/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model.behavior;

import java.util.Collection;
import java.util.Iterator;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.Type;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.AirportWorld;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior;
import org.boxed_economy.queuetheory.model.information.BoardingTicketInformation;
import org.boxed_economy.queuetheory.model.information.CallFromServerInformation;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.DestinationInformation;
import org.boxed_economy.queuetheory.model.information.PassengerInformation;

public class ServiceBehavior
extends AbstractServiceBehavior {
    private double serviceWork = 0.0;

    protected void callNextPassengerAction() {
        Relation toQueueManager = this.getAgent().getRelation(QueueTheoryModel.RELATIONTYPE_ToQueueManager);
        this.sendInformation(toQueueManager, QueueTheoryModel.BEHAVIORTYPE_ManageQueue, new CallFromServerInformation());
    }

    protected boolean isWaitingPassengerNotExists(Event e) {
        return ((PassengerInformation)this.getReceivedInformation()).getPassenger() == null;
    }

    protected boolean isWaitingPassengerExists(Event e) {
        return ((PassengerInformation)this.getReceivedInformation()).getPassenger() != null;
    }

    protected void startServiceAction() {
        DebugPrinter.println("<IN>-startServiceAction : " + this.getAgent().getType());
        PassengerInformation passengerInformation = (PassengerInformation)this.getReceivedInformation();
        Agent passenger = passengerInformation.getPassenger();
        this.getAgent().addRelation(QueueTheoryModel.RELATIONTYPE_ToServedPassenger, passenger);
        DebugPrinter.describe("\u5217\u306e\u5148\u982d\u306e" + passenger + "\u3092\u547c\u3073\u307e\u3059 : " + this.getAgent().getType());
        Relation toServedPassenger = this.getAgent().getRelation(QueueTheoryModel.RELATIONTYPE_ToServedPassenger);
        this.sendInformation(toServedPassenger, QueueTheoryModel.BEHAVIORTYPE_MoveAndWait, new CallFromServerInformation());
        DebugPrinter.describe("\u30b5\u30fc\u30d3\u30b9\u3092\u59cb\u3081\u307e\u3059 : " + this.getAgent().getType());
        this.serviceWork += this.getServiceWorkLength(passenger);
        DebugPrinter.println("<OUT>-startServiceAction : " + this.getAgent().getType());
    }

    protected boolean isNotServiceFinished(Event e) {
        return 0.0 < this.serviceWork;
    }

    protected boolean isServiceFinished(Event e) {
        return this.serviceWork <= 0.0;
    }

    protected void keepServicingAction() {
        DebugPrinter.println("<IN>-keepServicingAction : " + this.getAgent().getType());
        this.serviceWork -= 1.0;
        DebugPrinter.describe("\u6b8b\u308a\u30b5\u30fc\u30d3\u30b9\u91cf\u306f " + this.serviceWork);
        DebugPrinter.println("<OUT>-keepServicingAction : " + this.getAgent().getType());
    }

    protected void showNextDestinationAction() {
        DebugPrinter.println("<IN>-showNextServerAction : " + this.getAgent().getType());
        DebugPrinter.describe("\u30b5\u30fc\u30d3\u30b9\u304c\u7d42\u308f\u3063\u305f\u306e\u3067\u6b21\u306e\u884c\u304d\u5148\u3092\u6559\u3048\u307e\u3059 : " + this.getAgent().getType());
        DestinationInformation destination = new DestinationInformation(this.getDistance());
        Collection toQueueManagers = this.getAgent().getRelations(QueueTheoryModel.RELATIONTYPE_Route);
        Iterator i = toQueueManagers.iterator();
        while (i.hasNext()) {
            Agent nextQueueManager = ((Relation)i.next()).getTarget();
            destination.addNextQueueManager(nextQueueManager);
        }
        Relation toServedPassenger = this.getAgent().getRelation(QueueTheoryModel.RELATIONTYPE_ToServedPassenger);
        this.sendInformation(toServedPassenger, QueueTheoryModel.BEHAVIORTYPE_MoveAndWait, destination);
        this.getActiveChannel().close();
        this.getAgent().removeRelation(toServedPassenger);
        DebugPrinter.println("<OUT>-showNextServerAction : " + this.getAgent().getType());
    }

    protected int getDistance() {
        AirportWorld world = (AirportWorld)this.getWorld();
        AgentType agentType = this.getAgent().getType();
        if (agentType.equals((Type)QueueTheoryModel.AGENTTYPE_InformationDesk)) {
            RandomNumberGenerator random = this.getWorld().getRandomNumberGenerator();
            return random.generate(world.TRAVELTIME_FromInfoDeskToCounter_MAX - world.TRAVELTIME_FromInfoDeskToCounter_MIN + 1) + world.TRAVELTIME_FromInfoDeskToCounter_MIN;
        }
        if (agentType.equals((Type)QueueTheoryModel.AGENTTYPE_CheckInCounter)) {
            RandomNumberGenerator random = this.getWorld().getRandomNumberGenerator();
            return random.generate(world.TRAVELTIME_FromCounterToSecurityCheck_MAX - world.TRAVELTIME_FromCounterToSecurityCheck_MIN + 1) + world.TRAVELTIME_FromCounterToSecurityCheck_MIN;
        }
        if (agentType.equals((Type)QueueTheoryModel.AGENTTYPE_Gate)) {
            return 1;
        }
        throw new ModelException("Invalid AgentType : " + this.getAgent().getType().getName());
    }

    private double getServiceWorkLength(Agent passenger) {
        AirportWorld world = (AirportWorld)this.getWorld();
        AgentType agentType = this.getAgent().getType();
        RandomNumberGenerator random = this.getWorld().getRandomNumberGenerator();
        if (agentType.equals((Type)QueueTheoryModel.AGENTTYPE_InformationDesk)) {
            return this.getInformationDeskServiceTime();
        }
        if (agentType.equals((Type)QueueTheoryModel.AGENTTYPE_CheckInCounter)) {
            ((BoardingTicketInformation)passenger.getInformation((Information)QueueTheoryModel.INFORMATIONTYPE_BoardingTicket)).check();
            if (passenger.getQuantity(QueueTheoryModel.GOODSTYPE_Luggage).getValueAsDouble() > 0.0) {
                return random.generate(world.SERVICETIME_CounterWithLuggage_MAX - world.SERVICETIME_CounterWithLuggage_MIN + 1) + world.SERVICETIME_CounterWithLuggage_MIN;
            }
            return random.generate(world.SERVICETIME_CounterNoLuggage_MAX - world.SERVICETIME_CounterNoLuggage_MIN + 1) + world.SERVICETIME_CounterNoLuggage_MIN;
        }
        if (agentType.equals((Type)QueueTheoryModel.AGENTTYPE_Gate)) {
            return random.generate(world.SERVICETIME_SecurityCheck_MAX - world.SERVICETIME_SecurityCheck_MIN + 1) + world.SERVICETIME_SecurityCheck_MIN;
        }
        throw new ModelException("Invalid AgentType : " + this.getAgent().getType().getName());
    }

    private double getInformationDeskServiceTime() {
        RandomNumberGenerator random = this.getWorld().getRandomNumberGenerator();
        return -((AirportWorld)this.getWorld()).AVERAGE_InfomationDeskServiceTime * Math.log(random.generate());
    }

    protected void initialize() {
    }

    protected void terminate() {
    }
}

