/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.util.Collection;
import java.util.Iterator;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.Type;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.information.BoardingTicketInformation;
import org.boxed_economy.queuetheory.model.information.PassengerQueueInformation;

public class AirportQueueDataGetter {
    static /* synthetic */ Class class$0;

    public static String getPassengerCondition(World world) {
        StringBuffer condition = new StringBuffer();
        int numAllPassenger = AirportQueueDataGetter.getNumberOfAllPassenger(world);
        int numMovingPassenger = AirportQueueDataGetter.getNumberOfMovingPassenger(world);
        int numMovingPassenger_Economy = AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(world, "Economy class");
        int numMovingPassenger_Business = AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(world, "Bussiness class");
        int numMovingPassenger_First = AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(world, "First class");
        int numMovingPassenger_Gate = AirportQueueDataGetter.getNumberOfMovingPassengerToGate(world);
        int numServedPassenger = AirportQueueDataGetter.getNumberOfServedPassenger(world);
        int numQueuingPassenger = AirportQueueDataGetter.getNumberOfQueuingPassenger(world);
        int numQueuingPassenger_InformationDesk = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(world, QueueTheoryModel.AGENTTYPE_InformationDesk);
        int numQueuingPassenger_Economy = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(world, QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
        int numQueuingPassenger_Bussiness = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(world, QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
        int numQueuingPassenger_First = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(world, QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
        int numQueueingPassenger_Gate = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(world, QueueTheoryModel.AGENTTYPE_Gate);
        int numQueueingPassenger_Sink = AirportQueueDataGetter.getNumberOfQueuingPassenger_Sink(world);
        condition.append("----------\u4e57\u5ba2\u306e\u72b6\u614b----------");
        condition.append("\n");
        condition.append("\t\u5168\u4f53\t\t\t\t\t\t\t\t: " + numAllPassenger);
        condition.append("\n");
        condition.append("\t\t- \u79fb\u52d5\u4e2d\t\t\t\t\t: " + numMovingPassenger);
        condition.append("\n");
        condition.append("\t\t\t- Economy\t\t\t\t: " + numMovingPassenger_Economy);
        condition.append("\n");
        condition.append("\t\t\t- Business\t\t\t\t: " + numMovingPassenger_Business);
        condition.append("\n");
        condition.append("\t\t\t- First\t\t\t\t\t: " + numMovingPassenger_First);
        condition.append("\n");
        condition.append("\t\t\t- Gate\t\t\t\t\t: " + numMovingPassenger_Gate);
        condition.append("\n");
        condition.append("\t\t- \u30b5\u30fc\u30d3\u30b9\u53d7\u3051\u4e2d\t\t\t: " + numServedPassenger);
        condition.append("\n");
        condition.append("\t\t- \u4e26\u3073\u4e2d\t\t\t\t\t\t: " + numQueuingPassenger);
        condition.append("\n");
        condition.append("\t\t\t- InformationDesk\t: " + numQueuingPassenger_InformationDesk);
        condition.append("\n");
        condition.append("\t\t\t- Economy\t\t\t\t: " + numQueuingPassenger_Economy);
        condition.append("\n");
        condition.append("\t\t\t- Bussiness\t\t\t: " + numQueuingPassenger_Bussiness);
        condition.append("\n");
        condition.append("\t\t\t- First\t\t\t\t\t: " + numQueuingPassenger_First);
        condition.append("\n");
        condition.append("\t\t\t- Gate\t\t\t\t\t: " + numQueueingPassenger_Gate);
        condition.append("\n");
        condition.append("\t\t\t- Sink\t\t\t\t\t: " + numQueueingPassenger_Sink);
        condition.append("\n");
        condition.append("------------------------------");
        if (numAllPassenger != numMovingPassenger + numServedPassenger + numQueuingPassenger) {
            throw new ModelException("\u4e57\u5ba2\u306e\u4eba\u6570\u304c\u5408\u3044\u307e\u305b\u3093");
        }
        if (numMovingPassenger != numMovingPassenger_Economy + numMovingPassenger_Business + numMovingPassenger_First + numMovingPassenger_Gate) {
            throw new ModelException("\u79fb\u52d5\u3057\u3066\u3044\u308b\u4eba\u6570\u304c\u5408\u3044\u307e\u305b\u3093");
        }
        if (numQueuingPassenger != numQueuingPassenger_InformationDesk + numQueuingPassenger_Economy + numQueuingPassenger_Bussiness + numQueuingPassenger_First + numQueueingPassenger_Gate + numQueueingPassenger_Sink) {
            throw new ModelException("\u4e26\u3093\u3067\u3044\u308b\u4eba\u6570\u304c\u5408\u3044\u307e\u305b\u3093");
        }
        return condition.toString();
    }

    public static void printInitialCondition(World world) {
        int numSource = world.getAgents(QueueTheoryModel.AGENTTYPE_Source).size();
        int numInformationDesk = world.getAgents(QueueTheoryModel.AGENTTYPE_InformationDesk).size();
        int numCheckInCounter = world.getAgentsRecursively(QueueTheoryModel.AGENTTYPE_CheckInCounter).size();
        int numCounter_Economy = world.getAgents(QueueTheoryModel.AGENTTYPE_Counter_EconomyClass).size();
        int numCounter_Bussiness = world.getAgents(QueueTheoryModel.AGENTTYPE_Counter_BussinessClass).size();
        int numCounter_First = world.getAgents(QueueTheoryModel.AGENTTYPE_Counter_FirstClass).size();
        int numGate = world.getAgents(QueueTheoryModel.AGENTTYPE_Gate).size();
        int numSink = world.getAgents(QueueTheoryModel.AGENTTYPE_Sink).size();
        System.out.println("-----\u521d\u671f\u72b6\u614b-----");
        System.out.println("Source\t\t\t\t: " + numSource);
        System.out.println("InformationDesk\t: " + numInformationDesk);
        System.out.println("CheckInCounter\t: " + numCheckInCounter);
        System.out.println("\t- Economy\t\t: " + numCounter_Economy);
        System.out.println("\t- Bussiness\t: " + numCounter_Bussiness);
        System.out.println("\t- First\t\t\t: " + numCounter_First);
        System.out.println("Gate\t\t\t\t\t: " + numGate);
        System.out.println("Sink\t\t\t\t\t: " + numSink);
        System.out.println("------------------");
    }

    public static int getNumberOfMovingPassengerToGate(World world) {
        int total = 0;
        Collection passengers = world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
        Iterator i = passengers.iterator();
        while (i.hasNext()) {
            BoardingTicketInformation ticket;
            Agent passenger = (Agent)i.next();
            if (!passenger.getRelationTypes().contains(QueueTheoryModel.RELATIONTYPE_MoveTo) || !(ticket = (BoardingTicketInformation)passenger.getInformation((Information)QueueTheoryModel.INFORMATIONTYPE_BoardingTicket)).isChecked()) continue;
            ++total;
        }
        return total;
    }

    public static int getNumberOfMovingPassengerToEachCounter(World world, String ticketClass) {
        int total = 0;
        Collection passengers = world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
        Iterator i = passengers.iterator();
        while (i.hasNext()) {
            BoardingTicketInformation ticket;
            Agent passenger = (Agent)i.next();
            if (!passenger.getRelationTypes().contains(QueueTheoryModel.RELATIONTYPE_MoveTo) || (ticket = (BoardingTicketInformation)passenger.getInformation((Information)QueueTheoryModel.INFORMATIONTYPE_BoardingTicket)).isChecked() || !ticket.checkSeatClass(ticketClass)) continue;
            ++total;
        }
        return total;
    }

    public static int getNumberOfQueuingPassengerToEachServer(World world, AgentType agentType) {
        Agent queueManager = world.getAgent(agentType).getRelation(QueueTheoryModel.RELATIONTYPE_ToQueueManager).getTarget();
        PassengerQueueInformation queue = (PassengerQueueInformation)queueManager.getInformation((Information)QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
        return queue.size();
    }

    public static int getNumberOfQueuingPassenger_Sink(World world) {
        Agent sink = world.getAgent(QueueTheoryModel.AGENTTYPE_Sink);
        PassengerQueueInformation queue = (PassengerQueueInformation)sink.getInformation((Information)QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
        return queue.size();
    }

    public static int getNumberOfQueuingPassenger(World world) {
        int numQueuingPassenger = 0;
        Collection queueManagers = world.getAgents(QueueTheoryModel.AGENTTYPE_QueueManager);
        Iterator i = queueManagers.iterator();
        while (i.hasNext()) {
            PassengerQueueInformation queue;
            Agent queueManager = (Agent)i.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.boxed_economy.queuetheory.model.information.PassengerQueueInformation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((queue = (PassengerQueueInformation)queueManager.getInformation((Class)clazz)).size() <= 0) continue;
            numQueuingPassenger += queue.size();
        }
        Agent sink = world.getAgent(QueueTheoryModel.AGENTTYPE_Sink);
        PassengerQueueInformation queue = (PassengerQueueInformation)sink.getInformation((Information)QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
        return numQueuingPassenger += queue.size();
    }

    public static int getNumberOfServedPassenger(World world) {
        int numServedPassenger = 0;
        Collection servers = world.getAgentsRecursively(QueueTheoryModel.AGENTTYPE_Server);
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            Agent server = (Agent)i.next();
            if (server.getRelations(QueueTheoryModel.RELATIONTYPE_ToServedPassenger).isEmpty()) continue;
            ++numServedPassenger;
        }
        return numServedPassenger;
    }

    public static int getNumberOfAllPassenger(World world) {
        int numAllPassenger = world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger).size();
        return numAllPassenger;
    }

    public static int getNumberOfMovingPassenger(World world) {
        int numMovingPassenger = 0;
        Collection passengers = world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
        Iterator i = passengers.iterator();
        while (i.hasNext()) {
            Agent passenger = (Agent)i.next();
            if (passenger.getRelations(QueueTheoryModel.RELATIONTYPE_MoveTo).isEmpty()) continue;
            ++numMovingPassenger;
        }
        return numMovingPassenger;
    }

    public static int getNumberOfMovingPassengerToServer(AgentType serverType, World world) {
        int numMovingPassenger = 0;
        Collection passengers = world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
        Iterator i = passengers.iterator();
        while (i.hasNext()) {
            Agent queueManager;
            Agent passenger = (Agent)i.next();
            if (passenger.getRelations(QueueTheoryModel.RELATIONTYPE_MoveTo).isEmpty() || (queueManager = passenger.getRelation(QueueTheoryModel.RELATIONTYPE_MoveTo).getTarget()).getType().equals((Type)QueueTheoryModel.AGENTTYPE_Sink) || !queueManager.getRelation(QueueTheoryModel.RELATIONTYPE_ToServer).getTarget().getType().equals((Type)serverType)) continue;
            ++numMovingPassenger;
        }
        return numMovingPassenger;
    }

    public static int getNumberOfMovingPassengerToSink(World world) {
        int numMovingPassenger = 0;
        Collection passengers = world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
        Iterator i = passengers.iterator();
        while (i.hasNext()) {
            Agent queueManager;
            Agent passenger = (Agent)i.next();
            if (passenger.getRelations(QueueTheoryModel.RELATIONTYPE_MoveTo).isEmpty() || !(queueManager = passenger.getRelation(QueueTheoryModel.RELATIONTYPE_MoveTo).getTarget()).getType().equals((Type)QueueTheoryModel.AGENTTYPE_Sink)) continue;
            ++numMovingPassenger;
        }
        return numMovingPassenger;
    }
}

