/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.queuetheory.model.AirportWorld;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.presentation.AirportQueueDataGetter;
import org.boxed_economy.queuetheory.model.presentation.CsvWriter;
import org.boxed_economy.queuetheory.model.presentation.ServerCard;
import org.boxed_economy.queuetheory.model.presentation.SourceAndSinkCard;

public class AirportQueuePanel
extends JPanel {
    public static final int serverWidth = 120;
    public static final int serverHeight = 20;
    private World world = null;
    private CsvWriter csvWriter = new CsvWriter();
    static /* synthetic */ Class class$0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintComponent(Graphics g) {
        this.initializePanel(g);
        if (this.world != null) {
            Class<?> clazz = this.world.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.boxed_economy.queuetheory.model.AirportWorld");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz2 = class$0 = clazz3;
            }
            if (clazz.equals(clazz2)) {
                this.drawServerCards(g);
                return;
            }
        }
        this.warning(g);
    }

    private void warning(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(Color.black);
        g.drawString("\u9069\u5207\u306aWorld\u304c\u8aad\u307f\u8fbc\u307e\u308c\u3066\u3044\u307e\u305b\u3093", width / 2 - 100, height / 2);
    }

    public void setWorld(World world) {
        this.world = world;
    }

    private void initializePanel(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.white);
        g.setFont(new Font("System", 0, 11));
    }

    private void drawServerCards(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int infoDeskNum = ((AirportWorld)this.world).NUMBER_InformationDesk;
        int economyNum = ((AirportWorld)this.world).NUMBER_CheckInCounter_EconomyClass;
        int businessNum = ((AirportWorld)this.world).NUMBER_CheckInCounter_BusinessClass;
        int firstNum = ((AirportWorld)this.world).NUMBER_CheckInCounter_FirstClass;
        int gateNum = ((AirportWorld)this.world).NUMBER_SecurityCheck;
        int infoDeskQueueNum = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_InformationDesk);
        int economyQueueNum = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
        int businessQueueNum = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
        int firstQueueNum = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
        int gateQueueNum = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Gate);
        int movingToEconomy = AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(this.world, "Economy class");
        int movingToBusiness = AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(this.world, "Bussiness class");
        int movingToFirst = AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(this.world, "First class");
        int movingToGate = AirportQueueDataGetter.getNumberOfMovingPassengerToGate(this.world);
        SourceAndSinkCard source = new SourceAndSinkCard("Entrance", width / 40, height - 20 - height / 10 - businessNum * 3);
        SourceAndSinkCard sink = new SourceAndSinkCard("Gate", width * 39 / 40 - 120, economyNum * 3 + height / 10);
        ServerCard informationDesk = new ServerCard(infoDeskNum, "Information Desk", infoDeskQueueNum, width / 10, (height - 20) / 2);
        ServerCard economy = new ServerCard(economyNum, "Economy Counter", economyQueueNum, (width - 120) / 2, economyNum * 3 + height / 10);
        ServerCard business = new ServerCard(businessNum, "Business Counter", businessQueueNum, (width - 120) / 2, (height - 20) / 2);
        ServerCard first = new ServerCard(firstNum, "First Counter", firstQueueNum, (width - 120) / 2, height - 20 - height / 10 - businessNum * 3);
        ServerCard gate = new ServerCard(gateNum, "Security Check", gateQueueNum, width * 9 / 10 - 120, (height - 20) / 2);
        source.drawSourceLine(g, informationDesk.endX(), informationDesk.endY());
        sink.drawSinkLine(g, width, gate.beginX(), gate.beginY());
        AirportQueuePanel.drawLineWithArrow(g, informationDesk.beginX(), informationDesk.beginY(), economy.endX(), economy.endY());
        AirportQueuePanel.drawLineWithArrow(g, informationDesk.beginX(), informationDesk.beginY(), business.endX(), business.endY());
        AirportQueuePanel.drawLineWithArrow(g, informationDesk.beginX(), informationDesk.beginY(), first.endX(), first.endY());
        int gateEndX = (business.beginX() + gate.endX()) / 2;
        int gateEndY = gate.endY();
        g.drawLine(economy.beginX(), economy.beginY(), gateEndX, gateEndY);
        AirportQueuePanel.drawLineWithArrow(g, business.beginX(), business.beginY(), gate.endX(), gate.endY());
        g.drawLine(first.beginX(), first.beginY(), gateEndX, gateEndY);
        source.paintCard(g);
        sink.paintCard(g);
        informationDesk.paintServerCards(this, g);
        economy.paintServerCards(this, g);
        business.paintServerCards(this, g);
        first.paintServerCards(this, g);
        gate.paintServerCards(this, g);
        informationDesk.paintMovingPassenger(g, movingToEconomy, economy.endX(), economy.endY());
        informationDesk.paintMovingPassenger(g, movingToBusiness, business.endX(), business.endY());
        informationDesk.paintMovingPassenger(g, movingToFirst, first.endX(), first.endY());
        business.paintMovingPassenger(g, movingToGate, gate.endX(), gate.endY());
    }

    public void printCsv() {
        int infoQ = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_InformationDesk);
        int economyQ = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
        int businessQ = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
        int firstQ = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
        int gateQ = AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(this.world, QueueTheoryModel.AGENTTYPE_Gate);
        this.csvWriter.writeAveragePrice(infoQ, firstQ, businessQ, economyQ, gateQ);
    }

    public static void drawLineWithArrow(Graphics g, int beginX, int beginY, int endX, int endY) {
        double arrowSize = 10.0;
        double sharpness = 3.0;
        double hypotenuseLength = Math.sqrt(Math.pow(Math.abs(beginX - endX), 2.0) + Math.pow(Math.abs(beginY - endY), 2.0));
        double baseX = (double)endX - (double)(endX - beginX) * (arrowSize / hypotenuseLength);
        double baseY = (double)endY - (double)(endY - beginY) * (arrowSize / hypotenuseLength);
        double oneArrowX = baseX + (baseY - (double)endY) / sharpness;
        double oneArrowY = baseY - (baseX - (double)endX) / sharpness;
        double theOtherArrowX = baseX - (baseY - (double)endY) / sharpness;
        double theOtherArrowY = baseY + (baseX - (double)endX) / sharpness;
        g.drawLine(beginX, beginY, endX, endY);
        g.drawLine(endX, endY, (int)oneArrowX, (int)oneArrowY);
        g.drawLine(endX, endY, (int)theOtherArrowX, (int)theOtherArrowY);
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("AirportQueueViewer");
        jFrame.setSize(new Dimension(750, 300));
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)new AirportQueuePanel(), "Center");
        jFrame.setVisible(true);
    }
}

