/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class ImageProvider {
    private static ImageProvider instance;
    private Map imageTable = new HashMap();

    public static final ImageProvider getInstance() {
        if (instance == null) {
            instance = new ImageProvider();
        }
        return instance;
    }

    private ImageProvider() {
    }

    public Image getImage(String name) {
        return this.getImage(name, ClassLoader.getSystemClassLoader());
    }

    private Image getImage(String name, ClassLoader classLoader) {
        if (!this.imageTable.containsKey(name)) {
            try {
                URL url = this.createResourceURL(name, classLoader);
                Image image = this.loadImage(url);
                this.imageTable.put(name, image);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (Image)this.imageTable.get(name);
    }

    private URL createResourceURL(String name, ClassLoader classLoader) {
        URL url = classLoader.getResource(name);
        if (url == null) {
            throw new RuntimeException("Invalid resource name in createResourceURL() name=" + name);
        }
        return url;
    }

    private Image loadImage(URL url) throws Exception {
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        MediaTracker mt = new MediaTracker(new JPanel());
        mt.addImage(image, 0);
        mt.waitForAll();
        return image;
    }
}

