/**
 * AirportWorld.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model;

import java.util.Collection;
import java.util.Iterator;

import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.stepclock.StepClock;
import org
	.boxed_economy
	.queuetheory
	.model
	.information
	.BoardingTicketInformation;
import org
	.boxed_economy
	.queuetheory
	.model
	.information
	.PassengerQueueInformation;
import org.boxed_economy.queuetheory.model.presentation.AirportQueueDataGetter;

/**
 * @author tsuya
 * Created Date : 2003/10/14 15:02:02
 */
public class AirportWorld extends World {

	/********************************************************
	 * f̃p[^
	 ********************************************************/

	// T[o̐
	public int NUMBER_InformationDesk = 1;
	public int NUMBER_CheckInCounter_EconomyClass = 4;
	public int NUMBER_CheckInCounter_BusinessClass = 2;
	public int NUMBER_CheckInCounter_FirstClass = 1;
	public int NUMBER_SecurityCheck = 1;

	// q̓Ԃ̊Ԋu̕
	public double AVERAGE_ArrivalTime = 1.5;
	public double AVERAGE_InfomationDeskServiceTime = 1.0;

	// T[rX
	public int SERVICETIME_CounterWithLuggage_MIN = 5;
	public int SERVICETIME_CounterWithLuggage_MAX = 20;
	public int SERVICETIME_CounterNoLuggage_MIN = 2;
	public int SERVICETIME_CounterNoLuggage_MAX = 4;
	public int SERVICETIME_SecurityCheck_MIN = 1;
	public int SERVICETIME_SecurityCheck_MAX = 2;

	// ړ
	public int TRAVELTIME_FromInfoDeskToCounter_MIN = 5;
	public int TRAVELTIME_FromInfoDeskToCounter_MAX = 8;
	public int TRAVELTIME_FromCounterToSecurityCheck_MIN = 10;
	public int TRAVELTIME_FromCounterToSecurityCheck_MAX = 20;

	// q̔䗦
	public double RATIO_FirstClassPassenger = 0.1;
	public double RATIO_BusinessClassPassenger = 0.3;

	// ו̗L
	public double RATIO_LuggageFirstClass = 0.7;
	public double RATIO_LuggageBusinessClass = 0.3;
	public double RATIO_LuggageEconomyClass = 0.7;

	/********************************************************
	 * f̎s֘A
	 ********************************************************/

	public static void main(String[] args) {
		BESP.main(new String[] { "-model", AirportWorld.class.getName()});
//		BESP.main(args);
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeWorld()
	 */
	public void initializeWorld() {
		super.initializeWorld();
		this.setClock(new StepClock());
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.World#initializeAgents()
	 */
	public void initializeAgents() {
		super.initializeAgents();

		/*
		 * ҂s
		 */

		//҂s̐
		Agent queueManagerForInformationDesk = createQueueManager();

		Agent queueManagerForCheckInCounter_EconomyClass = createQueueManager();
		queueManagerForCheckInCounter_EconomyClass.putInformation(
			new BoardingTicketInformation(
				BoardingTicketInformation.CLASS_Economy));

		Agent queueManagerForCheckInCounter_BussinessClass =
			createQueueManager();
		queueManagerForCheckInCounter_BussinessClass.putInformation(
			new BoardingTicketInformation(
				BoardingTicketInformation.CLASS_Bussiness));

		Agent queueManagerForCheckInCounter_FirstClass = createQueueManager();
		queueManagerForCheckInCounter_FirstClass.putInformation(
			new BoardingTicketInformation(
				BoardingTicketInformation.CLASS_First));

		Agent queueManagerForGate = createQueueManager();

		//VNi҂s̈j̐
		Agent sink = createSink();

		/*
		 * \[X
		 */
		Agent bus = createSourceAndAddRelation();
		this.addRelationToSource(bus, queueManagerForInformationDesk);

		/*
		 * T[o[
		 */
		for (int i = 0; i < NUMBER_InformationDesk; i++) {
			Agent informationDesk =
				super.createAgent(QueueTheoryModel.AGENTTYPE_InformationDesk);
			informationDesk.addBehavior(
				QueueTheoryModel.BEHAVIORTYPE_InformationDeskService);

			this.addRelationToServer(
				informationDesk,
				queueManagerForInformationDesk,
				queueManagerForCheckInCounter_EconomyClass);
			this.addRelationToServer(
				informationDesk,
				queueManagerForInformationDesk,
				queueManagerForCheckInCounter_BussinessClass);
			this.addRelationToServer(
				informationDesk,
				queueManagerForInformationDesk,
				queueManagerForCheckInCounter_FirstClass);

		}
		for (int i = 0; i < NUMBER_CheckInCounter_EconomyClass; i++) {
			Agent checkInCounter_EconomyClass =
				super.createAgent(
					QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
			checkInCounter_EconomyClass.addBehavior(
				QueueTheoryModel.BEHAVIORTYPE_Service);

			this.addRelationToServer(
				checkInCounter_EconomyClass,
				queueManagerForCheckInCounter_EconomyClass,
				queueManagerForGate);
		}
		for (int i = 0; i < NUMBER_CheckInCounter_BusinessClass; i++) {
			Agent checkInCounter_BussinessClass =
				super.createAgent(
					QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
			checkInCounter_BussinessClass.addBehavior(
				QueueTheoryModel.BEHAVIORTYPE_Service);

			this.addRelationToServer(
				checkInCounter_BussinessClass,
				queueManagerForCheckInCounter_BussinessClass,
				queueManagerForGate);
		}
		for (int i = 0; i < NUMBER_CheckInCounter_FirstClass; i++) {
			Agent checkInCounter_FirstClass =
				super.createAgent(
					QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
			checkInCounter_FirstClass.addBehavior(
				QueueTheoryModel.BEHAVIORTYPE_Service);

			this.addRelationToServer(
				checkInCounter_FirstClass,
				queueManagerForCheckInCounter_FirstClass,
				queueManagerForGate);
		}
		for (int i = 0; i < NUMBER_SecurityCheck; i++) {
			Agent gate = super.createAgent(QueueTheoryModel.AGENTTYPE_Gate);
			gate.addBehavior(QueueTheoryModel.BEHAVIORTYPE_Service);

			this.addRelationToServer(gate, queueManagerForGate, sink);
		}

		//eXgp
		AirportQueueDataGetter.printInitialCondition(this);

		Collection c = this.getAgents(QueueTheoryModel.AGENTTYPE_QueueManager);
		for (Iterator i = c.iterator(); i.hasNext();) {
			Agent qm = (Agent) i.next();
			qm.getRelation(QueueTheoryModel.RELATIONTYPE_ToServer);
		}
	}

	/********************************************************
	 * G[WFg̐E֌Wt^֘A
	 ********************************************************/

	private void addRelationToServer(
		Agent server,
		Agent entryQueueManager,
		Agent exitQueueManager) {
		server.addRelation(
			QueueTheoryModel.RELATIONTYPE_ToQueueManager,
			entryQueueManager);
		server.addRelation(
			QueueTheoryModel.RELATIONTYPE_Route,
			exitQueueManager);
		entryQueueManager.addRelation(
			QueueTheoryModel.RELATIONTYPE_ToServer,
			server);
	}

	private Agent createQueueManager() {
		Agent queueManagerForInformationDesk =
			super.createAgent(QueueTheoryModel.AGENTTYPE_QueueManager);
		queueManagerForInformationDesk.addBehavior(
			QueueTheoryModel.BEHAVIORTYPE_ManageQueue);
		queueManagerForInformationDesk.putInformation(
			new PassengerQueueInformation());
		return queueManagerForInformationDesk;
	}

	private Agent createSink() {
		Agent sink = super.createAgent(QueueTheoryModel.AGENTTYPE_Sink);
		sink.addBehavior(QueueTheoryModel.BEHAVIORTYPE_ManageQueue);
		sink.putInformation(new PassengerQueueInformation());
		sink.addBehavior(QueueTheoryModel.BEHAVIORTYPE_Depart);
		return sink;
	}

	private Agent createSourceAndAddRelation() {
		Agent bus = super.createAgent(QueueTheoryModel.AGENTTYPE_Source);
		bus.addBehavior(QueueTheoryModel.BEHAVIORTYPE_DropPassengers);
		return bus;
	}

	private void addRelationToSource(Agent source, Agent queueManager) {
		source.addRelation(QueueTheoryModel.RELATIONTYPE_Route, queueManager);
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.World#getName()
	 */
	public String getName() {
		return "AirportQueue";
	}

	/********************************************************
	 * f̃p[^ւ̃Rg
	 ********************************************************/

	public String getSERVICETIME_CounterWithLuggage_MINComment(){
		return "וqɑ΂JE^[̍ŏT[rX";
	}
	public String getSERVICETIME_CounterWithLuggage_MAXComment(){
		return "וqɑ΂JE^[̍őT[rX";
	}
	public String getSERVICETIME_CounterNoLuggage_MINComment(){
		return "ו̂Ȃqɑ΂JE^[̍ŏT[rX";
	}
	public String getSERVICETIME_CounterNoLuggage_MAXComment(){
		return "ו̂Ȃqɑ΂JE^[̍őT[rX";
	}
	public String getSERVICETIME_SecurityCheck_MINComment(){
		return "ZLeB`FbNɂŏ̎";
	}
	public String getSERVICETIME_SecurityCheck_MAXComment(){
		return "ZLeB`FbNɂő̎";
	}

	public String getTRAVELTIME_FromInfoDeskToCounter_MINComment(){
		return "CtH[VfXNJE^[܂ł̍ŏs";
	}
	public String getTRAVELTIME_FromInfoDeskToCounter_MAXComment(){
		return "CtH[VfXNJE^[܂ł̍ős";
	}
	public String getTRAVELTIME_FromCounterToSecurityCheck_MINComment(){
		return "JE^[ZLeB`FbN܂ł̍ŏs";
	}
	public String getTRAVELTIME_FromCounterToSecurityCheck_MAXComment(){
		return "JE^[ZLeB`FbN܂ł̍ős";
	}


	public String getNUMBER_InformationDeskComment() {
		return "CtH[VfXN̐";
	}

	public String getNUMBER_CheckInCounter_EconomyClassComment() {
		return "GRm~[NX̃JE^[̐";
	}

	public String getNUMBER_CheckInCounter_BusinessClassComment() {
		return "rWlXNX̃JE^[̐";
	}

	public String getNUMBER_CheckInCounter_FirstClassComment() {
		return "t@[XgNX̃JE^[̐";
	}

	public String getNUMBER_SecurityCheckComment() {
		return "ZLeB`FbN̐";
	}
	
	public String getAVERAGE_ArrivalTimeComment(){
		return "q̓Ԋuij̕ϒl";
	}
	
	public String getAVERAGE_InfomationDeskServiceTimeComment(){
		return "CtH[VfXN̏qPlT[rXԂ̕ϒl";
	}

	public String getRATIO_FirstClassPassengerComment(){
		return "qt@[XgNXłm";
	}

	public String getRATIO_BusinessClassPassengerComment(){
		return "qrWlXNXłm";
	}
	
	public String getRATIO_LuggageFirstClassComment(){
		return "t@[XgNX̏qוĂm";
	}

	public String getRATIO_LuggageBusinessClassComment(){
		return "rWlXNX̏qוĂm";
	}

	public String getRATIO_LuggageEconomyClassComment(){
		return "GRm~[NX̏qוĂm";
	}

	/********************************************************
	 * f̃p[^̑
	 ********************************************************/

	/**
	 * Returns the nUMBER_CheckInCounter_BusinessClass.
	 * @return int
	 */
	public int getNUMBER_CheckInCounter_BusinessClass() {
		return NUMBER_CheckInCounter_BusinessClass;
	}

	/**
	 * Returns the nUMBER_CheckInCounter_EconomyClass.
	 * @return int
	 */
	public int getNUMBER_CheckInCounter_EconomyClass() {
		return NUMBER_CheckInCounter_EconomyClass;
	}

	/**
	 * Returns the nUMBER_CheckInCounter_FirstClass.
	 * @return int
	 */
	public int getNUMBER_CheckInCounter_FirstClass() {
		return NUMBER_CheckInCounter_FirstClass;
	}

	/**
	 * Returns the nUMBER_Gate.
	 * @return int
	 */
	public int getNUMBER_SecurityCheck() {
		return NUMBER_SecurityCheck;
	}

	/**
	 * Returns the nUMBER_InformationDesk.
	 * @return int
	 */
	public int getNUMBER_InformationDesk() {
		return NUMBER_InformationDesk;
	}

	/**
	 * Sets the nUMBER_CheckInCounter_BusinessClass.
	 * @param nUMBER_CheckInCounter_BusinessClass The nUMBER_CheckInCounter_BusinessClass to set
	 */
	public void setNUMBER_CheckInCounter_BusinessClass(int nUMBER_CheckInCounter_BusinessClass) {
		NUMBER_CheckInCounter_BusinessClass =
			nUMBER_CheckInCounter_BusinessClass;
	}

	/**
	 * Sets the nUMBER_CheckInCounter_EconomyClass.
	 * @param nUMBER_CheckInCounter_EconomyClass The nUMBER_CheckInCounter_EconomyClass to set
	 */
	public void setNUMBER_CheckInCounter_EconomyClass(int nUMBER_CheckInCounter_EconomyClass) {
		NUMBER_CheckInCounter_EconomyClass = nUMBER_CheckInCounter_EconomyClass;
	}

	/**
	 * Sets the nUMBER_CheckInCounter_FirstClass.
	 * @param nUMBER_CheckInCounter_FirstClass The nUMBER_CheckInCounter_FirstClass to set
	 */
	public void setNUMBER_CheckInCounter_FirstClass(int nUMBER_CheckInCounter_FirstClass) {
		NUMBER_CheckInCounter_FirstClass = nUMBER_CheckInCounter_FirstClass;
	}

	/**
	 * Sets the nUMBER_Gate.
	 * @param nUMBER_Gate The nUMBER_Gate to set
	 */
	public void setNUMBER_SecurityCheck(int nUMBER_Gate) {
		NUMBER_SecurityCheck = nUMBER_Gate;
	}

	/**
	 * Sets the nUMBER_InformationDesk.
	 * @param nUMBER_InformationDesk The nUMBER_InformationDesk to set
	 */
	public void setNUMBER_InformationDesk(int nUMBER_InformationDesk) {
		NUMBER_InformationDesk = nUMBER_InformationDesk;
	}

	/**
	 * Returns the aVERAGE_ArrivalTime.
	 * @return double
	 */
	public double getAVERAGE_ArrivalTime() {
		return AVERAGE_ArrivalTime;
	}

	/**
	 * Sets the aVERAGE_ArrivalTime.
	 * @param aVERAGE_ArrivalTime The aVERAGE_ArrivalTime to set
	 */
	public void setAVERAGE_ArrivalTime(double aVERAGE_ArrivalTime) {
		AVERAGE_ArrivalTime = aVERAGE_ArrivalTime;
	}

	/**
	 * Returns the aVERAGE_InfomationDeskServiceTime.
	 * @return double
	 */
	public double getAVERAGE_InfomationDeskServiceTime() {
		return AVERAGE_InfomationDeskServiceTime;
	}

	/**
	 * Returns the mAX_CheckInCounterServiceTimeNoLuggage.
	 * @return int
	 */
	public int getSERVICETIME_CounterNoLuggage_MAX() {
		return SERVICETIME_CounterNoLuggage_MAX;
	}

	/**
	 * Returns the mAX_CheckInCounterServiceTimeWithLuggage.
	 * @return int
	 */
	public int getSERVICETIME_CounterWithLuggage_MAX() {
		return SERVICETIME_CounterWithLuggage_MAX;
	}

	/**
	 * Returns the mAX_SecurityCheckTime.
	 * @return int
	 */
	public int getSERVICETIME_SecurityCheck_MAX() {
		return SERVICETIME_SecurityCheck_MAX;
	}

	/**
	 * Returns the mAX_TravelTimeFromCounterToSecurityCheck.
	 * @return int
	 */
	public int getTRAVELTIME_FromCounterToSecurityCheck_MAX() {
		return TRAVELTIME_FromCounterToSecurityCheck_MAX;
	}

	/**
	 * Returns the mAX_TravelTimeFromInfoDeskToCounter.
	 * @return int
	 */
	public int getTRAVELTIME_FromInfoDeskToCounter_MAX() {
		return TRAVELTIME_FromInfoDeskToCounter_MAX;
	}

	/**
	 * Returns the mIN_CheckInCounterServiceTimeNoLuggage.
	 * @return int
	 */
	public int getSERVICETIME_CounterNoLuggage_MIN() {
		return SERVICETIME_CounterNoLuggage_MIN;
	}

	/**
	 * Returns the mIN_CheckInCounterServiceTimeWithLuggage.
	 * @return int
	 */
	public int getSERVICETIME_CounterWithLuggage_MIN() {
		return SERVICETIME_CounterWithLuggage_MIN;
	}

	/**
	 * Returns the mIN_SecurityCheckTime.
	 * @return int
	 */
	public int getSERVICETIME_SecurityCheck_MIN() {
		return SERVICETIME_SecurityCheck_MIN;
	}

	/**
	 * Returns the mIN_TravelTimeFromCounterToSecurityCheck.
	 * @return int
	 */
	public int getTRAVELTIME_FromCounterToSecurityCheck_MIN() {
		return TRAVELTIME_FromCounterToSecurityCheck_MIN;
	}

	/**
	 * Returns the mIN_TravelTimeFromInfoDeskToCounter.
	 * @return int
	 */
	public int getTRAVELTIME_FromInfoDeskToCounter_MIN() {
		return TRAVELTIME_FromInfoDeskToCounter_MIN;
	}

	/**
	 * Sets the aVERAGE_InfomationDeskServiceTime.
	 * @param aVERAGE_InfomationDeskServiceTime The aVERAGE_InfomationDeskServiceTime to set
	 */
	public void setAVERAGE_InfomationDeskServiceTime(double aVERAGE_InfomationDeskServiceTime) {
		AVERAGE_InfomationDeskServiceTime = aVERAGE_InfomationDeskServiceTime;
	}

	/**
	 * Sets the mAX_CheckInCounterServiceTimeNoLuggage.
	 * @param mAX_CheckInCounterServiceTimeNoLuggage The mAX_CheckInCounterServiceTimeNoLuggage to set
	 */
	public void setSERVICETIME_CounterNoLuggage_MAX(int mAX_CheckInCounterServiceTimeNoLuggage) {
		SERVICETIME_CounterNoLuggage_MAX =
			mAX_CheckInCounterServiceTimeNoLuggage;
	}

	/**
	 * Sets the mAX_CheckInCounterServiceTimeWithLuggage.
	 * @param mAX_CheckInCounterServiceTimeWithLuggage The mAX_CheckInCounterServiceTimeWithLuggage to set
	 */
	public void setSERVICETIME_CounterWithLuggage_MAX(int mAX_CheckInCounterServiceTimeWithLuggage) {
		SERVICETIME_CounterWithLuggage_MAX =
			mAX_CheckInCounterServiceTimeWithLuggage;
	}

	/**
	 * Sets the mAX_SecurityCheckTime.
	 * @param mAX_SecurityCheckTime The mAX_SecurityCheckTime to set
	 */
	public void setSERVICETIME_SecurityCheck_MAX(int mAX_SecurityCheckTime) {
		SERVICETIME_SecurityCheck_MAX = mAX_SecurityCheckTime;
	}

	/**
	 * Sets the mAX_TravelTimeFromCounterToSecurityCheck.
	 * @param mAX_TravelTimeFromCounterToSecurityCheck The mAX_TravelTimeFromCounterToSecurityCheck to set
	 */
	public void setTRAVELTIME_FromCounterToSecurityCheck_MAX(int mAX_TravelTimeFromCounterToSecurityCheck) {
		TRAVELTIME_FromCounterToSecurityCheck_MAX =
			mAX_TravelTimeFromCounterToSecurityCheck;
	}

	/**
	 * Sets the mAX_TravelTimeFromInfoDeskToCounter.
	 * @param mAX_TravelTimeFromInfoDeskToCounter The mAX_TravelTimeFromInfoDeskToCounter to set
	 */
	public void setTRAVELTIME_FromInfoDeskToCounter_MAX(int mAX_TravelTimeFromInfoDeskToCounter) {
		TRAVELTIME_FromInfoDeskToCounter_MAX =
			mAX_TravelTimeFromInfoDeskToCounter;
	}

	/**
	 * Sets the mIN_CheckInCounterServiceTimeNoLuggage.
	 * @param mIN_CheckInCounterServiceTimeNoLuggage The mIN_CheckInCounterServiceTimeNoLuggage to set
	 */
	public void setSERVICETIME_CounterNoLuggage_MIN(int mIN_CheckInCounterServiceTimeNoLuggage) {
		SERVICETIME_CounterNoLuggage_MIN =
			mIN_CheckInCounterServiceTimeNoLuggage;
	}

	/**
	 * Sets the mIN_CheckInCounterServiceTimeWithLuggage.
	 * @param mIN_CheckInCounterServiceTimeWithLuggage The mIN_CheckInCounterServiceTimeWithLuggage to set
	 */
	public void setSERVICETIME_CounterWithLuggage_MIN(int mIN_CheckInCounterServiceTimeWithLuggage) {
		SERVICETIME_CounterWithLuggage_MIN =
			mIN_CheckInCounterServiceTimeWithLuggage;
	}

	/**
	 * Sets the mIN_SecurityCheckTime.
	 * @param mIN_SecurityCheckTime The mIN_SecurityCheckTime to set
	 */
	public void setSERVICETIME_SecurityCheck_MIN(int mIN_SecurityCheckTime) {
		SERVICETIME_SecurityCheck_MIN = mIN_SecurityCheckTime;
	}

	/**
	 * Sets the mIN_TravelTimeFromCounterToSecurityCheck.
	 * @param mIN_TravelTimeFromCounterToSecurityCheck The mIN_TravelTimeFromCounterToSecurityCheck to set
	 */
	public void setTRAVELTIME_FromCounterToSecurityCheck_MIN(int mIN_TravelTimeFromCounterToSecurityCheck) {
		TRAVELTIME_FromCounterToSecurityCheck_MIN =
			mIN_TravelTimeFromCounterToSecurityCheck;
	}

	/**
	 * Sets the mIN_TravelTimeFromInfoDeskToCounter.
	 * @param mIN_TravelTimeFromInfoDeskToCounter The mIN_TravelTimeFromInfoDeskToCounter to set
	 */
	public void setTRAVELTIME_FromInfoDeskToCounter_MIN(int mIN_TravelTimeFromInfoDeskToCounter) {
		TRAVELTIME_FromInfoDeskToCounter_MIN =
			mIN_TravelTimeFromInfoDeskToCounter;
	}

	/**
	 * Returns the rATIO_BusinessClassHasLuggage.
	 * @return double
	 */
	public double getRATIO_LuggageBusinessClass() {
		return RATIO_LuggageBusinessClass;
	}

	/**
	 * Returns the rATIO_BusinessClassPassenger.
	 * @return double
	 */
	public double getRATIO_BusinessClassPassenger() {
		return RATIO_BusinessClassPassenger;
	}

	/**
	 * Returns the rATIO_EconomyClassHasLuggage.
	 * @return double
	 */
	public double getRATIO_LuggageEconomyClass() {
		return RATIO_LuggageEconomyClass;
	}

	/**
	 * Returns the rATIO_FirstClassHasLuggage.
	 * @return double
	 */
	public double getRATIO_LuggageFirstClass() {
		return RATIO_LuggageFirstClass;
	}

	/**
	 * Returns the rATIO_FirstClassPassenger.
	 * @return double
	 */
	public double getRATIO_FirstClassPassenger() {
		return RATIO_FirstClassPassenger;
	}

	/**
	 * Sets the rATIO_BusinessClassHasLuggage.
	 * @param rATIO_BusinessClassHasLuggage The rATIO_BusinessClassHasLuggage to set
	 */
	public void setRATIO_LuggageBusinessClass(double rATIO_BusinessClassHasLuggage) {
		RATIO_LuggageBusinessClass = rATIO_BusinessClassHasLuggage;
	}

	/**
	 * Sets the rATIO_BusinessClassPassenger.
	 * @param rATIO_BusinessClassPassenger The rATIO_BusinessClassPassenger to set
	 */
	public void setRATIO_BusinessClassPassenger(double rATIO_BusinessClassPassenger) {
		RATIO_BusinessClassPassenger = rATIO_BusinessClassPassenger;
	}

	/**
	 * Sets the rATIO_EconomyClassHasLuggage.
	 * @param rATIO_EconomyClassHasLuggage The rATIO_EconomyClassHasLuggage to set
	 */
	public void setRATIO_LuggageEconomyClass(double rATIO_EconomyClassHasLuggage) {
		RATIO_LuggageEconomyClass = rATIO_EconomyClassHasLuggage;
	}

	/**
	 * Sets the rATIO_FirstClassHasLuggage.
	 * @param rATIO_FirstClassHasLuggage The rATIO_FirstClassHasLuggage to set
	 */
	public void setRATIO_LuggageFirstClass(double rATIO_FirstClassHasLuggage) {
		RATIO_LuggageFirstClass = rATIO_FirstClassHasLuggage;
	}

	/**
	 * Sets the rATIO_FirstClassPassenger.
	 * @param rATIO_FirstClassPassenger The rATIO_FirstClassPassenger to set
	 */
	public void setRATIO_FirstClassPassenger(double rATIO_FirstClassPassenger) {
		RATIO_FirstClassPassenger = rATIO_FirstClassPassenger;
	}

}
