/**
 * QueueTheoryModel.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model;

import org.boxed_economy.besp.container.*;
import org.boxed_economy.besp.model.*;
import org.boxed_economy.besp.model.fmfw.*;

/**
 * @author tsuya
 * Created Date : 2003/10/14 15:01:30
 */
public class QueueTheoryModel implements BESPPlugin {

	public static AgentType AGENTTYPE_Passenger;
	public static AgentType AGENTTYPE_Server;
	public static AgentType AGENTTYPE_QueueManager;
	public static AgentType AGENTTYPE_Source;
	public static AgentType AGENTTYPE_Sink;
	public static AgentType AGENTTYPE_InformationDesk;
	public static AgentType AGENTTYPE_CheckInCounter;
	public static AgentType AGENTTYPE_Gate;
	public static AgentType AGENTTYPE_Counter_EconomyClass;
	public static AgentType AGENTTYPE_Counter_BussinessClass;
	public static AgentType AGENTTYPE_Counter_FirstClass;
	public static GoodsType GOODSTYPE_Luggage;
	public static RelationType RELATIONTYPE_Route;
	public static RelationType RELATIONTYPE_ToServedPassenger;
	public static RelationType RELATIONTYPE_MoveTo;
	public static RelationType RELATIONTYPE_ToQueueManager;
	public static RelationType RELATIONTYPE_ToServer;
	public static BehaviorType BEHAVIORTYPE_DropPassengers;
	public static BehaviorType BEHAVIORTYPE_MoveAndWait;
	public static BehaviorType BEHAVIORTYPE_ManageQueue;
	public static BehaviorType BEHAVIORTYPE_Service;
	public static BehaviorType BEHAVIORTYPE_Depart;
	public static BehaviorType BEHAVIORTYPE_InformationDeskService;
	public static InformationType INFORMATIONTYPE_Destination;
	public static InformationType INFORMATIONTYPE_CallFromServer;
	public static InformationType INFORMATIONTYPE_Passenger;
	public static InformationType INFORMATIONTYPE_PassengerQueue;
	public static InformationType INFORMATIONTYPE_BoardingTicket;

	/** 
	* This method will be modified automatically by Type Editor 
	*/
	public static void initializePlugin(BESPContainer container) {
		installTypes(container);
		initializeTypes(container);
	}

	/** 
	* This method will be modified automatically by Type Editor 
	*/
	private static void installTypes(BESPContainer container) {
		//Get the model container  
		ModelContainer modelContainer = container.getModelContainer();

		AGENTTYPE_Passenger = modelContainer.installAgentType("Passenger");
		AGENTTYPE_Server = modelContainer.installAgentType("Server");
		AGENTTYPE_QueueManager =
			modelContainer.installAgentType("QueueManager");
		AGENTTYPE_Source = modelContainer.installAgentType("Source");
		AGENTTYPE_Sink = modelContainer.installAgentType("Sink");
		AGENTTYPE_InformationDesk =
			modelContainer.installAgentType("InformationDesk");
		AGENTTYPE_CheckInCounter =
			modelContainer.installAgentType("CheckInCounter");
		AGENTTYPE_Gate = modelContainer.installAgentType("Gate");
		AGENTTYPE_Counter_EconomyClass =
			modelContainer.installAgentType("Counter_EconomyClass");
		AGENTTYPE_Counter_BussinessClass =
			modelContainer.installAgentType("Counter_BussinessClass");
		AGENTTYPE_Counter_FirstClass =
			modelContainer.installAgentType("Counter_FirstClass");
		GOODSTYPE_Luggage = modelContainer.installGoodsType("Luggage");
		RELATIONTYPE_Route = modelContainer.installRelationType("Route");
		RELATIONTYPE_ToServedPassenger =
			modelContainer.installRelationType("ToServedPassenger");
		RELATIONTYPE_MoveTo = modelContainer.installRelationType("MoveTo");
		RELATIONTYPE_ToQueueManager =
			modelContainer.installRelationType("ToQueueManager");
		RELATIONTYPE_ToServer = modelContainer.installRelationType("ToServer");
		BEHAVIORTYPE_DropPassengers =
			modelContainer.installBehaviorType(
				"org.boxed_economy.queuetheory.model.behavior.DropPassengersBehavior");
		BEHAVIORTYPE_MoveAndWait =
			modelContainer.installBehaviorType(
				"org.boxed_economy.queuetheory.model.behavior.MoveAndWaitBehavior");
		BEHAVIORTYPE_ManageQueue =
			modelContainer.installBehaviorType(
				"org.boxed_economy.queuetheory.model.behavior.ManageQueueBehavior");
		BEHAVIORTYPE_Service =
			modelContainer.installBehaviorType(
				"org.boxed_economy.queuetheory.model.behavior.ServiceBehavior");
		BEHAVIORTYPE_Depart =
			modelContainer.installBehaviorType(
				"org.boxed_economy.queuetheory.model.behavior.DepartBehavior");
		BEHAVIORTYPE_InformationDeskService =
			modelContainer.installBehaviorType(
				"org.boxed_economy.queuetheory.model.behavior.InformationDeskServiceBehavior");
		INFORMATIONTYPE_Destination =
			modelContainer.installInformationType(
				"org.boxed_economy.queuetheory.model.information.DestinationInformation");
		INFORMATIONTYPE_CallFromServer =
			modelContainer.installInformationType(
				"org.boxed_economy.queuetheory.model.information.CallFromServerInformation");
		INFORMATIONTYPE_Passenger =
			modelContainer.installInformationType(
				"org.boxed_economy.queuetheory.model.information.PassengerInformation");
		INFORMATIONTYPE_PassengerQueue =
			modelContainer.installInformationType(
				"org.boxed_economy.queuetheory.model.information.PassengerQueueInformation");
		INFORMATIONTYPE_BoardingTicket =
			modelContainer.installInformationType(
				"org.boxed_economy.queuetheory.model.information.BoardingTicketInformation");
	}

	private static void initializeTypes(BESPContainer container) {
		ModelContainer modelContainer = container.getModelContainer();

		modelContainer.setPriority(AGENTTYPE_Source, 4444);
		modelContainer.setPriority(AGENTTYPE_Passenger, 333);
		modelContainer.setPriority(AGENTTYPE_Server, 22);
		modelContainer.setPriority(AGENTTYPE_Sink, 1);

		AGENTTYPE_Server.addChild(AGENTTYPE_InformationDesk);
		AGENTTYPE_Server.addChild(AGENTTYPE_CheckInCounter);
		AGENTTYPE_Server.addChild(AGENTTYPE_Gate);

		AGENTTYPE_QueueManager.addChild(AGENTTYPE_Sink);

		AGENTTYPE_CheckInCounter.addChild(AGENTTYPE_Counter_EconomyClass);
		AGENTTYPE_CheckInCounter.addChild(AGENTTYPE_Counter_BussinessClass);
		AGENTTYPE_CheckInCounter.addChild(AGENTTYPE_Counter_FirstClass);
	}
}
