/**
 * AbstractDepartBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractDepartBehavior
*/
public abstract class AbstractDepartBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitForDepartureTime =
			factory.createCompositeState("WaitForDepartureTime");

		//actions
		Action departAction = new Action() {
			public void doAction() {
				departAction();
			}
			public String toString() {
				return "departAction";
			}
		};
		Action waitAction = new Action() {
			public void doAction() {
				waitAction();
			}
			public String toString() {
				return "waitAction";
			}
		};

		//guard-conditions
		GuardCondition isNotDepartureTime = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isNotDepartureTime(e);
			}
		};
		GuardCondition isDepartureTimeComing = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isDepartureTimeComing(e);
			}
		};

		//transitions
		Transition transitionInitialStateToWaitForDepartureTime =
			factory.createTransition();
		Transition transitionWaitForDepartureTimeToWaitForDepartureTime =
			factory.createTransition();
		Transition transitionWaitForDepartureTimeToWaitForDepartureTime1 =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitForDepartureTime);

		//transitions setting
		transitionWaitForDepartureTimeToWaitForDepartureTime.setEvent(
			TimeEvent.class);
		transitionWaitForDepartureTimeToWaitForDepartureTime.setGuardCondition(
			isNotDepartureTime);
		transitionWaitForDepartureTimeToWaitForDepartureTime.addAction(
			waitAction);
		transitionWaitForDepartureTimeToWaitForDepartureTime1.setEvent(
			TimeEvent.class);
		transitionWaitForDepartureTimeToWaitForDepartureTime1
			.setGuardCondition(
			isDepartureTimeComing);
		transitionWaitForDepartureTimeToWaitForDepartureTime1.addAction(
			departAction);

		//connection of transitions
		transitionInitialStateToWaitForDepartureTime.setSourceState(
			initialState);
		transitionInitialStateToWaitForDepartureTime.setTargetState(
			waitForDepartureTime);
		transitionWaitForDepartureTimeToWaitForDepartureTime.setSourceState(
			waitForDepartureTime);
		transitionWaitForDepartureTimeToWaitForDepartureTime.setTargetState(
			waitForDepartureTime);
		transitionWaitForDepartureTimeToWaitForDepartureTime1.setSourceState(
			waitForDepartureTime);
		transitionWaitForDepartureTimeToWaitForDepartureTime1.setTargetState(
			waitForDepartureTime);

	}

	/**
	*departAction
	*/
	protected abstract void departAction();
	/**
	*waitAction
	*/
	protected abstract void waitAction();
	/**
	*isNotDepartureTime
	*/
	protected abstract boolean isNotDepartureTime(Event e);
	/**
	*isDepartureTimeComing
	*/
	protected abstract boolean isDepartureTimeComing(Event e);
}
