/**
 * AbstractDropPassengersBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractDropPassengersBehavior
*/
public abstract class AbstractDropPassengersBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState drivingToAirport =
			factory.createCompositeState("DrivingToAirport");

		//actions
		Action keepDrivingAction = new Action() {
			public void doAction() {
				keepDrivingAction();
			}
			public String toString() {
				return "keepDrivingAction";
			}
		};
		Action dropPassengersAction = new Action() {
			public void doAction() {
				dropPassengersAction();
			}
			public String toString() {
				return "dropPassengersAction";
			}
		};

		//guard-conditions
		GuardCondition isArrived = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isArrived(e);
			}
		};
		GuardCondition isNotArrived = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isNotArrived(e);
			}
		};

		//transitions
		Transition transitionInitialStateToDrivingToAirport =
			factory.createTransition();
		Transition transitionDrivingToAirportToDrivingToAirport =
			factory.createTransition();
		Transition transitionDrivingToAirportToDrivingToAirport1 =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(drivingToAirport);

		//transitions setting
		transitionDrivingToAirportToDrivingToAirport.setGuardCondition(
			isArrived);
		transitionDrivingToAirportToDrivingToAirport.addAction(
			dropPassengersAction);
		transitionDrivingToAirportToDrivingToAirport1.setEvent(TimeEvent.class);
		transitionDrivingToAirportToDrivingToAirport1.setGuardCondition(
			isNotArrived);
		transitionDrivingToAirportToDrivingToAirport1.addAction(
			keepDrivingAction);

		//connection of transitions
		transitionInitialStateToDrivingToAirport.setSourceState(initialState);
		transitionInitialStateToDrivingToAirport.setTargetState(
			drivingToAirport);
		transitionDrivingToAirportToDrivingToAirport.setSourceState(
			drivingToAirport);
		transitionDrivingToAirportToDrivingToAirport.setTargetState(
			drivingToAirport);
		transitionDrivingToAirportToDrivingToAirport1.setSourceState(
			drivingToAirport);
		transitionDrivingToAirportToDrivingToAirport1.setTargetState(
			drivingToAirport);

	}

	/**
	*keepDrivingAction
	*/
	protected abstract void keepDrivingAction();
	/**
	*dropPassengersAction
	*/
	protected abstract void dropPassengersAction();
	/**
	*isArrived
	*/
	protected abstract boolean isArrived(Event e);
	/**
	*isNotArrived
	*/
	protected abstract boolean isNotArrived(Event e);
}
