/**
 * AbstractManageQueueBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractManageQueueBehavior
*/
public abstract class AbstractManageQueueBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitForChannel =
			factory.createCompositeState("WaitForChannel");

		//actions
		Action showNextPassengerAction = new Action() {
			public void doAction() {
				showNextPassengerAction();
			}
			public String toString() {
				return "showNextPassengerAction";
			}
		};
		Action addNewPassengerToQueueAction = new Action() {
			public void doAction() {
				addNewPassengerToQueueAction();
			}
			public String toString() {
				return "addNewPassengerToQueueAction";
			}
		};

		//guard-conditions
		GuardCondition isPassengerInformationReceived = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isPassengerInformationReceived(e);
			}
		};
		GuardCondition isCallFromServer = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isCallFromServer(e);
			}
		};

		//transitions
		Transition transitionWaitForChannelToWaitForChannel =
			factory.createTransition();
		Transition transitionWaitForChannelToWaitForChannel1 =
			factory.createTransition();
		Transition transitionInitialStateToWaitForChannel =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitForChannel);

		//transitions setting
		transitionWaitForChannelToWaitForChannel.setEvent(ChannelEvent.class);
		transitionWaitForChannelToWaitForChannel.setGuardCondition(
			isCallFromServer);
		transitionWaitForChannelToWaitForChannel.addAction(
			showNextPassengerAction);
		transitionWaitForChannelToWaitForChannel1.setEvent(ChannelEvent.class);
		transitionWaitForChannelToWaitForChannel1.setGuardCondition(
			isPassengerInformationReceived);
		transitionWaitForChannelToWaitForChannel1.addAction(
			addNewPassengerToQueueAction);

		//connection of transitions
		transitionWaitForChannelToWaitForChannel.setSourceState(waitForChannel);
		transitionWaitForChannelToWaitForChannel.setTargetState(waitForChannel);
		transitionWaitForChannelToWaitForChannel1.setSourceState(
			waitForChannel);
		transitionWaitForChannelToWaitForChannel1.setTargetState(
			waitForChannel);
		transitionInitialStateToWaitForChannel.setSourceState(initialState);
		transitionInitialStateToWaitForChannel.setTargetState(waitForChannel);

	}

	/**
	*showNextPassengerAction
	*/
	protected abstract void showNextPassengerAction();
	/**
	*addNewPassengerToQueueAction
	*/
	protected abstract void addNewPassengerToQueueAction();
	/**
	*isPassengerInformationReceived
	*/
	protected abstract boolean isPassengerInformationReceived(Event e);
	/**
	*isCallFromServer
	*/
	protected abstract boolean isCallFromServer(Event e);
}
