/**
 * AbstractMoveAndWaitBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractMoveAndWaitBehavior
*/
public abstract class AbstractMoveAndWaitBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState serve = factory.createCompositeState("Serve");
		CompositeState move = factory.createCompositeState("Move");
		CompositeState waitForService =
			factory.createCompositeState("WaitForService");

		//actions
		Action chooseQueueAction = new Action() {
			public void doAction() {
				chooseQueueAction();
			}
			public String toString() {
				return "chooseQueueAction";
			}
		};
		Action beginMovingAction = new Action() {
			public void doAction() {
				beginMovingAction();
			}
			public String toString() {
				return "beginMovingAction";
			}
		};
		Action serveAction = new Action() {
			public void doAction() {
				serveAction();
			}
			public String toString() {
				return "serveAction";
			}
		};
		Action keepMovingAction = new Action() {
			public void doAction() {
				keepMovingAction();
			}
			public String toString() {
				return "keepMovingAction";
			}
		};

		//guard-conditions
		GuardCondition isCallFromServerReceived = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isCallFromServerReceived(e);
			}
		};
		GuardCondition isArrivedAtQueue = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isArrivedAtQueue(e);
			}
		};
		GuardCondition isDestinationReceived = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isDestinationReceived(e);
			}
		};
		GuardCondition isNotArrivedAtQueue = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isNotArrivedAtQueue(e);
			}
		};

		//transitions
		Transition transitionServeToMove = factory.createTransition();
		Transition transitionMoveToMove = factory.createTransition();
		Transition transitionWaitForServiceToServe = factory.createTransition();
		Transition transitionInitialStateToServe = factory.createTransition();
		Transition transitionMoveToWaitForService = factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(serve);
		this.addState(move);
		this.addState(waitForService);

		//transitions setting
		transitionServeToMove.setEvent(ChannelEvent.class);
		transitionServeToMove.setGuardCondition(isDestinationReceived);
		transitionServeToMove.addAction(beginMovingAction);
		transitionMoveToMove.setEvent(TimeEvent.class);
		transitionMoveToMove.setGuardCondition(isNotArrivedAtQueue);
		transitionMoveToMove.addAction(keepMovingAction);
		transitionWaitForServiceToServe.setEvent(ChannelEvent.class);
		transitionWaitForServiceToServe.setGuardCondition(
			isCallFromServerReceived);
		transitionWaitForServiceToServe.addAction(serveAction);
		transitionMoveToWaitForService.setGuardCondition(isArrivedAtQueue);
		transitionMoveToWaitForService.addAction(chooseQueueAction);

		//connection of transitions
		transitionServeToMove.setSourceState(serve);
		transitionServeToMove.setTargetState(move);
		transitionMoveToMove.setSourceState(move);
		transitionMoveToMove.setTargetState(move);
		transitionWaitForServiceToServe.setSourceState(waitForService);
		transitionWaitForServiceToServe.setTargetState(serve);
		transitionInitialStateToServe.setSourceState(initialState);
		transitionInitialStateToServe.setTargetState(serve);
		transitionMoveToWaitForService.setSourceState(move);
		transitionMoveToWaitForService.setTargetState(waitForService);

	}

	/**
	*chooseQueueAction
	*/
	protected abstract void chooseQueueAction();
	/**
	*beginMovingAction
	*/
	protected abstract void beginMovingAction();
	/**
	*serveAction
	*/
	protected abstract void serveAction();
	/**
	*keepMovingAction
	*/
	protected abstract void keepMovingAction();
	/**
	*isCallFromServerReceived
	*/
	protected abstract boolean isCallFromServerReceived(Event e);
	/**
	*isArrivedAtQueue
	*/
	protected abstract boolean isArrivedAtQueue(Event e);
	/**
	*isDestinationReceived
	*/
	protected abstract boolean isDestinationReceived(Event e);
	/**
	*isNotArrivedAtQueue
	*/
	protected abstract boolean isNotArrivedAtQueue(Event e);
}
