/**
 * AbstractServiceBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior;

import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Action;
import org.boxed_economy.besp.model.fmfw.behavior.CompositeState;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.GuardCondition;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory;
import org.boxed_economy.besp.model.fmfw.behavior.Transition;

/**
* AbstractServiceBehavior
*/
public abstract class AbstractServiceBehavior extends AbstractBehavior {

	/**
	* This method automatically generated from AbstractBehavior Builder
	* Don't touch by hand
	*/
	protected void initializeStateMachine() {
		//factory
		StateMachineFactory factory = this.getStateMachine();

		//states
		State initialState = factory.createInitialState();
		CompositeState waitForPassenger =
			factory.createCompositeState("WaitForPassenger");
		CompositeState service = factory.createCompositeState("Service");
		CompositeState newState = factory.createCompositeState("NewState");

		//actions
		Action showNextDestinationAction = new Action() {
			public void doAction() {
				showNextDestinationAction();
			}
			public String toString() {
				return "showNextDestinationAction";
			}
		};
		Action startServiceAction = new Action() {
			public void doAction() {
				startServiceAction();
			}
			public String toString() {
				return "startServiceAction";
			}
		};
		Action keepServicingAction = new Action() {
			public void doAction() {
				keepServicingAction();
			}
			public String toString() {
				return "keepServicingAction";
			}
		};
		Action callNextPassengerAction = new Action() {
			public void doAction() {
				callNextPassengerAction();
			}
			public String toString() {
				return "callNextPassengerAction";
			}
		};

		//guard-conditions
		GuardCondition isWaitingPassengerNotExists = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isWaitingPassengerNotExists(e);
			}
		};
		GuardCondition isServiceFinished = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isServiceFinished(e);
			}
		};
		GuardCondition isWaitingPassengerExists = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isWaitingPassengerExists(e);
			}
		};
		GuardCondition isNotServiceFinished = new GuardCondition() {
			public boolean isMatched(Event e) {
				return isNotServiceFinished(e);
			}
		};

		//transitions
		Transition transitionServiceToService = factory.createTransition();
		Transition transitionServiceToNewState = factory.createTransition();
		Transition transitionInitialStateToWaitForPassenger =
			factory.createTransition();
		Transition transitionNewStateToWaitForPassenger =
			factory.createTransition();
		Transition transitionNewStateToService = factory.createTransition();
		Transition transitionWaitForPassengerToNewState =
			factory.createTransition();

		//states setting

		//structure of states
		this.setInitialState(initialState);
		this.addState(waitForPassenger);
		this.addState(service);
		this.addState(newState);

		//transitions setting
		transitionServiceToService.setEvent(TimeEvent.class);
		transitionServiceToService.setGuardCondition(isNotServiceFinished);
		transitionServiceToService.addAction(keepServicingAction);
		transitionServiceToNewState.setGuardCondition(isServiceFinished);
		transitionServiceToNewState.addAction(showNextDestinationAction);
		transitionServiceToNewState.addAction(callNextPassengerAction);
		transitionNewStateToWaitForPassenger.setGuardCondition(
			isWaitingPassengerNotExists);
		transitionNewStateToService.setGuardCondition(isWaitingPassengerExists);
		transitionNewStateToService.addAction(startServiceAction);
		transitionWaitForPassengerToNewState.setEvent(TimeEvent.class);
		transitionWaitForPassengerToNewState.addAction(callNextPassengerAction);

		//connection of transitions
		transitionServiceToService.setSourceState(service);
		transitionServiceToService.setTargetState(service);
		transitionServiceToNewState.setSourceState(service);
		transitionServiceToNewState.setTargetState(newState);
		transitionInitialStateToWaitForPassenger.setSourceState(initialState);
		transitionInitialStateToWaitForPassenger.setTargetState(
			waitForPassenger);
		transitionNewStateToWaitForPassenger.setSourceState(newState);
		transitionNewStateToWaitForPassenger.setTargetState(waitForPassenger);
		transitionNewStateToService.setSourceState(newState);
		transitionNewStateToService.setTargetState(service);
		transitionWaitForPassengerToNewState.setSourceState(waitForPassenger);
		transitionWaitForPassengerToNewState.setTargetState(newState);

	}

	/**
	*showNextDestinationAction
	*/
	protected abstract void showNextDestinationAction();
	/**
	*startServiceAction
	*/
	protected abstract void startServiceAction();
	/**
	*keepServicingAction
	*/
	protected abstract void keepServicingAction();
	/**
	*callNextPassengerAction
	*/
	protected abstract void callNextPassengerAction();
	/**
	*isWaitingPassengerNotExists
	*/
	protected abstract boolean isWaitingPassengerNotExists(Event e);
	/**
	*isServiceFinished
	*/
	protected abstract boolean isServiceFinished(Event e);
	/**
	*isWaitingPassengerExists
	*/
	protected abstract boolean isWaitingPassengerExists(Event e);
	/**
	*isNotServiceFinished
	*/
	protected abstract boolean isNotServiceFinished(Event e);
}
