/**
 * DepartBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.PassengerQueueInformation;

/**
 * @author tsuya
 * Created Date : 2003/10/14 16:54:40
 */
public class DepartBehavior extends AbstractDepartBehavior {

	private int timeLeft = 0;

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDepartBehavior#isNotDepartureTime(Event)
	 */
	protected boolean isNotDepartureTime(Event e) {
		return this.timeLeft > 0;
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDepartBehavior#waitAction()
	 */
	protected void waitAction() {
		DebugPrinter.println("<IN>-waitAction : " + this.getAgent().getType());
		DebugPrinter.describe(
			"oԂ܂őҋ@ł ... c莞Ԃ"
				+ this.timeLeft
				+ " : "
				+ this.getAgent().getType());

		this.timeLeft--;

		DebugPrinter.println("<OUT>-waitAction : " + this.getAgent().getType());

		//eXgp
		//System.out.println(AirportQueueDataGetter.getPassengerCondition(this.getWorld()));
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDepartBehavior#isDepartureTimeComing(Event)
	 */
	protected boolean isDepartureTimeComing(Event e) {
		return this.timeLeft == 0;
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDepartBehavior#departAction()
	 */
	protected void departAction() {
		DebugPrinter.println(
			"<IN>-departAction : " + this.getAgent().getType());

		//҂sQ
		PassengerQueueInformation queue =
			(PassengerQueueInformation) this.getAgent().getInformation(
				QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);

		DebugPrinter.describe(
			"o܂ ... q "
				+ queue.size()
				+ " : "
				+ this.getAgent().getType());

		//҂sɂAĂqSĂV~[V폜
		while (0 < queue.size()) {
			Agent passenger = queue.removeFirstPassenger();
			this.getWorld().destroyAgent(passenger);
			System.out.println("폜܂");
		}
		this.timeLeft = 4;

		DebugPrinter.println(
			"<OUT>-departAction : " + this.getAgent().getType());

		//eXgp
		//System.out.println(AirportQueueDataGetter.getPassengerCondition(this.getWorld()));
	}

	/***********************************************
	 * Ȃ\bh
	 ***********************************************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

}
