/**
 * DropPassengersBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import java.util.Collection;
import java.util.Iterator;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.AirportWorld;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org
	.boxed_economy
	.queuetheory
	.model
	.information
	.BoardingTicketInformation;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.DestinationInformation;

/**
 * \[X̍słi`ւ̃WoX̍sƍlĂj
 * Ԋuŋ`ɓAq~낵܂
 * @author tsuya
 * Created Date : 2003/10/14 15:06:50
 */
public class DropPassengersBehavior extends AbstractDropPassengersBehavior {

	//	private int slantRangeToAirport = 1;
	private double timeRange = 0.0;

	/**
	 * ǂ̔
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDropPassengersBehavior#isArrived(Event)
	 */
	protected boolean isArrived(Event e) {
		//		return this.slantRangeToAirport == 0;
		return this.timeRange < 0.0;
	}

	/**
	 * ܂ĂȂǂ̔
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDropPassengersBehavior#isNotArrived(Event)
	 */
	protected boolean isNotArrived(Event e) {
		//		return this.slantRangeToAirport > 0;
		return 0.0 <= this.timeRange;
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDropPassengersBehavior#dropPassengersAction()
	 */
	protected void dropPassengersAction() {
		DebugPrinter.println(
			"<IN>-dropPassengersAction : " + this.getAgent().getType());
		DebugPrinter.describe("q~낵܂ : " + this.getAgent().getType());

		while (this.timeRange < 0.0) {
			//q𐶐܂
			Agent newPassenger = this.createPassenger();
			//֌WčsĊ֌W폜܂
			this.sendDestination(newPassenger);
			//̏q̓Ԃ𑫂܂
			this.timeRange =
				this.timeRange + this.getNextPassengerArrivalTime();
		}
		/*
		 * ̓܂ł̎ԂvZ܂
		 */
		//		RandomNumberGenerator random =
		//			this.getWorld().getRandomNumberGenerator();
		//
		//		this.slantRangeToAirport =
		//			(int) ((
		//				- ((AirportWorld) this.getWorld()).getAVERAGE_ArrivalTime()
		//					* Math.log(random.generate()))
		//				+ ((AirportWorld) this.getWorld()).RATIO_Rush);
		//
		//		if (this.slantRangeToAirport < 0) {
		//			this.slantRangeToAirport = 0;
		//		}

		DebugPrinter.println(
			"<OUT>-dropPassengersAction : " + this.getAgent().getType());
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractDropPassengersBehavior#keepDrivingAction()
	 */
	protected void keepDrivingAction() {
		DebugPrinter.println(
			"<IN>-keepDrivingAction : " + this.getAgent().getType());
		//		DebugPrinter.describe("c苗 " + this.slantRangeToAirport);

		//c苗JE^炵܂
		//		this.slantRangeToAirport--;
		this.timeRange = this.timeRange - 1.0;

		DebugPrinter.println(
			"<OUT>-keepDrivingAction : " + this.getAgent().getType());
	}

	/******************************************************************
	 * q̓Ԋu֘A
	 ******************************************************************/

	/**
	 * WorldŐݒ肳ꂽϓԊuƂɁA
	 * ̏q܂ł̎ԊԊuԂ܂
	 */
	private double getNextPassengerArrivalTime() {
		RandomNumberGenerator random =
			this.getWorld().getRandomNumberGenerator();
		return
			- ((AirportWorld) this.getWorld()).getAVERAGE_ArrivalTime()
				* Math.log(random.generate());
	}

	/******************************************************************
	 * q̐Eݒ֘A
	 ******************************************************************/

	/**
	 * q𐶐ĕԂ܂
	 */
	private Agent createPassenger() {
		AirportWorld world = (AirportWorld) this.getWorld();

		//q쐬܂
		Agent newPassenger =
			this.getAgent().getWorld().createAgent(
				QueueTheoryModel.AGENTTYPE_Passenger);

		//qɍst܂
		newPassenger.addBehavior(QueueTheoryModel.BEHAVIORTYPE_MoveAndWait);

		RandomNumberGenerator randomNumberGenerator =
			this.getWorld().getRandomNumberGenerator();
		/*
		 * qɓ挔tĉו܂
		 * 10%̓t@[XgNX	- 70%ו
		 * 30%̓rWlXNX		- 30%ו
		 * 60%̓GRm~[NX	- 70%ו
		 */
		double random = randomNumberGenerator.generate();
		if (1.0 - world.RATIO_FirstClassPassenger < random) {
			//t@[XgNX
			newPassenger.putInformation(
				new BoardingTicketInformation(
					BoardingTicketInformation.CLASS_First));
			this.addLuggage(newPassenger, world.RATIO_LuggageFirstClass);
		} else if (
			1.0
				- world.RATIO_FirstClassPassenger
				- world.RATIO_BusinessClassPassenger
				< random) {
			//rWlXNX
			newPassenger.putInformation(
				new BoardingTicketInformation(
					BoardingTicketInformation.CLASS_Bussiness));
			this.addLuggage(newPassenger, world.RATIO_LuggageBusinessClass);
		} else {
			//GRm~[NX
			newPassenger.putInformation(
				new BoardingTicketInformation(
					BoardingTicketInformation.CLASS_Economy));
			this.addLuggage(newPassenger, world.RATIO_LuggageEconomyClass);
		}
		return newPassenger;
	}

	/**
	 * ̊mŉו^܂
	 */
	private void addLuggage(Agent newPassenger, double ratio) {
		RandomNumberGenerator randomNumberGenerator =
			this.getWorld().getRandomNumberGenerator();
		if (randomNumberGenerator.generate() < ratio) {
			newPassenger.addGoods(
				this.getWorld().createGoods(
					QueueTheoryModel.GOODSTYPE_Luggage,
					1.0));
		}
	}

	/**
	 * qɊ֌WȂŁA̍sA֌W폜܂
	 */
	private void sendDestination(Agent newPassenger) {
		//̍siCtH[VfXN̑҂sǗG[WFgjQƂ܂
		DestinationInformation destination = new DestinationInformation(1);
		Collection toInformationDesks =
			this.getAgent().getRelations(QueueTheoryModel.RELATIONTYPE_Route);
		for (Iterator i = toInformationDesks.iterator(); i.hasNext();) {
			Agent informationDesk = ((Relation) i.next()).getTarget();
			destination.addNextQueueManager(informationDesk);
		}

		//qɑ΂֌Wт܂
		this.getAgent().addRelation(
			QueueTheoryModel.RELATIONTYPE_ToServedPassenger,
			newPassenger);

		//qɎ̍s܂
		this.sendInformation(
			QueueTheoryModel.RELATIONTYPE_ToServedPassenger,
			QueueTheoryModel.BEHAVIORTYPE_MoveAndWait,
			destination);

		//qɑ΂֌W폜܂
		this.getAgent().removeRelations(
			QueueTheoryModel.RELATIONTYPE_ToServedPassenger);
	}

	/***********************************************
	 * Ȃ\bh
	 ***********************************************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

}
