/**
 * InformationDeskServiceBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import java.util.Collection;
import java.util.Iterator;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org
	.boxed_economy
	.queuetheory
	.model
	.information
	.BoardingTicketInformation;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.DestinationInformation;

/**
 * @author tsuya
 * Created Date : 2003/10/14 18:03:54
 */
public class InformationDeskServiceBehavior extends ServiceBehavior {

	/**
	 * q̂挔ɂāA̍sӂ킯܂
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#showNextDestinationAction()
	 */
	protected void showNextDestinationAction() {
		DebugPrinter.println(
			"<IN>-showNextServerAction : " + this.getAgent().getType());
		DebugPrinter.describe(
			"T[rXÎŎ̍s܂ : " + this.getAgent().getType());

		//݉Β̏q挔QƂ܂
		Agent passenger =
			this
				.getAgent()
				.getRelation(QueueTheoryModel.RELATIONTYPE_ToServedPassenger)
				.getTarget();
		BoardingTicketInformation ticket =
			(BoardingTicketInformation) passenger.getInformation(
				QueueTheoryModel.INFORMATIONTYPE_BoardingTicket);

		//挔̎ނɊÂA̍s쐬܂
		DestinationInformation destination =
			new DestinationInformation(super.getDistance());
		Collection toQueueManagers =
			this.getAgent().getRelations(QueueTheoryModel.RELATIONTYPE_Route);
		for (Iterator i = toQueueManagers.iterator(); i.hasNext();) {
			Agent nextQueueManager = ((Relation) i.next()).getTarget();
			if (((BoardingTicketInformation) nextQueueManager
				.getInformation(
					QueueTheoryModel.INFORMATIONTYPE_BoardingTicket))
				.checkSeatClass(ticket.getSeatClass())) {
				destination.addNextQueueManager(nextQueueManager);
			}
		}

		//݉Β̏qɓn܂
		Relation toServedPassenger =
			this.getAgent().getRelation(
				QueueTheoryModel.RELATIONTYPE_ToServedPassenger);
		this.sendInformation(
			toServedPassenger,
			QueueTheoryModel.BEHAVIORTYPE_MoveAndWait,
			destination);
		this.getActiveChannel().close();

		//Β̊֌W폜܂
		this.getAgent().removeRelation(toServedPassenger);

		DebugPrinter.println(
			"<OUT>-showNextServerAction : " + this.getAgent().getType());
	}

}
