/**
 * ManageQueueBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.PassengerInformation;
import org.boxed_economy.queuetheory.model.information.PassengerQueueInformation;

/**
 * @author tsuya
 * Created Date : 2003/10/14 15:42:17
 */
public class ManageQueueBehavior extends AbstractManageQueueBehavior {

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractManageQueueBehavior#isPassengerInformationReceived(Event)
	 */
	protected boolean isPassengerInformationReceived(Event e) {
		return QueueTheoryModel.INFORMATIONTYPE_Passenger.equals(
			this.getWorld().getInformationType(this.getReceivedInformation()));
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractManageQueueBehavior#addNewPassengerToQueueAction()
	 */
	protected void addNewPassengerToQueueAction() {
		DebugPrinter.println(
			"<IN>-addNewPassengerToQueueAction : " + this.getAgent());
		DebugPrinter.describe("҂sɉ܂ : " + this.getAgent());

		//VqQ
		PassengerInformation passengerInformation =
			(PassengerInformation) this.getReceivedInformation();
		Agent passenger = passengerInformation.getPassenger();

		//҂sɉ
		PassengerQueueInformation queue =
			(PassengerQueueInformation) this.getAgent().getInformation(
				QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
		queue.addPassenger(passenger);

		DebugPrinter.println(
			"<OUT>-addNewPassengerToQueueAction : " + this.getAgent());
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractManageQueueBehavior#isCallFromServer(Event)
	 */
	protected boolean isCallFromServer(Event e) {
		return QueueTheoryModel.INFORMATIONTYPE_CallFromServer.equals(
			this.getWorld().getInformationType(this.getReceivedInformation()));
	}

	/**
	 * ̏qT[o[ɓ`܂
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractManageQueueBehavior#showNextPassengerAction()
	 */
	protected void showNextPassengerAction() {
		DebugPrinter.println(
			"<IN>-showNextPassengerAction : " + this.getAgent());
		DebugPrinter.describe("̏T[o[ɓ`܂ : " + this.getAgent());

		//҂s񂩂擪̏qƂ肾
		PassengerQueueInformation queue =
			(PassengerQueueInformation) this.getAgent().getInformation(
				QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
		Agent firstPassenger = queue.removeFirstPassenger();

		//̏qT[o[ɓ`
		this.sendInformation(new PassengerInformation(firstPassenger));

		DebugPrinter.println(
			"<OUT>-showNextPassengerAction : " + this.getAgent());
	}

	/***********************************************
	 * Ȃ\bh
	 ***********************************************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

}
