/**
 * MoveAndWaitBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import java.util.Iterator;

import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.information.*;
import org.boxed_economy.queuetheory.model.information.DestinationInformation;
import org.boxed_economy.queuetheory.model.information.PassengerInformation;

/**
 * @author tsuya
 * Created Date : 2003/10/14 15:22:38
 */
public class MoveAndWaitBehavior extends AbstractMoveAndWaitBehavior {

	private int slantRange = 0;

	/**
	 * ̍sɊւ󂯎ǂ̔
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#isDestinationReceived(Event)
	 */
	protected boolean isDestinationReceived(Event e) {
		return QueueTheoryModel.INFORMATIONTYPE_Destination.equals(
			this.getWorld().getInformationType(this.getReceivedInformation()));
	}

	/**
	 * ̍sւ̈ړJn܂
	 * 	- ̍sւ̊֌Wт܂
	 * 	- c苗JE^ݒ肵܂
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#beginMovingAction()
	 */
	protected void beginMovingAction() {
		DebugPrinter.println("<IN>-beginMovingAction : " + this.getAgent());

		DestinationInformation destination =
			(DestinationInformation) this.getReceivedInformation();

		//̍sւ̊֌Wт܂
		for (Iterator i = destination.Iterator(); i.hasNext();) {
			Agent nextServer = (Agent) i.next();
			this.getAgent().addRelation(
				QueueTheoryModel.RELATIONTYPE_MoveTo,
				nextServer);
		}

		//c苗JE^ݒ肵܂
		int slantRangeToNext = destination.getSlantRange();
		this.slantRange = slantRangeToNext;

		DebugPrinter.describe(
			"̖ړInֈړJn܂ ... c苗 "
				+ this.slantRange
				+ " : "
				+ this.getAgent());
		DebugPrinter.println("<OUT>-beginMovingAction : " + this.getAgent());
	}

	/**
	 * ܂ĂȂǂ̔
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#isNotArrivedAtQueue(Event)
	 */
	protected boolean isNotArrivedAtQueue(Event e) {
		return this.slantRange > 0;
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#keepMovingAction()
	 */
	protected void keepMovingAction() {
		DebugPrinter.println("<IN>-keepMovingAction : " + this.getAgent());

		this.slantRange--;

		DebugPrinter.describe(
			"̖ړInɈړł ... c苗 "
				+ this.slantRange
				+ " : "
				+ this.getAgent());
		DebugPrinter.println("<OUT>-keepMovingAction : " + this.getAgent());
	}

	/**
	 * ǂ̔
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#isArrivedAtQueue(Event)
	 */
	protected boolean isArrivedAtQueue(Event e) {
		return this.slantRange == 0;
	}

	/**
	 * ǂ̑҂sɕԂ߂āA֌Wт܂
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#chooseQueueAction()
	 */
	protected void chooseQueueAction() {
		DebugPrinter.println("<IN>-chooseQueueAction : " + this.getAgent());

		//ԑ҂sIт܂i͂߂̂Iт܂j
		Agent queueManager =
			this
				.getAgent()
				.getRelation(QueueTheoryModel.RELATIONTYPE_MoveTo)
				.getTarget();

		DebugPrinter.describe("̂ő҂sɕт܂ : " + this.getAgent());

		//I񂾑҂sɎԂƂ`܂
		this.sendInformation(
			QueueTheoryModel.RELATIONTYPE_MoveTo,
			QueueTheoryModel.BEHAVIORTYPE_ManageQueue,
			new PassengerInformation(this.getAgent()));

		//ړÎŁAړ̂߂̊֌Wׂč폜܂
		this.getAgent().removeRelations(QueueTheoryModel.RELATIONTYPE_MoveTo);

		DebugPrinter.println("<OUT>-chooseQueueAction : " + this.getAgent());
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#isCallFromServerReceived(Event)
	 */
	protected boolean isCallFromServerReceived(Event e) {
		return QueueTheoryModel.INFORMATIONTYPE_CallFromServer.equals(
			this.getWorld().getInformationType(this.getReceivedInformation()));
	}

	/**
	 * T[rX󂯂܂
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractMoveAndWaitBehavior#serveAction()
	 */
	protected void serveAction() {
		DebugPrinter.println("<IN>-serveAction : " + this.getAgent());
		DebugPrinter.describe("T[rX󂯂܂ : " + this.getAgent());
		DebugPrinter.println("<OUT>-serveAction : " + this.getAgent());
	}

	/***********************************************
	 * Ȃ\bh
	 ***********************************************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

}
