/**
 * ServiceBehavior.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.behavior;

import java.util.Collection;
import java.util.Iterator;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.queuetheory.model.AirportWorld;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org
	.boxed_economy
	.queuetheory
	.model
	.information
	.BoardingTicketInformation;
import org
	.boxed_economy
	.queuetheory
	.model
	.information
	.CallFromServerInformation;
import org.boxed_economy.queuetheory.model.information.DebugPrinter;
import org.boxed_economy.queuetheory.model.information.DestinationInformation;
import org.boxed_economy.queuetheory.model.information.PassengerInformation;

/**
 * @author tsuya
 * Created Date : 2003/10/14 16:16:30
 */
public class ServiceBehavior extends AbstractServiceBehavior {

	//	private int serviceWork = 0;
	private double serviceWork = 0.0;

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#callNextPassengerAction()
	 */
	protected void callNextPassengerAction() {
		Relation toQueueManager =
			this.getAgent().getRelation(
				QueueTheoryModel.RELATIONTYPE_ToQueueManager);
		this.sendInformation(
			toQueueManager,
			QueueTheoryModel.BEHAVIORTYPE_ManageQueue,
			new CallFromServerInformation());
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#isWaitingPassengerNotExists(Event)
	 */
	protected boolean isWaitingPassengerNotExists(Event e) {
		return ((PassengerInformation) this.getReceivedInformation())
			.getPassenger()
			== null;
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#isWaitingPassengerExists(Event)
	 */
	protected boolean isWaitingPassengerExists(Event e) {
		return ((PassengerInformation) this.getReceivedInformation())
			.getPassenger()
			!= null;
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#startServiceAction()
	 */
	protected void startServiceAction() {
		DebugPrinter.println(
			"<IN>-startServiceAction : " + this.getAgent().getType());

		PassengerInformation passengerInformation =
			(PassengerInformation) this.getReceivedInformation();
		Agent passenger = passengerInformation.getPassenger();

		//Β̊֌Wт܂
		this.getAgent().addRelation(
			QueueTheoryModel.RELATIONTYPE_ToServedPassenger,
			passenger);

		DebugPrinter.describe(
			"̐擪" + passenger + "Ăт܂ : " + this.getAgent().getType());

		Relation toServedPassenger =
			this.getAgent().getRelation(
				QueueTheoryModel.RELATIONTYPE_ToServedPassenger);
		this.sendInformation(
			toServedPassenger,
			QueueTheoryModel.BEHAVIORTYPE_MoveAndWait,
			new CallFromServerInformation());

		DebugPrinter.describe("T[rXn߂܂ : " + this.getAgent().getType());

		//T[rXԂ̒ŽvZɕKvȂƁiוĂ邩HȂǁjq˂܂
		this.serviceWork =
			this.serviceWork + this.getServiceWorkLength(passenger);

		DebugPrinter.println(
			"<OUT>-startServiceAction : " + this.getAgent().getType());
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#isNotServiceFinished(Event)
	 */
	protected boolean isNotServiceFinished(Event e) {
		//		return this.serviceWork > 0;
		return 0.0 < this.serviceWork;
	}

	/**
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#isServiceFinished(Event)
	 */
	protected boolean isServiceFinished(Event e) {
		//		return this.serviceWork == 0;
		return this.serviceWork <= 0.0;
	}

	/**
	 * T[rX𑱂܂
	 * 	- T[rXc莞ԃJE^炵܂
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#keepServicingAction()
	 */
	protected void keepServicingAction() {
		DebugPrinter.println(
			"<IN>-keepServicingAction : " + this.getAgent().getType());

		//		this.serviceWork--;
		this.serviceWork = this.serviceWork - 1.0;

		DebugPrinter.describe("cT[rXʂ " + this.serviceWork);
		DebugPrinter.println(
			"<OUT>-keepServicingAction : " + this.getAgent().getType());
	}

	/**
	 * ̍sāA΂I܂
	 * 	- ̍s܂
	 * 		- ̍s쐬܂
	 * 		- ݉Β̏qɓn܂
	 * 	- Β֌W폜܂
	 * @see org.boxed_economy.queuetheory.model.behavior.AbstractServiceBehavior#showNextDestinationAction()
	 */
	protected void showNextDestinationAction() {
		DebugPrinter.println(
			"<IN>-showNextServerAction : " + this.getAgent().getType());
		DebugPrinter.describe(
			"T[rXÎŎ̍s܂ : " + this.getAgent().getType());

		//̍s쐬܂
		DestinationInformation destination =
			new DestinationInformation(this.getDistance());
		Collection toQueueManagers =
			this.getAgent().getRelations(QueueTheoryModel.RELATIONTYPE_Route);
		for (Iterator i = toQueueManagers.iterator(); i.hasNext();) {
			Agent nextQueueManager = ((Relation) i.next()).getTarget();
			destination.addNextQueueManager(nextQueueManager);
		}

		//݉Β̏qɓn܂
		Relation toServedPassenger =
			this.getAgent().getRelation(
				QueueTheoryModel.RELATIONTYPE_ToServedPassenger);
		this.sendInformation(
			toServedPassenger,
			QueueTheoryModel.BEHAVIORTYPE_MoveAndWait,
			destination);
		this.getActiveChannel().close();

		//Β̊֌W폜܂
		this.getAgent().removeRelation(toServedPassenger);

		DebugPrinter.println(
			"<OUT>-showNextServerAction : " + this.getAgent().getType());
	}

	/***********************************************
	 * T[rXԁEvZ\bh
	 ***********************************************/

	/**
	 * ̃T[o܂ł̋Ԃ܂
	 */
	protected int getDistance() {
		AirportWorld world = (AirportWorld) this.getWorld();
		AgentType agentType = this.getAgent().getType();
		if (agentType.equals(QueueTheoryModel.AGENTTYPE_InformationDesk)) {
			RandomNumberGenerator random =
				this.getWorld().getRandomNumberGenerator();
			//CtH[VfXNJE^[܂ł̋͂T`W
			return random.generate(
				world.TRAVELTIME_FromInfoDeskToCounter_MAX
					- world.TRAVELTIME_FromInfoDeskToCounter_MIN
					+ 1)
				+ world.TRAVELTIME_FromInfoDeskToCounter_MIN;
		} else if (
			agentType.equals(QueueTheoryModel.AGENTTYPE_CheckInCounter)) {
			//JE^[瓋܂łPO`QO
			RandomNumberGenerator random =
				this.getWorld().getRandomNumberGenerator();
			return random.generate(
				world.TRAVELTIME_FromCounterToSecurityCheck_MAX
					- world.TRAVELTIME_FromCounterToSecurityCheck_MIN
					+ 1)
				+ world.TRAVELTIME_FromCounterToSecurityCheck_MIN;
		} else if (agentType.equals(QueueTheoryModel.AGENTTYPE_Gate)) {
			//P
			return 1;
		} else {
			throw new ModelException(
				"Invalid AgentType : " + this.getAgent().getType().getName());
		}
	}

	/**
	 * T[rXԂԂ܂
	 */
	private double getServiceWorkLength(Agent passenger) {
		AirportWorld world = (AirportWorld) this.getWorld();
		AgentType agentType = this.getAgent().getType();
		RandomNumberGenerator random =
			this.getWorld().getRandomNumberGenerator();
		if (agentType.equals(QueueTheoryModel.AGENTTYPE_InformationDesk)) {
			//CtH[VfXNT[rXԂ͕ςPŎwz
			return this.getInformationDeskServiceTime();
		} else if (
			agentType.equals(QueueTheoryModel.AGENTTYPE_CheckInCounter)) {
			//JE^[T[rXԂ͉וȂQ`SAוT`QO
			((BoardingTicketInformation) passenger
				.getInformation(
					QueueTheoryModel.INFORMATIONTYPE_BoardingTicket))
				.check();
			if (passenger
				.getQuantity(QueueTheoryModel.GOODSTYPE_Luggage)
				.getValueAsDouble()
				> 0.0) {
				return (double)
					(random
						.generate(
							world.SERVICETIME_CounterWithLuggage_MAX
								- world.SERVICETIME_CounterWithLuggage_MIN
								+ 1)
						+ world.SERVICETIME_CounterWithLuggage_MIN);
			} else {
				return (double)
					(random
						.generate(
							world.SERVICETIME_CounterNoLuggage_MAX
								- world.SERVICETIME_CounterNoLuggage_MIN
								+ 1)
						+ world.SERVICETIME_CounterNoLuggage_MIN);
			}
		} else if (agentType.equals(QueueTheoryModel.AGENTTYPE_Gate)) {
			//T[rXԂ͂PAQ
			return (double)
				(random
					.generate(
						world.SERVICETIME_SecurityCheck_MAX
							- world.SERVICETIME_SecurityCheck_MIN
							+ 1)
					+ world.SERVICETIME_SecurityCheck_MIN);
		} else {
			throw new ModelException(
				"Invalid AgentType : " + this.getAgent().getType().getName());
		}
	}

	/**
	 * Information Desk̃T[rXԂԂ܂
	 */
	private double getInformationDeskServiceTime() {
		RandomNumberGenerator random =
			this.getWorld().getRandomNumberGenerator();
		return
			- ((AirportWorld) this.getWorld()).AVERAGE_InfomationDeskServiceTime
				* Math.log(random.generate());
	}

	/***********************************************
	 * Ȃ\bh
	 ***********************************************/

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#initialize()
	 */
	protected void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior#terminate()
	 */
	protected void terminate() {
	}

}
