/**
 * AirportQueueDataGetter.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.util.Collection;
import java.util.Iterator;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org.boxed_economy.queuetheory.model.information.BoardingTicketInformation;
import org.boxed_economy.queuetheory.model.information.PassengerQueueInformation;

/**
 * @author tsuya
 * Created Date : 2003/10/18 12:31:43
 */
public class AirportQueueDataGetter {

	public static String getPassengerCondition(World world) {
		StringBuffer condition = new StringBuffer();

		//SĂ̏q̃JEg
		int numAllPassenger = getNumberOfAllPassenger(world);
		//ړ̏q̃JEg
		int numMovingPassenger = getNumberOfMovingPassenger(world);
		int numMovingPassenger_Economy =
			getNumberOfMovingPassengerToEachCounter(
				world,
				BoardingTicketInformation.CLASS_Economy);
		int numMovingPassenger_Business =
			getNumberOfMovingPassengerToEachCounter(
				world,
				BoardingTicketInformation.CLASS_Bussiness);
		int numMovingPassenger_First =
			getNumberOfMovingPassengerToEachCounter(
				world,
				BoardingTicketInformation.CLASS_First);
		int numMovingPassenger_Gate =
			getNumberOfMovingPassengerToGate(
				world);

		//T[rX󂯂Ăq̃JEg
		int numServedPassenger = getNumberOfServedPassenger(world);
		//łq̃JEg
		int numQueuingPassenger = getNumberOfQueuingPassenger(world);

		//eT[oɕłq̃JEg
		int numQueuingPassenger_InformationDesk =
			getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_InformationDesk);
		int numQueuingPassenger_Economy =
			getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
		int numQueuingPassenger_Bussiness =
			getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
		int numQueuingPassenger_First =
			getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
		int numQueueingPassenger_Gate =
			getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Gate);
		int numQueueingPassenger_Sink = getNumberOfQueuingPassenger_Sink(world);

		condition.append("----------q̏----------");
		condition.append("\n");
		condition.append("	S								: " + numAllPassenger);
		condition.append("\n");
		condition.append(
			"		- ړ					: " + numMovingPassenger);
		condition.append("\n");
		condition.append(
			"			- Economy				: " + numMovingPassenger_Economy);
		condition.append("\n");
		condition.append(
			"			- Business				: "
				+ numMovingPassenger_Business);
		condition.append("\n");
		condition.append(
			"			- First					: " + numMovingPassenger_First);
		condition.append("\n");
		condition.append(
			"			- Gate					: " + numMovingPassenger_Gate);

		condition.append("\n");
		condition.append(
			"		- T[rX󂯒			: " + numServedPassenger);
		condition.append("\n");
		condition.append(
			"		- ђ						: " + numQueuingPassenger);
		condition.append("\n");
		condition.append(
			"			- InformationDesk	: "
				+ numQueuingPassenger_InformationDesk);
		condition.append("\n");
		condition.append(
			"			- Economy				: "
				+ numQueuingPassenger_Economy);
		condition.append("\n");
		condition.append(
			"			- Bussiness			: "
				+ numQueuingPassenger_Bussiness);
		condition.append("\n");
		condition.append(
			"			- First					: "
				+ numQueuingPassenger_First);
		condition.append("\n");
		condition.append(
			"			- Gate					: "
				+ numQueueingPassenger_Gate);
		condition.append("\n");
		condition.append(
			"			- Sink					: "
				+ numQueueingPassenger_Sink);
		condition.append("\n");
		condition.append("------------------------------");

		if (numAllPassenger
			!= numMovingPassenger + numServedPassenger + numQueuingPassenger) {
			throw new ModelException("q̐l܂");
		}
		if (numMovingPassenger
			!= numMovingPassenger_Economy
				+ numMovingPassenger_Business
				+ numMovingPassenger_First
				+ numMovingPassenger_Gate) {
			throw new ModelException("ړĂl܂");
		}

		if (numQueuingPassenger
			!= numQueuingPassenger_InformationDesk
				+ numQueuingPassenger_Economy
				+ numQueuingPassenger_Bussiness
				+ numQueuingPassenger_First
				+ numQueueingPassenger_Gate
				+ numQueueingPassenger_Sink) {
			throw new ModelException("łl܂");
		}
		return condition.toString();
	}

	public static void printInitialCondition(World world) {
		int numSource =
			world.getAgents(QueueTheoryModel.AGENTTYPE_Source).size();
		int numInformationDesk =
			world.getAgents(QueueTheoryModel.AGENTTYPE_InformationDesk).size();
		int numCheckInCounter =
			world
				.getAgentsRecursively(QueueTheoryModel.AGENTTYPE_CheckInCounter)
				.size();
		int numCounter_Economy =
			world
				.getAgents(QueueTheoryModel.AGENTTYPE_Counter_EconomyClass)
				.size();
		int numCounter_Bussiness =
			world
				.getAgents(QueueTheoryModel.AGENTTYPE_Counter_BussinessClass)
				.size();
		int numCounter_First =
			world
				.getAgents(QueueTheoryModel.AGENTTYPE_Counter_FirstClass)
				.size();
		int numGate = world.getAgents(QueueTheoryModel.AGENTTYPE_Gate).size();
		int numSink = world.getAgents(QueueTheoryModel.AGENTTYPE_Sink).size();

		System.out.println("----------");
		System.out.println("Source				: " + numSource);
		System.out.println("InformationDesk	: " + numInformationDesk);
		System.out.println("CheckInCounter	: " + numCheckInCounter);
		System.out.println("	- Economy		: " + numCounter_Economy);
		System.out.println("	- Bussiness	: " + numCounter_Bussiness);
		System.out.println("	- First			: " + numCounter_First);
		System.out.println("Gate					: " + numGate);
		System.out.println("Sink					: " + numSink);
		System.out.println("------------------");
	}

//	public static void printPassengerCondition(World world) {
//		//SĂ̏q̃JEg
//		int numAllPassenger = getNumberOfAllPassenger(world);
//		//ړ̏q̃JEg
//		int numMovingPassenger = getNumberOfMovingPassenger(world);
//		//T[rX󂯂Ăq̃JEg
//		int numServedPassenger = getNumberOfServedPassenger(world);
//		//łq̃JEg
//		int numQueuingPassenger = getNumberOfQueuingPassenger(world);
//
//		//eT[oɕłq̃JEg
//		int numQueuingPassenger_InformationDesk =
//			getNumberOfQueuingPassengerToEachServer(
//				world,
//				QueueTheoryModel.AGENTTYPE_InformationDesk);
//		int numQueuingPassenger_Economy =
//			getNumberOfQueuingPassengerToEachServer(
//				world,
//				QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
//		int numQueuingPassenger_Bussiness =
//			getNumberOfQueuingPassengerToEachServer(
//				world,
//				QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
//		int numQueuingPassenger_First =
//			getNumberOfQueuingPassengerToEachServer(
//				world,
//				QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
//		int numQueueingPassenger_Gate =
//			getNumberOfQueuingPassengerToEachServer(
//				world,
//				QueueTheoryModel.AGENTTYPE_Gate);
//		int numQueueingPassenger_Sink = getNumberOfQueuingPassenger_Sink(world);
//
//		System.out.println("----------q̏----------");
//		System.out.println(
//			"	S								: " + numAllPassenger);
//		System.out.println(
//			"		- ړ					: " + numMovingPassenger);
//
//		System.out.println(
//			"		- T[rX󂯒			: " + numServedPassenger);
//		System.out.println(
//			"		- ђ						: " + numQueuingPassenger);
//		System.out.println(
//			"			- InformationDesk	: "
//				+ numQueuingPassenger_InformationDesk);
//		System.out.println(
//			"			- Economy				: "
//				+ numQueuingPassenger_Economy);
//		System.out.println(
//			"			- Bussiness			: "
//				+ numQueuingPassenger_Bussiness);
//		System.out.println(
//			"			- First					: "
//				+ numQueuingPassenger_First);
//		System.out.println(
//			"			- Gate					: "
//				+ numQueueingPassenger_Gate);
//		System.out.println(
//			"			- Sink					: "
//				+ numQueueingPassenger_Sink);
//		System.out.println("------------------------------");
//
//		if (numAllPassenger
//			!= numMovingPassenger + numServedPassenger + numQueuingPassenger) {
//			throw new ModelException("q̐l܂");
//		}
//		if (numQueuingPassenger
//			!= numQueuingPassenger_InformationDesk
//				+ numQueuingPassenger_Economy
//				+ numQueuingPassenger_Bussiness
//				+ numQueuingPassenger_First
//				+ numQueueingPassenger_Gate
//				+ numQueueingPassenger_Sink) {
//			throw new ModelException("łl܂");
//		}
//		if (numMovingPassenger
//			!= getNumberOfMovingPassengerToServer(
//				QueueTheoryModel.AGENTTYPE_InformationDesk,
//				world)
//				+ getNumberOfMovingPassengerToServer(
//					QueueTheoryModel.AGENTTYPE_Counter_EconomyClass,
//					world)
//				+ getNumberOfMovingPassengerToServer(
//					QueueTheoryModel.AGENTTYPE_Counter_BussinessClass,
//					world)
//				+ getNumberOfMovingPassengerToServer(
//					QueueTheoryModel.AGENTTYPE_Counter_FirstClass,
//					world)
//				+ getNumberOfMovingPassengerToServer(
//					QueueTheoryModel.AGENTTYPE_Gate,
//					world)
//				+ getNumberOfMovingPassengerToSink(world)) {
//			throw new ModelException("ړ̐l܂");
//		}
//
//	}

	/***********************************************
	 * q̐l擾֘A
	 ***********************************************/

	/**
	 * ֈړ̏q̐Ԃ܂
	 */
	public static int getNumberOfMovingPassengerToGate(World world) {
		int total = 0;
		Collection passengers =
			world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
		for (Iterator i = passengers.iterator(); i.hasNext();) {
			Agent passenger = (Agent) i.next();
			if (passenger
				.getRelationTypes()
				.contains(QueueTheoryModel.RELATIONTYPE_MoveTo)) {
				BoardingTicketInformation ticket =
					(BoardingTicketInformation) passenger.getInformation(
						QueueTheoryModel.INFORMATIONTYPE_BoardingTicket);
				if (ticket.isChecked()) {
					total++;
				}
			}
		}
		return total;
	}

	/**
	 * e`FbNCJE^[ֈړ̏q̐Ԃ܂
	 */
	public static int getNumberOfMovingPassengerToEachCounter(
		World world,
		String ticketClass) {
		int total = 0;
		Collection passengers =
			world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
		for (Iterator i = passengers.iterator(); i.hasNext();) {
			Agent passenger = (Agent) i.next();
			if (passenger
				.getRelationTypes()
				.contains(QueueTheoryModel.RELATIONTYPE_MoveTo)) {
				BoardingTicketInformation ticket =
					(BoardingTicketInformation) passenger.getInformation(
						QueueTheoryModel.INFORMATIONTYPE_BoardingTicket);
				if (!ticket.isChecked()
					&& ticket.checkSeatClass(ticketClass)) {
					total++;
				}
			}
		}
		return total;
	}

	/**
	 * w肵AgentTypẽT[o֕łq̐Ԃ܂
	 */
	public static int getNumberOfQueuingPassengerToEachServer(
		World world,
		AgentType agentType) {
		//eT[oToQueueManager֌WẴG[WFg擾
		Agent queueManager =
			world
				.getAgent(agentType)
				.getRelation(QueueTheoryModel.RELATIONTYPE_ToQueueManager)
				.getTarget();
		PassengerQueueInformation queue =
			(PassengerQueueInformation) queueManager.getInformation(
				QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
		return queue.size();
	}

	public static int getNumberOfQueuingPassenger_Sink(World world) {
		Agent sink = world.getAgent(QueueTheoryModel.AGENTTYPE_Sink);
		PassengerQueueInformation queue =
			(PassengerQueueInformation) sink.getInformation(
				QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
		return queue.size();
	}

	/**
	 * łq̐Ԃ܂
	 */
	public static int getNumberOfQueuingPassenger(World world) {
		int numQueuingPassenger = 0;
		Collection queueManagers =
			world.getAgents(QueueTheoryModel.AGENTTYPE_QueueManager);
		for (Iterator i = queueManagers.iterator(); i.hasNext();) {
			Agent queueManager = (Agent) i.next();
			PassengerQueueInformation queue =
				(PassengerQueueInformation) queueManager.getInformation(
					PassengerQueueInformation.class);
			if (queue.size() > 0) {
				numQueuingPassenger = numQueuingPassenger + queue.size();
			}
		}
		//VNɕłqZo܂
		Agent sink = world.getAgent(QueueTheoryModel.AGENTTYPE_Sink);
		PassengerQueueInformation queue =
			(PassengerQueueInformation) sink.getInformation(
				QueueTheoryModel.INFORMATIONTYPE_PassengerQueue);
		numQueuingPassenger = numQueuingPassenger + queue.size();

		return numQueuingPassenger;
	}

	/**
	 * T[rX󂯂Ăq̐Ԃ܂
	 */
	public static int getNumberOfServedPassenger(World world) {
		int numServedPassenger = 0;
		Collection servers =
			world.getAgentsRecursively(QueueTheoryModel.AGENTTYPE_Server);
		for (Iterator i = servers.iterator(); i.hasNext();) {
			Agent server = (Agent) i.next();
			if (!server
				.getRelations(QueueTheoryModel.RELATIONTYPE_ToServedPassenger)
				.isEmpty()) {
				numServedPassenger++;
			}
		}
		return numServedPassenger;
	}

	/**
	 * SqԂ܂
	 */
	public static int getNumberOfAllPassenger(World world) {
		int numAllPassenger;
		numAllPassenger =
			world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger).size();
		return numAllPassenger;
	}

	/**
	 * ړ̏q̐Ԃ܂
	 */
	public static int getNumberOfMovingPassenger(World world) {
		int numMovingPassenger = 0;
		Collection passengers =
			world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
		for (Iterator i = passengers.iterator(); i.hasNext();) {
			Agent passenger = (Agent) i.next();
			if (!passenger
				.getRelations(QueueTheoryModel.RELATIONTYPE_MoveTo)
				.isEmpty()) {
				numMovingPassenger++;
			}
		}
		return numMovingPassenger;
	}

	public static int getNumberOfMovingPassengerToServer(
		AgentType serverType,
		World world) {
		int numMovingPassenger = 0;
		Collection passengers =
			world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
		for (Iterator i = passengers.iterator(); i.hasNext();) {
			Agent passenger = (Agent) i.next();
			if (!passenger
				.getRelations(QueueTheoryModel.RELATIONTYPE_MoveTo)
				.isEmpty()) {
				Agent queueManager =
					passenger
						.getRelation(QueueTheoryModel.RELATIONTYPE_MoveTo)
						.getTarget();
				if (!queueManager
					.getType()
					.equals(QueueTheoryModel.AGENTTYPE_Sink)
					&& queueManager
						.getRelation(QueueTheoryModel.RELATIONTYPE_ToServer)
						.getTarget()
						.getType()
						.equals(serverType)) {
					numMovingPassenger++;
				}
			}
		}
		return numMovingPassenger;
	}

	public static int getNumberOfMovingPassengerToSink(World world) {
		int numMovingPassenger = 0;
		Collection passengers =
			world.getAgents(QueueTheoryModel.AGENTTYPE_Passenger);
		for (Iterator i = passengers.iterator(); i.hasNext();) {
			Agent passenger = (Agent) i.next();
			if (!passenger
				.getRelations(QueueTheoryModel.RELATIONTYPE_MoveTo)
				.isEmpty()) {
				Agent queueManager =
					passenger
						.getRelation(QueueTheoryModel.RELATIONTYPE_MoveTo)
						.getTarget();
				if (queueManager
					.getType()
					.equals(QueueTheoryModel.AGENTTYPE_Sink)) {
					numMovingPassenger++;
				}
			}
		}
		return numMovingPassenger;
	}

}
