/**
 * AirportQueuePanel.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;

import javax.swing.JFrame;
import javax.swing.JPanel;

import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.queuetheory.model.AirportWorld;
import org.boxed_economy.queuetheory.model.QueueTheoryModel;
import org
	.boxed_economy
	.queuetheory
	.model
	.information
	.BoardingTicketInformation;

/**
 * @author tsuya
 * Created Date : 2003/10/23 13:56:43
 */
public class AirportQueuePanel extends JPanel {

	public static final int serverWidth = 120;
	public static final int serverHeight = 20;
	private World world = null;
	private CsvWriter csvWriter = new CsvWriter();

	protected void paintComponent(Graphics g) {
		this.initializePanel(g);
		if (this.world != null
			&& this.world.getClass().equals(AirportWorld.class)) {
			this.drawServerCards(g);
		} else {
			this.warning(g);
		}
	}

	private void warning(Graphics g) {
		int width = this.getWidth();
		int height = this.getHeight();
		g.setColor(Color.black);
		g.drawString("K؂Worldǂݍ܂Ă܂", width / 2 - 100, height / 2);
	}

	public void setWorld(World world) {
		this.world = world;
	} /**
							 * pl̏ݒs܂
							 */
	private void initializePanel(Graphics g) {
		//`R|[lgݒ肵܂
		super.paintComponent(g);
		this.setBackground(Color.white);
		g.setFont(new Font("System", 0, 11));
	} /**
						 * T[o`悵܂
						 */
	private void drawServerCards(Graphics g) {
		int width = this.getWidth();
		int height = this.getHeight();
		int infoDeskNum = ((AirportWorld) this.world).NUMBER_InformationDesk;
		int economyNum =
			((AirportWorld) this.world).NUMBER_CheckInCounter_EconomyClass;
		int businessNum =
			((AirportWorld) this.world).NUMBER_CheckInCounter_BusinessClass;
		int firstNum =
			((AirportWorld) this.world).NUMBER_CheckInCounter_FirstClass;
		int gateNum = ((AirportWorld) this.world).NUMBER_SecurityCheck;
		int infoDeskQueueNum =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_InformationDesk);
		int economyQueueNum =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
		int businessQueueNum =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
		int firstQueueNum =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
		int gateQueueNum =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Gate);
		int movingToEconomy =
			AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(
				world,
				BoardingTicketInformation.CLASS_Economy);
		int movingToBusiness =
			AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(
				world,
				BoardingTicketInformation.CLASS_Bussiness);
		int movingToFirst =
			AirportQueueDataGetter.getNumberOfMovingPassengerToEachCounter(
				world,
				BoardingTicketInformation.CLASS_First);
		int movingToGate =
			AirportQueueDataGetter.getNumberOfMovingPassengerToGate(world);
		//\[XƃVN̐ݒ
		SourceAndSinkCard source =
			new SourceAndSinkCard(
				"Entrance",
				width / 40,
				height - serverHeight - height / 10 - businessNum * 3);
		SourceAndSinkCard sink =
			new SourceAndSinkCard(
				"Gate",
				(width * 39) / 40 - serverWidth,
				economyNum * 3 + height / 10);
		//T[o̐ݒ
		ServerCard informationDesk =
			new ServerCard(
				infoDeskNum,
				"Information Desk",
				infoDeskQueueNum,
				width / 10,
				(height - serverHeight) / 2);
		ServerCard economy =
			new ServerCard(
				economyNum,
				"Economy Counter",
				economyQueueNum,
				(width - serverWidth) / 2,
				economyNum * 3 + height / 10);
		ServerCard business =
			new ServerCard(
				businessNum,
				"Business Counter",
				businessQueueNum,
				(width - serverWidth) / 2,
				(height - serverHeight) / 2);
		ServerCard first =
			new ServerCard(
				firstNum,
				"First Counter",
				firstQueueNum,
				(width - serverWidth) / 2,
				height - serverHeight - height / 10 - businessNum * 3);
		ServerCard gate =
			new ServerCard(
				gateNum,
				"Security Check",
				gateQueueNum,
				(width * 9) / 10 - serverWidth,
				(height - serverHeight) / 2);
		//\[X^VNƃT[o̐̕`
		source.drawSourceLine(
			g,
			informationDesk.endX(),
			informationDesk.endY());
		sink.drawSinkLine(g, width, gate.beginX(), gate.beginY());
		//T[oԂ̐̕`
		drawLineWithArrow(
			g,
			informationDesk.beginX(),
			informationDesk.beginY(),
			economy.endX(),
			economy.endY());
		drawLineWithArrow(
			g,
			informationDesk.beginX(),
			informationDesk.beginY(),
			business.endX(),
			business.endY());
		drawLineWithArrow(
			g,
			informationDesk.beginX(),
			informationDesk.beginY(),
			first.endX(),
			first.endY());
		int gateEndX = (business.beginX() + gate.endX()) / 2;
		int gateEndY = gate.endY();
		g.drawLine(economy.beginX(), economy.beginY(), gateEndX, gateEndY);
		drawLineWithArrow(
			g,
			business.beginX(),
			business.beginY(),
			gate.endX(),
			gate.endY());
		g.drawLine(first.beginX(), first.beginY(), gateEndX, gateEndY);
		//\[XƃVN̕`
		source.paintCard(g);
		sink.paintCard(g);
		//T[o̕`
		informationDesk.paintServerCards(this, g);
		economy.paintServerCards(this, g);
		business.paintServerCards(this, g);
		first.paintServerCards(this, g);
		gate.paintServerCards(this, g);
		//ړ̏q̕`
		informationDesk.paintMovingPassenger(
			g,
			movingToEconomy,
			economy.endX(),
			economy.endY());
		informationDesk.paintMovingPassenger(
			g,
			movingToBusiness,
			business.endX(),
			business.endY());
		informationDesk.paintMovingPassenger(
			g,
			movingToFirst,
			first.endX(),
			first.endY());
		business.paintMovingPassenger(
			g,
			movingToGate,
			gate.endX(),
			gate.endY());
	}

	public void printCsv() {
		int infoQ =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_InformationDesk);
		int economyQ =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_EconomyClass);
		int businessQ =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_BussinessClass);
		int firstQ =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Counter_FirstClass);
		int gateQ =
			AirportQueueDataGetter.getNumberOfQueuingPassengerToEachServer(
				world,
				QueueTheoryModel.AGENTTYPE_Gate);
		this.csvWriter.writeAveragePrice(
			infoQ,
			firstQ,
			businessQ,
			economyQ,
			gateQ);
	}

	/*************************************************************
				 * `
				 *************************************************************/

	public static void drawLineWithArrow(
		Graphics g,
		int beginX,
		int beginY,
		int endX,
		int endY) {
		//̑傫
		double arrowSize = 10.0;
		//̉s
		double sharpness = 3.0;
		double hypotenuseLength =
			Math.sqrt(
				Math.pow(Math.abs(beginX - endX), 2.0)
					+ Math.pow(Math.abs(beginY - endY), 2.0));
		double baseX = endX - (endX - beginX) * (arrowSize / hypotenuseLength);
		double baseY = endY - (endY - beginY) * (arrowSize / hypotenuseLength);
		//̍W擾
		double oneArrowX = baseX + (baseY - endY) / sharpness;
		double oneArrowY = baseY - (baseX - endX) / sharpness;
		double theOtherArrowX = baseX - (baseY - endY) / sharpness;
		double theOtherArrowY = baseY + (baseX - endX) / sharpness;
		//`
		g.drawLine(beginX, beginY, endX, endY);
		//̊e[`
		g.drawLine(endX, endY, (int) oneArrowX, (int) oneArrowY);
		g.drawLine(endX, endY, (int) theOtherArrowX, (int) theOtherArrowY);
	} /*************************************************************
						 * eXgspmain
						 *************************************************************/

	public static void main(String[] args) {
		JFrame jFrame = new JFrame();
		jFrame.setTitle("AirportQueueViewer");
		jFrame.setSize(new Dimension(750, 300));
		jFrame.getContentPane().setLayout(new BorderLayout());
		jFrame.getContentPane().add(
			new AirportQueuePanel(),
			BorderLayout.CENTER);
		jFrame.setVisible(true);
	}
}
