/**
 * AirportQueueViewer.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.awt.BorderLayout;
import java.awt.Dimension;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.besp.presentation.gui.AbstractInternalFrameComponent;

/**
 * @author tsuya
 * Created Date : 2003/10/18 16:58:23
 */
public class AirportQueueViewer
	extends AbstractInternalFrameComponent
	implements UpdateClockListener, ModelContainerListener, SimulationStateListener {

	private BorderLayout borderLayout = new BorderLayout();
	private AirportQueuePanel airportQueuePanel = new AirportQueuePanel();

	public AirportQueueViewer() {
		super();
		this.setTitle("AirportQueueViewer");
		this.setSize(new Dimension(740, 340));
		this.getContentPane().setLayout(borderLayout);
		this.getContentPane().add(airportQueuePanel, BorderLayout.CENTER);
	}

	/**
	 * TimeEventĂs
	 * @see org.boxed_economy.besp.model.fmfw.update.UpdateClockListener#clockGained(UpdateClockEvent)
	 */
	public void clockGained(UpdateClockEvent e) {
		airportQueuePanel.repaint();
		//airportQueuePanel.printCsv();
	}

	/**
	 * V~[V~i߂jɍs
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopped(SimulationStateEvent)
	 */
	public void simulationStopped(SimulationStateEvent ev) {
		airportQueuePanel.repaint();
	}

	/***********************************************
	 * TimeEventListenerǉE폜ifǂݍ݁Ejj
	 ***********************************************/

	/**
	 * fǂݍ܂ꂽɍs
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldOpened(ModelContainerEvent)
	 */
	public void worldOpened(ModelContainerEvent ev) {
		this.addUpdateClockListener(this);
		this.airportQueuePanel.setWorld(this.getWorld());
		this.airportQueuePanel.repaint();
	}

	/**
	 * fjꂽɍs
	 * @see org.boxed_economy.besp.model.ModelContainerListener#worldClosed(ModelContainerEvent)
	 */
	public void worldClosed(ModelContainerEvent ev) {
		this.removeUpdateClockListener(this);
		this.airportQueuePanel.setWorld(null);
		this.airportQueuePanel.repaint();
	}

	/***********************************************
	 * Ȃ\bh
	 ***********************************************/

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#initialize()
	 */
	public void initialize() {
	}

	/**
	 * @see org.boxed_economy.besp.presentation.PresentationComponent#terminate()
	 */
	public void terminate() {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldOpen(ModelContainerEvent)
	 */
	public void prepareWorldOpen(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.ModelContainerListener#prepareWorldClose(ModelContainerEvent)
	 */
	public void prepareWorldClose(ModelContainerEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStarted(SimulationStateEvent)
	 */
	public void simulationStarted(SimulationStateEvent ev) {
	}

	/**
	 * @see org.boxed_economy.besp.model.SimulationStateListener#simulationStopping(SimulationStateEvent)
	 */
	public void simulationStopping(SimulationStateEvent ev) {
	}

}
