/**
 * ServerCard.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.ImageIcon;
import javax.swing.JPanel;

/**
 * @author tsuya
 * Created Date : 2003/10/23 14:05:09
 */
public class ServerCard {

	private int serverNumber;
	private String serverName;
	private int queueNumber;
	private int xCoordinate;
	private int yCoordinate;
	private ImageIcon queueMember;

	public ServerCard(
		int serverNumber,
		String serverName,
		int queueNumber,
		int xCoodinate,
		int yCoodinate) {
		this.serverNumber = serverNumber;
		this.serverName = serverName;
		this.queueNumber = queueNumber;
		this.xCoordinate = xCoodinate;
		this.yCoordinate = yCoodinate;

		//Ă܂()
		Image image =
			ImageProvider.getInstance().getImage(
				"org/boxed_economy/queuetheory/model/presentation/passenger.gif");
		queueMember = new ImageIcon(image);
		//queueMember = new ImageIcon("passenger.gif");
	}

	public void paintServerCards(JPanel jPanel, Graphics g) {
		//J[h̕`
		for (int i = serverNumber - 1; 0 <= i; i--) {
			g.setColor(Color.black);
			g.fillRect(
				this.xCoordinate + i * 5,
				this.yCoordinate - i * 5,
				AirportQueuePanel.serverWidth,
				AirportQueuePanel.serverHeight);
			g.setColor(Color.white);
			g.fillRect(
				this.xCoordinate + i * 5 + 1,
				this.yCoordinate - i * 5 + 1,
				AirportQueuePanel.serverWidth - 2,
				AirportQueuePanel.serverHeight - 2);
		}
		//̕`
		g.setColor(Color.black);
		g.drawString(
			this.serverName,
			this.xCoordinate
				+ AirportQueuePanel.serverWidth / 2
				- this.serverName.length() * 3
				+ 7,
			this.yCoordinate + 14);

		//łl̕`
		g.setColor(Color.lightGray);
		g.fillRect(
			this.xCoordinate + 65 + 2,
			this.yCoordinate + AirportQueuePanel.serverHeight + 2,
			AirportQueuePanel.serverWidth - 65 - 4,
			AirportQueuePanel.serverHeight - 4);
		g.setColor(Color.black);
		g.drawString(
			"Wait : " + this.queueNumber,
			this.xCoordinate + AirportQueuePanel.serverWidth - 47,
			this.yCoordinate + AirportQueuePanel.serverHeight * 2 - 6);

		//łl̂܂̃Otŕ`
		//		if (this.queueNumber < 5) {
		//			g.setColor(Color.blue);
		//		} else if (this.queueNumber < 10) {
		//			g.setColor(Color.orange);
		//		} else {
		//			g.setColor(Color.red);
		//		}
		//		int graphWidth = this.queueNumber * AirportQueuePanel.serverWidth / 20;
		//		if (AirportQueuePanel.serverWidth - 4 < graphWidth) {
		//			graphWidth = AirportQueuePanel.serverWidth - 4;
		//		}
		//		g.fillRect(
		//			,
		//			graphWidth,
		//			3);

		for (int i = this.queueNumber; 0 < i; i--) {
			//		for (int i = 35; 0 < i; i--) {
			this.queueMember.paintIcon(
				jPanel,
				g,
				this.xCoordinate
					+ AirportQueuePanel.serverWidth
					- 54
					- this.queueMember.getIconWidth()
					- i * 5
					+ 3,
				this.yCoordinate + AirportQueuePanel.serverHeight + 6);
		}
	}

	public void paintMovingPassenger(
		Graphics g,
		int movingNumber,
		int x,
		int y) {
		int width = 50;
		int height = 16;
		int movingX = (this.beginX() + x) / 2 - width / 2;
		int movingY = (this.beginY() + y) / 2 - height / 2;
		g.setColor(Color.lightGray);
		g.fillRect(movingX, movingY, width, height);
		g.setColor(Color.black);
		g.drawString(
			"Move : " + movingNumber,
			movingX + 3,
			movingY + height / 2 + 4);
	}

	public int beginX() {
		return this.xCoordinate + AirportQueuePanel.serverWidth;
	}

	public int beginY() {
		return this.yCoordinate + AirportQueuePanel.serverHeight / 2;
	}

	public int endX() {
		return this.xCoordinate;
	}

	public int endY() {
		return this.yCoordinate + AirportQueuePanel.serverHeight / 2;
	}

}
