/**
 * SourceAndSinkCard.java
 * Copyright (c) 2003 Boxed-Economy Project. All rights reserved.
 */
package org.boxed_economy.queuetheory.model.presentation;

import java.awt.Color;
import java.awt.Graphics;

/**
 * @author tsuya
 * Created Date : 2003/10/23 16:28:30
 */
public class SourceAndSinkCard {

	private String name;
	private int xCoordinate;
	private int yCoordinate;

	public SourceAndSinkCard(String name, int xCoodinate, int yCoodinate) {
		this.name = name;
		this.xCoordinate = xCoodinate;
		this.yCoordinate = yCoodinate;
	}

	public void paintCard(Graphics g) {
		//\[X^VN̕`
		g.setColor(Color.black);
		g.fillOval(
			this.xCoordinate,
			this.yCoordinate,
			AirportQueuePanel.serverWidth,
			AirportQueuePanel.serverHeight);
		g.setColor(Color.white);
		g.fillOval(
			this.xCoordinate + 1,
			this.yCoordinate + 1,
			AirportQueuePanel.serverWidth - 2,
			AirportQueuePanel.serverHeight - 2);
		g.setColor(Color.black);
		g.drawString(
			this.name,
			this.xCoordinate
				+ AirportQueuePanel.serverWidth / 2
				- this.name.length() * 2
				- 5,
			this.yCoordinate + AirportQueuePanel.serverHeight / 2 + 5);
	}

	/**
	 * \[XƃCtH[VfXN̊Ԃ̐`悵܂
	 */
	public void drawSourceLine(Graphics g, int endX, int endY) {
		g.setColor(Color.black);
		g.drawLine(
			this.xCoordinate + AirportQueuePanel.serverWidth / 2,
			this.yCoordinate + AirportQueuePanel.serverHeight / 2 + 5,
			endX / 2,
			endY);
		AirportQueuePanel.drawLineWithArrow(g, endX / 2, endY, endX, endY);
	}

	/**
	 * ƃVN̊Ԃ̐`悵܂
	 */
	public void drawSinkLine(
		Graphics g,
		int panelWidth,
		int beginX,
		int beginY) {
		g.setColor(Color.black);
		g.drawLine(beginX, beginY, (beginX + panelWidth) / 2, beginY);
		AirportQueuePanel.drawLineWithArrow(
			g,
			(beginX + panelWidth) / 2,
			beginY,
			this.xCoordinate + AirportQueuePanel.serverWidth / 2,
			this.yCoordinate + AirportQueuePanel.serverHeight / 2 + 10);
	}

}
