(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3384281,      60494]*)
(*NotebookOutlinePosition[   3384948,      60517]*)
(*  CellTagsIndexPosition[   3384904,      60513]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\[FilledSquare]\ \ Fourier\ Series\)], "Input"],

Cell[BoxData[
    RowBox[{\(a \((n)\)\), "=", 
      RowBox[{\(1\/L\), 
        RowBox[{
          StyleBox[\(\[Integral]\_\(-L\)\%L\),
            ScriptLevel->0], 
          RowBox[{\(f[x]\), \(Cos[\(n\ \[Pi]\ x\)\/L]\), 
            StyleBox["\[ThinSpace]",
              ScriptLevel->0], 
            StyleBox[\(\[DifferentialD]x\),
              ScriptLevel->0]}]}]}]}]], "Input",
  FontColor->GrayLevel[0.100008],
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    RowBox[{\(b \((n)\)\), "=", 
      RowBox[{\(1\/L\), 
        RowBox[{
          StyleBox[\(\[Integral]\_\(-L\)\%L\),
            ScriptLevel->0], 
          RowBox[{\(f[x]\), \(Sin[\(n\ \[Pi]\ x\)\/L]\), 
            StyleBox["\[ThinSpace]",
              ScriptLevel->0], 
            StyleBox[\(\[DifferentialD]x\),
              ScriptLevel->0]}]}]}]}]], "Input",
  FontColor->GrayLevel[0.100008],
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(f[x] = 
      \(a \((0)\)\)\/2 + 
        \[Sum]\+\(n = 1\)\%\[Infinity]\((
            a \((n)\) Cos[\(n\ \[Pi]\ x\)\/L] + 
              b \((n)\) Sin[\(n\ \[Pi]\ x\)\/L])\)\)], "Input",
  FontColor->GrayLevel[0.100008],
  Background->GrayLevel[0.900008]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    StyleBox["Ex1",
      FontVariations->{"Underline"->True}]], "Input"],

Cell[BoxData[
    \(f[x_] := Which[\(-2\) Pi <= x < 0, \(-x\), 0 <= x < 2  Pi, x]\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[f[x], {x, \(-2\) Pi, \ 2  Pi}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.0147151 0.0936792 [
[.04527 .00222 -6 -9 ]
[.04527 .00222 6 0 ]
[.19685 .00222 -6 -9 ]
[.19685 .00222 6 0 ]
[.34842 .00222 -6 -9 ]
[.34842 .00222 6 0 ]
[.65158 .00222 -3 -9 ]
[.65158 .00222 3 0 ]
[.80315 .00222 -3 -9 ]
[.80315 .00222 3 0 ]
[.95473 .00222 -3 -9 ]
[.95473 .00222 3 0 ]
[.4875 .10839 -6 -4.5 ]
[.4875 .10839 0 4.5 ]
[.4875 .20207 -6 -4.5 ]
[.4875 .20207 0 4.5 ]
[.4875 .29575 -6 -4.5 ]
[.4875 .29575 0 4.5 ]
[.4875 .38943 -6 -4.5 ]
[.4875 .38943 0 4.5 ]
[.4875 .48311 -6 -4.5 ]
[.4875 .48311 0 4.5 ]
[.4875 .57679 -6 -4.5 ]
[.4875 .57679 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.04527 .01472 m
.04527 .02097 L
s
[(-6)] .04527 .00222 0 1 Mshowa
.19685 .01472 m
.19685 .02097 L
s
[(-4)] .19685 .00222 0 1 Mshowa
.34842 .01472 m
.34842 .02097 L
s
[(-2)] .34842 .00222 0 1 Mshowa
.65158 .01472 m
.65158 .02097 L
s
[(2)] .65158 .00222 0 1 Mshowa
.80315 .01472 m
.80315 .02097 L
s
[(4)] .80315 .00222 0 1 Mshowa
.95473 .01472 m
.95473 .02097 L
s
[(6)] .95473 .00222 0 1 Mshowa
.125 Mabswid
.08317 .01472 m
.08317 .01847 L
s
.12106 .01472 m
.12106 .01847 L
s
.15895 .01472 m
.15895 .01847 L
s
.23474 .01472 m
.23474 .01847 L
s
.27264 .01472 m
.27264 .01847 L
s
.31053 .01472 m
.31053 .01847 L
s
.38632 .01472 m
.38632 .01847 L
s
.42421 .01472 m
.42421 .01847 L
s
.46211 .01472 m
.46211 .01847 L
s
.53789 .01472 m
.53789 .01847 L
s
.57579 .01472 m
.57579 .01847 L
s
.61368 .01472 m
.61368 .01847 L
s
.68947 .01472 m
.68947 .01847 L
s
.72736 .01472 m
.72736 .01847 L
s
.76526 .01472 m
.76526 .01847 L
s
.84105 .01472 m
.84105 .01847 L
s
.87894 .01472 m
.87894 .01847 L
s
.91683 .01472 m
.91683 .01847 L
s
.00738 .01472 m
.00738 .01847 L
s
.99262 .01472 m
.99262 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .10839 m
.50625 .10839 L
s
[(1)] .4875 .10839 1 0 Mshowa
.5 .20207 m
.50625 .20207 L
s
[(2)] .4875 .20207 1 0 Mshowa
.5 .29575 m
.50625 .29575 L
s
[(3)] .4875 .29575 1 0 Mshowa
.5 .38943 m
.50625 .38943 L
s
[(4)] .4875 .38943 1 0 Mshowa
.5 .48311 m
.50625 .48311 L
s
[(5)] .4875 .48311 1 0 Mshowa
.5 .57679 m
.50625 .57679 L
s
[(6)] .4875 .57679 1 0 Mshowa
.125 Mabswid
.5 .03345 m
.50375 .03345 L
s
.5 .05219 m
.50375 .05219 L
s
.5 .07092 m
.50375 .07092 L
s
.5 .08966 m
.50375 .08966 L
s
.5 .12713 m
.50375 .12713 L
s
.5 .14587 m
.50375 .14587 L
s
.5 .1646 m
.50375 .1646 L
s
.5 .18334 m
.50375 .18334 L
s
.5 .22081 m
.50375 .22081 L
s
.5 .23955 m
.50375 .23955 L
s
.5 .25828 m
.50375 .25828 L
s
.5 .27702 m
.50375 .27702 L
s
.5 .31449 m
.50375 .31449 L
s
.5 .33322 m
.50375 .33322 L
s
.5 .35196 m
.50375 .35196 L
s
.5 .3707 m
.50375 .3707 L
s
.5 .40817 m
.50375 .40817 L
s
.5 .4269 m
.50375 .4269 L
s
.5 .44564 m
.50375 .44564 L
s
.5 .46438 m
.50375 .46438 L
s
.5 .50185 m
.50375 .50185 L
s
.5 .52058 m
.50375 .52058 L
s
.5 .53932 m
.50375 .53932 L
s
.5 .55805 m
.50375 .55805 L
s
.5 .59553 m
.50375 .59553 L
s
.5 .61426 m
.50375 .61426 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .55556 L
.10458 .50348 L
.14415 .45457 L
.18221 .40753 L
.22272 .35746 L
.26171 .30926 L
.30316 .25803 L
.34309 .20867 L
.3815 .16119 L
.42237 .11068 L
.46172 .06204 L
.48147 .03761 L
.49012 .02693 L
.49468 .02129 L
.49719 .01819 L
.49842 .01667 L
.49955 .01527 L
.50085 .01577 L
.50154 .01661 L
.50226 .01751 L
.50471 .02054 L
.5095 .02646 L
.51896 .03815 L
.53984 .06396 L
.57781 .11089 L
.61824 .16086 L
.65714 .20896 L
.6985 .26008 L
.73835 .30933 L
.77668 .35671 L
.81746 .40712 L
.85673 .45566 L
.89448 .50232 L
.93468 .55201 L
.97337 .59983 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{227, 140.188},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003S0000S1P00`40o`000?l0003ohoooo`004Ooo
o`80000Ooooo0`0001coool30000>oooo`<0000Noooo0`0001coool200004_ooo`004Oooo`030000
oooo000001ooool00`000?ooooooo`0Koooo00<0003oooooool0>oooo`030000oooooooo01ooool0
0`000?ooooooo`0Koooo00<0003oool000004Oooo`003?ooo`<00002oooo00<0003oool000006?oo
o`<00002oooo100001Ooool300000oooo`030000oooooooo03_oool00`000?ooooooo`0Loooo1000
01coool00`000?ooo`00000Aoooo000Aoooo0P0001koool00`000?ooo`00000Noooo00<0003ooooo
ool0>oooo`030000oooooooo01coool00`000?ooo`00000Moooo0P0001;oool0017oool00`000?oo
ooooo`0Noooo0P0001goool00`000?ooo`00000koooo00<0003oool000007_ooo`80000Moooo00<0
003oooooool04Oooo`004_ooo`80000Ooooo00<0003oooooool07?ooo`030000oooooooo03_oool0
0`000?ooooooo`0Noooo00<0003oooooool07?ooo`80000Aoooo003Soooo003Soooo001aoooo00<0
003oooooool0Koooo`00LOooo`030000oooooooo06ooool0077oool00`000?ooooooo`1_oooo0007
ooooe00000Soool000Soool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo0`0000Ooool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`07oooo001^oooo00<0003oooooool00`0006ooool006koool010000?oo
ooooo`0000;oool00`000?ooooooo`1/oooo001]oooo00D0003oooooooooool000000_ooo`030000
oooooooo06coool006goool01@000?ooooooooooo`000003oooo00<0003oooooool0Joooo`00K?oo
o`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool0J_ooo`00Joooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool0JOooo`00J_ooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool0JOooo`00JOooo`030000oooooooo00Goool0
0`000?ooooooo`04oooo00<0003oooooool0J?ooo`00J?ooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool0Ioooo`00Ioooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool0I_ooo`00I_ooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0
003oooooool0IOooo`00I_ooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003ooooo
ool0IOooo`00IOooo`030000oooooooo00Woool00`000?ooooooo`08oooo00<0003oooooool0I?oo
o`00I?ooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003oooooool0Hoooo`00Hooo
o`030000oooooooo00_oool00`000?ooooooo`0:oooo00<0003oooooool0H_ooo`00H_ooo`030000
oooooooo00coool00`000?ooooooo`0;oooo00<0003oooooool0HOooo`00H_ooo`030000oooooooo
00Coool500000oooo`030000oooooooo00_oool00`000?ooooooo`1Qoooo001Qoooo00<0003ooooo
ool01oooo`030000oooooooo00?oool00`000?ooooooo`0<oooo00<0003oooooool0H?ooo`00H?oo
o`030000oooooooo00Soool00`000?ooooooo`03oooo0P0000koool00`000?ooooooo`1Ooooo001O
oooo00<0003oooooool02Oooo`030000oooooooo00?oool00`000?ooooooo`0>oooo00<0003ooooo
ool0G_ooo`00G_ooo`030000oooooooo00[oool00`000?ooooooo`03oooo00<0003oooooool03_oo
o`030000oooooooo05koool005koool00`000?ooooooo`09oooo0P0000Goool00`000?ooooooo`0?
oooo00<0003oooooool0GOooo`00GOooo`030000oooooooo017oool00`000?ooooooo`0@oooo00<0
003oooooool0G?ooo`00G?ooo`030000oooooooo01;oool00`000?ooooooo`0Aoooo00<0003ooooo
ool0Foooo`00Foooo`030000oooooooo01?oool00`000?ooooooo`0Aoooo00<0003oooooool0Fooo
o`00F_ooo`030000oooooooo01Coool00`000?ooooooo`0Boooo00<0003oooooool0F_ooo`00FOoo
o`030000oooooooo01Goool00`000?ooooooo`0Coooo00<0003oooooool0FOooo`00FOooo`030000
oooooooo01Goool00`000?ooooooo`0Doooo00<0003oooooool0F?ooo`00F?ooo`030000oooooooo
01Koool00`000?ooooooo`0Doooo00<0003oooooool0F?ooo`00Eoooo`030000oooooooo01Ooool0
0`000?ooooooo`0Eoooo00<0003oooooool0Eoooo`00E_ooo`030000oooooooo01Soool00`000?oo
ooooo`0Foooo00<0003oooooool0E_ooo`00EOooo`030000oooooooo01Woool00`000?ooooooo`0G
oooo00<0003oooooool0EOooo`00EOooo`030000oooooooo01Woool00`000?ooooooo`0Hoooo00<0
003oooooool0E?ooo`00E?ooo`030000oooooooo01[oool00`000?ooooooo`0Ioooo00<0003ooooo
ool0Doooo`00Doooo`030000oooooooo01_oool00`000?ooooooo`0Joooo00<0003oooooool0D_oo
o`00D_ooo`030000oooooooo01coool00`000?ooooooo`0Joooo00<0003oooooool0D_ooo`00DOoo
o`030000oooooooo01Koool300001?ooo`030000oooooooo01_oool00`000?ooooooo`1Aoooo001A
oooo00<0003oooooool05_ooo`030000oooooooo00Coool00`000?ooooooo`0Loooo00<0003ooooo
ool0D?ooo`00D?ooo`030000oooooooo01Soool00`000?ooooooo`03oooo0P0001koool00`000?oo
ooooo`1?oooo001?oooo00<0003oooooool06Oooo`030000oooooooo00?oool00`000?ooooooo`0N
oooo00<0003oooooool0C_ooo`00C_ooo`030000oooooooo01Woool00`000?ooo`000004oooo00<0
003oooooool07oooo`030000oooooooo04goool004goool00`000?ooooooo`0Koooo00<0003ooooo
ool00oooo`030000oooooooo01ooool00`000?ooooooo`1=oooo001=oooo00<0003oooooool08Ooo
o`030000oooooooo023oool00`000?ooooooo`1<oooo001<oooo00<0003oooooool08_ooo`030000
oooooooo027oool00`000?ooooooo`1;oooo001;oooo00<0003oooooool08oooo`030000oooooooo
02;oool00`000?ooooooo`1:oooo001:oooo00<0003oooooool09?ooo`030000oooooooo02;oool0
0`000?ooooooo`1:oooo0019oooo00<0003oooooool09Oooo`030000oooooooo02?oool00`000?oo
ooooo`19oooo0019oooo00<0003oooooool09Oooo`030000oooooooo02Coool00`000?ooooooo`18
oooo0018oooo00<0003oooooool09_ooo`030000oooooooo02Goool00`000?ooooooo`17oooo0017
oooo00<0003oooooool09oooo`030000oooooooo02Goool00`000?ooooooo`17oooo0016oooo00<0
003oooooool0:?ooo`030000oooooooo02Koool00`000?ooooooo`16oooo0015oooo00<0003ooooo
ool0:Oooo`030000oooooooo02Ooool00`000?ooooooo`15oooo0015oooo00<0003oooooool0:Ooo
o`030000oooooooo02Soool00`000?ooooooo`14oooo0014oooo00<0003oooooool0:_ooo`030000
oooooooo02Woool00`000?ooooooo`13oooo0013oooo00<0003oooooool0:oooo`030000oooooooo
02[oool00`000?ooooooo`12oooo0012oooo00<0003oooooool09Oooo`800005oooo00<0003ooooo
ool0:oooo`030000oooooooo047oool0047oool00`000?ooooooo`0Xoooo00<0003oooooool00_oo
o`030000oooooooo02_oool00`000?ooooooo`11oooo0010oooo00<0003oooooool0:?ooo`030000
oooooooo00?oool20000;Oooo`030000oooooooo043oool0043oool00`000?ooooooo`0Yoooo00<0
003oooooool00_ooo`030000oooooooo02goool00`000?ooooooo`0ooooo000ooooo00<0003ooooo
ool0:?ooo`030000oooo000000Coool00`000?ooooooo`0^oooo00<0003oooooool0?_ooo`00?_oo
o`030000oooooooo02[oool00`000?ooooooo`03oooo00<0003oooooool0;oooo`030000oooooooo
03goool003goool00`000?ooooooo`0aoooo00<0003oooooool0<?ooo`030000oooooooo03coool0
03coool00`000?ooooooo`0boooo00<0003oooooool0<Oooo`030000oooooooo03_oool003coool0
0`000?ooooooo`0boooo00<0003oooooool0<Oooo`030000oooooooo03_oool003_oool00`000?oo
ooooo`0coooo00<0003oooooool0<_ooo`030000oooooooo03[oool003[oool00`000?ooooooo`0d
oooo00<0003oooooool0<oooo`030000oooooooo03Woool003Woool00`000?ooooooo`0eoooo00<0
003oooooool0=?ooo`030000oooooooo03Soool003Soool00`000?ooooooo`0foooo00<0003ooooo
ool0=Oooo`030000oooooooo03Ooool003Soool00`000?ooooooo`0foooo00<0003oooooool0=Ooo
o`030000oooooooo03Ooool003Ooool00`000?ooooooo`0goooo00<0003oooooool0=_ooo`030000
oooooooo03Koool003Koool00`000?ooooooo`0hoooo00<0003oooooool0=oooo`030000oooooooo
03Goool003Goool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`030000oooooooo03Coool0
03Coool00`000?ooooooo`0joooo00<0003oooooool0>Oooo`030000oooooooo03?oool003Coool0
0`000?ooooooo`0joooo00<0003oooooool0>Oooo`030000oooooooo03?oool003?oool00`000?oo
ooooo`0koooo00<0003oooooool0>_ooo`030000oooooooo03;oool003;oool00`000?ooooooo`0f
oooo0`0000?oool00`000?ooooooo`0koooo00<0003oooooool0<Oooo`00<Oooo`030000oooooooo
03Soool00`000?ooooooo`02oooo00<0003oooooool0??ooo`030000oooooooo033oool0033oool0
0`000?ooooooo`0goooo100000?oool20000?_ooo`030000oooooooo02ooool002ooool00`000?oo
ooooo`0hoooo00<0003oool000001?ooo`030000oooooooo03koool00`000?ooooooo`0^oooo000_
oooo00<0003oooooool0>Oooo`800004oooo00<0003oooooool0?_ooo`030000oooooooo02koool0
02koool00`000?ooooooo`0koooo00<0003oooooool00_ooo`030000oooooooo03ooool00`000?oo
ooooo`0]oooo000]oooo00<0003oooooool0@Oooo`030000oooooooo043oool00`000?ooooooo`0/
oooo000/oooo00<0003oooooool0@_ooo`030000oooooooo047oool00`000?ooooooo`0[oooo000[
oooo00<0003oooooool0@oooo`030000oooooooo04;oool00`000?ooooooo`0Zoooo000[oooo00<0
003oooooool0@oooo`030000oooooooo04;oool00`000?ooooooo`0Zoooo000Zoooo00<0003ooooo
ool0A?ooo`030000oooooooo04?oool00`000?ooooooo`0Yoooo000Yoooo00<0003oooooool0AOoo
o`030000oooooooo04Coool00`000?ooooooo`0Xoooo000Xoooo00<0003oooooool0A_ooo`030000
oooooooo04Goool00`000?ooooooo`0Woooo000Woooo00<0003oooooool0Aoooo`030000oooooooo
04Koool00`000?ooooooo`0Voooo000Woooo00<0003oooooool0Aoooo`030000oooooooo04Koool0
0`000?ooooooo`0Voooo000Voooo00<0003oooooool0B?ooo`030000oooooooo04Ooool00`000?oo
ooooo`0Uoooo000Uoooo00<0003oooooool0BOooo`030000oooooooo04Soool00`000?ooooooo`0T
oooo000Toooo00<0003oooooool0B_ooo`030000oooooooo04Woool00`000?ooooooo`0Soooo000S
oooo00<0003oooooool0Boooo`030000oooooooo04[oool00`000?ooooooo`0Roooo000Soooo00<0
003oooooool0Boooo`030000oooooooo04[oool00`000?ooooooo`0Roooo000Roooo00<0003ooooo
ool0A_ooo`030000oooooooo00?oool00`000?ooooooo`1;oooo00<0003oooooool08Oooo`008Ooo
o`030000oooooooo04Koool00`000?ooo`000004oooo00<0003oooooool0C?ooo`030000oooooooo
023oool0023oool00`000?ooooooo`19oooo00<0003oooooool00_ooo`80001>oooo00<0003ooooo
ool07oooo`007oooo`030000oooooooo04Soool200001Oooo`030000oooooooo04koool00`000?oo
ooooo`0Noooo000Ooooo00<0003oooooool0B?ooo`030000oooooooo00Coool00`000?ooooooo`1>
oooo00<0003oooooool07_ooo`007_ooo`030000oooooooo04Woool300001?ooo`030000oooooooo
04ooool00`000?ooooooo`0Moooo000Moooo00<0003oooooool0DOooo`030000oooooooo053oool0
0`000?ooooooo`0Loooo000Loooo00<0003oooooool0D_ooo`030000oooooooo057oool00`000?oo
ooooo`0Koooo000Koooo00<0003oooooool0Doooo`030000oooooooo057oool00`000?ooooooo`0K
oooo000Koooo00<0003oooooool0Doooo`030000oooooooo05;oool00`000?ooooooo`0Joooo000J
oooo00<0003oooooool0E?ooo`030000oooooooo05?oool00`000?ooooooo`0Ioooo000Ioooo00<0
003oooooool0EOooo`030000oooooooo05Coool00`000?ooooooo`0Hoooo000Hoooo00<0003ooooo
ool0E_ooo`030000oooooooo05Coool00`000?ooooooo`0Hoooo000Goooo00<0003oooooool0Eooo
o`030000oooooooo05Goool00`000?ooooooo`0Goooo000Foooo00<0003oooooool0F?ooo`030000
oooooooo05Koool00`000?ooooooo`0Foooo000Foooo00<0003oooooool0F?ooo`030000oooooooo
05Ooool00`000?ooooooo`0Eoooo000Eoooo00<0003oooooool0FOooo`030000oooooooo05Ooool0
0`000?ooooooo`0Eoooo000Doooo00<0003oooooool0F_ooo`030000oooooooo05Soool00`000?oo
ooooo`0Doooo000Coooo00<0003oooooool0Foooo`030000oooooooo05Woool00`000?ooooooo`0C
oooo000Boooo00<0003oooooool0G?ooo`030000oooooooo05[oool00`000?ooooooo`0Boooo000B
oooo00<0003oooooool0EOooo`800005oooo00<0003oooooool0Foooo`030000oooooooo017oool0
017oool00`000?ooooooo`1Foooo00<0003oool000001?ooo`030000oooooooo05coool00`000?oo
ooooo`0@oooo000@oooo00<0003oooooool0Eoooo`030000oooo000000Coool20000G_ooo`030000
oooooooo00ooool000ooool00`000?ooooooo`1Hoooo0P0000Goool00`000?ooooooo`1Moooo00<0
003oooooool03oooo`003_ooo`030000oooooooo05Woool00`000?ooooooo`04oooo00<0003ooooo
ool0G_ooo`030000oooooooo00koool000koool00`000?ooooooo`1Joooo0P0000Coool00`000?oo
ooooo`1Ooooo00<0003oooooool03Oooo`003Oooo`030000oooooooo067oool00`000?ooooooo`1P
oooo00<0003oooooool03?ooo`003?ooo`030000oooooooo06;oool00`000?ooooooo`1Qoooo00<0
003oooooool02oooo`00LOooo`030000oooooooo06ooool0077oool00`000?ooooooo`1_oooo001a
oooo00<0003oooooool0Koooo`00\
\>"],
  ImageRangeCache->{{{0, 226}, {139.188, 0}} -> {-7.05276, -0.587859, 
  0.0624138, 0.0504939}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(S[n_, x_] := 
      1 - \(8\/Pi\^2\) 
          \(\[Sum]\+\(i = 0\)\%n\( 1\/\((2  i + 1)\)\^2\) 
              Cos[\(\((2  i + 1)\) x\)\/2]\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[S[10, x], {x, \(-8\), 8}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0595238 0.0147151 0.297036 [
[.05357 .00222 -12 -9 ]
[.05357 .00222 12 0 ]
[.20238 .00222 -6 -9 ]
[.20238 .00222 6 0 ]
[.35119 .00222 -12 -9 ]
[.35119 .00222 12 0 ]
[.64881 .00222 -9 -9 ]
[.64881 .00222 9 0 ]
[.79762 .00222 -3 -9 ]
[.79762 .00222 3 0 ]
[.94643 .00222 -9 -9 ]
[.94643 .00222 9 0 ]
[.4875 .16323 -18 -4.5 ]
[.4875 .16323 0 4.5 ]
[.4875 .31175 -6 -4.5 ]
[.4875 .31175 0 4.5 ]
[.4875 .46027 -18 -4.5 ]
[.4875 .46027 0 4.5 ]
[.4875 .60879 -6 -4.5 ]
[.4875 .60879 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.05357 .01472 m
.05357 .02097 L
s
[(-7.5)] .05357 .00222 0 1 Mshowa
.20238 .01472 m
.20238 .02097 L
s
[(-5)] .20238 .00222 0 1 Mshowa
.35119 .01472 m
.35119 .02097 L
s
[(-2.5)] .35119 .00222 0 1 Mshowa
.64881 .01472 m
.64881 .02097 L
s
[(2.5)] .64881 .00222 0 1 Mshowa
.79762 .01472 m
.79762 .02097 L
s
[(5)] .79762 .00222 0 1 Mshowa
.94643 .01472 m
.94643 .02097 L
s
[(7.5)] .94643 .00222 0 1 Mshowa
.125 Mabswid
.08333 .01472 m
.08333 .01847 L
s
.1131 .01472 m
.1131 .01847 L
s
.14286 .01472 m
.14286 .01847 L
s
.17262 .01472 m
.17262 .01847 L
s
.23214 .01472 m
.23214 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.29167 .01472 m
.29167 .01847 L
s
.32143 .01472 m
.32143 .01847 L
s
.38095 .01472 m
.38095 .01847 L
s
.41071 .01472 m
.41071 .01847 L
s
.44048 .01472 m
.44048 .01847 L
s
.47024 .01472 m
.47024 .01847 L
s
.52976 .01472 m
.52976 .01847 L
s
.55952 .01472 m
.55952 .01847 L
s
.58929 .01472 m
.58929 .01847 L
s
.61905 .01472 m
.61905 .01847 L
s
.67857 .01472 m
.67857 .01847 L
s
.70833 .01472 m
.70833 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.76786 .01472 m
.76786 .01847 L
s
.82738 .01472 m
.82738 .01847 L
s
.85714 .01472 m
.85714 .01847 L
s
.8869 .01472 m
.8869 .01847 L
s
.91667 .01472 m
.91667 .01847 L
s
.02381 .01472 m
.02381 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .16323 m
.50625 .16323 L
s
[(0.5)] .4875 .16323 1 0 Mshowa
.5 .31175 m
.50625 .31175 L
s
[(1)] .4875 .31175 1 0 Mshowa
.5 .46027 m
.50625 .46027 L
s
[(1.5)] .4875 .46027 1 0 Mshowa
.5 .60879 m
.50625 .60879 L
s
[(2)] .4875 .60879 1 0 Mshowa
.125 Mabswid
.5 .04442 m
.50375 .04442 L
s
.5 .07412 m
.50375 .07412 L
s
.5 .10383 m
.50375 .10383 L
s
.5 .13353 m
.50375 .13353 L
s
.5 .19294 m
.50375 .19294 L
s
.5 .22264 m
.50375 .22264 L
s
.5 .25234 m
.50375 .25234 L
s
.5 .28205 m
.50375 .28205 L
s
.5 .34145 m
.50375 .34145 L
s
.5 .37116 m
.50375 .37116 L
s
.5 .40086 m
.50375 .40086 L
s
.5 .43057 m
.50375 .43057 L
s
.5 .48997 m
.50375 .48997 L
s
.5 .51968 m
.50375 .51968 L
s
.5 .54938 m
.50375 .54938 L
s
.5 .57908 m
.50375 .57908 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .44645 m
.06244 .50744 L
.08255 .54044 L
.10458 .57427 L
.11448 .59234 L
.11733 .59677 L
.11873 .59862 L
.12002 .60009 L
.12117 .60119 L
.12244 .60215 L
.12372 .60283 L
.12441 .60308 L
.12507 .60324 L
.12624 .60331 L
.12753 .6031 L
.12874 .60262 L
.12987 .60194 L
.13098 .60105 L
.13199 .60007 L
.13426 .59734 L
.13935 .58916 L
.14415 .58027 L
.1827 .51831 L
.22371 .45333 L
.26319 .39092 L
.30116 .33075 L
.34159 .26655 L
.3805 .20455 L
.42186 .13844 L
.4617 .07516 L
.47992 .0468 L
.48491 .03751 L
.48754 .03277 L
.4903 .02825 L
.49272 .02489 L
.49401 .02343 L
.49538 .02214 L
.49664 .02123 L
.49779 .02064 L
.49894 .02029 L
.50003 .02018 L
.50118 .02031 L
.50243 .02073 L
.50374 .02148 L
.50497 .02244 L
.50716 .02475 L
.50952 .02797 L
.51981 .04631 L
.54082 .07895 L
.58209 .14488 L
Mistroke
.62185 .2084 L
.6601 .26926 L
.7008 .3338 L
.73998 .3958 L
.78161 .4617 L
.82173 .52573 L
.84015 .55477 L
.85059 .5708 L
.86033 .58859 L
.86271 .59273 L
.86529 .59672 L
.86757 .5996 L
.86881 .60087 L
.86998 .60183 L
.87068 .6023 L
.87132 .60265 L
.87203 .60296 L
.87279 .60318 L
.87406 .60332 L
.87469 .60327 L
.87539 .60314 L
.87662 .60268 L
.87794 .60189 L
.87918 .60087 L
.88031 .59973 L
.88552 .59234 L
.89116 .58212 L
.90139 .5643 L
.94236 .50017 L
.97619 .44645 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{242, 149.438},
  ImageMargins->{{42, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003b0000UAP00`40o`000?l0003ol_ooo`004_oo
o`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool06Oooo`030000oooooooo
01Soool300000oooo`030000oooooooo00;oool00`000?ooooooo`0boooo0`0000?oool00`000?oo
ooooo`02oooo00<0003oooooool06Oooo`030000oooooooo01Woool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`030000oooooooo00ooool001;oool00`000?ooooooo`06oooo00<0003oool0
00006Oooo`030000oooo000001Woool00`000?ooooooo`07oooo00<0003oool00000<oooo`030000
oooooooo00Ooool00`000?ooo`00000Ioooo00<0003oool000006_ooo`030000oooooooo00Koool0
0`000?ooo`00000@oooo000<oooo0`0000?oool00`000?ooooooo`08oooo00<0003oooooool04_oo
o`<00004oooo00<0003oooooool04_ooo`<00003oooo00<0003oooooool02?ooo`030000oooooooo
03;oool00`000?ooooooo`08oooo00<0003oooooool06Oooo`030000oooooooo01Soool00`000?oo
ooooo`08oooo00<0003oooooool03_ooo`004oooo`030000oooooooo00Goool200006_ooo`80000K
oooo00<0003oooooool01_ooo`80000eoooo00<0003oooooool01_ooo`80000Joooo0P0001coool0
0`000?ooooooo`05oooo0P00017oool0017oool00`000?ooo`000007oooo00<0003oooooool06Ooo
o`030000oooooooo01Woool00`000?ooo`000007oooo00<0003oooooool0<oooo`030000oooo0000
00Ooool00`000?ooooooo`0Ioooo00<0003oooooool06Oooo`030000oooo000000Ooool00`000?oo
ooooo`0@oooo000Aoooo0`0000Ooool300006Oooo`<0000Joooo00<0003oooooool01_ooo`<0000d
oooo00<0003oooooool01_ooo`<0000Ioooo0`0001Woool300001oooo`<0000@oooo003boooo003b
oooo001hoooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo07Ooool007Soool00`000?oo
ooooo`1goooo0009oooog`0000[oool000koool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo0`0000Goool00`000?oo
ooooo`03oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool01?oo
o`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool00`000?oo
ooooo`0=oooo001foooo1@0007Ooool007Koool01@000?ooo`000?ooo`00001goooo001eoooo00@0
003oooooool00002oooo00<0003oooooool0M?ooo`00MOooo`040000oooooooo00000_ooo`030000
oooooooo07Coool007Coool010000?ooooooooooo`800002oooo00<0003oooooool0Loooo`00M?oo
o`050000oooooooooooo000000?oool00`000?ooooooo`1coooo001coooo00<0003oooooool00_oo
o`030000oooooooo00;oool00`000?ooooooo`1boooo001coooo00<0003oooooool00_ooo`030000
oooooooo00;oool00`000?ooooooo`1boooo001boooo00<0003oooooool00oooo`030000oooooooo
00?oool00`000?ooooooo`1aoooo001aoooo00<0003oooooool01?ooo`030000oooooooo00Coool0
0`000?ooooooo`1`oooo001aoooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?oo
ooooo`1_oooo001`oooo00<0003oooooool01Oooo`800006oooo00<0003oooooool0Koooo`00Kooo
o`030000oooooooo00Koool00`000?ooooooo`06oooo00<0003oooooool0K_ooo`00Koooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool0KOooo`00K_ooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool0KOooo`00KOooo`030000oooooooo00Soool0
0`000?ooooooo`08oooo00<0003oooooool0K?ooo`00KOooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool0K?ooo`00K?ooo`030000oooooooo00Woool00`000?ooooooo`09
oooo00<0003oooooool0Joooo`00Joooo`030000oooooooo00[oool200002oooo`030000oooooooo
06[oool006_oool00`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo06[oool0
06[oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo06Woool006[oool0
0`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo06Woool006Woool00`000?oo
ooooo`0<oooo00<0003oooooool03?ooo`030000oooooooo06Soool006Soool00`000?ooooooo`0=
oooo00<0003oooooool03Oooo`030000oooooooo06Ooool006Soool00`000?ooooooo`0=oooo0P00
00koool00`000?ooooooo`1Woooo001Woooo00<0003oooooool03_ooo`030000oooooooo00koool0
0`000?ooooooo`1Voooo001Voooo00<0003oooooool03oooo`030000oooooooo00koool00`000?oo
ooooo`1Voooo001Voooo00<0003oooooool03oooo`030000oooooooo00ooool00`000?ooooooo`1U
oooo001Uoooo00<0003oooooool04?ooo`030000oooooooo013oool00`000?ooooooo`1Toooo001T
oooo00D0003oooooooooool000001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool04?ooo`030000oooooooo06Coool006Coool01P000?ooooooo`000?ooo`0000Ooool0
0`000?ooo`000004oooo00<0003oooooool04Oooo`030000oooooooo06?oool006?oool01`000?oo
ooooooooo`000?ooo`000009oooo00<0003oooooool00_ooo`80000Coooo00<0003oooooool0H_oo
o`00H_ooo`030000oooooooo00;oool00`000?ooo`000007oooo0P0000Goool00`000?ooooooo`0B
oooo00<0003oooooool0H_ooo`00H_ooo`030000oooooooo00;oool00`000?ooo`000007oooo00<0
003oooooool01?ooo`030000oooooooo01?oool00`000?ooooooo`1Qoooo001Qoooo00<0003ooooo
ool01?ooo`030000oooooooo00Koool300001?ooo`030000oooooooo01Coool00`000?ooooooo`1P
oooo001Poooo00<0003oooooool05Oooo`030000oooooooo01Coool00`000?ooooooo`1Poooo001P
oooo00<0003oooooool05Oooo`030000oooooooo01Goool00`000?ooooooo`1Ooooo001Ooooo00<0
003oooooool05_ooo`80000Foooo00<0003oooooool0Goooo`00G_ooo`030000oooooooo01Ooool0
0`000?ooooooo`0Foooo00<0003oooooool0G_ooo`00G_ooo`030000oooooooo01Ooool00`000?oo
ooooo`0Goooo00<0003oooooool0GOooo`00GOooo`030000oooooooo01Soool00`000?ooooooo`0G
oooo00<0003oooooool0GOooo`00G?ooo`030000oooooooo01Woool00`000?ooooooo`0Hoooo00<0
003oooooool0G?ooo`00G?ooo`030000oooooooo01Woool00`000?ooooooo`0Ioooo00<0003ooooo
ool0Foooo`00Foooo`030000oooooooo01[oool00`000?ooooooo`0Ioooo00<0003oooooool0Fooo
o`00Foooo`030000oooooooo01[oool200006oooo`030000oooooooo05[oool005[oool00`000?oo
ooooo`0Koooo00<0003oooooool06oooo`030000oooooooo05Woool005[oool00`000?ooooooo`0K
oooo00<0003oooooool06oooo`030000oooooooo05Woool005Woool00`000?ooooooo`0Loooo00<0
003oooooool07?ooo`030000oooooooo05Soool005Soool00`000?ooooooo`0Moooo00<0003ooooo
ool07Oooo`030000oooooooo05Ooool005Soool00`000?ooooooo`0Moooo00<0003oooooool07_oo
o`030000oooooooo05Koool005Ooool00`000?ooooooo`0Noooo00<0003oooooool07_ooo`030000
oooooooo05Koool005Ooool00`000?ooooooo`0Noooo0P00023oool00`000?ooooooo`1Eoooo001F
oooo00<0003oooooool07oooo`030000oooooooo023oool00`000?ooooooo`1Doooo001Foooo00<0
003oooooool07oooo`030000oooooooo023oool00`000?ooooooo`1Doooo001Eoooo00<0003ooooo
ool08?ooo`030000oooooooo027oool00`000?ooooooo`1Coooo001Doooo00<0003oooooool08Ooo
o`030000oooooooo02;oool00`000?ooooooo`1Boooo001Doooo00<0003oooooool08Oooo`030000
oooooooo02;oool00`000?ooooooo`1Boooo001Coooo00<0003oooooool08_ooo`80000Toooo00<0
003oooooool0DOooo`00D_ooo`030000oooooooo02?oool00`000?ooooooo`0Soooo00<0003ooooo
ool0DOooo`00D_ooo`030000oooooooo02?oool00`000?ooooooo`0Toooo00<0003oooooool0D?oo
o`00DOooo`030000oooooooo02Coool00`000?ooooooo`0Uoooo00<0003oooooool0Coooo`00D?oo
o`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool0Coooo`00D?ooo`030000
oooooooo01goool500000oooo`030000oooooooo02Koool00`000?ooooooo`1>oooo001?oooo00<0
003oooooool08?ooo`030000oooooooo00?oool00`000?ooooooo`0Voooo00<0003oooooool0C_oo
o`00Coooo`030000oooooooo023oool00`000?ooooooo`03oooo0P0002Soool00`000?ooooooo`1=
oooo001>oooo00<0003oooooool08Oooo`030000oooooooo00?oool00`000?ooooooo`0Xoooo00<0
003oooooool0C?ooo`00COooo`030000oooooooo02;oool00`000?ooooooo`03oooo00<0003ooooo
ool0:?ooo`030000oooooooo04coool004goool00`000?ooooooo`0Qoooo0P0000Goool00`000?oo
ooooo`0Yoooo00<0003oooooool0Boooo`00C?ooo`030000oooooooo02Woool00`000?ooooooo`0Y
oooo00<0003oooooool0Boooo`00Boooo`030000oooooooo02[oool00`000?ooooooo`0Zoooo00<0
003oooooool0B_ooo`00Boooo`030000oooooooo02[oool00`000?ooooooo`0[oooo00<0003ooooo
ool0BOooo`00B_ooo`030000oooooooo02_oool20000;?ooo`030000oooooooo04Woool004Woool0
0`000?ooooooo`0/oooo00<0003oooooool0;?ooo`030000oooooooo04Soool004Woool00`000?oo
ooooo`0/oooo00<0003oooooool0;?ooo`030000oooooooo04Soool004Soool00`000?ooooooo`0]
oooo00<0003oooooool0;Oooo`030000oooooooo04Ooool004Ooool00`000?ooooooo`0^oooo00<0
003oooooool0;Oooo`030000oooooooo04Ooool004Ooool00`000?ooooooo`0^oooo00<0003ooooo
ool0;_ooo`030000oooooooo04Koool004Koool00`000?ooooooo`0_oooo0P00033oool00`000?oo
ooooo`15oooo0016oooo00<0003oooooool0;oooo`030000oooooooo02ooool00`000?ooooooo`15
oooo0015oooo00<0003oooooool0<?ooo`030000oooooooo033oool00`000?ooooooo`14oooo0014
oooo00<0003oooooool0<Oooo`030000oooooooo033oool00`000?ooooooo`14oooo0014oooo00<0
003oooooool0<Oooo`030000oooooooo037oool00`000?ooooooo`13oooo0013oooo00<0003ooooo
ool0<_ooo`030000oooooooo037oool00`000?ooooooo`13oooo0012oooo00<0003oooooool0<ooo
o`030000oooooooo03;oool00`000?ooooooo`12oooo0012oooo00<0003oooooool0<oooo`80000d
oooo00<0003oooooool0@Oooo`00@Oooo`030000oooooooo03Coool00`000?ooooooo`0coooo00<0
003oooooool0@Oooo`00@Oooo`030000oooooooo03Coool00`000?ooooooo`0doooo00<0003ooooo
ool0@?ooo`00@?ooo`030000oooooooo03Goool00`000?ooooooo`0eoooo00<0003oooooool0?ooo
o`00?oooo`030000oooooooo03Koool00`000?ooooooo`0foooo00<0003oooooool0?_ooo`00?ooo
o`030000oooooooo03Koool00`000?ooooooo`0foooo00<0003oooooool0?_ooo`00?_ooo`030000
oooooooo03Ooool20000>?ooo`030000oooooooo03goool003goool00`000?ooooooo`0hoooo00<0
003oooooool0>?ooo`030000oooooooo03coool003goool00`000?ooooooo`0hoooo00<0003ooooo
ool0>?ooo`030000oooooooo03coool003coool00`000?ooooooo`0ioooo00<0003oooooool0>Ooo
o`030000oooooooo03_oool000koool00`000?ooooooo`0[oooo00<0003oooooool0>Oooo`030000
oooooooo03[oool00`000?ooooooo`0Zoooo00<0003oooooool03Oooo`003oooo`030000oooooooo
02Woool00`000?ooooooo`0Xoooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo03_oool00`000?ooooooo`0Xoooo00<0003oooooool03_ooo`003oooo`030000
oooooooo02Soool00`000?ooooooo`0[oooo00<0003oooooool01_ooo`030000oooo000000Coool0
0`000?ooooooo`0koooo00<0003oooooool0:?ooo`030000oooooooo00koool0013oool00`000?oo
ooooo`0Woooo00<0003oooooool0:oooo`030000oooooooo00Soool00`000?ooooooo`02oooo0P00
03goool00`000?ooooooo`0Voooo00<0003oooooool03oooo`004Oooo`030000oooooooo02Goool0
0`000?ooooooo`0/oooo00<0003oooooool01_ooo`800005oooo00<0003oooooool0?Oooo`030000
oooooooo02Coool00`000?ooooooo`0@oooo000Aoooo00<0003oooooool09?ooo`030000oooooooo
02goool00`000?ooooooo`06oooo00<0003oooooool01?ooo`030000oooooooo03goool00`000?oo
ooooo`0Toooo00<0003oooooool04?ooo`004_ooo`030000oooooooo02?oool00`000?ooooooo`0/
oooo0P0000Soool300001?ooo`030000oooooooo03koool00`000?ooooooo`0Roooo00<0003ooooo
ool04Oooo`004oooo`030000oooooooo027oool00`000?ooooooo`0noooo00<0003oooooool0?_oo
o`030000oooooooo027oool00`000?ooooooo`0Boooo000Doooo00<0003oooooool07oooo`030000
oooooooo03ooool00`000?ooooooo`0ooooo00<0003oooooool08?ooo`030000oooooooo01;oool0
01Coool00`000?ooooooo`0Ooooo00<0003oooooool0?oooo`030000oooooooo043oool00`000?oo
ooooo`0Noooo00<0003oooooool04oooo`005Oooo`030000oooooooo01goool00`000?ooooooo`10
oooo0P00047oool00`000?ooooooo`0Moooo00<0003oooooool05?ooo`005_ooo`030000oooooooo
01_oool00`000?ooooooo`11oooo00<0003oooooool0@Oooo`030000oooooooo01coool00`000?oo
ooooo`0Doooo000Foooo00<0003oooooool06oooo`030000oooooooo047oool00`000?ooooooo`11
oooo00<0003oooooool06oooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Ioooo00<0
003oooooool0@_ooo`030000oooooooo04;oool00`000?ooooooo`0Ioooo00<0003oooooool05_oo
o`006?ooo`030000oooooooo01Ooool00`000?ooooooo`13oooo00<0003oooooool0@oooo`030000
oooooooo01Soool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool05oooo`030000oooooooo
04?oool00`000?ooooooo`13oooo00<0003oooooool05oooo`030000oooooooo01Ooool001Woool0
0`000?ooooooo`0Eoooo00<0003oooooool0A?ooo`800015oooo00<0003oooooool05Oooo`030000
oooooooo01Soool001Woool00`000?ooooooo`0Doooo00<0003oooooool0AOooo`030000oooooooo
04Coool00`000?ooooooo`0Eoooo00<0003oooooool06?ooo`006_ooo`030000oooooooo01?oool0
0`000?ooooooo`15oooo00<0003oooooool0AOooo`030000oooooooo01?oool00`000?ooooooo`0I
oooo000Joooo00<0003oooooool04_ooo`030000oooooooo04Koool00`000?ooooooo`16oooo00<0
003oooooool04Oooo`030000oooooooo01[oool001_oool00`000?ooooooo`0Aoooo00<0003ooooo
ool0A_ooo`030000oooooooo04Koool00`000?ooooooo`0Aoooo00<0003oooooool06_ooo`006ooo
o`030000oooooooo013oool00`000?ooooooo`17oooo00<0003oooooool0Aoooo`030000oooooooo
00ooool00`000?ooooooo`0Koooo000Loooo00<0003oooooool03oooo`030000oooooooo04Ooool0
0`000?ooooooo`18oooo00<0003oooooool03_ooo`030000oooooooo01_oool001coool00`000?oo
ooooo`0>oooo00<0003oooooool0B?ooo`800019oooo00<0003oooooool03Oooo`030000oooooooo
01coool001goool00`000?ooooooo`0<oooo00<0003oooooool0BOooo`030000oooooooo04Woool0
0`000?ooooooo`0;oooo00<0003oooooool07Oooo`007_ooo`030000oooooooo00_oool00`000?oo
ooooo`19oooo00<0003oooooool0B_ooo`030000oooooooo00[oool00`000?ooooooo`0Moooo000O
oooo00<0003oooooool02Oooo`030000oooooooo04[oool00`000?ooooooo`1:oooo00<0003ooooo
ool02Oooo`030000oooooooo01koool001ooool00`000?ooooooo`09oooo00<0003oooooool0B_oo
o`030000oooooooo04_oool00`000?ooooooo`07oooo00<0003oooooool07oooo`008?ooo`030000
oooooooo00Ooool00`000?ooooooo`1;oooo00<0003oooooool0Boooo`030000oooooooo00Ooool0
0`000?ooooooo`0Ooooo000Qoooo00<0003oooooool01_ooo`030000oooooooo04_oool20000COoo
o`030000oooooooo00Goool00`000?ooooooo`0Poooo000Qoooo00<0003oooooool01Oooo`030000
oooooooo04coool00`000?ooooooo`1<oooo00<0003oooooool01Oooo`030000oooooooo023oool0
02;oool00`000?ooooooo`03oooo00<0003oooooool0COooo`030000oooooooo04goool00`000?oo
ooooo`03oooo00<0003oooooool08Oooo`008_ooo`030000oooooooo00?oool00`000?ooooooo`1=
oooo00<0003oooooool0COooo`800004oooo00<0003oooooool08Oooo`008oooo`050000oooooooo
oooo0000053oool00`000?ooooooo`1>oooo00D0003oooooooooool000009?ooo`008oooo`800000
0oooo`000?ooo`19oooo0`0000Coool00`000?ooooooo`1?oooo00@0003oool00000000Toooo000T
oooo0P0004_oool00`000?ooooooo`04oooo00<0003oooooool0D?ooo`80000Uoooo001boooo00<0
003oooooool00oooo`80001hoooo001boooo00<0003oooooool00oooo`030000oooooooo07Ooool0
077oool00`000?ooo`000004oooo00<0003oooooool0Moooo`00L_ooo`030000oooooooo07goool0
0?;oool00001\
\>"],
  ImageRangeCache->{{{0, 241}, {148.438, 0}} -> {-9.10329, -0.178279, 
  0.07552, 0.0151336}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    StyleBox["Ex2",
      FontVariations->{"Underline"->True}]], "Input"],

Cell[BoxData[
    \(f[x_] := Which[\(-5\) <= x < 0, 0, 0 <= x < 5, 3]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[f[x], {x, \(-5\), 5}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.500194 0.0953316 0.0147151 0.196201 [
[.11887 .00222 -6 -9 ]
[.11887 .00222 6 0 ]
[.30953 .00222 -6 -9 ]
[.30953 .00222 6 0 ]
[.69086 .00222 -3 -9 ]
[.69086 .00222 3 0 ]
[.88152 .00222 -3 -9 ]
[.88152 .00222 3 0 ]
[.48769 .11282 -18 -4.5 ]
[.48769 .11282 0 4.5 ]
[.48769 .21092 -6 -4.5 ]
[.48769 .21092 0 4.5 ]
[.48769 .30902 -18 -4.5 ]
[.48769 .30902 0 4.5 ]
[.48769 .40712 -6 -4.5 ]
[.48769 .40712 0 4.5 ]
[.48769 .50522 -18 -4.5 ]
[.48769 .50522 0 4.5 ]
[.48769 .60332 -6 -4.5 ]
[.48769 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.11887 .01472 m
.11887 .02097 L
s
[(-4)] .11887 .00222 0 1 Mshowa
.30953 .01472 m
.30953 .02097 L
s
[(-2)] .30953 .00222 0 1 Mshowa
.69086 .01472 m
.69086 .02097 L
s
[(2)] .69086 .00222 0 1 Mshowa
.88152 .01472 m
.88152 .02097 L
s
[(4)] .88152 .00222 0 1 Mshowa
.125 Mabswid
.16653 .01472 m
.16653 .01847 L
s
.2142 .01472 m
.2142 .01847 L
s
.26186 .01472 m
.26186 .01847 L
s
.3572 .01472 m
.3572 .01847 L
s
.40486 .01472 m
.40486 .01847 L
s
.45253 .01472 m
.45253 .01847 L
s
.54786 .01472 m
.54786 .01847 L
s
.59553 .01472 m
.59553 .01847 L
s
.64319 .01472 m
.64319 .01847 L
s
.73852 .01472 m
.73852 .01847 L
s
.78619 .01472 m
.78619 .01847 L
s
.83385 .01472 m
.83385 .01847 L
s
.0712 .01472 m
.0712 .01847 L
s
.02354 .01472 m
.02354 .01847 L
s
.92919 .01472 m
.92919 .01847 L
s
.97685 .01472 m
.97685 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.50019 .11282 m
.50644 .11282 L
s
[(0.5)] .48769 .11282 1 0 Mshowa
.50019 .21092 m
.50644 .21092 L
s
[(1)] .48769 .21092 1 0 Mshowa
.50019 .30902 m
.50644 .30902 L
s
[(1.5)] .48769 .30902 1 0 Mshowa
.50019 .40712 m
.50644 .40712 L
s
[(2)] .48769 .40712 1 0 Mshowa
.50019 .50522 m
.50644 .50522 L
s
[(2.5)] .48769 .50522 1 0 Mshowa
.50019 .60332 m
.50644 .60332 L
s
[(3)] .48769 .60332 1 0 Mshowa
.125 Mabswid
.50019 .03434 m
.50394 .03434 L
s
.50019 .05396 m
.50394 .05396 L
s
.50019 .07358 m
.50394 .07358 L
s
.50019 .0932 m
.50394 .0932 L
s
.50019 .13244 m
.50394 .13244 L
s
.50019 .15206 m
.50394 .15206 L
s
.50019 .17168 m
.50394 .17168 L
s
.50019 .1913 m
.50394 .1913 L
s
.50019 .23054 m
.50394 .23054 L
s
.50019 .25016 m
.50394 .25016 L
s
.50019 .26978 m
.50394 .26978 L
s
.50019 .2894 m
.50394 .2894 L
s
.50019 .32864 m
.50394 .32864 L
s
.50019 .34826 m
.50394 .34826 L
s
.50019 .36788 m
.50394 .36788 L
s
.50019 .3875 m
.50394 .3875 L
s
.50019 .42674 m
.50394 .42674 L
s
.50019 .44636 m
.50394 .44636 L
s
.50019 .46598 m
.50394 .46598 L
s
.50019 .4856 m
.50394 .4856 L
s
.50019 .52484 m
.50394 .52484 L
s
.50019 .54446 m
.50394 .54446 L
s
.50019 .56408 m
.50394 .56408 L
s
.50019 .5837 m
.50394 .5837 L
s
.25 Mabswid
.50019 0 m
.50019 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02418 .01472 L
.02728 .01472 L
.05485 .01472 L
.11162 .01472 L
.16807 .01472 L
.22241 .01472 L
.28018 .01472 L
.33583 .01472 L
.38935 .01472 L
.41922 .01472 L
.44631 .01472 L
.45987 .01472 L
.47454 .01472 L
.48128 .01472 L
.4884 .01472 L
.49447 .01472 L
.49614 .01472 L
.49792 .01472 L
.49961 .01472 L
.50114 .60332 L
.50279 .60332 L
.50434 .60332 L
.50788 .60332 L
.51504 .60332 L
.52789 .60332 L
.55698 .60332 L
.6112 .60332 L
.66885 .60332 L
.72438 .60332 L
.77778 .60332 L
.83462 .60332 L
.88934 .60332 L
.94749 .60332 L
.97438 .60332 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{216, 133.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003H0000QAP00`40o`000?l0003of?ooo`008_oo
o`<0000Qoooo0`0004Koool300009?ooo`<0000Ooooo000Soooo00<0003oooooool08?ooo`030000
oooooooo04Koool00`000?ooooooo`0Uoooo00<0003oooooool07_ooo`007?ooo`<00002oooo1000
01coool300000oooo`030000oooooooo04Koool00`000?ooooooo`0Roooo100001ooool0027oool0
0`000?ooo`00000Soooo00<0003oooooool0A_ooo`030000oooooooo02;oool00`000?ooo`00000P
oooo000Roooo0P0002;oool00`000?ooo`000016oooo00<0003oool000009?ooo`80000Poooo000S
oooo00<0003oooooool08Oooo`030000oooooooo04Koool00`000?ooooooo`0Toooo00<0003ooooo
ool07_ooo`00f?ooo`00f?ooo`00Joooo`030000oooooooo06[oool006_oool00`000?ooooooo`1Z
oooo001[oooo00<0003oooooool0J_ooo`002?ooolL00009oooo000Poooo00<0003oooooool08_oo
o`030000oooooooo02?oool00`000?ooooooo`0Soooo00<0003oooooool08_ooo`030000oooooooo
01ooool006_oool00`000?ooooooo`1Zoooo001[oooo0P0006_oool006_oool00`000?ooooooo`1Z
oooo001[oooo00<0003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool20000Jooo
o`00Joooo`030000oooooooo06[oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0003ooooo
ool0J_ooo`00Joooo`80001[oooo001[oooo00<0003oooooool0J_ooo`00Joooo`030000oooooooo
06[oool006_oool00`000?ooooooo`1Zoooo001[oooo0P0006_oool006_oool00`000?ooooooo`1Z
oooo001Loooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oooooool0J_ooo`00Foooo`030000oooo000000Ooool00`000?ooo`000003oooo00<0003ooooo
ool0J_ooo`00Foooo`030000oooo000000Woool010000?ooooooooooo`80001[oooo001Koooo00<0
003oool000001oooo`800004oooo00<0003oooooool0J_ooo`00Foooo`030000oooo000000Ooool0
0`000?ooooooo`03oooo00<0003oooooool0J_ooo`00G?ooo`030000oooooooo00Koool300000ooo
o`030000oooooooo06[oool006_oool20000Joooo`00Joooo`030000oooooooo06[oool006_oool0
0`000?ooooooo`1Zoooo001[oooo00<0003oooooool0J_ooo`00Joooo`80001[oooo001[oooo00<0
003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool00`000?ooooooo`1Zoooo001[
oooo0P0006_oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0003oooooool0J_ooo`00Jooo
o`80001[oooo001[oooo00<0003oooooool0J_ooo`00I?ooo`D00002oooo00<0003oooooool0J_oo
o`00I_ooo`030000oooooooo00;oool00`000?ooooooo`1Zoooo001Voooo00<0003oooooool00_oo
o`80001[oooo001Voooo00<0003oooooool00_ooo`030000oooooooo06[oool006Koool00`000?oo
ooooo`02oooo00<0003oooooool0J_ooo`00IOooo`800004oooo00<0003oooooool0J_ooo`00Jooo
o`80001[oooo001[oooo00<0003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool0
0`000?ooooooo`1Zoooo001[oooo0P0006_oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0
003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool20000Joooo`00Joooo`030000
oooooooo06[oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0003oooooool0J_ooo`00Jooo
o`80001[oooo001[oooo00<0003oooooool0J_ooo`00F_ooo`D00002oooo00<0003oooooool00_oo
o`030000oooooooo00;oool00`000?ooooooo`1Zoooo001Loooo00<0003oooooool01_ooo`030000
oooo000000?oool00`000?ooooooo`1Zoooo001Loooo00<0003oooooool02?ooo`040000oooooooo
oooo0P0006_oool005coool00`000?ooooooo`06oooo0P0000Coool00`000?ooooooo`1Zoooo001L
oooo00<0003oooooool01_ooo`030000oooooooo00?oool00`000?ooooooo`1Zoooo001Koooo0P00
00Soool300000oooo`030000oooooooo06[oool006_oool20000Joooo`00Joooo`030000oooooooo
06[oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0003oooooool0J_ooo`00Joooo`80001[
oooo001[oooo00<0003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool20000Jooo
o`00Joooo`030000oooooooo06[oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0003ooooo
ool0J_ooo`00Joooo`80001[oooo001[oooo00<0003oooooool0J_ooo`00IOooo`<00003oooo00<0
003oooooool0J_ooo`00IOooo`030000oooooooo00?oool00`000?ooooooo`1Zoooo001Voooo00<0
003oooooool00_ooo`80001[oooo001Voooo00<0003oooooool00_ooo`030000oooooooo06[oool0
06Goool00`000?ooo`000003oooo00<0003oooooool0J_ooo`00I_ooo`030000oooooooo00;oool0
0`000?ooooooo`1Zoooo001[oooo0P0006_oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0
003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool20000Joooo`00Joooo`030000
oooooooo06[oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0003oooooool0J_ooo`00Jooo
o`80001[oooo001[oooo00<0003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool0
0`000?ooooooo`1Zoooo001[oooo0P0006_oool006_oool00`000?ooooooo`1Zoooo001Koooo0`00
00?oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo06[oool005_oool0
0`000?ooooooo`07oooo00<0003oool000000oooo`030000oooooooo06[oool005coool00`000?oo
ooooo`08oooo00@0003oooooooooool20000Joooo`00G?ooo`030000oooooooo00Koool200001?oo
o`030000oooooooo06[oool005_oool00`000?ooo`000007oooo00<0003oooooool00oooo`030000
oooooooo06[oool005coool00`000?ooooooo`06oooo0`0000?oool20000Joooo`00Joooo`030000
oooooooo06[oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0003oooooool0J_ooo`00Jooo
o`80001[oooo001[oooo00<0003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool0
0`000?ooooooo`1Zoooo001[oooo0P0006_oool006_oool00`000?ooooooo`1Zoooo001[oooo00<0
003oooooool0J_ooo`00Joooo`030000oooooooo06[oool006_oool20000Joooo`00Joooo`030000
oooooooo06[oool006Goool200001?ooo`030000oooooooo06[oool006Ooool01@000?oooooooooo
o`00001/oooo001Voooo00<0003oooooool00_oooel0000>oooo001Woooo00D0003oooooooooool0
0000K?ooo`00IOooo`030000oooo000000?oool00`000?ooooooo`1Zoooo001Voooo00<0003ooooo
ool00_ooo`030000oooooooo06[oool00=Soool00001\
\>"],
  ImageRangeCache->{{{0, 215}, {132.438, 0}} -> {-5.7011, -0.295533, 
  0.0530146, 0.0257591}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(S[n_, x_] := 
      3\/2 + \(6\/Pi\) 
          \(\[Sum]\+\(i = 0\)\%n\( 1\/\((2  i + 1)\)\) 
              Sin[\(\((2  i + 1)\) x\)\/5]\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[S[20, x], {x, \(-5\), 5}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 0.0593766 0.166408 [
[.11905 .04688 -6 -9 ]
[.11905 .04688 6 0 ]
[.30952 .04688 -6 -9 ]
[.30952 .04688 6 0 ]
[.69048 .04688 -3 -9 ]
[.69048 .04688 3 0 ]
[.88095 .04688 -3 -9 ]
[.88095 .04688 3 0 ]
[.4875 .14258 -18 -4.5 ]
[.4875 .14258 0 4.5 ]
[.4875 .22578 -6 -4.5 ]
[.4875 .22578 0 4.5 ]
[.4875 .30899 -18 -4.5 ]
[.4875 .30899 0 4.5 ]
[.4875 .39219 -6 -4.5 ]
[.4875 .39219 0 4.5 ]
[.4875 .4754 -18 -4.5 ]
[.4875 .4754 0 4.5 ]
[.4875 .5586 -6 -4.5 ]
[.4875 .5586 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.11905 .05938 m
.11905 .06563 L
s
[(-4)] .11905 .04688 0 1 Mshowa
.30952 .05938 m
.30952 .06563 L
s
[(-2)] .30952 .04688 0 1 Mshowa
.69048 .05938 m
.69048 .06563 L
s
[(2)] .69048 .04688 0 1 Mshowa
.88095 .05938 m
.88095 .06563 L
s
[(4)] .88095 .04688 0 1 Mshowa
.125 Mabswid
.16667 .05938 m
.16667 .06313 L
s
.21429 .05938 m
.21429 .06313 L
s
.2619 .05938 m
.2619 .06313 L
s
.35714 .05938 m
.35714 .06313 L
s
.40476 .05938 m
.40476 .06313 L
s
.45238 .05938 m
.45238 .06313 L
s
.54762 .05938 m
.54762 .06313 L
s
.59524 .05938 m
.59524 .06313 L
s
.64286 .05938 m
.64286 .06313 L
s
.7381 .05938 m
.7381 .06313 L
s
.78571 .05938 m
.78571 .06313 L
s
.83333 .05938 m
.83333 .06313 L
s
.07143 .05938 m
.07143 .06313 L
s
.02381 .05938 m
.02381 .06313 L
s
.92857 .05938 m
.92857 .06313 L
s
.97619 .05938 m
.97619 .06313 L
s
.25 Mabswid
0 .05938 m
1 .05938 L
s
.5 .14258 m
.50625 .14258 L
s
[(0.5)] .4875 .14258 1 0 Mshowa
.5 .22578 m
.50625 .22578 L
s
[(1)] .4875 .22578 1 0 Mshowa
.5 .30899 m
.50625 .30899 L
s
[(1.5)] .4875 .30899 1 0 Mshowa
.5 .39219 m
.50625 .39219 L
s
[(2)] .4875 .39219 1 0 Mshowa
.5 .4754 m
.50625 .4754 L
s
[(2.5)] .4875 .4754 1 0 Mshowa
.5 .5586 m
.50625 .5586 L
s
[(3)] .4875 .5586 1 0 Mshowa
.125 Mabswid
.5 .07602 m
.50375 .07602 L
s
.5 .09266 m
.50375 .09266 L
s
.5 .1093 m
.50375 .1093 L
s
.5 .12594 m
.50375 .12594 L
s
.5 .15922 m
.50375 .15922 L
s
.5 .17586 m
.50375 .17586 L
s
.5 .1925 m
.50375 .1925 L
s
.5 .20914 m
.50375 .20914 L
s
.5 .24243 m
.50375 .24243 L
s
.5 .25907 m
.50375 .25907 L
s
.5 .27571 m
.50375 .27571 L
s
.5 .29235 m
.50375 .29235 L
s
.5 .32563 m
.50375 .32563 L
s
.5 .34227 m
.50375 .34227 L
s
.5 .35891 m
.50375 .35891 L
s
.5 .37555 m
.50375 .37555 L
s
.5 .40883 m
.50375 .40883 L
s
.5 .42547 m
.50375 .42547 L
s
.5 .44211 m
.50375 .44211 L
s
.5 .45876 m
.50375 .45876 L
s
.5 .49204 m
.50375 .49204 L
s
.5 .50868 m
.50375 .50868 L
s
.5 .52532 m
.50375 .52532 L
s
.5 .54196 m
.50375 .54196 L
s
.5 .04274 m
.50375 .04274 L
s
.5 .0261 m
.50375 .0261 L
s
.5 .00945 m
.50375 .00945 L
s
.5 .57524 m
.50375 .57524 L
s
.5 .59188 m
.50375 .59188 L
s
.5 .60852 m
.50375 .60852 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .05752 m
.02605 .05674 L
.02846 .05602 L
.03072 .05547 L
.03172 .05528 L
.03279 .05511 L
.03405 .05495 L
.03521 .05486 L
.03646 .05481 L
.03717 .0548 L
.03784 .05482 L
.03904 .05488 L
.04014 .05498 L
.04141 .05515 L
.04262 .05537 L
.045 .05592 L
.04753 .05667 L
.0521 .05837 L
.05749 .06058 L
.06244 .06242 L
.0651 .06321 L
.06646 .06353 L
.06791 .06381 L
.06867 .06393 L
.06937 .06402 L
.07008 .06409 L
.07073 .06415 L
.07149 .06419 L
.07232 .06421 L
.07305 .06421 L
.07382 .06418 L
.07509 .06409 L
.0758 .06401 L
.07645 .06393 L
.07892 .06347 L
.08023 .06314 L
.08166 .06272 L
.08454 .06172 L
.08994 .05947 L
.09504 .05727 L
.09962 .05561 L
.10087 .05525 L
.1022 .05492 L
.10344 .05467 L
.10458 .05448 L
.10577 .05434 L
.10691 .05426 L
.1081 .05422 L
.1094 .05425 L
.11054 .05433 L
Mistroke
.11175 .05448 L
.11289 .05466 L
.11392 .05487 L
.11646 .05555 L
.11921 .05651 L
.12419 .05865 L
.1295 .06114 L
.1324 .06239 L
.13511 .06339 L
.13742 .06408 L
.13861 .06436 L
.13989 .0646 L
.14063 .06471 L
.14131 .06479 L
.14195 .06485 L
.14264 .0649 L
.14383 .06493 L
.14514 .06489 L
.14636 .06479 L
.1475 .06464 L
.14874 .06441 L
.15007 .06409 L
.15279 .06325 L
.15526 .06228 L
.16453 .05774 L
.16968 .05539 L
.1711 .05487 L
.17259 .05438 L
.17388 .05403 L
.17527 .05372 L
.17657 .05351 L
.17776 .05339 L
.17896 .05333 L
.18009 .05333 L
.18141 .05342 L
.18263 .05356 L
.18327 .05367 L
.18397 .05381 L
.1854 .05415 L
.1956 .05866 L
.20116 .06175 L
.20388 .06313 L
.20634 .06422 L
.20847 .06499 L
.20959 .06532 L
.21078 .06561 L
.21205 .06584 L
.21322 .06599 L
.21431 .06606 L
.21552 .06607 L
Mistroke
.21683 .06599 L
.21802 .06584 L
.21868 .06573 L
.2194 .06558 L
.22071 .06524 L
.22323 .06437 L
.22557 .06333 L
.23521 .05764 L
.23993 .05491 L
.24201 .0539 L
.24428 .05299 L
.24546 .05261 L
.24673 .05229 L
.24743 .05214 L
.24806 .05204 L
.24931 .05189 L
.25 .05185 L
.25065 .05184 L
.25135 .05185 L
.2521 .0519 L
.25336 .05205 L
.25407 .05218 L
.25474 .05233 L
.25712 .05305 L
.25931 .05398 L
.26422 .05679 L
.27338 .06316 L
.27602 .06481 L
.27851 .06612 L
.28074 .06704 L
.282 .06744 L
.28316 .06772 L
.28444 .06794 L
.28564 .06804 L
.28696 .06804 L
.2877 .06798 L
.28837 .0679 L
.28908 .06779 L
.28973 .06765 L
.2912 .06723 L
.2925 .06675 L
.29389 .06612 L
.29913 .06284 L
.30387 .05906 L
.30876 .05504 L
.31144 .05306 L
.31393 .05149 L
.31606 .05042 L
.31715 .04998 L
.31834 .0496 L
Mistroke
.31964 .0493 L
.32086 .04914 L
.32206 .0491 L
.32317 .04916 L
.32436 .04934 L
.32565 .04967 L
.32687 .05009 L
.32798 .05058 L
.3307 .05215 L
.33328 .05409 L
.344 .06442 L
.34637 .06661 L
.34894 .06868 L
.35136 .07026 L
.35251 .07085 L
.35358 .07131 L
.35483 .07171 L
.35548 .07186 L
.35619 .07197 L
.35693 .07205 L
.35763 .07206 L
.35894 .07196 L
.36015 .07172 L
.36127 .07136 L
.3625 .07082 L
.3638 .07009 L
.36597 .06853 L
.36831 .06641 L
.37254 .06166 L
.37754 .05529 L
.38219 .0496 L
.38456 .04713 L
.38681 .0452 L
.38805 .04435 L
.3894 .04361 L
.39062 .04313 L
.39175 .04284 L
.393 .04271 L
.39417 .04278 L
.39545 .04307 L
.39617 .04333 L
.39683 .04363 L
.39815 .0444 L
.39959 .0455 L
.40222 .04818 L
.40752 .05578 L
.41316 .06573 L
.4181 .07422 L
.4208 .07812 L
.42331 .08099 L
Mistroke
.42455 .08206 L
.42587 .08293 L
.42663 .08329 L
.42734 .08353 L
.42799 .08367 L
.42868 .08373 L
.42993 .08359 L
.43125 .08311 L
.43238 .0824 L
.43362 .08133 L
.43506 .07967 L
.43639 .07778 L
.43937 .07229 L
.44476 .05872 L
.44981 .04359 L
.45521 .02809 L
.45784 .02198 L
.45912 .01953 L
.46031 .01766 L
.46139 .01631 L
.46253 .0153 L
.46368 .01475 L
.46494 .01472 L
.4662 .01533 L
.46741 .01655 L
.46848 .01821 L
.46966 .02064 L
.47094 .02405 L
.47229 .02857 L
.47473 .03913 L
.47908 .06588 L
.48389 .10701 L
.49456 .23377 L
.5046 .37286 L
.51441 .49368 L
.51934 .53992 L
.52217 .56086 L
.52475 .57618 L
.52713 .58717 L
.52937 .59483 L
.53061 .59795 L
.53175 .60017 L
.533 .60191 L
.53363 .60251 L
.53432 .60298 L
.53548 .60332 L
.53654 .60316 L
.53777 .60245 L
.53893 .6013 L
.54 .59987 L
Mistroke
.54099 .59825 L
.54324 .59365 L
.55381 .56341 L
.559 .54937 L
.56127 .54437 L
.56377 .53996 L
.56486 .53841 L
.56602 .53703 L
.56702 .53605 L
.56812 .53523 L
.56935 .53461 L
.57052 .5343 L
.57166 .53427 L
.57271 .53446 L
.57386 .53491 L
.57494 .53555 L
.57612 .53647 L
.5774 .53771 L
.58238 .54452 L
.5874 .55326 L
.59276 .56266 L
.59537 .56665 L
.59783 .56985 L
.60003 .57215 L
.60127 .57317 L
.60243 .57395 L
.60364 .57457 L
.60428 .57482 L
.60497 .57503 L
.6057 .57517 L
.60638 .57525 L
.60767 .57522 L
.60887 .575 L
.60998 .57463 L
.6112 .57406 L
.6125 .57327 L
.61549 .5708 L
.61829 .56783 L
.62353 .56132 L
.6286 .55495 L
.63332 .55005 L
.6357 .54821 L
.63692 .54746 L
.63825 .54681 L
.639 .54652 L
.6397 .5463 L
.64037 .54614 L
.64108 .54601 L
.6423 .54592 L
.643 .54593 L
Mistroke
.64365 .54598 L
.64479 .54618 L
.64603 .54653 L
.64721 .54699 L
.6483 .54753 L
.65255 .55046 L
.66214 .55969 L
.66721 .56428 L
.67006 .56631 L
.67142 .56709 L
.67269 .5677 L
.6739 .56817 L
.675 .56849 L
.67622 .56874 L
.67753 .56886 L
.67878 .56886 L
.6795 .5688 L
.68015 .56871 L
.68136 .56846 L
.68264 .56807 L
.68483 .56714 L
.6872 .56581 L
.69148 .56274 L
.69654 .55858 L
.70124 .55487 L
.70362 .55326 L
.70586 .55198 L
.7071 .55139 L
.70845 .55086 L
.70967 .55048 L
.7108 .55021 L
.71205 .55002 L
.71322 .54993 L
.7145 .54995 L
.71522 .55 L
.71588 .55008 L
.7172 .55033 L
.71795 .55052 L
.71864 .55073 L
.72126 .55175 L
.72402 .55319 L
.72662 .55482 L
.73148 .55821 L
.73667 .56175 L
.73941 .56336 L
.74093 .56411 L
.74236 .56473 L
.74363 .56519 L
.745 .56559 L
.74626 .56586 L
Mistroke
.74742 .56603 L
.7485 .56612 L
.7497 .56613 L
.75096 .56606 L
.75213 .56591 L
.7534 .56566 L
.75473 .56531 L
.7571 .56446 L
.76246 .56174 L
.76744 .55868 L
.77214 .55586 L
.77636 .55377 L
.77874 .5529 L
.7798 .55259 L
.78094 .55232 L
.78208 .55212 L
.78315 .55199 L
.78442 .55191 L
.78558 .55191 L
.78679 .55199 L
.7881 .55216 L
.78934 .5524 L
.79049 .55268 L
.79309 .55353 L
.79544 .55452 L
.8007 .55724 L
.80964 .562 L
.81182 .56291 L
.81414 .56369 L
.81548 .56405 L
.81669 .5643 L
.81792 .56449 L
.81907 .5646 L
.82029 .56465 L
.82158 .56463 L
.82268 .56455 L
.8239 .5644 L
.8252 .56416 L
.8266 .56382 L
.82914 .56303 L
.83396 .56097 L
.83838 .55876 L
.84348 .55625 L
.84618 .55511 L
.84767 .55457 L
.84906 .55412 L
.85039 .55377 L
.85182 .55346 L
.85313 .55325 L
.85433 .55312 L
Mistroke
.85546 .55306 L
.85671 .55305 L
.858 .55312 L
.85922 .55324 L
.86048 .55344 L
.86182 .55371 L
.86422 .55437 L
.86967 .55647 L
.87477 .55884 L
.87957 .56098 L
.88381 .56251 L
.88497 .56284 L
.8862 .56313 L
.88734 .56336 L
.88839 .56352 L
.88955 .56365 L
.89079 .56373 L
.89195 .56375 L
.89304 .56372 L
.89431 .56363 L
.89548 .56349 L
.89676 .56327 L
.89812 .56298 L
.90828 .55929 L
.91328 .55712 L
.91571 .55616 L
.91792 .55539 L
.91993 .5548 L
.92211 .55429 L
.92331 .55408 L
.92441 .55394 L
.92546 .55384 L
.92657 .55378 L
.92769 .55377 L
.9289 .55381 L
.93004 .55389 L
.93107 .55401 L
.93229 .5542 L
.93361 .55446 L
.936 .55507 L
.94089 .55675 L
.94607 .55886 L
.95055 .56063 L
.9529 .56144 L
.95538 .56216 L
.95665 .56246 L
.95804 .56273 L
.95931 .56293 L
.96049 .56306 L
.9617 .56314 L
Mistroke
.9628 .56317 L
.96408 .56316 L
.96528 .56309 L
.96591 .56303 L
.9666 .56295 L
.968 .56275 L
.97052 .56222 L
.97345 .5614 L
.97619 .56046 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{242, 149.5},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003b0000UAP00`40o`000?l0003oN?ooo`030000
oooooooo07Ooool007Soool00`000?ooooooo`1goooo001hoooo0P0007Soool001koool30000:_oo
o`<0000Zoooo00<0003oooooool0:Oooo`<0000/oooo0`0001coool001ooool00`000?ooooooo`0Y
oooo00<0003oooooool08?ooo`<00007oooo00<0003oooooool0:Oooo`030000oooooooo02goool0
0`000?ooooooo`0Koooo000Hoooo0`0000;oool400009Oooo`<00003oooo00<0003oooooool07ooo
o`040000oooooooo00001_ooo`030000oooooooo02[oool00`000?ooooooo`0Zoooo100001coool0
01goool00`000?ooo`00000/oooo00<0003oooooool07_ooo`050000oooooooooooo000000Koool2
0000:oooo`030000oooooooo02[oool00`000?ooo`00000Moooo000Noooo0P0002_oool00`000?oo
o`00000Ooooo00D0003oooooooooool000001_ooo`030000oooooooo02Woool00`000?ooo`00000/
oooo0P0001goool001ooool00`000?ooooooo`0Zoooo00<0003oooooool07_ooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool0:_ooo`030000oooooooo02coool00`000?oo
ooooo`0Koooo001/oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`1g
oooo001Moooo0`0000coool00`000?ooooooo`03oooo00<0003oooooool00oooo`80001hoooo001L
oooo0P0000;oool00`000?ooooooo`09oooo00<0003oooooool00oooo`030000oooooooo00?oool0
0`000?ooooooo`1goooo000loooo00<0003oooooool03?ooo`D0000<oooo00<0003oooooool00_oo
o`030000oooooooo00Ooool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
07Ooool000Ooool500003?ooo`D0000<oooo1@0000coool2000000?oool0000000002oooo`800003
oooo0P0000[oool00`000?ooooooo`04oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo00<0003oooooool0Moooo`00l@00007oool000Koool00`000?ooooooo`04
oooo200000Ooool00`000?ooooooo`0300000_ooo`<000000oooo`000?ooo`06oooo0P000004oooo
0000oooooooo0P0000Ooool010000?ooo`00000000Goool00`000?ooo`000008oooo00@0003ooooo
ool00002oooo00<0003oooooool01Oooo`030000oooo000000Koool010000?ooooooo`0000Goool0
0`000?ooooooo`02oooo00<0003oooooool02?ooo`030000oooooooo00Woool00`000?ooooooo`08
oooo00<0003oooooool02Oooo`030000oooooooo00Soool00`000?ooooooo`09oooo00<0003ooooo
ool02?ooo`030000oooooooo00Woool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Goool001coool00`000?ooooooo`02oooo0`0000koool400003?ooo`H00002oooo00<0
003oooooool01_ooo`030000oooooooo00;oool00`000?ooooooo`08oooo00<0003oooooool01?oo
o`030000oooooooo00Koool00`000?ooooooo`02oooo00<0003oooooool0:oooo`030000oooooooo
02_oool00`000?ooooooo`0Koooo001Doooo100000coool00`000?ooooooo`02oooo00<0003ooooo
ool01oooo`030000oooooooo00;oool00`000?ooooooo`1goooo001Toooo00<0003oooooool00_oo
o`030000oooooooo00Ooool00`000?ooooooo`02oooo0P0007Soool006Goool2000000?oool00000
00002Oooo`030000oooooooo00;oool00`000?ooooooo`1goooo001Voooo0`0000[oool00`000?oo
ooooo`02oooo00<0003oooooool0Moooo`00M?ooo`050000oooooooooooo000007Woool007Coool0
10000?ooooooooooo`80001hoooo001doooo00D0003oooooooooool00000NOooo`00M?ooo`050000
oooooooooooo000007Woool007Coool01@000?ooooooooooo`00001ioooo001doooo00@0003ooooo
ooooool20000N?ooo`00M?ooo`050000oooooooooooo000007Woool007Coool01@000?oooooooooo
o`00001ioooo001doooo00D0003oooooooooool00000NOooo`00M?ooo`040000oooooooooooo0P00
07Soool007Goool010000?ooooooo`0007Woool006Soool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`040000oooooooo00000_ooo`030000oooooooo07Ooool006Ooool00`000?ooo`000007
oooo00D0003oool0003oool000000_ooo`030000oooooooo07Ooool006Ooool00`000?ooo`000009
oooo00<0003oool000000_ooo`<0001goooo001Woooo00<0003oool000001oooo`800002oooo00@0
003oooooool0001ioooo001Woooo00<0003oool000001oooo`050000oooooooooooo000000;oool0
0`000?ooooooo`1goooo001Xoooo00<0003oooooool01_ooo`<000001Oooo`000?ooooooo`00001i
oooo001eoooo00<0003oooooool00P0007Soool007Goool010000?ooooooo`0007Woool007Goool0
10000?ooooooo`0007Woool007Koool00`000?ooo`00001ioooo001foooo00@0003oool00000001h
oooo001foooo00<0003oool00000NOooo`00M_ooo`030000oooo000007Woool007Koool00`000?oo
o`00001ioooo001foooo00@0003oool00000001hoooo001foooo00<0003oool00000NOooo`00M_oo
o`030000oooo000007Woool007Koool00`000?ooo`00001ioooo001foooo00@0003oool00000001h
oooo001goooo0P0007Woool0073oool500000_ooo`80001ioooo001boooo00<0003oooooool00_oo
o`80001ioooo001boooo00<0003oooooool00_ooo`@0001goooo001boooo00<0003oooooool00_oo
o`80001ioooo001boooo00<0003oooooool00_ooo`80001ioooo001aoooo0P0000Coool20000NOoo
o`00Moooo`<0001hoooo001goooo0P0007Woool007Ooool20000NOooo`00Moooo`80001ioooo001g
oooo0`0007Soool007Ooool20000NOooo`00Moooo`80001ioooo001hoooo00<0003oooooool0Mooo
o`00N?ooo`80001hoooo001hoooo00<0003oooooool0Moooo`00N?ooo`030000oooooooo07Ooool0
07Soool00`000?ooooooo`1goooo001hoooo0P0007Soool007Soool00`000?ooooooo`1goooo001V
oooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo07Ooool0
06Soool00`000?ooooooo`06oooo00<0003oool000001?ooo`030000oooooooo07Ooool006Soool0
0`000?ooooooo`08oooo00<0003oooooool00_ooo`<0001goooo001Xoooo00<0003oooooool01_oo
o`800005oooo00<0003oooooool0Moooo`00J?ooo`030000oooooooo00Koool00`000?ooooooo`04
oooo00<0003oooooool0Moooo`00Ioooo`800008oooo0`0000Coool00`000?ooooooo`1goooo001h
oooo0P0007Soool007Soool00`000?ooooooo`1goooo001hoooo00<0003oooooool0Moooo`00N?oo
o`030000oooooooo07Ooool007Soool20000N?ooo`00N?ooo`80001hoooo001hoooo0P0007Soool0
07Soool20000N?ooo`00N?ooo`80001hoooo001hoooo0P0007Soool007Soool20000N?ooo`00N?oo
o`80001hoooo001hoooo0P0007Soool007Soool20000N?ooo`00LOooo`<00004oooo0P0007Soool0
077oool00`000?ooooooo`04oooo0P0007Soool007;oool00`000?ooooooo`03oooo0`0007Ooool0
07;oool00`000?ooooooo`03oooo0P0007Soool0077oool00`000?ooo`000004oooo0P0007Soool0
07;oool00`000?ooooooo`03oooo0P0007Soool007Soool30000Moooo`00N?ooo`030000oooo0000
07Ooool007Soool00`000?ooo`00001goooo001hoooo00<0003oool00000Moooo`00N?ooo`<0001g
oooo001hoooo00<0003oool00000Moooo`00N?ooo`030000oooo000007Ooool007Soool00`000?oo
o`00001goooo001hoooo0`0007Ooool007Soool00`000?ooo`00001goooo001hoooo00<0003oool0
0000Moooo`00N?ooo`030000oooo000007Ooool007Soool30000Moooo`00N?ooo`030000oooo0000
07Ooool006Ooool300000oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00@0003ooooo
ool0001foooo001Woooo00<0003oooooool01oooo`030000oooo000000Coool010000?ooooooo`00
07Koool006Soool00`000?ooooooo`08oooo00<0003oooooool00_ooo`@0001foooo001Xoooo00<0
003oooooool01_ooo`800005oooo00@0003oooooool0001foooo001Woooo00<0003oool000001ooo
o`030000oooooooo00Coool010000?ooooooo`0007Koool006Soool00`000?ooooooo`06oooo0`00
00Coool010000?ooooooo`0007Koool007Soool2000000?oool0003oool0MOooo`00N?ooo`040000
oooooooo0000M_ooo`00N?ooo`040000oooooooo0000M_ooo`00N?ooo`040000oooooooo0000M_oo
o`00N?ooo`800002oooo00<0003oooooool0Loooo`00N?ooo`050000oooooooooooo000007Goool0
07Soool01@000?ooooooooooo`00001eoooo001hoooo00D0003oooooooooool00000MOooo`00N?oo
o`800002oooo00<0003oooooool0Loooo`00N?ooo`050000oooooooooooo000007Goool007Soool0
0`000?ooooooo`02oooo00<0003oooooool02Oooo`030000oooooooo06Koool007Soool00`000?oo
ooooo`02oooo00<0003oooooool02?ooo`040000oooo00000000I_ooo`00N?ooo`800003oooo00<0
003oooooool01oooo`030000oooooooo00;oool00`000?ooooooo`1Soooo001hoooo00<0003ooooo
ool00_ooo`030000oooooooo00Ooool00`000?ooooooo`02oooo00<0003oooooool02_ooo`<0001F
oooo001aoooo0P0000Goool00`000?ooooooo`02oooo00<0003oooooool01_ooo`030000oooooooo
00Coool00`000?ooooooo`08oooo0P0000;oool200003?ooo`@00014oooo001coooo00<0003ooooo
ool00_ooo`030000oooooooo00;oool00`000?ooooooo`06oooo00<0003oooooool01?ooo`030000
oooooooo00Ooool00`000?ooooooo`04oooo00<0003oooooool01oooo`800003oooo0P0000_oool6
00002oooo`H0000;oooo1P00013oool007;oool00`000?ooooooo`03oooo0`0000;oool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0
003oooooool01Oooo`030000oooooooo00Goool200001oooo`800006oooo00<0003oooooool01_oo
o`<00005oooo0P0000Ooool300001Oooo`80000>oooo001coooo00<0003oooooool00_ooo`030000
oooooooo00;oool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`07oooo00<0003oooooool00oooo`030000oooooooo00Soool200001?ooo`030000
oooooooo00Ooool300000_ooo`<0000:oooo1`0000[oool700001oooo`00LOooo`030000oooo0000
00Coool00`000?ooooooo`02oooo00<0003oooooool01Oooo`030000oooooooo00Ooool00`000?oo
ooooo`02oooo0P0000[oool200000_ooo`80000<oooo1@0000goool30000:oooo`00L_ooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00Woool0
1@000?ooooooooooo`00000=oooo0`0004goool007Soool200001?ooo`030000oooooooo00?oool0
0`000?ooooooo`09oooo100005koool007Soool00`000?ooooooo`03oooo00<0003oooooool00_oo
o`030000oooooooo06coool007Soool00`000?ooooooo`04oooo00D0003oooooooooool00000K_oo
o`00N?ooo`030000oooooooo00Coool01@000?ooooooooooo`00001^oooo001hoooo0P0000Goool0
10000?ooooooo`0006ooool007Soool00`000?ooooooo`04oooo00@0003oooooool0001_oooo001h
oooo00<0003oooooool01?ooo`@0001_oooo001hoooo00<0003oooooool01Oooo`80001`oooo001h
oooo0P0007Soool007Soool00`000?ooooooo`1goooo001hoooo00<0003oooooool0Moooo`00\
\>"],
  ImageRangeCache->{{{0, 241}, {148.5, 0}} -> {-5.26579, -0.356832, 
  0.0436995, 0.02501}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Complex\ Fourier\ Series\)], "Input"],

Cell[BoxData[
    RowBox[{\(c \((n)\)\), "=", 
      RowBox[{\(1\/\(2  L\)\), 
        RowBox[{
          StyleBox[\(\[Integral]\_\(-L\)\%L\),
            ScriptLevel->0], 
          RowBox[{\(f[x]\), \(Exp[\(\(-I\)\ n\ \[Pi]\ x\)\/L]\), 
            StyleBox["\[ThinSpace]",
              ScriptLevel->0], 
            StyleBox[\(\[DifferentialD]x\),
              ScriptLevel->0]}]}]}]}]], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(f[x] = 
      \[Sum]\+\(n = \(-\[Infinity]\)\)\%\[Infinity] c \((n)\) 
          Exp[\(I\ n\ \[Pi]\ x\)\/L]\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    RowBox[{
      RowBox[{\(c[n_]\), ":=", 
        RowBox[{
          RowBox[{\(\(-1\)\/\(4  \[Pi]\)\), 
            RowBox[{
              StyleBox[\(\[Integral]\_\(\(-2\) \[Pi]\)\%0\),
                ScriptLevel->0], 
              RowBox[{
                StyleBox["x",
                  ScriptLevel->0], 
                StyleBox[" ",
                  ScriptLevel->0], \(Exp[\(\(-I\)\ n\ \ x\)\/2]\), 
                StyleBox["\[ThinSpace]",
                  ScriptLevel->0], 
                StyleBox[\(\[DifferentialD]x\),
                  ScriptLevel->0]}]}]}], 
          StyleBox["+",
            ScriptLevel->0], 
          RowBox[{\(1\/\(4  \[Pi]\)\), 
            RowBox[{
              StyleBox[\(\[Integral]\_0\%\(2 \[Pi]\)\),
                ScriptLevel->0], 
              RowBox[{
                StyleBox["x",
                  ScriptLevel->0], 
                StyleBox[" ",
                  ScriptLevel->0], \(Exp[\(\(-I\)\ n\ \ x\)\/2]\), 
                StyleBox["\[ThinSpace]",
                  ScriptLevel->0], 
                StyleBox[\(\[DifferentialD]x\),
                  ScriptLevel->0]}]}]}]}]}], 
      StyleBox[";",
        ScriptLevel->0]}]], "Input"],

Cell[BoxData[
    \(\(F[x_] := \[Sum]\+\(n = \(-5\)\)\%5 c[n] Exp[\(I\ n\ \ x\)\/2]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[F[x], {x, \(-2\) \[Pi], 2  \[Pi]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0757881 0.0147151 0.0969234 [
[.04527 .00222 -6 -9 ]
[.04527 .00222 6 0 ]
[.19685 .00222 -6 -9 ]
[.19685 .00222 6 0 ]
[.34842 .00222 -6 -9 ]
[.34842 .00222 6 0 ]
[.65158 .00222 -3 -9 ]
[.65158 .00222 3 0 ]
[.80315 .00222 -3 -9 ]
[.80315 .00222 3 0 ]
[.95473 .00222 -3 -9 ]
[.95473 .00222 3 0 ]
[.4875 .11164 -6 -4.5 ]
[.4875 .11164 0 4.5 ]
[.4875 .20856 -6 -4.5 ]
[.4875 .20856 0 4.5 ]
[.4875 .30549 -6 -4.5 ]
[.4875 .30549 0 4.5 ]
[.4875 .40241 -6 -4.5 ]
[.4875 .40241 0 4.5 ]
[.4875 .49933 -6 -4.5 ]
[.4875 .49933 0 4.5 ]
[.4875 .59626 -6 -4.5 ]
[.4875 .59626 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.04527 .01472 m
.04527 .02097 L
s
[(-6)] .04527 .00222 0 1 Mshowa
.19685 .01472 m
.19685 .02097 L
s
[(-4)] .19685 .00222 0 1 Mshowa
.34842 .01472 m
.34842 .02097 L
s
[(-2)] .34842 .00222 0 1 Mshowa
.65158 .01472 m
.65158 .02097 L
s
[(2)] .65158 .00222 0 1 Mshowa
.80315 .01472 m
.80315 .02097 L
s
[(4)] .80315 .00222 0 1 Mshowa
.95473 .01472 m
.95473 .02097 L
s
[(6)] .95473 .00222 0 1 Mshowa
.125 Mabswid
.08317 .01472 m
.08317 .01847 L
s
.12106 .01472 m
.12106 .01847 L
s
.15895 .01472 m
.15895 .01847 L
s
.23474 .01472 m
.23474 .01847 L
s
.27264 .01472 m
.27264 .01847 L
s
.31053 .01472 m
.31053 .01847 L
s
.38632 .01472 m
.38632 .01847 L
s
.42421 .01472 m
.42421 .01847 L
s
.46211 .01472 m
.46211 .01847 L
s
.53789 .01472 m
.53789 .01847 L
s
.57579 .01472 m
.57579 .01847 L
s
.61368 .01472 m
.61368 .01847 L
s
.68947 .01472 m
.68947 .01847 L
s
.72736 .01472 m
.72736 .01847 L
s
.76526 .01472 m
.76526 .01847 L
s
.84105 .01472 m
.84105 .01847 L
s
.87894 .01472 m
.87894 .01847 L
s
.91683 .01472 m
.91683 .01847 L
s
.00738 .01472 m
.00738 .01847 L
s
.99262 .01472 m
.99262 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.5 .11164 m
.50625 .11164 L
s
[(1)] .4875 .11164 1 0 Mshowa
.5 .20856 m
.50625 .20856 L
s
[(2)] .4875 .20856 1 0 Mshowa
.5 .30549 m
.50625 .30549 L
s
[(3)] .4875 .30549 1 0 Mshowa
.5 .40241 m
.50625 .40241 L
s
[(4)] .4875 .40241 1 0 Mshowa
.5 .49933 m
.50625 .49933 L
s
[(5)] .4875 .49933 1 0 Mshowa
.5 .59626 m
.50625 .59626 L
s
[(6)] .4875 .59626 1 0 Mshowa
.125 Mabswid
.5 .0341 m
.50375 .0341 L
s
.5 .05348 m
.50375 .05348 L
s
.5 .07287 m
.50375 .07287 L
s
.5 .09225 m
.50375 .09225 L
s
.5 .13102 m
.50375 .13102 L
s
.5 .15041 m
.50375 .15041 L
s
.5 .16979 m
.50375 .16979 L
s
.5 .18918 m
.50375 .18918 L
s
.5 .22795 m
.50375 .22795 L
s
.5 .24733 m
.50375 .24733 L
s
.5 .26672 m
.50375 .26672 L
s
.5 .2861 m
.50375 .2861 L
s
.5 .32487 m
.50375 .32487 L
s
.5 .34425 m
.50375 .34425 L
s
.5 .36364 m
.50375 .36364 L
s
.5 .38302 m
.50375 .38302 L
s
.5 .42179 m
.50375 .42179 L
s
.5 .44118 m
.50375 .44118 L
s
.5 .46056 m
.50375 .46056 L
s
.5 .47995 m
.50375 .47995 L
s
.5 .51872 m
.50375 .51872 L
s
.5 .5381 m
.50375 .5381 L
s
.5 .55749 m
.50375 .55749 L
s
.5 .57687 m
.50375 .57687 L
s
.5 .61564 m
.50375 .61564 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.02499 .6033 L
.02605 .60324 L
.02729 .60312 L
.02846 .60297 L
.03053 .60259 L
.03279 .60203 L
.03527 .60122 L
.0379 .60015 L
.04262 .5977 L
.05205 .59089 L
.06244 .58072 L
.10458 .52227 L
.14487 .46475 L
.18364 .41889 L
.22486 .36985 L
.26457 .31545 L
.30277 .26369 L
.34341 .21587 L
.38254 .16898 L
.42412 .10871 L
.44499 .07814 L
.45414 .06615 L
.46419 .05468 L
.47388 .04578 L
.47853 .04238 L
.48294 .03973 L
.48533 .03854 L
.48793 .03743 L
.4901 .03667 L
.49249 .03601 L
.49374 .03573 L
.49507 .03549 L
.49581 .03538 L
.49649 .0353 L
.49718 .03523 L
.49782 .03518 L
.49896 .03512 L
.50021 .0351 L
.50144 .03513 L
.50274 .03522 L
.50397 .03535 L
.50533 .03556 L
.50674 .03583 L
.50807 .03615 L
.51298 .0378 L
.51578 .03907 L
.51834 .04044 L
.52409 .04422 L
.53442 .05327 L
Mistroke
.54424 .06417 L
.58248 .11875 L
.62318 .17639 L
.66236 .22239 L
.704 .27238 L
.74412 .3277 L
.78272 .37946 L
.82377 .42726 L
.86331 .47556 L
.90134 .53126 L
.92252 .56211 L
.93177 .57403 L
.94181 .5852 L
.95099 .59336 L
.95503 .59624 L
.95948 .59887 L
.96366 .60081 L
.96759 .60213 L
.96975 .60265 L
.97173 .603 L
.97277 .60313 L
.9739 .60323 L
.97509 .6033 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{254, 156.875},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003n0000W1P00`40o`000?l0003oo_ooo`004ooo
o`80000Soooo0`00023oool30000@oooo`<0000Roooo0`00023oool200004oooo`004oooo`030000
oooo000002?oool00`000?ooooooo`0Ooooo00<0003oooooool0@oooo`030000oooooooo02?oool0
0`000?ooooooo`0Ooooo00<0003oool000004_ooo`003_ooo`<00002oooo00<0003oool000007?oo
o`<00002oooo100001_oool300000oooo`030000oooooooo04?oool00`000?ooooooo`0Poooo1000
023oool00`000?ooo`00000Boooo000Coooo0P0002;oool00`000?ooo`00000Roooo00<0003ooooo
ool0@oooo`030000oooooooo023oool00`000?ooo`00000Qoooo0P0001?oool001?oool00`000?oo
ooooo`0Roooo0P00027oool00`000?ooo`000013oooo00<0003oool000008_ooo`80000Qoooo00<0
003oooooool04_ooo`005?ooo`80000Soooo00<0003oooooool08?ooo`030000oooooooo04?oool0
0`000?ooooooo`0Roooo00<0003oooooool08?ooo`80000Boooo003noooo001noooo00<0003ooooo
ool0OOooo`00O_ooo`030000oooooooo07goool007koool00`000?ooooooo`1moooo001noooo00<0
003oooooool0OOooo`001oooonl00008oooo000Boooo00<0003oooooool08Oooo`030000oooooooo
027oool00`000?ooooooo`0Qoooo00<0003oooooool08Oooo`030000oooooooo027oool00`000?oo
ooooo`0Qoooo00<0003oooooool04Oooo`00O_ooo`030000oooooooo07goool007koool00`000?oo
ooooo`1moooo001moooo0`0007koool007_oool80000Noooo`00NOooo`800003oooo00D0003ooooo
ooooool00000Noooo`00N?ooo`030000oooooooo00?oool00`000?ooooooo`02oooo0P0007Woool0
07Koool200001_ooo`030000oooooooo00Coool00`000?ooooooo`1foooo001eoooo00<0003ooooo
ool01_ooo`800006oooo00<0003oooooool0MOooo`00M?ooo`030000oooooooo00Ooool00`000?oo
ooooo`06oooo0P0007Goool007Coool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000
oooooooo07;oool007?oool00`000?ooooooo`08oooo00<0003oooooool02Oooo`030000oooooooo
077oool007;oool00`000?ooooooo`09oooo0P0000[oool00`000?ooooooo`1aoooo001boooo00<0
003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`1`oooo001aoooo00<0003ooooo
ool02_ooo`030000oooooooo00_oool00`000?ooooooo`1_oooo001`oooo00<0003oooooool02ooo
o`030000oooooooo00_oool00`000?ooooooo`1_oooo001`oooo00<0003oooooool02oooo`030000
oooooooo00coool00`000?ooooooo`1^oooo001_oooo00<0003oooooool03?ooo`80000>oooo00<0
003oooooool0KOooo`00K_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool0K?ooo`00KOooo`030000oooooooo00koool00`000?ooooooo`0>oooo00<0003oooooool0K?oo
o`00KOooo`030000oooooooo00Koool500000oooo`030000oooooooo00ooool00`000?ooooooo`1[
oooo001/oooo00<0003oooooool02Oooo`030000oooooooo00?oool00`000?ooooooo`0@oooo00<0
003oooooool0J_ooo`00Joooo`030000oooooooo00[oool00`000?ooooooo`03oooo0P00017oool0
0`000?ooooooo`1Zoooo001[oooo00<0003oooooool02_ooo`030000oooooooo00?oool00`000?oo
ooooo`0Aoooo00<0003oooooool0JOooo`00J_ooo`030000oooooooo00_oool00`000?ooooooo`03
oooo00<0003oooooool04_ooo`030000oooooooo06Soool006Woool00`000?ooooooo`0;oooo0P00
00Goool00`000?ooooooo`0Boooo00<0003oooooool0J?ooo`00J?ooo`030000oooooooo01?oool2
00005?ooo`030000oooooooo06Ooool006Soool00`000?ooooooo`0Coooo00<0003oooooool05?oo
o`030000oooooooo06Koool006Ooool00`000?ooooooo`0Doooo00<0003oooooool05?ooo`030000
oooooooo06Koool006Koool00`000?ooooooo`0Eoooo00<0003oooooool05Oooo`030000oooooooo
06Goool006Koool00`000?ooooooo`0Eoooo00<0003oooooool05_ooo`030000oooooooo06Coool0
06Goool00`000?ooooooo`0Foooo0P0001Ooool00`000?ooooooo`1Toooo001Toooo00<0003ooooo
ool05oooo`030000oooooooo01Ooool00`000?ooooooo`1Soooo001Soooo00<0003oooooool06?oo
o`030000oooooooo01Ooool00`000?ooooooo`1Soooo001Soooo00<0003oooooool06?ooo`030000
oooooooo01Soool00`000?ooooooo`1Roooo001Roooo00<0003oooooool06Oooo`030000oooooooo
01Woool00`000?ooooooo`1Qoooo001Qoooo00<0003oooooool06_ooo`80000Joooo00<0003ooooo
ool0HOooo`00H?ooo`030000oooooooo01_oool00`000?ooooooo`0Joooo00<0003oooooool0H?oo
o`00H?ooo`030000oooooooo01_oool00`000?ooooooo`0Koooo00<0003oooooool0Goooo`00Gooo
o`030000oooooooo01coool00`000?ooooooo`0Loooo00<0003oooooool0G_ooo`00G_ooo`030000
oooooooo01goool200007_ooo`030000oooooooo05goool005goool00`000?ooooooo`0Noooo00<0
003oooooool07_ooo`030000oooooooo05coool005goool00`000?ooooooo`0Noooo00<0003ooooo
ool07oooo`030000oooooooo05_oool005coool00`000?ooooooo`0Hoooo0`0000Coool00`000?oo
ooooo`0Ooooo00<0003oooooool0Foooo`00Foooo`030000oooooooo01Woool00`000?ooooooo`04
oooo00<0003oooooool08?ooo`030000oooooooo05[oool005[oool00`000?ooooooo`0Koooo00<0
003oooooool00oooo`80000Roooo00<0003oooooool0FOooo`00F_ooo`030000oooooooo01_oool0
0`000?ooooooo`03oooo00<0003oooooool08_ooo`030000oooooooo05Soool005Woool00`000?oo
ooooo`0Koooo00<0003oool000001?ooo`030000oooooooo02?oool00`000?ooooooo`1Goooo001H
oooo00<0003oooooool07Oooo`030000oooooooo00?oool00`000?ooooooo`0Toooo00<0003ooooo
ool0E_ooo`00Eoooo`030000oooooooo02Coool200009_ooo`030000oooooooo05Goool005Koool0
0`000?ooooooo`0Uoooo00<0003oooooool09_ooo`030000oooooooo05Coool005Goool00`000?oo
ooooo`0Voooo00<0003oooooool09oooo`030000oooooooo05?oool005Coool00`000?ooooooo`0W
oooo00<0003oooooool09oooo`030000oooooooo05?oool005Coool00`000?ooooooo`0Woooo00<0
003oooooool0:?ooo`030000oooooooo05;oool005?oool00`000?ooooooo`0Xoooo0P0002[oool0
0`000?ooooooo`1Aoooo001Boooo00<0003oooooool0:Oooo`030000oooooooo02[oool00`000?oo
ooooo`1@oooo001Aoooo00<0003oooooool0:_ooo`030000oooooooo02_oool00`000?ooooooo`1?
oooo001@oooo00<0003oooooool0:oooo`030000oooooooo02coool00`000?ooooooo`1>oooo001?
oooo00<0003oooooool0;?ooo`030000oooooooo02coool00`000?ooooooo`1>oooo001>oooo00<0
003oooooool0;Oooo`80000^oooo00<0003oooooool0COooo`00COooo`030000oooooooo02koool0
0`000?ooooooo`0^oooo00<0003oooooool0C?ooo`00COooo`030000oooooooo02koool00`000?oo
ooooo`0_oooo00<0003oooooool0Boooo`00C?ooo`030000oooooooo02ooool00`000?ooooooo`0_
oooo00<0003oooooool0Boooo`00Boooo`030000oooooooo033oool20000<Oooo`030000oooooooo
04[oool004[oool00`000?ooooooo`0aoooo00<0003oooooool0<Oooo`030000oooooooo04Woool0
04[oool00`000?ooooooo`0aoooo00<0003oooooool0<Oooo`030000oooooooo04Woool004Woool0
0`000?ooooooo`0[oooo0P0000Goool00`000?ooooooo`0boooo00<0003oooooool0B?ooo`00B?oo
o`030000oooooooo02koool00`000?ooooooo`02oooo00<0003oooooool0<oooo`030000oooooooo
04Ooool004Ooool00`000?ooooooo`0^oooo00<0003oooooool00oooo`80000eoooo00<0003ooooo
ool0A_ooo`00Aoooo`030000oooooooo02ooool00`000?ooooooo`02oooo00<0003oooooool0=?oo
o`030000oooooooo04Koool004Koool00`000?ooooooo`0^oooo00<0003oool000001?ooo`030000
oooooooo03Goool00`000?ooooooo`15oooo0015oooo00<0003oooooool0<?ooo`030000oooooooo
00?oool00`000?ooooooo`0foooo00<0003oooooool0A?ooo`00A?ooo`030000oooooooo03Ooool0
0`000?ooooooo`0foooo00<0003oooooool0A?ooo`00A?ooo`030000oooooooo03Ooool20000>?oo
o`030000oooooooo04?oool004?oool00`000?ooooooo`0hoooo00<0003oooooool0>?ooo`030000
oooooooo04;oool004;oool00`000?ooooooo`0ioooo00<0003oooooool0>?ooo`030000oooooooo
04;oool0047oool00`000?ooooooo`0joooo00<0003oooooool0>Oooo`030000oooooooo047oool0
047oool00`000?ooooooo`0joooo0P0003_oool00`000?ooooooo`10oooo0010oooo00<0003ooooo
ool0>oooo`030000oooooooo03[oool00`000?ooooooo`10oooo000ooooo00<0003oooooool0??oo
o`030000oooooooo03_oool00`000?ooooooo`0ooooo000noooo00<0003oooooool0?Oooo`030000
oooooooo03coool00`000?ooooooo`0noooo000noooo00<0003oooooool0?Oooo`030000oooooooo
03goool00`000?ooooooo`0moooo000moooo00<0003oooooool0?_ooo`80000noooo00<0003ooooo
ool0?Oooo`00??ooo`030000oooooooo03ooool00`000?ooooooo`0noooo00<0003oooooool0??oo
o`00>oooo`030000oooooooo043oool00`000?ooooooo`0ooooo00<0003oooooool0>oooo`00>_oo
o`030000oooooooo047oool00`000?ooooooo`0ooooo00<0003oooooool0>oooo`00>_ooo`030000
oooooooo047oool20000@Oooo`030000oooooooo03[oool003Woool00`000?ooooooo`12oooo00<0
003oooooool0@Oooo`030000oooooooo03Woool003Soool00`000?ooooooo`13oooo00<0003ooooo
ool0@_ooo`030000oooooooo03Soool003Ooool00`000?ooooooo`0noooo0`0000?oool00`000?oo
ooooo`13oooo00<0003oooooool0=oooo`00=oooo`030000oooooooo03ooool00`000?ooooooo`02
oooo00<0003oooooool0A?ooo`030000oooooooo03Koool003Koool00`000?ooooooo`0noooo1000
00?oool20000A_ooo`030000oooooooo03Goool003Goool00`000?ooooooo`0ooooo00<0003oool0
00001?ooo`030000oooooooo04Goool00`000?ooooooo`0eoooo000doooo00<0003oooooool0@Ooo
o`800004oooo00<0003oooooool0A_ooo`030000oooooooo03Coool003Coool00`000?ooooooo`12
oooo00<0003oooooool00_ooo`030000oooooooo04Ooool00`000?ooooooo`0coooo000coooo00<0
003oooooool0B?ooo`030000oooooooo04Soool00`000?ooooooo`0boooo000boooo00<0003ooooo
ool0BOooo`80001:oooo00<0003oooooool0<Oooo`00<Oooo`030000oooooooo04[oool00`000?oo
ooooo`1:oooo00<0003oooooool0<?ooo`00<?ooo`030000oooooooo04_oool00`000?ooooooo`1;
oooo00<0003oooooool0;oooo`00;oooo`030000oooooooo04coool00`000?ooooooo`1<oooo00<0
003oooooool0;_ooo`00;_ooo`030000oooooooo04goool20000C_ooo`030000oooooooo02goool0
02koool00`000?ooooooo`1=oooo00<0003oooooool0COooo`030000oooooooo02goool002goool0
0`000?ooooooo`1>oooo00<0003oooooool0C_ooo`030000oooooooo02coool002coool00`000?oo
ooooo`1?oooo00<0003oooooool0Coooo`030000oooooooo02_oool002_oool00`000?ooooooo`1@
oooo00<0003oooooool0D?ooo`030000oooooooo02[oool002[oool00`000?ooooooo`1Aoooo0P00
05;oool00`000?ooooooo`0Yoooo000Yoooo00<0003oooooool0D_ooo`030000oooooooo05;oool0
0`000?ooooooo`0Xoooo000Xoooo00<0003oooooool0Doooo`030000oooooooo05;oool00`000?oo
ooooo`0Xoooo000Xoooo00<0003oooooool0Doooo`030000oooooooo05?oool00`000?ooooooo`0W
oooo000Woooo00<0003oooooool0E?ooo`030000oooooooo05Coool00`000?ooooooo`0Voooo000V
oooo00<0003oooooool0EOooo`80001Foooo00<0003oooooool09Oooo`009_ooo`030000oooooooo
05Goool00`000?ooooooo`1Eoooo00<0003oooooool09Oooo`009Oooo`030000oooooooo053oool0
0`000?ooooooo`03oooo00<0003oooooool0E_ooo`030000oooooooo02Coool002Coool00`000?oo
ooooo`1@oooo00<0003oool000001?ooo`030000oooooooo05Ooool00`000?ooooooo`0Soooo000T
oooo00<0003oooooool0D_ooo`030000oooooooo00;oool20000F?ooo`030000oooooooo02?oool0
02?oool00`000?ooooooo`1Aoooo0P0000Goool00`000?ooooooo`1Hoooo00<0003oooooool08_oo
o`008oooo`030000oooooooo057oool00`000?ooooooo`04oooo00<0003oooooool0FOooo`030000
oooooooo027oool002;oool00`000?ooooooo`1Boooo0`0000Coool00`000?ooooooo`1Joooo00<0
003oooooool08?ooo`008Oooo`030000oooooooo05[oool00`000?ooooooo`1Joooo00<0003ooooo
ool08?ooo`008Oooo`030000oooooooo05[oool20000G?ooo`030000oooooooo01ooool0023oool0
0`000?ooooooo`1Koooo00<0003oooooool0G?ooo`030000oooooooo01koool001ooool00`000?oo
ooooo`1Loooo00<0003oooooool0G?ooo`030000oooooooo01koool001ooool00`000?ooooooo`1L
oooo00<0003oooooool0GOooo`030000oooooooo01goool001koool00`000?ooooooo`1Moooo0P00
05ooool00`000?ooooooo`0Loooo000Moooo00<0003oooooool0G_ooo`030000oooooooo05koool0
0`000?ooooooo`0Loooo000Loooo00<0003oooooool0Goooo`030000oooooooo05ooool00`000?oo
ooooo`0Koooo000Loooo00<0003oooooool0Goooo`030000oooooooo063oool00`000?ooooooo`0J
oooo000Koooo00<0003oooooool0H?ooo`030000oooooooo067oool00`000?ooooooo`0Ioooo000J
oooo00<0003oooooool0HOooo`80001Roooo00<0003oooooool06Oooo`006_ooo`030000oooooooo
067oool00`000?ooooooo`1Roooo00<0003oooooool06?ooo`006Oooo`030000oooooooo06;oool0
0`000?ooooooo`1Soooo00<0003oooooool05oooo`006?ooo`030000oooooooo06?oool00`000?oo
ooooo`1Soooo00<0003oooooool05oooo`005oooo`030000oooooooo06Coool00`000?ooooooo`1T
oooo00<0003oooooool05_ooo`005oooo`030000oooooooo06Coool20000I_ooo`030000oooooooo
01Goool001Koool00`000?ooooooo`1Uoooo00<0003oooooool0IOooo`030000oooooooo01Goool0
01Coool20000HOooo`800005oooo00<0003oooooool0I_ooo`030000oooooooo01Coool001?oool0
0`000?ooooooo`1Qoooo00<0003oool000001?ooo`030000oooooooo06Ooool200005?ooo`004_oo
o`030000oooooooo06;oool00`000?ooo`000004oooo0P0006[oool200004_ooo`003oooo`<0001U
oooo0P0000Goool00`000?ooooooo`1[oooo0P00013oool000coool40000Ioooo`030000oooooooo
00Coool00`000?ooooooo`1]oooo0`0000goool007Soool200001?ooo`030000oooooooo07goool0
07koool00`000?ooooooo`1moooo001noooo0P0007koool00001\
\>"],
  ImageRangeCache->{{{0, 253}, {155.875, 0}} -> {-6.9983, -0.518278, 
  0.0553225, 0.0432588}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Table[c[n], {n, \(-5\), 5}]\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Discrete\ Fourier\ Series\)], "Input"],

Cell[BoxData[
    \(d \((k)\) = 
      \[Sum]\+\(n = 0\)\%\(N - 1\)f[\(2  nL\)\/N] 
          Exp[\(-I\) \(2\ k\ n\ \[Pi]\)\/N]\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(f[2  nL] = 
      \(1\/N\) \(\[Sum]\+\(k = 1\)\%\(N - 1\)d \((k)\) 
            Exp[I \( 2\ k\ n\ \[Pi]\)\/N]\)\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    StyleBox["Ex1",
      FontVariations->{"Underline"->True}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[N[f[\(4  \[Pi]\ m\)\/8]], {m, \(-4\), 3}]\)], "Input"],

Cell[BoxData[
    \({6.28318530717958623`, 4.71238898038468967`, 3.14159265358979311`, 
      1.57079632679489655`, 0, 1.57079632679489655`, 3.14159265358979311`, 
      4.71238898038468967`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[Table[N[f[\(4  \[Pi]\ m\)\/8]], {m, \(-4\), 3}], \ 
      PlotStyle -> {PointSize[0.02]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.112245 0.136054 0.0147151 0.0936792 [
[.15986 .00222 -3 -9 ]
[.15986 .00222 3 0 ]
[.29592 .00222 -3 -9 ]
[.29592 .00222 3 0 ]
[.43197 .00222 -3 -9 ]
[.43197 .00222 3 0 ]
[.56803 .00222 -3 -9 ]
[.56803 .00222 3 0 ]
[.70408 .00222 -3 -9 ]
[.70408 .00222 3 0 ]
[.84014 .00222 -3 -9 ]
[.84014 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .10839 -6 -4.5 ]
[.01131 .10839 0 4.5 ]
[.01131 .20207 -6 -4.5 ]
[.01131 .20207 0 4.5 ]
[.01131 .29575 -6 -4.5 ]
[.01131 .29575 0 4.5 ]
[.01131 .38943 -6 -4.5 ]
[.01131 .38943 0 4.5 ]
[.01131 .48311 -6 -4.5 ]
[.01131 .48311 0 4.5 ]
[.01131 .57679 -6 -4.5 ]
[.01131 .57679 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.15986 .01472 m
.15986 .02097 L
s
[(2)] .15986 .00222 0 1 Mshowa
.29592 .01472 m
.29592 .02097 L
s
[(3)] .29592 .00222 0 1 Mshowa
.43197 .01472 m
.43197 .02097 L
s
[(4)] .43197 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(5)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(6)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(7)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(8)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .10839 m
.03006 .10839 L
s
[(1)] .01131 .10839 1 0 Mshowa
.02381 .20207 m
.03006 .20207 L
s
[(2)] .01131 .20207 1 0 Mshowa
.02381 .29575 m
.03006 .29575 L
s
[(3)] .01131 .29575 1 0 Mshowa
.02381 .38943 m
.03006 .38943 L
s
[(4)] .01131 .38943 1 0 Mshowa
.02381 .48311 m
.03006 .48311 L
s
[(5)] .01131 .48311 1 0 Mshowa
.02381 .57679 m
.03006 .57679 L
s
[(6)] .01131 .57679 1 0 Mshowa
.125 Mabswid
.02381 .03345 m
.02756 .03345 L
s
.02381 .05219 m
.02756 .05219 L
s
.02381 .07092 m
.02756 .07092 L
s
.02381 .08966 m
.02756 .08966 L
s
.02381 .12713 m
.02756 .12713 L
s
.02381 .14587 m
.02756 .14587 L
s
.02381 .1646 m
.02756 .1646 L
s
.02381 .18334 m
.02756 .18334 L
s
.02381 .22081 m
.02756 .22081 L
s
.02381 .23955 m
.02756 .23955 L
s
.02381 .25828 m
.02756 .25828 L
s
.02381 .27702 m
.02756 .27702 L
s
.02381 .31449 m
.02756 .31449 L
s
.02381 .33322 m
.02756 .33322 L
s
.02381 .35196 m
.02756 .35196 L
s
.02381 .3707 m
.02756 .3707 L
s
.02381 .40817 m
.02756 .40817 L
s
.02381 .4269 m
.02756 .4269 L
s
.02381 .44564 m
.02756 .44564 L
s
.02381 .46438 m
.02756 .46438 L
s
.02381 .50185 m
.02756 .50185 L
s
.02381 .52058 m
.02756 .52058 L
s
.02381 .53932 m
.02756 .53932 L
s
.02381 .55805 m
.02756 .55805 L
s
.02381 .59553 m
.02756 .59553 L
s
.02381 .61426 m
.02756 .61426 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.02381 .60332 Mdot
.15986 .45617 Mdot
.29592 .30902 Mdot
.43197 .16187 Mdot
.56803 .01472 Mdot
.70408 .16187 Mdot
.84014 .30902 Mdot
.97619 .45617 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{274, 169.25},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004B0000ZAP00`40o`000?l0003ooooooa?oool0
033oool300008?ooo`80000Roooo0`00027oool00`000?ooooooo`0Ooooo0P0002;oool00`000?oo
ooooo`0Poooo00<0003oooooool02oooo`00<?ooo`030000oooooooo02;oool00`000?ooooooo`0P
oooo00<0003oooooool07oooo`030000oooo0000023oool00`000?ooo`00000Qoooo00<0003ooooo
ool07oooo`030000oooo000000coool0037oool00`000?ooooooo`0Poooo00<0003oooooool07ooo
o`@0000Roooo00<0003oooooool07_ooo`030000oooo0000027oool00`000?ooooooo`0Ooooo00<0
003oool000003?ooo`00<Oooo`030000oooooooo027oool00`000?ooooooo`0Noooo00<0003oool0
00008Oooo`80000Qoooo0P0002?oool00`000?ooooooo`0Ooooo00<0003oooooool02oooo`00<?oo
o`030000oooo0000023oool00`000?ooo`00000Qoooo0P00027oool00`000?ooooooo`0Poooo00<0
003oooooool08?ooo`030000oooo0000023oool00`000?ooo`00000<oooo000aoooo00<0003ooooo
ool08?ooo`030000oooooooo027oool00`000?ooooooo`0Ooooo0`00027oool200008?ooo`<0000Q
oooo00<0003oooooool02oooo`00oooooa?oool00?oooolCoooo000>oooo00<0003oooooool0oooo
o`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo08Woool30000MOoo
o`002?ooool0000500001_ooo`003_ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0
003oooooool01Oooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?oo
o`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo
00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?oo
ooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0
003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`02oooo1@0000Coool00`000?oo
ooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0
003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?oo
o`030000oooooooo00Coool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo
00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00[oool000koool0
0`000?ooooooo`0Qoooo00<0003oooooool08?ooo`030000oooooooo023oool00`000?ooooooo`0N
oooo1@00023oool00`000?ooooooo`0Poooo00<0003oooooool08Oooo`030000oooooooo00[oool0
00koool00`000?ooooooo`29oooo0`0007Goool000koool00`000?ooooooo`3ooooo0_ooo`003_oo
o`80003ooooo0oooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0oooo
o`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>
oooo0P000?ooool3oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3o
oooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool0
00koool20000ooooo`?oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo
0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_oo
o`003_ooo`80003ooooo0oooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003ooooo
ool0ooooo`;oool000Koool500000oooo`030000oooooooo0?ooool2oooo0008oooo00<0003ooooo
ool00oooo`030000oooooooo0?ooool2oooo0008oooo00<0003oooooool00oooo`<0003ooooo0_oo
o`002?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo0_ooo`002?ooo`030000oooooooo
00?oool00`000?ooooooo`3ooooo0_ooo`001oooo`800005oooo00<0003oooooool0ooooo`;oool0
00koool00`000?ooooooo`3ooooo0_ooo`003_ooo`80003ooooo0oooo`003_ooo`030000oooooooo
0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_oo
o`003_ooo`80003ooooo0oooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003ooooo
ool0ooooo`;oool000koool00`000?ooooooo`1Voooo0`0004?oool30000D_ooo`003_ooo`030000
oooooooo06Goool50000@Oooo`D0001Aoooo000>oooo0P0006Koool50000@Oooo`D0001Aoooo000>
oooo00<0003oooooool0IOooo`D00011oooo1@00057oool000koool00`000?ooooooo`1Voooo0`00
04?oool30000D_ooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0oooo
o`;oool000koool20000ooooo`?oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000
oooooooo0?ooool2oooo0007oooo0`0000Coool00`000?ooooooo`3ooooo0_ooo`001oooo`030000
oooooooo00Coool00`000?ooooooo`3ooooo0_ooo`002?ooo`030000oooooooo00?oool30000oooo
o`;oool000Soool00`000?ooooooo`03oooo00<0003oooooool0ooooo`;oool000Ooool00`000?oo
o`000004oooo00<0003oooooool0ooooo`;oool000Soool00`000?ooooooo`03oooo00<0003ooooo
ool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`80003ooooo0oooo`003_oo
o`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?oo
ooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo0P000?ooool3oooo000>
oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000
oooooooo0?ooool2oooo000>oooo0P000?ooool3oooo000>oooo00<0003oooooool0ooooo`;oool0
00koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0
003oooooool0ooooo`;oool000koool20000ooooo`?oool000koool00`000?ooooooo`3ooooo0_oo
o`003_ooo`030000oooooooo0?ooool2oooo0007oooo0P0000Goool00`000?ooooooo`3ooooo0_oo
o`002Oooo`030000oooooooo00;oool00`000?ooooooo`3ooooo0_ooo`002?ooo`030000oooooooo
00?oool30000ooooo`;oool000Woool00`000?ooooooo`02oooo00<0003oooooool0ooooo`;oool0
00Ooool00`000?ooo`000004oooo00<0003oooooool0@oooo`<00029oooo0`0002ooool000Soool0
0`000?ooooooo`03oooo00<0003oooooool0@_ooo`D00027oooo1@0002koool000koool00`000?oo
ooooo`12oooo1@0008Ooool50000;_ooo`003_ooo`800013oooo1@0008Ooool50000;_ooo`003_oo
o`030000oooooooo04?oool30000ROooo`<0000_oooo000>oooo00<0003oooooool0ooooo`;oool0
00koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo0P00
0?ooool3oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_oo
o`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool000koool2
0000ooooo`?oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2
oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_oo
o`80003ooooo0oooo`003_ooo`030000oooooooo0?ooool2oooo0008oooo0`0000?oool00`000?oo
ooooo`3ooooo0_ooo`002Oooo`030000oooooooo00;oool00`000?ooooooo`3ooooo0_ooo`001ooo
o`@00003oooo0`000?ooool2oooo0007oooo00<0003oool000001?ooo`030000oooooooo0?ooool2
oooo0008oooo0P0000Coool00`000?ooooooo`3ooooo0_ooo`002Oooo`030000oooooooo00;oool0
0`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo0P000?ooool3
oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_oo
o`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool000koool20000oooo
o`?oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>
oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`80003o
oooo0oooo`003_ooo`030000oooooooo023oool30000d?ooo`<0000;oooo000>oooo00<0003ooooo
ool07oooo`D0003>oooo1@0000[oool000koool00`000?ooooooo`0Ooooo1@000<koool500002_oo
o`003_ooo`030000oooooooo01ooool50000c_ooo`D0000:oooo000>oooo0P00027oool30000d?oo
o`<0000;oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_oo
o`002?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo0_ooo`001oooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0_ooo`002Oooo`030000oooooooo00;oool30000ooooo`;oool0
00Ooool200001Oooo`030000oooooooo0?ooool2oooo0007oooo00<0003oooooool01?ooo`030000
oooooooo0?ooool2oooo0007oooo0`0000Coool00`000?ooooooo`3ooooo0_ooo`003_ooo`80003o
oooo0oooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool0
00koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo0P00
0?ooool3oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_oo
o`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0ooooo`;oool000koool2
0000ooooo`?oool000koool00`000?ooooooo`3ooooo0_ooo`003_ooo`030000oooooooo0?ooool2
oooo000>oooo00<0003oooooool0ooooo`;oool000koool00`000?ooooooo`3ooooo0_ooo`003_oo
o`80003ooooo0oooo`003_ooo`030000oooooooo0?ooool2oooo000>oooo00<0003oooooool0oooo
o`;oool000Ooool200001Oooo`030000oooooooo0?ooool2oooo0007oooo00<0003oool000001?oo
o`030000oooooooo0?ooool2oooo0007oooo00<0003oool000001?ooo`<0003ooooo0_ooo`001ooo
o`800005oooo00<0003oooooool0ooooo`;oool000Ooool00`000?ooooooo`04oooo00<0003ooooo
ool0ooooo`;oool000Soool200001?ooo`030000oooooooo0?ooool2oooo000>oooo00<0003ooooo
ool0ooooo`;oool000goool30000ooooo`?oool000coool50000ooooo`;oool000coool50000oooo
o`;oool000coool50000ooooo`;oool000goool30000ooooo`?oool000koool20000ooooo`?oool0
0001\
\>"],
  ImageRangeCache->{{{0, 273}, {168.25, 0}} -> {0.576658, -0.504925, 
  0.0284224, 0.0412789}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(d[m_] := 
      \(1\/8\) \(\[Sum]\+\(n = \(-4\)\)\%3 f[\(4  \[Pi]\ n\)\/8] 
            Exp[\(-I\)\ \(2  m\ n\ \[Pi]\)\/8]\); \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[N[d[m]], {m, 0, 7}]\)], "Input"],

Cell[BoxData[
    \({3.14159265358979311`, \(-1.34075853066724381`\) + 0.`\ I, 0, 
      \(-0.230037796127652427`\) + 0.`\ I, 0, 
      \(-0.230037796127652427`\) + 0.`\ I, 0, 
      \(-1.34075853066724381`\) + 0.`\ I}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(F[n_] := 
      \[Sum]\+\(m = \(-4\)\)\%3 d[m] Exp[I\ \(\(2  m\ n\)\/8\) \[Pi]]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[N[F[m]], {m, \(-4\), 3}]\)], "Input"],

Cell[BoxData[
    \({\(6.28318530717958534`\[InvisibleSpace]\) + 0.`\ I, 
      \(4.71238898038468967`\[InvisibleSpace]\) + 0.`\ I, 
      3.14159265358979311`, 
      \(1.57079632679489655`\[InvisibleSpace]\) + 0.`\ I, 
      4.44089209850062616`*^-16 + 0.`\ I, 
      \(1.57079632679489655`\[InvisibleSpace]\) + 0.`\ I, 
      3.14159265358979311`, 
      \(4.71238898038468967`\[InvisibleSpace]\) + 0.`\ I}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListPlot[Table[N[F[m]], {m, \(-4\), 3}], \ 
      PlotStyle -> {PointSize[0.02]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.112245 0.136054 0.0147151 0.0936792 [
[.15986 .00222 -3 -9 ]
[.15986 .00222 3 0 ]
[.29592 .00222 -3 -9 ]
[.29592 .00222 3 0 ]
[.43197 .00222 -3 -9 ]
[.43197 .00222 3 0 ]
[.56803 .00222 -3 -9 ]
[.56803 .00222 3 0 ]
[.70408 .00222 -3 -9 ]
[.70408 .00222 3 0 ]
[.84014 .00222 -3 -9 ]
[.84014 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.01131 .10839 -6 -4.5 ]
[.01131 .10839 0 4.5 ]
[.01131 .20207 -6 -4.5 ]
[.01131 .20207 0 4.5 ]
[.01131 .29575 -6 -4.5 ]
[.01131 .29575 0 4.5 ]
[.01131 .38943 -6 -4.5 ]
[.01131 .38943 0 4.5 ]
[.01131 .48311 -6 -4.5 ]
[.01131 .48311 0 4.5 ]
[.01131 .57679 -6 -4.5 ]
[.01131 .57679 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.15986 .01472 m
.15986 .02097 L
s
[(2)] .15986 .00222 0 1 Mshowa
.29592 .01472 m
.29592 .02097 L
s
[(3)] .29592 .00222 0 1 Mshowa
.43197 .01472 m
.43197 .02097 L
s
[(4)] .43197 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(5)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(6)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(7)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(8)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .10839 m
.03006 .10839 L
s
[(1)] .01131 .10839 1 0 Mshowa
.02381 .20207 m
.03006 .20207 L
s
[(2)] .01131 .20207 1 0 Mshowa
.02381 .29575 m
.03006 .29575 L
s
[(3)] .01131 .29575 1 0 Mshowa
.02381 .38943 m
.03006 .38943 L
s
[(4)] .01131 .38943 1 0 Mshowa
.02381 .48311 m
.03006 .48311 L
s
[(5)] .01131 .48311 1 0 Mshowa
.02381 .57679 m
.03006 .57679 L
s
[(6)] .01131 .57679 1 0 Mshowa
.125 Mabswid
.02381 .03345 m
.02756 .03345 L
s
.02381 .05219 m
.02756 .05219 L
s
.02381 .07092 m
.02756 .07092 L
s
.02381 .08966 m
.02756 .08966 L
s
.02381 .12713 m
.02756 .12713 L
s
.02381 .14587 m
.02756 .14587 L
s
.02381 .1646 m
.02756 .1646 L
s
.02381 .18334 m
.02756 .18334 L
s
.02381 .22081 m
.02756 .22081 L
s
.02381 .23955 m
.02756 .23955 L
s
.02381 .25828 m
.02756 .25828 L
s
.02381 .27702 m
.02756 .27702 L
s
.02381 .31449 m
.02756 .31449 L
s
.02381 .33322 m
.02756 .33322 L
s
.02381 .35196 m
.02756 .35196 L
s
.02381 .3707 m
.02756 .3707 L
s
.02381 .40817 m
.02756 .40817 L
s
.02381 .4269 m
.02756 .4269 L
s
.02381 .44564 m
.02756 .44564 L
s
.02381 .46438 m
.02756 .46438 L
s
.02381 .50185 m
.02756 .50185 L
s
.02381 .52058 m
.02756 .52058 L
s
.02381 .53932 m
.02756 .53932 L
s
.02381 .55805 m
.02756 .55805 L
s
.02381 .59553 m
.02756 .59553 L
s
.02381 .61426 m
.02756 .61426 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.02381 .60332 Mdot
.15986 .45617 Mdot
.29592 .30902 Mdot
.43197 .16187 Mdot
.56803 .01472 Mdot
.70408 .16187 Mdot
.84014 .30902 Mdot
.97619 .45617 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/AP00`40o`000?l0003oooooob7oool0
03;oool300008_ooo`80000Toooo0`0002?oool00`000?ooooooo`0Qoooo0P0002Coool00`000?oo
ooooo`0Roooo00<0003oooooool02oooo`00<_ooo`030000oooooooo02Coool00`000?ooooooo`0R
oooo00<0003oooooool08Oooo`030000oooo000002;oool00`000?ooo`00000Soooo00<0003ooooo
ool08Oooo`030000oooo000000coool003?oool00`000?ooooooo`0Roooo00<0003oooooool08Ooo
o`@0000Toooo00<0003oooooool08?ooo`030000oooo000002?oool00`000?ooooooo`0Qoooo00<0
003oool000003?ooo`00<oooo`030000oooooooo02?oool00`000?ooooooo`0Poooo00<0003oool0
00008oooo`80000Soooo0P0002Goool00`000?ooooooo`0Qoooo00<0003oooooool02oooo`00<_oo
o`030000oooo000002;oool00`000?ooo`00000Soooo0P0002?oool00`000?ooooooo`0Roooo00<0
003oooooool08_ooo`030000oooo000002;oool00`000?ooo`00000<oooo000coooo00<0003ooooo
ool08_ooo`030000oooooooo02?oool00`000?ooooooo`0Qoooo0`0002?oool200008_ooo`<0000S
oooo00<0003oooooool02oooo`00ooooob7oool000ooool00`000?ooooooo`3ooooo3oooo`003ooo
o`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0T?ooo`<0001koooo000?oooo00<0
003oooooool0Soooo`D0001joooo0008ooooo`0001<00006oooo000?oooo00<0003oooooool01?oo
o`030000oooooooo00Coool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo
00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Coool00`000?oo
ooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Coool00`000?ooooooo`05oooo00<0
003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`05oooo00<0003oooooool01?oo
o`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo
00;oool500001?ooo`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Ooo
o`030000oooooooo00Coool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo
00Coool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?oo
ooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`04oooo00<0
003oooooool02oooo`003oooo`030000oooooooo02;oool00`000?ooooooo`0Roooo00<0003ooooo
ool08_ooo`030000oooooooo027oool300008oooo`030000oooooooo02;oool00`000?ooooooo`0R
oooo00<0003oooooool02oooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003ooooo
ool0ooooo`ooool000ooool20000oooooa3oool000ooool00`000?ooooooo`3ooooo3oooo`003ooo
o`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000ooool00`000?oo
ooooo`3ooooo3oooo`003oooo`80003ooooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?
oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000
oooooooo0?ooool?oooo000?oooo0P000?ooool@oooo000?oooo00<0003oooooool0ooooo`ooool0
00ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0
003oooooool0ooooo`ooool000ooool20000oooooa3oool000ooool00`000?ooooooo`3ooooo3ooo
o`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000Koool5
00001?ooo`030000oooooooo0?ooool?oooo0008oooo00<0003oooooool01?ooo`030000oooooooo
0?ooool?oooo0008oooo00<0003oooooool01?ooo`80003ooooo4?ooo`002?ooo`030000oooooooo
00Coool00`000?ooooooo`3ooooo3oooo`002?ooo`030000oooooooo00Coool00`000?ooooooo`3o
oooo3oooo`001oooo`800006oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3o
oooo3oooo`003oooo`80003ooooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0
003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo
0?ooool?oooo000?oooo0P000?ooool@oooo000?oooo00<0003oooooool0ooooo`ooool000ooool0
0`000?ooooooo`1[oooo0`0004Ooool30000E_ooo`003oooo`030000oooooooo06[oool50000AOoo
o`D0001Eoooo000?oooo00<0003oooooool0J_ooo`D00015oooo1@0005Goool000ooool20000Jooo
o`D00015oooo1@0005Goool000ooool00`000?ooooooo`1[oooo0`0004Ooool30000E_ooo`003ooo
o`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000ooool00`000?oo
ooooo`3ooooo3oooo`003oooo`80003ooooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?
oooo00<0003oooooool0ooooo`ooool000Ooool300001Oooo`030000oooooooo0?ooool?oooo0007
oooo00<0003oooooool01Oooo`030000oooooooo0?ooool?oooo0008oooo00<0003oooooool01?oo
o`80003ooooo4?ooo`002?ooo`030000oooooooo00Coool00`000?ooooooo`3ooooo3oooo`001ooo
o`030000oooo000000Goool00`000?ooooooo`3ooooo3oooo`002?ooo`030000oooooooo00Coool0
0`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo0?ooool?oooo000?oooo0P000?ooool@
oooo000?oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3oooo`003ooo
o`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000ooool20000oooo
oa3oool000ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo0?ooool?oooo000?
oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3oooo`003oooo`80003o
oooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool0
00ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0
003oooooool0ooooo`ooool000ooool20000oooooa3oool000ooool00`000?ooooooo`3ooooo3ooo
o`003oooo`030000oooooooo0?ooool?oooo0007oooo0P0000Koool00`000?ooooooo`3ooooo3ooo
o`002Oooo`030000oooooooo00?oool00`000?ooooooo`3ooooo3oooo`002?ooo`030000oooooooo
00Coool20000oooooa3oool000Woool00`000?ooooooo`03oooo00<0003oooooool0A_ooo`<0002A
oooo0`00037oool000Ooool00`000?ooo`000005oooo00<0003oooooool0AOooo`D0002?oooo1@00
033oool000Soool00`000?ooooooo`04oooo00<0003oooooool0AOooo`D0002?oooo1@00033oool0
00ooool00`000?ooooooo`15oooo1@0008ooool50000<?ooo`003oooo`800017oooo0`00097oool3
0000<Oooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool0
00ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo0?ooool?oooo000?oooo0P00
0?ooool@oooo000?oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3ooo
o`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000ooool2
0000oooooa3oool000ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo0?ooool?
oooo000?oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3oooo`003ooo
o`80003ooooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0oooo
o`ooool000Soool300001?ooo`030000oooooooo0?ooool?oooo0009oooo00<0003oooooool00ooo
o`030000oooooooo0?ooool?oooo0007oooo100000Coool20000oooooa3oool000Ooool00`000?oo
o`000005oooo00<0003oooooool0ooooo`ooool000Soool200001Oooo`030000oooooooo0?ooool?
oooo0009oooo00<0003oooooool00oooo`030000oooooooo0?ooool?oooo000?oooo00<0003ooooo
ool0ooooo`ooool000ooool20000oooooa3oool000ooool00`000?ooooooo`3ooooo3oooo`003ooo
o`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000ooool00`000?oo
ooooo`3ooooo3oooo`003oooo`80003ooooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?
oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000
oooooooo0?ooool?oooo000?oooo0P000?ooool@oooo000?oooo00<0003oooooool0ooooo`ooool0
00ooool00`000?ooooooo`0Qoooo0`000=_oool300003?ooo`003oooo`030000oooooooo023oool5
0000fOooo`D0000;oooo000?oooo00<0003oooooool08?ooo`D0003Ioooo1@0000_oool000ooool0
0`000?ooooooo`0Poooo1@000=Woool500002oooo`003oooo`80000Roooo0`000=_oool300003?oo
o`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000Soool0
0`000?ooooooo`04oooo00<0003oooooool0ooooo`ooool000Ooool00`000?ooo`000005oooo00<0
003oooooool0ooooo`ooool000Woool00`000?ooooooo`03oooo0P000?ooool@oooo0007oooo0P00
00Koool00`000?ooooooo`3ooooo3oooo`001oooo`030000oooooooo00Goool00`000?ooooooo`3o
oooo3oooo`001oooo`<00005oooo00<0003oooooool0ooooo`ooool000ooool00`000?ooooooo`3o
oooo3oooo`003oooo`80003ooooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0
003oooooool0ooooo`ooool000ooool00`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo
0?ooool?oooo000?oooo0P000?ooool@oooo000?oooo00<0003oooooool0ooooo`ooool000ooool0
0`000?ooooooo`3ooooo3oooo`003oooo`030000oooooooo0?ooool?oooo000?oooo00<0003ooooo
ool0ooooo`ooool000ooool20000oooooa3oool000ooool00`000?ooooooo`3ooooo3oooo`003ooo
o`030000oooooooo0?ooool?oooo000?oooo00<0003oooooool0ooooo`ooool000ooool00`000?oo
ooooo`3ooooo3oooo`003oooo`80003ooooo4?ooo`003oooo`030000oooooooo0?ooool?oooo000?
oooo00<0003oooooool0ooooo`ooool000Ooool200001_ooo`030000oooooooo0?ooool?oooo0007
oooo00<0003oool000001Oooo`030000oooooooo0?ooool?oooo0007oooo00<0003oool000001Ooo
o`80003ooooo4?ooo`001oooo`800006oooo00<0003oooooool0ooooo`ooool000Ooool00`000?oo
ooooo`05oooo00<0003oooooool0ooooo`ooool000Soool200001Oooo`030000oooooooo0?ooool?
oooo000?oooo00<0003oooooool0ooooo`ooool000ooool20000oooooa3oool000goool30000oooo
oa7oool000coool50000oooooa3oool000coool50000oooooa3oool000coool50000oooooa3oool0
00goool40000oooooa3oool000ooool00`000?ooooooo`3ooooo3oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0.593101, -0.485707, 
  0.0269521, 0.0391436}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Fourier\ Command\)], "Input"],

Cell[BoxData[
    \(Fourier[a]\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[
    \(InverseFourier[a]\)], "Input",
  Background->GrayLevel[0.900008]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\:4f8b1\)], "Input"],

Cell[BoxData[
    \(\(a = {1, 2, 3, 4}/2;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = Fourier[a]\)], "Input"],

Cell[BoxData[
    \({\(\(2.5`\)\(\[InvisibleSpace]\)\) + 0.`\ \[ImaginaryI], \(-0.5`\) - 
        0.5`\ \[ImaginaryI], \(-0.5`\) + 0.`\ \[ImaginaryI], \(-0.5`\) + 
        0.5`\ \[ImaginaryI]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseFourier[2  b]\)], "Input"],

Cell[BoxData[
    \({1.`, 2.`, 3.`, 4.`}\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\:4f8b2\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = Table[N[f[\(4  \[Pi]\ m\)\/8]], {m, \(-4\), 3}]\)], "Input"],

Cell[BoxData[
    \({6.28318530717958623`, 4.71238898038468967`, 3.14159265358979311`, 
      1.57079632679489655`, 0, 1.57079632679489655`, 3.14159265358979311`, 
      4.71238898038468967`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = Fourier[a]/\@8\)], "Input"],

Cell[BoxData[
    \({\(3.14159265358979267`\[InvisibleSpace]\) + 0.`\ I, 
      \(1.34075853066724381`\[InvisibleSpace]\) - 
        5.55111512312578092`*^-17\ I, \(0.`\[InvisibleSpace]\) + 0.`\ I, 
      \(0.230037796127652471`\[InvisibleSpace]\) + 
        1.66533453693773436`*^-16\ I, \(0.`\[InvisibleSpace]\) + 0.`\ I, 
      \(0.230037796127652471`\[InvisibleSpace]\) + 
        5.55111512312578092`*^-17\ I, \(0.`\[InvisibleSpace]\) + 0.`\ I, 
      \(1.34075853066724381`\[InvisibleSpace]\) - 
        1.66533453693773436`*^-16\ I}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InverseFourier[\(\@8\) b]\)], "Input"],

Cell[BoxData[
    \({\(6.28318530717958534`\[InvisibleSpace]\) + 0.`\ I, 
      \(4.71238898038468967`\[InvisibleSpace]\) - 
        1.57009245868377504`*^-16\ I, 
      \(3.14159265358979267`\[InvisibleSpace]\) + 0.`\ I, 
      \(1.57079632679489673`\[InvisibleSpace]\) - 
        1.57009245868377504`*^-16\ I, 6.28036983473510002`*^-16 + 0.`\ I, 
      \(1.57079632679489673`\[InvisibleSpace]\) + 
        1.57009245868377504`*^-16\ I, 
      \(3.14159265358979267`\[InvisibleSpace]\) + 0.`\ I, 
      \(4.71238898038468967`\[InvisibleSpace]\) + 
        1.57009245868377504`*^-16\ I}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\:4f8b3\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell["\<\
sample={
{0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.352941, 0.192157, 0.223529, 0.388235, 0.45098, 0.352941, 0.352941, \
0.482353, 
0.741176, 0.968627, 1, 0.741176, 0.45098, 0.419608, 0.45098, 0.45098, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.419608, 0.482353, 0.517647, 0.54902, 0.54902, 0.45098, 0.321569, 
0.419608, 0.482353, 0.45098, 0.419608, 0.45098, 0.517647, 0.517647, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, \

0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.45098, 0.419608, 0.321569, 0.290196, 0.290196, \
0.388235, 
0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.45098, 0.321569, 0.352941, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.678431, \

0.678431, 0.741176, 0.776471, 0.807843, 0.839216, 0.905882, 0.937255, \
0.968627, 
1, 1, 1, 0.968627, 0.905882, 0.839216, 0.776471, 0.709804, 0.709804},
{0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.419608, 0.290196, 0.290196, 0.388235, 0.45098, 0.419608, 0.352941, \
0.388235, 
0.611765, 0.776471, 0.807843, 0.678431, 0.482353, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.45098, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.388235, 
0.290196, 0.388235, 0.482353, 0.482353, 0.45098, 0.482353, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.388235, 0.388235, 0.419608, 0.352941, 0.258824, 0.258824, \
0.290196, 
0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.352941, 0.352941, 0.388235, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.709804, 0.776471, 0.807843, 0.839216, 0.870588, \
0.937255, 
0.968627, 1, 1, 1, 1, 0.937255, 0.870588, 0.807843, 0.741176, 0.709804},
{0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.388235, 0.352941, 0.419608, 0.54902, 0.611765, 0.54902, 0.45098, 
0.482353, 0.517647, 0.54902, 0.517647, 0.482353, 0.419608, 0.419608, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.419608, \

0.290196, 0.388235, 0.517647, 0.580392, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.388235, 0.388235, 0.419608, 0.352941, 0.223529, 0.192157, \
0.258824, 
0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.54902, 0.517647, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.647059, \

0.647059, 0.647059, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.905882, 
0.968627, 0.968627, 1, 1, 1, 0.968627, 0.905882, 0.839216, 0.776471, \
0.741176},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.388235, 0.419608, 0.611765, 0.839216, 0.839216, 0.709804, \

0.482353, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.419608, 0.419608, 0.482353, \
0.482353, 
0.352941, 0.482353, 0.647059, 0.709804, 0.580392, 0.45098, 0.45098, 0.482353, \

0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.388235, 0.419608, 0.419608, 0.352941, 0.258824, 0.192157, \
0.192157, 
0.321569, 0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 
0.54902, 0.54902, 0.419608, 0.388235, 0.388235, 0.352941, 0.388235, 0.352941, \

0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.419608, 
0.419608, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \

0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.839216, \
0.870588, 
0.905882, 0.937255, 0.968627, 1, 1, 0.968627, 0.937255, 0.905882, 0.807843, 
0.776471},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.388235, 0.388235, 0.580392, 0.839216, 0.905882, \
0.776471, 
0.482353, 0.419608, 0.388235, 0.419608, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.45098, 0.482353, \

0.482353, 0.482353, 0.45098, 0.482353, 0.45098, 0.45098, 0.54902, 0.54902, 
0.45098, 0.611765, 0.839216, 0.870588, 0.647059, 0.45098, 0.419608, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.419608, 0.419608, 0.352941, 0.290196, \
0.223529, 
0.258824, 0.321569, 0.388235, 0.419608, 0.419608, 0.419608, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.54902, 0.580392, 0.482353, 0.388235, 0.352941, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, \

0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.807843, \
0.839216, 
0.870588, 0.905882, 0.968627, 0.968627, 1, 1, 0.968627, 0.937255, 0.839216, 
0.807843},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.352941, 0.321569, 0.45098, 0.611765, 0.647059, \
0.611765, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.580392, \
0.580392, 
0.482353, 0.709804, 0.937255, 0.937255, 0.678431, 0.482353, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.45098, 0.419608, \
0.352941, 
0.258824, 0.321569, 0.388235, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.54902, 0.611765, 0.517647, 0.419608, 0.352941, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, \

0.647059, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 0.968627, 0.905882, 
0.870588},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.517647, 0.517647, 
0.45098, 0.611765, 0.776471, 0.776471, 0.611765, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.54902, 0.647059, 0.580392, 0.45098, 0.352941, 0.352941, 0.388235, 0.352941, \

0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, \

0.647059, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, \
0.807843, 
0.839216, 0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 0.968627, 
0.937255, 0.870588},
{0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.352941, 0.352941, 0.419608, 0.419608, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.517647, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.482353, 0.45098, 0.45098, 0.419608, 0.419608, 0.482353, 0.45098, 
0.388235, 0.482353, 0.611765, 0.580392, 0.482353, 0.45098, 0.482353, \
0.482353, 
0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.352941, 0.321569, 0.388235, \
0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.388235, 
0.54902, 0.678431, 0.611765, 0.45098, 0.352941, 0.352941, 0.388235, 0.388235, \

0.388235, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, \

0.647059, 0.611765, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, \
0.807843, 
0.807843, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, \
0.968627, 
0.937255, 0.905882},
{0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.352941, 0.352941, 0.388235, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, \

0.388235, 0.388235, 0.45098, 0.482353, 0.45098, 0.482353, 0.482353, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.482353, 0.482353, 0.45098, \

0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 0.419608, 0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.352941, 0.223529, 0.223529, 0.388235, \
0.45098, 
0.419608, 0.321569, 0.290196, 0.388235, 0.45098, 0.45098, 0.388235, 0.388235, \

0.54902, 0.647059, 0.678431, 0.517647, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.870588, 0.905882, 0.937255, 0.968627, 0.968627, \
0.968627, 
0.937255, 0.968627},
{0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.352941, 0.352941, 0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 
0.482353, 0.45098, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.419608, 0.388235, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 0.45098, 
0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.45098, 0.517647, 0.482353, \

0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.321569, 0.223529, 0.258824, 0.388235, \
0.482353, 
0.388235, 0.258824, 0.223529, 0.321569, 0.45098, 0.482353, 0.419608, \
0.352941, 
0.517647, 0.647059, 0.678431, 0.54902, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, \
0.776471, 
0.776471, 0.807843, 0.839216, 0.870588, 0.905882, 0.937255, 0.968627, \
0.937255, 
0.937255, 0.968627},
{0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.352941, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.482353, 0.517647, 
0.482353, 0.45098, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.388235, 0.419608, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.419608, 0.45098, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.321569, 0.223529, 0.290196, 0.419608, \
0.482353, 
0.388235, 0.258824, 0.192157, 0.290196, 0.419608, 0.482353, 0.419608, \
0.352941, 
0.482353, 0.611765, 0.709804, 0.611765, 0.419608, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.388235, 0.419608, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.54902, 0.517647, 0.482353, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.807843, 0.807843, 0.839216, 0.905882, 0.937255, \
0.937255, 
0.937255, 0.968627},
{0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, \

0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.517647, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.517647, \

0.45098, 0.419608, 0.419608, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.580392, 0.647059, 0.580392, 0.482353, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.352941, 0.290196, 0.352941, 0.419608, \
0.45098, 
0.45098, 0.321569, 0.223529, 0.258824, 0.388235, 0.45098, 0.419608, 0.388235, \

0.419608, 0.54902, 0.709804, 0.647059, 0.482353, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.388235, 0.419608, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.870588, 0.905882, \
0.905882, 
0.937255, 0.968627},
{0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.388235, \

0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \

0.45098, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.45098, 0.517647, 
0.517647, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 
0.45098, 0.45098, 0.517647, 0.709804, 0.839216, 0.741176, 0.54902, 0.482353, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.482353, 
0.482353, 0.45098, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.321569, 0.290196, 0.352941, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.517647, 0.678431, 0.678431, 0.517647, 0.388235, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.388235, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.839216, 0.870588, \
0.905882, 
0.937255, 0.968627},
{0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.388235, 0.352941, \

0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \

0.45098, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.45098, 0.517647, 
0.54902, 0.482353, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.517647, 0.45098, \

0.482353, 0.45098, 0.482353, 0.709804, 0.937255, 0.870588, 0.647059, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, \

0.482353, 0.419608, 0.352941, 0.321569, 0.352941, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.482353, 0.54902, 0.611765, 0.517647, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.352941, 0.321569, 0.388235, 0.388235, \
0.352941, 
0.352941, 0.45098, 0.611765, 0.678431, 0.580392, 0.419608, 0.352941, \
0.352941, 
0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.54902, 0.580392, 0.54902, 0.517647, \

0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.776471, 0.807843, 0.839216, 0.870588, \
0.870588, 
0.937255, 0.968627},
{0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.388235, 0.352941, \

0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.45098, 0.54902, 
0.54902, 0.482353, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.647059, 0.937255, 0.937255, 0.709804, \
0.517647, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.388235, 0.419608, \
0.482353, 
0.482353, 0.388235, 0.321569, 0.321569, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.482353, 0.647059, 0.776471, 0.678431, 0.482353, \
0.388235, 
0.419608, 0.45098, 0.419608, 0.352941, 0.352941, 0.388235, 0.419608, \
0.388235, 
0.352941, 0.388235, 0.54902, 0.678431, 0.611765, 0.45098, 0.352941, 0.352941, \

0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.54902, 0.580392, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.839216, \
0.870588, 
0.905882, 0.937255},
{0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.45098, 0.54902, 
0.580392, 0.482353, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, \

0.482353, 0.45098, 0.482353, 0.517647, 0.482353, 0.45098, 0.482353, 0.517647, \

0.45098, 0.517647, 0.482353, 0.580392, 0.905882, 1, 0.776471, 0.580392, 
0.419608, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 
0.321569, 0.290196, 0.321569, 0.352941, 0.388235, 0.419608, 0.45098, \
0.517647, 
0.482353, 0.388235, 0.321569, 0.321569, 0.419608, 0.45098, 0.45098, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.482353, 0.709804, 0.870588, 0.776471, 0.517647, \
0.388235, 
0.388235, 0.419608, 0.352941, 0.321569, 0.352941, 0.45098, 0.517647, \
0.482353, 
0.352941, 0.388235, 0.517647, 0.678431, 0.647059, 0.482353, 0.388235, \
0.352941, 
0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.517647, 0.54902, 0.580392, 0.580392, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.776471, 0.741176, 0.776471, 0.807843, 0.839216, \
0.870588, 
0.905882, 0.937255},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.388235, 0.388235, 0.419608, \

0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.517647, 
0.580392, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.45098, 0.611765, 0.839216, 1, 0.870588, 0.580392, \
0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, 0.482353, \
0.321569, 
0.258824, 0.258824, 0.290196, 0.419608, 0.580392, 0.647059, 0.647059, \
0.54902, 
0.388235, 0.290196, 0.352941, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.580392, 0.741176, 0.741176, 0.580392, 0.419608, 0.45098, \

0.388235, 0.352941, 0.352941, 0.352941, 0.482353, 0.678431, 0.741176, \
0.517647, 
0.352941, 0.419608, 0.647059, 0.678431, 0.517647, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.45098, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.54902, 0.611765, 0.580392, 0.517647, 0.517647, \

0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.776471, 0.807843, 0.839216, 0.839216, \
0.870588, 
0.905882},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.517647, 
0.580392, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.45098, 0.482353, 0.580392, 0.807843, 1, 0.905882, 0.611765, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.517647, 0.580392, 0.611765, 
0.580392, 0.419608, 0.388235, 0.517647, 0.709804, 0.839216, 0.807843, \
0.741176, 
0.54902, 0.45098, 0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.482353, 0.580392, 0.647059, 0.54902, 0.45098, \

0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.54902, 0.776471, \
0.905882, 
0.647059, 0.419608, 0.419608, 0.611765, 0.678431, 0.54902, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.54902, 0.611765, 0.580392, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.776471, 0.807843, 0.839216, \
0.839216, 
0.870588, 0.905882},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.517647, 
0.580392, 0.482353, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.482353, 0.419608, 0.45098, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.54902, 0.776471, 1, 0.905882, 0.647059, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.419608, 0.45098, 0.611765, 0.776471, 0.839216, 
0.741176, 0.517647, 0.419608, 0.580392, 0.776471, 0.839216, 0.776471, \
0.678431, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.388235, 0.388235, 0.45098, 0.517647, 0.517647, 0.45098, 
0.388235, 0.352941, 0.388235, 0.419608, 0.419608, 0.54902, 0.807843, \
0.968627, 
0.807843, 0.482353, 0.388235, 0.580392, 0.709804, 0.611765, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.517647, 0.54902, 0.611765, 0.580392, 0.517647, \

0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.839216, \
0.839216, 
0.870588, 0.870588},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \
0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.517647, 
0.54902, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.419608, \

0.482353, 0.419608, 0.419608, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.741176, 0.937255, 0.905882, \
0.678431, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.419608, 0.45098, 0.709804, 0.937255, 0.937255, 
0.741176, 0.54902, 0.45098, 0.517647, 0.611765, 0.611765, 0.54902, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.419608, 0.45098, 0.45098, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.482353, 0.741176, 0.968627, \

0.870588, 0.54902, 0.388235, 0.580392, 0.741176, 0.647059, 0.482353, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.517647, 0.580392, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.839216, \
0.839216, 
0.870588, 0.870588},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \
0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.517647, 
0.54902, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.482353, 0.517647, 0.482353, 0.45098, 0.419608, \

0.482353, 0.419608, 0.419608, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.482353, 0.517647, 0.678431, 0.905882, 0.870588, \
0.678431, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.419608, 0.482353, 0.709804, 0.839216, \
0.741176, 
0.54902, 0.45098, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.45098, 0.482353, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, \

0.419608, 0.45098, 0.482353, 0.45098, 0.388235, 0.419608, 0.647059, 0.937255, \

0.870588, 0.611765, 0.482353, 0.611765, 0.741176, 0.678431, 0.517647, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.517647, 0.580392, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.870588, 0.870588},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, \
0.419608, 
0.482353, 0.388235, 0.388235, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.517647, 0.647059, 0.839216, 0.807843, \
0.647059, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.54902, 0.54902, 0.388235, 
0.352941, 0.290196, 0.223529, 0.160784, 0.192157, 0.352941, 0.482353, \
0.517647, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 
0.419608, 0.482353, 0.482353, 0.45098, 0.388235, 0.388235, 0.54902, 0.741176, \

0.776471, 0.647059, 0.54902, 0.611765, 0.741176, 0.709804, 0.54902, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.517647, 0.580392, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.776471, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.419608, 0.45098, 0.482353, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.482353, 
0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.419608, \
0.419608, 
0.482353, 0.352941, 0.352941, 0.45098, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.611765, 0.776471, 0.741176, \
0.611765, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.419608, 0.321569, 0.258824, 
0.290196, 0.258824, 0.223529, 0.223529, 0.258824, 0.419608, 0.54902, \
0.611765, 
0.54902, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.419608, 0.482353, 0.45098, 0.419608, 0.388235, 0.388235, 0.419608, \
0.517647, 
0.611765, 0.611765, 0.54902, 0.517647, 0.647059, 0.709804, 0.580392, \
0.482353, 
0.419608, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.517647, 0.580392, 0.611765, 0.580392, 0.517647, \

0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.482353, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.54902, 0.482353, 0.45098, 0.419608, 0.388235, \

0.482353, 0.352941, 0.352941, 0.45098, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.517647, 0.611765, 0.709804, 0.678431, \
0.580392, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.388235, 0.45098, 0.45098, 0.352941, 0.290196, 0.321569, 
0.352941, 0.419608, 0.517647, 0.580392, 0.580392, 0.647059, 0.678431, \
0.678431, 
0.611765, 0.54902, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.482353, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.419608, 0.388235, 0.45098, 0.419608, 0.352941, 0.388235, 
0.45098, 0.54902, 0.482353, 0.419608, 0.54902, 0.678431, 0.611765, 0.517647, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.54902, 0.611765, 0.580392, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.580392, 0.482353, 0.388235, 0.223529, 0.192157, \
0.290196, 
0.45098, 0.352941, 0.352941, 0.45098, 0.580392, 0.580392, 0.517647, 0.54902, 
0.517647, 0.54902, 0.517647, 0.517647, 0.611765, 0.678431, 0.611765, 0.54902, \

0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.388235, 0.352941, \

0.352941, 0.388235, 0.54902, 0.741176, 0.709804, 0.54902, 0.388235, 0.321569, \

0.482353, 0.611765, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.482353, 0.388235, 0.388235, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.352941, 0.352941, \
0.352941, 
0.45098, 0.517647, 0.517647, 0.352941, 0.45098, 0.647059, 0.709804, 0.54902, 
0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.482353, \
0.517647, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.517647, 0.482353, 0.482353, 0.580392, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588},
{0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, \

0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.517647, 0.517647, 0.321569, 0.160784, 0.0313725, 0.129412, \
0.321569, 
0.352941, 0.290196, 0.258824, 0.352941, 0.482353, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.611765, 0.647059, 0.580392, 0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.45098, 0.419608, 0.388235, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.54902, 0.839216, 0.937255, 0.776471, 0.517647, 0.352941, \
0.321569, 
0.352941, 0.517647, 0.678431, 0.741176, 0.776471, 0.741176, 0.647059, \
0.517647, 
0.352941, 0.321569, 0.352941, 0.388235, 0.419608, 0.419608, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.482353, 0.482353, 0.45098, 0.321569, 0.388235, 0.580392, 0.709804, \
0.611765, 
0.45098, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.580392, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588},
{0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.482353, 0.388235, 0.258824, 0.0941176, 0.0313725, 0, 0.129412, 0.290196, 
0.223529, 0.223529, 0.223529, 0.258824, 0.290196, 0.290196, 0.321569, \
0.352941, 
0.419608, 0.482353, 0.517647, 0.517647, 0.580392, 0.611765, 0.54902, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.419608, 0.388235, 0.352941, 0.290196, 0.258824, 0.223529, \
0.258824, 
0.419608, 0.647059, 0.839216, 0.776471, 0.54902, 0.352941, 0.258824, \
0.258824, 
0.258824, 0.321569, 0.419608, 0.54902, 0.741176, 0.807843, 0.678431, 0.45098, \

0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.352941, 0.419608, 0.517647, 0.54902, 0.517647, 
0.482353, 0.419608, 0.419608, 0.352941, 0.388235, 0.517647, 0.678431, \
0.647059, 
0.482353, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.45098, 0.482353, 0.54902, 0.580392, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.776471, 0.807843, 0.807843, 0.839216, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.45098, 0.388235, 0.321569, 
0.258824, 0.160784, 0.0627451, 0, 0, 0, 0.192157, 0.258824, 0.0627451, \
0.0941176, 
0.129412, 0.129412, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 
0.258824, 0.321569, 0.388235, 0.517647, 0.54902, 0.54902, 0.580392, 0.517647, \

0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.419608, \
0.352941, 
0.321569, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.321569, \
0.388235, 
0.482353, 0.517647, 0.419608, 0.321569, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.258824, 0.419608, 0.709804, 0.870588, 0.741176, 0.517647, \
0.419608, 
0.388235, 0.419608, 0.388235, 0.352941, 0.352941, 0.388235, 0.388235, \
0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.388235, 0.388235, 0.580392, 0.776471, 0.741176, 0.580392, 0.45098, \

0.388235, 0.45098, 0.482353, 0.45098, 0.517647, 0.647059, 0.678431, 0.54902, 
0.45098, 0.388235, 0.419608, 0.419608, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.482353, 0.54902, 0.580392, 0.54902, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.611765, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.776471, 0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, \
0.905882, 
0.870588},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.54902, 0.517647, 0.482353, 0.419608, 0.352941, 0.223529, 0.160784, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0.192157, 0.223529, 0.0627451, 
0.0627451, 0.129412, 0.0941176, 0, 0, 0, 0.0313725, 0, 0.0627451, 0.0941176, 
0.192157, 0.321569, 0.419608, 0.419608, 0.482353, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.45098, \

0.45098, 0.419608, 0.388235, 0.321569, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.352941, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.258824, 0.258824, 0.258824, 0.290196, 0.321569, 0.388235, \
0.419608, 
0.54902, 0.709804, 0.807843, 0.776471, 0.647059, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.388235, 0.352941, 
0.482353, 0.807843, 1, 0.807843, 0.517647, 0.388235, 0.352941, 0.45098, 
0.54902, 0.517647, 0.517647, 0.611765, 0.647059, 0.580392, 0.45098, 0.388235, \

0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.45098, 
0.482353, 0.54902, 0.580392, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.678431, 0.709804, 0.741176, 0.776471, 0.807843, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.54902, \
0.517647, 
0.54902, 0.45098, 0.321569, 0.223529, 0.129412, 0.0313725, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0627451, 0.290196, 0.290196, 0.0627451, 0.0627451, 0.129412, 
0.160784, 0.0313725, 0, 0, 0, 0, 0, 0, 0.0627451, 0.160784, 0.192157, \
0.192157, 
0.223529, 0.419608, 0.482353, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 
0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \

0.45098, 0.419608, 0.388235, 0.352941, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.258824, 0.290196, \
0.388235, 
0.482353, 0.580392, 0.580392, 0.611765, 0.647059, 0.741176, 0.776471, \
0.741176, 
0.678431, 0.580392, 0.54902, 0.517647, 0.54902, 0.517647, 0.482353, 0.45098, 
0.45098, 0.388235, 0.388235, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.388235, 0.388235, 0.611765, 0.905882, 1, 0.776471, \
0.419608, 
0.352941, 0.352941, 0.419608, 0.517647, 0.482353, 0.482353, 0.517647, \
0.611765, 
0.611765, 0.45098, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.45098, 0.482353, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.709804, \
0.741176, 
0.776471, 0.807843, 0.870588, 0.870588, 0.905882, 0.937255, 0.937255, \
0.905882, 
0.937255, 0.905882},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.388235, 0.258824, 0.129412, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.192157, 0.517647, 0.54902, 0.129412, 0.0313725, 0.0941176, 0.129412, \
0.0627451, 
0, 0, 0, 0, 0, 0, 0.0313725, 0.0627451, 0.0313725, 0, 0.0627451, 0.160784, 
0.223529, 0.352941, 0.45098, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.419608, 0.388235, 0.352941, 0.352941, \
0.321569, 
0.290196, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.388235, 0.388235, 0.352941, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.388235, 0.517647, 0.678431, 0.776471, \
0.741176, 
0.678431, 0.611765, 0.647059, 0.709804, 0.741176, 0.709804, 0.709804, \
0.647059, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.517647, 0.419608, \

0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \

0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 
0.419608, 0.482353, 0.647059, 0.807843, 0.807843, 0.611765, 0.388235, \
0.352941, 
0.388235, 0.388235, 0.45098, 0.45098, 0.45098, 0.45098, 0.580392, 0.611765, 
0.482353, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.45098, 0.482353, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.741176, \
0.776471, 
0.807843, 0.870588, 0.905882, 0.937255, 0.937255, 0.937255, 0.937255, \
0.937255, 
0.905882},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, \

0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.419608, \
0.352941, 
0.192157, 0.0941176, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.192157, 
0.678431, 0.839216, 0.517647, 0.321569, 0.192157, 0.160784, 0.0313725, 0, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0.0627451, 
0.129412, 0.223529, 0.321569, 0.45098, 0.54902, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.45098, 0.388235, 0.352941, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, \
0.388235, 
0.419608, 0.352941, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.419608, 0.580392, 0.741176, 0.807843, 0.807843, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.678431, 0.678431, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.580392, 0.580392, 0.611765, 0.580392, 0.517647, 0.517647, \
0.482353, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.517647, 0.580392, 0.611765, 0.54902, 0.45098, 0.352941, 0.352941, 0.45098, 
0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.54902, 0.611765, 0.482353, \

0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.45098, \

0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.482353, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 
0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.741176, 0.776471, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 0.937255, 0.937255, \
0.905882},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, \

0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.419608, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.482353, 
0.45098, 0.482353, 0.54902, 0.54902, 0.482353, 0.388235, 0.223529, 0.129412, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.129412, 0.45098, 0.776471, 
0.741176, 0.517647, 0.258824, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, \
0.0313725, 
0.0941176, 0.192157, 0.352941, 0.45098, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.45098, 0.419608, 0.388235, 0.321569, \
0.290196, 
0.258824, 0.290196, 0.290196, 0.321569, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.352941, 0.419608, \
0.45098, 
0.388235, 0.321569, 0.290196, 0.321569, 0.321569, 0.388235, 0.482353, \
0.611765, 
0.776471, 0.807843, 0.776471, 0.678431, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.482353, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.388235, 0.352941, 0.352941, 0.352941, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.45098, 0.45098, 0.388235, 0.517647, 0.580392, 0.517647, 0.419608, 0.388235, \

0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.647059, 0.647059, 
0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.839216, 0.870588, \
0.905882, 
0.937255, 0.968627, 0.968627, 0.968627, 0.937255, 0.937255},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.54902, 0.517647, 0.419608, 0.290196, 0.160784, 0.0627451, \
0.0313725, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.129412, 0.321569, 0.517647, 
0.388235, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0627451, 
0.129412, 0.192157, 0.321569, 0.388235, 0.45098, 0.517647, 0.580392, \
0.580392, 
0.54902, 0.517647, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.388235, 0.352941, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.321569, 0.290196, 0.321569, 0.321569, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.321569, 0.388235, 0.45098, 0.419608, \
0.352941, 
0.352941, 0.388235, 0.419608, 0.54902, 0.647059, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.517647, 0.482353, 0.45098, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.352941, 0.352941, 
0.352941, 0.352941, 0.352941, 0.419608, 0.45098, 0.388235, 0.419608, 0.45098, \

0.419608, 0.517647, 0.54902, 0.517647, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.517647, 0.517647, \

0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.611765, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.709804, 0.741176, 0.776471, 0.807843, 0.870588, 0.905882, 0.937255, \
0.937255, 
0.968627, 0.968627, 0.968627, 0.937255},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.482353, 0.482353, 0.419608, 0.388235, 0.419608, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.45098, 0.352941, 0.223529, 0.0941176, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.129412, 0.160784, 0.223529, \
0.192157, 
0.129412, 0.0627451, 0.0627451, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0627451, 0.129412, 0.223529, \

0.352941, 0.482353, 0.54902, 0.580392, 0.580392, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.388235, 0.352941, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, \
0.352941, 
0.419608, 0.419608, 0.388235, 0.419608, 0.45098, 0.580392, 0.647059, \
0.678431, 
0.678431, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.388235, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.388235, \
0.419608, 
0.388235, 0.45098, 0.45098, 0.419608, 0.482353, 0.54902, 0.517647, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 
0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.807843, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 0.968627, 0.937255},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.45098, 0.419608, 0.388235, 0.419608, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, \

0.419608, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0627451, 0.192157, 0.192157, 0.129412, \
0.0313725, 
0, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0, 0, 0.0313725, 0.129412, 0.223529, 0.388235, 0.482353, 
0.580392, 0.611765, 0.580392, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.45098, 0.388235, 0.352941, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.321569, 0.352941, 0.388235, 0.388235, 0.419608, \
0.482353, 
0.517647, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.580392, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.45098, \

0.419608, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, \

0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 
0.388235, 0.419608, 0.352941, 0.352941, 0.388235, 0.482353, 0.45098, \
0.419608, 
0.45098, 0.517647, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.776471, 0.839216, 0.870588, 0.905882, 0.937255, \
0.937255, 
0.937255, 0.937255, 0.905882},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.54902, 0.54902, 0.482353, 0.388235, \

0.258824, 0.129412, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0.0941176, 0.192157, 0.223529, 0.129412, 0.0313725, 
0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 
0, 0, 0, 0.0313725, 0.129412, 0.290196, 0.419608, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.482353, 0.45098, 0.388235, 0.352941, \
0.290196, 
0.290196, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.419608, 0.45098, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.419608, 0.388235, 0.419608, \

0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.45098, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.419608, 
0.388235, 0.352941, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.419608, \

0.388235, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.678431, 0.709804, 0.709804, 0.741176, 0.776471, \
0.807843, 
0.839216, 0.870588, 0.905882, 0.937255, 0.937255, 0.905882, 0.905882},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.45098, 0.321569, 0.192157, 
0.0941176, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0.0313725, 0.0941176, 0.192157, 0.223529, 0.160784, 0.0627451, \

0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0, 0, 0, 0.0941176, 0.192157, 0.321569, 0.45098, \
0.580392, 
0.611765, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.45098, 0.388235, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.54902, 0.517647, 0.419608, 0.388235, \
0.352941, 
0.419608, 0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.388235, 
0.352941, 0.352941, 0.352941, 0.419608, 0.45098, 0.517647, 0.678431, \
0.647059, 
0.517647, 0.388235, 0.419608, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.741176, \
0.807843, 
0.807843, 0.839216, 0.870588, 0.905882, 0.905882, 0.870588, 0.870588},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.482353, 0.419608, 0.290196, 0.129412, 0.0313725, \

0, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0, 0, 0, 0.0313725, 0, 0.0941176, 0.192157, 0.223529, 0.160784, 
0.0627451, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 
0, 0, 0, 0, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0, 0.0627451, 0.129412, 
0.258824, 0.388235, 0.517647, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.419608, 0.352941, 0.321569, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.419608, 0.45098, 0.482353, 0.517647, 0.517647, 0.517647, \
0.580392, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.580392, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.352941, 0.388235, 0.419608, 0.45098, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.517647, 
0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.45098, \
0.580392, 
0.807843, 0.870588, 0.776471, 0.54902, 0.419608, 0.482353, 0.45098, 0.482353, \

0.54902, 0.517647, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.741176, 0.776471, 0.807843, 0.807843, 0.839216, 0.870588, 0.870588, \
0.839216, 
0.870588},
{0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.419608, 0.388235, 0.45098, 0.517647, 0.517647, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.580392, 0.54902, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 
0.0313725, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0941176, 0.223529, 0.290196, 0.192157, \
0.0627451, 
0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0.0627451, 
0.160784, 0.290196, 0.45098, 0.580392, 0.611765, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.54902, 
0.517647, 0.482353, 0.419608, 0.352941, 0.321569, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.580392, 0.580392, \
0.482353, 
0.388235, 0.352941, 0.321569, 0.352941, 0.388235, 0.45098, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.419608, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.419608, 0.580392, \
0.776471, 
0.937255, 0.968627, 0.776471, 0.482353, 0.482353, 0.45098, 0.517647, \
0.580392, 
0.54902, 0.482353, 0.482353, 0.482353, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.741176, 0.776471, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216},
{0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.482353, 0.517647, 0.54902, 0.54902, 
0.54902, 0.45098, 0.352941, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0.0627451, 0.223529, 0.321569, 0.223529, 0.0627451, 0.0313725, 0, 0, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0.0627451, 0.192157, 0.388235, \
0.517647, 
0.611765, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.517647, 0.45098, 0.388235, 0.352941, 0.321569, 0.290196, 
0.290196, 0.321569, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.388235, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.54902, 0.482353, 0.419608, 0.352941, 0.352941, \
0.321569, 
0.352941, 0.419608, 0.45098, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.388235, 0.352941, 0.352941, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.580392, 0.807843, 0.937255, 0.870588, 0.647059, \
0.517647, 
0.482353, 0.517647, 0.54902, 0.54902, 0.482353, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.709804, 0.741176, 0.741176, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.776471},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.419608, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 
0.388235, 0.290196, 0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0.0941176, 0.258824, 0.321569, 0.223529, 0.0941176, 0.0313725, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0.0313725, 0.0627451, 0.160784, 0.321569, 0.45098, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.482353, \

0.45098, 0.388235, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.517647, 0.482353, 0.419608, 0.388235, 0.352941, 0.321569, \
0.321569, 
0.388235, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.45098, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.54902, 0.678431, 0.741176, 0.678431, 0.54902, 0.517647, 0.482353, \

0.517647, 0.517647, 0.482353, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471},
{0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.45098, 0.352941, 
0.192157, 0.129412, 0.0313725, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0941176, 0.258824, \

0.352941, 0.258824, 0.0941176, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0.0941176, 0.192157, 0.419608, 
0.482353, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.482353, 0.388235, \

0.352941, 0.321569, 0.290196, 0.258824, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.45098, 0.388235, 0.352941, 0.290196, \

0.321569, 0.388235, 0.45098, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.45098, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.388235, 0.45098, 0.54902, 0.580392, 0.54902, 0.482353, 0.45098, 
0.482353, 0.482353, 0.482353, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, \

0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.741176},
{0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.54902, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 
0.0627451, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0941176, 0.258824, \

0.388235, 0.290196, 0.129412, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.129412, 0.290196, 0.482353, 
0.580392, 0.611765, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.517647, 0.45098, 0.388235, 0.290196, 0.290196, 0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.482353, 0.45098, 0.419608, 0.352941, 0.290196, 0.290196, \

0.352941, 0.45098, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.388235, 
0.352941, 0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176},
{0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.580392, 0.580392, 0.45098, 0.321569, 0.192157, \
0.0941176, 
0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0627451, 0.258824, 0.388235, 
0.321569, 0.129412, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0.129412, 
0.290196, 0.45098, 0.54902, 0.611765, 0.580392, 0.54902, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.517647, 0.45098, 0.352941, 0.321569, 0.290196, 0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, \

0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.54902, 0.517647, 0.517647, 0.482353, 0.419608, 0.352941, \

0.258824, 0.258824, 0.352941, 0.419608, 0.482353, 0.54902, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, 0.388235, \
0.45098, 
0.45098, 0.388235, 0.388235, 0.482353, 0.54902, 0.54902, 0.482353, 0.45098, 
0.45098, 0.482353, 0.482353, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804},
{0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \

0.54902, 0.54902, 0.580392, 0.482353, 0.290196, 0.160784, 0.0627451, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0.0627451, 0.223529, 0.388235, 
0.321569, 0.160784, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0.0313725, \

0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0, 0.0627451, 0.223529, 0.419608, 
0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.482353, 0.419608, 
0.352941, 0.290196, 0.258824, 0.321569, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.54902, 0.517647, 0.482353, 0.482353, 0.419608, 0.352941, 0.290196, \
0.258824, 
0.321569, 0.419608, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.482353, 0.419608, 0.352941, \
0.352941, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.388235, \
0.482353, 
0.580392, 0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.580392, 0.54902, 0.45098, 0.290196, 0.129412, 0.0313725, 0.0313725, 0, 
0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.223529, 0.388235, 0.321569, 
0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0.0627451, 
0.192157, 0.388235, 0.54902, 0.647059, 0.611765, 0.580392, 0.580392, 0.54902, \

0.54902, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 0.419608, 
0.352941, 0.321569, 0.290196, 0.290196, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.54902, 0.517647, 0.517647, 0.482353, 0.419608, \
0.352941, 
0.290196, 0.258824, 0.352941, 0.419608, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.352941, 
0.352941, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.388235, 0.45098, \

0.611765, 0.741176, 0.709804, 0.580392, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804},
{0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.45098, 0.290196, 0.160784, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.192157, 0.352941, 0.352941, 
0.192157, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.160784, 0.388235, 0.54902, 0.647059, 0.611765, 0.580392, \
0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.517647, 0.45098, 0.352941, 
0.290196, 0.290196, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.482353, 0.419608, \
0.388235, 
0.321569, 0.290196, 0.290196, 0.321569, 0.482353, 0.517647, 0.54902, 0.54902, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.352941, \

0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.517647, 
0.709804, 0.839216, 0.741176, 0.580392, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804},
{0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.517647, \

0.482353, 0.54902, 0.54902, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.580392, 0.580392, 0.54902, 
0.45098, 0.321569, 0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.192157, 0.352941, 0.321569, 
0.192157, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0, 0.0313725, 0.160784, \
0.321569, 
0.54902, 0.611765, 0.611765, 0.580392, 0.54902, 0.580392, 0.580392, 0.54902, 
0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 
0.517647, 0.419608, 0.321569, 0.290196, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.388235, 0.352941, 0.352941, 0.321569, 0.258824, \

0.352941, 0.482353, 0.580392, 0.580392, 0.54902, 0.517647, 0.54902, 0.54902, 
0.580392, 0.54902, 0.45098, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.517647, 0.776471, 0.905882, 0.776471, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.709804, 0.678431},
{0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.54902, 0.517647, 0.517647, 0.482353, 0.45098, 0.45098, 0.482353, 0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 
0.290196, 0.160784, 0.0627451, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.160784, 0.321569, 0.321569, 0.192157, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0, \
0.0313725, 
0.0313725, 0, 0, 0.0313725, 0.129412, 0.290196, 0.45098, 0.580392, 0.647059, 
0.611765, 0.54902, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.54902, 0.580392, 0.580392, \

0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.54902, 0.517647, 0.419608, 0.352941, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \

0.611765, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.54902, 0.54902, 0.517647, 0.45098, 
0.419608, 0.388235, 0.352941, 0.290196, 0.258824, 0.352941, 0.45098, 0.54902, \

0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.45098, 0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.482353, 
0.709804, 0.839216, 0.709804, 0.54902, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.678431},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.482353, 0.45098, 0.388235, 0.352941, 0.419608, 0.517647, \

0.580392, 0.611765, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.419608, 0.290196, 
0.129412, 0.0627451, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, \
0.0313725, 
0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.160784, 0.321569, 0.321569, 0.192157, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0.0627451, 0.223529, 0.45098, 0.611765, \
0.647059, 
0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, \

0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.517647, 0.419608, 0.321569, 0.290196, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.54902, 0.517647, 0.45098, \

0.419608, 0.388235, 0.321569, 0.258824, 0.258824, 0.321569, 0.482353, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.482353, 0.388235, 0.352941, 
0.388235, 0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.45098, 0.611765, \

0.678431, 0.611765, 0.54902, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.482353, 0.419608, 0.388235, 0.482353, 0.580392, \

0.647059, 0.647059, 0.611765, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 
0.0627451, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.129412, 0.258824, 0.321569, 0.223529, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0627451, 
0.223529, 0.45098, 0.611765, 0.647059, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.45098, 0.352941, 0.290196, 0.290196, 
0.290196, 0.290196, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.517647, 0.482353, 0.45098, 0.388235, 0.352941, 0.290196, \
0.258824, 
0.258824, 0.352941, 0.482353, 0.54902, 0.580392, 0.54902, 0.580392, 0.580392, \

0.517647, 0.419608, 0.388235, 0.388235, 0.419608, 0.45098, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \

0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.517647, 0.580392, \
0.678431, 
0.709804, 0.807843, 0.741176, 0.611765, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.482353, 0.321569, 0.192157, \
0.0941176, 
0.0313725, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0941176, 0.223529, 0.321569, 0.223529, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, \
0.0627451, 
0.223529, 0.45098, 0.611765, 0.647059, 0.580392, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.517647, 0.419608, 0.352941, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.290196, 0.290196, 0.321569, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.741176, 0.776471, 0.776471, 0.741176, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.388235, 0.321569, 0.321569, 0.290196, 0.258824, \

0.290196, 0.388235, 0.517647, 0.580392, 0.580392, 0.580392, 0.580392, \
0.517647, 
0.419608, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.45098, 0.45098, 0.517647, 0.517647, 0.517647, 0.482353, 
0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.580392, 0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.517647, \
0.482353, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.611765, \
0.709804, 
0.776471, 0.870588, 0.807843, 0.678431, 0.580392, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.54902, 0.482353, 0.482353, 0.517647, 0.54902, \

0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.517647, 0.388235, 0.223529, 0.0941176, \
0.0313725, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.192157, 0.321569, 
0.223529, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, \

0.0313725, 0, 0, 0.0313725, 0, 0.0313725, 0, 0, 0.0627451, 0.258824, \
0.482353, 
0.611765, 0.647059, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.45098, 0.352941, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.290196, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.709804, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.709804, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.45098, \

0.388235, 0.321569, 0.321569, 0.321569, 0.290196, 0.258824, 0.321569, \
0.45098, 
0.54902, 0.580392, 0.580392, 0.580392, 0.517647, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.647059},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.580392, 0.54902, 0.517647, 0.45098, 0.419608, 0.388235, 0.352941, \

0.352941, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.482353, 0.647059, \
0.776471, 
0.807843, 0.807843, 0.709804, 0.611765, 0.580392, 0.54902, 0.54902, 0.611765, \

0.647059, 0.647059, 0.54902, 0.45098, 0.419608, 0.45098, 0.517647, 0.54902, 
0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.517647, 0.419608, 0.258824, 0.129412, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.192157, 0.290196, 0.223529, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0941176, 
0.258824, 0.482353, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.517647, 0.45098, 0.352941, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.709804, 
0.776471, 0.807843, 0.839216, 0.776471, 0.741176, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.517647, 0.419608, 0.352941, 0.352941, 0.352941, 0.321569, 0.290196, \
0.290196, 
0.352941, 0.45098, 0.54902, 0.54902, 0.580392, 0.54902, 0.45098, 0.419608, 
0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.517647, 0.54902, 0.517647, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.482353, 0.45098, 0.419608, 0.45098, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.580392, \
0.54902, 
0.482353, 0.482353, 0.419608, 0.388235, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, \
0.223529, 
0.192157, 0.192157, 0.192157, 0.192157, 0.258824, 0.45098, 0.709804, \
0.870588, 
0.905882, 0.807843, 0.678431, 0.647059, 0.647059, 0.647059, 0.709804, \
0.807843, 
0.776471, 0.678431, 0.517647, 0.388235, 0.388235, 0.517647, 0.580392, \
0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, 0.0313725, \
0.0313725, 
0, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.160784, 0.290196, 0.223529, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, \

0.0313725, 0, 0, 0, 0.0313725, 0.0941176, 0.321569, 0.54902, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.517647, 0.388235, 0.321569, 0.290196, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.741176, 0.807843, 0.839216, 0.839216, 0.776471, \
0.741176, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.54902, 0.517647, 0.45098, 0.45098, 0.419608, 
0.352941, 0.321569, 0.258824, 0.258824, 0.388235, 0.517647, 0.580392, \
0.611765, 
0.54902, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.517647, 0.54902, 0.54902, 
0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, \
0.45098, 
0.45098, 0.482353, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.647059, 0.647059, \
0.647059},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.482353, \
0.45098, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.321569, 0.45098, 0.611765, 0.807843, \
0.905882, 
0.839216, 0.678431, 0.580392, 0.647059, 0.709804, 0.741176, 0.776471, \
0.807843, 
0.741176, 0.647059, 0.517647, 0.482353, 0.517647, 0.580392, 0.580392, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, \

0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.160784, 0.258824, 0.223529, 0.129412, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0, 0, 0.129412, 0.321569, 0.517647, 0.611765, 0.647059, 0.580392, 
0.580392, 0.580392, 0.611765, 0.580392, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.54902, 0.482353, 0.388235, 0.352941, \

0.321569, 0.290196, 0.290196, 0.321569, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.709804, 0.807843, 0.870588, 0.870588, 0.807843, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.482353, 0.419608, \
0.321569, 
0.290196, 0.290196, 0.321569, 0.388235, 0.517647, 0.580392, 0.611765, \
0.517647, 
0.419608, 0.388235, 0.388235, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.517647, 0.54902, 0.580392, 0.54902, 0.482353, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.482353, 0.45098, 0.517647, 
0.54902, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.54902, 0.482353, 0.419608, 0.388235, 0.388235, \
0.352941, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.517647, 0.678431, 0.807843, 0.870588, \
0.870588, 
0.709804, 0.54902, 0.482353, 0.580392, 0.709804, 0.741176, 0.709804, \
0.678431, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \

0.45098, 0.352941, 0.192157, 0.0941176, 0.0313725, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.160784, 0.258824, 0.223529, 0.129412, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 
0.0313725, 0, 0.0313725, 0.160784, 0.290196, 0.482353, 0.647059, 0.611765, 
0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.517647, 0.419608, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \

0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.709804, 0.839216, 0.905882, 0.905882, 0.807843, 0.741176, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.482353, \
0.388235, 
0.321569, 0.290196, 0.321569, 0.352941, 0.45098, 0.54902, 0.611765, 0.54902, 
0.419608, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.482353, 0.580392, 0.611765, 0.580392, 0.517647, \

0.482353, 0.482353, 0.517647, 0.580392, 0.580392, 0.517647, 0.482353, \
0.517647, 
0.54902, 0.517647, 0.482353, 0.45098, 0.419608, 0.45098, 0.517647, 0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.352941, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.54902, 0.678431, 0.776471, 0.870588, 0.839216, \
0.807843, 
0.611765, 0.482353, 0.419608, 0.45098, 0.54902, 0.580392, 0.580392, 0.611765, \

0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.54902, \
0.482353, 
0.352941, 0.223529, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.129412, 0.258824, 
0.223529, 0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0.0941176, 0.321569, 
0.54902, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.54902, 0.517647, 0.45098, 0.352941, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.709804, 0.839216, 0.905882, 0.905882, 0.839216, \
0.741176, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.517647, 0.45098, 0.388235, 0.321569, 0.290196, 0.290196, 0.388235, \
0.517647, 
0.580392, 0.54902, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.580392, 0.611765, 
0.580392, 0.517647, 0.482353, 0.45098, 0.517647, 0.580392, 0.611765, 0.54902, \

0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, 0.419608, 0.45098, \

0.517647, 0.54902, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.482353, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.580392, 0.611765, 0.647059, 0.678431, 0.709804, 0.741176, \
0.776471, 
0.647059, 0.54902, 0.45098, 0.419608, 0.419608, 0.419608, 0.517647, 0.611765, \

0.647059, 0.647059, 0.611765, 0.580392, 0.580392, 0.580392, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.517647, \
0.388235, 
0.258824, 0.160784, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.129412, 0.223529, 0.223529, 
0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.129412, 
0.352941, 0.580392, 0.647059, 0.580392, 0.580392, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, \

0.580392, 0.54902, 0.580392, 0.580392, 0.54902, 0.482353, 0.388235, 0.321569, \

0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.839216, 0.905882, 0.905882, 0.870588, \
0.741176, 
0.678431, 0.678431, 0.647059, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.482353, 0.419608, 0.352941, 0.321569, 0.290196, 0.321569, \
0.419608, 
0.54902, 0.580392, 0.517647, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.482353, 0.482353, 0.54902, 0.647059, 0.580392, \

0.517647, 0.482353, 0.482353, 0.517647, 0.482353, 0.45098, 0.45098, 0.482353, \

0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.54902, 0.482353, 0.45098, 0.388235, 0.352941, \

0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \

0.611765, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.678431, \
0.741176, 
0.647059, 0.611765, 0.580392, 0.54902, 0.45098, 0.419608, 0.482353, 0.54902, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.419608, \
0.290196, 
0.129412, 0.0627451, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0941176, 0.223529, 0.223529, 0.129412, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.160784, 
0.419608, 0.611765, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.54902, \

0.54902, 0.580392, 0.611765, 0.517647, 0.419608, 0.352941, 0.321569, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.839216, 0.905882, 0.905882, 0.870588, 0.741176, \
0.678431, 
0.678431, 0.647059, 0.678431, 0.678431, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.517647, 0.45098, 0.388235, 0.352941, 0.321569, 0.290196, 0.352941, \
0.482353, 
0.580392, 0.54902, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.517647, 0.54902, 
0.54902, 0.580392, 0.54902, 0.517647, 0.517647, 0.611765, 0.580392, 0.54902, 
0.482353, 0.482353, 0.482353, 0.45098, 0.419608, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.580392, 0.54902, 0.482353, 0.419608, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.482353, \
0.45098, 
0.580392, 0.611765, 0.647059, 0.678431, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.482353, 0.321569, \
0.192157, 
0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0941176, 0.192157, 0.223529, 0.129412, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0.0941176, 
0.258824, 0.482353, 0.678431, 0.678431, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.482353, 0.388235, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.741176, 0.839216, 0.905882, 0.937255, 0.870588, 0.741176, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.678431, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.517647, 0.45098, 0.419608, 0.352941, 0.321569, 0.321569, 0.290196, \
0.388235, 
0.54902, 0.580392, 0.45098, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.54902, 0.580392, 
0.580392, 0.647059, 0.647059, 0.54902, 0.482353, 0.580392, 0.611765, \
0.580392, 
0.482353, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.611765},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.580392, 0.54902, \
0.517647, 
0.419608, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.45098, 
0.419608, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, 0.517647, \
0.482353, 
0.54902, 0.580392, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.54902, 0.388235, 0.223529, \
0.0941176, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0941176, 0.192157, 
0.223529, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0, 0.0313725, 0.0627451, 0.129412, 0.321569, 0.580392, 0.647059, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.517647, 0.419608, \

0.352941, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.611765, 0.647059, 0.678431, 0.741176, 0.839216, \
0.905882, 
0.905882, 0.839216, 0.741176, 0.678431, 0.678431, 0.647059, 0.647059, \
0.678431, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.611765, 0.580392, 0.517647, 0.45098, 0.419608, \
0.388235, 
0.352941, 0.321569, 0.290196, 0.321569, 0.45098, 0.517647, 0.482353, 0.45098, \

0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.54902, 0.580392, 0.54902, 0.611765, 0.647059, 0.580392, 
0.482353, 0.54902, 0.611765, 0.611765, 0.517647, 0.45098, 0.517647, 0.54902, 
0.54902, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.580392},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.45098, 0.388235, 0.352941, \

0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.45098, 
0.45098, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.482353, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.647059, 0.611765, 0.611765, 0.580392, 0.482353, 0.290196, 0.129412, \
0.0313725, 
0.0313725, 0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.192157, 0.223529, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0, 0, 0, 0.160784, 0.388235, 0.54902, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.54902, 0.54902, 0.580392, 
0.580392, 0.517647, 0.419608, 0.352941, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.741176, 0.839216, 0.905882, 0.905882, 0.839216, 0.741176, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.678431, 0.678431, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.54902, 0.482353, 0.45098, 0.419608, 0.388235, 0.352941, 0.321569, 0.290196, \

0.388235, 0.482353, 0.517647, 0.482353, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.54902, 0.54902, 
0.517647, 0.54902, 0.611765, 0.580392, 0.517647, 0.517647, 0.611765, \
0.611765, 
0.517647, 0.482353, 0.517647, 0.580392, 0.611765, 0.54902, 0.517647, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392},
{0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.482353, 0.419608, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, \

0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.54902, 0.517647, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \

0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.482353, 0.352941, 0.192157, 0.0627451, 0, 
0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.129412, 0.192157, 0.160784, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0627451, 0.160784, 0.388235, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 
0.482353, 0.388235, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.741176, 0.839216, 0.870588, 0.870588, 0.839216, 0.776471, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, \
0.54902, 
0.482353, 0.482353, 0.45098, 0.419608, 0.388235, 0.352941, 0.321569, \
0.352941, 
0.45098, 0.517647, 0.482353, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.611765, 0.580392, 
0.482353, 0.482353, 0.580392, 0.611765, 0.580392, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.580392, 0.517647, \
0.45098, 
0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, \

0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.580392, 0.54902, 0.517647, 0.580392, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.54902, 0.388235, 0.258824, 0.129412, 0.0313725, 0, 
0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.129412, 0.192157, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0627451, 0.258824, 0.45098, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.54902, 0.517647, \

0.419608, 0.352941, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.741176, 0.839216, 0.870588, 0.905882, 0.839216, 0.776471, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, \
0.54902, 
0.482353, 0.482353, 0.482353, 0.45098, 0.388235, 0.352941, 0.321569, \
0.321569, 
0.419608, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \

0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.611765, 0.580392, 
0.482353, 0.45098, 0.517647, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.45098, 0.388235, 0.352941, \

0.352941, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.580392, 0.517647, 0.517647, 0.580392, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.580392, 0.45098, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.129412, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 
0, 0, 0.129412, 0.290196, 0.517647, 0.611765, 0.647059, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.517647, 0.45098, 0.388235, 
0.321569, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.741176, 
0.807843, 0.870588, 0.905882, 0.839216, 0.776471, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.419608, 0.388235, 0.352941, 0.321569, \
0.352941, 
0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 
0.54902, 0.580392, 0.580392, 0.517647, 0.54902, 0.611765, 0.611765, 0.482353, \

0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.517647, 0.482353, 0.419608, 0.388235, 0.352941, 0.321569, \
0.321569, 
0.352941, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.517647, 0.54902, 0.647059, 0.678431, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.517647, 0.352941, 0.192157, 0.0941176, 0.0313725, 0, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.129412, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0, 0, 0.0627451, 0.129412, 0.388235, 0.54902, 0.647059, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.482353, 
0.419608, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.678431, 
0.678431, 0.741176, 0.807843, 0.870588, 0.905882, 0.839216, 0.776471, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.517647, 0.517647, 0.54902, 0.54902, 0.482353, 0.419608, 0.388235, \

0.321569, 0.352941, 0.388235, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.54902, 0.580392, 0.580392, 0.482353, 0.54902, 0.611765, \

0.647059, 0.54902, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902},
{0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.517647, 
0.45098, 0.419608, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.611765, 0.54902, 0.517647, 0.580392, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.54902, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.223529, 0.45098, 0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.45098, 
0.388235, 0.321569, 0.290196, 0.290196, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.678431, 
0.678431, 0.741176, 0.807843, 0.870588, 0.905882, 0.870588, 0.776471, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.517647, 0.517647, 0.54902, 0.580392, 0.517647, 0.482353, \
0.419608, 
0.352941, 0.321569, 0.352941, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.482353, 0.517647, 0.611765, \

0.647059, 0.580392, 0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902},
{0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.517647, 0.45098, 0.388235, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.709804, 0.678431, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.482353, 0.321569, 0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 
0.0313725, 0, 0, 0.129412, 0.321569, 0.517647, 0.580392, 0.611765, 0.580392, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.419608, 0.352941, 0.321569, 0.290196, 
0.290196, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, \
0.321569, 
0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.741176, \
0.807843, 
0.870588, 0.905882, 0.870588, 0.776471, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.517647, \
0.517647, 
0.54902, 0.580392, 0.54902, 0.482353, 0.45098, 0.388235, 0.352941, 0.352941, 
0.419608, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.54902, 0.54902, 
0.54902, 0.517647, 0.482353, 0.517647, 0.580392, 0.647059, 0.580392, \
0.517647, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.482353, 0.419608, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.647059, 0.580392, 0.54902, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.580392, \
0.517647, 
0.352941, 0.223529, 0.0941176, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.192157, 0.352941, 0.54902, 0.611765, \

0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.45098, 0.388235, 0.321569, 0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, \
0.741176, 
0.807843, 0.870588, 0.870588, 0.870588, 0.776471, 0.709804, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.580392, \
0.517647, 
0.517647, 0.580392, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.388235, \

0.352941, 0.388235, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.517647, 0.611765, 
0.611765, 0.54902, 0.482353, 0.482353, 0.482353, 0.580392, 0.647059, \
0.611765, 
0.517647, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902},
{0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.517647, 0.482353, 0.419608, 0.388235, 0.352941, 0.321569, 0.321569, \
0.290196, 
0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.678431, 0.611765, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.611765, 0.647059, 0.647059, 0.54902, 0.45098, \

0.258824, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \

0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, \
0.0627451, 
0.258824, 0.482353, 0.611765, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 0.419608, 
0.352941, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.321569, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.678431, 0.741176, 0.807843, 0.839216, 0.870588, 0.870588, \
0.776471, 
0.709804, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.517647, 0.517647, 0.580392, 0.647059, 0.611765, \
0.580392, 
0.54902, 0.482353, 0.388235, 0.352941, 0.388235, 0.419608, 0.482353, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.54902, 0.647059, 0.678431, 0.580392, 0.45098, 0.482353, 0.482353, 
0.54902, 0.647059, 0.611765, 0.54902, 0.482353, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.517647},
{0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.419608, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.647059, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.678431, 0.647059, 0.482353, \
0.352941, 
0.192157, 0.129412, 0.0627451, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0.129412, 0.352941, 
0.54902, 0.611765, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.45098, 0.352941, 0.290196, 0.290196, 
0.321569, 0.290196, 0.290196, 0.321569, 0.290196, 0.290196, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.678431, 
0.741176, 0.807843, 0.839216, 0.905882, 0.870588, 0.807843, 0.709804, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.580392, 
0.517647, 0.517647, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, \
0.54902, 
0.45098, 0.352941, 0.352941, 0.388235, 0.45098, 0.482353, 0.482353, 0.45098, 
0.419608, 0.45098, 0.45098, 0.419608, 0.45098, 0.419608, 0.45098, 0.54902, 
0.678431, 0.647059, 0.54902, 0.482353, 0.482353, 0.482353, 0.54902, 0.647059, \

0.647059, 0.54902, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647},
{0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, \
0.388235, 
0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.678431, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.388235, \
0.258824, 
0.160784, 0.129412, 0.0627451, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.223529, 0.45098, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.419608, 0.352941, 
0.290196, 0.290196, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.678431, 0.741176, 0.807843, 0.839216, 0.870588, 0.870588, \
0.807843, 
0.709804, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.580392, 0.517647, 0.517647, 0.580392, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.517647, 0.419608, 0.388235, 0.352941, 0.419608, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.419608, 
0.45098, 0.54902, 0.647059, 0.611765, 0.517647, 0.45098, 0.482353, 0.482353, 
0.517647, 0.611765, 0.647059, 0.580392, 0.482353, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647},
{0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.419608, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.482353, 0.321569, \
0.192157, 
0.129412, 0.0941176, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.0941176, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0, 0, 0.129412, 0.321569, 0.517647, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.45098, 0.352941, 0.321569, 
0.290196, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.709804, 0.741176, 0.807843, 0.839216, 0.870588, 0.870588, \
0.807843, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.580392, 0.517647, 0.517647, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.54902, 0.482353, 0.419608, 0.321569, 0.388235, 0.45098, \

0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.517647, 0.611765, 0.580392, 0.482353, 0.45098, 0.517647, \
0.482353, 
0.482353, 0.580392, 0.647059, 0.611765, 0.517647, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647},
{0.517647, 0.482353, 0.45098, 0.419608, 0.388235, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.611765, 0.647059, 0.647059, 0.580392, 0.419608, 0.258824, \
0.160784, 
0.129412, 0.0941176, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.129412, 0.129412, 0.0941176, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0941176, 0.258824, 0.45098, 0.54902, 0.580392, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.482353, 0.388235, 0.352941, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.709804, 0.741176, 0.807843, 0.839216, 0.870588, \
0.870588, 
0.807843, 0.741176, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.517647, 0.54902, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.54902, 0.419608, 0.321569, \
0.388235, 
0.419608, 0.482353, 0.482353, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.482353, 0.54902, 0.54902, 0.482353, 0.45098, 0.517647, 
0.482353, 0.482353, 0.54902, 0.647059, 0.647059, 0.54902, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647},
{0.482353, 0.45098, 0.419608, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, \
0.580392, 
0.580392, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.611765, 0.517647, 0.352941, 0.192157, \
0.129412, 
0.0941176, 0.0941176, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.160784, 0.352941, 0.482353, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.45098, 
0.352941, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.807843, \
0.839216, 
0.870588, 0.870588, 0.807843, 0.741176, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.580392, 0.517647, 0.54902, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.482353, 
0.352941, 0.352941, 0.419608, 0.45098, 0.482353, 0.45098, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.517647, 0.517647, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.54902, 0.611765, 0.647059, 0.54902, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647},
{0.388235, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.647059, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.611765, 0.45098, 0.290196, 0.160784, \
0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0941176, 0.258824, 
0.45098, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.419608, 0.352941, 0.352941, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.709804, 0.741176, \
0.807843, 
0.839216, 0.870588, 0.870588, 0.807843, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.580392, 0.517647, \
0.54902, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.517647, 0.45098, 0.352941, 0.388235, 0.45098, 0.517647, 0.482353, 0.45098, 
0.419608, 0.388235, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.580392, \
0.647059, 
0.580392, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.517647, 0.482353, 0.517647},
{0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.678431, \
0.647059, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.517647, 0.352941, 0.223529, 0.129412, \
0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.192157, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.192157, 
0.352941, 0.482353, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.482353, \

0.388235, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.741176, \
0.807843, 
0.870588, 0.905882, 0.870588, 0.807843, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.54902, 0.517647, 0.54902, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.388235, 0.388235, 0.419608, 0.482353, 0.517647, 0.45098, \

0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.54902, 0.647059, \

0.611765, 0.517647, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.517647},
{0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.647059, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.580392, 0.419608, 0.258824, 0.160784, 0.129412, \
0.129412, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.192157, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.258824, 0.388235, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.45098, 
0.388235, 0.352941, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.741176, \
0.807843, 
0.870588, 0.905882, 0.870588, 0.807843, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.54902, 0.517647, 0.54902, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.54902, 
0.54902, 0.54902, 0.45098, 0.388235, 0.388235, 0.45098, 0.482353, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.419608, 0.517647, 0.647059, \

0.611765, 0.517647, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353},
{0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.611765, 0.580392, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.54902, 0.352941, 0.192157, 0.129412, 0.129412, \
0.129412, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.192157, 
0.160784, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.223529, 0.321569, 0.482353, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.482353, \
0.388235, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.647059, 0.678431, 0.709804, 0.741176, \
0.807843, 
0.839216, 0.870588, 0.870588, 0.839216, 0.776471, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.647059, 0.611765, 0.54902, 0.517647, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.54902, 
0.517647, 0.580392, 0.517647, 0.45098, 0.388235, 0.419608, 0.482353, \
0.482353, 
0.419608, 0.388235, 0.352941, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.419608, 0.482353, 0.54902, 0.580392, 0.611765, 0.678431, 0.678431, \

0.647059, 0.54902, 0.45098, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353},
{0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.611765, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.482353, 0.321569, 0.160784, 0.129412, 0.0941176, \
0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.192157, 
0.160784, 0.129412, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.192157, 0.258824, 0.419608, 0.517647, 0.54902, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.45098, \
0.388235, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, \
0.807843, 
0.870588, 0.905882, 0.905882, 0.839216, 0.776471, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.647059, 0.611765, 0.54902, 0.517647, 0.54902, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.517647, 
0.482353, 0.54902, 0.54902, 0.482353, 0.419608, 0.419608, 0.45098, 0.482353, 
0.45098, 0.388235, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, \

0.45098, 0.45098, 0.482353, 0.580392, 0.776471, 0.870588, 0.870588, 0.776471, \

0.678431, 0.611765, 0.482353, 0.45098, 0.419608, 0.45098, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.611765, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.54902, 0.419608, 0.258824, 0.129412, 0.0941176, 0.0941176, \
0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.160784, 
0.192157, 0.129412, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.192157, 0.352941, 0.482353, 0.54902, 0.54902, 0.517647, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.45098, \
0.352941, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, \
0.807843, 
0.870588, 0.905882, 0.905882, 0.839216, 0.807843, 0.741176, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.54902, 0.517647, 0.54902, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.517647, 
0.482353, 0.517647, 0.54902, 0.517647, 0.45098, 0.388235, 0.419608, 0.482353, \

0.482353, 0.419608, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.54902, 0.807843, 0.968627, 0.968627, \
0.839216, 
0.709804, 0.647059, 0.517647, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, \

0.45098, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.580392, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.647059, 
0.647059, 0.517647, 0.321569, 0.192157, 0.129412, 0.129412, 0.0941176, \
0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.160784, 
0.192157, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.129412, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.290196, 0.45098, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.482353, 0.419608, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.678431, 0.709804, 0.776471, 0.807843, \
0.870588, 
0.905882, 0.905882, 0.870588, 0.807843, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.54902, 0.517647, 0.580392, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.482353, \
0.45098, 
0.517647, 0.580392, 0.517647, 0.419608, 0.388235, 0.419608, 0.482353, \
0.482353, 
0.45098, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.517647, 0.678431, 0.870588, 0.905882, 0.839216, \
0.741176, 
0.678431, 0.54902, 0.45098, 0.419608, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.45098},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.647059, 
0.611765, 0.45098, 0.258824, 0.192157, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.160784, 
0.192157, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.129412, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.223529, 0.388235, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.517647, 0.54902, 0.54902, 0.517647, 0.482353, 0.388235, 0.321569, 0.290196, \

0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.709804, 0.776471, 0.807843, \
0.870588, 
0.905882, 0.905882, 0.870588, 0.807843, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.54902, 0.517647, 0.580392, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.45098, 0.45098, \

0.517647, 0.54902, 0.45098, 0.352941, 0.352941, 0.419608, 0.45098, 0.482353, 
0.482353, 0.45098, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.45098, 0.482353, 0.517647, 0.580392, 0.647059, 0.678431, \
0.678431, 
0.647059, 0.54902, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.45098},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, \
0.647059, 
0.54902, 0.388235, 0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.160784, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.160784, 
0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.160784, 0.321569, 0.45098, 0.517647, 0.54902, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.45098, 0.352941, 0.290196, 0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.709804, 0.776471, 0.807843, \
0.870588, 
0.905882, 0.905882, 0.870588, 0.807843, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.611765, 0.54902, 0.517647, 0.580392, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.517647, 0.419608, \
0.419608, 
0.482353, 0.482353, 0.388235, 0.321569, 0.352941, 0.419608, 0.45098, 0.45098, \

0.482353, 0.45098, 0.419608, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.517647, 0.482353, 0.45098, 0.388235, 0.419608, 0.482353, \
0.580392, 
0.647059, 0.54902, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.45098, 0.290196, 0.160784, 0.160784, 0.160784, 0.129412, 0.0627451, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.160784, 
0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.258824, 0.388235, 0.517647, 0.580392, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.517647, 0.482353, 0.419608, 0.321569, 0.290196, 0.258824, \

0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.709804, 0.776471, 0.839216, \
0.870588, 
0.905882, 0.937255, 0.870588, 0.807843, 0.741176, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.54902, 0.517647, 0.580392, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.611765, 0.580392, 0.517647, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.352941, 0.321569, 0.321569, 0.388235, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.419608, 0.352941, 0.321569, 0.388235, 0.482353, 
0.54902, 0.580392, 0.517647, 0.45098, 0.419608, 0.388235, 0.45098, 0.54902, 
0.647059, 0.54902, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.678431, 0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.419608, 0.258824, 0.129412, 0.160784, 0.192157, 0.129412, 0.0627451, \
0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.129412, 
0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.129412, 0.160784, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.192157, 0.321569, 0.482353, 0.54902, 0.517647, \
0.482353, 
0.54902, 0.54902, 0.517647, 0.45098, 0.388235, 0.321569, 0.258824, 0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.741176, 0.776471, 0.839216, \
0.905882, 
0.937255, 0.937255, 0.905882, 0.839216, 0.776471, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.611765, 0.54902, 0.517647, 0.580392, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.611765, 0.54902, 0.482353, 0.419608, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.388235, 0.45098, 0.45098, \

0.419608, 0.45098, 0.482353, 0.45098, 0.352941, 0.321569, 0.419608, 0.54902, 
0.647059, 0.517647, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, \
0.482353, 
0.580392, 0.580392, 0.482353, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.678431, 0.611765, 0.580392, 0.54902, 0.54902, 0.517647, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.482353, 
0.321569, 0.192157, 0.129412, 0.160784, 0.160784, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.129412, 0.160784, 0.129412, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.160784, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.258824, 0.419608, 
0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.419608, 0.321569, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.709804, \
0.741176, 
0.807843, 0.839216, 0.905882, 0.937255, 0.968627, 0.905882, 0.839216, \
0.776471, 
0.741176, 0.709804, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, 0.611765, \
0.54902, 
0.517647, 0.580392, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.388235, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.419608, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.352941, 
0.419608, 0.54902, 0.647059, 0.54902, 0.388235, 0.352941, 0.352941, 0.388235, \

0.388235, 0.388235, 0.45098, 0.54902, 0.580392, 0.482353, 0.419608, 0.45098, 
0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098},
{0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.580392, 0.54902, \
0.517647, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.45098, 
0.290196, 0.160784, 0.0941176, 0.160784, 0.160784, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0941176, 0.223529, 0.192157, 0.160784, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.129412, 
0.160784, 0.160784, 0.129412, 0.129412, 0.0941176, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.129412, 0.192157, 0.192157, 0.129412, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.223529, 0.388235, 0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.419608, 0.321569, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.709804, 0.741176, \
0.807843, 
0.839216, 0.905882, 0.937255, 0.968627, 0.905882, 0.839216, 0.776471, \
0.741176, 
0.709804, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.54902, 0.54902, \

0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.517647, 0.419608, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.517647, 
0.611765, 0.580392, 0.419608, 0.352941, 0.352941, 0.388235, 0.419608, \
0.388235, 
0.388235, 0.45098, 0.517647, 0.54902, 0.482353, 0.419608, 0.419608, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353},
{0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, \

0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.54902, \
0.517647, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.54902, \
0.388235, 
0.223529, 0.129412, 0.0941176, 0.129412, 0.129412, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0941176, 0.258824, 0.223529, 0.160784, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.160784, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.129412, 
0.223529, 0.192157, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.223529, 0.321569, 0.223529, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.160784, 0.321569, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.388235, \
0.290196, 
0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.709804, \
0.741176, 
0.807843, 0.839216, 0.905882, 0.968627, 0.968627, 0.937255, 0.870588, \
0.807843, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, \
0.611765, 
0.54902, 0.45098, 0.388235, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \

0.352941, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.388235, \
0.517647, 
0.647059, 0.678431, 0.45098, 0.290196, 0.321569, 0.352941, 0.388235, \
0.419608, 
0.388235, 0.388235, 0.419608, 0.45098, 0.54902, 0.482353, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353},
{0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.580392, \
0.54902, 
0.517647, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.482353, \
0.352941, 
0.192157, 0.129412, 0.0941176, 0.160784, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.160784, 0.258824, 0.258824, 0.192157, 0.0941176, 0.0627451, 0.129412, 
0.223529, 0.192157, 0.129412, 0.129412, 0.0941176, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.223529, 0.352941, 0.321569, 0.160784, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.290196, 0.45098, 
0.517647, 0.517647, 0.482353, 0.517647, 0.45098, 0.388235, 0.290196, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.776471, \
0.807843, 
0.870588, 0.937255, 0.968627, 0.968627, 0.937255, 0.870588, 0.807843, \
0.741176, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.580392, 0.611765, 0.647059, 0.611765, 0.647059, 0.611765, 0.517647, \
0.45098, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.352941, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.611765, \
0.709804, 
0.647059, 0.388235, 0.290196, 0.321569, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.517647, 0.482353, 0.45098, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.482353, 0.482353},
{0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.45098, 0.290196, 
0.160784, 0.0941176, 0.129412, 0.160784, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.160784, 0.352941, 0.45098, 0.321569, 0.0941176, 0.0627451, 0.129412, \
0.192157, 
0.223529, 0.160784, 0.129412, 0.0941176, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.129412, 0.290196, 0.290196, 0.192157, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.129412, 0.258824, 0.419608, 0.517647, 
0.517647, 0.482353, 0.517647, 0.45098, 0.352941, 0.290196, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.807843, \
0.870588, 
0.937255, 0.968627, 1, 0.937255, 0.905882, 0.839216, 0.776471, 0.741176, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.54902, 0.54902, \

0.611765, 0.647059, 0.647059, 0.611765, 0.517647, 0.45098, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.517647, 0.647059, 0.741176, \
0.517647, 
0.352941, 0.388235, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.482353, 0.482353, 0.45098, 0.419608, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, \

0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.419608, 0.258824, 
0.129412, 0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.160784, 0.352941, 0.54902, 0.388235, 0.129412, 0.0941176, 0.160784, \
0.192157, 
0.258824, 0.160784, 0.129412, 0.0941176, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.160784, 0.192157, 0.192157, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.223529, 0.352941, 0.482353, 
0.517647, 0.517647, 0.482353, 0.419608, 0.321569, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.807843, \
0.870588, 
0.937255, 0.968627, 1, 0.968627, 0.905882, 0.839216, 0.776471, 0.741176, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.482353, 0.419608, 0.419608, 0.45098, 0.45098, \

0.388235, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.611765, 0.678431, 0.678431, \
0.419608, 
0.388235, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.45098, 0.482353, 0.45098, 0.419608, 0.388235, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353},
{0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.54902, 0.517647, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.517647, 0.388235, 0.223529, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.223529, 0.419608, 0.388235, 0.160784, 0.129412, 0.160784, \
0.223529, 
0.290196, 0.192157, 0.129412, 0.0941176, 0.129412, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.290196, 0.45098, 0.517647, 
0.517647, 0.482353, 0.419608, 0.321569, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.741176, 0.776471, 0.839216, 0.870588, \
0.937255, 
0.968627, 1, 0.968627, 0.905882, 0.839216, 0.776471, 0.741176, 0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, \
0.580392, 
0.54902, 0.482353, 0.419608, 0.419608, 0.482353, 0.517647, 0.45098, 0.352941, \

0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.517647, 0.647059, 0.647059, 0.517647, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.45098, 0.45098, 0.419608, 0.388235, 0.388235, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353},
{0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.54902, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.580392, 0.54902, 0.482353, 0.352941, 0.192157, 
0.129412, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.223529, 0.321569, 0.223529, 0.0941176, 0.129412, 
0.223529, 0.290196, 0.223529, 0.160784, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.160784, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.258824, 0.388235, 
0.482353, 0.517647, 0.482353, 0.388235, 0.290196, 0.258824, 0.290196, \
0.321569, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.741176, 0.776471, 0.839216, \
0.905882, 
0.937255, 0.968627, 1, 0.968627, 0.937255, 0.839216, 0.807843, 0.741176, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.45098, 0.517647, 0.580392, 0.517647, 0.388235, \

0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.580392, 0.647059, 0.580392, 0.352941, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.352941, \
0.321569, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353},
{0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, \

0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, \
0.611765, 
0.611765, 0.54902, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, \

0.54902, 0.517647, 0.517647, 0.580392, 0.54902, 0.419608, 0.290196, 0.192157, \

0.129412, 0.129412, 0.129412, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.129412, 
0.223529, 0.321569, 0.223529, 0.129412, 0.0941176, 0.129412, 0.129412, \
0.160784, 
0.160784, 0.192157, 0.160784, 0.160784, 0.160784, 0.160784, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.223529, 0.352941, 
0.482353, 0.517647, 0.482353, 0.352941, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.580392, 0.611765, 
0.647059, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.741176, 0.776471, 0.839216, \
0.905882, 
0.937255, 0.968627, 1, 0.968627, 0.937255, 0.870588, 0.807843, 0.776471, 
0.741176, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.54902, 0.580392, 0.647059, 0.580392, 0.482353, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.482353, 0.647059, 0.611765, 0.45098, 0.419608, \
0.419608, 
0.388235, 0.45098, 0.419608, 0.419608, 0.419608, 0.388235, 0.352941, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.388235, 0.419608, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098},
{0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.419608, 0.290196, 0.192157, \

0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.0941176, 0.129412, 
0.223529, 0.352941, 0.223529, 0.160784, 0.129412, 0.129412, 0.129412, \
0.160784, 
0.160784, 0.192157, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.192157, 0.321569, 
0.45098, 0.517647, 0.45098, 0.352941, 0.258824, 0.258824, 0.290196, 0.290196, \

0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.580392, 0.647059, 
0.678431, 0.678431, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.741176, 0.807843, 0.839216, \
0.905882, 
0.937255, 0.968627, 1, 1, 0.937255, 0.870588, 0.807843, 0.776471, 0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.611765, 0.54902, 0.419608, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.517647, 0.611765, 0.54902, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.388235, 0.419608, 0.419608, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098},
{0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.776471, 0.741176, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.647059, 0.580392, 0.54902, 0.517647, 0.517647, 0.482353, 0.517647, 0.54902, \

0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.388235, 0.258824, \
0.192157, 
0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.258824, 0.352941, 0.258824, 0.160784, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.192157, 0.192157, 0.223529, 0.192157, 0.192157, 0.160784, 0.160784, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.160784, 0.258824, 
0.419608, 0.482353, 0.45098, 0.352941, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.678431, \

0.709804, 0.741176, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.776471, 0.807843, 0.839216, \
0.905882, 
0.937255, 0.968627, 1, 1, 0.937255, 0.870588, 0.839216, 0.776471, 0.741176, 
0.709804, 0.678431, 0.678431, 0.647059, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.611765, 0.482353, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.45098, 0.54902, 0.580392, 0.482353, 0.388235, 0.388235, 0.419608, 0.388235, \

0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.352941, 
0.321569, 0.321569, 0.352941, 0.388235, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.482353, 0.352941, 0.258824, \
0.192157, 
0.160784, 0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.160784, 
0.258824, 0.321569, 0.258824, 0.160784, 0.129412, 0.160784, 0.160784, \
0.160784, 
0.192157, 0.192157, 0.223529, 0.223529, 0.192157, 0.192157, 0.160784, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.223529, 
0.388235, 0.517647, 0.419608, 0.321569, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.647059, 
0.678431, 0.709804, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.905882, 
0.937255, 0.968627, 1, 1, 0.937255, 0.905882, 0.839216, 0.776471, 0.741176, 
0.709804, 0.678431, 0.678431, 0.647059, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.580392, 0.45098, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.388235, 0.352941, \
0.388235, 
0.45098, 0.54902, 0.54902, 0.45098, 0.352941, 0.388235, 0.419608, 0.419608, 
0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.352941, 
0.321569, 0.321569, 0.290196, 0.321569, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.45098},
{0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.45098, 0.321569, 0.223529, \
0.192157, 
0.129412, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.129412, 0.160784, 0.160784, 
0.258824, 0.321569, 0.290196, 0.160784, 0.129412, 0.160784, 0.160784, \
0.160784, 
0.192157, 0.223529, 0.223529, 0.223529, 0.223529, 0.192157, 0.160784, \
0.160784, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.192157, 
0.352941, 0.482353, 0.419608, 0.321569, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.580392, 0.611765, 
0.647059, 0.647059, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.870588, 
0.937255, 0.968627, 1, 1, 0.937255, 0.905882, 0.839216, 0.807843, 0.741176, 
0.709804, 0.709804, 0.678431, 0.647059, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.54902, 0.419608, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.352941, 0.321569, 0.321569, 0.352941, 0.388235, 0.352941, \
0.388235, 
0.482353, 0.54902, 0.517647, 0.419608, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.321569, 0.290196, 0.321569, 0.352941, 0.388235, 0.352941, \
0.352941, 
0.388235, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098},
{0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.419608, 0.290196, 0.192157, \
0.160784, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.160784, 0.160784, 0.129412, 
0.223529, 0.321569, 0.290196, 0.192157, 0.129412, 0.160784, 0.160784, \
0.160784, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.192157, 0.192157, \
0.160784, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.160784, 
0.290196, 0.45098, 0.388235, 0.321569, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.870588, 
0.937255, 0.968627, 1, 1, 0.937255, 0.905882, 0.839216, 0.807843, 0.741176, 
0.741176, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.580392, 0.482353, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.482353, 0.54902, 0.482353, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098},
{0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.482353, 0.388235, 0.258824, 0.160784, \
0.160784, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0941176, 0.160784, 0.258824, 0.192157, 0.129412, 
0.192157, 0.321569, 0.290196, 0.192157, 0.129412, 0.160784, 0.160784, \
0.192157, 
0.223529, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.160784, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.258824, 0.419608, 0.388235, 0.321569, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.870588, 
0.937255, 0.968627, 0.968627, 0.968627, 0.937255, 0.905882, 0.839216, \
0.807843, 
0.776471, 0.741176, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.678431, 0.54902, 0.45098, 0.352941, 0.321569, 0.352941, \

0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.482353, 0.517647, 0.45098, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098},
{0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.482353, 0.352941, 0.223529, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.129412, 0.258824, 0.352941, 0.258824, 0.0941176, 
0.129412, 0.290196, 0.290196, 0.192157, 0.129412, 0.160784, 0.160784, \
0.192157, 
0.223529, 0.258824, 0.290196, 0.290196, 0.290196, 0.258824, 0.223529, \
0.192157, 
0.192157, 0.160784, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.223529, 0.388235, 0.352941, 0.290196, 0.258824, 0.290196, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.870588, 
0.937255, 0.937255, 0.968627, 0.968627, 0.937255, 0.870588, 0.839216, \
0.807843, 
0.776471, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.517647, 0.419608, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, \
0.352941, 
0.388235, 0.482353, 0.517647, 0.419608, 0.388235, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.388235, 0.352941, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.741176, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.611765, 0.580392, 0.580392, 0.517647, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.482353, 0.321569, 0.192157, 0.129412, \
0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.129412, 0.290196, 0.419608, 0.290196, 0.129412, 
0.129412, 0.290196, 0.290196, 0.192157, 0.160784, 0.160784, 0.192157, \
0.192157, 
0.223529, 0.290196, 0.290196, 0.321569, 0.321569, 0.290196, 0.258824, \
0.223529, 
0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.223529, 0.321569, 0.352941, 0.290196, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.419608, \

0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.776471, 0.807843, \
0.870588, 
0.905882, 0.937255, 0.968627, 0.968627, 0.937255, 0.870588, 0.839216, \
0.807843, 
0.776471, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.482353, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.45098, 0.45098, 0.45098, 0.388235, 0.388235, 0.388235, 0.388235, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.352941, 0.290196, 0.258824, 0.223529, \
0.290196, 
0.352941, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098},
{0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, 0.517647, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.45098, 0.321569, 0.192157, 0.129412, \
0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.129412, 0.290196, 0.419608, 0.321569, 0.129412, 
0.129412, 0.258824, 0.258824, 0.192157, 0.160784, 0.160784, 0.192157, \
0.192157, 
0.258824, 0.321569, 0.321569, 0.352941, 0.352941, 0.290196, 0.258824, \
0.258824, 
0.223529, 0.160784, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.192157, 0.290196, 0.321569, 0.290196, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.741176, 0.807843, 0.839216, \
0.870588, 
0.905882, 0.937255, 0.937255, 0.937255, 0.937255, 0.870588, 0.839216, \
0.807843, 
0.776471, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.482353, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.45098, 0.45098, 0.45098, 0.388235, 0.352941, 0.388235, 0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.258824, 0.160784, 0.129412, 0.160784, \
0.290196, 
0.388235, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098},
{0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, \
0.482353, 
0.45098, 0.482353, 0.482353, 0.45098, 0.290196, 0.160784, 0.129412, \
0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.129412, 0.290196, 0.419608, 0.321569, 0.160784, 
0.129412, 0.223529, 0.258824, 0.192157, 0.160784, 0.160784, 0.160784, \
0.192157, 
0.258824, 0.321569, 0.352941, 0.388235, 0.388235, 0.321569, 0.290196, \
0.258824, 
0.223529, 0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.160784, 0.258824, 0.290196, 0.290196, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.741176, 0.807843, 0.839216, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, \
0.807843, 
0.776471, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.45098, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.321569, 0.258824, 0.192157, 0.0941176, 0.0627451, 0.129412, 
0.290196, 0.388235, 0.352941, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098},
{0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.54902, \
0.517647, 
0.45098, 0.45098, 0.482353, 0.419608, 0.290196, 0.160784, 0.0941176, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0941176, 0.129412, 0.223529, 0.321569, 0.290196, 0.129412, 
0.129412, 0.192157, 0.258824, 0.223529, 0.160784, 0.160784, 0.160784, \
0.192157, 
0.258824, 0.321569, 0.419608, 0.45098, 0.419608, 0.388235, 0.321569, \
0.290196, 
0.258824, 0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.129412, 0.129412, 0.129412, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.160784, 0.223529, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.839216, 
0.870588, 0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.807843, \
0.807843, 
0.776471, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.678431, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.54902, 0.419608, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, \
0.419608, 
0.290196, 0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.129412, \
0.258824, 
0.321569, 0.321569, 0.258824, 0.258824, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098},
{0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, \
0.517647, 
0.45098, 0.45098, 0.45098, 0.388235, 0.258824, 0.160784, 0.0941176, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.192157, 0.160784, 
0.160784, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.160784, 0.223529, 0.192157, 0.129412, 
0.129412, 0.192157, 0.258824, 0.223529, 0.160784, 0.160784, 0.192157, \
0.223529, 
0.290196, 0.352941, 0.45098, 0.517647, 0.517647, 0.45098, 0.388235, 0.352941, \

0.290196, 0.223529, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.160784, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.129412, 0.192157, 0.223529, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.807843, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.807843, \
0.807843, 
0.776471, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.517647, 0.388235, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.352941, 
0.258824, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.258824, 
0.258824, 0.223529, 0.192157, 0.223529, 0.223529, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.321569, 0.321569, 0.352941, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, \
0.54902, 
0.482353, 0.45098, 0.419608, 0.388235, 0.258824, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.160784, 0.192157, 0.223529, 0.258824, 
0.258824, 0.160784, 0.129412, 0.160784, 0.129412, 0.129412, 0.0941176, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.0941176, 0.129412, 
0.192157, 0.223529, 0.192157, 0.192157, 0.192157, 0.192157, 0.223529, \
0.321569, 
0.388235, 0.482353, 0.580392, 0.611765, 0.54902, 0.45098, 0.388235, 0.321569, \

0.223529, 0.192157, 0.160784, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.129412, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.192157, 0.223529, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, \
0.517647, 
0.54902, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.870588, 0.839216, 0.807843, 0.807843, \
0.776471, 
0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.580392, 0.482353, 0.388235, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.388235, 0.352941, 0.388235, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.352941, 0.290196, 0.258824, \
0.223529, 
0.192157, 0.223529, 0.160784, 0.129412, 0.160784, 0.290196, 0.321569, \
0.258824, 
0.223529, 0.192157, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.290196, 0.321569, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.419608},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.647059, 0.647059, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.45098, 0.419608, 0.352941, 0.258824, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.160784, 0.258824, 0.388235, 0.482353, 
0.45098, 0.290196, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 0.129412, 
0.160784, 0.192157, 0.192157, 0.192157, 0.192157, 0.192157, 0.258824, \
0.321569, 
0.388235, 0.517647, 0.647059, 0.709804, 0.647059, 0.54902, 0.45098, 0.321569, \

0.258824, 0.223529, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.129412, 0.258824, 0.290196, 0.223529, 
0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.192157, 0.192157, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.517647, 0.54902, \

0.580392, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.741176, 0.776471, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.839216, 0.839216, 0.807843, 0.776471, \
0.776471, 
0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.678431, \
0.647059, 
0.580392, 0.45098, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.388235, 0.352941, 0.388235, 0.388235, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.352941, 0.290196, 0.192157, 0.160784, \
0.192157, 
0.192157, 0.223529, 0.223529, 0.258824, 0.352941, 0.482353, 0.419608, \
0.290196, 
0.223529, 0.223529, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.352941, 0.223529, 0.160784, 0.0941176, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.321569, 0.580392, 0.776471, 
0.678431, 0.388235, 0.192157, 0.160784, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.0941176, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.192157, 
0.192157, 0.192157, 0.192157, 0.192157, 0.192157, 0.258824, 0.321569, \
0.388235, 
0.580392, 0.709804, 0.839216, 0.776471, 0.647059, 0.482353, 0.388235, \
0.258824, 
0.223529, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0941176, 
0.0627451, 0.0313725, 0.129412, 0.290196, 0.54902, 0.419608, 0.258824, \
0.129412, 
0.0627451, 0.0313725, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.160784, 0.192157, 0.192157, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.517647, 0.580392, 0.580392, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.776471, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.776471, 0.776471, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.678431, 0.647059, 0.580392, \
0.45098, 
0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.388235, 0.352941, 0.388235, 0.388235, 0.352941, 0.388235, \
0.352941, 
0.321569, 0.258824, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, \
0.192157, 
0.258824, 0.388235, 0.580392, 0.647059, 0.482353, 0.290196, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.352941, 
0.321569, 0.290196, 0.258824, 0.290196, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.517647, 0.419608, 0.321569, 0.223529, 0.129412, 0.0941176, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.352941, 0.611765, 0.807843, 
0.776471, 0.45098, 0.192157, 0.129412, 0.160784, 0.129412, 0.129412, \
0.160784, 
0.160784, 0.129412, 0.129412, 0.192157, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.223529, 0.223529, 0.160784, 0.223529, 0.321569, 0.258824, 0.258824, \
0.419608, 
0.611765, 0.839216, 0.905882, 0.870588, 0.807843, 0.611765, 0.419608, \
0.290196, 
0.258824, 0.192157, 0.160784, 0.129412, 0.0941176, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.129412, 0.258824, 0.678431, 0.580392, 0.321569, 0.129412, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.192157, 0.192157, 0.223529, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.482353, 0.517647, 0.54902, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.776471, 0.807843, 0.839216, 0.807843, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.776471, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.54902, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.352941, 0.290196, \
0.258824, 
0.192157, 0.160784, 0.129412, 0.129412, 0.160784, 0.192157, 0.223529, \
0.352941, 
0.54902, 0.647059, 0.580392, 0.419608, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.321569, \
0.352941, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608},
{0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.54902, 0.45098, 0.321569, 0.223529, 0.129412, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.160784, 0.290196, 0.482353, 0.647059, 
0.580392, 0.352941, 0.192157, 0.129412, 0.160784, 0.129412, 0.129412, \
0.160784, 
0.160784, 0.129412, 0.160784, 0.192157, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.192157, 0.290196, 0.258824, 0.258824, 0.321569, 0.321569, 0.352941, \
0.482353, 
0.678431, 0.905882, 0.968627, 0.968627, 0.905882, 0.709804, 0.517647, \
0.321569, 
0.258824, 0.192157, 0.192157, 0.160784, 0.129412, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.160784, 0.482353, 0.45098, 0.290196, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.192157, 0.192157, 0.223529, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.517647, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.388235, 0.388235, 0.388235, 0.352941, 0.321569, 0.192157, \
0.160784, 
0.160784, 0.160784, 0.192157, 0.223529, 0.258824, 0.321569, 0.45098, \
0.517647, 
0.54902, 0.517647, 0.388235, 0.258824, 0.223529, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608},
{0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.482353, 0.352941, 0.223529, 0.129412, 0.0627451, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.192157, 0.290196, 0.388235, 
0.352941, 0.258824, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.160784, 0.160784, 0.192157, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.192157, 0.290196, 0.290196, 0.290196, 0.321569, 0.388235, 0.45098, 0.54902, \

0.776471, 0.937255, 1, 1, 0.968627, 0.839216, 0.611765, 0.388235, 0.258824, 
0.223529, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.129412, 0.258824, 0.290196, 0.258824, 0.160784, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.192157, 
0.223529, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.419608, \
0.388235, 
0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.517647, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.321569, 0.290196, \
0.352941, 
0.388235, 0.45098, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.580392, \

0.517647, 0.419608, 0.352941, 0.290196, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608},
{0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.517647, 0.388235, 0.223529, 0.129412, 0.0627451, \
0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.160784, 0.160784, 0.192157, 
0.192157, 0.192157, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.160784, 0.192157, 0.192157, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.192157, 0.223529, 0.258824, 0.290196, 0.352941, 0.388235, 0.45098, \
0.611765, 
0.807843, 0.937255, 1, 1, 1, 0.937255, 0.741176, 0.482353, 0.290196, \
0.223529, 
0.192157, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.129412, 0.129412, 0.223529, 0.223529, 0.160784, 0.129412, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.160784, 0.192157, 0.223529, 0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.611765, 0.482353, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.352941, \
0.388235, 
0.388235, 0.352941, 0.321569, 0.258824, 0.258824, 0.352941, 0.45098, \
0.647059, 
0.807843, 0.870588, 0.839216, 0.741176, 0.678431, 0.45098, 0.352941, \
0.258824, 
0.223529, 0.258824, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.388235, 0.388235},
{0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.54902, 0.419608, 0.258824, 0.129412, 0.0627451, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 
0.129412, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.160784, 0.223529, 0.192157, 0.160784, 0.160784, 0.192157, \
0.129412, 
0.192157, 0.192157, 0.223529, 0.258824, 0.321569, 0.352941, 0.482353, \
0.611765, 
0.839216, 0.968627, 1, 1, 1, 1, 0.870588, 0.611765, 0.352941, 0.258824, 
0.192157, 0.160784, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0941176, 0.129412, 0.129412, 0.192157, 0.192157, 0.129412, 0.129412, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.160784, 0.192157, 0.223529, 0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.611765, 0.482353, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.321569, 0.258824, 0.223529, 0.258824, 0.321569, 0.419608, \
0.54902, 
0.678431, 0.741176, 0.678431, 0.580392, 0.482353, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.290196, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.388235},
{0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.482353, 0.321569, 0.129412, 0.0627451, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.160784, 0.223529, 0.192157, 0.129412, 0.0941176, 0.129412, \
0.0941176, 
0.192157, 0.223529, 0.290196, 0.290196, 0.258824, 0.321569, 0.45098, \
0.580392, 
0.807843, 0.937255, 1, 1, 1, 1, 0.937255, 0.709804, 0.419608, 0.290196, 
0.192157, 0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.129412, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.160784, 0.192157, 0.223529, 0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.580392, 0.45098, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, \
0.352941, 
0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.290196, 0.223529, 0.223529, 0.223529, 0.192157, 0.223529, \
0.258824, 
0.290196, 0.321569, 0.321569, 0.290196, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941},
{0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.54902, 0.388235, 0.160784, 0.0627451, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.160784, 0.192157, 0.192157, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.129412, 0.223529, 0.388235, 0.419608, 0.321569, 0.290196, \
0.388235, 
0.517647, 0.741176, 0.905882, 0.968627, 1, 0.968627, 1, 0.937255, 0.678431, 
0.419608, 0.290196, 0.223529, 0.192157, 0.160784, 0.160784, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.160784, 0.129412, 0.129412, 
0.129412, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.223529, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.580392, 0.419608, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.290196, 0.258824, 0.223529, 0.223529, 0.223529, \
0.192157, 
0.192157, 0.160784, 0.160784, 0.160784, 0.223529, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.352941, 0.352941, 0.352941, 0.321569, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.678431, 0.611765, 0.611765, 0.580392, 0.45098, 0.192157, 0.0627451, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 
0.129412, 0.160784, 0.129412, 0.160784, 0.192157, 0.160784, 0.0941176, \
0.0941176, 
0.0627451, 0.0941176, 0.192157, 0.45098, 0.580392, 0.419608, 0.223529, \
0.290196, 
0.45098, 0.709804, 0.870588, 0.968627, 1, 0.968627, 1, 0.905882, 0.647059, 
0.388235, 0.290196, 0.223529, 0.192157, 0.160784, 0.129412, 0.0941176, \
0.0941176, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.54902, 0.419608, \
0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.290196, 0.223529, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.223529, 0.223529, 0.223529, 0.223529, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.352941},
{0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.611765, 0.678431, 0.647059, 0.580392, 0.482353, 0.258824, 0.0627451, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 
0.129412, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 
0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.129412, 0.129412, 0.160784, 0.321569, 0.54902, 0.580392, 0.290196, \
0.160784, 
0.321569, 0.647059, 0.905882, 0.968627, 0.968627, 0.968627, 0.968627, \
0.870588, 
0.647059, 0.419608, 0.321569, 0.223529, 0.192157, 0.192157, 0.160784, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.0941176, 0.0627451, 0.0627451, 0.129412, 0.160784, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.192157, 
0.258824, 0.290196, 0.290196, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.611765, 0.647059, 0.647059, 0.517647, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.321569, 0.321569, 0.352941, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.352941, 0.290196, 0.258824, 0.258824, 0.223529, 0.223529, \
0.192157, 
0.192157, 0.192157, 0.223529, 0.223529, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.321569},
{0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.517647, 0.290196, 0.129412, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 
0.160784, 0.160784, 0.192157, 0.192157, 0.223529, 0.419608, 0.580392, \
0.45098, 
0.223529, 0.192157, 0.482353, 0.741176, 0.937255, 0.968627, 0.968627, \
0.968627, 
0.870588, 0.647059, 0.45098, 0.352941, 0.258824, 0.223529, 0.223529, \
0.192157, 
0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.192157, 0.258824, 0.321569, 0.290196, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, 0.611765, \
0.517647, 
0.388235, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.290196, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569},
{0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.54902, 0.352941, 0.160784, \
0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.160784, 0.258824, 0.258824, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 
0.160784, 0.160784, 0.192157, 0.192157, 0.160784, 0.290196, 0.482353, \
0.45098, 
0.290196, 0.160784, 0.321569, 0.580392, 0.807843, 0.937255, 0.937255, \
0.905882, 
0.807843, 0.611765, 0.482353, 0.388235, 0.321569, 0.290196, 0.258824, \
0.223529, 
0.192157, 0.192157, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.160784, 0.290196, 0.321569, 0.321569, 0.290196, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.482353, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.321569, 0.321569, 0.290196, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569},
{0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.580392, 0.419608, 0.192157, \
0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.192157, 0.352941, 0.352941, 0.223529, 
0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.160784, 
0.160784, 0.160784, 0.160784, 0.192157, 0.192157, 0.192157, 0.258824, \
0.321569, 
0.290196, 0.258824, 0.321569, 0.482353, 0.647059, 0.807843, 0.870588, \
0.807843, 
0.709804, 0.580392, 0.45098, 0.388235, 0.321569, 0.290196, 0.258824, \
0.223529, 
0.192157, 0.192157, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.160784, 0.290196, 0.352941, 0.321569, 0.290196, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.45098, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.419608, \
0.388235, 
0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941},
{0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.580392, 0.45098, 0.258824, \
0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 
0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.160784, 0.192157, 0.223529, 0.160784, 0.160784, \
0.223529, 
0.290196, 0.388235, 0.388235, 0.45098, 0.517647, 0.678431, 0.776471, \
0.709804, 
0.647059, 0.54902, 0.419608, 0.352941, 0.290196, 0.258824, 0.223529, \
0.223529, 
0.192157, 0.160784, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0313725, 0.0627451, 0.0627451, 
0.0941176, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 
0.160784, 0.290196, 0.352941, 0.352941, 0.290196, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.580392, \
0.45098, 
0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.419608, \
0.388235, 
0.352941, 0.321569, 0.321569, 0.321569, 0.290196, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.517647, 0.321569, \
0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 
0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.160784, 0.160784, 0.192157, 0.160784, 0.192157, \
0.223529, 
0.290196, 0.321569, 0.388235, 0.388235, 0.388235, 0.54902, 0.647059, \
0.611765, 
0.54902, 0.45098, 0.352941, 0.321569, 0.290196, 0.258824, 0.223529, 0.192157, \

0.160784, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.160784, 0.258824, 0.192157, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.192157, 0.290196, 0.388235, 0.388235, 0.290196, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.54902, \
0.419608, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.258824, 0.223529, \
0.223529, 
0.258824, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.647059, 0.647059, 0.647059, 0.611765, 0.54902, 0.352941, \
0.160784, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.223529, 0.352941, 0.352941, 0.223529, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.192157, \
0.223529, 
0.290196, 0.258824, 0.321569, 0.290196, 0.258824, 0.388235, 0.482353, \
0.482353, 
0.45098, 0.352941, 0.321569, 0.290196, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 0.223529, 
0.321569, 0.290196, 0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 
0.290196, 0.388235, 0.419608, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.517647, 0.388235, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.388235, 0.388235, 0.388235, 0.321569, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.290196, 0.223529, 0.223529, 0.223529, \
0.258824, 
0.258824, 0.258824, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.352941},
{0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.419608, \
0.160784, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.192157, 0.290196, 0.290196, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.129412, 0.160784, 0.0941176, 0.160784, 0.192157, 0.192157, 0.160784, \
0.192157, 
0.258824, 0.290196, 0.290196, 0.223529, 0.192157, 0.290196, 0.419608, \
0.419608, 
0.388235, 0.321569, 0.290196, 0.290196, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 0.223529, 
0.352941, 0.321569, 0.129412, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 
0.321569, 0.419608, 0.419608, 0.352941, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.611765, 0.482353, 0.388235, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.321569, 0.352941, 0.388235, 0.419608, 0.388235, 0.321569, \
0.290196, 
0.321569, 0.321569, 0.290196, 0.258824, 0.223529, 0.223529, 0.223529, \
0.258824, 
0.258824, 0.258824, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.388235},
{0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.839216, 0.839216, \
0.776471, 
0.776471, 0.741176, 0.709804, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.678431, 0.647059, 0.580392, 0.45098, \
0.192157, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.192157, 0.223529, 0.223529, 0.160784, 
0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.129412, 0.192157, 0.160784, 0.129412, \
0.223529, 
0.223529, 0.258824, 0.258824, 0.192157, 0.192157, 0.290196, 0.352941, \
0.388235, 
0.352941, 0.290196, 0.258824, 0.258824, 0.258824, 0.223529, 0.192157, \
0.160784, 
0.160784, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, \
0.129412, 
0.129412, 0.129412, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0313725, 0.0627451, 0.160784, 
0.223529, 0.192157, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.192157, 
0.321569, 0.388235, 0.419608, 0.352941, 0.321569, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.580392, 0.45098, 0.352941, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.419608, 0.388235, 0.352941, 0.290196, \
0.290196, 
0.321569, 0.290196, 0.258824, 0.258824, 0.223529, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.388235, 0.419608},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.776471, 0.839216, 0.839216, \
0.807843, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.678431, 0.647059, 0.580392, 0.482353, \
0.223529, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.160784, 0.192157, 0.192157, 0.160784, 
0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.0941176, 0.0941176, 0.129412, 0.192157, 0.160784, 0.160784, 
0.192157, 0.223529, 0.223529, 0.223529, 0.192157, 0.192157, 0.258824, \
0.352941, 
0.352941, 0.321569, 0.290196, 0.258824, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.192157, 0.192157, \
0.160784, 
0.129412, 0.129412, 0.160784, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.129412, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.192157, 0.321569, 0.388235, 0.419608, 0.388235, 0.321569, 0.290196, \
0.258824, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.54902, 0.419608, \
0.352941, 
0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.388235, 0.388235, 0.352941, 0.321569, \
0.290196, 
0.290196, 0.321569, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608},
{0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.776471, 0.807843, 0.839216, \
0.839216, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.678431, 0.647059, 0.611765, 0.517647, \
0.290196, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.192157, 0.160784, 0.160784, 
0.192157, 0.192157, 0.223529, 0.192157, 0.129412, 0.160784, 0.258824, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.160784, 0.160784, 0.160784, 0.160784, 0.192157, 0.192157, 0.192157, \
0.129412, 
0.129412, 0.129412, 0.160784, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 
0.223529, 0.321569, 0.388235, 0.419608, 0.388235, 0.352941, 0.290196, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.517647, 0.419608, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.388235, 0.388235, 0.321569, 0.290196, \
0.290196, 
0.321569, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608},
{0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.839216, \
0.839216, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.678431, 0.647059, 0.611765, 0.54902, \
0.321569, 
0.129412, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.192157, 0.160784, 0.129412, 
0.160784, 0.192157, 0.290196, 0.223529, 0.160784, 0.129412, 0.223529, \
0.290196, 
0.258824, 0.223529, 0.258824, 0.223529, 0.223529, 0.223529, 0.192157, \
0.160784, 
0.160784, 0.160784, 0.192157, 0.192157, 0.192157, 0.160784, 0.160784, \
0.129412, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.160784, 
0.258824, 0.321569, 0.388235, 0.419608, 0.388235, 0.388235, 0.321569, \
0.290196, 
0.258824, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.482353, 0.388235, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608},
{0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.54902, \
0.352941, 
0.160784, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.223529, 0.129412, 0.0941176, 
0.129412, 0.192157, 0.352941, 0.321569, 0.223529, 0.160784, 0.192157, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.223529, 0.192157, 0.192157, 0.160784, \
0.160784, 
0.160784, 0.192157, 0.192157, 0.192157, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.160784, 
0.258824, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.290196, 
0.258824, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.54902, 0.45098, 0.352941, 0.321569, \

0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608},
{0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.580392, \
0.388235, 
0.192157, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.160784, 0.223529, 0.129412, 0.0941176, 
0.129412, 0.192157, 0.352941, 0.419608, 0.290196, 0.192157, 0.192157, \
0.223529, 
0.258824, 0.223529, 0.192157, 0.192157, 0.192157, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.192157, 0.192157, 0.192157, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.0941176, 0.129412, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.160784, 
0.290196, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.290196, 
0.258824, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \

0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.482353, 0.388235, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.321569, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608},
{0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, \
0.419608, 
0.192157, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.192157, 0.223529, 0.129412, 0.129412, 
0.0941176, 0.129412, 0.321569, 0.388235, 0.321569, 0.223529, 0.192157, \
0.192157, 
0.223529, 0.223529, 0.192157, 0.192157, 0.192157, 0.160784, 0.160784, \
0.160784, 
0.192157, 0.192157, 0.192157, 0.192157, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.192157, 0.290196, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.45098, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.647059, 0.647059, 0.611765, \
0.45098, 
0.192157, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.192157, 0.223529, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.258824, 0.352941, 0.290196, 0.223529, 0.160784, 
0.160784, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.223529, 0.223529, 0.192157, 0.160784, 0.160784, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.192157, 
0.321569, 0.388235, 0.388235, 0.352941, 0.352941, 0.419608, 0.388235, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \

0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.580392, 0.45098, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.905882, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, \
0.482353, 
0.258824, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.192157, 0.192157, 0.129412, 
0.0941176, 0.0941176, 0.129412, 0.223529, 0.192157, 0.160784, 0.160784, 
0.160784, 0.192157, 0.223529, 0.258824, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.258824, 0.258824, 0.223529, 0.192157, 0.160784, 0.160784, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.223529, 0.321569, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.321569, 0.290196, 0.290196, 0.290196, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.517647, 0.388235, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.258824, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.580392, 0.580392, 
0.54902, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.419608, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.905882, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.517647, 
0.258824, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.192157, 0.192157, 0.129412, 
0.0627451, 0.0941176, 0.0941176, 0.160784, 0.160784, 0.160784, 0.160784, 
0.160784, 0.160784, 0.192157, 0.258824, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.192157, 0.160784, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.223529, 0.321569, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.352941, 0.321569, 0.290196, 0.290196, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.647059, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.611765, 0.482353, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.54902, 0.580392, 0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.905882, 0.905882, 0.870588, 0.839216, \
0.870588, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.611765, \
0.517647, 
0.290196, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 0.160784, 0.129412, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.129412, 0.160784, 0.160784, 
0.129412, 0.129412, 0.160784, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.192157, 0.192157, 0.160784, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 
0.258824, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.352941, 0.321569, 0.321569, 0.290196, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.54902, 0.419608, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.580392, 0.647059, 
0.611765, 0.580392, 0.517647, 0.517647, 0.482353, 0.45098, 0.45098, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.937255, \
0.937255, 
0.937255, 0.905882, 0.905882, 0.905882, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.611765, \
0.54902, 
0.321569, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.160784, 0.160784, 
0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.129412, 0.0941176, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.160784, 0.258824, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.580392, 0.482353, 0.388235, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.223529, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.580392, 
0.647059, 0.647059, 0.611765, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.937255, \
0.937255, 
0.937255, 0.905882, 0.905882, 0.905882, 0.870588, 0.870588, 0.839216, \
0.870588, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.611765, \
0.54902, 
0.321569, 0.129412, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.129412, 0.129412, 0.129412, 0.129412, 
0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 
0.160784, 0.129412, 0.129412, 0.0941176, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.192157, 
0.290196, 0.388235, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.45098, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.54902, 0.611765, 
0.647059, 0.611765, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.870588, 0.905882, 0.937255, 0.937255, 0.937255, 0.937255, \
0.937255, 
0.937255, 0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.839216, \
0.870588, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.54902, 
0.321569, 0.129412, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.160784, 
0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.223529, 
0.321569, 0.388235, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.517647, 0.388235, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, \
0.321569, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.54902, 0.611765, 
0.647059, 0.647059, 0.580392, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 0.968627, \
0.968627, 
0.968627, 0.937255, 0.905882, 0.905882, 0.905882, 0.870588, 0.839216, \
0.870588, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.741176, 0.709804, 0.678431, 0.678431, 0.647059, \
0.54902, 
0.321569, 0.129412, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.160784, 
0.160784, 0.129412, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.129412, 0.129412, 0.0941176, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.160784, 0.258824, 
0.321569, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.352941, 0.388235, 0.388235, 0.388235, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.580392, 0.45098, 0.352941, 0.321569, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.580392, 
0.611765, 0.647059, 0.611765, 0.54902, 0.482353, 0.482353, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.419608},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 0.968627, \
0.968627, 
0.968627, 0.937255, 0.937255, 0.905882, 0.905882, 0.870588, 0.870588, \
0.870588, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.741176, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.321569, 0.0941176, 0.0627451, 0.0313725, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.160784, 
0.160784, 0.129412, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.192157, 0.258824, 0.321569, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.352941, 0.388235, 0.419608, 0.388235, 0.352941, \
0.321569, 
0.321569, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.54902, 0.419608, 0.321569, 0.290196, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.54902, 0.580392, 0.611765, 0.647059, 0.580392, 0.517647, \
0.482353, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.419608},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.905882, 
0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 1, 1, 1, 0.968627, \
0.968627, 
0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.129412, 0.160784, 0.160784, 0.129412, 0.129412, 
0.0941176, 0.0941176, 0.129412, 0.129412, 0.0941176, 0.129412, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 0.290196, 
0.352941, 0.388235, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.54902, \

0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.647059, 0.611765, 0.611765, 0.611765, \
0.678431, 
0.611765, 0.482353, 0.388235, 0.321569, 0.321569, 0.321569, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.419608, 0.45098, 0.482353, 0.482353, 0.517647, \

0.54902, 0.611765, 0.647059, 0.611765, 0.54902, 0.482353, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.388235, 0.419608, 0.419608},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, \
0.905882, 
0.937255, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 0.968627, 0.968627, 
0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.160784, 0.192157, 0.160784, 0.129412, 0.0941176, 
0.0627451, 0.0627451, 0.0941176, 0.129412, 0.0941176, 0.129412, 0.129412, 
0.0941176, 0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.160784, 0.223529, 0.321569, 
0.352941, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.580392, 0.45098, 0.352941, 0.321569, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.258824, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.580392, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 
0.419608, 0.388235, 0.419608, 0.419608},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.905882, \
0.905882, 
0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 
0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.352941, 0.160784, \
0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.160784, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.258824, 0.352941, 0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.482353, 
0.388235, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.54902, 0.611765, 0.580392, 0.580392, 0.517647, 0.482353, 0.482353, 0.45098, \

0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \

0.419608, 0.388235, 0.419608},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, \
0.937255, 
0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, \
0.905882, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, \
0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.192157, 
0.223529, 0.160784, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.129412, 0.192157, 0.290196, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.647059, 0.611765, 0.54902, 0.419608, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.517647, 0.580392, 0.580392, 
0.580392, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.419608},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, \
0.937255, 
0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.352941, 0.160784, 0.0941176, 0.0627451, \
0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.160784, 
0.258824, 0.192157, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.258824, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.482353, 0.388235, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 
0.580392, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.419608},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 
0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.580392, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.160784, 
0.258824, 0.192157, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.160784, 0.290196, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.45098, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 
0.580392, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608},
{0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.937255, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.580392, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.129412, 0.223529, 
0.192157, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 
0.258824, 0.419608, 0.352941, 0.160784, 0.0313725, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.192157, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 
0.54902, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608},
{0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.580392, 0.482353, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.223529, 
0.192157, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0941176, 
0.419608, 0.741176, 0.709804, 0.352941, 0.0313725, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.129412, 0.223529, 
0.321569, 0.388235, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.352941, \
0.321569, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.54902, 0.419608, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.290196, 0.258824, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.517647, 0.517647, 0.54902, 
0.54902, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608},
{0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.905882, 0.937255, 0.937255, 0.968627, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 
0.839216, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.611765, 0.54902, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0627451, \
0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.129412, 0.192157, 
0.160784, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.129412, 
0.517647, 0.905882, 0.839216, 0.388235, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.192157, 0.258824, 
0.321569, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.580392, 
0.45098, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608},
{0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 
0.839216, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.54902, 0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, \
0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.129412, 0.192157, 
0.192157, 0.160784, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0941176, 
0.388235, 0.709804, 0.647059, 0.321569, 0.129412, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.129412, 0.223529, 0.290196, 
0.352941, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.517647, 
0.419608, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.388235, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 
0.839216, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.54902, 0.54902, 0.482353, 0.388235, 0.223529, 0.0941176, \
0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0941176, 0.160784, 
0.192157, 0.192157, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.192157, 0.352941, 0.321569, 0.192157, 0.160784, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.160784, 0.258824, 0.352941, 
0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.54902, 0.45098, \

0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.741176, 0.741176, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.54902, 0.517647, 0.517647, 0.45098, 0.290196, 0.129412, \
0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.129412, 0.192157, 0.192157, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.223529, 0.290196, 0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.611765, 0.611765, 0.647059, 0.580392, 0.482353, \
0.388235, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.54902, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, \

0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.741176, 0.741176, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.54902, 0.482353, 0.54902, 0.517647, 0.388235, 0.192157, \
0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.129412, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.160784, 0.129412, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0941176, 0.129412, 0.258824, 0.321569, 0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.54902, 0.419608, \
0.321569, 
0.290196, 0.321569, 0.321569, 0.321569, 0.290196, 0.290196, 0.321569, \
0.352941, 
0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.517647, 0.54902, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.905882, 0.870588, \

0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.517647, 0.482353, 0.54902, 0.54902, 0.45098, 0.290196, 0.129412, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.192157, 0.321569, 0.352941, 0.388235, 0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.388235, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.482353, 0.388235, 0.290196, \
0.290196, 
0.321569, 0.290196, 0.290196, 0.290196, 0.321569, 0.352941, 0.352941, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.905882, 
0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.580392, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \
0.388235, 
0.192157, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0941176, \
0.160784, 
0.129412, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.129412, 0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.160784, 0.223529, 0.352941, 0.352941, 0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.611765, 0.611765, 0.580392, 0.517647, 0.419608, 0.352941, \
0.290196, 
0.321569, 0.321569, 0.290196, 0.290196, 0.321569, 0.352941, 0.388235, \
0.352941, 
0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.905882, 
0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.709804, 
0.678431, 0.580392, 0.517647, 0.517647, 0.482353, 0.517647, 0.54902, 0.45098, \

0.258824, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.129412, 0.223529, 
0.290196, 0.223529, 0.0941176, 0.0313725, 0.0627451, 0.0941176, 0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.192157, 0.290196, 0.388235, 0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.580392, 0.482353, 0.352941, \
0.321569, 
0.290196, 0.321569, 0.321569, 0.290196, 0.290196, 0.352941, 0.388235, \
0.388235, 
0.352941, 0.290196, 0.258824, 0.290196, 0.290196, 0.290196, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.580392, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.517647, 
0.388235, 0.192157, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0, 0.0313725, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.192157, 0.258824, \

0.192157, 0.0627451, 0.0313725, 0.0313725, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0941176, 0.129412, 0.223529, 0.352941, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.388235, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.482353, 0.388235, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.352941, 0.388235, 0.352941, 0.321569, \
0.290196, 
0.258824, 0.258824, 0.290196, 0.321569, 0.321569, 0.290196, 0.290196, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.937255, 0.937255, 0.905882, \

0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.580392, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.517647, 0.45098, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0.0627451, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, \

0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.129412, 0.192157, 
0.290196, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, \
0.517647, 
0.419608, 0.352941, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.352941, 0.321569, 0.290196, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, \
0.258824, 
0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, \
0.968627, 
1, 0.968627, 0.968627, 1, 1, 0.968627, 0.968627, 0.968627, 0.937255, \
0.937255, 
0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.611765, 0.580392, 0.517647, 0.517647, \
0.54902, 
0.517647, 0.54902, 0.54902, 0.517647, 0.352941, 0.223529, 0.0627451, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, \
0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 0, 0, 0, 0, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.258824, 0.352941, 0.388235, 
0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.580392, 0.580392, 0.611765, 0.54902, 0.419608, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.968627, \
0.968627, 
0.968627, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.905882, 0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, \
0.870588, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.580392, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.580392, 0.482353, 0.321569, 
0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0, 0, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 
0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.129412, 0.223529, 0.321569, 0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 0.352941, 0.290196, \

0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.905882, 0.937255, 0.937255, 0.968627, \
0.968627, 
0.968627, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, 0.937255, \
0.937255, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.580392, 0.54902, 0.419608, 
0.223529, 0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0941176, 0.160784, 0.290196, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.352941, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.611765, \
0.580392, 
0.54902, 0.45098, 0.388235, 0.321569, 0.290196, 0.290196, 0.321569, 0.321569, \

0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.290196, 
0.258824, 0.290196, 0.290196, 0.321569, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.937255, 0.937255, \
0.937255, 
0.937255, 0.937255, 0.968627, 0.968627, 0.968627, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.580392, 0.54902, 0.517647, 
0.352941, 0.223529, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.129412, 0.223529, 0.321569, 0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.580392, 0.482353, 0.388235, 0.321569, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.290196, 0.258824, 0.290196, 0.290196, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.937255, \
0.937255, 
0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.905882, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.54902, 0.54902, \

0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.482353, 0.321569, 0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 0.192157, 0.290196, 
0.352941, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.517647, 0.388235, \
0.321569, 
0.290196, 0.290196, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.352941, 0.352941, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, \
0.937255, 
0.905882, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.905882, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.54902, 0.54902, \

0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.580392, 
0.580392, 0.419608, 0.223529, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0941176, 0.160784, 0.258824, 0.352941, 0.388235, 0.352941, 
0.352941, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.419608, 0.321569, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.807843, 0.807843, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.647059, 0.611765, 0.580392, 0.54902, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.517647, 0.388235, 0.192157, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.129412, 0.223529, 0.352941, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, \

0.517647, 0.45098, 0.352941, 0.290196, 0.290196, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.807843, 0.807843, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.482353, 0.352941, 0.192157, 0.0627451, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.129412, 0.192157, 
0.290196, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.517647, 0.45098, 0.352941, \

0.321569, 0.290196, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.905882, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.807843, 0.807843, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.580392, \
0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.580392, 0.580392, 0.482353, 0.321569, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.160784, 0.290196, 
0.352941, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.580392, 0.580392, 0.54902, 0.54902, 0.517647, 0.45098, 0.352941, 0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, \
0.321569, 
0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.905882, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, 0.54902, 0.54902, \

0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.54902, 0.580392, 0.54902, 0.419608, 0.223529, 0.0941176, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.160784, 0.223529, 0.352941, 0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.482353, 0.45098, 0.352941, 0.290196, 0.352941, 0.352941, \

0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.258824, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.352941, 0.160784, 0.0627451, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.0941176, 0.129412, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.129412, 0.223529, 0.290196, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.482353, 
0.419608, 0.388235, 0.321569, 0.321569, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.290196, 0.258824, 0.290196, 0.290196, \
0.321569, 
0.290196, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.45098},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.647059, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.580392, 0.482353, 0.290196, 0.129412, \

0.0627451, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0941176, 0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.129412, \
0.129412, 
0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.192157, 0.290196, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.482353, 0.419608, 0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.352941, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.321569, 0.290196, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.45098},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.611765, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.54902, 0.580392, 0.54902, 0.419608, 0.290196, 
0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0941176, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.160784, 0.290196, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.45098, 0.419608, 0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.388235, 0.321569, 0.290196, 0.258824, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353},
{0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.611765, 0.54902, 0.517647, 0.517647, 0.54902, \

0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.45098, 
0.223529, 0.129412, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0941176, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.192157, 0.192157, 0.160784, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.160784, 0.258824, 0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.352941, 0.352941, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.352941, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.482353, 0.482353, 0.419608, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.352941, \
0.388235, 
0.321569, 0.290196, 0.258824, 0.290196, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.482353},
{0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.678431, 0.709804, \
0.709804, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.647059, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.388235, 0.258824, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.129412, 0.160784, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.192157, \
0.192157, 
0.160784, 0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.129412, 0.258824, 0.352941, 0.388235, 
0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.482353, 0.45098, \

0.419608, 0.419608, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.258824, 0.258824, 0.290196, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.388235, \
0.388235, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.611765, 0.54902, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 
0.517647, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.129412, 
0.160784, 0.192157, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.0941176, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.192157, \
0.192157, 
0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0941176, 0.129412, 0.223529, 0.352941, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.419608, 0.388235, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.352941, 0.388235, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.580392, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.54902, 
0.580392, 0.54902, 0.45098, 0.290196, 0.129412, 0.0627451, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.129412, 0.192157, 0.223529, 
0.223529, 0.192157, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.160784, 
0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.192157, 0.192157, \
0.160784, 
0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.160784, 0.258824, 
0.352941, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, \

0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.290196, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.352941, 0.388235, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.647059, 0.54902, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.580392, 0.580392, 0.419608, 0.223529, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.129412, 0.160784, 0.192157, 
0.223529, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.192157, \
0.192157, 
0.192157, 0.160784, 0.129412, 0.0941176, 0.129412, 0.160784, 0.258824, \
0.321569, 
0.419608, 0.419608, 0.388235, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.321569, 0.290196, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, \
0.54902},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.678431, 0.580392, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.45098, 0.517647, 0.54902, 0.517647, 0.388235, 0.192157, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, \
0.0627451, 
0.0941176, 0.129412, 0.160784, 0.192157, 0.223529, 0.192157, 0.192157, \
0.160784, 
0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, \
0.192157, 
0.192157, 0.160784, 0.160784, 0.160784, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.160784, 0.192157, 0.258824, 0.352941, 0.419608, 0.45098, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.388235, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, \

0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.321569, 0.290196, 0.258824, 0.258824, 0.290196, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.192157, 0.192157, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.352941, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.517647, 0.517647, 0.517647, 0.54902, 0.54902},
{0.678431, 0.678431, 0.709804, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.647059, 0.54902, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.54902, 0.517647, 0.388235, 0.192157, \
0.0941176, 
0.0627451, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.129412, 0.160784, 0.223529, 0.223529, 0.223529, 0.192157, 0.192157, \
0.160784, 
0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, \
0.192157, 
0.192157, 0.192157, 0.192157, 0.160784, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.160784, 0.192157, 0.258824, 0.388235, 0.419608, 0.45098, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.321569, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.352941, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.611765, 0.482353, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.45098, 0.517647, 0.54902, 0.482353, 0.352941, 0.258824, \

0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.129412, 0.160784, 0.192157, 0.223529, 0.223529, 0.192157, 0.192157, \
0.192157, 
0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.0941176, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.192157, 0.192157, 0.192157, 0.192157, 0.192157, 0.192157, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.192157, 0.192157, 0.290196, 0.352941, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.352941, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.321569, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.258824, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.580392, 0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.482353, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.419608, 
0.258824, 0.160784, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.129412, 
0.160784, 0.192157, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.192157, 0.192157, 0.192157, 0.192157, 0.192157, 0.192157, 0.192157, \
0.192157, 
0.223529, 0.223529, 0.192157, 0.160784, 0.160784, 0.258824, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.321569, 
0.352941, 0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.321569, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, 0.192157, \
0.192157, 
0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.321569, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.709804, 0.741176, 0.741176, 0.678431, \
0.580392, 
0.517647, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.517647, 
0.45098, 0.352941, 0.192157, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0941176, 0.129412, 0.192157, 0.223529, 
0.258824, 0.258824, 0.223529, 0.192157, 0.192157, 0.192157, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.192157, 0.192157, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, \
0.192157, 
0.223529, 0.223529, 0.258824, 0.192157, 0.192157, 0.223529, 0.321569, \
0.419608, 
0.45098, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.321569, 0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.709804, 0.741176, 0.741176, 0.678431, \
0.54902, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.517647, 0.482353, 0.388235, 0.223529, 0.0941176, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.160784, 0.192157, 0.223529, 
0.258824, 0.258824, 0.223529, 0.223529, 0.192157, 0.192157, 0.192157, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.192157, 0.192157, 0.192157, 0.192157, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.192157, 0.192157, \
0.258824, 
0.352941, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.321569, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.192157, 0.192157, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.741176, 0.709804, 0.611765, \
0.517647, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 
0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 
0.482353, 0.517647, 0.517647, 0.388235, 0.258824, 0.129412, 0.0627451, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.129412, 0.223529, 0.258824, 0.258824, 0.258824, 
0.223529, 0.223529, 0.192157, 0.192157, 0.192157, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.192157, 0.192157, 0.223529, 0.223529, 0.258824, 0.258824, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.258824, 0.223529, 0.160784, 0.192157, \
0.258824, 
0.352941, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.290196, 0.290196, 0.258824, 0.258824, 0.258824, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.580392, \
0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.419608, 0.290196, 0.160784, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.160784, 0.192157, 0.223529, 0.258824, 0.223529, 0.223529, \
0.223529, 
0.192157, 0.192157, 0.192157, 0.192157, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.160784, 0.192157, 0.192157, 0.160784, \
0.160784, 
0.192157, 0.192157, 0.223529, 0.223529, 0.258824, 0.258824, 0.223529, \
0.223529, 
0.223529, 0.258824, 0.290196, 0.258824, 0.192157, 0.192157, 0.223529, \
0.290196, 
0.352941, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.321569, \
0.290196, 
0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.647059, 0.517647, \
0.419608, 
0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.419608, 0.290196, 0.223529, 
0.129412, 0.0627451, 0.0313725, 0, 0.0313725, 0.0627451, 0.0941176, 0.129412, \

0.223529, 0.223529, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, \
0.192157, 
0.192157, 0.192157, 0.160784, 0.160784, 0.160784, 0.160784, 0.129412, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.160784, 0.160784, 0.192157, 0.192157, 0.192157, 0.192157, \
0.192157, 
0.192157, 0.223529, 0.223529, 0.223529, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.223529, 0.223529, 0.258824, 0.258824, 0.223529, 0.192157, 0.192157, \
0.290196, 
0.352941, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.352941, \
0.388235, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, \
0.352941, 
0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.321569, 0.290196, \
0.258824, 
0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.290196, 
0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.678431, 0.580392, 0.482353, \
0.388235, 
0.388235, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.258824, 0.192157, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.160784, 
0.223529, 0.223529, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.223529, 
0.192157, 0.192157, 0.192157, 0.160784, 0.160784, 0.160784, 0.160784, \
0.129412, 
0.129412, 0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.192157, 0.192157, 0.192157, \
0.223529, 
0.192157, 0.192157, 0.223529, 0.223529, 0.223529, 0.290196, 0.290196, \
0.290196, 
0.258824, 0.223529, 0.192157, 0.258824, 0.258824, 0.258824, 0.192157, \
0.192157, 
0.223529, 0.290196, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.321569, 
0.321569, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.321569, 0.352941, 0.352941, 0.321569, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, \
0.258824, 
0.290196, 0.290196, 0.290196, 0.290196, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.517647, 0.517647, 0.54902, 0.54902},
{0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.611765, 0.517647, 0.419608, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, \
0.517647, 
0.388235, 0.321569, 0.223529, 0.160784, 0.129412, 0.160784, 0.223529, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.223529, \
0.192157, 
0.192157, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, \
0.129412, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, \
0.160784, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.192157, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.192157, 0.192157, 0.223529, 0.258824, 0.290196, 0.321569, 0.290196, \
0.290196, 
0.258824, 0.258824, 0.258824, 0.258824, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.321569, 0.352941, 0.419608, 0.45098, 0.419608, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.290196, 0.352941, 0.352941, 0.321569, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.678431, 0.54902, 0.45098, 0.388235, 0.388235, \

0.388235, 0.388235, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, \
0.388235, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.482353, 0.45098, 0.388235, 0.290196, 0.258824, 0.223529, 0.223529, \
0.258824, 
0.258824, 0.290196, 0.290196, 0.258824, 0.223529, 0.192157, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.160784, 0.160784, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.129412, \
0.129412, 
0.129412, 0.129412, 0.129412, 0.129412, 0.129412, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, 0.160784, \
0.160784, 
0.160784, 0.160784, 0.160784, 0.192157, 0.223529, 0.258824, 0.258824, \
0.223529, 
0.192157, 0.192157, 0.223529, 0.223529, 0.290196, 0.321569, 0.352941, \
0.388235, 
0.321569, 0.290196, 0.258824, 0.258824, 0.258824, 0.258824, 0.223529, \
0.192157, 
0.192157, 0.290196, 0.388235, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.388235, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.290196, 0.352941, 0.352941, 0.321569, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.223529, 0.223529, 0.223529, 0.223529, 0.192157, 0.192157, 0.223529, \
0.223529, 
0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.223529, 0.258824, \
0.258824, 
0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.258824, 0.290196, \
0.290196, 
0.290196, 0.290196, 0.321569, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.321569, 0.321569, 0.352941, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 
0.580392, 0.580392},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.678431, 0.580392, 0.482353, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.388235