(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    617905,      11484]*)
(*NotebookOutlinePosition[    618594,      11508]*)
(*  CellTagsIndexPosition[    618550,      11504]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(\(\n\)\(\(<< \ LinearAlgebra`MatrixManipulation`;\)\(\n\)
    \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ \ Correlation\)], "Input"],

Cell["\<\
corRelation=
\tCompile[{{vectorA,_Real,1},{vectorB,_Real,1}},
\t\tModule[{meanA=0.,meanB=0.,normA=0.,normB=0.,
\t\t\t\tvectorAprime={0.},vectorBprime={0.}},
\t\t\tmeanA=Apply[Plus,vectorA]/Length[vectorA];
\t\t\tmeanB=Apply[Plus,vectorB]/Length[vectorB];
\t\t\tvectorAprime=vectorA-meanA;
\t\t\tnormA=Sqrt[vectorAprime.vectorAprime];
\t\t\tvectorBprime=vectorB-meanB;
\t\t\tnormB=Sqrt[vectorBprime.vectorBprime];
\t\t\tvectorAprime.vectorBprime/(normA normB)]];\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ \ Sample\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell["\<\
sample={
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.517647, 0.54902, 0.45098},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.388235, \
0.258824},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.419608, 0.352941, 0.192157, \
0.0941176},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.419608, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, \
0.482353, 
0.54902, 0.54902, 0.482353, 0.388235, 0.223529, 0.129412, 0, 0},
{0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.54902, 
0.517647, 0.419608, 0.290196, 0.160784, 0.0627451, 0.0313725, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.482353, 0.482353, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.45098, 
0.352941, 0.223529, 0.0941176, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, \

0.129412, 0.0313725, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.54902, 0.54902, 0.482353, 0.388235, 0.258824, 0.129412, \

0.0313725, 0, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.45098, 0.321569, 0.192157, 0.0941176, 0.0313725, \

0, 0, 0, 0, 0, 0, 0, 0},
{0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.482353, 0.419608, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.388235, 0.45098, 0.517647, 0.517647, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.45098, 
0.352941, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.45098, \

0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 0.388235, 0.290196, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \

0.517647, 0.54902, 0.580392, 0.54902, 0.45098, 0.352941, 0.192157, 0.129412, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.517647, 
0.54902, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.580392, 0.580392, 0.45098, 0.321569, 0.192157, 0.0941176, 0, 0, 0, \
0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.482353, 0.290196, 0.160784, 0.0627451, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.54902, \

0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.45098, 0.290196, 0.129412, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.45098, 
0.290196, 0.160784, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725},
{0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.517647, 0.482353, 0.54902, 
0.54902, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 
0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.482353, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, 0.160784, 
0.0627451, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0.0313725, 
0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.482353, 0.45098, 0.388235, 0.352941, 0.419608, 0.517647, 0.580392, \
0.611765, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, 0.0627451, \

0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.482353, 0.419608, 0.388235, 0.482353, 0.580392, 0.647059, \
0.647059, 
0.611765, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.54902, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.54902, \

0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.517647, 0.580392, 0.678431, 0.709804, \
0.807843, 
0.741176, 0.611765, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.482353, 0.321569, 0.192157, 0.0941176, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.611765, 0.709804, 0.776471, \
0.870588, 
0.807843, 0.678431, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.419608, 0.388235, 0.352941, 0.352941, 0.321569, \

0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.482353, 0.647059, 0.776471, 0.807843, \
0.807843, 
0.709804, 0.611765, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, \

0.54902, 0.45098, 0.419608, 0.45098, 0.517647, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.517647, 0.419608, 0.258824, 0.129412, 0.0313725, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, \
0.482353, 
0.419608, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.258824, 0.45098, 0.709804, 0.870588, 0.905882, \
0.807843, 
0.678431, 0.647059, 0.647059, 0.647059, 0.709804, 0.807843, 0.776471, \
0.678431, 
0.517647, 0.388235, 0.388235, 0.517647, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.45098, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.321569, 0.45098, 0.611765, 0.807843, 0.905882, 0.839216, \
0.678431, 
0.580392, 0.647059, 0.709804, 0.741176, 0.776471, 0.807843, 0.741176, \
0.647059, 
0.517647, 0.482353, 0.517647, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 
0.290196, 0.160784, 0.0627451, 0, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.388235, 0.388235, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.517647, 0.678431, 0.807843, 0.870588, 0.870588, 0.709804, \
0.54902, 
0.482353, 0.580392, 0.709804, 0.741176, 0.709804, 0.678431, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 0.352941, \

0.192157, 0.0941176, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.54902, 0.678431, 0.776471, 0.870588, 0.839216, 0.807843, 0.611765, \
0.482353, 
0.419608, 0.45098, 0.54902, 0.580392, 0.580392, 0.611765, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.482353, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.611765, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.647059, \
0.54902, 
0.45098, 0.419608, 0.419608, 0.419608, 0.517647, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.517647, 0.388235, 0.258824, \
0.160784, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.54902, 0.482353, 0.45098, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.647059, \

0.647059, 0.647059, 0.611765, 0.647059, 0.678431, 0.741176, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.45098, 0.419608, 0.482353, 0.54902, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, \
0.0627451, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.580392, \
0.611765, 
0.647059, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.482353, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, \

0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.709804, 0.678431, 0.678431, 0.647059, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.54902, \
0.580392, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.54902, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, \

0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.482353, 0.54902, \

0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.482353, 0.290196, 0.129412, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, \

0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.54902, \
0.517647, 
0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.352941, 0.192157, 0.0627451, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.580392, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.54902, 0.388235, 0.258824, 0.129412, 0.0313725, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.580392, \

0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.517647, 0.517647, 0.580392, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.580392, 
0.45098, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.517647, 0.54902, 0.647059, 0.678431, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.517647, 
0.352941, 0.192157, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, \
0.45098, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.611765, 0.54902, 0.517647, 0.580392, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.54902, \
0.419608, 
0.258824, 0.129412, 0.0627451, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.709804, 
0.678431, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.482353, \
0.321569, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.580392, 0.54902, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.517647, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.678431, 0.678431, 0.611765, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.580392, 0.611765, 0.647059, 0.647059, 0.54902, 0.45098, 0.258824, 0.160784, \

0.0627451, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.580392, 0.580392, 0.580392, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.678431, 0.647059, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.580392, 0.388235, 0.258824, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.647059, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.482353, 0.321569, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.419608, 0.258824, 0.160784, 0.129412, \
0.0941176, 
0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, \

0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.517647, 0.352941, 0.192157, 0.129412, 0.0941176, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.647059, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.45098, 0.290196, 0.160784, 0.0941176, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.678431, 0.647059, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.517647, 0.352941, 0.223529, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.647059, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.580392, 0.419608, 0.258824, 0.160784, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, 0.611765, \
0.580392, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.54902, 0.352941, 0.192157, 0.129412, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.482353, 0.321569, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.54902, 
0.419608, 0.258824, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.647059, \
0.517647, 
0.321569, 0.192157, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.611765, \
0.45098, 
0.258824, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.54902, \
0.388235, 
0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.45098, \
0.290196, 
0.160784, 0.160784, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.419608, \
0.258824, 
0.129412, 0.160784, 0.192157, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.611765, 0.580392, 0.54902, 0.54902, 0.517647, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.482353, 0.321569, \
0.192157, 
0.129412, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.45098, 0.290196, \
0.160784, 
0.0941176, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.223529, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.388235, 0.223529, \
0.129412, 
0.0941176, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.258824, 0.223529, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, \

0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0941176, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.129412, 
0.192157, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.45098, 0.290196, 0.160784, \
0.0941176, 
0.129412, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.419608, 0.258824, 0.129412, \
0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.517647, 0.388235, 0.223529, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.580392, 0.54902, 0.482353, 0.352941, 0.192157, 0.129412, 0.129412, \

0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.611765, \
0.54902, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.580392, 0.54902, 0.419608, 0.290196, 0.192157, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.54902, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, \
0.580392, 
0.54902, 0.517647, 0.517647, 0.482353, 0.517647, 0.54902, 0.517647, 0.517647, \

0.517647, 0.54902, 0.517647, 0.388235, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.482353, 0.352941, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.45098, 0.321569, 0.223529, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.388235, 0.258824, 0.160784, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.352941, 0.223529, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.580392, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.45098, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.482353, \

0.482353, 0.45098, 0.290196, 0.160784, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.611765, 0.611765, 0.54902, 0.517647, 0.45098, 0.45098, 
0.482353, 0.419608, 0.290196, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.45098, 0.45098, \

0.45098, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, \

0.419608, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.45098, 
0.419608, 0.352941, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.223529, 0.160784, 0.0941176, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.517647, 
0.419608, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.54902, 
0.45098, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.482353, 0.352941, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, \
0.580392, 
0.517647, 0.388235, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.54902, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.321569, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.54902, 0.388235, 0.160784, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.678431, \
0.611765, 
0.611765, 0.580392, 0.45098, 0.192157, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.611765, \
0.678431, 
0.647059, 0.580392, 0.482353, 0.258824, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.678431, 
0.647059, 0.611765, 0.517647, 0.290196, 0.129412, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.160784, 0.258824, 0.258824, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.419608, 0.192157, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.192157, 0.352941, 0.352941, 0.223529, 0.129412, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.45098, 0.258824, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.517647, 0.321569, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.223529, 0.352941, 0.352941, 0.223529, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.580392, 0.419608, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.192157, 0.290196, 0.290196, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.839216, 0.839216, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.45098, 0.192157, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.192157, 0.223529, 0.223529, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.839216, 0.839216, 0.807843, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.482353, 0.223529, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.160784, 0.192157, 0.192157, 0.160784, 0.129412, 0.0941176, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.517647, 0.290196, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.54902, 0.321569, 0.129412, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.580392, 0.388235, 0.192157, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.419608, 0.192157, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.647059, 0.611765, 0.45098, 0.192157, \
0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.482353, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.870588, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.517647, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.611765, 0.517647, 0.290196, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, \
0.870588, 
0.905882, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, \
0.937255, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, \
0.905882, 
0.905882, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, \
0.905882, 
0.937255, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.321569, \
0.0941176, 
0.0627451, 0.0313725, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, \
0.937255, 
0.937255, 0.968627, 0.968627, 1, 1, 1, 0.968627, 0.968627, 0.937255, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0313725, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, \
0.937255, 
0.968627, 0.968627, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0627451, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, \
0.968627, 
0.968627, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.905882, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.580392, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.482353, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.839216, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.611765, 
0.54902, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.482353, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.517647, 0.45098, 0.290196, 0.129412, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
0.968627, 
0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, 0.54902, \
0.482353, 
0.54902, 0.517647, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725}};\
\>", "Graphics",
  Evaluatable->True,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell["size=Dimensions[sample]", "Input"],

Cell[BoxData[
    \({128, 128}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SamplePhoto = 
      ListDensityPlot[sample, Mesh \[Rule] False, 
        AspectRatio \[Rule] size[\([1]\)]/size[\([2]\)], 
        PlotLabel \[Rule] "\<Sample Photo\>"]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sample) show
105.000 12.813 moveto
(Photo) show
135.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000LOol2
000QOol40003Ool2000POol30002Ool2000NOol30004Ool2000OOol20004Ool2000KOol50002Ool2
0004Ool2000GOol500000goo000000020003Ool2000COol001]oo`04001oogoo000POol00`00Oomo
o`03Ool01000Oomoo`0087oo00@007ooOol0009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo00@007ooOol0009oo`04001oogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0
009oo`03001oogoo01Ioo`05001oogooOol00005Ool01000Oomoo`004Woo000KOol01000Oomoo`00
8Goo00<007ooOol00Woo00@007ooOol001eoo`D00005Ool007ooOol0000MOol01000Oomoo`000Woo
00@007ooOol001eoo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001o
ogoo0002Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`004Woo000K
Ool01000Oomoo`008Woo00D007ooOomoo`00009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo0`000goo00@007ooOol001ioo`8000=oo`04001oogoo000LOol01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo01Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00
Oomoo`0@Ool001]oo`04001oogoo000POol01000Oomoo`000Woo00@007ooOol001ioo`03001oo`00
009oo`04001oogoo000NOol00`00Oomoo`02Ool01000Oomoo`007Goo00@007ooOol0009oo`04001o
ogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo01Ioo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol047oo000LOol2000ROol20004Ool2000POol20003Ool2
000OOol30003Ool2000OOol20004Ool2000LOol20004Ool20004Ool2000HOol20004Ool20004Ool2
000COol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Qoool0
00D000Aoo`0067oo00<007ooOol00Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo0P0017oo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool0015oo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@0
07ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@007ooOol000Aoo`<00?io
o`<000Aoo`0047oo00@007ooOol000Aoo`03001oogoo009oodHe[@@icPHe[@PicP03=JdaS36<008e
[C<icP8mka<icT4mk`=240Hmk`924096<@924096<@8icPEoo`03001oogoo009oo`0047oo00@007oo
Ool000Aoo`03001oogoo009oodHe[@@icPHe[@PicP03=JdaS36<008e[C<icP8mka<icT4mk`=240Hm
k`924096<@924096<@8icPEoo`03001oogoo009oo`004Goo0P001Goo00<007ooOol00WooD3F]1SW>
0cF]0S6<0SF]73W>0Sg_2CW>13F]43W>13g_1cW>BSg_1T8@0Sg_0S6<0R481Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Oom@=Jd6>Lh3=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl7>Li:?Nl6@Q02
?Nl2<H`28@P5Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooe0e[@@icP@e[@<aS08e[A`icP8m
k`TicP@e[A0icPHmk`<icP`mk`HicRlmk`A240<mk`Q2408e[@8]J`8HaP8<H`Eoo`03001oogoo009o
o`0067oo00<007ooOol00WooD3F]13W>13F]0c6<0SF]73W>0Sg_2CW>13F]43W>1Sg_0cW>33g_1SW>
;cg_148@0cg_248@0SF]0Re[0QS60PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Oolj=Jd2
>Lh8=Jd2>Lh:=Jd4>Lh4=Jd00c6<=Jde[@02=JdL>Lh2?Nl3>Lh2?Nl2>Lh4<H`2=Jd4?Nl8>LhC?Nl2
>LhW?Nl4@Q02?Nl4@Q06?Nl4@Q02?Nl00cW>?Nlmk`04AS42?Nl2<H`27>L248@40005Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oocXe[@8icPPe[@8icPXe[@@icP@e[@03<H`e[CF]008e[A`icP8m
k`<icP8mk`8icP@aS08e[@@mk`PicQ<mk`8icRLmk`A2408mk`A240Hmk`A2408mk`03>Lhmkcg_00A6
<@8mk`8aS08Li`8@Q0@000Eoo`03001oogoo009oo`0067oo0P000goo0SW>=3F]1SW>1SF]1SW>1SF]
1SW>13F]00<aS3F]=Jd07SW>0Sg_0cW>0Sg_0SW>136<0SW>A3g_2T8@0Sg_1T8@23g_00=244HaAS40
0T8@0SF]0RDY0QBU0PQ20P@Q100017oo0P0017oo000HOol00`00Oomoo`02Ool2>Lhd=Jd6>Lh6=Jd6
>Lh6=Jd6>Lh4=Jd00c6<=Jde[@0N>Lh2?Nl3>Lh2?Nl2>Lh4<H`2>Li4?Nl:@Q02?Nl6@Q08?Nl00d8@
AS56<@02@Q02=Jd29BT25:D2248212440005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo``i
cQle[A<icP8e[@PicP@e[@HicPLe[@hicP8e[A0icP8mk`03>Lhmkcg_008mk`8e[@8aS08e[BDmk`A2
40hmk`I240<mka12408mk`m2408icP8]J`8Li`8<H`X000Eoo`03001oogoo009oo`0067oo00<007oo
Ool00Woo33W>7cF]4cW>0SF]23W>13F]1SW>1cF]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Cg_148@3Sg_1T8@0cg_448@0Sg_3d8@0SW>0Re[0QcW0PaS2P001Goo00<007ooOol00Woo000H
Ool00`00Oomoo`02OolI>Lh2=Jd4>Lh8=Jd?>Lh4=Jd4>Lh2=Jd6>Lh6=Jd6>Lh7=JdL>Lh4?Nl2>Lh3
?Nl2>Lh2=Jd2<H`2=JdS?Nl8@Q0<?Nl7@Q02?NlD@Q04?Nl2@Q04AS42@Q000cF]9BTU:@0248@2124<
0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooaTicP8e[@@icPPe[@licP@e[@@icP8e[@Hi
cPHe[@HicPLe[A`icP@mk`8icP<mk`8icP8e[@8aS08e[B<mk`Q240`mk`M2408mkaA240@mk`9240A6
<@924003=JdU:BDY008@Q0848@`000Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo?SW>13F]
1SW>0SF]23W>0SF]0S6<0SF]2CW>13g_33W>23g_0SW>0cg_0SW>13F]0SW>7cg_0T8@0Sg_1T8@3Sg_
7D8@0Sg_0T8@14Ha0Sg_0S6<00<Q212448@00P@Q3P001Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ooln>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd9>Lh4?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhO?Nl2
@Q02?Nl6@Q0>?NlM@Q02?Nl2@Q04AS42?Nl2<H`00b4848@@Q002124>0005Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo009ooaTicP8e[CLicP@e[@TicPhmk`@icP/mk`8icP@e[@8icQlmk`A2408mk`I2
40PmkaM2408mk`Y240I6<@8icP8YBP8HaP0336<48@@Q010000Eoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo6CW>0SF]=cW>13F]2CW>3Sg_13W>2cg_0SW>13F]0SW>7cg_148@0Sg_1T8@23g_5d8@
0Sg_2T8@1THa0SW>0RU:0QS600<<H`@Q124040001Goo00<007ooOol00Woo000HOol20003Ool2?Nm>
>Lh6=Jd2>Lh00cg_>LhicP02>LhO?Nl4=Jd2>LhJ?Nl;@Q02?Nl6@Q06?NlQ@Q06AS42?Nl2=Jd29BT2
48@2124=000212440004Ool20004Ool001Qoo`03001oogoo009ooa/mkcDicPHe[@8icP03?NlicSW>
008icP@mk`@icQHmk`03>Lhe[CF]008aS08icPA240@icPhmk`U2408mkaY240M6<@9240A6<@Q240A6
<@9:DP96<@92408aS08Li`8<H`848@80000312400000008000@48@X000Eoo`03001oogoo009oo`00
67oo00<007ooOol00Woo6cg_=CW>1SF]0SW>00<mkcW>>Lh00SW>13g_13W>5Sg_00<icSF]=Jd00S6<
0SW>148@13W>3Sg_2D8@0Sg_6T8@1dHa0T8@14Ha248@14Ha0TYB0THa0T8@0S6<0QcW0PaS0P@Q0P00
00<48@0000000P0010@Q2P001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolG?Nl8>Lh8?Nl4
>LhG?Nl8>Lh2?Nl2>Lh6=Jd4>LhI?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2>Lh4?NlI@Q04?NlO
@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124C0005Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009ooaLmk`PicPPmk`@icQLmk`PicP8mk`8icPHe[@@icQTmk`@icPHmk`03>Lhe[CF]008e
[@8icPHmk`8icP@mkaU240@mkam240A6<@8mk`9240I6<@8icP8]J`8Li`8<H`848@8000848A<000Eo
o`03001oogoo009oo`0067oo00<007ooOol00Woo6cg_13W>23g_13W>2cg_13W>3Sg_0SW>0Sg_0SW>
13F]13W>9Cg_00<icSF]=Jd00SW>0Sg_0T8@3Sg_>T8@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q
4`001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolK?Nl4>Lh8?Nl4>Lh;?Nl4>Lh>?Nl2>Lh2
?Nl2>Lh4=Jd4>LhU?Nl00cW>=Jde[@02>Lh2?Nl2@Q0>?Nlj@Q08AS42?Nl2<H`29BT25:D224821244
0002124C0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo``mk`A2408mk`E243Dmk`PicRDm
k`DicP@mk`A2408mk`A240PmkbU24096<@M24096<@A24096<@9:DP96<@8icP8]J`8HaP8@Q0848@P0
00848A<000Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo33g_148@0Sg_1D8@=Cg_23W>9Cg_
1CW>13g_148@0Sg_148@23g_:D8@0THa1d8@0THa148@0THa0TYB0THa0SW>0Re[0QS60Q240P@Q2000
0P@Q4`001Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool@@Q02?Nl5@Q04?Nl4@Q0]?Nl6>LhW
?Nl2>Lh5?Nl<@Q08?Nlb@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124G0005Ool0
0`00Oomoo`02Ool001Qoo`8000=ooa12408mk`E240@mk`A242dmk`HicRLmk`8icPDmk`a240Pmkc92
4096<@924096<@9:DP96<@8icP8YBP8HaP88@P848@@000@48AL000Aoo`8000Aoo`0067oo00<007oo
Ool00Woo6D8@0Sg_1T8@0Sg_5d8@43g_23W>0Sg_0T8@3cg_148@4cg_148@13g_A48@0THa14YB0SW>
0RU:0QS60PaS1P0010@Q6@001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolI@Q02?Nl6@Q02
?NlG@Q0@?Nl8>Lh2?Nl2@Q0??Nl4@Q0C?Nl4@Q04?Nm4@Q02AS44BU82>Lh2:DX26<H236<60004124I
0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`96<@I240A6<C9240`mk`HicP@mk`92414m
k`9240@mk`9240Xmk`M240@mkaY240U6<AA24096<@M240I6<@9:DP8mk`8U:@8DY@88@RD000Eoo`03
001oogoo009oo`0067oo00<007ooOol00Woo0THa1T8@14Ha<T8@33g_1SW>13g_0T8@4Cg_0T8@13g_
0T8@2Sg_1d8@13g_6T8@2DHa548@0THa1d8@1THa0TYB0Sg_0RDY0QBU0PQ29@001Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02OolIAS4a@Q08?Nl7@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q07AS4B@Q02AS42
@Q06AS44@Q03AS42BU82AS42>Lh29BT248@412420002124<0002124C0005Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo009ooaU6<C5240Pmk`M240`mk`Y240XmkaE240A6<@Y240M6<A924096<@9240I6
<@A240=6<@9:DP96<@8icP8U:@8@Q0@48@8000848@`000848A<000Eoo`03001oogoo009oo`0067oo
00<007ooOol00Woo6DHa248@2THa7d8@13g_8D8@13g_0SW>13g_3d8@2THa2T8@1DHa448@1THa0T8@
2dHa14YB0SW>0RDY0QBU20@Q1P0010@Q5@0010@Q1Goo00<007ooOol00Woo000:Ool40003Ool20005
Ool00`00Oomoo`02OolIAS48@Q0:AS4O@Q04?NlQ@Q04?Nl2>Lh4?Nl?@Q0:AS4:@Q05AS4@@Q06AS42
@Q0;AS44BU82>Lh29BT25:D812460004124E00041245Ool00`00Oomoo`02Ool000Yoo`03001oogoo
00=oo`04001oogoo0004Ool00`00Oomoo`02Ool2BU8[AS4E@Q02AS42BU82AS42@Q02?Nl4AS44?NlE
@Q02?Nl4@Q06?NlY@Q05AS44@Q02AS46@Q0<AS44@Q02AS43BU82AS42>Lh2:DX248@22488124S0005
Ool00`00Oomoo`02Ool000]oo`03001oogoo009oo`04001oogoo0004Ool30002Ool2BU8[AS4E@Q02
AS42BU82AS42@Q02?Nl4AS44?NlE@Q02?Nl4@Q06?NlY@Q05AS44@Q02AS46@Q0<AS44@Q02AS43BU82
AS42>Lh2:DX248@22488124S0003Ool30004Ool000aoo`05001oogooOol00002Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool<BU87AS46BU8JAS47@Q02AS44@Q02?Nl4>Lh2?Nl4@Q04AS44@Q02AS47@Q04
AS46@Q02AS4>@Q02AS4S@Q07AS44@Q0FAS42@Q04AS400d8@=Jde[@029BT25:D2248W000212440005
Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo34YB
1dHa1TYB6THa1d8@0THa148@0Sg_13W>0Sg_148@14Ha148@0THa1d8@14Ha1T8@0THa3T8@0THa8d8@
1dHa148@5THa0T8@14Ha00=243F]=Jd00RDY0QBU0PQ29`000P@Q10001Goo00<007ooOol00Woo000;
Ool20004Ool20005Ool00`00Oomoo`02OolSBU8IAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02BU82CW<;
AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0cAS42BU82AS400cF]9BTU:@0248@2248<0002124<0002124;
00081245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oob=:DQU6<@92408mk`8icP8aS08]J`8e
[@92409:DP9>L`]6<@A240I6<@A24096<@Y241E6<@A243=6<@9:DP96<@03=JdU:BDY008@Q088@P`0
00848@`000848@/000P48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo3TYB1Dic24YB14Ha
7DYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@1dHa148@0THa0TYB24Ha248@14Ha0T8@@4Ha1TYB
0THa0SW>00<YBQS66<H00PQ20P@Q0P003P@Q20002@@Q10002P@Q1Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool>BU85CW<8BU84AS4MBU84AS42?Nl2=Jd2<H`2?Nl2BU84DY@2CW<4@Q07AS44@Q02
AS42BU88AS48@Q04AS42@Q10AS46BU82AS42>Lh00bU:6<HHaP0224821242000>124800091244000:
1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A>L`Q:DPI>L`M:DP9>L`96<@A:DPQ>L`9:
DPI6<@A240E6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240]6<@A:DP96<@9240A6<@I24396
<@A:DQ96<@A:DP96<@8mk`8YBP036<H<H`aS00848@@000@48@H000848@X001L48@Eoo`03001oogoo
009oo`0067oo00<007ooOol00Woo14ic24YB1Tic1dYB0Tic0THa14YB24ic0TYB1THa148@1DHa24YB
0THa0T8@0TYB0UJe0U[F0VLi0Ukg0Tic0T8@2dHa14YB0THa0T8@14Ha1T8@<THa14YB4THa14YB0THa
0Sg_0RU:00<HaPaS36<00P@Q100010@Q1P000P@Q2P005`@Q1Goo00<007ooOol00Woo000HOol20003
Ool8CW<8BU8;CW<2DY@6CW<2BU82AS42@Q02?Nl6=Jd4<H`5=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2
IcT2E[D2BU85AS46BU82AS44?Nl2@Q02AS42BU88AS42BU8`AS4:BU8:AS44BU82@Q02<H`27>L00`aS
12448@0L000G1244Ool20004Ool001Qoo`03001oogoo009oo`Q>L`Q:DP]>L`9BU0I>L`9:DP96<@92
408mk`He[@@aS0De[@8icP@mk`I2409>L`9JeP9S609_N`9W>@9F]@9:DPE6<@I:DP96<@@mk`924096
<@9:DPQ6<@9:DS16<@Y:DPY6<@A:DP92408aS08Li`0336<48@@Q01`001L48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo6Dic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:2bDY12U:0Re[
0Sg_0U:D0V<H16Li0U[F0Tic0TYB14Ha00=>Le:DDY@00U:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha
1TYB<4Ha24YB1THa1TYB0T8@0SF]0R480Q2400<48@0000000P0030@Q3P005`@Q1Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02OolICW<2BU82CW<2BU82AS42@Q02>Lh2=Jd2<H`4;F/6:DX;9BT4:DX2
;F/2?Nl2DY@2HaP4IcT2F]H2CW<2BU84AS400dicDYABU002DY@2AS42>Lh2=Jd2>Lh2@Q02AS44BU84
AS46BU8`AS48BU86AS46BU82@Q02=Jd28@P248@00`@Q00000002000<124>000G1245Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009ooa9>L`=BU09>L`9:DP96<@@mk`8e[@8aS08]J`hYBP<U:@8Q208L
i`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP03IcUS66<H009F]@9240@aS092409:DP96<@a:
DQM6<A9:DPe6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P<48@8000H48@8000848A@001<48@Eoo`03
001oogoo009oo`0067oo00<007ooOol00Woo4Tic0e:D0Tic0TYB0THa13g_0SF]0S6<0Re[3RU:0bDY
0R480QcW21S60R480SW>0U[F0Vmk0W>L0VLi0UJe1U:D0U[F00=W>F<HHaP00UJe0T8@136<0T8@0TYB
0THa34YB5dHa4TYB3DHa14YB14Ha1TYB0THa0SW>0RDY0QBU0PQ20`@Q0P001P@Q0P000P@Q50004`@Q
1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<CW<4DY@3CW<2BU82@Q02?Nl2>Lh2<H`<;F/4
:DX6;F/3:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2HaP00fLiG_MNm`02
DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS45BU84AS46BU84AS46BU82AS42>Lh29BT25:D22483
0008124:00061244000I1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A>L`YBU09>L`96
<@03?Nle[CF]00@aS08]J`8aS0P]J`8aS0@]J`XaS003;F/aS36<00HaS08e[@92409F]@9W>@A_N`9J
eP96<@8mk`9:DP9JeP9Nm`9JeP03E[E:DTYB00I:DPA>Ld1:DPA6<@a:DP96<@8icP8]J`8HaP8<H`84
8@<000H48@X000P48@@001T48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo14ic2U:D0Tic
0THa00<mkcF]=Jd0136<0Re[0S6<22e[0S6<12e[2S6<00<]Jc6<<H`01S6<0SF]0T8@0UJe0VLi16mk
0U[F0THa0Sg_0TYB0U[F0Ukg0U[F00=F]DYBBU801TYB14ic@4YB14Ha34YB0THa0SW>0Re[0QS60PaS
0P@Q0`001P@Q2P0020@Q10006@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8DY@4CW<2
AS42?Nl2=Jd00be[:DXYBP02:DX4;F/:<H`8=Jd;>Lh6?Nl2AS42E[D2HaP2Kg/2JeX2IcT2CW<2?Nl2
=Jd2>Lh2AS44BU800dicBU9:DP0<CW<IBU88CW<YBU82CW<2AS42?Nl2;F/27>L236<=1248000:1244
000I1245Ool00`00Oomoo`02Ool001Qoo`8000=oo`QBU0A>L`96<@8mk`8e[@03;F/YBRU:008YBP@]
J`XaS0Pe[@/icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP03CW=:DTYB00a>
LaU:DPQ>LbU:DP9>L`96<@8mk`8]J`8Li`8<H`d48@P000X48@@001T48@Aoo`8000Aoo`0067oo00<0
07ooOol00Woo15:D0Tic0TYB0T8@0Sg_136<1be[2S6<13F]1SW>1Sg_1D8@1THa0TYB0Tic0U:D0UJe
0U[F0Ukg0V<H0U:D0THa0SW>1SF]0T8@00=>Le:DDY@00U:D0Tic1TYB0Tic0U:D34ic>4YB0THa14YB
0T8@0S6<0R480QBU2@@Q3P009`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4DY@2CW<2
BU82@Q02?Nl4<H`7;F/:<H`4=Jd6>Lh6?Nl5@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42
>Lh6=Jd2@Q000dicDYABU002DY@2CW<6BU82CW<2DY@<CW<hBU82AS44BU82@Q02<H`28@P25:D9124>
000W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`daS0@e
[@8icPHmk`Q240=6<@A:DP9>L`IBU09>L`9BU09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`03AS5>
Ldic02=>LaQ:DP9>L`U:DPA>L`a:DP96<@8e[@8U:@8@Q088@P848A<002T48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3C6<13F]0SW>1Sg_248@0dHa14YB0Tic
1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_00=6<DicCW<08dic64YB0Tic2DYB14ic
34YB0THa0SF]0RDY0Q240PQ20P@Q4`00:@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
?Nl2=Jd2<H`6;F/A<H`2=Jd4>Lh4?Nl4@Q08AS43BU84CW<6DY@:E[D6DY@2CW<2BU82@Q02?Nl00cW>
BU9:DP02CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU85CW<2BU82AS42BU86CW<2?Nl2:DX26<H224821244
000212430002124800081242000Q1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja4aS08e[@@icP@mk`A240Q6<@=:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`03>Li:DTYB
009>L`9BU09F]@ABU1e>La1:DPY>L`A:DPE>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@00084
8@<000848@P000P48@8002448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0S6<1Re[3C6<
13F]0SW>0SF]0SW>13g_148@14Ha24YB1Dic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@00<m
kdHaAS400TYB1U:D>Dic14YB1Dic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P002`@Q1P002P@Q0P008@@Q
1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2<H`6;F/=<H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04
AS48BU85CW<8DY@2E[D2F]H4E[D2DY@4E[D2DY@4CW<2BU82@Q000cg_AS56<@02BU86DY@iCW<4BU85
CW<6BU84CW<2AS42<H`27>L236<21242000;1246000:1242000Q1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`H]Ja4aS08e[@@icP8mk`A240A6<@Q:DPA>L`MBU0iF]@QJeP9F]@ABU09:DP03
AS4mkcg_0096<@9>L`YBU1m>L`9BU1A>L`=:DP9>L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@4
8@<000848@H000X48@8002448@Eoo`03001oogoo009oo`0067oo0P000goo1Re[4C6<0SF]13W>0Sg_
148@14Ha24YB14ic1e:D3UJe25[F0UJe15:D0TYB00=6<Cg_?Nl00THa0Tic2U:D7dic0U:D54ic0dYB
0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q0`000P@Q1P002P@Q0P008@@Q17oo0P0017oo
000HOol00`00Oomoo`02Ool6;F/=<H`2=Jd4>Lh4?Nl4@Q04AS44BU88CW<4DY@9E[D@F]H8E[D3DY@2
AS42@Q02AS42CW<8DY@6CW<:DY@XCW<2BU88CW<2BU82?Nl2;F/26<H22486000K1242000Q1245Ool0
0`00Oomoo`02Ool001Qoo`03001oogoo009oo`H]J`daS08e[@@icP@mk`A240A6<@A:DPQ>L`ABU0UF
]A1JePQF]@=BU096<@924096<@9>L`QBU0I>L`YBU2Q>L`9:DPQ>L`9:DP8mk`8]J`8HaP88@PH001/4
8@8002448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo336<1SF]0cW>13g_148@14Ha1TYB
1Tic1U:D1eJe65[F15Je0e:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Dic0U:D0Tic0THa
0S6<0R480Q240P@Q1P006`@Q0P008@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<<H`6
=Jd3>Lh4?Nl4@Q04AS46BU86CW<6DY@7E[DHF]H4E[D3DY@2BU82AS42@Q02BU82CW<6DY@4CW<<DY@?
CW<2DY@MCW<2DY@2CW<2AS42<H`28@P248@21246000K1242000Q1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`PaS0Pe[@8icPDmk`A24096<@A:DPI>L`QBU0IF]AEJePINm`AJePEF]@9BU09:
DPA2409:DPAF]@iBU0A>L`]BU0A>L`IBU1M>L`ABU09:DP8icP8U:@8@Q0848@P003h48@Eoo`03001o
ogoo009oo`0067oo00<007ooOol00Woo236<23F]0SW>1Cg_148@0THa14YB1Tic25:D1UJe5E[F1Ukg
15[F1EJe0U:D0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D5dic15:D0TYB0SW>0RDY0Q240P@Q2000
?P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6<H`8=Jd2>Lh3?Nl6@Q02AS44BU86CW<6
DY@8E[D;F]HDG_L4F]H5E[D2DY@2AS42@Q02AS42DY@2E[DUDY@ICW<2DY@2CW<2@Q02;F/26<H236<2
124200021244000n1245Ool00`00Oomoo`02Ool000aoo`<0009oo`8000Eoo`03001oogoo009oo`Ha
S0Pe[@8icP<mk`I24096<@A:DPI>L`IBU0QF]@]JeQANm`AJePEF]@9BU096<@924096<@9BU09F]BEB
U1U>L`9BU09>L`92408]J`8HaP8<H`848@8000848@@003h48@Eoo`03001oogoo009oo`003Goo00@0
07ooOol0009oo`03001oogoo009oo`03001oogoo009oo`PaS0@e[@@icP8mk`=240I6<@A:DPI>L`IB
U0QF]@UJePiNm`9S60YNm`9JePEF]@9>L`96<@92409:DQmBU0A>L`ABU1M>L`ABU096<@8e[@8Q208@
Q088@P848@8000848@@003h48@Eoo`03001oogoo009oo`002Woo1@0000Eoo`00Oomoo`0000Aoo`<0
009oo`PaS0@e[@@icP8mk`=240I6<@A:DPI>L`IBU0QF]@UJePiNm`9S60YNm`9JePEF]@9>L`96<@92
409:DQmBU0A>L`ABU1M>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@003h48@=oo`<000Aoo`00
2Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl00d8@AS56
<@06AS44BU84CW<8DY@8E[D5F]H:G_L:HaP:G_L3F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@5
CW<4DY@2CW<2?Nl2:DX25:D22482124400021244000n1245Ool00`00Oomoo`02Ool000]oo`03001o
o`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl00d8@AS56<@06AS44BU84
CW<8DY@8E[D5F]H:G_L:HaP:G_L3F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@5CW<4DY@2CW<2
?Nl2:DX25:D22482124400021244000n1245Ool00`00Oomoo`02Ool000aoo`8000=oo`8000Eoo`03
001oogoo009oo`8aS08e[@@icPPmk`9240E6<@A:DPA>L`IBU0IF]@]JePYNm`iS60YNm`EJeP9F]@9B
U09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`=BU09:DP92408]J`8Li`8<H`848@H000848@@003h48@Eo
o`03001oogoo009oo`0067oo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1DHa14YB14ic1U:D1UJe
2e[F2Ukg3V<H2Ukg1E[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic0e:D0TYB0T8@0Re[0QcW
0PaS0P@Q1P000P@Q1000?P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4
@Q03AS44BU86CW<4DY@8E[D<F]H5G_L2HaP2G_LDHaP9G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2
CW<2BU82CW<3DY@2AS42>Lh28@P25:D22486124200021244000n1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`8e[@HicP@mk`A240=6<@A:DPI>L`ABU0QF]@aJePENm`9S609NmaAS60UNm`9J
ePAF]@9>L`A:DP9>LamBU0Q>L`YBU09>L`9:DP9>L`=BU096<@8icP8Q208DY@88@PH48@8000848@@0
03h48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo13W>13g_148@1THa0dYB1Tic1U:D1UJe
35[F2Ekg66<H1ekg1U[F0U:D1TYB0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D00=F]E:DDY@0
0Sg_0Re[0QS60Q240PQ20P@Q2000@P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4>Lh4
?Nl4@Q06AS43BU86CW<6DY@6E[D<F]H9G_LHHaP7G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4
CW<>DY@4CW<2DY@00eJeDYABU002?Nl2;F/26<H248@22482124800121245Ool00`00Oomoo`02Ool0
01Qoo`8000=oo`8icP@mk`A240I6<@=:DPI>L`QBU0AF]@YJeP]Nm`iS609W>@aS60UNm`9JeP9F]@Q>
LbeBU0I>L`=BU09:DP8aS08Q208DY@8@Q088@P848@H004@48@Aoo`8000Aoo`0067oo00<007ooOol0
0Woo0SW>13g_148@1THa0dYB1Tic25:D15Je2U[F2ekg3V<H0VLi36<H2Ekg0U[F0UJe24ic;E:D1Tic
0e:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00A0@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02
Ool2?Nl6@Q04AS46BU83CW<:DY@4E[D:F]H=G_L>HaP8IcT;HaP4G_L4F]H2DY@6CW<[DY@8CW<2DY@0
0dic?Nlmk`02:DX26<H248@236<4124400161245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`I240A6<@Q:DPE>L`QBU09F]@iJeP]Nmb5S609Nm`IJeP9F]@9>L`A:DP9>LbUBU09>L`9BU09>L`AB
U003BU8e[CF]008Q208DY@8@Q08<H`848@H004H48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo1T8@14Ha24YB1Dic25:D0UJe3U[F2ekg8F<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic
15:D00=:DSF]=Jd00R480QBU0Q240PaS0P@Q1P00AP@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool4@Q06AS48BU83CW<8DY@4E[D>F]H;G_LOHaP4G_L6F]H2E[D2DY@4BU82CW<KDY@2CW<>DY@4
CW<2DY@2CW<00d8@;F/]J`026<H248@436<4124400161245Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`A240I6<@Q:DP=>L`QBU0AF]@iJeP]NmamS60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iB
U0A>L`9BU09>L`03@Q0]Jbe[008HaP8@Q0@<H`@48@@004H48@Eoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo0T8@1THa14YB1dic1U:D25Je35[F3Ekg7f<H1Ukg1U[F0U:D0Tic14YB1Tic5E:D1Tic
2U:D0Tic15:D0Tic00<icRDY9BT00QBU10aS0PQ2CP@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool2@Q06AS44BU87CW<6DY@8E[D<F]H=G_LOHaP6G_L6F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2
CW<4DY@2CW<00cW>9BTU:@025:D436<2249>1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`I6<@I:DPI>L`EBU0QF]@aJeP]Nm`YS609W>A]S60QNm`9F]@9BU0I:DPA>L`9BU0A>L`EBU11>L`AB
U0Q>L`ABU0924003;F/LiacW008@Q0@<H`88@Th48@Eoo`03001oogoo009oo`0067oo0P000goo1THa
1TYB1Tic1E:D25Je35[F2ekg2V<H0VLi6f<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic15:D24ic
15:D0T8@00<]JacW7>L00Q2410aS0PQ2CP@Q17oo0P0017oo000HOol00`00Oomoo`02Ool4AS44BU8:
CW<5DY@6E[D:F]H>G_L9HaP6IcTIHaP8G_L2F]H2DY@2CW<6BU88CW<3DY@NCW<2DY@2BU82=Jd00b48
5:DDY@0448@2248]1242248Q1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A6<@A:DPY>
L`EBU0IF]@YJePiNm`US60IW>AUS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@038@PD
YABU00@@Q088@Rd48@88@R448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0THa24YB0Tic
2E:D15Je3U[F3Ukg2F<H2VLi16<H36Li1f<H15kg0U[F15Je0Tic0TYB0THa14YB24ic00=BU4icCW<0
1Tic0U:D34ic0U:D0Tic0TYB14ic0THa0Re[00<HaQ2448@011240PQ2;`@Q0PQ27`@Q1Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool2AS48BU82CW<9DY@4E[D>F]H>G_L9HaP:IcT4HaP<IcT7HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/0
0aS648@@Q00448@2248_1242248O1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`I:DPI>
L`UBU0AF]@iJePiNm`US60aW>@IS60AW>@]S60ANm`AJeP9F]@9BU09>L`A6<@9:DRM>L`9:DP8mk`8Y
BP035:D@Q12400@<H`88@Rd48@@8@Ql48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo1TYB
1Tic2E:D15Je3U[F3Ukg2F<H36Li1V<H16Li2f<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic0TYB0Sg_
0RU:00<DYA2448@010aS0PQ2;@@Q10Q27`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4
BU88CW<7DY@4E[D>F]H<G_L?HaP:IcTGHaP4G_L4F]H2E[D2CW<4AS42BU8SCW<4DY@2AS42=Jd28@P0
0a2436<<H`0236<4248H1242248?1248248O1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`A:DPQ>L`MBU0AF]@iJePaNm`mS60YW>AMS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q
200348@<H`aS008<H`@8@QP48@88@Pl48@P8@Ql48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo14YB24ic2eJe3U[F35kg2F<H16Li1V<H1VLi5f<H15kg15[F0UJe0U:D0TYB14Ha0TYB7Dic0TYB
0Tic15:D0T8@0RU:0QS60a240PaS10Q25P@Q10Q22`@Q30Q27`@Q1Goo00<007ooOol00Woo000HOol2
0003Ool4BU88CW<;E[D>F]H<G_L9HaP4IcT6HaP6IcTGHaP4G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2
BU82CW<4DY@2@Q02:DX26<H348@236<4248F1244248;124<248O1244Ool20004Ool001Qoo`03001o
ogoo009oo`A:DPI>L`9BU0]F]@iJePaNm`US60IW>@IS60AW>AES60INm`AJeP9F]@9BU09>L`I6<@9:
DQ=>L`9:DPI>L`9:DP9>L`9BU09>L`8icP8Q208HaP035:D@Q124008<H`P8@Q848@@8@PT48A08@Qd4
8@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo14YB1Tic0U:D2eJe3U[F35kg2F<H1VLi1V<H
16Li5F<H1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS600<D
YA2448@00PaS20Q24P@Q10Q22@@Q40Q27@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
BU86CW<4DY@;E[D<F]HBG_L5HaP:IcTKHaP6G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02BU87CW<4BU88
CW<4BU84CW<2BU82CW<2DY@2AS42<H`26<H35:D248@236<8248<124:248512422482124@248M1245
Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`9:DPI>L`ABU0]F]@aJeQ9Nm`ES60YW>A]S60IN
m`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP<D
Y@8@Q08<H`P8@P`48@X8@PD48@88@P848A08@Qd48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo1Tic1U:D2EJe3U[F4Ukg0f<H3VLi6F<H1Ukg15[F15Je0U:D0TYB1THa14YB0dic14YB14ic0TYB
0Tic1TYB24ic0SW>0RDY1ABU0Q242PQ22P@Q9@Q27@@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool6CW<6DY@9E[D>F]HBG_L3HaP>IcTIHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2
BU82CW<6BU88CW<2>Lh29BT55:D248@:248:124U248M1245Ool00`00Oomoo`02Ool000Yoo`<000Ao
o`8000Eoo`03001oogoo009oo`I>L`ABU0]F]@iJePQNm`IS60ANm`=S609W>@9S60YW>AUS60YNm`9J
eP9F]@9BU09>L`I6<AU:DPI>L`9:DP8e[@8Q208@Q08DY@036<H@Q12400@8@P848@@8@PX48@@8@P@<
Had8@QT48@@8@PEoo`03001oogoo009oo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool6CW<4DY@;E[D>F]H8G_L6HaP4G_L3HaP2IcT2HaP:IcTIHaP:G_L2F]H2E[D2DY@2CW<6
AS4IBU86CW<2BU82=Jd28@P248@25:D00aS648@@Q00424821244248:1244248436<M248I12442485
Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`000Woo0Tic2U:D1eJe
45[F3Ukg16<H3fLi6f<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
0aBU0PaS30Q210@Q0PQ21PaS0Q240PaS1@Q21P@Q4PQ26@@Q10Q20goo0`0017oo000:Ool30003Ool0
1000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D1eJe45[F3Ukg16<H3fLi6f<H2Ukg15[F0UJe0Tic
0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q240aBU0PaS30Q210@Q0PQ21PaS0Q240PaS1@Q2
1P@Q4PQ26@@Q10Q21Goo00<007ooOol00Woo000;Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<0
07ooOol00Woo0Tic25:D2EJe45[F3Ukg1F<H3VLi6f<H2Ukg15[F0UJe0U:D0Tic0TYB0THa0T8@0THa
2dYB0THa2TYB0Tic0TYB0SW>0RDY0QBU0PaS0aBU0PaS2PQ21P@Q0PQ20PaS0QcW0QS60QBU0PaS1`Q2
10@Q40Q27`@Q1Goo00<007ooOol00Woo000;Ool30003Ool20005Ool00`00Oomoo`02Ool2CW<8DY@9
E[D@F]H>G_L5HaP>IcTKHaP:G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02AS4;BU82AS4:BU82CW<2BU82
>Lh29BT25:D236<35:D236<:24861242248236<27>L26<H25:D236<72484124@248O1245Ool00`00
Oomoo`02Ool001Qoo`03001oogoo009oo`9>L`IBU0]F]A1JePaNm`IS60mW>A]S60YNm`AJePAF]@9B
U09>L`96<@924096<@]:DP96<@Y:DP9>L`96<@8aS08Li`8@Q08<H`<@Q08<H`H8@PX48@88@P8<H`8Q
208Li`8DY@8<Ha/8@Qd48@88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo0Tic1U:D2eJe
45[F35kg1V<H3fLi6f<H2Ukg15[F15Je0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW
0Q240PaS0a240PaS1PQ22P@Q0PQ20PaS0R480QcW0QBU0PaS6`Q27@@Q0PQ21Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool6DY@<E[D?F]H:G_L8HaPAIcTKHaP:G_L6F]H2E[D2DY@2CW<2BU82AS42
@Q000dHaBU9:DP04BU86AS42BU82AS48BU82?Nl2;F/26<H248@236<25:D00a2436<<H`02248>1242
36<248@46<H25:D236<K248K12442485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IBU0aF
]@mJePYNm`QS615W>A]S60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB00A:DPI6<@9:DP96
<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@0348@<H`aS0088@Ph48@8<H`8@Q0@HaP8DY@8<Ha/8@Q/48@@8
@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U:D25Je4e[F2Ukg2V<H3fLi7F<H25kg1U[F
0UJe15:D0TYB0THa0d8@4THa1TYB0SW>0RDY0QBU0PaS0Q240QBU00<@Q0aS36<00PQ230@Q10Q220aS
5`Q20PaS10Q26@@Q1PQ21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6DY@8E[DCF]H:G_L:
HaP?IcTMHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT25:D236<248@25:D00a2436<<
H`02248<1244248836<G248236<4248I12462485Ool00`00Oomoo`02Ool001Qoo`8000=oo`ABU0QF
]AEJePiNm`US619W>AMS60QNm`IJeP9F]@ABU09>L`9:DPM240i6<@A:DP96<@8e[@8Q208@Q0@<H`8@
Q00336<8@PQ20088@Ph48Al8@P@<H`@8@QT48@H8@PAoo`8000Aoo`0067oo00<007ooOol00Woo15:D
25Je4e[F45kg2F<H4VLi6f<H15kg0U[F0Ukg0U[F1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB
0THa0T8@0S6<0QcW0Q241PaS1@Q22P@Q0PQ210@Q1PQ210@Q4`Q210aS1PQ20P@Q10Q21`@Q40Q21Goo
00<007ooOol00Woo000HOol00`00Oomoo`02Ool4DY@8E[DCF]H@G_L9HaPBIcTKHaP4G_L2F]H2G_L2
F]H6E[D2DY@2BU82AS400d8@?Nlmk`04@Q0<AS42BU82AS42@Q02<H`27>L248@636<5248:12422484
12462484124C248436<6248212442487124@2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`ABU0QF]A=JePaNm`YS60EW>@AS60iW>AUS60ANm`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_
00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@Q08<H`0324848@@Q00`48@`8@P@48@D8@P848@`8
@P@<H`H8@P848@@8@PL48A08@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15:D25Je4e[F
35kg2V<H1FLi16<H3VLi6F<H15kg0U[F15kg0U[F15Je0U:D0TYB0THa00=243g_?Nl01T8@1THa0T8@
0THa0TYB0THa0Sg_0Re[0QS61Q240PaS00<8@P@Q124030@Q30Q210@Q1@Q20P@Q30Q210aS1PQ20P@Q
10Q21`@Q40Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<E[D?F]H@G_L8HaP3IcT8HaP2
IcT6HaP6IcTCHaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT2
6<H648@236<E12422484124E248436<:248212462485124>2485Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`aF]@mJeQ1Nm`QS60=W>@QS609W>@IS60IW>A=S60iNm`IJeP9F]@9BU0A>L`03AS4m
kcg_008mk`I240A6<@A2409:DP96<@8e[@8U:@8HaPH@Q08<HaD48@88@P@48AD8@P@<H`X8@P848@H8
@PD48@h8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo2UJe4E[F45kg2V<H00=W>F<HHaP0
1V<H0VLi1V<H1VLi4f<H15kg0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@
0SF]0RDY0QS60QBU0Q240PaS0PQ24`@Q10Q210@Q5@Q210aS2PQ20P@Q1PQ20`@Q40Q21Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool:E[DAF]H@G_L:HaP00fLiHaQS6006HaP2IcT6HaP6IcTCHaP4
G_L2HaP8G_L6F]H4E[D2DY@2CW<00dYB@Q124008@Q04AS44@Q02AS42@Q02=Jd29BT26<H25:D248@2
36<2248C12442484124E248436<:248212462483124@2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`QF]A=JeQ1Nma=S609W>@IS60IW>@eS609Nm`IS609Nm`AS60INm`QJeP9F]@ABU003BU96
<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88@Q<48Ad8@P@<H`X8@P84
8@H8@P031248@PQ20108@PEoo`03001oogoo009oo`0067oo0P000goo25Je4e[F45kg4f<H0VLi1V<H
1VLi3F<H0Ukg1V<H0Ukg16<H1Ukg25[F0UJe15:D00=:DTHaAS40148@0Sg_0T8@0THa1T8@0THa0T8@
0S6<0R480QS60QBU0Q240PaS0PQ24`@Q7@Q210aS2PQ20P@Q1PQ200<48@Q2248040Q217oo0P0017oo
000HOol00`00Oomoo`02Ool8E[DCF]H@G_L?HaP6IcT8HaP2IcT?HaP2G_L<HaP6G_L8F]H4E[D2DY@0
0dicBU9:DP02AS42@Q02?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248C124O248436<:2482124I
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`QF]A=JeQ1Nm`mS60IW>@QS609W>@mS609N
m`aS60INm`QJePAF]@9BU003CW=:DTYB0096<@92408mk`Y24096<@8mk`8]J`8Q208HaP8DY@8@Q088
@Q<48Al8@P@<H`X8@P848AT8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo25Je4e[F3Ukg
3F<H2VLi6F<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa0T8@13g_2T8@0SW>0RU:0QcW0QS6
0Q240PaS5@@Q7`Q210aS2PQ20P@Q6@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8E[DC
F]H>G_L=HaP:IcTIHaP2G_L<HaP4G_L:F]H4E[D2DY@00dicBU9:DP02AS42@Q04?Nl:@Q02>Lh2:DX2
7>L26<H248@236<E124O248436<:2482124I2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`QF]A=JePaNm`iS60]W>@9S60AW>A=S609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2408e
[@8U:@8HaP8DY@8<H`88@Q<48B48@P@<HbD8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo
25Je4e[F35kg3V<H2fLi0V<H16Li4f<H0Ukg36<H15kg2U[F15Je0U:D0dic0TYB0T8@13g_2T8@0SF]
0RDY0QS60QBU0PaS0PQ24`@Q8@Q210aS9@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8
E[D?F]H>G_L>HaP=IcT2HaP4IcTCHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06?Nl4
@Q02?Nl2<H`28@P45:D236<2248912422484124U248236<W2485Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`QF]@mJePiNm`iS60eW>@9S60AW>A=S609Nm`aS60INm`QJePIF]@03DYA>Ldic009:
DP96<@9240Hmk`A2408mk`8aS08Q20@DY@8<H`88@PT48@88@P@48BD8@P8<HbL8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo0UJe4e[F45kg3V<H4fLi4V<H0ekg36<H1Ukg2U[F15Je0e:D0Tic
0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU0Q240PaS0PQ22@@Q0PQ20P@Q9`Q20PaS9`Q21Goo00<007oo
Ool00Woo000HOol20003Ool2E[DCF]H@G_L>HaPCIcTBHaP3G_L<HaP6G_L:F]H4E[D3DY@2CW<2BU82
@Q08?Nl2@Q02?Nl2;F/27>L25:D248@236<2248912422482124W248236<W2484Ool20004Ool001Qo
o`03001oogoo009oo`AF]@mJeQ9Nm`iS60mW>AAS60=Nm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PL48@88@PX48@P8@P848A<8@PP<Hb<8
@P8<H`88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15Je3e[F4Ukg3V<H3fLi56<H0ekg
2V<H0VLi0V<H0Ukg0V<H15kg25[F1EJe0U:D0Tic14YB0T8@0SW>13g_0T8@0Sg_0RU:0QS60Q240PaS
0PQ21`@Q0PQ22P@Q20Q20P@Q4`Q220aS8`Q20PaS0PQ21Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool2E[D@F]HAG_LBHaP;IcTFHaP3G_L>HaP8G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02
>Lh2:DX26<H248@236<224871244248812482482124E248636<W2485Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`9F]A1JeQ5Nma9S60]W>AIS60=Nm`iS60QNm`QJePEF]@9BU0A>L`9:DP92408i
cP@mk`92408icP8YBP8HaP8@Q08<H`88@PL48@@8@PP48@P8@P848AD8@PH<HbL8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo0UJe3U[F4ekg4f<H26Li6V<H00=Nmf<HHaP036<H25kg2U[F0eJe
15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ21`@Q10Q220@Q20Q20P@Q5@Q21PaS
9@Q20PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2E[D>F]HCG_LCHaP8IcTJHaP00ekg
HaQS600<HaP8G_L:F]H3E[D4DY@2CW<2BU82AS42?Nl2>Lh4?Nl2>Lh29BT25:D248@236<224871244
248812482482124E248636<U248236<5Ool00`00Oomoo`02Ool000]oo`8000Aoo`8000Eoo`03001o
ogoo009oo`9F]@iJeQ=NmaES60IW>BUS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8D
Y@@<H`T48@H8@PH48@P8@P848AD8@PH<HbD8@P8<H`Eoo`03001oogoo009oo`002Woo00@007ooOol0
009oo`04001oogoo0004Ool00`00Oomoo`02Ool2E[D>F]HCG_LEHaP6IcTYHaP8G_L:F]H5E[D2DY@4
CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<91246248612482482124E248636<U248236<5Ool00`00
Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`000Woo45[F5Ekg4F<H26Li:F<H
2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2@@Q1PQ21P@Q20Q20P@Q5@Q21PaS9`Q2
0goo0`0017oo000;Ool20003Ool01000Oomoo`0017oo00<007ooOol00Woo45[F5Ekg4F<H26Li:F<H
2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2@@Q1PQ21P@Q20Q20P@Q5@Q21PaS9`Q2
1Goo00<007ooOol00Woo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009ooa9J
eQ=Nma1S60UW>B]S60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8icP8e[@8aS08Q208DY@8<H`88@QD4
8@P8@P848AD8@PH<HbD8@P8<H`Eoo`03001oogoo009oo`002goo0P0017oo0P001Goo00<007ooOol0
0Woo4U[F4ekg46<H2FLi:f<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU0PaS
0PQ25@@Q20Q20P@Q5@Q21PaS9@Q20PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolBF]H9
G_L2HaP8G_L<HaP?IcTYHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P25:D236<2248E
12482482124C248836<W2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa9JePUNm`9S60QN
m`aS60mW>BUS60aNm`MJeP9F]@IBU09>L`9:DP92408icP8e[@8]J`8Q208DY@8<H`88@QD48@P8@P84
8A<8@PP<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo4U[F2Ekg16<H1Ukg2V<H4fLi
9f<H3Ukg1E[F0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS5`@Q20Q20P@Q4`Q220aS9`Q21Goo
00<007ooOol00Woo000HOol00`00Oomoo`02Ool@F]H?G_L4HaP2G_L:HaP?IcTDHaP4IcT2HaP5G_L<
HaP<G_L9F]H4E[D2DY@4CW<2BU82@Q02=Jd2:DX27>L248@236<?2482124:2486124?248:36<U2482
12422485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1JePmNm`AS609Nm`YS60mW>AAS60AW
>@9S60ENm`aS60aNm`UJePAF]@9BU0A>L`9:DP92408e[@8YBP8Li`8@Q08<H`l8@P848@X8@PH48@l8
@PX<HbD8@P848@88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo45[F3ekg2V<H0VLi16<H
3fLi56<H0VLi16<H0ekg3V<H35kg2E[F15Je0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q
:0Q240aS8`Q21Goo00<007ooOol00Woo000HOol20003Ool@F]H?G_L:HaP2IcT4HaP?IcTDHaP2IcT4
HaP3G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2:DX27>L248@236<22486124X248@36<S2484
Ool20004Ool001Qoo`03001oogoo009ooa1JePmNm`YS609W>@9S60mW>AaS60=Nm`iS60iNm`MJePAF
]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BD8@Q4<HbD8@PEoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo45[F3ekg2V<H0VLi0V<H3fLi76<H0ekg3V<H3Ukg1e[F15Je0U:D14ic14YB0Sg_0Re[
0QcW0Q2410Q21P@Q9@Q24@aS9@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool@F]H?G_L8
HaP4IcT2HaP?IcTLHaP3G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`27>L248@42482124Z248@
36<U2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1JePmNm`QS60AW>@9S60mW>AaS60=N
ma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848BX8@Q0<HbD8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo3U[F4Ekg1V<H1VLi16<H3fLi1V<H0VLi4V<H0ekg46<H35kg1e[F
1UJe0U:D1Tic0THa0SF]0R480Q244@Q20P@Q7@Q20PaS0PQ230aS9@Q21Goo00<007ooOol00Woo000H
Ool00`00Oomoo`02Ool>F]HAG_L6HaP6IcT4HaP?IcT6HaP2IcTBHaP3G_L@HaP<G_L7F]H6E[D2DY@6
CW<2AS42=Jd28@P248@A2482124M248236<2248<36<U2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`iJePeNm`YS60IW>@9S61]W>A1S60=Nm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8m
k`8YBP8@Q0l8@P@48Ad8@Ph<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo3U[F3Ekg
2V<H1VLi0V<H6fLi46<H0ekg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q243`Q210@Q
7@Q23PaS9`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool>F]H=G_L8HaP6IcT2HaPMIcTG
HaP4G_L:HaP>G_L7F]H4E[D4DY@4CW<2AS42<H`25:DA2482124L248536<648@836<S2485Ool00`00
Oomoo`02Ool001Qoo`8000=oo`iJePeNm`QS60IW>@9S61eW>AMS60ANm`YS60iNm`MJePAF]@ABU0A>
L`96<@8aS08DYA48@P848A`8@PD<H`H@Q0P<Hb<8@PAoo`8000Aoo`0067oo00<007ooOol00Woo3U[F
3Ekg26<H1VLi0V<H7fLi5F<H15kg2V<H3Ukg2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:@Q2
1`aS0Q2411BU0Q241PaS7`Q20PaS0PQ21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool>F]H=
G_L8HaP6IcT2HaPOIcTEHaP4G_L:HaP>G_L9F]H2E[D2DY@2E[D4CW<2BU82>Lh26<H2248236<Y2487
36<248@45:D248@636<O248236<22485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJeQEN
m`YS62EW>B=S60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2148@P848Ad8@P8<H`8@Q0@HaP8DY@8@
Q08<H`88@P8<Hb<8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U[F5Ekg2V<H9FLi8f<H
3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484@Q20P@Q7@Q20PaS0Q2411S60QBU0Q240PaS0PQ20PaS
8`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6F]HEG_L6HaPYIcTEHaP4G_L:HaP2G_L4
HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@?2482124M248236<248@46<H25:D248@636<S
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJeQENm`IS62UW>AES60ANm`YS609Nm`AS
60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q0l8@P848Ad8@P8<H`8@Q0@HaP8DY@8@Q0H<Hb<8
@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U[F5Ekg1V<H:FLi5F<H15kg1V<H15kg26<H
1ekg25[F15Je25:D0THa0Re[0QBU1PQ20PaS9@Q20`aS0QBU12480QBU0Q2410aS9@Q21Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool6F]HEG_L6HaPYIcTEHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8
DY@2AS42;F/25:D6248236<U248336<25:D48@P25:D248@436<U2485Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`IJeQENm`AS62]W>AES60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8H
aPH8@P8<HbD8@P<<H`8HaP@]J`8Li`8@Q0@<HbD8@PEoo`03001oogoo009oo`0067oo0P000goo1U[F
5Ekg16<H:fLi5F<H15kg1V<H15kg26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9@Q20`aS0QS6
12e[0QcW0Q2410aS9@Q217oo0P0017oo000HOol00`00Oomoo`02Ool6F]H=G_L<HaPBIcT4JeXCIcTG
HaP4G_L8HaP6G_L4HaP7G_L8F]H4E[D8DY@2BU82>Lh28@P6248236<I248436<8248336<28@P4=Jd2
8@P248@236<W2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJePeNm`aS619W>@A[FQ=W
>AMS60ANm`QS60INm`AS60MNm`QJePAF]@QBU09:DP8icP8Q20H8@P8<HaT8@P@<H`P8@P<<H`8Q20@e
[@8Q208@Q08<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15[F3Ukg2f<H36Li0V]J
16Li2f]J46Li8f<H15kg26<H0ekg2U[F15Je1U:D0Tic0T8@0RU:0PaS10Q210aS5`Q21PaS1PQ20`aS
0R4813F]0R480Q240PaS2PQ20P@Q6`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4F]H>
G_L;HaP<IcT2JeX4IcT;JeX@IcTSHaP4G_L8HaP3G_L:F]H4E[D6DY@2CW<2@Q02:DX236<4248436<G
248636<6248336<28@P4=Jd28@P248@236<:2482124K2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009ooa1Nm`]S60aW>A=[FQ1W>C5S60=Nm`aJePIBU09>L`96<@8]J`8DY@@8@P8<HaT8@P@<H`P8
@P<<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A/8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo
45kg2f<H36Li4f]J46Li<F<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6@Q210aS20Q20`aS0QcW
12e[0QcW0Q241PaS10Q210@Q6`Q21Goo00<007ooOol00Woo0004Ool50002Ool20004Ool20005Ool0
0`00Oomoo`02Ool@G_L;HaP<IcTCJeX@IcTWHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D42484
36<E248236<<248336<26<H49BT25:D248@636<42484124K2485Ool00`00Oomoo`02Ool000Ioo`05
001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo45kg2f<H36Li
4f]J46Li9f<H16Li1V<H0ekg35[F1U:D0Tic0TYB0SF]0QBU10Q210aS5@Q20PaS30Q20`aS0QS612DY
0QBU0Q241PaS10Q210@Q6`Q21Goo00<007ooOol00Woo0006Ool01@00Oomoogoo00000Woo00@007oo
Ool0009oo`03001oogoo009oo`<0009ooa9Nm`ES611W>@m[FPAW>@9[FPiW>B=S60ANm`9S60A[FPAS
6003G_MJeU[F00ANm`QJeP9F]@9BU09F]@9BU09:DP8icP8HaP8<H`88@P@<HaD8@P@<H`P8@P<<H`8@
Q08HaP@Li`8DY@@@Q08<HbD8@P=oo`<000Aoo`001Woo00D007ooOomoo`00009oo`04001oogoo0002
Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L5HaP@IcT?JeX4IcT2JeX>IcTSHaP4G_L2HaP4JeX4
HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H236<2248436<E248436<8248336<2
48@26<H47>L25:D448@236<U2485Ool00`00Oomoo`02Ool000Ioo`05001oogooOol00002Ool01000
Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo0Ukg0U[F3Ukg1F<H3VLi5f]J3VLi9F<H0Ukg
0V<H16]J0VLi0V<H1ekg25[F0UJe0U:D0UJe0U:D0TYB0Sg_0QcW0PaS0PQ210aS5@Q210aS10Q20PaS
0PQ20`aS0Q240QBU11S60QBU0Q2410aS9@Q21Goo00<007ooOol00Woo0005Ool20004Ool20004Ool2
0005Ool00`00Oomoo`02Ool4F]H<G_L7HaP<IcTIJeX>IcTUHaP2G_L2HaP2IcT4JeX2HaP7G_L8F]H2
E[D2DY@2E[D2DY@2CW<2@Q029BT236<2248436<E248436<4248236<2248336<448@45:D248@636<U
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`AJePaNm`MS60aW>AU[FPiW>BES609Nm`9S
609W>@A[FP9S60MNm`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaD8@P@<H`@8@P8<H`88
@P<<H`@@Q0@DY@8@Q0H<HbD8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo0U[F3Ukg1f<H
36Li6f]J46Li9F<H0VLi16]J0f<H1Ukg25[F0UJe0U:D0UJe0U:D0Tic0THa0RU:0Q240PQ210aS00<8
@PaS36<06PQ20PaS10Q200<<Ha2448@00Q2411BU0Q241PaS9@Q21Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool2F]H>G_L7HaP<IcTKJeX@IcTUHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2
CW<2AS42:DX248@2248436<00`Q236<<H`0J248236<424800`aS48@@Q00248@45:D248@636<U2485
Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1Nm`ES60aW>A1[FP9_N`][FQ1W>A]S609Nm`YS
60AW>@=S60INm`YJePAF]@9BU09>L`96<@8]J`8DY@88@P@<H`03248<H`aS00@8@P8<Ha@8@P@<H`88
@P<<H`P@Q0P<H`@8@PP48AL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo45kg1F<H36Li
46]J0Vmk2f]J46Li6f<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS00<8
@PaS36<010Q20PaS50Q210aS0PQ20`aS212420aS10Q220@Q5`Q21Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool@G_L3HaP>IcT6JeX4Kg/4JeX6Kg/9JeXBIcT8HaP00fLiHaQS600QHaP6G_L4F]H2
G_L4F]H4E[D2DY@2CW<2BU82<H`26<H2248436<00`Q236<<H`04248236<D248436<2248336<648@6
36<8248812442489124:2485Ool00`00Oomoo`02Ool001Qoo`8000=ooa1Nm`=S60iW>@I[FPA_N`A[
FPI_N`U[FQ9W>@QS6003IcUS66<H025S60INm`AJeP9Nm`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<
H`03248<H`aS00@8@P8<Ha@8@P@<H`88@P<<H`H@Q0H<H`P8@PP48@@8@PT48@X8@PAoo`8000Aoo`00
67oo00<007ooOol00Woo3Ukg1F<H36Li16]J4Vmk2F]J6fLi8f<H1Ukg15[F0Ukg15[F15Je15:D0Tic
0SF]0QS61PaS00<8@PaS36<06PQ210aS0PQ23`aS20Q220@Q10Q22`@Q20Q21Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool>G_L5HaP<IcT4JeXBKg/9JeXKIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2
CW<2=Jd26<H636<00`Q236<<H`0J248436<2248?36<824881244248;12482485Ool00`00Oomoo`02
Ool001Qoo`03001oogoo009oo`iNm`ES60YW>@I[FQ=_N`Q[FQ]W>AAS60ANm`eS60ANm`AJeP9Nm`QJ
ePABU09>L`8icP8HaP8<H`88@PD<Ha88@P8<H`H8@P@<H`88@Pl<H`P8@PP48@@8@P/48@P8@PEoo`03
001oogoo009oo`0067oo00<007ooOol00Woo3Ukg1F<H2VLi1V]J4fmk26]J6fLi56<H15kg3F<H15kg
15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21@aS4PQ20PaS1PQ210aS0PQ23`aS20Q220@Q10Q22`@Q
20Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool:G_L8HaP9IcT6JeX6Kg/6Li`8Kg/9JeX@
IcT`HaP4G_L6F]H2G_L4F]H4E[D2DY@2BU82?Nl28@P736<2248236<<248636<:248A36<6248>1247
248812442485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`YNm`QS60UW>@I[FPI_N`IcW0Q_
N`U[FQ1W>C1S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20L<H`88@P8<H``8@PH<H`X8@Q4<H`H8
@Ph48@L8@PP48@@8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo2Ukg1V<H2fLi1V]J16mk
2W>L0Vmk0W>L0fmk2V]J3VLi<6<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0T8@0R481`aS0PQ20PaS40Q2
0PaS2PQ24`aS10Q24@@Q0PQ22P@Q10Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool:G_L6
HaP;IcT6JeX4Kg/:Li`2Kg/2Li`3Kg/:JeX>IcT`HaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P7
36<2248236<@248236<:248C36<4248A1242248:12442485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`QNm`QS60UW>@I[FPA_Na9cW003Kg][FV]J009_N`I[FPiW>C1S60YNm`IJePIF]@9>L`92
408U:@/<Ha`8@Q<<H`88@Ql48@@8@PEoo`03001oogoo009oo`0067oo0P000goo25kg26<H2FLi1V]J
16mk4W>L00=_Nf]JJeX00Vmk1V]J3VLi<6<H2Ukg1U[F1UJe0Tic0T8@0RDY2`aS70Q24`aS0PQ27`@Q
10Q217oo0P0017oo000HOol00`00Oomoo`02Ool8G_L6HaP9IcT6JeX4Kg/6Li`6Mkd6Li`7Kg/6JeX@
IcT^HaP:G_L8F]H4E[D2CW<2AS42:DX248@936<B248236<8248A36<4248O12442485Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oo`QNm`IS60UW>@I[FPA_N`IcW0Ig_@IcW0M_N`I[FQ1W>BiS60YN
m`QJePAF]@9>L`96<@8YBP8@Q0T<Ha88@P8<H`P8@Q4<H`@8@Ql48@@8@PEoo`03001oogoo009oo`00
67oo00<007ooOol00Woo1Ukg26<H1fLi26]J16mk17>L27Nm1W>L0fmk0V]J0Vmk16]J4VLi26<H00=W
>F<HHaP016<H0VLi7F<H35kg1U[F15Je0Tic0THa0RU:0Q240PaS0PQ21@aS4PQ20PaS20Q21@aS10Q2
1PaS1PQ28`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6G_L8HaP7IcT8JeX4Kg/4Li`8
Mkd6Li`3Kg/2JeX2Kg/4JeXBIcT8HaP00fLiHaQS6004HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX2
48@236<2248536<B248236<8248536<4248636<6248S1245Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`INm`IS60UW>@A[FPI_N`9cW0ig_@AcW0=_N`9[FP9_N`A[FQAW>@AS60=W>B1S609W>@=S
60aNm`IJePAF]@9BU096<@8YBP8@Q08<H`88@PD<Ha88@P8<H`P8@Q4<H`@8@R<48@Eoo`03001oogoo
009oo`0067oo00<007ooOol00Woo1Ukg1V<H2FLi16]J1Vmk0W>L3WNm17>L0fmk0V]J0Vmk16]J56Li
16<H0fLi86<H0VLi0f<H35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21@aS4PQ20PaS20Q24@aS10Q2
8`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6G_L4HaP9IcT6JeX4Kg/4Li`2Mkd:Nmh2
Mkd6Li`00fmkJeY[FP02Kg/6JeXIIcT@HaP2IcT>HaP2IcT00f<HG_MNm`0<G_L2F]H2G_L2F]H4E[D2
DY@2AS42:DX248@236<2248536<B248236<8248A36<4248S1245Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`INm`AS60UW>@I[FPA_N`AcW09g_@YkgP9g_@IcW003Kg][FV]J009_N`I[FQUW>A1S
609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88@PD<Ha88@P8<
H`P8@Q4<H`@8@R<48@Eoo`03001oogoo009oo`0067oo0P000goo1Ukg16<H2FLi16]J16mk17>L17Nm
2W_N17Nm17>L1Fmk1V]J6fLi3V<H0VLi4F<H3Ukg0U[F0Ukg0U[F15Je0U:D0TYB0RU:0PaS0PQ20P@Q
1@aS1PQ20PaS2PQ20PaS20Q24@aS10Q28`@Q17oo0P0017oo000HOol00`00Oomoo`02Ool6G_L4HaP9
IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`5Kg/6JeXKIcT>HaP2IcTAHaP>G_L2F]H2G_L2F]H4E[D2DY@2
BU82:DX236<22482124536<6248236<:248236<8248A36<4248S1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`aS60IW>@E[FP9_N`AcW0Ag_@AkgPIoo`AkgP9g_@AcW0=_N`I[FQ]W>B=S60iN
m`IJePAF]@9BU096<@8YBP8@Q0848@L8@PX<H``8@PH<H`D8@P`<H`@8@R<48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo36<H1VLi1F]J0Vmk17>L17Nm17_N1Woo17_N0WNm17>L0fmk1V]J6fLi
8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q1`Q22PaS30Q21PaS1@Q230aS10Q28`@Q1Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool<HaP6IcT3JeX4Kg/2Li`4Mkd4Nmh8Ool4Nmh2Mkd4Li`3Kg/6
JeXKIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@224821245248:36<U248U1245Ool00`00Oomoo`02
Ool001Qoo`03001oogoo009oo`aS60IW>@=[FPA_N`9cW0Ag_@AkgPQoo`AkgP9g_@AcW0=_N`I[FQ]W
>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@D8@PX<HbD8@RD48@Eoo`03001oogoo009oo`00
67oo00<007ooOol00Woo36<H16Li1F]J0Vmk17>L0WNm17_N2Woo17_N0WNm17>L1Fmk16]J7fLi2V<H
0VLi4f<H3Ukg1U[F15Je0U:D0THa0Re[0QBU0PQ20`@Q20Q21PaS9@Q29@@Q1Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool<HaP4IcT5JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`5Kg/4JeXOIcT:
HaP2IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224831248248636<U248U1245Ool00`00Oomoo`02
Ool000Aoo`D00003Ool00000008000=oo`8000Eoo`03001oogoo009oo`QS60QW>@=[FPA_N`9cW09g
_@AkgPioo`9kgP9g_@AcW0E_N`A[FR5W>AmS60aNm`IJePAF]@9BU096<@8]J`8DY@88@P<48@88@P84
8@H8@P@<Hal8@P8<H`@8@RD48@Eoo`03001oogoo009oo`001Woo00D007ooOomoo`0000Eoo`04001o
ogoo0004Ool00`00Oomoo`02Ool6HaP8IcT5JeX2Kg/4Li`2Mkd2Nmh@Ool2Nmh4Mkd2Li`5Kg/4JeXO
IcTQHaP:G_L8F]H4E[D2DY@2AS42;F/25:D236<224800`@Q2488@P0212422482124M248236<62482
36<4248U1245Ool00`00Oomoo`02Ool000Ioo`03001oogoo009oo`03001oogoo009oo`04001oogoo
0004Ool30002Ool6HaP8IcT5JeX2Kg/4Li`2Mkd2Nmh@Ool2Nmh4Mkd2Li`5Kg/4JeXOIcTQHaP:G_L8
F]H4E[D2DY@2AS42;F/25:D236<224800`@Q2488@P0212422482124M248236<6248236<4248U1243
Ool30004Ool000Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool4HaP8IcT6JeX3Kg/2Li`2Mkd2NmhBOol4Nmh2Mkd2Li`5Kg/6JeXIIcTWHaP8G_L8F]H4E[D2
DY@2BU82<H`26<H236<224800`@Q2488@P0212422484124W248W1245Ool00`00Oomoo`02Ool000Io
o`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li
1V]J0fmk0W>L0WNm0W_N4Woo17_N0WNm0W>L1Fmk1V]J6FLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS6
0PaS0PQ200<48@Q224800P@Q0PQ210@Q9`Q29`@Q1Goo00<007ooOol00Woo0005Ool20004Ool20004
Ool20005Ool00`00Oomoo`02Ool4HaP6IcT6JeX3Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`5Kg/6JeXK
IcT:HaP4IcT>HaP2G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@224800`@Q2488@P02
1242248412422482124@248436<?248W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`AS
60IW>@I[FP=_N`9cW0Ag_@9kgQAoo`9kgP9g_@9cW0E_N`I[FQ]W>@YS60AW>@iS609Nm`=S609Nm`AS
60INm`QJePAF]@9BU09:DP8e[@8Q208@Q088@P031248@PQ200848@88@P@48@88@P848A08@P@<H`l8
@RL48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0V<H1VLi1V]J16mk0g>L0WNm17_N57oo
0W_N0WNm0W>L1Fmk1V]J:FLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY0QBU0PQ200<48@Q2
248010Q210@Q0PQ220@Q2PQ21`aS30Q29`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
HaP6IcT6JeX4Kg/3Li`2Mkd4NmhDOol2Nmh2Mkd2Li`5Kg/6JeXYIcT>HaP7G_L4HaP6G_L8F]H4E[D2
DY@2BU82?Nl29BT25:D224800`@Q2488@P04248412422488124:248736<<248W1245Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oo`QW>@Q[FP9_N`03Liag_GNm009g_@AkgQ9oo`AkgP9g_@9cW003
Kg][FV]J009_N`Q[FR5W>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`D8@P@48@88@PX48@H8
@P@<H`D8@P8<H`@8@P8<H`H8@RL48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo26Li26]J
0Vmk00=cW7NmMkd00WNm17_N4Woo17_N0WNm0W>L00=_Nf]JJeX00Vmk26]J8FLi66<H3Ekg25[F15Je
0Tic0THa0T8@0S6<0QcW0PaS1@Q210@Q0PQ22P@Q1PQ210aS1@Q20PaS10Q20PaS1PQ29`@Q1Goo00<0
07ooOol00Woo000HOol00`00Oomoo`02Ool8IcT6JeX4Kg/00g>LMkeg_@04NmhDOol2Nmh4Mkd2Li`0
0fmkJeY[FP04Kg/8JeXOIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D5248@124E248236<6
248W1245Ool00`00Oomoo`02Ool001Qoo`8000=oo`QW>@I[FPA_N`03Liag_GNm00AkgQAoo`9kgPAg
_@9cW003Kg][FV]J00A_N`Q[FQmW>AQS60eNm`QJeP9F]@9BU09>L`A6<@8icP8U:@8DY@D8@Q048AD8
@P8<H`H8@RL48@Aoo`8000Aoo`0067oo00<007ooOol00Woo26Li16]J1Vmk00=cW7NmMkd017_N57oo
0W_N17Nm0W>L00=_Nf]JJeX016mk3V]J0VLi16]J4fLi66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha
0Sg_0S6<0QcW00<<H`Q224800PQ250@Q4@Q20PaS1PQ29`@Q1Goo00<007ooOol00Woo000HOol00`00
Oomoo`02Ool8IcT4JeX6Kg/00g>LMkeg_@04NmhDOol2Nmh4Mkd2Li`00fmkJeY[FP04Kg/>JeX2IcT4
JeXCIcTHHaP=G_L2F]H2G_L4F]H2E[D2DY@2CW<4AS42?Nl2<H`27>L00`aS2488@P02248D124A2482
36<6248W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IW>@I[FPA_N`=cW09g_@AkgQAo
o`9kgPAg_@9cW0M_NaI[FQ5W>@QS60AW>@eS60aNm`9JePANm`9JeP9F]@9BU09:DP96<@A2408icP8U
:@0348@8@PQ20088@QH48@/8@PH<H`@8@RT48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo
1VLi1V]J16mk0g>L0WNm17_N57oo0W_N17Nm0W>L1fmk5V]J4FLi26<H16Li3F<H35kg0U[F15kg0U[F
0UJe0U:D0TYB0THa148@0SW>0RDY00<@Q0Q224800PQ25P@Q2`Q21PaS10Q2:@@Q1Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02Ool6IcT6JeX4Kg/3Li`2Mkd2NmhDOol4Nmh4Mkd2Li`5Kg/8JeX8IcT8
JeXAIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`00aS636<<H`04
248J124?248Y1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IW>@I[FPA_N`=cW09g_@9k
gQAoo`AkgPAg_@9cW0E_N`Q[FPQW>@Q[FQ5W>@QS60AW>@eS60aNm`9JePANm`9JeP9F]@9BU09:DP96
<@8mk`96<@92408aS0036<H<H`aS00@8@QX48@l8@RT48@Eoo`03001oogoo009oo`0067oo00<007oo
Ool0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03
001oogoo02Aoo`03001oogoo02=oo`03001oogoo019oo`03001oogoo009oo`0067oo0P000goo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol01goo0P0017oo000HOooo00050004Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo0028Ool3002EOol008Uoo`03001oogoo09Aoo`00Mgoo0`000goo1`0000Eoo`00Ool0
07oo00<000=oo`<000Aoo`<000Moo`<000=oo`<00003Ool00000009oo`8000Aoo`8000Aoo`8006Ao
o`00Mgoo00@007ooOol0009oo`@0009oo`07001oo`00Ool007oo00000Woo00D007ooOomoo`0000Ao
o`03001oogoo00Uoo`03001oogoo00=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`04001oogoo001SOol007Yoo`03001oogoo00=oo`0:001oogoo001oo`00Ool007oo0002Ool0
1@00Oomoogoo000017oo100027oo0`000goo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomo
o`03Ool01000Oomoo`00Hgoo001hOol20004Ool300001goo00000000Ool007oo00@000Aoo`03001o
ogoo00=oo`8000Uoo`04001oogoo0002Ool30004Ool20002Ool50003Ool2001TOol007Moo`04001o
ogoo000EOol00`00Oomoo`0>Ool01000Oomoo`000Woo00<007ooOol02Goo00<007ooOol0JWoo001g
Ool4000DOol2000?Ool40002Ool2001hOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.1932, -8.85118, 0.514055, \
0.514055}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Fourier\ Transform\)], "Input"],

Cell[BoxData[
    \(\(FourierSample = Fourier[sample];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[FourierSample], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCEFFFFADCCFF73C66BA0FDE0BF41FFFF68A097B2F4
86BC51736D94586453A88C3091BA5A68537E885C6D5F607A44775A577C706B876B369844
605B898D63458C675D606B844D6A7B7AAB4443FB67A87433FF97B18656C2FF59D67BC2FF
68FFFFFFFFF7FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFEBFFFFFF817CFFFFC6988292A55E4734612A2E2B27052D
1A1B6A2F3729350538291A360106253E0F44102B102225092F2814361304392236271220
193807183B263147481827222B0F1F471A3946481E3A162E5858622F609A7864F9FFFFFF
D8FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFC1FFFFFFFFFFC9F48B347EFF5E21296E80911A6A445587
1F5D113D3F4033545D2540285F643B6B2D6846344156511A5245344E271F572065183E3E
26690E3754375035542E506612236F3E473A388026594D49B01F70839FDFE5B3D8FFFFFF
FFFFFFFFFFCBFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF90FFFFF3FF70FF21A692BAFF9B4F4849FF3032379689437E3C
313A4F8A19587163154E4A526D3B29496F4B157C3F2152112C465A3C364C3145381B4E54
5D173C5224535F2C4B0B99411B6B3F6258477B41BB5D388942BEB03BFFFDB6FF6EFFFF9F
FF69FFFFFFFF3AFFFFA8FFFFFFC2FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC8FFF4FFFFFF92A0295D7A6C2B854F340E7353
324D1E341C08654237294B11162428321B363F2135241762220A39341F40340622553825
461C373D544A2A2D41230E1F1C39302E59424F40900D3B5A4C847F667F57FFC170A4B3FF
BB2BD87DACB196652FFFFFFFFFFFFFCEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF69FFFF6694FF9AE8FF81CF95E74E53475549471B4E6A1E
3A0E570471392C474642130F1B20342E24160E390B2C1D141E250C191310150610400C20
0C1B3F2938573A34121E1C312F384B262346412624633B2A446121274A9D949A785C306E
916272F65A66D4A4FFFFFFFF83BFFFFFB8FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF1FFFFFFFFFFFFFBEF3FF538D625EC87E564D4A7725
2A3A29551D303545260D3D201935213A0F1235343A15534402283542044714283E136438
201B6D3F5941075F254A40121E3562406159287D2836443069514C39625259422B37EE25
96DA9AFFBCE7FFFFFFFFD3FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF67FFFF5BD1FF5FFF935796C4FFD66346661C654738
3E2C44182F5D070B231A40350D192C2817302B173432231C1C1B2D2B03494B21272A1536
0F2933314F130516243B293F1B1B29083F4C4A202B372F5C3223383C562F76CCB2D4CFA9
AF6483FFFFFCFFA3FFFF64FFBEFFE5FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF28FFFFFFFF78FFFFB5FFFF6B7CFEB675734F6D873D321016
2D201C3E5A242D1815151F1C36290C35031E1C25270530341D3329251533252F1E2C3430
320C0F252F230E053B282C2E5232263C1E121E10514237311D5F2156124E7459B6B3C386
FFAACAEA93FF905EFFFFEEA6B8FFFF4EFF76FFFF
FFFFFFFFFFFFFFFFFFFFFFFF59FFC5FFFF62FFFFEDE78734A19A60A7B01EB769332F0F04
3B114C1048211D12061E061E173D132E291B2A245B1D2C181F130D1E2F241A2731141315
0A281E194E1C130F502323234A081E46282D16045A451D472D9A5D47461DC060749E2291
B5B881A3B16AFFFA99A2FFF5857FFFFFF8FFFFFF
FFFFFFFF0DFFFFFFFFFFFFFFFAFFFFFFFFFFFF7C844958FF794AD0AA882C42350B287C32
262231192E493A234D21132A31261C0B1F34222B2419381A141C5713181D4330160E1406
2723283735452B471829051F1E16182027401933431F2B2955204A1E2C592D3132A8FFFF
D04A778248D5C9E2FFDF7EC9DE12FFFFFFFFFFFF
FFFF7921FFFFFFFFFFFFFFFFA3FFC5FFE5FFFF167FA9E28023486E439C5554404C5E1223
50563C150A4A1A1D172727302B29200E3517363E081A282922231A370E361D0D0D2A2330
2516382622253D38193A1A37173519453423212C1155324C11333A5AAC7541869FB55D24
524ABE3D7BBDBB85FF935AEFAAFFE1FFFFFFFFFF
FFFFFFFFFFFF94FFFFFFFFFFFFFFA1FFFFFFFFA4EC85AC7A52B828463C6D5107230D0E4C
1C3C0A1C2B0D2E360F1A171E12141F36201A0324130C302A1D2E18321E092C2F0E161533
175D371F1C11213608203632141710193B4A27291D302E19395B182C11478991593E4A89
4A186FA171E3F396789D8895CDB6ED59FFFFFFFF
FFFFFFFFFFFFBDFF78FFFFFFFFFF65FFFFFFEB9FFF912E38AF4E8619635911160C2D1830
5A2421284026280E25021D332225340B3B281408311A144021192017252E231E19271721
200E0B0B202A1A2A233B240F0E1D1B362A162F2C44232A1233450F52345EA86A56432711
954667AEAD13CEC09650B0446DF977A5FF2BEBFF
FFFFFFFFEF83D14996FFFFFFFFFFF1FFFFFFFF39A06E92519F6C35446A1A7C42463B3621
1843492B215009132607282823260C32280E2953072538281915142A1932331D21293912
1E2F3A342F0E2C0D13524B11451E1C1830461A19193D3D471F4D372768122E3B19321565
837227BB7BB22EBEA674479DCB6BFFFFB7FFFFFF
FFFFFFFFE2FDFFBAFFFFFFFFFFFFDCC5A0B7FFB4875DBC4714404B1B6A464D593A1E301A
261C310316232519231A4213160D0D173C131627282615230B3913252223140612271415
3314331510483E4933193619072424130F3B3A2729013E27345947212A2D0F14404C1B57
5F2CDB3750B14B33947D3394A0C0FFFF12FFFFFF
FFFFCA62FFFFF7DBFFFFF7E6FFC2FF6AAA9E766D6B8A3E6312443C182F5F771F352C2B16
173808122A1A092F1F3F23080F11230E32361F161D140728252C040D273D1116203C1C1D
16183221281419051D0933192E0F081E1F1E1926184C3F221D0D353E35256426164150CA
3A533F5B6866497058796C78359DC1A0FFFFFFFF
C5FFFFFFFF98D9FFDEB6C0E1EEA6FFBCFF1AD329C66B445B3B4C20302820724143431F4B
2F1821064412372141293E242C3816071C16191A2510220722261F06451715143C212E2C
230C2D14253718193F27211C0321202B312107133A263444143A12040727273748294D31
90AA407EBBB24A54444B9D0F44FFA98EFF9DFFFF
FFFFFFFFFF7E5549947A98E893FFFF6DFF3082A36B6A5227886F2A102F272C33632B1940
174E2E464717180E1B2D302514212F04192C100E0A23311B1E0922300905373213164516
16071A1F3E173422193C17251E083341211A261A2F272B20367644592C1A6159098B9144
7724118F6D7A566D58031F44D4FF51FFFF35D1FF
FFFFFFFF4576229AC5FDFFB9E5FFF9AEFF36EA41784E6210115F36301B2C1C20490C294A
19152D271E2B2B1E1512130D2311221F3D2211321C1114130E1B2214111D22002945021B
3C1321262022310E4816133A0C251634033D142820403A250F402950475A2D4031814A7D
5848965A4382536E35232D78F144F9F2FBC2FFFF
FFFFBEC0FFE358C3FFFCAE9BC5FF82FFC3E9AE697475483166253B3F291C052C2A2C240E
210E21242553110C130C26232F271513131B1A1E260E112A2A1D032C220D15121908172F
191216121F0A38301027154722032B1A1E0F153D25092F294B2F2514733F245D82294B9E
4F3B2D4A3449479E08195C99765FB2F06FFFFFFF
FFFFD3B2FFAA9CFFFFA1242E6EBBBBFF67FFC759587B272E0F1E174C192B4522281C321D
180D0B0A29121016261C11212A0C060B0B1A271A1D0E1925110F131C2C270D063420281D
29160C071A1E402524231223112229183822142A033D182C2433120A435E60626415154B
015A0B3C6A5842333F45843C589CD1999AFFFFFF
71FFFFFFE942B683B77E65228D56D3D39FFF64B85A702E274D352A4D2A1A192C31420C22
3E53103C1F1619302E44182C0E2912173A34202A0D09062C0E24153B220E11141B0F0B2E
161B1D29202E0B1A2F1538260A1C1C342E3A342B35120B0C2011257337103090440A3D19
1F1C4350355F4D62588C725E80FD8D2DFFC1FFFF
A5FFFFFF402D0627D1DBCF60AB59FF8CB4FF67E2294324452D230D35453D192642361313
0E2E0D27151E1D1F1D283A241B1A1C1E14111C0C0E13150A2614341322221A1A19312206
0E33191419292C32212509251320131B310C2F1925521F0D53203E5A352F32324D404526
64058A320E7A381C685B3415A1D7994BFF52D3FF
FFFFFFC8AB326F69FBDA52B15786C74BD48A92CD3181111D444326612B2027050314103D
2E1C0A2A24254510161A121C2330251D151B39221E2B1A1E1B051E17092B100A33130622
08380D221415143D07250527072B0709152E1729150E2351222725293E0E2E1826094046
481740214F8222385E4B454594867456982A8EFF
FFFFEC32E13F3BD1FFBF294D8686275CA312DDE681632B264F36302A1A611C2E0615250F
1A0B1D241428173C454414180D140F0E1E1C29062534120F27142E1F192511131E031A0E
091F1E041A13210F0F2A10180601131D2722332817221D2C162E311847083A3E39532E1C
2E4945194D144A57592454548062826086A9FFFF
FFFFF550FF1B359DA26B370834144DBD4F59FF4FCE762B3A2D4B3B0B211A1041351D042D
1A1D05162221181D0F0C0C3C180E19101B08171C0D1113052D160E083A1F0E211A120E0D
07122522141D2B0F0223221A340B23110F210E1E0C15382330273D291D07411320330856
20463777574573590A58791F1DA153185DA5FFFF
72FFFFE3A8874A3C7F88688F5242A4C117A4B64E94485E1E28501E641B2F283B04291B3C
225223092446341828192A0F2C211B1D17090F1C0D260D0D160E0718131D050B0E091A1C
170A14160727070F2E16332B1C394109140E263C152D1E24242952282F1E2A2448103014
0D4E853D194B4A1170283B275CB11D64C2BEFFFF
B3FFFFCF7E42392592AA6A716A1CA86330667163724E375B21271437281A4B512C0D2823
03262B382D1D212A1B052C2C231A06230A17102F190A091D111C1E1722120E13001D3015
451317041411042206132720261C132323130F1D2C1414372A1617382B084D173D114B47
47184426244D09534821554C5C682433C175FFFF
FFFFFF8D655E515D8BA93B685741274D58863B8F2B347C491D2F4016283812150F3F2728
2D1C301B0F17140D03100D0E271E22221910140C260926051A26183D1E0E13101D0B1C12
0C2E0A2B2A141921200E0E171E120616101C0F0C35115235342614150C031118161C1F1F
46571636501C4155192052224B1C3264928FCCFF
FFFFAD48AD240781607135383126284C7C0D685A3F70523B1D4F371A223132223314260C
0B281C170C1E1202160E08171F0A15191625090C0D0A25312139072E0A32151909172414
12191F0A0B2318252A151023150B16131112192A27141E31280F01341E361D340D213B1C
26761460222E5F6F05240F922944554E985BA2FF
F1FF8E837B3456582A283C265C344879454D67367676244D2747234D2E1222141A1C2417
370E2900023A0C2222230B2C15142507142E0A1D02050F1B2414090C20091F0F12061311
110E1410033B090911240F250C0D171C0D191D1212251B0B2C11110E2A043207261F4223
4D42433D54385D5251214A1C327B2E9AC0ABFFFF
C3FFFFA3A36B64623C04565B601482A248536C3E8C21512A2857143A3E053353154B210E
2E0F20133309112F24152211151A13181D0A1D0F14170D0E0D0B022B12100C2F1B091118
060A160214052B201705052410182D1A21350D0C18130642070D3F0E2812370E1B241831
1326541E133C421C5C4F23395A325930E9F6FFFF
BBFFFF6D7058584431362E1A5638256753611B5F4B1E2D163025272C381F212F1312221D
190A080A193B220C18271E220E10150C181B2307111010201206301A0C2E161716290807
0C1912081720221E063D1B112F04222703232620221E093421151424241F0811161D2D7E
303C39203E19532A62252B232B3A1E1AB9B8FFFF
97FFFF7784472437432A352C1F24124B2D1333751F74263233012B1B202B071138111B19
21333B142907391D2613271D3A2C19120D1E1D080B2317151A0E0B390B1F1F210824270A
121C34200412270B1E1C251A1C0A1A062434300A15342F121D2018303713112308201D01
186616584C195E4F2B1F2E45214E0956967CBBFF
C9FFF37C6B2D3263441D3839215220492A093C2E0F840C0D570D19171522131019222E28
2F2F1D072B1E35172A152A18240C1F140E1912090E0C1317160F082A1F05091424140E22
201C0B20192503121D23290E0709242D242D12340F0B12243D0D115807302D16191B1C33
3230573346403C6610124E313672237C5C25BFFF
ABFFDE99844825330C5D1F652C59322C08384D321236314B1731182016151433110A1227
26241A12040E1C2808210F2204152627051C0D100D1A1D1E1D29110E16241F0F061F2644
060F19381A160B2C160C0E112023121910280B1B2D03133824301F2C0B2813030A081517
2C1D3D2724452D062A4D21174F3D22518B7AC0FF
ABFFC8884652081B22290F504A451B322D2A172E361D10542F2A2D1026191835160E0F0C
2722051D063722271D230E2D1A141020281C0F08360B2D0C170E1F17220D12111508161F
0A140F230F1A160F1519110A312C1D2223261713182C2224190D272121361F141A2A3327
130724223E364C1520313E43303C2C585D51FBFF
B1FFBE9C8A271E3726233D4927121D3727353D3B1E1B3D1A0C29060A170A17181F1B0E27
2A090E0D18110A091505142C2A061D1F181B0B2F0C0F1E0E1113091C141F182116100417
18050921180D0020260E2718131727100D181126270F0E04010F0E100E0D34100C18202D
19231018241A363B29333C7725472B2B7072E9FF
8FFFDC52550C654C2925340C18283838313827231829461C2017131E23340A1D3714190B
06110403020D141F1A30303520141D0D162429200E0E1C240D1415252015160914152B29
07201F21123120222111180F0924080704091F19111D1D0E15222310261E15300C122D2D
1A2A02454F364D241D113D422951512D5B85D3FF
B6FFFD39642054823661213451323934151B492B1A131C3215271C1C1719242B172C1F09
292B1F08200117011815100E0220150F1D1724161E24111D2119190B0F0B180C0B251611
1B1D141211211819150C0C072A07211E22180C052617180F22251B0F05110E261E3C1129
060F30473F364310132C3A271D620510AA52B7FF
DEFF9E79593A484626493D3342133D25362E271E12360A0F24261B1E162116181C112E13
18131B21141C06180D100C1B171E0F0B0604112412050911251A111E1E281F161811090B
16150C220A21190F1131190F1A171B1426160F0D09261C0C1F2C13110F16212E0C2D2021
000A2C2B264419321F262019134B341B9535A5FF
8EFFB95987611D454D3B44532D211E352524051A201717421C130A190624050A113D1927
0F2B0E14142326151B172D1C2C1E200422261B031519091C1F190C170A14250C22170A1D
0D0B30160C1A14140B22061C0A2310211C2211142115291A28110E1C4123153912142D22
021B2F0B32221F342B2D2233322B28236C5DB7FF
99FFC86369502E1E4717441E1A191E1A2C1D122116192C26481F0F0A1A0C290C1D232B1A
0E070D1E1B0E1F0C13072322251C09331926281E141519281C221917220D081B1F0A130C
162313110F1F12010F0E3611101E032C1817152B0F322228050E1C241110340B18290D20
2D13331C1F1B23331516543735281B147684DFFF
A3FFD1976B0D2D270A2127182C20072910481A242521333712272E0D3029060B230E0A22
0C211A11130E0A2C06171D141A131E1211271612181911140F080C120E12241126090B1B
13190D071D0D1C1E0D0A1D121716190B12290E0C25161C071F3B1B1C0C182E170F102120
1F21122A161B381C23281234132F28354F9FCFFF
C9FFD7416F20183D21390A1B2A242A09171426322A0E0B331F22150E211817221227281F
1B191E301C2C1C320B1D25170E2A1E18140B1B0C1A0C0F0C0E0E0D0F121916181923090B
0F15101C1527131A131711200F17161D141C15231A1720260D0F26340D09120C1E191F28
4F324B182210263B2B1D28223B3C243D8B63C2FF
C2FFC1547D381C25322B2120124F30241B22252E19171836321E24140806023716132E1E
1211202B131A031709111D1C0A06050411091816100B152E0E091B1110111216050B0E1E
0D1109171811250704160607091A140A0F03111B1B0A0507062224393C14170E1D30212A
162202173C130E1F1221521E086B290F9454BFFF
8AFFC0685049332E1420481A18491E18051D2A24051437131B151A2616082821211D1429
07262D123A1C2A0F090F351B1F0823241307080D09231315081C170C0D0709100C051513
0A19070D14261B0C1B1828241D11071025151C2F1721292D2D2C1725151E221E0D1C151C
0F211A19282A251A253D13220F332C20555CCDFF
68FFC95B7F47361710282B3F101C1F143D052C320B2911101B180F1907021C0307200906
1B2C061D2923291C0F0B1B250E0C130919090E09090A1F06150810010E091D1112222717
0E12110C05241F031E1D2D180A1A12222E2A3131201D22201B0008120D38061D05184216
3516201B0A27250E35540D08363E3A285E5FAEFF
8BFFB6456A4A231A2A14232E301C0E0A101D2A1F071A1E0E2F1626140E1325190D0E0B11
1E0F1D221C19280C1C1603134F0A082913090F1D142615181F0C122313042E1D09140F22
0A030F0A0C010D082012101F1B1B0B290E0818301105301D1224251609191B14203D1B16
161032102D1538292C2335402F10233E6265A1FF
83FFD04B791C1F3F002B3426262E31051533173A11142B16070B0C0B101B23101218060B
1A261D1A09081836031B171F030A0625151910170607130F190A1C170819260803091E1E
1B0F19121C06150F1B24232C1A250F18192606270606191B1613130B161C2C12051B1D2C
1B0532261312150C1E133C2A21092C2A796094FF
9DFFD65C771F22341917370B24450C170F371009111D0D1F1B0B101E160E19060E200713
150F31181C1F0D0B16063009202E130C0C18100C0F170C11221208151A0A0D221D180409
180C031128121E050F0E0A1C1C02181C1614191514241A330A13182F2318241F0C470B15
1C16242A21331E0E061B23191F3F26258D51EDFF
92FFCC58793D323D2E252834061A1E1C1B041B1F010C1D28161B2D0E3D121B192611091B
112613120C17051430071E180D2B2917120913091524050E1B142109080C1F0E4915220D
0F270D060E0A22072B2113051C20192506081D0F2723121D1F212B0E0D191C1A15001829
1E0F20052231350F0D2B29191F372C335861B7FF
9EFFBC5668544C3816490A1C2C3513121E0F292218151A191E0A11191D211A03101B1E21
250B0B14081F1B210F0F0A1C140A252E0A1C0C19050E0A0909160E182715050E0B120A32
041816060C122B0D24171B142E0F0E232A11251A131511031928140315190C171E141317
1E1F110E2620112027091F211024412E576A8DFF
87FFC248532B552D311A220F3328182636111F291919441F330B201A151816060F1B2724
1817130A051E120A2C370D20200D0F120312081E1D120C082212260E0D0606090E190519
0C220B2B0F0B14170B0C0718110F26140F152C220F15052139161F2012210C120C133B29
1D171F331421133A170516151C49371B846AC0FF
A6FFBA5B722C474C100808174F37212D20241D0B2A13061B161F092019151A05211F231F
181C07241B110D1D08170817151F010A171437101E16180F0B19150E1919121012060B07
0C0E130F200F1B071712132E1713280A22150E0D1F150C1210032C21210625151D34230A
341F3829012E013634161D26202B240D8461A7FF
9AFFA7685B2305501D1A241950353535110A0F171D19080F191321200D1D252D1D0F1309
1D13133017301A0C111B2C05171309140D221419170A0E1610191912170A0E0A1016100E
1D231B0B140B1F141920140B121212071A142C112B1424201618310B1524130B1134191F
300E2B0C111C0818281638071845441C8C6AABFF
84FFBB327123033B3630320957282A0920251B1F03070D2814130C28101C1109081D151A
091B061F14271514041C110D20071E16171E110D1A122F0B041D150D290218222B0B1B14
1710092005221507050A1B19060915040C141F190C0D1C2B171A11110F182209131C252B
211A281D27082028113F27432C5525446056C7FF
8DFFAC67621B122A2B2025193E150E182B3319322322193012081D04110510220C251713
081C3A121D0F0E121103090A270F07220F110913101C1406140F1329110B0D12100F2018
171B1D27131B2016231C1B1E100C090513211D0C171B0F0A1B13240E0F18251806113D1C
192C241F1B0D302327211C481A3432385B32B8FF
71FFB165750E2B25182B1C2812381B380F1B0818131A1F14121C230C2323181B1A0A342A
10292C1A0F231804282515142D171E122020200E141C1D1E042720230525140A071C170D
16052413141F0917110A2D08101F0E1D1B2411180F190F1A181A193D0A22071F232C132F
39331028171513392110154B2D25204D4162ACFF
94FFB6577F1C3C4D1C0A1A1F1F260E533E1D1313201018171C2918262514182B1F091A21
19030E1B0F0A170B1412081501181F1719191B141008161C0A23211013132A121F0A0515
120A2D151B081D0E1422211A2113080E1314051A0E1622161A160F140718231B211E1323
2F0C401B2C3431270A0A510D24661E407F6092FF
97FFA7675439274A162C2E173C2515333C151E2D192425281E051518072926171214060E
0B0D0F181E1220071C151D1A1820071A1223320C111C16161915031A12150F110924021C
170203160E1A08151F140D000A141B1D141019341B1B0E10021B171C1C1514083634031D
151D203A35410E2F070246160F2F2229532F8CFF
98FFC380512D233C202F35201A3B1D262C17160D241C290E20050C1331261A1100133D07
0C030914101A1A172E0605201318130B16141A1410101C121D141F0F2408200818110821
160C08160B211A190D0C150417021A060814180F21040D05261A2F3337172C2119292C14
1F181732041D141F1E221C4F315A291B6025B0FF
89FFB0697125162C1E210E28112123212805221E192E16300D0225251F1E1B29101D1119
1B2111362E1F1D220D20170F141A05071017031A141725190A151A0C140C1A150A192517
141A03171007051A140F17200D221D1F2E3611211B19111D10291B1E1F2525020D30162E
191E22052821232111280E211E2C16257169B0FF
98FFB025601B295A314F1C221E1F141D043217181F142C2919212C1737332F1A26050D04
210F181408061A021704150C0D191A210B16080C1621081118082008240F1F141D121C10
10141A14160B1318132005062E171A1A101409030C073D1300111A2631130C05200E291C
240D16172C261D3B1A20352F203C232D5180C3FF
97FF8C2F5329222F0F164602072F0E41353A201D151D0334360814151C1C171B02100E1B
1B341910141D1B140A000D141F15081A0E160302171C022409110F15121A03151916161C
110C3223121A0720181A1D151C0720121E180F0D0B0E061412172629071815051E282524
192D1E153C3315253C172E2C164A27395467A7FF
94FF92607F401E66240D510A0A2731342C1B400C2F23131E211B231807140F161A162216
0E1A0514130E0813211A2122140E1D081B152D0A1215050A1F122A13131021230A1C1608
10141B1919171F1801150812140B170A0F1B0E0319211A091F2B1814252618291C171810
2013131D3E530E261F1F1A0A1C4D3C1C7F57B6FF
71FFAC62414D20252D4B15102139131517281033392F132C231F07220A3D191A181A0F19
0F1811241B1D0E1F10082D0A1117091F14132405160D171C070A142505232027041E1D1C
140E202020121E172D141525280418230F1A2C29102A340A1A1B1823230C231C12141F1A
1318081B0F381B3812281C2B18252B0E7565B1FF
8DFFB8325B3832341A481C212723300D1B1F242C191C3D11061825180F0E24131B0A0F1B
170C1D211305090C101E1B1C2316201B13271D1B1718200F10120D0B1129130F1406141C
101309110F22070F270A090311120E0F1D123A1C081317250C22100511041D0812301922
233219332B180E153E1925202B2A121B6267ACFF
84FFC756604425552C43273F11282008271D281A212B251C130922180F11111A172B1C0D
0C191F140C04150906191B0A050715220520091017141B0B2B221802290D151D040B2F12
1A0D111E17161E07200D111C04141527141F061B091A151D0809111C10280C1314280D07
031F1B2520092A2857093230363B03237132BBFF
9AFFAB6A8C1C4445180738162818081C110C2B0E301F1934110B1324150B311816202414
2B112C141A071212120B142019141F0B140B1B231D0E1016100A0E0A1712191910160E0A
171914220D14091317052C1B110C1A30173013131D09130F1D2D251D0D202113190F0819
1D170F0A113535355019241A1D5005235B68A7FF
A6FFA761840D242B20261D163436012E0129381F340A23341D15250621212C0310120C15
1F0D0E15220A2813172E131217071B0F200F130E0C070B0612101219190E15190B0F1816
1E103714170A011F15170817081D0D111B24071C181F231F21051A151920091F161B0613
2A0B1D24202D21374F170808104C472C725BBAFF
87FFC06A841B37491C151605173A132114331F171D293B130C120C2112201F1639210515
0F222C150F14260F1118070C0B17140B0F2B0B220C1905190E0906060D0E261222080C12
1D1E081203120F0D20200D372C0A121E050A13171824271B0F061618151A200B331F4419
19291F1136261828330F221A312D552B5348C2FF
9EFF8D6A572E412410211F0927201120260E111F1E1713141E170C191503142819031115
131A25112A230E0F2E141B17240D2B120C06161804320A120B0E051527180E1609090A0E
05190C1C0A2E250A141C0A0F0F211B1F08140B0B25211E1B10031A211D19110A1E191A15
1822290F1E1213352C1C0A4916384C546856BCFF
92FFB76158332C371F19292B0D0F35312205200F1E291800151A1C190D0E2B211F1D1223
270F1D08062519201C0513212B07220A0E060D270F0D2215490E1F0C080921141B0E0524
150913091217292B0D181E07301405170C121326111B091126191B123D0E2D1B16281D0C
011F1B041B1C1E1A063428252E3D323D7958CCFF
9DFFED518D25263F1F19231B060E1E33212A24161C150B470C1F2418232F18130A331A24
14151914161C18021C1C0A0E0F051E122811030C180904181D220D0A1A15081222110C17
0F0C10180C0C132E20093006160B0D1F1C18310F151307200E06190E161E100B1B1F0D1D
110910370F170C45240B37171934221F775CD6FF
83FF9460792A2C09212A3C131E0C1512132632051B2C1D1B05122C1C160B1313161B1906
0627062619180F251A2C23241B0F15061C12190F1B1E1E090308261908171C0A190F1307
061710191525060A031F171B03361808091A1D261A0B06181210231B100B0C0B07162B14
113A17331505312E2626342B003F1F1C794BD0FF
8BFFA165623E23102F4035232C2938152D10321016161B3D20141B1909162524121D3005
113018080E290B1B1B1F101220080D010C0A0F030A220F14091D2E041323120C1F181526
141D0F091329080A4F1303161C0C28191C221D0F1E110B0E0D1925130E1426162F0E1E1A
071F2A1D100A0E1C302E23142A1A234A6A45B6FF
68FFAE5F5E283A3E36080D54350E25270A1B201635164218051D06380D1208001B20221D
2031312A2E22121A0A182D1D1E031F24050C11120E17272212111D090E01100815061F0A
09090E091909130C0E251B0B0F1C2923291D062C1B06092007031C0207190F181B101129
0B322C053D141F1C103F2B28101736477F5BC9FF
8AFFCD5C55202C330F22133D251A252A28191A210F1C151C0D1E221E1525172C2D2D2921
172F1C15251007111D2428181B0C1B26140D07190A1315050C1009070D0C171C08151323
090D0807132423081F1B350F090F2A1C3A122D260729141D2121280816261A151B133714
05242A1D05181E49181A4820142E33495068C0FF
C2FFBF54940F296B081E5221121F0E133C170222162A21301D0E17143C3924220607050A
1B1B11030F0A141A0907061604072511181709110D1E0E0B0516121110111B090E2E150B
10161809110405060A1C1D110917031A132B2011121E2E13163702060814241E32361817
192E25221B24304F1220212B32251C387D54C1FF
C9FFC2638B3D243C3B22281D2B3B261022184B324F281F191E0C12090D34260F0D262017
1A23151C141D16170F201117131A1327151C10150F0B092319181619120F0D0E0E0C0F0C
1A0C1B0B14181E2A0E17251D0B321C2C1C301E191B1F282712221718210E15221F330B0E
2A32261417092A242A1B0A39213D18206F41D7FF
A3FFCF9F4F35282F13341228231C381B162A12211F2021100F172E180C1C1B3B1F071C16
250C0E29120B191617121D0A0D1E1C0D1D070D19131B0B09261124120E120C080F141119
1812162711121E131A141D17062C0A0E13111A210C220A0E230B0629300D2E2712373321
25241A48102907202C1827210A272D0D6B97D1FF
99FFDF8476141B28353754161533231B1F1C33132D200D29180B341011241C0E05282232
0F2B1517182C031E1011360E0F01121F0F111323160C130A1F1B080D221719221C281915
141E28261933091C25222307130C1F0E1B1E0D070E1A2B231D0C290C1A0A0F1F48262C19
1621121D2C1A1E191A1E4417471E2E506963C8FF
8EFFB75D6C23282B3233222D2B341F22320B2F1B02222D1412391523411C0E11281A2915
211411221C2110230A1C06220B14141A0C16300B0D1D0A17220C25140A170C191F1C0919
15031B262204201E2C1C2D171B15262314140E2B0F27193D110A052406190A131C421717
201A052425351E212D53443B4D451D618759B9FF
DEFFA535951B344B131920261F321944262B2C0A0021202D0C2E21160F11132C1F0C1C26
090D0F1626141B171A0F1931110F19210A220C15160B091118161F281E1E111A25110905
12241104060B0F1E171B0C100D18061C14211B1318132E111C181621161E1B26240F0A36
121E272E36253D1342333D492646483A59799EFF
B6FFB752AA1005621D273A2C131043363F47300F0629113C1E260E11050F1B25220F1817
26050C18221E21072A070C0C151918211112141D1B1116250B0C180B0F0B1919211D1124
1E1624171D0F1520020E10151801170120081F2B29091F2C172B2419171C1C2715321C13
1A2B491B1534393251342161368254206439FDFF
8FFFD3855B2D515129423D111D244D364F45022A1A2D2D120C30151E26102322150E1D1D
11191F0904070824090F18112122203112211F2007292B1514091615202515140D241C0E
0E202924160D1D14203530301A1F140D02030411060B1914371D0A34231E1317201C4629
1823273831383828180C3425294C650C5552DCFF
B1FFE972702B2B4725773C33293B361A24181023192D20180C10340D0E100E0F01040E0F
272611180D1027171318270E2620000D18210905181704101621181F141C0913110E1E0F
0C2F0B1B181F1D062A2C140515090A11180D0E092A270E1B1F18170A170A06290C1A3D1B
1E3B3D3527371D1227493D2326371E278A9CBEFF
ABFFFB515D582C3C30433E3120154C363E2224071327332A1A141F362121270D1924222C
1813172623221D2C310A1119150F161A0F230F140A1F16081511120D22171F0E170C2D0B
36080F1C282010141A2D0E231D272237061D0522270C0F0E1635181926102D2A2F54101D
362E172A2D321B454A500F29221B08524688C8FF
ABFFC07A8B51223D4F17214D2A062D4524273D1D2C1715080A0313280B2C1F3024381303
2D1B0B281019122320110E0C162C0B161A38190F0644261F060F1F24160E11291D1E1D1A
0D100D1C0527261504220F2108281C0E04121A242627120A1133141516201831174B3136
12324D38082C32592C651F5D0C3325488499DEFF
C9FFBF255C7C237236314E1210663C404633573032331C1B19162D300758110D3D24120B
0F34122D242D2409070E29231D12032519200B1C20220E14241409051F2A080F1617130C
0E0912190E141F0C24182A152A17351E2B071D2F2F282E22191013221517190D570D0C84
0F2E3C092A4920522139381D4463322D6B7CF3FF
97FFBB7C9656094E21452E1F2B4F5E194C58166618011D2008231113373018201D122F34
150A303424061A0A1C1A251C1E0B27120420341C120A272408211F1F0B390B0E1A151723
0B081D1E0D12192C3A1D2713261D390729143B3321191B113811072B201B2B0133322674
1F7533132D4B12241F2C352A433724478477FFFF
BBFFFFB8B91A1E3A2B232B25622A53193E20393C307E2D1D1611081F242414152134091E
22202623032722042F111B3D061E2220170812190C0708291617162E0C1A300612201010
1107231B180C15100E221E27180C223B190A080A191D2212132F211F382C272530162D1E
4B5F1B6153672538561A2E3631445858706DFFFF
C3FFFFF6E93059325A39234F5C1C423C131E5426133118241B0E3712280E3F0D07420613
180C0D35211A2D181024050517202B051402160A061811091B2F0C10122B020B0D0E0D17
140F1D0A1D18131A15112215242F11093313200F2E0E214B155333053E3A1457282A5121
8C3E6C5348A28214605B56043C62646BA3A3FFFF
F1FFFFABC09A2E7B321C4A2151525D38543D43424D23421F260732042A0E11112C0B1B25
12121D190D1C170D0C250F241109093B0310140E11111306120F1F09200C0914241B0F05
021D0A2E14072514152C0B2322220C3A0200290E3717241C1A1422122E4D2347274D2476
7636674D457948345C263C282A5856347B838EFF
FFFFA25B984E554429920F24056F5F2E22601476261C3B210D341D361E34010F28311E14
272A19121113160B152310152A2518230B0A1F1912142417091915320A2E07392131250A
0D0C09251619150A1F17080E1602121E0C171C280B0C261433223231221A374F1D3B5270
3F5A680D7C4C28263138357160810724AD48ADFF
FFFFCC8F9264321C4B2252201955411C50361657461F1F1C161811030C15142634355211
350C0F1C101606121E170E0E202119142A2B0A2E0C121C0B1D10130E1E3D18261A052609
260C14101922221E270E0D10030D14170F1B301C2D28273F0F1512382816402F1D497C34
2B8F3B86584D274157683BA98B5D515E658DFFFF
B3FFFF75C13324685C4C55214853094D2426441847474B113D174D082B3817162A371414
2C1D0F132323131C2620271306220411140417134515301D00130E1222171E1C111D090A
192F10170A23061A232C2C051B2A211D2D382B260323280D2C514B1A28371427215B374E
726371663063A81C6A716AAA922539427ECFFFFF
72FFFFBEC2641DB15C273B2870114A4B193D854E0D14301048242A1E2F28522924241E2D
153C260E140941391C2B33162E0F07270716140A171C1A090E0B051D1318070E160D0D26
0D1C0F09171D1B212C0F2A192818344624092352223C1B29043B282F1B641E50281E5E48
944EB6A417C1A442528F68887F3C4A87A8E3FFFF
FFFFFFA55D1853A11D1F79580A5973455777374620560833201341071D293D2730233815
0C1E0E210F11230B341A2223020F2B1D14222512070D0E121A210E1F3A080E162D051311
0D1C17081B10190E183C0C0C0F1D18212216051D1A2D041D3541101A210B3B4B2D3A2B76
CE4FFF594FBD4D143408376BA29D351BFF50F5FF
FFFFFFA9866082628054542459574A144D1945492E1C2E53393E3A084718312E162C1D22
17283322271D13010618102A0F0F21131A041E1F090E1A031E131125191F2E14270F1234
2506291C1E0E0F140D181444453C172814241D0B1A0F2515062E1C611A2A30364F262B63
81E6DD12A35C2786864D29BFFFD13B3FE132ECFF
FFFF8E2A985674869445454B5E3822824F2140174846400926182E0E3E2925272251230E
1529172E1509072B07270525073D141514220D3808220613330A102B09171E051B1E1A2B
1E22391B151D2530231C121A16104525242A0A1C2E3D1014030527202B612643441D1181
31CD928AD44BC78657B152DAFB696F32ABC8FFFF
A5FFD352FF4B99D7A115345B681C387A0E328A05642645404D32322F355A3E20530D1F52
25192F0C311B13201325092521322C29191419330E062231191A1A2222133414260A1513
0E0C1C11141E1C1A1B243A281D1F1D1E15270D2E0E1313364226193D45350D232D452443
29E267FFB48CFF59AB60CFDBD127062D40FFFFFF
71FFFFC1FF2D8DFD805E728C58624D5F3550431C1F193D0A4490301037732511200C0B12
352B343A2E341C1C0A2638152F1A0B2E20291D1B162E0B0F1B14110E223B15240E2C0609
0D2A20343A1712290E2C18442E3019161F3C10533E220C42312C191A2A4D2A354D272E70
5AB864FF9FD3D3568D22657EB783B642E9FFFFFF
FFFFFFFF9A99D19C583C84453F3342586A3C0B5A014B15156462605E430A1233242C183D
032A142238182922112312232425401E1A070C16291D282034060D272C1C130F1125190E
1D1A271A0B0B060C2A21111C26161012290A0B0D181D321C2822452B194C171E0F2E277B
5859C7FF67FFBBBB6E2E24A1FFFF9CAAFFB2D3FF
FFFFFFFF6FF0B25F76995C19089E4749344A2D3B4F9E4B29825D243F7314252F4B292F09
253D150F1E1A2B03224715271030380A1F121612192F17081912150D222C031D2A2A110E
261E1A1B131315272F23260C130C11532524210E210E242C2A2C051C293F3B2566314875
7469AEE9C3FF82FFC59BAEFCFFC358E3FFC0BEFF
FFFFFFC2FBF2F944F1782D23356E5382435A9648587D4A8131402D5A475029400F253A40
2028143D033416250C3A1316480E3122202621133C1B02452900221D1114221B0E131411
1C3211223D1F2211230D1312151E2B2B1E272D15194A290C49201C2C1B30365F1110624E
7841EA36FFAEF9FFE5B9FFFDC59A227645FFFFFF
FFFFD135FFFF51FFD4441F03586D567A6D8F11247744918B0959611A2C59447636202B27
2F1A261A214133081E25173C192234173E1F1A071616451613323705093022091E1B3123
0A0E102C19042F211425302D1B0E181747462E4E1740192B63332C272F102A6F8827526A
6BA38230FF6DFFFF93E8987A9449557EFFFFFFFF
C5FFFF9DFF8EA9FF440F9D4B44544AB2BB7E40AA90314D29483727270704123A14443426
3A130721312B2021031C21273F19183725142D0C232C2E213C14151745061F2622072210
251A19161C0716382C243E2941213712440621182F4B1F43434172202830204C3B5B446B
C629D31AFFBCFFA6EEE1C0B6DEFFD998FFFFFFFF
FFFFFFFFFFA0C19D35786C7958704966685B3F533ACA504116266425353E350D1D223F4C
1826191E1F1E080F2E1933091D05191428213218161D1C3C2016113D270D042C25280714
1D161F36320E23110F08233F1F2F091A2A12083817162B2C351F775F2F183C4412633E8A
6B6D769EAA6AFFC2FFE6F7FFFFDBF7FFFF62CAFF
FFFFFFFF12FFFFC0A094337D94334BB15037DB2C5F571B4C40140F2D2A21475934273E01
29273A3B0F1324240719361933493E48101533143315142712061423222513390B231526
282716133C170D0D1613421A231925231603311C261A301E3A594D466A1B4B401447BC5D
87B4FFB7A0C5DCFFFFFFFFFFFFBAFFFDE2FFFFFF
FFFFFFFFB7FFFF6BCB9D4774A6BE2EB27BBB277283651532193B2E126827374D1F473D3D
19191A4630181C1E45114B52130D2C0E2F343A2F1E123929211D3332192A141519283825
0753290E28320C262328280726130950212B49431821363B46427C1A6A44356C9F51926E
A039FFFFFFFFF1FFFFFFFFFF9649D183EFFFFFFF
FFFFEB2BFFA577F96D44B05096C0CE13ADAE674695112743566AA85E34520F4533122A23
442C2F162A361B1D0E0F243B232A1A2A200B0B0E20211727191E232E251720192140141A
310814283B0B342522331D02250E2826402821245A30182D0C1611596319864EAF382E91
FF9FEBFFFFFF65FFFFFFFFFF78FFBDFFFFFFFFFF
FFFFFFFFFF59EDB6CD95889D7896F3E371A16F184A894A3E59918947112C185B39192E30
1D29274A3B19101714323620083621111C1F375D173315160E2F2C091E32182E1D2A300C
1324031A20361F14121E171A0F362E0D2B1C0A3C1C4C0E0D2307516D3C4628B8527AAC85
ECA4FFFFFFFFA1FFFFFFFFFFFFFF94FFFFFFFFFF
FFFFFFFFFFFFE1FFAAEF5A93FF85BBBD7B3DBE4A52245DB59F864175AC5A3A33114C3255
112C21233445193517371A3A19383D25222638162530232A0D0D1D360E371A232229281A
083E3617350E20292B302727171D1A4A0A153C565023125E4C4054559C436E482380E2A9
7F16FFFFE5FFC5FFA3FFFFFFFFFFFFFFFF2179FF
FFFFFFFFFFFFFF12DEC97EDFFFE2C9D54882774AD0FFFFA832312D592C1E4A2055292B1F
43331940272018161E1F052918472B45353728232706140E1630431D1813571C141A3819
242B22341F0B1C26312A13214D233A492E19312226327C280B35422C88AAD04A79FF5849
847CFFFFFFFFFFFFFAFFFFFFFFFFFFFF0DFFFFFF
FFFFFFFFF8FFFF7F85F5FFA299FAFF6AB1A381B8B591229E7460C01D46475D9A2D471D45
5A04162D28461E084A232323500F131C4E191E280A15131431271A242F1E0D131F182C1D
5B242A1B292E133D171E061E06121D2148104C113B040F2F3369B71EB0A7609AA13487E7
EDFFFF62FFFFC5FF59FFFFFFFFFFFFFFFFFFFFFF
FFFFFF76FF4EFFFFB8A6EEFFFF5E90FF93EACAAAFF86C3B3B659744E1256215F1D313742
51101E121E3C2632522E2C283B050E232F250F0C3230342C1E2F2533152529331D343005
27251C1E03350C29361C1F1515182D245A3E1C202D1610323D876D4F7375B6FE7C6BFFFF
B5FFFF78FFFFFFFF28FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFE5FFBEFF64FFFFA3FFFCFFFF8364AFA9CFD4B2CC762F563C3823325C2F37
2B204A4C3F08291B1B3F293B241605134F3133290F36152A27214B49032B2D1B1C1C2332
34172B3017282C190D35401A230B075D2F18442C3E3847651C664663D6FFC4965793FF5F
FFD15BFFFF67FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFD3FFFFFFFFE7BCFF9ADA9625EE372B42595262394C5169304436
287D2859614062351E12404A255F0741593F6D1B203864133E2814470442352802445315
3A3435120F3A213519203D0D264535301D55293A2A25774A4D567EC85E628D53FFF3BEFF
FFFFFFFFFF1FFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFB8FFFFBF83FFFFFFFFA4D4665AF67262916E305C789A949D4A272161442A3B63
2426414623264B382F311C1E12343A5738293F1B0C200C401006151013190C251E141D2C
0B390E16242E34201B0F134246472C397104570E3A1E6A4E1B47495547534EE795CF81FF
E89AFF9466FFFF69FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFCEFFFFFFFFFFFF2F6596B1AC7DD82BBBFFB3A470C1FF577F667F844C5A3B0D
90404F42592E30391C1F0E23412D2A4A543D371C46253855220634401F34390A22621724
35213F361B32282416114B29374265081C341E4D3253730E344F852B6C7A5D29A092FFFF
FFF4FFC8FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFC2FFFFFFA8FFFF3AFFFFFFFF69FF9FFFFF6EFFB6FDFF3BB0BE4289385D
BB417B4758623F6B1B41990B4B2C5F5324523C175D544E1B3845314C363C5A462C115221
3F7C154B6F49293B6D524A4E15637158198A4F3A313C7E438996373230FF49484F9BFFBA
92A621FF70FFF3FFFF90FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCBFFFFFFFFFFFFFFFFD8B3E5DF9F83701FB0494D59
2680383A473E6F231266502E5435503754370E69263E3E186520571F274E3445521A5156
413446682D6B3B645F2840255D5433403F3D115D1F8755446A1A91806E29215EFF7E348B
F4C9FFFFFFFFFFC1FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD8FFFFFFF964789A602F6258582E163A
1E4846391A471F0F2B222718484731263B1807381920122736223904133614282F092522
102B10440F3E250601361A2938053529372F6A1B1A2D05272B2E2A6134475EA5928298C6
FFFF7C81FFFFFFEBFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFFF68FFC27BD659FFC25686B197FF3374A8
67FB4344AB7A7B6A4D846B605D678C45638D895B604498366B876B707C575A77447A605F
6D5C887E53685ABA91308CA8536458946D7351BC86F4B297A068FFFF41BFE0FDA06BC673
FFCCADFFFFCEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0ogoo1goo0@00
0Goo000>Ool20005Ool00`00Oomoo`0POol2IcT4Ool2E[D2IcT2Ool2>Lh2HaP2=Jd2DY@2Ool2Li`2
G_L28@P4Ool2=Jd2DY@2BU82F]H2Nmh2@Q02G_L2:DX2>Lh2=Jd2BU82;F/2<H`2:DX2E[D2AS426<H2
BU82G_L2;F/2=Jd2:DX2?Nl2AS42;F/2=Jd2;F/2<H`2?Nl28@P2>Lh2;F/00bU:?Nlmk`02>Lh2=Jd2
@Q02=Jd26<H2CW<28@P2<H`2;F/4AS42<H`28@P2AS42<H`2;F/2<H`2=Jd2@Q029BT2=Jd4?Nl2E[D4
8@P2Ool2<H`2E[D2>Lh26<H2Ool2BU82F]H2@Q02:DX2HaP2Ool2;F/2JeX2?Nl2HaP2Ool2=Jd8Ool2
NmhQOol10001Ool001Eoo`03001oogoo021oo`9W>@Aoo`9F]@9W>@9oo`8icP9S608e[@9BU09oo`9c
W09Nm`8Q20Aoo`8e[@9BU09:DP9JeP9kgP92409Nm`8YBP8icP8e[@9:DP8]J`8aS08YBP9F]@96<@8H
aP9:DP9Nm`8]J`8e[@8YBP8mk`96<@8]J`8e[@8]J`8aS08mk`8Q208icP8]J`03:DXmkcg_008icP8e
[@92408e[@8HaP9>L`8Q208aS08]J`A6<@8aS08Q2096<@8aS08]J`8aS08e[@92408U:@8e[@@mk`9F
]@@Q209oo`8aS09F]@8icP8HaP9oo`9:DP9JeP92408YBP9S609oo`8]J`9[FP8mk`9S609oo`8e[@Qo
o`9kgR5oo`40005oo`005Goo00<007ooOol077oo0WNm1Woo0T8@0Sg_17oo0V<H0Tic0T8@0TYB0U:D
0Re[0R480QS60S6<1QBU0Q240P000QBU10aS0SF]0QBU0QS60QBU0QS60P000QcW0QBU0PaS0QS61000
0Q240QcW0P@Q0R480PQ20QBU0PQ211240P@Q11BU0PQ200<HaPQ224800P000QcW0Q240QS60Q240PQ2
0Q240PaS0QcW0P000PaS0QcW0Q240QS60R480RDY0PaS11240QBU0P@Q0PaS0R480PaS0QcW0R480RDY
0PaS0QcW0PQ20QBU12e[0S6<0QBU0S6<0Tic0Sg_0S6<27oo0Vmk:goo0@000Goo000EOol00`00Oomo
o`0LOol2Mkd6Ool2@Q02?Nl4Ool2HaP2CW<2@Q02BU82DY@2;F/28@P26<H2<H`65:D248@200025:D4
36<2=Jd25:D26<H25:D26<H200027>L25:D236<26<H4000248@27>L212428@P224825:D2248448@2
12445:D224800aS62488@P0200027>L248@26<H248@2248248@236<27>L2000236<27>L248@26<H2
8@P29BT236<448@25:D2124236<28@P236<27>L28@P29BT236<27>L224825:D4;F/2<H`25:D2<H`2
CW<2?Nl2<H`8Ool2Kg/[Ool10001Ool001Eoo`03001oogoo01aoo`9S60Yoo`9W>@9kgP96<@8HaP8m
k`9oo`8]J`8@Q08DY@8e[@92409:DP8<H`8e[@8Q208YBP92408<H`8]J`88@P@Li`8Q208HaP8YBP8]
J`8@Q08Q208DY@8]J`8aS08Li`8e[@8DY@8e[@8Q208HaP8Q20@YBP8<H`8YBP8Q208HaP039BT@Q124
008<H`8YBP8@Q08aS08<H`@Li`8@Q08e[@848@8HaP8YBP8HaP8YBP8HaP8YBP8DY@8YBP8aS088@P8@
Q08e[@8Li`8Q20@Li`92408@Q08]J`@U:@9JeP8<H`8icP92409>L`9_N`9cW09JeP9_Na1oo`9W>B5o
o`40005oo`005Goo00<007ooOol077oo0V<H2Woo0VLi0W_N0THa0QS60Sg_0Woo0Re[0Q240QBU0SF]
0T8@0TYB0PaS0SF]0R480RU:0T8@0PaS0Re[0PQ211cW0R480QS60RU:0Re[0Q240R480QBU0Re[0S6<
0QcW0SF]0QBU0SF]0R480QS60R4812U:0PaS0RU:0R480QS600<U:A2448@00PaS0RU:0Q240S6<0PaS
11cW0Q240SF]0P@Q0QS60RU:0QS60RU:0QS60RU:0QBU0RU:0S6<0PQ20Q240SF]0QcW0R4811cW0T8@
0Q240Re[12DY0U[F0PaS0SW>0T8@0Tic0Vmk0W>L0U[F0Vmk47oo0VLi8Goo0@000Goo000EOol00`00
Oomoo`0HOol2BU84Ool2Nmh2Ool2>Lh2Ool248@2DY@2BU82G_L2Ool2CW<69BT2Ool66<H2BU82AS42
8@P2?Nl27>L26<H27>L29BT2AS4236<2;F/2>Lh2<H`224849BT2:DX2=Jd27>L25:D29BT2=Jd29BT2
2482?Nl27>L248@2:DX224825:D28@P2;F/00acW6<HHaP029BT26<H28@P27>L236<29BT2:DX2;F/2
24827>L2:DX248@2:DX2;F/25:D29BT21242CW<28@P236<2=Jd27>L2<H`2;F/28@P2?Nl28@P2G_L2
;F/27>L2AS428@P2G_L2F]H27>L4Ool2F]H2Ool2=Jd4Ool2CW<2Ool2=Jd8Ool27>L4Ool2E[D6Ool2
HaPAOol10001Ool001Eoo`8001Uoo`9:DPAoo`9kgP9oo`8icP9oo`8@Q09BU09:DP9Nm`9oo`9>L`HU
:@9oo`HHaP9:DP96<@8Q208mk`8Li`8HaP8Li`8U:@96<@8<H`8]J`8icP8aS088@P@U:@8YBP8e[@8L
i`8DY@8U:@8e[@8U:@88@P8mk`8Li`8@Q08YBP88@P8DY@8Q208]J`037>LHaQS6008U:@8HaP8Q208L
i`8<H`8U:@8YBP8]J`88@P8Li`8YBP8@Q08YBP8]J`8DY@8U:@848@9>L`8Q208<H`8e[@8Li`8aS08]
J`8Q208mk`8Q209Nm`8]J`8Li`96<@8Q209Nm`9JeP8Li`Aoo`9JeP9oo`8e[@Aoo`9>L`9oo`8e[@Qo
o`8Li`Aoo`9F]@Ioo`9S611oo`80005oo`005Goo00<007ooOol097oo0VLi0Woo0W_N1Woo0TYB0U:D
0QBU0Re[0Sg_0SF]0QBU0T8@0RDY0QS60P@Q0SW>0RU:0QS60RDY0PaS0QS60PaS0P@Q0S6<0R480QS6
0QBU0RDY10Q20Q240QBU0QS60PaS0QS60QcW0Q240QS60Q240PQ20S6<0Q240P@Q0QcW00<HaPaS36<0
0R480QS60P000Q240RU:0QcW0Q240R480PaS0QS60QcW0RU:0RDY11BU0R480Q240P@Q10aS0QcW0QS6
0QBU0Re[0R480RDY0R480TYB0P@Q0QcW0Re[0RDY0T8@0Sg_0S6<0Sg_0RU:0Woo0V<H0SW>0U:D0U[F
0Woo0Ukg0QBU0Vmk0Sg_0UJe0U[F0TYB0S6<0QBU37oo0VLi3Goo0@000Goo000EOol00`00Oomoo`0T
Ool2IcT2Ool2Nmh6Ool2BU82DY@25:D2;F/2?Nl2=Jd25:D2@Q029BT26<H21242>Lh2:DX26<H29BT2
36<26<H236<21242<H`28@P26<H25:D29BT4248248@25:D26<H236<26<H27>L248@26<H248@22482
<H`248@212427>L00aS636<<H`028@P26<H2000248@2:DX27>L248@28@P236<26<H27>L2:DX29BT4
5:D28@P248@2124436<27>L26<H25:D2;F/28@P29BT28@P2BU8212427>L2;F/29BT2@Q02?Nl2<H`2
?Nl2:DX2Ool2HaP2>Lh2DY@2F]H2Ool2G_L25:D2Kg/2?Nl2E[D2F]H2BU82<H`25:D<Ool2IcT=Ool1
0001Ool001Eoo`03001oogoo01aoo`8e[@Aoo`8aS09:DP9oo`9>L`9g_@9oo`92409W>@9:DP9cW08U
:@8YBP8Q208YBP8U:@8Q208<H`8U:@8e[@8<H`8Li`848@8YBP80008icP8Li`8DY@HQ2088@P848@8<
H`8@Q08HaP8DY@8@Q088@P848@8Li`848@8DY@8<H`88@P8<H`8@Q0848@0336<8@PQ200@8@P800088
@P8Q20848@8@Q0848@8<H`8Li`8DY@8Li`8YBP8Li`8HaP88@P@<H`8HaP8DY@8Li`8U:@@@Q0@Q20@@
Q08aS08Li`8DY@8Q208aS0@@Q08U:@9>L`9:DP9>L`8mk`8]J`8HaP8e[@9:DP8aS08icP9kgP8]J`8a
S09[FP9BU0Qoo`92409Nm`Aoo`9Nm`]oo`40005oo`005Goo00<007ooOol077oo0SF]17oo0S6<0TYB
0Woo0Tic0WNm0Woo0T8@0VLi0TYB0W>L0RDY0RU:0R480RU:0RDY0R480PaS0RDY0SF]0PaS0QcW0P@Q
0RU:0P000SW>0QcW0QBU1R480PQ20P@Q0PaS0Q240QS60QBU0Q240PQ20P@Q0QcW0P@Q0QBU0PaS0PQ2
0PaS0Q240P@Q00<<H`Q2248010Q20P000PQ20R480P@Q0Q240P@Q0PaS0QcW0QBU0QcW0RU:0QcW0QS6
0PQ210aS0QS60QBU0QcW0RDY1124124811240S6<0QcW0QBU0R480S6<11240RDY0Tic0TYB0Tic0Sg_
0Re[0QS60SF]0TYB0S6<0SW>0W_N0Re[0S6<0V]J0U:D27oo0T8@0Ukg17oo0Ukg2goo0@000Goo000E
Ool00`00Oomoo`0POol236<<Ool2G_L2Nmh2Ool2:DX2AS42<H`2;F/2IcT2?Nl2:DX49BT2>Lh248@2
5:D27>L25:D2:DX236<46<H28@P248@212427>L248@236<26<H248@27>L2124224846<H27>L22482
:DX28@P200025:D26<H00b48000000028@P224825:D27>L22482<H`27>L248@236<2=Jd27>L2;F/2
8@P20002;F/248@29BT28@P2248236<26<H2<H`28@P2<H`2;F/25:D2?Nl25:D26<H28@P26<H2=Jd2
:DX29BT27>L2<H`2:DX2;F/28@P25:D26<H2Mkd248@2BU82Kg/2CW<2Ool2G_L2Li`8Ool2JeXGOol1
0001Ool001Eoo`03001oogoo021oo`8<H`aoo`9Nm`9kgP9oo`8YBP96<@8aS08]J`9W>@8mk`8YBP@U
:@8icP8@Q08DY@8Li`8DY@8YBP8<H`@HaP8Q208@Q0848@8Li`8@Q08<H`8HaP8@Q08Li`848@88@P@H
aP8Li`88@P8YBP8Q2080008DY@8HaP038@P00000008Q2088@P8DY@8Li`88@P8aS08Li`8@Q08<H`8e
[@8Li`8]J`8Q2080008]J`8@Q08U:@8Q2088@P8<H`8HaP8aS08Q208aS08]J`8DY@8mk`8DY@8HaP8Q
208HaP8e[@8YBP8U:@8Li`8aS08YBP8]J`8Q208DY@8HaP9g_@8@Q09:DP9_N`9>L`9oo`9Nm`9cW0Qo
o`9[FQMoo`40005oo`005Goo00<007ooOol087oo0S6<17oo0Re[0V]J0Woo0Re[0Woo0TYB0RU:0TYB
0V<H0Woo0V]J0S6<0R480S6<0PaS0S6<0R4811cW0QBU0R480PaS0QBU0Re[0P000P@Q0Q240PaS0R48
0QS60P@Q0PaS11BU0PQ20QS60QBU0PQ211S60Q241PaS0aBU0P0012DY11240QBU0PQ20QS60P@Q0QBU
11S60RDY0PQ20P000PQ20Q240QcW0QBU0QcW10aS0QBU0P@Q0QcW12DY0Q240QBU0QS60QBU0Re[0QS6
0Q2411cW0RU:0QBU0SW>0VLi0U[F0V]J0VLi15Je0S6<0T8@27oo0U:D17oo0S6<0Woo0Ukg0Woo0W>L
3goo0@000Goo000EOol00`00Oomoo`0POol2<H`4Ool2;F/2JeX2Ool2;F/2Ool2BU82:DX2BU82HaP2
Ool2JeX2<H`28@P2<H`236<2<H`28@P47>L25:D28@P236<25:D2;F/20002124248@236<28@P26<H2
124236<45:D224826<H25:D224846<H248@636<35:D200049BT448@25:D224826<H212425:D46<H2
9BT224820002248248@27>L25:D27>L436<25:D212427>L49BT248@25:D26<H25:D2;F/26<H248@4
7>L2:DX25:D2>Lh2IcT2F]H2JeX2IcT4E[D2<H`2@Q08Ool2DY@4Ool2<H`2Ool2G_L2Ool2Li`?Ool1
0001Ool001Eoo`03001oogoo01Yoo`8DY@Qoo`8mk`Aoo`9JePAoo`8e[@8mk`9oo`9JeP@icP8U:@8e
[@92408Li`8HaP@8@P8DY@8@Q08<H`8Li`8]J`8@Q08DY@8<H`@8@P@<H`8HaP8DY@848@8HaP8000@<
H`@@Q08000@HaP8<H`8HaP8DY@0348@8@PQ2008HaP8@Q08DY@8<H`8DY@HHaP@48@8@Q08DY@8@Q084
8@80008Li`HDY@8YBP8HaP8@Q08Li`8<H`88@P8<H`88@P8YBP8Q20@HaP8<H`8]J`8@Q08YBP88@P8U
:@8icP8]J`AJeP9S6092409oo`9F]@9W>@9g_@9:DP9oo`9:DP8]J`Aoo`9g_@9BU09Nm`Aoo`8U:@9o
o`8icPUoo`40005oo`005Goo0P006goo0QBU27oo0Sg_17oo0U[F17oo0SF]0Sg_0Woo0U[F13W>0RDY
0SF]0T8@0QcW0QS610Q20QBU0Q240PaS0QcW0Re[0Q240QBU0PaS10Q210aS0QS60QBU0P@Q0QS60P00
10aS11240P0011S60PaS0QS60QBU00<@Q0Q224800QS60Q240QBU0PaS0QBU1QS610@Q0Q240QBU0Q24
0P@Q0P000QcW1QBU0RU:0QS60Q240QcW0PaS0PQ20PaS0PQ20RU:0R4811S60PaS0Re[0Q240RU:0PQ2
0RDY0SW>0Re[15[F0V<H0T8@0Woo0UJe0VLi0WNm0TYB0Woo0TYB0Re[17oo0WNm0U:D0Ukg17oo0RDY
0Woo0SW>27oo0P000Goo000EOol00`00Oomoo`0JOol2;F/2Ool2HaP4Ool2<H`4Ool2Mkd2Li`2@Q02
6<H2DY@2CW<2<H`2DY@2F]H236<2F]H2=Jd26<H25:D2124200027>L224829BT224829BT248@236<2
2482000236<2000236<224827>L224845:D236<25:D248@2;F/236<25:D436<2248212400`aS5:DD
Y@0248@236<248@26<H6248212425:D436<29BT236<224821242:DX648@29BT2124236<28@P45:D2
24820002;F/28@P236<28@P25:D2CW<2;F/48@P236<2HaP2<H`2>Lh2CW<248@2BU82F]H2G_L2@Q02
DY@2F]H2=Jd4Ool2CW<2DY@2Ool2Nmh2@Q02?NlAOol10001Ool001Eoo`03001oogoo01Yoo`8]J`9o
o`9S60Aoo`8aS0Aoo`9g_@9cW092408HaP9BU09>L`8aS09BU09JeP8<H`9JeP8e[@8HaP8DY@848@80
008Li`88@P8U:@88@P8U:@8@Q08<H`88@P80008<H`80008<H`88@P8Li`88@P@DY@8<H`8DY@8@Q08]
J`8<H`8DY@@<H`88@P848@0336<DYABU008@Q08<H`8@Q08HaPH8@P848@8DY@@<H`8U:@8<H`88@P84
8@8YBPH@Q08U:@848@8<H`8Q20@DY@88@P80008]J`8Q208<H`8Q208DY@9>L`8]J`@Q208<H`9S608a
S08icP9>L`8@Q09:DP9JeP9Nm`92409BU09JeP8e[@Aoo`9>L`9BU09oo`9kgP92408mka5oo`40005o
o`005Goo00<007ooOol02Woo0P@Q77oo0Sg_0T8@0RDY0Re[0Woo0Sg_0RDY0V]J0UJe0THa0QBU0R48
0QS60P@Q0QBU0Sg_0QS611240QS60PaS0QBU0RDY0QcW0Q240RDY0Q240PQ20QBU0QS60Q240PaS0P@Q
0PaS0QS60Q240QBU0Q240PaS0QcW0PaS0PQ20PaS0RU:00<8@PaS36<00PaS0R480QS60PQ20P@Q0PQ2
0P0011240QBU11S60R480QBU0R480PaS0QBU0P0010aS0PQ20PaS11240R480PaS0QS60R480PaS11BU
0RU:0Q240RDY0PaS0QBU0Re[0QBU11S60UJe17oo0V]J0RDY0SW>0T8@0RDY0V]J0VLi0W>L0Woo0Vmk
0Sg_0VLi0Vmk0PQ24Goo0@000Goo000EOol00`00Oomoo`0:Ool2124LOol2?Nl2@Q029BT2;F/2Ool2
?Nl29BT2JeX2E[D2AS425:D28@P26<H212425:D2?Nl26<H448@26<H236<25:D29BT27>L248@29BT2
48@224825:D26<H248@236<2124236<26<H248@25:D248@236<27>L236<2248236<2:DX00`Q236<<
H`0236<28@P26<H2248212422482000448@25:D46<H28@P25:D28@P236<25:D2000436<2248236<4
48@28@P236<26<H28@P236<45:D2:DX248@29BT236<25:D2;F/25:D46<H2E[D4Ool2JeX29BT2>Lh2
@Q029BT2JeX2IcT2Li`2Ool2Kg/2?Nl2IcT2Kg/2248AOol10001Ool001Eoo`03001oogoo00Ioo`8m
k`8@Q11oo`9BU09oo`9S609oo`9cW0Aoo`88@P8mk`9F]@9cW092408@Q08U:@8e[@8Q209>L`@YBP8Q
208U:@8]J`88@P8@Q0@YBP8Li`88@P848@8U:@@<H`88@P@@Q08HaP@DY@8@Q0848@8HaP88@P8HaP8L
i`848@8<H`@DY@@@Q08<H`036<H48@@Q008HaP8<H`@48@8DY@8@Q08HaP8@Q088@P8Li`H@Q0@Li`8<
H`8Li`8<H`8HaP88@P8HaP8<H`8Q208HaP@@Q08DY@88@P8YBP8HaP8U:@88@P8HaP8Li`8]J`9F]@8i
cP8Q2092409>L`9JeP8]J`8@Q08YBP8U:@9Nm`8Li`8mk`ANm`92409oo`9:DP8]J`9g_@9F]@9oo`9c
W0moo`40005oo`005Goo00<007ooOol01Woo0Sg_0Q2447oo0U:D0Woo0V<H0Woo0W>L17oo0PQ20Sg_
0UJe0W>L0T8@0Q240RDY0SF]0R480Tic12U:0R480RDY0Re[0PQ20Q2412U:0QcW0PQ20P@Q0RDY10aS
0PQ211240QS611BU0Q240P@Q0QS60PQ20QS60QcW0P@Q0PaS11BU11240PaS00<HaP@Q12400QS60PaS
10@Q0QBU0Q240QS60Q240PQ20QcW1Q2411cW0PaS0QcW0PaS0QS60PQ20QS60PaS0R480QS611240QBU
0PQ20RU:0QS60RDY0PQ20QS60QcW0Re[0UJe0SW>0R480T8@0Tic0U[F0Re[0Q240RU:0RDY0Ukg0QcW
0Sg_15kg0T8@0Woo0TYB0Re[0WNm0UJe0Woo0W>L3goo0@000Goo000EOol00`00Oomoo`0>Ool2BU8>
Ool2DY@8Ool2DY@2Mkd2@Q02E[D2?Nl2:DX2G_L25:D28@P27>L2=Jd2:DX2000248@412429BT236<2
7>L2124236<25:D212425:D26<H2124236<2248236<4248236<26<H248@236<2000248@224821242
6<H25:D236<25:D236<00aS636<<H`0212445:D2124424826<H22482;F/26<H436<2248248@26<H2
124248@46<H6248236<27>L29BT248@25:D236<26<H25:D236<27>L2;F/236<25:D224828@P2AS42
BU82;F/27>L29BT2AS429BT236<2=Jd2DY@2>Lh2Li`2Nmh2BU82?Nl2CW<2AS42BU82IcT2F]H2Mkd2
;F/=Ool10001Ool001Eoo`03001oogoo00ioo`9:DPioo`9BU0Qoo`9BU09g_@92409F]@8mk`8YBP9N
m`8DY@8Q208Li`8e[@8YBP80008@Q0@48@8U:@8<H`8Li`848@8<H`8DY@848@8DY@8HaP848@8<H`88
@P8<H`@8@P8<H`8HaP8@Q08<H`80008@Q088@P848@8HaP8DY@8<H`8DY@8<H`036<H<H`aS00848@@D
Y@848@@8@P8HaP88@P8]J`8HaP@<H`88@P8@Q08HaP848@8@Q0@HaPH8@P8<H`8Li`8U:@8@Q08DY@8<
H`8HaP8DY@8<H`8Li`8]J`8<H`8DY@88@P8Q2096<@9:DP8]J`8Li`8U:@96<@8U:@8<H`8e[@9BU08i
cP9cW09kgP9:DP8mk`9>L`96<@9:DP9W>@9JeP9g_@8]J`eoo`40005oo`005Goo00<007ooOol03Woo
0Ukg0Woo0Sg_2Woo0S6<1Woo0WNm0Tic0Woo0TYB0QBU0QcW0UJe0RDY0T8@0PaS0S6<0Re[10Q20P@Q
0QBU0PaS0QS60Re[11240QBU0R480Q240QBU0P@Q0Q240P000PaS0QS611240QS60P@Q0QcW0QBU0PQ2
0P@Q0QS60PaS0PQ20R480Q240PaS0Q2400<8@Q2448@00QBU0Q2410aS0Q240PQ211241P@Q0Q240QBU
0PaS0QBU0Q240QcW0Q2410@Q10aS0QS60QBU0PQ211BU0R480Q240QBU0PQ20QS60R480P@Q0RU:0QS6
0Re[0UJe0SF]0RU:0R480Q240PQ20TYB0R480S6<15Je0PQ20VLi0V<H0TYB0RU:0U[F0R480SF]0Woo
0SW>0U:D0Woo0QBU0WNm1goo0@000Goo000EOol2000?Ool2G_L2Ool2?Nl:Ool2<H`6Ool2Mkd2CW<2
Ool2BU825:D27>L2E[D29BT2@Q0236<2<H`2;F/4248212425:D236<26<H2;F/448@25:D28@P248@2
5:D2124248@2000236<26<H448@26<H212427>L25:D2248212426<H236<224828@P248@236<248@0
0`Q248@@Q0025:D248@436<248@2248448@6124248@25:D236<25:D248@27>L248@4124436<26<H2
5:D224845:D28@P248@25:D224826<H28@P21242:DX26<H2;F/2E[D2=Jd2:DX28@P248@22482BU82
8@P2<H`4E[D22482IcT2HaP2BU82:DX2F]H28@P2=Jd2Ool2>Lh2DY@2Ool25:D2Mkd6Ool20001Ool0
01Eoo`03001oogoo00Yoo`9g_@92409[FP8U:@9:DPYoo`9kgPQoo`8Li`9BU08e[@9:DP8YBP9>L`8e
[@8HaP8Q208e[@8<H`8mk`@Q208Li`8HaP8@Q08<H`8Q208U:@8DY@8@Q08YBP848@88@P8@Q08000@D
Y@@@Q0848@8HaP8DY@848@8DY@8YBP80008@Q08Li`8DY@8<H`@8@P035:D<H`aS00@HaP8<H`8@Q08D
Y@8Li`88@P8<H`8DY@8Li`8HaP8DY@848@8DY@848@88@P8YBP8U:@88@P8Q20H<H`8HaP8Q20H<H`@L
i`8Q208<H`8U:@8HaP8@Q08e[@88@P8DY@8Li`8<H`8HaP88@P8aS092408icP8@Q09Nm`8mk`9JeP8D
Y@9Nm`9BU08icP8Q209>L`9W>@8e[@Aoo`9JeP]oo`40005oo`005Goo00<007ooOol02Woo0WNm0T8@
0V]J0RDY0TYB2Woo0W_N27oo0QcW0U:D0SF]0TYB0RU:0Tic0SF]0QS60R480SF]0PaS0Sg_12480QcW
0QS60Q240PaS0R480RDY0QBU0Q240RU:0P@Q0PQ20Q240P0011BU11240P@Q0QS60QBU0P@Q0QBU0RU:
0P000Q240QcW0QBU0PaS10Q200<DY@aS36<011S60PaS0Q240QBU0QcW0PQ20PaS0QBU0QcW0QS60QBU
0P@Q0QBU0P@Q0PQ20RU:0RDY0PQ20R481PaS0QS60R481PaS11cW0R480PaS0RDY0QS60Q240SF]0PQ2
0QBU0QcW0PaS0QS60PQ20S6<0T8@0SW>0Q240Ukg0Sg_0U[F0QBU0Ukg0U:D0SW>0R480Tic0VLi0SF]
17oo0U[F2goo0@000Goo000EOol00`00Oomoo`0:Ool2Li`4Ool2G_L<Ool2Kg/2HaP2DY@2F]H2Ool2
F]H2@Q02;F/2G_L28@P224828@P29BT236<2=Jd28@P29BT2;F/27>L236<26<H236<248@236<26<H2
0002248448@236<248@236<28@P42484124224827>L4248248@25:D248@2248248@212427>L22485
48@224820002248248@424826<H224826<H424829BT27>L29BT26<H236<26<H236<2000448@22482
12447>L248@25:D200027>L248@26<H2;F/28@P248@45:D2124224828@P29BT236<2:DX2;F/25:D2
Kg/26<H2:DX2F]H29BT26<H2BU82?Nl26<H2BU82DY@2HaP4Ool2248;Ool10001Ool001Eoo`03001o
ogoo00Yoo`9cW0Aoo`9Nm`aoo`9_N`9S609BU09JeP9oo`9JeP92408]J`9Nm`8Q2088@P8Q208U:@8<
H`8e[@8Q208U:@8]J`8Li`8<H`8HaP8<H`8@Q08<H`8HaP800088@P@@Q08<H`8@Q08<H`8Q20@8@P@4
8@88@P8Li`@8@P8@Q08DY@8@Q088@P8@Q0848@8Li`88@PD@Q088@P800088@P8@Q0@8@P8HaP88@P8H
aP@8@P8U:@8Li`8U:@8HaP8<H`8HaP8<H`8000@@Q088@P848@@Li`8@Q08DY@80008Li`8@Q08HaP8]
J`8Q208@Q0@DY@848@88@P8Q208U:@8<H`8YBP8]J`8DY@9_N`8HaP8YBP9JeP8U:@8HaP9:DP8mk`8H
aP9:DP9BU09S60Aoo`88@P]oo`40005oo`005Goo00<007ooOol01Woo0VLi0S6<17oo0W_N0Vmk17oo
0W_N0W>L0Woo0V<H0Woo0SF]0UJe0Tic0SW>13F]0THa0QcW0S6<0PQ20R480QcW0PaS0QBU0Re[0SW>
0PaS0QS611BU10Q20QcW0P@Q0PQ20QBU0PaS0P@Q0QBU0PaS0QcW0Q2410@Q0PQ20Q240P@Q11S60PaS
0PQ20PaS0PQ20P000QBU0Q240QBU0P0000<48A2448@00QcW10Q20Q240QcW10aS0PQ20PaS0QS60Q24
0QBU0PQ20PaS0P000PaS0P@Q0QS60PaS0QBU10@Q20aS0Q240PaS0RDY0QcW0Q240PaS0P@Q0QS60QcW
0QS60Q240S6<0Q240PQ20R480RU:0VLi0QcW0RU:0QcW0Re[0SF]0S6<0RDY0SW>0Re[0Sg_0SF]0Sg_
0QS60Tic0V<H0U:D3Goo0@000Goo000EOol00`00Oomoo`06Ool2IcT2<H`4Ool2Nmh2Kg/4Ool2Nmh2
Li`2Ool2HaP2Ool2=Jd2E[D2CW<2>Lh4=Jd2AS427>L2<H`224828@P27>L236<25:D2;F/2>Lh236<2
6<H45:D424827>L2124224825:D236<212425:D236<27>L248@41242248248@212446<H236<22482
36<2248200025:D248@25:D200000`@Q48@@Q0027>L4248248@27>L436<2248236<26<H248@25:D2
248236<2000236<212426<H236<25:D4124836<248@236<29BT27>L248@236<212426<H27>L26<H2
48@2<H`248@224828@P2:DX2IcT27>L2:DX27>L2;F/2=Jd2<H`29BT2>Lh2;F/2?Nl2=Jd2?Nl26<H2
CW<2HaP2DY@=Ool10001Ool001Eoo`03001oogoo009oo`9S60Qoo`9>L`9_N`9oo`9_N`9JeP9S609c
W09g_@9BU09oo`9Nm`9oo`8<H`9[FP8DY@9S608e[@8Q208]J`8Li`8U:@8@Q08HaP8DY@8@Q08icPHQ
208<H`8U:@8DY@8<H`8@Q080008Q2088@P8HaP8@Q08Q208DY@8Li`8@Q08DY@8Li`88@P80008<H`88
@P@<H`8@Q088@P8@Q08000@@Q08<H`03000Q224800H8@P8Li`8@Q0@DY@8@Q0848@8DY@88@P8@Q08H
aP@<H`8Li`@@Q08<H`8000@@Q08DY@8HaP8@Q0800088@P8Li`8@Q08HaP8Q2088@P8Li`88@P@000@@
Q08HaP8U:@8DY@8U:@8HaP9:DP9F]@8Q208mk`9Nm`9JeP8U:@8YBP8Q208U:@9>L`848@8Q209oo`9F
]@96<@9oo`9>L`Uoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Woo0V<H27oo0Tic0Vmk
0Woo0Vmk0U[F0V<H0W>L0WNm0U:D0Woo0Ukg0Woo0PaS0V]J0QBU0V<H0SF]0R480Re[0QcW0RDY0Q24
0QS60QBU0Q240SW>1R480PaS0RDY0QBU0PaS0Q240P000R480PQ20QS60Q240R480QBU0QcW0Q240QBU
0QcW0PQ20P000PaS0PQ210aS0Q240PQ20Q240P0011240PaS00<002488@P01PQ20QcW0Q2411BU0Q24
0P@Q0QBU0PQ20Q240QS610aS0QcW11240PaS0P0011240QBU0QS60Q240P000PQ20QcW0Q240QS60R48
0PQ20QcW0PQ2100011240QS60RDY0QBU0RDY0QS60TYB0UJe0R480Sg_0Ukg0U[F0RDY0RU:0R480RDY
0Tic0P@Q0R480Woo0UJe0THa0Woo0Tic2Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`00
17oo00<007ooOol037oo0Sg_0RU:0RDY0TYB0Sg_0Tic0WNm0TYB17oo0SF]0Woo0QS60T8@0U:D13F]
0RU:0Q240THa0SF]0QBU0PQ20QBU0Q240QBU0QS60S6<0QBU0PaS0R480PQ20RDY0QBU12480PQ20PaS
0P@Q0PaS0QBU0QS60Q240PQ20Q240QBU0P000PaS0QBU0PQ210@Q0Q240QS610aS0P@Q0Q2400<HaP@Q
12400P0011S610Q20R4810Q20P0010aS0QcW0PQ20QS60Q240PaS0QcW0PQ20Q240PaS0P@Q0QS60R48
0Q240PaS0Q240PaS0QBU0Q240QBU0Q240QS60SW>0R480Re[0QBU0PaS0S6<0Re[0P@Q0THa0TYB0R48
0SW>0Q240PQ20THa0SF]0Sg_0RU:0SF]0Re[0P000PaS0R480V]J0Woo0RU:17oo0QS60V]J1goo0@00
0Goo0008Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P003Goo0Sg_0RU:0RDY0TYB0Sg_0Tic0WNm
0TYB17oo0SF]0Woo0QS60T8@0U:D13F]0RU:0Q240THa0SF]0QBU0PQ20QBU0Q240QBU0QS60S6<0QBU
0PaS0R480PQ20RDY0QBU12480PQ20PaS0P@Q0PaS0QBU0QS60Q240PQ20Q240QBU0P000PaS0QBU0PQ2
10@Q0Q240QS610aS0P@Q0Q2400<HaP@Q12400P0011S610Q20R4810Q20P0010aS0QcW0PQ20QS60Q24
0PaS0QcW0PQ20Q240PaS0P@Q0QS60R480Q240PaS0Q240PaS0QBU0Q240QBU0Q240QS60SW>0R480Re[
0QBU0PaS0S6<0Re[0P@Q0THa0TYB0R480SW>0Q240PQ20THa0SF]0Sg_0RU:0SF]0Re[0P000PaS0R48
0V]J0Woo0RU:17oo0QS60V]J1Woo0P000Goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo
00<007ooOol02Woo0R480SW>0Q240Tic0V<H17oo0Ukg0W>L17oo0UJe0Woo0QS60WNm0R480Sg_0RDY
0S6<10Q20Re[11S60PaS0QBU0PaS0Q240RDY0P@Q0QBU0RDY0PaS0PQ20QBU0Q240PaS11BU0PaS1PQ2
0P@Q0Q240PQ20Q240PaS0QcW0Q240PQ20QS60PaS1PQ20P@Q0PaS0Q240`Q20PaS0Q240P000QBU0R48
0P000PaS0QcW0PQ221240QS60P@Q0RDY10Q20QcW0P@Q0Q240PQ20QS60P000QcW0PQ20QBU0Q240R48
0QcW0Q240P@Q0R480QBU0RU:0R480Re[0QBU0R480QS60T8@0RDY0Sg_0Re[0RDY0TYB0Re[0R480T8@
0RU:0SF]0QS60Q240QBU0Sg_0W_N0R480Woo0W_N0Woo0V<H2Goo0@000Goo0007Ool01000Oomoo`00
0Woo00@007ooOol000Aoo`03001oogoo00Yoo`8Q208icP8@Q09>L`9S60Aoo`9Nm`9cW0Aoo`9F]@9o
o`8HaP9g_@8Q208mk`8U:@8aS0@8@P8]J`@HaP8<H`8DY@8<H`8@Q08U:@848@8DY@8U:@8<H`88@P8D
Y@8@Q08<H`@DY@8<H`H8@P848@8@Q088@P8@Q08<H`8Li`8@Q088@P8HaP8<H`H8@P848@8<H`8@Q0<8
@P8<H`8@Q080008DY@8Q2080008<H`8Li`88@PP@Q08HaP848@8U:@@8@P8Li`848@8@Q088@P8HaP80
008Li`88@P8DY@8@Q08Q208Li`8@Q0848@8Q208DY@8YBP8Q208]J`8DY@8Q208HaP92408U:@8mk`8]
J`8U:@9:DP8]J`8Q2092408YBP8e[@8HaP8@Q08DY@8mk`9kgP8Q209oo`9kgP9oo`9S60Uoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol01Woo0Ukg0V<H0Woo0W>L0Re[0V<H17oo0UJe0Tic0V<H
0Woo0T8@0Woo0V<H0WNm0UJe0SF]13W>0RDY0QS60S6<0Q2411cW0QBU0PaS0P001QBU0Q240P@Q0Q24
0P@Q1Q240RU:0PQ20P@Q0PQ20P@Q11240QBU0Q241PQ21PaS0Q240P@Q0PQ211BU0PaS0P0000<DYA24
48@00P@Q10Q20PaS0P@Q0PQ20QBU0PaS1PQ20PaS0P@Q0QcW0QS60PQ20Q240PQ20R480Q240P000QBU
10aS0P@Q0PQ20QcW0Q240P@Q11BU0RDY0QBU0Q240PQ20SW>0QcW0Q240Re[0T8@0QBU0RDY0Tic0RDY
0QcW0QBU0RDY0QS60RDY0R480Tic0P@Q0PaS0Re[0Tic0SW>0Re[0U[F0W_N0SF]2goo0@000Goo000E
Ool00`00Oomoo`06Ool2G_L2HaP2Ool2Li`2;F/2HaP4Ool2E[D2CW<2HaP2Ool2@Q02Ool2HaP2Mkd2
E[D2=Jd4>Lh29BT26<H2<H`248@47>L25:D236<200065:D248@2124248@2124648@2:DX224821242
2482124448@25:D248@6248636<248@2124224845:D236<200000aBU48@@Q0021244248236<21242
24825:D236<6248236<212427>L26<H2248248@224828@P248@200025:D436<2124224827>L248@2
12445:D29BT25:D248@22482>Lh27>L248@2;F/2@Q025:D29BT2CW<29BT27>L25:D29BT26<H29BT2
8@P2CW<2124236<2;F/2CW<2>Lh2;F/2F]H2Nmh2=Jd;Ool10001Ool001Eoo`03001oogoo00Ioo`9[
FP9JeP9oo`9F]@9>L`Aoo`9BU08@Q08DY@8e[@ANm`9oo`8aS09oo`9S60@]J`8mk`8@Q08DY@848@8<
H`88@P8U:@8<H`8DY@8Q208@Q08DY@8<H`8HaP@<H`H48@8DY@H8@P8@Q08<H`88@P8@Q08DY@848@80
00@48@8<H`8@Q0@<H`848@8<H`8@Q088@P848@88@P0336<DYABU008@Q0848@80008HaP8@Q08DY@8<
H`8DY@88@P848@8000@<H`8Q20H@Q088@P8@Q088@P8@Q08DY@8<H`8Li`8@Q088@P8DY@80008Li`8<
H`8DY@8@Q08HaP88@P848@8Q208]J`HaS0@8@P8U:@80008]J`848@8Li`8e[@8]J`8Q208HaP8Li`8Q
2092408Li`8]J`9>L`9[FPA>L`]oo`40005oo`005Goo00<007ooOol01Woo0V]J0U[F0Woo0UJe0Tic
17oo0U:D0Q240QBU0SF]15kg0Woo0S6<0Woo0V<H12e[0Sg_0Q240QBU0P@Q0PaS0PQ20RDY0PaS0QBU
0R480Q240QBU0PaS0QS610aS1P@Q0QBU1PQ20Q240PaS0PQ20Q240QBU0P@Q0P0010@Q0PaS0Q2410aS
0P@Q0PaS0Q240PQ20P@Q0PQ200<<HaBU5:D00Q240P@Q0P000QS60Q240QBU0PaS0QBU0PQ20P@Q0P00
10aS0R481Q240PQ20Q240PQ20Q240QBU0PaS0QcW0Q240PQ20QBU0P000QcW0PaS0QBU0Q240QS60PQ2
0P@Q0R480Re[1S6<10Q20RDY0P000Re[0P@Q0QcW0SF]0Re[0R480QS60QcW0R480T8@0QcW0Re[0Tic
0V]J14ic2goo0@000Goo000EOol00`00Oomoo`02Ool2>Lh6Ool2Mkd28@P2F]H2@Q02F]H2?Nl2<H`2
48@2AS42:DX4JeX2CW<2Ool2<H`2G_L2;F/2>Lh25:D248@29BT26<H25:D29BT25:D436<25:D26<H2
8@P2124248@27>L2:DX224827>L236<2248236<26<H25:D28@P236<25:D212425:D424827>L26<H2
48@25:D4124200025:D2124248@224800acW48@@Q0021244248236<412425:D2248436<25:D248@2
5:D2124236<25:D224827>L248@2124436<26<H25:D27>L26<H25:D26<H22484124248@2248248@2
>Lh26<H224826<H2BU828@P212427>L636<28@P2:DX26<H2;F/29BT2<H`2;F/2AS42>Lh2;F/2@Q02
Ool2AS425:D2Ool2HaP9Ool10001Ool001Eoo`03001oogoo009oo`8icPIoo`9g_@8Q209JeP92409J
eP8mk`8aS08@Q096<@8YBPA[FP9>L`9oo`8aS09Nm`8]J`8icP8DY@8@Q08U:@8HaP8DY@8U:@8DY@@<
H`8DY@8HaP8Q20848@8@Q08Li`8YBP88@P8Li`8<H`88@P8<H`8HaP8DY@8Q208<H`8DY@848@8DY@@8
@P8Li`8HaP8@Q08DY@@48@80008DY@848@8@Q088@P037>L@Q12400848@@8@P8<H`@48@8DY@88@P@<
H`8DY@8@Q08DY@848@8<H`8DY@88@P8Li`8@Q0848@@<H`8HaP8DY@8Li`8HaP8DY@8HaP88@P@48@8@
Q088@P8@Q08icP8HaP88@P8HaP9:DP8Q20848@8Li`H<H`8Q208YBP8HaP8]J`8U:@8aS08]J`96<@8i
cP8]J`92409oo`96<@8DY@9oo`9S60Uoo`40005oo`005Goo00<007ooOol00Woo0U:D1Woo0R480QBU
0P000Q240V]J0Vmk0VLi0S6<0UJe0Re[0Woo0THa0U[F0Woo0S6<0W>L0QBU0R480Q240R480QBU0Q24
0P@Q0QS60R480QcW0PaS0Q240R480QS610Q20P@Q0QBU0P@Q0Q240PQ220aS0QBU0QcW0Q2420aS10Q2
0PaS10@Q10Q20P@Q0Q240PQ20QS600<8@Q2448@00Q241PaS0QS60Q240P000P@Q0QS60PaS0PQ20PaS
11BU0QS611240P@Q0Q240PQ20Q240PQ20PaS0QS60P@Q0QBU0PaS0Q240RU:0PaS0P@Q0RU:0Q240QcW
0Re[0QS60QBU11S60RDY12480Q240S6<0P000THa0QS60P@Q0Sg_0QcW0PaS0SF]0Re[0QS60PQ20U:D
0V]J0Tic0RDY0Woo0RU:0V]J1goo0@000Goo000EOol20003Ool2DY@6Ool28@P25:D2000248@2JeX2
Kg/2IcT2<H`2E[D2;F/2Ool2AS42F]H2Ool2<H`2Li`25:D28@P248@28@P25:D248@212426<H28@P2
7>L236<248@28@P26<H4248212425:D2124248@2248836<25:D27>L248@836<4248236<412442482
124248@224826<H00`Q248@@Q00248@636<26<H248@2000212426<H236<2248236<45:D26<H448@2
124248@2248248@2248236<26<H212425:D236<248@2:DX236<21242:DX248@27>L2;F/26<H25:D4
6<H29BT48@P248@2<H`20002AS426<H21242?Nl27>L236<2=Jd2;F/26<H22482DY@2JeX2CW<29BT2
Ool2:DX2JeX6Ool20001Ool001Eoo`03001oogoo00Qoo`9W>@9F]@8HaP@e[@9oo`9_N`8YBP9JeP8Y
BP92409S608U:@9[FP96<@9:DP9W>@8HaP924088@P8<H`@Q208@Q08aS08DY@@@Q0@000@8@P8Li`8D
Y@8<H`848@8DY@@@Q08Q20@8@P8<H`88@P8<H`8@Q08HaP8@Q08<H`88@P8<H`8Li`8@Q08<H`8DY@H<
H`80008<H`0324848@@Q008DY@88@P848@8HaP88@P80008@Q0848@8Li`848@8@Q0H8@P8Li`80008@
Q080008@Q080008DY@8000848@88@P8DY@88@P8DY@88@P848@8@Q08YBPH@Q08DY@8Li`848@8DY@8<
H`8@Q0848@@Q208U:@88@P8Q208@Q08U:@92408@Q08Li`8]J`8U:@@Q209:DP92408icP8YBP9>L`8D
Y@96<@Moo`40005oo`005Goo00<007ooOol027oo0VLi0UJe0QS613F]0Woo0Vmk0RU:0U[F0RU:0T8@
0V<H0RDY0V]J0THa0TYB0VLi0QS60T8@0PQ20PaS12480Q240S6<0QBU1124100010Q20QcW0QBU0PaS
0P@Q0QBU11240R4810Q20PaS0PQ20PaS0Q240QS60Q240PaS0PQ20PaS0QcW0Q240PaS0QBU1PaS0P00
0PaS00<8@P@Q12400QBU0PQ20P@Q0QS60PQ20P000Q240P@Q0QcW0P@Q0Q241PQ20QcW0P000Q240P00
0Q240P000QBU0P000P@Q0PQ20QBU0PQ20QBU0PQ20P@Q0Q240RU:1Q240QBU0QcW0P@Q0QBU0PaS0Q24
0P@Q12480RDY0PQ20R480Q240RDY0T8@0Q240QcW0Re[0RDY12480TYB0T8@0SW>0RU:0Tic0QBU0THa
1goo0@000Goo000EOol00`00Oomoo`06Ool2Mkd26<H2Li`47>L2JeX2Ool2G_L25:D29BT4@Q0248@2
;F/2DY@22482Kg/2Li`2@Q02<H`25:D248@29BT46<H25:D236<2<H`236<25:D20002248248@21242
36<2124236<248@224825:D224827>L48@P2248236<212422484124436<25:D2000248@26<H22482
124248@224825:D336<248@4248236<2000236<4124436<2000236<2248248@412425:D2248236<4
0002248236<448@26<H25:D2248248@236<25:D224825:D26<H236<28@P212467>L2:DX25:D236<2
5:D29BT28@P236<29BT224829BT2:DX2;F/248@4:DX2@Q02<H`2@Q02<H`2@Q02E[D9Ool10001Ool0
01Eoo`03001oogoo00Ioo`9g_@8HaP9cW0@Li`9[FP9oo`9Nm`8DY@8U:@A2408@Q08]J`9BU088@P9_
N`9cW092408aS08DY@8@Q08U:@@HaP8DY@8<H`8aS08<H`8DY@800088@P8@Q0848@8<H`848@8<H`8@
Q088@P8DY@88@P8Li`@Q2088@P8<H`848@88@P@48@@<H`8DY@80008@Q08HaP88@P848@8@Q088@P8D
Y@<<H`8@Q0@8@P8<H`80008<H`@48@@<H`80008<H`88@P8@Q0@48@8DY@88@P8<H`@00088@P8<H`@@
Q08HaP8DY@88@P8@Q08<H`8DY@88@P8DY@8HaP8<H`8Q20848@HLi`8YBP8DY@8<H`8DY@8U:@8Q208<
H`8U:@88@P8U:@8YBP8]J`8@Q0@YBP92408aS092408aS092409F]@Uoo`40005oo`005Goo00<007oo
Ool01Woo0W_N0RU:0Woo0PaS0QS60Tic0U:D0SF]0QS60P@Q0QS60PQ20RDY0Ukg0RDY0Re[0Woo0RDY
0VLi0SW>0QBU0QcW0QBU0RDY0QcW0P@Q0Q240PaS0PQ20R480QS60PaS0P000QBU10aS0P000PQ21124
10aS1P@Q0QcW0PaS0P@Q0PaS0PQ20PaS0P@Q0PQ20PaS0P@Q10Q20P000QBU0PQ20`@Q0QcW0PaS0P@Q
0Q240PaS0PQ210@Q0P000PQ211240PQ20PaS0QBU0P@Q0P0011240PaS0QS60P@Q0Q240PQ20P@Q0Q24
0P@Q0PaS0P@Q0PQ20QcW0Q240QS60Q240QcW0QBU0PaS0P000R480PQ20Q240QS60P@Q0RU:0Q240R48
0QS60SW>0RU:0R480SW>0Re[0P@Q0Re[0Sg_10aS0U:D0RU:0PaS0Re[0U:D2Goo0@000Goo000EOol0
0`00Oomoo`06Ool2Nmh2:DX2Ool236<26<H2CW<2DY@2=Jd26<H212426<H224829BT2G_L29BT2;F/2
Ool29BT2IcT2>Lh25:D27>L25:D29BT27>L2124248@236<224828@P26<H236<200025:D436<20002
248448@436<612427>L236<2124236<2248236<21242248236<21244248200025:D2248312427>L2
36<2124248@236<2248412420002248448@2248236<25:D21242000448@236<26<H2124248@22482
124248@2124236<2124224827>L248@26<H248@27>L25:D236<200028@P2248248@26<H21242:DX2
48@28@P26<H2>Lh2:DX28@P2>Lh2;F/21242;F/2?Nl436<2DY@2:DX236<2;F/2DY@9Ool10001Ool0
01Eoo`03001oogoo009oo`8icPAoo`9cW09F]@92408U:@8Li`8mk`96<@8e[@96<@8YBP8Q209BU09S
6088@P9BU09JeP8U:@9:DP8U:@8]J`8<H`8DY@8YBP8<H`8aS08<H`@DY@8Li`80008DY@8<H`8Li`8@
Q08YBP8@Q0848@8@Q08Q208HaP8<H`8DY@8<H`8DY@848@8DY@8@Q0@<H`88@P@48@8<H`848@8@Q0@4
8@88@P848@80000336<8@PQ2008<H`8000H48@@<H`88@P848@@8@P80008@Q08000848@8DY@88@P8H
aP8DY@8<H`8Li`8Q20848@88@P848@8@Q08Li`88@P8DY@8<H`@@Q08DY@8YBP@DY@8<H`8DY@8@Q08U
:@88@P8HaP88@P848@8U:@92408Li`8<H`@U:@88@P8icP8DY@8Li`8@Q08]J`9JeP8<H`8aS09S609N
m`Uoo`40005oo`005Goo00<007ooOol00Woo0SW>17oo0W>L0UJe0T8@0RDY0QcW0Sg_0THa0SF]0THa
0RU:0R480U:D0V<H0PQ20U:D0U[F0RDY0TYB0RDY0Re[0PaS0QBU0RU:0PaS0S6<0PaS11BU0QcW0P00
0QBU0PaS0QcW0Q240RU:0Q240P@Q0Q240R480QS60PaS0QBU0PaS0QBU0P@Q0QBU0Q2410aS0PQ210@Q
0PaS0P@Q0Q2410@Q0PQ20P@Q0P0000<<H`Q224800PaS0P001P@Q10aS0PQ20P@Q10Q20P000Q240P00
0P@Q0QBU0PQ20QS60QBU0PaS0QcW0R480P@Q0PQ20P@Q0Q240QcW0PQ20QBU0PaS11240QBU0RU:11BU
0PaS0QBU0Q240RDY0PQ20QS60PQ20P@Q0RDY0T8@0QcW0PaS12DY0PQ20SW>0QBU0QcW0Q240Re[0U[F
0PaS0S6<0V<H0Ukg2Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H4Ool2IcT2?Nl28@P27>L248@2
BU82E[D2=Jd2>Lh2=Jd236<2E[D2<H`26<H2<H`2>Lh2<H`2>Lh29BT26<H2;F/448@224826<H25:D2
36<29BT2:DX25:D212425:D248@2000248@25:D27>L25:D236<248@25:D236<200045:D248@236<2
000248@2124424825:D236<4124236<2248436<00`Q248@@Q002248212422482000236<26<H22482
8@P4248200042482000248@20002248648@236<2248448@22482124236<25:D424826<H25:D42482
7>L25:D212429BT224827>L224829BT48@P236<28@P448@29BT21242:DX29BT248@2:DX29BT2;F/2
=Jd248@26<H2HaP2>Lh9Ool10001Ool001Eoo`8000=oo`9JePAoo`9W>@8mk`8Q208Li`8@Q09:DP9F
]@8e[@8icP8e[@8<H`9F]@8aS08HaP8aS08icP8aS08icP8U:@8HaP8]J`@@Q088@P8HaP8DY@8<H`8U
:@8YBP8DY@848@8DY@8@Q080008@Q08DY@8Li`8DY@8<H`8@Q08DY@8<H`8000@DY@8@Q08<H`80008@
Q0848@@8@P8DY@8<H`@48@8<H`88@P@<H`03248@Q1240088@P848@88@P80008<H`8HaP88@P8Q20@8
@P8000@8@P80008@Q0800088@PH@Q08<H`88@P@@Q088@P848@8<H`8DY@@8@P8HaP8DY@@8@P8Li`8D
Y@848@8U:@88@P8Li`88@P8U:@@Q208<H`8Q20@@Q08U:@848@8YBP8U:@8@Q08YBP8U:@8]J`8e[@8@
Q08HaP9S608icPQoo`80005oo`005Goo00<007ooOol027oo0THa0S6<0Re[0RU:0Re[0THa0UJe0QcW
0SF]0RU:0R480Q240RDY0Re[0T8@0QcW0THa0QBU0QS60Sg_0RDY0PaS0QBU0R480PQ20QBU0QcW10Q2
0P@Q0QcW0Q2411BU0PaS0QS60PaS0P@Q10Q20P@Q0P000PQ210@Q0Q240PaS11240PaS10Q20P@Q0Q24
0P@Q0Q240P000PaS0Q240PaS00<Li`aS36<00P@Q10Q20PaS0P@Q0PaS0PQ20P@Q0QBU0P@Q11BU0PQ2
0PaS112410@Q0PQ20PaS0PQ20P0010Q20PaS10@Q0QS60PQ20RU:11S60Q2410Q20P@Q0P000PQ20PaS
0PQ21PaS0R480RU:0PQ20QS60RU:0PaS0R480RU:0PaS0Q240RU:0Q240RDY0PaS0QS60S6<0TYB0THa
0VLi1goo0@000Goo000EOol00`00Oomoo`08Ool2AS42<H`2;F/2:DX2;F/2AS42E[D27>L2=Jd2:DX2
8@P248@29BT2;F/2@Q027>L2AS425:D26<H2?Nl29BT236<25:D28@P224825:D27>L4248212427>L2
48@45:D236<26<H236<212442482124200022484124248@236<448@236<42482124248@2124248@2
000236<248@236<00acW36<<H`021244248236<2124236<2248212425:D212445:D2248236<448@4
1242248236<224820004248236<412426<H22482:DX46<H248@4248212420002248236<2248636<2
8@P2:DX224826<H2:DX236<28@P2:DX236<248@2:DX248@29BT236<26<H2<H`2BU82AS42IcT7Ool1
0001Ool001Eoo`03001oogoo00Ioo`9F]@8U:@9F]@8@Q0800092408aS08icP8HaP8Li`8HaP8@Q08D
Y@8U:@8mk`848@8e[@8]J`8Li`8icP8YBP8Li`8<H`8U:@8HaP8<H`8@Q0@HaP8@Q08HaP88@P8@Q0@4
8@8DY@8<H`88@P848@8<H`88@P800088@P@48@88@P8<H`848@88@P8<H`88@P8@Q0P48@8@Q08HaP8@
Q08Li`8000035:D48@@Q008HaP88@P8<H`848@88@P8@Q0@8@P@<H`@48@8@Q08<H`8@Q08DY@@8@P8@
Q088@P848@P8@P8<H`8DY@8@Q088@P8<H`8HaP8DY@848@80008HaP8<H`8HaP8<H`8HaP848@8@Q08L
i`8<H`8@Q08icP88@P8aS08@Q08DY@8]J`8e[@80008@Q0848@9:DP8DY@8Q208YBP8U:@9>L`8]J`9B
U0Moo`40005oo`005Goo00<007ooOol01Woo0UJe0RDY0UJe0Q240P000T8@0S6<0SW>0QS60QcW0QS6
0Q240QBU0RDY0Sg_0P@Q0SF]0Re[0QcW0SW>0RU:0QcW0PaS0RDY0QS60PaS0Q2411S60Q240QS60PQ2
0Q2410@Q0QBU0PaS0PQ20P@Q0PaS0PQ20P000PQ210@Q0PQ20PaS0P@Q0PQ20PaS0PQ20Q2420@Q0Q24
0QS60Q240QcW0P0000<DY@@Q12400QS60PQ20PaS0P@Q0PQ20Q2410Q210aS10@Q0Q240PaS0Q240QBU
10Q20Q240PQ20P@Q20Q20PaS0QBU0Q240PQ20PaS0QS60QBU0P@Q0P000QS60PaS0QS60PaS0QS60P@Q
0Q240QcW0PaS0Q240SW>0PQ20S6<0Q240QBU0Re[0SF]0P000Q240P@Q0TYB0QBU0R480RU:0RDY0Tic
0Re[0U:D1goo0@000Goo000EOol00`00Oomoo`02Ool2Nmh2Ool2AS42@Q02?Nl26<H2:DX2;F/45:D2
7>L248@2;F/26<H29BT2?Nl28@P29BT2<H`26<H4>Lh248@29BT248@28@P248@29BT25:D2248248@2
248436<248@224826<H212425:D400027>L2124648@212425:D4248248@2000224825:D2124236<4
0002124236<248@22483124248@2124236<212422482000624821244248200027>L41242248248@2
124248@41242248236<2124436<4248248@236<212425:D4248212425:D200026<H2000248@236<2
8@P248@29BT48@P27>L2:DX27>L2;F/4:DX248@29BT236<26<H2?Nl25:D2CW<2HaP2E[D9Ool10001
Ool001Eoo`03001oogoo009oo`9kgP9oo`96<@92408mk`8HaP8YBP8]J`@DY@8Li`8@Q08]J`8HaP8U
:@8mk`8Q208U:@8aS08HaP@icP8@Q08U:@8@Q08Q208@Q08U:@8DY@88@P8@Q088@P@<H`8@Q088@P8H
aP848@8DY@@0008Li`848@H@Q0848@8DY@@8@P8@Q0800088@P8DY@848@8<H`@000848@8<H`8@Q088
@P<48@8@Q0848@8<H`848@88@P8000H8@P848@@8@P80008Li`@48@88@P8@Q0848@8@Q0@48@88@P8<
H`848@@<H`@8@P8@Q08<H`848@8DY@@8@P848@8DY@80008HaP80008@Q08<H`8Q208@Q08U:@@Q208L
i`8YBP8Li`8]J`@YBP8@Q08U:@8<H`8HaP8mk`8DY@9>L`9S609F]@Uoo`40005oo`005Goo00<007oo
Ool00Woo0V<H17oo15:D0SF]136<0QcW0P000RU:0Re[0S6<0PQ20T8@0U:D0RDY0RU:0SF]0QcW0THa
0Q240RU:11BU0RU:0PQ211cW0P000QS60RU:0PQ20RDY0Q240P@Q0QBU0P@Q0Q240PQ20QS60P@Q0PQ2
0QBU0Q240PQ20Q2410Q20PaS0PQ210aS0P@Q0PaS0P@Q10Q220@Q0P0000<DY@Q224800PQ20P@Q0QBU
0PaS0P@Q0PQ20PaS0P000P@Q0PQ20P000PQ20P000QBU0Q240PQ210000Q240PQ20PaS0QBU0PaS0Q24
0QS610@Q0PaS0PQ20P000R480P000P@Q0QcW0P@Q0QBU0PQ20QS60P@Q0PaS0Q240PaS0QS60PQ20Q24
0RU:0PaS0PQ20QcW0R480PaS0Re[0RDY0Q240QcW0Re[0QS60Re[0QS60WNm0W_N2Goo0@000Goo000E
Ool00`00Oomoo`02Ool2HaP4Ool4DY@2=Jd4<H`27>L20002:DX2;F/2<H`22482@Q02DY@29BT2:DX2
=Jd27>L2AS4248@2:DX45:D2:DX224847>L200026<H2:DX224829BT248@212425:D2124248@22482
6<H2124224825:D248@2248248@4248236<2248436<2124236<212442488124200000aBU2488@P02
248212425:D236<21242248236<20002124224820002248200025:D248@22484000248@2248236<2
5:D236<248@26<H4124236<2248200028@P2000212427>L212425:D224826<H2124236<248@236<2
6<H2248248@2:DX236<224827>L28@P236<2;F/29BT248@27>L2;F/26<H2;F/26<H2Mkd2Nmh9Ool1
0001Ool001Eoo`03001oogoo009oo`9Nm`Aoo`8e[@8icP@]J`8Q20@HaP8DY@8<H`8YBP8Li`8@Q08a
S08YBP8aS08<H`8]J`8U:@8<H`8DY@88@P8HaP@@Q08DY@8Li`8<H`8@Q08DY@@8@P8@Q0@<H`H48@8<
H`8Li`8@Q0848@8<H`8@Q08<H`8@Q0848@@8@P848@@<H`8@Q08000H8@P8@Q088@P80008HaP0336<4
8@@Q008DY@H8@P8DY@848@8000848@8<H`88@P848@88@P@@Q08<H`80008Li`8<H`88@P8DY@8000@@
Q08000P@Q08<H`848@8HaP8@Q0@8@P@@Q08<H`848@@8@P8<H`8DY@8mk`8HaP@Li`8@Q08Li`8<H`8Y
BP8DY@8aS08@Q08DY@8@Q08DY@8Li`@<H`ANm`Uoo`40005oo`005Goo0P000goo0Ukg17oo0SF]0SW>
12e[0R4811S60QBU0PaS0RU:0QcW0Q240S6<0RU:0S6<0PaS0Re[0RDY0PaS0QBU0PQ20QS611240QBU
0QcW0PaS0Q240QBU10Q20Q2410aS1P@Q0PaS0QcW0Q240P@Q0PaS0Q240PaS0Q240P@Q10Q20P@Q10aS
0Q240P001PQ20Q240PQ20P000QS600<<H`@Q12400QBU1PQ20QBU0P@Q0P000P@Q0PaS0PQ20P@Q0PQ2
11240PaS0P000QcW0PaS0PQ20QBU0P0011240P0021240PaS0P@Q0QS60Q2410Q211240PaS0P@Q10Q2
0PaS0QBU0Sg_0QS611cW0Q240QcW0PaS0RU:0QBU0S6<0Q240QBU0Q240QBU0QcW10aS15kg27oo0P00
0Goo000EOol00`00Oomoo`02Ool2BU84Ool2>Lh2@Q028@P248@26<H28@P25:D26<H25:D236<248@2
24829BT25:D224826<H2>Lh236<2>Lh248@46<H200025:D236<248@25:D2000224827>L2248436<2
48@26<H27>L224825:D200027>L236<248@2248248@236<27>L25:D236<22482124436<4124248@4
248236<412400acW12448@0436<248@2124448@21242248236<26<H248@20002248248@2124436<2
48@436<2124236<2000248@46<H2124224826<H25:D2248236<248@236<46<H4248248@2124248@2
36<2000236<2<H`22482;F/29BT236<2;F/29BT25:D236<25:D28@P248@29BT21242:DX2BU82?Nl2
G_L7Ool10001Ool001Eoo`03001oogoo009oo`9:DPAoo`8icP92408Q208@Q08HaP8Q208DY@8HaP8D
Y@8<H`8@Q088@P8U:@8DY@88@P8HaP8icP8<H`8icP8@Q0@HaP80008DY@8<H`8@Q08DY@800088@P8L
i`88@P@<H`8@Q08HaP8Li`88@P8DY@80008Li`8<H`8@Q088@P8@Q08<H`8Li`8DY@8<H`88@P848@@<
H`@48@8@Q0@8@P8<H`@48@037>L48@@Q00@<H`8@Q0848@@@Q0848@88@P8<H`8HaP8@Q0800088@P8@
Q0848@@<H`8@Q0@<H`848@8<H`80008@Q0@HaP848@88@P8HaP8DY@88@P8<H`8@Q08<H`@HaP@8@P8@
Q0848@8@Q08<H`80008<H`8aS088@P8]J`8U:@8<H`8]J`8U:@8DY@8<H`8DY@8Q208@Q08U:@848@8Y
BP9:DP8mk`9Nm`Moo`40005oo`005Goo00<007ooOol00Woo0VLi0Woo0W_N0Sg_0SF]0QBU0QS60S6<
0R480PaS11cW0Q240RU:0Q240RDY0QBU0P@Q0QcW0QBU0P@Q0T8@10@Q0RU:0P@Q0PaS10Q20Q2410Q2
0PaS0Q2421BU0PaS0P000QBU0PaS0QS60PQ20QBU0PQ20QBU0PaS0Q240P@Q0PaS0PQ20P@Q0PaS0PQ2
1P@Q1PQ210@Q00<DY@aS36<00P000P@Q0PQ20Q240PQ20P@Q11240PaS0P@Q0Q240PaS0Q240P000PQ2
0PaS0Q240QBU0P@Q0P000P@Q0Q240QBU0Q240QBU0PQ20QS610@Q0PQ20Q240QcW0P@Q0PQ20Re[0P00
0QS60QBU0PQ21PaS1QS60RU:0QS612480QcW0S6<10Q20RDY11S60SW>0Q240Sg_0Re[0Q240Ukg1goo
0@000Goo000EOol00`00Oomoo`02Ool2IcT2Ool2Nmh2?Nl2=Jd25:D26<H2<H`28@P236<47>L248@2
:DX248@29BT25:D212427>L25:D21242@Q041242:DX2124236<4248248@4248236<248@85:D236<2
00025:D236<26<H224825:D224825:D236<248@2124236<22482124236<224861246248412400aBU
36<<H`0200021242248248@22482124448@236<2124248@236<248@20002248236<248@25:D21242
0002124248@25:D248@25:D224826<H41242248248@27>L212422482;F/200026<H25:D2248636<6
6<H2:DX26<H48@P27>L2<H`424829BT46<H2>Lh248@2?Nl2;F/248@2G_L7Ool10001Ool001Eoo`03
001oogoo009oo`9F]@9oo`9_N`9>L`92408U:@8@Q08HaP848@8]J`8<H`8aS08DY@8]J`8HaP8DY@84
8@8Li`8U:@8HaP88@P@HaP8U:@88@P8HaP8<H`8@Q0H8@P8HaP88@P848@88@PH@Q08<H`88@P800084
8@8<H`8DY@848@8@Q0848@8@Q0800088@P@@Q080008<H`848@88@P848@P<H`8DY@88@P031248@PQ2
008@Q08<H`848@80008<H`8@Q08Q208000848@8<H`8Li`8<H`88@P848@8DY@88@P@48@88@P@@Q088
@P8<H`88@P8DY@848@8<H`8DY@800088@P8Li`8@Q08HaP8<H`8DY@848@8DY@88@P8000@48@@8@P8D
Y@8<H`8Li`@@Q08Q208DY@80008DY@8U:@8@Q088@P8U:@8Li`8@Q08YBP96<@8mk`9S60Moo`40005o
o`005Goo00<007ooOol00Woo0UJe0Woo0Vmk0Tic0T8@0RDY0Q240QS60P@Q0Re[0PaS0S6<0QBU0Re[
0QS60QBU0P@Q0QcW0RDY0QS60PQ211S60RDY0PQ20QS60PaS0Q241PQ20QS60PQ20P@Q0PQ21Q240PaS
0PQ20P000P@Q0PaS0QBU0P@Q0Q240P@Q0Q240P000PQ211240P000PaS0P@Q0PQ20P@Q20aS0QBU0PQ2
00<48@Q224800Q240PaS0P@Q0P000PaS0Q240R480P000P@Q0PaS0QcW0PaS0PQ20P@Q0QBU0PQ210@Q
0PQ211240PQ20PaS0PQ20QBU0P@Q0PaS0QBU0P000PQ20QcW0Q240QS60PaS0QBU0P@Q0QBU0PQ20P00
10@Q10Q20QBU0PaS0QcW11240R480QBU0P000QBU0RDY0Q240PQ20RDY0QcW0Q240RU:0THa0Sg_0V<H
1goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2Ool2IcT2AS428@P2:DX2124236<248@25:D21242
:DX29BT28@P236<26<H45:D224825:D26<H236<22482:DX65:D2248248@436<26<H22486124448@2
000236<200026<H448@236<248@212425:D236<4248248@25:D236<412426<H212425:D212422482
124236<00`Q248@@Q002124624821242248236<212422482124248@2124236<224821242248236<2
248212426<H25:D236<648@4248236<25:D448@236<2124648@26<H236<2248236<25:D26<H248@2
2482000448@27>L26<H29BT2248248@26<H27>L28@P26<H27>L25:D4;F/2:DX9Ool10001Ool000Uo
o`<0009oo`8000Eoo`03001oogoo009oo`9F]@9oo`9W>@96<@8Q208YBP848@8<H`8@Q08DY@848@8Y
BP8U:@8Q208<H`8HaP@DY@88@P8DY@8HaP8<H`88@P8YBPHDY@88@P8@Q0@<H`8HaP88@PH48@@@Q080
008<H`80008HaP@@Q08<H`8@Q0848@8DY@8<H`@8@P8@Q08DY@8<H`@48@8HaP848@8DY@848@88@P84
8@8<H`03248@Q12400848@H8@P848@88@P8<H`848@88@P848@8@Q0848@8<H`88@P848@88@P8<H`88
@P848@8HaP8DY@8<H`H@Q0@8@P8<H`8DY@@@Q08<H`848@H@Q08HaP8<H`88@P8<H`8DY@8HaP8@Q088
@P8000@@Q08Li`8HaP8U:@88@P8@Q08HaP8Li`8Q208HaP8Li`8DY@@]J`8YBPUoo`40005oo`002Woo
00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9JeP9oo`9Nm`9>L`96<@8@Q08<H`8H
aP@@Q08Li`8U:@8@Q088@P8<H`8HaP8@Q08HaP@Li`@<H`8Li`8<H`848@8DY@8000848@88@P848@88
@PH<H`848@8@Q08DY@H48@8<H`88@P@48@88@P800088@P@DY@8000P<H`848@8DY@@48@8<H`848@@8
@P848@0336<8@PQ200@<H`8@Q0@8@P800088@P8<H`8000848@8@Q08<H`848@8000@@Q0848@8@Q08<
H`@8@P8@Q088@P848@8<H`88@P@@Q0@48@@000@48@88@P@48@8HaP88@P848@8<H`8@Q08DY@8<H`8@
Q088@P8<H`8@Q08<H`8HaP8Li`8DY@8HaP8Li`8icP8@Q08Q20@DY@@icP9g_@Moo`40005oo`001goo
1@0000Eoo`00Oomoo`0000Aoo`8000=oo`9JeP9oo`9Nm`9>L`96<@8@Q08<H`8HaP@@Q08Li`8U:@8@
Q088@P8<H`8HaP8@Q08HaP@Li`@<H`8Li`8<H`848@8DY@8000848@88@P848@88@PH<H`848@8@Q08D
Y@H48@8<H`88@P@48@88@P800088@P@DY@8000P<H`848@8DY@@48@8<H`848@@8@P848@0336<8@PQ2
00@<H`8@Q0@8@P800088@P8<H`8000848@8@Q08<H`848@8000@@Q0848@8@Q08<H`@8@P8@Q088@P84
8@8<H`88@P@@Q0@48@@000@48@88@P@48@8HaP88@P848@8<H`8@Q08DY@8<H`8@Q088@P8<H`8@Q08<
H`8HaP8Li`8DY@8HaP8Li`8icP8@Q08Q20@DY@@icP9g_@Ioo`80005oo`001goo00@007ooOol0009o
o`04001oogoo0004Ool00`00Oomoo`02Ool2AS42Ool2Kg/4:DX21242<H`29BT25:D248@26<H21242
36<25:D47>L26<H27>L448@236<25:D28@P236<248@4248236<248@26<H2124236<26<H2248236<2
12420002248600021242248436<66<H248@2248236<21242248248@25:D248@4124236<248@21244
248348@42482124424845:D2000248@236<248@224826<H648@2248236<4124248@2124400021244
36<2248436<21242248448@2248248@236<224826<H2124224845:D236<25:D200028@P29BT26<H2
9BT248@236<224827>L28@P25:D4:DX25:D2;F/2@Q02JeX7Ool10001Ool000Qoo`03001oo`00009o
o`04001oogoo0004Ool00`00Oomoo`02Ool2AS42Ool2Kg/4:DX21242<H`29BT25:D248@26<H21242
36<25:D47>L26<H27>L448@236<25:D28@P236<248@4248236<248@26<H2124236<26<H2248236<2
12420002248600021242248436<66<H248@2248236<21242248248@25:D248@4124236<248@21244
248348@42482124424845:D2000248@236<248@224826<H648@2248236<4124248@2124400021244
36<2248436<21242248448@2248248@236<224826<H2124224845:D236<25:D200028@P29BT26<H2
9BT248@236<224827>L28@P25:D4:DX25:D2;F/2@Q02JeX7Ool10001Ool000Uoo`8000=oo`8000Eo
o`03001oogoo009oo`9JePAoo`8Li`8aS08@Q08YBP92408HaP8aS08@Q08HaP8YBP8HaP8Li`8HaP88
@P8<H`8U:@8DY@8<H`88@P8<H`8HaP88@P8@Q0@<H`88@P8<H`8@Q08DY@88@P8DY@8<H`848@@DY@8<
H`848@8@Q0800088@P80008<H`@8@P848@80008@Q088@P848@8<H`88@P8@Q088@P8<H`8@Q088@P8<
H`8@Q0@<H`D48@8<H`@48@8@Q0@8@P@<H`H8@P8@Q0@<H`88@P@48@80008DY@80008@Q08<H`8@Q08<
H`848@80008@Q088@P8<H`848@@@Q08<H`848@800088@P848@8@Q08<H`8Li`88@P8DY@8000848@8H
aP8Q208Li`8HaP8Q20@8@P8DY@8Li`8@Q08<H`8aS0800088@P9F]@8YBP9JePMoo`40005oo`005Goo
00<007ooOol00Woo0U[F17oo0QcW0S6<0Q240RU:0T8@0QS60S6<0Q240QS60RU:0QS60QcW0QS60PQ2
0PaS0RDY0QBU0PaS0PQ20PaS0QS60PQ20Q2410aS0PQ20PaS0Q240QBU0PQ20QBU0PaS0P@Q11BU0PaS
0P@Q0Q240P000PQ20P000PaS10Q20P@Q0P000Q240PQ20P@Q0PaS0PQ20Q240PQ20PaS0Q240PQ20PaS
0Q2410aS1@@Q0PaS10@Q0Q2410Q210aS1PQ20Q2410aS0PQ210@Q0P000QBU0P000Q240PaS0Q240PaS
0P@Q0P000Q240PQ20PaS0P@Q11240PaS0P@Q0P000PQ20P@Q0Q240PaS0QcW0PQ20QBU0P000P@Q0QS6
0R480QcW0QS60R4810Q20QBU0QcW0Q240PaS0S6<0P000PQ20UJe0RU:0U[F1goo0@000Goo000EOol0
0`00Oomoo`02Ool2Kg/2Ool2CW<2?Nl2;F/27>L29BT28@P248@29BT27>L26<H28@P224827>L248@2
6<H25:D248@236<224826<H4124448@436<2248248@2248436<224825:D2248236<2248236<248@2
248236<2000236<212422482124236<2248236<412440002248248@2248200021242248248@236<2
248336<25:D236<2248236<2248412442482124248@2124248@236<2124224826<H236<2124236<2
248236<2248248@22486124248@236<2124236<25:D424821242248248@25:D212425:D448@20002
12445:D248@28@P236<26<H236<448@236<224829BT26<H236<2BU826<H2DY@7Ool10001Ool001Eo
o`03001oogoo009oo`9_N`9oo`9>L`8mk`8]J`8Li`8U:@8Q208@Q08U:@8Li`8HaP8Q2088@P8Li`8@
Q08HaP8DY@8@Q08<H`88@P8HaP@48@@@Q0@<H`88@P8@Q088@P@<H`88@P8DY@88@P8<H`88@P8<H`8@
Q088@P8<H`80008<H`848@88@P848@8<H`88@P8<H`@48@@00088@P8@Q088@P8000848@88@P8@Q08<
H`88@P<<H`8DY@8<H`88@P8<H`88@P@48@@8@P848@8@Q0848@8@Q08<H`848@88@P8HaP8<H`848@8<
H`88@P8<H`88@P8@Q088@PH48@8@Q08<H`848@8<H`8DY@@8@P848@88@P8@Q08DY@848@8DY@@@Q080
00848@@DY@8@Q08Q208<H`8HaP8<H`@@Q08<H`88@P8U:@8HaP8<H`9:DP8HaP9BU0Moo`40005oo`00
5Goo00<007ooOol00Woo0THa0Woo0Ukg0Re[0T8@0S6<0PaS0R480RDY0QcW0R480RU:0QBU0Q240PaS
0QS611240P000PaS0Q2410Q20R480PaS0PQ20P@Q0PaS0P000Q240P000P@Q0PQ20QcW0PaS0Q240P@Q
0QBU0P@Q10Q211240PQ20PaS0PQ20QBU0PaS0QBU0PaS0Q240P0011240PaS0P000PQ20PaS0P@Q1PaS
0P@Q00<8@P@Q12400PQ20Q240P@Q0Q240PQ20P@Q0PaS10@Q0QS60PQ20P@Q0PaS10Q20P@Q0Q240P00
0PaS0P@Q0Q240PQ20Q240PaS0Q2410Q20Q240PQ20QBU0PaS0QBU0PQ20P@Q0PaS0R480Q240PQ20QcW
10Q20QBU0Q240P000PaS0QBU0P@Q0QS60Q240PaS0QS611BU0Q2411S611BU0Q240SF]0Re[0U[F1goo
0@000Goo000EOol00`00Oomoo`02Ool2AS42Ool2G_L2;F/2@Q02<H`236<28@P29BT27>L28@P2:DX2
5:D248@236<26<H448@2000236<248@424828@P236<22482124236<2000248@20002124224827>L2
36<248@212425:D21244248448@2248236<224825:D236<25:D236<248@2000448@236<200022482
36<2124636<212400`Q212448@02248248@2124248@22482124236<412426<H22482124236<42482
124248@2000236<2124248@2248248@236<248@4248248@224825:D236<25:D22482124236<28@P2
48@224827>L424825:D248@2000236<25:D212426<H248@236<26<H45:D248@46<H45:D248@2=Jd2
;F/2F]H7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9oo`9W>@8aS08e[@8YBP8DY@8<H`8Q2088
@P8Q20X<H`8DY@8<H`88@P8@Q088@P8<H`8DY@8@Q08U:@8<H`@48@8<H`848@8DY@848@8<H`8@Q08D
Y@8<H`848@8000848@@<H`848@8<H`848@88@P8000H@Q08<H`848@8HaP8<H`8@Q08DY@8<H`@8@P8<
H`8DY@8<H`8@Q08<H`03248@Q12400@48@@<H`848@88@P848@88@P8@Q0@8@P848@8<H`88@P8000@4
8@8HaP@8@P8<H`80008DY@8<H`@8@P8DY@848@8HaP8@Q08DY@8000848@8<H`8@Q0@8@P8HaP848@8<
H`8DY@848@8@Q08DY@88@P8HaPH<H`8@Q08HaP@8@P8YBP@HaP8DY@8<H`88@P8icP92409_N`Moo`40
005oo`005Goo0P000goo0Tic0Woo0VLi0S6<0SF]0RU:0QBU0PaS0R480PQ20R482PaS0QBU0PaS0PQ2
0Q240PQ20PaS0QBU0Q240RDY0PaS10@Q0PaS0P@Q0QBU0P@Q0PaS0Q240QBU0PaS0P@Q0P000P@Q10aS
0P@Q0PaS0P@Q0PQ20P001Q240PaS0P@Q0QS60PaS0Q240QBU0PaS10Q20PaS0QBU0PaS0Q240PaS00<8
@Q2448@010@Q10aS0P@Q0PQ20P@Q0PQ20Q2410Q20P@Q0PaS0PQ20P0010@Q0QS610Q20PaS0P000QBU
0PaS10Q20QBU0P@Q0QS60Q240QBU0P000P@Q0PaS0Q2410Q20QS60P@Q0PaS0QBU0P@Q0Q240QBU0PQ2
0QS61PaS0Q240QS610Q20RU:11S60QBU0PaS0PQ20SW>0T8@0Vmk1Woo0P000Goo000EOol00`00Oomo
o`02Ool2DY@2Ool2JeX2BU82=Jd212425:D248@2124448@236<25:D248@200025:D224829BT236<6
48@46<H2248248@25:D212426<H25:D20002124248@4124248@2124248@236<4248412425:D20002
248236<2248236<2248236<4248248@4248436<4248612400`Q212448@02248248@2248248@41242
36<2248236<21242000236<2124436<4124236<6248236<2124224825:D4124248@2248236<20002
36<27>L436<2124236<25:D224821242248448@236<248@224825:D2248236<27>L236<248@25:D2
24826<H224845:D26<H29BT2CW<2IcT7Ool10001Ool001Eoo`03001oogoo009oo`9BU09oo`9[FP9:
DP8e[@848@8DY@8@Q0848@@@Q08<H`8DY@8@Q080008DY@88@P8U:@8<H`H@Q0@HaP88@P8@Q08DY@84
8@8HaP8DY@8000848@8@Q0@48@8@Q0848@8@Q08<H`@8@P@48@8DY@800088@P8<H`88@P8<H`88@P8<
H`@8@P8@Q0@8@P@<H`@8@PH48@0324848@@Q0088@P8@Q088@P8@Q0@48@8<H`88@P8<H`848@80008<
H`848@@<H`@48@8<H`H8@P8<H`848@88@P8DY@@48@8@Q088@P8<H`80008<H`8Li`@<H`848@8<H`8D
Y@88@P848@88@P@@Q08<H`8@Q088@P8DY@88@P8<H`8Li`8<H`8@Q08DY@88@P8HaP88@P@DY@8HaP8U
:@9>L`9W>@Moo`40005oo`005Goo00<007ooOol00Woo0VLi0Woo0V]J0R480SF]0Q240PaS0QcW0Q24
0QcW0P@Q0PaS0QBU0Q240QBU0P@Q10Q20Q240QS60QBU10@Q0QS60PaS0Q240PQ20P@Q0Q240PaS0PQ2
0Q240PQ20Q240QBU20aS0QS60PaS0QBU0PaS0QS60P@Q0PaS0Q240PQ20P@Q0QBU10aS0PQ20P@Q0PaS
0P@Q0PaS3@@Q0PQ20PaS0PQ210aS0Q241P@Q10Q20PaS0PQ20Q240PQ20PaS1PQ20Q240P@Q10Q20PaS
0PQ20PaS0PQ20Q240PaS0PQ2112410@Q0Q240QS610@Q0PQ20P@Q1PaS0QBU0RDY0QS60RDY0PaS0Q24
0PQ20Q240QcW0QBU0PaS0QBU0Q2411cW0Q240QcW0THa0S6<0V<H1goo0@000Goo000EOol00`00Oomo
o`02Ool2IcT2Ool2JeX28@P2=Jd248@236<27>L248@27>L2124236<25:D248@25:D21244248248@2
6<H25:D412426<H236<248@22482124248@236<2248248@2248248@25:D836<26<H236<25:D236<2
6<H2124236<248@2248212425:D436<22482124236<2124236<=1242248236<2248436<248@61244
248236<2248248@2248236<6248248@21244248236<2248236<2248248@236<2248448@4124248@2
6<H412422482124636<25:D29BT26<H29BT236<248@2248248@27>L25:D236<25:D248@47>L248@2
7>L2AS42<H`2HaP7Ool10001Ool001Eoo`03001oogoo009oo`9S609oo`9S608YBP8mk`8Li`8<H`8@
Q08HaP8DY@@@Q088@P8U:@8HaP8@Q08<H`@@Q08DY@8<H`88@P8<H`@HaP8<H`8@Q088@P848@@0008H
aP@8@P8DY@8<H`@8@P8@Q08DY@88@P8<H`800088@P848@88@P@<H`848@H00088@P848@8<H`@8@P84
8@88@P8DY@@48@8<H`T8@P8000@48@8<H`848@88@P848@88@P8<H`88@P8@Q0@00088@P@000848@8<
H`88@P@48@800088@P@<H`848@H000@@Q0@Li`@8@P848@8<H`8HaP8@Q08DY@88@P8@Q0800088@P8L
i`88@P848@8<H`88@P8@Q08YBP8<H`848@8e[@8DY@848@9:DP8YBP9Nm`Moo`40005oo`005Goo00<0
07ooOol00Woo0V<H0Woo0V<H0RU:0Sg_0QcW0PaS0Q240QS60QBU11240PQ20RDY0QS60Q240PaS1124
0QBU0PaS0PQ20PaS11S60PaS0Q240PQ20P@Q10000QS610Q20QBU0PaS10Q20Q240QBU0PQ20PaS0P00
0PQ20P@Q0PQ210aS0P@Q1P000PQ20P@Q0PaS10Q20P@Q0PQ20QBU10@Q0PaS2@Q20P0010@Q0PaS0P@Q
0PQ20P@Q0PQ20PaS0PQ20Q2410000PQ210000P@Q0PaS0PQ210@Q0P000PQ210aS0P@Q1P00112411cW
10Q20P@Q0PaS0QS60Q240QBU0PQ20Q240P000PQ20QcW0PQ20P@Q0PaS0PQ20Q240RU:0PaS0P@Q0SF]
0QBU0P@Q0TYB0RU:0Ukg1goo0@000Goo000EOol00`00Oomoo`02Ool2AS42Ool2HaP2=Jd2:DX29BT2
6<H25:D2248248@29BT436<29BT436<2000236<25:D248@2000224826<H2248236<2248236<248@2
248212425:D448@236<224825:D2000248@25:D224827>L236<25:D612426<H436<2124448@22482
0006124248@42482124236<224831242000212422482124200042482124236<200021242248248@2
36<2124436<25:D248@236<224820002248248@2248236<25:D2248248@85:D2248248@2248236<2
48@236<2124236<2248236<2124248@436<45:D248@236<248@27>L2248248@212426<H25:D248@2
:DX2;F/2IcT7Ool10001Ool001Eoo`03001oogoo009oo`96<@9oo`9S608e[@8YBP8U:@8HaP8DY@88
@P8@Q08U:@@<H`8U:@@<H`80008<H`8DY@8@Q0800088@P8HaP88@P8<H`88@P8<H`8@Q088@P848@8D
Y@@@Q08<H`88@P8DY@80008@Q08DY@88@P8Li`8<H`8DY@H48@8HaP@<H`848@@@Q088@P8000H48@8@
Q0@8@P848@8<H`88@P<48@8000848@88@P848@8000@8@P848@8<H`8000848@88@P8@Q08<H`848@@<
H`8DY@8@Q08<H`88@P800088@P8@Q088@P8<H`8DY@88@P8@Q0PDY@88@P8@Q088@P8<H`8@Q08<H`84
8@8<H`88@P8<H`848@8@Q0@<H`@DY@8@Q08<H`8@Q08Li`88@P8@Q0848@8HaP8DY@8@Q08YBP8]J`9W
>@Moo`40005oo`005Goo00<007ooOol00Woo0SF]0Woo0VLi0Re[0Sg_0R480QS610Q211BU0QcW0PQ2
10aS0PQ20QcW0P000QBU0QS60P@Q0QBU10Q210aS0P@Q0PaS10000PaS10000Q240P@Q0P000PaS0QBU
0P000PaS0QBU0Q240QBU0PaS10@Q0PaS0Q2410@Q0PQ20P@Q0PaS2P@Q0PaS0P000PQ20P@Q0PQ200<0
00@Q12400P@Q0PaS10Q211240PQ20P@Q10Q20P@Q0P000Q240PaS0P0010aS0QBU0PaS0P@Q0PaS0PQ2
0Q2411BU11S60Q240PaS11240PaS0P000P@Q0PQ20P@Q0QcW0P000PaS0P000PaS0R480PQ20QS60PQ2
0Q240PaS0P@Q11240P@Q0QS60RU:10@Q0QS611cW0QBU12e[0UJe1goo0@000Goo000EOol20003Ool2
=Jd2Ool2IcT2;F/2?Nl28@P26<H424845:D27>L2248436<224827>L200025:D26<H212425:D42484
36<2124236<4000236<4000248@21242000236<25:D2000236<25:D248@25:D236<4124236<248@4
12422482124236<:124236<200022482124224800`0012448@02124236<4248448@2248212442482
1242000248@236<2000436<25:D236<2124236<2248248@45:D46<H248@236<448@236<200021242
248212427>L2000236<2000236<28@P224826<H2248248@236<2124448@212426<H2:DX412426<H4
7>L25:D4;F/2E[D6Ool20001Ool001Eoo`03001oogoo009oo`96<@9oo`9JeP8Q208e[@8U:@8@Q08<
H`8DY@88@P8@Q08DY@8HaP8<H`@48@88@P8<H`8DY@8<H`8000@<H`848@8DY@88@P8@Q088@P848@88
@P8@Q08<H`H48@88@P8<H`848@8<H`8@Q0@<H`8DY@848@8<H`88@P800088@P8U:@@48@8DY@88@P@4
8@8<H`88@P8@Q088@P@<H`848@88@P0348@8@PQ20080008DY@8<H`848@88@P848@8@Q0848@8000H4
8@8000@48@8@Q0@8@PH<H`848@8DY@@48@8<H`8HaP88@P80008HaP8<H`88@P@@Q088@P848@@<H`88
@P8@Q08Li`8<H`H8@P8HaP88@P8DY@88@P8Li`@DY@8@Q08HaP8Q208DY@88@P8@Q08Li`@aS09BU0Mo
o`40005oo`005Goo00<007ooOol00Woo0THa0Woo0U[F0R480SF]0RDY0Q240PaS0QBU0PQ20Q240QBU
0QS60PaS10@Q0PQ20PaS0QBU0PaS0P0010aS0P@Q0QBU0PQ20Q240PQ20P@Q0PQ20Q240PaS1P@Q0PQ2
0PaS0P@Q0PaS0Q2410aS0QBU0P@Q0PaS0PQ20P000PQ20RDY10@Q0QBU0PQ210@Q0PaS0PQ20Q240PQ2
10aS0P@Q0PQ200<@Q0Q224800P000QBU0PaS0P@Q0PQ20P@Q0Q240P@Q0P001P@Q0P0010@Q0Q2410Q2
1PaS0P@Q0QBU10@Q0PaS0QS60PQ20P000QS60PaS0PQ211240PQ20P@Q10aS0PQ20Q240QcW0PaS1PQ2
0QS60PQ20QBU0PQ20QcW11BU0Q240QS60R480QBU0PQ20Q240QcW136<0U:D1goo0@000Goo000EOol0
0`00Oomoo`02Ool2@Q02Ool2JeX29BT2?Nl436<27>L200025:D26<H448@25:D26<H2000224826<H2
24827>L424825:D2248200061242248236<248@4248236<20002124236<248@436<4124236<26<H2
000236<2248236<200021242000248@2248236<4248400022482124236<2124236<00`Q212448@02
36<248@212420002124636<2124236<2248236<200022482124236<448@25:D236<248@2124436<2
48@2000248@4000436<624821242248236<25:D22482000436<25:D236<200026<H248@624821242
36<224827>L25:D248@212445:D2?Nl2<H`2BU87Ool10001Ool001Eoo`03001oogoo009oo`92409o
o`9[FP8U:@8mk`@<H`8Li`80008DY@8HaP@@Q08DY@8HaP800088@P8HaP88@P8Li`@8@P8DY@88@P80
00H48@88@P8<H`8@Q0@8@P8<H`8000848@8<H`8@Q0@<H`@48@8<H`8HaP80008<H`88@P8<H`800084
8@80008@Q088@P8<H`@8@P@00088@P848@8<H`848@8<H`0324848@@Q008<H`8@Q0848@8000848@H<
H`848@8<H`88@P8<H`800088@P848@8<H`@@Q08DY@8<H`8@Q0848@@<H`8@Q080008@Q0@000@<H`H8
@P848@88@P8<H`8DY@88@P8000@<H`8DY@8<H`80008HaP8@Q0H8@P848@8<H`88@P8Li`8DY@8@Q084
8@@DY@8mk`8aS09:DPMoo`40005oo`005Goo00<007ooOol00Woo0Tic0Woo0V]J0Re[0SW>0PaS0Q24
0QS60PaS0PQ20QS60P@Q0Q240R480P@Q0PQ20P@Q0QS60PQ20P@Q0PQ20PaS0P@Q10aS0P@Q0PQ20PaS
0PQ20P@Q0PaS0P000P@Q0Q240P0010Q20P@Q0QS61PaS10@Q0PQ20P000QS60P@Q0Q240QBU0PQ210@Q
0PaS0PQ210@Q0PQ20P@Q0PQ20Q240PQ20P@Q00<8@PaS36<010@Q0Q2410aS0P000P@Q0PaS0P@Q0P00
0PQ20QBU0PQ20PaS0P001P@Q10aS0P0010aS10Q20PaS10Q20Q240PaS0QS60P@Q0PQ20PaS0QBU0Q24
0PaS0Q240PaS0P@Q0R480P@Q0PQ20PaS0PQ20Q240QBU0Q240QS60PaS0P@Q0P000PaS0Q2410aS0QcW
11240THa0RU:0WNm1goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2JeX2;F/2>Lh236<248@2
6<H236<224826<H2124248@28@P21242248212426<H224821242248236<2124436<21242248236<2
2482124236<20002124248@20004248212426<H636<41242248200026<H2124248@25:D224841242
36<22484124224821242248248@2248212400`Q236<<H`04124248@436<20002124236<212420002
24825:D2248236<20006124436<2000436<4248236<4248248@236<26<H21242248236<25:D248@2
36<248@236<212428@P21242248236<2248248@25:D248@26<H236<21242000236<248@436<27>L4
48@2AS42:DX2Mkd7Ool10001Ool001Eoo`03001oogoo009oo`9:DP9oo`9W>@8]J`8mk`8Li`8HaP8L
i`8DY@8@Q08DY@8HaP8000P<H`8000@<H`8000848@8<H`8DY@88@P8<H`8DY@848@8Li`88@P@<H`8@
Q088@P848@8<H`88@P8@Q0@8@P848@88@P800088@P8HaP8000@<H`848@@DY@@8@P848@88@P848@88
@P8@Q08000848@8<H`88@P8@Q0D48@8<H`848@8U:@88@P8@Q0@48@8@Q0848@8000@48@8@Q080008D
Y@8@Q088@P80008<H`8@Q08<H`8@Q08000848@8<H`848@@@Q088@P@<H`8@Q08DY@@48@H<H`88@P80
008<H`8DY@8<H`848@8@Q080008@Q0@HaP@48@@DY@@<H`8HaP8DY@8HaP8]J`8aS09JePMoo`40005o
o`005Goo00<007ooOol00Woo0TYB0Woo0VLi0Re[0Sg_0QcW0QS60QcW0QBU0Q240QBU0QS60P0020aS
0P0010aS0P000P@Q0PaS0QBU0PQ20PaS0QBU0P@Q0QcW0PQ210aS0Q240PQ20P@Q0PaS0PQ20Q2410Q2
0P@Q0PQ20P000PQ20QS60P0010aS0P@Q11BU10Q20P@Q0PQ20P@Q0PQ20Q240P000P@Q0PaS0PQ20Q24
1@@Q0PaS0P@Q0RDY0PQ20Q2410@Q0Q240P@Q0P0010@Q0Q240P000QBU0Q240PQ20P000PaS0Q240PaS
0Q240P000P@Q0PaS0P@Q11240PQ210aS0Q240QBU10@Q1PaS0PQ20P000PaS0QBU0PaS0P@Q0Q240P00
0Q2411S610@Q11BU10aS0QS60QBU0QS60Re[0S6<0U[F1goo0@000Goo000EOol00`00Oomoo`02Ool2
CW<2Ool2G_L2:DX2=Jd2:DX29BT27>L224829BT2124236<25:D26<H4248236<212425:D248@236<2
248636<21242248436<248@236<20002248436<448@412422482124436<248@6124236<224821242
48@25:D2124236<2124236<200081242248212400`aS48@@Q002248200041242248212426<H20002
36<224820002124224825:D2124248@2248236<224825:D4124248@25:D2248248@236<624820002
36<25:D224820002248236<21242248236<6248436<22482124448@2248448@2124236<248@22482
48@28@P25:D2:DX2=Jd2AS47Ool10001Ool001Eoo`8000=oo`9>L`9oo`9Nm`8YBP8e[@8YBP8U:@8L
i`88@P8U:@848@8<H`8DY@8HaP@8@P8<H`848@8DY@8@Q08<H`88@PH<H`848@88@P@<H`8@Q08<H`80
0088@P@<H`@@Q0@48@88@P848@@<H`8@Q0H48@8<H`88@P848@8@Q08DY@848@8<H`848@8<H`8000P4
8@88@P848@0336<@Q1240088@P8000@48@88@P848@8HaP80008<H`88@P8000848@88@P8DY@848@8@
Q088@P8<H`88@P8DY@@48@8@Q08DY@88@P8@Q08<H`H8@P80008<H`8DY@88@P800088@P8<H`848@88
@P8<H`H8@P@<H`88@P848@@@Q088@P@@Q0848@8<H`8@Q088@P8@Q08Q208DY@8YBP8e[@96<@Ioo`80
005oo`005Goo00<007ooOol00Woo0T8@0Woo0V<H0RDY0RU:0QBU0RU:0QBU0QS60PaS0Q240P@Q0QS6
0QBU0PaS0Q240QS60PQ20PaS0QBU10aS0R480PaS0QS60P@Q0Q240PaS0PQ20PaS0PQ20P000P@Q0PaS
11240PaS10Q20P@Q0P000PaS0PQ20P@Q0QBU0QS60P@Q112410@Q0PQ20P000PQ20P@Q10aS0PQ210@Q
0Q240PQ20Q240`@Q100010@Q0PaS0P000PaS0P@Q0Q240P@Q0QBU10@Q10Q210@Q0P000PaS0PQ20P@Q
0Q240PQ20P@Q0PQ20QBU0Q240P@Q0PQ20P000Q240QcW0PQ20PaS0Q240PQ20Q240P@Q0PQ20P@Q0PQ2
0QcW0QBU0PaS0PQ20PaS0QS60PQ20Q240PQ20QcW0PQ20P0010Q20PaS0RDY0QS60PaS0T8@0SF]0V<H
1goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02Ool2HaP29BT2:DX25:D2:DX25:D26<H236<248@2
12426<H25:D236<248@26<H2248236<25:D436<28@P236<26<H2124248@236<2248236<224820002
124236<448@236<424821242000236<2248212425:D26<H2124448@41242248200022482124436<2
2484124248@2248248@312440004124236<2000236<2124248@212425:D4124424841242000236<2
2482124248@22482124224825:D248@212422482000248@27>L2248236<248@2248248@212422482
124224827>L25:D236<2248236<26<H2248248@224827>L224820004248236<29BT26<H236<2@Q02
=Jd2HaP7Ool10001Ool001Eoo`03001oogoo009oo`9BU09oo`9Nm`8]J`8icP8DY@8Q208U:@88@P@4
8@88@P8U:@8HaP8@Q08DY@@@Q08<H`848@8DY@88@P80008<H`88@P8<H`848@8@Q08<H`88@P8<H`80
008@Q08<H`8@Q0H<H`80008@Q08<H`88@P848@8<H`848@88@P848@@8@P8<H`8000848@@8@P8HaP88
@P8<H`88@P8<H`@48@8<H`88@P03124<H`aS008<H`H8@P8000848@8000@48@88@P848@8@Q0848@8<
H`8000H8@P8DY@@8@P8DY@848@8@Q088@P@48@8<H`88@P848@@8@P80008DY@@@Q080008@Q088@P8<
H`8HaP8@Q0848@8HaP8<H`8Li`8DY@80008DY@8000@HaP88@P8<H`@@Q08DY@8@Q0848@92408aS09B
U0Moo`40005oo`005Goo00<007ooOol00Woo0U:D0Woo0Ukg0Re[0SW>0QBU0R480RDY0PQ210@Q0PQ2
0RDY0QS60Q240QBU11240PaS0P@Q0QBU0PQ20P000PaS0PQ20PaS0P@Q0Q240PaS0PQ20PaS0P000Q24
0PaS0Q241PaS0P000Q240PaS0PQ20P@Q0PaS0P@Q0PQ20P@Q10Q20PaS0P000P@Q10Q20QS60PQ20PaS
0PQ20PaS10@Q0PaS0PQ200<48@aS36<00PaS1PQ20P000P@Q0P0010@Q0PQ20P@Q0Q240P@Q0PaS0P00
1PQ20QBU10Q20QBU0P@Q0Q240PQ210@Q0PaS0PQ20P@Q10Q20P000QBU11240P000Q240PQ20PaS0QS6
0Q240P@Q0QS60PaS0QcW0QBU0P000QBU0P0011S60PQ20PaS11240QBU0Q240P@Q0T8@0S6<0U:D1goo
0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2DY@2=Jd2;F/248@20002:DX436<248@236<2:DX6
6<H224841242248436<4124236<2248448@2124236<248@25:D236<212422482124236<424826<H2
24826<H236<21242248236<25:D20004248212422482124248@2248236<224841244248436<32486
12462482124236<248@236<212422482124236<2248236<248@2248212462482000236<224825:D2
24825:D2248448@2248236<26<H21242248248@22482124224826<H436<26<H212425:D212422482
36<2124236<25:D224827>L2000236<48@P236<2AS42=Jd2E[D7Ool10001Ool001Eoo`03001oogoo
009oo`9>L`9oo`9BU08e[@8]J`8@Q080008YBP@<H`8@Q08<H`8YBPHHaP88@P@48@88@P@<H`@48@8<
H`88@P@@Q0848@8<H`8@Q08DY@8<H`848@88@P848@8<H`@8@P8HaP88@P8HaP8<H`848@88@P8<H`8D
Y@8000@8@P848@88@P848@8@Q088@P8<H`88@P@48@@8@P@<H`<8@PH48@H8@P848@8<H`8@Q08<H`84
8@88@P848@8<H`88@P8<H`8@Q088@P848@H8@P80008<H`88@P8DY@88@P8DY@88@P@@Q088@P8<H`8H
aP848@88@P8@Q088@P848@88@P8HaP@<H`8HaP848@8DY@848@88@P8<H`848@8<H`8DY@88@P8Li`80
008<H`@Q208<H`96<@8e[@9F]@Moo`40005oo`005Goo00<007ooOol00Woo0T8@0Woo0Ukg0QS60SW>
0Q240P000QcW1QS60P@Q0RU:11BU0P@Q112410aS10000P@Q0QBU10Q20P@Q0QBU0PQ20PaS0PQ210@Q
0PaS0PQ20PaS0P@Q0PaS0P000PaS0PQ20Q2410Q20P000PaS0PQ20P@Q0Q240P000PaS10Q20PaS0PQ2
0P@Q0PaS0PQ20QBU0P@Q0P000PaS0PQ200<48ABU5:D00P000PaS0Q240QBU0P@Q0PaS1PQ20P@Q0Q24
0P000Q240PQ210000P@Q10aS0P000P@Q0PQ20P000P@Q0PQ210aS10@Q0PaS0QBU0PQ20PaS10Q20P@Q
0PaS0Q240P@Q0PQ20PaS0Q240QBU0Q240PaS0QBU0PaS0Q240P@Q0Q240QBU0PQ20QcW0Q240R480QBU
0RU:0Q240R480S6<0RU:0V<H1goo0@000Goo0007Ool30004Ool20005Ool00`00Oomoo`02Ool2@Q02
Ool2G_L26<H2>Lh248@200027>L66<H21242:DX45:D2124448@436<4000212425:D4248212425:D2
248236<22484124236<2248236<2124236<2000236<2248248@42482000236<22482124248@20002
36<4248236<22482124236<224825:D21242000236<224800`@Q5:DDY@02000236<248@25:D21242
36<62482124248@2000248@224840002124436<200021242248200021242248436<4124236<25:D2
248236<42482124236<248@21242248236<248@25:D248@236<25:D236<248@2124248@25:D22482
7>L248@28@P25:D2:DX248@28@P2<H`2:DX2HaP7Ool10001Ool000Moo`04001oogoo0002Ool01000
Oomoo`0017oo00<007ooOol00Woo0THa0Woo0UJe136<0PaS0PQ211BU11240PaS0QcW0PQ20P@Q0PaS
0QBU0QS60PaS0QS611240PaS0QS60PQ20P@Q0PaS0P000PQ20P000PQ20Q240P@Q0Q2410Q20P@Q0PaS
0QcW0PQ20PaS10@Q10Q20P0010@Q0Q240P@Q0P000Q240P@Q0PQ20P@Q10Q20PaS0PQ20P000PQ20P@Q
0PQ200<DY@Q2248010@Q10Q20P@Q0Q240PaS0PQ210aS0Q240PQ20PaS0Q240PQ20Q241PaS0PQ210@Q
0P000PQ20Q240PaS0P@Q0PQ20PaS10@Q0PaS0PQ20Q2410@Q0PaS0Q240PaS0P000PQ20QcW10aS0QBU
0Q2410aS0P@Q0QS61Q240PaS0RDY0PaS11S60QcW0Re[0QS60Ukg1goo0@000Goo0007Ool01000Oomo
o`000Woo00@007ooOol000Aoo`8000=oo`96<@9oo`9F]@@aS08<H`88@P@DY@@@Q08<H`8Li`88@P84
8@8<H`8DY@8HaP8<H`8HaP@@Q08<H`8HaP88@P848@8<H`800088@P800088@P8@Q0848@8@Q0@8@P84
8@8<H`8Li`88@P8<H`@48@@8@P8000@48@8@Q0848@80008@Q0848@88@P848@@8@P8<H`88@P800088
@P848@88@P035:D8@PQ200@48@@8@P848@8@Q08<H`88@P@<H`8@Q088@P8<H`8@Q088@P8@Q0H<H`88
@P@48@800088@P8@Q08<H`848@88@P8<H`@48@8<H`88@P8@Q0@48@8<H`8@Q08<H`800088@P8Li`@<
H`8DY@8@Q0@<H`848@8HaPH@Q08<H`8U:@8<H`@HaP8Li`8]J`8HaP9Nm`Ioo`80005oo`001goo0`00
0goo00@007ooOol000Aoo`03001oogoo009oo`8icP9oo`9JeP8aS08icP848@8DY@8@Q08<H`8DY@8<
H`8DY@88@P8Li`8<H`8Li`848@8<H`848@8<H`88@P@<H`@8@P8<H`8@Q0848@@@Q0H<H`848@8HaP8D
Y@88@P@DY@8<H`848@8@Q08<H`80008DY@8@Q0@8@P8DY@88@P8<H`88@PH@Q0848@88@PH<H`8000D@
Q080008@Q088@P848@80008<H`88@P848@88@P80008@Q0@8@P8<H`848@@8@P848@8DY@848@88@P8<
H`848@@<H`8@Q088@P8<H`848@8<H`848@P<H`8Li`848@8@Q080008<H`8@Q08DY@88@P8DY@8Li`8H
aP88@P8DY@H8@P8Li`8@Q0@8@P8U:@8DY@@@Q08U:@8Q208aS09F]@Moo`40005oo`0027oo00<007oo
Ool00Woo00@007ooOol000Aoo`03001oogoo009oo`8icP9oo`9JeP8aS08icP848@8DY@8@Q08<H`8D
Y@8<H`8DY@88@P8Li`8<H`8Li`848@8<H`848@8<H`88@P@<H`@8@P8<H`8@Q0848@@@Q0H<H`848@8H
aP8DY@88@P@DY@8<H`848@8@Q08<H`80008DY@8@Q0@8@P8DY@88@P8<H`88@PH@Q0848@88@PH<H`80
00D@Q080008@Q088@P848@80008<H`88@P848@88@P80008@Q0@8@P8<H`848@@8@P848@8DY@848@88
@P8<H`848@@<H`8@Q088@P8<H`848@8<H`848@P<H`8Li`848@8@Q080008<H`8@Q08DY@88@P8DY@8L
i`8HaP88@P8DY@H8@P8Li`8@Q0@8@P8U:@8DY@@@Q08U:@8Q208aS09F]@Moo`40005oo`0027oo0`00
0goo0P001Goo00<007ooOol00Woo0TYB0Woo0U[F0RU:0Sg_0PaS0QcW0RDY0PaS0P@Q1PaS0Q240P@Q
0RU:0QcW0PaS10Q20Q240PQ20PaS0PQ20PaS0QBU0PaS11240PQ20PaS0QBU0PaS0P@Q0PaS0Q240PaS
0P000P@Q0PaS10@Q0PQ20P@Q10Q20P@Q0PQ20P0010aS0PQ21PaS10Q20P@Q0PQ20PaS0P@Q11241@Q2
0QBU0PQ20PaS0P@Q0P0010Q20P@Q0QBU0PQ20PaS0P@Q0PaS0P@Q0PQ211240PaS0Q240PQ210@Q10Q2
0P000PaS0P@Q0PQ20Q240PQ20PaS0PQ20P@Q0PQ20P000PaS0Q240PaS0Q240PaS0PQ20Q240QBU0P@Q
0R480PaS0QBU11S60Q2410@Q0RU:0P@Q0Q240S6<0PaS0R480Sg_0S6<0TYB1goo0@000Goo000EOol0
0`00Oomoo`02Ool2BU82Ool2F]H2:DX2?Nl236<27>L29BT236<2124636<248@21242:DX27>L236<4
248248@2248236<2248236<25:D236<448@2248236<25:D236<2124236<248@236<20002124236<4
124224821244248212422482000436<2248636<424821242248236<2124448@524825:D2248236<2
12420004248212425:D2248236<2124236<21242248448@236<248@2248412442482000236<21242
248248@2248236<2248212422482000236<248@236<248@236<2248248@25:D212428@P236<25:D4
6<H248@41242:DX2124248@2<H`236<28@P2?Nl2<H`2BU87Ool10001Ool001Eoo`03001oogoo009o
o`9:DP9oo`9BU08aS08YBP8Li`8@Q08U:@88@P@DY@88@P8Li`8@Q088@P8HaP8Li`88@P8<H`8DY@8<
H`@@Q08DY@8<H`800088@P8<H`80008DY@8@Q0H8@P8000P48@@<H`88@P8@Q080008<H`88@PH<H`8@
Q080008<H`88@P8@Q08HaP848@88@P8<H`@8@P8<H`88@P80000336<8@PQ20088@P848@88@P848@8@
Q080008<H`88@P@00088@P848@8<H`848@88@P8<H`88@P848@8000848@88@P@<H`@8@P8<H`8HaP@<
H`848@88@P80008<H`88@P@<H`@8@P848@@HaP80008<H`88@P8<H`8@Q08Li`8HaP8Q20848@8DY@@0
008Q2088@P848@8DY@8@Q08DY@8YBP8DY@96<@Moo`40005oo`005Goo00<007ooOol00Woo0TYB0Woo
0U:D0S6<0RU:0QcW0Q240RDY0PQ211BU0PQ20QcW0Q240PQ20QS60QcW0PQ20PaS0QBU0PaS11240QBU
0PaS0P000PQ20PaS0P000QBU0Q241PQ20P0020@Q10aS0PQ20Q240P000PaS0PQ21PaS0Q240P000PaS
0PQ20Q240QS60P@Q0PQ20PaS10Q20PaS0PQ20P0000<<H`Q224800PQ20P@Q0PQ20P@Q0Q240P000PaS
0PQ210000PQ20P@Q0PaS0P@Q0PQ20PaS0PQ20P@Q0P000P@Q0PQ210aS10Q20PaS0QS610aS0P@Q0PQ2
0P000PaS0PQ210aS10Q20P@Q11S60P000PaS0PQ20PaS0Q240QcW0QS60R480P@Q0QBU10000R480PQ2
0P@Q0QBU0Q240QBU0RU:0QBU0THa1goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2HaP2@Q02
:DX25:D248@27>L248@25:D26<H248@236<27>L236<248@25:D42482124248@236<25:D2124248@2
0002124224826<H248@236<22482000224827>L20002124200021244248436<224825:D4000248@2
248236<224821244248236<6248236<2248236<2248236<00`@Q48@@Q002124248@2124236<22482
124248@2248412422482124248@436<41242248200022482000236<200021242248236<2124248@2
00021242000248@236<25:D46<H224825:D248@236<45:D2248436<224826<H2000236<2248436<2
48@236<29BT26<H2;F/25:D236<2<H`248@2F]H7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9o
o`9S6092408YBP8DY@8@Q08Li`8@Q08DY@8HaP8@Q08<H`8Li`8<H`8@Q08DY@@8@P848@8@Q08<H`8D
Y@848@8@Q08000848@88@P8HaP8@Q08<H`88@P800088@P8Li`8000848@8000848@@8@P@<H`88@P8D
Y@@0008@Q088@P8<H`88@P848@@8@P8<H`H8@P8<H`88@P8<H`88@P8<H`03124@Q12400848@8@Q084
8@8<H`88@P848@8@Q088@P@48@88@P848@8@Q0@<H`@48@88@P800088@P80008<H`8000848@88@P8<
H`848@8@Q08000848@80008@Q08<H`8DY@@HaP88@P8DY@8@Q08<H`@DY@88@P@<H`88@P8HaP80008<
H`88@P@<H`8@Q08<H`8U:@8HaP8]J`8DY@8<H`8aS08@Q09JePMoo`40005oo`005Goo00<007ooOol0
0Woo0THa0Woo0U[F0SF]0SW>0Q240PQ20QBU0PaS0Q240P@Q0QBU0PQ21Q240QBU0P000Q2410aS0QBU
0PQ20QS60P@Q0P0011241PaS0QBU0PQ20PaS0PQ210aS0Q240PQ20QS60QBU10aS0Q240P@Q0Q240PQ2
0P@Q0PQ20PaS100010Q20P000PaS10Q20Q240PaS0P@Q0PQ20PaS00<48@Q224800P@Q0PaS0PQ20P@Q
0PaS0Q2410Q20PaS0P0010Q210000PaS0PQ20P@Q0PQ20Q240P@Q0Q2410aS0QBU0QS60PQ20Q2410aS
0PQ20PaS0PQ20QBU1PaS11240P000P@Q0QS60PQ20QBU10aS0Q240P000QBU1Q240PQ20QBU0P@Q0Q24
0PaS0QBU0PQ20Q240SW>0SF]0U[F1goo0@000Goo000EOol20003Ool2AS42Ool2F]H2=Jd2>Lh248@2
24825:D236<248@212425:D2248648@25:D2000248@436<25:D224826<H21242000448@636<25:D2
248236<2248436<248@224826<H25:D436<248@2124248@224821242248236<400042482000236<4
248248@236<21242248236<00`@Q2488@P02124236<22482124236<248@4248236<2000424840002
36<224821242248248@2124248@436<25:D26<H2248248@436<2248236<224825:D636<448@20002
12426<H224825:D436<248@200025:D648@224825:D2124248@236<25:D2248248@2>Lh2=Jd2F]H6
Ool20001Ool001Eoo`03001oogoo009oo`9>L`9oo`9JeP8@Q08aS08<H`8DY@8]J`8HaP8U:@8<H`8@
Q0@<H`88@P8<H`80008HaP88@P@<H`88@P@DY@8<H`8@Q08DY@88@P@HaP8DY@8<H`8@Q08000848@80
008@Q0848@8<H`88@P848@80008<H`800088@P800088@P@48@@<H`8@Q0848@88@P@48@88@P8@Q084
8@88@P8<H`848@8@Q003124@Q12400848@8<H`88@P8<H`88@P8<H`H8@P8<H`@8@P848@88@P8<H`88
@P8@Q0@0008DY@88@P@<H`@8@P848@8000848@80008Li`88@P800088@P8<H`8@Q08HaP88@P848@80
008@Q0848@8DY@8<H`8@Q0848@@8@P8DY@8@Q08<H`8Li`8<H`8@Q08HaP8DY@8@Q08Li`8@Q08DY@8Y
BP92409S60Moo`40005oo`005Goo00<007ooOol00Woo0Tic0Woo0U[F0Q240S6<0PaS0QBU0Re[0QS6
0RDY0PaS0Q2410aS0PQ20PaS0P000QS60PQ210aS0PQ211BU0PaS0Q240QBU0PQ211S60QBU0PaS0Q24
0P000P@Q0P000Q240P@Q0PaS0PQ20P@Q0P000PaS0P000PQ20P000PQ210@Q10aS0Q240P@Q0PQ210@Q
0PQ20Q240P@Q0PQ20PaS0P@Q0Q2400<48A2448@00P@Q0PaS0PQ20PaS0PQ20PaS1PQ20PaS10Q20P@Q
0PQ20PaS0PQ20Q2410000QBU0PQ210aS10Q20P@Q0P000P@Q0P000QcW0PQ20P000PQ20PaS0Q240QS6
0PQ20P@Q0P000Q240P@Q0QBU0PaS0Q240P@Q10Q20QBU0Q240PaS0QcW0PaS0Q240QS60QBU0Q240QcW
0Q240QBU0RU:0T8@0V<H1goo0@000Goo000EOol00`00Oomoo`02Ool2BU82Ool2AS425:D2:DX25:D2
48@25:D2124224828@P400025:D212428@P26<H27>L248@236<2248236<200046<H21244248436<2
248236<200022482124436<26<H236<4248436<22482124200021242248236<22482124236<21242
24840002248236<2000248@2124224821243248236<20002248236<4248236<2248212426<H248@2
248236<2000248@636<2248236<2000248@2248436<812420006248248@25:D2000236<224820002
36<25:D448@236<25:D236<224827>L26<H2248248@27>L224845:D224829BT248@27>L2:DX2<H`2
DY@7Ool10001Ool001Eoo`03001oogoo009oo`9:DP9oo`96<@8DY@8YBP8DY@8@Q08DY@848@88@P8Q
20@0008DY@848@8Q208HaP8Li`8@Q08<H`88@P8<H`8000@HaP848@@8@P@<H`88@P8<H`800088@P84
8@@<H`8HaP8<H`@8@P@<H`88@P848@8000848@88@P8<H`88@P848@8<H`848@88@P@00088@P8<H`80
008@Q0848@88@P848@<8@P8<H`800088@P8<H`@8@P8<H`88@P848@8HaP8@Q088@P8<H`80008@Q0H<
H`88@P8<H`80008@Q088@P@<H`P48@8000H8@P8@Q08DY@80008<H`88@P80008<H`8DY@@@Q08<H`8D
Y@8<H`88@P8Li`8HaP88@P8@Q08Li`88@P@DY@88@P8U:@8@Q08Li`8YBP8aS09BU0Moo`40005oo`00
5Goo00<007ooOol00Woo0TYB0Woo0TYB0S6<0Sg_0R480PaS0S6<0Q240P@Q0RU:10@Q0Q2411S60QBU
0PaS0R480P@Q0QBU0Q240PQ20PaS0Q240PaS0Q240PaS0P000PQ20P@Q0PQ20PaS0PQ20Q240PQ20P@Q
0PaS0P0010Q210@Q0PQ20Q240PaS11240PQ20P@Q0PaS0P@Q0PaS0PQ20QBU0P@Q10Q20P000P@Q0PaS
0PQ20QBU1@Q211240P@Q0PaS0PQ20P@Q10Q21PaS0PQ210aS0P000PQ20P@Q10Q20P@Q0PQ210@Q0PaS
0P@Q0P000PaS0Q240PaS0P@Q0PaS0QBU0PaS0PQ211240PaS0QBU0PaS0PQ20PaS0PQ20Q2410Q20PaS
0QcW0RU:0P@Q0Q241PaS0P@Q0PaS0RDY0QcW0PaS0Sg_0RU:0U[F1goo0@000Goo000EOol00`00Oomo
o`02Ool2BU82Ool2BU82<H`2?Nl28@P236<2<H`248@21242:DX4124248@46<H25:D236<28@P21242
5:D248@2248236<248@236<248@236<2000224821242248236<2248248@22482124236<200042484
1242248248@236<448@22482124236<2124236<224825:D2124424820002124236<224825:D52484
48@2124236<224821244248636<2248436<2000224821244248212422484124236<21242000236<2
48@236<2124236<25:D236<2248448@236<25:D236<2248236<2248248@4248236<27>L2:DX21242
48@636<2124236<29BT27>L236<2?Nl2:DX2F]H7Ool10001Ool001Eoo`03001oogoo009oo`8icP9o
o`9F]@8aS08Q208U:@@@Q08DY@8U:@@8@P8@Q08Li`H8@P8DY@88@P8HaP8Li`8DY@88@P8DY@8@Q08<
H`80008@Q0848@8Li`P<H`848@8<H`848@8<H`88@P8@Q0@<H`848@8<H`88@P848@8DY@848@@8@P84
8@8<H`@8@P8@Q0800088@P848@88@P8<H`8000848@88@P0348@0000000H@Q08000H<H`88@P848@H@
Q088@P8<H`88@P8DY@@8@P8@Q08DY@80008<H`8@Q0848@8<H`@DY@88@P8DY@8HaP848@H<H`@@Q084
8@8@Q08<H`@8@P@<H`88@P8<H`848@8<H`848@8Li`8<H`8Li`88@P8DY@8<H`8DY@8<H`8@Q08DY@84
8@8icP8aS09JePMoo`40005oo`005Goo00<007ooOol00Woo0SW>0Woo0UJe0S6<0R480RDY11240QBU
0RDY10Q20Q240QcW1PQ20QBU0PQ20QS60QcW0QBU0PQ20QBU0Q240PaS0P000Q240P@Q0QcW20aS0P@Q
0PaS0P@Q0PaS0PQ20Q2410aS0P@Q0PaS0PQ20P@Q0QBU0P@Q10Q20P@Q0PaS10Q20Q240P000PQ20P@Q
0PQ20PaS0P000P@Q0PQ200<@Q00000001Q240P001PaS0PQ20P@Q1Q240PQ20PaS0PQ20QBU10Q20Q24
0QBU0P000PaS0Q240P@Q0PaS11BU0PQ20QBU0QS60P@Q1PaS11240P@Q0Q240PaS10Q210aS0PQ20PaS
0P@Q0PaS0P@Q0QcW0PaS0QcW0PQ20QBU0PaS0QBU0PaS0Q240QBU0P@Q0SW>0S6<0U[F1goo0@000Goo
000EOol00`00Oomoo`02Ool2AS42Ool2G_L26<H2;F/27>L46<H236<29BT236<648@26<H2124436<2
48@25:D436<27>L22482000236<248@236<4124248@2248236<4124236<22482124236<248@22482
00041242248636<248@2248248@236<2248248@436<2248236<248@212442483124224825:D22482
124224820002248236<4248212422482124248@20002124248@4124200042484124236<224827>L2
36<21244248248@2124248@2248200022482000236<2124224826<H236<448@26<H236<26<H25:D2
36<2124224827>L236<448@45:D2248236<4<H`2E[D7Ool10001Ool001Eoo`8000=oo`96<@9oo`9N
m`8HaP8]J`8Li`@HaP8<H`8U:@8<H`H@Q08HaP848@@<H`8@Q08DY@@<H`8Li`88@P80008<H`8@Q08<
H`@48@8@Q088@P8<H`@48@8<H`88@P848@8<H`8@Q088@P8000@48@88@PH<H`8@Q088@P8@Q08<H`88
@P8@Q0@<H`88@P8<H`8@Q0848@@8@P<48@88@P8DY@88@P848@88@P800088@P8<H`@8@P848@88@P84
8@8@Q08000848@8@Q0@48@8000@8@P@48@8<H`88@P8Li`8<H`848@@8@P8@Q0848@8@Q088@P800088
@P80008<H`848@88@P8HaP8<H`@@Q08HaP8<H`8HaP8DY@8<H`848@88@P8Li`8<H`@@Q0@DY@88@P8<
H`@aS09F]@Ioo`80005oo`005Goo00<007ooOol00Woo0T8@0Woo0V<H0RU:0S6<0R480Q240RU:0QBU
0R480Q240QcW0PQ20QBU0Q240P@Q0Q240PaS0QBU0PaS0Q240QBU0Q240PaS0PQ20P@Q0Q240PaS0P@Q
10Q20PaS0PQ20QBU0PaS10@Q10aS0PQ20P@Q0P000PQ20P@Q0P0010aS0P@Q10000PQ20Q240P000Q24
0P@Q1PQ20PaS0P@Q0QBU0Q240PaS00<001BU5:D00P@Q0PQ20PaS0P000P@Q0QBU0PQ20PaS0P@Q0PQ2
0PaS10Q20PaS0P000Q240P@Q0PQ20PaS0P0010Q20Q240PQ20PaS0P000PaS0P@Q0PaS0PQ20PaS10@Q
0PQ20PaS0PQ20QBU0P@Q10Q20QBU0P@Q100010aS11240P@Q11BU0RU:0P@Q1QS60QcW0P000Q240SW>
0QS60Ukg1goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02Ool2HaP2:DX2<H`28@P248@2:DX25:D2
8@P248@27>L224825:D248@2124248@236<25:D236<248@25:D248@236<22482124248@236<21244
248236<224825:D236<4124436<224821242000224821242000436<212440002248248@2000248@2
1246248236<212425:D248@236<00`005:DDY@021242248236<2000212425:D2248236<212422482
36<4248236<2000248@21242248236<20004248248@2248236<2000236<2124236<2248236<41242
248236<224825:D2124424825:D21244000436<448@212445:D2:DX212466<H27>L2000248@2>Lh2
6<H2G_L7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9oo`9F]@8e[@96<@8<H`@Q208<H`80008L
i`88@P8DY@8<H`848@8<H`88@P848@8DY@848@8HaP@<H`8HaP88@P848@88@P8@Q088@P848@8HaP8<
H`88@P@@Q088@P8DY@88@P8DY@88@P8<H`8000H8@P848@88@P8@Q08<H`88@P8<H`848@88@P848@8<
H`8@Q08<H`848@H8@PD48@@8@P@<H`@8@P@48@88@P8<H`88@P8@Q0848@88@P848@@8@P80008DY@8<
H`88@P848@8<H`8HaP88@P8HaP@8@P8<H`848@88@P848@8<H`8DY@8@Q08<H`848@@@Q088@P8<H`@4
8@@<H`88@P@48@88@PHHaP8YBP8<H`8@Q0@<H`8YBP80008@Q08]J`8e[@9BU0Moo`40005oo`005Goo
00<007ooOol00Woo0Tic0Woo0UJe0SF]0THa0PaS12480PaS0P000QcW0PQ20QBU0PaS0P@Q0PaS0PQ2
0P@Q0QBU0P@Q0QS610aS0QS60PQ20P@Q0PQ20Q240PQ20P@Q0QS60PaS0PQ211240PQ20QBU0PQ20QBU
0PQ20PaS0P001PQ20P@Q0PQ20Q240PaS0PQ20PaS0P@Q0PQ20P@Q0PaS0Q240PaS0P@Q1PQ21@@Q10Q2
10aS10Q210@Q0PQ20PaS0PQ20Q240P@Q0PQ20P@Q10Q20P000QBU0PaS0PQ20P@Q0PaS0QS60PQ20QS6
10Q20PaS0P@Q0PQ20P@Q0PaS0QBU0Q240PaS0P@Q11240PQ20PaS10@Q10aS0PQ210@Q0PQ21QS60RU:
0PaS0Q2410aS0RU:0P000Q240Re[0SF]0U:D1goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2Ool2
DY@2<H`2@Q02124248@25:D448@236<224846<H200025:D200025:D27>L236<26<H2124248@26<H2
36<2248248@2000448@25:D2000424821242248236<41242248248@212425:D424825:D624820002
36<2124248@2124224841242000212420006248336<21242248236<4124236<2248236<224826<H4
24821242000236<4248212422482124236<21242248236<248@2000636<248@236<248@2000236<2
248236<248@2124236<2248236<2000224825:D2124236<448@25:D248@26<H29BT2248412422482
9BT28@P25:D2>Lh2;F/2G_L7Ool10001Ool001Eoo`03001oogoo009oo`9BU09oo`9BU08aS0924084
8@8@Q08DY@@@Q08<H`88@P@HaP80008DY@80008DY@8Li`8<H`8HaP848@8@Q08HaP8<H`88@P8@Q080
00@@Q08DY@8000@8@P848@88@P8<H`@48@88@P8@Q0848@8DY@@8@P8DY@H8@P80008<H`848@8@Q084
8@88@P@48@8000848@8000H8@P<<H`848@88@P8<H`@48@8<H`88@P8<H`88@P8HaP@8@P848@80008<
H`@8@P848@88@P848@8<H`848@88@P8<H`8@Q08000H<H`8@Q08<H`8@Q080008<H`88@P8<H`8@Q084
8@8<H`88@P8<H`800088@P8DY@848@8<H`@@Q08DY@8@Q08HaP8U:@88@P@48@88@P8U:@8Q208DY@8i
cP8]J`9Nm`Moo`40005oo`005Goo00<007ooOol00Woo0T8@0Woo0V<H0SF]0T8@0PaS0QS60RDY0PaS
10Q20P000PQ20QcW0PQ20Q240PQ20QS60PaS0PQ20PaS0QBU0QcW0PQ20P@Q0PQ20P@Q0Q240PQ20Q24
0PaS0PQ20QcW0Q240P000PQ20P@Q0Q240QBU0PQ20P@Q0PQ20Q240P@Q0PQ20PaS0P0010@Q10Q210@Q
0QBU0P@Q0Q240P@Q0PaS0P000PaS10@Q0`0010@Q0Q240PQ20Q2410@Q0PQ210aS0P@Q0PQ20P000PQ2
10@Q11240P@Q0QS60QBU0P@Q0PQ20PaS0P000P@Q10Q20PaS11240PaS0P@Q0P000PQ20PaS0PQ20PaS
0Q240P@Q0QS60PaS0R4810aS0QBU0PaS0PQ20QS60Q240PaS0QBU0QS60P@Q0Q240PaS0QS60QBU0RU:
0QBU0RU:0RDY0V<H1goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02Ool2HaP2=Jd2@Q0236<26<H2
9BT236<42482000224827>L2248248@224826<H236<2248236<25:D27>L2248212422482124248@2
248248@236<224827>L248@200022482124248@25:D224821242248248@21242248236<200041244
248412425:D2124248@2124236<2000236<412430004124248@2248248@41242248436<212422482
00022484124448@212426<H25:D21242248236<200021244248236<448@236<212420002248236<2
248236<248@212426<H236<28@P436<25:D236<224826<H248@236<25:D26<H2124248@236<26<H2
5:D2:DX25:D2:DX29BT2HaP7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9oo`96<@8e[@8YBP8D
Y@8Q208@Q088@P8@Q08<H`848@@@Q088@P@@Q0848@88@P@<H`H8@P8<H`88@P848@8<H`88@P800088
@P8DY@8<H`8000H8@P8<H`8@Q088@P8DY@8@Q0@48@8DY@88@P8<H`88@P8@Q0848@8DY@88@P848@80
0088@P8<H`80008HaP848@88@P@48@800003248@Q124008<H`848@88@PP48@80008<H`848@8<H`84
8@8DY@8@Q0848@88@P8<H`H48@8@Q0@<H`848@88@P@48@@@Q0@<H`88@P80008<H`8@Q0@<H`88@P84
8@H<H`88@P8<H`8@Q08DY@848@8<H`@8@P8HaP8DY@8<H`848@8U:@88@P8Li`8U:@8YBP8e[@8YBP9N
m`Moo`40005oo`005Goo0P000goo0Tic0Woo0THa0SF]0RU:0QBU0R480Q240PQ20Q240PaS0P@Q1124
0PQ211240P@Q0PQ210aS1PQ20PaS0PQ20P@Q0PaS0PQ20P000PQ20QBU0PaS0P001PQ20PaS0Q240PQ2
0QBU0Q2410@Q0QBU0PQ20PaS0PQ20Q240P@Q0QBU0PQ20P@Q0P000PQ20PaS0P000QS60P@Q0PQ210@Q
0P0000<8@Q2448@00PaS0P@Q0PQ220@Q0P000PaS0P@Q0PaS0P@Q0QBU0Q240P@Q0PQ20PaS1P@Q0Q24
10aS0P@Q0PQ210@Q112410aS0PQ20P000PaS0Q2410aS0PQ20P@Q1PaS0PQ20PaS0Q240QBU0P@Q0PaS
10Q20QS60QBU0PaS0P@Q0RDY0PQ20QcW0RDY0RU:0SF]0RU:0Ukg1Woo0P000Goo000EOol00`00Oomo
o`02Ool2BU82Ool2F]H2<H`2;F/26<H25:D26<H436<45:D412446<H248@2000248@2124236<25:D2
36<20002248636<412425:D248@436<2248448@2124236<21242000248@236<248@236<200022482
48@25:D2000248@412420002124248@4124248@224829BT2124236<5124248@2248236<212420002
48@2248212422482124424845:D2124436<200026<H22482000224821244248248@2248236<21242
248248@436<224827>L212425:D236<224825:D236<21242000436<2000836<200026<H25:D248@2
5:D27>L26<H27>L2?Nl2;F/2IcT7Ool10001Ool001Eoo`03001oogoo009oo`9:DP9oo`9JeP8aS08]
J`8HaP8DY@8HaP@<H`@DY@@48@@HaP8@Q080008@Q0848@8<H`8DY@8<H`800088@PH<H`@48@8DY@8@
Q0@<H`88@P@@Q0848@8<H`848@80008@Q08<H`8@Q08<H`800088@P8@Q08DY@80008@Q0@48@800084
8@8@Q0@48@8@Q088@P8U:@848@8<H`D48@8@Q088@P8<H`848@80008@Q088@P848@88@P848@@8@P@D
Y@848@@<H`80008HaP88@P800088@P848@@8@P8@Q088@P8<H`848@88@P8@Q0@<H`88@P8Li`848@8D
Y@8<H`88@P8DY@8<H`848@8000@<H`8000P<H`80008HaP8DY@8@Q08DY@8Li`8HaP8Li`8mk`8]J`9W
>@Moo`40005oo`005Goo00<007ooOol00Woo0Tic0Woo0WNm0RU:0THa11240QcW10aS0Q240PaS0P00
0P@Q0PaS0QS60Q240QBU0Q240PQ20PaS0PQ20P@Q0R480P@Q0PaS0Q240PaS0Q240QBU0PaS0PQ20P@Q
0QS60PaS0Q2410Q20PaS10Q210aS0P0010aS1P@Q0P000PaS0PQ20QBU0PQ20P000P@Q0PaS0P@Q0P00
10aS0Q240`@Q0PaS0PQ20P@Q0PQ20Q240PQ20P@Q0PQ210@Q0PQ20PaS10@Q0PQ20QBU0Q240P@Q0QS6
0P000PQ210@Q1PaS0QS60P@Q10Q20P000Q240P@Q0P000PaS0P@Q0PQ20PaS0PQ20P@Q10aS0P@Q0PaS
0PQ20P@Q0PQ20QS60P@Q0PQ20P@Q0R480Q240P@Q0QS60PQ20PaS0QS60Q240PaS0SW>0Re[0V]J1goo
0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2Mkd2:DX2AS4448@27>L436<248@236<200021242
36<26<H248@25:D248@2248236<2248212428@P2124236<248@236<248@25:D236<2248212426<H2
36<248@4248236<4248436<2000436<61242000236<224825:D224820002124236<21242000436<2
48@3124236<224821242248248@22482124224841242248236<4124224825:D248@212426<H20002
2484124636<26<H212442482000248@21242000236<21242248236<22482124436<2124236<22482
124224826<H21242248212428@P248@212426<H2248236<26<H248@236<2>Lh2;F/2JeX7Ool10001
Ool001Eoo`03001oogoo009oo`92409oo`9:DP8aS08mk`@DY@848@8@Q08DY@8Li`88@P8<H`848@H8
@P8@Q08HaP80008<H`8DY@@<H`800088@P8DY@8<H`88@P848@H8@P@<H`@0008@Q080008@Q0@<H`84
8@8@Q08<H`8DY@@@Q08<H`848@88@P80008<H`88@P8<H`848@H<H`848@8000848@8@Q00336<48@@Q
0088@P8<H`848@8<H`848@88@P@000@8@P8<H`88@P8@Q08000848@80008<H`88@P8<H`80008HaP8<
H`@48@@<H`8@Q08<H`848@80008<H`@8@P8@Q08<H`88@PH48@800088@P8DY@@8@P8Li`88@P8HaP88
@P80008HaP8DY@@@Q08HaP8DY@80008Li`@<H`8mk`8U:@9[FPMoo`40005oo`005Goo00<007ooOol0
0Woo0T8@0Woo0TYB0S6<0Sg_11BU0P@Q0Q240QBU0QcW0PQ20PaS0P@Q1PQ20Q240QS60P000PaS0QBU
10aS0P000PQ20QBU0PaS0PQ20P@Q1PQ210aS10000Q240P000Q2410aS0P@Q0Q240PaS0QBU11240PaS
0P@Q0PQ20P000PaS0PQ20PaS0P@Q1PaS0P@Q0P000P@Q0Q2400<<H`@Q12400PQ20PaS0P@Q0PaS0P@Q
0PQ2100010Q20PaS0PQ20Q240P000P@Q0P000PaS0PQ20PaS0P000QS60PaS10@Q10aS0Q240PaS0P@Q
0P000PaS10Q20Q240PaS0PQ21P@Q0P000PQ20QBU10Q20QcW0PQ20QS60PQ20P000QS60QBU11240QS6
0QBU0P000QcW10aS0Sg_0RDY0V]J1goo0@000Goo000EOol00`00Oomoo`02Ool2AS42Ool2DY@4<H`2
7>L248@224825:D28@P26<H248@45:D27>L224825:D224826<H6248236<27>L248@2248436<21242
248448@2248236<26<H2000224826<H236<412425:D2124636<4248248@412420006124200021242
48@212422482124236<25:D00`002488@P0248@22482124436<2248248@2248236<4124224825:D4
12429BT224820002248236<212425:D436<248@236<2124236<22486124236<248@2248212422482
48@224825:D2124436<2000236<25:D236<22484124236<26<H25:D248@224825:D236<248@29BT2
=Jd28@P2F]H7Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`96<@9oo`9BU0@aS08L
i`8@Q088@P8DY@8Q208HaP8@Q0@DY@8Li`88@P8DY@88@P8HaPH8@P8<H`8Li`8@Q088@P@<H`848@88
@P@@Q088@P8<H`8HaP800088@P8HaP8<H`@48@8DY@848@H<H`@8@P8@Q0@48@8000H48@8000848@8@
Q0848@88@P848@8<H`8DY@030008@PQ2008@Q088@P848@@<H`88@P8@Q088@P8<H`@48@88@P8DY@@4
8@8U:@88@P800088@P8<H`848@8DY@@<H`8@Q08<H`848@8<H`88@PH48@8<H`8@Q088@P848@88@P8@
Q088@P8DY@848@@<H`80008<H`8DY@8<H`88@P@48@8<H`8HaP8DY@8@Q088@P8DY@8<H`8@Q08U:@8e
[@8Q209JePMoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool2
=Jd2Ool2E[D4;F/25:D47>L26<H41242:DX26<H2124448@2124236<248@224826<H224828@P236<2
000236<200027>L2124224821242000236<448@236<248@46<H45:D248@2248236<2124236<25:D4
36<2000236<248@20002124424821242248448@4248236<312420002248212422482000236<:1242
36<212422484124248@236<4124236<25:D248@25:D236<200025:D236<20002124248@4000236<4
000236<2124436<424825:D212426<H25:D200027>L2248436<224827>L45:D424826<H28@P2?Nl2
;F/2IcT7Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo0P000goo0SF]0Woo0UJe
12e[0QBU11cW0QS610@Q0RU:0QS60P@Q11240P@Q0PaS0Q240PQ20QS60PQ20R480PaS0P000PaS0P00
0QcW0P@Q0PQ20P@Q0P000PaS11240PaS0Q2411S611BU0Q240PQ20PaS0P@Q0PaS0QBU10aS0P000PaS
0Q240P000P@Q10Q20P@Q0PQ2112410Q20PaS0`@Q0P000PQ20P@Q0PQ20P000PaS2P@Q0PaS0P@Q0PQ2
10@Q0Q240PaS10@Q0PaS0QBU0Q240QBU0PaS0P000QBU0PaS0P000P@Q0Q2410000PaS10000PaS0P@Q
10aS10Q20QBU0P@Q0QS60QBU0P000QcW0PQ210aS0PQ20QcW11BU10Q20QS60R480Sg_0Re[0VLi1Woo
0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007ooOol00Woo0THa0Woo0VLi0Re[0RU:0Q24
0QBU0QS60P@Q0Q240PQ20QcW0Q240PaS0Q2411BU10aS0Q240P@Q0PaS0PQ20PaS0P@Q0PaS0Q240PaS
0PQ20Q240PQ221BU0Q240PQ20QBU0PaS0PQ20Q240PQ20P000PQ20PaS0Q240QBU10aS0P@Q0PaS0Q24
0PQ20P@Q0P000PaS0P@Q10Q20P000P@Q0PQ20P@Q00<000@Q12400P@Q0PQ20PaS0P@Q10Q20Q241P@Q
0P000PQ211240P@Q10aS0QS61P@Q0QBU0PaS0QcW0PQ20QBU0Q240P000QBU0PQ20PaS11240QBU0P@Q
0PQ20Q240PaS0PQ20PaS0PQ20QS60PQ20P000Q240QBU0PaS0P0010aS0RDY10aS0RDY0Q240PQ20QBU
0QS60RDY0RU:0SF]0V<H1goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001o
ogoo009oo`96<@9oo`9W>@8]J`8YBP8@Q08DY@8HaP848@8@Q088@P8Li`8@Q08<H`8@Q0@DY@@<H`8@
Q0848@8<H`88@P8<H`848@8<H`8@Q08<H`88@P8@Q088@PPDY@8@Q088@P8DY@8<H`88@P8@Q088@P80
0088@P8<H`8@Q08DY@@<H`848@8<H`8@Q088@P848@80008<H`848@@8@P8000848@88@P848@030004
8@@Q00848@88@P8<H`848@@8@P8@Q0H48@800088@P@@Q0848@@<H`8HaPH48@8DY@8<H`8Li`88@P8D
Y@8@Q080008DY@88@P8<H`@@Q08DY@848@88@P8@Q08<H`88@P8<H`88@P8HaP88@P80008@Q08DY@8<
H`8000@<H`8U:@@<H`8U:@8@Q088@P8DY@8HaP8U:@8YBP8e[@9S60Moo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo0V<H0Woo0Ukg0RU:0TYB0P@Q0QBU0SF]0P@Q0PaS0RU:0Q240PQ20PaS
0P@Q0PQ20QcW0PQ20P000Q240PQ20QBU0Q240QS60PaS0P@Q10Q211cW11241P000P@Q10aS0PQ20P00
10@Q0PQ20PaS0P@Q10000PQ210000Q240PQ20PaS0PQ20P@Q0PQ20P@Q0PaS10@Q0P002@Q20PaS10@Q
0QBU0PQ20P@Q10Q20PaS0P@Q0PQ21P000P@Q10aS0PQ20P@Q0PQ20P000PaS0PQ20QBU0Q2410Q20PaS
0QBU10Q20QS610000P@Q0PQ20Q240PaS11S60PaS0PQ20PaS0QBU11240PaS0Q240QS60RDY0PQ21124
0QBU0QS60Q240PaS0QcW0Sg_0RU:0V<H1goo0@000Goo000EOol00`00Oomoo`02Ool2HaP2Ool2G_L2
:DX2BU8212425:D2=Jd2124236<2:DX248@2248236<2124224827>L22482000248@224825:D248@2
6<H236<2124424847>L448@60002124436<2248200041242248236<2124400022484000248@22482
36<2248212422482124236<412420009248236<412425:D224821244248236<21242248600021244
36<2248212422482000236<224825:D248@4248236<25:D424826<H400021242248248@236<46<H2
36<2248236<25:D448@236<248@26<H29BT2248448@25:D26<H248@236<27>L2?Nl2:DX2HaP7Ool1
0001Ool001Eoo`03001oogoo009oo`9W>@9oo`9S608aS096<@8Li`8@Q0@Li`8@Q08DY@8<H`8DY@8L
i`8@Q088@P8@Q08<H`8U:@8HaP8U:@8DY@H<H`848@88@P@48@8HaP8@Q0@48@@@Q088@P8<H`8@Q088
@P8<H`88@P8<H`@8@P848@8@Q0H8@P8<H`88@P8@Q088@P8<H`@8@PH48@8@Q0@<H`88@P0336<8@PQ2
00h48@8<H`848@8<H`848@88@P@<H`8DY@848@88@P8@Q08<H`848@8HaP8<H`8DY@8<H`8HaPP<H`8D
Y@8@Q088@P8@Q088@P8<H`8@Q0848@88@P8@Q08<H`8HaP@48@8DY@8HaP8@Q0@8@P848@8DY@8@Q08D
Y@8<H`848@8Li`8@Q08Li`8<H`8@Q08e[@8Q209[FPMoo`40005oo`005Goo00<007ooOol00Woo0VLi
0Woo0V<H0S6<0THa0QcW0Q2411cW0Q240QBU0PaS0QBU0QcW0Q240PQ20Q240PaS0RDY0QS60RDY0QBU
1PaS0P@Q0PQ210@Q0QS60Q2410@Q11240PQ20PaS0Q240PQ20PaS0PQ20PaS10Q20P@Q0Q241PQ20PaS
0PQ20Q240PQ20PaS10Q21P@Q0Q2410aS0PQ200<<H`Q224803P@Q0PaS0P@Q0PaS0P@Q0PQ210aS0QBU
0P@Q0PQ20Q240PaS0P@Q0QS60PaS0QBU0PaS0QS620aS0QBU0Q240PQ20Q240PQ20PaS0Q240P@Q0PQ2
0Q240PaS0QS610@Q0QBU0QS60Q2410Q20P@Q0QBU0Q240QBU0PaS0P@Q0QcW0Q240QcW0PaS0Q240SF]
0R480V]J1goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2Ool2IcT2CW<29BT26<H45:D224826<H2
24825:D248@236<27>L236<224825:D2248248@236<448@22482124224825:D236<2124436<27>L2
36<2000236<2248248@412425:D22482124236<6248236<4124436<2124236<20002124236<22482
36<4124248@2248248@00`Q212448@0224861244248436<4248248@4248236<2248236<2248236<2
248200025:D41244248236<248@2124248@4124248@2124200025:D26<H212425:D248@224846<H6
48@236<29BT224825:D2000248@25:D236<448@2124248@25:D21242=Jd2BU82JeX7Ool10001Ool0
01Eoo`03001oogoo009oo`9BU09oo`9W>@9>L`8U:@8HaP@DY@88@P8HaP88@P8DY@8@Q08<H`8Li`8<
H`88@P8DY@88@P8@Q08<H`@@Q088@P848@88@P8DY@8<H`848@@<H`8Li`8<H`80008<H`88@P8@Q0@4
8@8DY@88@P848@8<H`H8@P8<H`@48@@<H`848@8<H`8000848@8<H`88@P8<H`@48@8@Q088@P8@Q003
24848@@Q0088@PH48@@8@P@<H`@8@P8@Q0@8@P8<H`88@P8<H`88@P8<H`88@P80008DY@@48@@8@P8<
H`8@Q0848@8@Q0@48@8@Q0848@80008DY@8HaP848@8DY@8@Q088@P@HaPH@Q08<H`8U:@88@P8DY@80
008@Q08DY@8<H`@@Q0848@8@Q08DY@848@8e[@9:DP9[FPMoo`40005oo`005Goo00<007ooOol00Woo
0Tic0Woo0Vmk0T8@0SW>0PQ20PaS0QBU11S60RU:10Q20QS60Q241PaS0QS60PQ20QBU0Q240P@Q0QBU
0PaS0P@Q0QS610Q20Q240PaS0P@Q0P000QBU0Q240QS60P@Q0QBU10Q20PaS0QBU0P000PaS10Q20QS6
10@Q0P000PQ20PaS0P@Q10Q20Q240PQ20P@Q0PQ20P@Q10aS0`@Q0Q240PQ20PaS0Q240PaS0QBU0PaS
10Q20PaS0QBU0Q240PaS0QS60P@Q0PaS1Q240P000PQ20P@Q0PaS0P@Q10aS0P@Q0P000P@Q0PaS0QBU
0Q240PaS0P@Q0QBU0P@Q0PaS10@Q0PaS0RDY0Q240QBU0PaS0PQ20Q240PQ20PaS0QBU2PaS0R480PQ2
0R480PaS0QBU0RU:0SF]0S6<0VLi1goo0@000Goo000EOol20003Ool2CW<2Ool2Kg/2@Q02>Lh22482
36<25:D46<H2:DX424826<H248@636<26<H224825:D248@212425:D236<212426<H4248248@236<2
124200025:D248@26<H212425:D4248236<25:D2000236<424826<H412420002248236<212442482
48@2248212422482124436<3124248@2248236<248@236<25:D236<4248236<25:D248@236<26<H2
124236<648@200022482124236<2124436<212420002124236<25:D248@236<212425:D2124236<4
124236<29BT248@25:D236<2248248@2248236<25:D:36<28@P224828@P236<25:D2:DX2=Jd2<H`2
IcT6Ool20001Ool001Eoo`03001oogoo009oo`96<@9oo`9JeP8]J`8e[@8@Q0@DY@@HaP8@Q0@DY@8H
aP8<H`8@Q08HaP848@8DY@8<H`80008@Q08DY@@8@P8Li`88@P8@Q08Q208<H`848@88@P8DY@8<H`8D
Y@88@P8@Q0@8@P8@Q08<H`8@Q088@P8@Q0848@8<H`80008@Q0848@@8@P8<H`848@88@P8HaP@48@8<
H`848@88@P8@Q0848@8@Q00324848@@Q0088@P848@H<H`848@8<H`88@P80008<H`@@Q080008@Q08<
H`8DY@8<H`8DY@88@P8<H`88@P@@Q0@8@P848@8DY@848@8@Q08<H`8Li`88@P848@80008@Q080008<
H`848@88@P8<H`8Q20@8@P8@Q08<H`8000@@Q08HaP8<H`8@Q08DY@8YBP8Q208Li`8U:@8Q208<H`8a
S092408]J`9Nm`Moo`40005oo`005Goo00<007ooOol00Woo0THa0Woo0U[F0Re[0SF]0Q2411BU11S6
0Q2411BU0QS60PaS0Q240QS60P@Q0QBU0PaS0P000Q240QBU10Q20QcW0PQ20Q240R480PaS0P@Q0PQ2
0QBU0PaS0QBU0PQ20Q2410Q20Q240PaS0Q240PQ20Q240P@Q0PaS0P000Q240P@Q10Q20PaS0P@Q0PQ2
0QS610@Q0PaS0P@Q0PQ20Q240P@Q0Q2400<8@P@Q12400PQ20P@Q1PaS0P@Q0PaS0PQ20P000PaS1124
0P000Q240PaS0QBU0PaS0QBU0PQ20PaS0PQ2112410Q20P@Q0QBU0P@Q0Q240PaS0QcW0PQ20P@Q0P00
0Q240P000PaS0P@Q0PQ20PaS0R4810Q20Q240PaS0P0011240QS60PaS0Q240QBU0RU:0R480QcW0RDY
0R480PaS0S6<0T8@0Re[0Ukg1goo0@000Goo000EOol00`00Oomoo`02Ool2Kg/2Ool2DY@26<H2BU82
36<26<H29BT2248236<448@236<26<H236<28@P248@45:D21242000448@25:D212425:D248@22482
124424825:D236<2124236<248@61242248248@2248236<2248236<2124236<26<H22482124236<2
48@2124248@2124424841242248236<2248236<00aBU36<<H`0236<2248236<248@2248212420002
248248@224840004124236<2248236<212422482124236<2000236<2248248@236<2248236<22482
5:D2248436<2248248@2248436<448@412426<H2248236<248@25:D26<H248@27>L224828@P26<H2
7>L29BT248@28@P29BT27>L2;F/2?Nl2CW<7Ool10001Ool001Eoo`03001oogoo009oo`9_N`9oo`9B
U08HaP9:DP8<H`8HaP8U:@88@P8<H`@@Q08<H`8HaP8<H`8Q208@Q0@DY@848@8000@@Q08DY@848@8D
Y@8@Q088@P848@@8@P8DY@8<H`848@8<H`8@Q0H48@88@P8@Q088@P8<H`88@P8<H`848@8<H`8HaP88
@P848@8<H`8@Q0848@8@Q0848@@8@P@48@88@P8<H`88@P8<H`035:D<H`aS008<H`88@P8<H`8@Q088
@P848@800088@P8@Q088@P@000@48@8<H`88@P8<H`848@88@P848@8<H`80008<H`88@P8@Q08<H`88
@P8<H`88@P8DY@88@P@<H`88@P8@Q088@P@<H`@@Q0@48@8HaP88@P8<H`8@Q08DY@8HaP8@Q08Li`88
@P8Q208HaP8Li`8U:@8@Q08Q208U:@8Li`8]J`8mk`9>L`Moo`40005oo`005Goo00<007ooOol00Woo
0U[F0Woo0U[F0RU:0UJe0PQ20P000S6<0PaS0Q240QcW0QBU10Q20R480QS60QcW0R480QS60P@Q0P00
0QBU0PQ20QcW0PaS0Q240P@Q0PQ20P000P@Q0PaS11240P@Q0PaS0PQ20Q240P000P@Q0PaS0Q240PaS
0Q240P000QBU0P0010@Q0PQ210aS0Q241PQ210aS10Q20Q2410@Q0PaS1@@Q10aS0Q240PaS0PQ20Q24
0PaS0PQ20Q240PQ20PaS0P@Q0PQ20Q240P000P@Q10Q20PaS0P000PQ20P000Q240P@Q0PaS11BU0P@Q
0PaS0QBU0PQ20QBU0Q240PaS0PQ210aS0Q240PQ20QS60PaS0PQ20PaS0QBU0RDY0PaS0PQ20QS60QcW
0QS60RU:0QS60Q240S6<0QS60T8@0RU:0Q240S6<0QcW2Goo0@000Goo000EOol00`00Oomoo`02Ool2
F]H2Ool2F]H2:DX2E[D224820002<H`236<248@27>L25:D424828@P26<H27>L28@P26<H212420002
5:D224827>L236<248@2124224820002124236<448@2124236<2248248@20002124236<248@236<2
48@200025:D200041242248436<248@6248436<4248248@4124236<5124436<248@236<2248248@2
36<2248248@2248236<21242248248@200021244248236<200022482000248@2124236<45:D21242
36<25:D224825:D248@236<2248436<248@224826<H236<2248236<25:D29BT236<224826<H27>L2
6<H2:DX26<H248@2<H`26<H2@Q02:DX248@2<H`27>L9Ool10001Ool001Eoo`03001oogoo009oo`96
<@9oo`9[FP92408]J`8DY@@YBP8DY@8Q208Li`88@P8<H`8@Q08U:@8HaP8U:@8Q2080008DY@8<H`@D
Y@88@P848@8HaP88@P8<H`8@Q088@P@@Q088@P848@@<H`88@P@<H`848@@000848@8@Q0@48@8<H`88
@PH@Q08HaP88@P8@Q08<H`8@Q08000@DY@@8@P848@<8@P@@Q0@8@P848@8@Q08<H`@48@8@Q08DY@8@
Q088@P848@8<H`88@P8@Q0HHaP@<H`88@P848@H00088@P8000848@8<H`88@P8HaP8<H`848@8HaP8@
Q08<H`@8@P8@Q08<H`8Q208DY@8<H`@@Q08Li`8HaP@Li`8DY@8<H`848@8HaP8@Q08DY@8U:@8aS084
8@@YBP9_N`Moo`40005oo`005Goo00<007ooOol00Woo0THa0Woo0V]J0T8@0Re[0QBU12U:0QBU0R48
0QcW0PQ20PaS0Q240RDY0QS60RDY0R480P000QBU0PaS11BU0PQ20P@Q0QS60PQ20PaS0Q240PQ21124
0PQ20P@Q10aS0PQ210aS0P@Q10000P@Q0Q2410@Q0PaS0PQ21Q240QS60PQ20Q240PaS0Q240P0011BU
10Q20P@Q0`Q2112410Q20P@Q0Q240PaS10@Q0Q240QBU0Q240PQ20P@Q0PaS0PQ20Q241QS610aS0PQ2
0P@Q1P000PQ20P000P@Q0PaS0PQ20QS60PaS0P@Q0QS60Q240PaS10Q20Q240PaS0R480QBU0PaS1124
0QcW0QS611cW0QBU0PaS0P@Q0QS60Q240QBU0RDY0S6<0P@Q12U:0Vmk1goo0@000Goo000EOol00`00
Oomoo`02Ool2F]H2Ool2Mkd4>Lh45:D28@P248@2>Lh27>L26<H25:D27>L26<H236<248@236<22482
48@236<25:D248@236<2124224826<H41242248412440004124448@2248236<21242248248@42482
36<248@2124448@20002124236<248@21242000236<224820004248248@336<2248236<212442482
124236<412425:D2124836<200045:D22482000224841242248236<612425:D248@2124636<22482
12422482124200025:D2124236<27>L436<47>L26<H248@26<H236<2248248@29BT27>L448@26<H2
36<248@2AS42CW<2G_L7Ool10001Ool001Eoo`8000=oo`9JeP9oo`9g_@@icP@DY@8Q208@Q08icP8L
i`8HaP8DY@8Li`8HaP8<H`8@Q08<H`88@P8@Q08<H`8DY@8@Q08<H`848@88@P8HaP@48@88@P@48@@0
00@48@@@Q088@P8<H`848@88@P8@Q0@8@P8<H`8@Q0848@@@Q08000848@8<H`8@Q0848@80008<H`88
@P8000@8@P8@Q0<<H`88@P8<H`848@@8@P848@8<H`@48@8DY@848@P<H`8000@DY@88@P800088@P@4
8@88@P8<H`H48@8DY@8@Q0848@H<H`88@P848@88@P848@80008DY@848@8<H`8Li`@<H`@Li`8HaP8@
Q08HaP8<H`88@P8@Q08U:@8Li`@@Q08HaP8<H`8@Q096<@9>L`9Nm`Ioo`80005oo`005Goo00<007oo
Ool00Woo0UJe17oo0RU:12e[0QBU0QcW0QS60R480QcW0QS60Q240PQ20RDY0QS60QcW11240P000PQ2
0Q240QS60QBU0PaS0PQ20PaS0QS61Q240P@Q0PaS11240QBU0PaS10Q21Q240PaS0QBU0QS60P@Q0PQ2
0PaS0PQ20P@Q0PQ20PaS0P@Q0Q240P@Q0PQ20P@Q0PaS0PQ20P@Q1PQ200<48A2448@00PQ20PaS0P@Q
0PQ20P@Q0QBU0P@Q0QS610@Q0PaS0QBU0Q2410Q20PaS0QBU0P@Q0Q240PaS11240QS60P000PaS0P00
11241P@Q0PQ20QS610aS0Q240PQ21QBU0RU:0PQ20PaS0QS60QBU0PQ211BU0QS60PaS0R480RDY0RU:
0P@Q0QBU0Q240PaS0P@Q0RU:0R480THa0VLi1goo0@000Goo000EOol00`00Oomoo`02Ool2E[D4Ool2
:DX4;F/25:D27>L26<H28@P27>L26<H248@224829BT26<H27>L448@20002248248@26<H25:D236<2
248236<26<H648@2124236<448@25:D236<4248648@236<25:D26<H21242248236<2248212422482
36<2124248@212422482124236<22482124624800`@Q48@@Q002248236<21242248212425:D21242
6<H4124236<25:D248@4248236<25:D2124248@236<448@26<H2000236<2000448@6124224826<H4
36<248@224865:D2:DX2248236<26<H25:D224845:D26<H236<28@P29BT2:DX212425:D248@236<2
1242:DX28@P2AS42IcT7Ool10001Ool001Eoo`03001oogoo009oo`9F]@9oo`9S608mk`96<@8YBP8@
Q08Li`8U:@88@P8@Q08U:@8DY@80008DY@8Q20@@Q08Li`8<H`8DY@@8@P@48@800088@P8DY@848@8D
Y@8<H`8HaP8@Q08Li`88@P80008DY@8<H`848@8DY@88@P8<H`88@P@@Q088@P@48@88@P8DY@848@88
@P8<H`8Li`8<H`848@80008Q208@Q08<H`8000848@8<H`0348@8@PQ200848@88@P8DY@P<H`848@88
@P848@8<H`8000@@Q088@P80008@Q0848@8@Q0848@8DY@8<H`848@800088@P8<H`H@Q088@P848@88
@P8HaPH8@P8@Q08<H`8HaP88@P8U:@@HaP88@P8HaP8U:@8Li`848@8DY@8HaP8]J`8DY@8aS08<H`8]
J`848@8HaP8@Q08U:@92409>L`9_N`Moo`40005oo`005Goo00<007ooOol00Woo0UJe0Woo0V<H0Sg_
0THa0RU:0Q240QcW0RDY0PQ20Q240RDY0QBU0P000QBU0R4811240QcW0PaS0QBU10Q210@Q0P000PQ2
0QBU0P@Q0QBU0PaS0QS60Q240QcW0PQ20P000QBU0PaS0P@Q0QBU0PQ20PaS0PQ211240PQ210@Q0PQ2
0QBU0P@Q0PQ20PaS0QcW0PaS0P@Q0P000R480Q240PaS0P000P@Q0PaS00<@Q0Q224800P@Q0PQ20QBU
20aS0P@Q0PQ20P@Q0PaS0P0011240PQ20P000Q240P@Q0Q240P@Q0QBU0PaS0P@Q0P000PQ20PaS1Q24
0PQ20P@Q0PQ20QS61PQ20Q240PaS0QS60PQ20RDY11S60PQ20QS60RDY0QcW0P@Q0QBU0QS60Re[0QBU
0S6<0PaS0Re[0P@Q0QS60Q240RDY0T8@0Tic0Vmk1goo0@000Goo000EOol00`00Oomoo`02Ool2IcT2
Ool2G_L248@2;F/2?Nl248@2>Lh46<H29BT42482<H`27>L48@P26<H2:DX66<H636<224825:D26<H2
0002;F/2248212427>L248@2248412426<H224825:D248@25:D248@21242000212425:D248@236<2
2482000248@236<248@2124236<448@21242248248@2248212400`0036<<H`025:D4124624861242
248236<21242248236<2124248@236<25:D224825:D224826<H236<25:D2000236<85:D248@236<4
248248@4248236<21242:DX41242@Q0212425:D27>L212425:D29BT248@2:DX248@47>L236<28@P2
<H`26<H25:D2=Jd2?Nl2Nmh7Ool10001Ool001Eoo`03001oogoo009oo`9W>@9oo`9Nm`8@Q08]J`8m
k`8@Q08icP@HaP8U:@@8@P8aS08Li`@Q208HaP8YBPHHaPH<H`88@P8DY@8HaP80008]J`88@P848@8L
i`8@Q088@P@48@8HaP88@P8DY@8@Q08DY@8@Q0848@8000848@8DY@8@Q08<H`88@P80008@Q08<H`8@
Q0848@8<H`@@Q0848@88@P8@Q088@P848@03000<H`aS008DY@@48@H8@PH48@88@P8<H`848@88@P8<
H`848@8@Q08<H`8DY@88@P8DY@88@P8HaP8<H`8DY@80008<H`PDY@8@Q08<H`@8@P8@Q0@8@P8<H`84
8@8YBP@48@9240848@8DY@8Li`848@8DY@8U:@8@Q08YBP8@Q0@Li`8<H`8Q208aS08HaP8DY@8e[@8m
k`9kgPMoo`40005oo`005Goo00<007ooOol00Woo0TYB0Woo0Ukg0Sg_0TYB0RU:0P@Q0RDY0Q240R48
0QBU0PaS0QBU0RDY0Re[0PaS0RDY0Re[0PQ20S6<0PaS0P000PaS0Q240P@Q0Q2410Q211S60PaS0Q24
0PaS0PQ20QBU0QS60PQ20P@Q11S60Q240P000PaS0P@Q10aS0Q2410aS0P@Q0Q240PQ20P000Q240QS6
0PaS0PQ20P@Q11240P@Q0Q240`aS0P@Q0QcW10@Q0PaS10Q20Q2410@Q10aS0P@Q0PQ20PaS0QBU0QcW
0PaS0Q240PQ20Q240PaS0QcW0P000QBU0PQ20QcW0QS60Q2410aS0PQ20QcW0PQ20P000QBU0Q240PaS
0QBU0P0011S60Q240SW>0PaS0SW>0QS60PQ20QBU0RDY0PQ20Q240PaS0QBU0QS60QBU0R480QS60Q24
0R480T8@0SW>2Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82Ool2G_L2?Nl2BU82:DX212429BT2
48@28@P25:D236<25:D29BT2;F/236<29BT2;F/22482<H`236<2000236<248@2124248@424846<H2
36<248@236<224825:D26<H2248212446<H248@2000236<2124436<248@436<2124248@224820002
48@26<H236<22482124448@2124248@336<212427>L4124236<4248248@4124436<21242248236<2
5:D27>L236<248@2248248@236<27>L200025:D224827>L26<H248@436<224827>L2248200025:D2
48@236<25:D200046<H248@2>Lh236<2>Lh26<H224825:D29BT2248248@236<25:D26<H25:D28@P2
6<H248@28@P2@Q02>Lh9Ool10001Ool001Eoo`03001oogoo009oo`9Nm`Aoo`ANm`@<H`8Li`8DY@8@
Q08DY@8@Q08aS08DY@8YBP8<H`8Li`8@Q0@Li`8HaP8mk`8DY@8<H`@8@P848@8<H`@@Q0@8@P8@Q08H
aP848@8<H`P@Q08000@@Q080008DY@88@P8<H`8Li`80008<H`@@Q088@P848@88@P8<H`848@800084
8@8DY@H8@P035:D48@@Q008<H`8HaP800088@P8@Q0H8@P80008@Q0@<H`848@@8@P848@8@Q08<H`8@
Q08<H`848@8@Q08Li`8<H`H48@@<H`8@Q0@8@P8DY@8@Q08<H`8Li`8DY@@@Q08HaP88@P8DY@8<H`8U
:@8]J`8<H`8aS08YBP8aS08@Q08Li`8YBP8<H`8DY@@HaP8Q20@]J`8icP8e[@Uoo`40005oo`005Goo
0P000goo0Ukg17oo15kg10aS0QcW0QBU0Q240QBU0Q240S6<0QBU0RU:0PaS0QcW0Q2411cW0QS60Sg_
0QBU0PaS10Q20P@Q0PaS112410Q20Q240QS60P@Q0PaS21240P0011240P000QBU0PQ20PaS0QcW0P00
0PaS11240PQ20P@Q0PQ20PaS0P@Q0P000P@Q0QBU1PQ200<DY@@Q12400PaS0QS60P000PQ20Q241PQ2
0P000Q2410aS0P@Q10Q20P@Q0Q240PaS0Q240PaS0P@Q0Q240QcW0PaS1P@Q10aS0Q2410Q20QBU0Q24
0PaS0QcW0QBU11240QS60PQ20QBU0PaS0RDY0Re[0PaS0S6<0RU:0S6<0Q240QcW0RU:0PaS0QBU11S6
0R4812e[0SW>0SF]27oo0P000Goo000EOol00`00Oomoo`02Ool2HaP4Ool2Nmh2Mkd26<H2;F/26<H2
;F/27>L248@29BT2;F/236<28@P27>L2248236<2:DX248@224826<H236<248@236<212426<H22482
5:D212427>L2124200028@P20002248236<412426<H248@236<25:D236<2248248@40002248248@2
5:D200022482000224821242000236<22482124236<25:D2124324825:D2000812442482124236<2
124436<2248236<4248248@2248248@25:D2248212426<H2248248@212425:D2124248@29BT22482
:DX26<H200047>L22482:DX45:D2:DX248@2AS427>L2=Jd2:DX29BT2DY@2@Q022482<H`2;F/2:DX2
00027>L4<H`2=Jd4DY@9Ool10001Ool001Eoo`03001oogoo009oo`9S60Aoo`9kgP9g_@8HaP8]J`8H
aP8]J`8Li`8@Q08U:@8]J`8<H`8Q208Li`88@P8<H`8YBP8@Q088@P8HaP8<H`8@Q08<H`848@8HaP88
@P8DY@848@8Li`848@80008Q20800088@P8<H`@48@8HaP8@Q08<H`8DY@8<H`88@P8@Q0@00088@P8@
Q08DY@800088@P800088@P848@80008<H`88@P848@8<H`8DY@848@<8@P8DY@8000P48@@8@P848@8<
H`848@@<H`88@P8<H`@8@P8@Q088@P8@Q08DY@88@P848@8HaP88@P8@Q0848@8DY@848@8@Q08U:@88
@P8YBP8HaP8000@Li`88@P8YBP@DY@8YBP8@Q096<@8Li`8e[@8YBP8U:@9BU0924088@P8aS08]J`8Y
BP80008Li`@aS08e[@ABU0Uoo`40005oo`005Goo00<007ooOol00Woo0W_N17oo0UJe0V<H0Tic0QBU
0Sg_0QS60PaS0RDY0Q2412U:0Re[0QcW0RU:0QcW12480RDY0Q240R480PaS0Q240P000QS60P000QBU
0P@Q10Q20QBU0P@Q0PaS0Q2410Q210aS0P@Q0PaS0PQ210@Q0Q240P@Q0Q240PQ210@Q0QcW0P0010Q2
0P@Q1PQ20P000PQ20P@Q0PaS00<48A2448@010@Q0PQ20Q240PaS0P@Q10000PaS0P@Q0QBU0PQ20P00
0Q2410Q20QBU0P@Q1Q240P@Q0QcW10000QBU0P@Q0QS60PQ20Q2410aS0PQ20Q240PQ20QBU0RDY0Q24
0R480Q240RDY0Q2413W>0QS60S6<0RDY0R480Sg_0RDY0QS60Re[0Q240QcW11BU0Re[0RU:0QS60Sg_
0T8@0THa1goo0@000Goo000EOol00`00Oomoo`02Ool2Nmh4Ool2E[D2HaP2CW<25:D2?Nl26<H236<2
9BT248@4:DX2;F/27>L2:DX27>L48@P29BT248@28@P236<248@200026<H200025:D2124424825:D2
124236<248@4248436<2124236<22484124248@2124248@2248412427>L200042482124624820002
2482124236<00`@Q48@@Q0041242248248@236<21244000236<212425:D22482000248@424825:D2
124648@212427>L400025:D212426<H2248248@436<2248248@224825:D29BT248@28@P248@29BT2
48@4>Lh26<H2<H`29BT28@P2?Nl29BT26<H2;F/248@27>L45:D2;F/2:DX26<H2?Nl2@Q02AS47Ool1
0001Ool001Eoo`03001oogoo00Ioo`9BU08]J`9>L`8U:@8YBP8Q208DY@9:DP848@8@Q080008e[@8]
J`8DY@8@Q08aS088@P8icP8@Q08<H`8Li`8@Q0848@8HaP8<H`8HaP8<H`8HaP8000848@8DY@8HaP8<
H`88@P8@Q08DY@8<H`P8@P848@88@P8@Q0@8@P8DY@8@Q08<H`8@Q0@48@@<H`@8@P8@Q088@P848@8<
H`88@P036<H48@@Q008DY@80008Li`8@Q08HaP8@Q0P48@8@Q088@P8<H`88@P848@8<H`88@P@48@88
@P800088@P8<H`848@88@P8<H`8DY@@48@8@Q088@P8HaP8@Q0@HaP8@Q08<H`8HaP8U:@8<H`8Li`8Y
BP8icP8Li`8]J`8e[@848@8mk`8U:@8DY@8@Q08HaP8Li`8HaP8icP8aS0924080008@Q09F]@8U:@9F
]@Moo`40005oo`005Goo00<007ooOol01Woo0U:D0Re[0Tic0RDY0RU:0R480QBU0TYB0P@Q0Q240P00
0SF]0Re[0QBU0Q240S6<0PQ20SW>0Q240PaS0QcW0Q240P@Q0QS60PaS0QS60PaS0QS60P000P@Q0QBU
0QS60PaS0PQ20Q240QBU0PaS20Q20P@Q0PQ20Q2410Q20QBU0Q240PaS0Q2410@Q10aS10Q20Q240PQ2
0P@Q0PaS0PQ200<HaP@Q12400QBU0P000QcW0Q240QS60Q2420@Q0Q240PQ20PaS0PQ20P@Q0PaS0PQ2
10@Q0PQ20P000PQ20PaS0P@Q0PQ20PaS0QBU10@Q0Q240PQ20QS60Q2411S60Q240PaS0QS60RDY0PaS
0QcW0RU:0SW>0QcW0Re[0SF]0P@Q0Sg_0RDY0QBU0Q240QS60QcW0QS60SW>0S6<0T8@0P000Q240UJe
0RDY0UJe1goo0@000Goo000EOol00`00Oomoo`06Ool2IcT2AS42BU82<H`26<H236<29BT248@2:DX2
48@236<2:DX28@P236<2:DX26<H22482:DX28@P636<2248236<2248200021244248248@46<H2:DX2
24826<H4124236<424820002248236<22484124448@236<224845:D212425:D21242248236<21242
36<424800`@Q36<<H`027>L236<248@236<2000248@2124248@21244248236<448@236<248@41242
2482000212442482124236<26<H236<45:D248@27>L2124424827>L25:D224828@P25:D236<29BT2
?Nl26<H25:D2AS427>L2@Q02;F/29BT248@28@P2:DX2=Jd27>L2E[D2AS42;F/2:DX2;F/2<H`2AS49
Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eoo`03001oogoo00Ioo`9W>@96<@9:DP8a
S08HaP8<H`8U:@8@Q08YBP8@Q08<H`8YBP8Q208<H`8YBP8HaP88@P8YBP8Q20H<H`88@P8<H`88@P80
00848@@8@P8@Q0@HaP8YBP88@P8HaP@48@8<H`@8@P800088@P8<H`88@P@48@@@Q08<H`88@P@DY@84
8@8DY@848@88@P8<H`848@8<H`@8@P03124<H`aS008Li`8<H`8@Q08<H`80008@Q0848@8@Q0848@@8
@P8<H`@@Q08<H`8@Q0@48@88@P8000848@@8@P848@8<H`8HaP8<H`@DY@8@Q08Li`848@@8@P8Li`8D
Y@88@P8Q208DY@8<H`8U:@8mk`8HaP8DY@96<@8Li`92408]J`8U:@8@Q08Q208YBP8e[@8Li`9F]@96
<@8]J`8YBP8]J`8aS096<@Uoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool2F]H4Ool2>Lh2HaP26<H248@2=Jd2;F/29BT2:DX248@29BT2
:DX212429BT448@28@P236<48@P29BT224827>L224829BT212425:D27>L424825:D26<H424825:D2
36<21242248448@2248236<648@22482000248@200042482000424828@P224826<H236<200022482
12400`Q248@@Q002248436<2248236<4124236<25:D42482124248@2000236<248@45:D2000236<2
5:D248@236<25:D27>L25:D248@2000248@25:D212425:D2:DX29BT236<25:D26<H2248448@2;F/2
6<H29BT2>Lh2<H`2>Lh2<H`26<H2<H`2E[D236<2=Jd2>Lh2=Jd2E[D2BU8248@27>L28@P2?Nl2IcT9
Ool10001Ool000=oo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo
0U[F17oo0SW>0V<H0QS60Q240SF]0Re[0RDY0RU:0Q240RDY0RU:0P@Q0RDY11240R480PaS12480RDY
0PQ20QcW0PQ20RDY0P@Q0QBU0QcW10Q20QBU0QS610Q20QBU0PaS0P@Q0PQ211240PQ20PaS1Q240PQ2
0P000Q240P0010Q20P0010Q20R480PQ20QS60PaS0P000PQ20P@Q00<8@Q2448@00PQ210aS0PQ20PaS
10@Q0PaS0QBU10Q20P@Q0Q240P000PaS0Q2411BU0P000PaS0QBU0Q240PaS0QBU0QcW0QBU0Q240P00
0Q240QBU0P@Q0QBU0RU:0RDY0PaS0QBU0QS60PQ211240Re[0QS60RDY0SW>0S6<0SW>0S6<0QS60S6<
0UJe0PaS0SF]0SW>0SF]0UJe0TYB0Q240QcW0R480Sg_0VLi27oo0P000Goo0003Ool01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`8icPAoo`9Nm`9S608aS08<
H`9JeP8]J`8@Q08Li`8DY@8icP88@P@U:@8<H`8Li`92408U:@848@88@P8HaP88@P8U:@8@Q08DY@8<
H`@DY@8YBP8DY@@@Q08<H`8DY@88@P8Li`8@Q0848@88@P848@8Q208Li`8<H`8DY@8HaP88@P8DY@84
8@80008@Q08000@8@P848@88@P@<H`H48@80000336<8@PQ2008<H`8000848@88@P@48@8@Q0848@8<
H`@48@88@P@<H`8@Q08DY@848@8DY@8<H`8DY@8<H`8HaP8Q208@Q0848@8@Q08YBP8@Q08Li`8<H`8D
Y@80008Li`@DY@8<H`8aS08<H`8YBP8DY@8<H`8]J`8U:@9:DP8U:@9JeP9BU088@P9S609BU08Q208Y
BP96<@8e[@96<@8mk`8Li`8U:@92409F]@9cW0Uoo`40005oo`000goo00D007ooOomoo`00009oo`04
001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2>Lh4Ool2G_L2HaP2<H`236<2F]H2;F/2
48@27>L25:D2>Lh224849BT236<27>L2@Q029BT2124224826<H224829BT248@25:D236<45:D2:DX2
5:D448@236<25:D224827>L248@21242248212428@P27>L236<25:D26<H224825:D21242000248@2
000424821242248436<6124200000`aS2488@P0236<2000212422484124248@2124236<412422484
36<248@25:D212425:D236<25:D236<26<H28@P248@2124248@2:DX248@27>L236<25:D200027>L4
5:D236<2<H`236<2:DX25:D236<2;F/29BT2BU829BT2F]H2DY@22482HaP2DY@28@P2:DX2AS42=Jd2
AS42?Nl27>L29BT2@Q02E[D2Li`9Ool10001Ool0009oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo
00Qoo`9BU08]J`8<H`8YBP9BU0@<H`8mk`8]J`848@8]J`8icP8Q208YBP8icP8HaP8Q208@Q08YBP84
8@8HaP8@Q088@P8Q2080008<H`8DY@8Li`8@Q08HaP8@Q08Li`88@P848@8<H`848@8@Q0848@88@P8@
Q0848@8HaP8<H`@@Q08000848@8DY@8<H`88@P@@Q088@P8000@48@88@P8<H`8@Q0848@0336<LiacW
00@48@88@P8DY@8000@8@P848@8<H`88@P848@8<H`88@P8<H`848@8<H`8Li`H48@@<H`@@Q088@P80
00@<H`8DY@80008<H`8HaP8Q2088@P8<H`8@Q0848@8Li`8U:@8DY@8Li`8DY@8icP9W>@8U:@9oo`8]
J`8U:@9Nm`8U:@88@P8HaP848@8HaP8e[@9BU09>L`8HaP8<H`9oo`8YBP9kgPMoo`40005oo`005Goo
00<007ooOol027oo0U:D0Re[0PaS0RU:0U:D10aS0Sg_0Re[0P@Q0Re[0SW>0R480RU:0SW>0QS60R48
0Q240RU:0P@Q0QS60Q240PQ20R480P000PaS0QBU0QcW0Q240QS60Q240QcW0PQ20P@Q0PaS0P@Q0Q24
0P@Q0PQ20Q240P@Q0QS60PaS11240P000P@Q0QBU0PaS0PQ211240PQ20P0010@Q0PQ20PaS0Q240P@Q
00<<HacW7>L010@Q0PQ20QBU0P0010Q20P@Q0PaS0PQ20P@Q0PaS0PQ20PaS0P@Q0PaS0QcW1P@Q10aS
11240PQ20P0010aS0QBU0P000PaS0QS60R480PQ20PaS0Q240P@Q0QcW0RDY0QBU0QcW0QBU0SW>0VLi
0RDY0Woo0Re[0RDY0Ukg0RDY0PQ20QS60P@Q0QS60SF]0U:D0Tic0QS60PaS0Woo0RU:0W_N1goo0@00
0Goo000EOol00`00Oomoo`08Ool2E[D2@Q02<H`2@Q02<H`2@Q04:DX248@2;F/2:DX29BT224829BT2
36<28@P29BT25:D236<25:D2:DX67>L212428@P236<26<H25:D224825:D236<248@224825:D26<H4
48@236<22484000236<224825:D4124248@2248236<2000436<4124236<2000236<424800a2436<<
H`0236<25:D2248248@2124224826<H248@200025:D436<412422482124236<224848@P27>L22482
5:D2248248@236<2124236<2124248@2248200025:D236<2<H`236<25:D46<H29BT248@25:D2<H`2
@Q02Li`2Kg/22482DY@2;F/248@4@Q029BT25:D2G_L2Ool2JeX47>L2Li`26<H2Mkd7Ool10001Ool0
01Eoo`03001oogoo00Qoo`9F]@92408aS092408aS09240@YBP8@Q08]J`8YBP8U:@88@P8U:@8<H`8Q
208U:@8DY@8<H`8DY@8YBPHLi`848@8Q208<H`8HaP8DY@88@P8DY@8<H`8@Q088@P8DY@8HaP@@Q08<
H`88@P@0008<H`88@P8DY@@48@8@Q088@P8<H`8000@<H`@48@8<H`80008<H`@8@P0348@<H`aS008<
H`8DY@88@P8@Q0848@88@P8HaP8@Q080008DY@@<H`@48@88@P848@8<H`88@P@Q208Li`88@P8DY@88
@P8@Q08<H`848@8<H`848@8@Q088@P80008DY@8<H`8aS08<H`8DY@@HaP8U:@8@Q08DY@8aS092409c
W09_N`88@P9BU08]J`8@Q0A2408U:@8DY@9Nm`9oo`9[FP@Li`9cW08HaP9g_@Moo`40005oo`005Goo
00<007ooOol01Woo0THa0QBU0Tic0RU:0SW>0T8@0TYB12480RDY0Re[0QcW0Q240T8@0RDY0Q240R48
0PQ20RDY12480P@Q0Q240PaS0QBU0P@Q0QcW0QBU1Q240RU:0Q240P@Q0PQ20QBU0PQ20QBU0PQ20P@Q
0P000QBU0P000Q240P000Q240P000QcW1PQ20Q240P@Q0QcW0P@Q0Q240P000PQ20QS60P@Q0PQ200<D
Y@@Q12400PQ20PaS0P001PaS0QBU0PaS0Q240QcW0PaS0PQ20PaS0Q240QS60Q240PaS0PQ20PaS10Q2
0R4811240QBU0P@Q0PaS0QBU0QcW10Q2100011240QBU0S6<0Q2412480PaS0PQ20T8@0QS60VLi0TYB
0THa0V]J0RDY0V<H0T8@0RU:0U[F0RU:0Vmk0Woo13F]0QS60UJe0VLi2Goo0@000Goo000EOol00`00
Oomoo`06Ool2AS425:D2CW<2:DX2>Lh2@Q02BU848@P29BT2;F/27>L248@2@Q029BT248@28@P22482
9BT48@P2124248@236<25:D212427>L25:D648@2:DX248@2124224825:D224825:D2248212420002
5:D2000248@2000248@200027>L6248248@212427>L2124248@2000224826<H2124224800aBU1244
8@02248236<2000636<25:D236<248@27>L236<2248236<248@26<H248@236<2248236<424828@P4
48@25:D2124236<25:D27>L42484000448@25:D2<H`248@48@P236<22482@Q026<H2IcT2BU82AS42
JeX29BT2HaP2@Q02:DX2F]H2:DX2Kg/2Ool4=Jd26<H2E[D2IcT9Ool10001Ool001Eoo`03001oogoo
009oo`9BU09oo`9[FP8YBP9oo`8U:@9>L`9[FP9BU088@P8HaP8]J`8e[@8<H`8Li`8mk`848@8HaP96
<@80008aS08@Q0@Q208U:@@HaP8DY@8HaP8]J`8Li`8@Q08YBP848@8<H`8YBP8@Q08<H`8DY@848@8H
aP8<H`88@P8@Q088@P8@Q0848@@@Q08HaP@DY@8<H`88@P8<H`8HaP848@80008@Q08HaPH<H`<@Q088
@P8HaP88@P8@Q0848@@8@P@48@8<H`@8@PP<H`8@Q08Li`8DY@P<H`88@P8@Q0848@8DY@848@@8@P8H
aP8Q208@Q08<H`8Li`8Q208HaP848@8@Q08DY@8Q208@Q08Q208DY@9cW08aS09oo`9JeP96<@9oo`8]
J`9F]@8aS09W>@9_N`9[FP8@Q080008DY@8Q20]oo`40005oo`005Goo0P000goo0U:D0Woo0V]J0RU:
0Woo0RDY0Tic0V]J0U:D0PQ20QS60Re[0SF]0PaS0QcW0Sg_0P@Q0QS60THa0P000S6<0Q2412480RDY
11S60QBU0QS60Re[0QcW0Q240RU:0P@Q0PaS0RU:0Q240PaS0QBU0P@Q0QS60PaS0PQ20Q240PQ20Q24
0P@Q11240QS611BU0PaS0PQ20PaS0QS60P@Q0P000Q240QS61PaS0a240PQ20QS60PQ20Q240P@Q10Q2
10@Q0PaS10Q220aS0Q240QcW0QBU20aS0PQ20Q240P@Q0QBU0P@Q10Q20QS60R480Q240PaS0QcW0R48
0QS60P@Q0Q240QBU0R480Q240R480QBU0W>L0S6<0Woo0U[F0THa0Woo0Re[0UJe0S6<0VLi0Vmk0V]J
0Q240P000QBU0R482Woo0P000Goo000EOol00`00Oomoo`02Ool2>Lh4Ool2HaP2Ool25:D2AS42Ool2
@Q02;F/2>Lh2AS42;F/2<H`29BT2;F/26<H2:DX28@P636<27>L212428@P2BU826<H224826<H2>Lh2
48@2248248@4124224826<H25:D26<H27>L25:D26<H436<2124248@27>L224825:D236<212425:D2
48@25:D436<224825:D4124236<424800`@Q48@@Q0027>L2248248@212425:D2000412425:D248@2
6<H27>L424825:D212425:D236<28@P25:D26<H236<2248236<27>L22482:DX27>L248@212428@P2
6<H25:D436<25:D29BT25:D26<H29BT248@25:D2>Lh2;F/2G_L2<H`2Ool2CW<4JeX2:DX2AS4248@2
<H`2?Nl2F]H2@Q02F]H28@P2Mkd;Ool10001Ool001Eoo`03001oogoo009oo`8icPAoo`9S609oo`8D
Y@96<@9oo`92408]J`8icP96<@8]J`8aS08U:@8]J`8HaP8YBP8Q20H<H`8Li`848@8Q209:DP8HaP88
@P8HaP8icP8@Q088@P8@Q0@48@88@P8HaP8DY@8HaP8Li`8DY@8HaP@<H`848@8@Q08Li`88@P8DY@8<
H`848@8DY@8@Q08DY@@<H`88@P8DY@@48@8<H`@8@P03124@Q124008Li`88@P8@Q0848@8DY@8000@4
8@8DY@8@Q08HaP8Li`@8@P8DY@848@8DY@8<H`8Q208DY@8HaP8<H`88@P8<H`8Li`88@P8YBP8Li`8@
Q0848@8Q208HaP8DY@@<H`8DY@8U:@8DY@8HaP8U:@8@Q08DY@8icP8]J`9Nm`8aS09oo`9>L`A[FP8Y
BP96<@8@Q08aS08mk`9JeP92409JeP8Q209g_@]oo`40005oo`005Goo00<007ooOol02Woo14ic0V]J
0Tic0Re[0QcW0T8@0R480QcW0QS60R480Re[0SF]0QcW0P@Q0Re[0P000RDY10Q21S6<0Re[0R480P@Q
0PQ20QS60Q240QBU0PaS0QcW0P000QBU0PQ20Q240QcW0PaS0QBU0Q240PQ20Q240PQ21Q240R4810aS
0P000P@Q0PQ20QBU0PaS0QBU0Q240QS60P000P@Q00<@Q1BU5:D00PaS0PQ20P@Q0PQ20Q240PaS0P@Q
10aS0Q240PaS10@Q0P000P@Q0QBU0Q240PQ20PaS0Q241PQ20QBU1P@Q10aS0QS60PaS0QBU0Q240R48
0QBU0PaS0RDY0PQ20PaS0P@Q0QBU0Q240Sg_12e[0V<H0Woo0S6<0Woo15kg0SF]0QBU0Q240U:D17oo
0Tic0UJe0Woo0U[F0V]J1goo0@000Goo000EOol00`00Oomoo`0:Ool4CW<2JeX2CW<2;F/27>L2@Q02
8@P27>L26<H28@P2;F/2=Jd27>L21242;F/200029BT42486<H`2;F/28@P2124224826<H248@25:D2
36<27>L200025:D2248248@27>L236<25:D248@2248248@2248648@28@P436<20002124224825:D2
36<25:D248@26<H2000212400a245:DDY@0236<224821242248248@236<2124436<248@236<41242
000212425:D248@2248236<248@624825:D6124436<26<H236<25:D248@28@P25:D236<29BT22482
36<212425:D248@2?Nl4;F/2HaP2Ool2<H`2Ool4G_L2=Jd25:D248@2DY@4Ool2CW<2E[D2Ool2F]H2
JeX7Ool10001Ool001Eoo`03001oogoo00Yoo`8e[@9kgP9JeP8]J`8icP9>L`8]J`8<H`848@9>L`8Q
208U:@8HaP8U:@8DY@8Li`8U:@9>L`8U:@8DY@92408]J`8@Q08Li`8icP88@P8@Q08DY@8U:@@DY@84
8@8@Q08Li`88@P848@@<H`8DY@80008@Q08Q2088@P8@Q088@P8HaP8Li`848@8<H`H8@P8<H`8DY@88
@P848@8<H`@8@P03124@Q124008DY@80008<H`@DY@88@P848@8@Q0H<H`H8@P8@Q08DY@@@Q0848@88
@P848@88@P8YBPH@Q0848@8@Q0848@8@Q0HDY@80008<H`8DY@@Li`8@Q08aS08HaP8U:@@icP8e[@9F
]@9g_@9S609oo`92409oo`9S609>L`9F]@Aoo`9S608]J`9cW09oo`9S609Nm`Moo`40005oo`005Goo
00<007ooOol02Woo0SF]0W_N0U[F0Re[0SW>0Tic0Re[0PaS0P@Q0Tic0R480RDY0QS60RDY0QBU0QcW
0RDY0Tic0RDY0QBU0T8@0Re[0Q240QcW0SW>0PQ20Q240QBU0RDY11BU0P@Q0Q240QcW0PQ20P@Q10aS
0QBU0P000Q240R480PQ20Q240PQ20QS60QcW0P@Q0PaS1PQ20PaS0QBU0PQ20P@Q0PaS10Q200<48A24
48@00QBU0P000PaS11BU0PQ20P@Q0Q241PaS1PQ20Q240QBU11240P@Q0PQ20P@Q0PQ20RU:1Q240P@Q
0Q240P@Q0Q241QBU0P000PaS0QBU11cW0Q240S6<0QS60RDY13W>0SF]0UJe0WNm0V<H0Woo0T8@0Woo
0V<H0Tic0UJe17oo0V<H0Re[0W>L0Woo0V<H0Ukg1goo0@000Goo000EOol00`00Oomoo`08Ool2HaP2
Ool2Nmh2Ool28@P2Nmh2?Nl25:D248@26<H2=Jd2:DX2@Q028@P2;F/2BU829BT2;F/2?Nl29BT2@Q02
6<H28@P25:D2;F/28@P2:DX25:D28@P2124248@27>L28@P248@25:D224827>L200026<H2248248@2
12427>L424829BT212426<H848@224827>L236<200028@P25:D2000248@00`aS2488@P02248248@2
36<21246248236<26<H2248248@27>L236<248@2248248@21246248236<45:D236<248@25:D22482
36<29BT25:D212429BT248@236<25:D236<46<H2;F/42482<H`29BT2?Nl28@P2Mkd26<H2Ool2E[D4
Ool2Li`2G_L4Ool2HaP2CW<248@2>Lh28@P;Ool10001Ool001Eoo`03001oogoo00Qoo`9S609oo`9k
gP9oo`8Q209kgP8mk`8DY@8@Q08HaP8e[@8YBP92408Q208]J`9:DP8U:@8]J`8mk`8U:@92408HaP8Q
208DY@8]J`8Q208YBP8DY@8Q20848@8@Q08Li`8Q208@Q08DY@88@P8Li`80008HaP88@P8@Q0848@8L
i`@8@P8U:@848@8HaPP@Q088@P8Li`8<H`80008Q208DY@80008@Q00336<8@PQ20088@P8@Q08<H`84
8@H8@P8<H`8HaP88@P8@Q08Li`8<H`8@Q088@P8@Q0848@H8@P8<H`@DY@8<H`8@Q08DY@88@P8<H`8U
:@8DY@848@8U:@8@Q08<H`8DY@8<H`@HaP8]J`@8@P8aS08U:@8mk`8Q209g_@8HaP9oo`9F]@Aoo`9c
W09Nm`Aoo`9S609>L`8@Q08icP8Q20]oo`40005oo`005Goo00<007ooOol01Woo0V]J0QS617oo0RU:
0Woo0V]J0R480PaS0P000Re[0SF]0RU:0Sg_0SF]0THa0PQ20Q240SW>0R480TYB0THa0P@Q0Re[0S6<
0PaS0QBU0Re[0R480SW>0QS60Q240QBU0Q240QBU0PaS0Q240PaS0Q240R480QS60P@Q0PaS0Q240PQ2
0QcW0PaS0Q240QS60PQ20QcW10aS0P0010Q20R4810Q211S600<000@Q12400QS60Q240P@Q10aS0QS6
0Q2410@Q0PQ20QBU0PaS0P000QBU0Q240PQ20Q240QS60QBU0PaS0P@Q0PaS0PQ212480QBU0RDY0PQ2
0R480PaS0QBU0S6<0QS60QBU0Q240QBU0PQ20QBU0SF]0THa0Q240RU:13F]0U:D0T8@0QS60Woo0SF]
17oo0TYB0WNm0Tic0Sg_0TYB0RDY0RU:0Sg_3Goo0@000Goo000EOol20007Ool2JeX26<H4Ool2:DX2
Ool2JeX28@P236<20002;F/2=Jd2:DX2?Nl2=Jd2AS42248248@2>Lh28@P2BU82AS421242;F/2<H`2
36<25:D2;F/28@P2>Lh26<H248@25:D248@25:D236<248@236<248@28@P26<H2124236<248@22482
7>L236<248@26<H224827>L436<2000424828@P424846<H00`0012448@026<H248@2124436<26<H2
48@4124224825:D236<200025:D248@2248248@26<H25:D236<2124236<224848@P25:D29BT22482
8@P236<25:D2<H`26<H25:D248@25:D224825:D2=Jd2AS4248@2:DX4=Jd2DY@2@Q026<H2Ool2=Jd4
Ool2BU82Mkd2CW<2?Nl2BU829BT2:DX2?Nl<Ool20001Ool001Eoo`03001oogoo009oo`9S60Aoo`9>
L`9oo`96<@9F]@9oo`8Q20848@9>L`8U:@8Q208YBP8U:@9JeP9Nm`8mk`8Q209F]@9:DP8HaP8U:@8D
Y@8U:@8HaP@@Q0@00088@P8Li`88@P8Q208HaP8@Q08Li`88@P80008@Q08HaP8DY@@@Q080008<H`@@
Q08Li`@<H`8HaP8@Q088@P8DY@848@8@Q0@DY@8@Q08Li`D8@P8Q2080008<H`@@Q080008@Q088@P8@
Q0@<H`88@P8<H`800088@P8Li`8DY@8@Q08Li`8DY@8Q208@Q08HaP88@P8Q2080008@Q08<H`8DY@8U
:@8<H`HQ208icP8@Q08DY@8HaP8@Q08U:@8Li`8]J`8Q208e[@9S608DY@9[FP8<H`9oo`9Nm`9oo`9B
U09g_@9cW09S609JeP9_N`9oo`9_N`9>L`eoo`40005oo`005Goo00<007ooOol00Woo0V<H17oo0Tic
0Woo0THa0UJe0Woo0R480P@Q0Tic0RDY0R480RU:0RDY0U[F0Ukg0Sg_0R480UJe0TYB0QS60RDY0QBU
0RDY0QS6112410000PQ20QcW0PQ20R480QS60Q240QcW0PQ20P000Q240QS60QBU11240P000PaS1124
0QcW10aS0QS60Q240PQ20QBU0P@Q0Q2411BU0Q240QcW1@Q20R480P000PaS11240P000Q240PQ20Q24
10aS0PQ20PaS0P000PQ20QcW0QBU0Q240QcW0QBU0R480Q240QS60PQ20R480P000Q240PaS0QBU0RDY
0PaS1R480SW>0Q240QBU0QS60Q240RDY0QcW0Re[0R480SF]0V<H0QBU0V]J0PaS0Woo0Ukg0Woo0U:D
0WNm0W>L0V<H0U[F0Vmk0Woo0Vmk0Tic3Goo0@000Goo000EOol00`00Oomoo`0<Ool2DY@2HaP2CW<2
6<H2?Nl2=Jd2?Nl2;F/2>Lh29BT2<H`2=Jd2;F/27>L2:DX27>L2IcT2:DX28@P2248248@2<H`248@2
6<H27>L26<H2124236<248@27>L29BT236<248@836<412425:D236<26<H2124236<2000236<22482
5:D248@26<H236<2248436<27>L248@424800acW48@@Q002124200025:D248@25:D20002248236<2
248236<46<H2124248@22484124248@27>L236<25:D2124236<25:D2248212427>L424845:D26<H2
36<2>Lh2;F/25:D236<27>L28@P22482<H`27>L2AS44=Jd2>Lh2CW<2E[D2=Jd2Ool2HaP2Ool2Li`2
Nmh4Ool2Kg/2Nmh4Ool2<H`2IcT7Ool10001Ool001Eoo`03001oogoo00aoo`9BU09S609>L`8HaP8m
k`8e[@8mk`8]J`8icP8U:@8aS08e[@8]J`8Li`8YBP8Li`9W>@8YBP8Q2088@P8@Q08aS08@Q08HaP8L
i`8HaP848@8<H`8@Q08Li`8U:@8<H`8@Q0P<H`@48@8DY@8<H`8HaP848@8<H`80008<H`88@P8DY@8@
Q08HaP8<H`88@P@<H`8Li`8@Q0@8@P037>L@Q12400848@80008DY@8@Q08DY@800088@P8<H`88@P8<
H`@HaP848@8@Q088@P@48@8@Q08Li`8<H`8DY@848@8<H`8DY@88@P848@8Li`@8@P@DY@8HaP8<H`8i
cP8]J`8DY@8<H`8Li`8Q2088@P8aS08Li`96<@@e[@8icP9>L`9F]@8e[@9oo`9S609oo`9cW09kgPAo
o`9_N`9kgPAoo`8aS09W>@Moo`40005oo`005Goo00<007ooOol02Woo0PQ217oo0V<H0U:D0TYB0QS6
0Sg_0TYB0QS60RDY0U[F0RU:0QS60Vmk0QBU0Re[0RU:0PaS0RDY0R480PQ20P@Q11BU0Q240R480Re[
0QS60Q240QcW0P000QBU0Q2411cW0P@Q0PQ211240P000PaS0QS60PaS0QS60RDY0QcW0RDY10Q20QS6
0PQ20QS610Q20Q240PQ20P000PQ21A240PQ20QcW0P@Q0Q240PQ20Q240QBU0Q2410Q20QcW0PQ210@Q
10Q20R480PaS0Q240PaS11240PQ20P000QS60PaS0Q240PaS0QS60PaS0QcW0Re[0RDY0R480SF]0PaS
0RDY0R480PQ20R480Ukg0Re[0T8@0U[F0Woo0U[F0U:D0V<H0Vmk37oo0Ukg17oo0W>L2goo0@000Goo
000EOol00`00Oomoo`0:Ool22484Ool2HaP2DY@2BU826<H2?Nl2BU826<H29BT2F]H2:DX26<H2Kg/2
5:D2;F/2:DX236<29BT28@P2248212445:D248@28@P2;F/26<H248@27>L200025:D248@47>L21242
248448@2000236<26<H236<26<H29BT27>L29BT424826<H224826<H4248248@224820002248548@2
24827>L2124248@2248248@25:D248@424827>L22484124424828@P236<248@236<448@224820002
6<H236<248@236<26<H236<27>L2;F/29BT28@P2=Jd236<29BT28@P224828@P2G_L2;F/2@Q02F]H2
Ool2F]H2DY@2HaP2Kg/<Ool2G_L4Ool2Li`;Ool10001Ool001Eoo`03001oogoo00Yoo`9JePAoo`8e
[@9W>@9>L`8Q208icP9BU09Nm`8DY@9JeP8mk`9Nm`8@Q08icP92408aS088@P8HaP8<H`8Li`8DY@88
@P8e[@8@Q08HaP8U:@8<H`8Q20@Li`H<H`8Q208HaPH<H`8Q2088@P8U:@8YBP88@P848@8DY@848@8D
Y@8HaP8Li`8DY@8<H`88@P8Li`8DY@8@Q08<H`<HaP8<H`8DY@@8@P8<H`8DY@8Li`8@Q080008YBP8D
Y@848@8DY@8HaP848@@@Q0@DY@80008@Q088@P848@8YBP8@Q08DY@8U:@8Q208<H`8@Q08HaP8Li`@Q
208mk`8<H`8e[@8Q208HaP8e[@9>L`8YBP9:DP8e[@9BU08Li`Qoo`9kgPYoo`9:DP8U:@9[FP92409g
_@]oo`40005oo`005Goo00<007ooOol02Woo0U[F17oo0SF]0VLi0Tic0R480SW>0U:D0Ukg0QBU0U[F
0Sg_0Ukg0Q240SW>0T8@0S6<0PQ20QS60PaS0QcW0QBU0PQ20SF]0Q240QS60RDY0PaS0R4811cW1PaS
0R480QS61PaS0R480PQ20RDY0RU:0PQ20P@Q0QBU0P@Q0QBU0QS60QcW0QBU0PaS0PQ20QcW0QBU0Q24
0PaS0aS60PaS0QBU10Q20PaS0QBU0QcW0Q240P000RU:0QBU0P@Q0QBU0QS60P@Q112411BU0P000Q24
0PQ20P@Q0RU:0Q240QBU0RDY0R480PaS0Q240QS60QcW12480Sg_0PaS0SF]0R480QS60SF]0Tic0RU:
0TYB0SF]0U:D0QcW27oo0W_N2Woo0TYB0RDY0V]J0T8@0WNm2goo0@000Goo000EOol00`00Oomoo`06
Ool2Mkd25:D2Ool2DY@2>Lh2Ool2=Jd28@P2F]H2:DX2BU82HaP2IcT22484E[D2<H`28@P2BU822482
48@28@P2:DX2=Jd2E[D2;F/26<H2:DX212428@P26<H224825:D248@28@P45:D224825:D26<H436<4
124248@27>L248@25:D236<25:D248@6124448@2248248@436<248@00aBU48@@Q002248248@236<2
48@28@P2248236<26<H2124224825:D27>L212426<H448@26<H236<2000248@212425:D248@28@P2
5:D448@2;F/26<H236<25:D212442482;F/2<H`236<2@Q029BT2E[D27>L25:D2BU82Ool2CW<2Mkd6
Ool2<H`:Ool2?Nl2Ool2G_L?Ool10001Ool001Eoo`8000Moo`9g_@8DY@9oo`9BU08icP9oo`8e[@8Q
209JeP8YBP9:DP9S609W>@88@PAF]@8aS08Q209:DP88@P8@Q08Q208YBP8e[@9F]@8]J`8HaP8YBP84
8@8Q208HaP88@P8DY@8@Q08Q20@DY@88@P8DY@8HaP@<H`@48@8@Q08Li`8@Q08DY@8<H`8DY@8@Q0H4
8@@@Q088@P8@Q0@<H`8@Q0035:D@Q1240088@P8@Q08<H`8@Q08Q2088@P8<H`8HaP848@88@P8DY@8L
i`848@8HaP@@Q08HaP8<H`80008@Q0848@8DY@8@Q08Q208DY@@@Q08]J`8HaP8<H`8DY@848@@8@P8]
J`8aS08<H`92408U:@9F]@8Li`8DY@9:DP9oo`9>L`9g_@Ioo`8aS0Yoo`8mk`9oo`9Nm`ioo`80005o
o`005Goo00<007ooOol037oo0Re[0WNm0U[F0VLi0TYB0THa0Tic0Sg_0TYB0W_N0W>L0SW>0U:D0SF]
0PaS0RDY0THa0RDY0QcW0Re[0TYB0THa0R480PQ20QBU0PaS0Re[0QcW0PaS0QBU0QS60PaS0QBU0Q24
0RDY0QcW0PaS1PQ211S60Q240P@Q0QS60Q240PQ210aS0QS60Re[0PQ20QS610Q20P@Q11BU00<48@aS
36<00QS60PaS0QBU0PaS0QBU0QS60P@Q0PQ20Q240P000PaS0Q240QS60PaS10Q20PaS0PQ20PaS0P@Q
0QS60QBU0P@Q0QBU0PaS0P@Q0QcW0PaS0RDY10@Q0Q240P000RU:0SF]0QcW0R480QBU0Ukg0RU:0Sg_
0UJe0T8@0WNm0U:D27oo0U:D3Woo0TYB3goo0@000Goo000EOol00`00Oomoo`0<Ool2;F/2Mkd2F]H2
IcT2BU82AS42CW<2?Nl2BU82Nmh2Li`2>Lh2DY@2=Jd236<29BT2AS429BT27>L2;F/2BU82AS428@P2
24825:D236<2;F/27>L236<25:D26<H236<25:D248@29BT27>L236<624846<H248@212426<H248@2
248436<26<H2;F/224826<H4248212445:D00`@Q36<<H`026<H236<25:D236<25:D26<H212422482
48@2000236<248@26<H236<4248236<2248236<212426<H25:D212425:D236<212427>L236<29BT4
124248@20002:DX2=Jd27>L28@P25:D2G_L2:DX2?Nl2E[D2@Q02Mkd2DY@8Ool2DY@>Ool2BU8?Ool1
0001Ool001Eoo`03001oogoo00ioo`9cW09oo`9F]@9g_@8]J`9:DP9oo`9240ANm`8mk`8Li`9Nm`8U
:@8YBP8@Q08]J`9JeP9>L`92408Q208icP9F]@8]J`8Li`8HaP88@P8U:@8HaP8YBP88@P8DY@@@Q08H
aP8Q208<H`8HaP88@P8HaP8<H`8Li`8<H`@Li`H@Q08Li`88@P8@Q08HaP8@Q08DY@@48@8<H`036<H4
8@@Q008HaP8<H`@@Q0@DY@8<H`848@8Li`8HaP88@P8HaP848@8@Q0@DY@8HaP@@Q088@P@<H`8U:@84
8@88@P8Li`@YBP8@Q088@P8]J`8U:@8Q20@YBP9>L`8Q208e[@8U:@8@Q092409cW09F]@8mk`88@PAo
o`9cW09oo`9S609oo`9BU11oo`8@Q08mk`Moo`40005oo`005Goo00<007ooOol03Woo0W>L0Woo0UJe
0WNm0Re[0TYB0Woo0T8@15kg0Sg_0QcW0Ukg0RDY0RU:0Q240Re[0U[F0Tic0T8@0R480SW>0UJe0Re[
0QcW0QS60PQ20RDY0QS60RU:0PQ20QBU11240QS60R480PaS0QS60PQ20QS60PaS0QcW0PaS11cW1Q24
0QcW0PQ20Q240QS60Q240QBU10@Q0PaS00<HaP@Q12400QS60PaS112411BU0PaS0P@Q0QcW0QS60PQ2
0QS60P@Q0Q2411BU0QS611240PQ210aS0RDY0P@Q0PQ20QcW12U:0Q240PQ20Re[0RDY0R4812U:0Tic
0R480SF]0RDY0Q240T8@0W>L0UJe0Sg_0PQ217oo0W>L0Woo0V<H0Woo0U:D47oo0Q240Sg_1goo0@00
0Goo000EOol00`00Oomoo`0@Ool22482Kg/2IcT2?Nl2Kg/2Ool2Li`2IcT2JeX29BT2@Q02>Lh29BT2
JeX4Ool2E[D46<H25:D2;F/25:D236<29BT248@2:DX45:D236<28@P26<H236<28@P448@236<22484
36<200025:D236<28@P25:D28@P46<H25:D448@200022482124224826<H28@P336<22482:DX236<2
248236<27>L236<248@25:D248@26<H236<2124236<248@26<H25:D2248248@29BT248@27>L29BT2
5:D236<26<H448@26<H2?Nl25:D212426<H28@P25:D2AS42E[D2JeX29BT2?Nl2Ool2;F/29BT2@Q02
?NlLOol2124;Ool10001Ool001Eoo`03001oogoo011oo`88@P9_N`9W>@8mk`9_N`9oo`9cW09W>@9[
FP8U:@92408icP8U:@9[FPAoo`9F]@@HaP8DY@8]J`8DY@8<H`8U:@8@Q08YBP@DY@8<H`8Q208HaP8<
H`8Q20@@Q08<H`88@P@<H`80008DY@8<H`8Q208DY@8Q20@HaP8DY@@@Q0800088@P848@88@P8HaP8Q
20<<H`88@P8YBP8<H`88@P8<H`8Li`8<H`8@Q08DY@8@Q08HaP8<H`848@8<H`8@Q08HaP8DY@88@P8@
Q08U:@8@Q08Li`8U:@8DY@8<H`8HaP@@Q08HaP8mk`8DY@848@8HaP8Q208DY@96<@9F]@9[FP8U:@8m
k`9oo`8]J`8U:@92408mkaaoo`848@]oo`40005oo`005Goo00<007ooOol047oo0Sg_0T8@0W_N0Woo
0U:D0Tic17oo0SF]0U[F0U:D0T8@0Ukg0U[F0TYB0Q240Tic0SW>0S6<0V<H0PaS12480Re[0Tic0QBU
0R480PaS0R480Re[0P000PQ211BU0R480PaS0P@Q0RDY1Q240RU:0P@Q0PQ20PaS0RDY10aS0QBU0P@Q
1PQ20QS60Q240PaS00<@Q1BU5:D00PaS0P@Q0PQ210aS0QBU0PaS0Re[0Q240QBU0PaS11BU0PQ20QcW
0PQ20PaS0P000PaS0P000PQ20PaS0Q240RDY0PQ20RDY0PQ20QcW0P000P@Q0QBU0QS60SF]0U[F0PaS
0U[F0U:D0S6<0Tic0U:D0QS60T8@0W>L0WNm17oo0S6<17oo0V<H0Woo0Re[6goo0@000Goo00000goo
0000000300000goo000000020003Ool20005Ool00`00Oomoo`0@Ool2?Nl2@Q02Nmh2Ool2DY@2CW<4
Ool2=Jd2F]H2DY@2@Q02G_L2F]H2BU8248@2CW<2>Lh2<H`2HaP236<48@P2;F/2CW<25:D28@P236<2
8@P2;F/2000224845:D28@P236<212429BT648@2:DX21242248236<29BT436<25:D2124624826<H2
48@236<00a245:DDY@0236<21242248436<25:D236<2;F/248@25:D236<45:D224827>L2248236<2
000236<20002248236<248@29BT224829BT224827>L2000212425:D26<H2=Jd2F]H236<2F]H2DY@2
<H`2CW<2DY@26<H2@Q02Li`2Mkd4Ool2<H`4Ool2HaP2Ool2;F/KOol10001Ool000=oo`05001oogoo
Ool00005Ool01000Oomoo`0017oo00<007ooOol027oo0SW>0Woo0RDY17oo0Ukg0U:D0WNm17oo0Re[
0TYB0Woo0TYB0WNm0VLi0UJe0Woo0T8@0V<H15[F0Re[0SW>0RDY0PQ20RU:0Q240Re[0PaS11S60R48
0RU:0PQ20PaS0PQ20PaS0QcW0Q240QS60RU:1QBU0QcW0P000P@Q0Q240QBU0Q2410@Q1QS60QBU0PaS
0QBU0Q2400<HaPQ224800Q240QBU0QS60PaS11S60P00112410aS0P000QS60P@Q0QBU0QS610aS10Q2
0PaS0QBU0Q240Re[0QcW0PaS0Q240QBU10Q20QS60QcW0T8@0SF]0RDY13W>0U[F0Woo0Sg_0SF]17oo
0U[F17oo0Sg_27oo0QBU6goo0@000Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomo
o`0017oo0P002Goo0SW>0Woo0RDY17oo0Ukg0U:D0WNm17oo0Re[0TYB0Woo0TYB0WNm0VLi0UJe0Woo
0T8@0V<H15[F0Re[0SW>0RDY0PQ20RU:0Q240Re[0PaS11S60R480RU:0PQ20PaS0PQ20PaS0QcW0Q24
0QS60RU:1QBU0QcW0P000P@Q0Q240QBU0Q2410@Q1QS60QBU0PaS0QBU0Q2400<HaPQ224800Q240QBU
0QS60PaS11S60P00112410aS0P000QS60P@Q0QBU0QS610aS10Q20PaS0QBU0Q240Re[0QcW0PaS0Q24
0QBU10Q20QS60QcW0T8@0SF]0RDY13W>0U[F0Woo0Sg_0SF]17oo0U[F17oo0Sg_27oo0QBU6Woo0P00
0Goo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol03Woo
0W>L0Woo0Ukg0Woo0S6<17oo0U:D27oo0T8@0S6<15Je0VLi0V]J0U[F0VLi0SW>0QBU0RU:11cW0Q24
0QS60Re[0QBU0QS60QBU0Q2412DY0QcW0P@Q0QBU10aS0QcW0QBU0QcW0Q240PQ20P000PQ20RDY11S6
0QBU0P@Q0QS60PQ20QBU11240bDY0P0011BU1PaS0Q2411S60PQ20QBU0QS60PQ211BU0PaS0P@Q0QS6
0R480PaS0Q240P@Q0P000Re[0QBU0PaS0R480QBU11cW0R480S6<0PaS0S6<0R480S6<0V]J0Woo0V<H
0TYB0RU:0TYB0Woo0Re[0Woo0V]J0Re[17oo0S6<8Goo0@000Goo0003Ool01@00Oomoogoo00000Woo
00@007ooOol0009oo`03001oogoo009oo`03001oogoo00ioo`9cW09oo`9Nm`9oo`8aS0Aoo`9BU0Qo
o`92408aS0AF]@9W>@9[FP9JeP9W>@8icP8DY@8YBP@Li`8@Q08HaP8]J`8DY@8HaP8DY@8@Q0@U:@8L
i`848@8DY@@<H`8Li`8DY@8Li`8@Q088@P800088@P8U:@@HaP8DY@848@8HaP88@P8DY@@@Q0<U:@80
00@DY@H<H`8@Q0@HaP88@P8DY@8HaP88@P@DY@8<H`848@8HaP8Q208<H`8@Q0848@80008]J`8DY@8<
H`8Q208DY@@Li`8Q208aS08<H`8aS08Q208aS09[FP9oo`9S609:DP8YBP9:DP9oo`8]J`9oo`9[FP8]
J`Aoo`8aS25oo`40005oo`000Woo0P0017oo0P0017oo0P001Goo00<007ooOol05Woo0V]J27oo0W>L
0Ukg0Woo0Tic0Vmk0TYB0Q240WNm0QS60QBU0R480Re[0RU:0S6<0QcW0RDY0RU:0SF]0QS60R480QS6
0QBU0Sg_0QBU0Re[0S6<0R480S6<0QS60PaS0PQ20R480RDY0Q240Re[0P000R480Re[0QcW0SF]0PaS
0Q240QcW0S6<0PQ20QcW0QBU0PQ200<Q200000000R480QS60QBU0P000R480RU:0PQ20QcW11S60PQ2
0P@Q0QcW0Q240QS60PaS0Q240QcW0P@Q0Q240R4811S60PaS0RU:0QBU0QcW0QBU0Q240SW>12DY0RU:
0Sg_0VLi0Re[0S6<0THa0RU:0Woo0W_N0Ukg37oo0PaS8Goo0@000Goo000EOol00`00Oomoo`0FOol2
JeX8Ool2Li`2G_L2Ool2CW<2Kg/2BU8248@2Mkd26<H25:D28@P2;F/2:DX2<H`27>L29BT2:DX2=Jd2
6<H28@P26<H25:D2?Nl25:D2;F/2<H`28@P2<H`26<H236<224828@P29BT248@2;F/200028@P2;F/2
7>L2=Jd236<248@27>L2<H`224827>L25:D224800b48000000028@P26<H25:D200028@P2:DX22482
7>L46<H2248212427>L248@26<H236<248@27>L2124248@28@P46<H236<2:DX25:D27>L25:D248@2
>Lh49BT2:DX2?Nl2IcT2;F/2<H`2AS42:DX2Ool2Nmh2G_L<Ool236<QOol10001Ool001Eoo`03001o
ogoo00Yoo`9Nm`Aoo`9Nm`9240Qoo`9BU09[FP8aS08]J`9kgP8icP8aS09:DP8e[@8HaP8]J`8mk`9>
L`9:DP9>L`8U:@@@Q08aS08Q208DY@8Li`8aS0@@Q0@Q20@@Q08U:@8Li`8DY@8HaP@<H`88@P8HaP8L
i`8YBP8Li`8DY@8Li`8<H`848@8@Q0848@8Q2088@P8000D8@P8<H`848@8@Q08<H`88@P8<H`8DY@84
8@8Li`848@88@P8@Q08DY@8HaP8@Q08<H`848@88@PHQ208DY@8Li`8icP80008YBP848@8Li`8<H`8e
[@8U:@8<H`8Q208U:@8YBP8Q208YBP8U:@9cW09:DP9W>@92409oo`9g_@9>L`9oo`9:DP8aS0Aoo`8e
[Aeoo`40005oo`005Goo00<007ooOol02Woo0Ukg17oo0Ukg0T8@27oo0U:D0V]J0S6<0Re[0W_N0SW>
0S6<0TYB0SF]0QS60Re[0Sg_0Tic0TYB0Tic0RDY11240S6<0R480QBU0QcW0S6<1124124811240RDY
0QcW0QBU0QS610aS0PQ20QS60QcW0RU:0QcW0QBU0QcW0PaS0P@Q0Q240P@Q0R480PQ20P001@Q20PaS
0P@Q0Q240PaS0PQ20PaS0QBU0P@Q0QcW0P@Q0PQ20Q240QBU0QS60Q240PaS0P@Q0PQ21R480QBU0QcW
0SW>0P000RU:0P@Q0QcW0PaS0SF]0RDY0PaS0R480RDY0RU:0R480RU:0RDY0W>L0TYB0VLi0T8@0Woo
0WNm0Tic0Woo0TYB0S6<17oo0SF]7Goo0@000Goo000EOol00`00Oomoo`0<Ool2IcT<Ool25:D2<H`2
BU82F]H2E[D2?Nl2Kg/25:D2G_L2Ool2F]H2DY@2>Lh2HaP2Ool2:DX2?Nl2<H`2?Nl2@Q029BT2;F/2
7>L21242BU828@P29BT28@P2;F/25:D26<H27>L436<2124248@28@P45:D29BT2:DX27>L26<H236<2
8@P248@27>L2:DX248@200026<H00b4836<<H`026<H27>L2124248@2<H`2248248@26<H248@27>L2
6<H236<26<H25:D248@424829BT25:D26<H28@P2<H`2124236<26<H236<29BT26<H2:DX2>Lh21242
6<H29BT2@Q025:D2=Jd2?Nl2;F/25:D2DY@2BU86Ool2Nmh2Ool2IcTUOol10001Ool001Eoo`03001o
ogoo00aoo`9W>@aoo`8DY@8aS09:DP9JeP9F]@8mk`9_N`8DY@9Nm`9oo`9JeP9BU08icP9S609oo`8Y
BP8mk`8aS08mk`92408U:@8]J`8Li`848@9:DP8Q208U:@8Q208]J`8DY@8HaP8Li`@<H`848@8@Q08Q
20@DY@8U:@8YBP8Li`8HaP8<H`8Q208@Q08Li`8YBP8@Q080008HaP038@P<H`aS008HaP8Li`848@8@
Q08aS088@P8@Q08HaP8@Q08Li`8HaP8<H`8HaP8DY@8@Q0@8@P8U:@8DY@8HaP8Q208aS0848@8<H`8H
aP8<H`8U:@8HaP8YBP8icP848@8HaP8U:@92408DY@8e[@8mk`8]J`8DY@9BU09:DPIoo`9kgP9oo`9W
>BEoo`40005oo`005Goo00<007ooOol047oo0V<H1Woo0UJe17oo0QcW27oo0SF]0Woo0Tic17oo0SF]
0Woo0U[F17oo0QcW0U[F0Ukg0R480THa0QcW0Re[0Ukg0R480Sg_0R480Re[0S6<0QcW0SF]0PaS0R48
0Tic0P@Q0RDY0QBU0Re[0RU:0Q240RU:0QcW0PQ20Re[0RU:0RDY0PaS0QcW0R480QS600<U:AS66<H0
0QcW0Re[0R480QBU0PQ20RU:0Q240QcW0Sg_0PQ20RDY0SF]0RDY0QBU0QcW0SF]0RU:12DY0PQ20S6<
0SW>0Re[0PaS0THa0RDY0QcW0QS60QcW0Sg_0R480THa0TYB1QS60Woo1RDY0Tic0Woo0Ukg0TYB0U:D
0Q240Woo0SW>0Woo0W_N17oo0TYB6Goo0@000Goo000EOol2000AOol2HaP6Ool2E[D4Ool27>L8Ool2
=Jd2Ool2CW<4Ool2=Jd2Ool2F]H4Ool27>L2F]H2G_L28@P2AS427>L2;F/2G_L28@P2?Nl28@P2;F/2
<H`27>L2=Jd236<28@P2CW<212429BT25:D2;F/2:DX248@2:DX27>L22482;F/2:DX29BT236<27>L2
8@P26<H00bDY6<HHaP027>L2;F/28@P25:D22482:DX248@27>L2?Nl224829BT2=Jd29BT25:D27>L2
=Jd2:DX49BT22482<H`2>Lh2;F/236<2AS429BT27>L26<H27>L2?Nl28@P2AS42BU866<H2Ool69BT2
CW<2Ool2G_L2BU82DY@248@2Ool2>Lh2Ool2Nmh4Ool2BU8HOol20001Ool001Eoo`03001oogoo021o
o`9W>A1oo`9_N`9JeP9cW09_N`9>L`92408icP8<H`9JeP@U:@8]J`8@Q09240@Li`8Q208Li`8e[@8@
Q088@P8aS08YBP8DY@8YBP8HaP8YBP8HaP8YBP8HaP848@8e[@8@Q0@Li`8<H`8aS08@Q08YBP0336<@
Q124008U:@8HaP8Q208YBP8<H`@YBP8Q208HaP8Q208e[@8DY@8e[@8Li`8aS08]J`8DY@8Q208@Q08]
J`8YBP8HaP8Q20@Li`88@P8]J`8<H`92408YBP8Q208e[@8<H`9:DP92408e[@8DY@8@Q08]J`9oo`8m
k`8HaP96<@9kgP9W>@Yoo`9S61eoo`40005oo`005Goo00<007ooOol087oo0VLi47oo0Vmk0U[F0W>L
0Vmk0Tic0T8@0SW>0PaS0U[F12DY0Re[0Q240T8@11cW0R480QcW0SF]0Q240PQ20S6<0RU:0QBU0RU:
0QS60RU:0QS60RU:0QS60P@Q0SF]0Q2411cW0PaS0S6<0Q240RU:00<<Ha2448@00RDY0QS60R480RU:
0PaS12U:0R480QS60R480SF]0QBU0SF]0QcW0S6<0Re[0QBU0R480Q240Re[0RU:0QS60R4811cW0PQ2
0Re[0PaS0T8@0RU:0R480SF]0PaS0TYB0T8@0SF]0QBU0Q240Re[0Woo0Sg_0QS60THa0W_N0VLi2Woo
0V<H7Goo0@000Goo000EOol00`00Oomoo`0ZOol2Kg/8Ool2<H`2?Nl2CW<2<H`25:D2<H`4;F/25:D2
24827>L236<29BT28@P27>L236<28@P236<212425:D448@236<29BT28@P26<H248@27>L236<20002
7>L236<248@2248248@26<H248@27>L00`002488@P026<H224845:D2124448@224825:D224828@P2
12427>L248@400026<H236<25:D27>L200026<H25:D26<H25:D2=Jd436<25:D2000248@65:D2<H`2
6<H28@P2;F/2DY@2BU82@Q02CW<2HaP4Ool2?Nl2@Q06Ool2MkdMOol10001Ool001Eoo`03001oogoo
02Yoo`9_N`Qoo`8aS08mk`9>L`8aS08DY@8aS0@]J`8DY@88@P8Li`8<H`8U:@8Q208Li`8<H`8Q208<
H`848@8DY@@@Q08<H`8U:@8Q208HaP8@Q08Li`8<H`80008Li`8<H`8@Q088@P8@Q08HaP8@Q08Li`03
0008@PQ2008HaP88@P@DY@848@@@Q088@P8DY@88@P8Q20848@8Li`8@Q0@0008HaP8<H`8DY@8Li`80
008HaP8DY@8HaP8DY@8e[@@<H`8DY@80008@Q0HDY@8aS08HaP8Q208]J`9BU09:DP92409>L`9S60Ao
o`8mk`9240Ioo`9g_Aeoo`40005oo`005Goo00<007ooOol087oo0W_N27oo0SF]0Woo0V<H0Sg_0V]J
0Re[0Woo0V<H0RU:0T8@0U[F0TYB0Woo0QS60SW>0UJe0S6<0Woo12480UJe13g_0SF]0RDY0T8@0SF]
0S6<0Re[0S6<0THa0R480S6<14Ha0Re[0S6<0R480Tic0QS60SF]0T8@0SF]00<icSg_?Nl00RU:0Re[
0SW>0R480Sg_0S6<0Re[0SF]0Re[0THa0Sg_0RU:0SF]0Re[0Ukg0TYB0QS60THa0UJe0RU:0S6<0Re[
0TYB0SF]0SW>0RU:0Ukg0T8@0W_N0U[F0TYB0U:D0SF]17oo0R480Ukg0W>L0Woo0U:D0SF]0V<H0SW>
0Woo0VLi0UJe17oo0VLi8Goo0@000Goo000EOol00`00Oomoo`0POol2Nmh8Ool2=Jd2Ool2HaP2?Nl2
JeX2;F/2Ool2HaP2:DX2@Q02F]H2BU82Ool26<H2>Lh2E[D2<H`2Ool48@P2E[D4?Nl2=Jd29BT2@Q02
=Jd2<H`2;F/2<H`2AS428@P2<H`4AS42;F/2<H`28@P2CW<26<H2=Jd2@Q02=Jd00cW>?Nlmk`02:DX2
;F/2>Lh28@P2?Nl2<H`2;F/2=Jd2;F/2AS42?Nl2:DX2=Jd2;F/2G_L2BU826<H2AS42E[D2:DX2<H`2
;F/2BU82=Jd2>Lh2:DX2G_L2@Q02Nmh2F]H2BU82DY@2=Jd4Ool28@P2G_L2Li`2Ool2DY@2=Jd2HaP2
>Lh2Ool2IcT2E[D4Ool2IcTQOol10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<0
07ooOol0ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol0
0`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol1
0001Ool001Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Compression",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(n = 128;\)\)], "Input"],

Cell[TextData[StyleBox["nPrime=32;\n\
cut=TakeMatrix[FourierSample,{1,1},{32,32}];\n\
compressedfSpec=BlockMatrix[{{cut,ZeroMatrix[nPrime,n-nPrime]},{ZeroMatrix[n-\
nPrime,n]}}];",
  FontSize->14]], "Input",
  PageBreakWithin->Automatic,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[cut], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0300481 0.0192308 0.0300481 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -3 -9 ]
[.16947 -0.0125 3 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -6 -9 ]
[.77043 -0.0125 6 0 ]
[.92067 -0.0125 -6 -9 ]
[.92067 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -6 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -12 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -12 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(5)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(10)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(15)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(20)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(25)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(30)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.04928 0 m
.04928 .00375 L
s
.07933 0 m
.07933 .00375 L
s
.10937 0 m
.10937 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.22957 0 m
.22957 .00375 L
s
.25962 0 m
.25962 .00375 L
s
.28966 0 m
.28966 .00375 L
s
.34976 0 m
.34976 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.40986 0 m
.40986 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5 0 m
.5 .00375 L
s
.53005 0 m
.53005 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.59014 0 m
.59014 .00375 L
s
.65024 0 m
.65024 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.71034 0 m
.71034 .00375 L
s
.74038 0 m
.74038 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.83053 0 m
.83053 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.89063 0 m
.89063 .00375 L
s
.95072 0 m
.95072 .00375 L
s
.98077 0 m
.98077 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(5)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(10)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(15)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(20)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(25)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(30)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .04928 m
.00375 .04928 L
s
0 .07933 m
.00375 .07933 L
s
0 .10937 m
.00375 .10937 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .22957 m
.00375 .22957 L
s
0 .25962 m
.00375 .25962 L
s
0 .28966 m
.00375 .28966 L
s
0 .34976 m
.00375 .34976 L
s
0 .37981 m
.00375 .37981 L
s
0 .40986 m
.00375 .40986 L
s
0 .4399 m
.00375 .4399 L
s
0 .5 m
.00375 .5 L
s
0 .53005 m
.00375 .53005 L
s
0 .5601 m
.00375 .5601 L
s
0 .59014 m
.00375 .59014 L
s
0 .65024 m
.00375 .65024 L
s
0 .68029 m
.00375 .68029 L
s
0 .71034 m
.00375 .71034 L
s
0 .74038 m
.00375 .74038 L
s
0 .80048 m
.00375 .80048 L
s
0 .83053 m
.00375 .83053 L
s
0 .86058 m
.00375 .86058 L
s
0 .89063 m
.00375 .89063 L
s
0 .95072 m
.00375 .95072 L
s
0 .98077 m
.00375 .98077 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.04928 .99625 m
.04928 1 L
s
.07933 .99625 m
.07933 1 L
s
.10937 .99625 m
.10937 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.22957 .99625 m
.22957 1 L
s
.25962 .99625 m
.25962 1 L
s
.28966 .99625 m
.28966 1 L
s
.34976 .99625 m
.34976 1 L
s
.37981 .99625 m
.37981 1 L
s
.40986 .99625 m
.40986 1 L
s
.4399 .99625 m
.4399 1 L
s
.5 .99625 m
.5 1 L
s
.53005 .99625 m
.53005 1 L
s
.5601 .99625 m
.5601 1 L
s
.59014 .99625 m
.59014 1 L
s
.65024 .99625 m
.65024 1 L
s
.68029 .99625 m
.68029 1 L
s
.71034 .99625 m
.71034 1 L
s
.74038 .99625 m
.74038 1 L
s
.80048 .99625 m
.80048 1 L
s
.83053 .99625 m
.83053 1 L
s
.86058 .99625 m
.86058 1 L
s
.89063 .99625 m
.89063 1 L
s
.95072 .99625 m
.95072 1 L
s
.98077 .99625 m
.98077 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .04928 m
1 .04928 L
s
.99625 .07933 m
1 .07933 L
s
.99625 .10937 m
1 .10937 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .22957 m
1 .22957 L
s
.99625 .25962 m
1 .25962 L
s
.99625 .28966 m
1 .28966 L
s
.99625 .34976 m
1 .34976 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .40986 m
1 .40986 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5 m
1 .5 L
s
.99625 .53005 m
1 .53005 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .59014 m
1 .59014 L
s
.99625 .65024 m
1 .65024 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .71034 m
1 .71034 L
s
.99625 .74038 m
1 .74038 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .83053 m
1 .83053 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .89063 m
1 .89063 L
s
.99625 .95072 m
1 .95072 L
s
.99625 .98077 m
1 .98077 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
32 string
32 32 8 [32 0 0 32 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage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P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`004goo0P009goo0P008goo1@000Woo0P007goo1@000Woo0P0087oo10000goo0P00
87oo10000goo0P008Goo0P0017oo0P004goo000BOol01000Oomoo`009Goo00@007ooOol002Aoo`05
001oogooOol00002Ool00`00Oomoo`0NOol01@00Oomoogoo00000Woo00<007ooOol07Goo00<007oo
Ool00goo00@007ooOol001moo`03001oogoo00=oo`04001oogoo000OOol01000Oomoo`000Woo00@0
07ooOol0019oo`004Woo00@007ooOol002Qoo`03001oogoo029oo`05001oogooOol00002Ool00`00
Oomoo`0NOol00`00Oomoo`04Ool00`00Oomoo`0NOol00`00Oomoo`02Ool01000Oomoo`0087oo00<0
07ooOol01Goo00<007ooOol07goo00D007ooOomoo`00009oo`03001oogoo011oo`004Woo00@007oo
Ool002Ioo`8002Eoo`05001oogooOol00002Ool00`00Oomoo`0NOol00`00Oomoo`02Ool2000ROol0
1@00Oomoogoo00000Woo00<007ooOol07goo00<007ooOol00Woo0P008goo00@007ooOol0009oo`03
001oogoo011oo`004Woo00@007ooOol002Ioo`03001oogoo02Aoo`05001oogooOol00002Ool00`00
Oomoo`0NOol00`00Oomoo`02Ool00`00Oomoo`0OOol01000Oomoo`000Woo00@007ooOol001moo`04
001oogoo0003Ool00`00Oomoo`0OOol01000Oomoo`000Woo00@007ooOol0019oo`004goo0P009goo
0`008goo0P0017oo0P0087oo0P0017oo0`0087oo0P0017oo0P008Goo0P0017oo0`0087oo0P0017oo
0P004goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`003gooo`004@000Goo
000?Ool00`00Oomoo`02Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`02Ool10001Ool0
00moo`03001oogoo009oo`03001oogoo02Ioo`03001oogoo02Ioo`03001oogoo02Eoo`03001oogoo
02Ioo`03001oogoo02Ioo`03001oogoo02Ioo`03001oogoo019oo`40005oo`003goo00<007ooOol0
ogoo3Goo0@000Goo0008Ool20005Ool00`00Oomoo`3oOol=Ool10001Ool000Moo`04001oogoo0004
Ool00`00Oomoo`3oOol=Ool10001Ool000Moo`04001oogoo0004Ool3003oOol<Ool20001Ool000Mo
o`04001oogoo0004Ool00`00Oomoo`02Ooooool7ool4Ool10001Ool000Moo`04001oogoo0004Ool0
0`00Oomoo`02Ooooool7ool4Ool10001Ool000Qoo`8000Eoo`03001oogoo009oooooo`Ooo`Aoo`40
005oo`003goo00<007ooOol00Woooooo1ooo17oo0@000Goo000?Ool00`00Oomoo`02Ooooool7ool4
Ool10001Ool000moo`03001oogoo009oooooo`Ooo`Aoo`40005oo`003goo00<007ooOol00Woooooo
1ooo17oo0@000Goo000?Ool20003Ooooool7ool3Ool20001Ool000moo`03001oogoo009oocWoo`Te
[@Q[FPQcW0P]J`PaS0TQ20PicPPLi`P@Q0P]J`PDY@T<H`P@Q0PQ20P8@PP@Q0T8@PP<Ha0DY@P@Q0T4
8@PDY@PHaPP8@PAoo`40005oo`003goo00<007ooOol00Woo>Ooo2CF]26]J27>L22e[236<2B4823W>
21cW212422e[21BU2@aS2124224820Q221242@Q220aS41BU21242@@Q21BU21S620Q217oo0@000Goo
000?Ool00`00Oomoo`02Ooliool9=Jd8JeX8Li`8;F/8<H`98@P8>Lh87>L848@8;F/85:D936<848@8
8@P8248848@9248836<@5:D848@912485:D86<H82484Ool10001Ool000moo`03001oogoo009oocWo
o`Te[@Q[FPQcW0P]J`PaS0TQ20PicPPLi`P@Q0P]J`PDY@T<H`P@Q0PQ20P8@PP@Q0T8@PP<Ha0DY@P@
Q0T48@PDY@PHaPP8@PAoo`40005oo`003goo00<007ooOol00Woo>Ooo2CF]26]J27>L22e[236<2B48
23W>21cW212422e[21BU2@aS2124224820Q221242@Q220aS41BU21242@@Q21BU21S620Q217oo0@00
0Goo000?Ool00`00Oomoo`02Ooliool9=Jd8JeX8Li`8;F/8<H`98@P8>Lh87>L848@8;F/85:D936<8
48@88@P8248848@9248836<@5:D848@912485:D86<H82484Ool10001Ool000moo`03001oogoo009o
ocWoo`Te[@Q[FPQcW0P]J`PaS0TQ20PicPPLi`P@Q0P]J`PDY@T<H`P@Q0PQ20P8@PP@Q0T8@PP<Ha0D
Y@P@Q0T48@PDY@PHaPP8@PAoo`40005oo`003goo0P000goo>Ooo2CF]26]J27>L22e[236<2B4823W>
21cW212422e[21BU2@aS2124224820Q221242@Q220aS41BU21242@@Q21BU21S620Q20goo0P000Goo
000?Ool00`00Oomoo`02Ooliool9JeX8F]H8?Nl88@P8AS49@Q085:D86<H8>Lh88@PA24887>L86<H8
48@836<9248@36<8248A1248248800081244Ool10001Ool000moo`03001oogoo009oocWoo`U[FPQJ
ePPmk`PQ20Q6<@U240PDY@PHaPPicPPQ2148@PPLi`PHaPP@Q0P<H`T8@Q0<H`P8@Q448@P8@PP000P4
8@Aoo`40005oo`003goo00<007ooOol00Woo>Ooo2F]J25[F23g_224824Ha2D8@21BU21S623W>2248
4@Q221cW21S6212420aS2@Q240aS20Q24@@Q20Q2200020@Q17oo0@000Goo000?Ool00`00Oomoo`02
Ooliool9JeX8F]H8?Nl88@P8AS49@Q085:D86<H8>Lh88@PA24887>L86<H848@836<9248@36<8248A
1248248800081244Ool10001Ool000moo`03001oogoo009oocWoo`U[FPQJePPmk`PQ20Q6<@U240PD
Y@PHaPPicPPQ2148@PPLi`PHaPP@Q0P<H`T8@Q0<H`P8@Q448@P8@PP000P48@Aoo`40005oo`003goo
00<007ooOol00Woo>Ooo2F]J25[F23g_224824Ha2D8@21BU21S623W>22484@Q221cW21S6212420aS
2@Q240aS20Q24@@Q20Q2200020@Q17oo0@000Goo000?Ool00`00Oomoo`02Ooliool9JeX8F]H8?Nl8
8@P8AS49@Q085:D86<H8>Lh88@PA24887>L86<H848@836<9248@36<8248A1248248800081244Ool1
0001Ool000moo`8000=oocWoo`U[FPQJePPmk`PQ20Q6<@U240PDY@PHaPPicPPQ2148@PPLi`PHaPP@
Q0P<H`T8@Q0<H`P8@Q448@P8@PP000P48@=oo`80005oo`003goo00<007ooOol00Woo25kg>_oo26Li
25Je43g_2B482124248@21cW42DY2BU:212421BU20aS20@Q2@Q221S620Q240004@Q220aS200017oo
0@000Goo000?Ool00`00Oomoo`02Ool8G_Ljool8IcT8E[D@?Nl98@P848@8@Q087>L@9BT9:DX848@8
5:D836<8124924886<H8248@000A248836<80004Ool10001Ool000moo`03001oogoo009oo`QNmc[o
o`QW>@QF]A0mk`TQ20P@Q0Q240PLia0U:@TYBPP@Q0PDY@P<H`P48@T8@PPHaPP8@Q000148@PP<H`P0
00Aoo`40005oo`003goo00<007ooOol00Woo25kg>_oo26Li25Je43g_2B482124248@21cW42DY2BU:
212421BU20aS20@Q2@Q221S620Q240004@Q220aS200017oo0@000Goo000?Ool00`00Oomoo`02Ool8
G_Ljool8IcT8E[D@?Nl98@P848@8@Q087>L@9BT9:DX848@85:D836<8124924886<H8248@000A2488
36<80004Ool10001Ool000moo`03001oogoo009oo`QNmc[oo`QW>@QF]A0mk`TQ20P@Q0Q240PLia0U
:@TYBPP@Q0PDY@P<H`P48@T8@PPHaPP8@Q000148@PP<H`P000Aoo`40005oo`003goo00<007ooOol0
0Woo25kg>_oo26Li25Je43g_2B482124248@21cW42DY2BU:212421BU20aS20@Q2@Q221S620Q24000
4@Q220aS200017oo0@000Goo000?Ool20003Ool8G_Ljool8IcT8E[D@?Nl98@P848@8@Q087>L@9BT9
:DX848@85:D836<8124924886<H8248@000A248836<80003Ool20001Ool000moo`03001oogoo009o
oc7oo`QW>@Woo`QBU0Q>L`QJePP<H`TU:@PaS0PDY@PQ20P8@PPYBPT0010<H`P@Q0PLi`T<HaP48@PL
iaT48@P<H`Aoo`40005oo`003goo00<007ooOol00Woo<Ooo26Li2Ooo25:D24ic25[F20aS2BDY236<
21BU224820Q222U:2@0040aS212421cW2@aS60@Q21cW6@@Q20aS17oo0@000Goo000?Ool00`00Oomo
o`02Oolaool8IcT9ool8DY@8CW<8F]H836<99BT8<H`85:D88@P82488:DX9000@36<848@87>L936<H
12487>LI124836<4Ool10001Ool000moo`03001oogoo009ooc7oo`QW>@Woo`QBU0Q>L`QJePP<H`TU
:@PaS0PDY@PQ20P8@PPYBPT0010<H`P@Q0PLi`T<HaP48@PLiaT48@P<H`Aoo`40005oo`003goo00<0
07ooOol00Woo<Ooo26Li2Ooo25:D24ic25[F20aS2BDY236<21BU224820Q222U:2@0040aS212421cW
2@aS60@Q21cW6@@Q20aS17oo0@000Goo0008Ool20005Ool00`00Oomoo`02Oolaool8IcT9ool8DY@8
CW<8F]H836<99BT8<H`85:D88@P82488:DX9000@36<848@87>L936<H12487>LI124836<4Ool10001
Ool000Moo`04001oogoo0004Ool00`00Oomoo`02Oolaool8IcT9ool8DY@8CW<8F]H836<99BT8<H`8
5:D88@P82488:DX9000@36<848@87>L936<H12487>LI124836<4Ool10001Ool000Yoo`03001oogoo
009oo`<0009ooc7oo`QW>@Woo`QBU0Q>L`QJePP<H`TU:@PaS0PDY@PQ20P8@PPYBPT0010<H`P@Q0PL
i`T<HaP48@PLiaT48@P<H`=oo`80005oo`0027oo0P001Goo00<007ooOol00Woo@_oo24Ha44YB22U:
2Cg_23W>21S6424821242BU:21BU21S6224821cW4@aS20006@Q2200020aS20@Q17oo0@000Goo0008
Ool00`00Oomoo`04Ool00`00Oomoo`02Oom2ool8AS4@BU88:DX9?Nl8>Lh86<H@8@P848@9:DX85:D8
6<H88@P87>LA36<8000I2488000836<81244Ool10001Ool000Qoo`<000Aoo`03001oogoo009ood;o
o`Q6<A1:DPPYBPTmk`PicPPHaQ0Q20P@Q0TYBPPDY@PHaPPQ20PLia4<H`P001T8@PP000P<H`P48@Ao
o`40005oo`003goo00<007ooOol00Woo@_oo24Ha44YB22U:2Cg_23W>21S6424821242BU:21BU21S6
224821cW4@aS20006@Q2200020aS20@Q17oo0@000Goo000?Ool00`00Oomoo`02Oom2ool8AS4@BU88
:DX9?Nl8>Lh86<H@8@P848@9:DX85:D86<H88@P87>LA36<8000I2488000836<81244Ool10001Ool0
00moo`03001oogoo009ood;oo`Q6<A1:DPPYBPTmk`PicPPHaQ0Q20P@Q0TYBPPDY@PHaPPQ20PLia4<
H`P001T8@PP000P<H`P48@Aoo`40005oo`003goo00<007ooOol00Woo@_oo24Ha44YB22U:2Cg_23W>
21S6424821242BU:21BU21S6224821cW4@aS20006@Q2200020aS20@Q17oo0@000Goo000?Ool00`00
Oomoo`02Oom2ool8AS4@BU88:DX9?Nl8>Lh86<H@8@P848@9:DX85:D86<H88@P87>LA36<8000I2488
000836<81244Ool10001Ool000moo`8000=oo`Qg_AWoo`QBU0Soo`Q_N`Woo`PaS0Soo`Q240Pe[@U6
<@P8@PPaS0P]J`P8@PP<H`THaPP<Ha0DY@P8@PT@Q0P<H`PDYC448@=oo`80005oo`003goo00<007oo
Ool00Woo27Nm6Ooo25:D2?oo26mk2Ooo236<2?oo248@23F]2DHa20Q2236<22e[20Q220aS2AS620aS
41BU20Q22A2420aS21BU<@@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool8MkdIool8DY@8ool8Kg/9
ool8<H`8ool8@Q08=Jd9AS482488<H`8;F/8248836<96<H836<@5:D8248948@836<85:Da1244Ool1
0001Ool000moo`03001oogoo009oo`Qg_AWoo`QBU0Soo`Q_N`Woo`PaS0Soo`Q240Pe[@U6<@P8@PPa
S0P]J`P8@PP<H`THaPP<Ha0DY@P8@PT@Q0P<H`PDYC448@Aoo`40005oo`003goo00<007ooOol00Woo
27Nm6Ooo25:D2?oo26mk2Ooo236<2?oo248@23F]2DHa20Q2236<22e[20Q220aS2AS620aS41BU20Q2
2A2420aS21BU<@@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool8MkdIool8DY@8ool8Kg/9ool8<H`8
ool8@Q08=Jd9AS482488<H`8;F/8248836<96<H836<@5:D8248948@836<85:Da1244Ool10001Ool0
00moo`03001oogoo009oo`Qg_AWoo`QBU0Soo`Q_N`Woo`PaS0Soo`Q240Pe[@U6<@P8@PPaS0P]J`P8
@PP<H`THaPP<Ha0DY@P8@PT@Q0P<H`PDYC448@Aoo`40005oo`003goo00<007ooOol00Woo27Nm6Ooo
25:D2?oo26mk2Ooo236<2?oo248@23F]2DHa20Q2236<22e[20Q220aS2AS620aS41BU20Q22A2420aS
21BU<@@Q17oo0@000Goo000?Ool20003Ool8MkdIool8DY@8ool8Kg/9ool8<H`8ool8@Q08=Jd9AS48
2488<H`8;F/8248836<96<H836<@5:D8248948@836<85:Da1243Ool20001Ool000moo`03001oogoo
009oo`PHaPSoo`TaS0PHaPQW>@Soo`QBU0Woo`PaS0Q:DPPe[@QNm`Te[@PaS0Q240P000PQ20PLi`T]
Ja0HaPPQ20P@Q0TDY@PHaPP48@P<Ha48@PP@Q0P8@PP48@Aoo`40005oo`003goo00<007ooOol00Woo
21S62?oo2C6<21S626Li2?oo25:D2Ooo236<24YB23F]25kg2CF]236<248@2000224821cW2Be[41S6
224821242ABU21S620@Q20aS4@Q2212420Q220@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool86<H8
ool9<H`86<H8IcT8ool8DY@9ool8<H`8BU88=Jd8G_L9=Jd8<H`8@Q0800088@P87>L9;F/@6<H88@P8
48@95:D86<H8124836<A248848@824881244Ool10001Ool000moo`03001oogoo009oo`PHaPSoo`Ta
S0PHaPQW>@Soo`QBU0Woo`PaS0Q:DPPe[@QNm`Te[@PaS0Q240P000PQ20PLi`T]Ja0HaPPQ20P@Q0TD
Y@PHaPP48@P<Ha48@PP@Q0P8@PP48@Aoo`40005oo`003goo00<007ooOol00Woo21S62?oo2C6<21S6
26Li2?oo25:D2Ooo236<24YB23F]25kg2CF]236<248@2000224821cW2Be[41S6224821242ABU21S6
20@Q20aS4@Q2212420Q220@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool86<H8ool9<H`86<H8IcT8
ool8DY@9ool8<H`8BU88=Jd8G_L9=Jd8<H`8@Q0800088@P87>L9;F/@6<H88@P848@95:D86<H81248
36<A248848@824881244Ool10001Ool000moo`03001oogoo009oo`PHaPSoo`TaS0PHaPQW>@Soo`QB
U0Woo`PaS0Q:DPPe[@QNm`Te[@PaS0Q240P000PQ20PLi`T]Ja0HaPPQ20P@Q0TDY@PHaPP48@P<Ha48
@PP@Q0P8@PP48@Aoo`40005oo`003goo0P000goo21S62?oo2C6<21S626Li2?oo25:D2Ooo236<24YB
23F]25kg2CF]236<248@2000224821cW2Be[41S6224821242ABU21S620@Q20aS4@Q2212420Q220@Q
0goo0P000Goo000?Ool00`00Oomoo`02Ool8>Lh8oolADY@8ool8JeX8@Q09Li`8<H`8F]H8>Lh8HaP9
8@P8?Nl8<H`824889BT8:DX9248848@85:D824886<H936<8124836<848@86<H948@8248812482484
Ool10001Ool000moo`03001oogoo009oo`PicPSooa5BU0Soo`Q[FPQ240UcW0PaS0QJePPicPQS60TQ
20Pmk`PaS0P8@PPU:@PYBPT8@PP@Q0PDY@P8@PPHaPT<H`P48@P<H`P@Q0PHaPT@Q0P8@PP48@P8@PAo
o`40005oo`003goo00<007ooOol00Woo23W>2?oo4E:D2?oo26]J248@2G>L236<25[F23W>26<H2B48
23g_236<20Q222DY22U:2@Q2212421BU20Q221S62@aS20@Q20aS212421S62A2420Q220@Q20Q217oo
0@000Goo000?Ool00`00Oomoo`02Ool8>Lh8oolADY@8ool8JeX8@Q09Li`8<H`8F]H8>Lh8HaP98@P8
?Nl8<H`824889BT8:DX9248848@85:D824886<H936<8124836<848@86<H948@8248812482484Ool1
0001Ool000moo`03001oogoo009oo`PicPSooa5BU0Soo`Q[FPQ240UcW0PaS0QJePPicPQS60TQ20Pm
k`PaS0P8@PPU:@PYBPT8@PP@Q0PDY@P8@PPHaPT<H`P48@P<H`P@Q0PHaPT@Q0P8@PP48@P8@PAoo`40
005oo`003goo00<007ooOol00Woo23W>2?oo4E:D2?oo26]J248@2G>L236<25[F23W>26<H2B4823g_
236<20Q222DY22U:2@Q2212421BU20Q221S62@aS20@Q20aS212421S62A2420Q220@Q20Q217oo0@00
0Goo000?Ool00`00Oomoo`02Ool8>Lh8oolADY@8ool8JeX8@Q09Li`8<H`8F]H8>Lh8HaP98@P8?Nl8
<H`824889BT8:DX9248848@85:D824886<H936<8124836<848@86<H948@8248812482484Ool10001
Ool000moo`8000=oo`PicPSooa5BU0Soo`Q[FPQ240UcW0PaS0QJePPicPQS60TQ20Pmk`PaS0P8@PPU
:@PYBPT8@PP@Q0PDY@P8@PPHaPT<H`P48@P<H`P@Q0PHaPT@Q0P8@PP48@P8@P=oo`80005oo`003goo
00<007ooOol00Woo25:D2?oo4G>L2?oo22e[4D8@22e[25:D21cW23F]2@00248@224822U:23F]20Q2
4AS6212421S621cW4@Q221BU21244@Q220@Q20Q220aS17oo0@000Goo000?Ool00`00Oomoo`02Ool8
DY@8oolALi`8ool8;F/A@Q08;F/8DY@87>L8=Jd90008@Q088@P8:DX8=Jd8248A6<H848@86<H87>LA
24885:D848@A24881248248836<4Ool10001Ool000moo`03001oogoo009oo`QBU0Sooa5cW0Soo`P]
Ja5240P]J`QBU0PLi`Pe[@T000Q240PQ20PYBPPe[@P8@Q4HaPP@Q0PHaPPLia48@PPDY@P@Q148@PP4
8@P8@PP<H`Aoo`40005oo`003goo00<007ooOol00Woo25:D2?oo4G>L2?oo22e[4D8@22e[25:D21cW
23F]2@00248@224822U:23F]20Q24AS6212421S621cW4@Q221BU21244@Q220@Q20Q220aS17oo0@00
0Goo000?Ool00`00Oomoo`02Ool8DY@8oolALi`8ool8;F/A@Q08;F/8DY@87>L8=Jd90008@Q088@P8
:DX8=Jd8248A6<H848@86<H87>LA24885:D848@A24881248248836<4Ool10001Ool00003Ool00000
00<0009oo`8000Eoo`03001oogoo009oo`QBU0Sooa5cW0Soo`P]Ja5240P]J`QBU0PLi`Pe[@T000Q2
40PQ20PYBPPe[@P8@Q4HaPP@Q0PHaPPLia48@PPDY@P@Q148@PP48@P8@PP<H`Aoo`40005oo`000goo
00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo009oo`QBU0Sooa5cW0Soo`P]Ja5240P]
J`QBU0PLi`Pe[@T000Q240PQ20PYBPPe[@P8@Q4HaPP@Q0PHaPPLia48@PPDY@P@Q148@PP48@P8@PP<
H`Aoo`40005oo`000goo00D007ooOomoo`00009oo`03001oogoo009oo`<0009oo`QBU0Sooa5cW0So
o`P]Ja5240P]J`QBU0PLi`Pe[@T000Q240PQ20PYBPPe[@P8@Q4HaPP@Q0PHaPPLia48@PPDY@P@Q148
@PP48@P8@PP<H`=oo`80005oo`000goo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo
009oo`QNm`Soo`U[FPQg_@P]J`PDY@PicPTe[@Q6<@Q>L`P]J`PaS0T8@PQ240P@Q10Q20P8@PTU:@PQ
210DY@P<H`T48A0<H`P8@PP<H`T@Q0P000P@Q0P8@PAoo`40005oo`000goo00D007ooOomoo`00009o
o`03001oogoo009oo`03001oogoo009oo`QNm`Soo`U[FPQg_@P]J`PDY@PicPTe[@Q6<@Q>L`P]J`Pa
S0T8@PQ240P@Q10Q20P8@PTU:@PQ210DY@P<H`T48A0<H`P8@PP<H`T@Q0P000P@Q0P8@PAoo`40005o
o`000Woo0P0017oo0P001Goo00<007ooOol00Woo25kg2?oo2F]J27Nm22e[21BU23W>2CF]24Ha24ic
22e[236<2@Q2248@2124424820Q22BDY224841BU20aS2@@Q40aS20Q220aS2A242000212420Q217oo
0@000Goo000?Ool00`00Oomoo`02Ool8G_L8ool9JeX8Mkd8;F/85:D8>Lh9=Jd8AS48CW<8;F/8<H`9
2488@Q0848@@8@P824899BT88@P@5:D836<9124@36<8248836<948@8000848@82484Ool10001Ool0
00moo`03001oogoo009oo`QNm`Soo`U[FPQg_@P]J`PDY@PicPTe[@Q6<@Q>L`P]J`PaS0T8@PQ240P@
Q10Q20P8@PTU:@PQ210DY@P<H`T48A0<H`P8@PP<H`T@Q0P000P@Q0P8@PAoo`40005oo`003goo00<0
07ooOol00Woo25kg2?oo2F]J27Nm22e[21BU23W>2CF]24Ha24ic22e[236<2@Q2248@2124424820Q2
2BDY224841BU20aS2@@Q40aS20Q220aS2A242000212420Q217oo0@000Goo000?Ool00`00Oomoo`02
Ool8G_L8ool9JeX8Mkd8;F/85:D8>Lh9=Jd8AS48CW<8;F/8<H`92488@Q0848@@8@P824899BT88@P@
5:D836<9124@36<8248836<948@8000848@82484Ool10001Ool000moo`8000=oo`QNm`Soo`U[FPQg
_@P]J`PDY@PicPTe[@Q6<@Q>L`P]J`PaS0T8@PQ240P@Q10Q20P8@PTU:@PQ210DY@P<H`T48A0<H`P8
@PP<H`T@Q0P000P@Q0P8@P=oo`80005oo`003goo00<007ooOol00Woo23g_2?oo2CW>23F]2000236<
23F]2Be[25Je23W>236<23W>2ABU24Ha224822U:41cW2BDY20Q220aS20@Q20Q22ABU20Q220@Q2124
4@aS60@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool8?Nl8ool9>Lh8=Jd80008<H`8=Jd9;F/8E[D8
>Lh8<H`8>Lh95:D8AS488@P8:DX@7>L99BT8248836<8124824895:D82488124848@A36<H1244Ool1
0001Ool000moo`03001oogoo009oo`Pmk`Soo`TicPPe[@P000PaS0Pe[@T]J`QF]@PicPPaS0PicPTD
Y@Q6<@PQ20PYBQ0Li`TU:@P8@PP<H`P48@P8@PTDY@P8@PP48@P@Q14<HaP48@Aoo`40005oo`003goo
00<007ooOol00Woo23g_2?oo2CW>23F]2000236<23F]2Be[25Je23W>236<23W>2ABU24Ha224822U:
41cW2BDY20Q220aS20@Q20Q22ABU20Q220@Q21244@aS60@Q17oo0@000Goo000?Ool00`00Oomoo`02
Ool8?Nl8ool9>Lh8=Jd80008<H`8=Jd9;F/8E[D8>Lh8<H`8>Lh95:D8AS488@P8:DX@7>L99BT82488
36<8124824895:D82488124848@A36<H1244Ool10001Ool000moo`03001oogoo009oo`Pmk`Soo`Ti
cPPe[@P000PaS0Pe[@T]J`QF]@PicPPaS0PicPTDY@Q6<@PQ20PYBQ0Li`TU:@P8@PP<H`P48@P8@PTD
Y@P8@PP48@P@Q14<HaP48@Aoo`40005oo`003goo00<007ooOol00Woo23g_2?oo2CW>23F]2000236<
23F]2Be[25Je23W>236<23W>2ABU24Ha224822U:41cW2BDY20Q220aS20@Q20Q22ABU20Q220@Q2124
4@aS60@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool8?Nl8ool9>Lh8=Jd80008<H`8=Jd9;F/8E[D8
>Lh8<H`8>Lh95:D8AS488@P8:DX@7>L99BT8248836<8124824895:D82488124848@A36<H1244Ool1
0001Ool000moo`8000=oo`PU:@Soo`T8@PP000Q240PaS0P]J`TicPQ:DPP]J`PYBPPaS0T<H`Pe[@P@
Q0P]J`PDY@PHaPTLi`P000P8@PP<H`PDY@T8@PP000P48@P8@PP48@T<HaP48@=oo`80005oo`003goo
00<007ooOol00Woo22DY2?oo2@Q22000248@236<22e[2CW>24YB22e[22U:236<2@aS23F]212422e[
21BU21S62AcW200020Q220aS21BU2@Q2200020@Q20Q220@Q2@aS60@Q17oo0@000Goo000?Ool00`00
Oomoo`02Ool89BT8ool924880008@Q08<H`8;F/9>Lh8BU88;F/8:DX8<H`936<8=Jd848@8;F/85:D8
6<H97>L80008248836<85:D92488000812482488124936<H1244Ool10001Ool000moo`03001oogoo
009oo`PU:@Soo`T8@PP000Q240PaS0P]J`TicPQ:DPP]J`PYBPPaS0T<H`Pe[@P@Q0P]J`PDY@PHaPTL
i`P000P8@PP<H`PDY@T8@PP000P48@P8@PP48@T<HaP48@Aoo`40005oo`003goo00<007ooOol00Woo
22DY2?oo2@Q22000248@236<22e[2CW>24YB22e[22U:236<2@aS23F]212422e[21BU21S62AcW2000
20Q220aS21BU2@Q2200020@Q20Q220@Q2@aS60@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool89BT8
ool924880008@Q08<H`8;F/9>Lh8BU88;F/8:DX8<H`936<8=Jd848@8;F/85:D86<H97>L800082488
36<85:D92488000812482488124936<H1244Ool10001Ool000moo`03001oogoo009oo`PU:@Soo`T8
@PP000Q240PaS0P]J`TicPQ:DPP]J`PYBPPaS0T<H`Pe[@P@Q0P]J`PDY@PHaPTLi`P000P8@PP<H`PD
Y@T8@PP000P48@P8@PP48@T<HaP48@Aoo`40005oo`003goo00<007ooOol00Woo22DY2?oo2@Q22000
248@236<22e[2CW>24YB22e[22U:236<2@aS23F]212422e[21BU21S62AcW200020Q220aS21BU2@Q2
200020@Q20Q220@Q2@aS60@Q17oo0@000Goo000?Ool20003Ool89BT8Li`9>Lh8;F/8E[D89BT836<9
;F/8?Nl8:DX8=Jd8<H`96<H8:DX836<8;F/@6<H97>L836<85:D@36<92488124848@8000A12482488
12480003Ool20001Ool000moo`03001oogoo009oo`PU:@QcW0TicPP]J`QF]@PU:@P<H`T]J`Pmk`PY
BPPe[@PaS0THaPPYBPP<H`P]Ja0HaPTLi`P<H`PDYA0<H`T8@PP48@P@Q0P001448@P8@PP48@P000Ao
o`40005oo`003goo00<007ooOol00Woo22DY27>L2CW>22e[25Je22DY20aS2Be[23g_22U:23F]236<
2AS622U:20aS22e[41S62AcW20aS21BU40aS2@Q220@Q212420004@@Q20Q220@Q200017oo0@000Goo
000?Ool00`00Oomoo`02Ool89BT8Li`9>Lh8;F/8E[D89BT836<9;F/8?Nl8:DX8=Jd8<H`96<H8:DX8
36<8;F/@6<H97>L836<85:D@36<92488124848@8000A1248248812480004Ool10001Ool000moo`03
001oogoo009oo`PU:@QcW0TicPP]J`QF]@PU:@P<H`T]J`Pmk`PYBPPe[@PaS0THaPPYBPP<H`P]Ja0H
aPTLi`P<H`PDYA0<H`T8@PP48@P@Q0P001448@P8@PP48@P000Aoo`40005oo`003goo00<007ooOol0
0Woo22DY27>L2CW>22e[25Je22DY20aS2Be[23g_22U:23F]236<2AS622U:20aS22e[41S62AcW20aS
21BU40aS2@Q220@Q212420004@@Q20Q220@Q200017oo0@000Goo000?Ool00`00Oomoo`02Ool89BT8
Li`9>Lh8;F/8E[D89BT836<9;F/8?Nl8:DX8=Jd8<H`96<H8:DX836<8;F/@6<H97>L836<85:D@36<9
2488124848@8000A1248248812480004Ool10001Ool000moo`03001oogoo009oo`PU:@QcW0TicPP]
J`QF]@PU:@P<H`T]J`Pmk`PYBPPe[@PaS0THaPPYBPP<H`P]Ja0HaPTLi`P<H`PDYA0<H`T8@PP48@P@
Q0P001448@P8@PP48@P000Aoo`40005oo`003goo0P000goo22U:27Nm2DYB23W>23g_21S621242BDY
20Q221cW236<6BU:20Q221S641cW2ABU20aS21S620aS4@@Q212420@Q20aS20004@Q240000goo0P00
0Goo000?Ool00`00Oomoo`02Ool8:DX8Mkd9BU88>Lh8?Nl86<H848@99BT824887>L8<H`I:DX82488
6<H@7>L95:D836<86<H836<A124848@8124836<8000A248@0004Ool10001Ool000moo`03001oogoo
009oo`PYBPQg_@U:DPPicPPmk`PHaPP@Q0TU:@P8@PPLi`PaS1TYBPP8@PPHaQ0Li`TDY@P<H`PHaPP<
Ha448@P@Q0P48@P<H`P00148@Q0000Aoo`40005oo`003goo00<007ooOol00Woo22U:27Nm2DYB23W>
23g_21S621242BDY20Q221cW236<6BU:20Q221S641cW2ABU20aS21S620aS4@@Q212420@Q20aS2000
4@Q2400017oo0@000Goo000?Ool00`00Oomoo`02Ool8:DX8Mkd9BU88>Lh8?Nl86<H848@99BT82488
7>L8<H`I:DX824886<H@7>L95:D836<86<H836<A124848@8124836<8000A248@0004Ool10001Ool0
00moo`03001oogoo009oo`PYBPQg_@U:DPPicPPmk`PHaPP@Q0TU:@P8@PPLi`PaS1TYBPP8@PPHaQ0L
i`TDY@P<H`PHaPP<Ha448@P@Q0P48@P<H`P00148@Q0000Aoo`40005oo`0000=oo`0000000`000Woo
0P001Goo00<007ooOol00Woo22U:27Nm2DYB23W>23g_21S621242BDY20Q221cW236<6BU:20Q221S6
41cW2ABU20aS21S620aS4@@Q212420@Q20aS20004@Q2400017oo0@000Goo0003Ool01@00Oomoogoo
00000Woo00<007ooOol00Woo00<007ooOol00Woo22U:27Nm2DYB23W>23g_21S621242BDY20Q221cW
236<6BU:20Q221S641cW2ABU20aS21S620aS4@@Q212420@Q20aS20004@Q2400017oo0@000Goo0003
Ool00`00Oomoo`04Ool00`00Oomoo`02Ool30002Ool8:DX8Mkd9BU88>Lh8?Nl86<H848@99BT82488
7>L8<H`I:DX824886<H@7>L95:D836<86<H836<A124848@8124836<8000A248@0003Ool20001Ool0
00=oo`03001oogoo009oo`8000Eoo`03001oogoo009oo`PYBPSoo`Tmk`Pe[@PDY@P8@PP@Q0T48@P<
H`PYBPPU:@PLi`TYBPP]J`PDY@PQ210HaPTLi`P48@P<H`P8@PP<H`T48@P<H`P8@Q048@T8@PP000P8
@PP48@Aoo`40005oo`000goo00<007ooOol00Woo00<007ooOol017oo00<007ooOol00Woo22U:2?oo
2Cg_23F]21BU20Q221242@@Q20aS22U:22DY21cW2BU:22e[21BU224841S62AcW20@Q20aS20Q220aS
2@@Q20aS20Q240@Q2@Q2200020Q220@Q17oo0@000Goo0002Ool20004Ool30004Ool00`00Oomoo`02
Ool8:DX8ool9?Nl8=Jd85:D8248848@9124836<8:DX89BT87>L9:DX8;F/85:D88@P@6<H97>L81248
36<8248836<9124836<8248@12492488000824881244Ool10001Ool000moo`03001oogoo009oo`PY
BPSoo`Tmk`Pe[@PDY@P8@PP@Q0T48@P<H`PYBPPU:@PLi`TYBPP]J`PDY@PQ210HaPTLi`P48@P<H`P8
@PP<H`T48@P<H`P8@Q048@T8@PP000P8@PP48@Aoo`40005oo`003goo00<007ooOol00Woo22U:2?oo
2Cg_23F]21BU20Q221242@@Q20aS22U:22DY21cW2BU:22e[21BU224841S62AcW20@Q20aS20Q220aS
2@@Q20aS20Q240@Q2@Q2200020Q220@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool8:DX8ool9?Nl8
=Jd85:D8248848@9124836<8:DX89BT87>L9:DX8;F/85:D88@P@6<H97>L8124836<8248836<91248
36<8248@12492488000824881244Ool10001Ool000moo`03001oogoo009oo`PYBPSoo`Tmk`Pe[@PD
Y@P8@PP@Q0T48@P<H`PYBPPU:@PLi`TYBPP]J`PDY@PQ210HaPTLi`P48@P<H`P8@PP<H`T48@P<H`P8
@Q048@T8@PP000P8@PP48@Aoo`40005oo`003goo0P000goo22U:2?oo2Cg_23F]21BU20Q221242@@Q
20aS22U:22DY21cW2BU:22e[21BU224841S62AcW20@Q20aS20Q220aS2@@Q20aS20Q240@Q2@Q22000
20Q220@Q0goo0P000Goo000?Ool00`00Oomoo`02Ool8;F/8Li`9:DX86<H@5:D86<H948@87>L89BT@
8@P9;F/88@P85:D848@836<848@96<H848@836<8248848@91248000@12480009248@12482484Ool1
0001Ool000moo`03001oogoo009oo`P]J`QcW0TYBPPHaQ0DY@PHaPT@Q0PLi`PU:A0Q20T]J`PQ20PD
Y@P@Q0P<H`P@Q0THaPP@Q0P<H`P8@PP@Q0T48@P001048@P000T8@Q048@P8@PAoo`40005oo`003goo
00<007ooOol00Woo22e[27>L2BU:21S641BU21S62A2421cW22DY42482Be[224821BU212420aS2124
2AS6212420aS20Q221242@@Q200040@Q20002@Q240@Q20Q217oo0@000Goo000?Ool00`00Oomoo`02
Ool8;F/8Li`9:DX86<H@5:D86<H948@87>L89BT@8@P9;F/88@P85:D848@836<848@96<H848@836<8
248848@91248000@12480009248@12482484Ool10001Ool000moo`03001oogoo009oo`P]J`QcW0TY
BPPHaQ0DY@PHaPT@Q0PLi`PU:A0Q20T]J`PQ20PDY@P@Q0P<H`P@Q0THaPP@Q0P<H`P8@PP@Q0T48@P0
01048@P000T8@Q048@P8@PAoo`40005oo`003goo00<007ooOol00Woo22e[27>L2BU:21S641BU21S6
2A2421cW22DY42482Be[224821BU212420aS21242AS6212420aS20Q221242@@Q200040@Q20002@Q2
40@Q20Q217oo0@000Goo000?Ool00`00Oomoo`02Ool8;F/8Li`9:DX86<H@5:D86<H948@87>L89BT@
8@P9;F/88@P85:D848@836<848@96<H848@836<8248848@91248000@12480009248@12482484Ool1
0001Ool000moo`8000=oo`P]J`QcW0TYBPPHaQ0DY@PHaPT@Q0PLi`PU:A0Q20T]J`PQ20PDY@P@Q0P<
H`P@Q0THaPP@Q0P<H`P8@PP@Q0T48@P001048@P000T8@Q048@P8@P=oo`80005oo`003goo00<007oo
Ool00Woo22DY27>L2A2420Q223F]21S621BU2A2421S622DY41BU2AcW212422DY20Q240aS6@Q220aS
20@Q2@Q2200040@Q20002@@Q40Q2200017oo0@000Goo000?Ool00`00Oomoo`02Ool89BT8Li`948@8
2488=Jd86<H85:D948@86<H89BT@5:D97>L848@89BT8248@36<I248836<812492488000@12480009
124@24880004Ool10001Ool000moo`03001oogoo009oo`PU:@QcW0T@Q0P8@PPe[@PHaPPDY@T@Q0PH
aPPU:A0DY@TLi`P@Q0PU:@P8@Q0<HaT8@PP<H`P48@T8@PP001048@P000T48A08@PP000Aoo`40005o
o`003goo00<007ooOol00Woo22DY27>L2A2420Q223F]21S621BU2A2421S622DY41BU2AcW212422DY
20Q240aS6@Q220aS20@Q2@Q2200040@Q20002@@Q40Q2200017oo0@000Goo000?Ool00`00Oomoo`02
Ool89BT8Li`948@82488=Jd86<H85:D948@86<H89BT@5:D97>L848@89BT8248@36<I248836<81249
2488000@12480009124@24880004Ool10001Ool000moo`03001oogoo009oo`PU:@QcW0T@Q0P8@PPe
[@PHaPPDY@T@Q0PHaPPU:A0DY@TLi`P@Q0PU:@P8@Q0<HaT8@PP<H`P48@T8@PP001048@P000T48A08
@PP000Aoo`40005oo`003goo00<007ooOol00Woo22DY27>L2A2420Q223F]21S621BU2A2421S622DY
41BU2AcW212422DY20Q240aS6@Q220aS20@Q2@Q2200040@Q20002@@Q40Q2200017oo0@000Goo000?
Ool00`00Oomoo`02Ool89BT8Li`948@82488=Jd86<H85:D948@86<H89BT@5:D97>L848@89BT8248@
36<I248836<812492488000@12480009124@24880004Ool10001Ool000moo`8000=oo`P@Q0QBU0TU
:@PLi`PaS0P<H`P@Q14DYA0@Q14DY@P<H`PYBPP@Q0PQ20P000T@Q0P000P@Q0P8@PP48@T8@Q048@P0
00P48A4000P8@PP48@=oo`80005oo`003goo00<007ooOol00Woo212425:D2BDY21cW236<20aS2124
4ABU41244ABU20aS22U:2124224820002A242000212420Q220@Q2@Q240@Q200020@Q4@0020Q220@Q
17oo0@000Goo000?Ool00`00Oomoo`02Ool848@8DY@99BT87>L8<H`836<848@A5:D@48@A5:D836<8
:DX848@88@P8000948@8000848@824881249248@12480008124A000824881244Ool10001Ool000mo
o`03001oogoo009oo`P@Q0QBU0TU:@PLi`PaS0P<H`P@Q14DYA0@Q14DY@P<H`PYBPP@Q0PQ20P000T@
Q0P000P@Q0P8@PP48@T8@Q048@P000P48A4000P8@PP48@Aoo`40005oo`003goo00<007ooOol00Woo
212425:D2BDY21cW236<20aS21244ABU41244ABU20aS22U:2124224820002A242000212420Q220@Q
2@Q240@Q200020@Q4@0020Q220@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool848@8DY@99BT87>L8
<H`836<848@A5:D@48@A5:D836<8:DX848@88@P8000948@8000848@824881249248@12480008124A
000824881244Ool10001Ool000moo`03001oogoo009oo`P@Q0QBU0TU:@PLi`PaS0P<H`P@Q14DYA0@
Q14DY@P<H`PYBPP@Q0PQ20P000T@Q0P000P@Q0P8@PP48@T8@Q048@P000P48A4000P8@PP48@Aoo`40
005oo`003goo00<007ooOol00Woo212425:D2BDY21cW236<20aS21244ABU41244ABU20aS22U:2124
224820002A242000212420Q220@Q2@Q240@Q200020@Q4@0020Q220@Q17oo0@000Goo000?Ool20003
Ool86<H8DY@9:DX@8@P8248A124836<8248836<85:D936<88@P89BT824886<H81249248836<@2488
1249000836<8248@00091248000@1243Ool20001Ool000moo`03001oogoo009oo`PHaPQBU0TYBQ0Q
20P8@Q448@P<H`P8@PP<H`PDY@T<H`PQ20PU:@P8@PPHaPP48@T8@PP<Ha08@PP48@T000P<H`P8@Q00
00T48@P001048@Aoo`40005oo`003goo00<007ooOol00Woo21S625:D2BU:424820Q24@@Q20aS20Q2
20aS21BU2@aS224822DY20Q221S620@Q2@Q220aS40Q220@Q2@0020aS20Q240002@@Q200040@Q17oo
0@000Goo000?Ool00`00Oomoo`02Ool86<H8DY@9:DX@8@P8248A124836<8248836<85:D936<88@P8
9BT824886<H81249248836<@24881249000836<8248@00091248000@1244Ool10001Ool000moo`03
001oogoo009oo`PHaPQBU0TYBQ0Q20P8@Q448@P<H`P8@PP<H`PDY@T<H`PQ20PU:@P8@PPHaPP48@T8
@PP<Ha08@PP48@T000P<H`P8@Q0000T48@P001048@Aoo`40005oo`003goo00<007ooOol00Woo21S6
25:D2BU:424820Q24@@Q20aS20Q220aS21BU2@aS224822DY20Q221S620@Q2@Q220aS40Q220@Q2@00
20aS20Q240002@@Q200040@Q17oo0@000Goo00000goo000000020003Ool20005Ool00`00Oomoo`02
Ool86<H8DY@9:DX@8@P8248A124836<8248836<85:D936<88@P89BT824886<H81249248836<@2488
1249000836<8248@00091248000@1244Ool10001Ool00003Ool007oo00Aoo`04001oogoo0004Ool0
0`00Oomoo`02Ool86<H8DY@9:DX@8@P8248A124836<8248836<85:D936<88@P89BT824886<H81249
248836<@24881249000836<8248@00091248000@1244Ool10001Ool0009oo`03001oogoo009oo`04
001oogoo0004Ool30002Ool8;F/8G_LA9BT812482488000936<848@85:D86<H848@95:D87>L85:D8
36<87>L812495:D8124824881248248A0008248@12490008124@0003Ool20001Ool000=oo`05001o
ogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool8;F/8G_LA9BT812482488000936<848@8
5:D86<H848@95:D87>L85:D836<87>L812495:D8124824881248248A0008248@12490008124@0004
Ool10001Ool00005Ool007ooOol00002Ool01000Oomoo`0017oo00<007ooOol00Woo22e[25kg4BDY
20@Q20Q220002@aS212421BU21S621242ABU21cW21BU20aS21cW20@Q2ABU20@Q20Q220@Q20Q24@00
20Q240@Q2@0020@Q400017oo0@000Goo0002Ool20004Ool20005Ool00`00Oomoo`02Ool8;F/8G_LA
9BT812482488000936<848@85:D86<H848@95:D87>L85:D836<87>L812495:D8124824881248248A
0008248@12490008124@0004Ool10001Ool000moo`03001oogoo009oo`P]J`QNma4U:@P48@P8@PP0
00T<H`P@Q0PDY@PHaPP@Q0TDY@PLi`PDY@P<H`PLi`P48@TDY@P48@P8@PP48@P8@Q4000P8@Q048@T0
00P48A0000Aoo`40005oo`003goo00<007ooOol00Woo22e[25kg4BDY20@Q20Q220002@aS212421BU
21S621242ABU21cW21BU20aS21cW20@Q2ABU20@Q20Q220@Q20Q24@0020Q240@Q2@0020@Q400017oo
0@000Goo000?Ool00`00Oomoo`02Ool8;F/8G_LA9BT812482488000936<848@85:D86<H848@95:D8
7>L85:D836<87>L812495:D8124824881248248A0008248@12490008124@0004Ool10001Ool000mo
o`03001oogoo009oo`P]J`QNma4U:@P48@P8@PP000T<H`P@Q0PDY@PHaPP@Q0TDY@PLi`PDY@P<H`PL
i`P48@TDY@P48@P8@PP48@P8@Q4000P8@Q048@T000P48A0000Aoo`40005oo`003goo0P000goo22e[
25kg4A2421cW21BU20Q22A2441BU40aS2A2421S620Q221S6212421BU2@aS60Q24@@Q20Q2200040@Q
6@0020@Q0goo0P000Goo000?Ool00`00Oomoo`02Ool8;F/8G_LA48@87>L85:D8248948@@5:D@36<9
48@86<H824886<H848@85:D936<H248A12482488000@124I00081244Ool10001Ool000moo`03001o
ogoo009oo`P]J`QNma4@Q0PLi`PDY@P8@PT@Q10DYA0<H`T@Q0PHaPP8@PPHaPP@Q0PDY@T<HaP8@Q44
8@P8@PP001048AT000P48@Aoo`40005oo`003goo00<007ooOol00Woo22e[25kg4A2421cW21BU20Q2
2A2441BU40aS2A2421S620Q221S6212421BU2@aS60Q24@@Q20Q2200040@Q6@0020@Q17oo0@000Goo
000?Ool00`00Oomoo`02Ool8;F/8G_LA48@87>L85:D8248948@@5:D@36<948@86<H824886<H848@8
5:D936<H248A12482488000@124I00081244Ool10001Ool000moo`03001oogoo009oo`P]J`QNma4@
Q0PLi`PDY@P8@PT@Q10DYA0<H`T@Q0PHaPP8@PPHaPP@Q0PDY@T<HaP8@Q448@P8@PP001048AT000P4
8@Aoo`40005oo`003goo00<007ooOol00Woo22e[25kg4A2421cW21BU20Q22A2441BU40aS2A2421S6
20Q221S6212421BU2@aS60Q24@@Q20Q2200040@Q6@0020@Q17oo0@000Goo000?Ool00`00Oomoo`02
Ool8;F/8G_LA48@87>L85:D8248948@@5:D@36<948@86<H824886<H848@85:D936<H248A12482488
000@124I00081244Ool10001Ool000moo`8000=oo`PQ20QBU14@Q0PLia0<Ha4HaPP<H`P000P48@T8
@Q0@Q0PHaPP8@PPHaPT@Q1P8@PP000T48AP000P48A4000P48@P000=oo`80005oo`003goo00<007oo
Ool00Woo224825:D4A2421cW40aS4AS620aS200020@Q2@Q2412421S620Q221S62A2460Q220002@@Q
600020@Q4@0020@Q200017oo0@000Goo000?Ool00`00Oomoo`02Ool88@P8DY@A48@87>L@36<A6<H8
36<800081249248@48@86<H824886<H948@H24880009124H0008124A000812480004Ool10001Ool0
00moo`03001oogoo009oo`PQ20QBU14@Q0PLia0<Ha4HaPP<H`P000P48@T8@Q0@Q0PHaPP8@PPHaPT@
Q1P8@PP000T48AP000P48A4000P48@P000Aoo`40005oo`003goo00<007ooOol00Woo224825:D4A24
21cW40aS4AS620aS200020@Q2@Q2412421S620Q221S62A2460Q220002@@Q600020@Q4@0020@Q2000
17oo0@000Goo000?Ool00`00Oomoo`02Ool88@P8DY@A48@87>L@36<A6<H836<800081249248@48@8
6<H824886<H948@H24880009124H0008124A000812480004Ool10001Ool000moo`03001oogoo009o
o`PQ20QBU14@Q0PLia0<Ha4HaPP<H`P000P48@T8@Q0@Q0PHaPP8@PPHaPT@Q1P8@PP000T48AP000P4
8A4000P48@P000Aoo`40005oo`003goo00<007ooOol00Woo224825:D4A2421cW40aS4AS620aS2000
20@Q2@Q2412421S620Q221S62A2460Q220002@@Q600020@Q4@0020@Q200017oo0@000Goo000?Ool2
0003Ool88@P8DY@A48@87>L@36<A6<H836<800081249248@48@86<H824886<H948@H24880009124H
0008124A000812480003Ool20001Ool000moo`03001oogoo009oo`P8@PPmk`TQ20PHaPPDY@P48@P@
Q0T8@PP@Q108@PP000T<H`P48A0@Q0P<H`PLi`T8@PP@Q108@PP48@T001048@P000P48AT000P48@Ao
o`40005oo`003goo00<007ooOol00Woo20Q223g_2B4821S621BU20@Q21242@Q2212440Q220002@aS
20@Q412420aS21cW2@Q2212440Q220@Q2@0040@Q200020@Q6@0020@Q17oo0@000Goo000?Ool00`00
Oomoo`02Ool82488?Nl98@P86<H85:D8124848@9248848@@2488000936<8124@48@836<87>L92488
48@@24881249000@12480008124I00081244Ool10001Ool000moo`03001oogoo009oo`P8@PPmk`TQ
20PHaPPDY@P48@P@Q0T8@PP@Q108@PP000T<H`P48A0@Q0P<H`PLi`T8@PP@Q108@PP48@T001048@P0
00P48AT000P48@Aoo`40005oo`003goo00<007ooOol00Woo20Q223g_2B4821S621BU20@Q21242@Q2
212440Q220002@aS20@Q412420aS21cW2@Q2212440Q220@Q2@0040@Q200020@Q6@0020@Q17oo0@00
0Goo000?Ool00`00Oomoo`02Ool82488?Nl98@P86<H85:D8124848@9248848@@2488000936<8124@
48@836<87>L9248848@@24881249000@12480008124I00081244Ool10001Ool000moo`03001oogoo
009oo`P8@PPmk`TQ20PHaPPDY@P48@P@Q0T8@PP@Q108@PP000T<H`P48A0@Q0P<H`PLi`T8@PP@Q108
@PP48@T001048@P000P48AT000P48@Aoo`40005oo`003goo0P000goo20Q223g_2B4821S621BU20@Q
21242@Q2212440Q220002@aS20@Q412420aS21cW2@Q2212440Q220@Q2@0040@Q200020@Q6@0020@Q
0goo0P000Goo000?Ool00`00Oomoo`02Ool836<8@Q09:DX86<H@124A000H48@8248936<824886<H8
36<848@86<H924885:D800081248000A124@000I124@0004Ool10001Ool000moo`03001oogoo009o
o`P<H`Q240TYBPPHaQ048A4001P@Q0P8@PT<H`P8@PPHaPP<H`P@Q0PHaPT8@PPDY@P000P48@P00144
8A0001T48A0000Aoo`40005oo`003goo00<007ooOol00Woo20aS248@2BU:21S640@Q4@00612420Q2
2@aS20Q221S620aS212421S62@Q221BU200020@Q20004@@Q40006@@Q400017oo0@000Goo000?Ool0
0`00Oomoo`02Ool836<8@Q09:DX86<H@124A000H48@8248936<824886<H836<848@86<H924885:D8
00081248000A124@000I124@0004Ool10001Ool000moo`03001oogoo009oo`P<H`Q240TYBPPHaQ04
8A4001P@Q0P8@PT<H`P8@PPHaPP<H`P@Q0PHaPT8@PPDY@P000P48@P001448A0001T48A0000Aoo`40
005oo`003goo00<007ooOol00Woo20aS248@2BU:21S640@Q4@00612420Q22@aS20Q221S620aS2124
21S62@Q221BU200020@Q20004@@Q40006@@Q400017oo0@000Goo00000goo000000020003Ool20005
Ool00`00Oomoo`02Ool836<8@Q09:DX86<H@124A000H48@8248936<824886<H836<848@86<H92488
5:D800081248000A124@000I124@0004Ool10001Ool00003Ool007oo00Aoo`04001oogoo0004Ool0
0`00Oomoo`02Ool836<8@Q09:DX86<H@124A000H48@8248936<824886<H836<848@86<H924885:D8
00081248000A124@000I124@0004Ool10001Ool0009oo`03001oogoo00Eoo`03001oogoo009oo`<0
009oo`PQ20Q>L`THaPP@Q0P<H`P48A48@PPDY@P@Q0P48@P@Q0T48@P<H`P@Q0P48@P@Q14<H`P@Q0P4
8@P8@Q4001048@P000P8@R4000=oo`80005oo`000goo00<007ooOol00Woo0P001Goo00<007ooOol0
0Woo224824ic2AS6212420aS20@Q4@Q221BU212420@Q21242@@Q20aS212420@Q21244@aS212420@Q
20Q24@0040@Q200020Q28@0017oo0@000Goo00001Goo001oogoo00000goo00<007ooOol017oo00<0
07ooOol00Woo224824ic2AS6212420aS20@Q4@Q221BU212420@Q21242@@Q20aS212420@Q21244@aS
212420@Q20Q24@0040@Q200020Q28@0017oo0@000Goo0002Ool20004Ool30004Ool00`00Oomoo`02
Ool88@P8CW<96<H848@836<8124A24885:D848@8124848@9124836<848@8124848@A36<848@81248
248A000@12480008248Q0004Ool10001Ool000moo`03001oogoo009oo`PQ20Q>L`THaPP@Q0P<H`P4
8A48@PPDY@P@Q0P48@P@Q0T48@P<H`P@Q0P48@P@Q14<H`P@Q0P48@P8@Q4001048@P000P8@R4000Ao
o`40005oo`003goo00<007ooOol00Woo224824ic2AS6212420aS20@Q4@Q221BU212420@Q21242@@Q
20aS212420@Q21244@aS212420@Q20Q24@0040@Q200020Q28@0017oo0@000Goo000?Ool00`00Oomo
o`02Ool88@P8CW<96<H848@836<8124A24885:D848@8124848@9124836<848@8124848@A36<848@8
1248248A000@12480008248Q0004Ool10001Ool000moo`03001oogoo009oo`PQ20Q>L`THaPP@Q0P<
H`P48A48@PPDY@P@Q0P48@P@Q0T48@P<H`P@Q0P48@P@Q14<H`P@Q0P48@P8@Q4001048@P000P8@R40
00Aoo`40005oo`003goo0P000goo224825:D2ABU20@Q21BU40@Q2A2421BU2124200020@Q4@aS2000
20Q220aS20004ABU40Q24@0060@Q4@0020Q2200020@Q0goo0P000Goo000?Ool00`00Oomoo`02Ool8
8@P8DY@95:D812485:D@124948@85:D848@80008124A36<80008248836<8000A5:D@248A000H124A
0008248800081244Ool10001Ool000moo`03001oogoo009oo`PQ20QBU0TDY@P48@PDYA048@T@Q0PD
Y@P@Q0P000P48A4<H`P000P8@PP<H`P0014DYA08@Q4001P48A4000P8@PP000P48@Aoo`40005oo`00
3goo00<007ooOol00Woo224825:D2ABU20@Q21BU40@Q2A2421BU2124200020@Q4@aS200020Q220aS
20004ABU40Q24@0060@Q4@0020Q2200020@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool88@P8DY@9
5:D812485:D@124948@85:D848@80008124A36<80008248836<8000A5:D@248A000H124A00082488
00081244Ool10001Ool000moo`03001oogoo009oo`PQ20QBU0TDY@P48@PDYA048@T@Q0PDY@P@Q0P0
00P48A4<H`P000P8@PP<H`P0014DYA08@Q4001P48A4000P8@PP000P48@Aoo`40005oo`003goo00<0
07ooOol00Woo224825:D2ABU20@Q21BU40@Q2A2421BU2124200020@Q4@aS200020Q220aS20004ABU
40Q24@0060@Q4@0020Q2200020@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool88@P8DY@95:D81248
5:D@124948@85:D848@80008124A36<80008248836<8000A5:D@248A000H124A0008248800081244
Ool10001Ool000moo`8000=oo`PHaPQ6<@TDY@P48@PDY@P000P48A4<H`P8@PP48@P000T48@P000P4
8@P@Q0P48@P8@PTHaPP48@P@Q0P8@PP002448B4000P48@=oo`80005oo`003goo00<007ooOol00Woo
21S624Ha2ABU20@Q21BU200020@Q4@aS20Q220@Q20002@@Q200020@Q212420@Q20Q22AS620@Q2124
20Q220008@@Q8@0020@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool86<H8AS495:D812485:D80008
124A36<824881248000912480008124848@8124824896<H8124848@82488000Q124Q00081244Ool1
0001Ool000moo`03001oogoo009oo`PHaPQ6<@TDY@P48@PDY@P000P48A4<H`P8@PP48@P000T48@P0
00P48@P@Q0P48@P8@PTHaPP48@P@Q0P8@PP002448B4000P48@Aoo`40005oo`003goo00<007ooOol0
0Woo21S624Ha2ABU20@Q21BU200020@Q4@aS20Q220@Q20002@@Q200020@Q212420@Q20Q22AS620@Q
212420Q220008@@Q8@0020@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool86<H8AS495:D812485:D8
0008124A36<824881248000912480008124848@8124824896<H8124848@82488000Q124Q00081244
Ool10001Ool000moo`03001oogoo009oo`PHaPQ6<@TDY@P48@PDY@P000P48A4<H`P8@PP48@P000T4
8@P000P48@P@Q0P48@P8@PTHaPP48@P@Q0P8@PP002448B4000P48@Aoo`40005oo`003goo00<007oo
Ool00Woo21S624Ha2ABU20@Q21BU200020@Q4@aS20Q220@Q20002@@Q200020@Q212420@Q20Q22AS6
20@Q212420Q220008@@Q8@0020@Q17oo0@000Goo000?Ool20003Ool82488=Jd97>L85:D@36<A1248
248836<8248836<A124836<848@8000836<948@8124836<81248248A000812480008248900081248
00081243Ool20001Ool000moo`03001oogoo009oo`P8@PPe[@TLi`PDYA0<Ha448@P8@PP<H`P8@PP<
Ha448@P<H`P@Q0P000P<H`T@Q0P48@P<H`P48@P8@Q4000P48@P000P8@PT000P48@P000P48@Aoo`40
005oo`003goo00<007ooOol00Woo20Q223F]2AcW21BU40aS4@@Q20Q220aS20Q220aS4@@Q20aS2124
200020aS2A2420@Q20aS20@Q20Q24@0020@Q200020Q22@0020@Q200020@Q17oo0@000Goo000?Ool0
0`00Oomoo`02Ool82488=Jd97>L85:D@36<A1248248836<8248836<A124836<848@8000836<948@8
124836<81248248A00081248000824890008124800081244Ool10001Ool000moo`03001oogoo009o
o`P8@PPe[@TLi`PDYA0<Ha448@P8@PP<H`P8@PP<Ha448@P<H`P@Q0P000P<H`T@Q0P48@P<H`P48@P8
@Q4000P48@P000P8@PT000P48@P000P48@Aoo`40005oo`003goo00<007ooOol00Woo20Q223F]2AcW
21BU40aS4@@Q20Q220aS20Q220aS4@@Q20aS2124200020aS2A2420@Q20aS20@Q20Q24@0020@Q2000
20Q22@0020@Q200020@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool82488=Jd97>L85:D@36<A1248
248836<8248836<A124836<848@8000836<948@8124836<81248248A000812480008248900081248
00081244Ool10001Ool000moo`03001oogoo009oo`P8@PPe[@TLi`PDYA0<Ha448@P8@PP<H`P8@PP<
Ha448@P<H`P@Q0P000P<H`T@Q0P48@P<H`P48@P8@Q4000P48@P000P8@PT000P48@P000P48@Aoo`40
005oo`003goo0P000goo2124236<2B48212420Q240@Q2@0040aS6@Q2200020aS20Q220@Q8@Q240@Q
2@Q2600020@Q4@0040@Q0goo0P000Goo000?Ool00`00Oomoo`02Ool848@8<H`98@P848@8248@1249
000@36<I2488000836<82488124Q248@1249248H0008124A000@1244Ool10001Ool000moo`03001o
ogoo009oo`P@Q0PaS0TQ20P@Q0P8@Q048@T0010<HaT8@PP000P<H`P8@PP48B48@Q048@T8@QP000P4
8A4001048@Aoo`40005oo`003goo00<007ooOol00Woo2124236<2B48212420Q240@Q2@0040aS6@Q2
200020aS20Q220@Q8@Q240@Q2@Q2600020@Q4@0040@Q17oo0@000Goo000?Ool00`00Oomoo`02Ool8
48@8<H`98@P848@8248@1249000@36<I2488000836<82488124Q248@1249248H0008124A000@1244
Ool10001Ool000moo`03001oogoo009oo`P@Q0PaS0TQ20P@Q0P8@Q048@T0010<HaT8@PP000P<H`P8
@PP48B48@Q048@T8@QP000P48A4001048@Aoo`40005oo`000Woo0P0017oo0P001Goo00<007ooOol0
0Woo2124236<2B48212420Q240@Q2@0040aS6@Q2200020aS20Q220@Q8@Q240@Q2@Q2600020@Q4@00
40@Q17oo0@000Goo00001Goo001oogoo00000Woo00@007ooOol000Aoo`03001oogoo009oo`P@Q0Pa
S0TQ20P@Q0P8@Q048@T0010<HaT8@PP000P<H`P8@PP48B48@Q048@T8@QP000P48A4001048@Aoo`40
005oo`000goo00D007ooOomoo`00009oo`03001oogoo009oo`<0009oo`PLi`Q6<@TLi`P<Ha08@PP4
8@T8@Q0<H`P48@P8@Q448@P000P48@P8@PP<H`T48@P<H`P000P48@P8@PT48@P001048A4000P48A00
00=oo`80005oo`0017oo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`PLi`Q6<@TL
i`P<Ha08@PP48@T8@Q0<H`P48@P8@Q448@P000P48@P8@PP<H`T48@P<H`P000P48@P8@PT48@P00104
8A4000P48A0000Aoo`40005oo`0000Eoo`00Oomoo`00009oo`04001oogoo0004Ool00`00Oomoo`02
Ool87>L8AS497>L836<@24881249248@36<81248248A124800081248248836<9124836<800081248
24891248000@124A0008124@0004Ool10001Ool0009oo`8000Aoo`8000Eoo`03001oogoo009oo`PL
i`Q6<@TLi`P<Ha08@PP48@T8@Q0<H`P48@P8@Q448@P000P48@P8@PP<H`T48@P<H`P000P48@P8@PT4
8@P001048A4000P48A0000Aoo`40005oo`003goo00<007ooOol00Woo21cW24Ha2AcW20aS40Q220@Q
2@Q240aS20@Q20Q24@@Q200020@Q20Q220aS2@@Q20aS200020@Q20Q22@@Q200040@Q4@0020@Q4000
17oo0@000Goo000?Ool00`00Oomoo`02Ool87>L8AS497>L836<@24881249248@36<81248248A1248
00081248248836<9124836<80008124824891248000@124A0008124@0004Ool10001Ool000moo`03
001oogoo009oo`PLi`Q6<@TLi`P<Ha08@PP48@T8@Q0<H`P48@P8@Q448@P000P48@P8@PP<H`T48@P<
H`P000P48@P8@PT48@P001048A4000P48A0000Aoo`40005oo`003goo00<007ooOol00Woo21cW24Ha
2AcW20aS40Q220@Q2@Q240aS20@Q20Q24@@Q200020@Q20Q220aS2@@Q20aS200020@Q20Q22@@Q2000
40@Q4@0020@Q400017oo0@000Goo000?Ool00`00Oomoo`02Ool87>L8AS497>L836<@24881249248@
36<81248248A124800081248248836<9124836<80008124824891248000@124A0008124@0004Ool1
0001Ool000moo`8000=oo`PHaPPmk`T<H`P48@P<Ha0001T8@QT48A0000P48@P8@PP00148@PP48@P8
@Q448@P001048A4001048@P000=oo`80005oo`003goo00<007ooOol00Woo21S623g_2@aS20@Q20aS
40006@Q26@@Q400020@Q20Q220004@Q220@Q20Q24@@Q200040@Q4@0040@Q200017oo0@000Goo000?
Ool00`00Oomoo`02Ool86<H8?Nl936<8124836<@000I248I124@000812482488000A24881248248A
1248000@124A000@12480004Ool10001Ool000moo`03001oogoo009oo`PHaPPmk`T<H`P48@P<Ha00
01T8@QT48A0000P48@P8@PP00148@PP48@P8@Q448@P001048A4001048@P000Aoo`40005oo`003goo
00<007ooOol00Woo21S623g_2@aS20@Q20aS40006@Q26@@Q400020@Q20Q220004@Q220@Q20Q24@@Q
200040@Q4@0040@Q200017oo0@000Goo000?Ool00`00Oomoo`02Ool86<H8?Nl936<8124836<@000I
248I124@000812482488000A24881248248A1248000@124A000@12480004Ool10001Ool000moo`03
001oogoo009oo`PHaPPmk`T<H`P48@P<Ha0001T8@QT48A0000P48@P8@PP00148@PP48@P8@Q448@P0
01048A4001048@P000Aoo`40005oo`003goo00<007ooOol00Woo21S623g_2@aS20@Q20aS40006@Q2
6@@Q400020@Q20Q220004@Q220@Q20Q24@@Q200040@Q4@0040@Q200017oo0@000Goo000?Ool2003o
Ool=Ool20001Ool000moo`03001oogoo0?moo`eoo`40005oo`003goo00<007ooOol0ogoo3Goo0@00
0Goo000?Ool00`00Oomoo`02Ool00`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0UOol00`00
Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0VOol00`00Oomoo`0BOol10001Ool000moo`03001o
ogoo009oo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001o
ogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo009oo`40005oo`003gooo`004@00
0Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-2.52722, -2.351, 0.122588, \
0.122588}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[compressedfSpec], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF5E19101206090706070305030304030302020202020202020201020101020100000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
091D070A0402030001010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
071307080403030101000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
010805050402020201010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
010605040202010201010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
020604030202010100010100000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
010402010102010200010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000300000101010100000001000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000201010201000100010001000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
010201010100000000010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
010201010000000000010000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000200000000000001000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000100000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000100000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol017oo0Re[0PaS10Q20P000P@Ql@001Goo0@000Goo000=Ool01000Oomoo`0017oo
00<007ooOol017oo0Re[0PaS10Q20P000P@Ql@001Goo0@000Goo000>Ool20005Ool00`00Oomoo`02
Ool2124236<20002127g0005Ool10001Ool001Eoo`03001oogoo009oo`848@8<H`8000848OL000Eo
o`40005oo`005Goo00<007ooOol00Woo0P000PQ20P000P@Qm`001Goo0@000Goo000EOol00`00Oomo
o`02Ool2000224820002127g0005Ool10001Ool001Eoo`03001oogoo009oo`8000848O/000Eoo`40
005oo`005Goo00<007ooOol00Woo0P000P@Qn`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005
Ool10001Ool001Eoo`8000=oool000Aoo`80005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo
000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`00
5Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eo
o`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol0
0`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo0P00
0gooo`0017oo0P000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009o
ool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo
0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`00
1Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eo
o`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol20003Oooo0004Ool20001Ool0
01Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000E
Ool00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo
00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03
001oogoo009oool000Eoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Wooo`001Goo0@00
0Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Wooo`001Goo0@000Goo0008
Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000gooo`0017oo0P000Goo0009Ool01@00Oomoogoo
00000Woo00<007ooOol00Woo00<007ooOol00Wooo`001Goo0@000Goo0007Ool01000Oomoo`000Woo
00@007ooOol000Aoo`03001oogoo009oool000Eoo`40005oo`0027oo0P0017oo0P001Goo00<007oo
Ool00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo
009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02
Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Woo
o`001Goo0@000Goo000EOol20003Oooo0004Ool20001Ool001Eoo`03001oogoo009oool000Eoo`40
005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001
Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo
000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`00
5Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eo
o`8000=oool000Aoo`80005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomo
o`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol0
0Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009o
ool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo
0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo0P000gooo`0017oo0P00
0Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005o
o`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool0
01Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000E
Ool00`00Oomoo`02Oooo0005Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oool000Eo
o`40005oo`002Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oool000Eoo`40005o
o`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oool000Aoo`80005oo`001goo00@007ooOol0009o
o`04001oogoo0004Ool00`00Oomoo`02Oooo0005Ool10001Ool000Qoo`03001oo`00009oo`04001o
ogoo0004Ool00`00Oomoo`02Oooo0005Ool10001Ool000Uoo`8000=oo`8000Eoo`03001oogoo009o
ool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo
0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`00
1Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eo
o`40005oo`005Goo0P000gooo`0017oo0P000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool0
01Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000E
Ool00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo
00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03
001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol20003
Oooo0004Ool20001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Woo
o`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool0
00Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005
Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo
0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`8000=oool000Aoo`80005oo`00
5Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eo
o`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol0
0`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<0
07ooOol00Wooo`001Goo0@000Goo0007Ool30004Ool20005Ool00`00Oomoo`02Oooo0005Ool10001
Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Wooo`001Goo0@000Goo0007
Ool01000Oomoo`000Woo00@007ooOol000Aoo`8000=oool000Aoo`80005oo`001goo0`000goo00@0
07ooOol000Aoo`03001oogoo009oool000Eoo`40005oo`0027oo00<007ooOol00Woo00@007ooOol0
00Aoo`03001oogoo009oool000Eoo`40005oo`0027oo0`000goo0P001Goo00<007ooOol00Wooo`00
1Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eo
o`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool1
0001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@00
0Goo000EOol20003Oooo0004Ool20001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo
00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03
001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00
Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007oo
Ool00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`8000=oool0
00Aoo`80005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005
Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo
0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40
005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001
Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo0P000gooo`0017oo0P000Goo000EOol0
0`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<0
07ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001o
ogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomo
o`02Oooo0005Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oool000Eoo`40005oo`00
1goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Oooo0005Ool10001Ool000Moo`04
001oogoo0002Ool01000Oomoo`0017oo0P000gooo`0017oo0P000Goo0008Ool20003Ool01000Oomo
o`0017oo00<007ooOol00Wooo`001Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Ao
o`03001oogoo009oool000Eoo`40005oo`0027oo0P0017oo0P001Goo00<007ooOol00Wooo`001Goo
0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40
005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001
Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo
000EOol20003Oooo0004Ool20001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<0
07ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001o
ogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomo
o`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol0
0Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`8000=oool000Ao
o`80005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool1
0001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@00
0Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005o
o`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool0
01Eoo`03001oogoo009oool000Eoo`40005oo`005Goo0P000gooo`0017oo0P000Goo000EOol00`00
Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007oo
Ool00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo
009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02
Oooo0005Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eoo`03001oogoo009oool000Eo
o`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomo
o`02Oooo0005Ool10001Ool000=oo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0
0Woo0P000gooo`0017oo0P000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001o
ogoo009oo`03001oogoo009oool000Eoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo
0002Ool00`00Oomoo`02Ool00`00Oomoo`02Oooo0005Ool10001Ool0009oo`8000Aoo`8000Aoo`80
00Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000E
Ool00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo
00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03
001oogoo009oool000Eoo`40005oo`005Goo0P000gooo`0017oo0P000Goo000EOol00`00Oomoo`02
Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Woo
o`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool0
00Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005
Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo
0@000Goo000EOol20003Oooo0004Ool20001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`00
5Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eo
o`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol0
0`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<0
07ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`8000=o
ool000Aoo`80005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo
0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`00
1Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eo
o`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo00000goo0000000300000goo00000002
0003Ool20005Ool00`00Oomoo`02Oooo0005Ool10001Ool000=oo`05001oogooOol00005Ool01000
Oomoo`0017oo00<007ooOol00Wooo`001Goo0@000Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02
Ool01000Oomoo`0017oo0P000gooo`0017oo0P000Goo0003Ool00`00Oomoo`03Ool01@00Oomoogoo
00000Woo00<007ooOol00Woo00<007ooOol00Wooo`001Goo0@000Goo0003Ool01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oool000Eoo`40005oo`000Woo0P00
17oo0P0017oo0P001Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005
Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo
0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40
005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol20003Oooo0004Ool20001Ool001Eo
o`03001oogoo009oool000Eoo`40005oo`005Goo00<007ooOol00Wooo`001Goo0@000Goo000EOol0
0`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001oogoo009oool000Eoo`40005oo`005Goo00<0
07ooOol00Wooo`001Goo0@000Goo000EOol00`00Oomoo`02Oooo0005Ool10001Ool001Eoo`03001o
ogoo0?moo`Moo`40005oo`005Goo00<007ooOol0ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool0
0`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol0
0`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool001Eoo`8000=oo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Ioo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`80005oo`00
5Gooo`002`000Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(compressedSample = Abs[InverseFourier[compressedfSpec]];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[compressedSample, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
D9DACBBEBCBEBAB5B4B6B5B2B0AFACA8A5A4A19E9B9895908C8A8785848483807F7F7E7D
7E80817F7D7D7E7D7C79777574757572717273716F6D6D6B696867656160605F5A555351
4E4A443A2D1E130D0803020912191F24292D3033363A3D3F4144484A4B4D505251515254
55585C5F6163676A6C71777A797A85919597A7C3
9CA7A29895989794929494918F8E8C89868584827F7D7B78757372716F6F706F6E6D6C6D
6F70706E6D6E706F6C68666667686866666767646261615F5D5D5D5B585757554F4A4848
46413B33281E191614151B252D32363A3D3F414446484B4D4E5052545556585A5958595B
5C5D60646565676B6F7172737477818A8A7E7885
748A887E7D8384807F82827F7D7E7E7B797A7A78757473706E6E6E6C6B6C6E6D6B6A6B6D
6E6E6E6D6D6F706E696565686A6A6A6968696866656464636162625F5D5D5D59514D4F52
4F4A454038302C29282A313A3E3F42444646484B4C4D4F51515153565656585A5957585A
5B5B5D60605F6167696665686E7275756A503C4E
758B867B7C83837E7D81817E7E807F7D7B7D7D7A7777767372727170707274716E6F7172
72727272737575706B696C6F7171706E6E6E6D6C6B6B6A68686867656364635C55555A5C
5853504B443B36333234393F404041444546484A4B4B4E4F4E4F5154545355575655575A
5A58595D5D5B5E63625E5F696F6B625743231B45
7F8F887D7E83827D7D81827F7F80807D7B7C7B787777767473737372727474716F707272
727272737576746E6A6B6F7272716F6F6E6E6D6C6C6B6968686967656566625A55595E5E
5955534E463E383533353A3D3D3E414345474A4C4B4C4E4F4E4F53555454565959585A5D
5B595B5F5E5D5F626261676F6C5B4636220E1F52
7B8A8278787D7C78787C7D7A797A7A777576767473747472717171717070706E6D6E6F70
6F6F70727473706B696B6F71706D6D6D6D6C6B6B6A6867676868666667655E57575C605E
5957555047403B3836393D40414346494B4E50504F4F51515154585957585B5E5E5D5F5F
5D5B5E61605D606567686B695A3E251A130E2554
75847D737378787474787976757676747374757474747472717172706F6F706E6D6E7070
6E6E717474726E6B6A6C70716F6D6E6F6E6C6C6D6C69696B6C6A696B6A655D595D636461
5E5C5A544D46413E3D3F4346484A4D4F525353525151535455585B5B5A5B5E60605F5F5E
5D5C5E605E5C61696B675E4F381B0A0E100E234F
79877F74747A797576797A7777797977767878777677767472737270707172706E707170
6E6F747676726F6C6C6F737371717272706F71716E6C6F71706E6E6F6C645E5F65696865
63615E59524B45424143474A4B4D4F52535352505051535557595B5B5A5B5E605F5D5D5D
5C5C5C5D5D60676B6656412C1604040F120E2351
7D8A8175767B7B76777A7B79797A7A787778787776767573717271707071716F6E70706F
6E71767775716E6C6E72757472737573707173726F6F7273706E70706A615E63696A6866
64615E59524B45434345484B4D4E50525351505051535658595A5C5C5C5C5F605F5D5D5E
5D5C5D6064686A64533920120903091313102857
7B877F7373797975757879777678777473747675747372706F70706F6F706F6E6E6F706F
6F727576746F6C6D7074747373757572717273726F7072716E6D706E665F60676A696764
63615E59534C484647494C4F505152545453525456585A5B5C5D5E5F5E5F606261606061
606064696C6A614F361C0C0A09060A1212112A57
78857C71717777737377777574757572717476757272727170707170707070706F707170
70727677736E6D70737474757676757372747472717272706E70706C6461656B6C696766
6564615D57524E4D4D4F515455555657575757595A5C5D5E5E5F60616060616464626263
65676B6E6A5D48301A0A06090804071011112854
7B887E727379797474787876757676737477797673747574727374727172737271727271
70737777726F7073757677797978767575757574747373717172716B65656B6F6E6B6A6B
6B6966625D58545252525457575657595959595B5C5C5D5E5E6061616060626565626367
6B6D6C66594228140A0505060402071011102956
808B8174757A7A7575797A7876777675767978747375767473747472717373727171716F
707478767170727577787A7B79777676757676757473737372726F6966696F716F6C6D6F
6E6B6865605A565452525456565657595A59595B5C5C5D5E5F606161606063666564686E
716C61523D230F09080402040504091213132D5B
808B8073747A7A7575787A7774757575767675737475757472737271717273717070706F
7175777571717477797A7A7977777676757576757372727372706C69696D71726F6E7071
6E6B6866615B5754525255585858595B5C5B5B5C5D5E5E606161626161636566676A7174
6F604C37221008090802010607050A1314152E5C
808A7F73747B7A7574787975727477767575757575767674737373727273747371717272
72747574727377797A797878787876757576767573737473726F6D6C6F72747371717271
6E6B6A69645E5A575555585B5B5B5D5E5E5D5D5F5F5F606162626263646566696E747671
6149311F120A0708050001060704091315152E5B
848E8376787E7C76767A7A7675797B787677797877787876757576757475767472727371
707275757475797B7977797B7A7877767777777776767675737171727475757473737472
6F6E6F6D68615C5A58595C5F5F5E5E60605E5E5F605F6062636364656665686F77797160
482E1C120C0805050200020606040B151616305F
8992867A7B807D77787C7C78787C7C7876787A7978797A7776767775747575737171706E
6F73767675787C7B79797C7D7B78787979797A7A78787776737374767675757575757473
727273706A635E5B5A5B5E61605E5E60605E5E5F606061646565666767686E787C736046
2E1B120E0B0604040301030808070E1818193565
8A93877A7A7E7C78797D7C79797A797675787A79787A7A777576767473737371706F6F70
71747677797C7E7C7B7C7E7D7A797B7C7B7B7C7B79787775747578787675767776767676
757575716A645F5D5B5D6162605E5F61605E5F62636365676868686A6B70787E7863472E
1E140F0D09050405050305090A0910191A1C3866
89928679797F7E79797C7C7877797877777B7C7B7A7B7A77757676747273747372727474
7373757A7E7F7E7D7C7D7C7C7C7D7E7D7C7C7C7B7977767576797A797777787978787979
787775716B65625F5E606363605F6163626163666767696B6B6A6B6E73797D79674B2F1F
18120D0A080504050403050A0A090F191B1D3865
8C95897C7C827F79797D7D7A797B7C7B7B7E7F7C7B7B7A77767677747375777674757571
6C6C757D807F7D7C7B7B7C7E80807E7C7B7C7C7B797776777A7C7C7A79797A7A7A7A7A7A
787775726D68646261636564616163656565676A69696A6C6C6B6E757B7C76674E321F18
150E080808040203030205090A09101A1C1E3968
90998C7F7F837F797B80807C7C7F7F7D7C7D7D7A797A7977767777757477787573716D65
616A7881817E7D7D7C7D8082827F7D7C7C7C7D7C7A77787B7D7E7D7B7A7A7B7B7B7B7A79
787776736F6A6664646465646263666767686A6B6A6A6B6D6D6E747C7D75644E36211714
10090608070301030403060B0C0B131D1F213D6C
929A8D7F7E827F7C7E83827D7D7E7D7A797B7B7A7A7B7B7977787774747574716D69625D
627281878583828180828484818080807F7E7F7E7B797B7F807E7D7D7C7C7C7D7C7B7B7A
7A7A7976726D6A67666666666667696A6A6A6C6C6C6B6D6F70747B7E77654E3826191412
0E080709080302050605090F0F0E16212325406F
929A8D7F7F8383818284827D7C7D7D7B7C7F818180807E7B797876747373716D69646162
6D7E8B908E8A888684838383848686837F7F817F7C7C7F81818080807E7E7F7F7F7E7E7E
7E7E7D7A76716D6B6969696A6A6B6C6D6D6D6E6F6F6F7073767B7F7A6A523B2B1F171312
0E0A0A0B0804040809090D12111019242526406F
949D9082828888848284837F7F8284838588898683807D7975747371706F6E6A66636366
72849297938C86827F7E81878C8C867E7C7E807F7C7D8183838282818080818180808081
817F7E7C78736F6D6C6B6B6C6C6C6D6E6F707171717173787D807D705A412E231C161312
0F0B0B0B0805060A0B0B0E1212121B252525406F
969F9284848A89828185868485888A888787857F7975716D6A6A6A69676766635E5C5B60
7087989A90827B78787C868F90877A74777D7F7E7C7E8183838281817F7F80807F7F8080
7F7E7D7C77736F6D6B6A6B6C6D6C6D6F717172727172767D817F74604832231D1A161311
0E0B09090705070B0C0B0E1213131C2524254171
959E908181868580818789868484837E7975706963615F5C5B5D5E5D5B5B5A56514E5160
7C96A29A867773767C86919389776E717A80807E7E7F828382807F7F7E7D7D7E7D7D7D7D
7D7D7D7B7773706E6B6A6B6D6D6D6E717272717272767C828177644D36241B1A1814110F
0C0806080806070B0B0B0E1213131A2323254170
919A8C7D7E8585828387847C76736F67605C58545252535354575755535454504D52627E
9CAFAD9980767B838C94968D7A6D707B8385848281828383817F7F7E7D7D7D7E7E7D7D7E
7F80807E7A7672706D6C6E70706F707373727274777C82837B69513A271B181918120E0C
090605080806060A0B0A0D121311182223243F6D
929A8D80828988827F7D7569615E5A534F50505051545657595B5A58595C5D5C61718AA6
BABFB095807F899296958E8072727D878A8886848383848482808081807F808181818284
848484827E797572706F717372717275757475797E82847E6E573E2A1F19191916100B0A
0705060A0905060A0C0B0E121211192323233E6E
969F9285858984786F685F5551535250505457585A5D606163646363676C6F727E92A9BA
C1BAA58C808590938F888078767D878A8886858583838484838283838282838585848687
878685837F7A767472717374727274777877797F848580735D442E221D1A1817130D0908
0707090B0905070D0E0C0E1313121A2424244171
98A192817C7B71625854504D50555756575C5F5F616467686A6B6C6F74797D8491A2AEB4
B1A592817C838A88807B7A7B7D8286868484858482838585838384858383858786858687
868585837E7A7775737273747474787A79797D84878276634B3426201D181514100A0809
09090A0B0806090F0F0C0F1414131A2424254273
9499856F67645B4F4C505253565B5C5A5B60636465696D6E6F7174787C80858C969EA1A1
9C92847A7A81837F7B7D8182828284858687878584858787858586868485878785848585
858484837F7B79777473757677787A7B7A7C8288867B68523C2A211E1A1412110E09080A
0C0A0A0A08070A0E0D0B0E141311192323244272
8A89725B5658534F52595B5A5C5E5E5D5F65696A6C71747575777B7E80848A8E92949697
948D827D7F838482838789868485898A8B8B8A8887888988868688878686878785848586
86868785827F7D7A7675777A7A7A7B7B7C80878A8270594230231E1A161110100C08090C
0C0A080908070A0D0C0A0E12111019222122406C
7E7A6454565D5C595D61605D5E626263686F727274797C7B7A7D808284898D8E8F929698
958E87848688898A8C8D8B87888B8E8E8D8D8C8A89898988878889898787888785868889
8989898885827F7C78777A7C7C7A7A7C80878B8879614834271E1A1713100F0E0B090B0E
0C09080909080A0D0C0A0E12111119211F223E66
7573635A606563606062616063676A6C717678787A7E7F7E7E818486888C8E8F90959999
948F8B8A8A8B8C8D8D8C8A8B8D8F8F8D8C8C8C8A88888989898A8B898888888887888A8B
8B8B8C8B8884807C79797C7D7C7A7C81888D8C816B50392A211B181613100E0E0C0B0D0E
0C09080A09080A0D0C0B0E121111181F1E213B5F
72756A626568655F5F6264666A6E7173777A7B7C7E8181808285888A8B8E8F9193979897
93908E8C8B8C8E8E8D8D8E8F908E8C8C8D8E8D8A888A8B8C8C8C8C8A89898A8A8A8B8C8C
8D8D8E8D8985817E7B7C7E7F7D7D81898F9088755B402E241F1A1716130F0E0E0D0D0D0E
0B08080A09080A0C0C0B0D111110171E1E20375A
757A6F656668656163696D6E717577787B7E808183858586878A8C8D8E90929395969797
9594928F8D8E909090919292908D8C8E90908E8B8B8E8F908F8E8D8C8B8B8C8C8C8D8E8F
8F90908E8B8784817E7E808180818890938D7D654A3327211D181614110E0E0F0F0D0D0D
0B08080A0A080A0C0B0A0D111010161E1E20365A
7A7F7267686C6A686B727575767A7D7E8084868687898B8B8C8E9090919394959597999A
9997949190929394949493918F8E909293918F8E8F9192918F8E8D8D8C8D8E8E8E8E9091
9191918F8C8986838080828383868E9492856F553C2B221F1B171514110F0F100F0D0D0D
0B08090B0B090A0D0C0B0E111111181F1F21385E
7B8073696B71706E717779787A7E8283848789898A8C8D8D8D8F91919293949595989B9B
9997959493939595949392919090929393919090919291908E8E8E8E8E8F908F8F909192
929292908E8B878482828485878C93958D7960463226201D1A171514121010100F0D0D0D
0B090A0C0C0A0B0E0D0C0F131313192020223A60
7A80756C6F747371747A7C7B7D828585858889898A8D8D8D8D9091919192949596989A99
98989795939394949392929392929394939292929292918F8F8F90909090919190919393
93929292908C8886848486888C929793846B513B2C231E1C1A171614121010100F0E0E0E
0C0A0B0D0C0A0C0E0E0C0F13131218202122395E
7B82786F71767674777D7F7E8084868585888B8B8C8E8F8F8F9192929193959697989A9B
9B9B9A979494959594949595949394959594939393929291919292929292929191929495
94939393918D8A898887888C9398978C775D443328211D1B19161514110F0F100F0E0D0D
0C0A0B0C0C0A0B0E0D0C0F13131218202122385E
7E867C72747A7A797C82838182868887888C8F8E8E9192929293949394969898999B9D9F
9F9E9C989595979796969796949496979694949494939393939393939292929192939595
93929393918F8E8D8A878A92999A917F674E3A2D251F1B1917151413110F0F100F0D0D0D
0C0A0B0C0C0A0B0E0E0D0F131313192121223960
828A8076797F7F7D8084858385898B8B8D909190919495949394959596989A999A9DA0A1
9F9D9A979597989896969796959597979594949595949393939292929291919292949593
919293949392918F89878E989D9686705842332A231D19181715141311100F10100E0D0E
0D0B0B0D0D0B0C0F0F0E101415141A2223243A62
848D847A7C82838082868786888C8F8F8F91929293959694939497979898999A9C9FA09F
9D9B9A979697989795969797959596969594969695939393929292929292929394949392
919396979796948F898A959E9C8E78614D3C3028211A18181816141412101011100F0E0F
0E0C0C0E0E0C0D10100E111515141A2324243B64
8892887D8086868385898A898B8F918F8F919394959696949496999997989A9C9D9E9E9D
9D9D9B999798989797989998979697979797989795939494949394949494949494949393
94979A9B9B99958E8B919CA097826A5646382D251E1A191A1A17151412101012110F0F0F
0E0C0D0F0E0C0D10100F111616151B2425253C66
8C968B8183898986888C8D8C8D90918F8F9396969697969596999A9997999C9D9E9E9E9F
9F9F9D9B99999999999A9B9A989898999999989795949595959495959594949494949495
989A9C9D9C99948F8F969F9E8E765F4F42352A221D1A1A1B1916141412101012110F0F10
0F0D0D0F0F0D0E111110121717161D2626263E6A
8F998E83858B8B88898D8E8C8D90918F919598979697979697999A98979A9D9E9D9E9FA0
A09F9D9B9999999A9A9A9B9A989798999897969695959595949495959494949494959697
999A9C9C9B989490929A9F98836A56493E3126201D1B1A1A191614141311111212100F10
0F0D0E10100E0F121210131818171E262728406D
909A8F84868C8B87888C8D8C8D909191939798969596969697989897979A9D9D9C9D9FA0
9F9E9D9A9898999A999A9A99969597989796959696959494949494949494949595969797
97999B9C9C999492969D9D91795F4F45392C23201E1B1A1A181615151311111312101011
100E0F11100E0F131211141818171E272828416D
929B9085868C8B87888D8E8D8E919392949797959495969697989897979A9D9D9C9D9F9F
9E9E9D9A9898999A9A9A9997959597989796979897959495959494959696959696969696
96999C9E9D9A95959A9F9B886E564A41352822201E1A191A181614141310111312101011
100E0F11100E0F131211141818171E272828416E
949D9286878D8C898A8F918F8F929493949797959496989898989897989C9E9D9C9EA0A0
9F9E9D9B98989A9B9A99999796979A9B9998999997959596969595979796959595959495
979A9D9F9E9A96999FA0957D624F453C302622201D1919191715141412101112110F1011
0F0E0F11100E10131211141918181F2828294370
959F9388898F8E8B8D91928F8F9395949597979494979A99989797989A9D9E9D9C9FA1A0
9F9E9D9B98999B9B9A99999998999C9B9998999996949596949395979694939394939395
989A9D9F9D99989DA29D8A6F574941382D2522201C191818161414141210111211101011
100E1012110F1113131215191A192029292A4572
96A095898A908F8C8D91918F909496959596969495999A98969698999B9D9D9C9D9FA19F
9E9E9D9B989A9C9B9A999A9A999A9B9A9797989794939494929295969491919293929496
98999C9E9C999BA1A2957C6250463E352B24211F1B181717161414141210111212101111
100F1114131011141413161A1A1920292A2B4573
98A2978A8B91908D8E9192909296989695969595979A9A979597999B9B9C9D9D9EA0A09F
9E9F9E9B999B9C9B9A9A9B9998999A989595979693929293929395959290919393939596
97999D9F9D9B9FA49F8B705A4D453C312923211E1A171717171513131211111212111111
10101315141111151413161B1A1A212A2B2B4674
9BA5988C8C92928E8F9394929498989694959696989A999796999B9C9C9C9D9E9FA0A0A0
A0A19F9C9A9B9C9B99999998979899979596979693919393939495949191939493939596
979A9EA09D9DA3A59A8267544B42382E2723201D1A171717161413141312111312111012
12121416141112151514171B1B1B222B2B2C4877
9CA6998C8D939390919495949598989594969797989A9997979A9C9C9B9C9EA0A0A0A0A1
A1A09E9B9A9A9A9998989897989998969597979592919393939393939192939392939596
979B9F9F9DA0A7A594775E50483E332B27231F1D1A171616151314151512111212111114
15151616141213161614171C1C1C232C2C2E4978
9CA69A8C8E95959191959593949797959495979898999997989B9C9A9A9C9FA09F9F9FA0
9F9E9C999898989897979899999897959597969391929392919293939292929292949596
979B9E9D9EA5AAA38B6C554C453A302B27231F1C19161415161516171511111313131417
18161617151213161615181D1D1C232C2D2E4977
9DA79A8D8F97979291949593949697949395979898999898989A9B99999C9F9F9E9E9FA0
9F9D9B999898989898999999989796959695949291929291919294949392929293959595
979B9D9EA2AAAC9E7F60504B44382F2B28221E1C18141416171718171411121515151719
18151517161213161615181D1D1B232D2D2D4878
A0A99C8F9299989291949594949797949396999998989899999A99999A9EA09F9E9EA0A1
9F9D9B9A9999999A99999999979695959594939392929191929495949392929395959494
979B9DA0A7AEAA9473584E4B42362E2B27211D1B17131417191818171412141717161819
17141618151213161615181D1D1C242D2D2D4A7B
A1AA9D9193999892909496949597969493979998979899999898999A9C9FA09F9E9FA1A1
9E9C9B9A9998999999989898979595949494949493919192949494939291919394939293
979A9DA2ABAFA48968534E4A3F332C2A251F1C19161214181A1A19181514161818171818
17151718151213171615191D1D1D252E2D2F4D7D
A1AA9E92939897919094969594969593939698979798999897979A9B9D9FA09F9E9FA09F
9C9A9B9A9897989897969798969494949494959492909192939392929190919393919193
979A9DA5ADAD9C7E60514D473B2F2B29241E1B181411141B1E1D1B191716171818171818
17161818151213171716191E1E1D252E2F324E7D
A1AB9F91929897919094979594959593939698989798989796989C9D9E9FA09F9E9F9F9D
9B9A9B9A97979898979798989694939495959593918F9193939292929190919393919194
989A9FA8AFAA94755B4F4B44382E2B29241D1A171312192124211C1A1816161718181819
18171718151213171716191E1E1E252F30324D7C
A4AD9F92939A989190969895949596939396999997989897989B9E9E9E9FA09F9E9F9F9D
9B9B9C9A9898999998989998959494959595949390909294939292939291939492919296
999BA2ABAFA58C6D574E4A41362F2D29221C19171417212928201A191714141719181819
18171717141113171816191E1F1E252F30314D7D
A5AEA093959A9790919799959395969393979A999797999A9B9D9F9F9FA0A09F9E9F9E9C
9B9B9C9A9898999998979897959495959594949291919393929293939392939391909396
989BA3ACAD9E8366534D494036302C28211C1918181F282C261C17171513141819181718
17161717141113181816191F1F1E263030314F80
A5ADA09495999691939898949395959394989A9896989B9B9B9D9E9F9E9E9F9E9D9D9D9B
9A9B9B9A989798989796979795949494959493929292939291929393929191918F909395
979BA4ACA9977B60524D4940362F2B26211D1B1B1F252A28201714151413151819171617
171717171311141818161A1F1E1E263031345281
A4ADA19594989692949897939395959394989A9897999B9B9A9C9E9D9C9C9E9D9C9B9B9A
9A9B9C9A97979898979697979493939595949393929191919192939391908F8F8F909394
969BA5ACA690745D524E483F352E2926211E1D1F222525211A1413151413141717161517
181717161311141818171A1E1F1F273133365280
A5AFA39594999894949797949394949395999A9897999A99999C9D9C9B9D9E9D9C9B9C9B
9B9C9C9A979798989797979693939596959393929190909292929291908E8E8E8F909294
969DA7ABA18A6E5A524E473C322C2825211E1E1F2121201D171313151513141617161618
191817151312151919171A1F2021293436375280
A6B1A495949A9A95939696939293949496999A9896989A9A9A9C9D9C9D9F9F9D9C9C9D9C
9B9C9C9996979898969696959393959593929292908F9192929190908E8D8D8E8F909293
969EA7A99B826858524D4439302B2724201E1E1E1E1E1E1B16131416151314181917171A
1B1916151414171A1A181C2123232B3536375180
A7B1A394949A9A9392959693919395959799999796989B9B9B9C9D9E9F9F9D9C9C9D9C9A
9A9B9B9896969796959596959393949291919291908F9191908F8F8E8D8C8D8E8F909193
969EA6A4947A6358534C41362F2A2724211E1D1D1E1E1D1B161416181613161A1A17181C
1D1916161616171A1B1A1D2324242C3536365080
A7B1A393949B999392969692919497979798999796999D9D9B9C9E9F9D9B9B9B9C9C9A98
999B9B9896969696959696959392919190929392908F908F8E8E8F8E8D8D8E8F8F909292
959DA4A08E74625A544A3E352F2A2624221F1D1D1E1E1C1A171618191615171B1A171A1E
1D1916171816171B1B1A1D2324242B3535355081
A9B2A394959C9B93929797939296989797989997979A9D9C9B9C9E9D9A989A9C9C9B9999
9B9D9B9895969797969696939190919192939392908E8E8E8E8F8F8F8D8E8F8F8F919191
959DA39D8972635D54473B332E292625221E1C1E1E1D1B1A191819191715181A1A181B1F
1D1817181816171B1C1A1D2425252C3536365182
A9B2A394979E9B93929696939296989696989896979A9D9C9A9C9C9A97999C9E9D9B9A9B
9D9D9A97959697979695949290919293949494918F8E8E8F9090908E8E8E8F8F8F909090
959EA2998570655D524338322D282625211D1C1E1E1C1C1C1B1919191716181B1B1A1C1F
1D1817191816181D1D1B1F2627262C3636365283
A9B1A295979D9991919595929195979695979795969A9D9C9A9A9B99999C9FA09D9B9B9C
9C9B9996959697969594939291929494949493908E8E8F90908F8F8E8E8E8E8E8E8F8F90
969FA1968270655B4D3E36322D272624201C1C1F1F1E1E1E1C19191A1816191C1B1A1D20
1E19181A1916191E1E1C202727252B3636365283
A8B0A295979B9791919595919195979695969695979C9E9C999A9B9B9C9EA09F9C9A9A9C
9B9A98969696969695949493939394949493918F8E8E8F8F8F8E8D8D8D8D8D8C8D8E8F91
979F9E927F6E6357483B35312C2726241F1C1E22211F1F1E1C191A1B1817191C1B1A1E20
1E19181A19171A1E1E1C212726242B3636355182
A8B1A396979B98929295959293979997959697989A9E9F9C999B9D9E9D9EA09E9B9A9B9C
9B9A98989696969796959493939393949392908F8E8E8E8E8E8E8D8D8D8D8C8C8E8F8F91
989E9C8E7B6C6053443934302B272624201E2123211F1E1E1B1A1B1B1817191B1B1B1F21
1E19181A19171A1F1E1D212625242C3636365283
A9B2A598989D99939295969495999A979597999A9C9E9E9B999C9F9E9D9E9F9E9B9B9D9D
9B99999896959798969392929292939393918F8F8E8D8D8E8E8D8D8D8E8D8C8D8F8F8E90
979C988977685C4F4238332F2B28272521202323211E1E1E1C1A1B1A1817191B1B1C2021
1D19191B1A181C201F1D212726252D3636375384
AAB3A698989D9991919597969699999695979A9A9C9D9D9A9A9D9F9D9C9E9F9E9C9C9D9B
9898989795959797939091929392929392908F8F8E8D8D8E8E8D8D8E8E8C8B8D8F8E8C8F
969A948573665A4D403833302C2A282622222323211F1F1E1C1B1B1B19181A1C1D1E2122
1E1A1B1C1B1A1D201F1E222727262D3637385484
AAB4A798989B9790919799979698989695979A9B9B9D9D9B9B9D9F9E9C9D9F9E9D9B9A98
969798969495969591909294939293939290908F8E8D8D8E8D8C8D8E8D8B8B8D8E8C8B8F
969890817164594C3F3734312E2B292623222323211F1F1E1D1B1B1B1A191A1C1E1F2222
1F1B1B1D1C1A1D201F1E222727252D3637385384
ACB5A798979B989193999B979598999695989B9B9B9D9E9C9B9D9F9D9C9D9F9E9B999797
979898969595969491929595939293949290908F8E8C8C8D8D8C8D8E8D8B8B8D8D8B8B90
96968D7E6F62574A3F3734322E2B292623222324211F1E1E1D1C1B1B1A191A1D1F212323
1F1B1B1D1C1A1C20201E222727262D3738385385
ADB6A798989C9993959A9A969598989695999C9B9B9D9D9B9A9C9E9C9A9C9F9D99979798
98989897959595949393959593929393918F8F8F8D8B8B8D8D8C8D8D8C8A8B8D8C8A8B90
9493887A6C6055483E3734322E2B282523222424211E1E1F1E1C1C1C1A191A1E20222323
1F1B1C1E1C1A1D21201F222828272E3838385486
ADB6A798989C9994959999959497979595999B9A999B9C9A999B9C9A9A9D9F9C98979899
989898969494959493939494929192928F8E8E8E8C8A8B8D8D8C8C8C8B8A8B8C8B898A8E
928E8476695E53473D3735332F2B282624232424211F20201F1C1C1C1B191B1E21222423
1F1C1D1F1D1B1E22211F232928272E3838385587
ACB5A798979B9993939898959496979595989998999B9C9A999A9C9C9C9E9E9B98989998
979798969494959493939494929192918F8E8F8E8B8A8C8E8D8B8B8C8C8A8A8B8A88898D
8F8B8174695E53473E393634302B282624242524212020211F1D1C1D1B1A1B1E21232423
201D1E1F1D1C1E222120242928272E3838395587
ADB6A797979B99939398999593969896959899999A9C9C9A999B9E9F9E9E9E9C99989998
989899979595959594959594929192918F8F8F8E8B8A8D8E8D8B8C8D8C8A898A8987898C
8E897F74695E52463E3937342F2B282624242525222020201F1D1D1D1C1A1B1E22252624
201D1E1F1E1C1E222120242928272F3939395687
AEB6A797979C999394999A959497999695989B9B9B9D9C9A9A9EA1A09E9E9E9D9A999999
989999979595959695959593919192918F8F8F8E8B8A8D8E8C8A8B8C8A8888898887888C
8C877D72675B50463E3936332E2A272625262625221F2021201D1D1D1C191B2025272624
201E1E201E1D1F23222124292928303A3A3A5688
AEB6A798989C9993959A9A959598989595999C9B9B9C9C9B9CA0A29F9D9E9F9D9A989999
989899979494969796949291909191908F8E8E8C8A8A8C8C8A8A8B8B898788898886878A
89837A6F64594F463E3935332F2A28282828282521202123211E1E1E1C1A1D2327282624
211F2021201E20242321252B2A29303A3A3A5688
AEB6A798989C9893969A999595989895969A9C9B9B9C9E9D9EA0A19F9D9E9F9D99989898
979899979595979795929191919191908F8E8E8C8A8B8C8C8A898A8B8988898987858688
8780776D635950473F393734302C2A2B2A29272522212324211E1E1E1C1B1F2528272625
23212122201E21242322262B2A28303A3A395688
AFB7A898989C9995979B9A9695989796979B9D9B9C9EA09F9EA1A19F9E9F9F9C98979898
989999989596989793919192929191918F8E8E8D8B8B8C8C8A8A8B8B8A89898886848587
857F766D645A51473F3B3936322E2C2C2B29272523232424211F1F1F1D1C202628272727
24222222201E21242322262B2A28313A3A3A5789
AFB7A899989D9B96979B9A9695979897999C9D9C9DA0A19E9EA0A19F9D9E9E9A97969899
999A9A989696979692909292929292918F8E8E8D8B8B8B8C8A8A8B8B8A88878684838485
837D756D645A5047403C3A37332F2D2C2A28272624232424221F1F201E1E212628282828
25222122201F21242422262B2A29313B3A3B588A
AFB7A899989D9B96979B9A9695979898999C9D9D9EA09F9D9EA0A19E9C9D9D999697999A
999A9A9896969694919092939392918F8E8E8E8D8A8A8B8B8A898A8A8886858583828384
827C746C63595049433E3B38342F2D2C2A29282725242425222020201F1E212528292A29
25212122211F22252423272C2B2A323B3B3B598A
AEB7A899989D9B96979A9A9594979999999C9D9E9FA09E9D9EA0A09D9C9D9C9997999A9A
9A9A9A9895959694919192949492908E8D8E8E8C8A8A8B8A89898A8A8785858583828383
807B746C635A534C45403D39342F2D2D2C2A292826252525232020201F1E2025292B2B29
25212224222022252523272C2B2A323B3B3B5889
B0B8A999989E9D98989B9A9695989B9B9A9DA0A0A09F9F9FA0A1A09E9E9E9D9B999A9B9B
9B9B9B98969697959292949694918F8E8F8F8E8C8B8B8B8A898A8B8A8886868684838382
807B766E655D564F47413D3A342F2E2E2D2A29282624252523201F201F1E1F252B2D2D2A
26232425222123262524282C2B2A323C3B3C598A
B1B9A9999AA09F9A999C9B97969B9D9C9B9FA1A19FA0A1A1A1A1A19F9E9E9E9C9B9B9C9C
9C9C9B99979797959293959693908F90908F8E8D8C8B8A8A8A8B8B8A8987868685838382
807D776F665E574F47403D3A34302F2F2D2A29282624242523202022201D20282F32302C
28252525232224272625282D2C2C333C3C3D5A8B
B0B8A99A9BA2A09A999C9B97979C9E9B9B9FA1A09FA0A1A1A1A1A1A09E9F9F9D9C9C9D9C
9B9B9B99969696949293969592909091908F8F8E8B898A8B8B8B8B8A8987868685838282
827E776F665F584F46403D3A3531302F2D2A2A292725262724212223211E212C3435312D
29262625242224272625292E2D2C333D3D3E5A8B
AFB8A99B9DA2A099989C9B97979B9D9B9B9FA1A09FA1A2A2A1A1A1A09F9F9F9E9C9C9C9C
9B9B9B9896969695939496959391919190908F8D8A898B8C8C8B8B8B8987878785838384
837E766E6760595047423F3B363231302E2B2B2A2726272725222324211E24303737312D
29262525242324272726292E2D2C333D3D3E598A
B1BAAB9D9EA3A099999C9B97979C9D9B9CA0A3A1A0A2A4A2A1A1A2A1A0A0A09E9C9C9D9C
9C9C9B9997979796949596969391919191918F8C8A8B8D8E8C8B8C8C8A88888786838384
837D766F69625B514843403C363231312E2C2B2A2826272725222323201E25323A38322D
29262525242324272726292E2D2C333D3D3D598A
B3BBAC9E9EA3A099989C9B97999D9F9D9EA3A5A2A1A3A4A2A0A2A3A2A0A0A19F9D9D9E9E
9D9D9C9997989897959597969390909192908E8C8B8D8E8D8C8C8D8D8A88888785838384
827D76706A635A514843403B353232312E2B2A2A2724262724212223201F29383F3C342E
2A2725262524252727272A2E2E2D343E3D3E5A8C
B2BBAC9E9EA39F98979B9B999A9FA09EA0A4A4A1A0A2A3A1A0A3A4A2A0A1A2A09D9D9F9E
9D9C9B999797989694949796928F9092928F8E8D8D8D8D8C8B8C8D8C8A87878784828283
817C767069625A514943403B353332312D2B2B2A2725272926232425222330414740352E
2A2625262624252828272A2F2F2E343D3E3E5A8C
B1BAAC9E9EA29E97989D9D9B9C9FA09FA0A3A29FA0A2A3A2A2A5A5A3A1A3A3A09E9E9F9D
9C9B9B9997979896949597959190929392908F8E8D8D8C8C8C8D8E8D8A88888785838384
827D76706B645C534B45413C383534322F2D2D2B28272B2C28252728252939494B3F312A
28252527262323272827292E2E2D333D3E3E598A
B3BDAE9F9FA29E989A9FA09C9C9FA1A0A1A2A2A0A1A4A5A4A5A7A7A5A4A4A4A19E9F9F9D
9C9D9C9A9899999795979795929294949391908F8E8D8D8D8E8F908E8B89898886848686
847E78736E6860564D47433E39363533302F2E2C292A2E2E2A27292A282F404C48382A26
26252526242122272826282E2E2C333D3E3D598B
B7C0B0A09FA3A09B9CA1A09C9CA0A3A2A1A2A3A2A4A6A8A7A6A8A8A6A4A4A3A19F9F9F9E
9D9E9D9B999A99989697989694949595939191908E8E8E8F8F91918F8C8A8A8987868787
847E7A76716A61564D47433F39363534312F2F2D2B2C2F2E2927292A2B334249412F2425
27252424222023282826292F2F2D343F3E3E5B8E
B7BFAF9F9FA3A09B9CA09F9B9CA1A4A2A0A2A3A3A4A7A8A6A6A7A7A5A3A2A2A19F9E9F9E
9D9D9C9A999999979696979694949594929191908F8E8E8F9092918F8B8A8A8987878786
837F7B77716960564D47433E3937363431302F2D2C2D2F2D29272A2C2E3541443A2A2427
292523232322252A29262A30302E353F3F3F5C90
B4BCAC9E9EA29F999A9E9E9B9DA2A3A09FA1A3A3A4A7A7A5A5A6A6A4A2A2A2A19F9E9E9E
9D9C9B99989898979697979694949494929191918F8E8E909292918D8B8A8B8A88878786
837F7C77716960574E48433E3A37363432302F2E2D2E2F2D29292C2E30363F4035282629
282322242423262A29272B302F2D343F3E3F5C8F
B3BBAD9E9EA29F9A9B9F9F9D9EA3A3A09EA1A4A5A6A7A8A6A6A7A7A4A3A3A3A29F9E9E9E
9D9C9B9A9A9A99989798989795949595949392918F8E8F929493918E8C8C8C8B88878786
84817D78726A62594F48433F3B38363432312F2E2E2F2F2D2A2B2E2F30363C3C32282628
262222262624262928262A2F2E2D353F3E3E5B8D
B4BDAFA09FA2A09C9DA1A19E9FA3A3A09FA3A6A7A6A8A8A7A6A7A8A6A4A4A4A2A09F9F9F
9D9C9C9C9B9B9A999898999896959696949393918F8F92959593908E8E8D8C8A88878786
84817D79736B63594F48433F3B37353433302F2F2F2F2E2C2A2B2D2F3034393830282627
252324272624252828272A2F2F2E353F3E3E5B8E
B6BFB0A09EA3A19C9DA1A19E9FA3A39F9FA4A7A6A5A7A8A6A6A7A9A7A4A4A4A2A09F9F9E
9D9C9D9C9B9A99989797999896959696949392919091949695928F8E8D8C8B8987868686
84817D78726B63584E47423E3A373635333030302F2E2D2C2B2B2D2F303337372F272528
272526282624252828282C31302E353E3E3F5C8F
B5BEAF9E9DA2A09B9CA0A09E9FA2A19E9FA4A6A5A5A7A8A6A6A9AAA7A4A4A4A3A09F9F9E
9C9C9D9C9A99999897989A9996959696949292929292949593908E8D8C8B898886868686
84817D78726C63594E47423F3B383735333130302E2D2D2C2B2C2E2F303337372F27262A
292525272623242829282C302F2C333E3E3F5C8E
B6BEAE9E9DA2A09C9DA1A2A0A0A1A09FA0A5A7A6A7A9AAA9AAACABA8A5A5A6A3A09F9F9E
9D9D9E9C9B9A9A9A9A9B9B99969697979593949493929394928F8D8D8D8B8A8987868787
85827D79746E655A4F4743403C3937353230302F2D2C2D2D2C2D2F2F303337352D26272A
28242427252123292A282A2E2D2B343F3F3F5C8F
B8C0B09F9EA4A39FA0A4A4A1A0A2A2A1A3A7A9A9AAACADACACADACA9A6A6A6A4A09F9F9F
9E9E9F9E9D9C9C9C9C9C9B99969697979594959492919293918F8E8E8E8D8B8988878787
86827E7A7670665A4E47433F3B383534312F2E2E2D2D2E2E2D2D2E2E2F3235322B262729
262325272421242A2A27292E2E2E364140405E91
B9C1B09F9FA6A5A0A1A5A5A19FA2A4A3A4A8ABAAABADAEADACADACA9A6A6A6A3A0A0A0A0
9F9F9F9F9D9C9C9C9A999897969696969493939290909293918E8E8F8E8C8A8887878787
85827E7B766F64584D45413E3A363433312F2E2E2E2E2E2E2D2C2C2D2F3133302B272829
272627272422272C2A272A303131384141415F92
B8C0AF9EA0A7A6A0A0A5A49F9EA2A5A4A4A8ABAAABADAEADABACACA9A5A5A5A3A1A0A09F
9E9E9F9F9C9B9B9A98979797969595959493939290919293918E8E8F8E8B898887878787
86827E7A766E64584D45413E3A373533312F30302F2E2E2E2D2B2B2E2F3132302C29292B
2A2827272424282B2A272C323230374040415E91
B8BFAFA0A2A8A6A0A1A6A49F9FA4A6A4A5A9ACACACAFB0AEADAEAEAAA6A6A7A5A2A1A19F
9E9FA09E9B9A9A9997979999979696969594949392929394918F90908F8B898988888989
86837F7B777065594E46423F3B373534313031312F2D2D2D2C2B2C2E303132312D292A2C
2B2725252424272A29282C32312E364041415F92
BBC1B1A3A5AAA8A3A4A7A5A1A2A7A8A6A8ADB0AFB0B2B2B0B0B1AFAAA7A8A9A6A2A1A09F
9FA0A09E9B9B9B9A98999B9A979798989695959593939494929090918F8C8A8A8A898A89
8683807D7971675A4E45423E3A363433313030302D2B2C2D2C2B2C2F303132312D292A2C
2A2524252424272B2A292D32302F374242436295
BBC3B4A6A6ABA9A5A5A7A5A2A4A8A9A7AAAFB2B1B1B3B3B2B1B1AEAAA7A8A8A5A19FA09F
9E9F9F9D9B9B9B99989A9B99979798979594959493929393918F90918F8C8A8A8A898988
8683807D797166584C44403D39353332302F2F2E2C2B2D2E2C2B2D30303031302D2A2B2C
292524262525282C2B292E3332313A4444456396
BAC2B4A5A5AAA9A5A3A5A4A2A4A8A9A8ABB0B2B1B1B3B3B1B0AFACA9A6A7A6A39F9E9F9E
9D9D9E9D9B9A9A99999A9B99979798969494959492929393919091928F8B898A8A898887
8684817D787165574A423F3C38353331302F2F2E2C2C2E2F2C2B2D30303030302E2B2B2C
292626272726292D2C2A2F3433323A4445456294
BBC4B5A6A6ACABA5A3A6A6A4A5A9AAABADB2B4B3B3B4B5B2B0AFADAAA7A7A6A3A09F9F9E
9E9E9F9E9B9A9A9B9B9C9C9B99989897959596959493949492919393908B8A8B8B898889
8886827E7A7367584A423F3D38343231302F2F2F2D2D2E2E2B2A2D31302F30312F2B2B2C
2A2626272726292C2C2B2F3433323A4444446193
C0C9B9A9AAB0AEA6A5A9A9A7A7ABAEAEB1B5B7B6B6B7B7B4B2B1AFACA9A8A8A5A2A1A1A0
9FA0A09F9D9C9D9E9E9E9D9C99999998979798979594959593939493908C8B8C8C8A8A8A
8986827F7C74675647403E3C3732302F2F2F2F2E2C2C2D2D2A2B2F31302F31322F2B2B2D
2A2625282726292D2D2C2F3434333C4646466498
C3CBBCACACB1AEA7A6AAABA8A9AEB1B1B3B7B9B8B7B8B8B5B2B1AFACA9A8A8A5A1A0A0A0
9FA0A09F9D9D9E9E9E9D9C9A989899989697979694939494939393928E8B8A8B8B8A898A
8885817F7B726351433E3C39332F2F2F2F2F2F2E2C2C2D2D2C2D3032302F31322F2C2C2D
2A26262828272B2F2E2D313636363E484848679B
C2CBBBABAAAFACA6A6AAAAA8AAAFB2B2B3B7B9B8B7B7B7B4B1B0AEAAA7A6A6A39F9E9E9E
9D9E9F9E9C9C9D9D9B9A9998979797969596969593929494929191908C8A8A8B8A898889
8783807E7A6F5E4D413D3B37323031313130302F2D2D2E2E2D2E3132302F31322F2C2C2D
2A26262929292C2F2F2E323837363E484949679A
C3CCBBAAA9AFADA7A7ABACAAACB2B4B4B5B9BBB9B7B7B7B4B0AFADA9A6A6A5A29F9D9E9E
9D9E9F9E9C9C9D9C9B9A9A99999898979797969593939494929191908D8B8B8C8B898989
8783817F7A6E5D4C423E3B37343233333230302F2D2D2E2E2D2D2F302E2E30312E2A2B2C
292526292A292C2F2F2E333837363E494949669B
C8CFBDACADB3B1ABABB0B0AEB0B6B8B8BABEBEBBB9B9B8B4B1B0AEAAA7A7A6A39F9EA0A0
9F9FA1A09D9D9E9E9C9B9C9C9A9999999897979694949594939292918E8C8C8D8C8A8A8A
878381807A6D5C4C413D3A3733323131302E2D2C2B2B2C2C2B2B2D2D2C2D30302C292B2C
2926272A2A292C31312F33393838414B4B4B6AA0
CBD1BFB0B1B7B4AEAEB2B2B0B3B9BBBBBDBFBEBAB8B9B7B3B0AFAEA9A6A6A6A29F9FA0A0
9E9FA09F9D9D9E9E9C9B9C9C999898989796969593939393929191908D8B8B8B8A898887
8482807E776A58473D393735312F2F2E2D2B2B2A292A2B2C2B2A2C2D2D2E30302D2B2E2F
2B27292D2C2C2F343332363C3C3B444E4D4F6FA4
C8D0C0B1B1B6B3ADADB1B2B1B4BABCBCBCBDBBB8B6B6B5B1AFAEACA8A5A5A4A09D9E9E9D
9C9D9E9D9C9C9D9C9A9A9B9996959595949494949291929291908F8F8C89898A89878584
82807D7B736553433A383734302E2F2E2C2B2C2B2A2B2C2C2B2B2E2F2F303232302F3030
2C292B2F2F2E32353434393E3E3D454F4F516FA2
C9D2C2B2B1B6B4AFAEB3B5B5B7BCBFBDBBBBBAB8B6B6B5B2B0AFACA8A5A4A3A09E9E9E9D
9C9D9F9E9C9C9D9C9A9A9A989594969696969695939293939190908F8C898A8B8A868484
83807D7B736451423C3B38343130302F2D2C2D2C2B2B2C2C2B2C2F3130303233312F302F
2B292B2F2F2E31353534393E3D3C455050506DA1
D2DAC9B7B7BDBBB4B4BABCBBBDC1C3C0BDBEBEBCBAB9B9B6B3B1AEA9A6A5A4A29F9F9F9F
9E9FA1A09E9D9E9D9C9B9B999797999A9999989694949595929191908D8B8C8C8A868585
83807E7C73634F423D3B3732302F2E2C2B2B2B2928292A2A2A2C2F3030303232302E2F2E
2B292D30302F333737363B403F3F4953535372A8
DAE0CDBBBCC2BFB8B9BEC0BEBFC4C4C0BEC0C0BDBABABAB6B2AFACA8A4A4A4A19F9E9F9F
9E9FA09F9D9D9E9D9B9A9A9998999B9B9997969593939393918F908E8B898A8986838383
807D7C796F5D4A3F3A35312F2D2B2929292827272728292B2C2D30313030313231303130
2E2D30333333373C3B3A3F4546464F59585A7BB1
D7DECBBABBC1BDB6B7BDBEBCBDC1C1BDBCBDBCB8B6B7B6B2ADAAA8A4A0A0A19E9C9B9C9C
9B9C9D9C9A9B9C9B9998989797979998959292918F8F908F8D8C8C8B8886868582807F7E
7C7A78746856453B3632302F2C29282929282728292A2C2E2F3032333231333534343434
3130333737373B3F3E3E434A4948505B5C5D7CB0
D5DDCBBABBC0BDB7B8BEBFBDBEC2C1BDBBBCBBB8B6B7B6B0ABAAA8A39FA0A19F9C9B9C9C
9B9C9D9D9C9C9D9B999999999797989693919191909090908E8C8D8C8886868683807F7E
7D7B79736656473D383634322D29292A292728292A2B2D2F2F2F31323131343636353434
3130333737373A3E3F3F44494847505C5C5C79AE
E6ECD7C6C6CCC8C2C4CACAC7C8CBCAC5C3C4C3C0BEBFBCB6B1B0ADA8A5A6A7A4A1A1A2A1
A0A1A3A3A2A1A1A09E9E9E9D9A9A9B9996949596949494939190918F8C89898986838182
817F7B746858493F3B38332D27232323222223252626282A2A2A2D2E2E2F333635323232
302F343838383C414242474C4C4D5863626385BD
FFFFE8D6D6DBD7D0D2D6D5D2D2D4D2CCCACBCAC6C4C2BFB8B4B2AEA9A7A9A9A5A2A2A3A2
A0A2A4A4A1A1A19F9E9D9D9A9898999794939495939292918E8D8D8B88858585817D7D7D
7C78736C604F3F36302A221A1413151617191C1E1F21242627292C2F3032363837353536
36373D414142494E4E4E555D5E606B75757AA1D9
FFFDE7D6D7D9D4CECED1CFCCCCCCC9C4C1C1BFBBB7B5B1ABA7A4A19D9C9D9C9895969694
939698969393939291908E8C8A8B8B8885858787848383817E7D7D7B77757574706C6A6A
67625D554836281F1810080305090E13171B1F2124272C2F3033373A3B3E424342424345
45484E5152555B5F5F626B7271737D888B93B4E2
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00Woo16mk0VLi25kg35[F1UJe1U:D1Tic14YB14Ha348@2Sg_148@3Sg_53W>33F]
2C6<12e[1RU:12DY0R480QcW0QBU0PaS0PQ210@Q10000P@Q0PQ210aS0Q2411BU1QS61QcW124822DY
3RU:1Re[1S6<13F]13W>1Sg_0T8@1TYB0U:D0V<H1Goo0@000Goo000=Ool01000Oomoo`0017oo00<0
07ooOol00Woo16mk0VLi25kg35[F1UJe1U:D1Tic14YB14Ha348@2Sg_148@3Sg_53W>33F]2C6<12e[
1RU:12DY0R480QcW0QBU0PaS0PQ210@Q10000P@Q0PQ210aS0Q2411BU1QS61QcW124822DY3RU:1Re[
1S6<13F]13W>1Sg_0T8@1TYB0U:D0V<H1Goo0@000Goo000>Ool20005Ool00`00Oomoo`02Ool2CW<4
DY@2CW<2BU82CW<<BU88AS48@Q08?Nl8>Lh4=Jd2>Lh<=Jd4>Lh6=Jd2>Lh6=Jd6<H`4=Jd@<H`;;F/6
:DX89BT48@P27>L26<H25:D436<6248236<248@25:D46<H67>L68@P89BT::DX@;F/:<H`4=Jd:>Lh2
@Q04AS44?Nl2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9>L`ABU09>L`9:DP9>L`a:DPQ6<@Q2
40Pmk`PicP@e[@8icP`e[@@icPHe[@8icPHe[@HaS0@e[A0aS0/]J`HYBPPU:@@Q208Li`8HaP8DY@@<
H`H8@P8<H`8@Q08DY@@HaPHLi`HQ20PU:@XYBQ0]J`XaS0@e[@XicP9240A6<@@mk`9240Eoo`40005o
o`005Goo00<007ooOol00Woo0SW>14Ha13g_1T8@0Sg_148@4Sg_23W>93F]0SW>13F]136<43F]436<
2Be[0RU:12DY0RU:12DY12480QcW0QS621BU0QS61QcW22482RDY3RU:1Re[0RU:2Re[136<0Re[136<
0SF]136<13F]1SW>0SF]0RU:0QcW0RDY1Goo0@000Goo000EOol00`00Oomoo`02Ool2>Lh4AS44?Nl6
@Q02?Nl4@Q0B?Nl8>LhT=Jd2>Lh4=Jd4<H`@=Jd@<H`9;F/2:DX49BT2:DX49BT48@P27>L26<H85:D2
6<H67>L88@P:9BT>:DX6;F/2:DX:;F/4<H`2;F/4<H`2=Jd4<H`4=Jd6>Lh2=Jd2:DX27>L29BT5Ool1
0001Ool001Eoo`03001oogoo009oo`8icP96<@9240@mk`A240@mk`A240@mk`9240`mkaPicP@e[A@i
cPPe[@HicQHe[@TaS08]J`@YBPH]J`@YBP8U:@8Q208Li`PHaP@Li``Q210U:A8YBQ0]J`@aS0@]J`He
[@8aS08YBP8Q208@Q08<H`8Q20Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0THa0T8@13g_148@
13g_148@13g_0T8@33g_63W>13F]53W>23F]1SW>5SF]2C6<0Re[12U:1Re[12U:0RDY0R480QcW21S6
11cW324842DY4RU:42e[136<12e[1SF]0S6<0RU:0R480Q240PaS0R481Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl4AS44?Nl4@Q04?Nl4@Q04?Nl4@Q0:?NlH>Lh2=JdD>Lh8=Jd6>LhH=Jd9<H`2;F/2
:DX8;F/4:DX29BT28@P47>L66<H87>L88@P@9BT::DXH;F/8<H`4=Jd2;F/28@P26<H248@2124236<2
:DX5Ool10001Ool001Eoo`8000=oo`8mk`A6<@@mk`A240@mk`A240@mk`A240XmkaPicP8e[A@icPPe
[@HicQPe[@TaS08]J`8YBPP]J`@YBP8U:@8Q20@Li`HHaPPLi`PQ210U:@XYBQP]J`PaS0@e[@8]J`8Q
208HaP8@Q0848@8<H`8YBPAoo`80005oo`005Goo00<007ooOol00Woo0Sg_0THa0T8@63g_83W>23F]
0SW>13F]2SW>23F]13W>4SF]136<13F]1c6<0Re[12U:0Re[0S6<12e[1RU:124811cW0QS611cW2248
1RDY12U:12DY22U:12e[0RU:52e[136<0Re[1S6<1SF]0Re[0QcW0Q240PaS0PQ20P@Q0Q240RU:1Goo
0@000Goo000EOol00`00Oomoo`02Ool2?Nl2AS42@Q0H?NlP>Lh8=Jd2>Lh4=Jd:>Lh8=Jd4>LhB=Jd4
<H`4=Jd7<H`2;F/4:DX2;F/2<H`4;F/6:DX48@P47>L26<H47>L88@P69BT4:DX49BT8:DX4;F/2:DXD
;F/4<H`2;F/6<H`6=Jd2;F/27>L248@236<22482124248@2:DX5Ool10001Ool001Eoo`03001oogoo
009oo`8icP92408mk`@icP@mk`@icP@mkb8icP@e[@8icPHe[@@icP@e[@PicPPe[@@icR4e[@8aS0H]
J`HaS0H]J`8YBP8U:@@Q20HLi`@Q20PU:A8YBP`]J`@aS0`]J`8aS0@]J`8aS0@e[@8aS08]J`8U:@8L
i`8<H`@48@88@P848@8@Q08U:@Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0T8@0Sg_13W>13g_
13W>13g_8SW>13F]0SW>1SF]13W>13F]23W>23F]13W>8CF]0S6<1Re[1S6<1Re[0RU:0RDY12481QcW
124822DY4RU:32e[136<32e[0S6<12e[0S6<13F]0S6<0Re[0RDY0QcW0PaS10@Q0PQ20P@Q0Q240RDY
1Goo0@000Goo000EOol00`00Oomoo`02Ool2?Nl2@Q02?Nl4>Lh4?Nl4>Lh4?Nl4>Lh4?Nl4>Lh4?NlJ
>Lh2=Jd6>Lh4=Jd8>Lh8=Jd>>Lh2=Jd4>Lh6=Jd4>Lh7=Jd2<H`4;F/2<H`4=Jd6<H`4;F/2:DX29BT:
8@P89BTD:DX<;F/2<H`B;F/4<H`2=Jd2<H`2:DX28@P25:D22484000212422482124248@2:DX5Ool1
0001Ool001Eoo`03001oogoo009oo`8mk`92408mk`@icP@mk`@icP@mk`@icP@mk`@icP@mkaXicP8e
[@HicP@e[@PicPPe[@hicP8e[@@icPHe[@@icPLe[@8aS0@]J`8aS0@e[@HaS0@]J`8YBP8U:@XQ20PU
:A@YBP`]J`8aS18]J`@aS08e[@8aS08YBP8Q208DY@88@P@000848@88@P848@8@Q08YBPEoo`40005o
o`005Goo00<007ooOol00Woo0Sg_0THa0T8@13W>13g_13W>3Sg_0SW>13g_63W>13F]13W>13F]2SW>
1SF]5SW>13F]1SW>0SF]0cW>0SF]0S6<0Re[0S6<1SF]1S6<12e[0RU:0RDY224822DY4RU:42e[0S6<
3Re[136<13F]0S6<0RU:0QcW0Q240PQ20P@Q0P000P@Q1PQ20QBU0RU:1Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl2AS42@Q04>Lh4?Nl4>Lh>?Nl2>Lh4?NlH>Lh4=Jd4>Lh4=Jd:>Lh6=JdF>Lh4=Jd6
>Lh2=Jd3>Lh2=Jd2<H`2;F/2<H`6=Jd6<H`4;F/2:DX29BT88@P89BTB:DX@;F/2<H`>;F/4<H`4=Jd2
<H`2:DX27>L248@2248212420002124624825:D2:DX5Ool10001Ool001Eoo`03001oogoo009oo`8m
k`92408mk`@icP@mk`@icP@mk`@icP8mka@icP8e[@@icP@e[@8icPPe[@8icP@e[@PicPHe[APicP8e
[@HicP@e[@8icP03=JdaS36<008]J`@aS0@e[@PaS0@]J`8YBP@U:@@Q20HU:A8YBQ8]Ja8aS0He[@8a
S08U:@8HaP8<H`H48@8000848@H8@P8DY@8YBPEoo`40005oo`005Goo0P000goo0Sg_0T8@0Sg_13W>
13g_13W>13g_13W>0Sg_53W>0SF]13W>13F]0SW>23F]0SW>13F]23W>1SF]63W>0SF]1SW>13F]0SW>
00<e[C6<<H`00Re[136<13F]236<12e[0RU:12DY12481RDY4RU:4Re[4S6<1SF]0S6<0RDY0QS60PaS
1P@Q0P000P@Q1PQ20QBU0RU:17oo0P000Goo000EOol00`00Oomoo`02Ool2?Nl2@Q02?Nlj>Lh2=Jd@
>Lh4=JdR>Lh2=Jd4>Lh00cF]<H`aS004<H`6=Jd:<H`2;F/4:DX89BTB:DX>;F/H<H`6=Jd2;F/29BT2
6<H236<2124200041244000624825:D2:DX5Ool10001Ool001Eoo`03001oogoo009oo`8mk`92408m
kcXicP8e[A0icP@e[B8icP8e[@@icP03=JdaS36<00@aS0He[@XaS08]J`@YBPPU:A8YBPh]JaPaS0He
[@8]J`8U:@8HaP8<H`848@8000@48@@000H8@P8DY@8YBPEoo`40005oo`005Goo00<007ooOol00Woo
0Sg_0THa0Sg_13W>13g_13W>13g_3SW>0Sg_;3W>0SF]2SW>1Sg_6SW>00<e[C6<<H`00S6<43F]136<
12e[4RU:52e[5S6<1SF]0S6<0Re[0R480QBU0PQ20P@Q30001PQ20QBU0RU:1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2?Nl2AS42?Nl4>Lh4?Nl4>Lh4?Nl>>Lh2?Nl/>Lh2=Jd:>Lh6?NlJ>Lh00cF]<H`a
S002<H`@=Jd4<H`4;F/B:DXD;F/F<H`6=Jd2<H`2;F/28@P25:D22482124<000624825:D2:DX5Ool1
0001Ool001Eoo`03001oogoo009oo`924096<@9240@icP@mk`@icPHmk`XicP@mkb0icP8e[@@icP8m
k``icPPmkaXicP<e[@8aS0@e[@8icPhe[@@aS08]Ja8YBQ@]Ja8aS0@e[@8icP8e[@8aS08YBP8Li`8@
Q0H48@X000848@H8@P8DY@8]J`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@0THa0T8@13W>13g_
13W>1Sg_2SW>13g_83W>0SF]13W>0Sg_33W>23g_6SW>0cF]0S6<13F]0SW>3SF]136<0Re[4RU:52e[
4S6<13F]0SW>0SF]0S6<0RU:0QcW0Q241P@Q2P000P@Q1PQ20QBU0Re[1Goo0@000Goo000EOol00`00
Oomoo`02Ool2@Q02AS42@Q04>Lh4?Nl4>Lh4?Nl`>Lh2=Jd@>Lh8?NlL>Lh7=Jd4>Lh4=Jd4>Lh6=Jd4
<H`2;F/::DXH;F/D<H`2=Jd4>Lh2=Jd2<H`29BT26<H248@22486124:0002124624825:D2;F/5Ool1
0001Ool001Eoo`03001oogoo009oo`924096<@9240@icP@mk`@icP@mkc0icP8e[A0icPPmka`icPLe
[@@icP@e[@@icPHe[@@aS08]J`XYBQP]Ja@aS08e[@@icP8e[@8aS08U:@8HaP8@Q088@PH48@X00084
8@H8@P8DY@8]J`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@0THa0Sg_13W>13g_13W>13g_@3W>
3Sg_5SW>1cF]3SW>23F]0S6<12e[1RU:62e[4S6<13F]1SW>0S6<0RDY0QS60PaS0PQ20P@Q0P000P@Q
30000P@Q1PQ20QBU0Re[1Goo0@000Goo000EOol20003Ool2@Q02AS42?Nl4>Lh4?Nl4>Lh4?Nm0>Lh>
?NlF>Lh7=Jd>>Lh8=Jd2<H`4;F/6:DXH;F/B<H`4=Jd6>Lh2<H`29BT26<H236<2248212420002124<
0002124624825:D2;F/4Ool20001Ool001Eoo`03001oogoo009oo`924096<@92408icPHmk`@icP@m
k`@icPHmk`@icP@mk`8icP@mkbHicPHmk`8icPPmkb/icPXe[@8aS18]J`@aS0H]J`8aS08]Ja0aS0@e
[@8icP8mk`8icP8aS08U:@8DY@8<H`88@P@48A0000848@H8@P8HaP8]J`Eoo`40005oo`005Goo00<0
07ooOol00Woo0T8@0THa0T8@0SW>1Sg_13W>13g_13W>1Sg_13W>13g_0SW>13g_9SW>1Sg_0SW>23g_
:cW>2SF]0S6<4Re[136<1Re[0S6<0Re[436<13F]0SW>0Sg_0SW>0S6<0RDY0QBU0PaS0PQ210@Q4000
0P@Q1PQ20QS60Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42BU82@Q04?Nl2@Q02?Nl2>Lh@
?Nl2>Lh<?NlH>Lh4=Jd8>LhR?NlS>Lh2=Jd2<H`:;F/4<H`4;F/4<H`6;F/B<H`4=Jd4?Nl2>Lh2<H`2
8@P25:D236<22484124<000412420002124636<26<H2<H`5Ool10001Ool001Eoo`03001oogoo009o
o`96<@9:DP9240@mk`92408mk`8icQ0mk`8icP`mkaPicP@e[@PicR8mkb<icP8e[@8aS0X]J`@aS0@]
J`@aS0H]Ja8aS0@e[@@mk`8icP8aS08Q208DY@8<H`88@P@48@`000@48@8000848@H<H`8HaP8aS0Eo
o`40005oo`005Goo00<007ooOol00Woo0THa0TYB0T8@63g_13W>33g_53W>13F]2SW>93g_23W>0cg_
63W>0SF]0S6<22e[1S6<12e[136<12e[2S6<2SF]0SW>1Sg_0S6<0R480QBU0PaS0PQ21P@Q30001P@Q
0PQ21PaS0QcW0S6<1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42BU82@Q0H?Nl4>Lh<?NlD>Lh4
=Jd:>LhT?Nl8>Lh3?NlH>Lh2=Jd2<H`8;F/6<H`4;F/4<H`4;F/:<H`:=Jd2>Lh6?Nl2<H`28@P25:D2
36<22486124<00061242248636<27>L2<H`5Ool10001Ool001Eoo`03001oogoo009oo`96<@9:DP92
418mk`8icP@mk`@icP`mkb0icR@mk`PicPDmk`@icPhmk`HicP8e[@@aS0@]J`PaS08]Ja0aS0`e[@8i
cPHmk`8aS08U:@8DY@@<H`88@PH48@`000P48@H<H`8Li`8aS0Eoo`40005oo`001goo10000goo0P00
1Goo00<007ooOol00Woo0THa0TYB0T8@4Sg_0SW>13g_13W>33g_83W>93g_23W>1Cg_13W>3Sg_1SW>
0SF]136<12e[236<0Re[436<33F]0SW>1Sg_0S6<0RDY0QBU10aS0PQ21P@Q300020@Q1PaS0QcW0S6<
1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Woo0THa0TYB0THa
13g_0T8@8Sg_6SW>13F]0SW>0Sg_0T8@3Sg_148@3Sg_1SW>6Cg_1SW>13F]6S6<43F]0SW>13g_0SW>
0S6<0RDY0QS610aS0PQ220@Q30001P@Q0PQ21PaS0QcW0SF]1Goo0@000Goo0008Ool00`00Oomoo`02
Ool01000Oomoo`0017oo0P000goo0THa0TYB0THa13g_0T8@8Sg_6SW>13F]0SW>0Sg_0T8@3Sg_148@
3Sg_1SW>6Cg_1SW>13F]6S6<43F]0SW>13g_0SW>0S6<0RDY0QS610aS0PQ220@Q30001P@Q0PQ21PaS
0QcW0SF]17oo0P000Goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo
0TYB0Tic0THa13g_0T8@1Sg_148@63g_3SW>0Sg_1SW>0SF]136<0SF]0Sg_148@2Sg_1T8@43g_0SW>
7Cg_1SW>13F]5S6<4SF]0SW>13g_0SW>0S6<0RDY0QS60Q241PQ20P@Q0P000P@Q3P001P@Q0PQ210aS
0Q240QcW0SF]1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009o
o`9:DP9>L`96<@@mk`9240Hmk`A241Pmk`hicP8mk`HicP8e[@@aS08e[@8mk`A240Xmk`I2410mk`8i
cQdmk`HicP@e[AHaS18e[@8icP@mk`8icP8aS08U:@8HaP8@Q0H8@P848@8000848@h000H48@88@P@<
H`8@Q08Li`8e[@Eoo`40005oo`0027oo0P0017oo0P001Goo00<007ooOol00Woo0TYB0Tic0THa13g_
0T8@1Sg_148@6Sg_0SW>0Sg_33W>13F]0S6<0Re[0S6<0SW>748@43g_0T8@6cg_13W>13F]3S6<53F]
13W>13g_0SW>0S6<0RDY0QcW0Q240PaS10Q210@Q0P0010@Q2P0020@Q0PQ21Q240R480SF]1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2BU82CW<2AS44?Nl2@Q06?Nl4@Q0J?Nl2>Lh2?Nl<>Lh4=Jd2<H`2
;F/2<H`2>LhL@Q0@?Nl2@Q0K?Nl4>Lh4=Jd><H`D=Jd4>Lh4?Nl2>Lh2<H`29BT27>L248@236<42484
12420004124:00081242248648@28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>L`96
<@@mk`a240hmk`Q240Pmk`XicP@e[@HaS08e[@8mk`96<@9:DPI6<A9240@mk`9240Pmk`U241Pmk`@i
cR0e[@HicPHmk`8e[@8YBP8Li`8DY@8<H`H8@PX48@@000P48@H8@P8<H`H@Q08Q208e[@Eoo`40005o
o`005Goo00<007ooOol00Woo0TYB0Tic0THa13g_348@3Sg_248@23g_2SW>13F]1S6<0SF]0Sg_0THa
0TYB1THa4T8@13g_0T8@23g_2D8@63g_13W>83F]1SW>1Sg_0SF]0RU:0QcW0QBU0PaS1PQ22P@Q1000
20@Q1PQ20PaS1Q240R480SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82CW<2BU84@Q04AS48
@Q04?Nl8@Q04AS46@Q04?Nl:>Lh6=Jd8<H`2>Lh2@Q06BU82AS44@Q04?Nl4@Q04AS42@Q06?Nl2@Q06
?NlM@Q08?Nl2>LhF=Jd<>Lh4?Nl2@Q02?Nl2>Lh2;F/28@P25:D248@236<6248:1244000812462482
36<648@28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>L`9:DPA240A6<@Q240@mk`Q2
40A6<@I240@mk`XicPHe[@PaS08icP9240I:DP96<@A240@mk`A240A6<@9240Hmk`9240Hmkae240Pm
k`8icQHe[@`icP@mk`92408mk`8icP8]J`8Q208DY@8@Q08<H`H8@PX48@@000P48@H8@P8<H`H@Q08Q
208e[@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB148@14Ha348@1THa1T8@13g_13W>
2SF]236<1Re[0S6<0SW>0T8@14ic0TYB0T8@23g_0T8@0THa0TYB0T8@0Sg_13W>2Sg_2d8@13g_148@
13g_148@23g_13W>53F]3SW>0Sg_0T8@0Sg_0SW>0S6<0RDY0QS60Q2410aS1PQ220@Q1P0020@Q1PQ2
0PaS1Q240R480SW>1Goo0@000Goo000EOol20003Ool2BU82CW<2BU84@Q04AS4<@Q06AS46@Q04?Nl4
>Lh:=Jd8<H`6;F/2<H`2>Lh2@Q04CW<2BU82@Q08?Nl2@Q02AS42BU82@Q02?Nl4>Lh:?Nl;@Q04?Nl4
@Q04?Nl4@Q08?Nl4>LhD=Jd>>Lh2?Nl2@Q02?Nl2>Lh2<H`29BT26<H248@436<62488124600081246
248236<648@28@P2>Lh4Ool20001Ool001Eoo`03001oogoo009oo`9:DP9>L`9:DPi24096<@Q240@m
k`@icP8e[@@aS18]J`@YBP8U:@8YBP8aS08mk`9:DP9BU09>L`9240HicP8mk`9240A:DP96<@8icP8e
[@8icP8mk`A240Hmk`Q241/mk`HicQ0e[@hicP8mk`A2408icP8aS08U:@8HaP8@Q0H<H`@8@PH48@80
00@48@@000P48@H8@P8<H`H@Q08Q208icPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB
3T8@0THa248@13g_13W>0SF]136<4Re[12U:0RDY0RU:0S6<0Sg_0TYB0U:D0Tic0T8@1SW>0Sg_0T8@
14YB0THa0SW>0SF]0SW>0Sg_148@1Sg_248@6cg_1SW>43F]3SW>0Sg_148@0SW>0S6<0RDY0QS60Q24
1PaS10Q21P@Q0P0010@Q100020@Q1PQ20PaS1Q240R480SW>1Goo0@000Goo000EOol00`00Oomoo`02
Ool2BU82CW<2AS44?Nl<@Q02?Nl4>Lh2=Jd4<H`4;F/J:DX29BT2:DX2<H`2?Nl2CW<4E[D2CW<2@Q02
>Lh2?Nl2@Q02AS44BU82AS42?Nl2=Jd2>Lh2?NlB@Q0G?Nl4@Q04?Nl6>Lh6=Jd4>Lh2=Jd>>Lh2?Nl4
@Q02?Nl2=Jd2:DX27>L248@836<2248612440004124400081246248236<648@27>L2=Jd5Ool10001
Ool001Eoo`03001oogoo009oo`9:DP9>L`96<@@mk`a2408mk`@icP8e[@@aS0@]JaXYBP8U:@8YBP8a
S08mk`9>L`AF]@9>L`92408icP8mk`924096<@A:DP96<@8mk`8e[@8icP8mka9241Lmk`A240@mk`Hi
cPHe[@@icP8e[@hicP8mk`A2408mk`8e[@8YBP8Li`8@Q0P<H`88@PH48@@000@48@@000P48@H8@P8<
H`H@Q08Li`8e[@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0THa148@14Ha0T8@13g_0SW>
0SF]0S6<12e[0RU:0RDY3RU:42e[0S6<0SW>0THa0U:D15kg0U[F0TYB0T8@0Sg_0THa1TYB0THa0T8@
13W>0Sg_0T8@14Ha5D8@0Sg_548@13g_1SW>0SF]4SW>13g_148@0Sg_0SF]0RU:0QcW0QBU20aS10Q2
10@Q1P0010@Q100020@Q1PQ20PaS1Q240QcW0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82
CW<2AS44@Q04AS42@Q04?Nl2>Lh2=Jd2<H`4;F/2:DX29BT>:DX@;F/2<H`2>Lh2AS42DY@4G_L2F]H2
BU82@Q02?Nl2AS46BU82AS42@Q04>Lh2?Nl2@Q04AS4E@Q02?NlD@Q04?Nl6>Lh2=JdB>Lh4?Nl4@Q02
?Nl2=Jd2:DX27>L25:D836<4248412460004124400081246248236<648@27>L2=Jd5Ool10001Ool0
01Eoo`03001oogoo009oo`9:DP9>L`9:DPA24096<@92408mk`@e[@8]Ja0YBPH]J`haS0@e[@8icP8m
k`9:DP9F]@9Nm`9S609Nm`9BU096<@A240A:DPA6<@92408mk`8icP8mk`9240A6<Be240@mka@icP8m
k`8icP@mk`I2408icP8]J`8Q208DY@8@Q0H<H`@8@PH48@@000H48@@000P48@H8@P8<H`H@Q08Q208i
cPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB148@0THa0T8@0Sg_13F]0Re[42U:1Re[
3S6<13F]0SW>0Sg_0TYB0UJe0Ukg0V<H0Ukg0U:D0THa148@14YB14Ha0T8@0Sg_0SW>0Sg_0T8@14Ha
;D8@13g_53W>0Sg_0SW>13g_1T8@0SW>0Re[0R480QBU0Q241PaS10Q21P@Q10001P@Q100020@Q1PQ2
0PaS1Q240R480SW>1Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2DY@2BU82@Q04?Nl2>Lh2<H`2
;F/4:DX29BT::DX6;F/6<H`:=Jd2>Lh4?Nl2@Q02BU82DY@2E[D4F]H2DY@2BU82@Q02?Nl2@Q04AS42
@Q08?Nle@Q04?Nl@>Lh:?Nl6@Q02>Lh2<H`29BT26<H448@436<6248@1242000:1246248236<648@2
8@P2>Lh5Ool10001Ool001Eoo`8000=oo`9>L`9BU09:DP9240@mk`8icP8aS08]J`@YBP8U:@XYBPH]
J`HaS0Xe[@8icP@mk`92409:DP9BU09F]@AJeP9BU09:DP92408mk`9240A6<@9240PmkcE240@mka0i
cPXmk`I2408icP8aS08U:@8HaP@@Q0@<H`H8@Q048@8000X48@H8@P8<H`H@Q08Q208icPAoo`80005o
o`005Goo00<007ooOol00Woo0TYB0Tic0T8@0SF]136<0Re[12DY22U:22e[236<23F]13W>13g_148@
0THa0TYB0Tic15:D0Tic0TYB0T8@13g_148@1Sg_>d8@1Sg_33W>2Sg_0T8@0THa0T8@0Sg_0SF]0RU:
0QcW0QBU0Q2410aS1PQ24P@Q0P002P@Q1PQ20PaS1Q240R480SW>1Goo0@000Goo000EOol00`00Oomo
o`02Ool2BU82CW<2@Q02=Jd4<H`2;F/49BT8:DX8;F/8<H`8=Jd4>Lh4?Nl4@Q02AS42BU82CW<4DY@2
CW<2BU82@Q04?Nl4@Q06?Nlk@Q06?Nl<>Lh:?Nl2@Q02AS42@Q02?Nl2=Jd2:DX27>L25:D248@436<6
248B1242000:1246248236<648@28@P2>Lh5Ool10001Ool001Eoo`03001oogoo009oo`A6<@8icP8]
J`8YBP8]J`8YBP8U:@8YBQ0]J`8aS0He[@XicP@mk`A240A6<@Y:DP96<@9240@mk`Y24096<@I240a6
<@9240I6<@A24096<A]240Hmk`HicP`mk`A24096<@92408icP8]J`8Q208HaP8@Q0@<H`P8@Q848@80
00X48@H8@P8<H`H@Q08Q208e[@Eoo`40005oo`005Goo00<007ooOol00Woo14Ha0SW>0Re[0RU:0Re[
0RU:0RDY0RU:42e[0S6<1SF]2SW>13g_148@14Ha2TYB0THa0T8@13g_2T8@0THa1T8@34Ha0T8@1THa
148@0THa6d8@1Sg_1SW>33g_148@0THa0T8@0SW>0Re[0R480QS60Q2410aS20Q24P@Q0P002P@Q1PQ2
0PaS1Q240R480SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool4?Nl2<H`4:DX8;F/4<H`4;F/6<H`4
=Jd6>Lh:?Nl6@Q08AS44BU82CW<2BU82AS46@Q0<AS42@Q0HAS42@Q05AS44@Q02AS46@Q0<AS44@Q06
?Nl2>Lh<?Nl4@Q04AS42?Nl2<H`29BT26<H248@436<6248R1246248236<248@236<248@27>L2<H`5
Ool10001Ool001Eoo`03001oogoo009oo`@mk`8aS0@YBPP]J`@aS0@]J`HaS0@e[@HicPXmk`I240Q6
<@A:DP9>L`9:DP96<@I240a6<@9241Q6<@9240E6<@A24096<@I240a6<@A240Hmk`8icP`mk`A240A6
<@8mk`8aS08U:@8HaP8@Q0@<H`H8@R848@H8@P8<H`8@Q08<H`8@Q08Li`8aS0Eoo`40005oo`005Goo
00<007ooOol00Woo13W>0S6<0Re[536<13F]13W>3Sg_1T8@24Ha14YB14ic0TYB?DHa0T8@44Ha148@
43g_0T8@1THa0T8@0SF]0RU:0QcW0QBU0Q2410aS1PQ28P@Q1PQ21PaS0Q240QcW0Re[1Goo0@000Goo
000EOol00`00Oomoo`02Ool4>Lh2<H`2;F/D<H`4=Jd4>Lh>?Nl6@Q08AS44BU84CW<2BU8mAS42@Q0@
AS44@Q0@?Nl2@Q06AS42@Q02=Jd2:DX27>L25:D248@436<6248R1246248636<248@27>L2;F/5Ool1
0001Ool001Eoo`03001oogoo009oo`@icP8e[@@aS08e[@8aS0@]J`HaS0@e[@HicPPmk`Y240Y6<@I:
DP9>L`I:DQA6<@9:DSM6<@A240hmk`9240A6<@9:DP96<@8icP8]J`8Q208DY@8@Q0@<H`H8@R@48@P8
@P@<H`8@Q08HaP8]J`Eoo`40005oo`005Goo0P000goo13W>0SF]136<0SF]0S6<12e[1S6<13F]1SW>
23g_2T8@2THa1TYB0Tic1TYB54Ha0TYB=dHa148@3Sg_0T8@14Ha0TYB0THa0SW>0Re[0R480QBU0Q24
10aS1PQ290@Q20Q210aS0Q240QS60Re[17oo0P000Goo000EOol00`00Oomoo`02Ool2>Lh2?Nl2=Jd4
<H`2=Jd6<H`6=Jd6>Lh6?Nl>@Q08AS4DBU86AS4>BU86AS44BU8:AS42BU8IAS44BU84AS46@Q04?Nl8
@Q02AS44BU82AS42?Nl2<H`29BT26<H448@436<6248T1248248436<248@26<H2;F/5Ool10001Ool0
01Eoo`03001oogoo009oo`8icP8mk`8e[@@aS08e[@HaS0He[@HicPHmk`i240Q6<AA:DPI6<@i:DPI6
<@A:DPY6<@9:DQU6<@A:DPA6<@I240@mk`Q24096<@A:DP96<@8mk`8aS08U:@8HaP@@Q0@<H`H8@R@4
8@P8@P@<H`8@Q08HaP8]J`Eoo`40005oo`005Goo00<007ooOol00Woo13g_0SW>0S6<2SF]23W>1Sg_
2T8@2THa44YB1Tic5TYB14Ha24YB1THa1TYB4dHa2TYB1THa448@0THa14YB0T8@0SF]0RU:0QcW0QBU
0Q2410aS20Q210@Q0PQ27P@Q1PQ21PaS0Q240QcW0Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool4
?Nl2>Lh2<H`:=Jd8>Lh6?Nl:@Q0:AS4@BU86CW<FBU84AS48BU86AS46BU8CAS4:BU86AS4@@Q02AS44
BU82@Q02=Jd2:DX27>L25:D248@436<824841242248N1246248636<248@27>L2;F/5Ool10001Ool0
01Eoo`03001oogoo009oo`8mk`92408icP@e[@@icP8e[@@icPPmk`Q24116<@i:DPQ>Lbi:DP]6<@9:
DPA6<@i:DPA6<@i24096<@A:DP96<@8mk`8aS08Q208HaP@@Q0@<H`h8@Qh48@H8@P8<H`H@Q08Li`8a
S0Eoo`40005oo`005Goo00<007ooOol00Woo0Sg_0T8@0SW>13F]13W>0SF]13W>23g_248@44Ha3TYB
24ic;TYB2dHa0TYB14Ha3TYB14Ha3T8@0THa14YB0THa0Sg_0S6<0R480QS6112410aS3PQ27P@Q1PQ2
0PaS1Q240QcW0S6<1Goo0@000Goo000EOol00`00Oomoo`02Ool2?Nl2@Q02>Lh4=Jd8>Lh8?Nl8@Q0@
AS4@BU8:CW<ZBU86AS4MBU84AS48@Q04AS46BU82@Q02=Jd2:DX27>L25:D248@636<>248N12462482
36<648@27>L2;F/5Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`8mk`92408icP@e
[@PicPPmk`Q24116<A1:DPY>LbY:DPI6<Ae:DPA6<@Q240A6<@I:DP92408e[@8YBP8Li`8DY@8@Q0H<
H`h8@Qh48@H8@P8<H`H@Q08Li`8]J`Eoo`40005oo`002Woo00@007ooOol0009oo`03001oogoo009o
o`03001oogoo009oo`8mk`92408mk`8e[@XicPHmk`Y24116<A1:DPa>Ld]:DPQ6<@9240A6<@9:DP9>
L`9:DP96<@8icP8]J`8Q208HaP8DY@8@Q0H<H`P8@P@48@88@Qh48@H8@P8<H`H@Q08Li`8]J`Eoo`40
005oo`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`8mk`92408mk`8e[@XicPHmk`Y24116<A1:
DPa>Ld]:DPQ6<@9240A6<@9:DP9>L`9:DP96<@8icP8]J`8Q208HaP8DY@8@Q0H<H`P8@P@48@88@Qh4
8@H8@P8<H`H@Q08Li`8]J`Aoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool2?Nl2@Q02?Nl4>Lh8?Nl:@Q02AS42@Q0:AS4BBU8DCW=9BU88AS42@Q02AS42BU84CW<2
BU82?Nl2<H`29BT27>L25:D248@636<:24841242248N1246248236<648@27>L2<H`5Ool10001Ool0
00Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool2?Nl2@Q02?Nl4>Lh8?Nl:@Q02
AS42@Q0:AS4BBU8DCW=9BU88AS42@Q02AS42BU84CW<2BU82?Nl2<H`29BT27>L25:D248@636<:2484
1242248N1246248236<648@27>L2<H`5Ool10001Ool000Uoo`8000=oo`8000Eoo`03001oogoo009o
o`924096<@92408icPPmk`Y240Q6<AQ:DPY>L`ABU0I>L`I:DPA>LdE:DPA6<@924096<@A>L`9:DP92
408icP8]J`8Q208HaP8DY@8@Q0H<H``8@P848@@8@QX48@P8@P8<H`H@Q08Li`8aS0Eoo`40005oo`00
5Goo00<007ooOol00Woo0T8@0THa0T8@0SW>23g_2T8@24Ha64YB2Tic15:D1Tic1TYB14icADYB14Ha
0T8@0THa14ic0TYB0T8@0SW>0Re[0R480QS60QBU0Q241PaS30Q20P@Q10Q26P@Q20Q20PaS1Q240QcW
0S6<1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02AS42@Q04?Nl>@Q0:AS4FBU8<CW<2DY@8CW<6
BU82CW=7BU86AS42BU84CW<2AS42?Nl2<H`29BT27>L26<H25:D248@836<@248D1244248212482482
36<648@27>L2<H`5Ool10001Ool001Eoo`03001oogoo009oo`924096<@9240@mk`i240Y6<AI:DPa>
L`9BU0Q>L`I:DP9>LdM:DPI6<@9:DPA>L`96<@8mk`8aS08U:@8Li`8HaP8DY@8@Q0P<Ha08@Q@48@@8
@P848@P8@P8<H`H@Q08Li`8aS0Eoo`40005oo`005Goo00<007ooOol00Woo0THa0TYB0THa0Sg_2T8@
2THa0TYB14Ha4TYB14ic0TYB5Tic0TYB14ic14YB1Tic34YB0Tic9DYB24ic0TYB14Ha0TYB0Tic0U:D
0TYB0T8@0SF]0RU:0R480QcW0QBU0Q242PaS40Q250@Q10Q20P@Q20Q20PaS1Q240QcW0S6<1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2AS42BU82AS42?Nl:@Q0:AS42BU84AS4BBU84CW<2BU8FCW<2BU84
CW<4BU86CW<<BU82CW<UBU88CW<2BU84AS42BU82CW<2DY@2BU82@Q02=Jd2:DX28@P27>L25:D248@:
36<@248D124424821248248236<648@27>L2<H`5Ool10001Ool001Eoo`03001oogoo009oo`96<@9:
DP96<@A240A6<@9240Y6<@A:DPA6<A1:DPI>L`9:DSA>Lb5:DPa>L`9:DPA6<@9:DPA>L`96<@8icP8]
J`8U:@8Q208HaP8DY@8@Q0X<Ha08@P@48@88@Ph48@h8@P8<H`H@Q08Li`8e[@Eoo`40005oo`005Goo
0P000goo0THa0TYB0THa148@14Ha0T8@2THa14YB14Ha44YB1Tic0TYB=4ic8DYB34ic0TYB14Ha0TYB
14ic0THa0SW>0Re[0RDY0R480QS60QBU0Q242PaS40Q210@Q0PQ23P@Q3PQ20PaS1Q240QcW0SF]17oo
0P000Goo000EOol00`00Oomoo`02Ool2AS42CW<2AS44@Q0@AS44BU82AS44BU82CW<<BU86CW<2BU8<
CW<4DY@HCW<2BU86CW<UBU8<CW<6BU86CW<2@Q02=Jd2:DX29BT27>L26<H448@:36<B248212422486
124424841248248436<2248236<448@25:D28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`96
<@9>L`96<@A24116<@A:DP96<@A:DP9>L`a:DPI>L`9:DPa>L`ABU1Q>L`9:DPI>LbE:DPa>L`I:DPI>
L`92408e[@8YBP8U:@8Li`8HaP@@Q0X<Ha88@P848@88@PH48@@8@P@48@P8@P@<H`88@P8<H`@@Q08D
Y@8Q208e[@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0THa148@14Ha0T8@2THa2TYB0Tic
34YB14ic14YB34ic0U:D64ic1TYB0Tic:DYB2Tic1TYB14ic0TYB0Sg_0Re[0RDY0R480QcW0QBU1124
2PaS60Q210@Q10Q210@Q20Q210aS0PQ20PaS0Q2411BU0R480SF]1Goo0@000Goo000EOol00`00Oomo
o`02Ool2BU82CW<2AS44@Q04AS42@Q0:AS4:BU82CW<<BU84CW<4BU8<CW<2DY@HCW<6BU82CW<YBU8:
CW<6BU84CW<2BU82?Nl2;F/29BT28@P27>L25:D448@:36<H2484124424841248248436<2248236<2
48@45:D28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>L`9:DPA240A6<@9240Y6<AQ:
DPA>L`A:DRA>L`Q:DP9>L`I:DP9>Lb5:DPY>L`A:DPI>L`96<@8e[@8YBP8U:@8Q208HaP8DY@@@Q0X<
HaP8@P@48@@8@P@48@P8@P@<H`88@P8<H`8@Q0@DY@8Q208e[@Eoo`40005oo`005Goo00<007ooOol0
0Woo0TYB0Tic0TYB148@14Ha0T8@2THa64YB14ic14YB94ic24YB0Tic1TYB0Tic8DYB2Tic14YB1Tic
0THa0SF]0RU:0RDY0R480QS60QBU11242PaS60Q210@Q10Q210@Q20Q210aS0PQ20PaS0Q2411BU0R48
0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82CW<2BU84@Q0:AS42BU84AS4BBU8:CW<2BU8<
CW<4DY@FCW<6BU8<CW<QBU8:CW<2BU84CW<2DY@2BU82?Nl2<H`29BT28@P27>L26<H648@836<B2482
1244248612442482124:248836<65:D28@P2>Lh5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>
L`9:DPA240Y6<@9:DPA6<A9:DPY>L`9:DPa>L`ABU1I>L`I:DPa>Lb5:DPY>L`9:DPA>L`9BU09:DP8m
k`8aS08U:@8Q208Li`8HaPH@Q0P<Ha88@P848@@8@PH48@@8@P848@X8@PP<H`HDY@8Q208icPEoo`40
005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB34Ha14YB14Ha4TYB1Tic14YB3Tic15:D:4ic7dYB
44ic0U:D0Tic0THa0SF]0RU:0RDY0R480QcW0QBU1Q2420aS6PQ20P@Q1PQ20P@Q2PQ21PaS0Q241QBU
0R480SW>1Goo0@000Goo000EOol20003Ool2BU82CW<2BU8<AS44BU84AS4BBU86CW<4BU8>CW<4DY@X
CW<OBU8@CW<2DY@2CW<2AS42=Jd2:DX29BT28@P27>L25:D648@836<J248212462482124:248636<2
48@65:D28@P2>Lh4Ool20001Ool001Eoo`03001oogoo009oo`9:DP9BU09:DPA6<@9:DPI6<@A:DP96
<A9:DPI>L`A:DQ1>L`9BU29>L`A:DP9>Lb5:DPi>L`ABU09:DP8mk`8aS08YBP8Q208Li`8HaP8DY@@@
Q0H<Hah8@P848A88@PH<H`8@Q0HDY@8Q208icPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0U:D
0TYB14Ha0TYB1THa14YB0THa4TYB1Tic14YB44ic0U:D8Tic14YB0Tic8DYB3Tic15:D0TYB0Sg_0S6<
0RU:0R480QcW0QS60QBU11241PaS7PQ20P@Q4PQ21PaS0Q241QBU0R480SW>1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2CW<2DY@2BU84AS44BU84AS4:BU82CW<<BU84CW<6BU8>CW<4DY@RCW<YBU8<CW<2
DY@2CW<2AS42>Lh2;F/29BT28@P27>L26<H25:D448@436<d248636<248@65:D28@P2>Lh5Ool10001
Ool001Eoo`03001oogoo009oo`9>L`9BU09:DPA6<@A:DPA6<@Y:DP9>L`a:DPA>L`I:DPi>L`ABU29>
LbU:DPa>L`9BU09>L`96<@8icP8]J`8U:@8Q208Li`8HaP8DY@@@Q0@<Hc@8@PH<H`8@Q0HDY@8Q208i
cPEoo`40005oo`005Goo00<007ooOol00Woo0Tic0U:D0Tic14Ha14YB14Ha24YB14ic2TYB1Tic14YB
44ic2U:D54ic0TYB14ic:dYB14ic0U:D14ic15:D0Tic0T8@0S6<0RU:0RDY0R480QcW0QBU1Q2410aS
=0Q21PaS0Q241QBU0RDY0SW>1Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2DY@2CW<4AS44BU84
AS48BU84CW<:BU86CW<4BU8@CW<:DY@DCW<2BU84CW<[BU84CW<2DY@4CW<4DY@2CW<2@Q02<H`2:DX2
9BT28@P27>L25:D648@436<d248636<248@65:D29BT2>Lh5Ool10001Ool001Eoo`03001oogoo009o
o`9>L`9BU09>L`A6<A1:DPA>L`Y:DPI>L`A:DPa>L`iBU19>L`9:DPI>Lb]:DPQ>L`IBU09:DP8icP8]
J`8YBP8U:@8Li`8HaP8DY@@@Q0H<Hc@8@PH<H`8@Q0HDY@8U:@8mk`Eoo`40005oo`005Goo00<007oo
Ool00Woo0Tic0U:D0Tic14Ha44YB14ic2TYB1Tic14YB34ic3U:D4Tic0TYB1Tic:dYB24ic1U:D0TYB
0SW>0Re[0RU:0RDY0QcW0QS60QBU11241PaS=0Q21PaS0Q241QBU0RDY0Sg_1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2CW<2DY@2CW<4AS4LBU88CW<2BU8>CW<2DY@6CW<2DY@@CW<4BU88CW<]BU88CW<2
DY@2E[D2DY@2AS42=Jd2:DX29BT28@P27>L26<H25:D448@636<N248236<B248836<248@65:D29BT2
>Lh5Ool10001Ool001Eoo`8000=oo`9>L`9BU09>L`A6<Aa:DPQ>L`9:DPi>L`9BU0I>L`9BU11>L`A:
DPQ>Lbe:DPQ>L`9BU09F]@9BU096<@8e[@8YBP8U:@8Q208Li`8HaP8DY@@@Q0H<Hah8@P8<Ha88@PP<
H`8@Q0HDY@8U:@8icPAoo`80005oo`005Goo00<007ooOol00Woo0Tic0U:D0Tic14Ha74YB84ic0U:D
6Tic;dYB1Tic0U:D15Je0Tic0Sg_0S6<0RU:0RDY0R480QcW1QBU0Q241PaS2PQ20PaS40Q210aS4PQ2
20aS0Q241QBU0RDY0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2DY@2CW<4AS4LBU8PCW<2
DY@JCW<_BU86CW<2DY@4E[D2CW<2?Nl2<H`2:DX29BT28@P27>L65:D248@636<:248236<@248436<B
248836<248@65:D29BT2?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9BU09F]@9>L`96<@9:DPA>
LaI:DQQ>L`9BU0I>L`ABU1Q>Lc5:DPA>L`ABU0AF]@9:DP8icP8]J`@U:@8Q208HaP@DY@@@Q0@<H`P8
@PH<H`h8@P@<H`H8@P8<H``8@PP<H`8@Q0HDY@8U:@8mk`Eoo`40005oo`005Goo00<007ooOol00Woo
0U:D0UJe0Tic0THa0TYB14ic5TYB64ic0U:D1Tic15:D64ic<DYB14ic15:D15Je0TYB0SW>0Re[12DY
0R480QS611BU112410aS20Q21PaS3PQ210aS1PQ20PaS30Q220aS0Q241QBU0RDY0Sg_1Goo0@000Goo
000EOol00`00Oomoo`02Ool2DY@2E[D2CW<4BU84CW<FBU84CW<2BU8BCW<2DY@6CW<4DY@HCW<aBU84
CW<2DY@4E[D2DY@2AS42=Jd2:DX49BT27>L26<H45:D248@636<6248:36<6248436<2248436<62482
36<<248836<248@65:D29BT2?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9BU09F]@9>L`A:DPA>
LaI:DPA>L`9:DQ9>L`9BU0I>L`ABU1Q>Lc5:DPA>L`9BU0AF]@9BU096<@8e[@8YBP@U:@8Li`8HaP@D
Y@8@Q0H<H`H8@PX<H`H8@P@<H`88@P@<H`H8@P8<H``8@PP<H`8@Q0HDY@8U:@8mk`Eoo`40005oo`00
5Goo00<007ooOol00Woo0U:D0UJe0Tic14YB0Tic64YB0Tic14YB1Tic14YB24ic0U:D1Tic0U:D34ic
0TYB14ic1TYB0Tic<DYB14ic0U:D15Je0Tic0Sg_0S6<0RU:0RDY0R480QcW1QBU0Q241PaS1PQ22PaS
1PQ210aS0PQ210aS10Q210aS30Q220aS0Q2411BU0QS60RDY0Sg_1Goo0@000Goo0007Ool30004Ool2
0005Ool00`00Oomoo`02Ool2DY@2E[D2CW<4BU82CW<HBU82CW<4BU86CW<4BU88CW<2DY@6CW<2DY@<
CW<2BU84CW<6BU82CW<aBU84CW<2DY@4E[D2CW<2?Nl2<H`2:DX29BT28@P27>L65:D248@636<6248:
36<6248436<2248436<4248436<<248836<248@45:D26<H29BT2?Nl5Ool10001Ool000Moo`04001o
ogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0U:D0UJe0Tic14YB0Tic64YB14ic0TYB14ic
14YB2Tic0U:D4Tic14YB14ic14YB14ic4TYB0THa6dYB1Tic1UJe0TYB0SW>0Re[12DY0R480QcW1QBU
0Q2410aS1PQ20PaS1Q241PaS1PQ22PaS10Q20PaS30Q220aS0Q240QBU11S60RDY0Sg_1Goo0@000Goo
0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`8000=oo`9BU09F]@9>L`A:DP9>LaQ:DPA>L`9:
DPA>L`A:DPY>L`9BU19>L`A:DPA>L`A:DPA>La9:DP96<A]:DPI>L`IF]@9:DP8icP8]J`@U:@8Q208L
i`HDY@8@Q0@<H`H8@P8<H`H@Q0H<H`H8@PX<H`@8@P8<H``8@PP<H`8@Q08DY@@HaP8U:@8mk`Aoo`80
005oo`001goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9BU09F]@9>L`A:DPA>L`I:DP9>
L`i:DPA>L`9:DPA>L`9:DPa>L`9BU29>Lbm:DPA>L`9BU0AF]@9BU096<@8e[@8YBP@U:@8Q208HaPHD
Y@8@Q0@<H`H8@P8@Q0@DY@8@Q0@<H`P8@PX<H`h8@P8<H`88@PP<H`8@Q08DY@@HaP8U:@8mk`Eoo`40
005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9BU09F]@9>L`A:DPA>
L`I:DP9>L`i:DPA>L`9:DPA>L`9:DPa>L`9BU29>Lbm:DPA>L`9BU0AF]@9BU096<@8e[@8YBP@U:@8Q
208HaPHDY@8@Q0@<H`H8@P8@Q0@DY@8@Q0@<H`P8@PX<H`h8@P8<H`88@PP<H`8@Q08DY@@HaP8U:@8m
k`Eoo`40005oo`0027oo0`000goo0P001Goo00<007ooOol00Woo0U:D0UJe0U:D14YB0Tic24YB0Tic
3TYB14ic14YB3Tic15:D74ic0TYB0Tic<DYB14ic0U:D15Je0Tic0T8@0S6<0RU:12DY0R4811S611BU
0Q242PaS11BU0Q240PaS2PQ21PaS0PQ20PaS3PQ210aS0PQ220aS0Q241QS60RDY0T8@1Goo0@000Goo
000EOol00`00Oomoo`02Ool2DY@2E[D2DY@4BU82CW<8BU82CW<>BU84CW<4BU8>CW<4DY@LCW<2BU82
CW<aBU84CW<2DY@4E[D2CW<2@Q02<H`2:DX49BT28@P46<H45:D248@:36<45:D248@236<:248636<2
248236<>248436<2248836<248@66<H29BT2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9BU09F
]@9BU0A:DP9>L`I:DPA>L`a:DPI>L`9:DRQ>L`9:DPA>Lbm:DP96<@Q:DP9>L`9BU0AF]@9:DP8mk`8a
S08YBP@U:@8Q208HaP@DY@@@Q0P<H`8@Q0@DY@8@Q0`8@P@<Ha@8@P@<H`88@PP<H`8@Q0HHaP8YBP92
40Eoo`40005oo`005Goo00<007ooOol00Woo0U:D0UJe0U:D14YB0Tic1TYB14ic34YB1Tic0TYB:4ic
0TYB14ic;dYB0THa24YB0Tic0U:D15Je0TYB0Sg_0S6<0RU:12DY0R480QS611BU112420aS0Q2411BU
0Q2430Q210aS50Q210aS0PQ220aS0Q241QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2
DY@2E[D2DY@4BU82CW<6BU82CW<>BU86CW<2BU8VCW<4BU84CW<[BU86AS48BU82CW<2DY@2E[D2DY@2
BU82>Lh2;F/2:DX49BT27>L26<H45:D448@636<848@236<F248236<<248436<2248836<248@66<H2
:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9BU09F]@9BU0A:DP9>L`I:DP9>L`i:DPI>L`9:
DRI>L`A:DPA>Lb]:DPI6<@Q:DP9>L`9BU09F]@9BU09:DP8icP8]J`8YBP@U:@8Li`8HaP@DY@@@Q0H<
H`P@Q08<HaH8@P8<H``8@P@<H`88@PP<H`8@Q0HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol0
0Woo0U:D0UJe0U:D14YB14ic54YB1Tic0TYB9Tic14YB14ic:DYB24Ha24YB0Tic0U:D0UJe0U:D0THa
0SF]0Re[0RU:0RDY0R480QcW0QS611BU11241PaS1Q240PaS5PQ21PaS2PQ210aS0PQ210aS11240QBU
1QS60RU:0T8@1Goo0@000Goo000EOol20003Ool2DY@2E[D2DY@4BU84CW<DBU86CW<2BU8VCW<4BU84
CW<YBU88AS48BU82CW<2DY@2E[D2DY@2AS42=Jd2;F/2:DX29BT28@P27>L26<H45:D448@636<648@2
36<F248636<:248436<2248436<448@25:D66<H2:DX2@Q04Ool20001Ool001Eoo`03001oogoo009o
o`9BU09JeP9BU0A:DPA>LaA:DPI>L`9:DRI>L`A:DPA>LaY:DP96<@]:DPY6<@Q:DP9>L`9BU09F]@9>
L`92408e[@8]J`8YBP8U:@8Q208Li`8HaP8DY@H@Q0h<H`h8@P@<H`@8@PH<H`X8@PP<H`H@Q08DY@HH
aP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0U:D0U[F0U:D14YB14ic54YB1Tic0TYB9Tic
14YB14ic6TYB0THa2dYB2THa24YB0Tic0U:D0UJe0Tic0T8@0SF]0Re[0RU:0RDY0R480QcW0QS60QBU
1Q243PaS3PQ210aS10Q21PaS2PQ220aS1Q240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2DY@2F]H2DY@4BU84CW<DBU84CW<4BU8VCW<RBU82AS46BU8?AS48BU82CW<4DY@2BU82?Nl2
<H`2;F/2:DX29BT28@P26<H45:D648@>36<6248236<6248436<2248836<:248836<648@25:D66<H2
:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9BU09JeP9BU0A:DPA>LaA:DPA>L`A:DRI>Lb9:
DP96<@I:DPm6<@Q:DP9>L`ABU09:DP8mk`8aS08]J`8YBP8U:@8Q208HaP@DY@H@Q0h<H`H8@P8<H`H8
@P@<H`88@PP<H`X8@PP<H`H@Q08DY@HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0U:D
0U[F0U:D14YB14ic54YB14ic14YB9Tic8TYB0THa0TYB4dHa24YB0Tic15:D0THa0SW>0S6<0Re[0RU:
0RDY0QcW0QS611BU1Q243PaS10Q210aS1PQ210aS0PQ220aS10Q20PaS10Q220aS1Q240QBU1QS60RU:
0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2F]H2DY@4BU84CW<DBU84CW<4BU8VCW<RBU82
AS42BU8CAS48BU82CW<4DY@2AS42>Lh2<H`2;F/2:DX29BT27>L26<H45:D648@>36<4248436<62484
36<2248836<4248236<4248836<648@25:D66<H2:DX2@Q05Ool10001Ool001Eoo`03001oogoo009o
o`9F]@9JeP9BU0A:DPA>L`i:DP9>L`A:DPA>L`A:DRI>Lb9:DQM6<@Q:DP9>L`9BU09>L`96<@8icP8a
S08]J`8YBP8Q208Li`8HaP@DY@H@Q1H<H`@8@Q0<H`88@P@<H`@8@PP<H`H@Q08DY@HHaP8YBP9240Eo
o`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D14YB14ic3TYB0Tic14YB14ic14YB9Tic8TYB
5dHa24YB0Tic0U:D0Tic0THa0SW>0S6<0Re[0RU:0R480QcW0QS611BU1Q245PaS10Q240aS0PQ210aS
10Q220aS1Q240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@4BU84
CW<>BU82CW<4BU84CW<4BU8>CW<2BU8DCW<RBU88AS46BU8;AS48BU82CW<2DY@2CW<2@Q02>Lh2<H`2
;F/2:DX28@P27>L26<H45:D648@F36<4248@36<2248436<2248:36<648@25:D66<H2:DX2@Q05Ool1
0001Ool001Eoo`8000=oo`9F]@9JeP9BU0A:DPA>L`i:DP9>L`A:DPA>L`A:DPi>L`9:DQA>Lb9:DPQ6
<@I:DP]6<@Q:DP9>L`9BU09>L`92408icP8aS08]J`8YBP8Q208Li`8HaP@DY@H@Q1H<H`@8@Q0<H`88
@P@<H`88@PX<H`H@Q08DY@HHaP8YBP9240Aoo`80005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D
14YB14ic74YB54ic0U:D3Tic8TYB1THa14YB4dHa14YB0Tic0U:D0TYB0T8@0SW>0S6<0Re[0RDY0QcW
11S60QBU212460aS0PQ22PaS0Q242PaS0PQ220aS21240QBU1QS60RU:0T8@1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2E[D2F]H2DY@4BU84CW<LBU8DCW<2DY@>CW<RBU86AS44BU8CAS44BU82CW<2DY@2
BU82@Q02>Lh2<H`2;F/29BT27>L46<H25:D848@H36<2248:36<248@:36<2248836<848@25:D66<H2
:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0A:DP9>Lai:DQ9>L`9BU11>Lb1:
DQm6<@A:DPA>L`9:DP8mk`8e[@8aS08YBP8U:@8Li`@HaP8DY@H@Q0H<H`@@Q10<H`88@PX<H`8@Q0X<
H`88@PP<H`P@Q08DY@HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D14YB
0Tic7TYB4Tic0U:D44ic84YB7dHa14YB14ic0TYB0Sg_0SF]0S6<0RU:0RDY0QcW11S60QBU1Q241PaS
112440aS0PQ22PaS0Q242PaS0PQ220aS21240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2E[D2F]H2DY@4BU84CW<>BU82CW<8BU8FCW<2DY@BCW<NBU8OAS42BU86CW<2AS42?Nl2=Jd2
<H`2:DX28@P27>L46<H25:D848@236<648@@36<2248:36<248@:36<2248836<848@25:D66<H2:DX2
@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0A:DPA>L`i:DP9>L`Q:DQI>L`9BU19>
Lai:DQm6<@9:DPI>L`96<@8mk`8e[@8aS08YBP8Q208Li`@HaP8DY@P@Q08<H`H@Q10<H`88@PX<H`8@
Q0X<H`88@PP<H`P@Q08DY@HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D
24ic34YB14ic1TYB;4ic1TYB0Tic54YB8DHa14YB14ic0THa0SW>0SF]0Re[0RDY0R480QcW0QS61QBU
3Q2440aS0PQ220aS11243PaS0Q2410aS21240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2E[D2F]H2DY@8CW<<BU84CW<6BU8/CW<6BU82CW<DBU8QAS44BU84CW<2AS42>Lh2=Jd2;F/2
9BT28@P27>L26<H65:D>48@@36<2248836<448@>36<248@436<848@25:D66<H2:DX2@Q05Ool10001
Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>L`a:DPA>L`I:DRY>Lai:DR=6<@9:DP9>L`9:DP92
408icP8aS08]J`8U:@8Q208Li`@HaPHDY@`@Q1X<H`@@Q0h<H`8@Q0@<H`P@Q08DY@@HaP8Li`8YBP92
40Eoo`40005oo`005Goo0P000goo0UJe0U[F0U:D24ic34YB14ic1TYB:Tic7TYB8dHa0TYB0Tic0TYB
0T8@0SW>0S6<0Re[0RDY0R480QcW11S61QBU31246PaS11243PaS0Q2410aS21240QBU11S60QcW0RU:
0T8@17oo0P000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@6CW<8BU82CW<4BU84CW<6BU8TCW<4
BU82CW<PBU8QAS42BU82CW<2BU82@Q02>Lh2<H`2;F/29BT27>L66<H65:D<48@J36<448@>36<248@4
36<848@25:D46<H27>L2:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0I>L`Q:
DP9>L`A:DPA>L`I:DRA>L`A:DP9>Lb1:DR56<@9:DP9>L`9:DP92408icP8aS08]J`8U:@8Li`HHaPHD
Y@`@Q1X<H`@@Q0h<H`8@Q0@<H`P@Q08DY@@HaP8Li`8YBP9240Eoo`40005oo`005Goo00<007ooOol0
0Woo0UJe0U[F0U:D0Tic0TYB14ic14YB14ic14YB14ic14YB8Tic1TYB14ic84YB7dHa1TYB0THa0Sg_
0SF]0S6<0RU:0RDY0QcW1QS61QBU312460aS1Q243PaS11240PaS21240QBU0QS611cW0RU:0T8@1Goo
0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@2CW<2BU84CW<4BU84CW<4BU84CW<4BU8RCW<6
BU84CW<PBU8OAS46BU82AS42?Nl2=Jd2<H`2:DX29BT27>L66<H65:D<48@H36<648@>36<448@236<8
48@25:D26<H47>L2:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>L`A:DPA>
L`A:DPA>L`A:DR1>L`A:DPQ>Laa:DR=6<@I:DP96<@8mk`8e[@8aS08YBP8U:@8Li`HHaPHDY@`@Q1H<
H`P@Q0h<H`@@Q08<H`8@Q0@DY@8@Q08DY@HLi`8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo
0UJe0U[F0U:D24ic14YB14ic14YB14ic14YB84ic14YB24ic74YB8dHa1TYB0THa0Sg_0SF]0S6<0RU:
0RDY0QcW1QS61QBU31245PaS21243PaS11240PaS0Q2411BU0Q240QBU1QcW0RU:0T8@1Goo0@000Goo
000EOol00`00Oomoo`02Ool2E[D2F]H2DY@8CW<4BU84CW<<BU8PCW<2BU8:CW<JBU8WAS42BU82AS42
@Q02>Lh2=Jd2;F/2:DX28@P27>L66<H65:D<48@236<448@@36<848@>36<448@236<248@45:D248@2
5:D67>L2:DX2@Q05Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>
L`A:DPA>L`a:DR1>L`9:DPY>LaY:DRM6<@9:DP96<@92408icP8e[@8]J`8YBP8Q208Li`HHaPHDY@`@
Q08<H`@@Q10<H`P@Q0h<H`@@Q08<H`8@Q0@DY@8@Q08DY@HLi`8YBP9240Eoo`40005oo`001goo00@0
07ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool2E[D2F]H2DY@2CW<2BU84CW<4BU84CW<<
BU8VCW<4BU82CW<JBU8[AS42@Q02>Lh2=Jd2;F/2:DX28@P47>L66<H45:DB48@@36<:48@<36<848@4
5:D248@25:D67>L2:DX2@Q05Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo0P00
0goo0UJe0U[F0U:D0Tic0TYB14ic14YB14ic34YB9Tic14YB0Tic6TYB:dHa0T8@0SW>0SF]0Re[0RU:
0R4811cW1QS611BU4Q2440aS2Q2430aS212411BU0Q240QBU1QcW0RU:0T8@17oo0P000Goo0008Ool2
0003Ool01000Oomoo`0017oo00<007ooOol00Woo0UJe0U[F0U:D14YB14ic14YB14ic1TYB0Tic14YB
;4ic6TYB8DHa0T8@24Ha0Sg_0SW>0SF]0Re[0RU:0R4811cW11S61QBU4Q2440aS2Q2430aS212411BU
0Q240QBU1QcW0RU:0T8@1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001o
ogoo009oo`9F]@9JeP9BU0A:DPA>L`A:DPA>L`I:DP9>L`A:DRa>LaY:DR56<@9240Q6<@8mk`8icP8e
[@8]J`8YBP8Q20@Li`@HaPHDYA8@Q10<H`X@Q0`<H`P@Q0@DY@8@Q08DY@HLi`8YBP9240Eoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol00Woo0UJe0U[F0U:D14YB14ic14YB14ic1TYB0Tic14YB
4Tic15:D5Tic6TYB8DHa0T8@1THa0T8@0Sg_0SW>0S6<0Re[0RU:0R4811cW11S611BU3Q240PaS1Q24
30aS312410aS0Q241PaS21241QBU0QS61QcW0RU:0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2
E[D2F]H2DY@4BU84CW<4BU84CW<6BU82CW<4BU8BCW<4DY@FCW<JBU8QAS42@Q06AS42@Q02?Nl2>Lh2
<H`2;F/2:DX28@P47>L46<H45:D>48@236<648@<36<<48@436<248@636<848@65:D26<H67>L2:DX2
AS45Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>L`A:DPA>L`A:DPA>L`A:DQ1>L`AB
U1Q>LaY:DQU6<@9240I6<@A240A6<@92408mk`8e[@8aS08]J`8U:@8Q20@Li`@HaPhDY@`@Q0`<H`@@
Q08DY@H@Q08<H`H@Q08<H`X@Q0HDY@8HaPHLi`8YBP96<@Eoo`40005oo`005Goo00<007ooOol00Woo
0UJe0U[F0U:D24ic14YB14ic14YB14ic14YB44ic15:D64ic6TYB6DHa0T8@1THa148@14Ha0T8@0Sg_
0SF]0S6<0Re[0RDY0R4811cW11S63QBU312430aS11240QBU1Q240PaS1Q240PaS2Q241QBU0QS61QcW
0RU:0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@8CW<4BU84CW<4BU84CW<4BU8@
CW<4DY@BCW<2BU84CW<JBU8OAS46@Q02AS44@Q02>Lh2=Jd2<H`2;F/2:DX28@P47>L66<H:5:D>48@<
36<248@25:D@48@236<:48@65:D26<H67>L2:DX2AS45Ool10001Ool001Eoo`03001oogoo009oo`9F
]@9JeP9BU0Q>L`A:DPA>L`A:DPA>L`A:DQ1>L`ABU19>L`9:DPA>LaY:DQm6<@I24096<@A2408icP8e
[@8aS08]J`8YBP8Q20@Li`HHaPXDY@h@Q0`<H`8@Q08DYA0@Q08<H`X@Q0HDY@8HaPHLi`8YBP96<@Eo
o`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0UJe24ic14YB14ic14YB0Tic1TYB2Tic0U:D14ic
15:D34ic0TYB34ic14YB0Tic4TYB7dHa2T8@0Sg_0SW>0SF]0S6<0Re[0RU:0R481QcW11S62QBU3Q24
2PaS11240QBU41240PaS2Q241QBU0QS61QcW0RU:0THa1Goo0@000Goo000EOol20003Ool2E[D2F]H2
E[D8CW<4BU84CW<4BU82CW<6BU8:CW<2DY@4CW<4DY@<CW<2BU8<CW<4BU82CW<BBU8OAS4:@Q02?Nl2
>Lh2=Jd2<H`2;F/2:DX28@P67>L46<H:5:D>48@:36<448@25:D@48@236<:48@65:D26<H67>L2:DX2
AS44Ool20001Ool001Eoo`03001oogoo009oo`9F]@9JeP9F]@Q>L`A:DPA>L`I:DP9>L`9:DPY>L`AB
U0A>L`ABU0Y>L`A:DPa>LaQ:DQ]6<@i2408mk`8icP8e[@8aS08]J`8YBP@Q20@Li`@HaPXDY@h@Q0@<
H`8@Q0@<H`@@Q0PDY@X@Q08<H`X@Q0HDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol0
0Woo0UJe0U[F0UJe24ic14YB14ic1TYB0Tic0TYB2Tic15:D14ic15:D2Tic14YB34ic64YB6dHa3T8@
0Sg_0SW>0SF]0S6<0Re[0RU:124811cW11S62QBU3Q2410aS0Q2410aS112421BU2Q240PaS2Q241QBU
0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2E[D8CW<4BU84CW<6BU8>
CW<2DY@6CW<4DY@:CW<4BU8<CW<FBU8KAS4@@Q02?Nl2>Lh2=Jd2<H`2;F/2:DX29BT28@P67>L26<H<
5:DB48@436<448@85:D:48@236<:48@65:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo
009oo`9F]@9JeP9F]@Q>L`A:DPA>L`I:DPi>L`9BU0I>L`ABU0Y>L`A:DPa>LaI:DQ]6<A12408mk`8i
cP8e[@8aS08]J`8YBP8U:@8Q20HLi`8HaP`DYA8@Q0@<H`@@Q0PDY@X@Q08<H`X@Q0HDY@8HaPHLi`8]
J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0UJe24ic14YB14ic1TYB3Tic0U:D1Tic
15:D2Tic0TYB3Tic5TYB6DHa4T8@0Sg_0SW>0SF]0S6<0Re[0RU:0RDY124811cW0QS63QBU412410aS
112421BU5Q241QBU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2E[D8
CW<4BU84CW<6BU8>CW<2DY@6CW<4DY@:CW<2BU8>CW<FBU8IAS4B@Q02?Nl2>Lh2=Jd2<H`2;F/2:DX2
9BT48@P47>L26<H>5:D@48@436<448@85:DF48@65:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03
001oogoo009oo`9JeP9Nm`9F]A1>L`A:DPY>L`IBU0I>L`IBU1Y>LaA:DQe6<A12408mk`8icP8e[@8a
S08]J`8YBP8U:@@Q20@Li`8HaPhDY@`@Q08<H`8@Q0H<H`8@Q0PDYA@@Q0PDY@8HaPHLi`8]J`96<@Eo
o`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe44ic14YB2Tic1U:D1Tic1U:D6Tic54YB7DHa
448@0Sg_0SW>0SF]0S6<0Re[0RU:0RDY124811cW0QS63QBU31240PaS0Q241PaS0Q2421BU512421BU
0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<2DY@:CW<4BU8:
CW<4DY@2CW<<DY@JCW<DBU82AS44BU8GAS4@@Q02?Nl2>Lh2=Jd2<H`2;F/2:DX29BT48@P47>L46<H<
5:DB48@236<248@45:D46<H45:DB48@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`8000=oo`9J
eP9Nm`9F]@A>L`9BU0Y>L`A:DPY>L`ABU09>L`aBU1Y>LaA:DP96<@A:DQM6<A12408mk`8icP8e[@8a
S08]J`8YBP8U:@@Q20@Li`@HaP`DYA8@Q08<H`8@Q0@DY@@HaP@DYA8@Q0PDY@8HaPHLi`8]J`96<@Ao
o`80005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe14ic15:D24ic14YB2Tic15:D0Tic3U:D64ic
6TYB5dHa448@0Sg_0SW>0SF]0S6<12e[0RDY124811cW1QS62QBU4Q240PaS0Q240QBU1QS611BU4Q24
21BU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@8CW<4
BU8:CW<4DY@2CW<>DY@HCW<JBU8GAS4@@Q02?Nl2>Lh2=Jd2<H`4;F/29BT48@P47>L66<H:5:DB48@2
36<248@25:D66<H45:DB48@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9F
]@9Nm`9F]@A>L`ABU0Q>L`A:DPY>L`ABU09>L`iBU1Q>Laa:DQE6<A12408mk`8icP8e[@@aS08]J`8Y
BP@Q20@Li`PHaPPDYA8@Q08<H`8@Q0PHaP@DYA8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo
00<007ooOol00Woo0UJe0Ukg0UJe14ic15:D24ic14YB2Tic15:D0Tic3U:D64ic74YB5DHa448@0Sg_
0SW>0SF]136<0Re[0RU:124811cW21S621BU4Q240PaS0Q2421S611BU4Q2421BU0QS61QcW0Re[0THa
1Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@8CW<4BU88CW<LDY@BCW<LBU8I
AS4<@Q02?Nl2>Lh4=Jd2<H`2;F/2:DX29BT48@P27>L86<H:5:D@48@236<248@26<H47>L26<H45:DB
48@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F]@A>L`ABU0Q>
L`A:DPQ>LaaBU19>Laa:DQU6<@a2408mk`8icP@e[@8aS08]J`8YBP8U:@@Q208Li`PHaPXDYA0@Q08<
H`8@Q08HaP@Li`8HaP@DYA8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo
0U[F0Ukg0UJe14ic15:D24ic0TYB2Tic75:D4Tic0TYB14ic5TYB6DHa348@0Sg_13W>0SF]0S6<0Re[
0RU:0RDY12480QcW21S621BU4Q240PaS0QBU1QcW0QS611BU4Q2421BU0QS61QcW0Re[0THa1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@8CW<2BU8:CW<LDY@BCW<2BU84CW<FBU8I
AS4<@Q02?Nl4>Lh2=Jd2<H`2;F/2:DX29BT48@P27>L86<H85:DB48@236<25:D67>L26<H45:DB48@8
5:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F]@A>L`9BU0A>L`9:
DPY>L`9BU09>Lb1BU11>L`A:DP9>L`a:DP96<@I:DQM6<A12408mk`@icP8e[@8aS08]J`8YBP8U:@@Q
208Li`PHaPPDY@H@Q08DY@`@Q08HaPHQ208HaP@DY@`@Q0@DY@8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40
005oo`005Goo0P000goo0U[F0Ukg0UJe14ic0U:D14ic0TYB2Tic0U:D0Tic85:D44ic14YB0Tic34YB
0THa1TYB5dHa448@0Sg_13W>0SF]0S6<0Re[0RU:0RDY12480QcW21S621BU1Q240QBU31240QS61R48
0QS611BU312411BU0Q2421BU0QS61QcW0Re[0THa17oo0P000Goo000EOol00`00Oomoo`02Ool2F]H2
G_L2E[D4CW<2DY@2CW<2BU8<CW<2DY@2CW<6DY@2CW<HDY@@CW<4BU82CW<FBU8IAS4<@Q02?Nl4>Lh2
=Jd2<H`2;F/2:DX29BT48@P47>L66<H:5:D248@65:D448@25:D248@25:D27>L49BT27>L26<H45:D>
48@25:D248@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F]@A>
L`9BU09>L`9:DPa>L`9BU09>L`IBU09>LaQBU11>L`A:DP9>LaI:DQU6<@a2408mk`@icP8e[@8aS08]
J`8YBP8U:@@Q20@Li`HHaPXDY@8@Q0HDY@@@Q08DY@8@Q08DY@8Li`@U:@8Li`8HaP@DY@h@Q08DY@8@
Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe14ic0U:D24ic
0U:D1Tic95:D5Tic64YB3THa0TYB2DHa2T8@13g_0SW>13F]0S6<0RU:0RDY124811cW21S641BU0Q24
21BU0R4812DY0QcW0QBU4Q240QBU0Q2421BU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomo
o`02Ool2F]H2G_L2E[D4CW<2DY@8CW<2DY@6CW<TDY@FCW<HBU8>AS42BU89AS4:@Q04?Nl2>Lh4=Jd2
<H`2:DX29BT48@P47>L86<H@5:D248@85:D28@P49BT27>L25:DB48@25:D248@85:D26<H67>L2;F/2
AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9S609JeP9BU09>L`ABU0A>L`ABU0A>La9BU09F
]@ABU0AF]@YBU1Q>L`A:DP9>La9:DPY6<@A:DPU6<@Y240@mk`@icP8e[@8aS08YBP8U:@@Q20@Li`PH
aQ0DY@8@Q0HDY@8HaP8Q208U:@8Q208DYA8@Q0@DY@8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`00
5Goo00<007ooOol00Woo0U[F0V<H0U[F0U:D0Tic15:D14ic15:D14ic4U:D0UJe15:D15Je2U:D64ic
14YB0Tic4TYB2THa14YB2DHa2T8@13g_13W>0SF]0S6<0RU:0RDY124811cW21S641BU0Q241QBU0QS6
0R480RDY0R480QBU4Q2411BU0Q2421BU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02
Ool2F]H2G_L2E[D4CW<4DY@4CW<2DY@6CW<BDY@2E[DBDY@FCW<JBU88AS46BU89AS4:@Q04?Nl4>Lh2
=Jd2<H`2:DX29BT48@P47>L:6<H>5:D248@65:D26<H48@P27>L25:D448@25:D<48@45:D248@25:D4
6<H25:D26<H67>L2;F/2BU85Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eoo`03001o
ogoo009oo`9JeP9Nm`9F]@A>L`ABU0A>L`9BU0I>La9BU09F]A9BU1I>LaY:DPQ6<@I:DPU6<@Y240@m
k`@icP8e[@8aS08YBP8U:@@Q20@Li`XHaPhDY@8@Q0HDY@8HaP@Q208Li`8DY@@@Q08DY@`@Q0@DY@8@
Q08DY@@HaP8DY@8HaPHLi`8]J`9:DPEoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo
0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2F]H2G_L2E[D4CW<2DY@>CW<6DY@2CW<NDY@FCW<J
BU86AS48BU8;AS48@Q04?Nl4>Lh2=Jd2<H`2:DX49BT28@P47>L:6<HD5:D46<H27>L28@P26<H25:D2
48@45:D<48@45:D248@25:D26<H45:D26<H67>L2;F/2AS45Ool10001Ool000=oo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo0U[F0Ukg0UJe14ic0U:D3Tic1U:D0Tic
7U:D5Tic6TYB1THa24YB2dHa248@13g_13W>0SF]0S6<0RU:12DY0R4811cW2QS651BU11S60QcW0R48
0QS60QBU0Q2411BU312411BU0Q240QBU0QS611BU0QS61QcW0Re[0THa17oo0P000Goo0003Ool01@00
Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9JeP9Nm`9F]@A>
L`9BU0i>L`IBU09>L`YBU09F]A9BU1Q>L`9:DPA>La9:DPI6<@Q:DP]6<@Y240@mk`8icP8e[@8aS08]
J`@U:@8Q20HLi`PHaQ@DY@@HaP@Li`8HaP8DY@8@Q08DY@h@Q0@DY@8@Q0PDY@8HaPHLi`8]J`96<@Eo
o`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool2F]H2G_L2E[D4CW<2DY@>CW<6DY@2CW<:DY@2E[DBDY@HCW<2BU84CW<BBU86AS48BU8;AS4:
@Q04?Nl2>Lh2=Jd2<H`2;F/49BT28@P67>L86<HD5:D46<H47>L26<H25:D248@25:D>48@45:D248@8
5:D26<H67>L2;F/2AS45Ool10001Ool0009oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo009oo`9J
eP9Nm`9F]@9BU09>L`ABU0A>L`ABU0A>L`IBU09>L`QBU0AF]@IBU09F]@aBU1i>La1:DPA6<@Y:DP]6
<@Y240@mk`8icP8e[@8aS08]J`@U:@8Q20@Li`XHaQ@DY@@HaP@Li`8HaP8DYA8@Q0@DY@8@Q0PDY@8H
aPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe0U:D0Tic15:D14ic15:D
14ic1U:D0Tic25:D15Je1U:D0UJe35:D7Tic44YB14Ha2TYB2dHa2T8@13g_0SW>0SF]0S6<0Re[12DY
0R4811cW2QS651BU11S611cW0QS60QBU4Q2411BU0Q2421BU0QS61QcW0Re[0THa1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2F]H2G_L2F]H2DY@2CW<4DY@4CW<4DY@4CW<4DY@4CW<:DY@2E[D6DY@2E[D<
DY@FCW<4BU84CW<LBU8;AS4<@Q04?Nl2>Lh2=Jd2<H`2;F/29BT48@P47>L>6<H@5:D86<H25:D448@2
5:D648@25:D648@85:D46<H25:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9J
eP9Nm`9JeP9BU09>L`ABU0A>L`ABU0A>L`ABU0A>L`YBU09F]@IBU09F]@aBU1I>L`A:DPA>Laa:DP]6
<@a240@mk`8icP8e[@8aS08]J`8U:@@Q20@Li`hHaQ0DY@PHaP8DY@@@Q08DY@H@Q08DY@H@Q0PDY@@H
aP8DY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe14ic15:D14ic
15:D14ic15:D14ic2U:D0UJe15:D15Je35:D5Tic0TYB1Tic74YB2dHa348@13g_0SW>0SF]0S6<0Re[
0RDY12481QcW31S641BU21S60QBU112411BU312421BU0QS611BU0QS61QcW0Re[0THa1Goo0@000Goo
000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@4CW<4DY@4CW<4DY@4CW<:DY@2E[D4DY@4E[D<
DY@FCW<2BU86CW<LBU8;AS4<@Q04?Nl2>Lh2=Jd2<H`2;F/29BT48@P67>L<6<H@5:D86<H25:D448@4
5:D<48@85:D26<H45:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F
]@A>L`ABU0A>L`aBU09>L`YBU0iF]@YBU1i>LaY:DPe6<@a240@mk`8icP8e[@8aS08]J`8U:@HQ20@L
i`XHaQ8DY@PHaP8DY@@@Q0@DY@`@Q0hDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo0P000goo0U[F
0Ukg0UJe14ic15:D14ic35:D0Tic2U:D3UJe2U:D7Tic6TYB3DHa348@13g_0SW>0SF]0S6<0Re[0RDY
1R4811cW2QS64QBU21S60QBU112411BU31243QBU0QS61QcW0Re[0THa17oo0P000Goo000EOol00`00
Oomoo`02Ool2G_L2HaP2F]H4CW<4DY@2CW<DDY@DE[D:DY@NCW<JBU8?AS4:@Q04?Nl4>Lh2<H`2;F/2
9BT48@P67>L66<HH5:D66<H25:D448@25:D>48@45:D248@85:D26<H68@P2;F/2BU85Ool10001Ool0
01Eoo`03001oogoo009oo`9Nm`9S609JePA>L`ABU09>LaABU1AF]@YBU1i>LaY:DPm6<@Y240@mk`@i
cP8aS08]J`8U:@@Q20HLi`HHaQPDY@HHaP8DY@@@Q08DY@h@Q0@DY@8@Q0PDY@8HaPHQ208]J`9:DPEo
o`40005oo`005Goo00<007ooOol00Woo0Ukg0V<H0U[F14ic3U:D0Tic25:D5UJe45:D5Tic74YB3DHa
348@13g_0SW>0SF]0S6<0Re[0RDY124811cW21S661BU1QS60QBU0Q2411BU3Q2411BU0Q240QBU1QS6
0QcW1R480Re[0TYB1Goo0@000Goo000EOol00`00Oomoo`02Ool2G_L2HaP2F]H4CW<>DY@2CW<8DY@F
E[D@DY@FCW<LBU8=AS4<@Q04?Nl2>Lh2=Jd2<H`2;F/29BT48@P47>L86<HH5:D66<H25:D248@45:D>
48@45:D248@25:D66<H27>L68@P2;F/2BU85Ool10001Ool001Eoo`03001oogoo009oo`9Nm`9S609F
]@9>L`iBU0A>L`QBU1IF]@iBU1A>Lb1:DPe6<@a240@mk`8icP8e[@8aS08]J`8U:@@Q20@Li`PHaP8D
Y@@HaQ8DY@HHaP`DY@P@Q0HDY@8@Q08DY@PHaPHQ208]J`9:DPEoo`40005oo`005Goo00<007ooOol0
0Woo0Ukg0V<H0UJe0Tic3U:D14ic25:D5UJe3U:D54ic84YB3DHa348@13g_0SW>0SF]0S6<0Re[0RDY
124811cW21S60QBU11S64QBU1QS631BU21241QBU0Q240QBU21S61R480Re[0TYB1Goo0@000Goo000E
Ool00`00Oomoo`02Ool4G_L2E[D4DY@2E[D:DY@4CW<8DY@:E[D2F]H:E[D>DY@6CW<2DY@:CW<4BU84
CW<JBU82AS43BU8@AS44@Q04?Nl4>Lh2<H`2;F/29BT48@P47>L>6<H@5:D86<H:5:D<48@85:D46<H2
5:D26<H68@P2;F/2BU85Ool10001Ool001Eoo`03001oogoo009oo`ANm`9F]@ABU09F]@YBU0A>L`QB
U0YF]@9JePYF]@iBU0I>L`9BU0Y>L`A:DPA>LaY:DP96<@=:DQ16<@A240@mk`@icP8aS08]J`8U:@@Q
20@Li`hHaQ0DY@PHaPXDY@`@Q0PDY@@HaP8DY@8HaPHQ208]J`9:DPEoo`40005oo`005Goo00<007oo
Ool00Woo0Ukg0V<H0U[F15:D15Je3U:D0UJe0U:D15Je0U[F0UJe35[F15Je0U:D15Je25:D14ic15:D
4Tic14YB14ic5dYB44Ha1T8@13g_0SW>0S6<0Re[0RDY124811cW3QS641BU21S62QBU312421BU11S6
0QBU0QS61R480S6<0TYB1Goo0@000Goo000EOol20003Ool2G_L2HaP2F]H4DY@4E[D>DY@2E[D2DY@4
E[D2F]H2E[D<F]H4E[D2DY@4E[D8DY@4CW<4DY@BCW<4BU84CW<GBU8@AS46@Q04?Nl2>Lh2<H`2;F/2
9BT48@P47>L>6<H@5:D86<H:5:D<48@85:D46<H25:D26<H68@P2<H`2BU84Ool20001Ool001Eoo`03
001oogoo009oo`9Nm`9S609JePABU0AF]@aBU0AF]@9BU0AF]A1JePAF]@9BU0AF]@ABU09>L`9BU1Y>
L`A:DP9>LaA:DP96<@=:DQ16<@I240@mk`8icP8aS08]J`8U:@@Q20@Li`PHaQ@DY@XHaPXDY@X@Q0XD
Y@HHaP8Li`HQ208aS09:DPEoo`40005oo`005Goo00<007ooOol00Woo0Ukg0V<H0U[F15:D15Je35:D
15Je0U:D15Je45[F15Je0U:D15Je15:D0Tic0U:D6Tic14YB0Tic54YB0THa0dYB44Ha1T8@13g_0SW>
0S6<0Re[0RDY124811cW21S651BU2QS62QBU2Q242QBU1QS60QcW1R480S6<0TYB1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2G_L2HaP2F]H4DY@4E[D<DY@8E[D@F]H6E[D8DY@PCW<4BU82CW<IBU8>AS48
@Q04?Nl2>Lh2<H`2:DX29BT28@P67>L86<HD5:D:6<H:5:D:48@:5:D66<H27>L68@P2<H`2BU85Ool1
0001Ool001Eoo`03001oogoo009oo`9Nm`9S609JePABU0AF]@aBU0QF]A1JePIF]@QBU21>L`A:DP9>
LaU:DPi6<@Q240@mk`8icP8aS08YBP8U:@8Q20HLi`PHaQ@DY@XHaPXDY@X@Q0XDY@HHaP8Li`HQ208a
S09:DPEoo`40005oo`005Goo00<007ooOol00Woo0Ukg0V<H0U[F15:D15Je35:D25Je45[F1UJe2U:D
94ic6dYB44Ha148@13g_0SW>0S6<0Re[0RDY0R481QcW21S651BU11S60QBU11S62QBU2Q242QBU1QS6
0QcW1R480S6<0TYB1Goo0@000Goo000EOol00`00Oomoo`02Ool2G_L2HaP2F]H4DY@4E[D<DY@8E[D@
F]H6E[D:DY@TCW<KBU8@AS44@Q04?Nl2>Lh2<H`2;F/29BT28@P67>L86<HD5:D46<H25:D46<H:5:D:
48@:5:D66<H27>L68@P2<H`2BU85Ool10001Ool001Eoo`03001oogoo009oo`9S609W>@9Nm`AF]@9J
eP9F]@ABU0AF]@ABU0IF]AAJePYF]@YBU09>L`ABU1Y>L`A:DP9>La=:DQ16<@A240@mk`8icP8aS08Y
BP@Q20@Li`HHaQPDY@@HaP8DY@@HaPXDY@@@Q08DY@@@Q0XDY@HHaP8Li`HQ208aS09>L`Eoo`40005o
o`005Goo00<007ooOol00Woo0V<H0VLi0Ukg15Je0U[F0UJe15:D15Je15:D1UJe55[F2UJe2U:D0Tic
15:D6Tic14YB0Tic4dYB44Ha148@13g_0SW>0S6<0RU:124811cW1QS661BU11S60QBU11S62QBU1124
0QBU11242QBU1QS60QcW1R480S6<0Tic1Goo0@000Goo000EOol00`00Oomoo`02Ool2HaP2IcT2G_L4
E[D2F]H2E[D4DY@:E[D8F]H4G_L2F]H4G_L6F]H:E[D:DY@2CW<4DY@JCW<GBU8BAS44@Q04?Nl2>Lh2
<H`2:DX28@P67>L26<HJ5:D66<H25:D46<H:5:D448@45:D248@85:D86<H27>L69BT2<H`2CW<5Ool1
0001Ool001Eoo`8000=oo`9S609W>@9Nm`AF]@9JeP9F]@ABU0YF]@QJePANm`9JePANm`IJePYF]@YB
U09>L`ABU1Y>LaM:DQ96<@A240@mk`8icP8aS08YBP8Q20HLi`8HaQXDY@HHaP8DY@@HaPXDY@@@Q0@D
Y@8@Q0PDY@PHaP8Li`HU:@8aS09>L`Aoo`80005oo`005Goo00<007ooOol00Woo0V<H0VLi0Ukg25Je
15:D2UJe25[F15kg35[F15Je25:D84ic7dYB44Ha1T8@13g_0SF]0Re[0RDY0R4811cW41S63QBU1QS6
0QBU11S62QBU11243QBU0QS60QcW11S60QcW1RDY0S6<0Tic1Goo0@000Goo000EOol00`00Oomoo`02
Ool2HaP2IcT2G_L8E[D4DY@:E[D8F]H4G_L<F]H4E[D8DY@PCW<OBU8@AS46@Q04?Nl2=Jd2;F/29BT2
8@P47>L@6<H>5:D66<H25:D46<H:5:D448@>5:D26<H27>L46<H27>L69BT2<H`2CW<5Ool10001Ool0
01Eoo`03001oogoo009oo`9S609W>@9Nm`QF]@ABU0QF]@QJePINm`YJePIF]@QBU2I>LaU:DQ16<@I2
40@mk`8e[@8]J`8U:@8Q20@Lia0HaQ0DY@8HaP@DY@@HaPXDY@@@Q0hDY@8HaP8Li`@HaP8Li`HU:@8a
S09>L`Eoo`40005oo`005Goo00<007ooOol00Woo0V<H0VLi0Ukg25Je15:D25Je25[F1Ukg2U[F1UJe
25:D9Tic6DYB44Ha1T8@13g_0SF]0Re[0RDY0R4811cW41S641BU0QS611BU11S62QBU11243QBU0QS6
0QcW11S60QcW1RDY0S6<0Tic1Goo0@000Goo000EOol00`00Oomoo`02Ool4IcT2G_L4E[D4F]H4E[D4
F]H2E[D4F]HBG_L6F]H4E[D8DY@4CW<4DY@4CW<4DY@JCW<EBU8@AS48@Q02?Nl2=Jd2;F/29BT28@P4
7>L<6<HJ5:D46<H:5:D448@85:D46<H25:D26<H67>L28@P69BT2=Jd2DY@5Ool10001Ool001Eoo`03
001oogoo009oo`AW>@9Nm`AF]@AJePAF]@AJeP9F]@AJeQ9Nm`IJePAF]@QBU0A>L`ABU0A>L`ABU1Y>
LaE:DQ16<@Q2408mk`8e[@8]J`8U:@8Q20@Li``HaQXDY@@HaPXDY@@@Q0PDY@@HaP8DY@8HaPHLi`8Q
20HU:@8e[@9BU0Eoo`40005oo`005Goo00<007ooOol00Woo0VLi0V]J0Ukg25[F15Je25[F4Ukg1U[F
1UJe25:D14ic15:D14ic0U:D6Tic5dYB3THa248@0Sg_0SW>0SF]0Re[0R4811cW1QS68QBU11S62QBU
0Q242QBU21S61QcW0R481RDY0SF]0U:D1Goo0@000Goo00000goo0000000300000goo000000020003
Ool20005Ool00`00Oomoo`02Ool2IcT2JeX2G_L8F]H4E[D8F]HBG_L6F]H6E[D8DY@4CW<4DY@4CW<2
DY@JCW<GBU8>AS48@Q02?Nl2>Lh2=Jd2;F/28@P47>L66<HR5:D46<H:5:D248@:5:D86<H67>L28@P6
9BT2=Jd2DY@5Ool10001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<007ooOol0
0Woo0VLi0V]J0V<H25[F15Je25[F3Ukg25[F25Je25:D84ic74YB3DHa2T8@13g_0SW>0S6<0RU:0R48
11cW1QS681BU21S60QBU11S631BU21S621cW0R4812DY0RU:0SF]0U:D1Goo0@000Goo0003Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000goo0VLi0V]J0V<H25[F15Je25[F3Ukg
25[F25Je25:D84ic74YB3DHa2T8@13g_0SW>0S6<0RU:0R4811cW1QS681BU21S60QBU11S631BU21S6
21cW0R4812DY0RU:0SF]0U:D17oo0P000Goo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo
00<007ooOol00Woo00<007ooOol00Woo0VLi0V]J0V<H25[F15Je25[F3Ukg2U[F1UJe25:D84ic7TYB
2dHa2T8@13g_0SW>0S6<0RU:0R481QcW21S661BU31S60QBU0QS63QBU21S621cW0R481RU:0SF]0U:D
1Goo0@000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`9W>@9[FP9S60QJePAF]@QJePiNm`YJePIF]@QBU21>Lai:DP]6<@Y240@mk`8icP8aS08Y
BP8Q20HLi`PHaQPDY@`HaP8DY@8HaPhDY@PHaPPLi`8Q20HYBP8e[@9BU0Eoo`40005oo`000Woo0P00
17oo0P0017oo0P001Goo00<007ooOol00Woo0V]J0Vmk0VLi15[F15kg15[F25kg1V<H3Ukg1U[F15Je
25:D34ic15:D44ic14YB2Tic4DYB2THa2T8@13g_0SW>0S6<0RDY0R4811cW1QS671BU31S631BU11S6
0QBU21S60QcW0R4811cW0RDY1RU:0SW>0UJe1Goo0@000Goo000EOol00`00Oomoo`02Ool2JeX2Kg/2
IcT4F]H4G_L4F]H8G_L6HaP>G_L6F]H4E[D8DY@<CW<4DY@@CW<4BU8:CW<ABU8:AS4:@Q04?Nl2>Lh2
<H`29BT28@P47>L66<HL5:D<6<H<5:D46<H25:D86<H27>L28@P47>L29BT6:DX2>Lh2E[D5Ool10001
Ool001Eoo`03001oogoo009oo`9_N`9cW09W>@ANm`9S60QNm`9S60ANm`IS609Nm`AS60QNm`AJePIF
]@QBU0a>L`9BU1a>La1:DP96<@9:DPU6<@Y240Hmk`8e[@8]J`8U:@@Li`@HaPhDY@H@Q0XDYA@HaP@D
Y@XHaPPLi`HQ208U:@H]J`8mk`9JePEoo`40005oo`005Goo00<007ooOol00Woo0Vmk0W>L0VLi15kg
0V<H25kg0V<H15kg1V<H0Ukg16<H25kg15[F1UJe25:D34ic0U:D74ic44YB0THa0TYB2DHa2T8@1Sg_
0SF]0Re[0RDY11cW11S63QBU1Q242QBU51S611BU2QS621cW1R480RDY1Re[0Sg_0U[F1Goo0@000Goo
000EOol00`00Oomoo`02Ool2JeX2Kg/2IcT4G_L2HaP2G_L4F]H8G_L4HaP:G_L8F]H6E[D8DY@PCW<6
BU84CW<8BU84AS42BU8;AS4:@Q0:?Nl2>Lh2=Jd2:DX28@P27>L66<H>5:D248@<5:DR6<H87>L28@P6
9BT2:DX6;F/2?Nl2F]H5Ool10001Ool001Eoo`03001oogoo009oo`9[FP9_N`9W>@ANm`9S609Nm`AJ
ePQNm`AS60YNm`QJePIF]@QBU21>L`I:DPA>L`Q:DPA6<@9:DP]6<@Y240Xmk`8icP8e[@8YBP8Q208L
i`HHaPhDY@8@Q0`DYB8HaPPLi`8Q20HU:@8YBPH]J`8mk`9JePEoo`40005oo`005Goo00<007ooOol0
0Woo0V]J0Vmk0VLi15kg0V<H0Ukg0U[F2Ukg16<H2Ukg25[F1UJe0U:D0Tic15:D8Tic14YB0Tic4TYB
2DHa2T8@2Sg_0SW>0S6<0RU:0R4811cW1QS62QBU0Q2441BU81S621cW0R4812DY0R480RU:1Re[0Sg_
0UJe1Goo0@000Goo000EOol20003Ool2JeX2Kg/2IcT4G_L2HaP2G_L2F]H:G_L4HaP:G_L8F]H6E[D2
DY@2CW<4DY@RCW<4BU82CW<BBU89AS4:@Q0:?Nl2>Lh2<H`2:DX28@P47>L66<H:5:D248@@5:DP6<H8
7>L28@P49BT28@P2:DX6;F/2?Nl2E[D4Ool20001Ool001Eoo`03001oogoo009oo`9cW09g_@9[FPAS
60AW>@AS60AW>@9S60IW>@YS60INm`IJePAF]B1BU11>LaI:DPU6<@Y240@mk`8icP8e[@8]J`8U:@HL
i`8HaP8DYA@@Q10DY@hHaP8DY@8HaPPLi`PQ20HU:@8]J`HaS092409Nm`Eoo`40005oo`005Goo00<0
07ooOol00Woo0W>L0WNm0V]J16<H16Li16<H16Li0V<H1VLi2V<H1Ukg1U[F15Je85:D44ic5TYB2DHa
2T8@13g_0SW>0SF]0Re[0RDY1QcW0QS60QBU512441BU3QS60QBU0QS621cW22481RDY0Re[1S6<0T8@
0Ukg1Goo0@000Goo000EOol00`00Oomoo`06Ool2Mkd4JeX2Kg/BJeX8IcT6HaP4G_L4F]H4E[D2DY@4
E[DHDY@@CW<BBU89AS48@Q0:?Nl2>Lh2=Jd2<H`29BT27>L46<H25:D248@236<:248836<848@65:D6
6<H27>L<6<H27>L68@P89BT2:DX4;F/2<H`2=Jd4>Lh2?Nl2DY@2Kg/5Ool10001Ool001Eoo`03001o
ogoo00Ioo`9g_@A[FP9_Na9[FPQW>@IS60ANm`AJePAF]@9BU0AF]AQBU11>La9:DPU6<@Q240Xmk`8i
cP8e[@8aS08U:@8Li`@HaP8DY@8@Q08<H`X8@PP<H`P@Q0HDY@HHaP8Li``HaP8Li`HQ20PU:@8YBP@]
J`8aS08e[@@icP8mk`9BU09_N`Eoo`40005oo`005Goo00<007ooOol01Woo0W>L16]J0Vmk0V]J16Li
0V]J2VLi1V<H15kg1U[F0UJe1U:D2Tic34YB0Tic3TYB34Ha448@1cg_2SW>1SF]136<0Re[0RU:0RDY
0QS60QBU10aS0PQ20P@Q100010@Q10Q210aS1Q2411BU1QS61QcW3R4812DY1RU:1Re[0S6<0SF]1SW>
0Sg_14Ha0TYB0U[F0W>L1Goo0@000Goo000EOol00`00Oomoo`06Ool2Li`4JeX2Kg/2JeX4IcT2JeX:
IcT6HaP4G_L6F]H2E[D6DY@:CW<<BU82CW<>BU8<AS4@@Q07?Nl:>Lh6=Jd4<H`2;F/2:DX29BT26<H2
5:D436<22482124400041244248436<648@45:D66<H67>L>8@P49BT6:DX6;F/2<H`2=Jd6>Lh2?Nl4
AS42BU82F]H2Li`5Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0
ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool0
01Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(corRelation[Flatten[sample], Flatten[compressedSample]]\)], "Input"],

Cell[BoxData[
    \(0.9299314149859214`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[\((32\ 32)\)/\((128\ 128)\)]\)], "Input"],

Cell[BoxData[
    \(0.0625`\)], "Output"]
}, Open  ]]
}, Closed]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 723}},
CellGrouping->Manual,
WindowSize->{822, 415},
WindowMargins->{{39, Automatic}, {Automatic, 72}},
ShowCellLabel->False
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 101, 2, 70, "Input"],

Cell[CellGroupData[{
Cell[1880, 57, 63, 1, 30, "Input"],
Cell[1946, 60, 512, 13, 210, "Input"]
}, Closed]],
Cell[2473, 76, 26, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[2524, 80, 58, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2607, 85, 26, 0, 30, "Input"],
Cell[2636, 87, 168695, 3363, 29842, "Graphics",
  Evaluatable->True]
}, Closed]],

Cell[CellGroupData[{
Cell[171368, 3455, 40, 0, 27, "Input"],
Cell[171411, 3457, 44, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[171492, 3463, 202, 4, 50, "Input"],
Cell[171697, 3469, 89415, 1622, 296, 39956, 1007, "GraphicsData", \
"PostScript", "Graphics"],
Cell[261115, 5093, 137, 3, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[261279, 5100, 26, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[261330, 5104, 68, 1, 30, "Input"],
Cell[261401, 5107, 69, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[261495, 5112, 83, 1, 30, "Input"],
Cell[261581, 5115, 160504, 2465, 296, 38579, 955, "GraphicsData", \
"PostScript", "Graphics"],
Cell[422088, 7582, 137, 3, 29, "Output"]
}, Open  ]]
}, Closed]],
Cell[422252, 7589, 26, 0, 27, "Input"],

Cell[CellGroupData[{
Cell[422303, 7593, 138, 3, 30, "Input"],
Cell[422444, 7598, 45, 1, 30, "Input"],
Cell[422492, 7601, 253, 6, 66, "Input",
  PageBreakWithin->Automatic],

Cell[CellGroupData[{
Cell[422770, 7611, 73, 1, 30, "Input"],
Cell[422846, 7614, 47305, 1037, 296, 8013, 547, "GraphicsData", "PostScript", \
"Graphics"],
Cell[470154, 8653, 137, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[470328, 8661, 85, 1, 30, "Input"],
Cell[470416, 8664, 52968, 1137, 296, 38579, 955, "GraphicsData", \
"PostScript", "Graphics"],
Cell[523387, 9803, 137, 3, 29, "Output"]
}, Open  ]],
Cell[523539, 9809, 93, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[523657, 9814, 81, 1, 30, "Input"],
Cell[523741, 9817, 93671, 1640, 296, 38579, 955, "GraphicsData", \
"PostScript", "Graphics"],
Cell[617415, 11459, 137, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[617589, 11467, 88, 1, 30, "Input"],
Cell[617680, 11470, 53, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[617770, 11476, 63, 1, 30, "Input"],
Cell[617836, 11479, 41, 1, 29, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

