(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1008035,      23435]*)
(*NotebookOutlinePosition[   1008725,      23459]*)
(*  CellTagsIndexPosition[   1008681,      23455]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\[FilledSquare]\ \ \:304a\:307e\:3058\:306a\:3044\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(\(\n\)\(<< \ LinearAlgebra`MatrixManipulation`;\)\)\)], "Input"]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
coif6={{-.051429728471, .238929728471, .602859456942, 
 \t\t .272140543058,-.051429972847,-.011070271529},
 \t   {-.011070271529, .051429972847, .272140543058,
\t\t-.602859456942, .238929728471, .051429728471}}*
\t\tSqrt[2.];
coif12={{ .011587596739,-.029320137980,-.047639590310, 
 \t\t  .273021046535, .574682393857, .294867193696,
\t\t -.054085607092,-.042026480461, .016744410163, 
 \t\t  .003967883613,-.001289203356,-.000509505399},
 \t\t{-.000509505399, .001289203356, .003967883613,
 \t\t -.016744410163,-.042026480461, .054085607092,
 \t\t  .294867193696,-.574682393857, .273021046535,
\t\t  .047639590310,-.029320137980,-.011587596739}}*
\t\t Sqrt[2.];
coif18={{-.002682418671, .005503126709, .016583560479, 
\t\t -.046507764479,-.043220763560, .286503335274,
 \t\t  .561285256870, .302983571773,-.050770140755, 
\t\t -.058196250762, .024434094321, .011229240962, 
\t\t -.006369601011,-.001820458916, .000790205101,
 \t\t  .000329665174,-.000050192775,-.000024465734},
 \t\t{-.000024465734, .000050192775, .000329665174,
 \t\t -.000790205101,-.001820458916, .006369601011,
 \t\t  .011229240962,-.024434094321,-.058196250762,
 \t\t  .050770140755, .302983571773,-.561285256870,
 \t\t  .286503335274, .043220763560,-.046507764479,
 \t\t -.016583560479, .005503126709, .002682418671}}*
 \t\tSqrt[2.];
coif24={{ .000630961046,-.001152224852,-.005194524026, 
 \t\t  .011362459244, .018867235378,-.057464234429, 
\t\t -.039652648517, .293667390895, .553126452562, 
 \t\t  .307157326198,-.047112738865,-.068038127051,
 \t\t  .027813640153, .017735837438,-.010756318517,
\t\t -.004001012886, .002652665946, .000895594529,
\t\t -.000416500571,-.000183829769, .000044080354, 
 \t\t  .000022082857,-.000002304942,-.000001262175},
 \t\t{-.000001262175, .000002304942, .000022082857,
 \t\t -.000044080354,-.000183829769, .000416500571,
 \t\t  .000895594529,-.002652665946,-.004001012886,
 \t\t  .010756318517, .017735837438,-.027813640153,
 \t\t -.068038127051, .047112738865, .307157326198,
 \t\t -.553126452562, .293667390895, .039652648517,
 \t\t -.057464234429,-.018867235378, .011362459244,
 \t\t  .005194524026,-.001152224852,-.000630961046}}*
 \t\tSqrt[2.];
coif30={{-.000149963800, .000253561200, .001540245700, 
\t\t -.002941110800,-.007163781900, .016552066400, 
 \t\t  .019917804300,-.064997262800,-.036800073600,
 \t\t  .298092323500, .547505429400, .309706849000, 
\t\t -.043866050800,-.074652238900, .029195879500, 
 \t\t  .023110777000,-.013973687900,-.006480090000, 
 \t\t  .004783001400, .001720654700,-.001175822200,
\t\t -.000451227000, .000213729800, .000099377600,
\t\t -.000029232100,-.000015072000, .000002640800, 
 \t\t  .000001459300,-.000000118400,-.000000067300},
 \t\t{-.000000067300, .000000118400, .000001459300,
 \t\t -.000002640800,-.000015072000, .000029232100,
 \t\t  .000099377600,-.000213729800,-.000451227000,
 \t\t  .001175822200, .001720654700,-.004783001400,
 \t\t -.006480090000, .013973687900, .023110777000,
 \t\t -.029195879500,-.074652238900, .043866050800,
 \t\t  .309706849000,-.547505429400, .298092323500,
 \t\t  .036800073600,-.064997262800,-.019917804300,
 \t\t  .016552066400, .007163781900,-.002941110800,
 \t\t -.001540245700, .000253561200, .000149963800}}*
 \t\tSqrt[2.]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell[BoxData[
    \(Matrix\ Wavelet\ \[FilledSquare]\)], "Output"],

Cell[BoxData[""], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Fourier\ and\ Wavelet\ transforms\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ \ Sample\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(a = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 
            0, 0, 0, 1}, {1, 1, 1, 1, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 0, 0, 
            1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 
            1, 0, 0\ , 0, 1}};\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[a]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "0", "1", "1", "0", "0", "0", "1"},
            {"0", "0", "1", "1", "1", "1", "0", "1"},
            {"1", "1", "0", "1", "0", "0", "0", "1"},
            {"1", "1", "1", "1", "0", "1", "0", "0"},
            {"1", "0", "1", "1", "0", "0", "0", "1"},
            {"0", "0", "1", "1", "1", "1", "0", "1"},
            {"1", "1", "0", "1", "0", "1", "0", "1"},
            {"1", "1", "1", "1", "0", "0", "0", "1"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[a, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00
@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`8000Aoob7oob4004;o
of@0027oo`=oo`80009oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo
8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012
oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0
027oo`Aoo`40005oo`5oo`002Woo0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`8000Aood80
08Coob80027oo`=oo`80009oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo
17oo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool0
009oo`03001oogoo00Eoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`000goo00<0
07ooOol017oo0`000goo@P00Q?oo8P008Ooo0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomo
o`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`03
Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo00=ood;oob40027o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ
000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool20004
Oom2oolQ000QoomT000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40
027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`8000Aood;oob40027oof@0027oo`=oo`80009o
o`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4
oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40005o
o`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool20004Oon4oolQ000Qoom30003Ool20002Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40
027ood<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
ob40027ood<000Aoo`40005oo`5oo`0017oo0`000goo00<007ooOol00gooQ?oo8@008Ooo@`0017oo
0@000Goo0Goo0005Ool00`00Oomoo`02Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1
Ool0009oo`D000=oo`<000=oohCoob40027ood<0009oo`<0009oo`000Woo00@007ooOol000Aoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`000goo00<007oo000017oo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo0004Ool20004Ool00`00Oomoo`03OolQoolQ
0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo
0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool20004OolQoolQ0012oomT000Qool3Ool2
0002Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo0P0017oo@P00Q?oo8P008Ooo0goo0P000Woo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
0024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom20024oolR000Qool4Ool10001Ool1Ool0009oo`<000Eoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood8008Coob80027oo`Aoo`40
005oo`5oo`000Woo00@007ooOol000Aoo`<000=ood;oob40027oob40027oob80027oo`9oo`<0009o
o`000Woo0`001Goo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo0003
Ool00`00Oomoo`04Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool0
00=oo`<000Aoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool20004Oom2oolQ
000QoolQ000QoolR000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`8000AoohCoof@0027oo`=oo`80009oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool20004Oon4oomT000Qool3Ool20002
Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0
027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
0002Ool01000Oomoo`0017oo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo0002Ool01000
Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005Ool00`00Oomoo`3oOolAOol10001Ool1Ool0
009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol10001Ool1Ool000=oo`8000Eoo`03001oogoo
0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<0
07ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo0@00
0Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Fourier\ Transform\)], "Input"],

Cell[BoxData[
    \(\(fa = Fourier[a];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[fa], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF84817D9F7D8184
11071A1E11071A1E
1152357158255886
111E312A111E312A
356F403A113A406F
112A311E112A311E
1186582558713552
111E1A07111E1A07
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7ood92
424mkb5>Lb4mkd=240Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7ood92
424mkb5>Lb4mkd=240Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8Ooo@T8@8Cg_8Dic
8Cg_@d8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2@Q0Q?NlQCW<Q?Nm3@Q04Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7ood92424mkb5>Lb4mkd=240Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo@T8@8Cg_8Dic8Cg_@d8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2
@Q0Q?NlQCW<Q?Nm3@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood92424mkb5>Lb4mkd=2
40Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo@T8@8Cg_8Dic8Cg_@d8@17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQoom2@Q0Q?NlQCW<Q?Nm3@Q04Ool10001Ool1Ool000Yoo`03001oogoo
00=oob7ood92424mkb5>Lb4mkd=240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo@T8@8Cg_
8Dic8Cg_@d8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2@Q0Q?NlQCW<Q?Nm3@Q04Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7ood92424mkb5>Lb4mkd=240Aoo`40005oo`5oo`002Woo
00<007ooOol00goo8Ooo@T8@8Cg_8Dic8Cg_@d8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oom2@Q0Q?NlQCW<Q?Nm3@Q04Ool10001Ool1Ool000Yoo`8000Aoob7ood92424mkb5>Lb4mkd=240=o
o`80009oo`002Woo00<007ooOol00goo8Ooo@T8@8Cg_8Dic8Cg_@d8@17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQoom2@Q0Q?NlQCW<Q?Nm3@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob7o
od92424mkb5>Lb4mkd=240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo@T8@8Cg_8Dic8Cg_
@d8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2@Q0Q?NlQCW<Q?Nm3@Q04Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7ood92424mkb5>Lb4mkd=240Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo@T8@8Cg_8Dic8Cg_@d8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2@Q0Q
?NlQCW<Q?Nm3@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood92424mkb5>Lb4mkd=240Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8Ooo@T8@8Cg_8Dic8Cg_@d8@17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQoom2@Q0Q?NlQCW<Q?Nm3@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob7ood92424mkb5>Lb4mkd=240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo@T8@8Cg_8Dic
8Cg_@d8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2@Q0Q?NlQCW<Q?Nm3@Q04Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7ood92424mkb5>Lb4mkd=240Aoo`40005oo`5oo`002Woo0P00
17oo8Ooo@T8@8Cg_8Dic8Cg_@d8@0goo0P000Woo000:Ool00`00Oomoo`03OolQ248Q001236<Q248Q
001336<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R40048<Hb48@R4004<<H`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8@Q28@00@PaS8@Q28@00@`aS17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQ248Q001236<Q248Q001336<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R40
048<Hb48@R4004<<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@00@PaS8@Q28@00@`aS
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q001236<Q248Q001336<4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob48@R40048<Hb48@R4004<<H`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8@Q28@00@PaS8@Q28@00@`aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q001236<Q
248Q001336<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R40048<Hb48@R4004<<H`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8@Q28@00@PaS8@Q28@00@`aS17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQ248Q001236<Q248Q001336<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48
@R40048<Hb48@R4004<<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@00@PaS8@Q28@00
@`aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q001236<Q248Q001336<4Ool10001Ool1
Ool000Yoo`8000Aoob48@R40048<Hb48@R4004<<H`=oo`80009oo`002Woo00<007ooOol00goo8@Q2
8@00@PaS8@Q28@00@`aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q001236<Q248Q0013
36<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R40048<Hb48@R4004<<H`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8@Q28@00@PaS8@Q28@00@`aS17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQ248Q001236<Q248Q001336<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R40048<
Hb48@R4004<<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@00@PaS8@Q28@00@`aS17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q001236<Q248Q001336<4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob48@R40048<Hb48@R4004<<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8@Q28@00@PaS8@Q28@00@`aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q001236<Q248Q
001336<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R40048<Hb48@R4004<<H`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8@Q28@00@PaS8@Q28@00@`aS17oo0@000Goo0Goo0002Ool40004
Ool00`00Oomoo`03OolQ248Q001236<Q248Q001336<4Ool10001Ool1Ool0009oo`03001oogoo00Eo
o`03001oogoo00=oob48@R40048<Hb48@R4004<<H`Aoo`40005oo`5oo`000goo00<007ooOol017oo
0`000goo8@Q28@00@PaS8@Q28@00@`aS0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomoo`03
OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00
Oomoo`03OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool000=oo`8000Eoo`03001o
ogoo00=oob48@R4YBR4HaR4icR4]Jb4@Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8@Q28BU:8AS68CW>8Be[8A248Re[8D8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q:DXQ
6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4YBR4HaR4icR4]
Jb4@Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28BU:8AS68CW>8Be[8A248Re[
8D8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob48@R4YBR4HaR4icR4]Jb4@Q28]Jb5240Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8@Q28BU:8AS68CW>8Be[8A248Re[8D8@17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool000Yoo`03001oogoo
00=oob48@R4YBR4HaR4icR4]Jb4@Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q2
8BU:8AS68CW>8Be[8A248Re[8D8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q:DXQ6<HQ
>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4YBR4HaR4icR4]Jb4@
Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28BU:8AS68CW>8Be[8A248Re[8D8@
17oo0@000Goo0Goo000:Ool20004OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q03Ool20002Ool000Yo
o`03001oogoo00=oob48@R4YBR4HaR4icR4]Jb4@Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8@Q28BU:8AS68CW>8Be[8A248Re[8D8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4YBR4H
aR4icR4]Jb4@Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28BU:8AS68CW>8Be[
8A248Re[8D8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q
@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4YBR4HaR4icR4]Jb4@Q28]Jb5240Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8@Q28BU:8AS68CW>8Be[8A248Re[8D8@17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool000Yoo`03
001oogoo00=oob48@R4YBR4HaR4icR4]Jb4@Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8@Q28BU:8AS68CW>8Be[8A248Re[8D8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q
:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4YBR4HaR4i
cR4]Jb4@Q28]Jb5240Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28BU:8AS68CW>8Be[8A24
8Re[8D8@17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q:DXQ6<HQ>LhQ;F/Q48@R;F/Q@Q04
Ool10001Ool1Ool000Yoo`8000Aoob48@R4YBR4HaR4icR4]Jb4@Q28]Jb5240=oo`80009oo`002Woo
00<007ooOol00goo8@Q28@aS8AS68ABU8@Q28@aS8QS68ABU17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQ248Q36<Q6<HQ5:DQ248Q36<R6<HQ5:D4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48
@R4<Hb4HaR4DYB48@R4<Hb8HaR4DY@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@aS8AS6
8ABU8@Q28@aS8QS68ABU17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q36<Q6<HQ5:DQ248Q
36<R6<HQ5:D4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4<Hb4HaR4DYB48@R4<Hb8HaR4D
Y@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@aS8AS68ABU8@Q28@aS8QS68ABU17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQ248Q36<Q6<HQ5:DQ248Q36<R6<HQ5:D4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob48@R4<Hb4HaR4DYB48@R4<Hb8HaR4DY@Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8@Q28@aS8AS68ABU8@Q28@aS8QS68ABU17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQ248Q36<Q6<HQ5:DQ248Q36<R6<HQ5:D4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4<
Hb4HaR4DYB48@R4<Hb8HaR4DY@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@aS8AS68ABU
8@Q28@aS8QS68ABU17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q36<Q6<HQ5:DQ248Q36<R
6<HQ5:D4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4<Hb4HaR4DYB48@R4<Hb8HaR4DY@Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@aS8AS68ABU8@Q28@aS8QS68ABU17oo0@000Goo
0Goo000:Ool20004OolQ248Q36<Q6<HQ5:DQ248Q36<R6<HQ5:D3Ool20002Ool000Yoo`03001oogoo
00=oob48@R4<Hb4HaR4DYB48@R4<Hb8HaR4DY@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q2
8@aS8AS68ABU8@Q28@aS8QS68ABU17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q36<Q6<HQ
5:DQ248Q36<R6<HQ5:D4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4<Hb4HaR4DYB48@R4<
Hb8HaR4DY@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@aS8AS68ABU8@Q28@aS8QS68ABU
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q36<Q6<HQ5:DQ248Q36<R6<HQ5:D4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob48@R4<Hb4HaR4DYB48@R4<Hb8HaR4DY@Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8@Q28@aS8AS68ABU8@Q28@aS8QS68ABU17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQ248Q36<Q6<HQ5:DQ248Q36<R6<HQ5:D4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob48@R4<Hb4HaR4DYB48@R4<Hb8HaR4DY@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28@aS
8AS68ABU8@Q28@aS8QS68ABU17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q36<Q6<HQ5:DQ
248Q36<R6<HQ5:D4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4<Hb4HaR4DYB48@R4<Hb8H
aR4DY@Aoo`40005oo`5oo`0017oo0`000goo00<007ooOol00goo8@Q28@aS8AS68ABU8@Q28@aS8QS6
8ABU17oo0@000Goo0Goo0005Ool00`00Oomoo`02Ool00`00Oomoo`03OolQ248Q36<Q6<HQ5:DQ248Q
36<R6<HQ5:D4Ool10001Ool1Ool0009oo`D000=oo`<000=oob48@R4<Hb4HaR4DYB48@R4<Hb8HaR4D
Y@9oo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q
224e[@Aoo`40005oo`5oo`000goo00<007oo000017oo00<007ooOol00goo8AS68CF]8B488AcW8@Q2
8AcW8R488CF]17oo0@000Goo0Goo0004Ool20004Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ248Q
7>LR8@PQ=Jd4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q224e
[@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8AS68CF]8B488AcW8@Q28AcW8R488CF]17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ248Q7>LR8@PQ=Jd4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q224e[@Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8AS68CF]8B488AcW8@Q28AcW8R488CF]17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQ6<HQ=JdQ8@PQ7>LQ248Q7>LR8@PQ=Jd4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4HaR4e
[B4Q224Lib48@R4Lib8Q224e[@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8AS68CF]8B488AcW
8@Q28AcW8R488CF]17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ248Q7>LR
8@PQ=Jd4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q224e[@Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8AS68CF]8B488AcW8@Q28AcW8R488CF]17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ248Q7>LR8@PQ=Jd4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q224e[@Aoo`40005oo`5oo`002Woo0P0017oo
8AS68CF]8B488AcW8@Q28AcW8R488CF]0goo0P000Woo000:Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ
7>LQ248Q7>LR8@PQ=Jd4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4L
ib8Q224e[@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8AS68CF]8B488AcW8@Q28AcW8R488CF]
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ248Q7>LR8@PQ=Jd4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q224e[@Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8AS68CF]8B488AcW8@Q28AcW8R488CF]17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ248Q7>LR8@PQ=Jd4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob4HaR4e[B4Q224Lib48@R4Lib8Q224e[@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8AS68CF]
8B488AcW8@Q28AcW8R488CF]17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ
248Q7>LR8@PQ=Jd4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q
224e[@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8AS68CF]8B488AcW8@Q28AcW8R488CF]17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQ6<HQ=JdQ8@PQ7>LQ248Q7>LR8@PQ=Jd4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob4HaR4e[B4Q224Lib48@R4Lib8Q224e[@Aoo`40005oo`5oo`002Woo
00<007ooOol00goo8AS68CF]8B488AcW8@Q28AcW8R488CF]17oo0@000Goo0Goo000:Ool20004OolQ
6<HQ=JdQ8@PQ7>LQ248Q7>LR8@PQ=Jd3Ool20002Ool000Yoo`03001oogoo00=oob48@R4DYB4HaR4<
Hb48@R4DYB8HaR4<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28ABU8AS68@aS8@Q28ABU
8QS68@aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR6<HQ36<4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8@Q28ABU8AS68@aS8@Q28ABU8QS68@aS17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR6<HQ36<4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8@Q28ABU8AS68@aS8@Q28ABU8QS68@aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q5:DQ
6<HQ36<Q248Q5:DR6<HQ36<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4DYB4HaR4<Hb48
@R4DYB8HaR4<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28ABU8AS68@aS8@Q28ABU8QS6
8@aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR6<HQ36<4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8@Q28ABU8AS68@aS8@Q28ABU8QS68@aS17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR6<HQ36<4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40005oo`5oo`002Woo0P0017oo8@Q28ABU8AS6
8@aS8@Q28ABU8QS68@aS0goo0P000Woo000:Ool00`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR
6<HQ36<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8@Q28ABU8AS68@aS8@Q28ABU8QS68@aS17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR6<HQ36<4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8@Q28ABU8AS68@aS8@Q28ABU8QS68@aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
248Q5:DQ6<HQ36<Q248Q5:DR6<HQ36<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4DYB4H
aR4<Hb48@R4DYB8HaR4<H`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28ABU8AS68@aS8@Q2
8ABU8QS68@aS17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR6<HQ
36<4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8@Q28ABU8AS68@aS8@Q28ABU8QS68@aS17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQ248Q5:DQ6<HQ36<Q248Q5:DR6<HQ36<4Ool10001Ool1Ool0009oo`<0
00Eoo`03001oogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`03001oogoo00=oob48@R4DYB4HaR4<Hb48@R4DYB8HaR4<H`Aoo`40005oo`5oo`00
0Woo00@007ooOol000Aoo`<000=oob48@R52424]Jb4@Q24]Jb4icR8HaR4YBP9oo`<0009oo`000Woo
0`001Goo00<007ooOol00goo8@Q28D8@8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo0003Ool0
0`00Oomoo`04Ool00`00Oomoo`03OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool0
00=oo`<000Aoo`03001oogoo00=oob48@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005oo`5oo`00
2Woo00<007ooOol00goo8@Q28D8@8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob48@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28D8@
8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q@Q0Q;F/Q48@Q
;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R52424]Jb4@Q24]Jb4icR8H
aR4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28D8@8Be[8A248Be[8CW>8QS68BU:17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob48@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005oo`5oo`002Woo
00<007ooOol00goo8@Q28D8@8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48
@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28D8@8Be[
8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:Ool20004OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ
:DX3Ool20002Ool000Yoo`03001oogoo00=oob48@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005o
o`5oo`002Woo00<007ooOol00goo8@Q28D8@8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob48@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo
8@Q28D8@8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q@Q0Q
;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@R52424]Jb4@Q24]
Jb4icR8HaR4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q28D8@8Be[8A248Be[8CW>8QS6
8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob48@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005oo`5o
o`002Woo00<007ooOol00goo8@Q28D8@8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQ248Q@Q0Q;F/Q48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob48@R52424]Jb4@Q24]Jb4icR8HaR4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q2
8D8@8Be[8A248Be[8CW>8QS68BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ248Q@Q0Q;F/Q
48@Q;F/Q>LhR6<HQ:DX4Ool10001Ool1Ool000Yoo`8000Aoob48@T8<Hb400248@T<<Hb4000=oo`80
009oo`002Woo00<007ooOol00goo8@Q2@PaS8@008@Q2@`aS8@0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQ249236<Q000Q249336<Q0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@T8<
Hb400248@T<<Hb4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q2@PaS8@008@Q2@`aS8@00
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ249236<Q000Q249336<Q0004Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob48@T8<Hb400248@T<<Hb4000Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8@Q2@PaS8@008@Q2@`aS8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ249236<Q000Q
249336<Q0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@T8<Hb400248@T<<Hb4000Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8@Q2@PaS8@008@Q2@`aS8@0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQ249236<Q000Q249336<Q0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob48
@T8<Hb400248@T<<Hb4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q2@PaS8@008@Q2@`aS
8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ249236<Q000Q249336<Q0004Ool10001Ool1
Ool000Yoo`03001oogoo00=oob48@T8<Hb400248@T<<Hb4000Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8@Q2@PaS8@008@Q2@`aS8@0017oo0@000Goo0Goo000:Ool20004OolQ249236<Q000Q2493
36<Q0003Ool20002Ool000Yoo`03001oogoo00=oob48@T8<Hb400248@T<<Hb4000Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8@Q2@PaS8@008@Q2@`aS8@0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQ249236<Q000Q249336<Q0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@T8<Hb40
0248@T<<Hb4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo8@Q2@PaS8@008@Q2@`aS8@0017oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQ249236<Q000Q249336<Q0004Ool10001Ool1Ool000Yo
o`03001oogoo00=oob48@T8<Hb400248@T<<Hb4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8@Q2@PaS8@008@Q2@`aS8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ249236<Q000Q2493
36<Q0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@T8<Hb400248@T<<Hb4000Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8@Q2@PaS8@008@Q2@`aS8@0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQ249236<Q000Q249336<Q0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob48@T8<
Hb400248@T<<Hb4000Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8@Q2@PaS8@008@Q2
@`aS8@0017oo0@000Goo0Goo0002Ool01000Oomoo`0017oo00<007ooOol00goo8@Q2@PaS8@008@Q2
@`aS8@0017oo0@000Goo0Goo0002Ool01000Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005
Ool00`00Oomoo`3oOolAOol10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol1
0001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol00Woo0@000Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[InverseFourier[fa]], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00
@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`8000Aoob7oob4004;o
of@0027oo`=oo`80009oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo
8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012
oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0
027oo`Aoo`40005oo`5oo`002Woo0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`8000Aood80
08Coob80027oo`=oo`80009oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo
17oo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool0
009oo`03001oogoo00Eoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`000goo00<0
07ooOol017oo0`000goo@P00Q?oo8P008Ooo0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomo
o`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`03
Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo00=ood;oob40027o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ
000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool20004
Oom2oolQ000QoomT000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40
027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`8000Aood;oob40027oof@0027oo`=oo`80009o
o`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4
oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40005o
o`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool20004Oon4oolQ000Qoom30003Ool20002Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40
027ood<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
ob40027ood<000Aoo`40005oo`5oo`0017oo0`000goo00<007ooOol00gooQ?oo8@008Ooo@`0017oo
0@000Goo0Goo0005Ool00`00Oomoo`02Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1
Ool0009oo`D000=oo`<000=oohCoob40027ood<0009oo`<0009oo`000Woo00@007ooOol000Aoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`000goo00<007oo000017oo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo0004Ool20004Ool00`00Oomoo`03OolQoolQ
0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo
0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool20004OolQoolQ0012oomT000Qool3Ool2
0002Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo0P0017oo@P00Q?oo8P008Ooo0goo0P000Woo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
0024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom20024oolR000Qool4Ool10001Ool1Ool0009oo`<000Eoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood8008Coob80027oo`Aoo`40
005oo`5oo`000Woo00@007ooOol000Aoo`<000=ood;oob40027oob40027oob80027oo`9oo`<0009o
o`000Woo0`001Goo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo0003
Ool00`00Oomoo`04Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool0
00=oo`<000Aoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool20004Oom2oolQ
000QoolQ000QoolR000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`8000AoohCoof@0027oo`=oo`80009oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool20004Oon4oomT000Qool3Ool20002
Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0
027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
0002Ool01000Oomoo`0017oo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo0002Ool01000
Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005Ool00`00Oomoo`3oOolAOol10001Ool1Ool0
009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol10001Ool1Ool000=oo`8000Eoo`03001oogoo
0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<0
07ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo0@00
0Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ \ Wavelet\ Transform\)], "Input"],

Cell[BoxData[
    \(\(wa = waveletMatrix[8, coif6] . a;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[wa, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
CEDD96F07CA55AC7
C76DFFF0839F5ACC
CEDD96F07CD75AF0
C76DFFF083795AF2
4B28315A690F5AB4
B48C385A002B5A52
4B28315A69925A5A
B48C385A00065A52
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob5W>B5_
Nb5:DR5kgR4mkb5BU28]Jb5S60Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=o
ob5W>B5_Nb5:DR5kgR4mkb5BU28]Jb5S60Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo
8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/Q
BU8QNmhQ?NlQDY@R;F/QHaP4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4m
kb5BU28]Jb5S60Aoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[
8F<H17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQDY@R;F/QHaP4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5BU28]Jb5S60Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQDY@R;F/QHaP4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob5W>B5_Nb5:DR5kgR4mkb5BU28]Jb5S60Aoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi
8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8Q
NmhQ?NlQDY@R;F/QHaP4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5B
U28]Jb5S60Aoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQDY@R;F/QHaP4Ool10001
Ool1Ool000Yoo`8000Aoob5W>B5_Nb5:DR5kgR4mkb5BU28]Jb5S60=oo`80009oo`002Woo00<007oo
Ool00goo8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
IcTQKg/QBU8QNmhQ?NlQDY@R;F/QHaP4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:
DR5kgR4mkb5BU28]Jb5S60Aoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_
8E:D8Re[8F<H17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQDY@R;F/Q
HaP4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5BU28]Jb5S60Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQDY@R;F/QHaP4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5BU28]Jb5S60Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQ
Kg/QBU8QNmhQ?NlQDY@R;F/QHaP4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5k
gR4mkb5BU28]Jb5S60Aoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8E:D
8Re[8F<H17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQDY@R;F/QHaP4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5BU28]Jb5S60Aoo`40005o
o`5oo`002Woo0P0017oo8FLi8Fmk8DYB8G_N8Cg_8E:D8Re[8F<H0goo0P000Woo000:Ool00`00Oomo
o`03OolQHaPQ=JdQoolQNmhQ@Q0QCW<R;F/QIcT4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S
624e[B7oob5kgR52425>Lb8]Jb5W>@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo
8G_N8D8@8Dic8Re[8FLi17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q
CW<R;F/QIcT4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52425>Lb8]Jb5W
>@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Dic8Re[8FLi17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0QCW<R;F/QIcT4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob5S624e[B7oob5kgR52425>Lb8]Jb5W>@Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Dic8Re[8FLi17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQHaPQ=JdQoolQNmhQ@Q0QCW<R;F/QIcT4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e
[B7oob5kgR52425>Lb8]Jb5W>@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N
8D8@8Dic8Re[8FLi17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0QCW<R
;F/QIcT4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52425>Lb8]Jb5W>@Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Dic8Re[8FLi17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0QCW<R;F/QIcT4Ool10001Ool1Ool000Yo
o`8000Aoob5S624e[B7oob5kgR52425>Lb8]Jb5W>@=oo`80009oo`002Woo00<007ooOol00goo8F<H
8CF]8Ooo8G_N8D8@8Dic8Re[8FLi17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQ
NmhQ@Q0QCW<R;F/QIcT4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52425>
Lb8]Jb5W>@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Dic8Re[8FLi
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0QCW<R;F/QIcT4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52425>Lb8]Jb5W>@Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Dic8Re[8FLi17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0QCW<R;F/QIcT4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob5S624e[B7oob5kgR52425>Lb8]Jb5W>@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]
8Ooo8G_N8D8@8Dic8Re[8FLi17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ
@Q0QCW<R;F/QIcT4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52425>Lb8]
Jb5W>@Aoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Dic8Re[8FLi17oo
0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0QCW<R;F/QIcT4Ool1
0001Ool1Ool0009oo`03001oogoo00Eoo`03001oogoo00=oob5S624e[B7oob5kgR52425>Lb8]Jb5W
>@Aoo`40005oo`5oo`000goo00<007ooOol017oo0`000goo8F<H8CF]8Ooo8G_N8D8@8Dic8Re[8FLi
0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/Q
Nmh4Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQ
JeXR;F/QNmh4Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5[
FR8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[8G_N
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5[FR8]Jb5kgPAoo`40005oo`5oo`00
2Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[8G_N17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob5W>B5_Nb5:DR5kgR4mkb5[FR8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk
8DYB8G_N8Cg_8F]J8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ
?NlQJeXR;F/QNmh4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5[FR8]
Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[8G_N17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5[FR8]Jb5kgPAoo`40005oo`5oo`002Woo
00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[8G_N17oo0@000Goo0Goo000:Ool20004OolQ
IcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh3Ool20002Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5k
gR4mkb5[FR8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J
8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5[FR8]Jb5kgPAoo`40005o
o`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[8G_N17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob5W>B5_Nb5:DR5kgR4mkb5[FR8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo
8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/Q
BU8QNmhQ?NlQJeXR;F/QNmh4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4m
kb5[FR8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[
8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob5W>B5_Nb5:DR5kgR4mkb5[FR8]Jb5kgPAoo`40005oo`5o
o`002Woo00<007ooOol00goo8FLi8Fmk8DYB8G_N8Cg_8F]J8Re[8G_N17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQIcTQKg/QBU8QNmhQ?NlQJeXR;F/QNmh4Ool10001Ool1Ool000Yoo`8000Aoob5W
>B5_Nb5:DR5kgR4mkb5[FR8]Jb5kgP=oo`80009oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N
8D8@8Cg_8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR
;F/QNmh4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52424mkb8]Jb5kgPAo
o`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR;F/QNmh4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob5S624e[B7oob5kgR52424mkb8]Jb5kgPAoo`40005oo`5oo`002Woo00<007oo
Ool00goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
HaPQ=JdQoolQNmhQ@Q0Q?NlR;F/QNmh4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7o
ob5kgR52424mkb8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@
8Cg_8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR;F/Q
Nmh4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52424mkb8]Jb5kgPAoo`40
005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR;F/QNmh4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob5S624e[B7oob5kgR52424mkb8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol0
0goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo0@000Goo0Goo000:Ool20004OolQHaPQ=JdQoolQ
NmhQ@Q0Q?NlR;F/QNmh3Ool20002Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52424mkb8]
Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR;F/QNmh4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52424mkb8]Jb5kgPAoo`40005oo`5oo`002Woo
00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR;F/QNmh4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S
624e[B7oob5kgR52424mkb8]Jb5kgPAoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo
8G_N8D8@8Cg_8Re[8G_N17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q
?NlR;F/QNmh4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5S624e[B7oob5kgR52424mkb8]Jb5k
gPAoo`40005oo`5oo`002Woo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR;F/QNmh4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob5S624e[B7oob5kgR52424mkb8]Jb5kgPAoo`40005oo`5oo`0017oo0`00
0goo00<007ooOol00goo8F<H8CF]8Ooo8G_N8D8@8Cg_8Re[8G_N17oo0@000Goo0Goo0005Ool00`00
Oomoo`02Ool00`00Oomoo`03OolQHaPQ=JdQoolQNmhQ@Q0Q?NlR;F/QNmh4Ool10001Ool1Ool0009o
o`D000=oo`<000=oob5S624e[B7oob5kgR52424mkb8]Jb5kgP9oo`<0009oo`000Woo00@007ooOol0
00Aoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`000goo00<0
07oo000017oo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo0004
Ool20004Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo00<007oo
Ool00goo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4H
aR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]
8@@Q8Re[8E[F17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/Q
F]H4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B448B8]Jb5JePAoo`40
005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo00<007ooOol0
0goo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ
5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]
Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo0P0017oo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F
0goo0P000Woo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo
00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U
:B4DYB4HaR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS6
8Be[8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQ
124R;F/QF]H4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B448B8]Jb5J
ePAoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo00<0
07ooOol00goo8BDY8ABU8AS68Be[8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4D
YB4HaR4]Jb4e[B448B8]Jb5JePAoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[
8CF]8@@Q8Re[8E[F17oo0@000Goo0Goo000:Ool20004OolQ9BTQ5:DQ6<HQ;F/Q=JdQ124R;F/QF]H3
Ool20002Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5o
o`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[8@008ABU8Re[8BU:17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQF]HQAS4Q7>LQ;F/Q000Q5:DR;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob5JeR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F
8DHa8AcW8Be[8@008ABU8Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ
;F/Q000Q5:DR;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jb40024D
YB8]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[8@008ABU8Re[8BU:
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F/Q000Q5:DR;F/Q:DX4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`00
2Woo00<007ooOol00goo8E[F8DHa8AcW8Be[8@008ABU8Re[8BU:17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQF]HQAS4Q7>LQ;F/Q000Q5:DR;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob5JeR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa
8AcW8Be[8@008ABU8Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F/Q
000Q5:DR;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jb40024DYB8]
Jb4YBPAoo`40005oo`5oo`002Woo0P0017oo8E[F8DHa8AcW8Be[8@008ABU8Re[8BU:0goo0P000Woo
000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F/Q000Q5:DR;F/Q:DX4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob5JeR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol0
0goo8E[F8DHa8AcW8Be[8@008ABU8Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQ
AS4Q7>LQ;F/Q000Q5:DR;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]
Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[8@008ABU
8Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F/Q000Q5:DR;F/Q:DX4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005o
o`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[8@008ABU8Re[8BU:17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F/Q000Q5:DR;F/Q:DX4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob5JeR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo
8E[F8DHa8AcW8Be[8@008ABU8Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q
7>LQ;F/Q000Q5:DR;F/Q:DX4Ool10001Ool1Ool0009oo`<000Eoo`03001oogoo00=oob5JeR56<B4L
ib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob5J
eR56<B4Lib4]Jb40024DYB8]Jb4YBPAoo`40005oo`5oo`000Woo00@007ooOol000Aoo`<000=oob4U
:B4DYB4HaR4]Jb4e[B5:DT<]J`9oo`<0009oo`000Woo0`001Goo00<007ooOol00goo8BDY8ABU8AS6
8Be[8CF]8DYB@be[17oo0@000Goo0Goo0003Ool00`00Oomoo`04Ool00`00Oomoo`03OolQ9BTQ5:DQ
6<HQ;F/Q=JdQBU93;F/4Ool10001Ool1Ool000=oo`<000Aoo`03001oogoo00=oob4U:B4DYB4HaR4]
Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8DYB@be[
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQBU93;F/4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8BDY8ABU8AS68Be[8CF]8DYB@be[17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
9BTQ5:DQ6<HQ;F/Q=JdQBU93;F/4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]
Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8DYB@be[
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQBU93;F/4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8BDY8ABU8AS68Be[8CF]8DYB@be[17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
9BTQ5:DQ6<HQ;F/Q=JdQBU93;F/4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]
Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8DYB@be[
17oo0@000Goo0Goo000:Ool20004OolQ9BTQ5:DQ6<HQ;F/Q=JdQBU93;F/3Ool20002Ool000Yoo`03
001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8BDY8ABU8AS68Be[8CF]8DYB@be[17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ
;F/Q=JdQBU93;F/4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B5:DT<]
J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8DYB@be[17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQBU93;F/4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8BDY8ABU8AS68Be[8CF]8DYB@be[17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ
;F/Q=JdQBU93;F/4Ool10001Ool1Ool000Yoo`03001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B5:DT<]
J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8BDY8ABU8AS68Be[8CF]8DYB@be[17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ;F/Q=JdQBU93;F/4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob4U:B4DYB4HaR4]Jb4e[B5:DT<]J`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8BDY8ABU8AS68Be[8CF]8DYB@be[17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ9BTQ5:DQ6<HQ
;F/Q=JdQBU93;F/4Ool10001Ool1Ool000Yoo`8000Aoob5JeR56<B4Lib4]Jd80028]Jb4YBP=oo`80
009oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW
8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F]2000R;F/Q
:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005o
o`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW
8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F]2000R;F/Q
:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005o
o`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW
8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool20004OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX3Ool2
0002Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005oo`5oo`002Woo
00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4L
ib4]Jd80028]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[
8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005oo`5oo`002Woo
00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX4Ool10001Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4L
ib4]Jd80028]Jb4YBPAoo`40005oo`5oo`002Woo00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[
8BU:17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQF]HQAS4Q7>LQ;F]2000R;F/Q:DX4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob5JeR56<B4Lib4]Jd80028]Jb4YBPAoo`40005oo`5oo`000goo
0P001Goo00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[8BU:17oo0@000Goo0Goo0002Ool01000
Oomoo`0017oo00<007ooOol00goo8E[F8DHa8AcW8Be[@P008Re[8BU:17oo0@000Goo0Goo0002Ool0
1000Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005Ool00`00Oomoo`3oOolAOol10001Ool1
Ool0009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol10001Ool1Ool000=oo`8000Eoo`03001o
ogoo0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Transpose[waveletMatrix[8, coif6]] . wa, 
      Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00
@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`8000Aoob7oob4004;o
of@0027oo`=oo`80009oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo
8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012
oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0
027oo`Aoo`40005oo`5oo`002Woo0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`8000Aood80
08Coob80027oo`=oo`80009oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo
17oo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool0
009oo`03001oogoo00Eoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`000goo00<0
07ooOol017oo0`000goo@P00Q?oo8P008Ooo0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomo
o`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`03
Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo00=ood;oob40027o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ
000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool20004
Oom2oolQ000QoomT000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40
027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`8000Aood;oob40027oof@0027oo`=oo`80009o
o`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4
oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40005o
o`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool20004Oon4oolQ000Qoom30003Ool20002Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40
027ood<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
ob40027ood<000Aoo`40005oo`5oo`0017oo0`000goo00<007ooOol00gooQ?oo8@008Ooo@`0017oo
0@000Goo0Goo0005Ool00`00Oomoo`02Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1
Ool0009oo`D000=oo`<000=oohCoob40027ood<0009oo`<0009oo`000Woo00@007ooOol000Aoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`000goo00<007oo000017oo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo0004Ool20004Ool00`00Oomoo`03OolQoolQ
0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo
0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool20004OolQoolQ0012oomT000Qool3Ool2
0002Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo0P0017oo@P00Q?oo8P008Ooo0goo0P000Woo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
0024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom20024oolR000Qool4Ool10001Ool1Ool0009oo`<000Eoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood8008Coob80027oo`Aoo`40
005oo`5oo`000Woo00@007ooOol000Aoo`<000=ood;oob40027oob40027oob80027oo`9oo`<0009o
o`000Woo0`001Goo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo0003
Ool00`00Oomoo`04Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool0
00=oo`<000Aoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool20004Oom2oolQ
000QoolQ000QoolR000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`8000AoohCoof@0027oo`=oo`80009oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool20004Oon4oomT000Qool3Ool20002
Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0
027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
0002Ool01000Oomoo`0017oo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo0002Ool01000
Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005Ool00`00Oomoo`3oOolAOol10001Ool1Ool0
009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol10001Ool1Ool000=oo`8000Eoo`03001oogoo
0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<0
07ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo0@00
0Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ \ Shifted\ Sample\ and\ Correlation\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(b = {{1, 1, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 
            1, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 1\ , 0}, {1, 1, 0, 1, 1, 0, 0, 
            0}, {1, 0, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 0, 1, 0}, {1, 1, 1, 
            1, 1, 0, 0\ , 0}};\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[a, Mesh -> False], 
          ListDensityPlot[b, Mesh -> False]}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{198.688, 198.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000360000aQ000`40O003h00OaWoo000<Ool2000Z
Ool4000ZOol3000XOol3000[Ool20005Ool000]oo`04001oogoo000YOol00`00Oomoo`0/Ool00`00
Oomoo`0WOol01000Oomoo`00:Goo00@007ooOol000Aoo`002goo00@007ooOol002Yoo`03001oogoo
02Qoo`D002Qoo`04001oogoo000YOol01000Oomoo`0017oo000;Ool01000Oomoo`00:goo00<007oo
Ool09goo00@007ooOol002Uoo`<002]oo`8000Eoo`002goo00@007ooOol002Uoo`04001oogoo000Y
Ool00`00Ool0000ZOol00`00Oomoo`0YOol01000Oomoo`0017oo000<Ool2000[Ool2000[Ool2000Z
Ool3000ZOol20005Ool00<Ioo`00aWoo0036Ool00<Ioo`002Woo^P000Woo000:Ool01000Oomoo`00
2Woo00<007ooOol02Goo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol0
27oo00<007ooOol027oo00<007ooOol027oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol0
27oo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol0
2Goo00@007ooOol0009oo`000goo0P001Goo00<007ooOol0]Woo0@000Goo0Goo0002Ool01000Oomo
o`0017oo00<007ooOol0]Woo0@000Goo0Goo0002Ool01000Oomoo`0017oo0P00]Woo0P000Woo0002
Ool01000Oomoo`0017oo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo0002Ool01000
Oomoo`0017oo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo0003Ool20005Ool00`00
Oomoo`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Oo
o`9oo`40005oo`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo000:Ool0
0`00Oomoo`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<0
01Ooo`9oo`40005oo`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo000:
Ool00`00Oomoo`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002go
od<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo00=oo`0000000Woo
000:Ool00`00Oomoo`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH0
02good<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo
0Goo000:Ool00`00Oomoo`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01Oo
oaH002good<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@00
0Goo0Goo000:Ool00`00Oomoo`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo
01OooaH002good<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo
0@000Goo0Goo000:Ool00`00Oomoo`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001o
ogoo01OooaH002good<001Ooo`03Ool00000009oo`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo
0@000Goo0Goo000:Ool00`00Oomoo`0]001JoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo
02d005[ooaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo
0Goo000:Ool00`00Oomoo`0]001JoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02d005[o
oaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:
Ool00`00Oomoo`0]001JoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02d005[ooaH001Oo
o`9oo`40005oo`5oo`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00
Oomoo`0]001JoolF000Gool00goo00000002Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40
005oo`5oo`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]
001JoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40005oo`5o
o`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]001JoolF
000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40005oo`5oo`002Woo
00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`0]001JoolF
000Gool2Ool10001Ool1Ool0009oo`03001oogoo00Eoo`03001oogoo02d005[ooaH001Ooo`9oo`40
005oo`5oo`000goo00<007ooOol017oo0P0000=oo`000000:`00F_oo5P005ooo00=oo`0000000Woo
0004Ool00`00Oomoo`03Ool00`00Oomoo`0]oolF000Goom3000Gool2Ool10001Ool1Ool0009oo`04
001oogoo0004Ool00`00Oomoo`0]oolF000Goom3000Gool2Ool10001Ool1Ool000=oo`8000Eoo`03
001oogoo02gooaH001Oood<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P005ooo@`00
5ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000Goom3000Gool2Ool10001Ool1Ool000Yo
o`03001oogoo02gooaH001Oood<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P005ooo
@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000Goom3000Gool2Ool10001Ool1Ool0
00Yoo`03001oogoo02gooaH001Oood<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P00
5ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000Goom3000Gool00goo00000002
Ool000Yoo`03001oogoo02gooaH001Oood<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo
5P005ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000Goom3000Gool2Ool10001
Ool1Ool000Yoo`03001oogoo02gooaH001Oood<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0
;Ooo5P005ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000Goom3000Gool2Ool1
0001Ool1Ool000Yoo`03001oogoo02gooaH001Oood<001Ooo`9oo`40005oo`5oo`002Woo00<007oo
Ool0;Ooo5P005ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000Goom3000Gool2
Ool10001Ool1Ool000Yoo`03001oogoo02gooaH001Oood<001Ooo`9oo`40005oo`5oo`002Woo00<0
07ooOol0;Ooo5P005ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`1JoolF000Gool]0000
0goo00000002Ool000Yoo`03001oogoo05[ooaH001Ooobd0009oo`40005oo`5oo`002Woo00<007oo
Ool0F_oo5P005ooo;@000Woo0@000Goo0Goo000:Ool00`00Oomoo`1JoolF000Gool]0002Ool10001
Ool1Ool000Yoo`03001oogoo05[ooaH001Ooobd0009oo`40005oo`5oo`002Woo00<007ooOol0F_oo
5P005ooo;@000Woo0@000Goo0Goo000:Ool00`00Oomoo`1JoolF000Gool]0002Ool10001Ool1Ool0
00Yoo`03001oogoo05[ooaH001Ooobd0009oo`40005oo`5oo`002Woo00<007ooOol0F_oo5P005ooo
;@000Woo0@000Goo0Goo000:Ool00`00Oomoo`1JoolF000Gool]0002Ool10001Ool1Ool000Yoo`03
001oogoo05[ooaH001Ooobd0009oo`40005oo`5oo`002Woo00<007ooOol0F_oo5P005ooo;@0000=o
o`0000000Woo000:Ool00`00Oomoo`1JoolF000Gool]0002Ool10001Ool1Ool000Yoo`03001oogoo
05[ooaH001Ooobd0009oo`40005oo`5oo`002Woo00<007ooOol0F_oo5P005ooo;@000Woo0@000Goo
0Goo000:Ool00`00Oomoo`1JoolF000Gool]0002Ool10001Ool1Ool000Yoo`03001oogoo05[ooaH0
01Ooobd0009oo`40005oo`5oo`002Woo00<007ooOol0F_oo5P005ooo;@000Woo0@000Goo0Goo000:
Ool00`00Oomoo`1JoolF000Gool]0002Ool10001Ool1Ool000Yoo`03001oogoo05[ooaH001Ooobd0
009oo`40005oo`5oo`0017oo0`000goo00<007ooOol0F_oo5P005ooo;@000Woo0@000Goo0Goo0005
Ool00`00Oomoo`02Ool00`00Oomoo`1JoolF000Gool]0002Ool10001Ool1Ool0009oo`D000=oo`80
0003Oooooooo01GooaH002good<001Ooo`03Ool00000009oo`000Woo00@007ooOol000Aoo`03001o
ogoo01OooaH002good<001Ooo`9oo`40005oo`5oo`000goo00<007oo000017oo00<007ooOol05ooo
5P00;Ooo@`005ooo0Woo0@000Goo0Goo0004Ool20004Ool00`00Oomoo`0GoolF000]oom3000Gool2
Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Ooo`9oo`40005oo`5oo`002Woo00<0
07ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0GoolF000]oom3000G
ool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Ooo`9oo`40005oo`5oo`002Woo
00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0GoolF000]oom3
000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Ooo`9oo`40005oo`5oo`00
2Woo00<007ooOol05ooo5P00;Ooo@`005ooo00=oo`0000000Woo000:Ool00`00Oomoo`0GoolF000]
oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Ooo`9oo`40005oo`5o
o`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0GoolF
000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Ooo`9oo`40005o
o`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0G
oolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Ooo`9oo`40
005oo`5oo`002Woo00<007ooOol05ooo5P00;Ooo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomo
o`0GoolF000]oom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo01OooaH002good<001Ooo`03
Ool00000009oo`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomo
o`0]001JoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40005o
o`5oo`002Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]001J
oolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40005oo`5oo`00
2Woo00<007ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]001JoolF000G
ool2Ool10001Ool1Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40005oo`5oo`002Woo00<0
07ooOol0;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]001JoolF000Gool00goo
00000002Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0
;@00F_oo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]001JoolF000Gool2Ool10001Ool1
Ool000Yoo`03001oogoo02d005[ooaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;@00F_oo
5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]001JoolF000Gool2Ool10001Ool1Ool000Yo
o`03001oogoo02d005[ooaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;@00F_oo5P005ooo
0Woo0@000Goo0Goo0002Ool30005Ool00`00Oomoo`0]001JoolF000Gool2Ool10001Ool1Ool0009o
o`04001oogoo0004Ool00`00Oomoo`0]001JoolF000Gool2Ool10001Ool1Ool0009oo`04001oogoo
0004Ool200000goo0000000[001JoolF000Gool00goo00000002Ool0009oo`<000Eoo`03001oogoo
02gooaH001OooaH001OooaH001Ooo`9oo`40005oo`5oo`000goo00<007ooOol017oo00<007ooOol0
;Ooo5P005ooo5P005ooo5P005ooo0Woo0@000Goo0Goo0003Ool30004Ool00`00Oomoo`0]oolF000G
oolF000GoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02gooaH001OooaH001OooaH001Oo
o`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P005ooo5P005ooo5P005ooo0Woo0@000Goo0Goo
000:Ool00`00Oomoo`0]oolF000GoolF000GoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo
02gooaH001OooaH001OooaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P005ooo5P00
5ooo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000GoolF000GoolF000Gool2Ool1
0001Ool1Ool000Yoo`03001oogoo02gooaH001OooaH001OooaH001Ooo`9oo`40005oo`5oo`002Woo
00<007ooOol0;Ooo5P005ooo5P005ooo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF
000GoolF000GoolF000Gool00goo00000002Ool000Yoo`03001oogoo02gooaH001OooaH001OooaH0
01Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P005ooo5P005ooo5P005ooo0Woo0@000Goo
0Goo000:Ool00`00Oomoo`0]oolF000GoolF000GoolF000Gool2Ool10001Ool1Ool000Yoo`03001o
ogoo02gooaH001OooaH001OooaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P005ooo
5P005ooo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000GoolF000GoolF000Gool2
Ool10001Ool1Ool000Yoo`03001oogoo02gooaH001OooaH001OooaH001Ooo`9oo`40005oo`5oo`00
2Woo00<007ooOol0;Ooo5P005ooo5P005ooo5P005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`0]
oolF000GoolF000GoolF000Gool2Ool10001Ool1Ool000Yoo`03001oogoo02gooaH001OooaH001Oo
oaH001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0F_oo@`005ooo00=oo`0000000Woo000:Ool0
0`00Oomoo`1Joom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo05[ood<001Ooo`9oo`40005o
o`5oo`002Woo00<007ooOol0F_oo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`1Joom3000G
ool2Ool10001Ool1Ool000Yoo`03001oogoo05[ood<001Ooo`9oo`40005oo`5oo`002Woo00<007oo
Ool0F_oo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`1Joom3000Gool2Ool10001Ool1Ool0
00Yoo`03001oogoo05[ood<001Ooo`9oo`40005oo`5oo`002Woo00<007ooOol0F_oo@`005ooo0Woo
0@000Goo0Goo000:Ool00`00Oomoo`1Joom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo05[o
od<001Ooo`03Ool00000009oo`002Woo00<007ooOol0F_oo@`005ooo0Woo0@000Goo0Goo000:Ool0
0`00Oomoo`1Joom3000Gool2Ool10001Ool1Ool000Yoo`03001oogoo05[ood<001Ooo`9oo`40005o
o`5oo`002Woo00<007ooOol0F_oo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`1Joom3000G
ool2Ool10001Ool1Ool000Yoo`03001oogoo05[ood<001Ooo`9oo`40005oo`5oo`002Woo00<007oo
Ool0F_oo@`005ooo0Woo0@000Goo0Goo000:Ool00`00Oomoo`1Joom3000Gool2Ool10001Ool1Ool0
00=oo`8000Eoo`03001oogoo05[ood<001Ooo`9oo`40005oo`5oo`000Woo00@007ooOol000Aoo`03
001oogoo05[ood<001Ooo`9oo`40005oo`5oo`000Woo00@007ooOol000Aoo`800;Ioo`80009oo`00
0goo0P001Goo00<007ooOol0]Woo0@000Goo0Goo0002Ool01000Oomoo`0017oo00@007ooOol002ao
o`03001oogoo02Uoo`03001oogoo02Yoo`03001oogoo02Yoo`04001oogoo0002Ool000=oo`8000Eo
o`04001oogoo000:Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08
Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`09Ool00`00Oomoo`08
Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08
Ool00`00Oomoo`09Ool01000Oomoo`000Woo000:Oonj0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 197.688}, {197.688, 0}} -> {-0.618703, -0.667854, \
0.0448679, 0.0448679}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF000000
FFFFFFFFFF00FF00
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF00FF00
FFFFFFFFFF000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{198.688, 198.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000360000aQ000`40O003h00OaWoo000<Ool2000Z
Ool4000ZOol3000XOol3000[Ool20005Ool000]oo`04001oogoo000YOol00`00Oomoo`0/Ool00`00
Oomoo`0WOol01000Oomoo`00:Goo00@007ooOol000Aoo`002goo00@007ooOol002Yoo`03001oogoo
02Qoo`D002Qoo`04001oogoo000YOol01000Oomoo`0017oo000;Ool01000Oomoo`00:goo00<007oo
Ool09goo00@007ooOol002Uoo`<002]oo`8000Eoo`002goo00@007ooOol002Uoo`04001oogoo000Y
Ool00`00Ool0000ZOol00`00Oomoo`0YOol01000Oomoo`0017oo000<Ool2000[Ool2000[Ool2000Z
Ool3000ZOol20005Ool00<Ioo`00aWoo0036Ool00<Ioo`002Woo^P000Woo000:Ool01000Oomoo`00
2Woo00<007ooOol02Goo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol0
27oo00<007ooOol027oo00<007ooOol027oo00<007ooOol02Goo00<007ooOol027oo00<007ooOol0
27oo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol027oo00<007ooOol0
2Goo00@007ooOol0009oo`000goo0P001Goo00<007ooOol0]Woo0@000Goo0Goo0002Ool01000Oomo
o`0017oo00<007ooOol0]Woo0@000Goo0Goo0002Ool01000Oomoo`0017oo0P00]Woo0P000Woo0002
Ool01000Oomoo`0017oo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo0002Ool01000Oomo
o`0017oo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo0003Ool20005Ool00`00Oomoo`0]
oolF000]oom40002Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@0009oo`40005oo`5o
o`002Woo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000]
oom40002Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@0009oo`40005oo`5oo`002Woo
00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000]oom40002
Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@0009oo`40005oo`5oo`002Woo00<007oo
Ool0;Ooo5P00;OooA00000=oo`0000000Woo000:Ool00`00Oomoo`0]oolF000]oom40002Ool10001
Ool1Ool000Yoo`03001oogoo02gooaH002good@0009oo`40005oo`5oo`002Woo00<007ooOol0;Ooo
5P00;OooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000]oom40002Ool10001Ool1Ool0
00Yoo`03001oogoo02gooaH002good@0009oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P00;Ooo
A0000Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000]oom40002Ool10001Ool1Ool000Yoo`03
001oogoo02gooaH002good@0009oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P00;OooA0000Woo
0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000]oom40002Ool10001Ool1Ool000Yoo`03001oogoo
02gooaH002good@00003Ool00000009oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo
0Goo000:Ool00`00Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool000Yoo`03001oogoo01Ooob`0
05[ooaL0009oo`40005oo`5oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo0Goo000:
Ool00`00Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool000Yoo`03001oogoo01Ooob`005[ooaL0
009oo`40005oo`5oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo0Goo000:Ool00`00
Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool000Yoo`03001oogoo01Ooob`005[ooaL0009oo`40
005oo`5oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`0G
ool/001JoolG00000goo00000002Ool000Yoo`03001oogoo01Ooob`005[ooaL0009oo`40005oo`5o
o`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`0Gool/001J
oolG0002Ool10001Ool1Ool000Yoo`03001oogoo01Ooob`005[ooaL0009oo`40005oo`5oo`002Woo
00<007ooOol05ooo;000F_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`0Gool/001JoolG0002
Ool10001Ool1Ool000Yoo`03001oogoo01Ooob`005[ooaL0009oo`40005oo`5oo`002Woo00<007oo
Ool05ooo;000F_oo5`000Woo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`0Gool/001JoolG0002
Ool10001Ool1Ool0009oo`03001oogoo00Eoo`03001oogoo01Ooob`005[ooaL0009oo`40005oo`5o
o`000goo00<007ooOol017oo0P0000=oooooool05Ooo;000F_oo5`0000=oo`0000000Woo0004Ool0
0`00Oomoo`03Ool00`00Oomoo`13oolG000Foom40002Ool10001Ool1Ool0009oo`04001oogoo0004
Ool00`00Oomoo`13oolG000Foom40002Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo04?ooaL0
01Kood@0009oo`40005oo`5oo`002Woo00<007ooOol0@ooo5`005_ooA0000Woo0@000Goo0Goo000:
Ool00`00Oomoo`13oolG000Foom40002Ool10001Ool1Ool000Yoo`03001oogoo04?ooaL001Kood@0
009oo`40005oo`5oo`002Woo00<007ooOol0@ooo5`005_ooA0000Woo0@000Goo0Goo000:Ool00`00
Oomoo`13oolG000Foom40002Ool10001Ool1Ool000Yoo`03001oogoo04?ooaL001Kood@0009oo`40
005oo`5oo`002Woo00<007ooOol0@ooo5`005_ooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`13
oolG000Foom400000goo00000002Ool000Yoo`03001oogoo04?ooaL001Kood@0009oo`40005oo`5o
o`002Woo00<007ooOol0@ooo5`005_ooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`13oolG000F
oom40002Ool10001Ool1Ool000Yoo`03001oogoo04?ooaL001Kood@0009oo`40005oo`5oo`002Woo
00<007ooOol0@ooo5`005_ooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`13oolG000Foom40002
Ool10001Ool1Ool000Yoo`03001oogoo04?ooaL001Kood@0009oo`40005oo`5oo`002Woo00<007oo
Ool0@ooo5`005_ooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`13oolG000Foom40002Ool10001
Ool1Ool000Yoo`03001oogoo04?ooaL001Kood@0009oo`40005oo`5oo`002Woo00<007ooOol0@ooo
5`005_ooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`1`oolG000FoolG00000goo00000002Ool0
00Yoo`03001oogoo073ooaL001KooaL0009oo`40005oo`5oo`002Woo00<007ooOol0L?oo5`005_oo
5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`1`oolG000FoolG0002Ool10001Ool1Ool000Yoo`03
001oogoo073ooaL001KooaL0009oo`40005oo`5oo`002Woo00<007ooOol0L?oo5`005_oo5`000Woo
0@000Goo0Goo000:Ool00`00Oomoo`1`oolG000FoolG0002Ool10001Ool1Ool000Yoo`03001oogoo
073ooaL001KooaL0009oo`40005oo`5oo`002Woo00<007ooOol0L?oo5`005_oo5`000Woo0@000Goo
0Goo000:Ool00`00Oomoo`1`oolG000FoolG0002Ool10001Ool1Ool000Yoo`03001oogoo073ooaL0
01KooaL0009oo`40005oo`5oo`002Woo00<007ooOol0L?oo5`005_oo5`0000=oo`0000000Woo000:
Ool00`00Oomoo`1`oolG000FoolG0002Ool10001Ool1Ool000Yoo`03001oogoo073ooaL001KooaL0
009oo`40005oo`5oo`002Woo00<007ooOol0L?oo5`005_oo5`000Woo0@000Goo0Goo000:Ool00`00
Oomoo`1`oolG000FoolG0002Ool10001Ool1Ool000Yoo`03001oogoo073ooaL001KooaL0009oo`40
005oo`5oo`002Woo00<007ooOol0L?oo5`005_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`1`
oolG000FoolG0002Ool10001Ool1Ool000Yoo`03001oogoo073ooaL001KooaL0009oo`40005oo`5o
o`0017oo0`000goo00<007ooOol0L?oo5`005_oo5`000Woo0@000Goo0Goo0005Ool00`00Oomoo`02
Ool00`00Oomoo`1`oolG000FoolG0002Ool10001Ool1Ool0009oo`D000=oo`800003Oooooooo02_o
oaH002good@00003Ool00000009oo`000Woo00@007ooOol000Aoo`03001oogoo02gooaH002good@0
009oo`40005oo`5oo`000goo00<007oo000017oo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo
0Goo0004Ool20004Ool00`00Oomoo`0]oolF000]oom40002Ool10001Ool1Ool000Yoo`03001oogoo
02gooaH002good@0009oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo
0Goo000:Ool00`00Oomoo`0]oolF000]oom40002Ool10001Ool1Ool000Yoo`03001oogoo02gooaH0
02good@0009oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo000:
Ool00`00Oomoo`0]oolF000]oom40002Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@0
009oo`40005oo`5oo`002Woo00<007ooOol0;Ooo5P00;OooA00000=oo`0000000Woo000:Ool00`00
Oomoo`0]oolF000]oom40002Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@0009oo`40
005oo`5oo`002Woo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`0]
oolF000]oom40002Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@0009oo`40005oo`5o
o`002Woo00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000]
oom40002Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@0009oo`40005oo`5oo`002Woo
00<007ooOol0;Ooo5P00;OooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`0]oolF000]oom40002
Ool10001Ool1Ool000Yoo`03001oogoo02gooaH002good@00003Ool00000009oo`002Woo00<007oo
Ool05ooo;000F_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`0Gool/001JoolG0002Ool10001
Ool1Ool000Yoo`03001oogoo01Ooob`005[ooaL0009oo`40005oo`5oo`002Woo00<007ooOol05ooo
;000F_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool0
00Yoo`03001oogoo01Ooob`005[ooaL0009oo`40005oo`5oo`002Woo00<007ooOol05ooo;000F_oo
5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool000Yoo`03
001oogoo01Ooob`005[ooaL0009oo`40005oo`5oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo
0@000Goo0Goo000:Ool00`00Oomoo`0Gool/001JoolG00000goo00000002Ool000Yoo`03001oogoo
01Ooob`005[ooaL0009oo`40005oo`5oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo
0Goo000:Ool00`00Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool000Yoo`03001oogoo01Ooob`0
05[ooaL0009oo`40005oo`5oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo0Goo000:
Ool00`00Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool000Yoo`03001oogoo01Ooob`005[ooaL0
009oo`40005oo`5oo`002Woo00<007ooOol05ooo;000F_oo5`000Woo0@000Goo0Goo0002Ool30005
Ool00`00Oomoo`0Gool/001JoolG0002Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomo
o`0Gool/001JoolG0002Ool10001Ool1Ool0009oo`04001oogoo0004Ool200000gooooooo`0Eool/
001JoolG00000goo00000002Ool0009oo`<000Eoo`03001oogoo04?ooaL001KooaL001KooaL0009o
o`40005oo`5oo`000goo00<007ooOol017oo00<007ooOol0@ooo5`005_oo5`005_oo5`000Woo0@00
0Goo0Goo0003Ool30004Ool00`00Oomoo`13oolG000FoolG000FoolG0002Ool10001Ool1Ool000Yo
o`03001oogoo04?ooaL001KooaL001KooaL0009oo`40005oo`5oo`002Woo00<007ooOol0@ooo5`00
5_oo5`005_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`13oolG000FoolG000FoolG0002Ool1
0001Ool1Ool000Yoo`03001oogoo04?ooaL001KooaL001KooaL0009oo`40005oo`5oo`002Woo00<0
07ooOol0@ooo5`005_oo5`005_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`13oolG000FoolG
000FoolG0002Ool10001Ool1Ool000Yoo`03001oogoo04?ooaL001KooaL001KooaL0009oo`40005o
o`5oo`002Woo00<007ooOol0@ooo5`005_oo5`005_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomo
o`13oolG000FoolG000FoolG00000goo00000002Ool000Yoo`03001oogoo04?ooaL001KooaL001Ko
oaL0009oo`40005oo`5oo`002Woo00<007ooOol0@ooo5`005_oo5`005_oo5`000Woo0@000Goo0Goo
000:Ool00`00Oomoo`13oolG000FoolG000FoolG0002Ool10001Ool1Ool000Yoo`03001oogoo04?o
oaL001KooaL001KooaL0009oo`40005oo`5oo`002Woo00<007ooOol0@ooo5`005_oo5`005_oo5`00
0Woo0@000Goo0Goo000:Ool00`00Oomoo`13oolG000FoolG000FoolG0002Ool10001Ool1Ool000Yo
o`03001oogoo04?ooaL001KooaL001KooaL0009oo`40005oo`5oo`002Woo00<007ooOol0@ooo5`00
5_oo5`005_oo5`000Woo0@000Goo0Goo000:Ool00`00Oomoo`13oolG000FoolG000FoolG0002Ool1
0001Ool1Ool000Yoo`03001oogoo04?ooaL001KooaL001KooaL0009oo`40005oo`5oo`002Woo00<0
07ooOol0L?ooA00000=oo`0000000Woo000:Ool00`00Oomoo`1`oom40002Ool10001Ool1Ool000Yo
o`03001oogoo073ood@0009oo`40005oo`5oo`002Woo00<007ooOol0L?ooA0000Woo0@000Goo0Goo
000:Ool00`00Oomoo`1`oom40002Ool10001Ool1Ool000Yoo`03001oogoo073ood@0009oo`40005o
o`5oo`002Woo00<007ooOol0L?ooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`1`oom40002Ool1
0001Ool1Ool000Yoo`03001oogoo073ood@0009oo`40005oo`5oo`002Woo00<007ooOol0L?ooA000
0Woo0@000Goo0Goo000:Ool00`00Oomoo`1`oom40002Ool10001Ool1Ool000Yoo`03001oogoo073o
od@00003Ool00000009oo`002Woo00<007ooOol0L?ooA0000Woo0@000Goo0Goo000:Ool00`00Oomo
o`1`oom40002Ool10001Ool1Ool000Yoo`03001oogoo073ood@0009oo`40005oo`5oo`002Woo00<0
07ooOol0L?ooA0000Woo0@000Goo0Goo000:Ool00`00Oomoo`1`oom40002Ool10001Ool1Ool000Yo
o`03001oogoo073ood@0009oo`40005oo`5oo`002Woo00<007ooOol0L?ooA0000Woo0@000Goo0Goo
000:Ool00`00Oomoo`1`oom40002Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo073ood@0009o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo073ood@0009oo`40005oo`5oo`000Woo
00@007ooOol000Aoo`800;Ioo`80009oo`000goo0P001Goo00<007ooOol0]Woo0@000Goo0Goo0002
Ool01000Oomoo`0017oo00@007ooOol002aoo`03001oogoo02Uoo`03001oogoo02Yoo`03001oogoo
02Yoo`04001oogoo0002Ool000=oo`8000Eoo`04001oogoo000:Ool00`00Oomoo`09Ool00`00Oomo
o`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomo
o`08Ool00`00Oomoo`09Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomo
o`08Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`09Ool01000Oomoo`000Woo000:Oonj
0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 197.688}, {197.688, 0}} -> {-0.618703, -0.667854, \
0.0448679, 0.0448679}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF000000
FFFFFFFFFF00FF00
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF00FF00
FFFFFFFFFF000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{198.688, 94.5625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000360000GQ000`40O003h00OaWoo0036Ool00<Io
o`003Woo0P0047oo100047oo0`003Goo0`004Goo0P005Woo0P0047oo100047oo0`003Goo0`004Goo
0P002Woo000=Ool01000Oomoo`003goo00<007ooOol04Woo00<007ooOol037oo00@007ooOol000mo
o`04001oogoo000DOol01000Oomoo`003goo00<007ooOol04Woo00<007ooOol037oo00@007ooOol0
00moo`04001oogoo0009Ool000eoo`04001oogoo000@Ool00`00Oomoo`0>Ool5000=Ool01000Oomo
o`003goo00@007ooOol001Aoo`04001oogoo000@Ool00`00Oomoo`0>Ool5000=Ool01000Oomoo`00
3goo00@007ooOol000Uoo`003Goo00@007ooOol0015oo`03001oogoo00eoo`04001oogoo000>Ool3
000AOol2000EOol01000Oomoo`004Goo00<007ooOol03Goo00@007ooOol000ioo`<0015oo`8000Yo
o`003Goo00@007ooOol000moo`04001oogoo000?Ool00`00Ool0000?Ool00`00Oomoo`0?Ool01000
Oomoo`0057oo00@007ooOol000moo`04001oogoo000?Ool00`00Ool0000?Ool00`00Oomoo`0?Ool0
1000Oomoo`002Goo000>Ool2000AOol2000AOol2000?Ool3000@Ool2000FOol2000AOol2000AOol2
000?Ool3000@Ool2000:Ool00<Ioo`00aWoo0036Ool000Uoo`8000=oodd0011oo`8000=oodd000Uo
o`0027oo00@007ooOol0009oo`80019oo`03001oogoo00moo`03001oogoo00moo`03001oogoo011o
o`8000moo`04001oogoo0002Ool2000BOol00`00Oomoo`0?Ool00`00Oomoo`0?Ool00`00Oomoo`0@
Ool20009Ool000Qoo`04001oogoo0002Ool00`00Oomoo`19Ool00`00Oomoo`0=Ool01000Oomoo`00
0Woo00<007ooOol0BGoo00<007ooOol01goo0008Ool01000Oomoo`000Woo00<00?ooool02?oo2@00
4ooo6`002_oo00<007ooOol03Goo00@007ooOol0009oo`03003ooooo017oo`T001?ooad000Uoo`00
27oo00@007ooOol0009oo`03003ooooo00Soo`T001?ooa/000[oo`03001oogoo00eoo`04001oogoo
0002Ool00`00ooooo`0Aool9000CoolM0009Ool000Uoo`8000=oo`03003ooooo00Soo`T001?ooa/0
00[oo`03001oogoo00ioo`8000=oo`03003ooooo017oo`T001?ooad000Uoo`003Woo00<00?ooool0
2?oo2@004ooo6`002_oo00<007ooOol04goo00<00?ooool04Ooo2@004ooo7@002Goo000>Ool00`00
ooooo`08ool9000CoolK000:ool00`00Oomoo`0COol00`00ooooo`0Aool9000CoolM0009Ool000io
o`03003ooooo00Soo`T001?ooa/000[oo`03001oogoo01=oo`03003ooooo017oo`T001?ooad000Uo
o`003Woo00<00?ooool02?oo2@004ooo6`002_oo00<007ooOol04goo00<00?ooool04Ooo2@004ooo
7@002Goo000>Ool00`00ooooo`08ool9000CoolK000:ool00`00Oomoo`0COol00`00ooooo`0Aool9
000CoolM0009Ool000ioo`03003ooooo00Soo`T001?ooa/000[oo`03001oogoo01=oo`03003ooooo
017oo`T001?ooad000Uoo`003Woo50009Ooo2@002_oo00<007ooOol04goo00<00?ooool02?oo4P00
9Ooo2`002Goo000>OolD000Uool9000:ool00`00Oomoo`0COol00`00ooooo`08oolB000Uool;0009
Ool000iooa@002Goo`T000[oo`03001oogoo01=oo`03003ooooo00Sooa8002Goo`/000Uoo`003Woo
50009Ooo2@002_oo00<007ooOol04goo00<00?ooool02?oo4P009Ooo2`002Goo000>OolD000Uool9
000:ool00`00Oomoo`0COol00`00ooooo`08oolB000Uool;0009Ool000iooa@002Goo`T000[oo`03
001oogoo01=oo`03003ooooo00Sooa8002Goo`/000Uoo`0027oo10000Woo50009Ooo2@002_oo00<0
07ooOol03Goo10000Woo00<00?ooool02?oo4P009Ooo2`002Goo0008Ool00`00Oomoo`03OolD000U
ool9000:ool00`00Oomoo`0=Ool00`00Oomoo`03Ool00`00ooooo`08oolB000Uool;0009Ool000Uo
o`03001oogoo009ooa@002Goo`T000[oo`03001oogoo00ioo`03001oogoo009oo`03003ooooo00So
oa8002Goo`/000Uoo`002Woo00D007ooOomoo`0001?oo`T000[ooa/000[oo`03001oogoo00moo`05
001oogooOol0000Lool:0009oolM0009Ool000Qoo`04001oogoo0002Ool00`00ooooo`0Aool9000:
oolK000:ool00`00Oomoo`0=Ool01000Oomoo`000Woo00<00?ooool06_oo2P002Ooo7@002Goo0009
Ool20003Ool00`00ooooo`0Aool9000:oolK000:ool00`00Oomoo`0>Ool20003Ool00`00ooooo`0J
ool:0009oolM0009Ool000ioo`03003ooooo017oo`T000[ooa/000[oo`03001oogoo01=oo`03003o
oooo01[oo`X000Wooad000Uoo`003Woo00<00?ooool04Ooo2@002_oo6`002_oo00<007ooOol04goo
00<00?ooool06_oo2P002Ooo7@002Goo000>Ool00`00ooooo`0Aool9000:oolK000:ool00`00Oomo
o`0COol00`00ooooo`0Jool:0009oolM0009Ool000ioo`03003ooooo017oo`T000[ooa/000[oo`03
001oogoo01=oo`03003ooooo01[oo`X000Wooad000Uoo`003Woo00<00?ooool04Ooo2@002_oo6`00
2_oo00<007ooOol04goo00<00?ooool06_oo2P002Ooo7@002Goo000>Ool00`00ooooo`0Aool9000:
oolK000:ool00`00Oomoo`0COol00`00ooooo`0Jool:0009oolM0009Ool000ioo`03003ooooo02Co
o`T000Wooa@001Eoo`03003ooooo02goo`T000Woo`/000Uoo`003Woo00<00?ooool09?oo2@002Ooo
50005Goo00<00?ooool0;Ooo2@002Ooo2`002Goo000>Ool00`00ooooo`0Tool90009oolD000EOol0
0`00ooooo`0]ool90009ool;0009Ool000ioo`03003ooooo02Coo`T000Wooa@001Eoo`03003ooooo
02goo`T000Woo`/000Uoo`003Woo00<00?ooool09?oo2@002Ooo50005Goo00<00?ooool0;Ooo2@00
2Ooo2`002Goo000>Ool00`00ooooo`0Tool90009oolD000EOol00`00ooooo`0]ool90009ool;0009
Ool000Yoo`<00003Ool00?oo02Goo`T000Wooa@0015oo`<00003Ool00?oo02koo`T000Woo`/000Uo
o`002goo00@007ooOol002Koo`T000Wooa@0019oo`04001oogoo000_ool90009ool;0009Ool000Qo
o`D00003Ool00?oo02Goo`T000Wooa@000moo`D00003Ool00?oo02koo`T000Woo`/000Uoo`0027oo
00@007ooOol0009oo`03003ooooo00Soo`T001?ooa/000[oo`03001oogoo00eoo`04001oogoo0002
Ool00`00ooooo`0Aool9000CoolM0009Ool000Uoo`03001oo`00009oo`03003ooooo00Soo`T001?o
oa/000[oo`03001oogoo00ioo`03001oo`00009oo`03003ooooo017oo`T001?ooad000Uoo`002Woo
0P000Woo00<00?ooool02?oo2@004ooo6`002_oo00<007ooOol03goo0P000Woo00<00?ooool04Ooo
2@004ooo7@002Goo000>Ool00`00ooooo`08ool9000CoolK000:ool00`00Oomoo`0COol00`00oooo
o`0Aool9000CoolM0009Ool000ioo`03003ooooo00Soo`T001?ooa/000[oo`03001oogoo01=oo`03
003ooooo017oo`T001?ooad000Uoo`003Woo00<00?ooool02?oo2@004ooo6`002_oo00<007ooOol0
4goo00<00?ooool04Ooo2@004ooo7@002Goo000>Ool00`00ooooo`08ool9000CoolK000:ool00`00
Oomoo`0COol00`00ooooo`0Aool9000CoolM0009Ool000ioo`03003ooooo00Soo`T001?ooa/000[o
o`03001oogoo01=oo`03003ooooo017oo`T001?ooad000Uoo`003Woo00<00?ooool02?oo2@004ooo
6`002_oo00<007ooOol04goo00<00?ooool04Ooo2@004ooo7@002Goo000>OolD000Uool9000:ool0
0`00Oomoo`0COol00`00ooooo`08oolB000Uool;0009Ool000iooa@002Goo`T000[oo`03001oogoo
01=oo`03003ooooo00Sooa8002Goo`/000Uoo`003Woo50009Ooo2@002_oo00<007ooOol04goo00<0
0?ooool02?oo4P009Ooo2`002Goo000>OolD000Uool9000:ool00`00Oomoo`0COol00`00ooooo`08
oolB000Uool;0009Ool000iooa@002Goo`T000[oo`03001oogoo01=oo`03003ooooo00Sooa8002Go
o`/000Uoo`003Woo50009Ooo2@002_oo00<007ooOol04goo00<00?ooool02?oo4P009Ooo2`002Goo
000>OolD000Uool9000:ool00`00Oomoo`0COol00`00ooooo`08oolB000Uool;0009Ool000Qoo`<0
00=ooa@002Goo`T000[oo`03001oogoo00eoo`<000=oo`03003ooooo00Sooa8002Goo`/000Uoo`00
27oo00@007ooOol0009ooa@002Goo`T000[oo`03001oogoo00eoo`04001oogoo0002Ool00`00oooo
o`08oolB000Uool;0009Ool000Qoo`04001oogoo0002Ool00`00ooooo`0Aool9000:ool90009ool9
000:ool00`00Oomoo`0=Ool01000Oomoo`000Woo00<00?ooool06_oo2P002Ooo2@002Ooo2`002Goo
0008Ool30003Ool00`00ooooo`0Aool9000:ool90009ool9000:ool00`00Oomoo`0=Ool30003Ool0
0`00ooooo`0Jool:0009ool90009ool;0009Ool000Uoo`03001oogoo009oo`03003ooooo017oo`T0
00[oo`T000Woo`T000[oo`03001oogoo00ioo`03001oogoo009oo`03003ooooo01[oo`X000Woo`T0
00Woo`/000Uoo`002Goo0`000Woo00<00?ooool04Ooo2@002_oo2@002Ooo2@002_oo00<007ooOol0
3Woo0`000Woo00<00?ooool06_oo2P002Ooo2@002Ooo2`002Goo000>Ool00`00ooooo`0Aool9000:
ool90009ool9000:ool00`00Oomoo`0COol00`00ooooo`0Jool:0009ool90009ool;0009Ool000io
o`03003ooooo017oo`T000[oo`T000Woo`T000[oo`03001oogoo01=oo`03003ooooo01[oo`X000Wo
o`T000Woo`/000Uoo`003Woo00<00?ooool04Ooo2@002_oo2@002Ooo2@002_oo00<007ooOol04goo
00<00?ooool06_oo2P002Ooo2@002Ooo2`002Goo000>Ool00`00ooooo`0Aool9000:ool90009ool9
000:ool00`00Oomoo`0COol00`00ooooo`0Jool:0009ool90009ool;0009Ool000ioo`03003ooooo
017oo`T000[oo`T000Woo`T000[oo`03001oogoo01=oo`03003ooooo01[oo`X000Woo`T000Woo`/0
00Uoo`003Woo00<00?ooool09?oo6`002_oo00<007ooOol04goo00<00?ooool0;Ooo7@002Goo000>
Ool00`00ooooo`0ToolK000:ool00`00Oomoo`0COol00`00ooooo`0]oolM0009Ool000ioo`03003o
oooo02Cooa/000[oo`03001oogoo01=oo`03003ooooo02gooad000Uoo`003Woo00<00?ooool09?oo
6`002_oo00<007ooOol04goo00<00?ooool0;Ooo7@002Goo000>Ool00`00ooooo`0ToolK000:ool0
0`00Oomoo`0COol00`00ooooo`0]oolM0009Ool000ioo`03003ooooo02Cooa/000[oo`03001oogoo
01=oo`03003ooooo02gooad000Uoo`003Woo00<00?ooool09?oo6`002_oo00<007ooOol04goo00<0
0?ooool0;Ooo7@002Goo0009Ool20003Ool00`00ooooo`0ToolK000:ool00`00Oomoo`0>Ool20003
Ool00`00ooooo`0]oolM0009Ool000Qoo`04001oogoo0002Ool00`00ooooo`0ToolK000:ool00`00
Oomoo`0=Ool01000Oomoo`000Woo00<00?ooool0;Ooo7@002Goo0008Ool01000Oomoo`000Woo00<0
07ooOol0BGoo00<007ooOol03Goo00@007ooOol0009oo`03001oogoo04Uoo`03001oogoo00Moo`00
2Goo0P000gooC@0047oo0P000gooC@002Goo0008Ool01000Oomoo`00GWoo00@007ooOol005Qoo`00
2Goo0P00H7oo0P00FGoo0036Ool00<Ioo`00aWoo0000\
\>"],
  ImageRangeCache->{{{0, 197.688}, {93.5625, 0}} -> {-0.0564557, -0.0238146, \
0.0106881, 0.0106881}, {{5.25, 94.375}, {91.3125, 2.1875}} -> {-1.73929, \
-1.49341, 0.109277, 0.109277}, {{103.25, 192.375}, {91.3125, 2.1875}} -> \
{-12.4485, -1.49341, 0.109277, 0.109277}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Correlation",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[""], "Input"],

Cell["\<\
corRelation=
\tCompile[{{vectorA,_Real,1},{vectorB,_Real,1}},
\t\tModule[{meanA=0.,meanB=0.,normA=0.,normB=0.,
\t\t\t\tvectorAprime={0.},vectorBprime={0.}},
\t\t\tmeanA=Apply[Plus,vectorA]/Length[vectorA];
\t\t\tmeanB=Apply[Plus,vectorB]/Length[vectorB];
\t\t\tvectorAprime=vectorA-meanA;
\t\t\tnormA=Sqrt[vectorAprime.vectorAprime];
\t\t\tvectorBprime=vectorB-meanB;
\t\t\tnormB=Sqrt[vectorBprime.vectorBprime];
\t\t\tvectorAprime.vectorBprime/(normA normB)]];\
\>", "Input",
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["corRelation[Flatten[a],Flatten[b]]", "Input"],

Cell[BoxData[
    \(0.0020131159011798102`\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(fa = Fourier[a];\)\)], "Input"],

Cell[BoxData[
    \(\(fb = Fourier[b];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(corRelation[Flatten[Abs[fa]], Flatten[Abs[fb]]]\)], "Input"],

Cell[BoxData[
    \(0.9914808022643128`\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wa = waveletMatrix[8, coif6] . a;\)\)], "Input"],

Cell[BoxData[
    \(\(wb = waveletMatrix[8, coif6] . b;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(corRelation[Flatten[wa], Flatten[wb]]\)], "Input"],

Cell[BoxData[
    \(0.4556134372522856`\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Bad\ Sample\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(d = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 
            0, 0, 0, 1}, {1, 1, 1, 1, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 1, 0, 
            1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 
            1, 0, 0\ , 0, 1}};\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[a, Mesh -> False], 
          ListDensityPlot[d, Mesh -> False]}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00
@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`8000Aoob7oob4004;o
of@0027oo`=oo`80009oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo
8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012
oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0
027oo`Aoo`40005oo`5oo`002Woo0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`8000Aood80
08Coob80027oo`=oo`80009oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo
17oo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool0
009oo`03001oogoo00Eoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`000goo00<0
07ooOol017oo0`000goo@P00Q?oo8P008Ooo0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomo
o`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`03
Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo00=ood;oob40027o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ
000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool20004
Oom2oolQ000QoomT000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40
027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`8000Aood;oob40027oof@0027oo`=oo`80009o
o`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4
oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40005o
o`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool20004Oon4oolQ000Qoom30003Ool20002Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40
027ood<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
ob40027ood<000Aoo`40005oo`5oo`0017oo0`000goo00<007ooOol00gooQ?oo8@008Ooo@`0017oo
0@000Goo0Goo0005Ool00`00Oomoo`02Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1
Ool0009oo`D000=oo`<000=oohCoob40027ood<0009oo`<0009oo`000Woo00@007ooOol000Aoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`000goo00<007oo000017oo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo0004Ool20004Ool00`00Oomoo`03OolQoolQ
0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo
0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool20004OolQoolQ0012oomT000Qool3Ool2
0002Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo0P0017oo@P00Q?oo8P008Ooo0goo0P000Woo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
0024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom20024oolR000Qool4Ool10001Ool1Ool0009oo`<000Eoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood8008Coob80027oo`Aoo`40
005oo`5oo`000Woo00@007ooOol000Aoo`<000=ood;oob40027oob40027oob80027oo`9oo`<0009o
o`000Woo0`001Goo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo0003
Ool00`00Oomoo`04Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool0
00=oo`<000Aoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool20004Oom2oolQ
000QoolQ000QoolR000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`8000AoohCoof@0027oo`=oo`80009oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool20004Oon4oomT000Qool3Ool20002
Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0
027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
0002Ool01000Oomoo`0017oo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo0002Ool01000
Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005Ool00`00Oomoo`3oOolAOol10001Ool1Ool0
009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol10001Ool1Ool000=oo`8000Eoo`03001oogoo
0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<0
07ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo0@00
0Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00
@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`8000Aoob7oob4004;o
of@0027oo`=oo`80009oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo
8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012
oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0
027oo`Aoo`40005oo`5oo`002Woo0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`8000Aood80
08Coob80027oo`=oo`80009oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo
17oo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool0
009oo`03001oogoo00Eoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`000goo00<0
07ooOol017oo0`000goo@P00Q?oo8P008Ooo0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomo
o`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`03
Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo00=ood;oob40027o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ
000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool20004
Oom2oolQ000QoomT000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40
027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`8000Aood;oob40027oof@0027oo`=oo`80009o
o`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4
oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40005o
o`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool20004Oon4oolQ000Qoom30003Ool20002Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40
027ood<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
ob40027ood<000Aoo`40005oo`5oo`0017oo0`000goo00<007ooOol00gooQ?oo8@008Ooo@`0017oo
0@000Goo0Goo0005Ool00`00Oomoo`02Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1
Ool0009oo`D000=oo`<000=oohCoob40027ood<0009oo`<0009oo`000Woo00@007ooOol000Aoo`03
001oogoo00=oob7oob4004;oob40027oob80027oo`Aoo`40005oo`5oo`000goo00<007oo000017oo
00<007ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo17oo0@000Goo0Goo0004Ool20004Ool00`00
Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7o
ob4004;oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo8@00
8Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oob40027oob80027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7o
ob4004;oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo8@00
8Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oob40027oob80027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7o
ob4004;oob40027oob80027oo`Aoo`40005oo`5oo`002Woo0P0017oo8Ooo8@00@_oo8@008Ooo8P00
8Ooo0goo0P000Woo000:Ool00`00Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oolQ0012oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oob40
027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oolQ0012oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oob40
027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oolQ000QoolR000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_oo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool20004OolQoolQ0012
oolQ000QoolR000Qool3Ool20002Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomo
o`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo0P0017oo@P00Q?oo8P008Ooo0goo0P000Woo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool0009oo`<000Eoo`03001o
ogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`<000=ood;oob40027oob40
027oob80027oo`9oo`<0009oo`000Woo0`001Goo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo0003Ool00`00Oomoo`04Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR
000Qool4Ool10001Ool1Ool000=oo`<000Aoo`03001oogoo00=ood;oob40027oob40027oob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ
000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ
000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo
0Goo000:Ool20004Oom2oolQ000QoolQ000QoolR000Qool3Ool20002Ool000Yoo`03001oogoo00=o
od;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Q
ool4Ool10001Ool1Ool000Yoo`8000AoohCoof@0027oo`=oo`80009oo`002Woo00<007ooOol00goo
Q?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool20004
Oon4oomT000Qool3Ool20002Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00gooQ?oo
I0008Ooo17oo0@000Goo0Goo0002Ool01000Oomoo`0017oo00<007ooOol00gooQ?ooI0008Ooo17oo
0@000Goo0Goo0002Ool01000Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005Ool00`00Oomo
o`3oOolAOol10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol10001Ool1Ool0
00=oo`8000Eoo`03001oogoo0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo00<007ooOol0
3Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol0
3Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol0
3Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol0
3Woo00<007ooOol00Woo0@000Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 137.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000RA000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol0019oo`8001Uoo`@001Yoo`<001Moo`<001Yoo`8001ao
o`8001Yoo`@001Yoo`<001Moo`<001Yoo`8000eoo`004Goo00@007ooOol001Qoo`03001oogoo01ao
o`03001oogoo01Ioo`04001oogoo000HOol01000Oomoo`006Woo00@007ooOol001Uoo`03001oogoo
01aoo`03001oogoo01Ioo`04001oogoo000HOol01000Oomoo`0037oo000AOol01000Oomoo`006Goo
00<007ooOol067oo1@005goo00@007ooOol001Qoo`04001oogoo000JOol01000Oomoo`006Woo00<0
07ooOol067oo1@005goo00@007ooOol001Qoo`04001oogoo000<Ool0015oo`04001oogoo000JOol0
0`00Oomoo`0GOol01000Oomoo`0067oo0`006Woo0P006goo00@007ooOol001]oo`03001oogoo01Mo
o`04001oogoo000HOol3000JOol2000=Ool0015oo`04001oogoo000HOol01000Oomoo`006Goo00<0
07oo00006Goo00<007ooOol067oo00@007ooOol001Yoo`04001oogoo000IOol01000Oomoo`006Goo
00<007oo00006Goo00<007ooOol067oo00@007ooOol000aoo`004Woo0P006Woo0P006goo0P006Goo
0`006Goo0P0077oo0P006goo0P006goo0P006Goo0`006Goo0P003Goo003oOolQOol00?moob5oo`00
ogoo8Goo000;Ool20004Oomf000COol20003Oomf000;Ool000Yoo`04001oogoo0003Ool00`00Ool0
0006Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool01000Oomoo`004Woo00@007ooOol0009oo`03001oo`0000Ioo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oo`0000]oo`002Woo
00@007ooOol000=oo`03001oogoo075oo`80019oo`04001oogoo0002Ool2001bOol2000;Ool000Yo
o`04001oogoo0003Ool00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0@Ool01000Oomo
o`000Woo00<007ooool03_oo3P007?oo:`003_oo00=oo`00Ool02Woo000:Ool01000Oomoo`000goo
00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol047oo00@007ooOol0009oo`03001ooooo
00koo`h001coob/000koo`03Ool007oo00Yoo`002goo0P0017oo00<007ooool03Ooo3P007Ooo:P00
3_oo0Woo00<007ooOol04Goo0P000goo00<007ooool03_oo3P007?oo:`003_oo00=oo`00Ool02Woo
000AOol00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>ool>000L
ool[000>ool00goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo
01Ioo`03001ooooo00koo`h001coob/000koo`03Ool007oo00Yoo`004Goo00<007ooool03Ooo3P00
7Ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool03_oo3P007?oo:`003_oo00=oo`00Ool02Woo
000AOol00`00Ooooo`0=ool>000MoolZ000>ool00goo0000000HOol2000?ool>000Lool[000>ool0
0goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo01Ioo`03001o
oooo00koo`h001coob/000koo`03Ool007oo00Yoo`004Goo00<007ooool03Ooo3P007Ooo:P003_oo
0Woo00<007ooOol05Woo00<007ooool03_oo3P007?oo:`003_oo00=oo`00Ool02Woo000AOol00`00
Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>ool>000Lool[000>ool0
0goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo01Ioo`03001o
oooo00koo`h001coob/000koo`03Ool007oo00Yoo`004Goo00<007ooool03Ooo3P007Ooo:P003_oo
0Woo00<007ooOol05Woo00<007ooool03_oo3P007?oo:`003_oo00=oo`00Ool02Woo000AOol00`00
Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>ool>000Lool[000>ool0
0goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`03Ool0000001Qoo`8000ooo`h0
01coob/000koo`03Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol0
5Woo00<007oo00007000>Ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>
ool2Ool00`00Oomoo`0FOol00`00Ool0000L000iool>000>ool00goo001oo`0:Ool0015oo`03001o
o`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03001oo`0001`003Woo`h000koo`03Ool007oo
00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol05Woo00<007oo00007000>Ooo
3P003_oo00=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol0
0`00Ool0000L000iool>000>ool00goo001oo`0:Ool0015oo`03001oo`0001/003Woo`h000koo`9o
o`03001oogoo01Ioo`03001oo`0001`003Woo`h000koo`03Ool007oo00Yoo`004Goo00<007oo0000
6`00>Ooo3P003_oo00=oo`00000067oo7`00>Ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ool0
000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ool0000L000iool>000>ool00goo001oo`0:
Ool0015oo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03001oo`0001`003Woo`h0
00koo`03Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol05Woo00<0
07oo00007000>Ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>ool2Ool0
0`00Oomoo`0FOol00`00Ool0000L000iool>000>ool00goo001oo`0:Ool000Yoo`@000=oo`03001o
o`0001/003Woo`h000koo`9oo`03001oogoo011oo`@0009oo`03001oo`0001`003Woo`h000koo`03
Ool007oo00Yoo`002Woo00<007ooOol017oo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol0
47oo00<007ooOol00goo00<007oo00007000>Ooo3P003_oo00=oo`00Ool02Woo000;Ool00`00Oomo
o`03Ool00`00Ool0000K000iool>000>ool00goo0000000COol00`00Oomoo`02OolO000iool>000>
ool2000;Ool000aoo`03001oogoo009oo`03001ooooo01_oo`h000ooobX000koo`9oo`03001oogoo
019oo`06001oogooOol007oo7Ooo3P003_oo:`003_oo00=oo`00Ool02Woo000:Ool01000Oomoo`00
0goo00<007ooool06ooo3P003ooo:P003_oo0Woo00<007ooOol047oo00@007ooOol0009oo`03001o
oooo01coo`h000koob/000koo`03Ool007oo00Yoo`002goo0P0017oo00<007ooool06ooo3P003ooo
:P003_oo0Woo00<007ooOol04Goo0P000goo00<007ooool07?oo3P003_oo:`003_oo00=oo`00Ool0
2Woo000AOol00`00Ooooo`0Kool>000?oolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>
000>ool[000>ool00goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooobX000koo`9oo`03001o
ogoo01Ioo`03001ooooo01coo`h000koob/000koo`03Ool007oo00Yoo`004Goo00<007ooool06ooo
3P003ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P003_oo:`003_oo00=oo`00Ool0
2Woo000AOol00`00Ooooo`0Kool>000?oolZ000>ool00goo0000000HOol2000Mool>000>ool[000>
ool00goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooobX000koo`9oo`03001oogoo01Ioo`03
001ooooo01coo`h000koob/000koo`03Ool007oo00Yoo`004Goo00<007ooool06ooo3P003ooo:P00
3_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P003_oo:`003_oo00=oo`00Ool02Woo000AOol0
0`00Ooooo`0Kool>000?oolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>000>ool[000>
ool00goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooobX000koo`9oo`03001oogoo01Ioo`03
001ooooo01coo`h000koob/000koo`03Ool007oo00Yoo`004Goo00<007ooool06ooo3P003ooo:P00
3_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P003_oo:`003_oo00=oo`00Ool02Woo000AOol0
0`00Ooooo`0Kool>000?oolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>000>ool[000>
ool00goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooobX000koo`9oo`03001oogoo01Ioo`03
001ooooo01coo`h000koob/000koo`03Ool007oo00Yoo`004Goo00<007ooool0>?oo3P003_oo7000
00=oo`00000067oo0P00>Ooo3P003ooo700000=oo`00Ool02Woo000AOol00`00Ooooo`0hool>000>
oolL0002Ool00`00Oomoo`0FOol00`00Ooooo`0hool>000?oolL00000goo001oo`0:Ool0015oo`03
001ooooo03Soo`h000kooa`0009oo`03001oogoo01Ioo`03001ooooo03Soo`h000oooa`00003Ool0
07oo00Yoo`004Goo00<007ooool0>?oo3P003_oo70000Woo00<007ooOol05Woo00<007ooool0>?oo
3P003ooo700000=oo`00Ool02Woo000AOol00`00Ooooo`0hool>000>oolL0002Ool00`00Oomoo`0F
Ool00`00Ooooo`0hool>000?oolL00000goo001oo`0:Ool0015oo`03001ooooo03Soo`h000kooa`0
009oo`03001oogoo01Ioo`03001ooooo03Soo`h000oooa`00003Ool007oo00Yoo`004Goo00<007oo
ool0>?oo3P003_oo70000Woo00<007ooOol05Woo00<007ooool0>?oo3P003ooo700000=oo`00Ool0
2Woo000AOol00`00Ooooo`0hool>000>oolL00000goo0000000HOol2000iool>000?oolL00000goo
001oo`0:Ool0015oo`03001ooooo03Soo`h000kooa`0009oo`03001oogoo01Ioo`03001ooooo03So
o`h000oooa`00003Ool007oo00Yoo`004Goo00<007ooool0>?oo3P003_oo70000Woo00<007ooOol0
5Woo00<007ooool0>?oo3P003ooo700000=oo`00Ool02Woo000AOol00`00Ooooo`0hool>000>oolL
0002Ool00`00Oomoo`0FOol00`00Ooooo`0hool>000?oolL00000goo001oo`0:Ool0015oo`03001o
oooo03Soo`h000kooa`0009oo`03001oogoo01Ioo`03001ooooo03Soo`h000oooa`00003Ool007oo
00Yoo`0037oo0`000Woo00<007ooool0>?oo3P003_oo70000Woo00<007ooOol04Woo0`0000=oo`00
Ool0>Ooo3P003ooo700000=oo`00Ool02Woo000=Ool01P00Oomoogoo001oocWoo`h000kooa`0009o
o`03001oogoo01=oo`05001oogoo001oo`0iool>000?oolL00000goo001oo`0:Ool000Yoo`D0009o
o`03001ooooo00goo`h001goobX000koo`03Ool00000019oo`D00003Ool0000000ooo`h001coo`h0
00ooo`h000koo`8000]oo`002Woo00@007ooOol000=oo`03001ooooo00goo`h001goobX000koo`9o
o`03001oogoo011oo`04001oogoo0002Ool00`00Ooooo`0>ool>000Lool>000?ool>000>ool00goo
001oo`0:Ool000]oo`03001oo`0000=oo`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo
015oo`03001oo`00009oo`03001ooooo00koo`h001coo`h000ooo`h000koo`03Ool007oo00Yoo`00
37oo0P000goo00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol04Woo0P000Woo00<007oo
ool03_oo3P007?oo3P003ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ooooo`0=ool>000MoolZ
000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>ool>000Lool>000?ool>000>ool00goo001oo`0:
Ool0015oo`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo01Ioo`03001ooooo00koo`h0
01coo`h000ooo`h000koo`03Ool007oo00Yoo`004Goo00<007ooool03Ooo3P007Ooo:P003_oo0Woo
00<007ooOol05Woo00<007ooool03_oo3P007?oo3P003ooo3P003_oo00=oo`00Ool02Woo000AOol0
0`00Ooooo`0=ool>000MoolZ000>ool00goo0000000HOol2000?ool>000Lool>000?ool>000>ool0
0goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo01Ioo`03001o
oooo00koo`h001coo`h000ooo`h000koo`03Ool007oo00Yoo`004Goo00<007ooool03Ooo3P007Ooo
:P003_oo0Woo00<007ooOol05Woo00<007ooool03_oo3P007?oo3P003ooo3P003_oo00=oo`00Ool0
2Woo000AOol00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>ool>
000Lool>000?ool>000>ool00goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`9o
o`03001oogoo01Ioo`03001ooooo00koo`h001coo`h000ooo`h000koo`03Ool007oo00Yoo`004Goo
00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool03_oo3P007?oo3P00
3ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomo
o`0FOol00`00Ooooo`0>ool>000Lool>000?ool>000>ool00goo001oo`0:Ool0015oo`03001oo`00
01/003Woo`h000koo`03Ool0000001Qooal003Woo`h000koo`03Ool007oo00Yoo`004Goo00<007oo
00006`00>Ooo3P003_oo0Woo00<007ooOol05Woo00<007oo00007000>Ooo3P003_oo00=oo`00Ool0
2Woo000AOol00`00Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ool0000L000iool>
000>ool00goo001oo`0:Ool0015oo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03
001oo`0001`003Woo`h000koo`03Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo
00<007ooOol05Woo00<007oo00007000>Ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ool0000K
000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ool0000L000iool>000>ool00goo001oo`0:Ool0
015oo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03001oo`0001`003Woo`h000ko
o`03Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo00=oo`00000067oo7`00>Ooo3P00
3_oo00=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00
Ool0000L000iool>000>ool00goo001oo`0:Ool0015oo`03001oo`0001/003Woo`h000koo`9oo`03
001oogoo01Ioo`03001oo`0001`003Woo`h000koo`03Ool007oo00Yoo`004Goo00<007oo00006`00
>Ooo3P003_oo0Woo00<007ooOol05Woo00<007oo00007000>Ooo3P003_oo00=oo`00Ool02Woo000A
Ool00`00Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ool0000L000iool>000>ool0
0goo001oo`0:Ool000Yoo`<000Aoo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo011oo`<0
00=oo`03001oo`0001`003Woo`h000koo`03Ool007oo00Yoo`002Woo00@007ooOol000=oo`03001o
o`0001/003Woo`h000koo`9oo`03001oogoo011oo`04001oogoo0002Ool00`00Ool0000L000iool>
000>ool00goo001oo`0:Ool000Yoo`04001oogoo0003Ool00`00Ooooo`0Kool>000?ool>000>ool>
000>ool00goo0000000BOol01000Oomoo`000Woo0P007Ooo3P003_oo3P003ooo3P003_oo0P002goo
000:Ool30004Ool00`00Ooooo`0Kool>000?ool>000>ool>000>ool2Ool00`00Oomoo`0@Ool30003
Ool00`00Ooooo`0Lool>000>ool>000?ool>000>ool00goo001oo`0:Ool000]oo`03001oogoo00=o
o`03001ooooo01_oo`h000ooo`h000koo`h000koo`9oo`03001oogoo015oo`03001oogoo009oo`03
001ooooo01coo`h000koo`h000ooo`h000koo`03Ool007oo00Yoo`002goo0`000goo00<007ooool0
6ooo3P003ooo3P003_oo3P003_oo0Woo00<007ooOol04Goo0`000Woo00<007ooool07?oo3P003_oo
3P003ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ooooo`0Kool>000?ool>000>ool>000>ool2
Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>000>ool>000?ool>000>ool00goo001oo`0:Ool0015o
o`03001ooooo01_oo`h000ooo`h000koo`h000koo`9oo`03001oogoo01Ioo`03001ooooo01coo`h0
00koo`h000ooo`h000koo`03Ool007oo00Yoo`004Goo00<007ooool06ooo3P003ooo3P003_oo3P00
3_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P003_oo3P003ooo3P003_oo00=oo`00Ool02Woo
000AOol00`00Ooooo`0Kool>000?ool>000>ool>000>ool00goo0000000HOol2000Mool>000>ool>
000?ool>000>ool00goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooo`h000koo`h000koo`9o
o`03001oogoo01Ioo`03001ooooo01coo`h000koo`h000ooo`h000koo`03Ool007oo00Yoo`004Goo
00<007ooool06ooo3P003ooo3P003_oo3P003_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P00
3_oo3P003ooo3P003_oo00=oo`00Ool02Woo000AOol00`00Ooooo`0Kool>000?ool>000>ool>000>
ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>000>ool>000?ool>000>ool00goo001oo`0:Ool0
015oo`03001ooooo01_oo`h000ooo`h000koo`h000koo`9oo`03001oogoo01Ioo`03001ooooo01co
o`h000koo`h000ooo`h000koo`03Ool007oo00Yoo`004Goo00<007ooool06ooo3P003ooo3P003_oo
3P003_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P003_oo3P003ooo3P003_oo00=oo`00Ool0
2Woo000AOol00`00Ooooo`0Kool>000?ool>000>ool>000>ool2Ool00`00Oomoo`0FOol00`00Oooo
o`0Lool>000>ool>000?ool>000>ool00goo001oo`0:Ool0015oo`03001ooooo03SoobX000koo`03
Ool0000001Qoo`8003Woob/000koo`03Ool007oo00Yoo`004Goo00<007ooool0>?oo:P003_oo0Woo
00<007ooOol05Woo00<007ooool0>?oo:`003_oo00=oo`00Ool02Woo000AOol00`00Ooooo`0hoolZ
000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0hool[000>ool00goo001oo`0:Ool0015oo`03001o
oooo03SoobX000koo`9oo`03001oogoo01Ioo`03001ooooo03Soob/000koo`03Ool007oo00Yoo`00
4Goo00<007ooool0>?oo:P003_oo0Woo00<007ooOol05Woo00<007ooool0>?oo:`003_oo00=oo`00
Ool02Woo000AOol00`00Ooooo`0hoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0hool[000>
ool00goo001oo`0:Ool0015oo`03001ooooo03SoobX000koo`9oo`03001oogoo01Ioo`03001ooooo
03Soob/000koo`03Ool007oo00Yoo`004Goo00<007ooool0>?oo:P003_oo00=oo`00000067oo0P00
>Ooo:`003_oo00=oo`00Ool02Woo000AOol00`00Ooooo`0hoolZ000>ool2Ool00`00Oomoo`0FOol0
0`00Ooooo`0hool[000>ool00goo001oo`0:Ool0015oo`03001ooooo03SoobX000koo`9oo`03001o
ogoo01Ioo`03001ooooo03Soob/000koo`03Ool007oo00Yoo`004Goo00<007ooool0>?oo:P003_oo
0Woo00<007ooOol05Woo00<007ooool0>?oo:`003_oo00=oo`00Ool02Woo000AOol00`00Ooooo`0h
oolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0hool[000>ool00goo001oo`0:Ool000]oo`80
00Aoo`03001ooooo03SoobX000koo`9oo`03001oogoo015oo`8000=oo`03001ooooo03Soob/000ko
o`03Ool007oo00Yoo`002Woo00@007ooOol000=oo`03001ooooo03SoobX000koo`9oo`03001oogoo
011oo`04001oogoo0002Ool00`00Ooooo`0hool[000>ool00goo001oo`0:Ool000Yoo`04001oogoo
0003Ool00`00Oomoo`1aOol2000BOol01000Oomoo`000Woo0P00LWoo0P002goo000;Ool20004Ool0
0`00Ool0000KOol00`00Oomoo`0IOol00`00Oomoo`0IOol00`00Oomoo`0IOol01000Oomoo`004goo
0P000goo00<007oo000077oo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol06Goo00<007oo
00002goo000:Ool01000Oomoo`000gooMP004Woo00@007ooOol0009oogH000]oo`002goo0P00SGoo
0P00Q7oo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {136.125, 0}} -> {-0.0541876, -0.0238146, \
0.00734626, 0.00734626}, {{7.375, 137}, {132.875, 3.1875}} -> {-1.37318, \
-1.13535, 0.0711274, 0.0711274}, {{149.938, 279.625}, {132.875, 3.1875}} -> \
{-11.5155, -1.13535, 0.0711274, 0.0711274}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
imageNormalize=Compile[{{data2D,_Real,2}},
\t\tModule[{minimum=Min[data2D]},
\t\t\t(data2D-minimum)/Max[data2D-minimum]]];\
\>", "Input"],

Cell[BoxData[
    \(\(fd = Fourier[d];\)\)], "Input"],

Cell["\<\
filterMatrix=imageNormalize[Abs[fd]]-imageNormalize[Abs[fa]];\
\>", "Input"],

Cell["defectSpect=filterMatrix fd;", "Input"],

Cell["\<\
defectPosition=imageNormalize[Abs[InverseFourier[defectSpect]]];\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Identified) show
129.000 12.813 moveto
(Defect) show
165.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000000000
0000000000000000
0000000000000000
0000000000000000
0000000000FF0000
0000000000000000
0000000000000000
0000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000FOol2
000kOol4000mOol3000iOol3000lOol2000?Ool001Eoo`04001oogoo000jOol00`00Oomoo`0oOol0
0`00Oomoo`0hOol01000Oomoo`00>Woo00@007ooOol000ioo`005Goo00@007ooOol003]oo`03001o
ogoo03]oo`D003Uoo`04001oogoo000jOol01000Oomoo`003Woo000EOol01000Oomoo`00?7oo00<0
07ooOol0>Woo00@007ooOol003Yoo`<003aoo`8000moo`005Goo00@007ooOol003Yoo`04001oogoo
000lOol00`00Ool0000kOol00`00Oomoo`0jOol01000Oomoo`003Woo000FOol2000lOol2000nOol2
000kOol3000kOol2000?Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol0019oool000D000Yoo`004Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol037oo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol027oo000BOol00`00Oomoo`3oOol1Ool00`00Oomoo`08Ool000]oo`8000Eoo`03001o
ogoo0?moo`5oo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03001o
ogoo00Qoo`002Woo00@007ooOol000Aoo`<00?ioo`<000Yoo`002Woo00@007ooOol000Aoo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`002goo0P001Goo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo0P000goonP000goo0P002Woo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol20003Oooj0003Ool2000:Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol20003Oooj0003Ool2000:Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
2Woo100017oo00<007ooOol00WoonP0017oo00<007ooOol027oo000:Ool00`00Oomoo`05Ool00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool000]oo`03001oogoo00Aoo`<0009oooX0009oo`<000Yo
o`0037oo00<007ooOol00goo00<007ooOol00WoonP0017oo00<007ooOol027oo000:Ool01000Oomo
o`0017oo00<007ooOol00WoonP0017oo00<007ooOol027oo000;Ool20005Ool00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`8000=oooX000=oo`8000Yoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`8000=o
ooX000=oo`8000Yoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo0P000goonP000goo0P002Woo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WoonP0017oo00<007ooOol027oo000<Ool30003Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool000eoo`03001oogoo009oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`002Woo1@000goo
0`000WoonP000Woo0`002Woo000:Ool01000Oomoo`0017oo00<007ooOol00WooW0008?oo?P0017oo
00<007ooOol027oo000;Ool00`00Ool00004Ool00`00Oomoo`02OonL000Pooln0004Ool00`00Oomo
o`08Ool000aoo`8000Aoo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL000Pooln0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL000Pooln
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL000P
ooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL
000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo
00Qoo`004Woo0P000gooW0008?oo?P000goo0P002Woo000BOol00`00Oomoo`02OonL000Pooln0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL000Pooln
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL000P
ooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL
000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02
OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001o
ogoo00Qoo`004Woo0P000gooW0008?oo?P000goo0P002Woo000BOol00`00Oomoo`02Oooj0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WoonP0017oo00<007ooOol027oo000BOol20003Oooj0003Ool2000:Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool000Yoo`<000Eoo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`<0009oooX0009oo`<000Yoo`002Woo0`001Goo
00<007ooOol00WoonP0017oo00<007ooOol027oo000;Ool00`00Oomoo`04Ool00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool000]oo`<000Aoo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo0P000goonP000goo0P002Woo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007oo
Ool027oo000BOol20003Oooj0003Ool2000:Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol20003Oooj0003Ool2000:
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`002goo0P001Goo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo00<007ooOol00WoonP0017oo00<007oo
Ool027oo000:Ool01000Oomoo`0017oo0`00oWoo0`002Woo000;Ool20005Ool00`00Oomoo`3oOol1
Ool00`00Oomoo`08Ool000Yoo`04001oogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`08Ool0
00]oo`8000Eoo`03001oogoo009oo`03001oogoo03]oo`03001oogoo03aoo`03001oogoo03]oo`03
001oogoo03]oo`03001oogoo009oo`03001oogoo00Qoo`004Woo00<007ooOol00Woo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol00Woo00<007ooOol027oo000BOooo0005000:Ool00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00Hgoo0`000goo10000Woo0`0000=o
o`0000000Woo0P000Woo0P0017oo0`000Woo10000goo0`000goo0`000goo10001Woo100017oo0`00
0Woo10000goo0`000goo0`000goo0P00Fgoo001TOol01@00Oomoogoo00000Woo00@007ooOol000Eo
o`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo00<007ooOol017oo00D007ooOomo
o`0000Eoo`04001oogoo0008Ool01000Oomoo`000Woo00<007ooOol017oo00<007ooOol00Woo00<0
07ooOol00goo00<007ooOol00goo00@007ooOol005Yoo`00I7oo00D007ooOomoo`00009oo`03001o
ogoo00@0009oo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`04Ool0
1000Oomoogoo10000Woo00@007ooOol000Qoo`04001oogoo0002Ool40003Ool00`00Oomoo`02Ool4
0002Ool00`00Oomoo`03Ool00`00Oomoo`1KOol006Aoo`03001oogoo009oo`<000=oo`80009oo`@0
009oo`D000=oo`8000=oo`@000=oo`8000Aoo`8000Aoo`<000Qoo`04001oogoo0003Ool20003Ool4
0003Ool20004Ool300000goo00000003001JOol006Aoo`03001oogoo00Aoo`03001oogoo00aoo`03
001oogoo00Yoo`03001oogoo015oo`03001oogoo00Ioo`04001oogoo0009Ool00`00Oomoo`0>Ool0
0`00Oomoo`1KOol006=oo`<000Aoo`8001Ioo`03001oogoo00=oo`8000Aoo`03001oogoo00Uoo`80
00Moo`@000]oo`8006aoo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.756806, -0.5532, 0.0321285, \
0.0321285}}]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wd = waveletMatrix[8, coif6] . d;\)\)], "Input"],

Cell["filterMatrix=imageNormalize[wd]-imageNormalize[wa];", "Input"],

Cell["defectSpect=filterMatrix wd;", "Input"],

Cell["\<\
defectPosition=imageNormalize[Transpose[waveletMatrix[8,coif6]].defectSpect];\
\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Identified) show
129.000 12.813 moveto
(Defect) show
165.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000000000
0000000000000000
0000000000000000
0000000000FF0000
0000000000FF0000
0000000000FF0000
0000000000000000
0000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000FOol2
000kOol4000mOol3000iOol3000lOol2000?Ool001Eoo`04001oogoo000jOol00`00Oomoo`0oOol0
0`00Oomoo`0hOol01000Oomoo`00>Woo00@007ooOol000ioo`005Goo00@007ooOol003]oo`03001o
ogoo03]oo`D003Uoo`04001oogoo000jOol01000Oomoo`003Woo000EOol01000Oomoo`00?7oo00<0
07ooOol0>Woo00@007ooOol003Yoo`<003aoo`8000moo`005Goo00@007ooOol003Yoo`04001oogoo
000lOol00`00Ool0000kOol00`00Oomoo`0jOol01000Oomoo`003Woo000FOol2000lOol2000nOol2
000kOol3000kOol2000?Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol0019oool000D000Yoo`004Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol037oo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol027oo000BOol00`00Oomoo`3oOol1Ool00`00Oomoo`08Ool000]oo`8000Eoo`03001o
ogoo0?moo`5oo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03001o
ogoo00Qoo`002Woo00@007ooOol000Aoo`<00?ioo`<000Yoo`002Woo00@007ooOol000Aoo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`002goo0P001Goo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo0P000goonP000goo0P002Woo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol20003Oooj0003Ool2000:Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol20003Oooj0003Ool2000:Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
2Woo100017oo00<007ooOol00WoonP0017oo00<007ooOol027oo000:Ool00`00Oomoo`05Ool00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool000]oo`03001oogoo00Aoo`<0009oooX0009oo`<000Yo
o`0037oo00<007ooOol00goo00<007ooOol00WoonP0017oo00<007ooOol027oo000:Ool01000Oomo
o`0017oo00<007ooOol00WoonP0017oo00<007ooOol027oo000;Ool20005Ool00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`8000=oooX000=oo`8000Yoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`8000=o
ooX000=oo`8000Yoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023o
och000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo
000BOol00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0
023ooch000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
oi`0023ooch000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009ooi`0023ooch000Aoo`03001oogoo00Qoo`004Woo0P000gooW0008?oo?P000goo0P002Woo000B
Ool00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023o
och000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo
000BOol00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0
023ooch000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
oi`0023ooch000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009ooi`0023ooch000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<0
07ooOol027oo000<Ool30003Ool00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool000eo
o`03001oogoo009oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qoo`002Woo1@000goo
0`000WooW0008?oo?P000Woo0`002Woo000:Ool01000Oomoo`0017oo00<007ooOol00WooW0008?oo
?P0017oo00<007ooOol027oo000;Ool00`00Ool00004Ool00`00Oomoo`02OonL000Pooln0004Ool0
0`00Oomoo`08Ool000aoo`8000Aoo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL000P
ooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL
000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02
OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomo
o`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03
001oogoo00Qoo`004Woo0P000gooW0008?oo?P000goo0P002Woo000BOol00`00Oomoo`02OonL000P
ooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02OonL
000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02
OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomo
o`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00
Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Ao
o`03001oogoo00Qoo`004Woo0P000gooW0008?oo?P000goo0P002Woo000BOol00`00Oomoo`02OonL
000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomoo`02
OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomo
o`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00
Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000B
Ool20003OonL000Pooln0003Ool2000:Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00Oomo
o`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol00`00
Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooi`0023ooch0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooW0008?oo?P0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OonL000Pooln0004Ool00`00Oomoo`08Ool000Yoo`<000Eoo`03001oogoo009o
oi`0023ooch000Aoo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo009ooi`0023o
och000Aoo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`<0009ooi`0023ooch0009oo`<000Yo
o`002Woo0`001Goo00<007ooOol00WoonP0017oo00<007ooOol027oo000;Ool00`00Oomoo`04Ool0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool000]oo`<000Aoo`03001oogoo009oooX000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03
001oogoo00Qoo`004Woo0P000goonP000goo0P002Woo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol20003Oooj0003Ool2000:Ool0019oo`03001oogoo009oooX0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol20003
Oooj0003Ool2000:Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`002goo0P001Goo
00<007ooOol00WoonP0017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo0`00oWoo0`002Woo000;Ool20005Ool0
0`00Oomoo`3oOol1Ool00`00Oomoo`08Ool000Yoo`04001oogoo0004Ool00`00Oomoo`3oOol1Ool0
0`00Oomoo`08Ool000]oo`8000Eoo`03001oogoo009oo`03001oogoo03]oo`03001oogoo03aoo`03
001oogoo03]oo`03001oogoo03]oo`03001oogoo009oo`03001oogoo00Qoo`004Woo00<007ooOol0
0Woo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol027oo000BOooo0005000:Ool00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00Hgoo0`000goo
10000Woo0`0000=oo`0000000Woo0P000Woo0P0017oo0`000Woo10000goo0`000goo0`000goo1000
1Woo100017oo0`000Woo10000goo0`000goo0`000goo0P00Fgoo001TOol01@00Oomoogoo00000Woo
00@007ooOol000Eoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo00<007ooOol0
17oo00D007ooOomoo`0000Eoo`04001oogoo0008Ool01000Oomoo`000Woo00<007ooOol017oo00<0
07ooOol00Woo00<007ooOol00goo00<007ooOol00goo00@007ooOol005Yoo`00I7oo00D007ooOomo
o`00009oo`03001oogoo00@0009oo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Oomoo`02Ool0
0`00Oomoo`04Ool01000Oomoogoo10000Woo00@007ooOol000Qoo`04001oogoo0002Ool40003Ool0
0`00Oomoo`02Ool40002Ool00`00Oomoo`03Ool00`00Oomoo`1KOol006Aoo`03001oogoo009oo`<0
00=oo`80009oo`@0009oo`D000=oo`8000=oo`@000=oo`8000Aoo`8000Aoo`<000Qoo`04001oogoo
0003Ool20003Ool40003Ool20004Ool300000goo00000003001JOol006Aoo`03001oogoo00Aoo`03
001oogoo00aoo`03001oogoo00Yoo`03001oogoo015oo`03001oogoo00Ioo`04001oogoo0009Ool0
0`00Oomoo`0>Ool00`00Oomoo`1KOol006=oo`<000Aoo`8001Ioo`03001oogoo00=oo`8000Aoo`03
001oogoo00Uoo`8000Moo`@000]oo`8006aoo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.756806, -0.5532, 0.0321285, \
0.0321285}}]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Shifted\ Bad\ Sample\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(bd = {{1, 1, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 1, 1, 0}, {1, 1, 0, 
            0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 1\ , 0}, {1, 1, 0, 1, 1, 0, 0, 
            0}, {1, 0, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 0, 1, 0}, {1, 1, 1, 
            1, 1, 0, 0\ , 0}};\)\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[a, Mesh -> False], 
          ListDensityPlot[bd, Mesh -> False]}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00
@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`8000Aoob7oob4004;o
of@0027oo`=oo`80009oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo
8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012
oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0
027oo`Aoo`40005oo`5oo`002Woo0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00
Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Co
ob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`8000Aood80
08Coob80027oo`=oo`80009oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood80
08Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
od8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo
17oo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03Oom20024oolR000Qool4Ool10001Ool1Ool0
009oo`03001oogoo00Eoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`000goo00<0
07ooOol017oo0`000goo@P00Q?oo8P008Ooo0Woo0`000Woo0004Ool00`00Oomoo`03Ool00`00Oomo
o`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0009oo`04001oogoo0004Ool00`00Oomoo`03
Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo00=ood;oob40027o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ
000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool20004
Oom2oolQ000QoomT000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40
027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@_oo8@008OooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
oolQ000QoomT000Qool4Ool10001Ool1Ool000Yoo`8000Aood;oob40027oof@0027oo`=oo`80009o
o`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4
oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40005o
o`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool20004Oon4oolQ000Qoom30003Ool20002Ool000Yoo`03001oogoo00=oohCoob40027ood<000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027ood<0
00Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40027o
od<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoob40
027ood<000Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo8@008Ooo@`0017oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
ob40027ood<000Aoo`40005oo`5oo`0017oo0`000goo00<007ooOol00gooQ?oo8@008Ooo@`0017oo
0@000Goo0Goo0005Ool00`00Oomoo`02Ool00`00Oomoo`03Oon4oolQ000Qoom30004Ool10001Ool1
Ool0009oo`D000=oo`<000=oohCoob40027ood<0009oo`<0009oo`000Woo00@007ooOol000Aoo`03
001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`000goo00<007oo000017oo00<007oo
Ool00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo0004Ool20004Ool00`00Oomoo`03OolQoolQ
0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;o
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo
00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI000
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo
0P0017oo8Ooo8@00@_ooI0008Ooo0goo0P000Woo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Ao
o`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oob7oob40
04;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo8@00@_oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoolQ0012oomT000Qool4Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7oob4004;oof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8Ooo8@00@_ooI0008Ooo17oo0@000Goo0Goo000:Ool20004OolQoolQ0012oomT000Qool3Ool2
0002Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Qool4
Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo0P0017oo@P00Q?oo8P008Ooo0goo0P000Woo000:Ool00`00Oomoo`03Oom20024oolR000Q
ool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024oolR
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom20024
oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2
0024oolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood8008Coob80027oo`Aoo`40005o
o`5oo`002Woo00<007ooOol00goo@P00Q?oo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom20024oolR000Qool4Ool10001Ool1Ool0009oo`<000Eoo`03001oogoo00=ood8008Coob80027o
o`Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood8008Coob80027oo`Aoo`40
005oo`5oo`000Woo00@007ooOol000Aoo`<000=ood;oob40027oob40027oob80027oo`9oo`<0009o
o`000Woo0`001Goo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo0003
Ool00`00Oomoo`04Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool0
00=oo`<000Aoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027o
ob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P00
8Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool20004Oom2oolQ
000QoolQ000QoolR000Qool3Ool20002Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob40027oob40027oob80027oo`Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000Q
oolQ000QoolR000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob40027oob40027oob80
027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@008Ooo8@008Ooo8P008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ000QoolQ000QoolR000Qool4Ool10001Ool1Ool000Yo
o`8000AoohCoof@0027oo`=oo`80009oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCo
of@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:
Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027o
o`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00
Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40
005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03
Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5o
o`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT
000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo
00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo000:Ool20004Oon4oomT000Qool3Ool20002
Ool000Yoo`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?oo
I0008Ooo17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yo
o`03001oogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001o
ogoo00=oohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=o
ohCoof@0027oo`Aoo`40005oo`5oo`002Woo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oon4oomT000Qool4Ool10001Ool1Ool000Yoo`03001oogoo00=oohCoof@0
027oo`Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo
0002Ool01000Oomoo`0017oo00<007ooOol00gooQ?ooI0008Ooo17oo0@000Goo0Goo0002Ool01000
Oomoo`0017oo0`00ogoo3goo0`000Woo0003Ool20005Ool00`00Oomoo`3oOolAOol10001Ool1Ool0
009oo`04001oogoo0004Ool00`00Oomoo`3oOolAOol10001Ool1Ool000=oo`8000Eoo`03001oogoo
0?mooa5oo`40005oo`5oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<0
07ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<0
07ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo0@00
0Goo0Goo000:Oooo000E0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFF0000FF000000
FFFFFFFFFF00FF00
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF00FF00
FFFFFFFFFF000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000?Ool2
000oOol40010Ool3000mOol30010Ool20007Ool000ioo`04001oogoo000nOol00`00Oomoo`12Ool0
0`00Oomoo`0lOol01000Oomoo`00?Woo00@007ooOol000Ioo`003Woo00@007ooOol003moo`03001o
ogoo03ioo`D003eoo`04001oogoo000nOol01000Oomoo`001Woo000>Ool01000Oomoo`00@7oo00<0
07ooOol0?Goo00@007ooOol003ioo`<0041oo`8000Moo`003Woo00@007ooOol003ioo`04001oogoo
000oOol00`00Ool0000oOol00`00Oomoo`0nOol01000Oomoo`001Woo000?Ool20010Ool20011Ool2
000oOol3000oOol20007Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol000Yoool001D0009oo`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo
00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo
00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo
0@000Goo0Goo000:Ool00`00Oomoo`03Ool00`00Oomoo`0oOol00`00Oomoo`0oOol00`00Oomoo`0o
Ool00`00Oomoo`0oOol00`00Oomoo`02Ool10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5o
o`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo0?mooa5oo`40005oo`5oo`000Woo00@0
07ooOol000Aoo`<00?moo`moo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood;oob40
04;oof@000Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood;oob4004;oof@0
00Aoo`40005oo`5oo`000goo0P001Goo00<007ooOol00goo@_oo8@00@_ooI00017oo0@000Goo0Goo
000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`03001oogoo00=ood;o
ob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00@_ooI00017oo0@000Goo
0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`03001oogoo00=o
od;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00@_ooI00017oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00@_ooI00017oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00@_ooI000
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`80
00Aood;oob4004;oof@000=oo`80009oo`002Woo00<007ooOol00goo@_oo8@00@_ooI00017oo0@00
0Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`03001oogoo
00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00@_ooI00017oo
0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`03001o
ogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00@_ooI000
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yoo`03
001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00@_oo
I00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00
@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo0P0017oo@_oo8@00@_oo
I0000goo0P000Woo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool10001Ool1Ool000Yoo`03
001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo@P00QOoo
8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool10001Ool1Ool000Yo
o`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo@P00
QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool10001Ool1Ool0
00Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo8Ooo
@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool1
0001Ool1Ool000Yoo`8000Aoob7ood8008Goob4000=oo`80009oo`002Woo00<007ooOol00goo8Ooo
@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool10001Ool1
Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool10001
Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004Ool1
0001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo0002Ool40004Ool00`00Oomoo`03OolQoom2
0025oolQ0004Ool10001Ool1Ool0009oo`03001oogoo00Eoo`03001oogoo00=oob7ood8008Goob40
00Aoo`40005oo`5oo`000goo00<007ooOol017oo0`000goo8Ooo@P00QOoo8@000Woo0`000Woo0004
Ool00`00Oomoo`03Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1Ool0009oo`04001o
ogoo0004Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1Ool000=oo`8000Eoo`03001o
ogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo@P008OooI000
17oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1Ool000Yoo`03
001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo@P008Ooo
I00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo@P00
8OooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo
@P008OooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo@P008OooI00017oo0@000Goo0Goo000:Ool20004Oom2oom2000QoomT0003Ool20002Ool000Yo
o`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo@P00
8OooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo
@P008OooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo@P008OooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo@P008OooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood;ood80027oof@000Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo@_oo@P008OooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oom2000QoomT0004
Ool10001Ool1Ool000Yoo`8000Aood;ood80027oof@000=oo`80009oo`002Woo00<007ooOol00goo
YOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ000RoolQ0004Ool10001
Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`002Woo00<007ooOol0
0gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ000RoolQ0004Ool1
0001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`002Woo00<007oo
Ool00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ000RoolQ0004
Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`002Woo00<0
07ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ000RoolQ
0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`002Woo
00<007ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ000R
oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`00
2Woo00<007ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool20004OonUoolQ000RoolQ
0003Ool20002Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`002Woo00<0
07ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ000RoolQ
0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`002Woo
00<007ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ000R
oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5oo`00
2Woo00<007ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoolQ
000RoolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005oo`5o
o`002Woo00<007ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonU
oolQ000RoolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoob4002;oob4000Aoo`40005o
o`5oo`0017oo0`000goo00<007ooOol00gooYOoo8@008_oo8@0017oo0@000Goo0Goo0005Ool00`00
Oomoo`02Ool00`00Oomoo`03OonUoolQ000RoolQ0004Ool10001Ool1Ool0009oo`D000=oo`<000=o
ojGoob4002;oob40009oo`<0009oo`000Woo00@007ooOol000Aoo`03001oogoo00=ood;oob4004;o
of@000Aoo`40005oo`5oo`000goo00<007oo000017oo00<007ooOol00goo@_oo8@00@_ooI00017oo
0@000Goo0Goo0004Ool20004Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool000Yo
o`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo8@00
@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1Ool0
00Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo@_oo
8@00@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@00@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@00@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo0P0017oo
@_oo8@00@_ooI0000goo0P000Woo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001Ool1
Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
@_oo8@00@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool10001
Ool1Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007ooOol0
0goo@_oo8@00@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004Ool1
0001Ool1Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo@_oo8@00@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT0004
Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo@_oo8@00@_ooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03Oom2oolQ0012oomT
0004Ool10001Ool1Ool000Yoo`03001oogoo00=ood;oob4004;oof@000Aoo`40005oo`5oo`002Woo
00<007ooOol00goo@_oo8@00@_ooI00017oo0@000Goo0Goo000:Ool20004Oom2oolQ0012oomT0003
Ool20002Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<007oo
Ool00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ0004
Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo00<0
07ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025oolQ
0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`002Woo
00<007ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom20025
oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2
0025oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oom20025oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005o
o`5oo`002Woo0P0017oo8Ooo@P00QOoo8@000goo0P000Woo000:Ool00`00Oomoo`03OolQoom20025
oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5oo`00
2Woo00<007ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQoom2
0025oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005oo`5o
o`002Woo00<007ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OolQ
oom20025oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40005o
o`5oo`002Woo00<007ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03
OolQoom20025oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oob7ood8008Goob4000Aoo`40
005oo`5oo`002Woo00<007ooOol00goo8Ooo@P00QOoo8@0017oo0@000Goo0Goo000:Ool00`00Oomo
o`03OolQoom20025oolQ0004Ool10001Ool1Ool0009oo`<000Eoo`03001oogoo00=oob7ood8008Go
ob4000Aoo`40005oo`5oo`000Woo00@007ooOol000Aoo`03001oogoo00=oob7ood8008Goob4000Ao
o`40005oo`5oo`000Woo00@007ooOol000Aoo`<000=oof?oob40027oob4002;oob40009oo`<0009o
o`000Woo0`001Goo00<007ooOol00gooHooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo0003Ool0
0`00Oomoo`04Ool00`00Oomoo`03OomSoolQ000QoolQ000RoolQ0004Ool10001Ool1Ool000=oo`<0
00Aoo`03001oogoo00=oof?oob40027oob4002;oob4000Aoo`40005oo`5oo`002Woo00<007ooOol0
0gooHooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OomSoolQ000QoolQ
000RoolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oof?oob40027oob4002;oob4000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooHooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo000:Ool0
0`00Oomoo`03OomSoolQ000QoolQ000RoolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oof?o
ob40027oob4002;oob4000Aoo`40005oo`5oo`002Woo00<007ooOol00gooHooo8@008Ooo8@008_oo
8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OomSoolQ000QoolQ000RoolQ0004Ool10001Ool1
Ool000Yoo`03001oogoo00=oof?oob40027oob4002;oob4000Aoo`40005oo`5oo`002Woo00<007oo
Ool00gooHooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OomSoolQ000Q
oolQ000RoolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oof?oob40027oob4002;oob4000Ao
o`40005oo`5oo`002Woo00<007ooOol00gooHooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo000:
Ool20004OomSoolQ000QoolQ000RoolQ0003Ool20002Ool000Yoo`03001oogoo00=oof?oob40027o
ob4002;oob4000Aoo`40005oo`5oo`002Woo00<007ooOol00gooHooo8@008Ooo8@008_oo8@0017oo
0@000Goo0Goo000:Ool00`00Oomoo`03OomSoolQ000QoolQ000RoolQ0004Ool10001Ool1Ool000Yo
o`03001oogoo00=oof?oob40027oob4002;oob4000Aoo`40005oo`5oo`002Woo00<007ooOol00goo
Hooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OomSoolQ000QoolQ000R
oolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oof?oob40027oob4002;oob4000Aoo`40005o
o`5oo`002Woo00<007ooOol00gooHooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00
Oomoo`03OomSoolQ000QoolQ000RoolQ0004Ool10001Ool1Ool000Yoo`03001oogoo00=oof?oob40
027oob4002;oob4000Aoo`40005oo`5oo`002Woo00<007ooOol00gooHooo8@008Ooo8@008_oo8@00
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OomSoolQ000QoolQ000RoolQ0004Ool10001Ool1Ool0
00Yoo`03001oogoo00=oof?oob40027oob4002;oob4000Aoo`40005oo`5oo`002Woo00<007ooOol0
0gooHooo8@008Ooo8@008_oo8@0017oo0@000Goo0Goo000:Ool00`00Oomoo`03OomSoolQ000QoolQ
000RoolQ0004Ool10001Ool1Ool000Yoo`8000AoojGoof@000=oo`80009oo`002Woo00<007ooOol0
0gooYOooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoomT0004Ool10001Ool1Ool000Yo
o`03001oogoo00=oojGoof@000Aoo`40005oo`5oo`002Woo00<007ooOol00gooYOooI00017oo0@00
0Goo0Goo000:Ool00`00Oomoo`03OonUoomT0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGo
of@000Aoo`40005oo`5oo`002Woo00<007ooOol00gooYOooI00017oo0@000Goo0Goo000:Ool00`00
Oomoo`03OonUoomT0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoof@000Aoo`40005oo`5o
o`002Woo00<007ooOol00gooYOooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoomT0004
Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoof@000Aoo`40005oo`5oo`002Woo00<007ooOol0
0gooYOooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoomT0004Ool10001Ool1Ool000Yo
o`03001oogoo00=oojGoof@000Aoo`40005oo`5oo`002Woo00<007ooOol00gooYOooI00017oo0@00
0Goo0Goo000:Ool20004OonUoomT0003Ool20002Ool000Yoo`03001oogoo00=oojGoof@000Aoo`40
005oo`5oo`002Woo00<007ooOol00gooYOooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonU
oomT0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoof@000Aoo`40005oo`5oo`002Woo00<0
07ooOol00gooYOooI00017oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoomT0004Ool10001Ool1
Ool000Yoo`03001oogoo00=oojGoof@000Aoo`40005oo`5oo`002Woo00<007ooOol00gooYOooI000
17oo0@000Goo0Goo000:Ool00`00Oomoo`03OonUoomT0004Ool10001Ool1Ool000Yoo`03001oogoo
00=oojGoof@000Aoo`40005oo`5oo`002Woo00<007ooOol00gooYOooI00017oo0@000Goo0Goo000:
Ool00`00Oomoo`03OonUoomT0004Ool10001Ool1Ool000Yoo`03001oogoo00=oojGoof@000Aoo`40
005oo`5oo`000goo0P001Goo00<007ooOol00gooYOooI00017oo0@000Goo0Goo0002Ool01000Oomo
o`0017oo00<007ooOol00gooYOooI00017oo0@000Goo0Goo0002Ool01000Oomoo`0017oo0`00ogoo
3goo0`000Woo0003Ool20005Ool00`00Oomoo`3oOolAOol10001Ool1Ool0009oo`04001oogoo0004
Ool00`00Oomoo`3oOolAOol10001Ool1Ool000=oo`8000Eoo`03001oogoo0?mooa5oo`40005oo`5o
o`002Woo00<007ooOol00goo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007oo
Ool03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007oo
Ool03Goo00<007ooOol03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol03Goo00<007oo
Ool03Woo00<007ooOol03Goo00<007ooOol03Woo00<007ooOol00Woo0@000Goo0Goo000:Oooo000E
0002Ool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, \
0.0303025}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFF0000FF000000
FFFFFFFFFF00FF00
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF00FF00
FFFFFFFFFF000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 137.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000RA000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol0019oo`8001Uoo`@001Yoo`<001Moo`<001Yoo`8001ao
o`8001Yoo`@001Yoo`<001Moo`<001Yoo`8000eoo`004Goo00@007ooOol001Qoo`03001oogoo01ao
o`03001oogoo01Ioo`04001oogoo000HOol01000Oomoo`006Woo00@007ooOol001Uoo`03001oogoo
01aoo`03001oogoo01Ioo`04001oogoo000HOol01000Oomoo`0037oo000AOol01000Oomoo`006Goo
00<007ooOol067oo1@005goo00@007ooOol001Qoo`04001oogoo000JOol01000Oomoo`006Woo00<0
07ooOol067oo1@005goo00@007ooOol001Qoo`04001oogoo000<Ool0015oo`04001oogoo000JOol0
0`00Oomoo`0GOol01000Oomoo`0067oo0`006Woo0P006goo00@007ooOol001]oo`03001oogoo01Mo
o`04001oogoo000HOol3000JOol2000=Ool0015oo`04001oogoo000HOol01000Oomoo`006Goo00<0
07oo00006Goo00<007ooOol067oo00@007ooOol001Yoo`04001oogoo000IOol01000Oomoo`006Goo
00<007oo00006Goo00<007ooOol067oo00@007ooOol000aoo`004Woo0P006Woo0P006goo0P006Goo
0`006Goo0P0077oo0P006goo0P006goo0P006Goo0`006Goo0P003Goo003oOolQOol00?moob5oo`00
ogoo8Goo000;Ool20004Oomf000COol20003Oomf000;Ool000Yoo`04001oogoo0003Ool00`00Ool0
0006Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomo
o`04Ool01000Oomoo`004Woo00@007ooOol0009oo`03001oo`0000Ioo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oogoo00Aoo`03001oo`0000]oo`002Woo
00@007ooOol000=oo`03001oogoo075oo`80019oo`04001oogoo0002Ool2001bOol2000;Ool000Yo
o`04001oogoo0003Ool00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0@Ool01000Oomo
o`000Woo00<007ooool07?oo3P007?oo:`0000=oo`00Ool02Woo000:Ool01000Oomoo`000goo00<0
07ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol047oo00@007ooOol0009oo`03001ooooo01co
o`h001coob/00003Ool007oo00Yoo`002goo0P0017oo00<007ooool03Ooo3P007Ooo:P003_oo0Woo
00<007ooOol04Goo0P000goo00<007ooool07?oo3P007?oo:`0000=oo`00Ool02Woo000AOol00`00
Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>000Lool[00000goo
001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo01Ioo`03001ooooo
01coo`h001coob/00003Ool007oo00Yoo`004Goo00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<0
07ooOol05Woo00<007ooool07?oo3P007?oo:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0=ool>
000MoolZ000>ool00goo0000000HOol2000Mool>000Lool[00000goo001oo`0:Ool0015oo`03001o
oooo00goo`h001goobX000koo`9oo`03001oogoo01Ioo`03001ooooo01coo`h001coob/00003Ool0
07oo00Yoo`004Goo00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool0
7?oo3P007?oo:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00
Oomoo`0FOol00`00Ooooo`0Lool>000Lool[00000goo001oo`0:Ool0015oo`03001ooooo00goo`h0
01goobX000koo`9oo`03001oogoo01Ioo`03001ooooo01coo`h001coob/00003Ool007oo00Yoo`00
4Goo00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P007?oo
:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol0
0`00Ooooo`0Lool>000Lool[00000goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000ko
o`03Ool0000001Qoo`8001goo`h001coob/00003Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo
3P003_oo0Woo00<007ooOol05Woo00<007ooool03_oo7000>Ooo3P0000=oo`00Ool02Woo000AOol0
0`00Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>oolL000iool>00000goo
001oo`0:Ool0015oo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03001ooooo00ko
oa`003Woo`h00003Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol0
5Woo00<007ooool03_oo7000>Ooo3P0000=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>
ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>oolL000iool>00000goo001oo`0:Ool0015oo`03001o
o`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03001ooooo00kooa`003Woo`h00003Ool007oo
00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo00=oo`00000067oo0P003ooo7000>Ooo3P0000=o
o`00Ool02Woo000AOol00`00Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>
oolL000iool>00000goo001oo`0:Ool0015oo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo
01Ioo`03001ooooo00kooa`003Woo`h00003Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P00
3_oo0Woo00<007ooOol05Woo00<007ooool03_oo7000>Ooo3P0000=oo`00Ool02Woo000AOol00`00
Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>oolL000iool>00000goo001o
o`0:Ool000Yoo`@000=oo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo011oo`@0009oo`03
001ooooo00kooa`003Woo`h00003Ool007oo00Yoo`002Woo00<007ooOol017oo00<007oo00006`00
>Ooo3P003_oo0Woo00<007ooOol047oo00<007ooOol00goo00<007ooool03_oo7000>Ooo3P0000=o
o`00Ool02Woo000;Ool00`00Oomoo`03Ool00`00Ool0000K000iool>000>ool00goo0000000COol0
0`00Oomoo`02Ool2000?oolL000iool@000;Ool000aoo`03001oogoo009oo`03001ooooo01_oo`h0
00ooobX000koo`9oo`03001oogoo019oo`06001oogooOol007oo7Ooo70003_oo:`0000=oo`00Ool0
2Woo000:Ool01000Oomoo`000goo00<007ooool06ooo3P003ooo:P003_oo0Woo00<007ooOol047oo
00@007ooOol0009oo`03001ooooo01cooa`000koob/00003Ool007oo00Yoo`002goo0P0017oo00<0
07ooool06ooo3P003ooo:P003_oo0Woo00<007ooOol04Goo0P000goo00<007ooool07?oo70003_oo
:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0Kool>000?oolZ000>ool2Ool00`00Oomoo`0FOol0
0`00Ooooo`0LoolL000>ool[00000goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooobX000ko
o`9oo`03001oogoo01Ioo`03001ooooo01cooa`000koob/00003Ool007oo00Yoo`004Goo00<007oo
ool06ooo3P003ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool07?oo70003_oo:`0000=oo`00
Ool02Woo000AOol00`00Ooooo`0Kool>000?oolZ000>ool00goo0000000HOol2000MoolL000>ool[
00000goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooobX000koo`9oo`03001oogoo01Ioo`03
001ooooo01cooa`000koob/00003Ool007oo00Yoo`004Goo00<007ooool06ooo3P003ooo:P003_oo
0Woo00<007ooOol05Woo00<007ooool07?oo70003_oo:`0000=oo`00Ool02Woo000AOol00`00Oooo
o`0Kool>000?oolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0LoolL000>ool[00000goo001o
o`0:Ool0015oo`03001ooooo01_oo`h000ooobX000koo`9oo`03001oogoo01Ioo`03001ooooo01co
oa`000koob/00003Ool007oo00Yoo`004Goo00<007ooool06ooo3P003ooo:P003_oo0Woo00<007oo
Ool05Woo00<007ooool07?oo70003_oo:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0Kool>000?
oolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0LoolL000>ool[00000goo001oo`0:Ool0015o
o`03001ooooo01_oo`h000ooobX000koo`9oo`03001oogoo01Ioo`03001ooooo01cooa`000koob/0
0003Ool007oo00Yoo`004Goo00<007ooool0>?oo3P003_oo700000=oo`00000067oo0P00Aooo3`00
3_oo3P0000=oo`00Ool02Woo000AOol00`00Ooooo`0hool>000>oolL0002Ool00`00Oomoo`0FOol0
0`00Ooooo`16ool?000>ool>00000goo001oo`0:Ool0015oo`03001ooooo03Soo`h000kooa`0009o
o`03001oogoo01Ioo`03001ooooo04Koo`l000koo`h00003Ool007oo00Yoo`004Goo00<007ooool0
>?oo3P003_oo70000Woo00<007ooOol05Woo00<007ooool0A_oo3`003_oo3P0000=oo`00Ool02Woo
000AOol00`00Ooooo`0hool>000>oolL0002Ool00`00Oomoo`0FOol00`00Ooooo`16ool?000>ool>
00000goo001oo`0:Ool0015oo`03001ooooo03Soo`h000kooa`0009oo`03001oogoo01Ioo`03001o
oooo04Koo`l000koo`h00003Ool007oo00Yoo`004Goo00<007ooool0>?oo3P003_oo70000Woo00<0
07ooOol05Woo00<007ooool0A_oo3`003_oo3P0000=oo`00Ool02Woo000AOol00`00Ooooo`0hool>
000>oolL00000goo0000000HOol20017ool?000>ool>00000goo001oo`0:Ool0015oo`03001ooooo
03Soo`h000kooa`0009oo`03001oogoo01Ioo`03001ooooo04Koo`l000koo`h00003Ool007oo00Yo
o`004Goo00<007ooool0>?oo3P003_oo70000Woo00<007ooOol05Woo00<007ooool0A_oo3`003_oo
3P0000=oo`00Ool02Woo000AOol00`00Ooooo`0hool>000>oolL0002Ool00`00Oomoo`0FOol00`00
Ooooo`16ool?000>ool>00000goo001oo`0:Ool0015oo`03001ooooo03Soo`h000kooa`0009oo`03
001oogoo01Ioo`03001ooooo04Koo`l000koo`h00003Ool007oo00Yoo`0037oo0`000Woo00<007oo
ool0>?oo3P003_oo70000Woo00<007ooOol04Woo0`0000=oo`00Ool0Aooo3`003_oo3P0000=oo`00
Ool02Woo000=Ool01P00Oomoogoo001oocWoo`h000kooa`0009oo`03001oogoo01=oo`05001oogoo
001oo`17ool?000>ool>00000goo001oo`0:Ool000Yoo`D0009oo`03001ooooo00goo`h001goobX0
00koo`03Ool00000019oo`D00003Ool0000001goo`h001coobd000]oo`002Woo00@007ooOol000=o
o`03001ooooo00goo`h001goobX000koo`9oo`03001oogoo011oo`04001oogoo0002Ool00`00Oooo
o`0Lool>000Lool[00000goo001oo`0:Ool000]oo`03001oo`0000=oo`03001ooooo00goo`h001go
obX000koo`9oo`03001oogoo015oo`03001oo`00009oo`03001ooooo01coo`h001coob/00003Ool0
07oo00Yoo`0037oo0P000goo00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol04Woo0P00
0Woo00<007ooool07?oo3P007?oo:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0=ool>000MoolZ
000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>000Lool[00000goo001oo`0:Ool0015oo`03
001ooooo00goo`h001goobX000koo`9oo`03001oogoo01Ioo`03001ooooo01coo`h001coob/00003
Ool007oo00Yoo`004Goo00<007ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol05Woo00<007oo
ool07?oo3P007?oo:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0=ool>000MoolZ000>ool00goo
0000000HOol2000Mool>000Lool[00000goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX0
00koo`9oo`03001oogoo01Ioo`03001ooooo01coo`h001coob/00003Ool007oo00Yoo`004Goo00<0
07ooool03Ooo3P007Ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P007?oo:`0000=o
o`00Ool02Woo000AOol00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol00`00Oooo
o`0Lool>000Lool[00000goo001oo`0:Ool0015oo`03001ooooo00goo`h001goobX000koo`9oo`03
001oogoo01Ioo`03001ooooo01coo`h001coob/00003Ool007oo00Yoo`004Goo00<007ooool03Ooo
3P007Ooo:P003_oo0Woo00<007ooOol05Woo00<007ooool07?oo3P007?oo:`0000=oo`00Ool02Woo
000AOol00`00Ooooo`0=ool>000MoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Lool>000L
ool[00000goo001oo`0:Ool0015oo`03001oo`0001/003Woo`h000koo`03Ool0000001Qoo`8000oo
oa`003Woo`h00003Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol0
5Woo00<007ooool03_oo7000>Ooo3P0000=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>
ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>oolL000iool>00000goo001oo`0:Ool0015oo`03001o
o`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03001ooooo00kooa`003Woo`h00003Ool007oo
00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol05Woo00<007ooool03_oo7000
>Ooo3P0000=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol0
0`00Ooooo`0>oolL000iool>00000goo001oo`0:Ool0015oo`03001oo`0001/003Woo`h000koo`9o
o`03001oogoo01Ioo`03001ooooo00kooa`003Woo`h00003Ool007oo00Yoo`004Goo00<007oo0000
6`00>Ooo3P003_oo00=oo`00000067oo0P003ooo7000>Ooo3P0000=oo`00Ool02Woo000AOol00`00
Ool0000K000iool>000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0>oolL000iool>00000goo001o
o`0:Ool0015oo`03001oo`0001/003Woo`h000koo`9oo`03001oogoo01Ioo`03001ooooo00kooa`0
03Woo`h00003Ool007oo00Yoo`004Goo00<007oo00006`00>Ooo3P003_oo0Woo00<007ooOol05Woo
00<007ooool03_oo7000>Ooo3P0000=oo`00Ool02Woo000AOol00`00Ool0000K000iool>000>ool2
Ool00`00Oomoo`0FOol00`00Ooooo`0>oolL000iool>00000goo001oo`0:Ool000Yoo`<000Aoo`03
001oo`0001/003Woo`h000koo`9oo`03001oogoo011oo`<000=oo`03001ooooo00kooa`003Woo`h0
0003Ool007oo00Yoo`002Woo00@007ooOol000=oo`03001oo`0001/003Woo`h000koo`9oo`03001o
ogoo011oo`04001oogoo0002Ool00`00Ooooo`0>oolL000iool>00000goo001oo`0:Ool000Yoo`04
001oogoo0003Ool00`00Ooooo`0Kool>000?ool>000>ool>000>ool00goo0000000BOol01000Oomo
o`000Woo0P00:ooo3P003_oo3`003_oo40002goo000:Ool30004Ool00`00Ooooo`0Kool>000?ool>
000>ool>000>ool2Ool00`00Oomoo`0@Ool30003Ool00`00Ooooo`0Zool>000>ool?000>ool>0000
0goo001oo`0:Ool000]oo`03001oogoo00=oo`03001ooooo01_oo`h000ooo`h000koo`h000koo`9o
o`03001oogoo015oo`03001oogoo009oo`03001ooooo02[oo`h000koo`l000koo`h00003Ool007oo
00Yoo`002goo0`000goo00<007ooool06ooo3P003ooo3P003_oo3P003_oo0Woo00<007ooOol04Goo
0`000Woo00<007ooool0:_oo3P003_oo3`003_oo3P0000=oo`00Ool02Woo000AOol00`00Ooooo`0K
ool>000?ool>000>ool>000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Zool>000>ool?000>ool>
00000goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooo`h000koo`h000koo`9oo`03001oogoo
01Ioo`03001ooooo02[oo`h000koo`l000koo`h00003Ool007oo00Yoo`004Goo00<007ooool06ooo
3P003ooo3P003_oo3P003_oo0Woo00<007ooOol05Woo00<007ooool0:_oo3P003_oo3`003_oo3P00
00=oo`00Ool02Woo000AOol00`00Ooooo`0Kool>000?ool>000>ool>000>ool00goo0000000HOol2
000[ool>000>ool?000>ool>00000goo001oo`0:Ool0015oo`03001ooooo01_oo`h000ooo`h000ko
o`h000koo`9oo`03001oogoo01Ioo`03001ooooo02[oo`h000koo`l000koo`h00003Ool007oo00Yo
o`004Goo00<007ooool06ooo3P003ooo3P003_oo3P003_oo0Woo00<007ooOol05Woo00<007ooool0
:_oo3P003_oo3`003_oo3P0000=oo`00Ool02Woo000AOol00`00Ooooo`0Kool>000?ool>000>ool>
000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Zool>000>ool?000>ool>00000goo001oo`0:Ool0
015oo`03001ooooo01_oo`h000ooo`h000koo`h000koo`9oo`03001oogoo01Ioo`03001ooooo02[o
o`h000koo`l000koo`h00003Ool007oo00Yoo`004Goo00<007ooool06ooo3P003ooo3P003_oo3P00
3_oo0Woo00<007ooOol05Woo00<007ooool0:_oo3P003_oo3`003_oo3P0000=oo`00Ool02Woo000A
Ool00`00Ooooo`0Kool>000?ool>000>ool>000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`0Zool>
000>ool?000>ool>00000goo001oo`0:Ool0015oo`03001ooooo03SoobX000koo`03Ool0000001Qo
o`8004Ooob/00003Ool007oo00Yoo`004Goo00<007ooool0>?oo:P003_oo0Woo00<007ooOol05Woo
00<007ooool0A_oo:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0hoolZ000>ool2Ool00`00Oomo
o`0FOol00`00Ooooo`16ool[00000goo001oo`0:Ool0015oo`03001ooooo03SoobX000koo`9oo`03
001oogoo01Ioo`03001ooooo04Koob/00003Ool007oo00Yoo`004Goo00<007ooool0>?oo:P003_oo
0Woo00<007ooOol05Woo00<007ooool0A_oo:`0000=oo`00Ool02Woo000AOol00`00Ooooo`0hoolZ
000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`16ool[00000goo001oo`0:Ool0015oo`03001ooooo
03SoobX000koo`9oo`03001oogoo01Ioo`03001ooooo04Koob/00003Ool007oo00Yoo`004Goo00<0
07ooool0>?oo:P003_oo00=oo`00000067oo0P00Aooo:`0000=oo`00Ool02Woo000AOol00`00Oooo
o`0hoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`16ool[00000goo001oo`0:Ool0015oo`03
001ooooo03SoobX000koo`9oo`03001oogoo01Ioo`03001ooooo04Koob/00003Ool007oo00Yoo`00
4Goo00<007ooool0>?oo:P003_oo0Woo00<007ooOol05Woo00<007ooool0A_oo:`0000=oo`00Ool0
2Woo000AOol00`00Ooooo`0hoolZ000>ool2Ool00`00Oomoo`0FOol00`00Ooooo`16ool[00000goo
001oo`0:Ool000]oo`8000Aoo`03001ooooo03SoobX000koo`9oo`03001oogoo015oo`8000=oo`03
001ooooo04Koob/00003Ool007oo00Yoo`002Woo00@007ooOol000=oo`03001ooooo03SoobX000ko
o`9oo`03001oogoo011oo`04001oogoo0002Ool00`00Ooooo`16ool[00000goo001oo`0:Ool000Yo
o`04001oogoo0003Ool00`00Oomoo`1aOol2000BOol01000Oomoo`000Woo0P00LWoo0P002goo000;
Ool20004Ool00`00Ool0000KOol00`00Oomoo`0IOol00`00Oomoo`0IOol00`00Oomoo`0IOol01000
Oomoo`004goo0P000goo00<007oo000077oo00<007ooOol06Goo00<007ooOol06Goo00<007ooOol0
6Goo00<007oo00002goo000:Ool01000Oomoo`000gooMP004Woo00@007ooOol0009oogH000]oo`00
2goo0P00SGoo0P00Q7oo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {136.125, 0}} -> {-0.0541876, -0.0238146, \
0.00734626, 0.00734626}, {{7.375, 137}, {132.875, 3.1875}} -> {-1.37318, \
-1.13535, 0.0711274, 0.0711274}, {{149.938, 279.625}, {132.875, 3.1875}} -> \
{-11.5155, -1.13535, 0.0711274, 0.0711274}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
imageNormalize=Compile[{{data2D,_Real,2}},
\t\tModule[{minimum=Min[data2D]},
\t\t\t(data2D-minimum)/Max[data2D-minimum]]];\
\>", "Input"],

Cell[BoxData[
    \(\(fd = Fourier[bd];\)\)], "Input"],

Cell["\<\
filterMatrix=imageNormalize[Abs[fd]]-imageNormalize[Abs[fa]];\
\>", "Input"],

Cell["defectSpect=filterMatrix fd;", "Input"],

Cell["\<\
defectPosition=imageNormalize[Abs[InverseFourier[defectSpect]]];\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Identified) show
129.000 12.813 moveto
(Defect) show
165.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000000000
0000000000000000
0000FF0000000000
FF00000000000000
0000000000000000
0000000000000000
0000FF0000000000
FF00FF0000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000FOol2
000kOol4000mOol3000iOol3000lOol2000?Ool001Eoo`04001oogoo000jOol00`00Oomoo`0oOol0
0`00Oomoo`0hOol01000Oomoo`00>Woo00@007ooOol000ioo`005Goo00@007ooOol003]oo`03001o
ogoo03]oo`D003Uoo`04001oogoo000jOol01000Oomoo`003Woo000EOol01000Oomoo`00?7oo00<0
07ooOol0>Woo00@007ooOol003Yoo`<003aoo`8000moo`005Goo00@007ooOol003Yoo`04001oogoo
000lOol00`00Ool0000kOol00`00Oomoo`0jOol01000Oomoo`003Woo000FOol2000lOol2000nOol2
000kOol3000kOol2000?Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol0019oool000D000Yoo`004Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol037oo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol027oo000BOol00`00Oomoo`3oOol1Ool00`00Oomoo`08Ool000]oo`8000Eoo`03001o
ogoo0?moo`5oo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03001o
ogoo00Qoo`002Woo00@007ooOol000Aoo`<00?ioo`<000Yoo`002Woo00@007ooOol000Aoo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`002goo0P001Goo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo0P000goonP000goo0P002Woo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol20003Oooj0003Ool2000:Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo
000BOol20003Oooj0003Ool2000:Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
2Woo100017oo00<007ooOol00WoonP0017oo00<007ooOol027oo000:Ool00`00Oomoo`05Ool00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool000]oo`03001oogoo00Aoo`<0009oooX0009oo`<000Yo
o`0037oo00<007ooOol00goo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000:Ool0
1000Oomoo`0017oo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000;Ool20005Ool0
0`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oo
oi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl0
01oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ocl001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`8000=oocl0
01oooi`000=oo`8000Yoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oo
oi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl0
01oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ocl001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oocl001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08Ool0019oo`8000=o
ocl001oooi`000=oo`8000Yoo`004Woo00<007ooOol00Woo7ooof`0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OolOoooK0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooom/000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooof`0017oo00<007ooOol027oo000BOol00`00
Oomoo`02OolOoooK0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooom/000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00Woo7ooof`0017oo00<007ooOol027oo000BOol00`00Oomoo`02
OolOoooK0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooom/000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00Woo7ooof`0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolOoooK
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooom/000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00Woo7ooof`0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolOoooK0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009ooaooom/000Aoo`03001oogoo00Qoo`004Woo0P000goo
7ooof`000goo0P002Woo000BOol00`00Oomoo`02OolOoooK0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009ooaooom/000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooof`0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02OolOoooK0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009ooaooom/000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooof`0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02OolOoooK0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaoo
om/000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooof`0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OolOoooK0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooom/000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooof`0017oo00<007ooOol027oo000<Ool30003
Ool00`00Oomoo`02OolOoooK0004Ool00`00Oomoo`08Ool000eoo`03001oogoo009oo`03001oogoo
009ooaooom/000Aoo`03001oogoo00Qoo`002Woo1@000goo0`000Woo7ooof`000Woo0`002Woo000:
Ool01000Oomoo`0017oo00<007ooOol00WoonP0017oo00<007ooOol027oo000;Ool00`00Ool00004
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool000aoo`8000Aoo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
nP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Ao
o`03001oogoo00Qoo`004Woo0P000goonP000goo0P002Woo000BOol00`00Oomoo`02Oooj0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00
Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo0P000goonP00
0goo0P002Woo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<0
07ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol2
0003Oooj0003Ool2000:Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oooX000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oooj0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oooX000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00WoonP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oooj
0004Ool00`00Oomoo`08Ool000Yoo`<000Eoo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`00
2Woo00@007ooOol000Aoo`03001oogoo009oooX000Aoo`03001oogoo00Qoo`002Woo00@007ooOol0
00Aoo`<0009oooX0009oo`<000Yoo`002Woo0`001Goo00<007ooOol00Woo?`007oooW00017oo00<0
07ooOol027oo000;Ool00`00Oomoo`04Ool00`00Oomoo`02Oolo000OoonL0004Ool00`00Oomoo`08
Ool000]oo`<000Aoo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000OoonL0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000OoonL0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000OoonL
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000O
oonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qo
o`004Woo0P000goo?`007oooW0000goo0P002Woo000BOol00`00Oomoo`02Oolo000OoonL0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000OoonL0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000OoonL
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000O
oonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo
000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooi`000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00Woo?`007oooW00017oo00<007ooOol027oo000BOol20003OolOoolP
000OoonL0003Ool2000:Ool0019oo`03001oogoo009ooaooob0001oooi`000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00Woo7ooo80007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02
OolOoolP000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooob0001oooi`000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooo80007oooW00017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OolOoolP000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaoo
ob0001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooo80007oooW00017oo00<0
07ooOol027oo000BOol00`00Oomoo`02OolOoolP000OoonL0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009ooaooob0001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooo8000
7oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02OolOoolP000OoonL0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009ooaooob0001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00Woo7ooo80007oooW00017oo00<007ooOol027oo000BOol20003OolOoolP000OoonL0003Ool2
000:Ool0019oo`03001oogoo009ooaooob0001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00Woo7ooo80007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02OolOoolP000OoonL
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooob0001oooi`000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00Woo7ooo80007oooW00017oo00<007ooOol027oo000BOol00`00Oomoo`02
OolOoolP000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaooob0001oooi`000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooo80007oooW00017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OolOoolP000OoonL0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooaoo
ob0001oooi`000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7ooo80007oooW00017oo00<0
07ooOol027oo000BOol00`00Oomoo`02OolOoolP000OoonL0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009ooaooob0001oooi`000Aoo`03001oogoo00Qoo`002goo0P001Goo00<007ooOol00Woo
7ooo80007oooW00017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo00<007ooOol00Woo7ooo
80007oooW00017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo0`00oWoo0`002Woo000;Ool2
0005Ool00`00Oomoo`3oOol1Ool00`00Oomoo`08Ool000Yoo`04001oogoo0004Ool00`00Oomoo`3o
Ool1Ool00`00Oomoo`08Ool000]oo`8000Eoo`03001oogoo009oo`03001oogoo03]oo`03001oogoo
03aoo`03001oogoo03]oo`03001oogoo03]oo`03001oogoo009oo`03001oogoo00Qoo`004Woo00<0
07ooOol00Woo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<0
07ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol037oo00<0
07ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<0
07ooOol037oo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol027oo000BOooo0005000:Ool0
0?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00Hgoo
0`000goo10000Woo0`0000=oo`0000000Woo0P000Woo0P0017oo0`000Woo10000goo0`000goo0`00
0goo10001Woo100017oo0`000Woo10000goo0`000goo0`000goo0P00Fgoo001TOol01@00Oomoogoo
00000Woo00@007ooOol000Eoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo00<0
07ooOol017oo00D007ooOomoo`0000Eoo`04001oogoo0008Ool01000Oomoo`000Woo00<007ooOol0
17oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00goo00@007ooOol005Yoo`00I7oo00D0
07ooOomoo`00009oo`03001oogoo00@0009oo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Oomo
o`02Ool00`00Oomoo`04Ool01000Oomoogoo10000Woo00@007ooOol000Qoo`04001oogoo0002Ool4
0003Ool00`00Oomoo`02Ool40002Ool00`00Oomoo`03Ool00`00Oomoo`1KOol006Aoo`03001oogoo
009oo`<000=oo`80009oo`@0009oo`D000=oo`8000=oo`@000=oo`8000Aoo`8000Aoo`<000Qoo`04
001oogoo0003Ool20003Ool40003Ool20004Ool300000goo00000003001JOol006Aoo`03001oogoo
00Aoo`03001oogoo00aoo`03001oogoo00Yoo`03001oogoo015oo`03001oogoo00Ioo`04001oogoo
0009Ool00`00Oomoo`0>Ool00`00Oomoo`1KOol006=oo`<000Aoo`8001Ioo`03001oogoo00=oo`80
00Aoo`03001oogoo00Uoo`8000Moo`@000]oo`8006aoo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.756806, -0.5532, 0.0321285, \
0.0321285}}]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wd = waveletMatrix[8, coif6] . bd;\)\)], "Input"],

Cell["filterMatrix=imageNormalize[wd]-imageNormalize[wa];", "Input"],

Cell["defectSpect=filterMatrix wd;", "Input"],

Cell["\<\
defectPosition=imageNormalize[Transpose[waveletMatrix[8,coif6]].defectSpect];\
\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Identified) show
129.000 12.813 moveto
(Defect) show
165.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
00FF0000FF000000
00000000FF000000
00000000FF00FF00
00000000FF000000
00FF0000FF00FF00
00000000FF00FF00
0000FF00FF00FF00
00000000FF000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000FOol2
000kOol4000mOol3000iOol3000lOol2000?Ool001Eoo`04001oogoo000jOol00`00Oomoo`0oOol0
0`00Oomoo`0hOol01000Oomoo`00>Woo00@007ooOol000ioo`005Goo00@007ooOol003]oo`03001o
ogoo03]oo`D003Uoo`04001oogoo000jOol01000Oomoo`003Woo000EOol01000Oomoo`00?7oo00<0
07ooOol0>Woo00@007ooOol003Yoo`<003aoo`8000moo`005Goo00@007ooOol003Yoo`04001oogoo
000lOol00`00Ool0000kOol00`00Oomoo`0jOol01000Oomoo`003Woo000FOol2000lOol2000nOol2
000kOol3000kOol2000?Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003o
OolQOol0019oool000D000Yoo`004Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol037oo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo
00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol00Woo
00<007ooOol027oo000BOol00`00Oomoo`3oOol1Ool00`00Oomoo`08Ool000]oo`8000Eoo`03001o
ogoo0?moo`5oo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03001o
ogoo00Qoo`002Woo00@007ooOol000Aoo`<00?ioo`<000Yoo`002Woo00@007ooOol000Aoo`03001o
ogoo009ooal0023ooch001oooeh000Aoo`03001oogoo00Qoo`002Woo00@007ooOol000Aoo`03001o
ogoo009ooal0023ooch001oooeh000Aoo`03001oogoo00Qoo`002goo0P001Goo00<007ooOol00Woo
7`008?oo?P007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolO000Pooln000OoomN
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001oooeh000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007oooGP0017oo00<007ooOol027oo000BOol00`00
Oomoo`02OolO000Pooln000OoomN0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023o
och001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007oooGP0017oo
00<007ooOol027oo000BOol00`00Oomoo`02OolO000Pooln000OoomN0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009ooal0023ooch001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0Woo7`008?oo?P007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolO000Pooln000O
oomN0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001oooeh000Aoo`03001o
ogoo00Qoo`004Woo0P000goo7`008?oo?P007oooGP000goo0P002Woo000BOol00`00Oomoo`02OolO
000Pooln000OoomN0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001oooeh0
00Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007oooGP0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02OolO000Pooln000OoomN0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009ooal0023ooch001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7`008?oo
?P007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolO000Pooln000OoomN0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001oooeh000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00Woo7`008?oo?P007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02
OolO000Pooln000OoomN0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001oo
oeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007oooGP0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02OolO000Pooln000OoomN0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009ooal0023ooch001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7`00
8?oo?P007oooGP0017oo00<007ooOol027oo000BOol20003OolO000Pooln000OoomN0003Ool2000:
Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
O@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol20003Oomm000OoomN0003Ool2
000:Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`00
2Woo100017oo00<007ooOol00WooO@007oooGP0017oo00<007ooOol027oo000:Ool00`00Oomoo`05
Ool00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomoo`08Ool000]oo`03001oogoo00Aoo`<0009o
ogd001oooeh0009oo`<000Yoo`0037oo00<007ooOol00goo00<007ooOol00WooO@007ooo80007ooo
7`0017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo00<007ooOol00WooO@007ooo80007ooo
7`0017oo00<007ooOol027oo000;Ool20005Ool00`00Oomoo`02Oomm000OoolP000OoolO0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oo
oal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@00
7ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`8000=oogd001ooob0001oooal0
00=oo`8000Yoo`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009o
ogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo80007ooo
7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000O
oolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo8000
7ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00
Oomoo`08Ool0019oo`8000=oogd001ooob0001oooal000=oo`8000Yoo`004Woo00<007ooOol00Woo
O@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`00
4Woo0P000gooO@007oooGP000goo0P002Woo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WooO@007oooGP0017oo00<007ooOol027oo000<Ool30003Ool00`00Oomoo`02
Oomm000OoomN0004Ool00`00Oomoo`08Ool000eoo`03001oogoo009oo`03001oogoo009oogd001oo
oeh000Aoo`03001oogoo00Qoo`002Woo1@000goo0`000WooO@007oooGP000Woo0`002Woo000:Ool0
1000Oomoo`0017oo00<007ooOol00Woo7`008?oo?P007ooo80007ooo7`0017oo00<007ooOol027oo
000;Ool00`00Ool00004Ool00`00Oomoo`02OolO000Pooln000OoolP000OoolO0004Ool00`00Oomo
o`08Ool000aoo`8000Aoo`03001oogoo009ooal0023ooch001ooob0001oooal000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007ooo80007ooo7`0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OolO000Pooln000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009ooal0023ooch001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
7`008?oo?P007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolO000Pooln
000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001ooob00
01oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007ooo80007ooo7`00
17oo00<007ooOol027oo000BOol00`00Oomoo`02OolO000Pooln000OoolP000OoolO0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001ooob0001oooal000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00Woo7`008?oo?P007ooo80007ooo7`0017oo00<007ooOol027oo000BOol0
0`00Oomoo`02OolO000Pooln000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009ooal0023ooch001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo0P000goo7`008?oo?P00
7ooo80007ooo7`000goo0P002Woo000BOol00`00Oomoo`02OolO000Pooln000OoolP000OoolO0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001ooob0001oooal000Aoo`03001o
ogoo00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007ooo80007ooo7`0017oo00<007ooOol027oo
000BOol00`00Oomoo`02OolO000Pooln000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009ooal0023ooch001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0Woo7`008?oo?P007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolO000P
ooln000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001oo
ob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007ooo80007ooo
7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02OolO000Pooln000OoolP000OoolO0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009ooal0023ooch001ooob0001oooal000Aoo`03001oogoo
00Qoo`004Woo00<007ooOol00Woo7`008?oo?P007ooo80007ooo7`0017oo00<007ooOol027oo000B
Ool00`00Oomoo`02OolO000Pooln000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001o
ogoo009ooal0023ooch001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo0P000goo7`008?oo
?P007ooo80007ooo7`000goo0P002Woo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool0
0`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`00
4Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oo
oal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03
001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@00
7ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004
Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qo
o`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob00
01oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<0
07ooOol027oo000BOol20003Oomm000OoolP000OoolO0003Ool2000:Ool0019oo`03001oogoo009o
ogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo80007ooo
7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000O
oolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oogd001ooob0001oooal000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo80007ooo7`0017oo00<007ooOol027oo
000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo
009oogd001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo8000
7ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoolP000OoolO0004Ool00`00
Oomoo`08Ool000Yoo`<000Eoo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qo
o`002Woo00@007ooOol000Aoo`03001oogoo009oogd001ooob0001oooal000Aoo`03001oogoo00Qo
o`002Woo00@007ooOol000Aoo`<0009oogd001ooob0001oooal0009oo`<000Yoo`002Woo0`001Goo
00<007ooOol00Woo?`007ooo7`007ooo80007ooo7`0017oo00<007ooOol027oo000;Ool00`00Oomo
o`04Ool00`00Oomoo`02Oolo000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08Ool000]oo`<0
00Aoo`03001oogoo009oocl001oooal001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00Woo?`007ooo7`007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oolo000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oo
oal001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007ooo7`007ooo
80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000OoolO000OoolP000OoolO
0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooal001ooob0001oooal000Aoo`03
001oogoo00Qoo`004Woo00<007ooOol00Woo?`007ooo7`007ooo80007ooo7`0017oo00<007ooOol0
27oo000BOol00`00Oomoo`02Oolo000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oocl001oooal001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007oo
Ool00Woo?`007ooo7`007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo
000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooal0
01ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo0P000goo?`007ooo7`007ooo80007ooo7`00
0goo0P002Woo000BOol00`00Oomoo`02Oolo000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oocl001oooal001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo
00<007ooOol00Woo?`007ooo7`007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomo
o`02Oolo000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl0
01oooal001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007ooo7`00
7ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oolo000OoolO000OoolP000O
oolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oooal001ooob0001oooal000Ao
o`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007ooo7`007ooo80007ooo7`0017oo00<007oo
Ool027oo000BOol00`00Oomoo`02Oolo000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oocl001oooal001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<0
07ooOol00Woo?`007ooo7`007ooo80007ooo7`0017oo00<007ooOol027oo000BOol00`00Oomoo`02
Oolo000OoolO000OoolP000OoolO0004Ool00`00Oomoo`08Ool0019oo`03001oogoo009oocl001oo
oal001ooob0001oooal000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo?`007ooo7`007ooo
80007ooo7`0017oo00<007ooOol027oo000BOol20003Oomm000OoomN0003Ool2000:Ool0019oo`03
001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007oooGP00
17oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomoo`08Ool0019o
o`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo
GP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@00
7oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
O@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WooO@007oooGP0017oo00<007ooOol027oo000BOol20003Oomm000OoomN0003Ool2000:Ool0019o
o`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@007ooo
GP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomoo`08Ool0
019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00WooO@00
7oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomoo`08
Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol00Woo
O@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00Oomo
o`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`004Woo00<007ooOol0
0WooO@007oooGP0017oo00<007ooOol027oo000BOol00`00Oomoo`02Oomm000OoomN0004Ool00`00
Oomoo`08Ool0019oo`03001oogoo009oogd001oooeh000Aoo`03001oogoo00Qoo`002goo0P001Goo
00<007ooOol00WooO@007oooGP0017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo00<007oo
Ool00WooO@007oooGP0017oo00<007ooOol027oo000:Ool01000Oomoo`0017oo0`00oWoo0`002Woo
000;Ool20005Ool00`00Oomoo`3oOol1Ool00`00Oomoo`08Ool000Yoo`04001oogoo0004Ool00`00
Oomoo`3oOol1Ool00`00Oomoo`08Ool000]oo`8000Eoo`03001oogoo009oo`03001oogoo03]oo`03
001oogoo03aoo`03001oogoo03]oo`03001oogoo03]oo`03001oogoo009oo`03001oogoo00Qoo`00
4Woo00<007ooOol00Woo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol03Goo00<007ooOol0
37oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol037oo00<007ooOol0
3Goo00<007ooOol037oo00<007ooOol03Goo00<007ooOol00Woo00<007ooOol027oo000BOooo0005
000:Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00Hgoo0`000goo10000Woo0`0000=oo`0000000Woo0P000Woo0P0017oo0`000Woo10000goo0`00
0goo0`000goo10001Woo100017oo0`000Woo10000goo0`000goo0`000goo0P00Fgoo001TOol01@00
Oomoogoo00000Woo00@007ooOol000Eoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0
0Woo00<007ooOol017oo00D007ooOomoo`0000Eoo`04001oogoo0008Ool01000Oomoo`000Woo00<0
07ooOol017oo00<007ooOol00Woo00<007ooOol00goo00<007ooOol00goo00@007ooOol005Yoo`00
I7oo00D007ooOomoo`00009oo`03001oogoo00@0009oo`04001oogoo0002Ool00`00Oomoo`05Ool0
0`00Oomoo`02Ool00`00Oomoo`04Ool01000Oomoogoo10000Woo00@007ooOol000Qoo`04001oogoo
0002Ool40003Ool00`00Oomoo`02Ool40002Ool00`00Oomoo`03Ool00`00Oomoo`1KOol006Aoo`03
001oogoo009oo`<000=oo`80009oo`@0009oo`D000=oo`8000=oo`@000=oo`8000Aoo`8000Aoo`<0
00Qoo`04001oogoo0003Ool20003Ool40003Ool20004Ool300000goo00000003001JOol006Aoo`03
001oogoo00Aoo`03001oogoo00aoo`03001oogoo00Yoo`03001oogoo015oo`03001oogoo00Ioo`04
001oogoo0009Ool00`00Oomoo`0>Ool00`00Oomoo`1KOol006=oo`<000Aoo`8001Ioo`03001oogoo
00=oo`8000Aoo`03001oogoo00Uoo`8000Moo`@000]oo`8006aoo`00ogoo8Goo003oOolQOol00001
\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.756806, -0.5532, 0.0321285, \
0.0321285}}]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Photo\ Example\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00WooB3F]13W>1SF]23W>0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa
0T8@0THa0SW>1Goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol00WooB3F]13W>1SF]23W>
0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa0T8@0THa0SW>1Goo0@000Goo000>Ool20005
Ool00`00Oomoo`02OomB=Jd6>Lh4=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl8>Li<?Nl6@Q02?Nl2
<H`28@P5Ool10001Ool001Eoo`03001oogoo009ooe8e[@HicP@e[@8aS08e[A`icP8mk`TicP@e[A0i
cP@mk`PicT`mk`I2408mk`8aS08Q20Eoo`40005oo`005Goo00<007ooOol00WooDSF]13W>13F]136<
0SF]73W>0Sg_2CW>13F]43W>1Sg_13W>33g_1SW><3g_148@13g_248@0SF]0Re[0QS60PaS1Goo0@00
0Goo000EOol00`00Oomoo`02OomB=Jd4>Lh4=Jd4<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh6?Nl4>Lh<?Nl6
>Lh`?Nl4@Q04?Nl8@Q02=Jd2;F/26<H236<5Ool10001Ool001Eoo`03001oogoo009ooc`e[@8icPPe
[@8icPXe[@@icP@e[@8aS0@e[A`icP8mk`<icP8mk`8icP@aS08e[@@mk`PicQ@mk`8icRPmk`A2408m
k`A240Hmk`A2408mk`8icP8mk`A6<@8mk`8aS08Li`8@Q0@000Eoo`40005oo`005Goo00<007ooOol0
0Woo?3F]0SW>23F]0SW>2SF]13W>13F]0S6<13F]73W>0Sg_0cW>0Sg_0SW>136<0SF]13g_23W>53g_
0SW>:3g_148@0Sg_148@1Sg_148@0Sg_0SW>0Sg_14Ha0Sg_0S6<0QcW0Q2410001Goo0@000Goo000E
Ool00`00Oomoo`02Ool2>Lhf=Jd6>Lh6=Jd6>Lh6=Jd6>Lh4=Jd2<H`2=JdN>Lh2?Nl3>Lh2?Nl2>Lh4
<H`2>Li6?Nl:@Q02?Nl6@Q08?Nl2@Q02AS42@Q02=Jd29BT25:D2248212440005Ool10001Ool001Eo
o`8000=oo`8icSHe[@HicPHe[@HicPHe[@HicP@e[@8aS08e[AhicP8mk`<icP8mk`8icP@aS08icTHm
k`Y2408mk`I240Pmk`924096<@92408e[@8U:@8DY@88@P848@@000Aoo`80005oo`005Goo00<007oo
Ool00Woo33W>83F]53W>0SF]23W>13F]1SW>23F]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Sg_148@3Sg_1T8@13g_448@0Sg_448@0SW>0Re[0QcW0PaS2P001Goo0@000Goo000EOol00`00
Oomoo`02Ool<>LhP=JdD>Lh2=Jd8>Lh4=Jd6>Lh8=Jd>>Lh2=Jd@>Lh2?Nl00cW>?Nlmk`02?Nl2=Jd2
<H`2=JdV?Nl4@Q0>?Nl6@Q04?Nl@@Q02?Nl@@Q02>Lh2;F/27>L236<:0005Ool10001Ool001Eoo`03
001oogoo009ooaXicP8e[@@icPPe[A0icP@e[@@icP8e[@HicPHe[@HicPPe[A`icP@mk`8icP<mk`8i
cP8e[@8aS08e[B@mk`Q240`mk`Q2408mkaA240@mk`9240A6<@92408e[@8U:@8@Q0848@`000Eoo`40
005oo`005Goo00<007ooOol00Woo6SW>0SF]13W>23F]43W>13F]13W>0SF]1SW>1SF]1SW>23F]73W>
13g_0SW>0cg_0SW>0SF]0S6<0SF]93g_248@33g_248@0Sg_548@13g_0T8@14Ha0T8@0SF]0RDY0Q24
0P@Q30001Goo0@000Goo000EOol00`00Oomoo`02Oom0>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd:>Lh4
?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhP?Nl2@Q02?Nl6@Q0>?NlN@Q02?Nl2@Q04AS42?Nl2<H`28@P2
48@2124>0005Ool10001Ool001Eoo`03001oogoo009ood0icP@e[@HicP8e[@PicP8e[@8aS08e[@Xi
cP@mk``icPPmk`8icP<mk`8icP@e[@8icR0mk`92408mk`I240hmkai2408mk`9240A6<@8mk`8aS08Q
208@Q0848@h000Eoo`40005oo`005Goo00<007ooOol00Woo6SW>0SF]>3W>13F]2SW>3Sg_13W>2cg_
0SW>13F]0SW>83g_148@0Sg_1T8@23g_648@0Sg_2T8@1THa0SW>0RU:0QS60PaS0P@Q40001Goo0@00
0Goo000EOol00`00Oomoo`02OolJ>Lh2=Jdh>Lh4=Jd:>Lh>?Nl4>Lh;?Nl2>Lh4=Jd2>LhP?Nl4@Q02
?Nl6@Q08?NlH@Q02?Nl:@Q06AS42>Lh2:DX26<H236<2124@0005Ool10001Ool001Eoo`03001oogoo
009oo`8mke0icPHe[@8icP8mk`@icQlmk`@e[@8icQXmk`a2408mk`I240Hmkb9240I6<@8mk`8e[@8U
:@8@Q0848@h000848@@000Eoo`40005oo`005Goo0P000goo0Sg_D3W>1SF]0SW>0Sg_13W>7cg_13F]
0SW>6Sg_348@0Sg_1T8@1Sg_8T8@1THa0Sg_0SF]0RDY0Q240P@Q3P000P@Q100017oo0P000Goo000E
Ool00`00Oomoo`02OolL?Nlf>Lh6=Jd2>Lh2?Nl4>Lh4?Nl4>LhF?Nl00cW>=Jde[@02<H`2>Lh4@Q04
>Lh>?Nl:@Q02?NlJ@Q08AS42@Q04AS48@Q04AS42BU82AS42@Q02<H`27>L236<21242000212440004
124:0005Ool10001Ool001Eoo`03001oogoo009ooa`mkcHicPHe[@8icP8mk`@icP@mk`@icQHmk`03
>Lhe[CF]008aS08icPA240@icPhmk`Y2408mkaY240Q6<@9240A6<@Q240A6<@9:DP96<@92408aS08L
i`8<H`848@8000848@@000@48@X000Eoo`40005oo`005Goo00<007ooOol00Woo63g_23W>23g_13W>
63g_23W>0Sg_0SW>1SF]13W>6Sg_13W>1Sg_00<icSF]=Jd00SF]0SW>1Sg_0SW>13g_6T8@13g_848@
14Ha0Sg_0T8@1THa0SW>0Re[0QcW0PaS0P@Q0P000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolH?Nl8>Lh8?Nl4>LhH?Nl8>Lh2?Nl2>Lh6=Jd4>LhJ?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2
>Lh4?NlJ@Q04?NlP@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124D0005Ool10001Ool0
01Eoo`03001oogoo009ooa`mk`@icPPmk`@icP`mk`@icPhmk`8icP8mk`8icP@e[@@icRHmk`03>Lhe
[CF]008icP8mk`9240hmkca240Q6<@8mk`8aS08U:@8DY@88@P848@@000848A@000Eoo`40005oo`00
5Goo00<007ooOol00Woo73g_13W>23g_13W>33g_13W>3Sg_0SW>0Sg_0SW>13F]13W>9Sg_00<icSF]
=Jd00SW>0Sg_0T8@3Sg_?48@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q50001Goo0@000Goo000E
Ool00`00Oomoo`02Ool<?Nl4@Q02?Nl6@Q0f?Nl8>LhV?Nl5>Lh4?Nl4@Q02?Nl4@Q08?NlZ@Q02AS48
@Q02AS44@Q02AS42BU82AS42>Lh2;F/26<H248@212480002124D0005Ool10001Ool001Eoo`03001o
ogoo009oo``mk`A2408mk`I243Hmk`PicRHmk`DicP@mk`A2408mk`A240PmkbY24096<@Q24096<@A2
4096<@9:DP96<@8icP8]J`8HaP8@Q0848@P000848A@000Eoo`40005oo`005Goo00<007ooOol00Woo
448@0Sg_1T8@13g_148@;Sg_1SW>:3g_0SW>1Cg_348@23g_=48@0THa0T8@0THa0TYB0THa0SW>0RU:
0QS60PQ20P@Q100010@Q60001Goo0@000Goo000EOol20003Ool@@Q02?Nl6@Q04?Nl4@Q0^?Nl6>LhX
?Nl2>Lh5?Nl<@Q08?Nld@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124H0004Ool2
0001Ool001Eoo`03001oogoo009ooaY2408mk`I2408mkaQ2410mk`PicP8mk`92410mk`A241<mk`A2
40@mkdI24096<@A:DP8icP8YBP8HaP8<H`H000@48AX000Eoo`40005oo`005Goo00<007ooOol00Woo
6T8@0Sg_1T8@0Sg_648@43g_23W>0Sg_0T8@43g_148@4cg_148@13g_AT8@0THa14YB0SW>0RU:0QS6
0PaS1P0010@Q6P001Goo0@000Goo000EOol00`00Oomoo`02Ool2AS46@Q04AS4d@Q0<?Nl6>Lh4?Nl2
@Q0B?Nl2@Q04?Nl2@Q0:?Nl7@Q04?NlJ@Q0:AS4D@Q02AS48@Q06AS42BU82?Nl29BT25:D2248V0005
Ool10001Ool001Eoo`03001oogoo009oo`96<@I240A6<CA240`mk`HicP@mk`92418mk`9240@mk`92
40Xmk`M240@mkaY240Y6<AA24096<@Q240I6<@9:DP8mk`8U:@8DY@88@RH000Eoo`40005oo`005Goo
00<007ooOol00Woo6THa<T8@23g_248@33g_2T8@2Sg_5D8@14Ha2T8@24Ha4T8@0THa0T8@1THa148@
14Ha0TYB0THa0SW>0RDY0Q2410@Q0P000P@Q30000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolJAS4b@Q08?Nl8@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q08AS4B@Q02AS42@Q06AS44@Q04AS42BU82AS42
>Lh29BT248@412420002124<0002124D0005Ool10001Ool001Eoo`03001oogoo009ooaY6<@Q240Y6
<B1240@mkb9240@mk`8icP@mk`m240Y6<@Y240I6<A1240I6<@9240a6<@A:DP8icP8U:@8DY@P48@H0
00@48AH000@48@Eoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Woo6THa248@2THa848@
13g_8T8@13g_0SW>13g_3d8@2THa2T8@1THa448@1THa0T8@34Ha14YB0SW>0RDY0QBU20@Q1P0010@Q
5P0010@Q1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Woo0TYB
;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa148@0THa1T8@34Ha148@
0THa14YB0THa0SW>0RU:0Q240PQ220@Q90001Goo0@000Goo0008Ool00`00Oomoo`02Ool01000Oomo
o`0017oo0P000goo0TYB;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa
148@0THa1T8@34Ha148@0THa14YB0THa0SW>0RU:0Q240PQ220@Q900017oo0P000Goo0009Ool01@00
Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo34YB24Ha1TYB6THa248@0THa148@0Sg_
13W>0Sg_148@14Ha148@0THa248@14Ha1T8@0THa3T8@0THa8d8@24Ha148@5THa0T8@14Ha0T8@0SF]
0RDY0QBU0PQ2:0000P@Q10001Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03
001oogoo009oo`a:DPQ6<@I:DQY6<@Q24096<@A2408mk`@icP8mk`A240A6<@A24096<@Q240A6<@I2
4096<@i24096<B=240Q6<@A241I6<@9240A6<@92408e[@8U:@8DY@88@RP000848@@000Eoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol00Woo94YB6THa0T8@0Sg_0SW>0S6<0Re[0SF]0T8@0TYB
0Tic34Ha148@1THa148@0THa2T8@5DHa148@=4Ha0TYB0THa0SF]0RDY0Q240PQ230000P@Q30000P@Q
300020@Q1Goo0@000Goo000EOol00`00Oomoo`02OolTBU8JAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02
BU82CW<<AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0dAS42BU82AS42=Jd29BT248@2248<0002124<0002
124<00081245Ool10001Ool001Eoo`03001oogoo009oo`i:DPI>L`Q:DPA6<Ai:DPA6<@8mk`8e[@8a
S08mk`9:DPABU09>L`A240Q6<@A24096<@9:DPQ6<@Q240A6<@924456<@I:DP96<@8icP8YBP8HaP88
@P848@8000h48@P000X48@@000X48@Eoo`40005oo`005Goo00<007ooOol00Woo3TYB1Tic24YB14Ha
7TYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@24Ha148@0THa0TYB24Ha248@14Ha0T8@@DHa1TYB
0THa0SW>0RU:0QS60PQ20P@Q0P003P@Q20002P@Q10002P@Q1Goo0@000Goo000EOol00`00Oomoo`02
Ool4CW<8BU86CW<8BU82CW<2AS44BU88CW<2BU86AS44@Q06AS48BU82AS42@Q02BU82E[D2F]H2IcT2
G_L2CW<2@Q0<AS44BU82AS42@Q04AS46@Q0cAS44BU8BAS44BU82AS42?Nl2:DX26<H236<212440004
12460002124:000H1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`Q:DPI>L`Q:DP9>L`96<@A:
DPQ>L`9:DPI6<@A240I6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240a6<@A:DP96<@9240A6
<@I243=6<@A:DQ96<@A:DP96<@8mk`8YBP8HaP8<H`848@@000@48@H000848@X001P48@Eoo`40005o
o`005Goo00<007ooOol00Woo24ic24YB34ic0U:D1Tic0TYB0THa0T8@0Sg_1SF]136<1SF]0SW>13g_
1T8@0Tic0U[F0V<H0Vmk0VLi0UJe0TYB1THa1TYB0THa13g_0T8@0THa0TYB24Ha0TYB<DHa2TYB2THa
14YB0T8@0S6<0QcW0PaS0P@Q700060@Q1Goo0@000Goo000EOol20003Ool8CW<8BU8<CW<2DY@6CW<2
BU82AS42@Q02?Nl6=Jd4<H`6=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2IcT2E[D2BU86AS46BU82AS44
?Nl2@Q02AS42BU88AS42BU8aAS4:BU8:AS44BU82@Q02<H`27>L236<2124L000H1244Ool20001Ool0
01Eoo`03001oogoo009ooaY>L`9:DP9>L`9:DP96<@92408icP8e[@8aS0@]J`HYBP`U:@@YBP8]J`8m
k`9BU09S60AW>@9JeP9>L`9:DPA6<@9>L`ABU096<@8icP8e[@8icP924096<@A:DPA6<@I:DS56<@Q:
DPI6<@I:DP92408e[@8Q208@Q0848@@000`48@h001P48@Eoo`40005oo`005Goo00<007ooOol00Woo
6Tic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:32DY12U:0Re[0Sg_0U:D0V<H16Li0U[F0Tic
0TYB14Ha0Tic15:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha1TYB<DHa24YB1THa1TYB0T8@0SF]0R48
0Q240P@Q100030@Q3P0060@Q1Goo0@000Goo000EOol00`00Oomoo`02OolBCW<4DY@2CW<2BU82AS44
?Nl2=Jd2<H`2;F/>:DX49BT28@P27>L86<H28@P2>Lh2F]H2Kg/2Li`2IcT2E[D6DY@2F]H2IcT2HaP2
E[D2@Q04<H`2@Q02BU82AS4<BU8GAS4BBU8>AS44BU84AS46BU82AS42>Lh29BT25:D2248412420006
12420002124D000D1245Ool10001Ool001Eoo`03001oogoo009ooa9>L`ABU09>L`9:DP96<@@mk`8e
[@8aS08]J`hYBP@U:@8Q208Li`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP9W>@9S609F]@92
40@aS092409:DP96<@a:DQM6<A9:DPi6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P@48@8000H48@80
00848A@001@48@Eoo`40005oo`005Goo00<007ooOol00Woo34ic15:D14ic0TYB0T8@0Sg_0SW>0S6<
32e[12U:1Re[12U:12DY1R480RU:0SW>0Tic0VLi0W>L0V]J0UJe0TYB0U:D0U[F0Ukg0V<H0VLi0Ukg
0U:D0T8@0Sg_0T8@14YB0Tic3TYB5DHa34YB1THa1TYB14Ha1TYB14Ha1TYB0THa0SW>0RDY0QBU0PQ2
100020@Q2P001P@Q10006P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<CW<4DY@4CW<2BU82@Q02
?Nl2>Lh2<H`<;F/4:DX6;F/4:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2
HaP2IcT2G_L2DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS46BU84AS46BU84AS46BU82AS42>Lh2
9BT25:D224840008124:00061244000J1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`YBU09>
L`96<@8mk`8e[@@aS08]J`8aS0P]J`8aS0@]J`XaS08]J`PaS08e[@92409F]@9W>@A_N`9JeP96<@8m
k`9:DP9JeP9Nm`9JeP9F]@Q:DPA>Ld5:DPA6<@a:DP96<@8icP8]J`8HaP8<H`848@@000H48@X000P4
8@@001X48@Eoo`40005oo`005Goo00<007ooOol00Woo14ic2U:D0Tic0THa0Sg_0SF]136<0Re[0S6<
22e[0S6<12e[2S6<0Re[236<0SF]0T8@0UJe0VLi16mk0U[F0THa0Sg_0TYB0U[F0Ukg0U[F0UJe24YB
14ic@DYB14Ha34YB0THa0SW>0Re[0QS60PaS0P@Q10001P@Q2P0020@Q10006P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool8DY@4CW<2AS42?Nl2=Jd2;F/4:DX4;F/:<H`8=Jd<>Lh6?Nl2AS42E[D2HaP2
Kg/2JeX2IcT2CW<2?Nl2=Jd2>Lh2AS44BU82CW<2BU8<CW<IBU88CW<ZBU82CW<2AS42?Nl2;F/27>L2
36<>1248000:1244000J1245Ool10001Ool001Eoo`8000=oo`QBU0A>L`96<@8mk`8e[@8]J`@YBP@]
J`XaS0Pe[@`icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP9>L`9:DPa>LaU:
DPQ>LbY:DP9>L`96<@8mk`8]J`8Li`8<H`h48@P000X48@@001X48@Aoo`80005oo`005Goo00<007oo
Ool00Woo15:D0Tic0TYB0T8@0Sg_136<22e[2S6<13F]1SW>1Sg_1T8@1THa0TYB0Tic0U:D0UJe0U[F
0Ukg0V<H0U:D0THa0SW>1SF]0T8@0Tic15:D0Tic1TYB0Tic0U:D34ic>DYB0THa14YB0T8@0S6<0R48
0QBU2P@Q3P00:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@2CW<2BU82@Q02?Nl4<H`8;F/:
<H`4=Jd6>Lh6?Nl6@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42>Lh6=Jd2@Q02CW<4DY@2
CW<6BU82CW<2DY@<CW<iBU82AS44BU82@Q02<H`28@P25:D:124>000X1245Ool10001Ool001Eoo`03
001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`haS0@e[@8icPHmk`Q240A6<@A:DP9>L`IBU09>L`9B
U09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`96<BE>LaQ:DP9>L`Y:DPA>L`a:DP96<@8e[@8U:@8@
Q088@P848A@002X48@Eoo`40005oo`005Goo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3S6<
13F]0SW>1Sg_248@14Ha14YB0Tic1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_0THa
9Dic64YB0Tic2TYB14ic34YB0THa0SF]0RDY0Q240PQ20P@Q5000:P@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl2=Jd2<H`6;F/B<H`2=Jd4>Lh4?Nl4@Q08AS44BU84CW<6DY@:E[D6DY@2CW<2BU82
@Q02?Nl2>Lh2BU82CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU86CW<2BU82AS42BU86CW<2?Nl2:DX26<H2
24821244000212440002124800081242000R1245Ool10001Ool001Eoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja8aS08e[@@icP@mk`A240Q6<@A:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`8icP9:DP9>
L`9BU09F]@ABU1e>La1:DPY>L`A:DPI>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@000848@@0
00848@P000P48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<1Re[3S6<13F]0SW>0SF]
0SW>13g_148@14Ha24YB1Tic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@0Sg_0THa0TYB1U:D
>Dic14YB1Tic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P0030@Q1P002P@Q0P008P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`6;F/><H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04AS48BU86CW<8DY@2E[D2F]H4
E[D2DY@4E[D2DY@4CW<2BU82@Q02?Nl2AS42BU86DY@iCW<4BU86CW<6BU84CW<2AS42<H`27>L236<2
1242000<1246000:1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]Ja8aS08e[@@icP8m
k`A240A6<@Q:DPA>L`QBU0iF]@QJeP9F]@ABU09:DP96<@8mk`96<@9>L`YBU1m>L`9BU1A>L`A:DP9>
L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@48@@000848@H000X48@8002848@Eoo`40005oo`00
5Goo0P000goo1Re[4S6<0SF]13W>0Sg_148@14Ha24YB14ic25:D3UJe25[F0UJe15:D0TYB0THa0Sg_
0THa0Tic2U:D7dic0U:D54ic14YB0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q10000P@Q
1P002P@Q0P008P@Q17oo0P000Goo000EOol00`00Oomoo`02Ool6;F/><H`2=Jd4>Lh4?Nl4@Q04AS44
BU88CW<4DY@:E[D@F]H8E[D4DY@2AS42@Q02AS42CW<8DY@6CW<:DY@YCW<2BU88CW<2BU82?Nl2;F/2
6<H22486000L1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]J`haS08e[@@icP@mk`A2
40A6<@A:DPQ>L`ABU0YF]A1JePQF]@ABU096<@924096<@9>L`QBU0I>L`YBU2U>L`9:DPQ>L`9:DP8m
k`8]J`8HaP88@PH001`48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo336<1SF]13W>13g_
148@14Ha1TYB1Tic1U:D25Je65[F15Je15:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Tic
0U:D0Tic0THa0S6<0R480Q240P@Q1P0070@Q0P008P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<
<H`6=Jd4>Lh4?Nl4@Q04AS46BU86CW<6DY@8E[DHF]H4E[D4DY@2BU82AS42@Q02BU82CW<6DY@4CW<<
DY@?CW<2DY@NCW<2DY@2CW<2AS42<H`28@P248@21246000L1242000R1245Ool10001Ool001Eoo`03
001oogoo009oo`PaS0Pe[@8icPHmk`A24096<@A:DPI>L`QBU0IF]AIJePINm`AJePIF]@9BU09:DPA2
409:DPAF]@iBU0A>L`]BU0A>L`IBU1Q>L`ABU09:DP8icP8U:@8@Q0848@P004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo236<23F]0SW>1Sg_148@0THa14YB1Tic25:D1UJe5U[F1Ukg15[F1UJe0U:D
0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D64ic15:D0TYB0SW>0RDY0Q240P@Q2000@0@Q1Goo0@00
0Goo000EOol00`00Oomoo`02Ool6<H`8=Jd2>Lh4?Nl6@Q02AS44BU86CW<6DY@8E[D<F]HDG_L4F]H6
E[D2DY@2AS42@Q02AS42DY@2E[DUDY@JCW<2DY@2CW<2@Q02;F/26<H236<212420002124400101245
Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`HaS0Pe[@8icP@mk`I24096<@A:DPI>
L`IBU0QF]@aJeQANm`AJePIF]@9BU096<@924096<@9BU09F]BEBU1Y>L`9BU09>L`92408]J`8HaP8<
H`848@8000848@@004048@Eoo`40005oo`002Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF]@YJePiNm`9S60YNm`9JePIF]@9>L`96
<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@004048@Eoo`40005o
o`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF
]@YJePiNm`9S60YNm`9JePIF]@9>L`96<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088
@P848@8000848@@004048@Aoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2
E[D2BU84AS42CW<WDY@<CW<2DY@6CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool1
0001Ool000Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2
@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@6
CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool10001Ool000Uoo`8000=oo`8000Eo
o`03001oogoo009oo`8aS08e[@@icPPmk`9240I6<@A:DPA>L`IBU0IF]@aJePYNm`iS60YNm`IJeP9F
]@9BU09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`ABU09:DP92408]J`8Li`8<H`848@H000848@@00404
8@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1THa14YB14ic1U:D1UJe35[F
2Ukg3V<H2Ukg1U[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic15:D0TYB0T8@0Re[0QcW0PaS
0P@Q1P000P@Q1000@0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4@Q04AS44BU86
CW<4DY@8E[D<F]H6G_L2HaP2G_LDHaP:G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2CW<2BU82CW<4
DY@2AS42>Lh28@P25:D2248612420002124400101245Ool10001Ool001Eoo`03001oogoo009oo`8e
[@HicP@mk`A240A6<@A:DPI>L`ABU0QF]@aJePINm`9S609NmaAS60YNm`9JePAF]@9>L`A:DP9>LamB
U0Q>L`YBU09>L`9:DP9>L`ABU096<@8icP8Q208DY@88@PH48@8000848@@004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo13W>13g_148@1THa14YB1Tic1U:D1UJe35[F2Ukg66<H25kg1U[F0U:D1TYB
0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D0UJe0U:D0Sg_0Re[0QS60Q240PQ20P@Q2000A0@Q
1Goo0@000Goo000EOol00`00Oomoo`02Ool4>Lh4?Nl4@Q06AS44BU86CW<6DY@6E[D<F]H:G_LHHaP8
G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4CW<>DY@4CW<2DY@2E[D2DY@2?Nl2;F/26<H248@2
2482124800141245Ool10001Ool001Eoo`03001oogoo009oo`8icP@mk`A240I6<@A:DPI>L`QBU0AF
]@YJePaNm`iS609W>@aS60YNm`9JeP9F]@Q>LbeBU0I>L`ABU09:DP8aS08Q208DY@8@Q088@P848@H0
04H48@Eoo`40005oo`005Goo0P000goo0SW>13g_148@1THa14YB1Tic25:D15Je2U[F35kg3V<H0VLi
36<H2Ukg0U[F0UJe24ic;E:D1Tic15:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00AP@Q17oo0P000Goo
000EOol00`00Oomoo`02Ool2?Nl6@Q04AS46BU84CW<:DY@4E[D:F]H>G_L>HaP8IcT<HaP4G_L4F]H2
DY@6CW<[DY@8CW<2DY@2CW<2?Nl2:DX26<H248@236<4124400181245Ool10001Ool001Eoo`03001o
ogoo009oo`8mk`I240A6<@I:DPA>L`YBU0AF]@YJePiNm`iS60QW>@aS60ANm`AJeP9BU0I>Lb]BU0Q>
L`9BU09>L`8mk`8YBP8HaP8@Q08<H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo1T8@
14Ha24YB1Tic25:D0UJe3U[F35kg8V<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic15:D0TYB
0SF]0R480QBU0Q240PaS0P@Q1P00B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6@Q04AS48BU86
CW<8DY@2E[D>F]H<G_LRHaP2G_L6F]H2E[D2CW<4BU82CW<YDY@2CW<2DY@2CW<4DY@2BU82=Jd28@P2
5:D248@236<2124600181245Ool10001Ool001Eoo`03001oogoo009oo`A240I6<@Q:DPA>L`QBU0AF
]@iJePaNmb1S60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iBU0A>L`9BU09>L`92408]J`8HaP8@Q0@<
H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo148@1THa24YB14ic25:D15Je3U[F35kg
86<H15kg1U[F0UJe0U:D14YB0Tic6e:D0Tic3U:D14ic0U:D0Tic0T8@0Re[0QS60Q2410aS10@Q1000
B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q06AS44BU88CW<6DY@8E[D<F]H>G_LPHaP6G_L6
F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2CW<4DY@2CW<2>Lh29BT25:D436<2249@1245Ool10001Ool0
01Eoo`03001oogoo009oo`9240I6<@A:DPQ>L`IBU0QF]@aJePiNmb1S60INm`IJeP9BU09>L`A:DPI>
LaEBU0I>L`YBU09>L`ABU09>L`8icP8U:@8DY@@<H`88@U048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1THa1TYB1Tic1U:D25Je35[F35kg2V<H0VLi76<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic
15:D24ic15:D0T8@0Re[0QcW0Q2410aS0PQ2D0@Q1Goo0@000Goo000EOol20003Ool6AS46BU86CW<6
DY@8E[D<F]H<G_L:HaP2IcTLHaP8G_L2E[D2DY@6BU84CW<2DY@4CW<5DY@@CW<4DY@8CW<4DY@2@Q02
;F/27>L248@436<2249@1244Ool20001Ool001Eoo`03001oogoo009oo`A6<@A:DPY>L`IBU0IF]@YJ
ePiNm`YS60IW>AYS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@8Q208DY@@@Q088@Rh4
8@88@R848@Eoo`40005oo`005Goo00<007ooOol00Woo14Ha14YB2Tic1U:D1UJe2U[F3Ukg2V<H1VLi
6V<H25kg0U[F0U:D0Tic1TYB24ic0e:D7Tic0U:D0TYB0SF]0R480QBU11240PQ2;P@Q0PQ28P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool2AS48BU82CW<:DY@4E[D>F]H>G_L:HaP:IcT4HaP<IcT8HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/2
6<H648@2248`1242248P1245Ool10001Ool001Eoo`03001oogoo009oo`96<@Q:DP9>L`YBU0AF]@iJ
ePiNm`YS60YW>@AS60aW>@QS60ANm`9JePAF]@9>L`9:DP96<@A:DPQ>L`03DYA>Ldic00I>L`9BU0a>
L`9BU09>L`9:DPA>L`96<@8]J`8HaPH@Q088@S048@88@R048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1TYB1Tic2U:D15Je3U[F3Ukg2V<H36Li1V<H16Li36<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic
0TYB0Sg_0RU:0QBU0Q2410aS0PQ2;P@Q10Q280@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6BU86
CW<:DY@4E[D>F]H>G_L:HaP<IcT6HaP4IcT<HaP4G_L4F]H2E[D2DY@2CW<4AS42BU8WCW<2BU82?Nl2
:DX25:D248@436<2248^1244248P1245Ool10001Ool001Eoo`03001oogoo009oo`A:DPQ>L`QBU0AF
]@iJePaNma1S60YW>AQS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q208@Q0@<H`@8@QP4
8@88@Q048@P8@R048@Eoo`40005oo`005Goo00<007ooOol00Woo14YB24ic25:D15Je3U[F35kg46<H
2VLi66<H15kg15[F0UJe0Tic14Ha0TYB8dic15:D0THa0SF]0R480Q2410aS10Q260@Q0PQ240@Q20Q2
80@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU88CW<<E[D>F]H<G_L:HaP4IcT6HaP6IcTHHaP4
G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2BU82CW<4DY@2@Q02:DX26<H448@236<4248F1244248<124<
248P1245Ool10001Ool001Eoo`8000=oo`A:DPQ>L`aF]@iJePaNm`YS60AW>@IS60IW>AQS60ANm`AJ
eP9F]@9BU09:DPA6<@9:DQe>L`9:DP9>L`ABU092408YBP8HaP@@Q08<H`@8@QH48@@8@P`48@`8@R04
8@Aoo`80005oo`005Goo00<007ooOol00Woo14YB1Tic0U:D35Je3U[F35kg2V<H1VLi1V<H16Li5V<H
1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS60QBU0Q240PaS
20Q24P@Q10Q22P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU86CW<2DY@<E[D>F]H<
G_L:HaP6IcT6HaP4IcTFHaP6G_L4F]H2E[D2DY@2CW<6AS42BU8CCW<2BU86CW<2BU82CW<2DY@2CW<2
>Lh28@P26<H25:D248@236<8248B1244248:124@248N1245Ool10001Ool001Eoo`03001oogoo009o
o`9:DPI>L`ABU0aF]@aJeQ9Nm`IS60YW>AaS60INm`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:
DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP@DY@8@Q08<H`P8@P`48@X8@PH48@88@P848A08@Qh4
8@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB1Tic15:D35Je35[F4Ukg1V<H2VLi76<H1Ukg15[F
0UJe0U:D0Tic0TYB0THa0T8@0TYB1dic14YB24ic14YB14ic0TYB0Tic0U:D0THa0S6<0QS611BU0Q24
0PaS20Q230@Q2PQ21P@Q0PQ20P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6CW<6DY@:
E[D>F]HBG_L4HaP>IcTJHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2BU82CW<6BU88CW<2
>Lh29BT65:D248@:248:124V248N1245Ool10001Ool001Eoo`03001oogoo009oo`I>L`IBU0YF]@iJ
eQ9Nm`AS60iW>AYS60INm`AJePAF]@9BU09:DPI6<@A:DP=>L`A:DPA>L`9:DP9>L`I:DPQ>L`8icP8U
:@HDY@8@Q0X8@PX48BH8@Qh48@Eoo`40005oo`005Goo00<007ooOol00Woo1Tic15:D35Je3U[F25kg
1V<H15kg16<H0VLi0V<H2VLi6V<H2Ukg0U[F0UJe0U:D0Tic1THa6DYB1Tic0TYB0SF]0R480Q240QBU
0QS60Q2410Q20P@Q10Q22P@Q10Q210aS7PQ26P@Q10Q21Goo0@000Goo0007Ool30004Ool20005Ool0
0`00Oomoo`02Ool6CW<4DY@<E[D>F]H8G_L6HaP4G_L4HaP2IcT2HaP:IcTJHaP:G_L2F]H2E[D2DY@2
CW<6AS4IBU86CW<2BU82=Jd28@P248@25:D26<H248@424821244248:1244248436<N248J12442485
Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D25Je
45[F3Ukg16<H46Li76<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
11BU0PaS30Q210@Q0PQ21PaS0Q240PaS1PQ21P@Q4PQ26P@Q10Q21Goo0@000Goo0007Ool01000Oomo
o`000Woo00@007ooOol000Aoo`8000=oo`9>L`YBU0QF]A1JePiNm`AS611W>AaS60YNm`AJeP9F]@9>
L`9:DPA6<@9240e:DP96<@Y:DPA>L`8mk`8YBP8HaP8@Q0@DY@8<H``8@P@48@88@PH<H`8@Q08<H`H8
@PH48A88@QX48@@8@PAoo`80005oo`001goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9>
L`QBU0YF]A1JePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>
L`9:DP8icP8U:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eo
o`40005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`QBU0YF]A1J
ePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>L`9:DP8icP8U
:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eoo`40005oo`00
27oo0`000goo0P001Goo00<007ooOol00Woo0Tic1U:D35Je45[F35kg1V<H46Li76<H2Ukg15[F15Je
0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW0Q240PaS11240PaS1PQ22P@Q0PQ20PaS
0R480QcW0QBU0PaS70Q27P@Q0PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<6DY@<E[D@F]H<
G_L6HaP@IcTLHaP:G_L4F]H4E[D2DY@2CW<2AS42@Q02AS4;BU82AS4:BU82CW<2AS42<H`27>L248@2
36<448@236<6248:1242248236<28@P27>L25:D236<L248N12422485Ool10001Ool001Eoo`03001o
ogoo009oo`IBU0aF]A1JePYNm`QS619W>AaS60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB
00A:DPI6<@9:DP96<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@8@Q08<H`88@Ph48@8<H`8@Q0@HaP8DY@8<
Ha`8@Q`48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U:D35Je45[F2Ukg26<H4VLi76<H2Ukg
1U[F0UJe0U:D0Tic0TYB0THa0T8@00=6<DYBBU8014YB1THa0TYB0THa24YB0Sg_0Re[0QS60Q240PaS
0QBU0Q240PaS0PQ23P@Q0PaS0Q2411S60QBU0PaS70Q270@Q10Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool6DY@8E[DDF]H:G_L:HaP@IcTNHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT2
5:D236<248@25:D248@236<2248<1244248836<H248236<4248J12462485Ool10001Ool001Eoo`03
001oogoo009oo`IBU0QF]AAJePYNm`YS611W>AiS60QNm`IJeP9F]@ABU09:DP96<@=24196<@I:DP8i
cP8U:@8DY@8<H`8@Q08DY@8@Q08<H`88@P`48@@8@PP<HaP8@P8<H`@8@QX48@H8@PEoo`40005oo`00
5Goo00<007ooOol00Woo15:D25Je5U[F3Ukg2V<H4VLi66<H25kg1U[F0UJe15:D0Tic0TYB1d8@3THa
14YB0THa0SF]0R480Q2410aS0Q240PaS10Q23P@Q80Q210aS10Q26P@Q1PQ21Goo0@000Goo000EOol2
0003Ool4DY@8E[DFF]H>G_L:HaPBIcTHHaP8G_L6F]H2E[D4DY@2CW<2BU87@Q0>AS44BU82AS42=Jd2
8@P248@436<248@236<4248>124P248436<4248J12462484Ool20001Ool001Eoo`03001oogoo009o
o`ABU0QF]AAJeQ1Nm`YS619W>AaS60ANm`9JeP9Nm`9JePIF]@9BU09:DP96<@03@Q0mkcg_00A240a6
<@9:DP96<@92408aS08Li`8@Q0H<H`H8@PX48@88@P@48@H8@P@48A@8@P@<H`H8@P848@@8@PP48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo15:D25Je55[F45kg2V<H4VLi76<H15kg0U[F0Ukg0U[F
1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB0THa0T8@0S6<0QcW0Q241PaS1PQ22P@Q0PQ210@Q
1PQ210@Q50Q210aS1PQ20P@Q10Q220@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@8E[DD
F]H<G_L:HaP6IcT4HaP>IcTJHaP4G_L2F]H4G_L2F]H4E[D2DY@2BU82AS400d8@?Nlmk`06@Q06AS42
@Q02AS42BU82AS42?Nl2;F/26<H648@236<2248>124<248412462482124<248436<6248212442488
124@2485Ool10001Ool001Eoo`03001oogoo009oo`ABU0QF]AAJePaNm`YS60IW>@AS60iW>AYS60AN
m`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@
Q08<H`88@Ph48@`8@P@48@H8@P848@`8@P@<H`H8@P848@@8@PP48A08@PEoo`40005oo`005Goo00<0
07ooOol00Woo35Je45[F45kg26<H16Li26<H0VLi1V<H1VLi56<H3Ukg1U[F0UJe0U:D14ic00=6<Cg_
?Nl00Sg_1T8@14Ha148@0TYB0THa0SF]0RDY0QS61Q240PaS5P@Q0PQ210@Q5PQ210aS2PQ20P@Q1PQ2
1P@Q3PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool<E[D@F]H@G_L8HaP4IcT8HaP2IcT6HaP6IcTD
HaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT26<H648@236<F
12422484124F248436<:248212462486124>2485Ool10001Ool001Eoo`03001oogoo009oo`YF]A9J
eQ1Nm`YS609W>@QS609W>@IS60IW>AAS60ANm`9S60QNm`IJePAF]@9BU09>L`03BU92448@00Q240A6
<@A24096<@92408e[@8U:@8HaP8DY@8@Q08<H`88@Q@48@@8@P@48AH8@P@<H`X8@P848@H8@P@48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo2UJe4U[F45kg2V<H0VLi26<H0VLi1V<H1VLi56<H15kg
0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@0SF]0RDY0QS60QBU0Q240PaS
0PQ250@Q10Q210@Q5PQ210aS2PQ20P@Q1PQ210@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool8
E[DDF]H@G_LDHaP2IcT6HaP6IcT>HaP2G_L6HaP2G_L4HaP6G_L8F]H2E[D4DY@00dYBAS56<@04@Q02
?Nl2@Q02AS46@Q02AS42@Q02<H`28@P26<H25:D248@236<2248D124N248436<:248212462482124B
2485Ool10001Ool001Eoo`8000=oo`QF]AAJeQ1NmaAS609W>@IS60IW>@iS609Nm`IS609Nm`AS60IN
m`QJeP9F]@ABU003BU96<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88
@Q@48Ah8@P@<H`X8@P848@H8@P848A88@PAoo`80005oo`005Goo00<007ooOol00Woo25Je55[F45kg
46<H1VLi26<H0VLi46<H0Ukg36<H1Ukg25[F15Je0U:D00=>LdYBBU800THa0T8@0Sg_2T8@0THa0Sg_
0Re[0R480QS60QBU0Q240PQ250@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[DDF]H@G_L@HaP6IcT8HaP2IcT@HaP2G_L<HaP6G_L8F]H4E[D2DY@00dicBU9:DP02AS42@Q02
?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248D124P248436<:2482124J2485Ool10001Ool001Eo
o`03001oogoo009oo`QF]AAJePiNm`iS60YW>AYS609Nm`aS60ANm`YJePAF]@9BU003CW=:DTYB0096
<@9240@mk`Y2408icP8YBP8Li`8HaP8@Q08<HaH48B08@P@<H`X8@P848AX8@PEoo`40005oo`005Goo
00<007ooOol00Woo25Je55[F3Ukg3V<H2VLi6V<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa
0T8@13g_2T8@0SW>0RU:0QcW0QS60Q240PaS5P@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool8E[DDF]H<G_L>HaP<IcT2HaP4IcTDHaP2G_L<HaP4G_L:F]H4E[D2DY@3CW<2BU82
@Q04?Nl:@Q02=Jd29BT26<H25:D236<2248D124R248436<V2485Ool10001Ool001Eoo`03001oogoo
009oo`QF]AAJePaNm`iS60aW>@9S60AW>AAS609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2
408e[@8U:@8HaP8DY@8<H`88@Q@48B88@P@<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo25Je
45[F3Ukg3V<H3VLi0V<H16Li56<H0Ukg36<H1Ukg25[F1UJe00=BU4icCW<00TYB0THa0T8@1Sg_148@
0Sg_0S6<0R4811BU0PaS0PQ22P@Q0PQ210@Q9PQ20PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[D@F]H>G_L>HaP>IcT2HaP4IcTDHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06
?Nl4@Q02?Nl2<H`28@P45:D236<2248:12422484124V248236<X2485Ool10001Ool001Eoo`03001o
ogoo009oo`9F]AAJeQ1Nm`iS61AW>A9S60ANm`aS60INm`YJePAF]@=BU09>L`9:DP9240Pmk`92408m
k`8]J`8Li`8DY@8@Q08<H`88@PX48@88@P848BP8@P8<HbP8@PEoo`40005oo`005Goo0P000goo0UJe
55[F45kg3V<H56Li4V<H15kg36<H1Ukg2U[F15Je0e:D0Tic0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU
0Q240PaS0PQ22P@Q0PQ20P@Q:0Q20PaS:0Q217oo0P000Goo000EOol00`00Oomoo`02Ool4E[D@F]HB
G_L>HaP@IcTDHaP4G_L:HaP2IcT2HaP2G_L2HaP4G_L8F]H5E[D2DY@2CW<4BU82@Q02>Lh4?Nl2@Q02
?Nl2:DX26<H248@236<224881242248:12482482124D248836<T248236<22485Ool10001Ool001Eo
o`03001oogoo009oo`AF]A1JeQ9Nm`iS611W>AAS60ANm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PP48@88@PX48@P8@P848A@8@PP<Hb@8
@P8<H`88@PEoo`40005oo`005Goo00<007ooOol00Woo0UJe45[F4Ukg4V<H36Li5V<H15kg3V<H25kg
25[F1EJe0U:D14ic0TYB0T8@0SW>13g_0T8@0SW>0RU:0QS60Q240PaS0PQ220@Q10Q220@Q20Q20P@Q
5PQ21PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D@F]HBG_LBHaP<IcTFHaP4G_L>HaP8
G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02>Lh2:DX26<H248@236<224881244248812482482
124F248636<X2485Ool10001Ool001Eoo`03001oogoo009oo`9F]@iJeQANmaAS60QW>AYS609Nm`iS
60QNm`YJeP=F]@ABU09>L`9:DP96<@8mk`8icP@mk`8icP8U:@8DY@8@Q08<H`88@PP48@@8@PP48@P8
@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`005Goo00<007ooOol00Woo0UJe3U[F55kg56<H26Li6V<H
0Ukg3V<H25kg2U[F0eJe15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ220@Q10Q2
20@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D>F]HDG_LFHaP6
IcTZHaP8G_L:F]H5E[D2DY@4CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<:1246248612482482124F
248636<V248236<5Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`9F]@iJeQANmaIS
60IW>BYS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8DY@@<H`X48@H8@PH48@P8@P84
8AH8@PH<HbH8@P8<H`Eoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomo
o`02Ool@F]HFG_LBHaP8IcTZHaP:G_L8F]H5E[D4DY@2CW<2BU82@Q06>Lh2<H`28@P25:D436<:1246
248612482482124F248636<X2485Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo
0P000goo45[F5Ukg4V<H26Li:V<H2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2P@Q
1PQ21P@Q20Q20P@Q5PQ21PaS:0Q217oo0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007oo
Ool00Woo4U[F55kg46<H2VLi;6<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU
0PaS0PQ25P@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007oo
Ool000Aoo`03001oogoo009ooa9JeQANma1S60YW>BaS60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8i
cP8e[@8aS08Q208DY@8<H`88@QH48@P8@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo4U[F2Ukg0V<H25kg36<H46Li:V<H35kg1e[F0UJe1U:D0Tic0TYB0T8@
0SW>0SF]0Re[0R480QBU0PaS0PQ25P@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000EOol00`00Oomo
o`02OolBF]H:G_L2HaP8G_L<HaP@IcTZHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P2
5:D236<2248F12482482124D248836<X2485Ool10001Ool001Eoo`03001oogoo009ooa9JePYNm`AS
60INm`YS61AW>BQS60iNm`EJeP9F]@IBU0A>L`96<@8mk`8e[@8]J`8Li`8DY@8<HaP48@P8@P848A@8
@PP<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo4U[F2Ukg16<H1Ukg2V<H56Li:6<H3Ukg1E[F
0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS60@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000E
Ool00`00Oomoo`02Ool@F]H@G_L4HaP2G_L:HaP@IcTDHaP4IcT2HaP6G_L<HaP<G_L9F]H4E[D2DY@4
CW<2BU82@Q02=Jd2:DX27>L248@236<@2482124:2486124@248:36<V248212422485Ool10001Ool0
01Eoo`03001oogoo009ooa1JeQ1Nm`AS609Nm`YS611W>AAS60AW>@9S60INm`aS60aNm`UJePAF]@9B
U0A>L`9:DP92408e[@8YBP8Li`8@Q08<Ha08@P848@X8@PH48A08@PX<HbH8@P848@88@PEoo`40005o
o`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi16<H46Li56<H0VLi16<H15kg3V<H35kg2E[F15Je
0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q:PQ240aS90Q21Goo0@000Goo000EOol20003
Ool@F]H@G_L:HaP2IcT4HaP@IcTDHaP2IcT4HaP4G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2
:DX27>L248@236<22486124Z248@36<T2484Ool20001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`YS
609W>@9S611W>AaS60ANm`iS60iNm`MJePAF]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BH8@Q8<
HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi0V<H46Li76<H15kg3V<H3Ukg
1e[F15Je0U:D14ic14YB0Sg_0Re[0QcW0Q2410Q21P@Q9PQ24PaS9PQ21Goo0@000Goo000EOol00`00
Oomoo`02Ool@F]H@G_L8HaP4IcT2HaP@IcTLHaP4G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`2
7>L248@42482124/248@36<V2485Ool10001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`QS60AW>@9S
611W>AaS60ANma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848B`8@Q0<HbH8@PEo
o`40005oo`005Goo00<007ooOol00Woo3U[F4Ukg1V<H1VLi16<H46Li1V<H0VLi4V<H15kg46<H35kg
1e[F1UJe0U:D1Tic0THa0SF]0R480Q244PQ20P@Q7PQ20PaS0PQ230aS9PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool>F]HBG_L6HaP6IcT4HaP@IcT6HaP2IcTBHaP4G_L@HaP<G_L7F]H6E[D2DY@6CW<2
AS42=Jd28@P248@B2482124N248236<2248<36<V2485Ool10001Ool001Eoo`03001oogoo009oo`iJ
ePiNm`YS60IW>@9S61aW>A1S60ANm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8mk`8YBP8@Q108
@P@48Ah8@Ph<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo3U[F3Ukg2V<H1VLi0V<H76Li46<H
15kg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q2440Q210@Q7PQ23PaS:0Q21Goo0@00
0Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPNIcTHHaP4G_L:HaP>G_L7F]H4E[D4DY@4
CW<2AS42<H`25:DB2482124L248636<648@836<T2485Ool10001Ool001Eoo`8000=oo`iJePiNm`QS
60IW>@9S61iW>AQS60ANm`YS60iNm`MJePAF]@ABU0A>L`96<@8aS08DYA88@P848A`8@PH<H`H@Q0P<
Hb@8@PAoo`80005oo`005Goo00<007ooOol00Woo3U[F3Ukg26<H1VLi0V<H86Li5V<H15kg2V<H3Ukg
2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:PQ220aS0Q2411BU0Q241PaS80Q20PaS0PQ21Goo
0@000Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPPIcTFHaP4G_L:HaP>G_L9F]H2E[D2
DY@2E[D4CW<2BU82>Lh26<H2248236<Z248836<248@45:D248@636<P248236<22485Ool10001Ool0
01Eoo`03001oogoo009oo`IJeQINm`YS62IW>BAS60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2188
@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q08<H`88@P8<Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo
1U[F5Ukg2V<H9VLi96<H3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484PQ20P@Q7PQ20PaS0Q2411S6
0QBU0Q240PaS0PQ20PaS90Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4
G_L:HaP2G_L4HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@@2482124N248236<248@46<H2
5:D248@636<T2485Ool10001Ool001Eoo`03001oogoo009oo`IJeQINm`IS62YW>AIS60ANm`YS609N
m`AS60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q108@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q0H<
Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U[F5Ukg1V<H:VLi5V<H15kg1V<H15kg26<H1ekg
25[F15Je25:D0THa0Re[0QBU1PQ20PaS9PQ210aS0QBU12480QBU0Q2410aS9PQ21Goo0@000Goo000E
Ool00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8DY@2AS42;F/2
5:D6248236<V248436<25:D48@P25:D248@436<V2485Ool10001Ool001Eoo`03001oogoo009oo`IJ
eQINm`AS62aW>AIS60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8HaPH8@P8<HbH8@P@<H`8H
aP@]J`8Li`8@Q0@<HbH8@PEoo`40005oo`005Goo0P000goo1U[F5Ukg16<H;6Li5V<H15kg1V<H15kg
26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9PQ210aS0QS612e[0QcW0Q2410aS9PQ217oo0P00
0Goo000EOol00`00Oomoo`02Ool6F]H>G_L<HaPBIcT4JeXDIcTHHaP4G_L8HaP6G_L4HaP7G_L8F]H4
E[D8DY@2BU82>Lh28@P6248236<J248436<8248436<28@P4=Jd28@P248@236<X2485Ool10001Ool0
01Eoo`03001oogoo009oo`IJePiNm`aS619W>@A[FQAW>AQS60ANm`QS60INm`AS60MNm`QJePAF]@QB
U09:DP8icP8Q20H8@P8<HaX8@P@<H`P8@P@<H`8Q20@e[@8Q208@Q08<HbP8@PEoo`40005oo`005Goo
00<007ooOol00Woo15[F3Ukg36<H36Li0V]J16Li36]J46Li96<H15kg26<H0ekg2U[F15Je1U:D0Tic
0T8@0RU:0PaS10Q210aS60Q21PaS1PQ210aS0R4813F]0R480Q240PaS2PQ20P@Q70Q21Goo0@000Goo
000EOol00`00Oomoo`02Ool4F]H>G_L<HaP<IcT2JeX4IcT<JeX@IcTTHaP4G_L8HaP3G_L:F]H4E[D6
DY@2CW<2@Q02:DX236<4248436<H248636<6248436<28@P4=Jd28@P248@236<:2482124L2485Ool1
0001Ool001Eoo`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>C9S60=Nm`aJePIBU09>L`96<@8]J`8D
Y@@8@P8<HaX8@P@<H`P8@P@<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A`8@PEoo`40005oo`005Goo00<0
07ooOol00Woo45kg36<H36Li56]J46Li<V<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6PQ210aS
20Q210aS0QcW12e[0QcW0Q241PaS10Q210@Q70Q21Goo0@000Goo000EOol00`00Oomoo`02Ool@G_L<
HaP<IcTDJeX@IcTXHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D4248436<F248236<<248436<2
6<H49BT25:D248@636<42484124L2485Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eo
o`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>BQS60AW>@IS60=Nm`aJePIBU09>L`9:DP8e[@8DY@@8
@P@<HaH8@P8<H``8@P@<H`8HaP@U:@8DY@8@Q0H<H`@8@P@48A`8@PEoo`40005oo`000goo00D007oo
Oomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L6HaP@IcT@JeX4
IcT2JeX>IcTTHaP4G_L2HaP4JeX4HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H2
36<2248436<F248436<8248436<248@26<H47>L25:D448@236<V2485Ool10001Ool000=oo`05001o
ogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo4Ukg1V<H46Li46]J16Li0V]J
3VLi96<H15kg0V<H16]J16<H00=Nme[FF]H015kg25[F0UJe0U:D0UJe0U:D0TYB0SW>0QS60PaS0PQ2
10aS5PQ210aS20Q210aS0Q240QS611cW0QBU11240PaS9PQ217oo0P000Goo0003Ool01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9Nm`9JePiNm`IS60iW>AQ[
FPiW>BIS609Nm`9S60A[FP9W>@9S60MNm`QJeP9F]@9BU09F]@9BU09:DP8mk`8Li`8<H`88@P@<HaH8
@P@<H`@8@P8<H`88@P@<H`8@Q08DY@@HaP8DY@8@Q0@<HbH8@PEoo`40005oo`000goo00D007ooOomo
o`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2G_L2F]H>G_L6HaP>IcTH
JeX>IcTVHaP2G_L2HaP4JeX2IcT2HaP7G_L8F]H2E[D2DY@2E[D2DY@2BU82?Nl27>L236<2248436<F
248436<4248236<2248436<248@25:D46<H25:D248@436<V2485Ool10001Ool0009oo`8000Aoo`80
00Aoo`8000Eoo`03001oogoo009oo`AJePaNm`QS60aW>AY[FPiW>BIS609Nm`9S609W>@A[FP9S60MN
m`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaH8@P@<H`@8@P8<H`88@P@<H`@@Q0@DY@8@
Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo15[F35kg26<H36Li6V]J3VLi9V<H0Ukg0V<H
0VLi16]J0V<H1ekg25[F0UJe0U:D0UJe0U:D0Tic0T8@0RDY0PaS0PQ210aS5PQ210aS10Q20PaS0PQ2
10aS112411BU0Q241PaS9PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H>G_L8HaP<IcTLJeX@
IcTVHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2CW<2AS42:DX248@2248436<2248236<J2482
36<4248236<448@45:D248@636<V2485Ool10001Ool001Eoo`03001oogoo009oo`9JePiNm`QS60aW
>Aa[FQ1W>BIS609W>@A[FP=S60INm`QJeP9F]@9BU09F]@9BU09>L`96<@8YBP8@Q088@P@<H`88@P8<
HaX8@P8<H`@8@P8<H`@@Q0@DY@8@Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45kg1V<H
36Li46]J0Vmk36]J46Li76<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS
0PQ20PaS10Q20PaS50Q210aS0PQ210aS212420aS10Q220@Q60Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool@G_L6HaP<IcT@JeX2Kg/<JeX@IcTLHaP2G_L:HaP4IcT3HaP6G_L:F]H4E[D2DY@2CW<2AS42
;F/25:D2248436<2248236<4248236<D248436<2248436<848@836<42488124H2485Ool10001Ool0
01Eoo`03001oogoo009ooa1Nm`AS60iW>@I[FPA_N`A[FPI_N`Y[FQ9W>@QS609W>B=S60INm`AJeP9N
m`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<H`88@P8<H`@8@P8<Ha@8@P@<H`88@P@<H`H@Q0H<H`P8
@PP48@@8@PX48@X8@PEoo`40005oo`005Goo0P000goo45kg16<H3VLi1V]J16mk16]J1Vmk2V]J4VLi
26<H0VLi8f<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0TYB0S6<0QS60PQ210aS0PQ20PaS10Q20PaS50Q2
10aS0PQ210aS1Q241PaS20Q220@Q10Q22P@Q2PQ217oo0P000Goo000EOol00`00Oomoo`02Ool>G_L6
HaP<IcT4JeXBKg/:JeXLIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2CW<2=Jd26<H636<2248236<J2484
36<2248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`iNm`IS60aW>@A[
FQ9_N`Y[FQaW>B=S60INm`AJeP9Nm`AJePAF]@ABU09>L`8e[@8HaPH<H`88@P8<HaX8@P@<H`88@Q0<
H`P8@PP48@@8@P`48@P8@PEoo`40005oo`005Goo00<007ooOol00Woo3Ukg1V<H2VLi1V]J56mk26]J
76Li56<H15kg3F<H15kg15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21PaS4PQ20PaS1PQ210aS0PQ2
40aS20Q220@Q10Q230@Q20Q21Goo0@000Goo000EOol00`00Oomoo`02Ool>G_L6HaP:IcT6JeXDKg/8
JeXLIcTDHaP4G_L=HaP4G_L4F]H2G_L8F]H4DY@2CW<2>Lh26<H236<2248636<B248236<6248436<2
248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`YNm`QS60YW>@I[FPI_
N`IcW0Q_N`Y[FQ1W>C5S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20P<H`88@P8<H``8@PH<H`X8
@Q8<H`H8@Ph48@P8@PP48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo2Ukg26<H2VLi1V]J1Vmk
1W>L26mk2V]J46Li<F<H15kg1U[F0Ukg15[F15Je0U:D0TYB0Sg_0R4820aS0PQ20PaS30Q21PaS2PQ2
4PaS1PQ23P@Q20Q220@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool:G_L6HaP<IcT6JeX4Kg/:
Li`2Kg/2Li`4Kg/:JeX>IcTaHaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P836<2248236<@2482
36<:248D36<4248B1242248:12442485Ool10001Ool001Eoo`03001oogoo009oo`YNm`IS60aW>@I[
FPA_N`YcW09_N`9cW0A_N`Y[FPiW>C5S60INm`AJeP9Nm`AJePAF]@9BU09>L`92408Q20P<H`88@P8<
Ha08@P8<H`X8@Q@<H`@8@Q848@88@PX48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg26<H
2VLi1V]J16mk4W>L0Vmk0V]J0Vmk1V]J3VLi<F<H2Ukg1U[F1UJe0Tic0T8@0RDY30aS70Q250aS0PQ2
80@Q10Q21Goo0@000Goo000EOol20003Ool8G_L8HaP:IcT6JeX4Kg/BLi`2Kg/2JeX2Kg/6JeX>IcTa
HaP:G_L6F]H6E[D2CW<2@Q029BT<36<L248D36<2248P12442484Ool20001Ool001Eoo`03001oogoo
009oo`QNm`IS60YW>@I[FPA_N`IcW0Ig_@IcW0Q_N`I[FQ1W>BmS60YNm`QJePAF]@9>L`96<@8YBP8@
Q0X<Ha88@P8<H`P8@Q8<H`@8@R048@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg1V<H2VLi
1V]J16mk1W>L1WNm1W>L26mk1V]J46Li;f<H2Ukg25[F15Je0Tic0THa0RU:0Q242PaS4PQ20PaS20Q2
4PaS10Q280@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6G_L8HaP8IcT8JeX4Kg/4Li`8Mkd6
Li`4Kg/2JeX2Kg/4JeXBIcT8HaP2IcT6HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX248@236<22486
36<B248236<8248636<4248636<6248T1245Ool10001Ool001Eoo`03001oogoo009oo`INm`QS60QW
>@Q[FPA_N`AcW0Qg_@IcW0A_N`9[FP9_N`A[FQ9W>@QS609W>@IS609W>AeS60aNm`IJePAF]@9>L`96
<@8YBP8@Q08<H`88@PH<Ha88@P8<H`P8@PH<H`@8@PH<H`H8@R@48@Eoo`40005oo`005Goo00<007oo
Ool00Woo1Ukg1V<H2VLi16]J1Vmk0W>L3WNm17>L16mk0V]J0Vmk16]J56Li16<H16Li86<H0VLi0f<H
35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L6HaP:IcT4JeX6Kg/2Li`>Mkd4Li`4Kg/2JeX2Kg/4JeXDIcT4HaP4IcTP
HaP2IcT3HaP<G_L6F]H4E[D2DY@2AS42:DX248@236<2248636<B248236<8248B36<4248T1245Ool1
0001Ool001Eoo`03001oogoo009oo`INm`AS60YW>@I[FPA_N`AcW09g_@YkgP9g_@IcW09_N`9[FP9_
N`I[FQYW>A1S609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88
@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`40005oo`005Goo00<007ooOol00Woo1Ukg16<H2VLi1V]J
16mk17>L0WNm2W_N0WNm1W>L0Vmk0V]J0Vmk1V]J6VLi46<H0VLi3V<H0VLi00=S65kgG_L035kg0U[F
0Ukg0U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L4HaP:IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`6Kg/6JeXLIcT>HaP2IcTA
HaP>G_L2F]H2G_L2F]H4E[D2DY@2BU82:DX236<22482124636<6248236<:248236<8248B36<4248T
1245Ool10001Ool001Eoo`8000=oo`INm`AS60YW>@A[FPA_N`AcW0Ag_@YkgPAg_@AcW0I_N`I[FQaW
>@iS609W>A5S60iNm`9JeP9Nm`9JePAF]@9BU09:DP8YBP8<H`88@P848@H<H`H8@P8<H`X8@P8<H`P8
@Q8<H`@8@R@48@Aoo`80005oo`005Goo00<007ooOol00Woo36<H1VLi1V]J0Vmk17>L17Nm17_N1Woo
17_N0WNm17>L16mk1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q20Q22PaS30Q21PaS1PQ2
30aS10Q290@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<HaP6IcT6JeX2Kg/4Li`4Mkd4Nmh6Ool4
Nmh2Mkd4Li`4Kg/6JeXLIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@21248248:36<<248636<6248<
36<4248T1245Ool10001Ool001Eoo`03001oogoo009oo`aS60IW>@A[FPA_N`9cW0Ag_@AkgPQoo`Ak
gP9g_@AcW0A_N`I[FQaW>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@H8@PX<HbH8@RH48@Eo
o`40005oo`005Goo00<007ooOol00Woo36<H1VLi16]J16mk0W>L17Nm17_N27oo17_N0WNm17>L16mk
1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240PQ20P@Q1PQ22PaS9PQ29P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool<HaP4IcT6JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`6Kg/4JeXPIcT:HaP2
IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224841248248636<V248V1245Ool10001Ool001Eoo`03
001oogoo009oo`aS60AW>@I[FP9_N`AcW09g_@AkgPYoo`AkgP9g_@AcW0I_N`A[FR1W>@YS609W>A=S
60iNm`IJePAF]@9BU096<@8]J`8DY@88@P@48@P8@PH<HbH8@RH48@Eoo`40005oo`005Goo00<007oo
Ool00Woo26<H26Li16]J16mk0W>L0WNm17_N3Woo0W_N0WNm17>L1Vmk16]J8VLi7f<H35kg1U[F15Je
0U:D0THa0Re[0QBU0PQ210@Q0PQ20P@Q1PQ210aS80Q20PaS10Q29P@Q1Goo0@000Goo00000goo0000
000300000goo000000020003Ool20005Ool00`00Oomoo`02Ool8HaP8IcT4JeX4Kg/2Li`2Mkd4Nmh>
Ool2Nmh2Mkd4Li`6Kg/4JeXRIcTOHaP<G_L6F]H4E[D2DY@2AS42;F/25:D224841242248212462484
36<P248236<4248V1245Ool10001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<0
07ooOol00Woo1V<H26Li1V]J0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F
15Je0U:D0THa0Re[0QBU0PaS0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q1Goo0@00
0Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000goo1V<H26Li1V]J
0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F15Je0U:D0THa0Re[0QBU0PaS
0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q17oo0P000Goo0003Ool00`00Oomoo`03
Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li1V]J16mk0W>L0WNm
0W_N4Woo17_N0WNm0W>L1Vmk1V]J6VLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS60PaS0PQ20P@Q0PQ2
0P@Q0PQ210@Q:0Q2:0@Q1Goo0@000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo009oo`03001oogoo009oo`AS60QW>@I[FPA_N`9cW09g_@9kgQ9oo`AkgP9g_@9cW0I_N`I[
FQYW>BMS60QNm`QJePAF]@9BU09:DP8aS08HaP8<H`88@P848@88@P848@88@P@48BP8@RP48@Eoo`40
005oo`000Woo0P0017oo0P0017oo0P001Goo00<007ooOol00Woo16<H1VLi1V]J16mk0W>L17Nm0W_N
57oo0W_N0WNm0W>L1Vmk1V]J76Li2V<H16Li3V<H0Ukg0f<H0Ukg16<H1Ukg25[F15Je0U:D0TYB0SF]
0R480Q240PQ20P@Q0PQ20P@Q0PQ210@Q0PQ20P@Q40Q210aS40Q2:0@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool4HaP6IcT6JeX4Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`6Kg/6JeXLIcT:HaP4IcT>HaP2
G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@22482124224821242248412422482124@
248436<@248X1245Ool10001Ool001Eoo`03001oogoo009oo`9S60IW>@I[FPA_N`AcW09g_@AkgQAo
o`9kgP9g_@9cW0I_N`I[FRYW>@iS60MNm`AS60INm`QJePAF]@9BU09:DP8mk`8U:@8DY@88@P848@H8
@P@48@88@PP48@X8@PP<H``8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo0V<H1VLi1V]J16mk
17>L0WNm17_N57oo0W_N0WNm0W>L1Vmk1V]J:VLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY
0QBU0PQ20P@Q1PQ210@Q0PQ220@Q2PQ220aS30Q2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool8
IcT8JeX2Kg/2Li`4Mkd4NmhBOol4Nmh2Mkd2Li`2Kg/2JeX2Kg/8JeXRIcTHHaP=G_L8F]H4E[D2CW<2
AS42@Q02<H`27>L236<624841242248:1246248436<6248236<4248236<6248X1245Ool10001Ool0
01Eoo`03001oogoo009oo`QW>@Q[FP9_N`9cW0Ag_@AkgQ9oo`AkgP9g_@9cW09_N`9[FP9_N`Q[FR9W
>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`H8@P@48@88@PX48@H8@P@<H`H8@P8<H`@8@P8<
H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li1V]J16mk0W>L0WNm17_N57oo0W_N17Nm
0W>L0Vmk0V]J16mk26]J86Li66<H3Ekg25[F0UJe0U:D0Tic14Ha0SW>0RDY0QBU1PQ240@Q5PQ20PaS
1PQ2:0@Q1Goo0@000Goo000EOol20003Ool8IcT6JeX4Kg/2Li`2Mkd4NmhDOol2Nmh4Mkd2Li`2Kg/2
JeX4Kg/8JeXPIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D6248@124F248236<6248X1244
Ool20001Ool001Eoo`03001oogoo009oo`QW>@A[FPI_N`9cW09g_@AkgQAoo`9kgPAg_@9cW09_N`9[
FPA_N`i[FP9W>@A[FQAW>AQS60eNm`9JeP9Nm`AJeP9F]@9BU09>L`A6<@8mk`8aS08Li`8<H`@8@Q@4
8A88@P8<H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li16]J1Vmk0W>L0WNm17_N57oo
0W_N17Nm0W>L0Vmk0V]J16mk3V]J0VLi16]J56Li66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha0Sg_
0S6<0QcW0PaS10Q250@Q4PQ20PaS1PQ2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4
Kg/4Li`2Mkd4NmhDOol2Nmh4Mkd2Li`8Kg/FJeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2
BU82AS44@Q02>Lh29BT248@4248F124<248636<4248Z1245Ool10001Ool001Eoo`03001oogoo009o
o`IW>@I[FPA_N`AcW09g_@AkgQAoo`9kgPAg_@9cW0Q_NaI[FQ9W>@QS60AW>@eS60aNm`9JePANm`9J
eP9F]@9BU09:DP96<@A2408icP8U:@8@Q0@8@QH48@`8@PH<H`@8@RX48@Eoo`40005oo`005Goo00<0
07ooOol00Woo1VLi1V]J16mk17>L0WNm0W_N57oo17_N17Nm0W>L1Vmk26]J26Li26]J4VLi26<H16Li
3F<H35kg0U[F15kg0U[F0UJe0U:D0TYB0THa0Sg_0THa0T8@0S6<0QS60PaS10Q26P@Q40Q2:P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4Kg/4Li`2Mkd2NmhDOol4Nmh4Mkd2Li`6Kg/8JeX8
IcT8JeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`26<H236<4
248J124@248Z1245Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0
ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool0
01Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell["\<\
sample={
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.517647, 0.54902, 0.45098},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.388235, \
0.258824},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.419608, 0.352941, 0.192157, \
0.0941176},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.419608, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, \
0.482353, 
0.54902, 0.54902, 0.482353, 0.388235, 0.223529, 0.129412, 0, 0},
{0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.54902, 
0.517647, 0.419608, 0.290196, 0.160784, 0.0627451, 0.0313725, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.482353, 0.482353, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.45098, 
0.352941, 0.223529, 0.0941176, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, \

0.129412, 0.0313725, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.54902, 0.54902, 0.482353, 0.388235, 0.258824, 0.129412, \

0.0313725, 0, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.45098, 0.321569, 0.192157, 0.0941176, 0.0313725, \

0, 0, 0, 0, 0, 0, 0, 0},
{0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.482353, 0.419608, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.388235, 0.45098, 0.517647, 0.517647, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.45098, 
0.352941, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.45098, \

0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 0.388235, 0.290196, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \

0.517647, 0.54902, 0.580392, 0.54902, 0.45098, 0.352941, 0.192157, 0.129412, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.517647, 
0.54902, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.580392, 0.580392, 0.45098, 0.321569, 0.192157, 0.0941176, 0, 0, 0, \
0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.482353, 0.290196, 0.160784, 0.0627451, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.54902, \

0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.45098, 0.290196, 0.129412, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.45098, 
0.290196, 0.160784, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725},
{0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.517647, 0.482353, 0.54902, 
0.54902, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 
0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.482353, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, 0.160784, 
0.0627451, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0.0313725, 
0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.482353, 0.45098, 0.388235, 0.352941, 0.419608, 0.517647, 0.580392, \
0.611765, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, 0.0627451, \

0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.482353, 0.419608, 0.388235, 0.482353, 0.580392, 0.647059, \
0.647059, 
0.611765, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.54902, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.54902, \

0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.517647, 0.580392, 0.678431, 0.709804, \
0.807843, 
0.741176, 0.611765, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.482353, 0.321569, 0.192157, 0.0941176, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.611765, 0.709804, 0.776471, \
0.870588, 
0.807843, 0.678431, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.419608, 0.388235, 0.352941, 0.352941, 0.321569, \

0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.482353, 0.647059, 0.776471, 0.807843, \
0.807843, 
0.709804, 0.611765, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, \

0.54902, 0.45098, 0.419608, 0.45098, 0.517647, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.517647, 0.419608, 0.258824, 0.129412, 0.0313725, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, \
0.482353, 
0.419608, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.258824, 0.45098, 0.709804, 0.870588, 0.905882, \
0.807843, 
0.678431, 0.647059, 0.647059, 0.647059, 0.709804, 0.807843, 0.776471, \
0.678431, 
0.517647, 0.388235, 0.388235, 0.517647, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.45098, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.321569, 0.45098, 0.611765, 0.807843, 0.905882, 0.839216, \
0.678431, 
0.580392, 0.647059, 0.709804, 0.741176, 0.776471, 0.807843, 0.741176, \
0.647059, 
0.517647, 0.482353, 0.517647, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 
0.290196, 0.160784, 0.0627451, 0, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.388235, 0.388235, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.517647, 0.678431, 0.807843, 0.870588, 0.870588, 0.709804, \
0.54902, 
0.482353, 0.580392, 0.709804, 0.741176, 0.709804, 0.678431, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 0.352941, \

0.192157, 0.0941176, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.54902, 0.678431, 0.776471, 0.870588, 0.839216, 0.807843, 0.611765, \
0.482353, 
0.419608, 0.45098, 0.54902, 0.580392, 0.580392, 0.611765, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.482353, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.611765, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.647059, \
0.54902, 
0.45098, 0.419608, 0.419608, 0.419608, 0.517647, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.517647, 0.388235, 0.258824, \
0.160784, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.54902, 0.482353, 0.45098, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.647059, \

0.647059, 0.647059, 0.611765, 0.647059, 0.678431, 0.741176, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.45098, 0.419608, 0.482353, 0.54902, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, \
0.0627451, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.580392, \
0.611765, 
0.647059, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.482353, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, \

0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.709804, 0.678431, 0.678431, 0.647059, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.54902, \
0.580392, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.54902, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, \

0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.482353, 0.54902, \

0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.482353, 0.290196, 0.129412, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, \

0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.54902, \
0.517647, 
0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.352941, 0.192157, 0.0627451, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.580392, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.54902, 0.388235, 0.258824, 0.129412, 0.0313725, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.580392, \

0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.517647, 0.517647, 0.580392, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.580392, 
0.45098, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.517647, 0.54902, 0.647059, 0.678431, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.517647, 
0.352941, 0.192157, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, \
0.45098, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.611765, 0.54902, 0.517647, 0.580392, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.54902, \
0.419608, 
0.258824, 0.129412, 0.0627451, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.709804, 
0.678431, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.482353, \
0.321569, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.580392, 0.54902, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.517647, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.678431, 0.678431, 0.611765, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.580392, 0.611765, 0.647059, 0.647059, 0.54902, 0.45098, 0.258824, 0.160784, \

0.0627451, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.580392, 0.580392, 0.580392, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.678431, 0.647059, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.580392, 0.388235, 0.258824, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.647059, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.482353, 0.321569, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.419608, 0.258824, 0.160784, 0.129412, \
0.0941176, 
0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, \

0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.517647, 0.352941, 0.192157, 0.129412, 0.0941176, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.647059, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.45098, 0.290196, 0.160784, 0.0941176, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.678431, 0.647059, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.517647, 0.352941, 0.223529, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.647059, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.580392, 0.419608, 0.258824, 0.160784, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, 0.611765, \
0.580392, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.54902, 0.352941, 0.192157, 0.129412, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.482353, 0.321569, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.54902, 
0.419608, 0.258824, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.647059, \
0.517647, 
0.321569, 0.192157, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.611765, \
0.45098, 
0.258824, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.54902, \
0.388235, 
0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.45098, \
0.290196, 
0.160784, 0.160784, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.419608, \
0.258824, 
0.129412, 0.160784, 0.192157, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.611765, 0.580392, 0.54902, 0.54902, 0.517647, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.482353, 0.321569, \
0.192157, 
0.129412, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.45098, 0.290196, \
0.160784, 
0.0941176, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.223529, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.388235, 0.223529, \
0.129412, 
0.0941176, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.258824, 0.223529, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, \

0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0941176, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.129412, 
0.192157, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.45098, 0.290196, 0.160784, \
0.0941176, 
0.129412, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.419608, 0.258824, 0.129412, \
0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.517647, 0.388235, 0.223529, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.580392, 0.54902, 0.482353, 0.352941, 0.192157, 0.129412, 0.129412, \

0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.611765, \
0.54902, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.580392, 0.54902, 0.419608, 0.290196, 0.192157, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.54902, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, \
0.580392, 
0.54902, 0.517647, 0.517647, 0.482353, 0.517647, 0.54902, 0.517647, 0.517647, \

0.517647, 0.54902, 0.517647, 0.388235, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.482353, 0.352941, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.45098, 0.321569, 0.223529, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.388235, 0.258824, 0.160784, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.352941, 0.223529, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.580392, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.45098, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.482353, \

0.482353, 0.45098, 0.290196, 0.160784, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.611765, 0.611765, 0.54902, 0.517647, 0.45098, 0.45098, 
0.482353, 0.419608, 0.290196, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.45098, 0.45098, \

0.45098, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, \

0.419608, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.45098, 
0.419608, 0.352941, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.223529, 0.160784, 0.0941176, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.517647, 
0.419608, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.54902, 
0.45098, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.482353, 0.352941, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, \
0.580392, 
0.517647, 0.388235, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.54902, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.321569, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.54902, 0.388235, 0.160784, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.678431, \
0.611765, 
0.611765, 0.580392, 0.45098, 0.192157, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.611765, \
0.678431, 
0.647059, 0.580392, 0.482353, 0.258824, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.678431, 
0.647059, 0.611765, 0.517647, 0.290196, 0.129412, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.160784, 0.258824, 0.258824, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.419608, 0.192157, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.192157, 0.352941, 0.352941, 0.223529, 0.129412, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.45098, 0.258824, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.517647, 0.321569, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.223529, 0.352941, 0.352941, 0.223529, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.580392, 0.419608, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.192157, 0.290196, 0.290196, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.839216, 0.839216, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.45098, 0.192157, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.192157, 0.223529, 0.223529, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.839216, 0.839216, 0.807843, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.482353, 0.223529, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.160784, 0.192157, 0.192157, 0.160784, 0.129412, 0.0941176, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.517647, 0.290196, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.54902, 0.321569, 0.129412, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.580392, 0.388235, 0.192157, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.419608, 0.192157, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.647059, 0.611765, 0.45098, 0.192157, \
0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.482353, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.870588, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.517647, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.611765, 0.517647, 0.290196, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, \
0.870588, 
0.905882, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, \
0.937255, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, \
0.905882, 
0.905882, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, \
0.905882, 
0.937255, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.321569, \
0.0941176, 
0.0627451, 0.0313725, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, \
0.937255, 
0.937255, 0.968627, 0.968627, 1, 1, 1, 0.968627, 0.968627, 0.937255, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0313725, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, \
0.937255, 
0.968627, 0.968627, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0627451, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, \
0.968627, 
0.968627, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.905882, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.580392, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.482353, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.839216, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.611765, 
0.54902, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.482353, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.517647, 0.45098, 0.290196, 0.129412, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
0.968627, 
0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, 0.54902, \
0.482353, 
0.54902, 0.517647, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725}};\
\>", "Graphics",
  Evaluatable->True,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ 128\[Times]128\ simple\)], "Input"],

Cell[CellGroupData[{

Cell["size=Dimensions[sample]", "Input"],

Cell[BoxData[
    \({128, 128}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SamplePhoto = 
      ListDensityPlot[sample, Mesh \[Rule] False, 
        AspectRatio \[Rule] size[\([1]\)]/\((2  size[\([2]\)])\), 
        PlotLabel \[Rule] "\<Sample Photo\>"]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.00961538 0.00375601 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00962 -6 -4.5 ]
[-0.0125 .00962 0 4.5 ]
[-0.0125 .08474 -12 -4.5 ]
[-0.0125 .08474 0 4.5 ]
[-0.0125 .15986 -12 -4.5 ]
[-0.0125 .15986 0 4.5 ]
[-0.0125 .23498 -12 -4.5 ]
[-0.0125 .23498 0 4.5 ]
[-0.0125 .3101 -12 -4.5 ]
[-0.0125 .3101 0 4.5 ]
[-0.0125 .38522 -18 -4.5 ]
[-0.0125 .38522 0 4.5 ]
[-0.0125 .46034 -18 -4.5 ]
[-0.0125 .46034 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .5 .125 0 ]
[ 1 0 .125 0 ]
[.5 .5125 -38 0 ]
[.5 .5125 38 12.5625 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00962 m
.00625 .00962 L
s
[(0)] -0.0125 .00962 1 0 Mshowa
0 .08474 m
.00625 .08474 L
s
[(20)] -0.0125 .08474 1 0 Mshowa
0 .15986 m
.00625 .15986 L
s
[(40)] -0.0125 .15986 1 0 Mshowa
0 .23498 m
.00625 .23498 L
s
[(60)] -0.0125 .23498 1 0 Mshowa
0 .3101 m
.00625 .3101 L
s
[(80)] -0.0125 .3101 1 0 Mshowa
0 .38522 m
.00625 .38522 L
s
[(100)] -0.0125 .38522 1 0 Mshowa
0 .46034 m
.00625 .46034 L
s
[(120)] -0.0125 .46034 1 0 Mshowa
.125 Mabswid
0 .0284 m
.00375 .0284 L
s
0 .04718 m
.00375 .04718 L
s
0 .06596 m
.00375 .06596 L
s
0 .10352 m
.00375 .10352 L
s
0 .1223 m
.00375 .1223 L
s
0 .14108 m
.00375 .14108 L
s
0 .17864 m
.00375 .17864 L
s
0 .19742 m
.00375 .19742 L
s
0 .2162 m
.00375 .2162 L
s
0 .25376 m
.00375 .25376 L
s
0 .27254 m
.00375 .27254 L
s
0 .29132 m
.00375 .29132 L
s
0 .32888 m
.00375 .32888 L
s
0 .34766 m
.00375 .34766 L
s
0 .36644 m
.00375 .36644 L
s
0 .404 m
.00375 .404 L
s
0 .42278 m
.00375 .42278 L
s
0 .44156 m
.00375 .44156 L
s
0 .47912 m
.00375 .47912 L
s
0 .4979 m
.00375 .4979 L
s
.25 Mabswid
0 0 m
0 .5 L
s
.01923 .49375 m
.01923 .5 L
s
.16947 .49375 m
.16947 .5 L
s
.31971 .49375 m
.31971 .5 L
s
.46995 .49375 m
.46995 .5 L
s
.62019 .49375 m
.62019 .5 L
s
.77043 .49375 m
.77043 .5 L
s
.92067 .49375 m
.92067 .5 L
s
.125 Mabswid
.05679 .49625 m
.05679 .5 L
s
.09435 .49625 m
.09435 .5 L
s
.13191 .49625 m
.13191 .5 L
s
.20703 .49625 m
.20703 .5 L
s
.24459 .49625 m
.24459 .5 L
s
.28215 .49625 m
.28215 .5 L
s
.35727 .49625 m
.35727 .5 L
s
.39483 .49625 m
.39483 .5 L
s
.43239 .49625 m
.43239 .5 L
s
.50751 .49625 m
.50751 .5 L
s
.54507 .49625 m
.54507 .5 L
s
.58263 .49625 m
.58263 .5 L
s
.65775 .49625 m
.65775 .5 L
s
.69531 .49625 m
.69531 .5 L
s
.73287 .49625 m
.73287 .5 L
s
.80799 .49625 m
.80799 .5 L
s
.84555 .49625 m
.84555 .5 L
s
.88311 .49625 m
.88311 .5 L
s
.95823 .49625 m
.95823 .5 L
s
.99579 .49625 m
.99579 .5 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.99375 .00962 m
1 .00962 L
s
.99375 .08474 m
1 .08474 L
s
.99375 .15986 m
1 .15986 L
s
.99375 .23498 m
1 .23498 L
s
.99375 .3101 m
1 .3101 L
s
.99375 .38522 m
1 .38522 L
s
.99375 .46034 m
1 .46034 L
s
.125 Mabswid
.99625 .0284 m
1 .0284 L
s
.99625 .04718 m
1 .04718 L
s
.99625 .06596 m
1 .06596 L
s
.99625 .10352 m
1 .10352 L
s
.99625 .1223 m
1 .1223 L
s
.99625 .14108 m
1 .14108 L
s
.99625 .17864 m
1 .17864 L
s
.99625 .19742 m
1 .19742 L
s
.99625 .2162 m
1 .2162 L
s
.99625 .25376 m
1 .25376 L
s
.99625 .27254 m
1 .27254 L
s
.99625 .29132 m
1 .29132 L
s
.99625 .32888 m
1 .32888 L
s
.99625 .34766 m
1 .34766 L
s
.99625 .36644 m
1 .36644 L
s
.99625 .404 m
1 .404 L
s
.99625 .42278 m
1 .42278 L
s
.99625 .44156 m
1 .44156 L
s
.99625 .47912 m
1 .47912 L
s
.99625 .4979 m
1 .4979 L
s
.25 Mabswid
1 0 m
1 .5 L
s
gsave
.5 .5125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sample) show
105.000 12.813 moveto
(Photo) show
135.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
% Start of gray image
p
.01923 .00962 translate
.96154 .48076 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 144},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T1000`40O003h00Oogoo8Goo000YOol2
000MOol40003Ool2000LOol30002Ool2000IOol30004Ool2000KOol20004Ool2000GOol50002Ool2
0004Ool2000DOol500000goo000000020003Ool2000NOol002Qoo`04001oogoo000LOol00`00Oomo
o`03Ool01000Oomoo`0077oo00@007ooOol0009oo`03001oogoo01Ioo`04001oogoo0002Ool01000
Oomoo`006Goo00@007ooOol0009oo`04001oogoo000HOol01@00Oomoogoo00000Woo00@007ooOol0
009oo`03001oogoo01=oo`05001oogooOol00005Ool01000Oomoo`007Goo000XOol01000Oomoo`00
7Goo00<007ooOol00Woo00@007ooOol001Uoo`D00005Ool007ooOol0000HOol01000Oomoo`000Woo
00@007ooOol001Uoo`04001oogoo0002Ool01000Oomoo`0067oo00D007ooOomoo`00009oo`04001o
ogoo0002Ool00`00Oomoo`0COol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`007Goo000X
Ool01000Oomoo`007Woo00D007ooOomoo`00009oo`03001oogoo01Moo`04001oogoo0002Ool01000
Oomoo`0067oo0`000goo00@007ooOol001Yoo`8000=oo`04001oogoo000HOol01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo01=oo`03001oogoo00=oo`05001oogooOol00002Ool00`00
Oomoo`0KOol002Qoo`04001oogoo000LOol01000Oomoo`000Woo00@007ooOol001Yoo`03001oo`00
009oo`04001oogoo000IOol00`00Oomoo`02Ool01000Oomoo`006Goo00@007ooOol0009oo`04001o
ogoo000HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo01=oo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol06goo000YOol2000NOol20004Ool2000LOol20003Ool2
000JOol30003Ool2000KOol20004Ool2000HOol20004Ool20004Ool2000EOol20004Ool20004Ool2
000NOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo000VOooX000BOol001mo
o`8000Eoo`05001oogooOol00008Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool2000BOol001ioo`04001oogoo0004Ool01@00Oomoogoo0000
8Woo00<007ooOol087oo00<007ooOol07goo00<007ooOol087oo00<007ooOol087oo00<007ooOol0
87oo00<007ooOol03goo00<007ooOol047oo000NOol01000Oomoo`0017oo0P00i7oo0P004Woo000N
Ool01000Oomoo`0017oo00@007ooOomoocle[@<icPDe[@LicP8e[@8aS08e[BdicP8mka4icSXmk`=2
40Dmk`924096<@924003AS4icSW>00Aoo`03001oogoo011oo`007Woo00@007ooOol000Aoo`04001o
ogooOom7=Jd6>Lh3=Jd2<H`2=JdH>Lh2?Nl8>Lh4=Jd>>Lh3?Nl7>Li3?Nl5@Q02?Nl00c6<8@PQ2004
Ool00`00Oomoo`0@Ool001moo`8000Eoo`04001oogooOom7=Jd4>Lh3=Jd4<H`2=JdH>Lh2?Nl8>Lh4
=Jd>>Lh5?Nl4>Lh:?Nl5>LhZ?Nl4@Q03?Nl7@Q02=Jd2;F/00aS636<<H`04Ool00`00Oomoo`0@Ool0
02Ioo`80009oo`8icRle[@DicPDe[@DicPHe[@DicP<e[@8aS08e[AXicP8mk`<icP8mk`8icP<aS08i
cSdmk`U24003?Nm2448@00A240Lmk`03@Q16<DHa0092408e[@039BTDYABU0088@P848@<000=oo`80
019oo`009Woo00@007ooOomoo`XicQ`e[A8icP03=JdicSW>00DicP@e[@DicPLe[@`icP8e[@hicP8m
k`03>Lhmkcg_008mk`8e[@03<H`e[CF]024mk`A240`mk`E240@mk`i24003?Nm2448@00a2408icP8]
J`8Li`0336<0000000L000Aoo`03001oogoo011oo`009Woo00@007ooOomooaLicP03=JdicSW>008i
cPLe[@hicP<e[@@icP03=JdicSW>00@icPDe[@DicPLe[ATicP<mk`8icP<mk`8icP8e[@03<H`e[CF]
020mk`M240Xmk`M2408mka5240@mk`03@Q16<DHa0096<@924003=JdU:BDY008@Q0848@X000Aoo`03
001oogoo011oo`009Woo00@007ooOomoocPicP<e[@DicP8e[@LicP8e[@8aS003=JdicSW>00LicP@m
k`XicPLmk`8icP<mk`8icP<e[@8icQ`mk`92408mk`E240`mkaY2408mk`9240=6<@8mk`8aS0038@P@
Q12400848@`000Aoo`03001oogoo011oo`009Woo0P000Woo5cW>00<e[CW>>Lh0;cW>13F]23W>3Cg_
0cW>2Sg_0SW>13F]00<icSg_?Nl06Sg_148@0Sg_1D8@1cg_5D8@00<mkd8@@Q001d8@1DHa0SW>0RU:
0QS600<<H`@Q12403P000goo0P004Woo000VOol01000Oomoogoo0Sg_ACW>1SF]00<icSg_?Nl013W>
6cg_13F]0SW>5Sg_2d8@0Sg_1D8@1Cg_7T8@1DHa0Sg_00<e[BDY9BT00Q240P@Q30000P@Q0`0017oo
00<007ooOol047oo000VOol01000Oomoogoo63g_;cW>1SF]00<icSg_?Nl013W>0cg_13W>4cg_00<i
cSF]=Jd00S6<0SW>0d8@13W>33g_2D8@00<mkd8@@Q005D8@1dHa0T8@0dHa1d8@14Ha00=:DTHaAS40
0T8@0S6<00<Li`aS36<00P@Q0P0000<48@0000000P000`@Q2@0017oo00<007ooOol047oo000VOol0
1000Oomoogoo63g_13W>1cg_0cW>2cg_0cW>33g_0SW>0Sg_0SW>0cF]13W>8Cg_00<icSF]=Jd00SW>
0Sg_00=243g_?Nl02cg_=48@1dHa0Sg_00<aS2DY9BT00QBU0PQ200<48@0000000P000P@Q4@0017oo
00<007ooOol047oo000VOol01000Oomoogoo2Sg_148@0Sg_1D8@;cg_1cW>8Cg_1CW>13g_0d8@0Sg_
0d8@1cg_9D8@0THa1d8@00=6<D8@@Q000T8@0THa00=:DTHaAS400SW>0Re[00<HaQ2448@00P@Q1`00
0P@Q4@0017oo00<007ooOol047oo000VOol20002Ool>@Q02?Nl5@Q03?Nl4@Q0X?Nl5>LhS?Nl2>Lh5
?Nl:@Q07?Nl^@Q000dHa@Q124002AS42BU800dHa>LhicP02:DX26<H00`Q212448@040003124E0003
Ool2000BOol002Ioo`04001oogooOolG@Q000cg_@Q124004@Q000cg_@Q12400C@Q0>?Nl7>Lh2?Nl2
@Q0>?Nl3@Q0A?Nl4@Q03?Nlm@Q02AS44BU800cW>:DXYBP026<H236<50003124G0004Ool00`00Oomo
o`0@Ool001Qoo`@000=oo`8000Eoo`04001oogooOol2AS45@Q03AS4^@Q0:?Nl5>Lh4?Nl2@Q0??Nl2
@Q04?Nl00d8@?Nlmk`07?Nl7@Q03?NlG@Q09AS4A@Q02AS47@Q05AS42BU82?Nl00bDY5:DDY@02248Q
0004Ool00`00Oomoo`0@Ool001Qoo`03001oogoo00=oo`04001oogoo0004Ool01000Oomoogoo5dHa
:d8@1cg_1d8@2cg_248@2Cg_4d8@14Ha248@1dHa448@0THa0T8@1DHa0d8@14Ha00=:DTHaAS400SW>
0RDY00<@Q0@Q12400P@Q0P0000<48@0000002@000P@Q4@0017oo00<007ooOol047oo000IOol00`00
Oomoo`02Ool01000Oomoo`0017oo0P000Woo0TYB9THa4d8@0THa0TYB00=6<D8@@Q000Sg_0dHa13g_
4d8@0Sg_0d8@1Sg_948@1DHa148@0THa1D8@2THa148@00=6<DYBBU800TYB0THa00<icRU::DX00Q24
0PQ21`@Q7`000goo0P004Woo000JOol01@00Oomoogoo00000Woo00<007ooOol00Woo00@007ooOomo
o`Y:DPM6<@I:DQI6<@M24096<@=2408mk`@icP03?Nm2448@009240=6<@A24096<@M240=6<@E24096
<@a24096<Am240M6<@A241=6<@9240=6<@92408e[@039BTDYABU0088@R<000848@<000Aoo`03001o
ogoo011oo`0067oo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoogoo7dYB5dHa0T8@00<m
kcW>>Lh00S6<0Re[00<e[D8@@Q000TYB0Tic2THa148@1DHa0d8@0THa2D8@4dHa0d8@;THa00=:DTHa
AS400SF]0RDY00<@Q0Q224802`0000<48@0000002@000P@Q2P001`@Q17oo00<007ooOol047oo000I
Ool20004Ool20005Ool01000Oomoogoo34YB1Dic1dYB14Ha6TYB0dHa0Sg_0SF]0S6<00<mkdYBBU80
15:D00=>Ld8@@Q000T8@1dHa0d8@0THa0TYB1dHa1d8@0dHa0T8@>THa1DYB00=6<CW>>Lh00RU:0QS6
00<8@P@Q12400P0030@Q1`002@@Q0`002@@Q17oo00<007ooOol047oo000VOol20002Ool3CW<7BU86
CW<7BU800dicAS56<@04BU87CW<00dYBAS56<@04AS43@Q05AS47BU82AS42@Q000dYBE[EF]@02F]H2
IcT00ekgCW=>L`02@Q0:AS44BU82AS400d8@AS56<@02AS45@Q0]AS44BU8@AS43BU82AS400cg_:DXY
BP026<H236<00`@Q000000020003124600000`@Q00000007000E1243Ool2000BOol002Ioo`04001o
ogooOol7CW<7BU8:CW<2DY@5CW<2BU82AS42@Q000cg_=Jde[@04=Jd3<H`5=Jd2>Lh3?Nl6@Q000dic
F]IJeP02HaP2Kg/00fLiE[EF]@02BU85AS45BU82AS44?Nl00d8@AS56<@02BU87AS42BU8[AS49BU89
AS43BU82@Q000c6<7>LLi`0236<2124H000E1244Ool00`00Oomoo`0@Ool002Ioo`04001oogooOolG
CW<00dYBCW=>L`02BU82AS400d8@>LhicP02=Jd2<H`3;F/5:DX;9BT3:DX2;F/2?Nl00e:DHaQS6004
IcT00e[FCW=>L`02BU83AS42CW<4DY@00dHa>LhicP02=Jd2>Lh00d8@AS56<@04BU83AS45BU8/AS47
BU85AS45BU82@Q02=Jd00b4848@@Q0021243000;124<000E1244Ool00`00Oomoo`0@Ool002Ioo`04
001oogooOol:CW<4DY@3CW<2BU82@Q02?Nl00cW><H`aS00;;F/3:DX5;F/4:DX39BT58@P2:DX2>Lh2
CW<00fLiLiacW002JeX2E[D00dYBDYABU002F]H2G_L00f<HIcUW>@02G_L2DY@00d8@?Nlmk`02@Q03
BU82CW<<BU8CAS4;BU85AS45BU84AS45BU84AS45BU82AS400cW>9BTU:@025:D00`Q2000000020007
124900051243000G1244Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol3CW<9DY@2CW<2AS400cg_
=Jde[@04<H`00be[<H`aS007;F/2<H`3;F/9<H`2;F/7<H`00cF]@Q124002E[D2IcT3Kg/2F]H2AS40
0cg_BU9:DP02F]H2G_L00e[FE[EF]@07BU84CW<iBU84AS4:BU82AS42>Lh00be[6<HHaP0236<00`@Q
000000020005124900071243000G1244Ool00`00Oomoo`0@Ool002Ioo`80009oo`MBU0=>L`96<@8m
k`8e[@03;F/YBRU:008YBP<]J`TaS0Le[@/icPDmk`03AS5F]EJe009S609_N`03JeYW>FLi009>L`8m
k`03=JdicSW>0096<@=:DP9>L`9:DPY>LaM:DPM>LbE:DP03CW=6<DHa008mk`8]J`037>L<H`aS00`4
8@L000T48@<001L48@=oo`80019oo`009Woo00@007ooOomoo`=BU09>L`9:DP924003?NlaS36<008a
S0L]J`TaS0<e[@DicPHmk`E240E6<@9:DP03CW=BU5:D009F]@9JeP03G_MS66<H009BU096<@03>Lhe
[CF]00@e[@03@Q1>Ldic00ABU003CW=:DTYB00A:DP03CW=BU5:D00]>Lc9:DP96<@=:DP92408aS08Q
20035:D48@@Q00L48@`002<48@Aoo`03001oogoo011oo`009Woo00@007ooOomoo`9>L`03AS4mkcg_
008icP8aS0L]J``aS0<e[@8icPDmk`M240A6<@=:DP9>L`EBU09>L`9BU003E[ENmekg009BU09>L`03
BU96<DHa008icP8e[@03?Nm6<DHa025>LaE:DP9>L`U:DP=>L`]:DP03AS4e[CF]008U:@8@Q0032484
8@@Q014002D48@Aoo`03001oogoo011oo`009Woo00@007ooOomoo`8mk`03=JdaS36<00D]Ja0aS08e
[@<icP@mk`=240M6<@A:DP=>L`EBU0UF]@EBU09>L`9:DP924003?NlicSW>009:DP9>L`03DYAF]EJe
00ABU1Y>L`i:DPQ>L`A:DPE>L`9:DP96<@03BU9>Ldic00A>L`03?NlYBRU:008HaP88@P0312400000
0080000312400000008000848@L000L48@0300048@@Q01`48@Aoo`03001oogoo011oo`009Woo0P00
0Woo1Be[436<0SF]0cW>0Sg_0d8@14Ha1dYB0dic1e:D35Je1e[F0UJe15:D00=:DTHaAS400Sg_0THa
00=>Le:DDY@01e:D74ic0U:D4Dic14YB00=>LdYBBU800TYB0U:D0dic0TYB0Sg_00<U:A2448@010@Q
0`000`@Q10000P@Q1@002@@Q00<000@Q124070@Q0goo0P004Woo000VOol01000Oomoogoo1Be[336<
0SF]13W>0cg_148@0dHa14YB1dic0e:D2EJe3U[F1eJe0e:D0THa0T8@00=6<DicCW<01e:D1Dic2E:D
9Dic00=:DTicCW<01Dic0TYB0Sg_0Re[00<HaPQ224801@006@@Q00<000@Q124070@Q17oo00<007oo
Ool047oo000JOol30002Ool20005Ool01000Oomoogoo2S6<1SF]0cW>13g_0d8@14Ha1DYB1Dic1E:D
1eJe5E[F15Je0e:D0TYB0THa00=244YBBU800Tic1E:D14ic2U:D3Tic0U:D6Tic0U:D00=>LdHaAS40
0S6<0R4800<@Q0@Q12401@006@@Q00<000@Q124070@Q17oo00<007ooOol047oo000KOol01000Oomo
o`000Woo00<007ooOol00Woo00@007ooOomoo`LaS0Le[@8icPDmk`=24096<@A:DPE>L`MBU0EF]A=J
ePENm`AJePEF]@9BU09:DP=2409:DP=F]@eBU0=>L`YBU0A>L`EBU1E>L`ABU003BU8icSW>008U:@8@
Q0031240000000D003P48@Aoo`03001oogoo011oo`0067oo1@0000Eoo`00Oomoo`0000Aoo`80009o
o`DaS0Le[@8icP<mk`I24003AS5:DTYB009:DPE>L`EBU0MF]@]JeQ5Nm`AJePEF]@9BU003AS52448@
0096<@9BU003E[EBU5:D01mBU1M>L`9BU09>L`03@Q0]Jbe[008HaP8<H`031240000000848@<003P4
8@=oo`80019oo`0067oo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoogoo1c6<0cF]13W>
0Sg_0d8@1DHa14YB1Dic1E:D1eJe2E[F35kg0V<H2Ekg00=JeUJeE[D015Je00=>LdHaAS400T8@0TYB
6e:D14ic0e:D5Dic15:D0THa00<e[B488@P00Q240PQ200<48@0000000P@Q0`00>0@Q17oo00<007oo
Ool047oo000IOol00`00Ool00002Ool01000Oomoo`0017oo00@007ooOomoo`<aS0He[@<icP@mk`03
@Q16<DHa00E6<@A:DP=>L`MBU0MF]@IJePQNm`US60UNm`=JeP9F]@9JeP03E[E:DTYB00A6<@03CW=B
U5:D025BU0]>L`03DYA>Ldic00A>L`=BU09>L`8mk`03:DXDYABU0088@P848@<000848@<003P48@Ao
o`03001oogoo011oo`006Woo0P000goo0P001Goo00@007ooOomoo`8e[@DicP<mk`A240=6<@A:DPE>
L`ABU0MF]@YJePENm`9S609Nma5S60UNm`9JeP=F]@9>L`=:DP9>LaaBU0M>L`UBU003CW=:DTYB009>
L`=BU096<@8icP8Q20035:D8@PQ200D48@8000848@<003P48@Aoo`03001oogoo011oo`009Woo00@0
07ooOomoo`<icP@mk`=240I6<@=:DPE>L`IBU0EF]@YJePUNmaES60MNm`EJeP9BU0E:DP9>L`=BU0A>
L`=BU09>L`iBU0=>L`eBU0=>L`9BU09F]@03DY@mkcg_008]J`8HaP0348@8@PQ200848@L003/48@Ao
o`03001oogoo011oo`009Woo0P000Woo0SW>0cg_148@1DHa0dYB1Tic1e:D0eJe2E[F2Ukg36<H0VLi
2f<H25kg0U[F0UJe1dic:5:D1Dic15:D00=:DS6<<H`00R480QBU00<@Q0Q224800P@Q1@00?@@Q0goo
0P004Woo000VOol01000Oomoogoo0Sg_1D8@0dHa1TYB0dic2E:D0eJe2E[F35kg36<H1fLi2f<H0ekg
15[F0U:D1Dic9U:D1dic0U:D0Tic00<mkbU::DX00QS60Q2400<<H`@Q12400P@Q0`00?`@Q17oo00<0
07ooOol047oo000VOol01000Oomoogoo1D8@14Ha1dYB1Dic1e:D0UJe35[F2Ukg7V<H0Ukg1E[F0UJe
00=>LdYBBU800TYB0Tic95:D0Tic0U:D00=>Le:DDY@00U:D0TYB00<e[B488@P00QBU0Q2400<<H`@Q
12401@00?`@Q17oo00<007ooOol047oo000VOol01000Oomoogoo0d8@1THa1dYB0dic1e:D15Je35[F
2Ukg76<H15kg1E[F0UJe00=BU4YBBU800TYB0Tic65:D0Tic35:D0dic0U:D0Tic0T8@00<]JaS66<H0
0Q240`aS10@Q0`00?`@Q17oo00<007ooOol047oo000VOol20002Ool5AS45BU86CW<5DY@7E[D:F]H;
G_L8HaP2IcTIHaP7G_L00eJeDYABU005BU84CW<2DY@3CW<5DY@>CW<4DY@7CW<3DY@2@Q02;F/00acW
48@@Q00436<00`Q212448@141243Ool2000BOol002Ioo`04001oogooOol3AS44BU89CW<5DY@5E[D9
F]H<G_L9HaP5IcTGHaP7G_L00e[FDYABU002CW<5BU87CW<3DY@KCW<00e:DBU9:DP02=Jd28@P00aBU
48@@Q00248@2248X12400`Q212448@0L1244Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol2AS47
BU800dicDYABU007DY@4E[D<F]H<G_L9HaP8IcT4HaP:IcT7HaP4G_L2F]H3E[D2CW<2BU800dHaBU9:
DP02BU87CW<00e:DCW=>L`05CW<2DY@;CW<00e:DCW=>L`02BU83CW<2AS42;F/26<H548@2248Y1242
248L1244Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol5BU85CW<9DY@4E[D<F]H<G_L9HaP:IcT5
HaP4IcT:HaP4G_L3F]H2E[D2DY@2CW<3AS42BU8SCW<00dYB?Nlmk`02:DX25:D00a2436<<H`0236<2
248X1243248L1244Ool00`00Oomoo`0@Ool002Ioo`80009oo`=:DPM>L`MBU0AF]@aJeP]Nm`eS60UW
>AES60ANm`=JeP9F]@9>L`=6<@9:DQm>L`ABU003AS4e[CF]008Q208@Q0<<H`@8@Q@48@88@Ph48@L8
@Q`48@=oo`80019oo`009Woo00@007ooOomoo`=:DPM>L`]F]@aJeP]Nm`QS60AW>@ES60EW>AES60AN
m`=JeP9F]@9BU003BU96<DHa0096<@9:DQY>L`03BU9>Ldic00ABU003@Q0YBRU:008HaP<@Q08<H`@8
@Q<48@<8@P/48@X8@Q`48@Aoo`03001oogoo011oo`009Woo00@007ooOomoo`=:DPI>L`03DYAF]EJe
00UF]@aJeP]Nm`QS60EW>@IS60=W>A=S60INm`=JeP9F]@9BU003CW=6<DHa00A6<@03BU9>Ldic011>
L`03BU9>Ldic00A>L`03BU9>Ldic009BU09>L`03>LhQ2248008HaP8DY@0348@<H`aS00L8@Q048@<8
@PT48@h8@QX48@Aoo`03001oogoo011oo`0067oo0`0017oo0P001Goo00@007ooOomoo`E>L`EBU0UF
]@aJeQ1Nm`AS60aW>AIS60INm`=JePAF]@03DYA:DTYB00E6<@A:DP=>L`A:DP=>L`9:DP9>L`E:DPM>
L`8icP039BTDYABU00@DY@0348@8@PQ200L8@PT48B48@QX48@Aoo`03001oogoo011oo`0067oo00@0
07ooOol0009oo`04001oogoo0004Ool01000Oomoogoo1Dic15:D2UJe35[F1ekg1V<H0ekg16<H00=W
>F<HHaP02FLi5V<H2Ekg0U[F0UJe00=BU4icCW<01DHa5dYB1Dic0TYB0SF]00<Q212448@00QBU0QS6
00<@Q0Q224800PQ20P@Q0`Q22@@Q0`Q210aS6PQ25`@Q0`Q217oo00<007ooOol047oo000HOol01000
Oomoo`000Woo00@007ooOol000Aoo`80009oo`9>L`QBU0MF]@iJePeNm`=S60iW>AQS60UNm`AJeP03
E[E>Ldic009:DP=6<@9240a:DP96<@U:DP=>L`8mk`8YBP036<H@Q12400@DY@0336<8@PQ200T8@P<4
8@88@PD<H`8@Q08<H`D8@PD48A08@QL48@<8@P=oo`80019oo`0067oo0`000goo00@007ooOol000Ao
o`04001oogooOol2CW<7DY@8E[D>F]H=G_L5HaP<IcTHHaP9G_L4F]H00eJeDYABU002CW<2BU800dHa
@Q124002AS4:BU82AS49BU800dicBU9:DP02>Lh29BT00aBU36<<H`045:D00`aS2488@P0724851242
248236<27>L00aS65:DDY@0236<72483124>248L1244Ool00`00Oomoo`0@Ool001Uoo`03001oogoo
009oo`04001oogoo0004Ool01000Oomoogoo0Tic1E:D2UJe3U[F2ekg1F<H3VLi66<H2Ekg15[F0eJe
0U:D0Tic00=6<D8@@Q000THa2TYB0THa2DYB00=>LdHaAS400S6<0QcW00<@Q0aS36<0112400<<H`Q2
248010Q220@Q0PQ20PaS0R4800<LiaBU5:D00PaS60Q26P@Q0PQ217oo00<007ooOol047oo000IOol3
0003Ool20005Ool01000Oomoogoo1E:D2eJe3U[F25kg1f<H46Li66<H2Ekg1E[F0UJe0U:D0Tic00=:
DTHaAS400T8@00=6<DYBBU8014YB1DHa0TYB00=6<DYBBU801DYB0Sg_0Re[0QS600<@Q0aS36<00QBU
0Q2400<<H`Q2248030@Q0PaS0Q240aS60QBU0PaS60Q26@@Q0`Q217oo00<007ooOol047oo000VOol2
0002Ool5DY@7E[DBF]H8G_L9HaP>IcTJHaP7G_L5F]H2E[D4DY@00dYBAS56<@03@Q0@AS45BU82>Lh2
9BT25:D00`aS48@@Q0025:D248@00`aS2488@P0;1243248736<E248236<3248G12452483Ool2000B
Ool002Ioo`04001oogooOol3DY@7E[DBF]H>G_L9HaP?IcTIHaP3G_L2F]H2G_L00e[FE[EF]@04E[D0
0e:DBU9:DP02AS400d8@?Nlmk`04@Q0:AS42BU82AS400d8@<H`aS0027>L248@536<5248912422483
12452484124A248436<5248212432487124>2484Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol3
DY@7E[DBF]H:G_L9HaP5IcT4HaP<IcTGHaP3G_L2F]H3G_L2F]H4E[D00e:DBU9:DP02AS400d8@?Nlm
k`05@Q06AS400d8@AS56<@02BU82AS400cg_;F/]J`026<H548@236<2248<124:248412452482124:
248436<5248212432487124>2484Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol:E[D>F]H>G_L7
HaP4IcT7HaP00fLiHaQS6004HaP5IcTAHaP=G_L5F]H2E[D00e:DCW=>L`02CW<00dHa?Nlmk`02?Nl5
@Q04AS43@Q02BU82AS400cF]9BTU:@026<H548@236<C12422483124C248436<924800`@Q2488@P04
2485124<2484Ool00`00Oomoo`0@Ool002Ioo`80009oo`UF]@mJePiNm`US609W>@MS6003IcUS66<H
00AS60EW>A5S60ANm`9S60MNm`EJeP=F]@9BU09>L`03BU92448@00M240A6<@=24096<@924003=JdU
:BDY008HaP8DY@0348@<H`aS0088@Q448@@8@P<48A<8@P@<H`T8@P031248@PQ200@8@P<48@h8@P=o
o`80019oo`009Woo00@007ooOomoo`MF]A5JePiNma9S6003IcUS66<H00AS60EW>@aS609Nm`ES609N
m`=S60INm`MJeP03E[EBU5:D009BU003BU96<DHa00A24003?Nm2448@0096<@E24096<@924003<H`Q
2248008HaP8DY@0348@<H`aS0088@Q448AX8@P@<H`T8@P031248@PQ200@8@P031248@PQ200h8@PAo
o`03001oogoo011oo`009Woo00@007ooOomoo`MF]A5JePiNm`iS60EW>@MS609W>@iS609Nm`YS60IN
m`MJeP=F]@9BU003CW=:DTYB0096<@924003?Nm2448@00M24096<@8mk`03;F/Q2248008HaP8DY@03
48@8@PQ201848A/8@P@<H`T8@P031248@PQ201D8@PAoo`03001oogoo011oo`009Woo00@007ooOomo
o`MF]A5JeP]Nm`aS60YW>@9S60AW>A5S609Nm`YS60ANm`UJeP=F]@9BU0=>L`9:DP9240<mk`U2408e
[@039BTHaQS6008DY@8<H`0324848@@Q01048Ad8@P@<Hb48@PAoo`03001oogoo011oo`009Woo00@0
07ooOomoo`MF]@iJePaNm`aS60aW>@9S60AW>A5S609Nm`YS60INm`MJePEF]@03DYA>Ldic009:DP96
<@03@Q0mkcg_00@mk`=2408mk`8aS0038@PDYABU008DY@8<H`0324848@@Q00L48@88@P<48B48@P8<
Hb<8@PAoo`03001oogoo011oo`009Woo0P000Woo0UJe4E[F3Ukg36<H4VLi3f<H15kg2V<H1Ukg25[F
15Je0e:D0Tic0TYB00=243g_?Nl01Cg_0T8@0Sg_0Re[00<LiaBU5:D00Q240PaS00<8@P@Q12401`@Q
0PQ20P@Q8PQ20PaS8`Q20goo0P004Woo000VOol01000Oomoogoo0eJe3U[F45kg36<H3VLi4V<H0ekg
2F<H0VLi00=S65kgG_L00V<H0ekg1e[F1EJe0U:D0Tic0dYB0T8@0SW>0cg_0T8@0Sg_0RU:00<HaQ24
48@00PaS0PQ21`@Q00<8@P@Q12401`@Q1`Q20P@Q4@Q21`aS80Q200<<H`Q2248017oo00<007ooOol0
47oo000IOol20004Ool20005Ool01000Oomoogoo0UJe3U[F3ekg46<H2VLi56<H0ekg36<H1ekg1e[F
1EJe0U:D14ic00=:DT8@@Q000SW>0cg_0T8@0SW>0RU:00<HaQ2448@00PaS0PQ21`@Q0`Q21`@Q1`Q2
0P@Q4`Q21@aS8`Q217oo00<007ooOol047oo000HOol01000Oomoo`000Woo00@007ooOol000Aoo`04
001oogooOol2E[D<F]HAG_LBHaP7IcTFHaP2G_L<HaP7G_L9F]H3E[D4DY@2CW<00dYBAS56<@02?Nl2
>Lh3?Nl2>Lh29BT00aBU48@@Q00236<224871243248712472482124C248536<Q248236<4Ool00`00
Oomoo`0@Ool001Qoo`04001oogoo0002Ool01000Oomoo`0017oo0P000Woo0UJe35[F4Ekg56<H1FLi
96<H1ekg2E[F1EJe0U:D0dic0THa0T8@0cW>0Sg_0SF]0RDY00<DY@aS36<00PaS2@@Q1@Q21@@Q1`Q2
0P@Q4`Q21@aS8@Q20PaS0goo0P004Woo000IOol20003Ool01000Oomoo`0017oo00@007ooOomooa1J
eQ5Nm`iS60UW>BIS60]Nm`=JePEF]@ABU003CW=:DTYB0096<@8mk`03>Lhe[CF]008aS08Q20035:D<
H`aS0088@Q<48@L8@P848A<8@PD<Hb48@P8<H`Aoo`03001oogoo011oo`0067oo00@007ooOol0009o
o`04001oogoo0004Ool01000Oomoogoo45[F25kg0V<H1ekg2f<H3FLi9F<H2ekg1U[F0UJe1E:D0Tic
0TYB0T8@00<icSF]=Jd00Re[0R4800<DY@aS36<00PQ24`@Q1`Q20P@Q4@Q21`aS8`Q217oo00<007oo
Ool047oo000IOol20004Ool20005Ool01000Oomoogoo45[F25kg16<H1Ekg2F<H4FLi8f<H35kg1E[F
0UJe1E:D14ic0THa00<mkcF]=Jd00Re[0QcW00<DY@aS36<05@@Q1`Q20P@Q4@Q21`aS8`Q217oo00<0
07ooOol047oo000VOol20002Ool>F]H>G_L3HaP2G_L9HaP>IcTAHaP4IcT00f<HG_MNm`04G_L:HaP;
G_L8F]H4E[D00e:DCW=>L`02CW<2BU800d8@=Jde[@02:DX27>L00a2436<<H`0>248212492485124>
248836<R24800`@Q2488@P03Ool2000BOol002Ioo`04001oogooOol>F]H>G_L9HaP00fLiHaQS6002
HaP>IcTAHaP2IcT3HaP4G_L<HaP;G_L8F]H4E[D00e:DCW=>L`02CW<2BU800dHa>LhicP02:DX27>L0
0a2436<<H`022485124U248>36<O2484Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol>F]H>G_L9
HaP00fLiHaQS600>IcTHHaP4G_L<HaP<G_L7F]H4E[D00e:DCW=>L`02CW<3BU82?Nl2;F/27>L00a24
2488@P022485124Q248@36<Q2484Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol<F]H@G_L5HaP5
IcT4HaP>IcT5HaP2IcT?HaP4G_L>HaP:G_L7F]H5E[D2DY@5CW<2AS42=Jd28@P00a242488@P0>2482
124J248236<00`Q236<<H`0936<Q2484Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol<F]H<G_L9
HaP5IcT2HaPHIcT>HaP4G_L3HaP4G_L7HaP<G_L7F]H3E[D4DY@3CW<2BU82?Nl2:DX00a242488@P0<
2484124J248<36<S2484Ool00`00Oomoo`0@Ool002Ioo`80009oo`aJePaNm`MS60IW>@03HaQW>FLi
01QW>AES60ANm`US60aNm`MJeP=F]@ABU0=>L`96<@8aS0035:D8@PQ200h8@P848AP8@PD<H`H@Q0L<
Hal8@P=oo`80019oo`009Woo00@007ooOomoo`aJePaNm`MS60IW>@03HaQW>FLi01YW>A=S60ANm`US
60aNm`QJeP9F]@9BU09F]@=>L`9:DP8icP036<H8@PQ2008<Hb@8@PL<H`8@Q0@DY@0348@<H`aS00@<
Ha`8@P0336<8@PQ200Aoo`03001oogoo011oo`009Woo00@007ooOomoo`EJeQ=Nm`US625W>B1S60aN
m`MJePEF]@9>L`03E[EBU5:D009:DP8mk`038@P8@PQ200h8@P848AX8@P8<H`0348@HaQS6008HaP8D
Y@0348@<H`aS0088@P8<Hal8@PAoo`03001oogoo011oo`009Woo00@007ooOomoo`EJeQ=Nm`IS62AW
>A=S60ANm`US6003G_MS66<H009S60QNm`MJePAF]@9BU003E[EBU5:D009>L`9240039BT@Q12400h8
@P848AX8@P8<H`0348@HaQS6008HaP8DY@0348@<H`aS00@<Hal8@PAoo`03001oogoo011oo`009Woo
0P000Woo1E[F4ekg1V<H96Li4f<H15kg1F<H15kg1f<H1Ukg1e[F15Je1e:D0THa00<]JaBU5:D01@Q2
0PaS8@Q210aS00<DYB488@P00R480QBU00<@Q0aS36<00PaS8@Q20goo0P004Woo000VOol01000Oomo
ogoo1E[F35kg2f<H46Li0f]J4FLi5F<H15kg1f<H1Ekg16<H1Ukg1e[F15Je1e:D0TYB00<icR488@P0
1@Q20PaS5`Q20`aS1`Q210aS00<Q23F]=Jd00SF]0R4800<@Q0aS36<08`Q217oo00<007ooOol047oo
000BOol50002Ool20004Ool20005Ool01000Oomoogoo0e[F3Ekg2V<H2fLi00=[FVLiIcT00VLi2V]J
3VLi86<H0ekg1f<H0ekg2E[F15Je1E:D0Tic00=242U::DX00PaS0`Q210aS5@Q21@aS1@Q210aS00<Q
23F]=Jd00SF]0R4800<@Q0aS36<02@Q20P@Q60Q217oo00<007ooOol047oo000DOol01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`04001oogooOol>G_L:HaP;IcTAJeX>IcT/HaP3
G_L;F]H5DY@2CW<00dHa;F/]J`025:D3248236<G248336<7248436<00acW;F/]J`02;F/27>L00a24
36<<H`0436<32484124H2484Ool00`00Oomoo`0@Ool001Aoo`05001oogooOol00002Ool01000Oomo
o`000Woo00<007ooOol00Woo0P000Woo3Ukg2V<H2fLi4F]J3VLi8f<H16Li1F<H0ekg2e[F1E:D0Tic
00=:DSF]=Jd00QBU0`Q210aS4`Q20PaS2PQ210aS00<HaRDY9BT00RDY0QBU00<@Q0aS36<010aS0`Q2
10@Q60Q20goo0P004Woo000DOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009o
o`04001oogooOol@G_L5HaP>IcT>JeX3IcT2JeX<IcTPHaP3G_L2HaP3JeX4HaP00ekgF]IJeP04G_L7
F]H00eJeDYABU002E[D2DY@00dYB>LhicP026<H236<00`Q236<<H`0236<C248436<6248436<248@0
0aS67>LLi`027>L25:D348@236<Q2484Ool00`00Oomoo`0@Ool001Aoo`05001oogooOol00002Ool0
1000Oomoo`000Woo00<007ooOol00Woo00@007ooOomoo`9Nm`03F]INmekg00]Nm`ES60aW>AE[FPaW
>B5S609Nm`9S60=[FP9W>@9S60MNm`MJeP03E[EBU5:D009F]@9BU003BU8mkcg_008Li`8<H`03248<
H`aS008<Ha<8@P@<H`<8@P8<H`03248<H`aS008<H`8@Q0035:DHaQS6008HaP8DY@0348@<H`aS008<
Hb48@PAoo`03001oogoo011oo`004goo0P0017oo0P0017oo0P001Goo00@007ooOomoo`9JePaNm`MS
60YW>AU[FPiW>B5S609W>@=[FP=S60INm`MJeP03E[EBU5:D009F]@9BU003CW=6<DHa008YBP8@Q003
248<H`aS008<H`88@P0336<8@PQ201D8@P8<H`<8@P8<H`<@Q0@DY@8@Q0D<Hb48@PAoo`03001oogoo
011oo`009Woo00@007ooOomoo`iNm`ES60]W>@i[FP03Kg][FV]J00U[FPiW>AQS609Nm`US60=W>@=S
60INm`QJePAF]@9BU003CW=6<DHa008]J`8DY@03248<H`aS008<H`88@P0336<8@PQ20088@P8<Ha48
@P<<H`88@P@<H`L@Q0L<H`<8@PL48AD8@PAoo`03001oogoo011oo`009Woo0P000Woo3Ukg0f<H3FLi
1F]J0fmk16]J1Fmk2F]J3fLi1f<H0VLi7f<H1Ukg0e[F0Ukg0e[F15Je0U:D00=>LdYBBU800S6<0QS6
00<8@PaS36<00PaS0PQ200<<H`Q224800PQ20PaS4@Q20`aS0PQ210aS1A241@aS1`Q21`@Q10Q220@Q
2@Q20goo0P004Woo000VOol01000Oomoogoo35kg1F<H2fLi0f]J46mk2F]J66Li7f<H1Ukg0e[F0Ukg
0e[F15Je0e:D0Tic0SF]0QS61@aS0PQ200<<H`Q224805@Q20`aS0PQ23PaS1`Q21`@Q10Q22P@Q1`Q2
17oo00<007ooOol047oo000VOol01000Oomoogoo35kg1F<H2FLi1F]J4Vmk1f]J66Li4V<H0ekg36<H
15kg0e[F0Ukg1e[F0e:D0Tic0SW>0QS600<<H`Q224801@aS40Q20PaS1@Q20`aS0PQ23PaS1`Q21`@Q
10Q22P@Q1`Q217oo00<007ooOol047oo000VOol01000Oomoogoo2Ekg1f<H26Li1V]J1Fmk1G>L1fmk
2F]J3VLi:f<H15kg1E[F0Ukg0e[F15Je00=BU4YBBU800Sg_0R481`aS00<8@PaS36<02`Q21@aS20Q2
40aS1@Q23@@Q1`Q21`@Q0`Q217oo00<007ooOol047oo000VOol20002Ool9G_L5HaP:IcT6JeX3Kg/9
Li`2Kg/00g>LKg]_N`02Kg/8JeX=IcT[HaP5G_L4F]H2G_L3F]H4E[D00e:DCW=>L`02@Q028@P736<0
0`Q236<<H`0>248236<8248B36<3248@1242248912432483Ool2000BOol002Ioo`04001oogooOol7
G_L5HaP9IcT5JeX4Kg/5Li`5Mkd5Li`7Kg/5JeX>IcTZHaP9G_L7F]H3E[D2CW<2AS42:DX00a2436<<
H`0736<@248236<6248@36<4248L12432484Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol5G_L7
HaP7IcT7JeX4Kg/3Li`7Mkd5Li`4Kg/2JeX00fmkJeY[FP02JeX?IcT7HaP2IcT5HaP2IcTJHaP;G_L5
F]H3E[D2CW<2AS42:DX00a2436<<H`02248536<@248236<6248636<3248536<6248O1244Ool00`00
Oomoo`0@Ool002Ioo`04001oogooOol5G_L5HaP9IcT4JeX5Kg/2Li`<Mkd3Li`4Kg/2JeX00fmkJeY[
FP02JeXAIcT4HaP3IcTLHaP2IcT3HaP;G_L5F]H3E[D2DY@2AS42:DX00a2436<<H`02248536<@2482
36<6248@36<4248O1244Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol5G_L4HaP8IcT6JeX3Kg/4
Li`00gNmNmikgP07Nmh2Mkd5Li`2Kg/2JeX00fmkJeY[FP03JeXGIcT>HaP2IcT<HaP2IcT00f<HG_MN
m`0;G_L00e[FG_MNm`02F]H3E[D2DY@2AS42:DX00a2436<<H`02248536<@248236<6248@36<4248O
1244Ool00`00Oomoo`0@Ool002Ioo`80009oo`ENm`AS60QW>@A[FP=_N`AcW0=g_@UkgPAg_@=cW0E_
N`E[FQUW>@aS609W>@mS60eNm`03F]INmekg009JeP=F]@9BU09:DP8YBP0336<8@PQ200848@D<H`D8
@P8<H`T8@P8<H`H8@Q0<H`@8@Ql48@=oo`80019oo`009Woo00@007ooOomoo`YS60IW>@E[FP9_N`=c
W0Ag_@=kgPEoo`AkgP9g_@=cW0A_N`E[FQQW>AmS60eNm`EJeP=F]@9BU096<@8YBP0348@48@@Q00L8
@PT<H`X8@PD<H`H8@PX<H`@8@Ql48@Aoo`03001oogoo011oo`004Woo1@0000=oo`0000000P000goo
0P001Goo00@007ooOomoo`YS60AW>@E[FP9_N`=cW09g_@AkgPQoo`AkgP9g_@=cW0E_N`A[FQaW>@QS
609W>A5S60eNm`EJeP=F]@9BU096<@8]J`035:D8@PQ200@48@L8@PD<Hb48@R448@Aoo`03001oogoo
011oo`0057oo00D007ooOomoo`0000Eoo`04001oogoo0004Ool01000Oomoogoo1f<H1fLi0f]J16mk
0W>L00=g_G_NNmh00W_N37oo0W_N0WNm0g>L1Fmk16]J7FLi76<H2ekg1E[F0eJe0U:D0THa0Re[00<D
Y@Q2248010@Q00<8@P@Q12401@Q210aS70Q200<<H`Q224800PQ28@@Q17oo00<007ooOol047oo000D
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000Woo1F<H1fLi1F]J0Vmk17>L
00=g_G_NNmh03Woo0W_N0gNm0W>L1Fmk16]J76Li7F<H2Ekg1e[F0eJe0U:D0THa0Re[00<DY@aS36<0
0PQ20P@Q00<8@P@Q12400PQ20P@Q6PQ200<<H`Q2248010Q200<<H`Q224800PQ28@@Q0goo0P004Woo
000DOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00@007ooOomoo`=S60MW
>@I[FP=_N`9cW09g_@03Nmioogoo00ioo`AkgP03MkecW7>L00E_N`E[FQMW>B=S60MNm`MJeP=F]@9B
U09:DP8aS0036<H<H`aS0088@P848@0324848@@Q0088@P<48B<8@R<48@Aoo`03001oogoo011oo`00
57oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool01000Oomoogoo0f<H1VLi
1F]J0fmk0W>L17Nm00=kgWooOol047oo0W_N00=g_G>LLi`01Fmk1F]J6FLi2F<H0fLi36<H0Ukg0f<H
0Ukg16<H1Ekg1e[F0eJe0U:D0TYB0SF]00<Q212448@00PQ20P@Q00<8@P@Q12400PQ20`@Q0PQ20P@Q
3PQ20`aS3PQ28`@Q17oo00<007ooOol047oo000COol20004Ool20004Ool20005Ool01000Oomoogoo
0V<H1FLi1F]J16mk0g>L0WNm0g_N4Woo0W_N00=g_G>LLi`01Fmk1F]J9FLi36<H1ekg16<H1Ekg1e[F
0eJe0U:D0TYB0Sg_00<U:ABU5:D00PQ20P@Q1@Q20`@Q0PQ21`@Q2@Q21`aS2PQ28`@Q17oo00<007oo
Ool047oo000VOol20002Ool7IcT7JeX2Kg/00g>LMkeg_@02Mkd3Nmh@Ool4Nmh00gNmLiacW002Kg/2
JeX00fmkJeY[FP05JeXNIcTEHaP<G_L7F]H3E[D2CW<2AS42@Q000c6<7>LLi`0236<5248412400`Q2
12448@071245248436<5248236<3248236<5248S1243Ool2000BOol002Ioo`04001oogooOol7IcT3
JeX6Kg/00g>LMkeg_@04NmhAOol2Nmh3Mkd2Li`2Kg/2JeX3Kg/<JeX2IcT3JeXBIcTEHaP<G_L2F]H0
0ekgF]IJeP02F]H2E[D00e:DCW=>L`04AS400cg_<H`aS0027>L236<3248B124?248236<5248S1244
Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol5IcT5JeX4Kg/3Li`2Mkd4NmhAOol2Nmh3Mkd2Li`7
Kg/CJeX@IcT7HaP3IcT<HaP;G_L2F]H3G_L2F]H2E[D00e:DBU9:DP02AS43@Q02>Lh29BT248@3248C
124;248536<3248U1244Ool00`00Oomoo`0@Ool002Ioo`04001oogooOol5IcT5JeX4Kg/3Li`2Mkd2
NmhAOol4Nmh3Mkd2Li`5Kg/7JeX7IcT7JeX@IcT7HaP3IcT<HaP;G_L2F]H3G_L2F]H2E[D00e:DBU9:
DP02AS42?Nl00dHa@Q124002<H`26<H00`aS2488@P02248F124>248U1244Ool00`00Oomoo`0@Ool0
02Ioo`05001oogooOol00008Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00
Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00
Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00
Oomoo`05Ool00`00Oomoo`06Ool2000BOol002IoonP0019oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol008Moo`<009Ioo`00R7oo00<007ooOol0UGoo001fOol30003Ool70000
1Goo001oo`00Ool00`000goo0`0017oo0`001goo0`000goo0`0000=oo`0000000Woo0P0017oo0P00
17oo0P00IGoo001fOol01000Oomoo`000Woo10000Woo00L007oo001oo`00Ool00002Ool01@00Oomo
ogoo000017oo00<007ooOol02Goo00<007ooOol00goo00@007ooOol0009oo`04001oogoo0002Ool0
1000Oomoo`000Woo00@007ooOol006Aoo`00NGoo00<007ooOol00goo00X007ooOol007oo001oo`00
Ool0009oo`05001oogooOol00004Ool40008Ool30003Ool01000Oomoo`000Woo00@007ooOol0009o
o`03001oogoo00=oo`04001oogoo001TOol007Moo`8000Aoo`<00007Ool00000001oo`00Ool01000
17oo00<007ooOol00goo0P002Goo00@007ooOol0009oo`<000Aoo`80009oo`D000=oo`8006Eoo`00
MWoo00@007ooOol001Eoo`03001oogoo00ioo`04001oogoo0002Ool00`00Oomoo`09Ool00`00Oomo
o`1[Ool007Ioo`@001Aoo`8000moo`@0009oo`8007Uoo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-24.5616, -16.2479, 0.575512, \
1.15102}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(sample2 = sample;\)\)], "Input"],

Cell["\<\
Do[sample2[[i,j]]=0,
\t\t{i,50,52},{j,30, 32}];\
\>", "Input"],

Cell[BoxData[
    \(\(bsample = sample2;\)\)], "Input"],

Cell[BoxData[
    \(\(SamplePhoto = 
        ListDensityPlot[sample, \n\tMesh -> False, \n\t
          PlotLabel -> "\<Bad Sample Photo\>", \n\t
          DisplayFunction -> Identity];\)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
BadSamplePhoto=ListDensityPlot[bsample,
\tMesh->False,
\tPlotLabel->\"Bad Sample Photo\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SamplePhoto,BadSamplePhoto}]];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -50 0 ]
[.5 1.0125 50 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Bad) show
87.000 12.813 moveto
(Sample) show
129.000 12.813 moveto
(Photo) show
159.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -50 0 ]
[.5 1.0125 50 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Bad) show
87.000 12.813 moveto
(Sample) show
129.000 12.813 moveto
(Photo) show
159.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC600000000CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C600000000CECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C600000000CECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{652.813, 310.813},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:<0001=Q000`40O003h00OogooogooSWoo003o
OoooOon>Ool00?mooomoohioo`00ogooogooSWoo003oOoooOon>Ool00?mooomoohioo`00ogooogoo
SWoo003oOoooOon>Ool002aoo`8002=oo`@000=oo`80025oo`<0009oo`8001moo`<000Aoo`80021o
o`8000Aoo`8001aoo`D0009oo`8000Aoo`8001Uoo`D00003Ool00000008000=oo`8004aoo`80029o
o`@000=oo`80025oo`<0009oo`8001moo`<000Aoo`80021oo`8000Aoo`8001aoo`D0009oo`8000Ao
o`8001Uoo`D00003Ool00000008000=oo`8002=oo`00:goo00@007ooOol0029oo`03001oogoo00=o
o`04001oogoo000QOol01000Oomoo`000Woo00<007ooOol077oo00@007ooOol0009oo`04001oogoo
000NOol01000Oomoo`000Woo00@007ooOol001eoo`05001oogooOol00002Ool01000Oomoo`000Woo
00<007ooOol067oo00D007ooOomoo`0000Eoo`04001oogoo001:Ool01000Oomoo`008Goo00<007oo
Ool00goo00@007ooOol0025oo`04001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@0
07ooOol001ioo`04001oogoo0002Ool01000Oomoo`007Goo00D007ooOomoo`00009oo`04001oogoo
0002Ool00`00Oomoo`0HOol01@00Oomoogoo00001Goo00@007ooOol0029oo`00:goo00@007ooOol0
02=oo`03001oogoo009oo`04001oogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009o
o`04001oogoo000NOol01000Oomoo`000Woo00@007ooOol001eoo`05001oogooOol00002Ool01000
Oomoo`000Woo00<007ooOol067oo00<007ooOol00Woo00<007ooOol00Woo00@007ooOol004Yoo`04
001oogoo000ROol00`00Oomoo`02Ool01000Oomoo`007Woo1@0000Eoo`00Oomoo`0001ioo`04001o
ogoo0002Ool01000Oomoo`007Woo00@007ooOol0009oo`04001oogoo000MOol01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo01Qoo`03001oogoo009oo`03001oogoo009oo`04001oogoo
000ROol002]oo`04001oogoo000TOol01@00Oomoogoo00000Woo00<007ooOol077oo00@007ooOol0
009oo`04001oogoo000NOol30003Ool01000Oomoo`007goo0P000goo00@007ooOol001eoo`05001o
ogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo00<007ooOol00goo00D007ooOomoo`00
009oo`03001oogoo04Qoo`04001oogoo000SOol01@00Oomoogoo00000Woo00<007ooOol077oo00@0
07ooOol0009oo`04001oogoo000NOol30003Ool01000Oomoo`007goo0P000goo00@007ooOol001eo
o`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo00<007ooOol00goo00D007oo
Oomoo`00009oo`03001oogoo021oo`00:goo00@007ooOol0029oo`04001oogoo0002Ool01000Oomo
o`007goo00<007oo00000Woo00@007ooOol001moo`03001oogoo009oo`04001oogoo000NOol01000
Oomoo`000Woo00@007ooOol001eoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0
67oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`18Ool01000Oomoo`008Goo00@0
07ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<007ooOol00Woo
00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`007Goo00D007ooOomoo`00009oo`04001o
ogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo021o
o`00;7oo0P0097oo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P0017oo0P007Goo
0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P00C7oo0P008goo0P0017oo0P008Goo0P000goo
0P0087oo0`000goo0P0087oo0P0017oo0P007Goo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo
0P008goo003oOoooOon>Ool00?mooomoohioo`00ogooogooSWoo003oOoooOon>Ool00?mooomoohio
o`00:7ooo`003@00>Gooo`003@004goo000XOol00`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomo
o`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomo
o`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomo
o`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomo
o`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomo
o`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool2000iOol0
0`00Oomoo`02Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool0
0`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool0
0`00Oomoo`08Ool00`00Oomoo`07Ool2000COol002Qoo`03001oogoo009oo`03001oogoo02Ioo`03
001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Eoo`03
001oogoo019oo`03001oogoo03Moo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03
001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo01=oo`03
001oogoo015oo`00:7oo00<007ooOol0ogoo2Goo00<007ooOol0=goo00<007ooOol0ogoo2Goo00<0
07ooOol04Goo000QOol20005Ool00`00Oomoo`3oOol9Ool00`00Oomoo`0`Ool20005Ool00`00Oomo
o`3oOol9Ool00`00Oomoo`0AOol0021oo`04001oogoo0004Ool00`00Oomoo`3oOol9Ool00`00Oomo
o`0_Ool01000Oomoo`0017oo00<007ooOol0ogoo2Goo00<007ooOol04Goo000POol01000Oomoo`00
17oo0`00ogoo1goo0`00<Goo00@007ooOol000Aoo`<00?moo`Moo`<001=oo`0087oo00@007ooOol0
00Aoo`03001oogoo009oodPe[@@icPHe[@PicP8e[@8aS08e[CDicP8mka@icT8mk`A240Hmk`924096
<@924096<@8icPEoo`03001oogoo02moo`04001oogoo0004Ool00`00Oomoo`02Oom8=Jd4>Lh6=Jd8
>Lh2=Jd2<H`2=Jde>Lh2?NlD>Li2?Nl4@Q06?Nl2@Q02AS42@Q02AS42>Lh5Ool00`00Oomoo`0AOol0
021oo`04001oogoo0004Ool00`00Oomoo`02Oom8=Jd4>Lh6=Jd8>Lh2=Jd2<H`2=Jde>Lh2?NlD>Li2
?Nl4@Q06?Nl2@Q02AS42@Q02AS42>Lh5Ool00`00Oomoo`0_Ool01000Oomoo`0017oo00<007ooOol0
0WooB3F]13W>1SF]23W>0SF]0S6<0SF]=CW>0Sg_53W>@Sg_148@1Sg_0T8@0THa0T8@0THa0SW>1Goo
00<007ooOol04Goo000QOol20005Ool00`00Oomoo`02OomB=Jd6>Lh4=Jd2<H`2=JdL>Lh2?Nl;>Lh4
=Jd@>Lh4?Nl8>Li<?Nl6@Q02?Nl2<H`28@P5Ool00`00Oomoo`0`Ool20005Ool00`00Oomoo`02OomB
=Jd6>Lh4=Jd2<H`2=JdL>Lh2?Nl;>Lh4=Jd@>Lh4?Nl8>Li<?Nl6@Q02?Nl2<H`28@P5Ool00`00Oomo
o`0AOol002Qoo`03001oogoo009ooe8e[@HicP@e[@8aS08e[A`icP8mk`/icP@e[A0icP@mk`PicT`m
k`I2408mk`8aS08Q20Eoo`03001oogoo03Moo`03001oogoo009ooe8e[@HicP@e[@8aS08e[A`icP8m
k`/icP@e[A0icP@mk`PicT`mk`I2408mk`8aS08Q20Eoo`03001oogoo015oo`00:7oo00<007ooOol0
0WooDSF]13W>13F]136<0SF]73W>0Sg_2cW>13F]43W>1Sg_13W>33g_1SW><3g_148@13g_248@0SF]
0Re[0QS60PaS1Goo00<007ooOol0=goo00<007ooOol00WooDSF]13W>13F]136<0SF]73W>0Sg_2cW>
13F]43W>1Sg_13W>33g_1SW><3g_148@13g_248@0SF]0Re[0QS60PaS1Goo00<007ooOol04Goo000X
Ool00`00Oomoo`02OomB=Jd4>Lh4=Jd4<H`2=JdL>Lh2?Nl;>Lh4=Jd@>Lh6?Nl4>Lh<?Nl6>Lh`?Nl4
@Q04?Nl8@Q02=Jd2;F/26<H236<5Ool00`00Oomoo`0gOol00`00Oomoo`02OomB=Jd4>Lh4=Jd4<H`2
=JdL>Lh2?Nl;>Lh4=Jd@>Lh6?Nl4>Lh<?Nl6>Lh`?Nl4@Q04?Nl8@Q02=Jd2;F/26<H236<5Ool00`00
Oomoo`0AOol002Qoo`03001oogoo009ooc`e[@8icPPe[@8icPXe[@@icP@e[@8aS0@e[A`icP8mk`Di
cP8mk`8icP@aS08e[@@mk`PicQ@mk`8icRPmk`A2408mk`A240Hmk`A2408mk`8icP8mk`A6<@8mk`8a
S08Li`8@Q0@000Eoo`03001oogoo03Moo`03001oogoo009ooc`e[@8icPPe[@8icPXe[@@icP@e[@8a
S0@e[A`icP8mk`DicP8mk`8icP@aS08e[@@mk`PicQ@mk`8icRPmk`A2408mk`A240Hmk`A2408mk`8i
cP8mk`A6<@8mk`8aS08Li`8@Q0@000Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo?3F]0SW>
23F]0SW>2SF]13W>13F]0S6<13F]73W>0Sg_1CW>0Sg_0SW>136<0SF]13g_23W>53g_0SW>:3g_148@
0Sg_148@1Sg_148@0Sg_0SW>0Sg_14Ha0Sg_0S6<0QcW0Q2410001Goo00<007ooOol0=goo00<007oo
Ool00Woo?3F]0SW>23F]0SW>2SF]13W>13F]0S6<13F]73W>0Sg_1CW>0Sg_0SW>136<0SF]13g_23W>
53g_0SW>:3g_148@0Sg_148@1Sg_148@0Sg_0SW>0Sg_14Ha0Sg_0S6<0QcW0Q2410001Goo00<007oo
Ool04Goo000XOol00`00Oomoo`02Ool2>Lhf=Jd6>Lh6=Jd6>Lh6=Jd6>Lh4=Jd2<H`2=JdN>Lh2?Nl5
>Lh2?Nl2>Lh4<H`2>Li6?Nl:@Q02?Nl6@Q08?Nl2@Q02AS42@Q02=Jd29BT25:D2248212440005Ool0
0`00Oomoo`0gOol00`00Oomoo`02Ool2>Lhf=Jd6>Lh6=Jd6>Lh6=Jd6>Lh4=Jd2<H`2=JdN>Lh2?Nl5
>Lh2?Nl2>Lh4<H`2>Li6?Nl:@Q02?Nl6@Q08?Nl2@Q02AS42@Q02=Jd29BT25:D2248212440005Ool0
0`00Oomoo`0AOol002Qoo`8000=oo`8icSHe[@HicPHe[@HicPHe[@HicP@e[@8aS08e[AhicP8mk`Di
cP8mk`8icP@aS08icTHmk`Y2408mk`I240Pmk`924096<@92408e[@8U:@8DY@88@P848@@000Aoo`80
03Uoo`8000=oo`8icSHe[@HicPHe[@HicPHe[@HicP@e[@8aS08e[AhicP8mk`DicP8mk`8icP@aS08i
cTHmk`Y2408mk`I240Pmk`924096<@92408e[@8U:@8DY@88@P848@@000Aoo`8001=oo`00:7oo00<0
07ooOol00Woo33W>83F]53W>0SF]23W>13F]1SW>23F]3SW>0SF]43W>0Sg_0SW>1Cg_0SF]0S6<0SF]
9Sg_148@3Sg_1T8@13g_448@0Sg_448@0SW>0Re[0QcW0PaS2P001Goo00<007ooOol0=goo00<007oo
Ool00Woo33W>83F]53W>0SF]23W>13F]1SW>23F]3SW>0SF]43W>0Sg_0SW>1Cg_0SF]0S6<0SF]9Sg_
148@3Sg_1T8@13g_448@0Sg_448@0SW>0Re[0QcW0PaS2P001Goo00<007ooOol04Goo000XOol00`00
Oomoo`02Ool<>LhP=JdD>Lh2=Jd8>Lh4=Jd6>Lh8=Jd>>Lh2=Jd@>Lh2?Nl2>Lh5?Nl2=Jd2<H`2=JdV
?Nl4@Q0>?Nl6@Q04?Nl@@Q02?Nl@@Q02>Lh2;F/27>L236<:0005Ool00`00Oomoo`0gOol00`00Oomo
o`02Ool<>LhP=JdD>Lh2=Jd8>Lh4=Jd6>Lh8=Jd>>Lh2=Jd@>Lh2?Nl2>Lh5?Nl2=Jd2<H`2=JdV?Nl4
@Q0>?Nl6@Q04?Nl@@Q02?Nl@@Q02>Lh2;F/27>L236<:0005Ool00`00Oomoo`0AOol002Qoo`03001o
ogoo009ooaXicP8e[@@icPPe[A0icP@e[@@icP8e[@HicPHe[@HicPPe[A`icP@mk`8icPDmk`8icP8e
[@8aS08e[B@mk`Q240`mk`Q2408mkaA240@mk`9240A6<@92408e[@8U:@8@Q0848@`000Eoo`03001o
ogoo03Moo`03001oogoo009ooaXicP8e[@@icPPe[A0icP@e[@@icP8e[@HicPHe[@HicPPe[A`icP@m
k`8icPDmk`8icP8e[@8aS08e[B@mk`Q240`mk`Q2408mkaA240@mk`9240A6<@92408e[@8U:@8@Q084
8@`000Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo6SW>0SF]13W>23F]43W>13F]13W>0SF]
1SW>1SF]1SW>23F]73W>13g_0SW>1Cg_0SW>0SF]0S6<0SF]93g_248@33g_248@0Sg_548@13g_0T8@
14Ha0T8@0SF]0RDY0Q240P@Q30001Goo00<007ooOol0=goo00<007ooOol00Woo6SW>0SF]13W>23F]
43W>13F]13W>0SF]1SW>1SF]1SW>23F]73W>13g_0SW>1Cg_0SW>0SF]0S6<0SF]93g_248@33g_248@
0Sg_548@13g_0T8@14Ha0T8@0SF]0RDY0Q240P@Q30001Goo00<007ooOol04Goo000XOol00`00Oomo
o`02Oom0>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd:>Lh4?Nl<>Lh8?Nl2>Lh5?Nl2>Lh4=Jd2>LhP?Nl2
@Q02?Nl6@Q0>?NlN@Q02?Nl2@Q04AS42?Nl2<H`28@P248@2124>0005Ool00`00Oomoo`0gOol00`00
Oomoo`02Oom0>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd:>Lh4?Nl<>Lh8?Nl2>Lh5?Nl2>Lh4=Jd2>LhP
?Nl2@Q02?Nl6@Q0>?NlN@Q02?Nl2@Q04AS42?Nl2<H`28@P248@2124>0005Ool00`00Oomoo`0AOol0
02Qoo`03001oogoo009ood0icP@e[@HicP8e[@PicP8e[@8aS08e[@XicP@mk``icPPmk`8icPDmk`8i
cP@e[@8icR0mk`92408mk`I240hmkai2408mk`9240A6<@8mk`8aS08Q208@Q0848@h000Eoo`03001o
ogoo03Moo`03001oogoo009ood0icP@e[@HicP8e[@PicP8e[@8aS08e[@XicP@mk``icPPmk`8icPDm
k`8icP@e[@8icR0mk`92408mk`I240hmkai2408mk`9240A6<@8mk`8aS08Q208@Q0848@h000Eoo`03
001oogoo015oo`00:7oo00<007ooOol00Woo6SW>0SF]>3W>13F]2SW>3Sg_13W>33g_0cW>13F]0SW>
83g_148@0Sg_1T8@23g_648@0Sg_2T8@1THa0SW>0RU:0QS60PaS0P@Q40001Goo00<007ooOol0=goo
00<007ooOol00Woo6SW>0SF]>3W>13F]2SW>3Sg_13W>33g_0cW>13F]0SW>83g_148@0Sg_1T8@23g_
648@0Sg_2T8@1THa0SW>0RU:0QS60PaS0P@Q40001Goo00<007ooOol04Goo000XOol00`00Oomoo`02
OolJ>Lh2=Jdh>Lh4=Jd:>Lh>?Nl4>Lh<?Nl3>Lh4=Jd2>LhP?Nl4@Q02?Nl6@Q08?NlH@Q02?Nl:@Q06
AS42>Lh2:DX26<H236<2124@0005Ool00`00Oomoo`0gOol00`00Oomoo`02OolJ>Lh2=Jdh>Lh4=Jd:
>Lh>?Nl4>Lh<?Nl3>Lh4=Jd2>LhP?Nl4@Q02?Nl6@Q08?NlH@Q02?Nl:@Q06AS42>Lh2:DX26<H236<2
124@0005Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`8mke0icPHe[@8icP8mk`@icR0mk`De
[@8icQXmk`a2408mk`I240Hmkb9240I6<@8mk`8e[@8U:@8@Q0848@h000848@@000Eoo`03001oogoo
03Moo`03001oogoo009oo`8mke0icPHe[@8icP8mk`@icR0mk`De[@8icQXmk`a2408mk`I240Hmkb92
40I6<@8mk`8e[@8U:@8@Q0848@h000848@@000Eoo`03001oogoo015oo`00:7oo0P000goo0Sg_D3W>
1SF]0SW>0Sg_13W>83g_1CF]0SW>6Sg_348@0Sg_1T8@1Sg_8T8@1THa0Sg_0SF]0RDY0Q240P@Q3P00
0P@Q100017oo0P00>Goo0P000goo0Sg_D3W>1SF]0SW>0Sg_13W>83g_1CF]0SW>6Sg_348@0Sg_1T8@
1Sg_8T8@1THa0Sg_0SF]0RDY0Q240P@Q3P000P@Q100017oo0P004goo000XOol00`00Oomoo`02OolL
?Nlf>Lh6=Jd2>Lh2?Nl4>Lh4?Nl4>LhF?Nl2>Lh3=Jd2<H`2>Lh4@Q04>Lh>?Nl:@Q02?NlJ@Q08AS42
@Q04AS48@Q04AS42BU82AS42@Q02<H`27>L236<21242000212440004124:0005Ool00`00Oomoo`0g
Ool00`00Oomoo`02OolL?Nlf>Lh6=Jd2>Lh2?Nl4>Lh4?Nl4>LhF?Nl2>Lh3=Jd2<H`2>Lh4@Q04>Lh>
?Nl:@Q02?NlJ@Q08AS42@Q04AS48@Q04AS42BU82AS42@Q02<H`27>L236<21242000212440004124:
0005Ool00`00Oomoo`0AOol002Qoo`03001oogoo009ooa`mkcHicPHe[@8icP8mk`@icP@mk`@icQHm
k`8icP<e[@8aS08icPA240@icPhmk`Y2408mkaY240Q6<@9240A6<@Q240A6<@9:DP96<@92408aS08L
i`8<H`848@8000848@@000@48@X000Eoo`03001oogoo03Moo`03001oogoo009ooa`mkcHicPHe[@8i
cP8mk`@icP@mk`@icQHmk`8icP<e[@8aS08icPA240@icPhmk`Y2408mkaY240Q6<@9240A6<@Q240A6
<@9:DP96<@92408aS08Li`8<H`848@8000848@@000@48@X000Eoo`03001oogoo015oo`00:7oo00<0
07ooOol00Woo63g_23W>23g_13W>63g_23W>0Sg_0SW>1SF]13W>6Sg_13W>1Sg_0SW>1CF]0SW>1Sg_
0SW>13g_6T8@13g_848@14Ha0Sg_0T8@1THa0SW>0Re[0QcW0PaS0P@Q0P000P@Q50001Goo00<007oo
Ool0=goo00<007ooOol00Woo63g_23W>23g_13W>63g_23W>0Sg_0SW>1SF]13W>6Sg_13W>1Sg_0SW>
1CF]0SW>1Sg_0SW>13g_6T8@13g_848@14Ha0Sg_0T8@1THa0SW>0Re[0QcW0PaS0P@Q0P000P@Q5000
1Goo00<007ooOol04Goo000XOol00`00Oomoo`02OolH?Nl8>Lh8?Nl4>LhH?Nl8>Lh2?Nl2>Lh6=Jd4
>LhJ?Nl4>Lh6?Nl2>Lh5=Jd2>Lh6?Nl2>Lh4?NlJ@Q04?NlP@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L2
36<212420002124D0005Ool00`00Oomoo`0gOol00`00Oomoo`02OolH?Nl8>Lh8?Nl4>LhH?Nl8>Lh2
?Nl2>Lh6=Jd4>LhJ?Nl4>Lh6?Nl2>Lh5=Jd2>Lh6?Nl2>Lh4?NlJ@Q04?NlP@Q04AS42?Nl2@Q06AS42
>Lh2;F/27>L236<212420002124D0005Ool00`00Oomoo`0AOol002Qoo`03001oogoo009ooa`mk`@i
cPPmk`@icP`mk`@icPhmk`8icP8mk`8icP@e[@@icRHmk`8icP<e[@8icP8mk`9240hmkca240Q6<@8m
k`8aS08U:@8DY@88@P848@@000848A@000Eoo`03001oogoo03Moo`03001oogoo009ooa`mk`@icPPm
k`@icP`mk`@icPhmk`8icP8mk`8icP@e[@@icRHmk`8icP<e[@8icP8mk`9240hmkca240Q6<@8mk`8a
S08U:@8DY@88@P848@@000848A@000Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo73g_13W>
23g_13W>33g_13W>3Sg_0SW>0Sg_0SW>13F]13W>9Sg_0SW>0cF]0SW>0Sg_0T8@3Sg_?48@24Ha0Sg_
0S6<0RDY0QBU0PQ20P@Q10000P@Q50001Goo00<007ooOol0=goo00<007ooOol00Woo73g_13W>23g_
13W>33g_13W>3Sg_0SW>0Sg_0SW>13F]13W>9Sg_0SW>0cF]0SW>0Sg_0T8@3Sg_?48@24Ha0Sg_0S6<
0RDY0QBU0PQ20P@Q10000P@Q50001Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool<?Nl4@Q02
?Nl6@Q0f?Nl8>LhV?Nl7>Lh4?Nl4@Q02?Nl4@Q08?NlZ@Q02AS48@Q02AS44@Q02AS42BU82AS42>Lh2
;F/26<H248@212480002124D0005Ool00`00Oomoo`0gOol00`00Oomoo`02Ool<?Nl4@Q02?Nl6@Q0f
?Nl8>LhV?Nl7>Lh4?Nl4@Q02?Nl4@Q08?NlZ@Q02AS48@Q02AS44@Q02AS42BU82AS42>Lh2;F/26<H2
48@212480002124D0005Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo``mk`A2408mk`I243Hm
k`PicRHmk`LicP@mk`A2408mk`A240PmkbY24096<@Q24096<@A24096<@9:DP96<@8icP8]J`8HaP8@
Q0848@P000848A@000Eoo`03001oogoo03Moo`03001oogoo009oo``mk`A2408mk`I243Hmk`PicRHm
k`LicP@mk`A2408mk`A240PmkbY24096<@Q24096<@A24096<@9:DP96<@8icP8]J`8HaP8@Q0848@P0
00848A@000Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo448@0Sg_1T8@13g_148@;Sg_1SW>
:3g_0SW>1cg_348@23g_=48@0THa0T8@0THa0TYB0THa0SW>0RU:0QS60PQ20P@Q100010@Q60001Goo
00<007ooOol0=goo00<007ooOol00Woo448@0Sg_1T8@13g_148@;Sg_1SW>:3g_0SW>1cg_348@23g_
=48@0THa0T8@0THa0TYB0THa0SW>0RU:0QS60PQ20P@Q100010@Q60001Goo00<007ooOol04Goo000X
Ool20003Ool@@Q02?Nl6@Q04?Nl4@Q0^?Nl6>LhX?Nl2>Lh7?Nl<@Q08?Nld@Q02AS42@Q02AS42BU82
AS42>Lh2:DX26<H2248212440004124H0004Ool2000iOol20003Ool@@Q02?Nl6@Q04?Nl4@Q0^?Nl6
>LhX?Nl2>Lh7?Nl<@Q08?Nld@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124H0004
Ool2000COol002Qoo`03001oogoo009ooaY2408mk`I2408mkaQ2410mk`PicP8mk`92410mk`A241@m
k`E240@mkdI24096<@A:DP8icP8YBP8HaP8<H`H000@48AX000Eoo`03001oogoo03Moo`03001oogoo
009ooaY2408mk`I2408mkaQ2410mk`PicP8mk`92410mk`A241@mk`E240@mkdI24096<@A:DP8icP8Y
BP8HaP8<H`H000@48AX000Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo6T8@0Sg_1T8@0Sg_
648@43g_23W>0Sg_0T8@43g_148@53g_1D8@13g_AT8@0THa14YB0SW>0RU:0QS60PaS1P0010@Q6P00
1Goo00<007ooOol0=goo00<007ooOol00Woo6T8@0Sg_1T8@0Sg_648@43g_23W>0Sg_0T8@43g_148@
53g_1D8@13g_AT8@0THa14YB0SW>0RU:0QS60PaS1P0010@Q6P001Goo00<007ooOol04Goo000XOol0
0`00Oomoo`02Ool2AS46@Q04AS4d@Q0<?Nl6>Lh4?Nl2@Q0B?Nl2@Q04?Nl2@Q0:?Nl9@Q04?NlJ@Q0:
AS4D@Q02AS48@Q06AS42BU82?Nl29BT25:D2248V0005Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2
AS46@Q04AS4d@Q0<?Nl6>Lh4?Nl2@Q0B?Nl2@Q04?Nl2@Q0:?Nl9@Q04?NlJ@Q0:AS4D@Q02AS48@Q06
AS42BU82?Nl29BT25:D2248V0005Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`96<@I240A6
<CA240`mk`HicP@mk`92418mk`9240@mk`9240Xmk`U240@mkaY240Y6<AA24096<@Q240I6<@9:DP8m
k`8U:@8DY@88@RH000Eoo`03001oogoo03Moo`03001oogoo009oo`96<@I240A6<CA240`mk`HicP@m
k`92418mk`9240@mk`9240Xmk`U240@mkaY240Y6<AA24096<@Q240I6<@9:DP8mk`8U:@8DY@88@RH0
00Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo6THa<T8@23g_248@33g_2T8@2Sg_5d8@14Ha
2T8@24Ha4T8@0THa0T8@1THa148@14Ha0TYB0THa0SW>0RDY0Q2410@Q0P000P@Q30000P@Q50001Goo
00<007ooOol0=goo00<007ooOol00Woo6THa<T8@23g_248@33g_2T8@2Sg_5d8@14Ha2T8@24Ha4T8@
0THa0T8@1THa148@14Ha0TYB0THa0SW>0RDY0Q2410@Q0P000P@Q30000P@Q50001Goo00<007ooOol0
4Goo000XOol00`00Oomoo`02OolJAS4b@Q08?Nl8@Q0<?Nl:@Q0:?NlG@Q04AS4:@Q08AS4B@Q02AS42
@Q06AS44@Q04AS42BU82AS42>Lh29BT248@412420002124<0002124D0005Ool00`00Oomoo`0gOol0
0`00Oomoo`02OolJAS4b@Q08?Nl8@Q0<?Nl:@Q0:?NlG@Q04AS4:@Q08AS4B@Q02AS42@Q06AS44@Q04
AS42BU82AS42>Lh29BT248@412420002124<0002124D0005Ool00`00Oomoo`0AOol002Qoo`03001o
ogoo009ooaY6<@Q240Y6<B1240@mkb9240@mk`8icP@mka5240Y6<@Y240I6<A1240I6<@9240a6<@A:
DP8icP8U:@8DY@P48@H000@48AH000@48@Eoo`03001oogoo03Moo`03001oogoo009ooaY6<@Q240Y6
<B1240@mkb9240@mk`8icP@mka5240Y6<@Y240I6<A1240I6<@9240a6<@A:DP8icP8U:@8DY@P48@H0
00@48AH000@48@Eoo`03001oogoo015oo`006Woo10000goo0P001Goo00<007ooOol00Woo6THa248@
2THa848@13g_8T8@13g_0SW>13g_4D8@2THa2T8@1THa448@1THa0T8@34Ha14YB0SW>0RDY0QBU20@Q
1P0010@Q5P0010@Q1Goo00<007ooOol0:Goo10000goo0P001Goo00<007ooOol00Woo6THa248@2THa
848@13g_8T8@13g_0SW>13g_4D8@2THa2T8@1THa448@1THa0T8@34Ha14YB0SW>0RDY0QBU20@Q1P00
10@Q5P0010@Q1Goo00<007ooOol04Goo000JOol00`00Oomoo`03Ool01000Oomoo`0017oo00<007oo
Ool00Woo0TYB;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:d8@1THa148@0THa
1T8@34Ha148@0THa14YB0THa0SW>0RU:0Q240PQ220@Q90001Goo00<007ooOol0:Goo00<007ooOol0
0goo00@007ooOol000Aoo`03001oogoo009oo`9:DRa6<AI24096<@9:DP96<@92408mk`A6<@@mkaI2
408mk`A240Hmkb]240I6<@A24096<@I240a6<@A24096<@A:DP96<@8icP8YBP8@Q088@PP48B@000Eo
o`03001oogoo015oo`006goo00<007ooOol00Woo00@007ooOol000Aoo`<0009oo`9:DRa6<AI24096
<@9:DP96<@92408mk`A6<@@mkaI2408mk`A240Hmkb]240I6<@A24096<@I240a6<@A24096<@A:DP96
<@8icP8YBP8@Q088@PP48B@000=oo`<002aoo`03001oogoo009oo`04001oogoo0004Ool30002Ool2
BU8/AS4F@Q02AS42BU82AS42@Q02?Nl4AS44?NlF@Q02?Nl4@Q06?Nl[@Q06AS44@Q02AS46@Q0<AS44
@Q02AS44BU82AS42>Lh2:DX248@22488124T0003Ool3000COol001aoo`05001oogooOol00002Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool<BU88AS46BU8JAS48@Q02AS44@Q02?Nl4>Lh2?Nl4@Q04AS44
@Q02AS48@Q04AS46@Q02AS4>@Q02AS4U@Q08AS44@Q0FAS42@Q04AS42@Q02=Jd29BT25:D2248X0002
12440005Ool00`00Oomoo`0[Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo
34YB24Ha1TYB6THa248@0THa148@0Sg_13W>0Sg_148@14Ha148@0THa248@14Ha1T8@0THa3T8@0THa
9D8@24Ha148@5THa0T8@14Ha0T8@0SF]0RDY0QBU0PQ2:0000P@Q10001Goo00<007ooOol04Goo000J
Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009oo`a:DPQ6<@I:DQY6<@Q24096<@A2
408mk`@icP8mk`A240A6<@A24096<@Q240A6<@I24096<@i24096<BE240Q6<@A241I6<@9240A6<@92
408e[@8U:@8DY@88@RP000848@@000Eoo`03001oogoo02Uoo`04001oogoo0002Ool01000Oomoo`00
17oo00<007ooOol00Woo34YB24Ha1TYB6THa248@0THa148@0Sg_13W>0Sg_148@14Ha148@0THa248@
14Ha1T8@0THa3T8@0THa9D8@24Ha148@5THa0T8@14Ha0T8@0SF]0RDY0QBU0PQ2:0000P@Q10001Goo
00<007ooOol04Goo000KOol20004Ool20005Ool00`00Oomoo`02OolTBU8JAS42@Q02?Nl2>Lh2<H`2
;F/2=Jd2@Q02BU82CW<<AS44@Q06AS44@Q02AS4:@Q0GAS44@Q0dAS42BU82AS42=Jd29BT248@2248<
0002124<0002124<00081245Ool00`00Oomoo`0ZOol20004Ool20005Ool00`00Oomoo`02OolTBU8J
AS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02BU82CW<<AS44@Q06AS44@Q02AS4:@Q0GAS44@Q0dAS42BU82
AS42=Jd29BT248@2248<0002124<0002124<00081245Ool00`00Oomoo`0AOol002Qoo`03001oogoo
009oobA:DQY6<@92408mk`8icP8aS08]J`8e[@92409:DP9>L`a6<@A240I6<@A24096<@Y241M6<@A2
43A6<@9:DP96<@8e[@8U:@8@Q088@P`000848@`000848@`000P48@Eoo`03001oogoo03Moo`03001o
ogoo009oobA:DQY6<@92408mk`8icP8aS08]J`8e[@92409:DP9>L`a6<@A240I6<@A24096<@Y241M6
<@A243A6<@9:DP96<@8e[@8U:@8@Q088@P`000848@`000848@`000P48@Eoo`03001oogoo015oo`00
:7oo00<007ooOol00Woo3TYB1Tic24YB14Ha7TYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@24Ha
148@0THa0TYB24Ha248@14Ha0T8@@dHa1TYB0THa0SW>0RU:0QS60PQ20P@Q0P003P@Q20002P@Q1000
2P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo3TYB1Tic24YB14Ha7TYB14Ha0Sg_0SF]0S6<0Sg_
0TYB15:D0Tic148@24Ha148@0THa0TYB24Ha248@14Ha0T8@@dHa1TYB0THa0SW>0RU:0QS60PQ20P@Q
0P003P@Q20002P@Q10002P@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool>BU86CW<8BU84
AS4NBU84AS42?Nl2=Jd2<H`2?Nl2BU84DY@2CW<4@Q08AS44@Q02AS42BU88AS48@Q04AS42@Q13AS46
BU82AS42>Lh2:DX26<H224821242000>1248000:1244000:1245Ool00`00Oomoo`0gOol00`00Oomo
o`02Ool>BU86CW<8BU84AS4NBU84AS42?Nl2=Jd2<H`2?Nl2BU84DY@2CW<4@Q08AS44@Q02AS42BU88
AS48@Q04AS42@Q13AS46BU82AS42>Lh2:DX26<H224821242000>1248000:1244000:1245Ool00`00
Oomoo`0AOol002Qoo`03001oogoo009oo`A>L`Q:DPI>L`Q:DP9>L`96<@A:DPQ>L`9:DPI6<@A240I6
<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240a6<@A:DP96<@9240A6<@I243E6<@A:DQ96<@A:
DP96<@8mk`8YBP8HaP8<H`848@@000@48@H000848@X001P48@Eoo`03001oogoo03Moo`03001oogoo
009oo`A>L`Q:DPI>L`Q:DP9>L`96<@A:DPQ>L`9:DPI6<@A240I6<@Q:DP96<@92409:DP9F]@9JeP9W
>@9Nm`9>L`9240a6<@A:DP96<@9240A6<@I243E6<@A:DQ96<@A:DP96<@8mk`8YBP8HaP8<H`848@@0
00@48@H000848@X001P48@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo14ic24YB1Tic24YB
0Tic0THa14YB24ic0TYB1THa148@1THa24YB0THa0T8@0TYB0UJe0U[F0VLi0Ukg0Tic0T8@34Ha14YB
0THa0T8@14Ha1T8@=DHa14YB4THa14YB0THa0Sg_0RU:0QS60PaS0P@Q100010@Q1P000P@Q2P0060@Q
1Goo00<007ooOol0=goo00<007ooOol00Woo14ic24YB1Tic24YB0Tic0THa14YB24ic0TYB1THa148@
1THa24YB0THa0T8@0TYB0UJe0U[F0VLi0Ukg0Tic0T8@34Ha14YB0THa0T8@14Ha1T8@=DHa14YB4THa
14YB0THa0Sg_0RU:0QS60PaS0P@Q100010@Q1P000P@Q2P0060@Q1Goo00<007ooOol04Goo000XOol0
0`00Oomoo`02Ool8CW<8BU8<CW<2DY@6CW<2BU82AS42@Q02?Nl6=Jd4<H`6=Jd2>Lh4?Nl6@Q02CW<2
F]H2HaP2Kg/2IcT2E[D2BU86AS46BU82AS44?Nl2@Q02AS42BU88AS42BU8cAS4:BU8:AS44BU82@Q02
<H`27>L236<2124L000H1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool8CW<8BU8<CW<2DY@6CW<2
BU82AS42@Q02?Nl6=Jd4<H`6=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2IcT2E[D2BU86AS46BU82AS44
?Nl2@Q02AS42BU88AS42BU8cAS4:BU8:AS44BU82@Q02<H`27>L236<2124L000H1245Ool00`00Oomo
o`0AOol002Qoo`8000=oo`Q>L`Q:DPa>L`9BU0I>L`9:DP96<@92408mk`He[@@aS0He[@8icP@mk`I2
409>L`9JeP9S609_N`9W>@9F]@9:DPI6<@I:DP96<@@mk`924096<@9:DPQ6<@9:DS=6<@Y:DPY6<@A:
DP92408aS08Li`8<H`848A`001P48@Aoo`8003Uoo`8000=oo`Q>L`Q:DPa>L`9BU0I>L`9:DP96<@92
408mk`He[@@aS0He[@8icP@mk`I2409>L`9JeP9S609_N`9W>@9F]@9:DPI6<@I:DP96<@@mk`924096
<@9:DPQ6<@9:DS=6<@Y:DPY6<@A:DP92408aS08Li`8<H`848A`001P48@Aoo`8001=oo`00:7oo00<0
07ooOol00Woo6Tic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:32DY12U:0Re[0Sg_0U:D0V<H
16Li0U[F0Tic0TYB14Ha0Tic15:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha1TYB<dHa24YB1THa1TYB
0T8@0SF]0R480Q240P@Q100030@Q3P0060@Q1Goo00<007ooOol0=goo00<007ooOol00Woo6Tic0TYB
0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:32DY12U:0Re[0Sg_0U:D0V<H16Li0U[F0Tic0TYB14Ha
0Tic15:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha1TYB<dHa24YB1THa1TYB0T8@0SF]0R480Q240P@Q
100030@Q3P0060@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02OolJCW<2BU82CW<2BU82AS42
@Q02>Lh2=Jd2<H`4;F/6:DX<9BT4:DX2;F/2?Nl2DY@2HaP4IcT2F]H2CW<2BU84AS42CW<4DY@2AS42
>Lh2=Jd2>Lh2@Q02AS44BU84AS46BU8cAS48BU86AS46BU82@Q02=Jd28@P248@21244000<124>000H
1245Ool00`00Oomoo`0gOol00`00Oomoo`02OolJCW<2BU82CW<2BU82AS42@Q02>Lh2=Jd2<H`4;F/6
:DX<9BT4:DX2;F/2?Nl2DY@2HaP4IcT2F]H2CW<2BU84AS42CW<4DY@2AS42>Lh2=Jd2>Lh2@Q02AS44
BU84AS46BU8cAS48BU86AS46BU82@Q02=Jd28@P248@21244000<124>000H1245Ool00`00Oomoo`0A
Ool002Qoo`03001oogoo009ooa9>L`ABU09>L`9:DP96<@@mk`8e[@8aS08]J`hYBP@U:@8Q208Li`PH
aP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP9W>@9S609F]@9240@aS092409:DP96<@a:DQU6<A9:
DPi6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P@48@8000H48@8000848A@001@48@Eoo`03001oogoo
03Moo`03001oogoo009ooa9>L`ABU09>L`9:DP96<@@mk`8e[@8aS08]J`hYBP@U:@8Q208Li`PHaP8Q
208icP9JeP9_N`9cW09W>@9F]@IBU09JeP9W>@9S609F]@9240@aS092409:DP96<@a:DQU6<A9:DPi6
<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P@48@8000H48@8000848A@001@48@Eoo`03001oogoo015o
o`00:7oo00<007ooOol00Woo4Tic15:D0Tic0TYB0THa13g_0SF]0S6<0Re[3RU:12DY0R480QcW21S6
0R480SW>0U[F0Vmk0W>L0VLi0UJe1U:D0U[F0VLi0V<H0UJe0T8@136<0T8@0TYB0THa34YB6DHa4TYB
3THa14YB14Ha1TYB0THa0SW>0RDY0QBU0PQ210@Q0P001P@Q0P000P@Q500050@Q1Goo00<007ooOol0
=goo00<007ooOol00Woo4Tic15:D0Tic0TYB0THa13g_0SF]0S6<0Re[3RU:12DY0R480QcW21S60R48
0SW>0U[F0Vmk0W>L0VLi0UJe1U:D0U[F0VLi0V<H0UJe0T8@136<0T8@0TYB0THa34YB6DHa4TYB3THa
14YB14Ha1TYB0THa0SW>0RDY0QBU0PQ210@Q0P001P@Q0P000P@Q500050@Q1Goo00<007ooOol04Goo
000XOol00`00Oomoo`02Ool<CW<4DY@4CW<2BU82@Q02?Nl2>Lh2<H`<;F/4:DX6;F/4:DX49BT68@P2
:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2HaP2IcT2G_L2DY@2@Q02?Nl2@Q04BU82CW<>
BU8GAS4<BU86AS46BU84AS46BU84AS46BU82AS42>Lh29BT25:D224840008124:00061244000J1245
Ool00`00Oomoo`0gOol00`00Oomoo`02Ool<CW<4DY@4CW<2BU82@Q02?Nl2>Lh2<H`<;F/4:DX6;F/4
:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2HaP2IcT2G_L2DY@2@Q02?Nl2
@Q04BU82CW<>BU8GAS4<BU86AS46BU84AS46BU84AS46BU82AS42>Lh29BT25:D224840008124:0006
1244000J1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`a>L`ABU0A>L`9:DP92408mk`8i
cP8aS0`]J`@YBPH]J`@YBP@U:@HQ208YBP8icP9>L`9W>@9cW09[FP9F]@9:DP9BU09JeP9Nm`9S609W
>@9Nm`9BU092408mk`9240A:DP9>L`i:DQM6<@a:DPI6<@I:DPA6<@I:DPA6<@I:DP96<@8icP8U:@8D
Y@88@P@000P48@X000H48@@001X48@Eoo`03001oogoo03Moo`03001oogoo009oo`a>L`ABU0A>L`9:
DP92408mk`8icP8aS0`]J`@YBPH]J`@YBP@U:@HQ208YBP8icP9>L`9W>@9cW09[FP9F]@9:DP9BU09J
eP9Nm`9S609W>@9Nm`9BU092408mk`9240A:DP9>L`i:DQM6<@a:DPI6<@I:DPA6<@I:DPA6<@I:DP96
<@8icP8U:@8DY@88@P@000P48@X000H48@@001X48@Eoo`03001oogoo015oo`00:7oo00<007ooOol0
0Woo14ic2U:D0Tic0THa0Sg_0SF]136<0Re[0S6<22e[0S6<12e[2S6<0Re[236<0SF]0T8@0UJe0VLi
16mk0U[F0THa0Sg_0TYB0U[F0Ukg0U[F0UJe24YB14ic@dYB14Ha34YB0THa0SW>0Re[0QS60PaS0P@Q
10001P@Q2P0020@Q10006P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo14ic2U:D0Tic0THa0Sg_
0SF]136<0Re[0S6<22e[0S6<12e[2S6<0Re[236<0SF]0T8@0UJe0VLi16mk0U[F0THa0Sg_0TYB0U[F
0Ukg0U[F0UJe24YB14ic@dYB14Ha34YB0THa0SW>0Re[0QS60PaS0P@Q10001P@Q2P0020@Q10006P@Q
1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool4CW<:DY@2CW<2AS42?Nl2=Jd4<H`2;F/2<H`8
;F/2<H`4;F/:<H`2;F/8<H`2=Jd2@Q02E[D2IcT4Kg/2F]H2AS42?Nl2BU82F]H2G_L2F]H2E[D8BU84
CW=3BU84AS4<BU82AS42>Lh2;F/26<H236<212440006124:00081244000J1245Ool00`00Oomoo`0g
Ool00`00Oomoo`02Ool4CW<:DY@2CW<2AS42?Nl2=Jd4<H`2;F/2<H`8;F/2<H`4;F/:<H`2;F/8<H`2
=Jd2@Q02E[D2IcT4Kg/2F]H2AS42?Nl2BU82F]H2G_L2F]H2E[D8BU84CW=3BU84AS4<BU82AS42>Lh2
;F/26<H236<212440006124:00081244000J1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009o
o`QBU0A>L`96<@8mk`8e[@8]J`@YBP@]J`XaS0Pe[@`icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8m
k`8e[@8icP96<@A:DP9>L`9:DPa>La]:DPQ>LbY:DP9>L`96<@8mk`8]J`8Li`8<H`h48@P000X48@@0
01X48@Eoo`03001oogoo03Moo`03001oogoo009oo`QBU0A>L`96<@8mk`8e[@8]J`@YBP@]J`XaS0Pe
[@`icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP9>L`9:DPa>La]:DPQ>LbY:
DP9>L`96<@8mk`8]J`8Li`8<H`h48@P000X48@@001X48@Eoo`03001oogoo015oo`00:7oo0P000goo
25:D14ic0THa0Sg_0SF]0Re[12U:12e[2S6<23F]33W>1Sg_0THa0UJe0V<H0Vmk0V]J0VLi0Tic0Sg_
0SF]0SW>0THa14YB0Tic0TYB34ic6dYB24ic:TYB0Tic0THa0Sg_0Re[0QcW0PaS3P@Q20002P@Q1000
6P@Q17oo0P00>Goo0P000goo25:D14ic0THa0Sg_0SF]0Re[12U:12e[2S6<23F]33W>1Sg_0THa0UJe
0V<H0Vmk0V]J0VLi0Tic0Sg_0SF]0SW>0THa14YB0Tic0TYB34ic6dYB24ic:TYB0Tic0THa0Sg_0Re[
0QcW0PaS3P@Q20002P@Q10006P@Q17oo0P004goo000XOol00`00Oomoo`02Ool4DY@2CW<2BU82@Q02
?Nl4<H`8;F/:<H`4=Jd6>Lh6?Nl6@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42>Lh6=Jd2
@Q02CW<4DY@2CW<6BU82CW<2DY@<CW<kBU82AS44BU82@Q02<H`28@P25:D:124>000X1245Ool00`00
Oomoo`0gOol00`00Oomoo`02Ool4DY@2CW<2BU82@Q02?Nl4<H`8;F/:<H`4=Jd6>Lh6?Nl6@Q06AS42
BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42>Lh6=Jd2@Q02CW<4DY@2CW<6BU82CW<2DY@<CW<kBU82
AS44BU82@Q02<H`28@P25:D:124>000X1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`AB
U09>L`9:DP92408mk`@aS0P]J`XaS0@e[@HicPHmk`I240I6<@9:DP9>L`9BU09F]@9JeP9Nm`9S609B
U096<@8icPHe[@92409>L`ABU09>L`I:DP9>L`9BU0a>Lc]:DP96<@A:DP92408aS08Q208DY@X48@h0
02P48@Eoo`03001oogoo03Moo`03001oogoo009oo`ABU09>L`9:DP92408mk`@aS0P]J`XaS0@e[@Hi
cPHmk`I240I6<@9:DP9>L`9BU09F]@9JeP9Nm`9S609BU096<@8icPHe[@92409>L`ABU09>L`I:DP9>
L`9BU0a>Lc]:DP96<@A:DP92408aS08Q208DY@X48@h002P48@Eoo`03001oogoo015oo`00:7oo00<0
07ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3S6<13F]0SW>1Sg_248@14Ha14YB0Tic1U:D0Tic0U:D
0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_0THa9dic64YB0Tic2TYB14ic34YB0THa0SF]0RDY0Q24
0PQ20P@Q5000:P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3S6<
13F]0SW>1Sg_248@14Ha14YB0Tic1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_0THa
9dic64YB0Tic2TYB14ic34YB0THa0SF]0RDY0Q240PQ20P@Q5000:P@Q1Goo00<007ooOol04Goo000X
Ool00`00Oomoo`02Ool2CW<2AS42?Nl2>Lh2<H`8;F/><H`4=Jd2>Lh6?Nl8@Q04AS44BU82CW<6DY@2
CW<2DY@2E[D2G_L2DY@2CW<2BU82AS42>Lh2=Jd2?Nl2AS4WCW<HBU82CW<:BU84CW<<BU82AS42=Jd2
9BT248@22482124D000Z1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2CW<2AS42?Nl2>Lh2<H`8
;F/><H`4=Jd2>Lh6?Nl8@Q04AS44BU82CW<6DY@2CW<2DY@2E[D2G_L2DY@2CW<2BU82AS42>Lh2=Jd2
?Nl2AS4WCW<HBU82CW<:BU84CW<<BU82AS42=Jd29BT248@22482124D000Z1245Ool00`00Oomoo`0A
Ool002Qoo`03001oogoo009oo`8mk`8e[@8aS0H]Ja8aS08e[@@icP@mk`A240Q6<@A:DPA>L`IBU0YF
]@IBU09>L`9:DP92408mk`8icP9:DP9>L`9BU09F]@ABU1m>La1:DPY>L`A:DPI>L`9:DP96<@9:DPI>
L`8mk`8YBP8HaP88@P848@@000848@@000848@P000P48@8002848@Eoo`03001oogoo03Moo`03001o
ogoo009oo`8mk`8e[@8aS0H]Ja8aS08e[@@icP@mk`A240Q6<@A:DPA>L`IBU0YF]@IBU09>L`9:DP92
408mk`8icP9:DP9>L`9BU09F]@ABU1m>La1:DPY>L`A:DPI>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88
@P848@@000848@@000848@P000P48@8002848@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo
0Sg_0SF]0S6<1Re[4S6<0SF]13W>13g_148@24Ha14YB14ic1U:D2UJe1U:D0Tic0TYB0T8@0Sg_0SW>
0TYB0Tic0U:D0UJe15:D7dic44YB2Tic14YB1Tic0TYB0THa0TYB1Tic0Sg_0RU:0QS60PQ20P@Q1000
0P@Q10000P@Q200020@Q0P008P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo0Sg_0SF]0S6<1Re[
4S6<0SF]13W>13g_148@24Ha14YB14ic1U:D2UJe1U:D0Tic0TYB0T8@0Sg_0SW>0TYB0Tic0U:D0UJe
15:D7dic44YB2Tic14YB1Tic0TYB0THa0TYB1Tic0Sg_0RU:0QS60PQ20P@Q10000P@Q10000P@Q2000
20@Q0P008P@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool2<H`6;F/><H`4=Jd2>Lh2=Jd2
>Lh4?Nl4@Q04AS48BU86CW<8DY@2E[D2F]H4E[D2DY@4E[D2DY@4CW<2BU82@Q02?Nl2AS42BU86DY@k
CW<4BU86CW<6BU84CW<2AS42<H`27>L236<21242000<1246000:1242000R1245Ool00`00Oomoo`0g
Ool00`00Oomoo`02Ool2<H`6;F/><H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04AS48BU86CW<8DY@2E[D2F]H4
E[D2DY@4E[D2DY@4CW<2BU82@Q02?Nl2AS42BU86DY@kCW<4BU86CW<6BU84CW<2AS42<H`27>L236<2
1242000<1246000:1242000R1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`8aS0H]J`ha
S0@e[@8icP8e[@8icP@mk`A240A6<@Q:DPI>L`QBU09F]@9JePAF]@9BU0AF]@9BU0A>L`9:DP92408m
k`96<@9:DPIBU3]>L`A:DPI>L`I:DPA>L`96<@8aS08Li`8<H`848@8000`48@H000X48@8002848@Eo
o`03001oogoo03Moo`03001oogoo009oo`8aS0H]J`haS0@e[@8icP8e[@8icP@mk`A240A6<@Q:DPI>
L`QBU09F]@9JePAF]@9BU0AF]@9BU0A>L`9:DP92408mk`96<@9:DPIBU3]>L`A:DPI>L`I:DPA>L`96
<@8aS08Li`8<H`848@8000`48@H000X48@8002848@Eoo`03001oogoo015oo`00:7oo00<007ooOol0
0Woo1Re[4S6<0SF]13W>0Sg_148@14Ha24YB14ic25:D3UJe25[F0UJe15:D0TYB0THa0Sg_0THa0Tic
2U:D8Dic0U:D54ic14YB0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q10000P@Q1P002P@Q
0P008P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo1Re[4S6<0SF]13W>0Sg_148@14Ha24YB14ic
25:D3UJe25[F0UJe15:D0TYB0THa0Sg_0THa0Tic2U:D8Dic0U:D54ic14YB0Tic14YB0U:D14ic0TYB
0Sg_0RDY0Q2410@Q100010@Q10000P@Q1P002P@Q0P008P@Q1Goo00<007ooOol04Goo000XOol20003
Ool6;F/B<H`2=Jd4>Lh2?Nl4@Q04AS48BU84CW<8DY@>E[D8F]H2E[D4DY@2BU82AS42?Nl2AS42CW<:
DY@QCW<2DY@DCW<4BU82CW<4BU82DY@4CW<2BU82?Nl29BT248@412440004124400021246000:1242
000R1244Ool2000iOol20003Ool6;F/B<H`2=Jd4>Lh2?Nl4@Q04AS48BU84CW<8DY@>E[D8F]H2E[D4
DY@2BU82AS42?Nl2AS42CW<:DY@QCW<2DY@DCW<4BU82CW<4BU82DY@4CW<2BU82?Nl29BT248@41244
0004124400021246000:1242000R1244Ool2000COol002Qoo`03001oogoo009oo`H]J`haS08e[@@i
cP@mk`A240A6<@A:DPQ>L`ABU0YF]A1JePQF]@ABU096<@924096<@9>L`QBU0I>L`YBU2]>L`9:DPQ>
L`9:DP8mk`8]J`8HaP88@PH001`48@8002848@Eoo`03001oogoo03Moo`03001oogoo009oo`H]J`ha
S08e[@@icP@mk`A240A6<@A:DPQ>L`ABU0YF]A1JePQF]@ABU096<@924096<@9>L`QBU0I>L`YBU2]>
L`9:DPQ>L`9:DP8mk`8]J`8HaP88@PH001`48@8002848@Eoo`03001oogoo015oo`00:7oo00<007oo
Ool00Woo1Re[3S6<0SF]13W>13g_148@14Ha14YB24ic15:D2UJe45[F25Je15:D0THa0T8@0THa0Tic
25:D1Tic2U:D:dic0TYB24ic0TYB0Sg_0Re[0QS60PQ21P0070@Q0P008P@Q1Goo00<007ooOol0=goo
00<007ooOol00Woo1Re[3S6<0SF]13W>13g_148@14Ha14YB24ic15:D2UJe45[F25Je15:D0THa0T8@
0THa0Tic25:D1Tic2U:D:dic0TYB24ic0TYB0Sg_0Re[0QS60PQ21P0070@Q0P008P@Q1Goo00<007oo
Ool04Goo000XOol00`00Oomoo`02Ool<<H`6=Jd4>Lh4?Nl4@Q04AS46BU86CW<6DY@8E[DHF]H4E[D4
DY@2BU82AS42@Q02BU82CW<6DY@4CW<<DY@ACW<2DY@NCW<2DY@2CW<2AS42<H`28@P248@21246000L
1242000R1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool<<H`6=Jd4>Lh4?Nl4@Q04AS46BU86CW<6
DY@8E[DHF]H4E[D4DY@2BU82AS42@Q02BU82CW<6DY@4CW<<DY@ACW<2DY@NCW<2DY@2CW<2AS42<H`2
8@P248@21246000L1242000R1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo``aS0He[@@i
cP@mk`A240A6<@I:DPI>L`IBU0QF]AQJePAF]@ABU09:DP96<@92409:DP9>L`IBU0A>L`aBU15>L`9B
U1i>L`9BU09>L`96<@8aS08Q208@Q0848@H001`48@8002848@Eoo`03001oogoo03Moo`03001oogoo
009oo``aS0He[@@icP@mk`A240A6<@I:DPI>L`IBU0QF]AQJePAF]@ABU09:DP96<@92409:DP9>L`IB
U0A>L`aBU15>L`9BU1i>L`9BU09>L`96<@8aS08Q208@Q0848@H001`48@8002848@Eoo`03001oogoo
015oo`00:7oo00<007ooOol00Woo236<23F]0SW>1Sg_148@0THa14YB1Tic25:D1UJe5U[F1Ukg15[F
1UJe0U:D0TYB148@0TYB15Je3U:D14ic3E:D14ic1U:D64ic15:D0TYB0SW>0RDY0Q240P@Q2000@0@Q
1Goo00<007ooOol0=goo00<007ooOol00Woo236<23F]0SW>1Sg_148@0THa14YB1Tic25:D1UJe5U[F
1Ukg15[F1UJe0U:D0TYB148@0TYB15Je3U:D14ic3E:D14ic1U:D64ic15:D0TYB0SW>0RDY0Q240P@Q
2000@0@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool8<H`8=Jd2>Lh6?Nl4@Q02AS44BU86
CW<8DY@6E[DFF]H6G_L4F]H6E[D2DY@2BU84@Q02BU84E[D>DY@4CW<=DY@4CW<6DY@HCW<4DY@2BU82
>Lh29BT248@2124800101245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool8<H`8=Jd2>Lh6?Nl4@Q02
AS44BU86CW<8DY@6E[DFF]H6G_L4F]H6E[D2DY@2BU84@Q02BU84E[D>DY@4CW<=DY@4CW<6DY@HCW<4
DY@2BU82>Lh29BT248@2124800101245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`HaS0Pe
[@8icP@mk`I24096<@A:DPI>L`IBU0QF]@aJeQANm`AJePIF]@9BU096<@924096<@9BU09F]BMBU1Y>
L`9BU09>L`92408]J`8HaP8<H`848@8000848@@004048@Eoo`03001oogoo03Moo`03001oogoo009o
o`HaS0Pe[@8icP@mk`I24096<@A:DPI>L`IBU0QF]@aJeQANm`AJePIF]@9BU096<@924096<@9BU09F
]BMBU1Y>L`9BU09>L`92408]J`8HaP8<H`848@8000848@@004048@Eoo`03001oogoo015oo`0077oo
0`000Woo0P001Goo00<007ooOol00Woo1S6<23F]0SW>13g_1T8@0THa14YB1Tic1U:D25Je35[F55kg
15[F1UJe0U:D0THa0T8@0THa0U:D0UJe9e:D6Tic0U:D0Tic0T8@0Re[0QS60PaS0P@Q0P000P@Q1000
@0@Q1Goo00<007ooOol0:goo0`000Woo0P001Goo00<007ooOol00Woo1S6<23F]0SW>13g_1T8@0THa
14YB1Tic1U:D25Je35[F55kg15[F1UJe0U:D0THa0T8@0THa0U:D0UJe9e:D6Tic0U:D0Tic0T8@0Re[
0QS60PaS0P@Q0P000P@Q1000@0@Q1Goo00<007ooOol04Goo000MOol01000Oomoo`000Woo00<007oo
Ool00Woo00<007ooOol00Woo236<13F]13W>0Sg_148@1THa14YB1Tic1U:D25Je2U[F3Ukg0V<H2Ukg
0U[F1UJe0Tic0THa0T8@0TYB8E:D14ic15:D64ic15:D0THa0SF]0R480Q240PQ20P@Q0P000P@Q1000
@0@Q1Goo00<007ooOol0;7oo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`PaS0@e
[@@icP8mk`A240I6<@A:DPI>L`IBU0QF]@YJePiNm`9S60YNm`9JePIF]@9>L`96<@92409:DR5BU0A>
L`ABU1Q>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@004048@Eoo`03001oogoo015oo`006Woo
1@0000Eoo`00Oomoo`0000Aoo`<0009oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF]@YJePiN
m`9S60YNm`9JePIF]@9>L`96<@92409:DR5BU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088@P848@80
00848@@004048@=oo`<002]oo`D00005Ool007ooOol00004Ool30002Ool8<H`4=Jd4>Lh2?Nl4@Q06
AS44BU86CW<6DY@8E[D:F]H>G_L2HaP:G_L2F]H6E[D2CW<2AS42@Q02BU8QDY@4CW<4DY@HCW<4DY@2
AS42=Jd28@P248@2248212420002124400101243Ool3000COol001Yoo`04001oogoo0002Ool01000
Oomoo`0017oo00<007ooOol00Woo136<1SF]13W>13g_0T8@24Ha14YB14ic25:D25Je1U[F2Ukg2V<H
2Ukg15[F0UJe0U[F0UJe0TYB14Ha0Tic:E:D34ic0U:D1Tic15:D0Tic0Sg_0RU:0QBU0PQ20P@Q1000
0P@Q1000@0@Q1Goo00<007ooOol0:Goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02
Ool4<H`6=Jd4>Lh4?Nl2@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2E[D2BU84
AS42CW<YDY@<CW<2DY@6CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool00`00Oomo
o`0AOol001]oo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2
@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2E[D2BU84AS42CW<YDY@<CW<2DY@6
CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool00`00Oomoo`0ZOol00`00Ool00002
Ool01000Oomoo`0017oo00<007ooOol00Woo136<1SF]13W>13g_0T8@24Ha14YB14ic25:D25Je1U[F
2Ukg2V<H2Ukg15[F0UJe0U[F0UJe0TYB14Ha0Tic:E:D34ic0U:D1Tic15:D0Tic0Sg_0RU:0QBU0PQ2
0P@Q10000P@Q1000@0@Q1Goo00<007ooOol04Goo000LOol20003Ool20005Ool00`00Oomoo`02Ool2
<H`2=Jd4>Lh8?Nl2@Q06AS44BU84CW<6DY@6E[D<F]H:G_L>HaP:G_L6F]H2E[D2DY@2BU82AS42BU82
CW<WDY@8CW<4DY@6CW<4DY@2BU82@Q02;F/27>L236<212460002124400101245Ool00`00Oomoo`0[
Ool20003Ool20005Ool00`00Oomoo`02Ool2<H`2=Jd4>Lh8?Nl2@Q06AS44BU84CW<6DY@6E[D<F]H:
G_L>HaP:G_L6F]H2E[D2DY@2BU82AS42BU82CW<WDY@8CW<4DY@6CW<4DY@2BU82@Q02;F/27>L236<2
12460002124400101245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`8aS08e[@@icPPmk`92
40I6<@A:DPA>L`IBU0IF]@aJePYNm`iS60YNm`IJeP9F]@9BU09:DP96<@9:DP9>LbMBU0Q>L`ABU0I>
L`ABU09:DP92408]J`8Li`8<H`848@H000848@@004048@Eoo`03001oogoo03Moo`03001oogoo009o
o`8aS08e[@@icPPmk`9240I6<@A:DPA>L`IBU0IF]@aJePYNm`iS60YNm`IJeP9F]@9BU09:DP96<@9:
DP9>LbMBU0Q>L`ABU0I>L`ABU09:DP92408]J`8Li`8<H`848@H000848@@004048@Eoo`03001oogoo
015oo`00:7oo00<007ooOol00Woo0SF]1SW>13g_148@14Ha14YB1Tic15:D25Je35[F1Ukg0V<H0Ukg
56<H2Ukg0U[F15Je0Tic14YB0Tic8E:D24ic2U:D0Tic0TYB0Tic15:D0THa0SW>0R480QBU0PQ21P@Q
0P000P@Q1000@0@Q1Goo00<007ooOol0=goo00<007ooOol00Woo0SF]1SW>13g_148@14Ha14YB1Tic
15:D25Je35[F1Ukg0V<H0Ukg56<H2Ukg0U[F15Je0Tic14YB0Tic8E:D24ic2U:D0Tic0TYB0Tic15:D
0THa0SW>0R480QBU0PQ21P@Q0P000P@Q1000@0@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02
Ool2=Jd6>Lh4?Nl4@Q04AS44BU86CW<4DY@8E[D<F]H6G_L2HaP2G_LDHaP:G_L2F]H4E[D2CW<4BU82
CW<QDY@8CW<:DY@2CW<2BU82CW<4DY@2AS42>Lh28@P25:D2248612420002124400101245Ool00`00
Oomoo`0gOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4@Q04AS44BU86CW<4DY@8E[D<F]H6G_L2HaP2G_LD
HaP:G_L2F]H4E[D2CW<4BU82CW<QDY@8CW<:DY@2CW<2BU82CW<4DY@2AS42>Lh28@P25:D224861242
0002124400101245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`@icP@mk`A240I6<@A:DPI>
L`IBU0IF]@aJePYNmaQS60QNm`IJeP9BU0I:DP9>L`ABU0A>L`ABU09>La5BU0A>L`iBU0A>L`9BU09F
]@9BU08mk`8]J`8HaP8@Q088@P848@P004@48@Eoo`03001oogoo03Moo`03001oogoo009oo`@icP@m
k`A240I6<@A:DPI>L`IBU0IF]@aJePYNmaQS60QNm`IJeP9BU0I:DP9>L`ABU0A>L`ABU09>La5BU0A>
L`iBU0A>L`9BU09F]@9BU08mk`8]J`8HaP8@Q088@P848@P004@48@Eoo`03001oogoo015oo`00:7oo
00<007ooOol00Woo13W>13g_148@1THa14YB1Tic1U:D1UJe35[F2Ukg66<H25kg1U[F0U:D1TYB0Tic
15:D14ic15:D0Tic4E:D14ic3U:D14ic0U:D0UJe0U:D0Sg_0Re[0QS60Q240PQ20P@Q2000A0@Q1Goo
00<007ooOol0=goo00<007ooOol00Woo13W>13g_148@1THa14YB1Tic1U:D1UJe35[F2Ukg66<H25kg
1U[F0U:D1TYB0Tic15:D14ic15:D0Tic4E:D14ic3U:D14ic0U:D0UJe0U:D0Sg_0Re[0QS60Q240PQ2
0P@Q2000A0@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool2>Lh4?Nl4@Q06AS44BU86CW<8
DY@4E[D:F]H<G_L>HaP2IcT<HaP:G_L2F]H2E[D8CW<_DY@6CW<4DY@2BU82<H`28@P25:D248@22482
124600161245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2>Lh4?Nl4@Q06AS44BU86CW<8DY@4E[D:
F]H<G_L>HaP2IcT<HaP:G_L2F]H2E[D8CW<_DY@6CW<4DY@2BU82<H`28@P25:D248@2248212460016
1245Ool00`00Oomoo`0AOol002Qoo`8000=oo`8icP@mk`A240I6<@A:DPI>L`QBU0AF]@YJePaNm`iS
609W>@aS60YNm`9JeP9F]@Q>LbmBU0I>L`ABU09:DP8aS08Q208DY@8@Q088@P848@H004H48@Aoo`80
03Uoo`8000=oo`8icP@mk`A240I6<@A:DPI>L`QBU0AF]@YJePaNm`iS609W>@aS60YNm`9JeP9F]@Q>
LbmBU0I>L`ABU09:DP8aS08Q208DY@8@Q088@P848@H004H48@Aoo`8001=oo`00:7oo00<007ooOol0
0Woo0Sg_1T8@14Ha1TYB14ic2U:D15Je2U[F3Ukg3V<H26Li36<H15kg15[F0U:D1Tic;E:D24ic0U:D
0Tic0Sg_0RU:0QS60Q240PaS10@Q1000B0@Q1Goo00<007ooOol0=goo00<007ooOol00Woo0Sg_1T8@
14Ha1TYB14ic2U:D15Je2U[F3Ukg3V<H26Li36<H15kg15[F0U:D1Tic;E:D24ic0U:D0Tic0Sg_0RU:
0QS60Q240PaS10@Q1000B0@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool2?Nl6@Q04AS46
BU84CW<:DY@4E[D:F]H>G_L>HaP8IcT<HaP4G_L4F]H2DY@6CW<]DY@8CW<2DY@2CW<2?Nl2:DX26<H2
48@236<4124400181245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2?Nl6@Q04AS46BU84CW<:DY@4
E[D:F]H>G_L>HaP8IcT<HaP4G_L4F]H2DY@6CW<]DY@8CW<2DY@2CW<2?Nl2:DX26<H248@236<41244
00181245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`I240A6<@Q:DPI>L`QBU09F]@iJePaN
mb9S609Nm`IJeP9F]@9>L`A:DP9>Lb]BU09>L`9BU09>L`ABU09:DP8e[@8Q208DY@8@Q08<H`848@H0
04P48@Eoo`03001oogoo03Moo`03001oogoo009oo`I240A6<@Q:DPI>L`QBU09F]@iJePaNmb9S609N
m`IJeP9F]@9>L`A:DP9>Lb]BU09>L`9BU09>L`ABU09:DP8e[@8Q208DY@8@Q08<H`848@H004P48@Eo
o`03001oogoo015oo`00:7oo00<007ooOol00Woo1T8@14Ha24YB1Tic25:D0UJe3U[F35kg8V<H0Ukg
1U[F0UJe0Tic14YB0Tic:e:D0Tic0U:D0Tic15:D0TYB0SF]0R480QBU0Q240PaS0P@Q1P00B0@Q1Goo
00<007ooOol0=goo00<007ooOol00Woo1T8@14Ha24YB1Tic25:D0UJe3U[F35kg8V<H0Ukg1U[F0UJe
0Tic14YB0Tic:e:D0Tic0U:D0Tic15:D0TYB0SF]0R480QBU0Q240PaS0P@Q1P00B0@Q1Goo00<007oo
Ool04Goo000XOol00`00Oomoo`02Ool4@Q06AS48BU84CW<8DY@4E[D>F]H<G_LPHaP4G_L6F]H2E[D2
DY@4BU82CW<MDY@2CW<>DY@4CW<2DY@2CW<2@Q02;F/26<H248@436<4124400181245Ool00`00Oomo
o`0gOol00`00Oomoo`02Ool4@Q06AS48BU84CW<8DY@4E[D>F]H<G_LPHaP4G_L6F]H2E[D2DY@4BU82
CW<MDY@2CW<>DY@4CW<2DY@2CW<2@Q02;F/26<H248@436<4124400181245Ool00`00Oomoo`0AOol0
02Qoo`03001oogoo009oo`A240I6<@Q:DPA>L`QBU0AF]@iJePaNmb1S60ANm`IJeP9F]@9BU0A:DP9>
LaeBU09>L`iBU0A>L`9BU09>L`92408]J`8HaP8@Q0@<H`@48@@004P48@Eoo`03001oogoo03Moo`03
001oogoo009oo`A240I6<@Q:DPA>L`QBU0AF]@iJePaNmb1S60ANm`IJeP9F]@9BU0A:DP9>LaeBU09>
L`iBU0A>L`9BU09>L`92408]J`8HaP8@Q0@<H`@48@@004P48@Eoo`03001oogoo015oo`00:7oo00<0
07ooOol00Woo0T8@1THa14YB24ic1U:D25Je35[F3Ukg86<H1Ukg1U[F0U:D0Tic14YB1Tic5e:D1Tic
2U:D0Tic15:D0Tic0SW>0RDY0QBU10aS0PQ2D0@Q1Goo00<007ooOol0=goo00<007ooOol00Woo0T8@
1THa14YB24ic1U:D25Je35[F3Ukg86<H1Ukg1U[F0U:D0Tic14YB1Tic5e:D1Tic2U:D0Tic15:D0Tic
0SW>0RDY0QBU10aS0PQ2D0@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool2@Q06AS44BU88
CW<6DY@8E[D<F]H>G_LPHaP6G_L6F]H2DY@2CW<4BU86CW<GDY@6CW<:DY@2CW<4DY@2CW<2>Lh29BT2
5:D436<2249@1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2@Q06AS44BU88CW<6DY@8E[D<F]H>
G_LPHaP6G_L6F]H2DY@2CW<4BU86CW<GDY@6CW<:DY@2CW<4DY@2CW<2>Lh29BT25:D436<2249@1245
Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`I6<@I:DPI>L`IBU0QF]@aJePaNm`YS609W>AaS
60QNm`9F]@9BU0I:DPA>L`9BU0A>L`MBU11>L`ABU0Q>L`ABU092408]J`8Li`8@Q0@<H`88@U048@Eo
o`03001oogoo03Moo`03001oogoo009oo`I6<@I:DPI>L`IBU0QF]@aJePaNm`9S60P0009W>AaS60QN
m`9F]@9BU0I:DPA>L`9BU0A>L`MBU11>L`ABU0Q>L`ABU092408]J`8Li`8@Q0@<H`88@U048@Eoo`03
001oogoo015oo`00:7oo0P000goo1THa1TYB1Tic1U:D25Je35[F35kg2V<H0VLi76<H25kg0UJe0U:D
1TYB14ic0U:D14ic1e:D44ic15:D24ic15:D0T8@0Re[0QcW0Q2410aS0PQ2D0@Q17oo0P00>Goo0P00
0goo1THa1TYB1Tic1U:D25Je35[F35kg0V<H20000VLi76<H25kg0UJe0U:D1TYB14ic0U:D14ic1e:D
44ic15:D24ic15:D0T8@0Re[0QcW0Q2410aS0PQ2D0@Q17oo0P004goo000XOol00`00Oomoo`02Ool4
AS44BU8:CW<6DY@6E[D:F]H>G_L:HaP6IcTJHaP8G_L2F]H2DY@2CW<6BU88CW<4DY@OCW<2DY@2BU82
=Jd28@P25:D448@2248^1242248R1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool4AS44BU8:CW<6
DY@6E[D:F]H>G_L4HaP80004IcTJHaP8G_L2F]H2DY@2CW<6BU88CW<4DY@OCW<2DY@2BU82=Jd28@P2
5:D448@2248^1242248R1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`A6<@A:DPY>L`IB
U0IF]@YJePiNm`YS60IW>AYS60QNm`9JeP9BU09>L`I:DPQ>L`ABU1m>L`9BU09:DP8e[@8Q208DY@@@
Q088@Rh48@88@R848@Eoo`03001oogoo03Moo`03001oogoo009oo`A6<@A:DPY>L`IBU0IF]@YJePiN
m`AS60P000AW>AYS60QNm`9JeP9BU09>L`I:DPQ>L`ABU1m>L`9BU09:DP8e[@8Q208DY@@@Q088@Rh4
8@88@R848@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo0THa24YB0Tic2U:D15Je3U[F3Ukg
2V<H2VLi16<H36Li26<H15kg0U[F15Je0Tic0TYB0THa14YB24ic0U:D2Dic0U:D34ic0U:D0Tic0TYB
14ic0THa0Re[0QS61Q240PQ2<0@Q0PQ280@Q1Goo00<007ooOol0=goo00<007ooOol00Woo0THa24YB
0Tic2U:D15Je3U[F3Ukg16<H200026Li16<H36Li26<H15kg0U[F15Je0Tic0TYB0THa14YB24ic0U:D
2Dic0U:D34ic0U:D0Tic0TYB14ic0THa0Re[0QS61Q240PQ2<0@Q0PQ280@Q1Goo00<007ooOol04Goo
000XOol00`00Oomoo`02Ool2AS48BU82CW<:DY@4E[D>F]H>G_L:HaP:IcT4HaP<IcT8HaP4G_L2F]H4
E[D2CW<2BU82AS44BU88CW<2DY@9CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/26<H648@2248`1242
248P1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2AS48BU82CW<:DY@4E[D>F]H>G_L4HaP80008
IcT4HaP<IcT8HaP4G_L2F]H4E[D2CW<2BU82AS44BU88CW<2DY@9CW<2DY@<CW<2DY@2CW<2BU84CW<2
AS42;F/26<H648@2248`1242248P1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`I:DPI>
L`YBU0AF]@iJePiNm`YS60aW>@IS60AW>@aS60ANm`AJeP9F]@9BU09>L`A6<@9:DRU>L`9:DP8mk`8Y
BP8DY@8@Q0@<H`88@Rh48@@8@R048@Eoo`03001oogoo03Moo`03001oogoo009oo`I:DPI>L`YBU0AF
]@iJePiNm`YS60aW>@IS60AW>@aS60ANm`AJeP9F]@9BU09>L`A6<@9:DRU>L`9:DP8mk`8YBP8DY@8@
Q0@<H`88@Rh48@@8@R048@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo1TYB1Tic2U:D15Je
3U[F3Ukg2V<H36Li1V<H16Li36<H15kg15[F0UJe0U:D0Tic14Ha0TYB:Dic0TYB0Sg_0RU:0QBU0Q24
10aS0PQ2;P@Q10Q280@Q1Goo00<007ooOol0=goo00<007ooOol00Woo1TYB1Tic2U:D15Je3U[F3Ukg
2V<H36Li1V<H16Li36<H15kg15[F0UJe0U:D0Tic14Ha0TYB:Dic0TYB0Sg_0RU:0QBU0Q2410aS0PQ2
;P@Q10Q280@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool4BU88CW<8DY@4E[D>F]H<G_L@
HaP:IcTHHaP4G_L4F]H2E[D2CW<4AS42BU8UCW<4DY@2AS42=Jd28@P248@436<4248H1242248@1248
248P1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool4BU88CW<8DY@4E[D>F]H<G_L@HaP:IcTHHaP4
G_L4F]H2E[D2CW<4AS42BU8UCW<4DY@2AS42=Jd28@P248@436<4248H1242248@1248248P1245Ool0
0`00Oomoo`0AOol002Qoo`03001oogoo009oo`A:DPQ>L`QBU0AF]@iJePaNma1S60YW>AQS60ANm`AJ
eP9F]@9>L`A6<@9:DRE>L`ABU096<@8e[@8Q208@Q0@<H`@8@QP48@88@Q048@P8@R048@Eoo`03001o
ogoo03Moo`03001oogoo009oo`A:DPQ>L`QBU0AF]@iJePaNma1S60YW>AQS60ANm`AJeP9F]@9>L`A6
<@9:DRE>L`ABU096<@8e[@8Q208@Q0@<H`@8@QP48@88@Q048@P8@R048@Eoo`03001oogoo015oo`00
:7oo00<007ooOol00Woo14YB24ic35Je3U[F35kg2V<H16Li1V<H1VLi66<H15kg15[F0UJe0U:D0TYB
14Ha0TYB7dic0TYB0Tic15:D0T8@0RU:0QS611240PaS10Q25P@Q10Q230@Q30Q280@Q1Goo00<007oo
Ool0=goo00<007ooOol00Woo14YB24ic35Je3U[F35kg2V<H16Li1V<H1VLi66<H15kg15[F0UJe0U:D
0TYB14Ha0TYB7dic0TYB0Tic15:D0T8@0RU:0QS611240PaS10Q25P@Q10Q230@Q30Q280@Q1Goo00<0
07ooOol04Goo000XOol20003Ool4BU88CW<<E[D>F]H<G_L:HaP4IcT6HaP6IcTHHaP4G_L4F]H2E[D2
DY@2BU84AS42BU8OCW<2BU82CW<4DY@2@Q02:DX26<H448@236<4248F1244248<124<248P1244Ool2
000iOol20003Ool4BU88CW<<E[D>F]H<G_L:HaP4IcT6HaP6IcTHHaP4G_L4F]H2E[D2DY@2BU84AS42
BU8OCW<2BU82CW<4DY@2@Q02:DX26<H448@236<4248F1244248<124<248P1244Ool2000COol002Qo
o`03001oogoo009oo`A:DPI>L`9BU0aF]@iJePaNm`YS60IW>@IS60AW>AIS60INm`AJeP9F]@9BU09>
L`I6<@9:DQE>L`9:DPI>L`9:DP9>L`9BU09>L`8icP8Q208HaP8DY@8@Q08<H`P8@Q848@@8@PX48A08
@Qh48@Eoo`03001oogoo03Moo`03001oogoo009oo`A:DPI>L`9BU0aF]@iJePaNm`YS60IW>@IS60AW
>AIS60INm`AJeP9F]@9BU09>L`I6<@9:DQE>L`9:DPI>L`9:DP9>L`9BU09>L`8icP8Q208HaP8DY@8@
Q08<H`P8@Q848@@8@PX48A08@Qh48@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo14YB1Tic
0U:D35Je3U[F35kg2V<H1VLi1V<H16Li5V<H1Ukg15[F0UJe0U:D0Tic1THa0TYB5Dic0TYB1Tic0TYB
0Tic0U:D0Tic0SW>0R480QS60QBU0Q240PaS20Q24P@Q10Q22P@Q40Q27P@Q1Goo00<007ooOol0=goo
00<007ooOol00Woo14YB1Tic0U:D35Je3U[F35kg2V<H1VLi1V<H16Li5V<H1Ukg15[F0UJe0U:D0Tic
1THa0TYB5Dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS60QBU0Q240PaS20Q24P@Q10Q22P@Q40Q2
7P@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool2BU86CW<4DY@<E[D<F]HBG_L6HaP:IcTL
HaP6G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02BU89CW<4BU88CW<4BU84CW<2BU82CW<2DY@2AS42<H`2
6<H45:D248@236<8248<124:248612422482124@248N1245Ool00`00Oomoo`0gOol00`00Oomoo`02
Ool2BU86CW<4DY@<E[D<F]HBG_L6HaP:IcTLHaP6G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02BU89CW<4
BU88CW<4BU84CW<2BU82CW<2DY@2AS42<H`26<H45:D248@236<8248<124:248612422482124@248N
1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`9:DPI>L`ABU0aF]@aJeQ9Nm`IS60YW>AaS
60INm`AJeP9F]@9BU09>L`9:DP96<@92409:DPU>L`A:DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08H
aP@DY@8@Q08<H`P8@P`48@X8@PH48@88@P848A08@Qh48@Eoo`03001oogoo03Moo`03001oogoo009o
o`9:DPI>L`ABU0aF]@aJeQ9Nm`IS60YW>AaS60INm`AJeP9F]@9BU09>L`9:DP96<@92409:DPU>L`A:
DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP@DY@8@Q08<H`P8@P`48@X8@PH48@88@P848A08@Qh4
8@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo1Tic1U:D2UJe3U[F4Ukg16<H3VLi6V<H1Ukg
15[F15Je0U:D0TYB1THa14YB1Dic14YB14ic0TYB0Tic1TYB24ic0SW>0RDY1QBU0Q242PQ22P@Q9PQ2
7P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo1Tic1U:D2UJe3U[F4Ukg16<H3VLi6V<H1Ukg15[F
15Je0U:D0TYB1THa14YB1Dic14YB14ic0TYB0Tic1TYB24ic0SW>0RDY1QBU0Q242PQ22P@Q9PQ27P@Q
1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool6CW<6DY@:E[D>F]HBG_L4HaP>IcTJHaP6G_L4
F]H4E[D2DY@2BU86AS44BU85CW<4BU84CW<2BU82CW<6BU88CW<2>Lh29BT65:D248@:248:124V248N
1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool6CW<6DY@:E[D>F]HBG_L4HaP>IcTJHaP6G_L4F]H4
E[D2DY@2BU86AS44BU85CW<4BU84CW<2BU82CW<6BU88CW<2>Lh29BT65:D248@:248:124V248N1245
Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`I>L`ABU0aF]@iJePQNm`IS60ANm`AS609W>@9S
60YW>AYS60YNm`9JeP9F]@9BU09>L`I6<A]:DPI>L`9:DP8e[@8Q208@Q08DY@8HaP8@Q0@8@P848@@8
@PX48@@8@P@<Hah8@QX48@@8@PEoo`03001oogoo03Moo`03001oogoo009oo`I>L`ABU0aF]@iJePQN
m`IS60ANm`AS609W>@9S60YW>AYS60YNm`9JeP9F]@9BU09>L`I6<A]:DPI>L`9:DP8e[@8Q208@Q08D
Y@8HaP8@Q0@8@P848@@8@PX48@@8@P@<Hah8@QX48@@8@PEoo`03001oogoo015oo`006Woo0`0017oo
0P001Goo00<007ooOol00Woo1Tic15:D35Je3U[F25kg1V<H15kg16<H0VLi0V<H2VLi6V<H2Ukg0U[F
0UJe0U:D0Tic1THa6dYB1Tic0TYB0SF]0R480Q240QBU0QS60Q2410Q20P@Q10Q22P@Q10Q210aS7PQ2
6P@Q10Q21Goo00<007ooOol0:Goo0`0017oo0P001Goo00<007ooOol00Woo1Tic15:D35Je3U[F25kg
1V<H15kg16<H0VLi0V<H2VLi6V<H2Ukg0U[F0UJe0U:D0Tic1THa6dYB1Tic0TYB0SF]0R480Q240QBU
0QS60Q2410Q20P@Q10Q22P@Q10Q210aS7PQ26P@Q10Q21Goo00<007ooOol04Goo000JOol01000Oomo
o`000Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`YBU0QF]A1JePiNm`AS611W>AaS60YNm`AJ
eP9F]@9>L`9:DPA6<@9240m:DP96<@Y:DPA>L`8mk`8YBP8HaP8@Q0@DY@8<H``8@P@48@88@PH<H`8@
Q08<H`H8@PH48A88@QX48@@8@PEoo`03001oogoo02Uoo`04001oogoo0002Ool01000Oomoo`0017oo
00<007ooOol00Woo0Tic2U:D25Je45[F3Ukg16<H46Li76<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3dYB
0THa2TYB14ic0Sg_0RU:0QS60Q2411BU0PaS30Q210@Q0PQ21PaS0Q240PaS1PQ21P@Q4PQ26P@Q10Q2
1Goo00<007ooOol04Goo000JOol01000Oomoo`000Woo00@007ooOol000Aoo`<0009oo`9>L`YBU0QF
]A1JePiNm`AS611W>AaS60YNm`AJeP9F]@9>L`9:DPA6<@9240m:DP96<@Y:DPA>L`8mk`8YBP8HaP8@
Q0@DY@8<H``8@P@48@88@PH<H`8@Q08<H`H8@PH48A88@QX48@@8@P=oo`<002]oo`04001oogoo0002
Ool01000Oomoo`0017oo0`000Woo0Tic2U:D25Je45[F3Ukg16<H46Li76<H2Ukg15[F0UJe0Tic0TYB
14Ha0T8@3dYB0THa2TYB14ic0Sg_0RU:0QS60Q2411BU0PaS30Q210@Q0PQ21PaS0Q240PaS1PQ21P@Q
4PQ26P@Q10Q20goo0`004goo000JOol30003Ool01000Oomoo`0017oo00<007ooOol00Woo0Tic25:D
2UJe45[F3Ukg1V<H3VLi76<H2Ukg15[F0UJe0U:D0Tic0TYB0THa0T8@0THa3DYB0THa2TYB0Tic0TYB
0SW>0RDY0QBU0PaS11BU0PaS2PQ21P@Q0PQ20PaS0QcW0QS60QBU0PaS20Q210@Q40Q280@Q1Goo00<0
07ooOol0:Goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9>L`QBU0YF]A1JePiNm`IS60iW
>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@e:DP96<@Y:DP9>L`9:DP8icP8U:@8DY@8<H`@D
Y@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eoo`03001oogoo015oo`006goo
00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`QBU0YF]A1JePiNm`IS60iW>AaS
60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@e:DP96<@Y:DP9>L`9:DP8icP8U:@8DY@8<H`@DY@8<
H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eoo`03001oogoo02Yoo`03001oogoo
009oo`04001oogoo0004Ool00`00Oomoo`02Ool2CW<8DY@:E[D@F]H>G_L6HaP>IcTLHaP:G_L4F]H2
E[D2DY@2CW<2BU82AS42@Q02AS4=BU82AS4:BU82CW<2BU82>Lh29BT25:D236<45:D236<:24861242
248236<27>L26<H25:D236<82484124@248P1245Ool00`00Oomoo`0AOol001]oo`<000=oo`8000Eo
o`03001oogoo009oo`9>L`IBU0aF]A1JePaNm`IS611W>AaS60YNm`AJePAF]@9BU09>L`96<@924096
<@e:DP96<@Y:DP9>L`96<@8aS08Li`8@Q08<H`@@Q08<H`H8@PX48@88@P8<H`8Q208Li`8DY@8<Ha`8
@Qh48@88@PEoo`03001oogoo02Yoo`<000=oo`8000Eoo`03001oogoo009oo`9>L`IBU0aF]A1JePaN
m`IS611W>AaS60YNm`AJePAF]@9BU09>L`96<@924096<@e:DP96<@Y:DP9>L`96<@8aS08Li`8@Q08<
H`@@Q08<H`H8@PX48@88@P8<H`8Q208Li`8DY@8<Ha`8@Qh48@88@PEoo`03001oogoo015oo`00:7oo
00<007ooOol00Woo0Tic1U:D35Je45[F35kg1V<H46Li76<H2Ukg15[F15Je0U:D0Tic0THa0T8@0THa
3DYB0THa2TYB0Tic0THa0S6<0QcW0Q240PaS11240PaS1PQ22P@Q0PQ20PaS0R480QcW0QBU0PaS70Q2
7P@Q0PQ21Goo00<007ooOol0=goo00<007ooOol00Woo0Tic1U:D35Je45[F35kg1V<H46Li76<H2Ukg
15[F15Je0U:D0Tic0THa0T8@0THa3DYB0THa2TYB0Tic0THa0S6<0QcW0Q240PaS11240PaS1PQ22P@Q
0PQ20PaS0R480QcW0QBU0PaS70Q27P@Q0PQ21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool6
DY@<E[D@F]H:G_L8HaPBIcTLHaP:G_L6F]H2E[D2DY@2CW<2BU82AS42@Q02AS47BU86AS42BU82AS48
BU82?Nl2;F/26<H248@236<25:D248@236<2248>124236<248@46<H25:D236<L248L12442485Ool0
0`00Oomoo`0gOol00`00Oomoo`02Ool6DY@<E[D@F]H:G_L8HaPBIcTLHaP:G_L6F]H2E[D2DY@2CW<2
BU82AS42@Q02AS47BU86AS42BU82AS48BU82?Nl2;F/26<H248@236<25:D248@236<2248>124236<2
48@46<H25:D236<L248L12442485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`IBU0aF]A1J
ePYNm`QS619W>AaS60YNm`IJeP9F]@9BU09>L`9:DP96<@924096<@M:DPI6<@9:DP96<@Q:DP8mk`8]
J`8HaP8@Q08<H`8DY@8@Q08<H`88@Ph48@8<H`8@Q0@HaP8DY@8<Ha`8@Q`48@@8@PEoo`03001oogoo
03Moo`03001oogoo009oo`IBU0aF]A1JePYNm`QS619W>AaS60YNm`IJeP9F]@9BU09>L`9:DP96<@92
4096<@M:DPI6<@9:DP96<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@8@Q08<H`88@Ph48@8<H`8@Q0@HaP8D
Y@8<Ha`8@Q`48@@8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo1U:D25Je55[F2Ukg2V<H
46Li7V<H25kg1U[F0UJe15:D0TYB0THa148@4dHa1TYB0SW>0RDY0QBU0PaS0Q240QBU0Q240PaS0PQ2
30@Q10Q220aS60Q20PaS10Q26P@Q1PQ21Goo00<007ooOol0=goo00<007ooOol00Woo1U:D25Je55[F
2Ukg2V<H46Li7V<H25kg1U[F0UJe15:D0TYB0THa148@4dHa1TYB0SW>0RDY0QBU0PaS0Q240QBU0Q24
0PaS0PQ230@Q10Q220aS60Q20PaS10Q26P@Q1PQ21Goo00<007ooOol04Goo000XOol00`00Oomoo`02
Ool6DY@8E[DDF]H:G_L:HaP@IcTNHaP8G_L6F]H2E[D4DY@2BU82AS44@Q0CAS46BU82>Lh29BT25:D2
36<248@25:D248@236<2248<1244248836<H248236<4248J12462485Ool00`00Oomoo`0gOol00`00
Oomoo`02Ool6DY@8E[DDF]H:G_L:HaP@IcTNHaP8G_L6F]H2E[D4DY@2BU82AS44@Q0CAS46BU82>Lh2
9BT25:D236<248@25:D248@236<2248<1244248836<H248236<4248J12462485Ool00`00Oomoo`0A
Ool002Qoo`03001oogoo009oo`ABU0QF]AIJePiNm`YS619W>AQS60QNm`IJeP9F]@ABU09>L`9:DPU2
40i6<@A:DP96<@8e[@8Q208@Q0@<H`8@Q08<H`@8@Ph48B08@P@<H`@8@QX48@H8@PEoo`03001oogoo
03Moo`03001oogoo009oo`ABU0QF]AIJePiNm`YS619W>AQS60QNm`IJeP9F]@ABU09>L`9:DPU240i6
<@A:DP96<@8e[@8Q208@Q0@<H`8@Q08<H`@8@Ph48B08@P@<H`@8@QX48@H8@PEoo`03001oogoo015o
o`00:7oo0P000goo15:D25Je5U[F3Ukg2V<H4VLi66<H25kg1U[F0UJe15:D0Tic0TYB2D8@3THa14YB
0THa0SF]0R480Q2410aS0Q240PaS10Q23P@Q80Q210aS10Q26P@Q1PQ217oo0P00>Goo0P000goo15:D
25Je5U[F3Ukg2V<H4VLi66<H25kg1U[F0UJe15:D0Tic0TYB2D8@3THa14YB0THa0SF]0R480Q2410aS
0Q240PaS10Q23P@Q80Q210aS10Q26P@Q1PQ217oo0P004goo000XOol00`00Oomoo`02Ool4DY@8E[DD
F]H@G_L:HaPBIcTLHaP4G_L2F]H2G_L2F]H6E[D2DY@2BU82AS42@Q03?Nl4@Q0<AS42BU82AS42@Q02
<H`27>L248@636<6248:1242248412462484124D248436<6248212442488124@2485Ool00`00Oomo
o`0gOol00`00Oomoo`02Ool4DY@8E[DDF]H@G_L:HaPBIcTLHaP4G_L2F]H2G_L2F]H6E[D2DY@2BU82
AS42@Q03?Nl4@Q0<AS42BU82AS42@Q02<H`27>L248@636<6248:1242248412462484124D248436<6
248212442488124@2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`ABU0QF]AAJeQ1Nm`YS
619W>AaS60ANm`9JeP9Nm`9JePIF]@9BU09:DP96<@9240<mk`A240a6<@9:DP96<@92408aS08Li`8@
Q0H<H`H8@PX48@88@P@48@H8@P@48A@8@P@<H`H8@P848@@8@PP48A08@PEoo`03001oogoo03Moo`03
001oogoo009oo`ABU0QF]AAJeQ1Nm`YS619W>AaS60ANm`9JeP9Nm`9JePIF]@9BU09:DP96<@9240<m
k`A240a6<@9:DP96<@92408aS08Li`8@Q0H<H`H8@PX48@88@P@48@H8@P@48A@8@P@<H`H8@P848@@8
@PP48A08@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo15:D25Je55[F35kg2V<H1VLi16<H
3VLi6V<H15kg0U[F15kg0U[F15Je0U:D0TYB0THa0T8@0cg_1T8@1THa0T8@0THa0TYB0THa0Sg_0Re[
0QS61Q240PaS0PQ23P@Q30Q210@Q1PQ20P@Q30Q210aS1PQ20P@Q10Q220@Q40Q21Goo00<007ooOol0
=goo00<007ooOol00Woo15:D25Je55[F35kg2V<H1VLi16<H3VLi6V<H15kg0U[F15kg0U[F15Je0U:D
0TYB0THa0T8@0cg_1T8@1THa0T8@0THa0TYB0THa0Sg_0Re[0QS61Q240PaS0PQ23P@Q30Q210@Q1PQ2
0P@Q30Q210aS1PQ20P@Q10Q220@Q40Q21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool4DY@8
E[DDF]H<G_L:HaP6IcT4HaP>IcTJHaP4G_L2F]H4G_L2F]H4E[D2DY@2BU82AS42@Q03?Nl6@Q06AS42
@Q02AS42BU82AS42?Nl2;F/26<H648@236<2248>124<248412462482124<248436<6248212442488
124@2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool4DY@8E[DDF]H<G_L:HaP6IcT4HaP>IcTJHaP4
G_L2F]H4G_L2F]H4E[D2DY@2BU82AS42@Q03?Nl6@Q06AS42@Q02AS42BU82AS42?Nl2;F/26<H648@2
36<2248>124<248412462482124<248436<6248212442488124@2485Ool00`00Oomoo`0AOol002Qo
o`03001oogoo009oo`aF]A1JeQ1Nm`QS60AW>@QS609W>@IS60IW>AAS60iNm`IJeP9F]@9BU0A>L`96
<@Dmk`I240A6<@A2409:DP96<@8e[@8U:@8HaPH@Q08<HaH48@88@P@48AH8@P@<H`X8@P848@H8@PH4
8@h8@PEoo`03001oogoo03Moo`03001oogoo009oo`aF]A1JeQ1Nm`QS60AW>@QS609W>@IS60IW>AAS
60iNm`IJeP9F]@9BU0A>L`96<@Dmk`I240A6<@A2409:DP96<@8e[@8U:@8HaPH@Q08<HaH48@88@P@4
8AH8@P@<H`X8@P848@H8@PH48@h8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo35Je45[F
45kg26<H16Li26<H0VLi1V<H1VLi56<H3Ukg1U[F0UJe0U:D14ic0THa1Cg_1T8@14Ha148@0TYB0THa
0SF]0RDY0QS61Q240PaS5P@Q0PQ210@Q5PQ210aS2PQ20P@Q1PQ21P@Q3PQ21Goo00<007ooOol0=goo
00<007ooOol00Woo35Je45[F45kg26<H16Li26<H0VLi1V<H1VLi56<H3Ukg1U[F0UJe0U:D14ic0THa
1Cg_1T8@14Ha148@0TYB0THa0SF]0RDY0QS61Q240PaS5P@Q0PQ210@Q5PQ210aS2PQ20P@Q1PQ21P@Q
3PQ21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool:E[DBF]H@G_L:HaP2IcT8HaP2IcT6HaP6
IcTDHaP4G_L2HaP8G_L6F]H4E[D2DY@2CW<2BU8;@Q04AS44@Q02AS42@Q02=Jd29BT26<H25:D248@2
36<2248D12442484124F248436<:248212462484124@2485Ool00`00Oomoo`0gOol00`00Oomoo`02
Ool:E[DBF]H@G_L:HaP2IcT8HaP2IcT6HaP6IcTDHaP4G_L2HaP8G_L6F]H4E[D2DY@2CW<2BU8;@Q04
AS44@Q02AS42@Q02=Jd29BT26<H25:D248@236<2248D12442484124F248436<:248212462484124@
2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`YF]A9JeQ1Nm`YS609W>@QS609W>@IS60IW
>AAS60ANm`9S60QNm`IJePAF]@9BU09>L`9:DP]240A6<@A24096<@92408e[@8U:@8HaP8DY@8@Q08<
H`88@Q@48@@8@P@48AH8@P@<H`X8@P848@H8@P@48A08@PEoo`03001oogoo03Moo`03001oogoo009o
o`YF]A9JeQ1Nm`YS609W>@QS609W>@IS60IW>AAS60ANm`9S60QNm`IJePAF]@9BU09>L`9:DP]240A6
<@A24096<@92408e[@8U:@8HaP8DY@8@Q08<H`88@Q@48@@8@P@48AH8@P@<H`X8@P848@H8@P@48A08
@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo25Je55[F45kg56<H0VLi1V<H1VLi3V<H0Ukg
1V<H0Ukg16<H1Ukg25[F0UJe15:D0TYB0dHa148@0Sg_0T8@0THa1T8@0THa0T8@0S6<0R480QS60QBU
0Q240PaS0PQ250@Q7PQ210aS2PQ20P@Q1PQ20P@Q4PQ21Goo00<007ooOol0=goo00<007ooOol00Woo
25Je55[F45kg56<H0VLi1V<H1VLi3V<H0Ukg1V<H0Ukg16<H1Ukg25[F0UJe15:D0TYB0dHa148@0Sg_
0T8@0THa1T8@0THa0T8@0S6<0R480QS60QBU0Q240PaS0PQ250@Q7PQ210aS2PQ20P@Q1PQ20P@Q4PQ2
1Goo00<007ooOol04Goo000XOol20003Ool8E[DDF]H@G_LDHaP2IcT6HaP6IcT>HaP2G_L6HaP2G_L4
HaP6G_L8F]H2E[D4DY@2BU83AS44@Q02?Nl2@Q02AS46@Q02AS42@Q02<H`28@P26<H25:D248@236<2
248D124N248436<:248212462482124B2484Ool2000iOol20003Ool8E[DDF]H@G_LDHaP2IcT6HaP6
IcT>HaP2G_L6HaP2G_L4HaP6G_L8F]H2E[D4DY@2BU83AS44@Q02?Nl2@Q02AS46@Q02AS42@Q02<H`2
8@P26<H25:D248@236<2248D124N248436<:248212462482124B2484Ool2000COol002Qoo`03001o
ogoo009oo`QF]AAJeQ1Nma1S60IW>@QS609W>A1S609Nm`aS60INm`QJePAF]@9BU09>L`=:DP96<@92
408mk`Y24096<@8mk`8]J`8Q208HaP8DY@8@Q088@Q@48B08@P@<H`X8@P848AX8@PEoo`03001oogoo
03Moo`03001oogoo009oo`QF]AAJeQ1Nma1S60IW>@QS609W>A1S609Nm`aS60INm`QJePAF]@9BU09>
L`=:DP96<@92408mk`Y24096<@8mk`8]J`8Q208HaP8DY@8@Q088@Q@48B08@P@<H`X8@P848AX8@PEo
o`03001oogoo015oo`00:7oo00<007ooOol00Woo25Je55[F45kg46<H1VLi26<H0VLi46<H0Ukg36<H
1Ukg25[F15Je0U:D0Tic0dYB0THa0T8@0Sg_2T8@0THa0Sg_0Re[0R480QS60QBU0Q240PQ250@Q80Q2
10aS2PQ20P@Q6PQ21Goo00<007ooOol0=goo00<007ooOol00Woo25Je55[F45kg46<H1VLi26<H0VLi
46<H0Ukg36<H1Ukg25[F15Je0U:D0Tic0dYB0THa0T8@0Sg_2T8@0THa0Sg_0Re[0R480QS60QBU0Q24
0PQ250@Q80Q210aS2PQ20P@Q6PQ21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool8E[DDF]H>
G_L>HaP:IcTJHaP2G_L<HaP4G_L:F]H4E[D2DY@2CW<3BU82AS42@Q04?Nl:@Q02>Lh2:DX27>L26<H2
48@236<F124P248436<:2482124J2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool8E[DDF]H>G_L>
HaP:IcTJHaP2G_L<HaP4G_L:F]H4E[D2DY@2CW<3BU82AS42@Q04?Nl:@Q02>Lh2:DX27>L26<H248@2
36<F124P248436<:2482124J2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`QF]AAJePiN
m`iS60YW>AYS609Nm`aS60ANm`YJePAF]@9BU09>L`=:DP96<@9240@mk`Y2408icP8YBP8Li`8HaP8@
Q08<HaH48B08@P@<H`X8@P848AX8@PEoo`03001oogoo03Moo`03001oogoo009oo`QF]AAJePiNm`iS
60YW>AYS609Nm`aS60ANm`YJePAF]@9BU09>L`=:DP96<@9240@mk`Y2408icP8YBP8Li`8HaP8@Q08<
HaH48B08@P@<H`X8@P848AX8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo25Je55[F35kg
3V<H36Li0V<H16Li56<H0Ukg36<H15kg2U[F15Je0U:D1Dic0TYB0T8@13g_2T8@0SF]0RDY0QS60QBU
0PaS0PQ250@Q8PQ210aS9PQ21Goo00<007ooOol0=goo00<007ooOol00Woo25Je55[F35kg3V<H36Li
0V<H16Li56<H0Ukg36<H15kg2U[F15Je0U:D1Dic0TYB0T8@13g_2T8@0SF]0RDY0QS60QBU0PaS0PQ2
50@Q8PQ210aS9PQ21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool8E[DDF]H<G_L>HaP<IcT2
HaP4IcTDHaP2G_L<HaP4G_L:F]H4E[D2DY@5CW<2BU82@Q04?Nl:@Q02=Jd29BT26<H25:D236<2248D
124R248436<V2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool8E[DDF]H<G_L>HaP<IcT2HaP4IcTD
HaP2G_L<HaP4G_L:F]H4E[D2DY@5CW<2BU82@Q04?Nl:@Q02=Jd29BT26<H25:D236<2248D124R2484
36<V2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`QF]A1JePiNm`iS60iW>@9S60AW>AAS
609Nm`aS60INm`QJePIF]@9BU0=>L`9:DP96<@9240Hmk`A2408mk`8aS08Q20@DY@8<H`88@PX48@88
@P@48BH8@P8<HbP8@PEoo`03001oogoo03Moo`03001oogoo009oo`QF]A1JePiNm`iS60iW>@9S60AW
>AAS609Nm`aS60INm`QJePIF]@9BU0=>L`9:DP96<@9240Hmk`A2408mk`8aS08Q20@DY@8<H`88@PX4
8@88@P@48BH8@P8<HbP8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo25Je45[F3Ukg3V<H
3VLi0V<H16Li56<H0Ukg36<H1Ukg25[F1UJe0U:D0dic0TYB0THa0T8@1Sg_148@0Sg_0S6<0R4811BU
0PaS0PQ22P@Q0PQ210@Q9PQ20PaS:0Q21Goo00<007ooOol0=goo00<007ooOol00Woo25Je45[F3Ukg
3V<H3VLi0V<H16Li56<H0Ukg36<H1Ukg25[F1UJe0U:D0dic0TYB0THa0T8@1Sg_148@0Sg_0S6<0R48
11BU0PaS0PQ22P@Q0PQ210@Q9PQ20PaS:0Q21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool2
E[DDF]H@G_L>HaPDIcTBHaP4G_L<HaP6G_L:F]H4E[D5DY@2CW<2BU82@Q08?Nl2@Q02?Nl2;F/27>L2
5:D248@236<2248:12422482124X248236<X2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2E[DD
F]H@G_L>HaPDIcTBHaP4G_L<HaP6G_L:F]H4E[D5DY@2CW<2BU82@Q08?Nl2@Q02?Nl2;F/27>L25:D2
48@236<2248:12422482124X248236<X2485Ool00`00Oomoo`0AOol002Qoo`8000=oo`9F]AAJeQ1N
m`iS61AW>A9S60ANm`aS60INm`YJePAF]@EBU09>L`9:DP9240Pmk`92408mk`8]J`8Li`8DY@8@Q08<
H`88@PX48@88@P848BP8@P8<HbP8@PAoo`8003Uoo`8000=oo`9F]AAJeQ1Nm`iS61AW>A9S60ANm`aS
60INm`YJePAF]@EBU09>L`9:DP9240Pmk`92408mk`8]J`8Li`8DY@8@Q08<H`88@PX48@88@P848BP8
@P8<HbP8@PAoo`8001=oo`00:7oo00<007ooOol00Woo15Je45[F4Ukg3V<H46Li56<H15kg2V<H0VLi
0V<H0Ukg0V<H15kg25[F1UJe0e:D0Tic14YB0T8@0SW>13g_0T8@0Sg_0RU:0QS60Q240PaS0PQ220@Q
0PQ22P@Q20Q20P@Q50Q220aS90Q20PaS0PQ21Goo00<007ooOol0=goo00<007ooOol00Woo15Je45[F
4Ukg3V<H46Li56<H15kg2V<H0VLi0V<H0Ukg0V<H15kg25[F1UJe0e:D0Tic14YB0T8@0SW>13g_0T8@
0Sg_0RU:0QS60Q240PaS0PQ220@Q0PQ22P@Q20Q20P@Q50Q220aS90Q20PaS0PQ21Goo00<007ooOol0
4Goo000XOol00`00Oomoo`02Ool4E[D@F]HBG_L>HaP@IcTDHaP4G_L:HaP2IcT2HaP2G_L2HaP4G_L8
F]H6E[D3DY@2CW<4BU82@Q02>Lh4?Nl2@Q02?Nl2:DX26<H248@236<224881242248:12482482124D
248836<T248236<22485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool4E[D@F]HBG_L>HaP@IcTDHaP4
G_L:HaP2IcT2HaP2G_L2HaP4G_L8F]H6E[D3DY@2CW<4BU82@Q02>Lh4?Nl2@Q02?Nl2:DX26<H248@2
36<224881242248:12482482124D248836<T248236<22485Ool00`00Oomoo`0AOol002Qoo`03001o
ogoo009oo`9F]A1JeQ9Nma9S60aW>AIS60ANm`iS60QNm`QJePIF]@=BU0A>L`9:DP92408icP@mk`92
408icP8YBP8HaP8@Q08<H`88@PP48@@8@PP48@P8@P848AH8@PH<HbP8@PEoo`03001oogoo03Moo`03
001oogoo009oo`9F]A1JeQ9Nma9S60aW>AIS60ANm`iS60QNm`QJePIF]@=BU0A>L`9:DP92408icP@m
k`92408icP8YBP8HaP8@Q08<H`88@PP48@@8@PP48@P8@P848AH8@PH<HbP8@PEoo`03001oogoo015o
o`00:7oo00<007ooOol00Woo0UJe45[F4Ukg4V<H36Li5V<H15kg3V<H25kg25[F1UJe0e:D14ic0TYB
0T8@0SW>13g_0T8@0SW>0RU:0QS60Q240PaS0PQ220@Q10Q220@Q20Q20P@Q5PQ21PaS:0Q21Goo00<0
07ooOol0=goo00<007ooOol00Woo0UJe45[F4Ukg4V<H36Li5V<H15kg3V<H25kg25[F1UJe0e:D14ic
0TYB0T8@0SW>13g_0T8@0SW>0RU:0QS60Q240PaS0PQ220@Q10Q220@Q20Q20P@Q5PQ21PaS:0Q21Goo
00<007ooOol04Goo000XOol00`00Oomoo`02Ool2E[D>F]HDG_LDHaP8IcTJHaP2G_L>HaP8G_L:F]H4
E[D5DY@2CW<2BU82AS42?Nl2>Lh4?Nl2>Lh29BT25:D248@236<224881244248812482482124F2486
36<V248236<5Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2E[D>F]HDG_LDHaP8IcTJHaP2G_L>HaP8
G_L:F]H4E[D5DY@2CW<2BU82AS42?Nl2>Lh4?Nl2>Lh29BT25:D248@236<224881244248812482482
124F248636<V248236<5Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`9F]@iJeQANmaAS60QW
>AYS609Nm`iS60QNm`YJePAF]@EBU09>L`9:DP96<@8mk`8icP@mk`8icP8U:@8DY@8@Q08<H`88@PP4
8@@8@PP48@P8@P848AH8@PH<HbH8@P8<H`Eoo`03001oogoo03Moo`03001oogoo009oo`9F]@iJeQAN
maAS60QW>AYS609Nm`iS60QNm`YJePAF]@EBU09>L`9:DP96<@8mk`8icP@mk`8icP8U:@8DY@8@Q08<
H`88@PP48@@8@PP48@P8@P848AH8@PH<HbH8@P8<H`Eoo`03001oogoo015oo`00:7oo00<007ooOol0
0Woo0UJe3U[F55kg5V<H1VLi:V<H25kg2U[F1eJe0U:D14ic0THa0T8@13W>0Sg_0SF]0RDY0QBU10aS
2P@Q1PQ21P@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo00<007ooOol0=goo00<007ooOol00Woo0UJe3U[F
55kg5V<H1VLi:V<H25kg2U[F1eJe0U:D14ic0THa0T8@13W>0Sg_0SF]0RDY0QBU10aS2P@Q1PQ21P@Q
20Q20P@Q5PQ21PaS9PQ20PaS1Goo00<007ooOol04Goo000KOol20004Ool20005Ool00`00Oomoo`02
Ool2E[D>F]HDG_LFHaP6IcTZHaP8G_L:F]H7E[D2DY@4CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<:
1246248612482482124F248636<V248236<5Ool00`00Oomoo`0ZOol20004Ool20005Ool00`00Oomo
o`02Ool2E[D>F]HDG_LFHaP6IcTZHaP8G_L:F]H7E[D2DY@4CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D4
36<:1246248612482482124F248636<V248236<5Ool00`00Oomoo`0AOol001Yoo`04001oogoo0002
Ool01000Oomoo`0017oo00<007ooOol00Woo45[F5Ukg4V<H26Li:V<H2Ukg25[F1eJe15:D0Tic0TYB
0T8@1SW>0S6<0R480QBU10aS2P@Q1PQ21P@Q20Q20P@Q5PQ21PaS:0Q21Goo00<007ooOol0:Goo00@0
07ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool@F]HFG_LBHaP8IcTZHaP:G_L8F]H7E[D4
DY@2CW<2BU82@Q06>Lh2<H`28@P25:D436<:1246248612482482124F248636<X2485Ool00`00Oomo
o`0AOol001Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`000Woo45[F5Ukg4V<H26Li:V<H2Ukg
25[F1eJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2P@Q1PQ21P@Q20Q20P@Q5PQ21PaS:0Q20goo
0`00:goo00@007ooOol0009oo`04001oogoo0004Ool30002Ool@F]HFG_LBHaP8IcTZHaP:G_L8F]H7
E[D4DY@2CW<2BU82@Q06>Lh2<H`28@P25:D436<:1246248612482482124F248636<X2483Ool3000C
Ool001]oo`8000=oo`04001oogoo0004Ool00`00Oomoo`02OolBF]HDG_L@HaP:IcT/HaP<G_L4F]H7
E[D4DY@2CW<2BU82AS42?Nl2>Lh2=Jd2<H`28@P25:D236<2248F12482482124F248636<V248236<5
Ool00`00Oomoo`0ZOol20003Ool01000Oomoo`0017oo00<007ooOol00Woo4U[F55kg46<H2VLi;6<H
35kg15[F1eJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU0PaS0PQ25P@Q20Q20P@Q5PQ21PaS
9PQ20PaS1Goo00<007ooOol04Goo000JOol01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo
009ooa9JeQANma1S60YW>BaS60aNm`AJePMF]@ABU09>L`9:DP96<@8mk`8icP8e[@8aS08Q208DY@8<
H`88@QH48@P8@P848AH8@PH<HbH8@P8<H`Eoo`03001oogoo02Uoo`04001oogoo0002Ool01000Oomo
o`0017oo00<007ooOol00Woo4U[F55kg46<H2VLi;6<H35kg15[F1eJe15:D0Tic0TYB0THa0Sg_0SW>
0SF]0S6<0R480QBU0PaS0PQ25P@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo00<007ooOol04Goo000KOol2
0004Ool20005Ool00`00Oomoo`02OolBF]H:G_L2HaP8G_L<HaP@IcTZHaP<G_L8F]H3E[D6DY@2CW<2
BU82@Q02>Lh2=Jd2;F/28@P25:D236<2248F12482482124D248836<X2485Ool00`00Oomoo`0ZOol2
0004Ool20005Ool00`00Oomoo`02OolBF]H:G_L2HaP8G_L<HaP@IcTZHaP<G_L8F]H3E[D6DY@2CW<2
BU82@Q02>Lh2=Jd2;F/28@P25:D236<2248F12482482124D248836<X2485Ool00`00Oomoo`0AOol0
02Qoo`03001oogoo009ooa9JePYNm`9S60QNm`aS611W>BYS60aNm`QJeP=F]@IBU09>L`9:DP92408i
cP8e[@8]J`8Q208DY@8<H`88@QH48@P8@P848A@8@PP<HbP8@PEoo`03001oogoo03Moo`03001oogoo
009ooa9JePYNm`9S60QNm`aS611W>BYS60aNm`QJeP=F]@IBU09>L`9:DP92408icP8e[@8]J`8Q208D
Y@8<H`88@QH48@P8@P848A@8@PP<HbP8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo4U[F
2Ukg16<H1Ukg2V<H56Li:6<H3Ukg1U[F0eJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS60@Q20Q2
0P@Q50Q220aS:0Q21Goo00<007ooOol0=goo00<007ooOol00Woo4U[F2Ukg16<H1Ukg2V<H56Li:6<H
3Ukg1U[F0eJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS60@Q20Q20P@Q50Q220aS:0Q21Goo00<0
07ooOol04Goo000XOol00`00Oomoo`02OolBF]H:G_L4HaP6G_L:HaPDIcTXHaP>G_L6F]H3E[D6DY@4
CW<2AS42?Nl2=Jd2;F/27>L25:D236<H12482482124D248836<X2485Ool00`00Oomoo`0gOol00`00
Oomoo`02OolBF]H:G_L4HaP6G_L:HaPDIcTXHaP>G_L6F]H3E[D6DY@4CW<2AS42?Nl2=Jd2;F/27>L2
5:D236<H12482482124D248836<X2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009ooa1JeQ1N
m`AS609Nm`YS611W>AAS60AW>@9S60INm`aS60aNm`]JePAF]@9BU0A>L`9:DP92408e[@8YBP8Li`8@
Q08<Ha08@P848@X8@PH48A08@PX<HbH8@P848@88@PEoo`03001oogoo03Moo`03001oogoo009ooa1J
eQ1Nm`AS609Nm`YS611W>AAS60AW>@9S60INm`aS60aNm`]JePAF]@9BU0A>L`9:DP92408e[@8YBP8L
i`8@Q08<Ha08@P848@X8@PH48A08@PX<HbH8@P848@88@PEoo`03001oogoo015oo`00:7oo00<007oo
Ool00Woo45[F45kg16<H0Ukg2V<H46Li56<H16Li0V<H1Ukg36<H35kg2e[F15Je0U:D14ic0TYB0T8@
0SF]0RU:0QcW0Q240PaS40Q20P@Q2PQ21P@Q40Q22PaS9PQ20P@Q0PQ21Goo00<007ooOol0=goo00<0
07ooOol00Woo45[F45kg16<H0Ukg2V<H46Li56<H16Li0V<H1Ukg36<H35kg2e[F15Je0U:D14ic0TYB
0T8@0SF]0RU:0QcW0Q240PaS40Q20P@Q2PQ21P@Q40Q22PaS9PQ20P@Q0PQ21Goo00<007ooOol04Goo
000XOol00`00Oomoo`02Ool@F]H@G_L:HaP2IcT4HaP@IcTDHaP2IcT4HaP4G_L>HaP<G_L;F]H4E[D2
DY@4CW<2BU82AS42>Lh2:DX27>L248@236<22486124Z248@36<T2485Ool00`00Oomoo`0gOol00`00
Oomoo`02Ool@F]H@G_L:HaP2IcT4HaP@IcTDHaP2IcT4HaP4G_L>HaP<G_L;F]H4E[D2DY@4CW<2BU82
AS42>Lh2:DX27>L248@236<22486124Z248@36<T2485Ool00`00Oomoo`0AOol002Qoo`8000=ooa1J
eQ1Nm`YS609W>@AS611W>AAS609W>@AS60ANm`iS60aNm`]JePAF]@9BU0A>L`9:DP96<@8icP8YBP8L
i`8@Q08<H`88@PH48BX8@Q0<Hb@8@PAoo`8003Uoo`8000=ooa1JeQ1Nm`YS609W>@AS611W>AAS609W
>@AS60ANm`iS60aNm`]JePAF]@9BU0A>L`9:DP96<@8icP8YBP8Li`8@Q08<H`88@PH48BX8@Q0<Hb@8
@PAoo`8001=oo`00:7oo00<007ooOol00Woo45[F45kg2V<H0VLi0V<H46Li76<H15kg3V<H3Ukg2E[F
15Je0U:D14ic14YB0Sg_0Re[0QcW0Q2410Q21P@Q9PQ24PaS9PQ21Goo00<007ooOol0=goo00<007oo
Ool00Woo45[F45kg2V<H0VLi0V<H46Li76<H15kg3V<H3Ukg2E[F15Je0U:D14ic14YB0Sg_0Re[0QcW
0Q2410Q21P@Q9PQ24PaS9PQ21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool@F]H@G_L:HaP2
IcT2HaP@IcTLHaP4G_L>HaP>G_L9F]H4E[D2DY@4CW<4BU82?Nl2;F/27>L248@42486124V248B36<V
2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool@F]H@G_L:HaP2IcT2HaP@IcTLHaP4G_L>HaP>G_L9
F]H4E[D2DY@4CW<4BU82?Nl2;F/27>L248@42486124V248B36<V2485Ool00`00Oomoo`0AOol002Qo
o`03001oogoo009ooa1JeQ1Nm`QS60AW>@9S611W>AaS60ANma1S60aNm`UJePAF]@ABU0A>L`9:DP92
408aS08Li`8@Q0@8@P848B`8@Q0<HbH8@PEoo`03001oogoo03Moo`03001oogoo009ooa1JeQ1Nm`QS
60AW>@9S611W>AaS60ANma1S60aNm`UJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848B`8@Q0<
HbH8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo45[F45kg26<H16Li0V<H46Li76<H15kg
46<H35kg2E[F15Je15:D14ic0TYB0T8@0S6<0QcW0Q2410Q20P@Q;0Q240aS9PQ21Goo00<007ooOol0
=goo00<007ooOol00Woo45[F45kg26<H16Li0V<H46Li76<H15kg46<H35kg2E[F15Je15:D14ic0TYB
0T8@0S6<0QcW0Q2410Q20P@Q;0Q240aS9PQ21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool>
F]HBG_L6HaP6IcT4HaP@IcT6HaP2IcTBHaP4G_L@HaP<G_L9F]H6E[D2DY@6CW<2AS42=Jd28@P248@B
2482124N248236<2248<36<V2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool>F]HBG_L6HaP6IcT4
HaP@IcT6HaP2IcTBHaP4G_L@HaP<G_L9F]H6E[D2DY@6CW<2AS42=Jd28@P248@B2482124N248236<2
248<36<V2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`iJeQ9Nm`IS60IW>@AS611W>@IS
609W>A9S60ANma1S60aNm`UJePIF]@9BU0I>L`96<@8e[@8Q208@Q188@P848Ah8@P8<H`88@P`<HbH8
@PEoo`03001oogoo03Moo`03001oogoo009oo`iJeQ9Nm`IS60IW>@AS611W>@IS609W>A9S60ANma1S
60aNm`UJePIF]@9BU0I>L`96<@8e[@8Q208@Q188@P848Ah8@P8<H`88@P`<HbH8@PEoo`03001oogoo
015oo`00:7oo00<007ooOol00Woo3U[F3Ukg2V<H1VLi0V<H76Li46<H15kg16<H15kg26<H3Ukg2E[F
15Je15:D14ic0TYB0Sg_0RU:0Q2440Q210@Q7PQ23PaS:0Q21Goo00<007ooOol0=goo00<007ooOol0
0Woo3U[F3Ukg2V<H1VLi0V<H76Li46<H15kg16<H15kg26<H3Ukg2E[F15Je15:D14ic0TYB0Sg_0RU:
0Q2440Q210@Q7PQ23PaS:0Q21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool>F]H>G_L:HaP6
IcT2HaPLIcT@HaP4G_L4HaP4G_L8HaP>G_L9F]H4E[D4DY@4CW<2BU82?Nl2:DX248@@2484124N248>
36<X2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool>F]H>G_L:HaP6IcT2HaPLIcT@HaP4G_L4HaP4
G_L8HaP>G_L9F]H4E[D4DY@4CW<2BU82?Nl2:DX248@@2484124N248>36<X2485Ool00`00Oomoo`0A
Ool002Qoo`03001oogoo009oo`iJePiNm`QS60IW>@9S61iW>AQS60ANm`YS60iNm`UJePAF]@ABU0A>
L`96<@8aS08DYA88@P848A`8@PH<H`H@Q0P<Hb@8@PEoo`03001oogoo03Moo`03001oogoo009oo`iJ
ePiNm`QS60IW>@9S61iW>AQS60ANm`YS60iNm`UJePAF]@ABU0A>L`96<@8aS08DYA88@P848A`8@PH<
H`H@Q0P<Hb@8@PEoo`03001oogoo015oo`00:7oo0P000goo3U[F3Ukg26<H1VLi0V<H7VLi66<H15kg
2V<H3Ukg2E[F15Je15:D14ic0THa0S6<0QBU4PQ20P@Q70Q21PaS1Q2420aS90Q217oo0P00>Goo0P00
0goo3U[F3Ukg26<H1VLi0V<H7VLi66<H15kg2V<H3Ukg2E[F15Je15:D14ic0THa0S6<0QBU4PQ20P@Q
70Q21PaS1Q2420aS90Q217oo0P004goo000XOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPPIcTF
HaP4G_L:HaP>G_L;F]H2E[D2DY@2E[D4CW<2BU82>Lh26<H2248236<Z248836<248@45:D248@636<P
248236<22485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPPIcTFHaP4G_L:
HaP>G_L;F]H2E[D2DY@2E[D4CW<2BU82>Lh26<H2248236<Z248836<248@45:D248@636<P248236<2
2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`iJePiNm`QS60IW>@9S621W>AIS60ANm`YS
60iNm`]JeP9F]@9BU09F]@A>L`9:DP8icP8HaP88@P8<HbX8@PP<H`8@Q0@DY@8@Q0H<Hb08@P8<H`88
@PEoo`03001oogoo03Moo`03001oogoo009oo`iJePiNm`QS60IW>@9S621W>AIS60ANm`YS60iNm`]J
eP9F]@9BU09F]@A>L`9:DP8icP8HaP88@P8<HbX8@PP<H`8@Q0@DY@8@Q0H<Hb08@P8<H`88@PEoo`03
001oogoo015oo`00:7oo00<007ooOol00Woo1U[F5Ukg2V<H9VLi96<H3Ukg2E[F1UJe0Tic0UJe0U:D
0TYB0Sg_0R484PQ20P@Q7PQ20PaS0Q2411S60QBU0Q240PaS0PQ20PaS90Q21Goo00<007ooOol0=goo
00<007ooOol00Woo1U[F5Ukg2V<H9VLi96<H3Ukg2E[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484PQ20P@Q
7PQ20PaS0Q2411S60QBU0Q240PaS0PQ20PaS90Q21Goo00<007ooOol04Goo000XOol00`00Oomoo`02
Ool6F]HFG_L:HaPVIcTTHaP>G_L9F]H6E[D2CW<2E[D2DY@2BU82?Nl28@PB2482124N248236<248@4
6<H25:D248@236<2248236<T2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool6F]HFG_L:HaPVIcTT
HaP>G_L9F]H6E[D2CW<2E[D2DY@2BU82?Nl28@PB2482124N248236<248@46<H25:D248@236<22482
36<T2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`IJeQINm`IS62YW>AIS60ANm`YS609N
m`AS60YNm`UJePAF]@9BU09F]@9BU09>L`92408U:@8@Q108@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q0H<
Hb@8@PEoo`03001oogoo03Moo`03001oogoo009oo`IJeQINm`IS62YW>AIS60ANm`YS609Nm`AS60YN
m`UJePAF]@9BU09F]@9BU09>L`92408U:@8@Q108@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q0H<Hb@8@PEo
o`03001oogoo015oo`00:7oo00<007ooOol00Woo1U[F5Ukg1V<H:VLi5V<H15kg2V<H0Ukg16<H2Ukg
2E[F15Je0U:D0UJe0U:D0Tic0T8@0RDY0Q2440Q20P@Q7PQ20PaS0Q2411S60QBU0Q241PaS90Q21Goo
00<007ooOol0=goo00<007ooOol00Woo1U[F5Ukg1V<H:VLi5V<H15kg2V<H0Ukg16<H2Ukg2E[F15Je
0U:D0UJe0U:D0Tic0T8@0RDY0Q2440Q20P@Q7PQ20PaS0Q2411S60QBU0Q241PaS90Q21Goo00<007oo
Ool04Goo000XOol00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4G_L6HaP4G_L8HaP8G_L9F]H4E[D8
DY@2AS42;F/25:D6248236<V248436<25:D48@P25:D248@436<V2485Ool00`00Oomoo`0gOol00`00
Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4G_L6HaP4G_L8HaP8G_L9F]H4E[D8DY@2AS42;F/25:D62482
36<V248436<25:D48@P25:D248@436<V2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`IJ
eQINm`IS62YW>AIS60ANm`IS60ANm`QS60QNm`UJePAF]@QBU096<@8]J`8DY@H8@P8<HbH8@P@<H`8D
Y@@Q208DY@8@Q0@<HbH8@PEoo`03001oogoo03Moo`03001oogoo009oo`IJeQINm`IS62YW>AIS60AN
m`IS60ANm`QS60QNm`UJePAF]@QBU096<@8]J`8DY@H8@P8<HbH8@P@<H`8DY@@Q208DY@8@Q0@<HbH8
@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo1U[F5Ukg16<H;6Li5V<H15kg1V<H15kg26<H
25kg2E[F15Je25:D0TYB0SF]0QS61PQ20PaS9PQ210aS0QS612e[0QcW0Q2410aS9PQ21Goo00<007oo
Ool0=goo00<007ooOol00Woo1U[F5Ukg16<H;6Li5V<H15kg1V<H15kg26<H25kg2E[F15Je25:D0TYB
0SF]0QS61PQ20PaS9PQ210aS0QS612e[0QcW0Q2410aS9PQ21Goo00<007ooOol04Goo000XOol20003
Ool6F]HFG_L4HaP/IcTFHaP4G_L6HaP4G_L8HaP8G_L9F]H4E[D8DY@2BU82=Jd26<H6248236<V2484
36<26<H4;F/27>L248@436<V2484Ool2000iOol20003Ool6F]HFG_L4HaP/IcTFHaP4G_L6HaP4G_L8
HaP8G_L9F]H4E[D8DY@2BU82=Jd26<H6248236<V248436<26<H4;F/27>L248@436<V2484Ool2000C
Ool002Qoo`03001oogoo009oo`IJePiNm`aS619W>@A[FQAW>AQS60ANm`QS60INm`AS60QNm`UJePAF
]@QBU09:DP8icP8Q20H8@P8<HaX8@P@<H`P8@P@<H`8Q20@e[@8Q208@Q08<HbP8@PEoo`03001oogoo
03Moo`03001oogoo009oo`IJePiNm`aS619W>@A[FQAW>AQS60ANm`QS60INm`AS60QNm`UJePAF]@QB
U09:DP8icP8Q20H8@P8<HaX8@P@<H`P8@P@<H`8Q20@e[@8Q208@Q08<HbP8@PEoo`03001oogoo015o
o`00:7oo00<007ooOol00Woo1U[F3Ukg36<H4VLi16]J56Li66<H15kg26<H1Ukg16<H25kg2E[F15Je
25:D0TYB0SW>0R481PQ20PaS6PQ210aS20Q210aS0R4813F]0R480Q240PaS:0Q21Goo00<007ooOol0
=goo00<007ooOol00Woo1U[F3Ukg36<H4VLi16]J56Li66<H15kg26<H1Ukg16<H25kg2E[F15Je25:D
0TYB0SW>0R481PQ20PaS6PQ210aS20Q210aS0R4813F]0R480Q240PaS:0Q21Goo00<007ooOol04Goo
000XOol00`00Oomoo`02Ool4F]H>G_L<HaP<IcT2JeX4IcT<JeX@IcTTHaP4G_L8HaP4G_L;F]H4E[D6
DY@2CW<2@Q02:DX236<4248436<H248636<6248436<28@P4=Jd28@P248@236<:2482124L2485Ool0
0`00Oomoo`0gOol00`00Oomoo`02Ool4F]H>G_L<HaP<IcT2JeX4IcT<JeX@IcTTHaP4G_L8HaP4G_L;
F]H4E[D6DY@2CW<2@Q02:DX236<4248436<H248636<6248436<28@P4=Jd28@P248@236<:2482124L
2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`AJePiNm`aS60aW>@9[FPAW>@a[FQ1W>BAS
60ANm`QS60ANm`]JePAF]@IBU09>L`92408YBP8<H`@8@P@<HaP8@PH<H`H8@P@<H`8Q20@e[@8Q208@
Q08<H`X8@P848A`8@PEoo`03001oogoo03Moo`03001oogoo009oo`AJePiNm`aS60aW>@9[FPAW>@a[
FQ1W>BAS60ANm`QS60ANm`]JePAF]@IBU09>L`92408YBP8<H`@8@P@<HaP8@PH<H`H8@P@<H`8Q20@e
[@8Q208@Q08<H`X8@P848A`8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo45kg36<H36Li
56]J46Li<V<H1Ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6PQ210aS20Q210aS0QcW12e[0QcW0Q24
1PaS10Q210@Q70Q21Goo00<007ooOol0=goo00<007ooOol00Woo45kg36<H36Li56]J46Li<V<H1Ekg
35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6PQ210aS20Q210aS0QcW12e[0QcW0Q241PaS10Q210@Q70Q2
1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool@G_L<HaP<IcTDJeX@IcTbHaP5G_L<F]H6DY@2
CW<2AS42;F/25:D4248236<J248436<8248436<27>L4;F/27>L248@636<42484124L2485Ool00`00
Oomoo`0gOol00`00Oomoo`02Ool@G_L<HaP<IcTDJeX@IcTbHaP5G_L<F]H6DY@2CW<2AS42;F/25:D4
248236<J248436<8248436<27>L4;F/27>L248@636<42484124L2485Ool00`00Oomoo`0AOol002Qo
o`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>BQS60AW>@IS60ENm`aJePIBU09>L`9:DP8e[@8DY@@8
@P@<HaH8@P8<H``8@P@<H`8HaP@U:@8DY@8@Q0H<H`@8@P@48A`8@PEoo`03001oogoo03Moo`03001o
ogoo009ooa1Nm`aS60aW>AA[FQ1W>BQS60AW>@IS60ENm`aJePIBU09>L`9:DP8e[@8DY@@8@P@<HaH8
@P8<H``8@P@<H`8HaP@U:@8DY@8@Q0H<H`@8@P@48A`8@PEoo`03001oogoo015oo`0057oo1@000Woo
0P0017oo0P001Goo00<007ooOol00Woo45kg36<H36Li56]J46Li:6<H16Li1V<H1Ekg35[F1U:D0Tic
0TYB0SF]0QBU10Q210aS5PQ20PaS30Q210aS0QS612DY0QBU0Q241PaS10Q210@Q70Q21Goo00<007oo
Ool08goo1@000Woo0P0017oo0P001Goo00<007ooOol00Woo45kg36<H36Li56]J46Li:6<H16Li1V<H
1Ekg35[F1U:D0Tic0TYB0SF]0QBU10Q210aS5PQ20PaS30Q210aS0QS612DY0QBU0Q241PaS10Q210@Q
70Q21Goo00<007ooOol04Goo000FOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo
009oo`03001oogoo009ooa9Nm`IS611W>A1[FPAW>@9[FPiW>BAS60ANm`9S60A[FPAS609Nm`=JePAN
m`QJeP9F]@9BU09F]@9BU09:DP8icP8HaP8<H`88@P@<HaH8@P@<H`P8@P@<H`8@Q08HaP@Li`8DY@@@
Q08<HbH8@PEoo`03001oogoo02Eoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0
0Woo00<007ooOol00Woo4Ukg1V<H46Li46]J16Li0V]J3VLi96<H15kg0V<H16]J16<H0Ukg0e[F15kg
25[F0UJe0U:D0UJe0U:D0TYB0SW>0QS60PaS0PQ210aS5PQ210aS20Q210aS0Q240QS611cW0QBU1124
0PaS9PQ21Goo00<007ooOol04Goo000FOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001o
ogoo009oo`<0009ooa9Nm`IS611W>A1[FPAW>@9[FPiW>BAS60ANm`9S60A[FPAS609Nm`=JePANm`QJ
eP9F]@9BU09F]@9BU09:DP8icP8HaP8<H`88@P@<HaH8@P@<H`P8@P@<H`8@Q08HaP@Li`8DY@@@Q08<
HbH8@P=oo`<002Moo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0`000Woo
4Ukg1V<H46Li46]J16Li0V]J3VLi96<H15kg0V<H16]J16<H0Ukg0e[F15kg25[F0UJe0U:D0UJe0U:D
0TYB0SW>0QS60PaS0PQ210aS5PQ210aS20Q210aS0Q240QS611cW0QBU11240PaS9PQ20goo0`004goo
000FOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9N
m`9JePiNm`IS60iW>AQ[FPiW>BIS609Nm`9S60A[FP9W>@9S60UNm`QJeP9F]@9BU09F]@9BU09:DP8m
k`8Li`8<H`88@P@<HaH8@P@<H`@8@P8<H`88@P@<H`8@Q08DY@@HaP8DY@8@Q0@<HbH8@PEoo`03001o
ogoo02Eoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo
0Ukg0U[F3Ukg1V<H3VLi66]J3VLi9V<H0Ukg0V<H16]J0VLi0V<H2Ekg25[F0UJe0U:D0UJe0U:D0TYB
0Sg_0QcW0PaS0PQ210aS5PQ210aS10Q20PaS0PQ210aS0Q240QBU11S60QBU0Q2410aS9PQ21Goo00<0
07ooOol04Goo000FOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`9Nm`9JePiNm`IS60iW>AQ[FPiW>BIS609Nm`9S60A[FP9W>@9S60UNm`QJeP9F]@9BU09F
]@9BU09:DP8mk`8Li`8<H`88@P@<HaH8@P@<H`@8@P8<H`88@P@<H`8@Q08DY@@HaP8DY@8@Q0@<HbH8
@PEoo`03001oogoo02Eoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<0
07ooOol00Woo0Ukg0U[F3Ukg1V<H3VLi66]J3VLi9V<H0Ukg0V<H16]J0VLi0V<H2Ekg25[F0UJe0U:D
0UJe0U:D0TYB0Sg_0QcW0PaS0PQ210aS5PQ210aS10Q20PaS0PQ210aS0Q240QBU11S60QBU0Q2410aS
9PQ21Goo00<007ooOol04Goo000EOol20004Ool20004Ool20005Ool00`00Oomoo`02Ool4F]H<G_L8
HaP<IcTJJeX>IcTVHaP2G_L2HaP2IcT4JeX2HaP9G_L8F]H2E[D2DY@2E[D2DY@2CW<2@Q029BT236<2
248436<F248436<4248236<2248436<448@45:D248@636<V2485Ool00`00Oomoo`0TOol20004Ool2
0004Ool20005Ool00`00Oomoo`02Ool4F]H<G_L8HaP<IcTJJeX>IcTVHaP2G_L2HaP2IcT4JeX2HaP9
G_L8F]H2E[D2DY@2E[D2DY@2CW<2@Q029BT236<2248436<F248436<4248236<2248436<448@45:D2
48@636<V2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`AJePaNm`QS60aW>AY[FPiW>BIS
609Nm`9S609W>@A[FP9S60UNm`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaH8@P@<H`@8
@P8<H`88@P@<H`@@Q0@DY@8@Q0H<HbH8@PEoo`03001oogoo03Moo`03001oogoo009oo`AJePaNm`QS
60aW>AY[FPiW>BIS609Nm`9S609W>@A[FP9S60UNm`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88
@P@<HaH8@P@<H`@8@P8<H`88@P@<H`@@Q0@DY@8@Q0H<HbH8@PEoo`03001oogoo015oo`00:7oo00<0
07ooOol00Woo0U[F3Ukg26<H36Li76]J46Li9V<H0VLi16]J16<H1ekg25[F0UJe0U:D0UJe0U:D0Tic
0THa0RU:0Q240PQ210aS0PQ20PaS6PQ20PaS10Q20PaS112411BU0Q241PaS9PQ21Goo00<007ooOol0
=goo00<007ooOol00Woo0U[F3Ukg26<H36Li76]J46Li9V<H0VLi16]J16<H1ekg25[F0UJe0U:D0UJe
0U:D0Tic0THa0RU:0Q240PQ210aS0PQ20PaS6PQ20PaS10Q20PaS112411BU0Q241PaS9PQ21Goo00<0
07ooOol04Goo000XOol00`00Oomoo`02Ool2F]H>G_L8HaP<IcTLJeX@IcTVHaP2IcT4JeX4HaP7G_L8
F]H2E[D2DY@2E[D2DY@2CW<2AS42:DX248@2248436<2248236<J248236<4248236<448@45:D248@6
36<V2485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool2F]H>G_L8HaP<IcTLJeX@IcTVHaP2IcT4JeX4
HaP7G_L8F]H2E[D2DY@2E[D2DY@2CW<2AS42:DX248@2248436<2248236<J248236<4248236<448@4
5:D248@636<V2485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009ooa1Nm`IS60aW>A1[FP9_N`a[
FQ1W>AaS609Nm`YS60AW>@AS60MNm`YJePAF]@9BU09>L`96<@8]J`8DY@88@P@<H`88@P8<H`@8@P8<
Ha@8@P@<H`88@P@<H`P@Q0P<H`@8@PP48AP8@PEoo`03001oogoo03Moo`03001oogoo009ooa1Nm`IS
60aW>A1[FP9_N`a[FQ1W>AaS609Nm`YS60AW>@AS60MNm`YJePAF]@9BU09>L`96<@8]J`8DY@88@P@<
H`88@P8<H`@8@P8<Ha@8@P@<H`88@P@<H`P@Q0P<H`@8@PP48AP8@PEoo`03001oogoo015oo`00:7oo
00<007ooOol00Woo45kg1V<H36Li46]J0Vmk36]J46Li76<H0Ukg2V<H16Li16<H1ekg2U[F15Je0U:D
0Tic0THa0Re[0QBU0PQ210aS0PQ20PaS10Q20PaS50Q210aS0PQ210aS212420aS10Q220@Q60Q21Goo
00<007ooOol0=goo00<007ooOol00Woo45kg1V<H36Li46]J0Vmk36]J46Li76<H0Ukg2V<H16Li16<H
1ekg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS0PQ20PaS10Q20PaS50Q210aS0PQ210aS212420aS
10Q220@Q60Q21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool@G_L4HaP>IcT6JeX4Kg/4JeX6
Kg/:JeXBIcT8HaP2IcTTHaP7G_L4F]H2G_L4F]H4E[D2DY@2CW<2BU82<H`26<H2248436<2248236<4
248236<D248436<2248436<648@636<824881244248:124:2485Ool00`00Oomoo`0gOol00`00Oomo
o`02Ool@G_L4HaP>IcT6JeX4Kg/4JeX6Kg/:JeXBIcT8HaP2IcTTHaP7G_L4F]H2G_L4F]H4E[D2DY@2
CW<2BU82<H`26<H2248436<2248236<4248236<D248436<2248436<648@636<824881244248:124:
2485Ool00`00Oomoo`0AOol002Qoo`8000=ooa1Nm`AS60iW>@I[FPA_N`A[FPI_N`Y[FQ9W>@QS609W
>BAS60MNm`AJeP9Nm`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<H`88@P8<H`@8@P8<Ha@8@P@<H`88
@P@<H`H@Q0H<H`P8@PP48@@8@PX48@X8@PAoo`8003Uoo`8000=ooa1Nm`AS60iW>@I[FPA_N`A[FPI_
N`Y[FQ9W>@QS609W>BAS60MNm`AJeP9Nm`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<H`88@P8<H`@8
@P8<Ha@8@P@<H`88@P@<H`H@Q0H<H`P8@PP48@@8@PX48@X8@PAoo`8001=oo`00:7oo00<007ooOol0
0Woo3Ukg1V<H36Li16]J4Vmk2V]J76Li96<H1ekg15[F0Ukg15[F15Je15:D0Tic0SF]0QS61PaS0PQ2
0PaS6PQ210aS0PQ240aS20Q220@Q10Q230@Q20Q21Goo00<007ooOol0=goo00<007ooOol00Woo3Ukg
1V<H36Li16]J4Vmk2V]J76Li96<H1ekg15[F0Ukg15[F15Je15:D0Tic0SF]0QS61PaS0PQ20PaS6PQ2
10aS0PQ240aS20Q220@Q10Q230@Q20Q21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool>G_L6
HaP<IcT4JeXBKg/:JeXLIcTTHaP7G_L4F]H2G_L4F]H4E[D4DY@2CW<2=Jd26<H636<2248236<J2484
36<2248@36<824881244248<12482485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool>G_L6HaP<IcT4
JeXBKg/:JeXLIcTTHaP7G_L4F]H2G_L4F]H4E[D4DY@2CW<2=Jd26<H636<2248236<J248436<2248@
36<824881244248<12482485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`iNm`IS60YW>@I[
FQA_N`Q[FQaW>AAS60ANm`mS60ANm`AJeP9Nm`QJePABU09>L`8icP8HaP8<H`88@PH<Ha88@P8<H`H8
@P@<H`88@Q0<H`P8@PP48@@8@P`48@P8@PEoo`03001oogoo03Moo`03001oogoo009oo`iNm`IS60YW
>@I[FQA_N`Q[FQaW>AAS60ANm`mS60ANm`AJeP9Nm`QJePABU09>L`8icP8HaP8<H`88@PH<Ha88@P8<
H`H8@P@<H`88@Q0<H`P8@PP48@@8@P`48@P8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo
3Ukg1V<H2VLi1V]J56mk26]J76Li56<H15kg3f<H15kg15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ2
1PaS4PQ20PaS1PQ210aS0PQ240aS20Q220@Q10Q230@Q20Q21Goo00<007ooOol0=goo00<007ooOol0
0Woo3Ukg1V<H2VLi1V]J56mk26]J76Li56<H15kg3f<H15kg15[F0Ukg25[F15:D0Tic0SW>0QS60PaS
0PQ21PaS4PQ20PaS1PQ210aS0PQ240aS20Q220@Q10Q230@Q20Q21Goo00<007ooOol04Goo000XOol0
0`00Oomoo`02Ool:G_L8HaP:IcT6JeX6Kg/6Li`8Kg/:JeX@IcTcHaP4G_L6F]H2G_L4F]H4E[D2DY@2
BU82?Nl28@P836<2248236<<248636<:248B36<6248>1248248812442485Ool00`00Oomoo`0gOol0
0`00Oomoo`02Ool:G_L8HaP:IcT6JeX6Kg/6Li`8Kg/:JeX@IcTcHaP4G_L6F]H2G_L4F]H4E[D2DY@2
BU82?Nl28@P836<2248236<<248636<:248B36<6248>1248248812442485Ool00`00Oomoo`0AOol0
02Qoo`03001oogoo009oo`YNm`QS60YW>@I[FPI_N`IcW0Q_N`Y[FQ1W>C=S60ANm`IJeP9Nm`AJePAF
]@9BU09:DP8mk`8Q20P<H`88@P8<H``8@PH<H`X8@Q8<H`H8@Ph48@P8@PP48@@8@PEoo`03001oogoo
03Moo`03001oogoo009oo`YNm`QS60YW>@I[FPI_N`IcW0Q_N`Y[FQ1W>C=S60ANm`IJeP9Nm`AJePAF
]@9BU09:DP8mk`8Q20P<H`88@P8<H``8@PH<H`X8@Q8<H`H8@Ph48@P8@PP48@@8@PEoo`03001oogoo
015oo`00:7oo00<007ooOol00Woo2Ukg1V<H36Li1V]J16mk2W>L0Vmk0W>L16mk2V]J3VLi<f<H1Ukg
15[F0Ukg15[F15Je0U:D0Tic0T8@0R4820aS0PQ20PaS40Q20PaS2PQ250aS10Q24P@Q0PQ22P@Q10Q2
1Goo00<007ooOol0=goo00<007ooOol00Woo2Ukg1V<H36Li1V]J16mk2W>L0Vmk0W>L16mk2V]J3VLi
<f<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0T8@0R4820aS0PQ20PaS40Q20PaS2PQ250aS10Q24P@Q0PQ2
2P@Q10Q21Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool:G_L6HaP<IcT6JeX4Kg/:Li`2Kg/2
Li`4Kg/:JeX>IcTcHaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P836<2248236<@248236<:248D
36<4248B1242248:12442485Ool00`00Oomoo`0gOol00`00Oomoo`02Ool:G_L6HaP<IcT6JeX4Kg/:
Li`2Kg/2Li`4Kg/:JeX>IcTcHaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P836<2248236<@2482
36<:248D36<4248B1242248:12442485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`QNm`QS
60YW>@I[FPA_Na9cW09_N`9[FP9_N`I[FPiW>C=S60YNm`IJePIF]@9>L`92408U:@`<Ha`8@Q@<H`88
@R048@@8@PEoo`03001oogoo03Moo`03001oogoo009oo`QNm`QS60YW>@I[FPA_Na9cW09_N`9[FP9_
N`I[FPiW>C=S60YNm`IJePIF]@9>L`92408U:@`<Ha`8@Q@<H`88@R048@@8@PEoo`03001oogoo015o
o`00:7oo0P000goo25kg26<H2VLi1V]J16mk4W>L0Vmk0V]J0Vmk1V]J3VLi<f<H2Ukg1U[F1UJe0Tic
0T8@0RDY30aS70Q250aS0PQ280@Q10Q217oo0P00>Goo0P000goo25kg26<H2VLi1V]J16mk4W>L0Vmk
0V]J0Vmk1V]J3VLi<f<H2Ukg1U[F1UJe0Tic0T8@0RDY30aS70Q250aS0PQ280@Q10Q217oo0P004goo
000XOol00`00Oomoo`02Ool8G_L6HaP:IcT6JeX4Kg/6Li`6Mkd6Li`8Kg/6JeX@IcTaHaP:G_L8F]H4
E[D2CW<2AS42:DX248@:36<B248236<8248B36<4248P12442485Ool00`00Oomoo`0gOol00`00Oomo
o`02Ool8G_L6HaP:IcT6JeX4Kg/6Li`6Mkd6Li`8Kg/6JeX@IcTaHaP:G_L8F]H4E[D2CW<2AS42:DX2
48@:36<B248236<8248B36<4248P12442485Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`QN
m`IS60YW>@I[FPA_N`IcW0Ig_@IcW0Q_N`I[FQ1W>C5S60YNm`QJePAF]@9>L`96<@8YBP8@Q0X<Ha88
@P8<H`P8@Q8<H`@8@R048@@8@PEoo`03001oogoo03Moo`03001oogoo009oo`QNm`IS60YW>@I[FPA_
N`IcW0Ig_@IcW0Q_N`I[FQ1W>C5S60YNm`QJePAF]@9>L`96<@8YBP8@Q0X<Ha88@P8<H`P8@Q8<H`@8
@R048@@8@PEoo`03001oogoo015oo`00:7oo00<007ooOol00Woo1Ukg26<H26Li26]J16mk17>L27Nm
1W>L16mk0V]J0Vmk16]J4VLi26<H0VLi1V<H0VLi7f<H35kg1U[F15Je0Tic0THa0RU:0Q240PaS0PQ2
1PaS4PQ20PaS20Q21PaS10Q21PaS1PQ290@Q1Goo00<007ooOol0=goo00<007ooOol00Woo1Ukg26<H
26Li26]J16mk17>L27Nm1W>L16mk0V]J0Vmk16]J4VLi26<H0VLi1V<H0VLi7f<H35kg1U[F15Je0Tic
0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q21PaS10Q21PaS1PQ290@Q1Goo00<007ooOol04Goo000X
Ool00`00Oomoo`02Ool6G_L8HaP8IcT8JeX4Kg/4Li`8Mkd6Li`4Kg/2JeX2Kg/4JeXBIcT8HaP2IcT6
HaP2IcTOHaP<G_L6F]H4E[D2CW<2AS42:DX248@236<2248636<B248236<8248636<4248636<6248T
1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool6G_L8HaP8IcT8JeX4Kg/4Li`8Mkd6Li`4Kg/2JeX2
Kg/4JeXBIcT8HaP2IcT6HaP2IcTOHaP<G_L6F]H4E[D2CW<2AS42:DX248@236<2248636<B248236<8
248636<4248636<6248T1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`INm`IS60YW>@A[
FPI_N`9cW0ig_@AcW0A_N`9[FP9_N`A[FQAW>@AS60AW>B1S609W>@ES60aNm`IJePAF]@9BU096<@8Y
BP8@Q08<H`88@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`03001oogoo03Moo`03001oogoo009oo`IN
m`IS60YW>@A[FPI_N`9cW0ig_@AcW0A_N`9[FP9_N`A[FQAW>@AS60AW>B1S609W>@ES60aNm`IJePAF
]@9BU096<@8YBP8@Q08<H`88@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`03001oogoo015oo`00:7oo
00<007ooOol00Woo1Ukg1V<H2VLi16]J1Vmk0W>L3WNm17>L16mk0V]J0Vmk16]J56Li16<H16Li86<H
0VLi1F<H35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo00<0
07ooOol0=goo00<007ooOol00Woo1Ukg1V<H2VLi16]J1Vmk0W>L3WNm17>L16mk0V]J0Vmk16]J56Li
16<H16Li86<H0VLi1F<H35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q2
90@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool6G_L4HaP:IcT6JeX4Kg/4Li`2Mkd:Nmh2
Mkd6Li`2Kg/2JeX2Kg/6JeXJIcT@HaP2IcT>HaP2IcT2HaP?G_L2F]H2G_L2F]H4E[D2DY@2AS42:DX2
48@236<2248636<B248236<8248B36<4248T1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool6G_L4
HaP:IcT6JeX4Kg/4Li`2Mkd:Nmh2Mkd6Li`2Kg/2JeX2Kg/6JeXJIcT@HaP2IcT>HaP2IcT2HaP?G_L2
F]H2G_L2F]H4E[D2DY@2AS42:DX248@236<2248636<B248236<8248B36<4248T1245Ool00`00Oomo
o`0AOol002Qoo`03001oogoo009oo`INm`AS60YW>@I[FPA_N`AcW09g_@YkgP9g_@IcW09_N`9[FP9_
N`I[FQYW>A1S609W>@iS609W>@9S60mNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88@PH<Ha88
@P8<H`P8@Q8<H`@8@R@48@Eoo`03001oogoo03Moo`03001oogoo009oo`INm`AS60YW>@I[FPA_N`Ac
W09g_@YkgP9g_@IcW09_N`9[FP9_N`I[FQYW>A1S609W>@iS609W>@9S60mNm`9JeP9Nm`9JePAF]@9B
U096<@8YBP8@Q08<H`88@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`03001oogoo015oo`00:7oo00<0
07ooOol00Woo1Ukg16<H2VLi16]J16mk17>L17Nm2W_N17Nm17>L1Vmk1V]J76Li3V<H0VLi4V<H3ekg
0U[F0Ukg0U[F15Je0U:D0TYB0RU:0PaS0PQ20P@Q1PaS1PQ20PaS2PQ20PaS20Q24PaS10Q290@Q1Goo
00<007ooOol0=goo00<007ooOol00Woo1Ukg16<H2VLi16]J16mk17>L17Nm2W_N17Nm17>L1Vmk1V]J
76Li3V<H0VLi4V<H3ekg0U[F0Ukg0U[F15Je0U:D0TYB0RU:0PaS0PQ20P@Q1PaS1PQ20PaS2PQ20PaS
20Q24PaS10Q290@Q1Goo00<007ooOol04Goo000XOol20003Ool6G_L4HaP:IcT4JeX4Kg/4Li`4Mkd:
Nmh4Mkd4Li`6Kg/6JeXLIcT>HaP2IcTBHaP?G_L2F]H2G_L2F]H4E[D2DY@2BU82:DX236<224821246
36<6248236<:248236<8248B36<4248T1244Ool2000iOol20003Ool6G_L4HaP:IcT4JeX4Kg/4Li`4
Mkd:Nmh4Mkd4Li`6Kg/6JeXLIcT>HaP2IcTBHaP?G_L2F]H2G_L2F]H4E[D2DY@2BU82:DX236<22482
124636<6248236<:248236<8248B36<4248T1244Ool2000COol002Qoo`03001oogoo009oo`aS60IW
>@I[FP9_N`AcW0Ag_@AkgPIoo`AkgP9g_@AcW0A_N`I[FQaW>BAS60mNm`IJePAF]@9BU096<@8YBP8@
Q0848@P8@PX<H``8@PH<H`H8@P`<H`@8@R@48@Eoo`03001oogoo03Moo`03001oogoo009oo`aS60IW
>@I[FP9_N`AcW0Ag_@AkgPIoo`AkgP9g_@AcW0A_N`I[FQaW>BAS60mNm`IJePAF]@9BU096<@8YBP8@
Q0848@P8@PX<H``8@PH<H`H8@P`<H`@8@R@48@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo
36<H1VLi1V]J0Vmk17>L17Nm17_N1Woo17_N0WNm17>L16mk1V]J76Li96<H3ekg1U[F15Je0U:D0THa
0RU:0Q240P@Q20Q22PaS30Q21PaS1PQ230aS10Q290@Q1Goo00<007ooOol0=goo00<007ooOol00Woo
36<H1VLi1V]J0Vmk17>L17Nm17_N1Woo17_N0WNm17>L16mk1V]J76Li96<H3ekg1U[F15Je0U:D0THa
0RU:0Q240P@Q20Q22PaS30Q21PaS1PQ230aS10Q290@Q1Goo00<007ooOol04Goo000XOol00`00Oomo
o`02Ool<HaP6IcT4JeX4Kg/2Li`4Mkd4Nmh8Ool4Nmh2Mkd4Li`4Kg/6JeXLIcTTHaP?G_L6F]H4E[D2
DY@2AS42:DX248@224821246248:36<V248V1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool<HaP6
IcT4JeX4Kg/2Li`4Mkd4Nmh8Ool4Nmh2Mkd4Li`4Kg/6JeXLIcTTHaP?G_L6F]H4E[D2DY@2AS42:DX2
48@224821246248:36<V248V1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`aS60IW>@A[
FPA_N`9cW0Ag_@AkgPQoo`AkgP9g_@AcW0A_N`I[FQaW>BAS60mNm`IJePAF]@9BU096<@8YBP8@Q088
@P848@H8@PX<HbH8@RH48@Eoo`03001oogoo03Moo`03001oogoo009oo`aS60IW>@A[FPA_N`9cW0Ag
_@AkgPQoo`AkgP9g_@AcW0A_N`I[FQaW>BAS60mNm`IJePAF]@9BU096<@8YBP8@Q088@P848@H8@PX<
HbH8@RH48@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo36<H16Li1V]J0Vmk17>L0WNm17_N
2Woo17_N0WNm17>L1Vmk16]J86Li2V<H0VLi56<H3ekg1U[F15Je0U:D0THa0Re[0QBU0PQ210@Q20Q2
1PaS9PQ29P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo36<H16Li1V]J0Vmk17>L0WNm17_N2Woo
17_N0WNm17>L1Vmk16]J86Li2V<H0VLi56<H3ekg1U[F15Je0U:D0THa0Re[0QBU0PQ210@Q20Q21PaS
9PQ29P@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool<HaP4IcT6JeX2Kg/4Li`2Mkd4Nmh:
Ool4Nmh2Mkd4Li`6Kg/4JeXPIcT:HaP2IcTDHaP?G_L6F]H4E[D2DY@2AS42;F/25:D2248412482486
36<V248V1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool<HaP4IcT6JeX2Kg/4Li`2Mkd4Nmh:Ool4
Nmh2Mkd4Li`6Kg/4JeXPIcT:HaP2IcTDHaP?G_L6F]H4E[D2DY@2AS42;F/25:D224841248248636<V
248V1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`QS60QW>@A[FPA_N`9cW09g_@AkgPio
o`9kgP9g_@AcW0I_N`A[FR9W>B5S60aNm`IJePAF]@9BU096<@8]J`8DY@88@P@48@88@P848@H8@P@<
Hb08@P8<H`@8@RH48@Eoo`03001oogoo03Moo`03001oogoo009oo`QS60QW>@A[FPA_N`9cW09g_@Ak
gPioo`9kgP9g_@AcW0I_N`A[FR9W>B5S60aNm`IJePAF]@9BU096<@8]J`8DY@88@P@48@88@P848@H8
@P@<Hb08@P8<H`@8@RH48@Eoo`03001oogoo015oo`0057oo1@0000=oo`0000000P000goo0P001Goo
00<007ooOol00Woo26<H26Li16]J16mk0W>L0WNm17_N3Woo0W_N0WNm17>L1Vmk16]J8VLi8F<H35kg
1U[F15Je0U:D0THa0Re[0QBU0PQ210@Q0PQ20P@Q1PQ210aS80Q20PaS10Q29P@Q1Goo00<007ooOol0
8goo1@0000=oo`0000000P000goo0P001Goo00<007ooOol00Woo26<H26Li16]J16mk0W>L0WNm17_N
3Woo0W_N0WNm17>L1Vmk16]J8VLi8F<H35kg1U[F15Je0U:D0THa0Re[0QBU0PQ210@Q0PQ20P@Q1PQ2
10aS80Q20PaS10Q29P@Q1Goo00<007ooOol04Goo000FOol01@00Oomoogoo00001Goo00@007ooOol0
00Aoo`03001oogoo009oo`IS60QW>@I[FP9_N`AcW09g_@9kgQ1oo`9kgPAg_@9cW0I_N`A[FR1W>B=S
60YNm`QJePAF]@9BU096<@8]J`8DY@8<H`88@P848@88@P848@88@P848Ah8@P8<H`H8@P8<H`@8@RH4
8@Eoo`03001oogoo02Eoo`05001oogooOol00005Ool01000Oomoo`0017oo00<007ooOol00Woo1V<H
26Li1V]J0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8f<H2Ukg25[F15Je0U:D0THa0Re[
0QBU0PaS0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q1Goo00<007ooOol04Goo000F
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0`000Woo1V<H26Li1V]J0Vmk17>L
0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8f<H2Ukg25[F15Je0U:D0THa0Re[0QBU0PaS0PQ20P@Q
0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q0goo0`009goo00<007ooOol00Woo00<007ooOol0
0Woo00@007ooOol000Aoo`<0009oo`IS60QW>@I[FP9_N`AcW09g_@9kgQ1oo`9kgPAg_@9cW0I_N`A[
FR1W>B=S60YNm`QJePAF]@9BU096<@8]J`8DY@8<H`88@P848@88@P848@88@P848Ah8@P8<H`H8@P8<
H`@8@RH48@=oo`<001=oo`005Woo00<007ooOol00goo00D007ooOomoo`00009oo`03001oogoo009o
o`03001oogoo009oo`AS60QW>@I[FPA_N`9cW09g_@9kgQ9oo`AkgP9g_@9cW0I_N`I[FQYW>BUS60QN
m`QJePAF]@9BU09:DP8aS08HaP8<H`88@P848@88@P848@88@P@48BP8@RP48@Eoo`03001oogoo02Eo
o`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool4HaP8IcT6
JeX4Kg/2Li`2Mkd2NmhBOol4Nmh2Mkd2Li`6Kg/6JeXJIcTYHaP8G_L8F]H4E[D2DY@2BU82<H`26<H2
36<224821242248212422484124X248X1245Ool00`00Oomoo`0AOol001Ioo`05001oogooOol00002
Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li1V]J16mk0W>L0WNm0W_N
4Woo17_N0WNm0W>L1Vmk1V]J6VLi:F<H25kg25[F15Je0U:D0TYB0S6<0QS60PaS0PQ20P@Q0PQ20P@Q
0PQ210@Q:0Q2:0@Q1Goo00<007ooOol09Goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool4HaP8IcT6JeX4Kg/2Li`2Mkd2NmhBOol4Nmh2Mkd2Li`6Kg/6JeXJ
IcTYHaP8G_L8F]H4E[D2DY@2BU82<H`26<H236<224821242248212422484124X248X1245Ool00`00
Oomoo`0AOol001Eoo`8000Aoo`8000Aoo`8000Eoo`03001oogoo009oo`AS60IW>@I[FPA_N`9cW0Ag
_@9kgQAoo`9kgP9g_@9cW0I_N`I[FQaW>@YS60AW>@iS609Nm`AS60=Nm`AS60INm`QJePAF]@9BU09:
DP8e[@8Q208@Q088@P848@88@P848@88@P@48@88@P848A08@P@<Ha08@RP48@Eoo`03001oogoo02Ao
o`8000Aoo`8000Aoo`8000Eoo`03001oogoo009oo`AS60IW>@I[FPA_N`9cW0Ag_@9kgQAoo`9kgP9g
_@9cW0I_N`I[FQaW>@YS60AW>@iS609Nm`AS60=Nm`AS60INm`QJePAF]@9BU09:DP8e[@8Q208@Q088
@P848@88@P848@88@P@48@88@P848A08@P@<Ha08@RP48@Eoo`03001oogoo015oo`00:7oo00<007oo
Ool00Woo16<H1VLi1V]J16mk0W>L17Nm0W_N57oo0W_N0WNm0W>L1Vmk1V]J76Li2V<H16Li3V<H0Ukg
16<H0ekg16<H1Ukg25[F15Je0U:D0TYB0SF]0R480Q240PQ20P@Q0PQ20P@Q0PQ210@Q0PQ20P@Q40Q2
10aS40Q2:0@Q1Goo00<007ooOol0=goo00<007ooOol00Woo16<H1VLi1V]J16mk0W>L17Nm0W_N57oo
0W_N0WNm0W>L1Vmk1V]J76Li2V<H16Li3V<H0Ukg16<H0ekg16<H1Ukg25[F15Je0U:D0TYB0SF]0R48
0Q240PQ20P@Q0PQ20P@Q0PQ210@Q0PQ20P@Q40Q210aS40Q2:0@Q1Goo00<007ooOol04Goo000XOol0
0`00Oomoo`02Ool2HaP6IcT6JeX4Kg/4Li`2Mkd4NmhDOol2Nmh2Mkd2Li`6Kg/6JeXZIcT>HaP9G_L4
HaP6G_L8F]H4E[D2DY@2BU82?Nl29BT25:D224821246248412422488124:248836<<248X1245Ool0
0`00Oomoo`0gOol00`00Oomoo`02Ool2HaP6IcT6JeX4Kg/4Li`2Mkd4NmhDOol2Nmh2Mkd2Li`6Kg/6
JeXZIcT>HaP9G_L4HaP6G_L8F]H4E[D2DY@2BU82?Nl29BT25:D224821246248412422488124:2488
36<<248X1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`9S60IW>@I[FPA_N`AcW09g_@Ak
gQAoo`9kgP9g_@9cW0I_N`I[FRYW>@iS60UNm`AS60INm`QJePAF]@9BU09:DP8mk`8U:@8DY@88@P84
8@H8@P@48@88@PP48@X8@PP<H``8@RP48@Eoo`03001oogoo03Moo`03001oogoo009oo`9S60IW>@I[
FPA_N`AcW09g_@AkgQAoo`9kgP9g_@9cW0I_N`I[FRYW>@iS60UNm`AS60INm`QJePAF]@9BU09:DP8m
k`8U:@8DY@88@P848@H8@P@48@88@PP48@X8@PP<H``8@RP48@Eoo`03001oogoo015oo`00:7oo00<0
07ooOol00Woo26Li26]J0Vmk0W>L17Nm17_N4Woo17_N0WNm0W>L0Vmk0V]J0Vmk26]J8VLi66<H3ekg
25[F15Je0Tic0THa0T8@0S6<0QcW0PaS1PQ210@Q0PQ22P@Q1PQ210aS1PQ20PaS10Q20PaS1PQ2:0@Q
1Goo00<007ooOol0=goo00<007ooOol00Woo26Li26]J0Vmk0W>L17Nm17_N4Woo17_N0WNm0W>L0Vmk
0V]J0Vmk26]J8VLi66<H3ekg25[F15Je0Tic0THa0T8@0S6<0QcW0PaS1PQ210@Q0PQ22P@Q1PQ210aS
1PQ20PaS10Q20PaS1PQ2:0@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool8IcT8JeX2Kg/2
Li`4Mkd4NmhBOol4Nmh2Mkd2Li`2Kg/2JeX2Kg/8JeXRIcTHHaP?G_L8F]H4E[D2CW<2AS42@Q02<H`2
7>L236<624841242248:1246248436<6248236<4248236<6248X1245Ool00`00Oomoo`0gOol00`00
Oomoo`02Ool8IcT8JeX2Kg/2Li`4Mkd4NmhBOol4Nmh2Mkd2Li`2Kg/2JeX2Kg/8JeXRIcTHHaP?G_L8
F]H4E[D2CW<2AS42@Q02<H`27>L236<624841242248:1246248436<6248236<4248236<6248X1245
Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`QW>@I[FPA_N`9cW09g_@AkgQAoo`9kgPAg_@9c
W09_N`9[FPA_N`Q[FR1W>AQS60mNm`QJeP9F]@9BU09>L`A6<@8icP8U:@8DY@H8@Q048AH8@P8<H`H8
@RP48@Eoo`03001oogoo03Moo`03001oogoo009oo`QW>@I[FPA_N`9cW09g_@AkgQAoo`9kgPAg_@9c
W09_N`9[FPA_N`Q[FR1W>AQS60mNm`QJeP9F]@9BU09>L`A6<@8icP8U:@8DY@H8@Q048AH8@P8<H`H8
@RP48@Eoo`03001oogoo015oo`00:7oo0P000goo26Li1V]J16mk0W>L0WNm17_N57oo0W_N17Nm0W>L
0Vmk0V]J16mk26]J86Li66<H3ekg25[F0UJe0U:D0Tic14Ha0SW>0RDY0QBU1PQ240@Q5PQ20PaS1PQ2
:0@Q17oo0P00>Goo0P000goo26Li1V]J16mk0W>L0WNm17_N57oo0W_N17Nm0W>L0Vmk0V]J16mk26]J
86Li66<H3ekg25[F0UJe0U:D0Tic14Ha0SW>0RDY0QBU1PQ240@Q5PQ20PaS1PQ2:0@Q17oo0P004goo
000XOol00`00Oomoo`02Ool8IcT4JeX6Kg/2Li`2Mkd4NmhDOol2Nmh4Mkd2Li`2Kg/2JeX4Kg/>JeX2
IcT4JeXDIcTHHaP?G_L2F]H2G_L4F]H2E[D2DY@2CW<4AS42?Nl2<H`27>L236<4248D124B248236<6
248X1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool8IcT4JeX6Kg/2Li`2Mkd4NmhDOol2Nmh4Mkd2
Li`2Kg/2JeX4Kg/>JeX2IcT4JeXDIcTHHaP?G_L2F]H2G_L4F]H2E[D2DY@2CW<4AS42?Nl2<H`27>L2
36<4248D124B248236<6248X1245Ool00`00Oomoo`0AOol002Qoo`03001oogoo009oo`QW>@A[FPI_
N`9cW09g_@AkgQAoo`9kgPAg_@9cW09_N`9[FPA_N`i[FP9W>@A[FQAW>AQS60mNm`9JeP9Nm`AJeP9F
]@9BU09>L`A6<@8mk`8aS08Li`8<H`@8@Q@48A88@P8<H`H8@RP48@Eoo`03001oogoo03Moo`03001o
ogoo009oo`QW>@A[FPI_N`9cW09g_@AkgQAoo`9kgPAg_@9cW09_N`9[FPA_N`i[FP9W>@A[FQAW>AQS
60mNm`9JeP9Nm`AJeP9F]@9BU09>L`A6<@8mk`8aS08Li`8<H`@8@Q@48A88@P8<H`H8@RP48@Eoo`03
001oogoo015oo`00:7oo00<007ooOol00Woo1VLi1V]J16mk17>L0WNm17_N57oo0W_N17Nm0W>L26mk
5V]J4VLi26<H16Li3V<H3Ekg0U[F15kg0U[F0UJe0U:D0TYB0THa148@0SW>0RDY0Q2410Q25P@Q30Q2
1PaS10Q2:P@Q1Goo00<007ooOol0=goo00<007ooOol00Woo1VLi1V]J16mk17>L0WNm17_N57oo0W_N
17Nm0W>L26mk5V]J4VLi26<H16Li3V<H3Ekg0U[F15kg0U[F0UJe0U:D0TYB0THa148@0SW>0RDY0Q24
10Q25P@Q30Q21PaS10Q2:P@Q1Goo00<007ooOol04Goo000XOol00`00Oomoo`02Ool6IcT6JeX4Kg/4
Li`2Mkd4NmhDOol2Nmh4Mkd2Li`8Kg/FJeXBIcT8HaP4IcT>HaP=G_L2F]H4G_L2F]H2E[D2DY@2BU82
AS44@Q02>Lh29BT248@4248F124<248636<4248Z1245Ool00`00Oomoo`0gOol00`00Oomoo`02Ool6
IcT6JeX4Kg/4Li`2Mkd4NmhDOol2Nmh4Mkd2Li`8Kg/FJeXBIcT8HaP4IcT>HaP=G_L2F]H4G_L2F]H2
E[D2DY@2BU82AS44@Q02>Lh29BT248@4248F124<248636<4248Z1245Ool00`00Oomoo`0AOol002Qo
o`03001oogoo009oo`IW>@I[FPA_N`AcW09g_@9kgQAoo`AkgPAg_@9cW0I_N`Q[FPQW>@Q[FQ9W>@QS
60AW>@iS60eNm`9JePANm`9JeP9F]@9BU09:DP96<@8mk`96<@92408aS08HaP8<H`@8@QX48A08@RX4
8@Eoo`03001oogoo03Moo`03001oogoo009oo`IW>@I[FPA_N`AcW09g_@9kgQAoo`AkgPAg_@9cW0I_
N`Q[FPQW>@Q[FQ9W>@QS60AW>@iS60eNm`9JePANm`9JeP9F]@9BU09:DP96<@8mk`96<@92408aS08H
aP8<H`@8@QX48A08@RX48@Eoo`03001oogoo015oo`00:7oo00<007ooOol00Woo1VLi1V]J16mk17>L
0WNm0W_N57oo17_N17Nm0W>L1Vmk26]J26Li26]J4VLi26<H16Li3V<H3Ekg0U[F15kg0U[F0UJe0U:D
0TYB0THa0Sg_0THa0T8@0S6<0QS60PaS10Q26P@Q40Q2:P@Q1Goo00<007ooOol0=goo00<007ooOol0
0Woo1VLi1V]J16mk17>L0WNm0W_N57oo17_N17Nm0W>L1Vmk26]J26Li26]J4VLi26<H16Li3V<H3Ekg
0U[F15kg0U[F0UJe0U:D0TYB0THa0Sg_0THa0T8@0S6<0QS60PaS10Q26P@Q40Q2:P@Q1Goo00<007oo
Ool04Goo000XOol00`00Oomoo`3oOol9Ool00`00Oomoo`0gOol00`00Oomoo`3oOol9Ool00`00Oomo
o`0AOol002Qoo`03001oogoo0?moo`Uoo`03001oogoo03Moo`03001oogoo0?moo`Uoo`03001oogoo
015oo`00:7oo00<007ooOol0ogoo2Goo00<007ooOol0=goo00<007ooOol0ogoo2Goo00<007ooOol0
4Goo000XOol20003Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool2000iOol20003Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`08Ool00`00Oomoo`07Ool2000COol002Qo
ool000d003Uoool000d001=oo`00ogooogooSWoo003oOoooOon>Ool00?mooomoohioo`00ogooogoo
SWoo003oOoooOon>Ool00:Qoo`<00?mood9oo`<009eoo`00ZGoo00<007ooOol0ogoo@Woo00<007oo
Ool0W7oo001nOol40003Ool50002Ool40007Ool30003Ool700001Goo001oo`00Ool00`000goo0`00
17oo0`001goo0`000goo0`0000=oo`0000000Woo0P0017oo0P0017oo0P00iWoo10000goo1@000Woo
10001goo0`000goo1`0000Eoo`00Ool007oo00<000=oo`<000Aoo`<000Moo`<000=oo`<00003Ool0
0000009oo`8000Aoo`8000Aoo`8006aoo`00Ogoo00@007ooOol0009oo`@0009oo`04001oogoo0008
Ool01000Oomoo`000Woo10000Woo00L007oo001oo`00Ool00002Ool01@00Oomoogoo000017oo00<0
07ooOol02Goo00<007ooOol00goo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo
00@007ooOol00>Ioo`04001oogoo0002Ool40002Ool01000Oomoo`0027oo00@007ooOol0009oo`@0
009oo`07001oo`00Ool007oo00000Woo00D007ooOomoo`0000Aoo`03001oogoo00Uoo`03001oogoo
00=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo001[Ool007mo
o`04001oogoo0005Ool01000Oomoo`000Woo00<007ooOol02Goo00<007ooOol00goo00X007ooOol0
07oo001oo`00Ool0009oo`05001oogooOol00004Ool40008Ool30003Ool01000Oomoo`000Woo00@0
07ooOol0009oo`03001oogoo00=oo`04001oogoo003VOol01000Oomoo`001Goo00@007ooOol0009o
o`03001oogoo00Uoo`03001oogoo00=oo`0:001oogoo001oo`00Ool007oo0002Ool01@00Oomoogoo
000017oo100027oo0`000goo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`03Ool01000
Oomoo`00Jgoo001oOol30004Ool30003Ool30009Ool20004Ool300001goo00000000Ool007oo00@0
00Aoo`03001oogoo00=oo`8000Uoo`04001oogoo0002Ool30004Ool20002Ool50003Ool2003WOol3
0004Ool30003Ool30009Ool20004Ool300001goo00000000Ool007oo00@000Aoo`03001oogoo00=o
o`8000Uoo`04001oogoo0002Ool30004Ool20002Ool50003Ool2001/Ool007moo`04001oogoo000;
Ool00`00Oomoo`06Ool01000Oomoo`005Goo00<007ooOol03Woo00@007ooOol0009oo`03001oogoo
00Uoo`03001oogoo0>eoo`04001oogoo000;Ool00`00Oomoo`06Ool01000Oomoo`005Goo00<007oo
Ool03Woo00@007ooOol0009oo`03001oogoo00Uoo`03001oogoo079oo`00OWoo10002goo0P0027oo
100057oo0P003goo10000Woo0P00nWoo10002goo0P0027oo100057oo0P003goo10000Woo0P00P7oo
003oOoooOon>Ool00?mooomoohioo`00ogooogooSWoo003oOoooOon>Ool00?mooomoohioo`00ogoo
ogooSWoo003oOoooOon>Ool00?mooomoohioo`00ogooogooSWoo003oOoooOon>Ool00001\
\>"],
  ImageRangeCache->{{{0, 651.813}, {309.813, 0}} -> {-0.0519562, -0.0238146, \
0.00322779, 0.00322779}, {{16.0625, 311.125}, {302.375, 7.375}} -> {-22.9277, \
-12.4272, 0.499015, 0.499015}, {{340.625, 635.688}, {302.375, 7.375}} -> \
{-184.889, -12.4272, 0.499015, 0.499015}}]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", 
      StyleBox[
        RowBox[{"  ", 
          StyleBox[" ",
            FontVariations->{"Underline"->True}]}]], 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(SampleFourier = Chop[Abs[Fourier[sample]]];\)\)], "Input"],

Cell[BoxData[
    \(\(BadSampleFourier = Chop[Abs[Fourier[bsample]]];\)\)], "Input"],

Cell["\<\
filterMatrix=
imageNormalize[BadSampleFourier]-imageNormalize[SampleFourier];\
\>", "Input"],

Cell["defectSpect=filterMatrix Fourier[bsample];", "Input"],

Cell["\<\
defectPosition=imageNormalize[Chop[InverseFourier[defectSpect]]];\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Identified) show
129.000 12.813 moveto
(Defect) show
165.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000LOol2
000QOol40003Ool2000POol30002Ool2000NOol30004Ool2000OOol20004Ool2000KOol50002Ool2
0004Ool2000GOol500000goo000000020003Ool2000COol001]oo`04001oogoo000POol00`00Oomo
o`03Ool01000Oomoo`0087oo00@007ooOol0009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo00@007ooOol0009oo`04001oogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0
009oo`03001oogoo01Ioo`05001oogooOol00005Ool01000Oomoo`004Woo000KOol01000Oomoo`00
8Goo00<007ooOol00Woo00@007ooOol001eoo`D00005Ool007ooOol0000MOol01000Oomoo`000Woo
00@007ooOol001eoo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001o
ogoo0002Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`004Woo000K
Ool01000Oomoo`008Woo00D007ooOomoo`00009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo0`000goo00@007ooOol001ioo`8000=oo`04001oogoo000LOol01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo01Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00
Oomoo`0@Ool001]oo`04001oogoo000POol01000Oomoo`000Woo00@007ooOol001ioo`03001oo`00
009oo`04001oogoo000NOol00`00Oomoo`02Ool01000Oomoo`007Goo00@007ooOol0009oo`04001o
ogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo01Ioo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol047oo000LOol2000ROol20004Ool2000POol20003Ool2
000OOol30003Ool2000OOol20004Ool2000LOol20004Ool20004Ool2000HOol20004Ool20004Ool2
000COol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Qoool0
00D000Aoo`0067oo00<007ooOol00Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo0P0017oo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool0015oo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@0
07ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@007ooOol000Aoo`<00?io
o`<000Aoo`0047oo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@0
07ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`004Goo0P001Goo00<007ooOol0ogoo
0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo
0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00
Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
0P00ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo
0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00
Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol2003oOol1Ool20004Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001o
ogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool0
0`00Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001o
ogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool0
0`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo
0Goo00<007ooOol00Woo000:Ool40003Ool20005Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
00Yoo`03001oogoo00=oo`04001oogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000]o
o`03001oogoo009oo`04001oogoo0004Ool3003nOol30004Ool000aoo`05001oogooOol00002Ool0
0`00Oomoo`02Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000
Oomoo`0017oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000;Ool20004Ool20005Ool00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol2003oOol1Ool20004Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo
009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo
009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo0P00ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool000aoo`<0009oo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo
009oo`003Goo00@007ooOol0009oo`03001oogoo009oo`03001oogoo0?moo`5oo`03001oogoo009o
o`002Woo1@0000Eoo`00Oomoo`0000Aoo`<00?ioo`<000Aoo`002Woo00@007ooOol0009oo`04001o
ogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000]oo`03001oo`00009oo`04001oogoo
0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000aoo`8000=oo`8000Eoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`8003eoo`H00;eoo`8000Aoo`0067oo00<007ooOol0?7oo1P00_Woo00<007ooOol00Woo000HOol0
0`00Oomoo`0jOol<002jOol00`00Oomoo`02Ool001Qoo`03001oogoo03Yoo`h00;Qoo`03001oogoo
009oo`0067oo00<007ooOol0>Woo3P00^7oo00<007ooOol00Woo000HOol00`00Oomoo`0jOol>002h
Ool00`00Oomoo`02Ool001Qoo`03001oogoo03Yoo`h00;Qoo`03001oogoo009oo`0067oo00<007oo
Ool0>7oo4P00]Woo00<007ooOol00Woo000HOol00`00Oomoo`0hOolB002fOol00`00Oomoo`02Ool0
01Qoo`03001oogoo03MooaD00;Aoo`03001oogoo009oo`0067oo0P00>7oo5@00/goo0P0017oo000H
Ool00`00Oomoo`0eOolG002dOol00`00Oomoo`02Ool001Qoo`03001oogoo03EooaL00;Aoo`03001o
ogoo009oo`0067oo00<007ooOol0=Goo5@00]Woo00<007ooOol00Woo000HOol00`00Oomoo`0eOolE
002fOol00`00Oomoo`02Ool001Qoo`03001oogoo03Eooa400;Yoo`03001oogoo009oo`0067oo00<0
07ooOol0=Goo4@00^Woo00<007ooOol00Woo000HOol00`00Oomoo`0gOol=002lOol00`00Oomoo`02
Ool001Qoo`03001oogoo03Moo`d00;aoo`03001oogoo009oo`0067oo00<007ooOol0=goo2`00_Woo
00<007ooOol00Woo000HOol2000hOol;002mOol20004Ool001Qoo`03001oogoo03Qoo`X00;ioo`03
001oogoo009oo`0067oo00<007ooOol0>7oo2P00_Woo00<007ooOol00Woo000HOol00`00Oomoo`0j
Ool60030Ool00`00Oomoo`02Ool001Qoo`03001oogoo03Yoo`H00<1oo`03001oogoo009oo`0067oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
00Yoo`<000Aoo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`002Woo00@007ooOol0009o
o`04001oogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool0
1000Oomoo`0017oo0`00oWoo0`0017oo000:Ool30003Ool01000Oomoo`0017oo00<007ooOol0ogoo
0Goo00<007ooOol00Woo000;Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000;Ool30003Ool20005Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo
009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo
009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo0P00ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol2003oOol1Ool20004Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000]o
o`8000Aoo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`002Woo00@007ooOol0009oo`04
001oogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000
Oomoo`0017oo0`00oWoo0`0017oo000;Ool20003Ool01000Oomoo`0017oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03
001oogoo009oo`002goo0P0017oo0P001Goo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol0
0`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`00
67oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02
Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007oo
Ool00Woo000HOol2003oOol1Ool20004Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`00
67oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02
Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007oo
Ool00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03
001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo0Goo00<007oo
Ool00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03
001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0
ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo0?moo`5oo`03001oogoo009oo`0067oo0P00ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0
ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo0004Ool5
0002Ool20004Ool20005Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000Ioo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol0ogoo0Goo00<007ooOol00Woo0006
Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`<00?ioo`<000Aoo`001Woo
00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool000Ioo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007oo
Ool0ogoo0Goo00<007ooOol00Woo0005Ool20004Ool20004Ool20005Ool00`00Oomoo`3oOol1Ool0
0`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo
0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo
0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00
Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo
0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo
0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00
Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo0P00ogoo0Goo0P0017oo000HOol00`00
Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001o
ogoo009oo`0067oo0P00ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001o
ogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool0
0`00Oomoo`02Ool000Aoo`D00003Ool00000008000=oo`8000Eoo`03001oogoo0?moo`5oo`03001o
ogoo009oo`001Woo00D007ooOomoo`0000Eoo`04001oogoo0004Ool00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool000Ioo`03001oogoo009oo`03001oogoo009oo`04001oogoo0004Ool3003nOol30004
Ool000Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool000Ioo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo
00<007ooOol0ogoo0Goo00<007ooOol00Woo0005Ool20004Ool20004Ool20005Ool00`00Oomoo`3o
Ool1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007oo
Ool0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03
001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000H
Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007oo
Ool0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03
001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000H
Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009o
o`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03
001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02=oo`03001oogoo019oo`03001oogoo009oo`00
67oo0P000goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<0
07ooOol01goo00<007ooOol01goo0P0017oo000HOooo00050004Ool00?moob5oo`00ogoo8Goo003o
OolQOol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00JGoo0`000goo10000Woo0`0000=o
o`0000000Woo0P000Woo0P0017oo0`000Woo10000goo0`000goo0`000goo10001Woo100017oo0`00
0Woo10000goo0`000goo0`000goo0P00EGoo001ZOol01@00Oomoogoo00000Woo00@007ooOol000Eo
o`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo00<007ooOol017oo00D007ooOomo
o`0000Eoo`04001oogoo0008Ool01000Oomoo`000Woo00<007ooOol017oo00<007ooOol00Woo00<0
07ooOol00goo00<007ooOol00goo00@007ooOol005Aoo`00JWoo00D007ooOomoo`00009oo`03001o
ogoo00@0009oo`04001oogoo0002Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`04Ool0
1000Oomoogoo10000Woo00@007ooOol000Qoo`04001oogoo0002Ool40003Ool00`00Oomoo`02Ool4
0002Ool00`00Oomoo`03Ool00`00Oomoo`1EOol006Yoo`03001oogoo009oo`<000=oo`80009oo`@0
009oo`D000=oo`8000=oo`@000=oo`8000Aoo`8000Aoo`<000Qoo`04001oogoo0003Ool20003Ool4
0003Ool20004Ool300000goo00000003001DOol006Yoo`03001oogoo00Aoo`03001oogoo00aoo`03
001oogoo00Yoo`03001oogoo015oo`03001oogoo00Ioo`04001oogoo0009Ool00`00Oomoo`0>Ool0
0`00Oomoo`1EOol006Uoo`<000Aoo`8001Ioo`03001oogoo00=oo`8000Aoo`03001oogoo00Uoo`80
00Moo`@000]oo`8006Ioo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.1932, -8.85118, 0.514055, \
0.514055}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wSample = waveletMatrix[128, coif6] . sample;\)\)], "Input"],

Cell[BoxData[
    \(\(wBadSample = waveletMatrix[128, coif6] . bsample;\)\)], "Input"],

Cell["\<\
filterMatrix=
imageNormalize[wBadSample]-imageNormalize[wSample];\
\>", "Input"],

Cell["defectSpect=filterMatrix wBadSample;", "Input"],

Cell["\<\
defectPosition=imageNormalize[Transpose[waveletMatrix[128,coif6]].defectSpect]\
;\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False]\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Identified) show
129.000 12.813 moveto
(Defect) show
165.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000LOol2
000QOol40003Ool2000POol30002Ool2000NOol30004Ool2000OOol20004Ool2000KOol50002Ool2
0004Ool2000GOol500000goo000000020003Ool2000COol001]oo`04001oogoo000POol00`00Oomo
o`03Ool01000Oomoo`0087oo00@007ooOol0009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo00@007ooOol0009oo`04001oogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0
009oo`03001oogoo01Ioo`05001oogooOol00005Ool01000Oomoo`004Woo000KOol01000Oomoo`00
8Goo00<007ooOol00Woo00@007ooOol001eoo`D00005Ool007ooOol0000MOol01000Oomoo`000Woo
00@007ooOol001eoo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001o
ogoo0002Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`004Woo000K
Ool01000Oomoo`008Woo00D007ooOomoo`00009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo0`000goo00@007ooOol001ioo`8000=oo`04001oogoo000LOol01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo01Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00
Oomoo`0@Ool001]oo`04001oogoo000POol01000Oomoo`000Woo00@007ooOol001ioo`03001oo`00
009oo`04001oogoo000NOol00`00Oomoo`02Ool01000Oomoo`007Goo00@007ooOol0009oo`04001o
ogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo01Ioo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol047oo000LOol2000ROol20004Ool2000POol20003Ool2
000OOol30003Ool2000OOol20004Ool2000LOol20004Ool20004Ool2000HOol20004Ool20004Ool2
000COol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Qoool0
00D000Aoo`0067oo00<007ooOol00Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo0P0017oo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool0015oo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@0
07ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@007ooOol000Aoo`<00?io
o`<000Aoo`0047oo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@0
07ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`004Goo0P001Goo00<007ooOol0ogoo
0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo
0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00
Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
0P00ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo
0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00
Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol2003oOol1Ool20004Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001o
ogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool0
0`00Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo0Goo00<007ooOol0
0Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001o
ogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool0
0`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo
0Goo00<007ooOol00Woo000:Ool40003Ool20005Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool0
00Yoo`03001oogoo00=oo`04001oogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000]o
o`03001oogoo009oo`04001oogoo0004Ool3003nOol30004Ool000aoo`05001oogooOol00002Ool0
0`00Oomoo`02Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000
Oomoo`0017oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000;Ool20004Ool20005Ool00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol2003oOol1Ool20004Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo
009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo
009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo0P00ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool000aoo`<0009oo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo
009oo`003Goo00@007ooOol0009oo`03001oogoo009oo`03001oogoo0?moo`5oo`03001oogoo009o
o`002Woo1@0000Eoo`00Oomoo`0000Aoo`<00?ioo`<000Aoo`002Woo00@007ooOol0009oo`04001o
ogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000]oo`03001oo`00009oo`04001oogoo
0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000aoo`8000=oo`8000Eoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`800?moo`5oo`8000Aoo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0@7oo0P00_Woo00<007ooOol0
0Woo000HOol00`00Oomoo`10Ool2002nOol00`00Oomoo`02Ool001Qoo`03001oogoo03Yoo`P00;io
o`03001oogoo009oo`0067oo0P00>goo2000_Goo0P0017oo000HOol00`00Oomoo`0jOol8002nOol0
0`00Oomoo`02Ool001Qoo`03001oogoo03Yoo`P00;ioo`03001oogoo009oo`0067oo00<007ooOol0
>Woo2000_Woo00<007ooOol00Woo000HOol00`00Oomoo`0jOol8002nOol00`00Oomoo`02Ool001Qo
o`03001oogoo03Yoo`P00;ioo`03001oogoo009oo`0067oo00<007ooOol0>Woo2000_Woo00<007oo
Ool00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03
001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol2003oOol1Ool20004
Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007oo
Ool00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03
001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool000Yoo`<000Aoo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`00
2Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000Yo
o`04001oogoo0002Ool01000Oomoo`0017oo0`00oWoo0`0017oo000:Ool30003Ool01000Oomoo`00
17oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000;Ool00`00Oomoo`02Ool01000Oomoo`0017oo
00<007ooOol0ogoo0Goo00<007ooOol00Woo000;Ool30003Ool20005Ool00`00Oomoo`3oOol1Ool0
0`00Oomoo`02Ool001Qoo`03001oogoo03Yoo`P00;ioo`03001oogoo009oo`0067oo00<007ooOol0
>Woo2000_Woo00<007ooOol00Woo000HOol00`00Oomoo`0jOol8002nOol00`00Oomoo`02Ool001Qo
o`03001oogoo03Yoo`P00;ioo`03001oogoo009oo`0067oo00<007ooOol0>Woo2000_Woo00<007oo
Ool00Woo000HOol00`00Oomoo`0jOol8002nOol00`00Oomoo`02Ool001Qoo`8003]oo`P00;eoo`80
00Aoo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00
Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo
00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo0P00
ogoo0Goo0P0017oo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomo
o`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol2003oOol1Ool20004Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<0
07ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qo
o`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007ooOol00Woo
000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool000]oo`8000Aoo`8000Eoo`03001oogoo0?mo
o`5oo`03001oogoo009oo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`00oWoo0`0017oo000;
Ool20003Ool01000Oomoo`0017oo00<007ooOol0ogoo0Goo00<007ooOol00Woo000:Ool01000Oomo
o`000Woo00@007ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`002goo0P0017oo0P00
1Goo00<007ooOol0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02
Ool001Qoo`03001oogoo0?moo`5oo`03001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00<007oo
Ool00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03001oogoo0?moo`5oo`03
001oogoo009oo`0067oo00<007ooOol0ogoo0Goo00