(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1037898,      18287]*)
(*NotebookOutlinePosition[   1038588,      18311]*)
(*  CellTagsIndexPosition[   1038544,      18307]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\:304a\:307e\:3058\:306a\:3044\)], "Input"],

Cell[BoxData[
    \(\(<< Utilities`MemoryConserve`;\)\)], "Input"],

Cell[BoxData[{
    \(\($MemoryIncrement;\)\), "\n", 
    \(\(<< \ LinearAlgebra`MatrixManipulation`;\)\), "\n", 
    \(\(Off[General::spell1, MemoryConserve::start, 
        MemoryConserve::end];\)\)}], "Input"]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ \ Correlation\)], "Input"],

Cell["\<\
corRelation=
\tCompile[{{vectorA,_Real,1},{vectorB,_Real,1}},
\t\tModule[{meanA=0.,meanB=0.,normA=0.,normB=0.,
\t\t\t\tvectorAprime={0.},vectorBprime={0.}},
\t\t\tmeanA=Apply[Plus,vectorA]/Length[vectorA];
\t\t\tmeanB=Apply[Plus,vectorB]/Length[vectorB];
\t\t\tvectorAprime=vectorA-meanA;
\t\t\tnormA=Sqrt[vectorAprime.vectorAprime];
\t\t\tvectorBprime=vectorB-meanB;
\t\t\tnormB=Sqrt[vectorBprime.vectorBprime];
\t\t\tvectorAprime.vectorBprime/(normA normB)]];\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
coif6={{-.051429728471, .238929728471, .602859456942, 
 \t\t .272140543058,-.051429972847,-.011070271529},
 \t   {-.011070271529, .051429972847, .272140543058,
\t\t-.602859456942, .238929728471, .051429728471}}*
\t\tSqrt[2.];
coif12={{ .011587596739,-.029320137980,-.047639590310, 
 \t\t  .273021046535, .574682393857, .294867193696,
\t\t -.054085607092,-.042026480461, .016744410163, 
 \t\t  .003967883613,-.001289203356,-.000509505399},
 \t\t{-.000509505399, .001289203356, .003967883613,
 \t\t -.016744410163,-.042026480461, .054085607092,
 \t\t  .294867193696,-.574682393857, .273021046535,
\t\t  .047639590310,-.029320137980,-.011587596739}}*
\t\t Sqrt[2.];
coif18={{-.002682418671, .005503126709, .016583560479, 
\t\t -.046507764479,-.043220763560, .286503335274,
 \t\t  .561285256870, .302983571773,-.050770140755, 
\t\t -.058196250762, .024434094321, .011229240962, 
\t\t -.006369601011,-.001820458916, .000790205101,
 \t\t  .000329665174,-.000050192775,-.000024465734},
 \t\t{-.000024465734, .000050192775, .000329665174,
 \t\t -.000790205101,-.001820458916, .006369601011,
 \t\t  .011229240962,-.024434094321,-.058196250762,
 \t\t  .050770140755, .302983571773,-.561285256870,
 \t\t  .286503335274, .043220763560,-.046507764479,
 \t\t -.016583560479, .005503126709, .002682418671}}*
 \t\tSqrt[2.];
coif24={{ .000630961046,-.001152224852,-.005194524026, 
 \t\t  .011362459244, .018867235378,-.057464234429, 
\t\t -.039652648517, .293667390895, .553126452562, 
 \t\t  .307157326198,-.047112738865,-.068038127051,
 \t\t  .027813640153, .017735837438,-.010756318517,
\t\t -.004001012886, .002652665946, .000895594529,
\t\t -.000416500571,-.000183829769, .000044080354, 
 \t\t  .000022082857,-.000002304942,-.000001262175},
 \t\t{-.000001262175, .000002304942, .000022082857,
 \t\t -.000044080354,-.000183829769, .000416500571,
 \t\t  .000895594529,-.002652665946,-.004001012886,
 \t\t  .010756318517, .017735837438,-.027813640153,
 \t\t -.068038127051, .047112738865, .307157326198,
 \t\t -.553126452562, .293667390895, .039652648517,
 \t\t -.057464234429,-.018867235378, .011362459244,
 \t\t  .005194524026,-.001152224852,-.000630961046}}*
 \t\tSqrt[2.];
coif30={{-.000149963800, .000253561200, .001540245700, 
\t\t -.002941110800,-.007163781900, .016552066400, 
 \t\t  .019917804300,-.064997262800,-.036800073600,
 \t\t  .298092323500, .547505429400, .309706849000, 
\t\t -.043866050800,-.074652238900, .029195879500, 
 \t\t  .023110777000,-.013973687900,-.006480090000, 
 \t\t  .004783001400, .001720654700,-.001175822200,
\t\t -.000451227000, .000213729800, .000099377600,
\t\t -.000029232100,-.000015072000, .000002640800, 
 \t\t  .000001459300,-.000000118400,-.000000067300},
 \t\t{-.000000067300, .000000118400, .000001459300,
 \t\t -.000002640800,-.000015072000, .000029232100,
 \t\t  .000099377600,-.000213729800,-.000451227000,
 \t\t  .001175822200, .001720654700,-.004783001400,
 \t\t -.006480090000, .013973687900, .023110777000,
 \t\t -.029195879500,-.074652238900, .043866050800,
 \t\t  .309706849000,-.547505429400, .298092323500,
 \t\t  .036800073600,-.064997262800,-.019917804300,
 \t\t  .016552066400, .007163781900,-.002941110800,
 \t\t -.001540245700, .000253561200, .000149963800}}*
 \t\tSqrt[2.]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Photo\ Example\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00WooB3F]13W>1SF]23W>0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa
0T8@0THa0SW>1Goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol00WooB3F]13W>1SF]23W>
0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa0T8@0THa0SW>1Goo0@000Goo000>Ool20005
Ool00`00Oomoo`02OomB=Jd6>Lh4=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl8>Li<?Nl6@Q02?Nl2
<H`28@P5Ool10001Ool001Eoo`03001oogoo009ooe8e[@HicP@e[@8aS08e[A`icP8mk`TicP@e[A0i
cP@mk`PicT`mk`I2408mk`8aS08Q20Eoo`40005oo`005Goo00<007ooOol00WooDSF]13W>13F]136<
0SF]73W>0Sg_2CW>13F]43W>1Sg_13W>33g_1SW><3g_148@13g_248@0SF]0Re[0QS60PaS1Goo0@00
0Goo000EOol00`00Oomoo`02OomB=Jd4>Lh4=Jd4<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh6?Nl4>Lh<?Nl6
>Lh`?Nl4@Q04?Nl8@Q02=Jd2;F/26<H236<5Ool10001Ool001Eoo`03001oogoo009ooc`e[@8icPPe
[@8icPXe[@@icP@e[@8aS0@e[A`icP8mk`<icP8mk`8icP@aS08e[@@mk`PicQ@mk`8icRPmk`A2408m
k`A240Hmk`A2408mk`8icP8mk`A6<@8mk`8aS08Li`8@Q0@000Eoo`40005oo`005Goo00<007ooOol0
0Woo?3F]0SW>23F]0SW>2SF]13W>13F]0S6<13F]73W>0Sg_0cW>0Sg_0SW>136<0SF]13g_23W>53g_
0SW>:3g_148@0Sg_148@1Sg_148@0Sg_0SW>0Sg_14Ha0Sg_0S6<0QcW0Q2410001Goo0@000Goo000E
Ool00`00Oomoo`02Ool2>Lhf=Jd6>Lh6=Jd6>Lh6=Jd6>Lh4=Jd2<H`2=JdN>Lh2?Nl3>Lh2?Nl2>Lh4
<H`2>Li6?Nl:@Q02?Nl6@Q08?Nl2@Q02AS42@Q02=Jd29BT25:D2248212440005Ool10001Ool001Eo
o`8000=oo`8icSHe[@HicPHe[@HicPHe[@HicP@e[@8aS08e[AhicP8mk`<icP8mk`8icP@aS08icTHm
k`Y2408mk`I240Pmk`924096<@92408e[@8U:@8DY@88@P848@@000Aoo`80005oo`005Goo00<007oo
Ool00Woo33W>83F]53W>0SF]23W>13F]1SW>23F]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Sg_148@3Sg_1T8@13g_448@0Sg_448@0SW>0Re[0QcW0PaS2P001Goo0@000Goo000EOol00`00
Oomoo`02Ool<>LhP=JdD>Lh2=Jd8>Lh4=Jd6>Lh8=Jd>>Lh2=Jd@>Lh2?Nl00cW>?Nlmk`02?Nl2=Jd2
<H`2=JdV?Nl4@Q0>?Nl6@Q04?Nl@@Q02?Nl@@Q02>Lh2;F/27>L236<:0005Ool10001Ool001Eoo`03
001oogoo009ooaXicP8e[@@icPPe[A0icP@e[@@icP8e[@HicPHe[@HicPPe[A`icP@mk`8icP<mk`8i
cP8e[@8aS08e[B@mk`Q240`mk`Q2408mkaA240@mk`9240A6<@92408e[@8U:@8@Q0848@`000Eoo`40
005oo`005Goo00<007ooOol00Woo6SW>0SF]13W>23F]43W>13F]13W>0SF]1SW>1SF]1SW>23F]73W>
13g_0SW>0cg_0SW>0SF]0S6<0SF]93g_248@33g_248@0Sg_548@13g_0T8@14Ha0T8@0SF]0RDY0Q24
0P@Q30001Goo0@000Goo000EOol00`00Oomoo`02Oom0>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd:>Lh4
?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhP?Nl2@Q02?Nl6@Q0>?NlN@Q02?Nl2@Q04AS42?Nl2<H`28@P2
48@2124>0005Ool10001Ool001Eoo`03001oogoo009ood0icP@e[@HicP8e[@PicP8e[@8aS08e[@Xi
cP@mk``icPPmk`8icP<mk`8icP@e[@8icR0mk`92408mk`I240hmkai2408mk`9240A6<@8mk`8aS08Q
208@Q0848@h000Eoo`40005oo`005Goo00<007ooOol00Woo6SW>0SF]>3W>13F]2SW>3Sg_13W>2cg_
0SW>13F]0SW>83g_148@0Sg_1T8@23g_648@0Sg_2T8@1THa0SW>0RU:0QS60PaS0P@Q40001Goo0@00
0Goo000EOol00`00Oomoo`02OolJ>Lh2=Jdh>Lh4=Jd:>Lh>?Nl4>Lh;?Nl2>Lh4=Jd2>LhP?Nl4@Q02
?Nl6@Q08?NlH@Q02?Nl:@Q06AS42>Lh2:DX26<H236<2124@0005Ool10001Ool001Eoo`03001oogoo
009oo`8mke0icPHe[@8icP8mk`@icQlmk`@e[@8icQXmk`a2408mk`I240Hmkb9240I6<@8mk`8e[@8U
:@8@Q0848@h000848@@000Eoo`40005oo`005Goo0P000goo0Sg_D3W>1SF]0SW>0Sg_13W>7cg_13F]
0SW>6Sg_348@0Sg_1T8@1Sg_8T8@1THa0Sg_0SF]0RDY0Q240P@Q3P000P@Q100017oo0P000Goo000E
Ool00`00Oomoo`02OolL?Nlf>Lh6=Jd2>Lh2?Nl4>Lh4?Nl4>LhF?Nl00cW>=Jde[@02<H`2>Lh4@Q04
>Lh>?Nl:@Q02?NlJ@Q08AS42@Q04AS48@Q04AS42BU82AS42@Q02<H`27>L236<21242000212440004
124:0005Ool10001Ool001Eoo`03001oogoo009ooa`mkcHicPHe[@8icP8mk`@icP@mk`@icQHmk`03
>Lhe[CF]008aS08icPA240@icPhmk`Y2408mkaY240Q6<@9240A6<@Q240A6<@9:DP96<@92408aS08L
i`8<H`848@8000848@@000@48@X000Eoo`40005oo`005Goo00<007ooOol00Woo63g_23W>23g_13W>
63g_23W>0Sg_0SW>1SF]13W>6Sg_13W>1Sg_00<icSF]=Jd00SF]0SW>1Sg_0SW>13g_6T8@13g_848@
14Ha0Sg_0T8@1THa0SW>0Re[0QcW0PaS0P@Q0P000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolH?Nl8>Lh8?Nl4>LhH?Nl8>Lh2?Nl2>Lh6=Jd4>LhJ?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2
>Lh4?NlJ@Q04?NlP@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124D0005Ool10001Ool0
01Eoo`03001oogoo009ooa`mk`@icPPmk`@icP`mk`@icPhmk`8icP8mk`8icP@e[@@icRHmk`03>Lhe
[CF]008icP8mk`9240hmkca240Q6<@8mk`8aS08U:@8DY@88@P848@@000848A@000Eoo`40005oo`00
5Goo00<007ooOol00Woo73g_13W>23g_13W>33g_13W>3Sg_0SW>0Sg_0SW>13F]13W>9Sg_00<icSF]
=Jd00SW>0Sg_0T8@3Sg_?48@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q50001Goo0@000Goo000E
Ool00`00Oomoo`02Ool<?Nl4@Q02?Nl6@Q0f?Nl8>LhV?Nl5>Lh4?Nl4@Q02?Nl4@Q08?NlZ@Q02AS48
@Q02AS44@Q02AS42BU82AS42>Lh2;F/26<H248@212480002124D0005Ool10001Ool001Eoo`03001o
ogoo009oo``mk`A2408mk`I243Hmk`PicRHmk`DicP@mk`A2408mk`A240PmkbY24096<@Q24096<@A2
4096<@9:DP96<@8icP8]J`8HaP8@Q0848@P000848A@000Eoo`40005oo`005Goo00<007ooOol00Woo
448@0Sg_1T8@13g_148@;Sg_1SW>:3g_0SW>1Cg_348@23g_=48@0THa0T8@0THa0TYB0THa0SW>0RU:
0QS60PQ20P@Q100010@Q60001Goo0@000Goo000EOol20003Ool@@Q02?Nl6@Q04?Nl4@Q0^?Nl6>LhX
?Nl2>Lh5?Nl<@Q08?Nld@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124H0004Ool2
0001Ool001Eoo`03001oogoo009ooaY2408mk`I2408mkaQ2410mk`PicP8mk`92410mk`A241<mk`A2
40@mkdI24096<@A:DP8icP8YBP8HaP8<H`H000@48AX000Eoo`40005oo`005Goo00<007ooOol00Woo
6T8@0Sg_1T8@0Sg_648@43g_23W>0Sg_0T8@43g_148@4cg_148@13g_AT8@0THa14YB0SW>0RU:0QS6
0PaS1P0010@Q6P001Goo0@000Goo000EOol00`00Oomoo`02Ool2AS46@Q04AS4d@Q0<?Nl6>Lh4?Nl2
@Q0B?Nl2@Q04?Nl2@Q0:?Nl7@Q04?NlJ@Q0:AS4D@Q02AS48@Q06AS42BU82?Nl29BT25:D2248V0005
Ool10001Ool001Eoo`03001oogoo009oo`96<@I240A6<CA240`mk`HicP@mk`92418mk`9240@mk`92
40Xmk`M240@mkaY240Y6<AA24096<@Q240I6<@9:DP8mk`8U:@8DY@88@RH000Eoo`40005oo`005Goo
00<007ooOol00Woo6THa<T8@23g_248@33g_2T8@2Sg_5D8@14Ha2T8@24Ha4T8@0THa0T8@1THa148@
14Ha0TYB0THa0SW>0RDY0Q2410@Q0P000P@Q30000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolJAS4b@Q08?Nl8@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q08AS4B@Q02AS42@Q06AS44@Q04AS42BU82AS42
>Lh29BT248@412420002124<0002124D0005Ool10001Ool001Eoo`03001oogoo009ooaY6<@Q240Y6
<B1240@mkb9240@mk`8icP@mk`m240Y6<@Y240I6<A1240I6<@9240a6<@A:DP8icP8U:@8DY@P48@H0
00@48AH000@48@Eoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Woo6THa248@2THa848@
13g_8T8@13g_0SW>13g_3d8@2THa2T8@1THa448@1THa0T8@34Ha14YB0SW>0RDY0QBU20@Q1P0010@Q
5P0010@Q1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Woo0TYB
;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa148@0THa1T8@34Ha148@
0THa14YB0THa0SW>0RU:0Q240PQ220@Q90001Goo0@000Goo0008Ool00`00Oomoo`02Ool01000Oomo
o`0017oo0P000goo0TYB;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa
148@0THa1T8@34Ha148@0THa14YB0THa0SW>0RU:0Q240PQ220@Q900017oo0P000Goo0009Ool01@00
Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo34YB24Ha1TYB6THa248@0THa148@0Sg_
13W>0Sg_148@14Ha148@0THa248@14Ha1T8@0THa3T8@0THa8d8@24Ha148@5THa0T8@14Ha0T8@0SF]
0RDY0QBU0PQ2:0000P@Q10001Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03
001oogoo009oo`a:DPQ6<@I:DQY6<@Q24096<@A2408mk`@icP8mk`A240A6<@A24096<@Q240A6<@I2
4096<@i24096<B=240Q6<@A241I6<@9240A6<@92408e[@8U:@8DY@88@RP000848@@000Eoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol00Woo94YB6THa0T8@0Sg_0SW>0S6<0Re[0SF]0T8@0TYB
0Tic34Ha148@1THa148@0THa2T8@5DHa148@=4Ha0TYB0THa0SF]0RDY0Q240PQ230000P@Q30000P@Q
300020@Q1Goo0@000Goo000EOol00`00Oomoo`02OolTBU8JAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02
BU82CW<<AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0dAS42BU82AS42=Jd29BT248@2248<0002124<0002
124<00081245Ool10001Ool001Eoo`03001oogoo009oo`i:DPI>L`Q:DPA6<Ai:DPA6<@8mk`8e[@8a
S08mk`9:DPABU09>L`A240Q6<@A24096<@9:DPQ6<@Q240A6<@924456<@I:DP96<@8icP8YBP8HaP88
@P848@8000h48@P000X48@@000X48@Eoo`40005oo`005Goo00<007ooOol00Woo3TYB1Tic24YB14Ha
7TYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@24Ha148@0THa0TYB24Ha248@14Ha0T8@@DHa1TYB
0THa0SW>0RU:0QS60PQ20P@Q0P003P@Q20002P@Q10002P@Q1Goo0@000Goo000EOol00`00Oomoo`02
Ool4CW<8BU86CW<8BU82CW<2AS44BU88CW<2BU86AS44@Q06AS48BU82AS42@Q02BU82E[D2F]H2IcT2
G_L2CW<2@Q0<AS44BU82AS42@Q04AS46@Q0cAS44BU8BAS44BU82AS42?Nl2:DX26<H236<212440004
12460002124:000H1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`Q:DPI>L`Q:DP9>L`96<@A:
DPQ>L`9:DPI6<@A240I6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240a6<@A:DP96<@9240A6
<@I243=6<@A:DQ96<@A:DP96<@8mk`8YBP8HaP8<H`848@@000@48@H000848@X001P48@Eoo`40005o
o`005Goo00<007ooOol00Woo24ic24YB34ic0U:D1Tic0TYB0THa0T8@0Sg_1SF]136<1SF]0SW>13g_
1T8@0Tic0U[F0V<H0Vmk0VLi0UJe0TYB1THa1TYB0THa13g_0T8@0THa0TYB24Ha0TYB<DHa2TYB2THa
14YB0T8@0S6<0QcW0PaS0P@Q700060@Q1Goo0@000Goo000EOol20003Ool8CW<8BU8<CW<2DY@6CW<2
BU82AS42@Q02?Nl6=Jd4<H`6=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2IcT2E[D2BU86AS46BU82AS44
?Nl2@Q02AS42BU88AS42BU8aAS4:BU8:AS44BU82@Q02<H`27>L236<2124L000H1244Ool20001Ool0
01Eoo`03001oogoo009ooaY>L`9:DP9>L`9:DP96<@92408icP8e[@8aS0@]J`HYBP`U:@@YBP8]J`8m
k`9BU09S60AW>@9JeP9>L`9:DPA6<@9>L`ABU096<@8icP8e[@8icP924096<@A:DPA6<@I:DS56<@Q:
DPI6<@I:DP92408e[@8Q208@Q0848@@000`48@h001P48@Eoo`40005oo`005Goo00<007ooOol00Woo
6Tic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:32DY12U:0Re[0Sg_0U:D0V<H16Li0U[F0Tic
0TYB14Ha0Tic15:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha1TYB<DHa24YB1THa1TYB0T8@0SF]0R48
0Q240P@Q100030@Q3P0060@Q1Goo0@000Goo000EOol00`00Oomoo`02OolBCW<4DY@2CW<2BU82AS44
?Nl2=Jd2<H`2;F/>:DX49BT28@P27>L86<H28@P2>Lh2F]H2Kg/2Li`2IcT2E[D6DY@2F]H2IcT2HaP2
E[D2@Q04<H`2@Q02BU82AS4<BU8GAS4BBU8>AS44BU84AS46BU82AS42>Lh29BT25:D2248412420006
12420002124D000D1245Ool10001Ool001Eoo`03001oogoo009ooa9>L`ABU09>L`9:DP96<@@mk`8e
[@8aS08]J`hYBP@U:@8Q208Li`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP9W>@9S609F]@92
40@aS092409:DP96<@a:DQM6<A9:DPi6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P@48@8000H48@80
00848A@001@48@Eoo`40005oo`005Goo00<007ooOol00Woo34ic15:D14ic0TYB0T8@0Sg_0SW>0S6<
32e[12U:1Re[12U:12DY1R480RU:0SW>0Tic0VLi0W>L0V]J0UJe0TYB0U:D0U[F0Ukg0V<H0VLi0Ukg
0U:D0T8@0Sg_0T8@14YB0Tic3TYB5DHa34YB1THa1TYB14Ha1TYB14Ha1TYB0THa0SW>0RDY0QBU0PQ2
100020@Q2P001P@Q10006P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<CW<4DY@4CW<2BU82@Q02
?Nl2>Lh2<H`<;F/4:DX6;F/4:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2
HaP2IcT2G_L2DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS46BU84AS46BU84AS46BU82AS42>Lh2
9BT25:D224840008124:00061244000J1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`YBU09>
L`96<@8mk`8e[@@aS08]J`8aS0P]J`8aS0@]J`XaS08]J`PaS08e[@92409F]@9W>@A_N`9JeP96<@8m
k`9:DP9JeP9Nm`9JeP9F]@Q:DPA>Ld5:DPA6<@a:DP96<@8icP8]J`8HaP8<H`848@@000H48@X000P4
8@@001X48@Eoo`40005oo`005Goo00<007ooOol00Woo14ic2U:D0Tic0THa0Sg_0SF]136<0Re[0S6<
22e[0S6<12e[2S6<0Re[236<0SF]0T8@0UJe0VLi16mk0U[F0THa0Sg_0TYB0U[F0Ukg0U[F0UJe24YB
14ic@DYB14Ha34YB0THa0SW>0Re[0QS60PaS0P@Q10001P@Q2P0020@Q10006P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool8DY@4CW<2AS42?Nl2=Jd2;F/4:DX4;F/:<H`8=Jd<>Lh6?Nl2AS42E[D2HaP2
Kg/2JeX2IcT2CW<2?Nl2=Jd2>Lh2AS44BU82CW<2BU8<CW<IBU88CW<ZBU82CW<2AS42?Nl2;F/27>L2
36<>1248000:1244000J1245Ool10001Ool001Eoo`8000=oo`QBU0A>L`96<@8mk`8e[@8]J`@YBP@]
J`XaS0Pe[@`icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP9>L`9:DPa>LaU:
DPQ>LbY:DP9>L`96<@8mk`8]J`8Li`8<H`h48@P000X48@@001X48@Aoo`80005oo`005Goo00<007oo
Ool00Woo15:D0Tic0TYB0T8@0Sg_136<22e[2S6<13F]1SW>1Sg_1T8@1THa0TYB0Tic0U:D0UJe0U[F
0Ukg0V<H0U:D0THa0SW>1SF]0T8@0Tic15:D0Tic1TYB0Tic0U:D34ic>DYB0THa14YB0T8@0S6<0R48
0QBU2P@Q3P00:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@2CW<2BU82@Q02?Nl4<H`8;F/:
<H`4=Jd6>Lh6?Nl6@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42>Lh6=Jd2@Q02CW<4DY@2
CW<6BU82CW<2DY@<CW<iBU82AS44BU82@Q02<H`28@P25:D:124>000X1245Ool10001Ool001Eoo`03
001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`haS0@e[@8icPHmk`Q240A6<@A:DP9>L`IBU09>L`9B
U09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`96<BE>LaQ:DP9>L`Y:DPA>L`a:DP96<@8e[@8U:@8@
Q088@P848A@002X48@Eoo`40005oo`005Goo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3S6<
13F]0SW>1Sg_248@14Ha14YB0Tic1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_0THa
9Dic64YB0Tic2TYB14ic34YB0THa0SF]0RDY0Q240PQ20P@Q5000:P@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl2=Jd2<H`6;F/B<H`2=Jd4>Lh4?Nl4@Q08AS44BU84CW<6DY@:E[D6DY@2CW<2BU82
@Q02?Nl2>Lh2BU82CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU86CW<2BU82AS42BU86CW<2?Nl2:DX26<H2
24821244000212440002124800081242000R1245Ool10001Ool001Eoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja8aS08e[@@icP@mk`A240Q6<@A:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`8icP9:DP9>
L`9BU09F]@ABU1e>La1:DPY>L`A:DPI>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@000848@@0
00848@P000P48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<1Re[3S6<13F]0SW>0SF]
0SW>13g_148@14Ha24YB1Tic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@0Sg_0THa0TYB1U:D
>Dic14YB1Tic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P0030@Q1P002P@Q0P008P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`6;F/><H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04AS48BU86CW<8DY@2E[D2F]H4
E[D2DY@4E[D2DY@4CW<2BU82@Q02?Nl2AS42BU86DY@iCW<4BU86CW<6BU84CW<2AS42<H`27>L236<2
1242000<1246000:1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]Ja8aS08e[@@icP8m
k`A240A6<@Q:DPA>L`QBU0iF]@QJeP9F]@ABU09:DP96<@8mk`96<@9>L`YBU1m>L`9BU1A>L`A:DP9>
L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@48@@000848@H000X48@8002848@Eoo`40005oo`00
5Goo0P000goo1Re[4S6<0SF]13W>0Sg_148@14Ha24YB14ic25:D3UJe25[F0UJe15:D0TYB0THa0Sg_
0THa0Tic2U:D7dic0U:D54ic14YB0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q10000P@Q
1P002P@Q0P008P@Q17oo0P000Goo000EOol00`00Oomoo`02Ool6;F/><H`2=Jd4>Lh4?Nl4@Q04AS44
BU88CW<4DY@:E[D@F]H8E[D4DY@2AS42@Q02AS42CW<8DY@6CW<:DY@YCW<2BU88CW<2BU82?Nl2;F/2
6<H22486000L1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]J`haS08e[@@icP@mk`A2
40A6<@A:DPQ>L`ABU0YF]A1JePQF]@ABU096<@924096<@9>L`QBU0I>L`YBU2U>L`9:DPQ>L`9:DP8m
k`8]J`8HaP88@PH001`48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo336<1SF]13W>13g_
148@14Ha1TYB1Tic1U:D25Je65[F15Je15:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Tic
0U:D0Tic0THa0S6<0R480Q240P@Q1P0070@Q0P008P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<
<H`6=Jd4>Lh4?Nl4@Q04AS46BU86CW<6DY@8E[DHF]H4E[D4DY@2BU82AS42@Q02BU82CW<6DY@4CW<<
DY@?CW<2DY@NCW<2DY@2CW<2AS42<H`28@P248@21246000L1242000R1245Ool10001Ool001Eoo`03
001oogoo009oo`PaS0Pe[@8icPHmk`A24096<@A:DPI>L`QBU0IF]AIJePINm`AJePIF]@9BU09:DPA2
409:DPAF]@iBU0A>L`]BU0A>L`IBU1Q>L`ABU09:DP8icP8U:@8@Q0848@P004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo236<23F]0SW>1Sg_148@0THa14YB1Tic25:D1UJe5U[F1Ukg15[F1UJe0U:D
0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D64ic15:D0TYB0SW>0RDY0Q240P@Q2000@0@Q1Goo0@00
0Goo000EOol00`00Oomoo`02Ool6<H`8=Jd2>Lh4?Nl6@Q02AS44BU86CW<6DY@8E[D<F]HDG_L4F]H6
E[D2DY@2AS42@Q02AS42DY@2E[DUDY@JCW<2DY@2CW<2@Q02;F/26<H236<212420002124400101245
Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`HaS0Pe[@8icP@mk`I24096<@A:DPI>
L`IBU0QF]@aJeQANm`AJePIF]@9BU096<@924096<@9BU09F]BEBU1Y>L`9BU09>L`92408]J`8HaP8<
H`848@8000848@@004048@Eoo`40005oo`002Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF]@YJePiNm`9S60YNm`9JePIF]@9>L`96
<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@004048@Eoo`40005o
o`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF
]@YJePiNm`9S60YNm`9JePIF]@9>L`96<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088
@P848@8000848@@004048@Aoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2
E[D2BU84AS42CW<WDY@<CW<2DY@6CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool1
0001Ool000Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2
@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@6
CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool10001Ool000Uoo`8000=oo`8000Eo
o`03001oogoo009oo`8aS08e[@@icPPmk`9240I6<@A:DPA>L`IBU0IF]@aJePYNm`iS60YNm`IJeP9F
]@9BU09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`ABU09:DP92408]J`8Li`8<H`848@H000848@@00404
8@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1THa14YB14ic1U:D1UJe35[F
2Ukg3V<H2Ukg1U[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic15:D0TYB0T8@0Re[0QcW0PaS
0P@Q1P000P@Q1000@0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4@Q04AS44BU86
CW<4DY@8E[D<F]H6G_L2HaP2G_LDHaP:G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2CW<2BU82CW<4
DY@2AS42>Lh28@P25:D2248612420002124400101245Ool10001Ool001Eoo`03001oogoo009oo`8e
[@HicP@mk`A240A6<@A:DPI>L`ABU0QF]@aJePINm`9S609NmaAS60YNm`9JePAF]@9>L`A:DP9>LamB
U0Q>L`YBU09>L`9:DP9>L`ABU096<@8icP8Q208DY@88@PH48@8000848@@004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo13W>13g_148@1THa14YB1Tic1U:D1UJe35[F2Ukg66<H25kg1U[F0U:D1TYB
0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D0UJe0U:D0Sg_0Re[0QS60Q240PQ20P@Q2000A0@Q
1Goo0@000Goo000EOol00`00Oomoo`02Ool4>Lh4?Nl4@Q06AS44BU86CW<6DY@6E[D<F]H:G_LHHaP8
G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4CW<>DY@4CW<2DY@2E[D2DY@2?Nl2;F/26<H248@2
2482124800141245Ool10001Ool001Eoo`03001oogoo009oo`8icP@mk`A240I6<@A:DPI>L`QBU0AF
]@YJePaNm`iS609W>@aS60YNm`9JeP9F]@Q>LbeBU0I>L`ABU09:DP8aS08Q208DY@8@Q088@P848@H0
04H48@Eoo`40005oo`005Goo0P000goo0SW>13g_148@1THa14YB1Tic25:D15Je2U[F35kg3V<H0VLi
36<H2Ukg0U[F0UJe24ic;E:D1Tic15:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00AP@Q17oo0P000Goo
000EOol00`00Oomoo`02Ool2?Nl6@Q04AS46BU84CW<:DY@4E[D:F]H>G_L>HaP8IcT<HaP4G_L4F]H2
DY@6CW<[DY@8CW<2DY@2CW<2?Nl2:DX26<H248@236<4124400181245Ool10001Ool001Eoo`03001o
ogoo009oo`8mk`I240A6<@I:DPA>L`YBU0AF]@YJePiNm`iS60QW>@aS60ANm`AJeP9BU0I>Lb]BU0Q>
L`9BU09>L`8mk`8YBP8HaP8@Q08<H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo1T8@
14Ha24YB1Tic25:D0UJe3U[F35kg8V<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic15:D0TYB
0SF]0R480QBU0Q240PaS0P@Q1P00B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6@Q04AS48BU86
CW<8DY@2E[D>F]H<G_LRHaP2G_L6F]H2E[D2CW<4BU82CW<YDY@2CW<2DY@2CW<4DY@2BU82=Jd28@P2
5:D248@236<2124600181245Ool10001Ool001Eoo`03001oogoo009oo`A240I6<@Q:DPA>L`QBU0AF
]@iJePaNmb1S60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iBU0A>L`9BU09>L`92408]J`8HaP8@Q0@<
H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo148@1THa24YB14ic25:D15Je3U[F35kg
86<H15kg1U[F0UJe0U:D14YB0Tic6e:D0Tic3U:D14ic0U:D0Tic0T8@0Re[0QS60Q2410aS10@Q1000
B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q06AS44BU88CW<6DY@8E[D<F]H>G_LPHaP6G_L6
F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2CW<4DY@2CW<2>Lh29BT25:D436<2249@1245Ool10001Ool0
01Eoo`03001oogoo009oo`9240I6<@A:DPQ>L`IBU0QF]@aJePiNmb1S60INm`IJeP9BU09>L`A:DPI>
LaEBU0I>L`YBU09>L`ABU09>L`8icP8U:@8DY@@<H`88@U048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1THa1TYB1Tic1U:D25Je35[F35kg2V<H0VLi76<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic
15:D24ic15:D0T8@0Re[0QcW0Q2410aS0PQ2D0@Q1Goo0@000Goo000EOol20003Ool6AS46BU86CW<6
DY@8E[D<F]H<G_L:HaP2IcTLHaP8G_L2E[D2DY@6BU84CW<2DY@4CW<5DY@@CW<4DY@8CW<4DY@2@Q02
;F/27>L248@436<2249@1244Ool20001Ool001Eoo`03001oogoo009oo`A6<@A:DPY>L`IBU0IF]@YJ
ePiNm`YS60IW>AYS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@8Q208DY@@@Q088@Rh4
8@88@R848@Eoo`40005oo`005Goo00<007ooOol00Woo14Ha14YB2Tic1U:D1UJe2U[F3Ukg2V<H1VLi
6V<H25kg0U[F0U:D0Tic1TYB24ic0e:D7Tic0U:D0TYB0SF]0R480QBU11240PQ2;P@Q0PQ28P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool2AS48BU82CW<:DY@4E[D>F]H>G_L:HaP:IcT4HaP<IcT8HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/2
6<H648@2248`1242248P1245Ool10001Ool001Eoo`03001oogoo009oo`96<@Q:DP9>L`YBU0AF]@iJ
ePiNm`YS60YW>@AS60aW>@QS60ANm`9JePAF]@9>L`9:DP96<@A:DPQ>L`03DYA>Ldic00I>L`9BU0a>
L`9BU09>L`9:DPA>L`96<@8]J`8HaPH@Q088@S048@88@R048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1TYB1Tic2U:D15Je3U[F3Ukg2V<H36Li1V<H16Li36<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic
0TYB0Sg_0RU:0QBU0Q2410aS0PQ2;P@Q10Q280@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6BU86
CW<:DY@4E[D>F]H>G_L:HaP<IcT6HaP4IcT<HaP4G_L4F]H2E[D2DY@2CW<4AS42BU8WCW<2BU82?Nl2
:DX25:D248@436<2248^1244248P1245Ool10001Ool001Eoo`03001oogoo009oo`A:DPQ>L`QBU0AF
]@iJePaNma1S60YW>AQS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q208@Q0@<H`@8@QP4
8@88@Q048@P8@R048@Eoo`40005oo`005Goo00<007ooOol00Woo14YB24ic25:D15Je3U[F35kg46<H
2VLi66<H15kg15[F0UJe0Tic14Ha0TYB8dic15:D0THa0SF]0R480Q2410aS10Q260@Q0PQ240@Q20Q2
80@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU88CW<<E[D>F]H<G_L:HaP4IcT6HaP6IcTHHaP4
G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2BU82CW<4DY@2@Q02:DX26<H448@236<4248F1244248<124<
248P1245Ool10001Ool001Eoo`8000=oo`A:DPQ>L`aF]@iJePaNm`YS60AW>@IS60IW>AQS60ANm`AJ
eP9F]@9BU09:DPA6<@9:DQe>L`9:DP9>L`ABU092408YBP8HaP@@Q08<H`@8@QH48@@8@P`48@`8@R04
8@Aoo`80005oo`005Goo00<007ooOol00Woo14YB1Tic0U:D35Je3U[F35kg2V<H1VLi1V<H16Li5V<H
1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS60QBU0Q240PaS
20Q24P@Q10Q22P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU86CW<2DY@<E[D>F]H<
G_L:HaP6IcT6HaP4IcTFHaP6G_L4F]H2E[D2DY@2CW<6AS42BU8CCW<2BU86CW<2BU82CW<2DY@2CW<2
>Lh28@P26<H25:D248@236<8248B1244248:124@248N1245Ool10001Ool001Eoo`03001oogoo009o
o`9:DPI>L`ABU0aF]@aJeQ9Nm`IS60YW>AaS60INm`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:
DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP@DY@8@Q08<H`P8@P`48@X8@PH48@88@P848A08@Qh4
8@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB1Tic15:D35Je35[F4Ukg1V<H2VLi76<H1Ukg15[F
0UJe0U:D0Tic0TYB0THa0T8@0TYB1dic14YB24ic14YB14ic0TYB0Tic0U:D0THa0S6<0QS611BU0Q24
0PaS20Q230@Q2PQ21P@Q0PQ20P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6CW<6DY@:
E[D>F]HBG_L4HaP>IcTJHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2BU82CW<6BU88CW<2
>Lh29BT65:D248@:248:124V248N1245Ool10001Ool001Eoo`03001oogoo009oo`I>L`IBU0YF]@iJ
eQ9Nm`AS60iW>AYS60INm`AJePAF]@9BU09:DPI6<@A:DP=>L`A:DPA>L`9:DP9>L`I:DPQ>L`8icP8U
:@HDY@8@Q0X8@PX48BH8@Qh48@Eoo`40005oo`005Goo00<007ooOol00Woo1Tic15:D35Je3U[F25kg
1V<H15kg16<H0VLi0V<H2VLi6V<H2Ukg0U[F0UJe0U:D0Tic1THa6DYB1Tic0TYB0SF]0R480Q240QBU
0QS60Q2410Q20P@Q10Q22P@Q10Q210aS7PQ26P@Q10Q21Goo0@000Goo0007Ool30004Ool20005Ool0
0`00Oomoo`02Ool6CW<4DY@<E[D>F]H8G_L6HaP4G_L4HaP2IcT2HaP:IcTJHaP:G_L2F]H2E[D2DY@2
CW<6AS4IBU86CW<2BU82=Jd28@P248@25:D26<H248@424821244248:1244248436<N248J12442485
Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D25Je
45[F3Ukg16<H46Li76<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
11BU0PaS30Q210@Q0PQ21PaS0Q240PaS1PQ21P@Q4PQ26P@Q10Q21Goo0@000Goo0007Ool01000Oomo
o`000Woo00@007ooOol000Aoo`8000=oo`9>L`YBU0QF]A1JePiNm`AS611W>AaS60YNm`AJeP9F]@9>
L`9:DPA6<@9240e:DP96<@Y:DPA>L`8mk`8YBP8HaP8@Q0@DY@8<H``8@P@48@88@PH<H`8@Q08<H`H8
@PH48A88@QX48@@8@PAoo`80005oo`001goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9>
L`QBU0YF]A1JePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>
L`9:DP8icP8U:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eo
o`40005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`QBU0YF]A1J
ePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>L`9:DP8icP8U
:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eoo`40005oo`00
27oo0`000goo0P001Goo00<007ooOol00Woo0Tic1U:D35Je45[F35kg1V<H46Li76<H2Ukg15[F15Je
0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW0Q240PaS11240PaS1PQ22P@Q0PQ20PaS
0R480QcW0QBU0PaS70Q27P@Q0PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<6DY@<E[D@F]H<
G_L6HaP@IcTLHaP:G_L4F]H4E[D2DY@2CW<2AS42@Q02AS4;BU82AS4:BU82CW<2AS42<H`27>L248@2
36<448@236<6248:1242248236<28@P27>L25:D236<L248N12422485Ool10001Ool001Eoo`03001o
ogoo009oo`IBU0aF]A1JePYNm`QS619W>AaS60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB
00A:DPI6<@9:DP96<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@8@Q08<H`88@Ph48@8<H`8@Q0@HaP8DY@8<
Ha`8@Q`48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U:D35Je45[F2Ukg26<H4VLi76<H2Ukg
1U[F0UJe0U:D0Tic0TYB0THa0T8@00=6<DYBBU8014YB1THa0TYB0THa24YB0Sg_0Re[0QS60Q240PaS
0QBU0Q240PaS0PQ23P@Q0PaS0Q2411S60QBU0PaS70Q270@Q10Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool6DY@8E[DDF]H:G_L:HaP@IcTNHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT2
5:D236<248@25:D248@236<2248<1244248836<H248236<4248J12462485Ool10001Ool001Eoo`03
001oogoo009oo`IBU0QF]AAJePYNm`YS611W>AiS60QNm`IJeP9F]@ABU09:DP96<@=24196<@I:DP8i
cP8U:@8DY@8<H`8@Q08DY@8@Q08<H`88@P`48@@8@PP<HaP8@P8<H`@8@QX48@H8@PEoo`40005oo`00
5Goo00<007ooOol00Woo15:D25Je5U[F3Ukg2V<H4VLi66<H25kg1U[F0UJe15:D0Tic0TYB1d8@3THa
14YB0THa0SF]0R480Q2410aS0Q240PaS10Q23P@Q80Q210aS10Q26P@Q1PQ21Goo0@000Goo000EOol2
0003Ool4DY@8E[DFF]H>G_L:HaPBIcTHHaP8G_L6F]H2E[D4DY@2CW<2BU87@Q0>AS44BU82AS42=Jd2
8@P248@436<248@236<4248>124P248436<4248J12462484Ool20001Ool001Eoo`03001oogoo009o
o`ABU0QF]AAJeQ1Nm`YS619W>AaS60ANm`9JeP9Nm`9JePIF]@9BU09:DP96<@03@Q0mkcg_00A240a6
<@9:DP96<@92408aS08Li`8@Q0H<H`H8@PX48@88@P@48@H8@P@48A@8@P@<H`H8@P848@@8@PP48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo15:D25Je55[F45kg2V<H4VLi76<H15kg0U[F0Ukg0U[F
1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB0THa0T8@0S6<0QcW0Q241PaS1PQ22P@Q0PQ210@Q
1PQ210@Q50Q210aS1PQ20P@Q10Q220@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@8E[DD
F]H<G_L:HaP6IcT4HaP>IcTJHaP4G_L2F]H4G_L2F]H4E[D2DY@2BU82AS400d8@?Nlmk`06@Q06AS42
@Q02AS42BU82AS42?Nl2;F/26<H648@236<2248>124<248412462482124<248436<6248212442488
124@2485Ool10001Ool001Eoo`03001oogoo009oo`ABU0QF]AAJePaNm`YS60IW>@AS60iW>AYS60AN
m`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@
Q08<H`88@Ph48@`8@P@48@H8@P848@`8@P@<H`H8@P848@@8@PP48A08@PEoo`40005oo`005Goo00<0
07ooOol00Woo35Je45[F45kg26<H16Li26<H0VLi1V<H1VLi56<H3Ukg1U[F0UJe0U:D14ic00=6<Cg_
?Nl00Sg_1T8@14Ha148@0TYB0THa0SF]0RDY0QS61Q240PaS5P@Q0PQ210@Q5PQ210aS2PQ20P@Q1PQ2
1P@Q3PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool<E[D@F]H@G_L8HaP4IcT8HaP2IcT6HaP6IcTD
HaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT26<H648@236<F
12422484124F248436<:248212462486124>2485Ool10001Ool001Eoo`03001oogoo009oo`YF]A9J
eQ1Nm`YS609W>@QS609W>@IS60IW>AAS60ANm`9S60QNm`IJePAF]@9BU09>L`03BU92448@00Q240A6
<@A24096<@92408e[@8U:@8HaP8DY@8@Q08<H`88@Q@48@@8@P@48AH8@P@<H`X8@P848@H8@P@48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo2UJe4U[F45kg2V<H0VLi26<H0VLi1V<H1VLi56<H15kg
0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@0SF]0RDY0QS60QBU0Q240PaS
0PQ250@Q10Q210@Q5PQ210aS2PQ20P@Q1PQ210@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool8
E[DDF]H@G_LDHaP2IcT6HaP6IcT>HaP2G_L6HaP2G_L4HaP6G_L8F]H2E[D4DY@00dYBAS56<@04@Q02
?Nl2@Q02AS46@Q02AS42@Q02<H`28@P26<H25:D248@236<2248D124N248436<:248212462482124B
2485Ool10001Ool001Eoo`8000=oo`QF]AAJeQ1NmaAS609W>@IS60IW>@iS609Nm`IS609Nm`AS60IN
m`QJeP9F]@ABU003BU96<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88
@Q@48Ah8@P@<H`X8@P848@H8@P848A88@PAoo`80005oo`005Goo00<007ooOol00Woo25Je55[F45kg
46<H1VLi26<H0VLi46<H0Ukg36<H1Ukg25[F15Je0U:D00=>LdYBBU800THa0T8@0Sg_2T8@0THa0Sg_
0Re[0R480QS60QBU0Q240PQ250@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[DDF]H@G_L@HaP6IcT8HaP2IcT@HaP2G_L<HaP6G_L8F]H4E[D2DY@00dicBU9:DP02AS42@Q02
?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248D124P248436<:2482124J2485Ool10001Ool001Eo
o`03001oogoo009oo`QF]AAJePiNm`iS60YW>AYS609Nm`aS60ANm`YJePAF]@9BU003CW=:DTYB0096
<@9240@mk`Y2408icP8YBP8Li`8HaP8@Q08<HaH48B08@P@<H`X8@P848AX8@PEoo`40005oo`005Goo
00<007ooOol00Woo25Je55[F3Ukg3V<H2VLi6V<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa
0T8@13g_2T8@0SW>0RU:0QcW0QS60Q240PaS5P@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool8E[DDF]H<G_L>HaP<IcT2HaP4IcTDHaP2G_L<HaP4G_L:F]H4E[D2DY@3CW<2BU82
@Q04?Nl:@Q02=Jd29BT26<H25:D236<2248D124R248436<V2485Ool10001Ool001Eoo`03001oogoo
009oo`QF]AAJePaNm`iS60aW>@9S60AW>AAS609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2
408e[@8U:@8HaP8DY@8<H`88@Q@48B88@P@<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo25Je
45[F3Ukg3V<H3VLi0V<H16Li56<H0Ukg36<H1Ukg25[F1UJe00=BU4icCW<00TYB0THa0T8@1Sg_148@
0Sg_0S6<0R4811BU0PaS0PQ22P@Q0PQ210@Q9PQ20PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[D@F]H>G_L>HaP>IcT2HaP4IcTDHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06
?Nl4@Q02?Nl2<H`28@P45:D236<2248:12422484124V248236<X2485Ool10001Ool001Eoo`03001o
ogoo009oo`9F]AAJeQ1Nm`iS61AW>A9S60ANm`aS60INm`YJePAF]@=BU09>L`9:DP9240Pmk`92408m
k`8]J`8Li`8DY@8@Q08<H`88@PX48@88@P848BP8@P8<HbP8@PEoo`40005oo`005Goo0P000goo0UJe
55[F45kg3V<H56Li4V<H15kg36<H1Ukg2U[F15Je0e:D0Tic0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU
0Q240PaS0PQ22P@Q0PQ20P@Q:0Q20PaS:0Q217oo0P000Goo000EOol00`00Oomoo`02Ool4E[D@F]HB
G_L>HaP@IcTDHaP4G_L:HaP2IcT2HaP2G_L2HaP4G_L8F]H5E[D2DY@2CW<4BU82@Q02>Lh4?Nl2@Q02
?Nl2:DX26<H248@236<224881242248:12482482124D248836<T248236<22485Ool10001Ool001Eo
o`03001oogoo009oo`AF]A1JeQ9Nm`iS611W>AAS60ANm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PP48@88@PX48@P8@P848A@8@PP<Hb@8
@P8<H`88@PEoo`40005oo`005Goo00<007ooOol00Woo0UJe45[F4Ukg4V<H36Li5V<H15kg3V<H25kg
25[F1EJe0U:D14ic0TYB0T8@0SW>13g_0T8@0SW>0RU:0QS60Q240PaS0PQ220@Q10Q220@Q20Q20P@Q
5PQ21PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D@F]HBG_LBHaP<IcTFHaP4G_L>HaP8
G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02>Lh2:DX26<H248@236<224881244248812482482
124F248636<X2485Ool10001Ool001Eoo`03001oogoo009oo`9F]@iJeQANmaAS60QW>AYS609Nm`iS
60QNm`YJeP=F]@ABU09>L`9:DP96<@8mk`8icP@mk`8icP8U:@8DY@8@Q08<H`88@PP48@@8@PP48@P8
@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`005Goo00<007ooOol00Woo0UJe3U[F55kg56<H26Li6V<H
0Ukg3V<H25kg2U[F0eJe15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ220@Q10Q2
20@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D>F]HDG_LFHaP6
IcTZHaP8G_L:F]H5E[D2DY@4CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<:1246248612482482124F
248636<V248236<5Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`9F]@iJeQANmaIS
60IW>BYS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8DY@@<H`X48@H8@PH48@P8@P84
8AH8@PH<HbH8@P8<H`Eoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomo
o`02Ool@F]HFG_LBHaP8IcTZHaP:G_L8F]H5E[D4DY@2CW<2BU82@Q06>Lh2<H`28@P25:D436<:1246
248612482482124F248636<X2485Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo
0P000goo45[F5Ukg4V<H26Li:V<H2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2P@Q
1PQ21P@Q20Q20P@Q5PQ21PaS:0Q217oo0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007oo
Ool00Woo4U[F55kg46<H2VLi;6<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU
0PaS0PQ25P@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007oo
Ool000Aoo`03001oogoo009ooa9JeQANma1S60YW>BaS60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8i
cP8e[@8aS08Q208DY@8<H`88@QH48@P8@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo4U[F2Ukg0V<H25kg36<H46Li:V<H35kg1e[F0UJe1U:D0Tic0TYB0T8@
0SW>0SF]0Re[0R480QBU0PaS0PQ25P@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000EOol00`00Oomo
o`02OolBF]H:G_L2HaP8G_L<HaP@IcTZHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P2
5:D236<2248F12482482124D248836<X2485Ool10001Ool001Eoo`03001oogoo009ooa9JePYNm`AS
60INm`YS61AW>BQS60iNm`EJeP9F]@IBU0A>L`96<@8mk`8e[@8]J`8Li`8DY@8<HaP48@P8@P848A@8
@PP<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo4U[F2Ukg16<H1Ukg2V<H56Li:6<H3Ukg1E[F
0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS60@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000E
Ool00`00Oomoo`02Ool@F]H@G_L4HaP2G_L:HaP@IcTDHaP4IcT2HaP6G_L<HaP<G_L9F]H4E[D2DY@4
CW<2BU82@Q02=Jd2:DX27>L248@236<@2482124:2486124@248:36<V248212422485Ool10001Ool0
01Eoo`03001oogoo009ooa1JeQ1Nm`AS609Nm`YS611W>AAS60AW>@9S60INm`aS60aNm`UJePAF]@9B
U0A>L`9:DP92408e[@8YBP8Li`8@Q08<Ha08@P848@X8@PH48A08@PX<HbH8@P848@88@PEoo`40005o
o`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi16<H46Li56<H0VLi16<H15kg3V<H35kg2E[F15Je
0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q:PQ240aS90Q21Goo0@000Goo000EOol20003
Ool@F]H@G_L:HaP2IcT4HaP@IcTDHaP2IcT4HaP4G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2
:DX27>L248@236<22486124Z248@36<T2484Ool20001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`YS
609W>@9S611W>AaS60ANm`iS60iNm`MJePAF]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BH8@Q8<
HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi0V<H46Li76<H15kg3V<H3Ukg
1e[F15Je0U:D14ic14YB0Sg_0Re[0QcW0Q2410Q21P@Q9PQ24PaS9PQ21Goo0@000Goo000EOol00`00
Oomoo`02Ool@F]H@G_L8HaP4IcT2HaP@IcTLHaP4G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`2
7>L248@42482124/248@36<V2485Ool10001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`QS60AW>@9S
611W>AaS60ANma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848B`8@Q0<HbH8@PEo
o`40005oo`005Goo00<007ooOol00Woo3U[F4Ukg1V<H1VLi16<H46Li1V<H0VLi4V<H15kg46<H35kg
1e[F1UJe0U:D1Tic0THa0SF]0R480Q244PQ20P@Q7PQ20PaS0PQ230aS9PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool>F]HBG_L6HaP6IcT4HaP@IcT6HaP2IcTBHaP4G_L@HaP<G_L7F]H6E[D2DY@6CW<2
AS42=Jd28@P248@B2482124N248236<2248<36<V2485Ool10001Ool001Eoo`03001oogoo009oo`iJ
ePiNm`YS60IW>@9S61aW>A1S60ANm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8mk`8YBP8@Q108
@P@48Ah8@Ph<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo3U[F3Ukg2V<H1VLi0V<H76Li46<H
15kg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q2440Q210@Q7PQ23PaS:0Q21Goo0@00
0Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPNIcTHHaP4G_L:HaP>G_L7F]H4E[D4DY@4
CW<2AS42<H`25:DB2482124L248636<648@836<T2485Ool10001Ool001Eoo`8000=oo`iJePiNm`QS
60IW>@9S61iW>AQS60ANm`YS60iNm`MJePAF]@ABU0A>L`96<@8aS08DYA88@P848A`8@PH<H`H@Q0P<
Hb@8@PAoo`80005oo`005Goo00<007ooOol00Woo3U[F3Ukg26<H1VLi0V<H86Li5V<H15kg2V<H3Ukg
2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:PQ220aS0Q2411BU0Q241PaS80Q20PaS0PQ21Goo
0@000Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPPIcTFHaP4G_L:HaP>G_L9F]H2E[D2
DY@2E[D4CW<2BU82>Lh26<H2248236<Z248836<248@45:D248@636<P248236<22485Ool10001Ool0
01Eoo`03001oogoo009oo`IJeQINm`YS62IW>BAS60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2188
@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q08<H`88@P8<Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo
1U[F5Ukg2V<H9VLi96<H3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484PQ20P@Q7PQ20PaS0Q2411S6
0QBU0Q240PaS0PQ20PaS90Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4
G_L:HaP2G_L4HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@@2482124N248236<248@46<H2
5:D248@636<T2485Ool10001Ool001Eoo`03001oogoo009oo`IJeQINm`IS62YW>AIS60ANm`YS609N
m`AS60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q108@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q0H<
Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U[F5Ukg1V<H:VLi5V<H15kg1V<H15kg26<H1ekg
25[F15Je25:D0THa0Re[0QBU1PQ20PaS9PQ210aS0QBU12480QBU0Q2410aS9PQ21Goo0@000Goo000E
Ool00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8DY@2AS42;F/2
5:D6248236<V248436<25:D48@P25:D248@436<V2485Ool10001Ool001Eoo`03001oogoo009oo`IJ
eQINm`AS62aW>AIS60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8HaPH8@P8<HbH8@P@<H`8H
aP@]J`8Li`8@Q0@<HbH8@PEoo`40005oo`005Goo0P000goo1U[F5Ukg16<H;6Li5V<H15kg1V<H15kg
26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9PQ210aS0QS612e[0QcW0Q2410aS9PQ217oo0P00
0Goo000EOol00`00Oomoo`02Ool6F]H>G_L<HaPBIcT4JeXDIcTHHaP4G_L8HaP6G_L4HaP7G_L8F]H4
E[D8DY@2BU82>Lh28@P6248236<J248436<8248436<28@P4=Jd28@P248@236<X2485Ool10001Ool0
01Eoo`03001oogoo009oo`IJePiNm`aS619W>@A[FQAW>AQS60ANm`QS60INm`AS60MNm`QJePAF]@QB
U09:DP8icP8Q20H8@P8<HaX8@P@<H`P8@P@<H`8Q20@e[@8Q208@Q08<HbP8@PEoo`40005oo`005Goo
00<007ooOol00Woo15[F3Ukg36<H36Li0V]J16Li36]J46Li96<H15kg26<H0ekg2U[F15Je1U:D0Tic
0T8@0RU:0PaS10Q210aS60Q21PaS1PQ210aS0R4813F]0R480Q240PaS2PQ20P@Q70Q21Goo0@000Goo
000EOol00`00Oomoo`02Ool4F]H>G_L<HaP<IcT2JeX4IcT<JeX@IcTTHaP4G_L8HaP3G_L:F]H4E[D6
DY@2CW<2@Q02:DX236<4248436<H248636<6248436<28@P4=Jd28@P248@236<:2482124L2485Ool1
0001Ool001Eoo`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>C9S60=Nm`aJePIBU09>L`96<@8]J`8D
Y@@8@P8<HaX8@P@<H`P8@P@<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A`8@PEoo`40005oo`005Goo00<0
07ooOol00Woo45kg36<H36Li56]J46Li<V<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6PQ210aS
20Q210aS0QcW12e[0QcW0Q241PaS10Q210@Q70Q21Goo0@000Goo000EOol00`00Oomoo`02Ool@G_L<
HaP<IcTDJeX@IcTXHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D4248436<F248236<<248436<2
6<H49BT25:D248@636<42484124L2485Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eo
o`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>BQS60AW>@IS60=Nm`aJePIBU09>L`9:DP8e[@8DY@@8
@P@<HaH8@P8<H``8@P@<H`8HaP@U:@8DY@8@Q0H<H`@8@P@48A`8@PEoo`40005oo`000goo00D007oo
Oomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L6HaP@IcT@JeX4
IcT2JeX>IcTTHaP4G_L2HaP4JeX4HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H2
36<2248436<F248436<8248436<248@26<H47>L25:D448@236<V2485Ool10001Ool000=oo`05001o
ogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo4Ukg1V<H46Li46]J16Li0V]J
3VLi96<H15kg0V<H16]J16<H00=Nme[FF]H015kg25[F0UJe0U:D0UJe0U:D0TYB0SW>0QS60PaS0PQ2
10aS5PQ210aS20Q210aS0Q240QS611cW0QBU11240PaS9PQ217oo0P000Goo0003Ool01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9Nm`9JePiNm`IS60iW>AQ[
FPiW>BIS609Nm`9S60A[FP9W>@9S60MNm`QJeP9F]@9BU09F]@9BU09:DP8mk`8Li`8<H`88@P@<HaH8
@P@<H`@8@P8<H`88@P@<H`8@Q08DY@@HaP8DY@8@Q0@<HbH8@PEoo`40005oo`000goo00D007ooOomo
o`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2G_L2F]H>G_L6HaP>IcTH
JeX>IcTVHaP2G_L2HaP4JeX2IcT2HaP7G_L8F]H2E[D2DY@2E[D2DY@2BU82?Nl27>L236<2248436<F
248436<4248236<2248436<248@25:D46<H25:D248@436<V2485Ool10001Ool0009oo`8000Aoo`80
00Aoo`8000Eoo`03001oogoo009oo`AJePaNm`QS60aW>AY[FPiW>BIS609Nm`9S609W>@A[FP9S60MN
m`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaH8@P@<H`@8@P8<H`88@P@<H`@@Q0@DY@8@
Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo15[F35kg26<H36Li6V]J3VLi9V<H0Ukg0V<H
0VLi16]J0V<H1ekg25[F0UJe0U:D0UJe0U:D0Tic0T8@0RDY0PaS0PQ210aS5PQ210aS10Q20PaS0PQ2
10aS112411BU0Q241PaS9PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H>G_L8HaP<IcTLJeX@
IcTVHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2CW<2AS42:DX248@2248436<2248236<J2482
36<4248236<448@45:D248@636<V2485Ool10001Ool001Eoo`03001oogoo009oo`9JePiNm`QS60aW
>Aa[FQ1W>BIS609W>@A[FP=S60INm`QJeP9F]@9BU09F]@9BU09>L`96<@8YBP8@Q088@P@<H`88@P8<
HaX8@P8<H`@8@P8<H`@@Q0@DY@8@Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45kg1V<H
36Li46]J0Vmk36]J46Li76<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS
0PQ20PaS10Q20PaS50Q210aS0PQ210aS212420aS10Q220@Q60Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool@G_L6HaP<IcT@JeX2Kg/<JeX@IcTLHaP2G_L:HaP4IcT3HaP6G_L:F]H4E[D2DY@2CW<2AS42
;F/25:D2248436<2248236<4248236<D248436<2248436<848@836<42488124H2485Ool10001Ool0
01Eoo`03001oogoo009ooa1Nm`AS60iW>@I[FPA_N`A[FPI_N`Y[FQ9W>@QS609W>B=S60INm`AJeP9N
m`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<H`88@P8<H`@8@P8<Ha@8@P@<H`88@P@<H`H@Q0H<H`P8
@PP48@@8@PX48@X8@PEoo`40005oo`005Goo0P000goo45kg16<H3VLi1V]J16mk16]J1Vmk2V]J4VLi
26<H0VLi8f<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0TYB0S6<0QS60PQ210aS0PQ20PaS10Q20PaS50Q2
10aS0PQ210aS1Q241PaS20Q220@Q10Q22P@Q2PQ217oo0P000Goo000EOol00`00Oomoo`02Ool>G_L6
HaP<IcT4JeXBKg/:JeXLIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2CW<2=Jd26<H636<2248236<J2484
36<2248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`iNm`IS60aW>@A[
FQ9_N`Y[FQaW>B=S60INm`AJeP9Nm`AJePAF]@ABU09>L`8e[@8HaPH<H`88@P8<HaX8@P@<H`88@Q0<
H`P8@PP48@@8@P`48@P8@PEoo`40005oo`005Goo00<007ooOol00Woo3Ukg1V<H2VLi1V]J56mk26]J
76Li56<H15kg3F<H15kg15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21PaS4PQ20PaS1PQ210aS0PQ2
40aS20Q220@Q10Q230@Q20Q21Goo0@000Goo000EOol00`00Oomoo`02Ool>G_L6HaP:IcT6JeXDKg/8
JeXLIcTDHaP4G_L=HaP4G_L4F]H2G_L8F]H4DY@2CW<2>Lh26<H236<2248636<B248236<6248436<2
248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`YNm`QS60YW>@I[FPI_
N`IcW0Q_N`Y[FQ1W>C5S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20P<H`88@P8<H``8@PH<H`X8
@Q8<H`H8@Ph48@P8@PP48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo2Ukg26<H2VLi1V]J1Vmk
1W>L26mk2V]J46Li<F<H15kg1U[F0Ukg15[F15Je0U:D0TYB0Sg_0R4820aS0PQ20PaS30Q21PaS2PQ2
4PaS1PQ23P@Q20Q220@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool:G_L6HaP<IcT6JeX4Kg/:
Li`2Kg/2Li`4Kg/:JeX>IcTaHaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P836<2248236<@2482
36<:248D36<4248B1242248:12442485Ool10001Ool001Eoo`03001oogoo009oo`YNm`IS60aW>@I[
FPA_N`YcW09_N`9cW0A_N`Y[FPiW>C5S60INm`AJeP9Nm`AJePAF]@9BU09>L`92408Q20P<H`88@P8<
Ha08@P8<H`X8@Q@<H`@8@Q848@88@PX48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg26<H
2VLi1V]J16mk4W>L0Vmk0V]J0Vmk1V]J3VLi<F<H2Ukg1U[F1UJe0Tic0T8@0RDY30aS70Q250aS0PQ2
80@Q10Q21Goo0@000Goo000EOol20003Ool8G_L8HaP:IcT6JeX4Kg/BLi`2Kg/2JeX2Kg/6JeX>IcTa
HaP:G_L6F]H6E[D2CW<2@Q029BT<36<L248D36<2248P12442484Ool20001Ool001Eoo`03001oogoo
009oo`QNm`IS60YW>@I[FPA_N`IcW0Ig_@IcW0Q_N`I[FQ1W>BmS60YNm`QJePAF]@9>L`96<@8YBP8@
Q0X<Ha88@P8<H`P8@Q8<H`@8@R048@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg1V<H2VLi
1V]J16mk1W>L1WNm1W>L26mk1V]J46Li;f<H2Ukg25[F15Je0Tic0THa0RU:0Q242PaS4PQ20PaS20Q2
4PaS10Q280@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6G_L8HaP8IcT8JeX4Kg/4Li`8Mkd6
Li`4Kg/2JeX2Kg/4JeXBIcT8HaP2IcT6HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX248@236<22486
36<B248236<8248636<4248636<6248T1245Ool10001Ool001Eoo`03001oogoo009oo`INm`QS60QW
>@Q[FPA_N`AcW0Qg_@IcW0A_N`9[FP9_N`A[FQ9W>@QS609W>@IS609W>AeS60aNm`IJePAF]@9>L`96
<@8YBP8@Q08<H`88@PH<Ha88@P8<H`P8@PH<H`@8@PH<H`H8@R@48@Eoo`40005oo`005Goo00<007oo
Ool00Woo1Ukg1V<H2VLi16]J1Vmk0W>L3WNm17>L16mk0V]J0Vmk16]J56Li16<H16Li86<H0VLi0f<H
35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L6HaP:IcT4JeX6Kg/2Li`>Mkd4Li`4Kg/2JeX2Kg/4JeXDIcT4HaP4IcTP
HaP2IcT3HaP<G_L6F]H4E[D2DY@2AS42:DX248@236<2248636<B248236<8248B36<4248T1245Ool1
0001Ool001Eoo`03001oogoo009oo`INm`AS60YW>@I[FPA_N`AcW09g_@YkgP9g_@IcW09_N`9[FP9_
N`I[FQYW>A1S609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88
@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`40005oo`005Goo00<007ooOol00Woo1Ukg16<H2VLi1V]J
16mk17>L0WNm2W_N0WNm1W>L0Vmk0V]J0Vmk1V]J6VLi46<H0VLi3V<H0VLi00=S65kgG_L035kg0U[F
0Ukg0U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L4HaP:IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`6Kg/6JeXLIcT>HaP2IcTA
HaP>G_L2F]H2G_L2F]H4E[D2DY@2BU82:DX236<22482124636<6248236<:248236<8248B36<4248T
1245Ool10001Ool001Eoo`8000=oo`INm`AS60YW>@A[FPA_N`AcW0Ag_@YkgPAg_@AcW0I_N`I[FQaW
>@iS609W>A5S60iNm`9JeP9Nm`9JePAF]@9BU09:DP8YBP8<H`88@P848@H<H`H8@P8<H`X8@P8<H`P8
@Q8<H`@8@R@48@Aoo`80005oo`005Goo00<007ooOol00Woo36<H1VLi1V]J0Vmk17>L17Nm17_N1Woo
17_N0WNm17>L16mk1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q20Q22PaS30Q21PaS1PQ2
30aS10Q290@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<HaP6IcT6JeX2Kg/4Li`4Mkd4Nmh6Ool4
Nmh2Mkd4Li`4Kg/6JeXLIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@21248248:36<<248636<6248<
36<4248T1245Ool10001Ool001Eoo`03001oogoo009oo`aS60IW>@A[FPA_N`9cW0Ag_@AkgPQoo`Ak
gP9g_@AcW0A_N`I[FQaW>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@H8@PX<HbH8@RH48@Eo
o`40005oo`005Goo00<007ooOol00Woo36<H1VLi16]J16mk0W>L17Nm17_N27oo17_N0WNm17>L16mk
1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240PQ20P@Q1PQ22PaS9PQ29P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool<HaP4IcT6JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`6Kg/4JeXPIcT:HaP2
IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224841248248636<V248V1245Ool10001Ool001Eoo`03
001oogoo009oo`aS60AW>@I[FP9_N`AcW09g_@AkgPYoo`AkgP9g_@AcW0I_N`A[FR1W>@YS609W>A=S
60iNm`IJePAF]@9BU096<@8]J`8DY@88@P@48@P8@PH<HbH8@RH48@Eoo`40005oo`005Goo00<007oo
Ool00Woo26<H26Li16]J16mk0W>L0WNm17_N3Woo0W_N0WNm17>L1Vmk16]J8VLi7f<H35kg1U[F15Je
0U:D0THa0Re[0QBU0PQ210@Q0PQ20P@Q1PQ210aS80Q20PaS10Q29P@Q1Goo0@000Goo00000goo0000
000300000goo000000020003Ool20005Ool00`00Oomoo`02Ool8HaP8IcT4JeX4Kg/2Li`2Mkd4Nmh>
Ool2Nmh2Mkd4Li`6Kg/4JeXRIcTOHaP<G_L6F]H4E[D2DY@2AS42;F/25:D224841242248212462484
36<P248236<4248V1245Ool10001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<0
07ooOol00Woo1V<H26Li1V]J0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F
15Je0U:D0THa0Re[0QBU0PaS0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q1Goo0@00
0Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000goo1V<H26Li1V]J
0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F15Je0U:D0THa0Re[0QBU0PaS
0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q17oo0P000Goo0003Ool00`00Oomoo`03
Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li1V]J16mk0W>L0WNm
0W_N4Woo17_N0WNm0W>L1Vmk1V]J6VLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS60PaS0PQ20P@Q0PQ2
0P@Q0PQ210@Q:0Q2:0@Q1Goo0@000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo009oo`03001oogoo009oo`AS60QW>@I[FPA_N`9cW09g_@9kgQ9oo`AkgP9g_@9cW0I_N`I[
FQYW>BMS60QNm`QJePAF]@9BU09:DP8aS08HaP8<H`88@P848@88@P848@88@P@48BP8@RP48@Eoo`40
005oo`000Woo0P0017oo0P0017oo0P001Goo00<007ooOol00Woo16<H1VLi1V]J16mk0W>L17Nm0W_N
57oo0W_N0WNm0W>L1Vmk1V]J76Li2V<H16Li3V<H0Ukg0f<H0Ukg16<H1Ukg25[F15Je0U:D0TYB0SF]
0R480Q240PQ20P@Q0PQ20P@Q0PQ210@Q0PQ20P@Q40Q210aS40Q2:0@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool4HaP6IcT6JeX4Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`6Kg/6JeXLIcT:HaP4IcT>HaP2
G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@22482124224821242248412422482124@
248436<@248X1245Ool10001Ool001Eoo`03001oogoo009oo`9S60IW>@I[FPA_N`AcW09g_@AkgQAo
o`9kgP9g_@9cW0I_N`I[FRYW>@iS60MNm`AS60INm`QJePAF]@9BU09:DP8mk`8U:@8DY@88@P848@H8
@P@48@88@PP48@X8@PP<H``8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo0V<H1VLi1V]J16mk
17>L0WNm17_N57oo0W_N0WNm0W>L1Vmk1V]J:VLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY
0QBU0PQ20P@Q1PQ210@Q0PQ220@Q2PQ220aS30Q2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool8
IcT8JeX2Kg/2Li`4Mkd4NmhBOol4Nmh2Mkd2Li`2Kg/2JeX2Kg/8JeXRIcTHHaP=G_L8F]H4E[D2CW<2
AS42@Q02<H`27>L236<624841242248:1246248436<6248236<4248236<6248X1245Ool10001Ool0
01Eoo`03001oogoo009oo`QW>@Q[FP9_N`9cW0Ag_@AkgQ9oo`AkgP9g_@9cW09_N`9[FP9_N`Q[FR9W
>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`H8@P@48@88@PX48@H8@P@<H`H8@P8<H`@8@P8<
H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li1V]J16mk0W>L0WNm17_N57oo0W_N17Nm
0W>L0Vmk0V]J16mk26]J86Li66<H3Ekg25[F0UJe0U:D0Tic14Ha0SW>0RDY0QBU1PQ240@Q5PQ20PaS
1PQ2:0@Q1Goo0@000Goo000EOol20003Ool8IcT6JeX4Kg/2Li`2Mkd4NmhDOol2Nmh4Mkd2Li`2Kg/2
JeX4Kg/8JeXPIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D6248@124F248236<6248X1244
Ool20001Ool001Eoo`03001oogoo009oo`QW>@A[FPI_N`9cW09g_@AkgQAoo`9kgPAg_@9cW09_N`9[
FPA_N`i[FP9W>@A[FQAW>AQS60eNm`9JeP9Nm`AJeP9F]@9BU09>L`A6<@8mk`8aS08Li`8<H`@8@Q@4
8A88@P8<H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li16]J1Vmk0W>L0WNm17_N57oo
0W_N17Nm0W>L0Vmk0V]J16mk3V]J0VLi16]J56Li66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha0Sg_
0S6<0QcW0PaS10Q250@Q4PQ20PaS1PQ2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4
Kg/4Li`2Mkd4NmhDOol2Nmh4Mkd2Li`8Kg/FJeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2
BU82AS44@Q02>Lh29BT248@4248F124<248636<4248Z1245Ool10001Ool001Eoo`03001oogoo009o
o`IW>@I[FPA_N`AcW09g_@AkgQAoo`9kgPAg_@9cW0Q_NaI[FQ9W>@QS60AW>@eS60aNm`9JePANm`9J
eP9F]@9BU09:DP96<@A2408icP8U:@8@Q0@8@QH48@`8@PH<H`@8@RX48@Eoo`40005oo`005Goo00<0
07ooOol00Woo1VLi1V]J16mk17>L0WNm0W_N57oo17_N17Nm0W>L1Vmk26]J26Li26]J4VLi26<H16Li
3F<H35kg0U[F15kg0U[F0UJe0U:D0TYB0THa0Sg_0THa0T8@0S6<0QS60PaS10Q26P@Q40Q2:P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4Kg/4Li`2Mkd2NmhDOol4Nmh4Mkd2Li`6Kg/8JeX8
IcT8JeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`26<H236<4
248J124@248Z1245Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0
ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool0
01Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell["\<\
sample={
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.517647, 0.54902, 0.45098},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.388235, \
0.258824},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.419608, 0.352941, 0.192157, \
0.0941176},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.419608, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, \
0.482353, 
0.54902, 0.54902, 0.482353, 0.388235, 0.223529, 0.129412, 0, 0},
{0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.54902, 
0.517647, 0.419608, 0.290196, 0.160784, 0.0627451, 0.0313725, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.482353, 0.482353, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.45098, 
0.352941, 0.223529, 0.0941176, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, \

0.129412, 0.0313725, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.54902, 0.54902, 0.482353, 0.388235, 0.258824, 0.129412, \

0.0313725, 0, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.45098, 0.321569, 0.192157, 0.0941176, 0.0313725, \

0, 0, 0, 0, 0, 0, 0, 0},
{0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.482353, 0.419608, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.388235, 0.45098, 0.517647, 0.517647, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.45098, 
0.352941, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.45098, \

0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 0.388235, 0.290196, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \

0.517647, 0.54902, 0.580392, 0.54902, 0.45098, 0.352941, 0.192157, 0.129412, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.517647, 
0.54902, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.580392, 0.580392, 0.45098, 0.321569, 0.192157, 0.0941176, 0, 0, 0, \
0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.482353, 0.290196, 0.160784, 0.0627451, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.54902, \

0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.45098, 0.290196, 0.129412, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.45098, 
0.290196, 0.160784, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725},
{0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.517647, 0.482353, 0.54902, 
0.54902, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 
0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.482353, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, 0.160784, 
0.0627451, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0.0313725, 
0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.482353, 0.45098, 0.388235, 0.352941, 0.419608, 0.517647, 0.580392, \
0.611765, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, 0.0627451, \

0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.482353, 0.419608, 0.388235, 0.482353, 0.580392, 0.647059, \
0.647059, 
0.611765, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.54902, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.54902, \

0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.517647, 0.580392, 0.678431, 0.709804, \
0.807843, 
0.741176, 0.611765, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.482353, 0.321569, 0.192157, 0.0941176, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.611765, 0.709804, 0.776471, \
0.870588, 
0.807843, 0.678431, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.419608, 0.388235, 0.352941, 0.352941, 0.321569, \

0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.482353, 0.647059, 0.776471, 0.807843, \
0.807843, 
0.709804, 0.611765, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, \

0.54902, 0.45098, 0.419608, 0.45098, 0.517647, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.517647, 0.419608, 0.258824, 0.129412, 0.0313725, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, \
0.482353, 
0.419608, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.258824, 0.45098, 0.709804, 0.870588, 0.905882, \
0.807843, 
0.678431, 0.647059, 0.647059, 0.647059, 0.709804, 0.807843, 0.776471, \
0.678431, 
0.517647, 0.388235, 0.388235, 0.517647, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.45098, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.321569, 0.45098, 0.611765, 0.807843, 0.905882, 0.839216, \
0.678431, 
0.580392, 0.647059, 0.709804, 0.741176, 0.776471, 0.807843, 0.741176, \
0.647059, 
0.517647, 0.482353, 0.517647, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 
0.290196, 0.160784, 0.0627451, 0, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.388235, 0.388235, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.517647, 0.678431, 0.807843, 0.870588, 0.870588, 0.709804, \
0.54902, 
0.482353, 0.580392, 0.709804, 0.741176, 0.709804, 0.678431, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 0.352941, \

0.192157, 0.0941176, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.54902, 0.678431, 0.776471, 0.870588, 0.839216, 0.807843, 0.611765, \
0.482353, 
0.419608, 0.45098, 0.54902, 0.580392, 0.580392, 0.611765, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.482353, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.611765, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.647059, \
0.54902, 
0.45098, 0.419608, 0.419608, 0.419608, 0.517647, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.517647, 0.388235, 0.258824, \
0.160784, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.54902, 0.482353, 0.45098, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.647059, \

0.647059, 0.647059, 0.611765, 0.647059, 0.678431, 0.741176, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.45098, 0.419608, 0.482353, 0.54902, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, \
0.0627451, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.580392, \
0.611765, 
0.647059, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.482353, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, \

0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.709804, 0.678431, 0.678431, 0.647059, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.54902, \
0.580392, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.54902, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, \

0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.482353, 0.54902, \

0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.482353, 0.290196, 0.129412, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, \

0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.54902, \
0.517647, 
0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.352941, 0.192157, 0.0627451, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.580392, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.54902, 0.388235, 0.258824, 0.129412, 0.0313725, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.580392, \

0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.517647, 0.517647, 0.580392, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.580392, 
0.45098, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.517647, 0.54902, 0.647059, 0.678431, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.517647, 
0.352941, 0.192157, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, \
0.45098, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.611765, 0.54902, 0.517647, 0.580392, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.54902, \
0.419608, 
0.258824, 0.129412, 0.0627451, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.709804, 
0.678431, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.482353, \
0.321569, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.580392, 0.54902, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.517647, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.678431, 0.678431, 0.611765, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.580392, 0.611765, 0.647059, 0.647059, 0.54902, 0.45098, 0.258824, 0.160784, \

0.0627451, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.580392, 0.580392, 0.580392, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.678431, 0.647059, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.580392, 0.388235, 0.258824, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.647059, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.482353, 0.321569, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.419608, 0.258824, 0.160784, 0.129412, \
0.0941176, 
0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, \

0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.517647, 0.352941, 0.192157, 0.129412, 0.0941176, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.647059, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.45098, 0.290196, 0.160784, 0.0941176, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.678431, 0.647059, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.517647, 0.352941, 0.223529, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.647059, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.580392, 0.419608, 0.258824, 0.160784, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, 0.611765, \
0.580392, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.54902, 0.352941, 0.192157, 0.129412, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.482353, 0.321569, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.54902, 
0.419608, 0.258824, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.647059, \
0.517647, 
0.321569, 0.192157, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.611765, \
0.45098, 
0.258824, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.54902, \
0.388235, 
0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.45098, \
0.290196, 
0.160784, 0.160784, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.419608, \
0.258824, 
0.129412, 0.160784, 0.192157, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.611765, 0.580392, 0.54902, 0.54902, 0.517647, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.482353, 0.321569, \
0.192157, 
0.129412, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.45098, 0.290196, \
0.160784, 
0.0941176, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.223529, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.388235, 0.223529, \
0.129412, 
0.0941176, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.258824, 0.223529, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, \

0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0941176, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.129412, 
0.192157, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.45098, 0.290196, 0.160784, \
0.0941176, 
0.129412, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.419608, 0.258824, 0.129412, \
0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.517647, 0.388235, 0.223529, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.580392, 0.54902, 0.482353, 0.352941, 0.192157, 0.129412, 0.129412, \

0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.611765, \
0.54902, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.580392, 0.54902, 0.419608, 0.290196, 0.192157, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.54902, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, \
0.580392, 
0.54902, 0.517647, 0.517647, 0.482353, 0.517647, 0.54902, 0.517647, 0.517647, \

0.517647, 0.54902, 0.517647, 0.388235, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.482353, 0.352941, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.45098, 0.321569, 0.223529, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.388235, 0.258824, 0.160784, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.352941, 0.223529, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.580392, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.45098, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.482353, \

0.482353, 0.45098, 0.290196, 0.160784, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.611765, 0.611765, 0.54902, 0.517647, 0.45098, 0.45098, 
0.482353, 0.419608, 0.290196, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.45098, 0.45098, \

0.45098, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, \

0.419608, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.45098, 
0.419608, 0.352941, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.223529, 0.160784, 0.0941176, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.517647, 
0.419608, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.54902, 
0.45098, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.482353, 0.352941, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, \
0.580392, 
0.517647, 0.388235, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.54902, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.321569, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.54902, 0.388235, 0.160784, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.678431, \
0.611765, 
0.611765, 0.580392, 0.45098, 0.192157, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.611765, \
0.678431, 
0.647059, 0.580392, 0.482353, 0.258824, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.678431, 
0.647059, 0.611765, 0.517647, 0.290196, 0.129412, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.160784, 0.258824, 0.258824, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.419608, 0.192157, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.192157, 0.352941, 0.352941, 0.223529, 0.129412, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.45098, 0.258824, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.517647, 0.321569, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.223529, 0.352941, 0.352941, 0.223529, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.580392, 0.419608, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.192157, 0.290196, 0.290196, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.839216, 0.839216, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.45098, 0.192157, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.192157, 0.223529, 0.223529, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.839216, 0.839216, 0.807843, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.482353, 0.223529, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.160784, 0.192157, 0.192157, 0.160784, 0.129412, 0.0941176, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.517647, 0.290196, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.54902, 0.321569, 0.129412, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.580392, 0.388235, 0.192157, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.419608, 0.192157, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.647059, 0.611765, 0.45098, 0.192157, \
0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.482353, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.870588, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.517647, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.611765, 0.517647, 0.290196, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, \
0.870588, 
0.905882, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, \
0.937255, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, \
0.905882, 
0.905882, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, \
0.905882, 
0.937255, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.321569, \
0.0941176, 
0.0627451, 0.0313725, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, \
0.937255, 
0.937255, 0.968627, 0.968627, 1, 1, 1, 0.968627, 0.968627, 0.937255, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0313725, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, \
0.937255, 
0.968627, 0.968627, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0627451, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, \
0.968627, 
0.968627, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.905882, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.580392, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.482353, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.839216, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.611765, 
0.54902, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.482353, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.517647, 0.45098, 0.290196, 0.129412, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
0.968627, 
0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, 0.54902, \
0.482353, 
0.54902, 0.517647, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725}};\
\>", "Graphics",
  Evaluatable->True,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ 128\[Times]128\ simple\)], "Input"],

Cell[CellGroupData[{

Cell["size=Dimensions[sample]", "Input"],

Cell[BoxData[
    \({128, 128}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SamplePhoto = 
      ListDensityPlot[sample, Mesh \[Rule] False, 
        AspectRatio \[Rule] size[\([1]\)]/\((size[\([2]\)])\), 
        PlotLabel \[Rule] "\<Sample Photo\>"]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sample) show
105.000 12.813 moveto
(Photo) show
135.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000LOol2
000QOol40003Ool2000POol30002Ool2000NOol30004Ool2000OOol20004Ool2000KOol50002Ool2
0004Ool2000GOol500000goo000000020003Ool2000COol001]oo`04001oogoo000POol00`00Oomo
o`03Ool01000Oomoo`0087oo00@007ooOol0009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo00@007ooOol0009oo`04001oogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0
009oo`03001oogoo01Ioo`05001oogooOol00005Ool01000Oomoo`004Woo000KOol01000Oomoo`00
8Goo00<007ooOol00Woo00@007ooOol001eoo`D00005Ool007ooOol0000MOol01000Oomoo`000Woo
00@007ooOol001eoo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001o
ogoo0002Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`004Woo000K
Ool01000Oomoo`008Woo00D007ooOomoo`00009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo0`000goo00@007ooOol001ioo`8000=oo`04001oogoo000LOol01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo01Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00
Oomoo`0@Ool001]oo`04001oogoo000POol01000Oomoo`000Woo00@007ooOol001ioo`03001oo`00
009oo`04001oogoo000NOol00`00Oomoo`02Ool01000Oomoo`007Goo00@007ooOol0009oo`04001o
ogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo01Ioo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol047oo000LOol2000ROol20004Ool2000POol20003Ool2
000OOol30003Ool2000OOol20004Ool2000LOol20004Ool20004Ool2000HOol20004Ool20004Ool2
000COol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Qoool0
00D000Aoo`0067oo00<007ooOol00Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo0P0017oo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool0015oo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@0
07ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@007ooOol000Aoo`<00?io
o`<000Aoo`0047oo00@007ooOol000Aoo`03001oogoo009oodHe[@@icPHe[@PicP03=JdaS36<008e
[C<icP8mka<icT4mk`=240Hmk`924096<@924096<@8icPEoo`03001oogoo009oo`0047oo00@007oo
Ool000Aoo`03001oogoo009oodHe[@@icPHe[@PicP03=JdaS36<008e[C<icP8mka<icT4mk`=240Hm
k`924096<@924096<@8icPEoo`03001oogoo009oo`004Goo0P001Goo00<007ooOol00WooD3F]1SW>
0cF]0S6<0SF]73W>0Sg_2CW>13F]43W>13g_1cW>BSg_1T8@0Sg_0S6<0R481Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Oom@=Jd6>Lh3=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl7>Li:?Nl6@Q02
?Nl2<H`28@P5Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooe0e[@@icP@e[@<aS08e[A`icP8m
k`TicP@e[A0icPHmk`<icP`mk`HicRlmk`A240<mk`Q2408e[@8]J`8HaP8<H`Eoo`03001oogoo009o
o`0067oo00<007ooOol00WooD3F]13W>13F]0c6<0SF]73W>0Sg_2CW>13F]43W>1Sg_0cW>33g_1SW>
;cg_148@0cg_248@0SF]0Re[0QS60PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Oolj=Jd2
>Lh8=Jd2>Lh:=Jd4>Lh4=Jd00c6<=Jde[@02=JdL>Lh2?Nl3>Lh2?Nl2>Lh4<H`2=Jd4?Nl8>LhC?Nl2
>LhW?Nl4@Q02?Nl4@Q06?Nl4@Q02?Nl00cW>?Nlmk`04AS42?Nl2<H`27>L248@40005Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oocXe[@8icPPe[@8icPXe[@@icP@e[@03<H`e[CF]008e[A`icP8m
k`<icP8mk`8icP@aS08e[@@mk`PicQ<mk`8icRLmk`A2408mk`A240Hmk`A2408mk`03>Lhmkcg_00A6
<@8mk`8aS08Li`8@Q0@000Eoo`03001oogoo009oo`0067oo0P000goo0SW>=3F]1SW>1SF]1SW>1SF]
1SW>13F]00<aS3F]=Jd07SW>0Sg_0cW>0Sg_0SW>136<0SW>A3g_2T8@0Sg_1T8@23g_00=244HaAS40
0T8@0SF]0RDY0QBU0PQ20P@Q100017oo0P0017oo000HOol00`00Oomoo`02Ool2>Lhd=Jd6>Lh6=Jd6
>Lh6=Jd6>Lh4=Jd00c6<=Jde[@0N>Lh2?Nl3>Lh2?Nl2>Lh4<H`2>Li4?Nl:@Q02?Nl6@Q08?Nl00d8@
AS56<@02@Q02=Jd29BT25:D2248212440005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo``i
cQle[A<icP8e[@PicP@e[@HicPLe[@hicP8e[A0icP8mk`03>Lhmkcg_008mk`8e[@8aS08e[BDmk`A2
40hmk`I240<mka12408mk`m2408icP8]J`8Li`8<H`X000Eoo`03001oogoo009oo`0067oo00<007oo
Ool00Woo33W>7cF]4cW>0SF]23W>13F]1SW>1cF]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Cg_148@3Sg_1T8@0cg_448@0Sg_3d8@0SW>0Re[0QcW0PaS2P001Goo00<007ooOol00Woo000H
Ool00`00Oomoo`02OolI>Lh2=Jd4>Lh8=Jd?>Lh4=Jd4>Lh2=Jd6>Lh6=Jd6>Lh7=JdL>Lh4?Nl2>Lh3
?Nl2>Lh2=Jd2<H`2=JdS?Nl8@Q0<?Nl7@Q02?NlD@Q04?Nl2@Q04AS42@Q000cF]9BTU:@0248@2124<
0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooaTicP8e[@@icPPe[@licP@e[@@icP8e[@Hi
cPHe[@HicPLe[A`icP@mk`8icP<mk`8icP8e[@8aS08e[B<mk`Q240`mk`M2408mkaA240@mk`9240A6
<@924003=JdU:BDY008@Q0848@`000Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo?SW>13F]
1SW>0SF]23W>0SF]0S6<0SF]2CW>13g_33W>23g_0SW>0cg_0SW>13F]0SW>7cg_0T8@0Sg_1T8@3Sg_
7D8@0Sg_0T8@14Ha0Sg_0S6<00<Q212448@00P@Q3P001Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ooln>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd9>Lh4?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhO?Nl2
@Q02?Nl6@Q0>?NlM@Q02?Nl2@Q04AS42?Nl2<H`00b4848@@Q002124>0005Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo009ooaTicP8e[CLicP@e[@TicPhmk`@icP/mk`8icP@e[@8icQlmk`A2408mk`I2
40PmkaM2408mk`Y240I6<@8icP8YBP8HaP0336<48@@Q010000Eoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo6CW>0SF]=cW>13F]2CW>3Sg_13W>2cg_0SW>13F]0SW>7cg_148@0Sg_1T8@23g_5d8@
0Sg_2T8@1THa0SW>0RU:0QS600<<H`@Q124040001Goo00<007ooOol00Woo000HOol20003Ool2?Nm>
>Lh6=Jd2>Lh00cg_>LhicP02>LhO?Nl4=Jd2>LhJ?Nl;@Q02?Nl6@Q06?NlQ@Q06AS42?Nl2=Jd29BT2
48@2124=000212440004Ool20004Ool001Qoo`03001oogoo009ooa/mkcDicPHe[@8icP03?NlicSW>
008icP@mk`@icQHmk`03>Lhe[CF]008aS08icPA240@icPhmk`U2408mkaY240M6<@9240A6<@Q240A6
<@9:DP96<@92408aS08Li`8<H`848@80000312400000008000@48@X000Eoo`03001oogoo009oo`00
67oo00<007ooOol00Woo6cg_=CW>1SF]0SW>00<mkcW>>Lh00SW>13g_13W>5Sg_00<icSF]=Jd00S6<
0SW>148@13W>3Sg_2D8@0Sg_6T8@1dHa0T8@14Ha248@14Ha0TYB0THa0T8@0S6<0QcW0PaS0P@Q0P00
00<48@0000000P0010@Q2P001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolG?Nl8>Lh8?Nl4
>LhG?Nl8>Lh2?Nl2>Lh6=Jd4>LhI?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2>Lh4?NlI@Q04?NlO
@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124C0005Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009ooaLmk`PicPPmk`@icQLmk`PicP8mk`8icPHe[@@icQTmk`@icPHmk`03>Lhe[CF]008e
[@8icPHmk`8icP@mkaU240@mkam240A6<@8mk`9240I6<@8icP8]J`8Li`8<H`848@8000848A<000Eo
o`03001oogoo009oo`0067oo00<007ooOol00Woo6cg_13W>23g_13W>2cg_13W>3Sg_0SW>0Sg_0SW>
13F]13W>9Cg_00<icSF]=Jd00SW>0Sg_0T8@3Sg_>T8@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q
4`001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolK?Nl4>Lh8?Nl4>Lh;?Nl4>Lh>?Nl2>Lh2
?Nl2>Lh4=Jd4>LhU?Nl00cW>=Jde[@02>Lh2?Nl2@Q0>?Nlj@Q08AS42?Nl2<H`29BT25:D224821244
0002124C0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo``mk`A2408mk`E243Dmk`PicRDm
k`DicP@mk`A2408mk`A240PmkbU24096<@M24096<@A24096<@9:DP96<@8icP8]J`8HaP8@Q0848@P0
00848A<000Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo33g_148@0Sg_1D8@=Cg_23W>9Cg_
1CW>13g_148@0Sg_148@23g_:D8@0THa1d8@0THa148@0THa0TYB0THa0SW>0Re[0QS60Q240P@Q2000
0P@Q4`001Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool@@Q02?Nl5@Q04?Nl4@Q0]?Nl6>LhW
?Nl2>Lh5?Nl<@Q08?Nlb@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124G0005Ool0
0`00Oomoo`02Ool001Qoo`8000=ooa12408mk`E240@mk`A242dmk`HicRLmk`8icPDmk`a240Pmkc92
4096<@924096<@9:DP96<@8icP8YBP8HaP88@P848@@000@48AL000Aoo`8000Aoo`0067oo00<007oo
Ool00Woo6D8@0Sg_1T8@0Sg_5d8@43g_23W>0Sg_0T8@3cg_148@4cg_148@13g_A48@0THa14YB0SW>
0RU:0QS60PaS1P0010@Q6@001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolI@Q02?Nl6@Q02
?NlG@Q0@?Nl8>Lh2?Nl2@Q0??Nl4@Q0C?Nl4@Q04?Nm4@Q02AS44BU82>Lh2:DX26<H236<60004124I
0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`96<@I240A6<C9240`mk`HicP@mk`92414m
k`9240@mk`9240Xmk`M240@mkaY240U6<AA24096<@M240I6<@9:DP8mk`8U:@8DY@88@RD000Eoo`03
001oogoo009oo`0067oo00<007ooOol00Woo0THa1T8@14Ha<T8@33g_1SW>13g_0T8@4Cg_0T8@13g_
0T8@2Sg_1d8@13g_6T8@2DHa548@0THa1d8@1THa0TYB0Sg_0RDY0QBU0PQ29@001Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02OolIAS4a@Q08?Nl7@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q07AS4B@Q02AS42
@Q06AS44@Q03AS42BU82AS42>Lh29BT248@412420002124<0002124C0005Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo009ooaU6<C5240Pmk`M240`mk`Y240XmkaE240A6<@Y240M6<A924096<@9240I6
<@A240=6<@9:DP96<@8icP8U:@8@Q0@48@8000848@`000848A<000Eoo`03001oogoo009oo`0067oo
00<007ooOol00Woo6DHa248@2THa7d8@13g_8D8@13g_0SW>13g_3d8@2THa2T8@1DHa448@1THa0T8@
2dHa14YB0SW>0RDY0QBU20@Q1P0010@Q5@0010@Q1Goo00<007ooOol00Woo000:Ool40003Ool20005
Ool00`00Oomoo`02OolIAS48@Q0:AS4O@Q04?NlQ@Q04?Nl2>Lh4?Nl?@Q0:AS4:@Q05AS4@@Q06AS42
@Q0;AS44BU82>Lh29BT25:D812460004124E00041245Ool00`00Oomoo`02Ool000Yoo`03001oogoo
00=oo`04001oogoo0004Ool00`00Oomoo`02Ool2BU8[AS4E@Q02AS42BU82AS42@Q02?Nl4AS44?NlE
@Q02?Nl4@Q06?NlY@Q05AS44@Q02AS46@Q0<AS44@Q02AS43BU82AS42>Lh2:DX248@22488124S0005
Ool00`00Oomoo`02Ool000]oo`03001oogoo009oo`04001oogoo0004Ool30002Ool2BU8[AS4E@Q02
AS42BU82AS42@Q02?Nl4AS44?NlE@Q02?Nl4@Q06?NlY@Q05AS44@Q02AS46@Q0<AS44@Q02AS43BU82
AS42>Lh2:DX248@22488124S0003Ool30004Ool000aoo`05001oogooOol00002Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool<BU87AS46BU8JAS47@Q02AS44@Q02?Nl4>Lh2?Nl4@Q04AS44@Q02AS47@Q04
AS46@Q02AS4>@Q02AS4S@Q07AS44@Q0FAS42@Q04AS400d8@=Jde[@029BT25:D2248W000212440005
Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo34YB
1dHa1TYB6THa1d8@0THa148@0Sg_13W>0Sg_148@14Ha148@0THa1d8@14Ha1T8@0THa3T8@0THa8d8@
1dHa148@5THa0T8@14Ha00=243F]=Jd00RDY0QBU0PQ29`000P@Q10001Goo00<007ooOol00Woo000;
Ool20004Ool20005Ool00`00Oomoo`02OolSBU8IAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02BU82CW<;
AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0cAS42BU82AS400cF]9BTU:@0248@2248<0002124<0002124;
00081245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oob=:DQU6<@92408mk`8icP8aS08]J`8e
[@92409:DP9>L`]6<@A240I6<@A24096<@Y241E6<@A243=6<@9:DP96<@03=JdU:BDY008@Q088@P`0
00848@`000848@/000P48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo3TYB1Dic24YB14Ha
7DYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@1dHa148@0THa0TYB24Ha248@14Ha0T8@@4Ha1TYB
0THa0SW>00<YBQS66<H00PQ20P@Q0P003P@Q20002@@Q10002P@Q1Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool>BU85CW<8BU84AS4MBU84AS42?Nl2=Jd2<H`2?Nl2BU84DY@2CW<4@Q07AS44@Q02
AS42BU88AS48@Q04AS42@Q10AS46BU82AS42>Lh00bU:6<HHaP0224821242000>124800091244000:
1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A>L`Q:DPI>L`M:DP9>L`96<@A:DPQ>L`9:
DPI6<@A240E6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240]6<@A:DP96<@9240A6<@I24396
<@A:DQ96<@A:DP96<@8mk`8YBP036<H<H`aS00848@@000@48@H000848@X001L48@Eoo`03001oogoo
009oo`0067oo00<007ooOol00Woo14ic24YB1Tic1dYB0Tic0THa14YB24ic0TYB1THa148@1DHa24YB
0THa0T8@0TYB0UJe0U[F0VLi0Ukg0Tic0T8@2dHa14YB0THa0T8@14Ha1T8@<THa14YB4THa14YB0THa
0Sg_0RU:00<HaPaS36<00P@Q100010@Q1P000P@Q2P005`@Q1Goo00<007ooOol00Woo000HOol20003
Ool8CW<8BU8;CW<2DY@6CW<2BU82AS42@Q02?Nl6=Jd4<H`5=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2
IcT2E[D2BU85AS46BU82AS44?Nl2@Q02AS42BU88AS42BU8`AS4:BU8:AS44BU82@Q02<H`27>L00`aS
12448@0L000G1244Ool20004Ool001Qoo`03001oogoo009oo`Q>L`Q:DP]>L`9BU0I>L`9:DP96<@92
408mk`He[@@aS0De[@8icP@mk`I2409>L`9JeP9S609_N`9W>@9F]@9:DPE6<@I:DP96<@@mk`924096
<@9:DPQ6<@9:DS16<@Y:DPY6<@A:DP92408aS08Li`0336<48@@Q01`001L48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo6Dic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:2bDY12U:0Re[
0Sg_0U:D0V<H16Li0U[F0Tic0TYB14Ha00=>Le:DDY@00U:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha
1TYB<4Ha24YB1THa1TYB0T8@0SF]0R480Q2400<48@0000000P0030@Q3P005`@Q1Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02OolICW<2BU82CW<2BU82AS42@Q02>Lh2=Jd2<H`4;F/6:DX;9BT4:DX2
;F/2?Nl2DY@2HaP4IcT2F]H2CW<2BU84AS400dicDYABU002DY@2AS42>Lh2=Jd2>Lh2@Q02AS44BU84
AS46BU8`AS48BU86AS46BU82@Q02=Jd28@P248@00`@Q00000002000<124>000G1245Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009ooa9>L`=BU09>L`9:DP96<@@mk`8e[@8aS08]J`hYBP<U:@8Q208L
i`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP03IcUS66<H009F]@9240@aS092409:DP96<@a:
DQM6<A9:DPe6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P<48@8000H48@8000848A@001<48@Eoo`03
001oogoo009oo`0067oo00<007ooOol00Woo4Tic0e:D0Tic0TYB0THa13g_0SF]0S6<0Re[3RU:0bDY
0R480QcW21S60R480SW>0U[F0Vmk0W>L0VLi0UJe1U:D0U[F00=W>F<HHaP00UJe0T8@136<0T8@0TYB
0THa34YB5dHa4TYB3DHa14YB14Ha1TYB0THa0SW>0RDY0QBU0PQ20`@Q0P001P@Q0P000P@Q50004`@Q
1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<CW<4DY@3CW<2BU82@Q02?Nl2>Lh2<H`<;F/4
:DX6;F/3:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2HaP00fLiG_MNm`02
DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS45BU84AS46BU84AS46BU82AS42>Lh29BT25:D22483
0008124:00061244000I1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A>L`YBU09>L`96
<@03?Nle[CF]00@aS08]J`8aS0P]J`8aS0@]J`XaS003;F/aS36<00HaS08e[@92409F]@9W>@A_N`9J
eP96<@8mk`9:DP9JeP9Nm`9JeP03E[E:DTYB00I:DPA>Ld1:DPA6<@a:DP96<@8icP8]J`8HaP8<H`84
8@<000H48@X000P48@@001T48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo14ic2U:D0Tic
0THa00<mkcF]=Jd0136<0Re[0S6<22e[0S6<12e[2S6<00<]Jc6<<H`01S6<0SF]0T8@0UJe0VLi16mk
0U[F0THa0Sg_0TYB0U[F0Ukg0U[F00=F]DYBBU801TYB14ic@4YB14Ha34YB0THa0SW>0Re[0QS60PaS
0P@Q0`001P@Q2P0020@Q10006@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8DY@4CW<2
AS42?Nl2=Jd00be[:DXYBP02:DX4;F/:<H`8=Jd;>Lh6?Nl2AS42E[D2HaP2Kg/2JeX2IcT2CW<2?Nl2
=Jd2>Lh2AS44BU800dicBU9:DP0<CW<IBU88CW<YBU82CW<2AS42?Nl2;F/27>L236<=1248000:1244
000I1245Ool00`00Oomoo`02Ool001Qoo`8000=oo`QBU0A>L`96<@8mk`8e[@03;F/YBRU:008YBP@]
J`XaS0Pe[@/icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP03CW=:DTYB00a>
LaU:DPQ>LbU:DP9>L`96<@8mk`8]J`8Li`8<H`d48@P000X48@@001T48@Aoo`8000Aoo`0067oo00<0
07ooOol00Woo15:D0Tic0TYB0T8@0Sg_136<1be[2S6<13F]1SW>1Sg_1D8@1THa0TYB0Tic0U:D0UJe
0U[F0Ukg0V<H0U:D0THa0SW>1SF]0T8@00=>Le:DDY@00U:D0Tic1TYB0Tic0U:D34ic>4YB0THa14YB
0T8@0S6<0R480QBU2@@Q3P009`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4DY@2CW<2
BU82@Q02?Nl4<H`7;F/:<H`4=Jd6>Lh6?Nl5@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42
>Lh6=Jd2@Q000dicDYABU002DY@2CW<6BU82CW<2DY@<CW<hBU82AS44BU82@Q02<H`28@P25:D9124>
000W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`daS0@e
[@8icPHmk`Q240=6<@A:DP9>L`IBU09>L`9BU09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`03AS5>
Ldic02=>LaQ:DP9>L`U:DPA>L`a:DP96<@8e[@8U:@8@Q088@P848A<002T48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3C6<13F]0SW>1Sg_248@0dHa14YB0Tic
1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_00=6<DicCW<08dic64YB0Tic2DYB14ic
34YB0THa0SF]0RDY0Q240PQ20P@Q4`00:@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
?Nl2=Jd2<H`6;F/A<H`2=Jd4>Lh4?Nl4@Q08AS43BU84CW<6DY@:E[D6DY@2CW<2BU82@Q02?Nl00cW>
BU9:DP02CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU85CW<2BU82AS42BU86CW<2?Nl2:DX26<H224821244
000212430002124800081242000Q1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja4aS08e[@@icP@mk`A240Q6<@=:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`03>Li:DTYB
009>L`9BU09F]@ABU1e>La1:DPY>L`A:DPE>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@00084
8@<000848@P000P48@8002448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0S6<1Re[3C6<
13F]0SW>0SF]0SW>13g_148@14Ha24YB1Dic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@00<m
kdHaAS400TYB1U:D>Dic14YB1Dic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P002`@Q1P002P@Q0P008@@Q
1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2<H`6;F/=<H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04
AS48BU85CW<8DY@2E[D2F]H4E[D2DY@4E[D2DY@4CW<2BU82@Q000cg_AS56<@02BU86DY@iCW<4BU85
CW<6BU84CW<2AS42<H`27>L236<21242000;1246000:1242000Q1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`H]Ja4aS08e[@@icP8mk`A240A6<@Q:DPA>L`MBU0iF]@QJeP9F]@ABU09:DP03
AS4mkcg_0096<@9>L`YBU1m>L`9BU1A>L`=:DP9>L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@4
8@<000848@H000X48@8002448@Eoo`03001oogoo009oo`0067oo0P000goo1Re[4C6<0SF]13W>0Sg_
148@14Ha24YB14ic1e:D3UJe25[F0UJe15:D0TYB00=6<Cg_?Nl00THa0Tic2U:D7dic0U:D54ic0dYB
0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q0`000P@Q1P002P@Q0P008@@Q17oo0P0017oo
000HOol00`00Oomoo`02Ool6;F/=<H`2=Jd4>Lh4?Nl4@Q04AS44BU88CW<4DY@9E[D@F]H8E[D3DY@2
AS42@Q02AS42CW<8DY@6CW<:DY@XCW<2BU88CW<2BU82?Nl2;F/26<H22486000K1242000Q1245Ool0
0`00Oomoo`02Ool001Qoo`03001oogoo009oo`H]J`daS08e[@@icP@mk`A240A6<@A:DPQ>L`ABU0UF
]A1JePQF]@=BU096<@924096<@9>L`QBU0I>L`YBU2Q>L`9:DPQ>L`9:DP8mk`8]J`8HaP88@PH001/4
8@8002448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo336<1SF]0cW>13g_148@14Ha1TYB
1Tic1U:D1eJe65[F15Je0e:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Dic0U:D0Tic0THa
0S6<0R480Q240P@Q1P006`@Q0P008@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<<H`6
=Jd3>Lh4?Nl4@Q04AS46BU86CW<6DY@7E[DHF]H4E[D3DY@2BU82AS42@Q02BU82CW<6DY@4CW<<DY@?
CW<2DY@MCW<2DY@2CW<2AS42<H`28@P248@21246000K1242000Q1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`PaS0Pe[@8icPDmk`A24096<@A:DPI>L`QBU0IF]AEJePINm`AJePEF]@9BU09:
DPA2409:DPAF]@iBU0A>L`]BU0A>L`IBU1M>L`ABU09:DP8icP8U:@8@Q0848@P003h48@Eoo`03001o
ogoo009oo`0067oo00<007ooOol00Woo236<23F]0SW>1Cg_148@0THa14YB1Tic25:D1UJe5E[F1Ukg
15[F1EJe0U:D0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D5dic15:D0TYB0SW>0RDY0Q240P@Q2000
?P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6<H`8=Jd2>Lh3?Nl6@Q02AS44BU86CW<6
DY@8E[D;F]HDG_L4F]H5E[D2DY@2AS42@Q02AS42DY@2E[DUDY@ICW<2DY@2CW<2@Q02;F/26<H236<2
124200021244000n1245Ool00`00Oomoo`02Ool000aoo`<0009oo`8000Eoo`03001oogoo009oo`Ha
S0Pe[@8icP<mk`I24096<@A:DPI>L`IBU0QF]@]JeQANm`AJePEF]@9BU096<@924096<@9BU09F]BEB
U1U>L`9BU09>L`92408]J`8HaP8<H`848@8000848@@003h48@Eoo`03001oogoo009oo`003Goo00@0
07ooOol0009oo`03001oogoo009oo`03001oogoo009oo`PaS0@e[@@icP8mk`=240I6<@A:DPI>L`IB
U0QF]@UJePiNm`9S60YNm`9JePEF]@9>L`96<@92409:DQmBU0A>L`ABU1M>L`ABU096<@8e[@8Q208@
Q088@P848@8000848@@003h48@Eoo`03001oogoo009oo`002Woo1@0000Eoo`00Oomoo`0000Aoo`<0
009oo`PaS0@e[@@icP8mk`=240I6<@A:DPI>L`IBU0QF]@UJePiNm`9S60YNm`9JePEF]@9>L`96<@92
409:DQmBU0A>L`ABU1M>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@003h48@=oo`<000Aoo`00
2Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl00d8@AS56
<@06AS44BU84CW<8DY@8E[D5F]H:G_L:HaP:G_L3F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@5
CW<4DY@2CW<2?Nl2:DX25:D22482124400021244000n1245Ool00`00Oomoo`02Ool000]oo`03001o
o`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl00d8@AS56<@06AS44BU84
CW<8DY@8E[D5F]H:G_L:HaP:G_L3F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@5CW<4DY@2CW<2
?Nl2:DX25:D22482124400021244000n1245Ool00`00Oomoo`02Ool000aoo`8000=oo`8000Eoo`03
001oogoo009oo`8aS08e[@@icPPmk`9240E6<@A:DPA>L`IBU0IF]@]JePYNm`iS60YNm`EJeP9F]@9B
U09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`=BU09:DP92408]J`8Li`8<H`848@H000848@@003h48@Eo
o`03001oogoo009oo`0067oo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1DHa14YB14ic1U:D1UJe
2e[F2Ukg3V<H2Ukg1E[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic0e:D0TYB0T8@0Re[0QcW
0PaS0P@Q1P000P@Q1000?P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4
@Q03AS44BU86CW<4DY@8E[D<F]H5G_L2HaP2G_LDHaP9G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2
CW<2BU82CW<3DY@2AS42>Lh28@P25:D22486124200021244000n1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`8e[@HicP@mk`A240=6<@A:DPI>L`ABU0QF]@aJePENm`9S609NmaAS60UNm`9J
ePAF]@9>L`A:DP9>LamBU0Q>L`YBU09>L`9:DP9>L`=BU096<@8icP8Q208DY@88@PH48@8000848@@0
03h48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo13W>13g_148@1THa0dYB1Tic1U:D1UJe
35[F2Ekg66<H1ekg1U[F0U:D1TYB0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D00=F]E:DDY@0
0Sg_0Re[0QS60Q240PQ20P@Q2000@P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4>Lh4
?Nl4@Q06AS43BU86CW<6DY@6E[D<F]H9G_LHHaP7G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4
CW<>DY@4CW<2DY@00eJeDYABU002?Nl2;F/26<H248@22482124800121245Ool00`00Oomoo`02Ool0
01Qoo`8000=oo`8icP@mk`A240I6<@=:DPI>L`QBU0AF]@YJeP]Nm`iS609W>@aS60UNm`9JeP9F]@Q>
LbeBU0I>L`=BU09:DP8aS08Q208DY@8@Q088@P848@H004@48@Aoo`8000Aoo`0067oo00<007ooOol0
0Woo0SW>13g_148@1THa0dYB1Tic25:D15Je2U[F2ekg3V<H0VLi36<H2Ekg0U[F0UJe24ic;E:D1Tic
0e:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00A0@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02
Ool2?Nl6@Q04AS46BU83CW<:DY@4E[D:F]H=G_L>HaP8IcT;HaP4G_L4F]H2DY@6CW<[DY@8CW<2DY@0
0dic?Nlmk`02:DX26<H248@236<4124400161245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`I240A6<@Q:DPE>L`QBU09F]@iJeP]Nmb5S609Nm`IJeP9F]@9>L`A:DP9>LbUBU09>L`9BU09>L`AB
U003BU8e[CF]008Q208DY@8@Q08<H`848@H004H48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo1T8@14Ha24YB1Dic25:D0UJe3U[F2ekg8F<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic
15:D00=:DSF]=Jd00R480QBU0Q240PaS0P@Q1P00AP@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool4@Q06AS48BU83CW<8DY@4E[D>F]H;G_LOHaP4G_L6F]H2E[D2DY@4BU82CW<KDY@2CW<>DY@4
CW<2DY@2CW<00d8@;F/]J`026<H248@436<4124400161245Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`A240I6<@Q:DP=>L`QBU0AF]@iJeP]NmamS60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iB
U0A>L`9BU09>L`03@Q0]Jbe[008HaP8@Q0@<H`@48@@004H48@Eoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo0T8@1THa14YB1dic1U:D25Je35[F3Ekg7f<H1Ukg1U[F0U:D0Tic14YB1Tic5E:D1Tic
2U:D0Tic15:D0Tic00<icRDY9BT00QBU10aS0PQ2CP@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool2@Q06AS44BU87CW<6DY@8E[D<F]H=G_LOHaP6G_L6F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2
CW<4DY@2CW<00cW>9BTU:@025:D436<2249>1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`I6<@I:DPI>L`EBU0QF]@aJeP]Nm`YS609W>A]S60QNm`9F]@9BU0I:DPA>L`9BU0A>L`EBU11>L`AB
U0Q>L`ABU0924003;F/LiacW008@Q0@<H`88@Th48@Eoo`03001oogoo009oo`0067oo0P000goo1THa
1TYB1Tic1E:D25Je35[F2ekg2V<H0VLi6f<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic15:D24ic
15:D0T8@00<]JacW7>L00Q2410aS0PQ2CP@Q17oo0P0017oo000HOol00`00Oomoo`02Ool4AS44BU8:
CW<5DY@6E[D:F]H>G_L9HaP6IcTIHaP8G_L2F]H2DY@2CW<6BU88CW<3DY@NCW<2DY@2BU82=Jd00b48
5:DDY@0448@2248]1242248Q1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A6<@A:DPY>
L`EBU0IF]@YJePiNm`US60IW>AUS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@038@PD
YABU00@@Q088@Rd48@88@R448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0THa24YB0Tic
2E:D15Je3U[F3Ukg2F<H2VLi16<H36Li1f<H15kg0U[F15Je0Tic0TYB0THa14YB24ic00=BU4icCW<0
1Tic0U:D34ic0U:D0Tic0TYB14ic0THa0Re[00<HaQ2448@011240PQ2;`@Q0PQ27`@Q1Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool2AS48BU82CW<9DY@4E[D>F]H>G_L9HaP:IcT4HaP<IcT7HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/0
0aS648@@Q00448@2248_1242248O1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`I:DPI>
L`UBU0AF]@iJePiNm`US60aW>@IS60AW>@]S60ANm`AJeP9F]@9BU09>L`A6<@9:DRM>L`9:DP8mk`8Y
BP035:D@Q12400@<H`88@Rd48@@8@Ql48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo1TYB
1Tic2E:D15Je3U[F3Ukg2F<H36Li1V<H16Li2f<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic0TYB0Sg_
0RU:00<DYA2448@010aS0PQ2;@@Q10Q27`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4
BU88CW<7DY@4E[D>F]H<G_L?HaP:IcTGHaP4G_L4F]H2E[D2CW<4AS42BU8SCW<4DY@2AS42=Jd28@P0
0a2436<<H`0236<4248H1242248?1248248O1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`A:DPQ>L`MBU0AF]@iJePaNm`mS60YW>AMS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q
200348@<H`aS008<H`@8@QP48@88@Pl48@P8@Ql48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo14YB24ic2eJe3U[F35kg2F<H16Li1V<H1VLi5f<H15kg15[F0UJe0U:D0TYB14Ha0TYB7Dic0TYB
0Tic15:D0T8@0RU:0QS60a240PaS10Q25P@Q10Q22`@Q30Q27`@Q1Goo00<007ooOol00Woo000HOol2
0003Ool4BU88CW<;E[D>F]H<G_L9HaP4IcT6HaP6IcTGHaP4G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2
BU82CW<4DY@2@Q02:DX26<H348@236<4248F1244248;124<248O1244Ool20004Ool001Qoo`03001o
ogoo009oo`A:DPI>L`9BU0]F]@iJePaNm`US60IW>@IS60AW>AES60INm`AJeP9F]@9BU09>L`I6<@9:
DQ=>L`9:DPI>L`9:DP9>L`9BU09>L`8icP8Q208HaP035:D@Q124008<H`P8@Q848@@8@PT48A08@Qd4
8@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo14YB1Tic0U:D2eJe3U[F35kg2F<H1VLi1V<H
16Li5F<H1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS600<D
YA2448@00PaS20Q24P@Q10Q22@@Q40Q27@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
BU86CW<4DY@;E[D<F]HBG_L5HaP:IcTKHaP6G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02BU87CW<4BU88
CW<4BU84CW<2BU82CW<2DY@2AS42<H`26<H35:D248@236<8248<124:248512422482124@248M1245
Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`9:DPI>L`ABU0]F]@aJeQ9Nm`ES60YW>A]S60IN
m`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP<D
Y@8@Q08<H`P8@P`48@X8@PD48@88@P848A08@Qd48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo1Tic1U:D2EJe3U[F4Ukg0f<H3VLi6F<H1Ukg15[F15Je0U:D0TYB1THa14YB0dic14YB14ic0TYB
0Tic1TYB24ic0SW>0RDY1ABU0Q242PQ22P@Q9@Q27@@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool6CW<6DY@9E[D>F]HBG_L3HaP>IcTIHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2
BU82CW<6BU88CW<2>Lh29BT55:D248@:248:124U248M1245Ool00`00Oomoo`02Ool000Yoo`<000Ao
o`8000Eoo`03001oogoo009oo`I>L`ABU0]F]@iJePQNm`IS60ANm`=S609W>@9S60YW>AUS60YNm`9J
eP9F]@9BU09>L`I6<AU:DPI>L`9:DP8e[@8Q208@Q08DY@036<H@Q12400@8@P848@@8@PX48@@8@P@<
Had8@QT48@@8@PEoo`03001oogoo009oo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool6CW<4DY@;E[D>F]H8G_L6HaP4G_L3HaP2IcT2HaP:IcTIHaP:G_L2F]H2E[D2DY@2CW<6
AS4IBU86CW<2BU82=Jd28@P248@25:D00aS648@@Q00424821244248:1244248436<M248I12442485
Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`000Woo0Tic2U:D1eJe
45[F3Ukg16<H3fLi6f<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
0aBU0PaS30Q210@Q0PQ21PaS0Q240PaS1@Q21P@Q4PQ26@@Q10Q20goo0`0017oo000:Ool30003Ool0
1000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D1eJe45[F3Ukg16<H3fLi6f<H2Ukg15[F0UJe0Tic
0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q240aBU0PaS30Q210@Q0PQ21PaS0Q240PaS1@Q2
1P@Q4PQ26@@Q10Q21Goo00<007ooOol00Woo000;Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<0
07ooOol00Woo0Tic25:D2EJe45[F3Ukg1F<H3VLi6f<H2Ukg15[F0UJe0U:D0Tic0TYB0THa0T8@0THa
2dYB0THa2TYB0Tic0TYB0SW>0RDY0QBU0PaS0aBU0PaS2PQ21P@Q0PQ20PaS0QcW0QS60QBU0PaS1`Q2
10@Q40Q27`@Q1Goo00<007ooOol00Woo000;Ool30003Ool20005Ool00`00Oomoo`02Ool2CW<8DY@9
E[D@F]H>G_L5HaP>IcTKHaP:G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02AS4;BU82AS4:BU82CW<2BU82
>Lh29BT25:D236<35:D236<:24861242248236<27>L26<H25:D236<72484124@248O1245Ool00`00
Oomoo`02Ool001Qoo`03001oogoo009oo`9>L`IBU0]F]A1JePaNm`IS60mW>A]S60YNm`AJePAF]@9B
U09>L`96<@924096<@]:DP96<@Y:DP9>L`96<@8aS08Li`8@Q08<H`<@Q08<H`H8@PX48@88@P8<H`8Q
208Li`8DY@8<Ha/8@Qd48@88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo0Tic1U:D2eJe
45[F35kg1V<H3fLi6f<H2Ukg15[F15Je0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW
0Q240PaS0a240PaS1PQ22P@Q0PQ20PaS0R480QcW0QBU0PaS6`Q27@@Q0PQ21Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool6DY@<E[D?F]H:G_L8HaPAIcTKHaP:G_L6F]H2E[D2DY@2CW<2BU82AS42
@Q000dHaBU9:DP04BU86AS42BU82AS48BU82?Nl2;F/26<H248@236<25:D00a2436<<H`02248>1242
36<248@46<H25:D236<K248K12442485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IBU0aF
]@mJePYNm`QS615W>A]S60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB00A:DPI6<@9:DP96
<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@0348@<H`aS0088@Ph48@8<H`8@Q0@HaP8DY@8<Ha/8@Q/48@@8
@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U:D25Je4e[F2Ukg2V<H3fLi7F<H25kg1U[F
0UJe15:D0TYB0THa0d8@4THa1TYB0SW>0RDY0QBU0PaS0Q240QBU00<@Q0aS36<00PQ230@Q10Q220aS
5`Q20PaS10Q26@@Q1PQ21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6DY@8E[DCF]H:G_L:
HaP?IcTMHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT25:D236<248@25:D00a2436<<
H`02248<1244248836<G248236<4248I12462485Ool00`00Oomoo`02Ool001Qoo`8000=oo`ABU0QF
]AEJePiNm`US619W>AMS60QNm`IJeP9F]@ABU09>L`9:DPM240i6<@A:DP96<@8e[@8Q208@Q0@<H`8@
Q00336<8@PQ20088@Ph48Al8@P@<H`@8@QT48@H8@PAoo`8000Aoo`0067oo00<007ooOol00Woo15:D
25Je4e[F45kg2F<H4VLi6f<H15kg0U[F0Ukg0U[F1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB
0THa0T8@0S6<0QcW0Q241PaS1@Q22P@Q0PQ210@Q1PQ210@Q4`Q210aS1PQ20P@Q10Q21`@Q40Q21Goo
00<007ooOol00Woo000HOol00`00Oomoo`02Ool4DY@8E[DCF]H@G_L9HaPBIcTKHaP4G_L2F]H2G_L2
F]H6E[D2DY@2BU82AS400d8@?Nlmk`04@Q0<AS42BU82AS42@Q02<H`27>L248@636<5248:12422484
12462484124C248436<6248212442487124@2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`ABU0QF]A=JePaNm`YS60EW>@AS60iW>AUS60ANm`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_
00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@Q08<H`0324848@@Q00`48@`8@P@48@D8@P848@`8
@P@<H`H8@P848@@8@PL48A08@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15:D25Je4e[F
35kg2V<H1FLi16<H3VLi6F<H15kg0U[F15kg0U[F15Je0U:D0TYB0THa00=243g_?Nl01T8@1THa0T8@
0THa0TYB0THa0Sg_0Re[0QS61Q240PaS00<8@P@Q124030@Q30Q210@Q1@Q20P@Q30Q210aS1PQ20P@Q
10Q21`@Q40Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<E[D?F]H@G_L8HaP3IcT8HaP2
IcT6HaP6IcTCHaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT2
6<H648@236<E12422484124E248436<:248212462485124>2485Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`aF]@mJeQ1Nm`QS60=W>@QS609W>@IS60IW>A=S60iNm`IJeP9F]@9BU0A>L`03AS4m
kcg_008mk`I240A6<@A2409:DP96<@8e[@8U:@8HaPH@Q08<HaD48@88@P@48AD8@P@<H`X8@P848@H8
@PD48@h8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo2UJe4E[F45kg2V<H00=W>F<HHaP0
1V<H0VLi1V<H1VLi4f<H15kg0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@
0SF]0RDY0QS60QBU0Q240PaS0PQ24`@Q10Q210@Q5@Q210aS2PQ20P@Q1PQ20`@Q40Q21Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool:E[DAF]H@G_L:HaP00fLiHaQS6006HaP2IcT6HaP6IcTCHaP4
G_L2HaP8G_L6F]H4E[D2DY@2CW<00dYB@Q124008@Q04AS44@Q02AS42@Q02=Jd29BT26<H25:D248@2
36<2248C12442484124E248436<:248212462483124@2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`QF]A=JeQ1Nma=S609W>@IS60IW>@eS609Nm`IS609Nm`AS60INm`QJeP9F]@ABU003BU96
<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88@Q<48Ad8@P@<H`X8@P84
8@H8@P031248@PQ20108@PEoo`03001oogoo009oo`0067oo0P000goo25Je4e[F45kg4f<H0VLi1V<H
1VLi3F<H0Ukg1V<H0Ukg16<H1Ukg25[F0UJe15:D00=:DTHaAS40148@0Sg_0T8@0THa1T8@0THa0T8@
0S6<0R480QS60QBU0Q240PaS0PQ24`@Q7@Q210aS2PQ20P@Q1PQ200<48@Q2248040Q217oo0P0017oo
000HOol00`00Oomoo`02Ool8E[DCF]H@G_L?HaP6IcT8HaP2IcT?HaP2G_L<HaP6G_L8F]H4E[D2DY@0
0dicBU9:DP02AS42@Q02?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248C124O248436<:2482124I
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`QF]A=JeQ1Nm`mS60IW>@QS609W>@mS609N
m`aS60INm`QJePAF]@9BU003CW=:DTYB0096<@92408mk`Y24096<@8mk`8]J`8Q208HaP8DY@8@Q088
@Q<48Al8@P@<H`X8@P848AT8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo25Je4e[F3Ukg
3F<H2VLi6F<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa0T8@13g_2T8@0SW>0RU:0QcW0QS6
0Q240PaS5@@Q7`Q210aS2PQ20P@Q6@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8E[DC
F]H>G_L=HaP:IcTIHaP2G_L<HaP4G_L:F]H4E[D2DY@00dicBU9:DP02AS42@Q04?Nl:@Q02>Lh2:DX2
7>L26<H248@236<E124O248436<:2482124I2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`QF]A=JePaNm`iS60]W>@9S60AW>A=S609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2408e
[@8U:@8HaP8DY@8<H`88@Q<48B48@P@<HbD8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo
25Je4e[F35kg3V<H2fLi0V<H16Li4f<H0Ukg36<H15kg2U[F15Je0U:D0dic0TYB0T8@13g_2T8@0SF]
0RDY0QS60QBU0PaS0PQ24`@Q8@Q210aS9@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8
E[D?F]H>G_L>HaP=IcT2HaP4IcTCHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06?Nl4
@Q02?Nl2<H`28@P45:D236<2248912422484124U248236<W2485Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`QF]@mJePiNm`iS60eW>@9S60AW>A=S609Nm`aS60INm`QJePIF]@03DYA>Ldic009:
DP96<@9240Hmk`A2408mk`8aS08Q20@DY@8<H`88@PT48@88@P@48BD8@P8<HbL8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo0UJe4e[F45kg3V<H4fLi4V<H0ekg36<H1Ukg2U[F15Je0e:D0Tic
0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU0Q240PaS0PQ22@@Q0PQ20P@Q9`Q20PaS9`Q21Goo00<007oo
Ool00Woo000HOol20003Ool2E[DCF]H@G_L>HaPCIcTBHaP3G_L<HaP6G_L:F]H4E[D3DY@2CW<2BU82
@Q08?Nl2@Q02?Nl2;F/27>L25:D248@236<2248912422482124W248236<W2484Ool20004Ool001Qo
o`03001oogoo009oo`AF]@mJeQ9Nm`iS60mW>AAS60=Nm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PL48@88@PX48@P8@P848A<8@PP<Hb<8
@P8<H`88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15Je3e[F4Ukg3V<H3fLi56<H0ekg
2V<H0VLi0V<H0Ukg0V<H15kg25[F1EJe0U:D0Tic14YB0T8@0SW>13g_0T8@0Sg_0RU:0QS60Q240PaS
0PQ21`@Q0PQ22P@Q20Q20P@Q4`Q220aS8`Q20PaS0PQ21Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool2E[D@F]HAG_LBHaP;IcTFHaP3G_L>HaP8G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02
>Lh2:DX26<H248@236<224871244248812482482124E248636<W2485Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`9F]A1JeQ5Nma9S60]W>AIS60=Nm`iS60QNm`QJePEF]@9BU0A>L`9:DP92408i
cP@mk`92408icP8YBP8HaP8@Q08<H`88@PL48@@8@PP48@P8@P848AD8@PH<HbL8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo0UJe3U[F4ekg4f<H26Li6V<H00=Nmf<HHaP036<H25kg2U[F0eJe
15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ21`@Q10Q220@Q20Q20P@Q5@Q21PaS
9@Q20PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2E[D>F]HCG_LCHaP8IcTJHaP00ekg
HaQS600<HaP8G_L:F]H3E[D4DY@2CW<2BU82AS42?Nl2>Lh4?Nl2>Lh29BT25:D248@236<224871244
248812482482124E248636<U248236<5Ool00`00Oomoo`02Ool000]oo`8000Aoo`8000Eoo`03001o
ogoo009oo`9F]@iJeQ=NmaES60IW>BUS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8D
Y@@<H`T48@H8@PH48@P8@P848AD8@PH<HbD8@P8<H`Eoo`03001oogoo009oo`002Woo00@007ooOol0
009oo`04001oogoo0004Ool00`00Oomoo`02Ool2E[D>F]HCG_LEHaP6IcTYHaP8G_L:F]H5E[D2DY@4
CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<91246248612482482124E248636<U248236<5Ool00`00
Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`000Woo45[F5Ekg4F<H26Li:F<H
2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2@@Q1PQ21P@Q20Q20P@Q5@Q21PaS9`Q2
0goo0`0017oo000;Ool20003Ool01000Oomoo`0017oo00<007ooOol00Woo45[F5Ekg4F<H26Li:F<H
2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2@@Q1PQ21P@Q20Q20P@Q5@Q21PaS9`Q2
1Goo00<007ooOol00Woo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009ooa9J
eQ=Nma1S60UW>B]S60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8icP8e[@8aS08Q208DY@8<H`88@QD4
8@P8@P848AD8@PH<HbD8@P8<H`Eoo`03001oogoo009oo`002goo0P0017oo0P001Goo00<007ooOol0
0Woo4U[F4ekg46<H2FLi:f<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU0PaS
0PQ25@@Q20Q20P@Q5@Q21PaS9@Q20PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolBF]H9
G_L2HaP8G_L<HaP?IcTYHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P25:D236<2248E
12482482124C248836<W2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa9JePUNm`9S60QN
m`aS60mW>BUS60aNm`MJeP9F]@IBU09>L`9:DP92408icP8e[@8]J`8Q208DY@8<H`88@QD48@P8@P84
8A<8@PP<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo4U[F2Ekg16<H1Ukg2V<H4fLi
9f<H3Ukg1E[F0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS5`@Q20Q20P@Q4`Q220aS9`Q21Goo
00<007ooOol00Woo000HOol00`00Oomoo`02Ool@F]H?G_L4HaP2G_L:HaP?IcTDHaP4IcT2HaP5G_L<
HaP<G_L9F]H4E[D2DY@4CW<2BU82@Q02=Jd2:DX27>L248@236<?2482124:2486124?248:36<U2482
12422485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1JePmNm`AS609Nm`YS60mW>AAS60AW
>@9S60ENm`aS60aNm`UJePAF]@9BU0A>L`9:DP92408e[@8YBP8Li`8@Q08<H`l8@P848@X8@PH48@l8
@PX<HbD8@P848@88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo45[F3ekg2V<H0VLi16<H
3fLi56<H0VLi16<H0ekg3V<H35kg2E[F15Je0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q
:0Q240aS8`Q21Goo00<007ooOol00Woo000HOol20003Ool@F]H?G_L:HaP2IcT4HaP?IcTDHaP2IcT4
HaP3G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2:DX27>L248@236<22486124X248@36<S2484
Ool20004Ool001Qoo`03001oogoo009ooa1JePmNm`YS609W>@9S60mW>AaS60=Nm`iS60iNm`MJePAF
]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BD8@Q4<HbD8@PEoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo45[F3ekg2V<H0VLi0V<H3fLi76<H0ekg3V<H3Ukg1e[F15Je0U:D14ic14YB0Sg_0Re[
0QcW0Q2410Q21P@Q9@Q24@aS9@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool@F]H?G_L8
HaP4IcT2HaP?IcTLHaP3G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`27>L248@42482124Z248@
36<U2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1JePmNm`QS60AW>@9S60mW>AaS60=N
ma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848BX8@Q0<HbD8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo3U[F4Ekg1V<H1VLi16<H3fLi1V<H0VLi4V<H0ekg46<H35kg1e[F
1UJe0U:D1Tic0THa0SF]0R480Q244@Q20P@Q7@Q20PaS0PQ230aS9@Q21Goo00<007ooOol00Woo000H
Ool00`00Oomoo`02Ool>F]HAG_L6HaP6IcT4HaP?IcT6HaP2IcTBHaP3G_L@HaP<G_L7F]H6E[D2DY@6
CW<2AS42=Jd28@P248@A2482124M248236<2248<36<U2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`iJePeNm`YS60IW>@9S61]W>A1S60=Nm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8m
k`8YBP8@Q0l8@P@48Ad8@Ph<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo3U[F3Ekg
2V<H1VLi0V<H6fLi46<H0ekg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q243`Q210@Q
7@Q23PaS9`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool>F]H=G_L8HaP6IcT2HaPMIcTG
HaP4G_L:HaP>G_L7F]H4E[D4DY@4CW<2AS42<H`25:DA2482124L248536<648@836<S2485Ool00`00
Oomoo`02Ool001Qoo`8000=oo`iJePeNm`QS60IW>@9S61eW>AMS60ANm`YS60iNm`MJePAF]@ABU0A>
L`96<@8aS08DYA48@P848A`8@PD<H`H@Q0P<Hb<8@PAoo`8000Aoo`0067oo00<007ooOol00Woo3U[F
3Ekg26<H1VLi0V<H7fLi5F<H15kg2V<H3Ukg2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:@Q2
1`aS0Q2411BU0Q241PaS7`Q20PaS0PQ21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool>F]H=
G_L8HaP6IcT2HaPOIcTEHaP4G_L:HaP>G_L9F]H2E[D2DY@2E[D4CW<2BU82>Lh26<H2248236<Y2487
36<248@45:D248@636<O248236<22485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJeQEN
m`YS62EW>B=S60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2148@P848Ad8@P8<H`8@Q0@HaP8DY@8@
Q08<H`88@P8<Hb<8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U[F5Ekg2V<H9FLi8f<H
3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484@Q20P@Q7@Q20PaS0Q2411S60QBU0Q240PaS0PQ20PaS
8`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6F]HEG_L6HaPYIcTEHaP4G_L:HaP2G_L4
HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@?2482124M248236<248@46<H25:D248@636<S
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJeQENm`IS62UW>AES60ANm`YS609Nm`AS
60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q0l8@P848Ad8@P8<H`8@Q0@HaP8DY@8@Q0H<Hb<8
@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U[F5Ekg1V<H:FLi5F<H15kg1V<H15kg26<H
1ekg25[F15Je25:D0THa0Re[0QBU1PQ20PaS9@Q20`aS0QBU12480QBU0Q2410aS9@Q21Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool6F]HEG_L6HaPYIcTEHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8
DY@2AS42;F/25:D6248236<U248336<25:D48@P25:D248@436<U2485Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`IJeQENm`AS62]W>AES60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8H
aPH8@P8<HbD8@P<<H`8HaP@]J`8Li`8@Q0@<HbD8@PEoo`03001oogoo009oo`0067oo0P000goo1U[F
5Ekg16<H:fLi5F<H15kg1V<H15kg26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9@Q20`aS0QS6
12e[0QcW0Q2410aS9@Q217oo0P0017oo000HOol00`00Oomoo`02Ool6F]H=G_L<HaPBIcT4JeXCIcTG
HaP4G_L8HaP6G_L4HaP7G_L8F]H4E[D8DY@2BU82>Lh28@P6248236<I248436<8248336<28@P4=Jd2
8@P248@236<W2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJePeNm`aS619W>@A[FQ=W
>AMS60ANm`QS60INm`AS60MNm`QJePAF]@QBU09:DP8icP8Q20H8@P8<HaT8@P@<H`P8@P<<H`8Q20@e
[@8Q208@Q08<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15[F3Ukg2f<H36Li0V]J
16Li2f]J46Li8f<H15kg26<H0ekg2U[F15Je1U:D0Tic0T8@0RU:0PaS10Q210aS5`Q21PaS1PQ20`aS
0R4813F]0R480Q240PaS2PQ20P@Q6`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4F]H>
G_L;HaP<IcT2JeX4IcT;JeX@IcTSHaP4G_L8HaP3G_L:F]H4E[D6DY@2CW<2@Q02:DX236<4248436<G
248636<6248336<28@P4=Jd28@P248@236<:2482124K2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009ooa1Nm`]S60aW>A=[FQ1W>C5S60=Nm`aJePIBU09>L`96<@8]J`8DY@@8@P8<HaT8@P@<H`P8
@P<<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A/8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo
45kg2f<H36Li4f]J46Li<F<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6@Q210aS20Q20`aS0QcW
12e[0QcW0Q241PaS10Q210@Q6`Q21Goo00<007ooOol00Woo0004Ool50002Ool20004Ool20005Ool0
0`00Oomoo`02Ool@G_L;HaP<IcTCJeX@IcTWHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D42484
36<E248236<<248336<26<H49BT25:D248@636<42484124K2485Ool00`00Oomoo`02Ool000Ioo`05
001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo45kg2f<H36Li
4f]J46Li9f<H16Li1V<H0ekg35[F1U:D0Tic0TYB0SF]0QBU10Q210aS5@Q20PaS30Q20`aS0QS612DY
0QBU0Q241PaS10Q210@Q6`Q21Goo00<007ooOol00Woo0006Ool01@00Oomoogoo00000Woo00@007oo
Ool0009oo`03001oogoo009oo`<0009ooa9Nm`ES611W>@m[FPAW>@9[FPiW>B=S60ANm`9S60A[FPAS
6003G_MJeU[F00ANm`QJeP9F]@9BU09F]@9BU09:DP8icP8HaP8<H`88@P@<HaD8@P@<H`P8@P<<H`8@
Q08HaP@Li`8DY@@@Q08<HbD8@P=oo`<000Aoo`001Woo00D007ooOomoo`00009oo`04001oogoo0002
Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L5HaP@IcT?JeX4IcT2JeX>IcTSHaP4G_L2HaP4JeX4
HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H236<2248436<E248436<8248336<2
48@26<H47>L25:D448@236<U2485Ool00`00Oomoo`02Ool000Ioo`05001oogooOol00002Ool01000
Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo0Ukg0U[F3Ukg1F<H3VLi5f]J3VLi9F<H0Ukg
0V<H16]J0VLi0V<H1ekg25[F0UJe0U:D0UJe0U:D0TYB0Sg_0QcW0PaS0PQ210aS5@Q210aS10Q20PaS
0PQ20`aS0Q240QBU11S60QBU0Q2410aS9@Q21Goo00<007ooOol00Woo0005Ool20004Ool20004Ool2
0005Ool00`00Oomoo`02Ool4F]H<G_L7HaP<IcTIJeX>IcTUHaP2G_L2HaP2IcT4JeX2HaP7G_L8F]H2
E[D2DY@2E[D2DY@2CW<2@Q029BT236<2248436<E248436<4248236<2248336<448@45:D248@636<U
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`AJePaNm`MS60aW>AU[FPiW>BES609Nm`9S
609W>@A[FP9S60MNm`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaD8@P@<H`@8@P8<H`88
@P<<H`@@Q0@DY@8@Q0H<HbD8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo0U[F3Ukg1f<H
36Li6f]J46Li9F<H0VLi16]J0f<H1Ukg25[F0UJe0U:D0UJe0U:D0Tic0THa0RU:0Q240PQ210aS00<8
@PaS36<06PQ20PaS10Q200<<Ha2448@00Q2411BU0Q241PaS9@Q21Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool2F]H>G_L7HaP<IcTKJeX@IcTUHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2
CW<2AS42:DX248@2248436<00`Q236<<H`0J248236<424800`aS48@@Q00248@45:D248@636<U2485
Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1Nm`ES60aW>A1[FP9_N`][FQ1W>A]S609Nm`YS
60AW>@=S60INm`YJePAF]@9BU09>L`96<@8]J`8DY@88@P@<H`03248<H`aS00@8@P8<Ha@8@P@<H`88
@P<<H`P@Q0P<H`@8@PP48AL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo45kg1F<H36Li
46]J0Vmk2f]J46Li6f<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS00<8
@PaS36<010Q20PaS50Q210aS0PQ20`aS212420aS10Q220@Q5`Q21Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool@G_L3HaP>IcT6JeX4Kg/4JeX6Kg/9JeXBIcT8HaP00fLiHaQS600QHaP6G_L4F]H2
G_L4F]H4E[D2DY@2CW<2BU82<H`26<H2248436<00`Q236<<H`04248236<D248436<2248336<648@6
36<8248812442489124:2485Ool00`00Oomoo`02Ool001Qoo`8000=ooa1Nm`=S60iW>@I[FPA_N`A[
FPI_N`U[FQ9W>@QS6003IcUS66<H025S60INm`AJeP9Nm`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<
H`03248<H`aS00@8@P8<Ha@8@P@<H`88@P<<H`H@Q0H<H`P8@PP48@@8@PT48@X8@PAoo`8000Aoo`00
67oo00<007ooOol00Woo3Ukg1F<H36Li16]J4Vmk2F]J6fLi8f<H1Ukg15[F0Ukg15[F15Je15:D0Tic
0SF]0QS61PaS00<8@PaS36<06PQ210aS0PQ23`aS20Q220@Q10Q22`@Q20Q21Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool>G_L5HaP<IcT4JeXBKg/9JeXKIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2
CW<2=Jd26<H636<00`Q236<<H`0J248436<2248?36<824881244248;12482485Ool00`00Oomoo`02
Ool001Qoo`03001oogoo009oo`iNm`ES60YW>@I[FQ=_N`Q[FQ]W>AAS60ANm`eS60ANm`AJeP9Nm`QJ
ePABU09>L`8icP8HaP8<H`88@PD<Ha88@P8<H`H8@P@<H`88@Pl<H`P8@PP48@@8@P/48@P8@PEoo`03
001oogoo009oo`0067oo00<007ooOol00Woo3Ukg1F<H2VLi1V]J4fmk26]J6fLi56<H15kg3F<H15kg
15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21@aS4PQ20PaS1PQ210aS0PQ23`aS20Q220@Q10Q22`@Q
20Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool:G_L8HaP9IcT6JeX6Kg/6Li`8Kg/9JeX@
IcT`HaP4G_L6F]H2G_L4F]H4E[D2DY@2BU82?Nl28@P736<2248236<<248636<:248A36<6248>1247
248812442485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`YNm`QS60UW>@I[FPI_N`IcW0Q_
N`U[FQ1W>C1S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20L<H`88@P8<H``8@PH<H`X8@Q4<H`H8
@Ph48@L8@PP48@@8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo2Ukg1V<H2fLi1V]J16mk
2W>L0Vmk0W>L0fmk2V]J3VLi<6<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0T8@0R481`aS0PQ20PaS40Q2
0PaS2PQ24`aS10Q24@@Q0PQ22P@Q10Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool:G_L6
HaP;IcT6JeX4Kg/:Li`2Kg/2Li`3Kg/:JeX>IcT`HaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P7
36<2248236<@248236<:248C36<4248A1242248:12442485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`QNm`QS60UW>@I[FPA_Na9cW003Kg][FV]J009_N`I[FPiW>C1S60YNm`IJePIF]@9>L`92
408U:@/<Ha`8@Q<<H`88@Ql48@@8@PEoo`03001oogoo009oo`0067oo0P000goo25kg26<H2FLi1V]J
16mk4W>L00=_Nf]JJeX00Vmk1V]J3VLi<6<H2Ukg1U[F1UJe0Tic0T8@0RDY2`aS70Q24`aS0PQ27`@Q
10Q217oo0P0017oo000HOol00`00Oomoo`02Ool8G_L6HaP9IcT6JeX4Kg/6Li`6Mkd6Li`7Kg/6JeX@
IcT^HaP:G_L8F]H4E[D2CW<2AS42:DX248@936<B248236<8248A36<4248O12442485Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oo`QNm`IS60UW>@I[FPA_N`IcW0Ig_@IcW0M_N`I[FQ1W>BiS60YN
m`QJePAF]@9>L`96<@8YBP8@Q0T<Ha88@P8<H`P8@Q4<H`@8@Ql48@@8@PEoo`03001oogoo009oo`00
67oo00<007ooOol00Woo1Ukg26<H1fLi26]J16mk17>L27Nm1W>L0fmk0V]J0Vmk16]J4VLi26<H00=W
>F<HHaP016<H0VLi7F<H35kg1U[F15Je0Tic0THa0RU:0Q240PaS0PQ21@aS4PQ20PaS20Q21@aS10Q2
1PaS1PQ28`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6G_L8HaP7IcT8JeX4Kg/4Li`8
Mkd6Li`3Kg/2JeX2Kg/4JeXBIcT8HaP00fLiHaQS6004HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX2
48@236<2248536<B248236<8248536<4248636<6248S1245Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`INm`IS60UW>@A[FPI_N`9cW0ig_@AcW0=_N`9[FP9_N`A[FQAW>@AS60=W>B1S609W>@=S
60aNm`IJePAF]@9BU096<@8YBP8@Q08<H`88@PD<Ha88@P8<H`P8@Q4<H`@8@R<48@Eoo`03001oogoo
009oo`0067oo00<007ooOol00Woo1Ukg1V<H2FLi16]J1Vmk0W>L3WNm17>L0fmk0V]J0Vmk16]J56Li
16<H0fLi86<H0VLi0f<H35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21@aS4PQ20PaS20Q24@aS10Q2
8`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6G_L4HaP9IcT6JeX4Kg/4Li`2Mkd:Nmh2
Mkd6Li`00fmkJeY[FP02Kg/6JeXIIcT@HaP2IcT>HaP2IcT00f<HG_MNm`0<G_L2F]H2G_L2F]H4E[D2
DY@2AS42:DX248@236<2248536<B248236<8248A36<4248S1245Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`INm`AS60UW>@I[FPA_N`AcW09g_@YkgP9g_@IcW003Kg][FV]J009_N`I[FQUW>A1S
609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88@PD<Ha88@P8<
H`P8@Q4<H`@8@R<48@Eoo`03001oogoo009oo`0067oo0P000goo1Ukg16<H2FLi16]J16mk17>L17Nm
2W_N17Nm17>L1Fmk1V]J6fLi3V<H0VLi4F<H3Ukg0U[F0Ukg0U[F15Je0U:D0TYB0RU:0PaS0PQ20P@Q
1@aS1PQ20PaS2PQ20PaS20Q24@aS10Q28`@Q17oo0P0017oo000HOol00`00Oomoo`02Ool6G_L4HaP9
IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`5Kg/6JeXKIcT>HaP2IcTAHaP>G_L2F]H2G_L2F]H4E[D2DY@2
BU82:DX236<22482124536<6248236<:248236<8248A36<4248S1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`aS60IW>@E[FP9_N`AcW0Ag_@AkgPIoo`AkgP9g_@AcW0=_N`I[FQ]W>B=S60iN
m`IJePAF]@9BU096<@8YBP8@Q0848@L8@PX<H``8@PH<H`D8@P`<H`@8@R<48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo36<H1VLi1F]J0Vmk17>L17Nm17_N1Woo17_N0WNm17>L0fmk1V]J6fLi
8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q1`Q22PaS30Q21PaS1@Q230aS10Q28`@Q1Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool<HaP6IcT3JeX4Kg/2Li`4Mkd4Nmh8Ool4Nmh2Mkd4Li`3Kg/6
JeXKIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@224821245248:36<U248U1245Ool00`00Oomoo`02
Ool001Qoo`03001oogoo009oo`aS60IW>@=[FPA_N`9cW0Ag_@AkgPQoo`AkgP9g_@AcW0=_N`I[FQ]W
>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@D8@PX<HbD8@RD48@Eoo`03001oogoo009oo`00
67oo00<007ooOol00Woo36<H16Li1F]J0Vmk17>L0WNm17_N2Woo17_N0WNm17>L1Fmk16]J7fLi2V<H
0VLi4f<H3Ukg1U[F15Je0U:D0THa0Re[0QBU0PQ20`@Q20Q21PaS9@Q29@@Q1Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool<HaP4IcT5JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`5Kg/4JeXOIcT:
HaP2IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224831248248636<U248U1245Ool00`00Oomoo`02
Ool000Aoo`D00003Ool00000008000=oo`8000Eoo`03001oogoo009oo`QS60QW>@=[FPA_N`9cW09g
_@AkgPioo`9kgP9g_@AcW0E_N`A[FR5W>AmS60aNm`IJePAF]@9BU096<@8]J`8DY@88@P<48@88@P84
8@H8@P@<Hal8@P8<H`@8@RD48@Eoo`03001oogoo009oo`001Woo00D007ooOomoo`0000Eoo`04001o
ogoo0004Ool00`00Oomoo`02Ool6HaP8IcT5JeX2Kg/4Li`2Mkd2Nmh@Ool2Nmh4Mkd2Li`5Kg/4JeXO
IcTQHaP:G_L8F]H4E[D2DY@2AS42;F/25:D236<224800`@Q2488@P0212422482124M248236<62482
36<4248U1245Ool00`00Oomoo`02Ool000Ioo`03001oogoo009oo`03001oogoo009oo`04001oogoo
0004Ool30002Ool6HaP8IcT5JeX2Kg/4Li`2Mkd2Nmh@Ool2Nmh4Mkd2Li`5Kg/4JeXOIcTQHaP:G_L8
F]H4E[D2DY@2AS42;F/25:D236<224800`@Q2488@P0212422482124M248236<6248236<4248U1243
Ool30004Ool000Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool4HaP8IcT6JeX3Kg/2Li`2Mkd2NmhBOol4Nmh2Mkd2Li`5Kg/6JeXIIcTWHaP8G_L8F]H4E[D2
DY@2BU82<H`26<H236<224800`@Q2488@P0212422484124W248W1245Ool00`00Oomoo`02Ool000Io
o`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li
1V]J0fmk0W>L0WNm0W_N4Woo17_N0WNm0W>L1Fmk1V]J6FLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS6
0PaS0PQ200<48@Q224800P@Q0PQ210@Q9`Q29`@Q1Goo00<007ooOol00Woo0005Ool20004Ool20004
Ool20005Ool00`00Oomoo`02Ool4HaP6IcT6JeX3Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`5Kg/6JeXK
IcT:HaP4IcT>HaP2G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@224800`@Q2488@P02
1242248412422482124@248436<?248W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`AS
60IW>@I[FP=_N`9cW0Ag_@9kgQAoo`9kgP9g_@9cW0E_N`I[FQ]W>@YS60AW>@iS609Nm`=S609Nm`AS
60INm`QJePAF]@9BU09:DP8e[@8Q208@Q088@P031248@PQ200848@88@P@48@88@P848A08@P@<H`l8
@RL48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0V<H1VLi1V]J16mk0g>L0WNm17_N57oo
0W_N0WNm0W>L1Fmk1V]J:FLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY0QBU0PQ200<48@Q2
248010Q210@Q0PQ220@Q2PQ21`aS30Q29`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
HaP6IcT6JeX4Kg/3Li`2Mkd4NmhDOol2Nmh2Mkd2Li`5Kg/6JeXYIcT>HaP7G_L4HaP6G_L8F]H4E[D2
DY@2BU82?Nl29BT25:D224800`@Q2488@P04248412422488124:248736<<248W1245Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oo`QW>@Q[FP9_N`03Liag_GNm009g_@AkgQ9oo`AkgP9g_@9cW003
Kg][FV]J009_N`Q[FR5W>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`D8@P@48@88@PX48@H8
@P@<H`D8@P8<H`@8@P8<H`H8@RL48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo26Li26]J
0Vmk00=cW7NmMkd00WNm17_N4Woo17_N0WNm0W>L00=_Nf]JJeX00Vmk26]J8FLi66<H3Ekg25[F15Je
0Tic0THa0T8@0S6<0QcW0PaS1@Q210@Q0PQ22P@Q1PQ210aS1@Q20PaS10Q20PaS1PQ29`@Q1Goo00<0
07ooOol00Woo000HOol00`00Oomoo`02Ool8IcT6JeX4Kg/00g>LMkeg_@04NmhDOol2Nmh4Mkd2Li`0
0fmkJeY[FP04Kg/8JeXOIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D5248@124E248236<6
248W1245Ool00`00Oomoo`02Ool001Qoo`8000=oo`QW>@I[FPA_N`03Liag_GNm00AkgQAoo`9kgPAg
_@9cW003Kg][FV]J00A_N`Q[FQmW>AQS60eNm`QJeP9F]@9BU09>L`A6<@8icP8U:@8DY@D8@Q048AD8
@P8<H`H8@RL48@Aoo`8000Aoo`0067oo00<007ooOol00Woo26Li16]J1Vmk00=cW7NmMkd017_N57oo
0W_N17Nm0W>L00=_Nf]JJeX016mk3V]J0VLi16]J4fLi66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha
0Sg_0S6<0QcW00<<H`Q224800PQ250@Q4@Q20PaS1PQ29`@Q1Goo00<007ooOol00Woo000HOol00`00
Oomoo`02Ool8IcT4JeX6Kg/00g>LMkeg_@04NmhDOol2Nmh4Mkd2Li`00fmkJeY[FP04Kg/>JeX2IcT4
JeXCIcTHHaP=G_L2F]H2G_L4F]H2E[D2DY@2CW<4AS42?Nl2<H`27>L00`aS2488@P02248D124A2482
36<6248W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IW>@I[FPA_N`=cW09g_@AkgQAo
o`9kgPAg_@9cW0M_NaI[FQ5W>@QS60AW>@eS60aNm`9JePANm`9JeP9F]@9BU09:DP96<@A2408icP8U
:@0348@8@PQ20088@QH48@/8@PH<H`@8@RT48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo
1VLi1V]J16mk0g>L0WNm17_N57oo0W_N17Nm0W>L1fmk5V]J4FLi26<H16Li3F<H35kg0U[F15kg0U[F
0UJe0U:D0TYB0THa148@0SW>0RDY00<@Q0Q224800PQ25P@Q2`Q21PaS10Q2:@@Q1Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02Ool6IcT6JeX4Kg/3Li`2Mkd2NmhDOol4Nmh4Mkd2Li`5Kg/8JeX8IcT8
JeXAIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`00aS636<<H`04
248J124?248Y1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IW>@I[FPA_N`=cW09g_@9k
gQAoo`AkgPAg_@9cW0E_N`Q[FPQW>@Q[FQ5W>@QS60AW>@eS60aNm`9JePANm`9JeP9F]@9BU09:DP96
<@8mk`96<@92408aS0036<H<H`aS00@8@QX48@l8@RT48@Eoo`03001oogoo009oo`0067oo00<007oo
Ool0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03
001oogoo02Aoo`03001oogoo02=oo`03001oogoo019oo`03001oogoo009oo`0067oo0P000goo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol01goo0P0017oo000HOooo00050004Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo0028Ool3002EOol008Uoo`03001oogoo09Aoo`00Mgoo0`000goo1`0000Eoo`00Ool0
07oo00<000=oo`<000Aoo`<000Moo`<000=oo`<00003Ool00000009oo`8000Aoo`8000Aoo`8006Ao
o`00Mgoo00@007ooOol0009oo`@0009oo`07001oo`00Ool007oo00000Woo00D007ooOomoo`0000Ao
o`03001oogoo00Uoo`03001oogoo00=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`04001oogoo001SOol007Yoo`03001oogoo00=oo`0:001oogoo001oo`00Ool007oo0002Ool0
1@00Oomoogoo000017oo100027oo0`000goo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomo
o`03Ool01000Oomoo`00Hgoo001hOol20004Ool300001goo00000000Ool007oo00@000Aoo`03001o
ogoo00=oo`8000Uoo`04001oogoo0002Ool30004Ool20002Ool50003Ool2001TOol007Moo`04001o
ogoo000EOol00`00Oomoo`0>Ool01000Oomoo`000Woo00<007ooOol02Goo00<007ooOol0JWoo001g
Ool4000DOol2000?Ool40002Ool2001hOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.1932, -8.85118, 0.514055, \
0.514055}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Compression",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((1)\)\ \ \ Fourier\ Transform\)], "Input"],

Cell[BoxData[
    \(\(fa = Fourier[sample];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[fa], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCEFFFFADCCFF73C66BA0FDE0BF41FFFF68A097B2F4
86BC51736D94586453A88C3091BA5A68537E885C6D5F607A44775A577C706B876B369844
605B898D63458C675D606B844D6A7B7AAB4443FB67A87433FF97B18656C2FF59D67BC2FF
68FFFFFFFFF7FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFEBFFFFFF817CFFFFC6988292A55E4734612A2E2B27052D
1A1B6A2F3729350538291A360106253E0F44102B102225092F2814361304392236271220
193807183B263147481827222B0F1F471A3946481E3A162E5858622F609A7864F9FFFFFF
D8FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFC1FFFFFFFFFFC9F48B347EFF5E21296E80911A6A445587
1F5D113D3F4033545D2540285F643B6B2D6846344156511A5245344E271F572065183E3E
26690E3754375035542E506612236F3E473A388026594D49B01F70839FDFE5B3D8FFFFFF
FFFFFFFFFFCBFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF90FFFFF3FF70FF21A692BAFF9B4F4849FF3032379689437E3C
313A4F8A19587163154E4A526D3B29496F4B157C3F2152112C465A3C364C3145381B4E54
5D173C5224535F2C4B0B99411B6B3F6258477B41BB5D388942BEB03BFFFDB6FF6EFFFF9F
FF69FFFFFFFF3AFFFFA8FFFFFFC2FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC8FFF4FFFFFF92A0295D7A6C2B854F340E7353
324D1E341C08654237294B11162428321B363F2135241762220A39341F40340622553825
461C373D544A2A2D41230E1F1C39302E59424F40900D3B5A4C847F667F57FFC170A4B3FF
BB2BD87DACB196652FFFFFFFFFFFFFCEFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF69FFFF6694FF9AE8FF81CF95E74E53475549471B4E6A1E
3A0E570471392C474642130F1B20342E24160E390B2C1D141E250C191310150610400C20
0C1B3F2938573A34121E1C312F384B262346412624633B2A446121274A9D949A785C306E
916272F65A66D4A4FFFFFFFF83BFFFFFB8FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF1FFFFFFFFFFFFFBEF3FF538D625EC87E564D4A7725
2A3A29551D303545260D3D201935213A0F1235343A15534402283542044714283E136438
201B6D3F5941075F254A40121E3562406159287D2836443069514C39625259422B37EE25
96DA9AFFBCE7FFFFFFFFD3FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF67FFFF5BD1FF5FFF935796C4FFD66346661C654738
3E2C44182F5D070B231A40350D192C2817302B173432231C1C1B2D2B03494B21272A1536
0F2933314F130516243B293F1B1B29083F4C4A202B372F5C3223383C562F76CCB2D4CFA9
AF6483FFFFFCFFA3FFFF64FFBEFFE5FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF28FFFFFFFF78FFFFB5FFFF6B7CFEB675734F6D873D321016
2D201C3E5A242D1815151F1C36290C35031E1C25270530341D3329251533252F1E2C3430
320C0F252F230E053B282C2E5232263C1E121E10514237311D5F2156124E7459B6B3C386
FFAACAEA93FF905EFFFFEEA6B8FFFF4EFF76FFFF
FFFFFFFFFFFFFFFFFFFFFFFF59FFC5FFFF62FFFFEDE78734A19A60A7B01EB769332F0F04
3B114C1048211D12061E061E173D132E291B2A245B1D2C181F130D1E2F241A2731141315
0A281E194E1C130F502323234A081E46282D16045A451D472D9A5D47461DC060749E2291
B5B881A3B16AFFFA99A2FFF5857FFFFFF8FFFFFF
FFFFFFFF0DFFFFFFFFFFFFFFFAFFFFFFFFFFFF7C844958FF794AD0AA882C42350B287C32
262231192E493A234D21132A31261C0B1F34222B2419381A141C5713181D4330160E1406
2723283735452B471829051F1E16182027401933431F2B2955204A1E2C592D3132A8FFFF
D04A778248D5C9E2FFDF7EC9DE12FFFFFFFFFFFF
FFFF7921FFFFFFFFFFFFFFFFA3FFC5FFE5FFFF167FA9E28023486E439C5554404C5E1223
50563C150A4A1A1D172727302B29200E3517363E081A282922231A370E361D0D0D2A2330
2516382622253D38193A1A37173519453423212C1155324C11333A5AAC7541869FB55D24
524ABE3D7BBDBB85FF935AEFAAFFE1FFFFFFFFFF
FFFFFFFFFFFF94FFFFFFFFFFFFFFA1FFFFFFFFA4EC85AC7A52B828463C6D5107230D0E4C
1C3C0A1C2B0D2E360F1A171E12141F36201A0324130C302A1D2E18321E092C2F0E161533
175D371F1C11213608203632141710193B4A27291D302E19395B182C11478991593E4A89
4A186FA171E3F396789D8895CDB6ED59FFFFFFFF
FFFFFFFFFFFFBDFF78FFFFFFFFFF65FFFFFFEB9FFF912E38AF4E8619635911160C2D1830
5A2421284026280E25021D332225340B3B281408311A144021192017252E231E19271721
200E0B0B202A1A2A233B240F0E1D1B362A162F2C44232A1233450F52345EA86A56432711
954667AEAD13CEC09650B0446DF977A5FF2BEBFF
FFFFFFFFEF83D14996FFFFFFFFFFF1FFFFFFFF39A06E92519F6C35446A1A7C42463B3621
1843492B215009132607282823260C32280E2953072538281915142A1932331D21293912
1E2F3A342F0E2C0D13524B11451E1C1830461A19193D3D471F4D372768122E3B19321565
837227BB7BB22EBEA674479DCB6BFFFFB7FFFFFF
FFFFFFFFE2FDFFBAFFFFFFFFFFFFDCC5A0B7FFB4875DBC4714404B1B6A464D593A1E301A
261C310316232519231A4213160D0D173C131627282615230B3913252223140612271415
3314331510483E4933193619072424130F3B3A2729013E27345947212A2D0F14404C1B57
5F2CDB3750B14B33947D3394A0C0FFFF12FFFFFF
FFFFCA62FFFFF7DBFFFFF7E6FFC2FF6AAA9E766D6B8A3E6312443C182F5F771F352C2B16
173808122A1A092F1F3F23080F11230E32361F161D140728252C040D273D1116203C1C1D
16183221281419051D0933192E0F081E1F1E1926184C3F221D0D353E35256426164150CA
3A533F5B6866497058796C78359DC1A0FFFFFFFF
C5FFFFFFFF98D9FFDEB6C0E1EEA6FFBCFF1AD329C66B445B3B4C20302820724143431F4B
2F1821064412372141293E242C3816071C16191A2510220722261F06451715143C212E2C
230C2D14253718193F27211C0321202B312107133A263444143A12040727273748294D31
90AA407EBBB24A54444B9D0F44FFA98EFF9DFFFF
FFFFFFFFFF7E5549947A98E893FFFF6DFF3082A36B6A5227886F2A102F272C33632B1940
174E2E464717180E1B2D302514212F04192C100E0A23311B1E0922300905373213164516
16071A1F3E173422193C17251E083341211A261A2F272B20367644592C1A6159098B9144
7724118F6D7A566D58031F44D4FF51FFFF35D1FF
FFFFFFFF4576229AC5FDFFB9E5FFF9AEFF36EA41784E6210115F36301B2C1C20490C294A
19152D271E2B2B1E1512130D2311221F3D2211321C1114130E1B2214111D22002945021B
3C1321262022310E4816133A0C251634033D142820403A250F402950475A2D4031814A7D
5848965A4382536E35232D78F144F9F2FBC2FFFF
FFFFBEC0FFE358C3FFFCAE9BC5FF82FFC3E9AE697475483166253B3F291C052C2A2C240E
210E21242553110C130C26232F271513131B1A1E260E112A2A1D032C220D15121908172F
191216121F0A38301027154722032B1A1E0F153D25092F294B2F2514733F245D82294B9E
4F3B2D4A3449479E08195C99765FB2F06FFFFFFF
FFFFD3B2FFAA9CFFFFA1242E6EBBBBFF67FFC759587B272E0F1E174C192B4522281C321D
180D0B0A29121016261C11212A0C060B0B1A271A1D0E1925110F131C2C270D063420281D
29160C071A1E402524231223112229183822142A033D182C2433120A435E60626415154B
015A0B3C6A5842333F45843C589CD1999AFFFFFF
71FFFFFFE942B683B77E65228D56D3D39FFF64B85A702E274D352A4D2A1A192C31420C22
3E53103C1F1619302E44182C0E2912173A34202A0D09062C0E24153B220E11141B0F0B2E
161B1D29202E0B1A2F1538260A1C1C342E3A342B35120B0C2011257337103090440A3D19
1F1C4350355F4D62588C725E80FD8D2DFFC1FFFF
A5FFFFFF402D0627D1DBCF60AB59FF8CB4FF67E2294324452D230D35453D192642361313
0E2E0D27151E1D1F1D283A241B1A1C1E14111C0C0E13150A2614341322221A1A19312206
0E33191419292C32212509251320131B310C2F1925521F0D53203E5A352F32324D404526
64058A320E7A381C685B3415A1D7994BFF52D3FF
FFFFFFC8AB326F69FBDA52B15786C74BD48A92CD3181111D444326612B2027050314103D
2E1C0A2A24254510161A121C2330251D151B39221E2B1A1E1B051E17092B100A33130622
08380D221415143D07250527072B0709152E1729150E2351222725293E0E2E1826094046
481740214F8222385E4B454594867456982A8EFF
FFFFEC32E13F3BD1FFBF294D8686275CA312DDE681632B264F36302A1A611C2E0615250F
1A0B1D241428173C454414180D140F0E1E1C29062534120F27142E1F192511131E031A0E
091F1E041A13210F0F2A10180601131D2722332817221D2C162E311847083A3E39532E1C
2E4945194D144A57592454548062826086A9FFFF
FFFFF550FF1B359DA26B370834144DBD4F59FF4FCE762B3A2D4B3B0B211A1041351D042D
1A1D05162221181D0F0C0C3C180E19101B08171C0D1113052D160E083A1F0E211A120E0D
07122522141D2B0F0223221A340B23110F210E1E0C15382330273D291D07411320330856
20463777574573590A58791F1DA153185DA5FFFF
72FFFFE3A8874A3C7F88688F5242A4C117A4B64E94485E1E28501E641B2F283B04291B3C
225223092446341828192A0F2C211B1D17090F1C0D260D0D160E0718131D050B0E091A1C
170A14160727070F2E16332B1C394109140E263C152D1E24242952282F1E2A2448103014
0D4E853D194B4A1170283B275CB11D64C2BEFFFF
B3FFFFCF7E42392592AA6A716A1CA86330667163724E375B21271437281A4B512C0D2823
03262B382D1D212A1B052C2C231A06230A17102F190A091D111C1E1722120E13001D3015
451317041411042206132720261C132323130F1D2C1414372A1617382B084D173D114B47
47184426244D09534821554C5C682433C175FFFF
FFFFFF8D655E515D8BA93B685741274D58863B8F2B347C491D2F4016283812150F3F2728
2D1C301B0F17140D03100D0E271E22221910140C260926051A26183D1E0E13101D0B1C12
0C2E0A2B2A141921200E0E171E120616101C0F0C35115235342614150C031118161C1F1F
46571636501C4155192052224B1C3264928FCCFF
FFFFAD48AD240781607135383126284C7C0D685A3F70523B1D4F371A223132223314260C
0B281C170C1E1202160E08171F0A15191625090C0D0A25312139072E0A32151909172414
12191F0A0B2318252A151023150B16131112192A27141E31280F01341E361D340D213B1C
26761460222E5F6F05240F922944554E985BA2FF
F1FF8E837B3456582A283C265C344879454D67367676244D2747234D2E1222141A1C2417
370E2900023A0C2222230B2C15142507142E0A1D02050F1B2414090C20091F0F12061311
110E1410033B090911240F250C0D171C0D191D1212251B0B2C11110E2A043207261F4223
4D42433D54385D5251214A1C327B2E9AC0ABFFFF
C3FFFFA3A36B64623C04565B601482A248536C3E8C21512A2857143A3E053353154B210E
2E0F20133309112F24152211151A13181D0A1D0F14170D0E0D0B022B12100C2F1B091118
060A160214052B201705052410182D1A21350D0C18130642070D3F0E2812370E1B241831
1326541E133C421C5C4F23395A325930E9F6FFFF
BBFFFF6D7058584431362E1A5638256753611B5F4B1E2D163025272C381F212F1312221D
190A080A193B220C18271E220E10150C181B2307111010201206301A0C2E161716290807
0C1912081720221E063D1B112F04222703232620221E093421151424241F0811161D2D7E
303C39203E19532A62252B232B3A1E1AB9B8FFFF
97FFFF7784472437432A352C1F24124B2D1333751F74263233012B1B202B071138111B19
21333B142907391D2613271D3A2C19120D1E1D080B2317151A0E0B390B1F1F210824270A
121C34200412270B1E1C251A1C0A1A062434300A15342F121D2018303713112308201D01
186616584C195E4F2B1F2E45214E0956967CBBFF
C9FFF37C6B2D3263441D3839215220492A093C2E0F840C0D570D19171522131019222E28
2F2F1D072B1E35172A152A18240C1F140E1912090E0C1317160F082A1F05091424140E22
201C0B20192503121D23290E0709242D242D12340F0B12243D0D115807302D16191B1C33
3230573346403C6610124E313672237C5C25BFFF
ABFFDE99844825330C5D1F652C59322C08384D321236314B1731182016151433110A1227
26241A12040E1C2808210F2204152627051C0D100D1A1D1E1D29110E16241F0F061F2644
060F19381A160B2C160C0E112023121910280B1B2D03133824301F2C0B2813030A081517
2C1D3D2724452D062A4D21174F3D22518B7AC0FF
ABFFC8884652081B22290F504A451B322D2A172E361D10542F2A2D1026191835160E0F0C
2722051D063722271D230E2D1A141020281C0F08360B2D0C170E1F17220D12111508161F
0A140F230F1A160F1519110A312C1D2223261713182C2224190D272121361F141A2A3327
130724223E364C1520313E43303C2C585D51FBFF
B1FFBE9C8A271E3726233D4927121D3727353D3B1E1B3D1A0C29060A170A17181F1B0E27
2A090E0D18110A091505142C2A061D1F181B0B2F0C0F1E0E1113091C141F182116100417
18050921180D0020260E2718131727100D181126270F0E04010F0E100E0D34100C18202D
19231018241A363B29333C7725472B2B7072E9FF
8FFFDC52550C654C2925340C18283838313827231829461C2017131E23340A1D3714190B
06110403020D141F1A30303520141D0D162429200E0E1C240D1415252015160914152B29
07201F21123120222111180F0924080704091F19111D1D0E15222310261E15300C122D2D
1A2A02454F364D241D113D422951512D5B85D3FF
B6FFFD39642054823661213451323934151B492B1A131C3215271C1C1719242B172C1F09
292B1F08200117011815100E0220150F1D1724161E24111D2119190B0F0B180C0B251611
1B1D141211211819150C0C072A07211E22180C052617180F22251B0F05110E261E3C1129
060F30473F364310132C3A271D620510AA52B7FF
DEFF9E79593A484626493D3342133D25362E271E12360A0F24261B1E162116181C112E13
18131B21141C06180D100C1B171E0F0B0604112412050911251A111E1E281F161811090B
16150C220A21190F1131190F1A171B1426160F0D09261C0C1F2C13110F16212E0C2D2021
000A2C2B264419321F262019134B341B9535A5FF
8EFFB95987611D454D3B44532D211E352524051A201717421C130A190624050A113D1927
0F2B0E14142326151B172D1C2C1E200422261B031519091C1F190C170A14250C22170A1D
0D0B30160C1A14140B22061C0A2310211C2211142115291A28110E1C4123153912142D22
021B2F0B32221F342B2D2233322B28236C5DB7FF
99FFC86369502E1E4717441E1A191E1A2C1D122116192C26481F0F0A1A0C290C1D232B1A
0E070D1E1B0E1F0C13072322251C09331926281E141519281C221917220D081B1F0A130C
162313110F1F12010F0E3611101E032C1817152B0F322228050E1C241110340B18290D20
2D13331C1F1B23331516543735281B147684DFFF
A3FFD1976B0D2D270A2127182C20072910481A242521333712272E0D3029060B230E0A22
0C211A11130E0A2C06171D141A131E1211271612181911140F080C120E12241126090B1B
13190D071D0D1C1E0D0A1D121716190B12290E0C25161C071F3B1B1C0C182E170F102120
1F21122A161B381C23281234132F28354F9FCFFF
C9FFD7416F20183D21390A1B2A242A09171426322A0E0B331F22150E211817221227281F
1B191E301C2C1C320B1D25170E2A1E18140B1B0C1A0C0F0C0E0E0D0F121916181923090B
0F15101C1527131A131711200F17161D141C15231A1720260D0F26340D09120C1E191F28
4F324B182210263B2B1D28223B3C243D8B63C2FF
C2FFC1547D381C25322B2120124F30241B22252E19171836321E24140806023716132E1E
1211202B131A031709111D1C0A06050411091816100B152E0E091B1110111216050B0E1E
0D1109171811250704160607091A140A0F03111B1B0A0507062224393C14170E1D30212A
162202173C130E1F1221521E086B290F9454BFFF
8AFFC0685049332E1420481A18491E18051D2A24051437131B151A2616082821211D1429
07262D123A1C2A0F090F351B1F0823241307080D09231315081C170C0D0709100C051513
0A19070D14261B0C1B1828241D11071025151C2F1721292D2D2C1725151E221E0D1C151C
0F211A19282A251A253D13220F332C20555CCDFF
68FFC95B7F47361710282B3F101C1F143D052C320B2911101B180F1907021C0307200906
1B2C061D2923291C0F0B1B250E0C130919090E09090A1F06150810010E091D1112222717
0E12110C05241F031E1D2D180A1A12222E2A3131201D22201B0008120D38061D05184216
3516201B0A27250E35540D08363E3A285E5FAEFF
8BFFB6456A4A231A2A14232E301C0E0A101D2A1F071A1E0E2F1626140E1325190D0E0B11
1E0F1D221C19280C1C1603134F0A082913090F1D142615181F0C122313042E1D09140F22
0A030F0A0C010D082012101F1B1B0B290E0818301105301D1224251609191B14203D1B16
161032102D1538292C2335402F10233E6265A1FF
83FFD04B791C1F3F002B3426262E31051533173A11142B16070B0C0B101B23101218060B
1A261D1A09081836031B171F030A0625151910170607130F190A1C170819260803091E1E
1B0F19121C06150F1B24232C1A250F18192606270606191B1613130B161C2C12051B1D2C
1B0532261312150C1E133C2A21092C2A796094FF
9DFFD65C771F22341917370B24450C170F371009111D0D1F1B0B101E160E19060E200713
150F31181C1F0D0B16063009202E130C0C18100C0F170C11221208151A0A0D221D180409
180C031128121E050F0E0A1C1C02181C1614191514241A330A13182F2318241F0C470B15
1C16242A21331E0E061B23191F3F26258D51EDFF
92FFCC58793D323D2E252834061A1E1C1B041B1F010C1D28161B2D0E3D121B192611091B
112613120C17051430071E180D2B2917120913091524050E1B142109080C1F0E4915220D
0F270D060E0A22072B2113051C20192506081D0F2723121D1F212B0E0D191C1A15001829
1E0F20052231350F0D2B29191F372C335861B7FF
9EFFBC5668544C3816490A1C2C3513121E0F292218151A191E0A11191D211A03101B1E21
250B0B14081F1B210F0F0A1C140A252E0A1C0C19050E0A0909160E182715050E0B120A32
041816060C122B0D24171B142E0F0E232A11251A131511031928140315190C171E141317
1E1F110E2620112027091F211024412E576A8DFF
87FFC248532B552D311A220F3328182636111F291919441F330B201A151816060F1B2724
1817130A051E120A2C370D20200D0F120312081E1D120C082212260E0D0606090E190519
0C220B2B0F0B14170B0C0718110F26140F152C220F15052139161F2012210C120C133B29
1D171F331421133A170516151C49371B846AC0FF
A6FFBA5B722C474C100808174F37212D20241D0B2A13061B161F092019151A05211F231F
181C07241B110D1D08170817151F010A171437101E16180F0B19150E1919121012060B07
0C0E130F200F1B071712132E1713280A22150E0D1F150C1210032C21210625151D34230A
341F3829012E013634161D26202B240D8461A7FF
9AFFA7685B2305501D1A241950353535110A0F171D19080F191321200D1D252D1D0F1309
1D13133017301A0C111B2C05171309140D221419170A0E1610191912170A0E0A1016100E
1D231B0B140B1F141920140B121212071A142C112B1424201618310B1524130B1134191F
300E2B0C111C0818281638071845441C8C6AABFF
84FFBB327123033B3630320957282A0920251B1F03070D2814130C28101C1109081D151A
091B061F14271514041C110D20071E16171E110D1A122F0B041D150D290218222B0B1B14
1710092005221507050A1B19060915040C141F190C0D1C2B171A11110F182209131C252B
211A281D27082028113F27432C5525446056C7FF
8DFFAC67621B122A2B2025193E150E182B3319322322193012081D04110510220C251713
081C3A121D0F0E121103090A270F07220F110913101C1406140F1329110B0D12100F2018
171B1D27131B2016231C1B1E100C090513211D0C171B0F0A1B13240E0F18251806113D1C
192C241F1B0D302327211C481A3432385B32B8FF
71FFB165750E2B25182B1C2812381B380F1B0818131A1F14121C230C2323181B1A0A342A
10292C1A0F231804282515142D171E122020200E141C1D1E042720230525140A071C170D
16052413141F0917110A2D08101F0E1D1B2411180F190F1A181A193D0A22071F232C132F
39331028171513392110154B2D25204D4162ACFF
94FFB6577F1C3C4D1C0A1A1F1F260E533E1D1313201018171C2918262514182B1F091A21
19030E1B0F0A170B1412081501181F1719191B141008161C0A23211013132A121F0A0515
120A2D151B081D0E1422211A2113080E1314051A0E1622161A160F140718231B211E1323
2F0C401B2C3431270A0A510D24661E407F6092FF
97FFA7675439274A162C2E173C2515333C151E2D192425281E051518072926171214060E
0B0D0F181E1220071C151D1A1820071A1223320C111C16161915031A12150F110924021C
170203160E1A08151F140D000A141B1D141019341B1B0E10021B171C1C1514083634031D
151D203A35410E2F070246160F2F2229532F8CFF
98FFC380512D233C202F35201A3B1D262C17160D241C290E20050C1331261A1100133D07
0C030914101A1A172E0605201318130B16141A1410101C121D141F0F2408200818110821
160C08160B211A190D0C150417021A060814180F21040D05261A2F3337172C2119292C14
1F181732041D141F1E221C4F315A291B6025B0FF
89FFB0697125162C1E210E28112123212805221E192E16300D0225251F1E1B29101D1119
1B2111362E1F1D220D20170F141A05071017031A141725190A151A0C140C1A150A192517
141A03171007051A140F17200D221D1F2E3611211B19111D10291B1E1F2525020D30162E
191E22052821232111280E211E2C16257169B0FF
98FFB025601B295A314F1C221E1F141D043217181F142C2919212C1737332F1A26050D04
210F181408061A021704150C0D191A210B16080C1621081118082008240F1F141D121C10
10141A14160B1318132005062E171A1A101409030C073D1300111A2631130C05200E291C
240D16172C261D3B1A20352F203C232D5180C3FF
97FF8C2F5329222F0F164602072F0E41353A201D151D0334360814151C1C171B02100E1B
1B341910141D1B140A000D141F15081A0E160302171C022409110F15121A03151916161C
110C3223121A0720181A1D151C0720121E180F0D0B0E061412172629071815051E282524
192D1E153C3315253C172E2C164A27395467A7FF
94FF92607F401E66240D510A0A2731342C1B400C2F23131E211B231807140F161A162216
0E1A0514130E0813211A2122140E1D081B152D0A1215050A1F122A13131021230A1C1608
10141B1919171F1801150812140B170A0F1B0E0319211A091F2B1814252618291C171810
2013131D3E530E261F1F1A0A1C4D3C1C7F57B6FF
71FFAC62414D20252D4B15102139131517281033392F132C231F07220A3D191A181A0F19
0F1811241B1D0E1F10082D0A1117091F14132405160D171C070A142505232027041E1D1C
140E202020121E172D141525280418230F1A2C29102A340A1A1B1823230C231C12141F1A
1318081B0F381B3812281C2B18252B0E7565B1FF
8DFFB8325B3832341A481C212723300D1B1F242C191C3D11061825180F0E24131B0A0F1B
170C1D211305090C101E1B1C2316201B13271D1B1718200F10120D0B1129130F1406141C
101309110F22070F270A090311120E0F1D123A1C081317250C22100511041D0812301922
233219332B180E153E1925202B2A121B6267ACFF
84FFC756604425552C43273F11282008271D281A212B251C130922180F11111A172B1C0D
0C191F140C04150906191B0A050715220520091017141B0B2B221802290D151D040B2F12
1A0D111E17161E07200D111C04141527141F061B091A151D0809111C10280C1314280D07
031F1B2520092A2857093230363B03237132BBFF
9AFFAB6A8C1C4445180738162818081C110C2B0E301F1934110B1324150B311816202414
2B112C141A071212120B142019141F0B140B1B231D0E1016100A0E0A1712191910160E0A
171914220D14091317052C1B110C1A30173013131D09130F1D2D251D0D202113190F0819
1D170F0A113535355019241A1D5005235B68A7FF
A6FFA761840D242B20261D163436012E0129381F340A23341D15250621212C0310120C15
1F0D0E15220A2813172E131217071B0F200F130E0C070B0612101219190E15190B0F1816
1E103714170A011F15170817081D0D111B24071C181F231F21051A151920091F161B0613
2A0B1D24202D21374F170808104C472C725BBAFF
87FFC06A841B37491C151605173A132114331F171D293B130C120C2112201F1639210515
0F222C150F14260F1118070C0B17140B0F2B0B220C1905190E0906060D0E261222080C12
1D1E081203120F0D20200D372C0A121E050A13171824271B0F061618151A200B331F4419
19291F1136261828330F221A312D552B5348C2FF
9EFF8D6A572E412410211F0927201120260E111F1E1713141E170C191503142819031115
131A25112A230E0F2E141B17240D2B120C06161804320A120B0E051527180E1609090A0E
05190C1C0A2E250A141C0A0F0F211B1F08140B0B25211E1B10031A211D19110A1E191A15
1822290F1E1213352C1C0A4916384C546856BCFF
92FFB76158332C371F19292B0D0F35312205200F1E291800151A1C190D0E2B211F1D1223
270F1D08062519201C0513212B07220A0E060D270F0D2215490E1F0C080921141B0E0524
150913091217292B0D181E07301405170C121326111B091126191B123D0E2D1B16281D0C
011F1B041B1C1E1A063428252E3D323D7958CCFF
9DFFED518D25263F1F19231B060E1E33212A24161C150B470C1F2418232F18130A331A24
14151914161C18021C1C0A0E0F051E122811030C180904181D220D0A1A15081222110C17
0F0C10180C0C132E20093006160B0D1F1C18310F151307200E06190E161E100B1B1F0D1D
110910370F170C45240B37171934221F775CD6FF
83FF9460792A2C09212A3C131E0C1512132632051B2C1D1B05122C1C160B1313161B1906
0627062619180F251A2C23241B0F15061C12190F1B1E1E090308261908171C0A190F1307
061710191525060A031F171B03361808091A1D261A0B06181210231B100B0C0B07162B14
113A17331505312E2626342B003F1F1C794BD0FF
8BFFA165623E23102F4035232C2938152D10321016161B3D20141B1909162524121D3005
113018080E290B1B1B1F101220080D010C0A0F030A220F14091D2E041323120C1F181526
141D0F091329080A4F1303161C0C28191C221D0F1E110B0E0D1925130E1426162F0E1E1A
071F2A1D100A0E1C302E23142A1A234A6A45B6FF
68FFAE5F5E283A3E36080D54350E25270A1B201635164218051D06380D1208001B20221D
2031312A2E22121A0A182D1D1E031F24050C11120E17272212111D090E01100815061F0A
09090E091909130C0E251B0B0F1C2923291D062C1B06092007031C0207190F181B101129
0B322C053D141F1C103F2B28101736477F5BC9FF
8AFFCD5C55202C330F22133D251A252A28191A210F1C151C0D1E221E1525172C2D2D2921
172F1C15251007111D2428181B0C1B26140D07190A1315050C1009070D0C171C08151323
090D0807132423081F1B350F090F2A1C3A122D260729141D2121280816261A151B133714
05242A1D05181E49181A4820142E33495068C0FF
C2FFBF54940F296B081E5221121F0E133C170222162A21301D0E17143C3924220607050A
1B1B11030F0A141A0907061604072511181709110D1E0E0B0516121110111B090E2E150B
10161809110405060A1C1D110917031A132B2011121E2E13163702060814241E32361817
192E25221B24304F1220212B32251C387D54C1FF
C9FFC2638B3D243C3B22281D2B3B261022184B324F281F191E0C12090D34260F0D262017
1A23151C141D16170F201117131A1327151C10150F0B092319181619120F0D0E0E0C0F0C
1A0C1B0B14181E2A0E17251D0B321C2C1C301E191B1F282712221718210E15221F330B0E
2A32261417092A242A1B0A39213D18206F41D7FF
A3FFCF9F4F35282F13341228231C381B162A12211F2021100F172E180C1C1B3B1F071C16
250C0E29120B191617121D0A0D1E1C0D1D070D19131B0B09261124120E120C080F141119
1812162711121E131A141D17062C0A0E13111A210C220A0E230B0629300D2E2712373321
25241A48102907202C1827210A272D0D6B97D1FF
99FFDF8476141B28353754161533231B1F1C33132D200D29180B341011241C0E05282232
0F2B1517182C031E1011360E0F01121F0F111323160C130A1F1B080D221719221C281915
141E28261933091C25222307130C1F0E1B1E0D070E1A2B231D0C290C1A0A0F1F48262C19
1621121D2C1A1E191A1E4417471E2E506963C8FF
8EFFB75D6C23282B3233222D2B341F22320B2F1B02222D1412391523411C0E11281A2915
211411221C2110230A1C06220B14141A0C16300B0D1D0A17220C25140A170C191F1C0919
15031B262204201E2C1C2D171B15262314140E2B0F27193D110A052406190A131C421717
201A052425351E212D53443B4D451D618759B9FF
DEFFA535951B344B131920261F321944262B2C0A0021202D0C2E21160F11132C1F0C1C26
090D0F1626141B171A0F1931110F19210A220C15160B091118161F281E1E111A25110905
12241104060B0F1E171B0C100D18061C14211B1318132E111C181621161E1B26240F0A36
121E272E36253D1342333D492646483A59799EFF
B6FFB752AA1005621D273A2C131043363F47300F0629113C1E260E11050F1B25220F1817
26050C18221E21072A070C0C151918211112141D1B1116250B0C180B0F0B1919211D1124
1E1624171D0F1520020E10151801170120081F2B29091F2C172B2419171C1C2715321C13
1A2B491B1534393251342161368254206439FDFF
8FFFD3855B2D515129423D111D244D364F45022A1A2D2D120C30151E26102322150E1D1D
11191F0904070824090F18112122203112211F2007292B1514091615202515140D241C0E
0E202924160D1D14203530301A1F140D02030411060B1914371D0A34231E1317201C4629
1823273831383828180C3425294C650C5552DCFF
B1FFE972702B2B4725773C33293B361A24181023192D20180C10340D0E100E0F01040E0F
272611180D1027171318270E2620000D18210905181704101621181F141C0913110E1E0F
0C2F0B1B181F1D062A2C140515090A11180D0E092A270E1B1F18170A170A06290C1A3D1B
1E3B3D3527371D1227493D2326371E278A9CBEFF
ABFFFB515D582C3C30433E3120154C363E2224071327332A1A141F362121270D1924222C
1813172623221D2C310A1119150F161A0F230F140A1F16081511120D22171F0E170C2D0B
36080F1C282010141A2D0E231D272237061D0522270C0F0E1635181926102D2A2F54101D
362E172A2D321B454A500F29221B08524688C8FF
ABFFC07A8B51223D4F17214D2A062D4524273D1D2C1715080A0313280B2C1F3024381303
2D1B0B281019122320110E0C162C0B161A38190F0644261F060F1F24160E11291D1E1D1A
0D100D1C0527261504220F2108281C0E04121A242627120A1133141516201831174B3136
12324D38082C32592C651F5D0C3325488499DEFF
C9FFBF255C7C237236314E1210663C404633573032331C1B19162D300758110D3D24120B
0F34122D242D2409070E29231D12032519200B1C20220E14241409051F2A080F1617130C
0E0912190E141F0C24182A152A17351E2B071D2F2F282E22191013221517190D570D0C84
0F2E3C092A4920522139381D4463322D6B7CF3FF
97FFBB7C9656094E21452E1F2B4F5E194C58166618011D2008231113373018201D122F34
150A303424061A0A1C1A251C1E0B27120420341C120A272408211F1F0B390B0E1A151723
0B081D1E0D12192C3A1D2713261D390729143B3321191B113811072B201B2B0133322674
1F7533132D4B12241F2C352A433724478477FFFF
BBFFFFB8B91A1E3A2B232B25622A53193E20393C307E2D1D1611081F242414152134091E
22202623032722042F111B3D061E2220170812190C0708291617162E0C1A300612201010
1107231B180C15100E221E27180C223B190A080A191D2212132F211F382C272530162D1E
4B5F1B6153672538561A2E3631445858706DFFFF
C3FFFFF6E93059325A39234F5C1C423C131E5426133118241B0E3712280E3F0D07420613
180C0D35211A2D181024050517202B051402160A061811091B2F0C10122B020B0D0E0D17
140F1D0A1D18131A15112215242F11093313200F2E0E214B155333053E3A1457282A5121
8C3E6C5348A28214605B56043C62646BA3A3FFFF
F1FFFFABC09A2E7B321C4A2151525D38543D43424D23421F260732042A0E11112C0B1B25
12121D190D1C170D0C250F241109093B0310140E11111306120F1F09200C0914241B0F05
021D0A2E14072514152C0B2322220C3A0200290E3717241C1A1422122E4D2347274D2476
7636674D457948345C263C282A5856347B838EFF
FFFFA25B984E554429920F24056F5F2E22601476261C3B210D341D361E34010F28311E14
272A19121113160B152310152A2518230B0A1F1912142417091915320A2E07392131250A
0D0C09251619150A1F17080E1602121E0C171C280B0C261433223231221A374F1D3B5270
3F5A680D7C4C28263138357160810724AD48ADFF
FFFFCC8F9264321C4B2252201955411C50361657461F1F1C161811030C15142634355211
350C0F1C101606121E170E0E202119142A2B0A2E0C121C0B1D10130E1E3D18261A052609
260C14101922221E270E0D10030D14170F1B301C2D28273F0F1512382816402F1D497C34
2B8F3B86584D274157683BA98B5D515E658DFFFF
B3FFFF75C13324685C4C55214853094D2426441847474B113D174D082B3817162A371414
2C1D0F132323131C2620271306220411140417134515301D00130E1222171E1C111D090A
192F10170A23061A232C2C051B2A211D2D382B260323280D2C514B1A28371427215B374E
726371663063A81C6A716AAA922539427ECFFFFF
72FFFFBEC2641DB15C273B2870114A4B193D854E0D14301048242A1E2F28522924241E2D
153C260E140941391C2B33162E0F07270716140A171C1A090E0B051D1318070E160D0D26
0D1C0F09171D1B212C0F2A192818344624092352223C1B29043B282F1B641E50281E5E48
944EB6A417C1A442528F68887F3C4A87A8E3FFFF
FFFFFFA55D1853A11D1F79580A5973455777374620560833201341071D293D2730233815
0C1E0E210F11230B341A2223020F2B1D14222512070D0E121A210E1F3A080E162D051311
0D1C17081B10190E183C0C0C0F1D18212216051D1A2D041D3541101A210B3B4B2D3A2B76
CE4FFF594FBD4D143408376BA29D351BFF50F5FF
FFFFFFA9866082628054542459574A144D1945492E1C2E53393E3A084718312E162C1D22
17283322271D13010618102A0F0F21131A041E1F090E1A031E131125191F2E14270F1234
2506291C1E0E0F140D181444453C172814241D0B1A0F2515062E1C611A2A30364F262B63
81E6DD12A35C2786864D29BFFFD13B3FE132ECFF
FFFF8E2A985674869445454B5E3822824F2140174846400926182E0E3E2925272251230E
1529172E1509072B07270525073D141514220D3808220613330A102B09171E051B1E1A2B
1E22391B151D2530231C121A16104525242A0A1C2E3D1014030527202B612643441D1181
31CD928AD44BC78657B152DAFB696F32ABC8FFFF
A5FFD352FF4B99D7A115345B681C387A0E328A05642645404D32322F355A3E20530D1F52
25192F0C311B13201325092521322C29191419330E062231191A1A2222133414260A1513
0E0C1C11141E1C1A1B243A281D1F1D1E15270D2E0E1313364226193D45350D232D452443
29E267FFB48CFF59AB60CFDBD127062D40FFFFFF
71FFFFC1FF2D8DFD805E728C58624D5F3550431C1F193D0A4490301037732511200C0B12
352B343A2E341C1C0A2638152F1A0B2E20291D1B162E0B0F1B14110E223B15240E2C0609
0D2A20343A1712290E2C18442E3019161F3C10533E220C42312C191A2A4D2A354D272E70
5AB864FF9FD3D3568D22657EB783B642E9FFFFFF
FFFFFFFF9A99D19C583C84453F3342586A3C0B5A014B15156462605E430A1233242C183D
032A142238182922112312232425401E1A070C16291D282034060D272C1C130F1125190E
1D1A271A0B0B060C2A21111C26161012290A0B0D181D321C2822452B194C171E0F2E277B
5859C7FF67FFBBBB6E2E24A1FFFF9CAAFFB2D3FF
FFFFFFFF6FF0B25F76995C19089E4749344A2D3B4F9E4B29825D243F7314252F4B292F09
253D150F1E1A2B03224715271030380A1F121612192F17081912150D222C031D2A2A110E
261E1A1B131315272F23260C130C11532524210E210E242C2A2C051C293F3B2566314875
7469AEE9C3FF82FFC59BAEFCFFC358E3FFC0BEFF
FFFFFFC2FBF2F944F1782D23356E5382435A9648587D4A8131402D5A475029400F253A40
2028143D033416250C3A1316480E3122202621133C1B02452900221D1114221B0E131411
1C3211223D1F2211230D1312151E2B2B1E272D15194A290C49201C2C1B30365F1110624E
7841EA36FFAEF9FFE5B9FFFDC59A227645FFFFFF
FFFFD135FFFF51FFD4441F03586D567A6D8F11247744918B0959611A2C59447636202B27
2F1A261A214133081E25173C192234173E1F1A071616451613323705093022091E1B3123
0A0E102C19042F211425302D1B0E181747462E4E1740192B63332C272F102A6F8827526A
6BA38230FF6DFFFF93E8987A9449557EFFFFFFFF
C5FFFF9DFF8EA9FF440F9D4B44544AB2BB7E40AA90314D29483727270704123A14443426
3A130721312B2021031C21273F19183725142D0C232C2E213C14151745061F2622072210
251A19161C0716382C243E2941213712440621182F4B1F43434172202830204C3B5B446B
C629D31AFFBCFFA6EEE1C0B6DEFFD998FFFFFFFF
FFFFFFFFFFA0C19D35786C7958704966685B3F533ACA504116266425353E350D1D223F4C
1826191E1F1E080F2E1933091D05191428213218161D1C3C2016113D270D042C25280714
1D161F36320E23110F08233F1F2F091A2A12083817162B2C351F775F2F183C4412633E8A
6B6D769EAA6AFFC2FFE6F7FFFFDBF7FFFF62CAFF
FFFFFFFF12FFFFC0A094337D94334BB15037DB2C5F571B4C40140F2D2A21475934273E01
29273A3B0F1324240719361933493E48101533143315142712061423222513390B231526
282716133C170D0D1613421A231925231603311C261A301E3A594D466A1B4B401447BC5D
87B4FFB7A0C5DCFFFFFFFFFFFFBAFFFDE2FFFFFF
FFFFFFFFB7FFFF6BCB9D4774A6BE2EB27BBB277283651532193B2E126827374D1F473D3D
19191A4630181C1E45114B52130D2C0E2F343A2F1E123929211D3332192A141519283825
0753290E28320C262328280726130950212B49431821363B46427C1A6A44356C9F51926E
A039FFFFFFFFF1FFFFFFFFFF9649D183EFFFFFFF
FFFFEB2BFFA577F96D44B05096C0CE13ADAE674695112743566AA85E34520F4533122A23
442C2F162A361B1D0E0F243B232A1A2A200B0B0E20211727191E232E251720192140141A
310814283B0B342522331D02250E2826402821245A30182D0C1611596319864EAF382E91
FF9FEBFFFFFF65FFFFFFFFFF78FFBDFFFFFFFFFF
FFFFFFFFFF59EDB6CD95889D7896F3E371A16F184A894A3E59918947112C185B39192E30
1D29274A3B19101714323620083621111C1F375D173315160E2F2C091E32182E1D2A300C
1324031A20361F14121E171A0F362E0D2B1C0A3C1C4C0E0D2307516D3C4628B8527AAC85
ECA4FFFFFFFFA1FFFFFFFFFFFFFF94FFFFFFFFFF
FFFFFFFFFFFFE1FFAAEF5A93FF85BBBD7B3DBE4A52245DB59F864175AC5A3A33114C3255
112C21233445193517371A3A19383D25222638162530232A0D0D1D360E371A232229281A
083E3617350E20292B302727171D1A4A0A153C565023125E4C4054559C436E482380E2A9
7F16FFFFE5FFC5FFA3FFFFFFFFFFFFFFFF2179FF
FFFFFFFFFFFFFF12DEC97EDFFFE2C9D54882774AD0FFFFA832312D592C1E4A2055292B1F
43331940272018161E1F052918472B45353728232706140E1630431D1813571C141A3819
242B22341F0B1C26312A13214D233A492E19312226327C280B35422C88AAD04A79FF5849
847CFFFFFFFFFFFFFAFFFFFFFFFFFFFF0DFFFFFF
FFFFFFFFF8FFFF7F85F5FFA299FAFF6AB1A381B8B591229E7460C01D46475D9A2D471D45
5A04162D28461E084A232323500F131C4E191E280A15131431271A242F1E0D131F182C1D
5B242A1B292E133D171E061E06121D2148104C113B040F2F3369B71EB0A7609AA13487E7
EDFFFF62FFFFC5FF59FFFFFFFFFFFFFFFFFFFFFF
FFFFFF76FF4EFFFFB8A6EEFFFF5E90FF93EACAAAFF86C3B3B659744E1256215F1D313742
51101E121E3C2632522E2C283B050E232F250F0C3230342C1E2F2533152529331D343005
27251C1E03350C29361C1F1515182D245A3E1C202D1610323D876D4F7375B6FE7C6BFFFF
B5FFFF78FFFFFFFF28FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFE5FFBEFF64FFFFA3FFFCFFFF8364AFA9CFD4B2CC762F563C3823325C2F37
2B204A4C3F08291B1B3F293B241605134F3133290F36152A27214B49032B2D1B1C1C2332
34172B3017282C190D35401A230B075D2F18442C3E3847651C664663D6FFC4965793FF5F
FFD15BFFFF67FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFD3FFFFFFFFE7BCFF9ADA9625EE372B42595262394C5169304436
287D2859614062351E12404A255F0741593F6D1B203864133E2814470442352802445315
3A3435120F3A213519203D0D264535301D55293A2A25774A4D567EC85E628D53FFF3BEFF
FFFFFFFFFF1FFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFB8FFFFBF83FFFFFFFFA4D4665AF67262916E305C789A949D4A272161442A3B63
2426414623264B382F311C1E12343A5738293F1B0C200C401006151013190C251E141D2C
0B390E16242E34201B0F134246472C397104570E3A1E6A4E1B47495547534EE795CF81FF
E89AFF9466FFFF69FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFCEFFFFFFFFFFFF2F6596B1AC7DD82BBBFFB3A470C1FF577F667F844C5A3B0D
90404F42592E30391C1F0E23412D2A4A543D371C46253855220634401F34390A22621724
35213F361B32282416114B29374265081C341E4D3253730E344F852B6C7A5D29A092FFFF
FFF4FFC8FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFC2FFFFFFA8FFFF3AFFFFFFFF69FF9FFFFF6EFFB6FDFF3BB0BE4289385D
BB417B4758623F6B1B41990B4B2C5F5324523C175D544E1B3845314C363C5A462C115221
3F7C154B6F49293B6D524A4E15637158198A4F3A313C7E438996373230FF49484F9BFFBA
92A621FF70FFF3FFFF90FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCBFFFFFFFFFFFFFFFFD8B3E5DF9F83701FB0494D59
2680383A473E6F231266502E5435503754370E69263E3E186520571F274E3445521A5156
413446682D6B3B645F2840255D5433403F3D115D1F8755446A1A91806E29215EFF7E348B
F4C9FFFFFFFFFFC1FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFD8FFFFFFF964789A602F6258582E163A
1E4846391A471F0F2B222718484731263B1807381920122736223904133614282F092522
102B10440F3E250601361A2938053529372F6A1B1A2D05272B2E2A6134475EA5928298C6
FFFF7C81FFFFFFEBFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFFF68FFC27BD659FFC25686B197FF3374A8
67FB4344AB7A7B6A4D846B605D678C45638D895B604498366B876B707C575A77447A605F
6D5C887E53685ABA91308CA8536458946D7351BC86F4B297A068FFFF41BFE0FDA06BC673
FFCCADFFFFCEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0ogoo1goo0@00
0Goo000>Ool20005Ool00`00Oomoo`0POol2IcT4Ool2E[D2IcT2Ool2>Lh2HaP2=Jd2DY@2Ool2Li`2
G_L28@P4Ool2=Jd2DY@2BU82F]H2Nmh2@Q02G_L2:DX2>Lh2=Jd2BU82;F/2<H`2:DX2E[D2AS426<H2
BU82G_L2;F/2=Jd2:DX2?Nl2AS42;F/2=Jd2;F/2<H`2?Nl28@P2>Lh2;F/00bU:?Nlmk`02>Lh2=Jd2
@Q02=Jd26<H2CW<28@P2<H`2;F/4AS42<H`28@P2AS42<H`2;F/2<H`2=Jd2@Q029BT2=Jd4?Nl2E[D4
8@P2Ool2<H`2E[D2>Lh26<H2Ool2BU82F]H2@Q02:DX2HaP2Ool2;F/2JeX2?Nl2HaP2Ool2=Jd8Ool2
NmhQOol10001Ool001Eoo`03001oogoo021oo`9W>@Aoo`9F]@9W>@9oo`8icP9S608e[@9BU09oo`9c
W09Nm`8Q20Aoo`8e[@9BU09:DP9JeP9kgP92409Nm`8YBP8icP8e[@9:DP8]J`8aS08YBP9F]@96<@8H
aP9:DP9Nm`8]J`8e[@8YBP8mk`96<@8]J`8e[@8]J`8aS08mk`8Q208icP8]J`03:DXmkcg_008icP8e
[@92408e[@8HaP9>L`8Q208aS08]J`A6<@8aS08Q2096<@8aS08]J`8aS08e[@92408U:@8e[@@mk`9F
]@@Q209oo`8aS09F]@8icP8HaP9oo`9:DP9JeP92408YBP9S609oo`8]J`9[FP8mk`9S609oo`8e[@Qo
o`9kgR5oo`40005oo`005Goo00<007ooOol077oo0WNm1Woo0T8@0Sg_17oo0V<H0Tic0T8@0TYB0U:D
0Re[0R480QS60S6<1QBU0Q240P000QBU10aS0SF]0QBU0QS60QBU0QS60P000QcW0QBU0PaS0QS61000
0Q240QcW0P@Q0R480PQ20QBU0PQ211240P@Q11BU0PQ200<HaPQ224800P000QcW0Q240QS60Q240PQ2
0Q240PaS0QcW0P000PaS0QcW0Q240QS60R480RDY0PaS11240QBU0P@Q0PaS0R480PaS0QcW0R480RDY
0PaS0QcW0PQ20QBU12e[0S6<0QBU0S6<0Tic0Sg_0S6<27oo0Vmk:goo0@000Goo000EOol00`00Oomo
o`0LOol2Mkd6Ool2@Q02?Nl4Ool2HaP2CW<2@Q02BU82DY@2;F/28@P26<H2<H`65:D248@200025:D4
36<2=Jd25:D26<H25:D26<H200027>L25:D236<26<H4000248@27>L212428@P224825:D2248448@2
12445:D224800aS62488@P0200027>L248@26<H248@2248248@236<27>L2000236<27>L248@26<H2
8@P29BT236<448@25:D2124236<28@P236<27>L28@P29BT236<27>L224825:D4;F/2<H`25:D2<H`2
CW<2?Nl2<H`8Ool2Kg/[Ool10001Ool001Eoo`03001oogoo01aoo`9S60Yoo`9W>@9kgP96<@8HaP8m
k`9oo`8]J`8@Q08DY@8e[@92409:DP8<H`8e[@8Q208YBP92408<H`8]J`88@P@Li`8Q208HaP8YBP8]
J`8@Q08Q208DY@8]J`8aS08Li`8e[@8DY@8e[@8Q208HaP8Q20@YBP8<H`8YBP8Q208HaP039BT@Q124
008<H`8YBP8@Q08aS08<H`@Li`8@Q08e[@848@8HaP8YBP8HaP8YBP8HaP8YBP8DY@8YBP8aS088@P8@
Q08e[@8Li`8Q20@Li`92408@Q08]J`@U:@9JeP8<H`8icP92409>L`9_N`9cW09JeP9_Na1oo`9W>B5o
o`40005oo`005Goo00<007ooOol077oo0V<H2Woo0VLi0W_N0THa0QS60Sg_0Woo0Re[0Q240QBU0SF]
0T8@0TYB0PaS0SF]0R480RU:0T8@0PaS0Re[0PQ211cW0R480QS60RU:0Re[0Q240R480QBU0Re[0S6<
0QcW0SF]0QBU0SF]0R480QS60R4812U:0PaS0RU:0R480QS600<U:A2448@00PaS0RU:0Q240S6<0PaS
11cW0Q240SF]0P@Q0QS60RU:0QS60RU:0QS60RU:0QBU0RU:0S6<0PQ20Q240SF]0QcW0R4811cW0T8@
0Q240Re[12DY0U[F0PaS0SW>0T8@0Tic0Vmk0W>L0U[F0Vmk47oo0VLi8Goo0@000Goo000EOol00`00
Oomoo`0HOol2BU84Ool2Nmh2Ool2>Lh2Ool248@2DY@2BU82G_L2Ool2CW<69BT2Ool66<H2BU82AS42
8@P2?Nl27>L26<H27>L29BT2AS4236<2;F/2>Lh2<H`224849BT2:DX2=Jd27>L25:D29BT2=Jd29BT2
2482?Nl27>L248@2:DX224825:D28@P2;F/00acW6<HHaP029BT26<H28@P27>L236<29BT2:DX2;F/2
24827>L2:DX248@2:DX2;F/25:D29BT21242CW<28@P236<2=Jd27>L2<H`2;F/28@P2?Nl28@P2G_L2
;F/27>L2AS428@P2G_L2F]H27>L4Ool2F]H2Ool2=Jd4Ool2CW<2Ool2=Jd8Ool27>L4Ool2E[D6Ool2
HaPAOol10001Ool001Eoo`8001Uoo`9:DPAoo`9kgP9oo`8icP9oo`8@Q09BU09:DP9Nm`9oo`9>L`HU
:@9oo`HHaP9:DP96<@8Q208mk`8Li`8HaP8Li`8U:@96<@8<H`8]J`8icP8aS088@P@U:@8YBP8e[@8L
i`8DY@8U:@8e[@8U:@88@P8mk`8Li`8@Q08YBP88@P8DY@8Q208]J`037>LHaQS6008U:@8HaP8Q208L
i`8<H`8U:@8YBP8]J`88@P8Li`8YBP8@Q08YBP8]J`8DY@8U:@848@9>L`8Q208<H`8e[@8Li`8aS08]
J`8Q208mk`8Q209Nm`8]J`8Li`96<@8Q209Nm`9JeP8Li`Aoo`9JeP9oo`8e[@Aoo`9>L`9oo`8e[@Qo
o`8Li`Aoo`9F]@Ioo`9S611oo`80005oo`005Goo00<007ooOol097oo0VLi0Woo0W_N1Woo0TYB0U:D
0QBU0Re[0Sg_0SF]0QBU0T8@0RDY0QS60P@Q0SW>0RU:0QS60RDY0PaS0QS60PaS0P@Q0S6<0R480QS6
0QBU0RDY10Q20Q240QBU0QS60PaS0QS60QcW0Q240QS60Q240PQ20S6<0Q240P@Q0QcW00<HaPaS36<0
0R480QS60P000Q240RU:0QcW0Q240R480PaS0QS60QcW0RU:0RDY11BU0R480Q240P@Q10aS0QcW0QS6
0QBU0Re[0R480RDY0R480TYB0P@Q0QcW0Re[0RDY0T8@0Sg_0S6<0Sg_0RU:0Woo0V<H0SW>0U:D0U[F
0Woo0Ukg0QBU0Vmk0Sg_0UJe0U[F0TYB0S6<0QBU37oo0VLi3Goo0@000Goo000EOol00`00Oomoo`0T
Ool2IcT2Ool2Nmh6Ool2BU82DY@25:D2;F/2?Nl2=Jd25:D2@Q029BT26<H21242>Lh2:DX26<H29BT2
36<26<H236<21242<H`28@P26<H25:D29BT4248248@25:D26<H236<26<H27>L248@26<H248@22482
<H`248@212427>L00aS636<<H`028@P26<H2000248@2:DX27>L248@28@P236<26<H27>L2:DX29BT4
5:D28@P248@2124436<27>L26<H25:D2;F/28@P29BT28@P2BU8212427>L2;F/29BT2@Q02?Nl2<H`2
?Nl2:DX2Ool2HaP2>Lh2DY@2F]H2Ool2G_L25:D2Kg/2?Nl2E[D2F]H2BU82<H`25:D<Ool2IcT=Ool1
0001Ool001Eoo`03001oogoo01aoo`8e[@Aoo`8aS09:DP9oo`9>L`9g_@9oo`92409W>@9:DP9cW08U
:@8YBP8Q208YBP8U:@8Q208<H`8U:@8e[@8<H`8Li`848@8YBP80008icP8Li`8DY@HQ2088@P848@8<
H`8@Q08HaP8DY@8@Q088@P848@8Li`848@8DY@8<H`88@P8<H`8@Q0848@0336<8@PQ200@8@P800088
@P8Q20848@8@Q0848@8<H`8Li`8DY@8Li`8YBP8Li`8HaP88@P@<H`8HaP8DY@8Li`8U:@@@Q0@Q20@@
Q08aS08Li`8DY@8Q208aS0@@Q08U:@9>L`9:DP9>L`8mk`8]J`8HaP8e[@9:DP8aS08icP9kgP8]J`8a
S09[FP9BU0Qoo`92409Nm`Aoo`9Nm`]oo`40005oo`005Goo00<007ooOol077oo0SF]17oo0S6<0TYB
0Woo0Tic0WNm0Woo0T8@0VLi0TYB0W>L0RDY0RU:0R480RU:0RDY0R480PaS0RDY0SF]0PaS0QcW0P@Q
0RU:0P000SW>0QcW0QBU1R480PQ20P@Q0PaS0Q240QS60QBU0Q240PQ20P@Q0QcW0P@Q0QBU0PaS0PQ2
0PaS0Q240P@Q00<<H`Q2248010Q20P000PQ20R480P@Q0Q240P@Q0PaS0QcW0QBU0QcW0RU:0QcW0QS6
0PQ210aS0QS60QBU0QcW0RDY1124124811240S6<0QcW0QBU0R480S6<11240RDY0Tic0TYB0Tic0Sg_
0Re[0QS60SF]0TYB0S6<0SW>0W_N0Re[0S6<0V]J0U:D27oo0T8@0Ukg17oo0Ukg2goo0@000Goo000E
Ool00`00Oomoo`0POol236<<Ool2G_L2Nmh2Ool2:DX2AS42<H`2;F/2IcT2?Nl2:DX49BT2>Lh248@2
5:D27>L25:D2:DX236<46<H28@P248@212427>L248@236<26<H248@27>L2124224846<H27>L22482
:DX28@P200025:D26<H00b48000000028@P224825:D27>L22482<H`27>L248@236<2=Jd27>L2;F/2
8@P20002;F/248@29BT28@P2248236<26<H2<H`28@P2<H`2;F/25:D2?Nl25:D26<H28@P26<H2=Jd2
:DX29BT27>L2<H`2:DX2;F/28@P25:D26<H2Mkd248@2BU82Kg/2CW<2Ool2G_L2Li`8Ool2JeXGOol1
0001Ool001Eoo`03001oogoo021oo`8<H`aoo`9Nm`9kgP9oo`8YBP96<@8aS08]J`9W>@8mk`8YBP@U
:@8icP8@Q08DY@8Li`8DY@8YBP8<H`@HaP8Q208@Q0848@8Li`8@Q08<H`8HaP8@Q08Li`848@88@P@H
aP8Li`88@P8YBP8Q2080008DY@8HaP038@P00000008Q2088@P8DY@8Li`88@P8aS08Li`8@Q08<H`8e
[@8Li`8]J`8Q2080008]J`8@Q08U:@8Q2088@P8<H`8HaP8aS08Q208aS08]J`8DY@8mk`8DY@8HaP8Q
208HaP8e[@8YBP8U:@8Li`8aS08YBP8]J`8Q208DY@8HaP9g_@8@Q09:DP9_N`9>L`9oo`9Nm`9cW0Qo
o`9[FQMoo`40005oo`005Goo00<007ooOol087oo0S6<17oo0Re[0V]J0Woo0Re[0Woo0TYB0RU:0TYB
0V<H0Woo0V]J0S6<0R480S6<0PaS0S6<0R4811cW0QBU0R480PaS0QBU0Re[0P000P@Q0Q240PaS0R48
0QS60P@Q0PaS11BU0PQ20QS60QBU0PQ211S60Q241PaS0aBU0P0012DY11240QBU0PQ20QS60P@Q0QBU
11S60RDY0PQ20P000PQ20Q240QcW0QBU0QcW10aS0QBU0P@Q0QcW12DY0Q240QBU0QS60QBU0Re[0QS6
0Q2411cW0RU:0QBU0SW>0VLi0U[F0V]J0VLi15Je0S6<0T8@27oo0U:D17oo0S6<0Woo0Ukg0Woo0W>L
3goo0@000Goo000EOol00`00Oomoo`0POol2<H`4Ool2;F/2JeX2Ool2;F/2Ool2BU82:DX2BU82HaP2
Ool2JeX2<H`28@P2<H`236<2<H`28@P47>L25:D28@P236<25:D2;F/20002124248@236<28@P26<H2
124236<45:D224826<H25:D224846<H248@636<35:D200049BT448@25:D224826<H212425:D46<H2
9BT224820002248248@27>L25:D27>L436<25:D212427>L49BT248@25:D26<H25:D2;F/26<H248@4
7>L2:DX25:D2>Lh2IcT2F]H2JeX2IcT4E[D2<H`2@Q08Ool2DY@4Ool2<H`2Ool2G_L2Ool2Li`?Ool1
0001Ool001Eoo`03001oogoo01Yoo`8DY@Qoo`8mk`Aoo`9JePAoo`8e[@8mk`9oo`9JeP@icP8U:@8e
[@92408Li`8HaP@8@P8DY@8@Q08<H`8Li`8]J`8@Q08DY@8<H`@8@P@<H`8HaP8DY@848@8HaP8000@<
H`@@Q08000@HaP8<H`8HaP8DY@0348@8@PQ2008HaP8@Q08DY@8<H`8DY@HHaP@48@8@Q08DY@8@Q084
8@80008Li`HDY@8YBP8HaP8@Q08Li`8<H`88@P8<H`88@P8YBP8Q20@HaP8<H`8]J`8@Q08YBP88@P8U
:@8icP8]J`AJeP9S6092409oo`9F]@9W>@9g_@9:DP9oo`9:DP8]J`Aoo`9g_@9BU09Nm`Aoo`8U:@9o
o`8icPUoo`40005oo`005Goo0P006goo0QBU27oo0Sg_17oo0U[F17oo0SF]0Sg_0Woo0U[F13W>0RDY
0SF]0T8@0QcW0QS610Q20QBU0Q240PaS0QcW0Re[0Q240QBU0PaS10Q210aS0QS60QBU0P@Q0QS60P00
10aS11240P0011S60PaS0QS60QBU00<@Q0Q224800QS60Q240QBU0PaS0QBU1QS610@Q0Q240QBU0Q24
0P@Q0P000QcW1QBU0RU:0QS60Q240QcW0PaS0PQ20PaS0PQ20RU:0R4811S60PaS0Re[0Q240RU:0PQ2
0RDY0SW>0Re[15[F0V<H0T8@0Woo0UJe0VLi0WNm0TYB0Woo0TYB0Re[17oo0WNm0U:D0Ukg17oo0RDY
0Woo0SW>27oo0P000Goo000EOol00`00Oomoo`0JOol2;F/2Ool2HaP4Ool2<H`4Ool2Mkd2Li`2@Q02
6<H2DY@2CW<2<H`2DY@2F]H236<2F]H2=Jd26<H25:D2124200027>L224829BT224829BT248@236<2
2482000236<2000236<224827>L224845:D236<25:D248@2;F/236<25:D436<2248212400`aS5:DD
Y@0248@236<248@26<H6248212425:D436<29BT236<224821242:DX648@29BT2124236<28@P45:D2
24820002;F/28@P236<28@P25:D2CW<2;F/48@P236<2HaP2<H`2>Lh2CW<248@2BU82F]H2G_L2@Q02
DY@2F]H2=Jd4Ool2CW<2DY@2Ool2Nmh2@Q02?NlAOol10001Ool001Eoo`03001oogoo01Yoo`8]J`9o
o`9S60Aoo`8aS0Aoo`9g_@9cW092408HaP9BU09>L`8aS09BU09JeP8<H`9JeP8e[@8HaP8DY@848@80
008Li`88@P8U:@88@P8U:@8@Q08<H`88@P80008<H`80008<H`88@P8Li`88@P@DY@8<H`8DY@8@Q08]
J`8<H`8DY@@<H`88@P848@0336<DYABU008@Q08<H`8@Q08HaPH8@P848@8DY@@<H`8U:@8<H`88@P84
8@8YBPH@Q08U:@848@8<H`8Q20@DY@88@P80008]J`8Q208<H`8Q208DY@9>L`8]J`@Q208<H`9S608a
S08icP9>L`8@Q09:DP9JeP9Nm`92409BU09JeP8e[@Aoo`9>L`9BU09oo`9kgP92408mka5oo`40005o
o`005Goo00<007ooOol02Woo0P@Q77oo0Sg_0T8@0RDY0Re[0Woo0Sg_0RDY0V]J0UJe0THa0QBU0R48
0QS60P@Q0QBU0Sg_0QS611240QS60PaS0QBU0RDY0QcW0Q240RDY0Q240PQ20QBU0QS60Q240PaS0P@Q
0PaS0QS60Q240QBU0Q240PaS0QcW0PaS0PQ20PaS0RU:00<8@PaS36<00PaS0R480QS60PQ20P@Q0PQ2
0P0011240QBU11S60R480QBU0R480PaS0QBU0P0010aS0PQ20PaS11240R480PaS0QS60R480PaS11BU
0RU:0Q240RDY0PaS0QBU0Re[0QBU11S60UJe17oo0V]J0RDY0SW>0T8@0RDY0V]J0VLi0W>L0Woo0Vmk
0Sg_0VLi0Vmk0PQ24Goo0@000Goo000EOol00`00Oomoo`0:Ool2124LOol2?Nl2@Q029BT2;F/2Ool2
?Nl29BT2JeX2E[D2AS425:D28@P26<H212425:D2?Nl26<H448@26<H236<25:D29BT27>L248@29BT2
48@224825:D26<H248@236<2124236<26<H248@25:D248@236<27>L236<2248236<2:DX00`Q236<<
H`0236<28@P26<H2248212422482000448@25:D46<H28@P25:D28@P236<25:D2000436<2248236<4
48@28@P236<26<H28@P236<45:D2:DX248@29BT236<25:D2;F/25:D46<H2E[D4Ool2JeX29BT2>Lh2
@Q029BT2JeX2IcT2Li`2Ool2Kg/2?Nl2IcT2Kg/2248AOol10001Ool001Eoo`03001oogoo00Ioo`8m
k`8@Q11oo`9BU09oo`9S609oo`9cW0Aoo`88@P8mk`9F]@9cW092408@Q08U:@8e[@8Q209>L`@YBP8Q
208U:@8]J`88@P8@Q0@YBP8Li`88@P848@8U:@@<H`88@P@@Q08HaP@DY@8@Q0848@8HaP88@P8HaP8L
i`848@8<H`@DY@@@Q08<H`036<H48@@Q008HaP8<H`@48@8DY@8@Q08HaP8@Q088@P8Li`H@Q0@Li`8<
H`8Li`8<H`8HaP88@P8HaP8<H`8Q208HaP@@Q08DY@88@P8YBP8HaP8U:@88@P8HaP8Li`8]J`9F]@8i
cP8Q2092409>L`9JeP8]J`8@Q08YBP8U:@9Nm`8Li`8mk`ANm`92409oo`9:DP8]J`9g_@9F]@9oo`9c
W0moo`40005oo`005Goo00<007ooOol01Woo0Sg_0Q2447oo0U:D0Woo0V<H0Woo0W>L17oo0PQ20Sg_
0UJe0W>L0T8@0Q240RDY0SF]0R480Tic12U:0R480RDY0Re[0PQ20Q2412U:0QcW0PQ20P@Q0RDY10aS
0PQ211240QS611BU0Q240P@Q0QS60PQ20QS60QcW0P@Q0PaS11BU11240PaS00<HaP@Q12400QS60PaS
10@Q0QBU0Q240QS60Q240PQ20QcW1Q2411cW0PaS0QcW0PaS0QS60PQ20QS60PaS0R480QS611240QBU
0PQ20RU:0QS60RDY0PQ20QS60QcW0Re[0UJe0SW>0R480T8@0Tic0U[F0Re[0Q240RU:0RDY0Ukg0QcW
0Sg_15kg0T8@0Woo0TYB0Re[0WNm0UJe0Woo0W>L3goo0@000Goo000EOol00`00Oomoo`0>Ool2BU8>
Ool2DY@8Ool2DY@2Mkd2@Q02E[D2?Nl2:DX2G_L25:D28@P27>L2=Jd2:DX2000248@412429BT236<2
7>L2124236<25:D212425:D26<H2124236<2248236<4248236<26<H248@236<2000248@224821242
6<H25:D236<25:D236<00aS636<<H`0212445:D2124424826<H22482;F/26<H436<2248248@26<H2
124248@46<H6248236<27>L29BT248@25:D236<26<H25:D236<27>L2;F/236<25:D224828@P2AS42
BU82;F/27>L29BT2AS429BT236<2=Jd2DY@2>Lh2Li`2Nmh2BU82?Nl2CW<2AS42BU82IcT2F]H2Mkd2
;F/=Ool10001Ool001Eoo`03001oogoo00ioo`9:DPioo`9BU0Qoo`9BU09g_@92409F]@8mk`8YBP9N
m`8DY@8Q208Li`8e[@8YBP80008@Q0@48@8U:@8<H`8Li`848@8<H`8DY@848@8DY@8HaP848@8<H`88
@P8<H`@8@P8<H`8HaP8@Q08<H`80008@Q088@P848@8HaP8DY@8<H`8DY@8<H`036<H<H`aS00848@@D
Y@848@@8@P8HaP88@P8]J`8HaP@<H`88@P8@Q08HaP848@8@Q0@HaPH8@P8<H`8Li`8U:@8@Q08DY@8<
H`8HaP8DY@8<H`8Li`8]J`8<H`8DY@88@P8Q2096<@9:DP8]J`8Li`8U:@96<@8U:@8<H`8e[@9BU08i
cP9cW09kgP9:DP8mk`9>L`96<@9:DP9W>@9JeP9g_@8]J`eoo`40005oo`005Goo00<007ooOol03Woo
0Ukg0Woo0Sg_2Woo0S6<1Woo0WNm0Tic0Woo0TYB0QBU0QcW0UJe0RDY0T8@0PaS0S6<0Re[10Q20P@Q
0QBU0PaS0QS60Re[11240QBU0R480Q240QBU0P@Q0Q240P000PaS0QS611240QS60P@Q0QcW0QBU0PQ2
0P@Q0QS60PaS0PQ20R480Q240PaS0Q2400<8@Q2448@00QBU0Q2410aS0Q240PQ211241P@Q0Q240QBU
0PaS0QBU0Q240QcW0Q2410@Q10aS0QS60QBU0PQ211BU0R480Q240QBU0PQ20QS60R480P@Q0RU:0QS6
0Re[0UJe0SF]0RU:0R480Q240PQ20TYB0R480S6<15Je0PQ20VLi0V<H0TYB0RU:0U[F0R480SF]0Woo
0SW>0U:D0Woo0QBU0WNm1goo0@000Goo000EOol2000?Ool2G_L2Ool2?Nl:Ool2<H`6Ool2Mkd2CW<2
Ool2BU825:D27>L2E[D29BT2@Q0236<2<H`2;F/4248212425:D236<26<H2;F/448@25:D28@P248@2
5:D2124248@2000236<26<H448@26<H212427>L25:D2248212426<H236<224828@P248@236<248@0
0`Q248@@Q0025:D248@436<248@2248448@6124248@25:D236<25:D248@27>L248@4124436<26<H2
5:D224845:D28@P248@25:D224826<H28@P21242:DX26<H2;F/2E[D2=Jd2:DX28@P248@22482BU82
8@P2<H`4E[D22482IcT2HaP2BU82:DX2F]H28@P2=Jd2Ool2>Lh2DY@2Ool25:D2Mkd6Ool20001Ool0
01Eoo`03001oogoo00Yoo`9g_@92409[FP8U:@9:DPYoo`9kgPQoo`8Li`9BU08e[@9:DP8YBP9>L`8e
[@8HaP8Q208e[@8<H`8mk`@Q208Li`8HaP8@Q08<H`8Q208U:@8DY@8@Q08YBP848@88@P8@Q08000@D
Y@@@Q0848@8HaP8DY@848@8DY@8YBP80008@Q08Li`8DY@8<H`@8@P035:D<H`aS00@HaP8<H`8@Q08D
Y@8Li`88@P8<H`8DY@8Li`8HaP8DY@848@8DY@848@88@P8YBP8U:@88@P8Q20H<H`8HaP8Q20H<H`@L
i`8Q208<H`8U:@8HaP8@Q08e[@88@P8DY@8Li`8<H`8HaP88@P8aS092408icP8@Q09Nm`8mk`9JeP8D
Y@9Nm`9BU08icP8Q209>L`9W>@8e[@Aoo`9JeP]oo`40005oo`005Goo00<007ooOol02Woo0WNm0T8@
0V]J0RDY0TYB2Woo0W_N27oo0QcW0U:D0SF]0TYB0RU:0Tic0SF]0QS60R480SF]0PaS0Sg_12480QcW
0QS60Q240PaS0R480RDY0QBU0Q240RU:0P@Q0PQ20Q240P0011BU11240P@Q0QS60QBU0P@Q0QBU0RU:
0P000Q240QcW0QBU0PaS10Q200<DY@aS36<011S60PaS0Q240QBU0QcW0PQ20PaS0QBU0QcW0QS60QBU
0P@Q0QBU0P@Q0PQ20RU:0RDY0PQ20R481PaS0QS60R481PaS11cW0R480PaS0RDY0QS60Q240SF]0PQ2
0QBU0QcW0PaS0QS60PQ20S6<0T8@0SW>0Q240Ukg0Sg_0U[F0QBU0Ukg0U:D0SW>0R480Tic0VLi0SF]
17oo0U[F2goo0@000Goo000EOol00`00Oomoo`0:Ool2Li`4Ool2G_L<Ool2Kg/2HaP2DY@2F]H2Ool2
F]H2@Q02;F/2G_L28@P224828@P29BT236<2=Jd28@P29BT2;F/27>L236<26<H236<248@236<26<H2
0002248448@236<248@236<28@P42484124224827>L4248248@25:D248@2248248@212427>L22485
48@224820002248248@424826<H224826<H424829BT27>L29BT26<H236<26<H236<2000448@22482
12447>L248@25:D200027>L248@26<H2;F/28@P248@45:D2124224828@P29BT236<2:DX2;F/25:D2
Kg/26<H2:DX2F]H29BT26<H2BU82?Nl26<H2BU82DY@2HaP4Ool2248;Ool10001Ool001Eoo`03001o
ogoo00Yoo`9cW0Aoo`9Nm`aoo`9_N`9S609BU09JeP9oo`9JeP92408]J`9Nm`8Q2088@P8Q208U:@8<
H`8e[@8Q208U:@8]J`8Li`8<H`8HaP8<H`8@Q08<H`8HaP800088@P@@Q08<H`8@Q08<H`8Q20@8@P@4
8@88@P8Li`@8@P8@Q08DY@8@Q088@P8@Q0848@8Li`88@PD@Q088@P800088@P8@Q0@8@P8HaP88@P8H
aP@8@P8U:@8Li`8U:@8HaP8<H`8HaP8<H`8000@@Q088@P848@@Li`8@Q08DY@80008Li`8@Q08HaP8]
J`8Q208@Q0@DY@848@88@P8Q208U:@8<H`8YBP8]J`8DY@9_N`8HaP8YBP9JeP8U:@8HaP9:DP8mk`8H
aP9:DP9BU09S60Aoo`88@P]oo`40005oo`005Goo00<007ooOol01Woo0VLi0S6<17oo0W_N0Vmk17oo
0W_N0W>L0Woo0V<H0Woo0SF]0UJe0Tic0SW>13F]0THa0QcW0S6<0PQ20R480QcW0PaS0QBU0Re[0SW>
0PaS0QS611BU10Q20QcW0P@Q0PQ20QBU0PaS0P@Q0QBU0PaS0QcW0Q2410@Q0PQ20Q240P@Q11S60PaS
0PQ20PaS0PQ20P000QBU0Q240QBU0P0000<48A2448@00QcW10Q20Q240QcW10aS0PQ20PaS0QS60Q24
0QBU0PQ20PaS0P000PaS0P@Q0QS60PaS0QBU10@Q20aS0Q240PaS0RDY0QcW0Q240PaS0P@Q0QS60QcW
0QS60Q240S6<0Q240PQ20R480RU:0VLi0QcW0RU:0QcW0Re[0SF]0S6<0RDY0SW>0Re[0Sg_0SF]0Sg_
0QS60Tic0V<H0U:D3Goo0@000Goo000EOol00`00Oomoo`06Ool2IcT2<H`4Ool2Nmh2Kg/4Ool2Nmh2
Li`2Ool2HaP2Ool2=Jd2E[D2CW<2>Lh4=Jd2AS427>L2<H`224828@P27>L236<25:D2;F/2>Lh236<2
6<H45:D424827>L2124224825:D236<212425:D236<27>L248@41242248248@212446<H236<22482
36<2248200025:D248@25:D200000`@Q48@@Q0027>L4248248@27>L436<2248236<26<H248@25:D2
248236<2000236<212426<H236<25:D4124836<248@236<29BT27>L248@236<212426<H27>L26<H2
48@2<H`248@224828@P2:DX2IcT27>L2:DX27>L2;F/2=Jd2<H`29BT2>Lh2;F/2?Nl2=Jd2?Nl26<H2
CW<2HaP2DY@=Ool10001Ool001Eoo`03001oogoo009oo`9S60Qoo`9>L`9_N`9oo`9_N`9JeP9S609c
W09g_@9BU09oo`9Nm`9oo`8<H`9[FP8DY@9S608e[@8Q208]J`8Li`8U:@8@Q08HaP8DY@8@Q08icPHQ
208<H`8U:@8DY@8<H`8@Q080008Q2088@P8HaP8@Q08Q208DY@8Li`8@Q08DY@8Li`88@P80008<H`88
@P@<H`8@Q088@P8@Q08000@@Q08<H`03000Q224800H8@P8Li`8@Q0@DY@8@Q0848@8DY@88@P8@Q08H
aP@<H`8Li`@@Q08<H`8000@@Q08DY@8HaP8@Q0800088@P8Li`8@Q08HaP8Q2088@P8Li`88@P@000@@
Q08HaP8U:@8DY@8U:@8HaP9:DP9F]@8Q208mk`9Nm`9JeP8U:@8YBP8Q208U:@9>L`848@8Q209oo`9F
]@96<@9oo`9>L`Uoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Woo0V<H27oo0Tic0Vmk
0Woo0Vmk0U[F0V<H0W>L0WNm0U:D0Woo0Ukg0Woo0PaS0V]J0QBU0V<H0SF]0R480Re[0QcW0RDY0Q24
0QS60QBU0Q240SW>1R480PaS0RDY0QBU0PaS0Q240P000R480PQ20QS60Q240R480QBU0QcW0Q240QBU
0QcW0PQ20P000PaS0PQ210aS0Q240PQ20Q240P0011240PaS00<002488@P01PQ20QcW0Q2411BU0Q24
0P@Q0QBU0PQ20Q240QS610aS0QcW11240PaS0P0011240QBU0QS60Q240P000PQ20QcW0Q240QS60R48
0PQ20QcW0PQ2100011240QS60RDY0QBU0RDY0QS60TYB0UJe0R480Sg_0Ukg0U[F0RDY0RU:0R480RDY
0Tic0P@Q0R480Woo0UJe0THa0Woo0Tic2Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`00
17oo00<007ooOol037oo0Sg_0RU:0RDY0TYB0Sg_0Tic0WNm0TYB17oo0SF]0Woo0QS60T8@0U:D13F]
0RU:0Q240THa0SF]0QBU0PQ20QBU0Q240QBU0QS60S6<0QBU0PaS0R480PQ20RDY0QBU12480PQ20PaS
0P@Q0PaS0QBU0QS60Q240PQ20Q240QBU0P000PaS0QBU0PQ210@Q0Q240QS610aS0P@Q0Q2400<HaP@Q
12400P0011S610Q20R4810Q20P0010aS0QcW0PQ20QS60Q240PaS0QcW0PQ20Q240PaS0P@Q0QS60R48
0Q240PaS0Q240PaS0QBU0Q240QBU0Q240QS60SW>0R480Re[0QBU0PaS0S6<0Re[0P@Q0THa0TYB0R48
0SW>0Q240PQ20THa0SF]0Sg_0RU:0SF]0Re[0P000PaS0R480V]J0Woo0RU:17oo0QS60V]J1goo0@00
0Goo0008Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P003Goo0Sg_0RU:0RDY0TYB0Sg_0Tic0WNm
0TYB17oo0SF]0Woo0QS60T8@0U:D13F]0RU:0Q240THa0SF]0QBU0PQ20QBU0Q240QBU0QS60S6<0QBU
0PaS0R480PQ20RDY0QBU12480PQ20PaS0P@Q0PaS0QBU0QS60Q240PQ20Q240QBU0P000PaS0QBU0PQ2
10@Q0Q240QS610aS0P@Q0Q2400<HaP@Q12400P0011S610Q20R4810Q20P0010aS0QcW0PQ20QS60Q24
0PaS0QcW0PQ20Q240PaS0P@Q0QS60R480Q240PaS0Q240PaS0QBU0Q240QBU0Q240QS60SW>0R480Re[
0QBU0PaS0S6<0Re[0P@Q0THa0TYB0R480SW>0Q240PQ20THa0SF]0Sg_0RU:0SF]0Re[0P000PaS0R48
0V]J0Woo0RU:17oo0QS60V]J1Woo0P000Goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo
00<007ooOol02Woo0R480SW>0Q240Tic0V<H17oo0Ukg0W>L17oo0UJe0Woo0QS60WNm0R480Sg_0RDY
0S6<10Q20Re[11S60PaS0QBU0PaS0Q240RDY0P@Q0QBU0RDY0PaS0PQ20QBU0Q240PaS11BU0PaS1PQ2
0P@Q0Q240PQ20Q240PaS0QcW0Q240PQ20QS60PaS1PQ20P@Q0PaS0Q240`Q20PaS0Q240P000QBU0R48
0P000PaS0QcW0PQ221240QS60P@Q0RDY10Q20QcW0P@Q0Q240PQ20QS60P000QcW0PQ20QBU0Q240R48
0QcW0Q240P@Q0R480QBU0RU:0R480Re[0QBU0R480QS60T8@0RDY0Sg_0Re[0RDY0TYB0Re[0R480T8@
0RU:0SF]0QS60Q240QBU0Sg_0W_N0R480Woo0W_N0Woo0V<H2Goo0@000Goo0007Ool01000Oomoo`00
0Woo00@007ooOol000Aoo`03001oogoo00Yoo`8Q208icP8@Q09>L`9S60Aoo`9Nm`9cW0Aoo`9F]@9o
o`8HaP9g_@8Q208mk`8U:@8aS0@8@P8]J`@HaP8<H`8DY@8<H`8@Q08U:@848@8DY@8U:@8<H`88@P8D
Y@8@Q08<H`@DY@8<H`H8@P848@8@Q088@P8@Q08<H`8Li`8@Q088@P8HaP8<H`H8@P848@8<H`8@Q0<8
@P8<H`8@Q080008DY@8Q2080008<H`8Li`88@PP@Q08HaP848@8U:@@8@P8Li`848@8@Q088@P8HaP80
008Li`88@P8DY@8@Q08Q208Li`8@Q0848@8Q208DY@8YBP8Q208]J`8DY@8Q208HaP92408U:@8mk`8]
J`8U:@9:DP8]J`8Q2092408YBP8e[@8HaP8@Q08DY@8mk`9kgP8Q209oo`9kgP9oo`9S60Uoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol01Woo0Ukg0V<H0Woo0W>L0Re[0V<H17oo0UJe0Tic0V<H
0Woo0T8@0Woo0V<H0WNm0UJe0SF]13W>0RDY0QS60S6<0Q2411cW0QBU0PaS0P001QBU0Q240P@Q0Q24
0P@Q1Q240RU:0PQ20P@Q0PQ20P@Q11240QBU0Q241PQ21PaS0Q240P@Q0PQ211BU0PaS0P0000<DYA24
48@00P@Q10Q20PaS0P@Q0PQ20QBU0PaS1PQ20PaS0P@Q0QcW0QS60PQ20Q240PQ20R480Q240P000QBU
10aS0P@Q0PQ20QcW0Q240P@Q11BU0RDY0QBU0Q240PQ20SW>0QcW0Q240Re[0T8@0QBU0RDY0Tic0RDY
0QcW0QBU0RDY0QS60RDY0R480Tic0P@Q0PaS0Re[0Tic0SW>0Re[0U[F0W_N0SF]2goo0@000Goo000E
Ool00`00Oomoo`06Ool2G_L2HaP2Ool2Li`2;F/2HaP4Ool2E[D2CW<2HaP2Ool2@Q02Ool2HaP2Mkd2
E[D2=Jd4>Lh29BT26<H2<H`248@47>L25:D236<200065:D248@2124248@2124648@2:DX224821242
2482124448@25:D248@6248636<248@2124224845:D236<200000aBU48@@Q0021244248236<21242
24825:D236<6248236<212427>L26<H2248248@224828@P248@200025:D436<2124224827>L248@2
12445:D29BT25:D248@22482>Lh27>L248@2;F/2@Q025:D29BT2CW<29BT27>L25:D29BT26<H29BT2
8@P2CW<2124236<2;F/2CW<2>Lh2;F/2F]H2Nmh2=Jd;Ool10001Ool001Eoo`03001oogoo00Ioo`9[
FP9JeP9oo`9F]@9>L`Aoo`9BU08@Q08DY@8e[@ANm`9oo`8aS09oo`9S60@]J`8mk`8@Q08DY@848@8<
H`88@P8U:@8<H`8DY@8Q208@Q08DY@8<H`8HaP@<H`H48@8DY@H8@P8@Q08<H`88@P8@Q08DY@848@80
00@48@8<H`8@Q0@<H`848@8<H`8@Q088@P848@88@P0336<DYABU008@Q0848@80008HaP8@Q08DY@8<
H`8DY@88@P848@8000@<H`8Q20H@Q088@P8@Q088@P8@Q08DY@8<H`8Li`8@Q088@P8DY@80008Li`8<
H`8DY@8@Q08HaP88@P848@8Q208]J`HaS0@8@P8U:@80008]J`848@8Li`8e[@8]J`8Q208HaP8Li`8Q
2092408Li`8]J`9>L`9[FPA>L`]oo`40005oo`005Goo00<007ooOol01Woo0V]J0U[F0Woo0UJe0Tic
17oo0U:D0Q240QBU0SF]15kg0Woo0S6<0Woo0V<H12e[0Sg_0Q240QBU0P@Q0PaS0PQ20RDY0PaS0QBU
0R480Q240QBU0PaS0QS610aS1P@Q0QBU1PQ20Q240PaS0PQ20Q240QBU0P@Q0P0010@Q0PaS0Q2410aS
0P@Q0PaS0Q240PQ20P@Q0PQ200<<HaBU5:D00Q240P@Q0P000QS60Q240QBU0PaS0QBU0PQ20P@Q0P00
10aS0R481Q240PQ20Q240PQ20Q240QBU0PaS0QcW0Q240PQ20QBU0P000QcW0PaS0QBU0Q240QS60PQ2
0P@Q0R480Re[1S6<10Q20RDY0P000Re[0P@Q0QcW0SF]0Re[0R480QS60QcW0R480T8@0QcW0Re[0Tic
0V]J14ic2goo0@000Goo000EOol00`00Oomoo`02Ool2>Lh6Ool2Mkd28@P2F]H2@Q02F]H2?Nl2<H`2
48@2AS42:DX4JeX2CW<2Ool2<H`2G_L2;F/2>Lh25:D248@29BT26<H25:D29BT25:D436<25:D26<H2
8@P2124248@27>L2:DX224827>L236<2248236<26<H25:D28@P236<25:D212425:D424827>L26<H2
48@25:D4124200025:D2124248@224800acW48@@Q0021244248236<412425:D2248436<25:D248@2
5:D2124236<25:D224827>L248@2124436<26<H25:D27>L26<H25:D26<H22484124248@2248248@2
>Lh26<H224826<H2BU828@P212427>L636<28@P2:DX26<H2;F/29BT2<H`2;F/2AS42>Lh2;F/2@Q02
Ool2AS425:D2Ool2HaP9Ool10001Ool001Eoo`03001oogoo009oo`8icPIoo`9g_@8Q209JeP92409J
eP8mk`8aS08@Q096<@8YBPA[FP9>L`9oo`8aS09Nm`8]J`8icP8DY@8@Q08U:@8HaP8DY@8U:@8DY@@<
H`8DY@8HaP8Q20848@8@Q08Li`8YBP88@P8Li`8<H`88@P8<H`8HaP8DY@8Q208<H`8DY@848@8DY@@8
@P8Li`8HaP8@Q08DY@@48@80008DY@848@8@Q088@P037>L@Q12400848@@8@P8<H`@48@8DY@88@P@<
H`8DY@8@Q08DY@848@8<H`8DY@88@P8Li`8@Q0848@@<H`8HaP8DY@8Li`8HaP8DY@8HaP88@P@48@8@
Q088@P8@Q08icP8HaP88@P8HaP9:DP8Q20848@8Li`H<H`8Q208YBP8HaP8]J`8U:@8aS08]J`96<@8i
cP8]J`92409oo`96<@8DY@9oo`9S60Uoo`40005oo`005Goo00<007ooOol00Woo0U:D1Woo0R480QBU
0P000Q240V]J0Vmk0VLi0S6<0UJe0Re[0Woo0THa0U[F0Woo0S6<0W>L0QBU0R480Q240R480QBU0Q24
0P@Q0QS60R480QcW0PaS0Q240R480QS610Q20P@Q0QBU0P@Q0Q240PQ220aS0QBU0QcW0Q2420aS10Q2
0PaS10@Q10Q20P@Q0Q240PQ20QS600<8@Q2448@00Q241PaS0QS60Q240P000P@Q0QS60PaS0PQ20PaS
11BU0QS611240P@Q0Q240PQ20Q240PQ20PaS0QS60P@Q0QBU0PaS0Q240RU:0PaS0P@Q0RU:0Q240QcW
0Re[0QS60QBU11S60RDY12480Q240S6<0P000THa0QS60P@Q0Sg_0QcW0PaS0SF]0Re[0QS60PQ20U:D
0V]J0Tic0RDY0Woo0RU:0V]J1goo0@000Goo000EOol20003Ool2DY@6Ool28@P25:D2000248@2JeX2
Kg/2IcT2<H`2E[D2;F/2Ool2AS42F]H2Ool2<H`2Li`25:D28@P248@28@P25:D248@212426<H28@P2
7>L236<248@28@P26<H4248212425:D2124248@2248836<25:D27>L248@836<4248236<412442482
124248@224826<H00`Q248@@Q00248@636<26<H248@2000212426<H236<2248236<45:D26<H448@2
124248@2248248@2248236<26<H212425:D236<248@2:DX236<21242:DX248@27>L2;F/26<H25:D4
6<H29BT48@P248@2<H`20002AS426<H21242?Nl27>L236<2=Jd2;F/26<H22482DY@2JeX2CW<29BT2
Ool2:DX2JeX6Ool20001Ool001Eoo`03001oogoo00Qoo`9W>@9F]@8HaP@e[@9oo`9_N`8YBP9JeP8Y
BP92409S608U:@9[FP96<@9:DP9W>@8HaP924088@P8<H`@Q208@Q08aS08DY@@@Q0@000@8@P8Li`8D
Y@8<H`848@8DY@@@Q08Q20@8@P8<H`88@P8<H`8@Q08HaP8@Q08<H`88@P8<H`8Li`8@Q08<H`8DY@H<
H`80008<H`0324848@@Q008DY@88@P848@8HaP88@P80008@Q0848@8Li`848@8@Q0H8@P8Li`80008@
Q080008@Q080008DY@8000848@88@P8DY@88@P8DY@88@P848@8@Q08YBPH@Q08DY@8Li`848@8DY@8<
H`8@Q0848@@Q208U:@88@P8Q208@Q08U:@92408@Q08Li`8]J`8U:@@Q209:DP92408icP8YBP9>L`8D
Y@96<@Moo`40005oo`005Goo00<007ooOol027oo0VLi0UJe0QS613F]0Woo0Vmk0RU:0U[F0RU:0T8@
0V<H0RDY0V]J0THa0TYB0VLi0QS60T8@0PQ20PaS12480Q240S6<0QBU1124100010Q20QcW0QBU0PaS
0P@Q0QBU11240R4810Q20PaS0PQ20PaS0Q240QS60Q240PaS0PQ20PaS0QcW0Q240PaS0QBU1PaS0P00
0PaS00<8@P@Q12400QBU0PQ20P@Q0QS60PQ20P000Q240P@Q0QcW0P@Q0Q241PQ20QcW0P000Q240P00
0Q240P000QBU0P000P@Q0PQ20QBU0PQ20QBU0PQ20P@Q0Q240RU:1Q240QBU0QcW0P@Q0QBU0PaS0Q24
0P@Q12480RDY0PQ20R480Q240RDY0T8@0Q240QcW0Re[0RDY12480TYB0T8@0SW>0RU:0Tic0QBU0THa
1goo0@000Goo000EOol00`00Oomoo`06Ool2Mkd26<H2Li`47>L2JeX2Ool2G_L25:D29BT4@Q0248@2
;F/2DY@22482Kg/2Li`2@Q02<H`25:D248@29BT46<H25:D236<2<H`236<25:D20002248248@21242
36<2124236<248@224825:D224827>L48@P2248236<212422484124436<25:D2000248@26<H22482
124248@224825:D336<248@4248236<2000236<4124436<2000236<2248248@412425:D2248236<4
0002248236<448@26<H25:D2248248@236<25:D224825:D26<H236<28@P212467>L2:DX25:D236<2
5:D29BT28@P236<29BT224829BT2:DX2;F/248@4:DX2@Q02<H`2@Q02<H`2@Q02E[D9Ool10001Ool0
01Eoo`03001oogoo00Ioo`9g_@8HaP9cW0@Li`9[FP9oo`9Nm`8DY@8U:@A2408@Q08]J`9BU088@P9_
N`9cW092408aS08DY@8@Q08U:@@HaP8DY@8<H`8aS08<H`8DY@800088@P8@Q0848@8<H`848@8<H`8@
Q088@P8DY@88@P8Li`@Q2088@P8<H`848@88@P@48@@<H`8DY@80008@Q08HaP88@P848@8@Q088@P8D
Y@<<H`8@Q0@8@P8<H`80008<H`@48@@<H`80008<H`88@P8@Q0@48@8DY@88@P8<H`@00088@P8<H`@@
Q08HaP8DY@88@P8@Q08<H`8DY@88@P8DY@8HaP8<H`8Q20848@HLi`8YBP8DY@8<H`8DY@8U:@8Q208<
H`8U:@88@P8U:@8YBP8]J`8@Q0@YBP92408aS092408aS092409F]@Uoo`40005oo`005Goo00<007oo
Ool01Woo0W_N0RU:0Woo0PaS0QS60Tic0U:D0SF]0QS60P@Q0QS60PQ20RDY0Ukg0RDY0Re[0Woo0RDY
0VLi0SW>0QBU0QcW0QBU0RDY0QcW0P@Q0Q240PaS0PQ20R480QS60PaS0P000QBU10aS0P000PQ21124
10aS1P@Q0QcW0PaS0P@Q0PaS0PQ20PaS0P@Q0PQ20PaS0P@Q10Q20P000QBU0PQ20`@Q0QcW0PaS0P@Q
0Q240PaS0PQ210@Q0P000PQ211240PQ20PaS0QBU0P@Q0P0011240PaS0QS60P@Q0Q240PQ20P@Q0Q24
0P@Q0PaS0P@Q0PQ20QcW0Q240QS60Q240QcW0QBU0PaS0P000R480PQ20Q240QS60P@Q0RU:0Q240R48
0QS60SW>0RU:0R480SW>0Re[0P@Q0Re[0Sg_10aS0U:D0RU:0PaS0Re[0U:D2Goo0@000Goo000EOol0
0`00Oomoo`06Ool2Nmh2:DX2Ool236<26<H2CW<2DY@2=Jd26<H212426<H224829BT2G_L29BT2;F/2
Ool29BT2IcT2>Lh25:D27>L25:D29BT27>L2124248@236<224828@P26<H236<200025:D436<20002
248448@436<612427>L236<2124236<2248236<21242248236<21244248200025:D2248312427>L2
36<2124248@236<2248412420002248448@2248236<25:D21242000448@236<26<H2124248@22482
124248@2124236<2124224827>L248@26<H248@27>L25:D236<200028@P2248248@26<H21242:DX2
48@28@P26<H2>Lh2:DX28@P2>Lh2;F/21242;F/2?Nl436<2DY@2:DX236<2;F/2DY@9Ool10001Ool0
01Eoo`03001oogoo009oo`8icPAoo`9cW09F]@92408U:@8Li`8mk`96<@8e[@96<@8YBP8Q209BU09S
6088@P9BU09JeP8U:@9:DP8U:@8]J`8<H`8DY@8YBP8<H`8aS08<H`@DY@8Li`80008DY@8<H`8Li`8@
Q08YBP8@Q0848@8@Q08Q208HaP8<H`8DY@8<H`8DY@848@8DY@8@Q0@<H`88@P@48@8<H`848@8@Q0@4
8@88@P848@80000336<8@PQ2008<H`8000H48@@<H`88@P848@@8@P80008@Q08000848@8DY@88@P8H
aP8DY@8<H`8Li`8Q20848@88@P848@8@Q08Li`88@P8DY@8<H`@@Q08DY@8YBP@DY@8<H`8DY@8@Q08U
:@88@P8HaP88@P848@8U:@92408Li`8<H`@U:@88@P8icP8DY@8Li`8@Q08]J`9JeP8<H`8aS09S609N
m`Uoo`40005oo`005Goo00<007ooOol00Woo0SW>17oo0W>L0UJe0T8@0RDY0QcW0Sg_0THa0SF]0THa
0RU:0R480U:D0V<H0PQ20U:D0U[F0RDY0TYB0RDY0Re[0PaS0QBU0RU:0PaS0S6<0PaS11BU0QcW0P00
0QBU0PaS0QcW0Q240RU:0Q240P@Q0Q240R480QS60PaS0QBU0PaS0QBU0P@Q0QBU0Q2410aS0PQ210@Q
0PaS0P@Q0Q2410@Q0PQ20P@Q0P0000<<H`Q224800PaS0P001P@Q10aS0PQ20P@Q10Q20P000Q240P00
0P@Q0QBU0PQ20QS60QBU0PaS0QcW0R480P@Q0PQ20P@Q0Q240QcW0PQ20QBU0PaS11240QBU0RU:11BU
0PaS0QBU0Q240RDY0PQ20QS60PQ20P@Q0RDY0T8@0QcW0PaS12DY0PQ20SW>0QBU0QcW0Q240Re[0U[F
0PaS0S6<0V<H0Ukg2Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H4Ool2IcT2?Nl28@P27>L248@2
BU82E[D2=Jd2>Lh2=Jd236<2E[D2<H`26<H2<H`2>Lh2<H`2>Lh29BT26<H2;F/448@224826<H25:D2
36<29BT2:DX25:D212425:D248@2000248@25:D27>L25:D236<248@25:D236<200045:D248@236<2
000248@2124424825:D236<4124236<2248436<00`Q248@@Q002248212422482000236<26<H22482
8@P4248200042482000248@20002248648@236<2248448@22482124236<25:D424826<H25:D42482
7>L25:D212429BT224827>L224829BT48@P236<28@P448@29BT21242:DX29BT248@2:DX29BT2;F/2
=Jd248@26<H2HaP2>Lh9Ool10001Ool001Eoo`8000=oo`9JePAoo`9W>@8mk`8Q208Li`8@Q09:DP9F
]@8e[@8icP8e[@8<H`9F]@8aS08HaP8aS08icP8aS08icP8U:@8HaP8]J`@@Q088@P8HaP8DY@8<H`8U
:@8YBP8DY@848@8DY@8@Q080008@Q08DY@8Li`8DY@8<H`8@Q08DY@8<H`8000@DY@8@Q08<H`80008@
Q0848@@8@P8DY@8<H`@48@8<H`88@P@<H`03248@Q1240088@P848@88@P80008<H`8HaP88@P8Q20@8
@P8000@8@P80008@Q0800088@PH@Q08<H`88@P@@Q088@P848@8<H`8DY@@8@P8HaP8DY@@8@P8Li`8D
Y@848@8U:@88@P8Li`88@P8U:@@Q208<H`8Q20@@Q08U:@848@8YBP8U:@8@Q08YBP8U:@8]J`8e[@8@
Q08HaP9S608icPQoo`80005oo`005Goo00<007ooOol027oo0THa0S6<0Re[0RU:0Re[0THa0UJe0QcW
0SF]0RU:0R480Q240RDY0Re[0T8@0QcW0THa0QBU0QS60Sg_0RDY0PaS0QBU0R480PQ20QBU0QcW10Q2
0P@Q0QcW0Q2411BU0PaS0QS60PaS0P@Q10Q20P@Q0P000PQ210@Q0Q240PaS11240PaS10Q20P@Q0Q24
0P@Q0Q240P000PaS0Q240PaS00<Li`aS36<00P@Q10Q20PaS0P@Q0PaS0PQ20P@Q0QBU0P@Q11BU0PQ2
0PaS112410@Q0PQ20PaS0PQ20P0010Q20PaS10@Q0QS60PQ20RU:11S60Q2410Q20P@Q0P000PQ20PaS
0PQ21PaS0R480RU:0PQ20QS60RU:0PaS0R480RU:0PaS0Q240RU:0Q240RDY0PaS0QS60S6<0TYB0THa
0VLi1goo0@000Goo000EOol00`00Oomoo`08Ool2AS42<H`2;F/2:DX2;F/2AS42E[D27>L2=Jd2:DX2
8@P248@29BT2;F/2@Q027>L2AS425:D26<H2?Nl29BT236<25:D28@P224825:D27>L4248212427>L2
48@45:D236<26<H236<212442482124200022484124248@236<448@236<42482124248@2124248@2
000236<248@236<00acW36<<H`021244248236<2124236<2248212425:D212445:D2248236<448@4
1242248236<224820004248236<412426<H22482:DX46<H248@4248212420002248236<2248636<2
8@P2:DX224826<H2:DX236<28@P2:DX236<248@2:DX248@29BT236<26<H2<H`2BU82AS42IcT7Ool1
0001Ool001Eoo`03001oogoo00Ioo`9F]@8U:@9F]@8@Q0800092408aS08icP8HaP8Li`8HaP8@Q08D
Y@8U:@8mk`848@8e[@8]J`8Li`8icP8YBP8Li`8<H`8U:@8HaP8<H`8@Q0@HaP8@Q08HaP88@P8@Q0@4
8@8DY@8<H`88@P848@8<H`88@P800088@P@48@88@P8<H`848@88@P8<H`88@P8@Q0P48@8@Q08HaP8@
Q08Li`8000035:D48@@Q008HaP88@P8<H`848@88@P8@Q0@8@P@<H`@48@8@Q08<H`8@Q08DY@@8@P8@
Q088@P848@P8@P8<H`8DY@8@Q088@P8<H`8HaP8DY@848@80008HaP8<H`8HaP8<H`8HaP848@8@Q08L
i`8<H`8@Q08icP88@P8aS08@Q08DY@8]J`8e[@80008@Q0848@9:DP8DY@8Q208YBP8U:@9>L`8]J`9B
U0Moo`40005oo`005Goo00<007ooOol01Woo0UJe0RDY0UJe0Q240P000T8@0S6<0SW>0QS60QcW0QS6
0Q240QBU0RDY0Sg_0P@Q0SF]0Re[0QcW0SW>0RU:0QcW0PaS0RDY0QS60PaS0Q2411S60Q240QS60PQ2
0Q2410@Q0QBU0PaS0PQ20P@Q0PaS0PQ20P000PQ210@Q0PQ20PaS0P@Q0PQ20PaS0PQ20Q2420@Q0Q24
0QS60Q240QcW0P0000<DY@@Q12400QS60PQ20PaS0P@Q0PQ20Q2410Q210aS10@Q0Q240PaS0Q240QBU
10Q20Q240PQ20P@Q20Q20PaS0QBU0Q240PQ20PaS0QS60QBU0P@Q0P000QS60PaS0QS60PaS0QS60P@Q
0Q240QcW0PaS0Q240SW>0PQ20S6<0Q240QBU0Re[0SF]0P000Q240P@Q0TYB0QBU0R480RU:0RDY0Tic
0Re[0U:D1goo0@000Goo000EOol00`00Oomoo`02Ool2Nmh2Ool2AS42@Q02?Nl26<H2:DX2;F/45:D2
7>L248@2;F/26<H29BT2?Nl28@P29BT2<H`26<H4>Lh248@29BT248@28@P248@29BT25:D2248248@2
248436<248@224826<H212425:D400027>L2124648@212425:D4248248@2000224825:D2124236<4
0002124236<248@22483124248@2124236<212422482000624821244248200027>L41242248248@2
124248@41242248236<2124436<4248248@236<212425:D4248212425:D200026<H2000248@236<2
8@P248@29BT48@P27>L2:DX27>L2;F/4:DX248@29BT236<26<H2?Nl25:D2CW<2HaP2E[D9Ool10001
Ool001Eoo`03001oogoo009oo`9kgP9oo`96<@92408mk`8HaP8YBP8]J`@DY@8Li`8@Q08]J`8HaP8U
:@8mk`8Q208U:@8aS08HaP@icP8@Q08U:@8@Q08Q208@Q08U:@8DY@88@P8@Q088@P@<H`8@Q088@P8H
aP848@8DY@@0008Li`848@H@Q0848@8DY@@8@P8@Q0800088@P8DY@848@8<H`@000848@8<H`8@Q088
@P<48@8@Q0848@8<H`848@88@P8000H8@P848@@8@P80008Li`@48@88@P8@Q0848@8@Q0@48@88@P8<
H`848@@<H`@8@P8@Q08<H`848@8DY@@8@P848@8DY@80008HaP80008@Q08<H`8Q208@Q08U:@@Q208L
i`8YBP8Li`8]J`@YBP8@Q08U:@8<H`8HaP8mk`8DY@9>L`9S609F]@Uoo`40005oo`005Goo00<007oo
Ool00Woo0V<H17oo15:D0SF]136<0QcW0P000RU:0Re[0S6<0PQ20T8@0U:D0RDY0RU:0SF]0QcW0THa
0Q240RU:11BU0RU:0PQ211cW0P000QS60RU:0PQ20RDY0Q240P@Q0QBU0P@Q0Q240PQ20QS60P@Q0PQ2
0QBU0Q240PQ20Q2410Q20PaS0PQ210aS0P@Q0PaS0P@Q10Q220@Q0P0000<DY@Q224800PQ20P@Q0QBU
0PaS0P@Q0PQ20PaS0P000P@Q0PQ20P000PQ20P000QBU0Q240PQ210000Q240PQ20PaS0QBU0PaS0Q24
0QS610@Q0PaS0PQ20P000R480P000P@Q0QcW0P@Q0QBU0PQ20QS60P@Q0PaS0Q240PaS0QS60PQ20Q24
0RU:0PaS0PQ20QcW0R480PaS0Re[0RDY0Q240QcW0Re[0QS60Re[0QS60WNm0W_N2Goo0@000Goo000E
Ool00`00Oomoo`02Ool2HaP4Ool4DY@2=Jd4<H`27>L20002:DX2;F/2<H`22482@Q02DY@29BT2:DX2
=Jd27>L2AS4248@2:DX45:D2:DX224847>L200026<H2:DX224829BT248@212425:D2124248@22482
6<H2124224825:D248@2248248@4248236<2248436<2124236<212442488124200000aBU2488@P02
248212425:D236<21242248236<20002124224820002248200025:D248@22484000248@2248236<2
5:D236<248@26<H4124236<2248200028@P2000212427>L212425:D224826<H2124236<248@236<2
6<H2248248@2:DX236<224827>L28@P236<2;F/29BT248@27>L2;F/26<H2;F/26<H2Mkd2Nmh9Ool1
0001Ool001Eoo`03001oogoo009oo`9Nm`Aoo`8e[@8icP@]J`8Q20@HaP8DY@8<H`8YBP8Li`8@Q08a
S08YBP8aS08<H`8]J`8U:@8<H`8DY@88@P8HaP@@Q08DY@8Li`8<H`8@Q08DY@@8@P8@Q0@<H`H48@8<
H`8Li`8@Q0848@8<H`8@Q08<H`8@Q0848@@8@P848@@<H`8@Q08000H8@P8@Q088@P80008HaP0336<4
8@@Q008DY@H8@P8DY@848@8000848@8<H`88@P848@88@P@@Q08<H`80008Li`8<H`88@P8DY@8000@@
Q08000P@Q08<H`848@8HaP8@Q0@8@P@@Q08<H`848@@8@P8<H`8DY@8mk`8HaP@Li`8@Q08Li`8<H`8Y
BP8DY@8aS08@Q08DY@8@Q08DY@8Li`@<H`ANm`Uoo`40005oo`005Goo0P000goo0Ukg17oo0SF]0SW>
12e[0R4811S60QBU0PaS0RU:0QcW0Q240S6<0RU:0S6<0PaS0Re[0RDY0PaS0QBU0PQ20QS611240QBU
0QcW0PaS0Q240QBU10Q20Q2410aS1P@Q0PaS0QcW0Q240P@Q0PaS0Q240PaS0Q240P@Q10Q20P@Q10aS
0Q240P001PQ20Q240PQ20P000QS600<<H`@Q12400QBU1PQ20QBU0P@Q0P000P@Q0PaS0PQ20P@Q0PQ2
11240PaS0P000QcW0PaS0PQ20QBU0P0011240P0021240PaS0P@Q0QS60Q2410Q211240PaS0P@Q10Q2
0PaS0QBU0Sg_0QS611cW0Q240QcW0PaS0RU:0QBU0S6<0Q240QBU0Q240QBU0QcW10aS15kg27oo0P00
0Goo000EOol00`00Oomoo`02Ool2BU84Ool2>Lh2@Q028@P248@26<H28@P25:D26<H25:D236<248@2
24829BT25:D224826<H2>Lh236<2>Lh248@46<H200025:D236<248@25:D2000224827>L2248436<2
48@26<H27>L224825:D200027>L236<248@2248248@236<27>L25:D236<22482124436<4124248@4
248236<412400acW12448@0436<248@2124448@21242248236<26<H248@20002248248@2124436<2
48@436<2124236<2000248@46<H2124224826<H25:D2248236<248@236<46<H4248248@2124248@2
36<2000236<2<H`22482;F/29BT236<2;F/29BT25:D236<25:D28@P248@29BT21242:DX2BU82?Nl2
G_L7Ool10001Ool001Eoo`03001oogoo009oo`9:DPAoo`8icP92408Q208@Q08HaP8Q208DY@8HaP8D
Y@8<H`8@Q088@P8U:@8DY@88@P8HaP8icP8<H`8icP8@Q0@HaP80008DY@8<H`8@Q08DY@800088@P8L
i`88@P@<H`8@Q08HaP8Li`88@P8DY@80008Li`8<H`8@Q088@P8@Q08<H`8Li`8DY@8<H`88@P848@@<
H`@48@8@Q0@8@P8<H`@48@037>L48@@Q00@<H`8@Q0848@@@Q0848@88@P8<H`8HaP8@Q0800088@P8@
Q0848@@<H`8@Q0@<H`848@8<H`80008@Q0@HaP848@88@P8HaP8DY@88@P8<H`8@Q08<H`@HaP@8@P8@
Q0848@8@Q08<H`80008<H`8aS088@P8]J`8U:@8<H`8]J`8U:@8DY@8<H`8DY@8Q208@Q08U:@848@8Y
BP9:DP8mk`9Nm`Moo`40005oo`005Goo00<007ooOol00Woo0VLi0Woo0W_N0Sg_0SF]0QBU0QS60S6<
0R480PaS11cW0Q240RU:0Q240RDY0QBU0P@Q0QcW0QBU0P@Q0T8@10@Q0RU:0P@Q0PaS10Q20Q2410Q2
0PaS0Q2421BU0PaS0P000QBU0PaS0QS60PQ20QBU0PQ20QBU0PaS0Q240P@Q0PaS0PQ20P@Q0PaS0PQ2
1P@Q1PQ210@Q00<DY@aS36<00P000P@Q0PQ20Q240PQ20P@Q11240PaS0P@Q0Q240PaS0Q240P000PQ2
0PaS0Q240QBU0P@Q0P000P@Q0Q240QBU0Q240QBU0PQ20QS610@Q0PQ20Q240QcW0P@Q0PQ20Re[0P00
0QS60QBU0PQ21PaS1QS60RU:0QS612480QcW0S6<10Q20RDY11S60SW>0Q240Sg_0Re[0Q240Ukg1goo
0@000Goo000EOol00`00Oomoo`02Ool2IcT2Ool2Nmh2?Nl2=Jd25:D26<H2<H`28@P236<47>L248@2
:DX248@29BT25:D212427>L25:D21242@Q041242:DX2124236<4248248@4248236<248@85:D236<2
00025:D236<26<H224825:D224825:D236<248@2124236<22482124236<224861246248412400aBU
36<<H`0200021242248248@22482124448@236<2124248@236<248@20002248236<248@25:D21242
0002124248@25:D248@25:D224826<H41242248248@27>L212422482;F/200026<H25:D2248636<6
6<H2:DX26<H48@P27>L2<H`424829BT46<H2>Lh248@2?Nl2;F/248@2G_L7Ool10001Ool001Eoo`03
001oogoo009oo`9F]@9oo`9_N`9>L`92408U:@8@Q08HaP848@8]J`8<H`8aS08DY@8]J`8HaP8DY@84
8@8Li`8U:@8HaP88@P@HaP8U:@88@P8HaP8<H`8@Q0H8@P8HaP88@P848@88@PH@Q08<H`88@P800084
8@8<H`8DY@848@8@Q0848@8@Q0800088@P@@Q080008<H`848@88@P848@P<H`8DY@88@P031248@PQ2
008@Q08<H`848@80008<H`8@Q08Q208000848@8<H`8Li`8<H`88@P848@8DY@88@P@48@88@P@@Q088
@P8<H`88@P8DY@848@8<H`8DY@800088@P8Li`8@Q08HaP8<H`8DY@848@8DY@88@P8000@48@@8@P8D
Y@8<H`8Li`@@Q08Q208DY@80008DY@8U:@8@Q088@P8U:@8Li`8@Q08YBP96<@8mk`9S60Moo`40005o
o`005Goo00<007ooOol00Woo0UJe0Woo0Vmk0Tic0T8@0RDY0Q240QS60P@Q0Re[0PaS0S6<0QBU0Re[
0QS60QBU0P@Q0QcW0RDY0QS60PQ211S60RDY0PQ20QS60PaS0Q241PQ20QS60PQ20P@Q0PQ21Q240PaS
0PQ20P000P@Q0PaS0QBU0P@Q0Q240P@Q0Q240P000PQ211240P000PaS0P@Q0PQ20P@Q20aS0QBU0PQ2
00<48@Q224800Q240PaS0P@Q0P000PaS0Q240R480P000P@Q0PaS0QcW0PaS0PQ20P@Q0QBU0PQ210@Q
0PQ211240PQ20PaS0PQ20QBU0P@Q0PaS0QBU0P000PQ20QcW0Q240QS60PaS0QBU0P@Q0QBU0PQ20P00
10@Q10Q20QBU0PaS0QcW11240R480QBU0P000QBU0RDY0Q240PQ20RDY0QcW0Q240RU:0THa0Sg_0V<H
1goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2Ool2IcT2AS428@P2:DX2124236<248@25:D21242
:DX29BT28@P236<26<H45:D224825:D26<H236<22482:DX65:D2248248@436<26<H22486124448@2
000236<200026<H448@236<248@212425:D236<4248248@25:D236<412426<H212425:D212422482
124236<00`Q248@@Q002124624821242248236<212422482124248@2124236<224821242248236<2
248212426<H25:D236<648@4248236<25:D448@236<2124648@26<H236<2248236<25:D26<H248@2
2482000448@27>L26<H29BT2248248@26<H27>L28@P26<H27>L25:D4;F/2:DX9Ool10001Ool000Uo
o`<0009oo`8000Eoo`03001oogoo009oo`9F]@9oo`9W>@96<@8Q208YBP848@8<H`8@Q08DY@848@8Y
BP8U:@8Q208<H`8HaP@DY@88@P8DY@8HaP8<H`88@P8YBPHDY@88@P8@Q0@<H`8HaP88@PH48@@@Q080
008<H`80008HaP@@Q08<H`8@Q0848@8DY@8<H`@8@P8@Q08DY@8<H`@48@8HaP848@8DY@848@88@P84
8@8<H`03248@Q12400848@H8@P848@88@P8<H`848@88@P848@8@Q0848@8<H`88@P848@88@P8<H`88
@P848@8HaP8DY@8<H`H@Q0@8@P8<H`8DY@@@Q08<H`848@H@Q08HaP8<H`88@P8<H`8DY@8HaP8@Q088
@P8000@@Q08Li`8HaP8U:@88@P8@Q08HaP8Li`8Q208HaP8Li`8DY@@]J`8YBPUoo`40005oo`002Woo
00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9JeP9oo`9Nm`9>L`96<@8@Q08<H`8H
aP@@Q08Li`8U:@8@Q088@P8<H`8HaP8@Q08HaP@Li`@<H`8Li`8<H`848@8DY@8000848@88@P848@88
@PH<H`848@8@Q08DY@H48@8<H`88@P@48@88@P800088@P@DY@8000P<H`848@8DY@@48@8<H`848@@8
@P848@0336<8@PQ200@<H`8@Q0@8@P800088@P8<H`8000848@8@Q08<H`848@8000@@Q0848@8@Q08<
H`@8@P8@Q088@P848@8<H`88@P@@Q0@48@@000@48@88@P@48@8HaP88@P848@8<H`8@Q08DY@8<H`8@
Q088@P8<H`8@Q08<H`8HaP8Li`8DY@8HaP8Li`8icP8@Q08Q20@DY@@icP9g_@Moo`40005oo`001goo
1@0000Eoo`00Oomoo`0000Aoo`8000=oo`9JeP9oo`9Nm`9>L`96<@8@Q08<H`8HaP@@Q08Li`8U:@8@
Q088@P8<H`8HaP8@Q08HaP@Li`@<H`8Li`8<H`848@8DY@8000848@88@P848@88@PH<H`848@8@Q08D
Y@H48@8<H`88@P@48@88@P800088@P@DY@8000P<H`848@8DY@@48@8<H`848@@8@P848@0336<8@PQ2
00@<H`8@Q0@8@P800088@P8<H`8000848@8@Q08<H`848@8000@@Q0848@8@Q08<H`@8@P8@Q088@P84
8@8<H`88@P@@Q0@48@@000@48@88@P@48@8HaP88@P848@8<H`8@Q08DY@8<H`8@Q088@P8<H`8@Q08<
H`8HaP8Li`8DY@8HaP8Li`8icP8@Q08Q20@DY@@icP9g_@Ioo`80005oo`001goo00@007ooOol0009o
o`04001oogoo0004Ool00`00Oomoo`02Ool2AS42Ool2Kg/4:DX21242<H`29BT25:D248@26<H21242
36<25:D47>L26<H27>L448@236<25:D28@P236<248@4248236<248@26<H2124236<26<H2248236<2
12420002248600021242248436<66<H248@2248236<21242248248@25:D248@4124236<248@21244
248348@42482124424845:D2000248@236<248@224826<H648@2248236<4124248@2124400021244
36<2248436<21242248448@2248248@236<224826<H2124224845:D236<25:D200028@P29BT26<H2
9BT248@236<224827>L28@P25:D4:DX25:D2;F/2@Q02JeX7Ool10001Ool000Qoo`03001oo`00009o
o`04001oogoo0004Ool00`00Oomoo`02Ool2AS42Ool2Kg/4:DX21242<H`29BT25:D248@26<H21242
36<25:D47>L26<H27>L448@236<25:D28@P236<248@4248236<248@26<H2124236<26<H2248236<2
12420002248600021242248436<66<H248@2248236<21242248248@25:D248@4124236<248@21244
248348@42482124424845:D2000248@236<248@224826<H648@2248236<4124248@2124400021244
36<2248436<21242248448@2248248@236<224826<H2124224845:D236<25:D200028@P29BT26<H2
9BT248@236<224827>L28@P25:D4:DX25:D2;F/2@Q02JeX7Ool10001Ool000Uoo`8000=oo`8000Eo
o`03001oogoo009oo`9JePAoo`8Li`8aS08@Q08YBP92408HaP8aS08@Q08HaP8YBP8HaP8Li`8HaP88
@P8<H`8U:@8DY@8<H`88@P8<H`8HaP88@P8@Q0@<H`88@P8<H`8@Q08DY@88@P8DY@8<H`848@@DY@8<
H`848@8@Q0800088@P80008<H`@8@P848@80008@Q088@P848@8<H`88@P8@Q088@P8<H`8@Q088@P8<
H`8@Q0@<H`D48@8<H`@48@8@Q0@8@P@<H`H8@P8@Q0@<H`88@P@48@80008DY@80008@Q08<H`8@Q08<
H`848@80008@Q088@P8<H`848@@@Q08<H`848@800088@P848@8@Q08<H`8Li`88@P8DY@8000848@8H
aP8Q208Li`8HaP8Q20@8@P8DY@8Li`8@Q08<H`8aS0800088@P9F]@8YBP9JePMoo`40005oo`005Goo
00<007ooOol00Woo0U[F17oo0QcW0S6<0Q240RU:0T8@0QS60S6<0Q240QS60RU:0QS60QcW0QS60PQ2
0PaS0RDY0QBU0PaS0PQ20PaS0QS60PQ20Q2410aS0PQ20PaS0Q240QBU0PQ20QBU0PaS0P@Q11BU0PaS
0P@Q0Q240P000PQ20P000PaS10Q20P@Q0P000Q240PQ20P@Q0PaS0PQ20Q240PQ20PaS0Q240PQ20PaS
0Q2410aS1@@Q0PaS10@Q0Q2410Q210aS1PQ20Q2410aS0PQ210@Q0P000QBU0P000Q240PaS0Q240PaS
0P@Q0P000Q240PQ20PaS0P@Q11240PaS0P@Q0P000PQ20P@Q0Q240PaS0QcW0PQ20QBU0P000P@Q0QS6
0R480QcW0QS60R4810Q20QBU0QcW0Q240PaS0S6<0P000PQ20UJe0RU:0U[F1goo0@000Goo000EOol0
0`00Oomoo`02Ool2Kg/2Ool2CW<2?Nl2;F/27>L29BT28@P248@29BT27>L26<H28@P224827>L248@2
6<H25:D248@236<224826<H4124448@436<2248248@2248436<224825:D2248236<2248236<248@2
248236<2000236<212422482124236<2248236<412440002248248@2248200021242248248@236<2
248336<25:D236<2248236<2248412442482124248@2124248@236<2124224826<H236<2124236<2
248236<2248248@22486124248@236<2124236<25:D424821242248248@25:D212425:D448@20002
12445:D248@28@P236<26<H236<448@236<224829BT26<H236<2BU826<H2DY@7Ool10001Ool001Eo
o`03001oogoo009oo`9_N`9oo`9>L`8mk`8]J`8Li`8U:@8Q208@Q08U:@8Li`8HaP8Q2088@P8Li`8@
Q08HaP8DY@8@Q08<H`88@P8HaP@48@@@Q0@<H`88@P8@Q088@P@<H`88@P8DY@88@P8<H`88@P8<H`8@
Q088@P8<H`80008<H`848@88@P848@8<H`88@P8<H`@48@@00088@P8@Q088@P8000848@88@P8@Q08<
H`88@P<<H`8DY@8<H`88@P8<H`88@P@48@@8@P848@8@Q0848@8@Q08<H`848@88@P8HaP8<H`848@8<
H`88@P8<H`88@P8@Q088@PH48@8@Q08<H`848@8<H`8DY@@8@P848@88@P8@Q08DY@848@8DY@@@Q080
00848@@DY@8@Q08Q208<H`8HaP8<H`@@Q08<H`88@P8U:@8HaP8<H`9:DP8HaP9BU0Moo`40005oo`00
5Goo00<007ooOol00Woo0THa0Woo0Ukg0Re[0T8@0S6<0PaS0R480RDY0QcW0R480RU:0QBU0Q240PaS
0QS611240P000PaS0Q2410Q20R480PaS0PQ20P@Q0PaS0P000Q240P000P@Q0PQ20QcW0PaS0Q240P@Q
0QBU0P@Q10Q211240PQ20PaS0PQ20QBU0PaS0QBU0PaS0Q240P0011240PaS0P000PQ20PaS0P@Q1PaS
0P@Q00<8@P@Q12400PQ20Q240P@Q0Q240PQ20P@Q0PaS10@Q0QS60PQ20P@Q0PaS10Q20P@Q0Q240P00
0PaS0P@Q0Q240PQ20Q240PaS0Q2410Q20Q240PQ20QBU0PaS0QBU0PQ20P@Q0PaS0R480Q240PQ20QcW
10Q20QBU0Q240P000PaS0QBU0P@Q0QS60Q240PaS0QS611BU0Q2411S611BU0Q240SF]0Re[0U[F1goo
0@000Goo000EOol00`00Oomoo`02Ool2AS42Ool2G_L2;F/2@Q02<H`236<28@P29BT27>L28@P2:DX2
5:D248@236<26<H448@2000236<248@424828@P236<22482124236<2000248@20002124224827>L2
36<248@212425:D21244248448@2248236<224825:D236<25:D236<248@2000448@236<200022482
36<2124636<212400`Q212448@02248248@2124248@22482124236<412426<H22482124236<42482
124248@2000236<2124248@2248248@236<248@4248248@224825:D236<25:D22482124236<28@P2
48@224827>L424825:D248@2000236<25:D212426<H248@236<26<H45:D248@46<H45:D248@2=Jd2
;F/2F]H7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9oo`9W>@8aS08e[@8YBP8DY@8<H`8Q2088
@P8Q20X<H`8DY@8<H`88@P8@Q088@P8<H`8DY@8@Q08U:@8<H`@48@8<H`848@8DY@848@8<H`8@Q08D
Y@8<H`848@8000848@@<H`848@8<H`848@88@P8000H@Q08<H`848@8HaP8<H`8@Q08DY@8<H`@8@P8<
H`8DY@8<H`8@Q08<H`03248@Q12400@48@@<H`848@88@P848@88@P8@Q0@8@P848@8<H`88@P8000@4
8@8HaP@8@P8<H`80008DY@8<H`@8@P8DY@848@8HaP8@Q08DY@8000848@8<H`8@Q0@8@P8HaP848@8<
H`8DY@848@8@Q08DY@88@P8HaPH<H`8@Q08HaP@8@P8YBP@HaP8DY@8<H`88@P8icP92409_N`Moo`40
005oo`005Goo0P000goo0Tic0Woo0VLi0S6<0SF]0RU:0QBU0PaS0R480PQ20R482PaS0QBU0PaS0PQ2
0Q240PQ20PaS0QBU0Q240RDY0PaS10@Q0PaS0P@Q0QBU0P@Q0PaS0Q240QBU0PaS0P@Q0P000P@Q10aS
0P@Q0PaS0P@Q0PQ20P001Q240PaS0P@Q0QS60PaS0Q240QBU0PaS10Q20PaS0QBU0PaS0Q240PaS00<8
@Q2448@010@Q10aS0P@Q0PQ20P@Q0PQ20Q2410Q20P@Q0PaS0PQ20P0010@Q0QS610Q20PaS0P000QBU
0PaS10Q20QBU0P@Q0QS60Q240QBU0P000P@Q0PaS0Q2410Q20QS60P@Q0PaS0QBU0P@Q0Q240QBU0PQ2
0QS61PaS0Q240QS610Q20RU:11S60QBU0PaS0PQ20SW>0T8@0Vmk1Woo0P000Goo000EOol00`00Oomo
o`02Ool2DY@2Ool2JeX2BU82=Jd212425:D248@2124448@236<25:D248@200025:D224829BT236<6
48@46<H2248248@25:D212426<H25:D20002124248@4124248@2124248@236<4248412425:D20002
248236<2248236<2248236<4248248@4248436<4248612400`Q212448@02248248@2248248@41242
36<2248236<21242000236<2124436<4124236<6248236<2124224825:D4124248@2248236<20002
36<27>L436<2124236<25:D224821242248448@236<248@224825:D2248236<27>L236<248@25:D2
24826<H224845:D26<H29BT2CW<2IcT7Ool10001Ool001Eoo`03001oogoo009oo`9BU09oo`9[FP9:
DP8e[@848@8DY@8@Q0848@@@Q08<H`8DY@8@Q080008DY@88@P8U:@8<H`H@Q0@HaP88@P8@Q08DY@84
8@8HaP8DY@8000848@8@Q0@48@8@Q0848@8@Q08<H`@8@P@48@8DY@800088@P8<H`88@P8<H`88@P8<
H`@8@P8@Q0@8@P@<H`@8@PH48@0324848@@Q0088@P8@Q088@P8@Q0@48@8<H`88@P8<H`848@80008<
H`848@@<H`@48@8<H`H8@P8<H`848@88@P8DY@@48@8@Q088@P8<H`80008<H`8Li`@<H`848@8<H`8D
Y@88@P848@88@P@@Q08<H`8@Q088@P8DY@88@P8<H`8Li`8<H`8@Q08DY@88@P8HaP88@P@DY@8HaP8U
:@9>L`9W>@Moo`40005oo`005Goo00<007ooOol00Woo0VLi0Woo0V]J0R480SF]0Q240PaS0QcW0Q24
0QcW0P@Q0PaS0QBU0Q240QBU0P@Q10Q20Q240QS60QBU10@Q0QS60PaS0Q240PQ20P@Q0Q240PaS0PQ2
0Q240PQ20Q240QBU20aS0QS60PaS0QBU0PaS0QS60P@Q0PaS0Q240PQ20P@Q0QBU10aS0PQ20P@Q0PaS
0P@Q0PaS3@@Q0PQ20PaS0PQ210aS0Q241P@Q10Q20PaS0PQ20Q240PQ20PaS1PQ20Q240P@Q10Q20PaS
0PQ20PaS0PQ20Q240PaS0PQ2112410@Q0Q240QS610@Q0PQ20P@Q1PaS0QBU0RDY0QS60RDY0PaS0Q24
0PQ20Q240QcW0QBU0PaS0QBU0Q2411cW0Q240QcW0THa0S6<0V<H1goo0@000Goo000EOol00`00Oomo
o`02Ool2IcT2Ool2JeX28@P2=Jd248@236<27>L248@27>L2124236<25:D248@25:D21244248248@2
6<H25:D412426<H236<248@22482124248@236<2248248@2248248@25:D836<26<H236<25:D236<2
6<H2124236<248@2248212425:D436<22482124236<2124236<=1242248236<2248436<248@61244
248236<2248248@2248236<6248248@21244248236<2248236<2248248@236<2248448@4124248@2
6<H412422482124636<25:D29BT26<H29BT236<248@2248248@27>L25:D236<25:D248@47>L248@2
7>L2AS42<H`2HaP7Ool10001Ool001Eoo`03001oogoo009oo`9S609oo`9S608YBP8mk`8Li`8<H`8@
Q08HaP8DY@@@Q088@P8U:@8HaP8@Q08<H`@@Q08DY@8<H`88@P8<H`@HaP8<H`8@Q088@P848@@0008H
aP@8@P8DY@8<H`@8@P8@Q08DY@88@P8<H`800088@P848@88@P@<H`848@H00088@P848@8<H`@8@P84
8@88@P8DY@@48@8<H`T8@P8000@48@8<H`848@88@P848@88@P8<H`88@P8@Q0@00088@P@000848@8<
H`88@P@48@800088@P@<H`848@H000@@Q0@Li`@8@P848@8<H`8HaP8@Q08DY@88@P8@Q0800088@P8L
i`88@P848@8<H`88@P8@Q08YBP8<H`848@8e[@8DY@848@9:DP8YBP9Nm`Moo`40005oo`005Goo00<0
07ooOol00Woo0V<H0Woo0V<H0RU:0Sg_0QcW0PaS0Q240QS60QBU11240PQ20RDY0QS60Q240PaS1124
0QBU0PaS0PQ20PaS11S60PaS0Q240PQ20P@Q10000QS610Q20QBU0PaS10Q20Q240QBU0PQ20PaS0P00
0PQ20P@Q0PQ210aS0P@Q1P000PQ20P@Q0PaS10Q20P@Q0PQ20QBU10@Q0PaS2@Q20P0010@Q0PaS0P@Q
0PQ20P@Q0PQ20PaS0PQ20Q2410000PQ210000P@Q0PaS0PQ210@Q0P000PQ210aS0P@Q1P00112411cW
10Q20P@Q0PaS0QS60Q240QBU0PQ20Q240P000PQ20QcW0PQ20P@Q0PaS0PQ20Q240RU:0PaS0P@Q0SF]
0QBU0P@Q0TYB0RU:0Ukg1goo0@000Goo000EOol00`00Oomoo`02Ool2AS42Ool2HaP2=Jd2:DX29BT2
6<H25:D2248248@29BT436<29BT436<2000236<25:D248@2000224826<H2248236<2248236<248@2
248212425:D448@236<224825:D2000248@25:D224827>L236<25:D612426<H436<2124448@22482
0006124248@42482124236<224831242000212422482124200042482124236<200021242248248@2
36<2124436<25:D248@236<224820002248248@2248236<25:D2248248@85:D2248248@2248236<2
48@236<2124236<2248236<2124248@436<45:D248@236<248@27>L2248248@212426<H25:D248@2
:DX2;F/2IcT7Ool10001Ool001Eoo`03001oogoo009oo`96<@9oo`9S608e[@8YBP8U:@8HaP8DY@88
@P8@Q08U:@@<H`8U:@@<H`80008<H`8DY@8@Q0800088@P8HaP88@P8<H`88@P8<H`8@Q088@P848@8D
Y@@@Q08<H`88@P8DY@80008@Q08DY@88@P8Li`8<H`8DY@H48@8HaP@<H`848@@@Q088@P8000H48@8@
Q0@8@P848@8<H`88@P<48@8000848@88@P848@8000@8@P848@8<H`8000848@88@P8@Q08<H`848@@<
H`8DY@8@Q08<H`88@P800088@P8@Q088@P8<H`8DY@88@P8@Q0PDY@88@P8@Q088@P8<H`8@Q08<H`84
8@8<H`88@P8<H`848@8@Q0@<H`@DY@8@Q08<H`8@Q08Li`88@P8@Q0848@8HaP8DY@8@Q08YBP8]J`9W
>@Moo`40005oo`005Goo00<007ooOol00Woo0SF]0Woo0VLi0Re[0Sg_0R480QS610Q211BU0QcW0PQ2
10aS0PQ20QcW0P000QBU0QS60P@Q0QBU10Q210aS0P@Q0PaS10000PaS10000Q240P@Q0P000PaS0QBU
0P000PaS0QBU0Q240QBU0PaS10@Q0PaS0Q2410@Q0PQ20P@Q0PaS2P@Q0PaS0P000PQ20P@Q0PQ200<0
00@Q12400P@Q0PaS10Q211240PQ20P@Q10Q20P@Q0P000Q240PaS0P0010aS0QBU0PaS0P@Q0PaS0PQ2
0Q2411BU11S60Q240PaS11240PaS0P000P@Q0PQ20P@Q0QcW0P000PaS0P000PaS0R480PQ20QS60PQ2
0Q240PaS0P@Q11240P@Q0QS60RU:10@Q0QS611cW0QBU12e[0UJe1goo0@000Goo000EOol20003Ool2
=Jd2Ool2IcT2;F/2?Nl28@P26<H424845:D27>L2248436<224827>L200025:D26<H212425:D42484
36<2124236<4000236<4000248@21242000236<25:D2000236<25:D248@25:D236<4124236<248@4
12422482124236<:124236<200022482124224800`0012448@02124236<4248448@2248212442482
1242000248@236<2000436<25:D236<2124236<2248248@45:D46<H248@236<448@236<200021242
248212427>L2000236<2000236<28@P224826<H2248248@236<2124448@212426<H2:DX412426<H4
7>L25:D4;F/2E[D6Ool20001Ool001Eoo`03001oogoo009oo`96<@9oo`9JeP8Q208e[@8U:@8@Q08<
H`8DY@88@P8@Q08DY@8HaP8<H`@48@88@P8<H`8DY@8<H`8000@<H`848@8DY@88@P8@Q088@P848@88
@P8@Q08<H`H48@88@P8<H`848@8<H`8@Q0@<H`8DY@848@8<H`88@P800088@P8U:@@48@8DY@88@P@4
8@8<H`88@P8@Q088@P@<H`848@88@P0348@8@PQ20080008DY@8<H`848@88@P848@8@Q0848@8000H4
8@8000@48@8@Q0@8@PH<H`848@8DY@@48@8<H`8HaP88@P80008HaP8<H`88@P@@Q088@P848@@<H`88
@P8@Q08Li`8<H`H8@P8HaP88@P8DY@88@P8Li`@DY@8@Q08HaP8Q208DY@88@P8@Q08Li`@aS09BU0Mo
o`40005oo`005Goo00<007ooOol00Woo0THa0Woo0U[F0R480SF]0RDY0Q240PaS0QBU0PQ20Q240QBU
0QS60PaS10@Q0PQ20PaS0QBU0PaS0P0010aS0P@Q0QBU0PQ20Q240PQ20P@Q0PQ20Q240PaS1P@Q0PQ2
0PaS0P@Q0PaS0Q2410aS0QBU0P@Q0PaS0PQ20P000PQ20RDY10@Q0QBU0PQ210@Q0PaS0PQ20Q240PQ2
10aS0P@Q0PQ200<@Q0Q224800P000QBU0PaS0P@Q0PQ20P@Q0Q240P@Q0P001P@Q0P0010@Q0Q2410Q2
1PaS0P@Q0QBU10@Q0PaS0QS60PQ20P000QS60PaS0PQ211240PQ20P@Q10aS0PQ20Q240QcW0PaS1PQ2
0QS60PQ20QBU0PQ20QcW11BU0Q240QS60R480QBU0PQ20Q240QcW136<0U:D1goo0@000Goo000EOol0
0`00Oomoo`02Ool2@Q02Ool2JeX29BT2?Nl436<27>L200025:D26<H448@25:D26<H2000224826<H2
24827>L424825:D2248200061242248236<248@4248236<20002124236<248@436<4124236<26<H2
000236<2248236<200021242000248@2248236<4248400022482124236<2124236<00`Q212448@02
36<248@212420002124636<2124236<2248236<200022482124236<448@25:D236<248@2124436<2
48@2000248@4000436<624821242248236<25:D22482000436<25:D236<200026<H248@624821242
36<224827>L25:D248@212445:D2?Nl2<H`2BU87Ool10001Ool001Eoo`03001oogoo009oo`92409o
o`9[FP8U:@8mk`@<H`8Li`80008DY@8HaP@@Q08DY@8HaP800088@P8HaP88@P8Li`@8@P8DY@88@P80
00H48@88@P8<H`8@Q0@8@P8<H`8000848@8<H`8@Q0@<H`@48@8<H`8HaP80008<H`88@P8<H`800084
8@80008@Q088@P8<H`@8@P@00088@P848@8<H`848@8<H`0324848@@Q008<H`8@Q0848@8000848@H<
H`848@8<H`88@P8<H`800088@P848@8<H`@@Q08DY@8<H`8@Q0848@@<H`8@Q080008@Q0@000@<H`H8
@P848@88@P8<H`8DY@88@P8000@<H`8DY@8<H`80008HaP8@Q0H8@P848@8<H`88@P8Li`8DY@8@Q084
8@@DY@8mk`8aS09:DPMoo`40005oo`005Goo00<007ooOol00Woo0Tic0Woo0V]J0Re[0SW>0PaS0Q24
0QS60PaS0PQ20QS60P@Q0Q240R480P@Q0PQ20P@Q0QS60PQ20P@Q0PQ20PaS0P@Q10aS0P@Q0PQ20PaS
0PQ20P@Q0PaS0P000P@Q0Q240P0010Q20P@Q0QS61PaS10@Q0PQ20P000QS60P@Q0Q240QBU0PQ210@Q
0PaS0PQ210@Q0PQ20P@Q0PQ20Q240PQ20P@Q00<8@PaS36<010@Q0Q2410aS0P000P@Q0PaS0P@Q0P00
0PQ20QBU0PQ20PaS0P001P@Q10aS0P0010aS10Q20PaS10Q20Q240PaS0QS60P@Q0PQ20PaS0QBU0Q24
0PaS0Q240PaS0P@Q0R480P@Q0PQ20PaS0PQ20Q240QBU0Q240QS60PaS0P@Q0P000PaS0Q2410aS0QcW
11240THa0RU:0WNm1goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2JeX2;F/2>Lh236<248@2
6<H236<224826<H2124248@28@P21242248212426<H224821242248236<2124436<21242248236<2
2482124236<20002124248@20004248212426<H636<41242248200026<H2124248@25:D224841242
36<22484124224821242248248@2248212400`Q236<<H`04124248@436<20002124236<212420002
24825:D2248236<20006124436<2000436<4248236<4248248@236<26<H21242248236<25:D248@2
36<248@236<212428@P21242248236<2248248@25:D248@26<H236<21242000236<248@436<27>L4
48@2AS42:DX2Mkd7Ool10001Ool001Eoo`03001oogoo009oo`9:DP9oo`9W>@8]J`8mk`8Li`8HaP8L
i`8DY@8@Q08DY@8HaP8000P<H`8000@<H`8000848@8<H`8DY@88@P8<H`8DY@848@8Li`88@P@<H`8@
Q088@P848@8<H`88@P8@Q0@8@P848@88@P800088@P8HaP8000@<H`848@@DY@@8@P848@88@P848@88
@P8@Q08000848@8<H`88@P8@Q0D48@8<H`848@8U:@88@P8@Q0@48@8@Q0848@8000@48@8@Q080008D
Y@8@Q088@P80008<H`8@Q08<H`8@Q08000848@8<H`848@@@Q088@P@<H`8@Q08DY@@48@H<H`88@P80
008<H`8DY@8<H`848@8@Q080008@Q0@HaP@48@@DY@@<H`8HaP8DY@8HaP8]J`8aS09JePMoo`40005o
o`005Goo00<007ooOol00Woo0TYB0Woo0VLi0Re[0Sg_0QcW0QS60QcW0QBU0Q240QBU0QS60P0020aS
0P0010aS0P000P@Q0PaS0QBU0PQ20PaS0QBU0P@Q0QcW0PQ210aS0Q240PQ20P@Q0PaS0PQ20Q2410Q2
0P@Q0PQ20P000PQ20QS60P0010aS0P@Q11BU10Q20P@Q0PQ20P@Q0PQ20Q240P000P@Q0PaS0PQ20Q24
1@@Q0PaS0P@Q0RDY0PQ20Q2410@Q0Q240P@Q0P0010@Q0Q240P000QBU0Q240PQ20P000PaS0Q240PaS
0Q240P000P@Q0PaS0P@Q11240PQ210aS0Q240QBU10@Q1PaS0PQ20P000PaS0QBU0PaS0P@Q0Q240P00
0Q2411S610@Q11BU10aS0QS60QBU0QS60Re[0S6<0U[F1goo0@000Goo000EOol00`00Oomoo`02Ool2
CW<2Ool2G_L2:DX2=Jd2:DX29BT27>L224829BT2124236<25:D26<H4248236<212425:D248@236<2
248636<21242248436<248@236<20002248436<448@412422482124436<248@6124236<224821242
48@25:D2124236<2124236<200081242248212400`aS48@@Q002248200041242248212426<H20002
36<224820002124224825:D2124248@2248236<224825:D4124248@25:D2248248@236<624820002
36<25:D224820002248236<21242248236<6248436<22482124448@2248448@2124236<248@22482
48@28@P25:D2:DX2=Jd2AS47Ool10001Ool001Eoo`8000=oo`9>L`9oo`9Nm`8YBP8e[@8YBP8U:@8L
i`88@P8U:@848@8<H`8DY@8HaP@8@P8<H`848@8DY@8@Q08<H`88@PH<H`848@88@P@<H`8@Q08<H`80
0088@P@<H`@@Q0@48@88@P848@@<H`8@Q0H48@8<H`88@P848@8@Q08DY@848@8<H`848@8<H`8000P4
8@88@P848@0336<@Q1240088@P8000@48@88@P848@8HaP80008<H`88@P8000848@88@P8DY@848@8@
Q088@P8<H`88@P8DY@@48@8@Q08DY@88@P8@Q08<H`H8@P80008<H`8DY@88@P800088@P8<H`848@88
@P8<H`H8@P@<H`88@P848@@@Q088@P@@Q0848@8<H`8@Q088@P8@Q08Q208DY@8YBP8e[@96<@Ioo`80
005oo`005Goo00<007ooOol00Woo0T8@0Woo0V<H0RDY0RU:0QBU0RU:0QBU0QS60PaS0Q240P@Q0QS6
0QBU0PaS0Q240QS60PQ20PaS0QBU10aS0R480PaS0QS60P@Q0Q240PaS0PQ20PaS0PQ20P000P@Q0PaS
11240PaS10Q20P@Q0P000PaS0PQ20P@Q0QBU0QS60P@Q112410@Q0PQ20P000PQ20P@Q10aS0PQ210@Q
0Q240PQ20Q240`@Q100010@Q0PaS0P000PaS0P@Q0Q240P@Q0QBU10@Q10Q210@Q0P000PaS0PQ20P@Q
0Q240PQ20P@Q0PQ20QBU0Q240P@Q0PQ20P000Q240QcW0PQ20PaS0Q240PQ20Q240P@Q0PQ20P@Q0PQ2
0QcW0QBU0PaS0PQ20PaS0QS60PQ20Q240PQ20QcW0PQ20P0010Q20PaS0RDY0QS60PaS0T8@0SF]0V<H
1goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02Ool2HaP29BT2:DX25:D2:DX25:D26<H236<248@2
12426<H25:D236<248@26<H2248236<25:D436<28@P236<26<H2124248@236<2248236<224820002
124236<448@236<424821242000236<2248212425:D26<H2124448@41242248200022482124436<2
2484124248@2248248@312440004124236<2000236<2124248@212425:D4124424841242000236<2
2482124248@22482124224825:D248@212422482000248@27>L2248236<248@2248248@212422482
124224827>L25:D236<2248236<26<H2248248@224827>L224820004248236<29BT26<H236<2@Q02
=Jd2HaP7Ool10001Ool001Eoo`03001oogoo009oo`9BU09oo`9Nm`8]J`8icP8DY@8Q208U:@88@P@4
8@88@P8U:@8HaP8@Q08DY@@@Q08<H`848@8DY@88@P80008<H`88@P8<H`848@8@Q08<H`88@P8<H`80
008@Q08<H`8@Q0H<H`80008@Q08<H`88@P848@8<H`848@88@P848@@8@P8<H`8000848@@8@P8HaP88
@P8<H`88@P8<H`@48@8<H`88@P03124<H`aS008<H`H8@P8000848@8000@48@88@P848@8@Q0848@8<
H`8000H8@P8DY@@8@P8DY@848@8@Q088@P@48@8<H`88@P848@@8@P80008DY@@@Q080008@Q088@P8<
H`8HaP8@Q0848@8HaP8<H`8Li`8DY@80008DY@8000@HaP88@P8<H`@@Q08DY@8@Q0848@92408aS09B
U0Moo`40005oo`005Goo00<007ooOol00Woo0U:D0Woo0Ukg0Re[0SW>0QBU0R480RDY0PQ210@Q0PQ2
0RDY0QS60Q240QBU11240PaS0P@Q0QBU0PQ20P000PaS0PQ20PaS0P@Q0Q240PaS0PQ20PaS0P000Q24
0PaS0Q241PaS0P000Q240PaS0PQ20P@Q0PaS0P@Q0PQ20P@Q10Q20PaS0P000P@Q10Q20QS60PQ20PaS
0PQ20PaS10@Q0PaS0PQ200<48@aS36<00PaS1PQ20P000P@Q0P0010@Q0PQ20P@Q0Q240P@Q0PaS0P00
1PQ20QBU10Q20QBU0P@Q0Q240PQ210@Q0PaS0PQ20P@Q10Q20P000QBU11240P000Q240PQ20PaS0QS6
0Q240P@Q0QS60PaS0QcW0QBU0P000QBU0P0011S60PQ20PaS11240QBU0Q240P@Q0T8@0S6<0U:D1goo
0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2DY@2=Jd2;F/248@20002:DX436<248@236<2:DX6
6<H224841242248436<4124236<2248448@2124236<248@25:D236<212422482124236<424826<H2
24826<H236<21242248236<25:D20004248212422482124248@2248236<224841244248436<32486
12462482124236<248@236<212422482124236<2248236<248@2248212462482000236<224825:D2
24825:D2248448@2248236<26<H21242248248@22482124224826<H436<26<H212425:D212422482
36<2124236<25:D224827>L2000236<48@P236<2AS42=Jd2E[D7Ool10001Ool001Eoo`03001oogoo
009oo`9>L`9oo`9BU08e[@8]J`8@Q080008YBP@<H`8@Q08<H`8YBPHHaP88@P@48@88@P@<H`@48@8<
H`88@P@@Q0848@8<H`8@Q08DY@8<H`848@88@P848@8<H`@8@P8HaP88@P8HaP8<H`848@88@P8<H`8D
Y@8000@8@P848@88@P848@8@Q088@P8<H`88@P@48@@8@P@<H`<8@PH48@H8@P848@8<H`8@Q08<H`84
8@88@P848@8<H`88@P8<H`8@Q088@P848@H8@P80008<H`88@P8DY@88@P8DY@88@P@@Q088@P8<H`8H
aP848@88@P8@Q088@P848@88@P8HaP@<H`8HaP848@8DY@848@88@P8<H`848@8<H`8DY@88@P8Li`80
008<H`@Q208<H`96<@8e[@9F]@Moo`40005oo`005Goo00<007ooOol00Woo0T8@0Woo0Ukg0QS60SW>
0Q240P000QcW1QS60P@Q0RU:11BU0P@Q112410aS10000P@Q0QBU10Q20P@Q0QBU0PQ20PaS0PQ210@Q
0PaS0PQ20PaS0P@Q0PaS0P000PaS0PQ20Q2410Q20P000PaS0PQ20P@Q0Q240P000PaS10Q20PaS0PQ2
0P@Q0PaS0PQ20QBU0P@Q0P000PaS0PQ200<48ABU5:D00P000PaS0Q240QBU0P@Q0PaS1PQ20P@Q0Q24
0P000Q240PQ210000P@Q10aS0P000P@Q0PQ20P000P@Q0PQ210aS10@Q0PaS0QBU0PQ20PaS10Q20P@Q
0PaS0Q240P@Q0PQ20PaS0Q240QBU0Q240PaS0QBU0PaS0Q240P@Q0Q240QBU0PQ20QcW0Q240R480QBU
0RU:0Q240R480S6<0RU:0V<H1goo0@000Goo0007Ool30004Ool20005Ool00`00Oomoo`02Ool2@Q02
Ool2G_L26<H2>Lh248@200027>L66<H21242:DX45:D2124448@436<4000212425:D4248212425:D2
248236<22484124236<2248236<2124236<2000236<2248248@42482000236<22482124248@20002
36<4248236<22482124236<224825:D21242000236<224800`@Q5:DDY@02000236<248@25:D21242
36<62482124248@2000248@224840002124436<200021242248200021242248436<4124236<25:D2
248236<42482124236<248@21242248236<248@25:D248@236<25:D236<248@2124248@25:D22482
7>L248@28@P25:D2:DX248@28@P2<H`2:DX2HaP7Ool10001Ool000Moo`04001oogoo0002Ool01000
Oomoo`0017oo00<007ooOol00Woo0THa0Woo0UJe136<0PaS0PQ211BU11240PaS0QcW0PQ20P@Q0PaS
0QBU0QS60PaS0QS611240PaS0QS60PQ20P@Q0PaS0P000PQ20P000PQ20Q240P@Q0Q2410Q20P@Q0PaS
0QcW0PQ20PaS10@Q10Q20P0010@Q0Q240P@Q0P000Q240P@Q0PQ20P@Q10Q20PaS0PQ20P000PQ20P@Q
0PQ200<DY@Q2248010@Q10Q20P@Q0Q240PaS0PQ210aS0Q240PQ20PaS0Q240PQ20Q241PaS0PQ210@Q
0P000PQ20Q240PaS0P@Q0PQ20PaS10@Q0PaS0PQ20Q2410@Q0PaS0Q240PaS0P000PQ20QcW10aS0QBU
0Q2410aS0P@Q0QS61Q240PaS0RDY0PaS11S60QcW0Re[0QS60Ukg1goo0@000Goo0007Ool01000Oomo
o`000Woo00@007ooOol000Aoo`8000=oo`96<@9oo`9F]@@aS08<H`88@P@DY@@@Q08<H`8Li`88@P84
8@8<H`8DY@8HaP8<H`8HaP@@Q08<H`8HaP88@P848@8<H`800088@P800088@P8@Q0848@8@Q0@8@P84
8@8<H`8Li`88@P8<H`@48@@8@P8000@48@8@Q0848@80008@Q0848@88@P848@@8@P8<H`88@P800088
@P848@88@P035:D8@PQ200@48@@8@P848@8@Q08<H`88@P@<H`8@Q088@P8<H`8@Q088@P8@Q0H<H`88
@P@48@800088@P8@Q08<H`848@88@P8<H`@48@8<H`88@P8@Q0@48@8<H`8@Q08<H`800088@P8Li`@<
H`8DY@8@Q0@<H`848@8HaPH@Q08<H`8U:@8<H`@HaP8Li`8]J`8HaP9Nm`Ioo`80005oo`001goo0`00
0goo00@007ooOol000Aoo`03001oogoo009oo`8icP9oo`9JeP8aS08icP848@8DY@8@Q08<H`8DY@8<
H`8DY@88@P8Li`8<H`8Li`848@8<H`848@8<H`88@P@<H`@8@P8<H`8@Q0848@@@Q0H<H`848@8HaP8D
Y@88@P@DY@8<H`848@8@Q08<H`80008DY@8@Q0@8@P8DY@88@P8<H`88@PH@Q0848@88@PH<H`8000D@
Q080008@Q088@P848@80008<H`88@P848@88@P80008@Q0@8@P8<H`848@@8@P848@8DY@848@88@P8<
H`848@@<H`8@Q088@P8<H`848@8<H`848@P<H`8Li`848@8@Q080008<H`8@Q08DY@88@P8DY@8Li`8H
aP88@P8DY@H8@P8Li`8@Q0@8@P8U:@8DY@@@Q08U:@8Q208aS09F]@Moo`40005oo`0027oo00<007oo
Ool00Woo00@007ooOol000Aoo`03001oogoo009oo`8icP9oo`9JeP8aS08icP848@8DY@8@Q08<H`8D
Y@8<H`8DY@88@P8Li`8<H`8Li`848@8<H`848@8<H`88@P@<H`@8@P8<H`8@Q0848@@@Q0H<H`848@8H
aP8DY@88@P@DY@8<H`848@8@Q08<H`80008DY@8@Q0@8@P8DY@88@P8<H`88@PH@Q0848@88@PH<H`80
00D@Q080008@Q088@P848@80008<H`88@P848@88@P80008@Q0@8@P8<H`848@@8@P848@8DY@848@88
@P8<H`848@@<H`8@Q088@P8<H`848@8<H`848@P<H`8Li`848@8@Q080008<H`8@Q08DY@88@P8DY@8L
i`8HaP88@P8DY@H8@P8Li`8@Q0@8@P8U:@8DY@@@Q08U:@8Q208aS09F]@Moo`40005oo`0027oo0`00
0goo0P001Goo00<007ooOol00Woo0TYB0Woo0U[F0RU:0Sg_0PaS0QcW0RDY0PaS0P@Q1PaS0Q240P@Q
0RU:0QcW0PaS10Q20Q240PQ20PaS0PQ20PaS0QBU0PaS11240PQ20PaS0QBU0PaS0P@Q0PaS0Q240PaS
0P000P@Q0PaS10@Q0PQ20P@Q10Q20P@Q0PQ20P0010aS0PQ21PaS10Q20P@Q0PQ20PaS0P@Q11241@Q2
0QBU0PQ20PaS0P@Q0P0010Q20P@Q0QBU0PQ20PaS0P@Q0PaS0P@Q0PQ211240PaS0Q240PQ210@Q10Q2
0P000PaS0P@Q0PQ20Q240PQ20PaS0PQ20P@Q0PQ20P000PaS0Q240PaS0Q240PaS0PQ20Q240QBU0P@Q
0R480PaS0QBU11S60Q2410@Q0RU:0P@Q0Q240S6<0PaS0R480Sg_0S6<0TYB1goo0@000Goo000EOol0
0`00Oomoo`02Ool2BU82Ool2F]H2:DX2?Nl236<27>L29BT236<2124636<248@21242:DX27>L236<4
248248@2248236<2248236<25:D236<448@2248236<25:D236<2124236<248@236<20002124236<4
124224821244248212422482000436<2248636<424821242248236<2124448@524825:D2248236<2
12420004248212425:D2248236<2124236<21242248448@236<248@2248412442482000236<21242
248248@2248236<2248212422482000236<248@236<248@236<2248248@25:D212428@P236<25:D4
6<H248@41242:DX2124248@2<H`236<28@P2?Nl2<H`2BU87Ool10001Ool001Eoo`03001oogoo009o
o`9:DP9oo`9BU08aS08YBP8Li`8@Q08U:@88@P@DY@88@P8Li`8@Q088@P8HaP8Li`88@P8<H`8DY@8<
H`@@Q08DY@8<H`800088@P8<H`80008DY@8@Q0H8@P8000P48@@<H`88@P8@Q080008<H`88@PH<H`8@
Q080008<H`88@P8@Q08HaP848@88@P8<H`@8@P8<H`88@P80000336<8@PQ20088@P848@88@P848@8@
Q080008<H`88@P@00088@P848@8<H`848@88@P8<H`88@P848@8000848@88@P@<H`@8@P8<H`8HaP@<
H`848@88@P80008<H`88@P@<H`@8@P848@@HaP80008<H`88@P8<H`8@Q08Li`8HaP8Q20848@8DY@@0
008Q2088@P848@8DY@8@Q08DY@8YBP8DY@96<@Moo`40005oo`005Goo00<007ooOol00Woo0TYB0Woo
0U:D0S6<0RU:0QcW0Q240RDY0PQ211BU0PQ20QcW0Q240PQ20QS60QcW0PQ20PaS0QBU0PaS11240QBU
0PaS0P000PQ20PaS0P000QBU0Q241PQ20P0020@Q10aS0PQ20Q240P000PaS0PQ21PaS0Q240P000PaS
0PQ20Q240QS60P@Q0PQ20PaS10Q20PaS0PQ20P0000<<H`Q224800PQ20P@Q0PQ20P@Q0Q240P000PaS
0PQ210000PQ20P@Q0PaS0P@Q0PQ20PaS0PQ20P@Q0P000P@Q0PQ210aS10Q20PaS0QS610aS0P@Q0PQ2
0P000PaS0PQ210aS10Q20P@Q11S60P000PaS0PQ20PaS0Q240QcW0QS60R480P@Q0QBU10000R480PQ2
0P@Q0QBU0Q240QBU0RU:0QBU0THa1goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2HaP2@Q02
:DX25:D248@27>L248@25:D26<H248@236<27>L236<248@25:D42482124248@236<25:D2124248@2
0002124224826<H248@236<22482000224827>L20002124200021244248436<224825:D4000248@2
248236<224821244248236<6248236<2248236<2248236<00`@Q48@@Q002124248@2124236<22482
124248@2248412422482124248@436<41242248200022482000236<200021242248236<2124248@2
00021242000248@236<25:D46<H224825:D248@236<45:D2248436<224826<H2000236<2248436<2
48@236<29BT26<H2;F/25:D236<2<H`248@2F]H7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9o
o`9S6092408YBP8DY@8@Q08Li`8@Q08DY@8HaP8@Q08<H`8Li`8<H`8@Q08DY@@8@P848@8@Q08<H`8D
Y@848@8@Q08000848@88@P8HaP8@Q08<H`88@P800088@P8Li`8000848@8000848@@8@P@<H`88@P8D
Y@@0008@Q088@P8<H`88@P848@@8@P8<H`H8@P8<H`88@P8<H`88@P8<H`03124@Q12400848@8@Q084
8@8<H`88@P848@8@Q088@P@48@88@P848@8@Q0@<H`@48@88@P800088@P80008<H`8000848@88@P8<
H`848@8@Q08000848@80008@Q08<H`8DY@@HaP88@P8DY@8@Q08<H`@DY@88@P@<H`88@P8HaP80008<
H`88@P@<H`8@Q08<H`8U:@8HaP8]J`8DY@8<H`8aS08@Q09JePMoo`40005oo`005Goo00<007ooOol0
0Woo0THa0Woo0U[F0SF]0SW>0Q240PQ20QBU0PaS0Q240P@Q0QBU0PQ21Q240QBU0P000Q2410aS0QBU
0PQ20QS60P@Q0P0011241PaS0QBU0PQ20PaS0PQ210aS0Q240PQ20QS60QBU10aS0Q240P@Q0Q240PQ2
0P@Q0PQ20PaS100010Q20P000PaS10Q20Q240PaS0P@Q0PQ20PaS00<48@Q224800P@Q0PaS0PQ20P@Q
0PaS0Q2410Q20PaS0P0010Q210000PaS0PQ20P@Q0PQ20Q240P@Q0Q2410aS0QBU0QS60PQ20Q2410aS
0PQ20PaS0PQ20QBU1PaS11240P000P@Q0QS60PQ20QBU10aS0Q240P000QBU1Q240PQ20QBU0P@Q0Q24
0PaS0QBU0PQ20Q240SW>0SF]0U[F1goo0@000Goo000EOol20003Ool2AS42Ool2F]H2=Jd2>Lh248@2
24825:D236<248@212425:D2248648@25:D2000248@436<25:D224826<H21242000448@636<25:D2
248236<2248436<248@224826<H25:D436<248@2124248@224821242248236<400042482000236<4
248248@236<21242248236<00`@Q2488@P02124236<22482124236<248@4248236<2000424840002
36<224821242248248@2124248@436<25:D26<H2248248@436<2248236<224825:D636<448@20002
12426<H224825:D436<248@200025:D648@224825:D2124248@236<25:D2248248@2>Lh2=Jd2F]H6
Ool20001Ool001Eoo`03001oogoo009oo`9>L`9oo`9JeP8@Q08aS08<H`8DY@8]J`8HaP8U:@8<H`8@
Q0@<H`88@P8<H`80008HaP88@P@<H`88@P@DY@8<H`8@Q08DY@88@P@HaP8DY@8<H`8@Q08000848@80
008@Q0848@8<H`88@P848@80008<H`800088@P800088@P@48@@<H`8@Q0848@88@P@48@88@P8@Q084
8@88@P8<H`848@8@Q003124@Q12400848@8<H`88@P8<H`88@P8<H`H8@P8<H`@8@P848@88@P8<H`88
@P8@Q0@0008DY@88@P@<H`@8@P848@8000848@80008Li`88@P800088@P8<H`8@Q08HaP88@P848@80
008@Q0848@8DY@8<H`8@Q0848@@8@P8DY@8@Q08<H`8Li`8<H`8@Q08HaP8DY@8@Q08Li`8@Q08DY@8Y
BP92409S60Moo`40005oo`005Goo00<007ooOol00Woo0Tic0Woo0U[F0Q240S6<0PaS0QBU0Re[0QS6
0RDY0PaS0Q2410aS0PQ20PaS0P000QS60PQ210aS0PQ211BU0PaS0Q240QBU0PQ211S60QBU0PaS0Q24
0P000P@Q0P000Q240P@Q0PaS0PQ20P@Q0P000PaS0P000PQ20P000PQ210@Q10aS0Q240P@Q0PQ210@Q
0PQ20Q240P@Q0PQ20PaS0P@Q0Q2400<48A2448@00P@Q0PaS0PQ20PaS0PQ20PaS1PQ20PaS10Q20P@Q
0PQ20PaS0PQ20Q2410000QBU0PQ210aS10Q20P@Q0P000P@Q0P000QcW0PQ20P000PQ20PaS0Q240QS6
0PQ20P@Q0P000Q240P@Q0QBU0PaS0Q240P@Q10Q20QBU0Q240PaS0QcW0PaS0Q240QS60QBU0Q240QcW
0Q240QBU0RU:0T8@0V<H1goo0@000Goo000EOol00`00Oomoo`02Ool2BU82Ool2AS425:D2:DX25:D2
48@25:D2124224828@P400025:D212428@P26<H27>L248@236<2248236<200046<H21244248436<2
248236<200022482124436<26<H236<4248436<22482124200021242248236<22482124236<21242
24840002248236<2000248@2124224821243248236<20002248236<4248236<2248212426<H248@2
248236<2000248@636<2248236<2000248@2248436<812420006248248@25:D2000236<224820002
36<25:D448@236<25:D236<224827>L26<H2248248@27>L224845:D224829BT248@27>L2:DX2<H`2
DY@7Ool10001Ool001Eoo`03001oogoo009oo`9:DP9oo`96<@8DY@8YBP8DY@8@Q08DY@848@88@P8Q
20@0008DY@848@8Q208HaP8Li`8@Q08<H`88@P8<H`8000@HaP848@@8@P@<H`88@P8<H`800088@P84
8@@<H`8HaP8<H`@8@P@<H`88@P848@8000848@88@P8<H`88@P848@8<H`848@88@P@00088@P8<H`80
008@Q0848@88@P848@<8@P8<H`800088@P8<H`@8@P8<H`88@P848@8HaP8@Q088@P8<H`80008@Q0H<
H`88@P8<H`80008@Q088@P@<H`P48@8000H8@P8@Q08DY@80008<H`88@P80008<H`8DY@@@Q08<H`8D
Y@8<H`88@P8Li`8HaP88@P8@Q08Li`88@P@DY@88@P8U:@8@Q08Li`8YBP8aS09BU0Moo`40005oo`00
5Goo00<007ooOol00Woo0TYB0Woo0TYB0S6<0Sg_0R480PaS0S6<0Q240P@Q0RU:10@Q0Q2411S60QBU
0PaS0R480P@Q0QBU0Q240PQ20PaS0Q240PaS0Q240PaS0P000PQ20P@Q0PQ20PaS0PQ20Q240PQ20P@Q
0PaS0P0010Q210@Q0PQ20Q240PaS11240PQ20P@Q0PaS0P@Q0PaS0PQ20QBU0P@Q10Q20P000P@Q0PaS
0PQ20QBU1@Q211240P@Q0PaS0PQ20P@Q10Q21PaS0PQ210aS0P000PQ20P@Q10Q20P@Q0PQ210@Q0PaS
0P@Q0P000PaS0Q240PaS0P@Q0PaS0QBU0PaS0PQ211240PaS0QBU0PaS0PQ20PaS0PQ20Q2410Q20PaS
0QcW0RU:0P@Q0Q241PaS0P@Q0PaS0RDY0QcW0PaS0Sg_0RU:0U[F1goo0@000Goo000EOol00`00Oomo
o`02Ool2BU82Ool2BU82<H`2?Nl28@P236<2<H`248@21242:DX4124248@46<H25:D236<28@P21242
5:D248@2248236<248@236<248@236<2000224821242248236<2248248@22482124236<200042484
1242248248@236<448@22482124236<2124236<224825:D2124424820002124236<224825:D52484
48@2124236<224821244248636<2248436<2000224821244248212422484124236<21242000236<2
48@236<2124236<25:D236<2248448@236<25:D236<2248236<2248248@4248236<27>L2:DX21242
48@636<2124236<29BT27>L236<2?Nl2:DX2F]H7Ool10001Ool001Eoo`03001oogoo009oo`8icP9o
o`9F]@8aS08Q208U:@@@Q08DY@8U:@@8@P8@Q08Li`H8@P8DY@88@P8HaP8Li`8DY@88@P8DY@8@Q08<
H`80008@Q0848@8Li`P<H`848@8<H`848@8<H`88@P8@Q0@<H`848@8<H`88@P848@8DY@848@@8@P84
8@8<H`@8@P8@Q0800088@P848@88@P8<H`8000848@88@P0348@0000000H@Q08000H<H`88@P848@H@
Q088@P8<H`88@P8DY@@8@P8@Q08DY@80008<H`8@Q0848@8<H`@DY@88@P8DY@8HaP848@H<H`@@Q084
8@8@Q08<H`@8@P@<H`88@P8<H`848@8<H`848@8Li`8<H`8Li`88@P8DY@8<H`8DY@8<H`8@Q08DY@84
8@8icP8aS09JePMoo`40005oo`005Goo00<007ooOol00Woo0SW>0Woo0UJe0S6<0R480RDY11240QBU
0RDY10Q20Q240QcW1PQ20QBU0PQ20QS60QcW0QBU0PQ20QBU0Q240PaS0P000Q240P@Q0QcW20aS0P@Q
0PaS0P@Q0PaS0PQ20Q2410aS0P@Q0PaS0PQ20P@Q0QBU0P@Q10Q20P@Q0PaS10Q20Q240P000PQ20P@Q
0PQ20PaS0P000P@Q0PQ200<@Q00000001Q240P001PaS0PQ20P@Q1Q240PQ20PaS0PQ20QBU10Q20Q24
0QBU0P000PaS0Q240P@Q0PaS11BU0PQ20QBU0QS60P@Q1PaS11240P@Q0Q240PaS10Q210aS0PQ20PaS
0P@Q0PaS0P@Q0QcW0PaS0QcW0PQ20QBU0PaS0QBU0PaS0Q240QBU0P@Q0SW>0S6<0U[F1goo0@000Goo
000EOol00`00Oomoo`02Ool2AS42Ool2G_L26<H2;F/27>L46<H236<29BT236<648@26<H2124436<2
48@25:D436<27>L22482000236<248@236<4124248@2248236<4124236<22482124236<248@22482
00041242248636<248@2248248@236<2248248@436<2248236<248@212442483124224825:D22482
124224820002248236<4248212422482124248@20002124248@4124200042484124236<224827>L2
36<21244248248@2124248@2248200022482000236<2124224826<H236<448@26<H236<26<H25:D2
36<2124224827>L236<448@45:D2248236<4<H`2E[D7Ool10001Ool001Eoo`8000=oo`96<@9oo`9N
m`8HaP8]J`8Li`@HaP8<H`8U:@8<H`H@Q08HaP848@@<H`8@Q08DY@@<H`8Li`88@P80008<H`8@Q08<
H`@48@8@Q088@P8<H`@48@8<H`88@P848@8<H`8@Q088@P8000@48@88@PH<H`8@Q088@P8@Q08<H`88
@P8@Q0@<H`88@P8<H`8@Q0848@@8@P<48@88@P8DY@88@P848@88@P800088@P8<H`@8@P848@88@P84
8@8@Q08000848@8@Q0@48@8000@8@P@48@8<H`88@P8Li`8<H`848@@8@P8@Q0848@8@Q088@P800088
@P80008<H`848@88@P8HaP8<H`@@Q08HaP8<H`8HaP8DY@8<H`848@88@P8Li`8<H`@@Q0@DY@88@P8<
H`@aS09F]@Ioo`80005oo`005Goo00<007ooOol00Woo0T8@0Woo0V<H0RU:0S6<0R480Q240RU:0QBU
0R480Q240QcW0PQ20QBU0Q240P@Q0Q240PaS0QBU0PaS0Q240QBU0Q240PaS0PQ20P@Q0Q240PaS0P@Q
10Q20PaS0PQ20QBU0PaS10@Q10aS0PQ20P@Q0P000PQ20P@Q0P0010aS0P@Q10000PQ20Q240P000Q24
0P@Q1PQ20PaS0P@Q0QBU0Q240PaS00<001BU5:D00P@Q0PQ20PaS0P000P@Q0QBU0PQ20PaS0P@Q0PQ2
0PaS10Q20PaS0P000Q240P@Q0PQ20PaS0P0010Q20Q240PQ20PaS0P000PaS0P@Q0PaS0PQ20PaS10@Q
0PQ20PaS0PQ20QBU0P@Q10Q20QBU0P@Q100010aS11240P@Q11BU0RU:0P@Q1QS60QcW0P000Q240SW>
0QS60Ukg1goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02Ool2HaP2:DX2<H`28@P248@2:DX25:D2
8@P248@27>L224825:D248@2124248@236<25:D236<248@25:D248@236<22482124248@236<21244
248236<224825:D236<4124436<224821242000224821242000436<212440002248248@2000248@2
1246248236<212425:D248@236<00`005:DDY@021242248236<2000212425:D2248236<212422482
36<4248236<2000248@21242248236<20004248248@2248236<2000236<2124236<2248236<41242
248236<224825:D2124424825:D21244000436<448@212445:D2:DX212466<H27>L2000248@2>Lh2
6<H2G_L7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9oo`9F]@8e[@96<@8<H`@Q208<H`80008L
i`88@P8DY@8<H`848@8<H`88@P848@8DY@848@8HaP@<H`8HaP88@P848@88@P8@Q088@P848@8HaP8<
H`88@P@@Q088@P8DY@88@P8DY@88@P8<H`8000H8@P848@88@P8@Q08<H`88@P8<H`848@88@P848@8<
H`8@Q08<H`848@H8@PD48@@8@P@<H`@8@P@48@88@P8<H`88@P8@Q0848@88@P848@@8@P80008DY@8<
H`88@P848@8<H`8HaP88@P8HaP@8@P8<H`848@88@P848@8<H`8DY@8@Q08<H`848@@@Q088@P8<H`@4
8@@<H`88@P@48@88@PHHaP8YBP8<H`8@Q0@<H`8YBP80008@Q08]J`8e[@9BU0Moo`40005oo`005Goo
00<007ooOol00Woo0Tic0Woo0UJe0SF]0THa0PaS12480PaS0P000QcW0PQ20QBU0PaS0P@Q0PaS0PQ2
0P@Q0QBU0P@Q0QS610aS0QS60PQ20P@Q0PQ20Q240PQ20P@Q0QS60PaS0PQ211240PQ20QBU0PQ20QBU
0PQ20PaS0P001PQ20P@Q0PQ20Q240PaS0PQ20PaS0P@Q0PQ20P@Q0PaS0Q240PaS0P@Q1PQ21@@Q10Q2
10aS10Q210@Q0PQ20PaS0PQ20Q240P@Q0PQ20P@Q10Q20P000QBU0PaS0PQ20P@Q0PaS0QS60PQ20QS6
10Q20PaS0P@Q0PQ20P@Q0PaS0QBU0Q240PaS0P@Q11240PQ20PaS10@Q10aS0PQ210@Q0PQ21QS60RU:
0PaS0Q2410aS0RU:0P000Q240Re[0SF]0U:D1goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2Ool2
DY@2<H`2@Q02124248@25:D448@236<224846<H200025:D200025:D27>L236<26<H2124248@26<H2
36<2248248@2000448@25:D2000424821242248236<41242248248@212425:D424825:D624820002
36<2124248@2124224841242000212420006248336<21242248236<4124236<2248236<224826<H4
24821242000236<4248212422482124236<21242248236<248@2000636<248@236<248@2000236<2
248236<248@2124236<2248236<2000224825:D2124236<448@25:D248@26<H29BT2248412422482
9BT28@P25:D2>Lh2;F/2G_L7Ool10001Ool001Eoo`03001oogoo009oo`9BU09oo`9BU08aS0924084
8@8@Q08DY@@@Q08<H`88@P@HaP80008DY@80008DY@8Li`8<H`8HaP848@8@Q08HaP8<H`88@P8@Q080
00@@Q08DY@8000@8@P848@88@P8<H`@48@88@P8@Q0848@8DY@@8@P8DY@H8@P80008<H`848@8@Q084
8@88@P@48@8000848@8000H8@P<<H`848@88@P8<H`@48@8<H`88@P8<H`88@P8HaP@8@P848@80008<
H`@8@P848@88@P848@8<H`848@88@P8<H`8@Q08000H<H`8@Q08<H`8@Q080008<H`88@P8<H`8@Q084
8@8<H`88@P8<H`800088@P8DY@848@8<H`@@Q08DY@8@Q08HaP8U:@88@P@48@88@P8U:@8Q208DY@8i
cP8]J`9Nm`Moo`40005oo`005Goo00<007ooOol00Woo0T8@0Woo0V<H0SF]0T8@0PaS0QS60RDY0PaS
10Q20P000PQ20QcW0PQ20Q240PQ20QS60PaS0PQ20PaS0QBU0QcW0PQ20P@Q0PQ20P@Q0Q240PQ20Q24
0PaS0PQ20QcW0Q240P000PQ20P@Q0Q240QBU0PQ20P@Q0PQ20Q240P@Q0PQ20PaS0P0010@Q10Q210@Q
0QBU0P@Q0Q240P@Q0PaS0P000PaS10@Q0`0010@Q0Q240PQ20Q2410@Q0PQ210aS0P@Q0PQ20P000PQ2
10@Q11240P@Q0QS60QBU0P@Q0PQ20PaS0P000P@Q10Q20PaS11240PaS0P@Q0P000PQ20PaS0PQ20PaS
0Q240P@Q0QS60PaS0R4810aS0QBU0PaS0PQ20QS60Q240PaS0QBU0QS60P@Q0Q240PaS0QS60QBU0RU:
0QBU0RU:0RDY0V<H1goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02Ool2HaP2=Jd2@Q0236<26<H2
9BT236<42482000224827>L2248248@224826<H236<2248236<25:D27>L2248212422482124248@2
248248@236<224827>L248@200022482124248@25:D224821242248248@21242248236<200041244
248412425:D2124248@2124236<2000236<412430004124248@2248248@41242248436<212422482
00022484124448@212426<H25:D21242248236<200021244248236<448@236<212420002248236<2
248236<248@212426<H236<28@P436<25:D236<224826<H248@236<25:D26<H2124248@236<26<H2
5:D2:DX25:D2:DX29BT2HaP7Ool10001Ool001Eoo`03001oogoo009oo`9>L`9oo`96<@8e[@8YBP8D
Y@8Q208@Q088@P8@Q08<H`848@@@Q088@P@@Q0848@88@P@<H`H8@P8<H`88@P848@8<H`88@P800088
@P8DY@8<H`8000H8@P8<H`8@Q088@P8DY@8@Q0@48@8DY@88@P8<H`88@P8@Q0848@8DY@88@P848@80
0088@P8<H`80008HaP848@88@P@48@800003248@Q124008<H`848@88@PP48@80008<H`848@8<H`84
8@8DY@8@Q0848@88@P8<H`H48@8@Q0@<H`848@88@P@48@@@Q0@<H`88@P80008<H`8@Q0@<H`88@P84
8@H<H`88@P8<H`8@Q08DY@848@8<H`@8@P8HaP8DY@8<H`848@8U:@88@P8Li`8U:@8YBP8e[@8YBP9N
m`Moo`40005oo`005Goo0P000goo0Tic0Woo0THa0SF]0RU:0QBU0R480Q240PQ20Q240PaS0P@Q1124
0PQ211240P@Q0PQ210aS1PQ20PaS0PQ20P@Q0PaS0PQ20P000PQ20QBU0PaS0P001PQ20PaS0Q240PQ2
0QBU0Q2410@Q0QBU0PQ20PaS0PQ20Q240P@Q0QBU0PQ20P@Q0P000PQ20PaS0P000QS60P@Q0PQ210@Q
0P0000<8@Q2448@00PaS0P@Q0PQ220@Q0P000PaS0P@Q0PaS0P@Q0QBU0Q240P@Q0PQ20PaS1P@Q0Q24
10aS0P@Q0PQ210@Q112410aS0PQ20P000PaS0Q2410aS0PQ20P@Q1PaS0PQ20PaS0Q240QBU0P@Q0PaS
10Q20QS60QBU0PaS0P@Q0RDY0PQ20QcW0RDY0RU:0SF]0RU:0Ukg1Woo0P000Goo000EOol00`00Oomo
o`02Ool2BU82Ool2F]H2<H`2;F/26<H25:D26<H436<45:D412446<H248@2000248@2124236<25:D2
36<20002248636<412425:D248@436<2248448@2124236<21242000248@236<248@236<200022482
48@25:D2000248@412420002124248@4124248@224829BT2124236<5124248@2248236<212420002
48@2248212422482124424845:D2124436<200026<H22482000224821244248248@2248236<21242
248248@436<224827>L212425:D236<224825:D236<21242000436<2000836<200026<H25:D248@2
5:D27>L26<H27>L2?Nl2;F/2IcT7Ool10001Ool001Eoo`03001oogoo009oo`9:DP9oo`9JeP8aS08]
J`8HaP8DY@8HaP@<H`@DY@@48@@HaP8@Q080008@Q0848@8<H`8DY@8<H`800088@PH<H`@48@8DY@8@
Q0@<H`88@P@@Q0848@8<H`848@80008@Q08<H`8@Q08<H`800088@P8@Q08DY@80008@Q0@48@800084
8@8@Q0@48@8@Q088@P8U:@848@8<H`D48@8@Q088@P8<H`848@80008@Q088@P848@88@P848@@8@P@D
Y@848@@<H`80008HaP88@P800088@P848@@8@P8@Q088@P8<H`848@88@P8@Q0@<H`88@P8Li`848@8D
Y@8<H`88@P8DY@8<H`848@8000@<H`8000P<H`80008HaP8DY@8@Q08DY@8Li`8HaP8Li`8mk`8]J`9W
>@Moo`40005oo`005Goo00<007ooOol00Woo0Tic0Woo0WNm0RU:0THa11240QcW10aS0Q240PaS0P00
0P@Q0PaS0QS60Q240QBU0Q240PQ20PaS0PQ20P@Q0R480P@Q0PaS0Q240PaS0Q240QBU0PaS0PQ20P@Q
0QS60PaS0Q2410Q20PaS10Q210aS0P0010aS1P@Q0P000PaS0PQ20QBU0PQ20P000P@Q0PaS0P@Q0P00
10aS0Q240`@Q0PaS0PQ20P@Q0PQ20Q240PQ20P@Q0PQ210@Q0PQ20PaS10@Q0PQ20QBU0Q240P@Q0QS6
0P000PQ210@Q1PaS0QS60P@Q10Q20P000Q240P@Q0P000PaS0P@Q0PQ20PaS0PQ20P@Q10aS0P@Q0PaS
0PQ20P@Q0PQ20QS60P@Q0PQ20P@Q0R480Q240P@Q0QS60PQ20PaS0QS60Q240PaS0SW>0Re[0V]J1goo
0@000Goo000EOol00`00Oomoo`02Ool2CW<2Ool2Mkd2:DX2AS4448@27>L436<248@236<200021242
36<26<H248@25:D248@2248236<2248212428@P2124236<248@236<248@25:D236<2248212426<H2
36<248@4248236<4248436<2000436<61242000236<224825:D224820002124236<21242000436<2
48@3124236<224821242248248@22482124224841242248236<4124224825:D248@212426<H20002
2484124636<26<H212442482000248@21242000236<21242248236<22482124436<2124236<22482
124224826<H21242248212428@P248@212426<H2248236<26<H248@236<2>Lh2;F/2JeX7Ool10001
Ool001Eoo`03001oogoo009oo`92409oo`9:DP8aS08mk`@DY@848@8@Q08DY@8Li`88@P8<H`848@H8
@P8@Q08HaP80008<H`8DY@@<H`800088@P8DY@8<H`88@P848@H8@P@<H`@0008@Q080008@Q0@<H`84
8@8@Q08<H`8DY@@@Q08<H`848@88@P80008<H`88@P8<H`848@H<H`848@8000848@8@Q00336<48@@Q
0088@P8<H`848@8<H`848@88@P@000@8@P8<H`88@P8@Q08000848@80008<H`88@P8<H`80008HaP8<
H`@48@@<H`8@Q08<H`848@80008<H`@8@P8@Q08<H`88@PH48@800088@P8DY@@8@P8Li`88@P8HaP88
@P80008HaP8DY@@@Q08HaP8DY@80008Li`@<H`8mk`8U:@9[FPMoo`40005oo`005Goo00<007ooOol0
0Woo0T8@0Woo0TYB0S6<0Sg_11BU0P@Q0Q240QBU0QcW0PQ20PaS0P@Q1PQ20Q240QS60P000PaS0QBU
10aS0P000PQ20QBU0PaS0PQ20P@Q1PQ210aS10000Q240P000Q2410aS0P@Q0Q240PaS0QBU11240PaS
0P@Q0PQ20P000PaS0PQ20PaS0P@Q1PaS0P@Q0P000P@Q0Q2400<<H`@Q12400PQ20PaS0P@Q0PaS0P@Q
0PQ2100010Q20PaS0PQ20Q240P000P@Q0P000PaS0PQ20PaS0P000QS60PaS10@Q10aS0Q240PaS0P@Q
0P000PaS10Q20Q240PaS0PQ21P@Q0P000PQ20QBU10Q20QcW0PQ20QS60PQ20P000QS60QBU11240QS6
0QBU0P000QcW10aS0Sg_0RDY0V]J1goo0@000Goo000EOol00`00Oomoo`02Ool2AS42Ool2DY@4<H`2
7>L248@224825:D28@P26<H248@45:D27>L224825:D224826<H6248236<27>L248@2248436<21242
248448@2248236<26<H2000224826<H236<412425:D2124636<4248248@412420006124200021242
48@212422482124236<25:D00`002488@P0248@22482124436<2248248@2248236<4124224825:D4
12429BT224820002248236<212425:D436<248@236<2124236<22486124236<248@2248212422482
48@224825:D2124436<2000236<25:D236<22484124236<26<H25:D248@224825:D236<248@29BT2
=Jd28@P2F]H7Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`96<@9oo`9BU0@aS08L
i`8@Q088@P8DY@8Q208HaP8@Q0@DY@8Li`88@P8DY@88@P8HaPH8@P8<H`8Li`8@Q088@P@<H`848@88
@P@@Q088@P8<H`8HaP800088@P8HaP8<H`@48@8DY@848@H<H`@8@P8@Q0@48@8000H48@8000848@8@
Q0848@88@P848@8<H`8DY@030008@PQ2008@Q088@P848@@<H`88@P8@Q088@P8<H`@48@88@P8DY@@4
8@8U:@88@P800088@P8<H`848@8DY@@<H`8@Q08<H`848@8<H`88@PH48@8<H`8@Q088@P848@88@P8@
Q088@P8DY@848@@<H`80008<H`8DY@8<H`88@P@48@8<H`8HaP8DY@8@Q088@P8DY@8<H`8@Q08U:@8e
[@8Q209JePMoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool2
=Jd2Ool2E[D4;F/25:D47>L26<H41242:DX26<H2124448@2124236<248@224826<H224828@P236<2
000236<200027>L2124224821242000236<448@236<248@46<H45:D248@2248236<2124236<25:D4
36<2000236<248@20002124424821242248448@4248236<312420002248212422482000236<:1242
36<212422484124248@236<4124236<25:D248@25:D236<200025:D236<20002124248@4000236<4
000236<2124436<424825:D212426<H25:D200027>L2248436<224827>L45:D424826<H28@P2?Nl2
;F/2IcT7Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo0P000goo0SF]0Woo0UJe
12e[0QBU11cW0QS610@Q0RU:0QS60P@Q11240P@Q0PaS0Q240PQ20QS60PQ20R480PaS0P000PaS0P00
0QcW0P@Q0PQ20P@Q0P000PaS11240PaS0Q2411S611BU0Q240PQ20PaS0P@Q0PaS0QBU10aS0P000PaS
0Q240P000P@Q10Q20P@Q0PQ2112410Q20PaS0`@Q0P000PQ20P@Q0PQ20P000PaS2P@Q0PaS0P@Q0PQ2
10@Q0Q240PaS10@Q0PaS0QBU0Q240QBU0PaS0P000QBU0PaS0P000P@Q0Q2410000PaS10000PaS0P@Q
10aS10Q20QBU0P@Q0QS60QBU0P000QcW0PQ210aS0PQ20QcW11BU10Q20QS60R480Sg_0Re[0VLi1Woo
0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007ooOol00Woo0THa0Woo0VLi0Re[0RU:0Q24
0QBU0QS60P@Q0Q240PQ20QcW0Q240PaS0Q2411BU10aS0Q240P@Q0PaS0PQ20PaS0P@Q0PaS0Q240PaS
0PQ20Q240PQ221BU0Q240PQ20QBU0PaS0PQ20Q240PQ20P000PQ20PaS0Q240QBU10aS0P@Q0PaS0Q24
0PQ20P@Q0P000PaS0P@Q10Q20P000P@Q0PQ20P@Q00<000@Q12400P@Q0PQ20PaS0P@Q10Q20Q241P@Q
0P000PQ211240P@Q10aS0QS61P@Q0QBU0PaS0QcW0PQ20QBU0Q240P000QBU0PQ20PaS11240QBU0P@Q
0PQ20Q240PaS0PQ20PaS0PQ20QS60PQ20P000Q240QBU0PaS0P0010aS0RDY10aS0RDY0Q240PQ20QBU
0QS60RDY0RU:0SF]0V<H1goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001o
ogoo009oo`96<@9oo`9W>@8]J`8YBP8@Q08DY@8HaP848@8@Q088@P8Li`8@Q08<H`8@Q0@DY@@<H`8@
Q0848@8<H`88@P8<H`848@8<H`8@Q08<H`88@P8@Q088@PPDY@8@Q088@P8DY@8<H`88@P8@Q088@P80
0088@P8<H`8@Q08DY@@<H`848@8<H`8@Q088@P848@80008<H`848@@8@P8000848@88@P848@030004
8@@Q00848@88@P8<H`848@@8@P8@Q0H48@800088@P@@Q0848@@<H`8HaPH48@8DY@8<H`8Li`88@P8D
Y@8@Q080008DY@88@P8<H`@@Q08DY@848@88@P8@Q08<H`88@P8<H`88@P8HaP88@P80008@Q08DY@8<
H`8000@<H`8U:@@<H`8U:@8@Q088@P8DY@8HaP8U:@8YBP8e[@9S60Moo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo0V<H0Woo0Ukg0RU:0TYB0P@Q0QBU0SF]0P@Q0PaS0RU:0Q240PQ20PaS
0P@Q0PQ20QcW0PQ20P000Q240PQ20QBU0Q240QS60PaS0P@Q10Q211cW11241P000P@Q10aS0PQ20P00
10@Q0PQ20PaS0P@Q10000PQ210000Q240PQ20PaS0PQ20P@Q0PQ20P@Q0PaS10@Q0P002@Q20PaS10@Q
0QBU0PQ20P@Q10Q20PaS0P@Q0PQ21P000P@Q10aS0PQ20P@Q0PQ20P000PaS0PQ20QBU0Q2410Q20PaS
0QBU10Q20QS610000P@Q0PQ20Q240PaS11S60PaS0PQ20PaS0QBU11240PaS0Q240QS60RDY0PQ21124
0QBU0QS60Q240PaS0QcW0Sg_0RU:0V<H1goo0@000Goo000EOol00`00Oomoo`02Ool2HaP2Ool2G_L2
:DX2BU8212425:D2=Jd2124236<2:DX248@2248236<2124224827>L22482000248@224825:D248@2
6<H236<2124424847>L448@60002124436<2248200041242248236<2124400022484000248@22482
36<2248212422482124236<412420009248236<412425:D224821244248236<21242248600021244
36<2248212422482000236<224825:D248@4248236<25:D424826<H400021242248248@236<46<H2
36<2248236<25:D448@236<248@26<H29BT2248448@25:D26<H248@236<27>L2?Nl2:DX2HaP7Ool1
0001Ool001Eoo`03001oogoo009oo`9W>@9oo`9S608aS096<@8Li`8@Q0@Li`8@Q08DY@8<H`8DY@8L
i`8@Q088@P8@Q08<H`8U:@8HaP8U:@8DY@H<H`848@88@P@48@8HaP8@Q0@48@@@Q088@P8<H`8@Q088
@P8<H`88@P8<H`@8@P848@8@Q0H8@P8<H`88@P8@Q088@P8<H`@8@PH48@8@Q0@<H`88@P0336<8@PQ2
00h48@8<H`848@8<H`848@88@P@<H`8DY@848@88@P8@Q08<H`848@8HaP8<H`8DY@8<H`8HaPP<H`8D
Y@8@Q088@P8@Q088@P8<H`8@Q0848@88@P8@Q08<H`8HaP@48@8DY@8HaP8@Q0@8@P848@8DY@8@Q08D
Y@8<H`848@8Li`8@Q08Li`8<H`8@Q08e[@8Q209[FPMoo`40005oo`005Goo00<007ooOol00Woo0VLi
0Woo0V<H0S6<0THa0QcW0Q2411cW0Q240QBU0PaS0QBU0QcW0Q240PQ20Q240PaS0RDY0QS60RDY0QBU
1PaS0P@Q0PQ210@Q0QS60Q2410@Q11240PQ20PaS0Q240PQ20PaS0PQ20PaS10Q20P@Q0Q241PQ20PaS
0PQ20Q240PQ20PaS10Q21P@Q0Q2410aS0PQ200<<H`Q224803P@Q0PaS0P@Q0PaS0P@Q0PQ210aS0QBU
0P@Q0PQ20Q240PaS0P@Q0QS60PaS0QBU0PaS0QS620aS0QBU0Q240PQ20Q240PQ20PaS0Q240P@Q0PQ2
0Q240PaS0QS610@Q0QBU0QS60Q2410Q20P@Q0QBU0Q240QBU0PaS0P@Q0QcW0Q240QcW0PaS0Q240SF]
0R480V]J1goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2Ool2IcT2CW<29BT26<H45:D224826<H2
24825:D248@236<27>L236<224825:D2248248@236<448@22482124224825:D236<2124436<27>L2
36<2000236<2248248@412425:D22482124236<6248236<4124436<2124236<20002124236<22482
36<4124248@2248248@00`Q212448@0224861244248436<4248248@4248236<2248236<2248236<2
248200025:D41244248236<248@2124248@4124248@2124200025:D26<H212425:D248@224846<H6
48@236<29BT224825:D2000248@25:D236<448@2124248@25:D21242=Jd2BU82JeX7Ool10001Ool0
01Eoo`03001oogoo009oo`9BU09oo`9W>@9>L`8U:@8HaP@DY@88@P8HaP88@P8DY@8@Q08<H`8Li`8<
H`88@P8DY@88@P8@Q08<H`@@Q088@P848@88@P8DY@8<H`848@@<H`8Li`8<H`80008<H`88@P8@Q0@4
8@8DY@88@P848@8<H`H8@P8<H`@48@@<H`848@8<H`8000848@8<H`88@P8<H`@48@8@Q088@P8@Q003
24848@@Q0088@PH48@@8@P@<H`@8@P8@Q0@8@P8<H`88@P8<H`88@P8<H`88@P80008DY@@48@@8@P8<
H`8@Q0848@8@Q0@48@8@Q0848@80008DY@8HaP848@8DY@8@Q088@P@HaPH@Q08<H`8U:@88@P8DY@80
008@Q08DY@8<H`@@Q0848@8@Q08DY@848@8e[@9:DP9[FPMoo`40005oo`005Goo00<007ooOol00Woo
0Tic0Woo0Vmk0T8@0SW>0PQ20PaS0QBU11S60RU:10Q20QS60Q241PaS0QS60PQ20QBU0Q240P@Q0QBU
0PaS0P@Q0QS610Q20Q240PaS0P@Q0P000QBU0Q240QS60P@Q0QBU10Q20PaS0QBU0P000PaS10Q20QS6
10@Q0P000PQ20PaS0P@Q10Q20Q240PQ20P@Q0PQ20P@Q10aS0`@Q0Q240PQ20PaS0Q240PaS0QBU0PaS
10Q20PaS0QBU0Q240PaS0QS60P@Q0PaS1Q240P000PQ20P@Q0PaS0P@Q10aS0P@Q0P000P@Q0PaS0QBU
0Q240PaS0P@Q0QBU0P@Q0PaS10@Q0PaS0RDY0Q240QBU0PaS0PQ20Q240PQ20PaS0QBU2PaS0R480PQ2
0R480PaS0QBU0RU:0SF]0S6<0VLi1goo0@000Goo000EOol20003Ool2CW<2Ool2Kg/2@Q02>Lh22482
36<25:D46<H2:DX424826<H248@636<26<H224825:D248@212425:D236<212426<H4248248@236<2
124200025:D248@26<H212425:D4248236<25:D2000236<424826<H412420002248236<212442482
48@2248212422482124436<3124248@2248236<248@236<25:D236<4248236<25:D248@236<26<H2
124236<648@200022482124236<2124436<212420002124236<25:D248@236<212425:D2124236<4
124236<29BT248@25:D236<2248248@2248236<25:D:36<28@P224828@P236<25:D2:DX2=Jd2<H`2
IcT6Ool20001Ool001Eoo`03001oogoo009oo`96<@9oo`9JeP8]J`8e[@8@Q0@DY@@HaP8@Q0@DY@8H
aP8<H`8@Q08HaP848@8DY@8<H`80008@Q08DY@@8@P8Li`88@P8@Q08Q208<H`848@88@P8DY@8<H`8D
Y@88@P8@Q0@8@P8@Q08<H`8@Q088@P8@Q0848@8<H`80008@Q0848@@8@P8<H`848@88@P8HaP@48@8<
H`848@88@P8@Q0848@8@Q00324848@@Q0088@P848@H<H`848@8<H`88@P80008<H`@@Q080008@Q08<
H`8DY@8<H`8DY@88@P8<H`88@P@@Q0@8@P848@8DY@848@8@Q08<H`8Li`88@P848@80008@Q080008<
H`848@88@P8<H`8Q20@8@P8@Q08<H`8000@@Q08HaP8<H`8@Q08DY@8YBP8Q208Li`8U:@8Q208<H`8a
S092408]J`9Nm`Moo`40005oo`005Goo00<007ooOol00Woo0THa0Woo0U[F0Re[0SF]0Q2411BU11S6
0Q2411BU0QS60PaS0Q240QS60P@Q0QBU0PaS0P000Q240QBU10Q20QcW0PQ20Q240R480PaS0P@Q0PQ2
0QBU0PaS0QBU0PQ20Q2410Q20Q240PaS0Q240PQ20Q240P@Q0PaS0P000Q240P@Q10Q20PaS0P@Q0PQ2
0QS610@Q0PaS0P@Q0PQ20Q240P@Q0Q2400<8@P@Q12400PQ20P@Q1PaS0P@Q0PaS0PQ20P000PaS1124
0P000Q240PaS0QBU0PaS0QBU0PQ20PaS0PQ2112410Q20P@Q0QBU0P@Q0Q240PaS0QcW0PQ20P@Q0P00
0Q240P000PaS0P@Q0PQ20PaS0R4810Q20Q240PaS0P0011240QS60PaS0Q240QBU0RU:0R480QcW0RDY
0R480PaS0S6<0T8@0Re[0Ukg1goo0@000Goo000EOol00`00Oomoo`02Ool2Kg/2Ool2DY@26<H2BU82
36<26<H29BT2248236<448@236<26<H236<28@P248@45:D21242000448@25:D212425:D248@22482
124424825:D236<2124236<248@61242248248@2248236<2248236<2124236<26<H22482124236<2
48@2124248@2124424841242248236<2248236<00aBU36<<H`0236<2248236<248@2248212420002
248248@224840004124236<2248236<212422482124236<2000236<2248248@236<2248236<22482
5:D2248436<2248248@2248436<448@412426<H2248236<248@25:D26<H248@27>L224828@P26<H2
7>L29BT248@28@P29BT27>L2;F/2?Nl2CW<7Ool10001Ool001Eoo`03001oogoo009oo`9_N`9oo`9B
U08HaP9:DP8<H`8HaP8U:@88@P8<H`@@Q08<H`8HaP8<H`8Q208@Q0@DY@848@8000@@Q08DY@848@8D
Y@8@Q088@P848@@8@P8DY@8<H`848@8<H`8@Q0H48@88@P8@Q088@P8<H`88@P8<H`848@8<H`8HaP88
@P848@8<H`8@Q0848@8@Q0848@@8@P@48@88@P8<H`88@P8<H`035:D<H`aS008<H`88@P8<H`8@Q088
@P848@800088@P8@Q088@P@000@48@8<H`88@P8<H`848@88@P848@8<H`80008<H`88@P8@Q08<H`88
@P8<H`88@P8DY@88@P@<H`88@P8@Q088@P@<H`@@Q0@48@8HaP88@P8<H`8@Q08DY@8HaP8@Q08Li`88
@P8Q208HaP8Li`8U:@8@Q08Q208U:@8Li`8]J`8mk`9>L`Moo`40005oo`005Goo00<007ooOol00Woo
0U[F0Woo0U[F0RU:0UJe0PQ20P000S6<0PaS0Q240QcW0QBU10Q20R480QS60QcW0R480QS60P@Q0P00
0QBU0PQ20QcW0PaS0Q240P@Q0PQ20P000P@Q0PaS11240P@Q0PaS0PQ20Q240P000P@Q0PaS0Q240PaS
0Q240P000QBU0P0010@Q0PQ210aS0Q241PQ210aS10Q20Q2410@Q0PaS1@@Q10aS0Q240PaS0PQ20Q24
0PaS0PQ20Q240PQ20PaS0P@Q0PQ20Q240P000P@Q10Q20PaS0P000PQ20P000Q240P@Q0PaS11BU0P@Q
0PaS0QBU0PQ20QBU0Q240PaS0PQ210aS0Q240PQ20QS60PaS0PQ20PaS0QBU0RDY0PaS0PQ20QS60QcW
0QS60RU:0QS60Q240S6<0QS60T8@0RU:0Q240S6<0QcW2Goo0@000Goo000EOol00`00Oomoo`02Ool2
F]H2Ool2F]H2:DX2E[D224820002<H`236<248@27>L25:D424828@P26<H27>L28@P26<H212420002
5:D224827>L236<248@2124224820002124236<448@2124236<2248248@20002124236<248@236<2
48@200025:D200041242248436<248@6248436<4248248@4124236<5124436<248@236<2248248@2
36<2248248@2248236<21242248248@200021244248236<200022482000248@2124236<45:D21242
36<25:D224825:D248@236<2248436<248@224826<H236<2248236<25:D29BT236<224826<H27>L2
6<H2:DX26<H248@2<H`26<H2@Q02:DX248@2<H`27>L9Ool10001Ool001Eoo`03001oogoo009oo`96
<@9oo`9[FP92408]J`8DY@@YBP8DY@8Q208Li`88@P8<H`8@Q08U:@8HaP8U:@8Q2080008DY@8<H`@D
Y@88@P848@8HaP88@P8<H`8@Q088@P@@Q088@P848@@<H`88@P@<H`848@@000848@8@Q0@48@8<H`88
@PH@Q08HaP88@P8@Q08<H`8@Q08000@DY@@8@P848@<8@P@@Q0@8@P848@8@Q08<H`@48@8@Q08DY@8@
Q088@P848@8<H`88@P8@Q0HHaP@<H`88@P848@H00088@P8000848@8<H`88@P8HaP8<H`848@8HaP8@
Q08<H`@8@P8@Q08<H`8Q208DY@8<H`@@Q08Li`8HaP@Li`8DY@8<H`848@8HaP8@Q08DY@8U:@8aS084
8@@YBP9_N`Moo`40005oo`005Goo00<007ooOol00Woo0THa0Woo0V]J0T8@0Re[0QBU12U:0QBU0R48
0QcW0PQ20PaS0Q240RDY0QS60RDY0R480P000QBU0PaS11BU0PQ20P@Q0QS60PQ20PaS0Q240PQ21124
0PQ20P@Q10aS0PQ210aS0P@Q10000P@Q0Q2410@Q0PaS0PQ21Q240QS60PQ20Q240PaS0Q240P0011BU
10Q20P@Q0`Q2112410Q20P@Q0Q240PaS10@Q0Q240QBU0Q240PQ20P@Q0PaS0PQ20Q241QS610aS0PQ2
0P@Q1P000PQ20P000P@Q0PaS0PQ20QS60PaS0P@Q0QS60Q240PaS10Q20Q240PaS0R480QBU0PaS1124
0QcW0QS611cW0QBU0PaS0P@Q0QS60Q240QBU0RDY0S6<0P@Q12U:0Vmk1goo0@000Goo000EOol00`00
Oomoo`02Ool2F]H2Ool2Mkd4>Lh45:D28@P248@2>Lh27>L26<H25:D27>L26<H236<248@236<22482
48@236<25:D248@236<2124224826<H41242248412440004124448@2248236<21242248248@42482
36<248@2124448@20002124236<248@21242000236<224820004248248@336<2248236<212442482
124236<412425:D2124836<200045:D22482000224841242248236<612425:D248@2124636<22482
12422482124200025:D2124236<27>L436<47>L26<H248@26<H236<2248248@29BT27>L448@26<H2
36<248@2AS42CW<2G_L7Ool10001Ool001Eoo`8000=oo`9JeP9oo`9g_@@icP@DY@8Q208@Q08icP8L
i`8HaP8DY@8Li`8HaP8<H`8@Q08<H`88@P8@Q08<H`8DY@8@Q08<H`848@88@P8HaP@48@88@P@48@@0
00@48@@@Q088@P8<H`848@88@P8@Q0@8@P8<H`8@Q0848@@@Q08000848@8<H`8@Q0848@80008<H`88
@P8000@8@P8@Q0<<H`88@P8<H`848@@8@P848@8<H`@48@8DY@848@P<H`8000@DY@88@P800088@P@4
8@88@P8<H`H48@8DY@8@Q0848@H<H`88@P848@88@P848@80008DY@848@8<H`8Li`@<H`@Li`8HaP8@
Q08HaP8<H`88@P8@Q08U:@8Li`@@Q08HaP8<H`8@Q096<@9>L`9Nm`Ioo`80005oo`005Goo00<007oo
Ool00Woo0UJe17oo0RU:12e[0QBU0QcW0QS60R480QcW0QS60Q240PQ20RDY0QS60QcW11240P000PQ2
0Q240QS60QBU0PaS0PQ20PaS0QS61Q240P@Q0PaS11240QBU0PaS10Q21Q240PaS0QBU0QS60P@Q0PQ2
0PaS0PQ20P@Q0PQ20PaS0P@Q0Q240P@Q0PQ20P@Q0PaS0PQ20P@Q1PQ200<48A2448@00PQ20PaS0P@Q
0PQ20P@Q0QBU0P@Q0QS610@Q0PaS0QBU0Q2410Q20PaS0QBU0P@Q0Q240PaS11240QS60P000PaS0P00
11241P@Q0PQ20QS610aS0Q240PQ21QBU0RU:0PQ20PaS0QS60QBU0PQ211BU0QS60PaS0R480RDY0RU:
0P@Q0QBU0Q240PaS0P@Q0RU:0R480THa0VLi1goo0@000Goo000EOol00`00Oomoo`02Ool2E[D4Ool2
:DX4;F/25:D27>L26<H28@P27>L26<H248@224829BT26<H27>L448@20002248248@26<H25:D236<2
248236<26<H648@2124236<448@25:D236<4248648@236<25:D26<H21242248236<2248212422482
36<2124248@212422482124236<22482124624800`@Q48@@Q002248236<21242248212425:D21242
6<H4124236<25:D248@4248236<25:D2124248@236<448@26<H2000236<2000448@6124224826<H4
36<248@224865:D2:DX2248236<26<H25:D224845:D26<H236<28@P29BT2:DX212425:D248@236<2
1242:DX28@P2AS42IcT7Ool10001Ool001Eoo`03001oogoo009oo`9F]@9oo`9S608mk`96<@8YBP8@
Q08Li`8U:@88@P8@Q08U:@8DY@80008DY@8Q20@@Q08Li`8<H`8DY@@8@P@48@800088@P8DY@848@8D
Y@8<H`8HaP8@Q08Li`88@P80008DY@8<H`848@8DY@88@P8<H`88@P@@Q088@P@48@88@P8DY@848@88
@P8<H`8Li`8<H`848@80008Q208@Q08<H`8000848@8<H`0348@8@PQ200848@88@P8DY@P<H`848@88
@P848@8<H`8000@@Q088@P80008@Q0848@8@Q0848@8DY@8<H`848@800088@P8<H`H@Q088@P848@88
@P8HaPH8@P8@Q08<H`8HaP88@P8U:@@HaP88@P8HaP8U:@8Li`848@8DY@8HaP8]J`8DY@8aS08<H`8]
J`848@8HaP8@Q08U:@92409>L`9_N`Moo`40005oo`005Goo00<007ooOol00Woo0UJe0Woo0V<H0Sg_
0THa0RU:0Q240QcW0RDY0PQ20Q240RDY0QBU0P000QBU0R4811240QcW0PaS0QBU10Q210@Q0P000PQ2
0QBU0P@Q0QBU0PaS0QS60Q240QcW0PQ20P000QBU0PaS0P@Q0QBU0PQ20PaS0PQ211240PQ210@Q0PQ2
0QBU0P@Q0PQ20PaS0QcW0PaS0P@Q0P000R480Q240PaS0P000P@Q0PaS00<@Q0Q224800P@Q0PQ20QBU
20aS0P@Q0PQ20P@Q0PaS0P0011240PQ20P000Q240P@Q0Q240P@Q0QBU0PaS0P@Q0P000PQ20PaS1Q24
0PQ20P@Q0PQ20QS61PQ20Q240PaS0QS60PQ20RDY11S60PQ20QS60RDY0QcW0P@Q0QBU0QS60Re[0QBU
0S6<0PaS0Re[0P@Q0QS60Q240RDY0T8@0Tic0Vmk1goo0@000Goo000EOol00`00Oomoo`02Ool2IcT2
Ool2G_L248@2;F/2?Nl248@2>Lh46<H29BT42482<H`27>L48@P26<H2:DX66<H636<224825:D26<H2
0002;F/2248212427>L248@2248412426<H224825:D248@25:D248@21242000212425:D248@236<2
2482000248@236<248@2124236<448@21242248248@2248212400`0036<<H`025:D4124624861242
248236<21242248236<2124248@236<25:D224825:D224826<H236<25:D2000236<85:D248@236<4
248248@4248236<21242:DX41242@Q0212425:D27>L212425:D29BT248@2:DX248@47>L236<28@P2
<H`26<H25:D2=Jd2?Nl2Nmh7Ool10001Ool001Eoo`03001oogoo009oo`9W>@9oo`9Nm`8@Q08]J`8m
k`8@Q08icP@HaP8U:@@8@P8aS08Li`@Q208HaP8YBPHHaPH<H`88@P8DY@8HaP80008]J`88@P848@8L
i`8@Q088@P@48@8HaP88@P8DY@8@Q08DY@8@Q0848@8000848@8DY@8@Q08<H`88@P80008@Q08<H`8@
Q0848@8<H`@@Q0848@88@P8@Q088@P848@03000<H`aS008DY@@48@H8@PH48@88@P8<H`848@88@P8<
H`848@8@Q08<H`8DY@88@P8DY@88@P8HaP8<H`8DY@80008<H`PDY@8@Q08<H`@8@P8@Q0@8@P8<H`84
8@8YBP@48@9240848@8DY@8Li`848@8DY@8U:@8@Q08YBP8@Q0@Li`8<H`8Q208aS08HaP8DY@8e[@8m
k`9kgPMoo`40005oo`005Goo00<007ooOol00Woo0TYB0Woo0Ukg0Sg_0TYB0RU:0P@Q0RDY0Q240R48
0QBU0PaS0QBU0RDY0Re[0PaS0RDY0Re[0PQ20S6<0PaS0P000PaS0Q240P@Q0Q2410Q211S60PaS0Q24
0PaS0PQ20QBU0QS60PQ20P@Q11S60Q240P000PaS0P@Q10aS0Q2410aS0P@Q0Q240PQ20P000Q240QS6
0PaS0PQ20P@Q11240P@Q0Q240`aS0P@Q0QcW10@Q0PaS10Q20Q2410@Q10aS0P@Q0PQ20PaS0QBU0QcW
0PaS0Q240PQ20Q240PaS0QcW0P000QBU0PQ20QcW0QS60Q2410aS0PQ20QcW0PQ20P000QBU0Q240PaS
0QBU0P0011S60Q240SW>0PaS0SW>0QS60PQ20QBU0RDY0PQ20Q240PaS0QBU0QS60QBU0R480QS60Q24
0R480T8@0SW>2Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82Ool2G_L2?Nl2BU82:DX212429BT2
48@28@P25:D236<25:D29BT2;F/236<29BT2;F/22482<H`236<2000236<248@2124248@424846<H2
36<248@236<224825:D26<H2248212446<H248@2000236<2124436<248@436<2124248@224820002
48@26<H236<22482124448@2124248@336<212427>L4124236<4248248@4124436<21242248236<2
5:D27>L236<248@2248248@236<27>L200025:D224827>L26<H248@436<224827>L2248200025:D2
48@236<25:D200046<H248@2>Lh236<2>Lh26<H224825:D29BT2248248@236<25:D26<H25:D28@P2
6<H248@28@P2@Q02>Lh9Ool10001Ool001Eoo`03001oogoo009oo`9Nm`Aoo`ANm`@<H`8Li`8DY@8@
Q08DY@8@Q08aS08DY@8YBP8<H`8Li`8@Q0@Li`8HaP8mk`8DY@8<H`@8@P848@8<H`@@Q0@8@P8@Q08H
aP848@8<H`P@Q08000@@Q080008DY@88@P8<H`8Li`80008<H`@@Q088@P848@88@P8<H`848@800084
8@8DY@H8@P035:D48@@Q008<H`8HaP800088@P8@Q0H8@P80008@Q0@<H`848@@8@P848@8@Q08<H`8@
Q08<H`848@8@Q08Li`8<H`H48@@<H`8@Q0@8@P8DY@8@Q08<H`8Li`8DY@@@Q08HaP88@P8DY@8<H`8U
:@8]J`8<H`8aS08YBP8aS08@Q08Li`8YBP8<H`8DY@@HaP8Q20@]J`8icP8e[@Uoo`40005oo`005Goo
0P000goo0Ukg17oo15kg10aS0QcW0QBU0Q240QBU0Q240S6<0QBU0RU:0PaS0QcW0Q2411cW0QS60Sg_
0QBU0PaS10Q20P@Q0PaS112410Q20Q240QS60P@Q0PaS21240P0011240P000QBU0PQ20PaS0QcW0P00
0PaS11240PQ20P@Q0PQ20PaS0P@Q0P000P@Q0QBU1PQ200<DY@@Q12400PaS0QS60P000PQ20Q241PQ2
0P000Q2410aS0P@Q10Q20P@Q0Q240PaS0Q240PaS0P@Q0Q240QcW0PaS1P@Q10aS0Q2410Q20QBU0Q24
0PaS0QcW0QBU11240QS60PQ20QBU0PaS0RDY0Re[0PaS0S6<0RU:0S6<0Q240QcW0RU:0PaS0QBU11S6
0R4812e[0SW>0SF]27oo0P000Goo000EOol00`00Oomoo`02Ool2HaP4Ool2Nmh2Mkd26<H2;F/26<H2
;F/27>L248@29BT2;F/236<28@P27>L2248236<2:DX248@224826<H236<248@236<212426<H22482
5:D212427>L2124200028@P20002248236<412426<H248@236<25:D236<2248248@40002248248@2
5:D200022482000224821242000236<22482124236<25:D2124324825:D2000812442482124236<2
124436<2248236<4248248@2248248@25:D2248212426<H2248248@212425:D2124248@29BT22482
:DX26<H200047>L22482:DX45:D2:DX248@2AS427>L2=Jd2:DX29BT2DY@2@Q022482<H`2;F/2:DX2
00027>L4<H`2=Jd4DY@9Ool10001Ool001Eoo`03001oogoo009oo`9S60Aoo`9kgP9g_@8HaP8]J`8H
aP8]J`8Li`8@Q08U:@8]J`8<H`8Q208Li`88@P8<H`8YBP8@Q088@P8HaP8<H`8@Q08<H`848@8HaP88
@P8DY@848@8Li`848@80008Q20800088@P8<H`@48@8HaP8@Q08<H`8DY@8<H`88@P8@Q0@00088@P8@
Q08DY@800088@P800088@P848@80008<H`88@P848@8<H`8DY@848@<8@P8DY@8000P48@@8@P848@8<
H`848@@<H`88@P8<H`@8@P8@Q088@P8@Q08DY@88@P848@8HaP88@P8@Q0848@8DY@848@8@Q08U:@88
@P8YBP8HaP8000@Li`88@P8YBP@DY@8YBP8@Q096<@8Li`8e[@8YBP8U:@9BU0924088@P8aS08]J`8Y
BP80008Li`@aS08e[@ABU0Uoo`40005oo`005Goo00<007ooOol00Woo0W_N17oo0UJe0V<H0Tic0QBU
0Sg_0QS60PaS0RDY0Q2412U:0Re[0QcW0RU:0QcW12480RDY0Q240R480PaS0Q240P000QS60P000QBU
0P@Q10Q20QBU0P@Q0PaS0Q2410Q210aS0P@Q0PaS0PQ210@Q0Q240P@Q0Q240PQ210@Q0QcW0P0010Q2
0P@Q1PQ20P000PQ20P@Q0PaS00<48A2448@010@Q0PQ20Q240PaS0P@Q10000PaS0P@Q0QBU0PQ20P00
0Q2410Q20QBU0P@Q1Q240P@Q0QcW10000QBU0P@Q0QS60PQ20Q2410aS0PQ20Q240PQ20QBU0RDY0Q24
0R480Q240RDY0Q2413W>0QS60S6<0RDY0R480Sg_0RDY0QS60Re[0Q240QcW11BU0Re[0RU:0QS60Sg_
0T8@0THa1goo0@000Goo000EOol00`00Oomoo`02Ool2Nmh4Ool2E[D2HaP2CW<25:D2?Nl26<H236<2
9BT248@4:DX2;F/27>L2:DX27>L48@P29BT248@28@P236<248@200026<H200025:D2124424825:D2
124236<248@4248436<2124236<22484124248@2124248@2248412427>L200042482124624820002
2482124236<00`@Q48@@Q0041242248248@236<21244000236<212425:D22482000248@424825:D2
124648@212427>L400025:D212426<H2248248@436<2248248@224825:D29BT248@28@P248@29BT2
48@4>Lh26<H2<H`29BT28@P2?Nl29BT26<H2;F/248@27>L45:D2;F/2:DX26<H2?Nl2@Q02AS47Ool1
0001Ool001Eoo`03001oogoo00Ioo`9BU08]J`9>L`8U:@8YBP8Q208DY@9:DP848@8@Q080008e[@8]
J`8DY@8@Q08aS088@P8icP8@Q08<H`8Li`8@Q0848@8HaP8<H`8HaP8<H`8HaP8000848@8DY@8HaP8<
H`88@P8@Q08DY@8<H`P8@P848@88@P8@Q0@8@P8DY@8@Q08<H`8@Q0@48@@<H`@8@P8@Q088@P848@8<
H`88@P036<H48@@Q008DY@80008Li`8@Q08HaP8@Q0P48@8@Q088@P8<H`88@P848@8<H`88@P@48@88
@P800088@P8<H`848@88@P8<H`8DY@@48@8@Q088@P8HaP8@Q0@HaP8@Q08<H`8HaP8U:@8<H`8Li`8Y
BP8icP8Li`8]J`8e[@848@8mk`8U:@8DY@8@Q08HaP8Li`8HaP8icP8aS0924080008@Q09F]@8U:@9F
]@Moo`40005oo`005Goo00<007ooOol01Woo0U:D0Re[0Tic0RDY0RU:0R480QBU0TYB0P@Q0Q240P00
0SF]0Re[0QBU0Q240S6<0PQ20SW>0Q240PaS0QcW0Q240P@Q0QS60PaS0QS60PaS0QS60P000P@Q0QBU
0QS60PaS0PQ20Q240QBU0PaS20Q20P@Q0PQ20Q2410Q20QBU0Q240PaS0Q2410@Q10aS10Q20Q240PQ2
0P@Q0PaS0PQ200<HaP@Q12400QBU0P000QcW0Q240QS60Q2420@Q0Q240PQ20PaS0PQ20P@Q0PaS0PQ2
10@Q0PQ20P000PQ20PaS0P@Q0PQ20PaS0QBU10@Q0Q240PQ20QS60Q2411S60Q240PaS0QS60RDY0PaS
0QcW0RU:0SW>0QcW0Re[0SF]0P@Q0Sg_0RDY0QBU0Q240QS60QcW0QS60SW>0S6<0T8@0P000Q240UJe
0RDY0UJe1goo0@000Goo000EOol00`00Oomoo`06Ool2IcT2AS42BU82<H`26<H236<29BT248@2:DX2
48@236<2:DX28@P236<2:DX26<H22482:DX28@P636<2248236<2248200021244248248@46<H2:DX2
24826<H4124236<424820002248236<22484124448@236<224845:D212425:D21242248236<21242
36<424800`@Q36<<H`027>L236<248@236<2000248@2124248@21244248236<448@236<248@41242
2482000212442482124236<26<H236<45:D248@27>L2124424827>L25:D224828@P25:D236<29BT2
?Nl26<H25:D2AS427>L2@Q02;F/29BT248@28@P2:DX2=Jd27>L2E[D2AS42;F/2:DX2;F/2<H`2AS49
Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eoo`03001oogoo00Ioo`9W>@96<@9:DP8a
S08HaP8<H`8U:@8@Q08YBP8@Q08<H`8YBP8Q208<H`8YBP8HaP88@P8YBP8Q20H<H`88@P8<H`88@P80
00848@@8@P8@Q0@HaP8YBP88@P8HaP@48@8<H`@8@P800088@P8<H`88@P@48@@@Q08<H`88@P@DY@84
8@8DY@848@88@P8<H`848@8<H`@8@P03124<H`aS008Li`8<H`8@Q08<H`80008@Q0848@8@Q0848@@8
@P8<H`@@Q08<H`8@Q0@48@88@P8000848@@8@P848@8<H`8HaP8<H`@DY@8@Q08Li`848@@8@P8Li`8D
Y@88@P8Q208DY@8<H`8U:@8mk`8HaP8DY@96<@8Li`92408]J`8U:@8@Q08Q208YBP8e[@8Li`9F]@96
<@8]J`8YBP8]J`8aS096<@Uoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool2F]H4Ool2>Lh2HaP26<H248@2=Jd2;F/29BT2:DX248@29BT2
:DX212429BT448@28@P236<48@P29BT224827>L224829BT212425:D27>L424825:D26<H424825:D2
36<21242248448@2248236<648@22482000248@200042482000424828@P224826<H236<200022482
12400`Q248@@Q002248436<2248236<4124236<25:D42482124248@2000236<248@45:D2000236<2
5:D248@236<25:D27>L25:D248@2000248@25:D212425:D2:DX29BT236<25:D26<H2248448@2;F/2
6<H29BT2>Lh2<H`2>Lh2<H`26<H2<H`2E[D236<2=Jd2>Lh2=Jd2E[D2BU8248@27>L28@P2?Nl2IcT9
Ool10001Ool000=oo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo
0U[F17oo0SW>0V<H0QS60Q240SF]0Re[0RDY0RU:0Q240RDY0RU:0P@Q0RDY11240R480PaS12480RDY
0PQ20QcW0PQ20RDY0P@Q0QBU0QcW10Q20QBU0QS610Q20QBU0PaS0P@Q0PQ211240PQ20PaS1Q240PQ2
0P000Q240P0010Q20P0010Q20R480PQ20QS60PaS0P000PQ20P@Q00<8@Q2448@00PQ210aS0PQ20PaS
10@Q0PaS0QBU10Q20P@Q0Q240P000PaS0Q2411BU0P000PaS0QBU0Q240PaS0QBU0QcW0QBU0Q240P00
0Q240QBU0P@Q0QBU0RU:0RDY0PaS0QBU0QS60PQ211240Re[0QS60RDY0SW>0S6<0SW>0S6<0QS60S6<
0UJe0PaS0SF]0SW>0SF]0UJe0TYB0Q240QcW0R480Sg_0VLi27oo0P000Goo0003Ool01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`8icPAoo`9Nm`9S608aS08<
H`9JeP8]J`8@Q08Li`8DY@8icP88@P@U:@8<H`8Li`92408U:@848@88@P8HaP88@P8U:@8@Q08DY@8<
H`@DY@8YBP8DY@@@Q08<H`8DY@88@P8Li`8@Q0848@88@P848@8Q208Li`8<H`8DY@8HaP88@P8DY@84
8@80008@Q08000@8@P848@88@P@<H`H48@80000336<8@PQ2008<H`8000848@88@P@48@8@Q0848@8<
H`@48@88@P@<H`8@Q08DY@848@8DY@8<H`8DY@8<H`8HaP8Q208@Q0848@8@Q08YBP8@Q08Li`8<H`8D
Y@80008Li`@DY@8<H`8aS08<H`8YBP8DY@8<H`8]J`8U:@9:DP8U:@9JeP9BU088@P9S609BU08Q208Y
BP96<@8e[@96<@8mk`8Li`8U:@92409F]@9cW0Uoo`40005oo`000goo00D007ooOomoo`00009oo`04
001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2>Lh4Ool2G_L2HaP2<H`236<2F]H2;F/2
48@27>L25:D2>Lh224849BT236<27>L2@Q029BT2124224826<H224829BT248@25:D236<45:D2:DX2
5:D448@236<25:D224827>L248@21242248212428@P27>L236<25:D26<H224825:D21242000248@2
000424821242248436<6124200000`aS2488@P0236<2000212422484124248@2124236<412422484
36<248@25:D212425:D236<25:D236<26<H28@P248@2124248@2:DX248@27>L236<25:D200027>L4
5:D236<2<H`236<2:DX25:D236<2;F/29BT2BU829BT2F]H2DY@22482HaP2DY@28@P2:DX2AS42=Jd2
AS42?Nl27>L29BT2@Q02E[D2Li`9Ool10001Ool0009oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo
00Qoo`9BU08]J`8<H`8YBP9BU0@<H`8mk`8]J`848@8]J`8icP8Q208YBP8icP8HaP8Q208@Q08YBP84
8@8HaP8@Q088@P8Q2080008<H`8DY@8Li`8@Q08HaP8@Q08Li`88@P848@8<H`848@8@Q0848@88@P8@
Q0848@8HaP8<H`@@Q08000848@8DY@8<H`88@P@@Q088@P8000@48@88@P8<H`8@Q0848@0336<LiacW
00@48@88@P8DY@8000@8@P848@8<H`88@P848@8<H`88@P8<H`848@8<H`8Li`H48@@<H`@@Q088@P80
00@<H`8DY@80008<H`8HaP8Q2088@P8<H`8@Q0848@8Li`8U:@8DY@8Li`8DY@8icP9W>@8U:@9oo`8]
J`8U:@9Nm`8U:@88@P8HaP848@8HaP8e[@9BU09>L`8HaP8<H`9oo`8YBP9kgPMoo`40005oo`005Goo
00<007ooOol027oo0U:D0Re[0PaS0RU:0U:D10aS0Sg_0Re[0P@Q0Re[0SW>0R480RU:0SW>0QS60R48
0Q240RU:0P@Q0QS60Q240PQ20R480P000PaS0QBU0QcW0Q240QS60Q240QcW0PQ20P@Q0PaS0P@Q0Q24
0P@Q0PQ20Q240P@Q0QS60PaS11240P000P@Q0QBU0PaS0PQ211240PQ20P0010@Q0PQ20PaS0Q240P@Q
00<<HacW7>L010@Q0PQ20QBU0P0010Q20P@Q0PaS0PQ20P@Q0PaS0PQ20PaS0P@Q0PaS0QcW1P@Q10aS
11240PQ20P0010aS0QBU0P000PaS0QS60R480PQ20PaS0Q240P@Q0QcW0RDY0QBU0QcW0QBU0SW>0VLi
0RDY0Woo0Re[0RDY0Ukg0RDY0PQ20QS60P@Q0QS60SF]0U:D0Tic0QS60PaS0Woo0RU:0W_N1goo0@00
0Goo000EOol00`00Oomoo`08Ool2E[D2@Q02<H`2@Q02<H`2@Q04:DX248@2;F/2:DX29BT224829BT2
36<28@P29BT25:D236<25:D2:DX67>L212428@P236<26<H25:D224825:D236<248@224825:D26<H4
48@236<22484000236<224825:D4124248@2248236<2000436<4124236<2000236<424800a2436<<
H`0236<25:D2248248@2124224826<H248@200025:D436<412422482124236<224848@P27>L22482
5:D2248248@236<2124236<2124248@2248200025:D236<2<H`236<25:D46<H29BT248@25:D2<H`2
@Q02Li`2Kg/22482DY@2;F/248@4@Q029BT25:D2G_L2Ool2JeX47>L2Li`26<H2Mkd7Ool10001Ool0
01Eoo`03001oogoo00Qoo`9F]@92408aS092408aS09240@YBP8@Q08]J`8YBP8U:@88@P8U:@8<H`8Q
208U:@8DY@8<H`8DY@8YBPHLi`848@8Q208<H`8HaP8DY@88@P8DY@8<H`8@Q088@P8DY@8HaP@@Q08<
H`88@P@0008<H`88@P8DY@@48@8@Q088@P8<H`8000@<H`@48@8<H`80008<H`@8@P0348@<H`aS008<
H`8DY@88@P8@Q0848@88@P8HaP8@Q080008DY@@<H`@48@88@P848@8<H`88@P@Q208Li`88@P8DY@88
@P8@Q08<H`848@8<H`848@8@Q088@P80008DY@8<H`8aS08<H`8DY@@HaP8U:@8@Q08DY@8aS092409c
W09_N`88@P9BU08]J`8@Q0A2408U:@8DY@9Nm`9oo`9[FP@Li`9cW08HaP9g_@Moo`40005oo`005Goo
00<007ooOol01Woo0THa0QBU0Tic0RU:0SW>0T8@0TYB12480RDY0Re[0QcW0Q240T8@0RDY0Q240R48
0PQ20RDY12480P@Q0Q240PaS0QBU0P@Q0QcW0QBU1Q240RU:0Q240P@Q0PQ20QBU0PQ20QBU0PQ20P@Q
0P000QBU0P000Q240P000Q240P000QcW1PQ20Q240P@Q0QcW0P@Q0Q240P000PQ20QS60P@Q0PQ200<D
Y@@Q12400PQ20PaS0P001PaS0QBU0PaS0Q240QcW0PaS0PQ20PaS0Q240QS60Q240PaS0PQ20PaS10Q2
0R4811240QBU0P@Q0PaS0QBU0QcW10Q2100011240QBU0S6<0Q2412480PaS0PQ20T8@0QS60VLi0TYB
0THa0V]J0RDY0V<H0T8@0RU:0U[F0RU:0Vmk0Woo13F]0QS60UJe0VLi2Goo0@000Goo000EOol00`00
Oomoo`06Ool2AS425:D2CW<2:DX2>Lh2@Q02BU848@P29BT2;F/27>L248@2@Q029BT248@28@P22482
9BT48@P2124248@236<25:D212427>L25:D648@2:DX248@2124224825:D224825:D2248212420002
5:D2000248@2000248@200027>L6248248@212427>L2124248@2000224826<H2124224800aBU1244
8@02248236<2000636<25:D236<248@27>L236<2248236<248@26<H248@236<2248236<424828@P4
48@25:D2124236<25:D27>L42484000448@25:D2<H`248@48@P236<22482@Q026<H2IcT2BU82AS42
JeX29BT2HaP2@Q02:DX2F]H2:DX2Kg/2Ool4=Jd26<H2E[D2IcT9Ool10001Ool001Eoo`03001oogoo
009oo`9BU09oo`9[FP8YBP9oo`8U:@9>L`9[FP9BU088@P8HaP8]J`8e[@8<H`8Li`8mk`848@8HaP96
<@80008aS08@Q0@Q208U:@@HaP8DY@8HaP8]J`8Li`8@Q08YBP848@8<H`8YBP8@Q08<H`8DY@848@8H
aP8<H`88@P8@Q088@P8@Q0848@@@Q08HaP@DY@8<H`88@P8<H`8HaP848@80008@Q08HaPH<H`<@Q088
@P8HaP88@P8@Q0848@@8@P@48@8<H`@8@PP<H`8@Q08Li`8DY@P<H`88@P8@Q0848@8DY@848@@8@P8H
aP8Q208@Q08<H`8Li`8Q208HaP848@8@Q08DY@8Q208@Q08Q208DY@9cW08aS09oo`9JeP96<@9oo`8]
J`9F]@8aS09W>@9_N`9[FP8@Q080008DY@8Q20]oo`40005oo`005Goo0P000goo0U:D0Woo0V]J0RU:
0Woo0RDY0Tic0V]J0U:D0PQ20QS60Re[0SF]0PaS0QcW0Sg_0P@Q0QS60THa0P000S6<0Q2412480RDY
11S60QBU0QS60Re[0QcW0Q240RU:0P@Q0PaS0RU:0Q240PaS0QBU0P@Q0QS60PaS0PQ20Q240PQ20Q24
0P@Q11240QS611BU0PaS0PQ20PaS0QS60P@Q0P000Q240QS61PaS0a240PQ20QS60PQ20Q240P@Q10Q2
10@Q0PaS10Q220aS0Q240QcW0QBU20aS0PQ20Q240P@Q0QBU0P@Q10Q20QS60R480Q240PaS0QcW0R48
0QS60P@Q0Q240QBU0R480Q240R480QBU0W>L0S6<0Woo0U[F0THa0Woo0Re[0UJe0S6<0VLi0Vmk0V]J
0Q240P000QBU0R482Woo0P000Goo000EOol00`00Oomoo`02Ool2>Lh4Ool2HaP2Ool25:D2AS42Ool2
@Q02;F/2>Lh2AS42;F/2<H`29BT2;F/26<H2:DX28@P636<27>L212428@P2BU826<H224826<H2>Lh2
48@2248248@4124224826<H25:D26<H27>L25:D26<H436<2124248@27>L224825:D236<212425:D2
48@25:D436<224825:D4124236<424800`@Q48@@Q0027>L2248248@212425:D2000412425:D248@2
6<H27>L424825:D212425:D236<28@P25:D26<H236<2248236<27>L22482:DX27>L248@212428@P2
6<H25:D436<25:D29BT25:D26<H29BT248@25:D2>Lh2;F/2G_L2<H`2Ool2CW<4JeX2:DX2AS4248@2
<H`2?Nl2F]H2@Q02F]H28@P2Mkd;Ool10001Ool001Eoo`03001oogoo009oo`8icPAoo`9S609oo`8D
Y@96<@9oo`92408]J`8icP96<@8]J`8aS08U:@8]J`8HaP8YBP8Q20H<H`8Li`848@8Q209:DP8HaP88
@P8HaP8icP8@Q088@P8@Q0@48@88@P8HaP8DY@8HaP8Li`8DY@8HaP@<H`848@8@Q08Li`88@P8DY@8<
H`848@8DY@8@Q08DY@@<H`88@P8DY@@48@8<H`@8@P03124@Q124008Li`88@P8@Q0848@8DY@8000@4
8@8DY@8@Q08HaP8Li`@8@P8DY@848@8DY@8<H`8Q208DY@8HaP8<H`88@P8<H`8Li`88@P8YBP8Li`8@
Q0848@8Q208HaP8DY@@<H`8DY@8U:@8DY@8HaP8U:@8@Q08DY@8icP8]J`9Nm`8aS09oo`9>L`A[FP8Y
BP96<@8@Q08aS08mk`9JeP92409JeP8Q209g_@]oo`40005oo`005Goo00<007ooOol02Woo14ic0V]J
0Tic0Re[0QcW0T8@0R480QcW0QS60R480Re[0SF]0QcW0P@Q0Re[0P000RDY10Q21S6<0Re[0R480P@Q
0PQ20QS60Q240QBU0PaS0QcW0P000QBU0PQ20Q240QcW0PaS0QBU0Q240PQ20Q240PQ21Q240R4810aS
0P000P@Q0PQ20QBU0PaS0QBU0Q240QS60P000P@Q00<@Q1BU5:D00PaS0PQ20P@Q0PQ20Q240PaS0P@Q
10aS0Q240PaS10@Q0P000P@Q0QBU0Q240PQ20PaS0Q241PQ20QBU1P@Q10aS0QS60PaS0QBU0Q240R48
0QBU0PaS0RDY0PQ20PaS0P@Q0QBU0Q240Sg_12e[0V<H0Woo0S6<0Woo15kg0SF]0QBU0Q240U:D17oo
0Tic0UJe0Woo0U[F0V]J1goo0@000Goo000EOol00`00Oomoo`0:Ool4CW<2JeX2CW<2;F/27>L2@Q02
8@P27>L26<H28@P2;F/2=Jd27>L21242;F/200029BT42486<H`2;F/28@P2124224826<H248@25:D2
36<27>L200025:D2248248@27>L236<25:D248@2248248@2248648@28@P436<20002124224825:D2
36<25:D248@26<H2000212400a245:DDY@0236<224821242248248@236<2124436<248@236<41242
000212425:D248@2248236<248@624825:D6124436<26<H236<25:D248@28@P25:D236<29BT22482
36<212425:D248@2?Nl4;F/2HaP2Ool2<H`2Ool4G_L2=Jd25:D248@2DY@4Ool2CW<2E[D2Ool2F]H2
JeX7Ool10001Ool001Eoo`03001oogoo00Yoo`8e[@9kgP9JeP8]J`8icP9>L`8]J`8<H`848@9>L`8Q
208U:@8HaP8U:@8DY@8Li`8U:@9>L`8U:@8DY@92408]J`8@Q08Li`8icP88@P8@Q08DY@8U:@@DY@84
8@8@Q08Li`88@P848@@<H`8DY@80008@Q08Q2088@P8@Q088@P8HaP8Li`848@8<H`H8@P8<H`8DY@88
@P848@8<H`@8@P03124@Q124008DY@80008<H`@DY@88@P848@8@Q0H<H`H8@P8@Q08DY@@@Q0848@88
@P848@88@P8YBPH@Q0848@8@Q0848@8@Q0HDY@80008<H`8DY@@Li`8@Q08aS08HaP8U:@@icP8e[@9F
]@9g_@9S609oo`92409oo`9S609>L`9F]@Aoo`9S608]J`9cW09oo`9S609Nm`Moo`40005oo`005Goo
00<007ooOol02Woo0SF]0W_N0U[F0Re[0SW>0Tic0Re[0PaS0P@Q0Tic0R480RDY0QS60RDY0QBU0QcW
0RDY0Tic0RDY0QBU0T8@0Re[0Q240QcW0SW>0PQ20Q240QBU0RDY11BU0P@Q0Q240QcW0PQ20P@Q10aS
0QBU0P000Q240R480PQ20Q240PQ20QS60QcW0P@Q0PaS1PQ20PaS0QBU0PQ20P@Q0PaS10Q200<48A24
48@00QBU0P000PaS11BU0PQ20P@Q0Q241PaS1PQ20Q240QBU11240P@Q0PQ20P@Q0PQ20RU:1Q240P@Q
0Q240P@Q0Q241QBU0P000PaS0QBU11cW0Q240S6<0QS60RDY13W>0SF]0UJe0WNm0V<H0Woo0T8@0Woo
0V<H0Tic0UJe17oo0V<H0Re[0W>L0Woo0V<H0Ukg1goo0@000Goo000EOol00`00Oomoo`08Ool2HaP2
Ool2Nmh2Ool28@P2Nmh2?Nl25:D248@26<H2=Jd2:DX2@Q028@P2;F/2BU829BT2;F/2?Nl29BT2@Q02
6<H28@P25:D2;F/28@P2:DX25:D28@P2124248@27>L28@P248@25:D224827>L200026<H2248248@2
12427>L424829BT212426<H848@224827>L236<200028@P25:D2000248@00`aS2488@P02248248@2
36<21246248236<26<H2248248@27>L236<248@2248248@21246248236<45:D236<248@25:D22482
36<29BT25:D212429BT248@236<25:D236<46<H2;F/42482<H`29BT2?Nl28@P2Mkd26<H2Ool2E[D4
Ool2Li`2G_L4Ool2HaP2CW<248@2>Lh28@P;Ool10001Ool001Eoo`03001oogoo00Qoo`9S609oo`9k
gP9oo`8Q209kgP8mk`8DY@8@Q08HaP8e[@8YBP92408Q208]J`9:DP8U:@8]J`8mk`8U:@92408HaP8Q
208DY@8]J`8Q208YBP8DY@8Q20848@8@Q08Li`8Q208@Q08DY@88@P8Li`80008HaP88@P8@Q0848@8L
i`@8@P8U:@848@8HaPP@Q088@P8Li`8<H`80008Q208DY@80008@Q00336<8@PQ20088@P8@Q08<H`84
8@H8@P8<H`8HaP88@P8@Q08Li`8<H`8@Q088@P8@Q0848@H8@P8<H`@DY@8<H`8@Q08DY@88@P8<H`8U
:@8DY@848@8U:@8@Q08<H`8DY@8<H`@HaP8]J`@8@P8aS08U:@8mk`8Q209g_@8HaP9oo`9F]@Aoo`9c
W09Nm`Aoo`9S609>L`8@Q08icP8Q20]oo`40005oo`005Goo00<007ooOol01Woo0V]J0QS617oo0RU:
0Woo0V]J0R480PaS0P000Re[0SF]0RU:0Sg_0SF]0THa0PQ20Q240SW>0R480TYB0THa0P@Q0Re[0S6<
0PaS0QBU0Re[0R480SW>0QS60Q240QBU0Q240QBU0PaS0Q240PaS0Q240R480QS60P@Q0PaS0Q240PQ2
0QcW0PaS0Q240QS60PQ20QcW10aS0P0010Q20R4810Q211S600<000@Q12400QS60Q240P@Q10aS0QS6
0Q2410@Q0PQ20QBU0PaS0P000QBU0Q240PQ20Q240QS60QBU0PaS0P@Q0PaS0PQ212480QBU0RDY0PQ2
0R480PaS0QBU0S6<0QS60QBU0Q240QBU0PQ20QBU0SF]0THa0Q240RU:13F]0U:D0T8@0QS60Woo0SF]
17oo0TYB0WNm0Tic0Sg_0TYB0RDY0RU:0Sg_3Goo0@000Goo000EOol20007Ool2JeX26<H4Ool2:DX2
Ool2JeX28@P236<20002;F/2=Jd2:DX2?Nl2=Jd2AS42248248@2>Lh28@P2BU82AS421242;F/2<H`2
36<25:D2;F/28@P2>Lh26<H248@25:D248@25:D236<248@236<248@28@P26<H2124236<248@22482
7>L236<248@26<H224827>L436<2000424828@P424846<H00`0012448@026<H248@2124436<26<H2
48@4124224825:D236<200025:D248@2248248@26<H25:D236<2124236<224848@P25:D29BT22482
8@P236<25:D2<H`26<H25:D248@25:D224825:D2=Jd2AS4248@2:DX4=Jd2DY@2@Q026<H2Ool2=Jd4
Ool2BU82Mkd2CW<2?Nl2BU829BT2:DX2?Nl<Ool20001Ool001Eoo`03001oogoo009oo`9S60Aoo`9>
L`9oo`96<@9F]@9oo`8Q20848@9>L`8U:@8Q208YBP8U:@9JeP9Nm`8mk`8Q209F]@9:DP8HaP8U:@8D
Y@8U:@8HaP@@Q0@00088@P8Li`88@P8Q208HaP8@Q08Li`88@P80008@Q08HaP8DY@@@Q080008<H`@@
Q08Li`@<H`8HaP8@Q088@P8DY@848@8@Q0@DY@8@Q08Li`D8@P8Q2080008<H`@@Q080008@Q088@P8@
Q0@<H`88@P8<H`800088@P8Li`8DY@8@Q08Li`8DY@8Q208@Q08HaP88@P8Q2080008@Q08<H`8DY@8U
:@8<H`HQ208icP8@Q08DY@8HaP8@Q08U:@8Li`8]J`8Q208e[@9S608DY@9[FP8<H`9oo`9Nm`9oo`9B
U09g_@9cW09S609JeP9_N`9oo`9_N`9>L`eoo`40005oo`005Goo00<007ooOol00Woo0V<H17oo0Tic
0Woo0THa0UJe0Woo0R480P@Q0Tic0RDY0R480RU:0RDY0U[F0Ukg0Sg_0R480UJe0TYB0QS60RDY0QBU
0RDY0QS6112410000PQ20QcW0PQ20R480QS60Q240QcW0PQ20P000Q240QS60QBU11240P000PaS1124
0QcW10aS0QS60Q240PQ20QBU0P@Q0Q2411BU0Q240QcW1@Q20R480P000PaS11240P000Q240PQ20Q24
10aS0PQ20PaS0P000PQ20QcW0QBU0Q240QcW0QBU0R480Q240QS60PQ20R480P000Q240PaS0QBU0RDY
0PaS1R480SW>0Q240QBU0QS60Q240RDY0QcW0Re[0R480SF]0V<H0QBU0V]J0PaS0Woo0Ukg0Woo0U:D
0WNm0W>L0V<H0U[F0Vmk0Woo0Vmk0Tic3Goo0@000Goo000EOol00`00Oomoo`0<Ool2DY@2HaP2CW<2
6<H2?Nl2=Jd2?Nl2;F/2>Lh29BT2<H`2=Jd2;F/27>L2:DX27>L2IcT2:DX28@P2248248@2<H`248@2
6<H27>L26<H2124236<248@27>L29BT236<248@836<412425:D236<26<H2124236<2000236<22482
5:D248@26<H236<2248436<27>L248@424800acW48@@Q002124200025:D248@25:D20002248236<2
248236<46<H2124248@22484124248@27>L236<25:D2124236<25:D2248212427>L424845:D26<H2
36<2>Lh2;F/25:D236<27>L28@P22482<H`27>L2AS44=Jd2>Lh2CW<2E[D2=Jd2Ool2HaP2Ool2Li`2
Nmh4Ool2Kg/2Nmh4Ool2<H`2IcT7Ool10001Ool001Eoo`03001oogoo00aoo`9BU09S609>L`8HaP8m
k`8e[@8mk`8]J`8icP8U:@8aS08e[@8]J`8Li`8YBP8Li`9W>@8YBP8Q2088@P8@Q08aS08@Q08HaP8L
i`8HaP848@8<H`8@Q08Li`8U:@8<H`8@Q0P<H`@48@8DY@8<H`8HaP848@8<H`80008<H`88@P8DY@8@
Q08HaP8<H`88@P@<H`8Li`8@Q0@8@P037>L@Q12400848@80008DY@8@Q08DY@800088@P8<H`88@P8<
H`@HaP848@8@Q088@P@48@8@Q08Li`8<H`8DY@848@8<H`8DY@88@P848@8Li`@8@P@DY@8HaP8<H`8i
cP8]J`8DY@8<H`8Li`8Q2088@P8aS08Li`96<@@e[@8icP9>L`9F]@8e[@9oo`9S609oo`9cW09kgPAo
o`9_N`9kgPAoo`8aS09W>@Moo`40005oo`005Goo00<007ooOol02Woo0PQ217oo0V<H0U:D0TYB0QS6
0Sg_0TYB0QS60RDY0U[F0RU:0QS60Vmk0QBU0Re[0RU:0PaS0RDY0R480PQ20P@Q11BU0Q240R480Re[
0QS60Q240QcW0P000QBU0Q2411cW0P@Q0PQ211240P000PaS0QS60PaS0QS60RDY0QcW0RDY10Q20QS6
0PQ20QS610Q20Q240PQ20P000PQ21A240PQ20QcW0P@Q0Q240PQ20Q240QBU0Q2410Q20QcW0PQ210@Q
10Q20R480PaS0Q240PaS11240PQ20P000QS60PaS0Q240PaS0QS60PaS0QcW0Re[0RDY0R480SF]0PaS
0RDY0R480PQ20R480Ukg0Re[0T8@0U[F0Woo0U[F0U:D0V<H0Vmk37oo0Ukg17oo0W>L2goo0@000Goo
000EOol00`00Oomoo`0:Ool22484Ool2HaP2DY@2BU826<H2?Nl2BU826<H29BT2F]H2:DX26<H2Kg/2
5:D2;F/2:DX236<29BT28@P2248212445:D248@28@P2;F/26<H248@27>L200025:D248@47>L21242
248448@2000236<26<H236<26<H29BT27>L29BT424826<H224826<H4248248@224820002248548@2
24827>L2124248@2248248@25:D248@424827>L22484124424828@P236<248@236<448@224820002
6<H236<248@236<26<H236<27>L2;F/29BT28@P2=Jd236<29BT28@P224828@P2G_L2;F/2@Q02F]H2
Ool2F]H2DY@2HaP2Kg/<Ool2G_L4Ool2Li`;Ool10001Ool001Eoo`03001oogoo00Yoo`9JePAoo`8e
[@9W>@9>L`8Q208icP9BU09Nm`8DY@9JeP8mk`9Nm`8@Q08icP92408aS088@P8HaP8<H`8Li`8DY@88
@P8e[@8@Q08HaP8U:@8<H`8Q20@Li`H<H`8Q208HaPH<H`8Q2088@P8U:@8YBP88@P848@8DY@848@8D
Y@8HaP8Li`8DY@8<H`88@P8Li`8DY@8@Q08<H`<HaP8<H`8DY@@8@P8<H`8DY@8Li`8@Q080008YBP8D
Y@848@8DY@8HaP848@@@Q0@DY@80008@Q088@P848@8YBP8@Q08DY@8U:@8Q208<H`8@Q08HaP8Li`@Q
208mk`8<H`8e[@8Q208HaP8e[@9>L`8YBP9:DP8e[@9BU08Li`Qoo`9kgPYoo`9:DP8U:@9[FP92409g
_@]oo`40005oo`005Goo00<007ooOol02Woo0U[F17oo0SF]0VLi0Tic0R480SW>0U:D0Ukg0QBU0U[F
0Sg_0Ukg0Q240SW>0T8@0S6<0PQ20QS60PaS0QcW0QBU0PQ20SF]0Q240QS60RDY0PaS0R4811cW1PaS
0R480QS61PaS0R480PQ20RDY0RU:0PQ20P@Q0QBU0P@Q0QBU0QS60QcW0QBU0PaS0PQ20QcW0QBU0Q24
0PaS0aS60PaS0QBU10Q20PaS0QBU0QcW0Q240P000RU:0QBU0P@Q0QBU0QS60P@Q112411BU0P000Q24
0PQ20P@Q0RU:0Q240QBU0RDY0R480PaS0Q240QS60QcW12480Sg_0PaS0SF]0R480QS60SF]0Tic0RU:
0TYB0SF]0U:D0QcW27oo0W_N2Woo0TYB0RDY0V]J0T8@0WNm2goo0@000Goo000EOol00`00Oomoo`06
Ool2Mkd25:D2Ool2DY@2>Lh2Ool2=Jd28@P2F]H2:DX2BU82HaP2IcT22484E[D2<H`28@P2BU822482
48@28@P2:DX2=Jd2E[D2;F/26<H2:DX212428@P26<H224825:D248@28@P45:D224825:D26<H436<4
124248@27>L248@25:D236<25:D248@6124448@2248248@436<248@00aBU48@@Q002248248@236<2
48@28@P2248236<26<H2124224825:D27>L212426<H448@26<H236<2000248@212425:D248@28@P2
5:D448@2;F/26<H236<25:D212442482;F/2<H`236<2@Q029BT2E[D27>L25:D2BU82Ool2CW<2Mkd6
Ool2<H`:Ool2?Nl2Ool2G_L?Ool10001Ool001Eoo`8000Moo`9g_@8DY@9oo`9BU08icP9oo`8e[@8Q
209JeP8YBP9:DP9S609W>@88@PAF]@8aS08Q209:DP88@P8@Q08Q208YBP8e[@9F]@8]J`8HaP8YBP84
8@8Q208HaP88@P8DY@8@Q08Q20@DY@88@P8DY@8HaP@<H`@48@8@Q08Li`8@Q08DY@8<H`8DY@8@Q0H4
8@@@Q088@P8@Q0@<H`8@Q0035:D@Q1240088@P8@Q08<H`8@Q08Q2088@P8<H`8HaP848@88@P8DY@8L
i`848@8HaP@@Q08HaP8<H`80008@Q0848@8DY@8@Q08Q208DY@@@Q08]J`8HaP8<H`8DY@848@@8@P8]
J`8aS08<H`92408U:@9F]@8Li`8DY@9:DP9oo`9>L`9g_@Ioo`8aS0Yoo`8mk`9oo`9Nm`ioo`80005o
o`005Goo00<007ooOol037oo0Re[0WNm0U[F0VLi0TYB0THa0Tic0Sg_0TYB0W_N0W>L0SW>0U:D0SF]
0PaS0RDY0THa0RDY0QcW0Re[0TYB0THa0R480PQ20QBU0PaS0Re[0QcW0PaS0QBU0QS60PaS0QBU0Q24
0RDY0QcW0PaS1PQ211S60Q240P@Q0QS60Q240PQ210aS0QS60Re[0PQ20QS610Q20P@Q11BU00<48@aS
36<00QS60PaS0QBU0PaS0QBU0QS60P@Q0PQ20Q240P000PaS0Q240QS60PaS10Q20PaS0PQ20PaS0P@Q
0QS60QBU0P@Q0QBU0PaS0P@Q0QcW0PaS0RDY10@Q0Q240P000RU:0SF]0QcW0R480QBU0Ukg0RU:0Sg_
0UJe0T8@0WNm0U:D27oo0U:D3Woo0TYB3goo0@000Goo000EOol00`00Oomoo`0<Ool2;F/2Mkd2F]H2
IcT2BU82AS42CW<2?Nl2BU82Nmh2Li`2>Lh2DY@2=Jd236<29BT2AS429BT27>L2;F/2BU82AS428@P2
24825:D236<2;F/27>L236<25:D26<H236<25:D248@29BT27>L236<624846<H248@212426<H248@2
248436<26<H2;F/224826<H4248212445:D00`@Q36<<H`026<H236<25:D236<25:D26<H212422482
48@2000236<248@26<H236<4248236<2248236<212426<H25:D212425:D236<212427>L236<29BT4
124248@20002:DX2=Jd27>L28@P25:D2G_L2:DX2?Nl2E[D2@Q02Mkd2DY@8Ool2DY@>Ool2BU8?Ool1
0001Ool001Eoo`03001oogoo00ioo`9cW09oo`9F]@9g_@8]J`9:DP9oo`9240ANm`8mk`8Li`9Nm`8U
:@8YBP8@Q08]J`9JeP9>L`92408Q208icP9F]@8]J`8Li`8HaP88@P8U:@8HaP8YBP88@P8DY@@@Q08H
aP8Q208<H`8HaP88@P8HaP8<H`8Li`8<H`@Li`H@Q08Li`88@P8@Q08HaP8@Q08DY@@48@8<H`036<H4
8@@Q008HaP8<H`@@Q0@DY@8<H`848@8Li`8HaP88@P8HaP848@8@Q0@DY@8HaP@@Q088@P@<H`8U:@84
8@88@P8Li`@YBP8@Q088@P8]J`8U:@8Q20@YBP9>L`8Q208e[@8U:@8@Q092409cW09F]@8mk`88@PAo
o`9cW09oo`9S609oo`9BU11oo`8@Q08mk`Moo`40005oo`005Goo00<007ooOol03Woo0W>L0Woo0UJe
0WNm0Re[0TYB0Woo0T8@15kg0Sg_0QcW0Ukg0RDY0RU:0Q240Re[0U[F0Tic0T8@0R480SW>0UJe0Re[
0QcW0QS60PQ20RDY0QS60RU:0PQ20QBU11240QS60R480PaS0QS60PQ20QS60PaS0QcW0PaS11cW1Q24
0QcW0PQ20Q240QS60Q240QBU10@Q0PaS00<HaP@Q12400QS60PaS112411BU0PaS0P@Q0QcW0QS60PQ2
0QS60P@Q0Q2411BU0QS611240PQ210aS0RDY0P@Q0PQ20QcW12U:0Q240PQ20Re[0RDY0R4812U:0Tic
0R480SF]0RDY0Q240T8@0W>L0UJe0Sg_0PQ217oo0W>L0Woo0V<H0Woo0U:D47oo0Q240Sg_1goo0@00
0Goo000EOol00`00Oomoo`0@Ool22482Kg/2IcT2?Nl2Kg/2Ool2Li`2IcT2JeX29BT2@Q02>Lh29BT2
JeX4Ool2E[D46<H25:D2;F/25:D236<29BT248@2:DX45:D236<28@P26<H236<28@P448@236<22484
36<200025:D236<28@P25:D28@P46<H25:D448@200022482124224826<H28@P336<22482:DX236<2
248236<27>L236<248@25:D248@26<H236<2124236<248@26<H25:D2248248@29BT248@27>L29BT2
5:D236<26<H448@26<H2?Nl25:D212426<H28@P25:D2AS42E[D2JeX29BT2?Nl2Ool2;F/29BT2@Q02
?NlLOol2124;Ool10001Ool001Eoo`03001oogoo011oo`88@P9_N`9W>@8mk`9_N`9oo`9cW09W>@9[
FP8U:@92408icP8U:@9[FPAoo`9F]@@HaP8DY@8]J`8DY@8<H`8U:@8@Q08YBP@DY@8<H`8Q208HaP8<
H`8Q20@@Q08<H`88@P@<H`80008DY@8<H`8Q208DY@8Q20@HaP8DY@@@Q0800088@P848@88@P8HaP8Q
20<<H`88@P8YBP8<H`88@P8<H`8Li`8<H`8@Q08DY@8@Q08HaP8<H`848@8<H`8@Q08HaP8DY@88@P8@
Q08U:@8@Q08Li`8U:@8DY@8<H`8HaP@@Q08HaP8mk`8DY@848@8HaP8Q208DY@96<@9F]@9[FP8U:@8m
k`9oo`8]J`8U:@92408mkaaoo`848@]oo`40005oo`005Goo00<007ooOol047oo0Sg_0T8@0W_N0Woo
0U:D0Tic17oo0SF]0U[F0U:D0T8@0Ukg0U[F0TYB0Q240Tic0SW>0S6<0V<H0PaS12480Re[0Tic0QBU
0R480PaS0R480Re[0P000PQ211BU0R480PaS0P@Q0RDY1Q240RU:0P@Q0PQ20PaS0RDY10aS0QBU0P@Q
1PQ20QS60Q240PaS00<@Q1BU5:D00PaS0P@Q0PQ210aS0QBU0PaS0Re[0Q240QBU0PaS11BU0PQ20QcW
0PQ20PaS0P000PaS0P000PQ20PaS0Q240RDY0PQ20RDY0PQ20QcW0P000P@Q0QBU0QS60SF]0U[F0PaS
0U[F0U:D0S6<0Tic0U:D0QS60T8@0W>L0WNm17oo0S6<17oo0V<H0Woo0Re[6goo0@000Goo00000goo
0000000300000goo000000020003Ool20005Ool00`00Oomoo`0@Ool2?Nl2@Q02Nmh2Ool2DY@2CW<4
Ool2=Jd2F]H2DY@2@Q02G_L2F]H2BU8248@2CW<2>Lh2<H`2HaP236<48@P2;F/2CW<25:D28@P236<2
8@P2;F/2000224845:D28@P236<212429BT648@2:DX21242248236<29BT436<25:D2124624826<H2
48@236<00a245:DDY@0236<21242248436<25:D236<2;F/248@25:D236<45:D224827>L2248236<2
000236<20002248236<248@29BT224829BT224827>L2000212425:D26<H2=Jd2F]H236<2F]H2DY@2
<H`2CW<2DY@26<H2@Q02Li`2Mkd4Ool2<H`4Ool2HaP2Ool2;F/KOol10001Ool000=oo`05001oogoo
Ool00005Ool01000Oomoo`0017oo00<007ooOol027oo0SW>0Woo0RDY17oo0Ukg0U:D0WNm17oo0Re[
0TYB0Woo0TYB0WNm0VLi0UJe0Woo0T8@0V<H15[F0Re[0SW>0RDY0PQ20RU:0Q240Re[0PaS11S60R48
0RU:0PQ20PaS0PQ20PaS0QcW0Q240QS60RU:1QBU0QcW0P000P@Q0Q240QBU0Q2410@Q1QS60QBU0PaS
0QBU0Q2400<HaPQ224800Q240QBU0QS60PaS11S60P00112410aS0P000QS60P@Q0QBU0QS610aS10Q2
0PaS0QBU0Q240Re[0QcW0PaS0Q240QBU10Q20QS60QcW0T8@0SF]0RDY13W>0U[F0Woo0Sg_0SF]17oo
0U[F17oo0Sg_27oo0QBU6goo0@000Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomo
o`0017oo0P002Goo0SW>0Woo0RDY17oo0Ukg0U:D0WNm17oo0Re[0TYB0Woo0TYB0WNm0VLi0UJe0Woo
0T8@0V<H15[F0Re[0SW>0RDY0PQ20RU:0Q240Re[0PaS11S60R480RU:0PQ20PaS0PQ20PaS0QcW0Q24
0QS60RU:1QBU0QcW0P000P@Q0Q240QBU0Q2410@Q1QS60QBU0PaS0QBU0Q2400<HaPQ224800Q240QBU
0QS60PaS11S60P00112410aS0P000QS60P@Q0QBU0QS610aS10Q20PaS0QBU0Q240Re[0QcW0PaS0Q24
0QBU10Q20QS60QcW0T8@0SF]0RDY13W>0U[F0Woo0Sg_0SF]17oo0U[F17oo0Sg_27oo0QBU6Woo0P00
0Goo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol03Woo
0W>L0Woo0Ukg0Woo0S6<17oo0U:D27oo0T8@0S6<15Je0VLi0V]J0U[F0VLi0SW>0QBU0RU:11cW0Q24
0QS60Re[0QBU0QS60QBU0Q2412DY0QcW0P@Q0QBU10aS0QcW0QBU0QcW0Q240PQ20P000PQ20RDY11S6
0QBU0P@Q0QS60PQ20QBU11240bDY0P0011BU1PaS0Q2411S60PQ20QBU0QS60PQ211BU0PaS0P@Q0QS6
0R480PaS0Q240P@Q0P000Re[0QBU0PaS0R480QBU11cW0R480S6<0PaS0S6<0R480S6<0V]J0Woo0V<H
0TYB0RU:0TYB0Woo0Re[0Woo0V]J0Re[17oo0S6<8Goo0@000Goo0003Ool01@00Oomoogoo00000Woo
00@007ooOol0009oo`03001oogoo009oo`03001oogoo00ioo`9cW09oo`9Nm`9oo`8aS0Aoo`9BU0Qo
o`92408aS0AF]@9W>@9[FP9JeP9W>@8icP8DY@8YBP@Li`8@Q08HaP8]J`8DY@8HaP8DY@8@Q0@U:@8L
i`848@8DY@@<H`8Li`8DY@8Li`8@Q088@P800088@P8U:@@HaP8DY@848@8HaP88@P8DY@@@Q0<U:@80
00@DY@H<H`8@Q0@HaP88@P8DY@8HaP88@P@DY@8<H`848@8HaP8Q208<H`8@Q0848@80008]J`8DY@8<
H`8Q208DY@@Li`8Q208aS08<H`8aS08Q208aS09[FP9oo`9S609:DP8YBP9:DP9oo`8]J`9oo`9[FP8]
J`Aoo`8aS25oo`40005oo`000Woo0P0017oo0P0017oo0P001Goo00<007ooOol05Woo0V]J27oo0W>L
0Ukg0Woo0Tic0Vmk0TYB0Q240WNm0QS60QBU0R480Re[0RU:0S6<0QcW0RDY0RU:0SF]0QS60R480QS6
0QBU0Sg_0QBU0Re[0S6<0R480S6<0QS60PaS0PQ20R480RDY0Q240Re[0P000R480Re[0QcW0SF]0PaS
0Q240QcW0S6<0PQ20QcW0QBU0PQ200<Q200000000R480QS60QBU0P000R480RU:0PQ20QcW11S60PQ2
0P@Q0QcW0Q240QS60PaS0Q240QcW0P@Q0Q240R4811S60PaS0RU:0QBU0QcW0QBU0Q240SW>12DY0RU:
0Sg_0VLi0Re[0S6<0THa0RU:0Woo0W_N0Ukg37oo0PaS8Goo0@000Goo000EOol00`00Oomoo`0FOol2
JeX8Ool2Li`2G_L2Ool2CW<2Kg/2BU8248@2Mkd26<H25:D28@P2;F/2:DX2<H`27>L29BT2:DX2=Jd2
6<H28@P26<H25:D2?Nl25:D2;F/2<H`28@P2<H`26<H236<224828@P29BT248@2;F/200028@P2;F/2
7>L2=Jd236<248@27>L2<H`224827>L25:D224800b48000000028@P26<H25:D200028@P2:DX22482
7>L46<H2248212427>L248@26<H236<248@27>L2124248@28@P46<H236<2:DX25:D27>L25:D248@2
>Lh49BT2:DX2?Nl2IcT2;F/2<H`2AS42:DX2Ool2Nmh2G_L<Ool236<QOol10001Ool001Eoo`03001o
ogoo00Yoo`9Nm`Aoo`9Nm`9240Qoo`9BU09[FP8aS08]J`9kgP8icP8aS09:DP8e[@8HaP8]J`8mk`9>
L`9:DP9>L`8U:@@@Q08aS08Q208DY@8Li`8aS0@@Q0@Q20@@Q08U:@8Li`8DY@8HaP@<H`88@P8HaP8L
i`8YBP8Li`8DY@8Li`8<H`848@8@Q0848@8Q2088@P8000D8@P8<H`848@8@Q08<H`88@P8<H`8DY@84
8@8Li`848@88@P8@Q08DY@8HaP8@Q08<H`848@88@PHQ208DY@8Li`8icP80008YBP848@8Li`8<H`8e
[@8U:@8<H`8Q208U:@8YBP8Q208YBP8U:@9cW09:DP9W>@92409oo`9g_@9>L`9oo`9:DP8aS0Aoo`8e
[Aeoo`40005oo`005Goo00<007ooOol02Woo0Ukg17oo0Ukg0T8@27oo0U:D0V]J0S6<0Re[0W_N0SW>
0S6<0TYB0SF]0QS60Re[0Sg_0Tic0TYB0Tic0RDY11240S6<0R480QBU0QcW0S6<1124124811240RDY
0QcW0QBU0QS610aS0PQ20QS60QcW0RU:0QcW0QBU0QcW0PaS0P@Q0Q240P@Q0R480PQ20P001@Q20PaS
0P@Q0Q240PaS0PQ20PaS0QBU0P@Q0QcW0P@Q0PQ20Q240QBU0QS60Q240PaS0P@Q0PQ21R480QBU0QcW
0SW>0P000RU:0P@Q0QcW0PaS0SF]0RDY0PaS0R480RDY0RU:0R480RU:0RDY0W>L0TYB0VLi0T8@0Woo
0WNm0Tic0Woo0TYB0S6<17oo0SF]7Goo0@000Goo000EOol00`00Oomoo`0<Ool2IcT<Ool25:D2<H`2
BU82F]H2E[D2?Nl2Kg/25:D2G_L2Ool2F]H2DY@2>Lh2HaP2Ool2:DX2?Nl2<H`2?Nl2@Q029BT2;F/2
7>L21242BU828@P29BT28@P2;F/25:D26<H27>L436<2124248@28@P45:D29BT2:DX27>L26<H236<2
8@P248@27>L2:DX248@200026<H00b4836<<H`026<H27>L2124248@2<H`2248248@26<H248@27>L2
6<H236<26<H25:D248@424829BT25:D26<H28@P2<H`2124236<26<H236<29BT26<H2:DX2>Lh21242
6<H29BT2@Q025:D2=Jd2?Nl2;F/25:D2DY@2BU86Ool2Nmh2Ool2IcTUOol10001Ool001Eoo`03001o
ogoo00aoo`9W>@aoo`8DY@8aS09:DP9JeP9F]@8mk`9_N`8DY@9Nm`9oo`9JeP9BU08icP9S609oo`8Y
BP8mk`8aS08mk`92408U:@8]J`8Li`848@9:DP8Q208U:@8Q208]J`8DY@8HaP8Li`@<H`848@8@Q08Q
20@DY@8U:@8YBP8Li`8HaP8<H`8Q208@Q08Li`8YBP8@Q080008HaP038@P<H`aS008HaP8Li`848@8@
Q08aS088@P8@Q08HaP8@Q08Li`8HaP8<H`8HaP8DY@8@Q0@8@P8U:@8DY@8HaP8Q208aS0848@8<H`8H
aP8<H`8U:@8HaP8YBP8icP848@8HaP8U:@92408DY@8e[@8mk`8]J`8DY@9BU09:DPIoo`9kgP9oo`9W
>BEoo`40005oo`005Goo00<007ooOol047oo0V<H1Woo0UJe17oo0QcW27oo0SF]0Woo0Tic17oo0SF]
0Woo0U[F17oo0QcW0U[F0Ukg0R480THa0QcW0Re[0Ukg0R480Sg_0R480Re[0S6<0QcW0SF]0PaS0R48
0Tic0P@Q0RDY0QBU0Re[0RU:0Q240RU:0QcW0PQ20Re[0RU:0RDY0PaS0QcW0R480QS600<U:AS66<H0
0QcW0Re[0R480QBU0PQ20RU:0Q240QcW0Sg_0PQ20RDY0SF]0RDY0QBU0QcW0SF]0RU:12DY0PQ20S6<
0SW>0Re[0PaS0THa0RDY0QcW0QS60QcW0Sg_0R480THa0TYB1QS60Woo1RDY0Tic0Woo0Ukg0TYB0U:D
0Q240Woo0SW>0Woo0W_N17oo0TYB6Goo0@000Goo000EOol2000AOol2HaP6Ool2E[D4Ool27>L8Ool2
=Jd2Ool2CW<4Ool2=Jd2Ool2F]H4Ool27>L2F]H2G_L28@P2AS427>L2;F/2G_L28@P2?Nl28@P2;F/2
<H`27>L2=Jd236<28@P2CW<212429BT25:D2;F/2:DX248@2:DX27>L22482;F/2:DX29BT236<27>L2
8@P26<H00bDY6<HHaP027>L2;F/28@P25:D22482:DX248@27>L2?Nl224829BT2=Jd29BT25:D27>L2
=Jd2:DX49BT22482<H`2>Lh2;F/236<2AS429BT27>L26<H27>L2?Nl28@P2AS42BU866<H2Ool69BT2
CW<2Ool2G_L2BU82DY@248@2Ool2>Lh2Ool2Nmh4Ool2BU8HOol20001Ool001Eoo`03001oogoo021o
o`9W>A1oo`9_N`9JeP9cW09_N`9>L`92408icP8<H`9JeP@U:@8]J`8@Q09240@Li`8Q208Li`8e[@8@
Q088@P8aS08YBP8DY@8YBP8HaP8YBP8HaP8YBP8HaP848@8e[@8@Q0@Li`8<H`8aS08@Q08YBP0336<@
Q124008U:@8HaP8Q208YBP8<H`@YBP8Q208HaP8Q208e[@8DY@8e[@8Li`8aS08]J`8DY@8Q208@Q08]
J`8YBP8HaP8Q20@Li`88@P8]J`8<H`92408YBP8Q208e[@8<H`9:DP92408e[@8DY@8@Q08]J`9oo`8m
k`8HaP96<@9kgP9W>@Yoo`9S61eoo`40005oo`005Goo00<007ooOol087oo0VLi47oo0Vmk0U[F0W>L
0Vmk0Tic0T8@0SW>0PaS0U[F12DY0Re[0Q240T8@11cW0R480QcW0SF]0Q240PQ20S6<0RU:0QBU0RU:
0QS60RU:0QS60RU:0QS60P@Q0SF]0Q2411cW0PaS0S6<0Q240RU:00<<Ha2448@00RDY0QS60R480RU:
0PaS12U:0R480QS60R480SF]0QBU0SF]0QcW0S6<0Re[0QBU0R480Q240Re[0RU:0QS60R4811cW0PQ2
0Re[0PaS0T8@0RU:0R480SF]0PaS0TYB0T8@0SF]0QBU0Q240Re[0Woo0Sg_0QS60THa0W_N0VLi2Woo
0V<H7Goo0@000Goo000EOol00`00Oomoo`0ZOol2Kg/8Ool2<H`2?Nl2CW<2<H`25:D2<H`4;F/25:D2
24827>L236<29BT28@P27>L236<28@P236<212425:D448@236<29BT28@P26<H248@27>L236<20002
7>L236<248@2248248@26<H248@27>L00`002488@P026<H224845:D2124448@224825:D224828@P2
12427>L248@400026<H236<25:D27>L200026<H25:D26<H25:D2=Jd436<25:D2000248@65:D2<H`2
6<H28@P2;F/2DY@2BU82@Q02CW<2HaP4Ool2?Nl2@Q06Ool2MkdMOol10001Ool001Eoo`03001oogoo
02Yoo`9_N`Qoo`8aS08mk`9>L`8aS08DY@8aS0@]J`8DY@88@P8Li`8<H`8U:@8Q208Li`8<H`8Q208<
H`848@8DY@@@Q08<H`8U:@8Q208HaP8@Q08Li`8<H`80008Li`8<H`8@Q088@P8@Q08HaP8@Q08Li`03
0008@PQ2008HaP88@P@DY@848@@@Q088@P8DY@88@P8Q20848@8Li`8@Q0@0008HaP8<H`8DY@8Li`80
008HaP8DY@8HaP8DY@8e[@@<H`8DY@80008@Q0HDY@8aS08HaP8Q208]J`9BU09:DP92409>L`9S60Ao
o`8mk`9240Ioo`9g_Aeoo`40005oo`005Goo00<007ooOol087oo0W_N27oo0SF]0Woo0V<H0Sg_0V]J
0Re[0Woo0V<H0RU:0T8@0U[F0TYB0Woo0QS60SW>0UJe0S6<0Woo12480UJe13g_0SF]0RDY0T8@0SF]
0S6<0Re[0S6<0THa0R480S6<14Ha0Re[0S6<0R480Tic0QS60SF]0T8@0SF]00<icSg_?Nl00RU:0Re[
0SW>0R480Sg_0S6<0Re[0SF]0Re[0THa0Sg_0RU:0SF]0Re[0Ukg0TYB0QS60THa0UJe0RU:0S6<0Re[
0TYB0SF]0SW>0RU:0Ukg0T8@0W_N0U[F0TYB0U:D0SF]17oo0R480Ukg0W>L0Woo0U:D0SF]0V<H0SW>
0Woo0VLi0UJe17oo0VLi8Goo0@000Goo000EOol00`00Oomoo`0POol2Nmh8Ool2=Jd2Ool2HaP2?Nl2
JeX2;F/2Ool2HaP2:DX2@Q02F]H2BU82Ool26<H2>Lh2E[D2<H`2Ool48@P2E[D4?Nl2=Jd29BT2@Q02
=Jd2<H`2;F/2<H`2AS428@P2<H`4AS42;F/2<H`28@P2CW<26<H2=Jd2@Q02=Jd00cW>?Nlmk`02:DX2
;F/2>Lh28@P2?Nl2<H`2;F/2=Jd2;F/2AS42?Nl2:DX2=Jd2;F/2G_L2BU826<H2AS42E[D2:DX2<H`2
;F/2BU82=Jd2>Lh2:DX2G_L2@Q02Nmh2F]H2BU82DY@2=Jd4Ool28@P2G_L2Li`2Ool2DY@2=Jd2HaP2
>Lh2Ool2IcT2E[D4Ool2IcTQOol10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<0
07ooOol0ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol0
0`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol1
0001Ool001Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?mo
ob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(n = 128;\)\)], "Input"],

Cell[TextData[StyleBox["nPrime=32;\ncutfa=TakeMatrix[fa,{1,1},{32,32}];\n\
compressedfSpec=BlockMatrix[{{cutfa,ZeroMatrix[nPrime,n-nPrime]},{ZeroMatrix[\
n-nPrime,n]}}];",
  FontSize->14]], "Input",
  PageBreakWithin->Automatic,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[InverseFourier[fa]], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00WooB3F]13W>1SF]23W>0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa
0T8@0THa0SW>1Goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol00WooB3F]13W>1SF]23W>
0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa0T8@0THa0SW>1Goo0@000Goo000>Ool20005
Ool00`00Oomoo`02OomB=Jd6>Lh4=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl8>Li<?Nl6@Q02?Nl2
<H`28@P5Ool10001Ool001Eoo`03001oogoo009ooe8e[@HicP@e[@8aS08e[A`icP8mk`TicP@e[A0i
cP@mk`PicT`mk`I2408mk`8aS08Q20Eoo`40005oo`005Goo00<007ooOol00WooDSF]13W>13F]136<
0SF]73W>0Sg_2CW>13F]43W>1Sg_13W>33g_1SW><3g_148@13g_248@0SF]0Re[0QS60PaS1Goo0@00
0Goo000EOol00`00Oomoo`02OomB=Jd4>Lh4=Jd4<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh6?Nl4>Lh<?Nl6
>Lh`?Nl4@Q04?Nl8@Q02=Jd2;F/26<H236<5Ool10001Ool001Eoo`03001oogoo009ooc`e[@8icPPe
[@8icPXe[@@icP@e[@8aS0@e[A`icP8mk`<icP8mk`8icP@aS08e[@@mk`PicQ@mk`8icRPmk`A2408m
k`A240Hmk`A2408mk`8icP8mk`A6<@8mk`8aS08Li`8@Q0@000Eoo`40005oo`005Goo00<007ooOol0
0Woo?3F]0SW>23F]0SW>2SF]13W>13F]0S6<13F]73W>0Sg_0cW>0Sg_0SW>136<0SF]13g_23W>53g_
0SW>:3g_148@0Sg_148@1Sg_148@0Sg_0SW>0Sg_14Ha0Sg_0S6<0QcW0Q2410001Goo0@000Goo000E
Ool00`00Oomoo`02Ool2>Lhf=Jd6>Lh6=Jd6>Lh6=Jd6>Lh4=Jd2<H`2=JdN>Lh2?Nl3>Lh2?Nl2>Lh4
<H`2>Li6?Nl:@Q02?Nl6@Q08?Nl2@Q02AS42@Q02=Jd29BT25:D2248212440005Ool10001Ool001Eo
o`8000=oo`8icSHe[@HicPHe[@HicPHe[@HicP@e[@8aS08e[AhicP8mk`<icP8mk`8icP@aS08icTHm
k`Y2408mk`I240Pmk`924096<@92408e[@8U:@8DY@88@P848@@000Aoo`80005oo`005Goo00<007oo
Ool00Woo33W>83F]53W>0SF]23W>13F]1SW>23F]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Sg_148@3Sg_1T8@13g_448@0Sg_448@0SW>0Re[0QcW0PaS2P001Goo0@000Goo000EOol00`00
Oomoo`02Ool<>LhP=JdD>Lh2=Jd8>Lh4=Jd6>Lh8=Jd>>Lh2=Jd@>Lh2?Nl00cW>?Nlmk`02?Nl2=Jd2
<H`2=JdV?Nl4@Q0>?Nl6@Q04?Nl@@Q02?Nl@@Q02>Lh2;F/27>L236<:0005Ool10001Ool001Eoo`03
001oogoo009ooaXicP8e[@@icPPe[A0icP@e[@@icP8e[@HicPHe[@HicPPe[A`icP@mk`8icP<mk`8i
cP8e[@8aS08e[B@mk`Q240`mk`Q2408mkaA240@mk`9240A6<@92408e[@8U:@8@Q0848@`000Eoo`40
005oo`005Goo00<007ooOol00Woo6SW>0SF]13W>23F]43W>13F]13W>0SF]1SW>1SF]1SW>23F]73W>
13g_0SW>0cg_0SW>0SF]0S6<0SF]93g_248@33g_248@0Sg_548@13g_0T8@14Ha0T8@0SF]0RDY0Q24
0P@Q30001Goo0@000Goo000EOol00`00Oomoo`02Oom0>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd:>Lh4
?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhP?Nl2@Q02?Nl6@Q0>?NlN@Q02?Nl2@Q04AS42?Nl2<H`28@P2
48@2124>0005Ool10001Ool001Eoo`03001oogoo009ood0icP@e[@HicP8e[@PicP8e[@8aS08e[@Xi
cP@mk``icPPmk`8icP<mk`8icP@e[@8icR0mk`92408mk`I240hmkai2408mk`9240A6<@8mk`8aS08Q
208@Q0848@h000Eoo`40005oo`005Goo00<007ooOol00Woo6SW>0SF]>3W>13F]2SW>3Sg_13W>2cg_
0SW>13F]0SW>83g_148@0Sg_1T8@23g_648@0Sg_2T8@1THa0SW>0RU:0QS60PaS0P@Q40001Goo0@00
0Goo000EOol00`00Oomoo`02OolJ>Lh2=Jdh>Lh4=Jd:>Lh>?Nl4>Lh;?Nl2>Lh4=Jd2>LhP?Nl4@Q02
?Nl6@Q08?NlH@Q02?Nl:@Q06AS42>Lh2:DX26<H236<2124@0005Ool10001Ool001Eoo`03001oogoo
009oo`8mke0icPHe[@8icP8mk`@icQlmk`@e[@8icQXmk`a2408mk`I240Hmkb9240I6<@8mk`8e[@8U
:@8@Q0848@h000848@@000Eoo`40005oo`005Goo0P000goo0Sg_D3W>1SF]0SW>0Sg_13W>7cg_13F]
0SW>6Sg_348@0Sg_1T8@1Sg_8T8@1THa0Sg_0SF]0RDY0Q240P@Q3P000P@Q100017oo0P000Goo000E
Ool00`00Oomoo`02OolL?Nlf>Lh6=Jd2>Lh2?Nl4>Lh4?Nl4>LhF?Nl00cW>=Jde[@02<H`2>Lh4@Q04
>Lh>?Nl:@Q02?NlJ@Q08AS42@Q04AS48@Q04AS42BU82AS42@Q02<H`27>L236<21242000212440004
124:0005Ool10001Ool001Eoo`03001oogoo009ooa`mkcHicPHe[@8icP8mk`@icP@mk`@icQHmk`03
>Lhe[CF]008aS08icPA240@icPhmk`Y2408mkaY240Q6<@9240A6<@Q240A6<@9:DP96<@92408aS08L
i`8<H`848@8000848@@000@48@X000Eoo`40005oo`005Goo00<007ooOol00Woo63g_23W>23g_13W>
63g_23W>0Sg_0SW>1SF]13W>6Sg_13W>1Sg_00<icSF]=Jd00SF]0SW>1Sg_0SW>13g_6T8@13g_848@
14Ha0Sg_0T8@1THa0SW>0Re[0QcW0PaS0P@Q0P000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolH?Nl8>Lh8?Nl4>LhH?Nl8>Lh2?Nl2>Lh6=Jd4>LhJ?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2
>Lh4?NlJ@Q04?NlP@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124D0005Ool10001Ool0
01Eoo`03001oogoo009ooa`mk`@icPPmk`@icP`mk`@icPhmk`8icP8mk`8icP@e[@@icRHmk`03>Lhe
[CF]008icP8mk`9240hmkca240Q6<@8mk`8aS08U:@8DY@88@P848@@000848A@000Eoo`40005oo`00
5Goo00<007ooOol00Woo73g_13W>23g_13W>33g_13W>3Sg_0SW>0Sg_0SW>13F]13W>9Sg_00<icSF]
=Jd00SW>0Sg_0T8@3Sg_?48@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q50001Goo0@000Goo000E
Ool00`00Oomoo`02Ool<?Nl4@Q02?Nl6@Q0f?Nl8>LhV?Nl5>Lh4?Nl4@Q02?Nl4@Q08?NlZ@Q02AS48
@Q02AS44@Q02AS42BU82AS42>Lh2;F/26<H248@212480002124D0005Ool10001Ool001Eoo`03001o
ogoo009oo``mk`A2408mk`I243Hmk`PicRHmk`DicP@mk`A2408mk`A240PmkbY24096<@Q24096<@A2
4096<@9:DP96<@8icP8]J`8HaP8@Q0848@P000848A@000Eoo`40005oo`005Goo00<007ooOol00Woo
448@0Sg_1T8@13g_148@;Sg_1SW>:3g_0SW>1Cg_348@23g_=48@0THa0T8@0THa0TYB0THa0SW>0RU:
0QS60PQ20P@Q100010@Q60001Goo0@000Goo000EOol20003Ool@@Q02?Nl6@Q04?Nl4@Q0^?Nl6>LhX
?Nl2>Lh5?Nl<@Q08?Nld@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124H0004Ool2
0001Ool001Eoo`03001oogoo009ooaY2408mk`I2408mkaQ2410mk`PicP8mk`92410mk`A241<mk`A2
40@mkdI24096<@A:DP8icP8YBP8HaP8<H`H000@48AX000Eoo`40005oo`005Goo00<007ooOol00Woo
6T8@0Sg_1T8@0Sg_648@43g_23W>0Sg_0T8@43g_148@4cg_148@13g_AT8@0THa14YB0SW>0RU:0QS6
0PaS1P0010@Q6P001Goo0@000Goo000EOol00`00Oomoo`02Ool2AS46@Q04AS4d@Q0<?Nl6>Lh4?Nl2
@Q0B?Nl2@Q04?Nl2@Q0:?Nl7@Q04?NlJ@Q0:AS4D@Q02AS48@Q06AS42BU82?Nl29BT25:D2248V0005
Ool10001Ool001Eoo`03001oogoo009oo`96<@I240A6<CA240`mk`HicP@mk`92418mk`9240@mk`92
40Xmk`M240@mkaY240Y6<AA24096<@Q240I6<@9:DP8mk`8U:@8DY@88@RH000Eoo`40005oo`005Goo
00<007ooOol00Woo6THa<T8@23g_248@33g_2T8@2Sg_5D8@14Ha2T8@24Ha4T8@0THa0T8@1THa148@
14Ha0TYB0THa0SW>0RDY0Q2410@Q0P000P@Q30000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolJAS4b@Q08?Nl8@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q08AS4B@Q02AS42@Q06AS44@Q04AS42BU82AS42
>Lh29BT248@412420002124<0002124D0005Ool10001Ool001Eoo`03001oogoo009ooaY6<@Q240Y6
<B1240@mkb9240@mk`8icP@mk`m240Y6<@Y240I6<A1240I6<@9240a6<@A:DP8icP8U:@8DY@P48@H0
00@48AH000@48@Eoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Woo6THa248@2THa848@
13g_8T8@13g_0SW>13g_3d8@2THa2T8@1THa448@1THa0T8@34Ha14YB0SW>0RDY0QBU20@Q1P0010@Q
5P0010@Q1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Woo0TYB
;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa148@0THa1T8@34Ha148@
0THa14YB0THa0SW>0RU:0Q240PQ220@Q90001Goo0@000Goo0008Ool00`00Oomoo`02Ool01000Oomo
o`0017oo0P000goo0TYB;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa
148@0THa1T8@34Ha148@0THa14YB0THa0SW>0RU:0Q240PQ220@Q900017oo0P000Goo0009Ool01@00
Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo34YB24Ha1TYB6THa248@0THa148@0Sg_
13W>0Sg_148@14Ha148@0THa248@14Ha1T8@0THa3T8@0THa8d8@24Ha148@5THa0T8@14Ha0T8@0SF]
0RDY0QBU0PQ2:0000P@Q10001Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03
001oogoo009oo`a:DPQ6<@I:DQY6<@Q24096<@A2408mk`@icP8mk`A240A6<@A24096<@Q240A6<@I2
4096<@i24096<B=240Q6<@A241I6<@9240A6<@92408e[@8U:@8DY@88@RP000848@@000Eoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol00Woo94YB6THa0T8@0Sg_0SW>0S6<0Re[0SF]0T8@0TYB
0Tic34Ha148@1THa148@0THa2T8@5DHa148@=4Ha0TYB0THa0SF]0RDY0Q240PQ230000P@Q30000P@Q
300020@Q1Goo0@000Goo000EOol00`00Oomoo`02OolTBU8JAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02
BU82CW<<AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0dAS42BU82AS42=Jd29BT248@2248<0002124<0002
124<00081245Ool10001Ool001Eoo`03001oogoo009oo`i:DPI>L`Q:DPA6<Ai:DPA6<@8mk`8e[@8a
S08mk`9:DPABU09>L`A240Q6<@A24096<@9:DPQ6<@Q240A6<@924456<@I:DP96<@8icP8YBP8HaP88
@P848@8000h48@P000X48@@000X48@Eoo`40005oo`005Goo00<007ooOol00Woo3TYB1Tic24YB14Ha
7TYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@24Ha148@0THa0TYB24Ha248@14Ha0T8@@DHa1TYB
0THa0SW>0RU:0QS60PQ20P@Q0P003P@Q20002P@Q10002P@Q1Goo0@000Goo000EOol00`00Oomoo`02
Ool4CW<8BU86CW<8BU82CW<2AS44BU88CW<2BU86AS44@Q06AS48BU82AS42@Q02BU82E[D2F]H2IcT2
G_L2CW<2@Q0<AS44BU82AS42@Q04AS46@Q0cAS44BU8BAS44BU82AS42?Nl2:DX26<H236<212440004
12460002124:000H1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`Q:DPI>L`Q:DP9>L`96<@A:
DPQ>L`9:DPI6<@A240I6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240a6<@A:DP96<@9240A6
<@I243=6<@A:DQ96<@A:DP96<@8mk`8YBP8HaP8<H`848@@000@48@H000848@X001P48@Eoo`40005o
o`005Goo00<007ooOol00Woo24ic24YB34ic0U:D1Tic0TYB0THa0T8@0Sg_1SF]136<1SF]0SW>13g_
1T8@0Tic0U[F0V<H0Vmk0VLi0UJe0TYB1THa1TYB0THa13g_0T8@0THa0TYB24Ha0TYB<DHa2TYB2THa
14YB0T8@0S6<0QcW0PaS0P@Q700060@Q1Goo0@000Goo000EOol20003Ool8CW<8BU8<CW<2DY@6CW<2
BU82AS42@Q02?Nl6=Jd4<H`6=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2IcT2E[D2BU86AS46BU82AS44
?Nl2@Q02AS42BU88AS42BU8aAS4:BU8:AS44BU82@Q02<H`27>L236<2124L000H1244Ool20001Ool0
01Eoo`03001oogoo009ooaY>L`9:DP9>L`9:DP96<@92408icP8e[@8aS0@]J`HYBP`U:@@YBP8]J`8m
k`9BU09S60AW>@9JeP9>L`9:DPA6<@9>L`ABU096<@8icP8e[@8icP924096<@A:DPA6<@I:DS56<@Q:
DPI6<@I:DP92408e[@8Q208@Q0848@@000`48@h001P48@Eoo`40005oo`005Goo00<007ooOol00Woo
6Tic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:32DY12U:0Re[0Sg_0U:D0V<H16Li0U[F0Tic
0TYB14Ha0Tic15:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha1TYB<DHa24YB1THa1TYB0T8@0SF]0R48
0Q240P@Q100030@Q3P0060@Q1Goo0@000Goo000EOol00`00Oomoo`02OolBCW<4DY@2CW<2BU82AS44
?Nl2=Jd2<H`2;F/>:DX49BT28@P27>L86<H28@P2>Lh2F]H2Kg/2Li`2IcT2E[D6DY@2F]H2IcT2HaP2
E[D2@Q04<H`2@Q02BU82AS4<BU8GAS4BBU8>AS44BU84AS46BU82AS42>Lh29BT25:D2248412420006
12420002124D000D1245Ool10001Ool001Eoo`03001oogoo009ooa9>L`ABU09>L`9:DP96<@@mk`8e
[@8aS08]J`hYBP@U:@8Q208Li`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP9W>@9S609F]@92
40@aS092409:DP96<@a:DQM6<A9:DPi6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P@48@8000H48@80
00848A@001@48@Eoo`40005oo`005Goo00<007ooOol00Woo34ic15:D14ic0TYB0T8@0Sg_0SW>0S6<
32e[12U:1Re[12U:12DY1R480RU:0SW>0Tic0VLi0W>L0V]J0UJe0TYB0U:D0U[F0Ukg0V<H0VLi0Ukg
0U:D0T8@0Sg_0T8@14YB0Tic3TYB5DHa34YB1THa1TYB14Ha1TYB14Ha1TYB0THa0SW>0RDY0QBU0PQ2
100020@Q2P001P@Q10006P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<CW<4DY@4CW<2BU82@Q02
?Nl2>Lh2<H`<;F/4:DX6;F/4:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2
HaP2IcT2G_L2DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS46BU84AS46BU84AS46BU82AS42>Lh2
9BT25:D224840008124:00061244000J1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`YBU09>
L`96<@8mk`8e[@@aS08]J`8aS0P]J`8aS0@]J`XaS08]J`PaS08e[@92409F]@9W>@A_N`9JeP96<@8m
k`9:DP9JeP9Nm`9JeP9F]@Q:DPA>Ld5:DPA6<@a:DP96<@8icP8]J`8HaP8<H`848@@000H48@X000P4
8@@001X48@Eoo`40005oo`005Goo00<007ooOol00Woo14ic2U:D0Tic0THa0Sg_0SF]136<0Re[0S6<
22e[0S6<12e[2S6<0Re[236<0SF]0T8@0UJe0VLi16mk0U[F0THa0Sg_0TYB0U[F0Ukg0U[F0UJe24YB
14ic@DYB14Ha34YB0THa0SW>0Re[0QS60PaS0P@Q10001P@Q2P0020@Q10006P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool8DY@4CW<2AS42?Nl2=Jd2;F/4:DX4;F/:<H`8=Jd<>Lh6?Nl2AS42E[D2HaP2
Kg/2JeX2IcT2CW<2?Nl2=Jd2>Lh2AS44BU82CW<2BU8<CW<IBU88CW<ZBU82CW<2AS42?Nl2;F/27>L2
36<>1248000:1244000J1245Ool10001Ool001Eoo`8000=oo`QBU0A>L`96<@8mk`8e[@8]J`@YBP@]
J`XaS0Pe[@`icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP9>L`9:DPa>LaU:
DPQ>LbY:DP9>L`96<@8mk`8]J`8Li`8<H`h48@P000X48@@001X48@Aoo`80005oo`005Goo00<007oo
Ool00Woo15:D0Tic0TYB0T8@0Sg_136<22e[2S6<13F]1SW>1Sg_1T8@1THa0TYB0Tic0U:D0UJe0U[F
0Ukg0V<H0U:D0THa0SW>1SF]0T8@0Tic15:D0Tic1TYB0Tic0U:D34ic>DYB0THa14YB0T8@0S6<0R48
0QBU2P@Q3P00:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@2CW<2BU82@Q02?Nl4<H`8;F/:
<H`4=Jd6>Lh6?Nl6@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42>Lh6=Jd2@Q02CW<4DY@2
CW<6BU82CW<2DY@<CW<iBU82AS44BU82@Q02<H`28@P25:D:124>000X1245Ool10001Ool001Eoo`03
001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`haS0@e[@8icPHmk`Q240A6<@A:DP9>L`IBU09>L`9B
U09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`96<BE>LaQ:DP9>L`Y:DPA>L`a:DP96<@8e[@8U:@8@
Q088@P848A@002X48@Eoo`40005oo`005Goo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3S6<
13F]0SW>1Sg_248@14Ha14YB0Tic1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_0THa
9Dic64YB0Tic2TYB14ic34YB0THa0SF]0RDY0Q240PQ20P@Q5000:P@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl2=Jd2<H`6;F/B<H`2=Jd4>Lh4?Nl4@Q08AS44BU84CW<6DY@:E[D6DY@2CW<2BU82
@Q02?Nl2>Lh2BU82CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU86CW<2BU82AS42BU86CW<2?Nl2:DX26<H2
24821244000212440002124800081242000R1245Ool10001Ool001Eoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja8aS08e[@@icP@mk`A240Q6<@A:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`8icP9:DP9>
L`9BU09F]@ABU1e>La1:DPY>L`A:DPI>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@000848@@0
00848@P000P48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<1Re[3S6<13F]0SW>0SF]
0SW>13g_148@14Ha24YB1Tic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@0Sg_0THa0TYB1U:D
>Dic14YB1Tic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P0030@Q1P002P@Q0P008P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`6;F/><H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04AS48BU86CW<8DY@2E[D2F]H4
E[D2DY@4E[D2DY@4CW<2BU82@Q02?Nl2AS42BU86DY@iCW<4BU86CW<6BU84CW<2AS42<H`27>L236<2
1242000<1246000:1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]Ja8aS08e[@@icP8m
k`A240A6<@Q:DPA>L`QBU0iF]@QJeP9F]@ABU09:DP96<@8mk`96<@9>L`YBU1m>L`9BU1A>L`A:DP9>
L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@48@@000848@H000X48@8002848@Eoo`40005oo`00
5Goo0P000goo1Re[4S6<0SF]13W>0Sg_148@14Ha24YB14ic25:D3UJe25[F0UJe15:D0TYB0THa0Sg_
0THa0Tic2U:D7dic0U:D54ic14YB0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q10000P@Q
1P002P@Q0P008P@Q17oo0P000Goo000EOol00`00Oomoo`02Ool6;F/><H`2=Jd4>Lh4?Nl4@Q04AS44
BU88CW<4DY@:E[D@F]H8E[D4DY@2AS42@Q02AS42CW<8DY@6CW<:DY@YCW<2BU88CW<2BU82?Nl2;F/2
6<H22486000L1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]J`haS08e[@@icP@mk`A2
40A6<@A:DPQ>L`ABU0YF]A1JePQF]@ABU096<@924096<@9>L`QBU0I>L`YBU2U>L`9:DPQ>L`9:DP8m
k`8]J`8HaP88@PH001`48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo336<1SF]13W>13g_
148@14Ha1TYB1Tic1U:D25Je65[F15Je15:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Tic
0U:D0Tic0THa0S6<0R480Q240P@Q1P0070@Q0P008P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<
<H`6=Jd4>Lh4?Nl4@Q04AS46BU86CW<6DY@8E[DHF]H4E[D4DY@2BU82AS42@Q02BU82CW<6DY@4CW<<
DY@?CW<2DY@NCW<2DY@2CW<2AS42<H`28@P248@21246000L1242000R1245Ool10001Ool001Eoo`03
001oogoo009oo`PaS0Pe[@8icPHmk`A24096<@A:DPI>L`QBU0IF]AIJePINm`AJePIF]@9BU09:DPA2
409:DPAF]@iBU0A>L`]BU0A>L`IBU1Q>L`ABU09:DP8icP8U:@8@Q0848@P004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo236<23F]0SW>1Sg_148@0THa14YB1Tic25:D1UJe5U[F1Ukg15[F1UJe0U:D
0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D64ic15:D0TYB0SW>0RDY0Q240P@Q2000@0@Q1Goo0@00
0Goo000EOol00`00Oomoo`02Ool6<H`8=Jd2>Lh4?Nl6@Q02AS44BU86CW<6DY@8E[D<F]HDG_L4F]H6
E[D2DY@2AS42@Q02AS42DY@2E[DUDY@JCW<2DY@2CW<2@Q02;F/26<H236<212420002124400101245
Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`HaS0Pe[@8icP@mk`I24096<@A:DPI>
L`IBU0QF]@aJeQANm`AJePIF]@9BU096<@924096<@9BU09F]BEBU1Y>L`9BU09>L`92408]J`8HaP8<
H`848@8000848@@004048@Eoo`40005oo`002Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF]@YJePiNm`9S60YNm`9JePIF]@9>L`96
<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@004048@Eoo`40005o
o`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF
]@YJePiNm`9S60YNm`9JePIF]@9>L`96<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088
@P848@8000848@@004048@Aoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2
E[D2BU84AS42CW<WDY@<CW<2DY@6CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool1
0001Ool000Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2
@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@6
CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool10001Ool000Uoo`8000=oo`8000Eo
o`03001oogoo009oo`8aS08e[@@icPPmk`9240I6<@A:DPA>L`IBU0IF]@aJePYNm`iS60YNm`IJeP9F
]@9BU09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`ABU09:DP92408]J`8Li`8<H`848@H000848@@00404
8@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1THa14YB14ic1U:D1UJe35[F
2Ukg3V<H2Ukg1U[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic15:D0TYB0T8@0Re[0QcW0PaS
0P@Q1P000P@Q1000@0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4@Q04AS44BU86
CW<4DY@8E[D<F]H6G_L2HaP2G_LDHaP:G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2CW<2BU82CW<4
DY@2AS42>Lh28@P25:D2248612420002124400101245Ool10001Ool001Eoo`03001oogoo009oo`8e
[@HicP@mk`A240A6<@A:DPI>L`ABU0QF]@aJePINm`9S609NmaAS60YNm`9JePAF]@9>L`A:DP9>LamB
U0Q>L`YBU09>L`9:DP9>L`ABU096<@8icP8Q208DY@88@PH48@8000848@@004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo13W>13g_148@1THa14YB1Tic1U:D1UJe35[F2Ukg66<H25kg1U[F0U:D1TYB
0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D0UJe0U:D0Sg_0Re[0QS60Q240PQ20P@Q2000A0@Q
1Goo0@000Goo000EOol00`00Oomoo`02Ool4>Lh4?Nl4@Q06AS44BU86CW<6DY@6E[D<F]H:G_LHHaP8
G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4CW<>DY@4CW<2DY@2E[D2DY@2?Nl2;F/26<H248@2
2482124800141245Ool10001Ool001Eoo`03001oogoo009oo`8icP@mk`A240I6<@A:DPI>L`QBU0AF
]@YJePaNm`iS609W>@aS60YNm`9JeP9F]@Q>LbeBU0I>L`ABU09:DP8aS08Q208DY@8@Q088@P848@H0
04H48@Eoo`40005oo`005Goo0P000goo0SW>13g_148@1THa14YB1Tic25:D15Je2U[F35kg3V<H0VLi
36<H2Ukg0U[F0UJe24ic;E:D1Tic15:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00AP@Q17oo0P000Goo
000EOol00`00Oomoo`02Ool2?Nl6@Q04AS46BU84CW<:DY@4E[D:F]H>G_L>HaP8IcT<HaP4G_L4F]H2
DY@6CW<[DY@8CW<2DY@2CW<2?Nl2:DX26<H248@236<4124400181245Ool10001Ool001Eoo`03001o
ogoo009oo`8mk`I240A6<@I:DPA>L`YBU0AF]@YJePiNm`iS60QW>@aS60ANm`AJeP9BU0I>Lb]BU0Q>
L`9BU09>L`8mk`8YBP8HaP8@Q08<H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo1T8@
14Ha24YB1Tic25:D0UJe3U[F35kg8V<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic15:D0TYB
0SF]0R480QBU0Q240PaS0P@Q1P00B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6@Q04AS48BU86
CW<8DY@2E[D>F]H<G_LRHaP2G_L6F]H2E[D2CW<4BU82CW<YDY@2CW<2DY@2CW<4DY@2BU82=Jd28@P2
5:D248@236<2124600181245Ool10001Ool001Eoo`03001oogoo009oo`A240I6<@Q:DPA>L`QBU0AF
]@iJePaNmb1S60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iBU0A>L`9BU09>L`92408]J`8HaP8@Q0@<
H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo148@1THa24YB14ic25:D15Je3U[F35kg
86<H15kg1U[F0UJe0U:D14YB0Tic6e:D0Tic3U:D14ic0U:D0Tic0T8@0Re[0QS60Q2410aS10@Q1000
B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q06AS44BU88CW<6DY@8E[D<F]H>G_LPHaP6G_L6
F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2CW<4DY@2CW<2>Lh29BT25:D436<2249@1245Ool10001Ool0
01Eoo`03001oogoo009oo`9240I6<@A:DPQ>L`IBU0QF]@aJePiNmb1S60INm`IJeP9BU09>L`A:DPI>
LaEBU0I>L`YBU09>L`ABU09>L`8icP8U:@8DY@@<H`88@U048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1THa1TYB1Tic1U:D25Je35[F35kg2V<H0VLi76<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic
15:D24ic15:D0T8@0Re[0QcW0Q2410aS0PQ2D0@Q1Goo0@000Goo000EOol20003Ool6AS46BU86CW<6
DY@8E[D<F]H<G_L:HaP2IcTLHaP8G_L2E[D2DY@6BU84CW<2DY@4CW<5DY@@CW<4DY@8CW<4DY@2@Q02
;F/27>L248@436<2249@1244Ool20001Ool001Eoo`03001oogoo009oo`A6<@A:DPY>L`IBU0IF]@YJ
ePiNm`YS60IW>AYS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@8Q208DY@@@Q088@Rh4
8@88@R848@Eoo`40005oo`005Goo00<007ooOol00Woo14Ha14YB2Tic1U:D1UJe2U[F3Ukg2V<H1VLi
6V<H25kg0U[F0U:D0Tic1TYB24ic0e:D7Tic0U:D0TYB0SF]0R480QBU11240PQ2;P@Q0PQ28P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool2AS48BU82CW<:DY@4E[D>F]H>G_L:HaP:IcT4HaP<IcT8HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/2
6<H648@2248`1242248P1245Ool10001Ool001Eoo`03001oogoo009oo`96<@Q:DP9>L`YBU0AF]@iJ
ePiNm`YS60YW>@AS60aW>@QS60ANm`9JePAF]@9>L`9:DP96<@A:DPQ>L`03DYA>Ldic00I>L`9BU0a>
L`9BU09>L`9:DPA>L`96<@8]J`8HaPH@Q088@S048@88@R048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1TYB1Tic2U:D15Je3U[F3Ukg2V<H36Li1V<H16Li36<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic
0TYB0Sg_0RU:0QBU0Q2410aS0PQ2;P@Q10Q280@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6BU86
CW<:DY@4E[D>F]H>G_L:HaP<IcT6HaP4IcT<HaP4G_L4F]H2E[D2DY@2CW<4AS42BU8WCW<2BU82?Nl2
:DX25:D248@436<2248^1244248P1245Ool10001Ool001Eoo`03001oogoo009oo`A:DPQ>L`QBU0AF
]@iJePaNma1S60YW>AQS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q208@Q0@<H`@8@QP4
8@88@Q048@P8@R048@Eoo`40005oo`005Goo00<007ooOol00Woo14YB24ic25:D15Je3U[F35kg46<H
2VLi66<H15kg15[F0UJe0Tic14Ha0TYB8dic15:D0THa0SF]0R480Q2410aS10Q260@Q0PQ240@Q20Q2
80@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU88CW<<E[D>F]H<G_L:HaP4IcT6HaP6IcTHHaP4
G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2BU82CW<4DY@2@Q02:DX26<H448@236<4248F1244248<124<
248P1245Ool10001Ool001Eoo`8000=oo`A:DPQ>L`aF]@iJePaNm`YS60AW>@IS60IW>AQS60ANm`AJ
eP9F]@9BU09:DPA6<@9:DQe>L`9:DP9>L`ABU092408YBP8HaP@@Q08<H`@8@QH48@@8@P`48@`8@R04
8@Aoo`80005oo`005Goo00<007ooOol00Woo14YB1Tic0U:D35Je3U[F35kg2V<H1VLi1V<H16Li5V<H
1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS60QBU0Q240PaS
20Q24P@Q10Q22P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU86CW<2DY@<E[D>F]H<
G_L:HaP6IcT6HaP4IcTFHaP6G_L4F]H2E[D2DY@2CW<6AS42BU8CCW<2BU86CW<2BU82CW<2DY@2CW<2
>Lh28@P26<H25:D248@236<8248B1244248:124@248N1245Ool10001Ool001Eoo`03001oogoo009o
o`9:DPI>L`ABU0aF]@aJeQ9Nm`IS60YW>AaS60INm`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:
DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP@DY@8@Q08<H`P8@P`48@X8@PH48@88@P848A08@Qh4
8@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB1Tic15:D35Je35[F4Ukg1V<H2VLi76<H1Ukg15[F
0UJe0U:D0Tic0TYB0THa0T8@0TYB1dic14YB24ic14YB14ic0TYB0Tic0U:D0THa0S6<0QS611BU0Q24
0PaS20Q230@Q2PQ21P@Q0PQ20P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6CW<6DY@:
E[D>F]HBG_L4HaP>IcTJHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2BU82CW<6BU88CW<2
>Lh29BT65:D248@:248:124V248N1245Ool10001Ool001Eoo`03001oogoo009oo`I>L`IBU0YF]@iJ
eQ9Nm`AS60iW>AYS60INm`AJePAF]@9BU09:DPI6<@A:DP=>L`A:DPA>L`9:DP9>L`I:DPQ>L`8icP8U
:@HDY@8@Q0X8@PX48BH8@Qh48@Eoo`40005oo`005Goo00<007ooOol00Woo1Tic15:D35Je3U[F25kg
1V<H15kg16<H0VLi0V<H2VLi6V<H2Ukg0U[F0UJe0U:D0Tic1THa6DYB1Tic0TYB0SF]0R480Q240QBU
0QS60Q2410Q20P@Q10Q22P@Q10Q210aS7PQ26P@Q10Q21Goo0@000Goo0007Ool30004Ool20005Ool0
0`00Oomoo`02Ool6CW<4DY@<E[D>F]H8G_L6HaP4G_L4HaP2IcT2HaP:IcTJHaP:G_L2F]H2E[D2DY@2
CW<6AS4IBU86CW<2BU82=Jd28@P248@25:D26<H248@424821244248:1244248436<N248J12442485
Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D25Je
45[F3Ukg16<H46Li76<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
11BU0PaS30Q210@Q0PQ21PaS0Q240PaS1PQ21P@Q4PQ26P@Q10Q21Goo0@000Goo0007Ool01000Oomo
o`000Woo00@007ooOol000Aoo`8000=oo`9>L`YBU0QF]A1JePiNm`AS611W>AaS60YNm`AJeP9F]@9>
L`9:DPA6<@9240e:DP96<@Y:DPA>L`8mk`8YBP8HaP8@Q0@DY@8<H``8@P@48@88@PH<H`8@Q08<H`H8
@PH48A88@QX48@@8@PAoo`80005oo`001goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9>
L`QBU0YF]A1JePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>
L`9:DP8icP8U:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eo
o`40005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`QBU0YF]A1J
ePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>L`9:DP8icP8U
:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eoo`40005oo`00
27oo0`000goo0P001Goo00<007ooOol00Woo0Tic1U:D35Je45[F35kg1V<H46Li76<H2Ukg15[F15Je
0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW0Q240PaS11240PaS1PQ22P@Q0PQ20PaS
0R480QcW0QBU0PaS70Q27P@Q0PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<6DY@<E[D@F]H<
G_L6HaP@IcTLHaP:G_L4F]H4E[D2DY@2CW<2AS42@Q02AS4;BU82AS4:BU82CW<2AS42<H`27>L248@2
36<448@236<6248:1242248236<28@P27>L25:D236<L248N12422485Ool10001Ool001Eoo`03001o
ogoo009oo`IBU0aF]A1JePYNm`QS619W>AaS60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB
00A:DPI6<@9:DP96<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@8@Q08<H`88@Ph48@8<H`8@Q0@HaP8DY@8<
Ha`8@Q`48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U:D35Je45[F2Ukg26<H4VLi76<H2Ukg
1U[F0UJe0U:D0Tic0TYB0THa0T8@00=6<DYBBU8014YB1THa0TYB0THa24YB0Sg_0Re[0QS60Q240PaS
0QBU0Q240PaS0PQ23P@Q0PaS0Q2411S60QBU0PaS70Q270@Q10Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool6DY@8E[DDF]H:G_L:HaP@IcTNHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT2
5:D236<248@25:D248@236<2248<1244248836<H248236<4248J12462485Ool10001Ool001Eoo`03
001oogoo009oo`IBU0QF]AAJePYNm`YS611W>AiS60QNm`IJeP9F]@ABU09:DP96<@=24196<@I:DP8i
cP8U:@8DY@8<H`8@Q08DY@8@Q08<H`88@P`48@@8@PP<HaP8@P8<H`@8@QX48@H8@PEoo`40005oo`00
5Goo00<007ooOol00Woo15:D25Je5U[F3Ukg2V<H4VLi66<H25kg1U[F0UJe15:D0Tic0TYB1d8@3THa
14YB0THa0SF]0R480Q2410aS0Q240PaS10Q23P@Q80Q210aS10Q26P@Q1PQ21Goo0@000Goo000EOol2
0003Ool4DY@8E[DFF]H>G_L:HaPBIcTHHaP8G_L6F]H2E[D4DY@2CW<2BU87@Q0>AS44BU82AS42=Jd2
8@P248@436<248@236<4248>124P248436<4248J12462484Ool20001Ool001Eoo`03001oogoo009o
o`ABU0QF]AAJeQ1Nm`YS619W>AaS60ANm`9JeP9Nm`9JePIF]@9BU09:DP96<@03@Q0mkcg_00A240a6
<@9:DP96<@92408aS08Li`8@Q0H<H`H8@PX48@88@P@48@H8@P@48A@8@P@<H`H8@P848@@8@PP48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo15:D25Je55[F45kg2V<H4VLi76<H15kg0U[F0Ukg0U[F
1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB0THa0T8@0S6<0QcW0Q241PaS1PQ22P@Q0PQ210@Q
1PQ210@Q50Q210aS1PQ20P@Q10Q220@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@8E[DD
F]H<G_L:HaP6IcT4HaP>IcTJHaP4G_L2F]H4G_L2F]H4E[D2DY@2BU82AS400d8@?Nlmk`06@Q06AS42
@Q02AS42BU82AS42?Nl2;F/26<H648@236<2248>124<248412462482124<248436<6248212442488
124@2485Ool10001Ool001Eoo`03001oogoo009oo`ABU0QF]AAJePaNm`YS60IW>@AS60iW>AYS60AN
m`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@
Q08<H`88@Ph48@`8@P@48@H8@P848@`8@P@<H`H8@P848@@8@PP48A08@PEoo`40005oo`005Goo00<0
07ooOol00Woo35Je45[F45kg26<H16Li26<H0VLi1V<H1VLi56<H3Ukg1U[F0UJe0U:D14ic00=6<Cg_
?Nl00Sg_1T8@14Ha148@0TYB0THa0SF]0RDY0QS61Q240PaS5P@Q0PQ210@Q5PQ210aS2PQ20P@Q1PQ2
1P@Q3PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool<E[D@F]H@G_L8HaP4IcT8HaP2IcT6HaP6IcTD
HaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT26<H648@236<F
12422484124F248436<:248212462486124>2485Ool10001Ool001Eoo`03001oogoo009oo`YF]A9J
eQ1Nm`YS609W>@QS609W>@IS60IW>AAS60ANm`9S60QNm`IJePAF]@9BU09>L`03BU92448@00Q240A6
<@A24096<@92408e[@8U:@8HaP8DY@8@Q08<H`88@Q@48@@8@P@48AH8@P@<H`X8@P848@H8@P@48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo2UJe4U[F45kg2V<H0VLi26<H0VLi1V<H1VLi56<H15kg
0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@0SF]0RDY0QS60QBU0Q240PaS
0PQ250@Q10Q210@Q5PQ210aS2PQ20P@Q1PQ210@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool8
E[DDF]H@G_LDHaP2IcT6HaP6IcT>HaP2G_L6HaP2G_L4HaP6G_L8F]H2E[D4DY@00dYBAS56<@04@Q02
?Nl2@Q02AS46@Q02AS42@Q02<H`28@P26<H25:D248@236<2248D124N248436<:248212462482124B
2485Ool10001Ool001Eoo`8000=oo`QF]AAJeQ1NmaAS609W>@IS60IW>@iS609Nm`IS609Nm`AS60IN
m`QJeP9F]@ABU003BU96<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88
@Q@48Ah8@P@<H`X8@P848@H8@P848A88@PAoo`80005oo`005Goo00<007ooOol00Woo25Je55[F45kg
46<H1VLi26<H0VLi46<H0Ukg36<H1Ukg25[F15Je0U:D00=>LdYBBU800THa0T8@0Sg_2T8@0THa0Sg_
0Re[0R480QS60QBU0Q240PQ250@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[DDF]H@G_L@HaP6IcT8HaP2IcT@HaP2G_L<HaP6G_L8F]H4E[D2DY@00dicBU9:DP02AS42@Q02
?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248D124P248436<:2482124J2485Ool10001Ool001Eo
o`03001oogoo009oo`QF]AAJePiNm`iS60YW>AYS609Nm`aS60ANm`YJePAF]@9BU003CW=:DTYB0096
<@9240@mk`Y2408icP8YBP8Li`8HaP8@Q08<HaH48B08@P@<H`X8@P848AX8@PEoo`40005oo`005Goo
00<007ooOol00Woo25Je55[F3Ukg3V<H2VLi6V<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa
0T8@13g_2T8@0SW>0RU:0QcW0QS60Q240PaS5P@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool8E[DDF]H<G_L>HaP<IcT2HaP4IcTDHaP2G_L<HaP4G_L:F]H4E[D2DY@3CW<2BU82
@Q04?Nl:@Q02=Jd29BT26<H25:D236<2248D124R248436<V2485Ool10001Ool001Eoo`03001oogoo
009oo`QF]AAJePaNm`iS60aW>@9S60AW>AAS609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2
408e[@8U:@8HaP8DY@8<H`88@Q@48B88@P@<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo25Je
45[F3Ukg3V<H3VLi0V<H16Li56<H0Ukg36<H1Ukg25[F1UJe00=BU4icCW<00TYB0THa0T8@1Sg_148@
0Sg_0S6<0R4811BU0PaS0PQ22P@Q0PQ210@Q9PQ20PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[D@F]H>G_L>HaP>IcT2HaP4IcTDHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06
?Nl4@Q02?Nl2<H`28@P45:D236<2248:12422484124V248236<X2485Ool10001Ool001Eoo`03001o
ogoo009oo`9F]AAJeQ1Nm`iS61AW>A9S60ANm`aS60INm`YJePAF]@=BU09>L`9:DP9240Pmk`92408m
k`8]J`8Li`8DY@8@Q08<H`88@PX48@88@P848BP8@P8<HbP8@PEoo`40005oo`005Goo0P000goo0UJe
55[F45kg3V<H56Li4V<H15kg36<H1Ukg2U[F15Je0e:D0Tic0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU
0Q240PaS0PQ22P@Q0PQ20P@Q:0Q20PaS:0Q217oo0P000Goo000EOol00`00Oomoo`02Ool4E[D@F]HB
G_L>HaP@IcTDHaP4G_L:HaP2IcT2HaP2G_L2HaP4G_L8F]H5E[D2DY@2CW<4BU82@Q02>Lh4?Nl2@Q02
?Nl2:DX26<H248@236<224881242248:12482482124D248836<T248236<22485Ool10001Ool001Eo
o`03001oogoo009oo`AF]A1JeQ9Nm`iS611W>AAS60ANm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PP48@88@PX48@P8@P848A@8@PP<Hb@8
@P8<H`88@PEoo`40005oo`005Goo00<007ooOol00Woo0UJe45[F4Ukg4V<H36Li5V<H15kg3V<H25kg
25[F1EJe0U:D14ic0TYB0T8@0SW>13g_0T8@0SW>0RU:0QS60Q240PaS0PQ220@Q10Q220@Q20Q20P@Q
5PQ21PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D@F]HBG_LBHaP<IcTFHaP4G_L>HaP8
G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02>Lh2:DX26<H248@236<224881244248812482482
124F248636<X2485Ool10001Ool001Eoo`03001oogoo009oo`9F]@iJeQANmaAS60QW>AYS609Nm`iS
60QNm`YJeP=F]@ABU09>L`9:DP96<@8mk`8icP@mk`8icP8U:@8DY@8@Q08<H`88@PP48@@8@PP48@P8
@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`005Goo00<007ooOol00Woo0UJe3U[F55kg56<H26Li6V<H
0Ukg3V<H25kg2U[F0eJe15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ220@Q10Q2
20@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D>F]HDG_LFHaP6
IcTZHaP8G_L:F]H5E[D2DY@4CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<:1246248612482482124F
248636<V248236<5Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`9F]@iJeQANmaIS
60IW>BYS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8DY@@<H`X48@H8@PH48@P8@P84
8AH8@PH<HbH8@P8<H`Eoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomo
o`02Ool@F]HFG_LBHaP8IcTZHaP:G_L8F]H5E[D4DY@2CW<2BU82@Q06>Lh2<H`28@P25:D436<:1246
248612482482124F248636<X2485Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo
0P000goo45[F5Ukg4V<H26Li:V<H2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2P@Q
1PQ21P@Q20Q20P@Q5PQ21PaS:0Q217oo0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007oo
Ool00Woo4U[F55kg46<H2VLi;6<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU
0PaS0PQ25P@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007oo
Ool000Aoo`03001oogoo009ooa9JeQANma1S60YW>BaS60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8i
cP8e[@8aS08Q208DY@8<H`88@QH48@P8@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo4U[F2Ukg0V<H25kg36<H46Li:V<H35kg1e[F0UJe1U:D0Tic0TYB0T8@
0SW>0SF]0Re[0R480QBU0PaS0PQ25P@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000EOol00`00Oomo
o`02OolBF]H:G_L2HaP8G_L<HaP@IcTZHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P2
5:D236<2248F12482482124D248836<X2485Ool10001Ool001Eoo`03001oogoo009ooa9JePYNm`AS
60INm`YS61AW>BQS60iNm`EJeP9F]@IBU0A>L`96<@8mk`8e[@8]J`8Li`8DY@8<HaP48@P8@P848A@8
@PP<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo4U[F2Ukg16<H1Ukg2V<H56Li:6<H3Ukg1E[F
0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS60@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000E
Ool00`00Oomoo`02Ool@F]H@G_L4HaP2G_L:HaP@IcTDHaP4IcT2HaP6G_L<HaP<G_L9F]H4E[D2DY@4
CW<2BU82@Q02=Jd2:DX27>L248@236<@2482124:2486124@248:36<V248212422485Ool10001Ool0
01Eoo`03001oogoo009ooa1JeQ1Nm`AS609Nm`YS611W>AAS60AW>@9S60INm`aS60aNm`UJePAF]@9B
U0A>L`9:DP92408e[@8YBP8Li`8@Q08<Ha08@P848@X8@PH48A08@PX<HbH8@P848@88@PEoo`40005o
o`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi16<H46Li56<H0VLi16<H15kg3V<H35kg2E[F15Je
0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q:PQ240aS90Q21Goo0@000Goo000EOol20003
Ool@F]H@G_L:HaP2IcT4HaP@IcTDHaP2IcT4HaP4G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2
:DX27>L248@236<22486124Z248@36<T2484Ool20001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`YS
609W>@9S611W>AaS60ANm`iS60iNm`MJePAF]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BH8@Q8<
HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi0V<H46Li76<H15kg3V<H3Ukg
1e[F15Je0U:D14ic14YB0Sg_0Re[0QcW0Q2410Q21P@Q9PQ24PaS9PQ21Goo0@000Goo000EOol00`00
Oomoo`02Ool@F]H@G_L8HaP4IcT2HaP@IcTLHaP4G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`2
7>L248@42482124/248@36<V2485Ool10001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`QS60AW>@9S
611W>AaS60ANma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848B`8@Q0<HbH8@PEo
o`40005oo`005Goo00<007ooOol00Woo3U[F4Ukg1V<H1VLi16<H46Li1V<H0VLi4V<H15kg46<H35kg
1e[F1UJe0U:D1Tic0THa0SF]0R480Q244PQ20P@Q7PQ20PaS0PQ230aS9PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool>F]HBG_L6HaP6IcT4HaP@IcT6HaP2IcTBHaP4G_L@HaP<G_L7F]H6E[D2DY@6CW<2
AS42=Jd28@P248@B2482124N248236<2248<36<V2485Ool10001Ool001Eoo`03001oogoo009oo`iJ
ePiNm`YS60IW>@9S61aW>A1S60ANm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8mk`8YBP8@Q108
@P@48Ah8@Ph<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo3U[F3Ukg2V<H1VLi0V<H76Li46<H
15kg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q2440Q210@Q7PQ23PaS:0Q21Goo0@00
0Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPNIcTHHaP4G_L:HaP>G_L7F]H4E[D4DY@4
CW<2AS42<H`25:DB2482124L248636<648@836<T2485Ool10001Ool001Eoo`8000=oo`iJePiNm`QS
60IW>@9S61iW>AQS60ANm`YS60iNm`MJePAF]@ABU0A>L`96<@8aS08DYA88@P848A`8@PH<H`H@Q0P<
Hb@8@PAoo`80005oo`005Goo00<007ooOol00Woo3U[F3Ukg26<H1VLi0V<H86Li5V<H15kg2V<H3Ukg
2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:PQ220aS0Q2411BU0Q241PaS80Q20PaS0PQ21Goo
0@000Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPPIcTFHaP4G_L:HaP>G_L9F]H2E[D2
DY@2E[D4CW<2BU82>Lh26<H2248236<Z248836<248@45:D248@636<P248236<22485Ool10001Ool0
01Eoo`03001oogoo009oo`IJeQINm`YS62IW>BAS60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2188
@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q08<H`88@P8<Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo
1U[F5Ukg2V<H9VLi96<H3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484PQ20P@Q7PQ20PaS0Q2411S6
0QBU0Q240PaS0PQ20PaS90Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4
G_L:HaP2G_L4HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@@2482124N248236<248@46<H2
5:D248@636<T2485Ool10001Ool001Eoo`03001oogoo009oo`IJeQINm`IS62YW>AIS60ANm`YS609N
m`AS60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q108@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q0H<
Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U[F5Ukg1V<H:VLi5V<H15kg1V<H15kg26<H1ekg
25[F15Je25:D0THa0Re[0QBU1PQ20PaS9PQ210aS0QBU12480QBU0Q2410aS9PQ21Goo0@000Goo000E
Ool00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8DY@2AS42;F/2
5:D6248236<V248436<25:D48@P25:D248@436<V2485Ool10001Ool001Eoo`03001oogoo009oo`IJ
eQINm`AS62aW>AIS60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8HaPH8@P8<HbH8@P@<H`8H
aP@]J`8Li`8@Q0@<HbH8@PEoo`40005oo`005Goo0P000goo1U[F5Ukg16<H;6Li5V<H15kg1V<H15kg
26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9PQ210aS0QS612e[0QcW0Q2410aS9PQ217oo0P00
0Goo000EOol00`00Oomoo`02Ool6F]H>G_L<HaPBIcT4JeXDIcTHHaP4G_L8HaP6G_L4HaP7G_L8F]H4
E[D8DY@2BU82>Lh28@P6248236<J248436<8248436<28@P4=Jd28@P248@236<X2485Ool10001Ool0
01Eoo`03001oogoo009oo`IJePiNm`aS619W>@A[FQAW>AQS60ANm`QS60INm`AS60MNm`QJePAF]@QB
U09:DP8icP8Q20H8@P8<HaX8@P@<H`P8@P@<H`8Q20@e[@8Q208@Q08<HbP8@PEoo`40005oo`005Goo
00<007ooOol00Woo15[F3Ukg36<H36Li0V]J16Li36]J46Li96<H15kg26<H0ekg2U[F15Je1U:D0Tic
0T8@0RU:0PaS10Q210aS60Q21PaS1PQ210aS0R4813F]0R480Q240PaS2PQ20P@Q70Q21Goo0@000Goo
000EOol00`00Oomoo`02Ool4F]H>G_L<HaP<IcT2JeX4IcT<JeX@IcTTHaP4G_L8HaP3G_L:F]H4E[D6
DY@2CW<2@Q02:DX236<4248436<H248636<6248436<28@P4=Jd28@P248@236<:2482124L2485Ool1
0001Ool001Eoo`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>C9S60=Nm`aJePIBU09>L`96<@8]J`8D
Y@@8@P8<HaX8@P@<H`P8@P@<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A`8@PEoo`40005oo`005Goo00<0
07ooOol00Woo45kg36<H36Li56]J46Li<V<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6PQ210aS
20Q210aS0QcW12e[0QcW0Q241PaS10Q210@Q70Q21Goo0@000Goo000EOol00`00Oomoo`02Ool@G_L<
HaP<IcTDJeX@IcTXHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D4248436<F248236<<248436<2
6<H49BT25:D248@636<42484124L2485Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eo
o`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>BQS60AW>@IS60=Nm`aJePIBU09>L`9:DP8e[@8DY@@8
@P@<HaH8@P8<H``8@P@<H`8HaP@U:@8DY@8@Q0H<H`@8@P@48A`8@PEoo`40005oo`000goo00D007oo
Oomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L6HaP@IcT@JeX4
IcT2JeX>IcTTHaP4G_L2HaP4JeX4HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H2
36<2248436<F248436<8248436<248@26<H47>L25:D448@236<V2485Ool10001Ool000=oo`05001o
ogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo4Ukg1V<H46Li46]J16Li0V]J
3VLi96<H15kg0V<H16]J16<H00=Nme[FF]H015kg25[F0UJe0U:D0UJe0U:D0TYB0SW>0QS60PaS0PQ2
10aS5PQ210aS20Q210aS0Q240QS611cW0QBU11240PaS9PQ217oo0P000Goo0003Ool01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9Nm`9JePiNm`IS60iW>AQ[
FPiW>BIS609Nm`9S60A[FP9W>@9S60MNm`QJeP9F]@9BU09F]@9BU09:DP8mk`8Li`8<H`88@P@<HaH8
@P@<H`@8@P8<H`88@P@<H`8@Q08DY@@HaP8DY@8@Q0@<HbH8@PEoo`40005oo`000goo00D007ooOomo
o`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2G_L2F]H>G_L6HaP>IcTH
JeX>IcTVHaP2G_L2HaP4JeX2IcT2HaP7G_L8F]H2E[D2DY@2E[D2DY@2BU82?Nl27>L236<2248436<F
248436<4248236<2248436<248@25:D46<H25:D248@436<V2485Ool10001Ool0009oo`8000Aoo`80
00Aoo`8000Eoo`03001oogoo009oo`AJePaNm`QS60aW>AY[FPiW>BIS609Nm`9S609W>@A[FP9S60MN
m`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaH8@P@<H`@8@P8<H`88@P@<H`@@Q0@DY@8@
Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo15[F35kg26<H36Li6V]J3VLi9V<H0Ukg0V<H
0VLi16]J0V<H1ekg25[F0UJe0U:D0UJe0U:D0Tic0T8@0RDY0PaS0PQ210aS5PQ210aS10Q20PaS0PQ2
10aS112411BU0Q241PaS9PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H>G_L8HaP<IcTLJeX@
IcTVHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2CW<2AS42:DX248@2248436<2248236<J2482
36<4248236<448@45:D248@636<V2485Ool10001Ool001Eoo`03001oogoo009oo`9JePiNm`QS60aW
>Aa[FQ1W>BIS609W>@A[FP=S60INm`QJeP9F]@9BU09F]@9BU09>L`96<@8YBP8@Q088@P@<H`88@P8<
HaX8@P8<H`@8@P8<H`@@Q0@DY@8@Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45kg1V<H
36Li46]J0Vmk36]J46Li76<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS
0PQ20PaS10Q20PaS50Q210aS0PQ210aS212420aS10Q220@Q60Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool@G_L6HaP<IcT@JeX2Kg/<JeX@IcTLHaP2G_L:HaP4IcT3HaP6G_L:F]H4E[D2DY@2CW<2AS42
;F/25:D2248436<2248236<4248236<D248436<2248436<848@836<42488124H2485Ool10001Ool0
01Eoo`03001oogoo009ooa1Nm`AS60iW>@I[FPA_N`A[FPI_N`Y[FQ9W>@QS609W>B=S60INm`AJeP9N
m`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<H`88@P8<H`@8@P8<Ha@8@P@<H`88@P@<H`H@Q0H<H`P8
@PP48@@8@PX48@X8@PEoo`40005oo`005Goo0P000goo45kg16<H3VLi1V]J16mk16]J1Vmk2V]J4VLi
26<H0VLi8f<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0TYB0S6<0QS60PQ210aS0PQ20PaS10Q20PaS50Q2
10aS0PQ210aS1Q241PaS20Q220@Q10Q22P@Q2PQ217oo0P000Goo000EOol00`00Oomoo`02Ool>G_L6
HaP<IcT4JeXBKg/:JeXLIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2CW<2=Jd26<H636<2248236<J2484
36<2248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`iNm`IS60aW>@A[
FQ9_N`Y[FQaW>B=S60INm`AJeP9Nm`AJePAF]@ABU09>L`8e[@8HaPH<H`88@P8<HaX8@P@<H`88@Q0<
H`P8@PP48@@8@P`48@P8@PEoo`40005oo`005Goo00<007ooOol00Woo3Ukg1V<H2VLi1V]J56mk26]J
76Li56<H15kg3F<H15kg15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21PaS4PQ20PaS1PQ210aS0PQ2
40aS20Q220@Q10Q230@Q20Q21Goo0@000Goo000EOol00`00Oomoo`02Ool>G_L6HaP:IcT6JeXDKg/8
JeXLIcTDHaP4G_L=HaP4G_L4F]H2G_L8F]H4DY@2CW<2>Lh26<H236<2248636<B248236<6248436<2
248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`YNm`QS60YW>@I[FPI_
N`IcW0Q_N`Y[FQ1W>C5S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20P<H`88@P8<H``8@PH<H`X8
@Q8<H`H8@Ph48@P8@PP48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo2Ukg26<H2VLi1V]J1Vmk
1W>L26mk2V]J46Li<F<H15kg1U[F0Ukg15[F15Je0U:D0TYB0Sg_0R4820aS0PQ20PaS30Q21PaS2PQ2
4PaS1PQ23P@Q20Q220@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool:G_L6HaP<IcT6JeX4Kg/:
Li`2Kg/2Li`4Kg/:JeX>IcTaHaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P836<2248236<@2482
36<:248D36<4248B1242248:12442485Ool10001Ool001Eoo`03001oogoo009oo`YNm`IS60aW>@I[
FPA_N`YcW09_N`9cW0A_N`Y[FPiW>C5S60INm`AJeP9Nm`AJePAF]@9BU09>L`92408Q20P<H`88@P8<
Ha08@P8<H`X8@Q@<H`@8@Q848@88@PX48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg26<H
2VLi1V]J16mk4W>L0Vmk0V]J0Vmk1V]J3VLi<F<H2Ukg1U[F1UJe0Tic0T8@0RDY30aS70Q250aS0PQ2
80@Q10Q21Goo0@000Goo000EOol20003Ool8G_L8HaP:IcT6JeX4Kg/BLi`2Kg/2JeX2Kg/6JeX>IcTa
HaP:G_L6F]H6E[D2CW<2@Q029BT<36<L248D36<2248P12442484Ool20001Ool001Eoo`03001oogoo
009oo`QNm`IS60YW>@I[FPA_N`IcW0Ig_@IcW0Q_N`I[FQ1W>BmS60YNm`QJePAF]@9>L`96<@8YBP8@
Q0X<Ha88@P8<H`P8@Q8<H`@8@R048@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg1V<H2VLi
1V]J16mk1W>L1WNm1W>L26mk1V]J46Li;f<H2Ukg25[F15Je0Tic0THa0RU:0Q242PaS4PQ20PaS20Q2
4PaS10Q280@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6G_L8HaP8IcT8JeX4Kg/4Li`8Mkd6
Li`4Kg/2JeX2Kg/4JeXBIcT8HaP2IcT6HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX248@236<22486
36<B248236<8248636<4248636<6248T1245Ool10001Ool001Eoo`03001oogoo009oo`INm`QS60QW
>@Q[FPA_N`AcW0Qg_@IcW0A_N`9[FP9_N`A[FQ9W>@QS609W>@IS609W>AeS60aNm`IJePAF]@9>L`96
<@8YBP8@Q08<H`88@PH<Ha88@P8<H`P8@PH<H`@8@PH<H`H8@R@48@Eoo`40005oo`005Goo00<007oo
Ool00Woo1Ukg1V<H2VLi16]J1Vmk0W>L3WNm17>L16mk0V]J0Vmk16]J56Li16<H16Li86<H0VLi0f<H
35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L6HaP:IcT4JeX6Kg/2Li`>Mkd4Li`4Kg/2JeX2Kg/4JeXDIcT4HaP4IcTP
HaP2IcT3HaP<G_L6F]H4E[D2DY@2AS42:DX248@236<2248636<B248236<8248B36<4248T1245Ool1
0001Ool001Eoo`03001oogoo009oo`INm`AS60YW>@I[FPA_N`AcW09g_@YkgP9g_@IcW09_N`9[FP9_
N`I[FQYW>A1S609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88
@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`40005oo`005Goo00<007ooOol00Woo1Ukg16<H2VLi1V]J
16mk17>L0WNm2W_N0WNm1W>L0Vmk0V]J0Vmk1V]J6VLi46<H0VLi3V<H0VLi00=S65kgG_L035kg0U[F
0Ukg0U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L4HaP:IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`6Kg/6JeXLIcT>HaP2IcTA
HaP>G_L2F]H2G_L2F]H4E[D2DY@2BU82:DX236<22482124636<6248236<:248236<8248B36<4248T
1245Ool10001Ool001Eoo`8000=oo`INm`AS60YW>@A[FPA_N`AcW0Ag_@YkgPAg_@AcW0I_N`I[FQaW
>@iS609W>A5S60iNm`9JeP9Nm`9JePAF]@9BU09:DP8YBP8<H`88@P848@H<H`H8@P8<H`X8@P8<H`P8
@Q8<H`@8@R@48@Aoo`80005oo`005Goo00<007ooOol00Woo36<H1VLi1V]J0Vmk17>L17Nm17_N1Woo
17_N0WNm17>L16mk1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q20Q22PaS30Q21PaS1PQ2
30aS10Q290@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<HaP6IcT6JeX2Kg/4Li`4Mkd4Nmh6Ool4
Nmh2Mkd4Li`4Kg/6JeXLIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@21248248:36<<248636<6248<
36<4248T1245Ool10001Ool001Eoo`03001oogoo009oo`aS60IW>@A[FPA_N`9cW0Ag_@AkgPQoo`Ak
gP9g_@AcW0A_N`I[FQaW>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@H8@PX<HbH8@RH48@Eo
o`40005oo`005Goo00<007ooOol00Woo36<H1VLi16]J16mk0W>L17Nm17_N27oo17_N0WNm17>L16mk
1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240PQ20P@Q1PQ22PaS9PQ29P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool<HaP4IcT6JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`6Kg/4JeXPIcT:HaP2
IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224841248248636<V248V1245Ool10001Ool001Eoo`03
001oogoo009oo`aS60AW>@I[FP9_N`AcW09g_@AkgPYoo`AkgP9g_@AcW0I_N`A[FR1W>@YS609W>A=S
60iNm`IJePAF]@9BU096<@8]J`8DY@88@P@48@P8@PH<HbH8@RH48@Eoo`40005oo`005Goo00<007oo
Ool00Woo26<H26Li16]J16mk0W>L0WNm17_N3Woo0W_N0WNm17>L1Vmk16]J8VLi7f<H35kg1U[F15Je
0U:D0THa0Re[0QBU0PQ210@Q0PQ20P@Q1PQ210aS80Q20PaS10Q29P@Q1Goo0@000Goo00000goo0000
000300000goo000000020003Ool20005Ool00`00Oomoo`02Ool8HaP8IcT4JeX4Kg/2Li`2Mkd4Nmh>
Ool2Nmh2Mkd4Li`6Kg/4JeXRIcTOHaP<G_L6F]H4E[D2DY@2AS42;F/25:D224841242248212462484
36<P248236<4248V1245Ool10001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<0
07ooOol00Woo1V<H26Li1V]J0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F
15Je0U:D0THa0Re[0QBU0PaS0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q1Goo0@00
0Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000goo1V<H26Li1V]J
0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F15Je0U:D0THa0Re[0QBU0PaS
0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q17oo0P000Goo0003Ool00`00Oomoo`03
Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li1V]J16mk0W>L0WNm
0W_N4Woo17_N0WNm0W>L1Vmk1V]J6VLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS60PaS0PQ20P@Q0PQ2
0P@Q0PQ210@Q:0Q2:0@Q1Goo0@000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo009oo`03001oogoo009oo`AS60QW>@I[FPA_N`9cW09g_@9kgQ9oo`AkgP9g_@9cW0I_N`I[
FQYW>BMS60QNm`QJePAF]@9BU09:DP8aS08HaP8<H`88@P848@88@P848@88@P@48BP8@RP48@Eoo`40
005oo`000Woo0P0017oo0P0017oo0P001Goo00<007ooOol00Woo16<H1VLi1V]J16mk0W>L17Nm0W_N
57oo0W_N0WNm0W>L1Vmk1V]J76Li2V<H16Li3V<H0Ukg0f<H0Ukg16<H1Ukg25[F15Je0U:D0TYB0SF]
0R480Q240PQ20P@Q0PQ20P@Q0PQ210@Q0PQ20P@Q40Q210aS40Q2:0@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool4HaP6IcT6JeX4Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`6Kg/6JeXLIcT:HaP4IcT>HaP2
G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@22482124224821242248412422482124@
248436<@248X1245Ool10001Ool001Eoo`03001oogoo009oo`9S60IW>@I[FPA_N`AcW09g_@AkgQAo
o`9kgP9g_@9cW0I_N`I[FRYW>@iS60MNm`AS60INm`QJePAF]@9BU09:DP8mk`8U:@8DY@88@P848@H8
@P@48@88@PP48@X8@PP<H``8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo0V<H1VLi1V]J16mk
17>L0WNm17_N57oo0W_N0WNm0W>L1Vmk1V]J:VLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY
0QBU0PQ20P@Q1PQ210@Q0PQ220@Q2PQ220aS30Q2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool8
IcT8JeX2Kg/2Li`4Mkd4NmhBOol4Nmh2Mkd2Li`2Kg/2JeX2Kg/8JeXRIcTHHaP=G_L8F]H4E[D2CW<2
AS42@Q02<H`27>L236<624841242248:1246248436<6248236<4248236<6248X1245Ool10001Ool0
01Eoo`03001oogoo009oo`QW>@Q[FP9_N`9cW0Ag_@AkgQ9oo`AkgP9g_@9cW09_N`9[FP9_N`Q[FR9W
>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`H8@P@48@88@PX48@H8@P@<H`H8@P8<H`@8@P8<
H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li1V]J16mk0W>L0WNm17_N57oo0W_N17Nm
0W>L0Vmk0V]J16mk26]J86Li66<H3Ekg25[F0UJe0U:D0Tic14Ha0SW>0RDY0QBU1PQ240@Q5PQ20PaS
1PQ2:0@Q1Goo0@000Goo000EOol20003Ool8IcT6JeX4Kg/2Li`2Mkd4NmhDOol2Nmh4Mkd2Li`2Kg/2
JeX4Kg/8JeXPIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D6248@124F248236<6248X1244
Ool20001Ool001Eoo`03001oogoo009oo`QW>@A[FPI_N`9cW09g_@AkgQAoo`9kgPAg_@9cW09_N`9[
FPA_N`i[FP9W>@A[FQAW>AQS60eNm`9JeP9Nm`AJeP9F]@9BU09>L`A6<@8mk`8aS08Li`8<H`@8@Q@4
8A88@P8<H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li16]J1Vmk0W>L0WNm17_N57oo
0W_N17Nm0W>L0Vmk0V]J16mk3V]J0VLi16]J56Li66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha0Sg_
0S6<0QcW0PaS10Q250@Q4PQ20PaS1PQ2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4
Kg/4Li`2Mkd4NmhDOol2Nmh4Mkd2Li`8Kg/FJeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2
BU82AS44@Q02>Lh29BT248@4248F124<248636<4248Z1245Ool10001Ool001Eoo`03001oogoo009o
o`IW>@I[FPA_N`AcW09g_@AkgQAoo`9kgPAg_@9cW0Q_NaI[FQ9W>@QS60AW>@eS60aNm`9JePANm`9J
eP9F]@9BU09:DP96<@A2408icP8U:@8@Q0@8@QH48@`8@PH<H`@8@RX48@Eoo`40005oo`005Goo00<0
07ooOol00Woo1VLi1V]J16mk17>L0WNm0W_N57oo17_N17Nm0W>L1Vmk26]J26Li26]J4VLi26<H16Li
3F<H35kg0U[F15kg0U[F0UJe0U:D0TYB0THa0Sg_0THa0T8@0S6<0QS60PaS10Q26P@Q40Q2:P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4Kg/4Li`2Mkd2NmhDOol4Nmh4Mkd2Li`6Kg/8JeX8
IcT8JeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`26<H236<4
248J124@248Z1245Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0
ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool0
01Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[InverseFourier[compressedfSpec]], 
      Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
D9DACBBEBCBEBAB5B4B6B5B2B0AFACA8A5A4A19E9B9895908C8A8785848483807F7F7E7D
7E80817F7D7D7E7D7C79777574757572717273716F6D6D6B696867656160605F5A555351
4E4A443A2D1E130D0803020912191F24292D3033363A3D3F4144484A4B4D505251515254
55585C5F6163676A6C71777A797A85919597A7C3
9CA7A29895989794929494918F8E8C89868584827F7D7B78757372716F6F706F6E6D6C6D
6F70706E6D6E706F6C68666667686866666767646261615F5D5D5D5B585757554F4A4848
46413B33281E191614151B252D32363A3D3F414446484B4D4E5052545556585A5958595B
5C5D60646565676B6F7172737477818A8A7E7885
748A887E7D8384807F82827F7D7E7E7B797A7A78757473706E6E6E6C6B6C6E6D6B6A6B6D
6E6E6E6D6D6F706E696565686A6A6A6968696866656464636162625F5D5D5D59514D4F52
4F4A454038302C29282A313A3E3F42444646484B4C4D4F51515153565656585A5957585A
5B5B5D60605F6167696665686E7275756A503C4E
758B867B7C83837E7D81817E7E807F7D7B7D7D7A7777767372727170707274716E6F7172
72727272737575706B696C6F7171706E6E6E6D6C6B6B6A68686867656364635C55555A5C
5853504B443B36333234393F404041444546484A4B4B4E4F4E4F5154545355575655575A
5A58595D5D5B5E63625E5F696F6B625743231B45
7F8F887D7E83827D7D81827F7F80807D7B7C7B787777767473737372727474716F707272
727272737576746E6A6B6F7272716F6F6E6E6D6C6C6B6968686967656566625A55595E5E
5955534E463E383533353A3D3D3E414345474A4C4B4C4E4F4E4F53555454565959585A5D
5B595B5F5E5D5F626261676F6C5B4636220E1F52
7B8A8278787D7C78787C7D7A797A7A777576767473747472717171717070706E6D6E6F70
6F6F70727473706B696B6F71706D6D6D6D6C6B6B6A6867676868666667655E57575C605E
5957555047403B3836393D40414346494B4E50504F4F51515154585957585B5E5E5D5F5F
5D5B5E61605D606567686B695A3E251A130E2554
75847D737378787474787976757676747374757474747472717172706F6F706E6D6E7070
6E6E717474726E6B6A6C70716F6D6E6F6E6C6C6D6C69696B6C6A696B6A655D595D636461
5E5C5A544D46413E3D3F4346484A4D4F525353525151535455585B5B5A5B5E60605F5F5E
5D5C5E605E5C61696B675E4F381B0A0E100E234F
79877F74747A797576797A7777797977767878777677767472737270707172706E707170
6E6F747676726F6C6C6F737371717272706F71716E6C6F71706E6E6F6C645E5F65696865
63615E59524B45424143474A4B4D4F52535352505051535557595B5B5A5B5E605F5D5D5D
5C5C5C5D5D60676B6656412C1604040F120E2351
7D8A8175767B7B76777A7B79797A7A787778787776767573717271707071716F6E70706F
6E71767775716E6C6E72757472737573707173726F6F7273706E70706A615E63696A6866
64615E59524B45434345484B4D4E50525351505051535658595A5C5C5C5C5F605F5D5D5E
5D5C5D6064686A64533920120903091313102857
7B877F7373797975757879777678777473747675747372706F70706F6F706F6E6E6F706F
6F727576746F6C6D7074747373757572717273726F7072716E6D706E665F60676A696764
63615E59534C484647494C4F505152545453525456585A5B5C5D5E5F5E5F606261606061
606064696C6A614F361C0C0A09060A1212112A57
78857C71717777737377777574757572717476757272727170707170707070706F707170
70727677736E6D70737474757676757372747472717272706E70706C6461656B6C696766
6564615D57524E4D4D4F515455555657575757595A5C5D5E5E5F60616060616464626263
65676B6E6A5D48301A0A06090804071011112854
7B887E727379797474787876757676737477797673747574727374727172737271727271
70737777726F7073757677797978767575757574747373717172716B65656B6F6E6B6A6B
6B6966625D58545252525457575657595959595B5C5C5D5E5E6061616060626565626367
6B6D6C66594228140A0505060402071011102956
808B8174757A7A7575797A7876777675767978747375767473747472717373727171716F
707478767170727577787A7B79777676757676757473737372726F6966696F716F6C6D6F
6E6B6865605A565452525456565657595A59595B5C5C5D5E5F606161606063666564686E
716C61523D230F09080402040504091213132D5B
808B8073747A7A7575787A7774757575767675737475757472737271717273717070706F
7175777571717477797A7A7977777676757576757372727372706C69696D71726F6E7071
6E6B6866615B5754525255585858595B5C5B5B5C5D5E5E606161626161636566676A7174
6F604C37221008090802010607050A1314152E5C
808A7F73747B7A7574787975727477767575757575767674737373727273747371717272
72747574727377797A797878787876757576767573737473726F6D6C6F72747371717271
6E6B6A69645E5A575555585B5B5B5D5E5E5D5D5F5F5F606162626263646566696E747671
6149311F120A0708050001060704091315152E5B
848E8376787E7C76767A7A7675797B787677797877787876757576757475767472727371
707275757475797B7977797B7A7877767777777776767675737171727475757473737472
6F6E6F6D68615C5A58595C5F5F5E5E60605E5E5F605F6062636364656665686F77797160
482E1C120C0805050200020606040B151616305F
8992867A7B807D77787C7C78787C7C7876787A7978797A7776767775747575737171706E
6F73767675787C7B79797C7D7B78787979797A7A78787776737374767675757575757473
727273706A635E5B5A5B5E61605E5E60605E5E5F606061646565666767686E787C736046
2E1B120E0B0604040301030808070E1818193565
8A93877A7A7E7C78797D7C79797A797675787A79787A7A777576767473737371706F6F70
71747677797C7E7C7B7C7E7D7A797B7C7B7B7C7B79787775747578787675767776767676
757575716A645F5D5B5D6162605E5F61605E5F62636365676868686A6B70787E7863472E
1E140F0D09050405050305090A0910191A1C3866
89928679797F7E79797C7C7877797877777B7C7B7A7B7A77757676747273747372727474
7373757A7E7F7E7D7C7D7C7C7C7D7E7D7C7C7C7B7977767576797A797777787978787979
787775716B65625F5E606363605F6163626163666767696B6B6A6B6E73797D79674B2F1F
18120D0A080504050403050A0A090F191B1D3865
8C95897C7C827F79797D7D7A797B7C7B7B7E7F7C7B7B7A77767677747375777674757571
6C6C757D807F7D7C7B7B7C7E80807E7C7B7C7C7B797776777A7C7C7A79797A7A7A7A7A7A
787775726D68646261636564616163656565676A69696A6C6C6B6E757B7C76674E321F18
150E080808040203030205090A09101A1C1E3968
90998C7F7F837F797B80807C7C7F7F7D7C7D7D7A797A7977767777757477787573716D65
616A7881817E7D7D7C7D8082827F7D7C7C7C7D7C7A77787B7D7E7D7B7A7A7B7B7B7B7A79
787776736F6A6664646465646263666767686A6B6A6A6B6D6D6E747C7D75644E36211714
10090608070301030403060B0C0B131D1F213D6C
929A8D7F7E827F7C7E83827D7D7E7D7A797B7B7A7A7B7B7977787774747574716D69625D
627281878583828180828484818080807F7E7F7E7B797B7F807E7D7D7C7C7C7D7C7B7B7A
7A7A7976726D6A67666666666667696A6A6A6C6C6C6B6D6F70747B7E77654E3826191412
0E080709080302050605090F0F0E16212325406F
929A8D7F7F8383818284827D7C7D7D7B7C7F818180807E7B797876747373716D69646162
6D7E8B908E8A888684838383848686837F7F817F7C7C7F81818080807E7E7F7F7F7E7E7E
7E7E7D7A76716D6B6969696A6A6B6C6D6D6D6E6F6F6F7073767B7F7A6A523B2B1F171312
0E0A0A0B0804040809090D12111019242526406F
949D9082828888848284837F7F8284838588898683807D7975747371706F6E6A66636366
72849297938C86827F7E81878C8C867E7C7E807F7C7D8183838282818080818180808081
817F7E7C78736F6D6C6B6B6C6C6C6D6E6F707171717173787D807D705A412E231C161312
0F0B0B0B0805060A0B0B0E1212121B252525406F
969F9284848A89828185868485888A888787857F7975716D6A6A6A69676766635E5C5B60
7087989A90827B78787C868F90877A74777D7F7E7C7E8183838281817F7F80807F7F8080
7F7E7D7C77736F6D6B6A6B6C6D6C6D6F717172727172767D817F74604832231D1A161311
0E0B09090705070B0C0B0E1213131C2524254171
959E908181868580818789868484837E7975706963615F5C5B5D5E5D5B5B5A56514E5160
7C96A29A867773767C86919389776E717A80807E7E7F828382807F7F7E7D7D7E7D7D7D7D
7D7D7D7B7773706E6B6A6B6D6D6D6E717272717272767C828177644D36241B1A1814110F
0C0806080806070B0B0B0E1213131A2323254170
919A8C7D7E8585828387847C76736F67605C58545252535354575755535454504D52627E
9CAFAD9980767B838C94968D7A6D707B8385848281828383817F7F7E7D7D7D7E7E7D7D7E
7F80807E7A7672706D6C6E70706F707373727274777C82837B69513A271B181918120E0C
090605080806060A0B0A0D121311182223243F6D
929A8D80828988827F7D7569615E5A534F50505051545657595B5A58595C5D5C61718AA6
BABFB095807F899296958E8072727D878A8886848383848482808081807F808181818284
848484827E797572706F717372717275757475797E82847E6E573E2A1F19191916100B0A
0705060A0905060A0C0B0E121211192323233E6E
969F9285858984786F685F5551535250505457585A5D606163646363676C6F727E92A9BA
C1BAA58C808590938F888078767D878A8886858583838484838283838282838585848687
878685837F7A767472717374727274777877797F848580735D442E221D1A1817130D0908
0707090B0905070D0E0C0E1313121A2424244171
98A192817C7B71625854504D50555756575C5F5F616467686A6B6C6F74797D8491A2AEB4
B1A592817C838A88807B7A7B7D8286868484858482838585838384858383858786858687
868585837E7A7775737273747474787A79797D84878276634B3426201D181514100A0809
09090A0B0806090F0F0C0F1414131A2424254273
9499856F67645B4F4C505253565B5C5A5B60636465696D6E6F7174787C80858C969EA1A1
9C92847A7A81837F7B7D8182828284858687878584858787858586868485878785848585
858484837F7B79777473757677787A7B7A7C8288867B68523C2A211E1A1412110E09080A
0C0A0A0A08070A0E0D0B0E141311192323244272
8A89725B5658534F52595B5A5C5E5E5D5F65696A6C71747575777B7E80848A8E92949697
948D827D7F838482838789868485898A8B8B8A8887888988868688878686878785848586
86868785827F7D7A7675777A7A7A7B7B7C80878A8270594230231E1A161110100C08090C
0C0A080908070A0D0C0A0E12111019222122406C
7E7A6454565D5C595D61605D5E626263686F727274797C7B7A7D808284898D8E8F929698
958E87848688898A8C8D8B87888B8E8E8D8D8C8A89898988878889898787888785868889
8989898885827F7C78777A7C7C7A7A7C80878B8879614834271E1A1713100F0E0B090B0E
0C09080909080A0D0C0A0E12111119211F223E66
7573635A606563606062616063676A6C717678787A7E7F7E7E818486888C8E8F90959999
948F8B8A8A8B8C8D8D8C8A8B8D8F8F8D8C8C8C8A88888989898A8B898888888887888A8B
8B8B8C8B8884807C79797C7D7C7A7C81888D8C816B50392A211B181613100E0E0C0B0D0E
0C09080A09080A0D0C0B0E121111181F1E213B5F
72756A626568655F5F6264666A6E7173777A7B7C7E8181808285888A8B8E8F9193979897
93908E8C8B8C8E8E8D8D8E8F908E8C8C8D8E8D8A888A8B8C8C8C8C8A89898A8A8A8B8C8C
8D8D8E8D8985817E7B7C7E7F7D7D81898F9088755B402E241F1A1716130F0E0E0D0D0D0E
0B08080A09080A0C0C0B0D111110171E1E20375A
757A6F656668656163696D6E717577787B7E808183858586878A8C8D8E90929395969797
9594928F8D8E909090919292908D8C8E90908E8B8B8E8F908F8E8D8C8B8B8C8C8C8D8E8F
8F90908E8B8784817E7E808180818890938D7D654A3327211D181614110E0E0F0F0D0D0D
0B08080A0A080A0C0B0A0D111010161E1E20365A
7A7F7267686C6A686B727575767A7D7E8084868687898B8B8C8E9090919394959597999A
9997949190929394949493918F8E909293918F8E8F9192918F8E8D8D8C8D8E8E8E8E9091
9191918F8C8986838080828383868E9492856F553C2B221F1B171514110F0F100F0D0D0D
0B08090B0B090A0D0C0B0E111111181F1F21385E
7B8073696B71706E717779787A7E8283848789898A8C8D8D8D8F91919293949595989B9B
9997959493939595949392919090929393919090919291908E8E8E8E8E8F908F8F909192
929292908E8B878482828485878C93958D7960463226201D1A171514121010100F0D0D0D
0B090A0C0C0A0B0E0D0C0F131313192020223A60
7A80756C6F747371747A7C7B7D828585858889898A8D8D8D8D9091919192949596989A99
98989795939394949392929392929394939292929292918F8F8F90909090919190919393
93929292908C8886848486888C929793846B513B2C231E1C1A171614121010100F0E0E0E
0C0A0B0D0C0A0C0E0E0C0F13131218202122395E
7B82786F71767674777D7F7E8084868585888B8B8C8E8F8F8F9192929193959697989A9B
9B9B9A979494959594949595949394959594939393929291919292929292929191929495
94939393918D8A898887888C9398978C775D443328211D1B19161514110F0F100F0E0D0D
0C0A0B0C0C0A0B0E0D0C0F13131218202122385E
7E867C72747A7A797C82838182868887888C8F8E8E9192929293949394969898999B9D9F
9F9E9C989595979796969796949496979694949494939393939393939292929192939595
93929393918F8E8D8A878A92999A917F674E3A2D251F1B1917151413110F0F100F0D0D0D
0C0A0B0C0C0A0B0E0E0D0F131313192121223960
828A8076797F7F7D8084858385898B8B8D909190919495949394959596989A999A9DA0A1
9F9D9A979597989896969796959597979594949595949393939292929291919292949593
919293949392918F89878E989D9686705842332A231D19181715141311100F10100E0D0E
0D0B0B0D0D0B0C0F0F0E101415141A2223243A62
848D847A7C82838082868786888C8F8F8F91929293959694939497979898999A9C9FA09F
9D9B9A979697989795969797959596969594969695939393929292929292929394949392
919396979796948F898A959E9C8E78614D3C3028211A18181816141412101011100F0E0F
0E0C0C0E0E0C0D10100E111515141A2324243B64
8892887D8086868385898A898B8F918F8F919394959696949496999997989A9C9D9E9E9D
9D9D9B999798989797989998979697979797989795939494949394949494949494949393
94979A9B9B99958E8B919CA097826A5646382D251E1A191A1A17151412101012110F0F0F
0E0C0D0F0E0C0D10100F111616151B2425253C66
8C968B8183898986888C8D8C8D90918F8F9396969697969596999A9997999C9D9E9E9E9F
9F9F9D9B99999999999A9B9A989898999999989795949595959495959594949494949495
989A9C9D9C99948F8F969F9E8E765F4F42352A221D1A1A1B1916141412101012110F0F10
0F0D0D0F0F0D0E111110121717161D2626263E6A
8F998E83858B8B88898D8E8C8D90918F919598979697979697999A98979A9D9E9D9E9FA0
A09F9D9B9999999A9A9A9B9A989798999897969695959595949495959494949494959697
999A9C9C9B989490929A9F98836A56493E3126201D1B1A1A191614141311111212100F10
0F0D0E10100E0F121210131818171E262728406D
909A8F84868C8B87888C8D8C8D909191939798969596969697989897979A9D9D9C9D9FA0
9F9E9D9A9898999A999A9A99969597989796959696959494949494949494949595969797
97999B9C9C999492969D9D91795F4F45392C23201E1B1A1A181615151311111312101011
100E0F11100E0F131211141818171E272828416D
929B9085868C8B87888D8E8D8E919392949797959495969697989897979A9D9D9C9D9F9F
9E9E9D9A9898999A9A9A9997959597989796979897959495959494959696959696969696
96999C9E9D9A95959A9F9B886E564A41352822201E1A191A181614141310111312101011
100E0F11100E0F131211141818171E272828416E
949D9286878D8C898A8F918F8F929493949797959496989898989897989C9E9D9C9EA0A0
9F9E9D9B98989A9B9A99999796979A9B9998999997959596969595979796959595959495
979A9D9F9E9A96999FA0957D624F453C302622201D1919191715141412101112110F1011
0F0E0F11100E10131211141918181F2828294370
959F9388898F8E8B8D91928F8F9395949597979494979A99989797989A9D9E9D9C9FA1A0
9F9E9D9B98999B9B9A99999998999C9B9998999996949596949395979694939394939395
989A9D9F9D99989DA29D8A6F574941382D2522201C191818161414141210111211101011
100E1012110F1113131215191A192029292A4572
96A095898A908F8C8D91918F909496959596969495999A98969698999B9D9D9C9D9FA19F
9E9E9D9B989A9C9B9A999A9A999A9B9A9797989794939494929295969491919293929496
98999C9E9C999BA1A2957C6250463E352B24211F1B181717161414141210111212101111
100F1114131011141413161A1A1920292A2B4573
98A2978A8B91908D8E9192909296989695969595979A9A979597999B9B9C9D9D9EA0A09F
9E9F9E9B999B9C9B9A9A9B9998999A989595979693929293929395959290919393939596
97999D9F9D9B9FA49F8B705A4D453C312923211E1A171717171513131211111212111111
10101315141111151413161B1A1A212A2B2B4674
9BA5988C8C92928E8F9394929498989694959696989A999796999B9C9C9C9D9E9FA0A0A0
A0A19F9C9A9B9C9B99999998979899979596979693919393939495949191939493939596
979A9EA09D9DA3A59A8267544B42382E2723201D1A171717161413141312111312111012
12121416141112151514171B1B1B222B2B2C4877
9CA6998C8D939390919495949598989594969797989A9997979A9C9C9B9C9EA0A0A0A0A1
A1A09E9B9A9A9A9998989897989998969597979592919393939393939192939392939596
979B9F9F9DA0A7A594775E50483E332B27231F1D1A171616151314151512111212111114
15151616141213161614171C1C1C232C2C2E4978
9CA69A8C8E95959191959593949797959495979898999997989B9C9A9A9C9FA09F9F9FA0
9F9E9C999898989897979899999897959597969391929392919293939292929292949596
979B9E9D9EA5AAA38B6C554C453A302B27231F1C19161415161516171511111313131417
18161617151213161615181D1D1C232C2D2E4977
9DA79A8D8F97979291949593949697949395979898999898989A9B99999C9F9F9E9E9FA0
9F9D9B999898989898999999989796959695949291929291919294949392929293959595
979B9D9EA2AAAC9E7F60504B44382F2B28221E1C18141416171718171411121515151719
18151517161213161615181D1D1B232D2D2D4878
A0A99C8F9299989291949594949797949396999998989899999A99999A9EA09F9E9EA0A1
9F9D9B9A9999999A99999999979695959594939392929191929495949392929395959494
979B9DA0A7AEAA9473584E4B42362E2B27211D1B17131417191818171412141717161819
17141618151213161615181D1D1C242D2D2D4A7B
A1AA9D9193999892909496949597969493979998979899999898999A9C9FA09F9E9FA1A1
9E9C9B9A9998999999989898979595949494949493919192949494939291919394939293
979A9DA2ABAFA48968534E4A3F332C2A251F1C19161214181A1A19181514161818171818
17151718151213171615191D1D1D252E2D2F4D7D
A1AA9E92939897919094969594969593939698979798999897979A9B9D9FA09F9E9FA09F
9C9A9B9A9897989897969798969494949494959492909192939392929190919393919193
979A9DA5ADAD9C7E60514D473B2F2B29241E1B181411141B1E1D1B191716171818171818
17161818151213171716191E1E1D252E2F324E7D
A1AB9F91929897919094979594959593939698989798989796989C9D9E9FA09F9E9F9F9D
9B9A9B9A97979898979798989694939495959593918F9193939292929190919393919194
989A9FA8AFAA94755B4F4B44382E2B29241D1A171312192124211C1A1816161718181819
18171718151213171716191E1E1E252F30324D7C
A4AD9F92939A989190969895949596939396999997989897989B9E9E9E9FA09F9E9F9F9D
9B9B9C9A9898999998989998959494959595949390909294939292939291939492919296
999BA2ABAFA58C6D574E4A41362F2D29221C19171417212928201A191714141719181819
18171717141113171816191E1F1E252F30314D7D
A5AEA093959A9790919799959395969393979A999797999A9B9D9F9F9FA0A09F9E9F9E9C
9B9B9C9A9898999998979897959495959594949291919393929293939392939391909396
989BA3ACAD9E8366534D494036302C28211C1918181F282C261C17171513141819181718
17161717141113181816191F1F1E263030314F80
A5ADA09495999691939898949395959394989A9896989B9B9B9D9E9F9E9E9F9E9D9D9D9B
9A9B9B9A989798989796979795949494959493929292939291929393929191918F909395
979BA4ACA9977B60524D4940362F2B26211D1B1B1F252A28201714151413151819171617
171717171311141818161A1F1E1E263031345281
A4ADA19594989692949897939395959394989A9897999B9B9A9C9E9D9C9C9E9D9C9B9B9A
9A9B9C9A97979898979697979493939595949393929191919192939391908F8F8F909394
969BA5ACA690745D524E483F352E2926211E1D1F222525211A1413151413141717161517
181717161311141818171A1E1F1F273133365280
A5AFA39594999894949797949394949395999A9897999A99999C9D9C9B9D9E9D9C9B9C9B
9B9C9C9A979798989797979693939596959393929190909292929291908E8E8E8F909294
969DA7ABA18A6E5A524E473C322C2825211E1E1F2121201D171313151513141617161618
191817151312151919171A1F2021293436375280
A6B1A495949A9A95939696939293949496999A9896989A9A9A9C9D9C9D9F9F9D9C9C9D9C
9B9C9C9996979898969696959393959593929292908F9192929190908E8D8D8E8F909293
969EA7A99B826858524D4439302B2724201E1E1E1E1E1E1B16131416151314181917171A
1B1916151414171A1A181C2123232B3536375180
A7B1A394949A9A9392959693919395959799999796989B9B9B9C9D9E9F9F9D9C9C9D9C9A
9A9B9B9896969796959596959393949291919291908F9191908F8F8E8D8C8D8E8F909193
969EA6A4947A6358534C41362F2A2724211E1D1D1E1E1D1B161416181613161A1A17181C
1D1916161616171A1B1A1D2324242C3536365080
A7B1A393949B999392969692919497979798999796999D9D9B9C9E9F9D9B9B9B9C9C9A98
999B9B9896969696959696959392919190929392908F908F8E8E8F8E8D8D8E8F8F909292
959DA4A08E74625A544A3E352F2A2624221F1D1D1E1E1C1A171618191615171B1A171A1E
1D1916171816171B1B1A1D2324242B3535355081
A9B2A394959C9B93929797939296989797989997979A9D9C9B9C9E9D9A989A9C9C9B9999
9B9D9B9895969797969696939190919192939392908E8E8E8E8F8F8F8D8E8F8F8F919191
959DA39D8972635D54473B332E292625221E1C1E1E1D1B1A191819191715181A1A181B1F
1D1817181816171B1C1A1D2425252C3536365182
A9B2A394979E9B93929696939296989696989896979A9D9C9A9C9C9A97999C9E9D9B9A9B
9D9D9A97959697979695949290919293949494918F8E8E8F9090908E8E8E8F8F8F909090
959EA2998570655D524338322D282625211D1C1E1E1C1C1C1B1919191716181B1B1A1C1F
1D1817191816181D1D1B1F2627262C3636365283
A9B1A295979D9991919595929195979695979795969A9D9C9A9A9B99999C9FA09D9B9B9C
9C9B9996959697969594939291929494949493908E8E8F90908F8F8E8E8E8E8E8E8F8F90
969FA1968270655B4D3E36322D272624201C1C1F1F1E1E1E1C19191A1816191C1B1A1D20
1E19181A1916191E1E1C202727252B3636365283
A8B0A295979B9791919595919195979695969695979C9E9C999A9B9B9C9EA09F9C9A9A9C
9B9A98969696969695949493939394949493918F8E8E8F8F8F8E8D8D8D8D8D8C8D8E8F91
979F9E927F6E6357483B35312C2726241F1C1E22211F1F1E1C191A1B1817191C1B1A1E20
1E19181A19171A1E1E1C212726242B3636355182
A8B1A396979B98929295959293979997959697989A9E9F9C999B9D9E9D9EA09E9B9A9B9C
9B9A98989696969796959493939393949392908F8E8E8E8E8E8E8D8D8D8D8C8C8E8F8F91
989E9C8E7B6C6053443934302B272624201E2123211F1E1E1B1A1B1B1817191B1B1B1F21
1E19181A19171A1F1E1D212625242C3636365283
A9B2A598989D99939295969495999A979597999A9C9E9E9B999C9F9E9D9E9F9E9B9B9D9D
9B99999896959798969392929292939393918F8F8E8D8D8E8E8D8D8D8E8D8C8D8F8F8E90
979C988977685C4F4238332F2B28272521202323211E1E1E1C1A1B1A1817191B1B1C2021
1D19191B1A181C201F1D212726252D3636375384
AAB3A698989D9991919597969699999695979A9A9C9D9D9A9A9D9F9D9C9E9F9E9C9C9D9B
9898989795959797939091929392929392908F8F8E8D8D8E8E8D8D8E8E8C8B8D8F8E8C8F
969A948573665A4D403833302C2A282622222323211F1F1E1C1B1B1B19181A1C1D1E2122
1E1A1B1C1B1A1D201F1E222727262D3637385484
AAB4A798989B9790919799979698989695979A9B9B9D9D9B9B9D9F9E9C9D9F9E9D9B9A98
969798969495969591909294939293939290908F8E8D8D8E8D8C8D8E8D8B8B8D8E8C8B8F
969890817164594C3F3734312E2B292623222323211F1F1E1D1B1B1B1A191A1C1E1F2222
1F1B1B1D1C1A1D201F1E222727252D3637385384
ACB5A798979B989193999B979598999695989B9B9B9D9E9C9B9D9F9D9C9D9F9E9B999797
979898969595969491929595939293949290908F8E8C8C8D8D8C8D8E8D8B8B8D8D8B8B90
96968D7E6F62574A3F3734322E2B292623222324211F1E1E1D1C1B1B1A191A1D1F212323
1F1B1B1D1C1A1C20201E222727262D3738385385
ADB6A798989C9993959A9A969598989695999C9B9B9D9D9B9A9C9E9C9A9C9F9D99979798
98989897959595949393959593929393918F8F8F8D8B8B8D8D8C8D8D8C8A8B8D8C8A8B90
9493887A6C6055483E3734322E2B282523222424211E1E1F1E1C1C1C1A191A1E20222323
1F1B1C1E1C1A1D21201F222828272E3838385486
ADB6A798989C9994959999959497979595999B9A999B9C9A999B9C9A9A9D9F9C98979899
989898969494959493939494929192928F8E8E8E8C8A8B8D8D8C8C8C8B8A8B8C8B898A8E
928E8476695E53473D3735332F2B282624232424211F20201F1C1C1C1B191B1E21222423
1F1C1D1F1D1B1E22211F232928272E3838385587
ACB5A798979B9993939898959496979595989998999B9C9A999A9C9C9C9E9E9B98989998
979798969494959493939494929192918F8E8F8E8B8A8C8E8D8B8B8C8C8A8A8B8A88898D
8F8B8174695E53473E393634302B282624242524212020211F1D1C1D1B1A1B1E21232423
201D1E1F1D1C1E222120242928272E3838395587
ADB6A797979B99939398999593969896959899999A9C9C9A999B9E9F9E9E9E9C99989998
989899979595959594959594929192918F8F8F8E8B8A8D8E8D8B8C8D8C8A898A8987898C
8E897F74695E52463E3937342F2B282624242525222020201F1D1D1D1C1A1B1E22252624
201D1E1F1E1C1E222120242928272F3939395687
AEB6A797979C999394999A959497999695989B9B9B9D9C9A9A9EA1A09E9E9E9D9A999999
989999979595959695959593919192918F8F8F8E8B8A8D8E8C8A8B8C8A8888898887888C
8C877D72675B50463E3936332E2A272625262625221F2021201D1D1D1C191B2025272624
201E1E201E1D1F23222124292928303A3A3A5688
AEB6A798989C9993959A9A959598989595999C9B9B9C9C9B9CA0A29F9D9E9F9D9A989999
989899979494969796949291909191908F8E8E8C8A8A8C8C8A8A8B8B898788898886878A
89837A6F64594F463E3935332F2A28282828282521202123211E1E1E1C1A1D2327282624
211F2021201E20242321252B2A29303A3A3A5688
AEB6A798989C9893969A999595989895969A9C9B9B9C9E9D9EA0A19F9D9E9F9D99989898
979899979595979795929191919191908F8E8E8C8A8B8C8C8A898A8B8988898987858688
8780776D635950473F393734302C2A2B2A29272522212324211E1E1E1C1B1F2528272625
23212122201E21242322262B2A28303A3A395688
AFB7A898989C9995979B9A9695989796979B9D9B9C9EA09F9EA1A19F9E9F9F9C98979898
989999989596989793919192929191918F8E8E8D8B8B8C8C8A8A8B8B8A89898886848587
857F766D645A51473F3B3936322E2C2C2B29272523232424211F1F1F1D1C202628272727
24222222201E21242322262B2A28313A3A3A5789
AFB7A899989D9B96979B9A9695979897999C9D9C9DA0A19E9EA0A19F9D9E9E9A97969899
999A9A989696979692909292929292918F8E8E8D8B8B8B8C8A8A8B8B8A88878684838485
837D756D645A5047403C3A37332F2D2C2A28272624232424221F1F201E1E212628282828
25222122201F21242422262B2A29313B3A3B588A
AFB7A899989D9B96979B9A9695979898999C9D9D9EA09F9D9EA0A19E9C9D9D999697999A
999A9A9896969694919092939392918F8E8E8E8D8A8A8B8B8A898A8A8886858583828384
827C746C63595049433E3B38342F2D2C2A29282725242425222020201F1E212528292A29
25212122211F22252423272C2B2A323B3B3B598A
AEB7A899989D9B96979A9A9594979999999C9D9E9FA09E9D9EA0A09D9C9D9C9997999A9A
9A9A9A9895959694919192949492908E8D8E8E8C8A8A8B8A89898A8A8785858583828383
807B746C635A534C45403D39342F2D2D2C2A292826252525232020201F1E2025292B2B29
25212224222022252523272C2B2A323B3B3B5889
B0B8A999989E9D98989B9A9695989B9B9A9DA0A0A09F9F9FA0A1A09E9E9E9D9B999A9B9B
9B9B9B98969697959292949694918F8E8F8F8E8C8B8B8B8A898A8B8A8886868684838382
807B766E655D564F47413D3A342F2E2E2D2A29282624252523201F201F1E1F252B2D2D2A
26232425222123262524282C2B2A323C3B3C598A
B1B9A9999AA09F9A999C9B97969B9D9C9B9FA1A19FA0A1A1A1A1A19F9E9E9E9C9B9B9C9C
9C9C9B99979797959293959693908F90908F8E8D8C8B8A8A8A8B8B8A8987868685838382
807D776F665E574F47403D3A34302F2F2D2A29282624242523202022201D20282F32302C
28252525232224272625282D2C2C333C3C3D5A8B
B0B8A99A9BA2A09A999C9B97979C9E9B9B9FA1A09FA0A1A1A1A1A1A09E9F9F9D9C9C9D9C
9B9B9B99969696949293969592909091908F8F8E8B898A8B8B8B8B8A8987868685838282
827E776F665F584F46403D3A3531302F2D2A2A292725262724212223211E212C3435312D
29262625242224272625292E2D2C333D3D3E5A8B
AFB8A99B9DA2A099989C9B97979B9D9B9B9FA1A09FA1A2A2A1A1A1A09F9F9F9E9C9C9C9C
9B9B9B9896969695939496959391919190908F8D8A898B8C8C8B8B8B8987878785838384
837E766E6760595047423F3B363231302E2B2B2A2726272725222324211E24303737312D
29262525242324272726292E2D2C333D3D3E598A
B1BAAB9D9EA3A099999C9B97979C9D9B9CA0A3A1A0A2A4A2A1A1A2A1A0A0A09E9C9C9D9C
9C9C9B9997979796949596969391919191918F8C8A8B8D8E8C8B8C8C8A88888786838384
837D766F69625B514843403C363231312E2C2B2A2826272725222323201E25323A38322D
29262525242324272726292E2D2C333D3D3D598A
B3BBAC9E9EA3A099989C9B97999D9F9D9EA3A5A2A1A3A4A2A0A2A3A2A0A0A19F9D9D9E9E
9D9D9C9997989897959597969390909192908E8C8B8D8E8D8C8C8D8D8A88888785838384
827D76706A635A514843403B353232312E2B2A2A2724262724212223201F29383F3C342E
2A2725262524252727272A2E2E2D343E3D3E5A8C
B2BBAC9E9EA39F98979B9B999A9FA09EA0A4A4A1A0A2A3A1A0A3A4A2A0A1A2A09D9D9F9E
9D9C9B999797989694949796928F9092928F8E8D8D8D8D8C8B8C8D8C8A87878784828283
817C767069625A514943403B353332312D2B2B2A2725272926232425222330414740352E
2A2625262624252828272A2F2F2E343D3E3E5A8C
B1BAAC9E9EA29E97989D9D9B9C9FA09FA0A3A29FA0A2A3A2A2A5A5A3A1A3A3A09E9E9F9D
9C9B9B9997979896949597959190929392908F8E8D8D8C8C8C8D8E8D8A88888785838384
827D76706B645C534B45413C383534322F2D2D2B28272B2C28252728252939494B3F312A
28252527262323272827292E2E2D333D3E3E598A
B3BDAE9F9FA29E989A9FA09C9C9FA1A0A1A2A2A0A1A4A5A4A5A7A7A5A4A4A4A19E9F9F9D
9C9D9C9A9899999795979795929294949391908F8E8D8D8D8E8F908E8B89898886848686
847E78736E6860564D47433E39363533302F2E2C292A2E2E2A27292A282F404C48382A26
26252526242122272826282E2E2C333D3E3D598B
B7C0B0A09FA3A09B9CA1A09C9CA0A3A2A1A2A3A2A4A6A8A7A6A8A8A6A4A4A3A19F9F9F9E
9D9E9D9B999A99989697989694949595939191908E8E8E8F8F91918F8C8A8A8987868787
847E7A76716A61564D47433F39363534312F2F2D2B2C2F2E2927292A2B334249412F2425
27252424222023282826292F2F2D343F3E3E5B8E
B7BFAF9F9FA3A09B9CA09F9B9CA1A4A2A0A2A3A3A4A7A8A6A6A7A7A5A3A2A2A19F9E9F9E
9D9D9C9A999999979696979694949594929191908F8E8E8F9092918F8B8A8A8987878786
837F7B77716960564D47433E3937363431302F2D2C2D2F2D29272A2C2E3541443A2A2427
292523232322252A29262A30302E353F3F3F5C90
B4BCAC9E9EA29F999A9E9E9B9DA2A3A09FA1A3A3A4A7A7A5A5A6A6A4A2A2A2A19F9E9E9E
9D9C9B99989898979697979694949494929191918F8E8E909292918D8B8A8B8A88878786
837F7C77716960574E48433E3A37363432302F2E2D2E2F2D29292C2E30363F4035282629
282322242423262A29272B302F2D343F3E3F5C8F
B3BBAD9E9EA29F9A9B9F9F9D9EA3A3A09EA1A4A5A6A7A8A6A6A7A7A4A3A3A3A29F9E9E9E
9D9C9B9A9A9A99989798989795949595949392918F8E8F929493918E8C8C8C8B88878786
84817D78726A62594F48433F3B38363432312F2E2E2F2F2D2A2B2E2F30363C3C32282628
262222262624262928262A2F2E2D353F3E3E5B8D
B4BDAFA09FA2A09C9DA1A19E9FA3A3A09FA3A6A7A6A8A8A7A6A7A8A6A4A4A4A2A09F9F9F
9D9C9C9C9B9B9A999898999896959696949393918F8F92959593908E8E8D8C8A88878786
84817D79736B63594F48433F3B37353433302F2F2F2F2E2C2A2B2D2F3034393830282627
252324272624252828272A2F2F2E353F3E3E5B8E
B6BFB0A09EA3A19C9DA1A19E9FA3A39F9FA4A7A6A5A7A8A6A6A7A9A7A4A4A4A2A09F9F9E
9D9C9D9C9B9A99989797999896959696949392919091949695928F8E8D8C8B8987868686
84817D78726B63584E47423E3A373635333030302F2E2D2C2B2B2D2F303337372F272528
272526282624252828282C31302E353E3E3F5C8F
B5BEAF9E9DA2A09B9CA0A09E9FA2A19E9FA4A6A5A5A7A8A6A6A9AAA7A4A4A4A3A09F9F9E
9C9C9D9C9A99999897989A9996959696949292929292949593908E8D8C8B898886868686
84817D78726C63594E47423F3B383735333130302E2D2D2C2B2C2E2F303337372F27262A
292525272623242829282C302F2C333E3E3F5C8E
B6BEAE9E9DA2A09C9DA1A2A0A0A1A09FA0A5A7A6A7A9AAA9AAACABA8A5A5A6A3A09F9F9E
9D9D9E9C9B9A9A9A9A9B9B99969697979593949493929394928F8D8D8D8B8A8987868787
85827D79746E655A4F4743403C3937353230302F2D2C2D2D2C2D2F2F303337352D26272A
28242427252123292A282A2E2D2B343F3F3F5C8F
B8C0B09F9EA4A39FA0A4A4A1A0A2A2A1A3A7A9A9AAACADACACADACA9A6A6A6A4A09F9F9F
9E9E9F9E9D9C9C9C9C9C9B99969697979594959492919293918F8E8E8E8D8B8988878787
86827E7A7670665A4E47433F3B383534312F2E2E2D2D2E2E2D2D2E2E2F3235322B262729
262325272421242A2A27292E2E2E364140405E91
B9C1B09F9FA6A5A0A1A5A5A19FA2A4A3A4A8ABAAABADAEADACADACA9A6A6A6A3A0A0A0A0
9F9F9F9F9D9C9C9C9A999897969696969493939290909293918E8E8F8E8C8A8887878787
85827E7B766F64584D45413E3A363433312F2E2E2E2E2E2E2D2C2C2D2F3133302B272829
272627272422272C2A272A303131384141415F92
B8C0AF9EA0A7A6A0A0A5A49F9EA2A5A4A4A8ABAAABADAEADABACACA9A5A5A5A3A1A0A09F
9E9E9F9F9C9B9B9A98979797969595959493939290919293918E8E8F8E8B898887878787
86827E7A766E64584D45413E3A373533312F30302F2E2E2E2D2B2B2E2F3132302C29292B
2A2827272424282B2A272C323230374040415E91
B8BFAFA0A2A8A6A0A1A6A49F9FA4A6A4A5A9ACACACAFB0AEADAEAEAAA6A6A7A5A2A1A19F
9E9FA09E9B9A9A9997979999979696969594949392929394918F90908F8B898988888989
86837F7B777065594E46423F3B373534313031312F2D2D2D2C2B2C2E303132312D292A2C
2B2725252424272A29282C32312E364041415F92
BBC1B1A3A5AAA8A3A4A7A5A1A2A7A8A6A8ADB0AFB0B2B2B0B0B1AFAAA7A8A9A6A2A1A09F
9FA0A09E9B9B9B9A98999B9A979798989695959593939494929090918F8C8A8A8A898A89
8683807D7971675A4E45423E3A363433313030302D2B2C2D2C2B2C2F303132312D292A2C
2A2524252424272B2A292D32302F374242436295
BBC3B4A6A6ABA9A5A5A7A5A2A4A8A9A7AAAFB2B1B1B3B3B2B1B1AEAAA7A8A8A5A19FA09F
9E9F9F9D9B9B9B99989A9B99979798979594959493929393918F90918F8C8A8A8A898988
8683807D797166584C44403D39353332302F2F2E2C2B2D2E2C2B2D30303031302D2A2B2C
292524262525282C2B292E3332313A4444456396
BAC2B4A5A5AAA9A5A3A5A4A2A4A8A9A8ABB0B2B1B1B3B3B1B0AFACA9A6A7A6A39F9E9F9E
9D9D9E9D9B9A9A99999A9B99979798969494959492929393919091928F8B898A8A898887
8684817D787165574A423F3C38353331302F2F2E2C2C2E2F2C2B2D30303030302E2B2B2C
292626272726292D2C2A2F3433323A4445456294
BBC4B5A6A6ACABA5A3A6A6A4A5A9AAABADB2B4B3B3B4B5B2B0AFADAAA7A7A6A3A09F9F9E
9E9E9F9E9B9A9A9B9B9C9C9B99989897959596959493949492919393908B8A8B8B898889
8886827E7A7367584A423F3D38343231302F2F2F2D2D2E2E2B2A2D31302F30312F2B2B2C
2A2626272726292C2C2B2F3433323A4444446193
C0C9B9A9AAB0AEA6A5A9A9A7A7ABAEAEB1B5B7B6B6B7B7B4B2B1AFACA9A8A8A5A2A1A1A0
9FA0A09F9D9C9D9E9E9E9D9C99999998979798979594959593939493908C8B8C8C8A8A8A
8986827F7C74675647403E3C3732302F2F2F2F2E2C2C2D2D2A2B2F31302F31322F2B2B2D
2A2625282726292D2D2C2F3434333C4646466498
C3CBBCACACB1AEA7A6AAABA8A9AEB1B1B3B7B9B8B7B8B8B5B2B1AFACA9A8A8A5A1A0A0A0
9FA0A09F9D9D9E9E9E9D9C9A989899989697979694939494939393928E8B8A8B8B8A898A
8885817F7B726351433E3C39332F2F2F2F2F2F2E2C2C2D2D2C2D3032302F31322F2C2C2D
2A26262828272B2F2E2D313636363E484848679B
C2CBBBABAAAFACA6A6AAAAA8AAAFB2B2B3B7B9B8B7B7B7B4B1B0AEAAA7A6A6A39F9E9E9E
9D9E9F9E9C9C9D9D9B9A9998979797969596969593929494929191908C8A8A8B8A898889
8783807E7A6F5E4D413D3B37323031313130302F2D2D2E2E2D2E3132302F31322F2C2C2D
2A26262929292C2F2F2E323837363E484949679A
C3CCBBAAA9AFADA7A7ABACAAACB2B4B4B5B9BBB9B7B7B7B4B0AFADA9A6A6A5A29F9D9E9E
9D9E9F9E9C9C9D9C9B9A9A99999898979797969593939494929191908D8B8B8C8B898989
8783817F7A6E5D4C423E3B37343233333230302F2D2D2E2E2D2D2F302E2E30312E2A2B2C
292526292A292C2F2F2E333837363E494949669B
C8CFBDACADB3B1ABABB0B0AEB0B6B8B8BABEBEBBB9B9B8B4B1B0AEAAA7A7A6A39F9EA0A0
9F9FA1A09D9D9E9E9C9B9C9C9A9999999897979694949594939292918E8C8C8D8C8A8A8A
878381807A6D5C4C413D3A3733323131302E2D2C2B2B2C2C2B2B2D2D2C2D30302C292B2C
2926272A2A292C31312F33393838414B4B4B6AA0
CBD1BFB0B1B7B4AEAEB2B2B0B3B9BBBBBDBFBEBAB8B9B7B3B0AFAEA9A6A6A6A29F9FA0A0
9E9FA09F9D9D9E9E9C9B9C9C999898989796969593939393929191908D8B8B8B8A898887
8482807E776A58473D393735312F2F2E2D2B2B2A292A2B2C2B2A2C2D2D2E30302D2B2E2F
2B27292D2C2C2F343332363C3C3B444E4D4F6FA4
C8D0C0B1B1B6B3ADADB1B2B1B4BABCBCBCBDBBB8B6B6B5B1AFAEACA8A5A5A4A09D9E9E9D
9C9D9E9D9C9C9D9C9A9A9B9996959595949494949291929291908F8F8C89898A89878584
82807D7B736553433A383734302E2F2E2C2B2C2B2A2B2C2C2B2B2E2F2F303232302F3030
2C292B2F2F2E32353434393E3E3D454F4F516FA2
C9D2C2B2B1B6B4AFAEB3B5B5B7BCBFBDBBBBBAB8B6B6B5B2B0AFACA8A5A4A3A09E9E9E9D
9C9D9F9E9C9C9D9C9A9A9A989594969696969695939293939190908F8C898A8B8A868484
83807D7B736451423C3B38343130302F2D2C2D2C2B2B2C2C2B2C2F3130303233312F302F
2B292B2F2F2E31353534393E3D3C455050506DA1
D2DAC9B7B7BDBBB4B4BABCBBBDC1C3C0BDBEBEBCBAB9B9B6B3B1AEA9A6A5A4A29F9F9F9F
9E9FA1A09E9D9E9D9C9B9B999797999A9999989694949595929191908D8B8C8C8A868585
83807E7C73634F423D3B3732302F2E2C2B2B2B2928292A2A2A2C2F3030303232302E2F2E
2B292D30302F333737363B403F3F4953535372A8
DAE0CDBBBCC2BFB8B9BEC0BEBFC4C4C0BEC0C0BDBABABAB6B2AFACA8A4A4A4A19F9E9F9F
9E9FA09F9D9D9E9D9B9A9A9998999B9B9997969593939393918F908E8B898A8986838383
807D7C796F5D4A3F3A35312F2D2B2929292827272728292B2C2D30313030313231303130
2E2D30333333373C3B3A3F4546464F59585A7BB1
D7DECBBABBC1BDB6B7BDBEBCBDC1C1BDBCBDBCB8B6B7B6B2ADAAA8A4A0A0A19E9C9B9C9C
9B9C9D9C9A9B9C9B9998989797979998959292918F8F908F8D8C8C8B8886868582807F7E
7C7A78746856453B3632302F2C29282929282728292A2C2E2F3032333231333534343434
3130333737373B3F3E3E434A4948505B5C5D7CB0
D5DDCBBABBC0BDB7B8BEBFBDBEC2C1BDBBBCBBB8B6B7B6B0ABAAA8A39FA0A19F9C9B9C9C
9B9C9D9D9C9C9D9B999999999797989693919191909090908E8C8D8C8886868683807F7E
7D7B79736656473D383634322D29292A292728292A2B2D2F2F2F31323131343636353434
3130333737373A3E3F3F44494847505C5C5C79AE
E6ECD7C6C6CCC8C2C4CACAC7C8CBCAC5C3C4C3C0BEBFBCB6B1B0ADA8A5A6A7A4A1A1A2A1
A0A1A3A3A2A1A1A09E9E9E9D9A9A9B9996949596949494939190918F8C89898986838182
817F7B746858493F3B38332D27232323222223252626282A2A2A2D2E2E2F333635323232
302F343838383C414242474C4C4D5863626385BD
FFFFE8D6D6DBD7D0D2D6D5D2D2D4D2CCCACBCAC6C4C2BFB8B4B2AEA9A7A9A9A5A2A2A3A2
A0A2A4A4A1A1A19F9E9D9D9A9898999794939495939292918E8D8D8B88858585817D7D7D
7C78736C604F3F36302A221A1413151617191C1E1F21242627292C2F3032363837353536
36373D414142494E4E4E555D5E606B75757AA1D9
FFFDE7D6D7D9D4CECED1CFCCCCCCC9C4C1C1BFBBB7B5B1ABA7A4A19D9C9D9C9895969694
939698969393939291908E8C8A8B8B8885858787848383817E7D7D7B77757574706C6A6A
67625D554836281F1810080305090E13171B1F2124272C2F3033373A3B3E424342424345
45484E5152555B5F5F626B7271737D888B93B4E2
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00Woo16mk0VLi25kg35[F1UJe1U:D1Tic14YB14Ha348@2Sg_148@3Sg_53W>33F]
2C6<12e[1RU:12DY0R480QcW0QBU0PaS0PQ210@Q10000P@Q0PQ210aS0Q2411BU1QS61QcW124822DY
3RU:1Re[1S6<13F]13W>1Sg_0T8@1TYB0U:D0V<H1Goo0@000Goo000=Ool01000Oomoo`0017oo00<0
07ooOol00Woo16mk0VLi25kg35[F1UJe1U:D1Tic14YB14Ha348@2Sg_148@3Sg_53W>33F]2C6<12e[
1RU:12DY0R480QcW0QBU0PaS0PQ210@Q10000P@Q0PQ210aS0Q2411BU1QS61QcW124822DY3RU:1Re[
1S6<13F]13W>1Sg_0T8@1TYB0U:D0V<H1Goo0@000Goo000>Ool20005Ool00`00Oomoo`02Ool2CW<4
DY@2CW<2BU82CW<<BU88AS48@Q08?Nl8>Lh4=Jd2>Lh<=Jd4>Lh6=Jd2>Lh6=Jd6<H`4=Jd@<H`;;F/6
:DX89BT48@P27>L26<H25:D436<6248236<248@25:D46<H67>L68@P89BT::DX@;F/:<H`4=Jd:>Lh2
@Q04AS44?Nl2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9>L`ABU09>L`9:DP9>L`a:DPQ6<@Q2
40Pmk`PicP@e[@8icP`e[@@icPHe[@8icPHe[@HaS0@e[A0aS0/]J`HYBPPU:@@Q208Li`8HaP8DY@@<
H`H8@P8<H`8@Q08DY@@HaPHLi`HQ20PU:@XYBQ0]J`XaS0@e[@XicP9240A6<@@mk`9240Eoo`40005o
o`005Goo00<007ooOol00Woo0SW>14Ha13g_1T8@0Sg_148@4Sg_23W>93F]0SW>13F]136<43F]436<
2Be[0RU:12DY0RU:12DY12480QcW0QS621BU0QS61QcW22482RDY3RU:1Re[0RU:2Re[136<0Re[136<
0SF]136<13F]1SW>0SF]0RU:0QcW0RDY1Goo0@000Goo000EOol00`00Oomoo`02Ool2>Lh4AS44?Nl6
@Q02?Nl4@Q0B?Nl8>LhT=Jd2>Lh4=Jd4<H`@=Jd@<H`9;F/2:DX49BT2:DX49BT48@P27>L26<H85:D2
6<H67>L88@P:9BT>:DX6;F/2:DX:;F/4<H`2;F/4<H`2=Jd4<H`4=Jd6>Lh2=Jd2:DX27>L29BT5Ool1
0001Ool001Eoo`03001oogoo009oo`8icP96<@9240@mk`A240@mk`A240@mk`9240`mkaPicP@e[A@i
cPPe[@HicQHe[@TaS08]J`@YBPH]J`@YBP8U:@8Q208Li`PHaP@Li``Q210U:A8YBQ0]J`@aS0@]J`He
[@8aS08YBP8Q208@Q08<H`8Q20Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0THa0T8@13g_148@
13g_148@13g_0T8@33g_63W>13F]53W>23F]1SW>5SF]2C6<0Re[12U:1Re[12U:0RDY0R480QcW21S6
11cW324842DY4RU:42e[136<12e[1SF]0S6<0RU:0R480Q240PaS0R481Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl4AS44?Nl4@Q04?Nl4@Q04?Nl4@Q0:?NlH>Lh2=JdD>Lh8=Jd6>LhH=Jd9<H`2;F/2
:DX8;F/4:DX29BT28@P47>L66<H87>L88@P@9BT::DXH;F/8<H`4=Jd2;F/28@P26<H248@2124236<2
:DX5Ool10001Ool001Eoo`8000=oo`8mk`A6<@@mk`A240@mk`A240@mk`A240XmkaPicP8e[A@icPPe
[@HicQPe[@TaS08]J`8YBPP]J`@YBP8U:@8Q20@Li`HHaPPLi`PQ210U:@XYBQP]J`PaS0@e[@8]J`8Q
208HaP8@Q0848@8<H`8YBPAoo`80005oo`005Goo00<007ooOol00Woo0Sg_0THa0T8@63g_83W>23F]
0SW>13F]2SW>23F]13W>4SF]136<13F]1c6<0Re[12U:0Re[0S6<12e[1RU:124811cW0QS611cW2248
1RDY12U:12DY22U:12e[0RU:52e[136<0Re[1S6<1SF]0Re[0QcW0Q240PaS0PQ20P@Q0Q240RU:1Goo
0@000Goo000EOol00`00Oomoo`02Ool2?Nl2AS42@Q0H?NlP>Lh8=Jd2>Lh4=Jd:>Lh8=Jd4>LhB=Jd4
<H`4=Jd7<H`2;F/4:DX2;F/2<H`4;F/6:DX48@P47>L26<H47>L88@P69BT4:DX49BT8:DX4;F/2:DXD
;F/4<H`2;F/6<H`6=Jd2;F/27>L248@236<22482124248@2:DX5Ool10001Ool001Eoo`03001oogoo
009oo`8icP92408mk`@icP@mk`@icP@mkb8icP@e[@8icPHe[@@icP@e[@PicPPe[@@icR4e[@8aS0H]
J`HaS0H]J`8YBP8U:@@Q20HLi`@Q20PU:A8YBP`]J`@aS0`]J`8aS0@]J`8aS0@e[@8aS08]J`8U:@8L
i`8<H`@48@88@P848@8@Q08U:@Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0T8@0Sg_13W>13g_
13W>13g_8SW>13F]0SW>1SF]13W>13F]23W>23F]13W>8CF]0S6<1Re[1S6<1Re[0RU:0RDY12481QcW
124822DY4RU:32e[136<32e[0S6<12e[0S6<13F]0S6<0Re[0RDY0QcW0PaS10@Q0PQ20P@Q0Q240RDY
1Goo0@000Goo000EOol00`00Oomoo`02Ool2?Nl2@Q02?Nl4>Lh4?Nl4>Lh4?Nl4>Lh4?Nl4>Lh4?NlJ
>Lh2=Jd6>Lh4=Jd8>Lh8=Jd>>Lh2=Jd4>Lh6=Jd4>Lh7=Jd2<H`4;F/2<H`4=Jd6<H`4;F/2:DX29BT:
8@P89BTD:DX<;F/2<H`B;F/4<H`2=Jd2<H`2:DX28@P25:D22484000212422482124248@2:DX5Ool1
0001Ool001Eoo`03001oogoo009oo`8mk`92408mk`@icP@mk`@icP@mk`@icP@mk`@icP@mkaXicP8e
[@HicP@e[@PicPPe[@hicP8e[@@icPHe[@@icPLe[@8aS0@]J`8aS0@e[@HaS0@]J`8YBP8U:@XQ20PU
:A@YBP`]J`8aS18]J`@aS08e[@8aS08YBP8Q208DY@88@P@000848@88@P848@8@Q08YBPEoo`40005o
o`005Goo00<007ooOol00Woo0Sg_0THa0T8@13W>13g_13W>3Sg_0SW>13g_63W>13F]13W>13F]2SW>
1SF]5SW>13F]1SW>0SF]0cW>0SF]0S6<0Re[0S6<1SF]1S6<12e[0RU:0RDY224822DY4RU:42e[0S6<
3Re[136<13F]0S6<0RU:0QcW0Q240PQ20P@Q0P000P@Q1PQ20QBU0RU:1Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl2AS42@Q04>Lh4?Nl4>Lh>?Nl2>Lh4?NlH>Lh4=Jd4>Lh4=Jd:>Lh6=JdF>Lh4=Jd6
>Lh2=Jd3>Lh2=Jd2<H`2;F/2<H`6=Jd6<H`4;F/2:DX29BT88@P89BTB:DX@;F/2<H`>;F/4<H`4=Jd2
<H`2:DX27>L248@2248212420002124624825:D2:DX5Ool10001Ool001Eoo`03001oogoo009oo`8m
k`92408mk`@icP@mk`@icP@mk`@icP8mka@icP8e[@@icP@e[@8icPPe[@8icP@e[@PicPHe[APicP8e
[@HicP@e[@8icP03=JdaS36<008]J`@aS0@e[@PaS0@]J`8YBP@U:@@Q20HU:A8YBQ8]Ja8aS0He[@8a
S08U:@8HaP8<H`H48@8000848@H8@P8DY@8YBPEoo`40005oo`005Goo0P000goo0Sg_0T8@0Sg_13W>
13g_13W>13g_13W>0Sg_53W>0SF]13W>13F]0SW>23F]0SW>13F]23W>1SF]63W>0SF]1SW>13F]0SW>
00<e[C6<<H`00Re[136<13F]236<12e[0RU:12DY12481RDY4RU:4Re[4S6<1SF]0S6<0RDY0QS60PaS
1P@Q0P000P@Q1PQ20QBU0RU:17oo0P000Goo000EOol00`00Oomoo`02Ool2?Nl2@Q02?Nlj>Lh2=Jd@
>Lh4=JdR>Lh2=Jd4>Lh00cF]<H`aS004<H`6=Jd:<H`2;F/4:DX89BTB:DX>;F/H<H`6=Jd2;F/29BT2
6<H236<2124200041244000624825:D2:DX5Ool10001Ool001Eoo`03001oogoo009oo`8mk`92408m
kcXicP8e[A0icP@e[B8icP8e[@@icP03=JdaS36<00@aS0He[@XaS08]J`@YBPPU:A8YBPh]JaPaS0He
[@8]J`8U:@8HaP8<H`848@8000@48@@000H8@P8DY@8YBPEoo`40005oo`005Goo00<007ooOol00Woo
0Sg_0THa0Sg_13W>13g_13W>13g_3SW>0Sg_;3W>0SF]2SW>1Sg_6SW>00<e[C6<<H`00S6<43F]136<
12e[4RU:52e[5S6<1SF]0S6<0Re[0R480QBU0PQ20P@Q30001PQ20QBU0RU:1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2?Nl2AS42?Nl4>Lh4?Nl4>Lh4?Nl>>Lh2?Nl/>Lh2=Jd:>Lh6?NlJ>Lh00cF]<H`a
S002<H`@=Jd4<H`4;F/B:DXD;F/F<H`6=Jd2<H`2;F/28@P25:D22482124<000624825:D2:DX5Ool1
0001Ool001Eoo`03001oogoo009oo`924096<@9240@icP@mk`@icPHmk`XicP@mkb0icP8e[@@icP8m
k``icPPmkaXicP<e[@8aS0@e[@8icPhe[@@aS08]Ja8YBQ@]Ja8aS0@e[@8icP8e[@8aS08YBP8Li`8@
Q0H48@X000848@H8@P8DY@8]J`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@0THa0T8@13W>13g_
13W>1Sg_2SW>13g_83W>0SF]13W>0Sg_33W>23g_6SW>0cF]0S6<13F]0SW>3SF]136<0Re[4RU:52e[
4S6<13F]0SW>0SF]0S6<0RU:0QcW0Q241P@Q2P000P@Q1PQ20QBU0Re[1Goo0@000Goo000EOol00`00
Oomoo`02Ool2@Q02AS42@Q04>Lh4?Nl4>Lh4?Nl`>Lh2=Jd@>Lh8?NlL>Lh7=Jd4>Lh4=Jd4>Lh6=Jd4
<H`2;F/::DXH;F/D<H`2=Jd4>Lh2=Jd2<H`29BT26<H248@22486124:0002124624825:D2;F/5Ool1
0001Ool001Eoo`03001oogoo009oo`924096<@9240@icP@mk`@icP@mkc0icP8e[A0icPPmka`icPLe
[@@icP@e[@@icPHe[@@aS08]J`XYBQP]Ja@aS08e[@@icP8e[@8aS08U:@8HaP8@Q088@PH48@X00084
8@H8@P8DY@8]J`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@0THa0Sg_13W>13g_13W>13g_@3W>
3Sg_5SW>1cF]3SW>23F]0S6<12e[1RU:62e[4S6<13F]1SW>0S6<0RDY0QS60PaS0PQ20P@Q0P000P@Q
30000P@Q1PQ20QBU0Re[1Goo0@000Goo000EOol20003Ool2@Q02AS42?Nl4>Lh4?Nl4>Lh4?Nm0>Lh>
?NlF>Lh7=Jd>>Lh8=Jd2<H`4;F/6:DXH;F/B<H`4=Jd6>Lh2<H`29BT26<H236<2248212420002124<
0002124624825:D2;F/4Ool20001Ool001Eoo`03001oogoo009oo`924096<@92408icPHmk`@icP@m
k`@icPHmk`@icP@mk`8icP@mkbHicPHmk`8icPPmkb/icPXe[@8aS18]J`@aS0H]J`8aS08]Ja0aS0@e
[@8icP8mk`8icP8aS08U:@8DY@8<H`88@P@48A0000848@H8@P8HaP8]J`Eoo`40005oo`005Goo00<0
07ooOol00Woo0T8@0THa0T8@0SW>1Sg_13W>13g_13W>1Sg_13W>13g_0SW>13g_9SW>1Sg_0SW>23g_
:cW>2SF]0S6<4Re[136<1Re[0S6<0Re[436<13F]0SW>0Sg_0SW>0S6<0RDY0QBU0PaS0PQ210@Q4000
0P@Q1PQ20QS60Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42BU82@Q04?Nl2@Q02?Nl2>Lh@
?Nl2>Lh<?NlH>Lh4=Jd8>LhR?NlS>Lh2=Jd2<H`:;F/4<H`4;F/4<H`6;F/B<H`4=Jd4?Nl2>Lh2<H`2
8@P25:D236<22484124<000412420002124636<26<H2<H`5Ool10001Ool001Eoo`03001oogoo009o
o`96<@9:DP9240@mk`92408mk`8icQ0mk`8icP`mkaPicP@e[@PicR8mkb<icP8e[@8aS0X]J`@aS0@]
J`@aS0H]Ja8aS0@e[@@mk`8icP8aS08Q208DY@8<H`88@P@48@`000@48@8000848@H<H`8HaP8aS0Eo
o`40005oo`005Goo00<007ooOol00Woo0THa0TYB0T8@63g_13W>33g_53W>13F]2SW>93g_23W>0cg_
63W>0SF]0S6<22e[1S6<12e[136<12e[2S6<2SF]0SW>1Sg_0S6<0R480QBU0PaS0PQ21P@Q30001P@Q
0PQ21PaS0QcW0S6<1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42BU82@Q0H?Nl4>Lh<?NlD>Lh4
=Jd:>LhT?Nl8>Lh3?NlH>Lh2=Jd2<H`8;F/6<H`4;F/4<H`4;F/:<H`:=Jd2>Lh6?Nl2<H`28@P25:D2
36<22486124<00061242248636<27>L2<H`5Ool10001Ool001Eoo`03001oogoo009oo`96<@9:DP92
418mk`8icP@mk`@icP`mkb0icR@mk`PicPDmk`@icPhmk`HicP8e[@@aS0@]J`PaS08]Ja0aS0`e[@8i
cPHmk`8aS08U:@8DY@@<H`88@PH48@`000P48@H<H`8Li`8aS0Eoo`40005oo`001goo10000goo0P00
1Goo00<007ooOol00Woo0THa0TYB0T8@4Sg_0SW>13g_13W>33g_83W>93g_23W>1Cg_13W>3Sg_1SW>
0SF]136<12e[236<0Re[436<33F]0SW>1Sg_0S6<0RDY0QBU10aS0PQ21P@Q300020@Q1PaS0QcW0S6<
1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Woo0THa0TYB0THa
13g_0T8@8Sg_6SW>13F]0SW>0Sg_0T8@3Sg_148@3Sg_1SW>6Cg_1SW>13F]6S6<43F]0SW>13g_0SW>
0S6<0RDY0QS610aS0PQ220@Q30001P@Q0PQ21PaS0QcW0SF]1Goo0@000Goo0008Ool00`00Oomoo`02
Ool01000Oomoo`0017oo0P000goo0THa0TYB0THa13g_0T8@8Sg_6SW>13F]0SW>0Sg_0T8@3Sg_148@
3Sg_1SW>6Cg_1SW>13F]6S6<43F]0SW>13g_0SW>0S6<0RDY0QS610aS0PQ220@Q30001P@Q0PQ21PaS
0QcW0SF]17oo0P000Goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo
0TYB0Tic0THa13g_0T8@1Sg_148@63g_3SW>0Sg_1SW>0SF]136<0SF]0Sg_148@2Sg_1T8@43g_0SW>
7Cg_1SW>13F]5S6<4SF]0SW>13g_0SW>0S6<0RDY0QS60Q241PQ20P@Q0P000P@Q3P001P@Q0PQ210aS
0Q240QcW0SF]1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009o
o`9:DP9>L`96<@@mk`9240Hmk`A241Pmk`hicP8mk`HicP8e[@@aS08e[@8mk`A240Xmk`I2410mk`8i
cQdmk`HicP@e[AHaS18e[@8icP@mk`8icP8aS08U:@8HaP8@Q0H8@P848@8000848@h000H48@88@P@<
H`8@Q08Li`8e[@Eoo`40005oo`0027oo0P0017oo0P001Goo00<007ooOol00Woo0TYB0Tic0THa13g_
0T8@1Sg_148@6Sg_0SW>0Sg_33W>13F]0S6<0Re[0S6<0SW>748@43g_0T8@6cg_13W>13F]3S6<53F]
13W>13g_0SW>0S6<0RDY0QcW0Q240PaS10Q210@Q0P0010@Q2P0020@Q0PQ21Q240R480SF]1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2BU82CW<2AS44?Nl2@Q06?Nl4@Q0J?Nl2>Lh2?Nl<>Lh4=Jd2<H`2
;F/2<H`2>LhL@Q0@?Nl2@Q0K?Nl4>Lh4=Jd><H`D=Jd4>Lh4?Nl2>Lh2<H`29BT27>L248@236<42484
12420004124:00081242248648@28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>L`96
<@@mk`a240hmk`Q240Pmk`XicP@e[@HaS08e[@8mk`96<@9:DPI6<A9240@mk`9240Pmk`U241Pmk`@i
cR0e[@HicPHmk`8e[@8YBP8Li`8DY@8<H`H8@PX48@@000P48@H8@P8<H`H@Q08Q208e[@Eoo`40005o
o`005Goo00<007ooOol00Woo0TYB0Tic0THa13g_348@3Sg_248@23g_2SW>13F]1S6<0SF]0Sg_0THa
0TYB1THa4T8@13g_0T8@23g_2D8@63g_13W>83F]1SW>1Sg_0SF]0RU:0QcW0QBU0PaS1PQ22P@Q1000
20@Q1PQ20PaS1Q240R480SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82CW<2BU84@Q04AS48
@Q04?Nl8@Q04AS46@Q04?Nl:>Lh6=Jd8<H`2>Lh2@Q06BU82AS44@Q04?Nl4@Q04AS42@Q06?Nl2@Q06
?NlM@Q08?Nl2>LhF=Jd<>Lh4?Nl2@Q02?Nl2>Lh2;F/28@P25:D248@236<6248:1244000812462482
36<648@28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>L`9:DPA240A6<@Q240@mk`Q2
40A6<@I240@mk`XicPHe[@PaS08icP9240I:DP96<@A240@mk`A240A6<@9240Hmk`9240Hmkae240Pm
k`8icQHe[@`icP@mk`92408mk`8icP8]J`8Q208DY@8@Q08<H`H8@PX48@@000P48@H8@P8<H`H@Q08Q
208e[@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB148@14Ha348@1THa1T8@13g_13W>
2SF]236<1Re[0S6<0SW>0T8@14ic0TYB0T8@23g_0T8@0THa0TYB0T8@0Sg_13W>2Sg_2d8@13g_148@
13g_148@23g_13W>53F]3SW>0Sg_0T8@0Sg_0SW>0S6<0RDY0QS60Q2410aS1PQ220@Q1P0020@Q1PQ2
0PaS1Q240R480SW>1Goo0@000Goo000EOol20003Ool2BU82CW<2BU84@Q04AS4<@Q06AS46@Q04?Nl4
>Lh:=Jd8<H`6;F/2<H`2>Lh2@Q04CW<2BU82@Q08?Nl2@Q02AS42BU82@Q02?Nl4>Lh:?Nl;@Q04?Nl4
@Q04?Nl4@Q08?Nl4>LhD=Jd>>Lh2?Nl2@Q02?Nl2>Lh2<H`29BT26<H248@436<62488124600081246
248236<648@28@P2>Lh4Ool20001Ool001Eoo`03001oogoo009oo`9:DP9>L`9:DPi24096<@Q240@m
k`@icP8e[@@aS18]J`@YBP8U:@8YBP8aS08mk`9:DP9BU09>L`9240HicP8mk`9240A:DP96<@8icP8e
[@8icP8mk`A240Hmk`Q241/mk`HicQ0e[@hicP8mk`A2408icP8aS08U:@8HaP8@Q0H<H`@8@PH48@80
00@48@@000P48@H8@P8<H`H@Q08Q208icPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB
3T8@0THa248@13g_13W>0SF]136<4Re[12U:0RDY0RU:0S6<0Sg_0TYB0U:D0Tic0T8@1SW>0Sg_0T8@
14YB0THa0SW>0SF]0SW>0Sg_148@1Sg_248@6cg_1SW>43F]3SW>0Sg_148@0SW>0S6<0RDY0QS60Q24
1PaS10Q21P@Q0P0010@Q100020@Q1PQ20PaS1Q240R480SW>1Goo0@000Goo000EOol00`00Oomoo`02
Ool2BU82CW<2AS44?Nl<@Q02?Nl4>Lh2=Jd4<H`4;F/J:DX29BT2:DX2<H`2?Nl2CW<4E[D2CW<2@Q02
>Lh2?Nl2@Q02AS44BU82AS42?Nl2=Jd2>Lh2?NlB@Q0G?Nl4@Q04?Nl6>Lh6=Jd4>Lh2=Jd>>Lh2?Nl4
@Q02?Nl2=Jd2:DX27>L248@836<2248612440004124400081246248236<648@27>L2=Jd5Ool10001
Ool001Eoo`03001oogoo009oo`9:DP9>L`96<@@mk`a2408mk`@icP8e[@@aS0@]JaXYBP8U:@8YBP8a
S08mk`9>L`AF]@9>L`92408icP8mk`924096<@A:DP96<@8mk`8e[@8icP8mka9241Lmk`A240@mk`Hi
cPHe[@@icP8e[@hicP8mk`A2408mk`8e[@8YBP8Li`8@Q0P<H`88@PH48@@000@48@@000P48@H8@P8<
H`H@Q08Li`8e[@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0THa148@14Ha0T8@13g_0SW>
0SF]0S6<12e[0RU:0RDY3RU:42e[0S6<0SW>0THa0U:D15kg0U[F0TYB0T8@0Sg_0THa1TYB0THa0T8@
13W>0Sg_0T8@14Ha5D8@0Sg_548@13g_1SW>0SF]4SW>13g_148@0Sg_0SF]0RU:0QcW0QBU20aS10Q2
10@Q1P0010@Q100020@Q1PQ20PaS1Q240QcW0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82
CW<2AS44@Q04AS42@Q04?Nl2>Lh2=Jd2<H`4;F/2:DX29BT>:DX@;F/2<H`2>Lh2AS42DY@4G_L2F]H2
BU82@Q02?Nl2AS46BU82AS42@Q04>Lh2?Nl2@Q04AS4E@Q02?NlD@Q04?Nl6>Lh2=JdB>Lh4?Nl4@Q02
?Nl2=Jd2:DX27>L25:D836<4248412460004124400081246248236<648@27>L2=Jd5Ool10001Ool0
01Eoo`03001oogoo009oo`9:DP9>L`9:DPA24096<@92408mk`@e[@8]Ja0YBPH]J`haS0@e[@8icP8m
k`9:DP9F]@9Nm`9S609Nm`9BU096<@A240A:DPA6<@92408mk`8icP8mk`9240A6<Be240@mka@icP8m
k`8icP@mk`I2408icP8]J`8Q208DY@8@Q0H<H`@8@PH48@@000H48@@000P48@H8@P8<H`H@Q08Q208i
cPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB148@0THa0T8@0Sg_13F]0Re[42U:1Re[
3S6<13F]0SW>0Sg_0TYB0UJe0Ukg0V<H0Ukg0U:D0THa148@14YB14Ha0T8@0Sg_0SW>0Sg_0T8@14Ha
;D8@13g_53W>0Sg_0SW>13g_1T8@0SW>0Re[0R480QBU0Q241PaS10Q21P@Q10001P@Q100020@Q1PQ2
0PaS1Q240R480SW>1Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2DY@2BU82@Q04?Nl2>Lh2<H`2
;F/4:DX29BT::DX6;F/6<H`:=Jd2>Lh4?Nl2@Q02BU82DY@2E[D4F]H2DY@2BU82@Q02?Nl2@Q04AS42
@Q08?Nle@Q04?Nl@>Lh:?Nl6@Q02>Lh2<H`29BT26<H448@436<6248@1242000:1246248236<648@2
8@P2>Lh5Ool10001Ool001Eoo`8000=oo`9>L`9BU09:DP9240@mk`8icP8aS08]J`@YBP8U:@XYBPH]
J`HaS0Xe[@8icP@mk`92409:DP9BU09F]@AJeP9BU09:DP92408mk`9240A6<@9240PmkcE240@mka0i
cPXmk`I2408icP8aS08U:@8HaP@@Q0@<H`H8@Q048@8000X48@H8@P8<H`H@Q08Q208icPAoo`80005o
o`005Goo00<007ooOol00Woo0TYB0Tic0T8@0SF]136<0Re[12DY22U:22e[236<23F]13W>13g_148@
0THa0TYB0Tic15:D0Tic0TYB0T8@13g_148@1Sg_>d8@1Sg_33W>2Sg_0T8@0THa0T8@0Sg_0SF]0RU:
0QcW0QBU0Q2410aS1PQ24P@Q0P002P@Q1PQ20PaS1Q240R480SW>1Goo0@000Goo000EOol00`00Oomo
o`02Ool2BU82CW<2@Q02=Jd4<H`2;F/49BT8:DX8;F/8<H`8=Jd4>Lh4?Nl4@Q02AS42BU82CW<4DY@2
CW<2BU82@Q04?Nl4@Q06?Nlk@Q06?Nl<>Lh:?Nl2@Q02AS42@Q02?Nl2=Jd2:DX27>L25:D248@436<6
248B1242000:1246248236<648@28@P2>Lh5Ool10001Ool001Eoo`03001oogoo009oo`A6<@8icP8]
J`8YBP8]J`8YBP8U:@8YBQ0]J`8aS0He[@XicP@mk`A240A6<@Y:DP96<@9240@mk`Y24096<@I240a6
<@9240I6<@A24096<A]240Hmk`HicP`mk`A24096<@92408icP8]J`8Q208HaP8@Q0@<H`P8@Q848@80
00X48@H8@P8<H`H@Q08Q208e[@Eoo`40005oo`005Goo00<007ooOol00Woo14Ha0SW>0Re[0RU:0Re[
0RU:0RDY0RU:42e[0S6<1SF]2SW>13g_148@14Ha2TYB0THa0T8@13g_2T8@0THa1T8@34Ha0T8@1THa
148@0THa6d8@1Sg_1SW>33g_148@0THa0T8@0SW>0Re[0R480QS60Q2410aS20Q24P@Q0P002P@Q1PQ2
0PaS1Q240R480SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool4?Nl2<H`4:DX8;F/4<H`4;F/6<H`4
=Jd6>Lh:?Nl6@Q08AS44BU82CW<2BU82AS46@Q0<AS42@Q0HAS42@Q05AS44@Q02AS46@Q0<AS44@Q06
?Nl2>Lh<?Nl4@Q04AS42?Nl2<H`29BT26<H248@436<6248R1246248236<248@236<248@27>L2<H`5
Ool10001Ool001Eoo`03001oogoo009oo`@mk`8aS0@YBPP]J`@aS0@]J`HaS0@e[@HicPXmk`I240Q6
<@A:DP9>L`9:DP96<@I240a6<@9241Q6<@9240E6<@A24096<@I240a6<@A240Hmk`8icP`mk`A240A6
<@8mk`8aS08U:@8HaP8@Q0@<H`H8@R848@H8@P8<H`8@Q08<H`8@Q08Li`8aS0Eoo`40005oo`005Goo
00<007ooOol00Woo13W>0S6<0Re[536<13F]13W>3Sg_1T8@24Ha14YB14ic0TYB?DHa0T8@44Ha148@
43g_0T8@1THa0T8@0SF]0RU:0QcW0QBU0Q2410aS1PQ28P@Q1PQ21PaS0Q240QcW0Re[1Goo0@000Goo
000EOol00`00Oomoo`02Ool4>Lh2<H`2;F/D<H`4=Jd4>Lh>?Nl6@Q08AS44BU84CW<2BU8mAS42@Q0@
AS44@Q0@?Nl2@Q06AS42@Q02=Jd2:DX27>L25:D248@436<6248R1246248636<248@27>L2;F/5Ool1
0001Ool001Eoo`03001oogoo009oo`@icP8e[@@aS08e[@8aS0@]J`HaS0@e[@HicPPmk`Y240Y6<@I:
DP9>L`I:DQA6<@9:DSM6<@A240hmk`9240A6<@9:DP96<@8icP8]J`8Q208DY@8@Q0@<H`H8@R@48@P8
@P@<H`8@Q08HaP8]J`Eoo`40005oo`005Goo0P000goo13W>0SF]136<0SF]0S6<12e[1S6<13F]1SW>
23g_2T8@2THa1TYB0Tic1TYB54Ha0TYB=dHa148@3Sg_0T8@14Ha0TYB0THa0SW>0Re[0R480QBU0Q24
10aS1PQ290@Q20Q210aS0Q240QS60Re[17oo0P000Goo000EOol00`00Oomoo`02Ool2>Lh2?Nl2=Jd4
<H`2=Jd6<H`6=Jd6>Lh6?Nl>@Q08AS4DBU86AS4>BU86AS44BU8:AS42BU8IAS44BU84AS46@Q04?Nl8
@Q02AS44BU82AS42?Nl2<H`29BT26<H448@436<6248T1248248436<248@26<H2;F/5Ool10001Ool0
01Eoo`03001oogoo009oo`8icP8mk`8e[@@aS08e[@HaS0He[@HicPHmk`i240Q6<AA:DPI6<@i:DPI6
<@A:DPY6<@9:DQU6<@A:DPA6<@I240@mk`Q24096<@A:DP96<@8mk`8aS08U:@8HaP@@Q0@<H`H8@R@4
8@P8@P@<H`8@Q08HaP8]J`Eoo`40005oo`005Goo00<007ooOol00Woo13g_0SW>0S6<2SF]23W>1Sg_
2T8@2THa44YB1Tic5TYB14Ha24YB1THa1TYB4dHa2TYB1THa448@0THa14YB0T8@0SF]0RU:0QcW0QBU
0Q2410aS20Q210@Q0PQ27P@Q1PQ21PaS0Q240QcW0Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool4
?Nl2>Lh2<H`:=Jd8>Lh6?Nl:@Q0:AS4@BU86CW<FBU84AS48BU86AS46BU8CAS4:BU86AS4@@Q02AS44
BU82@Q02=Jd2:DX27>L25:D248@436<824841242248N1246248636<248@27>L2;F/5Ool10001Ool0
01Eoo`03001oogoo009oo`8mk`92408icP@e[@@icP8e[@@icPPmk`Q24116<@i:DPQ>Lbi:DP]6<@9:
DPA6<@i:DPA6<@i24096<@A:DP96<@8mk`8aS08Q208HaP@@Q0@<H`h8@Qh48@H8@P8<H`H@Q08Li`8a
S0Eoo`40005oo`005Goo00<007ooOol00Woo0Sg_0T8@0SW>13F]13W>0SF]13W>23g_248@44Ha3TYB
24ic;TYB2dHa0TYB14Ha3TYB14Ha3T8@0THa14YB0THa0Sg_0S6<0R480QS6112410aS3PQ27P@Q1PQ2
0PaS1Q240QcW0S6<1Goo0@000Goo000EOol00`00Oomoo`02Ool2?Nl2@Q02>Lh4=Jd8>Lh8?Nl8@Q0@
AS4@BU8:CW<ZBU86AS4MBU84AS48@Q04AS46BU82@Q02=Jd2:DX27>L25:D248@636<>248N12462482
36<648@27>L2;F/5Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`8mk`92408icP@e
[@PicPPmk`Q24116<A1:DPY>LbY:DPI6<Ae:DPA6<@Q240A6<@I:DP92408e[@8YBP8Li`8DY@8@Q0H<
H`h8@Qh48@H8@P8<H`H@Q08Li`8]J`Eoo`40005oo`002Woo00@007ooOol0009oo`03001oogoo009o
o`03001oogoo009oo`8mk`92408mk`8e[@XicPHmk`Y24116<A1:DPa>Ld]:DPQ6<@9240A6<@9:DP9>
L`9:DP96<@8icP8]J`8Q208HaP8DY@8@Q0H<H`P8@P@48@88@Qh48@H8@P8<H`H@Q08Li`8]J`Eoo`40
005oo`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`8mk`92408mk`8e[@XicPHmk`Y24116<A1:
DPa>Ld]:DPQ6<@9240A6<@9:DP9>L`9:DP96<@8icP8]J`8Q208HaP8DY@8@Q0H<H`P8@P@48@88@Qh4
8@H8@P8<H`H@Q08Li`8]J`Aoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool2?Nl2@Q02?Nl4>Lh8?Nl:@Q02AS42@Q0:AS4BBU8DCW=9BU88AS42@Q02AS42BU84CW<2
BU82?Nl2<H`29BT27>L25:D248@636<:24841242248N1246248236<648@27>L2<H`5Ool10001Ool0
00Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool2?Nl2@Q02?Nl4>Lh8?Nl:@Q02
AS42@Q0:AS4BBU8DCW=9BU88AS42@Q02AS42BU84CW<2BU82?Nl2<H`29BT27>L25:D248@636<:2484
1242248N1246248236<648@27>L2<H`5Ool10001Ool000Uoo`8000=oo`8000Eoo`03001oogoo009o
o`924096<@92408icPPmk`Y240Q6<AQ:DPY>L`ABU0I>L`I:DPA>LdE:DPA6<@924096<@A>L`9:DP92
408icP8]J`8Q208HaP8DY@8@Q0H<H``8@P848@@8@QX48@P8@P8<H`H@Q08Li`8aS0Eoo`40005oo`00
5Goo00<007ooOol00Woo0T8@0THa0T8@0SW>23g_2T8@24Ha64YB2Tic15:D1Tic1TYB14icADYB14Ha
0T8@0THa14ic0TYB0T8@0SW>0Re[0R480QS60QBU0Q241PaS30Q20P@Q10Q26P@Q20Q20PaS1Q240QcW
0S6<1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02AS42@Q04?Nl>@Q0:AS4FBU8<CW<2DY@8CW<6
BU82CW=7BU86AS42BU84CW<2AS42?Nl2<H`29BT27>L26<H25:D248@836<@248D1244248212482482
36<648@27>L2<H`5Ool10001Ool001Eoo`03001oogoo009oo`924096<@9240@mk`i240Y6<AI:DPa>
L`9BU0Q>L`I:DP9>LdM:DPI6<@9:DPA>L`96<@8mk`8aS08U:@8Li`8HaP8DY@8@Q0P<Ha08@Q@48@@8
@P848@P8@P8<H`H@Q08Li`8aS0Eoo`40005oo`005Goo00<007ooOol00Woo0THa0TYB0THa0Sg_2T8@
2THa0TYB14Ha4TYB14ic0TYB5Tic0TYB14ic14YB1Tic34YB0Tic9DYB24ic0TYB14Ha0TYB0Tic0U:D
0TYB0T8@0SF]0RU:0R480QcW0QBU0Q242PaS40Q250@Q10Q20P@Q20Q20PaS1Q240QcW0S6<1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2AS42BU82AS42?Nl:@Q0:AS42BU84AS4BBU84CW<2BU8FCW<2BU84
CW<4BU86CW<<BU82CW<UBU88CW<2BU84AS42BU82CW<2DY@2BU82@Q02=Jd2:DX28@P27>L25:D248@:
36<@248D124424821248248236<648@27>L2<H`5Ool10001Ool001Eoo`03001oogoo009oo`96<@9:
DP96<@A240A6<@9240Y6<@A:DPA6<A1:DPI>L`9:DSA>Lb5:DPa>L`9:DPA6<@9:DPA>L`96<@8icP8]
J`8U:@8Q208HaP8DY@8@Q0X<Ha08@P@48@88@Ph48@h8@P8<H`H@Q08Li`8e[@Eoo`40005oo`005Goo
0P000goo0THa0TYB0THa148@14Ha0T8@2THa14YB14Ha44YB1Tic0TYB=4ic8DYB34ic0TYB14Ha0TYB
14ic0THa0SW>0Re[0RDY0R480QS60QBU0Q242PaS40Q210@Q0PQ23P@Q3PQ20PaS1Q240QcW0SF]17oo
0P000Goo000EOol00`00Oomoo`02Ool2AS42CW<2AS44@Q0@AS44BU82AS44BU82CW<<BU86CW<2BU8<
CW<4DY@HCW<2BU86CW<UBU8<CW<6BU86CW<2@Q02=Jd2:DX29BT27>L26<H448@:36<B248212422486
124424841248248436<2248236<448@25:D28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`96
<@9>L`96<@A24116<@A:DP96<@A:DP9>L`a:DPI>L`9:DPa>L`ABU1Q>L`9:DPI>LbE:DPa>L`I:DPI>
L`92408e[@8YBP8U:@8Li`8HaP@@Q0X<Ha88@P848@88@PH48@@8@P@48@P8@P@<H`88@P8<H`@@Q08D
Y@8Q208e[@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB0Tic0THa148@14Ha0T8@2THa2TYB0Tic
34YB14ic14YB34ic0U:D64ic1TYB0Tic:DYB2Tic1TYB14ic0TYB0Sg_0Re[0RDY0R480QcW0QBU1124
2PaS60Q210@Q10Q210@Q20Q210aS0PQ20PaS0Q2411BU0R480SF]1Goo0@000Goo000EOol00`00Oomo
o`02Ool2BU82CW<2AS44@Q04AS42@Q0:AS4:BU82CW<<BU84CW<4BU8<CW<2DY@HCW<6BU82CW<YBU8:
CW<6BU84CW<2BU82?Nl2;F/29BT28@P27>L25:D448@:36<H2484124424841248248436<2248236<2
48@45:D28@P2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>L`9:DPA240A6<@9240Y6<AQ:
DPA>L`A:DRA>L`Q:DP9>L`I:DP9>Lb5:DPY>L`A:DPI>L`96<@8e[@8YBP8U:@8Q208HaP8DY@@@Q0X<
HaP8@P@48@@8@P@48@P8@P@<H`88@P8<H`8@Q0@DY@8Q208e[@Eoo`40005oo`005Goo00<007ooOol0
0Woo0TYB0Tic0TYB148@14Ha0T8@2THa64YB14ic14YB94ic24YB0Tic1TYB0Tic8DYB2Tic14YB1Tic
0THa0SF]0RU:0RDY0R480QS60QBU11242PaS60Q210@Q10Q210@Q20Q210aS0PQ20PaS0Q2411BU0R48
0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82CW<2BU84@Q0:AS42BU84AS4BBU8:CW<2BU8<
CW<4DY@FCW<6BU8<CW<QBU8:CW<2BU84CW<2DY@2BU82?Nl2<H`29BT28@P27>L26<H648@836<B2482
1244248612442482124:248836<65:D28@P2>Lh5Ool10001Ool001Eoo`03001oogoo009oo`9:DP9>
L`9:DPA240Y6<@9:DPA6<A9:DPY>L`9:DPa>L`ABU1I>L`I:DPa>Lb5:DPY>L`9:DPA>L`9BU09:DP8m
k`8aS08U:@8Q208Li`8HaPH@Q0P<Ha88@P848@@8@PH48@@8@P848@X8@PP<H`HDY@8Q208icPEoo`40
005oo`005Goo00<007ooOol00Woo0TYB0Tic0TYB34Ha14YB14Ha4TYB1Tic14YB3Tic15:D:4ic7dYB
44ic0U:D0Tic0THa0SF]0RU:0RDY0R480QcW0QBU1Q2420aS6PQ20P@Q1PQ20P@Q2PQ21PaS0Q241QBU
0R480SW>1Goo0@000Goo000EOol20003Ool2BU82CW<2BU8<AS44BU84AS4BBU86CW<4BU8>CW<4DY@X
CW<OBU8@CW<2DY@2CW<2AS42=Jd2:DX29BT28@P27>L25:D648@836<J248212462482124:248636<2
48@65:D28@P2>Lh4Ool20001Ool001Eoo`03001oogoo009oo`9:DP9BU09:DPA6<@9:DPI6<@A:DP96
<A9:DPI>L`A:DQ1>L`9BU29>L`A:DP9>Lb5:DPi>L`ABU09:DP8mk`8aS08YBP8Q208Li`8HaP8DY@@@
Q0H<Hah8@P848A88@PH<H`8@Q0HDY@8Q208icPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0U:D
0TYB14Ha0TYB1THa14YB0THa4TYB1Tic14YB44ic0U:D8Tic14YB0Tic8DYB3Tic15:D0TYB0Sg_0S6<
0RU:0R480QcW0QS60QBU11241PaS7PQ20P@Q4PQ21PaS0Q241QBU0R480SW>1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2CW<2DY@2BU84AS44BU84AS4:BU82CW<<BU84CW<6BU8>CW<4DY@RCW<YBU8<CW<2
DY@2CW<2AS42>Lh2;F/29BT28@P27>L26<H25:D448@436<d248636<248@65:D28@P2>Lh5Ool10001
Ool001Eoo`03001oogoo009oo`9>L`9BU09:DPA6<@A:DPA6<@Y:DP9>L`a:DPA>L`I:DPi>L`ABU29>
LbU:DPa>L`9BU09>L`96<@8icP8]J`8U:@8Q208Li`8HaP8DY@@@Q0@<Hc@8@PH<H`8@Q0HDY@8Q208i
cPEoo`40005oo`005Goo00<007ooOol00Woo0Tic0U:D0Tic14Ha14YB14Ha24YB14ic2TYB1Tic14YB
44ic2U:D54ic0TYB14ic:dYB14ic0U:D14ic15:D0Tic0T8@0S6<0RU:0RDY0R480QcW0QBU1Q2410aS
=0Q21PaS0Q241QBU0RDY0SW>1Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2DY@2CW<4AS44BU84
AS48BU84CW<:BU86CW<4BU8@CW<:DY@DCW<2BU84CW<[BU84CW<2DY@4CW<4DY@2CW<2@Q02<H`2:DX2
9BT28@P27>L25:D648@436<d248636<248@65:D29BT2>Lh5Ool10001Ool001Eoo`03001oogoo009o
o`9>L`9BU09>L`A6<A1:DPA>L`Y:DPI>L`A:DPa>L`iBU19>L`9:DPI>Lb]:DPQ>L`IBU09:DP8icP8]
J`8YBP8U:@8Li`8HaP8DY@@@Q0H<Hc@8@PH<H`8@Q0HDY@8U:@8mk`Eoo`40005oo`005Goo00<007oo
Ool00Woo0Tic0U:D0Tic14Ha44YB14ic2TYB1Tic14YB34ic3U:D4Tic0TYB1Tic:dYB24ic1U:D0TYB
0SW>0Re[0RU:0RDY0QcW0QS60QBU11241PaS=0Q21PaS0Q241QBU0RDY0Sg_1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2CW<2DY@2CW<4AS4LBU88CW<2BU8>CW<2DY@6CW<2DY@@CW<4BU88CW<]BU88CW<2
DY@2E[D2DY@2AS42=Jd2:DX29BT28@P27>L26<H25:D448@636<N248236<B248836<248@65:D29BT2
>Lh5Ool10001Ool001Eoo`8000=oo`9>L`9BU09>L`A6<Aa:DPQ>L`9:DPi>L`9BU0I>L`9BU11>L`A:
DPQ>Lbe:DPQ>L`9BU09F]@9BU096<@8e[@8YBP8U:@8Q208Li`8HaP8DY@@@Q0H<Hah8@P8<Ha88@PP<
H`8@Q0HDY@8U:@8icPAoo`80005oo`005Goo00<007ooOol00Woo0Tic0U:D0Tic14Ha74YB84ic0U:D
6Tic;dYB1Tic0U:D15Je0Tic0Sg_0S6<0RU:0RDY0R480QcW1QBU0Q241PaS2PQ20PaS40Q210aS4PQ2
20aS0Q241QBU0RDY0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2DY@2CW<4AS4LBU8PCW<2
DY@JCW<_BU86CW<2DY@4E[D2CW<2?Nl2<H`2:DX29BT28@P27>L65:D248@636<:248236<@248436<B
248836<248@65:D29BT2?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9BU09F]@9>L`96<@9:DPA>
LaI:DQQ>L`9BU0I>L`ABU1Q>Lc5:DPA>L`ABU0AF]@9:DP8icP8]J`@U:@8Q208HaP@DY@@@Q0@<H`P8
@PH<H`h8@P@<H`H8@P8<H``8@PP<H`8@Q0HDY@8U:@8mk`Eoo`40005oo`005Goo00<007ooOol00Woo
0U:D0UJe0Tic0THa0TYB14ic5TYB64ic0U:D1Tic15:D64ic<DYB14ic15:D15Je0TYB0SW>0Re[12DY
0R480QS611BU112410aS20Q21PaS3PQ210aS1PQ20PaS30Q220aS0Q241QBU0RDY0Sg_1Goo0@000Goo
000EOol00`00Oomoo`02Ool2DY@2E[D2CW<4BU84CW<FBU84CW<2BU8BCW<2DY@6CW<4DY@HCW<aBU84
CW<2DY@4E[D2DY@2AS42=Jd2:DX49BT27>L26<H45:D248@636<6248:36<6248436<2248436<62482
36<<248836<248@65:D29BT2?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9BU09F]@9>L`A:DPA>
LaI:DPA>L`9:DQ9>L`9BU0I>L`ABU1Q>Lc5:DPA>L`9BU0AF]@9BU096<@8e[@8YBP@U:@8Li`8HaP@D
Y@8@Q0H<H`H8@PX<H`H8@P@<H`88@P@<H`H8@P8<H``8@PP<H`8@Q0HDY@8U:@8mk`Eoo`40005oo`00
5Goo00<007ooOol00Woo0U:D0UJe0Tic14YB0Tic64YB0Tic14YB1Tic14YB24ic0U:D1Tic0U:D34ic
0TYB14ic1TYB0Tic<DYB14ic0U:D15Je0Tic0Sg_0S6<0RU:0RDY0R480QcW1QBU0Q241PaS1PQ22PaS
1PQ210aS0PQ210aS10Q210aS30Q220aS0Q2411BU0QS60RDY0Sg_1Goo0@000Goo0007Ool30004Ool2
0005Ool00`00Oomoo`02Ool2DY@2E[D2CW<4BU82CW<HBU82CW<4BU86CW<4BU88CW<2DY@6CW<2DY@<
CW<2BU84CW<6BU82CW<aBU84CW<2DY@4E[D2CW<2?Nl2<H`2:DX29BT28@P27>L65:D248@636<6248:
36<6248436<2248436<4248436<<248836<248@45:D26<H29BT2?Nl5Ool10001Ool000Moo`04001o
ogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0U:D0UJe0Tic14YB0Tic64YB14ic0TYB14ic
14YB2Tic0U:D4Tic14YB14ic14YB14ic4TYB0THa6dYB1Tic1UJe0TYB0SW>0Re[12DY0R480QcW1QBU
0Q2410aS1PQ20PaS1Q241PaS1PQ22PaS10Q20PaS30Q220aS0Q240QBU11S60RDY0Sg_1Goo0@000Goo
0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`8000=oo`9BU09F]@9>L`A:DP9>LaQ:DPA>L`9:
DPA>L`A:DPY>L`9BU19>L`A:DPA>L`A:DPA>La9:DP96<A]:DPI>L`IF]@9:DP8icP8]J`@U:@8Q208L
i`HDY@8@Q0@<H`H8@P8<H`H@Q0H<H`H8@PX<H`@8@P8<H``8@PP<H`8@Q08DY@@HaP8U:@8mk`Aoo`80
005oo`001goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9BU09F]@9>L`A:DPA>L`I:DP9>
L`i:DPA>L`9:DPA>L`9:DPa>L`9BU29>Lbm:DPA>L`9BU0AF]@9BU096<@8e[@8YBP@U:@8Q208HaPHD
Y@8@Q0@<H`H8@P8@Q0@DY@8@Q0@<H`P8@PX<H`h8@P8<H`88@PP<H`8@Q08DY@@HaP8U:@8mk`Eoo`40
005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9BU09F]@9>L`A:DPA>
L`I:DP9>L`i:DPA>L`9:DPA>L`9:DPa>L`9BU29>Lbm:DPA>L`9BU0AF]@9BU096<@8e[@8YBP@U:@8Q
208HaPHDY@8@Q0@<H`H8@P8@Q0@DY@8@Q0@<H`P8@PX<H`h8@P8<H`88@PP<H`8@Q08DY@@HaP8U:@8m
k`Eoo`40005oo`0027oo0`000goo0P001Goo00<007ooOol00Woo0U:D0UJe0U:D14YB0Tic24YB0Tic
3TYB14ic14YB3Tic15:D74ic0TYB0Tic<DYB14ic0U:D15Je0Tic0T8@0S6<0RU:12DY0R4811S611BU
0Q242PaS11BU0Q240PaS2PQ21PaS0PQ20PaS3PQ210aS0PQ220aS0Q241QS60RDY0T8@1Goo0@000Goo
000EOol00`00Oomoo`02Ool2DY@2E[D2DY@4BU82CW<8BU82CW<>BU84CW<4BU8>CW<4DY@LCW<2BU82
CW<aBU84CW<2DY@4E[D2CW<2@Q02<H`2:DX49BT28@P46<H45:D248@:36<45:D248@236<:248636<2
248236<>248436<2248836<248@66<H29BT2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9BU09F
]@9BU0A:DP9>L`I:DPA>L`a:DPI>L`9:DRQ>L`9:DPA>Lbm:DP96<@Q:DP9>L`9BU0AF]@9:DP8mk`8a
S08YBP@U:@8Q208HaP@DY@@@Q0P<H`8@Q0@DY@8@Q0`8@P@<Ha@8@P@<H`88@PP<H`8@Q0HHaP8YBP92
40Eoo`40005oo`005Goo00<007ooOol00Woo0U:D0UJe0U:D14YB0Tic1TYB14ic34YB1Tic0TYB:4ic
0TYB14ic;dYB0THa24YB0Tic0U:D15Je0TYB0Sg_0S6<0RU:12DY0R480QS611BU112420aS0Q2411BU
0Q2430Q210aS50Q210aS0PQ220aS0Q241QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2
DY@2E[D2DY@4BU82CW<6BU82CW<>BU86CW<2BU8VCW<4BU84CW<[BU86AS48BU82CW<2DY@2E[D2DY@2
BU82>Lh2;F/2:DX49BT27>L26<H45:D448@636<848@236<F248236<<248436<2248836<248@66<H2
:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9BU09F]@9BU0A:DP9>L`I:DP9>L`i:DPI>L`9:
DRI>L`A:DPA>Lb]:DPI6<@Q:DP9>L`9BU09F]@9BU09:DP8icP8]J`8YBP@U:@8Li`8HaP@DY@@@Q0H<
H`P@Q08<HaH8@P8<H``8@P@<H`88@PP<H`8@Q0HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol0
0Woo0U:D0UJe0U:D14YB14ic54YB1Tic0TYB9Tic14YB14ic:DYB24Ha24YB0Tic0U:D0UJe0U:D0THa
0SF]0Re[0RU:0RDY0R480QcW0QS611BU11241PaS1Q240PaS5PQ21PaS2PQ210aS0PQ210aS11240QBU
1QS60RU:0T8@1Goo0@000Goo000EOol20003Ool2DY@2E[D2DY@4BU84CW<DBU86CW<2BU8VCW<4BU84
CW<YBU88AS48BU82CW<2DY@2E[D2DY@2AS42=Jd2;F/2:DX29BT28@P27>L26<H45:D448@636<648@2
36<F248636<:248436<2248436<448@25:D66<H2:DX2@Q04Ool20001Ool001Eoo`03001oogoo009o
o`9BU09JeP9BU0A:DPA>LaA:DPI>L`9:DRI>L`A:DPA>LaY:DP96<@]:DPY6<@Q:DP9>L`9BU09F]@9>
L`92408e[@8]J`8YBP8U:@8Q208Li`8HaP8DY@H@Q0h<H`h8@P@<H`@8@PH<H`X8@PP<H`H@Q08DY@HH
aP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0U:D0U[F0U:D14YB14ic54YB1Tic0TYB9Tic
14YB14ic6TYB0THa2dYB2THa24YB0Tic0U:D0UJe0Tic0T8@0SF]0Re[0RU:0RDY0R480QcW0QS60QBU
1Q243PaS3PQ210aS10Q21PaS2PQ220aS1Q240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2DY@2F]H2DY@4BU84CW<DBU84CW<4BU8VCW<RBU82AS46BU8?AS48BU82CW<4DY@2BU82?Nl2
<H`2;F/2:DX29BT28@P26<H45:D648@>36<6248236<6248436<2248836<:248836<648@25:D66<H2
:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9BU09JeP9BU0A:DPA>LaA:DPA>L`A:DRI>Lb9:
DP96<@I:DPm6<@Q:DP9>L`ABU09:DP8mk`8aS08]J`8YBP8U:@8Q208HaP@DY@H@Q0h<H`H8@P8<H`H8
@P@<H`88@PP<H`X8@PP<H`H@Q08DY@HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0U:D
0U[F0U:D14YB14ic54YB14ic14YB9Tic8TYB0THa0TYB4dHa24YB0Tic15:D0THa0SW>0S6<0Re[0RU:
0RDY0QcW0QS611BU1Q243PaS10Q210aS1PQ210aS0PQ220aS10Q20PaS10Q220aS1Q240QBU1QS60RU:
0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2F]H2DY@4BU84CW<DBU84CW<4BU8VCW<RBU82
AS42BU8CAS48BU82CW<4DY@2AS42>Lh2<H`2;F/2:DX29BT27>L26<H45:D648@>36<4248436<62484
36<2248836<4248236<4248836<648@25:D66<H2:DX2@Q05Ool10001Ool001Eoo`03001oogoo009o
o`9F]@9JeP9BU0A:DPA>L`i:DP9>L`A:DPA>L`A:DRI>Lb9:DQM6<@Q:DP9>L`9BU09>L`96<@8icP8a
S08]J`8YBP8Q208Li`8HaP@DY@H@Q1H<H`@8@Q0<H`88@P@<H`@8@PP<H`H@Q08DY@HHaP8YBP9240Eo
o`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D14YB14ic3TYB0Tic14YB14ic14YB9Tic8TYB
5dHa24YB0Tic0U:D0Tic0THa0SW>0S6<0Re[0RU:0R480QcW0QS611BU1Q245PaS10Q240aS0PQ210aS
10Q220aS1Q240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@4BU84
CW<>BU82CW<4BU84CW<4BU8>CW<2BU8DCW<RBU88AS46BU8;AS48BU82CW<2DY@2CW<2@Q02>Lh2<H`2
;F/2:DX28@P27>L26<H45:D648@F36<4248@36<2248436<2248:36<648@25:D66<H2:DX2@Q05Ool1
0001Ool001Eoo`8000=oo`9F]@9JeP9BU0A:DPA>L`i:DP9>L`A:DPA>L`A:DPi>L`9:DQA>Lb9:DPQ6
<@I:DP]6<@Q:DP9>L`9BU09>L`92408icP8aS08]J`8YBP8Q208Li`8HaP@DY@H@Q1H<H`@8@Q0<H`88
@P@<H`88@PX<H`H@Q08DY@HHaP8YBP9240Aoo`80005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D
14YB14ic74YB54ic0U:D3Tic8TYB1THa14YB4dHa14YB0Tic0U:D0TYB0T8@0SW>0S6<0Re[0RDY0QcW
11S60QBU212460aS0PQ22PaS0Q242PaS0PQ220aS21240QBU1QS60RU:0T8@1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2E[D2F]H2DY@4BU84CW<LBU8DCW<2DY@>CW<RBU86AS44BU8CAS44BU82CW<2DY@2
BU82@Q02>Lh2<H`2;F/29BT27>L46<H25:D848@H36<2248:36<248@:36<2248836<848@25:D66<H2
:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0A:DP9>Lai:DQ9>L`9BU11>Lb1:
DQm6<@A:DPA>L`9:DP8mk`8e[@8aS08YBP8U:@8Li`@HaP8DY@H@Q0H<H`@@Q10<H`88@PX<H`8@Q0X<
H`88@PP<H`P@Q08DY@HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D14YB
0Tic7TYB4Tic0U:D44ic84YB7dHa14YB14ic0TYB0Sg_0SF]0S6<0RU:0RDY0QcW11S60QBU1Q241PaS
112440aS0PQ22PaS0Q242PaS0PQ220aS21240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2E[D2F]H2DY@4BU84CW<>BU82CW<8BU8FCW<2DY@BCW<NBU8OAS42BU86CW<2AS42?Nl2=Jd2
<H`2:DX28@P27>L46<H25:D848@236<648@@36<2248:36<248@:36<2248836<848@25:D66<H2:DX2
@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0A:DPA>L`i:DP9>L`Q:DQI>L`9BU19>
Lai:DQm6<@9:DPI>L`96<@8mk`8e[@8aS08YBP8Q208Li`@HaP8DY@P@Q08<H`H@Q10<H`88@PX<H`8@
Q0X<H`88@PP<H`P@Q08DY@HHaP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0U:D
24ic34YB14ic1TYB;4ic1TYB0Tic54YB8DHa14YB14ic0THa0SW>0SF]0Re[0RDY0R480QcW0QS61QBU
3Q2440aS0PQ220aS11243PaS0Q2410aS21240QBU1QS60RU:0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2E[D2F]H2DY@8CW<<BU84CW<6BU8/CW<6BU82CW<DBU8QAS44BU84CW<2AS42>Lh2=Jd2;F/2
9BT28@P27>L26<H65:D>48@@36<2248836<448@>36<248@436<848@25:D66<H2:DX2@Q05Ool10001
Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>L`a:DPA>L`I:DRY>Lai:DR=6<@9:DP9>L`9:DP92
408icP8aS08]J`8U:@8Q208Li`@HaPHDY@`@Q1X<H`@@Q0h<H`8@Q0@<H`P@Q08DY@@HaP8Li`8YBP92
40Eoo`40005oo`005Goo0P000goo0UJe0U[F0U:D24ic34YB14ic1TYB:Tic7TYB8dHa0TYB0Tic0TYB
0T8@0SW>0S6<0Re[0RDY0R480QcW11S61QBU31246PaS11243PaS0Q2410aS21240QBU11S60QcW0RU:
0T8@17oo0P000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@6CW<8BU82CW<4BU84CW<6BU8TCW<4
BU82CW<PBU8QAS42BU82CW<2BU82@Q02>Lh2<H`2;F/29BT27>L66<H65:D<48@J36<448@>36<248@4
36<848@25:D46<H27>L2:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0I>L`Q:
DP9>L`A:DPA>L`I:DRA>L`A:DP9>Lb1:DR56<@9:DP9>L`9:DP92408icP8aS08]J`8U:@8Li`HHaPHD
Y@`@Q1X<H`@@Q0h<H`8@Q0@<H`P@Q08DY@@HaP8Li`8YBP9240Eoo`40005oo`005Goo00<007ooOol0
0Woo0UJe0U[F0U:D0Tic0TYB14ic14YB14ic14YB14ic14YB8Tic1TYB14ic84YB7dHa1TYB0THa0Sg_
0SF]0S6<0RU:0RDY0QcW1QS61QBU312460aS1Q243PaS11240PaS21240QBU0QS611cW0RU:0T8@1Goo
0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@2CW<2BU84CW<4BU84CW<4BU84CW<4BU8RCW<6
BU84CW<PBU8OAS46BU82AS42?Nl2=Jd2<H`2:DX29BT27>L66<H65:D<48@H36<648@>36<448@236<8
48@25:D26<H47>L2:DX2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>L`A:DPA>
L`A:DPA>L`A:DR1>L`A:DPQ>Laa:DR=6<@I:DP96<@8mk`8e[@8aS08YBP8U:@8Li`HHaPHDY@`@Q1H<
H`P@Q0h<H`@@Q08<H`8@Q0@DY@8@Q08DY@HLi`8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo
0UJe0U[F0U:D24ic14YB14ic14YB14ic14YB84ic14YB24ic74YB8dHa1TYB0THa0Sg_0SF]0S6<0RU:
0RDY0QcW1QS61QBU31245PaS21243PaS11240PaS0Q2411BU0Q240QBU1QcW0RU:0T8@1Goo0@000Goo
000EOol00`00Oomoo`02Ool2E[D2F]H2DY@8CW<4BU84CW<<BU8PCW<2BU8:CW<JBU8WAS42BU82AS42
@Q02>Lh2=Jd2;F/2:DX28@P27>L66<H65:D<48@236<448@@36<848@>36<448@236<248@45:D248@2
5:D67>L2:DX2@Q05Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>
L`A:DPA>L`a:DR1>L`9:DPY>LaY:DRM6<@9:DP96<@92408icP8e[@8]J`8YBP8Q208Li`HHaPHDY@`@
Q08<H`@@Q10<H`P@Q0h<H`@@Q08<H`8@Q0@DY@8@Q08DY@HLi`8YBP9240Eoo`40005oo`001goo00@0
07ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool2E[D2F]H2DY@2CW<2BU84CW<4BU84CW<<
BU8VCW<4BU82CW<JBU8[AS42@Q02>Lh2=Jd2;F/2:DX28@P47>L66<H45:DB48@@36<:48@<36<848@4
5:D248@25:D67>L2:DX2@Q05Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo0P00
0goo0UJe0U[F0U:D0Tic0TYB14ic14YB14ic34YB9Tic14YB0Tic6TYB:dHa0T8@0SW>0SF]0Re[0RU:
0R4811cW1QS611BU4Q2440aS2Q2430aS212411BU0Q240QBU1QcW0RU:0T8@17oo0P000Goo0008Ool2
0003Ool01000Oomoo`0017oo00<007ooOol00Woo0UJe0U[F0U:D14YB14ic14YB14ic1TYB0Tic14YB
;4ic6TYB8DHa0T8@24Ha0Sg_0SW>0SF]0Re[0RU:0R4811cW11S61QBU4Q2440aS2Q2430aS212411BU
0Q240QBU1QcW0RU:0T8@1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001o
ogoo009oo`9F]@9JeP9BU0A:DPA>L`A:DPA>L`I:DP9>L`A:DRa>LaY:DR56<@9240Q6<@8mk`8icP8e
[@8]J`8YBP8Q20@Li`@HaPHDYA8@Q10<H`X@Q0`<H`P@Q0@DY@8@Q08DY@HLi`8YBP9240Eoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol00Woo0UJe0U[F0U:D14YB14ic14YB14ic1TYB0Tic14YB
4Tic15:D5Tic6TYB8DHa0T8@1THa0T8@0Sg_0SW>0S6<0Re[0RU:0R4811cW11S611BU3Q240PaS1Q24
30aS312410aS0Q241PaS21241QBU0QS61QcW0RU:0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2
E[D2F]H2DY@4BU84CW<4BU84CW<6BU82CW<4BU8BCW<4DY@FCW<JBU8QAS42@Q06AS42@Q02?Nl2>Lh2
<H`2;F/2:DX28@P47>L46<H45:D>48@236<648@<36<<48@436<248@636<848@65:D26<H67>L2:DX2
AS45Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP9BU0Q>L`A:DPA>L`A:DPA>L`A:DQ1>L`AB
U1Q>LaY:DQU6<@9240I6<@A240A6<@92408mk`8e[@8aS08]J`8U:@8Q20@Li`@HaPhDY@`@Q0`<H`@@
Q08DY@H@Q08<H`H@Q08<H`X@Q0HDY@8HaPHLi`8YBP96<@Eoo`40005oo`005Goo00<007ooOol00Woo
0UJe0U[F0U:D24ic14YB14ic14YB14ic14YB44ic15:D64ic6TYB6DHa0T8@1THa148@14Ha0T8@0Sg_
0SF]0S6<0Re[0RDY0R4811cW11S63QBU312430aS11240QBU1Q240PaS1Q240PaS2Q241QBU0QS61QcW
0RU:0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2DY@8CW<4BU84CW<4BU84CW<4BU8@
CW<4DY@BCW<2BU84CW<JBU8OAS46@Q02AS44@Q02>Lh2=Jd2<H`2;F/2:DX28@P47>L66<H:5:D>48@<
36<248@25:D@48@236<:48@65:D26<H67>L2:DX2AS45Ool10001Ool001Eoo`03001oogoo009oo`9F
]@9JeP9BU0Q>L`A:DPA>L`A:DPA>L`A:DQ1>L`ABU19>L`9:DPA>LaY:DQm6<@I24096<@A2408icP8e
[@8aS08]J`8YBP8Q20@Li`HHaPXDY@h@Q0`<H`8@Q08DYA0@Q08<H`X@Q0HDY@8HaPHLi`8YBP96<@Eo
o`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0UJe24ic14YB14ic14YB0Tic1TYB2Tic0U:D14ic
15:D34ic0TYB34ic14YB0Tic4TYB7dHa2T8@0Sg_0SW>0SF]0S6<0Re[0RU:0R481QcW11S62QBU3Q24
2PaS11240QBU41240PaS2Q241QBU0QS61QcW0RU:0THa1Goo0@000Goo000EOol20003Ool2E[D2F]H2
E[D8CW<4BU84CW<4BU82CW<6BU8:CW<2DY@4CW<4DY@<CW<2BU8<CW<4BU82CW<BBU8OAS4:@Q02?Nl2
>Lh2=Jd2<H`2;F/2:DX28@P67>L46<H:5:D>48@:36<448@25:D@48@236<:48@65:D26<H67>L2:DX2
AS44Ool20001Ool001Eoo`03001oogoo009oo`9F]@9JeP9F]@Q>L`A:DPA>L`I:DP9>L`9:DPY>L`AB
U0A>L`ABU0Y>L`A:DPa>LaQ:DQ]6<@i2408mk`8icP8e[@8aS08]J`8YBP@Q20@Li`@HaPXDY@h@Q0@<
H`8@Q0@<H`@@Q0PDY@X@Q08<H`X@Q0HDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol0
0Woo0UJe0U[F0UJe24ic14YB14ic1TYB0Tic0TYB2Tic15:D14ic15:D2Tic14YB34ic64YB6dHa3T8@
0Sg_0SW>0SF]0S6<0Re[0RU:124811cW11S62QBU3Q2410aS0Q2410aS112421BU2Q240PaS2Q241QBU
0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2E[D8CW<4BU84CW<6BU8>
CW<2DY@6CW<4DY@:CW<4BU8<CW<FBU8KAS4@@Q02?Nl2>Lh2=Jd2<H`2;F/2:DX29BT28@P67>L26<H<
5:DB48@436<448@85:D:48@236<:48@65:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo
009oo`9F]@9JeP9F]@Q>L`A:DPA>L`I:DPi>L`9BU0I>L`ABU0Y>L`A:DPa>LaI:DQ]6<A12408mk`8i
cP8e[@8aS08]J`8YBP8U:@8Q20HLi`8HaP`DYA8@Q0@<H`@@Q0PDY@X@Q08<H`X@Q0HDY@8HaPHLi`8]
J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0UJe0U[F0UJe24ic14YB14ic1TYB3Tic0U:D1Tic
15:D2Tic0TYB3Tic5TYB6DHa4T8@0Sg_0SW>0SF]0S6<0Re[0RU:0RDY124811cW0QS63QBU412410aS
112421BU5Q241QBU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H2E[D8
CW<4BU84CW<6BU8>CW<2DY@6CW<4DY@:CW<2BU8>CW<FBU8IAS4B@Q02?Nl2>Lh2=Jd2<H`2;F/2:DX2
9BT48@P47>L26<H>5:D@48@436<448@85:DF48@65:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03
001oogoo009oo`9JeP9Nm`9F]A1>L`A:DPY>L`IBU0I>L`IBU1Y>LaA:DQe6<A12408mk`8icP8e[@8a
S08]J`8YBP8U:@@Q20@Li`8HaPhDY@`@Q08<H`8@Q0H<H`8@Q0PDYA@@Q0PDY@8HaPHLi`8]J`96<@Eo
o`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe44ic14YB2Tic1U:D1Tic1U:D6Tic54YB7DHa
448@0Sg_0SW>0SF]0S6<0Re[0RU:0RDY124811cW0QS63QBU31240PaS0Q241PaS0Q2421BU512421BU
0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<2DY@:CW<4BU8:
CW<4DY@2CW<<DY@JCW<DBU82AS44BU8GAS4@@Q02?Nl2>Lh2=Jd2<H`2;F/2:DX29BT48@P47>L46<H<
5:DB48@236<248@45:D46<H45:DB48@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`8000=oo`9J
eP9Nm`9F]@A>L`9BU0Y>L`A:DPY>L`ABU09>L`aBU1Y>LaA:DP96<@A:DQM6<A12408mk`8icP8e[@8a
S08]J`8YBP8U:@@Q20@Li`@HaP`DYA8@Q08<H`8@Q0@DY@@HaP@DYA8@Q0PDY@8HaPHLi`8]J`96<@Ao
o`80005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe14ic15:D24ic14YB2Tic15:D0Tic3U:D64ic
6TYB5dHa448@0Sg_0SW>0SF]0S6<12e[0RDY124811cW1QS62QBU4Q240PaS0Q240QBU1QS611BU4Q24
21BU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@8CW<4
BU8:CW<4DY@2CW<>DY@HCW<JBU8GAS4@@Q02?Nl2>Lh2=Jd2<H`4;F/29BT48@P47>L66<H:5:DB48@2
36<248@25:D66<H45:DB48@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9F
]@9Nm`9F]@A>L`ABU0Q>L`A:DPY>L`ABU09>L`iBU1Q>Laa:DQE6<A12408mk`8icP8e[@@aS08]J`8Y
BP@Q20@Li`PHaPPDYA8@Q08<H`8@Q0PHaP@DYA8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo
00<007ooOol00Woo0UJe0Ukg0UJe14ic15:D24ic14YB2Tic15:D0Tic3U:D64ic74YB5DHa448@0Sg_
0SW>0SF]136<0Re[0RU:124811cW21S621BU4Q240PaS0Q2421S611BU4Q2421BU0QS61QcW0Re[0THa
1Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@8CW<4BU88CW<LDY@BCW<LBU8I
AS4<@Q02?Nl2>Lh4=Jd2<H`2;F/2:DX29BT48@P27>L86<H:5:D@48@236<248@26<H47>L26<H45:DB
48@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F]@A>L`ABU0Q>
L`A:DPQ>LaaBU19>Laa:DQU6<@a2408mk`8icP@e[@8aS08]J`8YBP8U:@@Q208Li`PHaPXDYA0@Q08<
H`8@Q08HaP@Li`8HaP@DYA8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo
0U[F0Ukg0UJe14ic15:D24ic0TYB2Tic75:D4Tic0TYB14ic5TYB6DHa348@0Sg_13W>0SF]0S6<0Re[
0RU:0RDY12480QcW21S621BU4Q240PaS0QBU1QcW0QS611BU4Q2421BU0QS61QcW0Re[0THa1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@8CW<2BU8:CW<LDY@BCW<2BU84CW<FBU8I
AS4<@Q02?Nl4>Lh2=Jd2<H`2;F/2:DX29BT48@P27>L86<H85:DB48@236<25:D67>L26<H45:DB48@8
5:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F]@A>L`9BU0A>L`9:
DPY>L`9BU09>Lb1BU11>L`A:DP9>L`a:DP96<@I:DQM6<A12408mk`@icP8e[@8aS08]J`8YBP8U:@@Q
208Li`PHaPPDY@H@Q08DY@`@Q08HaPHQ208HaP@DY@`@Q0@DY@8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40
005oo`005Goo0P000goo0U[F0Ukg0UJe14ic0U:D14ic0TYB2Tic0U:D0Tic85:D44ic14YB0Tic34YB
0THa1TYB5dHa448@0Sg_13W>0SF]0S6<0Re[0RU:0RDY12480QcW21S621BU1Q240QBU31240QS61R48
0QS611BU312411BU0Q2421BU0QS61QcW0Re[0THa17oo0P000Goo000EOol00`00Oomoo`02Ool2F]H2
G_L2E[D4CW<2DY@2CW<2BU8<CW<2DY@2CW<6DY@2CW<HDY@@CW<4BU82CW<FBU8IAS4<@Q02?Nl4>Lh2
=Jd2<H`2;F/2:DX29BT48@P47>L66<H:5:D248@65:D448@25:D248@25:D27>L49BT27>L26<H45:D>
48@25:D248@85:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F]@A>
L`9BU09>L`9:DPa>L`9BU09>L`IBU09>LaQBU11>L`A:DP9>LaI:DQU6<@a2408mk`@icP8e[@8aS08]
J`8YBP8U:@@Q20@Li`HHaPXDY@8@Q0HDY@@@Q08DY@8@Q08DY@8Li`@U:@8Li`8HaP@DY@h@Q08DY@8@
Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe14ic0U:D24ic
0U:D1Tic95:D5Tic64YB3THa0TYB2DHa2T8@13g_0SW>13F]0S6<0RU:0RDY124811cW21S641BU0Q24
21BU0R4812DY0QcW0QBU4Q240QBU0Q2421BU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomo
o`02Ool2F]H2G_L2E[D4CW<2DY@8CW<2DY@6CW<TDY@FCW<HBU8>AS42BU89AS4:@Q04?Nl2>Lh4=Jd2
<H`2:DX29BT48@P47>L86<H@5:D248@85:D28@P49BT27>L25:DB48@25:D248@85:D26<H67>L2;F/2
AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9S609JeP9BU09>L`ABU0A>L`ABU0A>La9BU09F
]@ABU0AF]@YBU1Q>L`A:DP9>La9:DPY6<@A:DPU6<@Y240@mk`@icP8e[@8aS08YBP8U:@@Q20@Li`PH
aQ0DY@8@Q0HDY@8HaP8Q208U:@8Q208DYA8@Q0@DY@8@Q0PDY@8HaPHLi`8]J`96<@Eoo`40005oo`00
5Goo00<007ooOol00Woo0U[F0V<H0U[F0U:D0Tic15:D14ic15:D14ic4U:D0UJe15:D15Je2U:D64ic
14YB0Tic4TYB2THa14YB2DHa2T8@13g_13W>0SF]0S6<0RU:0RDY124811cW21S641BU0Q241QBU0QS6
0R480RDY0R480QBU4Q2411BU0Q2421BU0QS61QcW0Re[0THa1Goo0@000Goo000EOol00`00Oomoo`02
Ool2F]H2G_L2E[D4CW<4DY@4CW<2DY@6CW<BDY@2E[DBDY@FCW<JBU88AS46BU89AS4:@Q04?Nl4>Lh2
=Jd2<H`2:DX29BT48@P47>L:6<H>5:D248@65:D26<H48@P27>L25:D448@25:D<48@45:D248@25:D4
6<H25:D26<H67>L2;F/2BU85Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eoo`03001o
ogoo009oo`9JeP9Nm`9F]@A>L`ABU0A>L`9BU0I>La9BU09F]A9BU1I>LaY:DPQ6<@I:DPU6<@Y240@m
k`@icP8e[@8aS08YBP8U:@@Q20@Li`XHaPhDY@8@Q0HDY@8HaP@Q208Li`8DY@@@Q08DY@`@Q0@DY@8@
Q08DY@@HaP8DY@8HaPHLi`8]J`9:DPEoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo
0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2F]H2G_L2E[D4CW<2DY@>CW<6DY@2CW<NDY@FCW<J
BU86AS48BU8;AS48@Q04?Nl4>Lh2=Jd2<H`2:DX49BT28@P47>L:6<HD5:D46<H27>L28@P26<H25:D2
48@45:D<48@45:D248@25:D26<H45:D26<H67>L2;F/2AS45Ool10001Ool000=oo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo0U[F0Ukg0UJe14ic0U:D3Tic1U:D0Tic
7U:D5Tic6TYB1THa24YB2dHa248@13g_13W>0SF]0S6<0RU:12DY0R4811cW2QS651BU11S60QcW0R48
0QS60QBU0Q2411BU312411BU0Q240QBU0QS611BU0QS61QcW0Re[0THa17oo0P000Goo0003Ool01@00
Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9JeP9Nm`9F]@A>
L`9BU0i>L`IBU09>L`YBU09F]A9BU1Q>L`9:DPA>La9:DPI6<@Q:DP]6<@Y240@mk`8icP8e[@8aS08]
J`@U:@8Q20HLi`PHaQ@DY@@HaP@Li`8HaP8DY@8@Q08DY@h@Q0@DY@8@Q0PDY@8HaPHLi`8]J`96<@Eo
o`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool2F]H2G_L2E[D4CW<2DY@>CW<6DY@2CW<:DY@2E[DBDY@HCW<2BU84CW<BBU86AS48BU8;AS4:
@Q04?Nl2>Lh2=Jd2<H`2;F/49BT28@P67>L86<HD5:D46<H47>L26<H25:D248@25:D>48@45:D248@8
5:D26<H67>L2;F/2AS45Ool10001Ool0009oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo009oo`9J
eP9Nm`9F]@9BU09>L`ABU0A>L`ABU0A>L`IBU09>L`QBU0AF]@IBU09F]@aBU1i>La1:DPA6<@Y:DP]6
<@Y240@mk`8icP8e[@8aS08]J`@U:@8Q20@Li`XHaQ@DY@@HaP@Li`8HaP8DYA8@Q0@DY@8@Q0PDY@8H
aPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe0U:D0Tic15:D14ic15:D
14ic1U:D0Tic25:D15Je1U:D0UJe35:D7Tic44YB14Ha2TYB2dHa2T8@13g_0SW>0SF]0S6<0Re[12DY
0R4811cW2QS651BU11S611cW0QS60QBU4Q2411BU0Q2421BU0QS61QcW0Re[0THa1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2F]H2G_L2F]H2DY@2CW<4DY@4CW<4DY@4CW<4DY@4CW<:DY@2E[D6DY@2E[D<
DY@FCW<4BU84CW<LBU8;AS4<@Q04?Nl2>Lh2=Jd2<H`2;F/29BT48@P47>L>6<H@5:D86<H25:D448@2
5:D648@25:D648@85:D46<H25:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9J
eP9Nm`9JeP9BU09>L`ABU0A>L`ABU0A>L`ABU0A>L`YBU09F]@IBU09F]@aBU1I>L`A:DPA>Laa:DP]6
<@a240@mk`8icP8e[@8aS08]J`8U:@@Q20@Li`hHaQ0DY@PHaP8DY@@@Q08DY@H@Q08DY@H@Q0PDY@@H
aP8DY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo00<007ooOol00Woo0U[F0Ukg0UJe14ic15:D14ic
15:D14ic15:D14ic2U:D0UJe15:D15Je35:D5Tic0TYB1Tic74YB2dHa348@13g_0SW>0SF]0S6<0Re[
0RDY12481QcW31S641BU21S60QBU112411BU312421BU0QS611BU0QS61QcW0Re[0THa1Goo0@000Goo
000EOol00`00Oomoo`02Ool2F]H2G_L2E[D4CW<4DY@4CW<4DY@4CW<4DY@4CW<:DY@2E[D4DY@4E[D<
DY@FCW<2BU86CW<LBU8;AS4<@Q04?Nl2>Lh2=Jd2<H`2;F/29BT48@P67>L<6<H@5:D86<H25:D448@4
5:D<48@85:D26<H45:D26<H67>L2;F/2AS45Ool10001Ool001Eoo`03001oogoo009oo`9JeP9Nm`9F
]@A>L`ABU0A>L`aBU09>L`YBU0iF]@YBU1i>LaY:DPe6<@a240@mk`8icP8e[@8aS08]J`8U:@HQ20@L
i`XHaQ8DY@PHaP8DY@@@Q0@DY@`@Q0hDY@8HaPHLi`8]J`96<@Eoo`40005oo`005Goo0P000goo0U[F
0Ukg0UJe14ic15:D14ic35:D0Tic2U:D3UJe2U:D7Tic6TYB3DHa348@13g_0SW>0SF]0S6<0Re[0RDY
1R4811cW2QS64QBU21S60QBU112411BU31243QBU0QS61QcW0Re[0THa17oo0P000Goo000EOol00`00
Oomoo`02Ool2G_L2HaP2F]H4CW<4DY@2CW<DDY@DE[D:DY@NCW<JBU8?AS4:@Q04?Nl4>Lh2<H`2;F/2
9BT48@P67>L66<HH5:D66<H25:D448@25:D>48@45:D248@85:D26<H68@P2;F/2BU85Ool10001Ool0
01Eoo`03001oogoo009oo`9Nm`9S609JePA>L`ABU09>LaABU1AF]@YBU1i>LaY:DPm6<@Y240@mk`@i
cP8aS08]J`8U:@@Q20HLi`HHaQPDY@HHaP8DY@@@Q08DY@h@Q0@DY@8@Q0PDY@8HaPHQ208]J`9:DPEo
o`40005oo`005Goo00<007ooOol00Woo0Ukg0V<H0U[F14ic3U:D0Tic25:D5UJe45:D5Tic74YB3DHa
348@13g_0SW>0SF]0S6<0Re[0RDY124811cW21S661BU1QS60QBU0Q2411BU3Q2411BU0Q240QBU1QS6
0QcW1R480Re[0TYB1Goo0@000Goo000EOol00`00Oomoo`02Ool2G_L2HaP2F]H4CW<>DY@2CW<8DY@F
E[D@DY@FCW<LBU8=AS4<@Q04?Nl2>Lh2=Jd2<H`2;F/29BT48@P47>L86<HH5:D66<H25:D248@45:D>
48@45:D248@25:D66<H27>L68@P2;F/2BU85Ool10001Ool001Eoo`03001oogoo009oo`9Nm`9S609F
]@9>L`iBU0A>L`QBU1IF]@iBU1A>Lb1:DPe6<@a240@mk`8icP8e[@8aS08]J`8U:@@Q20@Li`PHaP8D
Y@@HaQ8DY@HHaP`DY@P@Q0HDY@8@Q08DY@PHaPHQ208]J`9:DPEoo`40005oo`005Goo00<007ooOol0
0Woo0Ukg0V<H0UJe0Tic3U:D14ic25:D5UJe3U:D54ic84YB3DHa348@13g_0SW>0SF]0S6<0Re[0RDY
124811cW21S60QBU11S64QBU1QS631BU21241QBU0Q240QBU21S61R480Re[0TYB1Goo0@000Goo000E
Ool00`00Oomoo`02Ool4G_L2E[D4DY@2E[D:DY@4CW<8DY@:E[D2F]H:E[D>DY@6CW<2DY@:CW<4BU84
CW<JBU82AS43BU8@AS44@Q04?Nl4>Lh2<H`2;F/29BT48@P47>L>6<H@5:D86<H:5:D<48@85:D46<H2
5:D26<H68@P2;F/2BU85Ool10001Ool001Eoo`03001oogoo009oo`ANm`9F]@ABU09F]@YBU0A>L`QB
U0YF]@9JePYF]@iBU0I>L`9BU0Y>L`A:DPA>LaY:DP96<@=:DQ16<@A240@mk`@icP8aS08]J`8U:@@Q
20@Li`hHaQ0DY@PHaPXDY@`@Q0PDY@@HaP8DY@8HaPHQ208]J`9:DPEoo`40005oo`005Goo00<007oo
Ool00Woo0Ukg0V<H0U[F15:D15Je3U:D0UJe0U:D15Je0U[F0UJe35[F15Je0U:D15Je25:D14ic15:D
4Tic14YB14ic5dYB44Ha1T8@13g_0SW>0S6<0Re[0RDY124811cW3QS641BU21S62QBU312421BU11S6
0QBU0QS61R480S6<0TYB1Goo0@000Goo000EOol20003Ool2G_L2HaP2F]H4DY@4E[D>DY@2E[D2DY@4
E[D2F]H2E[D<F]H4E[D2DY@4E[D8DY@4CW<4DY@BCW<4BU84CW<GBU8@AS46@Q04?Nl2>Lh2<H`2;F/2
9BT48@P47>L>6<H@5:D86<H:5:D<48@85:D46<H25:D26<H68@P2<H`2BU84Ool20001Ool001Eoo`03
001oogoo009oo`9Nm`9S609JePABU0AF]@aBU0AF]@9BU0AF]A1JePAF]@9BU0AF]@ABU09>L`9BU1Y>
L`A:DP9>LaA:DP96<@=:DQ16<@I240@mk`8icP8aS08]J`8U:@@Q20@Li`PHaQ@DY@XHaPXDY@X@Q0XD
Y@HHaP8Li`HQ208aS09:DPEoo`40005oo`005Goo00<007ooOol00Woo0Ukg0V<H0U[F15:D15Je35:D
15Je0U:D15Je45[F15Je0U:D15Je15:D0Tic0U:D6Tic14YB0Tic54YB0THa0dYB44Ha1T8@13g_0SW>
0S6<0Re[0RDY124811cW21S651BU2QS62QBU2Q242QBU1QS60QcW1R480S6<0TYB1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2G_L2HaP2F]H4DY@4E[D<DY@8E[D@F]H6E[D8DY@PCW<4BU82CW<IBU8>AS48
@Q04?Nl2>Lh2<H`2:DX29BT28@P67>L86<HD5:D:6<H:5:D:48@:5:D66<H27>L68@P2<H`2BU85Ool1
0001Ool001Eoo`03001oogoo009oo`9Nm`9S609JePABU0AF]@aBU0QF]A1JePIF]@QBU21>L`A:DP9>
LaU:DPi6<@Q240@mk`8icP8aS08YBP8U:@8Q20HLi`PHaQ@DY@XHaPXDY@X@Q0XDY@HHaP8Li`HQ208a
S09:DPEoo`40005oo`005Goo00<007ooOol00Woo0Ukg0V<H0U[F15:D15Je35:D25Je45[F1UJe2U:D
94ic6dYB44Ha148@13g_0SW>0S6<0Re[0RDY0R481QcW21S651BU11S60QBU11S62QBU2Q242QBU1QS6
0QcW1R480S6<0TYB1Goo0@000Goo000EOol00`00Oomoo`02Ool2G_L2HaP2F]H4DY@4E[D<DY@8E[D@
F]H6E[D:DY@TCW<KBU8@AS44@Q04?Nl2>Lh2<H`2;F/29BT28@P67>L86<HD5:D46<H25:D46<H:5:D:
48@:5:D66<H27>L68@P2<H`2BU85Ool10001Ool001Eoo`03001oogoo009oo`9S609W>@9Nm`AF]@9J
eP9F]@ABU0AF]@ABU0IF]AAJePYF]@YBU09>L`ABU1Y>L`A:DP9>La=:DQ16<@A240@mk`8icP8aS08Y
BP@Q20@Li`HHaQPDY@@HaP8DY@@HaPXDY@@@Q08DY@@@Q0XDY@HHaP8Li`HQ208aS09>L`Eoo`40005o
o`005Goo00<007ooOol00Woo0V<H0VLi0Ukg15Je0U[F0UJe15:D15Je15:D1UJe55[F2UJe2U:D0Tic
15:D6Tic14YB0Tic4dYB44Ha148@13g_0SW>0S6<0RU:124811cW1QS661BU11S60QBU11S62QBU1124
0QBU11242QBU1QS60QcW1R480S6<0Tic1Goo0@000Goo000EOol00`00Oomoo`02Ool2HaP2IcT2G_L4
E[D2F]H2E[D4DY@:E[D8F]H4G_L2F]H4G_L6F]H:E[D:DY@2CW<4DY@JCW<GBU8BAS44@Q04?Nl2>Lh2
<H`2:DX28@P67>L26<HJ5:D66<H25:D46<H:5:D448@45:D248@85:D86<H27>L69BT2<H`2CW<5Ool1
0001Ool001Eoo`8000=oo`9S609W>@9Nm`AF]@9JeP9F]@ABU0YF]@QJePANm`9JePANm`IJePYF]@YB
U09>L`ABU1Y>LaM:DQ96<@A240@mk`8icP8aS08YBP8Q20HLi`8HaQXDY@HHaP8DY@@HaPXDY@@@Q0@D
Y@8@Q0PDY@PHaP8Li`HU:@8aS09>L`Aoo`80005oo`005Goo00<007ooOol00Woo0V<H0VLi0Ukg25Je
15:D2UJe25[F15kg35[F15Je25:D84ic7dYB44Ha1T8@13g_0SF]0Re[0RDY0R4811cW41S63QBU1QS6
0QBU11S62QBU11243QBU0QS60QcW11S60QcW1RDY0S6<0Tic1Goo0@000Goo000EOol00`00Oomoo`02
Ool2HaP2IcT2G_L8E[D4DY@:E[D8F]H4G_L<F]H4E[D8DY@PCW<OBU8@AS46@Q04?Nl2=Jd2;F/29BT2
8@P47>L@6<H>5:D66<H25:D46<H:5:D448@>5:D26<H27>L46<H27>L69BT2<H`2CW<5Ool10001Ool0
01Eoo`03001oogoo009oo`9S609W>@9Nm`QF]@ABU0QF]@QJePINm`YJePIF]@QBU2I>LaU:DQ16<@I2
40@mk`8e[@8]J`8U:@8Q20@Lia0HaQ0DY@8HaP@DY@@HaPXDY@@@Q0hDY@8HaP8Li`@HaP8Li`HU:@8a
S09>L`Eoo`40005oo`005Goo00<007ooOol00Woo0V<H0VLi0Ukg25Je15:D25Je25[F1Ukg2U[F1UJe
25:D9Tic6DYB44Ha1T8@13g_0SF]0Re[0RDY0R4811cW41S641BU0QS611BU11S62QBU11243QBU0QS6
0QcW11S60QcW1RDY0S6<0Tic1Goo0@000Goo000EOol00`00Oomoo`02Ool4IcT2G_L4E[D4F]H4E[D4
F]H2E[D4F]HBG_L6F]H4E[D8DY@4CW<4DY@4CW<4DY@JCW<EBU8@AS48@Q02?Nl2=Jd2;F/29BT28@P4
7>L<6<HJ5:D46<H:5:D448@85:D46<H25:D26<H67>L28@P69BT2=Jd2DY@5Ool10001Ool001Eoo`03
001oogoo009oo`AW>@9Nm`AF]@AJePAF]@AJeP9F]@AJeQ9Nm`IJePAF]@QBU0A>L`ABU0A>L`ABU1Y>
LaE:DQ16<@Q2408mk`8e[@8]J`8U:@8Q20@Li``HaQXDY@@HaPXDY@@@Q0PDY@@HaP8DY@8HaPHLi`8Q
20HU:@8e[@9BU0Eoo`40005oo`005Goo00<007ooOol00Woo0VLi0V]J0Ukg25[F15Je25[F4Ukg1U[F
1UJe25:D14ic15:D14ic0U:D6Tic5dYB3THa248@0Sg_0SW>0SF]0Re[0R4811cW1QS68QBU11S62QBU
0Q242QBU21S61QcW0R481RDY0SF]0U:D1Goo0@000Goo00000goo0000000300000goo000000020003
Ool20005Ool00`00Oomoo`02Ool2IcT2JeX2G_L8F]H4E[D8F]HBG_L6F]H6E[D8DY@4CW<4DY@4CW<2
DY@JCW<GBU8>AS48@Q02?Nl2>Lh2=Jd2;F/28@P47>L66<HR5:D46<H:5:D248@:5:D86<H67>L28@P6
9BT2=Jd2DY@5Ool10001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<007ooOol0
0Woo0VLi0V]J0V<H25[F15Je25[F3Ukg25[F25Je25:D84ic74YB3DHa2T8@13g_0SW>0S6<0RU:0R48
11cW1QS681BU21S60QBU11S631BU21S621cW0R4812DY0RU:0SF]0U:D1Goo0@000Goo0003Ool00`00
Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000goo0VLi0V]J0V<H25[F15Je25[F3Ukg
25[F25Je25:D84ic74YB3DHa2T8@13g_0SW>0S6<0RU:0R4811cW1QS681BU21S60QBU11S631BU21S6
21cW0R4812DY0RU:0SF]0U:D17oo0P000Goo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo
00<007ooOol00Woo00<007ooOol00Woo0VLi0V]J0V<H25[F15Je25[F3Ukg2U[F1UJe25:D84ic7TYB
2dHa2T8@13g_0SW>0S6<0RU:0R481QcW21S661BU31S60QBU0QS63QBU21S621cW0R481RU:0SF]0U:D
1Goo0@000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`9W>@9[FP9S60QJePAF]@QJePiNm`YJePIF]@QBU21>Lai:DP]6<@Y240@mk`8icP8aS08Y
BP8Q20HLi`PHaQPDY@`HaP8DY@8HaPhDY@PHaPPLi`8Q20HYBP8e[@9BU0Eoo`40005oo`000Woo0P00
17oo0P0017oo0P001Goo00<007ooOol00Woo0V]J0Vmk0VLi15[F15kg15[F25kg1V<H3Ukg1U[F15Je
25:D34ic15:D44ic14YB2Tic4DYB2THa2T8@13g_0SW>0S6<0RDY0R4811cW1QS671BU31S631BU11S6
0QBU21S60QcW0R4811cW0RDY1RU:0SW>0UJe1Goo0@000Goo000EOol00`00Oomoo`02Ool2JeX2Kg/2
IcT4F]H4G_L4F]H8G_L6HaP>G_L6F]H4E[D8DY@<CW<4DY@@CW<4BU8:CW<ABU8:AS4:@Q04?Nl2>Lh2
<H`29BT28@P47>L66<HL5:D<6<H<5:D46<H25:D86<H27>L28@P47>L29BT6:DX2>Lh2E[D5Ool10001
Ool001Eoo`03001oogoo009oo`9_N`9cW09W>@ANm`9S60QNm`9S60ANm`IS609Nm`AS60QNm`AJePIF
]@QBU0a>L`9BU1a>La1:DP96<@9:DPU6<@Y240Hmk`8e[@8]J`8U:@@Li`@HaPhDY@H@Q0XDYA@HaP@D
Y@XHaPPLi`HQ208U:@H]J`8mk`9JePEoo`40005oo`005Goo00<007ooOol00Woo0Vmk0W>L0VLi15kg
0V<H25kg0V<H15kg1V<H0Ukg16<H25kg15[F1UJe25:D34ic0U:D74ic44YB0THa0TYB2DHa2T8@1Sg_
0SF]0Re[0RDY11cW11S63QBU1Q242QBU51S611BU2QS621cW1R480RDY1Re[0Sg_0U[F1Goo0@000Goo
000EOol00`00Oomoo`02Ool2JeX2Kg/2IcT4G_L2HaP2G_L4F]H8G_L4HaP:G_L8F]H6E[D8DY@PCW<6
BU84CW<8BU84AS42BU8;AS4:@Q0:?Nl2>Lh2=Jd2:DX28@P27>L66<H>5:D248@<5:DR6<H87>L28@P6
9BT2:DX6;F/2?Nl2F]H5Ool10001Ool001Eoo`03001oogoo009oo`9[FP9_N`9W>@ANm`9S609Nm`AJ
ePQNm`AS60YNm`QJePIF]@QBU21>L`I:DPA>L`Q:DPA6<@9:DP]6<@Y240Xmk`8icP8e[@8YBP8Q208L
i`HHaPhDY@8@Q0`DYB8HaPPLi`8Q20HU:@8YBPH]J`8mk`9JePEoo`40005oo`005Goo00<007ooOol0
0Woo0V]J0Vmk0VLi15kg0V<H0Ukg0U[F2Ukg16<H2Ukg25[F1UJe0U:D0Tic15:D8Tic14YB0Tic4TYB
2DHa2T8@2Sg_0SW>0S6<0RU:0R4811cW1QS62QBU0Q2441BU81S621cW0R4812DY0R480RU:1Re[0Sg_
0UJe1Goo0@000Goo000EOol20003Ool2JeX2Kg/2IcT4G_L2HaP2G_L2F]H:G_L4HaP:G_L8F]H6E[D2
DY@2CW<4DY@RCW<4BU82CW<BBU89AS4:@Q0:?Nl2>Lh2<H`2:DX28@P47>L66<H:5:D248@@5:DP6<H8
7>L28@P49BT28@P2:DX6;F/2?Nl2E[D4Ool20001Ool001Eoo`03001oogoo009oo`9cW09g_@9[FPAS
60AW>@AS60AW>@9S60IW>@YS60INm`IJePAF]B1BU11>LaI:DPU6<@Y240@mk`8icP8e[@8]J`8U:@HL
i`8HaP8DYA@@Q10DY@hHaP8DY@8HaPPLi`PQ20HU:@8]J`HaS092409Nm`Eoo`40005oo`005Goo00<0
07ooOol00Woo0W>L0WNm0V]J16<H16Li16<H16Li0V<H1VLi2V<H1Ukg1U[F15Je85:D44ic5TYB2DHa
2T8@13g_0SW>0SF]0Re[0RDY1QcW0QS60QBU512441BU3QS60QBU0QS621cW22481RDY0Re[1S6<0T8@
0Ukg1Goo0@000Goo000EOol00`00Oomoo`06Ool2Mkd4JeX2Kg/BJeX8IcT6HaP4G_L4F]H4E[D2DY@4
E[DHDY@@CW<BBU89AS48@Q0:?Nl2>Lh2=Jd2<H`29BT27>L46<H25:D248@236<:248836<848@65:D6
6<H27>L<6<H27>L68@P89BT2:DX4;F/2<H`2=Jd4>Lh2?Nl2DY@2Kg/5Ool10001Ool001Eoo`03001o
ogoo00Ioo`9g_@A[FP9_Na9[FPQW>@IS60ANm`AJePAF]@9BU0AF]AQBU11>La9:DPU6<@Q240Xmk`8i
cP8e[@8aS08U:@8Li`@HaP8DY@8@Q08<H`X8@PP<H`P@Q0HDY@HHaP8Li``HaP8Li`HQ20PU:@8YBP@]
J`8aS08e[@@icP8mk`9BU09_N`Eoo`40005oo`005Goo00<007ooOol01Woo0W>L16]J0Vmk0V]J16Li
0V]J2VLi1V<H15kg1U[F0UJe1U:D2Tic34YB0Tic3TYB34Ha448@1cg_2SW>1SF]136<0Re[0RU:0RDY
0QS60QBU10aS0PQ20P@Q100010@Q10Q210aS1Q2411BU1QS61QcW3R4812DY1RU:1Re[0S6<0SF]1SW>
0Sg_14Ha0TYB0U[F0W>L1Goo0@000Goo000EOol00`00Oomoo`06Ool2Li`4JeX2Kg/2JeX4IcT2JeX:
IcT6HaP4G_L6F]H2E[D6DY@:CW<<BU82CW<>BU8<AS4@@Q07?Nl:>Lh6=Jd4<H`2;F/2:DX29BT26<H2
5:D436<22482124400041244248436<648@45:D66<H67>L>8@P49BT6:DX6;F/2<H`2=Jd6>Lh2?Nl4
AS42BU82F]H2Li`5Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0
ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool0
01Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(corRelation[Flatten[sample], 
      Flatten[Abs[InverseFourier[compressedfSpec]]]]\)], "Input"],

Cell[BoxData[
    \(0.9299314149859214`\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((2)\)\ \ Wavelet\ Transform\)], "Input"],

Cell[BoxData[
    \(\(w = waveletMatrix[128, coif6];\)\)], "Input"],

Cell[BoxData[
    \(\(wa = w . sample . Transpose[w];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[wa, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFF0000000000FF00FF00FF8121220000FFFF00FFFF0000FFFF00FF9E5DD775
AD1700FD68680000759793B50000FFFFFFFF0049FF00A0606EFF00C795BA867C77989B93
55BCA095197A7EA2B47E9F6F659730BF21581EBC28CE53A88CB4C1004508E90098A18DA9
E5D365C64D6ECE53318733AE4A6E9473828AFF00
FFFFFFFFFFFF0000FF0000FF00FF00000000C7BA54000000FF2CFF00FFFF00FF42FF7D00
5D85EE00D0505300FF00CC7000FFFF4688A3E2FF00FFF4467DFF007F5078AD6099E79F7A
5D4E975A98464FB06039739E718B4CCE216989CE186355D27921700061FFFF7F1CE98A5B
769A9E47D1FF00CE7E8F749F8E6E847F8598FF00
FFFFFFFFFFFF00FFFF0E00FF00FF000000FFFF362679FF00FFFF000068FF00FFD73C6418
58FFE0CF005837CC624BED9A0000FFD300C33336668D936677FF00A88B9C96944A836F72
7B5B7049E2166E9D95AC4464915E995CD46B63B58EA87577BF2373350000FFFF974C796E
A15A964A4A81CA663BA15D7F86677F82785AFF00
FFFFFFFF00FF000000FFFF00FFFF00FF2EFF00FFFFB783FF0000FFFFFFFF00FFC47B6E5C
869BFF00FF65FF00D7557C6FC778000C00D0D5FFE175766F9DFF00B3708676599D8D9860
5ACC7A9D73BFAC92B90046FF7F003FCD733495A74D966B9F6E8B8DAAB0435972246A498B
4F4A7C8EB9536552947652A68B6782888574FF00
FFFF00FF00FF00FF0EFF00FF00FFF500005F00BCFFFFFF00FFFFFFD2FF73FFD1AC6F56E5
6FA34C5F864B859691D4FF68FF00FFFF53C969FF009DC9757C84FF6F47964DA7867E764D
CF9F87646677BA54B1577F729C2A9ABC71015D8E79AA8C5EBB7ECEFF00FFFF2ED4AD77ED
B800779592FF00F7FF574BB9827A867D828066B8
00FF0000FF00FF000000FF000000FFFFFF5F0052003200FF00A4FFF20000FF009D8356EA
6A47754269DD083A877FD49400FF00FF7E8903FF00FF2D898700FF526798927269AF92A1
7C9271947AD0D6367B6E9F497AEC5FBE686D73926180A7235B89000BFFFF0058CC51697F
8B863488C0FF00ABDA9F64896589717D6F4100C6
FF00FFFF00FF000000F900FFFF00FF0000FF00FFAB004C00FF00FFFF000000FFAE427C29
86D2F100F0F78DA281934DE21B00FF771095FFD5FF600000275D008F6D96A9A1A82C8773
7B826873D150AB834E0CB722D788529A71A76C665B988A6CAE41A179191272E669906697
5A87BFB69C5D7DFF695F697550C1667B6788FF57
00FFDB00FFFFFF0000000000FFFF00FFFF6A24FF4500FF00FF00FFEFE6FF00FF46D0A8B6
9B2FFF00FFAA9F0049ADB3D9003FFF000000DED6BB1F87567CD000735F6D4EA98EA579A7
64AF7982842E92BB9A0090C0A15C72AA622075747D8C998097A5A8170EA4FFD8B67E9549
23AA31BFB0717B7C73666D9863738A7C827BFF4C
00FFFF00FFFF4E0000FF00FFFFFF00FFD1FF00FF00E38D00FF00FFFFAEFF00FFBC21D890
26C1FF00FF8000FF92727E18704C00FF7500FFD19E8386627EC5009D5A595082A0608A79
7D7D7B3AA8998A84700099C1E553A44B97807B8E698E7093A345A9427E7B7B18ACFFDF0F
00A100B897826A8D8991849572817E7F7F7FFF1F
FFFF0000FFFFFFFF0A00E600AA00FF000034CF24FF00F40000FFFF853451FF33A7CE52F6
1C985AFD5E63B6FF00C9B2B619FF0070FFB23C6055549A757882E70786349453579C9C2F
A29A8EC2927A8F7EA49C848C6C6C8567C0E3731C3BCA9D649B686D4F00FFFF0045A63678
C6677680CC769085755D9F5B717A887A8175076F
FFFF008700FF12FFFFFF00FFE8E688B429817766CCFF00FF00FFE04181D24B007E1EEF23
854ED6D14FC3A76B00FF0000FF00FFA37BFF15915BFFC5D889A4A4AB2D8F9571793D9194
5E69976688574F1B9CAB59837DCDC198A9008F83A8AB469200EC72FF1300FF1277AB8751
B3FF49A57D7A9149D81F5FC0BD967D8680882C69
FFFFFFFF0045358F9FDB5FFF00D82BDFBCE73FFAC100FF00FF5FFF4C8E896DA4E465C8B7
D7744D6881A4D9803F5CD49AFF00B70FB98980FF00FF8A717E87C6416E789D7A837F4693
82B08E82886D628D975384717F30C17E6AD05BB3623D60595F7EFF0000FFD4A5612B8E5D
72BD747A88FF00AB747B74917B7C807E7F87497D
000098FFFFC300008232C20007C0000000EA474BC4CF00FF6360FF004088A4FF97FF157C
8C862B7A55736F3C69FF2C0700FFFF384AA578A100BB59C36DB3543C5684318B619E7F4D
6D817A85804589957A889C7D838676A45375B72D88D96DAB008A9877F90047FFD29C657E
7CD066FF20EE159AA342AC7C59997D7F7E909E7D
00FF00000000FF070000FF001700FFFFFF0013FA0087DBFF00FFA8BA9100FF004547E28B
84A05E755EAE29C9567A80D14BFF00E6FF67A0393776916E533CFF61786F737E6D648775
8A94AB1D2E87BA717F8165738B8B954F8FAC5C9A7F71A79081872FC88FFF000EFFFF6D9E
7A7A916B637B796B7B3D7B7E86807E7D768B00AE
FF00FFFF00FF007478FF00FF00FF000000FFFF00FF980000FFC43F00FF000059C65E7258
7DA32E48FF009A7F229EFF00390D3BFFFF34174500FFFFFF000D008F83A381805A578789
69627D5EB439B287BA1699D202607D7EC43B7C8B708A908814C05F60677146A28DB9AFBD
5B6572BC88319C668994CB82D68587524E97FF32
100000000000FFFFFF00C80000FFFF00E60D00FF002BB0F40000FF00FF00FFFFFFCCB69A
9688CC00FFAD2D371DA9BF62B455B518004FFF4700008EFA9490FF5D7C6E786F72B56CCD
5FA56C81AC69776D00B2FF00B192707156A36255B2477B98699F538687706F916E7E6C81
3C93FFC2B3747B2561545D9D488A8A62898900AD
FF00FF000000FF00009AD200FFFF53FF9C76FFFFB10053EEFF6AFF00FF42D78365C356AE
627849FF848EA6ACFF0FCF2FAE22B41741CD00FF2F00FF747F45ACB3789D5C5D714B7F90
74A56B916C838664FF6930AF8D7A7D81898DAC481D6D7B915E786794667D4E9E8F5D7462
9CA987258FFFFF001D8A65C17B7E808B71706968
000000FF0000FFFFFF00AE000046FF0000AE00FF00FF51E80F0000FF2493ABFFB06C7022
ED8000FF00FF00FF88737077A88C982DA89CFF00FF5C96708A5A568977697AAC7863A985
607282B3AE8C680096FF46735BFFFF00FF2CA17B86727D87847661837B7E7E79806F73A4
22C7FF71008BBF84C3637A659853818F78763B77
00F3FF00FFFF000000FF46FFFFFF00FFFFDB00FFFF6A37A900FFFFFFCBFF00957CA7B5AA
5973FF00FF0BFF2E65B27B6366848100FF00FF9D4CA5B5697FA80099845C7B749CE3B266
21BC5E67A66190904100EC89F13E00FF6C9F6B946CA07A8B6E64488E836F8F50860051FF
120044C669D361AA8EB0B98E6F807E7E7F7FFF32
00FF0E00FFFFFFB0BA000300F584AE706A22CC03008CC273FF00A47678903EB18C896C75
589C5CAB624FFF00AE8F7DD16EA100FF00FF7B7F807977807E840E7C4464646B6D5F9485
7B9D887C81845F85829E8293645A68FF00AAAD607E627E8273B552527EB26320FFFF0068
DBB9747E807A807D7E79747E7F7F7F7F7F7FAC8F
FFFF3000A93ED2FF5100000074976A6F2E4BE9B5FF88450000FF32359A71D2516966C775
68FFB53A958145FF006A79897400FF00757E8891985069807F7DA2A9737C7F927F94A17E
337A965BA1B035AE624B908E786BB55CB4912BA2D042C2716872938DC50BFF6D00FF309C
997D7B935F83797E7F607B907E7F7E7F7E806384
F8006394777D7E844BC5FFB5BE51A652A400A58E3D00B4FF4847DA937E5D7A7B55A5436D
8AC6A50292836996FF00B4991DFF001DFF2EFF82A958E2797C628AA388B67360BB748629
757B8E5EA1C1927C9A5884798381842A7782929829799C68A445983752FF009187B1C15F
83564BC65B79708E8D6A57517B7D837D81548AB4
FFFF003BE6FF4EFFFFFFFFFFFF22928B94C1CE105AFF00FFA8FFE077BFFF557CB672CD58
978889F639695728C0FF00FF2000FF8763CA008E7FD9727A969D53039744847F7D835988
7F63787AA9B0498F86824D807C675C88AF9FB9688D577788AFBC3CC2C100B861657B8765
7DE2667C8B478A7D45AE6735AC8D49957E917543
FF7C7A00005773002F9200FF4CAD597F7FBBE497D61954697FC46A60AA6DA8673FE462EC
25AC8030A145956F5B74FC00FF452867B8567E7F984F6752787A368E897E9665909F807E
A8977E47907C6F8BB957927F9B3D997B8E4E7B6E77318493A00083A833AD4E8E89B28A77
7884857D7E827668A8957E675F737E7B7F735787
C4FFAA6000AB549F575C00A16F92622F00F356B393CEFF008690987C828CAC69395C8A7C
9371C669658C65A67A354FFF00FF993B87508D6BB35881807E92C3827E8278A97D5F91A4
B17642978A6B889067887E6A7FA34F8F68EC8A97A562A34685FF5D20F1008A8853787F8D
7059827F8747556772967E80807F7F7F7F91536C
0CFFB04877714462A869FF9D007C52558E24FD4000007C47A0A0FFD16F6E4733A9391768
7371ADA4787A5F776E883C69FF005F6F899A73FF009B767C7F67636C7D78C9787F4BB84F
AA008A7285738E80788D7C857AA56758A155EA8D4AA92EAF7A574BFF00FF89818A40847D
828F727FB0F400DE69F0718C7D7F7F7F7F676A87
0000005416ACC24B20BBDE3FFF576CAA00C39D88B2BA25FFA766009A6E7FC7B385759AA8
79B371A78376792B1EC863B400FFF87887735417FF6D29778272C2555E7F65AD6B7B9A73
4C8C81669C9C47847EA663867F707AAB5760A33AC5431B6B6F5E0C54FF00C1A542A0897E
76BD7453B01CC12370A1944C9575807F7D80576E
86BFFF8EFF1900F1C844BE5200366B7D7FBB66E76A3675896AB2FF672C1D6BE45E388A7E
753A7B696FA470875F00E627D2FF2E5973D98885004F47CE8B9BA63D7795AB5B9D5A7F6A
767F7F71774DAC867E6F808B84937D6C817E948572579C6863B2975454E87EAE68877F7B
8CD59F7E2C705F78AE72917D57A07587597C8085
6100B91F44AF9C8F9F8FFFFFC78C81FFFF6976FA3F6B2AD3813F679C7BAB71342D775CA0
67708C7D82B74F5A5D7F007A9DFF009DA1587F679D897D7E72A37B66C6897C7E6887705F
9C8E913B715F7E78807F6D987A9A578584565A7F7E7AA5A78262347966C83C375D647473
7C5B58857B718F90AEB67E7F817F8280809A6C81
00FF1F002000FF7900AAFF00D700FFE9166D7965C799FFFF0020FF5D9300FFB6618B7456
F24AD96C63835BCC459F6A8871B000FF626863B6914D7F85763EFF9740AD9FB280538877
7A6784897EAF6B5E7B817F61807F638E739D6395854A4CCE4CAA7C9F9A598E00CF86772E
7EB37C6886C96883D9917C7E7F85787F797A00A9
FF0000FF00FF00FEFFFA00FF00FF000057C09EFFF227BA00FF56376B00FF0078A45D8561
7BDF91AD0B5BF5B26E1B6E002D5C00FF56CC73962FB28739FFFF008E7B958F8E61887180
89787E5D8C67726B938F53A7803481809984649E893B22BE950775674D734779CE907151
787D8A6076A683968F60848E496D6AD5FFE3FF2A
4000FF005BFFFFFE4DFF0A220000FF5ECF6E5C006CD17CA79948820000FFA1B6A0BEA043
8579DA595DEFA27785A200FFA350AF9F7A7C789300FFFF0078B8A567847173707CDA4297
A06B817F7B806A85666E854344FF4AA5677B86977D829F00FF13988E9E5E7B7F38987085
8C847F7E79769D4966868DAD011B40C17A97737D
2683FF6307FFAE9FA6BDADAA0000318CC96F696EDB7F456A88006A00FF9F3E5C8367948B
75A68C9887A63C7E207176C3698E76D1BF49A79E8E52A78800E268777F797F7E7A4E7C7F
868C7C7F6F92725E6F8A689951927B8C93899D4E9B75B9698E7369787F8D737C7BAEACA4
8965895973C9728DAB703DA2E61E3D8DA8938C74
A953FF2CD3C95DA6537B4E657D007FA4C280B42C8A8F91A06B9D57FF00A747A48EA7AE21
95249D6B199260608B91164863C666826E8B898B00FF00FF8C915D6D80737B797DB14296
A254847F9F528286843486847856996B996F808976835DC2B08F6D7FAB8E8479A4776F76
817780817CA27261A5DFA20765FF8C6990709983
7F8BBC8FA200A80000823CA6FFFF71C75CB74CEE465824D0D1490075FF87904E9BA5916F
8B905D98428871A39B36E3988A685BC68658D500FF00FF8E7D8CABCF60A86569658D7163
7E72887D7D88A280739F87ABC2827E7D68C65069A54571B5419F628A9B7A81968CA48188
6D85596B647B9AFA04038094767D7E7F7F8A6168
E5EEFFFF2300FF9A009700C400855EC3048A35FB8CD87B5983AEFF00AF8BFF7E12838C56
AD556F7C627DFC8C85BD5BA0759D8133897000FF00D8977C759794BD80A66B5A8856906C
7D707BA8716C7073A269948CB07B659986C8939986F9747B82967475967E7482B64B7E79
70695B00E3BB3B16AC83786BA9807C9060D24B79
D08B00000F00FF00FFBC7BD600E80000FF00FF07B79C76435300FFFF8D9DC000754CB4B4
3C51FF00FF00FF0058887A776674797B940FFF00EF8385A1775EA45A9D7B48558B4165AF
8A946C42964DABDC6D1EFF825200A1EC1F90736E9A967C7F7E769B7B7D787F8569AA89A0
7E707DFF3C2580785F7D6D8D55847B92747A6B8A
007C5B12900000FFFF03C68B0043FF32B429FFFFFF24AF68BEE60001535DDD00CD004A8A
B35500FF00FF56058A9A6B937180787268FF00BD374B92CA758004D17C89A5525C33416C
D26A9A6E3BA42F5DFFAD0077FF6E2DC69F7578875E827D7D8187877D7E767999815DB173
78E28D367DB4916858A38544BA8C7C7E7F7E774A
54BCFF9EFFFF550000B900FFAEFF00F3733D009AFF598B8AC2FFD5C49AB300FFD371A36A
5E7AB200FF00FF009682A15781B20DF68F6AB47C578F8C717F85E30022317696AA7B784A
4C608D45686C9FA15311ACAB590085BF9D3F89766F7981845B899079A089A45E82866BA3
9E8866646CBC735BA1898E89757E7F7F7F7FAE43
82814128D79CBA3466BF47FFFF74455E749563FF7EFF44923100C96A8A78A9754F966B82
A7817E916DFF00B493A06F6A8E7C920AFF00CA829C888C7E7E7D8E456B6B79A49A86C1C8
52A1A6929068817B8778838D58FF25A5AF98568A899D7A7F826D577B7E7C719E534DC15C
58638F6E955387687D8A8C7E7F7F7F7F7F7F7390
60A9FFB9ABD40082B849A3CDA09D6056896DB66300905B0ABB00957F7D914CCD6172745C
766D30A7038BFF5F6C887A62C451AEFF00EA7A7E7D7E7D7F7F843D617AAF9CA4875C4D40
914E88725BB4A86183825A63A970D33E08CF70876D957C7F7E6886657C80CD6164D03E4F
75AB71817E807E807E7D7D7F7F7F7F7F7F7FA152
2B813A008C64AABA8A8AC1007377C97F4DA05F80CA6762ACFF936B7F7E7E7B937E5937C2
915696857638ED4E8F80806696A34340FF44747E7F7E7E7F7F7F66929B8D7660A9A47271
97757B7E7675AA7377CB75669B7566693195B871837180807E6C71987DA2978FF21698AB
756B9A7B7F7F7F7F7F7E7E7F7F7F7F7F7F7F8596
30597FFFED5FA61D85421001868F85677B835E98B7A0BAA4E8E7778F8E7F7592745A6449
A9516C8F70AA98AF9EA890A5538EFF0097717F7E7E8E8B7E7F7F7A696A5487458C957F9A
926EA7805A70938B8C7A77847EAC8768C07F6190AD855F7785AF78B25CDA7DFA662B948D
907D7D7F7D7F7F7E7F8D7B7F7F7F7F7F7F7F839B
A8D66B35826A82C2E655B33D6B81655F5475EEBE678B9275009653358575974A7A796A8F
7BB2879C7454BB7900C67D827F76FFAD6C82939097637A7E7F7BAB7CA9738456C4A27181
5B887F6C9E9456878A8A7DA65C776A622F90927AAF89748B7676916CC74584827CA66988
7E807D9278807D84746CB7837E7F7F7F7F7E6C9C
79808BBDC4C88F456B0D86B89E8AB634BE25758F81245B57278B9B9E809A765E93807184
7772A7398881716ACC6392C938810093A4827C557971AE7C7E9A7FA2527C7E91647F7F70
718E806D9857687B4A71807D807F844B9E7973830BC3884BAC8640AF34F98570925B9256
8B7DB27C877DC2B0817F67677F7F7F7F7F936FA7
A400F98C0000828565B5E73900B38D1BA0C654866586BCC858001DAF7CA4CA9B4F7471BD
5B8E7772807F7A857800A378A2FF585D760097A298785E817EA06E45419679456F7F834F
83A867D24B5E718450807F7E7F7F806C787DA5827E00B5838B35AC7DA237589E4892657F
6321974F7E985281826E90917D7F7F7E808C7DBF
CFFF6A7BCBEF57B77F80DDFFFF37CF0BBA2DB57A9C9E8AFFD9F4D975524D6E81A8866DAA
BF3160BA8B7B998175F047AE62A885AC8EC8499078B05D6F7F78595B81678A767F887E9D
7DA3539A5CA095829DA2927E7F7E77CF6D8B726AA9BF685EAD8BBF79B96656A0765F8784
89A65DA07D9B7E8057B387807076877678B8775B
5CB042CD8C99C77EE971506CBD6668A85CBC50600080384D4756BE87937C915C77607469
7467B0AD5C7487893F72287D2B14B081A1B3CD7C7079A6DF7A7CB86384B17A7F8066987A
81638A75BC6E646C506661807F717750B977888B357C9A4F9AAF6F777C737E878C857F99
42A73F9D799F7C7AB3477EC27CAE77867F7B689A
ED88B24A489B548D4B65D68A659D76997F6A9C969F9B0F9C979C796C9183415B8F5F8CAF
74C343618DA87A8C6C6CBA4476915381577A788074A66D647A8597956680808665737F83
4BA67A86968F8737AC588A7E72B6857C678C3F8D94B063AC75B7A16D8FD56D926E7A6957
7F8E807D7F7D867A7B737F6D6E78797E7F848773
86975F8C599BA4646A9C8C6EA074857EAB723E637F70958DC48A83B67C7F8DB45A696662
89AAAE9084057578A481564BE0747B9F5F73887D815D807F7F7D5D7B877D859A74808065
667D7F899C6E767566837E7EA8486A7F8B736C587B55C064AC00878C6440547DAB107899
814E837F7F7E769765817E7F7F7F7F7E7F7B7285
B2BA8297327B3FC26AA3345B62727A745974706166C0D5B160A08A897F6F84884F8E7EA1
4EB86784878870896D6275AD32868F54798E7E89667E7F7E7F73A97F7F7F94977E866D8D
9C79937FA26C8866827E7F87739C837E79A8789E9B9B6E665587699E948B877F678E7D86
87747F7F7F87818B8F7C7F7F7F7F7F7F7F787968
97317394758F8A619F6E52FE986D929DC1885BDBBB7BB000B14B5D656D848097A899C53C
887C4E835E68A1909940AD2333DB3E89937979646FB2717F7E8382807F80586A7F995490
65BF657A7E7EA07372837E5F6C5E8F827C94967C979569846C9ADA0D619C65AB7B848266
75AA7B7E7B3C947B5DAE7A7F7F7F7F7F7F83847F
A6E8A3507C4E9A388E887E5810AC69467E6FC68D517D7F23739BA0408F897B6E92636AAE
86729B8189859BA16D9C958BF451852E8F8085862B73857E7E8A90637579BA7B7E6A9778
B08A827F7E7B9A7D923A8380826C965B9D78577F7BAD82AD9BA47DA0245B7577A04F847F
7F7D7F816BA47377B576807F7F7F7F7F7F898B80
40FA83838463707E8A92CC89008ECF958C5D7F76799468978D98C0867C88943E67716487
76857E86797E7B6D784E837ED2277073898A8A7400A17B7E7E8C81AE9A8264857D758CBD
7AA87E76867C7D7F7A9D7C7F7E807C847A7798B1487BA47B7CB7FC6262718E898241847F
7E8875847CC8567176997B827E7F7F7F7F8B8E7B
B400473242A3A2815A8F9644FF60856770E16E7DA1207FC48E490075718488D45B969A79
91A87C7B817E794D35AC7BA6569F947C803DB600FF0081887E8050726E7F81948897A874
83BD588A71A0847E8072807E7E7F7B966967AF6A4DB292797E4C665EB93C898F7D837E7F
8327A7576E00E89C81957F42837F7F7F7F7E8B64
555A91A54277905E4F6998500DA35971646993947F8594BE8667B387BF826B7033B87293
776D639E887D807C46FF57596D76A07A867245D3006FCC66817D7691867F9FA955997D76
B376836E896839847E9766837F7B7F7E7F79841ED56046A5647A9EA14A528D8F4D8A867E
79A141A7DED935B47C3D649C847B7F7F7E7E8026
9BA5B36CCC4062A98F92A4A18F2871757EB06C67737D8E403861C36B586B92CC6A897CAD
B05F8072B0867481C201668B8A98846A5F67853F676560D052B3A88380756B5BA18461BD
5EA160914981917F7E77725F7ABC7A7F7F8472A86F57AB9476B9B3665B633B85BE645B81
7B4E8A793E3F715C919DA7795EA57B73A786697A
887A7DAB8898782D5BBA66849577B3A25E86A3238E917F6E719A588E5A86636D8F355893
654CB782395A897EA97B8F3F5A748B967DAB899F71CC6A3BD534875C72B523A67D655891
A578ACAA846E6B66807FA98F81548470807E6D927D827872B6236A1856BE2C881471817D
82B9955DCA76877D6B4E4183975E6867945B8D80
3A74A4B59592898A9A536840849ABE689F5D797E85605263A370717C829E876C6F8E8053
7D53467FA6BB8580825B77716390A99155745FA5816D808279A07185C05D8371C5A962A3
8A70ABA4B3B693997D7F74AA59AE868A7E81847D7F5D4B717D706D96715296468A6D8A83
7F6F767D8D8B77807B8C817E7E807F7F7E976E7A
A3AA84918639A068A7909AFF138C26BBC47E889FA49A7B8C1D6EA84E8A72B981947A69B7
957C60807C9B7A959088527E4D8774598783AC5298A0847E7E7AB3196A3B7ECCA4877D7B
84A5BC607E2999957E7F7F7D80968C8B7DA3927E7E879C937F7889938167A68A51A19EAD
79928F845E7F878F8359827F7F7F7F7F7F7E658B
9DC87D810077BC00B16E8B6B598F6674509474B853648CE3B0D95A7083858933617C7575
A788A0817CAC518B8265BA8A93EA51794BA3715E7B67807F7F814951B26F8A83A4958E75
7E78569E737C735C827E7D807E9E6C8E806C807E7E798CA77F92927C76E53CC79EC35D65
8766857B8B5D848F968F7E7F7F7F7F7F7F7F8B44
00FF9000C800FF75374262005F20F25A854BC47487993F2B005753B87B52F5C044797885
52106464737F943F5A905AAD5F00539D6866AD6BC3817D818369FB8D48879F8D89A27A7F
7E7D5994A1975F9E5D8C885D807B8582696D679679AB2A649A82769B6400D94A8E32A399
7995909A6C8B565EAD7A7F7E7E807C807E7F3C84
FF0000FF00FF00FFC0A500FF00FF000059C383DF9B78B60EFFC6677554A5009795787E79
8CB0ACB73AD9939E668794B22974088B6E785FA1588D851D00FF008B7C8E89896966807E
7E81876B917C9F83519C718CA2A07F7D9282728A7E878E6A8F785E5D5A9D5AAE81BD728C
8C7C8879848E8195778D737F854EBC50533CFF26
7616FF3CE1FFAE6C7C6BA03A20FFFF3596699C8E6E654EB4B0A054E300C9FF5D79848963
7CCD2FC09948937C924182008BA3746D5B8A8A6A5BABFF00FF00FF8280877D7F7DA06E80
8D737F7F5093496188625D667936A181786D7F878B573DF218A5867F7A94739176715D8E
9F7C8070869377A284979CB26918F2F00037556E
9353C98B8CF9C6877289566341FFDB708568727E797F5D46BAC9775277FFF67B807E7E83
7F4B7B7B5C756D817D7E932368BB74838D6F8187779529DCE227E3787E7C7F7F7F7F7F7F
7F817E7F8C5D6A84C18C858D776A4E827E857E7F7F7F7EAB425EA7795B967693709CA08A
8E7C7F7B7B828167B01C9B63C46B40D3B6568B91
8D34B43576C436646547A072AFFFAEB16BAF7E506778787A7C789A7B7500FF546E848A40
8F8A868D98886E6E924DA9B2787B7F80B584722A9B89B52FE1437DB07EA17A7F7C9B6E80
8C5A837F808C9FA56A6FA687938E7082813785818C613CA2799A787F817D7F7E807841A5
8A7E7B94A272846C7B977C816078858914897C90
7B94577585C5CE5A835C8299A18E707BAC865056B0C7927F697A8D90FF387C767E8C8672
7BA94494825B59697187BF797F7F7B6886A76592687500FF00967A7B7E7C7F7F79BC6A81
8E7F7E7F6E918F457A3E6F8B40B3814CA680706B918E838C7B7D7F7F7F7F827E87BA808C
908A799277A77B727080978DB09C4B7F8B788281
3FA6F29B8496659E6E938D8F4000218C7E7B896F9589896CF84A5B8EFFD251627D777B87
7D7D81827C958C75A56D514B6E909D7EA56C87837230C600EB9FA17C807F7F7F7990817E
7B827E7F7F7E7C807F8782567DA469668B7D6F907F79AE977C9A6C7C7F8E5581B1819490
74BA7D6D7D9A716C7C64926FB043A97088C66C5B
A28D8F09E4EF64661C7B742311008BBEB7942E499A2941FF9FB04C00006D8C6C8831A64B
869FA85251605F75A992937776816CB48F828982FF7A79958A917B837E827B7B9E5B6E81
9467817F718E7DA1777C7F99BB78936D907C7FA157817A8E51CC82AB70907F7BA3A14F81
7F7A82677DA24FBA7F8C72867EC98B6A91787F82
8D6EBB517023A28CA084B27EE9AE9871796F727E799D844380758FFF1B8B1BBF666D79AB
73A07487A98E7F777C94998A7B7D807A7D7D916400EE1BBE76806B4B7F57979592838085
6B947C7F6F8D7D7C7CA0679CA57A7E7F817B7F7C82926EAE882A9C7B54827F7F7D7B827E
7F7F78C8786C7B3CC6AF8A8385A07B7F7E7F917C
7A8572467992AD6C4292A05DB9945DFC89BB8792926C58C83E9473FFD4837686AA94848C
7EB17D8E7C847AD35284C980976E876E85805C86EC4DB455838066618C726F6B71467730
867E7F7F7FA56A817F8C935BAF777F7F5D8A88917E8247AB5F89697E987B846F7C71807F
7F798882847BA3CE798F76BE46777F7F7F7F8A8B
608F6E4D82386558D7A96657B3AFE82C4181AB992E70C1AE956339005A7DA9B485918967
8977988243BA6A966E7962846563A35B925EAE5DE6436BA87090795A8E6D817F826E8176
7E70847E7F7B6D847785885255AA797F5E5991779F768368978977A8667F6D6BAE6C8384
69B69BB35735D9422058646A8CC6787F7F8C6C94
E15AD13445AC8352DB414F87DF8D4F4B7B56FF009A818C658D7E8343559A6A44965D8A7C
42912CCDD7A25A9FB0BA7A916E9C377C2F7109FF00BC80908186C16A7F71808C77A2806B
80755B7280898955F044D1398F79906E8A7DA96778797E7F7E8B8078937E999DA06D5C60
736D8D6D92B0AF6C8C98846B9172807F8471605D
00A360FFBC20FF8F1737576B0055646541DE00FF7485A8AC5C7CFF6A9563614D715CA867
6DA36A062D8EAC6884947EA994806FA27F8726B37864707F698B67767F7471847C788C9D
797F81727D929BA54A86A8C746A27870669E8A8097797F7F7FA157837E7F8E796E908081
7F82676CD88181928162538288C576904F63977C
9AA187009362000067607D6F539B72FFF41BFF26FF7B7779A66BA1A37CA34E366EAD52CA
807A9243FF9E6B3B59757A7B7D7E7BE2558592348A3073807B64C25A6C6186477CE6B389
847685629667829A888FD38DA1827FA0A09873654FA77B7F7F7C827E7F7F7E7F5F9A7A6E
817A7E7C556A579B586951827D797C9270806CA4
D76626FF1994FF58D7B8789E4D797800593B73002CA880567E5131FF73737D0F6A7BCD3F
6A6C91C38400EF4D53B17D816D7A785E8646B31EA0A77A9F7880789B6F878D6989338090
8A5058A954974E66B08D89558260DB5C3F95B55C5B60807F7F7F8F7C7F7C7D8A814B9186
829E8DB08E579D726D6182826A8F7D7E7F7E7F7B
5DA566AD5C8F39FFFF4476C7399CFFB4B1C122EE188F60D8B32F0045927500FFBB813CBE
B67723D100FC00996FAA807694AC48315F962E7B8E5594A9767F91307A4E9E9B6FB93A81
7469A38AAE9B916F51A845AE7F906E8391E77282755E80817E7C6C817FA171B59D6C8940
AB808277668E614F66528768958D7C7F7F7F828E
955B7D1CA56100000075CEB5C4538475AE45FF3AFF53E95667BC6069536EFF002474B2AA
A25758C02670E386828A4BBF6C7984795FB115B367A381937E7B83D193BB584C7D799F71
6CA19F6AACA231CBF46E6549BD7590A47E32837F71847E5F83A17C7E7F75807B7599699A
BD9F4C4E9B7992806A73826A917D7F7F7F7F6681
81E2BED17ECD652467834BE06476008C7B58001D6E7C357D86A24C7A747185FF8C716882
736DFF64FF68477E8390988A857B89AD4DCCCA6E8E866C7C7F78FF11A03C6CB08F7B5D5C
A7747F5A7C61B8876BCA79E739BE6A72875D827F6F81855A8E7B7F8169C7688BA55E8191
B69E4F718B707F83B56D6E827C7F7F7F7F7F4C87
74488DA89A9AE840535DD06CB39895A05D7CD5726684899AA1C5DF828094138B6ABC6D6C
7B773D3F4B49C3448C7975A295684D9D9663C3BF7E77817E7F852DD2569B7D78AAB17B76
776C8F7A87C97473670CAA4E9E436B544571827B7F7B7E7F8F8B8D816E79907A6A7D63A9
7C605184A2627BA57881817E7F7F7F7F7F7FAB61
5F8BB7476EBB519D74622D6DDE8C448F5E7DCAA97ACC7E99A06C9A69818771854B916972
51C6999918F012744BAB72A2997D8B9CC459AE869480817E7F815EA99B8A8346AA7B949B
BEA378C39B97588384779A7372CC2B8F698886A77A9A7B7F7A9E9D817F7E799B15B1A187
7D7B876C925C856A7F81817E7F7F7F7F7F7F927B
42AC555FA2A5B26C74A1A7B1956E77AAAC8915855933B38560009872707D816D8B808598
A1B66153998909B07A02A034D47A7D61B474857E7E6F6E7F7F7E86A74D9958A9424BA190
4F93469B9D8D8A7C7E5F8A423C885D3ECA4F9478A63D877FA2648756807F7F7D858F92AB
4C77817F7E807E7F7E706E7F7F7F7F7F7F7F7C82
AF6CA0A66D848F93977645B7778B6C7B598A55B62B87779E6F787B7F7F82359B7DAC888B
7774B7505B86B6A47C888229658784B55E887D7F7F7F7F7E7F7E9E67515654AEA96D7B89
937B83798269B5877C5E66738F4A8E986E867D7F7B837E7FA25594937E7D628740997675
A37F7E7F7F7F7F7F7F7F7F7E7F7F7F7F7F7F7F8F
7FC159628593A1678566A315937A82C15F7799627A936428B448857F7E80BC4696749C94
A4A46B785AA0973D847C7D6DAB666A6C74A97E7F7F7F7F7F7F8140C7758853AC5F785D7C
A55D81964D818FB87B7EBC69784F80AA696E7D837A867E7F7B6F857776AF3860848B7A8D
7F897B7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F8F82
BF69609EF67292768C34624F8378A275749B9D9E9F4CA495FF517F7F7F7C7C5B647072A0
428CAE777E639251AF9C8B96B468629CA758827E7F7F7F7F7F7E898164659DB1B1487689
4C76895C759AC976825F7C77478959A9675B9E4DB12C857F7F9454987C725E74A8786F8F
7529997C7F7F7F7F7F7F7F7F7F7F7F7F7F7F733D
5AA24B0F29719ADBC690A14F7A75A486777545486B6A798E99AE787F7F7B8AA876AB8364
917A7B5AA1996E606C7C7D7979838079739F7C7E7F7F7F7F7F7E7F6340419196B16C6D3C
7779C57C7F7C7A7F7B83865972815B5B769691807A867E7F7F797F7D835CA39A596675AE
6D747E7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F7CA4
6590A1A76793675090A38C6F83844E7B9A84839C70B784A48173807E7E819F8472909487
7B777F827B95798CB16B7B8BB7A77A5AB8807F7F7F7F7F7F7F80666C7EA67895BA66B983
7F845882827B80787F7D7E827F929F9052428D7F67837D827E8FA9687FBF64618AA0B1AC
69817E7F7F7F7F7F7F7F7F7F7F7F7F7F7F7F824D
9B807E69806B7EC749825E8B878576796F726358B990429576807E8A8A7A72A48C9B9D45
7BAA6F847A625F90664BBA598826DF367A7D7F7F7E8B8A7E7F7DAA75C2647DA862714D71
905C7582439986C287827B7F7E6D938F94AF92A9B7617257836D7A9D4C6F6C688B558F79
817E7F7F7F7F7F7F7F8A857F7F7F7F7F7F7F7077
79827B35796B9AABCB1AB4938994925A64777ADA65859A9753747C8D96814D7296796685
7E827E89B9ABAB5880968EC96D7FBECA747F807D7F8BA57C7F7F721C71918366A8957080
76827F7A887D7A739641AA6C94596F686CD276BE868CBB7E5E5A8074DA2C7C585FA4787F
7F7F7F7F787F7F7F8193C37A7F7F7F7F7F7F8AB8
5F8E787E918E918874A06B37797449A286C1B947A18E79741F917555727DBAA150987784
777A5C6D7F90808221807D777978A578817E85948EB46D7F7F7F728B71877D60606E807B
A47B7B9868907AA970857E6B90817BAD9C8F567D9479787F8181857C96985D844A5D7E82
7E7F7F89B47B7F895A937A827E7F7F7F7F7F7D6C
6A7D847BBC987C6788766CA371818E8A61A6457C6E61AB6E888E7D96828260787E7C8D8D
7861AFB8767F74869C6576709C695967A78851867E74A17D7E80726887B97B8279807E8C
8D7E7B956B77765858957C7F7E7F8253817E734F839178946B894A797372708D6F7A956A
7F846F6C80815EA77E7D706E7F7F7F7F7F7F8460
947A857A4094796E7D65C19EC0848B3A986C857E7E929AA3797155647F8DA28B7E877B91
6D7F607E7F7E815DB169B48F5AB99161706E479E857E7D7F7E92A585AD5A817EA77B7F7D
7C8E7B887E9C6E7FAB787F7F7F7F7E808F77A54DB77FA665993E7956A3AA568FA283717A
836981726E87646C7F7F7F7F7E7F7F7F7F8F5D6D
A8B462656A7A5C7D5E9993E94265575592D55682764F859674C9BD9F81659CA97E6D7F96
4C8576797F7F7E7BA460797297C3D87085E4A483987D9E7D7F676D4D6F3F84706C7F7F7F
7F9078A99B5A718258827F7F7F7F7F7F7C7C9548602A72827F5F848F84416F8560746DC4
63ED5A82854B6E827E7F716F7F7F7F7F7F6C8B97
6341A38D1367766A7E70BB4C768D8766828E7C7F7DA286A75B13336D808B82706D87759A
B78F7D7F7E7F7D81512C7C967CB87DA142096368727D7B7F7E8878A04C777E5F827E815C
81915975AD7C7F7E807E7F7F7F7F7F787F7F88A59A5C997A90689D7594657E4C9396568E
87239E777E72937C7F7881817E7F7F7F7F85C18F
98B06D72D79A8B90559360C7A5707EAB6466658A8791889AD7CE9C7774705D8FB77B7A63
75B38550877D8E7A806B939A637ABD6478AE6F877F6977817A8487939489A46F7F7F8186
7E699886A16B7F816C6E817F7F7F7BAC7780777CB6765A8A8A90998AA45F36788A79827A
D4AF6276807F7E7F89B47D847B7F817E7BA5768A
66A0498458AA5A8D608C98A7869C6D3DA1638B87B895567767877071A4C4747B7B81A298
974872908D7E626D4FA04F9496A34BC074294C907A828667998D747C7D7D7C7F7E816C6E
7F9466876686907F848E8E7E7F7F7E6C997AB556845C81A3AE759E8695737273A26C7F70
629A96687F9B7C7F7682705395796A7E826A8279
B6A9639E7398AD74907D6F97B2735D9067BB4F851B7F457F9156B084856094708668737C
603C968E7C7D917A4635276E6624D7809766BA7E727A9AB9317FAC67815E817F7F6C947D
7E7C8261796A826B6D7F7C7F7F7C80664679798574747B41958D82AB3FB07E9C8A807E91
8AB45397799F7C7BA7567FB4799393A07D7F6C93
72667592886C8791BD9A64636E7A8A88807E90758D84669A8C5B6C7F8188847A7C7F7F7D
8A8A88916C8FA9AE7978739E7A4BA4778567727E7F7F7D839A7D7BA26F727F7F7F7F7E7F
7F787F845E906C8271676F7F7F8F8EB8826A867BA54D4F6651B08C6E82866F8C7C7F7F81
5A6C957B7F7D7F7F7D807F7D7F88B1787F7F7F7E
AD8E838883807C85577C7B75867D8183746B4C8D8A8E627A74678080627E7F7E7F778264
7FA58B7D887E7B847886625F74914E8086917E7F7E848C8D7B7F7F7D7F7F7E7F817B7F7F
84BB7A844E947F8F715F847E7F7E7E7B7D8353827D878E728E917C617EA1858D7F788289
947E7E7F7F7F7F7F7C7C7F8C8E7C7B7F7F7F7F7F
7F71956A7F759D877B79529775926B86879C7D8070687B7E718F7E7087844D7285A86E8B
6E6E70827D927B79844A4886926B7A8CA1767E7F7B607E7C7F828F8E6E817F844C967C7B
A7777F6F737E8256877F7E7F78A57E7F787EAB7E8C7CA16AA268BF4F8FB27C7E75AD4A91
79857E7F7F7F817E918F7E7D7C7F7F7F7F818472
689B707D24A06B8D62B79A7BAC696A826099626974568B72BC8879B17C6C52925F738F90
6F6FA682813F61697A7B88ABA66B8F635E77867ABB657F7F7F64488D877E844F767E7F8E
8F7E7F71767F79B667817F7F927F6B79C7584A6F7E74A27DCC3B74B17A746D7EB5677092
8159827F7F7F5F746B7F7F7F7F7F7F7F7F625D3A
7A846B8A8876857E877761677D7784808775798A837F7E666F867F7C7F777883A37D7979
87975A817E9D86807E8A69978F966E7A867F7E7F79807E7F7F79847B7E7F6F737F7E7F7A
797F7F8450758E8A7F7E7F7F7144837F788283797CA484BD4A80BEBE5462707F7E5B827E
7E807E7F7F7F81807F7E7F7F7F7F7F7F7F7DAF84
917088868F7E7E838070539E7B86987762707D7E7E6EBD678D6F807E7E8986859D809391
849B797F7E7F7F73A485748F9A9B70AF757F7F7F797F7F7F7E8A967D7F7F716F7F81828F
927E7F7E537381817E7F7F7F7F857E7F82577FB56882796B615D936A92A57E7B90947C7F
7F7F7F7F7F7F81817E7F7F7F7F7F7F7F7F842C73
678086736A8B836E726A766D83817A766EA577737B68889072887B887D84817575725A82
5866A082827E7B807C4D67B5527F7A7A7B857E81A17E7E7F7F8275807E7F83837E6E4B7E
7E7F89A46F7F704E827F7F817B83827E7E847E7B8D7996789E735650739A7C7F7B827E81
827B7F7F7F816C6D857E7F7F7F7F7F7F7F7F5D82
52799798F6788455AD8D4691B9A3AB818D8B6AE49C6EAC098C4581498F979590A193CE7F
888054865F8D8B7F80599E564664996BAE268A61854B877E7E9C9F7B7F7F706E7F9359A8
905B797C7F7E976F817F7F67B76744857F7F7F7F8E916B846A73866C597D846C85368871
5682807F816994834678807F7F7F7F7F7F9BA17D
9A757C90447685807D6C7890A4817A936E87825D8B967493867F8671867C7E7F7C7E7D54
86867A7E908D7E8E8FA17F63966E5A847A8779C9727C847E7F7C7C807F7F79807E7E807C
8390A97B7F825283787F7F8E8A7F857E7F8E907E6F6D807F899CB37892966B947D8B7D7F
82807E7F5F82797E865B817F7F7F7F7F7F7C7C7F
8D8F8192937E6A9E709171724B7CA07BB1835982AF8286427984989F7B7F76908495849F
737B647C7E7E7D647D787B7D93877190847E7F9296987E7E7F7F7F777F7BA47B7F916980
A48837857F7BB673C48A7E7E7F7A7F96697E757F825F875BAD52AA638E6E717D764C827F
7F7F7F7F84A09B7A746D7F7F7F7F7F7F7F7F7F7F
4F6E8374719B9086626A997D877B79868F7887764D6D7A948C80726372898980837B6D4F
787F83768478657F857063829E668595827E829C93BB757F7E8A8D787B7E807F7F7C826D
6D44777F7F7F7B7F7C5A827F7B986978857BA97B7E746D78406956A26D63827E7454817F
7F7F7F81506B9C927D927C7F7F7F7F7F7F8A8B7F
A08E72706C7671B571877F81A787C7853A797F75DD5178968C894B6C86889364648092B1
767F7E807E7D74487F9E859AD4358273867E87349638817F7E8C83A192816B7F7F7F8179
9FA57C7E7F7F7F7F7E837E7F7F7E78B0537D876A8C825C8839D1F938CA7F82818258827F
7F7F7F8170829F6F99A57D7F7F7F7F7F7F8B8D7B
6C8E908A9561717383626D8C5B8D808385787E7D89B67E907F78A366887E7E7B847A5F7C
80827E807D7F7F9DB37E7D837D72A08777827EB34491857E7F7E7E7D7E7E7F827E7B8C91
7B7D7F7B827E7F7F7E857E7F7F7F7F7A82955672A67B837E857D4FAF7480706E7CA57B7F
7F817B7F707572478353827F7F7F7F7F7F7E7E7F
DE3C6EA455989F8E7B787A7CF87C7C667A9E9092575A9B72806E1F67927F62B151B57775
6B398A6C8C7F84912B60866DA8817F837F695A3FD84590787F7F85918F7E854685985A7F
846189A8586F817F8536857F7F7F826794705D68936C87818D98928C6B4E8662817D7F7F
7F6C9E897F5290838D8D799F7C7F7F7F7F7F8189
568458626E7C94697B81947078677FA4616B7D7D7B5A5F655B76729867788E73AF636F8C
748F7E807D7E7E77D06193805F7C628B7F6562808AA94A837E7CA9717A7F6B6E826B737F
6F6092797F87817E7E857E7F7F7F7E827C7F6CA961795A687E91637993DF803B847F7F7F
814EA48B787C829962998E877F7F7F7F7F7F6C91
775B6CA29C898B86905F9C6580786C6E626C897E8C78959B737674879579927F4EAD807B
851A7E7F7F7F7F8329DE39618055737E7F745E93217FB1767F7D8C7A7C7F93956C947D84
5F837E7FA148727F7F7F7F7F7F7F7F7F7F7FA381A62F9EB6697BA29065616E857E7F7F7F
7E776D59A39A4F8CD0516F927C7F7F7F7F7F7A9E
8A81948C7A659D7E607D866634978C879B8495907E677B9F7674945A8B876582A87B6D70
7D8E7894887F7F7C7C9775826FAE917A817A66A27597807C7F814C86817F6D6B7A7E7F69
737F7F787C855C817F8F6B817F7F7F7F7F7C7C585BB4517E7F7F7A7E9DB390815C84817E
7C946C84A295807B8E797D7E827E7F7F7F7F936B
97785FA2877B6D6B7F5B919D6D976F58837D816FA58F757A756FA1A20E9B847383948855
80887F7D6174859FAC71826CB1557C6E6B8075646AAD5B7B8E66A47D7F7F788AB47B7EAA
896F88C28A7D837E7F7C908B805F817F7F9FA3865B7E847E8158986B8688747F836D6B7F
7F7C81706C5569B666B78B7C6C708181737F6F72
69A4854C9E7B8FAC8F85685C51738BAB9F6279CC6891827E6F8BA88A8C6979838784865E
7F777F7D77947B79A1755B884FB7AD97926E8695647A818C7C847D777F77AD737C845057
956C957960817F7F7F7F769081737E7F7F7C6C907F7C8E907D8C90719A669E7B9790907E
7E5F81837595798E817A847E7C877D7E59857F7F
835F5DB4875EAE627AB0607A76DC9A876E3B8F398991645D63AD537F4B837A604E687BA0
5D8061826C65877CAA768C57661183976CD0769C7F637A24AF4387737E9B71B57B6973AE
428C4767427E8D8E7E7F917B7E6D817F7F7F6D937C7F7C7F62476F4E86864D7342717F78
A9638265B87A7F7E8C8F5682914791AE8D6A817F
7D9585727F876A68687D829DA26A796C92D67B7E7E7C978F9A8692919176897B7E6F7D54
9F4684805F7F7E807D7F7BBF7B907583807C96797AB38E855B7F7CAB676E5B7E83B84D37
8079864F68B2767A7F7F8C8E7E797F787F7F7F7E7F7F7F7E71A69359A85D5A85A57C7E7F
7E6A917F7C7C827E757B927E7E828B8A7E7C827F
7EA1A9A780706BA37484A082309A9F877878815D998B8069727DA8828293AEAC8B9372A3
7E6958817E6E8B74828C956C6B5A75857E7D7CAAA26E807E7F958190AA83947DA863A281
B37E5D88928C8F927E7F805C89B474C77881817E7F8C8B7B7F6E6F878C938459807F7F7F
7E7E7C7F7FA1578A38867E7F7F7F7E7E7F916A7D
68797356947F82758B9374678B7D94ACB17185B874656678A179757C7E7F718C65576288
374FA97D69838A6D6B714680A871B27E607F75877A807E7F7F7E788D7DA8796A7B98BD73
7A7F787E78956C6A7F7F7E7191848C787F6D6B7F7F6F7D927E7F6E6B805D8F847E788A88
7E7C7F7D857E817E857E7F7F7F7F7F7F7F7E837D
993D4F875886906F94747CAF9C5B6DB57873848C9C8F857E4A74B4B07275B38391827CB3
827963807F908F8C918082805C756C4B7982D2039375787F7F7CA0576C5881AA56B6AFB4
9E8CA07A815192907E7F7F7F7E8F8A7E7F88917E7F80807E7F7F8E90815EBCF26BA9879F
7B8D6D8C465E837F8C9F7C7F7F7F7F7F7F7F6A85
74889670997A709E659377657089716CA387766C6474796958907D6181807282B5B08182
8C89787F7F69579271815B7E7D697EAF9F7B798A8E8F7F7E7F7F81558A6E6C7B7F50B7AB
788C8E787CA57B7E7F7F7F7F7F6C9E8978C6787F7F7F8E907E7C7B7E7E6E937E8651B07D
7E7E817D8284818C8C797F7F7F7F7F7F7F7F7F7F
987E7D87579B7295786F7B80AD767C8E908C7B736C8477A4BC775D877B7E7D827F669C7D
657A5F807F6E5A7781818198908FB77D6A8483634C8E7E7E7F7E85A1B282BA59B777B077
7F7D81B47B7D8C8E7E7F7F7F7F71A18B81757F7F7E857C54858D8F7E817256997D8EBE6D
807F7F817B625E705F6F7F7F7F7F7F7F7F7F7F89
7C72877A6C748E5E868A85726586848F727B7C8445669D8578A5A8837F836D98775E7C76
8A83817F7F7B52C6765F48677E908D66639C5D53857C7F7F7F806F7088B54F3CA18D7A7F
7F7BA8777C7C7D767F7F7F7F7F75587F5F987C7F833DAB88667F7E7F7B91AE798F957247
876C8266A568868383817E7F7F7F7F7F7F7F845D
916780A56575747C855968778177648D8C898380718538827964647F7E79979770648684
9968A980797E8D48877D6D9C784760677375E7649B7D7E7F7F7DA2907D833E7F4B5D827F
7F824A728E9D8AB2887C7B827E7F82826E6C817F7B9C6866967E787CB55FAF457651D98D
7C8558B96EB86C6E7F7F7F7F7F7F7F7F7F7F6F72
87858565B38F7284A66C7E6B727E85787E6FA16C8C8882675E88A79C7B80666E4B7E7E7C
795C6ABBA3827E8959897978648C9485807D998B85847E7F7F7F846A5C72839085867E7F
7F7C7F818C897975909EA547827F7F7E7F8269917E8158837E7BB28B6A5E586A817A787E
8265B6787C876D7BA17C7F7F7F7F7F7F7F7F7F82
00FFFF00FF00FF463660FF00C100FFFAB4891E5C528B70E3945860969400FF877BD17BA7
9786BC19B860675EAA806E94D077FF00748257C56E687F929600FF77956D6C6B736F7F7F
7F9E9E90669D8DA18749858377807F806C7C96697F809A7B7C908E89A099CDD246A3797F
7E808B76A48D7B9567807F7F7F8E6D87788B00B3
FF0026FF57CD00916F7A12F4726800757884829B8171765262AD7D7D93D7008180777F7A
7D82815D79727F83796F6F5E8D7435AE72718179807E856836FE00837C8181817F7F7E7F
7F7C7C7C827E817C8870807CAEB17E7E817F7C817E706B789B677B8C8E679984566D7A8D
8C7D7E7F7B7E7F7E7D857B808A807F524EC3707A
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol03Woo2P000Woo0P000Woo0P000Woo0T8@1124100017oo0P0017oo100017oo0P00
0Woo0Tic0Re[0V]J0SW>0UJe0PQ20P000Woo13F]10000SW>14YB0U[F100027oo0P000RDY0Woo0P00
0U:D0S6<0SF]0Woo0P0000=S64YBBU800Ukg0T8@0Sg_0SW>14ic0TYB0RU:0Ukg0U:D0TYB0PaS13g_
0U:D0U[F0Sg_0Tic0SF]0S6<0TYB0QS60Ukg0Q240Re[0PaS0Ukg0QBU0VLi0RU:0UJe0THa0U[F0V<H
0P000R480P@Q0WNm0P000Tic0U:D0THa0UJe0W>L0V]J0S6<0V<H0RDY0SF]0VLi0RU:0QS60T8@0QS6
0UJe0RDY0SF]0TYB0SW>0T8@0THa0Woo0P001Goo0@000Goo000=Ool01000Oomoo`0017oo00<007oo
Ool03Woo2P000Woo0P000Woo0P000Woo0T8@1124100017oo0P0017oo100017oo0P000Woo0Tic0Re[
0V]J0SW>0UJe0PQ20P000Woo13F]10000SW>14YB0U[F100027oo0P000RDY0Woo0P000U:D0S6<0SF]
0Woo0P0000=S64YBBU800Ukg0T8@0Sg_0SW>14ic0TYB0RU:0Ukg0U:D0TYB0PaS13g_0U:D0U[F0Sg_
0Tic0SF]0S6<0TYB0QS60Ukg0Q240Re[0PaS0Ukg0QBU0VLi0RU:0UJe0THa0U[F0V<H0P000R480P@Q
0WNm0P000Tic0U:D0THa0UJe0W>L0V]J0S6<0V<H0RDY0SF]0VLi0RU:0QS60T8@0QS60UJe0RDY0SF]
0TYB0SW>0T8@0THa0Woo0P001Goo0@000Goo000>Ool20005Ool00`00Oomoo`0>Ool40002Ool40002
Ool20002Ool80002HaP2G_L2:DX60002Ool25:D2Ool20004Ool20002Ool28@P2Ool2?Nl20002;F/2
@Q02Mkd20002JeX4:DX20002Ool20002IcT2>Lh20004Ool28@P2AS42DY@2Li`2Ool20002Ool2Nmh2
8@P2?Nl2Ool200000cg_:DXYBP02?Nl2E[D2<H`2CW<2Li`2CW<2?Nl2;F/29BT2BU82;F/2CW<28@P2
9BT2F]H2<H`27>L2>Lh2CW<2>Lh2AS429BT2IcT248@2=Jd2AS42IcT236<2<H`2:DX2JeX2?Nl248@2
>Lh20002<H`4Ool2?Nl236<2Mkd2AS42;F/2>Lh4CW<28@P2JeX2Ool20002IcT2?Nl2AS42>Lh2CW<2
AS42=Jd2@Q02?Nl2@Q02CW<2Ool20005Ool10001Ool001Eoo`03001oogoo00ioo`@0009oo`@0009o
o`80009oo`P0009S609Nm`8YBPH0009oo`8DY@9oo`8000Aoo`80009oo`8Q209oo`8mk`80008]J`92
409g_@80009[FP@YBP80009oo`80009W>@8icP8000Aoo`8Q2096<@9BU09cW09oo`80009oo`9kgP8Q
208mk`9oo`800003?NlYBRU:008mk`9F]@8aS09>L`9cW09>L`8mk`8]J`8U:@9:DP8]J`9>L`8Q208U
:@9JeP8aS08Li`8icP9>L`8icP96<@8U:@9W>@8@Q08e[@96<@9W>@8<H`8aS08YBP9[FP8mk`8@Q08i
cP80008aS0Aoo`8mk`8<H`9g_@96<@8]J`8icPA>L`8Q209[FP9oo`80009W>@8mk`96<@8icP9>L`96
<@8e[@92408mk`92409>L`9oo`8000Eoo`40005oo`005Goo00<007ooOol03Woo0P0017oo0P@Q0P00
0Woo0P000Woo1P0017oo0QS60Q240Sg_0Woo0P0017oo10000SF]0Woo0P000Woo0V]J0QcW0S6<0PaS
0Re[0Woo0W>L0VLi0P000Re[0QS60VLi0S6<0RDY0WNm0Tic10000Woo0V]J0P000V<H11S60S6<0THa
0TYB0S6<0SW>0Woo0P0000=F]DHaAS400Tic14YB0RDY0T8@0SF]0SW>0Sg_0Re[0SW>0RDY0W>L0PQ2
0SF]0Tic0TYB0UJe0R480S6<0TYB0Re[0Tic0Re[0V]J0SF]0S6<0U[F0THa0UJe13W>0Ukg0Q240SW>
0QS6100017oo0TYB0RDY0Sg_0SF]0U:D0Re[0TYB12DY0T8@0VLi0S6<0QcW0U:D0Re[0Sg_0T8@0S6<
0Sg_0T8@0Sg_0Re[0Woo0P001Goo0@000Goo000EOol00`00Oomoo`0>Ool20004Ool212420002Ool2
0002Ool60004Ool26<H248@2?Nl2Ool20004Ool40002=Jd2Ool20002Ool2JeX27>L2<H`236<2;F/2
Ool2Li`2IcT20002;F/26<H2IcT2<H`29BT2Mkd2CW<40002Ool2JeX20002HaP46<H2<H`2AS42BU82
<H`2>Lh2Ool200000eJeAS56<@02CW<4BU829BT2@Q02=Jd2>Lh2?Nl2;F/2>Lh29BT2Li`22482=Jd2
CW<2BU82E[D28@P2<H`2BU82;F/2CW<2;F/2JeX2=Jd2<H`2F]H2AS42E[D4>Lh2G_L248@2>Lh26<H4
0004Ool2BU829BT2?Nl2=Jd2DY@2;F/2BU849BT2@Q02IcT2<H`27>L2DY@2;F/2?Nl2@Q02<H`2?Nl2
@Q02?Nl2;F/2Ool20005Ool10001Ool001Eoo`03001oogoo00Yoo`80009oo`H000Aoo`8000Aoo`80
009oo`8DY@9oo`8000Aoo`9JeP92409oo`@000Qoo`80009oo`9S608mk`8e[@8]J`92409>L`9oo`80
009oo`8aS09oo`80009[FP8YBP8mk`8e[@9S608mk`8000848@8000A[FP9oo`9cW0@icP8e[@9>L`9o
o`800003F]HicSW>0092408icP8]J`9>L`96<@9>L`8aS08]J`9W>@8mk`9>L`8icP9Nm`9F]@9:DP9N
m`80008Q209oo`8mk`80008Li`9W>@8icP8HaP9:DP9BU08U:@9:DP8e[@9>L`8e[@A6<@9F]@9JeP8Q
208]J`8icP8@Q08e[@8U:@96<@@U:@8mk`96<@9Nm`8YBP8aS08YBP9:DP8icP8YBP9BU096<@8aS092
4096<@92408icP9oo`8000Eoo`40005oo`005Goo00<007ooOol02Woo0P000Woo1P0017oo0P0017oo
0P000Woo0QBU0Woo0P0017oo0U[F0T8@0Woo100027oo0P000Woo0V<H0Sg_0SF]0Re[0T8@0Tic0Woo
0P000Woo0S6<0Woo0P000V]J0RU:0Sg_0SF]0V<H0Sg_0P000P@Q0P0016]J0Woo0W>L13W>0SF]0Tic
0Woo0P0000=JeSW>>Lh00T8@0SW>0Re[0Tic0THa0Tic0S6<0Re[0VLi0Sg_0Tic0SW>0Ukg0UJe0TYB
0Ukg0P000R480Woo0Sg_0P000QcW0VLi0SW>0QS60TYB0U:D0RDY0TYB0SF]0Tic0SF]14Ha0UJe0U[F
0R480Re[0SW>0Q240SF]0RDY0THa12DY0Sg_0THa0Ukg0RU:0S6<0RU:0TYB0SW>0RU:0U:D0THa0S6<
0T8@0THa0T8@0SW>0Woo0P001Goo0@000Goo000EOol00`00Oomoo`06Ool20002Ool20002Ool20002
Ool21242Ool20002Ool20002Ool2Nmh40002;F/20002G_L6Ool20006Ool2JeX2Ool2>Lh2Ool2JeX2
E[D2=Jd2:DX2Li`2=Jd2DY@29BT2;F/2@Q029BT2@Q04BU82JeX2Ool2=Jd2Ool20004Ool2:DX2IcT2
=Jd2Ool20002CW<2IcT2>Lh2?Nl2@Q02Ool00cF]8@PQ2002BU829BT2DY@2@Q02?Nl2>Lh29BT2IcT2
CW<2@Q04<H`2>Lh2G_L2:DX2F]H2:DX2?Nl2>Lh2CW<25:D2CW<2G_L2>Lh20002;F/2AS42?Nl2E[D2
AS42;F/2G_L2?Nl2IcT2Ool20004Ool25:D2JeX2E[D2>Lh2Mkd2G_L20002>Lh4BU82Ool20002Nmh2
Ool2:DX29BT2G_L2@Q02?Nl2@Q02?Nl4@Q02<H`2G_L5Ool10001Ool001Eoo`8000Moo`80009oo`80
009oo`80009oo`848@9oo`80009oo`80009oo`9kgP@0008]J`80009Nm`Ioo`8000Ioo`9[FP9oo`8i
cP9oo`9[FP9F]@8e[@8YBP9cW08e[@9BU08U:@8]J`92408U:@9240A:DP9[FP9oo`8e[@9oo`8000Ao
o`8YBP9W>@8e[@9oo`80009>L`9W>@8icP8mk`92409oo`03=JdQ2248009:DP8U:@9BU092408mk`8i
cP8U:@9W>@9>L`9240@aS08icP9Nm`8YBP9JeP8YBP8mk`8icP9>L`8DY@9>L`9Nm`8icP80008]J`96
<@8mk`9F]@96<@8]J`9Nm`8mk`9W>@9oo`8000Aoo`8DY@9[FP9F]@8icP9g_@9Nm`80008icPA:DP9o
o`80009kgP9oo`8YBP8U:@9Nm`92408mk`92408mk`A2408aS09Nm`Aoo`80005oo`005Goo00<007oo
Ool00Woo0P000Woo10000Woo0P000Woo1P000Woo1P001Woo0Re[0P000RU:0P000QS60P000Woo0P00
0U:D0Woo0W_N10000Woo0P000Tic0T8@0RU:0WNm0SF]0R480SW>0R480SF]0Vmk0P@Q0QcW0T8@0Sg_
0V]J0TYB0P000Woo0P000Woo0Sg_0THa0P000Woo0P000Woo0QBU0THa0T8@0P000Woo00<YBS6<<H`0
0Tic0TYB0SW>0SF]0UJe0TYB0U:D0Sg_0TYB0SW>0TYB0Sg_16]J0QS60Sg_0SF]0Tic0RDY0Sg_0WNm
0Re[0Ukg13F]0SW>0TYB0S6<0T8@0U:D0Q240Re[0THa0P000P@Q17oo0P000Re[0VLi0RU:0SF]0Sg_
0THa0T8@0QS60THa0V<H0Woo0P000UJe0Vmk0Tic0S6<0THa0S6<0THa0SW>0Sg_0SF]0R480P000V<H
1Goo0@000Goo000EOol00`00Oomoo`02Ool20002Ool40002Ool20002Ool60002Ool60006Ool2;F/2
0002:DX200026<H20002Ool20002DY@2Ool2Nmh40002Ool20002CW<2@Q02:DX2Mkd2=Jd28@P2>Lh2
8@P2=Jd2Kg/212427>L2@Q02?Nl2JeX2BU820002Ool20002Ool2?Nl2AS420002Ool20002Ool25:D2
AS42@Q020002Ool00bU:<H`aS002CW<2BU82>Lh2=Jd2E[D2BU82DY@2?Nl2BU82>Lh2BU82?Nl4JeX2
6<H2?Nl2=Jd2CW<29BT2?Nl2Mkd2;F/2G_L4=Jd2>Lh2BU82<H`2@Q02DY@248@2;F/2AS4200021244
Ool20002;F/2IcT2:DX2=Jd2?Nl2AS42@Q026<H2AS42HaP2Ool20002E[D2Kg/2CW<2<H`2AS42<H`2
AS42>Lh2?Nl2=Jd28@P20002HaP5Ool10001Ool001Eoo`03001oogoo00Aoo`8000Aoo`80009oo`H0
009oo`8000Aoo`80009oo`@0009oo`80009oo`9F]@80008U:@80009oo`8000Aoo`H0009oo`9F]@8Q
208mk`8DY@92409[FP9kgP8000AkgP96<@9BU092409:DP8U:@9cW08<H`80009oo`8icP88@P9:DP9o
o`9[FP9oo`8aS0@0008@Q08]J`800003AS4e[CF]009:DP9F]@9BU09F]@8DY@92408icP8mk`92408e
[@8icP9[FP8YBP9F]@92408U:@848@9JeP8@Q09[FP96<@8YBP9>L`8icP9BU08e[@8aS08]J`9>L`96
<@8e[@9F]@8Q209BU08mk`8<H`88@P8icP9cW08e[@9:DP8aS09:DP8]J`92409Nm`9JeP9>L`8]J`8m
k`9oo`8e[@8]J`8e[@8icP8YBP9S608aS08mk`8aS096<@9oo`8YBPEoo`40005oo`005Goo00<007oo
Ool017oo0P0017oo0P000Woo1P000Woo0P0017oo0P000Woo10000Woo0P000Woo0UJe0P000RDY0P00
0Woo0P0017oo1P000Woo0UJe0R480Sg_0QBU0T8@0V]J0W_N0P0017_N0THa0U:D0T8@0TYB0RDY0W>L
0PaS0P000Woo0SW>0PQ20TYB0Woo0V]J0Woo0S6<10000Q240Re[0P0000=6<CF]=Jd00TYB0UJe0U:D
0UJe0QBU0T8@0SW>0Sg_0T8@0SF]0SW>0V]J0RU:0UJe0T8@0RDY0P@Q0U[F0Q240V]J0THa0RU:0Tic
0SW>0U:D0SF]0S6<0Re[0Tic0THa0SF]0UJe0R480U:D0Sg_0PaS0PQ20SW>0W>L0SF]0TYB0S6<0TYB
0Re[0T8@0Ukg0U[F0Tic0Re[0Sg_0Woo0SF]0Re[0SF]0SW>0RU:0V<H0S6<0Sg_0S6<0THa0Woo0RU:
1Goo0@000Goo000EOol00`00Oomoo`02Ool20002Ool2Kg/20006Ool:0004Ool20004Ool2=Jd248@2
Ool28@P20002Ool20002Ool20002Ool2Mkd2Li`2Ool20002Ool28@P2JeX2E[D2F]H2CW<25:D2Ool2
0002Ool2E[D2CW<200029BT2E[D2F]H2Kg/200027>L2Ool60002Kg/2JeX2G_L236<2@Q02:DX2?Nl2
JeX200000cW>;F/]J`02=Jd29BT2E[D2AS42DY@2?Nl2DY@2<H`2E[D2?Nl4@Q025:D2BU82G_L2CW<2
0002BU82HaP2DY@2;F/2>Lh2E[D2<H`248@4>Lh2?Nl2AS42CW<2@Q02BU82DY@2E[D224821242DY@2
Ool2Kg/2F]H2?Nl2BU829BT248@2E[D26<H2G_L2F]H2>Lh4?Nl2>Lh2<H`2=Jd2CW<2<H`2>Lh2AS42
?Nl2@Q02?Nl2Ool29BT5Ool10001Ool001Eoo`03001oogoo009oo`80009oo`9_N`8000Ioo`X000Ao
o`8000Aoo`8e[@8@Q09oo`8Q2080009oo`80009oo`80009oo`9g_@9cW09oo`80009oo`8Q209[FP9F
]@9JeP9>L`8DY@9oo`80009oo`9F]@9>L`80008U:@9F]@9JeP9_N`80008Li`9oo`H0009_N`9[FP9N
m`8<H`92408YBP8mk`9[FP800003>Lh]Jbe[008e[@8U:@9F]@96<@9BU08mk`9BU08aS09F]@8mk`A2
408DY@9:DP9Nm`9>L`80009:DP9S609BU08]J`8icP9F]@8aS08@Q0@icP8mk`96<@9>L`92409:DP9B
U09F]@88@P848@9BU09oo`9_N`9JeP8mk`9:DP8U:@8@Q09F]@8HaP9Nm`9JeP8icP@mk`8icP8aS08e
[@9>L`8aS08icP96<@8mk`92408mk`9oo`8U:@Eoo`40005oo`005Goo00<007ooOol00Woo0P0017oo
0P0017oo0RDY10000Woo0P001Woo0P000Woo0V]J0Woo0P000Woo0P000W>L0THa0P000Woo0P0017oo
0UJe0Woo0P000Woo0Ukg0Q240Vmk0TYB0Q240V<H0Woo0P000Woo0T8@0P000Woo0TYB0SW>0Sg_0PaS
0SW>0RDY0P000Woo0SW>0P000Woo0V]J0Tic148@0S6<0Sg_0V<H0P0000=>Lbe[;F/00Re[0RU:0T8@
0U:D0S6<0THa23g_0QcW0UJe0Tic0THa0T8@0SW>0P000Tic0V<H0W>L0RU:0U:D0RDY0TYB0T8@0Sg_
0THa0SF]0THa0SW>0TYB0U:D0R480UJe0R481Sg_0PaS0UJe0Woo0Vmk0P@Q0P000U:D0P000Ukg0TYB
0T8@0SF]14Ha0TYB0T8@0TYB0SW>0T8@23g_0Woo0PaS1Goo0@000Goo000EOol00`00Oomoo`02Ool2
0004Ool20004Ool29BT40002Ool20006Ool20002Ool2JeX2Ool20002Ool20002Li`2AS420002Ool2
0004Ool2E[D2Ool20002Ool2G_L248@2Kg/2BU8248@2HaP2Ool20002Ool2@Q020002Ool2BU82>Lh2
?Nl236<2>Lh29BT20002Ool2>Lh20002Ool2JeX2CW<4@Q02<H`2?Nl2HaP200000dic;F/]J`02;F/2
:DX2@Q02DY@2<H`2AS48?Nl27>L2E[D2CW<2AS42@Q02>Lh20002CW<2HaP2Li`2:DX2DY@29BT2BU82
@Q02?Nl2AS42=Jd2AS42>Lh2BU82DY@28@P2E[D28@P6?Nl236<2E[D2Ool2Kg/212420002DY@20002
G_L2BU82@Q02=Jd4AS42BU82@Q02BU82>Lh2@Q08?Nl2Ool236<5Ool10001Ool001Eoo`03001oogoo
00Ioo`@000Qoo`848@80009cW080009F]@80009oo`@0008HaP9W>@8@Q09oo`80009kgP@000Aoo`92
408HaP8YBP9oo`8HaP9BU09W>@8YBP9kgP8<H`9>L`8]J`9oo`8]J`8aS09JeP9oo`80009W>@AJeP8<
H`9oo`80008icP9oo`9JeP8Li`8aS0@YBP9>L`8icP8mk`92409cW0030012448@008HaP9:DP@YBPA>
L`8DY@9BU09>L`96<@9S609:DP8mk`96<@8mk`9BU09>L`924096<@@e[@92408aS09S609cW08icP8<
H`8Li`9W>@9>L`8aS09>L`@e[@8U:@8000Aoo`80008Q209BU08HaP8mk`9S608aS08icP92409W>@8i
cP9:DP92408icP8]J`9>L`8]J`8icP8mk`96<@8mk`92408icP80008e[@Eoo`40005oo`005Goo0P00
1goo100027oo0P@Q0P000W>L0P000UJe0P000Woo10000QS60VLi0Q240Woo0P000W_N100017oo0T8@
0QS60RU:0Woo0QS60U:D0VLi0RU:0W_N0PaS0Tic0Re[0Woo0Re[0S6<0U[F0Woo0P000VLi15[F0PaS
0Woo0P000SW>0Woo0U[F0QcW0S6<12U:0Tic0SW>0Sg_0T8@0W>L00<0048@@Q000QS60TYB12U:14ic
0QBU0U:D0Tic0THa0V<H0TYB0Sg_0THa0Sg_0U:D0Tic0T8@0THa13F]0T8@0S6<0V<H0W>L0SW>0PaS
0QcW0VLi0Tic0S6<0Tic13F]0RDY0P0017oo0P000R480U:D0QS60Sg_0V<H0S6<0SW>0T8@0VLi0SW>
0TYB0T8@0SW>0Re[0Tic0Re[0SW>0Sg_0THa0Sg_0T8@0SW>0P000SF]17oo0P000Goo000EOol00`00
Oomoo`06Ool20002@Q020002Ool22486Ool20002Ool2Mkd2Li`2AS42F]H25:D2@Q02>Lh2<H`2IcT2
Ool20002Ool20002Ool2Li`28@P2@Q02JeX29BT20002?Nl236<2Mkd248@2@Q029BT4JeX29BT2HaP2
DY@2=Jd20002Ool40002Ool20002Ool2DY@2?Nl2Ool22482BU82;F/2Ool2HaP2Kg/2AS44DY@00eJe
5:DDY@02AS42BU82>Lh2?Nl27>L4BU82;F/2=Jd2BU82<H`2AS42:DX29BT236<2CW<2E[D2;F/2@Q02
?Nl2IcT2HaP2CW<2E[D20002AS42@Q04E[D28@P2BU820002Mkd2>Lh2Ool224820002Ool22482>Lh2
E[D2@Q02:DX2F]H2Ool29BT2DY@4?Nl2BU829BT2Kg/236<2;F/2HaP2G_L2BU82?Nl4@Q02AS425:D2
=Jd5Ool10001Ool001Eoo`03001oogoo00Ioo`8000924080009oo`88@PIoo`80009oo`9g_@9cW096
<@9JeP8DY@92408icP8aS09W>@9oo`80009oo`80009oo`9cW08Q2092409[FP8U:@80008mk`8<H`9g
_@8@Q092408U:@A[FP8U:@9S609BU08e[@80009oo`@0009oo`80009oo`9BU08mk`9oo`88@P9:DP8]
J`9oo`9S609_N`96<@ABU003E[DDYABU0096<@9:DP8icP8mk`8Li`A:DP8]J`8e[@9:DP8aS096<@8Y
BP8U:@8<H`9>L`9F]@8]J`92408mk`9W>@9S609>L`9F]@800096<@9240AF]@8Q209:DP80009g_@8i
cP9oo`88@P80009oo`88@P8icP9F]@92408YBP9JeP9oo`8U:@9BU0@mk`9:DP8U:@9_N`8<H`8]J`9S
609Nm`9:DP8mk`A24096<@8DY@8e[@Eoo`40005oo`005Goo00<007ooOol02Woo0P000R480QS60THa
0Tic0Vmk0Re[0Woo0P000Vmk0QBU0Vmk0Ukg0W>L0QcW0Woo0V<H0P000Woo0P000Woo0Re[0Woo0RDY
14Ha0SF]0U:D0W>L0S6<0VLi0U[F0V]J0SW>0RDY0SF]0T8@0U:D0Vmk0T8@0QcW0Re[0V]J0Tic0Woo
0P000U[F0P@Q0Ukg0THa0T8@0Woo0P000Woo0THa0SW>0Sg_0T8@0V<H00<Q23F]=Jd00Sg_0Tic0Sg_
0T8@0Sg_0R480TYB0T8@0U[F0THa0T8@0THa0SF]0S6<0THa0TYB0RU:0T8@0SW>0Sg_0QS60V<H0Sg_
0SF]0V]J0Re[0U[F0S6<0QcW0S6<12e[0Sg_0Woo10000Woo0V]J0U:D0S6<0QBU0THa0Re[0SW>0Ukg
0SW>0Sg_0THa0Woo0P000UJe0SW>0Sg_0SW>0TYB13g_0T8@13g_0T8@0RDY0Sg_1Goo0@000Goo000E
Ool00`00Oomoo`0:Ool200028@P26<H2AS42CW<2Kg/2;F/2Ool20002Kg/25:D2Kg/2G_L2Li`27>L2
Ool2HaP20002Ool20002Ool2;F/2Ool29BT4AS42=Jd2DY@2Li`2<H`2IcT2F]H2JeX2>Lh29BT2=Jd2
@Q02DY@2Kg/2@Q027>L2;F/2JeX2CW<2Ool20002F]H21242G_L2AS42@Q02Ool20002Ool2AS42>Lh2
?Nl2@Q02HaP00b48=Jde[@02?Nl2CW<2?Nl2@Q02?Nl28@P2BU82@Q02F]H2AS42@Q02AS42=Jd2<H`2
AS42BU82:DX2@Q02>Lh2?Nl26<H2HaP2?Nl2=Jd2JeX2;F/2F]H2<H`27>L2<H`4;F/2?Nl2Ool40002
Ool2JeX2DY@2<H`25:D2AS42;F/2>Lh2G_L2>Lh2?Nl2AS42Ool20002E[D2>Lh2?Nl2>Lh2BU84?Nl2
@Q04?Nl2@Q029BT2?Nl5Ool10001Ool001Eoo`03001oogoo009oo`@0009>L`Aoo`9S60@00092408H
aP9S60@0009S60H0009g_@8Q208U:@9S609W>@80009oo`@aS09oo`80008Q2096<@9BU09oo`9:DP9o
o`88@P8mk`96<@92408DY@8mk`8YBP8icP8e[@8Li`8e[@9oo`8DY@@000Aoo`8Li`8U:@9BU08mk`9B
U080009Nm`8]J`9S608e[@9JeP8YBP037>LYBRU:0092408HaP96<@8aS09>L`8mk`8U:@8e[@92408m
k`A2408Q2096<@9:DP8mk`96<@9>L`8mk`A2408icP9BU08YBP8icP9JeP8DY@96<@9_N`8e[@9F]@80
0096<@9>L`8icP9oo`80008Q209oo`9[FP9>L`8aS0@mk`9[FP8aS09oo`8@Q09g_@88@P9>L`9BU08Q
209F]@8mk`8]J`9>L`Hmk`9:DP9>L`8mk`Eoo`40005oo`005Goo00<007ooOol00Woo10000Tic17oo
0V<H10000T8@0QS60V<H10000V<H1P000WNm0R480RDY0V<H0VLi0P000Woo136<0Woo0P000R480THa
0U:D0Woo0TYB0Woo0PQ20Sg_0THa0T8@0QBU0Sg_0RU:0SW>0SF]0QcW0SF]0Woo0QBU100017oo0QcW
0RDY0U:D0Sg_0U:D0P000Ukg0Re[0V<H0SF]0U[F0RU:00<LibU::DX00T8@0QS60THa0S6<0Tic0Sg_
0RDY0SF]0T8@0Sg_148@0R480THa0TYB0Sg_0THa0Tic0Sg_148@0SW>0U:D0RU:0SW>0U[F0QBU0THa
0Vmk0SF]0UJe0P000THa0Tic0SW>0Woo0P000R480Woo0V]J0Tic0S6<13g_0V]J0S6<0Woo0Q240WNm
0PQ20Tic0U:D0R480UJe0Sg_0Re[0Tic1Sg_0TYB0Tic0Sg_1Goo0@000Goo000EOol00`00Oomoo`02
Ool20002Ool80002Ool60002Ool2000224820006Ool200022482Ool20002@Q02Kg/2Ool20002Ool2
E[D2G_L2BU820002Ool200048@P2Li`2AS42@Q02DY@2;F/2>Lh2;F/2E[D25:D2IcT2:DX2?Nl2@Q02
JeX29BT2Ool20002Li`2Ool2<H`2DY@27>L26<H2>Lh2BU82=Jd2:DX27>L2Ool00c6<?Nlmk`02=Jd2
>Lh2?Nl2=Jd2<H`2@Q02>Lh2AS42BU82E[D236<25:D2@Q02G_L2>Lh2?Nl2@Q02<H`2>Lh4AS42BU82
9BT2AS42E[D2;F/2CW<2?Nl2>Lh2DY@2BU84@Q025:D2IcT2AS42Ool200021244Ool2=Jd2CW<4?Nl2
BU82=Jd2<H`4?Nl2=Jd2?Nl27>L4?Nl4@Q04?Nl2>Lh2AS420002E[D5Ool10001Ool001Eoo`03001o
ogoo009oo`80009oo`P0009oo`H0009oo`800088@P8000Ioo`800088@P9oo`800092409_N`9oo`80
009oo`9F]@9Nm`9:DP80009oo`8000@Q209cW096<@92409BU08]J`8icP8]J`9F]@8DY@9W>@8YBP8m
k`92409[FP8U:@9oo`80009cW09oo`8aS09BU08Li`8HaP8icP9:DP8e[@8YBP8Li`9oo`03<H`mkcg_
008e[@8icP8mk`8e[@8aS092408icP96<@9:DP9F]@8<H`8DY@92409Nm`8icP8mk`92408aS08icPA6
<@9:DP8U:@96<@9F]@8]J`9>L`8mk`8icP9BU09:DPA2408DY@9W>@96<@9oo`8000848@Aoo`8e[@9>
L`@mk`9:DP8e[@8aS0@mk`8e[@8mk`8Li`@mk`A240@mk`8icP96<@80009F]@Eoo`40005oo`005Goo
00<007ooOol017oo0P0017oo0P000Woo0P000SW>0Sg_0Woo0P000Woo0P000Woo1P0017oo0P000Woo
0Tic10000Woo0V<H0QcW0P000Woo10000Re[0V<H0Re[0SW>0Re[0Sg_0U:D0QBU0RDY0Woo0P000Tic
0Sg_0Q240Tic0Woo0P000QcW0P@Q0QcW17oo0QS60PQ20R480P001Woo0P000P@Q0P0000=6<D8@@Q00
0U:D148@0Re[0RU:0T8@0THa0SF]0S6<0Sg_0Re[0U[F0QcW0U[F0T8@0Ukg0PQ20Tic0V]J0P000S6<
13g_0V<H0QcW0Sg_0THa0SW>0THa0TYB0THa0PQ20V<H0Re[136<0SW>0R480U:D0THa0Ukg0UJe0Ukg
0Re[0S6<0SW>0Ukg0THa0QS60Tic0S6<0THa0TYB0VLi0T8@0V]J148@0RU:0RDY0TYB0Woo0QS61Goo
0@000Goo000EOol20005Ool20004Ool20002Ool20002>Lh2?Nl2Ool20002Ool20002Ool60004Ool2
0002Ool2CW<40002Ool2HaP27>L20002Ool40002;F/2HaP2;F/2>Lh2;F/2?Nl2DY@25:D29BT2Ool2
0002CW<2?Nl248@2CW<2Ool200027>L212427>L4Ool26<H224828@P20006Ool20002124200000dHa
@Q124002DY@4@Q02;F/2:DX2@Q02AS42=Jd2<H`2?Nl2;F/2F]H27>L2F]H2@Q02G_L22482CW<2JeX2
0002<H`4?Nl2HaP27>L2?Nl2AS42>Lh2AS42BU82AS422482HaP2;F/4<H`2>Lh28@P2DY@2AS42G_L2
E[D2G_L2;F/2<H`2>Lh2G_L2AS426<H2CW<2<H`2AS42BU82IcT2@Q02JeX4@Q02:DX29BT2BU82Ool2
6<H4Ool20001Ool001Eoo`03001oogoo009oo`88@PX000Ioo`80009W>@@000Aoo`80009cW0848@80
009oo`80008DY@9JeP9kgP@0009oo`80009oo`8000Ioo`9W>@9JeP9>L`9:DP96<@9W>@80009oo`9F
]@8DY@8HaP8<H`9F]@9Nm`8aS09JeP8YBP9JeP8<H`80008U:@9oo`8Q20@00096<@9oo`A:DP9oo`03
;F/mkcg_008e[@8mk`8e[@8icP9JeP8e[@9W>@8]J`9BU08e[@92409F]@8e[@8icP8e[@80009JeP9o
o`80009JeP9:DP@icP8YBP9BU08aS08YBP9JeP8Q208mk`9>L`8e[@9>L`8YBPA2408icP8e[@9:DP8e
[@8mk`8e[@92408Li`9:DP9oo`9S609JeP8icP8mk`8@Q08aS08YBP8]J`9>L`8U:@A6<@8aS0A6<@80
009F]@Eoo`40005oo`005Goo00<007ooOol00Woo0PQ22P001Woo0P000VLi100017oo0P000W>L0P@Q
0P000Woo0P000QBU0U[F0W_N10000Woo0P000Woo0P001Woo0VLi0U[F0Tic0TYB0THa0VLi0P000Woo
0UJe0QBU0QS60PaS0UJe0Ukg0S6<0U[F0RU:0U[F0PaS0P000RDY0Woo0R4810000THa0Woo14YB0Woo
00<]Jcg_?Nl00SF]0Sg_0SF]0SW>0U[F0SF]0VLi0Re[0U:D0SF]0T8@0UJe0SF]0SW>0SF]0P000U[F
0Woo0P000U[F0TYB13W>0RU:0U:D0S6<0RU:0U[F0R480Sg_0Tic0SF]0Tic0RU:148@0SW>0SF]0TYB
0SF]0Sg_0SF]0T8@0QcW0TYB0Woo0V<H0U[F0SW>0Sg_0Q240S6<0RU:0Re[0Tic0RDY14Ha0S6<14Ha
0P000UJe1Goo0@000Goo000EOol00`00Oomoo`04Ool20002Ool60002Ool40002CW<2JeX20004Ool2
:DX2Ool2CW<2>Lh4Ool2F]H20002:DX2Mkd2Ool2=Jd2Ool20002Ool28@P2JeX2@Q02<H`2HaP2:DX2
E[D2<H`2?Nl29BT2Ool2@Q02AS42DY@2E[D2Ool21242IcT25:D2E[D248@2F]H224828@P2IcT20002
Ool25:D20002Ool2>Lh2?Nl28@P2E[D00e[F?Nlmk`02CW<4;F/2>Lh29BT2?Nl2BU82>Lh2DY@2=Jd2
BU82=Jd4@Q02<H`2Ool2=Jd26<H2E[D2AS44?Nl2@Q04AS42E[D29BT236<2=Jd2?Nl2BU82;F/2?Nl2
<H`2BU82<H`2?Nl29BT2CW<2AS42;F/2>Lh2<H`2CW<2E[D2@Q0248@2AS44Ool2000236<2AS42<H`2
HaP4?Nl2@Q02AS44>Lh4=Jd5Ool10001Ool001Eoo`03001oogoo00Aoo`80009oo`H0009oo`@0009>
L`9[FP8000Aoo`8YBP9oo`9>L`8icPAoo`9JeP80008YBP9g_@9oo`8e[@9oo`80009oo`8Q209[FP92
408aS09S608YBP9F]@8aS08mk`8U:@9oo`924096<@9BU09F]@9oo`848@9W>@8DY@9F]@8@Q09JeP88
@P8Q209W>@80009oo`8DY@80009oo`8icP8mk`8Q209F]@03F]Hmkcg_009>L`@]J`8icP8U:@8mk`9:
DP8icP9BU08e[@9:DP8e[@A2408aS09oo`8e[@8HaP9F]@96<@@mk`9240A6<@9F]@8U:@8<H`8e[@8m
k`9:DP8]J`8mk`8aS09:DP8aS08mk`8U:@9>L`96<@8]J`8icP8aS09>L`9F]@92408@Q096<@Aoo`80
008<H`96<@8aS09S60@mk`924096<@@icP@e[@Eoo`40005oo`005Goo00<007ooOol00Woo1P000Woo
10001Woo0P000UJe10000R480Woo10000UJe0P000Woo0P000Woo0RU:0WNm0P@Q10000Woo0Q240TYB
0UJe0Woo0U[F0SF]0SW>0Q240WNm0T8@0P000Woo0P000Woo0P000Woo0THa1SW>0UJe0THa0Tic0QBU
0UJe0Tic0Woo0P000Woo0Re[0TYB0SW>0THa0Re[0RU:00=6<CW>>Lh00SF]0Sg_0UJe0Sg_0S6<0UJe
0T8@0S6<0SW>0T8@0U[F0UJe0THa0SF]0P000TYB0Woo0R480SW>0Re[17oo0P000Woo0QBU0U:D0Sg_
0T8@0SW>0Sg_148@0SW>0S6<0T8@23g_0T8@0SF]0SW>0U:D0Q240V<H0Woo0SW>0P000THa0Ukg0T8@
0V<H0S6<0Sg_0S6<0Tic0RU:0T8@0THa0Sg_0SW>0QcW0SW>1Goo0@000Goo000EOol00`00Oomoo`02
Ool60002Ool40006Ool20002E[D400028@P2Ool40002E[D20002Ool20002Ool2:DX2Mkd212440002
Ool248@2BU82E[D2Ool2F]H2=Jd2>Lh248@2Mkd2@Q020002Ool20002Ool20002Ool2AS46>Lh2E[D2
AS42CW<25:D2E[D2CW<2Ool20002Ool2;F/2BU82>Lh2AS42;F/2:DX00dHa>LhicP02=Jd2?Nl2E[D2
?Nl2<H`2E[D2@Q02<H`2>Lh2@Q02F]H2E[D2AS42=Jd20002BU82Ool28@P2>Lh2;F/4Ool20002Ool2
5:D2DY@2?Nl2@Q02>Lh2?Nl4@Q02>Lh2<H`2@Q08?Nl2@Q02=Jd2>Lh2DY@248@2HaP2Ool2>Lh20002
AS42G_L2@Q02HaP2<H`2?Nl2<H`2CW<2:DX2@Q02AS42?Nl2>Lh27>L2>Lh5Ool10001Ool001Eoo`03
001oogoo009oo`80009kgP9oo`8000Aoo`H0009oo`8Q20Ioo`8000Aoo`9_N`8000Aoo`8e[@8HaP9F
]@8000Ioo`9W>@9oo`80009:DP8mk`9BU09JeP9F]@8]J`8icP9oo`80009oo`848@9oo`8DY@8aS09J
eP8mk`@aS0A24080009oo`80009oo`9>L`8U:@9BU09JeP8e[@8mk`9F]@800003CW=2448@008]J`8m
k`8icP9>L`9cW09JeP8aS08@Q09Nm`8]J`8aS09BU08aS0A:DP8Q2080009g_@96<@9kgP8Li`80009o
o`8e[@9>L`8e[@9:DP8e[@9BU08mk`96<@8e[@8aS08U:@96<@92408e[@96<@8YBP924080008YBP9o
o`88@P80008Q209S608e[@9[FP8aS09F]@96<@9JeP9Nm`96<@8e[@9240Pmk`9oo`8HaPEoo`40005o
o`001goo10000goo0P001Goo00<007ooOol00Woo0P000W_N0Woo0P0017oo1P000Woo0R481Woo0P00
17oo0Vmk0P0017oo0SF]0QS60UJe0P001Woo0VLi0Woo0P000TYB0Sg_0U:D0U[F0UJe0Re[0SW>0Woo
0P000Woo0P@Q0Woo0QBU0S6<0U[F0Sg_136<148@0P000Woo0P000Woo0Tic0RDY0U:D0U[F0SF]0Sg_
0UJe0P0000=>Ld8@@Q000Re[0Sg_0SW>0Tic0W>L0U[F0S6<0Q240Ukg0Re[0S6<0U:D0S6<14YB0R48
0P000WNm0THa0W_N0QcW0P000Woo0SF]0Tic0SF]0TYB0SF]0U:D0Sg_0THa0SF]0S6<0RDY0THa0T8@
0SF]0THa0RU:0T8@0P000RU:0Woo0PQ20P000R480V<H0SF]0V]J0S6<0UJe0THa0U[F0Ukg0THa0SF]
0T8@23g_0Woo0QS61Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol0
0Woo0P000Woo0P@Q0P001Woo0U[F0Ukg1P000W_N0T8@0UJe0SW>0SF]0Q240VLi10000THa0V<H0SW>
0Woo0P000U:D0SW>0Sg_0TYB0QcW0U[F14Ha0SF]0SW>0Re[0Tic0Re[0UJe0S6<0RDY0Woo0P000UJe
0THa0Sg_0V]J0SF]0U:D0P000Woo0P000Woo13g_0T8@0Sg_0SW>0T8@0Sg_0T8@0P@Q00<mkb488@P0
136<13F]0Re[0TYB0T8@0Sg_0Tic0THa0Sg_148@0Re[148@0Tic0T8@0TYB0S6<0Re[0SF]0Woo0P00
15Je0S6<0Sg_0S6<0Sg_0T8@0SW>0U[F12U:0Sg_0U[F0S6<0Q2417oo0P000SF]0Vmk0Ukg0SW>0Sg_
0T8@0Sg_0T8@1Sg_0SW>3Sg_0UJe0THa1Goo0@000Goo0008Ool00`00Oomoo`02Ool01000Oomoo`00
17oo0P000goo0P000Woo0P@Q0P001Woo0U[F0Ukg1P000W_N0T8@0UJe0SW>0SF]0Q240VLi10000THa
0V<H0SW>0Woo0P000U:D0SW>0Sg_0TYB0QcW0U[F14Ha0SF]0SW>0Re[0Tic0Re[0UJe0S6<0RDY0Woo
0P000UJe0THa0Sg_0V]J0SF]0U:D0P000Woo0P000Woo13g_0T8@0Sg_0SW>0T8@0Sg_0T8@0P@Q00<m
kb488@P0136<13F]0Re[0TYB0T8@0Sg_0Tic0THa0Sg_148@0Re[148@0Tic0T8@0TYB0S6<0Re[0SF]
0Woo0P0015Je0S6<0Sg_0S6<0Sg_0T8@0SW>0U[F12U:0Sg_0U[F0S6<0Q2417oo0P000SF]0Vmk0Ukg
0SW>0Sg_0T8@0Sg_0T8@1Sg_0SW>3Sg_0UJe0THa17oo0P000Goo0009Ool01@00Oomoogoo00000Woo
00<007ooOol00Woo00<007ooOol01Woo0QS60P000UJe0QcW0V]J0Woo0RU:1P000SW>0TYB13F]0QBU
0RDY0WNm0U[F0Woo0THa0R4810000Woo11S60Tic0SW>0V]J0RU:0SF]0S6<0V<H0SW>0SF]0Woo0U[F
0QcW0TYB0T8@0R480Woo0P000SF]0Sg_0THa0SW>0P000Woo0P000SW>0Sg_0THa0TYB0Tic0RU:0SF]
0T8@13g_0U:D00=F]CW>>Lh013g_0TYB0Sg_0TYB0U:D0Sg_0QS60Sg_0TYB0Re[0U:D0U[F0QS60UJe
0S6<0RDY0TYB0THa0Sg_0SF]0U[F0Re[0U[F0TYB0QBU0U:D0V]J0R480V<H0SW>0SF]0SW>0TYB0THa
0V<H0P@Q0Woo0SF]0P000Woo0QS614ic13g_0TYB0Re[0T8@1Sg_0S6<0Sg_0TYB2Sg_0T8@0S6<0T8@
1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo00Ioo`8HaP80009F
]@8Li`9[FP9oo`8YBPH0008icP9:DP@e[@8DY@8U:@9g_@9JeP9oo`96<@8Q20@0009oo`@HaP9>L`8i
cP9[FP8YBP8e[@8aS09S608icP8e[@9oo`9JeP8Li`9:DP92408Q209oo`80008e[@8mk`96<@8icP80
009oo`80008icP8mk`96<@9:DP9>L`8YBP8e[@9240@mk`9BU003E[DicSW>00@mk`9:DP8mk`9:DP9B
U08mk`8HaP8mk`9:DP8]J`9BU09JeP8HaP9F]@8aS08U:@9:DP96<@8mk`8e[@9JeP8]J`9JeP9:DP8D
Y@9BU09[FP8Q209S608icP8e[@8icP9:DP96<@9S60848@9oo`8e[@80009oo`8HaPA>L`@mk`9:DP8]
J`9240Hmk`8aS08mk`9:DPXmk`92408aS09240Eoo`40005oo`0027oo0P0017oo0P001Goo00<007oo
Ool017oo0P000S6<0TYB0SW>13g_0T8@0RDY0V<H0Woo0U[F0Ukg0RU:0U:D0RU:0U:D0P000U:D0THa
0QcW0P000U[F0Woo0RDY0R480Vmk0TYB0Sg_0Re[13g_0RU:0U:D0R480SF]0THa0V<H0U:D0P000TYB
0T8@0SF]0TYB0Woo0P000U[F0Tic0PaS0Woo0P000PaS0Woo0QBU0Woo0T8@0UJe0Re[0W>L13g_0S6<
0THa00=BU4HaAS400U[F0SW>0S6<0Ukg0SW>0T8@0QBU0SW>0Sg_0THa0Re[0U:D0V<H0TYB0Sg_0Tic
0Re[0T8@0Sg_1T8@0QBU0SW>0T8@0TYB0Tic0QBU0Sg_0Tic0SF]0U:D0R480Tic0QS60RU:0Woo0P00
0TYB0T8@0U[F0V<H0Re[0T8@0RU:0RDY0V<H0Re[0Sg_0SW>14Ha0SF]12U:13g_0T8@0Sg_0T8@0RU:
0THa0U[F1Goo0@000Goo000EOol00`00Oomoo`04Ool20002<H`2BU82>Lh4?Nl2@Q029BT2HaP2Ool2
F]H2G_L2:DX2DY@2:DX2DY@20002DY@2AS427>L20002F]H2Ool29BT28@P2Kg/2BU82?Nl2;F/4?Nl2
:DX2DY@28@P2=Jd2AS42HaP2DY@20002BU82@Q02=Jd2BU82Ool20002F]H2CW<236<2Ool2000236<2
Ool25:D2Ool2@Q02E[D2;F/2Li`4?Nl2<H`2AS400e:DAS56<@02F]H2>Lh2<H`2G_L2>Lh2@Q025:D2
>Lh2?Nl2AS42;F/2DY@2HaP2BU82?Nl2CW<2;F/2@Q02?Nl6@Q025:D2>Lh2@Q02BU82CW<25:D2?Nl2
CW<2=Jd2DY@28@P2CW<26<H2:DX2Ool20002BU82@Q02F]H2HaP2;F/2@Q02:DX29BT2HaP2;F/2?Nl2
>Lh4AS42=Jd4:DX4?Nl2@Q02?Nl2@Q02:DX2AS42F]H5Ool10001Ool001Eoo`03001oogoo00Ioo`80
008Li`9cW09oo`8U:@aoo`8@Q09:DP96<@9:DP9S609W>@88@P8]J`9oo`80009oo`9F]@9oo`9cW08i
cP9Nm`9oo`8YBP8mk`9JeP8icP9W>@8]J`9:DPA6<@9kgP8Li`8e[@8YBP8DY@9S609oo`80009oo`8@
Q080009oo`92408aS09W>@800096<@8mk`9_N`8icP8mk`9:DP9>L`8YBP03001:DTYB008Q209240@m
k`92408]J`96<@8mk`8aS0@mk`9F]@9JeP8U:@96<@A2408U:@92408mk`8aS08]J`96<@9F]@9>L`9N
m`8e[@96<@8YBP8icP96<@9F]@9Nm`8Li`AS6080009Nm`@aS08mk`92408aS08mk`9cW08aS08mk`96
<@8Q2096<@8mk`8Q209F]@8aS08HaP9F]@96<@8U:@9:DP8mk`9:DP8icP8Q20Eoo`40005oo`005Goo
00<007ooOol01Woo0P000QcW0W>L0Woo0RDY37oo0Q240TYB0THa0TYB0V<H0VLi0PQ20Re[0Woo0P00
0Woo0UJe0Woo0W>L0SW>0Ukg0Woo0RU:0Sg_0U[F0SW>0VLi0Re[0TYB14Ha0W_N0QcW0SF]0RU:0QBU
0V<H0Woo0P000Woo0Q240P000Woo0T8@0S6<0VLi0P000THa0Sg_0Vmk0SW>0Sg_0TYB0Tic0RU:00<0
04YBBU800R480T8@13g_0T8@0Re[0THa0Sg_0S6<13g_0UJe0U[F0RDY0THa148@0RDY0T8@0Sg_0S6<
0Re[0THa0UJe0Tic0Ukg0SF]0THa0RU:0SW>0THa0UJe0Ukg0QcW16<H0P000Ukg136<0Sg_0T8@0S6<
0Sg_0W>L0S6<0Sg_0THa0R480THa0Sg_0R480UJe0S6<0QS60UJe0THa0RDY0TYB0Sg_0TYB0SW>0R48
1Goo0@000Goo000EOol00`00Oomoo`04Ool4?Nl40002:DX2>Lh200025:D2BU820002Ool29BT2E[D2
;F/4?Nl2G_L2Li`2BU82JeX236<2:DX2=Jd2?Nl2HaP2=Jd2<H`2E[D2=Jd2E[D2<H`27>L2Li`2<H`2
Mkd248@2E[D2@Q026<H2DY@28@P2BU82=Jd2;F/2>Lh2Ool20002Ool28@P25:D2<H`2G_L2:DX4?Nl2
CW<29BT2<H`2:DX4?Nl26<H3AS42?Nl2BU82<H`2BU82CW<2@Q02?Nl2E[D2BU82?Nl28@P2BU82?Nl2
=Jd2AS42G_L2:DX2BU82?Nl2CW<27>L2CW<2?Nl2AS429BT2?Nl2=Jd2>Lh26<H2@Q02BU82DY@20002
@Q02E[D26<H2E[D29BT4AS42F]H2AS42>Lh2?Nl4@Q04?Nl2@Q02>Lh2=Jd2E[D2BU82?Nl2<H`2;F/2
>Lh6?Nl2>Lh2:DX2@Q05Ool10001Ool001Eoo`03001oogoo00Aoo`@mk`@0008YBP8icP80008DY@9:
DP80009oo`8U:@9F]@8]J`@mk`9Nm`9cW09:DP9[FP8<H`8YBP8e[@8mk`9S608e[@8aS09F]@8e[@9F
]@8aS08Li`9cW08aS09g_@8@Q09F]@92408HaP9BU08Q209:DP8e[@8]J`8icP9oo`80009oo`8Q208D
Y@8aS09Nm`8YBP@mk`9>L`8U:@8aS08YBP@mk`8HaP=6<@8mk`9:DP8aS09:DP9>L`92408mk`9F]@9:
DP8mk`8Q209:DP8mk`8e[@96<@9Nm`8YBP9:DP8mk`9>L`8Li`9>L`8mk`96<@8U:@8mk`8e[@8icP8H
aP92409:DP9BU0800092409F]@8HaP9F]@8U:@A6<@9JeP96<@8icP8mk`A240@mk`92408icP8e[@9F
]@9:DP8mk`8aS08]J`8icPHmk`8icP8YBP9240Eoo`40005oo`005Goo00<007ooOol00Woo0V<H0Woo
0UJe0S6<0P000UJe0RU:0Tic0RU:0Re[0P000U:D0SF]0TYB0S6<0QBU0P000W_N0RU:0U[F0TYB0VLi
0Woo0P000T8@0TYB0Tic0Sg_0T8@0THa0UJe0SF]0QcW0Re[0THa0Sg_0TYB0SW>0V<H0SF]0S6<0THa
0S6<0U:D0Sg_0QS60RDY0Woo0P000Woo0Tic0QcW0T8@0RU:0THa0SF]0U[F0Re[148@0Sg_0TYB0V<H
00=243g_?Nl00T8@0Sg_0UJe0Sg_0Re[0TYB0U:D0U[F0SW>0R480TYB0THa0SF]0THa0TYB0S6<0THa
0Sg_0SF]0Sg_0U:D0RDY0THa0SF]0WNm0THa0TYB0U:D0S6<0U:D0R480T8@0Woo0Re[0Q240W_N0P00
14Ha0RU:13g_0THa0SW>0Re[0T8@0Sg_0T8@0R480RU:0S6<0SW>0TYB0Sg_148@23g_0TYB0RU:0SF]
1Goo0@000Goo000EOol20003Ool2HaP2Ool2E[D2<H`20002E[D2:DX2CW<2:DX2;F/20002DY@2=Jd2
BU82<H`25:D20002Nmh2:DX2F]H2BU82IcT2Ool20002@Q02BU82CW<2?Nl2@Q02AS42E[D2=Jd27>L2
;F/2AS42?Nl2BU82>Lh2HaP2=Jd2<H`2AS42<H`2DY@2?Nl26<H29BT2Ool20002Ool2CW<27>L2@Q02
:DX2AS42=Jd2F]H2;F/4@Q02?Nl2BU82HaP00d8@?Nlmk`02@Q02?Nl2E[D2?Nl2;F/2BU82DY@2F]H2
>Lh28@P2BU82AS42=Jd2AS42BU82<H`2AS42?Nl2=Jd2?Nl2DY@29BT2AS42=Jd2Mkd2AS42BU82DY@2
<H`2DY@28@P2@Q02Ool2;F/248@2Nmh20004AS42:DX4?Nl2AS42>Lh2;F/2@Q02?Nl2@Q028@P2:DX2
<H`2>Lh2BU82?Nl4@Q08?Nl2BU82:DX2=Jd4Ool20001Ool001Eoo`03001oogoo009oo`848@9oo`9J
eP8U:@@icP8Q208aS09F]@8e[@9oo`9>L`80008mk`@YBP96<@8@Q09oo`8Q20@0008mk`8Q20ABU09o
o`9[FP@e[@8Q208HaP9F]@8Li`88@P8e[@@icP9F]@9BU0@mk`8]J`8icP8e[@96<@8Li`8e[@9oo`80
008]J`8e[@96<@9>L`8icP9oo`80009>L`8icP@mk`@aS003=Jdmkcg_008mk`9W>@@mk`8U:@9Nm`8U
:@9F]@800096<@8icP92408icP96<@92408mk`96<@8mk`92408mk`9BU08aS08]J`9BU08YBP9g_@96
<@8U:@9F]@8DY@9F]@8mk`8YBP8U:@9oo`80009oo`96<@924096<@8Q2092408mk`924096<@8icP8m
k`9JeP9kgP80009_N`8e[@9kgP8icP96<@Xmk`8aS08e[@9240Eoo`40005oo`005Goo00<007ooOol0
0Woo0P@Q0Woo0U[F0RDY13W>0R480S6<0UJe0SF]0Woo0Tic0P000Sg_12U:0THa0Q240Woo0R481000
0Sg_0R4815:D0Woo0V]J13F]0R480QS60UJe0QcW0PQ20SF]13W>0UJe0U:D13g_0Re[0SW>0SF]0THa
0QcW0SF]0Woo0P000Re[0SF]0THa0Tic0SW>0Woo0P000Tic0SW>13g_136<00<e[Cg_?Nl00Sg_0VLi
13g_0RDY0Ukg0RDY0UJe0P000THa0SW>0T8@0SW>0THa0T8@0Sg_0THa0Sg_0T8@0Sg_0U:D0S6<0Re[
0U:D0RU:0WNm0THa0RDY0UJe0QBU0UJe0Sg_0RU:0RDY0Woo0P000Woo0THa0T8@0THa0R480T8@0Sg_
0T8@0THa0SW>0Sg_0U[F0W_N0P000Vmk0SF]0W_N0SW>0THa2Sg_0S6<0SF]0T8@1Goo0@000Goo000E
Ool00`00Oomoo`02Ool60002:DX22482E[D2HaP29BT248@2G_L2Kg/27>L2Ool2:DX2=Jd2E[D20002
HaP2CW<2AS42F]H2G_L248@2Ool2DY@2<H`20002CW<2=Jd2?Nl2HaP2F]H2@Q02>Lh2CW<2E[D2?Nl2
F]H2>Lh2DY@2@Q02>Lh2?Nl25:D236<2IcT2<H`2F]H20004Ool2?Nl2@Q02>Lh2:DX22482Ool2=Jd2
5:D2>Lh2@Q02>Lh2HaP00bU:;F/]J`02?Nl2<H`2E[D2=Jd2?Nl2CW<2>Lh29BT2AS42@Q02<H`4CW<2
8@P2@Q02?Nl2DY@2<H`2@Q02?Nl2>Lh2?Nl2E[D2:DX2<H`2DY@27>L2HaP28@P236<4=Jd2;F/21242
:DX2Ool20002HaP2DY@28@P2DY@2AS42?Nl2>Lh2G_L2>Lh2:DX2F]H236<2HaP248@2>Lh2DY@2BU82
9BT2BU82>Lh2@Q04?Nl2@Q02:DX2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`H0008YBP88@P9F
]@9S608U:@8@Q09Nm`9_N`8Li`9oo`8YBP8e[@9F]@80009S609>L`96<@9JeP9Nm`8@Q09oo`9BU08a
S080009>L`8e[@8mk`9S609JeP92408icP9>L`9F]@8mk`9JeP8icP9BU092408icP8mk`8DY@8<H`9W
>@8aS09JeP8000Aoo`8mk`92408icP8YBP88@P9oo`8e[@8DY@8icP92408icP9S6003:DX]Jbe[008m
k`8aS09F]@8e[@8mk`9>L`8icP8U:@96<@92408aS0A>L`8Q2092408mk`9BU08aS092408mk`8icP8m
k`9F]@8YBP8aS09BU08Li`9S608Q208<H`@e[@8]J`848@8YBP9oo`80009S609BU08Q209BU096<@8m
k`8icP9Nm`8icP8YBP9JeP8<H`9S608@Q08icP9BU09:DP8U:@9:DP8icP9240@mk`92408YBP8e[@Eo
o`40005oo`005Goo00<007ooOol00Woo0T8@0Ukg0Woo0THa0Woo0PaS0P000W_N0VLi0R480Ukg0RU:
0P000QS60SF]13g_0Ukg0S6<0W>L0SF]0QS60SW>0THa0SF]0U[F0Woo0S6<0QBU0PaS0SF]0W>L0Re[
0QcW0THa0Sg_0SW>0QcW0Sg_13F]0U:D0SW>0T8@0Re[0P000W>L0Q240V]J0Woo0QBU0Re[0SW>0Vmk
0THa0T8@0P000RDY0R480VLi0THa0Tic0U:D00<LicW>>Lh00TYB0UJe0Re[0Tic0Re[0Sg_0SF]0SW>
13g_13W>0RDY0UJe0T8@0Sg_0SF]0T8@0THa0T8@0TYB0Sg_0SF]0T8@0Sg_0TYB0T8@0SW>0RU:0Tic
0SF]0S6<0U[F0TYB12U:0WNm0Sg_0UJe0SF]0T8@13g_0THa0V]J0Tic0Sg_0QBU0SW>0Re[0Sg_0UJe
0SW>0TYB0Sg_0RU:0U:D0SW>0T8@0Re[0Sg_148@1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02
G_L2Ool2AS42Ool236<20002Nmh2IcT28@P2G_L2:DX200026<H2=Jd4?Nl2G_L2<H`2Li`2=Jd26<H2
>Lh2AS42=Jd2F]H2Ool2<H`25:D236<2=Jd2Li`2;F/27>L2AS42?Nl2>Lh27>L2?Nl4=Jd2DY@2>Lh2
@Q02;F/20002Li`248@2JeX2Ool25:D2;F/2>Lh2Kg/2AS42@Q0200029BT28@P2IcT2AS42CW<2DY@0
0acW>LhicP02BU82E[D2;F/2CW<2;F/2?Nl2=Jd2>Lh4?Nl4>Lh29BT2E[D2@Q02?Nl2=Jd2@Q02AS42
@Q02BU82?Nl2=Jd2@Q02?Nl2BU82@Q02>Lh2:DX2CW<2=Jd2<H`2F]H2BU84:DX2Mkd2?Nl2E[D2=Jd2
@Q04?Nl2AS42JeX2CW<2?Nl25:D2>Lh2;F/2?Nl2E[D2>Lh2BU82?Nl2:DX2DY@2>Lh2@Q02;F/2?Nl4
@Q05Ool10001Ool001Eoo`03001oogoo009oo`8aS080009Nm`8<H`8Q209F]@9>L`96<@9>L`96<@Ao
o`9S6096<@9240Aoo`8e[@8icP9oo`8Li`8e[@8DY@9[FP92408Li`8aS09>L`8mk`9F]@8icP8HaP8D
Y@8icP8]J`9BU08aS08icP96<@8mk`92409JeP8U:@@]J`8mk`80008mk`9>L`9oo`80009>L`9BU08]
J`8mk`8aS09>L`96<@@mk`8icP9BU08mk`03<HaS66<H0096<@@mk`8e[@92408icP8]J`9>L`96<@9:
DP8Li`8icP8]J`@mk`92408mk`8e[@9>L`8mk`9>L`8YBPA2408YBP8]J`Hmk`ABU092408aS08HaP8m
k`8aS09W>@8Li`8HaP8]J`8aS0@icP8mk`@]J`92408mk`8icP96<@9:DP9F]@9JeP@mk`92408mk`I2
409>L`8e[@9240Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0P000Ukg0PaS0R480UJe0Tic0THa
0Tic0THa17oo0V<H0THa0T8@17oo0SF]0SW>0Woo0QcW0SF]0QBU0V]J0T8@0QcW0S6<0Tic0Sg_0UJe
0SW>0QS60QBU0SW>0Re[0U:D0S6<0SW>0THa0Sg_0T8@0U[F0RDY12e[0Sg_0P000Sg_0Tic0Woo0P00
0Tic0U:D0Re[0Sg_0S6<0Tic0THa13g_0SW>0U:D0Sg_00<aS6<HHaP00THa13g_0SF]0T8@0SW>0Re[
0Tic0THa0TYB0QcW0SW>0Re[13g_0T8@0Sg_0SF]0Tic0Sg_0Tic0RU:148@0RU:0Re[1Sg_15:D0T8@
0S6<0QS60Sg_0S6<0VLi0QcW0QS60Re[0S6<13W>0Sg_12e[0T8@0Sg_0SW>0THa0TYB0UJe0U[F13g_
0T8@0Sg_1T8@0Tic0SF]0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool20002Ool236<2000248@2
0002Ool2?Nl20002E[D2Ool20002JeX20002Ool2Mkd22482=Jd2?Nl2<H`2HaP2CW<4Ool2000248@2
Ool2;F/2BU820002Ool2F]H2<H`2AS42>Lh2:DX2Nmh29BT2Kg/2=Jd2<H`2@Q02;F/2IcT28@P2CW<2
=Jd2AS42>Lh2F]H20002Ool2<H`2=Jd2<H`2F]H2BU829BT2?Nl2@Q02>Lh27>L2Ool00dYB8@PQ2002
E[D2CW<2F]H2@Q02:DX2AS42>Lh2?Nl2<H`2@Q02AS42?Nl2E[D2=Jd2;F/2?Nl2@Q02?Nl2<H`2@Q02
?Nl2<H`2AS42>Lh2CW<2<H`2BU82@Q049BT2IcT29BT2E[D2?Nl4CW<2;F/2AS420002IcT2@Q02>Lh2
5:D2?Nl2F]H2?Nl2=Jd2@Q02IcT2=Jd2@Q02Kg/2BU86?Nl2@Q08?Nl20002E[D5Ool10001Ool001Eo
o`8000=oo`80009oo`8<H`80008@Q080009oo`8mk`80009F]@9oo`80009[FP80009oo`9g_@88@P8e
[@8mk`8aS09S609>L`Aoo`80008@Q09oo`8]J`9:DP80009oo`9JeP8aS096<@8icP8YBP9kgP8U:@9_
N`8e[@8aS092408]J`9W>@8Q209>L`8e[@96<@8icP9JeP80009oo`8aS08e[@8aS09JeP9:DP8U:@8m
k`92408icP8Li`9oo`03BU8Q2248009F]@9>L`9JeP92408YBP96<@8icP8mk`8aS0924096<@8mk`9F
]@8e[@8]J`8mk`92408mk`8aS092408mk`8aS096<@8icP9>L`8aS09:DP9240@U:@9W>@8U:@9F]@8m
k`A>L`8]J`96<@80009W>@92408icP8DY@8mk`9JeP8mk`8e[@92409W>@8e[@92409_N`9:DPHmk`92
40Pmk`80009F]@Aoo`80005oo`005Goo00<007ooOol017oo10000Woo0P000Woo0P001Woo0P000Woo
0P000Woo10000RU:0V<H0Tic0Woo0W_N0Q240Ukg0P000Woo0RU:0QS60SF]0P000Woo0P000Sg_0U:D
0Re[0T8@0S6<0Sg_0Vmk0TYB0UJe0P@Q0Re[0W_N0U[F0SF]0PaS0SF]0P000QBU0Re[0P000Woo0RU:
0VLi0SW>0TYB0QBU0U[F0T8@0QcW17oo0P0000=6<Cg_?Nl00TYB14Ha0S6<0THa0SW>0T8@0THa13g_
0Re[0THa0S6<0SW>0SF]0TYB0THa0RU:0U:D0T8@0QS6148@0Tic0T8@0S6<0Tic0THa0QcW0Q240Ukg
0TYB0P000SW>0S6<0RDY0SW>0R480Sg_0VLi0TYB0SW>0RU:13g_0THa0S6<0SW>0U:D0T8@0TYB0THa
0S6<0T8@0THa0RDY13F]0V]J0Woo0W>L0Woo0QBU1Goo0@000Goo000EOol00`00Oomoo`04Ool40002
Ool20002Ool20006Ool20002Ool20002Ool40002:DX2HaP2CW<2Ool2Nmh248@2G_L20002Ool2:DX2
6<H2=Jd20002Ool20002?Nl2DY@2;F/2@Q02<H`2?Nl2Kg/2BU82E[D21242;F/2Nmh2F]H2=Jd236<2
=Jd200025:D2;F/20002Ool2:DX2IcT2>Lh2BU825:D2F]H2@Q027>L4Ool200000dHa?Nlmk`02BU84
AS42<H`2AS42>Lh2@Q02AS44?Nl2;F/2AS42<H`2>Lh2=Jd2BU82AS42:DX2DY@2@Q026<H4@Q02CW<2
@Q02<H`2CW<2AS427>L248@2G_L2BU820002>Lh2<H`29BT2>Lh28@P2?Nl2IcT2BU82>Lh2:DX4?Nl2
AS42<H`2>Lh2DY@2@Q02BU82AS42<H`2@Q02AS429BT4=Jd2JeX2Ool2Li`2Ool25:D5Ool10001Ool0
01Eoo`03001oogoo009oo`8Q2080009oo`80008]J`Ioo`8U:@9oo`848@8@Q0@0009oo`8]J`9W>@8e
[@8]J`80008e[@9[FP8mk`9BU09>L`8U:@9240@0009oo`9BU09JeP9BU09Nm`9BU08Q2092408mk`9_
N`@]J`9g_@9BU08icP92409BU080009oo`9BU08YBP9F]@9>L`Hmk`9:DP8000Aoo`80008mk`9Nm`9B
U003<Ha2448@00HicP8mk`9_N`8Q209:DP9BU08e[@9240@mk`92408e[@92408aS08e[@9240@Q209o
o`8U:@9BU08aS08mk`92409:DP8mk`92409>L`80009oo`88@P9>L`96<@9>L`8]J`@mk`8Li`9>L`8i
cP924096<@9240Hmk`8icP9>L`8U:@8aS0924096<@9F]@80008<H`8Q209S608mk`9:DP8icP8mk`Eo
o`40005oo`005Goo00<007ooOol00Woo0R480P000Woo0P000Re[1Woo0RDY0Woo0P@Q0Q2410000Woo
0Re[0VLi0SF]0Re[0P000SF]0V]J0Sg_0U:D0Tic0RDY0T8@10000Woo0U:D0U[F0U:D0Ukg0U:D0R48
0T8@0Sg_0Vmk12e[0WNm0U:D0SW>0T8@0U:D0P000Woo0U:D0RU:0UJe0Tic1Sg_0TYB0P0017oo0P00
0Sg_0Ukg0U:D00<aS48@@Q001SW>0Sg_0Vmk0R480TYB0U:D0SF]0T8@13g_0T8@0SF]0T8@0S6<0SF]
0T8@12480Woo0RDY0U:D0S6<0Sg_0T8@0TYB0Sg_0T8@0Tic0P000Woo0PQ20Tic0THa0Tic0Re[13g_
0QcW0Tic0SW>0T8@0THa0T8@1Sg_0SW>0Tic0RDY0S6<0T8@0THa0UJe0P000PaS0R480V<H0Sg_0TYB
0SW>0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool248@2@Q02Ool2<H`20002Ool2E[D2CW<2DY@2
G_L4E[D400026<H2AS42IcT6=Jd2Kg/2?Nl28@P2=Jd2AS420002=Jd20002Ool2CW<27>L2;F/2@Q02
<H`2BU82AS42>Lh2DY@2AS42CW<2@Q02DY@27>L2?Nl248@4>Lh2HaP2=Jd2AS42>Lh2JeX2G_L29BT2
DY@2CW<2AS42:DX2DY@2AS420002Li`2=Jd00cW>?Nlmk`08?Nl29BT4?Nl2@Q02AS44?Nl2=Jd2BU82
>Lh2;F/2=Jd2AS42=Jd2CW<2:DX2BU82?Nl2AS42BU82AS42CW<29BT2CW<2>Lh2G_L2=Jd2AS42>Lh2
=Jd4?Nl2AS42>Lh4?Nl4E[D2DY@2AS42<H`2AS42;F/2>Lh2IcT2>Lh2AS42E[D2>Lh27>L2DY@2Li`2
36<27>L2AS42E[D2BU82AS42>Lh5Ool10001Ool001Eoo`03001oogoo009oo`8@Q092409oo`8aS080
009oo`9F]@9>L`9BU09Nm`AF]@@0008HaP96<@9W>@He[@9_N`8mk`8Q208e[@96<@80008e[@80009o
o`9>L`8Li`8]J`92408aS09:DP96<@8icP9BU096<@9>L`92409BU08Li`8mk`8@Q0@icP9S608e[@96
<@8icP9[FP9Nm`8U:@9BU09>L`96<@8YBP9BU096<@80009cW08e[@03>Lhmkcg_00Pmk`8U:@@mk`92
4096<@@mk`8e[@9:DP8icP8]J`8e[@96<@8e[@9>L`8YBP9:DP8mk`96<@9:DP96<@9>L`8U:@9>L`8i
cP9Nm`8e[@96<@8icP8e[@@mk`96<@8icP@mk`AF]@9BU096<@8aS096<@8]J`8icP9W>@8icP96<@9F
]@8icP8Li`9BU09cW08<H`8Li`96<@9F]@9:DP96<@8icPEoo`40005oo`005Goo00<007ooOol00Woo
0UJe0RU:0Woo0QBU0V]J0VLi0Re[0U:D0RU:0Sg_0RDY0S6<0Sg_0P000Sg_0U:D0V<H0T8@0U[F0QBU
14Ha0TYB0U:D0SF]0Tic0RU:0Woo0P000U:D0R480U:D0THa0U:D0UJe0Q240TYB0Q240Tic0SF]0PaS
0TYB136<0THa0TYB0PQ20RDY0S6<0V<H0S6<0T8@0SF]1THa0P000Woo0P000Woo0THa0TYB0Re[00<e
[D8@@Q000SW>1Sg_0U[F0R480TYB0U:D0RU:0T8@0Sg_0Tic0RU:1T8@0QS6148@0Sg_0RU:0Tic0SF]
0Tic0SF]0T8@0THa0SW>0T8@0Re[0V<H0U[F0THa0SF]0Sg_0UJe0THa0T8@0Sg_0U:D0SW>0SF]0SW>
0T8@0SW>148@0Sg_0U:D0SW>0S6<0U:D0Vmk0U:D0P000S6<0Woo0THa0SF]0TYB0SW>0Tic0T8@1Goo
0@000Goo000EOol00`00Oomoo`02Ool2E[D2:DX2Ool25:D2JeX2IcT2;F/2DY@2:DX2?Nl29BT2<H`2
?Nl20002?Nl2DY@2HaP2@Q02F]H25:D4AS42BU82DY@2=Jd2CW<2:DX2Ool20002DY@28@P2DY@2AS42
DY@2E[D248@2BU8248@2CW<2=Jd236<2BU84<H`2AS42BU8224829BT2<H`2HaP2<H`2@Q02=Jd6AS42
0002Ool20002Ool2AS42BU82;F/00cF]@Q124002>Lh6?Nl2F]H28@P2BU82DY@2:DX2@Q02?Nl2CW<2
:DX6@Q026<H4@Q02?Nl2:DX2CW<2=Jd2CW<2=Jd2@Q02AS42>Lh2@Q02;F/2HaP2F]H2AS42=Jd2?Nl2
E[D2AS42@Q02?Nl2DY@2>Lh2=Jd2>Lh2@Q02>Lh4@Q02?Nl2DY@2>Lh2<H`2DY@2Kg/2DY@20002<H`2
Ool2AS42=Jd2BU82>Lh2CW<2@Q05Ool10001Ool001Eoo`03001oogoo009oo`8mk`96<@9Nm`96<@9B
U080009F]@@00092408Li`9BU0Aoo`8icP9S608]J`9JeP8U:@9g_@8Q208]J`8@Q0A[FP8U:@80008i
cP9oo`92409:DP8U:@9>L`9BU09:DP8e[@96<@9:DP8]J`9>L`8Q2096<@8icP9BU09>L`8HaP9cW09>
L`96<@8e[@8]J`9S6092408]J`9[FP80009oo`80009oo`96<@8mk`96<@9F]@03IcTaS36<009F]@8a
S08e[@8aS096<@8icP8aS08mk`8icP96<@@mk`96<@9BU092408icP9>L`92409F]@9S609240@mk`8e
[@9S608YBP8e[@9BU08Q208icP9JeP8Q209>L`8aS096<@9>L`8mk`92409:DP96<@9BU0924096<@8e
[@92408]J`8e[@8aS08mk`9>L`9oo`@00092409:DP8icPPmk`96<@8aS08e[@Eoo`40005oo`005Goo
0P000goo0Sg_0THa0Ukg0THa0U:D0P000UJe10000T8@0QcW0U:D17oo0SW>0V<H0Re[0U[F0RDY0WNm
0R480Re[0Q2416]J0RDY0P000SW>0Woo0T8@0TYB0RDY0Tic0U:D0TYB0SF]0THa0TYB0Re[0Tic0R48
0THa0SW>0U:D0Tic0QS60W>L0Tic0THa0SF]0Re[0V<H0T8@0Re[0V]J0P000Woo0P000Woo0THa0Sg_
0THa0UJe00=W>C6<<H`00UJe0S6<0SF]0S6<0THa0SW>0S6<0Sg_0SW>0THa13g_0THa0U:D0T8@0SW>
0Tic0T8@0UJe0V<H0T8@13g_0SF]0V<H0RU:0SF]0U:D0R480SW>0U[F0R480Tic0S6<0THa0Tic0Sg_
0T8@0TYB0THa0U:D0T8@0THa0SF]0T8@0Re[0SF]0S6<0Sg_0Tic0Woo10000T8@0TYB0SW>23g_0THa
0S6<0SF]17oo0P000Goo000EOol00`00Oomoo`02Ool2Li`2Mkd4Ool248@20002Ool2CW<20002BU82
0002HaP20002@Q02;F/2HaP20002AS426<H2Ool2AS42Kg/2?Nl2;F/2@Q02E[D2Ool20002E[D2AS42
Ool2?Nl22482@Q02AS42:DX2E[D2:DX2=Jd2?Nl2<H`2?Nl2Ool2AS42@Q02G_L2;F/2DY@2>Lh2CW<2
@Q026<H2AS42>Lh20002Ool20002Kg/2BU82?Nl2>Lh4BU800ekg@Q124002DY@2=Jd2;F/2AS42:DX2
BU82=Jd2?Nl2>Lh2?Nl2E[D2>Lh2=Jd4>Lh2DY@2=Jd2BU82AS42F]H2?Nl2<H`2CW<2@Q02IcT2BU82
CW<2@Q02Ool2>Lh2?Nl2@Q02BU84>Lh2BU82?Nl2>Lh2@Q02F]H29BT4?Nl2>Lh2=Jd2;F/20002Li`2
G_L27>L22482E[D2@Q02?Nl2=Jd2E[D2@Q02?Nl2BU82<H`2JeX29BT2?Nl5Ool10001Ool001Eoo`03
001oogoo009oo`9cW09g_@Aoo`8@Q080009oo`9>L`80009:DP80009S60800092408]J`9S60800096
<@8HaP9oo`96<@9_N`8mk`8]J`92409F]@9oo`80009F]@96<@9oo`8mk`88@P924096<@8YBP9F]@8Y
BP8e[@8mk`8aS08mk`9oo`96<@92409Nm`8]J`9BU08icP9>L`92408HaP96<@8icP80009oo`80009_
N`9:DP8mk`8icPA:DP03G_M2448@009BU08e[@8]J`96<@8YBP9:DP8e[@8mk`8icP8mk`9F]@8icP8e
[@@icP9BU08e[@9:DP96<@9JeP8mk`8aS09>L`92409W>@9:DP9>L`92409oo`8icP8mk`92409:DP@i
cP9:DP8mk`8icP92409JeP8U:@@mk`8icP8e[@8]J`80009cW09Nm`8Li`88@P9F]@92408mk`8e[@9F
]@92408mk`9:DP8aS09[FP8U:@8mk`Eoo`40005oo`005Goo00<007ooOol00Woo0V]J0THa10000P@Q
0P000Woo0P000Woo0Ukg0Sg_0V]J0P000WNm10000Woo0P000Woo0P000U[F0Tic0SW>0R480RU:0P00
17oo0THa0Tic0V<H0P000SW>0RDY15[F0QcW0RU:0Woo0P000Woo0P000Woo0P000Re[0THa0Sg_0SW>
0S6<0SW>13g_0TYB0P@Q0Woo0P000WNm148@0U:D0SW>0Re[0U:D00<]JdicCW<00Sg_0RDY0RU:0THa
0R480S6<0UJe0THa0TYB0SF]0R480TYB0RDY0UJe0Vmk0SF]0PaS0Woo0T8@0RU:0P000U:D0WNm0PaS
0TYB0SW>0SF]0Tic0TYB1Sg_0SW>0Tic23g_0T8@0SF]0UJe0THa0U:D0Sg_0SW>0Sg_0Woo0QcW0Q24
0T8@0Sg_0Re[0Sg_0SF]0THa0RU:0T8@0Sg_0TYB0SW>0Sg_0SF]0THa1Goo0@000Goo000EOol00`00
Oomoo`02Ool2JeX2AS44000212420002Ool20002Ool2G_L2?Nl2JeX20002Mkd40002Ool20002Ool2
0002F]H2CW<2>Lh28@P2:DX20004Ool2AS42CW<2HaP20002>Lh29BT4F]H27>L2:DX2Ool20002Ool2
0002Ool20002;F/2AS42?Nl2>Lh2<H`2>Lh4?Nl2BU821242Ool20002Mkd4@Q02DY@2>Lh2;F/2DY@0
0be[CW=>L`02?Nl29BT2:DX2AS428@P2<H`2E[D2AS42BU82=Jd28@P2BU829BT2E[D2Kg/2=Jd236<2
Ool2@Q02:DX20002DY@2Mkd236<2BU82>Lh2=Jd2CW<2BU86?Nl2>Lh2CW<8?Nl2@Q02=Jd2E[D2AS42
DY@2?Nl2>Lh2?Nl2Ool27>L248@2@Q02?Nl2;F/2?Nl2=Jd2AS42:DX2@Q02?Nl2BU82>Lh2?Nl2=Jd2
AS45Ool10001Ool001Eoo`03001oogoo009oo`80008mk`8]J`88@P9:DP@000Aoo`80009S6096<@80
008Q209oo`8HaP9JeP8DY@Ioo`8@Q09F]@8e[@9Nm`9cW0@0008YBP8]J`9_N`80009W>@80008U:@96
<@9JeP8YBP80009oo`80009oo`8YBP800096<@9>L`8e[@9:DP8icP92408mk`8icP8e[@9oo`80009N
m`8HaP8U:@9:DP9W>@8icP9240800003JeXmkcg_0096<@9BU08YBP8]J`8HaP8Q208e[@9[FP8e[@9>
L`8e[@8Li`9BU08DY@8]J`9oo`9F]@80008icP9oo`8e[@8DY@9S609>L`8icP8mk`92408]J`9240@m
k`I240@mk`8icP8mk`9>L`92408]J`9JeP8icP8mk`9cW096<@8HaP8mk`9JeP9:DP8e[@8]J`9BU092
408Q209Nm`96<@Pmk`8icP8U:@Eoo`40005oo`005Goo00<007ooOol00Woo0P000Sg_0Re[0PQ20TYB
100017oo0P000V<H0THa0P000R480Woo0QS60U[F0QBU1Woo0Q240UJe0SF]0Ukg0W>L10000RU:0Re[
0Vmk0P000VLi0P000RDY0THa0U[F0RU:0P000Woo0P000Woo0RU:0P000THa0Tic0SF]0TYB0SW>0T8@
0Sg_0SW>0SF]0Woo0P000Ukg0QS60RDY0TYB0VLi0SW>0T8@0P0000=[FSg_?Nl00THa0U:D0RU:0Re[
0QS60R480SF]0V]J0SF]0Tic0SF]0QcW0U:D0QBU0Re[0Woo0UJe0P000SW>0Woo0SF]0QBU0V<H0Tic
0SW>0Sg_0T8@0Re[0T8@13g_1T8@13g_0SW>0Sg_0Tic0T8@0Re[0U[F0SW>0Sg_0W>L0THa0QS60Sg_
0U[F0TYB0SF]0Re[0U:D0T8@0R480Ukg0THa23g_0SW>0RDY1Goo0@000Goo000EOol00`00Oomoo`02
Ool2:DX2G_L2Ool2CW<4Ool2:DX40002G_L20002Ool2E[D2Ool20002Nmh2>Lh27>L20002CW<2Ool2
;F/4AS42HaP2Ool2JeX2HaP2CW<2F]H20002Ool2JeX2>Lh2DY@2=Jd2;F/2?Nl2F]H20002Ool20002
Ool20002BU82@Q02DY@2:DX2@Q02F]H21242Nmh2AS42=Jd2F]H2?Nl2:DX4AS42>Lh2?Nl2@Q02Li`0
0`0048@@Q0026<H2>Lh2BU82E[D4?Nl49BT2<H`2AS428@P4=Jd2CW<2DY@2:DX22484E[D2;F/20002
@Q02G_L2CW<27>L2AS42>Lh2=Jd2?Nl4@Q02;F/2AS42BU82?Nl2DY@2AS42DY@2;F/4@Q02=Jd2DY@2
CW<2AS44<H`2=Jd2G_L2>Lh2;F/2DY@6AS42>Lh:?Nl2E[D28@P5Ool10001Ool000Uoo`<0009oo`80
00Eoo`03001oogoo009oo`8YBP9Nm`9oo`9>L`Aoo`8YBP@0009Nm`80009oo`9F]@9oo`80009kgP8i
cP8Li`80009>L`9oo`8]J`A6<@9S609oo`9[FP9S609>L`9JeP80009oo`9[FP8icP9BU08e[@8]J`8m
k`9JeP80009oo`80009oo`80009:DP92409BU08YBP92409JeP848@9kgP96<@8e[@9JeP8mk`8YBPA6
<@8icP8mk`92409cW003000@Q124008HaP8icP9:DP9F]@@mk`@U:@8aS096<@8Q20@e[@9>L`9BU08Y
BP88@PAF]@8]J`800092409Nm`9>L`8Li`96<@8icP8e[@8mk`A2408]J`96<@9:DP8mk`9BU096<@9B
U08]J`A2408e[@9BU09>L`96<@@aS08e[@9Nm`8icP8]J`9BU0I6<@8icPXmk`9F]@8Q20Eoo`40005o
o`002Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`A2408Q208DY@9[FP9>L`9N
m`8HaP8aS09Nm`8Q20Aoo`8icP8Q208]J`8icP9:DP8aS09oo`8mk`9oo`8Q209:DP8HaP80009W>@8e
[@96<@8mk`9F]@8icP8U:@9:DP8e[@92409BU092408mk`9:DP8e[@9oo`80009JeP9:DP9BU0@e[@96
<@8mk`9:DP848@9oo`80009W>@92409>L`A6<@Hmk`96<@038@Pe[CF]008e[@8mk`9BU09>L`92409S
609W>@8YBPABU0A:DP8e[@92408mk`92408mk`924096<@8]J`9oo`8@Q09BU09F]@9>L`8YBPA6<@9>
L`@mk`92408e[@8YBPHmk`8icP9>L`8YBP8U:@9S60@]J`8aS096<@8e[@9:DP8YBP92408e[@8mk`A6
<@hmk`8icP9:DPEoo`40005oo`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`A2408Q208DY@9[
FP9>L`9Nm`8HaP8aS09Nm`8Q20Aoo`8icP8Q208]J`8icP9:DP8aS09oo`8mk`9oo`8Q209:DP8HaP80
009W>@8e[@96<@8mk`9F]@8icP8U:@9:DP8e[@92409BU092408mk`9:DP8e[@9oo`80009JeP9:DP9B
U0@e[@96<@8mk`9:DP848@9oo`80009W>@92409>L`A6<@Hmk`96<@038@Pe[CF]008e[@8mk`9BU09>
L`92409S609W>@8YBPABU0A:DP8e[@92408mk`92408mk`924096<@8]J`9oo`8@Q09BU09F]@9>L`8Y
BPA6<@9>L`@mk`92408e[@8YBPHmk`8icP9>L`8YBP8U:@9S60@]J`8aS096<@8e[@9:DP8YBP92408e
[@8mk`A6<@hmk`8icP9:DPAoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool2<H`2E[D2Ool2G_L2E[D2JeX20002@Q02G_L29BT2DY@2IcT2DY@2CW<2<H`2:DX2AS42
=Jd2F]H2<H`20002BU82;F/21242G_L20002BU84?Nl2BU829BT2IcT2<H`4>Lh2;F/2>Lh2=Jd26<H2
DY@20002AS42Ool2;F/2=Jd2AS42?Nl2<H`2HaP2:DX2E[D2Ool20002Mkd>?Nl2@Q027>L00c6<?Nlm
k`02E[D2CW<2DY@2@Q02;F/29BT28@P2BU829BT2AS42>Lh2;F/2F]H2E[D2<H`4@Q02;F/2<H`2E[D2
>Lh2JeX27>L21242IcT2>Lh2@Q02=Jd2BU86?Nl2=Jd2@Q02<H`2?Nl2@Q02IcT4<H`2JeX27>L29BT2
>Lh2E[D2>Lh2@Q02?Nl2@Q02?Nl2@Q0D?Nl2DY@2:DX5Ool10001Ool000Qoo`03001oo`00009oo`04
001oogoo0004Ool00`00Oomoo`02Ool2<H`2E[D2Ool2G_L2E[D2JeX20002@Q02G_L29BT2DY@2IcT2
DY@2CW<2<H`2:DX2AS42=Jd2F]H2<H`20002BU82;F/21242G_L20002BU84?Nl2BU829BT2IcT2<H`4
>Lh2;F/2>Lh2=Jd26<H2DY@20002AS42Ool2;F/2=Jd2AS42?Nl2<H`2HaP2:DX2E[D2Ool20002Mkd>
?Nl2@Q027>L00c6<?Nlmk`02E[D2CW<2DY@2@Q02;F/29BT28@P2BU829BT2AS42>Lh2;F/2F]H2E[D2
<H`4@Q02;F/2<H`2E[D2>Lh2JeX27>L21242IcT2>Lh2@Q02=Jd2BU86?Nl2=Jd2@Q02<H`2?Nl2@Q02
IcT4<H`2JeX27>L29BT2>Lh2E[D2>Lh2@Q02?Nl2@Q02?Nl2@Q0D?Nl2DY@2:DX5Ool10001Ool000Uo
o`8000=oo`8000Eoo`03001oogoo009oo`8DY@92408Li`800096<@8aS09F]@9Nm`A6<@9S608000@i
cP9W>@8mk`8U:@9BU08]J`92409W>@@aS09F]@9oo`9:DP8e[@Pmk`9:DP8mk`8]J`8HaP9S609:DP8Y
BP9:DP92408icP8Li`9g_@8U:@96<@A2408aS09:DP9BU0@Q209oo`8Q208icPhmk`8aS003BU9>Ldic
0096<@8icP8aS09F]@9BU0@icP9:DP8icP@mk`@icP9F]@@icP9W>@8icP8aS09>L`8icP8aS08e[@8H
aP9:DP9Nm`8icP92408icPA2408mk`8e[@8icP9>L`8mk`9BU09:DP96<@9kgP88@P9>L`9F]@8icP8e
[@9>Lahmk`92409:DPEoo`40005oo`005Goo00<007ooOol00Woo0QBU0T8@0QcW0P000THa0S6<0UJe
0Ukg14Ha0V<H0P0013W>0VLi0Sg_0RDY0U:D0Re[0T8@0VLi136<0UJe0Woo0TYB0SF]23g_0TYB0Sg_
0Re[0QS60V<H0TYB0RU:0TYB0T8@0SW>0QcW0WNm0RDY0THa148@0S6<0TYB0U:D12480Woo0R480SW>
3Sg_0S6<00=:DTicCW<00THa0SW>0S6<0UJe0U:D13W>0TYB0SW>13g_13W>0UJe13W>0VLi0SW>0S6<
0Tic0SW>0S6<0SF]0QS60TYB0Ukg0SW>0T8@0SW>148@0Sg_0SF]0SW>0Tic0Sg_0U:D0TYB0THa0W_N
0PQ20Tic0UJe0SW>0SF]0Tic7Sg_0T8@0TYB1Goo0@000Goo000EOol00`00Oomoo`02Ool26<H2;F/2
?Nl2Ool2Mkd2;F/2DY@236<2@Q028@P224820002@Q02AS42@Q02<H`2?Nl2@Q02;F/2CW<2F]H2DY@2
G_L2DY@2Mkd2Li`2>Lh4AS42?Nl2>Lh2BU82>Lh2;F/2<H`29BT2E[D2:DX2=Jd2AS42>Lh2E[D2CW<2
E[D2CW<2E[D2BU82DY@2:DX2AS42Ool20002BU82>Lh6?Nl4AS48?Nl3=Jd2:DX2@Q028@P2AS42BU82
?Nl2CW<2BU82=Jd2DY@2@Q02;F/2>Lh2BU84AS42?Nl2>Lh2@Q02?Nl2E[D2@Q02=Jd2HaP2?Nl2<H`2
BU82E[D2@Q02;F/2>Lh2@Q02E[D2?Nl2F]H2;F/2Kg/2?Nl2Ool2<H`25:D2BU82AS42BU8@?Nl2AS4@
?Nl2@Q02CW<5Ool10001Ool001Eoo`03001oogoo009oo`8HaP8]J`8mk`9oo`9g_@8]J`9BU08<H`92
408Q2088@P8000924096<@92408aS08mk`92408]J`9>L`9JeP9BU09Nm`9BU09g_@9cW08icPA6<@8m
k`8icP9:DP8icP8]J`8aS08U:@9F]@8YBP8e[@96<@8icP9F]@9>L`9F]@9>L`9F]@9:DP9BU08YBP96
<@9oo`80009:DP8icPHmk`A6<@Pmk`<e[@8YBP92408Q2096<@9:DP8mk`9>L`9:DP8e[@9BU092408]
J`8icP9:DPA6<@8mk`8icP92408mk`9F]@92408e[@9S608mk`8aS09:DP9F]@92408]J`8icP92409F
]@8mk`9JeP8]J`9_N`8mk`9oo`8aS08DY@9:DP96<@9:DQ0mk`96<A0mk`92409>L`Eoo`40005oo`00
5Goo00<007ooOol00Woo0UJe0V]J0SF]0QS60T8@0SF]0T8@0V<H0W>L0RU:0U[F0QcW0SF]0T8@0S6<
0Re[0RU:0SW>0WNm0Ukg0S6<0THa0TYB0SW>0P000TYB0RU:0QS60T8@0SW>0TYB0RDY13g_0SF]0THa
0Sg_0U[F0T8@0Tic0SW>0RU:0Ukg0Sg_0P000V<H0Sg_0T8@0Sg_0SW>0Woo0UJe0SF]0T8@1TYB0S6<
23g_0UJe00<mkeJeE[D00SW>0T8@0RU:0V<H0U:D0SW>0T8@0Re[0THa0Sg_0SF]0Tic0TYB0RU:0T8@
14Ha0Sg_0U:D0Re[0SW>0SF]0S6<0QBU14YB0Sg_0UJe0THa0SW>0THa13W>0TYB0SF]0V<H0R48148@
0Sg_0U:D0SF]0THa0Sg_0T8@0Sg_0TYB0Sg_0T8@0Sg_0T8@0SW>0SF]0U[F0T8@33g_0SF]0Tic1Goo
0@000Goo000EOol00`00Oomoo`02Ool2E[D2JeX2=Jd26<H2@Q02=Jd2@Q02HaP2Li`2:DX2F]H27>L2
=Jd2@Q02<H`2;F/2:DX2>Lh2Mkd2G_L2<H`2AS42BU82>Lh20002BU82:DX26<H2@Q02>Lh2BU829BT4
?Nl2=Jd2AS42?Nl2F]H2@Q02CW<2>Lh2:DX2G_L2?Nl20002HaP2?Nl2@Q02?Nl2>Lh2Ool2E[D2=Jd2
@Q06BU82<H`8?Nl2E[D00cg_E[EF]@02>Lh2@Q02:DX2HaP2DY@2>Lh2@Q02;F/2AS42?Nl2=Jd2CW<2
BU82:DX2@Q04AS42?Nl2DY@2;F/2>Lh2=Jd2<H`25:D4BU82?Nl2E[D2AS42>Lh2AS44>Lh2BU82=Jd2
HaP28@P4@Q02?Nl2DY@2=Jd2AS42?Nl2@Q02?Nl2BU82?Nl2@Q02?Nl2@Q02>Lh2=Jd2F]H2@Q0<?Nl2
=Jd2CW<5Ool10001Ool001Eoo`03001oogoo009oo`8mk`924096<@9Nm`9S609W>@96<@8Q208e[@84
8@92409Nm`9>L`96<@9JeP8HaP9Nm`8@Q08icP96<@92408@Q08]J`8YBP8@Q096<@A>L`92409>L`8i
cP8]J`9:DP92408icP9240@icP9BU08Li`96<@92408icP8e[@9W>@8aS09:DP9W>@8Li`924080009:
DP9BU092408mk`8YBP8mk`8icP9F]@@mk`9>L`8mk`03DY@YBRU:00@mk`9:DP8aS0@mk`@icP96<@92
408e[@9>L`8YBP8e[@8mk`8U:@8icP92408mk`92408mk`92408U:@9>L`8mk`8icP9240848@9S6096
<@8U:@9F]@92408Q209F]@8HaP9oo`92408icP9:DP8]J`9:DP8YBP96<@8mk`9JeP8mk`92408mk`9S
609JeP92408mk`@aS0Xmk`9:DP8e[@9BU0Eoo`40005oo`005Goo0P000goo0Sg_0T8@0THa0Ukg0V<H
0VLi0THa0R480SF]0P@Q0T8@0Ukg0Tic0THa0U[F0QS60Ukg0Q240SW>0THa0T8@0Q240Re[0RU:0Q24
0THa14ic0T8@0Tic0SW>0Re[0TYB0T8@0SW>0T8@13W>0U:D0QcW0THa0T8@0SW>0SF]0VLi0S6<0TYB
0VLi0QcW0T8@0P000TYB0U:D0T8@0Sg_0RU:0Sg_0SW>0UJe13g_0Tic0Sg_00=BU2U::DX013g_0TYB
0S6<13g_13W>0THa0T8@0SF]0Tic0RU:0SF]0Sg_0RDY0SW>0T8@0Sg_0T8@0Sg_0T8@0RDY0Tic0Sg_
0SW>0T8@0P@Q0V<H0THa0RDY0UJe0T8@0R480UJe0QS60Woo0T8@0SW>0TYB0Re[0TYB0RU:0THa0Sg_
0U[F0Sg_0T8@0Sg_0V<H0U[F0T8@0Sg_136<2Sg_0TYB0SF]0U:D17oo0P000Goo000EOol00`00Oomo
o`02Ool2DY@20002Ool2AS440004@Q02<H`2F]H2Li`27>L20002F]H2AS4236<2DY@2HaP2:DX2@Q02
<H`2@Q02G_L2IcT2;F/2000236<2E[D2?Nl2DY@2IcT2CW<29BT4>Lh2G_L2;F/2AS44>Lh2@Q04?Nl2
@Q02?Nl20002DY@2?Nl2DY@2Ool4;F/2>Lh20002BU82DY@2CW<2?Nl2;F/2@Q02?Nl2DY@2=Jd38@P2
BU82?Nl28@P2=Jd2?Nl2@Q029BT2@Q02E[D2<H`2JeX29BT2;F/2>Lh2@Q02:DX2@Q08?Nl2@Q02=Jd4
?Nl2DY@2@Q02?Nl20002F]H2@Q02AS426<H2E[D2?Nl2DY@26<H2;F/2CW<29BT2BU82<H`2?Nl2<H`2
48@2BU829BT2?Nl2CW<2:DX4@Q02=Jd4BU88?Nl2@Q02AS42?Nl2G_L5Ool10001Ool001Eoo`03001o
ogoo009oo`9BU080009oo`96<@@000A2408aS09JeP9cW08Li`80009JeP96<@8<H`9BU09S608YBP92
408aS092409Nm`9W>@8]J`80008<H`9F]@8mk`9BU09W>@9>L`8U:@@icP9Nm`8]J`96<@@icP9240@m
k`92408mk`80009BU08mk`9BU09oo`@]J`8icP80009:DP9BU09>L`8mk`8]J`92408mk`9BU08e[@<Q
209:DP8mk`8Q208e[@8mk`92408U:@92409F]@8aS09[FP8U:@8]J`8icP92408YBP9240Pmk`92408e
[@@mk`9BU092408mk`80009JeP924096<@8HaP9F]@8mk`9BU08HaP8]J`9>L`8U:@9:DP8aS08mk`8a
S08@Q09:DP8U:@8mk`9>L`8YBPA2408e[@A:DPPmk`924096<@8mk`9Nm`Eoo`40005oo`005Goo00<0
07ooOol00Woo0VLi0Woo0SF]0Sg_0VLi0WNm0RU:0U[F0Sg_0T8@0Vmk17oo0QS60VLi0P@Q0Ukg0QBU
0U[F0Sg_14ic0THa0Woo0Vmk0W_N0Vmk0SW>0RU:0RDY0SF]0T8@0UJe0T8@0SF]0UJe0Ukg0QS60S6<
0Ukg0THa0Sg_0Tic0T8@0SW>0W_N0R480UJe0S6<0UJe0T8@0UJe0THa0VLi0RDY0TYB0Sg_0U[F0Re[
0SF]13g_0be[0T8@0S6<0THa0SW>0Sg_0THa0Sg_0Tic0Sg_0U:D0RU:0Tic0Re[0U:D0TYB0T8@0Tic
0U:D0TYB1Sg_0SW>0VLi0SF]0THa0SW>0SF]0UJe0Ukg0SF]0Re[0UJe0THa0Ukg0Sg_0Ukg0S6<0RU:
0U:D0SW>0Re[148@0THa0U:D0Re[0U:D0Sg_0Tic0Sg_0T8@0RU:0U[F148@13W>0T8@0SW>0Sg_0Ukg
0SW>0Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool2IcT2Ool2=Jd2?Nl2IcT2Mkd2:DX2F]H2?Nl2
@Q02Kg/4Ool26<H2IcT21242G_L25:D2F]H2?Nl4CW<2AS42Ool2Kg/2Nmh2Kg/2>Lh2:DX29BT2=Jd2
@Q02E[D2@Q02=Jd2E[D2G_L26<H2<H`2G_L2AS42?Nl2CW<2@Q02>Lh2Nmh28@P2E[D2<H`2E[D2@Q02
E[D2AS42IcT29BT2BU82?Nl2F]H2;F/2=Jd4?Nl3;F/2@Q02<H`2AS42>Lh2?Nl2AS42?Nl2CW<2?Nl2
DY@2:DX2CW<2;F/2DY@2BU82@Q02CW<2DY@2BU86?Nl2>Lh2IcT2=Jd2AS42>Lh2=Jd2E[D2G_L2=Jd2
;F/2E[D2AS42G_L2?Nl2G_L2<H`2:DX2DY@2>Lh2;F/4@Q02AS42DY@2;F/2DY@2?Nl2CW<2?Nl2@Q02
:DX2F]H4@Q04>Lh2@Q02>Lh2?Nl2G_L2>Lh2;F/5Ool10001Ool001Eoo`03001oogoo009oo`8]J`9J
eP8Q209W>@96<@9>L`9S608mk`9g_@8icP8YBP8e[@9Nm`8aS08e[@9F]@8]J`9Nm`8YBP8aS0800092
408Li`8U:@8Q208YBP9Nm`92409:DP8mk`9:DP8]J`8icP8aS08icP8e[@8icP8aS09JeP9F]@8]J`8i
cP924096<@8Li`8icP8DY@8mk`8DY@88@P9JeP92409BU09JeP9W>@8mk`8icP8mk`9BU09_N`@mk`9N
m`03<Ha2448@009JeP@mk`92408aS09>L`8mk`92408aS096<@8icP9Nm`8e[@8aS08e[@8YBP@aS092
408mk`@icP8YBP9Nm`8icPA6<@8HaP8mk`9>L`8U:@9>L`9F]@8e[@8icP8mk`8icP8mk`924096<@92
408mk`9>L`8Q209BU08Li`9>L`8mk`9>L`@mk`9JeP8Q208mk`9S608mk`9F]@8icP9240@mk`8e[@9>
L`Eoo`40005oo`005Goo00<007ooOol00Woo0Re[0U[F0R480VLi0THa0Tic0V<H0Sg_0WNm0SW>0RU:
0SF]0Ukg0S6<0SF]0UJe0Re[0Ukg0RU:0S6<0P000T8@0QcW0RDY0R480RU:0Ukg0T8@0TYB0Sg_0TYB
0Re[0SW>0S6<0SW>0SF]0SW>0S6<0U[F0UJe0Re[0SW>0T8@0THa0QcW0SW>0QBU0Sg_0QBU0PQ20U[F
0T8@0U:D0U[F0VLi0Sg_0SW>0Sg_0U:D0Vmk13g_0Ukg00<aS48@@Q000U[F13g_0T8@0S6<0Tic0Sg_
0T8@0S6<0THa0SW>0Ukg0SF]0S6<0SF]0RU:136<0T8@0Sg_13W>0RU:0Ukg0SW>14Ha0QS60Sg_0Tic
0RDY0Tic0UJe0SF]0SW>0Sg_0SW>0Sg_0T8@0THa0T8@0Sg_0Tic0R480U:D0QcW0Tic0Sg_0Tic13g_
0U[F0R480Sg_0V<H0Sg_0UJe0SW>0T8@13g_0SF]0Tic1Goo0@000Goo000EOol00`00Oomoo`02Ool2
Mkd2AS42F]H49BT2CW<2:DX2AS429BT2<H`2JeX2AS42<H`2CW<2>Lh2CW<2?Nl2=Jd2CW<2BU84CW<2
1242CW<2BU82CW<2?Nl2=Jd2BU82@Q028@P2;F/2AS42;F/2AS42E[D2>Lh2HaP28@P2<H`2AS42E[D2
?Nl2AS44=Jd2G_L28@P2>Lh2BU82:DX2@Q02:DX4?Nl2@Q02>Lh2DY@2=Jd2<H`2?Nl2@Q03BU82<H`6
@Q02<H`2>Lh2?Nl2@Q029BT2DY@2?Nl2@Q02BU82AS42@Q026<H2E[D2;F/2AS42?Nl2>Lh2F]H2@Q02
?Nl2<H`2AS427>L2AS42BU82F]H2<H`2E[D2>Lh2F]H2DY@2=Jd2AS42JeX2=Jd2BU82=Jd2?Nl2=Jd2
:DX2?Nl2AS42@Q06?Nl2@Q04?Nl2>Lh2?Nl4=Jd8?Nl4@Q02>Lh5Ool10001Ool001Eoo`03001oogoo
009oo`9g_@96<@9JeP@U:@9>L`8YBP96<@8U:@8aS09[FP96<@8aS09>L`8icP9>L`8mk`8e[@9>L`9:
DPA>L`848@9>L`9:DP9>L`8mk`8e[@9:DP92408Q208]J`96<@8]J`96<@9F]@8icP9S608Q208aS096
<@9F]@8mk`96<@@e[@9Nm`8Q208icP9:DP8YBP92408YBP@mk`92408icP9BU08e[@8aS08mk`9240=:
DP8aS0I2408aS08icP8mk`92408U:@9BU08mk`92409:DP96<@92408HaP9F]@8]J`96<@8mk`8icP9J
eP92408mk`8aS096<@8Li`96<@9:DP9JeP8aS09F]@8icP9JeP9BU08e[@96<@9[FP8e[@9:DP8e[@8m
k`8e[@8YBP8mk`96<@9240Hmk`9240@mk`8icP8mk`@e[@Pmk`A2408icPEoo`40005oo`005Goo00<0
07ooOol00Woo0T8@0TYB0Re[0THa0Re[0Tic0U:D0S6<0SF]0Tic0THa0SF]0U:D0SW>0T8@0Sg_0UJe
0SW>0QcW0S6<0Sg_0SW>0TYB0THa0V<H0THa0T8@0U[F13g_0THa0U[F0Re[0SF]136<0THa15Je0TYB
0T8@0P000SW>0Sg_0U:D0T8@0RU:0RDY0W>L0SW>0Sg_0Tic0Re[0SW>0THa0Sg_0T8@0Re[0T8@1Sg_
0Re[00<mkd8@@Q000Sg_0T8@0Tic0SW>148@136<13g_0THa0Tic0SF]13W>0S6<0T8@13g_0UJe0RDY
0SF]0Sg_0THa0SW>0SF]0Re[0Sg_0RU:0V<H0S6<0UJe0P000T8@0THa0S6<0R480RU:0Sg_0UJe0PQ2
0Sg_0Tic0T8@0RDY0T8@1Sg_0SW>0TYB0S6<0T8@43g_0SW>0T8@1Goo0@000Goo000EOol20003Ool2
@Q02BU82;F/2AS42;F/2CW<2DY@2<H`2=Jd2CW<2AS42=Jd2DY@2>Lh2@Q02?Nl2E[D2>Lh27>L2<H`2
?Nl2>Lh2BU82AS42HaP2AS42@Q02F]H4?Nl2AS42F]H2;F/2=Jd4<H`2AS44E[D2BU82@Q020002>Lh2
?Nl2DY@2@Q02:DX29BT2Li`2>Lh2?Nl2CW<2;F/2>Lh2AS42?Nl2@Q02;F/2@Q06?Nl2;F/00cg_@Q12
4002?Nl2@Q02CW<2>Lh4@Q04<H`4?Nl2AS42CW<2=Jd4>Lh2<H`2@Q04?Nl2E[D29BT2=Jd2?Nl2AS42
>Lh2=Jd2;F/2?Nl2:DX2HaP2<H`2E[D20002@Q02AS42<H`28@P2:DX2?Nl2E[D22482?Nl2CW<2@Q02
9BT2@Q06?Nl2>Lh2BU82<H`2@Q0@?Nl2>Lh2@Q04Ool20001Ool001Eoo`03001oogoo009oo`9JeP9N
m`92409:DP8HaP8mk`8Li`9S608e[@9BU08HaP8]J`8aS08icP8mk`8icP8]J`@icP@aS09S609[FP9J
eP8aS09BU0A6<@8mk`8e[@924096<@8U:@96<@8mk`9BU08U:@9Nm`8aS0A24096<@8icP96<@8e[@8a
S08icP9F]@8HaP924096<@8YBP8mk`96<@8mk`96<@8aS0Pmk`8icP9F]@Dmk`A:DP8mk`92408e[@96
<@9>L`8mk`9:DP8mk`9BU08e[@96<@8aS09240@mk`92408icP9>L`9240@mk`9F]@8mk`I>L`8e[@8a
S08YBP92408e[@9>L`9:DP96<@92408mk`8aS096<@8mk`A2408icPHmk`A240A6<A@mk`8e[@Eoo`40
005oo`005Goo00<007ooOol00Woo0U[F0Ukg0T8@0TYB0QS60Sg_0QcW0V<H0SF]0U:D0QS60Re[0S6<
0SW>0Sg_0SW>0Re[13W>136<0V<H0V]J0U[F0S6<0U:D14Ha0Sg_0SF]0T8@0THa0RDY0THa0Sg_0U:D
0RDY0Ukg0S6<148@0THa0SW>0THa0SF]0S6<0SW>0UJe0QS60T8@0THa0RU:0Sg_0THa0Sg_0THa0S6<
23g_0SW>0UJe1Cg_14YB0Sg_0T8@0SF]0THa0Tic0Sg_0TYB0Sg_0U:D0SF]0THa0S6<0T8@13g_0T8@
0SW>0Tic0T8@13g_0UJe0Sg_1Tic0SF]0S6<0RU:0T8@0SF]0Tic0TYB0THa0T8@0Sg_0S6<0THa0Sg_
148@0SW>1Sg_148@14Ha53g_0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU826<H2>Lh2BU82
>Lh4AS42<H`2CW<2=Jd2:DX2Ool2CW<2=Jd2BU82CW<2HaP2AS42;F/2Kg/2G_L2?Nl2F]H20002F]H2
9BT2;F/2<H`2=Jd4@Q02BU82E[D2CW<2HaP27>L2AS42?Nl29BT2@Q02;F/2=Jd2DY@2BU82CW<28@P2
E[D248@26<H2Kg/27>L2AS42BU84?Nl2<H`2=Jd2F]H2>Lh4?Nl5@Q02?Nl2@Q02;F/2=Jd2?Nl2CW<2
:DX2BU82<H`2G_L2<H`6?Nl2DY@4>Lh2@Q02?Nl2;F/2=Jd2;F/2AS42@Q02?Nl4BU82?Nl4BU82=Jd2
@Q02=Jd2CW<2Kg/21242<H`2CW<2<H`2E[D2?Nl4@Q02<H`2>Lh2E[D6?Nl27>L2BU82?Nl2;F/2E[D>
?Nl4@Q02?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9:DP8HaP8icP9:DP8icPA6<@8aS09>L`8e
[@8YBP9oo`9>L`8e[@9:DP9>L`9S6096<@8]J`9_N`9Nm`8mk`9JeP80009JeP8U:@8]J`8aS08e[@A2
409:DP9F]@9>L`9S608Li`96<@8mk`8U:@92408]J`8e[@9BU09:DP9>L`8Q209F]@8@Q08HaP9_N`8L
i`96<@9:DP@mk`8aS08e[@9JeP8icP@mk`E2408mk`92408]J`8e[@8mk`9>L`8YBP9:DP8aS09Nm`8a
S0Hmk`9BU0@icP92408mk`8]J`8e[@8]J`96<@92408mk`A:DP8mk`A:DP8e[@92408e[@9>L`9_N`84
8@8aS09>L`8aS09F]@8mk`A2408aS08icP9F]@Hmk`8Li`9:DP8mk`8]J`9F]@hmk`A2408mk`Eoo`40
005oo`005Goo00<007ooOol00Woo0U:D0WNm0U:D0RU:0Sg_0RDY0Tic0QcW14Ha0Sg_0Re[0PQ20UJe
0SF]0R480Sg_0SF]0V<H0THa0RU:13g_0Q240SW>0Tic0U:D0R4814Ha0Sg_0SF]0TYB0S6<0SF]0UJe
0T8@0SW>0Tic0T8@0THa0T8@0Tic0U:D0SF]0Tic0TYB0THa0W_N0RU:0T8@0QBU0THa1T8@0QBU0SW>
0T8@13g_0THa0TYB00<aS3W>>Lh00Sg_0Ukg13g_0SF]0TYB0Sg_0U[F0THa0T8@1Sg_0Tic0Sg_0TYB
0QcW1T8@0SF]0TYB0Re[0Tic0Sg_0RU:13g_0UJe0T8@0UJe0Tic0U:D0Sg_0U:D0Q240Re[13W>0U:D
0RDY0T8@23g_0T8@0SF]0U:D13W>0U[F0SW>0T8@33g_14Ha0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2DY@2Mkd2DY@2:DX2?Nl29BT2CW<27>L4AS42?Nl2;F/22482E[D2=Jd28@P2?Nl2=Jd2HaP2
AS42:DX4?Nl248@2>Lh2CW<2DY@28@P4AS42?Nl2=Jd2BU82<H`2=Jd2E[D2@Q02>Lh2CW<2@Q02AS42
@Q02CW<2DY@2=Jd2CW<2BU82AS42Nmh2:DX2@Q025:D2AS46@Q025:D2>Lh2@Q04?Nl2AS42BU800c6<
>LhicP02?Nl2G_L4?Nl2=Jd2BU82?Nl2F]H2AS42@Q06?Nl2CW<2?Nl2BU827>L6@Q02=Jd2BU82;F/2
CW<2?Nl2:DX4?Nl2E[D2@Q02E[D2CW<2DY@2?Nl2DY@248@2;F/4>Lh2DY@29BT2@Q08?Nl2@Q02=Jd2
DY@4>Lh2F]H2>Lh2@Q0<?Nl4AS42@Q05Ool10001Ool001Eoo`03001oogoo009oo`8Q209oo`I2408a
S08icP8mk`96<@9:DP9W>@96<@800096<@9W>@9:DP96<@8]J`8mk`8icP8mk`9:DP8e[@9:DP96<@9>
L`9S6092408mk`96<@9:DP8Li`8aS08icP8aS092408icP92408mk`9240Hmk`8e[@8mk`8U:@92408m
k`9[FP8@Q0@icPI6<@8icP80009BU0Hmk`96<@924003E[E>Ldic0092408aS092408mk`8icP96<@9N
m`8mk`9F]@8mk`8icP9240Pmk`9>L`Hmk`92408mk`92408mk`8icP9>L`9JeP8U:@8mk`9BU0@mk`9J
eP9oo`@aS08icPA6<@92408Q209240@mk`96<@8icP92408mk`9W>@8YBP@icP9>L`8mk`9240Xmk`A6
<@8mk`Eoo`40005oo`005Goo00<007ooOol00Woo0R480Woo1T8@0S6<0SW>0Sg_0THa0TYB0VLi0THa
0P000THa0VLi0TYB0THa0Re[0Sg_0SW>0Sg_0TYB0SF]0TYB0THa0Tic0V<H0T8@0Sg_0THa0TYB0QcW
0S6<0SW>0S6<0T8@0SW>0T8@0Sg_0T8@1Sg_0SF]0Sg_0RDY0T8@0Sg_0V]J0Q2413W>1THa0SW>0P00
0U:D1Sg_0THa0T8@00=F]DicCW<00T8@0S6<0T8@0Sg_0SW>0THa0Ukg0Sg_0UJe0Sg_0SW>0T8@23g_
0Tic1Sg_0T8@0Sg_0T8@0Sg_0SW>0Tic0U[F0RDY0Sg_0U:D13g_0U[F0Woo136<0SW>14Ha0T8@0R48
0T8@13g_0THa0SW>0T8@0Sg_0VLi0RU:13W>0Tic0Sg_0T8@2Sg_14Ha0Sg_1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2F]H200028@P26<H28@P4DY@2@Q02;F/2AS42BU828@P2Ool2<H`2@Q02<H`2>Lh2
Li`2=Jd2?Nl2DY@248@2?Nl2HaP2AS429BT20004>Lh2@Q02AS42JeX2;F/2BU82CW<2?Nl2BU82E[D4
?Nl2@Q04?Nl29BT26<H2E[D2?Nl2DY@2:DX2CW<2BU82?Nl2@Q027>L2F]H20002Ool20002@Q02AS42
?Nl2@Q02:DX00cW>=Jde[@02?Nl2@Q02BU82AS42BU82E[D2>Lh2@Q02G_L2;F/2AS42>Lh2DY@2@Q02
?Nl2@Q02>Lh2@Q08?Nl2BU82=Jd2<H`2E[D2=Jd29BT2F]H2BU84?Nl29BT2<H`2;F/2G_L27>L4AS42
?Nl2@Q04?Nl2@Q0248@2DY@2:DX2=Jd20002Mkd2CW<2@Q02BU82?Nl28@P2@Q0:?Nl2AS42<H`5Ool1
0001Ool001Eoo`8000=oo`9JeP80008Q208HaP8Q20ABU092408]J`96<@9:DP8Q209oo`8aS092408a
S08icP9cW08e[@8mk`9BU08@Q08mk`9S6096<@8U:@8000@icP924096<@9[FP8]J`9:DP9>L`8mk`9:
DP9F]@@mk`9240@mk`8U:@8HaP9F]@8mk`9BU08YBP9>L`9:DP8mk`92408Li`9JeP80009oo`800092
4096<@8mk`92408YBP03>Lhe[CF]008mk`92409:DP96<@9:DP9F]@8icP92409Nm`8]J`96<@8icP9B
U092408mk`92408icP9240Pmk`9:DP8e[@8aS09F]@8e[@8U:@9JeP9:DP@mk`8U:@8aS08]J`9Nm`8L
i`A6<@8mk`9240@mk`92408@Q09BU08YBP8e[@80009g_@9>L`92409:DP8mk`8Q209240Xmk`96<@8a
S0Aoo`80005oo`005Goo00<007ooOol00Woo0RU:0Re[0TYB0U:D0R480SW>0TYB0Re[0RDY0SF]0Tic
0RU:0P@Q0U:D0Re[0SW>0S6<0SF]14YB0Sg_0T8@0TYB0Ukg0T8@0S6<0U[F0T8@0Ukg0T8@0SF]0SW>
0QS60Ukg0SW>0TYB0SW>0SF]0S6<0Tic0THa0Sg_0T8@0Sg_0R480Woo0RU:0Re[0SF]0SW>0U:D0Sg_
0T8@0SW>0R480V]J0P000SF]0VLi0S6<0T8@0Sg_0SW>00=:DT8@@Q000Sg_0Tic0UJe0RU:0Tic0Sg_
0SW>0U[F0SW>0T8@0SF]0THa0SF]0QcW0T8@0Sg_0TYB0S6<0T8@33g_0T8@0PaS0V]J0S6<0R480U:D
0S6<0Sg_0Tic0U:D0RDY0RU:14Ha0RDY0THa0T8@13g_0U:D0R480U:D16mk0QS60U[F0Sg_0QcW0S6<
0Tic0T8@2Sg_0T8@0Q241Goo0@000Goo000EOol00`00Oomoo`02Ool2:DX2;F/2BU82DY@28@P2>Lh2
BU82;F/29BT2=Jd2CW<2:DX21242DY@2;F/2>Lh2<H`2=Jd4BU82?Nl2@Q02BU82G_L2@Q02<H`2F]H2
@Q02G_L2@Q02=Jd2>Lh26<H2G_L2>Lh2BU82>Lh2=Jd2<H`2CW<2AS42?Nl2@Q02?Nl28@P2Ool2:DX2
;F/2=Jd2>Lh2DY@2?Nl2@Q02>Lh28@P2JeX20002=Jd2IcT2<H`2@Q02?Nl2>Lh00dYB@Q124002?Nl2
CW<2E[D2:DX2CW<2?Nl2>Lh2F]H2>Lh2@Q02=Jd2AS42=Jd27>L2@Q02?Nl2BU82<H`2@Q0<?Nl2@Q02
36<2JeX2<H`28@P2DY@2<H`2?Nl2CW<2DY@29BT2:DX4AS429BT2AS42@Q04?Nl2DY@28@P2DY@4Kg/2
6<H2F]H2?Nl27>L2<H`2CW<2@Q0:?Nl2@Q0248@5Ool10001Ool001Eoo`03001oogoo009oo`9>L`9B
U09JeP8e[@9W>@8Q208aS09F]@96<@9:DPABU096<@8DY@@icP8mk`9JeP8e[@8aS08icP8mk`96<@8Q
208Li`8aS09S608e[@8]J`8e[@9:DP9W>@8e[@96<@8mk`9F]@9JeP8]J`92408icP9JeP92408icP92
409S6080008aS0A6<@9>L`92408e[@8]J`8aS092408Li`HaS09[FP8YBP9JeP9F]@=2408icP8e[@8]
J`9BU092408aS09Nm`8]J`9BU08aS09:DP8U:@92409:DP@mk`@icP8]J`8mk`9Nm`Hmk`92408icP9F
]@8e[@8YBP9F]@9:DP8icP9Nm`9JeP8aS08]J`8aS08Li`92409Nm`8aS08]J`92408mk`8U:@96<@8m
k`@Li`8icP8]J`9:DP9>L`9BU08mk`8]J`9BU08mk`8icP9BU092408e[@8mk`Eoo`40005oo`005Goo
00<007ooOol00Woo0Tic0U:D0U[F0SF]0VLi0R480S6<0UJe0THa0TYB15:D0THa0QBU13W>0Sg_0U[F
0SF]0S6<0SW>0Sg_0THa0R480QcW0S6<0V<H0SF]0Re[0SF]0TYB0VLi0SF]0THa0Sg_0UJe0U[F0Re[
0T8@0SW>0U[F0T8@0SW>0T8@0V<H0P000S6<14Ha0Tic0T8@0SF]0Re[0S6<0T8@0QcW1S6<0V]J0RU:
0U[F0UJe0d8@0SW>0SF]0Re[0U:D0T8@0S6<0Ukg0Re[0U:D0S6<0TYB0RDY0T8@0TYB13g_13W>0Re[
0Sg_0Ukg1Sg_0T8@0SW>0UJe0SF]0RU:0UJe0TYB0SW>0Ukg0U[F0S6<0Re[0S6<0QcW0T8@0Ukg0S6<
0Re[0T8@0Sg_0RDY0THa0Sg_11cW0SW>0Re[0TYB0Tic0U:D0Sg_0Re[0U:D0Sg_0SW>0U:D0T8@0SF]
0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS44?Nl2E[D2AS42CW<2?Nl25:D2;F/2G_L2<H`2
@Q02BU82>Lh2F]H2DY@2;F/2@Q02DY@248@2AS42BU82?Nl2=Jd2>Lh2CW<2;F/2AS42;F/2@Q02<H`2
=Jd2AS426<H2;F/2BU82<H`29BT2F]H2@Q027>L2;F/2AS42?Nl2E[D2?Nl2AS427>L2;F/2>Lh2AS42
BU82?Nl2E[D2AS42CW<2>Lh2IcT2=Jd27>L2JeX26<H2@Q000be[>LhicP02F]H248@2DY@2?Nl2<H`2
;F/2BU82DY@2?Nl4E[D2@Q04=Jd2<H`2@Q02?Nl2E[D2AS42@Q02:DX2@Q02>Lh2@Q02?Nl2=Jd2BU82
?Nl2@Q02?Nl2>Lh2F]H248@2=Jd236<2:DX2G_L25:D2AS422482>Lh2@Q02?Nl2@Q02G_L2BU82;F/2
IcT2>Lh2@Q02?Nl2=Jd29BT28@P2@Q02BU82;F/2=Jd2<H`2BU82;F/2AS42@Q05Ool10001Ool001Eo
o`03001oogoo009oo`96<@@mk`9F]@96<@9>L`8mk`8DY@8]J`9Nm`8aS092409:DP8icP9JeP9BU08]
J`92409BU08@Q096<@9:DP8mk`8e[@8icP9>L`8]J`96<@8]J`92408aS08e[@96<@8HaP8]J`9:DP8a
S08U:@9JeP92408Li`8]J`96<@8mk`9F]@8mk`96<@8Li`8]J`8icP96<@9:DP8mk`9F]@96<@9>L`8i
cP9W>@8e[@8Li`9[FP8HaP924003;F/icSW>009JeP8@Q09BU08mk`8aS08]J`9:DP9BU08mk`AF]@92
40@e[@8aS092408mk`9F]@96<@92408YBP92408icP92408mk`8e[@9:DP8mk`92408mk`8icP9JeP8@
Q08e[@8<H`8YBP9Nm`8DY@96<@88@P8icP92408mk`92409Nm`9:DP8]J`9W>@8icP92408mk`8e[@8U
:@8Q2092409:DP8]J`8e[@8aS09:DP8]J`96<@9240Eoo`40005oo`005Goo00<007ooOol00Woo0QcW
0SW>0U:D0U[F14YB14Ha0Tic0RU:0SF]0R480T8@0Tic0Ukg0SF]0Tic0Re[13g_0T8@0S6<0RU:0S6<
0U:D13W>0Sg_0T8@0Tic0T8@13F]0THa0T8@0RU:0Sg_0RU:0R480Sg_0U:D0Ukg1T8@0Re[13W>0S6<
0TYB0UJe0TYB0RU:0SW>0Re[0U:D0T8@0SF]148@0Sg_0U:D0SW>00=246<HHaP00Re[0T8@0SW>0V<H
0UJe0S6<0U:D0THa0SW>0UJe0U:D15[F0TYB0Tic13g_0SW>0UJe0Re[0UJe0T8@0THa0Sg_148@13g_
0Re[0RDY0SW>0Sg_0SW>0SF]0TYB0SW>0RU:0TYB0R480THa0SF]0THa0T8@0Sg_0SF]0SW>0Sg_14Ha
0SW>0T8@0Sg_0THa0T8@13g_0T8@1Sg_0TYB0SF]0Sg_1Goo0@000Goo0007Ool30004Ool20005Ool0
0`00Oomoo`02Ool27>L2>Lh2DY@2F]H4BU84AS42CW<2:DX2=Jd28@P2@Q02CW<2G_L2=Jd2CW<2;F/4
?Nl2@Q02<H`2:DX2<H`2DY@4>Lh2?Nl2@Q02CW<2@Q04=Jd2AS42@Q02:DX2?Nl2:DX28@P2?Nl2DY@2
G_L6@Q02;F/4>Lh2<H`2BU82E[D2BU82:DX2>Lh2;F/2DY@2@Q02=Jd4@Q02?Nl2DY@2>Lh00d8@HaQS
6002;F/2@Q02>Lh2HaP2E[D2<H`2DY@2AS42>Lh2E[D2DY@4F]H2BU82CW<4?Nl2>Lh2E[D2;F/2E[D2
@Q02AS42?Nl4@Q04?Nl2;F/29BT2>Lh2?Nl2>Lh2=Jd2BU82>Lh2:DX2BU828@P2AS42=Jd2AS42@Q02
?Nl2=Jd2>Lh2?Nl4AS42>Lh2@Q02?Nl2AS42@Q04?Nl2@Q06?Nl2BU82=Jd2?Nl5Ool10001Ool000Mo
o`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0U:D0UJe0T8@0TYB0T8@0QcW0U:D
0SF]0U:D0TYB0Tic0Woo0PQ20THa0Q240Ukg0V<H0Sg_0THa0Tic0U:D0Tic0Sg_0THa0PaS0SF]0UJe
0RDY0THa0SW>0Ukg0T8@0TYB0Sg_0SF]0U[F0TYB0Sg_0S6<0T8@0Sg_0Tic0Sg_14YB0THa0RU:0Sg_
0RDY0T8@0SW>0Re[148@0UJe0RU:0Tic0U:D0T8@1Sg_0U[F00<<HcF]=Jd00QcW0Sg_0VLi0U:D0T8@
13g_0T8@0U:D0Ukg0S6<0Sg_0QBU0Tic0TYB23g_0T8@0TYB14Ha0Sg_0U:D0TYB13g_0T8@0Tic0TYB
13g_0THa0TYB0T8@0S6<0U:D0THa0RU:0U:D0Tic0UJe0Sg_0TYB0THa0T8@0Re[0Sg_0T8@0THa0T8@
0Re[0T8@3Sg_0S6<0THa1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`8000=o
o`9BU09F]@92409:DP92408Li`9BU08e[@9BU09:DP9>L`9oo`88@P96<@8@Q09Nm`9S608mk`96<@9>
L`9BU09>L`8mk`96<@8<H`8e[@9F]@8U:@96<@8icP9Nm`92409:DP8mk`8e[@9JeP9:DP8mk`8aS092
408mk`9>L`8mk`A:DP96<@8YBP8mk`8U:@92408icP8]J`A2409F]@8YBP9>L`9BU09240Hmk`9JeP03
36<e[CF]008Li`8mk`9W>@9BU09240@mk`92409BU09Nm`8aS08mk`8DY@9>L`9:DPPmk`92409:DPA6
<@8mk`9BU09:DP@mk`92409>L`9:DP@mk`96<@9:DP92408aS09BU096<@8YBP9BU09>L`9F]@8mk`9:
DP96<@92408]J`8mk`924096<@92408]J`9240hmk`8aS096<@Aoo`80005oo`001goo0`000goo00@0
07ooOol000Aoo`03001oogoo009oo`9>L`9W>@8mk`924080008icP9Nm`80009JeP8e[@96<@8e[@8]
J`96<@8aS08icP8YBP9:DP8icP9Nm`8YBP8aS096<@9cW09JeP9_N`8]J`8icPA24096<@8HaP8aS08m
k`@icP9BU096<@9BU092408mk`9F]@8YBP96<@92408aS09Nm`96<@9:DP9g_@8YBP8mk`8U:@9BU08i
cP8]J`8mk`8aS09240@mk`92408U:@03:DYJeU[F008e[@96<@92409BU09:DP96<@8icP@mk`8YBP9>
L`8icP8mk`8icP8]J`9240@mk`92408mk`9>L`8e[@96<@92408e[@9240Hmk`96<@9BU08mk`A:DP8m
k`8icP9cW08Li`9S609>L`9S608]J`8aS092408aS092408mk`96<@8]J`924096<@9:DP96<A0mk`96
<@8Q20Eoo`40005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`9W
>@8mk`924080008icP9Nm`80009JeP8e[@96<@8e[@8]J`96<@8aS08icP8YBP9:DP8icP9Nm`8YBP8a
S096<@9cW09JeP9_N`8]J`8icPA24096<@8HaP8aS08mk`@icP9BU096<@9BU092408mk`9F]@8YBP96
<@92408aS09Nm`96<@9:DP9g_@8YBP8mk`8U:@9BU08icP8]J`8mk`8aS09240@mk`92408U:@03:DYJ
eU[F008e[@96<@92409BU09:DP96<@8icP@mk`8YBP9>L`8icP8mk`8icP8]J`9240@mk`92408mk`9>
L`8e[@96<@92408e[@9240Hmk`96<@9BU08mk`A:DP8mk`8icP9cW08Li`9S609>L`9S608]J`8aS092
408aS092408mk`96<@8]J`924096<@9:DP96<A0mk`96<@8Q20Eoo`40005oo`0027oo0`000goo0P00
1Goo00<007ooOol00Woo0P000Woo0TYB0P000VLi0P000Woo0SW>0QS60R480S6<0P000Re[0Q240W_N
0Re[0T8@0RDY0V<H0SW>0T8@0Tic0QcW0QBU0P0012U:0Ukg0Sg_0RU:0W_N0V<H0R4813g_0T8@0RU:
0PQ2136<0SW>0Sg_0TYB0QcW0Re[0TYB0Re[0UJe0Re[0P000RU:0Tic0SF]0S6<0UJe0SF]0V<H0T8@
0Sg_148@0SF]0Woo00=6<BDY9BT00T8@0Tic14Ha0U:D23g_0Re[0TYB0U:D0TYB0Re[0Tic0Re[14Ha
0Re[0T8@0Sg_148@13F]0S6<0TYB0Sg_0UJe0QBU0S6<0Tic0T8@0SW>0Tic0S6<0P000Vmk0RDY0THa
0QS60U:D0Tic0Sg_14YB0Tic0SF]0THa0RU:0Re[0UJe23g_0T8@0Sg_0T8@13g_0QcW0T8@1Goo0@00
0Goo000EOol00`00Oomoo`02Ool20002Ool2BU820002IcT20002Ool2>Lh26<H28@P2<H`20002;F/2
48@2Nmh2;F/2@Q029BT2HaP2>Lh2@Q02CW<27>L25:D20004:DX2G_L2?Nl2:DX2Nmh2HaP28@P4?Nl2
@Q02:DX22484<H`2>Lh2?Nl2BU827>L2;F/2BU82;F/2E[D2;F/20002:DX2CW<2=Jd2<H`2E[D2=Jd2
HaP2@Q02?Nl4@Q02=Jd2Ool00dHa9BTU:@02@Q02CW<4AS42DY@8?Nl2;F/2BU82DY@2BU82;F/2CW<2
;F/4AS42;F/2@Q02?Nl4@Q04=Jd2<H`2BU82?Nl2E[D25:D2<H`2CW<2@Q02>Lh2CW<2<H`20002Kg/2
9BT2AS426<H2DY@2CW<2?Nl4BU82CW<2=Jd2AS42:DX2;F/2E[D8?Nl2@Q02?Nl2@Q04?Nl27>L2@Q05
Ool10001Ool001Eoo`03001oogoo00Aoo`@0009oo`80009oo`80009oo`9S609BU080009oo`80009o
o`@0008]J`9S6092409_N`9>L`8mk`9JeP848@9oo`9S608aS08icP8YBP9BU08000A:DPHmk`96<@9J
eP9F]@9JeP8Li`9_N`9:DP9>L`8aS092409:DP9JeP8DY@8icP848@96<@8e[@8mk`8]J`9BU08]J`96
<@92408<H`80009oo`800003AS4mkcg_00I6<@8e[@8aS09240@mk`A2408e[@9:DP8mk`9>L`92408Y
BP9>L`8icP96<@ABU0@mk`9:DP92408icP96<@8mk`924096<@8e[@96<@8mk`H]J`9>L`8]J`9F]@92
409Nm`8icPA6<@8mk`96<@8mk`924096<@92409:DP8icP96<@8icP8mk`92408U:@9Nm`@YBP8Li`9o
o`8@Q0Eoo`40005oo`005Goo00<007ooOol017oo10000Woo0P000Woo0P000Woo0V<H0U:D0P000Woo
0P000Woo10000Re[0V<H0T8@0Vmk0Tic0Sg_0U[F0P@Q0Woo0V<H0S6<0SW>0RU:0U:D0P0014YB1Sg_
0THa0U[F0UJe0U[F0QcW0Vmk0TYB0Tic0S6<0T8@0TYB0U[F0QBU0SW>0P@Q0THa0SF]0Sg_0Re[0U:D
0Re[0THa0T8@0PaS0P000Woo0P0000=6<Cg_?Nl01THa0SF]0S6<0T8@13g_148@0SF]0TYB0Sg_0Tic
0T8@0RU:0Tic0SW>0THa15:D13g_0TYB0T8@0SW>0THa0Sg_0T8@0THa0SF]0THa0Sg_1Re[0Tic0Re[
0UJe0T8@0Ukg0SW>14Ha0Sg_0THa0Sg_0T8@0THa0T8@0TYB0SW>0THa0SW>0Sg_0T8@0RDY0Ukg12U:
0QcW0Woo0Q241Goo0@000Goo000EOol00`00Oomoo`02Ool2>Lh22482Ool27>L2Li`2Ool2E[D2=Jd2
?Nl2=Jd2DY@27>L248@4Ool26<H2BU82=Jd2CW<2AS42=Jd2<H`29BT4F]H2DY@2:DX2Li`20002IcT2
Ool2;F/2?Nl2@Q02AS42<H`2?Nl2IcT25:D2HaP2CW<29BT2BU82?Nl2BU828@P2@Q020002AS42DY@2
>Lh2=Jd2;F/4AS42=Jd2;F/2E[D2Ool20002Ool20002Ool5@Q06?Nl2DY@2=Jd2@Q02AS42>Lh4?Nl2
:DX2BU829BT2<H`2AS42<H`2;F/2<H`2?Nl26<H2DY@2@Q02?Nl2=Jd2?Nl2@Q02AS42:DX27>L2Nmh2
36<2DY@2@Q04?Nl2BU82>Lh2BU84>Lh2;F/2AS42CW<2?Nl2@Q02>Lh2@Q02BU82>Lh2DY@2@Q02BU82
CW<2F]H2=Jd236<4Nmh200026<H2:DX2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`8icP88@P9o
o`8Li`9cW09oo`9F]@8e[@8mk`8e[@9BU08Li`8@Q0Aoo`8HaP9:DP8e[@9>L`96<@8e[@8aS08U:@AJ
eP9BU08YBP9cW080009W>@9oo`8]J`8mk`924096<@8aS08mk`9W>@8DY@9S609>L`8U:@9:DP8mk`9:
DP8Q209240800096<@9BU08icP8e[@8]J`A6<@8e[@8]J`9F]@9oo`80009oo`80009oo`E240Hmk`9B
U08e[@924096<@8icP@mk`8YBP9:DP8U:@8aS096<@8aS08]J`8aS08mk`8HaP9BU092408mk`8e[@8m
k`924096<@8YBP8Li`9kgP8<H`9BU09240@mk`9:DP8icP9:DP@icP8]J`96<@9>L`8mk`92408icP92
409:DP8icP9BU092409:DP9>L`9JeP8e[@8<H`AkgP80008HaP8YBP8e[@Eoo`40005oo`005Goo00<0
07ooOol00Woo0TYB0RU:0VLi14Ha0Woo0V<H0T8@0SW>0THa0RU:0S6<0R480Woo0Vmk0SW>0T8@0SF]
0SW>1Sg_0Re[0R480Ukg0VLi0SW>0RU:0SW>0Woo0W_N0Sg_0T8@13g_0T8@0Sg_0RDY13g_0Re[0SW>
0SF]0T8@13g_0TYB0Q240SF]0Ukg0SW>0T8@0THa0SF]148@0SW>0TYB0QBU0Vmk0W>L0Q240W>L4cg_
0T8@13g_0THa0Re[0SF]0T8@0V<H0THa0T8@0THa0SW>0SF]0RDY0T8@0Sg_0T8@2Sg_0UJe0R480Re[
0U:D0Sg_0Re[0TYB0SW>0TYB0SW>0Tic0U:D14Ha23g_148@0S6<0U[F0PaS0Tic0S6<0V<H0SF]0R48
0V]J0U[F0RU:0THa0TYB1Goo0@000Goo000EOol20003Ool2BU82:DX2IcT4AS42Ool2HaP2@Q02>Lh2
AS42:DX2<H`28@P2Ool2Kg/2>Lh2@Q02=Jd2>Lh6?Nl2;F/28@P2G_L2IcT2>Lh2:DX2>Lh2Ool2Nmh2
?Nl2@Q04?Nl2@Q02?Nl29BT4?Nl2;F/2>Lh2=Jd2@Q04?Nl2BU8248@2=Jd2G_L2>Lh2@Q02AS42=Jd4
@Q02>Lh2BU825:D2Kg/2Li`248@2Li`C?Nl2@Q04?Nl2AS42;F/2=Jd2@Q02HaP2AS42@Q02AS42>Lh2
=Jd29BT2@Q02?Nl2@Q0:?Nl2E[D28@P2;F/2DY@2?Nl2;F/2BU82>Lh2BU82>Lh2CW<2DY@4AS48?Nl4
@Q02<H`2F]H236<2CW<2<H`2HaP2=Jd28@P2JeX2F]H2:DX2AS42BU84Ool20001Ool001Eoo`03001o
ogoo009oo`96<@8HaP9JeP8HaP8icP9S608HaP@aS08Q209BU08icP9F]@9oo`9F]@9JeP8e[@9F]@8m
k`8YBP8aS0Xmk`9>L`8mk`8icP80009oo`8YBP8e[@924096<@8Q20A6<@924096<@9>L`96<@@e[@9:
DP8U:@9F]@9JePHmk`92409JeP92408icP8DY@9>L`96<@9JeP8DY@9cW08Q208mk`03F]Hmkcg_009B
U0Hmk`9>L`8e[@924096<@8]J`92408mk`924096<@9>L`9BU0@e[@9BU092409:DP96<@8icPA2408H
aPA24096<@8aS08Li`9BU08mk`9>L`@mk`9240Hmk`92408mk`8Q209BU096<@@mk`9:DP9BU08icP92
408e[@8mk`9:DP8mk`92408aS08mk`924096<@88@P96<@8mk`9:DPEoo`40005oo`005Goo00<007oo
Ool00Woo0THa0QS60U[F0QS60SW>0V<H0QS6136<0R480U:D0SW>0UJe0Woo0UJe0U[F0SF]0UJe0Sg_
0RU:0S6<2Sg_0Tic0Sg_0SW>0P000Woo0RU:0SF]0T8@0THa0R4814Ha0T8@0THa0Tic0THa13F]0TYB
0RDY0UJe0U[F1Sg_0T8@0U[F0T8@0SW>0QBU0Tic0THa0U[F0QBU0W>L0R480Sg_00=JeSg_?Nl00U:D
1Sg_0Tic0SF]0T8@0THa0Re[0T8@0Sg_0T8@0THa0Tic0U:D13F]0U:D0T8@0TYB0THa0SW>148@0QS6
148@0THa0S6<0QcW0U:D0Sg_0Tic13g_0T8@1Sg_0T8@0Sg_0R480U:D0THa13g_0TYB0U:D0SW>0T8@
0SF]0Sg_0TYB0Sg_0T8@0S6<0Sg_0T8@0THa0PQ20THa0Sg_0TYB1Goo0@000Goo000EOol00`00Oomo
o`02Ool2?Nl2BU82:DX2>Lh2@Q02HaP2IcT2;F/2@Q02;F/2@Q02CW<2DY@2AS42>Lh2?Nl2E[D2@Q04
:DX2F]H2HaP2BU82?Nl2=Jd2?Nl2AS42BU82Ool27>L2?Nl2>Lh2?Nl2AS42@Q02>Lh2?Nl2E[D28@P2
BU82@Q04;F/2=Jd2>Lh2@Q02G_L8?Nl2=Jd2@Q02DY@2<H`2BU82=Jd2>Lh20002Ool20002BU8=?Nl2
G_L2=Jd2@Q02AS46?Nl2=Jd2BU82AS428@P2?Nl27>L2=Jd2AS428@P2F]H2@Q029BT2DY@2@Q02>Lh2
=Jd2BU82AS42@Q02AS4<?Nl2@Q02?Nl2@Q02G_L2@Q02AS42BU82AS42?Nl2BU82>Lh2DY@2?Nl4>Lh2
@Q02BU82AS42F]H2CW<29BT2?Nl2AS42?Nl4@Q05Ool10001Ool001Eoo`03001oogoo009oo`8mk`9:
DP8YBP8icP92409S609W>@8]J`92408]J`92409>L`9BU096<@8icP8mk`9F]@9240@YBP9JeP9S609:
DP8mk`8e[@8mk`96<@9:DP9oo`8Li`8mk`8icP8mk`96<@92408icP8mk`9F]@8Q209:DP9240@]J`8e
[@8icP92409Nm`Pmk`8e[@92409BU08aS09:DP8e[@8icP80009oo`80009:DPdmk`9Nm`8e[@924096
<@Hmk`8e[@9:DP96<@8Q208mk`8Li`8e[@96<@8Q209JeP92408U:@9BU092408icP8e[@9:DP96<@92
4096<@`mk`92408mk`92409Nm`924096<@9:DP96<@8mk`9:DP8icP9BU08mk`@icP92409:DP96<@9J
eP9>L`8U:@8mk`96<@8mk`A240Eoo`40005oo`005Goo00<007ooOol00Woo0QcW0U:D0W_N0Tic0T8@
0TYB0S6<0Tic0SF]0TYB14Ha0R480P000Q240THa13g_0THa0SF]0TYB14Ha0SF]0Woo0RDY0Re[0THa
0Woo0V]J0RU:0S6<0Sg_0SW>0Sg_0T8@13g_148@0Sg_0TYB0THa0SW>0U:D0SF]0RU:0RDY0SF]0TYB
0Tic0Sg_0U:D0SF]148@0SW>0QS60V<H0P000WNm0Tic0U:D00<mkd8@@Q0023g_0TYB0T8@13g_0T8@
2Sg_0T8@0Sg_148@0RU:0Sg_0U:D0SF]0S6<0THa0Sg_0SF]0TYB13g_0UJe0TYB0Sg_0Tic0SF]13g_
0THa0RU:0T8@0U[F0T8@14YB0SW>0Ukg0Sg_0SF]0Sg_0Tic0SW>0SF]0Sg_0S6<0TYB0SF]0U[F0R48
0UJe0SW>0THa0V<H0SF]0Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool27>L2DY@2Nmh2CW<2@Q02
BU82<H`2CW<2=Jd2BU84AS428@P2000248@2AS44?Nl2AS42=Jd2BU84AS42=Jd2Ool29BT2;F/2AS42
Ool2JeX2:DX2<H`2?Nl2>Lh2?Nl2@Q04?Nl4@Q02?Nl2BU82AS42>Lh2DY@2=Jd2:DX29BT2=Jd2BU82
CW<2?Nl2DY@2=Jd4@Q02>Lh26<H2HaP20002Mkd2CW<2DY@00cg_@Q124008?Nl2BU82@Q04?Nl2@Q0:
?Nl2@Q02?Nl4@Q02:DX2?Nl2DY@2=Jd2<H`2AS42?Nl2=Jd2BU84?Nl2E[D2BU82?Nl2CW<2=Jd4?Nl2
AS42:DX2@Q02F]H2@Q04BU82>Lh2G_L2?Nl2=Jd2?Nl2CW<2>Lh2=Jd2?Nl2<H`2BU82=Jd2F]H28@P2
E[D2>Lh2AS42HaP2=Jd2;F/5Ool10001Ool001Eoo`03001oogoo009oo`9BU0A6<@848@9cW09g_@@a
S08<H`8mk`8icP8@Q088@P800096<@9Nm`9JeP9:DP8DY@8U:@9>L`8DY@8Q209oo`9>L`9JeP8U:@@0
008e[@96<@8e[@96<@8HaP9BU08U:@92409>L`9F]@@YBP8aS08]J`8icP9F]@A:DP@icP92408e[@9J
eP96<@924096<@92409oo`@mk`9:DP96<@9:DP8mk`03@Q0mkcg_009240@mk`9>L`8]J`8e[@92409:
DP8aS092408mk`8icP96<@8mk`9BU08icP@mk`9>L`9Nm`8mk`9:DP8e[@9:DP@mk`9BU08YBP92408m
k`96<@8YBP9W>@92409F]@8icP9:DP@mk`ABU08U:@9240@mk`92408aS08mk`9BU08U:@9Nm`8mk`96
<@8icP92408mk`9W>@96<@8e[@9:DP@mk`9240Eoo`40005oo`005Goo00<007ooOol00Woo0U:D14Ha
0P@Q0W>L0WNm136<0PaS0Sg_0SW>0Q240PQ20P000THa0Ukg0U[F0TYB0QBU0RDY0Tic0QBU0R480Woo
0Tic0U[F0RDY10000SF]0THa0SF]0THa0QS60U:D0RDY0T8@0Tic0UJe12U:0S6<0Re[0SW>0UJe14YB
13W>0T8@0SF]0U[F0THa0T8@0THa0T8@0Woo13g_0TYB0THa0TYB0Sg_00=243g_?Nl00T8@13g_0Tic
0Re[0SF]0T8@0TYB0S6<0T8@0Sg_0SW>0THa0Sg_0U:D0SW>13g_0Tic0Ukg0Sg_0TYB0SF]0TYB13g_
0U:D0RU:0T8@0Sg_0THa0RU:0VLi0T8@0UJe0SW>0TYB13g_15:D0RDY0T8@13g_0T8@0S6<0Sg_0U:D
0RDY0Ukg0Sg_0THa0SW>0T8@0Sg_0VLi0THa0SF]0TYB13g_0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2AS42=Jd2G_L2:DX2>Lh248@2DY@2AS42DY@2@Q02F]H2?Nl2Mkd2E[D2CW<2>Lh2?Nl2=Jd2
>Lh4?Nl2CW<2@Q028@P2@Q02>Lh2AS42Ool236<2AS4236<2G_L2<H`2=Jd2?Nl2E[D2>Lh2DY@2>Lh2
@Q02E[D2AS42?Nl2>Lh2?Nl2BU82CW<2AS44?Nl2@Q06?Nl2BU82<H`20002Mkd236<2G_L2>Lh2@Q02
=Jd00bDY?Nlmk`02:DX6BU86@Q02=Jd2BU84?Nl2=Jd2AS46?Nl2DY@2<H`2CW<2DY@6?Nl2@Q06?Nl2
@Q02BU82=Jd2E[D2AS425:D2CW<2?Nl2:DX2@Q08?Nl2@Q08?Nl2IcT2?Nl2=Jd2?Nl27>L2HaP2E[D2
AS44@Q02DY@8?Nl2BU82?Nl5Ool10001Ool001Eoo`8000=oo`96<@8e[@9Nm`8YBP8icP8@Q09BU096
<@9BU092409JeP8mk`9g_@9F]@9>L`8icP8mk`8e[@8icP@mk`9>L`92408Q2092408icP96<@9oo`8<
H`96<@8<H`9Nm`8aS08e[@8mk`9F]@8icP9BU08icP92409F]@96<@8mk`8icP8mk`9:DP9>L`96<@@m
k`9240Hmk`9:DP8aS080009g_@8<H`9Nm`8icP92408e[@039BTmkcg_008YBPI:DPI2408e[@9:DP@m
k`8e[@96<@Hmk`9BU08aS09>L`9BU0Hmk`9240Hmk`92409:DP8e[@9F]@96<@8DY@9>L`8mk`8YBP92
40Pmk`9240Pmk`9W>@8mk`8e[@8mk`8Li`9S609F]@96<@A2409BU0Pmk`9:DP8mk`Aoo`80005oo`00
5Goo00<007ooOol00Woo0Sg_0T8@0SW>0R480Sg_0TYB0UJe0SF]0R480TYB0U:D0Re[0Ukg0TYB0Re[
0Woo0THa0Ukg0T8@14YB0SF]0Re[0VLi0QcW0TYB0SW>0Woo0V]J0T8@0SW>0T8@0UJe0TYB0T8@0THa
0Sg_0U[F0Sg_0THa0Sg_0T8@0Sg_0V]J0RU:0T8@0VLi0T8@0TYB0SF]0T8@0SF]148@0Re[0T8@0WNm
0RDY0U[F0RU:148@0c6<0THa0SW>13F]0SW>0R480SW>0QS60T8@23g_0U:D0SF]0T8@0Sg_0THa0TYB
0Re[0UJe0SW>13g_0Re[14Ha0TYB0Sg_0T8@0R480UJe0Re[0THa0SF]0Sg_0Tic0Sg_0T8@0SF]0Sg_
0SW>0T8@1Sg_0THa148@0Sg_0U:D0VLi0Sg_0THa0SW>0Ukg0R480SW>23g_14Ha1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2?Nl2@Q02>Lh28@P2?Nl2BU82E[D2=Jd28@P2BU82DY@2;F/2G_L2BU82;F/2
Ool2AS42G_L2@Q04BU82=Jd2;F/2IcT27>L2BU82>Lh2Ool2JeX2@Q02>Lh2@Q02E[D2BU82@Q02AS42
?Nl2F]H2?Nl2AS42?Nl2@Q02?Nl2JeX2:DX2@Q02IcT2@Q02BU82=Jd2@Q02=Jd4@Q02;F/2@Q02Mkd2
9BT2F]H2:DX4@Q03<H`2AS42>Lh4=Jd2>Lh28@P2>Lh26<H2@Q08?Nl2DY@2=Jd2@Q02?Nl2AS42BU82
;F/2E[D2>Lh4?Nl2;F/4AS42BU82?Nl2@Q028@P2E[D2;F/2AS42=Jd2?Nl2CW<2?Nl2@Q02=Jd2?Nl2
>Lh2@Q06?Nl2AS44@Q02?Nl2DY@2IcT2?Nl2AS42>Lh2G_L28@P2>Lh8?Nl4AS45Ool10001Ool001Eo
o`03001oogoo009oo`8aS096<@8e[@8U:@92408Li`8aS08]J`9[FP9F]@8aS08YBP9JeP9F]@9g_@8D
Y@8Q2092409F]@9>L`8DY@8icP9S609F]@9:DP8aS08Li`80008]J`8mk`9F]@9JeP92409:DP96<@8a
S096<@8icP9>L`92408Q209Nm`8e[@9:DP8e[@8mk`8aS09240@aS09BU08]J`9:DP8]J`9F]@8]J`9c
W08Q208e[@9F]@8icP9:DP8mk`03;F]6<DHa008e[@92408mk`92408e[@92408icP8mk`8icP9240Hm
k`8e[@92408icP924096<@@YBP9F]@@mk`@]J`9:DP8icP9>L`8icP92408e[@9:DP96<@8icP9F]@8a
S08mk`@e[@9F]@8e[@A2408e[@9JeP9>L`9JeP8YBP8HaP9_N`8Q208@Q08]J`8aS08e[@96<@9S60Hm
k`96<@8e[@9:DPEoo`40005oo`005Goo00<007ooOol00Woo0S6<0THa0SF]0RDY0T8@0QcW0S6<0Re[
0V]J0UJe0S6<0RU:0U[F0UJe0WNm0QBU0R480T8@0UJe0Tic0QBU0SW>0V<H0UJe0TYB0S6<0QcW0P00
0Re[0Sg_0UJe0U[F0T8@0TYB0THa0S6<0THa0SW>0Tic0T8@0R480Ukg0SF]0TYB0SF]0Sg_0S6<0T8@
136<0U:D0Re[0TYB0Re[0UJe0Re[0W>L0R480SF]0UJe0SW>0TYB0Sg_00<]JdHaAS400SF]0T8@0Sg_
0T8@0SF]0T8@0SW>0Sg_0SW>0T8@1Sg_0SF]0T8@0SW>0T8@0THa12U:0UJe13g_12e[0TYB0SW>0Tic
0SW>0T8@0SF]0TYB0THa0SW>0UJe0S6<0Sg_13F]0UJe0SF]148@0SF]0U[F0Tic0U[F0RU:0QS60Vmk
0R480Q240Re[0S6<0SF]0THa0V<H1Sg_0THa0SF]0TYB1Goo0@000Goo000EOol00`00Oomoo`02Ool2
Li`2;F/2JeX26<H28@P2E[D2@Q02:DX2Kg/28@P29BT2@Q02Kg/2AS449BT2?Nl2:DX2Ool20002CW<2
@Q02AS42<H`2AS42?Nl2@Q028@P2:DX2CW<2=Jd28@P2BU82;F/2AS42?Nl28@P2BU825:D2IcT2JeX2
DY@2;F/2CW<2F]H2G_L2?Nl2BU82=Jd2CW<26<H2?Nl25:D2>Lh21242Ool20002G_L2@Q02BU84@Q02
HaP00cF]?Nlmk`02>Lh2@Q02AS42>Lh2DY@2@Q02=Jd2@Q02>Lh2;F/2>Lh2@Q04AS42:DX2Nmh28@P2
JeX27>L2AS42?Nl2BU82=Jd2AS42?Nl2E[D2<H`:?Nl2AS42@Q02?Nl2BU82?Nl4CW<2DY@2=Jd2;F/2
<H`2>Lh2=Jd2AS42=Jd2BU82F]H2E[D2=Jd2AS42CW<2@Q02=Jd2BU82>Lh2@Q02?Nl2@Q02>Lh2<H`2
;F/5Ool10001Ool001Eoo`03001oogoo009oo`9cW08]J`9[FP8HaP8Q209F]@92408YBP9_N`8Q208U
:@92409_N`96<@@U:@8mk`8YBP9oo`80009>L`924096<@8aS096<@8mk`92408Q208YBP9>L`8e[@8Q
209:DP8]J`96<@8mk`8Q209:DP8DY@9W>@9[FP9BU08]J`9>L`9JeP9Nm`8mk`9:DP8e[@9>L`8HaP8m
k`8DY@8icP848@9oo`80009Nm`92409:DPA2409S6003=Jdmkcg_008icP924096<@8icP9BU092408e
[@92408icP8]J`8icP9240A6<@8YBP9kgP8Q209[FP8Li`96<@8mk`9:DP8e[@96<@8mk`9F]@8aS0Xm
k`96<@92408mk`9:DP8mk`A>L`9BU08e[@8]J`8aS08icP8e[@96<@8e[@9:DP9JeP9F]@8e[@96<@9>
L`92408e[@9:DP8icP92408mk`92408icP8aS08]J`Eoo`40005oo`005Goo00<007ooOol00Woo0P00
0U:D0S6<0Woo0Ukg0Q240Woo0THa0PQ20QS60RU:0SF]0P000RU:136<0R480Vmk0P000Woo0SW>0T8@
15Je0Re[0Sg_0Woo0SF]0TYB136<0RDY0SW>0Re[0UJe0S6<0SF]0U:D0SF]0P000QBU0THa0UJe0SF]
0T8@0TYB0Sg_0UJe0TYB0T8@0SF]0U:D0Sg_0T8@0Q240U[F0Sg_0S6<0SW>0Sg_0SF]0THa0S6<00<i
cSg_?Nl013W>0T8@13g_0THa0Tic13g_0T8@0SW>0Sg_0TYB0Tic0U:D0RDY0T8@0UJe0V<H0R480U:D
0Sg_0SW>0S6<0Tic0THa0T8@0TYB23g_0U:D0RU:0T8@13g_0THa0Sg_0SF]0TYB148@0Sg_0T8@0S6<
0SF]0Vmk148@0TYB0T8@0S6<0RU:0T8@0THa0V<H0SW>0TYB0RDY0S6<0TYB0Sg_1Goo0@000Goo000E
Ool00`00Oomoo`02Ool20002DY@2<H`2Ool2G_L248@2Ool2AS4224826<H2:DX2=Jd20002:DX4<H`2
8@P2Kg/20002Ool2>Lh2@Q04E[D2;F/2?Nl2Ool2=Jd2BU84<H`29BT2>Lh2;F/2E[D2<H`2=Jd2DY@2
=Jd200025:D2AS42E[D2=Jd2@Q02BU82?Nl2E[D2BU82@Q02=Jd2DY@2?Nl2@Q0248@2F]H2?Nl2<H`2
>Lh2?Nl2=Jd2AS42<H`00cW>?Nlmk`04>Lh2@Q04?Nl2AS42CW<4?Nl2@Q02>Lh2?Nl2BU82CW<2DY@2
9BT2@Q02E[D2HaP28@P2DY@2?Nl2>Lh2<H`2CW<2AS42@Q02BU88?Nl2DY@2:DX2@Q04?Nl2AS42?Nl2
=Jd2BU84@Q02?Nl2@Q02<H`2=Jd2Kg/4@Q02BU82@Q02<H`2:DX2@Q02AS42HaP2>Lh2BU829BT2<H`2
BU82?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9>L`9BU0924080009:DP8aS0@000@aS08mk`8e
[@8YBP9>L`8icP9oo`9kgP8<H`9oo`8@Q09oo`8mk`8icP8mk`9BU08e[@ABU08mk`9BU08U:@8HaP8e
[@9F]@8YBP9W>@92408mk`9:DP8Q209oo`9>L`8e[@8Li`8]J`8icPXmk`9cW08YBP92409:DP8HaP96
<@8HaP8icP92408mk`8aS09S6003;F/e[CF]008aS092408Q208mk`9cW09JeP96<@92408icP92408a
S09:DP8aS092409>L`A6<@9[FP96<@9BU092408mk`ABU09>L`8icP8aS08U:@9BU0Pmk`9240Xmk`8]
J`9>L`8mk`8e[@9240Hmk`8YBP8e[@8YBP9>L`8]J`8e[@8YBP9240Hmk`9:DP8icP92408e[@9BU0Eo
o`40005oo`005Goo0P000goo0Tic0U:D0T8@0P000TYB0S6<1000136<0Sg_0SF]0RU:0Tic0SW>0Woo
0W_N0PaS0Woo0Q240Woo0Sg_0SW>0Sg_0U:D0SF]15:D0Sg_0U:D0RDY0QS60SF]0UJe0RU:0VLi0T8@
0Sg_0TYB0R480Woo0Tic0SF]0QcW0Re[0SW>2Sg_0W>L0RU:0T8@0TYB0QS60THa0QS60SW>0T8@0Sg_
0S6<0V<H00<]JcF]=Jd00S6<0T8@0R480Sg_0W>L0U[F0THa0T8@0SW>0T8@0S6<0TYB0S6<0T8@0Tic
14Ha0V]J0THa0U:D0T8@0Sg_15:D0Tic0SW>0S6<0RDY0U:D23g_0T8@2Sg_0Re[0Tic0Sg_0SF]0T8@
1Sg_0RU:0SF]0RU:0Tic0Re[0SF]0RU:0T8@1Sg_0TYB0SW>0T8@0SF]0U:D17oo0P000Goo000EOol0
0`00Oomoo`02Ool2JeX2<H`248@2Ool236<2BU82Ool2;F/2JeX2G_L2?Nl2CW<29BT4?Nl20002;F/2
7>L2>Lh200025:D2E[D2@Q02:DX2?Nl2:DX26<H2Ool4>Lh2?Nl21242=Jd2?Nl2IcT27>L4=Jd2BU82
HaP2@Q020002Mkd29BT2:DX2F]H2?Nl2@Q02=Jd4?Nl2;F/2@Q028@P2F]H236<4DY@2?Nl2CW<2?Nl2
@Q02?Nl00dic=Jde[@02@Q02AS42=Jd2AS426<H2@Q02BU82AS42:DX2;F/2E[D2:DX2BU829BT2<H`2
F]H4AS42:DX2@Q02<H`2Kg/2;F/27>L2BU82F]H4;F/2<H`2@Q06?Nl2AS48?Nl2AS42@Q029BT2BU84
@Q02CW<2AS42F]H2AS42:DX2CW<2>Lh2=Jd2<H`4@Q02=Jd2AS4<?Nl5Ool10001Ool001Eoo`03001o
ogoo009oo`9[FP8aS08@Q09oo`8<H`9:DP9oo`8]J`9[FP9Nm`8mk`9>L`8U:@@mk`80008]J`8Li`8i
cP80008DY@9F]@92408YBP8mk`8YBP8HaP9oo`@icP8mk`848@8e[@8mk`9W>@8Li`@e[@9:DP9S6092
4080009g_@8U:@8YBP9JeP8mk`92408e[@@mk`8]J`92408Q209JeP8<H`ABU08mk`9>L`8mk`92408m
k`03CW<e[CF]00924096<@8e[@96<@8HaP92409:DP96<@8YBP8]J`9F]@8YBP9:DP8U:@8aS09JePA6
<@8YBP92408aS09_N`8]J`8Li`9:DP9JeP@]J`8aS09240Hmk`96<@Pmk`96<@92408U:@9:DPA2409>
L`96<@9JeP96<@8YBP9>L`8icP8e[@8aS0A2408e[@96<@`mk`Eoo`40005oo`005Goo00<007ooOol0
0Woo0Re[0U:D0S6<0UJe0Re[0THa0QcW17oo0R480SW>0V<H0QcW0Tic0Woo15[F0V<H0Q240WNm0PaS
0THa0S6<0Vmk0U[F0QBU0P000R480TYB0SW>0P000Woo0Ukg0T8@0QcW0Ukg0U[F0SW>0Q240V]J0P00
0Woo0P000Tic0SF]0UJe0T8@0SW>0TYB0UJe0RDY0QS60Re[0TYB0QBU0Sg_0THa0RU:0TYB0UJe0SW>
0Sg_0TYB00<HaSg_?Nl00RDY14ic0SF]0Ukg0QcW0T8@0SW>0SF]0U:D0THa0UJe0Tic0TYB0SF]0RU:
0UJe0R480UJe0Sg_0TYB0SF]0T8@0TYB0W>L0SW>0T8@0SW>0Re[148@13g_0SF]0T8@0Sg_0U:D0SW>
0U[F0Tic0SF]0THa0R480UJe148@0SW>0S6<0THa0S6<0RDY0S6<0RU:0T8@0SF]0TYB0THa23g_0T8@
0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2;F/2DY@2<H`2E[D2;F/2AS427>L4Ool28@P2>Lh2
HaP27>L2CW<2Ool4F]H2HaP248@2Mkd236<2AS42<H`2Kg/2F]H25:D200028@P2BU82>Lh20002Ool2
G_L2@Q027>L2G_L2F]H2>Lh248@2JeX20002Ool20002CW<2=Jd2E[D2@Q02>Lh2BU82E[D29BT26<H2
;F/2BU825:D2?Nl2AS42:DX2BU82E[D2>Lh2?Nl2BU800aS6?Nlmk`029BT4CW<2=Jd2G_L27>L2@Q02
>Lh2=Jd2DY@2AS42E[D2CW<2BU82=Jd2:DX2E[D28@P2E[D2?Nl2BU82=Jd2@Q02BU82Li`2>Lh2@Q02
>Lh2;F/4@Q04?Nl2=Jd2@Q02?Nl2DY@2>Lh2F]H2CW<2=Jd2AS428@P2E[D4@Q02>Lh2<H`2AS42<H`2
9BT2<H`2:DX2@Q02=Jd2BU82AS48?Nl2@Q02AS45Ool10001Ool001Eoo`03001oogoo009oo`9:DP8]
J`8mk`8<H`9BU08aS0H0008icP9W>@9JeP9S608YBP92408icP9F]@8Q209oo`8Li`9oo`8YBP9g_@8Y
BP8aS09Nm`8aS08e[@8YBP8e[@9oo`80008@Q08icP9JeP9F]@9BU08YBP8]J`9S608@Q08icP9cW0A2
4096<@8U:@9Nm`8e[@8mk`92408mk`8]J`9JeP88@P9JeP8aS09BU092409:DP@mk`924003JeY:DTYB
009Nm`8]J`8U:@@mk`9>L`8icP8e[@9BU09>L`8e[@9F]@9BU08HaP9W>@9kgP8e[@8aS08U:@9Nm`8i
cP9:DP9BU08mk`8HaP92408mk`8icP92408mk`8]J`92409BU0Hmk`8icP92408mk`8icP9>L`8e[@9>
L`9Nm`9>L`@U:@9>L`8mk`9:DP92408e[@8icP92408e[@9:DPXmk`8aS09240Eoo`40005oo`005Goo
00<007ooOol00Woo0TYB0Re[0Sg_0PaS0U:D0S6<1P000SW>0VLi0U[F0V<H0RU:0T8@0SW>0UJe0R48
0Woo0QcW0Woo0RU:0WNm0RU:0S6<0Ukg0S6<0SF]0RU:0SF]0Woo0P000Q240SW>0U[F0UJe0U:D0RU:
0Re[0V<H0Q240SW>0W>L148@0THa0RDY0Ukg0SF]0Sg_0T8@0Sg_0Re[0U[F0PQ20U[F0S6<0U:D0T8@
0TYB13g_0T8@00=[FTYBBU800Ukg0Re[0RDY13g_0Tic0SW>0SF]0U:D0Tic0SF]0UJe0U:D0QS60VLi
0W_N0SF]0S6<0RDY0Ukg0SW>0TYB0U:D0Sg_0QS60T8@0Sg_0SW>0T8@0Sg_0Re[0T8@0U:D1Sg_0SW>
0T8@0Sg_0SW>0Tic0SF]0Tic0Ukg0Tic12DY0Tic0Sg_0TYB0T8@0SF]0SW>0T8@0SF]0TYB2Sg_0S6<
0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02Li`2G_L2JeX2?Nl2IcT2<H`248@2<H`2@Q02
9BT2Li`2<H`2>Lh20002AS42?Nl2;F/2000236<2=Jd2?Nl26<H2?Nl2@Q02DY@29BT2?Nl4>Lh2@Q02
Ool2AS42>Lh2=Jd2@Q02>Lh2=Jd2Ool2<H`2Ool2=Jd28@P2?Nl2@Q02BU82CW<2AS42@Q02?Nl2AS42
E[D29BT4IcT2=Jd2AS42@Q02=Jd6?Nl2Ool00`Q2DYABU0027>L2=Jd2F]H2AS42?Nl4;F/2DY@2>Lh2
?Nl2;F/2?Nl2<H`2G_L2@Q02=Jd2IcT2?Nl2Li`27>L2G_L2=Jd2>Lh2@Q02;F/2@Q02?Nl2=Jd4@Q02
;F/2AS44?Nl2@Q02=Jd2HaP2=Jd2AS42DY@2;F/2@Q02BU82F]H2CW<29BT2>Lh2AS42>Lh2?Nl2@Q02
F]H4=Jd2@Q0<?Nl29BT2@Q05Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`92409c
W09Nm`9[FP8mk`9W>@8aS08@Q08aS092408U:@9cW08aS08icP800096<@8mk`8]J`80008<H`8e[@8m
k`8HaP8mk`92409BU08U:@8mk`@icP92409oo`96<@8icP8e[@92408icP8e[@9oo`8aS09oo`8e[@8Q
208mk`92409:DP9>L`96<@92408mk`96<@9F]@8U:@AW>@8e[@96<@92408e[@Hmk`9oo`03249BU5:D
008Li`8e[@9JeP96<@8mk`@]J`9BU08icP8mk`8]J`8mk`8aS09Nm`92408e[@9W>@8mk`9cW08Li`9N
m`8e[@8icP92408]J`92408mk`8e[@A2408]J`96<@@mk`92408e[@9S608e[@96<@9BU08]J`92409:
DP9JeP9>L`8U:@8icP96<@8icP8mk`92409JeP@e[@9240`mk`8U:@9240Eoo`40005oo`001goo00@0
07ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool2>Lh29BT2AS42E[D4CW<2Mkd28@P2:DX2
;F/2JeX2=Jd2F]H2CW<2BU82DY@2;F/2?Nl2JeX2>Lh2<H`2@Q02AS42CW<2DY@2HaP2Kg/4@Q02BU82
2482AS42=Jd2G_L4=Jd2?Nl2>Lh47>L49BT2HaP28@P2AS42?Nl2>Lh2DY@2BU82=Jd29BT2CW<2BU82
<H`2HaP2G_L2?Nl2>Lh2@Q04?Nl2@Q025:D00f]J:DXYBP02CW<4?Nl2E[D2F]H2?Nl4>Lh2=Jd2AS42
?Nl2@Q02IcT4>Lh2<H`21242E[D29BT2CW<28@P2=Jd2:DX28@P2>Lh2@Q0:?Nl6AS42@Q02=Jd2?Nl2
BU82?Nl2=Jd2?Nl2<H`2E[D2?Nl2<H`2:DX2@Q02DY@2<H`2?Nl2DY@2?Nl4@Q0>?Nl2E[D2<H`5Ool1
0001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo0P000goo0SW>0RDY0THa0UJe14ic0WNm
0R480RU:0Re[0V]J0SF]0U[F0Tic0TYB0U:D0Re[0Sg_0V]J0SW>0S6<0T8@0THa0Tic0U:D0V<H0Vmk
148@0TYB0PQ20THa0SF]0Ukg13F]0Sg_0SW>11cW12DY0V<H0R480THa0Sg_0SW>0U:D0TYB0SF]0RDY
0Tic0TYB0S6<0V<H0Ukg0Sg_0SW>0T8@13g_0T8@0QBU00=[FRU::DX00Tic13g_0UJe0U[F0Sg_13W>
0SF]0THa0Sg_0T8@0VLi13W>0S6<0P@Q0UJe0RDY0Tic0R480SF]0RU:0R480SW>0T8@2Sg_1THa0T8@
0SF]0Sg_0TYB0Sg_0SF]0Sg_0S6<0UJe0Sg_0S6<0RU:0T8@0U:D0S6<0Sg_0U:D0Sg_148@3Sg_0UJe
0S6<17oo0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007ooOol00Woo0Re[0THa0U[F0R48
0SF]0Ukg0RU:0Tic0SW>0S6<0QBU0SF]0Vmk0THa0R480THa0Re[0Sg_0VLi0UJe0Sg_0VLi0Sg_0Tic
0U:D0SF]0Tic0SF]148@0SW>0T8@0RDY0TYB0SF]0SW>0RU:0V<H14ic0PaS0W_N0PQ20SW>0RDY0UJe
0SW>0U:D0Tic0Sg_0THa0Tic0V<H0Re[0UJe0T8@0TYB148@13g_0T8@0Re[00=F]DicCW<00THa0T8@
0R480UJe0Sg_0TYB0Tic0Ukg0U:D0Sg_0V<H0Tic0TYB0Re[148@0SW>0Tic13W>0VLi0QBU0THa0SF]
0THa0T8@0U:D0Sg_0Tic1Sg_14ic0T8@1Sg_0Tic0PQ20U[F0U:D0T8@13g_0T8@0SF]0TYB0Re[0T8@
0SF]0Sg_148@3Sg_0TYB0Sg_1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03
001oogoo009oo`8]J`96<@9JeP8Q208e[@9Nm`8YBP9>L`8icP8aS08DY@8e[@9_N`96<@8Q2096<@8]
J`8mk`9W>@9F]@8mk`9W>@8mk`9>L`9BU08e[@9>L`8e[@A2408icP92408U:@9:DP8e[@8icP8YBP9S
60A>L`8<H`9kgP88@P8icP8U:@9F]@8icP9BU09>L`8mk`96<@9>L`9S608]J`9F]@92409:DPA240@m
k`92408]J`03E[E>Ldic0096<@92408Q209F]@8mk`9:DP9>L`9Nm`9BU08mk`9S609>L`9:DP8]J`A2
408icP9>L`@icP9W>@8DY@96<@8e[@96<@92409BU08mk`9>L`Hmk`A>L`9240Hmk`9>L`88@P9JeP9B
U09240@mk`92408e[@9:DP8]J`92408e[@8mk`A240hmk`9:DP8mk`Eoo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo0R480UJe0RU:0Re[15:D0U[F0SF]0SW>15:D0U[F0TYB0SF]0SW>15Je
0THa0PQ20T8@0Re[0QS60U[F0T8@0S6<0P000Tic13W>0Sg_0T8@0SF]0THa148@0Tic0U:D0U[F0S6<
0RU:0Tic0THa0P@Q0U[F0Sg_0P000U:D0QS60V]J13g_0S6<0U[F0SW>0T8@13g_13F]1Sg_0T8@00=B
U2DY9BT00Tic0Re[0UJe0R480RDY0U:D0TYB0RDY0TYB0R4814ic14Ha13g_0Re[0THa0R480QcW0THa
0Re[0QcW0VLi0RDY0TYB0Sg_0U:D0QcW0T8@0Sg_0U:D0S6<0T8@0RU:0T8@1Sg_0T8@0THa0TYB0UJe
0RDY0SW>0T8@13g_0T8@1Sg_0SW>0SF]43g_0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool28@P2
E[D2:DX2;F/4DY@2F]H2=Jd2>Lh4DY@2F]H2BU82=Jd2>Lh4E[D2AS422482@Q02;F/26<H2F]H2@Q02
<H`20002CW<4>Lh2?Nl2@Q02=Jd2AS44@Q02CW<2DY@2F]H2<H`2:DX2CW<2AS421242F]H2?Nl20002
DY@26<H2JeX4?Nl2<H`2F]H2>Lh2@Q04?Nl4=Jd6?Nl2@Q000e:D9BTU:@02CW<2;F/2E[D28@P29BT2
DY@2BU829BT2BU828@P4CW<4AS44?Nl2;F/2AS428@P27>L2AS42;F/27>L2IcT29BT2BU82?Nl2DY@2
7>L2@Q02?Nl2DY@2<H`2@Q02:DX2@Q06?Nl2@Q02AS42BU82E[D29BT2>Lh2@Q04?Nl2@Q06?Nl2>Lh2
=Jd@?Nl2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9F]@8e[@ABU08e[@924096<@A:DP8icP8Q
209JeP8icP96<@8e[@8mk`8]J`96<@8YBP9JeP8DY@92408icP9>L`8e[@Pmk`92408HaP9>L`8mk`9F
]@A6<@@icP9JeP8YBP8]J`92409JeP9BU08mk`96<@92408DY@8aS0A2409JeP8]J`96<A0mk`9>L`03
<H`YBRU:00@YBPAF]@8e[@8mk`96<@9:DP8mk`92408mk`92408e[@9JeP92408mk`8]J`8aS08icP96
<@8U:@96<@9>L`8e[@9240Hmk`9240@mk`9BU08YBPA:DP@mk`8aS092408Q209>L`@icP9BU2@mk`96
<@Eoo`40005oo`005Goo00<007ooOol00Woo0UJe0SF]15:D0SF]0T8@0THa14YB0SW>0R480U[F0SW>
0THa0SF]0Sg_0Re[0THa0RU:0U[F0QBU0T8@0SW>0Tic0SF]23g_0T8@0QS60Tic0Sg_0UJe14Ha13W>
0U[F0RU:0Re[0T8@0U[F0U:D0Sg_0THa0T8@0QBU0S6<148@0U[F0Re[0THa43g_0Tic00<aS2U::DX0
12U:15Je0SF]0Sg_0THa0TYB0Sg_0T8@0Sg_0T8@0SF]0U[F0T8@0Sg_0Re[0S6<0SW>0THa0RDY0THa
0Tic0SF]0T8@1Sg_0T8@13g_0U:D0RU:14YB13g_0S6<0T8@0R480Tic13W>0U:D93g_0THa1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2?Nl2HaP2;F/2<H`2@Q02BU82DY@2<H`2@Q02<H`2DY@22482BU82
?Nl2@Q02HaP2;F/2>Lh2CW<2<H`2?Nl2BU82<H`25:D2F]H29BT2@Q04?Nl2@Q02G_L28@P2BU82>Lh2
CW<2BU84DY@2=Jd2?Nl2;F/2DY@2BU827>L2@Q04?Nl2=Jd2E[D2<H`4=Jd2>Lh2E[D>?Nl2@Q028@P0
0f<H>LhicP02AS42:DX2E[D2;F/2?Nl2;F/2?Nl2DY@2;F/2@Q02BU829BT2@Q02AS42G_L4?Nl2G_L2
=Jd2?Nl29BT2@Q02E[D4=Jd2?Nl2@Q02?Nl2@Q06?Nl2=Jd2@Q04>Lh2E[D27>L2<H`2@Q02AS42?Nl2
AS42?Nl2AS4P?Nl2AS42@Q05Ool10001Ool001Eoo`03001oogoo009oo`8mk`9S608]J`8aS092409:
DP9BU08aS092408aS09BU088@P9:DP8mk`92409S608]J`8icP9>L`8aS08mk`9:DP8aS08DY@9JeP8U
:@9240@mk`92409Nm`8Q209:DP8icP9>L`9:DPABU08e[@8mk`8]J`9BU09:DP8Li`9240@mk`8e[@9F
]@8aS0@e[@8icP9F]@hmk`92408Q2003HaPicSW>0096<@8YBP9F]@8]J`8mk`8]J`8mk`9BU08]J`92
409:DP8U:@924096<@9Nm`@mk`9Nm`8e[@8mk`8U:@92409F]@@e[@8mk`92408mk`9240Hmk`8e[@92
40@icP9F]@8Li`8aS0924096<@8mk`96<@8mk`96<B0mk`96<@9240Eoo`40005oo`005Goo00<007oo
Ool00Woo0Ukg0SF]0S6<0Tic0W_N0SW>0TYB0SW>0THa0QS60S6<0RDY0T8@0Sg_0U:D13W>24ic0RDY
0U:D0TYB0Woo0RU:2Sg_0Re[0S6<13W>0U:D0R480THa0UJe0SW>0Sg_0S6<0TYB0RU:0UJe0Tic0THa
0TYB0U[F0SF]0S6<0Tic0U:D0Re[0T8@3Sg_0THa00=2436<<H`00S6<0Tic15[F0RDY0SW>0THa0RDY
0SW>0THa0Re[0SW>0Tic0VLi0SW>0T8@0Re[0Sg_0SW>0R480THa0Re[0UJe0S6<0Re[0Tic0RDY0U[F
0QBU0T8@13g_0TYB0RU:0Tic0Sg_0SW>0Re[0SW>0UJe0Sg_0SF]0THa0SW>0QBU0Tic7Sg_0SW>0QcW
1Goo0@000Goo000EOol20003Ool2G_L2=Jd2<H`2CW<2Nmh2>Lh2BU82>Lh2AS426<H2<H`29BT2@Q02
?Nl2DY@4>Lh8CW<29BT2DY@2BU82Ool2:DX:?Nl2;F/2<H`4>Lh2DY@28@P2AS42E[D2>Lh2?Nl2<H`2
BU82:DX2E[D2CW<2AS42BU82F]H2=Jd2<H`2CW<2DY@2;F/2@Q0>?Nl2AS400d8@<H`aS002<H`2CW<4
F]H29BT2>Lh2AS429BT2>Lh2AS42;F/2>Lh2CW<2IcT2>Lh2@Q02;F/2?Nl2>Lh28@P2AS42;F/2E[D2
<H`2;F/2CW<29BT2F]H25:D2@Q04?Nl2BU82:DX2CW<2?Nl2>Lh2;F/2>Lh2E[D2?Nl2=Jd2AS42>Lh2
5:D2CW<N?Nl2>Lh27>L4Ool20001Ool001Eoo`03001oogoo009oo`8]J`9BU08U:@848@8DY@8icP9>
L`9_N`9S609:DP9BU08U:@8mk`8icP9BU09240@icP8Q208U:@@e[@8mk`96<@9>L`9F]@Pmk`96<@9F
]@8icP9F]@92408aS09:DP@mk`8]J`9BU09>L`8e[@8aS08e[@Pmk`A2408mk`8icP9>La8mk`03<H`Q
2248008Q20A:DP9JeP@e[@8Li`8icP8mk`9S60`mk`A2408]J`8icP9240@]J`8icPA:DP92408mk`92
40`mk`92408]J`9BU09>L`8]J`8aS08icP9F]@8e[@8icR8mk`9BU0Eoo`40005oo`005Goo00<007oo
Ool00Woo0Re[0U:D0RDY0P@Q0QBU0SW>0Tic0Vmk0V<H0TYB0U:D0RDY0Sg_0SW>0U:D0T8@13W>0R48
0RDY13F]0Sg_0THa0Tic0UJe23g_0THa0UJe0SW>0UJe0T8@0S6<0TYB13g_0Re[0U:D0Tic0SF]0S6<
0SF]23g_148@0Sg_0SW>0Tic4Sg_00<aS2488@P00R4814YB0U[F13F]0QcW0SW>0Sg_0V<H33g_148@
0Re[0SW>0T8@12e[0SW>14YB0T8@0Sg_0T8@33g_0T8@0Re[0U:D0Tic0Re[0S6<0SW>0UJe0SF]0SW>
8Sg_0U:D1Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`2BU84DY@2<H`2BU82<H`2:DX2BU82DY@2
AS42=Jd4@Q029BT2?Nl2CW<4@Q02CW<2>Lh2F]H2@Q02DY@2@Q02>Lh2@Q04?Nl2@Q02CW<2@Q02>Lh4
BU82@Q02?Nl2>Lh2?Nl2@Q02?Nl2BU82?Nl2AS42F]H2=Jd2?Nl2AS42F]H2DY@2?Nl2;F/2G_L2@Q0>
?Nl2@Q02<H`00cF]?Nlmk`02DY@2?Nl2BU82G_L2<H`2G_L2@Q02?Nl2@Q02;F/4@Q02?Nl2@Q08?Nl2
@Q02?Nl2BU82CW<2BU82:DX28@P2AS42?Nl2<H`2@Q02?Nl2@Q02?Nl2AS42E[D2=Jd2?Nl2G_L4<H`2
AS42DY@2F]H2E[D2=Jd2@Q0P?Nl2@Q029BT5Ool10001Ool001Eoo`03001oogoo009oo`8aS09:DPAB
U08aS09:DP8aS08YBP9:DP9BU096<@8e[@A2408U:@8mk`9>L`A2409>L`8icP9JeP92409BU092408i
cP9240@mk`92409>L`92408icPA:DP92408mk`8icP8mk`92408mk`9:DP8mk`96<@9JeP8e[@8mk`96
<@9JeP9BU08mk`8]J`9Nm`9240hmk`92408aS003=Jdmkcg_009BU08mk`9:DP9Nm`8aS09Nm`92408m
k`92408]J`A2408mk`9240Pmk`92408mk`9:DP9>L`9:DP8YBP8Q2096<@8mk`8aS092408mk`92408m
k`96<@9F]@8e[@8mk`9Nm`@aS096<@9BU09JeP9F]@8e[@92420mk`92408U:@Eoo`40005oo`005Goo
00<007ooOol00Woo0Tic0T8@0Sg_0SF]0T8@0SF]0Sg_0V<H0RDY0T8@0Re[0THa148@0SW>0Sg_0SF]
0SW>0S6<0Re[0Ukg0TYB0R480TYB0SW>0T8@0Sg_14Ha0Sg_0SW>0U:D0THa14ic0R480Sg_0UJe0SF]
0T8@0Sg_0S6<0Re[0TYB0S6<0RDY0Ukg0Re[0THa0Q240Vmk0QS62Sg_14Ha1Sg_0UJe00<icV<HHaP0
0S6<0Sg_0UJe0S6<0SW>0RDY0SW>0TYB0Re[0SW>0T8@0R480Tic0T8@0V<H148@1Sg_0SF]0TYB0THa
0TYB0UJe0TYB0UJe0U[F0S6<0SW>0RU:0T8@0SF]0Sg_0Tic0RDY1SF]0THa0RU:0THa0Sg_0T8@43g_
0THa0T8@3Sg_13W>1Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<2@Q02?Nl2=Jd2@Q02=Jd2?Nl2
HaP29BT2@Q02;F/2AS44@Q02>Lh2?Nl2=Jd2>Lh2<H`2;F/2G_L2BU828@P2BU82>Lh2@Q02?Nl4AS42
?Nl2>Lh2DY@2AS44CW<28@P2?Nl2E[D2=Jd2@Q02?Nl2<H`2;F/2BU82<H`29BT2G_L2;F/2AS4248@2
Kg/26<H:?Nl4AS46?Nl2E[D00cW>HaQS6002<H`2?Nl2E[D2<H`2>Lh29BT2>Lh2BU82;F/2>Lh2@Q02
8@P2CW<2@Q02HaP4@Q06?Nl2=Jd2BU82AS42BU82E[D2BU82E[D2F]H2<H`2>Lh2:DX2@Q02=Jd2?Nl2
CW<29BT6=Jd2AS42:DX2AS42?Nl2@Q0@?Nl2AS42@Q0>?Nl4>Lh5Ool10001Ool001Eoo`03001oogoo
009oo`8mk`92408mk`8HaP8mk`8e[@9>L`9F]@9W>@8<H`9JeP9:DP96<@A:DP8]J`8aS08icP8mk`9_
N`8aS092409>L`9:DP8YBP8icP8mk`96<@9:DP92408U:@8icP9:DP8mk`8aS092408mk`92408mk`96
<@9Nm`AF]@8]J`92409:DP96<@9W>@8e[@8mk`9Nm`9W>@8icP8mk`9240@mk`96<@9BU0Hmk`8icP03
36<icSW>009:DP92408aS09F]@9:DP8icP92408icP9240@mk`96<@@mk`8icP9:DP8Q209F]@8e[@9:
DP8]J`He[@9[FP8icP9Nm`924096<@9Nm`8mk`@]J`92408icP9_N`8DY@8mk`@]J`9BU1@mk`92409:
DP9S60hmk`96<@9Nm`Eoo`40005oo`005Goo00<007ooOol00Woo0Sg_0T8@0Sg_0QS60Sg_0SF]0Tic
0UJe0VLi0PaS0U[F0TYB0THa14YB0Re[0S6<0SW>0Sg_0Vmk0S6<0T8@0Tic0TYB0RU:0SW>0Sg_0THa
0TYB0T8@0RDY0SW>0TYB0Sg_0S6<0T8@0Sg_0T8@0Sg_0THa0Ukg15Je0Re[0T8@0TYB0THa0VLi0SF]
0Sg_0Ukg0VLi0SW>0Sg_0T8@13g_0THa0U:D1Sg_0SW>00<<HcW>>Lh00TYB0T8@0S6<0UJe0TYB0SW>
0T8@0SW>0T8@13g_0THa13g_0SW>0TYB0R480UJe0SF]0TYB0Re[1SF]0V]J0SW>0Ukg0T8@0THa0Ukg
0Sg_12e[0T8@0SW>0Vmk0QBU0Sg_12e[0U:D53g_0T8@0TYB0V<H3Sg_0THa0Ukg1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2;F/2AS44?Nl2BU82AS42BU82AS42>Lh2DY@2=Jd26<H2?Nl2>Lh29BT2DY@2
@Q02HaP2G_L28@P2DY@2AS42?Nl2>Lh236<2BU82>Lh2:DX2>Lh2?Nl2G_L2DY@2:DX2CW<2>Lh2@Q02
>Lh2?Nl2;F/2=Jd2?Nl2BU84@Q0248@2@Q02?Nl2>Lh4?Nl2DY@2?Nl2@Q02?Nl2@Q02BU82AS42F]H2
=Jd6?Nl2>Lh00dHa>LhicP02@Q02?Nl4<H`2=Jd2@Q02?Nl2DY@4?Nl2CW<2=Jd2BU82?Nl2E[D2>Lh2
@Q02?Nl2=Jd2BU82@Q02?Nl2E[D2CW<2AS42:DX2?Nl2BU86?Nl6@Q02?Nl2BU82CW<2;F/2@Q029BT2
;F/2?Nl2@Q06?Nl2AS42F]H4?Nl2AS42;F/2BU82?Nl2@Q0>?Nl2=Jd5Ool10001Ool001Eoo`8000=o
o`8]J`96<@@mk`9:DP96<@9:DP96<@8icP9BU08e[@8HaP8mk`8icP8U:@9BU092409S609Nm`8Q209B
U096<@8mk`8icP8<H`9:DP8icP8YBP8icP8mk`9Nm`9BU08YBP9>L`8icP92408icP8mk`8]J`8e[@8m
k`9:DPA2408@Q092408mk`8icP@mk`9BU08mk`92408mk`92409:DP96<@9JeP8e[@Hmk`8icP03AS4i
cSW>0092408mk`@aS08e[@92408mk`9BU0@mk`9>L`8e[@9:DP8mk`9F]@8icP92408mk`8e[@9:DP92
408mk`9F]@9>L`96<@8YBP8mk`9:DPHmk`I2408mk`9:DP9>L`8]J`92408U:@8]J`8mk`9240Hmk`96
<@9JeP@mk`96<@8]J`9:DP8mk`9240hmk`8e[@Aoo`80005oo`005Goo00<007ooOol00Woo0SF]0Sg_
0T8@0Sg_0Ukg0Tic0Sg_0S6<0THa0SW>0SF]0U:D0SW>0T8@14Ha0S6<0U:D0R480Sg_0SF]0S6<0UJe
0SF]14Ha0Sg_0TYB148@0S6<1Sg_14Ha0Sg_0S6<0UJe0Ukg0SW>0Sg_0SW>0T8@0Tic0S6<13W>0Tic
0SF]0Re[0S6<0U:D0THa0RU:0T8@0Sg_0SW>0U:D13g_0T8@0SW>00<e[D8@@Q000Ukg0Sg_0T8@0Sg_
0T8@0Sg_14Ha13g_0TYB0SF]13W>12e[0TYB23g_0T8@0RU:0T8@0Sg_0SW>0RDY0T8@0TYB0Sg_0TYB
0SF]0THa0RDY0Sg_1SW>0THa0SF]0Sg_0TYB0SF]0Sg_0T8@13F]148@0Re[0U:D13g_0SW>0SF]33g_
0T8@0S6<1Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd2?Nl2@Q02?Nl2G_L2CW<2?Nl2<H`2AS42
>Lh2=Jd2DY@2>Lh2@Q04AS42<H`2DY@28@P2?Nl2=Jd2<H`2E[D2=Jd4AS42?Nl2BU84@Q02<H`6?Nl4
AS42?Nl2<H`2E[D2G_L2>Lh2?Nl2>Lh2@Q02CW<2<H`4>Lh2CW<2=Jd2;F/2<H`2DY@2AS42:DX2@Q02
?Nl2>Lh2DY@4?Nl2@Q02>Lh00cF]@Q124002G_L2?Nl2@Q02?Nl2@Q02?Nl4AS44?Nl2BU82=Jd4>Lh4
;F/2BU88?Nl2@Q02:DX2@Q02?Nl2>Lh29BT2@Q02BU82?Nl2BU82=Jd2AS429BT2?Nl6>Lh2AS42=Jd2
?Nl2BU82=Jd2?Nl2@Q04=Jd4@Q02;F/2DY@4?Nl2>Lh2=Jd<?Nl2@Q02<H`5Ool10001Ool001Eoo`03
001oogoo009oo`9:DP8mk`92408mk`8Q209:DP8mk`8e[@8mk`8aS09S609>L`9S60924096<@8Li`9>
L`8e[@9240@mk`9:DP9>L`9BU08mk`8icP8YBP8aS08mk`96<@9BU096<@8mk`92408mk`9:DP8e[@8m
k`8aS0Hmk`92408]J`9JeP8e[@9JeP96<@8]J`9Nm`9:DP8aS08icP8e[@8Q209>L`9240Pmk`9:DP9B
U003@Q1F]EJe008]J`92408mk`9BU0Pmk`96<@8mk`96<@8mk`9>L`8e[@8mk`9F]@`mk`924096<@8i
cP9BU08U:@9JeP8mk`9BU08aS09>L`8Li`8mk`8YBP9BU09F]@8YBP96<@9BU092408icP8mk`92408e
[@92408icP8e[@92408aS08e[A8mk`96<@8]J`8e[@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB
0Sg_0T8@0Sg_0R480TYB0Sg_0SF]0Sg_0S6<0V<H0Tic0V<H0T8@0THa0QcW0Tic0SF]0T8@13g_0TYB
0Tic0U:D0Sg_0SW>0RU:0S6<0Sg_0THa0U:D0THa0Sg_0T8@0Sg_0TYB0SF]0Sg_0S6<1Sg_0T8@0Re[
0U[F0SF]0U[F0THa0Re[0Ukg0TYB0S6<0SW>0SF]0R480Tic0T8@23g_0TYB0U:D00=245JeE[D00Re[
0T8@0Sg_0U:D23g_0THa0Sg_0THa0Sg_0Tic0SF]0Sg_0UJe33g_0T8@0THa0SW>0U:D0RDY0U[F0Sg_
0U:D0S6<0Tic0QcW0Sg_0RU:0U:D0UJe0RU:0THa0U:D0T8@0SW>0Sg_0T8@0SF]0T8@0SW>0SF]0T8@
0S6<0SF]4Sg_0THa0Re[0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D2F]H4<H`2=Jd2?Nl2
;F/2?Nl2;F/2CW<2BU82Mkd28@P2<H`4:DX2BU82JeX2:DX2@Q02>Lh29BT2@Q02BU82>Lh2IcT2G_L2
CW<2@Q02<H`2CW<2E[D2?Nl2=Jd2?Nl2BU829BT2@Q02>Lh:?Nl2DY@2<H`2?Nl2>Lh2BU82HaP2Kg/2
>Lh2@Q02Li`2DY@2@Q02CW<2?Nl2CW<4?Nl2<H`2=Jd00bDY=Jde[@027>L2@Q02>Lh2=Jd8?Nl2BU82
?Nl2E[D2CW<2;F/2>Lh2@Q02;F/2@Q0@?Nl2BU829BT2<H`25:D2>Lh2@Q02?Nl2;F/2@Q02AS42@Q02
8@P2=Jd2@Q02<H`2>Lh2=Jd2HaP2<H`2Mkd2;F/4@Q029BT2=Jd2@Q04?Nl2>Lh2=Jd:?Nl2=Jd2AS42
BU85Ool10001Ool001Eoo`03001oogoo009oo`9F]@9JeP@aS08e[@8mk`8]J`8mk`8]J`9>L`9:DP9g
_@8Q208aS0@YBP9:DP9[FP8YBP92408icP8U:@92409:DP8icP9W>@9Nm`9>L`92408aS09>L`9F]@8m
k`8e[@8mk`9:DP8U:@92408icPXmk`9BU08aS08mk`8icP9:DP9S609_N`8icP92409cW09BU092409>
L`8mk`9>L`@mk`8aS08e[@039BTe[CF]008Li`92408icP8e[@Pmk`9:DP8mk`9F]@9>L`8]J`8icP92
408]J`92410mk`9:DP8U:@8aS08DY@8icP92408mk`8]J`924096<@92408Q208e[@92408aS08icP8e
[@9S608aS09g_@8]J`A2408U:@8e[@9240@mk`8icP8e[@Xmk`8e[@96<@9:DPEoo`40005oo`005Goo
00<007ooOol00Woo0S6<0R480U:D0THa0PQ20S6<0SW>0SF]0Sg_0SW>0Ukg0RDY0SW>0THa0T8@0S6<
0T8@0THa1Sg_0U:D0T8@0U:D0Re[0PQ20QS60SF]0T8@0THa0T8@0SW>0SF]0T8@0SW>0Tic0U[F0THa
2Sg_0T8@0RU:0QBU0Sg_0TYB0Sg_0Ukg0Sg_0U:D0R480P@Q0S6<0SF]0SW>23g_0THa0Sg_00=BU2DY
9BT00SW>0Sg_0Re[0T8@0Sg_0T8@0Re[0T8@0TYB0Re[0SW>0UJe1Sg_0T8@4Sg_0THa0U:D0Tic0Re[
0Tic0Sg_0TYB0SF]0Tic0SW>0TYB0S6<0Sg_0RDY14YB0RU:0THa0T8@0Q240Tic0SW>0Sg_0SW>0TYB
1Sg_148@2Sg_0T8@0V<H0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`28@P2DY@2AS422482
<H`2>Lh2=Jd2?Nl2>Lh2G_L29BT2>Lh2AS42@Q02<H`2@Q02AS46?Nl2DY@2@Q02DY@2;F/224826<H2
=Jd2@Q02AS42@Q02>Lh2=Jd2@Q02>Lh2CW<2F]H2AS4:?Nl2@Q02:DX25:D2?Nl2BU82?Nl2G_L2?Nl2
DY@28@P21242<H`2=Jd2>Lh8?Nl2AS42?Nl00e:D9BTU:@02>Lh2?Nl2;F/2@Q02?Nl2@Q02;F/2@Q02
BU82;F/2>Lh2E[D6?Nl2@Q0B?Nl2AS42DY@2CW<2;F/2CW<2?Nl2BU82=Jd2CW<2>Lh2BU82<H`2?Nl2
9BT4BU82:DX2AS42@Q0248@2CW<2>Lh2?Nl2>Lh2BU86?Nl4@Q0:?Nl2@Q02HaP2AS45Ool10001Ool0
01Eoo`03001oogoo009oo`9>L`9JeP8e[@8icP9[FP9>L`96<@9:DP8YBP9:DP8aS09S609BU08icP8m
k`9F]@HaS096<@92409:DP96<@9>L`9[FP9W>@9>L`HicP8]J`96<@9JeP@mk`8aS08icP9JeP92408Y
BP92408mk`96<@8mk`92408e[@9:DP9>L`8aS08mk`9Nm`8aS08mk`9F]@8e[@92408mk`8e[@8icP92
408mk`A240=:DP96<@9BU08e[@@mk`A2408mk`8e[@9>L`92409BU08e[@8mk`9240@e[@9240Pmk`9F
]@8icP92408icP8mk`9JeP8icP8]J`A6<@9:DP9>L`96<@9BU08]J`8HaP8mk`96<@8mk`92408mk`9[
FP9F]@8aS08icP9240Hmk`96<@9JeP8mk`9240@mk`9240@mk`9BU08icP96<@Eoo`40005oo`005Goo
0P000goo0Tic0U[F0SF]0SW>0V]J0Tic0THa0TYB0RU:0TYB0S6<0V<H0U:D0SW>0Sg_0UJe1S6<0THa
0T8@0TYB0THa0Tic0V]J0VLi0Tic1SW>0Re[0THa0U[F13g_0S6<0SW>0U[F0T8@0RU:0T8@0Sg_0THa
0Sg_0T8@0SF]0TYB0Tic0S6<0Sg_0Ukg0S6<0Sg_0UJe0SF]0T8@0Sg_0SF]0SW>0T8@0Sg_148@0dYB
0THa0U:D0SF]13g_148@0Sg_0SF]0Tic0T8@0U:D0SF]0Sg_0T8@13F]0T8@23g_0UJe0SW>0T8@0SW>
0Sg_0U[F0SW>0Re[14Ha0TYB0Tic0THa0U:D0Re[0QS60Sg_0THa0Sg_0T8@0Sg_0V]J0UJe0S6<0SW>
0T8@1Sg_0THa0U[F0Sg_0T8@13g_0T8@13g_0U:D0SW>0THa17oo0P000Goo000EOol00`00Oomoo`02
Ool2<H`2DY@29BT2@Q02;F/2E[D2;F/2AS42<H`2AS42CW<2DY@2@Q02CW<2=Jd27>L2DY@2<H`2AS42
@Q02G_L2BU82:DX2>Lh2<H`2@Q04>Lh2DY@2HaP2>Lh4?Nl2@Q02DY@2CW<2BU829BT2>Lh2BU82AS42
?Nl2<H`2=Jd29BT2DY@29BT4BU82DY@29BT2HaP2>Lh25:D29BT2BU82?Nl4@Q02<H`2CW<2AS42>Lh;
?Nl2@Q04=Jd2?Nl2BU82<H`2@Q02<H`2@Q02BU82?Nl2@Q04AS48?Nl2=Jd2CW<2?Nl2F]H2:DX2@Q02
;F/2@Q02DY@2E[D2>Lh2CW<2@Q02BU86>Lh2DY@2=Jd2?Nl2>Lh2<H`2CW<2BU82=Jd2?Nl2CW<4?Nl2
>Lh2@Q02>Lh2:DX2BU82?Nl2=Jd2?Nl2@Q02=Jd2@Q02?Nl5Ool10001Ool001Eoo`03001oogoo009o
o`8aS09BU08U:@92408]J`9F]@8]J`96<@8aS096<@9>L`9BU092409>L`8e[@8Li`9BU08aS096<@92
409Nm`9:DP8YBP8icP8aS09240@icP9BU09S608icP@mk`92409BU09>L`9:DP8U:@8icP9:DP96<@8m
k`8aS08e[@8U:@9BU08U:@A:DP9BU08U:@9S608icP8DY@8U:@9:DP8mk`A2408aS09>L`96<@8icP/m
k`9240@e[@8mk`9:DP8aS092408aS092409:DP8mk`9240A6<@Pmk`8e[@9>L`8mk`9JeP8YBP92408]
J`92409BU09F]@8icP9>L`92409:DPHicP9BU08e[@8mk`8icP8aS09>L`9:DP8e[@8mk`9>L`@mk`8i
cP92408icP8YBP9:DP8mk`8e[@8mk`92408e[@92408mk`Eoo`40005oo`005Goo00<007ooOol00Woo
0U[F0UJe0S6<0Tic0SW>0Tic0UJe0SW>0TYB0Sg_0SF]0TYB0U[F0SW>0Re[0TYB0S6<0Ukg0RDY0T8@
0PaS0Sg_0R480Sg_0TYB0RU:0U[F148@0S6<0TYB0SW>0T8@0SF]0SW>0Sg_0S6<0QcW0TYB0THa13g_
0TYB0Sg_0R480QS60Q240SF]0S6<0Q240V]J0T8@0TYB0S6<0Ukg0Sg_0SW>0Sg_0Tic0Ukg0QS60Sg_
0UJe00<aS48@@Q000Re[0T8@13g_0SF]0TYB1Sg_0T8@0S6<0Sg_0SF]0T8@13F]2Sg_0T8@0S6<0R48
13g_0T8@13W>0Sg_0R480TYB0THa0T8@0UJe0QcW0U[F0Sg_0Tic0THa0T8@0Sg_0TYB0THa0U[F0RU:
0TYB0Sg_0Tic13g_0U:D0RU:0Sg_0U[F0Sg_14YB0U:D13g_0SF]0TYB1Goo0@000Goo000EOol00`00
Oomoo`02Ool2F]H2E[D2<H`2CW<2>Lh2CW<2E[D2>Lh2BU82?Nl2=Jd2BU82F]H2>Lh2;F/2BU82<H`2
G_L29BT2@Q0236<2?Nl28@P2?Nl2BU82:DX2F]H4@Q02<H`2BU82>Lh2@Q02=Jd2>Lh2?Nl2<H`27>L2
BU82AS44?Nl2BU82?Nl28@P26<H248@2=Jd2<H`248@2JeX2@Q02BU82<H`2G_L2?Nl2>Lh2?Nl2CW<2
G_L26<H2?Nl2E[D00c6<@Q124002;F/2@Q04?Nl2=Jd2BU86?Nl2@Q02<H`2?Nl2=Jd2@Q04=Jd:?Nl2
@Q02<H`28@P4?Nl2@Q04>Lh2?Nl28@P2BU82AS42@Q02E[D27>L2F]H2?Nl2CW<2AS42@Q02?Nl2BU82
AS42F]H2:DX2BU82?Nl2CW<4?Nl2DY@2:DX2?Nl2F]H2?Nl4BU82DY@4?Nl2=Jd2BU85Ool10001Ool0
01Eoo`03001oogoo009oo`8icP8aS08icP9:DP96<@8e[@92409:DP9Nm`9>L`@aS08e[@8mk`A6<@92
408mk`9:DP8icP96<@92408aS09>L`96<@8]J`8e[@8mk`924096<@9240Xmk`I6<@9:DP8e[@96<@AF
]@@mk`8icP9>L`8mk`8U:@9BU08icP92408aS08icPPmk`92409>L`@mk`03DY@e[CF]008icQ8mk`92
408]J`9:DP8e[@92408icP8aS08e[@@mk`A6<@9Nm`92408e[@92408mk`9BU0@U:@8aS08YBP9JeP96
<@8e[@A2408e[@96<@Hmk`92408]J`8e[@9:DP`mk`9240Hmk`96<@9JePXmk`Eoo`40005oo`005Goo
00<007ooOol00Woo0SW>0S6<0SW>0TYB0THa0SF]0T8@0TYB0Ukg0Tic136<0SF]0Sg_14Ha0T8@0Sg_
0TYB0SW>0THa0T8@0S6<0Tic0THa0Re[0SF]0Sg_0T8@0THa0T8@2Sg_1THa0TYB0SF]0THa15Je13g_
0SW>0Tic0Sg_0RDY0U:D0SW>0T8@0S6<0SW>23g_0T8@0Tic13g_00=BU3F]=Jd00SW>4Sg_0T8@0Re[
0TYB0SF]0T8@0SW>0S6<0SF]13g_14Ha0Ukg0T8@0SF]0T8@0Sg_0U:D12DY0S6<0RU:0U[F0THa0SF]
148@0SF]0THa1Sg_0T8@0Re[0SF]0TYB33g_0T8@1Sg_0THa0U[F2Sg_1Goo0@000Goo000EOol00`00
Oomoo`02Ool2E[D2AS42@Q02AS44@Q02?Nl2@Q02:DX4?Nl2>Lh2@Q02?Nl4@Q02>Lh2=Jd29BT6AS42
<H`2?Nl2>Lh2<H`4@Q02<H`8?Nl2>Lh2@Q02<H`2?Nl2DY@2AS42?Nl2AS44?Nl2@Q02?Nl2@Q02<H`2
;F/2>Lh2BU829BT4@Q02BU86?Nl2@Q04AS4??Nl2@Q06?Nl2@Q02G_L2?Nl2@Q029BT2BU82?Nl2AS42
>Lh2;F/2@Q0<?Nl2@Q02:DX2@Q02?Nl2@Q02AS42>Lh2AS42BU82?Nl2<H`2?Nl2DY@2@Q02AS44?Nl2
@Q02AS42BU8D?Nl4AS4>?Nl5Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eoo`03001o
ogoo009oo`9F]@96<@924096<@A2408mk`92408YBP@mk`8icP92408mk`A2408icP8e[@8U:@I6<@8a
S08mk`8icP8aS0A2408aS0Pmk`8icP92408aS08mk`9BU096<@8mk`96<@@mk`92408mk`92408aS08]
J`8icP9:DP8U:@A2409:DPHmk`9240A6<@lmk`9240Hmk`92409Nm`8mk`92408U:@9:DP8mk`96<@8i
cP8]J`9240`mk`92408YBP92408mk`924096<@8icP96<@9:DP8mk`8aS08mk`9BU0924096<@@mk`92
4096<@9:DQ@mk`A6<@hmk`Eoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool0
0`00Oomoo`02Ool00`00Oomoo`02Ool2?Nl2>Lh2BU82=Jd2?Nl2>Lh2CW<2@Q04?Nl2:DX2BU82>Lh2
BU82=Jd4@Q02CW<2?Nl2@Q02>Lh2=Jd4?Nl2>Lh2AS42?Nl2>Lh4@Q029BT2>Lh2@Q02E[D2=Jd2AS44
=Jd2>Lh2@Q02?Nl2BU84?Nl2@Q049BT2@Q02BU82=Jd2?Nl2AS42DY@2>Lh6?Nl2<H`6?Nl2@Q03AS42
=Jd2@Q02?Nl2@Q029BT2BU84?Nl2DY@2>Lh2?Nl2=Jd2>Lh2?Nl2@Q02:DX2@Q08?Nl2DY@8?Nl2E[D2
?Nl2AS42?Nl2DY@2=Jd2DY@2=Jd2G_L29BT2AS42F]H4?Nl2>Lh2E[D29BT2BU82?Nl2@Q08?Nl2@Q02
?Nl2BU82AS4>?Nl4@Q02>Lh5Ool10001Ool000=oo`05001oogooOol00002Ool01000Oomoo`000Woo
00<007ooOol00Woo0P000goo0Sg_0SW>0TYB0SF]0Sg_0SW>0Tic0T8@13g_0RU:0TYB0SW>0TYB0SF]
148@0Tic0Sg_0T8@0SW>0SF]13g_0SW>0THa0Sg_0SW>148@0RDY0SW>0T8@0UJe0SF]0THa13F]0SW>
0T8@0Sg_0TYB13g_0T8@12DY0T8@0TYB0SF]0Sg_0THa0U:D0SW>1Sg_0S6<1Sg_0T8@0dHa0SF]0T8@
0Sg_0T8@0RDY0TYB13g_0U:D0SW>0Sg_0SF]0SW>0Sg_0T8@0RU:0T8@23g_0U:D23g_0UJe0Sg_0THa
0Sg_0U:D0SF]0U:D0SF]0Ukg0RDY0THa0U[F13g_0SW>0UJe0RDY0TYB0Sg_0T8@23g_0T8@0Sg_0TYB
0THa3Sg_148@0SW>17oo0P000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001o
ogoo009oo`03001oogoo009oo`8e[@9>L`8icP8mk`8@Q09BU08e[@96<@8aS09JeP9>L`8mk`9F]@@e
[@92408aS09>L`8aS08e[@8icP8YBP96<@8icP9Nm`96<@8mk`9JeP8mk`8e[@8YBP9:DP8]J`8icP96
<@9:DP@e[@9BU0A2408Li`8aS08e[@@mk`96<@9F]@9BU08e[@96<@8aS08]J`8icP92408mk`9Nm`8a
S0Hmk`8aS08U:@03AS52448@008mk`92408U:@8icP@mk`A6<@@mk`@icP@mk`9JeP8aS09240@mk`9:
DP8mk`8e[@8mk`9S608]J`8U:@8e[@8mk`8icP9BU08mk`9W>@8Li`8icP9JeP8mk`8icP8e[@8mk`9J
eP8aS08icP9:DP92408]J`9240Hmk`8]J`8icP8e[A0mk`8aS08]J`8Li`Eoo`40005oo`000goo00D0
07ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2=Jd2CW<2>Lh2
?Nl248@2DY@2=Jd2AS42<H`2F]H2CW<2?Nl2E[D4=Jd2@Q02<H`2CW<2<H`2=Jd2>Lh2:DX2AS42>Lh2
G_L2AS42?Nl2F]H2?Nl2=Jd2:DX2BU82;F/2>Lh2AS42BU84=Jd2DY@4@Q027>L2<H`2=Jd4?Nl2AS42
E[D2DY@2=Jd2AS42<H`2;F/2>Lh2@Q02?Nl2G_L2<H`6?Nl2<H`29BT00dHa@Q124002?Nl2@Q029BT2
>Lh4?Nl4AS44?Nl4>Lh4?Nl2F]H2<H`2@Q04?Nl2BU82?Nl2=Jd2?Nl2HaP2;F/29BT2=Jd2?Nl2>Lh2
DY@2?Nl2IcT27>L2>Lh2F]H2?Nl2>Lh2=Jd2?Nl2F]H2<H`2>Lh2BU82@Q02;F/2@Q06?Nl2;F/2>Lh2
=Jd@?Nl2<H`2;F/27>L5Ool10001Ool0009oo`8000Aoo`8000Aoo`8000Eoo`03001oogoo009oo`8m
k`92408e[@A6<@8icP92408mk`92408icP@aS08mk`8icPI2408icP8mk`96<@9240@mk`8aS08e[@92
40Hmk`8icP8mk`92409BU0Hmk`92409:DP8]J`92408mk`9>L`A2408mk`96<@8e[@9:DP96<@9:DP8e
[@8mk`9240Pmk`9240Pmk`9240Dmk`8e[@8icPhmk`92408YBP8icPA6<@Pmk`8icP8Q209240@mk`A2
40@mk`9BU092409Nm`8U:@9240ANm`8YBP8aS08icP@mk`8]J`9240@mk`9240Pmk`A241@mk`9F]@92
40Eoo`40005oo`005Goo00<007ooOol00Woo0Sg_0T8@0SF]14Ha0SW>0T8@0Sg_0T8@0SW>136<0Sg_
0SW>1T8@0SW>0Sg_0THa0T8@13g_0S6<0SF]0T8@1Sg_0SW>0Sg_0T8@0U:D1Sg_0T8@0TYB0Re[0T8@
0Sg_0Tic148@0Sg_0THa0SF]0TYB0THa0TYB0SF]0Sg_0T8@23g_0T8@23g_0T8@1Cg_0SF]0SW>3Sg_
0T8@0RU:0SW>14Ha23g_0SW>0R480T8@13g_148@13g_0U:D0T8@0Ukg0RDY0T8@15kg0RU:0S6<0SW>
13g_0Re[0T8@13g_0T8@23g_148@53g_0UJe0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82
>Lh2AS42@Q02AS44?Nl4@Q02>Lh2:DX2CW<2?Nl2@Q02CW<2>Lh2<H`2>Lh6?Nl2=Jd2G_L2<H`2AS42
=Jd2@Q04?Nl2AS44@Q02CW<2@Q04BU82@Q02CW<:?Nl2>Lh2DY@2@Q02>Lh2AS44CW<2>Lh2E[D2>Lh@
?Nl2AS42BU85?Nl2>Lh2=Jd2?Nl4@Q02AS42BU86?Nl2:DX2>Lh4@Q0:?Nl2@Q04?Nl2@Q02:DX2?Nl2
F]H2=Jd2@Q02?Nl2=Jd2<H`2;F/2BU82=Jd2BU82DY@4?Nl4BU8@?Nl4@Q0B?Nl2@Q025:D2>Lh5Ool1
0001Ool001Eoo`03001oogoo009oo`9:DP8icP96<@924096<@@mk`A2408icP8YBP9>L`8mk`92409>
L`8icP8aS08icPHmk`8e[@9Nm`8aS096<@8e[@9240@mk`96<@A2409>L`9240A:DP92409>L`Xmk`8i
cP9BU092408icP96<@A>L`8icP9F]@8icQ0mk`96<@9:DPDmk`8icP8e[@8mk`A24096<@9:DPHmk`8Y
BP8icPA240Xmk`9240@mk`92408YBP8mk`9JeP8e[@92408mk`8e[@8aS08]J`9:DP8e[@9:DP9BU0@m
k`A:DQ0mk`A2418mk`92408DY@8icPEoo`40005oo`005Goo00<007ooOol00Woo0S6<148@0SW>0SF]
0THa0T8@0SF]0SW>0SF]0SW>0SF]148@0Sg_0SW>0SF]0U:D13W>0Sg_0SF]0THa0TYB0SW>0THa0Sg_
0THa0Sg_148@1SW>0Re[0T8@0Re[0S6<0U:D148@13g_0T8@0Sg_0RDY0S6<0U[F0RU:23g_0T8@0Sg_
0T8@0U:D23g_0T8@0SW>00=243g_?Nl00Sg_148@0Sg_0SF]0RDY1Sg_0THa0U:D0SF]0Sg_0SW>0RDY
0T8@13g_0T8@0Sg_148@13g_0T8@13g_0THa0Sg_0TYB0Sg_0Tic0SW>12U:0SW>0Tic1Sg_0T8@0Sg_
148@23g_0T8@13F]0T8@4Sg_0Re[0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`4@Q02>Lh2
=Jd2AS42@Q02=Jd2>Lh2=Jd2>Lh2=Jd4@Q02?Nl2>Lh2=Jd2DY@4>Lh2?Nl2=Jd2AS42BU82>Lh2AS42
?Nl2AS42?Nl4@Q06>Lh2;F/2@Q02;F/2<H`2DY@4@Q04?Nl2@Q02?Nl29BT2<H`2F]H2:DX8?Nl2@Q02
?Nl2@Q02DY@8?Nl2@Q02>Lh00d8@?Nlmk`02?Nl4@Q02?Nl2=Jd29BT6?Nl2AS42DY@2=Jd2?Nl2>Lh2
9BT2@Q04?Nl2@Q02?Nl4@Q04?Nl2@Q04?Nl2AS42?Nl2BU82?Nl2CW<2>Lh4:DX2>Lh2CW<6?Nl2@Q02
?Nl4@Q08?Nl2@Q04=Jd2@Q0B?Nl2;F/2@Q05Ool10001Ool001Eoo`03001oogoo009oo`8YBP8mk`9:
DP9>L`9kgP8mk`92408YBP9F]@96<@8Q209:DP9Nm`9BU09F]@9240A6<@8e[@9cW09>L`8e[@9F]@84
8@96<@8Q2092408U:@96<@I:DP9BU09:DP9W>@8mk`96<@92408YBP92408]J`A6<@8mk`92408]J`9>
L`8YBP8Q208aS09>L`8e[@9F]@8@Q096<@8aS092408U:@9240@mk`A>L`Dmk`8icP8e[@8mk`9:DP8]
J`9F]@9:DP8]J`Pmk`9:DP8e[@9240@mk`8aS09JeP8aS08Q209240Pmk`96<@9:DP8e[@92408e[@8i
cP92408e[@8]J`8mk`92408e[@92408HaP96<@8icP8YBPA2408mk`92408e[@9:DP92408Q208mk`92
40`mk`9>L`9BU08mk`Eoo`40005oo`005Goo0P000goo0RU:0Sg_0TYB0Tic0W_N0Sg_0T8@0RU:0UJe
0THa0R480TYB0Ukg0U:D0UJe0T8@14Ha0SF]0W>L0Tic0SF]0UJe0P@Q0THa0R480T8@0RDY0THa1TYB
0U:D0TYB0VLi0Sg_0THa0T8@0RU:0T8@0Re[14Ha0Sg_0T8@0Re[0Tic0RU:0R480S6<0Tic0SF]0UJe
0Q240THa0S6<0T8@0RDY0T8@13g_14ic1Cg_0SW>0SF]0Sg_0TYB0Re[0UJe0TYB0Re[23g_0TYB0SF]
0T8@13g_0S6<0U[F0S6<0R480T8@23g_0THa0TYB0SF]0T8@0SF]0SW>0T8@0SF]0Re[0Sg_0T8@0SF]
0T8@0QS60THa0SW>0RU:148@0Sg_0T8@0SF]0TYB0T8@0R480Sg_0T8@33g_0Tic0U:D0Sg_17oo0P00
0Goo000EOol00`00Oomoo`02Ool2CW<2>Lh2?Nl2BU828@P2>Lh4@Q02?Nl2=Jd2?Nl2BU82DY@2@Q02
?Nl2BU82=Jd4@Q02;F/2AS42BU82>Lh2BU82@Q02?Nl2@Q02>Lh2@Q0<?Nl2:DX4@Q04?Nl2BU82AS42
?Nl4AS42DY@2?Nl2<H`2BU82=Jd2;F/2@Q02?Nl2@Q02?Nl2IcT2>Lh2?Nl2@Q08?Nl00d8@?Nlmk`04
?Nl2@Q04?Nl2@Q02?Nl2@Q02BU82E[D4?Nl2@Q02:DX2@Q06?Nl4AS42?Nl2@Q04?Nl2AS42BU82?Nl4
=Jd2@Q02?Nl2AS42CW<2F]H2?Nl4BU82=Jd2BU82?Nl2AS44?Nl4@Q04?Nl2;F/2@Q04?Nl2@Q02;F/2
@Q0B?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9>L`8icP8mk`9:DP8Q208icPA2408mk`8e[@8m
k`9:DP9BU092408mk`9:DP8e[@A2408]J`96<@9:DP8icP9:DP92408mk`92408icP9240`mk`8YBPA2
40@mk`9:DP96<@8mk`A6<@9BU08mk`8aS09:DP8e[@8]J`92408mk`92408mk`9W>@8icP8mk`9240Pm
k`03@Q0mkcg_00@mk`9240@mk`92408mk`92409:DP9F]@@mk`92408YBP9240Hmk`A6<@8mk`9240@m
k`96<@9:DP8mk`@e[@92408mk`96<@9>L`9JeP8mk`A:DP8e[@9:DP8mk`96<@@mk`A240@mk`8]J`92
40@mk`92408]J`92418mk`Eoo`40005oo`005Goo00<007ooOol00Woo14Ha0T8@14YB0Sg_0SF]0Tic
0SW>0TYB13W>0RDY0Sg_0U:D0Sg_0U[F0T8@0Re[0T8@0UJe148@0R480Sg_0T8@14ic13g_0SW>0TYB
0T8@0TYB0T8@0Tic0SW>0Sg_0S6<23g_0S6<23g_0TYB0T8@0SW>0TYB0T8@13g_14YB0Tic2Sg_00<i
cSg_?Nl00Sg_0U:D13g_0TYB0SF]0T8@0U:D0THa0QS60T8@13g_0U[F0SW>0V<H0THa2Sg_0TYB0SF]
0Sg_0SW>0Sg_0T8@0Re[0T8@0Re[0UJe0RU:0UJe0S6<0THa0SF]0SW>0Sg_0SW>0RDY0T8@2Sg_0T8@
0U:D0Tic0Sg_0SW>0SF]53g_1Goo0@000Goo000EOol00`00Oomoo`02Ool4AS42@Q04BU82?Nl2=Jd2
CW<2>Lh2BU84>Lh29BT2?Nl2DY@2?Nl2F]H2@Q02;F/2@Q02E[D4@Q028@P2?Nl2@Q04CW<4?Nl2>Lh2
BU82@Q02BU82@Q02CW<2>Lh2?Nl2<H`8?Nl2<H`8?Nl2BU82@Q02>Lh2BU82@Q04?Nl4BU82CW<:?Nl0
0cW>?Nlmk`02?Nl2DY@4?Nl2BU82=Jd2@Q02DY@2AS426<H2@Q04?Nl2F]H2>Lh2HaP2AS4:?Nl2BU82
=Jd2?Nl2>Lh2?Nl2@Q02;F/2@Q02;F/2E[D2:DX2E[D2<H`2AS42=Jd2>Lh2?Nl2>Lh29BT2@Q0:?Nl2
@Q02DY@2CW<2?Nl2>Lh2=JdD?Nl5Ool10001Ool001Eoo`03001oogoo009oo`8U:@8e[@9240@icP9>
L`9:DP92408aS08e[@9>L`8mk`9240@mk`924096<@8mk`92408icP8U:@8e[@8mk`9:DP96<@92408i
cP8aS08icPA6<@A2408mk`8e[@8U:@@mk`92408icP92408mk`8aS08mk`92408icP8aS092409>L`8a
S092409:DP92408mk`92409>L`9:DP9Nm`8icP@mk`A6<@Dmk`9240Hmk`9240@e[@8Q208icP`mk`8]
J`9240@mk`9>L`8e[@8mk`92408mk`9F]@@mk`8icP8e[@8mk`8Q208e[@8YBP9BU08e[@8aS092408m
k`8icP8YBP9240Pmk`92408YBP8e[@9>L`9:DP8mk`9:DPhmk`A6<@8mk`Eoo`40005oo`005Goo00<0
07ooOol00Woo0RDY0SF]0T8@13W>0Tic0TYB0T8@0S6<0SF]0Tic0Sg_0T8@13g_0T8@0THa0Sg_0T8@
0SW>0RDY0SF]0Sg_0TYB0THa0T8@0SW>0S6<0SW>14Ha148@0Sg_0SF]0RDY13g_0T8@0SW>0T8@0Sg_
0S6<0Sg_0T8@0SW>0S6<0T8@0Tic0S6<0T8@0TYB0T8@0Sg_0T8@0Tic0TYB0Ukg0SW>13g_14Ha1Cg_
0T8@1Sg_0T8@13F]0R480SW>33g_0Re[0T8@13g_0Tic0SF]0Sg_0T8@0Sg_0UJe13g_0SW>0SF]0Sg_
0R480SF]0RU:0U:D0SF]0S6<0T8@0Sg_0SW>0RU:0T8@23g_0T8@0RU:0SF]0Tic0TYB0Sg_0TYB3Sg_
14Ha0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2AS44>Lh2=Jd4>Lh2F]H2>Lh2@Q02?Nl2
@Q02DY@2@Q02HaP2@Q027>L4?Nl2>Lh2Kg/2:DX2?Nl2BU84AS429BT2=Jd2@Q02AS42BU84<H`2@Q02
BU82F]H2>Lh4?Nl2@Q04?Nl2>Lh29BT2?Nl2CW<2@Q02CW<2JeX26<H2@Q02>Lh2@Q02?Nl2@Q026<H2
BU827>L2@Q04?Nl2AS42@Q000e:DBU9:DP02@Q02=Jd6?Nl2@Q02?Nl2CW<2DY@>?Nl2@Q0:?Nl2F]H2
:DX2?Nl2@Q02=Jd2AS42@Q02;F/2AS427>L2JeX2Ool27>L2IcT2?Nl6@Q02;F/2@Q08?Nl2@Q02>Lh2
@Q02CW<2=Jd2CW<2DY@>?Nl4AS42?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9BU096<@@icP8e
[@@icP9JeP8icP92408mk`92409BU092409S6092408Li`@mk`8icP9_N`8YBP8mk`9:DPA6<@8U:@8e
[@924096<@9:DP@aS092409:DP9JeP8icP@mk`9240@mk`8icP8U:@8mk`9>L`92409>L`9[FP8HaP92
408icP92408mk`92408HaP9:DP8Li`9240@mk`96<@924003DYA:DTYB0092408e[@Hmk`92408mk`9>
L`9BU0hmk`9240Xmk`9JeP8YBP8mk`92408e[@96<@92408]J`96<@8Li`9[FP9oo`8Li`9W>@8mk`I2
408]J`9240Pmk`92408icP92409>L`8e[@9>L`9BU0hmk`A6<@8mk`Eoo`40005oo`005Goo00<007oo
Ool00Woo0SF]0THa0TYB0THa0TYB0S6<13W>0T8@0S6<0SF]0THa0Re[0THa1T8@1Sg_0THa0U[F0Sg_
0TYB13g_0U:D0S6<0THa1Sg_0T8@0Sg_0Re[0Sg_148@0Sg_0T8@1Sg_0Tic0U[F13g_0T8@0Sg_0SW>
0U:D0T8@0SW>0T8@0Sg_0U[F0R480TYB0T8@3cg_0T8@13g_0THa0TYB23g_0T8@23g_0T8@33g_0T8@
0TYB0RU:0SW>0U:D0Sg_0T8@0Sg_0T8@0Sg_0RDY0UJe0SW>0T8@0SW>0SF]0Sg_0U:D1Sg_0T8@13g_
1SW>0R480T8@0RU:0T8@4Sg_1Goo0@000Goo000EOol20003Ool2=Jd2AS42BU82AS42BU82<H`4>Lh2
@Q02<H`2=Jd2AS42;F/2AS46@Q06?Nl2AS42F]H2?Nl2BU84?Nl2DY@2<H`2AS46?Nl2@Q02?Nl2;F/2
?Nl4@Q02?Nl2@Q06?Nl2CW<2F]H4?Nl2@Q02?Nl2>Lh2DY@2@Q02>Lh2@Q02?Nl2F]H28@P2BU82@Q0?
?Nl2@Q04?Nl2AS42BU88?Nl2@Q08?Nl2@Q0<?Nl2@Q02BU82:DX2>Lh2DY@2?Nl2@Q02?Nl2@Q02?Nl2
9BT2E[D2>Lh2@Q02>Lh2=Jd2?Nl2DY@6?Nl2@Q04?Nl6>Lh28@P2@Q02:DX2@Q0B?Nl4Ool20001Ool0
01Eoo`03001oogoo009oo`9_N`8Li`8e[@9BU08YBPA>L`96<@Pmk`9oo`@mk`8aS08mk`9>L`A:DP8Y
BP8]J`9>L`8icP92408e[@8<H`8aS09:DP8mk`8aS09JeP8YBP9JeP@icP8e[@8Li`96<@8e[@96<@8m
k`92409:DP8DY@8aS092408e[@9F]@92408mk`92408mk`8e[@8]J`8Li`9_N`8Q209:DPHmk`924003
BU96<DHa008mk`92408Q2092409>L`8]J`8mk`92408aS096<@9F]@8]J`8e[@92408mk`92408HaP92
40Hmk`92408aS09:DP8icP8]J`8e[@9:DP8e[@A24096<@9>L`9:DP96<@8e[@8U:@92408aS09240Pm
k`8e[@9>L`96<@8mk`8YBP9:DP9240A6<@8mk`9>L``mk`924096<@Eoo`40005oo`005Goo00<007oo
Ool00Woo0Vmk0QcW0SF]0U:D0RU:14ic0THa23g_0Woo13g_0S6<0Sg_0Tic14YB0RU:0Re[0Tic0SW>
0T8@0SF]0PaS0S6<0TYB0Sg_0S6<0U[F0RU:0U[F13W>0SF]0QcW0THa0SF]0THa0Sg_0T8@0TYB0QBU
0S6<0T8@0SF]0UJe0T8@0Sg_0T8@0Sg_0SF]0Re[0QcW0Vmk0R480TYB1Sg_0T8@00=:DTHaAS400Sg_
0T8@0R480T8@0Tic0Re[0Sg_0T8@0S6<0THa0UJe0Re[0SF]0T8@0Sg_0T8@0QS60T8@1Sg_0T8@0S6<
0TYB0SW>0Re[0SF]0TYB0SF]148@0THa0Tic0TYB0THa0SF]0RDY0T8@0S6<0T8@23g_0SF]0Tic0THa
0Sg_0RU:0TYB0T8@14Ha0Sg_0Tic33g_0T8@0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2:DX2
@Q02;F/2<H`2=Jd2?Nl2BU82=Jd2?Nl2@Q02BU82>Lh2?Nl2<H`2?Nl2DY@2<H`2=Jd6?Nl4;F/2<H`2
;F/4>Lh2CW<2<H`2?Nl2AS42>Lh2E[D2<H`2=Jd2AS42>Lh2AS42?Nl2@Q06?Nl2>Lh2JeX2<H`2BU82
@Q02;F/2?Nl2<H`2AS42?Nl4<H`2@Q02AS42E[D29BT2@Q04?Nl2E[D00cW>?Nlmk`02?Nl4=Jd2@Q02
=Jd2>Lh2?Nl2=Jd2<H`2BU84?Nl4@Q04?Nl2@Q0:?Nl2@Q04?Nl2=Jd2E[D2<H`2?Nl2;F/2=Jd2?Nl2
BU82<H`2?Nl2BU82Kg/2@Q027>L2@Q06?Nl2@Q029BT2DY@2AS44?Nl2@Q02CW<2<H`2CW<2AS42@Q0<
?Nl2=Jd2BU85Ool10001Ool001Eoo`03001oogoo009oo`8YBP92408]J`8aS08e[@8mk`9:DP8e[@8m
k`92409:DP8icP8mk`8aS08mk`9BU08aS08e[@Hmk`@]J`8aS08]J`@icP9>L`8aS08mk`96<@8icP9F
]@8aS08e[@96<@8icP96<@8mk`9240Hmk`8icP9[FP8aS09:DP92408]J`8mk`8aS096<@8mk`@aS092
4096<@9F]@8U:@9240@mk`9F]@03>Lhmkcg_008mk`@e[@92408e[@8icP8mk`8e[@8aS09:DP@mk`A2
40@mk`9240Xmk`9240@mk`8e[@9F]@8aS08mk`8]J`8e[@8mk`9:DP8aS08mk`9:DP9_N`92408Li`92
40Hmk`92408U:@9BU096<@@mk`92409>L`8aS09>L`96<@9240`mk`8e[@9:DPEoo`40005oo`005Goo
00<007ooOol00Woo0SW>0Re[0SF]0U:D0Tic14Ha0T8@0TYB0Re[0Tic0S6<0T8@0Sg_13F]0S6<0SF]
0THa0Sg_0THa0Sg_0TYB0Tic1SW>0T8@0TYB0Sg_0TYB0Sg_0RDY0UJe0T8@0Sg_0T8@0PaS2Sg_0T8@
0QBU0Vmk0QcW0S6<0T8@0RU:0SW>13g_0SW>0Re[0TYB0Q240Sg_0U[F0SW>13g_0THa1Cg_14YB0SF]
0TYB0Sg_0T8@0Re[0T8@13g_0U:D0RDY0SW>5Sg_0U:D0T8@0U:D0QBU0Tic0U[F0SF]0Sg_0U:D0TYB
136<0SF]0T8@2Sg_0SW>0SF]0Re[0U:D0Tic0RDY0THa0V]J0RU:0SF]0TYB3Sg_0Tic1Goo0@000Goo
000EOol00`00Oomoo`02Ool2>Lh2;F/2=Jd2DY@2CW<4AS42@Q02BU82;F/2CW<2<H`2@Q02?Nl4=Jd2
<H`2=Jd2AS42?Nl2AS42?Nl2BU82CW<6>Lh2@Q02BU82?Nl2BU82?Nl29BT2E[D2@Q02?Nl2@Q0236<:
?Nl2@Q025:D2Kg/27>L2<H`2@Q02:DX2>Lh4?Nl2>Lh2;F/2BU8248@2?Nl2F]H2>Lh4?Nl2AS45?Nl4
BU82=Jd2BU82?Nl2@Q02;F/2@Q04?Nl2DY@29BT2>LhF?Nl2DY@2@Q02DY@25:D2CW<2F]H2=Jd2?Nl2
DY@2BU84<H`2=Jd2@Q0:?Nl2>Lh2=Jd2;F/2DY@2CW<29BT2AS42JeX2:DX2=Jd2BU8>?Nl2CW<5Ool1
0001Ool001Eoo`03001oogoo009oo`96<@92409:DP96<@8mk`8aS09>L`8mk`8aS08mk`92408aS08H
aP9:DP96<@92409>L`9240A:DP8mk`8aS08mk`9>L`@icP9:DP8]J`96<@92408aS092409F]@8mk`8e
[@8icP8mk`96<@8mk`9:DP96<@Pmk`9:DP8icP92408e[@9F]@9:DP8mk`92408mk`8aS09BU08icP9:
DP9240@mk`92408U:@=2408mk`@e[@Hmk`8e[@8icPPmk`92408]J`92408mk`96<@8e[@9240hmk`@]
J`9JeP8YBPXmk`9>L`9JeP9:DP92408]J`A240@mk`9:DP8e[@92409BU09:DP92408mk`96<@Hmk`92
40Xmk`9:DP8e[@Eoo`40005oo`005Goo00<007ooOol00Woo0THa0T8@0TYB0THa0Sg_0S6<0Tic0Sg_
0S6<0Sg_0T8@0S6<0QS60TYB0THa0T8@0Tic0T8@14YB0Sg_0S6<0Sg_0Tic13W>0TYB0Re[0THa0T8@
0S6<0T8@0UJe0Sg_0SF]0SW>0Sg_0THa0Sg_0TYB0THa23g_0TYB0SW>0T8@0SF]0UJe0TYB0Sg_0T8@
0Sg_0S6<0U:D0SW>0TYB0T8@13g_0T8@0RDY0d8@0Sg_13F]1Sg_0SF]0SW>23g_0T8@0Re[0T8@0Sg_
0THa0SF]0T8@3Sg_12e[0U[F0RU:2Sg_0Tic0U[F0TYB0T8@0Re[148@13g_0TYB0SF]0T8@0U:D0TYB
0T8@0Sg_0THa1Sg_0T8@2Sg_0TYB0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82?Nl2;F/2
DY@2@Q02?Nl4=Jd2?Nl2;F/2BU82CW<2=Jd2BU82=Jd2;F/2@Q02?Nl2@Q02=Jd2DY@2AS42>Lh2?Nl2
>Lh2=Jd4DY@21242CW<2@Q02>Lh2@Q02BU82AS42:DX2@Q02AS44?Nl2<H`2>Lh2@Q02CW<2E[D2>Lh2
@Q02=Jd2F]H2:DX2?Nl4=Jd2@Q02>Lh2<H`2=Jd2E[D2;F/2?Nl2AS42<H`2DY@7?Nl2AS42F]H4?Nl2
E[D2AS42=Jd2AS42HaP2AS42?Nl2@Q06?Nl2BU82AS42@Q02;F/2@Q04?Nl2CW<2DY@2@Q02;F/2?Nl2
@Q02?Nl2@Q02;F/2CW<2=Jd2@Q02AS42>Lh2?Nl2@Q04=Jd6?Nl2@Q02>Lh2=Jd2:DX2=Jd2F]H2<H`2
F]H2AS42?Nl2=Jd2>Lh4@Q02>Lh2?Nl2=Jd2>Lh5Ool10001Ool001Eoo`8000=oo`9:DP8mk`8]J`9B
U092408mk`@e[@8mk`8]J`9:DP9>L`8e[@9:DP8e[@8]J`92408mk`92408e[@9BU096<@8icP8mk`8i
cP8e[@ABU0848@9>L`92408icP92409:DP96<@8YBP924096<@@mk`8aS08icP92409>L`9F]@8icP92
408e[@9JeP8YBP8mk`@e[@92408icP8aS08e[@9F]@8]J`8mk`96<@8aS09BU0Lmk`96<@9JeP@mk`9F
]@96<@8e[@96<@9S6096<@8mk`9240Hmk`9:DP96<@92408]J`9240@mk`9>L`9BU092408]J`8mk`92
408mk`92408]J`9>L`8e[@924096<@8icP8mk`9240@e[@Hmk`92408icP8e[@8YBP8e[@9JeP8aS09J
eP96<@8mk`8e[@8icPA2408icP8mk`8e[@8icPAoo`80005oo`005Goo00<007ooOol00Woo0SF]0U:D
0T8@0RDY0Tic0Sg_0THa0UJe0THa0T8@0SF]0Re[0RU:0SW>0THa0UJe0Tic0S6<0Sg_0VLi0SF]0TYB
0T8@0Sg_0SF]0THa0UJe14Ha0SF]0Sg_248@0Re[0Sg_0SW>13g_0SW>0TYB13g_0U:D0SW>0Re[0THa
0RDY0U[F0UJe14YB0SF]0T8@0TYB0S6<0Sg_0T8@0THa0Sg_0T8@0Sg_00<icSg_?Nl00SW>0UJe0SW>
0Sg_0T8@12U:0TYB0SF]0TYB0Sg_0S6<0T8@23g_0SW>0TYB0T8@0SW>23g_0SF]0TYB13g_0THa0TYB
0Sg_0THa0TYB0SW>0Tic0S6<0Tic0Sg_1TYB13g_0Re[148@0SW>0TYB0Sg_0THa0T8@0Sg_0T8@13g_
0T8@13g_0Re[0T8@13g_1Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd2DY@2@Q029BT2CW<2?Nl2
AS42E[D2AS42@Q02=Jd2;F/2:DX2>Lh2AS42E[D2CW<2<H`2?Nl2IcT2=Jd2BU82@Q02?Nl2=Jd2AS42
E[D4AS42=Jd2?Nl8@Q02;F/2?Nl2>Lh4?Nl2>Lh2BU84?Nl2DY@2>Lh2;F/2AS429BT2F]H2E[D4BU82
=Jd2@Q02BU82<H`2?Nl2@Q02AS42?Nl2@Q02?Nl00cW>?Nlmk`02>Lh2E[D2>Lh2?Nl2@Q04:DX2BU82
=Jd2BU82?Nl2<H`2@Q08?Nl2>Lh2BU82@Q02>Lh8?Nl2=Jd2BU84?Nl2AS42BU82?Nl2AS42BU82>Lh2
CW<2<H`2CW<2?Nl6BU84?Nl2;F/4@Q02>Lh2BU82?Nl2AS42@Q02?Nl2@Q04?Nl2@Q04?Nl2;F/2@Q04
?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9240@]J`9JeP92408]J`9F]@8aS08mk`9JeP8aS08m
k`8icP9_N`9>L`92408e[@8Li`96<@8Li`96<@9:DP8aS08]J`8aS09F]@8YBP8mk`8U:@92408mk`8a
S08U:@8e[@8mk`9BU08]J`92408aS092408e[@8aS092408mk`9F]@8icP96<@8YBP8aS088@P92409:
DP8e[@9[FP8icP9>L`8mk`8aS08mk`8@Q09F]@8Q20924003>Lhmkcg_009>L`8icP9JeP8mk`8e[@8i
cP9F]@8Q2096<@8Q208aS08Q208mk`A6<@@mk`9:DP@mk`8e[@9240Hmk`8e[@9:DPPmk`8aS08Q208e
[@8U:@A2408U:@8icP8Q208icP@mk`9F]@8aS092408aS09Nm`Hmk`A6<@8YBP92409:DP8Q209:DP9F
]@96<@8e[@92408mk`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@12e[0U[F0T8@0Re[0UJe0S6<
0Sg_0U[F0S6<0Sg_0SW>0Vmk0Tic0T8@0SF]0QcW0THa0QcW0THa0TYB0S6<0Re[0S6<0UJe0RU:0Sg_
0RDY0T8@0Sg_0S6<0RDY0SF]0Sg_0U:D0Re[0T8@0S6<0T8@0SF]0S6<0T8@0Sg_0UJe0SW>0THa0RU:
0S6<0PQ20T8@0TYB0SF]0V]J0SW>0Tic0Sg_0S6<0Sg_0Q240UJe0R480T8@00<icSg_?Nl00Tic0SW>
0U[F0Sg_0SF]0SW>0UJe0R480THa0R480S6<0R480Sg_14Ha13g_0TYB13g_0SF]0T8@1Sg_0SF]0TYB
23g_0S6<0R480SF]0RDY148@0RDY0SW>0R480SW>13g_0UJe0S6<0T8@0S6<0Ukg1Sg_14Ha0RU:0T8@
0TYB0R480TYB0UJe0THa0SF]0T8@0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2?Nl2BU82@Q02
>Lh2?Nl2@Q06=Jd2?Nl2@Q02CW<2DY@2=Jd2?Nl2=Jd2BU82JeX8?Nl2BU82AS42CW<2@Q06BU82>Lh2
AS44?Nl2=Jd2?Nl2:DX2CW<28@P4@Q02;F/4?Nl2@Q06?Nl2G_L2?Nl2BU82>Lh4@Q02?Nl2BU84?Nl2
F]H2AS42@Q02;F/4?Nl00eJe<H`aS002=Jd2;F/2?Nl2@Q02G_L29BT26<H2@Q02?Nl2@Q029BT2=Jd2
F]H2>Lh6?Nl4AS4H?Nl2>Lh2DY@2BU82;F/2E[D4;F/2@Q02DY@8?Nl2=Jd2BU86?Nl2@Q02?Nl2>Lh2
?Nl2BU84?Nl2@Q04AS44?Nl2@Q02?Nl5Ool10001Ool001Eoo`03001oogoo009oo`8mk`9:DP92408i
cP8mk`9240He[@8mk`92409>L`9BU08e[@8mk`8e[@9:DP9[FPPmk`9:DP96<@9>L`9240I:DP8icP96
<@@mk`8e[@8mk`8YBP9>L`8Q20A2408]J`@mk`9240Hmk`9Nm`8mk`9:DP8icPA2408mk`9:DP@mk`9J
eP96<@92408]J`@mk`03E[DaS36<008e[@8]J`8mk`92409Nm`8U:@8HaP92408mk`92408U:@8e[@9J
eP8icPHmk`A6<APmk`8icP9BU09:DP8]J`9F]@@]J`92409BU0Pmk`8e[@9:DPHmk`92408mk`8icP8m
k`9:DP@mk`9240A6<@@mk`92408mk`Eoo`40005oo`005Goo00<007ooOol00Woo0Sg_0U:D0UJe0U:D
0T8@0SW>0SF]0U:D0SW>0T8@0U:D0T8@0QS614ic0T8@13g_0T8@0Re[0Tic0THa0T8@0SF]0SW>0Sg_
0UJe148@0TYB15Je0THa0TYB0SW>0U:D0Sg_0SF]0Re[0T8@0Sg_0SF]0THa0SW>0T8@0THa0TYB13F]
0Re[0SW>0T8@1Sg_0UJe0U:D0SF]0T8@13g_0TYB0T8@00=:DUJeE[D00T8@0TYB0Sg_0UJe0S6<0U:D
0T8@0U[F0Sg_0Re[0THa0TYB14Ha0TYB13g_0T8@0Re[0THa0U[F0SW>0V<H0Sg_148@13g_14Ha13g_
13F]0T8@0THa0TYB0T8@0Re[0T8@43g_0U:D0RU:0THa0QcW0T8@3Sg_0TYB0SF]0Sg_1Goo0@000Goo
00000goo0000000300000goo000000020003Ool20005Ool00`00Oomoo`02Ool2?Nl2DY@2E[D2DY@2
@Q02>Lh2=Jd2DY@2>Lh2@Q02DY@2@Q026<H4CW<2@Q04?Nl2@Q02;F/2CW<2AS42@Q02=Jd2>Lh2?Nl2
E[D4@Q02BU84E[D2AS42BU82>Lh2DY@2?Nl2=Jd2;F/2@Q02?Nl2=Jd2AS42>Lh2@Q02AS42BU84=Jd2
;F/2>Lh2@Q06?Nl2E[D2DY@2=Jd2@Q04?Nl2BU82@Q000dYBE[EF]@02@Q02BU82?Nl2E[D2<H`2DY@2
@Q02F]H2?Nl2;F/2AS42BU84AS42BU84?Nl2@Q02;F/2AS42F]H2>Lh2HaP2?Nl4@Q04?Nl4AS44?Nl4
=Jd2@Q02AS42BU82@Q02;F/2@Q0@?Nl2DY@2:DX2AS427>L2@Q0>?Nl2BU82=Jd2?Nl5Ool10001Ool0
00=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<007ooOol00Woo0SF]0Sg_0SW>0RU:0TYB
0Sg_0T8@0SW>0THa0TYB0SW>0S6<0THa0Sg_0TYB0UJe0U[F0SW>0T8@0Ukg0SW>136<0Sg_0U:D0Sg_
0SW>1Sg_0SW>0THa0S6<0RU:0S6<0THa0QS60RDY0UJe0Sg_0SF]0T8@0THa13F]0SW>0R480T8@0UJe
0SW>0U[F0Sg_0S6<0Sg_0SW>0T8@0Sg_0T8@2Sg_00=6<Cg_?Nl00UJe0Sg_0SF]0Sg_0Tic0Ukg0SW>
2Sg_0TYB13F]1Sg_0SW>0TYB0T8@0THa13g_13F]13g_0SF]0Sg_0TYB13g_13F]0T8@0Re[0THa0T8@
13g_14Ha23g_0T8@0Sg_0T8@0Sg_0T8@4Sg_0T8@0Sg_1Goo0@000Goo0003Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool01000Oomoo`0017oo0P000goo0SF]0Sg_0SW>0RU:0TYB0Sg_0T8@0SW>0THa0TYB
0SW>0S6<0THa0Sg_0TYB0UJe0U[F0SW>0T8@0Ukg0SW>136<0Sg_0U:D0Sg_0SW>1Sg_0SW>0THa0S6<
0RU:0S6<0THa0QS60RDY0UJe0Sg_0SF]0T8@0THa13F]0SW>0R480T8@0UJe0SW>0U[F0Sg_0S6<0Sg_
0SW>0T8@0Sg_0T8@2Sg_00=6<Cg_?Nl00UJe0Sg_0SF]0Sg_0Tic0Ukg0SW>2Sg_0TYB13F]1Sg_0SW>
0TYB0T8@0THa13g_13F]13g_0SF]0Sg_0TYB13g_13F]0T8@0Re[0THa0T8@13g_14Ha23g_0T8@0Sg_
0T8@0Sg_0T8@4Sg_0T8@0Sg_17oo0P000Goo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo
00<007ooOol00Woo00<007ooOol00Woo0Tic0QcW0RDY0T8@0Re[0T8@0TYB0SF]0TYB0SW>0Sg_0UJe
0Tic0Re[0SF]0U[F0Sg_0SW>0T8@0THa0Tic0THa0T8@0Sg_0RDY0SW>15[F13W>0U[F0T8@0TYB0T8@
0Sg_0U[F0T8@0Sg_0S6<0T8@0Sg_0TYB14Ha0TYB1T8@0Re[0SW>0SF]0RDY0Sg_0T8@0V]J0P000TYB
0SW>23g_0U:D00<YBSF]=Jd00Re[0T8@0UJe0RU:0U[F0UJe0U[F0Tic0THa0U:D0Sg_0T8@0RU:14YB
2Sg_14Ha13g_0THa0TYB13g_148@1Sg_0THa0TYB0T8@0Re[0Ukg0W_N0SF]0UJe0T8@0Tic0Sg_0THa
0SF]0THa0R480Re[0T8@0Sg_0THa0Tic43g_0SF]0T8@1Goo0@000Goo0003Ool01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9>L`8Li`8U:@92408]J`92409:
DP8e[@9:DP8icP8mk`9F]@9>L`8]J`8e[@9JeP8mk`8icP924096<@9>L`96<@92408mk`8U:@8icPAJ
eP@icP9JeP92409:DP92408mk`9JeP92408mk`8aS092408mk`9:DPA6<@9:DPI2408]J`8icP8e[@8U
:@8mk`92409[FP80009:DP8icPPmk`9BU003:DXe[CF]008]J`92409F]@8YBP9JeP9F]@9JeP9>L`96
<@9BU08mk`92408YBPA:DPXmk`A6<@@mk`96<@9:DP@mk`A240Hmk`96<@9:DP92408]J`9Nm`9kgP8e
[@9F]@92409>L`8mk`96<@8e[@96<@8Q208]J`92408mk`96<@9>La0mk`8e[@9240Eoo`40005oo`00
0Woo0P0017oo0P0017oo0P001Goo00<007ooOol00Woo0SW>0THa0TYB0SW>0Tic0Sg_0SW>0Tic0S6<
0TYB0SW>0S6<0SW>0THa0SW>0SF]0U:D0T8@0SW>0SF]0S6<0SW>0Sg_0SF]0Re[0TYB0Sg_0S6<148@
0SW>0T8@15[F148@14Ha1Sg_0SF]0RU:0TYB0SW>0T8@0Re[13g_0SF]0Sg_0UJe0Tic13g_1THa23g_
0T8@00<YBTHaAS4013F]13g_0RU:0U[F0UJe0Sg_14Ha13g_0U:D3Sg_0SF]0Tic0THa0Sg_0V<H23g_
0THa0TYB2Sg_0SF]0TYB0Sg_0T8@0RU:0U[F1Sg_0T8@0Sg_1T8@14Ha5Sg_1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2>Lh2AS42BU82>Lh2CW<2?Nl2>Lh2CW<2<H`2BU82>Lh2<H`2>Lh2AS42>Lh2=Jd2
DY@2@Q02>Lh2=Jd2<H`2>Lh2?Nl2=Jd2;F/2BU82?Nl2<H`4@Q02>Lh2@Q04F]H4@Q04AS46?Nl2=Jd2
:DX2BU82>Lh2@Q02;F/4?Nl2=Jd2?Nl2E[D2CW<4?Nl6AS48?Nl2@Q000bU:AS56<@04=Jd4?Nl2:DX2
F]H2E[D2?Nl4AS44?Nl2DY@>?Nl2=Jd2CW<2AS42?Nl2HaP8?Nl2AS42BU8:?Nl2=Jd2BU82?Nl2@Q02
:DX2F]H6?Nl2@Q02?Nl6@Q04AS4F?Nl5Ool10001Ool001Eoo`03001oogoo009oo`9>L`@mk`92408Y
BP9>L`8icP9:DP8mk`8e[@8mk`92409F]@8icP8mk`96<@9:DP96<@8mk`8icP8e[@92408icP9BU09N
m`8icP8]J`9240Hmk`92408mk`8aS09>L`8mk`8aS08mk`8]J`92408mk`8e[@8]J`8icPI2409>L`9:
DP96<@9JeP8mk`8e[@A2408aS08U:@96<@Pmk`924003DYAJeU[F0092409Nm`8]J`9JeP8icP9JeP8i
cP@mk`92409JeP@mk`A6<@Xmk`8icP9BU096<@92408icPHmk`92408mk`8YBP9240A6<@8mk`92408i
cP8YBP9>L`8mk`96<@9Nm`8e[@9240@mk`92408mk`8aS08]J`8icP8]J`8e[A8mk`96<@Eoo`40005o
o`005Goo00<007ooOol00Woo0Tic13g_0T8@0RU:0Tic0SW>0TYB0Sg_0SF]0Sg_0T8@0UJe0SW>0Sg_
0THa0TYB0THa0Sg_0SW>0SF]0T8@0SW>0U:D0Ukg0SW>0Re[0T8@1Sg_0T8@0Sg_0S6<0Tic0Sg_0S6<
0Sg_0Re[0T8@0Sg_0SF]0Re[0SW>1T8@0Tic0TYB0THa0U[F0Sg_0SF]148@0S6<0RDY0THa23g_0T8@
00=BU5[FF]H00T8@0Ukg0Re[0U[F0SW>0U[F0SW>13g_0T8@0U[F13g_14Ha2Sg_0SW>0U:D0THa0T8@
0SW>1Sg_0T8@0Sg_0RU:0T8@14Ha0Sg_0T8@0SW>0RU:0Tic0Sg_0THa0Ukg0SF]0T8@13g_0T8@0Sg_
0S6<0Re[0SW>0Re[0SF]4Sg_0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2?Nl2>Lh2@Q02?Nl2
=Jd2>Lh2AS42;F/2@Q02AS42@Q02>Lh2<H`4@Q02AS42>Lh4?Nl2@Q028@P2<H`2CW<2@Q02?Nl2DY@2
E[D2@Q02?Nl2@Q02=Jd2CW<2>Lh2;F/2?Nl2>Lh2AS44@Q06?Nl2:DX2HaP2>Lh2;F/29BT2<H`2?Nl2
BU82AS44<H`2CW<2;F/2:DX2@Q08?Nl2@Q02=Jd00cW>AS56<@02F]H29BT27>L2DY@2AS48?Nl2E[D2
>Lh6?Nl2>Lh:?Nl2>Lh2;F/2?Nl2;F/2CW<4?Nl2@Q027>L2E[D2AS42<H`8?Nl2BU82E[D2?Nl2AS42
BU82>Lh28@P2@Q02=Jd2@Q02<H`2DY@2=Jd8@Q0@?Nl2@Q02;F/5Ool10001Ool001Eoo`03001oogoo
009oo`8mk`8icP92408mk`8e[@8icP96<@8]J`924096<@92408icP8aS0A24096<@8icP@mk`92408Q
208aS09>L`92408mk`9BU09F]@92408mk`92408e[@9>L`8icP8]J`8mk`8icP96<@A240Hmk`8YBP9S
608icP8]J`8U:@8aS08mk`9:DP96<@@aS09>L`8]J`8YBP9240Pmk`92408e[@03>Li6<DHa009JeP8U
:@8Li`9BU096<@Pmk`9F]@8icPHmk`8icPXmk`8icP8]J`8mk`8]J`9>L`@mk`92408Li`9F]@96<@8a
S0Pmk`9:DP9F]@8mk`96<@9:DP8icP8Q2092408e[@92408aS09BU08e[@Q2410mk`92408]J`Eoo`40
005oo`005Goo00<007ooOol00Woo0TYB0S6<0T8@0U:D0S6<13W>0Sg_0T8@0Re[0SF]0SW>0T8@0SW>
0S6<1THa148@0SW>0T8@0QcW0T8@0Sg_136<1Sg_14YB0SW>0S6<148@0Tic0SF]0UJe0T8@13g_0THa
0RDY0T8@0Sg_0SF]0Tic0Sg_0R48136<13W>0W>L0S6<0Tic2Sg_0U:D00=:DSg_?Nl00T8@0QcW0Sg_
0RDY0Re[0T8@13g_0T8@0RDY0SW>0THa0Tic0THa0U[F0THa13g_0T8@13g_148@13F]0T8@13g_0Tic
0SF]0S6<0TYB1Sg_0U[F0Re[0UJe0R480SW>0RU:0Vmk0THa0Sg_0T8@0Re[0Ukg0SF]0Ukg13F]53g_
0SF]0SW>1Goo0@000Goo000EOol20003Ool2BU82<H`2@Q02DY@2<H`4>Lh2?Nl2@Q02;F/2=Jd2>Lh2
@Q02>Lh2<H`6AS44@Q02>Lh2@Q027>L2@Q02?Nl4<H`6?Nl4BU82>Lh2<H`4@Q02CW<2=Jd2E[D2@Q04
?Nl2AS429BT2@Q02?Nl2=Jd2CW<2?Nl28@P4<H`4>Lh2Li`2<H`2CW<:?Nl2DY@00dYB?Nlmk`02@Q02
7>L2?Nl29BT2;F/2@Q04?Nl2@Q029BT2>Lh2AS42CW<2AS42F]H2AS44?Nl2@Q04?Nl4@Q04=Jd2@Q04
?Nl2CW<2=Jd2<H`2BU86?Nl2F]H2;F/2E[D28@P2>Lh2:DX2Kg/2AS42?Nl2@Q02;F/2G_L2=Jd2G_L4
=JdD?Nl2=Jd2>Lh4Ool20001Ool001Eoo`03001oogoo009oo`I2408aS09JeP96<@8icP92409BU08e
[@8mk`8e[@8icP8mk`9240@mk`8e[@9BU08e[@A6<@92408aS08]J`96<@9BU09>L`8mk`92408aS08e
[@8U:@Pmk`8]J`8e[@9Nm`9BU092408mk`96<@8]J`96<@@mk`8aS096<@9:DPA2408mk`9>L`96<@A2
40Pmk`924003=Jd]Jbe[008icP92409:DPA240Xmk`9240A6<@8mk`8icP9:DP9>L`9BU08Q209240Pm
k`92408e[@9:DP8mk`92408]J`9240@mk`9JeP96<@8e[@@]J`8e[@9240Hmk`92408aS09JeP@mk`92
408e[@8mk`9BU1@mk`9240Eoo`40005oo`005Goo00<007ooOol00Woo1T8@0S6<0U[F0THa0SW>0T8@
0U:D0SF]0Sg_0SF]0SW>0Sg_0T8@13g_0SF]0U:D0SF]14Ha0T8@0S6<0Re[0THa0U:D0Tic0Sg_0T8@
0S6<0SF]0RDY23g_0Re[0SF]0Ukg0U:D0T8@0Sg_0THa0Re[0THa13g_0S6<0THa0TYB148@0Sg_0Tic
0THa148@23g_0T8@00<e[Be[;F/00SW>0T8@0TYB148@2Sg_0T8@14Ha0Sg_0SW>0TYB0Tic0U:D0R48
0T8@23g_0T8@0SF]0TYB0Sg_0T8@0Re[0T8@13g_0U[F0THa0SF]12e[0SF]0T8@1Sg_0T8@0S6<0U[F
13g_0T8@0SF]0Sg_0U:D53g_0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool20004Ool20002Ool2
0002Ool28@P26<H2<H`2Ool20002HaP20004Ool2F]H2AS4236<2;F/2:DX2AS42>Lh2Li`2BU82;F/2
<H`4BU820002Ool2@Q02?Nl2JeX2?Nl2DY@2BU82@Q02G_L236<2G_L4<H`2;F/2E[D2@Q02=Jd2BU82
JeX2>Lh2Ool20002>Lh2@Q02:DX2HaP4=Jd2?Nl4BU820002Ool00cW>BU9:DP06=Jd2>Lh2=Jd6?Nl4
CW<2BU82<H`2CW<2AS42DY@2@Q029BT4@Q02>Lh2@Q02?Nl2@Q02=Jd2?Nl2BU82=Jd2?Nl2@Q02CW<4
?Nl2BU84AS42DY@2CW<2IcT2JeX28@P2DY@6?Nl2@Q02AS42>Lh2DY@2AS42?Nl2BU82<H`2@Q06?Nl2
AS42=Jd2@Q02?Nl2AS420002F]H5Ool10001Ool001Eoo`03001oogoo009oo`8000Aoo`80009oo`80
009oo`8Q208HaP8aS09oo`80009S608000Aoo`9JeP96<@8<H`8]J`8YBP96<@8icP9cW09:DP8]J`8a
S0A:DP80009oo`92408mk`9[FP8mk`9BU09:DP92409Nm`8<H`9Nm`@aS08]J`9F]@92408e[@9:DP9[
FP8icP9oo`80008icP92408YBP9S60@e[@8mk`A:DP80009oo`03>Li:DTYB00He[@8icP8e[@Hmk`A>
L`9:DP8aS09>L`96<@9BU092408U:@A2408icP92408mk`92408e[@8mk`9:DP8e[@8mk`92409>L`@m
k`9:DPA6<@9BU09>L`9W>@9[FP8Q209BU0Hmk`924096<@8icP9BU096<@8mk`9:DP8aS09240Hmk`96
<@8e[@92408mk`96<@80009JePEoo`40005oo`005Goo00<007ooOol017oo0P000Q240Woo0RU:0VLi
0P000TYB0SF]0Sg_0PQ20W_N0SW>0SF]0P000SW>0Sg_148@0Tic0T8@13W>0RU:0S6<0UJe13g_0TYB
0V]J0P00148@0SW>1Sg_148@0Re[0Sg_0SW>0Sg_0T8@0Sg_13F]0Re[0THa0SW>0QS60UJe13W>0T8@
0Sg_0T8@0Sg_0T8@0SF]0QS60Woo0P0000=243g_?Nl01T8@43g_0T8@0Sg_0T8@0Sg_0THa0SW>0T8@
0Sg_0UJe0U[F13g_0T8@13g_0T8@0Sg_0SW>0SF]0Sg_0Tic0S6<0Sg_14Ha0S6<0Tic0T8@0RU:0SF]
0Sg_14Ha43g_0T8@0Sg_0T8@0THa0T8@0Sg_0RU:0RDY0V<H0SW>0Sg_1Goo0@000Goo000EOol00`00
Oomoo`04Ool2000248@2Ool2:DX2IcT20002BU82=Jd2?Nl22482Nmh2>Lh2=Jd20002>Lh2?Nl4@Q02
CW<2@Q04>Lh2:DX2<H`2E[D4?Nl2BU82JeX20004@Q02>Lh6?Nl4@Q02;F/2?Nl2>Lh2?Nl2@Q02?Nl4
=Jd2;F/2AS42>Lh26<H2E[D4>Lh2@Q02?Nl2@Q02?Nl2@Q02=Jd26<H2Ool200000d8@?Nlmk`06@Q0@
?Nl2@Q02?Nl2@Q02?Nl2AS42>Lh2@Q02?Nl2E[D2F]H4?Nl2@Q04?Nl2@Q02?Nl2>Lh2=Jd2?Nl2CW<2
<H`2?Nl4AS42<H`2CW<2@Q02:DX2=Jd2?Nl4AS4@?Nl2@Q02?Nl2@Q02AS42@Q02?Nl2:DX29BT2HaP2
>Lh2?Nl5Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0ogoo1goo
0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0UOol0
0`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool001Eoo`80
00=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00ogoo8Goo
003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(n = 128;\)\)], "Input"],

Cell[TextData[StyleBox["nPrime=32;\ncutwa=TakeMatrix[wa,{1,1},{32,32}];\n\
compressedwSpec=BlockMatrix[{{cutwa,ZeroMatrix[nPrime,n-nPrime]},\n\t\
{ZeroMatrix[n-nPrime,n]}}];",
  FontSize->14]], "Input",
  PageBreakWithin->Automatic,
  FontSize->16],

Cell[BoxData[
    \(\(b = Transpose[w] . compressedwSpec . w;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Transpose[w] . wa . w, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00WooB3F]13W>1SF]23W>0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa
0T8@0THa0SW>1Goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol00WooB3F]13W>1SF]23W>
0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa0T8@0THa0SW>1Goo0@000Goo000>Ool20005
Ool00`00Oomoo`02OomB=Jd6>Lh4=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl8>Li<?Nl6@Q02?Nl2
<H`28@P5Ool10001Ool001Eoo`03001oogoo009ooe8e[@HicP@e[@8aS08e[A`icP8mk`TicP@e[A0i
cP@mk`PicT`mk`I2408mk`8aS08Q20Eoo`40005oo`005Goo00<007ooOol00WooDSF]13W>13F]136<
0SF]73W>0Sg_2CW>13F]43W>1Sg_13W>33g_1SW><3g_148@13g_248@0SF]0Re[0QS60PaS1Goo0@00
0Goo000EOol00`00Oomoo`02OomB=Jd4>Lh4=Jd4<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh6?Nl4>Lh<?Nl6
>Lh`?Nl4@Q04?Nl8@Q02=Jd2;F/26<H236<5Ool10001Ool001Eoo`03001oogoo009ooc`e[@8icPPe
[@8icPXe[@@icP@e[@8aS0@e[A`icP8mk`<icP8mk`8icP@aS08e[@@mk`PicQ@mk`8icRPmk`A2408m
k`A240Hmk`A2408mk`8icP8mk`A6<@8mk`8aS08Li`8@Q0@000Eoo`40005oo`005Goo00<007ooOol0
0Woo?3F]0SW>23F]0SW>2SF]13W>13F]0S6<13F]73W>0Sg_0cW>0Sg_0SW>136<0SF]13g_23W>53g_
0SW>:3g_148@0Sg_148@1Sg_148@0Sg_0SW>0Sg_14Ha0Sg_0S6<0QcW0Q2410001Goo0@000Goo000E
Ool00`00Oomoo`02Ool2>Lhf=Jd6>Lh6=Jd6>Lh6=Jd6>Lh4=Jd2<H`2=JdN>Lh2?Nl3>Lh2?Nl2>Lh4
<H`2>Li6?Nl:@Q02?Nl6@Q08?Nl2@Q02AS42@Q02=Jd29BT25:D2248212440005Ool10001Ool001Eo
o`8000=oo`8icSHe[@HicPHe[@HicPHe[@HicP@e[@8aS08e[AhicP8mk`<icP8mk`8icP@aS08icTHm
k`Y2408mk`I240Pmk`924096<@92408e[@8U:@8DY@88@P848@@000Aoo`80005oo`005Goo00<007oo
Ool00Woo33W>83F]53W>0SF]23W>13F]1SW>23F]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Sg_148@3Sg_1T8@13g_448@0Sg_448@0SW>0Re[0QcW0PaS2P001Goo0@000Goo000EOol00`00
Oomoo`02Ool<>LhP=JdD>Lh2=Jd8>Lh4=Jd6>Lh8=Jd>>Lh2=Jd@>Lh2?Nl00cW>?Nlmk`02?Nl2=Jd2
<H`2=JdV?Nl4@Q0>?Nl6@Q04?Nl@@Q02?Nl@@Q02>Lh2;F/27>L236<:0005Ool10001Ool001Eoo`03
001oogoo009ooaXicP8e[@@icPPe[A0icP@e[@@icP8e[@HicPHe[@HicPPe[A`icP@mk`8icP<mk`8i
cP8e[@8aS08e[B@mk`Q240`mk`Q2408mkaA240@mk`9240A6<@92408e[@8U:@8@Q0848@`000Eoo`40
005oo`005Goo00<007ooOol00Woo6SW>0SF]13W>23F]43W>13F]13W>0SF]1SW>1SF]1SW>23F]73W>
13g_0SW>0cg_0SW>0SF]0S6<0SF]93g_248@33g_248@0Sg_548@13g_0T8@14Ha0T8@0SF]0RDY0Q24
0P@Q30001Goo0@000Goo000EOol00`00Oomoo`02Oom0>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd:>Lh4
?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhP?Nl2@Q02?Nl6@Q0>?NlN@Q02?Nl2@Q04AS42?Nl2<H`28@P2
48@2124>0005Ool10001Ool001Eoo`03001oogoo009ood0icP@e[@HicP8e[@PicP8e[@8aS08e[@Xi
cP@mk``icPPmk`8icP<mk`8icP@e[@8icR0mk`92408mk`I240hmkai2408mk`9240A6<@8mk`8aS08Q
208@Q0848@h000Eoo`40005oo`005Goo00<007ooOol00Woo6SW>0SF]>3W>13F]2SW>3Sg_13W>2cg_
0SW>13F]0SW>83g_148@0Sg_1T8@23g_648@0Sg_2T8@1THa0SW>0RU:0QS60PaS0P@Q40001Goo0@00
0Goo000EOol00`00Oomoo`02OolJ>Lh2=Jdh>Lh4=Jd:>Lh>?Nl4>Lh;?Nl2>Lh4=Jd2>LhP?Nl4@Q02
?Nl6@Q08?NlH@Q02?Nl:@Q06AS42>Lh2:DX26<H236<2124@0005Ool10001Ool001Eoo`03001oogoo
009oo`8mke0icPHe[@8icP8mk`@icQlmk`@e[@8icQXmk`a2408mk`I240Hmkb9240I6<@8mk`8e[@8U
:@8@Q0848@h000848@@000Eoo`40005oo`005Goo0P000goo0Sg_D3W>1SF]0SW>0Sg_13W>7cg_13F]
0SW>6Sg_348@0Sg_1T8@1Sg_8T8@1THa0Sg_0SF]0RDY0Q240P@Q3P000P@Q100017oo0P000Goo000E
Ool00`00Oomoo`02OolL?Nlf>Lh6=Jd2>Lh2?Nl4>Lh4?Nl4>LhF?Nl00cW>=Jde[@02<H`2>Lh4@Q04
>Lh>?Nl:@Q02?NlJ@Q08AS42@Q04AS48@Q04AS42BU82AS42@Q02<H`27>L236<21242000212440004
124:0005Ool10001Ool001Eoo`03001oogoo009ooa`mkcHicPHe[@8icP8mk`@icP@mk`@icQHmk`03
>Lhe[CF]008aS08icPA240@icPhmk`Y2408mkaY240Q6<@9240A6<@Q240A6<@9:DP96<@92408aS08L
i`8<H`848@8000848@@000@48@X000Eoo`40005oo`005Goo00<007ooOol00Woo63g_23W>23g_13W>
63g_23W>0Sg_0SW>1SF]13W>6Sg_13W>1Sg_00<icSF]=Jd00SF]0SW>1Sg_0SW>13g_6T8@13g_848@
14Ha0Sg_0T8@1THa0SW>0Re[0QcW0PaS0P@Q0P000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolH?Nl8>Lh8?Nl4>LhH?Nl8>Lh2?Nl2>Lh6=Jd4>LhJ?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2
>Lh4?NlJ@Q04?NlP@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124D0005Ool10001Ool0
01Eoo`03001oogoo009ooa`mk`@icPPmk`@icP`mk`@icPhmk`8icP8mk`8icP@e[@@icRHmk`03>Lhe
[CF]008icP8mk`9240hmkca240Q6<@8mk`8aS08U:@8DY@88@P848@@000848A@000Eoo`40005oo`00
5Goo00<007ooOol00Woo73g_13W>23g_13W>33g_13W>3Sg_0SW>0Sg_0SW>13F]13W>9Sg_00<icSF]
=Jd00SW>0Sg_0T8@3Sg_?48@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q50001Goo0@000Goo000E
Ool00`00Oomoo`02Ool<?Nl4@Q02?Nl6@Q0f?Nl8>LhV?Nl5>Lh4?Nl4@Q02?Nl4@Q08?NlZ@Q02AS48
@Q02AS44@Q02AS42BU82AS42>Lh2;F/26<H248@212480002124D0005Ool10001Ool001Eoo`03001o
ogoo009oo``mk`A2408mk`I243Hmk`PicRHmk`DicP@mk`A2408mk`A240PmkbY24096<@Q24096<@A2
4096<@9:DP96<@8icP8]J`8HaP8@Q0848@P000848A@000Eoo`40005oo`005Goo00<007ooOol00Woo
448@0Sg_1T8@13g_148@;Sg_1SW>:3g_0SW>1Cg_348@23g_=48@0THa0T8@0THa0TYB0THa0SW>0RU:
0QS60PQ20P@Q100010@Q60001Goo0@000Goo000EOol20003Ool@@Q02?Nl6@Q04?Nl4@Q0^?Nl6>LhX
?Nl2>Lh5?Nl<@Q08?Nld@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124H0004Ool2
0001Ool001Eoo`03001oogoo009ooaY2408mk`I2408mkaQ2410mk`PicP8mk`92410mk`A241<mk`A2
40@mkdI24096<@A:DP8icP8YBP8HaP8<H`H000@48AX000Eoo`40005oo`005Goo00<007ooOol00Woo
6T8@0Sg_1T8@0Sg_648@43g_23W>0Sg_0T8@43g_148@4cg_148@13g_AT8@0THa14YB0SW>0RU:0QS6
0PaS1P0010@Q6P001Goo0@000Goo000EOol00`00Oomoo`02Ool2AS46@Q04AS4d@Q0<?Nl6>Lh4?Nl2
@Q0B?Nl2@Q04?Nl2@Q0:?Nl7@Q04?NlJ@Q0:AS4D@Q02AS48@Q06AS42BU82?Nl29BT25:D2248V0005
Ool10001Ool001Eoo`03001oogoo009oo`96<@I240A6<CA240`mk`HicP@mk`92418mk`9240@mk`92
40Xmk`M240@mkaY240Y6<AA24096<@Q240I6<@9:DP8mk`8U:@8DY@88@RH000Eoo`40005oo`005Goo
00<007ooOol00Woo6THa<T8@23g_248@33g_2T8@2Sg_5D8@14Ha2T8@24Ha4T8@0THa0T8@1THa148@
14Ha0TYB0THa0SW>0RDY0Q2410@Q0P000P@Q30000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolJAS4b@Q08?Nl8@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q08AS4B@Q02AS42@Q06AS44@Q04AS42BU82AS42
>Lh29BT248@412420002124<0002124D0005Ool10001Ool001Eoo`03001oogoo009ooaY6<@Q240Y6
<B1240@mkb9240@mk`8icP@mk`m240Y6<@Y240I6<A1240I6<@9240a6<@A:DP8icP8U:@8DY@P48@H0
00@48AH000@48@Eoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Woo6THa248@2THa848@
13g_8T8@13g_0SW>13g_3d8@2THa2T8@1THa448@1THa0T8@34Ha14YB0SW>0RDY0QBU20@Q1P0010@Q
5P0010@Q1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Woo0TYB
;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa148@0THa1T8@34Ha148@
0THa14YB0THa0SW>0RU:0Q240PQ220@Q90001Goo0@000Goo0008Ool00`00Oomoo`02Ool01000Oomo
o`0017oo0P000goo0TYB;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa
148@0THa1T8@34Ha148@0THa14YB0THa0SW>0RU:0Q240PQ220@Q900017oo0P000Goo0009Ool01@00
Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo34YB24Ha1TYB6THa248@0THa148@0Sg_
13W>0Sg_148@14Ha148@0THa248@14Ha1T8@0THa3T8@0THa8d8@24Ha148@5THa0T8@14Ha0T8@0SF]
0RDY0QBU0PQ2:0000P@Q10001Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03
001oogoo009oo`a:DPQ6<@I:DQY6<@Q24096<@A2408mk`@icP8mk`A240A6<@A24096<@Q240A6<@I2
4096<@i24096<B=240Q6<@A241I6<@9240A6<@92408e[@8U:@8DY@88@RP000848@@000Eoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol00Woo94YB6THa0T8@0Sg_0SW>0S6<0Re[0SF]0T8@0TYB
0Tic34Ha148@1THa148@0THa2T8@5DHa148@=4Ha0TYB0THa0SF]0RDY0Q240PQ230000P@Q30000P@Q
300020@Q1Goo0@000Goo000EOol00`00Oomoo`02OolTBU8JAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02
BU82CW<<AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0dAS42BU82AS42=Jd29BT248@2248<0002124<0002
124<00081245Ool10001Ool001Eoo`03001oogoo009oo`i:DPI>L`Q:DPA6<Ai:DPA6<@8mk`8e[@8a
S08mk`9:DPABU09>L`A240Q6<@A24096<@9:DPQ6<@Q240A6<@924456<@I:DP96<@8icP8YBP8HaP88
@P848@8000h48@P000X48@@000X48@Eoo`40005oo`005Goo00<007ooOol00Woo3TYB1Tic24YB14Ha
7TYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@24Ha148@0THa0TYB24Ha248@14Ha0T8@@DHa1TYB
0THa0SW>0RU:0QS60PQ20P@Q0P003P@Q20002P@Q10002P@Q1Goo0@000Goo000EOol00`00Oomoo`02
Ool4CW<8BU86CW<8BU82CW<2AS44BU88CW<2BU86AS44@Q06AS48BU82AS42@Q02BU82E[D2F]H2IcT2
G_L2CW<2@Q0<AS44BU82AS42@Q04AS46@Q0cAS44BU8BAS44BU82AS42?Nl2:DX26<H236<212440004
12460002124:000H1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`Q:DPI>L`Q:DP9>L`96<@A:
DPQ>L`9:DPI6<@A240I6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240a6<@A:DP96<@9240A6
<@I243=6<@A:DQ96<@A:DP96<@8mk`8YBP8HaP8<H`848@@000@48@H000848@X001P48@Eoo`40005o
o`005Goo00<007ooOol00Woo24ic24YB34ic0U:D1Tic0TYB0THa0T8@0Sg_1SF]136<1SF]0SW>13g_
1T8@0Tic0U[F0V<H0Vmk0VLi0UJe0TYB1THa1TYB0THa13g_0T8@0THa0TYB24Ha0TYB<DHa2TYB2THa
14YB0T8@0S6<0QcW0PaS0P@Q700060@Q1Goo0@000Goo000EOol20003Ool8CW<8BU8<CW<2DY@6CW<2
BU82AS42@Q02?Nl6=Jd4<H`6=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2IcT2E[D2BU86AS46BU82AS44
?Nl2@Q02AS42BU88AS42BU8aAS4:BU8:AS44BU82@Q02<H`27>L236<2124L000H1244Ool20001Ool0
01Eoo`03001oogoo009ooaY>L`9:DP9>L`9:DP96<@92408icP8e[@8aS0@]J`HYBP`U:@@YBP8]J`8m
k`9BU09S60AW>@9JeP9>L`9:DPA6<@9>L`ABU096<@8icP8e[@8icP924096<@A:DPA6<@I:DS56<@Q:
DPI6<@I:DP92408e[@8Q208@Q0848@@000`48@h001P48@Eoo`40005oo`005Goo00<007ooOol00Woo
6Tic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:32DY12U:0Re[0Sg_0U:D0V<H16Li0U[F0Tic
0TYB14Ha0Tic15:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha1TYB<DHa24YB1THa1TYB0T8@0SF]0R48
0Q240P@Q100030@Q3P0060@Q1Goo0@000Goo000EOol00`00Oomoo`02OolBCW<4DY@2CW<2BU82AS44
?Nl2=Jd2<H`2;F/>:DX49BT28@P27>L86<H28@P2>Lh2F]H2Kg/2Li`2IcT2E[D6DY@2F]H2IcT2HaP2
E[D2@Q04<H`2@Q02BU82AS4<BU8GAS4BBU8>AS44BU84AS46BU82AS42>Lh29BT25:D2248412420006
12420002124D000D1245Ool10001Ool001Eoo`03001oogoo009ooa9>L`ABU09>L`9:DP96<@@mk`8e
[@8aS08]J`hYBP@U:@8Q208Li`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP9W>@9S609F]@92
40@aS092409:DP96<@a:DQM6<A9:DPi6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P@48@8000H48@80
00848A@001@48@Eoo`40005oo`005Goo00<007ooOol00Woo34ic15:D14ic0TYB0T8@0Sg_0SW>0S6<
32e[12U:1Re[12U:12DY1R480RU:0SW>0Tic0VLi0W>L0V]J0UJe0TYB0U:D0U[F0Ukg0V<H0VLi0Ukg
0U:D0T8@0Sg_0T8@14YB0Tic3TYB5DHa34YB1THa1TYB14Ha1TYB14Ha1TYB0THa0SW>0RDY0QBU0PQ2
100020@Q2P001P@Q10006P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<CW<4DY@4CW<2BU82@Q02
?Nl2>Lh2<H`<;F/4:DX6;F/4:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2
HaP2IcT2G_L2DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS46BU84AS46BU84AS46BU82AS42>Lh2
9BT25:D224840008124:00061244000J1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`YBU09>
L`96<@8mk`8e[@@aS08]J`8aS0P]J`8aS0@]J`XaS08]J`PaS08e[@92409F]@9W>@A_N`9JeP96<@8m
k`9:DP9JeP9Nm`9JeP9F]@Q:DPA>Ld5:DPA6<@a:DP96<@8icP8]J`8HaP8<H`848@@000H48@X000P4
8@@001X48@Eoo`40005oo`005Goo00<007ooOol00Woo14ic2U:D0Tic0THa0Sg_0SF]136<0Re[0S6<
22e[0S6<12e[2S6<0Re[236<0SF]0T8@0UJe0VLi16mk0U[F0THa0Sg_0TYB0U[F0Ukg0U[F0UJe24YB
14ic@DYB14Ha34YB0THa0SW>0Re[0QS60PaS0P@Q10001P@Q2P0020@Q10006P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool8DY@4CW<2AS42?Nl2=Jd2;F/4:DX4;F/:<H`8=Jd<>Lh6?Nl2AS42E[D2HaP2
Kg/2JeX2IcT2CW<2?Nl2=Jd2>Lh2AS44BU82CW<2BU8<CW<IBU88CW<ZBU82CW<2AS42?Nl2;F/27>L2
36<>1248000:1244000J1245Ool10001Ool001Eoo`8000=oo`QBU0A>L`96<@8mk`8e[@8]J`@YBP@]
J`XaS0Pe[@`icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP9>L`9:DPa>LaU:
DPQ>LbY:DP9>L`96<@8mk`8]J`8Li`8<H`h48@P000X48@@001X48@Aoo`80005oo`005Goo00<007oo
Ool00Woo15:D0Tic0TYB0T8@0Sg_136<22e[2S6<13F]1SW>1Sg_1T8@1THa0TYB0Tic0U:D0UJe0U[F
0Ukg0V<H0U:D0THa0SW>1SF]0T8@0Tic15:D0Tic1TYB0Tic0U:D34ic>DYB0THa14YB0T8@0S6<0R48
0QBU2P@Q3P00:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@2CW<2BU82@Q02?Nl4<H`8;F/:
<H`4=Jd6>Lh6?Nl6@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42>Lh6=Jd2@Q02CW<4DY@2
CW<6BU82CW<2DY@<CW<iBU82AS44BU82@Q02<H`28@P25:D:124>000X1245Ool10001Ool001Eoo`03
001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`haS0@e[@8icPHmk`Q240A6<@A:DP9>L`IBU09>L`9B
U09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`96<BE>LaQ:DP9>L`Y:DPA>L`a:DP96<@8e[@8U:@8@
Q088@P848A@002X48@Eoo`40005oo`005Goo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3S6<
13F]0SW>1Sg_248@14Ha14YB0Tic1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_0THa
9Dic64YB0Tic2TYB14ic34YB0THa0SF]0RDY0Q240PQ20P@Q5000:P@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl2=Jd2<H`6;F/B<H`2=Jd4>Lh4?Nl4@Q08AS44BU84CW<6DY@:E[D6DY@2CW<2BU82
@Q02?Nl2>Lh2BU82CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU86CW<2BU82AS42BU86CW<2?Nl2:DX26<H2
24821244000212440002124800081242000R1245Ool10001Ool001Eoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja8aS08e[@@icP@mk`A240Q6<@A:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`8icP9:DP9>
L`9BU09F]@ABU1e>La1:DPY>L`A:DPI>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@000848@@0
00848@P000P48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<1Re[3S6<13F]0SW>0SF]
0SW>13g_148@14Ha24YB1Tic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@0Sg_0THa0TYB1U:D
>Dic14YB1Tic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P0030@Q1P002P@Q0P008P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`6;F/><H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04AS48BU86CW<8DY@2E[D2F]H4
E[D2DY@4E[D2DY@4CW<2BU82@Q02?Nl2AS42BU86DY@iCW<4BU86CW<6BU84CW<2AS42<H`27>L236<2
1242000<1246000:1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]Ja8aS08e[@@icP8m
k`A240A6<@Q:DPA>L`QBU0iF]@QJeP9F]@ABU09:DP96<@8mk`96<@9>L`YBU1m>L`9BU1A>L`A:DP9>
L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@48@@000848@H000X48@8002848@Eoo`40005oo`00
5Goo0P000goo1Re[4S6<0SF]13W>0Sg_148@14Ha24YB14ic25:D3UJe25[F0UJe15:D0TYB0THa0Sg_
0THa0Tic2U:D7dic0U:D54ic14YB0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q10000P@Q
1P002P@Q0P008P@Q17oo0P000Goo000EOol00`00Oomoo`02Ool6;F/><H`2=Jd4>Lh4?Nl4@Q04AS44
BU88CW<4DY@:E[D@F]H8E[D4DY@2AS42@Q02AS42CW<8DY@6CW<:DY@YCW<2BU88CW<2BU82?Nl2;F/2
6<H22486000L1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]J`haS08e[@@icP@mk`A2
40A6<@A:DPQ>L`ABU0YF]A1JePQF]@ABU096<@924096<@9>L`QBU0I>L`YBU2U>L`9:DPQ>L`9:DP8m
k`8]J`8HaP88@PH001`48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo336<1SF]13W>13g_
148@14Ha1TYB1Tic1U:D25Je65[F15Je15:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Tic
0U:D0Tic0THa0S6<0R480Q240P@Q1P0070@Q0P008P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<
<H`6=Jd4>Lh4?Nl4@Q04AS46BU86CW<6DY@8E[DHF]H4E[D4DY@2BU82AS42@Q02BU82CW<6DY@4CW<<
DY@?CW<2DY@NCW<2DY@2CW<2AS42<H`28@P248@21246000L1242000R1245Ool10001Ool001Eoo`03
001oogoo009oo`PaS0Pe[@8icPHmk`A24096<@A:DPI>L`QBU0IF]AIJePINm`AJePIF]@9BU09:DPA2
409:DPAF]@iBU0A>L`]BU0A>L`IBU1Q>L`ABU09:DP8icP8U:@8@Q0848@P004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo236<23F]0SW>1Sg_148@0THa14YB1Tic25:D1UJe5U[F1Ukg15[F1UJe0U:D
0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D64ic15:D0TYB0SW>0RDY0Q240P@Q2000@0@Q1Goo0@00
0Goo000EOol00`00Oomoo`02Ool6<H`8=Jd2>Lh4?Nl6@Q02AS44BU86CW<6DY@8E[D<F]HDG_L4F]H6
E[D2DY@2AS42@Q02AS42DY@2E[DUDY@JCW<2DY@2CW<2@Q02;F/26<H236<212420002124400101245
Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`HaS0Pe[@8icP@mk`I24096<@A:DPI>
L`IBU0QF]@aJeQANm`AJePIF]@9BU096<@924096<@9BU09F]BEBU1Y>L`9BU09>L`92408]J`8HaP8<
H`848@8000848@@004048@Eoo`40005oo`002Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF]@YJePiNm`9S60YNm`9JePIF]@9>L`96
<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@004048@Eoo`40005o
o`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF
]@YJePiNm`9S60YNm`9JePIF]@9>L`96<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088
@P848@8000848@@004048@Aoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2
E[D2BU84AS42CW<WDY@<CW<2DY@6CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool1
0001Ool000Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2
@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@6
CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool10001Ool000Uoo`8000=oo`8000Eo
o`03001oogoo009oo`8aS08e[@@icPPmk`9240I6<@A:DPA>L`IBU0IF]@aJePYNm`iS60YNm`IJeP9F
]@9BU09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`ABU09:DP92408]J`8Li`8<H`848@H000848@@00404
8@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1THa14YB14ic1U:D1UJe35[F
2Ukg3V<H2Ukg1U[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic15:D0TYB0T8@0Re[0QcW0PaS
0P@Q1P000P@Q1000@0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4@Q04AS44BU86
CW<4DY@8E[D<F]H6G_L2HaP2G_LDHaP:G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2CW<2BU82CW<4
DY@2AS42>Lh28@P25:D2248612420002124400101245Ool10001Ool001Eoo`03001oogoo009oo`8e
[@HicP@mk`A240A6<@A:DPI>L`ABU0QF]@aJePINm`9S609NmaAS60YNm`9JePAF]@9>L`A:DP9>LamB
U0Q>L`YBU09>L`9:DP9>L`ABU096<@8icP8Q208DY@88@PH48@8000848@@004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo13W>13g_148@1THa14YB1Tic1U:D1UJe35[F2Ukg66<H25kg1U[F0U:D1TYB
0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D0UJe0U:D0Sg_0Re[0QS60Q240PQ20P@Q2000A0@Q
1Goo0@000Goo000EOol00`00Oomoo`02Ool4>Lh4?Nl4@Q06AS44BU86CW<6DY@6E[D<F]H:G_LHHaP8
G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4CW<>DY@4CW<2DY@2E[D2DY@2?Nl2;F/26<H248@2
2482124800141245Ool10001Ool001Eoo`03001oogoo009oo`8icP@mk`A240I6<@A:DPI>L`QBU0AF
]@YJePaNm`iS609W>@aS60YNm`9JeP9F]@Q>LbeBU0I>L`ABU09:DP8aS08Q208DY@8@Q088@P848@H0
04H48@Eoo`40005oo`005Goo0P000goo0SW>13g_148@1THa14YB1Tic25:D15Je2U[F35kg3V<H0VLi
36<H2Ukg0U[F0UJe24ic;E:D1Tic15:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00AP@Q17oo0P000Goo
000EOol00`00Oomoo`02Ool2?Nl6@Q04AS46BU84CW<:DY@4E[D:F]H>G_L>HaP8IcT<HaP4G_L4F]H2
DY@6CW<[DY@8CW<2DY@2CW<2?Nl2:DX26<H248@236<4124400181245Ool10001Ool001Eoo`03001o
ogoo009oo`8mk`I240A6<@I:DPA>L`YBU0AF]@YJePiNm`iS60QW>@aS60ANm`AJeP9BU0I>Lb]BU0Q>
L`9BU09>L`8mk`8YBP8HaP8@Q08<H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo1T8@
14Ha24YB1Tic25:D0UJe3U[F35kg8V<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic15:D0TYB
0SF]0R480QBU0Q240PaS0P@Q1P00B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6@Q04AS48BU86
CW<8DY@2E[D>F]H<G_LRHaP2G_L6F]H2E[D2CW<4BU82CW<YDY@2CW<2DY@2CW<4DY@2BU82=Jd28@P2
5:D248@236<2124600181245Ool10001Ool001Eoo`03001oogoo009oo`A240I6<@Q:DPA>L`QBU0AF
]@iJePaNmb1S60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iBU0A>L`9BU09>L`92408]J`8HaP8@Q0@<
H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo148@1THa24YB14ic25:D15Je3U[F35kg
86<H15kg1U[F0UJe0U:D14YB0Tic6e:D0Tic3U:D14ic0U:D0Tic0T8@0Re[0QS60Q2410aS10@Q1000
B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q06AS44BU88CW<6DY@8E[D<F]H>G_LPHaP6G_L6
F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2CW<4DY@2CW<2>Lh29BT25:D436<2249@1245Ool10001Ool0
01Eoo`03001oogoo009oo`9240I6<@A:DPQ>L`IBU0QF]@aJePiNmb1S60INm`IJeP9BU09>L`A:DPI>
LaEBU0I>L`YBU09>L`ABU09>L`8icP8U:@8DY@@<H`88@U048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1THa1TYB1Tic1U:D25Je35[F35kg2V<H0VLi76<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic
15:D24ic15:D0T8@0Re[0QcW0Q2410aS0PQ2D0@Q1Goo0@000Goo000EOol20003Ool6AS46BU86CW<6
DY@8E[D<F]H<G_L:HaP2IcTLHaP8G_L2E[D2DY@6BU84CW<2DY@4CW<5DY@@CW<4DY@8CW<4DY@2@Q02
;F/27>L248@436<2249@1244Ool20001Ool001Eoo`03001oogoo009oo`A6<@A:DPY>L`IBU0IF]@YJ
ePiNm`YS60IW>AYS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@8Q208DY@@@Q088@Rh4
8@88@R848@Eoo`40005oo`005Goo00<007ooOol00Woo14Ha14YB2Tic1U:D1UJe2U[F3Ukg2V<H1VLi
6V<H25kg0U[F0U:D0Tic1TYB24ic0e:D7Tic0U:D0TYB0SF]0R480QBU11240PQ2;P@Q0PQ28P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool2AS48BU82CW<:DY@4E[D>F]H>G_L:HaP:IcT4HaP<IcT8HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/2
6<H648@2248`1242248P1245Ool10001Ool001Eoo`03001oogoo009oo`96<@Q:DP9>L`YBU0AF]@iJ
ePiNm`YS60YW>@AS60aW>@QS60ANm`9JePAF]@9>L`9:DP96<@A:DPQ>L`03DYA>Ldic00I>L`9BU0a>
L`9BU09>L`9:DPA>L`96<@8]J`8HaPH@Q088@S048@88@R048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1TYB1Tic2U:D15Je3U[F3Ukg2V<H36Li1V<H16Li36<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic
0TYB0Sg_0RU:0QBU0Q2410aS0PQ2;P@Q10Q280@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6BU86
CW<:DY@4E[D>F]H>G_L:HaP<IcT6HaP4IcT<HaP4G_L4F]H2E[D2DY@2CW<4AS42BU8WCW<2BU82?Nl2
:DX25:D248@436<2248^1244248P1245Ool10001Ool001Eoo`03001oogoo009oo`A:DPQ>L`QBU0AF
]@iJePaNma1S60YW>AQS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q208@Q0@<H`@8@QP4
8@88@Q048@P8@R048@Eoo`40005oo`005Goo00<007ooOol00Woo14YB24ic25:D15Je3U[F35kg46<H
2VLi66<H15kg15[F0UJe0Tic14Ha0TYB8dic15:D0THa0SF]0R480Q2410aS10Q260@Q0PQ240@Q20Q2
80@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU88CW<<E[D>F]H<G_L:HaP4IcT6HaP6IcTHHaP4
G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2BU82CW<4DY@2@Q02:DX26<H448@236<4248F1244248<124<
248P1245Ool10001Ool001Eoo`8000=oo`A:DPQ>L`aF]@iJePaNm`YS60AW>@IS60IW>AQS60ANm`AJ
eP9F]@9BU09:DPA6<@9:DQe>L`9:DP9>L`ABU092408YBP8HaP@@Q08<H`@8@QH48@@8@P`48@`8@R04
8@Aoo`80005oo`005Goo00<007ooOol00Woo14YB1Tic0U:D35Je3U[F35kg2V<H1VLi1V<H16Li5V<H
1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS60QBU0Q240PaS
20Q24P@Q10Q22P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU86CW<2DY@<E[D>F]H<
G_L:HaP6IcT6HaP4IcTFHaP6G_L4F]H2E[D2DY@2CW<6AS42BU8CCW<2BU86CW<2BU82CW<2DY@2CW<2
>Lh28@P26<H25:D248@236<8248B1244248:124@248N1245Ool10001Ool001Eoo`03001oogoo009o
o`9:DPI>L`ABU0aF]@aJeQ9Nm`IS60YW>AaS60INm`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:
DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP@DY@8@Q08<H`P8@P`48@X8@PH48@88@P848A08@Qh4
8@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB1Tic15:D35Je35[F4Ukg1V<H2VLi76<H1Ukg15[F
0UJe0U:D0Tic0TYB0THa0T8@0TYB1dic14YB24ic14YB14ic0TYB0Tic0U:D0THa0S6<0QS611BU0Q24
0PaS20Q230@Q2PQ21P@Q0PQ20P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6CW<6DY@:
E[D>F]HBG_L4HaP>IcTJHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2BU82CW<6BU88CW<2
>Lh29BT65:D248@:248:124V248N1245Ool10001Ool001Eoo`03001oogoo009oo`I>L`IBU0YF]@iJ
eQ9Nm`AS60iW>AYS60INm`AJePAF]@9BU09:DPI6<@A:DP=>L`A:DPA>L`9:DP9>L`I:DPQ>L`8icP8U
:@HDY@8@Q0X8@PX48BH8@Qh48@Eoo`40005oo`005Goo00<007ooOol00Woo1Tic15:D35Je3U[F25kg
1V<H15kg16<H0VLi0V<H2VLi6V<H2Ukg0U[F0UJe0U:D0Tic1THa6DYB1Tic0TYB0SF]0R480Q240QBU
0QS60Q2410Q20P@Q10Q22P@Q10Q210aS7PQ26P@Q10Q21Goo0@000Goo0007Ool30004Ool20005Ool0
0`00Oomoo`02Ool6CW<4DY@<E[D>F]H8G_L6HaP4G_L4HaP2IcT2HaP:IcTJHaP:G_L2F]H2E[D2DY@2
CW<6AS4IBU86CW<2BU82=Jd28@P248@25:D26<H248@424821244248:1244248436<N248J12442485
Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D25Je
45[F3Ukg16<H46Li76<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
11BU0PaS30Q210@Q0PQ21PaS0Q240PaS1PQ21P@Q4PQ26P@Q10Q21Goo0@000Goo0007Ool01000Oomo
o`000Woo00@007ooOol000Aoo`8000=oo`9>L`YBU0QF]A1JePiNm`AS611W>AaS60YNm`AJeP9F]@9>
L`9:DPA6<@9240e:DP96<@Y:DPA>L`8mk`8YBP8HaP8@Q0@DY@8<H``8@P@48@88@PH<H`8@Q08<H`H8
@PH48A88@QX48@@8@PAoo`80005oo`001goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9>
L`QBU0YF]A1JePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>
L`9:DP8icP8U:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eo
o`40005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`QBU0YF]A1J
ePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>L`9:DP8icP8U
:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eoo`40005oo`00
27oo0`000goo0P001Goo00<007ooOol00Woo0Tic1U:D35Je45[F35kg1V<H46Li76<H2Ukg15[F15Je
0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW0Q240PaS11240PaS1PQ22P@Q0PQ20PaS
0R480QcW0QBU0PaS70Q27P@Q0PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<6DY@<E[D@F]H<
G_L6HaP@IcTLHaP:G_L4F]H4E[D2DY@2CW<2AS42@Q02AS4;BU82AS4:BU82CW<2AS42<H`27>L248@2
36<448@236<6248:1242248236<28@P27>L25:D236<L248N12422485Ool10001Ool001Eoo`03001o
ogoo009oo`IBU0aF]A1JePYNm`QS619W>AaS60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB
00A:DPI6<@9:DP96<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@8@Q08<H`88@Ph48@8<H`8@Q0@HaP8DY@8<
Ha`8@Q`48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U:D35Je45[F2Ukg26<H4VLi76<H2Ukg
1U[F0UJe0U:D0Tic0TYB0THa0T8@00=6<DYBBU8014YB1THa0TYB0THa24YB0Sg_0Re[0QS60Q240PaS
0QBU0Q240PaS0PQ23P@Q0PaS0Q2411S60QBU0PaS70Q270@Q10Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool6DY@8E[DDF]H:G_L:HaP@IcTNHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT2
5:D236<248@25:D248@236<2248<1244248836<H248236<4248J12462485Ool10001Ool001Eoo`03
001oogoo009oo`IBU0QF]AAJePYNm`YS611W>AiS60QNm`IJeP9F]@ABU09:DP96<@=24196<@I:DP8i
cP8U:@8DY@8<H`8@Q08DY@8@Q08<H`88@P`48@@8@PP<HaP8@P8<H`@8@QX48@H8@PEoo`40005oo`00
5Goo00<007ooOol00Woo15:D25Je5U[F3Ukg2V<H4VLi66<H25kg1U[F0UJe15:D0Tic0TYB1d8@3THa
14YB0THa0SF]0R480Q2410aS0Q240PaS10Q23P@Q80Q210aS10Q26P@Q1PQ21Goo0@000Goo000EOol2
0003Ool4DY@8E[DFF]H>G_L:HaPBIcTHHaP8G_L6F]H2E[D4DY@2CW<2BU87@Q0>AS44BU82AS42=Jd2
8@P248@436<248@236<4248>124P248436<4248J12462484Ool20001Ool001Eoo`03001oogoo009o
o`ABU0QF]AAJeQ1Nm`YS619W>AaS60ANm`9JeP9Nm`9JePIF]@9BU09:DP96<@03@Q0mkcg_00A240a6
<@9:DP96<@92408aS08Li`8@Q0H<H`H8@PX48@88@P@48@H8@P@48A@8@P@<H`H8@P848@@8@PP48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo15:D25Je55[F45kg2V<H4VLi76<H15kg0U[F0Ukg0U[F
1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB0THa0T8@0S6<0QcW0Q241PaS1PQ22P@Q0PQ210@Q
1PQ210@Q50Q210aS1PQ20P@Q10Q220@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@8E[DD
F]H<G_L:HaP6IcT4HaP>IcTJHaP4G_L2F]H4G_L2F]H4E[D2DY@2BU82AS400d8@?Nlmk`06@Q06AS42
@Q02AS42BU82AS42?Nl2;F/26<H648@236<2248>124<248412462482124<248436<6248212442488
124@2485Ool10001Ool001Eoo`03001oogoo009oo`ABU0QF]AAJePaNm`YS60IW>@AS60iW>AYS60AN
m`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@
Q08<H`88@Ph48@`8@P@48@H8@P848@`8@P@<H`H8@P848@@8@PP48A08@PEoo`40005oo`005Goo00<0
07ooOol00Woo35Je45[F45kg26<H16Li26<H0VLi1V<H1VLi56<H3Ukg1U[F0UJe0U:D14ic00=6<Cg_
?Nl00Sg_1T8@14Ha148@0TYB0THa0SF]0RDY0QS61Q240PaS5P@Q0PQ210@Q5PQ210aS2PQ20P@Q1PQ2
1P@Q3PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool<E[D@F]H@G_L8HaP4IcT8HaP2IcT6HaP6IcTD
HaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT26<H648@236<F
12422484124F248436<:248212462486124>2485Ool10001Ool001Eoo`03001oogoo009oo`YF]A9J
eQ1Nm`YS609W>@QS609W>@IS60IW>AAS60ANm`9S60QNm`IJePAF]@9BU09>L`03BU92448@00Q240A6
<@A24096<@92408e[@8U:@8HaP8DY@8@Q08<H`88@Q@48@@8@P@48AH8@P@<H`X8@P848@H8@P@48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo2UJe4U[F45kg2V<H0VLi26<H0VLi1V<H1VLi56<H15kg
0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@0SF]0RDY0QS60QBU0Q240PaS
0PQ250@Q10Q210@Q5PQ210aS2PQ20P@Q1PQ210@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool8
E[DDF]H@G_LDHaP2IcT6HaP6IcT>HaP2G_L6HaP2G_L4HaP6G_L8F]H2E[D4DY@00dYBAS56<@04@Q02
?Nl2@Q02AS46@Q02AS42@Q02<H`28@P26<H25:D248@236<2248D124N248436<:248212462482124B
2485Ool10001Ool001Eoo`8000=oo`QF]AAJeQ1NmaAS609W>@IS60IW>@iS609Nm`IS609Nm`AS60IN
m`QJeP9F]@ABU003BU96<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88
@Q@48Ah8@P@<H`X8@P848@H8@P848A88@PAoo`80005oo`005Goo00<007ooOol00Woo25Je55[F45kg
46<H1VLi26<H0VLi46<H0Ukg36<H1Ukg25[F15Je0U:D00=>LdYBBU800THa0T8@0Sg_2T8@0THa0Sg_
0Re[0R480QS60QBU0Q240PQ250@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[DDF]H@G_L@HaP6IcT8HaP2IcT@HaP2G_L<HaP6G_L8F]H4E[D2DY@00dicBU9:DP02AS42@Q02
?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248D124P248436<:2482124J2485Ool10001Ool001Eo
o`03001oogoo009oo`QF]AAJePiNm`iS60YW>AYS609Nm`aS60ANm`YJePAF]@9BU003CW=:DTYB0096
<@9240@mk`Y2408icP8YBP8Li`8HaP8@Q08<HaH48B08@P@<H`X8@P848AX8@PEoo`40005oo`005Goo
00<007ooOol00Woo25Je55[F3Ukg3V<H2VLi6V<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa
0T8@13g_2T8@0SW>0RU:0QcW0QS60Q240PaS5P@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool8E[DDF]H<G_L>HaP<IcT2HaP4IcTDHaP2G_L<HaP4G_L:F]H4E[D2DY@3CW<2BU82
@Q04?Nl:@Q02=Jd29BT26<H25:D236<2248D124R248436<V2485Ool10001Ool001Eoo`03001oogoo
009oo`QF]AAJePaNm`iS60aW>@9S60AW>AAS609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2
408e[@8U:@8HaP8DY@8<H`88@Q@48B88@P@<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo25Je
45[F3Ukg3V<H3VLi0V<H16Li56<H0Ukg36<H1Ukg25[F1UJe00=BU4icCW<00TYB0THa0T8@1Sg_148@
0Sg_0S6<0R4811BU0PaS0PQ22P@Q0PQ210@Q9PQ20PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[D@F]H>G_L>HaP>IcT2HaP4IcTDHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06
?Nl4@Q02?Nl2<H`28@P45:D236<2248:12422484124V248236<X2485Ool10001Ool001Eoo`03001o
ogoo009oo`9F]AAJeQ1Nm`iS61AW>A9S60ANm`aS60INm`YJePAF]@=BU09>L`9:DP9240Pmk`92408m
k`8]J`8Li`8DY@8@Q08<H`88@PX48@88@P848BP8@P8<HbP8@PEoo`40005oo`005Goo0P000goo0UJe
55[F45kg3V<H56Li4V<H15kg36<H1Ukg2U[F15Je0e:D0Tic0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU
0Q240PaS0PQ22P@Q0PQ20P@Q:0Q20PaS:0Q217oo0P000Goo000EOol00`00Oomoo`02Ool4E[D@F]HB
G_L>HaP@IcTDHaP4G_L:HaP2IcT2HaP2G_L2HaP4G_L8F]H5E[D2DY@2CW<4BU82@Q02>Lh4?Nl2@Q02
?Nl2:DX26<H248@236<224881242248:12482482124D248836<T248236<22485Ool10001Ool001Eo
o`03001oogoo009oo`AF]A1JeQ9Nm`iS611W>AAS60ANm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PP48@88@PX48@P8@P848A@8@PP<Hb@8
@P8<H`88@PEoo`40005oo`005Goo00<007ooOol00Woo0UJe45[F4Ukg4V<H36Li5V<H15kg3V<H25kg
25[F1EJe0U:D14ic0TYB0T8@0SW>13g_0T8@0SW>0RU:0QS60Q240PaS0PQ220@Q10Q220@Q20Q20P@Q
5PQ21PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D@F]HBG_LBHaP<IcTFHaP4G_L>HaP8
G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02>Lh2:DX26<H248@236<224881244248812482482
124F248636<X2485Ool10001Ool001Eoo`03001oogoo009oo`9F]@iJeQANmaAS60QW>AYS609Nm`iS
60QNm`YJeP=F]@ABU09>L`9:DP96<@8mk`8icP@mk`8icP8U:@8DY@8@Q08<H`88@PP48@@8@PP48@P8
@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`005Goo00<007ooOol00Woo0UJe3U[F55kg56<H26Li6V<H
0Ukg3V<H25kg2U[F0eJe15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ220@Q10Q2
20@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D>F]HDG_LFHaP6
IcTZHaP8G_L:F]H5E[D2DY@4CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<:1246248612482482124F
248636<V248236<5Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`9F]@iJeQANmaIS
60IW>BYS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8DY@@<H`X48@H8@PH48@P8@P84
8AH8@PH<HbH8@P8<H`Eoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomo
o`02Ool@F]HFG_LBHaP8IcTZHaP:G_L8F]H5E[D4DY@2CW<2BU82@Q06>Lh2<H`28@P25:D436<:1246
248612482482124F248636<X2485Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo
0P000goo45[F5Ukg4V<H26Li:V<H2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2P@Q
1PQ21P@Q20Q20P@Q5PQ21PaS:0Q217oo0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007oo
Ool00Woo4U[F55kg46<H2VLi;6<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU
0PaS0PQ25P@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007oo
Ool000Aoo`03001oogoo009ooa9JeQANma1S60YW>BaS60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8i
cP8e[@8aS08Q208DY@8<H`88@QH48@P8@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo4U[F2Ukg0V<H25kg36<H46Li:V<H35kg1e[F0UJe1U:D0Tic0TYB0T8@
0SW>0SF]0Re[0R480QBU0PaS0PQ25P@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000EOol00`00Oomo
o`02OolBF]H:G_L2HaP8G_L<HaP@IcTZHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P2
5:D236<2248F12482482124D248836<X2485Ool10001Ool001Eoo`03001oogoo009ooa9JePYNm`AS
60INm`YS61AW>BQS60iNm`EJeP9F]@IBU0A>L`96<@8mk`8e[@8]J`8Li`8DY@8<HaP48@P8@P848A@8
@PP<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo4U[F2Ukg16<H1Ukg2V<H56Li:6<H3Ukg1E[F
0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS60@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000E
Ool00`00Oomoo`02Ool@F]H@G_L4HaP2G_L:HaP@IcTDHaP4IcT2HaP6G_L<HaP<G_L9F]H4E[D2DY@4
CW<2BU82@Q02=Jd2:DX27>L248@236<@2482124:2486124@248:36<V248212422485Ool10001Ool0
01Eoo`03001oogoo009ooa1JeQ1Nm`AS609Nm`YS611W>AAS60AW>@9S60INm`aS60aNm`UJePAF]@9B
U0A>L`9:DP92408e[@8YBP8Li`8@Q08<Ha08@P848@X8@PH48A08@PX<HbH8@P848@88@PEoo`40005o
o`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi16<H46Li56<H0VLi16<H15kg3V<H35kg2E[F15Je
0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q:PQ240aS90Q21Goo0@000Goo000EOol20003
Ool@F]H@G_L:HaP2IcT4HaP@IcTDHaP2IcT4HaP4G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2
:DX27>L248@236<22486124Z248@36<T2484Ool20001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`YS
609W>@9S611W>AaS60ANm`iS60iNm`MJePAF]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BH8@Q8<
HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi0V<H46Li76<H15kg3V<H3Ukg
1e[F15Je0U:D14ic14YB0Sg_0Re[0QcW0Q2410Q21P@Q9PQ24PaS9PQ21Goo0@000Goo000EOol00`00
Oomoo`02Ool@F]H@G_L8HaP4IcT2HaP@IcTLHaP4G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`2
7>L248@42482124/248@36<V2485Ool10001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`QS60AW>@9S
611W>AaS60ANma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848B`8@Q0<HbH8@PEo
o`40005oo`005Goo00<007ooOol00Woo3U[F4Ukg1V<H1VLi16<H46Li1V<H0VLi4V<H15kg46<H35kg
1e[F1UJe0U:D1Tic0THa0SF]0R480Q244PQ20P@Q7PQ20PaS0PQ230aS9PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool>F]HBG_L6HaP6IcT4HaP@IcT6HaP2IcTBHaP4G_L@HaP<G_L7F]H6E[D2DY@6CW<2
AS42=Jd28@P248@B2482124N248236<2248<36<V2485Ool10001Ool001Eoo`03001oogoo009oo`iJ
ePiNm`YS60IW>@9S61aW>A1S60ANm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8mk`8YBP8@Q108
@P@48Ah8@Ph<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo3U[F3Ukg2V<H1VLi0V<H76Li46<H
15kg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q2440Q210@Q7PQ23PaS:0Q21Goo0@00
0Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPNIcTHHaP4G_L:HaP>G_L7F]H4E[D4DY@4
CW<2AS42<H`25:DB2482124L248636<648@836<T2485Ool10001Ool001Eoo`8000=oo`iJePiNm`QS
60IW>@9S61iW>AQS60ANm`YS60iNm`MJePAF]@ABU0A>L`96<@8aS08DYA88@P848A`8@PH<H`H@Q0P<
Hb@8@PAoo`80005oo`005Goo00<007ooOol00Woo3U[F3Ukg26<H1VLi0V<H86Li5V<H15kg2V<H3Ukg
2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:PQ220aS0Q2411BU0Q241PaS80Q20PaS0PQ21Goo
0@000Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPPIcTFHaP4G_L:HaP>G_L9F]H2E[D2
DY@2E[D4CW<2BU82>Lh26<H2248236<Z248836<248@45:D248@636<P248236<22485Ool10001Ool0
01Eoo`03001oogoo009oo`IJeQINm`YS62IW>BAS60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2188
@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q08<H`88@P8<Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo
1U[F5Ukg2V<H9VLi96<H3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484PQ20P@Q7PQ20PaS0Q2411S6
0QBU0Q240PaS0PQ20PaS90Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4
G_L:HaP2G_L4HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@@2482124N248236<248@46<H2
5:D248@636<T2485Ool10001Ool001Eoo`03001oogoo009oo`IJeQINm`IS62YW>AIS60ANm`YS609N
m`AS60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q108@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q0H<
Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U[F5Ukg1V<H:VLi5V<H15kg1V<H15kg26<H1ekg
25[F15Je25:D0THa0Re[0QBU1PQ20PaS9PQ210aS0QBU12480QBU0Q2410aS9PQ21Goo0@000Goo000E
Ool00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8DY@2AS42;F/2
5:D6248236<V248436<25:D48@P25:D248@436<V2485Ool10001Ool001Eoo`03001oogoo009oo`IJ
eQINm`AS62aW>AIS60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8HaPH8@P8<HbH8@P@<H`8H
aP@]J`8Li`8@Q0@<HbH8@PEoo`40005oo`005Goo0P000goo1U[F5Ukg16<H;6Li5V<H15kg1V<H15kg
26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9PQ210aS0QS612e[0QcW0Q2410aS9PQ217oo0P00
0Goo000EOol00`00Oomoo`02Ool6F]H>G_L<HaPBIcT4JeXDIcTHHaP4G_L8HaP6G_L4HaP7G_L8F]H4
E[D8DY@2BU82>Lh28@P6248236<J248436<8248436<28@P4=Jd28@P248@236<X2485Ool10001Ool0
01Eoo`03001oogoo009oo`IJePiNm`aS619W>@A[FQAW>AQS60ANm`QS60INm`AS60MNm`QJePAF]@QB
U09:DP8icP8Q20H8@P8<HaX8@P@<H`P8@P@<H`8Q20@e[@8Q208@Q08<HbP8@PEoo`40005oo`005Goo
00<007ooOol00Woo15[F3Ukg36<H36Li0V]J16Li36]J46Li96<H15kg26<H0ekg2U[F15Je1U:D0Tic
0T8@0RU:0PaS10Q210aS60Q21PaS1PQ210aS0R4813F]0R480Q240PaS2PQ20P@Q70Q21Goo0@000Goo
000EOol00`00Oomoo`02Ool4F]H>G_L<HaP<IcT2JeX4IcT<JeX@IcTTHaP4G_L8HaP3G_L:F]H4E[D6
DY@2CW<2@Q02:DX236<4248436<H248636<6248436<28@P4=Jd28@P248@236<:2482124L2485Ool1
0001Ool001Eoo`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>C9S60=Nm`aJePIBU09>L`96<@8]J`8D
Y@@8@P8<HaX8@P@<H`P8@P@<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A`8@PEoo`40005oo`005Goo00<0
07ooOol00Woo45kg36<H36Li56]J46Li<V<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6PQ210aS
20Q210aS0QcW12e[0QcW0Q241PaS10Q210@Q70Q21Goo0@000Goo000EOol00`00Oomoo`02Ool@G_L<
HaP<IcTDJeX@IcTXHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D4248436<F248236<<248436<2
6<H49BT25:D248@636<42484124L2485Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eo
o`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>BQS60AW>@IS60=Nm`aJePIBU09>L`9:DP8e[@8DY@@8
@P@<HaH8@P8<H``8@P@<H`8HaP@U:@8DY@8@Q0H<H`@8@P@48A`8@PEoo`40005oo`000goo00D007oo
Oomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L6HaP@IcT@JeX4
IcT2JeX>IcTTHaP4G_L2HaP4JeX4HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H2
36<2248436<F248436<8248436<248@26<H47>L25:D448@236<V2485Ool10001Ool000=oo`05001o
ogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo4Ukg1V<H46Li46]J16Li0V]J
3VLi96<H15kg0V<H16]J16<H00=Nme[FF]H015kg25[F0UJe0U:D0UJe0U:D0TYB0SW>0QS60PaS0PQ2
10aS5PQ210aS20Q210aS0Q240QS611cW0QBU11240PaS9PQ217oo0P000Goo0003Ool01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9Nm`9JePiNm`IS60iW>AQ[
FPiW>BIS609Nm`9S60A[FP9W>@9S60MNm`QJeP9F]@9BU09F]@9BU09:DP8mk`8Li`8<H`88@P@<HaH8
@P@<H`@8@P8<H`88@P@<H`8@Q08DY@@HaP8DY@8@Q0@<HbH8@PEoo`40005oo`000goo00D007ooOomo
o`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2G_L2F]H>G_L6HaP>IcTH
JeX>IcTVHaP2G_L2HaP4JeX2IcT2HaP7G_L8F]H2E[D2DY@2E[D2DY@2BU82?Nl27>L236<2248436<F
248436<4248236<2248436<248@25:D46<H25:D248@436<V2485Ool10001Ool0009oo`8000Aoo`80
00Aoo`8000Eoo`03001oogoo009oo`AJePaNm`QS60aW>AY[FPiW>BIS609Nm`9S609W>@A[FP9S60MN
m`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaH8@P@<H`@8@P8<H`88@P@<H`@@Q0@DY@8@
Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo15[F35kg26<H36Li6V]J3VLi9V<H0Ukg0V<H
0VLi16]J0V<H1ekg25[F0UJe0U:D0UJe0U:D0Tic0T8@0RDY0PaS0PQ210aS5PQ210aS10Q20PaS0PQ2
10aS112411BU0Q241PaS9PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H>G_L8HaP<IcTLJeX@
IcTVHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2CW<2AS42:DX248@2248436<2248236<J2482
36<4248236<448@45:D248@636<V2485Ool10001Ool001Eoo`03001oogoo009oo`9JePiNm`QS60aW
>Aa[FQ1W>BIS609W>@A[FP=S60INm`QJeP9F]@9BU09F]@9BU09>L`96<@8YBP8@Q088@P@<H`88@P8<
HaX8@P8<H`@8@P8<H`@@Q0@DY@8@Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45kg1V<H
36Li46]J0Vmk36]J46Li76<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS
0PQ20PaS10Q20PaS50Q210aS0PQ210aS212420aS10Q220@Q60Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool@G_L6HaP<IcT@JeX2Kg/<JeX@IcTLHaP2G_L:HaP4IcT3HaP6G_L:F]H4E[D2DY@2CW<2AS42
;F/25:D2248436<2248236<4248236<D248436<2248436<848@836<42488124H2485Ool10001Ool0
01Eoo`03001oogoo009ooa1Nm`AS60iW>@I[FPA_N`A[FPI_N`Y[FQ9W>@QS609W>B=S60INm`AJeP9N
m`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<H`88@P8<H`@8@P8<Ha@8@P@<H`88@P@<H`H@Q0H<H`P8
@PP48@@8@PX48@X8@PEoo`40005oo`005Goo0P000goo45kg16<H3VLi1V]J16mk16]J1Vmk2V]J4VLi
26<H0VLi8f<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0TYB0S6<0QS60PQ210aS0PQ20PaS10Q20PaS50Q2
10aS0PQ210aS1Q241PaS20Q220@Q10Q22P@Q2PQ217oo0P000Goo000EOol00`00Oomoo`02Ool>G_L6
HaP<IcT4JeXBKg/:JeXLIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2CW<2=Jd26<H636<2248236<J2484
36<2248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`iNm`IS60aW>@A[
FQ9_N`Y[FQaW>B=S60INm`AJeP9Nm`AJePAF]@ABU09>L`8e[@8HaPH<H`88@P8<HaX8@P@<H`88@Q0<
H`P8@PP48@@8@P`48@P8@PEoo`40005oo`005Goo00<007ooOol00Woo3Ukg1V<H2VLi1V]J56mk26]J
76Li56<H15kg3F<H15kg15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21PaS4PQ20PaS1PQ210aS0PQ2
40aS20Q220@Q10Q230@Q20Q21Goo0@000Goo000EOol00`00Oomoo`02Ool>G_L6HaP:IcT6JeXDKg/8
JeXLIcTDHaP4G_L=HaP4G_L4F]H2G_L8F]H4DY@2CW<2>Lh26<H236<2248636<B248236<6248436<2
248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`YNm`QS60YW>@I[FPI_
N`IcW0Q_N`Y[FQ1W>C5S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20P<H`88@P8<H``8@PH<H`X8
@Q8<H`H8@Ph48@P8@PP48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo2Ukg26<H2VLi1V]J1Vmk
1W>L26mk2V]J46Li<F<H15kg1U[F0Ukg15[F15Je0U:D0TYB0Sg_0R4820aS0PQ20PaS30Q21PaS2PQ2
4PaS1PQ23P@Q20Q220@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool:G_L6HaP<IcT6JeX4Kg/:
Li`2Kg/2Li`4Kg/:JeX>IcTaHaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P836<2248236<@2482
36<:248D36<4248B1242248:12442485Ool10001Ool001Eoo`03001oogoo009oo`YNm`IS60aW>@I[
FPA_N`YcW09_N`9cW0A_N`Y[FPiW>C5S60INm`AJeP9Nm`AJePAF]@9BU09>L`92408Q20P<H`88@P8<
Ha08@P8<H`X8@Q@<H`@8@Q848@88@PX48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg26<H
2VLi1V]J16mk4W>L0Vmk0V]J0Vmk1V]J3VLi<F<H2Ukg1U[F1UJe0Tic0T8@0RDY30aS70Q250aS0PQ2
80@Q10Q21Goo0@000Goo000EOol20003Ool8G_L8HaP:IcT6JeX4Kg/BLi`2Kg/2JeX2Kg/6JeX>IcTa
HaP:G_L6F]H6E[D2CW<2@Q029BT<36<L248D36<2248P12442484Ool20001Ool001Eoo`03001oogoo
009oo`QNm`IS60YW>@I[FPA_N`IcW0Ig_@IcW0Q_N`I[FQ1W>BmS60YNm`QJePAF]@9>L`96<@8YBP8@
Q0X<Ha88@P8<H`P8@Q8<H`@8@R048@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg1V<H2VLi
1V]J16mk1W>L1WNm1W>L26mk1V]J46Li;f<H2Ukg25[F15Je0Tic0THa0RU:0Q242PaS4PQ20PaS20Q2
4PaS10Q280@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6G_L8HaP8IcT8JeX4Kg/4Li`8Mkd6
Li`4Kg/2JeX2Kg/4JeXBIcT8HaP2IcT6HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX248@236<22486
36<B248236<8248636<4248636<6248T1245Ool10001Ool001Eoo`03001oogoo009oo`INm`QS60QW
>@Q[FPA_N`AcW0Qg_@IcW0A_N`9[FP9_N`A[FQ9W>@QS609W>@IS609W>AeS60aNm`IJePAF]@9>L`96
<@8YBP8@Q08<H`88@PH<Ha88@P8<H`P8@PH<H`@8@PH<H`H8@R@48@Eoo`40005oo`005Goo00<007oo
Ool00Woo1Ukg1V<H2VLi16]J1Vmk0W>L3WNm17>L16mk0V]J0Vmk16]J56Li16<H16Li86<H0VLi0f<H
35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L6HaP:IcT4JeX6Kg/2Li`>Mkd4Li`4Kg/2JeX2Kg/4JeXDIcT4HaP4IcTP
HaP2IcT3HaP<G_L6F]H4E[D2DY@2AS42:DX248@236<2248636<B248236<8248B36<4248T1245Ool1
0001Ool001Eoo`03001oogoo009oo`INm`AS60YW>@I[FPA_N`AcW09g_@YkgP9g_@IcW09_N`9[FP9_
N`I[FQYW>A1S609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88
@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`40005oo`005Goo00<007ooOol00Woo1Ukg16<H2VLi1V]J
16mk17>L0WNm2W_N0WNm1W>L0Vmk0V]J0Vmk1V]J6VLi46<H0VLi3V<H0VLi00=S65kgG_L035kg0U[F
0Ukg0U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L4HaP:IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`6Kg/6JeXLIcT>HaP2IcTA
HaP>G_L2F]H2G_L2F]H4E[D2DY@2BU82:DX236<22482124636<6248236<:248236<8248B36<4248T
1245Ool10001Ool001Eoo`8000=oo`INm`AS60YW>@A[FPA_N`AcW0Ag_@YkgPAg_@AcW0I_N`I[FQaW
>@iS609W>A5S60iNm`9JeP9Nm`9JePAF]@9BU09:DP8YBP8<H`88@P848@H<H`H8@P8<H`X8@P8<H`P8
@Q8<H`@8@R@48@Aoo`80005oo`005Goo00<007ooOol00Woo36<H1VLi1V]J0Vmk17>L17Nm17_N1Woo
17_N0WNm17>L16mk1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q20Q22PaS30Q21PaS1PQ2
30aS10Q290@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<HaP6IcT6JeX2Kg/4Li`4Mkd4Nmh6Ool4
Nmh2Mkd4Li`4Kg/6JeXLIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@21248248:36<<248636<6248<
36<4248T1245Ool10001Ool001Eoo`03001oogoo009oo`aS60IW>@A[FPA_N`9cW0Ag_@AkgPQoo`Ak
gP9g_@AcW0A_N`I[FQaW>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@H8@PX<HbH8@RH48@Eo
o`40005oo`005Goo00<007ooOol00Woo36<H1VLi16]J16mk0W>L17Nm17_N27oo17_N0WNm17>L16mk
1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240PQ20P@Q1PQ22PaS9PQ29P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool<HaP4IcT6JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`6Kg/4JeXPIcT:HaP2
IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224841248248636<V248V1245Ool10001Ool001Eoo`03
001oogoo009oo`aS60AW>@I[FP9_N`AcW09g_@AkgPYoo`AkgP9g_@AcW0I_N`A[FR1W>@YS609W>A=S
60iNm`IJePAF]@9BU096<@8]J`8DY@88@P@48@P8@PH<HbH8@RH48@Eoo`40005oo`005Goo00<007oo
Ool00Woo26<H26Li16]J16mk0W>L0WNm17_N3Woo0W_N0WNm17>L1Vmk16]J8VLi7f<H35kg1U[F15Je
0U:D0THa0Re[0QBU0PQ210@Q0PQ20P@Q1PQ210aS80Q20PaS10Q29P@Q1Goo0@000Goo00000goo0000
000300000goo000000020003Ool20005Ool00`00Oomoo`02Ool8HaP8IcT4JeX4Kg/2Li`2Mkd4Nmh>
Ool2Nmh2Mkd4Li`6Kg/4JeXRIcTOHaP<G_L6F]H4E[D2DY@2AS42;F/25:D224841242248212462484
36<P248236<4248V1245Ool10001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<0
07ooOol00Woo1V<H26Li1V]J0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F
15Je0U:D0THa0Re[0QBU0PaS0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q1Goo0@00
0Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000goo1V<H26Li1V]J
0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F15Je0U:D0THa0Re[0QBU0PaS
0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q17oo0P000Goo0003Ool00`00Oomoo`03
Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li1V]J16mk0W>L0WNm
0W_N4Woo17_N0WNm0W>L1Vmk1V]J6VLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS60PaS0PQ20P@Q0PQ2
0P@Q0PQ210@Q:0Q2:0@Q1Goo0@000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo009oo`03001oogoo009oo`AS60QW>@I[FPA_N`9cW09g_@9kgQ9oo`AkgP9g_@9cW0I_N`I[
FQYW>BMS60QNm`QJePAF]@9BU09:DP8aS08HaP8<H`88@P848@88@P848@88@P@48BP8@RP48@Eoo`40
005oo`000Woo0P0017oo0P0017oo0P001Goo00<007ooOol00Woo16<H1VLi1V]J16mk0W>L17Nm0W_N
57oo0W_N0WNm0W>L1Vmk1V]J76Li2V<H16Li3V<H0Ukg0f<H0Ukg16<H1Ukg25[F15Je0U:D0TYB0SF]
0R480Q240PQ20P@Q0PQ20P@Q0PQ210@Q0PQ20P@Q40Q210aS40Q2:0@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool4HaP6IcT6JeX4Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`6Kg/6JeXLIcT:HaP4IcT>HaP2
G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@22482124224821242248412422482124@
248436<@248X1245Ool10001Ool001Eoo`03001oogoo009oo`9S60IW>@I[FPA_N`AcW09g_@AkgQAo
o`9kgP9g_@9cW0I_N`I[FRYW>@iS60MNm`AS60INm`QJePAF]@9BU09:DP8mk`8U:@8DY@88@P848@H8
@P@48@88@PP48@X8@PP<H``8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo0V<H1VLi1V]J16mk
17>L0WNm17_N57oo0W_N0WNm0W>L1Vmk1V]J:VLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY
0QBU0PQ20P@Q1PQ210@Q0PQ220@Q2PQ220aS30Q2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool8
IcT8JeX2Kg/2Li`4Mkd4NmhBOol4Nmh2Mkd2Li`2Kg/2JeX2Kg/8JeXRIcTHHaP=G_L8F]H4E[D2CW<2
AS42@Q02<H`27>L236<624841242248:1246248436<6248236<4248236<6248X1245Ool10001Ool0
01Eoo`03001oogoo009oo`QW>@Q[FP9_N`9cW0Ag_@AkgQ9oo`AkgP9g_@9cW09_N`9[FP9_N`Q[FR9W
>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`H8@P@48@88@PX48@H8@P@<H`H8@P8<H`@8@P8<
H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li1V]J16mk0W>L0WNm17_N57oo0W_N17Nm
0W>L0Vmk0V]J16mk26]J86Li66<H3Ekg25[F0UJe0U:D0Tic14Ha0SW>0RDY0QBU1PQ240@Q5PQ20PaS
1PQ2:0@Q1Goo0@000Goo000EOol20003Ool8IcT6JeX4Kg/2Li`2Mkd4NmhDOol2Nmh4Mkd2Li`2Kg/2
JeX4Kg/8JeXPIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D6248@124F248236<6248X1244
Ool20001Ool001Eoo`03001oogoo009oo`QW>@A[FPI_N`9cW09g_@AkgQAoo`9kgPAg_@9cW09_N`9[
FPA_N`i[FP9W>@A[FQAW>AQS60eNm`9JeP9Nm`AJeP9F]@9BU09>L`A6<@8mk`8aS08Li`8<H`@8@Q@4
8A88@P8<H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li16]J1Vmk0W>L0WNm17_N57oo
0W_N17Nm0W>L0Vmk0V]J16mk3V]J0VLi16]J56Li66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha0Sg_
0S6<0QcW0PaS10Q250@Q4PQ20PaS1PQ2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4
Kg/4Li`2Mkd4NmhDOol2Nmh4Mkd2Li`8Kg/FJeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2
BU82AS44@Q02>Lh29BT248@4248F124<248636<4248Z1245Ool10001Ool001Eoo`03001oogoo009o
o`IW>@I[FPA_N`AcW09g_@AkgQAoo`9kgPAg_@9cW0Q_NaI[FQ9W>@QS60AW>@eS60aNm`9JePANm`9J
eP9F]@9BU09:DP96<@A2408icP8U:@8@Q0@8@QH48@`8@PH<H`@8@RX48@Eoo`40005oo`005Goo00<0
07ooOol00Woo1VLi1V]J16mk17>L0WNm0W_N57oo17_N17Nm0W>L1Vmk26]J26Li26]J4VLi26<H16Li
3F<H35kg0U[F15kg0U[F0UJe0U:D0TYB0THa0Sg_0THa0T8@0S6<0QS60PaS10Q26P@Q40Q2:P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4Kg/4Li`2Mkd2NmhDOol4Nmh4Mkd2Li`6Kg/8JeX8
IcT8JeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`26<H236<4
248J124@248Z1245Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0
ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool0
01Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Transpose[w] . compressedwSpec . w, 
      Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
728DAEA7A3A3A2A5A7A9ACADAEB0B3B2B2B2B2B1B1B1B1AEACAAA7A6A5A4A3A3A2A1A1A1
A1A1A1A1A1A2A2A1A09E9C9E9FA0A2A1A0A09F9F9F9F9F9F9F9FA09E9D9B99999A9A9B99
979797938F8D8D81776C5F5E5D5954555656555656575758585859595A5A5B5B5A5A5A59
595857575757575758595A595757575351483857
697A8F8A87878788898A8A8B8C8C8D8D8D8D8D8D8D8C8C8B8B8A89898988888888878787
87878687888A8B8987858285878A8D8C8B8B8A8A8A8A898A8B8C8D8B8988868787878887
87878787868687827E797474747372727271707172737373737373737374747474747575
747474747473727476787B7A787A7F7166574157
60636866656565646362626161605F606060606060605F60626364646566676767676767
676766686A6C706C696661666A6E73727171717171706F717273757372716F7070707071
737474777A7D7F83868A8D8F909396949392919293949695949393939392929393949595
96969796969492979B9FA4A4A4AAB59A846C4E58
5C68777370706F6F6F6E6E6D6D6D6D6D6D6D6C6D6D6D6D6E6E6F6F707070717171717171
717070717273757372706C7073767A797878787878787778797B7C7A7876747677787979
7A7B7B7D7F808283858688898A8B8D8C8C8B8B8B8C8C8C8C8C8C8D8C8C8C8C8D8D8E8F8F
8F8F8F8F8F90908F8E8F908A8582827265533B4D
586B837C7878767676767676767676757575757576767777777777777777787878787878
777777777778797877767477797C7E7D7D7C7C7C7C7D7C7D7E7F817F7D7A76797B7D7F7F
7F808081828283838484848586878888878787878787868788888989898988898A8A8B8B
8B8B8A8B8B8D908A858280756B6258514B3E2C44
516A89817B7A787878787878787878777777767778797A7A7A7A7A7A7A7979797A7A7A7A
7979797978787878787878797B7D7F7E7D7D7C7D7D7D7E7F808184807D7A75797C7F8282
82828383838383848484848586878888888888878786848687898A8A8A8A898A8B8B8C8C
8C8B898C8F939A8F857F7C6959473133332B1D39
496990867E7D7B7B7B7B7A7A7A7B7B7A7A7978797B7C7E7E7D7D7D7D7D7C7C7C7C7C7D7C
7C7C7B7B7A7977797A7B7B7C7D7F807F7E7D7C7D7E7F7F80818387827E7A73797E828786
85858685858483848484848585868887878889878684818486898B8B8A8A8A8B8B8C8D8C
8C8A878E949DAA9889807B5E4527020D16130A2C
4D6B9086807E7C7D7D7D7C7C7C7C7B7B7B7A7A7B7C7D7E7E7D7D7E7D7D7D7D7D7D7D7D7D
7C7C7C7B7A7977797A7C7D7E7E808180807F7E7F80808081818385817F7B767B7E828585
858586858585858586868687878888888889898887868587888A8C8C8B8B8B8C8C8D8D8D
8D8D8E8C898A8E7F71665D4B3B270E161C191030
4F6D918781807E7E7E7F7F7E7D7D7C7C7C7C7C7C7D7D7E7E7E7E7E7E7E7E7E7E7D7D7D7D
7D7D7D7C7B7977797B7D7F7F808182818181818181818282828283817F7C797C7F828584
8585868686868787878888888889898989898989898887898A8B8D8D8C8C8C8C8D8D8E8D
8D8F9289807A75685B4F433A3124151B201D1534
516E928882818080808081807F7E7C7D7D7E7E7E7E7E7E7E7E7E7F7F7F7F7F7E7E7E7E7E
7E7E7E7C7B7976797C7E8181818283838383838383838383828282807F7D7B7D80818484
848586868788888989898A8A8A8A8A8A8A8A8A8A8A8A8A8B8C8D8E8E8E8D8D8D8E8E8E90
91969F8C7B6E605346362524221D161B201E1635
526F93898483818282828381807E7C7D7E7F807F7F7E7E7E7E7F7F7F7F7F807F7F7E7E7E
7E7F807D7B7874787C7F83838383848485858685858585848281807F7F7E7C7E80818283
8485868788898A8A8B8C8D8C8C8B8B8B8B8B8A8B8C8C8D8E8E8F90908F8E8D8E8F8F8E94
98A3B5957A62493B2D1900091114171B201F1937
5371958C868584848484858482817F808181828181818081818181818181818181808080
7F7F7F7E7D7B787B7E8184838384848484858585858585848382818181807F8182848585
8686878888898B8B8B8C8D8C8C8B8B8B8B8B8B8B8C8C8D8D8D8E8E8F8F8F908F8E8F908C
87878B7662513D342B1D0B111516161B201F1838
5473988E8887868686868786858482838383838383838383838384838383838382828281
81807F7F7E7D7B7E80828484848484848485858585848484838281828282828485868787
87878788898A8B8B8C8C8D8C8C8C8B8B8B8B8B8C8C8C8C8D8D8D8D8E8F90918F8D8E9084
786F665A4D40312C271E14161817161B201E1838
55749A918A8A888888888988878685858585848585858585858686858585848484848482
81807F7F7F7F7E8081838484848484848485858585858584838281838485868687888A89
888887888A8B8D8C8C8D8D8D8C8C8C8C8C8C8C8C8C8C8C8C8C8C8B8D8F9194928F929981
6C59433D362C201F1E1B17181817151A201E1738
56769C938C8C8B8B8A8A8A8A898888878786858686878787878889888787868685858584
82807E7F80818182838384848484848484848585848585848382808385878A8A8A8B8C8B
8A8886888A8C8E8E8D8D8D8D8D8D8D8C8C8C8C8C8C8C8C8B8B8A888C8F939796949BA983
6140181B1B140B1014171B1A1917151A1F1E1738
5878A0958F8E8D8D8D8D8D8C8B8A89898989898989898989898989898888888787878785
8482808283838484858586868686858686868786868584858584848587888A8A8A8B8C8C
8B8A898A8B8C8D8D8E8E8F8E8E8D8C8D8D8D8D8D8D8D8D8D8D8D8C8E8F91968D84818168
51391D1E1E18121517181A191917151A201F183A
597AA39891908E8F8F8F8F8E8D8C8B8B8C8C8C8C8B8B8B8B8B8A8A8A8A89898988888887
8684838485868687878788888787878888888988878684858686878888898A8A8B8C8D8C
8C8C8B8C8C8C8C8D8E8F908F8E8D8C8D8D8D8E8E8E8E8F8F8F90908F8D8F948475695E50
42311E1F1F1B1718191919191817151A201F183B
5B7DA69B94929091919191908F8E8C8D8E8E8F8E8E8E8D8D8D8C8C8B8B8B8A8A8A8B8B89
87858284868789898989898989898889898A8B898886838587888A8A8A8A8A8B8C8C8D8D
8D8D8E8D8D8C8B8D8E9092908F8E8C8D8D8E8E8F8F8F8F909192949290939A8069533A35
2F25181A1B1A1919191918181817141A2120193C
5D7FA99E9694929393939492918F8D8F909091919090908F8F8E8D8D8D8C8B8C8D8E908C
88847F8386898C8C8B8B8B8A8A8A8A8A8B8C8E8B88858185878A8D8C8B8B8A8B8C8D8E8E
8F8F918F8E8C8A8D8F919592908D8A8C8D8E8F8F9090909294969997959BA8805E3A0F16
1915111417191C1A191817171716141A2120193D
5E81AB9F98979495959596959493919293949593929291908F8E8D8E8E8E8F8D8C8B898A
8B8C8D8D8D8D8E8D8D8C8C8C8C8C8C8C8C8D8E8C8A8885888A8C8E8E8D8D8D8D8E8E8F8F
8F9091908F8E8C8E90929492918F8E8F8F909091919292939294988E858180664F35171B
1C19151718191A1A1A1A19191918151B22211B3F
6082ACA19A99979797989897979695959696979594929190908F8D8E8F90918E8C888289
8E939A9693918F8F8F8E8D8E8E8E8E8E8E8E8E8D8C8B898B8C8E908F8F8F8F8F8F8F9090
90909190908F8F909192949392919091919191929294959391929686766A5E4F412F1B1D
1E1B18191A19191A1A1B1C1B1B19161D23231C40
6284AEA39C9B999A9A9A9B9B9B9B9A9B9B9C9E9B999795949493919294969A938E877C87
9099A59E989490908F8E8D8E8F919391908F8E8E8E8D8C8E8F9092919191919191919091
91919191919190919293939393939393939292939495979592959C826B543B363025181A
1C1B1B1A1A19181A1B1C1E1D1C1A171E25241E42
6386B0A59E9D9B9C9D9E9E9FA0A1A2A3A4A5A8A4A29F9C9C9B9A979A9DA1A89C92867584
919EB0A59D978F8F8F8D8A8E9194999592908D8E8F8F8F90929394949494949393929191
919191919292939393939394949597969594929496979A98969CA9815F3B10171B181517
191B1E1C1B19171A1B1E201F1E1C181F26262044
6487B2A7A09F9E9E9E9E9E9C9B9A999998979794918F8C8B8A898788898A8C8986807788
96A6BBAFA59E969797979695949290919191919192929292939394949494949393939292
939393939393949494949494959596969595949595989C938A86876B5237171C1E1B1719
1A1B1C1B1A19181A1C1D201F1E1C192026261F44
6589B4A9A2A1A09F9E9D9D9A979592908D8B888683817E7D7C7B7979787775787C7C798B
9BAEC6B8ADA59A9D9E9FA19B9691898D9092959594949494949494949494949493939393
949595959595959595949495959696969696969695989E8D7E73695746321A1D1F1C191A
1B1B1C1B1A19181A1C1E201F1E1D1A2027261E44
678BB8ADA6A6A7A4A2A1A09B96918D88847F7A7774716D6C6B696866645F58636E73768C
9FB8D7C6B9AFA3A6A8AAAFA3998E7F888E93999897979796959493939494949494949394
9596989796969696959594959696979797979697979CA68D76624D433829171A1C1C1B1B
1B1B1B1A1A19181A1C1E201F1F1E1C2128261E45
698EBCB2ADAEB0ADA9A8A79F968F888079706764615C57565452514C483F314659646E8A
A4C5EFDAC9BEAFB3B5B8C0AD9D8A72808B949E9C9A9A9A98969592939393939494949495
97989A99989897979695949596969797989796999BA4B48F6F502C2B281E13171A1B1D1C
1B1A19191919181A1C1E2020201F1D2328261D45
678BB8ACA3A2A09D9996948F8A85817C78736E6C6B686665656463615F595061707B8697
A7BDD9C7B9AEA0A5A9AEB5A89D91818A92979E9C9B9B9B9A989795969696969696969697
98999A9999989898979796979797989898999C969191957960472928261F16181A1B1C1B
1B1B1B1B1B1A1A1B1D1E2020201F1D2228261E45
6488B4A59A96928F8B8884827F7D7A78777573737372727272727372726F6A78848F9BA2
AAB6C7B9ADA1939AA0A5ADA59E978E93979A9E9D9C9C9C9B9A9998989898989898989798
99999A9A999999999999989999989899999BA09387807A65523D2425231E181A1B1B1B1B
1C1D1D1D1D1C1B1D1E1F2020201E1C2228271F44
6488B5A2948D84817D787272727170717273737577787A7B7C7D7E7F81807E8B96A3B2AF
AEB1B6AAA093838E979EA8A3A09D9A9B9D9E9F9E9E9E9E9D9C9B9A9A9B9B9B9A9A999999
9A9A9A9A9A9A9A9A9A9A9B9A9A9998999A9FA894817263534330191C1E1C1A1A1A1A191B
1C1E201F1E1E1D1E1F1F2020201E1C2228272145
658AB9A18E8275706C645B5F626363676B6F73777A7F838586888A8E929495A1ACBBCEBF
B2AAA1978E806E7E8B96A3A2A2A4A8A5A3A2A0A0A09F9F9E9E9E9D9D9D9D9D9C9C9B9A9A
9A9A9A9A9B9B9B9B9C9C9E9C9B99969A9DA6B4967B644A3E32200A1217191C1B1A19171A
1D1F232120201F1F20202020201E1B2229282246
5D7DA593867E75726F6B64686B6C6D7174787C7F8285898B8D8E9093979999A2ABB5C3B9
B2ADAAA1998F818A92979D9EA0A3A7A5A3A2A0A0A0A0A0A09F9F9E9E9E9E9E9D9D9D9C9C
9C9C9C9C9C9C9D9D9D9D9D9D9C9C9C9B989CA4886E573C362E211216191A1B1B1B1B1A1C
1D1F2120201F1F1F20202020201E1C2228272141
567194877E797473726F6B6F727375797C808486898C8F91939597999C9E9FA5ABB2BAB6
B2B1B0A9A29B92959798989B9FA3A7A5A3A2A1A1A1A2A2A1A1A0A09F9F9F9F9E9E9E9E9E
9E9E9E9E9E9E9E9E9E9D9D9D9E9FA29B9492957A624A2E2C2921181A1B1B1B1B1C1C1C1D
1E1E1F1F1F1F1F2020202020201F1D212726203D
4D6481797372707070706E7275787A7E82878B8E909396989A9D9FA1A4A6A9ABAEB1B5B3
B2B2B3AEA9A49F9D9B968F979DA4ACA8A5A3A1A2A2A3A3A3A2A1A1A1A0A09FA0A0A0A0A0
A0A09FA0A0A0A0A09F9E9D9E9FA3A89D928D8C70573B191F211E1C1C1C1C1B1C1D1E1F1E
1E1E1D1E1F1F202020202020201F1D2125252038
4354696766696B6C6E6F7075797C7F84898E9496989B9DA0A3A5A8AAADB0B3B2B0AFADB0
B1B4B7B3B0AFAFA69D9283909BA5B2ACA8A4A0A2A3A4A5A4A3A3A2A2A1A1A0A0A1A2A2A2
A2A2A2A2A2A2A3A1A09E9C9FA2A7B0A0928A87674A29010E171B201E1D1C1A1C1E1F2220
1F1D1B1D1E20212120202020201F1E2124231F32
475A726E6C6E6F717475777B7F8285898E9297999B9EA1A3A5A8ABACAEB1B4B3B3B3B3B4
B5B7B9B6B2B1B1A9A39A8F979DA2A9A7A5A5A4A5A5A5A6A5A5A4A4A4A3A3A2A2A3A3A4A3
A2A2A1A1A1A2A2A1A1A09FA0A0A5AD9986786B56412809131A1C201F1E1D1C1D1E1F2120
1F1E1D1E1F20212020202020201F1E2124231F34
495E787371727376797B7D8184888B8F92969B9D9FA2A4A6A8ABADAFB0B2B4B5B5B6B7B8
B8B9BBB8B5B4B3ADA8A29A9D9FA0A1A2A4A5A7A7A7A7A7A7A6A6A5A5A5A4A4A4A4A5A5A4
A3A2A1A1A1A1A2A1A1A1A2A09FA2AA917B67534538260F171C1D201F1E1E1D1E1F1F2020
1F1F1E1E1F20202020202020201F1E2125241F35
4A607A75737474797D8084878A8E9195989B9FA1A4A6A9ABADAFB1B3B4B5B7B7B8B9BABB
BBBCBDBBB9B8B8B2ADA8A2A1A09D999EA2A6ABAAA9A9A9A8A8A7A7A7A7A6A6A6A6A7A7A5
A4A2A0A1A1A1A1A2A2A2A3A2A0A4AE8E725637332D2012171C1E21201F1F1F1F1F202020
1F1F1F1F1F20202020202020201F1D2125241F36
4B617C777576767B81858B8E9195989B9EA1A4A6A9ABAEB0B1B4B6B7B7B8B9BABBBCBEBE
BEBFC0BEBDBDBDB8B3AFABA5A0998E98A0A8B1AEACABABAAAAAAA9A9A9A9A9A9A8A9AAA7
A5A29FA0A1A1A1A2A2A3A5A4A2A8B78D6943171D1F1A14181C1E22212121212120202020
202020202020202020202020201F1D2125231E36
4D64807C7A7B7B8085898E9194979B9DA0A3A6A8ABADAFB1B3B4B6B7B9BABBBCBDBEC0C0
C0C1C2C0BEBEBEB9B5B2AFAAA59D949BA1A6ADABAAAAAAAAA9A9A9A9A9A9A9A8A8A8A8A7
A5A3A1A2A2A2A2A3A3A5A9A199979A7A5D3E191E201B161A1C1E21212020202020202020
202020202020202020202020201F1D2125231E37
4F6784807E808185898D9194979A9DA0A3A6A9ABADAFB1B3B4B6B7B8BABBBDBEBFC0C2C2
C2C3C4C2C0BFBFBBB8B6B4AEA9A2999EA2A5A9A9A9A9A9A9A9A9A9A9A9A9A9A8A8A7A7A6
A5A4A3A3A3A3A3A4A4A7AE9E908881685238191E1F1C181B1D1F21202020202020202020
202020202020202020202020201F1D2125231E38
506987838284868A8D9195989B9DA0A3A6A9ACAEB0B2B4B5B6B7B8BABCBEBFC1C2C3C5C5
C5C5C6C4C2C1C0BEBCBABAB3ACA49B9FA3A5A7A7A8A8A9A9A9A9A9A9A9A9AAA9A8A7A6A6
A6A5A5A5A5A4A3A5A5ABB49E8A7A6A57452F14191C1B1A1C1D1F21202020202020202020
202020202020202020202020201F1D2125231D38
526C8A8786888B8F92969A9C9FA1A4A7A9ACAFB1B3B5B8B8B9B9B9BCBEC0C2C3C5C6C8C8
C8C8C9C7C5C3C2C1BFC0C2B8B0A79CA0A3A4A5A6A6A7A9A9A9A9A9A9A9AAABA9A8A7A5A6
A6A7A7A6A6A5A3A6A8B0BE9F836B504437240D14191A1C1D1E1F20202020202020202020
202020202020202020202020201F1D2125231D39
546F908B8A8C8E9295989C9EA0A3A5A8ABAEB1B2B4B5B7B8B9BABABCBEC0C2C3C4C6C7C7
C7C8C8C7C5C4C3C2C0C0C1BAB3ABA3A4A5A4A2A4A6A7A9A9A9A9A9A9A9AAAAA9A8A7A6A6
A7A7A8A7A7A6A5A5A4A9B3957B63483E342411161B1C1D1E1E1F20202020202020202020
202020202020202020202020201F1D2125241D3A
577395908E909295989B9EA0A2A5A7AAACB0B3B4B5B6B7B8BABBBCBDBFC1C3C4C4C5C7C7
C7C7C8C7C6C5C4C3C1C1C1BBB5AFA9A8A6A3A0A3A5A7AAA9A9A9A9A9A9AAAAA9A8A8A6A7
A7A8A9A8A7A7A7A4A0A2A98C735A3E38302313181C1D1E1E1F1F20202020202020202020
202020202020202020202020201F1D2126241D3C
59779A95929496999B9EA1A3A5A7A9ACAEB2B5B6B6B7B8B9BABCBDBEC0C2C3C4C4C5C6C6
C7C7C8C7C7C6C6C4C3C2C3BDB8B3AFABA8A39CA1A5A7ABAAAAAAA9AAAAAAAAAAA9A8A7A8
A9A9AAA9A8A8A9A49E9FA4866B4F302E2A2015191C1E201F1F2020202020202020202020
20201F202020202020202020201F1D2126241D3D
5C7BA09A97999A9D9FA1A4A5A7A9AAADB1B4B9B8B8B8B7B9BBBDBEC0C1C2C4C4C4C5C5C6
C6C7C8C8C8C8C8C6C5C4C4BFBBB8B5AFAAA2989FA4A8AEACABABAAAAAAABABABAAAAA9AA
AAABADABAAAAABA49D9DA18063441F22231D161A1D1F2221202020202020202020202020
201F1F1F1F20202020202020201F1D2126251D3F
5D7DA29C999B9C9EA0A3A5A7A9ABADAFB2B5B8B8B8B9B9BBBCBDBFC0C1C3C5C5C6C6C7C7
C7C7C8C8C7C8C8C7C5C4C4C0BCBAB8B1ABA49A9FA3A5A9A8A8A9A9A9A9A9A9A8A8A7A7A7
A8A9AAA9A8A9ADA196908D735B402224241E181B1E1F2120202020202020202020202020
202020202020202020202020201F1D2127251D3F
5E7EA59E9B9C9EA0A2A4A6A8ABADAFB1B3B5B7B8B9BABBBCBDBEBFC1C2C4C6C6C7C8C9C8
C8C8C7C7C7C8C8C7C6C5C5C1BEBCBAB3ADA59C9FA2A3A4A5A6A7A8A8A7A7A6A6A6A5A5A5
A6A7A7A7A6A9AF9E8F847B66533C232424201A1C1E1F2020202020202020202020201F20
202021202020202020202020201F1D2127251D40
6080A8A19D9FA0A2A4A6A8AAADAFB2B3B5B6B7B9BABBBCBDBEBFBFC1C3C4C6C7C8C9CBCA
C9C8C6C7C8C8C9C8C6C6C6C3C0BEBEB6AEA69C9EA0A1A1A2A4A6A8A7A6A5A4A4A4A3A3A3
A4A4A5A5A5A9B29C897968594A37212323201C1E1F1F2020201F1F1F202020201F1F1F1F
2020212120201F2020202020201E1C2127251D41
6183ABA49FA1A2A4A6A8A9ACAFB2B6B6B6B7B7B9BBBDBFBFBFBFBFC1C3C5C7C8C9CBCECB
C9C8C5C7C8C9CAC9C7C7C6C4C2C1C3B9B0A69B9D9F9E9D9FA2A4A8A6A4A3A1A1A1A1A0A1
A2A2A2A4A4ABB69B826C544A40301E2122211F20202020201F1F1F1F1F2020201F1E1E1F
1F20212120201F2020202020201E1C2127251D41
6284ADA5A1A3A4A6A8A9ABAEB0B3B6B6B7B7B8BABBBCBEBFC0C0C1C2C4C6C8C9C9CBCDCB
C9C8C6C7C8C8C9C8C7C7C7C4C2C1C2B9B1A9A0A0A09D9A9DA0A3A6A5A3A3A2A2A2A1A1A1
A2A2A3A3A2A7B2967D664C453C2F202223211F1F20202020202020202020202020202020
2122232221201F2020202020201E1C2127251D42
6285AEA7A3A5A7A8AAABADAFB1B4B6B7B7B8B9BABBBDBEBFC0C1C2C3C5C7C9C9C9CACCCA
C9C8C7C7C8C8C8C7C7C7C7C5C2C1C1BAB3ACA5A3A19D979B9FA2A5A4A3A2A2A2A2A1A1A1
A2A2A3A2A0A4AD91775F443F392E212223211E1F1F1F1F202021222121201F2021212122
2223252322211F1F20202020201E1C2227251D42
6386B0A9A5A7AAABACADAEB1B3B5B8B8B8B9B9BABCBDBEBFC1C2C3C5C6C7C9C9CACACBCA
CAC9C8C8C8C8C7C7C7C7C7C5C3C2C2BBB5AFA9A5A19B93999DA0A5A3A2A2A2A2A2A2A1A2
A2A2A2A19FA3AD8D72573736332B222323211F1F1F1F1E1F2021232221201F2021222323
2425262423211F1F20202020201E1C2227251D42
6487B1ABA7AAADAEAEB0B0B2B4B6B9B9B9B9B9BBBCBDBEC0C1C3C5C6C7C8CACACACACBCA
CAC9C9C9C8C7C6C7C7C7C8C6C4C3C2BCB7B2AEA7A1998F959B9FA5A3A2A2A2A2A2A2A2A2
A2A1A1A09EA3AF8C6D4E282C2D28242322211F1F1E1D1C1E2021242221201E2021232425
2527282624211F1F20202020201F1C2227251C42
6589B3ACA8ABADAEAFB0B1B3B4B6B8B9B9BABABBBCBDBEC0C1C3C4C5C7C9CBCBCACBCBCA
C9C9C8C8C7C7C6C7C7C7C8C6C3C2C2BCB8B4B1AAA39B90969A9EA2A1A0A0A0A0A0A0A0A0
A0A2A49F99999D80664C2C2E2E29242323211F20202121222324252423211F2122242525
2526282623211F1F20202020201E1C2228261D43
668AB5AEAAACAEAEAFB1B2B3B5B6B8B8B9BABBBCBDBEBFC0C1C2C3C5C7C9CCCBCBCBCCCA
C9C8C7C7C7C7C6C6C6C7C8C5C3C2C1BDB9B6B3ACA59D92979A9C9F9E9E9E9F9F9E9E9E9F
9FA2A79D938F8D7660492E2F2E29242323211E2022242625252626252423212223242626
2627282523221F20202020201F1E1C2228261E45
688CB7AFABADAEAFB0B1B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C2C5C7CACDCCCCCCCCCB
C9C8C6C6C6C6C6C6C6C7C8C5C3C1C0BDBAB8B7AEA69D9296999A9C9C9C9D9D9D9D9C9B9D
9FA3AA9C8F867F6C5A462E2F2E29242423211E2124262928282828272624222325262726
2627282624221F20202020201F1E1C2228271F46
698DB9B1ACAEAFB0B1B2B3B4B5B6B7B8B9BBBCBDBEBFC0C0C1C1C1C4C7CACFCDCCCCCDCB
C9C7C4C5C6C6C6C6C6C7C7C5C3C1BFBDBBBBBCB1A89D909497989A9A9A9B9C9B9B9A999C
9EA4AE9B8A7D716253422E2F2E2A252424211E2225282C2B2A2A2A292726242526272827
27272826242220202020201F1F1E1B2229282047
6A8FBBB2ADAFB0B1B2B3B4B5B6B6B7B8BABBBCBDBEBFC0C1C2C3C3C6C8CBCFCDCCCCCCCB
C9C7C5C5C6C6C6C6C6C7C7C5C3C1C0BEBBBBBBB2AAA2979999989698999A9B9B9A99989B
9DA2AC988576655A4E3F2F2E2C28232323211D23272C312E2C2B29282726242526272827
2727282624221F202020201F1F1E1B2229282148
6B90BDB4AEB0B0B1B2B4B5B6B6B6B6B8BABBBDBDBEBFC0C2C3C4C6C8C9CCCFCDCCCCCCCA
C9C7C5C6C6C6C6C6C6C7C8C5C3C2C0BEBCBBBBB4ADA69E9D9B97939597989A999998979A
9BA1AB94806E5A52493D2F2D2B27222222201D23282E36312E2B28282726242526272727
2727282523211F1F202020201F1E1B2229282148
6C92BFB5B0B0B0B2B3B5B7B6B6B6B6B8BABBBDBEBFBFC0C2C4C6C8C9CBCDCFCECDCCCCCA
C9C7C5C5C6C6C6C6C6C7C8C5C3C2C0BEBCBCBCB5AFAAA4A09C968F9395979A9998979698
9AA0AC917A654C48433A302D2A262021211F1C242B333E37312D28282826252626272727
2727282523211E1F1F20201F1F1E1B2229292149
6D93C2B7B1B1B0B2B4B6B8B7B7B6B5B8BABBBDBEBFC0C0C3C5C8CBCCCDCED0CFCDCCCBCA
C8C6C4C5C6C6C6C6C6C7C8C5C3C2C0BFBDBCBCB7B2AEABA39D948A8F93969A9997969497
98A0AD8F755B3C3D3C37312D2A241E1F201E1A252F3A493E362F27282827262626272727
2627272523201D1E1F1F201F1F1D19212929224A
6E94C2B8B2B2B2B3B5B6B8B7B7B7B6B8BABCBDBEBFC0C0C3C5C7CACBCBCDCECDCCCCCCCA
C9C8C6C6C6C6C6C6C6C7C7C6C4C2C1BFBEBDBCB8B3B0ADA69F978D909394959595959596
969CA78B71593C3C3A342E2B28241E20211F1D242B333D36302C27272727262627272827
2727282624221F2020202020201F1C232B2A234B
6F95C3B9B3B3B3B4B5B6B7B7B8B8B7B9BBBCBEBEBFC0C1C3C5C7C9CACACBCCCCCCCCCCCB
CAC9C8C7C7C6C6C6C6C7C7C6C4C3C2C0BEBDBDB8B4B2B0A8A1998F919292919293949595
9498A2876E563A3A37312A2826231E2021201F24282C332F2C2926272726262627272828
28282826252321212120202021201F252C2B234B
7095C3B9B4B4B5B5B6B7B7B8B8B8B8BABBBCBEBFC0C1C1C3C5C7C9C9C9CACACBCBCCCCCB
CBCACAC9C8C7C5C6C6C7C7C6C4C4C3C1BFBEBDB9B6B4B4ABA39A9091918F8C8F91939594
92959E836A523636342E272625221E1F2121212325272928272626262626262727282928
282829272624232222211F21222221272E2C244C
7096C4BAB5B6B6B7B7B7B7B8B8B9B9BABCBDBEBFC0C1C1C3C5C7C9C9C8C8C8C9CACCCDCD
CCCCCCCAC9C7C5C5C6C7C8C6C5C4C3C2C0BEBDBBB8B7B8AEA49B908F8F8B878B8E919693
90939B7F664E3131302B242423201D1F21222422211F1D1F212325252526262727282929
29292A282726252423211F21232424292F2D254D
7197C5BBB5B6B7B7B7B7B7B8B9B9BABBBCBDBEBFC0C1C2C4C5C7C9C8C9C9C9CACACBCBCB
CBCBCBCAC8C7C5C6C6C6C6C6C5C4C4C2C0BFBDBBB8B7B8AFA7A09795928D878B8E919491
8D8F957B644C31312F29232222201E1F2122232222222123232425262626262727282929
292929282725242423222122242423292F2D254D
7197C5BBB6B6B7B7B7B7B6B8B9BABBBCBCBDBEBFC1C2C3C4C5C7C8C8C9C9CACACACACACA
CACACAC9C8C7C6C6C6C5C5C5C5C5C5C3C1BFBDBBB9B8B7B0AAA49D99958F888B8D90938F
8A8B8F77614B31312E28212121201E202121222323242425252626262626262728282929
292929282625242424242324252423292F2D254D
7198C6BCB6B7B8B7B7B6B6B7B9BABCBCBDBDBDBFC1C2C4C5C5C6C7C8C8C9CBCAC9C9C8C8
C9C9C9C8C8C7C6C6C5C5C4C4C4C5C6C3C1BFBDBCBAB8B8B2ADA8A49E9790868A8D8F938D
88878A735F4A32302D261E1F201F1F202021212224252626262627272726262728292A29
292929282725242425252525262523292F2E254E
7298C6BDB7B8B9B8B7B6B4B7B9BBBDBDBDBDBCBFC1C3C5C5C5C5C5C7C8C9CBCAC8C7C5C6
C7C8C9C8C7C7C7C6C5C4C3C4C4C5C7C4C2C0BEBCBAB9B9B4B0ADACA29A9084888B8E928C
858485705D4933302C241A1D1F1F1F1F2020202224262828272727272727262728292A29
29292928272524252626282727252329302E254E
7299C8BDB7B8B8B8B7B7B6B8BABBBDBEBEBEBEC0C2C3C6C6C6C7C7C8C9CACCCBCAC9C7C8
C8C8C8C7C7C7C7C6C5C4C3C4C4C6C7C5C2C0BEBCBBB9B8B4B0AEACA49C93898B8D8E9189
827F7F6A57442E2D2A241C1E1F1F1F202122222325262727272727272727262728292A29
29282827272624252626272727252329302E254E
739AC9BEB8B8B7B8B8B8B8B9BBBCBEBEBEBFBFC1C2C4C6C6C7C8C8C9CACBCDCCCACAC9C8
C8C8C7C7C7C6C6C6C5C4C3C4C5C6C8C5C2C0BEBDBBB9B8B5B1AFAEA69F978D8E8E8E8F87
7E7A7865533F292928231D1F202020212223242525262727272727272727262728292A29
29282827272625262626272626252329302E254E
739BCABFB8B8B7B8B8B9B9BABBBDBEBFBFC0C0C2C3C5C6C7C8C9CACBCBCDCECDCCCBCAC9
C8C7C6C6C6C6C6C5C5C3C2C3C5C6C9C6C3C1BFBDBBB9B8B5B2B1B0A8A19991908E8D8D84
7B75725F4E3B252626221D1F202121222324262626262626272727272727262728292B29
29282727272626262627272726252329302E254F
749BCCC0B8B8B6B7B8B9BABBBCBDBFBFC0C1C1C3C4C5C6C8C9CBCCCDCDCECFCECDCDCCCA
C9C7C5C5C5C6C6C5C4C3C1C3C4C7CAC6C3C1BFBDBBB9B7B5B3B2B3ABA39C94928F8C8B81
77706B5948361F2223211E1F212122232426282727272626262727272727262728292B29
28272627272727272727272727252329302E254F
749CCDC1B9B8B6B8B9BABBBCBDBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCFCDCCCBCAC9
C8C7C5C6C6C6C6C5C5C4C2C4C5C7C9C6C3C1BFBDBBBAB8B6B4B3B3ACA59F9995908D8B80
756E675646341E2223211F202121212324252727262626262627272727272627282A2C2A
29282627272727272727272727252329302E254F
759CCDC1B9B8B6B8BABBBDBDBDBDBEBFC0C1C2C3C4C5C7C7C8C8C9CACBCCCFCDCBC9C8C8
C7C7C6C6C6C6C6C5C5C4C4C5C5C7C8C6C3C1BFBEBCBAB9B7B5B3B3ADA7A29E98928E8B7F
746B635344321D21232120212121212224252726262625262627272727272627292A2D2B
29282626272727272727272726252229302E2550
759DCEC2BAB9B6B9BABCBEBEBEBDBDBFC0C1C3C3C4C5C7C7C7C7C7C8CACCCECCCAC8C6C6
C6C6C6C6C6C6C6C6C5C5C5C5C6C7C8C5C3C1BFBEBCBBB9B7B5B4B3AEA9A6A39B948E897D
71675F4F41301B1F222121212121202223252726262525262627272727262627292B2E2B
29282626272727272727272726252229302E2650
769ECFC3BBB9B6B9BBBEC1BFBEBDBCBEC0C2C4C4C5C6C7C6C6C5C4C6C8CBCECBC9C6C3C5
C5C6C7C6C6C6C5C6C6C6C7C7C6C7C7C5C3C1C0BEBCBBB9B7B6B4B4B0ACAAA99E958D867A
6E645A4B3E2D181D212223222221202223242626252525252626272727262527292C2F2C
2A282526262727272727272726252229302F2651
769ECFC2BAB9B6B9BBBDC0BFBFBEBDBFC0C2C3C4C5C6C7C7C7C7C7C9CACCCECCC9C7C5C5
C6C6C6C6C6C6C6C6C6C6C6C6C6C7C8C5C3C2C0BEBDBCBBB9B7B6B5B1ADABA9A097918C7D
6F6356493C2C191E2122222222212022232526262525252526262727272726282A2C2F2C
2A282626272727272727272726252229302E2650
759ECFC2BAB9B6B9BBBDBFBFBFBFBFC0C1C2C2C3C5C6C7C8C8C9CACACBCCCECCCAC8C5C6
C6C6C6C6C6C7C7C6C6C5C5C5C6C7C8C6C4C2C0BFBEBDBCBAB8B7B6B2AEACABA29A959180
706152463B2C1A1E2122222222212122232526262525252526262727272727292A2C2E2C
2A282626272727272727272727252329302E2550
759ED0C3BAB9B6B8BABCBEBFBFC0C0C1C1C1C1C3C4C6C7C8C9CACCCCCCCDCECCCAC8C6C6
C6C6C6C6C7C7C8C7C6C5C4C5C6C7C8C6C4C2C0BFBFBEBEBBB9B8B7B3B0AEADA49C989582
705F4C43392B1A1E2121222222212122232426262525252526262727282828292A2C2E2C
2A282626272727272727272727252329302E2550
759ED0C3BAB9B6B8BABCBEBEBFC1C2C2C1C1C0C2C4C5C7C8CACCCFCECECECFCCCAC9C6C6
C7C6C5C6C7C8C9C7C6C5C3C5C6C7C9C6C4C2C0C0BFBFC0BDBBB9B8B5B2B0AFA79F9B9A84
6F5C463E36291A1E21212121212121222324262525252525262626272828292A2B2C2E2C
2A282626272727272727272727252329302E244F
759ED0C3BAB9B6B9BBBCBEBFBFC0C1C1C2C2C2C4C5C7C8C9CACCCECECDCDCECCCAC8C6C6
C7C6C6C6C7C7C8C7C6C4C2C4C5C6C8C6C4C2C1C0C0BFBFBDBBB9B8B5B2B0AFA8A19E9E87
735E4840382A1A1F222223232323222324252626262525262626262728292A2B2B2C2E2C
2A282627272727272727272727252329302E254F
759ECFC3BBB9B7B9BBBDBFBFBFC0C0C1C2C4C5C6C7C8C9CACBCCCECDCDCDCDCBCAC8C6C7
C7C6C6C6C6C7C8C6C5C4C2C3C5C6C8C6C4C3C1C1C0BFBFBDBBB9B8B5B3B1B0A9A3A1A38B
76614A42392B1A1F2223252424242424252626262626262626262627292A2B2B2C2D2E2C
2A282627272727272727272727252329302E2550
759ECFC3BBB9B7B9BBBDBFBFBFBFBFC1C3C5C7C8C8C9C9CACBCDCECDCDCCCCCBC9C8C6C6
C6C6C6C6C6C7C8C6C4C3C0C2C4C6C8C6C5C3C2C1C0BFBEBDBBBAB8B6B3B1B0ABA5A5A88E
77614841382B1B202325262626252526262627262626262627262628292A2C2C2C2D2E2C
2A292727272727272727272727252329302E254F
759ECFC2BBB9B7B9BBBDC0BFBFBEBDC0C3C6CACACACACACBCCCDCFCDCCCCCBCAC8C7C5C6
C6C6C6C6C6C7C8C5C4C1BEC1C3C6C9C7C5C4C3C1C0BFBEBCBBBAB9B6B4B2B0ACA8A8AE92
7860443E372B1B212426282827272727272727272727272727272628292B2D2C2C2D2D2C
2A292727272727272727272727252329302E254F
759ECFC3BBBAB8BABCBDBFBFBFBFBFC2C4C7CACACACACBCBCCCDCECDCDCCCCCBCAC9C8C8
C7C7C6C6C6C7C7C6C4C3C1C2C4C5C7C6C5C4C4C2C1BFBEBDBCBBBAB7B5B3B2AEAAABAF96
7E6951473D2D1A2024262827272726272727272727272727272726282A2C2F2E2E2F302D
2B292727272727272727272727252329302E2550
769ECFC3BCBBB9BBBCBDBEBFC0C0C0C3C5C7CACACACBCBCCCCCDCECDCDCDCCCCCBCBCACA
C9C8C7C7C7C7C7C6C5C4C3C3C4C4C5C5C4C4C5C3C1C0BEBDBCBBBBB8B6B5B3B0ACADB19A
84715D50422F191F24252727262626262627272727272727272726282B2E31303031322F
2C2A2727272727272727272727252229302E2550
769ECFC3BCBCBABBBCBDBEBFC0C1C2C4C6C8CBCBCBCBCCCCCCCDCDCDCDCDCDCDCDCDCDCB
CAC9C7C7C7C7C6C6C5C5C5C4C4C4C3C4C4C5C6C4C2C0BEBDBDBCBCBAB8B6B5B2AFB0B49E
8A7967564631171F24252726262625262627272727272627272726292B2E313131323430
2D2A2727272726272727272726252229302E2650
769ECFC3BCBCBBBCBCBDBDBFC0C2C3C5C7C9CBCBCBCCCDCDCDCDCDCDCDCDCECECECFD0CE
CCCAC7C7C7C6C6C6C6C6C7C6C4C3C1C3C4C6C8C5C3C0BDBDBDBDBDBBB9B8B6B4B2B3B8A3
9080715D4A33161E23252726262525252627272727262626272727292B2D2F3031333632
2E2B2727282726272727272726252229302F2751
769FD0C4BDBDBCBDBDBEBDBFC1C2C4C6C7C9CCCCCCCCCDCDCDCDCECDCDCDCDCECECECFCD
CBCAC7C7C7C6C6C6C6C6C7C5C4C3C2C3C4C5C7C5C3C1C0BFBEBDBDBBB9B8B6B4B2B2B6A4
93867B644F35161F242527262626252626272727272727272726242A2F343A3837373833
2F2B2627272726272727272726252229302E2651
769FD1C5BEBEBDBEBEBEBEC0C2C3C4C6C8CACDCCCCCDCDCDCDCECECECECECDCDCDCECFCD
CBC9C7C7C7C7C6C6C6C6C6C5C5C3C2C3C4C4C5C4C3C2C2C0BFBEBDBBBAB8B6B4B2B2B5A5
968C846B53381720252627272626262626262727272728272725222A323A443F3C3B3B35
302B2526272726272727272726252229302E2550
769FD1C6BFBFBEBEBFBFBEC0C2C3C4C6C8CBCECDCDCDCDCDCECECFCECECDCDCDCDCECFCD
CBC9C7C7C7C7C6C6C6C6C7C5C4C3C2C3C3C3C4C3C3C3C4C2C0BEBDBBBAB8B7B4B2B2B3A6
9A928F72583A16202626282727262626262626272728292827241F2B35404F4842403E38
322B2325262627272727272727252329302E2550
76A0D2C6BFC0C0C0BFBFBEC0C2C3C4C6C9CCCFCECDCDCCCDCDCECFCECECDCDCDCDCECFCD
CBC9C7C7C7C7C6C6C6C6C7C6C4C3C2C2C2C2C2C3C3C4C6C3C1BFBDBBBAB8B7B5B2B1B2A7
9D999A7A5D3C151F2627282827272727272626272728292827231C2C39485C524A46423A
342C2224262627272727272727252329302D2450
77A1D3C7C0C0BFC0C0C0C1C2C4C5C6C8CACCCECECECECFCFCFD0D1D0CFCECDCECECECFCD
CBC9C7C7C7C7C6C6C6C6C7C6C5C4C3C3C3C3C3C4C4C5C7C4C2C1BFBDBBB9B7B5B3B2B3AA
A09D9E7E6040192228282827272726262726262728292A2827241D2C3846574E47434039
332B2325262626262627272727252329302E2450
78A1D4C8C0C0BEC0C1C2C3C4C6C7C8CACBCCCECFCFD0D1D1D1D2D2D1D0CFCECECECECECD
CBC9C7C7C7C6C6C6C6C6C6C6C5C5C4C4C4C4C4C5C5C6C7C5C3C2C1BFBCBAB8B6B4B4B4AC
A3A1A38264441D252A282727272726262726262728292A2928251E2C3743534B44413E38
322B2325262626262627272727252329302E2451
78A2D6C9C1C0BDC0C2C3C5C6C7C9CBCBCCCDCECFD0D1D3D3D3D3D4D3D1D0CECECECECECC
CBC9C7C7C7C6C6C6C6C6C6C6C6C6C6C5C5C5C4C5C6C7C9C7C5C4C3C0BEBBB8B7B5B5B5AE
A6A5A987694820272B2927272727262627262627282A2B2A28251F2C3743534B44413E38
322B2325262625262627272727252329302E2551
79A4D8CAC2C0BDC0C3C5C7C9CACBCDCDCDCDCDCFD1D3D6D5D5D6D6D4D3D1CFCFCECECECC
CBC9C7C7C7C6C6C6C6C6C6C6C6C7C7C7C6C6C5C6C7C9CAC8C7C6C5C2BFBBB8B7B6B6B7B0
AAAAB18D6D4B23292D2A27272727262627262628292A2D2B29251E2C3743534B44413E38
322B2325262525262627272727252329302E2552
79A3D7CAC1C0BDC0C3C5C7C8CACBCDCDCECECED0D2D3D5D5D5D5D6D4D3D1D0CFCFCECECC
CBCAC8C8C7C7C6C6C6C6C6C6C6C6C7C6C6C6C5C6C7C8CAC8C7C7C7C3C0BCB9B8B7B6B6B1
ABACB28F704F282D2F2B26272727272727272627282A2B2A2926212C353F4C45403D3B35
312B2425262525252626272726252229302E2552
79A3D7CAC1C0BDC0C3C5C8C9CACBCDCDCECFD0D1D2D3D5D5D5D5D6D4D3D2D1D0CFCECDCC
CBCBC9C9C8C7C6C6C6C6C6C6C6C6C6C6C6C5C5C6C7C8CAC9C7C7C8C4C0BDB9B8B7B6B6B1
ACADB49273532D31312C2627282727272727262728292A292927242C333B45403C393833
2F2A2526262524252626272626252229302E2551
78A3D6C9C1C0BDC0C3C5C8C9CACBCDCECFD0D1D2D3D3D4D4D4D5D5D4D3D3D3D1D0CECDCC
CCCBCBCAC8C7C5C6C6C6C6C6C6C6C6C6C6C5C4C6C7C8CAC9C8C9CAC5C2BEBAB9B8B7B6B2
ADAFB79576573234332D25272828282727272627272829292928262C31373F3B37363431
2E2A2626262525252626272626252229302E2551
78A3D6C9C1BFBCC0C3C5C8C9CACBCDCECFD1D2D2D3D3D3D4D4D4D5D4D4D4D4D2D0CECCCC
CCCCCCCAC9C7C5C5C6C6C6C6C6C6C6C6C6C5C4C6C7C9CBCACACACCC7C3BFBBBAB9B7B6B3
AFB2BA987A5B3737352D24262828282827272626272728282929292D303338353332312E
2C2A2727272625262626272727252329302E2451
78A3D6CAC1C0BEC1C4C6C9CACBCCCDCFD1D2D5D5D5D6D6D6D6D6D6D5D5D4D4D2D0CECCCC
CCCCCCCBCAC8C6C7C7C7C7C7C6C6C6C6C6C5C5C6C7C8C9C9C8C9CAC6C3BFBBBAB9B8B7B4
B0B3BB9A7C5E3B3B372F24262828282727272627272728282929292C2F3236343231312E
2C2926262524232425252625252421282F2E2551
79A3D7CAC2C1BFC2C5C8CBCBCCCDCED0D2D4D7D7D7D8D9D9D8D8D8D7D5D4D3D2D0CECCCD
CDCCCDCBCAC9C8C8C8C7C7C7C7C6C6C6C6C5C5C6C6C7C8C7C7C8C9C5C2BFBBBBBAB9B8B5
B1B4BC9C7E62403E3A3024262828272727272727272828282929292C2E3134323130302D
2B282625242322232324252424221F262E2D2551
79A3D7CAC2C1BFC3C6C8CCCCCDCDCED0D3D6D9D9D9DADBDADAD9D9D8D6D4D3D2D0CECCCD
CDCDCDCCCBCACAC9C9C8C7C7C7C6C6C6C6C6C5C6C6C6C6C6C6C7C8C5C2BFBBBBBABAB9B6
B3B6BE9E816545413C312326282727272727272728282728292A2A2C2D2F31302F2F2F2C
2A282525242220212223242323201D252E2D2552
79A3D7CAC3C2C0C3C6C9CDCDCDCECDD1D4D7DADBDBDCDDDCDBDBDBD9D7D5D3D1D0CECCCD
CDCDCDCDCCCCCCCBCAC9C8C7C7C6C6C6C6C6C6C5C5C5C4C4C5C6C7C4C1BEBBBBBBBBBBB8
B4B7C0A084694A453E322326282727272728282828272728292A2B2C2C2C2D2D2D2D2E2B
2927262423201E1F20222322211F1A232D2D2652
79A3D7CBC4C4C2C5C8CACDCECFCFCFD3D6D9DDDDDEDFE0DFDDDCDBD9D7D5D3D2D1CFCCCD
CDCDCECCCCCBCAC9C9C8C7C7C7C6C6C6C6C6C6C6C5C5C5C5C5C6C8C5C2BFBCBCBBBBBBB8
B5B8C0A1866C4E4840332326282727272727272828282728292A2A2B2C2D2E2D2D2D2E2B
2927242322201E1F20212321211F1B232C2C2551
78A3D8CCC5C5C4C7C9CBCDCFD0D1D1D5D8DCE0E0E0E2E3E1DFDDDCDAD8D6D4D2D1CFCCCD
CDCDCECCCBCAC8C8C8C7C7C7C7C6C6C6C6C6C6C6C6C6C5C6C6C7C8C5C2C0BDBDBCBBBBB9
B6B9C1A3886F524A423323262827272727272727282828282929292B2C2D2E2E2D2E2F2C
2926232222201F2020212221211E1B232C2B2350
78A3D8CDC6C7C7C9CACCCECFD1D2D3D7DADEE2E2E3E4E7E3E1DFDDDBD9D7D5D3D1CFCCCD
CDCDCECCCAC8C6C7C7C7C7C7C7C7C6C6C6C6C6C6C6C6C6C6C6C7C8C5C3C1BEBDBDBCBBB9
B6BAC2A58A72574E443523262827272727272627272828292929292A2B2D2E2E2D2E2F2C
2825222221201F1F20202120201E1B232B2A2250
78A3D8CDC7C9CACBCCCDCED0D2D3D4D8DCE0E4E5E5E7EAE6E3E0DDDCDAD8D6D4D2CFCCCD
CDCDCECCC9C6C3C4C5C6C6C6C6C7C7C7C6C6C6C6C6C6C6C7C7C7C8C6C4C2C0BEBDBCBBB9
B7BAC3A78D775E5347372327282726262626262727282929292828292B2C2E2E2D2E302B
2824202020201F1F1F20201F1F1E1A222B29214F
78A4D9CEC8C9CACBCDCECFD1D4D6D7DBDFE3E8E8E8E9ECE8E4E1DEDCDAD8D5D3D2CFCCCD
CDCDCECCCAC9C7C7C7C7C7C7C7C7C6C6C6C7C7C7C6C6C6C6C6C7C8C5C3C1BFBEBDBCBCBA
B8BBC3A78D765D51463521252828282727272627282829292929282A2B2C2E2E2D2E2F2B
2824202121201F1F202020201F1E1B222A29204F
78A4DACFC9CACACCCDCFD0D3D6D8DBDFE2E7ECEBEBECEEE9E5E2DEDCDAD7D5D3D1CFCCCD
CDCDCECDCBCBC9C9C9C8C8C7C7C7C6C6C6C7C7C7C7C6C6C6C6C7C8C5C3C1BEBEBDBDBCBB
B8BBC4A78D765C5145341F242828292828272727282829292929282A2B2C2E2D2D2D2F2B
2824202121201F1F202020201F1E1B222A291F4E
78A5DBD0C9CACBCDCECFD0D4D8DBDDE2E5EAF0EFEEEEF0EBE7E3DFDDDAD7D4D3D1CFCCCD
CDCDCDCDCDCCCCCBCAC9C8C8C7C6C5C6C7C7C8C7C7C6C6C6C6C7C8C5C3C0BDBEBDBDBDBC
B9BCC4A78D765C5144331D2328292B2A29282727282829292929292A2B2C2E2D2D2D2F2B
2824202121201F1F202020201F1E1B222A281E4E
78A5DCD0CACBCCCDCFD0D1D5D9DDE0E4E9EEF5F3F1F1F3EDE9E4E0DDDBD7D4D3D1CFCCCD
CDCDCDCDCECECFCECCCBC9C8C8C6C5C6C7C8C9C8C7C6C5C6C6C6C7C5C2C0BDBDBEBEBFBD
BABDC5A88E765C5044321C23282A2D2B2A282727282829292929292A2B2C2E2D2D2E2F2B
2824202121201F1F202020201F1E1B222A271D4D
78A6DED2CBCCCCCED0D2D3D7DCE0E4E8EBF0F6F4F2F2F4EEE9E5E0DDDBD8D4D3D1CFCCCD
CDCDCDCDCDCECFCDCCCBCAC9C8C7C5C6C7C7C8C7C7C6C6C6C6C6C7C5C2C0BDBEBEBEBEBC
B9BCC5A88E775E514431192126282B2A2928272828282828282828292A2B2C2C2B2C2D2A
2724202020201F20202020201F1E1B222A271D4E
79A7DFD3CCCCCCCFD1D3D4DADFE3E9EBEEF2F7F5F4F4F5EFEAE5E0DEDBD8D4D3D1CFCCCD
CDCDCDCDCDCECECDCCCBCBC9C8C7C5C6C6C7C7C7C7C6C6C6C6C6C7C5C3C0BEBEBDBDBDBB
B9BCC4A88F7860524430171F25272A2929282828282827282828282829292A2A2A2B2C29
2623202020201F20202020201F1E1B222A281D4E
7AA8E1D4CDCDCBCFD2D4D5DCE1E7EDEFF1F5F9F7F5F5F6F0EBE6E0DEDBD8D4D3D1CFCCCC
CDCDCDCDCDCDCECDCCCCCBCAC8C7C5C6C6C6C7C7C6C6C6C6C6C7C8C5C3C1BEBEBDBDBCBB
B8BCC4A88F786152432E141D23262A292929292928272727272727272728282828292B28
25221F202020202020202020201E1B222A281E4F
7BAAE2D5CDCDCBCFD2D5D6DDE4EBF2F3F5F8FCFAF8F7F8F2ECE7E1DEDBD8D4D2D1CECBCC
CDCDCDCDCDCDCECDCCCCCCCAC9C7C4C5C6C6C6C6C6C6C6C6C6C7C8C6C3C1BFBEBDBCBCBA
B8BBC4A78E786050412B101A22252A29292A2B2A29272626262626262626252626272926
24221F1F2020202020202020201E1B222A281E4F
7BABE4D7CFCFCDD2D5D8DAE1E6EDF4F4F5F8FBF9F8F8F9F2ECE7E1DFDCD8D4D3D1CFCCCD
CDCDCDCDCDCDCECDCDCCCCCBC9C8C6C6C7C7C6C6C6C6C6C6C6C6C7C5C3C1C0BFBDBCBBBA
B8BBC2A8917D6957462F131C222427272727282727272626272727272727262727272926
24211F1F202020202020201F1F1E1B222A281D4F
7CACE5D9D1D1CFD4D8DBDEE4E9EFF5F5F6F8FAF9F7F8F9F3EDE7E1DFDCD9D5D3D2D0CDCD
CECDCDCDCDCDCECDCDCCCCCBCAC9C8C8C8C7C7C7C7C6C6C6C5C5C5C4C2C2C1BFBEBCBBB9
B7BAC0A99483725E4B32151D222325252525252626262627272828282827272727272826
24211F1F202020202020201F1F1E1B222A281D50
7DADE8DBD4D4D2D7DCDFE3E8EDF2F9F8F8F9FBFAF9FAFCF5EFE9E3E0DDDAD6D5D3D1CECE
CECECDCECECECECECDCDCDCCCCCBCACAC9C8C7C7C7C7C7C6C5C5C4C3C3C3C3C0BEBCBAB9
B7B9BFAA96877A634D33141C212122222222222324252626272829282827272626262724
22201D1E1F1F1F1F1F1F1F1E1E1D1A2129271C4F
7DB0EDDFD7D8D6DCE1E5E9EEF2F8FEFDFCFCFCFCFCFDFFF8F2ECE5E3E0DCD8D6D5D3D0D0
D0CFCECECFCFCFCFCFCFCFCECECECECDCBCAC9C9C9C9C9C7C6C4C2C3C3C4C6C2C0BDBAB9
B7B9BFAB998D8268503311191E1E1F1E1E1E1D1F2123252627282A282726252524242422
201E1C1C1D1D1D1D1D1D1D1D1C1B181F2724194E
7EAEE7DBD4D4D3D8DDE1E5E9EDF2F8F7F6F6F7F6F6F6F8F2ECE6E0DEDBD8D4D3D1CFCDCD
CDCDCCCCCCCCCCCCCCCBCBCBCACACAC9C8C7C6C6C6C5C6C4C3C2C1C1C1C1C1BFBDBBB9B7
B5B6BAA99A8F866E573D1E23262422222322222325262728292A2C2B2A2A2A2929282826
24222021212121212121212121201D242C2A2052
7FABE1D6CFD0CFD4D8DCE1E4E8ECF1F0F0F0F1F0EFEFF1EBE5E0DBD8D6D3D0CFCECCCACA
CACACACAC9C9C9C8C8C8C7C7C6C6C6C5C4C3C2C2C2C2C2C1C0C0BFBEBDBDBCBBB9B8B7B5
B3B3B5A79A918B745E472B2D2E2A25262727272829292A2B2C2D2E2E2E2E2F2E2D2D2C2B
29272525262626262626262626252229312F2655
82AEE3D8D1D2D1D6DBE0E4E7EAEFF3F2F2F2F2F1F0F1F2ECE6E1DBDAD7D5D1D1D0CECCCD
CDCDCDCCCCCBCBCACAC9C9C8C8C7C7C6C5C4C3C3C3C3C4C3C2C1C1BFBEBDBCBBBABABAB7
B3B2B3A79D96927B654E3333302921232525252626272728292A2B2C2C2D2F2D2C2B2B29
2726232424242525252525252523202932322B59
87B3E9DED8D9D9DEE3E8EEF0F3F7FCFBFAFAFBF9F8F8F8F2EDE7E1E0DEDBD8D7D6D5D3D4
D4D5D6D4D3D2D0D0D0CFCFCECDCCCBCBCAC9C8C8C8C8C8C8C7C6C6C4C2C0BEBEBEBEC0BB
B7B4B3AAA19D9C836C553A363025181C1E1E1F1F1F1F1F202122232526282A2826252423
211F1D1D1E1E1E1E1E1E1E1E1F1D19253134305E
7C9FC9C1BCBCBCC0C3C7CACDCFD1D5D4D4D4D4D3D2D2D2CECAC7C2C1C0BEBCBBBAB9B8B9
B9B9B9B9B8B8B8B7B6B5B4B4B5B5B5B4B4B3B2B2B2B2B2B2B2B2B2B0AEACAAABABABACA9
A6A5A49D9794948271614E4B4840383A3C3C3C3C3D3D3D3E3E3F40414143444342414140
3F3D3C3C3C3C3C3D3D3D3E3E3D3C3B3E423F345A
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00Woo0SW>0THa0UJe35:D25Je55[F1UJe9U:D24ic2U:D44ic0U:D4Dic24YB1THa
0T8@0SW>0SF]22e[4RU:7Re[32U:22e[2RU:0RDY0QcW0RU:1Goo0@000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00Woo0SW>0THa0UJe35:D25Je55[F1UJe9U:D24ic2U:D44ic0U:D4Dic24YB1THa
0T8@0SW>0SF]22e[4RU:7Re[32U:22e[2RU:0RDY0QcW0RU:1Goo0@000Goo000>Ool20005Ool00`00
Oomoo`02Ool2=Jd2?Nl4AS46@Q0dAS4>@Q08AS4:@Q0QAS48@Q02AS4B@Q04?Nm6>Lh<?Nl2>Lh2<H`2
:DX28@P2:DX5Ool10001Ool001Eoo`03001oogoo009oo`8e[@8mk`A6<@I243A6<@i240Q6<@Y24256
<@Q24096<A9240@mkdHicP`mk`8icP8aS08YBP8Q208YBPEoo`40005oo`005Goo00<007ooOol00Woo
136<0SF]5S6<0Re[3S6<0Re[836<1SF]0SW>13F]1S6<13F]43W>0SF]3CW>0SF]4SW>1Sg_148@1THa
@4YB14ic1U:D0UJe0U[F0Tic0T8@0SF]0RDY0Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool4<H`2
=JdF<H`2;F/><H`2;F/P<H`6=Jd2>Lh4=Jd6<H`4=Jd@>Lh2=Jd=>Lh2=JdB>Lh6?Nl4@Q06AS50BU84
CW<6DY@2E[D2F]H2CW<2@Q02=Jd29BT2;F/5Ool10001Ool001Eoo`03001oogoo009oo`8]J`8e[@Pi
cRXe[BHicP8e[@HicQ0mk`8icP/mk`PicQ0mk`Y243i6<@A:DPI6<@9:DP96<@I2408icP8aS08YBP8L
i`8U:@Eoo`40005oo`005Goo00<007ooOol00Woo0Re[0SF]23W>:SF]9SW>0SF]1SW>43g_0SW>2cg_
23W>43g_2T8@?THa14YB1THa0TYB0THa1T8@0SW>0S6<0RU:0QcW0RDY1Goo0@000Goo000EOol00`00
Oomoo`02Ool2;F/2=Jd2@Q06?Nl`>Lh<?Nl:>Lh6?Nl8>LhL?Nl2@Q05?Nl2>Lh<?NlJ@Q04AS4@@Q0T
AS42BU82AS46@Q02>Lh2=Jd2<H`2;F/2:DX29BT27>L25:D28@P5Ool10001Ool001Eoo`8000=oo`8]
J`8e[@9240Hmkc0icP`mk`XicPHmk`PicQ`mk`9240Dmk`8icP`mkaY240A6<A1242A6<@9:DP96<@I2
408icP8e[@8aS08]J`8YBP8U:@8Li`8DY@8Q20Aoo`80005oo`005Goo00<007ooOol00Woo0RU:0SF]
0THa0T8@5Sg_2SW>D3g_1d8@13g_0SW>1Sg_848@2THa348@84Ha0TYB0Tic0THa0T8@13g_0SF]0Re[
0R481QS60QBU0PaS0QcW1Goo0@000Goo000EOol00`00Oomoo`02Ool2:DX2=Jd2AS42@Q0F?Nl:>Li@
?Nl7@Q04?Nl2>Lh6?NlP@Q0:AS4<@Q0PAS42BU82CW<2AS42@Q04?Nl2=Jd2;F/28@P66<H25:D236<2
7>L5Ool10001Ool001Eoo`03001oogoo009oo`8U:@8e[@9:DP9244`mk`8icPhmk`92410mk`U240@m
k`8icP@mkb924096<@A240A6<@a241Y6<@924096<@9:DP9>L`9F]@9>L`96<@92408mk`8]J`8Q208@
Q08000848@@8@P848@8DY@Eoo`40005oo`005Goo00<007ooOol00Woo0RDY0SF]0TYB0T8@C3g_0SW>
3Sg_0T8@43g_2D8@13g_0SW>13g_8T8@0THa148@14Ha348@6THa0T8@0THa0TYB0Tic0UJe0Tic0THa
0T8@0Sg_0Re[0R480Q240P000P@Q10Q20P@Q0QBU1Goo0@000Goo000EOol00`00Oomoo`02Ool29BT2
=Jd2BU84@Q1:?Nl2>Lh<?Nl8@Q06?Nl?@Q04?Nl2>Lh4?NlP@Q0>AS48@Q0VAS42?Nl2>Lh2<H`2;F/2
9BT27>L248@21242248436<224826<H5Ool10001Ool001Eoo`03001oogoo009oo`8U:@8e[@9:DPA2
44Xmk`8icP`mk`Q240Hmk`m240@mk`8icP@mkb1240i6<@Q242I6<@8mk`8icP8aS08]J`8U:@8Li`8@
Q0848@88@P@<H`88@P8HaPEoo`40005oo`005Goo00<007ooOol00Woo0RDY0SF]0TYB1T8@B3g_0SW>
2Sg_7d8@2Sg_648@6THa0T8@7THa0TYB0THa0T8@0Sg_0SW>0SF]0Re[0RDY0R480QcW0QS60Q240PQ2
0PaS0Q240PaS0PQ20QS61Goo0@000Goo000EOol00`00Oomoo`02Ool29BT2=Jd2BU86@Q18?Nl2>Lh:
?NlO@Q0:?NlH@Q0JAS42@Q0NAS42BU82AS42@Q02?Nl2>Lh2=Jd2;F/29BT28@P27>L26<H248@22482
36<248@236<224826<H5Ool10001Ool001Eoo`03001oogoo009oo`8YBP8e[@9:DP96<A1243`mk`8i
cPHmkb=240Pmka9243a6<@I:DP9>L`96<@8mk`8e[@8aS08YBP8Q208HaPH@Q08<H`88@P8<H`8@Q08<
H`88@P8HaPEoo`40005oo`005Goo0P000goo0RU:0SF]0TYB0THa448@?3g_0SW>1Sg_8d8@23g_4T8@
?4Ha1TYB0Tic0THa0Sg_0SF]0S6<0RU:0R480QS61Q240PaS0PQ20PaS0Q240PaS0PQ20QS617oo0P00
0Goo000EOol00`00Oomoo`02Ool2:DX2=Jd2BU82AS4B@Q0:?Nl2@Q0F?Nl2@Q0>?Nl2@Q06?Nl2>Lh6
?NlR@Q09?Nl@@Q0/AS44BU8>AS42BU82CW<2DY@2F]H2BU82?Nl2<H`29BT27>L25:D236<200021246
248236<248@436<26<H5Ool10001Ool001Eoo`03001oogoo009oo`8YBP8e[@9:DP96<A9240Xmk`92
41Hmk`9240hmk`9240Hmk`8icPHmkb9240Tmka1242a6<@A:DPi6<@9:DP9>L`9BU09JeP9:DP8mk`8a
S08U:@8Li`8DY@8<H`8000848@H8@P8<H`8@Q0@<H`8HaPEoo`40005oo`005Goo00<007ooOol00Woo
0RU:0SW>0TYB0THa548@0Sg_:T8@4Sg_:D8@0Sg_448@=THa0TYB1THa0TYB0THa148@0THa0SW>0S6<
0RU:0QcW0QS60QBU0PaS0P@Q20Q20PaS0Q2410aS0QcW1Goo0@000Goo000EOol00`00Oomoo`02Ool2
:DX2>Lh2BU82AS4D@Q02?NlZ@Q0B?NlY@Q02?Nl@@Q0fAS42BU86AS42BU82AS44@Q02AS42>Lh2<H`2
:DX27>L26<H25:D236<21248248236<248@436<27>L5Ool10001Ool001Eoo`03001oogoo009oo`8Y
BP8icP9>L`A6<D9240`mkce243A6<@A:DPI6<@9:DP92408mk`8e[@8aS08]J`8U:@8Q208HaP8DY@8@
Q08<H`@8@P8<H`@8@P8<H`8@Q0@<H`8Li`Eoo`40005oo`005Goo00<007ooOol00Woo0RU:0SW>0Tic
14Ha@T8@33g_?D8@=4Ha14YB1THa0TYB0T8@0Sg_0SF]0S6<0Re[0RDY0R480QS60QBU0Q240PaS10Q2
0PaS10Q20PaS0Q2410aS0QcW1Goo0@000Goo000EOol00`00Oomoo`02Ool2:DX2>Lh2CW<2BU8@AS4d
@Q0:?Nlc@Q0:AS42@Q0dAS46BU82AS42BU82CW<2@Q02=Jd2;F/28@P27>L26<H25:D248@636<22484
36<4248236<248@236<224827>L5Ool10001Ool001Eoo`03001oogoo009oo`8YBP8icP9>L`9:DQ16
<CA240Xmkc=240Y6<@9243A6<@I:DP96<@9:DP9>L`92408e[@8]J`8Q208Li`8HaP8DY@8@Q0H<H`88
@P@<H`@8@P8<H`8@Q08<H`88@P8Li`Eoo`40005oo`005Goo00<007ooOol00Woo0RU:0SW>0Tic0TYB
5THa548@1THa548@13g_<d8@44Ha0T8@=4Ha24YB0Tic0UJe0T8@0S6<0R481PaS0PQ20P@Q1PQ21PaS
10Q21PaS0PQ20QcW1Goo0@000Goo000EOol20003Ool2:DX2>Lh2CW<2BU8FAS4D@Q06AS4D@Q04?Nlc
@Q0@AS42@Q0dAS48BU82CW<2E[D2@Q02<H`28@P636<224821246248636<4248636<224827>L4Ool2
0001Ool001Eoo`03001oogoo009oo`8]J`8mk`9BU09:DSI6<D=244Q6<@A:DP96<@I2408e[@8YBP8L
i`P<H`H8@PP<H`@8@P8<H`8@Q0@<H`8Li`Eoo`40005oo`005Goo00<007ooOol00Woo0Re[0Sg_0U:D
0TYB=THa@d8@B4Ha14YB0THa1T8@0SF]0RU:0QcW20aS1PQ220aS10Q20PaS0Q2410aS0QcW1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2;F/2?Nl2DY@2CW<4BU8jAS4F@Q04AS46@Q0:AS4>@Q0UAS42BU8L
AS44BU86AS42BU82@Q02>Lh2=Jd2;F/2:DX28@P26<H836<2248<36<4248236<248@436<27>L5Ool1
0001Ool001Eoo`03001oogoo009oo`8]J`8mk`9BU09>L`A:DSY6<AI240A6<@I240Y6<@i242E6<@9:
DQa6<@A:DPI6<@9:DP92408icP8e[@8]J`8YBP8Q208HaPP<H`88@P`<H`@8@P8<H`8@Q0@<H`8Li`Eo
o`40005oo`005Goo00<007ooOol00Woo0Re[0Sg_0U:D0Tic44YB<4Ha348@7THa248@9dHa1TYB5THa
3TYB0Tic0T8@0SF]0RU:0QcW0QS60QBU0Q245PaS10Q20PaS11240PaS0QcW1Goo0@000Goo000EOol0
0`00Oomoo`02Ool2;F/2?Nl2DY@2CW<@BU8`AS4<@Q0NAS48@Q0WAS46BU8FAS4>BU82CW<2@Q02=Jd2
:DX27>L26<H25:D248@F36<4248236<448@236<27>L5Ool10001Ool001Eoo`03001oogoo009oo`8]
J`8mk`9F]@9>La9:DPI6<@i:DQI6<@9:DPA6<@92408mk`A24216<@Q241U6<@9:DPa6<@Q:DPi6<@a:
DP9>L`A:DP9>L`9F]@92408]J`8Li`848@88@P8<H`P8@PX<H`X8@P8<H`@@Q08<H`8Li`Eoo`40005o
o`001goo10000goo0P001Goo00<007ooOol00Woo0Re[0Sg_0UJe0Tic4TYB1THa3TYB5THa0TYB14Ha
0T8@0Sg_148@84Ha248@6DHa0TYB34Ha24YB3THa34YB0Tic14YB0Tic0UJe0T8@0Re[0QcW0P@Q0PQ2
0PaS20Q22PaS2PQ20PaS11240PaS0QcW1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`00
17oo00<007ooOol00Woo0Re[0T8@0UJe14ic9TYBA4Ha0T8@6dHa1TYB24Ha2TYB24Ha4TYB0Tic0THa
1T8@0S6<0RDY0QS60PQ21PaS10Q250aS0PQ20PaS11240PaS0QcW1Goo0@000Goo0008Ool00`00Oomo
o`02Ool01000Oomoo`0017oo0P000goo0Re[0T8@0UJe14ic9TYBA4Ha0T8@6dHa1TYB24Ha2TYB24Ha
4TYB0Tic0THa1T8@0S6<0RDY0QS60PQ21PaS10Q250aS0PQ20PaS11240PaS0QcW17oo0P000Goo0009
Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo0S6<0T8@0UJe0U:D14ic1TYB
14ic74YB24Ha14YB1THa0T8@14Ha0TYB0Tic1TYB:4Ha0TYB3DHa3TYB14Ha:4YB0T8@0SW>0SF]0Re[
0RDY0R480QBU80aS0PQ20PaS11240PaS0R481Goo0@000Goo0007Ool01000Oomoo`000Woo00@007oo
Ool000Aoo`03001oogoo009oo`8aS092409F]@9BU0A>L`I:DPA>Laa:DPQ6<@A:DPI6<@9240A6<@9:
DP9>L`I:DRQ6<@9:DPe6<@i:DPA6<BQ:DP92408icP8e[@8]J`8U:@8Q208DYB0<H`88@P8<H`@@Q08<
H`8Q20Eoo`40005oo`0027oo0P0017oo0P001Goo00<007ooOol00Woo0S6<0T8@0UJe0U:D8Tic4TYB
0Tic0TYB0THa0T8@0Sg_0T8@0TYB0Tic0U:D14ic1TYB2THa24YB44HaBDYB0Tic0T8@0SF]0RU:0QcW
11S60Q2480aS0PQ20PaS11240PaS0R481Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`2@Q02E[D2
DY@RCW<BBU82CW<2BU82AS42@Q02?Nl2@Q02BU82CW<2DY@4CW<6BU8:AS48BU8@AS59BU82CW<2@Q02
=Jd2:DX27>L46<H248@P36<2248236<448@236<28@P5Ool10001Ool001Eoo`03001oogoo009oo`8a
S092409JeP9BU11>L`aBU09F]@ABU0Y>L`9:DPA>L`9BU09F]@9>L`9:DP92408icP92409:DP9>L`9J
eP9BU09>L`9:DPa6<@A:DP9>L`I:DPY6<DE:DPA>L`9:DP9>L`9F]@92408]J`8Li`@8@P@<H`@8@P`<
H`88@PH<H`8@Q0X<H`H@Q08Q20Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0T8@0U[F0U:D44ic
35:D0UJe15:D2Tic0TYB14ic0U:D0UJe0Tic0TYB0T8@0SW>0T8@0TYB0Tic0U[F0U:D0Tic0TYB34Ha
14YB0Tic1TYB2THaADYB14ic0TYB0Tic0UJe0T8@0Re[0QcW10Q210aS10Q230aS0PQ21PaS0Q242PaS
1Q240R481Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`2@Q02F]H4DY@HCW<8BU8:AS42@Q0:AS44
@Q02>Lh2AS42BU82DY@2G_L2E[D2DY@2CW=UBU84CW<2BU82AS44@Q02=Jd2:DX26<H2248636<2248F
36<248@836<648@236<28@P5Ool10001Ool001Eoo`03001oogoo009oo`8aS092409JePABU1Q>L`Q:
DPY6<@9240Y6<@A2408icP96<@9:DP9BU09Nm`9F]@9BU09>LfE:DPA>L`9:DP96<@A2408e[@8YBP8H
aP88@PH<H`88@QH<H`8@Q0P<H`H@Q08<H`8Q20Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0THa
0U[F0UJe1U:D2Tic24YB1THa1T8@3Sg_13W>23g_0THa0Tic0UJe0V<H0Ukg0UJe0U:D24ic0U:D0Tic
14YB14HaDDYB14ic0THa0Sg_0SW>0SF]0RU:0R480QS680aS0Q2420aS1Q240PaS0R481Goo0@000Goo
000EOol20003Ool2<H`2AS42F]H2E[D6DY@:CW<8BU86AS46@Q0>?Nl4>Lh8?Nl2AS42CW<2E[D2HaP2
G_L2E[D2DY@8CW<2DY@2CW<4BU84AS5ABU84CW<2AS42?Nl2>Lh2=Jd2:DX28@P26<HP36<248@836<6
48@236<28@P4Ool20001Ool001Eoo`03001oogoo009oo`8aS096<@9Nm`9F]@iBU09>L`A:DPA6<@92
40@mk`HicPXe[@@aS0@]J`8aS08e[@@icP96<@9>L`9Nm`9[FP9S609Nm`9F]@ABU0IF]@9BU09>L`96
<@8mk`A6<@9:DPA>Lb=:DP9>LbA:DP9>L`9BU096<@8icP8aS08U:@8Q208Li`8DY@88@Qh<H`8@Q0P<
H`8@Q08DY@8@Q08<H`8Q20Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0THa0Ukg0UJe3U:D0Tic
14YB14Ha0T8@13g_1SW>2SF]136<12e[0S6<0SF]13W>0THa0Tic0Ukg0V]J0V<H0Ukg0UJe15:D1UJe
0U:D0Tic0THa0Sg_14Ha0TYB14ic8dYB0Tic94YB0Tic0U:D0THa0SW>0S6<0RDY0R480QcW0QBU0PQ2
7PaS0Q2420aS0Q240QBU0Q240PaS0R481Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd2AS42G_L2
F]H4E[D2F]H6E[D2DY@2CW<2BU84AS42@Q02?Nl2>Lh6<H`2;F/::DX49BT27>L26<H28@P2;F/2<H`2
=Jd2AS42DY@2HaP2Mkd2Kg/2IcT2G_L2E[D4F]H2G_L2HaP2E[D2CW<2AS42>Lh2@Q02AS42BU8<CW<I
BU8:CW<DBU82CW<4BU84CW<2DY@2F]H2AS42=Jd2:DX65:D236<4248L36<648@436<248@25:D248@2
36<28@P5Ool10001Ool001Eoo`03001oogoo009oo`8e[@96<@9Nm`9JePAF]@9JePIF]@9BU09>L`9:
DPA6<@92408mk`8icPHaS08]J`XYBP@U:@8Li`8HaP8Q208]J`8aS08e[@96<@9BU09S609g_@9_N`9W
>@9Nm`9F]@AJeP9Nm`9S609F]@9>L`96<@8icP924096<@9:DPa>LaU:DPY>LaA:DP9>L`A:DPA>L`9B
U09JeP96<@8e[@8YBPHDY@8<H`@8@Q`<H`H@Q0@<H`8@Q08DY@8@Q08<H`8Q20Eoo`40005oo`005Goo
00<007ooOol00Woo0S6<0THa0Ukg0UJe1U:D14ic14YB14Ha148@13g_0SW>23F]336<12e[0RU:0S6<
0SW>0Sg_0T8@0TYB0U:D0Ukg0Vmk0V<H0Ukg0UJe15:D15Je0U[F0UJe0Tic0TYB0T8@0THa14YB3Tic
5DYB44ic34YB2Tic24YB0Sg_0S6<0R4811BU0Q240PaS0PQ27PaS1Q2410aS0Q240QBU0Q240PaS0R48
1Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`2AS42G_L2E[D6DY@4CW<4BU84AS44@Q04?Nl2>Lh8
=Jd<<H`4;F/2:DX2<H`2>Lh2?Nl2@Q02BU82DY@2G_L2Kg/2HaP2G_L2E[D4DY@4E[D2F]H2E[D2CW<2
BU82@Q02AS44BU8>CW<EBU8@CW<<BU8:CW<8BU82?Nl2<H`28@P45:D248@236<2248N36<648@436<2
48@25:D248@236<28@P5Ool10001Ool001Eoo`03001oogoo009oo`8aS096<@9JeP9BU09>L`A:DPI6
<@A240PmkaXicP@e[@8mk`924096<@9>L`9BU09F]@9JeP9S609Nm`9F]@9BU09:DP9>L`ABU09F]@9B
U09>L`9:DP96<@A:DR5>L`9:DRI>L`9BU09:DPA2408mk`8aS08YBP8Li`H@Q28<H`H@Q0@<H`8@Q08D
Y@8@Q08<H`8Q20Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0THa0U[F0U:D0Tic14YB1THa148@
23g_6SW>13F]0Sg_0T8@0THa0Tic0U:D0UJe0U[F0V<H0Ukg0UJe0U:D0TYB0Tic15:D0UJe0U:D0Tic
0TYB0THa14YB8Dic0TYB9Tic0U:D0TYB148@0Sg_0S6<0RU:0QcW1Q248PaS1Q2410aS0Q240QBU0Q24
0PaS0R481Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`2AS42F]H2DY@2BU82AS44@Q04?NlF>Lh>
?Nl4@Q02?Nl2AS42BU82DY@2F]H4E[D4F]H2E[D2DY@2BU82@Q02AS42BU82CW<2E[D4DYAACW<2E[D2
BU82@Q02>Lh2<H`2:DX28@P26<HH36<248@>36<648@436<248@25:D448@28@P5Ool10001Ool001Eo
o`8000=oo`8aS096<@9JeP9BU09:DP96<@A240@mkaHicPhmk`A2408mk`96<@9:DP9BU09JePAF]@AJ
eP9F]@9BU09:DP924096<@9:DP9>L`9F]@ABU55>L`9F]@9:DP92408icP8aS08YBP8Q208HaQP<H`8@
Q0h<H`H@Q0@<H`8@Q08DY@@@Q08Q20Aoo`80005oo`005Goo00<007ooOol00Woo0S6<0THa0Ukg0U:D
0THa0T8@13W>0SF]0S6<12e[236<13F]13W>13g_1T8@1THa1TYB0U:D0UJe0Ukg0VLi0Ukg0U[F0UJe
0U:D0TYB0THa0T8@0SF]0Sg_0THa0TYB25:D0UJe35:D>Dic0TYB14ic0U:D0U[F0TYB0Sg_0S6<0RDY
0QcW0QS60Q240P@Q10Q22PaS0PQ21PaS212410aS2Q2410aS0Q2411BU0Q240R481Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`2AS42G_L2DY@2AS42@Q04>Lh2=Jd2<H`4;F/8<H`4=Jd4>Lh4?Nl6@Q06
AS46BU82DY@2E[D2G_L2IcT2G_L2F]H2E[D2DY@2BU82AS42@Q02=Jd2?Nl2AS42BU88DY@2E[D<DY@i
CW<2BU84CW<2DY@2F]H2BU82?Nl2<H`29BT27>L26<H248@21244248:36<2248636<848@436<:48@4
36<248@45:D248@28@P5Ool10001Ool001Eoo`03001oogoo009oo`8]J`8mk`9BU09:DP92408mk`@i
cP@e[@8aS0Pe[@@icPHmk`A240Q6<@I:DPA>L`9BU09F]@9JeP9S609Nm`9JePAF]@9BU09>L`96<@92
4096<@A:DPA>LaQBU3]>L`9BU096<@8e[@8YBP8Li`8HaP8DY@8@Q0@8@Q@<H`H@Q0H<H`X@Q0@<H`8@
Q08DY@@@Q08Q20Eoo`40005oo`005Goo00<007ooOol00Woo0Re[0Sg_0U:D0TYB0T8@0Sg_13W>13F]
0S6<23F]13W>1Sg_148@24Ha1TYB14ic0U:D0UJe0U[F0V<H0Ukg0U[F15Je0U:D0Tic0THa0T8@0THa
14YB14ic65:D>dic0U:D0THa0SF]0RU:0QcW0QS60QBU0Q2410Q250aS1Q241PaS2Q2410aS0Q240QBU
11240R481Goo0@000Goo000EOol00`00Oomoo`02Ool2:DX2>Lh2BU82@Q04?Nl6>Lh6=Jd6>Lh4?Nl6
@Q06AS48BU88CW<2DY@2E[D2F]H2G_L8F]H2E[D2DY@2CW<6BU88CW<LDY@]CW<2DY@2CW<6BU82?Nl2
<H`29BT65:D248@R36<<48@436<848@27>L5Ool10001Ool001Eoo`03001oogoo009oo`8YBP8icP9:
DP9240@mk`HicPHe[@HicP@mk`I240I6<@Q:DPQ>L`9BU09F]@9JeP9Nm`QJeP9F]@9BU09>L`I:DPQ>
LaaBU2e>L`9BU09>L`I:DP8mk`8aS08U:@HDY@8@Q28<H``@Q0@<H`P@Q08Li`Eoo`40005oo`005Goo
00<007ooOol00Woo0RDY0S6<0T8@0Sg_33W>0SF]13W>1Sg_148@14Ha1TYB24ic1U:D1UJe35[F15Je
0U:D1Tic0TYB0THa0TYB0Tic0U:D15Je6e:D0Tic3U:D0Tic2U:D2Tic0U:D0UJe0Tic0TYB14Ha0SW>
0RU:0QcW10aS0Q248PaS3Q2410aS21240QcW1Goo0@000Goo000EOol00`00Oomoo`02Ool29BT2<H`2
@Q02?Nl<>Lh2=Jd4>Lh6?Nl4@Q04AS46BU88CW<6DY@6E[D<F]H4E[D2DY@6CW<2BU82AS42BU82CW<2
DY@4E[DKDY@2CW<>DY@2CW<:DY@:CW<2DY@2E[D2CW<2BU84AS42>Lh2:DX27>L436<248@R36<>48@4
36<848@27>L5Ool10001Ool001Eoo`03001oogoo009oo`8Q208YBP8e[@@aS0Xe[@@icPHmk`9240A6
<@A:DPI>L`IBU0IF]@QJePAF]@aJePAF]@9BU09>L`9:DP92409:DP9>L`9BU09JePAF]CMBU0I>L`AB
U09JeP9BU09:DP96<@92408aS08U:@8DY@8000848@88@P8<H`8@Q0h<H`@@Q0X<Ha0@Q0@<H`H@Q08<
H`8HaPEoo`400