(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1479007,      26449]*)
(*NotebookOutlinePosition[   1479695,      26473]*)
(*  CellTagsIndexPosition[   1479651,      26469]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\:304a\:307e\:3058\:306a\:3044\)], "Input"],

Cell[BoxData[{
    \(<< Utilities`MemoryConserve`\), "\n", 
    \(\($MemoryIncrement;\)\), "\n", 
    \(\(<< \ LinearAlgebra`MatrixManipulation`;\)\), "\n", 
    \(\(Off[General::spell1, MemoryConserve::start, 
        MemoryConserve::end];\)\)}], "Input"]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[BoxData[
    StyleBox[\(Daubechies : \),
      FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
      FontWeight->"Bold",
      FontVariations->{"Underline"->True}]], "Input"],

Cell[BoxData[
    \(\(daub2 = {{1. , 1. }, {1. , \(-1. \)}}/Sqrt[2. ]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\

coif30={{-.000149963800, .000253561200, .001540245700, 
\t\t -.002941110800,-.007163781900, .016552066400, 
 \t\t  .019917804300,-.064997262800,-.036800073600,
 \t\t  .298092323500, .547505429400, .309706849000, 
\t\t -.043866050800,-.074652238900, .029195879500, 
 \t\t  .023110777000,-.013973687900,-.006480090000, 
 \t\t  .004783001400, .001720654700,-.001175822200,
\t\t -.000451227000, .000213729800, .000099377600,
\t\t -.000029232100,-.000015072000, .000002640800, 
 \t\t  .000001459300,-.000000118400,-.000000067300},
 \t\t{-.000000067300, .000000118400, .000001459300,
 \t\t -.000002640800,-.000015072000, .000029232100,
 \t\t  .000099377600,-.000213729800,-.000451227000,
 \t\t  .001175822200, .001720654700,-.004783001400,
 \t\t -.006480090000, .013973687900, .023110777000,
 \t\t -.029195879500,-.074652238900, .043866050800,
 \t\t  .309706849000,-.547505429400, .298092323500,
 \t\t  .036800073600,-.064997262800,-.019917804300,
 \t\t  .016552066400, .007163781900,-.002941110800,
 \t\t -.001540245700, .000253561200, .000149963800}}*
 \t\tSqrt[2.]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((1 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
expanMatrix[v_,wMat_]:=
\tBlock[{mdata=Length[v],is=Length[Transpose[daub2]],
\t\tndata=Ceiling[Log[2.,mdata]],mother,transwMat,emat,exPan},
\t\tmother=Ceiling[Log[2.,is]]-1;transwMat=Transpose[wMat];
    \temat=transwMat.Join[Take[v,{1,2^mother}],Table[0,{mdata-
    \t\t2^mother}]];\t
   \t\tpartInverse[i_]:=(exPan=Table[0,{mdata}];
   \t\t\tDo[exPan[[j]]=v[[j]],{j,1+2^(i-1),2^i}];
   \t\t\ttranswMat.exPan);
    \texPan=Table[partInverse[i],{i,mother+1,ndata}];
        emat=AppendColumns[{emat},exPan]\t\t
  \t];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((2 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
expanMatrix2D[spect2D_,wMatL_,wMatR_,anaW_]:=
\tBlock[{dim=Dimensions[spect2D],is=Length[Transpose[anaW]],
\t\tmother,transwMatL,emat2D,exPan2D},
\t\tmother=Ceiling[Log[2.,is]]-1;transwMatL=Transpose[wMatL];
\t\tWhich[\tdim[[1]]>=dim[[2]],nLdata=Log[2,dim[[1]]];size=dim[[1]],
\t\t\t\tdim[[2]]>dim[[1]],nLdata=Log[2,dim[[2]]];size=dim[[2]]];
\t\tinputMatrix=ZeroMatrix[size,size];
\t\t\tDo[inputMatrix[[i,j]]=spect2D[[i,j]],
\t\t\t\t{i,dim[[1]]},{j,dim[[2]]}];
\t\texPan2D=ZeroMatrix[dim[[1]],dim[[2]]];
\t\t\tDo[Do[exPan2D[[i,j]]=spect2D[[i,j]],{i,2^mother}],
\t\t\t\t{j,2^mother}];
\t\t\temat2D=transwMatL.exPan2D.wMatR;
\t\tpartInverse2D[i_]:=
\t\t\t(\tdummyMat=ZeroMatrix[size,size];
\t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
\t\t\t\t\t{k,2^i},{m,1+2^(i-1),2^i}];
   \t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
   \t\t\t\t\t{k,1+2^(i-1),2^i},{m,2^i}];
   \t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
   \t\t\t\t\t{k,1+2^(i-1),2^i},{m,1+2^(i-1),2^i}];
   \t\t\t\ttranswMatL.Table[dummyMat[[k,m]],
   \t\t\t\t\t{k,dim[[1]]},{m,dim[[2]]}].wMatR);
    \texPan2D=Table[partInverse2D[i],{i,mother+1,nLdata}];
    \t\tFlatten[{{emat2D},exPan2D},1]
    ];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["1",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["dimensional",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["sample",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(a = {x, y, u, v};\)\)], "Input"],

Cell[BoxData[
    \(\(daub2 = {{1. , 1. }, {1. , \(-1. \)}}/Sqrt[2. ];\)\)], "Input"],

Cell[BoxData[
    \(\(w = waveletMatrix[4, daub2];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.499999999999999911`", "0.499999999999999911`", 
              "0.499999999999999911`", "0.499999999999999911`"},
            {"0.499999999999999911`", "0.499999999999999911`", 
              \(-0.499999999999999911`\), \(-0.499999999999999911`\)},
            {"0.707106781186547461`", \(-0.707106781186547461`\), "0.`", 
              "0.`"},
            {"0.`", "0.`", "0.707106781186547461`", 
              \(-0.707106781186547461`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wa = w . a;\)\)], "Input"],

Cell[BoxData[
    \(\(unitMatrix4 = Transpose[w] . w; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[%] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.999999999999999644`", "0", "0", "0"},
            {"0", "0.999999999999999644`", "0", "0"},
            {"0", "0", "0.999999999999999644`", "0"},
            {"0", "0", "0", "0.999999999999999644`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[Simplify[Transpose[w] . wa]] // MatrixForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", GridBox[{
            {\(0.999999999999999644`\ x\)},
            {\(0.999999999999999644`\ y\)},
            {\(0.999999999999999644`\ u\)},
            {\(0.999999999999999644`\ v\)}
            }], ")"}],
      MatrixForm[ {
        Times[ .99999999999999967, x], 
        Times[ .99999999999999967, y], 
        Times[ .99999999999999967, u], 
        Times[ .99999999999999967, v]}]]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", 
      StyleBox[
        RowBox[{" ", 
          StyleBox[" ",
            FontVariations->{"Underline"->True}]}]], 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((1 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(multiResolvedVector = expanMatrix[wa, w];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[
        Print["\<Level\>", 
          i, "\<->\>", \n\t\tMatrixForm[
            Simplify[multiResolvedVector[\([i]\)]]]], {i, 3}];\)\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"Level\"\>", "\[InvisibleSpace]", "1", 
        "\[InvisibleSpace]", "\<\"->\"\>", "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", 
            TagBox[GridBox[{
                  {\(0.2499999999999999`\ u + 0.2499999999999999`\ v + 
                      0.2499999999999999`\ x + 0.2499999999999999`\ y\)},
                  {\(0.2499999999999999`\ u + 0.2499999999999999`\ v + 
                      0.2499999999999999`\ x + 0.2499999999999999`\ y\)},
                  {\(0.2499999999999999`\ u + 0.2499999999999999`\ v + 
                      0.2499999999999999`\ x + 0.2499999999999999`\ y\)},
                  {\(0.2499999999999999`\ u + 0.2499999999999999`\ v + 
                      0.2499999999999999`\ x + 0.2499999999999999`\ y\)}
                  },
                RowSpacings->1,
                ColumnAlignments->{Left}],
              Column], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]]}],
      SequenceForm[ "Level", 1, "->", 
        MatrixForm[ {
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ .24999999999999989, x], 
            Times[ .24999999999999989, y]], 
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ .24999999999999989, x], 
            Times[ .24999999999999989, y]], 
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ .24999999999999989, x], 
            Times[ .24999999999999989, y]], 
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ .24999999999999989, x], 
            Times[ .24999999999999989, y]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"Level\"\>", "\[InvisibleSpace]", "2", 
        "\[InvisibleSpace]", "\<\"->\"\>", "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", 
            TagBox[GridBox[{
                  {\(\(-0.2499999999999999`\)\ u - 0.2499999999999999`\ v + 
                      0.2499999999999999`\ x + 0.2499999999999999`\ y\)},
                  {\(\(-0.2499999999999999`\)\ u - 0.2499999999999999`\ v + 
                      0.2499999999999999`\ x + 0.2499999999999999`\ y\)},
                  {\(0.2499999999999999`\ u + 0.2499999999999999`\ v - 
                      0.2499999999999999`\ x - 0.2499999999999999`\ y\)},
                  {\(0.2499999999999999`\ u + 0.2499999999999999`\ v - 
                      0.2499999999999999`\ x - 0.2499999999999999`\ y\)}
                  },
                RowSpacings->1,
                ColumnAlignments->{Left}],
              Column], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]]}],
      SequenceForm[ "Level", 2, "->", 
        MatrixForm[ {
          Plus[ 
            Times[ -.24999999999999989, u], 
            Times[ -.24999999999999989, v], 
            Times[ .24999999999999989, x], 
            Times[ .24999999999999989, y]], 
          Plus[ 
            Times[ -.24999999999999989, u], 
            Times[ -.24999999999999989, v], 
            Times[ .24999999999999989, x], 
            Times[ .24999999999999989, y]], 
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ -.24999999999999989, x], 
            Times[ -.24999999999999989, y]], 
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ -.24999999999999989, x], 
            Times[ -.24999999999999989, y]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"Level\"\>", "\[InvisibleSpace]", "3", 
        "\[InvisibleSpace]", "\<\"->\"\>", "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", 
            TagBox[GridBox[{
                  {\(0.`\ u + 0.`\ v + 0.4999999999999999`\ x - 
                      0.4999999999999999`\ y\)},
                  {\(0.`\ u + 0.`\ v - 0.4999999999999999`\ x + 
                      0.4999999999999999`\ y\)},
                  {\(0.4999999999999999`\ u - 0.4999999999999999`\ v + 
                      0.`\ x + 0.`\ y\)},
                  {\(\(-0.4999999999999999`\)\ u + 0.4999999999999999`\ v + 
                      0.`\ x + 0.`\ y\)}
                  },
                RowSpacings->1,
                ColumnAlignments->{Left}],
              Column], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]]}],
      SequenceForm[ "Level", 3, "->", 
        MatrixForm[ {
          Plus[ 
            Times[ 0.0, u], 
            Times[ 0.0, v], 
            Times[ .49999999999999989, x], 
            Times[ -.49999999999999989, y]], 
          Plus[ 
            Times[ 0.0, u], 
            Times[ 0.0, v], 
            Times[ -.49999999999999989, x], 
            Times[ .49999999999999989, y]], 
          Plus[ 
            Times[ .49999999999999989, u], 
            Times[ -.49999999999999989, v], 
            Times[ 0.0, x], 
            Times[ 0.0, y]], 
          Plus[ 
            Times[ -.49999999999999989, u], 
            Times[ .49999999999999989, v], 
            Times[ 0.0, x], 
            Times[ 0.0, y]]}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Print["\<All Levels\>", 
      "\<->\>"\n\t\t
        MatrixForm[
          Chop[Simplify[
              multiResolvedVector[\([1]\)] + multiResolvedVector[\([2]\)]\n
                \t\t\t\t\t\t\t + multiResolvedVector[\([3]\)]\ ]]]]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"All Levels\"\>", "\[InvisibleSpace]", 
        RowBox[{"\<\"->\"\>", " ", 
          InterpretationBox[
            RowBox[{"(", GridBox[{
                  {\(0.999999999999999644`\ x\)},
                  {\(0.999999999999999644`\ y\)},
                  {\(0.999999999999999644`\ u\)},
                  {\(0.999999999999999644`\ v\)}
                  }], ")"}],
            MatrixForm[ {
              Times[ .99999999999999967, x], 
              Times[ .99999999999999967, y], 
              Times[ .99999999999999967, u], 
              Times[ .99999999999999967, v]}]]}]}],
      SequenceForm[ "All Levels", 
        Times[ "->", 
          MatrixForm[ {
            Times[ .99999999999999967, x], 
            Times[ .99999999999999967, y], 
            Times[ .99999999999999967, u], 
            Times[ .99999999999999967, v]}]]],
      Editable->False]], "Print"]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["2",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["dimensional",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["sample",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Photo\ Example\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol00WooB3F]13W>1SF]23W>0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa
0T8@0THa0SW>1Goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol00WooB3F]13W>1SF]23W>
0SF]0S6<0SF]<cW>0Sg_53W>@Sg_148@1Sg_0T8@0THa0T8@0THa0SW>1Goo0@000Goo000>Ool20005
Ool00`00Oomoo`02OomB=Jd6>Lh4=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl8>Li<?Nl6@Q02?Nl2
<H`28@P5Ool10001Ool001Eoo`03001oogoo009ooe8e[@HicP@e[@8aS08e[A`icP8mk`TicP@e[A0i
cP@mk`PicT`mk`I2408mk`8aS08Q20Eoo`40005oo`005Goo00<007ooOol00WooDSF]13W>13F]136<
0SF]73W>0Sg_2CW>13F]43W>1Sg_13W>33g_1SW><3g_148@13g_248@0SF]0Re[0QS60PaS1Goo0@00
0Goo000EOol00`00Oomoo`02OomB=Jd4>Lh4=Jd4<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh6?Nl4>Lh<?Nl6
>Lh`?Nl4@Q04?Nl8@Q02=Jd2;F/26<H236<5Ool10001Ool001Eoo`03001oogoo009ooc`e[@8icPPe
[@8icPXe[@@icP@e[@8aS0@e[A`icP8mk`<icP8mk`8icP@aS08e[@@mk`PicQ@mk`8icRPmk`A2408m
k`A240Hmk`A2408mk`8icP8mk`A6<@8mk`8aS08Li`8@Q0@000Eoo`40005oo`005Goo00<007ooOol0
0Woo?3F]0SW>23F]0SW>2SF]13W>13F]0S6<13F]73W>0Sg_0cW>0Sg_0SW>136<0SF]13g_23W>53g_
0SW>:3g_148@0Sg_148@1Sg_148@0Sg_0SW>0Sg_14Ha0Sg_0S6<0QcW0Q2410001Goo0@000Goo000E
Ool00`00Oomoo`02Ool2>Lhf=Jd6>Lh6=Jd6>Lh6=Jd6>Lh4=Jd2<H`2=JdN>Lh2?Nl3>Lh2?Nl2>Lh4
<H`2>Li6?Nl:@Q02?Nl6@Q08?Nl2@Q02AS42@Q02=Jd29BT25:D2248212440005Ool10001Ool001Eo
o`8000=oo`8icSHe[@HicPHe[@HicPHe[@HicP@e[@8aS08e[AhicP8mk`<icP8mk`8icP@aS08icTHm
k`Y2408mk`I240Pmk`924096<@92408e[@8U:@8DY@88@P848@@000Aoo`80005oo`005Goo00<007oo
Ool00Woo33W>83F]53W>0SF]23W>13F]1SW>23F]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Sg_148@3Sg_1T8@13g_448@0Sg_448@0SW>0Re[0QcW0PaS2P001Goo0@000Goo000EOol00`00
Oomoo`02Ool<>LhP=JdD>Lh2=Jd8>Lh4=Jd6>Lh8=Jd>>Lh2=Jd@>Lh2?Nl00cW>?Nlmk`02?Nl2=Jd2
<H`2=JdV?Nl4@Q0>?Nl6@Q04?Nl@@Q02?Nl@@Q02>Lh2;F/27>L236<:0005Ool10001Ool001Eoo`03
001oogoo009ooaXicP8e[@@icPPe[A0icP@e[@@icP8e[@HicPHe[@HicPPe[A`icP@mk`8icP<mk`8i
cP8e[@8aS08e[B@mk`Q240`mk`Q2408mkaA240@mk`9240A6<@92408e[@8U:@8@Q0848@`000Eoo`40
005oo`005Goo00<007ooOol00Woo6SW>0SF]13W>23F]43W>13F]13W>0SF]1SW>1SF]1SW>23F]73W>
13g_0SW>0cg_0SW>0SF]0S6<0SF]93g_248@33g_248@0Sg_548@13g_0T8@14Ha0T8@0SF]0RDY0Q24
0P@Q30001Goo0@000Goo000EOol00`00Oomoo`02Oom0>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd:>Lh4
?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhP?Nl2@Q02?Nl6@Q0>?NlN@Q02?Nl2@Q04AS42?Nl2<H`28@P2
48@2124>0005Ool10001Ool001Eoo`03001oogoo009ood0icP@e[@HicP8e[@PicP8e[@8aS08e[@Xi
cP@mk``icPPmk`8icP<mk`8icP@e[@8icR0mk`92408mk`I240hmkai2408mk`9240A6<@8mk`8aS08Q
208@Q0848@h000Eoo`40005oo`005Goo00<007ooOol00Woo6SW>0SF]>3W>13F]2SW>3Sg_13W>2cg_
0SW>13F]0SW>83g_148@0Sg_1T8@23g_648@0Sg_2T8@1THa0SW>0RU:0QS60PaS0P@Q40001Goo0@00
0Goo000EOol00`00Oomoo`02OolJ>Lh2=Jdh>Lh4=Jd:>Lh>?Nl4>Lh;?Nl2>Lh4=Jd2>LhP?Nl4@Q02
?Nl6@Q08?NlH@Q02?Nl:@Q06AS42>Lh2:DX26<H236<2124@0005Ool10001Ool001Eoo`03001oogoo
009oo`8mke0icPHe[@8icP8mk`@icQlmk`@e[@8icQXmk`a2408mk`I240Hmkb9240I6<@8mk`8e[@8U
:@8@Q0848@h000848@@000Eoo`40005oo`005Goo0P000goo0Sg_D3W>1SF]0SW>0Sg_13W>7cg_13F]
0SW>6Sg_348@0Sg_1T8@1Sg_8T8@1THa0Sg_0SF]0RDY0Q240P@Q3P000P@Q100017oo0P000Goo000E
Ool00`00Oomoo`02OolL?Nlf>Lh6=Jd2>Lh2?Nl4>Lh4?Nl4>LhF?Nl00cW>=Jde[@02<H`2>Lh4@Q04
>Lh>?Nl:@Q02?NlJ@Q08AS42@Q04AS48@Q04AS42BU82AS42@Q02<H`27>L236<21242000212440004
124:0005Ool10001Ool001Eoo`03001oogoo009ooa`mkcHicPHe[@8icP8mk`@icP@mk`@icQHmk`03
>Lhe[CF]008aS08icPA240@icPhmk`Y2408mkaY240Q6<@9240A6<@Q240A6<@9:DP96<@92408aS08L
i`8<H`848@8000848@@000@48@X000Eoo`40005oo`005Goo00<007ooOol00Woo63g_23W>23g_13W>
63g_23W>0Sg_0SW>1SF]13W>6Sg_13W>1Sg_00<icSF]=Jd00SF]0SW>1Sg_0SW>13g_6T8@13g_848@
14Ha0Sg_0T8@1THa0SW>0Re[0QcW0PaS0P@Q0P000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolH?Nl8>Lh8?Nl4>LhH?Nl8>Lh2?Nl2>Lh6=Jd4>LhJ?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2
>Lh4?NlJ@Q04?NlP@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124D0005Ool10001Ool0
01Eoo`03001oogoo009ooa`mk`@icPPmk`@icP`mk`@icPhmk`8icP8mk`8icP@e[@@icRHmk`03>Lhe
[CF]008icP8mk`9240hmkca240Q6<@8mk`8aS08U:@8DY@88@P848@@000848A@000Eoo`40005oo`00
5Goo00<007ooOol00Woo73g_13W>23g_13W>33g_13W>3Sg_0SW>0Sg_0SW>13F]13W>9Sg_00<icSF]
=Jd00SW>0Sg_0T8@3Sg_?48@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q50001Goo0@000Goo000E
Ool00`00Oomoo`02Ool<?Nl4@Q02?Nl6@Q0f?Nl8>LhV?Nl5>Lh4?Nl4@Q02?Nl4@Q08?NlZ@Q02AS48
@Q02AS44@Q02AS42BU82AS42>Lh2;F/26<H248@212480002124D0005Ool10001Ool001Eoo`03001o
ogoo009oo``mk`A2408mk`I243Hmk`PicRHmk`DicP@mk`A2408mk`A240PmkbY24096<@Q24096<@A2
4096<@9:DP96<@8icP8]J`8HaP8@Q0848@P000848A@000Eoo`40005oo`005Goo00<007ooOol00Woo
448@0Sg_1T8@13g_148@;Sg_1SW>:3g_0SW>1Cg_348@23g_=48@0THa0T8@0THa0TYB0THa0SW>0RU:
0QS60PQ20P@Q100010@Q60001Goo0@000Goo000EOol20003Ool@@Q02?Nl6@Q04?Nl4@Q0^?Nl6>LhX
?Nl2>Lh5?Nl<@Q08?Nld@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124H0004Ool2
0001Ool001Eoo`03001oogoo009ooaY2408mk`I2408mkaQ2410mk`PicP8mk`92410mk`A241<mk`A2
40@mkdI24096<@A:DP8icP8YBP8HaP8<H`H000@48AX000Eoo`40005oo`005Goo00<007ooOol00Woo
6T8@0Sg_1T8@0Sg_648@43g_23W>0Sg_0T8@43g_148@4cg_148@13g_AT8@0THa14YB0SW>0RU:0QS6
0PaS1P0010@Q6P001Goo0@000Goo000EOol00`00Oomoo`02Ool2AS46@Q04AS4d@Q0<?Nl6>Lh4?Nl2
@Q0B?Nl2@Q04?Nl2@Q0:?Nl7@Q04?NlJ@Q0:AS4D@Q02AS48@Q06AS42BU82?Nl29BT25:D2248V0005
Ool10001Ool001Eoo`03001oogoo009oo`96<@I240A6<CA240`mk`HicP@mk`92418mk`9240@mk`92
40Xmk`M240@mkaY240Y6<AA24096<@Q240I6<@9:DP8mk`8U:@8DY@88@RH000Eoo`40005oo`005Goo
00<007ooOol00Woo6THa<T8@23g_248@33g_2T8@2Sg_5D8@14Ha2T8@24Ha4T8@0THa0T8@1THa148@
14Ha0TYB0THa0SW>0RDY0Q2410@Q0P000P@Q30000P@Q50001Goo0@000Goo000EOol00`00Oomoo`02
OolJAS4b@Q08?Nl8@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q08AS4B@Q02AS42@Q06AS44@Q04AS42BU82AS42
>Lh29BT248@412420002124<0002124D0005Ool10001Ool001Eoo`03001oogoo009ooaY6<@Q240Y6
<B1240@mkb9240@mk`8icP@mk`m240Y6<@Y240I6<A1240I6<@9240a6<@A:DP8icP8U:@8DY@P48@H0
00@48AH000@48@Eoo`40005oo`001goo10000goo0P001Goo00<007ooOol00Woo6THa248@2THa848@
13g_8T8@13g_0SW>13g_3d8@2THa2T8@1THa448@1THa0T8@34Ha14YB0SW>0RDY0QBU20@Q1P0010@Q
5P0010@Q1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol00Woo0TYB
;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa148@0THa1T8@34Ha148@
0THa14YB0THa0SW>0RU:0Q240PQ220@Q90001Goo0@000Goo0008Ool00`00Oomoo`02Ool01000Oomo
o`0017oo0P000goo0TYB;4Ha5T8@0THa0TYB0THa0T8@0Sg_14Ha13g_5T8@0Sg_148@1Sg_:D8@1THa
148@0THa1T8@34Ha148@0THa14YB0THa0SW>0RU:0Q240PQ220@Q900017oo0P000Goo0009Ool01@00
Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo34YB24Ha1TYB6THa248@0THa148@0Sg_
13W>0Sg_148@14Ha148@0THa248@14Ha1T8@0THa3T8@0THa8d8@24Ha148@5THa0T8@14Ha0T8@0SF]
0RDY0QBU0PQ2:0000P@Q10001Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03
001oogoo009oo`a:DPQ6<@I:DQY6<@Q24096<@A2408mk`@icP8mk`A240A6<@A24096<@Q240A6<@I2
4096<@i24096<B=240Q6<@A241I6<@9240A6<@92408e[@8U:@8DY@88@RP000848@@000Eoo`40005o
o`0027oo0P0017oo0P001Goo00<007ooOol00Woo94YB6THa0T8@0Sg_0SW>0S6<0Re[0SF]0T8@0TYB
0Tic34Ha148@1THa148@0THa2T8@5DHa148@=4Ha0TYB0THa0SF]0RDY0Q240PQ230000P@Q30000P@Q
300020@Q1Goo0@000Goo000EOol00`00Oomoo`02OolTBU8JAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02
BU82CW<<AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0dAS42BU82AS42=Jd29BT248@2248<0002124<0002
124<00081245Ool10001Ool001Eoo`03001oogoo009oo`i:DPI>L`Q:DPA6<Ai:DPA6<@8mk`8e[@8a
S08mk`9:DPABU09>L`A240Q6<@A24096<@9:DPQ6<@Q240A6<@924456<@I:DP96<@8icP8YBP8HaP88
@P848@8000h48@P000X48@@000X48@Eoo`40005oo`005Goo00<007ooOol00Woo3TYB1Tic24YB14Ha
7TYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@24Ha148@0THa0TYB24Ha248@14Ha0T8@@DHa1TYB
0THa0SW>0RU:0QS60PQ20P@Q0P003P@Q20002P@Q10002P@Q1Goo0@000Goo000EOol00`00Oomoo`02
Ool4CW<8BU86CW<8BU82CW<2AS44BU88CW<2BU86AS44@Q06AS48BU82AS42@Q02BU82E[D2F]H2IcT2
G_L2CW<2@Q0<AS44BU82AS42@Q04AS46@Q0cAS44BU8BAS44BU82AS42?Nl2:DX26<H236<212440004
12460002124:000H1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`Q:DPI>L`Q:DP9>L`96<@A:
DPQ>L`9:DPI6<@A240I6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240a6<@A:DP96<@9240A6
<@I243=6<@A:DQ96<@A:DP96<@8mk`8YBP8HaP8<H`848@@000@48@H000848@X001P48@Eoo`40005o
o`005Goo00<007ooOol00Woo24ic24YB34ic0U:D1Tic0TYB0THa0T8@0Sg_1SF]136<1SF]0SW>13g_
1T8@0Tic0U[F0V<H0Vmk0VLi0UJe0TYB1THa1TYB0THa13g_0T8@0THa0TYB24Ha0TYB<DHa2TYB2THa
14YB0T8@0S6<0QcW0PaS0P@Q700060@Q1Goo0@000Goo000EOol20003Ool8CW<8BU8<CW<2DY@6CW<2
BU82AS42@Q02?Nl6=Jd4<H`6=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2IcT2E[D2BU86AS46BU82AS44
?Nl2@Q02AS42BU88AS42BU8aAS4:BU8:AS44BU82@Q02<H`27>L236<2124L000H1244Ool20001Ool0
01Eoo`03001oogoo009ooaY>L`9:DP9>L`9:DP96<@92408icP8e[@8aS0@]J`HYBP`U:@@YBP8]J`8m
k`9BU09S60AW>@9JeP9>L`9:DPA6<@9>L`ABU096<@8icP8e[@8icP924096<@A:DPA6<@I:DS56<@Q:
DPI6<@I:DP92408e[@8Q208@Q0848@@000`48@h001P48@Eoo`40005oo`005Goo00<007ooOol00Woo
6Tic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:32DY12U:0Re[0Sg_0U:D0V<H16Li0U[F0Tic
0TYB14Ha0Tic15:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha1TYB<DHa24YB1THa1TYB0T8@0SF]0R48
0Q240P@Q100030@Q3P0060@Q1Goo0@000Goo000EOol00`00Oomoo`02OolBCW<4DY@2CW<2BU82AS44
?Nl2=Jd2<H`2;F/>:DX49BT28@P27>L86<H28@P2>Lh2F]H2Kg/2Li`2IcT2E[D6DY@2F]H2IcT2HaP2
E[D2@Q04<H`2@Q02BU82AS4<BU8GAS4BBU8>AS44BU84AS46BU82AS42>Lh29BT25:D2248412420006
12420002124D000D1245Ool10001Ool001Eoo`03001oogoo009ooa9>L`ABU09>L`9:DP96<@@mk`8e
[@8aS08]J`hYBP@U:@8Q208Li`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP9W>@9S609F]@92
40@aS092409:DP96<@a:DQM6<A9:DPi6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P@48@8000H48@80
00848A@001@48@Eoo`40005oo`005Goo00<007ooOol00Woo34ic15:D14ic0TYB0T8@0Sg_0SW>0S6<
32e[12U:1Re[12U:12DY1R480RU:0SW>0Tic0VLi0W>L0V]J0UJe0TYB0U:D0U[F0Ukg0V<H0VLi0Ukg
0U:D0T8@0Sg_0T8@14YB0Tic3TYB5DHa34YB1THa1TYB14Ha1TYB14Ha1TYB0THa0SW>0RDY0QBU0PQ2
100020@Q2P001P@Q10006P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<CW<4DY@4CW<2BU82@Q02
?Nl2>Lh2<H`<;F/4:DX6;F/4:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2
HaP2IcT2G_L2DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS46BU84AS46BU84AS46BU82AS42>Lh2
9BT25:D224840008124:00061244000J1245Ool10001Ool001Eoo`03001oogoo009oo`A>L`YBU09>
L`96<@8mk`8e[@@aS08]J`8aS0P]J`8aS0@]J`XaS08]J`PaS08e[@92409F]@9W>@A_N`9JeP96<@8m
k`9:DP9JeP9Nm`9JeP9F]@Q:DPA>Ld5:DPA6<@a:DP96<@8icP8]J`8HaP8<H`848@@000H48@X000P4
8@@001X48@Eoo`40005oo`005Goo00<007ooOol00Woo14ic2U:D0Tic0THa0Sg_0SF]136<0Re[0S6<
22e[0S6<12e[2S6<0Re[236<0SF]0T8@0UJe0VLi16mk0U[F0THa0Sg_0TYB0U[F0Ukg0U[F0UJe24YB
14ic@DYB14Ha34YB0THa0SW>0Re[0QS60PaS0P@Q10001P@Q2P0020@Q10006P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool8DY@4CW<2AS42?Nl2=Jd2;F/4:DX4;F/:<H`8=Jd<>Lh6?Nl2AS42E[D2HaP2
Kg/2JeX2IcT2CW<2?Nl2=Jd2>Lh2AS44BU82CW<2BU8<CW<IBU88CW<ZBU82CW<2AS42?Nl2;F/27>L2
36<>1248000:1244000J1245Ool10001Ool001Eoo`8000=oo`QBU0A>L`96<@8mk`8e[@8]J`@YBP@]
J`XaS0Pe[@`icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP9>L`9:DPa>LaU:
DPQ>LbY:DP9>L`96<@8mk`8]J`8Li`8<H`h48@P000X48@@001X48@Aoo`80005oo`005Goo00<007oo
Ool00Woo15:D0Tic0TYB0T8@0Sg_136<22e[2S6<13F]1SW>1Sg_1T8@1THa0TYB0Tic0U:D0UJe0U[F
0Ukg0V<H0U:D0THa0SW>1SF]0T8@0Tic15:D0Tic1TYB0Tic0U:D34ic>DYB0THa14YB0T8@0S6<0R48
0QBU2P@Q3P00:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@2CW<2BU82@Q02?Nl4<H`8;F/:
<H`4=Jd6>Lh6?Nl6@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42>Lh6=Jd2@Q02CW<4DY@2
CW<6BU82CW<2DY@<CW<iBU82AS44BU82@Q02<H`28@P25:D:124>000X1245Ool10001Ool001Eoo`03
001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`haS0@e[@8icPHmk`Q240A6<@A:DP9>L`IBU09>L`9B
U09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`96<BE>LaQ:DP9>L`Y:DPA>L`a:DP96<@8e[@8U:@8@
Q088@P848A@002X48@Eoo`40005oo`005Goo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3S6<
13F]0SW>1Sg_248@14Ha14YB0Tic1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_0THa
9Dic64YB0Tic2TYB14ic34YB0THa0SF]0RDY0Q240PQ20P@Q5000:P@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool2?Nl2=Jd2<H`6;F/B<H`2=Jd4>Lh4?Nl4@Q08AS44BU84CW<6DY@:E[D6DY@2CW<2BU82
@Q02?Nl2>Lh2BU82CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU86CW<2BU82AS42BU86CW<2?Nl2:DX26<H2
24821244000212440002124800081242000R1245Ool10001Ool001Eoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja8aS08e[@@icP@mk`A240Q6<@A:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`8icP9:DP9>
L`9BU09F]@ABU1e>La1:DPY>L`A:DPI>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@000848@@0
00848@P000P48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<1Re[3S6<13F]0SW>0SF]
0SW>13g_148@14Ha24YB1Tic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@0Sg_0THa0TYB1U:D
>Dic14YB1Tic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P0030@Q1P002P@Q0P008P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`6;F/><H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04AS48BU86CW<8DY@2E[D2F]H4
E[D2DY@4E[D2DY@4CW<2BU82@Q02?Nl2AS42BU86DY@iCW<4BU86CW<6BU84CW<2AS42<H`27>L236<2
1242000<1246000:1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]Ja8aS08e[@@icP8m
k`A240A6<@Q:DPA>L`QBU0iF]@QJeP9F]@ABU09:DP96<@8mk`96<@9>L`YBU1m>L`9BU1A>L`A:DP9>
L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@48@@000848@H000X48@8002848@Eoo`40005oo`00
5Goo0P000goo1Re[4S6<0SF]13W>0Sg_148@14Ha24YB14ic25:D3UJe25[F0UJe15:D0TYB0THa0Sg_
0THa0Tic2U:D7dic0U:D54ic14YB0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q10000P@Q
1P002P@Q0P008P@Q17oo0P000Goo000EOol00`00Oomoo`02Ool6;F/><H`2=Jd4>Lh4?Nl4@Q04AS44
BU88CW<4DY@:E[D@F]H8E[D4DY@2AS42@Q02AS42CW<8DY@6CW<:DY@YCW<2BU88CW<2BU82?Nl2;F/2
6<H22486000L1242000R1245Ool10001Ool001Eoo`03001oogoo009oo`H]J`haS08e[@@icP@mk`A2
40A6<@A:DPQ>L`ABU0YF]A1JePQF]@ABU096<@924096<@9>L`QBU0I>L`YBU2U>L`9:DPQ>L`9:DP8m
k`8]J`8HaP88@PH001`48@8002848@Eoo`40005oo`005Goo00<007ooOol00Woo336<1SF]13W>13g_
148@14Ha1TYB1Tic1U:D25Je65[F15Je15:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Tic
0U:D0Tic0THa0S6<0R480Q240P@Q1P0070@Q0P008P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<
<H`6=Jd4>Lh4?Nl4@Q04AS46BU86CW<6DY@8E[DHF]H4E[D4DY@2BU82AS42@Q02BU82CW<6DY@4CW<<
DY@?CW<2DY@NCW<2DY@2CW<2AS42<H`28@P248@21246000L1242000R1245Ool10001Ool001Eoo`03
001oogoo009oo`PaS0Pe[@8icPHmk`A24096<@A:DPI>L`QBU0IF]AIJePINm`AJePIF]@9BU09:DPA2
409:DPAF]@iBU0A>L`]BU0A>L`IBU1Q>L`ABU09:DP8icP8U:@8@Q0848@P004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo236<23F]0SW>1Sg_148@0THa14YB1Tic25:D1UJe5U[F1Ukg15[F1UJe0U:D
0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D64ic15:D0TYB0SW>0RDY0Q240P@Q2000@0@Q1Goo0@00
0Goo000EOol00`00Oomoo`02Ool6<H`8=Jd2>Lh4?Nl6@Q02AS44BU86CW<6DY@8E[D<F]HDG_L4F]H6
E[D2DY@2AS42@Q02AS42DY@2E[DUDY@JCW<2DY@2CW<2@Q02;F/26<H236<212420002124400101245
Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`HaS0Pe[@8icP@mk`I24096<@A:DPI>
L`IBU0QF]@aJeQANm`AJePIF]@9BU096<@924096<@9BU09F]BEBU1Y>L`9BU09>L`92408]J`8HaP8<
H`848@8000848@@004048@Eoo`40005oo`002Woo00@007ooOol0009oo`03001oogoo009oo`03001o
ogoo009oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF]@YJePiNm`9S60YNm`9JePIF]@9>L`96
<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@004048@Eoo`40005o
o`001goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`PaS0@e[@@icP8mk`A240I6<@A:DPI>L`IBU0QF
]@YJePiNm`9S60YNm`9JePIF]@9>L`96<@92409:DQmBU0A>L`ABU1Q>L`ABU096<@8e[@8Q208@Q088
@P848@8000848@@004048@Aoo`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2
E[D2BU84AS42CW<WDY@<CW<2DY@6CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool1
0001Ool000Qoo`03001oo`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl2
@Q08AS44BU84CW<8DY@8E[D6F]H:G_L:HaP:G_L4F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@6
CW<4DY@2CW<2?Nl2:DX25:D2248212440002124400101245Ool10001Ool000Uoo`8000=oo`8000Eo
o`03001oogoo009oo`8aS08e[@@icPPmk`9240I6<@A:DPA>L`IBU0IF]@aJePYNm`iS60YNm`IJeP9F
]@9BU09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`ABU09:DP92408]J`8Li`8<H`848@H000848@@00404
8@Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1THa14YB14ic1U:D1UJe35[F
2Ukg3V<H2Ukg1U[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic15:D0TYB0T8@0Re[0QcW0PaS
0P@Q1P000P@Q1000@0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4@Q04AS44BU86
CW<4DY@8E[D<F]H6G_L2HaP2G_LDHaP:G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2CW<2BU82CW<4
DY@2AS42>Lh28@P25:D2248612420002124400101245Ool10001Ool001Eoo`03001oogoo009oo`8e
[@HicP@mk`A240A6<@A:DPI>L`ABU0QF]@aJePINm`9S609NmaAS60YNm`9JePAF]@9>L`A:DP9>LamB
U0Q>L`YBU09>L`9:DP9>L`ABU096<@8icP8Q208DY@88@PH48@8000848@@004048@Eoo`40005oo`00
5Goo00<007ooOol00Woo13W>13g_148@1THa14YB1Tic1U:D1UJe35[F2Ukg66<H25kg1U[F0U:D1TYB
0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D0UJe0U:D0Sg_0Re[0QS60Q240PQ20P@Q2000A0@Q
1Goo0@000Goo000EOol00`00Oomoo`02Ool4>Lh4?Nl4@Q06AS44BU86CW<6DY@6E[D<F]H:G_LHHaP8
G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4CW<>DY@4CW<2DY@2E[D2DY@2?Nl2;F/26<H248@2
2482124800141245Ool10001Ool001Eoo`03001oogoo009oo`8icP@mk`A240I6<@A:DPI>L`QBU0AF
]@YJePaNm`iS609W>@aS60YNm`9JeP9F]@Q>LbeBU0I>L`ABU09:DP8aS08Q208DY@8@Q088@P848@H0
04H48@Eoo`40005oo`005Goo0P000goo0SW>13g_148@1THa14YB1Tic25:D15Je2U[F35kg3V<H0VLi
36<H2Ukg0U[F0UJe24ic;E:D1Tic15:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00AP@Q17oo0P000Goo
000EOol00`00Oomoo`02Ool2?Nl6@Q04AS46BU84CW<:DY@4E[D:F]H>G_L>HaP8IcT<HaP4G_L4F]H2
DY@6CW<[DY@8CW<2DY@2CW<2?Nl2:DX26<H248@236<4124400181245Ool10001Ool001Eoo`03001o
ogoo009oo`8mk`I240A6<@I:DPA>L`YBU0AF]@YJePiNm`iS60QW>@aS60ANm`AJeP9BU0I>Lb]BU0Q>
L`9BU09>L`8mk`8YBP8HaP8@Q08<H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo1T8@
14Ha24YB1Tic25:D0UJe3U[F35kg8V<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic15:D0TYB
0SF]0R480QBU0Q240PaS0P@Q1P00B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6@Q04AS48BU86
CW<8DY@2E[D>F]H<G_LRHaP2G_L6F]H2E[D2CW<4BU82CW<YDY@2CW<2DY@2CW<4DY@2BU82=Jd28@P2
5:D248@236<2124600181245Ool10001Ool001Eoo`03001oogoo009oo`A240I6<@Q:DPA>L`QBU0AF
]@iJePaNmb1S60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iBU0A>L`9BU09>L`92408]J`8HaP8@Q0@<
H`@48@@004P48@Eoo`40005oo`005Goo00<007ooOol00Woo148@1THa24YB14ic25:D15Je3U[F35kg
86<H15kg1U[F0UJe0U:D14YB0Tic6e:D0Tic3U:D14ic0U:D0Tic0T8@0Re[0QS60Q2410aS10@Q1000
B0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q06AS44BU88CW<6DY@8E[D<F]H>G_LPHaP6G_L6
F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2CW<4DY@2CW<2>Lh29BT25:D436<2249@1245Ool10001Ool0
01Eoo`03001oogoo009oo`9240I6<@A:DPQ>L`IBU0QF]@aJePiNmb1S60INm`IJeP9BU09>L`A:DPI>
LaEBU0I>L`YBU09>L`ABU09>L`8icP8U:@8DY@@<H`88@U048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1THa1TYB1Tic1U:D25Je35[F35kg2V<H0VLi76<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic
15:D24ic15:D0T8@0Re[0QcW0Q2410aS0PQ2D0@Q1Goo0@000Goo000EOol20003Ool6AS46BU86CW<6
DY@8E[D<F]H<G_L:HaP2IcTLHaP8G_L2E[D2DY@6BU84CW<2DY@4CW<5DY@@CW<4DY@8CW<4DY@2@Q02
;F/27>L248@436<2249@1244Ool20001Ool001Eoo`03001oogoo009oo`A6<@A:DPY>L`IBU0IF]@YJ
ePiNm`YS60IW>AYS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@8Q208DY@@@Q088@Rh4
8@88@R848@Eoo`40005oo`005Goo00<007ooOol00Woo14Ha14YB2Tic1U:D1UJe2U[F3Ukg2V<H1VLi
6V<H25kg0U[F0U:D0Tic1TYB24ic0e:D7Tic0U:D0TYB0SF]0R480QBU11240PQ2;P@Q0PQ28P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool2AS48BU82CW<:DY@4E[D>F]H>G_L:HaP:IcT4HaP<IcT8HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/2
6<H648@2248`1242248P1245Ool10001Ool001Eoo`03001oogoo009oo`96<@Q:DP9>L`YBU0AF]@iJ
ePiNm`YS60YW>@AS60aW>@QS60ANm`9JePAF]@9>L`9:DP96<@A:DPQ>L`03DYA>Ldic00I>L`9BU0a>
L`9BU09>L`9:DPA>L`96<@8]J`8HaPH@Q088@S048@88@R048@Eoo`40005oo`005Goo00<007ooOol0
0Woo1TYB1Tic2U:D15Je3U[F3Ukg2V<H36Li1V<H16Li36<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic
0TYB0Sg_0RU:0QBU0Q2410aS0PQ2;P@Q10Q280@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6BU86
CW<:DY@4E[D>F]H>G_L:HaP<IcT6HaP4IcT<HaP4G_L4F]H2E[D2DY@2CW<4AS42BU8WCW<2BU82?Nl2
:DX25:D248@436<2248^1244248P1245Ool10001Ool001Eoo`03001oogoo009oo`A:DPQ>L`QBU0AF
]@iJePaNma1S60YW>AQS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q208@Q0@<H`@8@QP4
8@88@Q048@P8@R048@Eoo`40005oo`005Goo00<007ooOol00Woo14YB24ic25:D15Je3U[F35kg46<H
2VLi66<H15kg15[F0UJe0Tic14Ha0TYB8dic15:D0THa0SF]0R480Q2410aS10Q260@Q0PQ240@Q20Q2
80@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU88CW<<E[D>F]H<G_L:HaP4IcT6HaP6IcTHHaP4
G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2BU82CW<4DY@2@Q02:DX26<H448@236<4248F1244248<124<
248P1245Ool10001Ool001Eoo`8000=oo`A:DPQ>L`aF]@iJePaNm`YS60AW>@IS60IW>AQS60ANm`AJ
eP9F]@9BU09:DPA6<@9:DQe>L`9:DP9>L`ABU092408YBP8HaP@@Q08<H`@8@QH48@@8@P`48@`8@R04
8@Aoo`80005oo`005Goo00<007ooOol00Woo14YB1Tic0U:D35Je3U[F35kg2V<H1VLi1V<H16Li5V<H
1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS60QBU0Q240PaS
20Q24P@Q10Q22P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool4BU86CW<2DY@<E[D>F]H<
G_L:HaP6IcT6HaP4IcTFHaP6G_L4F]H2E[D2DY@2CW<6AS42BU8CCW<2BU86CW<2BU82CW<2DY@2CW<2
>Lh28@P26<H25:D248@236<8248B1244248:124@248N1245Ool10001Ool001Eoo`03001oogoo009o
o`9:DPI>L`ABU0aF]@aJeQ9Nm`IS60YW>AaS60INm`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:
DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP@DY@8@Q08<H`P8@P`48@X8@PH48@88@P848A08@Qh4
8@Eoo`40005oo`005Goo00<007ooOol00Woo0TYB1Tic15:D35Je35[F4Ukg1V<H2VLi76<H1Ukg15[F
0UJe0U:D0Tic0TYB0THa0T8@0TYB1dic14YB24ic14YB14ic0TYB0Tic0U:D0THa0S6<0QS611BU0Q24
0PaS20Q230@Q2PQ21P@Q0PQ20P@Q40Q27P@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6CW<6DY@:
E[D>F]HBG_L4HaP>IcTJHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2BU82CW<6BU88CW<2
>Lh29BT65:D248@:248:124V248N1245Ool10001Ool001Eoo`03001oogoo009oo`I>L`IBU0YF]@iJ
eQ9Nm`AS60iW>AYS60INm`AJePAF]@9BU09:DPI6<@A:DP=>L`A:DPA>L`9:DP9>L`I:DPQ>L`8icP8U
:@HDY@8@Q0X8@PX48BH8@Qh48@Eoo`40005oo`005Goo00<007ooOol00Woo1Tic15:D35Je3U[F25kg
1V<H15kg16<H0VLi0V<H2VLi6V<H2Ukg0U[F0UJe0U:D0Tic1THa6DYB1Tic0TYB0SF]0R480Q240QBU
0QS60Q2410Q20P@Q10Q22P@Q10Q210aS7PQ26P@Q10Q21Goo0@000Goo0007Ool30004Ool20005Ool0
0`00Oomoo`02Ool6CW<4DY@<E[D>F]H8G_L6HaP4G_L4HaP2IcT2HaP:IcTJHaP:G_L2F]H2E[D2DY@2
CW<6AS4IBU86CW<2BU82=Jd28@P248@25:D26<H248@424821244248:1244248436<N248J12442485
Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D25Je
45[F3Ukg16<H46Li76<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
11BU0PaS30Q210@Q0PQ21PaS0Q240PaS1PQ21P@Q4PQ26P@Q10Q21Goo0@000Goo0007Ool01000Oomo
o`000Woo00@007ooOol000Aoo`8000=oo`9>L`YBU0QF]A1JePiNm`AS611W>AaS60YNm`AJeP9F]@9>
L`9:DPA6<@9240e:DP96<@Y:DPA>L`8mk`8YBP8HaP8@Q0@DY@8<H``8@P@48@88@PH<H`8@Q08<H`H8
@PH48A88@QX48@@8@PAoo`80005oo`001goo0`000goo00@007ooOol000Aoo`03001oogoo009oo`9>
L`QBU0YF]A1JePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>
L`9:DP8icP8U:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eo
o`40005oo`0027oo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo009oo`9>L`QBU0YF]A1J
ePiNm`IS60iW>AaS60YNm`AJeP9F]@9BU09>L`9:DP96<@924096<@]:DP96<@Y:DP9>L`9:DP8icP8U
:@8DY@8<H`@DY@8<H`X8@PH48@88@P8<H`8Li`8HaP8DY@8<H`P8@P@48A08@R048@Eoo`40005oo`00
27oo0`000goo0P001Goo00<007ooOol00Woo0Tic1U:D35Je45[F35kg1V<H46Li76<H2Ukg15[F15Je
0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW0Q240PaS11240PaS1PQ22P@Q0PQ20PaS
0R480QcW0QBU0PaS70Q27P@Q0PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2CW<6DY@<E[D@F]H<
G_L6HaP@IcTLHaP:G_L4F]H4E[D2DY@2CW<2AS42@Q02AS4;BU82AS4:BU82CW<2AS42<H`27>L248@2
36<448@236<6248:1242248236<28@P27>L25:D236<L248N12422485Ool10001Ool001Eoo`03001o
ogoo009oo`IBU0aF]A1JePYNm`QS619W>AaS60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB
00A:DPI6<@9:DP96<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@8@Q08<H`88@Ph48@8<H`8@Q0@HaP8DY@8<
Ha`8@Q`48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U:D35Je45[F2Ukg26<H4VLi76<H2Ukg
1U[F0UJe0U:D0Tic0TYB0THa0T8@00=6<DYBBU8014YB1THa0TYB0THa24YB0Sg_0Re[0QS60Q240PaS
0QBU0Q240PaS0PQ23P@Q0PaS0Q2411S60QBU0PaS70Q270@Q10Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool6DY@8E[DDF]H:G_L:HaP@IcTNHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT2
5:D236<248@25:D248@236<2248<1244248836<H248236<4248J12462485Ool10001Ool001Eoo`03
001oogoo009oo`IBU0QF]AAJePYNm`YS611W>AiS60QNm`IJeP9F]@ABU09:DP96<@=24196<@I:DP8i
cP8U:@8DY@8<H`8@Q08DY@8@Q08<H`88@P`48@@8@PP<HaP8@P8<H`@8@QX48@H8@PEoo`40005oo`00
5Goo00<007ooOol00Woo15:D25Je5U[F3Ukg2V<H4VLi66<H25kg1U[F0UJe15:D0Tic0TYB1d8@3THa
14YB0THa0SF]0R480Q2410aS0Q240PaS10Q23P@Q80Q210aS10Q26P@Q1PQ21Goo0@000Goo000EOol2
0003Ool4DY@8E[DFF]H>G_L:HaPBIcTHHaP8G_L6F]H2E[D4DY@2CW<2BU87@Q0>AS44BU82AS42=Jd2
8@P248@436<248@236<4248>124P248436<4248J12462484Ool20001Ool001Eoo`03001oogoo009o
o`ABU0QF]AAJeQ1Nm`YS619W>AaS60ANm`9JeP9Nm`9JePIF]@9BU09:DP96<@03@Q0mkcg_00A240a6
<@9:DP96<@92408aS08Li`8@Q0H<H`H8@PX48@88@P@48@H8@P@48A@8@P@<H`H8@P848@@8@PP48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo15:D25Je55[F45kg2V<H4VLi76<H15kg0U[F0Ukg0U[F
1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB0THa0T8@0S6<0QcW0Q241PaS1PQ22P@Q0PQ210@Q
1PQ210@Q50Q210aS1PQ20P@Q10Q220@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool4DY@8E[DD
F]H<G_L:HaP6IcT4HaP>IcTJHaP4G_L2F]H4G_L2F]H4E[D2DY@2BU82AS400d8@?Nlmk`06@Q06AS42
@Q02AS42BU82AS42?Nl2;F/26<H648@236<2248>124<248412462482124<248436<6248212442488
124@2485Ool10001Ool001Eoo`03001oogoo009oo`ABU0QF]AAJePaNm`YS60IW>@AS60iW>AYS60AN
m`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@
Q08<H`88@Ph48@`8@P@48@H8@P848@`8@P@<H`H8@P848@@8@PP48A08@PEoo`40005oo`005Goo00<0
07ooOol00Woo35Je45[F45kg26<H16Li26<H0VLi1V<H1VLi56<H3Ukg1U[F0UJe0U:D14ic00=6<Cg_
?Nl00Sg_1T8@14Ha148@0TYB0THa0SF]0RDY0QS61Q240PaS5P@Q0PQ210@Q5PQ210aS2PQ20P@Q1PQ2
1P@Q3PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool<E[D@F]H@G_L8HaP4IcT8HaP2IcT6HaP6IcTD
HaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT26<H648@236<F
12422484124F248436<:248212462486124>2485Ool10001Ool001Eoo`03001oogoo009oo`YF]A9J
eQ1Nm`YS609W>@QS609W>@IS60IW>AAS60ANm`9S60QNm`IJePAF]@9BU09>L`03BU92448@00Q240A6
<@A24096<@92408e[@8U:@8HaP8DY@8@Q08<H`88@Q@48@@8@P@48AH8@P@<H`X8@P848@H8@P@48A08
@PEoo`40005oo`005Goo00<007ooOol00Woo2UJe4U[F45kg2V<H0VLi26<H0VLi1V<H1VLi56<H15kg
0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@0SF]0RDY0QS60QBU0Q240PaS
0PQ250@Q10Q210@Q5PQ210aS2PQ20P@Q1PQ210@Q40Q21Goo0@000Goo000EOol00`00Oomoo`02Ool8
E[DDF]H@G_LDHaP2IcT6HaP6IcT>HaP2G_L6HaP2G_L4HaP6G_L8F]H2E[D4DY@00dYBAS56<@04@Q02
?Nl2@Q02AS46@Q02AS42@Q02<H`28@P26<H25:D248@236<2248D124N248436<:248212462482124B
2485Ool10001Ool001Eoo`8000=oo`QF]AAJeQ1NmaAS609W>@IS60IW>@iS609Nm`IS609Nm`AS60IN
m`QJeP9F]@ABU003BU96<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88
@Q@48Ah8@P@<H`X8@P848@H8@P848A88@PAoo`80005oo`005Goo00<007ooOol00Woo25Je55[F45kg
46<H1VLi26<H0VLi46<H0Ukg36<H1Ukg25[F15Je0U:D00=>LdYBBU800THa0T8@0Sg_2T8@0THa0Sg_
0Re[0R480QS60QBU0Q240PQ250@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[DDF]H@G_L@HaP6IcT8HaP2IcT@HaP2G_L<HaP6G_L8F]H4E[D2DY@00dicBU9:DP02AS42@Q02
?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248D124P248436<:2482124J2485Ool10001Ool001Eo
o`03001oogoo009oo`QF]AAJePiNm`iS60YW>AYS609Nm`aS60ANm`YJePAF]@9BU003CW=:DTYB0096
<@9240@mk`Y2408icP8YBP8Li`8HaP8@Q08<HaH48B08@P@<H`X8@P848AX8@PEoo`40005oo`005Goo
00<007ooOol00Woo25Je55[F3Ukg3V<H2VLi6V<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa
0T8@13g_2T8@0SW>0RU:0QcW0QS60Q240PaS5P@Q80Q210aS2PQ20P@Q6PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool8E[DDF]H<G_L>HaP<IcT2HaP4IcTDHaP2G_L<HaP4G_L:F]H4E[D2DY@3CW<2BU82
@Q04?Nl:@Q02=Jd29BT26<H25:D236<2248D124R248436<V2485Ool10001Ool001Eoo`03001oogoo
009oo`QF]AAJePaNm`iS60aW>@9S60AW>AAS609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2
408e[@8U:@8HaP8DY@8<H`88@Q@48B88@P@<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo25Je
45[F3Ukg3V<H3VLi0V<H16Li56<H0Ukg36<H1Ukg25[F1UJe00=BU4icCW<00TYB0THa0T8@1Sg_148@
0Sg_0S6<0R4811BU0PaS0PQ22P@Q0PQ210@Q9PQ20PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02
Ool8E[D@F]H>G_L>HaP>IcT2HaP4IcTDHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06
?Nl4@Q02?Nl2<H`28@P45:D236<2248:12422484124V248236<X2485Ool10001Ool001Eoo`03001o
ogoo009oo`9F]AAJeQ1Nm`iS61AW>A9S60ANm`aS60INm`YJePAF]@=BU09>L`9:DP9240Pmk`92408m
k`8]J`8Li`8DY@8@Q08<H`88@PX48@88@P848BP8@P8<HbP8@PEoo`40005oo`005Goo0P000goo0UJe
55[F45kg3V<H56Li4V<H15kg36<H1Ukg2U[F15Je0e:D0Tic0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU
0Q240PaS0PQ22P@Q0PQ20P@Q:0Q20PaS:0Q217oo0P000Goo000EOol00`00Oomoo`02Ool4E[D@F]HB
G_L>HaP@IcTDHaP4G_L:HaP2IcT2HaP2G_L2HaP4G_L8F]H5E[D2DY@2CW<4BU82@Q02>Lh4?Nl2@Q02
?Nl2:DX26<H248@236<224881242248:12482482124D248836<T248236<22485Ool10001Ool001Eo
o`03001oogoo009oo`AF]A1JeQ9Nm`iS611W>AAS60ANm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PP48@88@PX48@P8@P848A@8@PP<Hb@8
@P8<H`88@PEoo`40005oo`005Goo00<007ooOol00Woo0UJe45[F4Ukg4V<H36Li5V<H15kg3V<H25kg
25[F1EJe0U:D14ic0TYB0T8@0SW>13g_0T8@0SW>0RU:0QS60Q240PaS0PQ220@Q10Q220@Q20Q20P@Q
5PQ21PaS:0Q21Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D@F]HBG_LBHaP<IcTFHaP4G_L>HaP8
G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02>Lh2:DX26<H248@236<224881244248812482482
124F248636<X2485Ool10001Ool001Eoo`03001oogoo009oo`9F]@iJeQANmaAS60QW>AYS609Nm`iS
60QNm`YJeP=F]@ABU09>L`9:DP96<@8mk`8icP@mk`8icP8U:@8DY@8@Q08<H`88@PP48@@8@PP48@P8
@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`005Goo00<007ooOol00Woo0UJe3U[F55kg56<H26Li6V<H
0Ukg3V<H25kg2U[F0eJe15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ220@Q10Q2
20@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo000EOol00`00Oomoo`02Ool2E[D>F]HDG_LFHaP6
IcTZHaP8G_L:F]H5E[D2DY@4CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<:1246248612482482124F
248636<V248236<5Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`9F]@iJeQANmaIS
60IW>BYS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8DY@@<H`X48@H8@PH48@P8@P84
8AH8@PH<HbH8@P8<H`Eoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomo
o`02Ool@F]HFG_LBHaP8IcTZHaP:G_L8F]H5E[D4DY@2CW<2BU82@Q06>Lh2<H`28@P25:D436<:1246
248612482482124F248636<X2485Ool10001Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo
0P000goo45[F5Ukg4V<H26Li:V<H2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2P@Q
1PQ21P@Q20Q20P@Q5PQ21PaS:0Q217oo0P000Goo0008Ool20003Ool01000Oomoo`0017oo00<007oo
Ool00Woo4U[F55kg46<H2VLi;6<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU
0PaS0PQ25P@Q20Q20P@Q5PQ21PaS9PQ20PaS1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007oo
Ool000Aoo`03001oogoo009ooa9JeQANma1S60YW>BaS60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8i
cP8e[@8aS08Q208DY@8<H`88@QH48@P8@P848AH8@PH<HbH8@P8<H`Eoo`40005oo`0027oo0P0017oo
0P001Goo00<007ooOol00Woo4U[F2Ukg0V<H25kg36<H46Li:V<H35kg1e[F0UJe1U:D0Tic0TYB0T8@
0SW>0SF]0Re[0R480QBU0PaS0PQ25P@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000EOol00`00Oomo
o`02OolBF]H:G_L2HaP8G_L<HaP@IcTZHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P2
5:D236<2248F12482482124D248836<X2485Ool10001Ool001Eoo`03001oogoo009ooa9JePYNm`AS
60INm`YS61AW>BQS60iNm`EJeP9F]@IBU0A>L`96<@8mk`8e[@8]J`8Li`8DY@8<HaP48@P8@P848A@8
@PP<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo4U[F2Ukg16<H1Ukg2V<H56Li:6<H3Ukg1E[F
0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS60@Q20Q20P@Q50Q220aS:0Q21Goo0@000Goo000E
Ool00`00Oomoo`02Ool@F]H@G_L4HaP2G_L:HaP@IcTDHaP4IcT2HaP6G_L<HaP<G_L9F]H4E[D2DY@4
CW<2BU82@Q02=Jd2:DX27>L248@236<@2482124:2486124@248:36<V248212422485Ool10001Ool0
01Eoo`03001oogoo009ooa1JeQ1Nm`AS609Nm`YS611W>AAS60AW>@9S60INm`aS60aNm`UJePAF]@9B
U0A>L`9:DP92408e[@8YBP8Li`8@Q08<Ha08@P848@X8@PH48A08@PX<HbH8@P848@88@PEoo`40005o
o`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi16<H46Li56<H0VLi16<H15kg3V<H35kg2E[F15Je
0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q:PQ240aS90Q21Goo0@000Goo000EOol20003
Ool@F]H@G_L:HaP2IcT4HaP@IcTDHaP2IcT4HaP4G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2
:DX27>L248@236<22486124Z248@36<T2484Ool20001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`YS
609W>@9S611W>AaS60ANm`iS60iNm`MJePAF]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BH8@Q8<
HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45[F45kg2V<H0VLi0V<H46Li76<H15kg3V<H3Ukg
1e[F15Je0U:D14ic14YB0Sg_0Re[0QcW0Q2410Q21P@Q9PQ24PaS9PQ21Goo0@000Goo000EOol00`00
Oomoo`02Ool@F]H@G_L8HaP4IcT2HaP@IcTLHaP4G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`2
7>L248@42482124/248@36<V2485Ool10001Ool001Eoo`03001oogoo009ooa1JeQ1Nm`QS60AW>@9S
611W>AaS60ANma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848B`8@Q0<HbH8@PEo
o`40005oo`005Goo00<007ooOol00Woo3U[F4Ukg1V<H1VLi16<H46Li1V<H0VLi4V<H15kg46<H35kg
1e[F1UJe0U:D1Tic0THa0SF]0R480Q244PQ20P@Q7PQ20PaS0PQ230aS9PQ21Goo0@000Goo000EOol0
0`00Oomoo`02Ool>F]HBG_L6HaP6IcT4HaP@IcT6HaP2IcTBHaP4G_L@HaP<G_L7F]H6E[D2DY@6CW<2
AS42=Jd28@P248@B2482124N248236<2248<36<V2485Ool10001Ool001Eoo`03001oogoo009oo`iJ
ePiNm`YS60IW>@9S61aW>A1S60ANm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8mk`8YBP8@Q108
@P@48Ah8@Ph<HbP8@PEoo`40005oo`005Goo00<007ooOol00Woo3U[F3Ukg2V<H1VLi0V<H76Li46<H
15kg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q2440Q210@Q7PQ23PaS:0Q21Goo0@00
0Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPNIcTHHaP4G_L:HaP>G_L7F]H4E[D4DY@4
CW<2AS42<H`25:DB2482124L248636<648@836<T2485Ool10001Ool001Eoo`8000=oo`iJePiNm`QS
60IW>@9S61iW>AQS60ANm`YS60iNm`MJePAF]@ABU0A>L`96<@8aS08DYA88@P848A`8@PH<H`H@Q0P<
Hb@8@PAoo`80005oo`005Goo00<007ooOol00Woo3U[F3Ukg26<H1VLi0V<H86Li5V<H15kg2V<H3Ukg
2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:PQ220aS0Q2411BU0Q241PaS80Q20PaS0PQ21Goo
0@000Goo000EOol00`00Oomoo`02Ool>F]H>G_L8HaP6IcT2HaPPIcTFHaP4G_L:HaP>G_L9F]H2E[D2
DY@2E[D4CW<2BU82>Lh26<H2248236<Z248836<248@45:D248@636<P248236<22485Ool10001Ool0
01Eoo`03001oogoo009oo`IJeQINm`YS62IW>BAS60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2188
@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q08<H`88@P8<Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo
1U[F5Ukg2V<H9VLi96<H3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484PQ20P@Q7PQ20PaS0Q2411S6
0QBU0Q240PaS0PQ20PaS90Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4
G_L:HaP2G_L4HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@@2482124N248236<248@46<H2
5:D248@636<T2485Ool10001Ool001Eoo`03001oogoo009oo`IJeQINm`IS62YW>AIS60ANm`YS609N
m`AS60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q108@P848Ah8@P8<H`8@Q0@HaP8DY@8@Q0H<
Hb@8@PEoo`40005oo`005Goo00<007ooOol00Woo1U[F5Ukg1V<H:VLi5V<H15kg1V<H15kg26<H1ekg
25[F15Je25:D0THa0Re[0QBU1PQ20PaS9PQ210aS0QBU12480QBU0Q2410aS9PQ21Goo0@000Goo000E
Ool00`00Oomoo`02Ool6F]HFG_L6HaPZIcTFHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8DY@2AS42;F/2
5:D6248236<V248436<25:D48@P25:D248@436<V2485Ool10001Ool001Eoo`03001oogoo009oo`IJ
eQINm`AS62aW>AIS60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8HaPH8@P8<HbH8@P@<H`8H
aP@]J`8Li`8@Q0@<HbH8@PEoo`40005oo`005Goo0P000goo1U[F5Ukg16<H;6Li5V<H15kg1V<H15kg
26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9PQ210aS0QS612e[0QcW0Q2410aS9PQ217oo0P00
0Goo000EOol00`00Oomoo`02Ool6F]H>G_L<HaPBIcT4JeXDIcTHHaP4G_L8HaP6G_L4HaP7G_L8F]H4
E[D8DY@2BU82>Lh28@P6248236<J248436<8248436<28@P4=Jd28@P248@236<X2485Ool10001Ool0
01Eoo`03001oogoo009oo`IJePiNm`aS619W>@A[FQAW>AQS60ANm`QS60INm`AS60MNm`QJePAF]@QB
U09:DP8icP8Q20H8@P8<HaX8@P@<H`P8@P@<H`8Q20@e[@8Q208@Q08<HbP8@PEoo`40005oo`005Goo
00<007ooOol00Woo15[F3Ukg36<H36Li0V]J16Li36]J46Li96<H15kg26<H0ekg2U[F15Je1U:D0Tic
0T8@0RU:0PaS10Q210aS60Q21PaS1PQ210aS0R4813F]0R480Q240PaS2PQ20P@Q70Q21Goo0@000Goo
000EOol00`00Oomoo`02Ool4F]H>G_L<HaP<IcT2JeX4IcT<JeX@IcTTHaP4G_L8HaP3G_L:F]H4E[D6
DY@2CW<2@Q02:DX236<4248436<H248636<6248436<28@P4=Jd28@P248@236<:2482124L2485Ool1
0001Ool001Eoo`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>C9S60=Nm`aJePIBU09>L`96<@8]J`8D
Y@@8@P8<HaX8@P@<H`P8@P@<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A`8@PEoo`40005oo`005Goo00<0
07ooOol00Woo45kg36<H36Li56]J46Li<V<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6PQ210aS
20Q210aS0QcW12e[0QcW0Q241PaS10Q210@Q70Q21Goo0@000Goo000EOol00`00Oomoo`02Ool@G_L<
HaP<IcTDJeX@IcTXHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D4248436<F248236<<248436<2
6<H49BT25:D248@636<42484124L2485Ool10001Ool00003Ool0000000<0009oo`8000Aoo`8000Eo
o`03001oogoo009ooa1Nm`aS60aW>AA[FQ1W>BQS60AW>@IS60=Nm`aJePIBU09>L`9:DP8e[@8DY@@8
@P@<HaH8@P8<H``8@P@<H`8HaP@U:@8DY@8@Q0H<H`@8@P@48A`8@PEoo`40005oo`000goo00D007oo
Oomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L6HaP@IcT@JeX4
IcT2JeX>IcTTHaP4G_L2HaP4JeX4HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H2
36<2248436<F248436<8248436<248@26<H47>L25:D448@236<V2485Ool10001Ool000=oo`05001o
ogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0P000goo4Ukg1V<H46Li46]J16Li0V]J
3VLi96<H15kg0V<H16]J16<H00=Nme[FF]H015kg25[F0UJe0U:D0UJe0U:D0TYB0SW>0QS60PaS0PQ2
10aS5PQ210aS20Q210aS0Q240QS611cW0QBU11240PaS9PQ217oo0P000Goo0003Ool01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9Nm`9JePiNm`IS60iW>AQ[
FPiW>BIS609Nm`9S60A[FP9W>@9S60MNm`QJeP9F]@9BU09F]@9BU09:DP8mk`8Li`8<H`88@P@<HaH8
@P@<H`@8@P8<H`88@P@<H`8@Q08DY@@HaP8DY@8@Q0@<HbH8@PEoo`40005oo`000goo00D007ooOomo
o`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`02Ool2G_L2F]H>G_L6HaP>IcTH
JeX>IcTVHaP2G_L2HaP4JeX2IcT2HaP7G_L8F]H2E[D2DY@2E[D2DY@2BU82?Nl27>L236<2248436<F
248436<4248236<2248436<248@25:D46<H25:D248@436<V2485Ool10001Ool0009oo`8000Aoo`80
00Aoo`8000Eoo`03001oogoo009oo`AJePaNm`QS60aW>AY[FPiW>BIS609Nm`9S609W>@A[FP9S60MN
m`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaH8@P@<H`@8@P8<H`88@P@<H`@@Q0@DY@8@
Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo15[F35kg26<H36Li6V]J3VLi9V<H0Ukg0V<H
0VLi16]J0V<H1ekg25[F0UJe0U:D0UJe0U:D0Tic0T8@0RDY0PaS0PQ210aS5PQ210aS10Q20PaS0PQ2
10aS112411BU0Q241PaS9PQ21Goo0@000Goo000EOol00`00Oomoo`02Ool2F]H>G_L8HaP<IcTLJeX@
IcTVHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2CW<2AS42:DX248@2248436<2248236<J2482
36<4248236<448@45:D248@636<V2485Ool10001Ool001Eoo`03001oogoo009oo`9JePiNm`QS60aW
>Aa[FQ1W>BIS609W>@A[FP=S60INm`QJeP9F]@9BU09F]@9BU09>L`96<@8YBP8@Q088@P@<H`88@P8<
HaX8@P8<H`@8@P8<H`@@Q0@DY@8@Q0H<HbH8@PEoo`40005oo`005Goo00<007ooOol00Woo45kg1V<H
36Li46]J0Vmk36]J46Li76<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS
0PQ20PaS10Q20PaS50Q210aS0PQ210aS212420aS10Q220@Q60Q21Goo0@000Goo000EOol00`00Oomo
o`02Ool@G_L6HaP<IcT@JeX2Kg/<JeX@IcTLHaP2G_L:HaP4IcT3HaP6G_L:F]H4E[D2DY@2CW<2AS42
;F/25:D2248436<2248236<4248236<D248436<2248436<848@836<42488124H2485Ool10001Ool0
01Eoo`03001oogoo009ooa1Nm`AS60iW>@I[FPA_N`A[FPI_N`Y[FQ9W>@QS609W>B=S60INm`AJeP9N
m`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<H`88@P8<H`@8@P8<Ha@8@P@<H`88@P@<H`H@Q0H<H`P8
@PP48@@8@PX48@X8@PEoo`40005oo`005Goo0P000goo45kg16<H3VLi1V]J16mk16]J1Vmk2V]J4VLi
26<H0VLi8f<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0TYB0S6<0QS60PQ210aS0PQ20PaS10Q20PaS50Q2
10aS0PQ210aS1Q241PaS20Q220@Q10Q22P@Q2PQ217oo0P000Goo000EOol00`00Oomoo`02Ool>G_L6
HaP<IcT4JeXBKg/:JeXLIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2CW<2=Jd26<H636<2248236<J2484
36<2248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`iNm`IS60aW>@A[
FQ9_N`Y[FQaW>B=S60INm`AJeP9Nm`AJePAF]@ABU09>L`8e[@8HaPH<H`88@P8<HaX8@P@<H`88@Q0<
H`P8@PP48@@8@P`48@P8@PEoo`40005oo`005Goo00<007ooOol00Woo3Ukg1V<H2VLi1V]J56mk26]J
76Li56<H15kg3F<H15kg15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21PaS4PQ20PaS1PQ210aS0PQ2
40aS20Q220@Q10Q230@Q20Q21Goo0@000Goo000EOol00`00Oomoo`02Ool>G_L6HaP:IcT6JeXDKg/8
JeXLIcTDHaP4G_L=HaP4G_L4F]H2G_L8F]H4DY@2CW<2>Lh26<H236<2248636<B248236<6248436<2
248@36<824881244248<12482485Ool10001Ool001Eoo`03001oogoo009oo`YNm`QS60YW>@I[FPI_
N`IcW0Q_N`Y[FQ1W>C5S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20P<H`88@P8<H``8@PH<H`X8
@Q8<H`H8@Ph48@P8@PP48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo2Ukg26<H2VLi1V]J1Vmk
1W>L26mk2V]J46Li<F<H15kg1U[F0Ukg15[F15Je0U:D0TYB0Sg_0R4820aS0PQ20PaS30Q21PaS2PQ2
4PaS1PQ23P@Q20Q220@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool:G_L6HaP<IcT6JeX4Kg/:
Li`2Kg/2Li`4Kg/:JeX>IcTaHaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P836<2248236<@2482
36<:248D36<4248B1242248:12442485Ool10001Ool001Eoo`03001oogoo009oo`YNm`IS60aW>@I[
FPA_N`YcW09_N`9cW0A_N`Y[FPiW>C5S60INm`AJeP9Nm`AJePAF]@9BU09>L`92408Q20P<H`88@P8<
Ha08@P8<H`X8@Q@<H`@8@Q848@88@PX48@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg26<H
2VLi1V]J16mk4W>L0Vmk0V]J0Vmk1V]J3VLi<F<H2Ukg1U[F1UJe0Tic0T8@0RDY30aS70Q250aS0PQ2
80@Q10Q21Goo0@000Goo000EOol20003Ool8G_L8HaP:IcT6JeX4Kg/BLi`2Kg/2JeX2Kg/6JeX>IcTa
HaP:G_L6F]H6E[D2CW<2@Q029BT<36<L248D36<2248P12442484Ool20001Ool001Eoo`03001oogoo
009oo`QNm`IS60YW>@I[FPA_N`IcW0Ig_@IcW0Q_N`I[FQ1W>BmS60YNm`QJePAF]@9>L`96<@8YBP8@
Q0X<Ha88@P8<H`P8@Q8<H`@8@R048@@8@PEoo`40005oo`005Goo00<007ooOol00Woo25kg1V<H2VLi
1V]J16mk1W>L1WNm1W>L26mk1V]J46Li;f<H2Ukg25[F15Je0Tic0THa0RU:0Q242PaS4PQ20PaS20Q2
4PaS10Q280@Q10Q21Goo0@000Goo000EOol00`00Oomoo`02Ool6G_L8HaP8IcT8JeX4Kg/4Li`8Mkd6
Li`4Kg/2JeX2Kg/4JeXBIcT8HaP2IcT6HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX248@236<22486
36<B248236<8248636<4248636<6248T1245Ool10001Ool001Eoo`03001oogoo009oo`INm`QS60QW
>@Q[FPA_N`AcW0Qg_@IcW0A_N`9[FP9_N`A[FQ9W>@QS609W>@IS609W>AeS60aNm`IJePAF]@9>L`96
<@8YBP8@Q08<H`88@PH<Ha88@P8<H`P8@PH<H`@8@PH<H`H8@R@48@Eoo`40005oo`005Goo00<007oo
Ool00Woo1Ukg1V<H2VLi16]J1Vmk0W>L3WNm17>L16mk0V]J0Vmk16]J56Li16<H16Li86<H0VLi0f<H
35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L6HaP:IcT4JeX6Kg/2Li`>Mkd4Li`4Kg/2JeX2Kg/4JeXDIcT4HaP4IcTP
HaP2IcT3HaP<G_L6F]H4E[D2DY@2AS42:DX248@236<2248636<B248236<8248B36<4248T1245Ool1
0001Ool001Eoo`03001oogoo009oo`INm`AS60YW>@I[FPA_N`AcW09g_@YkgP9g_@IcW09_N`9[FP9_
N`I[FQYW>A1S609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88
@PH<Ha88@P8<H`P8@Q8<H`@8@R@48@Eoo`40005oo`005Goo00<007ooOol00Woo1Ukg16<H2VLi1V]J
16mk17>L0WNm2W_N0WNm1W>L0Vmk0V]J0Vmk1V]J6VLi46<H0VLi3V<H0VLi00=S65kgG_L035kg0U[F
0Ukg0U[F15Je0U:D0THa0RU:0Q240PaS0PQ21PaS4PQ20PaS20Q24PaS10Q290@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool6G_L4HaP:IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`6Kg/6JeXLIcT>HaP2IcTA
HaP>G_L2F]H2G_L2F]H4E[D2DY@2BU82:DX236<22482124636<6248236<:248236<8248B36<4248T
1245Ool10001Ool001Eoo`8000=oo`INm`AS60YW>@A[FPA_N`AcW0Ag_@YkgPAg_@AcW0I_N`I[FQaW
>@iS609W>A5S60iNm`9JeP9Nm`9JePAF]@9BU09:DP8YBP8<H`88@P848@H<H`H8@P8<H`X8@P8<H`P8
@Q8<H`@8@R@48@Aoo`80005oo`005Goo00<007ooOol00Woo36<H1VLi1V]J0Vmk17>L17Nm17_N1Woo
17_N0WNm17>L16mk1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q20Q22PaS30Q21PaS1PQ2
30aS10Q290@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool<HaP6IcT6JeX2Kg/4Li`4Mkd4Nmh6Ool4
Nmh2Mkd4Li`4Kg/6JeXLIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@21248248:36<<248636<6248<
36<4248T1245Ool10001Ool001Eoo`03001oogoo009oo`aS60IW>@A[FPA_N`9cW0Ag_@AkgPQoo`Ak
gP9g_@AcW0A_N`I[FQaW>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@H8@PX<HbH8@RH48@Eo
o`40005oo`005Goo00<007ooOol00Woo36<H1VLi16]J16mk0W>L17Nm17_N27oo17_N0WNm17>L16mk
1V]J76Li8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240PQ20P@Q1PQ22PaS9PQ29P@Q1Goo0@000Goo000E
Ool00`00Oomoo`02Ool<HaP4IcT6JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`6Kg/4JeXPIcT:HaP2
IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224841248248636<V248V1245Ool10001Ool001Eoo`03
001oogoo009oo`aS60AW>@I[FP9_N`AcW09g_@AkgPYoo`AkgP9g_@AcW0I_N`A[FR1W>@YS609W>A=S
60iNm`IJePAF]@9BU096<@8]J`8DY@88@P@48@P8@PH<HbH8@RH48@Eoo`40005oo`005Goo00<007oo
Ool00Woo26<H26Li16]J16mk0W>L0WNm17_N3Woo0W_N0WNm17>L1Vmk16]J8VLi7f<H35kg1U[F15Je
0U:D0THa0Re[0QBU0PQ210@Q0PQ20P@Q1PQ210aS80Q20PaS10Q29P@Q1Goo0@000Goo00000goo0000
000300000goo000000020003Ool20005Ool00`00Oomoo`02Ool8HaP8IcT4JeX4Kg/2Li`2Mkd4Nmh>
Ool2Nmh2Mkd4Li`6Kg/4JeXRIcTOHaP<G_L6F]H4E[D2DY@2AS42;F/25:D224841242248212462484
36<P248236<4248V1245Ool10001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<0
07ooOol00Woo1V<H26Li1V]J0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F
15Je0U:D0THa0Re[0QBU0PaS0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q1Goo0@00
0Goo0003Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P000goo1V<H26Li1V]J
0Vmk17>L0WNm0W_N47oo0W_N17Nm0W>L1Vmk16]J86Li8F<H2Ukg25[F15Je0U:D0THa0Re[0QBU0PaS
0PQ20P@Q0PQ20P@Q0PQ20P@Q7PQ20PaS1PQ20PaS10Q29P@Q17oo0P000Goo0003Ool00`00Oomoo`03
Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li1V]J16mk0W>L0WNm
0W_N4Woo17_N0WNm0W>L1Vmk1V]J6VLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS60PaS0PQ20P@Q0PQ2
0P@Q0PQ210@Q:0Q2:0@Q1Goo0@000Goo0003Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo009oo`03001oogoo009oo`AS60QW>@I[FPA_N`9cW09g_@9kgQ9oo`AkgP9g_@9cW0I_N`I[
FQYW>BMS60QNm`QJePAF]@9BU09:DP8aS08HaP8<H`88@P848@88@P848@88@P@48BP8@RP48@Eoo`40
005oo`000Woo0P0017oo0P0017oo0P001Goo00<007ooOol00Woo16<H1VLi1V]J16mk0W>L17Nm0W_N
57oo0W_N0WNm0W>L1Vmk1V]J76Li2V<H16Li3V<H0Ukg0f<H0Ukg16<H1Ukg25[F15Je0U:D0TYB0SF]
0R480Q240PQ20P@Q0PQ20P@Q0PQ210@Q0PQ20P@Q40Q210aS40Q2:0@Q1Goo0@000Goo000EOol00`00
Oomoo`02Ool4HaP6IcT6JeX4Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`6Kg/6JeXLIcT:HaP4IcT>HaP2
G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@22482124224821242248412422482124@
248436<@248X1245Ool10001Ool001Eoo`03001oogoo009oo`9S60IW>@I[FPA_N`AcW09g_@AkgQAo
o`9kgP9g_@9cW0I_N`I[FRYW>@iS60MNm`AS60INm`QJePAF]@9BU09:DP8mk`8U:@8DY@88@P848@H8
@P@48@88@PP48@X8@PP<H``8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo0V<H1VLi1V]J16mk
17>L0WNm17_N57oo0W_N0WNm0W>L1Vmk1V]J:VLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY
0QBU0PQ20P@Q1PQ210@Q0PQ220@Q2PQ220aS30Q2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool8
IcT8JeX2Kg/2Li`4Mkd4NmhBOol4Nmh2Mkd2Li`2Kg/2JeX2Kg/8JeXRIcTHHaP=G_L8F]H4E[D2CW<2
AS42@Q02<H`27>L236<624841242248:1246248436<6248236<4248236<6248X1245Ool10001Ool0
01Eoo`03001oogoo009oo`QW>@Q[FP9_N`9cW0Ag_@AkgQ9oo`AkgP9g_@9cW09_N`9[FP9_N`Q[FR9W
>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`H8@P@48@88@PX48@H8@P@<H`H8@P8<H`@8@P8<
H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li1V]J16mk0W>L0WNm17_N57oo0W_N17Nm
0W>L0Vmk0V]J16mk26]J86Li66<H3Ekg25[F0UJe0U:D0Tic14Ha0SW>0RDY0QBU1PQ240@Q5PQ20PaS
1PQ2:0@Q1Goo0@000Goo000EOol20003Ool8IcT6JeX4Kg/2Li`2Mkd4NmhDOol2Nmh4Mkd2Li`2Kg/2
JeX4Kg/8JeXPIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D6248@124F248236<6248X1244
Ool20001Ool001Eoo`03001oogoo009oo`QW>@A[FPI_N`9cW09g_@AkgQAoo`9kgPAg_@9cW09_N`9[
FPA_N`i[FP9W>@A[FQAW>AQS60eNm`9JeP9Nm`AJeP9F]@9BU09>L`A6<@8mk`8aS08Li`8<H`@8@Q@4
8A88@P8<H`H8@RP48@Eoo`40005oo`005Goo00<007ooOol00Woo26Li16]J1Vmk0W>L0WNm17_N57oo
0W_N17Nm0W>L0Vmk0V]J16mk3V]J0VLi16]J56Li66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha0Sg_
0S6<0QcW0PaS10Q250@Q4PQ20PaS1PQ2:0@Q1Goo0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4
Kg/4Li`2Mkd4NmhDOol2Nmh4Mkd2Li`8Kg/FJeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2
BU82AS44@Q02>Lh29BT248@4248F124<248636<4248Z1245Ool10001Ool001Eoo`03001oogoo009o
o`IW>@I[FPA_N`AcW09g_@AkgQAoo`9kgPAg_@9cW0Q_NaI[FQ9W>@QS60AW>@eS60aNm`9JePANm`9J
eP9F]@9BU09:DP96<@A2408icP8U:@8@Q0@8@QH48@`8@PH<H`@8@RX48@Eoo`40005oo`005Goo00<0
07ooOol00Woo1VLi1V]J16mk17>L0WNm0W_N57oo17_N17Nm0W>L1Vmk26]J26Li26]J4VLi26<H16Li
3F<H35kg0U[F15kg0U[F0UJe0U:D0TYB0THa0Sg_0THa0T8@0S6<0QS60PaS10Q26P@Q40Q2:P@Q1Goo
0@000Goo000EOol00`00Oomoo`02Ool6IcT6JeX4Kg/4Li`2Mkd2NmhDOol4Nmh4Mkd2Li`6Kg/8JeX8
IcT8JeXBIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`26<H236<4
248J124@248Z1245Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`005Goo00<007ooOol0
ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomoo`0BOol10001Ool0
01Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQOol00?moob5oo`00
ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell["\<\
sample={
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.517647, 0.54902, 0.45098},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.388235, \
0.258824},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.419608, 0.352941, 0.192157, \
0.0941176},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.419608, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, \
0.482353, 
0.54902, 0.54902, 0.482353, 0.388235, 0.223529, 0.129412, 0, 0},
{0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.54902, 
0.517647, 0.419608, 0.290196, 0.160784, 0.0627451, 0.0313725, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.482353, 0.482353, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.45098, 
0.352941, 0.223529, 0.0941176, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, \

0.129412, 0.0313725, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.54902, 0.54902, 0.482353, 0.388235, 0.258824, 0.129412, \

0.0313725, 0, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.45098, 0.321569, 0.192157, 0.0941176, 0.0313725, \

0, 0, 0, 0, 0, 0, 0, 0},
{0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.482353, 0.419608, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.388235, 0.45098, 0.517647, 0.517647, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.45098, 
0.352941, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.45098, \

0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 0.388235, 0.290196, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \

0.517647, 0.54902, 0.580392, 0.54902, 0.45098, 0.352941, 0.192157, 0.129412, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.517647, 
0.54902, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.580392, 0.580392, 0.45098, 0.321569, 0.192157, 0.0941176, 0, 0, 0, \
0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.482353, 0.290196, 0.160784, 0.0627451, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.54902, \

0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.45098, 0.290196, 0.129412, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.45098, 
0.290196, 0.160784, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725},
{0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.517647, 0.482353, 0.54902, 
0.54902, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 
0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.482353, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, 0.160784, 
0.0627451, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0.0313725, 
0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.482353, 0.45098, 0.388235, 0.352941, 0.419608, 0.517647, 0.580392, \
0.611765, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, 0.0627451, \

0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.482353, 0.419608, 0.388235, 0.482353, 0.580392, 0.647059, \
0.647059, 
0.611765, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.54902, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.54902, \

0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.517647, 0.580392, 0.678431, 0.709804, \
0.807843, 
0.741176, 0.611765, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.482353, 0.321569, 0.192157, 0.0941176, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.611765, 0.709804, 0.776471, \
0.870588, 
0.807843, 0.678431, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.419608, 0.388235, 0.352941, 0.352941, 0.321569, \

0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.482353, 0.647059, 0.776471, 0.807843, \
0.807843, 
0.709804, 0.611765, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, \

0.54902, 0.45098, 0.419608, 0.45098, 0.517647, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.517647, 0.419608, 0.258824, 0.129412, 0.0313725, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, \
0.482353, 
0.419608, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.258824, 0.45098, 0.709804, 0.870588, 0.905882, \
0.807843, 
0.678431, 0.647059, 0.647059, 0.647059, 0.709804, 0.807843, 0.776471, \
0.678431, 
0.517647, 0.388235, 0.388235, 0.517647, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.45098, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.321569, 0.45098, 0.611765, 0.807843, 0.905882, 0.839216, \
0.678431, 
0.580392, 0.647059, 0.709804, 0.741176, 0.776471, 0.807843, 0.741176, \
0.647059, 
0.517647, 0.482353, 0.517647, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 
0.290196, 0.160784, 0.0627451, 0, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.388235, 0.388235, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.517647, 0.678431, 0.807843, 0.870588, 0.870588, 0.709804, \
0.54902, 
0.482353, 0.580392, 0.709804, 0.741176, 0.709804, 0.678431, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 0.352941, \

0.192157, 0.0941176, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.54902, 0.678431, 0.776471, 0.870588, 0.839216, 0.807843, 0.611765, \
0.482353, 
0.419608, 0.45098, 0.54902, 0.580392, 0.580392, 0.611765, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.482353, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.611765, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.647059, \
0.54902, 
0.45098, 0.419608, 0.419608, 0.419608, 0.517647, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.517647, 0.388235, 0.258824, \
0.160784, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.54902, 0.482353, 0.45098, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.647059, \

0.647059, 0.647059, 0.611765, 0.647059, 0.678431, 0.741176, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.45098, 0.419608, 0.482353, 0.54902, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, \
0.0627451, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.580392, \
0.611765, 
0.647059, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.482353, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, \

0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.709804, 0.678431, 0.678431, 0.647059, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.54902, \
0.580392, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.54902, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, \

0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.482353, 0.54902, \

0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.482353, 0.290196, 0.129412, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, \

0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.54902, \
0.517647, 
0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.352941, 0.192157, 0.0627451, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.580392, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.54902, 0.388235, 0.258824, 0.129412, 0.0313725, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.580392, \

0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.517647, 0.517647, 0.580392, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.580392, 
0.45098, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.517647, 0.54902, 0.647059, 0.678431, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.517647, 
0.352941, 0.192157, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, \
0.45098, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.611765, 0.54902, 0.517647, 0.580392, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.54902, \
0.419608, 
0.258824, 0.129412, 0.0627451, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.709804, 
0.678431, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.482353, \
0.321569, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.580392, 0.54902, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.517647, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.678431, 0.678431, 0.611765, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.580392, 0.611765, 0.647059, 0.647059, 0.54902, 0.45098, 0.258824, 0.160784, \

0.0627451, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.580392, 0.580392, 0.580392, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.678431, 0.647059, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.580392, 0.388235, 0.258824, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.647059, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.482353, 0.321569, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.419608, 0.258824, 0.160784, 0.129412, \
0.0941176, 
0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, \

0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.517647, 0.352941, 0.192157, 0.129412, 0.0941176, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.647059, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.45098, 0.290196, 0.160784, 0.0941176, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.678431, 0.647059, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.517647, 0.352941, 0.223529, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.647059, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.580392, 0.419608, 0.258824, 0.160784, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, 0.611765, \
0.580392, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.54902, 0.352941, 0.192157, 0.129412, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.482353, 0.321569, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.54902, 
0.419608, 0.258824, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.647059, \
0.517647, 
0.321569, 0.192157, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.611765, \
0.45098, 
0.258824, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.54902, \
0.388235, 
0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.45098, \
0.290196, 
0.160784, 0.160784, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.419608, \
0.258824, 
0.129412, 0.160784, 0.192157, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.611765, 0.580392, 0.54902, 0.54902, 0.517647, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.482353, 0.321569, \
0.192157, 
0.129412, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.45098, 0.290196, \
0.160784, 
0.0941176, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.223529, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.388235, 0.223529, \
0.129412, 
0.0941176, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.258824, 0.223529, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, \

0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0941176, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.129412, 
0.192157, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.45098, 0.290196, 0.160784, \
0.0941176, 
0.129412, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.419608, 0.258824, 0.129412, \
0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.517647, 0.388235, 0.223529, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.580392, 0.54902, 0.482353, 0.352941, 0.192157, 0.129412, 0.129412, \

0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.611765, \
0.54902, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.580392, 0.54902, 0.419608, 0.290196, 0.192157, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.54902, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, \
0.580392, 
0.54902, 0.517647, 0.517647, 0.482353, 0.517647, 0.54902, 0.517647, 0.517647, \

0.517647, 0.54902, 0.517647, 0.388235, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.482353, 0.352941, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.45098, 0.321569, 0.223529, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.388235, 0.258824, 0.160784, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.352941, 0.223529, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.580392, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.45098, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.482353, \

0.482353, 0.45098, 0.290196, 0.160784, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.611765, 0.611765, 0.54902, 0.517647, 0.45098, 0.45098, 
0.482353, 0.419608, 0.290196, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.45098, 0.45098, \

0.45098, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, \

0.419608, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.45098, 
0.419608, 0.352941, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.223529, 0.160784, 0.0941176, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.517647, 
0.419608, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.54902, 
0.45098, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.482353, 0.352941, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, \
0.580392, 
0.517647, 0.388235, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.54902, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.321569, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.54902, 0.388235, 0.160784, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.678431, \
0.611765, 
0.611765, 0.580392, 0.45098, 0.192157, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.611765, \
0.678431, 
0.647059, 0.580392, 0.482353, 0.258824, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.678431, 
0.647059, 0.611765, 0.517647, 0.290196, 0.129412, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.160784, 0.258824, 0.258824, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.419608, 0.192157, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.192157, 0.352941, 0.352941, 0.223529, 0.129412, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.45098, 0.258824, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.517647, 0.321569, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.223529, 0.352941, 0.352941, 0.223529, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.580392, 0.419608, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.192157, 0.290196, 0.290196, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.839216, 0.839216, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.45098, 0.192157, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.192157, 0.223529, 0.223529, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.839216, 0.839216, 0.807843, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.482353, 0.223529, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.160784, 0.192157, 0.192157, 0.160784, 0.129412, 0.0941176, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.517647, 0.290196, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.54902, 0.321569, 0.129412, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.580392, 0.388235, 0.192157, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.419608, 0.192157, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.647059, 0.611765, 0.45098, 0.192157, \
0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.482353, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.870588, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.517647, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.611765, 0.517647, 0.290196, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, \
0.870588, 
0.905882, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, \
0.937255, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, \
0.905882, 
0.905882, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, \
0.905882, 
0.937255, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.321569, \
0.0941176, 
0.0627451, 0.0313725, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, \
0.937255, 
0.937255, 0.968627, 0.968627, 1, 1, 1, 0.968627, 0.968627, 0.937255, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0313725, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, \
0.937255, 
0.968627, 0.968627, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0627451, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, \
0.968627, 
0.968627, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.905882, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.580392, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.482353, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.839216, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.611765, 
0.54902, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.482353, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.517647, 0.45098, 0.290196, 0.129412, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
0.968627, 
0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, 0.54902, \
0.482353, 
0.54902, 0.517647, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725}};\
\>", "Graphics",
  Evaluatable->True,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[FilledSquare]\ 128\[Times]128\ simple\)], "Input"],

Cell["\<\
sample={
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.419608, 0.419608, \

0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.54902, 0.517647, 0.54902, 0.45098},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.388235, \
0.258824},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.388235, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.419608, 0.352941, 0.192157, \
0.0941176},
{0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.45098, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.419608, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.419608, 0.482353, 0.482353, \

0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.45098, \
0.482353, 
0.54902, 0.54902, 0.482353, 0.388235, 0.223529, 0.129412, 0, 0},
{0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 
0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.388235, 0.419608, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.45098, 0.482353, 0.45098, 0.388235, 0.388235, 0.45098, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.54902, 
0.517647, 0.419608, 0.290196, 0.160784, 0.0627451, 0.0313725, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.482353, 0.482353, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.45098, 
0.352941, 0.223529, 0.0941176, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 
0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.388235, 0.419608, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, \

0.129412, 0.0313725, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.388235, 0.419608, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 
0.482353, 0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.54902, 0.54902, 0.482353, 0.388235, 0.258824, 0.129412, \

0.0313725, 0, 0, 0, 0, 0, 0, 0},
{0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.419608, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.45098, 0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.45098, 0.321569, 0.192157, 0.0941176, 0.0313725, \

0, 0, 0, 0, 0, 0, 0, 0},
{0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.482353, 0.419608, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 
0.45098, 0.419608, 0.419608, 0.419608, 0.45098, 0.482353, 0.45098, 0.45098, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.388235, 0.45098, 0.517647, 0.517647, 0.45098, 0.45098, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 
0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.45098, 
0.419608, 0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, \

0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.45098, 
0.352941, 0.223529, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.482353, 0.45098, \

0.419608, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.419608, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.482353, 0.388235, 0.290196, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0},
{0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \

0.517647, 0.54902, 0.580392, 0.54902, 0.45098, 0.352941, 0.192157, 0.129412, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.45098, 
0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, \
0.517647, 
0.54902, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.45098, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, 0.482353, \

0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.54902, 
0.580392, 0.580392, 0.45098, 0.321569, 0.192157, 0.0941176, 0, 0, 0, \
0.0313725, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.517647, \

0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.45098, 0.45098, \

0.45098, 0.482353, 0.482353, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.482353, 0.290196, 0.160784, 0.0627451, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.482353, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.54902, \

0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.54902, 
0.45098, 0.290196, 0.129412, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 
0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.482353, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.45098, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, \

0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.45098, 
0.290196, 0.160784, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725},
{0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.580392, 0.54902, 0.517647, 0.482353, 0.54902, 
0.54902, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.517647, 0.517647, 0.54902, 0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 
0.129412, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, \
0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 
0.517647, 0.482353, 0.45098, 0.45098, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 0.517647, 0.517647, \

0.54902, 0.54902, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 0.419608, 0.290196, 0.160784, 
0.0627451, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0.0313725, 
0, 0},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.482353, 0.45098, 0.388235, 0.352941, 0.419608, 0.517647, 0.580392, \
0.611765, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 0.54902, 0.517647, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, 0.0627451, \

0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.54902, 
0.54902, 0.482353, 0.419608, 0.388235, 0.482353, 0.580392, 0.647059, \
0.647059, 
0.611765, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.580392, 0.54902, 0.45098, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.54902, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, 0.54902, \

0.54902, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.517647, 0.580392, 0.678431, 0.709804, \
0.807843, 
0.741176, 0.611765, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.517647, 0.54902, 0.54902, 0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.54902, 0.482353, 0.321569, 0.192157, 0.0941176, 0.0313725, 0, 
0, 0.0313725, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.419608, \
0.419608, 
0.419608, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.611765, 0.709804, 0.776471, \
0.870588, 
0.807843, 0.678431, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.482353, 0.482353, 0.517647, 0.54902, 0.580392, 0.54902, 
0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 
0.580392, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.54902, 0.517647, 0.45098, 0.419608, 0.388235, 0.352941, 0.352941, 0.321569, \

0.321569, 0.321569, 0.290196, 0.290196, 0.290196, 0.290196, 0.290196, \
0.290196, 
0.321569, 0.321569, 0.352941, 0.482353, 0.647059, 0.776471, 0.807843, \
0.807843, 
0.709804, 0.611765, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, \

0.54902, 0.45098, 0.419608, 0.45098, 0.517647, 0.54902, 0.580392, 0.580392, 
0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.517647, 0.419608, 0.258824, 0.129412, 0.0313725, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, \
0.482353, 
0.419608, 0.388235, 0.352941, 0.321569, 0.321569, 0.321569, 0.321569, \
0.321569, 
0.321569, 0.321569, 0.290196, 0.290196, 0.258824, 0.223529, 0.192157, \
0.192157, 
0.192157, 0.192157, 0.258824, 0.45098, 0.709804, 0.870588, 0.905882, \
0.807843, 
0.678431, 0.647059, 0.647059, 0.647059, 0.709804, 0.807843, 0.776471, \
0.678431, 
0.517647, 0.388235, 0.388235, 0.517647, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 
0.45098, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.352941, 0.352941, 0.321569, 0.321569, \
0.352941, 
0.352941, 0.352941, 0.321569, 0.321569, 0.290196, 0.290196, 0.258824, \
0.258824, 
0.258824, 0.321569, 0.45098, 0.611765, 0.807843, 0.905882, 0.839216, \
0.678431, 
0.580392, 0.647059, 0.709804, 0.741176, 0.776471, 0.807843, 0.741176, \
0.647059, 
0.517647, 0.482353, 0.517647, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, \

0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 
0.580392, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 
0.290196, 0.160784, 0.0627451, 0, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.54902, 0.482353, 0.419608, 0.388235, 0.388235, 0.352941, 0.388235, \
0.352941, 
0.352941, 0.352941, 0.352941, 0.388235, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.517647, 0.678431, 0.807843, 0.870588, 0.870588, 0.709804, \
0.54902, 
0.482353, 0.580392, 0.709804, 0.741176, 0.709804, 0.678431, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.45098, 0.352941, \

0.192157, 0.0941176, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0, 
0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.321569, 0.321569, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.45098, 0.45098, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, 
0.54902, 0.678431, 0.776471, 0.870588, 0.839216, 0.807843, 0.611765, \
0.482353, 
0.419608, 0.45098, 0.54902, 0.580392, 0.580392, 0.611765, 0.580392, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.482353, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.388235, \
0.388235, 
0.352941, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.419608, 0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 
0.611765, 0.647059, 0.678431, 0.709804, 0.741176, 0.776471, 0.647059, \
0.54902, 
0.45098, 0.419608, 0.419608, 0.419608, 0.517647, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.54902, 0.580392, 0.580392, 0.517647, 0.388235, 0.258824, \
0.160784, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 0, 0, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.54902, 0.482353, 0.45098, 0.388235, 0.352941, 0.352941, \
0.352941, 
0.352941, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.419608, 0.419608, 0.45098, 0.482353, 0.482353, 0.482353, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.647059, \

0.647059, 0.647059, 0.611765, 0.647059, 0.678431, 0.741176, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.45098, 0.419608, 0.482353, 0.54902, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.54902, 0.419608, 0.290196, 0.129412, \
0.0627451, 
0.0313725, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.419608, 0.388235, 0.352941, 0.352941, 0.352941, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, \
0.419608, 
0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.647059, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.45098, 0.580392, \
0.611765, 
0.647059, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.54902, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.482353, 0.321569, 0.192157, 0.0627451, \
0.0313725, 
0, 0, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, 0.419608, 0.45098, \

0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \

0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.709804, 0.678431, 0.678431, 0.647059, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.482353, 0.54902, \
0.580392, 
0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.54902, 0.388235, 0.223529, 0.0941176, 0.0313725, 0, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0, 
0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, \

0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.580392, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.482353, 0.54902, \

0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.580392, 0.580392, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.482353, 0.290196, 0.129412, 0.0313725, 0.0313725, 
0, 0, 0.0313725, 0.0313725, 0, 0, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.352941, 0.352941, 0.352941, 0.388235, 0.388235, 0.388235, 0.388235, \
0.388235, 
0.388235, 0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, \

0.517647, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.678431, 0.678431, 0.647059, 0.647059, 0.54902, \
0.517647, 
0.54902, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.352941, 0.192157, 0.0627451, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.388235, 0.419608, \
0.419608, 
0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.580392, 0.611765, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.611765, 
0.54902, 0.388235, 0.258824, 0.129412, 0.0313725, 0, 0, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, \
0.419608, 
0.45098, 0.482353, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.580392, \

0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.517647, 0.517647, 0.580392, 0.678431, 0.678431, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.580392, 
0.45098, 0.290196, 0.129412, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.419608, \
0.45098, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.517647, 0.54902, 0.647059, 0.678431, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, \
0.517647, 
0.352941, 0.192157, 0.0941176, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.388235, 0.388235, 0.419608, 0.419608, 0.45098, \
0.45098, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.611765, 0.54902, 0.517647, 0.580392, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.54902, \
0.419608, 
0.258824, 0.129412, 0.0627451, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.388235, 0.388235, 0.419608, 0.419608, 0.419608, 0.45098, 0.45098, \
0.482353, 
0.482353, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.709804, 
0.678431, 0.580392, 0.54902, 0.54902, 0.611765, 0.647059, 0.647059, 0.647059, \

0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.482353, \
0.321569, 
0.160784, 0.0627451, 0.0313725, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.388235, 0.419608, 0.45098, 0.45098, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.580392, 0.54902, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.580392, 0.517647, 0.352941, \
0.223529, 
0.0941176, 0.0313725, 0, 0, 0, 0.0313725, 0, 0, 0.0313725, 0.0313725, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.419608, 0.45098, 0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, \

0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \

0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.678431, 0.678431, 0.611765, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.580392, 0.611765, 0.647059, 0.647059, 0.54902, 0.45098, 0.258824, 0.160784, \

0.0627451, 0.0313725, 0.0313725, 0.0313725, 0, 0.0313725, 0, 0, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.45098, 0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.580392, 0.580392, 0.580392, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.647059, 0.647059, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.647059, 0.678431, 0.647059, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \

0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.45098, 0.482353, 0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.580392, 0.388235, 0.258824, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.647059, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.611765, 0.482353, 0.321569, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.611765, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, 0.647059, \
0.611765, 
0.647059, 0.647059, 0.580392, 0.419608, 0.258824, 0.160784, 0.129412, \
0.0941176, 
0.0313725, 0, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, \

0.580392, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.580392, 0.580392, \
0.611765, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.647059, 0.611765, 0.517647, 0.352941, 0.192157, 0.129412, 0.0941176, \
0.0941176, 
0.0313725, 0.0313725, 0, 0, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.517647, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.647059, 0.611765, 0.580392, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.611765, \
0.647059, 
0.647059, 0.611765, 0.45098, 0.290196, 0.160784, 0.0941176, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 0.611765, 0.611765, \

0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.678431, 0.647059, 0.580392, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.647059, 0.517647, 0.352941, 0.223529, 0.129412, 0.0941176, 0.0941176, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.647059, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.580392, 0.419608, 0.258824, 0.160784, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.54902, 0.580392, 0.580392, 0.580392, 0.580392, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.678431, 0.678431, 0.611765, \
0.580392, 
0.54902, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.647059, 
0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.647059, 0.611765, 0.580392, 0.611765, \
0.611765, 
0.54902, 0.352941, 0.192157, 0.129412, 0.129412, 0.129412, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.482353, 0.321569, 0.160784, 0.129412, 0.0941176, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.611765, 
0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, \
0.54902, 
0.419608, 0.258824, 0.129412, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.580392, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \

0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.647059, \
0.517647, 
0.321569, 0.192157, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.611765, 0.611765, 0.611765, 
0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.611765, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.611765, \
0.45098, 
0.258824, 0.192157, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.580392, 0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.580392, 0.611765, 0.611765, \
0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, \
0.580392, 
0.580392, 0.611765, 0.611765, 0.580392, 0.611765, 0.647059, 0.54902, \
0.388235, 
0.192157, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.611765, 
0.611765, 0.580392, 0.580392, 0.611765, 0.611765, 0.580392, 0.611765, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.611765, 0.45098, \
0.290196, 
0.160784, 0.160784, 0.160784, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.611765, 0.611765, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.678431, 
0.647059, 0.611765, 0.54902, 0.54902, 0.54902, 0.580392, 0.580392, 0.580392, 
0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.611765, 0.611765, 0.611765, 0.580392, 0.419608, \
0.258824, 
0.129412, 0.160784, 0.192157, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.611765, 0.580392, 0.54902, 0.54902, 0.517647, 0.580392, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.611765, 0.482353, 0.321569, \
0.192157, 
0.129412, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.611765, 0.647059, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.580392, 0.45098, 0.290196, \
0.160784, 
0.0941176, 0.160784, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.223529, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.611765, 0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.517647, 0.54902, 0.580392, \

0.580392, 0.580392, 0.580392, 0.580392, 0.580392, 0.54902, 0.580392, \
0.580392, 
0.580392, 0.580392, 0.580392, 0.611765, 0.54902, 0.388235, 0.223529, \
0.129412, 
0.0941176, 0.129412, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0941176, 
0.258824, 0.223529, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.678431, 
0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.611765, 0.580392, 0.54902, 0.517647, 0.54902, \

0.580392, 0.580392, 0.580392, 0.54902, 0.54902, 0.54902, 0.580392, 0.54902, 
0.580392, 0.580392, 0.580392, 0.580392, 0.482353, 0.352941, 0.192157, \
0.129412, 
0.0941176, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0941176, 0.129412, 
0.192157, 0.192157, 0.160784, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.580392, 0.54902, 0.517647, \
0.517647, 
0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.580392, 0.45098, 0.290196, 0.160784, \
0.0941176, 
0.129412, 0.160784, 0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.580392, 0.54902, 0.419608, 0.258824, 0.129412, \
0.0941176, 
0.0941176, 0.129412, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.54902, 0.54902, 
0.54902, 0.580392, 0.54902, 0.517647, 0.388235, 0.223529, 0.129412, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.647059, 0.647059, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.709804, \
0.741176, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.54902, \
0.517647, 
0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.54902, 0.517647, 
0.54902, 0.580392, 0.54902, 0.482353, 0.352941, 0.192157, 0.129412, 0.129412, \

0.129412, 0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, 0.611765, \
0.54902, 
0.482353, 0.482353, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.580392, 0.54902, 0.419608, 0.290196, 0.192157, 0.129412, \
0.129412, 
0.129412, 0.0941176, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.611765, \
0.580392, 
0.517647, 0.517647, 0.517647, 0.517647, 0.517647, 0.54902, 0.54902, 0.517647, \

0.517647, 0.54902, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.647059, \
0.580392, 
0.54902, 0.517647, 0.517647, 0.482353, 0.517647, 0.54902, 0.517647, 0.517647, \

0.517647, 0.54902, 0.517647, 0.388235, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.517647, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.54902, 0.482353, 0.352941, 0.258824, 0.192157, 0.160784, \
0.129412, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.45098, 0.321569, 0.223529, 0.192157, 0.129412, \
0.0941176, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.611765, 
0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.517647, 0.517647, \
0.517647, 
0.517647, 0.517647, 0.419608, 0.290196, 0.192157, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.678431, 0.678431, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, \
0.647059, 
0.611765, 0.580392, 0.54902, 0.517647, 0.482353, 0.482353, 0.482353, \
0.517647, 
0.517647, 0.482353, 0.388235, 0.258824, 0.160784, 0.160784, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.611765, 0.580392, 0.517647, 0.482353, 0.482353, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.352941, 0.223529, 0.160784, 0.129412, 0.0941176, \
0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.580392, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.482353, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.678431, 
0.647059, 0.611765, 0.611765, 0.580392, 0.517647, 0.45098, 0.482353, \
0.482353, 
0.517647, 0.45098, 0.321569, 0.192157, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, 0.482353, \

0.482353, 0.45098, 0.290196, 0.160784, 0.129412, 0.0941176, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.678431, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.611765, 0.611765, 0.54902, 0.517647, 0.45098, 0.45098, 
0.482353, 0.419608, 0.290196, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, 0.45098, 0.45098, \

0.45098, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0941176, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.678431, \
0.678431, 
0.678431, 0.647059, 0.647059, 0.611765, 0.580392, 0.54902, 0.482353, 0.45098, \

0.419608, 0.388235, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.580392, 0.517647, \
0.45098, 
0.419608, 0.352941, 0.258824, 0.160784, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.647059, 0.647059, 0.647059, 0.611765, 0.611765, 0.54902, \
0.482353, 
0.419608, 0.352941, 0.223529, 0.160784, 0.0941176, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.517647, 
0.419608, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.54902, 
0.45098, 0.321569, 0.223529, 0.129412, 0.0941176, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, 0.580392, \
0.580392, 
0.482353, 0.352941, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.611765, \
0.580392, 
0.517647, 0.388235, 0.223529, 0.129412, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.647059, 0.611765, 0.611765, \
0.611765, 
0.54902, 0.419608, 0.258824, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, 0.611765, \
0.611765, 
0.580392, 0.482353, 0.321569, 0.129412, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.647059, \
0.611765, 
0.611765, 0.54902, 0.388235, 0.160784, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.678431, \
0.611765, 
0.611765, 0.580392, 0.45098, 0.192157, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.129412, 0.160784, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.678431, 0.611765, \
0.678431, 
0.647059, 0.580392, 0.482353, 0.258824, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.678431, 
0.647059, 0.611765, 0.517647, 0.290196, 0.129412, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.129412, 0.192157, 0.192157, 0.160784, 0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.160784, 0.258824, 0.258824, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.419608, 0.192157, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.192157, 0.352941, 0.352941, 0.223529, 0.129412, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.647059, 
0.647059, 0.647059, 0.580392, 0.45098, 0.258824, 0.0627451, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.517647, 0.321569, 0.0941176, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.258824, 0.419608, 0.419608, 0.258824, 0.129412, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.223529, 0.352941, 0.352941, 0.223529, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, 0.709804, \
0.647059, 
0.647059, 0.647059, 0.611765, 0.580392, 0.419608, 0.160784, 0.0627451, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.192157, 0.290196, 0.290196, 0.160784, 0.129412, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.839216, 0.839216, 0.776471, 0.776471, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.45098, 0.192157, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.192157, 0.223529, 0.223529, 0.160784, 0.129412, 0.129412, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.839216, 0.839216, 0.807843, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.580392, 0.482353, 0.223529, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.160784, 0.192157, 0.192157, 0.160784, 0.129412, 0.0941176, \
0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.517647, 0.290196, 0.0941176, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0941176, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.709804, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.807843, 0.839216, 0.839216, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.647059, 0.678431, 0.647059, 0.611765, 0.54902, 0.321569, 0.129412, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.129412, 0.129412, 0.160784, 0.160784, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.54902, 0.352941, 0.160784, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.611765, 0.580392, 0.388235, 0.192157, \
0.0627451, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.129412, 0.129412, 0.129412, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.647059, 0.611765, 0.419608, 0.192157, \
0.0941176, 
0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.870588, 0.870588, 0.870588, 0.870588, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.647059, 0.647059, 0.611765, 0.45098, 0.192157, \
0.0941176, 
0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, \
0.870588, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.482353, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.870588, 0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.741176, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.647059, 0.611765, 0.517647, 0.258824, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.905882, 0.905882, 0.905882, 0.905882, \
0.905882, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.678431, 0.678431, 0.678431, 0.611765, 0.517647, 0.290196, \
0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.776471, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.937255, 0.937255, 0.937255, \
0.905882, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.611765, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, \
0.870588, 
0.905882, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, 0.937255, \
0.937255, 
0.905882, 0.905882, 0.870588, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.776471, 0.776471, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.709804, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.870588, \
0.905882, 
0.905882, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.905882, 0.905882, 0.905882, 0.870588, 0.839216, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.54902, 0.321569, \
0.129412, 
0.0941176, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, \
0.905882, 
0.937255, 0.937255, 0.968627, 0.968627, 0.968627, 0.968627, 0.968627, \
0.937255, 
0.937255, 0.905882, 0.905882, 0.870588, 0.870588, 0.870588, 0.839216, \
0.839216, 
0.839216, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.709804, 0.678431, 0.678431, 0.647059, 0.580392, 0.321569, \
0.0941176, 
0.0627451, 0.0313725, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, \
0.937255, 
0.937255, 0.968627, 0.968627, 1, 1, 1, 0.968627, 0.968627, 0.937255, \
0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0313725, \
0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.807843, 0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, \
0.937255, 
0.968627, 0.968627, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 
0.905882, 0.870588, 0.870588, 0.839216, 0.839216, 0.839216, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, \
0.709804, 
0.678431, 0.678431, 0.647059, 0.54902, 0.321569, 0.129412, 0.0627451, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, \
0.968627, 
0.968627, 1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.905882, 
0.870588, 0.870588, 0.870588, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.741176, 0.709804, 0.709804, 0.709804, \
0.678431, 
0.678431, 0.647059, 0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, \
0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.839216, 0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, \
0.968627, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.741176, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 1, 
1, 1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, \
0.870588, 
0.870588, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.54902, 0.352941, 0.160784, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.807843, 0.839216, \
0.839216, 
0.839216, 0.870588, 0.870588, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.647059, 
0.580392, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0313725, 0.0627451, 
0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.776471, 0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.776471, 0.776471, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.419608, 0.258824, 0.129412, 0.0627451, 0.0313725, 0.0627451, 0.0313725, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.776471, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0.968627, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \

0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.741176, 
0.741176, 0.741176, 0.741176, 0.776471, 0.776471, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, 0.647059, \
0.580392, 
0.482353, 0.290196, 0.160784, 0.0627451, 0.0313725, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 
0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.870588, 0.905882, 0.937255, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0.968627, 0.968627, 0.937255, 0.905882, 0.870588, 0.839216, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.741176, 0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.678431, \
0.611765, 
0.54902, 0.517647, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 0.0941176, 
0.0627451, 0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.709804, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.45098, 0.290196, 0.160784, 0.0627451, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 0.0627451, 
0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.870588, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.839216, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.807843, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.709804, 0.709804, 0.678431, 0.647059, 0.611765, \
0.54902, 
0.54902, 0.482353, 0.388235, 0.223529, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0941176, 0.0627451, 
0.0627451, 0.0627451, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, 
0.870588, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, 0.839216, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.741176, 
0.709804, 0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, \
0.54902, 
0.517647, 0.517647, 0.45098, 0.290196, 0.129412, 0.0627451, 0.0627451, \
0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0627451, 0.0627451, 0.0941176, 0.0941176, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725},
{0.807843, 0.807843, 0.807843, 0.839216, 0.839216, 0.839216, 0.870588, \
0.870588, 
0.905882, 0.905882, 0.937255, 0.968627, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
0.968627, 
0.968627, 0.937255, 0.937255, 0.905882, 0.870588, 0.870588, 0.870588, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.839216, 
0.839216, 0.839216, 0.839216, 0.807843, 0.807843, 0.807843, 0.807843, \
0.807843, 
0.807843, 0.807843, 0.807843, 0.807843, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.807843, 0.807843, 0.776471, 0.776471, 0.776471, 0.776471, 0.776471, \
0.776471, 
0.776471, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, 0.741176, \
0.709804, 
0.741176, 0.741176, 0.709804, 0.678431, 0.647059, 0.580392, 0.54902, \
0.482353, 
0.54902, 0.517647, 0.388235, 0.192157, 0.0941176, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0627451, 
0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 0.0627451, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 
0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, 0.0313725, \
0.0313725}};\
\>", "Graphics",
  Evaluatable->True,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell["size=Dimensions[sample]", "Input"],

Cell[BoxData[
    \({128, 128}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SamplePhoto = 
      ListDensityPlot[sample, Mesh \[Rule] False, 
        AspectRatio \[Rule] size[\([1]\)]/\((size[\([2]\)])\), 
        PlotLabel \[Rule] "\<Sample Photo\>"]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Sample) show
105.000 12.813 moveto
(Photo) show
135.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
73736B6B6B737373736B636B737373737373737373737373737373737373737373737373
73737B737373737373737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B84847B7B7B848C848C73
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B7373736B6B636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B8484847B6342
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B
6B6B6B6B6B73736B6B63636B73737373737373737373737373737B73737373736B6B7373
7373737373737B7B7B73737B7B7B7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7B7B7B7B7B84847B7B848484846B5A3118
6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B736B6B6B6B73
6B6B6B6B6B73736B6B636B6B73737373737373737373737373737B73737B7363636B7B7B
737373737B7B7B7B7B7B7B7B7B7B737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84
847B84847B7B7B84847B737B8C8C7B6339210000
736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B7373736B6B6B7373
736B6B6B7373736B6B636B7373737373737373737373737373737B73737B736363737B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484
84847B8484847B7B7B7B848C846B4A2910080000
7373737373736B6B6B6B6B6B6B6B6B6B6B6B6B6B6B6B737373737373737373736B737373
736B6B7373736B6B6B6B737373737373736B73737373737373737B737B7B6B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B8484847B7B848484848484
84847B8484848484848484735A39180000000000
737373737373737373737373736B73736B6B6B6B73737373737373736B6B73736B737373
6B6B6B7373736B6B6B6B73737373737373737373737373737B7B737B7B736B636B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B848484847B7B7B7B7B7B848484847B848484848484
848484847B7B848C8C846B4A2108000000000000
73737373737373737373737373737373737373737373737373737373737373736B6B7373
736B737373736B636B73737373737B7B7373737373737B7B7B7B737B7B736B6B737B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B7B847B8484847B7B7B7B7B7B7B8484848484848484848484
848484847B848C8C7B6342210800000000000000
737373737373737373737373736B73737373737373737373737373737373737373737373
7373737373736B6B73737373737B7B7B7B7B7B7B73737B7B7B7B7B7B736B6B737B7B7B7B
7B7B7B7B7B7B7B7B7B7B7B7B84847B8484847B7B7B7B8484848484848484848484847B84
848484848C8C8C73523118080000000000000000
7B7373737373737373737373737373737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B6B6B737B7B7B7B7B
7B7B7B7B7B7B7B7B8484848484847B8484847B7B7B848484848484848484848484848484
84848C8C8C7B6B4A210800000000000000080000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737373737373737373737373737373737373737373
73737373736B6B6B737B73737B7B73737B7B7B7B7B7B7B7B7B7B7B736B6373848473737B
7B7B7B7B7B7B84848484847B848484848484848484848484848C8C8C8C848C8C84848484
8C8C948C84633918080008000008080000000000
7B7B7B7B7B7B7B7B7B7B7B7B737373737B7B7B7B73737B7B7B7B7B7B7B7B7B7B7B7B7373
73737B736B6B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B736B6B737B7B7B737B
7B848484848484848484848484847B7B848484848484848484848484848484848C8C7B84
8C8C8C735A391808000800000000000000000000
7B7B7B7B7B7B7B7B7B7B7B7B7B7B73737B7B7B7B73737B7B7B7B7B7B73737B7B7B7B7B7B
7B737B736B6B73737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B736B737B847B7B7B7B
7B7B7B8484848484848484848484848484848484848484848484848484848484848C8C8C
8C7B634A29100800000800000000000000000000
7B7B7B7B7B7B84847B8484847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B737373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7373737B7B84847B8484
7B7B7B7B8484848484848484848484848484848484848484848C848484848C84848C948C
735A312108000000000800000000000000000000
84848484848484847B8484847B7B84847B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B
7B7B7B7373737B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B7B737B7B7B848484848484
7B7B7B7B84848484848484848484848484848484848484848484848484848C848C948C73
5231100800000808000000000000000000000000
848484848484848484848484847B8484847B8484848484848484848484847B7B7B7B7B7B
7B7B737373737B847B7B7B7B7B7B7B7B84847B7B7B7B7B7B7B7B7B7B84847B7B84848484
848484848484848484848484848484848484848484848484848484848484848C94947352
3118000000080800000000000000000000000000
8C8484848C8C84848484848484848484848484848484848484848484848484847B7B7B7B
7B7B7373737B7B847B7B7B7B7B7B7B7B7B847B7B847B7B7B7B7B848484847B7B84848484
8484848484848484848C8C8C8C8C848484848484848484848C848484848C8C8C947B4A29
1000000000000000000000000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C8484848484848484848484848484848484848484848484
84847B7B7B7B848484847B7B7B7B7B7B84848484847B7B7B7B7B84848484848484848484
848C8C84848484848C8C8C8C8484848484848484848C848C8C8C84848C8C948C734A2108
0800080000000000000800000000000000000000
8C8C8C8C8C8C8C8C8C8C8C8C8C848484848C8C8C8C8C8484848484848484848484848484
84847B7B84848484848484848484848484848484847B7B737B7B84848484848484848C8C
8C8C8C84848484848C8C8C84848484848484848C8C8C848C8C8C8C8C8C9494734A290808
0808000000080800000000000000000000000808
948C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C84848484848484848484848C94
8C847B8C8C7B7B84848484848484848484847B84847B7B7B848484848484848484848484
8484848484848484848C8C8C84848C8484848C8C8C8C8C8C84848C94948C735221100808
0808000000000000000000000000000000000000
9494949494948C8C8C8C9494948C8C8C8C8C8C8C8C8C8C8C8C8C848484848C84847B7373
7B84848C8C84848C848484848C8C8484848C848484848484848C84848484848484848484
84848484848484848C8C8C8C84848C8C8C8C8C8C8C8C8C8C8C848C8C846B4A2910000000
0000000000000000000000000000000000080000
9494949494949494949494949494949494948C8C8C8C8C8C8C8C8C8C8C8C8C847B73635A
6B84949C8C8C8C8C8C8C84848C8C8C84848C84848484848C8C8C8C8C8C8C8C8C8C8C8484
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C948C6B4A211000000000
0000080000000000000800000000000008080808
949494949494949C9C9C949494948C8C9494949494949494949494949494948C8C7B6B63
7B94A5A59C84848C8C8C8C84848C948C8C8C8C848484848C8C848C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C8C9494948C735231100800080808
0808080800000000080808080800000808080808
9C9C949494949C9C9C949494949C8C94949C9C9C9C948C8C8C84848C8C8C949494948C84
94ADB5CEBD9C848C8C8C8C8C8C94948C848C8C8484848C8C8C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C94948C8C8C8C8C8C8C8C8C94948C7B523118080000080800
0000080000000000080808080808080808080808
9C9C9C9C949494949C9C9C9C9C9CA59C9C9C948C847B6B6B6B63636B6B6B737B7B848484
9CB5C6DECEAD948C8C8C9494948C7B7B848C948C8C8C8C948C8C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C94949494948C8C8C8C8C94948463391808000000000000
0000000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9C9C9C9C9C949C948C84736B635A5A5252524A4A4A4A4A4A52525A7B
A5C6CECEB59C948C8C9CA5A58C736B73848C94948C8C9494948C8C8C8C8C8C8C8C8C8C8C
8C8C8C8C8C8C8C8C8C8C8C8C8C8C949494948C8C8C949494846B42210800000808080808
0800000000000000080808080808080808080808
9C9C9C9C9C9C9C9C9CA5A59C948C7B7B6B635A525252525252524A4A4239313131314273
B5DEE7CEADA5A5A5B5CEC6AD84636384948C9494949494948C8C8C8C8C8C8C8C8C8C8C8C
9494949494949494948C8C8C8C8C8C8C94948C8C9494948C734A29100808000808080008
0000000000000000000008080808080808080808
9C9C9C9C9C9CA5A59C9C94847B73635A5A5A5A5A5A52525A5A5A52524A4A42424252739C
CEE7D6AD94A5B5BDC6CEBDA5847B8494949C949494949494948C8C8C8C8C8C8C8C8C8C8C
9494949494948C8C8C9494948C8C9494948C8C9494948C734A2910000008080808000000
0000080808000008080808080808080808080808
9C9CA5A5A5A5A59C8C7B6B63635A635A5A5A5A635A5A63636363635A636363636B84ADCE
DEDEB58C7B94B5BDB5AD949494949C9C9494949494949494949494949494949494949494
949494949494949494949494948C8C9494949494948C735A311808000008080800000000
0008080808000008080808080808080808080808
A5A5A5A59C9C8C7B6B5A52525A5A63636363636B6B6B6B7373737373737B7B7B8CADC6DE
D6CE9C7B6B738C94949C949C9C9C9C9C9C949494949494949494949494949C9C9C9C9494
949494949494949494949494949494949494949C8C7B5A39180808080808080800000000
0808080808000008080808080808080808080808
A5A59C94847B63635A5A5A5A63636363636B6B7373737B7B7B8484848C8C8C949CA5ADB5
BDC6A58C736B6B6B849CA5A59C9494949CA59C9C9C9C9C9C949494949494949494949494
94949494949494949494949494949494948C949484634229080808080800000000000000
0808080808080808080808080808080808080808
9C8C7B73635A5A5A5A636363636363636B6B737B7B7B848484848C8C94949CA5A5A59CA5
ADBDA59C948C736B7B8C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C94949494949494
94949494949C94949494949C9C9494949494948C6B4A2110080000000000000000000008
0808080808080808080808080808080808080808
7B6B635A5A5A6363636363636363636B73737B7B84848C8C8C8C94949C9CA5A5A5ADADAD
ADADA5A5A59C94847B73949CA5ADA5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9494949494
9494949C9C9C9C9C94949C9C9C948C949C9C9C7B52311008000008000008000000000808
0808000808080808080808080808080808080808
635A5A5A636363636363636B6B736B737B7B84848C8C949494949C9C9CA5A5A5A5ADB5AD
ADA5ADADA59C9C94847B8C94A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C94949C9C9C9494949C9C8C6339180800080808080808000000080808
0808000808080808080808080808080808080808
5A5A5A6363636363636363636B73737B84848C8C949494949C9CA5A5A5A5ADADADADADAD
ADB5B5B5B5ADA5A5948C7B8C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C94949C9494A59C9C947B4A21080800000808000008000000080808
0808000808080808080808080808080808080808
5A5A5A636363636363636B73737B7B84848C8C94949C9C9C9CA5A5ADADADADADB5B5B5B5
B5B5B5B5ADADADADA5A58C848C9CA5A5A5A59C9C9CA5A5A5A5A59C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C9C9C9C9C949C9C9C9C947B5A3110000000080808080808080808080808
0808000808080808080808080808080808080808
6363636363636B6B6B73737B7B84848C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5
B5B5B5B5B5B5ADADA5A5948C84949CA5A5A59C9CA5A5A5A5A5A59C9C9C9C9C9C9C9CA59C
9C9C9C9C9C9C9C9C9C9C9C9C9C9CA59C8C63422108000000080808080808080808080808
0808000808080808080808080808080808080808
636363636B6B6B6B737B7B7B84848C94949C9C9CA5A5A5A5ADADADB5B5B5B5B5B5B5B5B5
B5B5BDBDBDB5B5ADADADA594848494ADADA5A5A5A5A5A5A59C9CA5A5A5A5A5A59C9CA5A5
A59C9C9C9C9C9C9C9C9C9C9C9CA5A594734A210800000000080808080808080808080808
0808080808080808080808080808080808080808
6363636B6B6B6B737B7B8484848C94949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBD
BDBDBDBDBDBDB5B5ADADADA58C848CA5ADA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
9C9C9C9C9C9C9C9C9C9C9C9C9CA59C845A31180800080000080808080808080808080808
0808080808080808080808080808080808080808
636363636B6B73737B84848C8C8C94949C9C9CA5A5A5ADADADADB5B5B5B5B5BDBDBDBDBD
BDBDC6BDBDBDBDBDB5ADADAD9C8C8494A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9CA5A5
9C9C9C9C9C9C9C9C9C9C9C9CA5A58C6B4221100800080000080808080808080808080808
0808080808080808080808080808080808080808
63636B6B6B73737B7B848C8C8C8C94949C9CA5A5A5A5ADADADADB5B5B5BDBDBDBDBDC6C6
C6C6C6BDBDBDBDBDB5B5ADB5AD948C8C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9C9C9CA59C9C9CA5A59C7B522910080000080000080808080808080808080808
0808080808080808080808080808080808080808
636B73737B7B7B7B848C8C8C94949C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6
C6C6C6C6BDBDBDBDBDB5B5B5ADA5948C949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A59C9C9C9CA5A59C9C9CA5A594845A391808000000080000080808080808080808080808
0808080808080808080808080808080808080808
6B7373737B7B84848C8C94949C9C9CA5A5ADADADADB5B5B5B5B5B5BDBDBDC6BDC6C6C6C6
C6C6C6C6C6C6BDBDBDBDBDB5ADAD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A59C9C
9C9CA5A5A5A5A59C949CA5A58C7342291008080800080000080808080808080808080808
0808080808080808080808080808080808080808
73737B7B84848C8C8C94949C9C9CA5A5A5ADADADB5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6
C6C6C6C6C6C6C6BDBDBDBDB5B5B5A59494949CA5A59C9CA5A59CA5A5A5A5A5A5A5A59C9C
A5A5A5A5A5A5A59C9CA5ADA57B5A31211008000000000808080808080808080808080808
0808080808080808080808080808080808080808
737B7B84848C8C8C94949C9C9CA5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6CEC6C6C6C6C6C6BDBDBDBDBDB5AD9C9C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A5A59C9C9CA5A594634229211008000000080808080808080808080808080808
0808080808080808080808080808080808080808
7B8484848C8C9494949C9CA5A5A5A5A5ADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6CECECECEC6C6C6C6C6C6BDBDB5B5A59C9C9CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59C9C9C9CA59C7B523121180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
8484848C8C949494949C9C9CA5A5A5A5ADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6BDB5B5B5AD9C94949CA5A5A5A5A5A5A5A5A5A5A5A5A5A5A5A5
A5A5A5A5A59CA59CA5A5946B422921180800000008080808080808080808080808080808
0808080808080808080808080808080808080808
84848C8C8C949494949C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5ADA594949CA5A5A5A5A5A5A5A5A5A5A5A5A5A59CA5
A5A5A5A5A5A59C9CA59C845A312118180808000008080808080808080808080808080808
0808080808080808080808080808080808080808
848C8C8C94949C9C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6
C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5B5A59C94949C9C9CA5A5A5A5A5A5A5A5A5A5A59C9C
9CA5A5A5A5A59CA5A59C734A291818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C8C9494949C9C9CA5A5A5ADADADADB5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDADA59494949C9CA59C9CA5A5A59C9C9C9C9C9C9C
9CA5A59C9C9C9CA5A5845A39211818100808080808080808080808080808080808080808
0808080808080808080808080808080808080808
8C8C94949C9C9C9C9CA5A5A5ADADADB5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5A59C9494949C9C9C9CA5A59C9C9C9C9C9C9C9C
9C9C9C9C9C9C9CA5946B4229212110080808080808080808080808080808080808080808
0808100808080808080808080808080808080808
8C949494949CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CEC6C6CECECECECECEC6C6C6C6BDBDB5ADAD9C948C94949C9C9C9CA59C9C9C9CA59C9C9C
9C9C9CA59C949C9C8C5A3121212110080808080808080808080808080808080808080808
0808081008080808080808080808080808080808
9494949C9C9CA5A5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECE
CECEC6C6C6CECEC6C6C6C6C6C6BDBDB5B5ADA59C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9C9C9C947B522921181810080808080808080808080808080808080808080808
0808101008080808080808080808080808080808
94949C9C9C9CA5A5A5A5ADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5AD9C8C8C949C9C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C9C9CA5A58C6B422118181010080808080808080808080808100808080808080808
1010101008080808080808080808080808080808
94949C9C9C9CADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECEC6C6C6CE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5ADA5948C8C949C9C9C9C9C9C9C9C9C9C9C9C
9C9C9C949CA5A58452312121181010080808080808080808080810100808080808081010
1010101008080808080808080808080808080808
94949C9C9CA5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6C6
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C8C8C8C949C9C9C9C9C9C9C9C9C9C94
9C9C9C949CA59C7342312921181010101008080808080808080810100808080808101010
1010101010080808080808080808080808080808
949C9C9CA5A5ADADADADADADB5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADA59C948C84949C9C9C9C94949C9C9C9C94
949C9C949CA58C6331292921181010101008080808080810101010100808081008101010
1010101010080808080808080808080808080808
9C9C9CA5A5A5ADADADADADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6CECECECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5ADADA5948C8C8C94949C9C94949C9C949C94
94949C9C9C9C734A29292921101010101008080808081010101010101010101010101010
1010101010080808080808080808080808080808
9C9C9CA5A5ADADADADADADB5B5B5B5B5B5B5BDBDBDBDC6C6C6BDBDC6C6CEC6CECECECECE
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5ADA59C8C8C8C9494949494949494949494
94949C9C9C946B4221293121101008101008080808081010181810101010101010101010
1010101010080808080808080808080808081010
9CA5A5A5A5A5ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5AD9C948C8C84949494949494948C9494
9494949C9C7B523121292918101010101010080810181818211810101008080810101010
1010101010080808080808080808080808081010
9CA5A5A5A5ADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6CECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADA59C948C848C9494949494948C9494
9494949C94734A2918292918101010101008080810183931291810101010080810101010
1010101008080808080808080808080808080808
9CA5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5ADADA59C8C848C9494949494948C9494
9494949C8C63392118212118101010080808080810184239291810101010101010101010
1010101008080808080808080808080808080810
A5A5A5ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6CECECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5ADA59C948C848C9494948C8C8C948C
949494947B5A312118292118100808080808080818213131291810101010101010101010
1010101008080808080808080808080808081010
A5A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6C6C6C6CECECECECECECECEC6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A5948C84848C8C8C8C8C8C8C8C
8C949494734A291821292118100808080808081010181818181010101010101010101010
1018101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5ADA5A59C94848484848C8C8C8C8C8C
8C94948C6B42211818211810100808080808080810101010101010101010101010101010
1818101008080808080808080808080808101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDB5ADADADA5948C847B84848C8C8C8C8C
8C948C846339211818181010100808080808100808101010080810101010101010101010
1818101010081010080808081010101010101010
A5A5ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6CECECEC6C6CECECECE
CECECEC6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5BDBDB5ADADA5948C847B8484848C8C8C84
8C948C7B5A31212121181008080808080808101010101010080810101008101010101010
1818101010081010080808081010101010101010
ADADADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA59C9C8C7B7B8484848C8C84
84948C6B4A31212121180808080808080808080808100808101010101010101010101018
1810101010100810101008080810101010101010
ADADADADADB5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6C6C6C6BDBDC6BDBDBDBDB5B5B5ADADA59C9484848484848C8C84
848C846B4A31292118100808080808080808080810100808101010101010101010101018
1810101010100810101008081010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CEC6C6C6
CECECEC6C6C6C6C6C6C6BDC6C6C6BDC6C6BDBDBDB5B5B5B5ADA5A5948C84847B848C8484
848C84634231292118100808080808080808080810101010101010101010101010101018
1810101010100810101008101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECEC6C6C6
C6CEC6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADA59C948C847B84848484
848C7B5A4231292110080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C948C847B7B848484
848473523931211808080808080808080808081010101010101010101010101010101018
1810101010100810101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDB5B5B5B5B5ADADA59C9C94847B7B848484
84846B4A3129181008080808080808080808101010101010101010101010101010101018
1810101010101010101010101010101010101010
ADADADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECEC6CECE
C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6BDBDBDB5B5B5B5ADADADA59C948C847B7B7B84
847B63422929181008080808081008081010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECECECE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6BDBDBDB5B5B5B5B5ADADA5A59C94847B7B7B7B
847B5A392921181008080808081008101010101010101010101010101010101010101018
1010101010101010101010101010101010101010
ADADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6CECECECECECECECEC6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6CEC6BDC6BDBDB5B5B5B5ADADADA59C949484737B7B
847B52312118100808080810080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101810
ADB5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECECECEC6C6C6
C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5ADADADA59C9C9484737B7B
847352312118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADA5A59C948C7B737B
7B734A292118100808080810100808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
ADB5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6C6C6CECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5B5B5B5ADADADA59C9C8C847373
7B6B4A291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6C6CECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5B5B5ADADADA5A59C94847373
736342291818080808080810101008080810101010081010101010101010101010181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDBDC6C6C6C6C6C6C6C6CECECECECEC6C6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5ADADADA5A59C948C7B73
6B6342291810080808080808080808080810101010081010101010101010101010181818
1010101010101010101010101010101010101018
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6BDBDBDBDC6C6C6C6C6C6CECECECECECECECEC6C6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADA5A5A59C948473
6B5A42291810080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5B5BDBDBDBDBDC6C6BDBDBDC6C6C6C6C6CECECECECECECECECECEC6C6
C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5ADA5A5A59C9C8C7B
6B5A39291808080808080808080808080810101010081010101010101010101018181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6BDC6C6C6C6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CECEC6BDBDBDC6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C9484
6B5239211810101010101010100810101010100808081010101010101010181818181810
1010101010101010101010101010101010100810
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6C6CECECECECECECECEC6C6C6C6
C6C6C6C6C6C6CEC6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5B5ADADA59C9C948C
735239211810080808101010101010101010101010101010101010101010181818181818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6C6CEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA59C9C9494
7B5A39211010080808101010101010101010101010101010101010101818181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDC6C6C6C6CECEC6CECECECECECECECEC6C6C6C6C6
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADA5A59C9C94
846339211010081010101010101010101010101010101010101010101018181818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDBDBDC6C6C6CECECEC6C6CECECECECECECECEC6C6C6CE
C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6C6BDBDBDBDBDBDB5B5B5B5ADADADA59C9C9C
8C6B42211010101010101010100810101010101010101010101010101018101818181818
1810101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6CECECEC6CECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6BDBDC6C6BDBDC6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C9C
947B52211010101010101010080810101010101010101010101010101018181818181818
1010101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADA5A59C
9C8C63291010101010101010100810101010101010101010101010101818182121211818
1818101010101010101010101010101010101010
B5B5B5B5B5B5B5BDBDBDBDBDBDBDC6C6C6C6CECECEC6CECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5B5ADA5AD9C
9C9473311018101010101010101010101010101010101010101010181818182129292118
1818101010101010101010101010101010101810
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6C6C6CECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5B5B5ADADAD9CAD
A5947B421010101010101010100810101010101010101010101010101018213131292118
1018101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6BDC6C6BDBDBDBDBDB5B5B5B5ADADA5AD
A59C844A2110101010101010100810101010101010101010101010101018213131292118
1818101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A58C5A2910101018101010101010101010101010101010101010101818294242292118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDBDBDBDBDC6C6CECECECECECECECECECECECECECECECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6BDBDC6C6C6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A5946B3110101018101010101010101010101010101010101010101818315A5A392118
1810101010101010101010101010101010101010
B5B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECECECECED6D6CECECECECECECECECE
CEC6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDBDC6C6BDBDBDBDB5B5B5B5ADADA5A5
A5A594734210101018101010101010101010101010101818101010101818426B6B422118
1010101010101010101010101010101010101010
B5B5BDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6CECED6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6BDBDB5B5B5B5B5ADADA5
A5A59C845218101018181010101010101010101010101818181010101818426B6B422118
1010101010081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5B5B5B5A5
A5A59C8C5A29101018101010101010101010101010101818101010101818395A5A392118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6CECECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CECEC6C6C6BDBDB5B5B5B5B5B5A5
A5A59C946B29101018181010101010101010101010181010101010101818314A4A292118
1818101008081010101010101010101010101010
BDBDBDBDBDBDBDBDBDC6C6C6CECECECECECECECED6D6D6D6D6D6D6D6CECED6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDC6D6D6C6C6BDB5BDBDB5B5B5B5AD
A5ADA5947331181018181010101010101010101010181810101010181821313939292121
1810101010101010101010101010101010101010
BDB5BDBDBDBDBDBDBDC6C6C6CECECECECECECED6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6D6D6CEC6BDBDBDBDB5B5B5B5AD
A5ADA5947B39181018181010101010101010101010181810101810181821293131292118
1810101010101010101010101010101010101010
B5B5BDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6CECECECECE
CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6CED6D6C6BDBDBDBDB5B5B5B5AD
A5ADA59C844A181018181010101010101010101010181810101810181821212929211818
1810101010101010101010101010101010101010
B5BDBDBDBDBDBDBDC6C6C6C6CECECECECECED6D6D6D6D6D6D6D6D6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CED6D6C6C6BDBDBDB5B5B5B5AD
A5ADA59C8C52211018181018101010101010101010101010101810101821212929211818
1810101010101010101010101010101010101010
BDBDBDBDBDBDBDBDC6C6C6CECECECECECED6D6D6D6D6D6D6D6DED6D6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6BDC6C6C6C6C6CECEC6C6BDBDBDB5B5B5B5B5
ADADA59C8C5A291018181018101018101010101010101010101818101818212121211818
1818101008080808101010101010101010101010
BDBDBDBDBDBDBDBDC6C6CECECECECECECED6D6D6DEDED6D6DEDEDED6D6D6D6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA59C9463311018181018101018101010101010101010101818101818212121181818
1010101008080808101008080808081010101010
BDBDBDBDBDBDBDC6C6C6CECECECECECED6D6DEDEDEDEDEDEDEDEDED6D6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5B5
ADADA5A59C6B311818181018101010101010101010101010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDBDBDC6C6C6CECECECECED6D6D6DEDEDEDEDEDEDEDEDEDED6D6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6BDBDC6C6C6C6C6C6C6BDBDB5B5BDB5B5
B5B5A5A59C73311810181818101010101010101010181010101818101818181818181818
1010101008080808101008080808080810101010
BDBDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEDEE7E7E7DEDEDEDED6D6D6D6D6CECECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDB5B5B5BDB5
B5ADADA5947B421818181810181010101010101818181010101010181818181818181818
1010100808080808080810101010080808081010
BDBDBDBDBDC6C6C6CECECECECECED6D6D6DEDEE7E7E7E7E7DEE7DEDED6D6D6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDB5B5BDB5
B5ADADA59C84421818181810181010101010101010181010101010181818181818181818
1810100808080808080808081008080808081010
BDBDBDBDC6C6C6C6CECECECECED6D6D6DEDEE7E7E7E7E7E7E7E7E7DED6DED6D6D6CECECE
CECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5ADADAD9C844A1818181818181010101010101010101010101010181818181818181818
1810080808080808080808080808080808081010
BDBDBDBDC6C6C6CECECECECED6D6D6DEDEE7E7E7EFEFEFE7E7E7DEDEDEDED6D6D6CECECE
CECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADAD9C8C522118181818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808081010
BDBDBDC6C6C6C6CECECECED6D6D6D6DEDEE7E7EFEFEFEFE7E7E7DEDED6DED6D6CECECECE
CECECECECEC6C6C6C6CEC6C6C6CEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADAD9C8C522118101818181010101010101010101810101010181818101018181810
1010080808080808080808080808080808080808
BDBDBDC6C6C6CECECECECED6D6DEDEDEE7EFEFEFEFEFEFEFE7E7DEDED6DED6D6CECECECE
CECECECECECEC6C6CECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6CEC6C6BDBDBDBDBDBDB5
B5B5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6D6DEDEE7E7EFF7F7F7F7F7EFE7E7E7DED6DED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6CEC6C6C6C6C6C6C6CEC6BDBDBDBDBDBDBDB5
BDB5ADADA58C522118101818181010101010101010101810101010181818181818181818
1010080808080808080808080808080808080808
BDBDBDC6C6CECECECECED6D6DEDEE7E7EFEFF7F7F7F7F7EFEFE7E7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6C6C6CEC6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
BDB5ADADA594521810081818181010101810101010101810101010181818181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6D6DEE7E7EFEFF7F7FFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522108101010101818181818101010101010181818101010181818181818
1010080808080808080808080808080808080808
C6C6C6C6C6C6CECECED6D6DEDEE7EFEFF7F7FFFFFFFFF7F7EFE7E7DEDED6D6D6CECECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C522110081010101818181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6C6C6CECED6D6D6DEE7E7EFF7F7FFFFFFFFFFF7F7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6CEC6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810101010181818101010101010101010101010101010101010
1008080808080808080808080808080808080808
C6C6C6C6CECECECED6D6DEDEE7EFF7F7FFFFFFFFFFFFFFF7EFE7E7DEDEDED6D6CECECECE
CECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDB5
B5B5ADADA58C5A2910080810081010101818101010101010101010101010101010101810
1008080808080808080808080808080808080808
C6C6C6CECECECED6D6D6DEE7E7EFF7FFFFFFFFFFFFFFFFF7EFEFE7DEDEDED6D6CECECECE
CECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDB5B5
B5B5ADADA58C5A2918100810081008101010101010101010101010101010181010101810
1008080808080808080808080808080808080808
C6C6CECECECED6D6D6DEDEE7EFF7FFFFFFFFFFFFFFFFFFF7F7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDB5B5
B5B5ADADA594633118100810081008081010101010101010101010101010101010101010
0808080808080808080808080808080808080808
C6C6CECECED6D6D6DEDEE7EFEFF7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECEC6C6C6C6C6CECEC6C6C6C6C6C6C6BDC6C6BDC6C6BDBDBDB5B5
B5B5ADADA5946B4221100810081008081008101010101010101018181010101010101010
0808080808080808080808080808080808080808
C6CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFE7DEDEDED6D6D6CECECE
CECECECECECECECECECECECECECECECECECEC6C6C6C6C6C6C6BDBDBDBDC6C6BDBDBDB5B5
B5B5ADADA5947B4A29100810101008081008080808101010101018181818101010101010
0808080808080808080808080808080808080808
CECECECED6D6D6D6DEE7EFEFF7F7FFFFFFFFFFFFFFFFFFF7F7EFE7DED6DED6D6D6D6CECE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADAD9C8C846339181010100808100808080808101010181810101018101018101010
0808080808080808080808080808080808080808
CECECECED6D6D6DEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6CE
CECECECECECECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5B5
B5B5ADA59C8C8C734A291010100808080808080808101010101010101010101018101010
0808080808080808080808080808080808080808
CECECECED6D6DEDEDEE7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DED6DEDED6D6D6D6D6
D6D6CED6D6CECECECECECECECECECEC6C6C6C6C6C6C6C6C6C6C6C6BDBDBDBDBDBDBDB5BD
B5B5ADA59C8C8C7B63391810100808080808080808080810101010101010101018101010
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7F7FFFFFFFFFFFFFFFFFFFFF7EFEFE7DEDEDEDED6D6D6D6D6
D6D6D6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C8484734A2110100808080808080808080808101010101010181818101008
0808080808080808080808080808080808080808
CECECED6D6D6DEDEE7E7EFF7FFFFFFFFFFFFFFFFFFFFF7F7EFEFE7DEDEDED6D6D6D6CECE
CECED6D6D6D6CECECECECECECECECEC6C6C6C6CECEC6C6C6C6C6C6C6BDBDBDBDBDBDB5BD
BDB5ADA5948C7B8C84633118101008080808080808080808080808101010101010101008
0808080808080808080808080808080808080808
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo000LOol2
000QOol40003Ool2000POol30002Ool2000NOol30004Ool2000OOol20004Ool2000KOol50002Ool2
0004Ool2000GOol500000goo000000020003Ool2000COol001]oo`04001oogoo000POol00`00Oomo
o`03Ool01000Oomoo`0087oo00@007ooOol0009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo00@007ooOol0009oo`04001oogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0
009oo`03001oogoo01Ioo`05001oogooOol00005Ool01000Oomoo`004Woo000KOol01000Oomoo`00
8Goo00<007ooOol00Woo00@007ooOol001eoo`D00005Ool007ooOol0000MOol01000Oomoo`000Woo
00@007ooOol001eoo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001o
ogoo0002Ool00`00Oomoo`0FOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`004Woo000K
Ool01000Oomoo`008Woo00D007ooOomoo`00009oo`03001oogoo01]oo`04001oogoo0002Ool01000
Oomoo`007Goo0`000goo00@007ooOol001ioo`8000=oo`04001oogoo000LOol01@00Oomoogoo0000
0Woo00@007ooOol0009oo`03001oogoo01Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00
Oomoo`0@Ool001]oo`04001oogoo000POol01000Oomoo`000Woo00@007ooOol001ioo`03001oo`00
009oo`04001oogoo000NOol00`00Oomoo`02Ool01000Oomoo`007Goo00@007ooOol0009oo`04001o
ogoo000LOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo01Ioo`05001oogooOol0
0002Ool01000Oomoo`000Woo00<007ooOol047oo000LOol2000ROol20004Ool2000POol20003Ool2
000OOol30003Ool2000OOol20004Ool2000LOol20004Ool20004Ool2000HOol20004Ool20004Ool2
000COol00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`00ogoo8Goo003oOolQOol001Qoool0
00D000Aoo`0067oo00<007ooOol00Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo
00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo
00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo0P0017oo000HOol00`00Oomoo`3oOol1
Ool00`00Oomoo`02Ool0015oo`8000Eoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@0
07ooOol000Aoo`03001oogoo0?moo`5oo`03001oogoo009oo`0047oo00@007ooOol000Aoo`<00?io
o`<000Aoo`0047oo00@007ooOol000Aoo`03001oogoo009oodHe[@@icPHe[@PicP03=JdaS36<008e
[C<icP8mka<icT4mk`=240Hmk`924096<@924096<@8icPEoo`03001oogoo009oo`0047oo00@007oo
Ool000Aoo`03001oogoo009oodHe[@@icPHe[@PicP03=JdaS36<008e[C<icP8mka<icT4mk`=240Hm
k`924096<@924096<@8icPEoo`03001oogoo009oo`004Goo0P001Goo00<007ooOol00WooD3F]1SW>
0cF]0S6<0SF]73W>0Sg_2CW>13F]43W>13g_1cW>BSg_1T8@0Sg_0S6<0R481Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Oom@=Jd6>Lh3=Jd2<H`2=JdL>Lh2?Nl9>Lh4=Jd@>Lh4?Nl7>Li:?Nl6@Q02
?Nl2<H`28@P5Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooe0e[@@icP@e[@<aS08e[A`icP8m
k`TicP@e[A0icPHmk`<icP`mk`HicRlmk`A240<mk`Q2408e[@8]J`8HaP8<H`Eoo`03001oogoo009o
o`0067oo00<007ooOol00WooD3F]13W>13F]0c6<0SF]73W>0Sg_2CW>13F]43W>1Sg_0cW>33g_1SW>
;cg_148@0cg_248@0SF]0Re[0QS60PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Oolj=Jd2
>Lh8=Jd2>Lh:=Jd4>Lh4=Jd00c6<=Jde[@02=JdL>Lh2?Nl3>Lh2?Nl2>Lh4<H`2=Jd4?Nl8>LhC?Nl2
>LhW?Nl4@Q02?Nl4@Q06?Nl4@Q02?Nl00cW>?Nlmk`04AS42?Nl2<H`27>L248@40005Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oocXe[@8icPPe[@8icPXe[@@icP@e[@03<H`e[CF]008e[A`icP8m
k`<icP8mk`8icP@aS08e[@@mk`PicQ<mk`8icRLmk`A2408mk`A240Hmk`A2408mk`03>Lhmkcg_00A6
<@8mk`8aS08Li`8@Q0@000Eoo`03001oogoo009oo`0067oo0P000goo0SW>=3F]1SW>1SF]1SW>1SF]
1SW>13F]00<aS3F]=Jd07SW>0Sg_0cW>0Sg_0SW>136<0SW>A3g_2T8@0Sg_1T8@23g_00=244HaAS40
0T8@0SF]0RDY0QBU0PQ20P@Q100017oo0P0017oo000HOol00`00Oomoo`02Ool2>Lhd=Jd6>Lh6=Jd6
>Lh6=Jd6>Lh4=Jd00c6<=Jde[@0N>Lh2?Nl3>Lh2?Nl2>Lh4<H`2>Li4?Nl:@Q02?Nl6@Q08?Nl00d8@
AS56<@02@Q02=Jd29BT25:D2248212440005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo``i
cQle[A<icP8e[@PicP@e[@HicPLe[@hicP8e[A0icP8mk`03>Lhmkcg_008mk`8e[@8aS08e[BDmk`A2
40hmk`I240<mka12408mk`m2408icP8]J`8Li`8<H`X000Eoo`03001oogoo009oo`0067oo00<007oo
Ool00Woo33W>7cF]4cW>0SF]23W>13F]1SW>1cF]3SW>0SF]43W>0Sg_00<icSg_?Nl00Sg_0SF]0S6<
0SF]9Cg_148@3Sg_1T8@0cg_448@0Sg_3d8@0SW>0Re[0QcW0PaS2P001Goo00<007ooOol00Woo000H
Ool00`00Oomoo`02OolI>Lh2=Jd4>Lh8=Jd?>Lh4=Jd4>Lh2=Jd6>Lh6=Jd6>Lh7=JdL>Lh4?Nl2>Lh3
?Nl2>Lh2=Jd2<H`2=JdS?Nl8@Q0<?Nl7@Q02?NlD@Q04?Nl2@Q04AS42@Q000cF]9BTU:@0248@2124<
0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooaTicP8e[@@icPPe[@licP@e[@@icP8e[@Hi
cPHe[@HicPLe[A`icP@mk`8icP<mk`8icP8e[@8aS08e[B<mk`Q240`mk`M2408mkaA240@mk`9240A6
<@924003=JdU:BDY008@Q0848@`000Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo?SW>13F]
1SW>0SF]23W>0SF]0S6<0SF]2CW>13g_33W>23g_0SW>0cg_0SW>13F]0SW>7cg_0T8@0Sg_1T8@3Sg_
7D8@0Sg_0T8@14Ha0Sg_0S6<00<Q212448@00P@Q3P001Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ooln>Lh4=Jd6>Lh2=Jd8>Lh2=Jd2<H`2=Jd9>Lh4?Nl<>Lh8?Nl2>Lh3?Nl2>Lh4=Jd2>LhO?Nl2
@Q02?Nl6@Q0>?NlM@Q02?Nl2@Q04AS42?Nl2<H`00b4848@@Q002124>0005Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo009ooaTicP8e[CLicP@e[@TicPhmk`@icP/mk`8icP@e[@8icQlmk`A2408mk`I2
40PmkaM2408mk`Y240I6<@8icP8YBP8HaP0336<48@@Q010000Eoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo6CW>0SF]=cW>13F]2CW>3Sg_13W>2cg_0SW>13F]0SW>7cg_148@0Sg_1T8@23g_5d8@
0Sg_2T8@1THa0SW>0RU:0QS600<<H`@Q124040001Goo00<007ooOol00Woo000HOol20003Ool2?Nm>
>Lh6=Jd2>Lh00cg_>LhicP02>LhO?Nl4=Jd2>LhJ?Nl;@Q02?Nl6@Q06?NlQ@Q06AS42?Nl2=Jd29BT2
48@2124=000212440004Ool20004Ool001Qoo`03001oogoo009ooa/mkcDicPHe[@8icP03?NlicSW>
008icP@mk`@icQHmk`03>Lhe[CF]008aS08icPA240@icPhmk`U2408mkaY240M6<@9240A6<@Q240A6
<@9:DP96<@92408aS08Li`8<H`848@80000312400000008000@48@X000Eoo`03001oogoo009oo`00
67oo00<007ooOol00Woo6cg_=CW>1SF]0SW>00<mkcW>>Lh00SW>13g_13W>5Sg_00<icSF]=Jd00S6<
0SW>148@13W>3Sg_2D8@0Sg_6T8@1dHa0T8@14Ha248@14Ha0TYB0THa0T8@0S6<0QcW0PaS0P@Q0P00
00<48@0000000P0010@Q2P001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolG?Nl8>Lh8?Nl4
>LhG?Nl8>Lh2?Nl2>Lh6=Jd4>LhI?Nl4>Lh6?Nl00cW>=Jde[@02=Jd2>Lh6?Nl2>Lh4?NlI@Q04?NlO
@Q04AS42?Nl2@Q06AS42>Lh2;F/27>L236<212420002124C0005Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009ooaLmk`PicPPmk`@icQLmk`PicP8mk`8icPHe[@@icQTmk`@icPHmk`03>Lhe[CF]008e
[@8icPHmk`8icP@mkaU240@mkam240A6<@8mk`9240I6<@8icP8]J`8Li`8<H`848@8000848A<000Eo
o`03001oogoo009oo`0067oo00<007ooOol00Woo6cg_13W>23g_13W>2cg_13W>3Sg_0SW>0Sg_0SW>
13F]13W>9Cg_00<icSF]=Jd00SW>0Sg_0T8@3Sg_>T8@24Ha0Sg_0S6<0RDY0QBU0PQ20P@Q10000P@Q
4`001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolK?Nl4>Lh8?Nl4>Lh;?Nl4>Lh>?Nl2>Lh2
?Nl2>Lh4=Jd4>LhU?Nl00cW>=Jde[@02>Lh2?Nl2@Q0>?Nlj@Q08AS42?Nl2<H`29BT25:D224821244
0002124C0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo``mk`A2408mk`E243Dmk`PicRDm
k`DicP@mk`A2408mk`A240PmkbU24096<@M24096<@A24096<@9:DP96<@8icP8]J`8HaP8@Q0848@P0
00848A<000Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo33g_148@0Sg_1D8@=Cg_23W>9Cg_
1CW>13g_148@0Sg_148@23g_:D8@0THa1d8@0THa148@0THa0TYB0THa0SW>0Re[0QS60Q240P@Q2000
0P@Q4`001Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool@@Q02?Nl5@Q04?Nl4@Q0]?Nl6>LhW
?Nl2>Lh5?Nl<@Q08?Nlb@Q02AS42@Q02AS42BU82AS42>Lh2:DX26<H2248212440004124G0005Ool0
0`00Oomoo`02Ool001Qoo`8000=ooa12408mk`E240@mk`A242dmk`HicRLmk`8icPDmk`a240Pmkc92
4096<@924096<@9:DP96<@8icP8YBP8HaP88@P848@@000@48AL000Aoo`8000Aoo`0067oo00<007oo
Ool00Woo6D8@0Sg_1T8@0Sg_5d8@43g_23W>0Sg_0T8@3cg_148@4cg_148@13g_A48@0THa14YB0SW>
0RU:0QS60PaS1P0010@Q6@001Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolI@Q02?Nl6@Q02
?NlG@Q0@?Nl8>Lh2?Nl2@Q0??Nl4@Q0C?Nl4@Q04?Nm4@Q02AS44BU82>Lh2:DX26<H236<60004124I
0005Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`96<@I240A6<C9240`mk`HicP@mk`92414m
k`9240@mk`9240Xmk`M240@mkaY240U6<AA24096<@M240I6<@9:DP8mk`8U:@8DY@88@RD000Eoo`03
001oogoo009oo`0067oo00<007ooOol00Woo0THa1T8@14Ha<T8@33g_1SW>13g_0T8@4Cg_0T8@13g_
0T8@2Sg_1d8@13g_6T8@2DHa548@0THa1d8@1THa0TYB0Sg_0RDY0QBU0PQ29@001Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02OolIAS4a@Q08?Nl7@Q0<?Nl:@Q0:?NlE@Q04AS4:@Q07AS4B@Q02AS42
@Q06AS44@Q03AS42BU82AS42>Lh29BT248@412420002124<0002124C0005Ool00`00Oomoo`02Ool0
01Qoo`03001oogoo009ooaU6<C5240Pmk`M240`mk`Y240XmkaE240A6<@Y240M6<A924096<@9240I6
<@A240=6<@9:DP96<@8icP8U:@8@Q0@48@8000848@`000848A<000Eoo`03001oogoo009oo`0067oo
00<007ooOol00Woo6DHa248@2THa7d8@13g_8D8@13g_0SW>13g_3d8@2THa2T8@1DHa448@1THa0T8@
2dHa14YB0SW>0RDY0QBU20@Q1P0010@Q5@0010@Q1Goo00<007ooOol00Woo000:Ool40003Ool20005
Ool00`00Oomoo`02OolIAS48@Q0:AS4O@Q04?NlQ@Q04?Nl2>Lh4?Nl?@Q0:AS4:@Q05AS4@@Q06AS42
@Q0;AS44BU82>Lh29BT25:D812460004124E00041245Ool00`00Oomoo`02Ool000Yoo`03001oogoo
00=oo`04001oogoo0004Ool00`00Oomoo`02Ool2BU8[AS4E@Q02AS42BU82AS42@Q02?Nl4AS44?NlE
@Q02?Nl4@Q06?NlY@Q05AS44@Q02AS46@Q0<AS44@Q02AS43BU82AS42>Lh2:DX248@22488124S0005
Ool00`00Oomoo`02Ool000]oo`03001oogoo009oo`04001oogoo0004Ool30002Ool2BU8[AS4E@Q02
AS42BU82AS42@Q02?Nl4AS44?NlE@Q02?Nl4@Q06?NlY@Q05AS44@Q02AS46@Q0<AS44@Q02AS43BU82
AS42>Lh2:DX248@22488124S0003Ool30004Ool000aoo`05001oogooOol00002Ool00`00Oomoo`02
Ool00`00Oomoo`02Ool<BU87AS46BU8JAS47@Q02AS44@Q02?Nl4>Lh2?Nl4@Q04AS44@Q02AS47@Q04
AS46@Q02AS4>@Q02AS4S@Q07AS44@Q0FAS42@Q04AS400d8@=Jde[@029BT25:D2248W000212440005
Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo34YB
1dHa1TYB6THa1d8@0THa148@0Sg_13W>0Sg_148@14Ha148@0THa1d8@14Ha1T8@0THa3T8@0THa8d8@
1dHa148@5THa0T8@14Ha00=243F]=Jd00RDY0QBU0PQ29`000P@Q10001Goo00<007ooOol00Woo000;
Ool20004Ool20005Ool00`00Oomoo`02OolSBU8IAS42@Q02?Nl2>Lh2<H`2;F/2=Jd2@Q02BU82CW<;
AS44@Q06AS44@Q02AS4:@Q0EAS44@Q0cAS42BU82AS400cF]9BTU:@0248@2248<0002124<0002124;
00081245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oob=:DQU6<@92408mk`8icP8aS08]J`8e
[@92409:DP9>L`]6<@A240I6<@A24096<@Y241E6<@A243=6<@9:DP96<@03=JdU:BDY008@Q088@P`0
00848@`000848@/000P48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo3TYB1Dic24YB14Ha
7DYB14Ha0Sg_0SF]0S6<0Sg_0TYB15:D0Tic148@1dHa148@0THa0TYB24Ha248@14Ha0T8@@4Ha1TYB
0THa0SW>00<YBQS66<H00PQ20P@Q0P003P@Q20002@@Q10002P@Q1Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool>BU85CW<8BU84AS4MBU84AS42?Nl2=Jd2<H`2?Nl2BU84DY@2CW<4@Q07AS44@Q02
AS42BU88AS48@Q04AS42@Q10AS46BU82AS42>Lh00bU:6<HHaP0224821242000>124800091244000:
1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A>L`Q:DPI>L`M:DP9>L`96<@A:DPQ>L`9:
DPI6<@A240E6<@Q:DP96<@92409:DP9F]@9JeP9W>@9Nm`9>L`9240]6<@A:DP96<@9240A6<@I24396
<@A:DQ96<@A:DP96<@8mk`8YBP036<H<H`aS00848@@000@48@H000848@X001L48@Eoo`03001oogoo
009oo`0067oo00<007ooOol00Woo14ic24YB1Tic1dYB0Tic0THa14YB24ic0TYB1THa148@1DHa24YB
0THa0T8@0TYB0UJe0U[F0VLi0Ukg0Tic0T8@2dHa14YB0THa0T8@14Ha1T8@<THa14YB4THa14YB0THa
0Sg_0RU:00<HaPaS36<00P@Q100010@Q1P000P@Q2P005`@Q1Goo00<007ooOol00Woo000HOol20003
Ool8CW<8BU8;CW<2DY@6CW<2BU82AS42@Q02?Nl6=Jd4<H`5=Jd2>Lh4?Nl6@Q02CW<2F]H2HaP2Kg/2
IcT2E[D2BU85AS46BU82AS44?Nl2@Q02AS42BU88AS42BU8`AS4:BU8:AS44BU82@Q02<H`27>L00`aS
12448@0L000G1244Ool20004Ool001Qoo`03001oogoo009oo`Q>L`Q:DP]>L`9BU0I>L`9:DP96<@92
408mk`He[@@aS0De[@8icP@mk`I2409>L`9JeP9S609_N`9W>@9F]@9:DPE6<@I:DP96<@@mk`924096
<@9:DPQ6<@9:DS16<@Y:DPY6<@A:DP92408aS08Li`0336<48@@Q01`001L48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo6Dic0TYB0Tic0TYB0THa0T8@0SW>0SF]0S6<12e[1RU:2bDY12U:0Re[
0Sg_0U:D0V<H16Li0U[F0Tic0TYB14Ha00=>Le:DDY@00U:D0THa0SW>0SF]0SW>0T8@0THa14YB14Ha
1TYB<4Ha24YB1THa1TYB0T8@0SF]0R480Q2400<48@0000000P0030@Q3P005`@Q1Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02OolICW<2BU82CW<2BU82AS42@Q02>Lh2=Jd2<H`4;F/6:DX;9BT4:DX2
;F/2?Nl2DY@2HaP4IcT2F]H2CW<2BU84AS400dicDYABU002DY@2AS42>Lh2=Jd2>Lh2@Q02AS44BU84
AS46BU8`AS48BU86AS46BU82@Q02=Jd28@P248@00`@Q00000002000<124>000G1245Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009ooa9>L`=BU09>L`9:DP96<@@mk`8e[@8aS08]J`hYBP<U:@8Q208L
i`PHaP8Q208icP9JeP9_N`9cW09W>@9F]@IBU09JeP03IcUS66<H009F]@9240@aS092409:DP96<@a:
DQM6<A9:DPe6<@A:DPA6<@I:DP96<@8icP8U:@8DY@88@P<48@8000H48@8000848A@001<48@Eoo`03
001oogoo009oo`0067oo00<007ooOol00Woo4Tic0e:D0Tic0TYB0THa13g_0SF]0S6<0Re[3RU:0bDY
0R480QcW21S60R480SW>0U[F0Vmk0W>L0VLi0UJe1U:D0U[F00=W>F<HHaP00UJe0T8@136<0T8@0TYB
0THa34YB5dHa4TYB3DHa14YB14Ha1TYB0THa0SW>0RDY0QBU0PQ20`@Q0P001P@Q0P000P@Q50004`@Q
1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<CW<4DY@3CW<2BU82@Q02?Nl2>Lh2<H`<;F/4
:DX6;F/3:DX49BT68@P2:DX2>Lh2CW<2IcT2Li`2JeX2E[D2BU82DY@2F]H2G_L2HaP00fLiG_MNm`02
DY@2@Q02?Nl2@Q04BU82CW<>BU8EAS4<BU86AS45BU84AS46BU84AS46BU82AS42>Lh29BT25:D22483
0008124:00061244000I1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A>L`YBU09>L`96
<@03?Nle[CF]00@aS08]J`8aS0P]J`8aS0@]J`XaS003;F/aS36<00HaS08e[@92409F]@9W>@A_N`9J
eP96<@8mk`9:DP9JeP9Nm`9JeP03E[E:DTYB00I:DPA>Ld1:DPA6<@a:DP96<@8icP8]J`8HaP8<H`84
8@<000H48@X000P48@@001T48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo14ic2U:D0Tic
0THa00<mkcF]=Jd0136<0Re[0S6<22e[0S6<12e[2S6<00<]Jc6<<H`01S6<0SF]0T8@0UJe0VLi16mk
0U[F0THa0Sg_0TYB0U[F0Ukg0U[F00=F]DYBBU801TYB14ic@4YB14Ha34YB0THa0SW>0Re[0QS60PaS
0P@Q0`001P@Q2P0020@Q10006@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8DY@4CW<2
AS42?Nl2=Jd00be[:DXYBP02:DX4;F/:<H`8=Jd;>Lh6?Nl2AS42E[D2HaP2Kg/2JeX2IcT2CW<2?Nl2
=Jd2>Lh2AS44BU800dicBU9:DP0<CW<IBU88CW<YBU82CW<2AS42?Nl2;F/27>L236<=1248000:1244
000I1245Ool00`00Oomoo`02Ool001Qoo`8000=oo`QBU0A>L`96<@8mk`8e[@03;F/YBRU:008YBP@]
J`XaS0Pe[@/icPHmk`96<@9F]@9S609_N`9[FP9W>@9>L`8mk`8e[@8icP96<@A:DP03CW=:DTYB00a>
LaU:DPQ>LbU:DP9>L`96<@8mk`8]J`8Li`8<H`d48@P000X48@@001T48@Aoo`8000Aoo`0067oo00<0
07ooOol00Woo15:D0Tic0TYB0T8@0Sg_136<1be[2S6<13F]1SW>1Sg_1D8@1THa0TYB0Tic0U:D0UJe
0U[F0Ukg0V<H0U:D0THa0SW>1SF]0T8@00=>Le:DDY@00U:D0Tic1TYB0Tic0U:D34ic>4YB0THa14YB
0T8@0S6<0R480QBU2@@Q3P009`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4DY@2CW<2
BU82@Q02?Nl4<H`7;F/:<H`4=Jd6>Lh6?Nl5@Q06AS42BU82CW<2DY@2E[D2F]H2G_L2HaP2DY@2AS42
>Lh6=Jd2@Q000dicDYABU002DY@2CW<6BU82CW<2DY@<CW<hBU82AS44BU82@Q02<H`28@P25:D9124>
000W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`9>L`96<@8mk`8icP8aS0P]J`daS0@e
[@8icPHmk`Q240=6<@A:DP9>L`IBU09>L`9BU09F]@9Nm`9BU09>L`9:DP96<@8icP8e[@8mk`03AS5>
Ldic02=>LaQ:DP9>L`U:DPA>L`a:DP96<@8e[@8U:@8@Q088@P848A<002T48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo0Tic0THa0Sg_0SW>0S6<22e[3C6<13F]0SW>1Sg_248@0dHa14YB0Tic
1U:D0Tic0U:D0UJe0Ukg0U:D0Tic0TYB0THa0SW>0SF]0Sg_00=6<DicCW<08dic64YB0Tic2DYB14ic
34YB0THa0SF]0RDY0Q240PQ20P@Q4`00:@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
?Nl2=Jd2<H`6;F/A<H`2=Jd4>Lh4?Nl4@Q08AS43BU84CW<6DY@:E[D6DY@2CW<2BU82@Q02?Nl00cW>
BU9:DP02CW<2DY@2E[D4DY@MCW<@BU8:CW<4BU85CW<2BU82AS42BU86CW<2?Nl2:DX26<H224821244
000212430002124800081242000Q1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`8mk`8e
[@8aS0H]Ja4aS08e[@@icP@mk`A240Q6<@=:DPA>L`IBU0YF]@IBU09>L`9:DP92408mk`03>Li:DTYB
009>L`9BU09F]@ABU1e>La1:DPY>L`A:DPE>L`9:DP96<@9:DPI>L`8mk`8YBP8HaP88@P848@@00084
8@<000848@P000P48@8002448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0S6<1Re[3C6<
13F]0SW>0SF]0SW>13g_148@14Ha24YB1Dic25:D0UJe0U[F15Je0U:D15Je0U:D14ic0TYB0T8@00<m
kdHaAS400TYB1U:D>Dic14YB1Dic1TYB14ic0THa0S6<0QcW0PaS0P@Q0P002`@Q1P002P@Q0P008@@Q
1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2<H`6;F/=<H`4=Jd2>Lh2=Jd2>Lh4?Nl4@Q04
AS48BU85CW<8DY@2E[D2F]H4E[D2DY@4E[D2DY@4CW<2BU82@Q000cg_AS56<@02BU86DY@iCW<4BU85
CW<6BU84CW<2AS42<H`27>L236<21242000;1246000:1242000Q1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`H]Ja4aS08e[@@icP8mk`A240A6<@Q:DPA>L`MBU0iF]@QJeP9F]@ABU09:DP03
AS4mkcg_0096<@9>L`YBU1m>L`9BU1A>L`=:DP9>L`A:DP9BU0A>L`9:DP8mk`8U:@8@Q0@48@@000@4
8@<000848@H000X48@8002448@Eoo`03001oogoo009oo`0067oo0P000goo1Re[4C6<0SF]13W>0Sg_
148@14Ha24YB14ic1e:D3UJe25[F0UJe15:D0TYB00=6<Cg_?Nl00THa0Tic2U:D7dic0U:D54ic0dYB
0Tic14YB0U:D14ic0TYB0Sg_0RDY0Q2410@Q100010@Q0`000P@Q1P002P@Q0P008@@Q17oo0P0017oo
000HOol00`00Oomoo`02Ool6;F/=<H`2=Jd4>Lh4?Nl4@Q04AS44BU88CW<4DY@9E[D@F]H8E[D3DY@2
AS42@Q02AS42CW<8DY@6CW<:DY@XCW<2BU88CW<2BU82?Nl2;F/26<H22486000K1242000Q1245Ool0
0`00Oomoo`02Ool001Qoo`03001oogoo009oo`H]J`daS08e[@@icP@mk`A240A6<@A:DPQ>L`ABU0UF
]A1JePQF]@=BU096<@924096<@9>L`QBU0I>L`YBU2Q>L`9:DPQ>L`9:DP8mk`8]J`8HaP88@PH001/4
8@8002448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo336<1SF]0cW>13g_148@14Ha1TYB
1Tic1U:D1eJe65[F15Je0e:D0TYB0THa0T8@0TYB0Tic1U:D14ic35:D3dic0U:D7Dic0U:D0Tic0THa
0S6<0R480Q240P@Q1P006`@Q0P008@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<<H`6
=Jd3>Lh4?Nl4@Q04AS46BU86CW<6DY@7E[DHF]H4E[D3DY@2BU82AS42@Q02BU82CW<6DY@4CW<<DY@?
CW<2DY@MCW<2DY@2CW<2AS42<H`28@P248@21246000K1242000Q1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`PaS0Pe[@8icPDmk`A24096<@A:DPI>L`QBU0IF]AEJePINm`AJePEF]@9BU09:
DPA2409:DPAF]@iBU0A>L`]BU0A>L`IBU1M>L`ABU09:DP8icP8U:@8@Q0848@P003h48@Eoo`03001o
ogoo009oo`0067oo00<007ooOol00Woo236<23F]0SW>1Cg_148@0THa14YB1Tic25:D1UJe5E[F1Ukg
15[F1EJe0U:D0TYB148@0TYB15Je3U:D14ic2e:D14ic1U:D5dic15:D0TYB0SW>0RDY0Q240P@Q2000
?P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6<H`8=Jd2>Lh3?Nl6@Q02AS44BU86CW<6
DY@8E[D;F]HDG_L4F]H5E[D2DY@2AS42@Q02AS42DY@2E[DUDY@ICW<2DY@2CW<2@Q02;F/26<H236<2
124200021244000n1245Ool00`00Oomoo`02Ool000aoo`<0009oo`8000Eoo`03001oogoo009oo`Ha
S0Pe[@8icP<mk`I24096<@A:DPI>L`IBU0QF]@]JeQANm`AJePEF]@9BU096<@924096<@9BU09F]BEB
U1U>L`9BU09>L`92408]J`8HaP8<H`848@8000848@@003h48@Eoo`03001oogoo009oo`003Goo00@0
07ooOol0009oo`03001oogoo009oo`03001oogoo009oo`PaS0@e[@@icP8mk`=240I6<@A:DPI>L`IB
U0QF]@UJePiNm`9S60YNm`9JePEF]@9>L`96<@92409:DQmBU0A>L`ABU1M>L`ABU096<@8e[@8Q208@
Q088@P848@8000848@@003h48@Eoo`03001oogoo009oo`002Woo1@0000Eoo`00Oomoo`0000Aoo`<0
009oo`PaS0@e[@@icP8mk`=240I6<@A:DPI>L`IBU0QF]@UJePiNm`9S60YNm`9JePEF]@9>L`96<@92
409:DQmBU0A>L`ABU1M>L`ABU096<@8e[@8Q208@Q088@P848@8000848@@003h48@=oo`<000Aoo`00
2Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl00d8@AS56
<@06AS44BU84CW<8DY@8E[D5F]H:G_L:HaP:G_L3F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@5
CW<4DY@2CW<2?Nl2:DX25:D22482124400021244000n1245Ool00`00Oomoo`02Ool000]oo`03001o
o`00009oo`04001oogoo0004Ool00`00Oomoo`02Ool4<H`6=Jd4>Lh4?Nl00d8@AS56<@06AS44BU84
CW<8DY@8E[D5F]H:G_L:HaP:G_L3F]H2E[D2F]H2E[D2BU84AS42CW<WDY@<CW<2DY@5CW<4DY@2CW<2
?Nl2:DX25:D22482124400021244000n1245Ool00`00Oomoo`02Ool000aoo`8000=oo`8000Eoo`03
001oogoo009oo`8aS08e[@@icPPmk`9240E6<@A:DPA>L`IBU0IF]@]JePYNm`iS60YNm`EJeP9F]@9B
U09:DP96<@9:DP9>LbEBU0Q>L`ABU0I>L`=BU09:DP92408]J`8Li`8<H`848@H000848@@003h48@Eo
o`03001oogoo009oo`0067oo00<007ooOol00Woo0S6<0SF]13W>23g_0T8@1DHa14YB14ic1U:D1UJe
2e[F2Ukg3V<H2Ukg1E[F0UJe0U:D0TYB0THa0TYB0Tic9E:D24ic15:D1Tic0e:D0TYB0T8@0Re[0QcW
0PaS0P@Q1P000P@Q1000?P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2=Jd6>Lh4?Nl4
@Q03AS44BU86CW<4DY@8E[D<F]H5G_L2HaP2G_LDHaP9G_L2F]H4E[D2CW<4BU82CW<ODY@8CW<:DY@2
CW<2BU82CW<3DY@2AS42>Lh28@P25:D22486124200021244000n1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`8e[@HicP@mk`A240=6<@A:DPI>L`ABU0QF]@aJePENm`9S609NmaAS60UNm`9J
ePAF]@9>L`A:DP9>LamBU0Q>L`YBU09>L`9:DP9>L`=BU096<@8icP8Q208DY@88@PH48@8000848@@0
03h48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo13W>13g_148@1THa0dYB1Tic1U:D1UJe
35[F2Ekg66<H1ekg1U[F0U:D1TYB0Tic15:D14ic15:D0Tic3e:D14ic3U:D14ic0U:D00=F]E:DDY@0
0Sg_0Re[0QS60Q240PQ20P@Q2000@P@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4>Lh4
?Nl4@Q06AS43BU86CW<6DY@6E[D<F]H9G_LHHaP7G_L6F]H2DY@6BU82CW<4DY@4CW<4DY@2CW<?DY@4
CW<>DY@4CW<2DY@00eJeDYABU002?Nl2;F/26<H248@22482124800121245Ool00`00Oomoo`02Ool0
01Qoo`8000=oo`8icP@mk`A240I6<@=:DPI>L`QBU0AF]@YJeP]Nm`iS609W>@aS60UNm`9JeP9F]@Q>
LbeBU0I>L`=BU09:DP8aS08Q208DY@8@Q088@P848@H004@48@Aoo`8000Aoo`0067oo00<007ooOol0
0Woo0SW>13g_148@1THa0dYB1Tic25:D15Je2U[F2ekg3V<H0VLi36<H2Ekg0U[F0UJe24ic;E:D1Tic
0e:D0TYB0S6<0R480QBU0Q240PQ20P@Q1P00A0@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02
Ool2?Nl6@Q04AS46BU83CW<:DY@4E[D:F]H=G_L>HaP8IcT;HaP4G_L4F]H2DY@6CW<[DY@8CW<2DY@0
0dic?Nlmk`02:DX26<H248@236<4124400161245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`I240A6<@Q:DPE>L`QBU09F]@iJeP]Nmb5S609Nm`IJeP9F]@9>L`A:DP9>LbUBU09>L`9BU09>L`AB
U003BU8e[CF]008Q208DY@8@Q08<H`848@H004H48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo1T8@14Ha24YB1Dic25:D0UJe3U[F2ekg8F<H0Ukg1U[F0UJe0Tic14YB0Tic:E:D0Tic0U:D0Tic
15:D00=:DSF]=Jd00R480QBU0Q240PaS0P@Q1P00AP@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool4@Q06AS48BU83CW<8DY@4E[D>F]H;G_LOHaP4G_L6F]H2E[D2DY@4BU82CW<KDY@2CW<>DY@4
CW<2DY@2CW<00d8@;F/]J`026<H248@436<4124400161245Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`A240I6<@Q:DP=>L`QBU0AF]@iJeP]NmamS60ANm`IJeP9F]@9BU0A:DP9>La]BU09>L`iB
U0A>L`9BU09>L`03@Q0]Jbe[008HaP8@Q0@<H`@48@@004H48@Eoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo0T8@1THa14YB1dic1U:D25Je35[F3Ekg7f<H1Ukg1U[F0U:D0Tic14YB1Tic5E:D1Tic
2U:D0Tic15:D0Tic00<icRDY9BT00QBU10aS0PQ2CP@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool2@Q06AS44BU87CW<6DY@8E[D<F]H=G_LOHaP6G_L6F]H2DY@2CW<4BU86CW<EDY@6CW<:DY@2
CW<4DY@2CW<00cW>9BTU:@025:D436<2249>1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`I6<@I:DPI>L`EBU0QF]@aJeP]Nm`YS609W>A]S60QNm`9F]@9BU0I:DPA>L`9BU0A>L`EBU11>L`AB
U0Q>L`ABU0924003;F/LiacW008@Q0@<H`88@Th48@Eoo`03001oogoo009oo`0067oo0P000goo1THa
1TYB1Tic1E:D25Je35[F2ekg2V<H0VLi6f<H25kg0UJe0U:D1TYB14ic0U:D14ic1E:D44ic15:D24ic
15:D0T8@00<]JacW7>L00Q2410aS0PQ2CP@Q17oo0P0017oo000HOol00`00Oomoo`02Ool4AS44BU8:
CW<5DY@6E[D:F]H>G_L9HaP6IcTIHaP8G_L2F]H2DY@2CW<6BU88CW<3DY@NCW<2DY@2BU82=Jd00b48
5:DDY@0448@2248]1242248Q1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`A6<@A:DPY>
L`EBU0IF]@YJePiNm`US60IW>AUS60QNm`9JeP9BU09>L`I:DPQ>L`=BU1i>L`9BU09:DP8e[@038@PD
YABU00@@Q088@Rd48@88@R448@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0THa24YB0Tic
2E:D15Je3U[F3Ukg2F<H2VLi16<H36Li1f<H15kg0U[F15Je0Tic0TYB0THa14YB24ic00=BU4icCW<0
1Tic0U:D34ic0U:D0Tic0TYB14ic0THa0Re[00<HaQ2448@011240PQ2;`@Q0PQ27`@Q1Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool2AS48BU82CW<9DY@4E[D>F]H>G_L9HaP:IcT4HaP<IcT7HaP4
G_L2F]H4E[D2CW<2BU82AS44BU88CW<00e:DCW=>L`06CW<2DY@<CW<2DY@2CW<2BU84CW<2AS42;F/0
0aS648@@Q00448@2248_1242248O1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`I:DPI>
L`UBU0AF]@iJePiNm`US60aW>@IS60AW>@]S60ANm`AJeP9F]@9BU09>L`A6<@9:DRM>L`9:DP8mk`8Y
BP035:D@Q12400@<H`88@Rd48@@8@Ql48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo1TYB
1Tic2E:D15Je3U[F3Ukg2F<H36Li1V<H16Li2f<H15kg15[F0UJe0U:D0Tic14Ha0TYB9dic0TYB0Sg_
0RU:00<DYA2448@010aS0PQ2;@@Q10Q27`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4
BU88CW<7DY@4E[D>F]H<G_L?HaP:IcTGHaP4G_L4F]H2E[D2CW<4AS42BU8SCW<4DY@2AS42=Jd28@P0
0a2436<<H`0236<4248H1242248?1248248O1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`A:DPQ>L`MBU0AF]@iJePaNm`mS60YW>AMS60ANm`AJeP9F]@9>L`A6<@9:DR=>L`ABU096<@8e[@8Q
200348@<H`aS008<H`@8@QP48@88@Pl48@P8@Ql48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo14YB24ic2eJe3U[F35kg2F<H16Li1V<H1VLi5f<H15kg15[F0UJe0U:D0TYB14Ha0TYB7Dic0TYB
0Tic15:D0T8@0RU:0QS60a240PaS10Q25P@Q10Q22`@Q30Q27`@Q1Goo00<007ooOol00Woo000HOol2
0003Ool4BU88CW<;E[D>F]H<G_L9HaP4IcT6HaP6IcTGHaP4G_L4F]H2E[D2DY@2BU84AS42BU8MCW<2
BU82CW<4DY@2@Q02:DX26<H348@236<4248F1244248;124<248O1244Ool20004Ool001Qoo`03001o
ogoo009oo`A:DPI>L`9BU0]F]@iJePaNm`US60IW>@IS60AW>AES60INm`AJeP9F]@9BU09>L`I6<@9:
DQ=>L`9:DPI>L`9:DP9>L`9BU09>L`8icP8Q208HaP035:D@Q124008<H`P8@Q848@@8@PT48A08@Qd4
8@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo14YB1Tic0U:D2eJe3U[F35kg2F<H1VLi1V<H
16Li5F<H1Ukg15[F0UJe0U:D0Tic1THa0TYB4dic0TYB1Tic0TYB0Tic0U:D0Tic0SW>0R480QS600<D
YA2448@00PaS20Q24P@Q10Q22@@Q40Q27@@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
BU86CW<4DY@;E[D<F]HBG_L5HaP:IcTKHaP6G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02BU87CW<4BU88
CW<4BU84CW<2BU82CW<2DY@2AS42<H`26<H35:D248@236<8248<124:248512422482124@248M1245
Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`9:DPI>L`ABU0]F]@aJeQ9Nm`ES60YW>A]S60IN
m`AJeP9F]@9BU09>L`9:DP96<@92409:DPM>L`A:DPQ>L`A:DPA>L`9:DP9>L`9BU096<@8aS08HaP<D
Y@8@Q08<H`P8@P`48@X8@PD48@88@P848A08@Qd48@Eoo`03001oogoo009oo`0067oo00<007ooOol0
0Woo1Tic1U:D2EJe3U[F4Ukg0f<H3VLi6F<H1Ukg15[F15Je0U:D0TYB1THa14YB0dic14YB14ic0TYB
0Tic1TYB24ic0SW>0RDY1ABU0Q242PQ22P@Q9@Q27@@Q1Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool6CW<6DY@9E[D>F]HBG_L3HaP>IcTIHaP6G_L4F]H4E[D2DY@2BU86AS44BU83CW<4BU84CW<2
BU82CW<6BU88CW<2>Lh29BT55:D248@:248:124U248M1245Ool00`00Oomoo`02Ool000Yoo`<000Ao
o`8000Eoo`03001oogoo009oo`I>L`ABU0]F]@iJePQNm`IS60ANm`=S609W>@9S60YW>AUS60YNm`9J
eP9F]@9BU09>L`I6<AU:DPI>L`9:DP8e[@8Q208@Q08DY@036<H@Q12400@8@P848@@8@PX48@@8@P@<
Had8@QT48@@8@PEoo`03001oogoo009oo`002Woo00@007ooOol0009oo`04001oogoo0004Ool00`00
Oomoo`02Ool6CW<4DY@;E[D>F]H8G_L6HaP4G_L3HaP2IcT2HaP:IcTIHaP:G_L2F]H2E[D2DY@2CW<6
AS4IBU86CW<2BU82=Jd28@P248@25:D00aS648@@Q00424821244248:1244248436<M248I12442485
Ool00`00Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`000Woo0Tic2U:D1eJe
45[F3Ukg16<H3fLi6f<H2Ukg15[F0UJe0Tic0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q24
0aBU0PaS30Q210@Q0PQ21PaS0Q240PaS1@Q21P@Q4PQ26@@Q10Q20goo0`0017oo000:Ool30003Ool0
1000Oomoo`0017oo00<007ooOol00Woo0Tic2U:D1eJe45[F3Ukg16<H3fLi6f<H2Ukg15[F0UJe0Tic
0TYB14Ha0T8@3DYB0THa2TYB14ic0Sg_0RU:0QS60Q240aBU0PaS30Q210@Q0PQ21PaS0Q240PaS1@Q2
1P@Q4PQ26@@Q10Q21Goo00<007ooOol00Woo000;Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<0
07ooOol00Woo0Tic25:D2EJe45[F3Ukg1F<H3VLi6f<H2Ukg15[F0UJe0U:D0Tic0TYB0THa0T8@0THa
2dYB0THa2TYB0Tic0TYB0SW>0RDY0QBU0PaS0aBU0PaS2PQ21P@Q0PQ20PaS0QcW0QS60QBU0PaS1`Q2
10@Q40Q27`@Q1Goo00<007ooOol00Woo000;Ool30003Ool20005Ool00`00Oomoo`02Ool2CW<8DY@9
E[D@F]H>G_L5HaP>IcTKHaP:G_L4F]H2E[D2DY@2CW<2BU82AS42@Q02AS4;BU82AS4:BU82CW<2BU82
>Lh29BT25:D236<35:D236<:24861242248236<27>L26<H25:D236<72484124@248O1245Ool00`00
Oomoo`02Ool001Qoo`03001oogoo009oo`9>L`IBU0]F]A1JePaNm`IS60mW>A]S60YNm`AJePAF]@9B
U09>L`96<@924096<@]:DP96<@Y:DP9>L`96<@8aS08Li`8@Q08<H`<@Q08<H`H8@PX48@88@P8<H`8Q
208Li`8DY@8<Ha/8@Qd48@88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo0Tic1U:D2eJe
45[F35kg1V<H3fLi6f<H2Ukg15[F15Je0U:D0Tic0THa0T8@0THa2dYB0THa2TYB0Tic0THa0S6<0QcW
0Q240PaS0a240PaS1PQ22P@Q0PQ20PaS0R480QcW0QBU0PaS6`Q27@@Q0PQ21Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool6DY@<E[D?F]H:G_L8HaPAIcTKHaP:G_L6F]H2E[D2DY@2CW<2BU82AS42
@Q000dHaBU9:DP04BU86AS42BU82AS48BU82?Nl2;F/26<H248@236<25:D00a2436<<H`02248>1242
36<248@46<H25:D236<K248K12442485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IBU0aF
]@mJePYNm`QS615W>A]S60YNm`IJeP9F]@9BU09>L`9:DP96<@924003AS5:DTYB00A:DPI6<@9:DP96
<@Q:DP8mk`8]J`8HaP8@Q08<H`8DY@0348@<H`aS0088@Ph48@8<H`8@Q0@HaP8DY@8<Ha/8@Q/48@@8
@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U:D25Je4e[F2Ukg2V<H3fLi7F<H25kg1U[F
0UJe15:D0TYB0THa0d8@4THa1TYB0SW>0RDY0QBU0PaS0Q240QBU00<@Q0aS36<00PQ230@Q10Q220aS
5`Q20PaS10Q26@@Q1PQ21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6DY@8E[DCF]H:G_L:
HaP?IcTMHaP8G_L6F]H2E[D4DY@2BU82AS43@Q0BAS46BU82>Lh29BT25:D236<248@25:D00a2436<<
H`02248<1244248836<G248236<4248I12462485Ool00`00Oomoo`02Ool001Qoo`8000=oo`ABU0QF
]AEJePiNm`US619W>AMS60QNm`IJeP9F]@ABU09>L`9:DPM240i6<@A:DP96<@8e[@8Q208@Q0@<H`8@
Q00336<8@PQ20088@Ph48Al8@P@<H`@8@QT48@H8@PAoo`8000Aoo`0067oo00<007ooOol00Woo15:D
25Je4e[F45kg2F<H4VLi6f<H15kg0U[F0Ukg0U[F1UJe0U:D0TYB0THa00=243g_?Nl0148@34Ha0TYB
0THa0T8@0S6<0QcW0Q241PaS1@Q22P@Q0PQ210@Q1PQ210@Q4`Q210aS1PQ20P@Q10Q21`@Q40Q21Goo
00<007ooOol00Woo000HOol00`00Oomoo`02Ool4DY@8E[DCF]H@G_L9HaPBIcTKHaP4G_L2F]H2G_L2
F]H6E[D2DY@2BU82AS400d8@?Nlmk`04@Q0<AS42BU82AS42@Q02<H`27>L248@636<5248:12422484
12462484124C248436<6248212442487124@2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`ABU0QF]A=JePaNm`YS60EW>@AS60iW>AUS60ANm`9JePANm`9JePAF]@9BU09:DP96<@03@Q0mkcg_
00I240I6<@924096<@9:DP96<@8mk`8]J`8HaPH@Q08<H`0324848@@Q00`48@`8@P@48@D8@P848@`8
@P@<H`H8@P848@@8@PL48A08@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15:D25Je4e[F
35kg2V<H1FLi16<H3VLi6F<H15kg0U[F15kg0U[F15Je0U:D0TYB0THa00=243g_?Nl01T8@1THa0T8@
0THa0TYB0THa0Sg_0Re[0QS61Q240PaS00<8@P@Q124030@Q30Q210@Q1@Q20P@Q30Q210aS1PQ20P@Q
10Q21`@Q40Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool<E[D?F]H@G_L8HaP3IcT8HaP2
IcT6HaP6IcTCHaP>G_L6F]H2E[D2DY@4CW<00dHa?Nlmk`02?Nl6@Q04AS44@Q02BU82AS42=Jd29BT2
6<H648@236<E12422484124E248436<:248212462485124>2485Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`aF]@mJeQ1Nm`QS60=W>@QS609W>@IS60IW>A=S60iNm`IJeP9F]@9BU0A>L`03AS4m
kcg_008mk`I240A6<@A2409:DP96<@8e[@8U:@8HaPH@Q08<HaD48@88@P@48AD8@P@<H`X8@P848@H8
@PD48@h8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo2UJe4E[F45kg2V<H00=W>F<HHaP0
1V<H0VLi1V<H1VLi4f<H15kg0V<H25kg1U[F15Je0U:D0Tic00=:DT8@@Q00248@14Ha148@0THa0T8@
0SF]0RDY0QS60QBU0Q240PaS0PQ24`@Q10Q210@Q5@Q210aS2PQ20P@Q1PQ20`@Q40Q21Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool:E[DAF]H@G_L:HaP00fLiHaQS6006HaP2IcT6HaP6IcTCHaP4
G_L2HaP8G_L6F]H4E[D2DY@2CW<00dYB@Q124008@Q04AS44@Q02AS42@Q02=Jd29BT26<H25:D248@2
36<2248C12442484124E248436<:248212462483124@2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`QF]A=JeQ1Nma=S609W>@IS60IW>@eS609Nm`IS609Nm`AS60INm`QJeP9F]@ABU003BU96
<DHa00A2408mk`924096<@I24096<@92408aS08Q208HaP8DY@8@Q08<H`88@Q<48Ad8@P@<H`X8@P84
8@H8@P031248@PQ20108@PEoo`03001oogoo009oo`0067oo0P000goo25Je4e[F45kg4f<H0VLi1V<H
1VLi3F<H0Ukg1V<H0Ukg16<H1Ukg25[F0UJe15:D00=:DTHaAS40148@0Sg_0T8@0THa1T8@0THa0T8@
0S6<0R480QS60QBU0Q240PaS0PQ24`@Q7@Q210aS2PQ20P@Q1PQ200<48@Q2248040Q217oo0P0017oo
000HOol00`00Oomoo`02Ool8E[DCF]H@G_L?HaP6IcT8HaP2IcT?HaP2G_L<HaP6G_L8F]H4E[D2DY@0
0dicBU9:DP02AS42@Q02?Nl:@Q02AS42?Nl2;F/28@P26<H25:D248@2248C124O248436<:2482124I
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`QF]A=JeQ1Nm`mS60IW>@QS609W>@mS609N
m`aS60INm`QJePAF]@9BU003CW=:DTYB0096<@92408mk`Y24096<@8mk`8]J`8Q208HaP8DY@8@Q088
@Q<48Al8@P@<H`X8@P848AT8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo25Je4e[F3Ukg
3F<H2VLi6F<H0Ukg36<H15kg2U[F15Je0U:D00=>LdYBBU800THa0T8@13g_2T8@0SW>0RU:0QcW0QS6
0Q240PaS5@@Q7`Q210aS2PQ20P@Q6@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8E[DC
F]H>G_L=HaP:IcTIHaP2G_L<HaP4G_L:F]H4E[D2DY@00dicBU9:DP02AS42@Q04?Nl:@Q02>Lh2:DX2
7>L26<H248@236<E124O248436<:2482124I2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009o
o`QF]A=JePaNm`iS60]W>@9S60AW>A=S609Nm`aS60ANm`YJePAF]@9BU0=>L`9:DP9240@mk`Y2408e
[@8U:@8HaP8DY@8<H`88@Q<48B48@P@<HbD8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo
25Je4e[F35kg3V<H2fLi0V<H16Li4f<H0Ukg36<H15kg2U[F15Je0U:D0dic0TYB0T8@13g_2T8@0SF]
0RDY0QS60QBU0PaS0PQ24`@Q8@Q210aS9@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool8
E[D?F]H>G_L>HaP=IcT2HaP4IcTCHaP2G_L<HaP6G_L8F]H6E[D00e:DCW=>L`02BU82AS42@Q06?Nl4
@Q02?Nl2<H`28@P45:D236<2248912422484124U248236<W2485Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`QF]@mJePiNm`iS60eW>@9S60AW>A=S609Nm`aS60INm`QJePIF]@03DYA>Ldic009:
DP96<@9240Hmk`A2408mk`8aS08Q20@DY@8<H`88@PT48@88@P@48BD8@P8<HbL8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo0UJe4e[F45kg3V<H4fLi4V<H0ekg36<H1Ukg2U[F15Je0e:D0Tic
0TYB0T8@23g_0T8@0Sg_0Re[0QcW0QBU0Q240PaS0PQ22@@Q0PQ20P@Q9`Q20PaS9`Q21Goo00<007oo
Ool00Woo000HOol20003Ool2E[DCF]H@G_L>HaPCIcTBHaP3G_L<HaP6G_L:F]H4E[D3DY@2CW<2BU82
@Q08?Nl2@Q02?Nl2;F/27>L25:D248@236<2248912422482124W248236<W2484Ool20004Ool001Qo
o`03001oogoo009oo`AF]@mJeQ9Nm`iS60mW>AAS60=Nm`YS609W>@9S609Nm`9S60ANm`QJePEF]@9B
U09>L`A:DP92408icP@mk`92408mk`8YBP8HaP8@Q08<H`88@PL48@88@PX48@P8@P848A<8@PP<Hb<8
@P8<H`88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15Je3e[F4Ukg3V<H3fLi56<H0ekg
2V<H0VLi0V<H0Ukg0V<H15kg25[F1EJe0U:D0Tic14YB0T8@0SW>13g_0T8@0Sg_0RU:0QS60Q240PaS
0PQ21`@Q0PQ22P@Q20Q20P@Q4`Q220aS8`Q20PaS0PQ21Goo00<007ooOol00Woo000HOol00`00Oomo
o`02Ool2E[D@F]HAG_LBHaP;IcTFHaP3G_L>HaP8G_L8F]H5E[D2DY@4CW<2BU82@Q02>Lh4?Nl2@Q02
>Lh2:DX26<H248@236<224871244248812482482124E248636<W2485Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`9F]A1JeQ5Nma9S60]W>AIS60=Nm`iS60QNm`QJePEF]@9BU0A>L`9:DP92408i
cP@mk`92408icP8YBP8HaP8@Q08<H`88@PL48@@8@PP48@P8@P848AD8@PH<HbL8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo0UJe3U[F4ekg4f<H26Li6V<H00=Nmf<HHaP036<H25kg2U[F0eJe
15:D0Tic0TYB0THa0Sg_0SW>13g_0SW>0RDY0QBU0Q240PaS0PQ21`@Q10Q220@Q20Q20P@Q5@Q21PaS
9@Q20PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2E[D>F]HCG_LCHaP8IcTJHaP00ekg
HaQS600<HaP8G_L:F]H3E[D4DY@2CW<2BU82AS42?Nl2>Lh4?Nl2>Lh29BT25:D248@236<224871244
248812482482124E248636<U248236<5Ool00`00Oomoo`02Ool000]oo`8000Aoo`8000Eoo`03001o
ogoo009oo`9F]@iJeQ=NmaES60IW>BUS60QNm`YJePEF]@9BU0A>L`96<@9240@icP8mk`8e[@8U:@8D
Y@@<H`T48@H8@PH48@P8@P848AD8@PH<HbD8@P8<H`Eoo`03001oogoo009oo`002Woo00@007ooOol0
009oo`04001oogoo0004Ool00`00Oomoo`02Ool2E[D>F]HCG_LEHaP6IcTYHaP8G_L:F]H5E[D2DY@4
CW<2AS42@Q04>Lh2?Nl2=Jd29BT25:D436<91246248612482482124E248636<U248236<5Ool00`00
Oomoo`02Ool000Yoo`04001oogoo0002Ool01000Oomoo`0017oo0`000Woo45[F5Ekg4F<H26Li:F<H
2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2@@Q1PQ21P@Q20Q20P@Q5@Q21PaS9`Q2
0goo0`0017oo000;Ool20003Ool01000Oomoo`0017oo00<007ooOol00Woo45[F5Ekg4F<H26Li:F<H
2Ukg25[F1EJe15:D0Tic0TYB0T8@1SW>0S6<0R480QBU10aS2@@Q1PQ21P@Q20Q20P@Q5@Q21PaS9`Q2
1Goo00<007ooOol00Woo000:Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009ooa9J
eQ=Nma1S60UW>B]S60aNm`AJePEF]@ABU09>L`9:DP96<@8mk`8icP8e[@8aS08Q208DY@8<H`88@QD4
8@P8@P848AD8@PH<HbD8@P8<H`Eoo`03001oogoo009oo`002goo0P0017oo0P001Goo00<007ooOol0
0Woo4U[F4ekg46<H2FLi:f<H35kg15[F1EJe15:D0Tic0TYB0THa0Sg_0SW>0SF]0S6<0R480QBU0PaS
0PQ25@@Q20Q20P@Q5@Q21PaS9@Q20PaS1Goo00<007ooOol00Woo000HOol00`00Oomoo`02OolBF]H9
G_L2HaP8G_L<HaP?IcTYHaP<G_L7F]H2E[D6DY@2CW<2BU82@Q02>Lh2=Jd2;F/28@P25:D236<2248E
12482482124C248836<W2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa9JePUNm`9S60QN
m`aS60mW>BUS60aNm`MJeP9F]@IBU09>L`9:DP92408icP8e[@8]J`8Q208DY@8<H`88@QD48@P8@P84
8A<8@PP<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo4U[F2Ekg16<H1Ukg2V<H4fLi
9f<H3Ukg1E[F0UJe1U:D14ic0THa0Sg_0SF]0Re[0QcW0QBU0PaS5`@Q20Q20P@Q4`Q220aS9`Q21Goo
00<007ooOol00Woo000HOol00`00Oomoo`02Ool@F]H?G_L4HaP2G_L:HaP?IcTDHaP4IcT2HaP5G_L<
HaP<G_L9F]H4E[D2DY@4CW<2BU82@Q02=Jd2:DX27>L248@236<?2482124:2486124?248:36<U2482
12422485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1JePmNm`AS609Nm`YS60mW>AAS60AW
>@9S60ENm`aS60aNm`UJePAF]@9BU0A>L`9:DP92408e[@8YBP8Li`8@Q08<H`l8@P848@X8@PH48@l8
@PX<HbD8@P848@88@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo45[F3ekg2V<H0VLi16<H
3fLi56<H0VLi16<H0ekg3V<H35kg2E[F15Je0U:D14ic0TYB0THa0SW>0RU:0QcW0Q240PaS0PQ21P@Q
:0Q240aS8`Q21Goo00<007ooOol00Woo000HOol20003Ool@F]H?G_L:HaP2IcT4HaP?IcTDHaP2IcT4
HaP3G_L>HaP<G_L9F]H4E[D2DY@4CW<2BU82AS42>Lh2:DX27>L248@236<22486124X248@36<S2484
Ool20004Ool001Qoo`03001oogoo009ooa1JePmNm`YS609W>@9S60mW>AaS60=Nm`iS60iNm`MJePAF
]@9BU0A>L`A:DP8mk`8]J`8Li`8@Q0@8@PH48BD8@Q4<HbD8@PEoo`03001oogoo009oo`0067oo00<0
07ooOol00Woo45[F3ekg2V<H0VLi0V<H3fLi76<H0ekg3V<H3Ukg1e[F15Je0U:D14ic14YB0Sg_0Re[
0QcW0Q2410Q21P@Q9@Q24@aS9@Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool@F]H?G_L8
HaP4IcT2HaP?IcTLHaP3G_L@HaP<G_L7F]H4E[D4DY@4CW<2BU82@Q02<H`27>L248@42482124Z248@
36<U2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1JePmNm`QS60AW>@9S60mW>AaS60=N
ma1S60aNm`MJePAF]@ABU0A>L`9:DP92408aS08Li`8@Q0@8@P848BX8@Q0<HbD8@PEoo`03001oogoo
009oo`0067oo00<007ooOol00Woo3U[F4Ekg1V<H1VLi16<H3fLi1V<H0VLi4V<H0ekg46<H35kg1e[F
1UJe0U:D1Tic0THa0SF]0R480Q244@Q20P@Q7@Q20PaS0PQ230aS9@Q21Goo00<007ooOol00Woo000H
Ool00`00Oomoo`02Ool>F]HAG_L6HaP6IcT4HaP?IcT6HaP2IcTBHaP3G_L@HaP<G_L7F]H6E[D2DY@6
CW<2AS42=Jd28@P248@A2482124M248236<2248<36<U2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`iJePeNm`YS60IW>@9S61]W>A1S60=Nm`AS60ANm`QS60iNm`MJePAF]@ABU0A>L`9:DP8m
k`8YBP8@Q0l8@P@48Ad8@Ph<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo3U[F3Ekg
2V<H1VLi0V<H6fLi46<H0ekg16<H15kg26<H3Ukg1e[F15Je15:D14ic0TYB0Sg_0RU:0Q243`Q210@Q
7@Q23PaS9`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool>F]H=G_L8HaP6IcT2HaPMIcTG
HaP4G_L:HaP>G_L7F]H4E[D4DY@4CW<2AS42<H`25:DA2482124L248536<648@836<S2485Ool00`00
Oomoo`02Ool001Qoo`8000=oo`iJePeNm`QS60IW>@9S61eW>AMS60ANm`YS60iNm`MJePAF]@ABU0A>
L`96<@8aS08DYA48@P848A`8@PD<H`H@Q0P<Hb<8@PAoo`8000Aoo`0067oo00<007ooOol00Woo3U[F
3Ekg26<H1VLi0V<H7fLi5F<H15kg2V<H3Ukg2E[F0UJe0U:D0UJe14ic0TYB0SW>0QS60PQ20PaS:@Q2
1`aS0Q2411BU0Q241PaS7`Q20PaS0PQ21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool>F]H=
G_L8HaP6IcT2HaPOIcTEHaP4G_L:HaP>G_L9F]H2E[D2DY@2E[D4CW<2BU82>Lh26<H2248236<Y2487
36<248@45:D248@636<O248236<22485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJeQEN
m`YS62EW>B=S60iNm`MJePIF]@9>L`9F]@9BU09:DP8mk`8Q2148@P848Ad8@P8<H`8@Q0@HaP8DY@8@
Q08<H`88@P8<Hb<8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U[F5Ekg2V<H9FLi8f<H
3Ukg1e[F1UJe0Tic0UJe0U:D0TYB0Sg_0R484@Q20P@Q7@Q20PaS0Q2411S60QBU0Q240PaS0PQ20PaS
8`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6F]HEG_L6HaPYIcTEHaP4G_L:HaP2G_L4
HaP9G_L8F]H4E[D2DY@2E[D2DY@2CW<2@Q029BT248@?2482124M248236<248@46<H25:D248@636<S
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJeQENm`IS62UW>AES60ANm`YS609Nm`AS
60UNm`QJePAF]@9BU09F]@9BU09>L`92408U:@8@Q0l8@P848Ad8@P8<H`8@Q0@HaP8DY@8@Q0H<Hb<8
@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo1U[F5Ekg1V<H:FLi5F<H15kg1V<H15kg26<H
1ekg25[F15Je25:D0THa0Re[0QBU1PQ20PaS9@Q20`aS0QBU12480QBU0Q2410aS9@Q21Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool6F]HEG_L6HaPYIcTEHaP4G_L6HaP4G_L8HaP7G_L8F]H4E[D8
DY@2AS42;F/25:D6248236<U248336<25:D48@P25:D248@436<U2485Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`IJeQENm`AS62]W>AES60ANm`IS60ANm`QS60MNm`QJePAF]@QBU09:DP8e[@8H
aPH8@P8<HbD8@P<<H`8HaP@]J`8Li`8@Q0@<HbD8@PEoo`03001oogoo009oo`0067oo0P000goo1U[F
5Ekg16<H:fLi5F<H15kg1V<H15kg26<H1ekg25[F15Je25:D0TYB0SF]0QS61PQ20PaS9@Q20`aS0QS6
12e[0QcW0Q2410aS9@Q217oo0P0017oo000HOol00`00Oomoo`02Ool6F]H=G_L<HaPBIcT4JeXCIcTG
HaP4G_L8HaP6G_L4HaP7G_L8F]H4E[D8DY@2BU82>Lh28@P6248236<I248436<8248336<28@P4=Jd2
8@P248@236<W2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IJePeNm`aS619W>@A[FQ=W
>AMS60ANm`QS60INm`AS60MNm`QJePAF]@QBU09:DP8icP8Q20H8@P8<HaT8@P@<H`P8@P<<H`8Q20@e
[@8Q208@Q08<HbL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo15[F3Ukg2f<H36Li0V]J
16Li2f]J46Li8f<H15kg26<H0ekg2U[F15Je1U:D0Tic0T8@0RU:0PaS10Q210aS5`Q21PaS1PQ20`aS
0R4813F]0R480Q240PaS2PQ20P@Q6`Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool4F]H>
G_L;HaP<IcT2JeX4IcT;JeX@IcTSHaP4G_L8HaP3G_L:F]H4E[D6DY@2CW<2@Q02:DX236<4248436<G
248636<6248336<28@P4=Jd28@P248@236<:2482124K2485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009ooa1Nm`]S60aW>A=[FQ1W>C5S60=Nm`aJePIBU09>L`96<@8]J`8DY@@8@P8<HaT8@P@<H`P8
@P<<H`8Li`@]J`8Li`8@Q0H<H`@8@P@48A/8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo
45kg2f<H36Li4f]J46Li<F<H0ekg35[F1U:D0Tic0THa0Re[0QBU10Q20PaS6@Q210aS20Q20`aS0QcW
12e[0QcW0Q241PaS10Q210@Q6`Q21Goo00<007ooOol00Woo0004Ool50002Ool20004Ool20005Ool0
0`00Oomoo`02Ool@G_L;HaP<IcTCJeX@IcTWHaP4IcT6HaP3G_L<F]H6DY@2CW<2BU82=Jd25:D42484
36<E248236<<248336<26<H49BT25:D248@636<42484124K2485Ool00`00Oomoo`02Ool000Ioo`05
001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo45kg2f<H36Li
4f]J46Li9f<H16Li1V<H0ekg35[F1U:D0Tic0TYB0SF]0QBU10Q210aS5@Q20PaS30Q20`aS0QS612DY
0QBU0Q241PaS10Q210@Q6`Q21Goo00<007ooOol00Woo0006Ool01@00Oomoogoo00000Woo00@007oo
Ool0009oo`03001oogoo009oo`<0009ooa9Nm`ES611W>@m[FPAW>@9[FPiW>B=S60ANm`9S60A[FPAS
6003G_MJeU[F00ANm`QJeP9F]@9BU09F]@9BU09:DP8icP8HaP8<H`88@P@<HaD8@P@<H`P8@P<<H`8@
Q08HaP@Li`8DY@@@Q08<HbD8@P=oo`<000Aoo`001Woo00D007ooOomoo`00009oo`04001oogoo0002
Ool00`00Oomoo`02Ool00`00Oomoo`02OolBG_L5HaP@IcT?JeX4IcT2JeX>IcTSHaP4G_L2HaP4JeX4
HaP00ekgF]IJeP04G_L8F]H2E[D2DY@2E[D2DY@2BU82>Lh26<H236<2248436<E248436<8248336<2
48@26<H47>L25:D448@236<U2485Ool00`00Oomoo`02Ool000Ioo`05001oogooOol00002Ool01000
Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo0Ukg0U[F3Ukg1F<H3VLi5f]J3VLi9F<H0Ukg
0V<H16]J0VLi0V<H1ekg25[F0UJe0U:D0UJe0U:D0TYB0Sg_0QcW0PaS0PQ210aS5@Q210aS10Q20PaS
0PQ20`aS0Q240QBU11S60QBU0Q2410aS9@Q21Goo00<007ooOol00Woo0005Ool20004Ool20004Ool2
0005Ool00`00Oomoo`02Ool4F]H<G_L7HaP<IcTIJeX>IcTUHaP2G_L2HaP2IcT4JeX2HaP7G_L8F]H2
E[D2DY@2E[D2DY@2CW<2@Q029BT236<2248436<E248436<4248236<2248336<448@45:D248@636<U
2485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`AJePaNm`MS60aW>AU[FPiW>BES609Nm`9S
609W>@A[FP9S60MNm`QJeP9F]@9BU09F]@9BU09>L`92408U:@8<H`88@P@<HaD8@P@<H`@8@P8<H`88
@P<<H`@@Q0@DY@8@Q0H<HbD8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo0U[F3Ukg1f<H
36Li6f]J46Li9F<H0VLi16]J0f<H1Ukg25[F0UJe0U:D0UJe0U:D0Tic0THa0RU:0Q240PQ210aS00<8
@PaS36<06PQ20PaS10Q200<<Ha2448@00Q2411BU0Q241PaS9@Q21Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool2F]H>G_L7HaP<IcTKJeX@IcTUHaP2IcT4JeX3HaP6G_L8F]H2E[D2DY@2E[D2DY@2
CW<2AS42:DX248@2248436<00`Q236<<H`0J248236<424800`aS48@@Q00248@45:D248@636<U2485
Ool00`00Oomoo`02Ool001Qoo`03001oogoo009ooa1Nm`ES60aW>A1[FP9_N`][FQ1W>A]S609Nm`YS
60AW>@=S60INm`YJePAF]@9BU09>L`96<@8]J`8DY@88@P@<H`03248<H`aS00@8@P8<Ha@8@P@<H`88
@P<<H`P@Q0P<H`@8@PP48AL8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo45kg1F<H36Li
46]J0Vmk2f]J46Li6f<H0Ukg2V<H16Li0f<H1Ukg2U[F15Je0U:D0Tic0THa0Re[0QBU0PQ210aS00<8
@PaS36<010Q20PaS50Q210aS0PQ20`aS212420aS10Q220@Q5`Q21Goo00<007ooOol00Woo000HOol0
0`00Oomoo`02Ool@G_L3HaP>IcT6JeX4Kg/4JeX6Kg/9JeXBIcT8HaP00fLiHaQS600QHaP6G_L4F]H2
G_L4F]H4E[D2DY@2CW<2BU82<H`26<H2248436<00`Q236<<H`04248236<D248436<2248336<648@6
36<8248812442489124:2485Ool00`00Oomoo`02Ool001Qoo`8000=ooa1Nm`=S60iW>@I[FPA_N`A[
FPI_N`U[FQ9W>@QS6003IcUS66<H025S60INm`AJeP9Nm`AJePAF]@9BU09>L`9:DP8aS08HaP88@P@<
H`03248<H`aS00@8@P8<Ha@8@P@<H`88@P<<H`H@Q0H<H`P8@PP48@@8@PT48@X8@PAoo`8000Aoo`00
67oo00<007ooOol00Woo3Ukg1F<H36Li16]J4Vmk2F]J6fLi8f<H1Ukg15[F0Ukg15[F15Je15:D0Tic
0SF]0QS61PaS00<8@PaS36<06PQ210aS0PQ23`aS20Q220@Q10Q22`@Q20Q21Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool>G_L5HaP<IcT4JeXBKg/9JeXKIcTSHaP6G_L4F]H2G_L4F]H4E[D4DY@2
CW<2=Jd26<H636<00`Q236<<H`0J248436<2248?36<824881244248;12482485Ool00`00Oomoo`02
Ool001Qoo`03001oogoo009oo`iNm`ES60YW>@I[FQ=_N`Q[FQ]W>AAS60ANm`eS60ANm`AJeP9Nm`QJ
ePABU09>L`8icP8HaP8<H`88@PD<Ha88@P8<H`H8@P@<H`88@Pl<H`P8@PP48@@8@P/48@P8@PEoo`03
001oogoo009oo`0067oo00<007ooOol00Woo3Ukg1F<H2VLi1V]J4fmk26]J6fLi56<H15kg3F<H15kg
15[F0Ukg25[F15:D0Tic0SW>0QS60PaS0PQ21@aS4PQ20PaS1PQ210aS0PQ23`aS20Q220@Q10Q22`@Q
20Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool:G_L8HaP9IcT6JeX6Kg/6Li`8Kg/9JeX@
IcT`HaP4G_L6F]H2G_L4F]H4E[D2DY@2BU82?Nl28@P736<2248236<<248636<:248A36<6248>1247
248812442485Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`YNm`QS60UW>@I[FPI_N`IcW0Q_
N`U[FQ1W>C1S60ANm`IJeP9Nm`AJePAF]@9BU09:DP8mk`8Q20L<H`88@P8<H``8@PH<H`X8@Q4<H`H8
@Ph48@L8@PP48@@8@PEoo`03001oogoo009oo`0067oo00<007ooOol00Woo2Ukg1V<H2fLi1V]J16mk
2W>L0Vmk0W>L0fmk2V]J3VLi<6<H1Ukg15[F0Ukg15[F15Je0U:D0Tic0T8@0R481`aS0PQ20PaS40Q2
0PaS2PQ24`aS10Q24@@Q0PQ22P@Q10Q21Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool:G_L6
HaP;IcT6JeX4Kg/:Li`2Kg/2Li`3Kg/:JeX>IcT`HaP6G_L4F]H2G_L4F]H4E[D2DY@2CW<2@Q028@P7
36<2248236<@248236<:248C36<4248A1242248:12442485Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`QNm`QS60UW>@I[FPA_Na9cW003Kg][FV]J009_N`I[FPiW>C1S60YNm`IJePIF]@9>L`92
408U:@/<Ha`8@Q<<H`88@Ql48@@8@PEoo`03001oogoo009oo`0067oo0P000goo25kg26<H2FLi1V]J
16mk4W>L00=_Nf]JJeX00Vmk1V]J3VLi<6<H2Ukg1U[F1UJe0Tic0T8@0RDY2`aS70Q24`aS0PQ27`@Q
10Q217oo0P0017oo000HOol00`00Oomoo`02Ool8G_L6HaP9IcT6JeX4Kg/6Li`6Mkd6Li`7Kg/6JeX@
IcT^HaP:G_L8F]H4E[D2CW<2AS42:DX248@936<B248236<8248A36<4248O12442485Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oo`QNm`IS60UW>@I[FPA_N`IcW0Ig_@IcW0M_N`I[FQ1W>BiS60YN
m`QJePAF]@9>L`96<@8YBP8@Q0T<Ha88@P8<H`P8@Q4<H`@8@Ql48@@8@PEoo`03001oogoo009oo`00
67oo00<007ooOol00Woo1Ukg26<H1fLi26]J16mk17>L27Nm1W>L0fmk0V]J0Vmk16]J4VLi26<H00=W
>F<HHaP016<H0VLi7F<H35kg1U[F15Je0Tic0THa0RU:0Q240PaS0PQ21@aS4PQ20PaS20Q21@aS10Q2
1PaS1PQ28`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6G_L8HaP7IcT8JeX4Kg/4Li`8
Mkd6Li`3Kg/2JeX2Kg/4JeXBIcT8HaP00fLiHaQS6004HaP2IcTMHaP<G_L6F]H4E[D2CW<2AS42:DX2
48@236<2248536<B248236<8248536<4248636<6248S1245Ool00`00Oomoo`02Ool001Qoo`03001o
ogoo009oo`INm`IS60UW>@A[FPI_N`9cW0ig_@AcW0=_N`9[FP9_N`A[FQAW>@AS60=W>B1S609W>@=S
60aNm`IJePAF]@9BU096<@8YBP8@Q08<H`88@PD<Ha88@P8<H`P8@Q4<H`@8@R<48@Eoo`03001oogoo
009oo`0067oo00<007ooOol00Woo1Ukg1V<H2FLi16]J1Vmk0W>L3WNm17>L0fmk0V]J0Vmk16]J56Li
16<H0fLi86<H0VLi0f<H35kg1U[F15Je0U:D0THa0RU:0Q240PaS0PQ21@aS4PQ20PaS20Q24@aS10Q2
8`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool6G_L4HaP9IcT6JeX4Kg/4Li`2Mkd:Nmh2
Mkd6Li`00fmkJeY[FP02Kg/6JeXIIcT@HaP2IcT>HaP2IcT00f<HG_MNm`0<G_L2F]H2G_L2F]H4E[D2
DY@2AS42:DX248@236<2248536<B248236<8248A36<4248S1245Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`INm`AS60UW>@I[FPA_N`AcW09g_@YkgP9g_@IcW003Kg][FV]J009_N`I[FQUW>A1S
609W>@iS609W>@03HaQNmekg00aNm`9JeP9Nm`9JePAF]@9BU096<@8YBP8@Q08<H`88@PD<Ha88@P8<
H`P8@Q4<H`@8@R<48@Eoo`03001oogoo009oo`0067oo0P000goo1Ukg16<H2FLi16]J16mk17>L17Nm
2W_N17Nm17>L1Fmk1V]J6fLi3V<H0VLi4F<H3Ukg0U[F0Ukg0U[F15Je0U:D0TYB0RU:0PaS0PQ20P@Q
1@aS1PQ20PaS2PQ20PaS20Q24@aS10Q28`@Q17oo0P0017oo000HOol00`00Oomoo`02Ool6G_L4HaP9
IcT4JeX4Kg/4Li`4Mkd:Nmh4Mkd4Li`5Kg/6JeXKIcT>HaP2IcTAHaP>G_L2F]H2G_L2F]H4E[D2DY@2
BU82:DX236<22482124536<6248236<:248236<8248A36<4248S1245Ool00`00Oomoo`02Ool001Qo
o`03001oogoo009oo`aS60IW>@E[FP9_N`AcW0Ag_@AkgPIoo`AkgP9g_@AcW0=_N`I[FQ]W>B=S60iN
m`IJePAF]@9BU096<@8YBP8@Q0848@L8@PX<H``8@PH<H`D8@P`<H`@8@R<48@Eoo`03001oogoo009o
o`0067oo00<007ooOol00Woo36<H1VLi1F]J0Vmk17>L17Nm17_N1Woo17_N0WNm17>L0fmk1V]J6fLi
8f<H3Ukg1U[F15Je0U:D0THa0RU:0Q240P@Q1`Q22PaS30Q21PaS1@Q230aS10Q28`@Q1Goo00<007oo
Ool00Woo000HOol00`00Oomoo`02Ool<HaP6IcT3JeX4Kg/2Li`4Mkd4Nmh8Ool4Nmh2Mkd4Li`3Kg/6
JeXKIcTSHaP>G_L6F]H4E[D2DY@2AS42:DX248@224821245248:36<U248U1245Ool00`00Oomoo`02
Ool001Qoo`03001oogoo009oo`aS60IW>@=[FPA_N`9cW0Ag_@AkgPQoo`AkgP9g_@AcW0=_N`I[FQ]W
>B=S60iNm`IJePAF]@9BU096<@8YBP8@Q088@P848@D8@PX<HbD8@RD48@Eoo`03001oogoo009oo`00
67oo00<007ooOol00Woo36<H16Li1F]J0Vmk17>L0WNm17_N2Woo17_N0WNm17>L1Fmk16]J7fLi2V<H
0VLi4f<H3Ukg1U[F15Je0U:D0THa0Re[0QBU0PQ20`@Q20Q21PaS9@Q29@@Q1Goo00<007ooOol00Woo
000HOol00`00Oomoo`02Ool<HaP4IcT5JeX2Kg/4Li`2Mkd4Nmh:Ool4Nmh2Mkd4Li`5Kg/4JeXOIcT:
HaP2IcTCHaP>G_L6F]H4E[D2DY@2AS42;F/25:D224831248248636<U248U1245Ool00`00Oomoo`02
Ool000Aoo`D00003Ool00000008000=oo`8000Eoo`03001oogoo009oo`QS60QW>@=[FPA_N`9cW09g
_@AkgPioo`9kgP9g_@AcW0E_N`A[FR5W>AmS60aNm`IJePAF]@9BU096<@8]J`8DY@88@P<48@88@P84
8@H8@P@<Hal8@P8<H`@8@RD48@Eoo`03001oogoo009oo`001Woo00D007ooOomoo`0000Eoo`04001o
ogoo0004Ool00`00Oomoo`02Ool6HaP8IcT5JeX2Kg/4Li`2Mkd2Nmh@Ool2Nmh4Mkd2Li`5Kg/4JeXO
IcTQHaP:G_L8F]H4E[D2DY@2AS42;F/25:D236<224800`@Q2488@P0212422482124M248236<62482
36<4248U1245Ool00`00Oomoo`02Ool000Ioo`03001oogoo009oo`03001oogoo009oo`04001oogoo
0004Ool30002Ool6HaP8IcT5JeX2Kg/4Li`2Mkd2Nmh@Ool2Nmh4Mkd2Li`5Kg/4JeXOIcTQHaP:G_L8
F]H4E[D2DY@2AS42;F/25:D236<224800`@Q2488@P0212422482124M248236<6248236<4248U1243
Ool30004Ool000Ioo`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool4HaP8IcT6JeX3Kg/2Li`2Mkd2NmhBOol4Nmh2Mkd2Li`5Kg/6JeXIIcTWHaP8G_L8F]H4E[D2
DY@2BU82<H`26<H236<224800`@Q2488@P0212422484124W248W1245Ool00`00Oomoo`02Ool000Io
o`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo00<007ooOol00Woo16<H26Li
1V]J0fmk0W>L0WNm0W_N4Woo17_N0WNm0W>L1Fmk1V]J6FLi9f<H25kg25[F15Je0U:D0TYB0S6<0QS6
0PaS0PQ200<48@Q224800P@Q0PQ210@Q9`Q29`@Q1Goo00<007ooOol00Woo0005Ool20004Ool20004
Ool20005Ool00`00Oomoo`02Ool4HaP6IcT6JeX3Kg/2Li`4Mkd2NmhDOol2Nmh2Mkd2Li`5Kg/6JeXK
IcT:HaP4IcT>HaP2G_L3HaP2G_L4HaP6G_L8F]H4E[D2DY@2BU82=Jd28@P248@224800`@Q2488@P02
1242248412422482124@248436<?248W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`AS
60IW>@I[FP=_N`9cW0Ag_@9kgQAoo`9kgP9g_@9cW0E_N`I[FQ]W>@YS60AW>@iS609Nm`=S609Nm`AS
60INm`QJePAF]@9BU09:DP8e[@8Q208@Q088@P031248@PQ200848@88@P@48@88@P848A08@P@<H`l8
@RL48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo0V<H1VLi1V]J16mk0g>L0WNm17_N57oo
0W_N0WNm0W>L1Fmk1V]J:FLi3V<H1ekg16<H1Ukg25[F15Je0U:D0TYB0Sg_0RDY0QBU0PQ200<48@Q2
248010Q210@Q0PQ220@Q2PQ21`aS30Q29`@Q1Goo00<007ooOol00Woo000HOol00`00Oomoo`02Ool2
HaP6IcT6JeX4Kg/3Li`2Mkd4NmhDOol2Nmh2Mkd2Li`5Kg/6JeXYIcT>HaP7G_L4HaP6G_L8F]H4E[D2
DY@2BU82?Nl29BT25:D224800`@Q2488@P04248412422488124:248736<<248W1245Ool00`00Oomo
o`02Ool001Qoo`03001oogoo009oo`QW>@Q[FP9_N`03Liag_GNm009g_@AkgQ9oo`AkgP9g_@9cW003
Kg][FV]J009_N`Q[FR5W>AQS60eNm`QJePAF]@9>L`96<@92408aS08Li`8<H`D8@P@48@88@PX48@H8
@P@<H`D8@P8<H`@8@P8<H`H8@RL48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo26Li26]J
0Vmk00=cW7NmMkd00WNm17_N4Woo17_N0WNm0W>L00=_Nf]JJeX00Vmk26]J8FLi66<H3Ekg25[F15Je
0Tic0THa0T8@0S6<0QcW0PaS1@Q210@Q0PQ22P@Q1PQ210aS1@Q20PaS10Q20PaS1PQ29`@Q1Goo00<0
07ooOol00Woo000HOol00`00Oomoo`02Ool8IcT6JeX4Kg/00g>LMkeg_@04NmhDOol2Nmh4Mkd2Li`0
0fmkJeY[FP04Kg/8JeXOIcTHHaP=G_L8F]H2E[D2DY@2CW<4AS42>Lh29BT25:D5248@124E248236<6
248W1245Ool00`00Oomoo`02Ool001Qoo`8000=oo`QW>@I[FPA_N`03Liag_GNm00AkgQAoo`9kgPAg
_@9cW003Kg][FV]J00A_N`Q[FQmW>AQS60eNm`QJeP9F]@9BU09>L`A6<@8icP8U:@8DY@D8@Q048AD8
@P8<H`H8@RL48@Aoo`8000Aoo`0067oo00<007ooOol00Woo26Li16]J1Vmk00=cW7NmMkd017_N57oo
0W_N17Nm0W>L00=_Nf]JJeX016mk3V]J0VLi16]J4fLi66<H3Ekg0U[F0Ukg15[F0UJe0U:D0Tic14Ha
0Sg_0S6<0QcW00<<H`Q224800PQ250@Q4@Q20PaS1PQ29`@Q1Goo00<007ooOol00Woo000HOol00`00
Oomoo`02Ool8IcT4JeX6Kg/00g>LMkeg_@04NmhDOol2Nmh4Mkd2Li`00fmkJeY[FP04Kg/>JeX2IcT4
JeXCIcTHHaP=G_L2F]H2G_L4F]H2E[D2DY@2CW<4AS42?Nl2<H`27>L00`aS2488@P02248D124A2482
36<6248W1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IW>@I[FPA_N`=cW09g_@AkgQAo
o`9kgPAg_@9cW0M_NaI[FQ5W>@QS60AW>@eS60aNm`9JePANm`9JeP9F]@9BU09:DP96<@A2408icP8U
:@0348@8@PQ20088@QH48@/8@PH<H`@8@RT48@Eoo`03001oogoo009oo`0067oo00<007ooOol00Woo
1VLi1V]J16mk0g>L0WNm17_N57oo0W_N17Nm0W>L1fmk5V]J4FLi26<H16Li3F<H35kg0U[F15kg0U[F
0UJe0U:D0TYB0THa148@0SW>0RDY00<@Q0Q224800PQ25P@Q2`Q21PaS10Q2:@@Q1Goo00<007ooOol0
0Woo000HOol00`00Oomoo`02Ool6IcT6JeX4Kg/3Li`2Mkd2NmhDOol4Nmh4Mkd2Li`5Kg/8JeX8IcT8
JeXAIcT8HaP4IcT=HaP<G_L2F]H4G_L2F]H2E[D2DY@2BU82AS42?Nl2AS42@Q02<H`00aS636<<H`04
248J124?248Y1245Ool00`00Oomoo`02Ool001Qoo`03001oogoo009oo`IW>@I[FPA_N`=cW09g_@9k
gQAoo`AkgPAg_@9cW0E_N`Q[FPQW>@Q[FQ5W>@QS60AW>@eS60aNm`9JePANm`9JeP9F]@9BU09:DP96
<@8mk`96<@92408aS0036<H<H`aS00@8@QX48@l8@RT48@Eoo`03001oogoo009oo`0067oo00<007oo
Ool0ogoo0Goo00<007ooOol00Woo000HOol00`00Oomoo`3oOol1Ool00`00Oomoo`02Ool001Qoo`03
001oogoo009oo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03001oogoo02Aoo`03
001oogoo02Aoo`03001oogoo02=oo`03001oogoo019oo`03001oogoo009oo`0067oo0P000goo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<0
07ooOol01goo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01goo00<0
07ooOol01Woo00<007ooOol01goo00<007ooOol01goo00<007ooOol01Woo00<007ooOol01goo00<0
07ooOol01goo0P0017oo000HOooo00050004Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5o
o`00ogoo8Goo0028Ool3002EOol008Uoo`03001oogoo09Aoo`00Mgoo0`000goo1`0000Eoo`00Ool0
07oo00<000=oo`<000Aoo`<000Moo`<000=oo`<00003Ool00000009oo`8000Aoo`8000Aoo`8006Ao
o`00Mgoo00@007ooOol0009oo`@0009oo`07001oo`00Ool007oo00000Woo00D007ooOomoo`0000Ao
o`03001oogoo00Uoo`03001oogoo00=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0
009oo`04001oogoo001SOol007Yoo`03001oogoo00=oo`0:001oogoo001oo`00Ool007oo0002Ool0
1@00Oomoogoo000017oo100027oo0`000goo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomo
o`03Ool01000Oomoo`00Hgoo001hOol20004Ool300001goo00000000Ool007oo00@000Aoo`03001o
ogoo00=oo`8000Uoo`04001oogoo0002Ool30004Ool20002Ool50003Ool2001TOol007Moo`04001o
ogoo000EOol00`00Oomoo`0>Ool01000Oomoo`000Woo00<007ooOol02Goo00<007ooOol0JWoo001g
Ool4000DOol2000?Ool40002Ool2001hOol00?moob5oo`00ogoo8Goo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.1932, -8.85118, 0.514055, \
0.514055}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(w = waveletMatrix[128, coif30];\)\)], "Input"],

Cell[BoxData[
    \(\(wa = w . sample . Transpose[w];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[wa, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF4353FF00FF00FF74940000FF00FF00AF353CF539
B1C900FF007AA400CB60DE004700A00000FF00FF32CAA26D2523E02C66BD80A7537FBDF7
6968AB6C8D39139C21FF269B46A5964CDD14DA00F12F5F6F5E737D8E8A437A8983827E6F
1EDE66522761815AFF00FFFFCC6D907F70CD9579
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFF2000FFFF00009F8870293C80
24C800FF5704D7FF1A8996FF3DA4A80000FF00E6CE00B366C36D96AD347D84808687398B
637E71955ABC717F8CBC74B74B7348E03561E800ED00A45F4D645C2489FF728B749D8664
0D6B7E868586805EFF00FFFF9D41CB55888B7F98
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00BFAA0000CCFFFF00FF6C0000FF6D
1DFF00FF00FF33A2565CCC695578AA0000FF00FF320C30A8C833C3505A4975897495746D
69936E9D94C224BE4F4D80607B9C7EDD704E6750FF008A5A6FE77C798A8E80719529915B
987576747E7A8259FF00FFFF8342918471ADD375
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FF00E2FC00FF00001CFF6D00FF70
FF4537FF00FF04FF00FF00FF2BB49F0000FF00FF4C728D58A10086978B8B80748D549277
9A29717A7A8589C90FA05BAE4D8A6F735F56A4694BFF88E565C371876E9C7C924CFF00FF
2B6D5EB17485805EFF00FFFF3E66807A79D38D74
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00BCB1CB4700FF00FF00FFA266E800
FF37FF0000B5A26972FF009A771DBF0000FF00C79D258EC8E432BD41B06391648D8B6868
89595088805C78798D6A4ACD6479518DEE488500CFFFB7230489A0747D24A600CDAB5ECC
2FCA3481B5688450FF00FFFFA62AD773B2947A85
FFFFFFFFFFFFF0FFFFFFFFFFFFFFFFFF0078FF00FF00FFB6B3D121FF00FF00FF9B9F7FFC
7100FF00FF00D84CF900EC4289608B0000FF00BE9D6EB3F97D727E079283953D79004CAE
6C935F838E30846177958C787E9978E46561F046D500FF31FFDB7680659EC45751878382
5C367C6E9675935EFF00FFFF5F44819671686A56
FFFF7CFFFFFF00FFFFFFFFFFFFFFFFFF0000FF00FF00FF6A5AFF00FF00FF00FFCB41C27C
CA00FF00FF009F83A394CA824393BB0000FF00FF73A6728BA35C704B7B7373A3EE193D99
78808282885A757A935E91787AB4466BA442F100A700FF3D1307997B6986A4876E838CB5
67906D8C75807F50FF00FFFF7E6CA36D6E978B7E
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00900000FF0EFF1415052DFF00FF00FF00F717A0
C0C800FF0000777A607847D44A69B30000FF00A691896CE2975381947F838C2DB411D661
9264735284857895CE5766A76AC3B73FAB263B8D43D9448B409C69AD8051898B6864AFC8
5776727184867D69FF00FFFFA27A978A5C7A867C
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF0093EFFF00BDFF3373FF004FB291A3
41FAA8685A6000C8A8D869639A5A9B0000FF00BA579C799CE9A300C77F93798C67BE5A6D
6DC66F3FD47F918764B26A888999875F985390758B818C78B7115E51888C7E3F7AC16D50
71A643A15F8F7866EE00FFFF7A598F7F7CA07479
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0041C500FF00FF00A466AC62FF3500FF71643A5B
FF00935D7B817E696D931B9D40E3B70000FF00D15BAF8396A033FF005D8F867B7C73757A
6E7C95AD42519D5FBB2D899D98815F864DCD2F65A186987093648285765B7B6D75A0DF00
976C54958F10934EFF00FFFF8C68606158AE76AF
FFFFFFFFFF00EEFFFFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFDC9F5200FF00E800FF2D
5088688A7BCE479A0BEF6B87A139B80000FF00B04D6932A400D5DA008C6B8A7145A4B340
FF0000EF0970727E864AA1AA54B683709163A482966B9B776B749960725A31C37E4C3359
72B2A05EB96F8669FF00FFFF7E509285968C8537
FFFFFFFF00FF2AFFFFFFFFFFFFFFFFFF00FFFF00FF000000FF00A57E00FF00FFFF00E071
866682716E9733C37A859B543C40A50000FF0087927C8300FF00FF005AD56685AA7F7A3A
B9009E41D4266B994C72727B638071A3897B997170655F9A6FD384BF4A8E1E81B52D666E
885951B04A9B7C62FF00FFFF475F6B4FA567818D
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FFFF00FFA86CCD00FF005F00BA66
82FA902BFF00DDC000CF8B54518C930000FF00D83C81DF8241FF00CA73B37DC66994908F
78AD8C832C774C567A8B7B807B7481884EB589B0767D5D965A4066B57F00FF838B5F7F6C
8E4C5085837A806CD600FFFF9C87A870757E8C7A
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00E500FF00FF00FF6D0000FF00FF7B8CFF00AF
631D77AE00FF3106DA5F7A8F9976A80000FF0E7E81A82AC25C76A69B937F91956CCE9E61
8D4B847B897A74899B7554A028C86085973D5F7D74919E743C4C0D3C965B867A82858284
7C917F747E7E8264FB00FFFF9B6EA7359770983B
FFFFFFFFFFFFF2FFFFFFFFFFFFFFFFFF9DB8F300FF00FF00FC00FF1EFFFF00907B0AFF0F
AE205FFFFF0083AE749A75D86354B50000FF0058CD00D44A8053679774986B403DA1867D
8E5763778D7D68D91F4F58877284639B64C5A568E32163576867C2A170A381A2327A6177
7FAB4EA772887962FF00FFFF66B7A1709A766DA3
FFFFFFFFFFFF9CFFFFFFFFFFFFFFFFFF1ECBFF00FF00FF40B3FF009B00FFFFFF17590099
5C00FF00FFFF00FF511D4F67CC30960000FF00A0CDCE605569BC85AC81AEB17A45528485
D0549A797D80A5B25E043CA937C23C9875E2A15F1D8F6F00EA74809A96ECACB860998974
A8503CB85D74935FFF00FFFF617A849079897E91
2CF1CCA0FFE2FF8C4B2D0F7300009CFF864200A2B99C9D96DB2040878948A7A571996400
E031FF5C366679D5A70F9B185EC6939CA534431CA97C6D449F7064866B8789504F49B67F
826C83877E8C805E8C76948C7177A07080BA715A62AF9AA474A0718A7FC4CC48173F9A5B
BB6D7F8D5594748F657962848098A8539358746D
D0240018000F0000FFFFFFFF8F9DB8F68B6DEE1BB4AC6197FD66A52053C00E6F723E6197
00746FA6B2568E639142B1797F945DBB4E7724AA439269747B8F80AE8294973D7B5A708E
768C69946D9E678078585C7C885E9FC5606F3F996B36BA2E614E6F7884624B9761877B85
C4B88D8075838886769F8C86BB70808D579E7C62
00C7FF83DE3EFFFF000000006A000042419563FF2F1B6FA762C27BFFEE000CE353C53096
9044825F00FF469327C971658189AA82FF49754E874ED852BB66887A835D588AA2BE5A4D
92728364727358996D7A6F9E704C4AB43ABA7397A6366153A3619426899B70747DC6767F
E69D7B817E86727F75BE0B6742C4AA9D7A5A7E81
FFFF000000000000FFFFFFFFFFFFFFFFFF00FF00FF4EF198FFB200FFFFFF0000FFAC8137
170066FF00A722D95FB22D9AF39EEE0000FF4396826D99DB82ED00868E87885372537F65
9F7E6E8D617583729E81659E91323FA1A3145C914A99608592985759756C83617B8E91B5
6E5C7EA2629C6266CF51FFCF7B8C848D6C917373
0000FFFFFF00FF0000000000000000000000FF00FF9A71000029FF9F309100FF626E679A
00FFBB1BFB8A866F5BCA458CFF00A0706D7197D5853BA251FF009FFF997E768B858E4A81
78637B6752F54C9F707F8B948357D503FF28CA61AE5E76784D887B818E82846C7583B768
972900787484669768934F828472676B74D75296
FFE5006F00FF00FFFFFFFFAEFFFFFFFF00FF00FF516D85FFFF57003AFFFFFF0073B6FF0E
E739814A84067AC41CD34EFF7A29B13D7FCF5ABF68A542C100FF0074738B729A5289A14D
CFB262974EA98070938FA93B4E6462875B8F528460A0568099657B6B8E96A16297629877
A06B598C966483837A85845E71A16D6A59399580
930FFF00FF00FFA20000FFFF0000FF64FF00FF00FF00FF000000FF21A965000000FF00AE
6C869373A30BFF00FF00FF00F25D76632185491497789FDF00FF00FF73917BA1B1A2A74D
852460B451F4DF40F700A56B7A6D898A93626E7872777B7C848954C56C8150B9689C5978
B56D7F65955A80857E66A4816F547090735D9199
5B8300FF00FF00FFFF000000FFFF5EFF2BFF9000FF6E1300FFFF8E49D600FFFFFF00DE86
99835F59B400FF00FF008096B84F8E0B00FF46D1A79B6300FF00FF3E05C8636FB146677C
6216D528E27418CC2FD76F8E718F7D93627746977E6A834E9A2F3DAB321D4D835DCD759E
73BDC08A5A867B7A9049FF988E447371A1FCC278
FF00FF05FF03AC2D00FFFFFF0000FFCBE133A6AF6A5444FF000066CDC2FF0100FF0051A8
78E564BF00FF00FF0CA7716E7C89788F764E937B707F3AE516FD1E06907384917197748B
6FB1889D585A37D500AF7082765A88825EA75C508D7EB04ADCE09579AFA2877F7E85817D
816E7B77867A7F7F7C7F6F7C4E6B6A696A5A7D64
FFFF0F4F8FFF7496FF692A00C6AE94F33EB85A86674564A2FFFFAC541F00C68B38FF0030
A0706C0CFF37111BDD8A94686474846A6FB57846D84C64FF8800CA7844657F7286BE5396
653E91878068C3708C8973A8C73DBB776E53AC78E057A75E44FA2095778D53995A7D6275
876D8C9276827B7E8177978C78798D828B9B837C
610D0073005447656B80D9D99C9FA16EA1B6838D609E007D8000009AFFFD19E9774FFF00
76B15FFF0000EB9CEA6A9E71FD847C73A2913A9655539EB68924857E747D896EA09C8C5D
A760697A85848D288C697A825D5B6F799C55868400FF7A8E46E8AB5F8E7E45B4597B757F
A1653453927E847E80537AC375A97074A8608E25
C6E668FFC0286B22614395D100813EFF33D3EC37A98DD8CB009DFF210033FFFF324F80FF
00FF1800FFC72EFF134196A74EA191753F06C390AC767F8E9BD4435492637A6BA8BB57A8
806F65828C445084B8B4A65F683FC39AA79059A384277A38B653966751F9A7757058898D
43AE6D2C949B578A778A7F2DB148688F7E955D7D
38FF0000899788B6AB5E0D0098BD8996618578A17FB291D1DDCC0074E9DE3B67B5469254
FD00FFFE0026C12885908E664739787C248955F15DF034A84A2AAE428D9A88487B84837A
B3759B679D4B966E806C6F7087307C6DD0126571789755AB67AC7D5984877F7E7C886663
8DA98650586E727E836B60867F769C6E7C9B7D8E
8F71FFE100687B7A91A7B628583D56318D95919B1200ED84AA6DFFA12800C41251B83B15
44FC00E9EB4D7B628522FF6980897F9FBD8B4433A4846764DC8057ACB361498D87817472
6D9679706DC6509265E9B289B078816A71ED7C6CC500AB62568E747A727F7F758E2B6D42
7E96788388817E80769D4D5A886F7DA97D5274C3
006DF81FFF91835DA064A51F12626265901A6B5C5E6407DB2C000D2DBBBE9BFF495099E2
2D78FF000A7482B539FF006C55857A656C5AA539008B7D8B928C9C61A5009272916A8C7B
7489838A8E9753759E3BD6975D9236BB507B3BC900FF42B08B49828A7B8D6D9B8AFF27F4
49F56E9872807E7E8362708B7780BB808D37C157
A8516551004B755E372F0064F3833059A5806EADB700BE91A7C8978D4F687E008B020ED5
8AB100FFC17D9A5A4C6BBE9D3669946EC0469B3ACCB950BE77A37584697B81699DA04E7B
7A96708177698D9A5D5E9356B232166282210D68FA0DD37B2499917885A66755DD35823C
8F8B8E4F96737A7B7885545C5B8F77B065857F7A
8E0057807C7D7A9DB395C7C9E8FFC121917B8464917096786F9C75CF83B6DA8CC68D90C2
7EB1788B4A09796B80797B96827D7E7B6C6A77605E529B4366A85D989C78937D5972939A
878076936DB78789A5796B7FA680537383BF80A839FF74B99F48867F93887E78887F8281
768F7C7B7E7E7E7E7F7C8C7E7253843D8286849D
50B8A265929D7E54866D998F00759F9C3D9269B1526D7FDEB359C488BCA2584DBE5729B4
838659F7F0689769B488A06584817F829F756E8957907ACA737487545190786BA6956971
878789905B8B59503D739992839389847B679D6ACA675A938C957D8B757772A1787A7982
7F6CAE807F7D7E7E7D806CABA37F8153E2957782
66902F7F697E78C37E81D3859E88FF459787A66E49BE146EAD7B8E6B77883B5F6694E639
95D7435F2E79805F775F73689E7A7CA694998E7A76728E7DA53E90755E91796C9753586E
516E7E7F7E798C45928A6C833ABD835BA66A52AA5EC4979177738151935CBE6B7C8ABBAB
83876B6F807C7F7F779F7AAC4E857C986F838178
48B58000EA7F6AA7A17CD8766F7D4881D56FC2B183ADDA4C736E8B8D6F190064776F3A35
6F7BC5A9C578700051D78C7A688677AD670B567273F5624C8DA2677D7FAB79CC405F6986
4F897A817C7C7A708175B56B6E01AA8D85529B99830987795C775A84772C696B8692647B
776691868083788076899B9934916C475B837659
839B47FF6F71A480437AFB846D69B5C1444D554A73BA08AF74C35A62D277FFFF997C89F4
53B453C2279786FF736785A1716F907B556D9F8E6F9CCE314DB292906BAA5F9874938A88
91A19B787C8B82C9777F6A7497BC69669992D171908A6595636B927E76C07D976BA17987
60A37F817476847283A76C687E7A7F78877D8797
8F6C894E568FA27B765C3FD26AB7B22691AC48A87250E05F5A004C8340882FA49E9D4338
5361534AA96BBB9FCE746565AEC36D81AB6A73635C894483C67D635B87589367B5766468
5B4C648284686468BA5F849041698F4BA190786D848C519F8F8E6CA7419A3A8D829E7A76
B75981D064A48E847B86639A8EAF7F7E7E699985
76D593A4996F77A1A79E69548756BCFF6C8386377E9E57858374C43EA6B1A38F62907D7C
915D49C76B8A4B866F7B6EA3626A777BA57E9E6392977BBC19889D9F45A4769693859B36
9E64887F6EA27E7354A44D8388C46EAD91AD9A768BD17C90636E70597B9B807C7C778C8D
6A77855E72796B857A8D95787774748C697B757F
4468D29D4B68857C756B788BA5A44C76B279838F938B892C788786677FC1877880837E68
5265827E71737D7192808D6191887D7F64834A4875519197D891631B6086729A9A69687B
677B7F70B0545C848F855D568651C4649804778A6B1E62789D0088937F537E7D7F7E7183
607C7B8D857F827D7F76717F807E959474767D68
BDB0AE519973836098B28E678E7A4DA381776B7D887476705E70B0ADC062A778758F536E
848378768956709A779362977A7A80718E80549E83A43FBB64819B7A9682A38299688161
8A7B7D8B7597977E8296759D8F926E5C5873808692A986816FA976828785827F778C8584
947482787C7D7D7E8073536283749E92768B6495
6F5D008F42588281686C6DAC6394B16F5F6685788DB77671B4955CA9988B3E779F88AE64
9305829E358093817261759F62857B818086A79EB11E90785892486970A965797F77A480
5D7E875867717E758483AB7194B058846A9EBA423AA06CAB7A7B7D6B7B9E79807E338F97
56B77A837D7F7E7E7D8392827E8652637D9B716D
9466D479CFBB72978A4A9B355ABA9C6856908381659372B2A45C948B646AA86B9BC56877
8CA9A16F8E40986395518074877D7E8F9561876469B8826C907D9379AA84757E7D7FA674
933F887681788160A37B538181B298A2A7AA60A24B1C7161A3597C7F7D70807B6D808A6B
B0697D7B7F7E7E7F799392757C7BB57D86668C93
60879764FF93817625AB499184793868774396975A7C60617CAC904D568E77FF85438A5C
A465A1C25E71918F748A00A05D8B78938B98767B84946D9E6E8C668A72C578738E7D7B81
81AB797F7A748E90627C92A54B798E737AB0FF3F947296937950827B7D91737988C16479
579382787E7E7E7F7A9089788D7B59937B7C8CC3
857D7F6600847E986B387423945788B493AB817EC373D2608086008072725400792067CC
5CA17B9C71728623CF00FF158C867B7A4681638D829B8A977C77868197AD618B5EA08D7B
8067817D7F817E8B7459A58237C381826E4F7A657F7B868C88707D7A8A2693698A408AAD
ACA97055807C807D82769461688189857B9BA863
68909D1ABF7475ABAC7681A19A6FA7786DD17A6B61746DA8A28190809E9F72C57F8623FF
634C9937A9738F812BD60057D9608F746C9E2CAE6B94725D64A28D79AC7D8462865B3988
7497677B7C847E758B6C763BC6427D95699BB0923E5D868B468F887D829942A9CDBB659E
7846559288847C7F7C7A8331926FB8A846997579
647B63BA3AA0FF5C6D87635E707C6ED8847A5C90CC6AB16F656296AE20535F886E83AA00
818D837C7F755C548A1E9F6A68D248B6A3926B9199A5AC50946FB1895EA16F8F5D988378
807C696183AC7A86778B7B95894C99987FACA6637A433383C9565C82744B8E57512D6F58
8BA1A4825D9884739A8660767B6F735D9D8F61BF
9BA9628E4D5D578861877471C8EF5159883DB273647D65B2348C897285729154828CA292
5B357482957D77AB829A6ED66D35C2339A6665354B836053AE7043619777B8977A765B63
8772B19F7C517C648081668A7D817E7AB01A601E49A52784166D78837DB48F6BD06E8990
6C444E7B9B655E5EA963857B81AE08AD7F6F4C9D
805DA778B29967A3817DCFD36B57955764779A9376996F73797758565CA390677C81834B
835E6A7EBF93657A5EAA7C59788B7AAE686F6C9E844A7E583C82ADAA81789EA6B5A49EA8
73856BA75DAB938A7C8B897A855A4873816A69A263519C40986D96877F74828679877A76
777A7C8177807D8574987576C25F886DD18D759F
8E941B72FFAD7F59957C60A794CF7E9F638864C2CA7E839584BB95A160024AC87D9E8B8F
646A4C42926567969C5DBB938178857A991BB8766BA9AA807E767AA47CA7BB618F2D958C
7B7F8179799889946CB5997A7E7E9D9A777398958668AE8F5C8D89A8779F8D706A997C9B
935D7E7C817D7C7C807F696F5F4D6CDCA1807C8F
717AB1A1B292B1665B49504B26E0A80A8A8A67643D519771C7574D79B5FFCE435C708C60
A39AA4EAAF443C8977508566797A777B34595780609286708F8883BA82795DA675726A5D
7E807F8277A0749179597D79837B849E849597795AE55BC084C85869755C8E7390467E8A
979E7A7F7D7C817F7D719844C2689280B6A98577
FFE7000000000000FFFFFFFFFFFFFFFFE222FF00E48A67D580A5983D55110E58A04F607C
5A95410C00D17669B77C9691907D8B583BC242688182462F46785E7C7F74587FAF8C649E
559D8C5C7B7E9370846B60A574AC0E6AA85E78986E00976D9026B4A77C9682A266974D5C
A769847E7E7D7D798772CF8F457CB49575A37B7F
FFFF000000000000FFFFFFFFFFFFFFFF60FF0000FF35D868CD7A7AC7FCF433AF7A9F6195
B0C92AD40055526D55A2618777006B0000FF429184869DACBFA549CD7B868768818EAD80
4F7B79988EA8907A90737B86758F91747A8E5C6561B0899D68C1648D89817C89868E8B9C
6DAB79709940B07F7900FFD2749387866558857C
0000FFFFFFFFFFFF00000000000000009600FFFF00DA56874E50895B82AFCC419D6B9D4D
4C098D85D55D736A97847172FF00FF00FF00B88B7A5C92B336B9906491787B924E86437E
7271684F7E3F8C8D6D6C837E995250D139AA7F8476977E896D7165939A827C6890907C9C
719B7F8D9E4B809850BA002D927B7A7A7EAA6A7A
DFFF00002E000000FFFFFFFFFFFFB1C3FFFFFF00A3A88167B6E2697D5489006C41721670
8D8061BB64B4AA5CACBF36DF00D2987A1F9F6D6C869981A682B64EAF7D96817F6C8B6D50
75845D9D4585907B8C95A04F987DB48593476879738E76847EA9B6979C64706473C87289
A5868E4C80798F70A782C881816E83857A547C79
8717C9BCD8F791FF63731800221D6A8E6F0000C097BA79DE42727D7DCC60B9A24B66A38A
4D3363A363846F8A899D0CFF00FF00BB7D7784C5981396217D675C63A2617977A3558180
8E298DA37246A2669E737D7B747463C78FAF6292978A8B7CA77A6D76797A83878191847D
8575AD7D73EC84758D6184827C7B747873B5528C
A01E1DCD977D5B57935B001EFFEB7D1B68FFA97E43668F00FF664A3AFF971F00AC875F39
C4DB6B5F7BC3A24CED13FF00FF269D9299CBACB28E689D67B54A45878A6E8A77827C8F9C
5898A1A5A59B6F8E5AC64876BA4B5AA859A7697FA17E819373AE8E87729048576FC24F95
6D1E308E767D7B82759967785EAA5E606789685E
FFED4483FFD3FFA169D9FFFFFF36B44DA40FA8F44800FF978500FF626940EDEAECD77BC7
5D9D78B25D30905F00FF00FF60A179A468B6163A9F60995E27FF005E916969AA79737375
AC5CA08A968F6A7EA0B5A69C7EF3798C739676769974887ABE49707A754C5F44A089913E
9597945EAD7B819059CC5B6B7599846981397B6A
8EFF16AD80C15900FF00000000FF4C7FBFE04EFF00FF00FF0DFF47813C7E4DD2FF009960
7F6061798982528CFF00FF71A4827363AE66A35D4CA48B848D00FF00809978518F52A291
9CA5F821C32677B95782646C7F987A7A7F6CA5837E7678896B9F899586B070AB6E526275
4F8A6E8E5377828A738D55759897494DA21C569C
004E2CA6868741C300FF000000005F7E003FCF0000FF1FFFFFFF4FAF62B2C6008400DE8F
598B6B926265C15B00F800636CE4677E046595AC44869EC900FF00FFA57F9D5666907263
7E74715CC4978D8071C06295648281837687817F806A8A8B7072A480708B7E707E9B817E
54AB745AB882857A846DCB60705867679460526E
FF4A7A9FA98E3BFFFF00E7FF4527AB23EB777900FF008800D69D6B7EC5BEFAAFFF32B563
A5499AA20CFF507CFF227A759663903EFF0AA139D23B894DD000FF004F4C804A765DA38D
5E35766E8B006B7ED5387D6C7D677A7E6E838B799C7DAE766298A16B61D3794E6EB67257
A4818984717D7D7E7F7B81464E2F6397918A7345
E6568AB03C7CA40000BF9C00BA9C57903A984FFF398A67FF8261E8588D831C470078808D
7D909184722DFF98619590997D857CA2A91F6B7A6981A68F5BF73FFF5EAC9FA08760768D
8AAF84AA2FEA4EC962BD5E848199817A78814F6D808B729073718E54A26491659C478261
82818579847E7E7F798E407D767B7CA8806DBEC9
74A16983898A6CDCFFFFFFA86E86A264977F8E2DDF847B712C66C1152D9D6984FF58658B
794DB265F3E600BA7C7A778589797F6B477A448A6B5998453E801C849C548B72609BA86F
76747169A591A32D3DC2679C53B179817D6477788788AE86545F5E865396797F778B7D82
7C89887D7C7E7E7D8173A96187A89E9B8B834E2E
63AA475A78817B7C0C595A554C302ECF757C8477913C926C94B92D69B1897F7FA6A85A88
85637D8AA33CFF14858084797B807D81827F745242C1756FAF8B5751806C94697C8CA472
82B76C61928F65465B9BB3789A6086758B5F6AA37598CB7CBA4F848195638C827F787E7C
7F797E7F7F7E7E7E7E7F7B9C98738259B7966883
BB98799C175084B2D5615D0009DBC070AC3C905645858AFF00B8688782847C822EABAFB3
869A6B9B2D952B682AE41B788E9C7792C768B75F7D7E39B01595ECC387656176768EA254
B85CD03AAC62986F738D9D67855B8086758F7F7D986FAAA5946F66626C63898B7F97C690
6D9083708F6D817982745F55866F7A8F82AC7168
2F267275D2B2A24F7C00FFFFC940B90A5CAA57702179BB00E75A959BA8597ED7D45B8789
75B09164829E7499385EB26B68816F6569707B4894816C88761F5B548085846B7B87A7A6
6C81ABC925AF7B6B6F93887C9073817C789F647B777E87816691818682847C78B08A9185
84604B8780C678974C54967F866D6882866A79AA
A4758EB37DA8787C79FF00000032819984969E52A2902FE927E0806E87AA702122777B6E
6F807E867ECC5C816C895E3E77728160CF4C54D358A281925A8ED2C5716B81749C65857F
89ABB499AB879C7AA6A6866145B676837C7E7B7D80807A855F84836B79737F615C775887
686E49828375808E67975B9D79597B5872E5D384
82D762915A19776B6D7AFFDCFFFF924ADF5F6C6900915DFF45DC777B5E8F7567F01A5BAF
7D7C6C876E598764585C858F8AA870887480887CA75487705ACC2323A8475AA748A13A71
AD877F459B76B6584F98A76C4952877A7F7C90807E7B818A7E48977A90A484A9A0649772
5965887F6E907F7B8277877C6C7A8D7593296187
DBCB50C7C0653AAC8777113810002ED3409A5F50FFE16F54773B8A65DD983A30008D4AA9
848680B34E0E51A5447180658BAA787BA74692984CACAB6F8D5E9999577AA978BB8F9B8C
4C9A67B76F627EA86BF76A897064857C807E707F75A087A89B77764DBE627A956D755051
634F78748889827F7C8370928F62938362C54E8A
1888488F1E92A455AA838436CBDEC47976607D8F00856DFF58FF74CE506ABE8FCC87A78B
49B0737E7C90617766946FA4888D7B8184953F8DACA68A99257D9F395C9F9D61BB9F4BB2
B6758D3CB0728D8C8B228E79737985636EA0817D83758374799364A6AB9A52528A819483
746F88708E767F7D7E7E7B7C889350718D7D976C
8D9E6CD2C0637E82BD7295D92E6DA24A7B6C6472FF785700DA8565298C7F474D2A789184
8E9D818583896EA3D36682787287807DBE5297506B7E8A51ECB2C0C0AA787E57826B9489
92BE54E46CC46F767B677E836C7C7A6299717C7F66C96093AA4882A99CA2496E9772788D
B66A6D7E817E7E7E7C875970B54874988381575B
2674A05620897C7C35337670FFCEB0816D868C9D4B4180FF0312B4768BB763D07E747A7C
76A28F6761958CA89ABF9D747C7D7C805FCE4DC65E6C7994283C56697D6E90858BC7816B
5E23AD5388655D4D4F75767B847F7F818C8B90756F798E8552896F918171527FA5478B9B
767C7C7F7D7E7E7E7F7A8C7D509A8486A4A38C87
D263BCA13C80779ACD8F8B546436742565857A72B35B7AC68155AB8099A8717409834E96
75A49A878AA98E989D7E90857C7E7F79829A528972764BD78D894DABCB8E73CE8599637F
7F6FA3835E8F458A6E7793A66C937E806FA9B07884807C9B06C9AD7A86968461945C8062
887A7D7E7E7E7E7E7E7D807D937C8944A3708E94
257591C47E737D847887419C8C6C68917073887359B3861B825E28B9887318A15E826F18
9733E2728C749A71727F7B6B6F817C7D7BB77C7E8A9B9B995A537E9348953F9E9B88947A
845E7B3A4D7D6348A457996FB1487A74A575724E8B79877694876FC35865798678867E85
7F6E6C827D7E7E7E7F7C8683499E5FAA3D509C80
F0836A5C80817B8E9A6A9AA1947CA688837F72579F527A5FC163937DCC72C776A67B7D8B
6F406A8777A677728F7A8083827D817AAD6474A8938B7472C45861938D85887E8266A785
8D586C7E775D73BC738477807A848274A6608995767F558C3E8F7D74A677817A807B7E7B
7E82837D7E7E7E7E7D817393564547BBA06E8F9A
4E7FDF947C7D826C4378158A868781787D7E90B33C618395648F8A562B9C6C78785C8C6F
8855B57D5D27C68C74817D7C7C7F7A854CCEA4658AA3AD9E7F59669AAA5579934D7CA0B3
7A83B96B7546878E7B67837E7F7F7D7D826B7A8185A9355F84877B997E7B7F7F7D7F7E7F
7E7C7C7E7E7E7E7E7F7A908F688B58A16B7C4B86
8C2D599A73817F746B9AAD9C978FFCB37A8079766890859A9292739687C3428E8856B3A1
9099B85C8282A45989807F7E7F7E7F7B8B795B76858C4288A07D7A6F4B66935B63ACD068
86557D6C478F63926A698B54B02B897B7B95598985655E757F826F837428917D807D7E7E
7E7E7F7E7E7E7E7E7D806E306A64A6C5B13F6A83
88BDBB66867C7F794445598A193E487E837D7E88AB577C3F49625C8B8C8AB86F66655C8A
798869808B98608C837D7E7F7E7E7D827E517B9F8F54948A824DA6A97A7EC37E83777284
837C766A73785F648391848880837B7D7D82807F7970A897577376B06A7B7D7D7E7E7E7E
7E7F7E7E7E7E7E7E7E7E83A134378A91A66B7C37
6FB08A897B7C7F83C28D877677B151847B7E8098898D817E9C699974A85165879983A05F
8282BCA5689CB9717B7D7E7B7C7E7D7B58846A82A09C6B80848078847E7E5A7E81838076
7B827E7D7E8FA3923E4D93706B7B838278919F6385B77E4B91B7A5A9767C7E7F7D7E7E7E
7F7B7B7F7E7E7E7E7F7A89467AAC789CB469BC7A
A78975807E8A7F74816F8D6C883855B083897082A57680685E988E4E968B7A7C597F5B4E
C05F882BB53783877F7F7F8B8B7C817F9F7E9A9B914590A06A857A5D9760668B458F87C4
88827C807F65898E83B1A3A3AE77625590667C8957714A5D9E4D8A7B7C7D7E7F7F7E7E80
7A8C917A7F7E7E7E7D836578D0657DA864734964
3D7E6482778C749D665186921D44D164918C803F8B639465BB689F999E7A6C88BE618E94
93C45F8AA3AB7582757E7694A77C80787609897D5E858064719BB0B48081827E7E758577
954BA6639263746284D56FC28391B283565C8C76C3456E646B7F86807E7E7E797D7F7D7C
78A2C472837C7E7E7F7A93A979946E64A98A6F8B
885FA76C8272846EA877637CA67D53785F707FC29887ACB358AC83776F459173658C385B
83807380A06F82798A8FA2AB6A837B85699D5491758875896C3B8C9C9B7C808D65947FA1
5E86746F967785A3A3855A837B807B78897A7D8293A0558846627D7A7F7D808EB0798298
5D88727F7D7E7E7E7E7F80705F8E876A4B6C8573
7C6A40AB8D7378838090697A65888E827B8A7A5B725A985F815E72B091A59E7E7C8F887A
726D9185904CA88D63938068A27C826F7C7A6D7D8D897A6EBCB36E77877780856F91655F
67858382787E7E4F737E714F9A8F7C93608F4F6A8B696B8F67978D6C827F6A7A718059A0
7D826E6A837C7F7D807782629ABB76808E847991
56D28E6050847F917D6CB65A79838773677D92B695A48D6B727CABA79D775E3E79599174
B97A70C0B65C655146AF728C6C8179A58C7281847EA66D684A927D817F9281986E8D6E89
9F7E7F7C807E7F879180A63EC272A7629C31815D9C946183A974638384557D756D845868
7F7B86877C7F7D8077996161A5578475987A7F7E
8CCC5394D565874A857582419A7883909E816497ACA4C947906461868B89CBB2816FA46E
8175939CF37D84F38578A16F9F7B8265675892657E9B446C92737A7C798B8A9B95536C80
52807C7F7D7E7E787F8087455D356A7E7D696D9B75537876776269CD50F9796E81517F7F
7F836B6B827C7F7D83698B916944857265847B88
47A6A29A477C7A8B818DA283707F7B656180826E637E7E8D768F9675A357485F7C81493F
6AA170AB85AB391E6661708F7C7F7F7C8492729171AAB78D788A7E807999526DB985867E
8E81817D7E7E7E837F7A919BA1728B7F916CAC74876B7E479B8666889632818F7F6D8C7F
7A7D7D7C7E7E7E7E7D8AC187526C7F61897A8160
AC573AD89E79738081795C79A96A70AB727E84559169705F938594977FB2E29A876C7767
8F9C6A89B35A68AA6F83876B727F818A7F84AC7D85606EBE8952827F8567919E97628278
6F6F76807D7F7C9F7A808174B3615B9687849F90915F3B5C89848075CCAC746B7B7B7B7B
8DB0767D7F7E7D807B9F7595898E9F60837C7D77
6AA583806B7337569066A27A9172604C6DA6B5846F926A7F91A27D4F7C5D4A6C5B6F4B88
667E919F39BF7A2366906A8181838F809287757D9597953C788F8B7D7D8F7073797E8581
788B8E7A807C845D9A74B760715A86A3AA799385977475879F668867659885757C9E7E7F
8377725E8E856E797D66837F7F857C847D806E6D
AF8F8BBD578092767D6774A2999DA9867B8F3B97786A985984326C477D9960BEAB7B3931
377F713DB2759F84AF736880AA9C3887956A945D6F846026A18E7F777E7F855969747A74
7484847D7E817B7A4765798086796B478C87959E3FCA689F8C7A7C9197B950927CA37B7D
9E617EBD7A7CA6A4748D678C815E827985699185
8771775F867C797E77877B92558A5DA57F7F977C7C84879A71A2947489A56365A29C7C7D
8996726AA86A86456586827F6E739E7E799C7D87838688A6737F729A797E7C855C98717C
775A718278978CB67C6E8675AB464C7653AE8E64859667887C7F7D746165967C7E757F7F
75857F687A8CAA748279847D6B68827E7B84787C
A287839377888F767A7A767BA17E93927B747988816E74518C738B7170686E877D887278
4F65738E5D7A9399837C7F7A9196777F7A727E7F7F6D7998907F827494B576834F927799
6E587E7D8170797686805D836F7699669A917065809484957B867E938C83777F7E817D7C
837E7A968E7D7B807D7E7B7F86847D7C847D817D
8E676776828E7598955F7192836E6F757B807F547B80906C74656B8479718A7D74718B48
38969B7576A18D6D7F7D7A607F7C827A9494869B5A807B647E8F7B859F7582706F7C7E5C
7E847E7F7EA17B84797EAA719D71A76F955BC547959F797E799B49937F78807E7E7C817E
8C92797F807D807D7E807F76717A7C8B498F8077
6BCBA7A249677F788E8C837D96694179A9836F44816681667972658778D58674516F7B7E
85BD987A7C6861718C83AC68867A8156509B6470978D72709F787D55887D81716E8977B0
6D7B7E7A9388667DC2553B767E889491C5507FA7808C7477B26A728D7B617F7D7D865D6A
6D7C7E7F7E7E7D7C86595F46807A8249717E7992
92668E6F8A81806D747F7D8177817C6D757E70777F7B877F8B8482785F57927A92807485
71828B866B6E927F7C7D7B847C7D80728E8096877E8481915A7F7BA0857C7F815069938B
7E817C8366478D7A7A888A82809C80BC368ABEC45C567480746D7F797F867E7E7E7E807C
857E7E7D7E7E7E7E7F7EA37E7F807072847D7C82
8A755C8B76817A977082876B8183907A807F93867B677B777F8078A3678A68827A74B07A
647EA3A369A9747D7E7E84797F7F7C9C8678927494928C968B7D7C7193787981536E7A81
7E7D7F7C887F797D835B74AE6C6D896561528C6A9B877C7F8E7E827E7D7A7E7E7E7F7B7C
7B7D7E7E7E7E7E7F7A86216F7E81726F817C8093
686F6C7A6B747D8C7B78717A83799264837A8A7D818990787D815D9484737A71837B844D
6CA66F8469857B867C7F95887C7F7C86717C867F5E755F568C8A7D7F71878F9F628D6E4D
847B7F7D757B867D7D7B83729581848B95706F4061AB7A867B867D7D80847E7E7C7E6E6D
83807F7E7E7E7E7E7E7D69877B807879826E457D
8D0A3FC365B96FA16B9A86AB719F896A46A08B8D919C9363D59B66B9166F5A8A95697C6E
97427E51876BB7328A568551847C7D9BA17C97AAC6778A814F9348A49456857A85749571
7E7D846AA972507D7D7A787F8D97677568617F7E6688786A873D82666985757F85719084
5071797F7E7E7E8077A0A47380816D6E79A154A0
82ABA2715E9A797F80787F718287897268927980705B8A945C7D915CB7819085739D8E9B
757C895F6474788386C16C738A7C7F7D7B7B79696C5F848C88749A8B94889F7E7D835682
797A7994917C7E7C7F90917D6A6B8A8395AEA37E8D856A917C847D837F787D87567D7E79
8C5F807C7F7E7E7E7E7C7B7F7E7D8682816F8B78
846775828B64827E6D9792908E5F7395A46F826D97BE7E5A85A283975F787A95755B836A
6F6C86876296897C7799AE8D7D7F7E7B7E7484A77C94746164906F829E7E35827E78BA78
C08E7E787A807C8F6586827B88627D57A74FA1618D6F6B886B4F85797E7F7E7F8098A17A
6779817D7E7E7E7E7E7C7C7E7F7C9C7B7A956E78
5A837C826C68808B7D7C6D89945B6B6663698C8D7C897E7F75527E6A9F977E686076856A
70888F7C9291887E908195BF6E847A8F8D8279806D4C7D827B719174655674817E7F737E
7B627F7F818E68847D7DA37E7D66767336736C90875B877E6D51857C7F7E7C834B6E9994
7D7E837D7E7E7E7F7A90907A807E74807D7E8370
AA9D8694519A768D3DA28A7A8B5777B86C9D8E8D58516A857ED56B6886928C2078428EA2
998BB3658E699074931CA04A85797E918A9567809FC06A7E7B7F7C8BAA9D817F7D7D827D
82787F7D7D7A879C518E686E987F628A3AE5F22AE36A7C77875E807C7E7E7F7B767E9A5F
B09776827D7E7E7F7A92927C9177737F7C817184
835C6D6B8D9D7A7D847F79707F7889655F82767E967487797B8E9D8388796EA078989991
789171799B8A6F7E7FAA588C81817E7A77768477617981877D7F7D7F767B7A7C7F827D7E
7C827E7E7E807C8177956763A37C7B7D7C673FB169926A747DA57B807E7A7B7F6F617656
7D5D82747F7D7E7E7F797A7A758180837F7B9886
A0B17F7A5C777688725D96999689A6A56D947E7CA061939A96635788647D75428886275F
896AB388728383665D567B6C8071817E918F56B6677C6C35856799747D5D959A5B797A7D
833F837B807D7D6E985A6975876D7B7B8AAA96866B5588668171807C83729C8E846C6C7D
929C78A17A807D7E7D817993927782497A8E6285
5A898C779C6A8968737756867984755D9466757F766F5A827C6B6B6F5F54729E818FD76A
8D736E61519C73645EA3709C5E7F7D81A275A46B6F7B788C79827D7D7753927C807B7A7F
7D847C7E7E7F7D7C7E8D599A7F6E5470838E678984E273407F7F807B854C9A9C79907CA5
5B7F909579807D7E7D826A8581826C6B86686883
5E5E7E754C6073768569A59E7778AD917A9F829C7B577D9374A17378927D7B657B782EDB
445F8A4B6F7C80666E8A3881BD6C837E7B735FA87E7574228A727D7E628A7B78A7517081
7F76837F7E7C7E7D8172AA9E8136C2AD627FA584686A6689837D7E7C8361725B9D84609B
C8616A84837C7E7E7D7E82A37B7B929B6494847D
76779155C09D8B9A6F75628A997883A3656F835F8A968A9A8B706D847F6874957E788F70
70886EAD8E787C7E56958599678E7781628A9F727674819277978D7B62847B7B74886381
77946C787E867D7F7E7D77615DA44E7E8186757A9FB58E7A627F7A7F7E8F717E8D80886D
907F887C7A827E7E83798E747A83655C8A767E71
698F6E6F797D64528B6BA2809086AE92AD068E8D70838D8781A285678C8E6EA2869C9A7F
8363B64F816771855C7876816D7D816AA17B76998854857C7A816077956E86BE91787A80
7E7C8E907B5F807E77A2AD6E6C727A7C7D618F679582827F78706D827E847D6C755E6ABE
61AC8786716C7D7F6A876763857B8996AB7A8699
A2549F8AAB767A94677746915F675F6A877F7A6E7995588DAF67A1906F6593A28981A77C
5A7E44ADB2A98D718DA472887F75916E7670918B6E50887F7F8565819C6896836483797A
7F7D8592776A827C7E8162917E84909083708C708C7391778D8C98778063808283988790
7375797B847F79795F7E83857D80957B7A804F4F
956E586179B23C835F5D7FA2AACC5280874295965E723A7F328B8D744F76A8478184AE68
8E58670F81965EBA7C9B7E6A79269B4B997650719196658658757C6E3987386E397D8D91
7A7C897486727B817C86688F807D8181624F7B49987E2E8054667B819C498667B36E7F76
909A5D7B964F85AB9A71797D7F8A76B7776F6DBE
729C78A17879917A8686886580658B768697748F7190CA7F96737B88969F83A07B7E7180
7CB867AE7B7E807F9A737BA2908A5B8E74A6787C615A9C41757F69877F868D3574BA7885
7C7D8999738380797F7B83797F79768661A99568A04E7877AB81837D7A72917E73807F83
707D9C797C80939170857C836D626C748DBE4C27
70AC836EC090729C72AF9697966F699983719EA9AF7D738B54929177727876A37E68828D
915871636E897F8A79B3A963757A8498788D797D79B06F636877717AB477627F8C828A8F
7B7D855C91AB6FC178807981799396778A5E6576869E7360717D797B7F877E7E78A3607E
3E8073817F7C787C7D8F717AA3978B799B59A383
825A7A8A90868074717A3F7E658670807684757591AC5E92AF7D736F6A9E7D7F976D6F72
508B9668BC6E697A7E7D7C8481807B788385655B68883F5E9C816081727C84796F96646A
837B83678B8C937483706E81816B8399738D766C8A5D928A887B9193797E827E7D7E8180
8177827D7E7F807F7E7A7F806F9A816E7AA1C572
8C986E563E4E8D596F7A5BA984889372C27677AA926F6F87709D8683725274AA908E9779
8C7A596098436E8FC00693697D7C7F88925FAE78869A787B617C84909C81A4838C5C9A97
78807C847692907A7C8F9578807E7271837592947C54C1EB7EA27EA8749A706F566D7478
829F7A807D7E7D7E7C846B7B6E617D9E5DB8ACC7
805399797D87798C8C82915D7C725F8A677E7E678A94886F81566A80627892705E915B82
5D7D8E6975B59D7C75898F8C7A7F7E7A7160A5A8887F978381807C62758E817A79A96F74
807D7F7B8565959575B872837D78939D77847A7683797D8E7F52B26784757D7F857F7E91
9B817F7E7E7E7E7E7F7C8674947D637D7C4BC69F
98867F944970837B799A739082697693787B7F838C968F7E6E798C8090AE5E765D828081
6F998290B96576898162518F7E7F7E8085907D729F837270697C7F68847D95AD7A719393
7B7F7D7E826C9F937B7E817D7E7E825D7A8E937C7E736283768AC36E7F837C7B80605C7C
5A71817D7E7E7E7E7E807894AA7EBF5EBA7AAE73
8B7368407F606183A7999A938AAB98819D77835B997A738084425F806086A58B6BB3615A
4D707D6C9E6861975D59947B817D7E77788B556A836C7A7D727C7F6F7E7AA07883807B80
78817F7A8368588B588C7E7E8641A37A697E78807680BA6E97807A557E6A8E63A0717D78
7E7B7F7E7E7E7E7E7F7B835F85B54E2E9B967680
4E6BE1E1E3EBFFA81705002505344F06868572DB7B91898676668626869F746085449F67
73AB71599E3E8785EF518E7B7F808089AF857559888E8F75A978857B7C854672889F86AD
92777B857D82827B746E7E788296697499798670B97EA44F715FD29079874DAF83A96571
787E7E7E7D807D7E7B8B54638F763F734E697E7E
FFA6000000000000FFFFFFFFFFFFFFFF976C7900996A8E906EA37FA3896E65C27CA14C8F
796160B04599707E8CA2738382717D5A189444827E78837378BC8F9A7F7C87738F897F79
849FA645877C7F7E83806E97757B60837777A99161644C6C84877277806BB86E7B907981
9F7D7F7C8177837D8358DA935C71829C787B7D7E
0000FFFFFFFFFFFF00000000000000007DAEA2FF00B05A4D715398462DBFF04B6A60A077
6E8CB667FF20A56B65CD676A7AB678FFFF00BAA676A0927ABF0ABF4B779D998B6CA88995
9E50707F847377836C83886D847A877F7F8C83889BA6B09A7FA6847E7C7E898A98898188
707E7C81739C697D64FF00408F7770776966847E
185FFFFFFFFFFFEF00000000000000007A9369CE65867280857072627A40C07B747D8369
6D53A26477A0646B8C6E847D8C4B99AA8A69817B7D787D8466648F68807A7C82777C7A74
8D6F7C71B1A87D817B7D807A84686C84897D798E9C62989547647D8C8B807D7A7E7A7D7F
788B7F7B917A856334B91B7B7D7E7B7C84857C7E
A769706292697BD963646F8E8D737F756FAFFFD07A7570887A6F755E5CA4D98661807F8A
AE2E71C3647B8B5E857C768801FF4A41E15F887B7F857942837566817A8182769B5E6E91
C0888F947C704B837B847C7F778E8A93516693875592839262B1A88188837E837C787F6A
B307A071A77D72929071C17D817C7D7E7D76827F
769A66482F546458ADFF6C45887DA78F67BA0FAD5182A2765B738A97607D5C8D5A6F8954
93BC767A7BA1B482712B9F9BB70DE68C33AE738D7E408F879E7D93999661797E7C919C9F
69729D8F938D6D857F3E88749760349F8E7C817D83777C7B7D7F40A392768281A389726F
809A766C6E7C4E9A4488759B6EA081807B9D6C77
776D8DC5728F5472731F5E7E898A8F608960C49971A5913B4FA9BF9F8575967D4B837A7F
A2668E7485656AB86A8D5B684BD34B569F73899C69718BA33EA2855F8D847C8464878B4D
74396B7A4AB17C4E9888726B899178857E76857D7C7C807D87B770938E8A848F74A28273
68759DAD8E7D6A8C72827B79807C7C8078CA687B
706B64B7AFA2E96FFCAA7C778B5D6567D1AA574C746B7E9C6B838B8981DF5A67737EAE69
752C5DB17C6EC36678915654554BE8A5828C8176777D7A6B80727A937C7A7E7B89778384
807D885E849471598E80698D7F7BAEA079B05B8879986073B6878F877CB774778095765E
777AA14BAA85A45C95B66961847C7F7F7D8D7C81
642FD2A1D5586D9285910605A74C83C44B994C8066CF753572942B50E6989D375173B18C
B981577667CD96679899FF5A54BA729F777C712EA152979DA25C4F5A92727B8466917798
877973A4BB6F956D8D827CA06182798F4DCB87A4599A818095AB647B81767D6A7BB333BC
AE765C9E90B68A6E967283807F7E8375A8557074
718B6B644ACF82AD7153727763877A8A90548B27BE71714F926F966F5A9A6A9E8F7E7F90
9D8099717E787F859347329D968476717C5E637B87A974A47096A291658F7F84698A8380
77AF679DB08379827B84777A808C6BAB8622977A5D7C7A82767E807F7B8675BD7F618A47
9D9D8F967B8A7A8378828879845A8D8D868D7D89
536EC6768E0D78929C7800578F5952AFAA798E64B196A5AC7C905063CD49A9887BBF5C91
AA7B855E9A6D7D855A9E9D9B9B517D745E5FAE9F898675B17F84818E8A797E7E79A3707B
7E829557A07382845A719B926D833EA87389677797827D6C836E7A7D8276968B758DB8AD
76AA7FAC408E797E8271978C8D7862696E4C7332
95759169C4BA688E0473E87B1DAD6A4F2D4A7FAF9D38937B91348DCE7F82666C838B50A1
4C956C648F56A9509566AA7352B95BAC6A4E747198708B7C9B664CBD856E7E827D7D657F
7C7A8E544BA7798862519484A08D905E8D8C899D5E886A61BA68807E6EB18CB1672DBA3A
484A597495B87B84749C728B8E71837F82698672
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181000`40O003h00Oogoo8Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00?moob5oo`006Goo0P008Woo10000goo0P008Goo0`00
0Woo0P007goo0`0017oo0P0087oo0P0017oo0P006goo1@000Woo0P0017oo0P006Goo1@0000=oo`00
00000P000goo0P0047oo000HOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol0025oo`04
001oogoo0002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`04001oogoo0002
Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00
Oomoogoo00001Goo00@007ooOol000moo`0067oo00@007ooOol0029oo`03001oogoo009oo`04001o
ogoo000NOol500001Goo001oogoo00007Woo00@007ooOol0009oo`04001oogoo000NOol01000Oomo
o`000Woo00@007ooOol001aoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol067oo
00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000moo`0067oo00@007ooOol002=oo`05001o
ogooOol00002Ool00`00Oomoo`0LOol01000Oomoo`000Woo00@007ooOol001ioo`<000=oo`04001o
ogoo000OOol20003Ool01000Oomoo`0077oo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00
Oomoo`0HOol00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol03Goo000HOol01000Oomo
o`008Goo00@007ooOol0009oo`04001oogoo000OOol00`00Ool00002Ool01000Oomoo`007goo00<0
07ooOol00Woo00@007ooOol001ioo`04001oogoo0002Ool01000Oomoo`0077oo00D007ooOomoo`00
009oo`04001oogoo0002Ool00`00Oomoo`0HOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo00eoo`006Goo0P008goo0P0017oo0P008Goo0P000goo0P0087oo0`000goo0P0087oo0P00
17oo0P0077oo0P0017oo0P0017oo0P006Woo0P0017oo0P0017oo0P0047oo003oOolQOol00?moob5o
o`00ogoo8Goo003oOolQOol00?moob5oo`005Gooo`002`000Goo000EOol00`00Oomoo`02Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00
Oomoo`07Ool20001Ool001Eoo`03001oogoo009oo`03001oogoo02Eoo`03001oogoo02Eoo`03001o
ogoo02Eoo`03001oogoo02Eoo`03001oogoo02Aoo`03001oogoo02Eoo`03001oogoo019oo`40005o
o`003Woo0P001Goo00<007ooOol0ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo00<007ooOol0
ogoo1goo0@000Goo000=Ool01000Oomoo`0017oo0P00ogoo1goo0P000Goo000=Ool01000Oomoo`00
17oo00<007ooOol08Woo0R480RU:0Woo0P000Woo0P000Woo0SW>0TYB10000Woo0P000Woo0P000UJe
0QS60QcW0W_N0QcW0U[F0VLi0P000Woo0P000Sg_0U:D0P000VLi0S6<0Vmk0P000R480P000U:D1000
0Woo0P000Woo0QS60VLi0U:D0SF]11240W>L00<DYC6<<H`00Ukg0T8@0U:D0RU:0Sg_0Ukg0W_N13F]
0UJe0SF]0THa0QcW0PQ20Tic0Q240Woo0Q240Tic0R480U:D0TYB0RDY0Vmk0PQ20Vmk0P000W_N0QBU
0Re[0SF]0Re[0SW>0Sg_14Ha0R480Sg_0THa148@0Sg_0SF]0PaS0Vmk0S6<0RU:0Q240S6<0T8@0Re[
0Woo0P0017oo0VLi0SF]0TYB0Sg_0SW>0VLi0TYB0Sg_1Goo0@000Goo000=Ool01000Oomoo`0017oo
00<007ooOol08Woo0R480RU:0Woo0P000Woo0P000Woo0SW>0TYB10000Woo0P000Woo0P000UJe0QS6
0QcW0W_N0QcW0U[F0VLi0P000Woo0P000Sg_0U:D0P000VLi0S6<0Vmk0P000R480P000U:D10000Woo
0P000Woo0QS60VLi0U:D0SF]11240W>L00<DYC6<<H`00Ukg0T8@0U:D0RU:0Sg_0Ukg0W_N13F]0UJe
0SF]0THa0QcW0PQ20Tic0Q240Woo0Q240Tic0R480U:D0TYB0RDY0Vmk0PQ20Vmk0P000W_N0QBU0Re[
0SF]0Re[0SW>0Sg_14Ha0R480Sg_0THa148@0Sg_0SF]0PaS0Vmk0S6<0RU:0Q240S6<0T8@0Re[0Woo
0P0017oo0VLi0SF]0TYB0Sg_0SW>0VLi0TYB0Sg_1Goo0@000Goo000>Ool20005Ool00`00Oomoo`0R
Ool40002Ool20002Ool20004Ool248@20004Ool40002CW<2AS42>Lh25:D27>L2@Q0248@2IcT20002
Ool2:DX20002JeX2Ool236<2AS42BU82Ool27>L2DY@2E[D40002Ool20002Li`2IcT20002F]H2<H`2
HaP2=Jd2BU800eJe6<HHaP02?Nl8@Q027>L2AS42<H`2?Nl2>Lh2BU82;F/2G_L2>Lh2?Nl2AS42G_L2
>Lh2F]H29BT2>Lh29BT2Li`26<H2<H`2Mkd20002Mkd20002DY@2;F/29BT2<H`2;F/248@2AS42Ool2
>Lh2AS42>Lh2CW<2@Q02<H`21242=Jd2?Nl8@Q02;F/2Ool20004Ool2CW<28@P2IcT2:DX4AS42?Nl2
CW<5Ool10001Ool001Eoo`03001oogoo029oo`@0009oo`80009oo`8000Aoo`8@Q08000Aoo`@0009>
L`96<@8icP8DY@8Li`92408@Q09W>@80009oo`8YBP80009[FP9oo`8<H`96<@9:DP9oo`8Li`9BU09F
]@@0009oo`80009cW09W>@80009JeP8aS09S608e[@9:DP03E[DHaQS6008mk`Q2408Li`96<@8aS08m
k`8icP9:DP8]J`9Nm`8icP8mk`96<@9Nm`8icP9JeP8U:@8icP8U:@9cW08HaP8aS09g_@80009g_@80
009BU08]J`8U:@8aS08]J`8@Q096<@9oo`8icP96<@8icP9>L`92408aS0848@8e[@8mk`Q2408]J`9o
o`8000Aoo`9>L`8Q209W>@8YBPA6<@8mk`9>L`Eoo`40005oo`005Goo00<007ooOol08Woo10000Woo
0P000Woo0P000Ukg0UJe10000VLi17oo0P000Woo0SF]10000Woo0SF]0PaS0Woo0P000Woo0P000Woo
0QS60U:D0RU:0Re[0VLi0SF]0RU:0Sg_0UJe10000Woo0P000Woo0QS60P@Q0QS60UJe0VLi0QS60V<H
00<YBRe[;F/00RDY0SW>0THa0SW>0TYB0SW>13F]0TYB0SF]0Tic0TYB0V<H0Q240Ukg12DY0T8@0S6<
0Sg_0Tic0Sg_0Vmk0SW>0RDY0S6<0RU:0Woo0P000THa0Re[0SF]0W>L13g_14Ha0T8@0SW>0TYB0QBU
0TYB0Re[0Tic1SW>13g_0T8@0Re[0Woo0P0017oo0T8@0R480TYB0T8@0SW>0UJe0V]J0SW>1Goo0@00
0Goo000EOol00`00Oomoo`0ROol40002Ool20002Ool20002G_L2E[D40002IcT4Ool20002Ool2=Jd4
0002Ool2=Jd236<2Ool20002Ool20002Ool26<H2DY@2:DX2;F/2IcT2=Jd2:DX2?Nl2E[D40002Ool2
0002Ool26<H212426<H2E[D2IcT26<H2HaP00bU:;F/]J`029BT2>Lh2AS42>Lh2BU82>Lh4=Jd2BU82
=Jd2CW<2BU82HaP248@2G_L49BT2@Q02<H`2?Nl2CW<2?Nl2Kg/2>Lh29BT2<H`2:DX2Ool20002AS42
;F/2=Jd2Li`4?Nl4AS42@Q02>Lh2BU825:D2BU82;F/2CW<6>Lh4?Nl2@Q02;F/2Ool20004Ool2@Q02
8@P2BU82@Q02>Lh2E[D2JeX2>Lh5Ool10001Ool001Eoo`03001oogoo029oo`@0009oo`80009oo`80
009oo`80009cW09oo`80009oo`@0008<H`9oo`8e[@80009oo`8icP9oo`8Q208HaP9oo`80009oo`80
009oo`80009oo`80009oo`8DY@9JeP9>L`@0009oo`80009oo`8U:@8icP96<@8]J`9BU08000924003
BU96<DHa0096<@92408icP96<@8YBP9:DP8icP9>L`8DY@8icP@mk`924096<@9W>@848@9BU08]J`9F
]@8U:@96<@8e[@8icP8]J`8YBP9BU08e[@8U:@9oo`96<@9cW08aS09S608icP92408e[@9>L`8mk`9:
DP8U:@9oo`80009oo`8DY@8e[@8]J`9JeP8icPA2408]J`9oo`8000Aoo`8Li`8aS09240@mk`9[FP96
<@8icPEoo`40005oo`005Goo00<007ooOol08Woo10000Woo0P000Woo0P000Woo0P000W>L0Woo0P00
0Woo10000PaS0Woo0SF]0P000Woo0SW>0Woo0R480QS60Woo0P000Woo0P000Woo0P000Woo0P000Woo
0QBU0U[F0Tic10000Woo0P000Woo0RDY0SW>0THa0Re[0U:D0P000T8@00=:DTHaAS400THa0T8@0SW>
0THa0RU:0TYB0SW>0Tic0QBU0SW>13g_0T8@0THa0VLi0P@Q0U:D0Re[0UJe0RDY0THa0SF]0SW>0Re[
0RU:0U:D0SF]0RDY0Woo0THa0W>L0S6<0V<H0SW>0T8@0SF]0Tic0Sg_0TYB0RDY0Woo0P000Woo0QBU
0SF]0Re[0U[F0SW>148@0Re[0Woo0P0017oo0QcW0S6<0T8@13g_0V]J0THa0SW>1Goo0@000Goo000E
Ool00`00Oomoo`0ROol40002Ool20002Ool20002G_L2F]H2IcT28@P20002Ool20002Ool20002Ool2
DY@2<H`2Mkd20002Ool26<H2Ool40002F]H2DY@2=Jd2>Lh2Ool20002CW<2>Lh236<2G_L40002Ool2
0002HaP2CW<248@2AS42IcT2Li`26<H2G_L00b48F]IJeP02<H`2BU82<H`4AS44=Jd2AS42;F/2:DX2
AS42@Q02;F/4?Nl2AS42=Jd29BT2IcT2<H`2?Nl2:DX2AS42Mkd29BT2@Q020002IcT2Ool2F]H248@2
0002AS42DY@2>Lh2?Nl248@2DY@20002IcT2E[D2;F/2IcT25:D2IcT26<H2@Q02F]H2=Jd2@Q02:DX2
Ool20004Ool2DY@25:D2JeX2>Lh2F]H2BU82?Nl2@Q05Ool10001Ool001Eoo`8002=oo`@0009oo`80
009oo`80009Nm`9JeP9W>@8Q2080009oo`80009oo`80009oo`9BU08aS09g_@80009oo`8HaP9oo`@0
009JeP9BU08e[@8icP9oo`80009>L`8icP8<H`9Nm`@0009oo`80009S609>L`8@Q096<@9W>@9cW08H
aP9Nm`038@QJeU[F008aS09:DP8aS0A6<@@e[@96<@8]J`8YBP96<@92408]J`@mk`96<@8e[@8U:@9W
>@8aS08mk`8YBP96<@9g_@8U:@924080009W>@9oo`9JeP8@Q0800096<@9BU08icP8mk`8@Q09BU080
009W>@9F]@8]J`9W>@8DY@9W>@8HaP92409JeP8e[@92408YBP9oo`8000Aoo`9BU08DY@9[FP8icP9J
eP9:DP8mk`9240Aoo`80005oo`005Goo00<007ooOol03Woo0W_N4Woo0P000Sg_0Woo0P000Woo0P00
0Woo15[F0V]J0Q240Woo0P000Woo0P000Woo14ic0Sg_0Woo0SW>0P000Woo0P000Woo0P000Vmk0RDY
0Woo0P000WNm0R480THa0S6<0THa10000Woo0P000Ukg0Tic0SF]0U[F0Woo0Sg_0SW>0Sg_00<004YB
BU800T8@0TYB0QcW0Sg_0P000RDY0UJe0SF]0TYB0Re[0T8@0THa0QS60T8@0S6<0SW>0TYB0THa13g_
0Tic0Sg_0W>L136<0W_N0R480V]J0P000Woo0QS60Woo0Vmk0SW>0T8@0S6<0Tic0V<H12U:1T8@0Re[
0QS60Sg_0SF]0TYB0SW>0TYB0Re[0Woo0P0017oo0Re[0R480T8@0TYB0SW>13F]0RU:1Goo0@000Goo
000EOol00`00Oomoo`0>Ool2NmhBOol20002?Nl2Ool20002Ool20002Ool4F]H2JeX248@2Ool20002
Ool20002Ool4CW<2?Nl2Ool2>Lh20002Ool20002Ool20002Kg/29BT2Ool20002Mkd28@P2AS42<H`2
AS440002Ool20002G_L2CW<2=Jd2F]H2Ool2?Nl2>Lh2?Nl00`00BU9:DP02@Q02BU827>L2?Nl20002
9BT2E[D2=Jd2BU82;F/2@Q02AS426<H2@Q02<H`2>Lh2BU82AS44?Nl2CW<2?Nl2Li`4<H`2Nmh28@P2
JeX20002Ool26<H2Ool2Kg/2>Lh2@Q02<H`2CW<2HaP4:DX6@Q02;F/26<H2?Nl2=Jd2BU82>Lh2BU82
;F/2Ool20004Ool2;F/28@P2@Q02BU82>Lh4=Jd2:DX5Ool10001Ool001Eoo`03001oogoo00Ioo`8m
k`Ioo`80019oo`@0009oo`80009oo`80009oo`8e[@8]J`9oo`80009oo`80009oo`80009oo`9W>@8Q
209S608mk`9W>@80009oo`80009oo`80009>L`92409BU09:DP9W>@92408Q209:DP9Nm`@0009oo`80
009oo`8icP9BU08icP96<@9BU08]J`8icP039BTmkcg_00@icP9BU09g_@8<H`8Li`9>L`8mk`I24096
<@8]J`8icP8mk`9:DP8]J`9:DP@mk`9JeP8Q208e[@9BU08Q209kgP80009BU080009oo`8Li`88@P80
009>L`8mk`8e[@92409BU092408e[@924096<@9JeP8aS09:DP8e[@96<@8icP92408mk`8YBP9oo`80
00Aoo`8mk`8e[@9BU0@e[@9:DP96<@8mk`Eoo`40005oo`005Goo00<007ooOol01Woo0Sg_1Woo0P00
4Woo10000Woo0P000Woo0P000Woo0SF]0Re[0Woo0P000Woo0P000Woo0P000Woo0VLi0R480V<H0Sg_
0VLi0P000Woo0P000Woo0P000Tic0T8@0U:D0TYB0VLi0T8@0R480TYB0Ukg10000Woo0P000Woo0SW>
0U:D0SW>0THa0U:D0Re[0SW>00<U:Cg_?Nl013W>0U:D0WNm0PaS0QcW0Tic0Sg_1T8@0THa0Re[0SW>
0Sg_0TYB0Re[0TYB13g_0U[F0R480SF]0U:D0R480W_N0P000U:D0P000Woo0QcW0PQ20P000Tic0Sg_
0SF]0T8@0U:D0T8@0SF]0T8@0THa0U[F0S6<0TYB0SF]0THa0SW>0T8@0Sg_0RU:0Woo0P0017oo0Sg_
0SF]0U:D13F]0TYB0THa0Sg_1Goo0@000Goo000EOol00`00Oomoo`0ROol20002BU840002Ool21242
Ool4248200025:D2Ool20002Ool20002Ool20002Nmh22482DY@2HaP2IcT20002Ool40002>Lh2?Nl2
<H`2?Nl28@P2JeX29BT2=Jd2F]H40002Ool20002DY@2BU82AS42=Jd2Li`2BU82:DX2@Q000dYB?Nlm
k`02@Q02AS425:D2F]H22482JeX2<H`2BU82<H`2>Lh2:DX4@Q02?Nl2BU82IcT2:DX2<H`2DY@2=Jd2
HaP2F]H27>L2E[D248@27>L2AS428@P2Kg/28@P2AS428@P2CW<2=Jd2E[D2@Q02:DX4AS42=Jd2<H`2
E[D2IcT2:DX6>Lh4@Q02?Nl2=Jd2Ool20004Ool2DY@2?Nl2BU82AS42;F/2?Nl2@Q02?Nl5Ool10001
Ool001Eoo`03001oogoo029oo`80009:DP@0009oo`848@9oo`@8@P80008DY@9oo`80009oo`80009o
o`80009kgP88@P9BU09S609W>@80009oo`@0008icP8mk`8aS08mk`8Q209[FP8U:@8e[@9JeP@0009o
o`80009BU09:DP96<@8e[@9cW09:DP8YBP924003BU8mkcg_00924096<@8DY@9JeP88@P9[FP8aS09:
DP8aS08icP8YBPA2408mk`9:DP9W>@8YBP8aS09BU08e[@9S609JeP8Li`9F]@8@Q08Li`96<@8Q209_
N`8Q2096<@8Q209>L`8e[@9F]@92408YBPA6<@8e[@8aS09F]@9W>@8YBPHicPA2408mk`8e[@9oo`80
00Aoo`9BU08mk`9:DP96<@8]J`8mk`92408mk`Eoo`40005oo`005Goo00<007ooOol097oo0P000Woo
0P000Woo0P000TYB0WNm0Woo0P000Ukg0Woo0QS60SW>0Woo0P000RDY0U[F0TYB0U:D0R480Woo0UJe
0SF]0Re[0S6<0P000VLi0UJe0Vmk0SF]0S6<0Tic0Re[0Tic10000Woo0P000Ukg0RU:0Tic0Sg_0Tic
0WNm0U:D0P0000=S63g_?Nl00TYB0Sg_0THa0S6<0Ukg0Re[13F]0V<H0SF]0QcW0V]J0Sg_0TYB0T8@
0S6<0U[F0SF]14Ha0Tic0T8@0Re[0Tic0RU:0TYB0SW>0THa0T8@0THa0Sg_0U[F0PQ20Re[0RU:14Ha
0Sg_0QcW0Sg_0V<H0SF]0RU:0SW>0U:D0R480U:D0Re[0THa0Sg_0S6<0WNm0P0017oo0Sg_0Re[0THa
13g_0U:D0SW>0Sg_1Goo0@000Goo000EOol00`00Oomoo`0TOol20002Ool20002Ool20002BU82Mkd2
Ool20002G_L2Ool26<H2>Lh2Ool200029BT2F]H2BU82DY@28@P2Ool2E[D2=Jd2;F/2<H`20002IcT2
E[D2Kg/2=Jd2<H`2CW<2;F/2CW<40002Ool20002G_L2:DX2CW<2?Nl2CW<2Mkd2DY@200000f<H?Nlm
k`02BU82?Nl2AS42<H`2G_L2;F/4=Jd2HaP2=Jd27>L2JeX2?Nl2BU82@Q02<H`2F]H2=Jd4AS42CW<2
@Q02;F/2CW<2:DX2BU82>Lh2AS42@Q02AS42?Nl2F]H22482;F/2:DX4AS42?Nl27>L2?Nl2HaP2=Jd2
:DX2>Lh2DY@28@P2DY@2;F/2AS42?Nl2<H`2Mkd20004Ool2?Nl2;F/2AS44?Nl2DY@2>Lh2?Nl5Ool1
0001Ool001Eoo`03001oogoo00ioo`80019oo`80008Q209S6080009oo`80009oo`80009BU08aS09F
]@8aS09oo`8HaP80009oo`8icP8aS08Li`8]J`9oo`80009:DP8]J`8mk`92408mk`@e[@9:DP8<H`9>
L`8Q209cW09JeP@0009oo`80009[FP8]J`9F]@92409:DP9BU08HaP9oo`03000]Jbe[0096<@9240@m
k`@icP8mk`8e[@8mk`9:DP9F]@8Q208YBP9>L`8]J`9Nm`8DY@96<@A>L`92408]J`92408U:@9W>@8D
Y@8aS09BU092409>L`8icP9:DP8aS0A2408icP8]J`8mk`8e[@8icP9BU09_N`80009:DP8e[@8YBP9:
DP96<@88@P9:DP8U:@9oo`8000Aoo`96<@8e[@@aS08]J`9F]@8icP9F]@Eoo`40005oo`005Goo0P00
3goo0P004Woo0P000R480V<H0P000Woo0P000Woo0P000U:D0S6<0UJe0S6<0Woo0QS60P000Woo0SW>
0S6<0QcW0Re[0Woo0P000TYB0Re[0Sg_0T8@0Sg_13F]0TYB0PaS0Tic0R480W>L0U[F10000Woo0P00
0V]J0Re[0UJe0T8@0TYB0U:D0QS60Woo00<002e[;F/00THa0T8@13g_13W>0Sg_0SF]0Sg_0TYB0UJe
0R480RU:0Tic0Re[0Ukg0QBU0THa14ic0T8@0Re[0T8@0RDY0VLi0QBU0S6<0U:D0T8@0Tic0SW>0TYB
0S6<148@0SW>0Re[0Sg_0SF]0SW>0U:D0Vmk0P000TYB0SF]0RU:0TYB0THa0PQ20TYB0RDY0Woo0P00
17oo0THa0SF]136<0Re[0UJe0SW>0UJe17oo0P000Goo000EOol00`00Oomoo`0<Ool20002MkdDOol2
0002Ool20002Ool40006Ool2Kg/2CW<2:DX20002Ool20002Mkd20002Ool25:D2:DX2AS42=Jd2AS42
?Nl2IcT28@P2CW<21242Mkd2=Jd2@Q02DY@27>L2G_L40002Ool20002F]H29BT2=Jd26<H2DY@20002
JeX2Kg/00`00AS56<@02=Jd2AS42>Lh28@P2DY@2F]H28@P2Ool40002Mkd21244>Lh2?Nl2@Q029BT2
DY@2E[D2:DX2F]H2@Q02>Lh2BU82<H`2DY@2@Q02BU82=Jd2CW<2>Lh2=Jd2>Lh2CW<2<H`2>Lh2;F/2
6<H2HaP2?Nl29BT26<H2;F/2>Lh2F]H2DY@2;F/2G_L2=Jd2@Q02=Jd2Ool20004Ool2?Nl2:DX2BU82
@Q02BU82AS42@Q026<H5Ool10001Ool001Eoo`03001oogoo00aoo`80009g_AAoo`80009oo`80009o
o`@000Ioo`9_N`9>L`8YBP80009oo`80009g_@80009oo`8DY@8YBP96<@8e[@96<@8mk`9W>@8Q209>
L`848@9g_@8e[@92409BU08Li`9Nm`@0009oo`80009JeP8U:@8e[@8HaP9BU080009[FP9_N`030016
<DHa008e[@96<@8icP8Q209BU09JeP8Q209oo`@0009g_@848@@icP8mk`92408U:@9BU09F]@8YBP9J
eP92408icP9:DP8aS09BU092409:DP8e[@9>L`8icP8e[@8icP9>L`8aS08icP8]J`8HaP9S608mk`8U
:@8HaP8]J`8icP9JeP9BU08]J`9Nm`8e[@92408e[@9oo`8000Aoo`8mk`8YBP9:DP92409:DP96<@92
408HaPEoo`40005oo`005Goo00<007ooOol02Woo0P000Woo0QBU4Woo0P0017oo0P000Woo1P000Woo
0P000U:D0Sg_0P000Woo0P0017oo0P000W>L0SW>0T8@0S6<0T8@0SW>0SF]0TYB0QS60V<H0Sg_0T8@
0Tic0RU:0QcW0R480U:D10000Woo0P000T8@0TYB0Sg_0T8@0P000Woo0P000Woo00<002e[;F/00V]J
0S6<0T8@0UJe13g_0QcW0Ukg0P000Tic0R480V]J0Q240SF]0Tic0RDY13W>0Sg_0S6<0T8@0SW>0U:D
0THa0Sg_0Tic13W>0S6<0Re[0Tic0SF]0V]J0T8@0Ukg0RDY0THa0PaS0T8@0U[F0QBU0S6<0SF]0THa
0Re[0RU:0U[F0RDY0Tic0Sg_0S6<0Woo0P0017oo0R480Re[0SF]0RDY0U:D0S6<0T8@0THa1Goo0@00
0Goo000EOol00`00Oomoo`0:Ool20002Ool25:DBOol20004Ool20002Ool60002Ool20002DY@2?Nl2
0002Ool20004Ool20002Li`2>Lh2@Q02<H`2@Q02>Lh2=Jd2BU826<H2HaP2?Nl2@Q02CW<2:DX27>L2
8@P2DY@40002Ool20002@Q02BU82?Nl2@Q020002Ool20002Ool00`00;F/]J`02JeX2<H`2@Q02E[D4
?Nl27>L2G_L20002CW<28@P2JeX248@2=Jd2CW<29BT4>Lh2?Nl2<H`2@Q02>Lh2DY@2AS42?Nl2CW<4
>Lh2<H`2;F/2CW<2=Jd2JeX2@Q02G_L29BT2AS4236<2@Q02F]H25:D2<H`2=Jd2AS42;F/2:DX2F]H2
9BT2CW<2?Nl2<H`2Ool20004Ool28@P2;F/2=Jd29BT2DY@2<H`2@Q02AS45Ool10001Ool001Eoo`03
001oogoo00Qoo`8001Yoo`80009oo`80009oo`8000Aoo`80009oo`9F]@8e[@9W>@80009oo`80008]
J`80009Nm`8aS092409oo`9:DP8DY@9oo`80009_N`9S6080009W>@96<@@YBP96<@9:DP@0009oo`80
009_N`8Li`92409_N`92408Q209oo`800003IcTicSW>009JeP8mk`9S608e[@A:DP96<@8mk`9F]@96
<@92408DY@8icP8U:@8YBP8mk`96<@8mk`92408mk`8icP924096<@8U:@9JeP96<@9JeP8icP8mk`8]
J`9:DP8]J`8Q208aS09JeP8mk`80009oo`924096<@8]J`8mk`8e[@96<@8U:@8YBPA2408mk`92408e
[@9[FP8000Aoo`9>L`92409F]@@icP8mk`96<@8mk`Eoo`40005oo`005Goo00<007ooOol027oo0P00
6Woo0P000Woo0P000Woo0P0017oo0P000Woo0UJe0SF]0VLi0P000Woo0P000Re[0P000Ukg0S6<0T8@
0Woo0TYB0QBU0Woo0P000Vmk0V<H0P000VLi0THa12U:0THa0TYB10000Woo0P000Vmk0QcW0T8@0Vmk
0T8@0R480Woo0P0000=W>CW>>Lh00U[F0Sg_0V<H0SF]14YB0THa0Sg_0UJe0THa0T8@0QBU0SW>0RDY
0RU:0Sg_0THa0Sg_0T8@0Sg_0SW>0T8@0THa0RDY0U[F0THa0U[F0SW>0Sg_0Re[0TYB0Re[0R480S6<
0U[F0Sg_0P000Woo0T8@0THa0Re[0Sg_0SF]0THa0RDY0RU:148@0Sg_0T8@0SF]0V]J0P0017oo0Tic
0T8@0UJe13W>0Sg_0THa0Sg_1Goo0@000Goo000EOol00`00Oomoo`0TOol20002Li`20002Ool20002
Ool20002Ool2=Jd40002Ool20002Ool2?Nl2AS42Ool20002E[D2<H`236<2>Lh2E[D20002Ool26<H2
0002Kg/2;F/2?Nl2AS42CW<2>Lh2E[D40002Ool21242?Nl2@Q02E[D25:D2HaP2;F/2>Lh2DY@00dic
BU9:DP02?Nl4BU82=Jd2IcT2CW<2<H`2AS429BT2@Q02?Nl2AS42?Nl2>Lh2AS42CW<2>Lh2:DX2DY@2
5:D2IcT2<H`2@Q02BU827>L2;F/2?Nl2>Lh2BU82CW<2>Lh27>L29BT212427>L2BU82;F/2@Q02?Nl8
@Q02?Nl2BU82?Nl2>Lh4?Nl2@Q02<H`2Ool20004Ool2CW<2=Jd2DY@26<H2BU82>Lh2CW<27>L5Ool1
0001Ool001Eoo`03001oogoo02Aoo`80009cW080009oo`80009oo`80009oo`8e[@@0009oo`80009o
o`8mk`96<@9oo`80009F]@8aS08<H`8icP9F]@80009oo`8HaP80009_N`8]J`8mk`96<@9>L`8icP9F
]@@0009oo`848@8mk`92409F]@8DY@9S608]J`8icP9BU003CW=:DTYB008mk`A:DP8e[@9W>@9>L`8a
S096<@8U:@92408mk`96<@8mk`8icP96<@9>L`8icP8YBP9BU08DY@9W>@8aS092409:DP8Li`8]J`8m
k`8icP9:DP9>L`8icP8Li`8U:@848@8Li`9:DP8]J`92408mk`Q2408mk`9:DP8mk`8icP@mk`92408a
S09oo`8000Aoo`9>L`8e[@9BU08HaP9:DP8icP9>L`8Li`Eoo`40005oo`005Goo00<007ooOol03Woo
0W_N4Woo0Tic0Ukg0W_N0P000Woo0P000Woo0P000Woo0P000Woo0PaS17oo0P000TYB0Sg_0P@Q0Woo
0P@Q0UJe0Q240Re[17oo0P000T8@0UJe0SW>0Tic0SW>0Vmk0S6<0RU:0U[F10000Woo0P000Re[0VLi
0P000V]J0RDY0T8@0RU:0S6<00=:DSW>>Lh00Tic0SF]0R480QcW0U:D0T8@0Sg_0THa0RU:0S6<0SW>
0THa0Sg_0SF]0Vmk0PaS0RDY0Re[0T8@0SW>0T8@0S6<0Tic0S6<0V<H0U:D0SF]0W>L0Q240S6<0RU:
0SF]0S6<0V<H0U:D0SW>0U:D0T8@0U:D0QS60Sg_0S6<0SW>0Sg_0UJe0RDY0U:D0SW>0THa0Sg_0S6<
0Woo0P0017oo0S6<0U[F0U:D0SW>0Tic0SW>0SF]0U:D1Goo0@000Goo000EOol2000?Ool2NmhBOol2
CW<2G_L2Nmh20002Ool20002Ool20002Ool20002Ool236<4Ool20002BU82?Nl21242Ool21242E[D2
48@2;F/4Ool20002@Q02E[D2>Lh2CW<2>Lh2Kg/2<H`2:DX2F]H40002Ool20002;F/2IcT20002JeX2
9BT2@Q02:DX2<H`00dYB>LhicP02CW<2=Jd28@P27>L2DY@2@Q02?Nl2AS42:DX2<H`2>Lh2AS42?Nl2
=Jd2Kg/236<29BT2;F/2@Q02>Lh2@Q02<H`2CW<2<H`2HaP2DY@2=Jd2Li`248@2<H`2:DX2=Jd2<H`2
HaP2DY@2>Lh2DY@2@Q02DY@26<H2?Nl2<H`2>Lh2?Nl2E[D29BT2DY@2>Lh2AS42?Nl2<H`2Ool20004
Ool2<H`2F]H2DY@2>Lh2CW<2>Lh2=Jd2DY@4Ool20001Ool001Eoo`03001oogoo00ioo`9>La9oo`8<
H`9W>@9oo`80009oo`80009oo`8Q209JeP9oo`80009>L`8000Ioo`88@P8]J`80009>L`8]J`80009o
o`8000Aoo`80009oo`8YBP8<H`8U:@8aS09W>@8HaP9:DP@0009oo`80009BU0AW>@8aS08YBP8e[@9N
m`924003E[E2448@009F]@9JeP8mk`8Q208YBPA2409[FP8YBP9>L`@mk`92409BU09JeP8]J`80008L
i`9F]@8HaP9S608Li`9>L`8icP9cW09BU08]J`8<H`96<@8e[@80009g_@8icP92409>L`9:DP9g_@9F
]@9Nm`8aS09>L`96<@8icP9F]@8YBP8Li`9Nm`8]J`8icP9:DP8]J`9oo`8000Aoo`8aS08mk`92409:
DP8mk`96<@8mk`9:DPEoo`40005oo`005Goo00<007ooOol03Woo0Tic4Woo0PaS0VLi0Woo0P000Woo
0P000Woo0R480U[F0Woo0P000Tic0P001Woo0PQ20Re[0P000Tic0Re[0P000Woo0P0017oo0P000Woo
0RU:0PaS0RDY0S6<0VLi0QS60TYB10000Woo0P000U:D16Li0S6<0RU:0SF]0Ukg0T8@00=F]D8@@Q00
0UJe0U[F0Sg_0R480RU:148@0V]J0RU:0Tic13g_0T8@0U:D0U[F0Re[0P000QcW0UJe0QS60V<H0QcW
0Tic0SW>0W>L0U:D0Re[0PaS0THa0SF]0P000WNm0SW>0T8@0Tic0TYB0WNm0UJe0Ukg0S6<0Tic0THa
0SW>0UJe0RU:0QcW0Ukg0Re[0SW>0TYB0Re[0Woo0P0017oo0S6<0Sg_0T8@0TYB0Sg_0THa0Sg_0TYB
1Goo0@000Goo000EOol00`00Oomoo`02Ool25:D2Nmh2IcT2DY@2Ool2Li`2Ool2AS429BT25:D21242
>Lh40002CW<2Ool2@Q028@P20002DY@2G_L4CW<2BU82Kg/248@28@P2@Q02AS429BT4DY@2>Lh2CW<2
<H`20002Li`26<H2Ool2;F/26<H2<H`2?Nl2JeX2DY@21242CW<236<2;F/2HaP2BU82CW<2DY@26<H2
8@P236<2E[D2?Nl2=Jd28@P2CW<2>Lh2<H`00d8@=Jde[@02@Q02AS42:DX49BT2F]H2?Nl2@Q02=Jd4
@Q02?Nl2AS42@Q02;F/2AS42>Lh2BU82AS44>Lh2DY@2>Lh2@Q02G_L2>Lh2;F/2<H`2E[D2CW<2DY@2
>Lh2DY@2>Lh2AS42?Nl2HaP2IcT29BT224827>L2CW<2;F/2G_L2=Jd2?Nl2AS42:DX2BU82>Lh2AS42
<H`2?Nl2<H`4@Q02CW<2E[D2:DX2BU82;F/2>Lh2=Jd5Ool10001Ool001Eoo`03001oogoo009oo`8D
Y@9kgP9W>@9BU09oo`9cW09oo`96<@8U:@8DY@848@8icP@0009>L`9oo`92408Q2080009BU09Nm`A>
L`9:DP9_N`8@Q08Q20924096<@8U:@ABU08icP9>L`8aS080009cW08HaP9oo`8]J`8HaP8aS08mk`9[
FP9BU0848@9>L`8<H`8]J`9S609:DP9>L`9BU08HaP8Q208<H`9F]@8mk`8e[@8Q209>L`8icP8aS003
@Q0e[CF]00924096<@8YBP@U:@9JeP8mk`92408e[@A2408mk`96<@92408]J`96<@8icP9:DP96<@@i
cP9BU08icP92409Nm`8icP8]J`8aS09F]@9>L`9BU08icP9BU08icP96<@8mk`9S609W>@8U:@88@P8L
i`9>L`8]J`9Nm`8e[@8mk`96<@8YBP9:DP8icP96<@8aS08mk`8aS0A2409>L`9F]@8YBP9:DP8]J`8i
cP8e[@Eoo`40005oo`005Goo00<007ooOol00Woo0V]J0Q240P000PaS0P000P@Q100027oo0THa0Tic
0Ukg0W_N0THa0SF]0WNm0PaS0U[F0UJe0S6<0TYB0Woo0S6<0U:D0Q240RU:0V<H0P@Q0SF]0SW>0QcW
0S6<0TYB0P000SW>0SF]0U:D0U[F0RU:0THa0S6<0TYB0R480U[F13g_0TYB0Re[0Ukg0RDY0SW>0Q24
0UJe0R480TYB0SF]0SW>0Sg_0THa0T8@00=F]D8@@Q0014YB0QcW0Sg_0Re[0SW>0THa0SW>0THa0SF]
0TYB0SF]0Tic0S6<0T8@0Sg_12e[0Sg_0THa0Re[0Tic0V<H0S6<0SF]0QcW0Tic0SF]0QS60Ukg0QBU
0S6<0RDY0SF]0Sg_0T8@0S6<0RDY0TYB0S6<0T8@0Sg_0T8@0V<H0Ukg0THa0T8@0SW>0T8@0THa0T8@
0SW>0Tic0THa0T8@0Ukg0SW>0T8@0THa0RU:0Tic0Sg_0S6<1Goo0@000Goo000EOol00`00Oomoo`02
Ool2JeX248@2000236<2000212440008Ool2AS42CW<2G_L2Nmh2AS42=Jd2Mkd236<2F]H2E[D2<H`2
BU82Ool2<H`2DY@248@2:DX2HaP21242=Jd2>Lh27>L2<H`2BU820002>Lh2=Jd2DY@2F]H2:DX2AS42
<H`2BU828@P2F]H4?Nl2BU82;F/2G_L29BT2>Lh248@2E[D28@P2BU82=Jd2>Lh2?Nl2AS42@Q000eJe
@Q124004BU827>L2?Nl2;F/2>Lh2AS42>Lh2AS42=Jd2BU82=Jd2CW<2<H`2@Q02?Nl4;F/2?Nl2AS42
;F/2CW<2HaP2<H`2=Jd27>L2CW<2=Jd26<H2G_L25:D2<H`29BT2=Jd2?Nl2@Q02<H`29BT2BU82<H`2
@Q02?Nl2@Q02HaP2G_L2AS42@Q02>Lh2@Q02AS42@Q02>Lh2CW<2AS42@Q02G_L2>Lh2@Q02AS42:DX2
CW<2?Nl2<H`5Ool10001Ool001Eoo`03001oogoo009oo`80009S609oo`92409_N`8Li`Aoo`P0008e
[@@000@Q209:DP8aS09oo`8DY@8<H`8e[@9BU08aS09S608mk`9oo`9g_@8000848@9cW08YBP9S608H
aPA:DP8Q2092408]J`80009oo`8Q209:DP8@Q09W>@8icP8aS0924096<@9F]@92409oo`8U:@8icP8U
:@92408U:@9_N`8YBP9Nm`8aS096<@03?Nm2448@00@]J`96<@9BU09Nm`8]J`8U:@9:DP8icP92408a
S0@icP8]J`9>L`8e[@8mk`8e[@9>L`8icP@U:@9JeP8Li`9Nm`8icP9:DP9BU08HaP8aS08YBP9BU08a
S09:DP8@Q096<@9>L`@icP8mk`9S608icP8mk`9cW09>L`8mk`92408mk`92408icP8mk`8icP9Nm`84
8@8aS08Q209S609F]@9>L`8mk`8]J`8mk`9240Eoo`40005oo`001goo10000goo0P001Goo00<007oo
Ool00Woo0P000V<H0Woo0T8@0Vmk0QcW17oo20000SF]100012480TYB0S6<0Woo0QBU0PaS0SF]0U:D
0S6<0V<H0Sg_0Woo0WNm0P000P@Q0W>L0RU:0V<H0QS614YB0R480T8@0Re[0P000Woo0R480TYB0Q24
0VLi0SW>0S6<0T8@0THa0UJe0T8@0Woo0RDY0SW>0RDY0T8@0RDY0Vmk0RU:0Ukg0S6<0THa00<mkd8@
@Q0012e[0THa0U:D0Ukg0Re[0RDY0TYB0SW>0T8@0S6<13W>0Re[0Tic0SF]0Sg_0SF]0Tic0SW>12DY
0U[F0QcW0Ukg0SW>0TYB0U:D0QS60S6<0RU:0U:D0S6<0TYB0Q240THa0Tic13W>0Sg_0V<H0SW>0Sg_
0W>L0Tic0Sg_0T8@0Sg_0T8@0SW>0Sg_0SW>0Ukg0P@Q0S6<0R480V<H0UJe0Tic0Sg_0Re[0Sg_0T8@
1Goo0@000Goo0007Ool00`00Oomoo`03Ool01000Oomoo`0017oo00<007ooOol01Woo30004Woo0P00
0Woo0P000Woo0RDY0W_N0Tic0Woo0U[F0P001Woo10000Woo0UJe0T8@0QS60PQ20P000S6<0Woo0P00
0U:D0Q240Vmk0Re[0U[F0QBU0Tic0W_N0Tic0WNm10000Woo0R480TYB0T8@0SF]0Tic0Vmk0T8@0WNm
0P0000=244HaAS400T8@0THa0RU:0SW>0RU:0Sg_0S6<0Tic0Sg_0SF]0THa0S6<0SW>0T8@0SW>0Tic
0T8@0S6<0Tic0TYB0QS60QcW15:D0PQ20Re[0TYB0RDY0Tic0S6<0T8@0TYB0Tic0RU:0Re[0SW>0SF]
0T8@0S6<0Sg_0THa0TYB0U[F0SF]0Re[0Sg_0U:D0S6<0Tic136<0VLi0RU:0Woo0VLi0Sg_0THa0T8@
0THa0SF]0TYB13W>1Goo0@000Goo0008Ool00`00Oomoo`02Ool01000Oomoo`0017oo0P001goo3000
4Woo0P000Woo0P000Woo0RDY0W_N0Tic0Woo0U[F0P001Woo10000Woo0UJe0T8@0QS60PQ20P000S6<
0Woo0P000U:D0Q240Vmk0Re[0U[F0QBU0Tic0W_N0Tic0WNm10000Woo0R480TYB0T8@0SF]0Tic0Vmk
0T8@0WNm0P0000=244HaAS400T8@0THa0RU:0SW>0RU:0Sg_0S6<0Tic0Sg_0SF]0THa0S6<0SW>0T8@
0SW>0Tic0T8@0S6<0Tic0TYB0QS60QcW15:D0PQ20Re[0TYB0RDY0Tic0S6<0T8@0TYB0Tic0RU:0Re[
0SW>0SF]0T8@0S6<0Sg_0THa0TYB0U[F0SF]0Re[0Sg_0U:D0S6<0Tic136<0VLi0RU:0Woo0VLi0Sg_
0THa0T8@0THa0SF]0TYB13W>17oo0P000Goo0009Ool01@00Oomoogoo00000Woo00<007ooOol00Woo
00<007ooOol00Woo10001Woo0P000Woo5P000Woo0P000Woo0Tic0SW>10000QBU0Woo0Tic0QS60TYB
0P000Woo0S6<0SF]0S6<0Tic0P000Woo0Ukg0PaS0Woo0THa0T8@0SF]0Re[0VLi0R480THa0Woo0P00
0U:D0SW>0SF]0SW>0TYB0V]J0T8@0QcW0U:D0RU:0Woo0P000Tic00=oodicCW<00Sg_0SW>0THa0T8@
0THa0RDY0T8@0Sg_0S6<0Sg_0S6<0RU:0W_N0RDY0Tic0SW>0Sg_0THa0TYB0T8@0RU:0V]J0P000Woo
0QBU0VLi0S6<0UJe0Re[0SW>0Sg_0RDY0THa0Sg_0T8@0THa148@0SF]0SW>0T8@0U[F0SF]0TYB0QBU
0P000Sg_0SW>0T8@0S6<0TYB0SF]0TYB0RDY148@0SW>0S6<0SF]0SW>0V]J0RU:0TYB1Goo0@000Goo
0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009oo`@000Ioo`80009ooaH0009o
o`80009oo`9>L`8icP@0008DY@9oo`9>L`8HaP9:DP80009oo`8aS08e[@8aS09>L`80009oo`9Nm`8<
H`9oo`96<@92408e[@8]J`9W>@8Q2096<@9oo`80009BU08icP8e[@8icP9:DP9[FP92408Li`9BU08Y
BP9oo`80009>L`03Oom>Ldic008mk`8icP96<@924096<@8U:@92408mk`8aS08mk`8aS08YBP9kgP8U
:@9>L`8icP8mk`96<@9:DP92408YBP9[FP80009oo`8DY@9W>@8aS09F]@8]J`8icP8mk`8U:@96<@8m
k`924096<@A2408e[@8icP92409JeP8e[@9:DP8DY@80008mk`8icP92408aS09:DP8e[@9:DP8U:@A2
408icP8aS08e[@8icP9[FP8YBP9:DPEoo`40005oo`0027oo0P0017oo0P001Goo00<007ooOol017oo
0W>L0P000SF]0P000Woo0P0027oo0UJe27oo0P000Woo0P000Woo0RU:0SF]0T8@17oo0RU:0P000QcW
1Woo0P000SW>0U[F0Woo0P@Q0W>L0QcW0T8@0RDY0T8@0P000Sg_0V<H0PaS0V]J0RDY0Woo0Sg_0QBU
0U[F0QcW0Sg_0VLi0Re[0Ukg0SF]0U:D0R480V<H0P000Woo0P000cW>0THa0SW>0Tic0RU:0THa0U:D
0RDY0VLi0U[F0S6<0TYB0RDY0UJe0T8@0SW>0TYB0THa0UJe0QcW0RDY136<0T8@0Re[0THa0RU:0T8@
0S6<0U:D0RU:0T8@0Tic0S6<0Sg_0SF]0THa0TYB0U:D0S6<0TYB0S6<0Tic0SW>0U:D0SF]0Re[0THa
0TYB0S6<148@0Sg_148@0Re[0SW>0U:D13F]0Re[0QcW0TYB0T8@1Goo0@000Goo000EOol00`00Oomo
o`04Ool2Li`20002=Jd20002Ool20008Ool2E[D8Ool20002Ool20002Ool2:DX2=Jd2@Q04Ool2:DX2
00027>L6Ool20002>Lh2F]H2Ool21242Li`27>L2@Q029BT2@Q020002?Nl2HaP236<2JeX29BT2Ool2
?Nl25:D2F]H27>L2?Nl2IcT2;F/2G_L2=Jd2DY@28@P2HaP20002Ool20003>Lh2AS42>Lh2CW<2:DX2
AS42DY@29BT2IcT2F]H2<H`2BU829BT2E[D2@Q02>Lh2BU82AS42E[D27>L29BT4<H`2@Q02;F/2AS42
:DX2@Q02<H`2DY@2:DX2@Q02CW<2<H`2?Nl2=Jd2AS42BU82DY@2<H`2BU82<H`2CW<2>Lh2DY@2=Jd2
;F/2AS42BU82<H`4@Q02?Nl4@Q02;F/2>Lh2DY@4=Jd2;F/27>L2BU82@Q05Ool10001Ool001Eoo`03
001oogoo009oo`9:DP848@9oo`80009oo`80009oo`9BU0@000Aoo`@0009oo`8aS09oo`80009oo`80
009oo`80009oo`H0009oo`8@Q09F]@8aS0H0009oo`80009F]@8e[@92409:DP8icP9BU0848@9oo`80
009oo`80009oo`80009kgP8]J`8icP8aS08@Q092408U:@88@P9:DP8mk`9>L`9_N`80009oo`800003
OolicSW>009:DP8mk`9BU09JePABU08U:@92408@Q08aS09JeP8YBP9kgP9_N`8Q209kgP80009BU08e
[@8mk`8e[@A6<@9:DP8aS08e[@8mk`@icP@mk`924096<@8YBP9S608e[@92408YBP9Nm`8e[@9>L`8]
J`8mk`9JeP8e[@8mk`8aS09:DP8]J`A2408mk`8aS09BU092408e[@8YBP8icP9:DP8icP8]J`9:DP9>
L`Eoo`40005oo`005Goo00<007ooOol00Woo0TYB0P@Q0Woo0P000Woo0P000Woo0U:D100017oo1000
0Woo0S6<0Woo0P000Woo0P000Woo0P000Woo1P000Woo0Q240UJe0S6<1P000Woo0P000UJe0SF]0T8@
0TYB0SW>0U:D0P@Q0Woo0P000Woo0P000Woo0P000W_N0Re[0SW>0S6<0Q240T8@0RDY0PQ20TYB0Sg_
0Tic0Vmk0P000Woo0P0000=oocW>>Lh00TYB0Sg_0U:D0U[F15:D0RDY0T8@0Q240S6<0U[F0RU:0W_N
0Vmk0R480W_N0P000U:D0SF]0Sg_0SF]14Ha0TYB0S6<0SF]0Sg_13W>13g_0T8@0THa0RU:0V<H0SF]
0T8@0RU:0Ukg0SF]0Tic0Re[0Sg_0U[F0SF]0Sg_0S6<0TYB0Re[148@0Sg_0S6<0U:D0T8@0SF]0RU:
0SW>0TYB0SW>0Re[0TYB0Tic1Goo0@000Goo000EOol00`00Oomoo`02Ool2;F/2@Q020002Ool20002
Ool20004Ool60004Ool2;F/2Ool25:D2Ool2BU820002Ool2=Jd224820004Ool2AS429BT2JeX20006
Ool20002Kg/2@Q02CW<2@Q04;F/2F]H20002Ool20002Ool20002@Q02BU82G_L29BT2AS4212420002
Ool28@P2JeX2DY@2CW<2<H`20002Ool20002Ool00acW00000002IcT2<H`2=Jd2F]H28@P2<H`2?Nl2
<H`22482JeX25:D2Li`2>Lh236<2IcT25:D2JeX2=Jd2AS42>Lh2AS42?Nl2BU82<H`2>Lh28@P2BU82
?Nl2=Jd2@Q029BT2CW<25:D27>L2E[D26<H236<29BT2@Q02;F/2IcT2>Lh2CW<2>Lh2G_L2HaP2AS42
;F/2@Q04?Nl2BU829BT2Ool2CW<2AS428@P4>Lh2DY@2Ool2HaP2?Nl5Ool10001Ool001Eoo`03001o
ogoo009oo`8]J`924080009oo`80009oo`8000Aoo`H000Aoo`8]J`9oo`8DY@9oo`9:DP80009oo`8e
[@88@P8000Aoo`96<@8U:@9[FP8000Ioo`80009_N`92409>L`9240@]J`9JeP80009oo`80009oo`80
0092409:DP9Nm`8U:@96<@848@80009oo`8Q209[FP9BU09>L`8aS080009oo`80009oo`037>L00000
009W>@8aS08e[@9JeP8Q208aS08mk`8aS088@P9[FP8DY@9cW08icP8<H`9W>@8DY@9[FP8e[@96<@8i
cP96<@8mk`9:DP8aS08icP8Q209:DP8mk`8e[@92408U:@9>L`8DY@8Li`9F]@8HaP8<H`8U:@92408]
J`9W>@8icP9>L`8icP9Nm`9S6096<@8]J`9240@mk`9:DP8U:@9oo`9>L`96<@8Q20@icP9BU09oo`9S
608mk`Eoo`40005oo`005Goo00<007ooOol017oo0P000Woo0P000Woo0P000UJe0QBU0P001Woo1000
0Woo0VLi0W>L0QS60U:D0UJe0SF]0RU:0R480Woo10000S6<0VLi0V<H0Woo10000Woo0P000RU:0UJe
0Sg_0W>L0S6<0Ukg0P000Woo0P000Woo0P@Q0U:D0SW>0SF]0Sg_0THa0Sg_0THa0SW>0RDY0TYB0Sg_
0SW>0Sg_0QcW0W>L0PQ20Woo0PaS00<004YBBU800SW>0T8@0TYB0SW>0TYB0SW>0THa0SF]0U[F0THa
0Tic12e[0QS60V]J0P000UJe0SW>0T8@0SW>0Re[0THa0T8@0Re[0U:D0Re[0RU:0THa0Sg_0U[F0RDY
0Vmk0W>L0TYB0Sg_0UJe0U:D0T8@13g_148@0Sg_0T8@0SF]0Sg_0SW>0T8@2Sg_0SF]0Sg_0RDY23F]
0Re[0Sg_0S6<1Goo0@000Goo000EOol20005Ool20002Ool20002Ool20002E[D25:D20006Ool40002
Ool2IcT2Li`26<H2DY@2E[D2=Jd2:DX28@P2Ool40002<H`2IcT2HaP2Ool40002Ool20002:DX2E[D2
?Nl2Li`2<H`2G_L20002Ool20002Ool21242DY@2>Lh2=Jd2?Nl2AS42?Nl2AS42>Lh29BT2BU82?Nl2
>Lh2?Nl27>L2Li`22482Ool236<00`00BU9:DP02>Lh2@Q02BU82>Lh2BU82>Lh2AS42=Jd2F]H2AS42
CW<4;F/26<H2JeX20002E[D2>Lh2@Q02>Lh2;F/2AS42@Q02;F/2DY@2;F/2:DX2AS42?Nl2F]H29BT2
Kg/2Li`2BU82?Nl2E[D2DY@2@Q04?Nl4@Q02?Nl2@Q02=Jd2?Nl2>Lh2@Q0:?Nl2=Jd2?Nl29BT8=Jd2
;F/2?Nl2<H`4Ool20001Ool001Eoo`03001oogoo00Ioo`848@8U:@96<@9oo`8icP9:DP9oo`8e[@8D
Y@80009S609F]@9:DP9kgP8Li`9Nm`8]J`92408aS08Q208aS09BU0Aoo`9F]@8YBP8<H`80009S6096
<@8Li`9oo`80008HaP9BU08icP8e[@848@9oo`8HaP88@P8<H`9_N`96<@9:DP8e[@8aS08icP9240@e
[@9JeP8mk`8Q209_N`8U:@8aS09oo`96<@80009W>@03?NlQ2248008aS08mk`8icP92409Nm`8YBP9:
DP8aS08Li`9:DPA2408e[@9S608icPA6<@8icP9F]@9S608Li`9Nm`8icP8e[@8YBP9F]@8mk`9cW08Y
BP9BU08]J`8Q209oo`8@Q09:DP8icP96<@8YBP9>L`8]J`8mk`8aS08icP92408e[@96<@9:DP8icP92
40@mk`92408icP9:DP96<@@mk`96<@924096<@9>L`92408mk`Eoo`40005oo`005Goo00<007ooOol0
1Woo0P@Q0RDY0THa0Woo0SW>0TYB0Woo0SF]0QBU0P000V<H0UJe0TYB0W_N0QcW0Ukg0Re[0T8@0S6<
0R480S6<0U:D17oo0UJe0RU:0PaS0P000V<H0THa0QcW0Woo0P000QS60U:D0SW>0SF]0P@Q0Woo0QS6
0PQ20PaS0Vmk0THa0TYB0SF]0S6<0SW>0T8@13F]0U[F0Sg_0R480Vmk0RDY0S6<0Woo0THa0P000VLi
00<mkb488@P00S6<0Sg_0SW>0T8@0Ukg0RU:0TYB0S6<0QcW0TYB148@0SF]0V<H0SW>14Ha0SW>0UJe
0V<H0QcW0Ukg0SW>0SF]0RU:0UJe0Sg_0W>L0RU:0U:D0Re[0R480Woo0Q240TYB0SW>0THa0RU:0Tic
0Re[0Sg_0S6<0SW>0T8@0SF]0THa0TYB0SW>0T8@13g_0T8@0SW>0TYB0THa13g_0THa0T8@0THa0Tic
0T8@0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`212420002>Lh20002:DX28@P2<H`2=Jd2
@Q04Kg/4CW<2DY@2=Jd2DY@2F]H2@Q02AS42<H`2CW<20002?Nl2@Q040002CW<4Ool236<2Mkd2>Lh2
9BT2Ool20002>Lh2F]H2;F/2Ool40002Mkd2CW<2Mkd2=Jd2CW<2>Lh2Ool2@Q02?Nl2>Lh2DY@2BU82
7>L2BU84:DX2CW<2F]H2AS4248@2@Q000cg_>LhicP02?Nl2AS42=Jd2DY@2CW<2AS42;F/2DY@2<H`2
=Jd2?Nl4@Q02AS425:D2AS42=Jd2?Nl2@Q04;F/2=Jd2?Nl2CW<2:DX4@Q020002Ool2?Nl2AS428@P2
Mkd2E[D2;F/2AS42?Nl28@P2F]H2;F/2?Nl2>Lh2?Nl2DY@2<H`26<H2:DX2BU82?Nl2@Q02?Nl2@Q02
:DX2?Nl2HaP2>Lh2E[D4>Lh2E[D2<H`2AS4248@5Ool10001Ool001Eoo`03001oogoo009oo`8aS084
8@80008icP80008YBP8Q208aS08e[@9240A_N`A>L`9BU08e[@9BU09JeP924096<@8aS09>L`80008m
k`9240@0009>L`Aoo`8<H`9g_@8icP8U:@9oo`80008icP9JeP8]J`9oo`@0009g_@9>L`9g_@8e[@9>
L`8icP9oo`92408mk`8icP9BU09:DP8Li`9:DP@YBP9>L`9JeP96<@8@Q0924003?NlicSW>008mk`96
<@8e[@9BU09>L`96<@8]J`9BU08aS08e[@8mk`A24096<@8DY@96<@8e[@8mk`9240@]J`8e[@8mk`9>
L`8YBPA24080009oo`8mk`96<@8Q209g_@9F]@8]J`96<@8mk`8Q209JeP8]J`8mk`8icP8mk`9BU08a
S08HaP8YBP9:DP8mk`92408mk`92408YBP8mk`9S608icP9F]@@icP9F]@8aS096<@8@Q0Eoo`40005o
o`005Goo00<007ooOol00Woo0V<H0W>L0SF]0Woo0V<H0QBU0SF]0Q240S6<0R480TYB0V]J0P000T8@
0QcW0Woo0QS60V]J0WNm0QS60UJe0THa0Vmk0VLi0P000Tic0Woo0Q240P000QS617oo0QS60RDY0T8@
0Woo0P000Woo0PaS0P000Woo0V<H0QBU0Woo0PQ20R480TYB0U:D0RDY0U:D0TYB0SW>0QcW0P000V<H
0TYB0UJe0SW>0Sg_0THa0Tic0V]J0R4800<YBTYBBU800S6<0Sg_0SF]0UJe0Ukg0RU:0UJe0T8@0SF]
0S6<0T8@0THa0R480RU:0T8@0Ukg0U[F0U:D0Re[0SF]0QcW0V<H0Tic0U:D0TYB0Re[0U:D0T8@0Q24
0Sg_0QcW0U[F0RU:0TYB0S6<0RU:0Woo0U:D13W>0Re[14Ha0R480UJe0SF]0QBU0TYB0Tic0RU:0THa
0SW>0THa0Sg_0QBU0U[F0RDY0SF]0THa0Sg_0TYB0Re[0Sg_1Goo0@000Goo000EOol00`00Oomoo`02
Ool2HaP2Li`2=Jd2Ool2HaP25:D2=Jd248@2<H`28@P2BU82JeX20002@Q027>L2Ool26<H2JeX2Mkd2
6<H2E[D2AS42Kg/2IcT20002CW<2Ool248@200026<H4Ool26<H29BT2@Q02Ool20002Ool236<20002
Ool2HaP25:D2Ool224828@P2BU82DY@29BT2DY@2BU82>Lh27>L20002HaP2BU82E[D2>Lh2?Nl2AS42
CW<2JeX28@P00bU:BU9:DP02<H`2?Nl2=Jd2E[D2G_L2:DX2E[D2@Q02=Jd2<H`2@Q02AS428@P2:DX2
@Q02G_L2F]H2DY@2;F/2=Jd27>L2HaP2CW<2DY@2BU82;F/2DY@2@Q0248@2?Nl27>L2F]H2:DX2BU82
<H`2:DX2Ool2DY@4>Lh2;F/4AS428@P2E[D2=Jd25:D2BU82CW<2:DX2AS42>Lh2AS42?Nl25:D2F]H2
9BT2=Jd2AS42?Nl2BU82;F/2?Nl5Ool10001Ool001Eoo`03001oogoo009oo`8Li`9oo`@00096<@9:
DP96<@9JeP9F]@8]J`848@80009>L`9Nm`96<@9:DP8aS092408mk`9BU08mk`9JeP9:DP9[FP9_N`9W
>@80008icP9g_@9_N`8Li`8aS09JeP8Q209:DP8YBP9oo`8000Aoo`80008@Q09S608DY@92409:DP96
<@8aS08Q208Li`@mk`8@Q096<@8YBP9kgP8]J`9kgP8HaP9F]@8U:@8DY@9F]@038@Q6<DHa009>L`96
<@8U:@8mk`A2408mk`9JeP8icP9>L`8aS09>L`8U:@9:DP8e[@9240@e[@8icP92408HaP8mk`8e[@9[
FP88@P8aS08icP8mk`9:DP8YBP9F]@8aS09F]@8mk`8]J`A240Hmk`96<@@aS096<@9F]@92408YBP8]
J`8e[@8icP8mk`92408e[@8aS092408mk`8icP9>L`8e[@8mk`9>L`8mk`96<@Eoo`40005oo`005Goo
00<007ooOol00Woo0QcW0Woo10000THa0TYB0THa0U[F0UJe0Re[0P@Q0P000Tic0Ukg0THa0TYB0S6<
0T8@0Sg_0U:D0Sg_0U[F0TYB0V]J0Vmk0VLi0P000SW>0WNm0Vmk0QcW0S6<0U[F0R480TYB0RU:0Woo
0P0017oo0P000Q240V<H0QBU0T8@0TYB0THa0S6<0R480QcW13g_0Q240THa0RU:0W_N0Re[0W_N0QS6
0UJe0RDY0QBU0UJe00<Q24HaAS400Tic0THa0RDY0Sg_148@0Sg_0U[F0SW>0Tic0S6<0Tic0RDY0TYB
0SF]0T8@13F]0SW>0T8@0QS60Sg_0SF]0V]J0PQ20S6<0SW>0Sg_0TYB0RU:0UJe0S6<0UJe0Sg_0Re[
148@1Sg_0THa136<0THa0UJe0T8@0RU:0Re[0SF]0SW>0Sg_0T8@0SF]0S6<0T8@0Sg_0SW>0Tic0SF]
0Sg_0Tic0Sg_0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42>Lh2Ool2Li`20002=Jd4?Nl2
BU82DY@2F]H25:D2;F/27>L2:DX26<H2AS44BU82CW<224820002Mkd2@Q02E[D2=Jd2Ool2DY@25:D2
0002HaP22482:DX2G_L27>L224828@P2Ool20004Mkd29BT2?Nl2<H`2@Q0248@2Ool2=Jd2@Q02AS42
?Nl2CW<2G_L2AS428@P26<H2DY@2@Q04<H`2Kg/2@Q02:DX00eJeF]IJeP02<H`29BT2AS44@Q04>Lh2
=Jd2BU82?Nl2>Lh2=Jd2HaP2:DX2BU82<H`2Mkd2F]H2AS42F]H2?Nl2@Q02=Jd2>Lh2Mkd2?Nl2=Jd2
HaP20002E[D2<H`2:DX2AS42>Lh2?Nl2>Lh4?Nl2>Lh2AS425:D2=Jd28@P2?Nl2BU82?Nl2@Q02AS42
@Q02?Nl2@Q02>Lh2CW<29BT2;F/2AS42=Jd2?Nl2E[D2?Nl2:DX2>Lh2HaP5Ool10001Ool001Eoo`80
00=oo`96<@8icP9oo`9cW080008e[@@mk`9:DP9BU09JeP8DY@8]J`8Li`8YBP8HaP96<@A:DP9>L`88
@P80009g_@92409F]@8e[@9oo`9BU08DY@80009S6088@P8YBP9Nm`8Li`88@P8Q209oo`8000Ag_@8U
:@8mk`8aS092408@Q09oo`8e[@924096<@8mk`9>L`9Nm`96<@8Q208HaP9BU09240@aS09_N`92408Y
BP03E[EJeU[F008aS08U:@96<@A240@icP8e[@9:DP8mk`8icP8e[@9S608YBP9:DP8aS09g_@9JeP96
<@9JeP8mk`92408e[@8icP9g_@8mk`8e[@9S6080009F]@8aS08YBP96<@8icP8mk`8icP@mk`8icP96
<@8DY@8e[@8Q208mk`9:DP8mk`924096<@92408mk`92408icP9>L`8U:@8]J`96<@8e[@8mk`9F]@8m
k`8YBP8icP9S60Aoo`80005oo`005Goo00<007ooOol00Woo0P000SF]0Woo0PaS0Woo0TYB0T8@0Re[
0U:D0S6<0U:D0PaS0PQ21S6<0TYB0PaS0SF]12e[0S6<0P000Vmk0QBU0P000P@Q0QBU15kg0Tic0Woo
0RDY0RU:0Tic0W>L0QBU0Sg_0Woo0P000P@Q0SW>0T8@0U[F0QcW0Woo0P000SF]0RU:0T8@0Sg_0S6<
0SF]0Re[0U:D0QcW0P000THa0Sg_0THa0TYB0THa0Tic00<aS5:DDY@00P000TYB0SW>0TYB0SF]0THa
0Sg_0SW>0THa0T8@14Ha0TYB0RU:0SW>0Tic0QcW0V]J0TYB0Re[0TYB0QS60Ukg0RU:0Sg_0QcW0VLi
0P000Woo0R480U[F0THa0RDY0T8@0THa0Sg_0THa0SF]0Tic0THa0Woo0Q240W_N0RDY0W_N0SF]0Tic
0SW>0T8@13g_0T8@0S6<0SW>0THa0SW>0T8@0Ukg0T8@0THa0QS60V<H0RU:1Goo0@000Goo000EOol0
0`00Oomoo`02Ool20002=Jd2Ool236<2Ool2BU82@Q02;F/2DY@2<H`2DY@236<22486<H`2BU8236<2
=Jd4;F/2<H`20002Kg/25:D2000212425:D4G_L2CW<2Ool29BT2:DX2CW<2Li`25:D2?Nl2Ool20002
1242>Lh2@Q02F]H27>L2Ool20002=Jd2:DX2@Q02?Nl2<H`2=Jd2;F/2DY@27>L20002AS42?Nl2AS42
BU82AS42CW<00c6<DYABU0020002BU82>Lh2BU82=Jd2AS42?Nl2>Lh2AS42@Q04AS42BU82:DX2>Lh2
CW<27>L2JeX2BU82;F/2BU826<H2G_L2:DX2?Nl27>L2IcT20002Ool28@P2F]H2AS429BT2@Q02AS42
?Nl2AS42=Jd2CW<2AS42Ool248@2Nmh29BT2Nmh2=Jd2CW<2>Lh2@Q04?Nl2@Q02<H`2>Lh2AS42>Lh2
@Q02G_L2@Q02AS426<H2HaP2:DX5Ool10001Ool001Eoo`03001oogoo009oo`9F]@8YBP8aS08YBP80
008U:@8icP8]J`8HaP8DY@80008aS09kgP92408HaP8]J`9BU092408e[@9F]@9JeP80009Nm`9:DP9B
U09W>@9:DP96<@8U:@8e[@8mk`800096<@8000848@9[FP96<@9JeP80009oo`9S608mk`9>L`8]J`8U
:@8e[@9Nm`9>L`8HaP8e[@9:DP8e[@9S608Q209>L`8Li`9W>@9Nm`8YBP9Nm`8icP9BU08icP03@Q0e
[CF]008mk`92408e[@9>L`9BU08U:@@mk`9:DP8icP92408icP8e[@96<@9>L`@]J`9:DP8YBP9JeP8H
aP88@P8aS092408@Q0848@8e[@9oo`848@9[FP8mk`8@Q09>L`9:DP8mk`92409BU08aS08YBP9_N`8H
aP92408Li`I6<@8U:@9:DP8icPHmk`92408YBP@]J`96<@8icP9JeP8aS09240@mk`Eoo`40005oo`00
5Goo00<007ooOol00Woo0UJe0RU:0S6<0RU:0P000RDY0SW>0Re[0QS60QBU0P000S6<0W_N0T8@0QS6
0Re[0U:D0T8@0SF]0UJe0U[F0P000Ukg0TYB0U:D0VLi0TYB0THa0RDY0SF]0Sg_0P000THa0P000P@Q
0V]J0THa0U[F0P000Woo0V<H0Sg_0Tic0Re[0RDY0SF]0Ukg0Tic0QS60SF]0TYB0SF]0V<H0R480Tic
0QcW0VLi0Ukg0RU:0Ukg0SW>0U:D0SW>00=243F]=Jd00Sg_0T8@0SF]0Tic0U:D0RDY13g_0TYB0SW>
0T8@0SW>0SF]0THa0Tic12e[0TYB0RU:0U[F0QS60PQ20S6<0T8@0Q240P@Q0SF]0Woo0P@Q0V]J0Sg_
0Q240Tic0TYB0Sg_0T8@0U:D0S6<0RU:0Vmk0QS60T8@0QcW1THa0RDY0TYB0SW>1Sg_0T8@0RU:12e[
0THa0SW>0U[F0S6<0T8@13g_1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS420002:DX2@Q06?Nl2
CW<2F]H2BU82HaP2IcT2Mkd2Ool2HaP248@2BU82?Nl2@Q02<H`2BU82>Lh2BU82?Nl2=Jd2CW<2>Lh2
IcT2@Q02F]H2Kg/2AS42HaP2AS42BU82HaP2?Nl2F]H2?Nl2AS429BT21242?Nl2=Jd2@Q04?Nl2BU82
@Q06?Nl4=Jd2>Lh2<H`2;F/2:DX2CW<28@P2<H`2E[D2;F/3CW<2?Nl2BU82?Nl2;F/2>Lh2BU82CW<4
@Q02>Lh2BU82=Jd2F]H2@Q02AS42DY@2?Nl2=Jd2?Nl2DY@2@Q02:DX2>Lh2@Q02G_L2@Q02E[D27>L2
Ool2>Lh2G_L2CW<29BT2@Q02?Nl2BU82AS44?Nl2AS42?Nl4@Q02>Lh2AS4@?Nl2AS42?Nl2>Lh2:DX2
@Q027>L6@Q02CW<5Ool10001Ool001Eoo`03001oogoo009oo`96<@80008YBP9240Hmk`9>L`9JeP9:
DP9S609W>@9g_@9oo`9S608@Q09:DP8mk`92408aS09:DP8icP9:DP8mk`8e[@9>L`8icP9W>@92409J
eP9_N`96<@9S6096<@9:DP9S608mk`9JeP8mk`96<@8U:@848@8mk`8e[@9240@mk`9:DP9240Hmk`@e
[@8icP8aS08]J`8YBP9>L`8Q208aS09F]@8]J`=>L`8mk`9:DP8mk`8]J`8icP9:DP9>L`A2408icP9:
DP8e[@9JeP924096<@9BU08mk`8e[@8mk`9BU092408YBP8icP92409Nm`92409F]@8Li`9oo`8icP9N
m`9>L`8U:@92408mk`9:DP96<@@mk`96<@8mk`A2408icP96<A0mk`96<@8mk`8icP8YBP92408Li`I2
409>L`Eoo`40005oo`005Goo00<007ooOol00Woo0RU:0Ukg0U:D0S6<0TYB0Tic0Sg_0RU:0T8@0SF]
0Tic0THa0P000SW>14ic0QcW0TYB0SF]0U[F0RU:0SF]0Sg_0Vmk0U[F0Re[0V<H0THa0Ukg0U:D0Re[
0RDY0Ukg0RU:0QBU0U[F148@0Re[17_N0SF]0TYB0SF]0U[F0THa0U:D0S6<148@0Sg_0T8@0Tic0SW>
0SF]0THa0RU:0TYB0Sg_0VLi13W>0T8@0bU:0TYB0Sg_0SF]0U:D0TYB0SF]0SW>148@0THa0TYB0Re[
0THa0Re[0RU:0QcW0SW>0Tic0TYB0T8@0TYB0THa0T8@0Sg_0S6<0Tic0SF]0VLi0S6<0Re[0TYB0THa
0TYB0Sg_0THa1SW>0U:D1Sg_0T8@0Sg_0SF]0UJe0T8@2Sg_0T8@0SF]0UJe0U:D0Sg_0T8@0RU:0W>L
0TYB0SW>0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2:DX2G_L2DY@2<H`2BU82CW<2?Nl2:DX2
@Q02=Jd2CW<2AS420002>Lh4CW<27>L2BU82=Jd2F]H2:DX2=Jd2?Nl2Kg/2F]H2;F/2HaP2AS42G_L2
DY@2;F/29BT2G_L2:DX25:D2F]H4@Q02;F/4Nmh2=Jd2BU82=Jd2F]H2AS42DY@2<H`4@Q02?Nl2@Q02
CW<2>Lh2=Jd2AS42:DX2BU82?Nl2IcT4>Lh2@Q03:DX2BU82?Nl2=Jd2DY@2BU82=Jd2>Lh4@Q02AS42
BU82;F/2AS42;F/2:DX27>L2>Lh2CW<2BU82@Q02BU82AS42@Q02?Nl2<H`2CW<2=Jd2IcT2<H`2;F/2
BU82AS42BU82?Nl2AS46>Lh2DY@6?Nl2@Q02?Nl2=Jd2E[D2@Q0:?Nl2@Q02=Jd2E[D2DY@2?Nl2@Q02
:DX2Li`2BU82>Lh2@Q05Ool10001Ool001Eoo`03001oogoo009oo`8aS09:DP8DY@8mk`8e[@@mk`9S
608mk`92409[FP92409>L`96<@9oo`8Q209:DP92409BU08e[@8U:@9Nm`88@P8e[@9F]@8mk`96<@8e
[@8icP96<@8Li`8]J`8aS09:DP9cW08Li`9:DP9[FP8Q208]J`8DY@8mk`92408]J`8icP8]J`8icP8e
[@9>L`@mk`9BU09:DP9>L`96<@8mk`@icP96<@8mk`9BU08Li`9:DP03>Lh]Jbe[009:DP8mk`8e[@9:
DP8YBP8]J`8e[@8YBP8e[@Pmk`96<@8Q209:DP96<@8e[@92408Li`9Nm`92408]J`9BU08e[@8YBP9F
]@8]J`9S60A:DP@icP92408YBP9:DP8]J`9Nm`8e[@8mk`96<@9Nm`9F]@A240@e[@9240Hmk`8icP9>
L`8mk`9F]@8U:@92408mk`9>L`8e[@A2408mk`Eoo`40005oo`005Goo0P000goo0S6<0TYB0QBU0Sg_
0SF]13g_0V<H0Sg_0T8@0V]J0T8@0Tic0THa0Woo0R480TYB0T8@0U:D0SF]0RDY0Ukg0PQ20SF]0UJe
0Sg_0THa0SF]0SW>0THa0QcW0Re[0S6<0TYB0W>L0QcW0TYB0V]J0R480Re[0QBU0Sg_0T8@0Re[0SW>
0Re[0SW>0SF]0Tic13g_0U:D0TYB0Tic0THa0Sg_13W>0THa0Sg_0U:D0QcW0TYB00<icRe[;F/00TYB
0Sg_0SF]0TYB0RU:0Re[0SF]0RU:0SF]23g_0THa0R480TYB0THa0SF]0T8@0QcW0Ukg0T8@0Re[0U:D
0SF]0RU:0UJe0Re[0V<H14YB13W>0T8@0RU:0TYB0Re[0Ukg0SF]0Sg_0THa0Ukg0UJe148@13F]0T8@
1Sg_0SW>0Tic0Sg_0UJe0RDY0T8@0Sg_0Tic0SF]148@0Sg_17oo0P000Goo000EOol00`00Oomoo`02
Ool29BT2F]H2@Q020002Mkd2?Nl2=Jd4DY@2?Nl2Kg/2>Lh2=Jd2?Nl29BT2@Q02JeX2=Jd2HaP2F]H2
@Q02E[D2Kg/29BT2>Lh2=Jd4AS42=Jd236<20002<H`2>Lh2=Jd27>L26<H2=Jd2?Nl2HaP2E[D2HaP2
?Nl2>Lh20002:DX2JeX2AS42?Nl2=Jd2@Q02>Lh2E[D2<H`21242:DX4>Lh2Nmh2<H`29BT2AS42DY@2
<H`3?Nl2E[D2?Nl2IcT28@P2;F/2=Jd2@Q029BT2AS42?Nl2@Q06?Nl2>Lh2@Q02>Lh2F]H4=Jd20002
E[D2AS42@Q02:DX4CW<2@Q021242@Q02?Nl2;F/2>Lh2;F/2@Q02>Lh25:D4=Jd2@Q02BU82<H`2?Nl2
>Lh2<H`2BU86@Q02?Nl2@Q02>Lh2AS44CW<26<H2BU82=Jd28@P2;F/2@Q02>Lh2;F/5Ool10001Ool0
01Eoo`03001oogoo009oo`8U:@9JeP924080009g_@8mk`8e[@ABU08mk`9_N`8icP8e[@8mk`8U:@92
409[FP8e[@9S609JeP92409F]@9_N`8U:@8icP8e[@A6<@8e[@8<H`80008aS08icP8e[@8Li`8HaP8e
[@8mk`9S609F]@9S608mk`8icP80008YBP9[FP96<@8mk`8e[@92408icP9F]@8aS0848@8YBP@icP9k
gP8aS08U:@96<@9BU08aS0<mk`9F]@8mk`9W>@8Q208]J`8e[@92408U:@96<@8mk`9240Hmk`8icP92
408icP9JeP@e[@80009F]@96<@92408YBPA>L`9240848@92408mk`8]J`8icP8]J`92408icP8DY@@e
[@92409:DP8aS08mk`8icP8aS09:DPI2408mk`92408icP96<@A>L`8HaP9:DP8e[@8Q208]J`92408i
cP8]J`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@0Tic0R480Woo0SF]0SW>0U:D0T8@0R480Sg_
0Woo0T8@13F]0U[F0V<H0R480RDY0RU:0RDY0SW>0Ukg0P@Q0UJe0SW>0V<H0Re[0S6<0V]J0SW>17oo
0Tic0Sg_0THa0W_N0RU:0U[F0RU:0V<H0Q240TYB0T8@0Woo0SW>0S6<0T8@0U:D0SW>0SF]0TYB0Sg_
0RU:0SF]0Tic0THa0SF]0Tic0VLi0QS60RDY0U[F0dYB0SF]0UJe0Re[0Tic0SW>0TYB14Ha0TYB0U:D
0Tic13g_0THa0T8@0VLi0SW>0Sg_0SF]0SW>0TYB0Ukg0SF]0S6<0Tic0TYB0V]J0SW>0TYB0THa0S6<
0TYB0S6<0SF]0TYB0Sg_0SW>0V<H0Sg_0TYB0SF]0U:D0Sg_0T8@0S6<0U:D0Sg_0T8@13W>0T8@0SW>
0T8@0U:D13F]23g_0T8@0Sg_0T8@0TYB1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02CW<28@P2
Ool2=Jd2>Lh2DY@2@Q028@P2?Nl2Ool2@Q04=Jd2F]H2HaP28@P29BT2:DX29BT2>Lh2G_L21242E[D2
>Lh2HaP2;F/2<H`2JeX2>Lh4Ool2CW<2?Nl2AS42Nmh2:DX2F]H2:DX2HaP248@2BU82@Q02Ool2>Lh2
<H`2@Q02DY@2>Lh2=Jd2BU82?Nl2:DX2=Jd2CW<2AS42=Jd2CW<2IcT26<H29BT2F]H3BU82=Jd2E[D2
;F/2CW<2>Lh2BU84AS42BU82DY@2CW<4?Nl2AS42@Q02IcT2>Lh2?Nl2=Jd2>Lh2BU82G_L2=Jd2<H`2
CW<2BU82JeX2>Lh2BU82AS42<H`2BU82<H`2=Jd2BU82?Nl2>Lh2HaP2?Nl2BU82=Jd2DY@2?Nl2@Q02
<H`2DY@2?Nl2@Q04>Lh2@Q02>Lh2@Q02DY@4=Jd8?Nl2@Q02?Nl2@Q02BU85Ool10001Ool001Eoo`03
001oogoo009oo`96<@8e[@96<@8U:@8YBP96<@9BU08mk`8icP8]J`8Li`9[FP8e[@AJeP8@Q09:DP9F
]@8U:@9F]@8icP8YBP9cW0@]J`80008U:@92408Q2096<@8DY@9BU0A>L`8Q208Li`8YBP8aS08YBP8U
:@9F]@8e[@9Nm`9>L`9W>@8icP@aS09F]@9S608e[@92409F]@8e[@8icP8aS08]J`96<@8Q2092409S
608mk`8aS003;F]2448@008]J`9:DP8aS09JeP8icP8aS08e[@8]J`8U:@8aS0A2408e[@8aS08e[@9N
m`8]J`92409:DP8Q208e[@96<@8U:@9BU09:DP8mk`8e[@924096<@8YBP9>L`A6<@8e[@9BU08Q209>
L`8Li`96<@92409>L`8mk`8icP9JeP8]J`92409[FP8aS09BU096<@92408mk`92408aS09>L`96<@9F
]@Hmk`8e[@9>L`9240Eoo`40005oo`005Goo00<007ooOol00Woo0THa0SF]0THa0RDY0RU:0THa0U:D
0Sg_0SW>0Re[0QcW0V]J0SF]15[F0Q240TYB0UJe0RDY0UJe0SW>0RU:0W>L12e[0P000RDY0T8@0R48
0THa0QBU0U:D14ic0R480QcW0RU:0S6<0RU:0RDY0UJe0SF]0Ukg0Tic0VLi0SW>136<0UJe0V<H0SF]
0T8@0UJe0SF]0SW>0S6<0Re[0THa0R480T8@0V<H0Sg_0S6<00<]Jd8@@Q000Re[0TYB0S6<0U[F0SW>
0S6<0SF]0Re[0RDY0S6<148@0SF]0S6<0SF]0Ukg0Re[0T8@0TYB0R480SF]0THa0RDY0U:D0TYB0Sg_
0SF]0T8@0THa0RU:0Tic14Ha0SF]0U:D0R480Tic0QcW0THa0T8@0Tic0Sg_0SW>0U[F0Re[0T8@0V]J
0S6<0U:D0THa0T8@0Sg_0T8@0S6<0Tic0THa0UJe1Sg_0SF]0Tic0T8@1Goo0@000Goo000EOol00`00
Oomoo`02Ool2>Lh2JeX2BU82DY@2CW<2=Jd2>Lh4DY@2CW<2=Jd2:DX2@Q02:DX2G_L2Ool2=Jd4@Q02
6<H2?Nl2CW<2:DX4@Q02>Lh2HaP27>L2DY@2F]H2DY@2AS42<H`2BU84?Nl2BU82;F/29BT2HaP2=Jd2
AS429BT2@Q02=Jd2?Nl2=Jd2DY@2<H`2=Jd2>Lh2?Nl2DY@2?Nl2CW<2<H`4BU82?Nl2G_L236<2AS43
CW<28@P2DY@2>Lh4BU82@Q02CW<26<H2CW<2<H`2AS42?Nl2=Jd2DY@2?Nl2>Lh2:DX2DY@29BT2@Q02
AS42HaP2=Jd2E[D2BU82E[D2CW<2>Lh2AS42JeX2?Nl2BU82<H`2=Jd2>Lh2;F/2?Nl2CW<2@Q04?Nl2
>Lh4AS42=Jd2>Lh2@Q02;F/2>Lh2?Nl2=Jd2@Q02?Nl2AS42BU82?Nl6>Lh2AS42=Jd2?Nl2>Lh2?Nl5
Ool10001Ool000Uoo`<0009oo`8000Eoo`03001oogoo009oo`8icP9[FP9:DP9BU09>L`8e[@8icPAB
U09>L`8e[@8YBP92408YBP9Nm`9oo`8e[@A2408HaP8mk`9>L`8YBPA2408icP9S608Li`9BU09JeP9B
U096<@8aS09:DP@mk`9:DP8]J`8U:@9S608e[@96<@8U:@92408e[@8mk`8e[@9BU08aS08e[@8icP8m
k`9BU08mk`9>L`8aS0A:DP8mk`9Nm`8<H`96<@=>L`8Q209BU08icPA:DP92409>L`8HaP9>L`8aS096
<@8mk`8e[@9BU08mk`8icP8YBP9BU08U:@924096<@9S608e[@9F]@9:DP9F]@9>L`8icP96<@9[FP8m
k`9:DP8aS08e[@8icP8]J`8mk`9>L`9240@mk`8icPA6<@8e[@8icP92408]J`8icP8mk`8e[@92408m
k`96<@9:DP8mk`HicP96<@8e[@8mk`8icP8mk`Eoo`40005oo`002Woo00@007ooOol0009oo`03001o
ogoo009oo`03001oogoo009oo`8Q208e[@9[FP9>L`8U:@8e[@92408mk`8icP8e[@8mk`96<@ABU08U
:@8icP9JeP8mk`924096<@9:DPA6<@8DY@8mk`A2408aS08mk`9S6092408mk`A2408mk`8e[@8YBP8a
S092408mk`@icP8mk`8icP9:DP924096<@8aS09:DP96<@@mk`8aS09240@U:@8icP8YBPA:DP9_N`9:
DP8aS00336<aS36<0092408icPA>L`@e[@8mk`8aS0@mk`8icP9JeP8YBP8]J`924096<@92408]J`8Y
BP92408YBP9S608aS09>L`80008icP96<@8e[@8<H`8aS08mk`9>L`800096<@9:DP8mk`8YBPPmk`8i
cP92408aS0@mk`96<@92408mk`9240@mk`@icP8mk`92408mk`A:DP@icP8mk`8e[@Eoo`40005oo`00
1goo1@0000Eoo`00Oomoo`0000Aoo`8000=oo`8Q208e[@9[FP9>L`8U:@8e[@92408mk`8icP8e[@8m
k`96<@ABU08U:@8icP9JeP8mk`924096<@9:DPA6<@8DY@8mk`A2408aS08mk`9S6092408mk`A2408m
k`8e[@8YBP8aS092408mk`@icP8mk`8icP9:DP924096<@8aS09:DP96<@@mk`8aS09240@U:@8icP8Y
BPA:DP9_N`9:DP8aS00336<aS36<0092408icPA>L`@e[@8mk`8aS0@mk`8icP9JeP8YBP8]J`924096
<@92408]J`8YBP92408YBP9S608aS09>L`80008icP96<@8e[@8<H`8aS08mk`9>L`800096<@9:DP8m
k`8YBPPmk`8icP92408aS0@mk`96<@92408mk`9240@mk`@icP8mk`92408mk`A:DP@icP8mk`8e[@Ao
o`80005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`02Ool2G_L2F]H2E[D2
:DX2CW<2>Lh2@Q02<H`2CW<2F]H2AS42<H`2AS42?Nl29BT2DY@2@Q02>Lh2=Jd2?Nl2AS46>Lh2;F/2
>Lh2F]H2E[D2HaP2<H`2DY@2?Nl2>Lh2AS42:DX2=Jd4@Q02?Nl2>Lh2AS42:DX2>Lh2CW<2>Lh2BU82
<H`2BU84?Nl2@Q02>Lh2AS42@Q02:DX2CW<2@Q02DY@27>L2G_L2<H`2@Q02CW<00cg_BU9:DP02@Q02
DY@2@Q02CW<2=Jd2@Q02<H`2AS44?Nl2AS42>Lh4BU82?Nl2@Q02BU82>Lh2CW<2AS42BU82=Jd4;F/2
>Lh4@Q02BU82E[D4@Q02=Jd2E[D2>Lh8@Q02?Nl2>Lh2AS44@Q02BU82>Lh2@Q0:?Nl2@Q02>Lh2:DX2
<H`2@Q02>Lh2CW<2BU82>Lh2AS42<H`2BU85Ool10001Ool000Qoo`03001oo`00009oo`04001oogoo
0004Ool00`00Oomoo`02Ool2G_L2F]H2E[D2:DX2CW<2>Lh2@Q02<H`2CW<2F]H2AS42<H`2AS42?Nl2
9BT2DY@2@Q02>Lh2=Jd2?Nl2AS46>Lh2;F/2>Lh2F]H2E[D2HaP2<H`2DY@2?Nl2>Lh2AS42:DX2=Jd4
@Q02?Nl2>Lh2AS42:DX2>Lh2CW<2>Lh2BU82<H`2BU84?Nl2@Q02>Lh2AS42@Q02:DX2CW<2@Q02DY@2
7>L2G_L2<H`2@Q02CW<00cg_BU9:DP02@Q02DY@2@Q02CW<2=Jd2@Q02<H`2AS44?Nl2AS42>Lh4BU82
?Nl2@Q02BU82>Lh2CW<2AS42BU82=Jd4;F/2>Lh4@Q02BU82E[D4@Q02=Jd2E[D2>Lh8@Q02?Nl2>Lh2
AS44@Q02BU82>Lh2@Q0:?Nl2@Q02>Lh2:DX2<H`2@Q02>Lh2CW<2BU82>Lh2AS42<H`2BU85Ool10001
Ool000Uoo`8000=oo`8000Eoo`03001oogoo009oo`8e[@8]J`800096<@8Q208]J`A240He[@9F]@8a
S09:DP9JeP8e[@8]J`8aS092408mk`96<@9JeP@icP9JeP9:DP8]J`9F]@9>L`96<@8Li`8icP9>L`96
<@9F]@8aS09:DP800092409>L`8HaP92409:DP92408icP8aS08icP9>L`8aS092408mk`I2409BU09>
L`9JeP8<H`9:DP8mk`8]J`9:DP8U:@03=JdicSW>009F]@8aS0@mk`8icP9BU092408]J`8mk`92408]
J`8aS08icP8mk`8icPA2409F]@8icP9:DP9JeP8]J`92408e[@9>L`9Nm`8Q208Li`9BU08e[@9F]@Hm
k`8e[@8mk`9>L`8mk`92408mk`8HaP96<@9:DP8YBP9JeP8mk`9240Xmk`92409:DP92408mk`92408Y
BP8aS08mk`9>L`8icP8e[@Eoo`40005oo`005Goo00<007ooOol00Woo0SF]0Re[0P000THa0R480Re[
148@1SF]0UJe0S6<0TYB0U[F0SF]0Re[0S6<0T8@0Sg_0THa0U[F13W>0U[F0TYB0Re[0UJe0Tic0THa
0QcW0SW>0Tic0THa0UJe0S6<0TYB0P000T8@0Tic0QS60T8@0TYB0T8@0SW>0S6<0SW>0Tic0S6<0T8@
0Sg_1T8@0U:D0Tic0U[F0PaS0TYB0Sg_0Re[0TYB0RDY00<e[CW>>Lh00UJe0S6<13g_0SW>0U:D0T8@
0Re[0Sg_0T8@0Re[0S6<0SW>0Sg_0SW>148@0UJe0SW>0TYB0U[F0Re[0T8@0SF]0Tic0Ukg0R480QcW
0U:D0SF]0UJe1Sg_0SF]0Sg_0Tic0Sg_0T8@0Sg_0QS60THa0TYB0RU:0U[F0Sg_0T8@2Sg_0T8@0TYB
0T8@0Sg_0T8@0RU:0S6<0Sg_0Tic0SW>0SF]1Goo0@000Goo000EOol00`00Oomoo`02Ool2BU82<H`2
JeX2?Nl2IcT2G_L2>Lh2BU82AS429BT2CW<26<H2;F/2G_L2CW<2=Jd2:DX2BU84@Q02<H`2BU82>Lh2
F]H2DY@2;F/2BU82AS42<H`2=Jd2E[D2=Jd2CW<2HaP2=Jd2>Lh2AS42E[D2DY@2=Jd2AS428@P2CW<2
<H`2BU82:DX2@Q02>Lh2@Q04?Nl2AS42BU82<H`2@Q02<H`2=Jd2G_L2@Q02=Jd2BU82?Nl2BU800cg_
E[EF]@02@Q02>Lh6?Nl2DY@2>Lh2BU827>L2AS42>Lh2@Q02?Nl2@Q02<H`2DY@2?Nl2:DX4@Q02F]H2
CW<4DY@2E[D2<H`2DY@29BT236<2>Lh2<H`2DY@2;F/6?Nl2>Lh2@Q02?Nl2=Jd2@Q02AS42=Jd2F]H2
=Jd>?Nl4BU82>Lh4?Nl2F]H2?Nl2@Q02<H`2AS42BU85Ool10001Ool001Eoo`03001oogoo009oo`9:
DP8aS09[FP8mk`9W>@9Nm`8icP9:DP96<@8U:@9>L`8HaP8]J`9Nm`9>L`8e[@8YBP9:DPA2408aS09:
DP8icP9JeP9BU08]J`9:DP96<@8aS08e[@9F]@8e[@9>L`9S608e[@8icP96<@9F]@9BU08e[@96<@8Q
209>L`8aS09:DP8YBP92408icP9240@mk`96<@9:DP8aS092408aS08e[@9Nm`92408e[@9:DP8mk`9:
DP03?NmF]EJe0092408icPHmk`9BU08icP9:DP8Li`96<@8icP92408mk`92408aS09BU08mk`8YBPA2
409JeP9>L`ABU09F]@8aS09BU08U:@8<H`8icP8aS09BU08]J`Hmk`8icP92408mk`8e[@924096<@8e
[@9JeP8e[@hmk`A:DP8icP@mk`9JeP8mk`92408aS096<@9:DPEoo`40005oo`005Goo00<007ooOol0
0Woo0S6<0T8@0TYB0S6<0Woo0TYB0T8@0SW>0Q240UJe0RDY0TYB0T8@0Sg_0QcW0SF]0SW>0R4814YB
0Re[0Sg_136<0Sg_0UJe0TYB0RDY0RU:0THa0SW>0Woo0T8@0R480THa0Re[0U:D0S6<0U:D0V<H0Re[
0SW>0TYB0THa0SW>0THa0P000U:D0Re[0THa0Sg_0TYB0THa0Tic0SW>0Sg_0T8@0TYB0SF]0Tic0SF]
0THa0S6<00=6<CW>>Lh00V<H0Sg_0SW>0THa13g_148@0UJe1Sg_0SW>0THa0TYB0S6<0Sg_0TYB0U:D
0RDY0Sg_0THa0SW>0Sg_0U[F0Woo0QcW0TYB0SW>14YB0Sg_0RU:0T8@13g_0TYB0SW>0Sg_0THa0V<H
0S6<0Sg_0RU:0TYB0T8@33g_0TYB0THa0Sg_0THa0Sg_0Re[0TYB13g_0THa0V<H1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`2@Q02BU82<H`2Ool2BU82@Q02>Lh248@2E[D29BT2BU82@Q02?Nl27>L2
=Jd2>Lh28@P4BU82;F/2?Nl4<H`2?Nl2E[D2BU829BT2:DX2AS42>Lh2Ool2@Q028@P2AS42;F/2DY@2
<H`2DY@2HaP2;F/2>Lh2BU82AS42>Lh2AS420002DY@2;F/2AS42?Nl2BU82AS42CW<2>Lh2?Nl2@Q02
BU82=Jd2CW<2=Jd2AS42<H`00dHa>LhicP02HaP2?Nl2>Lh2AS44?Nl4@Q02E[D6?Nl2>Lh2AS42BU82
<H`2?Nl2BU82DY@29BT2?Nl2AS42>Lh2?Nl2F]H2Ool27>L2BU82>Lh4BU82?Nl2:DX2@Q04?Nl2BU82
>Lh2?Nl2AS42HaP2<H`2?Nl2:DX2BU82@Q0<?Nl2BU82AS42?Nl2AS42?Nl2;F/2BU84?Nl2AS42HaP5
Ool10001Ool001Eoo`03001oogoo009oo`9240@mk`8aS0800092408mk`9>L`8e[@8Li`8icP8@Q09:
DP8YBP96<@9JeP9:DP9F]@92408mk`9S608icP9[FP8aS0A24080009240@icP8YBP80008mk`8@Q08a
S09W>@8]J`9BU08mk`9>L`@icP92408@Q09W>@80009oo`88@P96<@9240@mk`8Q2092408aS096<@92
409>L`96<@9:DP8mk`8icP=2409:DP9F]@8aS096<@8]J`9BU096<@8mk`92408aS09240@mk`92408m
k`96<@8icP8]J`9BU092408HaP9S60A2408e[@8U:@8mk`8aS0@mk`9240A6<@8icP@mk`96<@8@Q09:
DP8e[@96<@8Q2096<@IF]@8icP8YBP92408mk`92408mk`92408icP9:DP8aS08e[@924096<@92408m
k`9>L`9F]@8aS0Eoo`40005oo`005Goo0P000goo0T8@13g_0S6<0P000T8@0Sg_0Tic0SF]0QcW0SW>
0Q240TYB0RU:0THa0U[F0TYB0UJe0T8@0Sg_0V<H0SW>0V]J0S6<148@0P000T8@13W>0RU:0P000Sg_
0Q240S6<0VLi0Re[0U:D0Sg_0Tic13W>0T8@0Q240VLi0P000Woo0PQ20THa0T8@13g_0R480T8@0S6<
0THa0T8@0Tic0THa0TYB0Sg_0SW>0d8@0TYB0UJe0S6<0THa0Re[0U:D0THa0Sg_0T8@0S6<0T8@13g_
0T8@0Sg_0THa0SW>0Re[0U:D0T8@0QS60V<H148@0SF]0RDY0Sg_0S6<13g_0T8@14Ha0SW>13g_0THa
0Q240TYB0SF]0THa0R480THa1UJe0SW>0RU:0T8@0Sg_0T8@0Sg_0T8@0SW>0TYB0S6<0SF]0T8@0THa
0T8@0Sg_0Tic0UJe0S6<17oo0P000Goo000EOol00`00Oomoo`02Ool2=Jd2BU82CW<236<2G_L4>Lh4
E[D2>Lh2@Q02DY@2CW<2=Jd2DY@2?Nl2=Jd2JeX2?Nl2=Jd2<H`2>Lh2=Jd2E[D2DY@2@Q02BU82@Q04
CW<2>Lh2HaP2?Nl2@Q0248@2Ool2<H`29BT2CW<26<H2E[D2>Lh2AS42@Q025:D2JeX20002:DX2Kg/2
<H`2AS42>Lh2=Jd2CW<25:D2E[D2=Jd2BU82>Lh2;F/2<H`2DY@2AS400cg_E[EF]@02?Nl2@Q02<H`2
@Q02;F/27>L2AS42>Lh2BU82<H`4?Nl2@Q02?Nl2>Lh2AS42=Jd2>Lh27>L2HaP28@P2?Nl2BU82=Jd2
CW<2F]H2BU827>L2;F/2@Q02AS428@P4AS42?Nl2@Q02CW<28@P2E[D2IcT2G_L2<H`2CW<2?Nl28@P2
:DX2BU82AS42@Q08?Nl2@Q026<H2BU82=Jd2G_L2E[D28@P2CW<2>Lh2?Nl5Ool10001Ool001Eoo`03
001oogoo009oo`8e[@9:DP9>L`8<H`9Nm`@icPAF]@8icP92409BU09>L`8e[@9BU08mk`8e[@9[FP8m
k`8e[@8aS08icP8e[@9F]@9BU092409:DP9240A>L`8icP9S608mk`92408@Q09oo`8aS08U:@9>L`8H
aP9F]@8icP96<@92408DY@9[FP80008YBP9_N`8aS096<@8icP8e[@9>L`8DY@9F]@8e[@9:DP8icP8]
J`8aS09BU096<@03?NmF]EJe008mk`92408aS092408]J`8Li`96<@8icP9:DP8aS0@mk`92408mk`8i
cP96<@8e[@8icP8Li`9S608Q208mk`9:DP8e[@9>L`9JeP9:DP8Li`8]J`924096<@8Q20A6<@8mk`92
409>L`8Q209F]@9W>@9Nm`8aS09>L`8mk`8Q208YBP9:DP96<@9240Pmk`92408HaP9:DP8e[@9Nm`9F
]@8Q209>L`8icP8mk`Eoo`40005oo`005Goo00<007ooOol00Woo0S6<0Sg_0S6<0Ukg0QcW0U:D0Woo
0Re[0SF]0T8@0S6<0Re[0SW>0Sg_0SF]0Vmk0T8@0Sg_0Re[0TYB0VLi0SF]0U[F0SF]136<0TYB0UJe
0Q240RU:0Re[0THa0SF]0T8@0UJe0P000T8@0THa0T8@13g_0SW>0Re[0RU:0THa0PaS0Tic13F]0V]J
0RDY0U[F0U:D0TYB0SF]0TYB0Tic0U:D0UJe0RU:0TYB0SF]0U[F00=6<Be[;F/00U:D0SF]0THa0Re[
0Tic0T8@0Sg_0T8@0Sg_0SF]0S6<0T8@0UJe0Sg_0T8@0SW>0THa0Sg_0TYB0THa0RDY14ic0Sg_0UJe
0U:D0S6<0Sg_0R480QS60T8@0VLi0RU:0Re[0T8@0SW>0RDY0THa12U:0QBU0SF]0Re[0THa15:D0T8@
0Re[0Tic0T8@0SW>0Tic0T8@0S6<0SW>0Sg_0SF]0SW>0Re[0Tic0THa0S6<0Ukg1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2<H`2?Nl2<H`2G_L27>L2DY@2Ool2;F/2=Jd2@Q02<H`2;F/2>Lh2?Nl2=Jd2
Kg/2@Q02?Nl2;F/2BU82IcT2=Jd2F]H2=Jd4<H`2BU82E[D248@2:DX2;F/2AS42=Jd2@Q02E[D20002
@Q02AS42@Q04?Nl2>Lh2;F/2:DX2AS4236<2CW<4=Jd2JeX29BT2F]H2DY@2BU82=Jd2BU82CW<2DY@2
E[D2:DX2BU82=Jd2F]H00dHa;F/]J`02DY@2=Jd2AS42;F/2CW<2@Q02?Nl2@Q02?Nl2=Jd2<H`2@Q02
E[D2?Nl2@Q02>Lh2AS42?Nl2BU82AS429BT4CW<2?Nl2E[D2DY@2<H`2?Nl28@P26<H2@Q02IcT2:DX2
;F/2@Q02>Lh29BT2AS44:DX25:D2=Jd2;F/2AS44DY@2@Q02;F/2CW<2@Q02>Lh2CW<2@Q02<H`2>Lh2
?Nl2=Jd2>Lh2;F/2CW<2AS42<H`2G_L5Ool10001Ool001Eoo`03001oogoo009oo`9>L`9F]@8aS096
<@8U:@8]J`8YBP96<@8aS09240@icP9W>@9g_@8YBP8]J`96<@8Li`9JeP8icP8aS08mk`8aS09JeP8H
aPA6<@8icP92408icP9:DP8YBP924096<@9BU09:DP8]J`8HaP8icP92409:DP8mk`8icP9F]@92409>
L`8e[@9[FP8e[@8HaP9S608HaP9>L`@aS08HaP8U:@92408aS08YBP9F]@8icP8Q2003<Ha:DTYB008i
cP9Nm`9:DP8mk`8icP8]J`8aS092408icP9JeP9>L`8mk`8YBP8mk`8aS0A2408aS096<@8mk`9240@m
k`9JeP8<H`8aS08<H`8U:@9BU08@Q0924088@P8e[@8mk`92408mk`9JeP96<@8e[@9[FP8e[@96<@9:
DP8e[@8Q208U:@8mk`9>L`8aS0@]J`9F]@8aS092408mk`92409F]@848@9F]@8mk`8e[@8U:@9>L`Eo
o`40005oo`005Goo00<007ooOol00Woo0Tic0UJe0S6<0THa0RDY0Re[0RU:0THa0S6<0T8@13W>0VLi
0WNm0RU:0Re[0THa0QcW0U[F0SW>0S6<0Sg_0S6<0U[F0QS614Ha0SW>0T8@0SW>0TYB0RU:0T8@0THa
0U:D0TYB0Re[0QS60SW>0T8@0TYB0Sg_0SW>0UJe0T8@0Tic0SF]0V]J0SF]0QS60V<H0QS60Tic136<
0QS60RDY0T8@0S6<0RU:0UJe0SW>0R4800<aS4YBBU800SW>0Ukg0TYB0Sg_0SW>0Re[0S6<0T8@0SW>
0U[F0Tic0Sg_0RU:0Sg_0S6<148@0S6<0THa0Sg_0T8@13g_0U[F0PaS0S6<0PaS0RDY0U:D0Q240T8@
0PQ20SF]0Sg_0T8@0Sg_0U[F0THa0SF]0V]J0SF]0THa0TYB0SF]0R480RDY0Sg_0Tic0S6<12e[0UJe
0S6<0T8@0Sg_0T8@0UJe0P@Q0UJe0Sg_0SF]0RDY0Tic1Goo0@000Goo000EOol00`00Oomoo`02Ool2
@Q02;F/2DY@2?Nl2F]H2CW<2<H`2DY@2@Q02?Nl2IcT2JeX2=Jd2:DX2BU82:DX2<H`2>Lh2CW<2BU82
>Lh2CW<2=Jd2>Lh2?Nl2>Lh2;F/2:DX2;F/2DY@2BU82<H`2?Nl4@Q029BT2@Q02;F/2=Jd2?Nl2G_L2
BU82<H`2?Nl2;F/2E[D2?Nl2;F/2?Nl2AS42?Nl2E[D6=Jd2CW<2@Q029BT2?Nl2;F/27>L2@Q03E[D2
@Q02?Nl2CW<2DY@2F]H2DY@2CW<2E[D2>Lh2@Q02=Jd2DY@2;F/2E[D2BU82AS42?Nl4AS42?Nl2@Q02
;F/29BT2>Lh2@Q04=Jd2DY@2<H`2:DX2CW<28@P2CW<2=Jd2BU82@Q02?Nl2>Lh4@Q02?Nl2@Q02?Nl4
>Lh4?Nl2@Q02>Lh2@Q02?Nl2@Q02>Lh2CW<4>Lh2HaP2;F/2AS42=Jd2JeX2AS42>Lh2CW<5Ool10001
Ool001Eoo`03001oogoo009oo`92408]J`9BU08mk`9JeP9>L`8aS09BU092408mk`9W>@9[FP8e[@8Y
BP9:DP8YBP8aS08icP9>L`9:DP8icP9>L`8e[@8icP8mk`8icP8]J`8YBP8]J`9BU09:DP8aS08mk`A2
408U:@92408]J`8e[@8mk`9Nm`9:DP8aS08mk`8]J`9F]@8mk`8]J`8mk`96<@8mk`9F]@He[@9>L`92
408U:@8mk`8]J`8Li`9240=F]@92408mk`9>L`9BU09JeP9BU09>L`9F]@8icP92408e[@9BU08]J`9F
]@9:DP96<@8mk`A6<@8mk`92408]J`8U:@8icP9240@e[@9BU08aS08YBP9>L`8Q209>L`8e[@9:DP92
408mk`8icPA2408mk`92408mk`@icP@mk`92408icP92408mk`92408icP9>L`@icP9S608]J`96<@8e
[@9[FP96<@8icP9>L`Eoo`40005oo`005Goo00<007ooOol00Woo0THa0TYB0PaS0SW>0Woo0UJe0Sg_
0Re[0TYB0Sg_0S6<0U:D0TYB0VLi0Sg_0Tic0S6<0THa0S6<0V<H0VLi0Sg_0T8@0TYB0T8@0Ukg0TYB
0U:D0S6<0P000RDY0VLi0Sg_0Tic14Ha0S6<0SF]0RDY0R480TYB136<0TYB0Tic0Re[0Ukg0TYB0T8@
0Sg_0T8@0Sg_0Tic0PaS0Ukg0SW>0SF]15Je0T8@0Sg_0SW>0Sg_00=BU3g_?Nl00U:D0Ukg0S6<0THa
0QBU0TYB0THa13g_0T8@13g_0Tic0THa0TYB0SF]0U[F0Tic1Sg_14ic13W>0Tic0TYB0T8@0SF]0UJe
0THa0Re[14Ha0UJe0SW>0Tic0THa0SW>0SF]0Tic0Sg_0Tic0TYB0Re[13g_0T8@1Sg_0T8@0Sg_13F]
0Re[0RDY0SF]0Vmk0U:D0T8@0Sg_0THa1Goo0@000Goo000EOol20003Ool2AS42BU8236<2>Lh2Ool2
E[D2?Nl2;F/2BU82?Nl2<H`2DY@2BU82IcT2?Nl2CW<2<H`2AS42<H`2HaP2IcT2?Nl2@Q02BU82@Q02
G_L2BU82DY@2<H`200029BT2IcT2?Nl2CW<4AS42<H`2=Jd29BT28@P2BU84<H`2BU82CW<2;F/2G_L2
BU82@Q02?Nl2@Q02?Nl2CW<236<2G_L2>Lh2=Jd4E[D2@Q02?Nl2>Lh2?Nl00e:D?Nlmk`02DY@2G_L2
<H`2AS425:D2BU82AS44?Nl2@Q04?Nl2CW<2AS42BU82=Jd2F]H2CW<6?Nl4CW<4>Lh2CW<2BU82@Q02
=Jd2E[D2AS42;F/4AS42E[D2>Lh2CW<2AS42>Lh2=Jd2CW<2?Nl2CW<2BU82;F/4?Nl2@Q06?Nl2@Q02
?Nl4=Jd2;F/29BT2=Jd2Kg/2DY@2@Q02?Nl2AS44Ool20001Ool001Eoo`03001oogoo009oo`8icP8m
k`9JeP9BU09JeP9:DP9JeP8aS08]J`8U:@8YBP8U:@8@Q09cW09F]@848@A6<@@aS08Li`8YBP9:DP8i
cP9S608YBP8U:@8mk`9JeP9oo`9W>@8Q208]J`8icP96<@8aS09BU09>L`9BU09g_@9F]@8Q208Li`96
<@8icP8YBP92408aS0@mk`8icP8mk`8HaP8]J`8YBP92408aS09:DP92408icPA6<@924003G_M2448@
008mk`8]J`9BU0@icP8e[@8]J`8mk`92408mk`92408icP9BU08icP9:DP8mk`8]J`@mk`92408mk`92
409>L`9240A:DP8mk`8]J`9cW08]J`9S6092409W>@8]J`8e[@8icP8]J`96<@8icP9:DP8Q208mk`96
<@9:DP9>L`Pmk`9240@mk`8icP9>L`8Q209S608e[@9:DP92409JeP9F]@92408icPEoo`40005oo`00
5Goo00<007ooOol00Woo0SW>0Sg_0U[F0U:D0U[F0TYB0U[F0S6<0Re[0RDY0RU:0RDY0Q240W>L0UJe
0P@Q14Ha136<0QcW0RU:0TYB0SW>0V<H0RU:0RDY0Sg_0U[F0Woo0VLi0R480Re[0SW>0THa0S6<0U:D
0Tic0U:D0WNm0UJe0R480QcW0THa0SW>0RU:0T8@0S6<13g_0SW>0Sg_0QS60Re[0RU:0T8@0S6<0TYB
0T8@0SW>14Ha0T8@00=Nmd8@@Q000Sg_0Re[0U:D13W>0SF]0Re[0Sg_0T8@0Sg_0T8@0SW>0U:D0SW>
0TYB0Sg_0Re[13g_0T8@0Sg_0T8@0Tic0T8@14YB0Sg_0Re[0W>L0Re[0V<H0T8@0VLi0Re[0SF]0SW>
0Re[0THa0SW>0TYB0R480Sg_0THa0TYB0Tic23g_0T8@13g_0SW>0Tic0R480V<H0SF]0TYB0T8@0U[F
0UJe0T8@0SW>1Goo0@000Goo000EOol00`00Oomoo`04Ool2Li`<000@Ool2Li`248@2Ool20002Li`2
AS42<H`2JeX2@Q02DY@2CW<27>L2:DX224821242;F/2DY@29BT2<H`2?Nl2;F/2BU828@P212420002
JeX2>Lh2=Jd2F]H2?Nl6BU82?Nl2AS42;F/27>L2HaP28@P2=Jd4@Q028@P25:D28@P2?Nl2;F/3?Nl2
>Lh2;F/2?Nl2E[D2AS42<H`2CW<2:DX2CW<2AS42;F/4?Nl2BU82>Lh2@Q02=Jd2<H`2DY@2>Lh2E[D2
1242=Jd2E[D2;F/2?Nl2CW<2=Jd20002BU82=Jd2BU8248@2F]H2DY@2?Nl2BU82@Q02DY@2<H`2BU82
9BT2;F/2DY@2=Jd2@Q0:?Nl2@Q02>Lh2IcT2AS428@P2?Nl2F]H2BU82>Lh2DY@4?Nl5Ool10001Ool0
01Eoo`03001oogoo00Aoo`9cW0`0011oo`9cW08@Q09oo`80009cW096<@8aS09[FP92409BU09>L`8L
i`8YBP88@P848@8]J`9BU08U:@8aS08mk`8]J`9:DP8Q20848@80009[FP8icP8e[@9JeP8mk`I:DP8m
k`96<@8]J`8Li`9S608Q208e[@A2408Q208DY@8Q208mk`8]J`<mk`8icP8]J`8mk`9F]@96<@8aS09>
L`8YBP9>L`96<@8]J`@mk`9:DP8icP92408e[@8aS09BU08icP9F]@848@8e[@9F]@8]J`8mk`9>L`8e
[@80009:DP8e[@9:DP8@Q09JeP9BU08mk`9:DP92409BU08aS09:DP8U:@8]J`9BU08e[@9240Xmk`92
408icP9W>@96<@8Q208mk`9JeP9:DP8icP9BU0@mk`Eoo`40005oo`005Goo00<007ooOol01Woo3000
47oo0S6<0Woo10000Woo0QS60Vmk0SF]0VLi13g_0V<H0Woo0W_N0QS60UJe0Sg_0Tic0S6<0TYB0U[F
0VLi0QBU0V]J0P0012U:0SF]0RU:0U:D0S6<0T8@0SW>0P000SF]10000Woo0R480TYB148@0Tic0UJe
0Ukg0U:D0RDY00=W>Cg_?Nl0148@0SF]0T8@0THa0UJe0T8@0RDY13g_0Tic0THa0UJe0TYB0Sg_0TYB
0SW>0Sg_0T8@0SW>0THa0TYB0SW>0Sg_0THa0Re[136<0U[F0THa0Tic0SF]0V<H0S6<14Ha0T8@0Sg_
0THa0T8@14Ha0Tic0SF]0UJe0Sg_0SW>0Tic0R480U[F13g_0P000Woo0V]J0SW>0TYB148@0S6<0Re[
0T8@0Sg_1Goo0@000Goo000EOol00`00Oomoo`06Ool<000@Ool2<H`2Ool40002Ool26<H2Kg/2=Jd2
IcT4?Nl2HaP2Ool2Nmh26<H2E[D2?Nl2CW<2<H`2BU82F]H2IcT25:D2JeX20004:DX2=Jd2:DX2DY@2
<H`2@Q02>Lh20002=Jd40002Ool28@P2BU84@Q02CW<2E[D2G_L2DY@29BT00fLi?Nlmk`04@Q02=Jd2
@Q02AS42E[D2@Q029BT4?Nl2CW<2AS42E[D2BU82?Nl2BU82>Lh2?Nl2@Q02>Lh2AS42BU82>Lh2?Nl2
AS42;F/4<H`2F]H2AS42CW<2=Jd2HaP2<H`4AS42@Q02?Nl2AS42@Q04AS42CW<2=Jd2E[D2?Nl2>Lh2
CW<28@P2F]H4?Nl20002Ool2JeX2>Lh2BU84@Q02<H`2;F/2@Q02?Nl5Ool10001Ool001Eoo`03001o
ogoo009oo`@000aooa00009:DP8000Aoo`80009_N`8YBP92408U:@8YBP96<@8]J`92409F]@9W>@8Q
209>L`8e[@9>L`@U:@848@96<@92409[FP8]J`8icP8e[@9:DP9240@icP9oo`80009oo`80009oo`80
009Nm`96<@8mk`8]J`9:DP9JeP8HaP9Nm`9:DP03<Ha:DTYB00@mk`9:DP8U:@92408Q208mk`@icP8e
[@8U:@8mk`8Li`A6<@@e[@92408mk`9>L`@YBP9[FP8Li`9F]@8mk`92408icP9:DP8mk`96<@8e[@8i
cP8aS09:DP9>L`92408mk`8e[@A:DP8mk`9>L`8icP9>L`8mk`96<@9>L`8U:@92409>L`8YBP9Nm`80
008DY@9:DPPmk`9F]@8e[@8mk`Eoo`40005oo`005Goo00<007ooOol00Woo100037oo40000TYB0P00
17oo0P000Vmk0RU:0T8@0RDY0RU:0THa0Re[0T8@0UJe0VLi0R480Tic0SF]0Tic12DY0P@Q0THa0T8@
0V]J0Re[0SW>0SF]0TYB0T8@13W>0Woo0P000Woo0P000Woo0P000Ukg0THa0Sg_0Re[0TYB0U[F0QS6
0Ukg0TYB00<aS4YBBU8013g_0TYB0RDY0T8@0R480Sg_13W>0SF]0RDY0Sg_0QcW14Ha13F]0T8@0Sg_
0Tic12U:0V]J0QcW0UJe0Sg_0T8@0SW>0TYB0Sg_0THa0SF]0SW>0S6<0TYB0Tic0T8@0Sg_0SF]14YB
0Sg_0Tic0SW>0Tic0Sg_0THa0Tic0RDY0T8@0Tic0RU:0Ukg0P000QBU0TYB23g_0UJe0SF]0Sg_1Goo
0@000Goo000EOol00`00Oomoo`02Ool2Kg/2Ool400025:D6000<Ool2F]H2HaP6Ool20002DY@2E[D2
@Q02<H`2F]H2Li`2=Jd2?Nl2:DX2AS420002=Jd28@P2>Lh22482>Lh2AS42@Q02<H`2G_L2<H`2F]H2
E[D2;F/2E[D2G_L26<H2Kg/20002JeX2CW<2?Nl236<2CW<4=Jd2@Q02CW<2@Q02DY@2@Q02F]H29BT0
0eJe?Nlmk`02BU82@Q02?Nl2=Jd2AS42=Jd2:DX2>Lh2@Q02;F/2CW<28@P2@Q02BU82?Nl2AS42BU82
DY@29BT2CW<2?Nl2F]H2@Q02BU828@P2=Jd2?Nl2>Lh2AS42>Lh2@Q02?Nl2E[D2F]H2BU82CW<2<H`2
>Lh2<H`2>Lh2IcT2>Lh2AS42DY@2@Q02AS429BT2@Q02?Nl2AS42>Lh2DY@2@Q02IcT4@Q02=Jd4@Q02
?Nl2:DX4?Nl5Ool10001Ool001Eoo`8000=oo`9_N`9oo`@0008DY@H000aoo`9JeP9S60Ioo`80009B
U09F]@92408aS09JeP9cW08e[@8mk`8YBP96<@80008e[@8Q208icP88@P8icP96<@92408aS09Nm`8a
S09JeP9F]@8]J`9F]@9Nm`8HaP9_N`80009[FP9>L`8mk`8<H`9>L`@e[@92409>L`92409BU092409J
eP8U:@03E[Dmkcg_009:DP92408mk`8e[@96<@8e[@8YBP8icP92408]J`9>L`8Q2092409:DP8mk`96
<@9:DP9BU08U:@9>L`8mk`9JeP92409:DP8Q208e[@8mk`8icP96<@8icP92408mk`9F]@9JeP9:DP9>
L`8aS08icP8aS08icP9W>@8icP96<@9BU0924096<@8U:@92408mk`96<@8icP9BU092409W>@A2408e
[@A2408mk`8YBP@mk`Aoo`80005oo`005Goo00<007ooOol00Woo0T8@0PQ20VLi0Ukg0Vmk0W_N0TYB
0Woo0S6<0SW>0PaS0P000Q240PaS0SF]0THa0SF]10000V<H0TYB0Ukg0Sg_0Vmk0R480SW>13g_0VLi
0S6<0Ukg0U:D0RDY0S6<0U:D0THa0RDY0QS60S6<0U:D0S6<0T8@0SF]14Ha0Tic0P@Q0Woo0P000Woo
0P000Ukg0Sg_0SW>0T8@0V<H0Tic0PQ20TYB0Q240Sg_0S6<0Re[00<aS5:DDY@00S6<0Sg_0SW>0U:D
0RU:148@0THa0QBU0THa0U:D0SW>0R480U:D0S6<0Tic0SW>13g_13W>0S6<0V<H0THa0UJe0S6<14YB
14Ha0Sg_0U:D0Sg_0SF]0SW>13g_1T8@0TYB0T8@0Sg_0T8@0SW>0UJe0Sg_0SW>0WNm0T8@0SW>0THa
0S6<148@13g_0SW>0Sg_0SW>0U[F0RU:0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q022482
IcT2G_L2Kg/2Nmh2BU82Ool2<H`2>Lh236<2000248@236<2=Jd2AS42=Jd40002HaP2BU82G_L2?Nl2
Kg/28@P2>Lh4?Nl2IcT2<H`2G_L2DY@29BT2<H`2DY@2AS429BT26<H2<H`2DY@2<H`2@Q02=Jd4AS42
CW<21242Ool20002Ool20002G_L2?Nl2>Lh2@Q02HaP2CW<22482BU8248@2?Nl2<H`2;F/00c6<DYAB
U002<H`2?Nl2>Lh2DY@2:DX4@Q02AS425:D2AS42DY@2>Lh28@P2DY@2<H`2CW<2>Lh4?Nl4>Lh2<H`2
HaP2AS42E[D2<H`4BU84AS42?Nl2DY@2?Nl2=Jd2>Lh4?Nl6@Q02BU82@Q02?Nl2@Q02>Lh2E[D2?Nl2
>Lh2Mkd2@Q02>Lh2AS42<H`4@Q04?Nl2>Lh2?Nl2>Lh2F]H2:DX2AS45Ool10001Ool001Eoo`03001o
ogoo009oo`9BU0@<H`9W>@9:DP8mk`8]J`8YBP9:DP8]J`80008<H`9oo`9g_@8mk`8<H`8e[@9oo`9F
]@8mk`8Q208aS096<@80009oo`8aS08U:@8Li`9oo`9:DP8<H`80009F]@92408]J`8Li`9S609_N`8e
[@8]J`8mk`9S609BU08U:@9g_@88@P9oo`80009oo`8@Q09>L`9:DP9>L`9W>@9F]@9JeP96<@8e[@9>
L`8aS09JeP8U:@8Q2003@Q16<DHa008e[@96<@8icP92408mk`96<@9>L`8]J`9>L`IBU09>L`8e[@96
<@8]J`9S608U:@8icP9Nm`8U:@8]J`9F]@8]J`9BU08e[@8mk`9BU08mk`92409:DP8icP9F]@96<@92
408icP9:DP8U:@8YBP8e[@9S608U:@9:DP8e[@8<H`8HaP96<@8icP@mk`92408icP9>L`8aS08mk`8]
J`9F]@8]J`@aS096<@8e[@8]J`Eoo`40005oo`005Goo00<007ooOol00Woo0U:D10aS0VLi0TYB0Sg_
0Re[0RU:0TYB0Re[0P000PaS0Woo0WNm0Sg_0PaS0SF]0Woo0UJe0Sg_0R480S6<0THa0P000Woo0S6<
0RDY0QcW0Woo0TYB0PaS0P000UJe0T8@0Re[0QcW0V<H0Vmk0SF]0Re[0Sg_0V<H0U:D0RDY0WNm0PQ2
0Woo0P000Woo0Q240Tic0TYB0Tic0VLi0UJe0U[F0THa0SF]0Tic0S6<0U[F0RDY0R4800=244HaAS40
0SF]0THa0SW>0T8@0Sg_0THa0Tic0Re[0Tic1U:D0Tic0SF]0THa0Re[0V<H0RDY0SW>0Ukg0RDY0Re[
0UJe0Re[0U:D0SF]0Sg_0U:D0Sg_0T8@0TYB0SW>0UJe0THa0T8@0SW>0TYB0RDY0RU:0SF]0V<H0RDY
0TYB0SF]0PaS0QS60THa0SW>13g_0T8@0SW>0Tic0S6<0Sg_0Re[0UJe0Re[136<0THa0SF]0Re[1Goo
0@000Goo000EOol00`00Oomoo`04Ool2Mkd28@P2@Q02Ool2JeX2Ool2DY@2=Jd2Kg/6Ool26<H2F]H2
9BT2DY@21242E[D2Nmh29BT20002Ool2BU82@Q020002Ool2<H`2=Jd28@P6Mkd2JeX2?Nl2HaP2;F/2
CW<2?Nl2F]H2;F/26<H2BU82;F/20002Ool20002Ool2<H`2DY@2?Nl2DY@2=Jd2F]H224827>L2CW<2
<H`2CW<2;F/248@2Ool200000be[BU9:DP04=Jd2E[D2?Nl6>Lh2E[D2;F/2DY@2AS42BU82AS42=Jd2
?Nl2DY@2F]H2DY@2CW<2?Nl2Nmh2?Nl2AS42>Lh2BU84>Lh2CW<2>Lh2AS42?Nl2G_L29BT2>Lh2?Nl2
>Lh29BT2;F/28@P2DY@2AS42BU827>L6BU82;F/2E[D2?Nl2@Q02BU82;F/2IcT2;F/2=Jd2>Lh2CW<2
@Q02=Jd2@Q027>L2?Nl2=Jd5Ool10001Ool001Eoo`03001oogoo00Aoo`9g_@8Q2092409oo`9[FP9o
o`9BU08e[@9_N`Ioo`8HaP9JeP8U:@9BU0848@9F]@9kgP8U:@80009oo`9:DP924080009oo`8aS08e
[@8Q20Ig_@9[FP8mk`9S608]J`9>L`8mk`9JeP8]J`8HaP9:DP8]J`80009oo`80009oo`8aS09BU08m
k`9BU08e[@9JeP88@P8Li`9>L`8aS09>L`8]J`8@Q09oo`800003;F]:DTYB00@e[@9F]@8mk`HicP9F
]@8]J`9BU096<@9:DP96<@8e[@8mk`9BU09JeP9BU09>L`8mk`9kgP8mk`96<@8icP9:DP@icP9>L`8i
cP96<@8mk`9Nm`8U:@8icP8mk`8icP8U:@8]J`8Q209BU096<@9:DP8Li`I:DP8]J`9F]@8mk`92409:
DP8]J`9W>@8]J`8e[@8icP9>L`92408e[@92408Li`8mk`8e[@Eoo`40005oo`005Goo00<007ooOol0
0Woo0THa0Woo0PQ20UJe0T8@0V<H0Re[0P000Woo20000Woo0RDY0Sg_0Ukg0W>L0RDY0Woo0P000Woo
0P000Woo0P@Q0Woo0R480T8@0QcW0Sg_0RDY0V]J0Woo0P000Tic0S6<0Sg_136<0Sg_0THa0T8@0RU:
0THa0Woo0P000Woo0SW>0U:D0T8@0SW>0S6<0UJe0S6<0U:D0Re[0RDY0U:D0THa0T8@0THa0P000Woo
00<0048@@Q000Tic0Sg_0RU:0THa0RU:0U:D0TYB0Tic0U:D0Woo0Q240V<H0Q240SW>0Ukg0RU:0T8@
0S6<0SF]0Sg_0Tic1Sg_0SF]0U:D0T8@0Sg_0SW>0Sg_0THa0SF]0Tic0THa0TYB0T8@0U[F0SW>0UJe
0SF]0RU:0S6<0SW>0RDY0THa0SF]0THa0RU:0SW>0T8@0THa0SW>0THa0RU:0SW>0Tic0TYB12DY0U:D
0PaS0RU:0Tic1Goo0@000Goo0007Ool30004Ool20005Ool00`00Oomoo`02Ool2AS42Ool22482E[D2
@Q02HaP2;F/20002Ool80002Ool29BT2?Nl2G_L2Li`29BT2Ool20002Ool20002Ool21242Ool28@P2
@Q027>L2?Nl29BT2JeX2Ool20002CW<2<H`2?Nl4<H`2?Nl2AS42@Q02:DX2AS42Ool20002Ool2>Lh2
DY@2@Q02>Lh2<H`2E[D2<H`2DY@2;F/29BT2DY@2AS42@Q02AS420002Ool00`00@Q124002CW<2?Nl2
:DX2AS42:DX2DY@2BU82CW<2DY@2Ool248@2HaP248@2>Lh2G_L2:DX2@Q02<H`2=Jd2?Nl2CW<6?Nl2
=Jd2DY@2@Q02?Nl2>Lh2?Nl2AS42=Jd2CW<2AS42BU82@Q02F]H2>Lh2E[D2=Jd2:DX2<H`2>Lh29BT2
AS42=Jd2AS42:DX2>Lh2@Q02AS42>Lh2AS42:DX2>Lh2CW<2BU849BT2DY@236<2:DX2CW<5Ool10001
Ool000Moo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol00Woo0P000RDY0QBU0U:D148@
0R480V<H0P000Woo20000Re[0Sg_0P000QcW0VLi10000Woo0PaS1Woo0RDY0UJe0S6<0U[F0V<H0P00
0T8@0P000Vmk0THa0Re[0THa0SF]0TYB136<0V<H0Re[0P000Woo0P000S6<0SF]0W>L0S6<0Sg_0P00
0S6<0TYB0UJe0R480T8@0Tic0VLi0P000Woo0P0000=ooe:DDY@00Sg_0Tic0RU:0S6<0TYB0SW>0S6<
0Sg_13W>0Re[0V<H0TYB0THa0T8@0SW>0V<H0S6<0TYB0S6<1T8@0SW>148@0Sg_0T8@0SF]14Ha13W>
0U:D0T8@0SW>0THa0Sg_0SW>0Sg_0Tic0T8@0Sg_0RU:0UJe0SW>0Re[0Ukg148@0Sg_0T8@0SF]0VLi
0S6<0SW>0Re[136<0TYB0S6<0RU:0SF]1Goo0@000Goo0007Ool01000Oomoo`000Woo00@007ooOol0
00Aoo`8000=oo`80008U:@8DY@9BU0A2408Q209S6080009oo`P0008]J`8mk`80008Li`9W>@@0009o
o`8<H`Ioo`8U:@9F]@8aS09JeP9S608000924080009_N`96<@8]J`96<@8e[@9:DP@aS09S608]J`80
009oo`80008aS08e[@9cW08aS08mk`80008aS09:DP9F]@8Q2092409>L`9W>@80009oo`800003OomB
U5:D008mk`9>L`8YBP8aS09:DP8icP8aS08mk`@icP8]J`9S609:DP96<@92408icP9S608aS09:DP8a
S0I2408icPA2408mk`92408e[@A6<@@icP9BU092408icP96<@8mk`8icP8mk`9>L`92408mk`8YBP9F
]@8icP8]J`9Nm`A2408mk`92408e[@9W>@8aS08icP8]J`@aS09:DP8aS08YBP8e[@Aoo`80005oo`00
1goo0`000goo00@007ooOol000Aoo`03001oogoo00Aoo`8U:@8mk`9>L`9F]@96<@8Li`Aoo`80009c
W09oo`8Q208@Q09F]@8@Q09g_@8icP8mk`80009oo`800096<@80009[FP9>L`8e[@8mk`9S609Nm`9o
o`9F]@9oo`8HaP9JeP8aS09BU08U:@9>L`9BU0848@9oo`8YBP8mk`9oo`8@Q08mk`8icP9:DP8aS09:
DP8Li`9oo`848@9BU08Li`9[FP8Li`96<@8U:@9[FP80009oo`03000U:BDY008U:@92408U:@8icP8]
J`9BU096<@8]J`8HaP8icP8e[@96<@80008e[@8mk`9[FP8Li`8mk`8e[@8mk`8aS0@mk`8e[@924096
<@8mk`9>L`8mk`9F]@8icP8aS09>L`9BU08e[@8aS09[FP8mk`8U:@8e[@9JeP8icP8YBP9BU0924096
<@92408icPXmk`92408Q208U:@8DY@8aS0A:DP96<@8icP8Q20Eoo`40005oo`0027oo00<007ooOol0
0Woo00@007ooOol000Aoo`03001oogoo00Aoo`8U:@8mk`9>L`9F]@96<@8Li`Aoo`80009cW09oo`8Q
208@Q09F]@8@Q09g_@8icP8mk`80009oo`800096<@80009[FP9>L`8e[@8mk`9S609Nm`9oo`9F]@9o
o`8HaP9JeP8aS09BU08U:@9>L`9BU0848@9oo`8YBP8mk`9oo`8@Q08mk`8icP9:DP8aS09:DP8Li`9o
o`848@9BU08Li`9[FP8Li`96<@8U:@9[FP80009oo`03000U:BDY008U:@92408U:@8icP8]J`9BU096
<@8]J`8HaP8icP8e[@96<@80008e[@8mk`9[FP8Li`8mk`8e[@8mk`8aS0@mk`8e[@924096<@8mk`9>
L`8mk`9F]@8icP8aS09>L`9BU08e[@8aS09[FP8mk`8U:@8e[@9JeP8icP8YBP9BU0924096<@92408i
cPXmk`92408Q208U:@8DY@8aS0A:DP96<@8icP8Q20Eoo`40005oo`0027oo0`000goo0P001Goo00<0
07ooOol00Woo0W>L0RU:0THa0U[F0QcW0Sg_0U:D10000Ukg0Tic0P000Ukg0Tic0RU:0TYB0QcW0Tic
0RDY0Woo0QcW0THa0S6<0Woo0T8@0S6<0WNm0Re[0THa0T8@0PaS0R480P000Sg_0T8@0THa0Sg_14YB
0T8@0SW>0QBU0Woo0Tic0S6<14YB0Tic0Sg_0T8@0Sg_0U:D0UJe0PaS0SF]0Sg_0SF]0T8@0U:D0THa
0Re[0W_N0QcW00=oobe[;F/00UJe0Tic0U:D0T8@0S6<0SW>14Ha0UJe0T8@0UJe0QBU0WNm0RDY0VLi
0S6<0Ukg0Re[148@0Tic0T8@13g_0T8@0RDY0SF]0T8@0THa0SW>0TYB13W>0THa0RU:0U:D0S6<0TYB
0S6<0Tic0R480T8@0S6<1T8@0Sg_0T8@23g_0THa0R480Sg_0SW>13g_0UJe0T8@0SF]0Ukg0VLi1Goo
0@000Goo000EOol00`00Oomoo`02Ool2Li`2:DX2AS42F]H27>L2?Nl2DY@40002G_L2CW<20002G_L2
CW<2:DX2BU827>L2CW<29BT2Ool27>L2AS42<H`2Ool2@Q02<H`2Mkd2;F/2AS42@Q0236<28@P20002
?Nl2@Q02AS42?Nl4BU82@Q02>Lh25:D2Ool2CW<2<H`4BU82CW<2?Nl2@Q02?Nl2DY@2E[D236<2=Jd2
?Nl2=Jd2@Q02DY@2AS42;F/2Nmh27>L00goo;F/]J`02E[D2CW<2DY@2@Q02<H`2>Lh4AS42E[D2@Q02
E[D25:D2Mkd29BT2IcT2<H`2G_L2;F/4@Q02CW<2@Q04?Nl2@Q029BT2=Jd2@Q02AS42>Lh2BU84>Lh2
AS42:DX2DY@2<H`2BU82<H`2CW<28@P2@Q02<H`6@Q02?Nl2@Q08?Nl2AS428@P2?Nl2>Lh4?Nl2E[D2
@Q02=Jd2G_L2IcT5Ool10001Ool001Eoo`03001oogoo009oo`8icP9BU08e[@9240A6<@8e[@9_N`Io
o`9F]@8e[@92409BU08aS09:DP8mk`96<@8DY@9_N`92408mk`8icP8DY@8aS09S6088@P8DY@9>L`8e
[@92409oo`8]J`8aS096<@8mk`8U:@9JeP8aS09kgP9cW080009Nm`@mk`8icP924096<@@mk`8e[@8Q
208mk`8Q2096<@8e[@8]J`9>L`8Q208Li`92408<H`03@Q1>Ldic008YBP96<@8icP8aS09>L`9F]@8e
[@HicP8e[@9BU09:DP9BU08DY@8Li`9S608aS09>L`8YBP9JeP8mk`92408mk`8aS08icP8mk`924096
<@9F]@92408YBP@]J`92408YBP9:DP@mk`8icP96<@8mk`92408mk`A6<@Xmk`92408icP9F]@8aS092
409F]@A>L`96<@92408U:@8DY@Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0U:D0SF]0T8@14Ha
0SF]0Vmk1Woo0UJe0SF]0T8@0U:D0S6<0TYB0Sg_0THa0QBU0Vmk0T8@0Sg_0SW>0QBU0S6<0V<H0PQ2
0QBU0Tic0SF]0T8@0Woo0Re[0S6<0THa0Sg_0RDY0U[F0S6<0W_N0W>L0P000Ukg13g_0SW>0T8@0THa
13g_0SF]0R480Sg_0R480THa0SF]0Re[0Tic0R480QcW0T8@0PaS00=244icCW<00RU:0THa0SW>0S6<
0Tic0UJe0SF]1SW>0SF]0U:D0TYB0U:D0QBU0QcW0V<H0S6<0Tic0RU:0U[F0Sg_0T8@0Sg_0S6<0SW>
0Sg_0T8@0THa0UJe0T8@0RU:12e[0T8@0RU:0TYB13g_0SW>0THa0Sg_0T8@0Sg_14Ha2Sg_0T8@0SW>
0UJe0S6<0T8@0UJe14ic0THa0T8@0RDY0QBU1Goo0@000Goo000EOol00`00Oomoo`02Ool2<H`2E[D2
8@P2;F/2?Nl2@Q04?Nl21244;F/2:DX29BT26<H25:D2IcT2>Lh2?Nl2@Q02>Lh2BU827>L2BU82=Jd2
BU82G_L25:D2=Jd2F]H2AS44?Nl2DY@2E[D2;F/2AS42@Q02<H`2?Nl2AS42DY@27>L2Ool22486@Q04
?Nl2@Q02?Nl4@Q02?Nl2>Lh2:DX28@P2HaP2>Lh2=Jd2E[D2AS43:DX2@Q02=Jd2BU82=Jd2?Nl2AS42
DY@2>Lh2@Q02F]H2=Jd2<H`2BU82AS42<H`28@P2;F/2CW<2F]H2?Nl2CW<2<H`2@Q02>Lh2AS42;F/2
=Jd2DY@2>Lh2CW<2IcT2?Nl2G_L29BT4@Q02BU82<H`2AS42@Q0N?Nl4CW<2>Lh2@Q02;F/2F]H2BU82
=Jd2@Q05Ool10001Ool001Eoo`03001oogoo009oo`8aS09F]@8Q208]J`8mk`9240@mk`848@@]J`8Y
BP8U:@8HaP8DY@9W>@8icP8mk`92408icP9:DP8Li`9:DP8e[@9:DP9Nm`8DY@8e[@9JeP96<@@mk`9B
U09F]@8]J`96<@92408aS08mk`96<@9BU08Li`9oo`88@PI240@mk`92408mk`A2408mk`8icP8YBP8Q
209S608icP8e[@9F]@96<@<YBP92408e[@9:DP8e[@8mk`96<@9BU08icP92409JeP8e[@8aS09:DP96
<@8aS08Q208]J`9>L`9JeP8mk`9>L`8aS092408icP96<@8]J`8e[@9BU08icP9>L`9W>@8mk`9Nm`8U
:@A2409:DP8aS096<@9241hmk`A>L`8icP92408]J`9JeP9:DP8e[@9240Eoo`40005oo`005Goo00<0
07ooOol00Woo0Ukg0Tic0Sg_0Tic0PQ20RU:0T8@0U[F0V]J0S6<0Re[0P000P@Q0Vmk0V<H0SW>0UJe
0QcW0TYB0RU:0R480T8@0THa0Woo0P000Ukg0SF]1T8@0Sg_0T8@0QBU15Je0U[F0T8@0Tic0SF]0Tic
0QBU0TYB0QBU0SF]0QBU0W>L0PaS0Sg_0THa0Tic0SW>0TYB0V<H0SF]0U[F0Re[13g_0QcW0U[F0PQ2
0TYB0WNm00=S648@@Q00136<13W>0THa0U:D0RU:0Ukg0Re[0V]J0QcW0UJe0S6<0Tic0SF]0SW>0THa
0Tic0S6<0T8@0Re[148@0SW>0THa13g_0Tic0SF]0UJe0U:D0TYB0SF]136<0SF]0S6<14Ha0Sg_0TYB
0V<H0TYB0SF]0TYB0T8@0SW>0THa0SF]0T8@0Sg_0T8@0SW>0Re[0RU:0T8@0SF]0Sg_0THa0T8@0UJe
0SW>0SF]1Goo0@000Goo000EOol20003Ool2G_L2CW<2?Nl2CW<22482:DX2@Q02F]H2JeX2<H`2;F/2
00021242Kg/2HaP2>Lh2E[D27>L2BU82:DX28@P2@Q02AS42Ool20002G_L2=Jd6@Q02?Nl2@Q025:D4
E[D2F]H2@Q02CW<2=Jd2CW<25:D2BU825:D2=Jd25:D2Li`236<2?Nl2AS42CW<2>Lh2BU82HaP2=Jd2
F]H2;F/4?Nl27>L2F]H22482BU82Mkd00f<H@Q124004<H`4>Lh2AS42DY@2:DX2G_L2;F/2JeX27>L2
E[D2<H`2CW<2=Jd2>Lh2AS42CW<2<H`2@Q02;F/4@Q02>Lh2AS44?Nl2CW<2=Jd2E[D2DY@2BU82=Jd4
<H`2=Jd2<H`4AS42?Nl2BU82HaP2BU82=Jd2BU82@Q02>Lh2AS42=Jd2@Q02?Nl2@Q02>Lh2;F/2:DX2
@Q02=Jd2?Nl2AS42@Q02E[D2>Lh2=Jd4Ool20001Ool001Eoo`03001oogoo009oo`8DY@8@Q0@icP9[
FP9JeP9BU08U:@8mk`8000Aoo`9W>@8Q209Nm`848@8]J`9F]@8YBP8icP8@Q08mk`9Nm`80009cW08]
J`9:DP9>L`9F]@8]J`8mk`A[FP8]J`924096<@8icP9JeP9:DP8aS092409>L`8icP9>L`8Li`8]J`9J
eP@e[@92408e[@8aS08e[@8icP8mk`8U:@9:DP92408e[@96<@8icP8<H`8]J`03:DY2448@00A2408e
[@8mk`9240ABU08e[@92409F]@9W>@8@Q09F]@8mk`@e[@9:DP96<@8mk`9:DP8icP9240@mk`9>L`8a
S08mk`8icP8mk`A2408aS09:DPQ240@mk`9JeP96<@9:DPA2408aS08U:@A2409S608mk`9:DP8U:@8Y
BP9:DP8mk`9240@e[@A2408e[@8mk`9F]@Eoo`40005oo`005Goo00<007ooOol00Woo0QBU0Q2413W>
0V]J0U[F0U:D0RDY0Sg_0P0017oo0VLi0R480Ukg0P@Q0Re[0UJe0RU:0SW>0Q240Sg_0Ukg0P000W>L
0Re[0TYB0Tic0UJe0Re[0Sg_16]J0Re[0T8@0THa0SW>0U[F0TYB0S6<0T8@0Tic0SW>0Tic0QcW0Re[
0U[F13F]0T8@0SF]0S6<0SF]0SW>0Sg_0RDY0TYB0T8@0SF]0THa0SW>0PaS0Re[00<YBT8@@Q00148@
0SF]0Sg_0T8@15:D0SF]0T8@0UJe0VLi0Q240UJe0Sg_13F]0TYB0THa0Sg_0TYB0SW>0T8@13g_0Tic
0S6<0Sg_0SW>0Sg_148@0S6<0TYB248@13g_0U[F0THa0TYB148@0S6<0RDY148@0V<H0Sg_0TYB0RDY
0RU:0TYB0Sg_0T8@13F]148@0SF]0Sg_0UJe1Goo0@000Goo000EOol00`00Oomoo`02Ool2DY@2>Lh2
AS42F]H2?Nl2E[D6?Nl2Ool600026<H2@Q02CW<2@Q02BU82CW<2:DX2DY@2BU825:D2Mkd248@2Li`2
@Q02=Jd2@Q02E[D2>Lh448@2>Lh2?Nl4=Jd2@Q02?Nl2@Q02?Nl2IcT2;F/2@Q02=Jd2AS42;F/27>L4
>Lh2@Q02<H`2IcT29BT2:DX2JeX2;F/2DY@2@Q02BU82;F/2AS42JeX00f<H>LhicP02=Jd2@Q02>Lh2
CW<2<H`2@Q02?Nl2AS42E[D2F]H2CW<2E[D2@Q02CW<2?Nl4DY@2@Q02<H`28@P2F]H2>Lh2@Q08?Nl4
@Q02?Nl2@Q02;F/4@Q02=Jd2?Nl2>Lh2?Nl2<H`2;F/2>Lh2;F/2@Q04=Jd29BT4@Q02>Lh2@Q02AS42
<H`2BU82;F/2CW<2?Nl2;F/2?Nl2;F/2>Lh2Li`2JeX2@Q05Ool10001Ool001Eoo`03001oogoo009o
o`9BU08icP96<@9JeP8mk`9F]@Hmk`9oo`H0008HaP92409>L`92409:DP9>L`8YBP9BU09:DP8DY@9g
_@8@Q09cW092408e[@92409F]@8icP@@Q08icP8mk`@e[@92408mk`92408mk`9W>@8]J`92408e[@96
<@8]J`8Li`@icP92408aS09W>@8U:@8YBP9[FP8]J`9BU092409:DP8]J`96<@9[FP03HaPicSW>008e
[@92408icP9>L`8aS092408mk`96<@9F]@9JeP9>L`9F]@92409>L`8mk`ABU092408aS08Q209JeP8i
cP9240Pmk`A2408mk`92408]J`A2408e[@8mk`8icP8mk`8aS08]J`8icP8]J`9240@e[@8U:@A2408i
cP924096<@8aS09:DP8]J`9>L`8mk`8]J`8mk`8]J`8icP9cW09[FP9240Eoo`40005oo`005Goo00<0
07ooOol00Woo0T8@0V]J0S6<0TYB0Re[0PaS0SW>13F]0Sg_0Woo0Vmk17oo0TYB0RDY0Vmk0Re[13F]
0P000TYB0Re[0Woo0R480Vmk0SW>0Sg_0Re[0THa0SW>0S6<0W_N0PaS0Re[0UJe13g_0SF]0T8@0SF]
0Re[0T8@0S6<12e[0T8@14Ha0UJe0SW>0THa0SW>0T8@0THa0Sg_0U:D0RU:0T8@0SW>0Re[0VLi0a24
0UJe0R480Re[0U:D0RDY0U:D0QcW0SW>0UJe0T8@0Sg_0R480Tic0SW>0U[F0Re[0RDY0Tic0U:D0SF]
0RDY0RU:0T8@1Sg_0TYB0T8@13g_0T8@0THa0Sg_0RDY0TYB0Sg_0TYB0U:D0T8@0UJe0U:D0S6<0TYB
0SW>0Re[0S6<0THa0Sg_0SF]0TYB13g_0T8@0SW>0T8@0Sg_0SF]0Sg_0THa0SW>0TYB0QBU0S6<0T8@
1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02JeX2<H`2BU82;F/236<2>Lh4=Jd2?Nl2Ool2Kg/4
Ool2BU829BT2Kg/2;F/4=Jd20002BU82;F/2Ool28@P2Kg/2>Lh2?Nl2;F/2AS42>Lh2<H`2Nmh236<2
;F/2E[D4?Nl2=Jd2@Q02=Jd2;F/2@Q02<H`4;F/2@Q04AS42E[D2>Lh2AS42>Lh2@Q02AS42?Nl2DY@2
:DX2@Q02>Lh2;F/2IcT348@2E[D28@P2;F/2DY@29BT2DY@27>L2>Lh2E[D2@Q02?Nl28@P2CW<2>Lh2
F]H2;F/29BT2CW<2DY@2=Jd29BT2:DX2@Q06?Nl2BU82@Q04?Nl2@Q02AS42?Nl29BT2BU82?Nl2BU82
DY@2@Q02E[D2DY@2<H`2BU82>Lh2;F/2<H`2AS42?Nl2=Jd2BU84?Nl2@Q02>Lh2@Q02?Nl2=Jd2?Nl2
AS42>Lh2BU825:D2<H`2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9_N`9W>@8YBPAS608aS08L
i`9F]@92408icP88@P8Li`88@P80008DY@9[FP8Q209>L`8]J`8YBP9oo`9cW08e[@8YBP8icP8Li`96
<@8aS09_N`9>L`8Li`8HaP800096<@8U:@9F]@I2409JeP8U:@848@8YBP9BU08Q208icP92408aS096
<@9F]@@mk`9BU08Q209:DP9>L`8U:@AF]@8e[@96<@8]J`=>L`8YBP8mk`9F]@8mk`9Nm`96<@9>L`96
<@8U:@9>L`8aS09JeP8e[@8aS08mk`9F]@8e[@9kgP8e[@96<@8icP8aS092408mk`92408mk`8icP8m
k`8icP9BU092409F]@9>L`@icP8U:@9Nm`8aS08mk`9:DP8e[@8icP@YBP8aS08U:@8mk`8icPA6<@92
40@mk`92408icP9:DP96<@8aS09:DP92408aS09S608U:@96<@Eoo`40005oo`005Goo00<007ooOol0
0Woo0Vmk0VLi0RU:16<H0S6<0QcW0UJe0T8@0SW>0PQ20QcW0PQ20P000QBU0V]J0R480Tic0Re[0RU:
0Woo0W>L0SF]0RU:0SW>0QcW0THa0S6<0Vmk0Tic0QcW0QS60P000THa0RDY0UJe1T8@0U[F0RDY0P@Q
0RU:0U:D0R480SW>0T8@0S6<0THa0UJe13g_0U:D0R480TYB0Tic0RDY15Je0SF]0THa0Re[0dic0RU:
0Sg_0UJe0Sg_0Ukg0THa0Tic0THa0RDY0Tic0S6<0U[F0SF]0S6<0Sg_0UJe0SF]0W_N0SF]0THa0SW>
0S6<0T8@0Sg_0T8@0Sg_0SW>0Sg_0SW>0U:D0T8@0UJe0Tic13W>0RDY0Ukg0S6<0Sg_0TYB0SF]0SW>
12U:0S6<0RDY0Sg_0SW>14Ha0T8@13g_0T8@0SW>0TYB0THa0S6<0TYB0T8@0S6<0V<H0RDY0THa1Goo
0@000Goo000EOol00`00Oomoo`02Ool236<2AS429BT2AS4236<2BU82DY@2:DX2E[D4@Q026<H2IcT2
Kg/2HaP2?Nl2>Lh2<H`2?Nl2AS420002@Q02=Jd2Ool2;F/2Ool2>Lh2IcT2:DX2=Jd2G_L2AS42IcT2
@Q02DY@2AS429BT2F]H2>Lh4?Nl2BU82<H`2>Lh2<H`2BU82=Jd2DY@4AS42?Nl4@Q02BU827>L2AS42
E[D2DY@2AS42CW<248@2?Nl2CW<00acW;F/]J`04CW<2<H`2G_L2CW<29BT4F]H2>Lh2AS427>L2F]H2
>Lh6AS4248@2AS42?Nl2>Lh2?Nl2@Q02<H`2=Jd2DY@2@Q02?Nl2@Q02>Lh2@Q02>Lh2?Nl2BU82<H`2
DY@2E[D2CW<4:DX2AS42@Q02BU82@Q02>Lh2=Jd2AS42>Lh2AS42>Lh<?Nl2AS42BU82:DX2>Lh2AS42
?Nl2BU82=Jd5Ool10001Ool001Eoo`8000=oo`8<H`96<@8U:@96<@8<H`9:DP9BU08YBP9F]@A2408H
aP9W>@9_N`9S608mk`8icP8aS08mk`96<@800092408e[@9oo`8]J`9oo`8icP9W>@8YBP8e[@9Nm`96
<@9W>@92409BU096<@8U:@9JeP8icP@mk`9:DP8aS08icP8aS09:DP8e[@9BU0A6<@8mk`A2409:DP8L
i`96<@9F]@9BU096<@9>L`8@Q08mk`9>L`037>L]Jbe[00A>L`8aS09Nm`9>L`8U:@AJeP8icP96<@8L
i`9JeP8icPI6<@8@Q096<@8mk`8icP8mk`92408aS08e[@9BU092408mk`92408icP92408icP8mk`9:
DP8aS09BU09F]@9>L`@YBP96<@92409:DP92408icP8e[@96<@8icP96<@8icP`mk`96<@9:DP8YBP8i
cP96<@8mk`9:DP8e[@Aoo`80005oo`005Goo00<007ooOol00Woo0THa0Tic0SF]0V]J0V<H0S6<0Sg_
0T8@0Ukg0SW>0TYB0Vmk0QBU0SF]0U:D0RDY0Sg_0SF]0S6<0SW>0Woo0Sg_0RU:0P000Vmk0T8@0S6<
0QBU0THa0Sg_0R480RDY0QBU0Sg_0TYB0T8@0THa0Tic1T8@0THa0SF]0U:D0V]J0S6<0T8@0Sg_0SW>
148@0Sg_0Ukg0RU:0TYB0RU:0SF]0Sg_0THa0RU:0WNm0U[F0f<H0UJe13g_0RU:0T8@0SF]0TYB0THa
0TYB0Ukg0RU:0W>L0SF]0V<H0SF]0SW>0Sg_0S6<0Sg_0T8@0SF]13g_0S6<0Tic0SW>13g_0S6<0VLi
0S6<0TYB0UJe0RDY0T8@0UJe0Tic0U:D0RDY0SF]0TYB0SW>0Sg_0THa0U[F13F]0Sg_0T8@23g_0T8@
0Re[0SW>0U[F0RDY0SW>0Tic148@0RU:0Re[1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42CW<2
=Jd2JeX2HaP2<H`2?Nl2@Q02G_L2>Lh2BU82Kg/25:D2=Jd2DY@29BT2?Nl2=Jd2<H`2>Lh2Ool2?Nl2
:DX20002Kg/2@Q02<H`25:D2AS42?Nl28@P29BT25:D2?Nl2BU82@Q02AS42CW<6@Q02AS42=Jd2DY@2
JeX2<H`2@Q02?Nl2>Lh4@Q02?Nl2G_L2:DX2BU82:DX2=Jd2?Nl2AS42:DX2Mkd2F]H3HaP2E[D4?Nl2
:DX2@Q02=Jd2BU82AS42BU82G_L2:DX2Li`2=Jd2HaP2=Jd2>Lh2?Nl2<H`2?Nl2@Q02=Jd4?Nl2<H`2
CW<2>Lh4?Nl2<H`2IcT2<H`2BU82E[D29BT2@Q02E[D2CW<2DY@29BT2=Jd2BU82>Lh2?Nl2AS42F]H4
=Jd2?Nl2@Q08?Nl2@Q02;F/2>Lh2F]H29BT2>Lh2CW<4@Q02:DX2;F/5Ool10001Ool001Eoo`03001o
ogoo009oo`8@Q08icP9BU08YBP8@Q096<@@mk`@HaP@icP9oo`9W>@9JeP92408e[@924096<@9>L`8U
:@8Q2092409oo`800088@P9JeP8icP96<@9JeP8aS09[FP8mk`8icP@mk`8icP9BU096<@@aS09:DP96
<@9F]@9>L`9Nm`9>L`8icPHmk`92408]J`9W>@8U:@9S608]J`8e[@8mk`9:DP8DY@8Li`8YBP03=Jdm
kcg_008e[@9:DP924096<@9S6092408e[@8]J`8@Q09F]@8YBP96<@8aS08]J`@U:@@icP8mk`9240@m
k`9240A6<@9:DP8icP8e[@8mk`96<@92408YBP96<@8e[@9:DP92408icP8YBP8mk`9BU08Q2096<@9>
L`8icQ8mk`96<@8mk`8YBP9>L`A240ABU096<@9240Eoo`40005oo`005Goo00<007ooOol00Woo0Q24
0SW>0U:D0RU:0Q240THa13g_11S613W>0Woo0VLi0U[F0T8@0SF]0T8@0THa0Tic0RDY0R480T8@0Woo
0P000PQ20U[F0SW>0THa0U[F0S6<0V]J0Sg_0SW>13g_0SW>0U:D0THa136<0TYB0THa0UJe0Tic0Ukg
0Tic0SW>1Sg_0T8@0Re[0VLi0RDY0V<H0Re[0SF]0Sg_0TYB0QBU0QcW0RU:00<e[Cg_?Nl00SF]0TYB
0T8@0THa0V<H0T8@0SF]0Re[0Q240UJe0RU:0THa0S6<0Re[12DY13W>0Sg_0T8@13g_0T8@14Ha0TYB
0SW>0SF]0Sg_0THa0T8@0RU:0THa0SF]0TYB0T8@0SW>0RU:0Sg_0U:D0R480THa0Tic0SW>4Sg_0THa
0Sg_0RU:0Tic148@15:D0THa0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2JeX2<H`2G_L2DY@2
7>L2@Q02>Lh2CW<2IcT4AS42:DX2<H`26<H2>Lh248@2<H`2@Q02?Nl2>Lh2F]H2;F/2?Nl2HaP2@Q02
:DX2E[D2@Q02CW<2E[D4>Lh21242@Q029BT2BU82>Lh2DY@2CW<2@Q02AS42E[D2AS44CW<2?Nl2BU82
@Q08?Nl2@Q02CW<2:DX2AS44>Lh29BT2JeX4AS429BT00eJeIcUW>@02AS42>Lh2IcT2@Q02CW<2<H`4
?Nl2=Jd2DY@2@Q02;F/2AS428@P2AS42=Jd2>Lh2BU82DY@2=Jd2BU82?Nl2@Q02=Jd2E[D2F]H2?Nl4
@Q02?Nl2CW<20002IcT2E[D2?Nl2@Q02BU82@Q02<H`2BU82;F/2@Q02<H`2AS4B?Nl2@Q02?Nl2BU82
?Nl2AS428@P2DY@2>Lh2AS42BU85Ool10001Ool001Eoo`03001oogoo009oo`9[FP8aS09Nm`9BU08L
i`92408icP9>L`9W>@A6<@8YBP8aS08HaP8icP8@Q08aS092408mk`8icP9JeP8]J`8mk`9S6092408Y
BP9F]@92409>L`9F]@@icP848@92408U:@9:DP8icP9BU09>L`924096<@9F]@96<@A>L`8mk`9:DP92
40Pmk`92409>L`8YBP96<@@icP8U:@9[FPA6<@8U:@03E[EW>FLi0096<@8icP9W>@92409>L`8aS0@m
k`8e[@9BU092408]J`96<@8Q2096<@8e[@8icP9:DP9BU08e[@9:DP8mk`92408e[@9F]@9JeP8mk`A2
408mk`9>L`80009W>@9F]@8mk`92409:DP92408aS09:DP8]J`92408aS096<A8mk`92408mk`9:DP8m
k`96<@8Q209BU08icP96<@9:DPEoo`40005oo`005Goo00<007ooOol00Woo0Q240SW>0TYB0V<H0Sg_
0SW>0Sg_0T8@0Sg_0T8@0R480Tic0THa13F]0TYB13W>0THa0SW>0Re[0U[F0T8@0PaS0T8@0Re[0QBU
0Ukg0THa0SW>0PaS0U:D0Re[0T8@0SF]0PaS0TYB0QS60W>L0SW>0THa0SW>0Tic13W>13g_13F]0T8@
1Sg_0U[F13g_0THa1Tic0Re[0RU:0Sg_00=:DRDY9BT00TYB0QcW14ic0THa0TYB0Sg_0T8@0Re[0Sg_
0QcW0RDY0Sg_0S6<0RDY0U:D0RU:0Tic0SF]0U[F0RDY0Sg_0SW>0U:D13W>0RDY0THa0Sg_0T8@0SW>
0TYB0T8@0SF]0V<H0Re[0S6<0Sg_0T8@0Sg_0T8@0Sg_0T8@0Sg_13F]0T8@33g_148@0RDY0Tic0Re[
0UJe0QcW0RU:0Tic0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool248@2>Lh2BU82HaP2?Nl2>Lh2
?Nl2@Q02?Nl2@Q028@P2CW<2AS44=Jd2BU84>Lh2AS42>Lh2;F/2F]H2@Q0236<2@Q02;F/25:D2G_L2
AS42>Lh236<2DY@2;F/2@Q02=Jd236<2BU826<H2Li`2>Lh2AS42>Lh2CW<4>Lh4?Nl4=Jd2@Q06?Nl2
F]H4?Nl2AS46CW<2;F/2:DX2?Nl00dYB9BTU:@02BU827>L4CW<2AS42BU82?Nl2@Q02;F/2?Nl27>L2
9BT2?Nl2<H`29BT2DY@2:DX2CW<2=Jd2F]H29BT2?Nl2>Lh2DY@4>Lh29BT2AS42?Nl2@Q02>Lh2BU82
@Q02=Jd2HaP2;F/2<H`2?Nl2@Q02?Nl2@Q02?Nl2@Q02?Nl4=Jd2@Q0<?Nl4@Q029BT2CW<2;F/2E[D2
7>L2:DX2CW<2@Q05Ool10001Ool001Eoo`03001oogoo009oo`9kgP92408e[@8]J`A2408mk`96<@9>
L`8e[@9>L`9BU09:DP8mk`9BU096<@92408mk`8icP8YBP9>L`8YBP8mk`8]J`9S608aS09:DP8mk`9W
>@8icP9S608icP9BU0@mk`96<@8e[@8Q208e[@92408icP9BU0@icP96<@8mk`I2408mk`92408mk`9F
]@8aS08icP9F]@9:DP96<@@icP9S608]J`8aS003BU96<DHa00924096<@8mk`92408aS09BU0924096
<@8]J`8e[@8mk`8icP8]J`8icP9Nm`8icP92408icP92408mk`A2408icP9BU08aS096<@9:DP8icP8m
k`8YBP96<@8Li`96<@8mk`8icP9BU08icP92408mk`9240Pmk`A240`mk`92408icP9:DP8YBP@Q209N
m`9BU08e[@96<@9>L`Eoo`40005oo`005Goo0P000goo0W_N0T8@0SF]0Re[148@0Sg_0THa0Tic0SF]
0Tic0U:D0TYB0Sg_0U:D0THa0T8@0Sg_0SW>0RU:0Tic0RU:0Sg_0Re[0V<H0S6<0TYB0Sg_0VLi0SW>
0V<H0SW>0U:D13g_0THa0SF]0R480SF]0T8@0SW>0U:D13W>0THa0Sg_1T8@0Sg_0T8@0Sg_0UJe0S6<
0SW>0UJe0TYB0THa13W>0V<H0Re[0S6<00=:DTHaAS400T8@0THa0Sg_0T8@0S6<0U:D0T8@0THa0Re[
0SF]0Sg_0SW>0Re[0SW>0Ukg0SW>0T8@0SW>0T8@0Sg_148@0SW>0U:D0S6<0THa0TYB0SW>0Sg_0RU:
0THa0QcW0THa0Sg_0SW>0U:D0SW>0T8@0Sg_0T8@23g_148@33g_0T8@0SW>0TYB0RU:12480Ukg0U:D
0SF]0THa0Tic17oo0P000Goo000EOol00`00Oomoo`02Ool29BT2?Nl2Kg/2BU84?Nl2@Q02=Jd28@P2
?Nl22482AS46@Q06?Nl2BU82F]H27>L2<H`2@Q02BU82<H`4AS42:DX25:D2CW<2=Jd4?Nl2;F/2AS42
=Jd2AS42:DX2F]H2?Nl2;F/248@2HaP2AS42>Lh2@Q0:?Nl2@Q029BT2IcT2DY@2<H`2AS42DY@2E[D2
CW<2?Nl2;F/2<H`00dicE[EF]@02:DX2?Nl2BU829BT2?Nl2DY@2F]H2?Nl2@Q02G_L2=Jd2>Lh28@P2
@Q02AS42?Nl2<H`2@Q0:?Nl2@Q02=Jd2?Nl4@Q02E[D26<H2;F/4@Q02?Nl2CW<T?Nl2BU82AS42=Jd2
AS42;F/2DY@2=Jd2?Nl29BT2@Q05Ool10001Ool001Eoo`03001oogoo009oo`8U:@8mk`9_N`9:DP@m
k`92408e[@8Q208mk`88@P96<@I240Hmk`9:DP9JeP8Li`8aS092409:DP8aS0A6<@8YBP8DY@9>L`8e
[@@mk`8]J`96<@8e[@96<@8YBP9JeP8mk`8]J`8@Q09S6096<@8icP9240Xmk`92408U:@9W>@9BU08a
S096<@9BU09F]@9>L`8mk`8]J`8aS003CW=F]EJe008YBP8mk`9:DP8U:@8mk`9BU09JeP8mk`92409N
m`8e[@8icP8Q20924096<@8mk`8aS09240Xmk`92408e[@8mk`A2409F]@8HaP8]J`A2408mk`9>Lb@m
k`9:DP96<@8e[@96<@8]J`9BU08e[@8mk`8U:@9240Eoo`40005oo`005Goo00<007ooOol00Woo0THa
0QBU0Re[0Tic0SW>0T8@0Sg_0SW>0SF]0Tic0UJe0Tic0TYB0THa0Woo0U[F0Sg_0T8@0Sg_0SW>0SF]
0TYB0T8@0Tic14YB0SW>0TYB0T8@0V<H0R4814Ha0RU:0U[F0U:D0TYB0Tic0Ukg0Re[148@0U:D0Re[
0THa0T8@33g_0THa0Sg_0Re[0SW>0T8@0THa0R480THa0U:D13g_00<e[BDY9BT00S6<0TYB0Re[0S6<
0UJe0V]J0SF]0T8@0RU:0Sg_0SF]0R480THa0S6<0TYB13F]0THa0RU:0U[F0QBU0THa13g_0TYB0Re[
0THa0T8@0S6<0Re[0SW>0Sg_0T8@0SF]0T8@0SW>0QBU0TYB0Sg_0T8@63g_0T8@0SF]0QS60SF]0S6<
0U:D0V<H0U[F0QcW0SF]0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS425:D2;F/2CW<2>Lh2
@Q02?Nl2>Lh2=Jd2CW<2E[D2CW<2BU82AS42Ool2F]H2?Nl2@Q02?Nl2>Lh2=Jd2BU82@Q02CW<4BU82
>Lh2BU82@Q02HaP28@P4AS42:DX2F]H2DY@2BU82CW<2G_L2;F/4@Q02DY@2;F/2AS42@Q0<?Nl2AS42
?Nl2;F/2>Lh2@Q02AS428@P2AS42DY@4?Nl00cF]9BTU:@02<H`2BU82;F/2<H`2E[D2JeX2=Jd2@Q02
:DX2?Nl2=Jd28@P2AS42<H`2BU84=Jd2AS42:DX2F]H25:D2AS44?Nl2BU82;F/2AS42@Q02<H`2;F/2
>Lh2?Nl2@Q02=Jd2@Q02>Lh25:D2BU82?Nl2@Q0H?Nl2@Q02=Jd26<H2=Jd2<H`2DY@2HaP2F]H27>L2
=Jd2@Q05Ool10001Ool001Eoo`03001oogoo009oo`96<@ANm`8aS09240Hmk`@Q208]J`96<@8<H`8L
i`8U:@8mk`9240@mk`96<@9F]@8YBP8mk`8Li`8U:@8aS08]J`I6<@9Nm`8e[@@aS08]J`96<@8mk`96
<@8e[@924096<@9>L`8aS096<@9240`mk`92408mk`8YBP8mk`9>L`96<@8YBP9:DP96<@92408U:@9B
U003E[Dmkcg_008mk`9S608mk`9240@icPA2408mk`8icP8e[@8icP8mk`8]J`8aS092409:DP924096
<@A240Hmk`A240@mk`8icP9F]@9:DP8YBP@icP9JeP8e[B8mk`92409BU0@HaP96<@9:DP9BU08e[@8m
k`8HaPEoo`40005oo`005Goo00<007ooOol00Woo0THa15kg0S6<0T8@1Sg_12480Re[0THa0PaS0QcW
0RDY0Sg_0T8@13g_0THa0UJe0RU:0Sg_0QcW0RDY0S6<0Re[1THa0Ukg0SF]136<0Re[0THa0Sg_0THa
0SF]0T8@0THa0Tic0S6<0THa0T8@33g_0T8@0Sg_0RU:0Sg_0Tic0THa0RU:0TYB0THa0T8@0RDY0U:D
00=F]Cg_?Nl00Sg_0V<H0Sg_0T8@13W>148@0Sg_0SW>0SF]0SW>0Sg_0Re[0S6<0T8@0TYB0T8@0THa
148@1Sg_148@13g_0SW>0UJe0TYB0RU:13W>0U[F0SF]8Sg_0T8@0U:D11S60THa0TYB0U:D0SF]0Sg_
0QS61Goo0@000Goo000EOol00`00Oomoo`02Ool2=Jd2F]H4AS46?Nl2@Q02HaP2AS42@Q04>Lh2F]H2
:DX2@Q04?Nl2@Q02CW<4AS42@Q02?Nl2CW<2=Jd2CW<2>Lh2E[D2:DX2<H`2@Q02CW<2@Q02DY@2;F/4
@Q02G_L2DY@2=Jd2CW<2G_L2>Lh@?Nl2;F/2@Q02=Jd2@Q02DY@2CW<2=Jd6@Q02?Nl00d8@?Nlmk`02
?Nl2;F/2?Nl6@Q02>Lh2?Nl2@Q06?Nl2AS42DY@2BU827>L29BT2BU82>Lh2=Jd2?Nl4@Q02?Nl2BU82
CW<2<H`2@Q02F]H2?Nl29BT2BU82F]H2DY@2E[D2>LhR?Nl2AS428@P2?Nl2E[D2?Nl2CW<2F]H2=Jd2
G_L2?Nl5Ool10001Ool000Qoo`8000Aoo`8000Eoo`03001oogoo009oo`8e[@9JePA6<@Hmk`92409S
6096<@9240@icP9JeP8YBP9240@mk`92409>L`A6<@92408mk`9>L`8e[@9>L`8icP9F]@8YBP8aS092
409>L`92409BU08]J`A2409Nm`9BU08e[@9>L`9Nm`8icQ0mk`8]J`92408e[@92409BU09>L`8e[@I2
408mk`03@Q0mkcg_008mk`8]J`8mk`I2408icP8mk`9240Hmk`96<@9BU09:DP8Li`8U:@9:DP8icP8e
[@8mk`A2408mk`9:DP9>L`8aS092409JeP8mk`8U:@9:DP9JeP9BU09F]@8icR8mk`96<@8Q208mk`9F
]@8mk`9>L`9JeP8e[@9Nm`8mk`Eoo`40005oo`001goo00@007ooOol0009oo`04001oogoo0004Ool0
0`00Oomoo`02Ool2DY@2AS42>Lh2@Q02?Nl2AS42?Nl2>Lh2@Q02=Jd2AS42=Jd2AS427>L2:DX2F]H2
@Q02AS42>Lh2@Q02DY@2>Lh2@Q02=Jd2;F/2CW<2AS429BT2BU82AS44?Nl2;F/2?Nl2;F/29BT2HaP2
;F/2AS425:D2F]H26<H4@Q06?Nl4AS42?Nl2@Q02?Nl2CW<2?Nl4CW<2BU828@P2BU82DY@2=Jd2@Q02
?Nl00be[BU9:DP04<H`2AS428@P2AS42@Q02HaP2AS42@Q02?Nl2@Q02?Nl2<H`4AS42@Q02F]H4DY@2
E[D2>Lh2<H`2:DX2BU82<H`2?Nl2AS42:DX2>Lh29BT2;F/2CW<29BT2AS4@?Nl2@Q02?Nl2AS42BU8<
?Nl2@Q02<H`2?Nl2JeX2<H`2?Nl2E[D2<H`2>Lh29BT2<H`5Ool10001Ool000Moo`04001oogoo0002
Ool01000Oomoo`0017oo0P000goo0U:D0THa0SW>0T8@0Sg_0THa0Sg_0SW>0T8@0SF]0THa0SF]0THa
0QcW0RU:0U[F0T8@0THa0SW>0T8@0U:D0SW>0T8@0SF]0Re[0Tic0THa0RDY0TYB0THa13g_0Re[0Sg_
0Re[0RDY0V<H0Re[0THa0QBU0U[F0QS6148@1Sg_14Ha0Sg_0T8@0Sg_0Tic0Sg_14ic0TYB0R480TYB
0U:D0SF]0T8@0Sg_00<]JdYBBU80136<0THa0R480THa0T8@0V<H0THa0T8@0Sg_0T8@0Sg_0S6<14Ha
0T8@0U[F15:D0UJe0SW>0S6<0RU:0TYB0S6<0Sg_0THa0RU:0SW>0RDY0Re[0Tic0RDY0THa43g_0T8@
0Sg_0THa0TYB33g_0T8@0S6<0Sg_0V]J0S6<0Sg_0UJe0S6<0SW>0RDY0S6<17oo0P000Goo0008Ool2
0003Ool01000Oomoo`0017oo00<007ooOol00Woo0QcW0Sg_0S6<0T8@0SW>0THa0SW>0Tic0S6<0RU:
0T8@0TYB0PaS0R480V]J0S6<0TYB0THa0T8@0QcW0THa0S6<0TYB0S6<0Ukg0SF]1Tic0Sg_0SF]0THa
0Ukg0S6<0THa14YB0V<H0Re[0THa0U:D0UJe0SW>0T8@0SW>0Sg_0SW>0TYB0U:D0Sg_0T8@0Sg_0SW>
0P@Q0THa0Sg_0Re[148@0S6<0SW>0Tic0e[F1T8@13g_0SW>0T8@0SW>0TYB0RDY0U:D0S6<0TYB0S6<
0SW>0S6<0T8@0V]J0SF]0V<H0T8@0TYB0U[F0T8@0RU:0Re[0THa0SW>0V<H0R480SF]0S6<0SF]0Sg_
148@4Sg_0U:D0V<H0SW>0T8@2Sg_0TYB0UJe0Sg_0TYB0SF]0S6<0UJe0THa0SF]0THa1Goo0@000Goo
0007Ool01000Oomoo`000Woo00@007ooOol000Aoo`03001oogoo009oo`8Li`8mk`8aS092408icP96
<@8icP9>L`8aS08YBP92409:DP8<H`8Q209[FP8aS09:DP96<@92408Li`96<@8aS09:DP8aS09Nm`8e
[@I>L`8mk`8e[@96<@9Nm`8aS096<@A:DP9S608]J`96<@9BU09F]@8icP92408icP8mk`8icP9:DP9B
U08mk`92408mk`8icP848@96<@8mk`8]J`A2408aS08icP9>L`=JePI240@mk`8icP92408icP9:DP8U
:@9BU08aS09:DP8aS08icP8aS092409[FP8e[@9S6092409:DP9JeP92408YBP8]J`96<@8icP9S608Q
208e[@8aS08e[@8mk`A2418mk`9BU09S608icP9240Xmk`9:DP9F]@8mk`9:DP8e[@8aS09F]@96<@8e
[@96<@Eoo`40005oo`0027oo0P0017oo0P001Goo00<007ooOol00Woo0THa0Re[0U:D0SF]0T8@0SW>
0T8@0SF]0UJe0SW>0S6<0Sg_0U:D0Sg_0RU:0Sg_0Re[0SW>0Sg_0V<H0Tic0T8@0UJe0U[F0Re[0UJe
0T8@0SW>0SF]0R480TYB0SW>0S6<0THa0QcW0Re[148@0SW>0T8@0U:D0SF]0T8@0Sg_14Ha0U:D0UJe
0SF]0T8@0Sg_0T8@0SF]0Tic0RU:0TYB0SW>0THa0SW>0THa0SF]0QcW0THa0dic0Sg_0T8@0THa0S6<
0TYB0Sg_0U:D0Re[0T8@0SW>0SF]0TYB0SW>0T8@15:D0T8@0Re[0T8@0Sg_0T8@13g_0THa13g_0T8@
0TYB0U:D0RU:0THa0R480S6<23g_0T8@0THa0U[F0Sg_0T8@0Tic0Re[0THa0SW>3Sg_0T8@0SW>0Re[
0THa0T8@0SF]0RDY0SF]0T8@0SW>1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42;F/2DY@2=Jd2
@Q02>Lh2@Q02=Jd2E[D2>Lh2<H`2?Nl2DY@2?Nl2:DX2?Nl2;F/2>Lh2?Nl2HaP2CW<2@Q02E[D2F]H2
;F/2E[D2@Q02>Lh2=Jd28@P2BU82>Lh2<H`2AS427>L2;F/4@Q02>Lh2@Q02DY@2=Jd2@Q02?Nl4AS42
DY@2E[D2=Jd2@Q02?Nl2@Q02=Jd2CW<2:DX2BU82>Lh2AS42>Lh2AS42=Jd27>L2AS43CW<2?Nl2@Q02
AS42<H`2BU82?Nl2DY@2;F/2@Q02>Lh2=Jd2BU82>Lh2@Q04DY@2@Q02;F/2@Q02?Nl2@Q04?Nl2AS44
?Nl2@Q02BU82DY@2:DX2AS428@P2<H`8?Nl2@Q02AS42F]H2?Nl2@Q02CW<2;F/2AS42>Lh>?Nl2@Q02
>Lh2;F/2AS42@Q02=Jd29BT2=Jd2@Q02>Lh5Ool10001Ool001Eoo`03001oogoo009oo`8mk`8e[@8Q
209F]@96<@8icP8mk`A2409:DP8e[@8mk`8aS0A6<@92408mk`96<@8mk`8]J`8icP8]J`9>L`8]J`92
408]J`8icP9JeP9:DP9BU09>L`@mk`A6<@8mk`8icP8e[@9:DP92409:DP8U:@9F]@96<@8aS09:DP92
408e[@9BU08mk`92408e[@@mk`8e[@8mk`A6<@8mk`8e[@9Nm`9JeP8e[@03>Li2448@008icPA2408e
[@9:DP8aS08]J`8aS0I240Hmk`8U:@8icP8mk`8icP8U:@9>L`96<@8mk`9:DP8aS096<@8U:@8e[@96
<@@e[@96<@8aS09:DP96<@8e[@92408mk`8e[@8mk`8icP92408]J`9BU08mk`9240@e[@9240Hmk`92
408icP92408aS09>L`9Nm`8icP924096<@92408mk`9:DPEoo`40005oo`005Goo00<007ooOol00Woo
0Sg_0SF]0R480UJe0THa0SW>0Sg_148@0TYB0SF]0Sg_0S6<14Ha0T8@0Sg_0THa0Sg_0Re[0SW>0Re[
0Tic0Re[0T8@0Re[0SW>0U[F0TYB0U:D0Tic13g_14Ha0Sg_0SW>0SF]0TYB0T8@0TYB0RDY0UJe0THa
0S6<0TYB0T8@0SF]0U:D0Sg_0T8@0SF]13g_0SF]0Sg_14Ha0Sg_0SF]0Ukg0U[F0SF]00<icT8@@Q00
0SW>148@0SF]0TYB0S6<0Re[0S6<1T8@1Sg_0RDY0SW>0Sg_0SW>0RDY0Tic0THa0Sg_0TYB0S6<0THa
0RDY0SF]0THa13F]0THa0S6<0TYB0THa0SF]0T8@0Sg_0SF]0Sg_0SW>0T8@0Re[0U:D0Sg_0T8@13F]
0T8@1Sg_0T8@0SW>0T8@0S6<0Tic0Ukg0SW>0T8@0THa0T8@0Sg_0TYB1Goo0@000Goo000EOol00`00
Oomoo`02Ool2:DX2JeX2AS42<H`2:DX2@Q02?Nl2BU82?Nl2=Jd2F]H2;F/2?Nl4@Q02>Lh2<H`2?Nl2
BU82F]H2BU82DY@2AS42=Jd2>Lh2?Nl2E[D2DY@2CW<2>Lh2;F/27>L2?Nl2;F/2BU82>Lh2G_L2?Nl2
>Lh2HaP2F]H2;F/2<H`2:DX28@P2E[D2>Lh2AS42=Jd2@Q02?Nl2DY@2AS42>Lh4@Q02?Nl2DY@4=Jd2
9BT2BU82?Nl00d8@?Nlmk`02BU82@Q02CW<2=Jd2AS42=Jd2AS42CW<6?Nl2@Q04?Nl2@Q02BU82@Q02
DY@27>L2HaP2>Lh2DY@2<H`2CW<26<H2@Q02;F/2CW<2BU82<H`2@Q02E[D2>Lh2<H`4@Q02:DX2?Nl2
>Lh2=Jd2@Q02;F/2=Jd4?Nl4@Q06?Nl2@Q02>Lh2CW<4<H`2DY@2:DX2@Q02>Lh2CW<6?Nl5Ool10001
Ool001Eoo`03001oogoo009oo`8YBP9[FP96<@8aS08YBP92408mk`9:DP8mk`8e[@9JeP8]J`8mk`A2
408icP8aS08mk`9:DP9JeP9:DP9BU096<@8e[@8icP8mk`9F]@9BU09>L`8icP8]J`8Li`8mk`8]J`9:
DP8icP9Nm`8mk`8icP9S609JeP8]J`8aS08YBP8Q209F]@8icP96<@8e[@92408mk`9BU096<@8icPA2
408mk`9BU0@e[@8U:@9:DP8mk`03@Q0mkcg_009:DP92409>L`8e[@96<@8e[@96<@9>L`Hmk`9240@m
k`92409:DP92409BU08Li`9S608icP9BU08aS09>L`8HaP92408]J`9>L`9:DP8aS092409F]@8icP8a
S0A2408YBP8mk`8icP8e[@92408]J`8e[@@mk`A240Hmk`92408icP9>L`@aS09BU08YBP92408icP9>
L`Hmk`Eoo`40005oo`005Goo00<007ooOol00Woo0THa0VLi0RU:0TYB0V]J0S6<0T8@0RDY0T8@0SW>
0T8@0R480Tic0Sg_0T8@0TYB0Tic0T8@0S6<0TYB0UJe0U:D0VLi0R480TYB136<0T8@14Ha0VLi0U[F
0T8@0SF]0U:D0SF]0T8@0SW>0TYB0Tic0W_N0Sg_0T8@0W_N0T8@0Sg_0U:D0SF]0Tic0Sg_0T8@136<
0Re[0TYB0S6<0Sg_0Tic0R480SF]0TYB0SW>1Cg_14Ha0Tic0TYB0RU:0SF]0T8@0RU:0T8@3Sg_148@
0R480Re[0QS60SF]13g_13F]0Tic0SW>0RU:0Sg_13W>0S6<0SF]0VLi0RU:0Woo0Sg_0SF]0T8@0RU:
1Sg_0T8@13F]0T8@1Sg_0T8@0SF]0THa0TYB0SF]0R480T8@0SW>0S6<0T8@0Sg_0THa1Goo0@000Goo
000EOol20003Ool2AS42IcT2:DX2BU82JeX2<H`2@Q029BT2@Q02>Lh2@Q028@P2CW<2?Nl2@Q02BU82
CW<2@Q02<H`2BU82E[D2DY@2IcT28@P2BU84<H`2@Q04AS42IcT2F]H2@Q02=Jd2DY@2=Jd2@Q02>Lh2
BU82CW<2Nmh2?Nl2@Q02Nmh2@Q02?Nl2DY@2=Jd2CW<2?Nl2@Q04<H`2;F/2BU82<H`2?Nl2CW<28@P2
=Jd2BU82>Lh5?Nl4AS42CW<2BU82:DX2=Jd2@Q02:DX2@Q0>?Nl4@Q028@P2;F/26<H2=Jd4?Nl4=Jd2
CW<2>Lh2:DX2?Nl4>Lh2<H`2=Jd2IcT2:DX2Ool2?Nl2=Jd2@Q02:DX6?Nl2@Q04=Jd2@Q06?Nl2@Q02
=Jd2AS42BU82=Jd28@P2@Q02>Lh2<H`2@Q02?Nl2AS44Ool20001Ool001Eoo`03001oogoo009oo`8Q
20ABU09>L`8Q20@mk`96<@924096<@9BU092408icP@mk`@aS0A2408e[@8aS0@mk`96<@8icP96<@9:
DP8icP9BU08YBP8U:@8]J`8mk`92408U:@8Li`8e[@9BU08icP9F]@92409F]@8Li`8<H`@aS08icP96
<@Pmk`92409:DP8icP9:DP8icP9F]@9JeP96<@8mk`96<@8mk`03@Q0mkcg_009>L`8YBP8e[@9Nm`A2
408mk`96<@A240Pmk`9240@mk`9:DP9>L`9BU08icP96<@8mk`9:DP8e[@9F]@8icP92408e[@8mk`8Q
209>L`92408aS096<@9:DP8HaP924096<@8mk`8e[@96<A@mk`96<@9S6092408YBP8e[@8mk`8aS096
<@8mk`92408aS0Eoo`40005oo`005Goo00<007ooOol00Woo0R4815:D0Tic0R4813g_0THa0T8@0THa
0U:D0T8@0SW>13g_136<148@0SF]0S6<13g_0THa0SW>0THa0TYB0SW>0U:D0RU:0RDY0Re[0Sg_0T8@
0RDY0QcW0SF]0U:D0SW>0UJe0T8@0UJe0QcW0PaS136<0SW>0THa23g_0T8@0TYB0SW>0TYB0SW>0UJe
0U[F0THa0Sg_0THa0Sg_00=243g_?Nl00Tic0RU:0SF]0Ukg148@0Sg_0THa148@23g_0T8@13g_0TYB
0Tic0U:D0SW>0THa0Sg_0TYB0SF]0UJe0SW>0T8@0SF]0Sg_0R480Tic0T8@0S6<0THa0TYB0QS60T8@
0THa0Sg_0SF]0THa53g_0THa0V<H0T8@0RU:0SF]0Sg_0S6<0THa0Sg_0T8@0S6<1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2E[D2:DX27>L2Kg/2CW<2?Nl2>Lh4@Q02?Nl2;F/2?Nl2E[D2=Jd2>Lh2E[D2
>Lh2?Nl2@Q02:DX2BU82=Jd2>Lh2;F/2BU82@Q04BU82?Nl2F]H2Li`2CW<2@Q02=Jd2>Lh2<H`2AS42
CW<2=Jd2AS42F]H2;F/2=Jd2E[D2=Jd4@Q02=Jd2>Lh2?Nl2@Q02AS42?Nl2@Q02E[D2?Nl2@Q02<H`2
=Jd2G_L2AS42:DX2@Q000cg_@Q124002<H`2BU82CW<2BU82<H`2@Q02?Nl4=Jd2>Lh2@Q06?Nl2CW<2
?Nl4@Q02>Lh2F]H2<H`2;F/2BU84@Q02CW<4BU82;F/27>L2;F/2AS44@Q02>Lh2IcT2E[D2>Lh2=Jd8
?Nl2AS42F]H2>Lh8?Nl2@Q02?Nl2CW<2>Lh2BU84AS42CW<2<H`2@Q04?Nl2>Lh5Ool10001Ool001Eo
o`03001oogoo009oo`9F]@8YBP8Li`9_N`9>L`8mk`8icPA2408mk`8]J`8mk`9F]@8e[@8icP9F]@8i
cP8mk`92408YBP9:DP8e[@8icP8]J`9:DP9240A:DP8mk`9JeP9cW09>L`92408e[@8icP8aS096<@9>
L`8e[@96<@9JeP8]J`8e[@9F]@8e[@A2408e[@8icP8mk`924096<@8mk`92409F]@8mk`92408aS08e
[@9Nm`96<@8YBP924003?Nm2448@008aS09:DP9>L`9:DP8aS092408mk`@e[@8icP9240Hmk`9>L`8m
k`A2408icP9JeP8aS08]J`9:DPA2409>L`A:DP8]J`8Li`8]J`96<@A2408icP9W>@9F]@8icP8e[@Pm
k`96<@9JeP8icPPmk`92408mk`9>L`8icP9:DPA6<@9>L`8aS09240@mk`8icPEoo`40005oo`005Goo
00<007ooOol00Woo0SF]0U:D148@0SF]0SW>0QS60RU:0TYB0S6<0U:D0Sg_0TYB0SW>0S6<0RDY0SF]
0U:D0U[F0T8@0SF]0TYB0SF]0Sg_0TYB0U:D0Sg_0RDY0Sg_0Re[0RDY0SF]0Re[0SF]0RDY0THa0S6<
0Sg_0TYB0Tic0QcW0Ukg0Sg_0Q240S6<0TYB0SF]1T8@0THa0T8@0TYB0T8@0SW>0Sg_1TYB0QcW0Sg_
14Ha0cg_0THa13W>13g_148@0Sg_14Ha0Sg_0T8@0Sg_0T8@0Re[0Tic0SW>0U[F0S6<0SW>0Re[0T8@
0U:D0UJe0Sg_0TYB0T8@0TYB13W>0T8@0Tic0S6<0THa136<0Tic0T8@0SW>0Sg_0Tic13g_0T8@13W>
0Re[0THa0T8@0SF]13g_0S6<0T8@13g_0T8@0Sg_0T8@0Sg_0T8@13F]1Goo0@000Goo000EOol00`00
Oomoo`02Ool2=Jd2DY@4@Q02=Jd2>Lh26<H2:DX2BU82<H`2DY@2?Nl2BU82>Lh2<H`29BT2=Jd2DY@2
F]H2@Q02=Jd2BU82=Jd2?Nl2BU82DY@2?Nl29BT2?Nl2;F/29BT2=Jd2;F/2=Jd29BT2AS42<H`2?Nl2
BU82CW<27>L2G_L2?Nl248@2<H`2BU82=Jd6@Q02AS42@Q02BU82@Q02>Lh2?Nl6BU827>L2?Nl4AS43
?Nl2AS44>Lh4?Nl4@Q02?Nl4AS42?Nl2@Q02?Nl2@Q02;F/2CW<2>Lh2F]H2<H`2>Lh2;F/2@Q02DY@2
E[D2?Nl2BU82@Q02BU84>Lh2@Q02CW<2<H`2AS44<H`2CW<2@Q02>Lh2?Nl2CW<4?Nl2@Q04>Lh2;F/2
AS42@Q02=Jd4?Nl2<H`2@Q04?Nl2@Q02?Nl2@Q02?Nl2@Q04=Jd5Ool10001Ool001Eoo`03001oogoo
009oo`9F]@A6<@9Nm`8YBP92409:DP8icP8mk`8aS08icP9BU0A>L`9F]@92408mk`96<@8Li`9:DP8m
k`8e[@9>L`8]J`92408HaP8e[@8Q208mk`9>L`8aS09Nm`9F]@8mk`8Li`@HaP8mk`8icP8Li`9JeP8i
cP9>L`92409F]@8icP8e[@92409F]@9>L`8Li`92409:DP8e[@9:DP8]J`8e[@92408aS08@Q09BU096
<@8mk`03>Lhmkcg_008mk`92408]J`8e[@8icP8mk`@icPA240@mk`9240@mk`8Q208aS08mk`A2408m
k`8e[@8Q2096<@92409:DP9>L`8Li`9W>@8e[@9>L`96<@@mk`A:DP9Nm`8YBP9:DP8mk`9BU0@mk`9>
L`8aS08mk`9Nm`@mk`ABU08icP96<@8aS096<@92408]J`92408mk`92408e[@9:DP9240Eoo`40005o
o`005Goo00<007ooOol00Woo0UJe14Ha0Ukg0RU:0T8@0TYB0SW>0Sg_0S6<0SW>0U:D14ic0UJe0T8@
0Sg_0THa0QcW0TYB0Sg_0SF]0Tic0Re[0T8@0QS60SF]0R480Sg_0Tic0S6<0Ukg0UJe0Sg_0QcW11S6
0Sg_0SW>0QcW0U[F0SW>0Tic0T8@0UJe0SW>0SF]0T8@0UJe0Tic0QcW0T8@0TYB0SF]0TYB0Re[0SF]
0T8@0S6<0Q240U:D0THa0Sg_00<icSg_?Nl00Sg_0T8@0Re[0SF]0SW>0Sg_13W>148@13g_0T8@13g_
0R480S6<0Sg_148@0Sg_0SF]0R480THa0T8@0TYB0Tic0QcW0VLi0SF]0Tic0THa13g_14YB0Ukg0RU:
0TYB0Sg_0U:D13g_0Tic0S6<0Sg_0Ukg13g_15:D0SW>0THa0S6<0THa0T8@0Re[0T8@0Sg_0T8@0SF]
0TYB0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q04>Lh2;F/2@Q06?Nl2>Lh2@Q02?Nl2BU82
:DX2AS42;F/2DY@4?Nl2BU84?Nl4@Q02CW<2>Lh2DY@2BU82>Lh2AS42DY@4<H`2DY@2CW<4?Nl2AS42
BU82>Lh2=Jd2E[D2=Jd2@Q028@P2<H`4@Q02?Nl2=Jd2>Lh2CW<4?Nl2CW<2?Nl6@Q02AS42DY@2>Lh2
?Nl2>Lh00dic?Nlmk`04?Nl2@Q02;F/2CW<2>Lh2?Nl2>Lh2;F/2>Lh2@Q02?Nl2BU82AS42F]H2?Nl2
=Jd2@Q02>Lh2E[D28@P29BT2>Lh2:DX2E[D2AS42<H`2@Q02BU82<H`2AS46?Nl2>Lh4<H`2BU84?Nl2
>Lh4?Nl2>Lh2@Q02?Nl2=Jd2?Nl2AS42E[D2>Lh2@Q02?Nl2@Q02?Nl4=Jd2@Q04?Nl2@Q04?Nl5Ool1
0001Ool001Eoo`8000=oo`9240@icP8]J`9240Hmk`8icP92408mk`9:DP8YBP96<@8]J`9BU0@mk`9:
DP@mk`A2409>L`8icP9BU09:DP8icP96<@9BU0@aS09BU09>L`@mk`96<@9:DP8icP8e[@9F]@8e[@92
408Q208aS0A2408mk`8e[@8icP9>L`@mk`9>L`8mk`I24096<@9BU08icP8mk`8icP03CW<mkcg_00@m
k`92408]J`9>L`8icP8mk`8icP8]J`8icP92408mk`9:DP96<@9JeP8mk`8e[@92408icP9F]@8Q208U
:@8icP8YBP9F]@96<@8aS092409:DP8aS096<@Hmk`8icP@aS09:DP@mk`8icP@mk`8icP92408mk`8e
[@8mk`96<@9F]@8icP92408mk`92408mk`@e[@9240@mk`9240@mk`Aoo`80005oo`005Goo00<007oo
Ool00Woo0U:D148@0TYB0SW>14Ha0SW>13g_0SW>0Sg_0U:D0Sg_14YB0Sg_0SW>0Sg_0THa0T8@0SF]
0SW>0RU:0THa0SW>0THa13W>13F]0T8@0Sg_0THa0SW>0Sg_0RDY0S6<0SW>0THa0Re[0Sg_0TYB0Tic
0T8@1Sg_14YB0SW>13g_0SW>1Sg_0SF]0Sg_0Tic0TYB0Sg_0T8@00<icTYBBU800U[F0SW>0T8@0RDY
0TYB0SW>0Tic0SF]0Re[13g_0T8@0SW>0Sg_0SW>148@0Re[0T8@0SF]0SW>0Tic0S6<0Tic0TYB0SW>
0S6<0T8@0TYB0T8@0TYB0Sg_0T8@0Sg_0TYB0THa0T8@0SW>13g_0T8@13g_0T8@13g_0TYB0THa13g_
0T8@23g_148@13g_0T8@0Sg_0T8@0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2DY@4@Q02BU82
>Lh4AS42>Lh4?Nl2>Lh2?Nl2DY@2?Nl4BU82?Nl2>Lh2?Nl2AS42@Q02=Jd2>Lh2:DX2AS42>Lh2AS44
>Lh4=Jd2@Q02?Nl2AS42>Lh2?Nl29BT2<H`2>Lh2AS42;F/2?Nl2BU82CW<2@Q06?Nl4BU82>Lh4?Nl2
>Lh6?Nl2=Jd2?Nl2CW<2BU82?Nl2@Q000cW>BU9:DP02F]H2>Lh2@Q029BT2BU82>Lh2CW<2=Jd2;F/4
?Nl2@Q02>Lh2?Nl2>Lh4@Q02;F/2@Q02=Jd2>Lh2CW<2<H`2CW<2BU82>Lh2<H`2@Q02BU82@Q02BU82
?Nl2@Q02?Nl2BU82AS42@Q02>Lh4?Nl2@Q04?Nl2@Q04?Nl2BU82AS44?Nl2@Q08?Nl4@Q04?Nl2@Q02
?Nl2@Q02?Nl5Ool10001Ool001Eoo`03001oogoo009oo`96<@@aS08icP924096<@8icP9>L`9:DP8]
J`8icP9:DP9240@e[@8icP8mk`92408mk`8YBP8mk`92409:DP8e[@8icP8aS08e[@92408mk`8icP96
<@8mk`@icP96<@8U:@8Li`9:DP9>L`@icP9BU096<@8e[@Hmk`8aS0@mk`92408mk`A:DP92409>L`8]
J`92408mk`8aS08mk`96<@8mk`03@Q1>Ldic008icP92408icP8e[@@mk`8]J`8mk`9240Hmk`9BU08m
k`9240@mk`9F]@8icP9>L`8icP9BU08e[@9:DP8]J`9S608Q209:DP9>L`Hmk`9>L`8U:@9:DP@mk`92
40Hmk`92408mk`96<@9:DP@mk`92408mk`9240@mk`92408mk`@icP@mk`96<@8U:@96<@92408icPEo
o`40005oo`005Goo00<007ooOol00Woo0THa136<0SW>0T8@0THa0SW>0Tic0TYB0Re[0SW>0TYB0T8@
13F]0SW>0Sg_0T8@0Sg_0RU:0Sg_0T8@0TYB0SF]0SW>0S6<0SF]0T8@0Sg_0SW>0THa0Sg_13W>0THa
0RDY0QcW0TYB0Tic13W>0U:D0THa0SF]1Sg_0S6<13g_0T8@0Sg_14YB0T8@0Tic0Re[0T8@0Sg_0S6<
0Sg_0THa0Sg_00=244icCW<00SW>0T8@0SW>0SF]13g_0Re[0Sg_0T8@1Sg_0U:D0Sg_0T8@13g_0UJe
0SW>0Tic0SW>0U:D0SF]0TYB0Re[0V<H0R480TYB0Tic1Sg_0Tic0RDY0TYB13g_0T8@1Sg_0T8@0Sg_
0THa0TYB13g_0T8@0Sg_0T8@13g_0T8@0Sg_13W>13g_0THa0RDY0THa0T8@0SW>1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2=Jd2IcT4DY@29BT2<H`4?Nl4AS42@Q02?Nl2BU82=Jd28@P2?Nl2E[D2@Q02
=Jd28@P2@Q02<H`2@Q02<H`2?Nl2>Lh2<H`2@Q02?Nl2JeX2@Q02>Lh2:DX2=Jd4?Nl2@Q02G_L2CW<4
?Nl2=Jd2<H`2>Lh2AS42@Q02E[D2=Jd2@Q02?Nl2@Q04:DX2CW<2<H`2>Lh2BU82AS44>Lh2CW<4?Nl0
0bU:AS56<@02?Nl2@Q02>Lh2=Jd2AS42>Lh2F]H2=Jd6?Nl2BU82AS42<H`2?Nl2HaP2:DX27>L2>Lh2
?Nl2AS44BU82HaP2:DX2?Nl2DY@2@Q02AS44>Lh2F]H2=Jd2>Lh2AS42?Nl2<H`6?Nl2@Q02;F/4=Jd>
?Nl2@Q04;F/28@P2@Q02?Nl2@Q029BT2>Lh4?Nl2BU85Ool10001Ool001Eoo`03001oogoo009oo`8e
[@9W>@ABU08U:@8aS0@mk`A6<@92408mk`9:DP8e[@8Q208mk`9F]@92408e[@8Q2092408aS092408a
S08mk`8icP8aS092408mk`9[FP92408icP8YBP8e[@@mk`92409Nm`9>L`@mk`8e[@8aS08icP96<@92
409F]@8e[@92408mk`9240@YBP9>L`8aS08icP9:DP96<@@icP9>L`@mk`03:DY6<DHa008mk`92408i
cP8e[@96<@8icP9JeP8e[@Hmk`9:DP96<@8aS08mk`9S608YBP8Li`8icP8mk`96<@A:DP9S608YBP8m
k`9BU0924096<@@icP9JeP8e[@8icP96<@8mk`8aS0Hmk`92408]J`@e[@hmk`9240@]J`8Q2092408m
k`92408U:@8icP@mk`9:DPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0S6<0THa0SF]0THa148@
0SF]0SW>13g_0T8@0SW>0T8@0Sg_0SF]0SW>0Sg_13W>13g_0T8@0Sg_0THa148@0Sg_0Re[0RU:0TYB
0Sg_0TYB0T8@0SW>0T8@0SW>0T8@0THa0T8@13F]0TYB23g_0T8@13g_0T8@0SW>0THa0T8@0TYB0T8@
0Sg_148@0TYB0Re[13g_00=BU48@@Q0013g_0T8@0RU:0SF]0TYB0THa0Sg_0T8@0Sg_0T8@0S6<0R48
0THa13g_14Ha148@0Tic0T8@0Ukg0QS60THa0Ukg0V<H0Re[0RU:0SW>0T8@0SW>0SF]1Sg_0T8@23g_
0T8@0Sg_0T8@4Sg_0U:D13g_0T8@13W>0T8@13g_0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2
BU82<H`2AS42=Jd2AS44@Q02=Jd2>Lh4?Nl2@Q02>Lh2@Q02?Nl2=Jd2>Lh2?Nl4>Lh4?Nl2@Q02?Nl2
AS44@Q02?Nl2;F/2:DX2BU82?Nl2BU82@Q02>Lh2@Q02>Lh2@Q02AS42@Q04=Jd2BU88?Nl2@Q04?Nl2
@Q02>Lh2AS42@Q02BU82@Q02?Nl4@Q02BU82;F/4?Nl00e:D@Q124004?Nl2@Q02:DX2=Jd2BU82AS42
?Nl2@Q02?Nl2@Q02<H`28@P2AS44?Nl4AS44@Q02CW<2@Q02G_L26<H2AS42G_L2HaP2;F/2:DX2>Lh2
@Q02>Lh2=Jd6?Nl2@Q08?Nl2@Q02?Nl2@Q0B?Nl2DY@4?Nl2@Q04>Lh2@Q04?Nl2@Q05Ool10001Ool0
01Eoo`03001oogoo009oo`96<@8icP8]J`96<@8icP92408mk`9:DP8icPA2408e[@A2409:DP8mk`92
408mk`9:DP92408mk`8aS08mk`8icP8mk`92408mk`9BU08aS096<@8e[@92408mk`8icP9JeP8mk`8a
S08mk`ABU08e[@9F]@8icPHmk`9240Pmk`9>L`92408mk`9:DP8icPA:DP96<@9:DP96<@@mk`03>Li:
DTYB00@mk`92408YBP8e[@8mk`9240Pmk`96<@Hmk`92408]J`8icP9F]@@e[@96<@@aS08YBP96<@8e
[@9>L`9240@mk`96<@8mk`9242@mk`92408@Q08e[@8mk`92408icP8e[@92408mk`92409:DPEoo`40
005oo`005Goo0P000goo0THa0SW>0Re[0THa0SW>0T8@0Sg_0TYB0SW>148@0SF]148@0TYB0Sg_0T8@
0Sg_0TYB0T8@0Sg_0S6<0Sg_0SW>0Sg_0T8@0Sg_0U:D0S6<0THa0SF]0T8@0Sg_0SW>0U[F0Sg_0S6<
0Sg_15:D0SF]0UJe0SW>1Sg_0T8@23g_0Tic0T8@0Sg_0TYB0SW>14YB0THa0TYB0THa13g_00<icTYB
BU8013g_0T8@0RU:0SF]0Sg_0T8@23g_0THa1Sg_0T8@0Re[0SW>0UJe13F]0THa136<0RU:0THa0SF]
0Tic0T8@13g_0THa0Sg_0T8@93g_0T8@0Q240SF]0Sg_0T8@0SW>0SF]0T8@0Sg_0T8@0TYB17oo0P00
0Goo000EOol00`00Oomoo`02Ool6=Jd2?Nl2=Jd2>Lh2?Nl2AS44?Nl2>Lh2?Nl2@Q02?Nl2BU82<H`2
@Q02?Nl2AS42?Nl2@Q02AS42BU84?Nl2@Q02;F/2BU82@Q02>Lh2?Nl2>Lh2@Q02?Nl2@Q029BT2=Jd2
DY@2=Jd2@Q02=Jd2@Q02?Nl2@Q04?Nl2BU82AS46?Nl2@Q02>Lh2?Nl2@Q02?Nl2;F/2>Lh2;F/2:DX4
AS43?Nl2>Lh2@Q02AS42CW<2<H`2AS42=Jd29BT2@Q06?Nl2>Lh2?Nl2@Q06?Nl2@Q02>Lh2BU84@Q02
AS42BU82>Lh2=Jd28@P2<H`2E[D2?Nl2@Q02?Nl2@Q04?Nl4@Q08?Nl4=Jd4@Q0@?Nl2=Jd2@Q02?Nl2
@Q04?Nl2@Q02=Jd28@P2?Nl5Ool10001Ool001Eoo`03001oogoo009oo`He[@8mk`8e[@8icP8mk`96
<@@mk`8icP8mk`92408mk`9:DP8aS092408mk`96<@8mk`924096<@9:DP@mk`92408]J`9:DP92408i
cP8mk`8icP92408mk`92408U:@8e[@9BU08e[@92408e[@92408mk`9240@mk`9:DP96<@Hmk`92408i
cP8mk`92408mk`8]J`8icP8]J`8YBPA6<@<mk`8icP924096<@9>L`8aS096<@8e[@8U:@9240Hmk`8i
cP8mk`9240Hmk`92408icP9:DPA24096<@9:DP8icP8e[@8Q208aS09F]@8mk`92408mk`9240@mk`A2
40Pmk`@e[@A2410mk`8e[@92408mk`9240@mk`92408e[@8Q208mk`Eoo`40005oo`005Goo00<007oo
Ool00Woo0THa0P@Q0QcW0V<H0S6<0Ukg0SF]0U:D0SF]0Tic0T8@0UJe0SW>0Tic0THa0SF]0R480U:D
14Ha0TYB0Tic0TYB0S6<0V]J0Tic0S6<0Ukg0PQ20SF]0Re[0THa0TYB0SF]0Sg_0SF]0TYB0R480Sg_
0RU:0T8@0SF]0U[F0QS60THa0RU:0T8@0RU:0T8@13g_0Tic0U:D0Sg_0TYB0UJe0V<H0SW>0THa0T8@
0RDY0TYB0RDY00=BU4YBBU800RU:0T8@0Sg_0T8@0SW>0TYB0SW>13g_0T8@0SF]0UJe0SW>0RU:2Sg_
0THa0TYB0S6<0SW>0SF]0S6<13g_0S6<0THa0Sg_0SF]0T8@0QcW0T8@0S6<0SF]0T8@0SW>0Sg_0T8@
0SW>0TYB0T8@0RU:0SW>2Sg_0T8@0SW>15:D0SW>148@13F]0Sg_0U:D0RU:0U:D1Goo0@000Goo000E
Ool00`00Oomoo`02Ool2AS4212427>L2HaP2<H`2G_L2=Jd2DY@2=Jd2CW<2@Q02E[D2>Lh2CW<2AS42
=Jd28@P2DY@4AS42BU82CW<2BU82<H`2JeX2CW<2<H`2G_L22482=Jd2;F/2AS42BU82=Jd2?Nl2=Jd2
BU828@P2?Nl2:DX2@Q02=Jd2F]H26<H2AS42:DX2@Q02:DX2@Q04?Nl2CW<2DY@2?Nl2BU82E[D2HaP2
>Lh2AS42@Q029BT2BU829BT00e:DBU9:DP02:DX2@Q02?Nl2@Q02>Lh2BU82>Lh4?Nl2@Q02=Jd2E[D2
>Lh2:DX:?Nl2AS42BU82<H`2>Lh2=Jd2<H`4?Nl2<H`2AS42?Nl2=Jd2@Q027>L2@Q02<H`2=Jd2@Q02
>Lh2?Nl2@Q02>Lh2BU82@Q02:DX2>Lh:?Nl2@Q02>Lh4DY@2>Lh4@Q04=Jd2?Nl2DY@2:DX2DY@5Ool1
0001Ool001Eoo`03001oogoo009oo`92409F]@9BU08icP8]J`9>L`@mk`9240@mk`8icPA24096<@8i
cP8e[@9:DP8mk`92408icP8]J`96<@9:DP8]J`8mk`9:DP8]J`9JeP92409:DP92408icP9>L`96<@9>
L`8icP8mk`96<@8]J`8aS08icP8mk`A2409S608e[@8icP96<@`mk`@e[@8]J`9240A6<@8icP9>L`03
AS5:DTYB0096<@9>L`@mk`92408YBP9240Hmk`A:DPPmk`A:DP8mk`@e[@96<@92409:DP9F]@9BU08m
k`96<@92408e[@9:DP8mk`92408mk`9240Hmk`92408YBPHmk`96<@8]J`9241Hmk`I2408e[@96<@8m
k`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@0UJe0U:D0SW>0Re[0Tic13g_0T8@13g_0SW>148@
0THa0SW>0SF]0TYB0Sg_0T8@0SW>0Re[0THa0TYB0Re[0Sg_0TYB0Re[0U[F0T8@0TYB0T8@0SW>0Tic
0THa0Tic0SW>0Sg_0THa0Re[0S6<0SW>0Sg_148@0V<H0SF]0SW>0THa33g_13F]0Re[0T8@14Ha0SW>
0Tic00=6<DYBBU800THa0Tic13g_0T8@0RU:0T8@1Sg_14YB23g_14YB0Sg_13F]0THa0T8@0TYB0UJe
0U:D0Sg_0THa0T8@0SF]0TYB0Sg_0T8@0Sg_0T8@1Sg_0T8@0RU:1Sg_0THa0Re[0T8@5Sg_1T8@0SF]
0THa0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02<H`2>Lh2@Q02AS42<H`2@Q02?Nl2=Jd6
BU82AS42;F/2>Lh2BU82DY@2=Jd2@Q02=Jd2BU82G_L2?Nl2;F/2@Q02DY@2@Q02BU82;F/4?Nl2BU82
>Lh2;F/2@Q06=Jd4@Q02<H`2BU82AS42?Nl2>Lh2CW<2E[D2AS4:?Nl2>Lh2@Q02DY@2?Nl2BU82>Lh4
<H`2BU82=Jd00d8@CW=>L`02?Nl26<H2@Q04?Nl2G_L2?Nl2HaP2AS46?Nl2@Q02?Nl2AS42<H`4@Q02
?Nl2AS42<H`2?Nl2:DX2DY@29BT2DY@2<H`2AS44=Jd2AS42=Jd29BT2@Q0:?Nl2@Q02CW<2DY@2?Nl2
<H`2?Nl2@Q0F?Nl2CW<4?Nl2BU82=Jd2?Nl5Ool10001Ool00003Ool0000000<0009oo`8000Aoo`80
00Eoo`03001oogoo009oo`92408aS08icP924096<@8aS092408mk`8e[@I:DP96<@8]J`8icP9:DP9B
U08e[@92408e[@9:DP9Nm`8mk`8]J`92409BU092409:DP8]J`@mk`9:DP8icP8]J`9240He[@A2408a
S09:DP96<@8mk`8icP9>L`9F]@96<@Xmk`8icP92409BU08mk`9:DP8icP@aS09:DP8e[@03@Q1>Ldic
008mk`8HaP9240@mk`9Nm`8mk`9S6096<@Hmk`92408mk`96<@8aS0A2408mk`96<@8aS08mk`8YBP9B
U08U:@9BU08aS096<@@e[@96<@8e[@8U:@9240Xmk`92409>L`9BU08mk`8aS08mk`9241Hmk`9>L`@m
k`9:DP8e[@8mk`Eoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool2;F/2@Q02?Nl2@Q04=Jd2@Q02AS44?Nl2=Jd2AS42BU82;F/2=Jd4<H`2
=Jd4AS42?Nl2AS44?Nl2>Lh2:DX2?Nl2=Jd2CW<2BU82?Nl2=Jd2<H`2>Lh2@Q02=Jd2>Lh4AS42?Nl4
BU82AS42?Nl2BU82@Q02BU82G_L2=Jd2@Q02?Nl4AS42@Q02?Nl2@Q02=Jd29BT2?Nl2@Q02?Nl2>Lh2
BU800cW><H`aS002:DX2>Lh2@Q04?Nl2>Lh4?Nl2<H`4?Nl2@Q02AS42=Jd2@Q04?Nl2DY@4?Nl2<H`4
>Lh26<H2>Lh2=Jd2BU82@Q02;F/2@Q02?Nl2=Jd2:DX2@Q08?Nl2@Q029BT2=Jd2CW<2BU84?Nl2@Q0<
?Nl4BU82?Nl2@Q02?Nl2>Lh2@Q04?Nl2@Q02>Lh5Ool10001Ool000=oo`05001oogooOol00002Ool0
1000Oomoo`000Woo00<007ooOol00Woo0P000goo0Re[0T8@0Sg_0T8@13F]0T8@0THa13g_0SF]0THa
0TYB0Re[0SF]136<0SF]14Ha0Sg_0THa13g_0SW>0RU:0Sg_0SF]0Tic0TYB0Sg_0SF]0S6<0SW>0T8@
0SF]0SW>14Ha0Sg_14YB0THa0Sg_0TYB0T8@0TYB0Ukg0SF]0T8@0Sg_14Ha0T8@0Sg_0T8@0SF]0RDY
0Sg_0T8@0Sg_0SW>0TYB00<icS6<<H`00RU:0SW>0T8@13g_0SW>13g_0S6<13g_0T8@0THa0SF]0T8@
13g_0U:D13g_0S6<13W>0QS60SW>0SF]0TYB0T8@0Re[0T8@0Sg_0SF]0RU:0T8@23g_0T8@0RDY0SF]
0Tic0TYB13g_0T8@33g_14YB0Sg_0T8@0Sg_0SW>0T8@13g_0T8@0SW>17oo0P000Goo0003Ool01@00
Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9F]@9>L`92409:
DP8YBP9>L`8icP96<@8Li`9BU096<@8mk`96<@8YBP8icP9Nm`8e[@9>L`A6<@8]J`8YBP8e[@92408m
k`9[FP@e[@92409:DP96<@8@Q08mk`8Q2096<@9BU09>L`96<@9JeP8aS096<@8e[@9:DP8icP9:DP8<
H`9BU08U:@9240@mk`9:DP96<@9:DP8aS092409>L`9S608e[@Pmk`03AS5F]EJe009>L`9240Hmk`92
408mk`9240Xmk`92409>L`8YBP96<@@e[@9>L`8mk`8aS096<@8Li`9cW09kgP8DY@9cW08e[@8mk`8i
cP92408]J`9240Xmk`8icP8mk`9>L`8]J`9JeP9:DP8icP9240Xmk`A:DP8mk`9:DP@icP@mk`92408i
cP9240Eoo`40005oo`000goo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`02Ool0
0`00Oomoo`02Ool2E[D2CW<2@Q02BU82:DX2CW<2>Lh2AS427>L2DY@2AS42?Nl2AS42:DX2>Lh2G_L2
=Jd2CW<4AS42;F/2:DX2=Jd2@Q02?Nl2JeX4=Jd2@Q02BU82AS4248@2?Nl28@P2AS42DY@2CW<2AS42
F]H2<H`2AS42=Jd2BU82>Lh2BU8236<2DY@29BT2@Q04?Nl2BU82AS42BU82<H`2@Q02CW<2HaP2=Jd8
?Nl00dHaE[EF]@02CW<2@Q06?Nl2@Q02?Nl2@Q0:?Nl2@Q02CW<2:DX2AS44=Jd2CW<2?Nl2<H`2AS42
7>L2Li`2Nmh25:D2Li`2=Jd2?Nl2>Lh2@Q02;F/2@Q0:?Nl2>Lh2?Nl2CW<2;F/2F]H2BU82>Lh2@Q0:
?Nl4BU82?Nl2BU84>Lh4?Nl2@Q02>Lh2@Q05Ool10001Ool0009oo`8000Aoo`8000Aoo`8000Eoo`03
001oogoo009oo`92408]J`@e[@96<@9>L`@mk`9240@mk`8icP@mk`96<@8aS08]J`92408icP8mk`9:
DP8icP9240@mk`96<@9>L`924096<@8mk`8e[@9BU08mk`A>L`9:DP8mk`9:DP8icP8mk`9>L`96<@8e
[@@mk`9F]@8]J`96<@A240@mk`@icP92408icP8aS08mk`A240Lmk`8icPPmk`9240Hmk`9240Hmk`92
408mk`92408icP9:DP@aS09BU0Pmk`8aS08Li`9JeP8e[@9:DP8e[@8icP8mk`9BU08mk`9240Pmk`8e
[@8aS08icP8YBP8mk`8]J`92408icQ0mk`8icPI240@mk`9>L`9240Eoo`40005oo`005Goo00<007oo
Ool00Woo0T8@0Re[13F]0THa0Tic13g_0T8@13g_0SW>13g_0THa0S6<0Re[0T8@0SW>0Sg_0TYB0SW>
0T8@13g_0THa0Tic0T8@0THa0Sg_0SF]0U:D0Sg_14ic0TYB0Sg_0TYB0SW>0Sg_0Tic0THa0SF]13g_
0UJe0Re[0THa148@13g_13W>0T8@0SW>0S6<0Sg_148@1cg_0SW>23g_0T8@1Sg_0T8@1Sg_0T8@0Sg_
0T8@0SW>0TYB136<0U:D23g_0S6<0QcW0U[F0SF]0TYB0SF]0SW>0Sg_0U:D0Sg_0T8@23g_0SF]0S6<
0SW>0RU:0Sg_0Re[0T8@0SW>43g_0SW>1T8@13g_0Tic0T8@1Goo0@000Goo000EOol00`00Oomoo`02
Ool2DY@2F]H4?Nl2;F/4>Lh2AS42>Lh2;F/2BU82CW<2BU82AS44DY@2=Jd2BU84?Nl2DY@2<H`2BU82
CW<2BU82<H`2:DX2AS42<H`2?Nl2>Lh28@P2AS42@Q0248@2;F/2AS42=Jd2F]H2AS42>Lh4@Q02<H`2
;F/2:DX2?Nl2=Jd2@Q02>Lh2@Q02?Nl2BU82AS42:DX2F]H2<H`2?Nl2=Jd26<H2@Q02<H`2CW<00cW>
?Nlmk`02;F/2BU82CW<2;F/6?Nl2@Q027>L2@Q02?Nl2@Q04?Nl2=Jd2CW<2;F/2=Jd2>Lh2@Q02=Jd4
?Nl2AS42E[D2BU82@Q02=Jd2:DX2AS42<H`2@Q02>Lh2@Q02?Nl2@Q02>Lh2CW<2AS42@Q04=Jd2?Nl2
BU82CW<2?Nl2DY@2?Nl2@Q06?Nl2@Q02?Nl4BU82>Lh2@Q029BT2?Nl2AS42<H`2@Q05Ool10001Ool0
01Eoo`03001oogoo009oo`9BU09JeP@mk`8]J`@icP96<@8icP8]J`9:DP9>L`9:DP96<@ABU08e[@9:
DP@mk`9BU08aS09:DP9>L`9:DP8aS08YBP96<@8aS08mk`8icP8Q2096<@92408@Q08]J`96<@8e[@9J
eP96<@8icPA2408aS08]J`8YBP8mk`8e[@92408icP92408mk`9:DP96<@8YBP9JeP8aS08mk`8e[@8H
aP92408aS09>L`03>Lhmkcg_008]J`9:DP9>L`8]J`Hmk`92408Li`92408mk`9240@mk`8e[@9>L`8]
J`8e[@8icP92408e[@@mk`96<@9F]@9:DP92408e[@8YBP96<@8aS092408icP92408mk`92408icP9>
L`96<@9240@e[@8mk`9:DP9>L`8mk`9BU08mk`9240Hmk`92408mk`A:DP8icP92408U:@8mk`96<@8a
S09240Eoo`40005oo`005Goo00<007ooOol00Woo0Re[14Ha0SW>0Tic0SF]0THa0SF]13W>0RU:0T8@
0Sg_0T8@0SW>0Re[0TYB0S6<0SW>0Sg_0SW>0SF]0Re[0T8@0Sg_1SF]0Re[0RU:0SW>0Tic0T8@0THa
0V]J0SF]0THa0SW>0SF]0S6<0RU:0Tic0SW>0S6<0Re[0U:D0SW>0Tic0Re[13g_0T8@0U:D0SW>0U:D
13F]13g_0THa0Sg_0T8@0cg_0SW>0RU:0TYB0Sg_0T8@23g_0T8@3Sg_0THa0Re[0Tic0Sg_0SF]0RU:
0SW>0T8@0THa0S6<0THa0T8@0W>L0SW>0R4813g_0T8@0Sg_0T8@0RDY14ic0Sg_0TYB0Sg_0U:D0Re[
0Sg_14YB0Sg_0T8@1Sg_0T8@0SF]1T8@13F]0T8@13F]0T8@1Goo0@000Goo000EOol00`00Oomoo`02
Ool2;F/4AS42>Lh2CW<2=Jd2AS42=Jd4>Lh2:DX2@Q02?Nl2@Q02>Lh2;F/2BU82<H`2>Lh2?Nl2>Lh2
=Jd2;F/2@Q02?Nl6=Jd2;F/2:DX2>Lh2CW<2@Q02AS42JeX2=Jd2AS42>Lh2=Jd2<H`2:DX2CW<2>Lh2
<H`2;F/2DY@2>Lh2CW<2;F/4?Nl2@Q02DY@2>Lh2DY@4=Jd4?Nl2AS42?Nl2@Q03?Nl2>Lh2:DX2BU82
?Nl2@Q08?Nl2@Q0>?Nl2AS42;F/2CW<2?Nl2=Jd2:DX2>Lh2@Q02AS42<H`2AS42@Q02Li`2>Lh28@P4
?Nl2@Q02?Nl2@Q029BT4CW<2?Nl2BU82?Nl2DY@2;F/2?Nl4BU82?Nl2@Q06?Nl2@Q02=Jd6@Q04=Jd2
@Q04=Jd2@Q05Ool10001Ool001Eoo`03001oogoo009oo`@]J`8mk`8icP8U:@8aS0@icP92408e[@9B
U09>L`8icP8mk`9F]@9:DP8mk`9>L`92409>L`8mk`8YBP8mk`9:DP8icP9BU08icP8mk`9:DP@mk`8a
S0@mk`8DY@9_N`8Q208]J`96<@8U:@8e[@8mk`92408aS08e[@96<@8Li`92409Nm`8e[@9240@mk`8i
cP8]J`9F]@8mk`@icP8@Q096<@8icP<mk`8aS096<@@mk`9BU08YBP8icP92408mk`8icP9240Xmk`92
408icP9F]@9>L`92408HaP9S609F]@8aS08mk`9BU09240@e[@8aS096<@9240Hmk`92408aS08icP8]
J`9>L`92408aS09>L`9W>@8aS08e[@A240Xmk`92409BU0@mk`9:DP9>L`8aS09:DP92408mk`Eoo`40
005oo`005Goo0P000goo12e[0Sg_0SW>0RDY0S6<13W>0T8@0SF]0U:D0Tic0SW>0Sg_0UJe0TYB0Sg_
0Tic0T8@0Tic0Sg_0RU:0Sg_0TYB0SW>0U:D0SW>0Sg_0TYB13g_0S6<13g_0QBU0Vmk0R480Re[0THa
0RDY0SF]0Sg_0T8@0S6<0SF]0THa0QcW0T8@0Ukg0SF]0T8@13g_0SW>0Re[0UJe0Sg_13W>0Q240THa
0SW>0cg_0S6<0THa13g_0U:D0RU:0SW>0T8@0Sg_0SW>0T8@2Sg_0T8@0SW>0UJe0Tic0T8@0QS60V<H
0UJe0S6<0Sg_0U:D0T8@13F]0S6<0THa0T8@1Sg_0T8@0S6<0SW>0Re[0Tic0T8@0S6<0Tic0VLi0S6<
0SF]148@2Sg_0T8@0U:D13g_0TYB0Tic0S6<0TYB0T8@0Sg_17oo0P000Goo000EOol00`00Oomoo`02
Ool4>Lh2BU82:DX2HaP2CW<2AS42CW<2=Jd2>Lh2<H`2AS42CW<2?Nl2@Q02DY@2<H`2=Jd2@Q02;F/2
AS42BU82AS42CW<2AS42>Lh2=Jd2@Q02?Nl2=Jd2>Lh2BU84?Nl2AS44>Lh2AS42=Jd2E[D2AS46?Nl2
:DX2BU82@Q02CW<2<H`2AS42>Lh2@Q02<H`2AS42CW<6>Lh2@Q02BU82>Lh2BU82AS400cg_<H`aS002
@Q04?Nl2>Lh2AS42<H`2@Q02>Lh2BU82=Jd4?Nl2@Q08?Nl2>Lh2<H`2;F/2DY@29BT2?Nl4@Q02>Lh2
?Nl2CW<2F]H2AS42?Nl2<H`8?Nl2AS42>Lh2?Nl2AS42@Q02AS42=Jd2BU82?Nl2AS44?Nl2@Q04?Nl2
@Q02?Nl2AS42>Lh2?Nl2@Q02<H`2;F/2AS42>Lh2?Nl2>Lh5Ool10001Ool001Eoo`03001oogoo009o
o`@icP9:DP8YBP9S609>L`96<@9>L`8e[@8icP8aS096<@9>L`8mk`92409BU08aS08e[@92408]J`96
<@9:DP96<@9>L`96<@8icP8e[@92408mk`8e[@8icP9:DP@mk`96<@@icP96<@8e[@9F]@96<@Hmk`8Y
BP9:DP92409>L`8aS096<@8icP92408aS096<@9>L`HicP92409:DP8icP9:DP96<@03?NlaS36<0092
40@mk`8icP96<@8aS092408icP9:DP8e[@@mk`9240Pmk`8icP8aS08]J`9BU08U:@8mk`A2408icP8m
k`9>L`9JeP96<@8mk`8aS0Pmk`96<@8icP8mk`96<@924096<@8e[@9:DP8mk`96<@@mk`9240@mk`92
408mk`96<@8icP8mk`92408aS08]J`96<@8icP8mk`8icPEoo`40005oo`005Goo00<007ooOol00Woo
0SF]0THa13F]13g_0S6<0RU:0THa0SF]0U:D0T8@0TYB0T8@0UJe0TYB0UJe0P0014Ha0SW>0T8@0THa
148@0U:D0T8@0S6<14Ha0SF]0U:D0T8@14ic0Sg_0T8@0S6<0U[F0RDY0T8@0S6<0SW>0T8@0Re[0Sg_
0SW>0T8@0SF]0Sg_0T8@0SF]0U:D0Sg_0SW>0Tic0THa0RU:0T8@13g_0T8@0S6<00<icTYBBU800SF]
0T8@0Ukg0TYB13g_0T8@13g_0THa0TYB0Sg_0Re[0T8@0Sg_0SW>0U:D0UJe13F]0SW>1Sg_0S6<0THa
0S6<0TYB148@13g_0SW>0SF]0T8@0Sg_0T8@0Sg_0SF]0SW>0Re[0SF]0Ukg0S6<0UJe148@0SW>0SF]
13g_0SF]0T8@136<0T8@0Sg_0THa0TYB0UJe0Sg_0T8@0Tic1Goo0@000Goo000EOol00`00Oomoo`02
Ool2=Jd2AS44=Jd4?Nl2<H`2:DX2AS42=Jd2DY@2@Q02BU82@Q02E[D2BU82E[D20004AS42>Lh2@Q02
AS44@Q02DY@2@Q02<H`4AS42=Jd2DY@2@Q04CW<2?Nl2@Q02<H`2F]H29BT2@Q02<H`2>Lh2@Q02;F/2
?Nl2>Lh2@Q02=Jd2?Nl2@Q02=Jd2DY@2?Nl2>Lh2CW<2AS42:DX2@Q04?Nl2@Q02<H`00cW>BU9:DP02
=Jd2@Q02G_L2BU84?Nl2@Q04?Nl2AS42BU82?Nl2;F/2@Q02?Nl2>Lh2DY@2E[D4=Jd2>Lh6?Nl2<H`2
AS42<H`2BU84@Q04?Nl2>Lh2=Jd2@Q02?Nl2@Q02?Nl2=Jd2>Lh2;F/2=Jd2G_L2<H`2E[D4@Q02>Lh2
=Jd4?Nl2=Jd2@Q04<H`2@Q02?Nl2AS42BU82E[D2?Nl2@Q02CW<5Ool10001Ool001Eoo`03001oogoo
009oo`9BU08YBP9>L`96<@9F]@8icP8mk`9:DP8aS08icP8Q209:DP8]J`8aS08]J`8e[@9240@mk`8e
[@8mk`9:DP8]J`96<@9F]@8aS09BU09:DP8e[@8aS09:DP9BU096<@92409BU08mk`8]J`8mk`8Q209F
]@9JeP9F]@96<@8icP96<@9BU08icP96<@8mk`8icP9:DP8e[@@icP9:DP96<@8e[@8YBP96<@@mk`92
408aS003@Q1>Ldic008e[@9:DP92408aS09240Pmk`92409:DP8icP8e[@9240@mk`92408aS09:DP8m
k`9240A:DP92408icP96<@8icP96<@8icP9:DP8icPA6<@9>L`8icP92408aS0I2409>L`92409:DP@i
cP@mk`9240Hmk`8]J`8mk`A2408mk`92409:DP@mk`9240@U:@Eoo`40005oo`005Goo00<007ooOol0
0Woo0U:D0RU:0Tic0THa0UJe0SW>0Sg_0TYB0S6<0SW>0R480TYB0Re[0S6<0Re[0SF]0T8@13g_0SF]
0Sg_0TYB0Re[0THa0UJe0S6<0U:D0TYB0SF]0S6<0TYB0U:D0THa0T8@0U:D0Sg_0Re[0Sg_0R480UJe
0U[F0UJe0THa0SW>0THa0U:D0SW>0THa0Sg_0SW>0TYB0SF]13W>0TYB0THa0SF]0RU:0THa13g_0T8@
0S6<00=244icCW<00SF]0TYB0T8@0S6<0T8@23g_0T8@0TYB0SW>0SF]0T8@13g_0T8@0S6<0TYB0Sg_
0T8@14YB0T8@0SW>0THa0SW>0THa0SW>0TYB0SW>14Ha0Tic0SW>0T8@0S6<1T8@0Tic0T8@0TYB13W>
13g_0T8@1Sg_0Re[0Sg_148@0Sg_0T8@0TYB13g_0T8@12DY1Goo0@000Goo000EOol00`00Oomoo`02
Ool2BU82=Jd2;F/2<H`2?Nl2F]H27>L2@Q04;F/2?Nl2DY@2E[D2IcT2:DX4@Q028@P4BU82;F/2>Lh2
7>L2?Nl26<H4AS42>Lh29BT2>Lh2E[D28@P4@Q02E[D2=Jd2AS42;F/2<H`21242@Q02BU82;F/2G_L2
?Nl2CW<2?Nl2=Jd2?Nl248@2CW<29BT2CW<2>Lh2:DX2>Lh4BU82<H`2@Q02;F/2>Lh2?Nl00cF]7>LL
i`02@Q027>L2=Jd27>L2?Nl2AS42BU84?Nl2AS42>Lh2@Q02>Lh2?Nl2@Q02?Nl2@Q02=Jd2AS42@Q02
?Nl4@Q02<H`29BT2?Nl29BT2CW<2?Nl25:D2@Q02:DX2<H`2?Nl2@Q02CW<29BT2@Q02<H`2F]H2=Jd2
?Nl2>Lh2BU82CW<2;F/2?Nl2BU829BT2@Q02E[D2CW<2>Lh6?Nl2AS42>Lh2F]H2>Lh4=Jd2G_L5Ool1
0001Ool001Eoo`03001oogoo009oo`9:DP8e[@8]J`8aS08mk`9JeP8Li`9240@]J`8mk`9BU09F]@9W
>@8YBPA2408Q20A:DP8]J`8icP8Li`8mk`8HaPA6<@8icP8U:@8icP9F]@8Q20A2409F]@8e[@96<@8]
J`8aS0848@92409:DP8]J`9Nm`8mk`9>L`8mk`8e[@8mk`8@Q09>L`8U:@9>L`8icP8YBP8icPA:DP8a
S092408]J`8icP8mk`03=JdLiacW0092408Li`8e[@8Li`8mk`96<@9:DP@mk`96<@8icP92408icP8m
k`92408mk`92408e[@96<@92408mk`A2408aS08U:@8mk`8U:@9>L`8mk`8DY@92408YBP8aS08mk`92
409>L`8U:@92408aS09JeP8e[@8mk`8icP9:DP9>L`8]J`8mk`9:DP8U:@92409F]@9>L`8icPHmk`96
<@8icP9JeP8icP@e[@9Nm`Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0Tic0Sg_0U:D13g_0TYB
0Sg_148@0THa0S6<0T8@0S6<0THa0SW>0T8@0TYB0SW>0THa0SW>0TYB0VLi0Sg_0TYB0SW>0Sg_0THa
0TYB0Tic0T8@0U:D13g_0SW>0T8@0Sg_0Ukg0S6<0UJe13g_0T8@0Sg_0Tic0SW>0Sg_0U:D0TYB0THa
0Re[0THa0SW>0U:D13g_0S6<0Re[0Tic0R480SW>0Sg_0SF]00=243g_?Nl00T8@0THa0QS60SW>0Ukg
0Sg_0T8@13g_0THa0Tic0SW>148@1Sg_0T8@1Sg_0SW>0T8@0S6<0UJe0TYB0SF]0U:D0RDY0Sg_0SW>
0UJe148@13g_0SW>0TYB0Sg_0SW>0T8@0Sg_0T8@0SW>0Sg_0Tic13g_0T8@14YB0SW>0T8@0Sg_0T8@
0SF]0S6<0SF]0SW>0THa0Ukg0RDY0Q241Goo0@000Goo000EOol20003Ool2>Lh2CW<2?Nl2DY@4?Nl2
BU82?Nl4@Q02AS42<H`2@Q02<H`2AS42>Lh2@Q02BU82>Lh2AS42>Lh2BU82IcT2?Nl2BU82>Lh2?Nl2
AS42BU82CW<2@Q02DY@4?Nl2>Lh2@Q02?Nl2G_L2<H`2E[D4?Nl2@Q02?Nl2CW<2>Lh2?Nl2DY@2BU82
AS42;F/2AS42>Lh2DY@4?Nl2<H`2;F/2CW<28@P2>Lh2?Nl2=Jd00d8@?Nlmk`02@Q02AS426<H2>Lh2
G_L2?Nl2@Q04?Nl2AS42CW<2>Lh4@Q06?Nl2@Q06?Nl2>Lh2@Q02<H`2E[D2BU82=Jd2DY@29BT2?Nl2
>Lh2E[D4@Q04?Nl2>Lh2BU82?Nl2>Lh2@Q02?Nl2@Q02>Lh2?Nl2CW<4?Nl2@Q04BU82>Lh2@Q02?Nl2
@Q02=Jd2<H`2=Jd2>Lh2AS42G_L29BT248@4Ool20001Ool001Eoo`03001oogoo009oo`8icP9F]@92
408e[@9S609:DP8icP9>L`8icP9F]@I:DP@e[@9>L`92408icP9>L`AF]@8mk`8icP96<@8YBPA:DP@i
cP8mk`8icP9BU08mk`8e[@924096<@9:DP8]J`8icP8aS08e[@96<@8mk`96<@8mk`9JeP9F]@8aS08i
cP8mk`92409>L`8mk`96<@Hmk`9JeP8e[@8aS08e[@@icP03?NmJeU[F008icP8aS08mk`96<@9240A6
<@@mk`92408]J`9:DP9F]@8e[@9S608mk`92408mk`92408mk`A:DP8icP96<@8]J`8aS08icP92409>
L`8icP8aS08icPPmk`9240Hmk`9BU08aS08mk`8Li`92408icP9240Xmk`96<@8icP8mk`9BU09:DP96
<@8mk`9>L`8]J`9BU09240Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0UJe0T8@0SF]0V<H0TYB
0SW>0Tic0SW>0UJe1TYB13F]0Tic0T8@0SW>0Tic15Je0Sg_0SW>0THa0RU:14YB13W>0Sg_0SW>0U:D
0Sg_0SF]0T8@0THa0TYB0Re[0SW>0S6<0SF]0THa0Sg_0THa0Sg_0U[F0UJe0S6<0SW>0Sg_0T8@0Tic
0Sg_0THa1Sg_0U[F0SF]0S6<0SF]13W>00<mke[FF]H00SW>0S6<0Sg_0THa0T8@14Ha13g_0T8@0Re[
0TYB0UJe0SF]0V<H0Sg_0T8@0Sg_0T8@0Sg_14YB0SW>0THa0Re[0S6<0SW>0T8@0Tic0SW>0S6<0SW>
23g_0T8@1Sg_0U:D0S6<0Sg_0QcW0T8@0SW>0T8@2Sg_0THa0SW>0Sg_0U:D0TYB0THa0Sg_0Tic0Re[
0U:D0T8@1Goo0@000Goo000EOol00`00Oomoo`02Ool2@Q02;F/2?Nl2AS42BU84@Q04>Lh2?Nl27>L2
?Nl2<H`2@Q02>Lh2@Q02>Lh2@Q04>Lh2BU82E[D2;F/2BU82E[D2?Nl2>Lh4=Jd2CW<4?Nl2BU84=Jd2
>Lh2:DX2AS42BU82=Jd2G_L4=Jd8?Nl6@Q04?Nl4@Q02<H`2;F/2=Jd2AS427>L2;F/2CW<2@Q02<H`0
0d8@>LhicP02?Nl2@Q02?Nl2=Jd2BU82<H`2=Jd2@Q02?Nl2@Q02<H`4AS42BU82>Lh2@Q02>Lh2=Jd4
@Q02=Jd2@Q02CW<2>Lh2AS42>Lh2=Jd2AS42;F/2BU84AS42?Nl4BU84?Nl2@Q06?Nl6@Q02>Lh2@Q06
?Nl2@Q08?Nl2@Q02=Jd2CW<2@Q02=Jd2?Nl2DY@2HaP2>Lh5Ool10001Ool001Eoo`03001oogoo009o
o`92408]J`8mk`96<@9:DPA240@icP8mk`8Li`8mk`8aS092408icP92408icP9240@icP9:DP9F]@8]
J`9:DP9F]@8mk`8icP@e[@9>L`@mk`9:DP@e[@8icP8YBP96<@9:DP8e[@9Nm`@e[@Pmk`I240@mk`A2
408aS08]J`8e[@96<@8Li`8]J`9>L`92408aS003@Q0icSW>008mk`92408mk`8e[@9:DP8aS08e[@92
408mk`92408aS0A6<@9:DP8icP92408icP8e[@A2408e[@92409>L`8icP96<@8icP8e[@96<@8]J`9:
DPA6<@8mk`A:DP@mk`9240Hmk`I2408icP9240Hmk`9240Pmk`92408e[@9>L`92408e[@8mk`9BU09S
608icPEoo`40005oo`005Goo00<007ooOol00Woo0THa0Tic0SF]0RU:0QcW0RDY0THa0Re[0SF]0Sg_
0Re[0UJe0T8@0THa0TYB0SW>0V<H13W>0UJe0TYB13F]0T8@0SW>0Tic148@0SW>0RU:0SW>0UJe0TYB
0THa0TYB0Sg_0THa0Sg_0Re[0S6<0Tic0R480SF]0THa0V<H0P000TYB0SF]1Sg_0THa0TYB0Re[0UJe
0Sg_0T8@0Tic13g_0S6<0Sg_0T8@00=:DTicCW<00T8@0U:D0T8@0THa0Re[0Tic0TYB0Sg_0T8@0Sg_
0T8@0SW>14YB13g_0THa0TYB0Sg_0T8@0Sg_13W>0T8@0SW>14YB0Sg_0RU:0V<H0WNm0Sg_0U:D0Sg_
0UJe0SW>0Tic0SW>0SF]0RU:0SF]0SW>0Sg_0T8@0Tic0Sg_0T8@2Sg_0T8@0SF]0Sg_0SF]0S6<0Sg_
0Tic0Re[0Ukg0UJe0V<H1Goo0@000Goo000EOol00`00Oomoo`02Ool2AS42CW<2=Jd2:DX27>L29BT2
AS42;F/2=Jd2?Nl2;F/2E[D2@Q02AS42BU82>Lh2HaP4>Lh2E[D2BU84=Jd2@Q02>Lh2CW<4@Q02>Lh2
:DX2>Lh2E[D2BU82AS42BU82?Nl2AS42?Nl2;F/2<H`2CW<28@P2=Jd2AS42HaP20002BU82=Jd6?Nl2
AS42BU82;F/2E[D2?Nl2@Q02CW<4?Nl2<H`2?Nl2@Q000dYBCW=>L`02@Q02DY@2@Q02AS42;F/2CW<2
BU82?Nl2@Q02?Nl2@Q02>Lh4BU84?Nl2AS42BU82?Nl2@Q02?Nl4>Lh2@Q02>Lh4BU82?Nl2:DX2HaP2
Mkd2?Nl2DY@2?Nl2E[D2>Lh2CW<2>Lh2=Jd2:DX2=Jd2>Lh2?Nl2@Q02CW<2?Nl2@Q0:?Nl2@Q02=Jd2
?Nl2=Jd2<H`2?Nl2CW<2;F/2G_L2E[D2HaP5Ool10001Ool001Eoo`03001oogoo009oo`92408YBP9>
L`@mk`92408mk`A6<@92409:DP8]J`8mk`8icP8]J`96<@8aS0@mk`8aS096<@9:DP96<@8e[@92408Y
BP8e[@92408aS08mk`9:DP8icP8]J`9:DP8]J`92408]J`8mk`96<@8e[@8icP9JeP9>L`8mk`8icPI6
<@Pmk`8icP8aS09BU09F]@96<@8mk`9:DPI2408mk`03<H`icSW>0096<@9240@mk`9F]@8e[@8icP92
40Hmk`92408aS0A:DP8icP9Nm`8icP9240@mk`9:DP9>L`8icP92408mk`8icP9240@mk`96<@8mk`8Y
BP9JeP8aS092408icP@mk`9240@mk`9:DP9>L`92410mk`92408icP9:DP8mk`8aS0@mk`8U:@9S609>
L`Eoo`40005oo`005Goo00<007ooOol00Woo0T8@0RU:0Tic13g_0T8@0Sg_14Ha0T8@0TYB0Re[0Sg_
0SW>0Re[0THa0S6<13g_0S6<0THa0TYB0THa0SF]0T8@0RU:0SF]0T8@0S6<0Sg_0TYB0SW>0Re[0TYB
0Re[0T8@0Re[0Sg_0THa0SF]0SW>0U[F0Tic0Sg_0SW>1THa23g_0SW>0S6<0U:D0UJe0THa0Sg_0TYB
1T8@0Sg_00<aS3W>>Lh00THa0T8@13g_0UJe0SF]0SW>0T8@1Sg_0T8@0S6<14YB0SW>0Ukg0SW>0T8@
13g_0TYB0Tic0SW>0T8@0Sg_0SW>0T8@13g_0THa0Sg_0RU:0U[F0S6<0T8@0SW>13g_0T8@13g_0TYB
0Tic0T8@43g_0T8@0SW>0TYB0Sg_0S6<13g_0RDY0V<H0Tic1Goo0@000Goo000EOol00`00Oomoo`02
Ool2CW<2@Q02?Nl2BU829BT2>Lh2@Q04?Nl2CW<2>Lh2BU82@Q02=Jd2>Lh2BU86?Nl2@Q02AS42BU82
AS42?Nl2=Jd2?Nl2AS42@Q02BU82E[D2;F/2>Lh2;F/6@Q02=Jd2CW<2@Q02BU82G_L2<H`2>Lh2AS42
@Q02<H`2:DX2AS46?Nl4@Q02BU82?Nl2>Lh2CW<2@Q04>Lh2=Jd4?Nl00cF]@Q124002?Nl2BU82E[D2
?Nl2>Lh4BU88?Nl2@Q02=Jd2CW<2BU84?Nl2@Q06?Nl2@Q02;F/2?Nl2AS42BU84?Nl2>Lh2<H`2@Q02
>Lh2AS42HaP2=Jd2?Nl2@Q04?Nl2@Q02<H`2;F/2?Nl2;F/2>Lh2@Q0<?Nl2@Q02?Nl2BU82E[D2?Nl2
G_L2;F/2G_L2?Nl2E[D2>Lh5Ool10001Ool001Eoo`8000=oo`9>L`92408mk`9:DP8U:@8icP9240@m
k`9>L`8icP9:DP92408e[@8icP9:DPHmk`924096<@9:DP96<@8mk`8e[@8mk`96<@92409:DP9F]@8]
J`8icP8]J`I2408e[@9>L`92409:DP9Nm`8aS08icP96<@92408aS08YBP96<@Hmk`A2409:DP8mk`8i
cP9>L`9240@icP8e[@@mk`03=Je2448@008mk`9:DP9F]@8mk`8icPA:DPPmk`92408e[@9>L`9:DP@m
k`9240Hmk`92408]J`8mk`96<@9:DP@mk`8icP8aS092408icP96<@9S608e[@8mk`9240@mk`92408a
S08]J`8mk`8]J`8icP9240`mk`92408mk`9:DP9F]@8mk`9Nm`8]J`9Nm`8mk`9F]@8icPAoo`80005o
o`005Goo00<007ooOol00Woo0THa0SW>0SF]0R480Sg_136<0T8@0U:D14ic0TYB0THa0UJe0Tic0T8@
0Tic0SW>0T8@0Re[0Tic0Sg_0SW>148@0R480Re[0T8@0S6<0T8@0U:D0THa0SF]0U[F0S6<0Re[0RDY
0SW>0Sg_0SF]0Tic0SF]0S6<0TYB12e[0TYB0Sg_0T8@13g_0SW>0Sg_0THa0RU:0SF]0T8@0SF]13g_
0SW>13g_00<e[Cg_?Nl00Sg_0U:D0Sg_148@0Sg_0T8@0Sg_0T8@13g_0T8@0SF]0Re[0THa0Re[0THa
13g_0T8@0R480U:D0Sg_0SF]13g_0T8@0SW>0T8@0Ukg0SF]0TYB0T8@0Sg_0RU:0Sg_0SF]0THa0S6<
0U:D0SW>63g_0T8@0Re[0T8@0U[F0RDY0QBU0Tic0TYB0SW>0T8@1Goo0@000Goo000EOol00`00Oomo
o`02Ool2AS42>Lh2=Jd28@P2?Nl4<H`2@Q02DY@4CW<2BU82AS42E[D2CW<2@Q02CW<2>Lh2@Q02;F/2
CW<2?Nl2>Lh4@Q028@P2;F/2@Q02<H`2@Q02DY@2AS42=Jd2F]H2<H`2;F/29BT2>Lh2?Nl2=Jd2CW<2
=Jd2<H`2BU84;F/2BU82?Nl2@Q04?Nl2>Lh2?Nl2AS42:DX2=Jd2@Q02=Jd4?Nl2>Lh4?Nl00cF]?Nlm
k`02?Nl2DY@2?Nl4@Q02?Nl2@Q02?Nl2@Q04?Nl2@Q02=Jd2;F/2AS42;F/2AS44?Nl2@Q028@P2DY@2
?Nl2=Jd4?Nl2@Q02>Lh2@Q02G_L2=Jd2BU82@Q02?Nl2:DX2?Nl2=Jd2AS42<H`2DY@2>LhH?Nl2@Q02
;F/2@Q02F]H29BT25:D2CW<2BU82>Lh2@Q05Ool10001Ool001Eoo`03001oogoo009oo`8U:@8e[@Ic
W09g_@9oo`9F]@88@P@0008@Q080008HaP8U:@8000A2408icP9_N`8mk`9:DP96<@92408icP8aS092
408@Q092409>L`8icP8aS092408Q209>L`8aS08icP9F]@8icP8]J`9>L`8Li`A2409g_@8YBP96<@@m
k`A24096<@9F]@92408icP8]J`I6<@8icP9F]@8mk`9240<mk`92408Q208icP96<@9>L`92409F]@9:
DP8icP8mk`92408mk`A2408mk`8icP8e[@@mk`92409:DP8e[@8icP9>L`8mk`92408icP9Nm`8mk`9B
U08U:@8icP8]J`9[FP9:DP8mk`92408U:@9F]@92409F]@8aS08icPXmk`9240Hmk`96<@8YBP8aS096
<@8icP8Li`8icP8U:@8e[@@mk`Eoo`40005oo`005Goo00<007ooOol00Woo0RDY0SF]1W>L0WNm0Woo
0UJe0PQ210000Q240P000QS60RDY0P00148@0SW>0Vmk0Sg_0TYB0THa0T8@0SW>0S6<0T8@0Q240T8@
0Tic0SW>0S6<0T8@0R480Tic0S6<0SW>0UJe0SW>0Re[0Tic0QcW148@0WNm0RU:0THa13g_148@0THa
0UJe0T8@0SW>0Re[1THa0SW>0UJe0Sg_0T8@0cg_0T8@0R480SW>0THa0Tic0T8@0UJe0TYB0SW>0Sg_
0T8@0Sg_148@0Sg_0SW>0SF]13g_0T8@0TYB0SF]0SW>0Tic0Sg_0T8@0SW>0Ukg0Sg_0U:D0RDY0SW>
0Re[0V]J0TYB0Sg_0T8@0RDY0UJe0T8@0UJe0S6<0SW>2Sg_0T8@1Sg_0THa0RU:0S6<0THa0SW>0QcW
0SW>0RDY0SF]13g_1Goo0@000Goo000EOol00`00Oomoo`04Ool2DY@<000@Ool2BU82=Jd2?Nl20002
CW<2=Jd2AS42BU82=Jd2DY@2?Nl2DY@2AS42=Jd2<H`2HaP2?Nl2DY@29BT2AS42?Nl4<H`2F]H28@P2
CW<2>Lh2?Nl2AS42DY@2>Lh4@Q02>Lh2?Nl2;F/236<2BU828@P2@Q04?Nl2@Q02>Lh2?Nl2G_L2AS40
0dic?Nlmk`02?Nl2@Q02>Lh4AS44?Nl2@Q02CW<2DY@28@P2@Q06?Nl4@Q02=Jd2BU82>Lh2?Nl2<H`2
@Q04>Lh2E[D2BU84<H`29BT2=Jd4@Q04>Lh2@Q02=Jd2G_L2=Jd2?Nl2BU82?Nl2@Q02CW<6?Nl2@Q02
>Lh2@Q02?Nl2@Q02;F/2Kg/2BU82;F/2>Lh2@Q02CW<8?Nl5Ool10001Ool001Eoo`03001oogoo00Ao
o`9BU0`0011oo`9:DP8e[@8mk`80009>L`8e[@96<@9:DP8e[@9BU08mk`9BU096<@8e[@8aS09S608m
k`9BU08U:@96<@8mk`@aS09JeP8Q209>L`8icP8mk`96<@9BU08icPA2408icP8mk`8]J`8<H`9:DP8Q
209240@mk`92408icP8mk`9Nm`96<@03CW<mkcg_008mk`92408icPA6<@@mk`92409>L`9BU08Q2092
40Hmk`A2408e[@9:DP8icP8mk`8aS09240@icP9F]@9:DP@aS08U:@8e[@A240@icP92408e[@9Nm`8e
[@8mk`9:DP8mk`92409>L`Hmk`92408icP92408mk`92408]J`9_N`9:DP8]J`8icP92409>L`Pmk`Eo
o`40005oo`005Goo00<007ooOol00Woo100037oo40000Sg_0UJe0U:D0Woo0P000U[F0Re[0RDY0SW>
0RU:0Tic0R480QBU0Ukg0W_N0RDY0SF]0S6<0U:D0SW>0SF]0THa0U[F0S6<0Woo0Q240U:D0SF]0S6<
0VLi0S6<0SF]0Sg_0U[F0Sg_17oo0P000Ukg0U:D0SW>0U:D0TYB0Sg_0Ukg0P@Q0Ukg00<U:CW>>Lh0
14ic0THa0SF]0UJe0THa0TYB0Tic0RU:0SW>0Sg_0T8@13W>0T8@0SF]0T8@0THa0SF]0T8@0Sg_0T8@
13g_0THa0T8@0THa0Tic0U:D0U[F0Tic0Sg_0U:D0T8@1Sg_14Ha0Tic0THa0T8@0THa0SW>13g_0T8@
0SW>0Tic0SF]0Sg_0S6<0Woo0P000R480THa1SW>0SF]0S6<0T8@0Sg_1Goo0@000Goo00000goo0000
000300000goo000000020003Ool20005Ool00`00Oomoo`02Ool4000<Ool@0002?Nl2E[D2DY@2Ool2
0002F]H2;F/29BT2>Lh2:DX2CW<28@P25:D2G_L2Nmh29BT2=Jd2<H`2DY@2>Lh2=Jd2AS42F]H2<H`2
Ool248@2DY@2=Jd2<H`2IcT2<H`2=Jd2?Nl2F]H2?Nl4Ool20002G_L2DY@2>Lh2DY@2BU82?Nl2G_L2
1242G_L00bDY>LhicP04CW<2AS42=Jd2E[D2AS42BU82CW<2:DX2>Lh2?Nl2@Q04>Lh2@Q02=Jd2@Q02
AS42=Jd2@Q02?Nl2@Q04?Nl2AS42@Q02AS42CW<2DY@2F]H2CW<2?Nl2DY@2@Q06?Nl4AS42CW<2AS42
@Q02AS42>Lh4?Nl2@Q02>Lh2CW<2=Jd2?Nl2<H`2Ool200028@P2AS46>Lh2=Jd2<H`2@Q02?Nl5Ool1
0001Ool000=oo`05001oogooOol00005Ool01000Oomoo`0017oo00<007ooOol00Woo0PaS0Re[2Woo
0WNm40000Sg_0TYB0SF]0VLi0S6<0T8@0SW>148@13W>0S6<0Sg_0R480V<H0Sg_0SW>0Sg_0T8@13F]
0RU:0U:D0S6<0SW>0U:D0S6<0SF]0THa0SF]0T8@0Sg_0THa0RDY0Tic0UJe0THa0SF]0T8@23g_0T8@
136<0THa00<e[D8@@Q0013g_0T8@0SW>13g_0SW>0THa0SF]0Sg_0SW>0U[F0UJe0Sg_0T8@13g_0T8@
0Sg_0T8@13F]0T8@0THa13g_0THa0Tic0S6<0Tic0TYB0R480S6<0Sg_14Ha0T8@3Sg_0THa13g_0TYB
0Sg_0T8@0S6<0QS60Ukg0PaS2Sg_148@13g_1Goo0@000Goo0003Ool00`00Oomoo`02Ool00`00Oomo
o`02Ool01000Oomoo`0017oo0P000goo0PaS0Re[2Woo0WNm40000Sg_0TYB0SF]0VLi0S6<0T8@0SW>
148@13W>0S6<0Sg_0R480V<H0Sg_0SW>0Sg_0T8@13F]0RU:0U:D0S6<0SW>0U:D0S6<0SF]0THa0SF]
0T8@0Sg_0THa0RDY0Tic0UJe0THa0SF]0T8@23g_0T8@136<0THa00<e[D8@@Q0013g_0T8@0SW>13g_
0SW>0THa0SF]0Sg_0SW>0U[F0UJe0Sg_0T8@13g_0T8@0Sg_0T8@13F]0T8@0THa13g_0THa0Tic0S6<
0Tic0TYB0R480S6<0Sg_14Ha0T8@3Sg_0THa13g_0TYB0Sg_0T8@0S6<0QS60Ukg0PaS2Sg_148@13g_
17oo0P000Goo0003Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007oo
Ool00Woo0U:D0SF]0SW>0S6<0TYB0SF]0Sg_0Vmk136<0SF]14Ha0SW>0Sg_0SW>0SF]0UJe0Woo0V]J
0Sg_13W>0THa0Sg_0SF]0SW>12e[0U:D0Vmk0T8@0S6<0T8@0Sg_0THa0UJe0QBU0SW>0V<H0S6<0Sg_
0THa0Re[0T8@0Sg_0SW>0THa0P000Woo0RDY0R480W>L0Re[0THa13g_0T8@0Sg_0R480T8@0SW>0S6<
00=243g_?Nl0148@0SW>0Tic0Re[0SF]0TYB0V<H14Ha0TYB0Sg_0SW>0RDY0T8@0Sg_0T8@13g_0SW>
14Ha0TYB0RU:0S6<0TYB0T8@0RU:0TYB0T8@0TYB0S6<0U[F0UJe0T8@0THa0T8@0Sg_0T8@1Sg_0SF]
0U[F0P000U:D0SW>0U:D0Sg_0SW>14YB0SW>0V<H0Sg_0T8@23g_0SW>0T8@0Sg_1Goo0@000Goo0003
Ool01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`03001oogoo009oo`9BU08e
[@8icP8aS09:DP8e[@8mk`9_N`@aS08e[@A6<@8icP8mk`8icP8e[@9F]@9oo`9[FP8mk`@icP96<@8m
k`8e[@8icP@]J`9BU09_N`92408aS092408mk`96<@9F]@8DY@8icP9S608aS08mk`96<@8]J`92408m
k`8icP96<@80009oo`8U:@8Q209cW08]J`96<@@mk`92408mk`8Q2092408icP8aS003@Q0mkcg_00A2
408icP9>L`8]J`8e[@9:DP9S60A6<@9:DP8mk`8icP8U:@92408mk`9240@mk`8icPA6<@9:DP8YBP8a
S09:DP92408YBP9:DP92409:DP8aS09JeP9F]@924096<@92408mk`9240Hmk`8e[@9JeP80009BU08i
cP9BU08mk`8icPA:DP8icP9S608mk`9240Pmk`8icP92408mk`Eoo`40005oo`000Woo0P0017oo0P00
17oo0P001Goo00<007ooOol00Woo0SW>0Tic0S6<0RDY0QBU0RU:0S6<0Re[0UJe0Woo0SF]0R480THa
0Sg_0U:D0THa0S6<0Ukg0P@Q0UJe0RU:0T8@0U:D0SW>0Re[0SW>0THa0TYB0S6<0Sg_0Re[0THa0Re[
0SF]0THa0RU:0TYB0Ukg0SW>13g_0U:D0U[F0T8@0SW>0QBU14ic0U[F0P@Q0W>L0THa0QS60UJe0SW>
0THa0Sg_0R480THa0T8@0Tic0Sg_0TYB00=>LdYBBU800S6<1Sg_0TYB14ic0SF]0SW>0Tic0THa0TYB
0THa0SF]0T8@0Sg_0QcW0THa0SW>0TYB0S6<0QS60Tic0THa0Sg_0T8@0Sg_0T8@0SW>23g_0R480U:D
0TYB0SW>148@0U:D0THa0SW>0SF]0T8@0Tic0SW>13F]0Sg_0RDY0Tic0R480THa0SW>0Tic0SF]0U:D
148@0Sg_0Tic0SF]0SW>1Goo0@000Goo000EOol00`00Oomoo`02Ool2>Lh2CW<2<H`29BT25:D2:DX2
<H`2;F/2E[D2Ool2=Jd28@P2AS42?Nl2DY@2AS42<H`2G_L21242E[D2:DX2@Q02DY@2>Lh2;F/2>Lh2
AS42BU82<H`2?Nl2;F/2AS42;F/2=Jd2AS42:DX2BU82G_L2>Lh4?Nl2DY@2F]H2@Q02>Lh25:D4CW<2
F]H21242Li`2AS426<H2E[D2>Lh2AS42?Nl28@P2AS42@Q02CW<2?Nl2BU800dicBU9:DP02<H`6?Nl2
BU84CW<2=Jd2>Lh2CW<2AS42BU82AS42=Jd2@Q02?Nl27>L2AS42>Lh2BU82<H`26<H2CW<2AS42?Nl2
@Q02?Nl2@Q02>Lh8?Nl28@P2DY@2BU82>Lh4@Q02DY@2AS42>Lh2=Jd2@Q02CW<2>Lh4=Jd2?Nl29BT2
CW<28@P2AS42>Lh2CW<2=Jd2DY@4@Q02?Nl2CW<2=Jd2>Lh5Ool10001Ool001Eoo`03001oogoo009o
o`8icP8e[@96<@9S608icP96<@8YBP@icP8<H`8]J`8mk`I6<@8aS096<@8aS09S609>L`8icP9BU09:
DP8Li`8U:@9F]@9Nm`9>L`92408icP9:DP8mk`8U:@9240@mk`9BU08aS096<@8icP92408aS08e[@9N
m`8e[@96<@8]J`8e[@8U:@9[FP8U:@8YBP9>L`8icP96<@9>L`8e[@8icP96<@9BU08Li`9BU0924003
;F]6<DHa0092408mk`92408aS0924096<@8U:@8icP8Li`8e[@8mk`8U:@9JeP8mk`8U:@9>L`96<@8i
cP8e[@96<@9:DP8mk`92408mk`8icP9240Hmk`92408mk`92409JeP8icP9:DPA6<@924096<@8icP9B
U092408icP8e[@8icP9>L`9F]@96<@8mk`8e[@96<@8icP9240@mk`9240@mk`92408mk`9W>@8e[@8m
k`Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0SF]0THa0V<H0SW>0THa0RU:13W>0PaS0Re[0Sg_
1THa0S6<0THa0S6<0V<H0Tic0SW>0U:D0TYB0QcW0RDY0UJe0Ukg0Tic0T8@0SW>0TYB0Sg_0RDY0T8@
13g_0U:D0S6<0THa0SW>0T8@0S6<0SF]0Ukg0SF]0THa0Re[0SF]0RDY0V]J0RDY0RU:0Tic0SW>0THa
0Tic0SF]0SW>0THa0U:D0QcW0U:D0T8@00<]JdHaAS400T8@0Sg_0T8@0S6<0T8@0THa0RDY0SW>0QcW
0SF]0Sg_0RDY0U[F0Sg_0RDY0Tic0THa0SW>0SF]0THa0TYB0Sg_0T8@0Sg_0SW>0T8@1Sg_0T8@0Sg_
0T8@0U[F0SW>0TYB14Ha0T8@0THa0SW>0U:D0T8@0SW>0SF]0SW>0Tic0UJe0THa0Sg_0SF]0THa0SW>
0T8@13g_0T8@13g_0T8@0Sg_0VLi0SF]0Sg_1Goo0@000Goo000EOol00`00Oomoo`02Ool2>Lh2=Jd2
<H`2F]H2E[D2DY@2Mkd2=Jd2Ool2E[D2?Nl2>Lh2AS42;F/4<H`2JeX2E[D2:DX29BT2>Lh2=Jd2?Nl2
CW<2=Jd2@Q04AS42@Q02Kg/2;F/2<H`2>Lh2?Nl2E[D2=Jd2>Lh25:D2;F/2F]H2?Nl2=Jd2HaP2<H`2
?Nl2BU86:DX29BT2Mkd2DY@2@Q02AS42@Q04>Lh4?Nl2=Jd2@Q02>Lh2?Nl00dYB?Nlmk`06?Nl2AS42
>Lh6@Q02?Nl2AS42;F/2@Q02BU82>Lh2;F/2AS42@Q02=Jd2AS44?Nl2E[D2DY@2?Nl2F]H2;F/2AS42
?Nl2CW<2<H`2>Lh2F]H2@Q02AS42@Q02?Nl2F]H4>Lh2@Q02BU82>Lh2;F/2>Lh2?Nl2DY@29BT2E[D2
@Q02DY@2;F/2BU82F]H2=Jd2<H`2@Q08?Nl2AS42?Nl2@Q05Ool10001Ool001Eoo`03001oogoo009o
o`8icP8e[@8aS09JeP9F]@9BU09g_@8e[@9oo`9F]@8mk`8icP96<@8]J`@aS09[FP9F]@8YBP8U:@8i
cP8e[@8mk`9>L`8e[@9240A6<@92409_N`8]J`8aS08icP8mk`9F]@8e[@8icP8DY@8]J`9JeP8mk`8e
[@9S608aS08mk`9:DPHYBP8U:@9g_@9BU0924096<@9240@icP@mk`8e[@92408icP8mk`03BU8mkcg_
00Hmk`96<@8icPI2408mk`96<@8]J`92409:DP8icP8]J`96<@92408e[@96<@@mk`9F]@9BU08mk`9J
eP8]J`96<@8mk`9>L`8aS08icP9JeP924096<@92408mk`9JeP@icP92409:DP8icP8]J`8icP8mk`9B
U08U:@9F]@92409BU08]J`9:DP9JeP8e[@8aS09240Pmk`96<@8mk`9240Eoo`40005oo`005Goo00<0
07ooOol00Woo0S6<0QBU0V]J0U:D0V]J0Re[0SF]0TYB0T8@0TYB10000U:D0RDY0T8@0V<H0RDY0Tic
0RDY0T8@0S6<0VLi0SW>0QS60SW>0TYB0QBU0RU:0W>L14ic0QS60RU:0SW>0U[F0THa0Ukg0T8@0RU:
0SW>0S6<0VLi0TYB0S6<14ic0Woo0Re[0RU:0Ukg0SW>0Tic0SW>0Sg_0SW>0QBU0U:D0RU:0TYB0Tic
0U:D0Re[0RDY00<]JdYBBU800SW>0Sg_0T8@0S6<0TYB0SW>0Tic0T8@0Sg_0SW>0U:D0Ukg0SF]0TYB
0SF]0THa0T8@0Sg_0U:D0S6<0T8@0Sg_0THa0RDY0VLi0T8@0U:D0Re[0Tic148@0TYB0UJe0S6<0Sg_
0T8@0SW>0Sg_0SF]0Sg_0U[F0QS60Ukg0UJe0SW>0Re[0Tic0TYB0U[F0THa0SF]0TYB0SW>148@13g_
0T8@0SW>0UJe0RU:13W>1Goo0@000Goo000EOol20003Ool2<H`25:D2JeX2DY@2JeX2;F/2=Jd2BU82
@Q02BU840002DY@29BT2@Q02HaP29BT2CW<29BT2@Q02<H`2IcT2>Lh26<H2>Lh2BU825:D2:DX2Li`4
CW<26<H2:DX2>Lh2F]H2AS42G_L2@Q02:DX2>Lh2<H`2IcT2BU82<H`4CW<2Ool2;F/2:DX2G_L2>Lh2
CW<2>Lh2?Nl2>Lh25:D2DY@2:DX2BU82CW<2DY@2;F/29BT00be[BU9:DP02>Lh2?Nl2@Q02<H`2BU82
>Lh2CW<2@Q02?Nl2>Lh2DY@2G_L2=Jd2BU82=Jd2AS42@Q02?Nl2DY@2<H`2@Q02?Nl2AS429BT2IcT2
@Q02DY@2;F/2CW<4@Q02BU82E[D2<H`2?Nl2@Q02>Lh2?Nl2=Jd2?Nl2F]H26<H2G_L2E[D2>Lh2;F/2
CW<2BU82F]H2AS42=Jd2BU82>Lh4@Q04?Nl2@Q02>Lh2E[D2:DX4>Lh4Ool20001Ool001Eoo`03001o
ogoo009oo`8icP96<@8e[@8aS08U:@9W>@92409F]@8icP8YBP@icP8aS092408mk`96<@9:DP8YBP96
<@8@Q09Nm`@icP8U:@9:DP8e[@9:DP8e[@8]J`9>L`8e[@9>L`96<@@mk`9:DP9>L`92409>L`8icPHm
k`92409:DP8Q208HaP9>L`9:DP9240@icP8mk`8]J`8aS08mk`92409F]@8icP9BU08icP9:DP9BU003
BU8aS36<0096<@8mk`92408e[@96<@A2408icP9F]@8aS09>L`9JeP92408mk`92408mk`92408icP8m
k`924096<@8e[@9F]@92408@Q09:DP8mk`8]J`@mk`92408icP8mk`9240@mk`92408icP9Nm`8mk`8a
S096<@8Q20A>L`96<@9:DP8mk`96<@8mk`92408mk`924096<@8mk`92408]J`A6<@924096<@8mk`96
<@Eoo`40005oo`005Goo00<007ooOol00Woo0SW>0THa0SF]0S6<0RDY0VLi0T8@0UJe0SW>0RU:13W>
0S6<0T8@0Sg_0THa0TYB0RU:0THa0Q240Ukg13W>0RDY0TYB0SF]0TYB0SF]0Re[0Tic0SF]0Tic0THa
13g_0TYB0Tic0T8@0Tic0SW>1Sg_0T8@0TYB0R480QS60Tic0TYB0T8@13W>0Sg_0Re[0S6<0Sg_0T8@
0UJe0SW>0U:D0SW>0TYB0U:D00=:DS6<<H`00THa0Sg_0T8@0SF]0THa148@0SW>0UJe0S6<0Tic0U[F
0T8@0Sg_0T8@0Sg_0T8@0SW>0Sg_0T8@0THa0SF]0UJe0T8@0Q240TYB0Sg_0Re[13g_0T8@0SW>0Sg_
0T8@13g_0T8@0SW>0Ukg0Sg_0S6<0THa0R4814ic0THa0TYB0Sg_0THa0Sg_0T8@0Sg_0T8@0THa0Sg_
0T8@0Re[14Ha0T8@0THa0Sg_0THa1Goo0@000Goo000EOol00`00Oomoo`02Ool2:DX2=Jd2HaP2>Lh2
AS421242?Nl2BU82CW<2?Nl20002:DX2AS42;F/2:DX4E[D2?Nl2AS42<H`2F]H2BU82DY@2E[D2?Nl2
BU82:DX2<H`2IcT29BT2E[D2AS42?Nl2G_L2;F/2BU82E[D2?Nl2@Q02;F/2CW<2=Jd2?Nl2@Q02;F/8
CW<2:DX2?Nl2>Lh4;F/2E[D2CW<2AS42@Q02>Lh2F]H2?Nl4@Q03AS48?Nl2DY@2>Lh4?Nl2@Q02BU82
:DX2DY@2>Lh4@Q02;F/2>Lh2CW<2BU82=Jd2@Q027>L2E[D2>Lh2AS42<H`2>Lh2BU82@Q02?Nl2=Jd2
@Q02=Jd4?Nl2@Q02>Lh2BU82AS42>Lh2AS42G_L2E[D2>Lh2E[D2?Nl2E[D28@P2AS44?Nl2@Q02>Lh2
BU84AS42?Nl2<H`4=Jd29BT2>Lh26<H5Ool10001Ool001Eoo`03001oogoo009oo`8YBP8e[@9S608i
cP96<@848@8mk`9:DP9>L`8mk`80008YBP96<@8]J`8YBPAF]@8mk`96<@8aS09JeP9:DP9BU09F]@8m
k`9:DP8YBP8aS09W>@8U:@9F]@96<@8mk`9Nm`8]J`9:DP9F]@8mk`92408]J`9>L`8e[@8mk`92408]
J`Q>L`8YBP8mk`8icP@]J`9F]@9>L`96<@92408icP9JeP8mk`A240=6<@Pmk`9BU08icP@mk`92409:
DP8YBP9BU08icPA2408]J`8icP9>L`9:DP8e[@92408Li`9F]@8icP96<@8aS08icP9:DP92408mk`8e
[@92408e[@@mk`92408icP9:DP96<@8icP96<@9Nm`9F]@8icP9F]@8mk`9F]@8Q2096<@@mk`92408i
cP9:DPA6<@8mk`8aS0@e[@8U:@8icP8HaPEoo`40005oo`005Goo00<007ooOol00Woo0TYB0SW>0TYB
0SF]0V<H0Ukg0SF]0THa0P000SW>0WNm0Sg_0PaS0UJe0SF]0RDY0QBU0RDY0Sg_0UJe0Tic0QcW0TYB
0Sg_0TYB0QS60THa0VLi0Sg_0T8@0S6<0SF]0T8@0THa0RU:0U:D0RDY0TYB0SF]0S6<0THa0RU:0UJe
0RU:0TYB0S6<0UJe0SW>0RU:0Ukg0Re[0UJe0SF]0RDY13W>0Tic0SW>0THa0Sg_0Tic0S6<0RDY00=N
md8@@Q000SF]0Sg_0T8@13g_0S6<1Sg_0THa0RU:0RDY0U:D0Sg_0THa0S6<0RU:0TYB0T8@0U:D0THa
0TYB0Re[1THa0Tic0Re[0THa0SF]0S6<0Ukg0SF]0T8@0Sg_0SF]0U[F0THa0U[F0S6<0QBU0Ukg0QcW
12DY0Re[0SW>0TYB0Ukg0Sg_0T8@0SW>0Tic0SW>14Ha0SW>0T8@0Sg_0T8@0SF]0T8@0SW>1Goo0@00
0Goo000EOol00`00Oomoo`02Ool2BU82>Lh2BU82=Jd2HaP2G_L2=Jd2AS420002>Lh2Mkd2?Nl236<2
E[D2=Jd29BT25:D29BT2?Nl2E[D2CW<27>L2BU82?Nl2BU826<H2AS42IcT2?Nl2@Q02<H`2=Jd2@Q02
AS42:DX2DY@29BT2BU82=Jd2<H`2AS42:DX2E[D2:DX2BU82<H`2E[D2>Lh2:DX2G_L2;F/2E[D2=Jd2
9BT4>Lh2CW<2>Lh2AS42?Nl2CW<2<H`29BT00ekg@Q124002=Jd2?Nl2@Q04?Nl2<H`6?Nl2AS42:DX2
9BT2DY@2?Nl2AS42<H`2:DX2BU82@Q02DY@2AS42BU82;F/6AS42CW<2;F/2AS42=Jd2<H`2G_L2=Jd2
@Q02?Nl2=Jd2F]H2AS42F]H2<H`25:D2G_L27>L49BT2;F/2>Lh2BU82G_L2?Nl2@Q02>Lh2CW<2>Lh4
AS42>Lh2@Q02?Nl2@Q02=Jd2@Q02>Lh5Ool10001Ool001Eoo`03001oogoo0?moo`Moo`40005oo`00
5Goo00<007ooOol0ogoo1goo0@000Goo000EOol00`00Oomoo`02Ool00`00Oomoo`0UOol00`00Oomo
o`0UOol00`00Oomoo`0UOol00`00Oomoo`0UOol00`00Oomoo`0TOol00`00Oomoo`0UOol00`00Oomo
o`0BOol10001Ool001Eoo`8000=oo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`03
001oogoo00Moo`03001oogoo00Moo`03001oogoo00Moo`80005oo`005Gooo`002`000Goo003oOolQ
Ool00?moob5oo`00ogoo8Goo003oOolQOol00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, \
0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", 
      StyleBox[
        RowBox[{" ", 
          StyleBox[" ",
            FontVariations->{"Underline"->True}]}]], 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((2 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["multiResolved=expanMatrix2D[wa,w,w,coif30];", "Input"],

Cell["\<\
recoveredGraph=
\tTable[ListDensityPlot[multiResolved[[i]],PlotRange->All,
\t\tMesh->False,PlotLabel->StringForm[\"Level `1`\",i],
\t\tDisplayFunction->Identity],{i,Length[multiResolved]}];\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
Do[Show[GraphicsArray[{{recoveredGraph[[i]],
\trecoveredGraph[[i+1]]}}]],{i,1,Length[multiResolved]-1,2}];\
\>", "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Level) show
99.000 12.813 moveto
(1) show
105.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
6F7B8895A1ACB4B9BCBCBBB9B6B4B2B2B2B3B5B6B7B8B8B7B5B2B0ADABA8A7A6A5A5A5A5
A6A6A6A6A6A5A5A4A4A4A3A3A3A4A4A4A4A4A4A4A3A3A2A2A1A1A1A0A0A0A09F9F9E9D9C
9B999795918D87817971696159534E4B4A4B4C4E51535556575757575656565556565655
555554545353535353525251504F4E4F51555B64
68737F8B97A1A9AEB0B0AEABA8A6A4A3A3A4A6A7A8A9A9A8A7A5A2A09E9C9B9A9A9A9B9B
9C9C9C9C9C9C9B9B9A9A9A9A9A9A9B9B9B9B9B9B9B9B9A9A999999989898979796969595
949392918E8B87827D767069635E5B5958595A5C5E60616262626160605F5F6061626364
65656565646362605F5D5A575452504F4F51565E
606A76828D969EA2A3A3A19E9A97959494959698999A9A9A9897959391908F8F8F8F9091
9292939392929191909090909091919292939393939292929191919090908F8F8E8E8E8E
8E8D8D8C8B8A8784807B76726D6A68666667686A6C6D6E6E6D6C6B6A6969696B6D6F7174
757777767573706D6A66625D5854504D4C4D5157
58626D78838C9397989794918D898785858688898B8C8C8C8B8A88878584848484858687
888989898989888887878787878889898A8A8A8B8B8A8A8A8A8989898888878787878787
878888888888868582807D7A7775747374757678797A7A7A7977757473727375787B7F82
8587878785817D79746E68615B55504B49484B50
515A65707A83898D8E8C8985817D7A7878797B7C7E7F80807F7E7D7C7B7A7A7A7B7C7D7E
7F8080818080807F7F7F7F7F7F8081818283838383838383838282828181818080808181
828384848586868585848381807F7F80808183848586868583817F7D7C7B7C7F82878B8F
92959594918D88827B736C645C544E4845434549
4B545E69737C82858583807B77736F6E6E6F707274757677767575747372727374757677
787979797979797878787878797A7A7B7C7D7D7D7E7E7D7D7D7D7C7C7C7B7B7B7B7B7C7D
7E7F808183848586878787888888898A8B8C8D8E8F8F8F8D8B898785848485888C909599
9D9F9F9E9A948E867E756C635A524B44403E3F44
464F59646E767D7F7F7D7975706C68676667696B6D6F707171706F6F6E6E6E6E6F707172
737374747474737373737374747576777879797A7A7A797979797878787878787878797A
7B7C7E7F81838586888A8B8D8E8F9091939494959595959392908E8C8B8B8D8F93989CA0
A3A4A4A19C968E857C73695F564D46403C3A3B3F
444D57626C747A7D7D7A76726D686563636466686A6C6E6F6F6F6E6E6E6D6D6E6E6E6F70
707071717170707070717172737374757677787878787877777776767676767677777879
7A7B7D7F80828587898C8E909294959697989898989897969594939291929395999CA0A2
A4A4A29E9891887F756B61574E47403B3736383D
444D58626C757A7D7D7A76726D686563636466696B6D6F70717171707070707070707070
706F6F6F6F6F6F707070717273747576777778787878787777767676767676777778797A
7B7C7E7F818385888A8D8F92949697989898989898979796969696969697989A9C9EA0A1
A09F9B968F867D73695F554D453E39353333363C
454F5A656F777D7F7F7D79746F6B686666676A6C6F717374757676767575757474737372
7170707070707071717273747576777879797A7A7A7A797978787777777878797A7A7B7C
7D7E7F81828486888B8D9092959697989797969595949494959697989A9B9C9D9E9E9D9C
9995908980776D63595047403935312F2F31353C
48525E69737B818383817D7974706D6B6B6D6F717477797A7B7C7C7C7C7C7B7A79787775
747372727272727374757678797A7B7C7C7D7D7D7D7C7C7B7B7A7A7A7A7B7B7C7D7E7F80
80818283848587898B8D90929495969695949291908F90919295979A9C9D9E9E9D9B9894
8F8881786F655B51483F38322D2A29292B2F363E
4B56626E788086898987837F7A767371727375787B7D808183838484848382817F7E7C7A
787675757575767778797B7C7D7E7F808081818180807F7F7E7D7D7D7D7E7F8081828383
848585858687888A8B8D8F919293939391908E8C8B8A8B8C8F93969A9C9E9E9D9A96908A
827A70665C52473E352E282421202124282E3640
4E5B67737D868C8F8F8D8A85817D7A78787A7C7F828487898A8B8B8B8B8A89878583817F
7C7A797878797A7B7C7E7F81828383848585858584848382818181818182838485868787
888888888889898A8B8D8E8F9091918F8E8B8987868586898C9095989B9D9D9A9690887F
756A5F54493E352C241E191716171A1F252D3742
525F6C78838C92959694908C8883817F7F818386888B8D8F9091919190908E8D8B888683
817F7D7D7D7D7E80818284858687888889898988888786868584848485868788898A8B8B
8B8B8B8B8B8A8B8B8C8C8D8E8E8E8E8C8A888583828283868A8E9397999A999690877E73
675B4F43372D241B15100D0C0D10151B232D3845
5563717D8992989C9C9A97938E8A87858687898C8E91939495959595949392908E8C8987
8583828181828384858788898A8B8B8B8C8C8B8B8A8A89888887878888898A8B8C8D8E8E
8E8E8E8D8D8C8C8C8C8C8C8C8C8C8B898886848281818285888D91949696948F887E7366
5A4D4034291F160F09060404070B1119222D3A47
576674828D979EA1A2A09D98948F8C8B8A8C8E909295969798979796959492918F8D8C8A
8987868686878788898A8B8C8D8D8D8D8D8D8D8D8C8C8B8A8A8A8A8A8B8B8C8D8E8F8F90
9090908F8F8E8D8D8C8C8B8B8A8A89888785848382838486898C8F9192908D877E73675B
4D4034281E150D070300000104091018222E3B48
59687785919BA3A6A7A5A29D9894908E8E8F919395979898989796949392908F8E8D8D8C
8B8B8B8B8B8B8C8C8D8D8E8E8E8E8E8E8E8E8D8D8D8C8C8C8C8B8C8C8C8D8E8E8F909091
91919190908F8F8E8D8C8B8A89898887878787878787888A8B8D8E8D8C89847C73685C4F
43362A20160F080401000002050B1119232F3B4A
5A697987949FA7AAABA9A6A19C9793919091929496979897969593918F8E8D8C8C8C8D8D
8E8E8F8F8F8F8F8F8F8F8F8F8F8F8E8E8E8D8D8D8D8C8C8C8C8D8D8D8E8E8E8F8F909091
919191919191908F8E8C8B8A89888888898A8B8C8D8E8E8F8E8E8C8985807971675C5145
392E231A120C070402020305090E141C25303C4A
5A6A7A8997A2AAAEAFADA9A39E999492919293949596969694918F8C8A888888898A8C8E
9091929393939392929190908F8F8E8E8D8D8C8C8C8C8C8D8D8D8E8E8E8F8F8F8F8F9090
91919292929291908F8D8B8A898888898B8D909294959594918E8A847E776E655B50463B
31271E17110C09070707090B0E13181F27313D4B
5A6A7B8A98A4ACB0B1AFABA59F9A95929192929495959593908D8A878483828385888B8E
9294969798979695949391908F8E8E8D8C8C8C8C8C8C8C8D8D8E8E8F8F8F8F8F8F8F8F90
9091929393939392908E8C8A8989898B8E9195989A9B9B98948E877F766C62584E453B32
29211B15110E0C0C0C0E0F1214181D2229323E4B
5B6B7B8B99A5AEB2B3B0ACA6A09A959291919192939392908D8985827F7D7D7F82868A8F
93979A9B9C9B9A98969492908F8E8D8C8C8B8B8B8B8C8C8D8E8F8F8F908F8F8F8E8E8F8F
9091929394949493918F8D8B8A8A8B8D91959A9DA0A1A09C958D83786D62564C4239312A
231D181412101011121416181B1E21262C343E4C
5B6B7B8B9AA6AEB2B3B0ACA59F9893908F8E8F9090908F8D8985817D7A79797B7F848A90
959A9D9F9F9E9D9A989593918F8E8D8C8C8B8B8B8C8C8D8E8F8F909090908F8F8E8E8E8F
909192939495959492908E8D8B8B8D9094999EA2A4A5A39D958A7E7164574B40372F2923
1E1A171514131416181A1C1E202325292E363F4C
5B6B7B8B9AA5AEB2B2AFAAA39C96908D8B8B8C8D8D8D8C8985817D79767576797D838A91
979DA0A2A3A19F9C999693918F8E8D8D8C8C8C8C8D8D8E8F8F9091919190908F8F8F8F8F
90919294959696959492908E8D8D8F92979CA0A4A6A6A39C928678695A4C40352D26211D
1A1817161617181A1C1F21232426292C3137414D
5C6B7B8B99A4ACB0B0ACA7A099928C898787888989898886827E7A76747374777D848B93
9A9FA3A5A5A4A19E9A979491908F8E8E8E8E8E8E8E8F8F90919192929291919090909090
91929394959696969593929190909295999DA1A4A6A4A0988C7F6F605042352B241F1C19
1818181818191A1C1F21232526282A2E3239424E
5D6C7B8A97A2AAADACA8A29B938C87838282838485868583807C7875737274787E858D95
9CA2A6A8A8A6A39F9B979492919090909090919191919192929293939393929292919192
929393949596969696959494939495979B9EA1A2A2A09A918476665646382C231D191817
1718191A1A1B1C1D1F21232426282B2E333A434F
5D6C7B8996A0A6A9A7A39D958E87817D7C7C7E7F818282817E7B78757474767A80878F97
9FA4A8AAAAA7A4A09C989593929292929393949494949494949494949494949494949493
9494949595969696979797979797989A9C9D9E9E9D9891877A6B5C4C3C2F241C18151516
17191B1C1C1C1D1D1E1F212224272A2E343B4450
5E6C7A87939CA2A4A29E978F88807B777677797B7D7F7F7F7D7B78767576787D838A929A
A1A7AAACABA9A5A19D999694939394959697989898979796969595959595969696969696
95959595959596979798999A9A9B9B9C9C9C9B99958F877C6F60514233271D1714131416
191B1D1E1E1E1D1C1C1D1E1F2225292E343B4551
5E6B798590989E9F9D989189817A7572717274777A7C7D7E7D7B797878797C80878E969D
A4A9ACADACAAA6A19D99979595959698999B9B9C9B9A9A99989796969797979898999898
9797969595959697999A9C9D9E9E9E9E9C9A97938D857C70635546382B20181311121417
1A1E2021201F1D1B1A1A1A1C1F22272D343C4651
5E6A77828D94999997928B837C75706D6C6E7074777A7C7D7D7C7B7B7B7D80848B9299A0
A6ABAEAFADAAA6A29E9A97969697999A9C9E9F9F9F9D9C9B999898989899999A9B9B9B9A
99989796959596979A9C9EA0A1A2A19F9C98928B847A706457493C2F231A141010111519
1D21232322201D1B191717191C20252C333C4651
5D69747F89909394918C867E77716C69696B6E72767A7C7E7F7F7F7F808185898F969DA3
A9ADB0B0AEABA7A29E9A989797989A9D9FA1A2A2A1A09F9D9B9A9999999A9B9C9D9D9D9C
9B999896969596989B9EA1A3A4A5A3A09B948D847A6F63574B3E32271D16110F1012161B
1F23252524211D1A17151516191E242B323B4651
5B66717C848B8E8F8C88827B746E6A68696B6E72777B7E818283838485878A8F949AA1A7
ACAFB1B1AFABA7A39E9B9998989A9C9FA1A3A4A5A4A3A19F9D9C9B9B9B9C9D9E9F9F9F9E
9D9B9997969697999CA0A3A6A7A7A5A09991867B7063574B3F342A211913100F1114181D
2125272725211E1A17141315181C2229313A4550
58636E7780868A8A88857F79736E6B6A6B6D71757A7F82858788898A8B8D90959A9FA5AA
AEB1B3B2B0ACA8A39F9C9999999B9DA0A3A5A6A6A6A4A3A19F9D9C9C9C9D9E9FA0A1A1A0
9E9C9A989797989A9DA1A5A8A9A9A59F978C807365584B40352B231C1613111113161A1F
2326282725221E1A17141314171C22293039434D
555F69737B81858785827E7974706E6E6F72767B7F84888B8D8E8F919294979B9FA4A9AE
B1B4B4B3B1ADA9A4A09C9A999A9C9EA1A3A6A7A7A7A6A4A2A19F9E9E9E9FA0A1A2A2A2A1
9F9D9B999898999B9FA3A6A9AAA9A59E9387796A5B4D40352C241E191513131416191C20
2326272724211E1A17151515181C22282F37414B
515B656E777D828483827E7B7774737375787D81868B8F92949697989A9B9EA1A5A9AEB1
B4B6B6B5B2AEAAA5A19D9B9A9B9D9FA1A4A6A7A8A8A7A5A4A2A1A0A0A0A0A1A2A3A3A3A2
A19F9D9B9A999A9DA0A4A7AAAAA9A49B8F8172615243362C241E1A17161516181A1C1F21
2425262523211E1B191717171A1D22272E353E47
4D57616A737A7F828282807E7B7A797A7D8084898E9296999C9D9FA0A1A3A5A8ABAFB2B5
B7B8B8B6B3AFABA6A29F9D9C9C9D9FA2A4A6A7A8A8A7A6A5A4A3A2A2A2A2A3A3A4A4A4A3
A2A09E9D9B9B9C9EA1A5A8AAAAA7A1978A7B6A5948392D231D19171617181A1C1E1F2122
2324242322201E1C1A19191A1C1E22272D333B44
4A535D676F777D80828382818080808285888D92969B9EA1A4A5A6A8A9AAACAEB1B4B6B8
BABABAB8B4B1ACA8A4A09E9D9D9EA0A2A4A6A7A8A8A8A7A6A5A4A4A3A3A4A4A4A5A5A5A4
A3A1A09E9D9D9EA0A3A5A8A9A8A49D92847462503F30241C17151516191C1E2022222323
23222221201F1E1D1C1B1B1C1E2023272B313841
47505A646D757B8083858585868687898D91959A9FA3A6A9ABADAEAFB0B1B2B4B6B8BABC
BCBCBBB9B6B2AEAAA6A3A09F9F9FA1A2A4A5A7A7A8A8A7A7A7A6A6A5A5A5A5A5A5A5A5A4
A4A3A2A0A09FA0A1A3A5A7A7A5A1988D7E6C5A4837281D15121214171B1F232526252523
2221201F1E1E1D1D1D1D1E1E1F2123262A30363E
454E58626C747C818587898A8B8C8E9194999DA2A6AAADB0B2B4B5B5B6B7B8B9BBBCBEBE
BFBEBDBBB8B4B0ACA8A5A3A1A1A1A2A3A4A5A6A7A7A8A8A8A8A8A7A7A7A6A6A6A6A5A5A5
A4A4A3A3A2A2A2A3A4A5A5A4A19B928676655240302117110E1013181D22262829282624
211F1E1D1C1C1D1D1E1F1F2021222426292E343C
444D58626C757D83878B8D8F909294979B9FA4A8ACB0B3B6B8B9BABBBBBCBDBEBFC0C0C1
C1C0BFBDBAB6B2AFABA8A6A4A3A3A3A3A4A4A5A6A7A8A8A9A9A9A9A9A8A8A7A6A6A5A5A5
A5A5A5A5A5A5A5A5A5A4A3A09B948B7D6E5D4B39291C120D0C0F13191F25292B2B292724
211E1C1B1B1B1C1D1F20212122232426292D333B
444E59646E7880868B8E91939597999CA0A4A8ADB1B4B8BABCBDBEBEBFBFC0C1C1C2C3C3
C3C2C1BEBCB9B5B2AFACA9A7A6A5A4A4A4A4A5A5A6A7A8A9AAABABAAAAA8A7A6A5A5A5A5
A6A6A7A8A8A8A7A7A5A39F9B958C8274655443332519100C0C0F141A20262A2C2C2A2724
211E1B1A1A1B1C1D1F20212222232426292D333B
45505B67727C848B8F939597999A9D9FA3A7ABB0B4B7BABCBEBFC0C0C1C1C2C2C3C4C4C4
C4C3C2C0BEBBB8B5B2B0ADABA9A7A6A5A4A4A4A5A6A7A8AAABACACACABA9A8A6A5A4A4A5
A6A8A9AAABABAAA8A5A19B958D83776A5B4C3D2E2117100C0C0F141A20262A2C2C2A2724
211E1B1A1A1B1C1D1F20212222232426292D343C
48535F6B768189909497999B9C9D9FA2A5A9ADB1B5B8BBBEBFC0C1C1C2C2C3C3C4C5C5C5
C5C5C4C2C0BEBCB9B6B4B1AEACAAA8A6A4A4A3A4A5A6A8AAACADADADABAAA8A6A4A3A3A4
A6A9ABADAEAEADA9A59E968E84796D605244362A1F16100E0E11151B2025292B2B292724
211E1C1B1A1B1C1D1E1F202121222426292E353E
4B5763707C868F959A9C9E9F9FA0A1A3A6AAAEB2B5B9BCBEBFC0C1C1C2C2C3C3C4C5C6C6
C6C6C5C4C3C1BFBDBAB8B5B2AFACAAA7A5A4A3A3A4A6A8AAACAEAEAEACAAA8A5A3A2A2A4
A7AAADB0B1B1AFAAA49B91867B6E6255483C31261E1712101113171B2024272929282624
211F1D1C1B1B1C1C1D1E1F20212224262A303740
4E5B6875818C959B9FA1A2A2A2A2A2A4A7AAAEB2B5B9BBBDBFC0C0C1C1C2C2C3C4C5C6C6
C7C7C7C6C5C4C2C0BEBCB9B6B3AFACA8A6A4A2A3A4A5A8AAACAEAFAEACAAA7A5A2A1A2A4
A7ABAFB2B3B3B0ABA2988C7F7164564A3F352C241D1815141416181C1F22252627262524
22201E1D1C1C1C1C1D1D1E1F202123262B313943
525F6D7B87929BA1A5A6A6A5A4A4A4A5A7AAAEB1B5B8BBBDBEBFBFC0C0C1C2C3C4C5C6C7
C7C8C8C7C7C6C5C4C2C0BDBAB6B2AEAAA6A4A2A2A3A5A7AAACAEAFAEACAAA7A4A2A0A1A3
A7ABB0B3B5B5B1AAA094867768594C40362E27221D1A191818191A1C1E21222424252423
2221201E1D1D1C1C1C1C1D1E1F2123272C323B46
556371808D98A1A7AAABAAA9A7A5A5A5A7AAADB1B4B8BABCBDBEBFBFC0C0C1C2C3C4C6C7
C7C8C9C9C9C8C8C7C5C3C1BDB9B4B0ABA7A4A2A1A2A4A6A9ACAEAEAEACA9A6A3A1A0A0A3
A7ACB0B4B6B6B1A99E90806F5F4F42372E2824201E1D1C1C1B1B1C1D1E1F202122232323
232221201F1D1D1C1C1C1C1D1E2023272D343D48
58667584919DA6ABAEAFAEACA9A7A6A6A8AAADB1B4B7BABCBDBEBEBFBFC0C1C2C3C4C6C7
C8C8C9CACACACAC9C8C6C3C0BBB6B1ACA8A4A2A1A2A3A6A8ABADAEADABA9A6A3A09FA0A3
A7ACB1B4B6B5B0A79B8B7A685747392F2823201F1F1F1F1F1F1E1D1D1D1E1E1F20222223
23232221201E1D1C1B1B1B1C1D2023282D353F4B
5A69788795A1AAAFB2B2B1AEABA9A7A7A9ABAEB1B5B8BABCBDBEBEBFBFC0C1C2C3C4C6C7
C8C9C9CACBCBCBCBCAC8C6C2BDB8B3AEA9A5A2A1A1A2A5A7AAACADACAAA8A5A2A09FA0A3
A7ACB0B4B5B4AEA49786746250403229221F1E1E1F20212121201F1E1D1D1D1E1F212223
24242322211F1D1C1B1B1B1C1D2023282E36404C
5B6B7A8997A3ACB2B5B5B3B1AEABA9A9AAACAFB2B6B9BBBDBEBFBFC0C0C1C2C3C4C5C6C7
C8C8C9CACBCCCCCCCBCAC7C4BFBAB4AFAAA5A2A1A1A2A4A6A8AAABABA9A7A5A2A09FA0A3
A7ABAFB2B3B1ABA192816F5C4A3A2D241E1C1C1D1F2123232322201F1D1D1D1D1F202223
24242423211F1E1C1B1B1B1B1D1F23282E36414D
5C6C7B8B99A5AEB4B7B7B5B3B0ADABAAABAEB1B4B7BABCBEBFC0C0C1C2C2C3C4C5C6C6C7
C8C8C9CACBCCCCCCCCCBC8C5C0BBB5B0ABA6A3A1A1A1A3A5A7A8A9A9A8A6A4A2A0A0A1A3
A7AAAEB0B0AEA79C8D7C6A57453529201B1A1A1C1F2224242423211F1E1D1D1D1F202223
2425242322201E1D1B1B1B1B1D1F23282E37414E
5D6C7C8C9AA7B0B6B9B9B7B5B1AEADACADAFB2B5B8BBBDBFC1C1C2C3C3C4C5C5C6C6C7C7
C7C8C8C9CACBCCCCCCCBC9C5C1BCB7B1ACA7A4A2A1A1A2A3A5A6A7A7A6A5A3A2A1A1A1A3
A6A9ACADADA9A297887765524132261E1918191C1F222425252422201F1D1D1E1F212224
2525252422201E1D1C1B1B1B1D1F23282E37414E
5D6D7D8C9BA7B1B7BABAB9B6B3B0AEAEAFB1B3B6B9BCBFC1C2C3C4C4C5C6C6C7C7C7C7C7
C7C8C8C9CACBCBCCCCCBC9C6C2BDB8B2ADA9A5A3A1A1A1A2A3A4A4A4A4A4A3A2A1A1A2A4
A6A8AAAAA8A49C918272604E3E2F241C1817191C1F222526252423211F1E1E1E1F212324
2526252423211F1D1C1B1B1C1D1F23282E37414E
5D6D7D8D9CA8B2B8BBBBBAB7B4B1AFAFB0B2B5B8BBBDC0C2C3C4C5C6C7C7C8C8C8C8C8C8
C7C7C7C8C9CACBCBCBCBC9C6C2BEB9B4AFAAA6A4A2A0A0A0A1A1A2A2A2A2A2A2A2A2A3A4
A6A7A7A6A49F968B7C6C5B4A3B2D221B1817191C1F23252626252321201F1E1F20222325
2626262523211F1D1C1B1B1C1D2023282E37424F
5E6D7E8E9CA9B3B9BCBCBBB8B5B2B0B0B1B3B6B9BCBEC1C3C5C6C7C7C8C9C9C9C9C9C8C8
C7C7C7C7C8C9CACBCBCAC9C6C3BEBAB5B0ACA8A5A2A19F9F9F9F9FA0A0A1A1A2A2A3A4A4
A5A5A4A29F99908476675747382B211B1818191C2023262727262422211F1F2021222426
2627262523211F1D1C1B1B1C1D1F23282F37424F
5E6E7E8E9DAAB3BABDBDBCB9B6B3B1B1B2B4B6B9BCBFC2C4C6C7C8C9C9CACACACAC9C9C8
C7C7C7C7C8C8C9CACAC9C8C6C3BFBBB7B2AEAAA7A3A19F9E9D9C9C9D9E9FA0A2A3A4A4A5
A4A3A19E9993897E70625243352A201B18181A1D20242628272625232120202021232526
2727272624221F1E1C1B1B1B1D1F23282F37424F
5F6F80909EABB5BBBEBEBCBAB6B4B1B1B2B4B7BABDC0C2C5C6C7C8C9CACBCBCBCBCAC9C8
C7C7C6C7C7C8C9C9C9C9C8C6C3C0BCB8B4B0ACA8A5A29F9C9B9A9A9B9C9EA0A1A3A4A5A5
A4A19E9A948D83776A5C4E403328201B19191B1E22252829292826242221212122242527
2828272624221F1D1C1B1B1B1D1F23282F384350
60708191A0ADB6BCBFBFBDBAB7B4B2B1B2B4B7BABDC0C3C5C7C8C9CACBCBCCCBCBCAC9C9
C8C7C6C6C7C7C8C8C9C8C7C6C4C1BEBAB7B3AFAAA6A29F9C999897989A9C9FA1A3A4A5A4
A29F9B968F877D716457493C30271F1B191A1C1F2327292A2A2927252322212223242627
2828282724221F1D1C1B1A1B1C1F23282F384451
62728393A2AEB8BEC0C0BEBBB7B4B2B1B2B4B7BABDC0C3C5C7C8C9CACBCCCCCCCBCBCAC9
C8C7C7C7C7C7C8C8C8C8C7C6C4C2BFBCB9B5B1ADA8A39F9B98969596989B9EA0A3A4A5A4
A19D98918A81766B5E5245392E251F1B1A1B1D2125282B2C2C2B29262423222223252628
2929282725221F1D1B1A1A1A1C1F232930394452
63748495A4B0BAC0C2C2BFBCB8B4B2B1B1B3B6BABDC0C3C5C7C8C9CACBCCCCCCCBCBCAC9
C8C7C7C7C7C7C7C7C7C7C6C5C4C2C0BEBBB8B4AFAAA49F9B9794939496999DA0A3A4A5A3
A09B948D847B7065594D41362C241E1B1A1C1F23272A2D2E2E2C2A282524222324252728
292A292725221F1D1B1A191A1C1F2329303A4553
64758696A5B2BCC1C3C3C0BCB8B4B1B0B1B3B6B9BDC0C3C5C7C8C9CACBCBCCCCCBCBCAC9
C9C8C7C7C7C7C7C7C7C6C6C5C4C3C1C0BDBAB6B1ACA6A09B9693929295989C9FA2A4A4A2
9E9891897F756A5F53483D332A231E1B1B1D2024282C2E2F2F2E2B292624232324262729
2A2A292825221F1D1B19191A1C1F2429313B4655
66768898A7B4BDC3C5C4C1BDB8B4B1B0B1B3B6B9BDC0C3C6C7C9C9CACBCBCCCCCBCBCACA
C9C8C8C7C7C7C7C6C6C6C5C5C4C4C3C1BFBCB8B3AEA7A19B9692919193979B9FA2A4A3A1
9C968D847A7065594E44393028221D1C1C1E2125292D3031302F2C2A2725242425262829
2A2A2A2825221F1D1A19191A1C1F242A323B4756
6778899AA9B5BFC4C6C5C1BDB9B4B1B0B1B3B6B9BDC0C3C6C8C9CACACBCBCBCBCBCBCBCA
C9C9C8C8C7C7C6C6C6C5C5C5C4C4C3C3C1BEBBB6AFA9A29C9692909093969A9EA1A3A29F
9A938A80756A5F54493F362E26211D1C1D1F22262A2E3031312F2D2A282624242527282A
2A2B2A2825221F1D1A19191A1C1F242A323C4857
68798A9BAAB6C0C5C7C5C2BEB9B4B1B0B1B3B6BABDC1C4C6C8C9CACACBCBCBCBCBCBCBCA
CAC9C8C8C7C7C6C6C5C5C4C4C5C4C4C4C3C0BDB8B1AAA39C9692909092969A9DA0A2A19E
9890867C71665A4F453C332C25201D1C1D1F23272B2E313231302D2B282625252627282A
2B2B2A2826231F1D1B19191A1C20252B333D4958
697A8B9CABB7C1C6C7C6C3BEB9B5B1B0B1B3B6BABEC1C4C7C8C9CACACBCBCBCBCBCBCBCA
CAC9C9C8C7C7C6C5C5C4C4C4C4C5C5C5C4C2BEB9B3ACA59E979390909295999DA0A1A09C
958D83786D61564B4139312A24201D1D1E2023272B2E3031312F2D2B282625252627292A
2B2B2A292623201D1B1A1A1A1D20252C343E4A59
6A7B8C9CABB8C1C6C8C6C3BEB9B5B2B1B1B4B7BBBEC2C5C7C9C9CACACACBCBCBCBCBCBCB
CACAC9C8C8C7C6C5C4C4C4C4C4C5C5C5C5C3C0BBB5AEA69F999491919295999C9F9F9E99
938A7F74685D52473E362F28231F1D1D1E2023262A2D2F30302F2D2A282625252628292A
2B2B2B292623201E1C1B1A1B1E21262D353F4B59
6A7B8C9DACB8C2C7C8C7C3BFBAB5B2B1B2B4B7BBBFC3C6C8C9CACACACACACACACBCBCBCB
CACAC9C9C8C7C6C5C4C3C3C4C4C5C6C6C6C4C1BCB6AFA8A19A9592929396999C9E9E9C97
90867C7065594E443B342D27221F1D1D1E202226292C2E2F2E2D2C2A282625252628292A
2B2C2B292724211E1C1B1B1C1E22272D353F4C5A
6B7C8D9DACB9C2C7C8C7C3BFBAB5B2B1B2B5B8BCC0C3C6C8CACACACACACACACACACACBCB
CACAC9C9C8C7C6C5C4C3C3C3C4C5C6C6C6C5C2BDB8B1AAA39C9794939496999B9C9C9A94
8D83786D61554B4139312B26221F1D1D1E1F2225282A2C2D2D2C2B29272625252628292B
2B2C2B292724211F1D1C1C1D1F23282E36404C5A
6B7C8D9EADB9C2C7C9C7C4BFBAB6B3B2B3B5B9BCC0C4C7C9CACACACACACACACACACACACA
CACACAC9C8C7C6C5C4C3C3C3C4C5C6C6C6C5C3BEB9B2ACA59F9A96959697999B9B9A9792
8A8075695D52483E362F2A25211F1D1D1E1F212426292A2B2B2A2928272525252728292B
2C2C2B2A272522201E1D1D1E2024292F37414D5B
6B7C8D9EADB9C2C8C9C8C4BFBBB6B3B2B3B6B9BDC1C4C7C9CACBCACACACAC9C9CACACACA
CACACAC9C8C7C6C5C4C3C3C3C4C5C6C7C6C5C3BFBAB4ADA7A19C99979798999A9A99958F
877D71665A4F453C342E2924211F1D1D1E1F21232527292A2A292827262525252728292B
2C2C2B2A282523211F1E1E1F21252A3037414D5B
6C7D8E9EADBAC3C8C9C8C4C0BBB7B4B3B4B6BABEC1C5C8CACBCBCBCACAC9C9C9C9CACACA
CACAC9C9C8C7C6C5C4C3C3C3C4C5C6C6C6C5C3C0BBB5AFA9A39F9B9999999A9A9997938C
84796E62574C4239322C2723211F1E1D1E1F202224262728282827262525252527282A2B
2C2C2B2A28252321201F1F2022262A3038424E5C
6C7D8E9FAEBAC3C8CAC8C5C0BBB7B4B3B4B7BABEC2C5C8CACBCBCBCACAC9C9C9C9C9CACA
CACAC9C9C8C7C6C5C4C4C3C4C4C5C6C6C6C5C3C0BCB7B1ABA6A19E9C9B9B9B9A9996918A
81766B5F53483F36302A2623201F1E1E1E1F202223252627272726262525252627282A2B
2C2C2B2A282624222020202123262B3139424E5C
6D7D8F9FAEBBC4C9CAC9C5C1BCB8B5B4B5B7BBBEC2C6C8CACBCBCBCACAC9C9C9C9C9C9C9
C9C9C9C8C8C7C6C5C4C4C4C4C5C5C6C6C6C5C3C0BCB8B3ADA8A4A19E9D9C9B9A98948F87
7E73675B50453B342D282522201F1E1E1F1F202223242526262626262525252627292A2B
2C2C2B2A282624222120202124272C3139434E5D
6D7E8FA0AFBBC4C9CBC9C6C1BCB8B5B4B5B8BBBFC2C6C9CACBCBCBCACACAC9C9C9C9C9C9
C9C9C8C8C7C7C6C5C5C4C4C4C5C5C6C6C6C5C3C0BDB9B4B0ABA7A3A19F9E9C9A97938D85
7B7064584C4238312B262321201F1F1F1F20212223242526262626262626262728292A2B
2C2C2B2A282624222121212224272C3239434F5D
6D7E8FA0AFBCC5CACCCAC7C2BDB9B6B5B5B8BBBFC3C6C9CBCBCBCBCBCACAC9C9C9C9C9C9
C9C8C8C7C7C6C6C5C5C5C5C5C5C5C5C5C5C4C3C0BDBAB6B1ADA9A6A4A2A09E9B97928B83
786D6154493E352E282522212020202021212222232425262626262626262727292A2B2C
2C2C2B2A282624222121212224272C3239434F5D
6E7F90A1B0BCC6CBCCCBC7C3BEB9B6B5B6B8BBBFC3C6C9CBCBCCCBCBCBCACAC9C9C9C9C8
C8C8C7C7C6C6C6C6C5C5C5C5C5C5C5C5C5C4C2C0BEBAB7B3AFACA9A6A4A19F9C97928A81
766A5E51453B322B262321202020212122222323242525262627272727272828292A2B2C
2C2C2B2A282624222121212224272C323A434F5D
6E7F90A1B0BDC6CBCDCBC8C3BEBAB6B5B6B8BCBFC3C6C9CBCCCCCCCBCBCBCACAC9C9C8C8
C7C7C7C6C6C6C6C6C6C6C6C6C6C6C5C5C4C3C2C0BEBBB8B5B2AEABA9A6A3A09C98918980
74685B4E42382F282421201F20212222232324242425262626272727282828292A2B2C2C
2D2C2B2A282624222121212224272C323A434F5E
6E7F91A2B1BEC7CCCDCCC8C4BFBAB7B6B7B9BCBFC3C6C9CBCCCCCCCCCBCBCACAC9C9C8C8
C7C6C6C6C6C6C6C6C6C6C6C6C6C6C5C5C4C3C1C0BEBCB9B6B3B0AEABA8A5A29D9891897F
7366594C3F352C25211F1F1F202123242425252525252626272728282829292A2B2C2C2D
2D2C2B2A282624222120212224272C323A434F5E
6E7F91A2B1BEC7CCCECCC9C4BFBBB7B6B7B9BCC0C3C7C9CBCCCCCCCCCCCBCBCAC9C9C8C7
C7C6C6C5C5C5C6C6C6C7C7C7C6C6C5C4C3C2C1C0BEBCBAB8B5B2B0ADAAA7A39F9992897E
726457493D3229231F1E1E1F2022242526262626262626262727282829292A2A2B2C2C2D
2D2C2B2A282523222120212224272C323A43505E
6E8091A2B1BEC8CDCECDC9C5BFBBB8B6B7B9BDC0C4C7CACBCCCDCDCCCCCBCBCACAC9C8C7
C6C6C5C5C5C5C6C6C7C7C7C7C6C6C5C4C3C2C1C0BEBDBBB9B7B4B2AFACA9A5A09A93897E
716355483B3027211E1C1D1E2123252627272726262626262728282929292A2B2B2C2D2D
2D2C2B2A282523222120202224272C323A43505E
6E8091A2B2BEC8CDCECDC9C5C0BBB8B7B8BABDC0C4C7CACCCDCDCDCCCCCCCBCAC9C9C8C7
C6C6C5C5C5C5C6C6C7C7C7C7C6C6C5C4C3C2C1C0BFBDBCBAB8B6B3B1AEAAA6A29B948A7E
71635446392E251F1C1B1C1E2124262728282827272626262727282829292A2A2B2C2C2D
2D2C2B2A282523222120202224272C323A43505E
6E8091A2B2BEC8CDCECDCAC5C0BBB8B7B8BABDC1C5C8CBCCCDCDCDCDCCCCCBCAC9C9C8C7
C6C6C5C5C5C5C6C6C7C7C7C7C6C5C5C4C3C2C1C0BFBEBDBBB9B7B4B2AFACA8A39D958B7F
72635446382D241E1B1A1C1E212427282929282827262626262727282829292A2B2C2C2D
2D2C2B2A282523222120202124272C323A43505E
6E8091A2B2BEC8CDCECDCAC5C0BBB8B7B8BBBEC2C5C9CBCDCECECDCDCCCBCBCAC9C9C8C7
C7C6C5C5C5C5C6C6C6C7C7C6C6C5C4C4C3C2C1C0C0BFBDBCBAB8B6B3B1AEAAA59F978D81
73645445382C231D1A1A1B1E222528292A2929282726262626262727272829292A2B2C2C
2D2C2B2A282523222120202124272C323A43505E
6E8091A2B1BEC8CDCECDCAC5C0BCB9B8B9BBBEC2C6C9CCCECECECECDCCCBCBCAC9C9C8C7
C7C6C6C6C6C6C6C6C6C6C6C6C6C5C4C4C3C2C2C1C0BFBEBCBAB8B6B4B2AFACA7A1998F83
74655546372B221C1A1A1B1E2225282A2A2A29282726252525262626272728292A2B2C2C
2C2C2B2A282623222120202124272C323A43505E
6E8091A2B1BEC7CDCECDCAC5C0BCB9B8B9BCBFC3C7CACDCECFCFCECDCCCBCACAC9C9C8C8
C7C7C6C6C6C6C6C6C6C6C6C6C5C5C4C4C3C3C2C1C1C0BEBDBBB9B7B5B3B1ADA9A39C9285
76675646382B221C19191B1F2226292B2B2B29282726252525252626262728292A2B2B2C
2C2C2B2A282623222120202123272C323A44505E
6E8091A2B1BEC7CDCECDCAC5C0BCB9B8B9BCC0C3C7CBCDCFCFCFCECDCCCBCACAC9C9C8C8
C8C7C7C7C6C6C6C6C6C6C6C5C5C5C4C4C4C3C3C2C1C0BFBDBBB9B7B6B4B2AFABA69E9488
79695848392C221C19191C1F23272A2B2C2B2A282726252424252526262728292A2B2C2C
2D2C2C2A282624222120202123272C323A44505E
6F8091A2B1BEC8CDCECDCAC5C0BCB9B8BABCC0C4C8CBCED0D0CFCFCDCCCBCACAC9C9C9C8
C8C8C7C7C7C6C6C6C6C5C5C5C5C5C4C4C4C4C3C3C2C0BFBDBBB9B8B6B5B3B1AEA8A1978B
7C6B5A493A2D231C1A1A1C1F23272A2C2C2B2A282725242424252526272728292A2B2C2D
2D2D2C2A282624222120202123272C323A44505E
6F8091A2B2BEC8CDCFCDCAC5C1BCBAB9BABDC1C5C9CCCFD0D0D0CFCECCCBCACAC9C9C9C9
C8C8C8C7C7C6C6C6C5C5C5C5C5C4C4C4C4C4C4C3C2C1BFBDBBB9B8B7B6B5B3B0ABA49B8E
7F6E5D4B3B2E231D1A1A1C2024282B2C2C2B2928262524242425262728292A2B2C2D2D2E
2D2D2C2A282624222120202124272C323A44505E
6F8091A2B2BFC8CDCFCECAC6C1BDBAB9BBBDC1C5C9CDCFD1D1D0CFCECDCBCACAC9C9C9C9
C9C9C8C8C7C7C6C5C5C5C4C4C4C4C5C5C5C5C4C4C2C1BFBDBBB9B8B7B7B6B5B2AEA89E92
82715F4E3E2F251E1B1B1D2124282B2C2C2B292726242323242627292A2B2C2D2E2F2F2F
2E2E2C2A282623222120202224272C323A44505E
6F8092A3B2BFC9CECFCECBC6C1BDBABABBBEC2C6CACDD0D1D2D1D0CECDCCCBCACAC9C9C9
C9C9C9C8C7C7C6C5C5C4C4C4C4C4C5C5C5C5C5C4C3C1BFBDBBB9B8B7B8B7B7B5B1ABA296
867563514031261F1C1C1E2125292C2D2C2B2927252423232527292B2D2E303131313131
302E2C2A282523222120212224272C323A44505E
6F8092A3B3C0C9CFD0CFCBC7C2BEBBBABCBEC2C6CACED0D2D2D1D0CFCDCCCBCACACACACA
C9C9C9C8C8C7C6C5C5C4C4C4C4C4C5C5C6C6C5C4C3C1BFBDBAB9B8B8B8B9B9B7B4AFA699
8A796654433428211E1D1F2226292C2D2C2A28262423232325282B2D3032343435343432
312F2D2A282523222120212224282C323A44505F
6F8192A4B3C0CACFD1CFCCC7C2BEBBBBBCBFC3C7CBCED1D2D2D2D0CFCECCCBCACACACACA
CAC9C9C8C8C7C6C5C4C4C4C4C4C4C5C6C6C6C6C5C3C1BFBCBAB8B8B8B9BABABAB7B2AA9D
8E7C6A5746362B231F1F2023272A2C2D2C2A27252322222426292D303336383838383634
32302D2A282523222121212224282C323A44505F
6F8193A4B4C1CAD0D1D0CDC8C3BFBCBBBDBFC3C7CBCFD1D3D3D2D1CFCECDCCCBCACACACA
CACAC9C9C8C7C6C5C4C4C3C3C4C4C5C6C6C7C6C5C3C1BFBCBAB8B8B8BABBBCBCBAB6ADA1
92806E5B49392D2521202124272A2C2C2B29272423222224272B2F3337393B3C3C3B3936
34302D2A272523222121212325282C323A44505F
708193A5B4C2CBD1D2D1CDC9C4BFBDBCBDC0C4C8CCCFD2D3D3D3D1D0CECDCCCBCBCBCBCB
CACAC9C9C8C7C6C5C4C3C3C3C4C4C5C6C7C7C7C5C4C1BFBCBAB8B8B9BABCBEBEBDB9B1A5
9684715E4C3D302823222325282A2C2C2B29262422212224282C31363A3D3F403F3E3B38
35312E2A272523222121212325282D323A44505F
708294A5B5C2CCD1D3D2CEC9C5C0BDBDBEC1C4C8CCD0D2D4D4D3D2D0CFCECCCCCBCBCBCB
CBCACAC9C8C7C6C5C4C3C3C3C4C5C6C6C7C7C7C6C4C2BFBCBAB8B8B9BBBDBFC0BFBBB4A8
998875625040332B26242426282A2C2C2A28252321212225282D33383C3F424242403D39
36322E2A272523212121222325282D333A44505F
708294A6B6C3CDD2D4D2CFCAC5C1BEBDBFC1C5C9CDD0D3D4D4D4D2D1CFCECDCCCCCCCBCB
CBCACAC9C8C7C6C5C4C4C3C4C4C5C6C7C8C8C7C6C4C2BFBCBAB9B8BABCBFC1C2C1BEB7AB
9D8B79665444372E28262627282A2B2B2927242221212225292E34393D41434443413E3A
36322E2A272422212121212325282D323A44505F
708294A6B6C3CDD3D5D3D0CBC6C2BFBEC0C2C6CACED1D4D5D5D4D3D2D0CFCECDCCCCCCCC
CBCBCAC9C8C7C6C5C4C4C4C4C4C5C6C7C8C8C8C7C5C2C0BDBBB9B9BBBDC0C2C4C3C0B9AE
9F8E7C6957473A312B282727282A2A2A28262422212123262A2F34393E41434443413E3A
36322E2A272422212020212325282C323A44505F
718395A6B7C4CED3D5D4D1CCC8C3C0C0C1C4C7CBCFD2D4D6D6D5D4D2D1CFCECDCDCDCCCC
CCCBCAC9C9C7C6C6C5C4C4C4C5C6C7C8C9C9C8C7C5C3C0BEBCBABABCBEC1C4C5C5C1BBB0
A2917F6D5B4B3E342D2A28282829292827252322212123262A2F34393D40424342403D3A
36312D2A272422212020212224282C323A445160
718395A7B7C4CED4D6D5D2CDC9C4C2C1C2C5C8CCD0D3D5D7D7D6D5D3D2D0CFCECECDCDCC
CCCBCBCAC9C8C7C6C5C5C5C5C5C6C7C8C9C9C9C8C6C4C1BFBDBCBCBDC0C2C5C6C6C3BCB2
A49482705E4E4137302C29282828282726242322212224272B2F34383C3F4041403E3C38
35312D2A262422201F1F202124272C323A445160
718395A7B7C5CFD5D7D6D3CFCAC6C3C2C3C6C9CDD1D4D6D8D8D7D5D4D2D1D0CFCECECDCD
CCCCCBCAC9C8C7C6C6C5C5C5C6C7C8C9C9CAC9C8C7C5C2C0BEBDBDBEC1C4C6C7C7C4BDB3
A69685736252453A332D2A282727272624232222222325282B2F33373A3C3E3E3E3C3A37
34302D29262321201F1F1F2123272B323A445160
718396A7B8C5D0D6D8D7D4D0CBC7C4C4C5C7CBCFD2D5D8D9D9D8D6D5D3D2D0CFCFCECECD
CDCCCBCAC9C9C8C7C6C6C6C6C7C7C8C9CACACAC9C7C5C3C1BFBEBEC0C2C5C7C8C7C4BEB4
A79887766556483D352F2B292726252423222222222426282B2F323538393B3B3B3A3835
33302C292623211F1E1E1F2022262B3139445160
718396A8B8C6D0D6D8D8D5D1CCC8C5C5C6C9CCD0D3D6D9DADAD9D7D6D4D2D1D0CFCFCECD
CDCCCBCBCAC9C8C7C7C6C6C6C7C8C8C9CACACAC9C8C6C4C2C0BFBFC1C3C6C8C9C8C5BFB5
A99A8A7968594B4038312D292725242322222122232527292C2E31333537383838373634
322F2C292623211F1E1D1E1F22252A3139445160
718396A8B8C6D0D7D9D8D6D1CDC9C6C6C7CACDD1D5D8DADBDBDAD8D6D5D3D1D0CFCFCECE
CDCCCCCBCAC9C8C7C7C7C7C7C7C8C9C9CACACAC9C8C6C4C2C1C0C0C2C4C6C8C9C8C5BFB6
AA9C8C7C6B5C4F433A332E2A27252322212121222426282A2C2E30323334353535353432
302E2C292623201E1D1D1D1F21252A3139435060
718496A8B9C6D1D7D9D9D6D2CDCAC7C6C8CBCED2D6D9DBDCDCDAD9D7D5D3D2D0CFCFCECE
CDCCCCCBCAC9C8C8C7C7C7C7C7C8C9C9CACACAC9C8C6C5C3C1C1C1C2C4C7C8C9C9C6C0B7
AB9D8E7E6F6052473D352F2B27242321212122232527292B2D2E30313232333333333231
302E2B292623201E1D1D1D1E21252A3039435160
718496A8B9C6D1D7D9D9D6D2CDCAC7C7C8CBCFD3D7DADCDDDCDBD9D7D5D3D1D0CFCECECD
CDCCCBCBCAC9C8C7C7C6C6C6C7C7C8C9CACACAC9C8C6C4C3C1C1C1C2C4C7C8C9C9C6C0B8
AC9F90817263554A4038312C282523212121222325282A2C2D2F30303131313131313130
2F2D2B282623201E1D1D1D1E21252A3139445160
718496A8B9C6D1D7D9D8D6D2CDC9C7C7C8CBCFD4D8DBDDDEDDDCDAD7D5D3D1D0CFCECDCD
CDCCCBCACAC9C8C7C6C6C6C6C6C7C8C8C9C9C9C8C7C6C4C2C1C0C1C2C4C6C8C9C8C6C1B8
ADA192837466594D433A332D292523212121222426282B2C2E2F30303030303131313030
2F2D2B282623201F1D1D1D1F21252A3139445160
728496A8B9C6D1D7D9D8D5D1CDC9C7C7C9CCD0D4D9DCDEDFDEDCDAD8D5D3D1CFCECDCDCD
CCCCCBCAC9C8C7C6C6C5C5C5C6C6C7C8C9C9C9C8C7C5C3C2C0C0C0C1C4C6C8C9C8C6C1B9
AFA2948677695C50463D352F2A2623222122232527292B2D2E2F3030303030303030302F
2E2D2B282623211F1E1D1E1F22252B3139445160
728496A8B9C7D1D7D9D8D5D1CDC9C7C7C9CCD1D5DADDDFE0DFDDDBD8D5D2D0CECDCDCDCC
CCCCCBCAC9C8C7C6C5C5C4C5C5C6C6C7C8C8C8C7C6C4C3C1BFBFBFC1C3C5C7C9C8C6C1BA
B0A496887A6C5E53483F37312B27242222222325272A2C2E2F303030303030303030302F
2E2C2B282623211F1E1E1E1F22262B313A445160
728497A9B9C7D1D7D9D8D6D1CDC9C7C7CACDD2D7DBDFE1E2E1DEDBD8D5D2D0CECDCCCCCC
CCCBCBCAC9C8C7C6C5C4C4C4C5C5C6C7C8C8C8C7C5C4C2C0BFBEBFC0C2C5C7C8C8C6C2BB
B1A5988A7C6E61554A4139322C28252322222425282A2C2E2F3031313030303030302F2F
2D2C2A282523201F1E1E1E2022262B323A445161
728497A9BAC7D2D8DAD9D6D2CECAC8C8CBCFD4D9DDE1E3E3E2E0DCD9D5D2D0CECDCCCCCC
CCCCCBCAC9C8C7C6C5C4C4C4C4C5C6C7C7C8C7C6C5C3C1C0BEBEBEC0C2C5C7C9C9C7C3BC
B2A79A8C7E7063574C433A332D28252322222426282A2D2E303031313030302F2F2F2F2E
2D2B2A272522201E1E1D1E2022262B323A445161
728497AABAC8D3D9DBDAD7D3CFCBCACACDD1D6DBE0E3E6E6E4E1DEDAD6D2D0CECDCCCCCC
CCCCCCCBCAC9C7C6C5C4C4C4C4C5C6C7C7C8C7C6C5C3C1BFBEBDBEBFC2C5C7C9C9C8C4BD
B3A89B8E807265594E443B342D28252322222325282A2D2E30303030302F2F2F2F2E2E2D
2C2B292724221F1E1D1D1D1F22252B3139445160
728598AABBCAD4DBDDDCDAD6D1CECCCDCFD4D9DEE3E7E9E9E7E4DFDBD7D3D0CECDCCCCCC
CDCDCCCCCBC9C8C7C6C5C4C4C5C5C6C7C8C8C8C7C5C3C1BFBEBDBEBFC2C5C8C9CAC8C5BE
B5A99D8F8173665A4E443B332D28242221212325282A2C2E2F30302F2F2E2E2E2E2D2D2D
2C2A282623211E1D1C1C1C1E2024293038435060
718598ABBDCBD6DDE0DFDDD9D5D1CFD0D3D8DDE2E7EAECECEAE6E2DDD8D4D1CFCDCDCDCD
CDCECDCDCCCBC9C8C7C6C6C5C6C6C7C8C9C9C8C7C6C4C1C0BEBDBEC0C3C6C8CACBCAC6BF
B6AB9E908274665A4E443B332C26232120202224272A2C2E2E2F2F2E2D2D2C2C2C2C2C2C
2B29282522201D1B1A1A1A1B1E22272E37424F5F
718599ACBECDD9E0E3E3E0DCD9D5D4D4D7DCE1E7EBEFF0F0EDE9E4DFDAD5D2CFCECECECE
CFCFCFCECDCCCBC9C8C7C7C7C7C8C8C9CACAC9C8C6C4C2C0BFBEBFC1C3C7CACCCCCBC7C0
B7AC9F91827466594E4339312A25211F1E1F212326292B2D2E2E2D2C2B2A2A2A2A2A2B2B
2A292725221F1C19181717191B1F252C35404E5E
708499ADC0CFDBE3E6E6E4E1DDDAD8D9DCE1E6EBF0F3F4F3F0ECE7E1DCD7D3D0CFCFCFCF
D0D0D0D0CFCECCCBCAC9C9C9C9C9CACBCBCBCAC9C7C5C3C1C0BFC0C2C5C8CBCDCECCC9C2
B8AD9F91837466594D42382F28231F1D1C1D1F2225282B2C2D2C2C2A2928272728292929
29282724211D1A1816151416181C2229323E4C5D
708499AEC1D1DEE6EAEAE8E5E1DEDDDEE1E5EAF0F4F7F8F7F3EFE9E3DDD8D4D1D0CFD0D0
D1D1D1D1D0CFCECDCCCBCACACACBCBCCCCCCCCCAC8C6C4C2C1C0C1C3C6C9CCCECFCECAC3
B9ADA091837465584B40362E26211D1B1B1C1E2125282A2C2C2B2A292726252526272828
29282624201D19161412121315191F27303C4B5C
6F849AAFC2D3E0E8EDEDECE9E5E2E1E2E5E9EEF3F7FAFBFAF6F1EBE4DED9D5D2D1D0D0D1
D1D2D2D2D1D0CFCECDCCCCCBCCCCCCCDCDCDCCCBC9C7C5C3C1C1C1C3C6CACDCFD0CECAC3
BAAEA092837465574B3F352C251F1B19191B1D2124272A2B2B2A29272524232324262728
28282624201C18151210101113171D252E3B4A5B
6F849AB0C4D5E2EBEFF0EFECE9E6E5E6E9EDF2F7FAFDFEFCF8F2ECE6DFDAD5D2D1D0D1D1
D2D3D3D3D2D1D0CFCECDCDCDCDCDCDCECECECDCBCAC7C5C3C2C1C2C4C7CACDD0D0CFCBC4
BAAEA092837465574A3F342B231D1A18181A1C2024272A2B2B2A28262422222223252627
28282724201C181411100F0F12161C232D3A495B
6F859BB0C4D6E3ECF1F3F2EFECE9E8E9ECF0F4F9FDFFFFFDF9F3EDE6E0DAD6D3D1D1D1D1
D2D3D3D3D3D2D1D0CFCECDCDCDCDCECECECECDCCCAC8C6C4C2C2C2C4C7CACDD0D0CFCBC4
BAAEA192837466584B3F342B231D191717191C2024272A2B2B2A28262322212122242627
28282624201C1814110F0F0F12161C232D3A495B
70869CB1C5D7E4EDF2F4F3F1EEEBEAEBEEF2F6FAFEFFFFFDF9F3EDE6E0DAD6D3D1D0D1D1
D2D3D3D3D3D2D1D0CFCECECDCDCECECECECECDCBCAC8C5C4C2C2C2C4C7CACDCFCFCECAC3
BAAEA193857667594C40352B231C181617181B1F23272A2B2B2A28262322212122232526
27272623201C18151210101113171D252F3B4A5C
72879DB2C6D7E4EDF2F4F4F2EFEDECECEFF2F7FAFDFFFFFCF8F2ECE5DFDAD5D2D1D0D0D1
D1D2D2D2D2D1D0CFCFCECDCDCDCDCDCECDCDCCCBC9C7C5C3C2C2C2C4C6C9CCCDCECCC9C2
B9AEA29486786A5C4E42372D241D191717181B1F23272A2B2B2A29262423222222242526
26262523201C191614131213161A2028313E4C5E
74899EB2C6D6E3ECF1F3F3F1EFEDECECEFF2F6F9FCFDFDFAF6F1EAE4DED9D4D1D0CFCFD0
D0D1D1D1D1D0CFCECECDCCCCCCCCCCCCCCCCCBCAC8C6C4C3C1C1C1C3C5C8CACBCBCAC6C0
B8AEA396897B6D5F52453A2F261F1A1717191C1F24272A2C2C2B2A282625232324242526
262524221F1C1A18161616181B1F252C36415061
778A9FB2C5D5E2EAEFF1F1F0EDEBEAEBEDF0F3F6F9FAF9F7F3EEE8E2DCD7D3D0CECECDCE
CECFCFCFCFCECDCDCCCBCBCACACACACACACAC9C8C6C4C3C1C0C0C0C1C3C5C7C8C8C7C4BE
B7AEA3988B7E7164564A3E3329211C19191A1D2024282B2D2E2D2C2B2928262626262626
25252322201D1C1B1A1A1B1D20252A323B465464
798C9FB2C3D3DFE7ECEEEEEDEBE9E8E8EAEDF0F2F4F5F5F2EEEAE4DED9D4D0CECCCBCBCB
CCCCCCCCCCCBCBCAC9C9C8C8C8C8C8C8C8C7C6C5C4C2C1BFBEBEBEBFC1C2C4C5C5C3C0BB
B5ADA3998E8276695B4F42372D251F1C1B1C1F22262A2D2F30302F2E2D2B2A2929282827
26252322211F1E1E1F202124272B3137404B5867
7B8D9FB1C1D0DBE3E8EAEAE8E6E5E4E4E6E8EBEDEFEFEFEDE9E4DFDAD5D1CDCBC9C8C8C8
C8C9C9C9C8C8C7C6C6C5C5C5C5C5C5C4C4C4C3C2C1BFBEBDBCBCBCBCBEBFC0C0C0BFBCB8
B2ACA39B91867A6E6154483C322923201E1F2125282C2F323333333231302F2E2D2C2B29
28262524232222232426282B2E32373D454F5B6A
7C8C9DAEBECBD6DEE2E4E4E3E1DFDEDEDFE2E4E6E7E8E7E5E2DED9D5D0CCC9C7C5C4C4C4
C4C4C4C4C4C3C3C2C2C1C1C1C0C0C0C0C0C0BFBEBDBCBBBAB9B8B8B9BABBBBBBBBBAB7B4
AFAAA39B93897E73665A4D42372F2825232426292C303335373838383736353432312F2D
2B292827262727282A2D2F3235393D434A535E6C
7B8B9BAAB9C6D0D7DBDDDCDBD9D7D6D6D7D9DBDDDEDFDEDCD9D6D2CDCAC6C3C1C0BFBFBF
BFBFBFBEBEBEBDBCBCBCBBBBBBBBBBBBBBBABAB9B8B7B6B5B5B4B4B4B5B5B6B6B5B4B2AF
ABA7A19B948C82776C6054483E362F2C2A2A2C2F3235393B3D3D3E3E3D3D3C3A39373533
312F2E2D2D2D2E30323437393C3F43484E56606D
798796A5B3BFC8CED2D3D3D1D0CECCCCCDCED0D2D3D3D3D1CFCCC8C4C1BEBBBAB9B8B8B8
B8B8B8B7B7B7B6B6B5B5B5B4B4B4B4B4B4B4B4B3B2B1B1B0AFAFAFAFAFAFAFAFAEADACA9
A7A39F9A948D857B71665B50463E3834333335373A3D4042444545454544444241403E3C
3A3937373737383A3C3E3F414345484B5157606C
7582909EABB6BFC4C8C8C8C6C4C2C0C0C0C2C3C5C6C6C6C5C2C0BDB9B7B4B2B0B0AFAFAF
AFAFAFAFAFAEAEADADADACACACACADADADADACACABABAAA9A9A8A8A8A8A8A8A7A7A6A4A3
A19F9C98938D877E756B62584F48433F3E3E3F4244474A4B4D4D4D4D4D4D4C4C4B4A4948
4645444444444546474849494A4A4C4E51575F69
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Level) show
99.000 12.813 moveto
(2) show
105.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
7D959F9274533A30343E4951565B5F61615F5C595654525150515255585B5D5E5F5E5D5D
5C5C5C5D5F6161605D5B5A5B5E606262605E5D5D5E606263646565625F5C5B5C5F626464
626061656B717575737170747A80868A8D8D8C8985807C7978797A7C7E808181807F7E7F
8080807F7C7B7A7B7D8086919DA5A3937A635A65
707A7B6B4F321B1212181F262B2F33353534312E2B2928282A2E3135393C3E4040403F3D
3B3A3A3D40444543403C3A3C41464A4A49474545454647494B4D4D4C4A484747484A4C4D
4E5053575C62696F767D858E97A0A6AAAAAAA7A5A29F9D9B9B9B9C9D9FA1A19F9C999898
9A9C9C99949190939AA3B1C4D7E3E2CCAA866D68
686C69583D220C0201050A1015191D1F201E1C1816141315191E23272B2E30323232302E
2B29292C30353734302C2A2D33393E3F3E3B393838383A3C3F414242403E3D3C3D3E4043
46494D51555A616B76828F9BA6B0B6B9B8B6B2B0ADACABABACADAFB1B2B3B2AFABA6A3A2
A3A4A3A09D9C9EA5AFBCCCE0F4FFFCE3BC937467
6A737363482C160B0B0F161C21262A2C2D2B282523212123272C3135383B3C3D3D3C3A37
34323134383C3D3B373332353B42464745423F3E3D3E3F43464A4C4B484542424346494C
4E515456585B6068737E8A959FA7ACAEACA9A5A29F9E9EA0A3A6AAACAEAEACA9A59F9994
908D8B8C90969FA9B5C0CCD9E3E7DEC5A3806863
7388918469493126282F3840464C505253514E4B494848494C4F5356585A5B5A59585553
504E4D4E505354524F4D4C4F54595C5C5A565352515154585D6163615C565353575B5F62
63636363636365696E747B82888D90908E8B8783807E7E82878D9296979795928E898176
6B636167748494A2ADB3B6B5B1A899836C58525D
7EA2B4AB8F6C51464B56626C72787D7F7F7E7B78767574757677797B7C7D7D7C7A777573
716F6E6E6E6E6E6D6C6B6C6E72757675726F6C6A696A6C71777C7D79726B67686E74797B
7A777472706E6C6A6868686A6C6D6E6D6B6865605C5A5A5F666F767A7B797775726D6455
45393742576E84949C9C958774604C3B2F2C3957
88B7D0CAAC886A616775848E959BA0A2A2A19D9B989796959595959696969694928F8D8C
8B8A898886848383838486888A8B8A8885827F7D7D7E81868B90918C837B76787F878D8E
8B86817D7A76726C655F5A5755545352504E4B47434041464E575E6263615E5C59554C3E
2F24243147607582857F705B41291508050F2955
8FBFDAD5B792756C7382919CA3A8ACAEAFAEABA7A4A19F9E9D9C9C9C9C9C9B9A98979695
969695928F8C8A8B8D8F9293949392908D8A888787878A8E9296959088807C7E858D9292
8F8A85817D7A746D655D56514D4B4947464443403D3B3C41484F55585855524D49443F38
33313540505F6A6E6A5F4F3B27150700000C2958
91BED6CFB28E726A71808E989EA2A5A8A9A8A5A19D999693929292929191919190909091
939493908C8886878B8F929392918F8D8A8987878788898C8E8F8E8A837D7A7C81878C8C
8985817E7B78746E67605A55514E4B4A4A4A49484747484C505457585755504A433E3D42
4B555F666968645C5143362B24201C18181F365F
91B8CBC3A6846A626976848C9194979A9B9B98938E888481808080808080808182848588
8A8C8B88847F7E7F83888C8C8B89868483828282838384848584827F7A7674767A7E8181
7F7D7A787775736F6B66625D5956545354555758595A5B5C5D5D5D5C5B59544C443F4353
697E8C8D8373604E3D2F27272E383E3D39394666
8FB0C1B79B7A6159606C78808386888B8D8D8A857E77726F6E6E6E6E6E6F707274777A7E
818383807C7776777B808384817F7C7B7A7A7B7B7C7D7D7C7B79777472706F7073757777
75747272727272716F6C6965625F5E5E5F6265686B6D6E6D6A66625F5D5B57524D4C5569
839AA6A290785F49372B283141535F5D544D526B
8BABBAB093735A52586470777B7D80828484817B746D676463636363636466686B6F7276
7A7D7D7B7773717276797C7B79767472727273747677777674716F6E6D6D6D6E6F707170
6F6D6D6E70727372716F6C6967656566686B6F7477797977726B645D585655575C647080
909DA19988735F4E433C3D485869716C5E525369
86A7B7AD906E544C525E6B7276797C7E807F7C766F68625F5E5D5E5E5F606264676B6E72
76797A78757270707274757472706E6C6C6C6C6E707172716F6D6C6B6B6C6D6E6E6F6E6D
6B69696B6F727474726F6D6A6969696B6E72767B7E807F7B746C635A524E525E6F808E94
928C847A7168615D5B5C60677078776B5A4C4D63
80A3B5AB8D6A4E454C58656D7175787A7C7B77726B65605C5B5B5B5C5D5E606365686B6E
7174757472706E6D6E6E6E6D6B6A6867666666686A6B6C6C6B6A696A6B6C6D6E6E6E6D6B
686767696D72747472706D6C6B6C6E7073777B7F8283817C756D6358504C5366819AA6A0
8D756158585E666F787F8588888479665243445C
7CA1B4A98A65483E44515E666B6F72747675716C66615C5A59595A5A5B5D5F616467696B
6C6D6E6E6D6D6C6B6A6A6867666463626262636465666767676767696A6B6C6D6D6C6B69
676565686C70737473716F6E6F707174777A7E818484817C746D645C56555E748EA5AD9E
806048424B5B6F82919CA2A1998D7A624B3B3D56
7AA0B3A8876042373D49565F63666A6C6D6C6965605B585656575959595A5B5F63676A6A
686664656668696A6967666462605F5F616263636362626263656668696A6A6B6B6A6968
66656567696C6F717373737373737476787B7E818283807A726B6766696E7885939B9987
6D53424250657C909EA8ABA89F907C624A393B54
7BA0B3A6845C3D32374350575B5E61646565625E5A565353555759595858595D63686A69
645F5C5C5F63676868676563605D5D5E6265676663605E5E616466686868686868686867
6766666667686A6E727679797876767678797B7D7E7F7C766F6A6A73818F97968E827364
574E4C5463768998A2A6A6A29A8F7D654C3B3B54
7DA2B4A78359392E333F4C53575A5C5F61615F5C58545354575B5D5D5C5B5C60656A6B68
615A56575B60646768686764615E5D60656A6C6A65605C5D606468696867666667676868
696968676564666B71787D7E7C79767575757576777776716C6A708198ABB0A184644B40
434D5B6A7988949B9E9C98938E887A654D3C3D56
81A5B6A78257362A303D4A53575A5D61646564615D5B5A5B5F6367696A6A6B6C6D6D6B66
5F595555585D616466676765636162656A6F716E68625E5F62676A6B6A68676768696A6A
6B6B6A676462636871797F817E7A767472706E6C6B6B6C6B6C6F7A8EA6B7B69D754B2F2B
39516A7C89929899968F8883817D74624D3D3F59
84A8B8A7805432262D3B4A555B60656A6F71716F6C69696A6D72787E848888837B716861
5C5A585858595B5D5F62646667696B6E717373706B666363676A6D6E6D6B6A6A6B6C6C6D
6D6D6B686461626770787F81807C7874706C68625D5C5E656F7B8999A6ABA28863402B2C
3F5973848D9293908B847C7875736C5C4A3D415C
87ABB9A87F512F232B3B4D59626971787E8282817E7C7B7B7D828A95A1AAAA9E8A73625B
5B5E605F5B575455575B60666C727678777573706D6A696A6C6F7071706F6E6F6F707070
6F6D6B68656363686F767D80807D79746F696158504C5160768B9A9F9A8F7D6853423A40
5064778287888784807B75706D6A6255463C435F
8AAEBCA980522E232C3E51606A747D868D9192908D8A8888898E97A7B8C4C4B193735C55
5C666C6A60564F4E51575F6871797E7F7B76726F6F6F7071717273737373737373737372
706E6B68666566696E74797D7E7E7A756E665D514642495F7D98A6A0896E5649464A515B
6570797D7E7C797775736F6B67625B4E423B4462
8CB1C0AE8557352A33465A69747E879096999895908C8988898D97A7BAC7C5B08D6A5352
61737E7B6C5C514E545C656E757B7E7D7A76727172737475747474747474757575757573
716F6C6A6968696A6D7175797C7D7B746C62584D45424C63829CA69777533B3743566872
7779797775716E6D6D6C6B68635E564A3F3A4463
8DB4C5B690644339435567757F878D939695918A837C7877787C85919FA8A59174574A53
6B869692806A5B59626E7679777572727374747575757675747473737373747475757473
72706E6D6C6B6B6B6C6D7074797B7A72675D544F4E525C6E83939584674937394B63767F
7F7B76726E6B686869696866625E55493D384262
8DB6CABF9D75564D55657681888C8F908E8981766B625C5B5E62686E72746F614F414156
799BAFAA947A696976858D88796A60606871787A79767473727271717070717172727373
73727271706F6D6C6A6A6B6F7478776F635752555E6A757D8080796C5A4B454C5C6F7D82
7F79726D6A696868696968676460584A3D364060
8CB8D0C8A983675E6573818A8D8E8D89847B6E605247404044484B4A454039322D2F3E5D
86ACC1BCA3877478899CA2957B604F4F5D6D7A7E7B75716F6F6F6F6E6E6D6D6D6E6F7072
7374757473726F6D6967676A6F73726B5F56545F71838C897B6A5B5352545B65707B8181
7B736C6867686A6B6C6C6B6A68655C4D3D333C5D
8CBBD5CFB18C6E656B7783898B8A87827A70625344373131363B3B34291E18181F2E4669
90B3C4BCA285747B91A7AF9F7D5B4546566B7A7F7B736E6C6D6E6E6D6C6B6B6B6B6C6D70
727577777674716E6A666465686C6C675F5A5D6C82959B8D725643424E60717C8183817C
756D676465686C6F7171706F6E6A604F3D323A5C
8FBFDAD3B28A695D616C777E80807F7B756C6153463B35373C4141382A1E1A1F2E435C7A
96ACB3A68B70636E88A3AFA282604A485669777B77706B6A6C6E6F6E6D6C6B6A69696B6D
717477787775726F6B6764626162636363666D7C8E9A99866748373B506A7F8A8A857E77
7069656364686E7276777776746F64513D31395C
92C3DDD3AD805B4B4E58646C70737676746F685F554D494B5056564E4238374052677B8B
969B9481675047567493A59F876C58555D697274716D6A6B6D6F7171706E6D6B6968696B
6E727577777673716E6A655F5A585A616B76828C93948B765B4237405772878F8C837971
6C67646365686E757A7D7E7D797366533E323B5F
94C4DCCEA4724A3738434F5960676D727576736E69646264696E6F6A625C5D697A8B9799
9286735B43302D3E5D7E94978B7A6B6566696C6C6A696A6C6F71737372716F6C6A676769
6C70747677767472706C665D544F5260748895999488776450423F4B61798A8F897E736B
6866656566696F767E8385837E76685440343D61
91BED3C398653C292A34414D56606A72797D7E7D7A7877797D8183817D7B7E8997A3A69E
8B745A412C1F1F304C6A828D8C847B746E6A676565666A6D707274747473706D69676667
6B6F737677777674716D665B514B4F637D97A5A1907963524A474C596B7E8A8B84786D67
65656666676A70788086888680786A5642363F61
87AEBFB0895B36252732404C56616D767E8386868483828385898B8B8B8B8E969EA4A195
816A523D2E252632465D71808789857E746A625F61656A6E7072737473726F6C68666567
6A6F7377797A7875706B63594F4B526886A0ACA2886A514648505C69758086857F756C66
63636465676B71798186888681786B58463A405D
7A99A79A7A54372B2F3A48545F6A747D84888A89878583838486888A8C8D8F9293938E84
7667584B423C3C414A5664727F87898377695F5C5F656B6E70727272716F6D6A67656567
6B7075797C7D7A756E675F5751515A708CA4AC9D7E5D46414C5D6D787D7F7F7D79746E68
64616163666C737A808485837F786C5B493E4158
6D8691876E523C353B4754606A737C84898C8C8986827F7D7D7F818487898A87827C7570
6C67635F5C5A575553545A667583898478695F5C60666C6F707070706F6D6B6866656669
6C71757A7E7F7C756B625B56565A65798FA0A39172533F41536B7E84817B75737373706B
65605F61666D747A7E80817F7B766C5D4D424354
677B847D6953434047525F6A737B81878B8C8A86817D79767676787C8083827B72696261
64686D7072726F685F57565F6D7B8381776B626063686C6F70706F6E6D6B69686767686A
6D7074797D7F7C74685E58585E6773818E969281674E41495F788A8C83766C696C70716D
67626062676E74797B7C7B7A78736B5F51464652
6A7D87806E5A4B484F5A656F757B8185878785807B76726F6F707276797C7A746A615C5C
616870777C7E7C74695E595D67727A7A756E6967696B6D6F6F6F6F6E6D6B6A69696A6B6C
6D6F71767A7D7A72665B575D6977828888847A6C5C4F4D586D82908E81716562666B6E6D
696564666B7175787877767574716B60534A4A56
748A948D7963534E535D676F73777B7E80807D79746F6B69696B6D707374736F69635F5F
62676D757B80807B7268616063696D7072727271706E6E6E6F70706F6E6D6C6C6D6E6F6F
6D6C6D707478776F645A59647687908C7E6D5E5654565E6C7B898F8A7D6E615D60656A6B
6B6A6B6D7073767675747271706F6A60554D4F5E
8099A59D876E5A53575F686D70727476787775716C6764636466696B6C6D6C6B6A686766
65676A70777D807E79736C66626061666E757A7A77726E6D6E6F70706F6E6E6F71737371
6D6A686A6E72726C635D5F6D82949A8C715644424E607280888D8C84786A605B5C5F6469
6C6F72747676767573706E6E6E6D6960564F5366
89A5B2AA92765F565960686C6D6E6F7071706E6A65615E5E60626465666667696B6D6D6C
6A68696D73797D807F7C766D625A585E6A7780817B746E6C6C6E70706F6F707274767572
6D686564676A6B69656369788C9B9B86644330354D6A8390928F877D73685F5A595B6066
6D7377797A797774716E6C6B6C6C68605650566B
8CA9B7AF977962595B62696C6D6C6D6D6E6D6A67625F5C5C5D5F6061626364676B6E706F
6D6B6B6E72767B7F82827E736559545A677680817C756E6B6B6C6D6E6E6F717376777672
6D686361606164676A6F77839198927A573828324F718C98978F84796F665E59585A5F65
6D74797C7C7A7774716E6B6B6B6C68605650566C
89A6B5AD957962595C636A6D6E6D6E6E6E6D6A67635F5D5C5C5D5E5F616365686B6D6F70
706F70717375787D82848177695C555965727C7E7A746E6A6969696A6C6F727476767572
6E69645E5A595C65717D878F928F82694C342A3754748E9A988F83776E655D59585A5F66
6D74797B7C7A7875716E6B6B6C6C6960554F546A
85A2B0A9927660585B636A6E6F6F7070706F6C6965625F5E5D5D5E606265686A6C6D6E70
71737473737375797F83827A6D615A5C646E767876736E6A686665676A6E727576757472
6F6B655D55525664788B979890826F59443633415A768C96948C81776D655E5A595C6066
6C72777A7A7A7876736F6D6C6D6D6960544D5167
819EACA58E725C555861696E707172737372706D696663615F5E5F6265696C6D6D6D6E6F
72747574727070757B80817B70666060646B70737473706C68646264696E737677767472
706C665C524C51647E97A4A08E775F4C413C3F4D6176878F8E8980776E66605D5C5E6267
6C7074777879787774716F6E6F6E6A5F534A4E63
7F9DACA48B6E5850545E676D6F717375777775716D69666462626366696C6F6F6F6E6E6F
71737473706D6D70767B7D79726A656365696D707374736F69646163686F75797A797774
716D665B504A5065839EABA48C70564742444C586675818787847D767069646161626568
6B6E7274767778777573717070706A5F51474B60
7F9EAEA58B6C534B505A656B6F7174777A7B7976716C68666666686A6D6F7171706F6E6F
7071716F6D6A6A6D71757776726D696767686B6F737777726B6561636971777C7E7D7B77
736E665B504B516785A0ADA48B6D5448474E57606A737B7F807E7A76716D696766666768
6A6D6F72747677777775737272716B5E4E44475E
7FA0B0A78A694F464B57626A6E71757A7D7F7E7A746F6B69696A6C6E7072727271706E6E
6E6E6E6C6A69686A6C6F7171716F6E6C6A696A6E74787A756E6763646A72797E81807E7A
746D645A524E556A859EA9A0886B554D505862686D7174777979777573716E6C6B6A6969
6A6B6D6F727476787876757474726B5D4C41455C
7FA1B2A88A664B42475360686D72777C8082807C76706C6B6B6D6F717273737372716F6E
6D6C6B6A69686868696A6B6D707272706D6A696D73787A776F6864656B72797E8182807A
736A625A54545B6D8498A198836B595459636B6F6F6F6F7072747475747472716E6C6A69
69696A6D6F7375777877767675736B5C4B3F425B
7FA2B3A88964483E43505D676D73797E8182817C77716D6C6C6E7072737474747473716F
6D6B6968686868676666676B707576746F6A686B707678756F6966676B70767C7F817E78
6F665E59585B6371818E938C7C6A5D5C636C7374716E6B6B6D6F717375757573716D6B68
6767696B6E7175777878777776736B5B493D415A
7FA3B4A88863463B404D5A656D747A7F82827F7B76726E6C6C6D6F707273747576757471
6E6B6867686868676563656A71777A78726B67686C7073726E6A68686B6E72777B7D7B73
696059585C636B747C82837D736862646B747978736D6967696C6F7274767674716D6A67
666667696D7074777878787776746B5B493C4059
7FA3B5A98962453A3E4B59646D757B8081807D7975716E6C6B6C6D6E7072747677777673
6F6B6867686969676462646A72797D7B746C6765676B6D6D6C6B6A6A6B6C6E727678766F
645A5559626C74787875716D6A67686C73797D7A746D676566696D7073757674716D6966
656567696C7073767878787776746B5B483C3F59
80A5B6AB8A64453A3E4A58646D757C7F807E7A7673706E6C6A6A6A6C6E70737577787875
716D6A69696A69676563646A737B7F7D766E6864646567696A6C6D6D6C6B6B6E7274736B
6057545B68767E7C7368605E61676E74797D7E7A746C666465676B6F72747573706C6866
656667696C6F73767778777776746B5B483C3F59
81A6B9AE8D66483C404C59646D757C7F7F7C7874716F6D6B6969696A6C6E717376787876
736F6C6B6A6A6A676564666C747B7F7E78716A65636263666A6F72716F6C6A6C6F72716A
5F565560708187806F5D51515A67737B7F807E79726A646263666A6E717374726F6B6867
6767696B6C6F72757777777776736B5A483B3F5A
82A8BBB1906A4C40434E5B666E757B7E7E7B7773706D6B69686868696B6C6F7174767776
74726F6D6C6B69676665686D747A7E7E7A746D67625F5F646A717676726E6A6B6E71716A
61595A66798A8F836C5445475567778082817D766F68626062656A6D707272716E6C6969
696A6B6C6D6F71737677777776736A5A483B3F5A
83AABEB3946D4F4346515D676E757A7D7D7A77736F6C6A68676768696A6B6D6F71747576
757472706D6B696767676A6E74797C7D7A77716A635E5D626B747A7B76706C6B6D70706B
645E616E81919585694E3D4052687B8485817A736C66616062666A6D6F7070706E6C6B6B
6B6C6D6E6E6E70737577777776736A59473B3F5B
84ABC0B69670514548535F686E74797C7C7A77736F6B696766666768696A6C6E70727375
757574716E6B696868696C6F7377797B7B79746D645D5B616B767D7E7A736D6B6C6D6D6A
67656A7788959683664A3A3E526B7F87868078716A64606062676B6E6F706F6F6E6D6C6D
6D6E6F6F6E6F70727577787877736A59473A3F5B
85ACC1B79770514549535F686E74787B7C7A77736F6B686664646566686A6C6E70717273
747473716E6B6969696B6D6F717375787A7A776F655D5A5F6A767F807C756F6A68676868
696C737F8C95927F63483A41566F838A877F766E6864616164686C6F70706F6F6F6E6E6E
6E6F6F6F6F6F71737677787877746A59463A3F5B
85ADC2B7966F4F4347535F686E73787B7C7B7874706B686563626264676B6E7071717172
727271706D6B6A6A6B6D6E6F6F6F7174787B7971665D595E69767E817D776F6863606165
6B747D878E918A775F493F475B74868C877E746D68646263666A6E707170707070706F6F
6E6E6E6E6E7072757778797977746B5946393E5B
85AEC2B7956C4D4145515E686E73787B7D7C7975706C686462606163676C6F7172727170
70706F6E6C6B6B6B6D6E6F6E6D6C6D71767A7A73685E5A5F69757D807D7870675F595961
6E7C878D8E8A7F6E5B4B464F6278888C867C726B68666566686B6E70717171717171706F
6E6C6C6C6E7073767879797978756B5946393E5A
85AEC3B7946A4A3E43505E686E73787B7D7D7A76716C686461606164696E71737372706F
6E6D6C6C6B6B6C6D6E6F6F6E6B69696D737879736A625E616A737B7E7D7971665B53535E
718391938D817364574E4E586A7C898B8479706B6A6A6B6C6C6D6E70717272727271706F
6D6B6A6B6D707377797A7A7A78746A5945383D5A
85AFC3B79368473B414F5E686D72777B7E7D7B77726D6865636263676B7073747472706E
6C6B6A6A6B6B6D6E7070706E6B68676B707576736D6764666C72777B7B7A7367594E4E5C
748B99988B79675B545256616F7E87867F746C6B6E727574726F6D6E6F71727372716F6D
6B6A696A6C6E7276797B7B7B7874695743363C59
85AFC3B79266453A404F5E686E72777B7E7E7C77726D68666565676B6F72757574726F6D
6B6A69696A6C6E6F7172716E6B6867696C7072726F6D6C6C6F717477797A7468584C4B5C
7792A09B88705C5251555E68747E8381786F696B727A7F7D77706B6A6D70727372706E6C
6A6969696A6D7075797B7C7B7873675541353A59
85AFC4B791654438404F5F696E72767B7E7F7C78726C686667686B6E7174757574716F6C
6A6969696A6C6E707273726F6C696767696B6E70727374737271717377797568574A4A5D
7A97A59D8569534B4F59646E767D7F7B736A666B768187847B7069676B6F7273716E6C6A
69696969696B6E73787C7D7B7872665340333A59
85B0C4B791654338404F5F696E72767B7E7F7D78726C6867686B6E717374757573716F6D
6B6A696A6B6D6F71737373716D6A676666676A6E73787B7A76716E6F72757266574A4B5F
7D9AA89D82634D474F5C6972787B7A766F68666B768287847A6E6665696E7273716E6B69
69696969696A6E73787B7C7B787165533F333958
85B0C4B792654438404F5F696F73777B7F807D78716B6766686C6F71727373737272706E
6D6C6B6B6C6D6F71737474726F6B67656363666D757C807F79716C6B6D6F6C62554C4E62
809BA79B7F6049454F5E6C74777876736E69686C737B7E7B736A6464696E7273716E6B6A
696969696A6C6F73787A7B7A7872675441343958
86B0C5B89266453941505F696F73787C80807E78716A6665686B6E707170707171727271
6F6E6D6D6C6D6E7073757573706C68646161646B757E83827C736B686767655D544E5367
829BA4987C5E494550606E75767573716F6D6B6C6D6F6F6C686563656A6E7272716F6C6B
6A6A6A6B6C6E71757879797978746A5743353A59
86B0C5B89368463B41505F696F74797E81817D7770696564676A6D6E6E6E6D6F70727373
72716F6E6D6D6E7073757674716D68646160636A757F85847E756C6662605C575251596C
8499A1947A5E4B4852616E74747271717272706C67635F5E5E6063676B6F717271706E6C
6B6A6B6C6E7174767878787878766C5A45373B59
86B0C5B99469483C414F5E686F757A7F81807D766F68646365696B6C6C6C6C6D6F717273
7372716F6E6D6E7073757674716D6964605F6269747E858581796F675F59555151545E70
86979D917A604E4B54616D7272706F717475736C635B5656595E64696D6F717272716F6D
6B6B6B6C6F7275777877777778776E5C47373B59
86B0C5BA966B493C414E5C676F767B7F817F7B756E6864636567696B6B6B6B6D6E6F7071
717171706E6D6E7072747574726E6A65615F6168727C8386837D756A5F56504E50566374
87969A8F7B64535056616B6F706F6F717476736D645C57575B61676B6E70717272716F6D
6C6B6B6C6F7275777877777778766E5B46373B59
86B0C6BA976C4A3C404C5A656E767C80807E79736D686564646668696B6C6D6D6D6D6D6E
6F6F706F6E6E6E7072747473716F6B66626061677079808586837B6F62554D4C50596677
8895988F7C6858545860686D6E6F70727474736E6964616063676A6D6F71717271716F6D
6C6A6A6B6E7174777878787878756C5944363A59
86B1C6BB976C4A3C3F4A58646D767D80807C77726D696664646566696B6D6F6E6D6B6A6B
6C6D6E6E6E6E6F7071727372716F6C68646162666D757D838787817565564C4B505B6979
8994978E7E6B5D575A60676B6E6F7172737372706E6D6C6C6C6D6E6F7071717171706F6D
6B6A696A6C6F7376797A7A7978746A5742343A58
86B1C7BC986C493B3E4957636D767D80807C76716D6A6765646566696D7071706E6B6969
6A6B6C6D6E6F6F707070707070706E6A666363666B7279818789857968584D4B515D6B7B
8993958D7E6C5F595B60666B6E7072737372717273747575737271717171717171706E6C
6B6968696B6E7276797B7B7A7873685540333858
86B2C8BC976B483A3D4857636D767D81807C77726E6A68666566686B6F727473716D6B6A
6A6A6B6D6E6F70706F6E6E6E7071706D68656465696E757E8589877B6A594E4D535F6D7B
8891938A7B6B5E595C61686C6F71727373737374767778777674727171717171706F6E6C
6A6868696B6F73777A7B7B7A777267543F313757
86B3C9BD976A46383C4958646E767D81817D78736F6B696767686A6D7174767674716E6C
6B6A6B6C6E6F706F6D6B6B6C6F71726F6B676565686C727A8287857B6B5B514F56606E7B
878F8F8777675B585C646B6F7071727374757676767676757473727171707070706F6E6C
696867686B7074787A7B7A79777267543F313657
86B3CABD966944363C4959666E767D80817F7A75706C6968686A6C70737678787674716F
6D6B6B6C6D6F706F6C69686B6F7274726D696665676A6F777F84837A6C5E545359626E7A
858C8C82736257565D666F7272717172757778777574727171717170706F6F6F6F6F6E6B
696767686C7175797B7A7978767267543E303656
87B5CBBE966742353C4B5B676F767C8081807C77716D6968686A6D707477797978767370
6E6C6B6C6E6F706E6B68676A6E7375736F6B676667696D747B7F7F786C6159575C636D78
8389897F6F5F55555E6A737674716F707477797774716E6E6E6F706F6F6E6D6E6E6E6E6B
696666686C72777A7B7A7977767268543E303556
88B6CDBE966641343C4D5E6970757A7E81807D78736D6A6767686A6E727678787674716F
6E6D6D6D6E6F6F6D6A68686A6E727473706C696767686C71777B7B766D645E5C5F646C76
8087867D6D5E5557616E777975706D6D71757776736F6D6C6D6E6F6E6D6C6B6C6D6E6E6C
696665686C72777B7B7A7877767268543E303657
89B8CEBF956540343D4E606B7074787C7F807D79736E69666565676A6F74767673706E6D
6D6E6F6F6F6F6E6C6A69696B6F727473706D6A6868696B6F747778746E68626061646A73
7C83847B6D5E575A65727B7C766F6A6A6D717474716F6D6D6E6F6F6D6B6A696A6C6E6E6C
696665676C72787B7C7B7977767267543E303658
8BB9CFC095643F343D50626C7174777B7E7F7D79736E6965636163676C717473706C6A6A
6C6F7171706F6D6C6B6A6B6C6F717372706E6B6A69696B6E717475736F6B676564656970
798080796C605A5E6A767E7D766D6766696D7071706E6D6D6E6F6F6D6A6867696C6E6F6D
696664676C72787B7C7B7978767267543F303759
8BBAD0C096643F333E50626D7174767A7D7E7C78736E6964616061656A7073726E6A6768
6C6F7273716F6E6C6B6B6C6D6F717272706E6C6B6A6A6B6D6F7172716F6D6A6967676A6F
757B7C766C625E636E79807E766C6563666A6D6E6E6D6D6D6F6F6F6D6A6867696C6F706E
6A6664666C72787B7D7B7A78767267543F31375A
8CBAD1C196643E333D50626D7174777A7D7D7A76716C6864626162666B7072716E6A6768
6C6F727372706F6D6C6C6C6D6F717272706F6D6C6C6C6C6D6F7070706F6E6D6C6B6B6C6F
737575716A646268727B807D746A636163676B6D6D6C6C6D6F706F6D6B68686A6D70716F
6A6664666C72787C7D7C7A78767267543E30375A
8BBAD1C196643E323C4E606C7175797C7D7C78746F6A6764636465696D7173726F6C696A
6C6F71727271706F6D6C6C6D6F727373716F6D6C6C6D6D6E6F6F706F6F6E6E6E6F707070
70706E6B6765666C747C7F7B7369615F62666A6B6C6C6C6D6F70706F6C6A6A6B6E71726F
6B6665676C72787C7D7C7A78767267543E303659
8BBAD1C196643E313A4C5F6B72777A7D7D7B77726D69666565676A6D70737473716E6C6C
6D6E7071727372706E6B6B6C6F727474726F6D6C6D6D6E6F6F70706F6E6E6E7073757573
6E6A666464656970777D7F7A7168615F6165696B6C6C6C6E6F7171706E6D6C6E7072726F
6B6765676C72787B7D7B7A78777368543E2F3658
8ABAD1C196643E313A4B5E6A71777B7E7E7B77716C676565676A6D7072747473716F6D6C
6C6D6E70727373716E6B696B6F737575726F6D6C6C6D6E6F7070706F6D6C6D7075797975
6D655F5E61666C737A7E7F7A7168615F6165696B6C6D6D6F70717271707070717273736F
6B6765676C72787B7D7B7A79777368543D2F3558
8AB9D0C196643E323A4C5E6A71767A7D7E7D78726C676465676B6E7173747372716F6D6C
6B6C6D6F717373716D69686A6E737675726F6C6B6B6C6E6F7071716F6C696A6F767C7D77
6C6159595D656D767C80817B736962606165696B6D6E6F7071727272737373747575736F
6B6766676C72777B7C7B7A79777368543D2E3557
8AB9D0C196643F323C4E606B7175787C7F7F7B756E686464676A6E71727372716F6D6B6A
6A6B6C6E717272706B6766696E737675726E6B6A6A6B6D6E7072726E6A66666C757D7F78
6B5E55555A636E777E83847E766C64616265696C6E70727272727273747677777776736F
6B6766686C72777B7C7C7A79777368543D2E3557
8AB9D0C096653F333D4F616B7073767B7F817E7870696463666A6E707171716F6D6B6A69
696A6B6E7071716E6A6665686D727675726E6A69696A6B6E7073726E6863636A747E817A
6C5E545358626C777F868782786E65626265696D7073747473727173757779797876726E
6A6766686C71777B7C7B7A79777368543D2F3557
89B8CFC0966540343E50616B6F72757B8082817A726A646365696C6F7070706F6D6B6A69
696A6B6D6F70706E6A6766686D717474716D6A6968696A6D7174746F68616067737E827C
6E60565458606A757F8789847A6F656263666A6E7274767574717071737677787674716D
6A6766686C71777A7C7B7A79777368543E2F3558
8AB8CFC0966641353E4F606A6F72767C8183817B736A646364686B6E6F7070706F6E6D6C
6B6B6B6C6E6F6F6E6B69686A6D707272706E6C6A69686A6D7276767168605E65717D837F
73665C58595E66717C8689847A6D646062676C707375767573716F6E6F70717271706F6C
696766686C72777A7C7B7A78767267543E303658
8AB8CEC0976742353D4D5E696E73787D8283807A726B656364676A6D6E70717272727170
6E6C6C6C6D6E6F6F6E6D6C6D6E6F6F6F6F6F6E6C6A696A6E7478787269605E64707C8381
796F665F5C5D626C78838883786A615E62686E727576767573706D6A6969696A6B6C6C6A
686666686D72777A7C7B7A78767267533E303758
8AB8CEC0976843353C4B5B676E747A7F82837F79726B66636466696C6E70727475767573
716E6C6C6C6D6E70707171706E6D6C6D6E6F6F6E6C6B6B70757A7B746A615D636E7A8283
7F797168615C5D667380868175675D5C61686F7476777674716D69666362626466696A69
676666686D72777B7C7B7978757166533E303759
8AB7CEC0986943353B4959656D757B8083837F79716A65636365686B6D70727577787876
736F6D6B6C6D6E70727474726F6C6A6A6C6E706F6E6C6D71777C7C756B625D616A757E83
84827C71655A575F6E7C848073655B5A60697176787977746E6963605F5F606365686968
666464676D73787B7C7B7877757166533E303759
89B7CEC1996A44363A4858646C747B8184837F79716A64626265686A6D6F727577797976
73706D6C6C6D6E71737575736F6B69686A6C6E6F6E6E6F73797C7C756B625C5E646D7780
86898679695952596879838073655B5B616971777B7C7A736B625C5A5D6166696B6C6B68
656262656B73797C7C7A7776747166533E303658
88B7CEC19A6A45363A4857626B737A8084848079716963606164676A6C6E717376777775
726F6D6C6C6D6E7173757573706B6867686A6C6D6E6F72767A7C7B746A615B5A5E646E7A
868F8E816C584D536476828074675D5C616971787D807D74675A53555E68717575736E69
645F5F636A737A7D7D7A7675747166533D2F3557
88B7CFC29A6B45363A4857626A71797F8484817A7168615F6164686A6C6E6F7173757573
716E6D6C6C6D6E71737474736F6C69676667686B6E7175787B7C797369615A56575B6574
869395887057494E5F7380807569605E636971798084807463534B515F717E83807A726A
635D5C6069737B7F7E7A7674737167533D2D3356
88B8D0C39B6A44353A4857626A71787F8384817A7067615F6165696B6C6D6E7071737371
6F6D6C6B6C6D6E7072737372706D6967656566696D72777B7D7D79726960595351535D6F
85979C8E7357474A5B707E7F766B6361656A727A82878375604E464E6278898E8A81756B
625C5A5E67727B7F7E7A7674737167533C2D3355
89B9D2C49B6A43343A4959646C73797F838380797068636264676A6C6D6D6D6F70717270
6E6C6B6B6B6C6E7071727272706D6B68656465686E73797D7F7D7972696058514D4E586D
869BA29477594647586C7B7D766C6564676C737B838985755F4C434D637C8E948F84786C
635C5A5E67727B807F7B7775747267533C2D3356
8BBBD3C59A6841333A495B676F757B8083827E78706A6665676A6C6D6D6D6D6E70717170
6D6B6A6A6A6C6E6F71727271706E6C69666465686E747A7E807F7A736A6057504B4B566C
879FA7997B5B46465569777A746D67666A6E747C84898576604C444E647D90959085786D
645D5B5F67727B7F7F7C7876757267533C2D3357
8CBDD5C59A673F31394A5C6971787D8182807B76706C6968696C6E6E6E6D6D6E7071716F
6D6A69696A6B6D6F70717171706F6D6A666565696E757B7F81807C746A61574F4A4A556C
89A2AB9D7F5E474553657477736E6A6A6D70767D84888476614F4751657D8E938E84786E
655F5D6068727A7F807D7A78767368533C2D3458
8DBED6C699653D30384A5D6B73797E80817E7974706C6A6A6B6C6E6E6E6E6D6E6F70706F
6C6A6968696B6C6E6F707171706F6D6A676565696E757B8082817D756B61574E4949546C
8AA4AEA08260494551627075736F6D6D7073777D8286827563534C54677B8A8F8A82776E
66615F6269727A7F807F7C7A787468543D2E3559
8DBED5C598643B2E374A5D6A72787D7F7F7C77726E6B6968696B6C6D6E6E6E6E6F6F6F6E
6C6B6A69696A6B6C6E6F7070706F6D69666464686E757B8083827E766C61574D4748536C
8BA6B0A385634A454F5F6D73727170717475787C80827E736457525968798689857E756D
676261646B737B8081807E7C7A766A553E2E3559
8CBDD5C497623A2D36495C6970767A7D7D7B76716C68666566686A6C6D6E6F6F6F6E6D6D
6C6C6B6A6A69696A6C6D6F6F6F6E6C68656363676D747B8183837F776C61574D4646526B
8AA6B1A487654C464E5C6970727374757778787A7C7C7970655C585E6A778183807A726C
676463676D747B8082817F7D7B776B563E2E3558
8BBCD3C396623A2C35485B676E74787B7C7A76716B6663626265676A6D6F70706F6D6C6C
6C6D6D6C6A6969696B6D6E6F6E6D6B68646262666C737A8083837F776D62574D4645516A
8AA6B2A588674E464C59666E727577797A7A79787877746E66605E636B747B7D7A75706B
676565686E757C8082817F7E7C786C573F2E3457
8BBCD3C296613A2D36485B676D72777A7C7B77716B6561606063666A6D7071716F6D6C6C
6D6E6F6E6C6A696A6C6D6F6F6E6D6A67646263666C72797F82837F776D62574D46455069
89A5B1A68A694F464B56626B71767A7C7C7B787674726F6B666362666C72767775716D6A
676666696E757A7F81807F7E7C776B563E2E3457
8CBCD3C296623A2D374A5C686E72777A7D7D79736C6662606163676A6E707271706E6C6C
6E7070706F6D6C6D6E6F70706E6D6A68656464676C71777D80817E776D63584E4746516A
89A5B1A68B6A514649525D676E757B7E7E7C7875726F6C69666465676B6F7272716F6C69
676667696D72787C7F7F7E7C797468533D2E3458
8DBDD3C396623B2F394C5F6B7074787C7F7F7C766F6964626366696C6F717272716F6E6E
6F70717271717071727272716F6D6B69676666686C70757A7E7F7D766D63594F4847526A
89A4B1A68C6C5247474E58626B747B7E7F7C7874706D6A67656465676A6D6F706F6D6B69
676666686B6F73787C7D7C7A767064503A2D3559
8EBED4C497643D313C4F636E7376797D81827F7A736C676666686B6E7072737372706F6F
707172737374747575757472706E6C6A6968696A6C6F73777C7D7C766D645A504A49536B
89A4B0A68D6E5447454A535D67727A7F7F7C78736F6C696664636466696C6E6F6E6D6B69
67666666686B7075797B7A78736C5F4C382C355A
8EBED5C599663F343E52657075787B7F8384827D766F6A68696A6D707274747473727070
717273747475767676767574726F6D6C6B6B6B6C6D6F72777B7D7B766E655C524B4A546B
88A2AFA68E70574844474F596470797E7E7B77726F6B686563626264676B6D6E6E6D6C6A
6766656566696D727678787570685B48352B355A
8DBDD5C69B6943374153667176797D818586847E78716C6A6A6B6E717375777675737171
71727373747474757676767573706E6D6C6C6C6D6E7073787C7E7D7870685E544D4B546A
87A1AEA68F73594A45454C55616E787D7D7A76716E6A67646260616366696C6E6E6E6C6A
6765646465686C71757676736D66594634293358
8BBCD4C69D6C463942536570767A7F838787857F78726D6A6A6B6D717477797876737171
71727373717070717375767573716F6D6C6C6D6E7072767A7E807F7A736B61564E4B5368
859FADA691755D4D46454A535F6D777C7D7975716D6A66636160606266696C6E6F6E6D6A
6765636466696D71757574716D66594632273156
89BBD4C79E6E483B4252636E757A7F848888847F78716C6968696C7074787A7A77737170
717272716F6C6C6D7073757574716F6D6C6C6D6E7174787D8082817C756D63584E4A5267
839EABA69278604F474549525E6C787D7D7974706D6A6663615F606266696C6F6F6F6E6B
67646364676B6F73767574716D675B4732262F54
88BAD4C79F6E483A404F5F6B72797F848787847E77706B6766676A6E73787B7A7773706F
7071716F6C6A696B6E71747473716E6D6B6B6C6E7175797E8283817D756D63574E4A5166
829CAAA6937A6351484548515F6E7A7F7F7A75706D6A676461606164676B6E7172716F6C
68656365686D727678777573706B5E4A34262D52
88BBD5C89E6D46373D4B5B676F767D828686827D756E68656364666B7176797976726F6E
6E6F6F6D6B6A696B6E717272716F6D6B6A6A6B6D7074797D8182807B746B61564C485065
819BAAA6947D65534944475261728085837D76716E6B6866636364676B6F72747574726E
696564656A7075797B7B7977746F634D36262D52
89BCD6C89D6A4232374656626A72797F8384807B736C65615F6062676D73767774716D6C
6B6B6C6B6B6B6B6D6F7071706E6C6A6868686A6C6F73777B7F7F7D7870675D524A474F64
809AA9A6957E6754484346526578878C888078726F6C6A686666686B6F73777979787571
6B6765666B72787D807F7E7D7A75695239282E53
8ABDD7C89B663C2C3140515D656D757C80817E787068625D5B5C5E63696F7374726F6B69
686868696B6C6E6F70706F6D6B6867666667686B6D7074787B7C7A746C63594F47454D63
7F99A8A69680685548414553687E8F948F857B74706E6C6A69696C6F74787B7D7D7C7873
6D6866686D747B8184858483817C6E573D2B3054
8DBFD8C8996237262B3A4B58616A72797E7F7B756D655E5957585B60666C70716F6D6967
666566676A6D6F70706F6D6A68656362636467696B6E7276797A77716960554B44434C62
7E98A8A697816955474044536B83959A958A7E76726F6D6C6B6C6F73777B7E80807E7A74
6D6866686E767E84888989898781745C412E3357
90C2D9C7985F3321253446545E6770787C7D79726A625B565455585D646A6E6F6E6B6865
64636466686B6D6F6F6E6B696562605F606265676A6D707477787670675E544A42414A60
7D97A7A697816A55473F43536C86999F998E827974706D6B6B6C7074797C7F81807E7A74
6D6765686E7780878B8D8D8D8B8578604533375B
94C5DBC8975E301E223142515D6871797C7C7770686059555354575D636A6E6F6D6A6764
6363646567696B6C6D6D6B6864605E5D5E616466696C707477787670685E54494240495F
7B96A6A597826A56473E41526B869AA19C92867C756F6B69696B6F73787B7E7F7F7D7872
6B6563666E7781888D8F8F8E8C87796248363B5F
96C7DDCA985E301D202F42515E6A747B7E7C777068605A555455585E646B6F6F6D6A6765
646565666768696B6C6C6B6864605E5D5E606366696C7074787977716960564B4341495E
7A94A4A497826C56463D3F4F688398A09C93877D756D686666686C7175797B7C7C7A756F
686361656D7680888C8E8D8C8A85786148373D61
96C8DFCC9A60311E21304353616D777D7F7C766F68615B5856575A5F666C70706E6B6766
65656666666768696B6C6C6965625F5E5F6164676A6D7175787977726B62594E45424A5E
7992A2A397846D58463B3B4B647F959D9B92877D746D676464676B6F737678797977736D
676261656C767F868A8B8B898781745D44343A5F
91C6E0CE9C6233202434475764707A7F7F7B756E68635E5B59595B61676D71716F6C6967
66656566666668696B6C6C6A67646160616264676A6E7175777775716B645C5249454B5E
778F9FA19786705A463837455F7B929B988F847B736D686565686B6F737577787876736E
696564676E767E8487878785837E70583D2B3158
8AC3E0D09F65372429394D5C68737C7F7F7A746E6966635F5D5C5E62686D7172706D6A68
666565656667696A6C6C6C6B69676564646466686B6F7274757573706C675F564D494D5E
758C9B9F9788745C463532405A778E97948B8078726E6A68686A6D707275767777767470
6C68686A6F767D81838281807E796B513420254E
83BFDFD1A2693C2B314154646F787F81807A746F6D6B6865626061656A6F737473706D6A
68666666686A6C6D6E6E6E6D6C6C6A696868686A6D7173757573716F6D69645B534E5260
7589979B978B786047342E3B557289918E857A74706D6B6A6A6B6D6F7173747576757471
6E6C6B6D71757A7D7D7B79787773654A2B151A44
80BFE2D6A97246363E4F62717A83888A87827C78767574716D6A696C7175797A79777572
6F6E6D6D6F71737474747474747373716F6E6E707376797979777473716F6A635C595C67
77879398968E7D654B352C364E697E86837B726C6A686765656567686A6C6D6E6F706F6D
6B6A696B6E717474736F6C6A6965573D1F0B133F
84C5E9DFB47F5648506276848D94999A97928D89888886827E7A787A7E8285868583817F
7E7C7B7B7C7E7F8080808080807F7E7C7A79797A7D80838382807E7B7977736F6A696B73
7D8890969691836C50382C32445B6D74736C66615E5C5A585758595B5C5E606263646463
6160606265676968645D5754514D412B12041140
8CCCF0E8BF8D665A64778A98A0A7ABACAAA6A19E9C9B99958F8B88898C90929392918F8E
8E8D8D8C8C8C8C8D8E8E8E8E8D8C8A8886848486888B8E8E8E8C8986837F7D7A797A7D80
85898E9295938873583F2F303B4C5A61615E5A56524E4A474647484A4C4E515355565756
54535356595C5D5A544B433C37332A1908021447
92CFF2EAC5967267718497A5ACB2B6B8B6B3AEABA9A8A5A19B96939396999B9C9B999898
9999999897969596979798979594918F8D8B8B8D909295969594918D8985828284888A8B
8A89898D92928B786047373238434D535555534F4A443E3B3A3B3D3F414446494B4D4D4C
4A49494C505455514A40362E28241C1107071D50
93C8E5DDBB906F656F80929EA5ABAFB0B0ADA9A6A4A29F9A95918F8F9194969796959494
95969696949392929393939291908E8C8A8888898C8E909292918F8B86817F8084898C8A
868281848A8D897B6753443F41474E54575958554E47413E3D3E404245474A4C4E4F504F
4D4C4C4F525556534C443B3632302B2119192D5A
8BB3C7BD9D775A505765747F858A8E908F8D8A8784827F7C797776787A7D7F807F7E7E7E
7E7F7F7F7F7F7F7E7D7C7C7C7C7C7C7A79777777797B7D7F80807E7A76727072767A7D7B
777372767C81817A6E625957595E64696D6F6E6B655E5956555557595B5E606262636262
62616162636464635F5C5A5B5E615D52443B4361
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{554, 263.75},
  ImageMargins->{{42, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008Z00011a000`40O003h00Oogooogoo;7oo003o
OoooOol/Ool00?mooomoobaoo`00ogooogoo;7oo003oOoooOol/Ool00?mooomoobaoo`00ogooogoo
;7oo000XOol2000LOol40003Ool2000JOol30002Ool2000IOol30004Ool2000IOol20004Ool2000F
Ool50002Ool20004Ool2000COol500000goo000000020003Ool20012Ool2000KOol40003Ool2000K
Ool30002Ool2000HOol30004Ool2000JOol20004Ool2000EOol50002Ool20004Ool2000COol50000
0goo000000020003Ool2000MOol002Moo`04001oogoo000KOol00`00Oomoo`03Ool01000Oomoo`00
6Woo00@007ooOol0009oo`03001oogoo01Ioo`04001oogoo0002Ool01000Oomoo`005goo00@007oo
Ool0009oo`04001oogoo000GOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo019o
o`05001oogooOol00005Ool01000Oomoo`00@7oo00@007ooOol001Yoo`03001oogoo00=oo`04001o
ogoo000KOol01000Oomoo`000Woo00<007ooOol05Goo00@007ooOol0009oo`04001oogoo000HOol0
1000Oomoo`000Woo00@007ooOol001Ioo`05001oogooOol00002Ool01000Oomoo`000Woo00<007oo
Ool04Woo00D007ooOomoo`0000Eoo`04001oogoo000LOol002Moo`04001oogoo000LOol00`00Oomo
o`02Ool01000Oomoo`005goo1@0000Eoo`00Oomoo`0001Qoo`04001oogoo0002Ool01000Oomoo`00
5goo00@007ooOol0009oo`04001oogoo000GOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03
001oogoo019oo`03001oogoo009oo`03001oogoo009oo`04001oogoo0010Ool01000Oomoo`006goo
00<007ooOol00Woo00@007ooOol001Qoo`D00005Ool007ooOol0000GOol01000Oomoo`000Woo00@0
07ooOol001Qoo`04001oogoo0002Ool01000Oomoo`005Woo00D007ooOomoo`00009oo`04001oogoo
0002Ool00`00Oomoo`0BOol00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0077oo000WOol0
1000Oomoo`007Goo00D007ooOomoo`00009oo`03001oogoo01Eoo`04001oogoo0002Ool01000Oomo
o`0067oo0`000goo00@007ooOol001Qoo`8000=oo`04001oogoo000GOol01@00Oomoogoo00000Woo
00@007ooOol0009oo`03001oogoo019oo`03001oogoo00=oo`05001oogooOol00002Ool00`00Oomo
o`0nOol01000Oomoo`0077oo00D007ooOomoo`00009oo`03001oogoo01Ioo`04001oogoo0002Ool0
1000Oomoo`005goo0`000goo00@007ooOol001Uoo`8000=oo`04001oogoo000FOol01@00Oomoogoo
00000Woo00@007ooOol0009oo`03001oogoo019oo`03001oogoo00=oo`05001oogooOol00002Ool0
0`00Oomoo`0JOol002Moo`04001oogoo000KOol01000Oomoo`000Woo00@007ooOol001Qoo`03001o
o`00009oo`04001oogoo000IOol00`00Oomoo`02Ool01000Oomoo`005goo00@007ooOol0009oo`04
001oogoo000GOol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo019oo`05001oogoo
Ool00002Ool01000Oomoo`000Woo00<007ooOol0?Woo00@007ooOol001Yoo`04001oogoo0002Ool0
1000Oomoo`006Goo00<007oo00000Woo00@007ooOol001Qoo`03001oogoo009oo`04001oogoo000H
Ool01000Oomoo`000Woo00@007ooOol001Ioo`05001oogooOol00002Ool01000Oomoo`000Woo00<0
07ooOol04Woo00D007ooOomoo`00009oo`04001oogoo0002Ool00`00Oomoo`0JOol002Qoo`8001eo
o`8000Aoo`8001Yoo`8000=oo`8001Yoo`<000=oo`8001Uoo`8000Aoo`8001Moo`8000Aoo`8000Ao
o`8001Aoo`8000Aoo`8000Aoo`80049oo`8001aoo`8000Aoo`8001]oo`8000=oo`8001Uoo`<000=o
o`8001Yoo`8000Aoo`8001Ioo`8000Aoo`8000Aoo`8001Aoo`8000Aoo`8000Aoo`8001eoo`00ogoo
ogoo;7oo003oOoooOol/Ool00?mooomoobaoo`00ogooogoo;7oo003oOoooOol/Ool002Eoon0003=o
on00019oo`009Goo00D007ooOomoo`0000Qoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo
00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo
00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`8003=oo`03001oogoo009oo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03
001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Ioo`03001oogoo00Eoo`03001oogoo00Ioo`03
001oogoo011oo`007Woo0P001Goo00<007ooOol0g7oo00<007ooOol0:goo0P0017oo00<007ooOol0
g7oo00<007ooOol047oo000MOol01000Oomoo`0017oo00<007ooOol0g7oo00<007ooOol0:Woo00@0
07ooOol000=oo`03001oogoo0=aoo`03001oogoo011oo`007Goo00@007ooOol000Aoo`<00=]oo`80
02aoo`04001oogoo0003Ool3003KOol2000BOol001eoo`04001oogoo0004Ool01000Oomoogoo0SF]
00<mkdHaAS400TYB00=BU5JeE[D00U[F25kg3e[F15kg1U[F1EJe?e:D2dic1DYB0THa0d8@0Sg_0SW>
00<e[C6<<H`00Re[00<YBRDY9BT02BDY<2U:1BDY12U:00<]Jc6<<H`017oo00<007ooOol0:Woo00@0
07ooOol000=oo`03001oogoo009oo`8mk`03BU9>Ldic009:DP03>LhYBRU:008Li`<HaP8Li`039BTY
BRU:008YBP<]J`<aS0D]J`hYBQH]J`DaS0P]J`LaS0H]J``aS0P]J``aS08e[@/icP8mk`=240U6<@=2
40`mk`M240Dmk`E240Xmk`=2409:DP03CW=BU5:D009BU003BU8mkcg_008aS003;F/aS36<00Aoo`03
001oogoo011oo`007Goo00@007ooOol000Aoo`04001oogooOol2=Jd00cg_AS56<@02BU800e:DE[EF
]@02F]H8G_L?F]H4G_L6F]H5E[DoDY@;CW<5BU82AS43@Q02?Nl2>Lh00cF]<H`aS002;F/00bU:9BTU
:@099BT`:DX59BT4:DX00be[<H`aS004Ool00`00Oomoo`0ZOol01000Oomoo`000goo00<007ooOol0
0Woo0Sg_00=:DTicCW<00TYB00<icRU::DX00QcW0aS60QcW00<U:BU::DX00RU:0be[0c6<1Be[3RU:
5Re[1C6<22e[1c6<1Re[336<22e[336<0SF]2cW>0Sg_0d8@2DHa0d8@33g_1d8@1Cg_1D8@2Sg_0d8@
0TYB00=>Le:DDY@00U:D00=:DSg_?Nl00S6<00<]Jc6<<H`017oo00<007ooOol047oo000NOol20005
Ool01000Oomoogoo0SF]00<icSg_?Nl00THa00=:DU:DDY@00eJe15[F1EJe35:D1UJe1e:D@4ic4DYB
0dHa0d8@0Sg_0cW>0SF]0S6<3Be[3S6<0be[5S6<1Be[1bU:0bDY0bU:0Re[17oo00<007ooOol0:goo
0P0017oo00<007ooOol00Woo0SW>0cg_0SF]00<U:AS66<H00PaS0`Q20`aS0Q240aBU2AS62aBU11S6
1AcW1B482QcW22481AcW12481BDY2R482bDY124822DY1BU:0Re[00<aS3F]=Jd00SF]00<icSg_?Nl0
0T8@00=6<DYBBU800e:D1EJe1E:D3Tic0e:D3dic1dYB0Tic00=BU5[FF]H00V<H00=[FW>LLi`00W>L
00=W>EJeE[D00T8@0cF]17oo00<007ooOol047oo000UOol01000Oomoogoo0S6<00<e[CW>>Lh00T8@
00=6<DYBBU800Tic1U:D14ic2TYB2Tic24YB1dHa=TYB54Ha1D8@0Sg_0cW>1CF]1C6<6cF]3cW>13F]
0c6<0be[12U:1BDY0bU:17oo00<007ooOol0<Goo00<007ooOol00Woo1CF]0Re[00<Lia2448@00P@Q
1@0000<48@Q224800PQ21@aS00<@Q0aS36<00`aS1`Q20`aS11240aBU2AS621BU21S61ABU0QS651cW
1b4821cW1B480bDY12U:00<]Jc6<<H`00SF]00<icT8@@Q000THa00=>Le:DDY@00e[F15kg1E[F35Je
1U[F15Je2e:D1Dic0U:D0UJe00=NmfLiIcT00W>L00=kgWooOol00Woo00=cW5kgG_L00TYB00<icS6<
<H`017oo00<007ooOol047oo000UOol01000Oomoogoo0S6<00<e[CW>>Lh00T8@00=6<DYBBU800Tic
1U:D14ic2TYB2Tic24YB1dHa=TYB54Ha1D8@0Sg_0cW>1CF]1C6<6cF]3cW>13F]0c6<0be[12U:1BDY
0bU:17oo00<007ooOol0<Goo00<007ooOol00Woo1CF]0Re[00<Lia2448@00P@Q1@0000<48@Q22480
0PQ21@aS00<@Q0aS36<00`aS1`Q20`aS11240aBU2AS621BU21S61ABU0QS651cW1b4821cW1B480bDY
12U:00<]Jc6<<H`00SF]00<icT8@@Q000THa00=>Le:DDY@00e[F15kg1E[F35Je1U[F15Je2e:D1Dic
0U:D0UJe00=NmfLiIcT00W>L00=kgWooOol00Woo00=cW5kgG_L00TYB00<icS6<<H`017oo00<007oo
Ool047oo000UOol01000Oomoogoo0Re[00<aS3F]=Jd00Sg_00=244HaAS400dYB0Tic1DYB14Ha1T8@
3dHa3d8@3THa248@7DHa348@24Ha1d8@0cg_33W>2Sg_33W>1Cg_2d8@13g_0SW>0cF]0S6<00<]JbU:
:DX00RU:1RDY0RU:17oo00<007ooOol0<Goo00<007ooOol00Woo0SF]0cW>0S6<00<U:ABU5:D00PQ2
1@@Q00<8@PaS36<00a242ABU2Q2400<DYAS66<H00QS631cW21S61acW1QS60QcW22482AcW0b481bDY
22481BDY1BU:0be[0S6<0SF]00<icSg_?Nl00THa00=:DTicCW<00U:D1UJe15:D1Dic1E:D2UJe0U:D
0dic0dYB1DHa14YB00=>LeJeE[D00U[F00=S66LiIcT00Vmk0g>L0Vmk00=S65:DDY@00T8@00<e[C6<
<H`017oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<aS3F]=Jd00Sg_00=244HaAS400dYB
0Tic1DYB14Ha1T8@3dHa3d8@3THa248@7DHa348@24Ha1d8@0cg_33W>2Sg_33W>1Cg_2d8@13g_0SW>
0cF]0S6<00<]JbU::DX00RU:1RDY0RU:17oo00<007ooOol0<Goo00<007ooOol00Woo0SF]0cW>0S6<
00<U:ABU5:D00PQ21@@Q00<8@PaS36<00a242ABU2Q2400<DYAS66<H00QS631cW21S61acW1QS60QcW
22482AcW0b481bDY22481BDY1BU:0be[0S6<0SF]00<icSg_?Nl00THa00=:DTicCW<00U:D1UJe15:D
1Dic1E:D2UJe0U:D0dic0dYB1DHa14YB00=>LeJeE[D00U[F00=S66LiIcT00Vmk0g>L0Vmk00=S65:D
DY@00T8@00<e[C6<<H`017oo00<007ooOol047oo000UOol01000Oomoogoo0RU:00<]Jc6<<H`00SW>
00<mkd8@@Q0024Ha148@3cg_0d8@5Sg_2T8@2Sg_?D8@0cg_4d8@2Sg_0d8@0dHa2DYB0dHa0T8@0Sg_
00<icSF]=Jd00S6<00<]JbU::DX00bDY1B480RDY17oo00<007ooOol0<Goo00<007ooOol00Woo0SW>
00=6<DYBBU800T8@00<e[BDY9BT00QS600<@Q1BU5:D00QBU00<Lib488@P00R4800<U:BU::DX01BU:
3BDY12U:2Re[1BU:1BDY1bU:1RDY0RU:1be[2RU:0be[1C6<0Re[1RU:12e[3C6<0cF]0SW>0Sg_00=2
44HaAS400THa0dYB0dHa1D8@13g_0d8@0THa2TYB0dHa0T8@0SW>00<e[C6<<H`00c6<0SW>0T8@00=:
DU:DDY@00UJe1U[F0UJe0Tic00=243F]=Jd00Re[00<YBRe[;F/017oo00<007ooOol047oo000UOol2
0002Ool29BT00bU:;F/]J`02=Jd00cW>?Nlmk`08@Q02?Nl4>Lh6=JdN>Li0?Nl?@Q0JAS48@Q03AS44
BU8:CW<00dYBAS56<@02@Q02?Nl00cW>=Jde[@02<H`00be[:DXYBP029BT38@P37>L28@P3Ool2000c
Ool20003Ool2?Nl00e:DF]IJeP02E[D00dHa=Jde[@02:DX00b489BTU:@02:DX00c6<=Jde[@02>Lh;
?Nl:>Lh<?Nl7>LhB=Jd9>Lh:=Jd3>Lh5?Nl2>Lh00cF]<H`aS003=Jd2>Lh5?Nl7>LhE=Jd4<H`6;F/2
<H`2=Jd2>Lh5?Nl5>Lh00cF]<H`aS002:DX00b487>LLi`026<H00b48:DXYBP02=Jd00d8@BU9:DP03
CW<2BU82@Q000cW><H`aS0029BT00acW5:DDY@025:D00acW:DXYBP04Ool00`00Oomoo`0@Ool002Eo
o`04001oogooOol29BT00bU:;F/]J`02=Jd00cW>?Nlmk`08@Q02?Nl4>Lh6=JdN>Li0?Nl?@Q0JAS48
@Q03AS44BU8:CW<00dYBAS56<@02@Q02?Nl00cW>=Jde[@02<H`00be[:DXYBP029BT38@P37>L28@P4
Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2?Nl00e:DF]IJeP02E[D00dHa=Jde[@02:DX00b489BTU
:@02:DX00c6<=Jde[@02>Lh;?Nl:>Lh<?Nl7>LhB=Jd9>Lh:=Jd3>Lh5?Nl2>Lh00cF]<H`aS003=Jd2
>Lh5?Nl7>LhE=Jd4<H`6;F/2<H`2=Jd2>Lh5?Nl5>Lh00cF]<H`aS002:DX00b487>LLi`026<H00b48
:DXYBP02=Jd00d8@BU9:DP03CW<2BU82@Q000cW><H`aS0029BT00acW5:DDY@025:D00acW:DXYBP04
Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P00bDY;F/]J`02<H`00cF]>LhicP08?Nl4>Lh3
=Jd5<H`7=Jd7>Lh;=JdP>LhY?Nl6@Q0:AS4EBU8:AS400dYBCW=>L`02CW<8DY@2CW<00dYBAS56<@02
@Q02?Nl00cW>=Jde[@02;F/00bU:9BTU:@038@P77>L4Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2
AS400e[FJeY[FP02IcT00eJeAS56<@02=Jd3<H`2>Lh00d8@AS56<@02BU800dicDYABU005DY@5CW<D
BU8<AS4<@Q08AS43@Q07?Nl3@Q02AS43BU82AS42@Q000cg_>LhicP03?Nl2@Q05AS43@Q04?Nl3>Lh2
=Jd00c6<;F/]J`02;F/::DX39BT88@P29BT2:DX2;F/5<H`5;F/00bU:9BTU:@027>L00aBU48@@Q002
48@00aS68@PQ2002<H`00cW>@Q124002@Q000cg_>LhicP02;F/00b485:DDY@0224800`@Q00000002
12400aBU:DXYBP04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P00bDY;F/]J`02<H`00cF]
>LhicP08?Nl4>Lh3=Jd5<H`7=Jd7>Lh;=JdP>LhY?Nl6@Q0:AS4EBU8:AS400dYBCW=>L`02CW<8DY@2
CW<00dYBAS56<@02@Q02?Nl00cW>=Jde[@02;F/00bU:9BTU:@038@P77>L4Ool00`00Oomoo`0aOol0
0`00Oomoo`02Ool2AS400e[FJeY[FP02IcT00eJeAS56<@02=Jd3<H`2>Lh00d8@AS56<@02BU800dic
DYABU005DY@5CW<DBU8<AS4<@Q08AS43@Q07?Nl3@Q02AS43BU82AS42@Q000cg_>LhicP03?Nl2@Q05
AS43@Q04?Nl3>Lh2=Jd00c6<;F/]J`02;F/::DX39BT88@P29BT2:DX2;F/5<H`5;F/00bU:9BTU:@02
7>L00aBU48@@Q00248@00aS68@PQ2002<H`00cW>@Q124002@Q000cg_>LhicP02;F/00b485:DDY@02
24800`@Q0000000212400aBU:DXYBP04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P00bDY
:DXYBP02<H`00cF]>LhicP07?Nl3>Lh4=Jd8<H`K=JdP>Lh8?NlC>Lh:?Nl6@Q05AS4:BU89CW<ABU83
CW<8DY@4CW<00dYBAS56<@02?Nl2>Lh00cF]<H`aS002:DX00bDY8@PQ20028@P00acW6<HHaP026<H3
7>L4Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgKg]_N`02JeX00e[FBU9:DP02>Lh00cF]
>LhicP02@Q000dYBCW=>L`02DY@:E[D5DY@BCW<<BU8:AS4:BU85AS45@Q03AS47BU82AS400d8@?Nlm
k`02?Nl00d8@AS56<@03BU84AS43@Q03?Nl2>Lh2=Jd00c6<;F/]J`03:DX59BT98@P57>L00b489BTU
:@029BT2:DX3;F/3:DX49BT00b487>LLi`027>L56<H00b48:DXYBP02;F/5=Jd00be[9BTU:@027>L0
0a242488@P05000212400aBU;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P00bDY
;F/]J`02<H`00cF]>LhicP07?Nl3>Lh4=Jd8<H`7=JdG>Lh:=JdC>Lh8?NlA>Lh<?Nl5@Q06AS47BU8:
CW<?BU87CW<5DY@3CW<2BU82AS400d8@?Nlmk`02>Lh2=Jd00be[:DXYBP029BT00b487>LLi`027>L6
6<H27>L4Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2BU800ekgJeY[FP02IcT00e[FAS56<@02>Lh0
0cF]>LhicP02@Q000dHaCW=>L`02CW<3DY@5E[D3DY@4CW<NBU83AS44@Q03AS47BU86AS45@Q0<AS42
@Q05?Nl3@Q05AS43@Q05?Nl2>Lh2=Jd3<H`2;F/3:DX<9BT38@P39BT6:DX00be[:DXYBP03:DX29BT2
8@P37>L28@P00bDY:DXYBP02;F/00c6<=Jde[@02=Jd00c6<;F/]J`02:DX00b486<HHaP025:D348@7
36<00aS6;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P00bDY;F/]J`02<H`00cF]
>LhicP07?Nl3>Lh4=Jd8<H`7=JdG>Lh:=JdC>Lh8?NlA>Lh<?Nl5@Q06AS47BU8:CW<?BU87CW<5DY@3
CW<2BU82AS400d8@?Nlmk`02>Lh2=Jd00be[:DXYBP029BT00b487>LLi`027>L66<H27>L4Ool00`00
Oomoo`0aOol00`00Oomoo`02Ool2BU800ekgJeY[FP02IcT00e[FAS56<@02>Lh00cF]>LhicP02@Q00
0dHaCW=>L`02CW<3DY@5E[D3DY@4CW<NBU83AS44@Q03AS47BU86AS45@Q0<AS42@Q05?Nl3@Q05AS43
@Q05?Nl2>Lh2=Jd3<H`2;F/3:DX<9BT38@P39BT6:DX00be[:DXYBP03:DX29BT28@P37>L28@P00bDY
:DXYBP02;F/00c6<=Jde[@02=Jd00c6<;F/]J`02:DX00b486<HHaP025:D348@736<00aS6;F/]J`04
Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P00bDY;F/]J`02<H`00cF]>LhicP08?Nl2>Lh5
=Jd5<H`5=Jdc>LhB?Nl5>LhA?Nl7@Q05AS48BU82CW<BBU8ACW<3BU82AS42@Q000cW>=Jde[@02<H`2
;F/00bU:8@PQ20028@P00acW6<HHaP026<H35:D36<H27>L4Ool00`00Oomoo`0aOol00`00Oomoo`02
Ool2BU800ekgIcUW>@02HaP00e:D@Q124002=Jd00c6<=Jde[@02>Lh00d8@AS56<@05BU87CW<00dYB
AS56<@02AS4F@Q08AS42@Q05?Nl00d8@AS56<@07AS4E@Q04?Nl5>Lh3?Nl3@Q07?Nl5>Lh3=Jd4<H`3
;F/::DXC;F/00bU:9BTU:@028@P00acW8@PQ2002:DX00cF]?Nlmk`03AS42@Q02>Lh00c6<9BTU:@02
7>L00aBU48@@Q00248@00aBU7>LLi`077>L00b48<H`aS004Ool00`00Oomoo`0@Ool002Eoo`80009o
o`8Q20039BT]Jbe[008aS003=JdicSW>00Pmk`8icPDe[@DaS0De[C<icQ8mk`DicQ4mk`M240E6<@Q:
DP9>La9:DQ5>L`=:DP96<@924003>Lhe[CF]008aS08]J`03:DXQ2248008Q20037>LHaQS6008HaP<D
Y@<HaP8Li`=oo`8003=oo`8000=oo`9:DP03G_MW>FLi009S6003DYA2448@008e[@03<H`e[CF]008i
cP03@Q16<DHa00E:DPM>L`03BU96<DHa0096<AI240Q6<@9240Dmk`03@Q16<DHa00M6<AE240@mk`Di
cP<mk`=240Lmk`DicP<e[@@aS0<]J`XYBQ<]J`03:DXU:BDY008Q20037>LQ2248008YBP03=Jdmkcg_
00=6<@92408icP03<H`U:BDY008Li`035:D@Q124008@Q0035:DLiacW00LLi`038@PaS36<00Aoo`03
001oogoo011oo`009Goo00@007ooOomoo`8U:@03:DX]Jbe[008e[@03>Lhmkcg_00M240<mk`@icPPe
[@DicQ@mkaHicRPmk`i240E6<A9:DP96<@Q:DPi>L`03BU96<DHa0096<@03@Q0mkcg_008e[@03<H`]
Jbe[008YBP8U:@<Li`8HaPXDY@036<HLiacW00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03
F]IS66<H009JeP03CW<mkcg_008aS003;F/aS36<008e[@03?Nm2448@00=240U6<@03@Q0mkcg_00<i
cP`e[@LicP<mk`M2408mk`DicP03?Nm2448@00E241Hmk`HicP8e[AHicPDe[@<aS0L]J`<aS0Xe[@@a
S0D]J`<YBP<U:@8YBP8e[@03@Q1>Ldic00=BU09:DP8mk`03;F/U:BDY008HaP<DY@8HaP038@PYBRU:
00<]J`8YBP8U:@03:DXe[CF]00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8U:@03:DXaS36<
008e[@03?Nm2448@009240=6<@=240@mk`XicPDmka5240Pmk``icP`mk`]2410mka9240Q6<@a:DPa6
<@=:DPY>L`A:DP03AS52448@008mk`03>LhaS36<008]J`03:DXQ2248008Li`8HaP<DY@P@Q0@DY@03
6<HQ224800Aoo`03001oogoo035oo`03001oogoo009oo`96<@03E[ENmekg009JeP03BU8icSW>008]
J`03:DX]Jbe[008aS0<icP<mk`U24003?NlicSW>008e[@laS0De[@<icPLmk`PicPLmkaHicP/e[@Di
cPLe[@PicPDe[@LaS0De[@<icP@mk`<icP8e[@8aS0<]J`DYBP8]J`03<H`icSW>00924003BU9>Ldic
009BU003CW=6<DHa008icP03;F/U:BDY008Q20<Li`8U:@03;F/e[CF]008icP03=Jd]Jbe[00<YBP8e
[@Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8U:@03:DXaS36<008e[@03?Nm2448@009240=6
<@=240@mk`XicPDmka5240Pmk``icP`mk`]2410mka9240Q6<@a:DPa6<@=:DPY>L`A:DP03AS52448@
008mk`03>LhaS36<008]J`03:DXQ2248008Li`8HaP<DY@P@Q0@DY@036<HQ224800Aoo`03001oogoo
035oo`03001oogoo009oo`96<@03E[ENmekg009JeP03BU8icSW>008]J`03:DX]Jbe[008aS0<icP<m
k`U24003?NlicSW>008e[@laS0De[@<icPLmk`PicPLmkaHicP/e[@DicPLe[@PicPDe[@LaS0De[@<i
cP@mk`<icP8e[@8aS0<]J`DYBP8]J`03<H`icSW>00924003BU9>Ldic009BU003CW=6<DHa008icP03
;F/U:BDY008Q20<Li`8U:@03;F/e[CF]008icP03=Jd]Jbe[00<YBP8e[@Aoo`03001oogoo011oo`00
9Goo00@007ooOomoo`8U:@03;F/aS36<008icP03?Nm2448@00Q6<@A240`mk`E240e6<@M241@mkbY2
41A6<@E:DPM6<@M240=6<@=:DPU>L`=:DP96<@03?NlicSW>008e[@03;F/YBRU:008U:@037>LHaQS6
008DY@8@Q0<<H`D8@P<<H`8@Q08DY@036<HQ224800Aoo`03001oogoo035oo`03001oogoo009oo`92
4003DYAJeU[F009F]@03BU8e[CF]008YBP039BTYBRU:008]J`03=JdicSW>008icPDmk`03@Q0mkcg_
008mk`03>Lhe[CF]008e[@03<H`]Jbe[00P]J`LaS0@e[@<icPDmka4icPXe[@HicQde[@HicPhe[@<i
cP<mk`9240<mk`8icP8e[@8aS003;F/YBRU:008U:@03:DX]Jbe[008e[@03@Q16<DHa00=:DP96<@92
4003?NlicSW>008e[@03<H`]Jbe[00<]J`@aS003>Lhmkcg_008icP03=Jd]Jbe[00<U:@8aS0Aoo`03
001oogoo011oo`009Goo00@007ooOomoo`8U:@03;F/aS36<008icP03?Nm2448@00Q6<@A240`mk`E2
40e6<@M241@mkbY241A6<@E:DPM6<@M240=6<@=:DPU>L`=:DP96<@03?NlicSW>008e[@03;F/YBRU:
008U:@037>LHaQS6008DY@8@Q0<<H`D8@P<<H`8@Q08DY@036<HQ224800Aoo`03001oogoo035oo`03
001oogoo009oo`924003DYAJeU[F009F]@03BU8e[CF]008YBP039BTYBRU:008]J`03=JdicSW>008i
cPDmk`03@Q0mkcg_008mk`03>Lhe[CF]008e[@03<H`]Jbe[00P]J`LaS0@e[@<icPDmka4icPXe[@Hi
cQde[@HicPhe[@<icP<mk`9240<mk`8icP8e[@8aS003;F/YBRU:008U:@03:DX]Jbe[008e[@03@Q16
<DHa00=:DP96<@924003?NlicSW>008e[@03<H`]Jbe[00<]J`@aS003>Lhmkcg_008icP03=Jd]Jbe[
00<U:@8aS0Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8YBP03;F/e[CF]008mk`03@Q16<DHa
00Q:DPA6<@=240@mk`E240I6<@Y:DPM6<@E240Xmk`a240a6<A5242I6<@Y240A6<@=:DPE>L`=:DP92
408mk`03>LhaS36<008]J`039BTQ2248008HaP035:D@Q124008<H`<8@PD48@@8@P0336<@Q124008D
Y@037>LQ224800Aoo`03001oogoo035oo`03001oogoo009oo`924003DYAJeU[F009F]@03AS4e[CF]
008U:@038@PU:BDY008]J`03<H`e[CF]00<icPLmk`<icP8e[@<aS0`]J`DaS0De[@XicPle[@LaS1he
[@<aS0@e[@PicPPe[@DicP@mk`E24003?NlicSW>008e[@8aS003;F/YBRU:008U:@03:DXaS36<0092
4003CW=BU5:D009BU003AS4icSW>008aS0D]J`03<H`e[CF]00<mk`9240=6<@92408mk`03<H`YBRU:
00<Q208]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8YBP03;F/e[CF]008mk`03@Q16<DHa
00Q:DPA6<@=240@mk`E240I6<@Y:DPM6<@E240Xmk`a240a6<A5242I6<@Y240A6<@=:DPE>L`=:DP92
408mk`03>LhaS36<008]J`039BTQ2248008HaP035:D@Q124008<H`<8@PD48@@8@P0336<@Q124008D
Y@037>LQ224800Aoo`03001oogoo035oo`03001oogoo009oo`924003DYAJeU[F009F]@03AS4e[CF]
008U:@038@PU:BDY008]J`03<H`e[CF]00<icPLmk`<icP8e[@<aS0`]J`DaS0De[@XicPle[@LaS1he
[@<aS0@e[@PicPPe[@DicP@mk`E24003?NlicSW>008e[@8aS003;F/YBRU:008U:@03:DXaS36<0092
4003CW=BU5:D009BU003AS4icSW>008aS0D]J`03<H`e[CF]00<mk`9240=6<@92408mk`03<H`YBRU:
00<Q208]J`Aoo`03001oogoo011oo`009Goo0P000Woo0RU:00<aS3W>>Lh00Sg_00=6<DYBBU801dic
0dYB14Ha1T8@1DHa4dYB1DHa4T8@6DHa148@:dHa348@14Ha24YB0dHa0Sg_0SW>00<aS2e[;F/00RDY
00<Q21S66<H00QBU00<<H`Q2248010@Q1P000P@Q0PQ200<<Ha2448@00QBU00<Lib488@P00goo0P00
<goo0P000goo0Sg_00=BU5[FF]H00UJe00=6<C6<<H`00RDY00<Lib488@P00RU:00<]Jc6<<H`00cF]
2CW>00<e[C6<<H`00S6<3be[1C6<5SF]6S6<3cF]1C6<13F]23W>1CF]1cW>0cg_1d8@00<mkcW>>Lh0
0SF]0S6<00<]JbU::DX00RU:00<]JcW>>Lh00THa00=BU5JeE[D00Tic00=2436<<H`00RDY00<Q22DY
9BT00Re[00<e[D8@@Q000TYB00=>Le:DDY@00U:D00=>LdHaAS400Sg_00<aS2DY9BT00acW0RU:17oo
00<007ooOol047oo000UOol01000Oomoogoo0RU:00<aS3W>>Lh00T8@00=6<DYBBU800Tic1E:D0dic
0TYB2THa24YB0Tic34YB24Ha2T8@;dHa1dYB5THa3D8@1DHa1DYB0THa0T8@00<mkcW>>Lh00S6<00<]
JbDY9BT00R4800<HaQBU5:D00PaS00<8@P@Q12402P000P@Q0PQ200<<Ha2448@00QBU00<LibDY9BT0
17oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00UJe00=2436<<H`00R4800<HaQcW
7>L00RDY00<YBRe[;F/00c6<2CF]0c6<0be[1BU:2Re[136<1CF]1c6<1SF]2C6<0be[4S6<3cF]1c6<
1CF]3cW>1Cg_1d8@00<mkcW>>Lh00SF]0c6<13F]00<mkd8@@Q000TYB0dic0T8@00<e[BU::DX00b48
0RU:0S6<00<mkdYBBU800Tic1EJe00=>LdYBBU800Sg_00<aS2DY9BT00acW0RU:17oo00<007ooOol0
47oo000UOol01000Oomoogoo0RU:00<aS3W>>Lh00T8@00=6<DYBBU800Tic1E:D0dic0TYB2THa24YB
0Tic34YB24Ha2T8@;dHa1dYB5THa3D8@1DHa1DYB0THa0T8@00<mkcW>>Lh00S6<00<]JbDY9BT00R48
00<HaQBU5:D00PaS00<8@P@Q12402P000P@Q0PQ200<<Ha2448@00QBU00<LibDY9BT017oo00<007oo
Ool0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00UJe00=2436<<H`00R4800<HaQcW7>L00RDY00<Y
BRe[;F/00c6<2CF]0c6<0be[1BU:2Re[136<1CF]1c6<1SF]2C6<0be[4S6<3cF]1c6<1CF]3cW>1Cg_
1d8@00<mkcW>>Lh00SF]0c6<13F]00<mkd8@@Q000TYB0dic0T8@00<e[BU::DX00b480RU:0S6<00<m
kdYBBU800Tic1EJe00=>LdYBBU800Sg_00<aS2DY9BT00acW0RU:17oo00<007ooOol047oo000UOol0
1000Oomoogoo0Re[00<e[CW>>Lh00T8@00=:DTicCW<025:D14ic0dYB1DHa1dYB1Dic2TYB@4Ha3DYB
4DHa348@3DHa0T8@0Sg_00<icSF]=Jd00Re[00<U:B488@P00QS600<DYA2448@00PQ20`@Q2P000P@Q
0PQ200<<Ha2448@00QBU00<LibDY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[F
F]H00U:D00=242e[;F/00QcW0aS60R480bU:0be[2C6<0be[22U:2Re[0S6<1CF]0S6<1be[0c6<0cF]
1c6<1Be[2S6<0be[1C6<3SF]2S6<1CF]0cW>1Cg_1CW>33g_00<icSF]=Jd013F]00<icT8@@Q000THa
0dYB0THa00=243W>>Lh00S6<00<YBRDY9BT00RDY00<YBS6<<H`00SW>00=6<DicCW<01e:D00=>LdHa
AS400Sg_00<aS2DY9BT00acW0RU:17oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<e[CW>
>Lh00T8@00=:DTicCW<025:D14ic0dYB1DHa1dYB1Dic2TYB@4Ha3DYB4DHa348@3DHa0T8@0Sg_00<i
cSF]=Jd00Re[00<U:B488@P00QS600<DYA2448@00PQ20`@Q2P000P@Q0PQ200<<Ha2448@00QBU00<L
ibDY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00U:D00=242e[;F/00QcW
0aS60R480bU:0be[2C6<0be[22U:2Re[0S6<1CF]0S6<1be[0c6<0cF]1c6<1Be[2S6<0be[1C6<3SF]
2S6<1CF]0cW>1Cg_1CW>33g_00<icSF]=Jd013F]00<icT8@@Q000THa0dYB0THa00=243W>>Lh00S6<
00<YBRDY9BT00RDY00<YBS6<<H`00SW>00=6<DicCW<01e:D00=>LdHaAS400Sg_00<aS2DY9BT00acW
0RU:17oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<e[Cg_?Nl00T8@00=:DTicCW<00U:D
1EJe0e:D0Tic3dYB0Tic24YBADHa4DYB8dHa0d8@0Sg_0SW>00<aS2e[;F/00RU:00<Q21cW7>L00QBU
00<@Q0aS36<00PQ200<48@0000002@000`@Q0PQ200<<Ha2448@00QS600<LibDY9BT017oo00<007oo
Ool0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00U:D00=242e[;F/00QcW00<DYAS66<H00QcW00<U
:BU::DX00RU:1Be[0c6<1Be[1bU:2Re[0c6<1CF]0S6<0Re[0bU:0Re[1C6<0cF]1C6<0be[136<1CF]
0c6<0be[136<1CF]236<23F]1c6<0SF]00<icSg_?Nl01cg_43W>13F]0SW>00=244icCW<00UJe00=J
eU:DDY@00T8@00<aS2DY9BT00b480RDY0Re[00<e[Cg_?Nl00THa00=:DTicCW<01Dic0TYB0dHa0Sg_
00<aS2DY9BT00acW0RU:17oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<e[Cg_?Nl00THa
00=:DU:DDY@025Je0U:D14ic54YB44Ha5DYB9DHa44YB4DHa34YB0dHa0T8@0Sg_00<icSF]=Jd00S6<
00<]JbU::DX00R4800<LiaS66<H00Q2400<<H`Q224800PQ20`@Q1@001@@Q0PQ20`aS0Q240QS600<L
ibDY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0T8@00=BU5[FF]H00U:D00=242U::DX00QS6
00<DYAS66<H00QcW00<U:BU::DX00RU:0be[236<2Be[0c6<3SF]00<aS2e[;F/00Re[0bU:0be[4C6<
0cF]0SW>0cF]0S6<0be[136<1SF]136<2cF]1c6<0SF]00<icSg_?Nl00Sg_00=243g_?Nl00Sg_1SW>
3SF]0Sg_00=6<E:DDY@00e[F0Tic0SW>00<U:ABU5:D00QBU00<LibU::DX00SF]00<mkdHaAS400TYB
0dic0TYB0dHa0d8@0Sg_0SW>00<aS2DY9BT00acW0Re[17oo00<007ooOol047oo000GOol40003Ool2
0005Ool01000Oomoogoo0Re[00<e[Cg_?Nl00THa00=:DU:DDY@025Je0U:D14ic54YB44Ha5DYB9DHa
44YB4DHa34YB0dHa0T8@0Sg_00<icSF]=Jd00S6<00<]JbU::DX00R4800<LiaS66<H00Q2400<<H`Q2
24800PQ20`@Q1@001@@Q0PQ20`aS0Q240QS600<LibDY9BT017oo00<007ooOol097oo10000goo0P00
17oo00<007ooOol00Woo0T8@00=BU5[FF]H00U:D00=242U::DX00QS600<DYAS66<H00QcW00<U:BU:
:DX00RU:0be[236<2Be[0c6<3SF]00<aS2e[;F/00Re[0bU:0be[4C6<0cF]0SW>0cF]0S6<0be[136<
1SF]136<2cF]1c6<0SF]00<icSg_?Nl00Sg_00=243g_?Nl00Sg_1SW>3SF]0Sg_00=6<E:DDY@00e[F
0Tic0SW>00<U:ABU5:D00QBU00<LibU::DX00SF]00<mkdHaAS400TYB0dic0TYB0dHa0d8@0Sg_0SW>
00<aS2DY9BT00acW0Re[17oo00<007ooOol047oo000GOol00`00Oomoo`03Ool01000Oomoo`0017oo
00@007ooOomoo`8]J`03=Jdmkcg_0096<@03CW=BU5:D009F]@=JeP=F]@9BU0A>La9:DP=6<@Y240E6
<@M:DP9>L`a:DRI6<A5:DPe6<@A:DPQ>L`9:DP96<@03@Q0mkcg_008icP03=JdaS36<008]J`039BTQ
2248008Li`036<HDYABU008@Q00336<8@PQ20088@PX48@<8@P@<H`0348@DYABU008HaP037>LU:BDY
00Aoo`03001oogoo02Aoo`03001oogoo00=oo`04001oogoo0003Ool00`00Oomoo`02Ool2@Q000eJe
G_MNm`02DY@00d8@:DXYBP026<H00a245:DDY@027>L00bDY:DXYBP02;F/3<H`3=Jd4>Lh:=Jd00cW>
?Nlmk`02?Nl00d8@AS56<@02AS400d8@?Nlmk`02>Lh2=Jd00c6<;F/]J`0=;F/7<H`5=Jd7>Lh00cF]
<H`aS005<H`I=Jd7<H`00cW>?Nlmk`02?Nl3@Q03?Nl4>Lh3=Jd2<H`5;F/00c6<=Jde[@02?Nl2AS40
0dicDYABU002E[D00e:DAS56<@02<H`00b485:DDY@025:D00acW;F/]J`02>Lh00d8@AS56<@05BU82
AS400d8@?Nlmk`02?Nl3>Lh2=Jd00be[9BTU:@027>L00b48;F/]J`04Ool00`00Oomoo`0@Ool001Qo
o`03001oogoo009oo`04001oogoo0004Ool3000017oo;F/]JcF]0Sg_0THa00=>Le:DDY@00UJe0e[F
0eJe0U:D14ic4TYB0dHa2T8@1DHa1dYB0Tic34YB9THa4DYB3DHa14YB24ic0TYB0THa00=243g_?Nl0
0SW>00<e[C6<<H`00Re[00<U:B488@P00QcW00<HaQBU5:D00Q2400<<H`Q224800PQ22P@Q0`Q210aS
00<@Q1BU5:D00QS600<LibDY9BT00goo0P009goo00<007ooOol00Woo00@007ooOol000=oo`<0009o
o`924003E[ENmekg009BU003@Q0YBRU:008HaP0348@DYABU008Li`039BTYBRU:008]J`<aS0<e[@@i
cPXe[@03>Lhmkcg_008mk`03@Q16<DHa0096<@03@Q0mkcg_008icP8e[@03<H`]Jbe[00d]J`LaS0De
[@LicP03=JdaS36<00DaS1Te[@LaS003>Lhmkcg_008mk`=240<mk`@icP<e[@8aS0D]J`03<H`e[CF]
008mk`96<@03CW=BU5:D009F]@03DYA6<DHa008aS0038@PDYABU008DY@037>L]Jbe[008icP03@Q16
<DHa00E:DP96<@03@Q0mkcg_008mk`<icP8e[@03;F/U:BDY008Li`038@P]Jbe[00=oo`80019oo`00
6Goo00D007ooOomoo`00009oo`03001oogoo009oo`04001oogooOol2;F/00cF]?Nlmk`02AS400dic
DYABU002E[D5F]H00eJeDYABU002DY@2CW<@BU84AS43@Q07?Nl3@Q03AS44BU8:CW<7BU8JAS42BU8<
AS4?BU8<AS43BU84CW<5DY@00dicBU9:DP02AS400d8@?Nlmk`02=Jd00c6<:DXYBP029BT00b487>LL
i`026<H00aBU48@@Q00336<>248536<348@25:D26<H00acW9BTU:@04Ool00`00Oomoo`0VOol01@00
Oomoogoo00000Woo00D007ooOomoo`0000Aoo`924003E[ENmekg009F]@03?NlYBRU:008DY@0348@D
YABU008Li`039BT]Jbe[008aS003=JdicSW>00<mk`E240Tmk`03@Q16<DHa009:DP03DYAF]EJe009F
]@03CW=6<DHa008icP8aS0D]J`03<H`]Jbe[008]J`HYBP8]J`<aS08e[@<icP8mk`LicPXe[@DicPHe
[@DicPLe[@DaS0<e[@8icP8mk`=240<mk`8icP<e[@8aS08]J`03:DXU:BDY008YBP03<H`icSW>0096
<@E>L`96<@03?Nle[CF]008YBP038@PLiacW008Q2003:DXaS36<008icP=24096<@E24003?NlicSW>
008icP<e[@8aS003:DXQ2248008Li`038@P]Jbe[00Aoo`03001oogoo011oo`005goo00@007ooOol0
009oo`04001oogoo0004Ool01000Oomoogoo0Re[00<e[Cg_?Nl00THa00=>Le:DDY@00UJe1E[F00=F
]E:DDY@014ic0dYB1DHa1DYB1DHa0d8@2Sg_0T8@0THa0dYB3Tic1DYB5dHa1dYB2THa4DYB24Ha0dYB
14ic1e:D00=>LdYBBU800THa00<mkcW>>Lh00S6<00<YBRDY9BT00R4800<HaQBU5:D00QBU00<@Q0aS
36<00PaS2PQ21`aS1A240aBU0QS600<LibDY9BT017oo00<007ooOol097oo00@007ooOol0009oo`04
001oogoo0003Ool00`00Oomoo`02Ool2AS400eJeG_MNm`02E[D00d8@:DXYBP025:D00a245:DDY@02
7>L00bU:<H`aS002=Jd00cW>?Nlmk`02@Q000dHaBU9:DP03BU8:AS42BU82DY@00ekgHaQS6002HaP0
0e[FBU9:DP02>Lh2;F/00bU:;F/]J`02<H`3=Jd2<H`00bU:9BTU:@029BT3:DX2;F/00cF]>LhicP07
?Nl3>Lh5=JdI>Lh5=Jd5<H`3=Jd2>Lh8?Nl2>Lh2=Jd00c6<;F/]J`02:DX38@P29BT00be[?Nlmk`02
CW<3DY@2AS42=Jd00bU:9BTU:@028@P00bDY:DXYBP02;F/00c6<>LhicP08?Nl5>Lh4=Jd3<H`2;F/0
0bDY8@PQ20027>L00b48<H`aS004Ool00`00Oomoo`0@Ool001Qoo`8000Aoo`8000Eoo`04001oogoo
Ool2;F/00cF]?Nlmk`02AS400dicDYABU002E[D5F]H00eJeDYABU004CW<3BU85AS45BU85AS43@Q0:
?Nl2@Q02AS43BU8>CW<5BU8GAS47BU8:AS4ABU88AS43BU84CW<7DY@00dicBU9:DP02AS400cg_>Lhi
cP02<H`00bU:9BTU:@028@P00aS65:DDY@025:D00a2436<<H`0236<:248736<548@35:D26<H00acW
9BTU:@04Ool00`00Oomoo`0UOol20004Ool20004Ool00`00Oomoo`02Ool2AS400eJeG_MNm`02E[D0
0d8@:DXYBP025:D00a245:DDY@027>L00bU:<H`aS002=Jd00cW>?Nlmk`02@Q000dHaBU9:DP03BU8:
AS42BU82DY@00ekgHaQS6002HaP00e[FBU9:DP02>Lh2;F/00bU:;F/]J`02<H`3=Jd2<H`00bU:9BTU
:@029BT3:DX2;F/00cF]>LhicP07?Nl3>Lh5=JdI>Lh5=Jd5<H`3=Jd2>Lh8?Nl2>Lh2=Jd00c6<;F/]
J`02:DX38@P29BT00be[?Nlmk`02CW<3DY@2AS42=Jd00bU:9BTU:@028@P00bDY:DXYBP02;F/00c6<
>LhicP08?Nl5>Lh4=Jd3<H`2;F/00bDY8@PQ20027>L00b48<H`aS004Ool00`00Oomoo`0@Ool002Eo
o`04001oogooOol2;F/00cF]?Nlmk`02AS400dicDYABU002E[D3F]H3E[D2DY@2CW<3BU8?AS44@Q03
?Nl5>Lh3?Nl2@Q02AS43BU82CW<7DY@5CW<5BU8EAS4;BU88AS4BBU87AS43BU82CW<9DY@00dicBU9:
DP02@Q000cg_=Jde[@02;F/00bDY8@PQ20026<H00aBU48@@Q00248@536<6248736<748@35:D46<H0
0b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400e[FHaQS6002E[D00d8@:DXYBP02
6<H00aBU6<HHaP028@P00be[=Jde[@02>Lh00cg_@Q124003BU84CW<3BU88AS42BU82DY@00ekgHaQS
6002HaP00e[FAS56<@02=Jd3:DX2<H`2>Lh3?Nl2=Jd00be[:DXYBP029BT00bU:;F/]J`02<H`00cF]
>LhicP07?NlQ>Lh==Jd4>Lh6?Nl2>Lh2=Jd00c6<;F/]J`029BT38@P29BT00c6<@Q124002CW<2DY@0
0dYB>LhicP02:DX00acW6<HHaP028@P00bU:=Jde[@03>Lh4?Nl5>Lh:=Jd00c6<;F/]J`02:DX00bDY
7>LLi`027>L00b48<H`aS004Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2;F/00cF]?Nlmk`02
AS400dicDYABU002E[D3F]H3E[D2DY@2CW<3BU8?AS44@Q03?Nl5>Lh3?Nl2@Q02AS43BU82CW<7DY@5
CW<5BU8EAS4;BU88AS4BBU87AS43BU82CW<9DY@00dicBU9:DP02@Q000cg_=Jde[@02;F/00bDY8@PQ
20026<H00aBU48@@Q00248@536<6248736<748@35:D46<H00b489BTU:@04Ool00`00Oomoo`0aOol0
0`00Oomoo`02Ool2AS400e[FHaQS6002E[D00d8@:DXYBP026<H00aBU6<HHaP028@P00be[=Jde[@02
>Lh00cg_@Q124003BU84CW<3BU88AS42BU82DY@00ekgHaQS6002HaP00e[FAS56<@02=Jd3:DX2<H`2
>Lh3?Nl2=Jd00be[:DXYBP029BT00bU:;F/]J`02<H`00cF]>LhicP07?NlQ>Lh==Jd4>Lh6?Nl2>Lh2
=Jd00c6<;F/]J`029BT38@P29BT00c6<@Q124002CW<2DY@00dYB>LhicP02:DX00acW6<HHaP028@P0
0bU:=Jde[@03>Lh4?Nl5>Lh:=Jd00c6<;F/]J`02:DX00bDY7>LLi`027>L00b48<H`aS004Ool00`00
Oomoo`0@Ool002Eoo`04001oogooOol2;F/00cF]?Nlmk`02AS400dicDYABU002E[D3F]H2E[D3DY@2
CW<2BU83AS43@Q09AS43@Q03?Nl9>Lh00cg_@Q124002AS400dYBCW=>L`02CW<8DY@4CW<6BU8AAS4a
BU83CW<9DY@00dicAS56<@02?Nl00cF]<H`aS002:DX00b486<HHaP025:D00a2436<<H`0C36<648@5
5:D26<H27>L00b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400e[FHaQS6002F]H0
0dYB<H`aS0028@P00acW8@PQ2002:DX00c6<>LhicP02?Nl00d8@AS56<@07BU800dHa@Q124003?Nl2
>Lh3?Nl2@Q02BU800dicE[EF]@02DY@00dYB>LhicP02:DX29BT00bU:=Jde[@02@Q03BU82@Q000cF]
;F/]J`02;F/00c6<=Jde[@02>Lh00cg_>LhicP0Z>Lh==Jd3>Lh5?Nl2>Lh2<H`00be[:DXYBP039BT2
:DX2;F/00cF]@Q124004BU800d8@<H`aS0029BT00aS67>LLi`029BT00c6<>LhicP05?Nl3>Lh<=Jd3
<H`2;F/2:DX00bDY7>LLi`027>L00b48<H`aS004Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2
;F/00cF]?Nlmk`02AS400dYBDYABU007E[D00e:DCW=>L`02BU82AS4B@Q03?Nl7>Lh3?Nl2@Q02AS40
0dYBCW=>L`04DY@3E[D3DY@4CW=8BU83CW<7DY@2CW<00dYB@Q124002>Lh00c6<:DXYBP028@P00acW
5:DDY@0248@536<3248>36<648@55:D26<H27>L00b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomo
o`02Ool2AS400e[FIcUW>@02G_L00dic>LhicP02:DX00bDY:DXYBP02<H`00cW>@Q124005AS42BU83
AS42@Q000cW>=Jde[@02<H`5;F/00c6<=Jde[@02=Jd3>Lh2=Jd00c6<9BTU:@048@P00bU:?Nlmk`02
CW<3E[D2BU800cg_=Jde[@02=Jd00cW>@Q124003AS42?Nl2=Jd3<H`2=Jd00cW>?Nlmk`03?NlR>Lh;
=Jd2>Lh2?Nl00cW>=Jde[@02<H`5:DX00be[=Jde[@02>Lh00cg_@Q124002@Q02?Nl00cF];F/]J`02
9BT00b489BTU:@02;F/00cF]?Nlmk`02@Q03?Nl2>Lh==Jd5<H`2;F/00bDY7>LLi`026<H00b48<H`a
S004Ool00`00Oomoo`0@Ool002Eoo`80009oo`8]J`03=Jdmkcg_0096<@03BU9BU5:D00MF]@03DYA>
Ldic009:DP96<A9240<mk`LicP<mk`924096<@03BU9>Ldic00ABU0=F]@=BU0A>LdQ:DP=>L`MBU09>
L`03BU92448@008icP03<H`YBRU:008Q20037>LDYABU008@Q0D<H`<8@Ph<H`H@Q0DDY@8HaP8Li`03
8@PU:BDY00=oo`8003=oo`8000=oo`96<@03F]IW>FLi009Nm`03CW<icSW>008YBP039BTYBRU:008a
S003>Li2448@00E6<@9:DP=6<@924003>Lhe[CF]008aS0D]J`03<H`e[CF]008e[@<icP8e[@03<H`U
:BDY00@Q2003:DXmkcg_009>L`=F]@9:DP03?Nle[CF]008e[@03>Li2448@00=6<@8mk`8e[@<aS08e
[@03>Lhmkcg_00<mkb8icP/e[@8icP8mk`03>Lhe[CF]008aS0DYBP03;F/e[CF]008icP03?Nm2448@
0092408mk`03=Jd]Jbe[008U:@038@PU:BDY008]J`03=Jdmkcg_009240<mk`8icPde[@DaS08]J`03
9BTLiacW008HaP038@PaS36<00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8]J`03=Jdmkcg_
0096<@03BU9BU5:D009BU003E[EBU5:D009BU003CW=:DTYB0096<@=240Tmk`I240Dmk`LicP8mk`=2
4096<@03BU9>Ldic009BU0EF]@EBU0=>Ld=:DPi>L`9:DP03@Q0mkcg_008e[@03;F/U:BDY008Li`03
5:D@Q12400<<H`L8@Pl<H`L@Q0<DY@8HaP8Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo
009oo`96<@03G_M[FV]J009W>@03E[E2448@008aS003;F/aS36<008icP03@Q16<DHa00M6<@03@Q0m
kcg_008e[@03<H`YBRU:00LQ20DU:@<Q208Li`036<HDYABU008DY@8Li`03;F]2448@009F]@03HaQN
mekg009BU003@Q0icSW>008mk`03AS5>Ldic009BU003BU8mkcg_008aS0<U:@8]J`03=Jdmkcg_00<m
k`@icQ8e[@dicPDe[@@aS0<e[@<icP8e[@8]J`<YBP8]J`03>Li2448@00=6<@8mk`8e[@8]J`DYBP03
;F/aS36<008icP03?Nm2448@00924003?NlicSW>00<e[@8aS0de[@8aS08]J`039BTLiacW008HaP03
7>L]Jbe[00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8]J`03=Jdmkcg_0096<@03BU9BU5:D
009BU003E[EBU5:D009BU003CW=:DTYB0096<@=240Tmk`I240Dmk`LicP8mk`=24096<@03BU9>Ldic
009BU0EF]@EBU0=>Ld=:DPi>L`9:DP03@Q0mkcg_008e[@03;F/U:BDY008Li`035:D@Q12400<<H`L8
@Pl<H`L@Q0<DY@8HaP8Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03G_M[
FV]J009W>@03E[E2448@008aS003;F/aS36<008icP03@Q16<DHa00M6<@03@Q0mkcg_008e[@03<H`Y
BRU:00LQ20DU:@<Q208Li`036<HDYABU008DY@8Li`03;F]2448@009F]@03HaQNmekg009BU003@Q0i
cSW>008mk`03AS5>Ldic009BU003BU8mkcg_008aS0<U:@8]J`03=Jdmkcg_00<mk`@icQ8e[@dicPDe
[@@aS0<e[@<icP8e[@8]J`<YBP8]J`03>Li2448@00=6<@8mk`8e[@8]J`DYBP03;F/aS36<008icP03
?Nm2448@00924003?NlicSW>00<e[@8aS0de[@8aS08]J`039BTLiacW008HaP037>L]Jbe[00Aoo`03
001oogoo011oo`009Goo00@007ooOomoo`8]J`03=Jdmkcg_00924003BU9>Ldic00EBU09>L`03BU96
<DHa0096<@924003?NlicSW>00<icPlmk`DicP@mk`03@Q16<DHa009:DP03CW=BU5:D009BU0MF]@=B
U0=>L`i:DPE>LbQ:DQ=>L`03BU96<DHa00924003?Nle[CF]008aS003:DXQ2248008HaP0348@<H`aS
00P8@QD<H`<@Q0<DY@8HaP8Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03
G_M[FV]J009W>@03F]I6<DHa008e[@03<H`e[CF]008icP03@Q16<DHa00=6<@A24003?NlicSW>008a
S003:DXQ224800LHaP<Li`8HaP035:D<H`aS00D<H`8DY@8Q2003=Je:DTYB009JeP03HaQNmekg009B
U003@Q0icSW>008mk`03BU9BU5:D009F]@03CW<mkcg_008]J`<Q208YBP03=Jdmkcg_00<mk`8icQHe
[@dicP<e[@DaS0De[@8aS0D]J`8e[@03@Q1:DTYB009>L`03AS4icSW>008YBP<Q208U:@8aS003>Lhm
kcg_00E2408mk`03>Lhe[CF]00DaS0De[@DicPDe[@8aS0039BTLiacW008HaP037>L]Jbe[00Aoo`03
001oogoo011oo`009Goo00@007ooOomoo`8]J`03=Jdmkcg_00924003BU9>Ldic00M>L`03BU96<DHa
0092408mk`XicQ8mk`=24096<@9:DP03CW=BU5:D00UF]@=BU0=>L`U:DQ1>L`]:DPQ>L`e:DQ5>L`A:
DP03AS52448@008mk`03>LhaS36<008YBP038@PLiacW008DY@0348@<H`aS00P8@P@<H`D@Q0d<H`@@
Q0035:DHaQS6008Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03G_M_Nfmk
009[FP03F]I6<DHa008e[@03;F/aS36<008e[@03>Lhmkcg_00=240@mk`03>Lhe[CF]008aS003:DXQ
2248008Li`<HaP8Li`<Q208Li`035:D<H`aS00<<H`8DY@8Q208]J`03?Nm:DTYB009F]@03F]IBU5:D
0096<@03>LhaS36<008e[@03AS5BU5:D009F]@03DYA2448@008aS0<U:@8YBP03=JdicSW>008mk`<i
cQLe[@DicP8mk`DicP<e[@laS08e[@8mk`03AS5>Ldic009>L`03@Q0aS36<008U:@8HaP037>LYBRU:
008e[@03?Nm6<DHa0096<@03@Q0mkcg_00<icP8e[@DaS0<e[@XicP8e[@8aS003:DXLiacW008HaP03
7>L]Jbe[00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8]J`03=Jdmkcg_00924003BU9>Ldic
00M>L`03BU96<DHa0092408mk`XicQ8mk`=24096<@9:DP03CW=BU5:D00UF]@=BU0=>L`U:DQ1>L`]:
DPQ>L`e:DQ5>L`A:DP03AS52448@008mk`03>LhaS36<008YBP038@PLiacW008DY@0348@<H`aS00P8
@P@<H`D@Q0d<H`@@Q0035:DHaQS6008Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009o
o`96<@03G_M_Nfmk009[FP03F]I6<DHa008e[@03;F/aS36<008e[@03>Lhmkcg_00=240@mk`03>Lhe
[CF]008aS003:DXQ2248008Li`<HaP8Li`<Q208Li`035:D<H`aS00<<H`8DY@8Q208]J`03?Nm:DTYB
009F]@03F]IBU5:D0096<@03>LhaS36<008e[@03AS5BU5:D009F]@03DYA2448@008aS0<U:@8YBP03
=JdicSW>008mk`<icQLe[@DicP8mk`DicP<e[@laS08e[@8mk`03AS5>Ldic009>L`03@Q0aS36<008U
:@8HaP037>LYBRU:008e[@03?Nm6<DHa0096<@03@Q0mkcg_00<icP8e[@DaS0<e[@XicP8e[@8aS003
:DXLiacW008HaP037>L]Jbe[00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8]J`03=JdicSW>
00924003AS5:DTYB00=>L`A:DP03AS52448@008mk`<icPDe[@DicPlmk`A24003AS5:DTYB009>L`=B
U0UF]@=BU0=>L`M:DRQ>L`Y:DPE>L`MBU0E>L`9:DP96<@03@Q0mkcg_008icP03<H`YBRU:008U:@03
7>LDYABU008@Q00336<8@PQ200L8@P<<H`P@Q0H<H`<8@P<<H`@@Q0035:DHaQS6008Li`038@PYBRU:
00Aoo`03001oogoo035oo`03001oogoo009oo`9:DP03HaQ_Nfmk009[FP03E[E2448@008]J`<U:@8]
J`03<H`e[CF]00PicP@e[@03;F/YBRU:00DU:@DYBP8U:@038@PLiacW008HaP038@PYBRU:008aS08m
k`03AS5:DTYB009>L`03BU92448@008aS003:DXQ2248008YBP03>Li:DTYB009BU003CW=2448@008e
[@03;F/YBRU:008]J`03=JdicSW>00<icPTe[@DicPde[@`icP<e[@8aS0H]J`8aS08e[@03>Li2448@
0096<@=:DP96<@03>Lh]Jbe[008Q208HaP038@PYBRU:008icP03@Q16<DHa0096<@03@Q0mkcg_008i
cP03=JdaS36<00DaS0<e[@8icPPmk`8icP8aS003:DXLiacW008HaP037>L]Jbe[00Aoo`03001oogoo
011oo`009Goo00@007ooOomoo`8]J`03=JdicSW>00924003AS5:DTYB00=>L`A:DP03AS52448@008m
k`<icPDe[@DicPlmk`A24003AS5:DTYB009>L`=BU0UF]@=BU0=>L`M:DRQ>L`Y:DPE>L`MBU0E>L`9:
DP96<@03@Q0mkcg_008icP03<H`YBRU:008U:@037>LDYABU008@Q00336<8@PQ200L8@P<<H`P@Q0H<
H`<8@P<<H`@@Q0035:DHaQS6008Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`9:
DP03HaQ_Nfmk009[FP03E[E2448@008]J`<U:@8]J`03<H`e[CF]00PicP@e[@03;F/YBRU:00DU:@DY
BP8U:@038@PLiacW008HaP038@PYBRU:008aS08mk`03AS5:DTYB009>L`03BU92448@008aS003:DXQ
2248008YBP03>Li:DTYB009BU003CW=2448@008e[@03;F/YBRU:008]J`03=JdicSW>00<icPTe[@Di
cPde[@`icP<e[@8aS0H]J`8aS08e[@03>Li2448@0096<@=:DP96<@03>Lh]Jbe[008Q208HaP038@PY
BRU:008icP03@Q16<DHa0096<@03@Q0mkcg_008icP03=JdaS36<00DaS0<e[@8icPPmk`8icP8aS003
:DXLiacW008HaP037>L]Jbe[00Aoo`03001oogoo011oo`009Goo0P000Woo0Re[00<e[CW>>Lh00Sg_
00=6<DYBBU801DYB0THa00=243g_?Nl013W>23F]0cW>33g_1D8@0dHa0TYB0Tic00=BU5JeE[D00UJe
0e[F15Je0e:D1Dic0dYB1dic25:D7Dic1dYB1Dic2U:D00=>LdYBBU800THa0T8@00<mkcF]=Jd00S6<
00<YBRDY9BT00QcW00<HaQ2448@00PaS0`Q20P@Q1@Q20`aS212410aS1`Q20`aS0Q2400<DYAS66<H0
0QcW00<Q22U::DX00goo0P00<goo0P000goo0TYB00=S66mkKg/00VLi00=BU3W>>Lh00RDY00<HaQcW
7>L00R4800<U:Be[;F/00c6<0SF]1cW>0cF]1C6<1cF]00<aS2e[;F/00Re[00<e[Cg_?Nl00THa0TYB
00=>LdYBBU800T8@00<icRe[;F/00R4800<HaQBU5:D00QcW00<]Jcg_?Nl00dYB0THa0Sg_00<e[C6<
<H`00S6<3CF]23W>1CF]136<0cF]3CW>0SF]0S6<00<]JbU::DX00RDY00<YBS6<<H`00SW>00=6<DYB
BU800Tic00=:DTHaAS400SW>00<aS2U::DX00R480QcW00<U:C6<<H`00Sg_1DHa00<mkcW>>Lh00cF]
1c6<0cF]0SW>0Sg_1D8@00<mkcW>>Lh00SF]00<YBR488@P00QS600<Lic6<<H`017oo00<007ooOol0
47oo000UOol01000Oomoogoo0Re[00<aS3W>>Lh00Sg_00=244HaAS401dHa00=243g_?Nl00SW>2SF]
0cW>13g_2d8@14Ha00=:DTicCW<00e:D15Je0e[F15Je0e:D3Dic35:D6dic1dYB0dic35:D00=>LdYB
BU800T8@0Sg_00<icS6<<H`00RU:00<U:AcW7>L00QS600<DYA2448@00PaS0`Q20P@Q0`Q20`aS2Q24
10aS1`Q20`aS0Q2400<DYAS66<H00QcW00<Q22U::DX017oo00<007ooOol0<Goo00<007ooOol00Woo
0TYB00=Nmf]JJeX00V<H00=>Lc6<<H`00QcW0aBU0QS600<Q22DY9BT00RU:00<aS3F]=Jd00SW>2Sg_
00<icSg_?Nl00Sg_1D8@1Cg_00=6<DYBBU8015:D00=>LdHaAS400SW>00<]Jb488@P00QBU0`aS0QS6
00<U:CF]=Jd00T8@0dHa0T8@00<mkcW>>Lh00cF]1c6<0cF]33W>0cF]1C6<13F]2cW>0SF]0S6<00<]
JbU::DX00bDY0S6<0Sg_00=:DU:DDY@00U:D00=:DSg_?Nl00S6<00<YBRDY9BT00R480RDY00<]JcF]
=Jd00Sg_0dHa0T8@00<mkcF]=Jd02S6<0SF]00<icSg_?Nl00d8@0THa0d8@0Sg_0SF]00<YBR488@P0
0QS600<Lic6<<H`017oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<aS3W>>Lh00Sg_00=2
44HaAS401dHa00=243g_?Nl00SW>2SF]0cW>13g_2d8@14Ha00=:DTicCW<00e:D15Je0e[F15Je0e:D
3Dic35:D6dic1dYB0dic35:D00=>LdYBBU800T8@0Sg_00<icS6<<H`00RU:00<U:AcW7>L00QS600<D
YA2448@00PaS0`Q20P@Q0`Q20`aS2Q2410aS1`Q20`aS0Q2400<DYAS66<H00QcW00<Q22U::DX017oo
00<007ooOol0<Goo00<007ooOol00Woo0TYB00=Nmf]JJeX00V<H00=>Lc6<<H`00QcW0aBU0QS600<Q
22DY9BT00RU:00<aS3F]=Jd00SW>2Sg_00<icSg_?Nl00Sg_1D8@1Cg_00=6<DYBBU8015:D00=>LdHa
AS400SW>00<]Jb488@P00QBU0`aS0QS600<U:CF]=Jd00T8@0dHa0T8@00<mkcW>>Lh00cF]1c6<0cF]
33W>0cF]1C6<13F]2cW>0SF]0S6<00<]JbU::DX00bDY0S6<0Sg_00=:DU:DDY@00U:D00=:DSg_?Nl0
0S6<00<YBRDY9BT00R480RDY00<]JcF]=Jd00Sg_0dHa0T8@00<mkcF]=Jd02S6<0SF]00<icSg_?Nl0
0d8@0THa0d8@0Sg_0SF]00<YBR488@P00QS600<Lic6<<H`017oo00<007ooOol047oo000UOol01000
Oomoogoo0Re[00<aS3F]=Jd00SW>0d8@1DHa0T8@0cg_0SW>23F]13W>0cg_1D8@24Ha14YB0dic0U:D
0eJe1e[F0eJe0U:D34ic3e:D3Dic1e:D1dic0dYB1Dic0e:D1EJe0U:D0Tic00=:DTHaAS400T8@0SW>
00<aS2e[;F/00RDY00<Q21S66<H00QBU00<@Q0aS36<02PQ20`aS112400<DYA2448@00a2410aS20Q2
0PaS0Q2400<DYAS66<H00QcW00<Q22DY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0T8@00=F
]EkgG_L00U[F00=6<Be[;F/00QS60a240QS600<Q22DY9BT00RU:00<aS3F]=Jd00SW>00<mkd8@@Q00
348@2THa00=:DTicCW<015:D00=:DT8@@Q000SF]00<YBQcW7>L00QBU0a240QS600<Q22e[;F/00SW>
0d8@0THa00=243g_?Nl00SW>00<e[C6<<H`00Re[0c6<0cF]2SW>1CF]1C6<13F]0cW>1Cg_0cW>0SF]
0S6<00<]JbDY9BT00RDY00<YBSF]=Jd00T8@00=BU5JeE[D00U:D00=6<CF]=Jd00RU:00<Q22DY9BT0
0RU:0Re[00<e[CW>>Lh01D8@0Sg_00<icSF]=Jd02S6<0SF]00<icSg_?Nl00d8@0THa0d8@0Sg_0SF]
00<]Jb488@P00QcW00<Q22e[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<aS3F]
=Jd00SW>0d8@1DHa0T8@0cg_0SW>23F]13W>0cg_1D8@24Ha14YB0dic0U:D0eJe1e[F0eJe0U:D34ic
3e:D3Dic1e:D1dic0dYB1Dic0e:D1EJe0U:D0Tic00=:DTHaAS400T8@0SW>00<aS2e[;F/00RDY00<Q
21S66<H00QBU00<@Q0aS36<02PQ20`aS112400<DYA2448@00a2410aS20Q20PaS0Q2400<DYAS66<H0
0QcW00<Q22DY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0T8@00=F]EkgG_L00U[F00=6<Be[
;F/00QS60a240QS600<Q22DY9BT00RU:00<aS3F]=Jd00SW>00<mkd8@@Q00348@2THa00=:DTicCW<0
15:D00=:DT8@@Q000SF]00<YBQcW7>L00QBU0a240QS600<Q22e[;F/00SW>0d8@0THa00=243g_?Nl0
0SW>00<e[C6<<H`00Re[0c6<0cF]2SW>1CF]1C6<13F]0cW>1Cg_0cW>0SF]0S6<00<]JbDY9BT00RDY
00<YBSF]=Jd00T8@00=BU5JeE[D00U:D00=6<CF]=Jd00RU:00<Q22DY9BT00RU:0Re[00<e[CW>>Lh0
1D8@0Sg_00<icSF]=Jd02S6<0SF]00<icSg_?Nl00d8@0THa0d8@0Sg_0SF]00<]Jb488@P00QcW00<Q
22e[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0RU:00<]JcF]=Jd00SW>00<mkd8@@Q00
1d8@0cg_13W>1CF]0cW>0cg_0T8@24Ha1dYB0dic0U:D0eJe2E[F0eJe15:D2Tic45:D2Dic2U:D3dic
0e:D1EJe0U:D0Tic00=:DT8@@Q000Sg_0SF]00<]JbDY9BT00R4800<HaQBU5:D00Q240`aS20Q210aS
2a2410aS1`Q20`aS0Q240aBU0QS600<Q22DY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_
00=>Le:DDY@00Tic00<mkbU::DX00QS60aBU0QcW00<U:BU::DX00Re[00<e[CW>>Lh00Sg_00=244Ha
AS400dHa2T8@2DHa1DYB0THa00=243W>>Lh00S6<00<]JbDY9BT00R480acW0R4800<U:BU::DX00S6<
00<icSg_?Nl00T8@00=6<D8@@Q000SW>00<e[Be[;F/00be[0S6<0cF]2CW>1CF]1S6<0SF]0cW>1cg_
0SW>00<e[C6<<H`00Re[1BU:00<]JcW>>Lh00THa00=BU5JeE[D00Tic00<mkbe[;F/00b480RDY0Re[
0SF]2Sg_00<icSF]=Jd00SF]236<0SF]00<icSg_?Nl01d8@0cg_0SF]00<]JbDY9BT00QcW00<Q22e[
;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0RU:00<]Jc6<<H`00SF]00<icSg_?Nl01d8@
0cg_2CW>0cg_0d8@14Ha1TYB1dic0e:D15Je2U[F0eJe15:D2Tic1U:D15Je6e:D2dic1E:D1EJe0U:D
0Tic00=6<D8@@Q000SW>0S6<00<YBR488@P00QS600<DYA2448@00`aS1`Q21`aS2a241PaS1@Q20`aS
0a240QBU0QS600<Lib488@P017oo00<007ooOol0<Goo00<007ooOol00Woo0SF]00=244YBBU800T8@
00<e[BU::DX00QcW00<HaQcW7>L00R4800<YBS6<<H`00SF]00<icSg_?Nl00T8@1THa148@1Sg_1D8@
14Ha0d8@0Sg_0cW>0SF]0c6<1Be[1bU:0Re[00<aS3W>>Lh00T8@00=6<D8@@Q000Sg_00<e[Be[;F/0
0Re[0c6<0cF]1cW>1cF]1C6<0cF]0cW>1cg_0SW>00<e[C6<<H`00Re[0bU:0Re[00<aS3g_?Nl00THa
0e:D0TYB00<icRU::DX00QcW00<Q22U::DX00SF]0Sg_0d8@0Sg_23W>0SF]0c6<0Re[0c6<0SF]00<i
cSg_?Nl00Sg_0d8@0cg_0SW>0SF]00<]JbDY9BT00b480RU:17oo00<007ooOol047oo000UOol01000
Oomoogoo0RU:00<]Jc6<<H`00SF]00<icSg_?Nl01d8@0cg_2CW>0cg_0d8@14Ha1TYB1dic0e:D15Je
2U[F0eJe15:D2Tic1U:D15Je6e:D2dic1E:D1EJe0U:D0Tic00=6<D8@@Q000SW>0S6<00<YBR488@P0
0QS600<DYA2448@00`aS1`Q21`aS2a241PaS1@Q20`aS0a240QBU0QS600<Lib488@P017oo00<007oo
Ool0<Goo00<007ooOol00Woo0SF]00=244YBBU800T8@00<e[BU::DX00QcW00<HaQcW7>L00R4800<Y
BS6<<H`00SF]00<icSg_?Nl00T8@1THa148@1Sg_1D8@14Ha0d8@0Sg_0cW>0SF]0c6<1Be[1bU:0Re[
00<aS3W>>Lh00T8@00=6<D8@@Q000Sg_00<e[Be[;F/00Re[0c6<0cF]1cW>1cF]1C6<0cF]0cW>1cg_
0SW>00<e[C6<<H`00Re[0bU:0Re[00<aS3g_?Nl00THa0e:D0TYB00<icRU::DX00QcW00<Q22U::DX0
0SF]0Sg_0d8@0Sg_23W>0SF]0c6<0Re[0c6<0SF]00<icSg_?Nl00Sg_0d8@0cg_0SW>0SF]00<]JbDY
9BT00b480RU:17oo00<007ooOol047oo000UOol01000Oomoogoo0RDY00<YBS6<<H`00SF]00<icSg_
?Nl00Sg_1T8@2cg_0d8@0dHa14YB1Tic1e:D1EJe1E[F15kg0e[F0eJe15:D2Tic1U:D15Je75:D2Tic
15:D1EJe0e:D0TYB00=6<Cg_?Nl00SF]0Re[00<U:AcW7>L00QBU00<@Q0aS36<00PaS1@Q220aS3A24
3PaS0a240QBU0QS600<Lib488@P017oo00<007ooOol0<Goo00<007ooOol00Woo0S6<00<mkd8@@Q00
0Sg_00<e[BU::DX01B480RU:00<]JcF]=Jd00SW>00<mkd8@@Q000T8@1DHa0d8@0cg_1CW>13g_1D8@
00<mkcW>>Lh00SF]1C6<0cF]1CW>13F]00<]JbU::DX00RU:00<]JcF]=Jd00Sg_0d8@0SW>00<e[C6<
<H`00c6<1CF]13W>2SF]0c6<1CF]0cW>1cg_0SW>00<e[Be[;F/01Be[0S6<00<icT8@@Q000THa0dYB
0T8@00<aS2DY9BT00R4800<U:Be[;F/00Sg_0dHa0T8@0SW>1CF]0cW>0SF]236<0SF]00<icSg_?Nl0
23g_0SW>0SF]00<]JbU::DX00b480RU:17oo00<007ooOol047oo000UOol20002Ool29BT00bU:<H`a
S002=Jd00cW>?Nlmk`02?Nl6@Q0;?Nl3@Q03AS44BU86CW<7DY@5E[D5F]H4G_L3F]H3E[D4DY@:CW<6
DY@4E[DLDY@:CW<4DY@5E[D3DY@2BU800dHa?Nlmk`02=Jd2;F/00bDY7>LLi`025:D00a2436<<H`02
36<5248836<=48@>36<348@25:D26<H00acW8@PQ2003Ool2000cOol20003Ool2<H`00cg_@Q124002
?Nl00cF]:DXYBP058@P2:DX00be[=Jde[@02>Lh00cg_@Q124002@Q05AS43@Q03?Nl5>Lh4?Nl5@Q00
0cg_>LhicP02=Jd5<H`3=Jd5>Lh4=Jd00be[:DXYBP02:DX00be[=Jde[@02?Nl3@Q02>Lh00cF]<H`a
S003<H`5=Jd4>Lh:=Jd3<H`5=Jd3>Lh7?Nl2>Lh00cF];F/]J`05;F/2<H`00cW>@Q124002AS43BU82
@Q000c6<9BTU:@028@P00bDY;F/]J`02?Nl3AS42@Q02>Lh5=Jd3>Lh2=Jd8<H`2=Jd00cW>?Nlmk`08
?Nl2>Lh2=Jd00be[:DXYBP038@P2:DX4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol29BT00bU:
;F/]J`02<H`00cF]>LhicP02?NlA@Q03AS43BU84CW<6DY@9E[D5F]H8G_L4F]H3E[D3DY@7CW<8DY@5
E[DMDY@7CW<5DY@5E[D00e:DCW=>L`02BU800d8@>LhicP02<H`2:DX00acW6<HHaP0248@00`aS2488
@P05248536<A48@=36<548@25:D26<H00acW8@PQ2004Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2
=Jd00cg_@Q124002@Q000cF];F/]J`059BT2;F/00c6<=Jde[@02>Lh00cg_@Q124008@Q02?Nl3>Lh4
=Jd5>Lh5?Nl00cW>=Jde[@02<H`3;F/2<H`2=Jd3>Lh5?Nl2>Lh00cF];F/]J`03;F/2<H`2>Lh3?Nl2
>Lh3=Jd2<H`N=Jd3>Lh5?Nl2>Lh00c6<;F/]J`02:DX00be[=Jde[@02>Lh00d8@AS56<@02AS400d8@
?Nlmk`02=Jd00be[9BTU:@029BT00be[=Jde[@02@Q02BU800dHa@Q124002>Lh5<H`6=Jd5<H`2=Jd3
>Lh4?Nl8>Lh2=Jd00c6<:DXYBP039BT2:DX4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P0
0bU:;F/]J`02<H`00cF]>LhicP02?Nl=@Q04AS43BU83CW<4DY@8E[D8F]H<G_L4F]H3E[D5DY@5CW<:
DY@3E[DPDY@2CW<=DY@2CW<2AS400cg_=Jde[@02;F/29BT00aS65:DDY@0236<8248336<?48@A36<5
48@25:D36<H27>L4Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2>Lh00dHaBU9:DP02AS400cg_<H`a
S002:DX00bDY:DXYBP02;F/00c6<=Jde[@03>Lh4?Nl3@Q03?Nl2>Lh:=Jd7>Lh3=Jd2<H`3;F/4<H`0
0cF]>LhicP02?Nl3@Q02?Nl00cW>=Jde[@05<H`3=Jd:>Lh7=Jd3>LhD=Jd4>Lh00cg_>LhicP02=Jd0
0c6<;F/]J`02;F/00c6<>LhicP02@Q000dYBAS56<@02?Nl00cF];F/]J`05:DX2;F/00cF]?Nlmk`05
AS42?Nl2=Jd00c6<;F/]J`03<H`:=Jd?>Lh4=Jd00c6<:DXYBP039BT2;F/4Ool00`00Oomoo`0@Ool0
02Eoo`04001oogooOol28@P00bU:;F/]J`02<H`00cF]>LhicP02?Nl=@Q04AS43BU83CW<4DY@8E[D8
F]H<G_L4F]H3E[D5DY@5CW<:DY@3E[DPDY@2CW<=DY@2CW<2AS400cg_=Jde[@02;F/29BT00aS65:DD
Y@0236<8248336<?48@A36<548@25:D36<H27>L4Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2>Lh0
0dHaBU9:DP02AS400cg_<H`aS002:DX00bDY:DXYBP02;F/00c6<=Jde[@03>Lh4?Nl3@Q03?Nl2>Lh:
=Jd7>Lh3=Jd2<H`3;F/4<H`00cF]>LhicP02?Nl3@Q02?Nl00cW>=Jde[@05<H`3=Jd:>Lh7=Jd3>LhD
=Jd4>Lh00cg_>LhicP02=Jd00c6<;F/]J`02;F/00c6<>LhicP02@Q000dYBAS56<@02?Nl00cF];F/]
J`05:DX2;F/00cF]?Nlmk`05AS42?Nl2=Jd00c6<;F/]J`03<H`:=Jd?>Lh4=Jd00c6<:DXYBP039BT2
;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol28@P00bDY;F/]J`02<H`00cF]>LhicP02?Nl5
@Q08AS44BU83CW<3DY@4E[D;F]HCG_L3F]H4E[DDDY@8E[DWDY@00dicBU9:DP02@Q000cW><H`aS002
:DX28@P00aS648@@Q00324821243248436<348@55:D548@A36<848@45:D00aS67>LLi`04Ool00`00
Oomoo`0aOol00`00Oomoo`02Ool2@Q000dicDYABU002CW<00d8@=Jde[@02;F/3:DX2;F/3=Jd7>Lh0
0cg_>LhicP03>Lh2=Jd8<H`>=Jd7<H`00cF]>LhicP02>Lh00cg_@Q124003?Nl2>Lh2=Jd8<H`2=Jd0
0cW>?Nlmk`02?Nl3>Lh7=Jd3>Lh7=Jd6>Lh9=Jd3>Lh2=Jd00c6<;F/]J`02;F/00cF]@Q124002BU80
0dicAS56<@02>Lh00bU:8@PQ20028@P00bDY<H`aS002>Lh00d8@AS56<@04AS400d8@?Nlmk`02=Jd0
0c6<;F/]J`03;F/2<H`5=Jd=>Lh9=Jd00c6<:DXYBP029BT00bU:<H`aS004Ool00`00Oomoo`0@Ool0
02Eoo`04001oogooOol28@P00bDY;F/]J`02<H`00cF]>LhicP02?Nl5@Q08AS44BU83CW<3DY@4E[D;
F]HCG_L3F]H4E[DDDY@8E[DWDY@00dicBU9:DP02@Q000cW><H`aS002:DX28@P00aS648@@Q0032482
1243248436<348@55:D548@A36<848@45:D00aS67>LLi`04Ool00`00Oomoo`0aOol00`00Oomoo`02
Ool2@Q000dicDYABU002CW<00d8@=Jde[@02;F/3:DX2;F/3=Jd7>Lh00cg_>LhicP03>Lh2=Jd8<H`>
=Jd7<H`00cF]>LhicP02>Lh00cg_@Q124003?Nl2>Lh2=Jd8<H`2=Jd00cW>?Nlmk`02?Nl3>Lh7=Jd3
>Lh7=Jd6>Lh9=Jd3>Lh2=Jd00c6<;F/]J`02;F/00cF]@Q124002BU800dicAS56<@02>Lh00bU:8@PQ
20028@P00bDY<H`aS002>Lh00d8@AS56<@04AS400d8@?Nlmk`02=Jd00c6<;F/]J`03;F/2<H`5=Jd=
>Lh9=Jd00c6<:DXYBP029BT00bU:<H`aS004Ool00`00Oomoo`0@Ool001Uoo`<0009oo`8000Eoo`04
001oogooOol28@P00bDY;F/]J`02<H`00cF]>LhicP02?Nl3@Q05AS47BU83CW<2DY@3E[D5F]H?G_L9
HaP5G_L3F]H5E[DCDY@?E[DNDY@2CW<00dYBAS56<@02?Nl00cF];F/]J`029BT27>L00aBU36<<H`02
248512400`Q236<<H`0236<00a245:DDY@055:D548@>36<;48@45:D00aS67>LLi`04Ool00`00Oomo
o`0VOol30002Ool20004Ool00`00Oomoo`02Ool2AS400e:DF]IJeP02E[D00dYB>LhicP02;F/00bU:
;F/]J`02<H`8=Jd5>Lh3=Jd4<H`3;F/<<H`?=Jd2>Lh3?Nl2@Q03?Nl2>Lh00cF]<H`aS005;F/2=Jd0
0cW>@Q124002@Q000cg_>LhicP07=Jd3>Lh3=Jd:>Lh4=Jd5<H`5=Jd3<H`2=Jd00cg_AS56<@03CW<2
@Q02<H`00b486<HHaP026<H00bDY=Jde[@02@Q03BU82AS42@Q000cg_>LhicP02=Jd6;F/4<H`00cF]
>LhicP02>Lh5?Nl5>Lh:=Jd00c6<:DXYBP03:DX2=Jd4Ool00`00Oomoo`0@Ool001Yoo`04001oogoo
0002Ool00`00Oomoo`02Ool01000Oomoogoo0R4800<U:Be[;F/00S6<00<e[CW>>Lh00Sg_0d8@1DHa
1dYB0dic0U:D0eJe1E[F3ekg2F<H1Ekg0e[F1EJe4e:D3eJe7U:D0Tic00=:DTHaAS400Sg_00<e[Be[
;F/00RDY0QcW00<DY@aS36<00PQ21@@Q00<8@PaS36<00PaS00<@Q1BU5:D01ABU1A243PaS2a2411BU
00<HaQcW7>L017oo00<007ooOol09goo00@007ooOol0009oo`05001oogooOol00004Ool2AS400e:D
F]IJeP02E[D00dYB>LhicP02;F/00bU:;F/]J`02<H`8=Jd5>Lh3=Jd4<H`3;F/<<H`?=Jd2>Lh3?Nl2
@Q03?Nl2>Lh00cF]<H`aS005;F/2=Jd00cW>@Q124002@Q000cg_>LhicP07=Jd3>Lh3=Jd:>Lh4=Jd5
<H`5=Jd3<H`2=Jd00cg_AS56<@03CW<2@Q02<H`00b486<HHaP026<H00bDY=Jde[@02@Q03BU82AS42
@Q000cg_>LhicP02=Jd6;F/4<H`00cF]>LhicP02>Lh5?Nl5>Lh:=Jd00c6<:DXYBP03:DX2=Jd4Ool0
0`00Oomoo`0@Ool001Moo`D00005Ool007ooOol00004Ool3000017oo8@PQ22DY0Re[0S6<00<e[Cg_
?Nl00d8@14Ha1dYB0dic0e:D15Je0e[F3Ekg46<H1Ekg0e[F1EJe4U:D3UJe3e:D1EJe1e:D0dic0TYB
00=6<D8@@Q000SW>00<aS2U::DX00R480QS600<@Q0aS36<00PQ21@@Q00<8@PaS36<00a241aBU1A24
3PaS2a2411BU00<HaQcW7>L00goo0P009Woo1@0000Eoo`00Oomoo`0000=oo`<0009oo`96<@03E[EJ
eU[F009F]@03BU8mkcg_008aS0<]J`8aS0le[@<aS0P]J`XaS0@e[@8icPPe[@<icP@mk`=2408mk`03
>LhaS36<008]J`03:DX]Jbe[008aS003>Li2448@00924003?NlicSW>00de[@XicP@e[@XaS0<e[@8i
cP03@Q1:DTYB009>L`03BU8mkcg_008YBP037>LDYABU008HaP039BTicSW>0096<@03CW=:DTYB0096
<@924003?Nle[CF]008aS0P]J`8aS003=JdicSW>00Lmk`DicPXe[@03<H`YBRU:00<YBP8e[@=oo`80
019oo`005goo00@007ooOol0009oo`04001oogoo0004Ool01000Oomoogoo0R4800<YBRe[;F/00S6<
00<icSg_?Nl00T8@0dHa1DYB1dic0e:D0UJe1E[F1ekg5f<H1Ekg1E[F1EJe3e:D45Je2U:D2eJe15:D
00=>LdYBBU800THa00=243W>>Lh00SF]00<]JbDY9BT00QcW0QBU00<@Q0Q224800PQ21@@Q00<8@PaS
36<00a241aBU1A243PaS2a2411BU00<HaQcW7>L017oo00<007ooOol097oo00@007ooOol0009oo`04
001oogoo0003Ool00`00Oomoo`02Ool2AS400e:DF]IJeP02E[D00dYB?Nlmk`02<H`3;F/2<H`?=Jd3
<H`<;F/5<H`7=Jd3>Lh2=Jd6>Lh4?Nl5@Q000cW>=Jde[@02;F/00bU:;F/]J`02<H`00cW>?Nlmk`03
?Nl2>Lh==Jd:>Lh4=Jd00c6<;F/]J`05;F/2<H`00cW>?Nlmk`02@Q000dHaBU9:DP02AS400d8@=Jde
[@029BT00aS65:DDY@026<H00bU:>LhicP02AS43CW<2AS42@Q000cW>=Jde[@02<H`8;F/2<H`00cF]
>LhicP08?Nl4>Lh:=Jd00c6<:DXYBP029BT00bU:=Jde[@04Ool00`00Oomoo`0@Ool001Qoo`03001o
o`00009oo`04001oogoo0004Ool01000Oomoogoo0R4800<YBRe[;F/00S6<00<icSg_?Nl00T8@0dHa
1DYB1dic0e:D0UJe1E[F1ekg5f<H1Ekg1E[F1EJe3e:D45Je2U:D2eJe15:D00=>LdYBBU800THa00=2
43W>>Lh00SF]00<]JbDY9BT00QcW0QBU00<@Q0Q224800PQ21@@Q00<8@PaS36<00a241aBU1A243PaS
2a2411BU00<HaQcW7>L017oo00<007ooOol09Goo00<007oo00000Woo00@007ooOol000=oo`03001o
ogoo009oo`96<@03DYAJeU[F009F]@03BU8mkcg_008aS0<]J`8aS0le[@<aS0`]J`DaS0Le[@<icP8e
[@HicP@mk`E24003>Lhe[CF]008]J`03:DX]Jbe[008aS003>Lhmkcg_00<mk`8icPde[@XicP@e[@03
<H`]Jbe[00D]J`8aS003>Lhmkcg_00924003AS5:DTYB0096<@03@Q0e[CF]008U:@036<HDYABU008H
aP03:DXicSW>0096<@=>L`96<@924003>Lhe[CF]008aS0P]J`8aS003=JdicSW>00Pmk`@icPXe[@03
<H`YBRU:008U:@03:DXe[CF]00Aoo`03001oogoo011oo`006Goo0P000goo0P001Goo00@007ooOomo
o`8U:@03:DX]Jbe[008e[@03>Li2448@0096<@E:DPQ>L`ABU0=F]@=JePMNma]S60ENm`EJePMF]@]B
U11F]@YBU0]F]@9BU09>L`03BU96<DHa00924003?Nle[CF]008aS003:DXQ2248008HaP8DY@0336<8
@PQ20088@P<48@<8@P8<H`<@Q0LDY@D@Q0l<H`X@Q0@DY@036<HLiacW00Aoo`03001oogoo02Ioo`80
00=oo`8000Aoo`03001oogoo009oo`924003DYAJeU[F009F]@03BU8icSW>008aS0<]J`8aS0He[@Di
cPDe[@@aS0P]J`DaS0Te[@dicP<mk`A24003?Nle[CF]008aS0<]J`8aS003=JdicSW>008mk`<icPDe
[@DaS0<e[@XicP@e[@03<H`]Jbe[00DYBP8aS003?Nm6<DHa009:DP03CW=:DTYB00924003=Jd]Jbe[
008Q20<HaP8Q2003;F/icSW>0096<@=:DP96<@924003>Lhe[CF]008aS0H]J`@aS003=JdicSW>008i
cPHmk`@icPXe[@03<H`YBRU:008U:@03:DXaS36<00Aoo`03001oogoo011oo`009Goo00@007ooOomo
o`8U:@03:DX]Jbe[008e[@03>Li2448@0096<@E:DPQ>L`ABU0=F]@=JePMNma]S60ENm`EJePMF]@]B
U11F]@YBU0]F]@9BU09>L`03BU96<DHa00924003?Nle[CF]008aS003:DXQ2248008HaP8DY@0336<8
@PQ20088@P<48@<8@P8<H`<@Q0LDY@D@Q0l<H`X@Q0@DY@036<HLiacW00Aoo`03001oogoo035oo`03
001oogoo009oo`924003DYAJeU[F009F]@03BU8icSW>008aS0<]J`8aS0He[@DicPDe[@@aS0P]J`Da
S0Te[@dicP<mk`A24003?Nle[CF]008aS0<]J`8aS003=JdicSW>008mk`<icPDe[@DaS0<e[@XicP@e
[@03<H`]Jbe[00DYBP8aS003?Nm6<DHa009:DP03CW=:DTYB00924003=Jd]Jbe[008Q20<HaP8Q2003
;F/icSW>0096<@=:DP96<@924003>Lhe[CF]008aS0H]J`@aS003=JdicSW>008icPHmk`@icPXe[@03
<H`YBRU:008U:@03:DXaS36<00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8U:@03:DXaS36<
008icP03?Nm2448@0096<@03BU9>Ldic00M>L`MBU0=F]@=JePMNmaeS60INm`AJePEF]@]BU11F]@YB
U0=F]@EJeP=F]@9BU09>L`03BU92448@008mk`03=JdaS36<008YBP039BTLiacW008HaP8@Q00336<8
@PQ200P8@P8<H`D@Q0DDY@D@Q14<H`P@Q08DY@<HaP8Q20Aoo`03001oogoo035oo`03001oogoo009o
o`924003CW=F]EJe009BU003AS4icSW>008]J`03:DX]Jbe[008aS0<e[@`icP<e[@DaS0D]J`<aS0`e
[@hicP03?Nm2448@00924003?NlicSW>00LaS003=JdicSW>00LicP<e[@DaS0<e[@`icP8e[@03<H`]
Jbe[008YBP039BTYBRU:008aS003?Nm:DTYB00=BU096<@8icP03;F/U:BDY008Q20<Li`8U:@03<H`i
cSW>009240E6<@924003>Lhe[CF]00<aS0D]J`@aS003=JdicSW>00<icPDmk`DicPTe[@03;F/YBRU:
00<U:@8aS0Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8U:@03;F/e[CF]008icP03@Q16<DHa
009:DP=>L`iBU0=F]@=JePMNmb1S60ENm`=JePEF]@YBU0iF]@aBU0=F]@MJeP03E[EBU5:D009>L`03
AS4mkcg_008icP03<H`YBRU:008U:@037>LHaQS6008DY@8@Q0<<H`L8@PD<H`l@Q14<H`H@Q08DY@8H
aP037>LQ224800Aoo`03001oogoo035oo`03001oogoo009oo`8mk`03CW=F]EJe009BU003AS4e[CF]
008]J`<YBP8]J`03<H`e[CF]008e[@/icP@e[@XaS0de[@TicP<e[@<icPDmk`8icP8e[@DaS0<e[@Li
cP<e[@DaS0<e[@8icPDmk`DicP8e[@03<H`]Jbe[008YBP039BTYBRU:008aS003@Q1>Ldic009F]@03
DYA6<DHa008icP03:DXQ224800<Q208U:@8]J`03<H`icSW>00M2408mk`<icP8e[@PaS0De[@LicP03
?NlicSW>00XicP8e[@03;F/YBRU:008Q20039BTaS36<00Aoo`03001oogoo011oo`009Goo00@007oo
Oomoo`8U:@03;F/e[CF]008icP03@Q16<DHa009:DP=>L`iBU0=F]@=JePMNmb1S60ENm`=JePEF]@YB
U0iF]@aBU0=F]@MJeP03E[EBU5:D009>L`03AS4mkcg_008icP03<H`YBRU:008U:@037>LHaQS6008D
Y@8@Q0<<H`L8@PD<H`l@Q14<H`H@Q08DY@8HaP037>LQ224800Aoo`03001oogoo035oo`03001oogoo
009oo`8mk`03CW=F]EJe009BU003AS4e[CF]008]J`<YBP8]J`03<H`e[CF]008e[@/icP@e[@XaS0de
[@TicP<e[@<icPDmk`8icP8e[@DaS0<e[@LicP<e[@DaS0<e[@8icPDmk`DicP8e[@03<H`]Jbe[008Y
BP039BTYBRU:008aS003@Q1>Ldic009F]@03DYA6<DHa008icP03:DXQ224800<Q208U:@8]J`03<H`i
cSW>00M2408mk`<icP8e[@PaS0De[@LicP03?NlicSW>00XicP8e[@03;F/YBRU:008Q20039BTaS36<
00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8YBP03;F/e[CF]008mk`03@Q1:DTYB009>La5B
U0=F]@=JePYNma5S60AW>@]S60ANm`=JeP=F]@aBU0aF]@aBU003E[EJeU[F00MJeP03E[EBU5:D009:
DP03@Q0icSW>008e[@03;F/U:BDY008Q20036<HDYABU00@@Q0l<Ha0@Q14<H`D@Q08DY@8HaP037>LQ
224800Aoo`03001oogoo035oo`03001oogoo009oo`8mk`03CW=F]EJe009BU003AS4e[CF]008YBP03
9BTYBRU:008]J`03<H`e[CF]008e[@DicPDmk`<icP<e[@DaS0Le[@DicPDe[@DicPTe[@PicP<e[@@a
S0De[@HicP8e[@DaS08e[@<icPLmk`<icP8e[@03<H`]Jbe[008YBP039BTYBRU:008aS003@Q1BU5:D
009F]@03DYA6<DHa008e[@03:DXU:BDY008Q20039BTYBRU:008aS003=JdicSW>00<mk`9240@mk`<i
cP<e[@LaS0Le[A8icP8e[@03;F/U:BDY00<Q208]J`Aoo`03001oogoo011oo`009Goo0P000Woo0RU:
00<]JcF]=Jd00Sg_00=244YBBU800Tic4E:D0eJe0e[F2Ukg4F<H16Li2f<H15kg0e[F0eJe35:D35Je
35:D00=F]E[FF]H01e[F00=F]E:DDY@00TYB00=243W>>Lh00SF]00<]JbDY9BT00R4800<HaQBU5:D0
11243`aS41244@aS1A240QBU0QS600<Lib488@P00goo0P00<goo0P000goo0Sg_00=>LeJeE[D00U:D
00=6<CF]=Jd00RU:00<U:BU::DX00Re[00<aS3F]=Jd00SF]1CW>1Cg_0cW>0cF]1C6<1cF]1CW>1CF]
1CW>2CF]23W>0cF]136<1CF]1SW>0SF]1C6<0SF]0cW>1cg_0cW>0SF]00<aS2e[;F/00RU:00<U:BU:
:DX00S6<00=245:DDY@00UJe00=BU4HaAS400SF]00<YBRDY9BT00R4800<U:BU::DX00S6<00<e[CW>
>Lh00cg_0T8@13g_0cW>0cF]1c6<1cF]4SW>0SF]00<]JbDY9BT00b480Re[17oo00<007ooOol047oo
000UOol01000Oomoogoo0RU:00<aS3W>>Lh00T8@00=6<DicCW<00e:D1eJe2E:D0eJe0e[F35kg3f<H
2VLi1f<H0ekg15[F00=F]E:DDY@02U:D35Je35:D00=F]E[FF]H01e[F00=F]DicCW<00TYB00=243F]
=Jd00Re[00<U:B488@P00QS60aBU112440aS4A243`aS1A240QBU0QS600<LibDY9BT017oo00<007oo
Ool0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00U:D00=6<CF]=Jd00RDY00<Q22DY9BT00RU:00<a
S3F]=Jd00SF]0cW>23g_0SW>33F]2SW>53F]1CW>33F]00<icSg_?Nl00Sg_00<icSF]=Jd01C6<0SF]
00<icSg_?Nl00Sg_0d8@0cg_0SW>0SF]00<aS2e[;F/00RU:00<U:BU::DX00SF]00=244icCW<00UJe
00=BU4HaAS400SF]00<YBRDY9BT00RU:00<]Jc6<<H`00cF]1CW>13g_1cW>43F]1CW>13g_23W>0SF]
00<]JbDY9BT00b480Re[17oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<aS3W>>Lh00T8@
00=:DTicCW<00U:D2UJe1E:D1EJe1E[F35kg2f<H46Li1F<H00=Nme[FF]H00U[F0eJe2U:D35Je1E:D
0Tic1E:D00=F]E[FF]H01e[F00=BU4icCW<00THa00<mkcF]=Jd00RU:00<Q21cW7>L00aBU11245PaS
3a243@aS11240aBU0QS600<LibDY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[F
F]H00UJe00=6<C6<<H`00RDY0b480RU:00<aS3F]=Jd00SF]0cW>0Sg_1D8@00<mkcW>>Lh00SW>23F]
33W>5cF]1cW>1cF]00<icSg_?Nl00Sg_00<icSF]=Jd00SF]0c6<0SF]00<icSg_?Nl00Sg_1D8@00<m
kcW>>Lh00SF]00<aS2e[;F/00bU:0Re[0SF]00=244icCW<00U:D00=>Ld8@@Q000SF]00<]JbU::DX0
0Re[00<aS3F]=Jd01cF]3cW>3cF]1CW>0Sg_23W>0SF]00<]JbDY9BT00QcW00<Q22e[;F/017oo00<0
07ooOol047oo000UOol01000Oomoogoo0Re[00<aS3W>>Lh00T8@00=:DTicCW<00U:D2UJe1E:D1EJe
1E[F35kg2f<H46Li1F<H00=Nme[FF]H00U[F0eJe2U:D35Je1E:D0Tic1E:D00=F]E[FF]H01e[F00=B
U4icCW<00THa00<mkcF]=Jd00RU:00<Q21cW7>L00aBU11245PaS3a243@aS11240aBU0QS600<LibDY
9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00UJe00=6<C6<<H`00RDY0b48
0RU:00<aS3F]=Jd00SF]0cW>0Sg_1D8@00<mkcW>>Lh00SW>23F]33W>5cF]1cW>1cF]00<icSg_?Nl0
0Sg_00<icSF]=Jd00SF]0c6<0SF]00<icSg_?Nl00Sg_1D8@00<mkcW>>Lh00SF]00<aS2e[;F/00bU:
0Re[0SF]00=244icCW<00U:D00=>Ld8@@Q000SF]00<]JbU::DX00Re[00<aS3F]=Jd01cF]3cW>3cF]
1CW>0Sg_23W>0SF]00<]JbDY9BT00QcW00<Q22e[;F/017oo00<007ooOol047oo000UOol01000Oomo
ogoo0Re[00<e[Cg_?Nl00T8@00=:DU:DDY@00eJe1E[F1UJe0e:D1EJe0e[F3Ukg2f<H4FLi16<H0ekg
0U[F0eJe35:D2UJe1E:D0Tic1E:D00=F]E[FF]H01E[F0UJe00=BU4YBBU800T8@00<icS6<<H`00RU:
00<Q21S66<H00QBU00<@Q0aS36<01@aS2A242`aS3Q243@aS11240aBU0QS600<Q22DY9BT017oo00<0
07ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00UJe00=6<C6<<H`00RDY00<Lib488@P00RU:
00<]Jc6<<H`00SF]00<icSg_?Nl00Sg_1D8@00<mkcW>>Lh00SW>1SF]43W>3CF]1c6<00<e[CW>>Lh0
1CW>1cF]0cW>0Sg_00<icSF]=Jd00SF]0c6<0SF]0cW>0cg_0T8@0cg_0SF]0S6<1Re[0S6<0SW>00=2
44HaAS400TYB00=6<Cg_?Nl00SF]0be[0S6<00<e[CW>>Lh00cW>2CF]33W>1CF]0c6<1CF]1CW>0cg_
1cW>0SF]00<]JbDY9BT00QcW00<Q22e[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0Re[
00<e[Cg_?Nl00T8@00=:DU:DDY@00eJe1E[F1UJe0e:D1EJe0e[F3Ukg2f<H4FLi16<H0ekg0U[F0eJe
35:D2UJe1E:D0Tic1E:D00=F]E[FF]H01E[F0UJe00=BU4YBBU800T8@00<icS6<<H`00RU:00<Q21S6
6<H00QBU00<@Q0aS36<01@aS2A242`aS3Q243@aS11240aBU0QS600<Q22DY9BT017oo00<007ooOol0
<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00UJe00=6<C6<<H`00RDY00<Lib488@P00RU:00<]Jc6<
<H`00SF]00<icSg_?Nl00Sg_1D8@00<mkcW>>Lh00SW>1SF]43W>3CF]1c6<00<e[CW>>Lh01CW>1cF]
0cW>0Sg_00<icSF]=Jd00SF]0c6<0SF]0cW>0cg_0T8@0cg_0SF]0S6<1Re[0S6<0SW>00=244HaAS40
0TYB00=6<Cg_?Nl00SF]0be[0S6<00<e[CW>>Lh00cW>2CF]33W>1CF]0c6<1CF]1CW>0cg_1cW>0SF]
00<]JbDY9BT00QcW00<Q22e[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<e[Cg_
?Nl00THa00=:DU:DDY@00UJe25[F35Je0e[F2Ukg3f<H4FLi16<H0ekg0U[F0eJe35:D25Je1e:D0Tic
1E:D0eJe1E[F0UJe00=BU4YBBU800T8@00<e[Be[;F/00RDY00<LiaBU5:D00Q2420aS2Q242PaS3Q24
3`aS0Q240aBU0QS600<Q22DY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H0
0UJe00=6<C6<<H`00R4800<Lib488@P00RDY00<]Jc6<<H`00SF]00<icSg_?Nl00Sg_0d8@0cg_13W>
23F]3cW>1CF]0S6<1CF]1c6<00<e[CW>>Lh00SW>0cg_0SW>00<e[C6<<H`00cF]1CW>2SF]13W>1Cg_
00<icSF]=Jd00S6<1Be[00<aS3F]=Jd00SW>00<mkd8@@Q000T8@00<mkcW>>Lh00SF]0c6<0SF]00<i
cSg_?Nl00Sg_00<icSF]=Jd00SF]00<aS3F]=Jd013F]2SW>0cF]1c6<0cF]1CW>1Cg_1CW>0SF]00<]
JbDY9BT00QcW00<Q22e[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0Re[00<e[Cg_?Nl0
0THa00=>Le:DDY@00UJe2U[F25Je1E[F1ekg4V<H4fLi0f<H0Ukg0e[F0UJe3E:D1eJe3U:D0eJe0e[F
0UJe0U:D00=>LdHaAS400Sg_00<e[BU::DX00R4800<HaQBU5:D00Q2420aS2Q242PaS3a243PaS0Q24
0aBU0QS600<Q22DY9BT017oo00<007ooOol0<Goo00<007ooOol00Woo0Sg_00=BU5[FF]H00UJe00=6
<C6<<H`00R480acW0RDY00<]Jc6<<H`00SF]00<icSg_?Nl01D8@0cg_13W>2SF]3CW>1CF]0S6<1CF]
1c6<00<e[CW>>Lh01Cg_0SW>00<e[C6<<H`00c6<4CF]0cW>0Sg_0SW>00<e[C6<<H`00Re[00<YBRe[
;F/00S6<00<e[CW>>Lh00cg_13W>0cF]0S6<0cF]0SW>1Cg_00<icSF]=Jd01C6<13F]2SW>0cF]1c6<
0cF]1CW>1Cg_1CW>0SF]00<]JbDY9BT00acW0Re[17oo00<007ooOol047oo000UOol20002Ool2;F/0
0cF]?Nlmk`02AS400dicDYABU002E[D:F]H8E[D5F]H7G_LBHaPCIcT3HaP2G_L3F]H2E[D=DY@7E[D>
DY@3E[D3F]H2E[D2DY@00dicAS56<@02?Nl00cF]:DXYBP028@P00aS65:DDY@0248@836<:48@:36<?
48@>36<248@35:D26<H00b489BTU:@03Ool2000cOol20003Ool2?Nl00e:DF]IJeP02E[D00dHa<H`a
S0028@P37>L29BT00be[<H`aS002=Jd00cW>?Nlmk`05@Q03?Nl4>Lh:=Jd=>Lh5=Jd2<H`5=Jd7<H`0
0cF]>LhicP05?Nl2>Lh00cF]<H`aS003<H`A=Jd3>Lh2?Nl2>Lh00cF]<H`aS002;F/00bU:;F/]J`02
<H`00cF]>LhicP03?Nl4>Lh3=Jd2<H`3=Jd2>Lh5?Nl00cW>=Jde[@05<H`4=Jd:>Lh3=Jd7<H`3=Jd5
>Lh5?Nl5>Lh2=Jd00be[9BTU:@037>L2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2;F/0
0cF]?Nlmk`02AS400dicDYABU003F]H4G_L5F]H8E[D4F]H6G_LFHaPAIcT3HaP2G_L3F]H2E[DRDY@8
E[D2DY@00dYBAS56<@02>Lh00c6<:DXYBP028@P00aS648@@Q00:36<<48@836<?48@>36<248@35:D2
6<H00b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000e:DF]IJeP02E[D00dHa<H`a
S0028@P37>L29BT00be[<H`aS002=Jd00cW>?Nlmk`02?Nl00d8@?Nlmk`02?Nl5>Lh;=Jd7>Lh4?Nl3
>Lh:=Jd7<H`00cF]>LhicP05?Nl2>Lh3=Jd7<H`?=Jd5>Lh00cF]<H`aS003:DX2;F/2=Jd00cW>?Nlm
k`02?Nl00cW>=Jde[@02<H`00be[<H`aS002<H`00cF]>LhicP07?Nl00cW>=Jde[@07<H`3=Jd9>Lh3
=Jd7<H`5=Jd5>Lh00cg_>LhicP05>Lh2=Jd00be[9BTU:@037>L2;F/4Ool00`00Oomoo`0@Ool002Eo
o`04001oogooOol2;F/00cF]?Nlmk`02AS400dicDYABU003F]H4G_L5F]H8E[D4F]H6G_LFHaPAIcT3
HaP2G_L3F]H2E[DRDY@8E[D2DY@00dYBAS56<@02>Lh00c6<:DXYBP028@P00aS648@@Q00:36<<48@8
36<?48@>36<248@35:D26<H00b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000e:D
F]IJeP02E[D00dHa<H`aS0028@P37>L29BT00be[<H`aS002=Jd00cW>?Nlmk`02?Nl00d8@?Nlmk`02
?Nl5>Lh;=Jd7>Lh4?Nl3>Lh:=Jd7<H`00cF]>LhicP05?Nl2>Lh3=Jd7<H`?=Jd5>Lh00cF]<H`aS003
:DX2;F/2=Jd00cW>?Nlmk`02?Nl00cW>=Jde[@02<H`00be[<H`aS002<H`00cF]>LhicP07?Nl00cW>
=Jde[@07<H`3=Jd9>Lh3=Jd7<H`5=Jd5>Lh00cg_>LhicP05>Lh2=Jd00be[9BTU:@037>L2;F/4Ool0
0`00Oomoo`0@Ool002Eoo`04001oogooOol2;F/00cF]?Nlmk`02AS400dicDYABU003F]H5G_L6F]H5
E[D5F]H5G_LGHaPAIcT3HaP4G_L00e[FE[EF]@02E[DPDY@6E[D2DY@2CW<00dYB@Q124002>Lh00c6<
9BTU:@027>L00aBU48@@Q00336<2248536<<48@836<?48@>36<248@35:D26<H00b489BTU:@04Ool0
0`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000e:DG_MNm`02E[D00dHa<H`aS0029BT00acW8@PQ2002
9BT00be[<H`aS002=Jd00cW>?Nlmk`07?Nl3>Lh?=Jd5>Lh4?Nl3>Lh:=Jd7<H`00cF]>LhicP07?Nl0
0cW>=Jde[@08<H`4=Jd3>Lh8=Jd4>Lh00cF];F/]J`03:DX2<H`2>Lh5@Q000cF];F/]J`03:DX2;F/2
<H`00cW>?Nlmk`02?Nl00d8@?Nlmk`02?Nl00cW>=Jde[@07<H`3=Jd7>Lh5=Jd5<H`7=Jd=>Lh2=Jd0
0be[9BTU:@037>L2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2;F/00cF]?Nlmk`02AS40
0dicE[EF]@02F]H6G_L6F]H3E[D5F]H5G_L=HaP:IcT6HaP=IcT3HaP4G_L00e[FE[EF]@02E[DVDY@2
CW<2BU800dHa?Nlmk`02=Jd00be[9BTU:@027>L00aBU48@@Q00336<2248536<>48@536<@48@<36<4
48@35:D26<H00b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000eJeG_MNm`02F]H0
0dYB=Jde[@029BT38@P29BT00be[<H`aS002=Jd00cW>?Nlmk`05?Nl5>LhA=Jd<>Lh8=Jd5<H`3=Jd2
>Lh7?Nl00cW>=Jde[@03<H`4;F/00c6<=Jde[@07>Lh6=Jd4>Lh00cF]<H`aS003;F/2<H`2?Nl3AS42
@Q000cF]:DXYBP038@P2:DX2<H`00cW>@Q124003@Q02?Nl2>Lh3=Jd7<H`3=Jd7>LhA=Jd=>Lh2=Jd0
0be[9BTU:@037>L2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2;F/00cF]?Nlmk`02AS40
0dicE[EF]@02F]H6G_L6F]H3E[D5F]H5G_L=HaP:IcT6HaP=IcT3HaP4G_L00e[FE[EF]@02E[DVDY@2
CW<2BU800dHa?Nlmk`02=Jd00be[9BTU:@027>L00aBU48@@Q00336<2248536<>48@536<@48@<36<4
48@35:D26<H00b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000eJeG_MNm`02F]H0
0dYB=Jde[@029BT38@P29BT00be[<H`aS002=Jd00cW>?Nlmk`05?Nl5>LhA=Jd<>Lh8=Jd5<H`3=Jd2
>Lh7?Nl00cW>=Jde[@03<H`4;F/00c6<=Jde[@07>Lh6=Jd4>Lh00cF]<H`aS003;F/2<H`2?Nl3AS42
@Q000cF]:DXYBP038@P2:DX2<H`00cW>@Q124003@Q02?Nl2>Lh3=Jd7<H`3=Jd7>LhA=Jd=>Lh2=Jd0
0be[9BTU:@037>L2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2;F/00cF]?Nlmk`02AS40
0dicE[EF]@02F]H8G_L<F]H5G_L:HaP=IcT7HaP<IcT3HaP4G_L3F]H3E[D5DY@9CW<FDY@3CW<2BU80
0d8@>LhicP02<H`00bU:8@PQ20027>L00aBU48@@Q00936<?48@336<B48@>36<248@35:D26<H00b48
9BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000eJeG_MNm`02F]H00dYB=Jde[@029BT3
8@P2:DX00be[<H`aS002=Jd00cW>?Nlmk`05?Nl3>Lh7=Jd3<H`:=Jd>>Lh5=Jd5<H`3=Jd2>Lh7?Nl3
>Lh2=Jd00c6<;F/]J`02;F/00c6<=Jde[@02>Lh3?Nl3>Lh5=Jd4>Lh00cF]<H`aS002;F/00c6<=Jde
[@02@Q03BU82@Q000cF]9BTU:@027>L00b48:DXYBP02=Jd00cg_@Q124003@Q02?Nl2>Lh00cF]<H`a
S007<H`5=Jd5>LhA=Jd=>Lh2=Jd00be[8@PQ20037>L2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001o
ogooOol2;F/00cF]?Nlmk`02AS400dicE[EF]@02F]H8G_L<F]H5G_L:HaP=IcT7HaP<IcT3HaP4G_L3
F]H3E[D5DY@9CW<FDY@3CW<2BU800d8@>LhicP02<H`00bU:8@PQ20027>L00aBU48@@Q00936<?48@3
36<B48@>36<248@35:D26<H00b489BTU:@04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000eJe
G_MNm`02F]H00dYB=Jde[@029BT38@P2:DX00be[<H`aS002=Jd00cW>?Nlmk`05?Nl3>Lh7=Jd3<H`:
=Jd>>Lh5=Jd5<H`3=Jd2>Lh7?Nl3>Lh2=Jd00c6<;F/]J`02;F/00c6<=Jde[@02>Lh3?Nl3>Lh5=Jd4
>Lh00cF]<H`aS002;F/00c6<=Jde[@02@Q03BU82@Q000cF]9BTU:@027>L00b48:DXYBP02=Jd00cg_
@Q124003@Q02?Nl2>Lh00cF]<H`aS007<H`5=Jd5>LhA=Jd=>Lh2=Jd00be[8@PQ20037>L2;F/4Ool0
0`00Oomoo`0@Ool002Eoo`80009oo`8]J`03=Jdmkcg_0096<@03CW=F]EJe009JePQNm`aJePENm`MS
611W>@MS60aW>@=S60ANm`=JeP=F]@EBU0i>L`mBU0=>L`9:DP96<@03?NlicSW>008aS003:DXQ2248
008HaP035:D@Q12400T<H`D@Q0035:D@Q12401`@Q0h<H`8@Q0<DY@8HaP038@PU:BDY00=oo`8003=o
o`8000=oo`924003E[ES66<H009JeP03BU8icSW>008YBP038@PU:BDY008YBP03;F/e[CF]008e[@03
>Lhmkcg_00Dmk`<icPDe[@LaS0Pe[@hicPde[@@icPHmk`8icP8e[@03<H`]Jbe[008]J`03<H`e[CF]
008icPDmk`03>Lhe[CF]00Pe[@@aS003=JdicSW>0096<@=:DP924003<H`U:BDY00<Li`8YBP8e[@03
?Nm2448@00=2408mk`8icP03=JdaS36<00LaS0De[@8icQ@e[@HicP@mk`<icP8e[@03;F/Q224800<L
i`8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8]J`03=Je2448@009:DP03CW=F]EJe009J
ePQNm`aJeP=Nm`US611W>@US60YW>@ES60=Nm`AJeP=F]@=BU0i>L`eBU0A>L`03BU96<DHa00924003
>Lhe[CF]008]J`039BTQ2248008HaP035:D@Q12400T<H`<@Q0LDYA0@Q0@DY@H@Q0h<H`8@Q0<DY@8L
i`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`924003E[ES66<H009JeP03BU8icSW>
008YBP038@PU:BDY008YBP03;F/e[CF]008e[@03>Lhmkcg_00Dmk`<icPDe[@TaS0He[@hicPde[@Di
cPDmk`8icP8e[@03<H`]Jbe[00<]J`8e[@8icP03?Nm2448@008mk`03>Lhe[CF]00<e[@8aS0Le[@03
>Lhmkcg_0096<@=:DP8mk`03<H`U:BDY008Li`038@PYBRU:008e[@03@Q16<DHa00924003?NlicSW>
00<e[@LaS0De[@@icQ@e[@HicP@mk`<icP8e[@03;F/Q224800<Li`8]J`Aoo`03001oogoo011oo`00
9Goo00@007ooOomoo`8]J`03=Je2448@009:DP03CW=F]EJe009JePQNm`aJeP=Nm`US611W>@US60YW
>@ES60=Nm`AJeP=F]@=BU0i>L`eBU0A>L`03BU96<DHa00924003>Lhe[CF]008]J`039BTQ2248008H
aP035:D@Q12400T<H`<@Q0LDYA0@Q0@DY@H@Q0h<H`8@Q0<DY@8Li`038@PYBRU:00Aoo`03001oogoo
035oo`03001oogoo009oo`924003E[ES66<H009JeP03BU8icSW>008YBP038@PU:BDY008YBP03;F/e
[CF]008e[@03>Lhmkcg_00Dmk`<icPDe[@TaS0He[@hicPde[@DicPDmk`8icP8e[@03<H`]Jbe[00<]
J`8e[@8icP03?Nm2448@008mk`03>Lhe[CF]00<e[@8aS0Le[@03>Lhmkcg_0096<@=:DP8mk`03<H`U
:BDY008Li`038@PYBRU:008e[@03@Q16<DHa00924003?NlicSW>00<e[@LaS0De[@@icQ@e[@HicP@m
k`<icP8e[@03;F/Q224800<Li`8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8aS003>Li2
448@009:DP03DYAF]EJe009JePQNm`aJeP=Nm`MS61AW>@US60IW>@MS60=Nm`AJeP=F]@=BU0M>L`9:
DPM>L`YBU0=>L`9:DP03AS52448@008mk`03>LhaS36<008YBP039BTLiacW008HaP0348@<H`aS00T<
H`<@Q0LDYA0@Q0DDY@D@Q0h<H`8@Q0<DY@8Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo
009oo`924003E[ES66<H009JeP03BU8e[CF]008U:@<Q208YBP03;F/e[CF]008e[@03>Lhmkcg_00Lm
k`<icP<e[@XaS0@e[@licQ4e[@<icPDmk`8icP03<H`]Jbe[00<]J`8e[@8icP03?Nm2448@008mk`03
>Lhe[CF]008e[@HaS08e[@8icP03?Nm2448@0096<@03BU96<DHa008icP03;F/U:BDY008Li`038@P]
Jbe[008icP03@Q16<DHa00924003?NlicSW>00<e[@LaS0@e[@/icP`e[@LicPDmk`<icP8e[@03;F/Q
224800<Li`8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8aS003>Li2448@009:DP03DYAF
]EJe009JePQNm`aJeP=Nm`MS61AW>@US60IW>@MS60=Nm`AJeP=F]@=BU0M>L`9:DPM>L`YBU0=>L`9:
DP03AS52448@008mk`03>LhaS36<008YBP039BTLiacW008HaP0348@<H`aS00T<H`<@Q0LDYA0@Q0DD
Y@D@Q0h<H`8@Q0<DY@8Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`924003E[ES
66<H009JeP03BU8e[CF]008U:@<Q208YBP03;F/e[CF]008e[@03>Lhmkcg_00Lmk`<icP<e[@XaS0@e
[@licQ4e[@<icPDmk`8icP03<H`]Jbe[00<]J`8e[@8icP03?Nm2448@008mk`03>Lhe[CF]008e[@Ha
S08e[@8icP03?Nm2448@0096<@03BU96<DHa008icP03;F/U:BDY008Li`038@P]Jbe[008icP03@Q16
<DHa00924003?NlicSW>00<e[@LaS0@e[@/icP`e[@LicPDmk`<icP8e[@03;F/Q224800<Li`8]J`Ao
o`03001oogoo011oo`009Goo00@007ooOomoo`8aS003>Li2448@009:DP03DYAF]EJe00=Nm`AS60=N
m`aJeP=Nm`MS61AW>@US60IW>@MS60ENm`=JePAF]@03DYA>Ldic00=>L`E:DPI>L`YBU0=>L`9:DP03
AS52448@008icP03=Jd]Jbe[008YBP038@PLiacW008DY@0348@<H`aS00L<H`<@Q0XDY@h@Q0HDY@D@
Q0h<H`8@Q0035:DHaQS6008Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`924003
E[ES66<H009JeP03BU8e[CF]008U:@<Q208YBP03;F/e[CF]008e[@03>Lhmkcg_00Lmk`<icP<e[@Xa
S0@e[@`icQDe[@@icP<mk`8icP03=Jd]Jbe[00<]J`8e[@8icP03?Nm2448@00<mk`8icP8aS0D]J`03
<H`e[CF]008mk`03@Q16<DHa00=6<@8mk`8e[@03;F/U:BDY008Q20039BTaS36<008mk`=6<@924003
?NlicSW>00<e[@DaS0He[@dicPXe[@DicPPmk`8icP8e[@03;F/Q224800<Li`8]J`Aoo`03001oogoo
011oo`009Goo00@007ooOomoo`8aS003>Li2448@009:DP03DYAJeU[F009Nm`ES60ENm`YJeP=Nm`MS
61AW>AQS60ENm`03F]IF]EJe009F]@03DYA>Ldic009>L`Q:DPA>L`YBU003CW=:DTYB0096<@03@Q0m
kcg_008icP03<H`]Jbe[008U:@038@PHaQS6008DY@0348@<H`aS00L<H`<@Q0`DY@`@Q0HDY@D@Q0h<
H`8@Q0035:DHaQS6008Li`038@PYBRU:00Aoo`03001oogoo035oo`03001oogoo009oo`924003E[ES
66<H009JeP03BU8e[CF]008U:@037>LQ2248008YBP03;F/e[CF]008e[@03>Lhmkcg_00Lmk`<icP<e
[@TaS0<e[@TicQ`e[@8icP<mk`8icP03=JdaS36<008]J`03<H`e[CF]008icPHmk`8icP8aS003;F/Y
BRU:008YBP03;F/icSW>009240=:DP96<@03@Q0icSW>008aS003:DXU:BDY008U:@03;F/e[CF]008m
k`=6<@924003?NlicSW>00he[@dicPXe[@DicPPmk`8icP8e[@03;F/Q224800<Li`8]J`Aoo`03001o
ogoo011oo`005goo0`0017oo0P001Goo00@007ooOomoo`8aS003>Li2448@009:DP03DYAJeU[F009N
m`ES60ENm`YJeP=Nm`MS61AW>AQS60ENm`03F]IF]EJe009F]@03DYA>Ldic009>L`Q:DPA>L`YBU003
CW=:DTYB0096<@03@Q0mkcg_008icP03<H`]Jbe[008U:@038@PHaQS6008DY@0348@<H`aS00L<H`<@
Q0`DY@`@Q0HDY@D@Q0h<H`8@Q0035:DHaQS6008Li`038@PYBRU:00Aoo`03001oogoo02Aoo`<000Ao
o`8000Aoo`03001oogoo009oo`924003E[ES66<H009JeP03BU8e[CF]008U:@037>LQ2248008YBP03
;F/e[CF]008e[@03>Lhmkcg_00Lmk`<icP<e[@TaS0<e[@TicQ`e[@8icP<mk`8icP03=JdaS36<008]
J`03<H`e[CF]008icPHmk`8icP8aS003;F/YBRU:008YBP03;F/icSW>009240=:DP96<@03@Q0icSW>
008aS003:DXU:BDY008U:@03;F/e[CF]008mk`=6<@924003?NlicSW>00he[@dicPXe[@DicPPmk`8i
cP8e[@03;F/Q224800<Li`8]J`Aoo`03001oogoo011oo`005goo00@007ooOol0009oo`04001oogoo
0004Ool01000Oomoogoo0S6<00<icT8@@Q000TYB00=BU5[FF]H00Ukg1V<H15kg2U[F0ekg1f<H5VLi
5f<H15kg0e[F0UJe0e:D0Tic24YB1Dic1e:D0dic0TYB0THa00<mkcW>>Lh00SF]00<]JbU::DX00RDY
00<LiaS66<H00QBU00<@Q0aS36<01@aS11243ABU312421BU0a243PaS0Q2400<DYAS66<H00QcW00<Q
22U::DX017oo00<007ooOol097oo00@007ooOol0009oo`04001oogoo0003Ool00`00Oomoo`02Ool2
@Q000eJeHaQS6002F]H00dYB=Jde[@028@P00acW8@PQ20029BT00be[=Jde[@02=Jd3>Lh7?Nl3>Lh3
=Jd9<H`00cF]>LhicP09>Lh?=Jd5>Lh5=Jd00c6<=Jde[@07>Lh00cF]<H`aS003<H`2=Jd3>Lh5?Nl2
>Lh2<H`00be[9BTU:@029BT00be[>LhicP02AS43CW<2AS400cg_<H`aS002;F/5:DX00c6<=Jde[@02
?Nl3@Q02?Nl00cW>=Jde[@03=Jd7>Lh7=Jd8>Lh>=Jd3>Lh8?Nl2>Lh2=Jd00bU:8@PQ20026<H00acW
;F/]J`04Ool00`00Oomoo`0@Ool001Moo`04001oogoo0002Ool01000Oomoo`0017oo0`0000Aooc6<
<H`icP92409:DP03DYAJeU[F009Nm`IS60ANm`YJeP=Nm`MS61IW>AMS60ANm`=JeP9F]@=BU09>L`Q:
DPE>L`MBU0=>L`9:DP96<@03?NlicSW>008e[@03;F/YBRU:008U:@037>LHaQS6008DY@0348@<H`aS
00D<H`@@Q0dDY@`@Q0PDY@<@Q0h<H`8@Q0035:DHaQS6008Li`038@PYBRU:00=oo`8002Ioo`04001o
ogoo0002Ool01000Oomoo`000goo0`000Woo0T8@00=F]F<HHaP00U[F00=:DSF]=Jd00R4800<Lib48
8@P00RDY00<]JcF]=Jd00SF]0cW>1cg_0cW>0cF]2C6<00<e[CW>>Lh02CW>3cF]1CW>1CF]00<aS3F]
=Jd01cW>00<e[C6<<H`00c6<0SF]0cW>1Cg_0SW>0S6<00<]JbDY9BT00RDY00<]JcW>>Lh00THa0dic
0THa00<mkc6<<H`00Re[1BU:00<aS3F]=Jd00Sg_0d8@0Sg_00<icSF]=Jd00cF]1cW>1cF]23W>3SF]
0cW>23g_0SW>0SF]00<YBR488@P00QS600<Libe[;F/00goo0P004Woo000GOol30003Ool01000Oomo
o`0017oo00@007ooOomoo`8aS003>Li6<DHa009>L`03DYAJeU[F009Nm`IS60ANm`YJeP=Nm`MS61QW
>AES60ENm`9JeP9F]@=BU09>L`Y:DP=>L`MBU09>L`03BU96<DHa00924003?NlicSW>008aS003;F/U
:BDY008Q20037>LHaQS6008DY@0348@<H`aS00D<H`@@Q0<DY@DHaPDDY@X@Q0XDY@<@Q0h<H`8@Q003
5:DHaQS6008Li`038@PYBRU:00Aoo`03001oogoo02Aoo`<000=oo`04001oogoo0003Ool00`00Oomo
o`02Ool2@Q000eJeHaQS6002F]H00dYB<H`aS0028@P00acW8@PQ20029BT00be[=Jde[@02=Jd3>Lh7
?Nl3>Lh3=Jd7<H`3=Jd9>LhA=Jd5>Lh5=Jd00c6<=Jde[@02=Jd5>Lh8=Jd5>Lh3?Nl2>Lh2=Jd00be[
9BTU:@029BT00be[>LhicP02BU800e:DCW=>L`02AS400cW>;F/]J`05:DX2;F/00cF]>LhicP02?Nl3
@Q02?Nl5=Jd00cW>?Nlmk`03?Nl4>Lh5=Jd8>Lh>=Jd3>Lh8?Nl2>Lh2<H`00bU:8@PQ20026<H00acW
;F/]J`04Ool00`00Oomoo`0@Ool001Qoo`03001oogoo009oo`04001oogoo0004Ool01000Oomoogoo
0S6<00<mkdHaAS400Tic00=F]E[FF]H00Ukg1V<H15kg2U[F0ekg1F<H6fLi5V<H0ekg0U[F0eJe0U:D
0Tic2TYB0dic1E:D14ic00=:DTHaAS400T8@00<icSF]=Jd00Re[00<YBRDY9BT00QcW00<HaQBU5:D0
0a241`aS11240aBU1AS61aBU21242QBU0a243PaS0Q2400<DYAS66<H00QcW00<U:BU::DX017oo00<0
07ooOol09Goo00<007ooOol00Woo00@007ooOol000=oo`03001oogoo009oo`924003E[ES66<H009J
eP03BU8aS36<008Q20037>LQ2248008U:@03;F/e[CF]008e[@<icPPmk`8icP<e[@@aS0De[@XicPle
[@LicPDe[@<aS0De[A4icP03?NlicSW>008e[@03:DXU:BDY008U:@03;F/mkcg_009:DP03DYA>Ldic
00924003=JdYBRU:00<U:@8]J`8aS003=JdicSW>00Dmk`8icP03=JdaS36<008e[@03>Li2448@00=2
408mk`8icP8e[@03<H`e[CF]008e[@DicQ0e[@8icPPmk`8icP8aS003:DXQ2248008HaP037>L]Jbe[
00Aoo`03001oogoo011oo`0067oo0`000goo0P001Goo00@007ooOomoo`8aS003?Nm6<DHa009>L`03
E[EJeU[F009Nm`IS60ANm`YJeP=Nm`ES61]W>AIS60=Nm`9JeP=F]@9BU09>L`Y:DP=>L`EBU0A>L`03
BU96<DHa00924003>Lhe[CF]008]J`03:DXU:BDY008Li`036<HDYABU00<@Q0L<H`@@Q0<DY@DHaPLD
Y@P@Q0XDY@<@Q0h<H`8@Q0035:DHaQS6008Li`039BTYBRU:00Aoo`03001oogoo02Eoo`<000=oo`80
00Aoo`03001oogoo009oo`924003E[ES66<H009JeP03BU8aS36<008Q20037>LQ2248008U:@03;F/e
[CF]008e[@<icPPmk`8icP<e[@@aS0De[@XicPle[@LicPDe[@<aS0De[A4icP03?NlicSW>008e[@03
:DXU:BDY008U:@03;F/mkcg_009:DP03DYA>Ldic00924003=JdYBRU:00<U:@8]J`8aS003=JdicSW>
00Dmk`8icP03=JdaS36<008e[@03>Li2448@00=2408mk`8icP8e[@03<H`e[CF]008e[@DicQ0e[@8i
cPPmk`8icP8aS003:DXQ2248008HaP037>L]Jbe[00Aoo`03001oogoo011oo`009Goo00@007ooOomo
o`8e[@03?Nm6<DHa009>L`03E[EJeU[F00QS60ANm`YJeP=Nm`ES61]W>AQS60=Nm`9JeP03E[EBU5:D
009>L`Y:DP=>L`EBU0A>L`03BU92448@008mk`03>LhaS36<008]J`039BTQ2248008Li`036<HDYABU
00<@Q0L<H`@@Q0<DY@LHaPDDY@P@Q0XDY@<@Q0`<H`@@Q0035:DHaQS6008Li`039BT]Jbe[00Aoo`03
001oogoo035oo`03001oogoo009oo`924003F]IS66<H009JeP03BU8aS36<008Q20037>LQ2248008U
:@03;F/e[CF]008e[@<icPPmk`8icP<e[@8aS0De[@`icPle[@PicP@e[@HaS0@e[@03>Lhmkcg_00<m
k`@icP<e[@DicP8aS003:DXU:BDY008U:@03;F/mkcg_009>L`03E[E>Ldic00924003<H`U:BDY008Q
20039BT]Jbe[008e[@03>Lhmkcg_00<mk`8icP<e[@8aS08e[@03>Li2448@00=2408mk`8e[@<aS0@e
[@DicQ0e[@8icPPmk`8icP8aS003:DXLiacW008HaP037>L]Jbe[00Aoo`03001oogoo011oo`009Goo
00@007ooOomoo`8e[@03?Nm6<DHa009>L`03E[EJeU[F00QS60ANm`YJeP=Nm`ES61]W>AQS60=Nm`9J
eP03E[EBU5:D009>L`Y:DP=>L`EBU0A>L`03BU92448@008mk`03>LhaS36<008]J`039BTQ2248008L
i`036<HDYABU00<@Q0L<H`@@Q0<DY@LHaPDDY@P@Q0XDY@<@Q0`<H`@@Q0035:DHaQS6008Li`039BT]
Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`924003F]IS66<H009JeP03BU8aS36<008Q2003
7>LQ2248008U:@03;F/e[CF]008e[@<icPPmk`8icP<e[@8aS0De[@`icPle[@PicP@e[@HaS0@e[@03
>Lhmkcg_00<mk`@icP<e[@DicP8aS003:DXU:BDY008U:@03;F/mkcg_009>L`03E[E>Ldic00924003
<H`U:BDY008Q20039BT]Jbe[008e[@03>Lhmkcg_00<mk`8icP<e[@8aS08e[@03>Li2448@00=2408m
k`8e[@<aS0@e[@DicQ0e[@8icPPmk`8icP8aS003:DXLiacW008HaP037>L]Jbe[00Aoo`03001oogoo
011oo`009Goo00@007ooOomoo`8e[@03?Nm6<DHa009>L`03E[EJeU[F00QS60ANm`YJeP=Nm`ES61]W
>AQS60=Nm`9JeP03E[EBU5:D009>L`Y:DP=>L`EBU09>L`9:DP03AS52448@008mk`03=JdaS36<008Y
BP039BTQ2248008Li`036<HDYABU00<@Q0D<H`H@Q0<DY@DHaPLDY@P@Q0XDY@D@Q0X<H`@@Q0035:DH
aQS6008Li`039BT]Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`924003F]IS66<H009JeP03
BU8aS36<008Q20037>LQ2248008U:@03;F/e[CF]008e[@<icP<mk`9240<mk`8icP8e[@<aS0De[@hi
cPde[@PicP@e[@PaS08e[@03>Lhmkcg_009240<mk`8icPPe[@8aS003:DXU:BDY008U:@03<Ha2448@
009>L`03DYA>Ldic008mk`03<H`U:BDY008Q20039BT]Jbe[008e[@<icP8mk`<icPLe[@03>Lhmkcg_
00<mk`8icP8e[@<aS0@e[@DicQ0e[@8icPPmk`8icP8aS003:DXQ2248008HaP037>L]Jbe[00Aoo`03
001oogoo011oo`009Goo00@007ooOomoo`8e[@03?Nm6<DHa009>L`03E[EJeU[F00QS60ANm`YJeP=N
m`ES61]W>AQS60=Nm`9JeP03E[EBU5:D009>L`Y:DP=>L`EBU09>L`9:DP03AS52448@008mk`03=Jda
S36<008YBP039BTQ2248008Li`036<HDYABU00<@Q0D<H`H@Q0<DY@DHaPLDY@P@Q0XDY@D@Q0X<H`@@
Q0035:DHaQS6008Li`039BT]Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`924003F]IS66<H
009JeP03BU8aS36<008Q20037>LQ2248008U:@03;F/e[CF]008e[@<icP<mk`9240<mk`8icP8e[@<a
S0De[@hicPde[@PicP@e[@PaS08e[@03>Lhmkcg_009240<mk`8icPPe[@8aS003:DXU:BDY008U:@03
<Ha2448@009>L`03DYA>Ldic008mk`03<H`U:BDY008Q20039BT]Jbe[008e[@<icP8mk`<icPLe[@03
>Lhmkcg_00<mk`8icP8e[@<aS0@e[@DicQ0e[@8icPPmk`8icP8aS003:DXQ2248008HaP037>L]Jbe[
00Aoo`03001oogoo011oo`009Goo0P000Woo0SF]00<mkdHaAS400Tic00=F]EkgG_L00f<H0VLi0f<H
15kg2U[F0ekg1F<H7FLi5f<H0Ukg0U[F00=F]E:DDY@00dic2DYB2Tic0TYB00=6<Cg_?Nl00SW>00<e
[Be[;F/00RU:00<Q21cW7>L00QS60aBU0Q241PaS1Q241ABU0aS61aBU1Q2431BU1A242PaS112400<D
YAS66<H00QcW00<U:Be[;F/00goo0P00<goo0P000goo0T8@00=JeV<HHaP00Ukg00=:DS6<<H`00R48
00<Lib488@P00RU:00<]JcF]=Jd00SF]00<icSg_?Nl00Sg_0d8@0cg_0SW>0SF]0c6<1CF]3cW>33F]
2SW>0cF]1c6<0SF]00<icSg_?Nl00d8@0Sg_0SW>0cF]1C6<0Re[00<YBRDY9BT00RU:00<aS48@@Q00
0Tic00=BU4icCW<00Sg_00<]JbDY9BT00R4800<YBS6<<H`00SF]23W>3cF]1C6<13F]1CW>3cF]0cW>
23g_0SW>0SF]00<YBR488@P00QS600<Libe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo
0SF]00<mkdHaAS400Tic00=F]EkgG_L00f<H0VLi0f<H15kg2U[F0ekg16<H7VLi5f<H0Ukg0U[F0eJe
0U:D00=>LdYBBU801dYB24ic14YB00=243g_?Nl00SW>00<aS2e[;F/00RDY00<Q21cW7>L00QS600<D
YA2448@00Q241PaS1Q243aBU1Q2431BU1A242PaS112400<DYAS66<H00QcW00<U:Be[;F/017oo00<0
07ooOol0<Goo00<007ooOol00Woo0T8@00=JeV<HHaP00Ukg00=:DSF]=Jd00R4800<Lib488@P00RU:
00<]JcF]=Jd00SF]00<icSg_?Nl00Sg_0d8@0Sg_0cW>0SF]1C6<2cF]2cW>23F]2SW>0cF]1c6<0SF]
00<icSg_?Nl00d8@0Sg_0SW>00<e[C6<<H`00c6<0Re[1BU:0Re[00<e[D8@@Q000Tic00=BU4YBBU80
0Sg_00<]JbDY9BT00RDY00<YBS6<<H`00SF]3CW>0SF]0c6<1Be[1C6<13F]1SW>33F]1CW>23g_0SW>
0SF]00<]Jb488@P00QS600<Libe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0SF]00<m
kdHaAS400Tic00=F]EkgG_L00f<H0VLi0f<H15kg2U[F0ekg16<H7VLi5f<H0Ukg0U[F0eJe0U:D00=>
LdYBBU801dYB24ic14YB00=243g_?Nl00SW>00<aS2e[;F/00RDY00<Q21cW7>L00QS600<DYA2448@0
0Q241PaS1Q243aBU1Q2431BU1A242PaS112400<DYAS66<H00QcW00<U:Be[;F/017oo00<007ooOol0
<Goo00<007ooOol00Woo0T8@00=JeV<HHaP00Ukg00=:DSF]=Jd00R4800<Lib488@P00RU:00<]JcF]
=Jd00SF]00<icSg_?Nl00Sg_0d8@0Sg_0cW>0SF]1C6<2cF]2cW>23F]2SW>0cF]1c6<0SF]00<icSg_
?Nl00d8@0Sg_0SW>00<e[C6<<H`00c6<0Re[1BU:0Re[00<e[D8@@Q000Tic00=BU4YBBU800Sg_00<]
JbDY9BT00RDY00<YBS6<<H`00SF]3CW>0SF]0c6<1Be[1C6<13F]1SW>33F]1CW>23g_0SW>0SF]00<]
Jb488@P00QS600<Libe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0SF]00<mkdHaAS40
0Tic00=F]EkgG_L00f<H0VLi0f<H15kg25[F15kg1F<H7VLi5f<H15kg00=JeUJeE[D00U:D00=>LdYB
BU801dYB24ic0TYB0THa00=243g_?Nl00SF]00<aS2U::DX00RDY00<Q21cW7>L00QS600<DYA2448@0
0Q2420aS11243ABU212431BU1A242PaS0Q240aBU0QS60R4800<U:Be[;F/017oo00<007ooOol0<Goo
00<007ooOol00Woo0T8@00=JeV<HHaP00Ukg00=:DSF]=Jd00RDY00<Lib488@P00RDY00<]JcF]=Jd0
0SF]00<icSg_?Nl00Sg_0d8@0Sg_00<icSF]=Jd00SF]1C6<3CF]2SW>1cF]2SW>0cF]136<00<]Jc6<
<H`00SF]00<icSg_?Nl01D8@0Sg_00<e[C6<<H`00be[1bU:0Re[00<icT8@@Q000TYB00=>LdYBBU80
0Sg_00<aS2DY9BT00RDY00<YBS6<<H`00SF]1CW>00<e[CW>>Lh01CW>0SF]00<aS2e[;F/00bU:12e[
0S6<1CF]1SW>33F]1CW>0Sg_1CW>00<mkcW>>Lh00SF]00<]Jb488@P00QS600<Libe[;F/017oo00<0
07ooOol047oo000UOol01000Oomoogoo0SF]00<mkdHaAS400Tic00=F]EkgG_L00f<H0VLi0f<H15kg
25[F15kg1F<H7VLi5f<H15kg00=JeUJeE[D00U:D00=>LdYBBU801dYB24ic0TYB0THa00=243g_?Nl0
0SF]00<aS2U::DX00RDY00<Q21cW7>L00QS600<DYA2448@00Q2420aS11243ABU212431BU1A242PaS
0Q240aBU0QS60R4800<U:Be[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0T8@00=JeV<HHaP0
0Ukg00=:DSF]=Jd00RDY00<Lib488@P00RDY00<]JcF]=Jd00SF]00<icSg_?Nl00Sg_0d8@0Sg_00<i
cSF]=Jd00SF]1C6<3CF]2SW>1cF]2SW>0cF]136<00<]Jc6<<H`00SF]00<icSg_?Nl01D8@0Sg_00<e
[C6<<H`00be[1bU:0Re[00<icT8@@Q000TYB00=>LdYBBU800Sg_00<aS2DY9BT00RDY00<YBS6<<H`0
0SF]1CW>00<e[CW>>Lh01CW>0SF]00<aS2e[;F/00bU:12e[0S6<1CF]1SW>33F]1CW>0Sg_1CW>00<m
kcW>>Lh00SF]00<]Jb488@P00QS600<Libe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo
0SF]00<mkdHaAS400Tic00=F]EkgG_L00f<H0VLi0f<H15kg25[F15kg1F<H7VLi5f<H15kg00=JeUJe
E[D00U:D0dic1dYB1dic0dYB0THa00=243W>>Lh00SF]00<]JbU::DX00RDY00<LiaS66<H00aBU1124
20aS1A2431BU212431BU1a241`aS0a240aBU0QS60R4800<U:Be[;F/017oo00<007ooOol0<Goo00<0
07ooOol00Woo0T8@00=JeV<HHaP00Ukg00=:DSF]=Jd00RDY00<Lib488@P00RDY00<]Jc6<<H`00SF]
00<icSg_?Nl00Sg_00=243g_?Nl00Sg_00<icSF]=Jd00SF]1S6<3SF]2SW>1CF]2SW>0cF]136<00<]
Jc6<<H`00SF]00<icSg_?Nl01D8@0Sg_00<icSF]=Jd00Re[0bU:0RDY0bU:0S6<00<icT8@@Q000TYB
00=>LdHaAS400Sg_00<aS2U::DX00bU:0S6<0cF]0SW>0cF]1cW>0SF]00<aS2e[;F/00bU:0Re[136<
0cF]23W>33F]1CW>0Sg_1CW>00<mkcW>>Lh00SF]00<]Jb488@P00QS600<Libe[;F/017oo00<007oo
Ool047oo000UOol01000Oomoogoo0SF]00<mkdHaAS400Tic00=F]EkgG_L00V<H1FLi00=S65kgG_L0
0Ukg25[F15kg1F<H7VLi5f<H15kg00=JeUJeE[D00e:D14ic0dYB2Dic00=:DTHaAS400T8@00<mkcW>
>Lh00S6<00<]JbDY9BT00R4800<LiaS66<H00aBU112420aS1a2421BU2Q243QBU1A241`aS0a240QBU
0aS60R4800<U:Be[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0T8@00=JeV<HHaP00Ukg00=:
DSF]=Jd00RDY00<Lib488@P00RDY00<]Jc6<<H`00SF]00<icSg_?Nl00d8@13g_00<icSF]=Jd00SF]
1S6<5CF]00<icSF]=Jd01CF]2SW>0cF]2C6<00<icSg_?Nl01d8@00<mkcF]=Jd00S6<00<YBRDY9BT0
0RDY00<YBRe[;F/00S6<00<icTHaAS400TYB00=>LdHaAS400Sg_00<e[Be[;F/00RU:00<]Jc6<<H`0
1cF]23W>0cF]2C6<1CF]23W>33F]1CW>23g_0SW>0SF]00<]Jb488@P00QS600<Libe[;F/017oo00<0
07ooOol047oo000UOol01000Oomoogoo0SF]00<mkdHaAS400Tic00=F]EkgG_L00V<H1FLi00=S65kg
G_L00Ukg25[F15kg1F<H7VLi5f<H15kg00=JeUJeE[D00e:D14ic0dYB2Dic00=:DTHaAS400T8@00<m
kcW>>Lh00S6<00<]JbDY9BT00R4800<LiaS66<H00aBU112420aS1a2421BU2Q243QBU1A241`aS0a24
0QBU0aS60R4800<U:Be[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0T8@00=JeV<HHaP00Ukg
00=:DSF]=Jd00RDY00<Lib488@P00RDY00<]Jc6<<H`00SF]00<icSg_?Nl00d8@13g_00<icSF]=Jd0
0SF]1S6<5CF]00<icSF]=Jd01CF]2SW>0cF]2C6<00<icSg_?Nl01d8@00<mkcF]=Jd00S6<00<YBRDY
9BT00RDY00<YBRe[;F/00S6<00<icTHaAS400TYB00=>LdHaAS400Sg_00<e[Be[;F/00RU:00<]Jc6<
<H`01cF]23W>0cF]2C6<1CF]23W>33F]1CW>23g_0SW>0SF]00<]Jb488@P00QS600<Libe[;F/017oo
00<007ooOol047oo000UOol20002Ool2=Jd00cg_AS56<@02CW<00eJeG_MNm`02HaP5IcT3HaP2G_L8
F]H4G_L3HaPPIcTIHaP2G_L00e[FE[EF]@02E[D00e:DCW=>L`0<CW<3BU82AS42@Q000cg_=Jde[@02
<H`00bU:9BTU:@028@P00acW6<HHaP025:D548@836<948@55:D;48@>5:D748@336<548@25:D00aS6
7>LLi`028@P00bDY;F/]J`03Ool2000cOol20003Ool2@Q000e[FHaQS6002G_L00dYB=Jde[@029BT3
7>L29BT00be[<H`aS002=Jd00cW>?Nlmk`03@Q02?Nl3>Lh4=Jd8<H`K=Jd:>Lh5=Jd7<H`00cF]>Lhi
cP02?Nl6@Q02>Lh2<H`00bU:9BTU:@029BT00bU:;F/]J`02=Jd00cg_AS56<@03BU82AS42?Nl00cF]
;F/]J`02:DX00be[<H`aS002<H`5=Jd:>Lh==Jd:>Lh>=Jd3>Lh8?Nl2>Lh2=Jd00bU:8@PQ20026<H0
0acW;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00cg_AS56<@02CW<00eJeG_MN
m`02HaP5IcT3HaP2G_L8F]H4G_L3HaPPIcTIHaP2G_L00e[FE[EF]@02E[D00e:DCW=>L`0<CW<3BU82
AS42@Q000cg_=Jde[@02<H`00bU:9BTU:@028@P00acW6<HHaP025:D548@836<948@55:D;48@>5:D7
48@336<548@25:D00aS67>LLi`028@P00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2
@Q000e[FHaQS6002G_L00dYB=Jde[@029BT37>L29BT00be[<H`aS002=Jd00cW>?Nlmk`03@Q02?Nl3
>Lh4=Jd8<H`K=Jd:>Lh5=Jd7<H`00cF]>LhicP02?Nl6@Q02>Lh2<H`00bU:9BTU:@029BT00bU:;F/]
J`02=Jd00cg_AS56<@03BU82AS42?Nl00cF];F/]J`02:DX00be[<H`aS002<H`5=Jd:>Lh==Jd:>Lh>
=Jd3>Lh8?Nl2>Lh2=Jd00bU:8@PQ20026<H00acW;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001o
ogooOol2=Jd00cg_AS56<@02CW<00eJeG_MNm`02HaP5IcT3HaP2G_L8F]H4G_L3HaPPIcTIHaP2G_L3
F]H2E[D3DY@<CW<3BU82AS42@Q000cW>=Jde[@02;F/00bU:9BTU:@027>L36<H25:D548@836<I48@>
5:D?48@25:D00aS67>LLi`028@P00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q00
0e[FHaQS6002G_L00dic=Jde[@029BT37>L29BT00bU:<H`aS002=Jd00cW>?Nlmk`03@Q02?Nl3>Lh4
=Jd8<H`3=Jd5>LhC=Jd<>Lh3=Jd7<H`00cF]>LhicP02?Nl3@Q02AS400d8@?Nlmk`02=Jd00be[9BTU
:@029BT00bU:;F/]J`02=Jd00cg_AS56<@03BU82AS42?Nl00cF];F/]J`03;F/4<H`3=JdS>Lh>=Jd3
>Lh8?Nl2>Lh2=Jd00bU:8@PQ20026<H00acW;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogoo
Ool2=Jd00cg_AS56<@02CW<00eJeG_MNm`02HaP5IcT3HaP4G_L6F]H4G_L3HaPPIcTIHaP3G_L2F]H3
E[D4DY@:CW<2BU800dHa@Q124002?Nl00cW><H`aS002;F/00bU:8@PQ20027>L00aS65:DDY@025:D5
48@836<I48@>5:D?48@25:D00aS67>LLi`028@P00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomo
o`02Ool2@Q000e[FIcUW>@02G_L00dYB=Jde[@029BT37>L29BT00bU:<H`aS002=Jd00cW>?Nlmk`03
@Q02?Nl3>Lh5=Jd5<H`5=Jd7>Lh?=Jd4>Lh6=Jd5>Lh4=Jd5<H`3=Jd2>Lh00cg_@Q124002AS400d8@
?Nlmk`02=Jd00be[9BTU:@029BT00bU:;F/]J`02=Jd00cg_AS56<@03BU82AS42?Nl00cF];F/]J`03
;F/2<H`5=Jd?>Lh2?NlA>Lh?=Jd3>Lh7?Nl3>Lh2<H`00bU:7>LLi`036<H2:DX4Ool00`00Oomoo`0@
Ool002Eoo`04001oogooOol2=Jd00cg_AS56<@02CW<00eJeG_MNm`02HaP5IcT3HaP4G_L6F]H4G_L3
HaPPIcTIHaP3G_L2F]H3E[D4DY@:CW<2BU800dHa@Q124002?Nl00cW><H`aS002;F/00bU:8@PQ2002
7>L00aS65:DDY@025:D548@836<I48@>5:D?48@25:D00aS67>LLi`028@P00bDY;F/]J`04Ool00`00
Oomoo`0aOol00`00Oomoo`02Ool2@Q000e[FIcUW>@02G_L00dYB=Jde[@029BT37>L29BT00bU:<H`a
S002=Jd00cW>?Nlmk`03@Q02?Nl3>Lh5=Jd5<H`5=Jd7>Lh?=Jd4>Lh6=Jd5>Lh4=Jd5<H`3=Jd2>Lh0
0cg_@Q124002AS400d8@?Nlmk`02=Jd00be[9BTU:@029BT00bU:;F/]J`02=Jd00cg_AS56<@03BU82
AS42?Nl00cF];F/]J`03;F/2<H`5=Jd?>Lh2?NlA>Lh?=Jd3>Lh7?Nl3>Lh2<H`00bU:7>LLi`036<H2
:DX4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00cg_AS56<@02DY@00eJeG_MNm`02HaP5
IcT3HaP4G_L5F]H5G_L3HaPNIcTKHaP3G_L4F]H00eJeDYABU003DY@7CW<4BU800dHa@Q124002?Nl0
0cW><H`aS002;F/00bDY8@PQ20027>L00aS65:DDY@0748@636<J48@?5:D?48@25:D00aS67>LLi`02
8@P00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q000e[FIcUW>@02G_L00dYB=Jde
[@028@P37>L29BT00be[<H`aS002=Jd00cW>?Nlmk`03@Q04?Nl00cW>=Jde[@03=Jd4<H`5=Jd:>Lh=
=Jd2>Lh:=Jd3>Lh4=Jd5<H`3=Jd2>Lh00cg_@Q124003@Q02?Nl2=Jd00be[:DXYBP029BT00bU:<H`a
S002=Jd00cg_@Q124003AS42@Q02>Lh00c6<;F/]J`03;F/2<H`3=JdT>Lh8=Jd2<H`3=Jd3>Lh9?Nl3
>Lh2<H`00bU:7>LLi`036<H2:DX4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00cg_AS56
<@02DY@00eJeG_MNm`02HaP5IcT3HaP4G_L5F]H5G_L3HaPNIcTKHaP3G_L4F]H00eJeDYABU003DY@7
CW<4BU800dHa@Q124002?Nl00cW><H`aS002;F/00bDY8@PQ20027>L00aS65:DDY@0748@636<J48@?
5:D?48@25:D00aS67>LLi`028@P00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q00
0e[FIcUW>@02G_L00dYB=Jde[@028@P37>L29BT00be[<H`aS002=Jd00cW>?Nlmk`03@Q04?Nl00cW>
=Jde[@03=Jd4<H`5=Jd:>Lh==Jd2>Lh:=Jd3>Lh4=Jd5<H`3=Jd2>Lh00cg_@Q124003@Q02?Nl2=Jd0
0be[:DXYBP029BT00bU:<H`aS002=Jd00cg_@Q124003AS42@Q02>Lh00c6<;F/]J`03;F/2<H`3=JdT
>Lh8=Jd2<H`3=Jd3>Lh9?Nl3>Lh2<H`00bU:7>LLi`036<H2:DX4Ool00`00Oomoo`0@Ool002Eoo`04
001oogooOol2=Jd00cg_AS56<@02DY@00eJeG_MNm`02HaP5IcT3HaP4G_L5F]H5G_L3HaPMIcTLHaP3
G_L4F]H3E[D7DY@3CW<4BU800dHa@Q124002?Nl00cF]<H`aS002:DX00bDY7>LLi`026<H35:DW48@?
5:D?48@25:D00aS67>LLi`028@P00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2@Q00
0e[FIcUW>@02G_L00dYB=Jde[@028@P00aS67>LLi`029BT00be[<H`aS002=Jd00cW>?Nlmk`03@Q04
?Nl3>Lh:=Jd5>Lh3?Nl6>Lh;=Jd2>Lh:=Jd5>Lh3=Jd5<H`4=Jd00cW>?Nlmk`03@Q02?Nl2=Jd00be[
:DXYBP02:DX00be[<H`aS002=Jd00cg_@Q124003AS42@Q02>Lh00c6<:DXYBP02:DX00be[<H`aS002
=Jd;>Lh2?NlA>Lh==Jd4<H`3=Jd3>Lh9?Nl3>Lh2<H`00bU:7>LLi`036<H2:DX4Ool00`00Oomoo`0@
Ool002Eoo`04001oogooOol2=Jd00cg_BU9:DP02DY@00e[FG_MNm`02HaP5IcT3HaP4G_L5F]H5G_L3
HaPKIcTNHaP3G_L4F]H5E[D5DY@3CW<4BU800dHa@Q124002>Lh00cF];F/]J`02:DX00b487>LLi`02
6<H00aBU48@@Q00S48@C5:D?48@25:D00aS67>LLi`028@P00bDY;F/]J`04Ool00`00Oomoo`0aOol0
0`00Oomoo`02Ool2@Q000e[FIcUW>@02G_L00dYB<H`aS0028@P00aS67>LLi`029BT00be[<H`aS002
=Jd00cW>?Nlmk`05@Q02?Nl3>Lh:=Jd5>Lh5?Nl5>Lh:=Jd2>Lh5=Jd2<H`3=Jd5>Lh3=Jd5<H`4=Jd0
0cW>?Nlmk`05?Nl2=Jd00c6<;F/]J`02:DX00be[<H`aS002=Jd00cg_@Q124003AS42?Nl2=Jd00be[
:DXYBP02:DX00be[=Jde[@07>Lh00cF]>LhicP03>Lh2?Nl5>Lh7=Jd2>Lh@=Jd4<H`3=Jd3>Lh7?Nl5
>Lh2=Jd00bU:7>LLi`036<H2:DX4Ool00`00Oomoo`0@Ool002Eoo`80009oo`8e[@03?Nm:DTYB009B
U003F]INmekg009S60EW>@=S60ANm`EJePENm`=S61]W>AiS60=Nm`AJePEF]@EBU0=>L`A:DP03AS52
448@008icP03=Jd]Jbe[008YBP038@PLiacW008HaP035:D@Q12402<@Q1<DY@l@Q08DY@036<HLiacW
008Q20039BT]Jbe[00=oo`8003=oo`8000=oo`924003F]IW>FLi009Nm`03BU8aS36<008Q20036<HL
iacW008U:@03;F/aS36<008e[@03>Lhmkcg_00E2408mk`<icPXe[@DicPDmk`DicPXe[@8icPDe[@8a
S0<e[@DicP<e[@DaS0@e[@03>Lhmkcg_00Dmk`8e[@03<H`]Jbe[008YBP03;F/aS36<008e[@03?Nm2
448@00=6<@8mk`8e[@03;F/YBRU:008YBP03;F/e[CF]00LicP03=JdicSW>00<icP8mk`DicPLe[@8i
cQ0e[@@aS0<e[@<icPLmk`DicP8e[@03:DXLiacW00<HaP8YBPAoo`03001oogoo011oo`009Goo00@0
07ooOomoo`8e[@03?Nm:DTYB009BU003F]INmekg009S60IW>@9S60ANm`EJePENm`=S61MW>B9S60EN
m`=JePEF]@IBU0=>L`9:DP03AS52448@008icP03=Jd]Jbe[008U:@038@PLiacW00<DY@D@Q08<Ha/@
Q1HDY@l@Q08DY@036<HLiacW008Q20039BT]Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`96
<@03F]IW>FLi009Nm`03BU8aS36<008Q20036<HLiacW008U:@03;F/e[CF]00<icP@mk`=240<mk`8i
cP<e[@@aS0De[@<icP<mk`HicQLe[@LicP<e[@<aS0@e[@<icP<mk`8icP8e[@03<H`]Jbe[00<]J`8a
S08e[@03>Li2448@00=2408mk`8e[@03;F/YBRU:008YBP03<H`e[CF]008icP03?NlicSW>008icP<e
[@PicQ/e[@@aS0<e[@<icPLmk`DicP8e[@03:DXLiacW00<HaP8YBPAoo`03001oogoo011oo`009Goo
00@007ooOomoo`8e[@03?Nm:DTYB009BU003F]INmekg009S60IW>@9S60ANm`EJePENm`=S61MW>B9S
60ENm`=JePEF]@IBU0=>L`9:DP03AS52448@008icP03=Jd]Jbe[008U:@038@PLiacW00<DY@D@Q08<
Ha/@Q1HDY@l@Q08DY@036<HLiacW008Q20039BT]Jbe[00Aoo`03001oogoo035oo`03001oogoo009o
o`96<@03F]IW>FLi009Nm`03BU8aS36<008Q20036<HLiacW008U:@03;F/e[CF]00<icP@mk`=240<m
k`8icP<e[@@aS0De[@<icP<mk`HicQLe[@LicP<e[@<aS0@e[@<icP<mk`8icP8e[@03<H`]Jbe[00<]
J`8aS08e[@03>Li2448@00=2408mk`8e[@03;F/YBRU:008YBP03<H`e[CF]008icP03?NlicSW>008i
cP<e[@PicQ/e[@@aS0<e[@<icPLmk`DicP8e[@03:DXLiacW00<HaP8YBPAoo`03001oogoo011oo`00
9Goo00@007ooOomoo`8e[@03?Nm:DTYB009BU003F]INmekg009S60IW>@9S60ANm`EJePENm`=S61MW
>B9S60ENm`EJePEF]@ABU0=>L`9:DP03AS4mkcg_008icP03<H`]Jbe[008U:@037>LHaQS6008DY@<@
Q0D<HaP@Q1TDY@l@Q08DY@036<HLiacW008Q20039BT]Jbe[00Aoo`03001oogoo035oo`03001oogoo
009oo`96<@03G_MW>FLi009Nm`03BU8aS36<008Q20036<HLiacW008U:@03<H`e[CF]00<icPDmk`92
40<mk`8icP<e[@LaS0<e[@TicQTe[@LicP/e[@@icP03?NlicSW>00<e[@LaS08e[@03>Lhmkcg_00=2
408mk`8e[@03;F/YBRU:008]J`03<H`icSW>00<mk`8icPLe[@HicQ/e[@DaS08e[@8icPPmk`DicP8a
S003:DXLiacW00<HaP8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8e[@03?Nm:DTYB009B
U003F]INmekg009S60IW>@9S60ANm`EJeP=Nm`ES61IW>B=S60MNm`EJeP=F]@ABU0=>L`9:DP03AS4m
kcg_008icP03<H`YBRU:008U:@037>LHaQS6008DY@0348@<H`aS00D<HaP@Q1TDY@l@Q08DY@036<HL
iacW008Q2003:DX]Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03G_MW>FLi009S6003
BU8aS36<008Li`036<HLiacW008YBP03<H`e[CF]00DicPPmk`8icP<e[@TaS003=JdicSW>00DicPTe
[@DicPde[@LicP/e[@LicP<e[@LaS08e[@03>Lhmkcg_00=2408mk`8e[@03<H`]Jbe[008]J`03=Jdi
cSW>00<mk`8icP8e[@<aS0<e[@DicQ0e[@03<H`e[CF]00Pe[@DaS08e[@8icPXmk`<icP8aS003:DXL
iacW00<HaP8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8e[@03?Nm:DTYB009BU003F]IN
mekg009S60IW>@9S60ANm`EJeP=Nm`ES61IW>B=S60MNm`EJeP=F]@ABU0=>L`9:DP03AS4mkcg_008i
cP03<H`YBRU:008U:@037>LHaQS6008DY@0348@<H`aS00D<HaP@Q1TDY@l@Q08DY@036<HLiacW008Q
2003:DX]Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03G_MW>FLi009S6003BU8aS36<
008Li`036<HLiacW008YBP03<H`e[CF]00DicPPmk`8icP<e[@TaS003=JdicSW>00DicPTe[@DicPde
[@LicP/e[@LicP<e[@LaS08e[@03>Lhmkcg_00=2408mk`8e[@03<H`]Jbe[008]J`03=JdicSW>00<m
k`8icP8e[@<aS0<e[@DicQ0e[@03<H`e[CF]00Pe[@DaS08e[@8icPXmk`<icP8aS003:DXLiacW00<H
aP8]J`Aoo`03001oogoo011oo`0067oo0P0017oo0P001Goo00@007ooOomoo`8e[@03@Q1:DTYB009B
U003F]INmekg00QW>@9S60ENm`AJeP=Nm`ES61IW>B=S60MNm`EJePEF]@=BU09>L`9:DP03AS4mkcg_
008icP03<H`YBRU:008U:@037>LHaQS600<@Q0L<HaH@Q1/DY@l@Q08DY@036<HLiacW008Q2003:DX]
Jbe[00Aoo`03001oogoo02Eoo`8000Aoo`8000Aoo`03001oogoo009oo`96<@03G_M[FV]J009S6003
BU8aS36<008Li`036<HLiacW008YBP03<H`e[CF]00DicPPmk`8icP<e[@TaS003=JdicSW>00<icP@e
[@8aS0De[@DicPde[@LicPde[@DicPLe[@<aS0<e[@8icP<mk`8icP8e[@03<H`]Jbe[008aS003=Jdm
kcg_00924003?NlicSW>008e[@DaS1He[@03<H`e[CF]00<e[@8icP<e[@DaS08e[@8icPXmk`<icP8a
S003:DXLiacW00<HaP8]J`Aoo`03001oogoo011oo`005goo00@007ooOol0009oo`04001oogoo0004
Ool01000Oomoogoo0SF]00=244YBBU800U:D00=JeUkgG_L026Li0V<H1Ekg15[F0ekg1F<H5VLi8f<H
1ekg1E[F1EJe0e:D0Tic0TYB00=6<Cg_?Nl00SW>00<aS2U::DX00RDY00<LiaS66<H00a241`aS5Q24
6aBU3a240QBU00<HaQcW7>L00R4800<YBRe[;F/017oo00<007ooOol097oo00@007ooOol0009oo`04
001oogoo0003Ool00`00Oomoo`02Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L00aS67>LLi`02
:DX00c6<=Jde[@05>Lh8?Nl2>Lh3=Jd9<H`00cF]>LhicP03>Lh4=Jd2<H`5=Jd5>Lh==Jd7>Lh==Jd5
>Lh7=Jd3<H`3=Jd2>Lh3?Nl2>Lh2=Jd00c6<;F/]J`02<H`00cF]?Nlmk`02@Q000cg_>LhicP02=Jd5
<H`F=Jd00c6<=Jde[@03=Jd2>Lh3=Jd5<H`2=Jd2>Lh:?Nl3>Lh2<H`00bU:7>LLi`036<H2;F/4Ool0
0`00Oomoo`0@Ool001Moo`04001oogoo0002Ool01000Oomoo`0017oo0`0000AoocF]=Je2409:DP9B
U003F]INmekg00QW>@AS60=Nm`9JePENm`ES61IW>B=S60QNm`EJePAF]@=BU09>L`9:DP03AS4mkcg_
008icP03<H`YBRU:008Q20037>LDYABU008@Q0P<H`L@Q0DDY@`@Q1TDY@l@Q08DY@036<HLiacW008Q
2003:DX]Jbe[00=oo`8002Ioo`04001oogoo0002Ool01000Oomoo`000goo0`000Woo0THa00=Nmf]J
JeX00V<H00=:DS6<<H`00QcW00<HaQcW7>L00RU:00<aS3F]=Jd01CW>1cg_0cW>0cF]2C6<00<e[CW>
>Lh00cW>13F]0S6<1CF]1SW>33F]1cW>3CF]1CW>3CF]1cW>0SF]0c6<0SF]00<icSg_?Nl00T8@00<m
kcW>>Lh00SF]1S6<33F]0SW>33F]0cW>0cF]1C6<0SF]0SW>2Sg_0cW>0S6<00<YBQcW7>L00aS60Re[
0goo0P004Woo000HOol20003Ool01000Oomoo`0017oo00@007ooOomoo`8e[@03@Q1:DTYB009BU003
F]INmekg00QW>@AS60=Nm`9JePENm`=S61QW>B=S60QNm`EJePIF]@03DYA>Ldic009:DP03AS4mkcg_
008icP03<H`YBRU:008Q20037>LDYABU008@Q0P<H`D@Q0TDY@/@Q1PDY@l@Q08DY@036<HLiacW008Q
2003:DX]Jbe[00Aoo`03001oogoo02Eoo`8000=oo`04001oogoo0003Ool00`00Oomoo`02Ool2AS40
0ekgJeY[FP02HaP00dYB<H`aS0027>L00aS67>LLi`029BT00c6<=Jde[@03>Lh9?Nl00cW>=Jde[@02
=Jd8<H`3=Jd5>Lh;=Jd8>Lh:=Jd7>Lh?=Jd00cW>=Jde[@08=Jd9>Lh3=Jd5<H`2=Jd00cW>?Nlmk`03
?Nl2>Lh2=Jd00c6<;F/]J`03<H`<=Jd4>Lh:=Jd3>Lh3=Jd5<H`2=Jd2>Lh:?Nl3>Lh2<H`00bU:7>LL
i`036<H2;F/4Ool00`00Oomoo`0@Ool001Moo`04001oogoo0002Ool01000Oomoo`0017oo00@007oo
Oomoo`8e[@03@Q1:DTYB009BU003F]INmekg00QW>@AS60=Nm`9JePENm`=S61QW>B=S60QNm`EJePIF
]@03DYA>Ldic009:DP03AS4mkcg_008icP03<H`YBRU:008Q20037>LDYABU008@Q0P<H`D@Q0TDY@/@
Q1PDY@l@Q08DY@036<HLiacW008Q2003:DX]Jbe[00Aoo`03001oogoo02Aoo`04001oogoo0002Ool0
1000Oomoo`000goo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H00=:DS6<<H`00QcW00<HaQcW7>L0
0RDY00<aS3F]=Jd00cW>2Cg_00<icSF]=Jd00SF]236<0cF]1CW>2cF]23W>2SF]1cW>3cF]00<icSF]
=Jd023F]2CW>0cF]1C6<0SF]00<icSg_?Nl00cg_0SW>0SF]00<aS2e[;F/00c6<33F]13W>2SF]0cW>
0cF]1C6<0SF]0SW>2Sg_0cW>0S6<00<YBQcW7>L00aS60Re[17oo00<007ooOol047oo000HOol20004
Ool20005Ool01000Oomoogoo0SF]00=244YBBU800U:D00=JeUkgG_L026Li16<H0ekg0U[F1Ekg0f<H
66Li9F<H25kg1E[F15Je00=BU4icCW<00TYB00=6<D8@@Q000SW>00<aS2U::DX00R4800<LiaBU5:D0
0Q2420aS0a242aBU3a2451BU3a240QBU00<HaQcW7>L00R4800<YBRe[;F/017oo00<007ooOol09Goo
0P0017oo0P0017oo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H00=:DS6<<H`00QcW00<HaQcW7>L0
0RDY00<]JcF]=Jd00cW>1cg_0cW>13F]1S6<13F]23W>2CF]2SW>23F]1cW>3CF]0cW>1cF]23W>13F]
1S6<0SF]0cW>1Cg_0SW>0SF]00<aS2e[;F/00c6<33F]1CW>1cF]1CW>0cF]1C6<0SF]0SW>2Sg_0cW>
0SF]00<YBQcW7>L00QBU00<HaRe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0SF]00=2
44YBBU800U:D00=JeUkgG_L026Li16<H0ekg0U[F1Ekg0f<H66Li9F<H25kg1E[F15Je00=BU4icCW<0
0TYB00=6<D8@@Q000SW>00<aS2U::DX00R4800<LiaBU5:D00Q2420aS0a242aBU3a2451BU3a240QBU
00<HaQcW7>L00R4800<YBRe[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX0
0V<H00=:DS6<<H`00QcW00<HaQcW7>L00RDY00<]JcF]=Jd00cW>1cg_0cW>13F]1S6<13F]23W>2CF]
2SW>23F]1cW>3CF]0cW>1cF]23W>13F]1S6<0SF]0cW>1Cg_0SW>0SF]00<aS2e[;F/00c6<33F]1CW>
1cF]1CW>0cF]1C6<0SF]0SW>2Sg_0cW>0SF]00<YBQcW7>L00QBU00<HaRe[;F/017oo00<007ooOol0
47oo000UOol01000Oomoogoo0SF]00=244YBBU800U:D00=JeUkgG_L026Li16<H2Ukg0f<H66Li9F<H
25kg1E[F15Je0e:D0Tic00=6<D8@@Q000SW>00<aS2U::DX00R4800<HaQBU5:D00Q2420aS0a242aBU
41244aBU3a240QBU00<HaQcW7>L00R4800<YBRe[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo
0THa00=Nmf]JJeX00V<H00=:DS6<<H`00QcW00<HaQcW7>L00RDY00<]JcF]=Jd00cW>1cg_0cW>0SF]
1c6<0cF]2SW>2SF]2CW>23F]1cW>2cF]1CW>1cF]0cW>13g_00<icSF]=Jd00S6<0be[0c6<0SF]0SW>
1Sg_0SW>0SF]00<aS2e[;F/00c6<2SF]4cW>0cF]1C6<0SF]0SW>2Sg_0cW>0SF]00<YBQcW7>L00QBU
00<HaRe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0SF]00=244YBBU800U:D00=JeUkg
G_L00V<H1VLi16<H2Ukg0f<H6FLi9F<H1ekg1e[F0eJe0U:D0Tic00=:DT8@@Q000SW>00<aS2U::DX0
0R4800<LiaBU5:D00Q2420aS0a242aBU41244aBU3a240QBU00<HaQcW7>L00R4800<YBRe[;F/017oo
00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H00=:DS6<<H`00QcW00<HaQcW7>L0
0RDY00<]JcF]=Jd00cW>2Cg_00<icSF]=Jd01c6<0cF]2SW>33F]1cW>23F]1cW>2cF]1CW>2CF]00<i
cSg_?Nl00Sg_00<icSF]=Jd00S6<1Be[00<aS3F]=Jd00SW>00<mkd8@@Q000T8@00<mkcW>>Lh00SF]
1S6<2CF]53W>0cF]1C6<0SF]0cW>2Cg_0cW>0SF]00<YBQcW7>L00QBU00<HaRU::DX017oo00<007oo
Ool047oo000UOol01000Oomoogoo0SF]00=244YBBU800U:D00=JeUkgG_L00V<H1VLi16<H2Ukg0f<H
6FLi9F<H1ekg1e[F0eJe0U:D0Tic00=:DT8@@Q000SW>00<aS2U::DX00R4800<LiaBU5:D00Q2420aS
0a242aBU41244aBU3a240QBU00<HaQcW7>L00R4800<YBRe[;F/017oo00<007ooOol0<Goo00<007oo
Ool00Woo0THa00=Nmf]JJeX00V<H00=:DS6<<H`00QcW00<HaQcW7>L00RDY00<]JcF]=Jd00cW>2Cg_
00<icSF]=Jd01c6<0cF]2SW>33F]1cW>23F]1cW>2cF]1CW>2CF]00<icSg_?Nl00Sg_00<icSF]=Jd0
0S6<1Be[00<aS3F]=Jd00SW>00<mkd8@@Q000T8@00<mkcW>>Lh00SF]1S6<2CF]53W>0cF]1C6<0SF]
0cW>2Cg_0cW>0SF]00<YBQcW7>L00QBU00<HaRU::DX017oo00<007ooOol047oo000UOol01000Oomo
ogoo0SF]00=244YBBU800U:D00=JeUkgG_L00V<H1VLi16<H25kg1F<H6fLi8f<H1ekg1e[F0eJe0U:D
0Tic00=:DTHaAS400Sg_00<e[Be[;F/00RDY00<LiaBU5:D00Q2420aS0a242aBU41244aBU3a240QBU
00<HaQcW7>L00R4800<YBRe[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX0
0V<H00=:DS6<<H`00QcW00<HaQcW7>L00RDY00<aS3F]=Jd00cW>2Cg_00<icSF]=Jd00SF]1C6<0cF]
23W>3SF]1cW>00<e[C6<<H`00S6<0cF]1cW>2cF]1CW>13F]0c6<0SF]00<icSg_?Nl00cg_0SF]0Re[
0bU:0Re[00<aS3F]=Jd00SW>00<mkd8@@Q000T8@00<mkcW>>Lh00SF]1S6<1CF]63W>0cF]136<0cF]
0cW>2Cg_0cW>0SF]00<YBQcW7>L00QBU00<HaRU::DX017oo00<007ooOol047oo000UOol20002Ool2
=Jd00d8@BU9:DP02DY@00e[FG_MNm`02HaP6IcT4HaP8G_L5HaPKIcTSHaP7G_L7F]H3E[D2DY@2CW<0
0dYBAS56<@02?Nl00cF];F/]J`029BT00acW5:DDY@0248@836<348@;5:D@48@C5:D?48@25:D00aS6
7>LLi`028@P00bU:;F/]J`03Ool2000cOol20003Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L0
0aS67>LLi`029BT00c6<=Jde[@03>Lh9?Nl00cW>=Jde[@02=Jd5<H`3=Jd8>Lh>=Jd7>Lh00cF]<H`a
S002<H`3=Jd7>Lh;=Jd5>Lh4=Jd3<H`2=Jd00cW>?Nlmk`03?Nl2=Jd2;F/3:DX2;F/00c6<=Jde[@02
>Lh00cg_@Q124002@Q000cg_>LhicP02=Jd6<H`5=JdH>Lh3=Jd4<H`3=Jd3>Lh9?Nl3>Lh2=Jd00bU:
7>LLi`025:D00aS6:DXYBP04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00d8@BU9:DP02
DY@00e[FG_MNm`08IcT4HaP8G_L4HaP5IcT3JeXFIcTQHaP9G_L7F]H3E[D2DY@00dYBAS56<@02?Nl0
0cF];F/]J`029BT00acW5:DDY@0248@836<348@;5:D@48@C5:D?48@25:D00aS67>LLi`028@P00bU:
;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L0
0aS67>LLi`029BT00c6<=Jde[@05>Lh3?Nl2@Q03?Nl2>Lh2=Jd5<H`3=Jd7>Lh?=Jd5>Lh3=Jd4<H`3
=Jd7>Lh;=Jd5>Lh4=Jd3<H`2=Jd00cW>?Nlmk`02@Q000cg_=Jde[@02;F/3:DX2;F/00c6<=Jde[@02
>Lh00cg_@Q124003@Q02?Nl2=Jd6<H`4=JdA>Lh5?Nl3>Lh3=Jd4<H`3=Jd3>Lh9?Nl3>Lh2=Jd00bU:
7>LLi`025:D00aS6:DXYBP04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00d8@BU9:DP02
DY@00e[FG_MNm`08IcT4HaP8G_L4HaP5IcT5JeXFIcTOHaP9G_L8F]H2E[D2DY@00dicAS56<@02?Nl0
0cF];F/]J`029BT00acW5:DDY@0248@636<448@<5:D=48@F5:D?48@25:D00aS67>LLi`028@P00bU:
;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgIcUW>@02HaP00dYB<H`aS0028@P0
0aS67>LLi`02:DX00c6<=Jde[@02=Jd3>Lh2?Nl5@Q000cg_>LhicP02=Jd5<H`5=Jd5>LhA=Jd3>Lh3
=Jd4<H`3=Jd7>Lh;=Jd5>Lh4=Jd5<H`00cW>?Nlmk`02@Q000cg_=Jde[@02<H`3:DX2;F/00c6<=Jde
[@02>Lh00cg_@Q124002AS400d8@?Nlmk`02=Jd6<H`4=JdB>Lh2?Nl5>Lh3=Jd4<H`3=Jd3>Lh9?Nl3
>Lh2=Jd00bU:7>LLi`025:D00aS6;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd0
0d8@BU9:DP02DY@00e[FG_MNm`08IcT4HaP8G_L4HaP5IcT5JeXFIcTOHaP9G_L8F]H2E[D2DY@00dic
AS56<@02?Nl00cF];F/]J`029BT00acW5:DDY@0248@636<448@<5:D=48@F5:D?48@25:D00aS67>LL
i`028@P00bU:;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgIcUW>@02HaP00dYB
<H`aS0028@P00aS67>LLi`02:DX00c6<=Jde[@02=Jd3>Lh2?Nl5@Q000cg_>LhicP02=Jd5<H`5=Jd5
>LhA=Jd3>Lh3=Jd4<H`3=Jd7>Lh;=Jd5>Lh4=Jd5<H`00cW>?Nlmk`02@Q000cg_=Jde[@02<H`3:DX2
;F/00c6<=Jde[@02>Lh00cg_@Q124002AS400d8@?Nlmk`02=Jd6<H`4=JdB>Lh2?Nl5>Lh3=Jd4<H`3
=Jd3>Lh9?Nl3>Lh2=Jd00bU:7>LLi`025:D00aS6;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001o
ogooOol2=Jd00d8@BU9:DP02DY@00e[FG_MNm`08IcT4HaP8G_L4HaP5IcT5JeXGIcTNHaP9G_L8F]H4
E[D00dicBU9:DP02@Q000cW>;F/]J`029BT00acW5:DDY@0248@636<448@:5:D=48@H5:D?48@25:D0
0aS67>LLi`028@P00bU:;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgIcUW>@02
HaP00dYB<H`aS0028@P00aS67>LLi`029BT00c6<=Jde[@02=Jd3>Lh2?Nl5@Q000cg_>LhicP02=Jd5
<H`6=Jd5>LhM=Jd7>Lh;=Jd7>Lh2=Jd00c6<;F/]J`02<H`00cW>?Nlmk`02@Q000cg_>LhicP02<H`6
;F/2<H`2>Lh00cg_@Q124002AS400d8@?Nlmk`02=Jd6<H`2=Jd<>Lh5=Jd8>Lh5=Jd4<H`3=Jd3>Lh9
?Nl3>Lh2<H`00bU:7>LLi`036<H2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00d8@
BU9:DP02DY@00e[FG_MNm`08IcT4HaP8G_L4HaP5IcT5JeXGIcTNHaP9G_L8F]H4E[D00dicBU9:DP02
@Q000cW>;F/]J`029BT00acW5:DDY@0248@636<448@:5:D=48@H5:D?48@25:D00aS67>LLi`028@P0
0bU:;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgIcUW>@02HaP00dYB<H`aS002
8@P00aS67>LLi`029BT00c6<=Jde[@02=Jd3>Lh2?Nl5@Q000cg_>LhicP02=Jd5<H`6=Jd5>LhM=Jd7
>Lh;=Jd7>Lh2=Jd00c6<;F/]J`02<H`00cW>?Nlmk`02@Q000cg_>LhicP02<H`6;F/2<H`2>Lh00cg_
@Q124002AS400d8@?Nlmk`02=Jd6<H`2=Jd<>Lh5=Jd8>Lh5=Jd4<H`3=Jd3>Lh9?Nl3>Lh2<H`00bU:
7>LLi`036<H2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00d8@BU9:DP02DY@00e[F
G_MNm`08IcT4HaP8G_L4HaP3IcT8JeXFIcTNHaP9G_L00e[FG_MNm`07F]H2E[D00e:DBU9:DP02@Q00
0cW><H`aS002:DX00b486<HHaP0248@636<448@:5:D<48@65:D<6<H75:D?48@25:D00aS67>LLi`02
8@P00bU:;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgIcUW>@02HaP00dYB<H`a
S0028@P00aS67>LLi`029BT00be[=Jde[@02=Jd00cW>?Nlmk`02?Nl5@Q000cg_>LhicP02=Jd6<H`5
=Jd<>LhX=Jd2>Lh3?Nl2>Lh2=Jd00c6<;F/]J`02<H`00cW>?Nlmk`03@Q02?Nl2=Jd00c6<;F/]J`03
;F/2<H`2=Jd00cg_@Q124002AS400d8@?Nlmk`02=Jd00c6<;F/]J`02<H`3=Jd<>LhB=Jd4<H`3=Jd3
>Lh9?Nl3>Lh2<H`00bU:7>LLi`036<H2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd0
0d8@BU9:DP02DY@00e[FHaQS6003IcT2JeX3IcT4HaP8G_L4HaP3IcT8JeXHIcTLHaP@G_L3F]H2E[D0
0e:DCW=>L`02AS400cg_<H`aS002:DX00b486<HHaP025:D00a2436<<H`0336<448@:5:D:48@55:D?
6<H75:D=48@45:D00aS67>LLi`028@P00bU:;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2
AS400ekgIcUW>@02HaP00dYB=Jde[@028@P00aS67>LLi`029BT00be[<H`aS002=Jd00cW>?Nlmk`02
?Nl3@Q03?Nl2>Lh2=Jd6<H`5=Jd>>Lh:=Jd8>LhC=Jd3>Lh3?Nl2>Lh2=Jd00c6<;F/]J`02<H`00cF]
?Nlmk`03@Q04?Nl00cW>=Jde[@02<H`3;F/2<H`00cW>@Q124003@Q02>Lh2<H`3;F/2<H`3=Jd:>Lh4
=Jd:<H`5=Jd5<H`3=Jd3>Lh9?Nl3>Lh2<H`00bU:7>LLi`036<H2;F/4Ool00`00Oomoo`0@Ool002Eo
o`80009oo`8e[@03@Q1:DTYB009BU003F]IS66<H00=W>@9[FP=W>@AS60QNm`AS60=W>@Q[FQQW>AaS
611Nm`=JeP9F]@03DYA>Ldic0096<@03?NlaS36<008YBP038@PHaQS6008DY@0348@<H`aS00<<H`@@
Q0XDY@X@Q0DDY@lHaPLDY@d@Q0@DY@036<HLiacW008Q2003:DX]Jbe[00=oo`8003=oo`8000=oo`96
<@03G_MW>FLi009S6003BU8e[CF]008Q20036<HLiacW008U:@03;F/aS36<008e[@03>Lhmkcg_008m
k`=240<mk`8icP8e[@HaS0De[@hicPXe[@PicQ<e[@<icP<mk`8icP8e[@03<H`]Jbe[008aS003=Jdm
kcg_00=240@mk`03>Lhe[CF]008aS0<]J`8aS003>Li2448@00=2408icP8aS0<]J`8aS0<e[@XicP@e
[@XaS0De[@DaS0<e[@<icPTmk`<icP8aS003:DXLiacW00<HaP8]J`Aoo`03001oogoo011oo`009Goo
00@007ooOomoo`8e[@03@Q1:DTYB009BU003F]IS66<H00=W>@9[FP=W>@AS60QNm`AS60=W>@Q[FQQW
>AaS615Nm`AJeP03E[E>Ldic0096<@03?Nle[CF]008YBP038@PHaQS6008DY@0348@<H`aS008<H`D@
Q0PDY@`@Q0<DY@DHaPLLi`LHaPDDY@d@Q0@DY@036<HLiacW008Q2003:DX]Jbe[00Aoo`03001oogoo
035oo`03001oogoo009oo`96<@03F]IW>FLi009S6003CW<e[CF]008Q20036<HLiacW008U:@03;F/a
S36<008e[@03>Lhmkcg_00E240<mk`8icP8e[@HaS0De[@LicP@mk`<icPXe[@PicPXe[@8icPLe[@<i
cP<mk`8icP8e[@03<H`]Jbe[008aS003=JdicSW>008mk`E24003?NlicSW>008aS003;F/YBRU:008]
J`03=Jdmkcg_00=2408icP8aS0<]J`8aS003=JdicSW>008icP<mk`<icP@e[@<aS0@]J`DaS0De[@Ha
S08e[@8icPPmk`DicP8aS003:DXLiacW00<HaP8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomo
o`8e[@03@Q1:DTYB009BU003F]IS66<H00=W>@9[FP=W>@AS60QNm`AS60=W>@Q[FQQW>AaS615Nm`AJ
eP03E[E>Ldic0096<@03?Nle[CF]008YBP038@PHaQS6008DY@0348@<H`aS008<H`D@Q0PDY@`@Q0<D
Y@DHaPLLi`LHaPDDY@d@Q0@DY@036<HLiacW008Q2003:DX]Jbe[00Aoo`03001oogoo035oo`03001o
ogoo009oo`96<@03F]IW>FLi009S6003CW<e[CF]008Q20036<HLiacW008U:@03;F/aS36<008e[@03
>Lhmkcg_00E240<mk`8icP8e[@HaS0De[@LicP@mk`<icPXe[@PicPXe[@8icPLe[@<icP<mk`8icP8e
[@03<H`]Jbe[008aS003=JdicSW>008mk`E24003?NlicSW>008aS003;F/YBRU:008]J`03=Jdmkcg_
00=2408icP8aS0<]J`8aS003=JdicSW>008icP<mk`<icP@e[@<aS0@]J`DaS0De[@HaS08e[@8icPPm
k`DicP8aS003:DXLiacW00<HaP8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8e[@03@Q1:
DTYB009BU003F]IS66<H009W>@E[FP=W>@9S60QNm`AS60=W>@Q[FQQW>AaS61=Nm`9JeP03E[EBU5:D
009:DP03@Q0e[CF]008]J`039BTLiacW008DY@X@Q0PDY@`@Q0<DY@@HaPXLi`DHaP<DY@l@Q0@DY@03
6<HLiacW008Q2003:DX]Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03F]IW>FLi009S
6003CW<e[CF]008Q20036<HLiacW008U:@03;F/aS36<008e[@03>Lhmkcg_00E240<mk`8icP8e[@Ha
S0Le[@DicP@mk`DicPPe[@PicQ<e[@03>Lhmkcg_00<mk`8icP8e[@03<H`]Jbe[008]J`03<H`e[CF]
008icP=24096<@03@Q0mkcg_008e[@03;F/YBRU:008]J`03=Jdmkcg_00=2408icP8aS0<]J`8aS003
=JdicSW>008icPDmk`03>Lhe[CF]008aS0D]J`<aS0Te[@HaS08e[@8icPHmk`LicP8aS003:DXLiacW
00<HaP8]J`Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8e[@03@Q1:DTYB009BU003F]IS66<H
009W>@E[FP=W>@9S60QNm`AS60=W>@Q[FQQW>AaS61=Nm`9JeP03E[EBU5:D009:DP03@Q0e[CF]008]
J`039BTLiacW008DY@X@Q0PDY@`@Q0<DY@@HaPXLi`DHaP<DY@l@Q0@DY@036<HLiacW008Q2003:DX]
Jbe[00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03F]IW>FLi009S6003CW<e[CF]008Q2003
6<HLiacW008U:@03;F/aS36<008e[@03>Lhmkcg_00E240<mk`8icP8e[@HaS0Le[@DicP@mk`DicPPe
[@PicQ<e[@03>Lhmkcg_00<mk`8icP8e[@03<H`]Jbe[008]J`03<H`e[CF]008icP=24096<@03@Q0m
kcg_008e[@03;F/YBRU:008]J`03=Jdmkcg_00=2408icP8aS0<]J`8aS003=JdicSW>008icPDmk`03
>Lhe[CF]008aS0D]J`<aS0Te[@HaS08e[@8icPHmk`LicP8aS003:DXLiacW00<HaP8]J`Aoo`03001o
ogoo011oo`009Goo00@007ooOomoo`8icP03@Q1:DTYB009BU003F]IS66<H009W>@E[FP=W>@9S60MN
m`=S60EW>@Y[FQIW>AaS61ENm`03F]IBU5:D009:DP03@Q0icSW>008]J`039BTLiacW008HaP035:D@
Q12400D@Q0XDY@X@Q0@DY@<HaPDLi`8Q20HLi`@HaP<DY@l@Q0@DY@036<HLiacW008Q2003:DX]Jbe[
00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03F]IW>FLi009S6003CW<e[CF]008Q20036<HL
iacW008U:@03:DXaS36<008e[@03>Lhmkcg_00M24003?NlicSW>008e[@PaS0De[@`icPXe[@XicP<e
[@8aS0Xe[@<icPDmk`8icP8e[@03<H`]Jbe[00<]J`8aS08e[@03?Nm2448@00=6<@92408e[@03;F/U
:BDY008YBP03<H`icSW>00=2408icP8aS0<]J`8aS003=JdicSW>00<mk`92408mk`03>LhaS36<008]
J`<YBP8]J`8e[@HicP@e[@03<H`]Jbe[008]J`03<H`e[CF]008icPHmk`LicP8aS003:DXLiacW008D
Y@036<HYBRU:00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8icP03@Q1:DTYB009BU003F]IS
66<H009W>@E[FP=W>@AS60ENm`=S60=W>@a[FQIW>AaS611Nm`03HaQNmekg009Nm`03F]IF]EJe009>
L`03AS4icSW>008aS003:DXQ2248008HaP035:D@Q12400D@Q0XDY@X@Q0@DY@036<HLiacW00<Li`LQ
20<Li`@HaP<DY@l@Q0@DY@036<HLiacW008Q2003:DX]Jbe[00Aoo`03001oogoo035oo`03001oogoo
009oo`96<@03F]IW>FLi009S6003CW<e[CF]008Q20036<HLiacW008U:@03:DXaS36<008e[@03>Lhm
kcg_008mk`E24003?NlicSW>008e[@03<H`]Jbe[00<aS0Te[@XicPXe[@PicPDe[@DaS0De[@@icPHm
k`8icP8e[@03<H`]Jbe[00<YBP8]J`8aS003>Li2448@00=:DP96<@8icP03:DXU:BDY008U:@03;F/i
cSW>00=2408icP8e[@03<H`]Jbe[008aS003=JdicSW>008mk`E24003>LhaS36<008YBP8U:@03:DX]
Jbe[008icP03?Nm2448@00924003?NlicSW>008e[@03<H`]Jbe[008]J`03<H`e[CF]008icPHmk`Li
cP8aS003:DXLiacW008DY@036<HYBRU:00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8icP03
@Q1:DTYB009BU003F]IS66<H009W>@E[FP=W>@AS60ENm`=S60=W>@a[FQIW>AaS611Nm`03HaQNmekg
009Nm`03F]IF]EJe009>L`03AS4icSW>008aS003:DXQ2248008HaP035:D@Q12400D@Q0XDY@X@Q0@D
Y@036<HLiacW00<Li`LQ20<Li`@HaP<DY@l@Q0@DY@036<HLiacW008Q2003:DX]Jbe[00Aoo`03001o
ogoo035oo`03001oogoo009oo`96<@03F]IW>FLi009S6003CW<e[CF]008Q20036<HLiacW008U:@03
:DXaS36<008e[@03>Lhmkcg_008mk`E24003?NlicSW>008e[@03<H`]Jbe[00<aS0Te[@XicPXe[@Pi
cPDe[@DaS0De[@@icPHmk`8icP8e[@03<H`]Jbe[00<YBP8]J`8aS003>Li2448@00=:DP96<@8icP03
:DXU:BDY008U:@03;F/icSW>00=2408icP8e[@03<H`]Jbe[008aS003=JdicSW>008mk`E24003>Lha
S36<008YBP8U:@03:DX]Jbe[008icP03?Nm2448@00924003?NlicSW>008e[@03<H`]Jbe[008]J`03
<H`e[CF]008icPHmk`LicP8aS003:DXLiacW008DY@036<HYBRU:00Aoo`03001oogoo011oo`009Goo
0P000Woo0SW>00=244YBBU800U:D00=JeV<HHaP00VLi1F]J0fLi16<H1Ekg0f<H0fLi36]J5VLi4V<H
16Li1V<H3Ukg1F<H0Ukg00=JeUJeE[D00Tic00=6<Cg_?Nl00S6<00<YBR488@P00QS60aBU1A2421BU
312411BU00<HaQcW7>L00QcW22480acW11S60aBU3a2411BU00<HaQcW7>L00R4800<YBRe[;F/00goo
0P00<goo0P000goo0THa00=Nmf]JJeX00V<H00=>LcF]=Jd00R4800<HaQcW7>L00RDY00<YBS6<<H`0
0SF]00<icSg_?Nl00Sg_1D8@00<mkcW>>Lh00c6<0Re[0c6<2CF]23W>33F]2SW>0cF]1c6<0cF]13W>
1Sg_0SW>0SF]00<aS2e[;F/01BU:0Re[00<e[D8@@Q000TYB00=>LdHaAS400SW>00<YBR488@P00RDY
00<]JcW>>Lh00cg_0SW>0SF]1C6<00<e[CW>>Lh00Sg_1D8@00<icS6<<H`00RDY0R4800<U:C6<<H`0
0Sg_1DHa00=243W>>Lh00SF]00<aS2e[;F/00be[0S6<0SW>1Sg_1cW>0S6<00<YBQcW7>L00QBU00<H
aRU::DX017oo00<007ooOol047oo000UOol01000Oomoogoo0SW>00=244YBBU800U:D00=JeV<HHaP0
0VLi1F]J0fLi16<H1Ekg0f<H0fLi36]J5VLi4V<H16Li1V<H3Ukg1F<H0Ukg00=JeUJeE[D00Tic00=6
<Cg_?Nl00S6<00<YBR488@P00QS60aBU1A2421BU312411BU00<HaQcW7>L00QcW22480acW11S60aBU
3a2411BU00<HaQcW7>L00R4800<YBRe[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=N
mf]JJeX00V<H00=>LcF]=Jd00R4800<HaQcW7>L00RDY00<YBS6<<H`00SF]00<icSg_?Nl00Sg_1D8@
00<mkcW>>Lh00c6<0Re[0c6<2CF]23W>33F]2SW>0cF]1c6<0cF]13W>1Sg_0SW>0SF]00<aS2e[;F/0
1BU:0Re[00<e[D8@@Q000TYB00=>LdHaAS400SW>00<YBR488@P00RDY00<]JcW>>Lh00cg_0SW>0SF]
1C6<00<e[CW>>Lh00Sg_1D8@00<icS6<<H`00RDY0R4800<U:C6<<H`00Sg_1DHa00=243W>>Lh00SF]
00<aS2e[;F/00be[0S6<0SW>1Sg_1cW>0S6<00<YBQcW7>L00QBU00<HaRU::DX017oo00<007ooOol0
47oo000UOol01000Oomoogoo0SW>00=244YBBU800U:D00=JeV<HHaP00VLi1V]J0VLi16<H0ekg1F<H
0fLi3V]J56Li4V<H1FLi1f<H2Ukg2F<H00=NmeJeE[D00Tic00=6<Cg_?Nl00SF]00<YBR488@P00QcW
00<HaQBU5:D00QBU0a2421BU312411BU00<HaQcW7>L00QcW22480acW11S60aBU3a2411BU00<HaQcW
7>L00R4800<YBRe[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H00=>
LcF]=Jd00R4800<HaQcW7>L00RDY00<]Jc6<<H`00SF]00<icSg_?Nl00Sg_1D8@00<mkcW>>Lh00SF]
1S6<2SF]1cW>33F]2SW>1CF]1C6<0cF]0SW>23g_0SW>0SF]00<aS2e[;F/00RU:0bDY0Re[00<e[D8@
@Q000Tic00=BU4YBBU800SW>00<]Jb488@P00R4800<]JcF]=Jd00cg_0SW>0SF]1C6<00<e[CW>>Lh0
0Sg_00=244HaAS400T8@00<icRe[;F/00RDY0R4800<U:C6<<H`00Sg_00=6<DYBBU800THa00=243g_
?Nl00SF]00<aS2e[;F/00be[0S6<0SW>00<mkd8@@Q000cg_1cW>0S6<00<YBQcW7>L00QBU00<HaRU:
:DX017oo00<007ooOol047oo000UOol01000Oomoogoo0SW>00=244YBBU800U:D00=JeV<HHaP00VLi
1V]J16Li2V<H0fLi3V]J56Li4F<H1VLi1f<H2Ukg2F<H00=Nme[FF]H00U:D00=:DSg_?Nl00SF]00<]
JbDY9BT00QcW00<HaQBU5:D031BU3A2411BU00<HaQcW7>L00QcW22480acW11S60aBU3a2411BU00<H
aQcW7>L00R4800<YBS6<<H`017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H
00=>LcF]=Jd00R4800<HaQcW7>L00RDY00<]Jc6<<H`00SF]00<icSg_?Nl01D8@0cg_0SW>0SF]1C6<
2cF]1cW>3SF]23W>1CF]1C6<0cF]0SW>0cg_0T8@0cg_0SW>0SF]00<aS2U::DX00RU:0bDY0RU:00<e
[D8@@Q000Tic00=BU4icCW<00Sg_00<]Jb488@P00R4800<YBSF]=Jd00SW>00<mkcW>>Lh00SF]0c6<
0cF]0SW>0Sg_00=244HaAS400T8@00<icS6<<H`00RDY0R4800<U:C6<<H`00Sg_1DYB00=243g_?Nl0
0SF]00<aS2e[;F/00be[0S6<0SW>23g_1CW>0S6<00<YBQcW7>L00QBU00<HaRU::DX017oo00<007oo
Ool047oo000UOol01000Oomoogoo0SW>00=244YBBU800U:D00=JeV<HHaP00VLi1V]J16Li2V<H0fLi
3V]J56Li4F<H1VLi1f<H2Ukg2F<H00=Nme[FF]H00U:D00=:DSg_?Nl00SF]00<]JbDY9BT00QcW00<H
aQBU5:D031BU3A2411BU00<HaQcW7>L00QcW22480acW11S60aBU3a2411BU00<HaQcW7>L00R4800<Y
BS6<<H`017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H00=>LcF]=Jd00R48
00<HaQcW7>L00RDY00<]Jc6<<H`00SF]00<icSg_?Nl01D8@0cg_0SW>0SF]1C6<2cF]1cW>3SF]23W>
1CF]1C6<0cF]0SW>0cg_0T8@0cg_0SW>0SF]00<aS2U::DX00RU:0bDY0RU:00<e[D8@@Q000Tic00=B
U4icCW<00Sg_00<]Jb488@P00R4800<YBSF]=Jd00SW>00<mkcW>>Lh00SF]0c6<0cF]0SW>0Sg_00=2
44HaAS400T8@00<icS6<<H`00RDY0R4800<U:C6<<H`00Sg_1DYB00=243g_?Nl00SF]00<aS2e[;F/0
0be[0S6<0SW>23g_1CW>0S6<00<YBQcW7>L00QBU00<HaRU::DX017oo00<007ooOol047oo000UOol0
1000Oomoogoo0SW>00=244YBBU800U:D00=JeV<HHaP00VLi1V]J16Li26<H16Li46]J5FLi3f<H26Li
1F<H25kg2f<H00=Nme[FF]H00U:D00=:DT8@@Q000SW>00<]JbDY9BT00R480aS62QBU3a2411BU00<H
aQcW7>L00acW1B481AcW11S60aBU1a240`aS1a240QBU00<HaQcW7>L00R4800<YBS6<<H`017oo00<0
07ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H00=>Lc6<<H`00QcW00<HaQcW7>L00RDY
00<]JcF]=Jd00SW>0cg_1D8@0Sg_0cW>4SF]1SW>3cF]23W>1CF]1C6<0cF]0SW>0cg_148@00<mkcW>
>Lh00SF]00<aS2U::DX01BDY0RU:00<e[DHaAS400U:D00=F]DicCW<00Sg_00<]Jb488@P00R4800<Y
BS6<<H`01CW>1cF]0cW>0Sg_00=244HaAS400T8@00<icS6<<H`00RDY0R4800<YBS6<<H`00Sg_00=6
<DYBBU800THa00=243g_?Nl00SF]00<aS2e[;F/00Re[00<aS3F]=Jd00SW>0cg_0T8@1Cg_0cW>0SF]
00<YBQcW7>L00QBU00<HaRe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0SW>00=244YB
BU800U:D00=JeV<HHaP00VLi1V]J16Li26<H16Li46]J5FLi3f<H26Li1F<H25kg2f<H00=Nme[FF]H0
0U:D00=:DT8@@Q000SW>00<]JbDY9BT00R480aS62QBU3a2411BU00<HaQcW7>L00acW1B481AcW11S6
0aBU1a240`aS1a240QBU00<HaQcW7>L00R4800<YBS6<<H`017oo00<007ooOol0<Goo00<007ooOol0
0Woo0THa00=Nmf]JJeX00V<H00=>Lc6<<H`00QcW00<HaQcW7>L00RDY00<]JcF]=Jd00SW>0cg_1D8@
0Sg_0cW>4SF]1SW>3cF]23W>1CF]1C6<0cF]0SW>0cg_148@00<mkcW>>Lh00SF]00<aS2U::DX01BDY
0RU:00<e[DHaAS400U:D00=F]DicCW<00Sg_00<]Jb488@P00R4800<YBS6<<H`01CW>1cF]0cW>0Sg_
00=244HaAS400T8@00<icS6<<H`00RDY0R4800<YBS6<<H`00Sg_00=6<DYBBU800THa00=243g_?Nl0
0SF]00<aS2e[;F/00Re[00<aS3F]=Jd00SW>0cg_0T8@1Cg_0cW>0SF]00<YBQcW7>L00QBU00<HaRe[
;F/017oo00<007ooOol047oo000AOol50002Ool20004Ool20005Ool01000Oomoogoo0SW>00=244YB
BU800U:D00=JeV<HHaP00VLi1V]J16Li26<H16Li1F]J0fmk2V]J4fLi3F<H2VLi1f<H1Ukg2f<H00=N
me[FF]H00U:D00=:DT8@@Q000SW>00<aS2U::DX00R4800<LiaS66<H01ABU4a241ABU0aS631cW1AS6
0aBU1a241@aS1A240QBU00<HaQcW7>L00R4800<YBS6<<H`017oo00<007ooOol07Woo1@000Woo0P00
17oo0P0017oo00<007ooOol00Woo0THa00=Nmf]JJeX00V<H00=>Lc6<<H`00QcW00<HaQcW7>L00RDY
00<]JcF]=Jd00SW>0cg_0d8@13g_0cW>53F]13W>43F]1cW>1CF]1C6<0cF]0SW>0Sg_1D8@00<mkcW>
>Lh00SF]00<aS2U::DX01BDY0RU:00<e[DHaAS400U:D00=F]E:DDY@00T8@00<aS2DY9BT00R4800<Y
BS6<<H`01CW>1CF]1CW>0Sg_1D8@00<icS6<<H`00RU:0RDY00<YBS6<<H`00Sg_1DHa00=243W>>Lh0
0SF]0c6<0Re[00<aS3F]=Jd00SW>0cg_0T8@1Sg_0SW>0SF]00<YBQcW7>L00QBU00<HaRe[;F/017oo
00<007ooOol047oo000COol01@00Oomoogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`04
001oogooOol2>Lh00d8@BU9:DP02DY@00ekgHaQS6003JeX2Kg/5JeX2IcT8HaP4IcT3JeX7Kg/8JeXD
IcT<HaP:IcT7HaP5G_L7HaP00fLiHaQS6002HaP00ekgF]IJeP02DY@00dic@Q124002>Lh00c6<:DXY
BP029BT00acW6<HHaP055:DC48@55:D36<H<7>L56<H35:D548@736<548@25:D00aS67>LLi`028@P0
0bU:<H`aS004Ool00`00Oomoo`0POol01@00Oomoogoo00000Woo00@007ooOol0009oo`05001oogoo
Ool00004Ool2AS400ekgJeY[FP02HaP00dic<H`aS0027>L00aBU6<HHaP029BT00be[=Jde[@02>Lh8
?Nl3>Lh/=Jd5>Lh5=Jd5<H`3=Jd2>Lh2?Nl5@Q000cg_>LhicP02=Jd00c6<:DXYBP029BT00b489BTU
:@02:DX00cF]AS56<@02DY@00e[FDYABU002@Q000c6<9BTU:@028@P00bDY;F/]J`02=Jd;>Lh4?Nl3
@Q02?Nl00cW><H`aS004:DX00be[=Jde[@02?Nl00d8@AS56<@02@Q000cg_>LhicP02=Jd6<H`2=Jd2
>Lh00cg_@Q124003@Q05?Nl2>Lh2=Jd00bU:7>LLi`025:D00aS6;F/]J`04Ool00`00Oomoo`0@Ool0
01=oo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol00Woo0`0000AoocW>>Li2409:
DP9BU003G_MS66<H00=[FP9_N`E[FP9W>@QS60AW>@=[FPM_N`Q[FQAW>@aS60YW>@MS60ENm`MS6003
IcUS66<H009S6003G_MJeU[F009BU003CW=2448@008icP03<H`YBRU:008U:@037>LHaQS600DDYA<@
Q0DDY@<HaP`Li`DHaP<DY@D@Q0L<H`D@Q08DY@036<HLiacW008Q2003:DXaS36<00=oo`80029oo`05
001oogooOol00002Ool01000Oomoo`000Woo00@007ooOomoo`<0009oo`96<@03G_M[FV]J009S6003
CW<aS36<008Li`035:DHaQS6008U:@03;F/e[CF]008icPPmk`<icR`e[@DicPDe[@DaS0<e[@8icP8m
k`E24003?NlicSW>008e[@03<H`YBRU:008U:@038@PU:BDY008YBP03=Je6<DHa009BU003F]IBU5:D
00924003<H`U:BDY008Q20039BT]Jbe[008e[@/icP@mk`=2408mk`03>LhaS36<00@YBP03;F/e[CF]
008mk`03@Q16<DHa00924003?NlicSW>008e[@HaS08e[@8icP03?Nm2448@00=240Dmk`8icP8e[@03
:DXLiacW008DY@036<H]Jbe[00=oo`80019oo`004goo00D007ooOomoo`00009oo`04001oogoo0002
Ool00`00Oomoo`02Ool01000Oomoogoo0SW>00=244YBBU800UJe00=Nmf<HHaP00f]J16mk0f]J16Li
1F<H0fLi1F]J1fmk2V]J4VLi2V<H3VLi1V<H15kg1F<H1FLi0V<H00=Nme[FF]H00UJe00=>LdHaAS40
0Sg_00<e[Be[;F/00RDY00<Q21cW7>L00QS60aBU4a241ABU1QS61AcW1aS61ABU1A242@aS0a240QBU
00<HaQcW7>L00R4800<YBS6<<H`017oo00<007ooOol087oo00D007ooOomoo`00009oo`04001oogoo
0002Ool01@00Oomoogoo000017oo0THa00=Nmf]JJeX00V<H00=:DS6<<H`00QcW00<DYAS66<H00RDY
00<]JcF]=Jd00cW>1cg_0cW>13F]1C6<;CF]1c6<00<e[CW>>Lh00Sg_1D8@00<mkcW>>Lh00SF]00<a
S2U::DX00RDY0b480RU:00<e[DHaAS400U:D00=JeU:DDY@00T8@00<aS2DY9BT00R4800<U:Be[;F/0
0SF]2SW>2Sg_00<icS6<<H`01Be[0SF]0SW>1D8@00<mkcW>>Lh00SF]1S6<0SF]0SW>00<mkd8@@Q00
0d8@1Cg_0SW>0SF]00<YBQcW7>L00QBU00<HaRe[;F/017oo00<007ooOol047oo000COol01@00Oomo
ogoo00000Woo00@007ooOol0009oo`03001oogoo009oo`04001oogooOol2>Lh00d8@BU9:DP02E[D0
0ekgHaQS6003JeX4Kg/3JeX4IcT5HaP3IcT5JeX7Kg/:JeXBIcT:HaP>IcT6HaP4G_L5HaP5IcT2HaP0
0ekgF]IJeP02E[D00dicAS56<@02?Nl00cF];F/]J`029BT00b487>LLi`026<H35:DC48@55:D66<H5
7>L76<H55:D548@936<348@25:D00aS67>LLi`028@P00bU:<H`aS004Ool00`00Oomoo`0POol01@00
Oomoogoo00000Woo00@007ooOol0009oo`05001oogooOol00004Ool2AS400ekgJeY[FP02HaP00dYB
<H`aS0027>L00aBU6<HHaP029BT00be[=Jde[@03>Lh7?Nl3>Lh4=Jd5<H`]=Jd7<H`00cF]>LhicP02
?Nl5@Q000cg_>LhicP02=Jd00c6<:DXYBP029BT38@P2:DX00cF]AS56<@02DY@00e[FDYABU002@Q00
0c6<9BTU:@028@P00bDY;F/]J`02=Jd:>Lh:?Nl00cW><H`aS005;F/2=Jd2>Lh5@Q000cg_>LhicP02
=Jd6<H`2=Jd2>Lh00cg_@Q124003@Q05?Nl2>Lh2=Jd00bU:7>LLi`025:D00aS6;F/]J`04Ool00`00
Oomoo`0@Ool0019oo`8000Aoo`8000Aoo`8000Eoo`04001oogooOol2>Lh00d8@BU9:DP02E[D00ekg
HaQS6003JeX4Kg/3JeX4IcT5HaP3IcT3JeX:Kg/9JeXBIcT:HaP>IcT?HaP5IcT2HaP00ekgF]IJeP02
E[D00dicAS56<@02?Nl00cF];F/]J`029BT00b487>LLi`026<H35:DA48@75:DB6<H55:D548@936<3
48@25:D00aS67>LLi`028@P00bU:<H`aS004Ool00`00Oomoo`0OOol20004Ool20004Ool20004Ool0
0`00Oomoo`02Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L00aBU6<HHaP029BT00be[<H`aS002
=Jd00cW>?Nlmk`05?Nl3>Lh2=Jd:<H`5=Jd3>LhR=Jd7<H`00cF]>LhicP02?Nl5@Q000cg_>LhicP02
=Jd00c6<:DXYBP029BT38@P2:DX00cF]AS56<@02DY@00e[FDYABU002AS400c6<9BTU:@028@P00bDY
;F/]J`02<H`00cF]>LhicP03>Lh:?Nl4>Lh00cF]<H`aS002<H`2;F/00c6<=Jde[@02>Lh5?Nl3>Lh2
=Jd5<H`3=Jd2>Lh00cg_@Q124003@Q07?Nl2=Jd00bU:7>LLi`025:D00aS6:DXYBP04Ool00`00Oomo
o`0@Ool002Eoo`04001oogooOol2>Lh00d8@BU9:DP02E[D00ekgHaQS6003JeX4Kg/3JeX4IcT3HaP5
IcT3JeX:Kg/9JeXDIcT8HaP>IcT?HaP5IcT3HaP2F]H2E[D00dicAS56<@02?Nl00cF]<H`aS002:DX0
0b487>LLi`026<H35:DA48@75:DB6<H55:D548@936<348@25:D00aS67>LLi`028@P00bU:<H`aS004
Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L00aBU6<HH
aP029BT00be[<H`aS002=Jd3>Lh5?Nl3>Lh2=Jd:<H`3=Jd5>LhP=Jd9<H`00cF]>LhicP03?Nl4@Q00
0cg_>LhicP02=Jd00c6<:DXYBP029BT38@P2:DX00cF]AS56<@02DY@00e[FDYABU002AS400cF]9BTU
:@028@P00bDY:DXYBP02<H`00cF]>LhicP02>Lh8?Nl5>Lh3=Jd7<H`2=Jd8>Lh4=Jd5<H`3=Jd2>Lh3
?Nl3@Q05?Nl2>Lh2=Jd00bU:7>LLi`025:D00aS6:DXYBP04Ool00`00Oomoo`0@Ool002Eoo`04001o
ogooOol2>Lh00d8@BU9:DP02E[D00ekgHaQS6003JeX4Kg/3JeX4IcT3HaP5IcT3JeX:Kg/9JeXDIcT8
HaP>IcT?HaP5IcT3HaP2F]H2E[D00dicAS56<@02?Nl00cF]<H`aS002:DX00b487>LLi`026<H35:DA
48@75:DB6<H55:D548@936<348@25:D00aS67>LLi`028@P00bU:<H`aS004Ool00`00Oomoo`0aOol0
0`00Oomoo`02Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L00aBU6<HHaP029BT00be[<H`aS002
=Jd3>Lh5?Nl3>Lh2=Jd:<H`3=Jd5>LhP=Jd9<H`00cF]>LhicP03?Nl4@Q000cg_>LhicP02=Jd00c6<
:DXYBP029BT38@P2:DX00cF]AS56<@02DY@00e[FDYABU002AS400cF]9BTU:@028@P00bDY:DXYBP02
<H`00cF]>LhicP02>Lh8?Nl5>Lh3=Jd7<H`2=Jd8>Lh4=Jd5<H`3=Jd2>Lh3?Nl3@Q05?Nl2>Lh2=Jd0
0bU:7>LLi`025:D00aS6:DXYBP04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2>Lh00d8@BU9:
DP02E[D00ekgHaQS6003JeX4Kg/3JeX4IcT3HaP5IcT3JeX:Kg/9JeXBIcT<HaP<IcT?HaP5IcT3HaP2
G_L2E[D00dicBU9:DP02@Q000cW><H`aS002:DX00bDY8@PQ20027>L00aS65:DDY@025:D=48@95:D@
6<H75:D548@936<348@25:D00aS67>LLi`028@P00bU:<H`aS004Ool00`00Oomoo`0aOol00`00Oomo
o`02Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L00aBU6<HHaP029BT00be[=Jde[@02=Jd3>Lh7
?Nl00cW>=Jde[@0:<H`3=Jd7>Lh7=Jd5>Lh:=Jd3>Lh7=Jd7<H`00cF]>LhicP02>Lh00cg_@Q124002
@Q000cg_>LhicP02=Jd00c6<;F/]J`029BT38@P2:DX00cF]AS56<@02DY@00e[FDYABU002AS400cF]
:DXYBP028@P00bDY:DXYBP02;F/00c6<=Jde[@02>Lh8?Nl3>Lh5=Jd7<H`4=Jd5>Lh5=Jd5<H`3=Jd2
>Lh;?Nl2>Lh2=Jd00bU:7>LLi`025:D00aS6;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogoo
Ool2>Lh00d8@BU9:DP02E[D00ekgHaQS6003JeX4Kg/3JeX4IcT3HaP5IcT3JeX:Kg/9JeXBIcT<HaP<
IcT?HaP5IcT3HaP2G_L2E[D00dicBU9:DP02@Q000cW><H`aS002:DX00bDY8@PQ20027>L00aS65:DD
Y@025:D=48@95:D@6<H75:D548@936<348@25:D00aS67>LLi`028@P00bU:<H`aS004Ool00`00Oomo
o`0aOol00`00Oomoo`02Ool2AS400ekgJeY[FP02HaP00dYB<H`aS0027>L00aBU6<HHaP029BT00be[
=Jde[@02=Jd3>Lh7?Nl00cW>=Jde[@0:<H`3=Jd7>Lh7=Jd5>Lh:=Jd3>Lh7=Jd7<H`00cF]>LhicP02
>Lh00cg_@Q124002@Q000cg_>LhicP02=Jd00c6<;F/]J`029BT38@P2:DX00cF]AS56<@02DY@00e[F
DYABU002AS400cF]:DXYBP028@P00bDY:DXYBP02;F/00c6<=Jde[@02>Lh8?Nl3>Lh5=Jd7<H`4=Jd5
>Lh5=Jd5<H`3=Jd2>Lh;?Nl2>Lh2=Jd00bU:7>LLi`025:D00aS6;F/]J`04Ool00`00Oomoo`0@Ool0
02Eoo`80009oo`8icP03@Q1:DTYB009F]@03G_MS66<H00=[FPA_N`=[FPAW>@=S60EW>@9[FP]_N`U[
FQ9W>@aS60YW>A5S60EW>@=S609Nm`9F]@03DYA:DTYB00924003>LhaS36<008]J`039BTQ2248008L
i`036<HDYABU008DY@d@Q0TDYA0HaPLDY@D@Q0T<H`<@Q08DY@036<HLiacW008Q2003:DXaS36<00=o
o`8003=oo`8000=oo`96<@03G_M[FV]J009S6003BU8aS36<008Li`035:DLiacW008U:@03;F/e[CF]
00<icPTmk`03>Lhe[CF]008e[@HaS0De[@LicPLe[A8icPLe[@DaS0<e[@@icPHmk`8icP8e[@03<H`]
Jbe[00<U:@8Q208YBP03=Je6<DHa009BU003F]IBU5:D0096<@03=JdYBRU:00<Q208U:@8]J`03<H`e
[CF]008icPPmk`<icP@e[@PaS0De[@8icPLe[@DaS0De[@03>Lhmkcg_00Lmk`<icP8aS003:DXLiacW
008DY@036<H]Jbe[00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8icP03@Q1:DTYB009F]@03
G_MS66<H00=[FPA_N`=[FPAW>@=S60=W>@A[FPe_N`E[FQ=W>@mS60QW>A5S60EW>@=S609Nm`9F]@03
DYA:DTYB00924003>Lhe[CF]008]J`03:DXQ2248008Li`036<HDYABU008DY@d@Q0TDY@lHaPPDY@D@
Q0T<H`<@Q08DY@036<HLiacW008Q2003:DXaS36<00Aoo`03001oogoo035oo`03001oogoo009oo`96
<@03G_M[FV]J009S6003BU8aS36<008Li`036<HLiacW008U:@03<H`e[CF]00<icP@mk`=240<mk`8i
cP8e[@DaS0De[@XicP<e[AHicPle[@<icPDmk`8icP8e[@03<H`]Jbe[008YBP<U:@8YBP03=Je6<DHa
009BU003F]IBU5:D0096<@03=JdYBRU:00<Q208U:@8YBP03;F/aS36<008icPPmk`8icPDe[@PaS0he
[@HaS0@e[@<icPLmk`03>Lhe[CF]008]J`039BTLiacW008DY@036<H]Jbe[00Aoo`03001oogoo011o
o`009Goo00@007ooOomoo`8icP03@Q1:DTYB009F]@03G_MS66<H00=[FPA_N`=[FPAW>@=S60=W>@A[
FPe_N`E[FQ=W>@mS60QW>A5S60EW>@=S609Nm`9F]@03DYA:DTYB00924003>Lhe[CF]008]J`03:DXQ
2248008Li`036<HDYABU008DY@d@Q0TDY@lHaPPDY@D@Q0T<H`<@Q08DY@036<HLiacW008Q2003:DXa
S36<00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03G_M[FV]J009S6003BU8aS36<008Li`03
6<HLiacW008U:@03<H`e[CF]00<icP@mk`=240<mk`8icP8e[@DaS0De[@XicP<e[AHicPle[@<icPDm
k`8icP8e[@03<H`]Jbe[008YBP<U:@8YBP03=Je6<DHa009BU003F]IBU5:D0096<@03=JdYBRU:00<Q
208U:@8YBP03;F/aS36<008icPPmk`8icPDe[@PaS0he[@HaS0@e[@<icPLmk`03>Lhe[CF]008]J`03
9BTLiacW008DY@036<H]Jbe[00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8icP03@Q1:DTYB
009F]@03G_MS66<H00=[FPA_N`=[FPAW>@=S60=W>@A[FPE_N`03Lia_Nfmk00E_N`E[FQ=W>A1S60EW
>@US60ENm`MS60=W>@=S609Nm`9JeP03DYA:DTYB0096<@03?Nle[CF]008]J`03:DXU:BDY008Li`<H
aP8DY@d@Q0LDYA4HaPPDY@D@Q0T<H`<@Q08DY@036<HLiacW008Q2003:DXaS36<00Aoo`03001oogoo
035oo`03001oogoo009oo`96<@03G_M[FV]J009S6003CW<aS36<008Li`036<HLiacW008YBP03<H`i
cSW>008icPDmk`E24003?NlicSW>00Xe[BDicPle[@<icPDmk`8icP8e[@03<H`]Jbe[008YBP<U:@8Y
BP03=Je6<DHa009BU003E[EBU5:D0096<@03>LhYBRU:008U:@<Q208U:@03;F/aS36<008icPHmk`@i
cPDe[@XaS0`e[@PaS0<e[@@icP<mk`<icP8e[@8]J`039BTHaQS6008DY@036<H]Jbe[00Aoo`03001o
ogoo011oo`009Goo00@007ooOomoo`8icP03@Q1:DTYB009F]@03G_MS66<H00=[FPA_N`=[FPAW>@=S
60=W>@A[FPE_N`03Lia_Nfmk00E_N`E[FQ=W>A1S60EW>@US60ENm`MS60=W>@=S609Nm`9JeP03DYA:
DTYB0096<@03?Nle[CF]008]J`03:DXU:BDY008Li`<HaP8DY@d@Q0LDYA4HaPPDY@D@Q0T<H`<@Q08D
Y@036<HLiacW008Q2003:DXaS36<00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03G_M[FV]J
009S6003CW<aS36<008Li`036<HLiacW008YBP03<H`icSW>008icPDmk`E24003?NlicSW>00Xe[BDi
cPle[@<icPDmk`8icP8e[@03<H`]Jbe[008YBP<U:@8YBP03=Je6<DHa009BU003E[EBU5:D0096<@03
>LhYBRU:008U:@<Q208U:@03;F/aS36<008icPHmk`@icPDe[@XaS0`e[@PaS0<e[@@icP<mk`<icP8e
[@8]J`039BTHaQS6008DY@036<H]Jbe[00Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8icP03
@Q1:DTYB009F]@03G_MS66<H00=[FPA_N`=[FPAW>@=S60=W>@A[FP=_N`EcW0E_N`E[FQ=W>A1S60EW
>@US60ENm`MS60=W>@=S609Nm`9JeP03DYA>Ldic0096<@03?Nle[CF]008aS003:DXU:BDY008Q2003
7>LHaQS600<DY@/@Q0PDY@lHaPXDY@D@Q0L<H`D@Q08DY@036<HLiacW008Q2003:DXaS36<00Aoo`03
001oogoo035oo`03001oogoo009oo`96<@03G_M[FV]J009S6003CW<e[CF]008Q20036<HQ2248008Y
BP03<H`icSW>008icP<mk`M240<mk`8icPPe[BLicP/e[@@icPPmk`8icP03=Jd]Jbe[008YBP<U:@8Y
BP03=Je2448@009BU003E[EBU5:D0096<@03>Lh]Jbe[008U:@<Q208U:@03:DXaS36<008e[@Hmk`@i
cP<e[@`aS0`e[@PaS0<e[@TicP03=JdaS36<008]J`038@PHaQS6008DY@036<H]Jbe[00Aoo`03001o
ogoo011oo`009Goo00@007ooOomoo`8icP03@Q1:DTYB009F]@03G_MS66<H009[FPE_N`=[FPYW>@9[
FP=_N`UcW0=_N`E[FQ=W>A9S609W>@YS60ENm`MS60=W>@=S609Nm`9JeP03DYA>Ldic0096<@03?Nli
cSW>008aS003:DXU:BDY008Q20037>LHaQS600<DY@/@Q0HDY@`HaPdDY@L@Q0L<H`D@Q08DY@036<HL
iacW008Q2003:DXaS36<00Aoo`03001oogoo035oo`03001oogoo009oo`96<@03G_M[FV]J009S6003
CW<e[CF]008Q20037>LQ2248008YBP03<H`icSW>008icP<mk`M240<mk`8icPPe[@DicP<mkalicPXe
[@DicP<mk`9240<mk`8icP03=JdaS36<008YBP<U:@8YBP03=Je2448@009>L`03E[EBU5:D009:DP03
>Lh]Jbe[008U:@<Q208U:@03:DX]Jbe[008e[@03>Lhmkcg_00<mk`@icP<e[@`aS0`e[@PaS0<e[@Ti
cP03=JdaS36<008]J`038@PHaQS6008@Q0036<HYBRU:00Aoo`03001oogoo011oo`009Goo00@007oo
Oomoo`8icP03@Q1:DTYB009F]@03G_MS66<H009[FPE_N`=[FPYW>@9[FP=_N`UcW0=_N`E[FQ=W>A9S
609W>@YS60ENm`MS60=W>@=S609Nm`9JeP03DYA>Ldic0096<@03?NlicSW>008aS003:DXU:BDY008Q
20037>LHaQS600<DY@/@Q0HDY@`HaPdDY@L@Q0L<H`D@Q08DY@036<HLiacW008Q2003:DXaS36<00Ao
o`03001oogoo035oo`03001oogoo009oo`96<@03G_M[FV]J009S6003CW<e[CF]008Q20037>LQ2248
008YBP03<H`icSW>008icP<mk`M240<mk`8icPPe[@DicP<mkalicPXe[@DicP<mk`9240<mk`8icP03
=JdaS36<008YBP<U:@8YBP03=Je2448@009>L`03E[EBU5:D009:DP03>Lh]Jbe[008U:@<Q208U:@03
:DX]Jbe[008e[@03>Lhmkcg_00<mk`@icP<e[@`aS0`e[@PaS0<e[@TicP03=JdaS36<008]J`038@PH
aQS6008@Q0036<HYBRU:00Aoo`03001oogoo011oo`009Goo0P000Woo0SW>00=244YBBU800UJe00=N
mfLiIcT00V]J1Fmk0f]J2FLi0f]J0Vmk2W>L0fmk1F]J4fLi4V<H0VLi26<H25kg1V<H1FLi00=S65kg
G_L00U[F00=F]DicCW<00THa00=243W>>Lh00S6<00<]JbDY9BT00R4800<LiaS66<H00aBU2a241QBU
2AS641BU1A242`aS0a240QBU00<HaQcW7>L00R4800<YBS6<<H`00goo0P00<goo0P000goo0THa00=N
mf]JJeX00V<H00=>LcF]=Jd00RDY00<Lib488@P00RU:00<aS3F]=Jd00SW>0cg_0T8@0dHa0T8@0cg_
0SW>23F]0cW>1Cg_3SW>1cF]2SW>2SF]0cW>0cg_1D8@0Sg_0SW>00<e[C6<<H`00Re[0bDY0RU:00<a
S48@@Q000Tic00=F]E:DDY@00TYB00<mkc6<<H`00RDY0b480RDY00<YBRe[;F/00SF]1Sg_13W>0cF]
1C6<0Re[1C6<33F]236<0cF]2CW>00<e[C6<<H`00Re[00<Q21S66<H00Q2400<DYBU::DX017oo00<0
07ooOol047oo000UOol01000Oomoogoo0SW>00=244YBBU800UJe00=NmfLiIcT00V]J1Fmk0f]J2FLi
0f]J0Vmk2W>L0fmk1F]J4fLi4V<H0VLi26<H25kg1V<H1FLi00=S65kgG_L00U[F00=F]DicCW<00THa
00=243W>>Lh00S6<00<]JbDY9BT00R4800<LiaS66<H00aBU2a241QBU2AS641BU1A242`aS0a240QBU
00<HaQcW7>L00R4800<YBS6<<H`017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX0
0V<H00=>LcF]=Jd00RDY00<Lib488@P00RU:00<aS3F]=Jd00SW>0cg_0T8@0dHa0T8@0cg_0SW>23F]
0cW>1Cg_3SW>1cF]2SW>2SF]0cW>0cg_1D8@0Sg_0SW>00<e[C6<<H`00Re[0bDY0RU:00<aS48@@Q00
0Tic00=F]E:DDY@00TYB00<mkc6<<H`00RDY0b480RDY00<YBRe[;F/00SF]1Sg_13W>0cF]1C6<0Re[
1C6<33F]236<0cF]2CW>00<e[C6<<H`00Re[00<Q21S66<H00Q2400<DYBU::DX017oo00<007ooOol0
47oo000UOol01000Oomoogoo0SW>00=244icCW<00UJe00=NmfLiIcT00V]J1Vmk16]J1fLi00=[FVmk
Kg/00Vmk0g>L0gNm17>L0fmk1F]J56Li3f<H1FLi1f<H25kg16<H1fLi00=S65kgG_L00U[F00=F]Dic
CW<00THa00=243W>>Lh00S6<00<]JbDY9BT00R4800<LiaS66<H00aBU2a2421BU0aS651BU1A242`aS
0a240QBU00<HaQcW7>L00R4800<YBS6<<H`017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=N
mf]JJeX00V<H00=>LcF]=Jd00RDY00<Lib488@P00RDY00<]JcF]=Jd00SW>0cg_1d8@00<mkcW>>Lh0
0SW>00<e[C6<<H`00c6<13F]00<icSg_?Nl00cg_1SW>00<e[CW>>Lh00cW>2SF]2CW>2SF]0cW>0cg_
1D8@0Sg_0SW>00<e[C6<<H`00RU:0bDY0RU:00<aS48@@Q000Tic00=F]E:DDY@00TYB00<mkc6<<H`0
0RU:00<U:B488@P00RDY00<YBRe[;F/00SF]1Sg_13W>0cF]336<0cF]1CW>1CF]1C6<13F]0cW>0Sg_
1SW>0SF]0Re[00<U:AS66<H00Q2400<DYBU::DX017oo00<007ooOol047oo000UOol01000Oomoogoo
0SW>00=244icCW<00UJe00=NmfLiIcT00V]J00=_Ng>LLi`01Fmk16]J00=W>F]JJeX00V]J0fmk0g>L
1gNm0g>L16mk0f]J5VLi36<H1VLi2F<H1Ekg1F<H1fLi00=S65kgG_L00U[F00=F]DicCW<00TYB00=2
43W>>Lh00S6<00<]JbDY9BT00R4800<LiaS66<H00QBU3A247QBU1A2430aS112400<DYAS66<H00R48
00<U:Be[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00VLi00=>LcF]=Jd0
0R4800<HaQcW7>L00RDY00<]Jc6<<H`00SF]00<icSg_?Nl01d8@00<mkcW>>Lh00cF]1c6<0SF]0cW>
0cg_13W>4SF]1cW>33F]0cW>0cg_1D8@0Sg_0SW>00<e[C6<<H`00RU:0bDY0RU:00<aS48@@Q000Tic
00=F]E:DDY@00TYB00<mkc6<<H`00RU:00<U:B488@P00R4800<YBS6<<H`00SW>1D8@00<mkcW>>Lh0
0SW>1CF]236<13F]23W>0cF]1C6<0SF]0cW>1cg_0cW>0SF]0S6<00<U:AS66<H00Q2400<DYBU::DX0
17oo00<007ooOol047oo000UOol01000Oomoogoo0SW>00=244icCW<00UJe00=NmfLiIcT00V]J00=_
Ng>LLi`01Fmk16]J00=W>F]JJeX00V]J0fmk0g>L1gNm0g>L16mk0f]J5VLi36<H1VLi2F<H1Ekg1F<H
1fLi00=S65kgG_L00U[F00=F]DicCW<00TYB00=243W>>Lh00S6<00<]JbDY9BT00R4800<LiaS66<H0
0QBU3A247QBU1A2430aS112400<DYAS66<H00R4800<U:Be[;F/017oo00<007ooOol0<Goo00<007oo
Ool00Woo0THa00=Nmf]JJeX00VLi00=>LcF]=Jd00R4800<HaQcW7>L00RDY00<]Jc6<<H`00SF]00<i
cSg_?Nl01d8@00<mkcW>>Lh00cF]1c6<0SF]0cW>0cg_13W>4SF]1cW>33F]0cW>0cg_1D8@0Sg_0SW>
00<e[C6<<H`00RU:0bDY0RU:00<aS48@@Q000Tic00=F]E:DDY@00TYB00<mkc6<<H`00RU:00<U:B48
8@P00R4800<YBS6<<H`00SW>1D8@00<mkcW>>Lh00SW>1CF]236<13F]23W>0cF]1C6<0SF]0cW>1cg_
0cW>0SF]0S6<00<U:AS66<H00Q2400<DYBU::DX017oo00<007ooOol047oo000UOol01000Oomoogoo
0SW>00=244icCW<00UJe00=NmfLiIcT00Vmk1W>L16mk1f]J00=_Ng>LLi`00W>L0gNm0g_N17Nm00=c
W6mkKg/00Vmk0f]J66Li1V<H36Li1f<H1Ekg1F<H1fLi0f<H0U[F00=F]DicCW<00TYB00=243W>>Lh0
0S6<00<]JbDY9BT00R4800<LiaS66<H00QBU0a241@aS1A247ABU1A241`aS0`Q21@aS0Q2400<DYAS6
6<H00R4800<U:Be[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00VLi00=>
LcF]=Jd00R480aS60R4800<YBS6<<H`00SF]00<icSg_?Nl00Sg_1D8@00<mkcW>>Lh00SF]0c6<0Re[
1C6<00<e[CW>>Lh01cW>4SF]1CW>3cF]13W>23g_0SW>00<aS2e[;F/00RU:00<U:B488@P00RDY00<a
S48@@Q000Tic00=F]E:DDY@00TYB00<mkc6<<H`00RU:00<U:B488@P00R4800<YBS6<<H`00Sg_00=2
44HaAS400THa00=243g_?Nl00SW>1SF]136<1CF]0cW>1Cg_13W>00<e[C6<<H`00c6<0SF]0SW>0cg_
0T8@1Sg_0SW>0SF]00<YBQcW7>L00aBU0RU:17oo00<007ooOol047oo000UOol01000Oomoogoo0SW>
00=244icCW<00UJe00=NmfLiIcT00Vmk1W>L16mk1f]J00=_Ng>LLi`00W>L0gNm0g_N17Nm00=cW6mk
Kg/00Vmk0f]J66Li1V<H36Li1f<H1Ekg1F<H1fLi0f<H0U[F00=F]DicCW<00TYB00=243W>>Lh00S6<
00<]JbDY9BT00R4800<LiaS66<H00QBU0a241@aS1A247ABU1A241`aS0`Q21@aS0Q2400<DYAS66<H0
0R4800<U:Be[;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00VLi00=>LcF]
=Jd00R480aS60R4800<YBS6<<H`00SF]00<icSg_?Nl00Sg_1D8@00<mkcW>>Lh00SF]0c6<0Re[1C6<
00<e[CW>>Lh01cW>4SF]1CW>3cF]13W>23g_0SW>00<aS2e[;F/00RU:00<U:B488@P00RDY00<aS48@
@Q000Tic00=F]E:DDY@00TYB00<mkc6<<H`00RU:00<U:B488@P00R4800<YBS6<<H`00Sg_00=244Ha
AS400THa00=243g_?Nl00SW>1SF]136<1CF]0cW>1Cg_13W>00<e[C6<<H`00c6<0SF]0SW>0cg_0T8@
1Sg_0SW>0SF]00<YBQcW7>L00aBU0RU:17oo00<007ooOol047oo000UOol01000Oomoogoo0SW>00=2
44icCW<00UJe00=S66LiIcT00Vmk27>L2Fmk0g>L0WNm27_N0WNm0g>L0Vmk1F]J1VLi1f]J6fLi26<H
0Ukg1F<H2VLi0V<H0Ukg00=F]DicCW<00TYB00=243W>>Lh00S6<00<]JbDY9BT00R4800<LiaBU5:D0
0QBU00<@Q0aS36<01`aS0a243aBU11242QBU1A241@aS1`Q20`aS0Q2400<DYAS66<H00QcW00<U:Be[
;F/017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=Nmf]JJeX00VLi00=>Lc6<<H`00QcW00<D
YAS66<H00R4800<YBRe[;F/00S6<00<e[CW>>Lh00Sg_0d8@0cg_0SW>0SF]00<aS2e[;F/01Be[0S6<
0cF]1CW>4cF]0cW>1cF]1S6<1CF]13W>1Sg_0SW>0SF]00<aS2e[;F/00RDY0b480RDY00<aS3g_?Nl0
0Tic00=F]E:DDY@00TYB00=243F]=Jd00RU:00<U:B488@P00R4800<YBSF]=Jd00Sg_00=6<DYBBU80
0THa00=243g_?Nl00cW>33F]0SW>2Sg_0SW>0cF]0S6<0cF]0SW>00<mkd8@@Q00248@0Sg_0SF]00<Y
BQcW7>L00QBU00<HaRU::DX017oo00<007ooOol047oo000UOol01000Oomoogoo0SW>00=244icCW<0
0UJe00=S66]JJeX00Vmk00=cW7NmMkd00gNm17>L1Fmk0g>L0WNm1G_N0Woo0g_N0gNm0W>L0fmk1F]J
0VLi36]J6fLi3F<H2VLi0V<H0Ukg00=F]E:DDY@00TYB00=243W>>Lh00S6<00<]JbDY9BT00R4800<H
aQBU5:D00a242@aS0a2431BU2Q241aBU1A240`aS2PQ210aS00<@Q1S66<H00QcW00<U:Be[;F/017oo
00<007ooOol0<Goo00<007ooOol00Woo0THa00=NmfmkKg/00VLi00=>Lc6<<H`00QS600<@Q1BU5:D0
0QcW00<U:Be[;F/00S6<00<e[CW>>Lh01cg_00<icSF]=Jd00S6<0be[0RU:0be[0c6<0SF]0cW>1SF]
236<1CF]0cW>1cF]2S6<1CF]0cW>13g_0cW>0SF]00<aS2U::DX00RDY0b480RDY00<aS3g_?Nl00Tic
00=F]E:DDY@00TYB00=243F]=Jd00RU:1B4800<YBSF]=Jd00T8@00=:DTicCW<00TYB00=6<Cg_?Nl0
0cW>2cF]0cW>0cg_148@0cg_0SW>0cF]0S6<0cF]0SW>00<mkd8@@Q001dHa0d8@0SW>00<]Jb488@P0
0QBU00<HaRU::DX017oo00<007ooOol047oo000UOol20002Ool2>Lh00d8@CW=>L`02E[D00f<HJeY[
FP02Kg/00g>LMkeg_@03Mkd4Li`5Kg/3Li`2Mkd5Nmh2Ool3Nmh3Mkd2Li`3Kg/5JeX2IcT<JeXKIcT=
HaP:IcT2HaP2G_L00eJeDYABU002BU800d8@>LhicP02<H`00be[9BTU:@028@P00aS65:DDY@0348@9
36<348@<5:D:48@75:D548@336<:248436<00a246<HHaP027>L00bDY;F/]J`03Ool2000cOol20003
Ool2AS400ekgKg]_N`02IcT00dic<H`aS0026<H00a245:DDY@027>L00bDY;F/]J`02<H`00cF]>Lhi
cP07?Nl00cW>=Jde[@02<H`3;F/2:DX3;F/3<H`2=Jd3>Lh6=Jd8<H`5=Jd3>Lh7=Jd:<H`5=Jd3>Lh4
?Nl3>Lh2=Jd00c6<:DXYBP029BT38@P29BT00c6<?Nlmk`02CW<00eJeDYABU002BU800d8@=Jde[@02
:DX58@P00bU:=Jde[@02@Q000dYBCW=>L`02BU800dHa?Nlmk`03>Lh;=Jd3>Lh3?Nl4@Q03?Nl2>Lh3
=Jd2<H`3=Jd2>Lh00cg_@Q124007AS43@Q02>Lh00be[8@PQ20025:D00aS6:DXYBP04Ool00`00Oomo
o`0@Ool002Eoo`04001oogooOol2=Jd00d8@CW=>L`02E[D00f<HJeY[FP02Li`8Mkd9Li`3Mkd3Nmh5
Ool4Nmh00gNmLiacW003Kg/EJeXIIcT=HaP5IcT2JeX3IcT2HaP2G_L00eJeDYABU002BU800d8@>Lhi
cP02<H`00bU:9BTU:@027>L00aS65:DDY@0248@:36<548@85:D>48@55:D548@336<<248236<00a24
5:DDY@027>L00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2BU800f<HKg]_N`02HaP0
0dic;F/]J`026<H348@26<H00b48:DXYBP02;F/00c6<>LhicP07?Nl00cW>=Jde[@02<H`00be[:DXY
BP03:DX4;F/00c6<=Jde[@09=Jd8<H`==Jd5<H`2;F/7<H`3=Jd5>Lh2?Nl3>Lh2<H`00be[:DXYBP02
9BT38@P29BT00c6<?Nlmk`02BU83DY@2BU800d8@=Jde[@02:DX00b487>LLi`028@P00bU:=Jde[@02
@Q05CW<00dHa@Q124002?Nl3>Lh7=Jd3>Lh5?Nl4@Q03?Nl2>Lh00cF]<H`aS002<H`3=Jd2>Lh3@Q08
AS42@Q02?Nl00c6<8@PQ20036<H2;F/4Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00d8@
CW=>L`02E[D00f<HJeY[FP02Li`8Mkd9Li`3Mkd3Nmh5Ool4Nmh00gNmLiacW003Kg/EJeXIIcT=HaP5
IcT2JeX3IcT2HaP2G_L00eJeDYABU002BU800d8@>LhicP02<H`00bU:9BTU:@027>L00aS65:DDY@02
48@:36<548@85:D>48@55:D548@336<<248236<00a245:DDY@027>L00bDY;F/]J`04Ool00`00Oomo
o`0aOol00`00Oomoo`02Ool2BU800f<HKg]_N`02HaP00dic;F/]J`026<H348@26<H00b48:DXYBP02
;F/00c6<>LhicP07?Nl00cW>=Jde[@02<H`00be[:DXYBP03:DX4;F/00c6<=Jde[@09=Jd8<H`==Jd5
<H`2;F/7<H`3=Jd5>Lh2?Nl3>Lh2<H`00be[:DXYBP029BT38@P29BT00c6<?Nlmk`02BU83DY@2BU80
0d8@=Jde[@02:DX00b487>LLi`028@P00bU:=Jde[@02@Q05CW<00dHa@Q124002?Nl3>Lh7=Jd3>Lh5
?Nl4@Q03?Nl2>Lh00cF]<H`aS002<H`3=Jd2>Lh3@Q08AS42@Q02?Nl00c6<8@PQ20036<H2;F/4Ool0
0`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00d8@CW=>L`02F]H00f<HJeY[FP02Li`3Mkd2Nmh5
Mkd5Li`3Mkd4Nmh8Ool2Nmh00gNmLiacW003Kg/FJeXHIcT=HaP4IcT3JeX3IcT2HaP2G_L00eJeDYAB
U002BU800d8@>LhicP02<H`00bU:9BTU:@027>L00aS65:DDY@0248@:36<548@85:D?48@45:D548@3
36<524841243248236<00a245:DDY@027>L00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02
Ool2BU800f<HKg]_N`02IcT00dYB;F/]J`026<H00`aS48@@Q0026<H00b48:DXYBP02;F/00cF]>Lhi
cP05?Nl3>Lh2=Jd2<H`00be[:DXYBP05:DX2;F/00c6<=Jde[@07=Jd<<H`;=Jd4<H`5;F/5<H`3=Jd5
>Lh2?Nl3>Lh2=Jd00be[:DXYBP029BT38@P29BT00be[?Nlmk`02BU83DY@2BU800d8@=Jde[@02:DX0
0b487>LLi`028@P00bU:=Jde[@02@Q000dicDYABU002CW<00dYB@Q124002?Nl00cW>=Jde[@09=Jd0
0cW>?Nlmk`0:?Nl2>Lh00cF]<H`aS003<H`2=Jd2>Lh00d8@AS56<@08AS42@Q02?Nl00c6<9BTU:@02
6<H00acW;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd00d8@CW=>L`02F]H00f<H
JeY[FP02Li`3Mkd2Nmh5Mkd5Li`3Mkd4Nmh8Ool2Nmh00gNmLiacW003Kg/FJeXHIcT=HaP4IcT3JeX3
IcT2HaP2G_L00eJeDYABU002BU800d8@>LhicP02<H`00bU:9BTU:@027>L00aS65:DDY@0248@:36<5
48@85:D?48@45:D548@336<524841243248236<00a245:DDY@027>L00bDY;F/]J`04Ool00`00Oomo
o`0aOol00`00Oomoo`02Ool2BU800f<HKg]_N`02IcT00dYB;F/]J`026<H00`aS48@@Q0026<H00b48
:DXYBP02;F/00cF]>LhicP05?Nl3>Lh2=Jd2<H`00be[:DXYBP05:DX2;F/00c6<=Jde[@07=Jd<<H`;
=Jd4<H`5;F/5<H`3=Jd5>Lh2?Nl3>Lh2=Jd00be[:DXYBP029BT38@P29BT00be[?Nlmk`02BU83DY@2
BU800d8@=Jde[@02:DX00b487>LLi`028@P00bU:=Jde[@02@Q000dicDYABU002CW<00dYB@Q124002
?Nl00cW>=Jde[@09=Jd00cW>?Nlmk`0:?Nl2>Lh00cF]<H`aS003<H`2=Jd2>Lh00d8@AS56<@08AS42
@Q02?Nl00c6<9BTU:@026<H00acW;F/]J`04Ool00`00Oomoo`0@Ool002Eoo`04001oogooOol2=Jd0
0d8@CW=>L`02F]H00f<HJeY[FP02Li`00gNmNmikgP03Nmh;Mkd3Nmh:Ool2Nmh00gNmLiacW002Li`0
0fmkJeY[FP0FJeXGIcT<HaP4IcT3JeX3IcT2HaP2G_L00eJeDYABU002BU800d8@>LhicP02<H`00be[
9BTU:@027>L00aS65:DDY@0248@336<3248436<548@85:D?48@45:D548@336<424851243248236<0
0a245:DDY@027>L00bDY;F/]J`04Ool00`00Oomoo`0aOol00`00Oomoo`02Ool2BU800f<HKg]_N`02
IcT00dic;F/]J`026<H00`aS48@@Q0025:D00b48:DXYBP02;F/00cF]>LhicP05?Nl3>Lh2=Jd2<H`0
0be[:DXYBP03:DX4;F/00c6<=Jde[@07=Jd<<H`;=Jd4<H`5;F/5<H`3=Jd3>Lh4?Nl3>Lh2=Jd00c6<
:DXYBP029BT38@P29BT00be[?Nlmk`02BU83DY@2BU800d8@=Jde[@02:DX00b487>LLi`027>L00bDY
=Jde[@02@Q000dicDYABU002CW<00dYB@Q124002?Nl00cW>=Jde[@02=Jd3<H`4=Jd3>Lh8?Nl2>Lh3
=Jd5<H`2=Jd2>Lh00d8@AS56<@08AS42@Q02?Nl00c6<9BTU:@026<H00acW<H`aS004Ool00`00Oomo
o`0@Ool0015oo`D00003Ool00000008000=oo`8000Eoo`04001oogooOol2>Lh00d8@CW=>L`02F]H0
0f<HJeY[FP02Li`00gNmNmikgP05Nmh9Mkd3Nmh:Ool2Nmh00gNmLiacW002Li`00fmkJeY[FP0FJeXG
IcT<HaP:IcT2HaP2G_L00eJeDYABU002BU800d8@>LhicP02<H`00be[9BTU:@028@P00aS65:DDY@02
48@336<3248636<348@85:DH48@336<<248236<00a245:DDY@027>L00bDY;F/]J`04Ool00`00Oomo
o`0NOol500000goo000000020003Ool20004Ool00`00Oomoo`02Ool2BU800fLiKg]_N`02IcT00dic
<H`aS0026<H00`aS48@@Q0026<H00b48:DXYBP02<H`00cF]>LhicP05?Nl2>Lh3=Jd2<H`3;F/3:DX4
;F/00c6<=Jde[@03>Lh4=Jd=<H`:=Jd4<H`5;F/5<H`3=Jd3>Lh4?Nl3>Lh2=Jd00c6<;F/]J`029BT3
8@P29BT00be[?Nlmk`02BU83DY@2BU800d8@=Jde[@02;F/00b487>LLi`027>L00bDY<H`aS002?Nl0
0dYBCW=>L`02CW<00dYB@Q124002?Nl00cW>=Jde[@07<H`3=Jd4>Lh5?Nl3>Lh2=Jd6<H`2=Jd2>Lh0
0cg_@Q124007AS43@Q02>Lh00be[8@PQ20026<H00acW;F/]J`04Ool00`00Oomoo`0@Ool001=oo`05
001oogooOol00005Ool01000Oomoo`0017oo00@007ooOomoo`8icP03@Q1>Ldic009JeP03HaQ[FV]J
009cW003MkekgW_N00EkgPUg_@=kgPYoo`9kgP03MkecW7>L009cW003Kg][FV]J01I[FQMW>@aS60YW
>@9S609Nm`03E[EBU5:D009:DP03@Q0icSW>008aS003;F/U:BDY008Q20036<HDYABU008@Q0<<H`<8
@PH<H`<@Q0PDYAP@Q0<<H``8@P8<H`0348@DYABU008Li`039BT]Jbe[00Aoo`03001oogoo021oo`05
001oogooOol00005Ool01000Oomoo`000goo00<007ooOol00Woo0TYB00=W>FmkKg/00VLi00=>Lc6<
<H`00QS600<<Ha2448@00QS600<Q22U::DX00S6<00<e[CW>>Lh01Cg_0SW>0cF]0S6<0be[0bU:12e[
00<aS3F]=Jd00cW>13F]3C6<2SF]136<1Be[1C6<0cF]0cW>13g_0cW>0SF]00<aS2e[;F/00RDY0b48
0RDY00<]Jcg_?Nl00TYB0e:D0TYB00=243F]=Jd00Re[00<Q21cW7>L00QcW00<U:C6<<H`00Sg_00=:
DTicCW<00Tic00=:DT8@@Q000Sg_00<icSF]=Jd01c6<0cF]13W>1Cg_0cW>0SF]1S6<0SF]0SW>00<m
kd8@@Q001dHa0d8@0SW>00<]Jb488@P00QS600<Libe[;F/017oo00<007ooOol047oo000COol00`00
Oomoo`02Ool00`00Oomoo`02Ool01000Oomoo`0017oo0`0000AoocW>>Li2409>L`9JeP03HaQ[FV]J
009cW003MkekgW_N00EkgPUg_@=kgPYoo`9kgP03MkecW7>L00=_NaI[FQQW>@eS60YW>@9S609Nm`03
E[EBU5:D009:DP03@Q0mkcg_008e[@03;F/U:BDY008Q20036<HDYABU008@Q0<<H`<8@PH<H`<@Q0PD
YAP@Q0<<H`X8@P8<H`8@Q0035:DHaQS6008Li`039BT]Jbe[00=oo`80029oo`03001oogoo009oo`03
001oogoo009oo`04001oogoo0003Ool30002Ool2BU800f<HLiacW002IcT00dic<H`aS0026<H348@2
6<H00b48:DXYBP02<H`00cW>?Nlmk`05?Nl2>Lh3=Jd2<H`8;F/3<H`2=Jd3>Lh6=Jd;<H`:=Jd><H`3
=Jd:>Lh2=Jd00c6<;F/]J`02:DX00bDY8@PQ20029BT00be[>LhicP02AS400dicDYABU002BU800d8@
>LhicP02;F/00b487>LLi`026<H00b48;F/]J`02?Nl00dYBCW=>L`02CW<00dHa@Q124002?Nl00cW>
=Jde[@02=Jd3<H`5=Jd5>Lh4?Nl3>Lh3=Jd5<H`2=Jd2>Lh00cg_@Q124008@Q02?Nl2>Lh00be[7>LL
i`025:D00aS6;F/]J`03Ool2000BOol001=oo`03001oogoo00=oo`05001oogooOol00002Ool00`00
Oomoo`02Ool01000Oomoogoo0SW>00=244icCW<00U[F00=S66]JJeX00W>L00=g_G_NNmh01G_N2GNm
0g_N2Woo0W_N00=g_G>LLi`00fmk5V]J66Li3F<H2VLi0V<H0Ukg00=F]E:DDY@00TYB00=243g_?Nl0
0SF]00<]JbDY9BT00R4800<HaQBU5:D00Q240`aS0`Q21PaS0a2421BU61240`aS2PQ20PaS0Q2400<D
YAS66<H00QcW00<U:Be[;F/017oo00<007ooOol087oo00<007ooOol00goo00D007ooOomoo`00009o
o`05001oogooOol00004Ool2BU800f<HLiacW002IcT00dic<H`aS0026<H348@26<H00b48:DXYBP02
<H`00cW>?Nlmk`05?Nl2>Lh3=Jd2<H`8;F/3<H`2=Jd3>Lh6=Jd;<H`:=Jd><H`3=Jd:>Lh2=Jd00c6<
;F/]J`02:DX00bDY8@PQ20029BT00be[>LhicP02AS400dicDYABU002BU800d8@>LhicP02;F/00b48
7>LLi`026<H00b48;F/]J`02?Nl00dYBCW=>L`02CW<00dHa@Q124002?Nl00cW>=Jde[@02=Jd3<H`5
=Jd5>Lh4?Nl3>Lh3=Jd5<H`2=Jd2>Lh00cg_@Q124008@Q02?Nl2>Lh00be[7>LLi`025:D00aS6;F/]
J`04Ool00`00Oomoo`0@Ool001=oo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0
0Woo00@007ooOomoo`8icP03AS5>Ldic009JeP03HaQ[FV]J009cW003MkekgW_N00EkgPUg_@=kgPQo
o`AkgP03MkecW7>L00=_N`E[FPAW>@a[FQUW>@eS60UW>@=S609Nm`03E[EBU5:D009:DP03AS4mkcg_
008e[@03;F/YBRU:008Q20037>LDYABU008@Q0<<H`<8@PH<H`<@Q0XDYA@@Q0L<H`D8@PD<H`8@Q003
5:DHaQS6008Q2003:DXaS36<00Aoo`03001oogoo021oo`05001oogooOol00002Ool01000Oomoo`00
0Woo00D007ooOomoo`0000Aoo`96<@03HaQcW7>L009[FP03CW<aS36<008HaP0348@DYABU008Li`03
9BT]Jbe[008e[@03>Lhmkcg_00Dmk`8icP<e[@<aS0L]J`8aS0<e[@DicPDe[@XaS0`e[@XaS0De[@Xi
cP8e[@03<H`]Jbe[008YBPDU:@03;F/icSW>0096<@=>L`9:DP03AS4icSW>008]J`038@PHaQS6008H
aP038@P]Jbe[008icP03AS5:DTYB009:DP03AS52448@008mk`03>Lhe[CF]00Te[@licPPe[@8icP03
?Nm2448@00M240<mk`8e[@03:DXHaQS600<@Q08U:@Aoo`03001oogoo011oo`004Woo0P0017oo0P00
17oo0P001Goo00@007ooOomoo`8icP03AS5>Ldic009JeP03HaQ[FV]J009cW0=g_@EkgPUg_@EkgPEo
o`=kgP=g_@9cW09_N`E[FRQW>A=S60=W>@=S609Nm`9JeP03E[EBU5:D009>L`03AS4mkcg_008icP03
<H`YBRU:008U:@037>LHaQS6008DY@0348@<H`aS00L<H`<@Q0lDYA<@Q0`<H`<@Q08DY@036<HLiacW
008Q2003:DXaS36<00Aoo`03001oogoo01moo`8000Aoo`8000Aoo`8000Aoo`03001oogoo009oo`92
4003G_M_Nfmk009[FP03DY@e[CF]008Li`035:DHaQS6008Q2003:DXaS36<008e[@<mk`=2408mk`8i
cPHe[@TaS0<e[@LicPDe[@DaS1`e[@XicPDe[@8aS08]J`03:DXU:BDY008YBP03<H`icSW>0096<@03
BU9>Ldic009:DP03AS4mkcg_008aS0038@PHaQS6008DY@037>LYBRU:008icP03AS5:DTYB0096<@03
@Q0mkcg_00<icP`e[@hicPHe[@@icPXmk`<icP8aS0039BTDYABU0088@P0336<Q224800Aoo`03001o
ogoo011oo`009Goo00@007ooOomoo`8icP03AS5>Ldic009JeP03HaQ[FV]J009cW0=g_@EkgPUg_@Ek
gPEoo`=kgP=g_@9cW09_N`E[FRQW>A=S60=W>@=S609Nm`9JeP03E[EBU5:D009>L`03AS4mkcg_008i
cP03<H`YBRU:008U:@037>LHaQS6008DY@0348@<H`aS00L<H`<@Q0lDYA<@Q0`<H`<@Q08DY@036<HL
iacW008Q2003:DXaS36<00Aoo`03001oogoo035oo`03001oogoo009oo`924003G_M_Nfmk009[FP03
DY@e[CF]008Li`035:DHaQS6008Q2003:DXaS36<008e[@<mk`=2408mk`8icPHe[@TaS0<e[@LicPDe
[@DaS1`e[@XicPDe[@8aS08]J`03:DXU:BDY008YBP03<H`icSW>0096<@03BU9>Ldic009:DP03AS4m
kcg_008aS0038@PHaQS6008DY@037>LYBRU:008icP03AS5:DTYB0096<@03@Q0mkcg_00<icP`e[@hi
cPHe[@@icPXmk`<icP8aS0039BTDYABU0088@P0336<Q224800Aoo`03001oogoo011oo`009Goo00@0
07ooOomoo`8mk`03AS5>Ldic009JeP03HaQ[FV]J009_N`03Liag_GNm00mg_@YkgPAg_@03Lia_Nfmk
009_N`=[FREW>@YS60QNm`aS609Nm`9JeP03E[EBU5:D009>L`03AS52448@008icP03=Jd]Jbe[008U
:@038@PHaQS6008DY@0348@<H`aS00L<H`<@Q0DDY@@HaPlDY@X@Q0L<H`H@Q08DY@<HaP8Q208U:@03
;F/aS36<00Aoo`03001oogoo035oo`03001oogoo009oo`924003G_McW7>L009[FP03E[DicSW>008Q
20036<HLiacW008U:@03<H`icSW>008mk`03@Q16<DHa0096<@=240<mk`LicPLe[@<icPDmk`DicPTe
[A8icPDe[@DicPDmk`LicP<e[@8aS0D]J`03<H`icSW>00924003BU9>Ldic009:DP03AS4mkcg_008a
S0039BTHaQS6008DY@036<HU:BDY008e[@03?Nm2448@00924003?NlicSW>00De[@TaS0Xe[@03>Lhe
[CF]00Xe[@LicPHe[@8aS08YBP037>L<H`aS00848@03248LiacW00Aoo`03001oogoo011oo`009Goo
00@007ooOomoo`8mk`03AS5>Ldic009JeP03HaQ[FV]J009_N`03Liag_GNm00mg_@YkgPAg_@03Lia_
Nfmk009_N`=[FREW>@YS60QNm`aS609Nm`9JeP03E[EBU5:D009>L`03AS52448@008icP03=Jd]Jbe[
008U:@038@PHaQS6008DY@0348@<H`aS00L<H`<@Q0DDY@@HaPlDY@X@Q0L<H`H@Q08DY@<HaP8Q208U
:@03;F/aS36<00Aoo`03001oogoo035oo`03001oogoo009oo`924003G_McW7>L009[FP03E[DicSW>
008Q20036<HLiacW008U:@03<H`icSW>008mk`03@Q16<DHa0096<@=240<mk`LicPLe[@<icPDmk`Di
cPTe[A8icPDe[@DicPDmk`LicP<e[@8aS0D]J`03<H`icSW>00924003BU9>Ldic009:DP03AS4mkcg_
008aS0039BTHaQS6008DY@036<HU:BDY008e[@03?Nm2448@00924003?NlicSW>00De[@TaS0Xe[@03
>Lhe[CF]00Xe[@LicPHe[@8aS08YBP037>L<H`aS00848@03248LiacW00Aoo`03001oogoo011oo`00
9Goo00@007ooOomoo`8mk`03AS5>Ldic009JeP03HaQ[FV]J009_N`03Liag_GNm00Eg_@UcW0eg_@9c
W0=_N`=[FQEW>AUS60mNm`ES60ENm`9JeP03E[EBU5:D009>L`03BU92448@008mk`03=JdaS36<008Y
BP039BTLiacW008HaP035:D@Q124008@Q0<<H`@@Q0DDY@/HaP`DY@l@Q0DDY@@HaP037>LQ2248008U
:@03;F/e[CF]00Aoo`03001oogoo035oo`03001oogoo009oo`924003HaQg_GNm009_N`03F]Hmkcg_
008YBP039BTYBRU:008aS003>Li2448@0096<@03BU9>Ldic009>L`=:DPM6<@=240Pmk`]240dmk`Y2
40dmk`U240Dmk`<icPLe[@03>Lhmkcg_0096<@I:DP92408e[@03:DXLiacW008DY@036<HQ2248008]
J`03=JdicSW>008icP03=JdaS36<008aS0H]J`8YBPT]Ja@aS0<e[@8aS003;F/YBRU:00<YBP8U:@8Q
20035:D8@PQ200800003248Q224800Aoo`03001oogoo011oo`009Goo00@007ooOomoo`8mk`03AS5>
Ldic009F]@03G_MW>FLi009[FP03Kg]cW7>L00McW0M_N`IcW09g_@EcW0=_N`A[FP=W>BMS61]Nm`=J
eP=F]@9BU09>L`03BU96<DHa008mk`03>LhaS36<008]J`039BTQ2248008HaP<DY@L@Q0<DY@LHaPDL
i`XHaPPDY@L@Q0LDY@<HaP@Li`038@PU:BDY008YBP03;F/e[CF]00Aoo`03001oogoo035oo`03001o
ogoo009oo`96<@03IcUkgW_N009g_@03G_M6<DHa008aS003;F/aS36<008icP03AS5>Ldic00=BU0EF
]@ABU0I>L`9:DPQ6<@U:DQi6<@M240]6<@A240Xmk`=240=6<@E:DP96<@8icP03;F/LiacW008DY@03
6<HLiacW008U:@03;F/aS36<008aS0<]J`<YBP@U:@DQ20LU:A0YBPL]J`8YBP039BTQ2248008Li`<H
aP8DY@0336<48@@Q00800003248Q224800Aoo`03001oogoo011oo`009Goo0P000Woo0Sg_00=6<Dic
CW<00UJe00=NmfLiIcT00V]J00=_Ng>LLi`01g>L1fmk1W>L0WNm1G>L0fmk16]J0fLi9f<H6ekg0e[F
0eJe0U:D0Tic00=:DTHaAS400Sg_00<icS6<<H`00Re[00<U:B488@P00QS60aBU1a240aBU1aS61AcW
2QS621BU1a241aBU0aS611cW00<Q22DY9BT00RU:00<]JcF]=Jd00goo0P00<goo0P000goo0THa00=W
>G_NNmh00WNm00=NmdHaAS400S6<00<]Jc6<<H`00SW>00=6<DicCW<00e:D1EJe15:D1Tic0TYB24Ha
2DYB7THa1d8@2dHa148@2Sg_0d8@0dHa1DYB0THa0SW>00<]JacW7>L00QBU00<HaQcW7>L00RDY00<]
Jc6<<H`00S6<0be[0bU:12DY1B481bDY42U:1be[0RU:00<U:B488@P00QcW0aS60QBU00<<H`@Q1240
0P0000<8@R488@P017oo00<007ooOol047oo000UOol01000Oomoogoo0Sg_00=6<DicCW<00UJe00=N
mf<HHaP00f]J2Fmk1f]J3Fmk0f]J16Li1V<H:Ekg5e[F15Je0e:D0Tic00=:DTHaAS400T8@00<icSF]
=Jd00S6<00<YBRDY9BT00QcW00<HaQBU5:D02ABU0aS64QcW1aS62QBU1aS61AcW0R480bDY0RU:00<a
S3F]=Jd017oo00<007ooOol0<Goo00<007ooOol00Woo0TYB00=W>G_NNmh00WNm00=S64YBBU800SW>
00<aS3W>>Lh00T8@00=:DU:DDY@00UJe0e[F0Ukg0e[F1eJe0e:D0Tic1TYB4dic2TYB0Tic1TYB2DHa
2dYB14Ha1T8@34Ha0dYB0THa0Sg_00<aS2488@P00aS60QcW0R4800<U:BU::DX01BU:0bDY0R482QcW
1B483bDY1bU:0RDY00<Q21S66<H00aBU0Q240PaS00<8@P0000000P0000<<HbU::DX017oo00<007oo
Ool047oo000UOol01000Oomoogoo0Sg_00=6<DicCW<00UJe00=Nmf<HHaP00f]J2Fmk1f]J3Fmk0f]J
16Li1V<H:Ekg5e[F15Je0e:D0Tic00=:DTHaAS400T8@00<icSF]=Jd00S6<00<YBRDY9BT00QcW00<H
aQBU5:D02ABU0aS64QcW1aS62QBU1aS61AcW0R480bDY0RU:00<aS3F]=Jd017oo00<007ooOol0<Goo
00<007ooOol00Woo0TYB00=W>G_NNmh00WNm00=S64YBBU800SW>00<aS3W>>Lh00T8@00=:DU:DDY@0
0UJe0e[F0Ukg0e[F1eJe0e:D0Tic1TYB4dic2TYB0Tic1TYB2DHa2dYB14Ha1T8@34Ha0dYB0THa0Sg_
00<aS2488@P00aS60QcW0R4800<U:BU::DX01BU:0bDY0R482QcW1B483bDY1bU:0RDY00<Q21S66<H0
0aBU0Q240PaS00<8@P0000000P0000<<HbU::DX017oo00<007ooOol047oo000UOol01000Oomoogoo
0Sg_00=244YBBU800U:D00=JeUkgG_L00fLi2F]J26Li2V]J1FLi16<H4Ekg8e[F55Je0e:D14ic00=:
DTHaAS400T8@00<mkcW>>Lh00S6<00<]JbU::DX00R480acW2AS60acW52481acW1QS62AcW1B480bDY
12U:00<aS3F]=Jd017oo00<007ooOol0<Goo00<007ooOol00Woo0TYB00=W>G>LLi`00Vmk00=NmdYB
BU800SF]00<aS3F]=Jd00T8@00=:DTicCW<00U:D0eJe0e[F15Je1E:D0dic0dYB14Ha9DYB3DHa1dYB
0dHa0d8@0Sg_0d8@1DHa1d8@1DHa0Sg_00<aS2U::DX00R4800<Lib488@P00R4800<U:BU::DX00RU:
0be[0RU:00<U:B488@P00R481AcW1b481RDY0RU:22DY1bU:0RDY00<Q21cW7>L01AS60QBU00<@Q0aS
36<00PaS00<DYBe[;F/017oo00<007ooOol047oo000UOol01000Oomoogoo0SW>00=244YBBU800Tic
00=F]E[FF]H00Ukg00=S66LiIcT00fLi6V<H0ekg25[F>UJe2U:D1Dic00=:DTHaAS400T8@00<mkcW>
>Lh00SF]00<aS2e[;F/00bDY0R481acW1B485bDY42482bDY12U:00<]JcF]=Jd017oo00<007ooOol0
<Goo00<007ooOol00Woo0THa00=JeV<HHaP00Ukg00=>LcW>>Lh00Re[0bU:0S6<00<icSg_?Nl00T8@
0dHa0TYB1DHa1D8@1Cg_0cW>1cg_00=243g_?Nl08Sg_1CW>1Sg_148@0cg_23W>1Cg_1cW>0Sg_0d8@
0Sg_00<e[C6<<H`00Re[00<YBRe[;F/00Re[00<aS3F]=Jd01cF]00<aS2e[;F/00Re[1bU:1Be[5c6<
22e[0S6<0Re[00<YBR488@P00QcW00<Q236<<H`017oo00<007ooOol047oo000UOol01000Oomoogoo
0SW>00=244YBBU800Tic00=F]E[FF]H00Ukg00=S66LiIcT00fLi6V<H0ekg25[F>UJe2U:D1Dic00=:
DTHaAS400T8@00<mkcW>>Lh00SF]00<aS2e[;F/00bDY0R481acW1B485bDY42482bDY12U:00<]JcF]
=Jd017oo00<007ooOol0<Goo00<007ooOol00Woo0THa00=JeV<HHaP00Ukg00=>LcW>>Lh00Re[0bU:
0S6<00<icSg_?Nl00T8@0dHa0TYB1DHa1D8@1Cg_0cW>1cg_00=243g_?Nl08Sg_1CW>1Sg_148@0cg_
23W>1Cg_1cW>0Sg_0d8@0Sg_00<e[C6<<H`00Re[00<YBRe[;F/00Re[00<aS3F]=Jd01cF]00<aS2e[
;F/00Re[1bU:1Be[5c6<22e[0S6<0Re[00<YBR488@P00QcW00<Q236<<H`017oo00<007ooOol047oo
000UOol00`00Oomoo`3LOol00`00Oomoo`0aOol00`00Oomoo`3LOol00`00Oomoo`0@Ool002Eoo`03
001oogoo0=aoo`03001oogoo035oo`03001oogoo0=aoo`03001oogoo011oo`009Goo0P000Woo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<0
07ooOol01Goo0P00<goo0P000goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<0
07ooOol01Goo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol01Goo00<007ooOol01Goo00<0
07ooOol01Woo00<007ooOol01Goo00<007ooOol01Woo00<007ooOol047oo000UOooP000cOooP000B
Ool00?mooomoobaoo`00ogooogoo;7oo003oOoooOol/Ool00?mooomoobaoo`00ogooogoo;7oo003o
OoooOol/Ool0081oo`D000=oo`<000=oo`8000Aoo`<0009oo`<000Uoo`D00>Uoo`D000=oo`<000=o
o`8000Aoo`<0009oo`<000Uoo`@006ioo`00PGoo00@007ooOol0009oo`03001oogoo00Aoo`8000=o
o`03001oogoo00Aoo`03001oogoo00Yoo`03001oogoo0>Yoo`04001oogoo0002Ool00`00Oomoo`04
Ool20003Ool00`00Oomoo`04Ool00`00Oomoo`08Ool00`00Oomoo`1_Ool0085oo`03001oogoo00=o
o`@0009oo`04001oogoo0002Ool40003Ool00`00Oomoo`0:Ool00`00Oomoo`3ZOol00`00Oomoo`03
Ool40002Ool01000Oomoo`000Woo10000goo00<007ooOol02Goo00<007ooOol0KWoo0021Ool00`00
Oomoo`04Ool20002Ool20002Ool20002Ool20004Ool00`00Oomoo`0:Ool00`00Oomoo`3ZOol00`00
Oomoo`04Ool20002Ool20002Ool20002Ool20004Ool00`00Oomoo`0:Ool00`00Oomoo`1]Ool0085o
o`03001oogoo01Ioo`03001oogoo00Yoo`03001oogoo0>Yoo`03001oogoo01Ioo`03001oogoo00Qo
o`04001oogoo001^Ool0081oo`<001Ioo`8000]oo`800>]oo`<001Ioo`8000]oo`8006moo`00ogoo
ogoo;7oo003oOoooOol/Ool00?mooomoobaoo`00ogooogoo;7oo003oOoooOol/Ool00?mooomoobao
o`00ogooogoo;7oo003oOoooOol/Ool00?mooomoobaoo`00\
\>"],
  ImageRangeCache->{{{0, 553}, {262.75, 0}} -> {-0.0523406, -0.0238146, \
0.00380594, 0.00380594}, {{13.75, 263.938}, {256.438, 6.25}} -> {-25.0317, \
-13.3636, 0.596826, 0.596826}, {{289, 539.188}, {256.438, 6.25}} -> \
{-189.308, -13.3636, 0.596826, 0.596826}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Level) show
99.000 12.813 moveto
(3) show
105.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
B68D6B5D606D797971675F5F62626160605F5F5F605F6063676A6B6E706E6D6F726F6C70
7574717071757A7E7C736D757F7E787677797C7E7E7C7A78787B7E7E7E818483817E7E81
878F928B8381899DAFB5B6BCC6D1D9D9D6D5D5D3D2D2D3D2D0CFCECFD0CECCCCCED0D1CF
CDCCCDD1D5D9DAD3CFD6DBCFBCACAFD3F9FFEFD7
AB948075757F8989837D797879797979787777787978787A7C7D7E7E7E7E7E80817F7D80
8384827F7E838A8A867E7B848E8C84838586888989898987868A8D8A888E928C85878C8D
8D90918D8A90989EA1A5AAB3BCC1C3C4C3C0BEBFC0C0BFBFBEBEBFC0C0BFBDBDBEBFBEBB
B8B6B7BBBFC5CACFCFC8B9A99E9BABD4F3E9CBB9
B3B8A9A09FA8B4B5B1AEADADAFB1B2B2B1B0B0B0B1B1B1AFADADACA9A7AAACAAA7A7A9AA
AAABAAA7A5AAAEAAA3A0A2ACB2AEA5A3A5A7A8A9AAABABA7A5A9AEA9A5ACB1A4989FACAC
A6A19E9B9DA4A9A69D948F959A97919396918C8F95949292949596969697969695959390
8D8C8C8E919398A7AC9A81797F8493B6C3936783
C3CAB2A9ACB5C0C2BFBDBCBDBFC2C3C4C4C4C4C3C2C2C2C1BEBBBABABCC0C0BAB4B7BDBF
BEBAB6B6B8BBBCB6AFB0B5BDC1BBB2AFB1B3B6B7B7B8B7B1ADB0B5B3B2BABCA99AAABFBD
B1ABA9A8A9ACACA79E958E8D8C847D7F83817E8185858484848383838384858483848688
8783808589837D80837A788EA297868D89573A77
D2CDA79CA3AEB9BDB9B4B1B2B5B8B9BABBBBBBB9B7B7B8B8B7B4B3B6BBBFBEB5AEB3BBBF
BDB4ADB1B8BAB6B0ACAFB6BBBBB5AEABACAFB1B3B4B5B2ACA6A6ABAFB4B9B6A195A8C0BC
AFABADADADAAA7A4A29E99948E868284898A89898A8C8C8B888888868487898886888C93
97948F929286766F717A91B6CAAD83776F493F87
D7C79A8B92A1B0B4ADA6A19FA1A4A7A6A5A4A3A3A3A5A6A6A5A6A6A5A5A9ACA49DA4ADAC
A59E9CA4AEABA39D9CA3ACADA9A49F9E9E9FA2A5A8A6A2A19E9897A5B1AEA295919FAEAB
A2A3A7A6A4A3A2A3A3A3A19D98949499A0A09D9C9B9C9C99979CA09B96999D9C9895979F
A9AFADA496857C8192A5B4BBB69D88929975619B
D5BC8B7A8093A6A9A097908C8D919493908C8B8D90929393929698928C9197928D949B96
8D888B97A09B908A8C959D9A949393929091939698969497978D899AAAA08E8C91979A97
94989C9B999B9EA0A2A4A5A6A7A6A8B0B7B5AEABABACADA9A8B0B7B1A9ACB1B1ACA6A4A9
B3BFC0B09A9096A9BECAC4AA918795BFD7AF89AC
D3B4816E758AA0A39A908885878B90918F8C8B8B8D8E8D8C8D90918D8A8E928E8B909592
8D898B959D978D8B8E9395918D929997929496939193979897908D99A29A8E91989A9793
919397989796979BA0A2A4AAAFADACB4BBB5AAA7A9AEB3B1AEB0B2AFACAEB1B2AFABA9AA
ACAFADA29EAEC3CAC4B6A3918A91A8D4E8BC91AE
D2B68270788DA2A69D938C8B8F94989B9C9A98979796949494949595979899979596999A
9996959DA39D95979B9A9692939BA4A29D9FA19A9499A0A09C9C9E9D9C99989FA5A29B98
9798999B9A97959A9F9FA0A8AEA9A3ABB1A89D9A9EA6AEAEA9A5A2A2A3A4A5A8AAAAA7A2
9A928E93A5C6DBCEAD8F7F8495A1AFCDD6A780A6
D5C091808799ACAFA79D98989DA1A4A5A4A2A1A0A0A0A0A09F9E9DA0A2A2A0A09F9E9D9D
9E9D9EA4A7A0999FA5A099999DA0A2A3A2A4A4A09C9FA2A1A1A8ABA095969FACB2A79999
A0A19F9E9C9B9B9FA29F9DA1A4A09BA1A6A199979A9FA4A3A09F9F9E9B9A9CA4ABABA498
8C85899DB5C4C1AA90878C97A1A0A0B5BB8F71A0
D8CA9E8F94A4B5B7AFA7A2A3A7AAABAAA8A6A5A4A4A6A9AAA9A7A6A7A7A6A6A7A7A5A29F
9EA1A5A8A7A09CA3ABA59DA0A5A29DA0A4A4A2A4A4A19FA0A5AFB1A08F93A3B3B7A69599
A6A9A6A3A09FA2A4A5A19C9B9B9896999D9D9B9A9A9B9B99989DA19E989599A2AAA89F94
8D8C97ACB9AB93818095ADB3AA978C9BA47D659C
D5C79C8C92A3B4B7AFA6A1A3A7A6A4A6A9ABAAA4A0A4ACADACACABA7A4A6A9ABABAAA6A2
A1A6AAA6A09EA0A7ADA9A3A3A5A3A1A2A4A3A2A4A4A09D9FA6B0B19E8D94A6B0AEA2969A
A4A8A8A8A7A5A3A3A2A09D9C9B9794979B9C9D9C9B999897989A9C9B9896979B9D99969A
A2A7A8A69C87777B8FA9BAB9AB938696A0796098
D1C19382889CB0B3A9A19D9E9F9D9C9FA5A9A9A0999EA7A8A7A8A7A19C9FA5A8A8A8A7A4
A3A8AAA1979AA3A9AAA9A6A2A1A3A5A4A2A1A1A1A09D9CA0A5ABA99A8E97A6A8A39E9B9B
9EA1A4A9ABA7A19E9E9E9E9F9F9B97999D9F9F9E9D9B9A9C9C9B999A9C9D9B958F8D93A4
B6BCB29A8173778DA7B4B5AFA5948CA1AB806397
D4C2927D8199B1B1A4A09F9995999E9F9D9D9D9A979A9D9D9C9C9C999696999B9EA1A3A4
A4A7A69D969AA3A7A7A6A4A1A0A1A2A2A1A09F9E9D9B9CA0A4A29D97959CA4A4A0A0A09E
9C999AA0A5A39E9C9C9D9E9E9E9D9D9D9FA1A2A2A1A09F9F9F9F9FA1A3A8A696888FA0AE
B4B2A6978C8C949EA7A9A5A3A09696AEB88B6A9B
D9C5937C819AB3B0A1A0A197909AA5A2999494979A9A9796959494969795929295989CA0
A3A4A19B979BA2A5A4A19E9E9F9E9DA0A2A09D9C9C9C9DA1A29C96989EA0A1A1A2A3A3A0
9C9694999E9E9C9B9C9D9E9E9E9FA1A1A1A2A3A3A3A3A2A2A2A4A5A5A5A9AA9D949EACAA
A099979CA6B1B3AA9D9796999D9A9DB8C3936FA0
DDC58F7D869BAEADA29D9B96959EA7A59F9A979A9D9D9C9C9C9A9A9DA09F9C9894919196
9DA09E97939AA4A5A09A97999D9A989EA3A19C9C9FA0A1A2A19D9BA2A7A1999BA0A1A09E
9D9B9C9D9E9E9D9C9DA0A2A4A4A4A3A3A3A2A1A09F9E9FA3A7A6A29F9C9699AAB9B5A490
858999A9B5BAB6A99C9594979B999DBAC6936DA1
DFC48B7D8A9BAAACA49B95979DA2A5A7A7A5A2A2A3A4A4A5A5A4A4A7AAAEADA69C938F95
9DA09E969299A3A39D9693969B9A989EA4A19C9EA2A3A3A1A0A1A4AAABA095979D9E9C9D
9FA3A6A4A19F9F9FA0A2A6A8A8A5A3A3A3A19E9C9B989AA3ACA89D9791868CB5D3BF967D
7A8AA2B1B4B0A8A29F9D9C9D9E9798B6C28F69A0
DEC48B7A8598ABB1A99D9699A0A2A2A5A8AAABACACABA9A7A5A6A8ACB1B6B6B1AAA4A3A9
AEA9A19E9D9D9D9E9D9A97989C9FA2A4A49F9B9FA4A29E9A9A9EA3A7A7A29D9D9FA1A2A3
A4A6A7A49F9FA1A1A2A3A3A19FA0A2A19E9C9C9D9E9997A2ADADA3968F919EB4BEAD948F
969CA2A6A7A5A29F9FA2A6A6A39896B0BB8B69A1
DDC58D798097AFB4ABA0999BA0A1A0A2A5A8AAADAEABA6A2A0A1A4A8ACAFB0AFAEAFB1B8
BAAEA2A4A8A0979AA1A09D9DA0A5A8A7A39D9BA0A5A09997989B9E9F9FA3A6A3A0A3A7A6
A5A4A29F9C9EA1A2A2A2A099949BA2A09B9A9CA1A39E9A9FA7AAA79D98A6B2A796929AAC
B9AF9E96969A9F9E9EA4AAACA79A95ACB7896AA1
DDC7917E869AAEAFA49D9A9B9FA2A4A4A29F9D9C9D9C9A98979898959496999C9EA2A6AA
AAA19AA0A7A19A9DA3A09DA3A9A59D9D9E9B9BA1A6A29C9DA0A09D9B9B9EA2A19F9F9F9E
9D9C9B9B9B9D9E9F9FA1A198929BA5A49E9DA0A2A4A4A19A96989EA6ABAEA58E7E88A1B6
BDAE99909094999B9CA1A5A7A49792ABB786639D
DDC894848E9FB0AEA29B98999DA1A3A29D958D8B8C8E90949696938A828084898E929291
9091969CA0A09FA5AAA39DA5ADA29494999C9EA1A4A2A1A5A9A59E9B9A9A9B9E9E9B9797
9898989B9D9E9D9C9DA1A29B969DA7A6A2A1A2A2A4A9A898888795ACBAAD937F7C8EA5B1
AEA499949596979A9C9D9DA0A0938FADBC865E99
DCC792818CA2B8BDB3A498979A979191908C888A8E9298A0A6A9A59B8E83818B9490857D
7F90A1A29B9AA1B0BBB5A8A1A09F9F9D9DA1A4A29E9EA0A3A5A29E9D9E9D9DA0A19E9A9C
9FA0A1A2A3A2A1A0A0A1A19F9D9FA19F9D9C9EA1A5ACAB9C8C8B97ABB6AB988E8F9AA6A6
A2A2A39F9B9B9D9FA09F9D9F9F9390B1C18B6099
DDC68F7B859EBBC7BFA9959499928A8B909293989DA0A4ACB4B8B7AFA3948F9FAEA5907F
7D95AEAEA1999CAEBDB9AA9B96A0ACA89FA5AAA297989D9F9F9E9D9FA2A2A1A3A4A2A1A4
A7A9A9A7A6A4A3A4A3A19FA2A3A09B9999999A9EA3A7A7A19C9C9FA2A4A5A6A7A8A6A29B
99A2ABA8A1A0A3A5A5A3A0A1A09493B4C48F659C
E0CB927B8096B0B9B09C8B8E9AA0A4A9ADAFB0B1AFA9A4A6ABACAAAAA9A4A8BFD5D7C5A7
9196A9B8B8A490929A938C96A4ACABA19AA2ABA09296A0A2A09F9FA0A2A2A2A3A4A4A3A3
A3A3A2A19F9E9EA0A2A09FA2A4A19E9FA1A19F9D9A9799A4AEAEA5958C98ABB3B0A89D94
939CA5A6A3A1A2A5A8A5A0A1A19897B5C38C639D
E3CE94797A8BA0A59D918B909EB0BFC5C5C4C1BDB6A99E9B9C98959BA5AAB5CBDFE5DABF
A59CA4B8C1A9877B7B777D97ADAB9E9899A1A69B9198A4A7A5A19F9EA0A0A0A0A0A1A19F
9C9A99989898999C9FA0A1A0A09FA1A6ACACA69B90888EA7BCBAA68B7E8EA9B2AEA59A94
93979CA0A29F9EA2A7A4A0A1A29999B5BF88619D
E4CC8F727080969E9EA0A4A5A9B2B9BAB6AFA8A4A29D9998989390969E9F9FA6A691808B
A2AFB2AC9F9188848A9CA9A39387879AACAB9E96959FA9ABA69F9B9C9E9E9C9C9C9C9B9C
9D9C9B9B9B9B9B9EA0A2A19D99979BA5AEAEA6988C8892ADC1B9A28C848EA0ACADA69C99
9B9B9C9FA29F9C9D9FA0A0A2A19795B2BE88629F
E1C78A6F71859EA9AAB0B4B0AAA5A19D988F88888D94999D9D9895999D978A7F6A423364
A6C4BA906C7B9FAAB0C9D0A6766D83A8C0B2969099A3ABABA59D999B9E9D9B9B9C99979C
A2A2A1A1A1A0A0A1A2A3A19C959295A0ABABA29790929DAEB8AD9C9595969AA4AAA69F9E
A0A0A0A2A29F9B999B9EA0A2A19491B0BF8A649E
D9C38E7A85A5C4C7B8A89C9491908F8D8A8A8C8F959BA0A5A69F9A9FA8AAA089726777A9
D2CDA3674E88D5E4D0BFAB8B7C8EACC0C1AA908C959EA4A6A49F9C9DA0A1A1A2A29F9C9F
A3A3A2A3A4A3A2A1A1A4A5A19A9697A0A8A6A09C9CA0A3A3A09C9A9CA0A2A1A09F9F9E9D
9EA2A5A6A39C989BA1A1A0A1A19591AFBE8B649A
D8C6978898BDDED9BA977D767C868D8D8D959EA3A5A6A7ABABA39DA5B3BFBDA494AAD4F5
F6CC8B504A99F1FFD8A47B758DB3CFCCB69F908C92999EA2A2A1A09FA1A3A6A8A8A6A3A2
A2A1A0A2A3A3A19F9EA2A6A5A2A09FA1A29E9CA3ABACA595898F9DA5A7AAA89F97989C9C
9CA1A7A7A39A979FA8A69FA0A29794B1BE896198
E8D8A39097AEC3BFA88E7E808D9AA09E9B9FA5A7A7A5A4A5A49F9DA6B2B9B6A79CA5BEDA
E2C594675D88BFCEBDA28B8490A4B4B6ADA19895989DA1A19F9E9E9D9D9EA1A5A7A6A3A2
A1A09FA0A1A1A09E9C9B9C9FA5AAABA1958E93A6B7B5A48F8491A7AFAEA8A09B999B9EA0
A1A2A1A19F9C9BA1A6A39EA0A29794B3BF865D9D
F5E0A287868F9C9F9892929CA9B2B4B0A9A6A5A3A1A09E9B99979AA2A9A9A39E95848099
B5B8A791807D858D97A6ADA292898C97A3A5A1A0A1A4A5A29D9C9D9C9A9A9A9EA1A19F9F
9F9E9D9E9FA0A09E9A95949BA6AFAF9E8C8690A8BAB4A0908C9AACB3AEA196979DA0A1A6
A8A19A999C9FA1A2A19F9EA1A29895B3BF845CA3
E8CA86696C8099A5A6A6A7ADB2B2AFADA9A6A3A09E9F9F9A9593969BA0A2A09B907D7483
9BA7ABADA99F92848299AFAE9F938D8F979FA4A6A5A4A3A09E9FA1A1A09D9B9A9B9B9C9C
9C9B9B9EA2A5A49D97959AA4ACABA2968F929CAAB0A79994989FA6A9A69F98979BA0A4A9
A89F97989DA0A1A1A09F9EA1A29997B1BC8662A3
D1AE6E576383A7B7B8B4B0AEACA6A0A0A2A2A09D9DA0A29D969596989BA0A29A8E87868A
929BA6B4BFC1B599838CA1ADAEA89E939099A4A7A5A19E9DA0A3A5A6A5A39F9A98999C9C
9B9B9C9FA4A8A69D9699A3ADAEA193929AA5ACA79E97979EA4A19B9B9D9FA09B989DA5A8
A59D989BA0A19FA0A0A09FA2A29A98AEB78B6D9F
C4AA7D738197ABB3AFA69F9FA19E9A9CA09F9D9EA0A2A39E9A9DA09E9B9D9F9C999C9F9A
969AA3AAAFB3B0A3959096A8B5AD9E95959DA4A5A19D9A9B9FA1A3A4A4A4A2A09EA0A2A0
9D9EA0A0A0A3A39E9A9DA3A6A39A9499A5B2B49E898FA2ADACA2979499A0A49F999CA1A4
A39E9B9EA3A19E9E9FA0A0A2A29B99AAB28F779D
C2B69B9AA5ABADA99E91898E979A9A9DA09E9C9FA3A3A29F9EA5AAA69F9C9DA0A7B1B4AB
9F9E9F9A94959CA6AA9D929FAEA89B9B9FA2A3A19D9B9B9C9E9E9E9E9FA2A4A4A4A7A8A4
A0A1A3A09C9C9EA0A1A3A19B95949AA4AEB7B1927C8EAEB8B1A3969398A1A7A49E9C9D9F
A19F9EA1A5A19D9C9EA0A1A2A29B99A8AF927D9D
CAC2A9A2A7ACAFA89C928D8F969A9C9E9E9C9B9EA1A1A09FA1A5A8A6A19E9FA4ABB3B6AF
A49F9B948E8D94A7B4AB9C96989EA4A7A6A19C9B9D9FA2A3A29E9B9A9C9FA1A09FA2A5A3
A0A1A29F9B9A9BA0A6AAA79B8F8F9AABB7B3A2897D91ADB8B2A3959299A3AAA9A29C9A9D
A09F9EA2A5A19C9C9FA0A1A2A19B99A8AF927EA1
D2C8A79898A3AEACA39D9B999A9DA0A1A09D9B9C9F9F9FA0A1A2A2A2A1A0A1A4A8A9A9A6
A29E9A99979395A2B0B5AB938391AAB3AEA195959DA4A8A8A49F9B9A9B9E9F9A96999FA0
A0A0A09F9D9A9AA0A8AFAD9D8E8E9AAEB8AB95898995A6B0AFA396949AA3AAAAA59E9A9D
A19F9DA0A4A19D9D9FA0A1A2A19A98A9B1917CA4
CEBF9A8E939EAAAEAAA6A19D9DA2A6A8A6A19E9FA2A3A3A1A0A0A1A2A29F9DA0A3A19D9C
9D9EA0A2A19D9A9CA4B2B3987F89A4B8BBA891909CA3A5A4A09D9D9D9EA3A49C96999F9F
9EA0A2A2A09B999EA6ACAA9A8C92A1ACAFA59895999C9FA5A7A39C9A9CA0A4A4A29F9D9E
A0A09FA0A1A09E9E9FA0A0A2A19A98AAB3917AA2
C4B18B85909BA5ADAEA8A19D9EA3A9ABA9A4A0A1A4A6A6A29E9FA1A3A29E9A9C9F9C9896
989FA7A8A6A5A29A99A8B1A08C8998B3C2AE928F999FA19F9C9C9FA0A2A7A8A0999CA2A1
9EA0A3A4A29E9B9DA1A4A299929CA7A59F9EA1A5A7A19A9BA0A2A3A09D9C9D9E9EA0A0A0
A0A0A0A09F9F9F9FA0A0A0A1A19A98ABB3937A9D
BEAC887F8895A3A9A7A5A19C999DA2A2A19F9E9C9DA0A19E9B9B9E9E9F9F9E9C99999999
9BA3A9A5A0A3A69F989CA4A8A4948DA2B6AB9793999EA3A29F9FA09FA0A4A59F9A9FA6A6
A19E9C9EA0A09E9F9F9B999DA5ABA99A8D95A5B0B0A496959BA2A5A39E9C9B9C9EA0A1A1
A09F9F9F9E9F9FA0A0A0A0A1A09998AAB3947B9A
BDAF8E808493A3A59F9F9F9A96979A9A999B9B9896999D9C99999B9B9CA0A29D989A9FA0
A0A5A79E979EA6A39B9497ABB7A28A92A3A49D9A9B9FA5A6A4A2A09E9D9FA09D9CA1A7A7
A29B9699A0A5A5A1999193A6B8B7A68E828FA6B4B3A494929AA1A4A3A09D9D9E9FA0A0A1
A09F9E9E9F9F9F9FA0A0A0A1A09998AAB3947B9A
C3B796888B98A6A8A19D9A98989A9C9EA0A09F9B999DA19E9A9A9C9EA0A1A09D9B9FA3A1
9E9E9E9C9B9EA1A09B9596A5B1A69590949CA3A39F9FA2A3A3A2A09F9F9E9EA0A2A3A1A0
9C98979CA6B0B19E8A8998B0BFB69E888190A7B3B0A295939AA0A3A3A09F9F9F9FA0A0A0
A09F9F9F9F9F9F9FA0A0A1A1A09997ABB4947A9C
CBBF9C8F939EABADA69E98999DA0A2A6A8A6A2A0A0A3A5A29E9DA0A3A4A09D9DA1A3A4A0
9B98989DA3A39F9C99989A9FA4A7A3958C98A7A9A49F9D9D9FA0A0A1A29F9DA3A7A39C98
97979BA2ACB9B7987D86A3B6BAAC978A8B97A5ADAAA198979B9FA2A2A1A0A0A0A0A0A0A0
A0A0A0A09F9F9F9FA0A0A1A2A09897ABB592789F
CDC09C8E93A1B0B0A7A09C9C9FA4A7A5A2A1A1A1A2A3A3A2A2A3A4A3A19E9EA1A4A4A19F
9D9B9B9FA3A6A49E98969AA2A9ADA899909AAAACA69E98999D9FA0A1A19E9BA0A5A39D9B
9A9A9CA3ABB3AF937F90ACB4ACA197979DA0A1A3A3A19F9D9D9FA1A1A1A0A0A0A09F9F9F
9FA0A0A0A09F9F9FA0A0A1A2A19896ACB692769E
CDBF98898EA0B2B1A6A1A09EA0A5A7A19A9A9FA1A19F9EA0A4A7A6A09B9CA2A5A5A29F9F
A0A1A2A1A1A6A9A29A969AA5AFAFA79C969DA8ACA89E96979D9F9FA0A09C9A9DA1A2A1A1
A09D9CA1A6A7A1918A9EB2AA99969DA7ADA69B9A9FA3A4A29F9FA0A1A0A0A0A09F9F9F9F
9FA0A0A0A09F9F9FA0A1A1A2A19896ADB791749D
D0BF94858B9EB0AFA39D9B9DA1A2A19F9D9EA0A2A19E9CA0A5A7A49D989CA3A6A5A2A09F
A0A2A4A3A2A4A5A2A0A0A2A2A3A9AAA09798A1AAACA398979B9FA0A09E9C9B9C9FA1A3A3
A29D9B9EA19F999394A5B09D8891A6B0AEA094969FA4A4A29F9FA0A0A0A0A09F9F9F9F9F
9F9FA0A0A09F9F9FA0A0A1A2A19896ADB990719D
D3C09282889BAEADA198969BA19F9C9EA2A4A3A29F9C9CA0A4A4A19B989DA4A5A3A2A09F
9EA0A2A3A29F9EA0A4A9A89C959FAAA3969399A6AFA89C999B9FA2A19F9D9D9EA0A1A1A2
A29E9C9D9E999699A1AEAE927B8FAEB4A99A8F95A1A4A1A09F9F9F9F9F9F9F9F9F9F9F9F
9F9FA0A09F9F9F9FA0A0A1A2A19795AEBA8F6E9D
D3BF907E8499AEADA199979A9E9F9D9EA0A2A39F9A999BA0A3A39E98969BA2A29F9E9D9D
9E9FA09F9D9B9A9DA2A4A299939AA3A29B9594A0AAA69C9CA0A1A1A2A2A19FA1A39F9B9D
A2A3A3A29F9593A3B6BEB28D748CB1B7AB9D94969EA1A1A09F9F9F9F9F9F9F9F9F9F9FA0
A0A09F9F9F9F9F9FA0A0A1A2A19795AEBA8E6D9C
D2BF907D8399AFAFA39D9B9A9C9FA19F9D9FA19D98989BA0A3A19D99989B9FA09D9C9B9B
9D9E9E9D9A98999B9E9E9C9996989DA2A39B949BA3A29D9FA2A2A1A4A5A3A0A3A49D9699
A2A8AAA69D9090ADC8C7AF8B778EB0B7ACA29B999B9EA1A1A09F9F9F9F9F9F9FA0A0A0A0
A0A09F9F9F9F9F9FA0A0A1A2A19795AFBB8E6C9B
D4C0917F859AB0B2A7A09C9B9C9E9FA0A1A09F9D9D9E9FA1A19F9D9FA2A09E9FA09E9B9A
9A9D9F9F9D9A999B9EA2A29D98999EA7ABA298989EA1A29F9D9FA3A5A3A09EA0A29C979B
A3ABACA1938890B3CEBC9886899BAEAFA7A19E9B9B9DA0A09FA0A0A09F9F9F9FA0A2A3A1
A0A0A09F9E9E9F9FA0A0A1A2A19795AFBB8D6B9C
D7C39381889CB0B4AAA09A9A9E9E9EA2A5A19D9FA3A4A3A2A09D9DA5AAA49D9FA3A39F9C
9A9DA1A3A29F9C9DA1A7A9A29A9AA1A9ADA89E9898A0A6A0999DA3A29E9C9C9E9F9C9B9E
A4ACAB9B89828FB4CAAA81849CA8AAA6A09E9F9E9D9E9F9F9FA0A0A09F9F9F9FA0A2A3A1
9EA0A2A19E9E9F9FA0A0A1A2A19795AFBB8D6A9C
DAC79581869BB1B4A99E97999EA1A2A3A39F9CA0A4A5A29F9D9A9BA4AAA2999CA4A6A4A2
A09FA0A2A4A5A4A2A1A4A6A39E9A9BA1A7A9A598919BA8A79F9D9D9C9C9D9EA1A29E9B9E
A5ADAC9D8B838DB0C4A47E89A5ABA49F9C9DA0A09E9FA1A2A19F9E9F9FA0A0A0A0A1A09C
9A9FA3A29E9E9FA0A0A1A0A2A19795B0BC8C689D
DDCB987F8198B1B4A69B95979FA4A6A39F9C9CA0A4A39F9C9B9A9CA2A49E989AA1A4A6A8
A7A29E9FA3A7A8A5A09FA0A2A19B9699A1AAAA9A8C96A7ADA99F96969C9FA2A5A49E9A9D
A4ACADA0918C93AAB7A08893A8A89F9B9A9DA1A1A0A2A3A3A19F9E9FA0A0A0A0A09F9C99
999EA3A29E9D9FA0A1A1A0A2A19795B0BD8B679D
DBCB997E7D95B1B5A89C9598A0A4A4A29E9B9BA1A5A39E9C9DA1A5A39F9E9E9D9C9B9EA6
ABA59D9C9FA2A3A19F9D9EA1A29E9B9CA1ACAE9F8F94A3ACADA296949BA1A4A4A09B999D
A4AAA89A909BAAAAA196939FABA59996999EA2A4A3A3A29F9C9FA2A2A09F9E9E9E9E9E9D
9DA0A3A09C9D9FA1A1A1A0A1A19795B0BD8C699D
D8C9987C7A93B1B7AB9E9699A0A3A1A09D9B9BA1A6A39E9C9EA7ACA49C9FA5A19A9495A0
A9A59C999B9C9C9D9E9E9EA0A2A2A1A1A3AAACA297969EA7ACA59B989AA0A4A39E9A999D
A3A6A39490ABC0A8898DA1ADAEA396949A9FA2A4A4A3A09A989FA7A59F9E9E9C9C9FA2A2
A1A2A29F9C9D9FA1A2A1A0A1A19795B0BD8D699C
D8C7947B7D96B3B8AC9D94979FA3A29F9C9B9EA3A5A19B999BA1A5A09B9FA6A49F99979C
A2A09C9B9C9D9E9E9E9E9E9FA0A0A09E9EA0A1A09D9A9AA1A7A6A19E9D9D9FA4A6A29D9B
9C9E9E9799B4C29B758AB0B8AEA298989DA1A2A2A2A3A39E9A9FA5A29D9D9F9E9EA1A4A2
A09FA0A09F9E9D9FA2A1A0A2A19795B1BD8A6499
D9C6917B819AB4B8AB9B92959EA3A39F9B9DA1A3A29F9B9998999A9B9DA0A2A4A4A29E9C
9B9B9D9EA0A1A2A09E9E9E9FA09E9C9B9A96969DA39E999CA2A5A5A39F9A9AA5AEABA19A
96959A9FA7B9B98C6B8CBDBFAB9F9A9BA1A2A19F9EA0A1A09FA0A09D9B9EA2A2A1A3A3A0
9C9C9FA2A39F9B9EA1A1A0A2A29694B1BD886098
DEC68F7C859CB3B6AA9C9497A0A4A39E9B9EA3A2A0A1A3A19E9A999DA2A19E9FA2A4A49F
9B9B9EA0A1A2A2A09E9D9EA1A2A09D9D9D98969FA7A0989AA0A4A4A19D9898A1AAABA59B
928E94A6B7BDAF846B93C4C0A295959AA2A39F9F9E9793989FA09E9D9EA1A4A5A4A2A09E
9C9D9FA3A49F9A9CA1A1A0A2A19794AFBB8A679F
E1C8907C859BB2B4A79C979AA1A4A39E9B9FA4A19FA3A7A7A49F9CA1A5A19B9A9EA3A6A3
9D9EA0A1A1A1A09E9D9D9FA2A5A39FA1A29E9CA2A8A29A9A9FA1A19F9C99989CA3A8A89E
91888EABC4C0A57F729AC5BA9A8E929AA3A4A09F9D938D96A0A09B9DA1A2A3A4A4A19E9D
9D9EA0A3A39F9A9CA0A1A0A2A19795AEBA8D6DA5
DEC9947C809AB4B3A39B9A9BA0A4A49F9B9DA1A2A09E9E9EA0A0A0A3A4A09B9B9DA2A4A1
9E9FA2A3A2A1A09E9D9D9FA3A5A29EA1A3A09EA2A7A6A19B989CA2A29F9B999CA3AAABA2
948488AECDBF997C789BBDB296929AA1A5A7A39A959AA4A9A8A0999DA39E999CA1A19E9D
9D9FA1A2A19E9D9EA1A1A0A2A29896B0BB8A679F
DAC9957B7D98B5B2A19A9A9B9DA3A5A09B9B9FA2A19B95969BA0A3A4A29F9D9D9FA1A19E
9C9FA3A4A2A1A09E9D9D9FA2A4A09C9FA2A09EA0A5A9A79C9399A3A7A59E999CA5ADAEA5
958386AECFBB927D819CB4AA9697A3A7A7A9A5958EA4BCBDAFA0979CA39B92969FA1A09E
9D9FA1A09E9E9FA0A1A0A0A2A39997B2BD875F98
DDC7907B839AB0B0A29B9A9A9DA3A6A19C9EA2A19E9F9F9F9EA1A4A5A49F9B9C9FA1A09C
999DA3A4A1A0A09E9D9E9FA2A39D999DA2A09DA0A5A9A89F9698A0A8ABA29999A1ACB0A4
92858AADC7B491868FA3B2A79596A0A4A5A9A6968FA4BDBDAEA0989DA4A0999BA0A2A19E
9C9EA29F9C9EA1A2A2A09FA1A29997B2BD87619B
E1C68B7C899CACAFA79E98989CA2A5A19EA1A49F9BA2ABA9A3A1A1A3A49F9A9B9FA2A19C
989CA1A2A1A0A09E9E9D9FA2A39D989CA29F9B9FA4A5A3A09E9B9CA6ACA498969DABB0A1
8E8893AEBEAC918F9CABB1A696949A9FA3A7A599939DACADA69E9A9EA5A5A2A2A2A1A19E
9C9FA29F9B9EA2A2A2A09FA1A19896B1BC8A67A1
DFC68F7D879BB0B5ACA097979CA1A3A19EA1A3A09C9FA4A4A19E9B9B9D9FA0A1A0A1A1A0
9D9D9E9FA0A0A09F9F9D9DA2A49F9A9DA29F9B9D9F9C9AA0A5A19BA0A49E9899A0AAAC9C
8C8D9CB1BAA48D90A1ABACA49A979CA1A5A5A19A94949697989A9CA1A5A4A2A2A19F9EA0
A2A4A39E999CA0A1A1A09FA1A19693AEBB8B69A1
DBC8947C8099B4BBB0A196969B9FA0A09FA0A1A09E9B999C9E9B969598A0A6A5A2A0A1A3
A4A09C9C9FA0A0A1A09D9DA1A5A29EA0A29F9C9C9B95939FABA69C999998999FA5AAA798
8C93A3B3B49E8992A5A8A39F9C9DA0A4A6A39E9A97918C8A8E969FA3A3A19E9FA09D9BA1
A8A8A39C989A9FA1A09F9EA2A29691ADBC8C689E
DAC8957B7D96B3B9AEA096959B9D9EA0A2A19F9D9C9C9D9F9F9C999B9FA2A4A4A3A0A0A2
A3A19D9C9D9FA2A1A09E9EA0A2A4A5A3A19F9D9F9F9895A0AAA79E9693969CA4A8A9A396
909BAAAFA9968B9BADA798979CA0A4A3A1A1A19E9C9E9E979298A0A3A19E9D9FA09B99A0
A9A8A19B999CA1A2A19F9EA2A49994B0BD8B669B
DDCA93797B94B0B5AA9F97969A9C9FA2A5A39F9B9A9FA5A5A19F9FA4A7A39EA0A3A09D9E
A1A2A09D9B9EA3A2A09FA09E9FA2A6A4A19F9FA2A39F9CA1A7A7A1989297A0A6A9A7A196
92A1AFA99A9093A7B5A791909AA2A5A29D9EA2A1A2ADB3AA9D9DA2A19F9E9E9F9F9B98A0
A7A59E9B9C9EA1A4A4A09DA1A59B98B3BF89629B
E3CD93787C94B0B5AAA09996989EA4A6A5A3A09B99A0A7A5A1A1A4A6A59D979DA39D979B
A3A5A39E9A9DA3A3A0A0A09F9D9B9B9DA0A2A3A19F9F9FA0A3A7A89C9398A3A8A7A7A295
90A4B4A58E8D9BAEB7A691919CA3A5A39E9B9BA0A6ABADA9A4A3A3A1A0A0A09F9E9B9BA2
A7A1999BA09E9CA3A9A39A9EA29995B2BE875F9D
E9D092787E96B1B5ABA29B96969FA8A8A4A3A19C999EA5A4A1A2A4A39F98959DA39B939A
A5A8A49E9A9DA2A3A1A09F9F9E969297A1A5A59F9B9CA1A0A0A8ABA1969BA4A7A5A6A395
8FA5B6A1878DA3B1B2A495969FA2A3A4A199949EA7A39DA0A5A5A3A2A1A2A29F9C9B9EA4
A89F969CA39C96A1ACA5999BA09592B0BE855E9F
E8CF907A8298B0B4ABA39D97969EA6A7A4A3A29B979CA3A3A1A1A19E9B999AA2A69D959B
A5A7A39E9B9CA0A3A29E9B9EA19C989DA4A6A39E9B9EA2A2A1A4A6A29E9FA3A4A3A19E97
97AAB59D8593ACB2ABA1999AA0A2A2A3A19B989FA6A19A9CA0A1A0A1A2A2A2A09D9C9EA5
A89F979DA49D969FA9A49B9EA29792B1BF865E9F
E5CB8E7B859AAFB4ABA39D97969CA2A4A3A3A19B979BA1A2A19F9D9B9B9DA1A6A7A09A9D
A3A3A09D9C9C9FA3A49D979DA4A4A1A4A7A4A09D9D9FA3A3A29E9DA1A5A3A0A0A09C9A9B
A2AEB19A8798B1B0A39C9B9DA0A2A1A09F9E9FA2A4A19D9A9A9C9EA0A1A2A1A09E9C9DA4
A9A1999EA49F999DA4A29EA2A59894B3C1885E9E
E5C88977849AAFB4ACA39B95949AA1A4A2A19F9D9D9FA1A19F9D9C9EA0A3A4A4A2A09FA0
A2A09E9D9E9D9DA3A6A09A9EA4A3A0A3A5A19C9A9BA0A3A29D98979DA4A39E9A98999DA3
A9AFAB968697ADA99C9A9D9E9FA09F9D9C9EA1A3A29F9B99999B9E9FA1A2A19F9C9B9DA4
A9A29A9EA3A09C9EA2A1A0A2A39794B3C1885D9D
E5C887748199B0B5ABA19893959CA2A3A19D9C9FA4A4A29E9C9C9EA2A5A5A29E9D9FA2A2
A09E9D9E9F9E9DA2A7A39EA0A39F9B9EA19F9B98999FA4A09995959BA2A4A09791949FA9
AFAFA5918595A9A69B999D9E9FA09F9D9C9EA1A2A19D9A9A9C9D9E9FA0A1A19E9B9A9DA3
A7A19B9EA2A19E9FA1A1A0A1A19593B3C1885E9E
E3C98D788299B1B5AA9D95969CA1A2A29F9B9AA0A7A6A09C9A9DA2A3A2A19F9C9CA1A5A3
9F9E9FA0A09E9EA2A5A29EA0A39F9B9C9FA09E9C9CA0A3A09B97989FA7A9A59A908D96A9
B6B09E8B8599AEAC9F9B9B9C9FA1A2A1A0A0A1A1A0A09F9F9F9F9F9FA0A1A09E9B9B9DA0
A2A09D9EA1A09F9FA0A1A1A2A19593B2C189609D
E1CB937D839AB2B4A89B9499A3A5A3A19E9A9AA0A6A49F9A999FA4A39E9C9C9C9EA2A4A2
9F9FA1A1A0A0A0A0A09E9DA0A3A09D9D9FA1A2A2A1A1A1A19F9C9CA3ABAFAA9F92888CA8
BFB39986869DB5B4A59C9A9B9FA2A4A4A4A2A09F9FA1A4A4A2A09F9FA0A0A09E9D9E9F9E
9E9E9FA0A09F9E9E9FA1A1A3A29592B1C08A629D
DFCB947D829AB2B3A69C989AA0A4A5A19C9B9DA1A4A39F9B9A9EA3A4A29E9B9D9F9F9D9D
9EA0A1A09FA1A39D989AA0A2A19F9E9EA0A1A2A3A4A2A1A0A09E9DA1A7ADACA294878BAC
C7B79785879DB3B2A59D9A9C9FA09F9F9FA0A09E9D9FA2A4A3A19E9FA0A1A09F9FA2A4A1
9C9DA0A1A09F9E9E9FA1A2A4A29693B1C08A639C
DFCA927C8199B1B4A79F9B999BA2A6A29C9DA1A2A2A19F9E9D9D9FA3A5A19D9E9F9C999B
9FA0A09E9EA3A49B9399A3A3A09E9EA0A1A09FA2A5A29F9FA09E9D9EA2A8AAA3978A8DB0
CBBA9686899CAFAEA39C9B9EA19F9A98999EA29F9B9C9FA2A3A09D9EA1A1A19F9FA5A9A3
9C9DA1A2A19F9D9D9FA1A2A3A29693B1BF8A629C
E1CA907A8198B0B6ADA198959AA2A7A39D9EA2A3A19F9E9FA09F9E9FA1A1A19E9C9D9EA0
A0A09F9E9EA2A49F9A9DA1A19F9E9FA0A19D9BA0A59F999DA3A09C9EA3A6A5A49D8D8BAD
CAB894858B9DAFAEA39B99A0A8A59D9A9BA0A3A09A9B9FA1A29F9D9EA1A2A29E9DA3A7A1
9A9CA1A3A19F9E9D9FA0A1A3A29693B1BF88609C
E4CB8E798197AFB8B1A194939AA3A7A39E9EA1A2A29F9D9FA2A19E9C9CA1A49F9A9EA5A5
A2A09E9E9FA0A2A3A3A19E9E9F9F9FA0A19C999FA49D969CA4A19CA0A5A4A1A4A28F88A7
C3B494878D9EAEAFA59A97A1ACAAA29E9FA2A5A19C9C9FA1A19E9D9EA0A2A29D9A9FA49F
999CA2A3A1A09E9D9FA0A1A3A29693B2BF875E9D
E7CC8D778197AFB6AD9F959399A1A5A29D9B9DA1A3A19E9E9F9F9F9FA0A2A39E9A9EA4A5
A3A09E9D9F9FA0A1A3A2A09F9F9E9EA1A39E9A9EA2A09C9FA19E9B9EA2A19FA3A19088A0
B9B09A8E8F9CA9AAA39A969DA5A6A29E9EA2A6A39E9EA0A1A19F9C9EA1A2A19C999EA4A0
9A9DA2A3A2A09E9D9FA0A1A3A29693B2C0875E9F
E9CD8C768098B1B4A79E9895979FA5A29C999AA0A5A39E9C9C9DA0A2A4A3A19F9E9EA0A1
A2A09E9E9E9E9E9E9FA1A3A29F9D9DA2A6A29D9DA1A3A4A29E9C9B9C9E9F9FA2A0938C9C
AFADA0969299A3A6A29B97989C9F9F9D9BA1A6A39E9EA0A2A29F9D9EA1A1A09D9CA0A4A0
9B9DA1A3A19F9E9D9FA0A1A3A29693B2C1885EA0
E9CD8D768098B1B3A79F9B9596A0A9A59D9899A0A6A29B9B9EA1A2A2A1A09FA1A2A09E9F
A1A1A09E9D9D9D9EA0A1A2A19F9D9DA1A5A39F9D9EA2A5A29E9E9F9F9D9C9DA1A39B959D
A8A9A39A9499A2A6A59F9897999C9D9C9BA1A5A19B9CA0A3A3A09D9E9F9E9D9EA0A3A39D
989BA0A2A19F9E9D9FA0A1A4A29592B3C2875C9E
E8CD8D778098B1B5AAA29B9595A1ABA8A09A9AA1A6A1999CA2A4A29F9C9D9FA2A3A19E9E
A0A1A19F9C9D9FA1A2A19FA0A09D9CA0A4A39F9C9CA0A3A19EA0A2A2A09E9DA0A3A09EA1
A5A6A29B979AA2A8A8A29B999B9C9E9D9DA1A39D979AA1A3A3A19E9D9E9D9DA0A3A4A19B
989BA0A2A19F9E9E9FA0A1A4A29592B3C386599C
E8CE8D778197B0B7AFA39995989EA4A7A6A09CA0A4A09B9EA2A2A09D9C9EA1A19F9E9E9F
A0A2A29E9B9FA4A4A19C9A9EA29D999EA4A29D9B9DA0A29F9B9CA0A3A5A6A49D999BA2A7
A8A49E9A9A9DA2A5A6A4A29F9EA0A3A3A2A2A19C989CA1A3A2A19F9D9D9FA1A3A3A19F9E
9D9FA1A1A09F9E9E9FA0A1A4A29592B3C386599C
E9CE8D788197AFB9B2A396959B9B9CA4AAA59D9EA1A09FA0A19F9D9C9DA1A39E999B9FA0
A1A2A29D9BA1A7A6A099979EA59F979DA4A19C9B9EA1A39F99989BA2A9AEAA9B8E93A0AC
AEA599979B9FA2A3A2A5A6A3A0A3A7A7A5A29F9C9B9EA1A2A1A1A09D9DA1A5A4A09E9EA1
A4A3A1A1A09F9E9E9FA0A1A3A29592B3C3865A9D
E9CE8E788197AFB8B0A194959C9C9CA3A8A1999CA2A19FA1A2A09D9D9FA2A39D97999FA0
A0A1A19E9C9FA2A3A19C9AA1A8A39B9EA3A3A09D9DA0A3A19D9898A0A9ADA99A8D8E9BAE
B8AA9691979DA2A4A4A2A19F9FA1A5A5A4A19F9E9E9FA0A1A1A1A09F9EA0A1A09E9EA0A3
A6A39F9FA1A09E9E9FA1A1A3A29592B3C2875C9E
E8CE8F788096AFB7AE9F94949B9EA0A3A49C969CA4A29DA0A3A19E9EA0A2A29D989A9FA0
A0A0A09F9E9D9DA0A29F9DA4AAA59E9EA2A4A49F9C9FA4A5A19A979DA6AAA59B918C94AF
C1B1958B8F99A4A9A7A09997999DA0A1A1A09F9F9F9F9EA0A1A09F9FA09F9D9C9C9EA1A3
A49F9C9EA1A09E9EA0A1A1A3A29592B3C2875D9E
E8CF8F777E95AFB8B0A1949399A0A5A6A39B979FA6A19A9DA3A19E9FA0A3A3A09D9FA2A3
A2A09D9D9F9E9EA0A29E9BA2A7A0989CA3A5A29E9B9FA5A6A29B969DA6AAA69D92888DAD
C6B798868597ACB1A9A1999392989FA2A2A09E9E9F9F9FA0A1A09E9D9E9E9E9B999A9DA0
A09D9B9EA1A09E9EA0A0A1A3A29692B3C2865B9D
E8CF8F767C93AFB9B2A3969298A2A9A8A39D9CA1A59F989CA1A19E9FA0A3A4A3A1A2A4A6
A5A09B9C9FA1A1A1A09C99A0A49B939AA5A59F9B9B9FA4A5A29B989DA6ABAAA0928589AA
C5BD9F837A95B5B8ABA39C928E96A1A5A4A09C9C9E9FA0A1A19F9D9C9D9FA19F9C9B9B9C
9D9D9D9FA09F9E9E9FA0A1A3A29693B3C185599C
E7CE8F757A91ADB8B1A4989296A1AAA7A09E9FA1A19D9A9DA1A19F9FA0A1A2A1A09FA0A3
A4A09C9DA0A1A1A1A09E9EA1A19B969CA4A4A09B999B9FA2A19D9A9BA1AAACA3938689A5
C0C2AC836D8EB9BDACA29B94939CA5A7A5A09C9B9EA0A1A2A19F9EA0A3A2A3AAAFA89E9C
9D9E9FA0A09F9F9E9FA0A1A3A29693B3C1865C9D
E6CD8F767C92ACB5AFA4999395A0A8A49D9EA19F9D9D9EA0A1A09F9FA0A09F9E9D9B9BA0
A3A19D9EA0A0A0A0A0A1A2A2A19E9DA0A3A4A19C999A9DA0A09F9D9B9DA7ADA494898CA2
BAC5B6846587BAC0ADA199969AA2A8A9A5A09C9C9E9FA1A2A2A1A0A3A5A0A0B0BCB1A09C
9FA1A2A2A09F9E9E9FA0A1A3A29693B2C088609F
E6CD8F7A8398AFB6AEA49A93959EA7A49D9DA09F9FA0A1A2A1A09EA0A1A19F9E9D9A9A9F
A4A29E9E9FA0A0A09F9FA0A1A1A0A0A2A5A4A19D9B9EA2A19E9FA09E9EA5A9A3978E90A3
B8C4B6866585B7C0B0A29793979FA6A9A6A29D9C9C9D9FA1A4A6A49E989498A6B0A79997
9DA1A4A4A19F9D9D9EA0A2A4A29693B2C1875E9E
E7CD8F7D889DB2B6ADA29993959DA5A49F9D9EA0A2A3A2A2A19F9E9FA1A1A09F9E9B9BA0
A4A29E9D9FA0A1A09F9E9EA0A19F9EA3A7A49E9C9DA4A8A39C9EA3A19FA3A5A29A9294A3
B6C0B4886B85B1BFB5A5958F939BA3A8A7A39F9C9B9A9BA0A7ACA89888868F9DA59C8F90
9AA1A5A6A39F9C9C9EA0A2A4A39592B2C2865B9C
E7CB8C7A879CB1B4AA9F9793959DA3A4A19F9F9E9FA1A2A19F9D9D9C9C9EA0A09F9D9DA1
A4A19D9C9EA0A1A09F9F9FA1A09996A2ACA498979EA7ACA49A9DA3A29FA2A4A29C95959E
ADBDB8906F83ABBEBBA7918C949CA3A7A7A4A19D9996979EA8B1AE99847E8AA6B7A18589
9BA2A4A8A8A29C9B9DA0A3A5A39591B2C2875C9D
E6CA8A768298AEB2A89D9795989DA2A4A4A29F9C9C9EA1A09E9D9D9B999DA0A1A09E9EA2
A4A09C9C9FA0A0A0A0A1A1A29F9591A0ADA495949CA6AAA39A9DA3A09DA0A3A29E999798
A2B7BC997781A2BBBFA98E8C979FA4A6A6A5A29D9794969EA9B5B39C837B8DBAD5B07F82
9BA2A3A9AAA39C9A9DA0A3A5A39591B2C2895E9E
E4C98B778097AEB2A8A09C9A9C9FA2A5A6A19D9C9E9E9E9F9FA0A1A1A0A1A1A19F9E9FA2
A4A09C9C9FA0A0A0A0A1A1A19F9997A0A9A79E98969BA1A09DA0A29F9B9DA0A2A29F9B96
99ADB8A1858599B4C0AB8F8C979FA3A5A5A6A49B93949CA5AFB9B5997E7B97D0EEBE7F7B
95A1A5A9A8A19A9A9DA0A2A5A29591B2C2895E9D
E4CB8E788198AFB4ABA4A09D9D9FA3A6A6A09A9DA1A09D9EA1A2A4A6A8A5A19F9E9D9EA2
A5A19D9D9FA0A0A0A0A0A0A0A09FA0A1A3A8A99E93939A9EA1A3A29E9A999DA2A5A6A295
91A2B1A9968C91ABBFAD918E979EA2A5A5A6A49A9195A0A9B1BAB4957A7D9FD8F4C2817A
93A1A7A8A39D9A9B9EA0A2A4A29591B3C3885D9B
EAD090788097B0B7AFA59C97979DA3A7A59E999CA2A29F9F9F9FA1A4A6A4A09E9E9D9DA2
A5A39F9E9F9FA0A0A0A0A09F9FA0A1A0A1A6A79F9799A0A1A1A2A29E99989AA1A7ACA895
8998ACB0A5918AA4BCAE9491999FA3A5A5A5A29B94959BA2AAB4B1967E7F99C6DBB48282
9AA7A9A59D9A9B9C9EA0A1A4A39592B4C4875A9D
EFD390778096B0B9B1A39690929BA4A6A39D999DA2A4A29F9C9B9D9FA1A19F9E9D9C9DA2
A6A4A09E9E9FA0A0A0A09F9F9E9E9E9FA1A2A29E9BA0A6A6A4A3A19C98989BA1A8B0AD96
8591A8B5B095849DBAAE96949CA0A3A5A4A3A19C9896969AA1ACAD9A868291ABB9A1868D
A3AAA7A19B9A9D9E9FA0A1A4A39592B4C485589F
EBCF8D768098B1B7AC9F9492979EA4A4A19C9B9FA4A4A09E9C9C9D9E9EA0A09E9B9B9EA3
A6A19C9B9EA0A1A1A1A1A09E9D9D9E9EA0A4A59D96979FAAB0A89B95969AA0A3A6AFAF98
858FA5B7B6978098B7AD97959C9FA2A3A3A2A09D9B9C9D9C9EA8ADA08F8C93A0A89D9094
A0A3A2A2A2A09F9F9FA0A0A2A19491B3C486599E
E4C98A768199B1B5A89B94969EA3A4A29E9C9DA2A5A39E9D9D9F9F9E9DA0A29E999A9FA4
A59F99999DA0A1A2A2A1A09E9D9D9E9EA0A6A79E928D95ABBBAD968F949DA5A5A3ACAF9A
878DA2B8BB9A7E93B2AC99979C9EA0A1A1A1A09E9EA2A5A2A0A7ACA397959AA1A5A09999
9C9C9DA4A8A5A09FA0A0A0A2A09390B2C3885B9B
E2C98D788198B0B7AD9D92949EA5A6A19C9DA1A2A2A19F9D9D9E9E9E9FA2A39E9A9CA0A3
A3A09C9B9B9EA1A2A1A09F9E9E9E9E9FA2A4A49F988F92A9BBB09A93959CA3A3A3ABAD9A
87899CB9C4A17E8DABAA9D9C9E9E9FA0A0A0A1A0A0A1A2A1A1A4A5A09A999DA5A8A1999B
A09F9DA2A6A4A09FA0A2A3A6A49693B3C2885C9A
E4CD907A8196AFBAB3A091929DA4A6A19C9EA2A29F9F9F9F9E9E9E9FA0A3A39F9C9DA1A1
A1A2A29E9B9DA0A1A09F9E9E9E9E9EA1A3A2A0A1A19894A3B3AEA099979A9FA0A3ACAD9B
888394B9CDAA8088A3A8A2A1A19F9F9E9E9FA1A2A19E9C9EA1A29F9B999BA0A9ACA2989C
A5A49F9FA09F9E9FA1A3A5A7A69895B5C3885B9B
E9D090798196AFB8B0A195969EA3A3A09C9DA0A2A19E9C9FA2A4A39F9DA1A4A19D9EA1A1
A0A2A3A09D9C9D9FA1A19F9E9E9E9FA2A3A09EA1A49E999EA5A5A09A96999EA1A5AEAF9E
8A808CB6D1B084879EA5A4A4A2A2A29F9C9EA1A19F9C9A9DA1A3A19B979DA5ABAAA39C9E
A3A3A19F9C98989DA3A3A0A0A09392B6C688599C
EDD28F778097B0B5ABA0999A9FA2A1A09E9D9DA1A39E9A9EA5A8A79F999FA6A39D9DA0A0
A0A1A1A2A19D9B9FA4A3A09E9E9EA0A2A2A09EA0A2A09E9B9A9D9E9B97999EA1A6AFB0A2
8E7F87B3D2B4888699A3A7A6A2A2A39E9A9CA0A09D9C9C9C9FA4A69E979EA8A8A3A2A19E
9DA0A2A09B95949DA6A29A9A9A8E8EB6C988579D
EBD18E757D97B1B6AA9E97989DA1A2A2A19E9D9FA19F9C9DA0A4A49E9A9FA5A29C9C9FA0
A0A0A0A2A3A19FA4A8A5A09E9E9FA1A1A0A0A09E9C9EA09E9C9D9F9F9D9B9C9FA5ADAEA3
918186B3D5B88A8292A1ABABA39F9E9B9A9C9FA2A2A09D9D9FA3A6A09A9DA2A09CA0A29D
989DA3A29D9998A1A8A49B9B9D908EB6C988579C
E8CF8E747B97B4B8AB9E959499A0A4A5A3A09E9E9FA0A09D9B9EA19D9A9FA4A19B9C9FA0
A0A0A0A0A1A1A3A7A8A49E9D9EA0A1A09EA1A29C989CA2A3A2A1A1A3A39E999CA3ABACA2
938287B5D7BA8A7E8B9EAFAFA59D99989A9C9FA4A8A49E9D9EA1A2A19E9E9D9A989DA19D
989DA3A3A09E9FA4A8A49EA1A49591B4C587579B
EACF8D737C98B6BAAB9F9792959FA7A6A09E9F9F9FA1A19D9A9FA39D979CA3A29F9E9F9F
9FA1A19D9A9B9EA1A19F9D9D9E9FA09F9FA0A19E9C9FA3A3A2A2A2A3A29E9A9BA0AAACA2
928186B2D4BB8D7D869BAFB1A79F99989B9C9FA6AAA59E9B9C9D9FA2A3A19E9B9A9DA1A1
A0A1A2A09FA0A2A3A2A09FA6AA9B94B2C083589D
EED08B737D99B5BAADA19992949FA8A59E9C9FA0A1A2A19E9DA3A69E969AA1A4A3A19F9E
9FA1A19B9696999B9B9C9C9D9E9F9FA0A09F9EA0A3A4A3A19FA0A2A2A09D9B9CA1AAADA2
907F84AFD0BC927E8297ADB2AAA29C9A9B9DA0A5A8A49E9B9A9A9DA3A7A5A09E9E9EA0A5
A8A59F9D9DA0A19F9D9C9FA8AC9E95B1BD8158A0
F0D18A747F97B0B8B0A1969399A0A5A39F9D9DA0A2A2A0A0A1A4A5A19D9DA0A3A3A19F9E
9FA0A09E9B9B9C9D9D9D9D9E9FA0A0A0A09F9EA0A2A2A19F9E9E9E9F9F9A979EA8ADA99E
908186AECFBF997E7B93B0B6ACA39B9A9C9FA1A2A2A2A09D9B9B9EA4A8A49E9D9E9FA0A5
A7A39D9C9EA0A09F9D9D9FA4A69A94B1BE835BA3
F0D18A758094ABB6B1A092959FA2A0A2A29F9D9FA2A19FA0A2A2A2A2A2A1A0A0A1A09F9F
A09F9FA1A3A2A0A2A4A19F9E9FA1A1A09F9F9F9F9F9F9F9E9E9D9C9F9F9794A1AFAFA59C
928489AFCFC29E7F7691B2B9AEA299979CA1A3A09EA0A3A09B9C9FA5A8A29B9A9D9FA0A2
A29F9C9DA0A09F9FA0A09FA09F9492B3C1855BA3
EED18C757F95AEB7AF9E9296A0A29FA0A1A1A09F9E9E9E9F9F9F9F9E9DA0A19F9C9D9FA0
A09E9EA3A6A29EA2A7A49E9D9FA1A1A09F9F9F9F9E9E9F9D9DA0A2A29E9795A0AEB0A89D
918388AECFC39F807891B2BAAFA1959399A0A4A19EA2A5A099999EA5A8A299989B9D9E9F
A09E9D9EA09F9E9FA0A1A0A1A09391B4C385579E
ECD18C747E99B4B9AC9D95979EA2A1A09FA1A29E9B9C9F9D9A9D9F9B989DA39F9A9B9FA1
A19F9EA2A59F9AA1A8A59E9D9EA0A1A09E9FA09F9E9FA19D9CA4AAA59C9899A0A9AFABA0
918186AED0C39D807A93B2BBB09F918F969FA4A3A0A3A59E97969CA4A8A29A999B9D9E9F
A09F9E9E9F9F9F9F9FA0A1A4A39591B5C583539B
ECCF8A73809DB9BAA99D97979CA2A5A29FA0A19F9C9FA19E9B9FA29F9C9FA3A29F9E9FA0
A2A19FA1A29E9CA1A6A5A09E9EA0A29F9DA0A3A19D9FA29F9EA5AAA49A979BA2AAADA9A1
948283AED4C59B7A7392B8BFAF9B8D8D979FA3A3A1A3A39E98999EA3A6A4A09E9EA0A2A3
A2A09E9E9F9F9F9E9FA0A1A3A29490B5C685559C
EFD088727F9DB9BAA99D98969AA2A7A49F9E9FA0A0A2A3A09FA2A5A5A2A1A2A3A4A19EA0
A2A2A09F9E9E9FA1A3A3A19E9D9FA29F9DA1A5A19D9FA2A19FA4A6A098979BA4ACACA59F
968282AED6C79C766D90BBC1AE9A8E909AA0A2A2A0A0A09E9B9DA0A1A2A4A5A3A0A2A5A5
A4A19E9E9F9F9E9E9FA0A0A2A19390B5C686569E
F3D78F717896B6BAAB9F98959AA2A7A49E9D9FA2A3A3A1A1A1A2A3A2A1A0A0A1A1A09FA1
A2A19F9E9D9C9DA0A29F9C9A9B9FA2A19FA0A19F9D9FA2A09FA3A49E97979CA4ABACA79D
918084AED3C69E796F8FB7BDAE9F97989EA2A2A2A09E9D9D9FA1A19E9C9EA1A09D9D9EA1
A29F9D9EA09F9E9E9FA0A1A3A29390B5C684549E
F5DC9371728FB2BAAEA097959AA0A4A29E9D9FA2A3A19F9FA0A09F9E9E9E9F9D9B9DA0A2
A1A09E9D9D9B9B9EA19D99999C9FA1A2A29F9C9C9DA0A19F9EA1A39D97969BA2A9AEA99C
8B7F87AECEC4A17F748FB1B8ADA49F9EA2A3A2A2A19E9C9EA2A3A19D999A9C9C9A99999C
A09F9D9FA1A09E9E9FA1A2A5A49591B6C6814F9C
F3D78D707791AFB9B0A19593989DA1A1A09F9E9E9FA0A09E9C9C9D9E9EA0A09C999CA1A1
A09E9D9D9D9D9D9E9FA0A0A1A2A1A1A2A2A09D9C9E9FA09F9EA0A09D989597A0AAAEA99C
8D8189ADCBC3A383778EAFB7AEA29A9CA3A3A09FA09F9FA1A2A2A19F9EA0A09D9A9C9FA1
A1A09EA0A2A09E9EA0A1A3A6A69793B7C67F4C9A
F0D086707E96B0B9B0A19592979CA0A2A2A09D9A9B9FA19E999A9D9FA0A2A29E9A9CA0A1
A09E9D9C9D9FA19F9FA3A7A7A5A2A0A1A2A19F9E9D9E9F9F9E9FA09F9C96949EAAADA79E
928589ACC9C1A283788FAFB9AF9E9195A0A29F9FA0A1A2A2A1A0A0A1A3A6A7A19DA1A7A7
A3A09FA1A2A09E9EA0A2A3A6A69793B7C6804C99
EECF876F7A96B2B8AB9D9290949CA2A3A09D9A98989B9E9D9B9B9D9D9D9FA09E9B9C9E9F
9F9E9D9C9D9E9F9F9F9F9F9D9B9A9B9D9E9E9D9C9C9D9E9E9EA0A2A3A098949DA9AAA39D
948789AAC7BD9D827B93B3BCB19E90919BA2A5A6A5A4A3A1A0A0A1A1A1A5A8A39FA3A9A7
A2A1A1A3A4A2A0A0A2A3A4A6A59793B9CA87559C
EFD28D707696B6BAAA9C9391959FA6A5A09D9C9B9A9B9CA0A2A09D9D9D9E9F9F9F9E9D9F
A1A09F9F9F9E9EA0A19D98949395989C9F9E9D9C9D9E9F9FA0A1A3A5A39C989FA8A7A19D
978A8BA8C2B99C827C95B4BDB3A1918E96A1AAABA7A3A09D9C9FA29F9DA0A4A19FA2A5A2
9D9EA1A3A3A2A1A0A1A2A3A4A19290B7CC8D5DA1
F7DB9478819FBEC4B6A89F9CA1A9AFAEABA9A9A7A6A5A7ADB1ACA5A5A8A6A4A7A9A5A1A3
A8A9A8A8A8A6A5A6A8A6A3A19F9FA2A7ABA9A5A4A4A5A5A6A6A5A5A5A5A4A4A8ABABA8A4
9F9494A9BCB8A3897E8FAAB7B29E8A89929A9F9F9D99969392979C9D9B9B9A9896999B97
9394989A9A9A999999999899968683ADC48556A2
FCDD927A86A1BEC5BAADA3A0A4A9AEAEADAEADABA8A8AAB0B3ADA7A7A9A8A6A9AAA6A2A3
A7A9AAAAA9A8A7A7A8AAACABA9A7A8ACAFADA8A6A6A6A6A7A7A5A2A0A0A4A9AAAAAAA9A6
A19C9CA5B0B4AC9482899EB0B39F8B8C979998989796959291959B9E9E9B979595979895
919396989897969698989697948481ABC28050A1
F1CA7C626F8AA5A99C918A86878C90908F90908E8B8B8D909293928D8B8F959694939392
919292929292939495959698999897969696969492939597989896918E9196999A999794
9396999799A8B09F8B8E9FB5C0B4A4A6AFB0AEADACADAFAFAEACACAEAEAAA7A9ADAFAEAC
ABACAEAFAFADABABACAFB1B3B0A09CC3D79460A5
E8C0725864809A9A8B827E7B7B808483808182817F7F807E7F868A827A84908E898C908C
878585868888898A8C8A898B8F908F8984878C8C898A8C8E9194948D87878B90938F8A8A
8E979A8F899AACAA9E979CAEBFBAB0B2B9BAB8B7B6B8BBBEBDB8B1B0B0AFAFB5BABAB8B7
B8B9BABAB9B5B2B2B5BABEC3C2B2ADD0DD965D9E
F3E299818DA9C5C7B8AFABACB0B6B9B7B4B5B6B5B4B5B5B1AFB4B7AEA7AEB8B4AEB1B5B2
ADABACB0B3AFAAA9ABACADAEAFB1B0A8A2A6ADB0AFABA8A9ADB0B1ACA6A6A8ACACA5A0A6
B0B5B0A19495A3B7BC9F808392918A8D918F8C8B8C8C8E9395928D8A8A8B8D9295938F8D
8E9294938E8986888C8F929B9F928BABB055197D
F8F7B9A4AEC7E3E8DCD1CCD0D9DEDFDDDBDBDCDCDCDCDCD9D6D6D6D0CCCED1CEC9CBCDCB
C9C8CAD0D3CCC3C1C3C6C7C8C7C8C7C1BDBFC6CCCCC5BCBCC0C3C4C1BEBFC1C2BFB5B2BC
CACABFB0A09296BCD1A770677373707374716D6C6D6C6C7074757472727376787875706D
6E737775706A686B6F7072797E716B8B90360070
DAC595848A9EB2B5AB9F989BA2A4A3A2A1A1A1A1A2A2A1A2A3A4A4A3A3A2A1A1A19F9EA0
A2A1A1A4A7A4A1A2A3A09DA1A5A5A29E9D9FA3A8A9A49D9B9EA0A2A2A1A3A5A6A39C98A1
ACB1ACA092868BADC7B3928D979EA3A4A2A09F9D9C9C9C9D9F9F9F9E9E9E9FA0A09F9D9B
9A9DA0A1A09F9D9A99A0A5A49B8B87A8BF9877A6
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Level) show
99.000 12.813 moveto
(4) show
105.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
81746D6D6F6F6D6B6A6866625F5F60605F60605F5F616363646669696A6D6F6E6D707370
7A7B6E6E6C76727176736B72757275777878767574767778787574777A7B7A7B7C7D7D7C
7B7888818A8F8E8A8B9AABB4B4BFBCBDC0BFBDBDBFBEBEBEC0C0C0BEBCBCBDBDBCBCBCBD
BFC0C0BFBEBCBDC3C5BCC3C5BCC4C4C3C4BEDBA3
AA9C9494999997979797979797979898989898989898999998989899999A999897999B99
96969798969D969993A0959999959898979797979797969797939F949996949B92909998
9896949798939C9B8E91918D979392929396989693929293949594939293949594949494
939291939595948F8B8D91928F8A92858AA5A56C
BB9B94959A9B979798989899999999999A9A9A999999999A9A99999B9C9996989A999798
99999999969D98919D9696999A979998979798989998979999929D93999593A29E969795
98999999968D95959B9192999091959392888D8992919392919191919191919292929291
908E8D8F939795878F9C9A95978F8D8C7CB4AB5F
BC959495989A98989A9A999A9A9A9999999898999A9998989898989694909E949996909E
91969997919998929E939E939795979796969797979696999A939C9196A2948996949B99
929492919D989495979A9A949094899693969A98939292929292929394939292928F8C9A
998B9F9C878D929F9B92858091A4AA9977A19151
C28C909091959696979797969696969695959496969593919192938F9995968F95909794
9791979198949891998A939A93939596959595959494949697939D8C8E9F978C959C8F8F
999A9795949596969493939394989A9692929596969594959593929497969493919D9793
949B8F9A92968E9395949E9C8F949D8D87B5B357
BE939595979B8D8E8E8E8D8E8F8F8F9091929392908C9998989797999994929A929B9293
9A92949A92948E96989299949493949597889795939495928F909F88949F928D9AA48E8E
969692929394959494949596989998919C9D8F9397989899979F999D93929F9C9A989695
9598899B9C9E9E9891919F9A9798937B8BB5B856
BE928F8F93969697989796999B8B9A9C909394919B979494959291988F8B959B929B9498
919592989198959B9990969597959395989999979596968F989D929791959B8C8E9E9493
9796939597959494969797969594919992959D919596969793978D939C8A969291939596
9693939B918E949692938E958F959E9186A6AD52
BF94929396989697989796989A9A9898999B9C9A97959595959493989C99959A8F8B9597
9B8E9C95919A9789939A94959790999B9191909396939D9795998D979799999393989394
9797969696979796959797928DA08F978F9690969794908F8D9791939897959494959696
9695969D8C8E919B999A949191A1A79285A4AB51
BE9495969899969697969596978997959393949494959696969696969594949799989593
93959793929C969299959494929990939896959C928D94939594949A938E919698939394
95979795949698959193938C979B8F99929A959A97909A98989898979696979798998897
95969697A195999496989C9790989A8985ABB153
C78C8D8E9192909091909091929495949393939394959595959696949293959596969796
959595939591999194A193909B989696969493979A989596979292A091949B9B8F949C99
939294959594928D9A9C9E9A969A8D9994998F918F9B9695959391919292939292979B99
938C948F958B999A8C8890969394948684BAB050
C1939394979A9898999999999C9F93959493929495949292919292919192939291939598
989593949A959A8F919E918B95998F8C979696949396999B999293979A8896A49C87949E
918E9092928F9B9693959886979A9C999595979897959495949E989A9F909E9B8C939997
9C919A8D999690909995A08F91A5A68885AAAE4C
C29392939697959495959595889095949E99999F96939C9A9A99999C9F9E9B99999A8E92
94909D95909694988D99999795989B999796969392968B8C989294999A928E908E97919C
929F9F9D9A9997949293959495988A88969595949495949493908E909293928E9DA1838E
9494A394979A969A96A5918F9197998A86ABB04E
C39492949796919294929191969E939098919099928F9794959292988D8A94939394969B
9C899895929299909995949596959495969695949597999896949797929695A091949595
93928F99939395959595959393969A9996959595959696949394969796969593909D9996
9C93919A96949E928C9B9193959B9C8A86ACB250
BF8D8B8F94909A9E929D989E969795959492929598979494949393959797969594939395
969598939C99919A9694939495949393949596969697979594988F9494998D9C9D8A9B9E
9195958C959395969697979796969796969595949595969695A494969794A09391919799
9299859A8D8F93908E9E9293949B9D8B85ACB24E
C99694989D9992988E978F99948F989B919494918E8F9292929393919093979796959492
93959A929691999593949695949596939193959696969694949B919C948E9C9896939397
8D94969099959595969697989896949495959594949595969593919395929C8C989A8E8A
9198919E938D979C9597959392999C8B85ACB24B
C2919190919291969A9490969C8895969B8EA09D9A9B9C9B9B9B9C9B9A9C8F9295989997
96988E96988E919F9196999794989A949F9F9293929394939396968E989B8F8B96939496
999C9C9A979695959391908F909293949495969696969693919396959496918F94A69497
9CA1919B989F9B8F9597969392999D8A83AEB549
CB8D8F8A979C919292929292929597969595979796969593939394949595979B90959796
95988F9696998B998D93989694989B938A9B8D8D9F90949695919C94919A928F99979797
94918F9194969594909B9796999F9494949596969596958F9A92999690A29F8897A0959A
978E93939394959493949493939B9E8A83AFB646
C7979997979A9A98999A9C9B9C93999893908E8D8D8F9193939392929292939596979592
939E989A96919D98989B8E919192908B98989A999A91999C9990989393979C9B98959290
8E9A998F959796929C9795988F939597979795918D9F919B969B9291978C9896918E8C87
978FA0919291929394A39392939A9D8A84AEB242
C4919194989893929394949598909696919C989596998F949695949394949493918D8984
8694908D96999E989192979A9B9A97959596979597919C8E978F99969794929496929C9A
9A9A9B91979896919B95958E979693969997929A95988C99959697978F8F9792959E8C97
92979195949F9C909595939292999C8B85ACBD4D
CF8B8A8C9093929597938F8F9295989897979898989B9F939698999A9B9896979A9AA8B4
A3998CA59D828996919599938E92989895968695958D94919B9694959695929395949291
91919294969796928D95939D97949C8E918F99969594969A8D8B959E9E9B939D8C9DA2A0
989B94969593919396979694939B9E8A83ACB03E
CB959494979D919597929B999A8C8D8C8C91969899999A9B9DA094989894A096A09A9393
999D9198988F95A290979C90959B979793A39595959999938C9B8F909293939291949897
95949493929293919C959299928E9696989693959794939AA08D94909193989A99909393
939395959596979695969794939CA0887DB9B23E
C89393949699979595969795959CA2A09C9D8F8E8C8B8A89898B8D8F8F8F91878591897A
8690909D8F9DA199919791929C9693878C9E90959897939C98989A9A999B9C9A999D9290
9C9B9B9999999A999895949698979697979694959693929596909FA18C9189988F918D8F
928F9B8F94979794909F908E8E9A9F8486B2BB49
C490919598978F95939A9392919B96939A96949291929494939495929093988A9697978A
9C95898994829097898B96919293958C999998919A968E99988998959393949393969896
93919192939393929395979390929798979797959595929C97959695979C929C919C989B
9F999399949795909A97979697949A8F81ACB443
CE97898E94949D96968E95938D9D7F8C8896989DA5A39FA3A59A9BA59D9AA69E9DABAB9F
A9AA8CAEA2918DA3999B9F98909DA19C949A908B97929793949595949292929292939394
9494949595959493949697929C9C8F8F8F91949596989497908D948B969A9994939C998E
928F9A8E9498978F96949593939DA28B81ADB541
CA9190968E918E8C9C9E9F9E9A939F8F949B959394988C93978F949E948D949689948D7F
919892AD9E97A1A59F9AA39592978E949B989B929D998F9C8F9295969594959595949495
9898989898979796969696948F9A9795969B919595969195979A989497989093928F8E90
93959695959898909795969391999D8883B1B841
C99091969EA19D99948C878C968DA39E9C9D8D8D8B8994898B91898A8B90938A91939192
918D7B837B7C908B7B7C80999791938F8E8C989B908D97989D9498989797999998989895
92929291919293939394959694909A96959C9495919A9596909A95969193929C99999C9E
A0959897949596929C99979391999D8882B1B840
CA9292959A9B95918D96938F969C8E9F90949491979B9B98979C949C97969696959C9E96
9B9A9A9A9AA199909AA28A999E8C8DA69A809798959393978D9498979597999897999992
9A97989797999B9D9E9092959796918A969D95949A9092999B959C9699A08F9792968D9E
8E91949391939493908C9893929B9F8982B0B740
CE928B8B8C87919997A5A497989888848F979DA1A496939C989D979E969E979D96999B8A
95A59F979DAA9593A5AF9B9E91929BA492A09998959596979A8F9291908F8F8E8E90928D
969494949496898C8C99989C9294A29A94898F9B959497968A8E928C8F999494998E9193
928E9B9A9C92959F98979894929A9F8A82AFB642
CC8D959497949395979995959B8CA09497928B9A898B9B938D9199899995929593888987
8BA39492969A9691919B8595968C93958F94979797979797969799999896949292959797
959595949496989A999491949A8E8E989395969395978FA09799969391958E9693979797
939A93939892959B9092989591999E8983B0B742
CE908F9999AA9B918D85878A95909EA0A0988E989594929A949495918D97928A95AAA7A9
8D9E7D838C8C938B8391869A9C989494978B8F9191919092949495969695A19F9EA09495
95969696969797979694949597969597989896A28E94909692919A9D9C99989C94989995
9C959293978D8F9891939794919A9E8881B2B93C
C994909593A28C9D969B9B949C9693929099929B96909B96919E99929C9A95948F979A8D
8AAA939490999A8A9CA298999794978E93A295989997969A90929192939494918F919495
959696969595959494969796939192979B89959A979198A48C9A99979A9095949295978F
959395969697989795969693919B9F8880B3BB39
D592899187878F9394A39E999594928D958D949D968E9895938F97909791989D93938185
8AAF9499A3AF948FA39D95888D93989895949495959494979A9A9A9A9B8E919293949595
959595928F9C8D929695909B9A92999A948C909B8F968C96998F8D8B8D91959695949199
939599989595959696969693929A9E8982B0B742
C18C959399959B9593908F8E8F9392999B9097909A8F969596929A949C909794939F9B98
989A8F91979298999C7F9F96979F929E96989594949595959594949394979B9194949292
9292909B9793959E96929891949490999990A096929C929A8E90A090919F919597929994
94998D99939496959495969492999C8C86AAB051
B68D9797A39F99949393929C97A694989A919B9299919A9A99919894909991908F99A496
99879192887D8C96908AA396988E92889093949596969594939394949495979A9C9A9899
9C9A98979592939A91909B979892969095949390989596919E9B9B9C9E9F9094959D9592
959B8F9A939396959495969493989B8E89A6AB5F
B69791978F919698989A988C8E9690949A929B92999491909B91989595919C99958E8B8E
929C969CA59D959D8B988895959A9997989D929696949190919395979795949493909F92
96959294969594979A8D8FA0908CA793989A989198929D908E9794878A9C8F908F999492
949B8F9A949496969595969493989A8F8BA4A867
B2908A948F909092928F989D929890968D9690978F9B98958F988F9B999693909D999698
9A9694978E959A9B94AF988D8F9A9991949C9293909D9A999CA093969695939494908D8F
939494959695949596989A8E9D958D8F94909293959395909A9594959798999998979593
949A8F9A949496969595969493989A8E8BA4A867
B896959696939B98959B9099939D9399919A958E97938F9B95909994908D999796969696
95949391939991948A978C98959E8E909099918F99949293969C8F929291919597939F8E
929597969595959594949497968E9A959C92A19F96989991989596969595949394959694
94998D99949496959595969493989B8E8AA5AA62
B39293919E9D978F959A928D9990949A929D99939D9894919C96919B989898938F8F9293
91909C99998F989197979397968F90A4978F9E9C9492939687899A9B9B99999F938E9A9D
A294969594959696959494969498989794938D898E979790989595959595949494959695
94969897959595959595969493989B8E89A6AB60
B594939B94959296988F9A9690969A909894909B948E9A9996909994939697919998999C
9C98939294978D9B959093A2939194A2958998999393979A9B999594949191989D999599
90939494949596969697969590969097949098968FA2938F999694949696969696959595
95959495959595959595969493989B8E89A6AA61
B8948F8893919A919599909C9A93989099928C99948E9896948F989593918F9C98949091
918D9C909796959F9B8D909C92929095938E95969494959798969394949291978B869295
8C939798969595929297988F999C8D9499989D9D8FA0928F9A9694949696959696959595
95959495959595959595969493989A8E8AA5AA62
B88F9592919A919A92949794948F979099909997958E9593928E9996929B959696909998
98959690999792968F99909D968C9D94969995949595939393949596979695989B979394
9A929999969290A191959499979F97979494998F8E9F938F999694949595959595959595
95959695959595959595969493989A8E8AA5A963
B1959A95A39D948E989C928C98949D949C95909E9B939C9B9C9B96919A959392909B9494
9695969C9092939599919797909D99919694979396979595949596969696969696989B9D
9E9092928F9A989199949A9484958B9693938D8F8FA0938F999694959595959595959595
95959695959595959595969493989B8E89A6AA60
B6998F88938F989199939B939C9690988F9996948F989394969591999392A38E9A959394
96979795969C929596979B93919F8F939C9C9A9497989998979797959395969392999093
918D9B999891929492908D9790A28E9A92979E9F90A0918E989595959595959595959595
95959595959595959595969493989B8D88A7AC5D
BE8F958E9A949B9590989099948D99949099938D98959291908D999794918E9995949595
9393929293969B909496978B929F9289968C8B9697888A99968698969395969493998E8F
9D999694959498979D9898A6939C8F9C93959093928E9A98969595959595959595959595
95959595959595959596969493999B8D88A8AD5A
B7968C97939A908D9A9095918F9A9494939A9099969695919B96949797929B9594959795
919D8D90939393998F9494929594998E9B998F9996989B98959698969495969595979998
95949494969B919894908E9F8E9294A29294949691999493959595959595959595959595
95959595959595959596969493999C8C87A9AF57
BC9C948F9A939997969D949E9A9896939C939A95949696A0989393969891999494959695
929E9C9EA1929396999A9D939B929D94979D989D93939797959596969595959595959594
92949595978D949590948F91958D9096899B98959C969494959595959595959595959595
95959595959595959596969493999C8C86AAB053
C4928C96939D9593939C948A9697978F939994939496958F979494979790989595959595
9593908F9194969593929796969494999291919293909495959494959695959494959695
94959695978DA4909D9D99969994989C9292999296949696959595959595959595959595
95959595959595959596969492999C8B85ABB150
C08C95929099908F8F988F989392919A929892939798958E969495989790989596969595
959594949496979594958B98939293939A8E969A9B979896939496959495969494998C9C
98969593949E92899591919597988E9E929D918D96949696959595959595959595959595
95959595959595959596969492999D8B85ACB24E
BE98918E9C959B9999929994919C9795919994959897929B95949696948E989595959595
9596969797979695969B8F959A8D929B8D94979396908E9A9696979594979A98979E9493
8D99959395A09295919F91959B9395929196979897959594959595959595959595959695
95959595959595959596969492999D8B85ACB24D
CA948C9795909694939E96909C98938F9A979594928F9A97959595909B9997938F9E9194
9697969595949494959699A094979AA0919C9297919892A28F8B9796998E918F8D919696
929E9B8B8F9492959C9695948F929A989496949596969595959595959595959595959495
95949394959595959596969492999D8B85ACB34C
C58E96919E9A928E8C9A948D96939099939597929B9694949596939A9193979198979A8F
949594919090919292909199909293999992989799909697999199998F95989794949596
959190959999939B8F919B928E9F8F8E9898949495959596969595959595959696949395
96939F91959595959596969492999D8A84ADB34A
BF96908D8C959D9A9A98939A929C99959396979198949494959793999094999297929397
9C9193A09D9A9A9DA19292959B90968E8A9A8D95929A8C9898938FA092969996A4939597
979492A697889797978E989695A293919898949496959494949596969595959595959698
97918C9D9395959595959694929A9D8A84AEB548
CB908A999A929795979691988E9693939597958E97959696959490999396999399949291
949C93928E99988D93969695968E9A939B93939E96939297939396959395969390929596
96949293929196979398969F8D9797919797949596959494949595959494959595959697
958E989A9195969595959694929A9D8A83AEB547
CA8E94979A91928E90909B939A9593949697949C95949696929C9695969592908F9D9B94
9098929592908F9194969694949C959E9599969390959A9C939397979494949394959695
9494959895989A949A958E91938D9A92959695959595969898938F9F9395969796949190
9D9794999195969595959694929A9D8A84ADB346
CB8D9294988E9D9798989690989596959595939A9393959590968E939892999B9195949A
929792969798989796959594959A8F978F94909B95949396989495969695949597989795
9496988F9A929297928E8F9F96909B91929495959595969A9A90979A9295969896909A97
95929399909496959595969492999D8A84ADB246
C98B919192999993959796909895959696948F9893949798949C9697989096969A90938F
9A9D93969797979796959495988C9299909793969A8F989191979393959999969395988A
9999988C99979095979F99999791979A9C92969796939093938C959992949394929B9594
949393979C92969694959694929A9E8A83AFB748
C498918E9C939692959796909894949697929A96949597989794909C958E979393979B90
9294949595949494959594969A90979C929B979290989A899B9D9593978E909890939B90
909E998694A4929B929891949A929394988F979997928D9A9996959A90918F9D8C979494
969695959890979794959794929A9E8982B0B947
CC938E9A969096939595939C969394979790979696938F909294939B909B99969493969D
9496959595949495959594959990989A8C9490999892999B90948D9A9D92949E998BA094
94939B9191A3848B939A8C9290999695968F97979394A29A929194979A9A999897959495
96969594968F979794959794929A9D8A83ADB13D
C68E8996939E979596948F9894939598978F979697919C9B9D8F8F968B988B999693939A
939695959595969695959595988F9796959B9690919A9298949C96939394959595959596
95959E8F91A799988E9B9B94969E8A96978F96948F8F9E92989B93959597999795959695
95959595989097979495969492999D8B85AAB945
C69A9393958F949599939A969494949797919895959494918E9D99A0999797979694968D
949695959695959595959595989097969397919C9B8E939399869C979593949698899896
93969391958E8E9297A09388979C9494989E94969E9B8A8399969495938A908D96959595
959494979B9296969495969492999D8A84ACBE49
C7978D90959D919499929795969594979792999493989B98919A928C9795949494959991
969694949595959595959595999098969397909A959392999B8C929994929496988B9A96
9295959792979E978CA59B8D979890949B9093989D86A39399929597949C959198959595
969494999094969595959693929A9E8983AFB53F
C1958F8C9C9A9495968F969496959496968F96959694918E9C958D969394969594959A93
99989494969595959595959598919896939891978F98979E958E9A9E9391969B9E8E9B99
9694939F989394928B948E8F989C988D93949394967DAA999490969894979D9B96949496
979493999295969595959694929A9E8A83AFB249
CC94909893969694909A959495959596949A93969890979495929C959194979795959892
999894949695959595959594978F98969399939699929293989A929697959A9195929C8E
9C9490988D9A979888A190909993939698979490A09399999C9395999492939394959596
969392999396969595959694939A9E8A83ABBB41
CC918B959394909B98969595959596959299939497939D999694929D999694949595978C
919394959595959595969694949D9494939A93959894929D8B9294919691929495939193
929590A0909199919CA59794989397979696959F93948989928E96979492939394969694
909D90999396959595969693919A9E8A81B6B73F
CE8E9394979499949394959595969694909994939597968F999696959199929295969695
979C9395959595959596969493988E9193999194989492979098929996919A9694949598
9497939B919397978E9D928C9992969593949490999696989A9996959496979594979790
98988F9992949293949697928E979B867CB3B540
CE8C91939994979394959595949697929B9694959595928C989694918D9A989796969694
9499909496969595959595959495989D93998F9F918D99A09B919C9C8F9B919996969799
9598899B98919B938A9190989D93959695919D8D8D99989E948F97959698989693979890
969890989D8E9C9D91969791999FA38E86B0B541
CA8A919398939895969695959595948E9794949797919B989693909A979C918E98989997
95969A9297969495969594969796969C92988C9A9B938F99978A9196919F958E9997988B
979B909B9D8D979C97959B939394959797919A9B9D969299938F9796988998959396978F
979A9297988A99998D93979096999B8782B0B741
D3959193969196949796949696929C9895949497978F989696929D9A8B9398929A8E928D
959397909797949496959496998B8E909294979A8E929995938F9F9A8D8E97928E99968E
90A1968A91949197989A9297949495959594928E8C9A8B8D9C999595979796959595949B
968E969694988D98959E9791879A9C8681B1B93E
CC919092929D9493969594979890969496949497978F989696928F9E92989A929B939A92
969397909797949495969796988F96A59090949B939496919D95909A949B9896939B9791
96988D969E9699958E9193979495969493989A91989D9490979494959595959696959199
96909A96919A92988F999590979C9F8981B2BA3A
CC91908E9C99939496959396989096949694949898909895959493949596948D99939C95
9A979B919697959495998B99959A8F9E9C8D949C9394959B958E9A8E94939A8896A18F93
959C97929594929698999597959596949498999095989D9A959495959595959596959199
96909A96919A939A90968F9A939BA08981B2BA3A
CE93918C97979495969594969791999695949597978F979495969796948F9A9697919895
8F9D909396969693949B909B93929595978D979D929394988F9A9895969A9A8C9A989592
91A0938D9C95929B94919596959495959595939B9492939495969595959595959595929A
968F98969299909A949599948F999F8880B1BA3B
CD94948E98979494969594979791999595959594909B9694959696929B979596998F9392
9193959595969693939A8F9B93929494978F999195949498909A969190959890909C9590
9199948D959F8E97909695959595959696938E989492939495959595959595969695929A
968F989793978C999495969390999F8880B2BA3B
CC93948F9A98949495959596958E97949496958F999594959695919A949293989B8D9C9E
929597969495969493998E9A9494979799909A9397959499929A938D9B9E928F95A0968F
93A3958E939D8B93969994949494949594909A969495979695959595959595969795919B
989098979395989694959694929B9F8881B2BB3B
CD908C8A99989494969695919B9896959596959D9492949796919A95949394979988969B
9295969695959694959C8F9B94939596998E969E949595988F959D969192969993969095
9399979090A691959699959393A1918F9C9996959596969695959595959595959594919D
8E9297969495969594959694929B9F8881B2B93B
CE9B93939798949496969299939395969595929B93929698978F9695969695959695969C
92959595959494969A8E909B94929395988C92988F9396979A90978F9896998E8D9C9D8A
939F958E9A9E949595989492909F8F9B9794949596969595959595959595959593908E9E
929496969595959595969693919A9E8981B0B73B
CD8A909096989495969199959493949696938D989493959796919A969495969595998F92
949494969693939A91919D98959393A3978CA3969A919597988E949D96908FA3998DA18C
92A3908993958E8C9797929E8F9294928C969395998A98969495969595959694A09A969B
939595959595959595969693929A9E8982B0C53A
CC988F9096989494939A93949796949697919A9695949596969591999393969698919798
959495969793929C9490989595949394978D9496978F9697978D949C968C989B928AA28E
94999990989C96929A978F9A9B929999949992959B8D9A97949496959595969490969097
929695959595959595969693929A9E8982B0B539
C8969090969996909B969394979594969790999595959595949696919A9593988F959797
96959596969493989E8A9796959494959990979696909997949A93998F99949297949694
8AA393889C9E989298979097948D9799939992969C8D9A96949496959595959592979098
939695959595959595969693929A9E8982B1B647
C4949090959A978E969495969594949696919B9694959695949697969197929994969494
959595959595959494969797959495969991989795909996929893959894919A8C9F988D
959E9C8E8FA189919697929790989396919892959B8C9996949495969595959694999299
949695959595959595969693929A9E8982B2B745
D0929091959996909A9695959595959697948E9894949696959695929B95929A94969595
95959595959696959494959594959695978E9696959A91919299929597919D9495989392
9399908F91A58E949797949C979C9396929992949A8C9996949496959595959694999298
929695959595959595969693929A9E8881B2B734
CE9191929598959492999394979592949796929B9393969695939099949394998F949796
95959595959596969695949495969694949C93969594969B93998F939890998F8E9C9792
8FA29290949A93979897959392939596949992949A8C9996949496959495969591979197
929595959595959595969693929A9F8881B2B842
CF91909296989595939A929498929D8F9597949B93949895909B98959494959699909696
95959595959594959595969595969693939A9195969393989094989E9690979B939A978C
969A9793979B93949394959695969696939992969D8E9A9694949695959696939B95929A
949795959595959595969693919B9F8880B3BB36
D1919091959895939198929598919A9C9194929A929599939994939496969594979D9496
959595969694929194989B9995959693939A9196979593989D909399928D95988C9B9491
96A08D98988B91918F909293939494938F989399A08F9996949495969596948E9793959C
959795959595959595969693919B9F877FB5BE39
D1919091959996919C9794959694908C9B9D8C989394969097949395969594978D919495
9594949697919C9E968D918B95959894939A939796949399909293969C949C9790989796
9193948E98989FA09F9B999A9D8D9B9A9996958B8F8D97959595959695929C989594968B
909394959595959595969693919B9F877FB5B039
D09191919599978F979595949398998F9695989592A1928D989695969594949C94969595
9594949797909A8F9992969E93949995929A93979693939991959596978C969895999099
95909A9398978F929098919296969493949496999A98959595959595938D959495969797
999D93959595959595969693919B9F877FB5BE38
D09290919499968F9795969393999C91969597928D9E909B969596969594969098999696
96959496969390939A92969D9291969493988F94969594979D939797978D979791968D9E
94969A978C9A90908D97929294949493949596969696959595959594A09A959494959595
978E95969495959595969693919B9F8880B3BC37
D19290919599958E98969594949798909998978F979A909B959495959595989097979594
9595959595969697998F939B9191959594969B91979794949890979899909A939A919A94
93989397919D8E9B99979696969696969695959494959595959696938E9A979695949394
989197979494969595969693919A9F8880B2BA36
D19190929699939B969495969594928C9796949A9399918D959495959594969B90908E9D
9094969694959697998F929C93979C9893949A9096969493968E9596978E969D948E9899
91939492949D9796979594989C8C9996959595959495969594969794909B889798979596
9A9297979494969595969693919B9F8880B3BB37
D1919092979891989393959796919C9896938F979399919C959496969594949698979697
9A91979794939495988D909B968C939C9292998F95969493959B9193959990968F9B9391
919A9B87969C90919894919991909995949496969595959595969695919B969595959698
8C9195969595959595969693919B9F8880B4BC38
D1928F929798919894939597978F989696929B97968B9D99949496969595949495959594
968E96979594949596999A98988E939D9391969D9397979595979C929697988F99969D8B
97A39C86989F8C8F999692979C8C98959494959695959595959695909A98949A92978F95
999E93959595959595969693929A9F8880B2B936
D2928F8F93948F9995949497978F9796979199989A8A9896949496969596969595959694
959B93959595969595939394988C8E9B9491939A92979896949498919896949A9691A686
8F9E9D8295B08D8F9A9893949797979695959595959595959596949D96958F8D8E979A92
969B91949696959595969693929A9E8881B0C534
D2928D999A9C999695949497989097969690899797969594949596959495969595969694
939992959595959595939394989C9D9A9592949A8F9191939594958E9696958A939D81A0
978F9991899D909199969395988998969494959595959595959594928D959AA59A959991
879B91949696959595969693929A9F8880B1B835
D1918C95929494949594949798909895939D989594949595959595949494959594969693
939992959695959595969696978B8E9A9394989C8C9B998F9695939A9395969A919B919E
91939B8E99989493959394979A8B999694949696959595959594959895948F9993939A94
989D93959696959595969693919B9F8880B3BC38
D1928D96929494959696959696919A948F99959595959596969695969797959595969694
949A929595959595959595959890959B909790919C95939C9696949A93959599919C9392
929A9696999498949E90969896979796949595959595959697959497A28E8F9D91819C97
968F96969494959595969693919B9F8880B3BC38
D1928E989597969697959292928F9A929A95939597979696969392959998959595969694
959C939695959595959494959993989C8F9895959E94919A9495949B93949498919B9397
9794929F958D9B94988D9897929395959595959595949394969493959D858DA894889C9C
968F99979393959595969693919A9F8880B3BB37
D2918A9595979595958F9B9A9B9A968F9694959493949593909C9B8D9092949595969594
958D94969595959595949495988D909A92959D91918B96998E90929A929495978E978F97
989288989B809E97958B9898939395969694949798919A9B91919298A0809DAD97879AA1
8B9198979697979594959693919B9F8880B3BA37
D08C949295979593919A939294949199949597938E9E918E99969494969C929595969694
959C94969595959595959595969797979692919B93909A97989A8F9890959696998F9793
999392A49D7F9E9A949897989495969696949398998F94959C8F929BA37E96A6938598A2
8E9095989B8C999694959794919B9F8880B3BB37
D7949090959995919D96929395919B95939698929A98999896959493959B929595969694
949A9295959595959595959595949496969391989E99929294969B939D94969696979E8F
9A948CA1938F9C9B938796979495969595959496968F989B92929399A281919E90869B9C
9699929A9190999594959693919A9F877FB4BD34
D18F8F91959A968F9A969596958F9793949797919894939495969696989C919495969694
939991959696959595959595959595959595959898929A998E9298919A9193949593988B
999387A19E80989B929696979394959595969694929E8E93989693949D8593A39C819C94
8F95929C928F989595959693919A9F877FB5BE31
D4939191959996928D9995929E9995949596958E95939394959595978A8B9D9296979693
939A9396959595959595959595959596969493988B878FA29D899A948A9B9B9196949597
959F93969E84A299919696979495969595969694919B999198958F9D97959C9A988F99A3
938C95999998969594969794929CA0877FB4BD32
DB89949295989693909C948D979494959695919A94949696959494969998999097989593
949B949695959595959595959595949697929198A090979E90909B979896968F98969694
909C908D9F869B979196959795969695959696959199958C95A18B989294939798969892
9A9398969192959594969794939CA08880B3BB35
CF8A9291959996919D9A968F9794949697929B9796969697969695969795968E95979594
95988E92959695969696959595959596969495979B8E99908E9B95919595969099979793
8E9D91949E979295949792939495959595969694929D9B8E92A08E9992988C92928F8E94
98919896929395959595959190999E8780B3BB37
CD97908F959A978D9696969198959496968F969596969595959595959593959B93969595
9694969C9496969696969695959596959497999693989896969C8E9B9196999197969791
8B9F948E9D94989297988E9F929494949596959493949493909F908D969E949998979597
958C959898999997969594918F989D8780B4BC36
D7938F90959A978E9793919B96959696949C9491919495928F9D8F939694939992959596
969494988F9496959393949595969694949889969194968F97978F9A929799909594939B
969F978B91949A8C98998D9E92919F929696959596979794909C9B8D9B919690929C9598
989C94998E92938D96979A9997A0A3887EB3BD34
D29090919599958F9A929994939597959099938C999D928E989598929996929892959595
95959596998F94918E9E92949696959495979896949495969593939B9396988F93A09095
909D988898989D86999A8C9E93909D919696959697979695919A968B9D9399989C8F9299
8F91939991999A909699929190999C8C7EB3BE32
D2908F929798919E999098949395959199939E9895979999979597909795929A93969595
9595959495999C99979B929596959595969595989A999696979695988E949A9092A09092
8A9995939D9C93939C9B899B939392939596959392939494919B978A9C968F909492929B
9494939992999A90969A9292909CA08080B4BD32
D5918F9297958C98958E98969694919B948E9894919090949797979D9594939A94969595
9595959696979795969B939595959496969392998D8B97959494959699929C9292A19091
96A4918D94A1898F8F9C959892969696949595908C9E9294929E9B8A999795979894939B
9596959A92969690999B918E8C99A08485B7BD33
D492909294A19793929A949698939A97939B938E9D9A9A8F9492928C9696939890949596
959494998E908F8E8E91949695959596969493979A99969595949495998F999193919E90
96959F8B81A79E889D9C9487A09596969596969F9A9C93959593909A9594959797959498
8F93988F949695929191A19A97A59F887DACBF32
D29291908F9C938F9D9692959890969391988F999694969A8D9D8D99969692959B919697
9693939B9498989897969695959696959595969594949596969593959A8E959D918F9C90
97959D8A8EB092809C9D95869E939495959695918D9E93969796939A9392949494949594
97919C94979695969797948B96949E8A