(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    240942,       6883]*)
(*NotebookOutlinePosition[    241614,       6907]*)
(*  CellTagsIndexPosition[    241570,       6903]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Utilities`MemoryConserve`\n$MemoryIncrement; 
    \n<< \ LinearAlgebra`MatrixManipulation`; \n
    Off[General::spell1, MemoryConserve::start, MemoryConserve::end]; \)], 
  "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ \ Normalization\)], "Input"],

Cell[BoxData[
    \(\(imageNormalize = 
      Compile[{{data2D, _Real, 2}}, \n\t\t
        Module[{minimum = Min[data2D]}, \n\t\t\t
          \((data2D - minimum)\)/Max[data2D - minimum]]]; \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Round\ Window\)], "Input"],

Cell["\<\
roundWin=Compile[{{xOrigin,_Integer},{yOrigin,_Integer},
\t{radius,_Integer},{dataMatrix, _Real, 2}},
\tModule[{i=0,j=0,k=0,win={{0.}},dim={0}},
\t\tdim=Table[Dimensions[dataMatrix][[i]],{i,2}];
\t\twin=Table[0.,{dim[[1]]},{dim[[2]]}];
\t\tDo[
\t\t\tj=Round[Sqrt[radius^2-i^2]];
\t\t\tDo[win[[yOrigin+i,k]]=1.,
\t\t\t{k,xOrigin-j,xOrigin+j}],
\t\t{i,-radius,radius}];
\t\twin dataMatrix]];\
\>", "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ \ Fourier - Wavelet\ transform\)], "Input"],

Cell["\<\
fourierWavelet[sample_,test_,base_]:=
\tModule[{n,m,wMatrix,varyPartSpect,partSpect,testFourier},
\t\tn=Length[sample];
\t\tm=Ceiling[Log[2.,Length[Transpose[base]]]]-1;
\t\twMatrix=waveletMatrix[n,base];
\t\ttestFourier=Fourier[test];
\t\tvaryPartSpect=
\t\t\twMatrix.Re[InverseFourier[
\t\t\t\t(imageNormalize[Abs[testFourier]]-
\t\t\t\t\timageNormalize[Abs[Fourier[sample]]])*
\t\t\t\t\ttestFourier]].Transpose[wMatrix];
\t\tpartSpect=ZeroMatrix[n];
\t\tDo[partSpect[[i,j]]=varyPartSpect[[i,j]],{i,2^m},{j,2^m}];
\t\troundWin[n/2,n/2,(n/2)-3,
\t\t\timageNormalize[Transpose[wMatrix].partSpect.wMatrix]]
\t];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[BoxData[
    StyleBox[\(Daubechies : \),
      FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
      FontWeight->"Bold",
      FontVariations->{"Underline"->True}]], "Input"],

Cell[BoxData[
    \(\(daub2 = {{1. , 1. }, {1. , \(-1. \)}}/Sqrt[2. ]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(coif6 = {{\(- .051429728471\), \  .238929728471, \  .602859456942, \ 
            \n\ \t\t\  .272140543058, \(- .051429972847\), 
            \(- .011070271529\)}, \n
          \ \t\ \ \ {\(- .011070271529\), \  .051429972847, \  .272140543058, 
            \n\t\t\(- .602859456942\), \  .238929728471, \  .051429728471}}*\n
        \t\tSqrt[2. ]; \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    \(\[FilledSquare]\ Sample\ Data\)], "Input"],

Cell[BoxData[
    \(\(a = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 
          0, 0, 0, 1}, {1, 1, 1, 1, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 1, 0, 1}, {
          0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 1, 0, 0
          \ , 0, 1}}; \)\)], "Input"],

Cell[BoxData[
    \(\(b = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 
          0, 0, 0, 1}, {1, 1, 1, 0, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 1, 0, 1}, {
          0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 1, 0, 0
          \ , 0, 1}}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[a, Mesh -> False], 
          ListDensityPlot[b, Mesh -> False]}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFF0000FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{543, 258.5},
  ImageMargins->{{43, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008O00010QP00`40o`000?l0003ooooooooooolQ
oooo003oooooooooob7oool00?oooooooooo8Oooo`00oooooooooolQoooo003oooooooooob7oool0
0?oooooooooo8Oooo`00oooooooooolQoooo000Koooo00<0003oooooool0=?ooo`<0000foooo0`00
03Goool20000=oooo`030000oooooooo02[oool00`000?ooooooo`0doooo0`0003Koool30000=?oo
o`80000goooo00<0003oooooool04oooo`006_ooo`030000oooo000003Goool00`000?ooooooo`0g
oooo00<0003oooooool0=?ooo`030000oooo000003Goool00`000?ooo`00000Zoooo00<0003oool0
0000=Oooo`030000oooooooo03Ooool00`000?ooooooo`0coooo00<0003oool00000=Oooo`030000
oooo000001Coool001[oool00`000?ooo`00000foooo00<0003oooooool0=?ooo`@0000eoooo00<0
003oool00000=Oooo`030000oooo000002[oool00`000?ooo`00000foooo00<0003oooooool0=?oo
o`@0000doooo00<0003oool00000=Oooo`030000oooo000001Coool001[oool00`000?ooo`00000f
oooo00<0003oooooool0=?ooo`030000oooo000003Koool20000=oooo`030000oooooooo02Woool0
0`000?ooo`00000foooo00<0003oooooool0=?ooo`030000oooo000003Goool20000=oooo`030000
oooooooo01?oool001[oool00`000?ooo`00000eoooo00<0003oool00000=_ooo`80000foooo00<0
003oooooool0=Oooo`030000oooo000002[oool00`000?ooo`00000eoooo00<0003oool00000=_oo
o`80000eoooo00<0003oooooool0=Oooo`030000oooo000001Coool001_oool00`000?ooooooo`0e
oooo00<0003oooooool0=_ooo`030000oooooooo03Goool20000=_ooo`030000oooooooo02[oool0
0`000?ooooooo`0eoooo00<0003oooooool0=_ooo`030000oooooooo03Coool20000=_ooo`030000
oooooooo01?oool00?oooooooooo8Oooo`00oooooooooolQoooo003oooooooooob7oool00?oooooo
oooo8Oooo`00oooooooooolQoooo000Gooooj`0002?ooooZ00004?ooo`005oooo`030000oooooooo
00;oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?oo
ooooo`0;oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0
003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02ooo
o`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo
00_oool00`000?ooooooo`0;oooo00<0003oooooool00_ooo`030000oooooooo027oool00`000?oo
ooooo`02oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0
003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02ooo
o`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo
00_oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?oo
ooooo`0;oooo00<0003oooooool02oooo`050000oooooooooooo0000013oool001Ooool00`000?oo
ooooo`02oooo00<0003oooooool0=Oooo`030000oooooooo03Goool00`000?ooooooo`0eoooo00<0
003oooooool0=Oooo`030000oooooooo00;oool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo03Goool00`000?ooooooo`0eoooo00<0003oooooool0=Oooo`030000oooooooo
03Goool01@000?ooooooooooo`00000@oooo000Aoooo00<0003oooooool00oooo`030000oooooooo
0>Ooool00`000?ooooooo`0Koooo00<0003oooooool00oooo`030000oooooooo0>Koool00`000?oo
ooooo`0>oooo000@oooo00<0003oool000001?ooo`030000oooooooo0>Ooool00`000?ooooooo`0J
oooo00<0003oool000001?ooo`030000oooooooo0>Koool00`000?ooooooo`0>oooo000@oooo00<0
003oool000001?ooo`<0003Uoooo0`0001coool00`000?ooo`000004oooo0`000>Goool200004?oo
o`004?ooo`030000oooo000000Coool00`000?ooooooo`0Noooo700003SooomD00008Oooo`030000
oooooooo01[oool00`000?ooo`000004oooo00<0003oooooool07_oooa`0000hooooE000023oool0
0`000?ooooooo`0>oooo000@oooo00<0003oool000001?ooo`030000oooooooo01kooolL0000>?oo
oe@0000Qoooo00<0003oooooool06_ooo`030000oooo000000Coool00`000?ooooooo`0Noooo7000
03SooomD00008?ooo`030000oooooooo00koool0017oool00`000?ooooooo`03oooo00<0003ooooo
ool07_oooa`0000hooooE000027oool00`000?ooooooo`0Koooo00<0003oooooool00oooo`030000
oooooooo01kooolL0000>?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
01kooolL0000>?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo01kooolL0000>?oo
oe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo01kooolL0000>?oooe@0000Q
oooo00<0003oooooool08Oooo`030000oooooooo01kooolL0000>?oooe@0000Poooo00<0003ooooo
ool03_ooo`005oooo`030000oooooooo01kooolL0000>?oooe@0000Qoooo00<0003oooooool08Ooo
o`030000oooooooo01kooolL0000>?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000
oooooooo01kooolL0000>?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo01kooolL
0000>?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo01kooolL0000>?oo
oe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo01kooolL0000>?oooe@0000Poooo00<0
003oooooool03_ooo`005oooo`030000oooooooo01kooolL0000>?oooe@0000Qoooo00<0003ooooo
ool08Oooo`030000oooooooo01kooolL0000>?oooe@0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo01kooolL0000>?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo
01kooolL0000>?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo01kooolL
0000>?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo01kooolL0000>?oooe@0000P
oooo00<0003oooooool03_ooo`005oooo`030000oooooooo01kooolL0000>?oooe@0000Qoooo00<0
003oooooool08Oooo`030000oooooooo01kooolL0000>?oooe@0000Poooo00<0003oooooool03_oo
o`005oooo`030000oooooooo01kooolL0000>?oooe@0000Qoooo00<0003oooooool08Oooo`030000
oooooooo01kooolL0000>?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`80000Ooooo7000
03SooomD00008?ooo`80000Soooo0P0001oooolL0000>?oooe@0000Ooooo0P00013oool001Ooool0
0`000?ooooooo`0Noooo700003SooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0N
oooo700003SooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0Noooo7000
03SooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0Noooo700003SooomD00008?oo
o`030000oooooooo00koool001Ooool00`000?ooooooo`0Noooo700003SooomD00008Oooo`030000
oooooooo027oool00`000?ooooooo`0Noooo700003SooomD00008?ooo`030000oooooooo00koool0
01Ooool00`000?ooooooo`0Noooo700003SooomD00008Oooo`030000oooooooo027oool00`000?oo
ooooo`0Noooo700003SooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0N
oooo700003SooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0Noooo700003SooomD
00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0Noooo700003SooomD00008Ooo
o`030000oooooooo027oool00`000?ooooooo`0Noooo700003SooomD00008?ooo`030000oooooooo
00koool001Ooool00`000?ooooooo`0Noooo700003SooomD00008Oooo`030000oooooooo027oool0
0`000?ooooooo`0Noooo700003SooomD00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`0Noooo700003SooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0Noooo7000
03SooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0Noooo700003SooomD
00008Oooo`030000oooooooo027oool00`000?ooooooo`0Noooo700003SooomD00008?ooo`030000
oooooooo00koool001Ooool00`000?ooooooo`0Noooo700003SooomD00008Oooo`030000oooooooo
027oool00`000?ooooooo`0Noooo700003SooomD00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`0Noooo700003SooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0N
oooo700003SooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0Noooo7000
03SooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0Noooo700003SooomD00008?oo
o`030000oooooooo00koool001Ooool00`000?ooooooo`0Noooo700003SooomD00008Oooo`030000
oooooooo027oool00`000?ooooooo`0Noooo700003SooomD00008?ooo`030000oooooooo00koool0
01Ooool200007ooooa`0000hooooE000023oool200008oooo`80000Ooooo700003SooomD00007ooo
o`80000@oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Q
oooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
ocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`
oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool0
0`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?oo
ooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000G
oooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003ooooo
ool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_oo
ocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000
023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool0
0`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>
oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0
003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`
oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000
027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?oo
ooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Q
oooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
ocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`
oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool0
0`000?ooooooo`0>oooo000Goooo0P0000?ooolh0000L?oooa`0000Poooo0P0002?oool200000ooo
ocP0001`oooo700001ooool200004?ooo`005oooo`030000oooooooo00;ooolh0000L?oooa`0000Q
oooo00<0003oooooool08Oooo`030000oooooooo00;ooolh0000L?oooa`0000Poooo00<0003ooooo
ool03_ooo`005oooo`030000oooooooo00;ooolh0000L?oooa`0000Qoooo00<0003oooooool08Ooo
o`030000oooooooo00;ooolh0000L?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000
oooooooo00;ooolh0000L?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo00;ooolh
0000L?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo00;ooolh0000L?oo
oa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo00;ooolh0000L?oooa`0000Poooo00<0
003oooooool03_ooo`005oooo`030000oooooooo00;ooolh0000L?oooa`0000Qoooo00<0003ooooo
ool08Oooo`030000oooooooo00;ooolh0000L?oooa`0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo00;ooolh0000L?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo
00;ooolh0000L?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo00;ooolh
0000L?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo00;ooolh0000L?oooa`0000P
oooo00<0003oooooool03_ooo`005oooo`030000oooooooo00;ooolh0000L?oooa`0000Qoooo00<0
003oooooool08Oooo`030000oooooooo00;ooolh0000L?oooa`0000Poooo00<0003oooooool03_oo
o`005oooo`030000oooooooo00;ooolh0000L?oooa`0000Qoooo00<0003oooooool08Oooo`030000
oooooooo00;ooolh0000L?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
00;ooolh0000L?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo00;ooolh0000L?oo
oa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo00;ooolh0000L?oooa`0000Q
oooo00<0003oooooool08Oooo`030000oooooooo00;ooolh0000L?oooa`0000Poooo00<0003ooooo
ool03_ooo`004?ooo`<00004oooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?oo
ooooo`0Joooo0`0000Coool00`000?ooooooo`02oooo>000073ooolL00008?ooo`030000oooooooo
00koool0013oool00`000?ooooooo`04oooo00<0003oooooool00_ooocP0001`oooo7000027oool0
0`000?ooooooo`0Joooo00<0003oooooool01?ooo`030000oooooooo00;ooolh0000L?oooa`0000P
oooo00<0003oooooool03_ooo`004Oooo`030000oooooooo00?oool300000_ooocP0001`oooo7000
01ooool300007Oooo`030000oooooooo00?oool300000_ooocP0001`oooo700001ooool200004?oo
o`004Oooo`030000oooooooo00?oool00`000?ooooooo`0joooo700001cooomD00008Oooo`030000
oooooooo01_oool00`000?ooooooo`03oooo00<0003oooooool0>_oooa`0000LooooE000023oool0
0`000?ooooooo`0>oooo000@oooo00<0003oool000001?ooo`030000oooooooo03[ooolL00007?oo
oe@0000Qoooo00<0003oooooool06_ooo`030000oooo000000Coool00`000?ooooooo`0joooo7000
01cooomD00008?ooo`030000oooooooo00koool0017oool00`000?ooooooo`03oooo00<0003ooooo
ool0>_oooa`0000LooooE000027oool00`000?ooooooo`0Koooo00<0003oooooool00oooo`030000
oooooooo03[ooolL00007?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
03[ooolL00007?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo03[ooolL00007?oo
oe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo03[ooolL00007?oooe@0000Q
oooo00<0003oooooool08Oooo`030000oooooooo03[ooolL00007?oooe@0000Poooo00<0003ooooo
ool03_ooo`005oooo`030000oooooooo03[ooolL00007?oooe@0000Qoooo00<0003oooooool08Ooo
o`030000oooooooo03[ooolL00007?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000
oooooooo03[ooolL00007?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo03[ooolL
00007?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo03[ooolL00007?oo
oe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo03[ooolL00007?oooe@0000Poooo00<0
003oooooool03_ooo`005oooo`030000oooooooo03[ooolL00007?oooe@0000Qoooo00<0003ooooo
ool08Oooo`030000oooooooo03[ooolL00007?oooe@0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo03[ooolL00007?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo
03[ooolL00007?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo03[ooolL
00007?oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo03[ooolL00007?oooe@0000P
oooo00<0003oooooool03_ooo`005oooo`030000oooooooo03[ooolL00007?oooe@0000Qoooo00<0
003oooooool08Oooo`030000oooooooo03[ooolL00007?oooe@0000Poooo00<0003oooooool03_oo
o`005oooo`030000oooooooo03[ooolL00007?oooe@0000Qoooo00<0003oooooool08Oooo`030000
oooooooo03[ooolL00007?oooe@0000Poooo00<0003oooooool03_ooo`005oooo`80000koooo7000
01cooomD00008?ooo`80000Soooo0P0003_ooolL00007?oooe@0000Ooooo0P00013oool001Ooool0
0`000?ooooooo`0joooo700001cooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0j
oooo700001cooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0joooo7000
01cooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0joooo700001cooomD00008?oo
o`030000oooooooo00koool001Ooool00`000?ooooooo`0joooo700001cooomD00008Oooo`030000
oooooooo027oool00`000?ooooooo`0joooo700001cooomD00008?ooo`030000oooooooo00koool0
01Ooool00`000?ooooooo`0joooo700001cooomD00008Oooo`030000oooooooo027oool00`000?oo
ooooo`0joooo700001cooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0j
oooo700001cooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0joooo700001cooomD
00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0joooo700001cooomD00008Ooo
o`030000oooooooo027oool00`000?ooooooo`0joooo700001cooomD00008?ooo`030000oooooooo
00koool001Ooool00`000?ooooooo`0joooo700001cooomD00008Oooo`030000oooooooo027oool0
0`000?ooooooo`0joooo700001cooomD00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`0joooo700001cooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0joooo7000
01cooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0joooo700001cooomD
00008Oooo`030000oooooooo027oool00`000?ooooooo`0joooo700001cooomD00008?ooo`030000
oooooooo00koool001Ooool00`000?ooooooo`0joooo700001cooomD00008Oooo`030000oooooooo
027oool00`000?ooooooo`0joooo700001cooomD00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`0joooo700001cooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0j
oooo700001cooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0joooo7000
01cooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`0joooo700001cooomD00008?oo
o`030000oooooooo00koool001Ooool00`000?ooooooo`0joooo700001cooomD00008Oooo`030000
oooooooo027oool00`000?ooooooo`0joooo700001cooomD00008?ooo`030000oooooooo00koool0
01Ooool20000>ooooa`0000LooooE000023oool200008oooo`80000koooo700001cooomD00007ooo
o`80000@oooo000Goooo00<0003oooooool0L_oooa`0000Loooo>00000Goool00`000?ooooooo`0Q
oooo00<0003oooooool0E_ooocP0000Loooo>00000Coool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool0L_oooa`0000Loooo>00000Goool00`000?ooooooo`0Qoooo00<0003oooooool0E_oo
ocP0000Loooo>00000Coool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooa`0000L
oooo>00000Goool00`000?ooooooo`0Qoooo00<0003oooooool0E_ooocP0000Loooo>00000Coool0
0`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooa`0000Loooo>00000Goool00`000?oo
ooooo`0Qoooo00<0003oooooool0E_ooocP0000Loooo>00000Coool00`000?ooooooo`0>oooo000G
oooo00<0003oooooool0L_oooa`0000Loooo>00000Goool00`000?ooooooo`0Qoooo00<0003ooooo
ool0E_ooocP0000Loooo>00000Coool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oo
oa`0000Loooo>00000Goool00`000?ooooooo`0Qoooo00<0003oooooool0E_ooocP0000Loooo>000
00Coool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooa`0000Loooo>00000Goool0
0`000?ooooooo`0Qoooo00<0003oooooool0E_ooocP0000Loooo>00000Coool00`000?ooooooo`0>
oooo000Goooo00<0003oooooool0L_oooa`0000Loooo>00000Goool00`000?ooooooo`0Qoooo00<0
003oooooool0E_ooocP0000Loooo>00000Coool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool0L_oooa`0000Loooo>00000Goool00`000?ooooooo`0Qoooo00<0003oooooool0E_ooocP0000L
oooo>00000Coool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooa`0000Loooo>000
00Goool00`000?ooooooo`0Qoooo00<0003oooooool0E_ooocP0000Loooo>00000Coool00`000?oo
ooooo`0>oooo000Goooo00<0003oooooool0L_oooa`0000Loooo>00000Goool00`000?ooooooo`0Q
oooo00<0003oooooool0E_ooocP0000Loooo>00000Coool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool0L_oooa`0000Loooo>00000Goool00`000?ooooooo`0Qoooo00<0003oooooool0E_oo
ocP0000Loooo>00000Coool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooa`0000L
oooo>00000Goool00`000?ooooooo`0Qoooo00<0003oooooool0E_ooocP0000Loooo>00000Coool0
0`000?ooooooo`0>oooo000Goooo0P0007?ooolL00007?ooocP00004oooo0P0002?oool20000Eooo
ocP0000Loooo>00000?oool200004?ooo`005oooo`030000oooooooo07;ooolL00007?ooocP00005
oooo00<0003oooooool08Oooo`030000oooooooo05Kooolh00007?ooocP00004oooo00<0003ooooo
ool03_ooo`005oooo`030000oooooooo07;ooolL00007?ooocP00005oooo00<0003oooooool08Ooo
o`030000oooooooo05Kooolh00007?ooocP00004oooo00<0003oooooool03_ooo`005oooo`030000
oooooooo07;ooolL00007?ooocP00005oooo00<0003oooooool08Oooo`030000oooooooo05Kooolh
00007?ooocP00004oooo00<0003oooooool03_ooo`005oooo`030000oooooooo07;ooolL00007?oo
ocP00005oooo00<0003oooooool08Oooo`030000oooooooo05Kooolh00007?ooocP00004oooo00<0
003oooooool03_ooo`005oooo`030000oooooooo07;ooolL00007?ooocP00005oooo00<0003ooooo
ool08Oooo`030000oooooooo05Kooolh00007?ooocP00004oooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo07;ooolL00007?ooocP00005oooo00<0003oooooool08Oooo`030000oooooooo
05Kooolh00007?ooocP00004oooo00<0003oooooool03_ooo`005oooo`030000oooooooo07;ooolL
00007?ooocP00005oooo00<0003oooooool08Oooo`030000oooooooo05Kooolh00007?ooocP00004
oooo00<0003oooooool03_ooo`005oooo`030000oooooooo07;ooolL00007?ooocP00005oooo00<0
003oooooool08Oooo`030000oooooooo05Kooolh00007?ooocP00004oooo00<0003oooooool03_oo
o`005oooo`030000oooooooo07;ooolL00007?ooocP00005oooo00<0003oooooool08Oooo`030000
oooooooo05Kooolh00007?ooocP00004oooo00<0003oooooool03_ooo`005oooo`030000oooooooo
07;ooolL00007?ooocP00005oooo00<0003oooooool08Oooo`030000oooooooo05Kooolh00007?oo
ocP00004oooo00<0003oooooool03_ooo`005oooo`030000oooooooo07;ooolL00007?ooocP00005
oooo00<0003oooooool08Oooo`030000oooooooo05Kooolh00007?ooocP00004oooo00<0003ooooo
ool03_ooo`004Oooo`<00003oooo00<0003oooooool0L_oooa`0000Loooo>00000Goool00`000?oo
ooooo`0Koooo0`0000?oool00`000?ooooooo`1Foooo>00001cooolh00001?ooo`030000oooooooo
00koool001;oool00`000?ooooooo`02oooo00<0003oooooool0L_oooa`0000Loooo>00000Goool0
0`000?ooooooo`0Loooo00<0003oooooool00_ooo`030000oooooooo05Kooolh00007?ooocP00004
oooo00<0003oooooool03_ooo`004?ooo`@00003oooo0`0007;ooolL00007?ooocP00003oooo0`00
01coool400000oooo`<0001Foooo>00001cooolh00000oooo`80000@oooo000@oooo00<0003oool0
00001?ooo`030000oooooooo01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0J
oooo00<0003oool000001?ooo`030000oooooooo01kooolL0000>?oooa`0000Loooo7000023oool0
0`000?ooooooo`0>oooo000Aoooo0P0000Coool00`000?ooooooo`0Noooo700003SooolL00007?oo
oa`0000Qoooo00<0003oooooool06oooo`800004oooo00<0003oooooool07_oooa`0000hoooo7000
01cooolL00008?ooo`030000oooooooo00koool001;oool00`000?ooooooo`02oooo00<0003ooooo
ool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo01coool00`000?ooooooo`02
oooo00<0003oooooool07_oooa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool0
01Ooool00`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Ooo
o`030000oooooooo01kooolL0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000G
oooo00<0003oooooool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo027oool0
0`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0
003oooooool07_oooa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000
oooooooo01kooolL0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo027oool00`000?oo
ooooo`0Noooo700003SooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000
oooooooo01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003ooooo
ool07_oooa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`0Noooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo
01kooolL0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`0N
oooo700003SooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool07_oo
oa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0N
oooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo01kooolL
0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo0P0001oooolL0000>?oo
oa`0000Loooo7000023oool200008oooo`80000Ooooo700003SooolL00007?oooa`0000Ooooo0P00
013oool001Ooool00`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Qoooo00<0003ooooo
ool08Oooo`030000oooooooo01kooolL0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>
oooo000Goooo00<0003oooooool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo
027oool00`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Poooo00<0003oooooool03_oo
o`005oooo`030000oooooooo01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0Q
oooo00<0003oooooool07_oooa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool0
01Ooool00`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Ooo
o`030000oooooooo01kooolL0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000G
oooo00<0003oooooool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo027oool0
0`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0
003oooooool07_oooa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`0Noooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000
oooooooo01kooolL0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo027oool00`000?oo
ooooo`0Noooo700003SooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000
oooooooo01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003ooooo
ool07_oooa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`0Noooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo
01kooolL0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool07_oooa`0000hoooo700001cooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`0N
oooo700003SooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
01kooolL0000>?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool07_oo
oa`0000hoooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0N
oooo700003SooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo01kooolL
0000>?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo0P0001oooolL0000>?oo
oa`0000Loooo7000023oool200008oooo`80000Ooooo700003SooolL00007?oooa`0000Ooooo0P00
013oool001Ooool00`000?ooooooo`02oooo>000073ooolL00008Oooo`030000oooooooo027oool0
0`000?ooooooo`02oooo>000073ooolL00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`02oooo>000073ooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`02oooo>000
073ooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`02oooo>000073ooolL
00008Oooo`030000oooooooo027oool00`000?ooooooo`02oooo>000073ooolL00008?ooo`030000
oooooooo00koool001Ooool00`000?ooooooo`02oooo>000073ooolL00008Oooo`030000oooooooo
027oool00`000?ooooooo`02oooo>000073ooolL00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`02oooo>000073ooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`02
oooo>000073ooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`02oooo>000
073ooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`02oooo>000073ooolL00008?oo
o`030000oooooooo00koool001Ooool00`000?ooooooo`02oooo>000073ooolL00008Oooo`030000
oooooooo027oool00`000?ooooooo`02oooo>000073ooolL00008?ooo`030000oooooooo00koool0
01Ooool00`000?ooooooo`02oooo>000073ooolL00008Oooo`030000oooooooo027oool00`000?oo
ooooo`02oooo>000073ooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`02
oooo>000073ooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`02oooo>000073ooolL
00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`02oooo>000073ooolL00008Ooo
o`030000oooooooo027oool00`000?ooooooo`02oooo>000073ooolL00008?ooo`030000oooooooo
00koool001Ooool00`000?ooooooo`02oooo>000073ooolL00008Oooo`030000oooooooo027oool0
0`000?ooooooo`02oooo>000073ooolL00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`02oooo>000073ooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`02oooo>000
073ooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`02oooo>000073ooolL
00008Oooo`030000oooooooo027oool00`000?ooooooo`02oooo>000073ooolL00008?ooo`030000
oooooooo00koool001Ooool200000oooocP0001`oooo7000023oool200008oooo`800003oooo>000
073ooolL00007oooo`80000@oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool0
0`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>
oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0
003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`
oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000
027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?oo
ooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Q
oooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
ocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`
oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool0
0`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?oo
ooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000G
oooo00<0003oooooool00_ooocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003ooooo
ool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_oo
ocP0001`oooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000
023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool00_ooocP0001`oooo7000027oool0
0`000?ooooooo`0Qoooo00<0003oooooool00_ooocP0001`oooo7000023oool00`000?ooooooo`0>
oooo000@oooo0P0000Goool00`000?ooooooo`02oooo>000073ooolL00008Oooo`030000oooooooo
01[oool200001Oooo`030000oooooooo00;ooolh0000L?oooa`0000Poooo00<0003oooooool03_oo
o`004?ooo`030000oooo000000Coool00`000?ooooooo`02oooo>000073ooolL00008Oooo`030000
oooooooo01[oool00`000?ooo`000004oooo00<0003oooooool00_ooocP0001`oooo7000023oool0
0`000?ooooooo`0>oooo000@oooo00<0003oool000001?ooo`<00002oooo>000073ooolL00007ooo
o`<0000Loooo00<0003oool000001?ooo`<00002oooo>000073ooolL00007oooo`80000@oooo000@
oooo0P0000Goool00`000?ooooooo`0joooo700001cooolL00007?oooa`0000Qoooo00<0003ooooo
ool06_ooo`800005oooo00<0003oooooool0>_oooa`0000Loooo700001cooolL00008?ooo`030000
oooooooo00koool0013oool00`000?ooooooo`04oooo00<0003oooooool0>_oooa`0000Loooo7000
01cooolL00008Oooo`030000oooooooo01[oool00`000?ooooooo`04oooo00<0003oooooool0>_oo
oa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool0017oool200001?ooo`030000
oooooooo03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Koooo0P0000Coool0
0`000?ooooooo`0joooo700001cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0
003oooooool0>_oooa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`0joooo700001cooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000
oooooooo03[ooolL00007?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool0>_oooa`0000Loooo700001cooolL00008Oooo`030000oooooooo027oool00`000?oo
ooooo`0joooo700001cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000
oooooooo03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003ooooo
ool0>_oooa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`0joooo700001cooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo
03[ooolL00007?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool0>_oooa`0000Loooo700001cooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`0j
oooo700001cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool0>_oo
oa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0j
oooo700001cooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo03[ooolL
00007?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0>_oo
oa`0000Loooo700001cooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`0joooo7000
01cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo03[ooolL
00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool0>_oooa`0000L
oooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool20000>ooooa`0000Loooo7000
01cooolL00008?ooo`80000Soooo0P0003_ooolL00007?oooa`0000Loooo700001ooool200004?oo
o`005oooo`030000oooooooo03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Q
oooo00<0003oooooool0>_oooa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool0
01Ooool00`000?ooooooo`0joooo700001cooolL00007?oooa`0000Qoooo00<0003oooooool08Ooo
o`030000oooooooo03[ooolL00007?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000G
oooo00<0003oooooool0>_oooa`0000Loooo700001cooolL00008Oooo`030000oooooooo027oool0
0`000?ooooooo`0joooo700001cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0
003oooooool0>_oooa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`0joooo700001cooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000
oooooooo03[ooolL00007?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool0>_oooa`0000Loooo700001cooolL00008Oooo`030000oooooooo027oool00`000?oo
ooooo`0joooo700001cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000
oooooooo03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003ooooo
ool0>_oooa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`0joooo700001cooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo
03[ooolL00007?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool0>_oooa`0000Loooo700001cooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`0j
oooo700001cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
03[ooolL00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool0>_oo
oa`0000Loooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`0j
oooo700001cooolL00007?oooa`0000Qoooo00<0003oooooool08Oooo`030000oooooooo03[ooolL
00007?oooa`0000Loooo7000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0>_oo
oa`0000Loooo700001cooolL00008Oooo`030000oooooooo027oool00`000?ooooooo`0joooo7000
01cooolL00007?oooa`0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo03[ooolL
00007?oooa`0000Loooo7000027oool00`000?ooooooo`0Qoooo00<0003oooooool0>_oooa`0000L
oooo700001cooolL00008?ooo`030000oooooooo00koool001Ooool20000>ooooa`0000Loooo7000
01cooolL00008?ooo`80000Soooo0P0003_ooolL00007?oooa`0000Loooo700001ooool200004?oo
o`005oooo`030000oooooooo07;ooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`1b
ooooE000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooe@0000Qoooo00<0
003oooooool08Oooo`030000oooooooo07;ooomD00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`1booooE000027oool00`000?ooooooo`0Qoooo00<0003oooooool0L_oooe@0000P
oooo00<0003oooooool03_ooo`005oooo`030000oooooooo07;ooomD00008Oooo`030000oooooooo
027oool00`000?ooooooo`1booooE000023oool00`000?ooooooo`0>oooo000Goooo00<0003ooooo
ool0L_oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo07;ooomD00008?ooo`030000
oooooooo00koool001Ooool00`000?ooooooo`1booooE000027oool00`000?ooooooo`0Qoooo00<0
003oooooool0L_oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo07;ooomD
00008Oooo`030000oooooooo027oool00`000?ooooooo`1booooE000023oool00`000?ooooooo`0>
oooo000Goooo00<0003oooooool0L_oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo
07;ooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`1booooE000027oool0
0`000?ooooooo`0Qoooo00<0003oooooool0L_oooe@0000Poooo00<0003oooooool03_ooo`005ooo
o`030000oooooooo07;ooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`1booooE000
023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooe@0000Qoooo00<0003ooooo
ool08Oooo`030000oooooooo07;ooomD00008?ooo`030000oooooooo00koool001Ooool00`000?oo
ooooo`1booooE000027oool00`000?ooooooo`0Qoooo00<0003oooooool0L_oooe@0000Poooo00<0
003oooooool03_ooo`005oooo`030000oooooooo07;ooomD00008Oooo`030000oooooooo027oool0
0`000?ooooooo`1booooE000023oool00`000?ooooooo`0>oooo000Goooo0P0007?ooomD00008?oo
o`80000Soooo0P0007?ooomD00007oooo`80000@oooo000Goooo00<0003oooooool0L_oooe@0000Q
oooo00<0003oooooool08Oooo`030000oooooooo07;ooomD00008?ooo`030000oooooooo00koool0
01Ooool00`000?ooooooo`1booooE000027oool00`000?ooooooo`0Qoooo00<0003oooooool0L_oo
oe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo07;ooomD00008Oooo`030000
oooooooo027oool00`000?ooooooo`1booooE000023oool00`000?ooooooo`0>oooo000Goooo00<0
003oooooool0L_oooe@0000Qoooo00<0003oooooool08Oooo`030000oooooooo07;ooomD00008?oo
o`030000oooooooo00koool001Ooool00`000?ooooooo`1booooE000027oool00`000?ooooooo`0Q
oooo00<0003oooooool0L_oooe@0000Poooo00<0003oooooool03_ooo`005oooo`030000oooooooo
07;ooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`1booooE000023oool00`000?oo
ooooo`0>oooo000Goooo00<0003oooooool0L_oooe@0000Qoooo00<0003oooooool08Oooo`030000
oooooooo07;ooomD00008?ooo`030000oooooooo00koool001Ooool00`000?ooooooo`1booooE000
027oool00`000?ooooooo`0Qoooo00<0003oooooool0L_oooe@0000Poooo00<0003oooooool03_oo
o`005oooo`030000oooooooo07;ooomD00008Oooo`030000oooooooo027oool00`000?ooooooo`1b
ooooE000023oool00`000?ooooooo`0>oooo000Goooo00<0003oooooool0L_oooe@0000Qoooo00<0
003oooooool08Oooo`030000oooooooo07;ooomD00008?ooo`030000oooooooo00koool001Ooool0
0`000?ooooooo`1booooE000027oool00`000?ooooooo`0Qoooo00<0003oooooool0L_oooe@0000P
oooo00<0003oooooool03_ooo`004Oooo`030000oooooooo00?oool00`000?ooooooo`1booooE000
027oool00`000?ooooooo`0Koooo00<0003oooooool00oooo`030000oooooooo07;ooomD00008?oo
o`030000oooooooo00koool0013oool00`000?ooo`000004oooo00<0003oooooool0L_oooe@0000Q
oooo00<0003oooooool06_ooo`030000oooo000000Coool00`000?ooooooo`1booooE000023oool0
0`000?ooooooo`0>oooo000@oooo00<0003oool000001?ooo`<0001booooE00001ooool300007?oo
o`030000oooo000000Coool30000L_oooe@0000Ooooo0P00013oool0017oool00`000?ooooooo`03
oooo00<0003oooooool0ioooo`030000oooooooo01_oool00`000?ooooooo`03oooo00<0003ooooo
ool0i_ooo`030000oooooooo00koool0013oool00`000?ooo`000004oooo00<0003oooooool0iooo
o`030000oooooooo01[oool00`000?ooo`000004oooo00<0003oooooool0i_ooo`030000oooooooo
00koool0017oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo00_oool0
0`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;
oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003ooooo
ool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000
oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo00_oool0
0`000?ooooooo`02oooo00<0003oooooool06oooo`030000oooooooo00?oool00`000?ooooooo`02
oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003ooooo
ool02oooo`030000oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000
oooooooo00_oool00`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo00_oool0
0`000?ooooooo`0;oooo00<0003oooooool02oooo`030000oooooooo00_oool00`000?ooooooo`0;
oooo00<0003oooooool02oooo`050000oooooooooooo0000013oool001Ooooo[00008oooonX0000@
oooo003oooooooooob7oool00?oooooooooo8Oooo`00oooooooooolQoooo003oooooooooob7oool0
0?oooooooooo8Oooo`00oooooooooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 542}, {257.5, 0}} -> {-0.0524367, -0.0238146, 
  0.00388353, 0.00388353}, {{13.5, 258.688}, {251.313, 
  6.125}} -> {-1.01113, -0.805768, 0.0356692, 0.0356692}, {{283.25, 
  528.438}, {251.313, 6.125}} -> {-10.6329, -0.805768, 0.0356692, 0.0356692}}],\


Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fourierWavelet[a, b, coif6]\)], "Input"],

Cell[BoxData[
    \({{0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.`, 0.`, 
        0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.376522164874519171`, 0.`, 0.`, 0.`, 
        0.`}, {0.`, 0.`, 0.215751606361998193`, 0.301982104417293495`, 
        0.371865165402880437`, 0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 
        0.214317557463480889`, 0.`, 0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.`, 0.`, 
        0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`}, {0.`, 0.`, 
        0.`, 0.`, 0.`, 0.`, 0.`, 0.`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(c = 
      ListDensityPlot[\n\tdaub20out = fourierWavelet[a, b, coif6], \n\t\t
        Mesh -> False, PlotLabel -> "\<difference\>", \n\t\t
        DisplayFunction -> Identity]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[a, Mesh -> False], 
          ListDensityPlot[b, Mesh -> False], c}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFF0000FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -32 0 ]
[.5 1.0125 32 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -93 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(difference) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000000000
0000000000000000
000000FF00000000
000092CDFC000000
0000009100000000
0000000000000000
0000000000000000
0000000000000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{593, 185.313},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009A0000^AP00`40o`000?l0003ooooooooooomC
oooo003ooooooooooe?oool00?ooooooooooDoooo`00oooooooooomCoooo003ooooooooooe?oool0
0?ooooooooooDoooo`006oooo`030000oooooooo02Coool300009Oooo`<0000Soooo0P0002Koool0
0`000?ooooooo`0Roooo00<0003oooooool08oooo`<0000Uoooo0`0002?oool200009_ooo`030000
oooooooo02Soool00`000?ooooooo`0Poooo0`0002;oool300008?ooo`80000Soooo00<0003ooooo
ool06_ooo`006_ooo`030000oooo000002Goool00`000?ooooooo`0Voooo00<0003oooooool08_oo
o`030000oooo000002Coool00`000?ooo`00000Roooo00<0003oool000009?ooo`030000oooooooo
02Koool00`000?ooooooo`0Roooo00<0003oool000009?ooo`030000oooo000002Soool00`000?oo
o`00000Qoooo00<0003oooooool08oooo`030000oooooooo01ooool00`000?ooo`00000Qoooo00<0
003oool000006oooo`006_ooo`030000oooo000002Koool00`000?ooooooo`0Soooo100002?oool0
0`000?ooo`00000Toooo00<0003oool000008_ooo`030000oooo000002Goool00`000?ooooooo`0S
oooo100002?oool00`000?ooo`00000Toooo00<0003oool00000:?ooo`030000oooo000002;oool0
0`000?ooooooo`0Poooo1000023oool00`000?ooo`00000Qoooo00<0003oool000006oooo`006_oo
o`030000oooo000002Koool00`000?ooooooo`0Soooo00<0003oool000009?ooo`80000Voooo00<0
003oooooool08Oooo`030000oooo000002Goool00`000?ooooooo`0Soooo00<0003oool000009?oo
o`80000Voooo00<0003oooooool09oooo`030000oooo000002;oool00`000?ooooooo`0Poooo00<0
003oool000008Oooo`80000Soooo00<0003oooooool06_ooo`006_ooo`030000oooo000002Goool0
0`000?ooo`00000Uoooo0P0002Coool00`000?ooooooo`0Toooo00<0003oool000008_ooo`030000
oooo000002Coool00`000?ooo`00000Uoooo0P0002Coool00`000?ooooooo`0Toooo00<0003oool0
0000:?ooo`030000oooo0000027oool00`000?ooo`00000Roooo0P00027oool00`000?ooooooo`0Q
oooo00<0003oool000006oooo`006oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0
003oooooool08oooo`80000Uoooo00<0003oooooool08_ooo`030000oooooooo02Coool00`000?oo
ooooo`0Uoooo00<0003oooooool08oooo`80000Uoooo00<0003oooooool0:?ooo`030000oooooooo
027oool00`000?ooooooo`0Roooo00<0003oooooool08?ooo`80000Roooo00<0003oooooool06_oo
o`00oooooooooomCoooo003ooooooooooe?oool00?ooooooooooDoooo`00oooooj?ooonF00006Ooo
o`006Ooooj@0000MooooY00001ooool00`000?ooooooo`02oooo00<0003oool000002?ooo`030000
oooooooo00Koool00`000?ooooooo`06oooo00<0003oooooool01_ooo`030000oooooooo00Koool0
0`000?ooooooo`06oooo00<0003oooooool01_ooo`030000oooooooo00Koool00`000?ooooooo`06
oooo00<0003oooooool01_ooo`030000oooooooo00Koool00`000?ooooooo`06oooo00<0003ooooo
ool01_ooo`030000oooooooo00Koool00`000?ooooooo`06oooo00<0003oooooool01_ooo`040000
oooooooo00006Oooo`005?ooo`030000oooooooo00;oool010000?ooooooo`0002Koool00`000?oo
ooooo`0Toooo00<0003oooooool09Oooo`030000oooooooo02Coool010000?ooooooo`0001Soool0
0`000?ooooooo`02oooo00@0003oooooool0000Voooo00<0003oooooool09?ooo`030000oooooooo
02Goool00`000?ooooooo`0Toooo00@0003oooooool0000Noooo00<0003oool000000oooo`030000
oooooooo09;oool00`000?ooooooo`0Goooo000Coooo00<0003oool000000oooo`030000oooooooo
0:3oool00`000?ooooooo`0Eoooo00<0003oool000000oooo`030000oooooooo0:3oool00`000?oo
ooooo`0Loooo00<0003oool000000oooo`030000oooooooo097oool200006Oooo`004oooo`030000
oooo000000?oool20000X?ooo`80000Goooo00<0003oool000000oooo`80002Poooo0P0001koool0
0`000?ooo`000003oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Coooo00<0
003oool000000oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0003oooooool05Ooo
o`030000oooo000000?oool00`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo
01coool00`000?ooo`000003oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000C
oooo00<0003oool000000oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0003ooooo
ool05Oooo`030000oooo000000?oool00`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000
oooooooo01goool00`000?ooooooo`02oooo00<0003oool00000T00000;oool00`000?ooooooo`0G
oooo000Doooo00<0003oooooool00_ooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0
003oooooool05_ooo`030000oooooooo00;oool00`000?ooooooo`0Doooo4`0002Sooolj00005ooo
o`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool0
0`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo01_oool00`000?ooooooo`0D
oooo4`0002Sooolj00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000
oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo
01_oool00`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo02;oool00`000?oo
o`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`0002Sooolj
00005oooo`030000oooooooo01_oool00`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000
oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?oo
ooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo01_oool00`000?ooooooo`0Doooo4`00
02Sooolj00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo
01Ooool001Woool00`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo01_oool0
0`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo02;oool00`000?ooo`00002@
00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`0002Sooolj00005ooo
o`030000oooooooo01_oool00`000?ooooooo`0Doooo4`0002Sooolj00005oooo`030000oooooooo
02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0D
oooo4`0002Sooolj00005_ooo`80000Moooo00<0003oooooool05?oooa<0000Xoooo>P0001Koool2
00009?ooo`030000oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo
01CooolC0000:?ooocX0000Goooo00<0003oooooool06oooo`030000oooooooo01CooolC0000:?oo
ocX0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05ooo
o`006Oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0003oooooool06oooo`030000
oooooooo01CooolC0000:?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo000009000002
oooo00<0003oooooool05oooo`006Oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0
003oooooool06oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0003oooooool08_oo
o`030000oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo01CooolC
0000:?ooocX0000Goooo00<0003oooooool06oooo`030000oooooooo01CooolC0000:?ooocX0000G
oooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05oooo`006Ooo
o`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0003oooooool06oooo`030000oooooooo
01CooolC0000:?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0
003oooooool05oooo`006Oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0003ooooo
ool06oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0003oooooool08_ooo`030000
oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo01CooolC0000:?oo
ocX0000Goooo00<0003oooooool06oooo`030000oooooooo01CooolC0000:?ooocX0000Goooo00<0
003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000
oooooooo01CooolC0000:?ooocX0000Goooo00<0003oooooool06oooo`030000oooooooo01CooolC
0000:?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0003ooooo
ool05oooo`006Oooo`030000oooooooo01CooolC0000:?ooocX0000Foooo0P0001goool00`000?oo
ooooo`0Doooo4`0002Sooolj00005_ooo`80000Toooo00<0003oool00000T00000;oool00`000?oo
ooooo`0Goooo000Ioooo00<0003oooooool05?oooa<0000Xoooo>P0001Ooool00`000?ooooooo`0K
oooo00<0003oooooool05?oooa<0000Xoooo>P0001Ooool00`000?ooooooo`0Roooo00<0003oool0
0000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09`0004oooolC00005ooo
o`030000oooooooo01_oool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool08_oo
o`030000oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02L0001?
oooo4`0001Ooool00`000?ooooooo`0Koooo00<0003oooooool09`0004oooolC00005oooo`030000
oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?oo
ooooo`0W0000Cooooa<0000Goooo00<0003oooooool06oooo`030000oooooooo02L0001?oooo4`00
01Ooool00`000?ooooooo`0Roooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000I
oooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0W
0000Cooooa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0003ooooo
ool05oooo`006Oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Koooo00<0
003oooooool09`0004oooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_oo
o`030000oooooooo01Ooool001Woool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003ooooo
ool06oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool0
0000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09`0004oooolC00005ooo
o`030000oooooooo01_oool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool08_oo
o`030000oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02L0001?
oooo4`0001Ooool00`000?ooooooo`0Koooo00<0003oooooool09`0004oooolC00005oooo`030000
oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?oo
ooooo`0W0000Cooooa<0000Foooo0P0001goool00`000?ooooooo`0W0000Cooooa<0000Foooo0P00
02Coool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0W
0000Cooooa<0000Goooo00<0003oooooool06oooo`030000oooooooo02L0001?oooo4`0001Ooool0
0`000?ooooooo`0Roooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0
003oooooool09`0004oooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0W0000Cooo
oa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05ooo
o`006Oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Koooo00<0003ooooo
ool09`0004oooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000
oooooooo01Ooool001Woool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool06ooo
o`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Loooo0`0000?oool00`000?oo
o`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0W0000Cooooa<0000G
oooo00<0003oooooool06oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0L
oooo00<0003oooooool00oooo`030000oooo000009000002oooo00<0003oooooool05oooo`006Ooo
o`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Koooo00<0003oooooool09`00
04oooolC00005oooo`030000oooooooo01goool00`000?ooooooo`02oooo00<0003oool00000T000
0003oooo0000000001Woool001Woool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003ooooo
ool06oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Moooo00<0003ooooo
ool00_ooo`030000oooo000003D0000CooooB00000;oool00`000?ooooooo`0Goooo000Coooo0`00
00?oool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool05Oooo`<00003oooo00<0
003oooooool09`0004oooolC00005oooo`030000oooooooo01coool00`000?ooo`000003oooo00<0
003oool00000=@0001?ooom800000_ooo`030000oooooooo01Ooool001?oool00`000?ooooooo`03
oooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo01Goool00`000?ooooooo`03
oooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo01goool00`000?ooooooo`02
oooo00<0003oool00000=@0001?ooom800000_ooo`030000oooooooo01Ooool001Coool00`000?oo
ooooo`02oooo0P000003oooo0000000002D0001?oooo4`0001Koool200006?ooo`030000oooooooo
00;oool2000000?oool0000000009@0004oooolC00005_ooo`80000Toooo00<0003oool00000=@00
01?ooom800000_ooo`030000oooooooo01Ooool001Coool00`000?ooooooo`02oooo00<0003ooooo
ool09ooooa@0000Doooo>P0001Ooool00`000?ooooooo`0Foooo00<0003oooooool00_ooo`030000
oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo000003D0000C
ooooB00000;oool00`000?ooooooo`0Goooo000Coooo00<0003oool000000oooo`030000oooooooo
02OooolD00005?ooocX0000Goooo00<0003oooooool05Oooo`030000oooo000000?oool00`000?oo
ooooo`0Woooo500001Cooolj00005oooo`030000oooooooo02;oool00`000?ooo`00000e00004ooo
odP00002oooo00<0003oooooool05oooo`005?ooo`030000oooooooo00;oool00`000?ooooooo`0W
oooo500001Cooolj00005oooo`030000oooooooo01Koool00`000?ooooooo`02oooo00<0003ooooo
ool09ooooa@0000Doooo>P0001Ooool00`000?ooooooo`0Roooo00<0003oool00000=@0001?ooom8
00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Woooo500001Cooolj00005ooo
o`030000oooooooo01_oool00`000?ooooooo`0Woooo500001Cooolj00005oooo`030000oooooooo
02;oool00`000?ooo`00000e00004oooodP00002oooo00<0003oooooool05oooo`006Oooo`030000
oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool06oooo`030000oooooooo02OooolD
00005?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo000003D0000CooooB00000;oool0
0`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?oo
ooooo`0Koooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?ooooooo`0Roooo00<0
003oool00000=@0001?ooom800000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0W
oooo500001Cooolj00005oooo`030000oooooooo01_oool00`000?ooooooo`0Woooo500001Cooolj
00005oooo`030000oooooooo02;oool00`000?ooo`00000e00004oooodP00002oooo00<0003ooooo
ool05oooo`006Oooo`030000oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool06ooo
o`030000oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo0000
03D0000CooooB00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000D
oooo>P0001Ooool00`000?ooooooo`0Koooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool0
0`000?ooooooo`0Roooo00<0003oool00000=@0001?ooom800000_ooo`030000oooooooo01Ooool0
01Woool00`000?ooooooo`0Woooo500001Cooolj00005_ooo`80000Moooo00<0003oooooool09ooo
oa@0000Doooo>P0001Koool200009?ooo`030000oooo000003D0000CooooB00000;oool00`000?oo
ooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?ooooooo`0K
oooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?ooooooo`0Roooo00<0003oool0
0000=@0001?ooom800000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Woooo5000
01Cooolj00005oooo`030000oooooooo01_oool00`000?ooooooo`0Woooo500001Cooolj00005ooo
o`030000oooooooo02;oool00`000?ooo`00000e00004oooodP00002oooo00<0003oooooool05ooo
o`006Oooo`030000oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool06oooo`030000
oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo000003D0000C
ooooB00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000Doooo>P00
01Ooool00`000?ooooooo`0Koooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?oo
ooooo`0Roooo00<0003oool00000=@0001?ooom800000_ooo`030000oooooooo01Ooool001Woool0
0`000?ooooooo`0Woooo500001Cooolj00005oooo`030000oooooooo01_oool00`000?ooooooo`0W
oooo500001Cooolj00005oooo`030000oooooooo02;oool00`000?ooo`00000S00004Y:BTQ?=cLdB
o?cl=P0000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000Doooo>P00
01Ooool00`000?ooooooo`0Koooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?oo
ooooo`0Roooo00<0003oool000008`0001:BTY8CcLg=4_clo3H00002oooo00<0003oooooool05ooo
o`006Oooo`030000oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool06oooo`030000
oooooooo02OooolD00005?ooocX0000Goooo00<0003oooooool08_ooo`030000oooo000002<0000B
TY:B4lg=cA;lo?`f00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Woooo5000
01Cooolj00005oooo`030000oooooooo01_oool00`000?ooooooo`0Woooo500001Cooolj00005ooo
o`030000oooooooo02;oool00`000?ooo`00000S00004Y:BTQ?=cLdBo?cl=P0000;oool00`000?oo
ooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?ooooooo`0K
oooo00<0003oooooool09ooooa@0000Doooo>P0001Ooool00`000?ooooooo`0Roooo00<0003oool0
00008`0001:BTY8CcLg=4_clo3H00002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo
02OooolD00005?ooocX0000Foooo0P0001goool00`000?ooooooo`0Woooo500001Cooolj00005_oo
o`80000Toooo00<0003oool000008`0001:BTY8CcLg=4_clo3H00002oooo00<0003oooooool05ooo
o`006Oooo`030000oooooooo04oooolC00005?ooobL00003oooo00<0003oooooool06oooo`030000
oooooooo03_ooolW00005?ooobL00003oooo00<0003oooooool08_ooo`030000oooo000002<0000B
TY:B4lg=cA;lo?`f00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`1?oooo4`00
01CooolW00000oooo`030000oooooooo01_oool00`000?ooooooo`0koooo9`0001CooolW00000ooo
o`030000oooooooo02;oool00`000?ooo`00000S00004Y:BTQ?=cLdBo?cl=P0000;oool00`000?oo
ooooo`0Goooo000Ioooo00<0003oooooool0Cooooa<0000Doooo9`0000?oool00`000?ooooooo`0K
oooo00<0003oooooool0>oooobL0000Doooo9`0000?oool00`000?ooooooo`0Roooo00<0003oool0
00008`0001:BTY8CcLg=4_clo3H00002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo
04oooolC00005?ooobL00003oooo00<0003oooooool06oooo`030000oooooooo03_ooolW00005?oo
obL00003oooo00<0003oooooool08_ooo`030000oooo000002<0000BTY:B4lg=cA;lo?`f00000_oo
o`030000oooooooo01Ooool001Woool00`000?ooooooo`1?oooo4`0001CooolW00000oooo`030000
oooooooo01_oool00`000?ooooooo`0koooo9`0001CooolW00000oooo`030000oooooooo02;oool0
0`000?ooo`00000S00004Y:BTQ?=cLdBo?cl=P0000;oool00`000?ooooooo`0Goooo000Ioooo00<0
003oooooool0Cooooa<0000Doooo9`0000?oool00`000?ooooooo`0Koooo00<0003oooooool0>ooo
obL0000Doooo9`0000?oool00`000?ooooooo`0Roooo00<0003oool000008`0001:BTY8CcLg=4_cl
o3H00002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo04oooolC00005?ooobL00003
oooo00<0003oooooool06oooo`030000oooooooo03_ooolW00005?ooobL00003oooo00<0003ooooo
ool08_ooo`030000oooo000002<0000BTY:B4lg=cA;lo?`f00000_ooo`030000oooooooo01Ooool0
01Woool00`000?ooooooo`1?oooo4`0001CooolW00000oooo`030000oooooooo01_oool00`000?oo
ooooo`0koooo9`0001CooolW00000oooo`030000oooooooo02;oool00`000?ooo`00000S00004Y:B
TQ?=cLdBo?cl=P0000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool0Cooooa<0000D
oooo9`0000;oool200007Oooo`030000oooooooo03_ooolW00005?ooobL00002oooo0P0002Coool0
0`000?ooo`00000S00004Y:BTQ?=cLdBo?cl=P0000;oool00`000?ooooooo`0Goooo000Ioooo00<0
003oooooool0Cooooa<0000Doooo9`0000?oool00`000?ooooooo`0Koooo00<0003oooooool0>ooo
obL0000Doooo9`0000?oool00`000?ooooooo`0Moooo0`0000;oool00`000?ooo`00000S00004Y:B
TQ?=cLdBo?cl=P0000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool0Cooooa<0000D
oooo9`0000?oool00`000?ooooooo`0Koooo00<0003oooooool0>oooobL0000Doooo9`0000?oool0
0`000?ooooooo`0Noooo00H0003oooooooooool0003ooolT00004Y:BTQ?=cLdBo?cl=P0000;oool0
0`000?ooooooo`0Goooo000Ioooo00<0003oooooool0Cooooa<0000Doooo9`0000?oool00`000?oo
ooooo`0Koooo00<0003oooooool0>oooobL0000Doooo9`0000?oool00`000?ooooooo`0Loooo1000
00;oool00`000?ooo`00000S00004Y:BTQ?=cLdBo?cl=P000003oooo0000000001Woool001Woool0
0`000?ooooooo`1?oooo4`0001CooolW00000oooo`030000oooooooo01_oool00`000?ooooooo`0k
oooo9`0001CooolW00000oooo`030000oooooooo01coool00`000?ooo`000003oooo00<0003oool0
0000=@0001>ATI5800000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`1?oooo4`00
01CooolW00000oooo`030000oooooooo01_oool00`000?ooooooo`0koooo9`0001CooolW00000ooo
o`030000oooooooo01goool200000oooo`030000oooo000003D0000CTI6AB00000;oool00`000?oo
ooooo`0Goooo000Ioooo00<0003oooooool0Cooooa<0000Doooo9`0000?oool00`000?ooooooo`0K
oooo00<0003oooooool0>oooobL0000Doooo9`0000?oool00`000?ooooooo`0Noooo00H0003ooooo
ooooool0003ooolf00004i6ATDP00002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo
04oooolC00005?ooobL00003oooo00<0003oooooool06oooo`030000oooooooo03_ooolW00005?oo
obL00003oooo00<0003oooooool08_ooo`030000oooo000003D0000CTI6AB00000;oool00`000?oo
ooooo`0Goooo000Doooo0`0000;oool00`000?ooooooo`1?oooo4`0001CooolW00000oooo`030000
oooooooo01Koool300000_ooo`030000oooooooo03_ooolW00005?ooobL00003oooo00<0003ooooo
ool08_ooo`030000oooo000003D0000CTI6AB00000;oool00`000?ooooooo`0Goooo000Eoooo00D0
003oooooooooool00000DOoooa<0000Doooo9`0000?oool00`000?ooooooo`0Goooo00D0003ooooo
ooooool00000?OooobL0000Doooo9`0000?oool00`000?ooooooo`0Roooo00<0003oool00000=@00
01>ATI5800000_ooo`030000oooooooo01Ooool001?oool400000_ooo`80001@oooo4`0001CooolW
00000_ooo`80000Goooo100000;oool20000??ooobL0000Doooo9`0000;oool200009?ooo`030000
oooo000003D0000CTI6AB00000;oool00`000?ooooooo`0Goooo000Coooo00<0003oool000000ooo
o`030000oooooooo04oooolC00005?ooobL00003oooo00<0003oooooool05Oooo`030000oooo0000
00?oool00`000?ooooooo`0koooo9`0001CooolW00000oooo`030000oooooooo02;oool00`000?oo
o`00000e00004i6ATDP00002oooo00<0003oooooool05oooo`005?ooo`800003oooo00<0003ooooo
ool05?oooa<0000Xoooo4`0001CooolC00005oooo`030000oooooooo01Koool200000oooo`030000
oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool0
0000=@0001>ATI5800000_ooo`030000oooooooo01Ooool001Goool01@000?ooooooooooo`00000F
oooo4`0002SooolC00005?oooa<0000Goooo00<0003oooooool05oooo`050000oooooooooooo0000
01KooolC0000:?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000=@00
01>ATI5800000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`0002SooolC
00005?oooa<0000Goooo00<0003oooooool06oooo`030000oooooooo01CooolC0000:?oooa<0000D
oooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000=@0001>ATI5800000_ooo`030000
oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`0002SooolC00005?oooa<0000Goooo00<0
003oooooool06oooo`030000oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?oo
ooooo`0Roooo00<0003oool00000=@0001>ATI5800000_ooo`030000oooooooo01Ooool001Woool0
0`000?ooooooo`0Doooo4`0002SooolC00005?oooa<0000Goooo00<0003oooooool06oooo`030000
oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool0
0000=@0001>ATI5800000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`00
02SooolC00005?oooa<0000Goooo00<0003oooooool06oooo`030000oooooooo01CooolC0000:?oo
oa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000=@0001>ATI5800000_oo
o`030000oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`0002SooolC00005?oooa<0000G
oooo00<0003oooooool06oooo`030000oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool0
0`000?ooooooo`0Roooo00<0003oool00000=@0001>ATI5800000_ooo`030000oooooooo01Ooool0
01Woool00`000?ooooooo`0Doooo4`0002SooolC00005?oooa<0000Goooo00<0003oooooool06ooo
o`030000oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0
003oool00000=@0001>ATI5800000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0D
oooo4`0002SooolC00005?oooa<0000Foooo0P0001goool00`000?ooooooo`0Doooo4`0002SooolC
00005?oooa<0000Foooo0P0002Coool00`000?ooo`00000e00004i6ATDP00002oooo00<0003ooooo
ool05oooo`006Oooo`030000oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?oo
ooooo`0Koooo00<0003oooooool05?oooa<0000Xoooo4`0001CooolC00005oooo`030000oooooooo
02;oool00`000?ooo`00000e00004i6ATDP00002oooo00<0003oooooool05oooo`006Oooo`030000
oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Koooo00<0003ooooo
ool05?oooa<0000Xoooo4`0001CooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@
00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Doooo4`0002SooolC00005?oo
oa<0000Goooo00<0003oooooool06oooo`030000oooooooo01CooolC0000:?oooa<0000Doooo4`00
01Ooool00`000?ooooooo`0Roooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000I
oooo00<0003oooooool05?oooa<0000Xoooo4`0001CooolC00005oooo`030000oooooooo01_oool0
0`000?ooooooo`0Doooo4`0002SooolC00005?oooa<0000Goooo00<0003oooooool08_ooo`030000
oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo01CooolC0000:?oo
oa<0000Doooo4`0001Ooool00`000?ooooooo`0Koooo00<0003oooooool05?oooa<0000Xoooo4`00
01CooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo
01Ooool001Woool00`000?ooooooo`0Doooo4`0002SooolC00005?oooa<0000Goooo00<0003ooooo
ool06oooo`030000oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0R
oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool05?oo
oa<0000Xoooo4`0001CooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0Doooo4`00
02SooolC00005?oooa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0
003oooooool05oooo`006Oooo`030000oooooooo01CooolC0000:?oooa<0000Doooo4`0001Ooool0
0`000?ooooooo`0Koooo00<0003oooooool05?oooa<0000Xoooo4`0001CooolC00005oooo`030000
oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?oo
ooooo`0Doooo4`0002SooolC00005?oooa<0000Goooo00<0003oooooool06oooo`030000oooooooo
01CooolC0000:?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000T000
00;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool05?oooa<0000Xoooo4`0001CooolC
00005_ooo`80000Moooo00<0003oooooool05?oooa<0000Xoooo4`0001CooolC00005_ooo`80000T
oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09`00
04oooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0
003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000
oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Koooo00<0003oooooool09`0004oooolC
00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool0
01Woool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool06oooo`030000oooooooo
02L0001?oooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000T00000;oool00`000?oo
ooooo`0Goooo000Ioooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo01_oool0
0`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002
oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?oo
ooooo`0Koooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo02;oool00`000?oo
o`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0W0000Cooooa<0000G
oooo00<0003oooooool06oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0R
oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09`00
04oooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0
003oooooool07?ooo`800004oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000I
oooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0W
0000Cooooa<0000Goooo00<0003oooooool07?ooo`030000oooo000000?oool00`000?ooo`00002@
00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0
003oooooool06oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Loooo00<0
003oool000000oooo`030000oooo0000090000000oooo`000000000Ioooo000Ioooo00<0003ooooo
ool09`0004oooolC00005_ooo`80000Moooo00<0003oooooool09`0004oooolC00005_ooo`80000N
oooo0P0000Coool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?oo
ooooo`0W0000Cooooa<0000Goooo00<0003oooooool06oooo`030000oooooooo02L0001?oooo4`00
01Ooool00`000?ooooooo`0Loooo00<0003oooooool00oooo`030000oooo000009000002oooo00<0
003oooooool05oooo`006Oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0K
oooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo01goool200000oooo`030000
oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02L0001?oooo4`00
01Ooool00`000?ooooooo`0Koooo00<0003oooooool09`0004oooolC00005oooo`030000oooooooo
02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0W
0000Cooooa<0000Goooo00<0003oooooool06oooo`030000oooooooo02L0001?oooo4`0001Ooool0
0`000?ooooooo`0Roooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0
003oooooool09`0004oooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0W0000Cooo
oa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05ooo
o`006Oooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Koooo00<0003ooooo
ool09`0004oooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000
oooooooo01Ooool001?oool200001?ooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?oo
ooooo`0Eoooo0P0000Coool00`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool08_oo
o`030000oooo000009000002oooo00<0003oooooool05oooo`004oooo`030000oooo000000?oool0
0`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool05Oooo`030000oooo000000?oool0
0`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002
oooo00<0003oooooool05oooo`004oooo`030000oooo000000?oool2000000?oool0000000009@00
04oooolC00005_ooo`80000Goooo00<0003oool000000oooo`8000000oooo`000000000U0000Cooo
oa<0000Foooo0P0002Coool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001?oool2
00001?ooo`030000oooooooo02L0001?oooo4`0001Ooool00`000?ooooooo`0Eoooo0P0000Coool0
0`000?ooooooo`0W0000Cooooa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002
oooo00<0003oooooool05oooo`004oooo`030000oooooooo00?oool00`000?ooooooo`0Woooo5000
01CooolC00005?oooa<0000Goooo00<0003oooooool05Oooo`030000oooooooo00?oool00`000?oo
ooooo`0Woooo500001CooolC00005?oooa<0000Goooo00<0003oooooool08_ooo`030000oooo0000
09000002oooo00<0003oooooool05oooo`005?ooo`800003oooo00<0003oooooool09ooooa@0000D
oooo4`0001CooolC00005oooo`030000oooooooo01Koool200000oooo`030000oooooooo02OooolD
00005?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000T00000;oool0
0`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000Doooo4`0001CooolC00005ooo
o`030000oooooooo01_oool00`000?ooooooo`0Woooo500001CooolC00005?oooa<0000Goooo00<0
003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000
oooooooo02OooolD00005?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Koooo00<0003ooooo
ool09ooooa@0000Doooo4`0001CooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@
00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Woooo500001CooolC00005?oo
oa<0000Goooo00<0003oooooool06oooo`030000oooooooo02OooolD00005?oooa<0000Doooo4`00
01Ooool00`000?ooooooo`0Roooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000I
oooo00<0003oooooool09ooooa@0000Doooo4`0001CooolC00005oooo`030000oooooooo01_oool0
0`000?ooooooo`0Woooo500001CooolC00005?oooa<0000Goooo00<0003oooooool08_ooo`030000
oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02OooolD00005?oo
oa<0000Doooo4`0001Ooool00`000?ooooooo`0Koooo00<0003oooooool09ooooa@0000Doooo4`00
01CooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo
01Ooool001Woool00`000?ooooooo`0Woooo500001CooolC00005?oooa<0000Goooo00<0003ooooo
ool06oooo`030000oooooooo02OooolD00005?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0R
oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooo
oa@0000Doooo4`0001CooolC00005_ooo`80000Moooo00<0003oooooool09ooooa@0000Doooo4`00
01CooolC00005_ooo`80000Toooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000I
oooo00<0003oooooool09ooooa@0000Doooo4`0001CooolC00005oooo`030000oooooooo01_oool0
0`000?ooooooo`0Woooo500001CooolC00005?oooa<0000Goooo00<0003oooooool08_ooo`030000
oooo000009000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo02OooolD00005?oo
oa<0000Doooo4`0001Ooool00`000?ooooooo`0Koooo00<0003oooooool09ooooa@0000Doooo4`00
01CooolC00005oooo`030000oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo
01Ooool001Woool00`000?ooooooo`0Woooo500001CooolC00005?oooa<0000Goooo00<0003ooooo
ool06oooo`030000oooooooo02OooolD00005?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0R
oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooo
oa@0000Doooo4`0001CooolC00005oooo`030000oooooooo01_oool00`000?ooooooo`0Woooo5000
01CooolC00005?oooa<0000Goooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0
003oooooool05oooo`006Oooo`030000oooooooo02OooolD00005?oooa<0000Doooo4`0001Ooool0
0`000?ooooooo`0Koooo00<0003oooooool09ooooa@0000Doooo4`0001CooolC00005oooo`030000
oooooooo02;oool00`000?ooo`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?oo
ooooo`0Woooo500001CooolC00005?oooa<0000Goooo00<0003oooooool06oooo`030000oooooooo
02OooolD00005?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000T000
00;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool09ooooa@0000Doooo4`0001CooolC
00005oooo`030000oooooooo01_oool00`000?ooooooo`0Woooo500001CooolC00005?oooa<0000G
oooo00<0003oooooool08_ooo`030000oooo000009000002oooo00<0003oooooool05oooo`006Ooo
o`030000oooooooo02OooolD00005?oooa<0000Doooo4`0001Ooool00`000?ooooooo`0Koooo00<0
003oooooool09ooooa@0000Doooo4`0001CooolC00005oooo`030000oooooooo02;oool00`000?oo
o`00002@00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`0Woooo500001CooolC
00005?oooa<0000Goooo00<0003oooooool06oooo`030000oooooooo02OooolD00005?oooa<0000D
oooo4`0001Ooool00`000?ooooooo`0Roooo00<0003oool00000T00000;oool00`000?ooooooo`0G
oooo000Ioooo00<0003oooooool09ooooa@0000Doooo4`0001CooolC00005_ooo`80000Moooo00<0
003oooooool09ooooa@0000Doooo4`0001CooolC00005_ooo`80000Toooo00<0003oool00000T000
00;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool0CoooocX0000Goooo00<0003ooooo
ool06oooo`030000oooooooo04oooolj00005oooo`030000oooooooo02;oool00`000?ooo`00002@
00000_ooo`030000oooooooo01Ooool001Woool00`000?ooooooo`1?oooo>P0001Ooool00`000?oo
ooooo`0Koooo00<0003oooooool0CoooocX0000Goooo00<0003oooooool08_ooo`030000oooo0000
09000002oooo00<0003oooooool05oooo`006Oooo`030000oooooooo04oooolj00005oooo`030000
oooooooo01_oool00`000?ooooooo`1?oooo>P0001Ooool00`000?ooooooo`0Roooo00<0003oool0
0000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003oooooool0CoooocX0000Goooo00<0
003oooooool06oooo`030000oooooooo04oooolj00005oooo`030000oooooooo01goool00`000?oo
ooooo`02oooo00<0003oool00000T00000;oool00`000?ooooooo`0Goooo000Ioooo00<0003ooooo
ool0CoooocX0000Goooo00<0003oooooool06oooo`030000oooooooo04oooolj00005oooo`030000
oooooooo01coool00`000?ooo`000003oooo00<0003oool00000T00000;oool00`000?ooooooo`0G
oooo000Ioooo00<0003oooooool0CoooocX0000Goooo00<0003oooooool06oooo`030000oooooooo
04oooolj00005oooo`030000oooooooo01coool00`000?ooo`000003oooo00<0003oool00000T000
0003oooo0000000001Woool001Woool00`000?ooooooo`1?oooo>P0001Ooool00`000?ooooooo`0K
oooo00<0003oooooool0CoooocX0000Goooo00<0003oooooool07Oooo`030000oooooooo00;oool0
0`000?ooooooo`2Boooo00<0003oooooool05oooo`006Oooo`030000oooooooo04oooolj00005ooo
o`030000oooooooo01_oool00`000?ooooooo`1?oooo>P0001Ooool00`000?ooooooo`0Loooo00<0
003oool000000oooo`030000oooo000002?oool00`000?ooooooo`0Qoooo00<0003oooooool08Ooo
o`030000oooooooo027oool010000?ooooooo`0001Woool001Woool00`000?ooooooo`1?oooo>P00
01Ooool00`000?ooooooo`0Koooo00<0003oooooool0CoooocX0000Goooo00<0003oooooool07Ooo
o`030000oooooooo00;ooonF00006Oooo`006Oooo`030000oooooooo04oooolj00005_ooo`80000M
oooo00<0003oooooool0CoooocX0000Foooo0P000=?oool001Woool00`000?ooooooo`1?oooo>P00
01Ooool00`000?ooooooo`0Koooo00<0003oooooool0CoooocX0000Goooo00<0003oooooool0dOoo
o`006Oooo`030000oooooooo04oooolj00005oooo`030000oooooooo01_oool00`000?ooooooo`1?
oooo>P0001Ooool00`000?ooooooo`3Aoooo000Ioooo00<0003oooooool0CoooocX0000Goooo00<0
003oooooool06oooo`030000oooooooo04oooolj00005oooo`030000oooooooo0=7oool001Woool0
0`000?ooooooo`1?oooo>P0001Ooool00`000?ooooooo`0Koooo00<0003oooooool0CoooocX0000G
oooo00<0003oooooool0dOooo`006Oooo`030000oooooooo04oooolj00005oooo`030000oooooooo
01_oool00`000?ooooooo`1?oooo>P0001Ooool00`000?ooooooo`3Aoooo000Ioooo00<0003ooooo
ool0CoooocX0000Goooo00<0003oooooool06oooo`030000oooooooo04oooolj00005oooo`030000
oooooooo053oool3000000Coool0000000000002oooo0`0000;oool300000oooo`800002oooo0`00
00?oool2000000?oool0000000000_ooo`030000oooo000000800003oooo0P0005;oool001Woool0
0`000?ooooooo`1?oooo>P0001Ooool00`000?ooooooo`0Koooo00<0003oooooool0CoooocX0000G
oooo00<0003oooooool0Coooo`040000oooooooo00000_ooo`030000oooooooo00;oool00`000?oo
ooooo`02oooo00D0003oooooooooool000001Oooo`050000oooooooooooo000000Coool01P000?oo
ooooo`000?ooo`0000Coool00`000?ooooooo`1Boooo000Doooo00<0003oooooool00_ooo`030000
oooooooo04oooolj00005oooo`030000oooooooo01Koool00`000?ooooooo`02oooo00<0003ooooo
ool0CoooocX0000Goooo00<0003oooooool0Coooo`040000oooooooo00000_ooo`030000oooooooo
00;oool00`000?ooooooo`02oooo00@0003oooooooooool300000oooo`040000oooooooooooo0`00
00;oool01P000?ooooooo`000?ooo`0000Coool30000D_ooo`004oooo`030000oooo000000?oool0
0`000?ooooooo`1?oooo>P0001Ooool00`000?ooooooo`0Eoooo00<0003oool000000oooo`030000
oooooooo04oooolj00005oooo`030000oooooooo053oool3000000?oool0000000000oooo`<00002
oooo0`0000;oool300000_ooo`@000001Oooo`00000000000?ooo`0400000_ooo`<00002oooo0`00
05;oool001?oool00`000?ooo`000003oooo0P00053ooolj00005_ooo`80000Goooo00<0003oool0
00000oooo`80001@oooo>P0001Koool20000E?ooo`030000oooooooo00Goool00`000?ooooooo`02
oooo00<0003oooooool0Koooo`005?ooo`030000oooooooo00;oool00`000?ooooooo`2Poooo00<0
003oooooool05_ooo`030000oooooooo00;oool00`000?ooooooo`2Poooo00<0003oooooool0DOoo
o`800002oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`1^oooo000C
oooo00<0003oool000000oooo`040000oooooooo00002Oooo`030000oooooooo00Ooool00`000?oo
ooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01ooo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo
00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`040000oooooooo00005oooo`030000
oooo000000?oool010000?ooooooo`0000Woool00`000?ooooooo`07oooo00<0003oooooool01_oo
o`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo
00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0
003oooooool01oooo`030000oooooooo00Ooool010000?ooooooo`000=?oool001Coool00`000?oo
ooooo`02ooooY00001Soool00`000?ooooooo`02ooooY0000=?oool00?ooooooooooDoooo`00oooo
oooooomCoooo003ooooooooooe?oool00?ooooooooooDoooo`00oooooooooomCoooo0000\
\>"],
  ImageRangeCache->{{{0, 592}, {184.313, 0}} -> {-0.0808907, -0.0234425, 
  0.00534085, 0.00534085}, {{15.125, 190.625}, {179.875, 
  4.375}} -> {-1.44981, -0.94953, 0.051013, 0.051013}, {{208.188, 383.75}, {
  179.875, 4.375}} -> {-11.3001, -0.94953, 0.051013, 0.051013}, {{401.313, 
  576.813}, {179.875, 4.375}} -> {-23.3641, -1.00999, 0.0555125, 0.0555125}}],\


Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(i = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 
          0, 0, 0, 1}, {1, 1, 1, 1, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 1, 0, 1}, {
          0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 1, 0, 0
          \ , 0, 1}}; \)\)], "Input"],

Cell[BoxData[
    \(\(j = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 1, 
          0, 0, 0, 1}, {1, 1, 1, 1, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 1, 0, 1}, {
          0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 1, 1, 
          1, 1, 1}}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[i, Mesh -> False], 
          ListDensityPlot[j, Mesh -> False]}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
000000FFFFFF00FF
00FF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{487.875, 232.313},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40007W0000j1P00`40o`000?l0003oooooonSoool0
0?oooooXoooo003oooooj?ooo`00ooooonSoool00?oooooXoooo003oooooj?ooo`00ooooonSoool0
01Woool00`000?ooooooo`0^oooo0`00033oool30000;oooo`80000aoooo00<0003oooooool09ooo
o`030000oooooooo02koool30000<?ooo`<0000^oooo0P00037oool00`000?ooooooo`0@oooo000H
oooo00<0003oool00000;oooo`030000oooooooo037oool00`000?ooooooo`0^oooo00<0003oool0
0000;oooo`030000oooo000002Ooool00`000?ooo`00000_oooo00<0003oooooool0<Oooo`030000
oooooooo02goool00`000?ooo`00000_oooo00<0003oool000004Oooo`006?ooo`030000oooo0000
033oool00`000?ooooooo`0^oooo100002ooool00`000?ooo`00000_oooo00<0003oool000009ooo
o`030000oooo0000033oool00`000?ooooooo`0^oooo100002koool00`000?ooo`00000_oooo00<0
003oool000004Oooo`006?ooo`030000oooo0000033oool00`000?ooooooo`0^oooo00<0003oool0
0000<?ooo`80000aoooo00<0003oooooool09_ooo`030000oooo0000033oool00`000?ooooooo`0^
oooo00<0003oool00000;oooo`80000aoooo00<0003oooooool04?ooo`006?ooo`030000oooo0000
02ooool00`000?ooo`00000`oooo0P00033oool00`000?ooooooo`0_oooo00<0003oool000009ooo
o`030000oooo000002ooool00`000?ooo`00000`oooo0P0002ooool00`000?ooooooo`0_oooo00<0
003oool000004Oooo`006Oooo`030000oooooooo02ooool00`000?ooooooo`0`oooo00<0003ooooo
ool0;oooo`80000`oooo00<0003oooooool09oooo`030000oooooooo02ooool00`000?ooooooo`0`
oooo00<0003oooooool0;_ooo`80000`oooo00<0003oooooool04?ooo`00ooooonSoool00?oooooX
oooo003oooooj?ooo`00ooooonSoool001KooooA00008Oooom40000>oooo000Foooo00D0003ooooo
ooooool000002oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003oooooool02_oo
o`030000oooooooo00Woool00`000?ooooooo`0:oooo00<0003oooooool02Oooo`030000oooooooo
00[oool00`000?ooooooo`0:oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?oo
ooooo`09oooo00<0003oooooool02_ooo`030000oooooooo00Woool00`000?ooooooo`0:oooo00<0
003oooooool02Oooo`050000oooooooooooo0000027oool01@000?ooooooooooo`00000<oooo00<0
003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00<0003oooooool02_oo
o`030000oooooooo00Woool00`000?ooooooo`0:oooo00<0003oooooool02Oooo`030000oooooooo
00[oool00`000?ooooooo`09oooo00<0003oooooool02_ooo`030000oooooooo00Woool00`000?oo
ooooo`0:oooo00<0003oooooool02Oooo`030000oooooooo00[oool00`000?ooooooo`09oooo00D0
003oooooooooool000003_ooo`004?ooo`030000oooooooo00?oool01@000?ooooooooooo`00000a
oooo00<0003oooooool0;oooo`030000oooooooo02ooool00`000?ooooooo`0_oooo00D0003ooooo
ooooool000007?ooo`030000oooooooo00;oool01@000?ooooooooooo`00000aoooo00<0003ooooo
ool0;oooo`030000oooooooo02ooool00`000?ooooooo`0_oooo00D0003oooooooooool000003_oo
o`003oooo`030000oooo000000Coool00`000?ooooooo`3=oooo00<0003oooooool06Oooo`030000
oooo000000?oool00`000?ooooooo`3=oooo00<0003oooooool03?ooo`003oooo`030000oooo0000
00Coool20000cOooo`80000Koooo00<0003oool000000oooo`<0003<oooo0P0000koool000ooool0
0`000?ooo`000004oooo00<0003oooooool06_oooaT0000booooB`0001goool00`000?ooooooo`0I
oooo00<0003oool000000oooo`030000oooooooo01[ooolI0000<_oood/0000Moooo00<0003ooooo
ool03?ooo`003oooo`030000oooo000000Coool00`000?ooooooo`0Joooo6@0003;ooom;00007Ooo
o`030000oooooooo01Woool00`000?ooo`000003oooo00<0003oooooool06_oooaT0000booooB`00
01goool00`000?ooooooo`0<oooo000@oooo00<0003oooooool00oooo`030000oooooooo01[ooolI
0000<_oood/0000Moooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?ooooooo`0J
oooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@00
03;ooom;00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Ooo
o`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000
oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool0
01Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo01ooool00`000?oo
ooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0J
oooo6@0003;ooom;00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;
00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Ooo
o`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo
00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo01ooool0
0`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?oo
ooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@00
03;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;
00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000
oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo
01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool2
00006ooooaT0000booooB`0001coool200008Oooo`80000Koooo6@0003;ooom;00007Oooo`030000
oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo
01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool0
0`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo01ooool00`000?ooooooo`0J
oooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@00
03;ooom;00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Ooo
o`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000
oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool0
01Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo01ooool00`000?oo
ooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0J
oooo6@0003;ooom;00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;
00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Ooo
o`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo
00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo01ooool0
0`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?oo
ooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@00
03;ooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;
00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000
oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo
01ooool00`000?ooooooo`0Joooo6@0003;ooom;00007Oooo`030000oooooooo00coool001Koool2
00006ooooaT0000booooB`0001coool200008Oooo`80000Koooo6@0003;ooom;00007Oooo`030000
oooooooo00coool001Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0O
oooo00@0003ooooooooooom;0000BooooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000
oooooooooooo<P0006CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooood/0001;
oooo6@0001goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000M
oooo00<0003oooooool07oooo`040000ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo
00coool001Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0
003ooooooooooom;0000BooooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooo
oooo<P0006CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooood/0001;oooo6@00
01goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0
003oooooool07oooo`040000ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo00coool0
01Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooo
oooooom;0000BooooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P00
06CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooood/0001;oooo6@0001goool0
0`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003ooooo
ool07oooo`040000ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo00coool001Koool0
10000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooooooooom;
0000BooooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P0006CooolI
00007Oooo`030000oooooooo01ooool010000?oooooooooood/0001;oooo6@0001goool00`000?oo
ooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003oooooool07ooo
o`040000ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo00coool001Koool200000_oo
oc80001Toooo6@0001coool200008Oooo`800002ooooB`0004_ooolI00007Oooo`030000oooooooo
00coool001Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0
003ooooooooooom;0000BooooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooo
oooo<P0006CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooood/0001;oooo6@00
01goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0
003oooooool07oooo`040000ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo00coool0
01Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooo
oooooom;0000BooooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P00
06CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooood/0001;oooo6@0001goool0
0`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003ooooo
ool07oooo`040000ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo00coool001Koool0
10000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooooooooom;
0000BooooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P0006CooolI
00007Oooo`030000oooooooo01ooool010000?oooooooooood/0001;oooo6@0001goool00`000?oo
ooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003oooooool07ooo
o`040000ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo00coool000ooool300001?oo
o`040000oooooooooooo<P0006CooolI00007Oooo`030000oooooooo01Woool300000oooo`040000
ooooooooooooB`0004_ooolI00007Oooo`030000oooooooo00coool000ooool00`000?ooooooo`04
oooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003oooooool06Oooo`030000oooooooo
00?oool010000?oooooooooood/0001;oooo6@0001goool00`000?ooooooo`0<oooo000@oooo00<0
003oooooool00oooo`800002oooo<P0006CooolI00007?ooo`80000Loooo00<0003oooooool00_oo
o`<000000oooo`00000000190000BooooaT0000Loooo0P0000koool0013oool00`000?ooooooo`03
oooo00<0003oooooool0<ooooaT0000IooooB`0001goool00`000?ooooooo`0Joooo00<0003ooooo
ool00_ooo`040000oooooooooooo6@0001WooolI00006Ooood/0000Moooo00<0003oooooool03?oo
o`003oooo`030000oooo000000Coool00`000?ooooooo`0coooo6@0001Wooom;00007Oooo`030000
oooooooo01Woool00`000?ooo`000003oooo00@0003ooooooooooolI00006OoooaT0000IooooB`00
01goool00`000?ooooooo`0<oooo000@oooo00<0003oooooool00oooo`030000oooooooo03?ooolI
00006Ooood/0000Moooo00<0003oooooool06_ooo`030000oooooooo00;oool010000?oooooooooo
oaT0000Ioooo6@0001Wooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0c
oooo6@0001Wooom;00007Oooo`030000oooooooo01ooool010000?oooooooooooaT0000Ioooo6@00
01Wooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0coooo6@0001Wooom;
00007Oooo`030000oooooooo01ooool010000?oooooooooooaT0000Ioooo6@0001Wooom;00007Ooo
o`030000oooooooo00coool001Koool00`000?ooooooo`0coooo6@0001Wooom;00007Oooo`030000
oooooooo01ooool010000?oooooooooooaT0000Ioooo6@0001Wooom;00007Oooo`030000oooooooo
00coool001Koool00`000?ooooooo`0coooo6@0001Wooom;00007Oooo`030000oooooooo01ooool0
10000?oooooooooooaT0000Ioooo6@0001Wooom;00007Oooo`030000oooooooo00coool001Koool0
0`000?ooooooo`0coooo6@0001Wooom;00007Oooo`030000oooooooo01ooool010000?oooooooooo
oaT0000Ioooo6@0001Wooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0c
oooo6@0001Wooom;00007Oooo`030000oooooooo01ooool010000?oooooooooooaT0000Ioooo6@00
01Wooom;00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`0coooo6@0001Wooom;
00007Oooo`030000oooooooo01ooool010000?oooooooooooaT0000Ioooo6@0001Wooom;00007Ooo
o`030000oooooooo00coool001Koool00`000?ooooooo`0coooo6@0001Wooom;00007Oooo`030000
oooooooo01ooool010000?oooooooooooaT0000Ioooo6@0001Wooom;00007Oooo`030000oooooooo
00coool001Koool00`000?ooooooo`0coooo6@0001Wooom;00007Oooo`030000oooooooo01ooool0
10000?oooooooooooaT0000Ioooo6@0001Wooom;00007Oooo`030000oooooooo00coool001Koool2
0000=?oooaT0000IooooB`0001coool200008Oooo`800002oooo6@0001WooolI00006Ooood/0000M
oooo00<0003oooooool03?ooo`005_ooo`030000oooooooo03?ooolI00006Ooood/0000Moooo00<0
003oooooool07oooo`040000oooooooooooo6@0001WooolI00006Ooood/0000Moooo00<0003ooooo
ool03?ooo`005_ooo`030000oooooooo03?ooolI00006Ooood/0000Moooo00<0003oooooool07ooo
o`040000oooooooooooo6@0001WooolI00006Ooood/0000Moooo00<0003oooooool03?ooo`005_oo
o`030000oooooooo03?ooolI00006Ooood/0000Moooo00<0003oooooool07oooo`040000oooooooo
oooo6@0001WooolI00006Ooood/0000Moooo00<0003oooooool03?ooo`005_ooo`030000oooooooo
03?ooolI00006Ooood/0000Moooo00<0003oooooool07oooo`040000oooooooooooo6@0001WooolI
00006Ooood/0000Moooo00<0003oooooool03?ooo`005_ooo`030000oooooooo03?ooolI00006Ooo
od/0000Moooo00<0003oooooool07oooo`040000oooooooooooo6@0001WooolI00006Ooood/0000M
oooo00<0003oooooool03?ooo`005_ooo`030000oooooooo03?ooolI00006Ooood/0000Moooo00<0
003oooooool07oooo`040000oooooooooooo6@0001WooolI00006Ooood/0000Moooo00<0003ooooo
ool03?ooo`005_ooo`030000oooooooo03?ooolI00006Ooood/0000Moooo00<0003oooooool07ooo
o`040000oooooooooooo6@0001WooolI00006Ooood/0000Moooo00<0003oooooool03?ooo`005_oo
o`030000oooooooo03?ooolI00006Ooood/0000Moooo00<0003oooooool07oooo`040000oooooooo
oooo6@0001WooolI00006Ooood/0000Moooo00<0003oooooool03?ooo`005_ooo`030000oooooooo
03?ooolI00006Ooood/0000Moooo00<0003oooooool07oooo`040000oooooooooooo6@0001WooolI
00006Ooood/0000Moooo00<0003oooooool03?ooo`005_ooo`030000oooooooo03?ooolI00006Ooo
od/0000Moooo00<0003oooooool07oooo`040000oooooooooooo6@0001WooolI00006Ooood/0000M
oooo00<0003oooooool03?ooo`005_ooo`030000oooooooo03?ooolI00006Ooood/0000Moooo00<0
003oooooool07oooo`040000oooooooooooo6@0001WooolI00006Ooood/0000Moooo00<0003ooooo
ool03?ooo`005_ooo`80000doooo6@0001Wooom;00007?ooo`80000Qoooo0P0000;ooolI00006Ooo
oaT0000IooooB`0001goool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000I
oooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool0
0`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?oo
ooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000F
oooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003ooooo
ool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoo
oaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P00
00Coool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool0
0`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<
oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0
003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0003ooooo
ool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000I
oooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P00
00Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?oo
ooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0O
oooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0
003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoo
oaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000I
oooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool0
0`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?oo
ooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000F
oooo0P0006KooolI00006Ooooc800003oooo0P00027oool20000I_oooaT0000Ioooo<P0000Coool0
0`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?oo
ooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000F
oooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003ooooo
ool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoo
oaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P00
00Coool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool0
0`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<
oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0
003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0003ooooo
ool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000I
oooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P00
00Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?oo
ooooo`0<oooo000Foooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0O
oooo00<0003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000Foooo00<0
003oooooool0IOoooaT0000Ioooo<P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool0IOoo
oaT0000Ioooo<P0000Coool00`000?ooooooo`0<oooo000@oooo0`0000?oool00`000?ooooooo`1U
oooo6@0001Wooolb00001?ooo`030000oooooooo01[oool300000_ooo`030000oooooooo06GooolI
00006Ooooc800004oooo00<0003oooooool03?ooo`004Oooo`030000oooooooo00;oool00`000?oo
ooooo`1Uoooo6@0001Wooolb00001?ooo`030000oooooooo01_oool01@000?ooooooooooo`00001W
oooo6@0001Wooolb00001?ooo`030000oooooooo00coool000ooool400000oooo`80001Voooo6@00
01Wooolb00000oooo`80000Koooo100000;oool30000IOoooaT0000Ioooo<P0000?oool200003_oo
o`003oooo`030000oooo000000Coool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000M
oooo00<0003oooooool06Oooo`030000oooo000000?oool00`000?ooooooo`0Joooo6@0003;ooolI
00006OoooaT0000Moooo00<0003oooooool03?ooo`004?ooo`800004oooo00<0003oooooool06_oo
oaT0000boooo6@0001WooolI00007Oooo`030000oooooooo01[oool200000oooo`030000oooooooo
01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000Aoooo00<0003ooooo
ool00_ooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0K
oooo00D0003oooooooooool000007?oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo
00coool001Koool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003ooooo
ool07oooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0<
oooo000Foooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo
01ooool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003oooooool03?oo
o`005_ooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0O
oooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo00coool0
01Koool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003oooooool07ooo
o`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000F
oooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo01ooool0
0`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003oooooool03?ooo`005_oo
o`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0Ooooo00<0
003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo00coool001Koool0
0`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003oooooool07oooo`030000
oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000Foooo00<0
003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo01ooool00`000?oo
ooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003oooooool03?ooo`005_ooo`030000
oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0Ooooo00<0003ooooo
ool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo00coool001Koool200006ooo
oaT0000boooo6@0001WooolI00007?ooo`80000Qoooo0P0001_ooolI0000<_oooaT0000Ioooo6@00
01goool00`000?ooooooo`0<oooo000Foooo00<0003oooooool06_oooaT0000boooo6@0001WooolI
00007Oooo`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000M
oooo00<0003oooooool03?ooo`005_ooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@00
01goool00`000?ooooooo`0Ooooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Ooo
o`030000oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000M
oooo00<0003oooooool07oooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool0
0`000?ooooooo`0<oooo000Foooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Ooo
o`030000oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0
003oooooool03?ooo`005_ooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool0
0`000?ooooooo`0Ooooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000
oooooooo00coool001Koool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0
003oooooool07oooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?oo
ooooo`0<oooo000Foooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000
oooooooo01ooool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003ooooo
ool03?ooo`005_ooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?oo
ooooo`0Ooooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo
00coool001Koool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003ooooo
ool07oooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0<
oooo000Foooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo
01ooool00`000?ooooooo`0Joooo6@0003;ooolI00006OoooaT0000Moooo00<0003oooooool03?oo
o`005_ooo`030000oooooooo01[ooolI0000<_oooaT0000Ioooo6@0001goool00`000?ooooooo`0O
oooo00<0003oooooool06_oooaT0000boooo6@0001WooolI00007Oooo`030000oooooooo00coool0
01Koool200006ooooaT0000boooo6@0001WooolI00007?ooo`80000Qoooo0P0001_ooolI0000<_oo
oaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oo
oaT0000Moooo00<0003oooooool07oooo`040000oooooooooooo<P0006CooolI00007Oooo`030000
oooooooo00coool001Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0O
oooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000
oooooooooooo<P0006CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooooc80001T
oooo6@0001goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000M
oooo00<0003oooooool07oooo`040000oooooooooooo<P0006CooolI00007Oooo`030000oooooooo
00coool001Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0
003ooooooooooolb0000I?oooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooo
oooo<P0006CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooooc80001Toooo6@00
01goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0
003oooooool07oooo`040000oooooooooooo<P0006CooolI00007Oooo`030000oooooooo00coool0
01Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooo
oooooolb0000I?oooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P00
06CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooooc80001Toooo6@0001goool0
0`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003ooooo
ool07oooo`040000oooooooooooo<P0006CooolI00007Oooo`030000oooooooo00coool001Koool0
10000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooooooooolb
0000I?oooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P0006CooolI
00007Oooo`030000oooooooo01ooool010000?oooooooooooc80001Toooo6@0001goool00`000?oo
ooooo`0<oooo000Foooo0P0000;ooolb0000I?oooaT0000Loooo0P00027oool200000_oooc80001T
oooo6@0001goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000M
oooo00<0003oooooool07oooo`040000oooooooooooo<P0006CooolI00007Oooo`030000oooooooo
00coool001Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0
003ooooooooooolb0000I?oooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooo
oooo<P0006CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooooc80001Toooo6@00
01goool00`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0
003oooooool07oooo`040000oooooooooooo<P0006CooolI00007Oooo`030000oooooooo00coool0
01Koool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooo
oooooolb0000I?oooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P00
06CooolI00007Oooo`030000oooooooo01ooool010000?oooooooooooc80001Toooo6@0001goool0
0`000?ooooooo`0<oooo000Foooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0003ooooo
ool07oooo`040000oooooooooooo<P0006CooolI00007Oooo`030000oooooooo00coool001Koool0
10000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0Ooooo00@0003ooooooooooolb
0000I?oooaT0000Moooo00<0003oooooool03?ooo`005_ooo`040000oooooooooooo<P0006CooolI
00007Oooo`030000oooooooo01ooool010000?oooooooooooc80001Toooo6@0001goool00`000?oo
ooooo`0<oooo000?oooo0P0000Goool010000?oooooooooooc80001Toooo6@0001goool00`000?oo
ooooo`0Ioooo0P0000Coool010000?oooooooooooc80001Toooo6@0001goool00`000?ooooooo`0<
oooo000?oooo00<0003oool000001?ooo`040000oooooooooooo<P0006CooolI00007Oooo`030000
oooooooo01Woool00`000?ooo`000003oooo00@0003ooooooooooolb0000I?oooaT0000Moooo00<0
003oooooool03?ooo`003oooo`030000oooo000000Coool200000_oooc80001Toooo6@0001coool2
00006oooo`030000oooo000000?oool3000000?oool000000000<00006CooolI00007?ooo`80000>
oooo000?oooo0P0000Goool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0
003oooooool06Oooo`800004oooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Ooo
o`030000oooooooo00coool000ooool00`000?ooooooo`04oooo00<0003oooooool0<ooooaT0000I
oooo6@0001WooolI00007Oooo`030000oooooooo01Woool00`000?ooooooo`03oooo00<0003ooooo
ool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo00coool0013oool200001?oo
o`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0Joooo0P00
00?oool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool03?oo
o`005_ooo`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0O
oooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo00coool0
01Koool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool07ooo
o`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000F
oooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo01ooool0
0`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool03?ooo`005_oo
o`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0Ooooo00<0
003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo00coool001Koool0
0`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool07oooo`030000
oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000Foooo00<0
003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo01ooool00`000?oo
ooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool03?ooo`005_ooo`030000
oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0Ooooo00<0003ooooo
ool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo00coool001Koool00`000?oo
ooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool07oooo`030000oooooooo
03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000Foooo00<0003ooooo
ool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo01ooool00`000?ooooooo`0c
oooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool03?ooo`005_ooo`80000doooo6@00
01WooolI00006OoooaT0000Loooo0P00027oool20000=?oooaT0000Ioooo6@0001WooolI00007Ooo
o`030000oooooooo00coool001Koool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000M
oooo00<0003oooooool07oooo`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool0
0`000?ooooooo`0<oooo000Foooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Ooo
o`030000oooooooo01ooool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0
003oooooool03?ooo`005_ooo`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool0
0`000?ooooooo`0Ooooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000
oooooooo00coool001Koool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0
003oooooool07oooo`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?oo
ooooo`0<oooo000Foooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000
oooooooo01ooool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003ooooo
ool03?ooo`005_ooo`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?oo
ooooo`0Ooooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo
00coool001Koool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003ooooo
ool07oooo`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0<
oooo000Foooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo
01ooool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool03?oo
o`005_ooo`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0O
oooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo00coool0
01Koool00`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool07ooo
o`030000oooooooo03?ooolI00006OoooaT0000Ioooo6@0001goool00`000?ooooooo`0<oooo000F
oooo00<0003oooooool0<ooooaT0000Ioooo6@0001WooolI00007Oooo`030000oooooooo01ooool0
0`000?ooooooo`0coooo6@0001WooolI00006OoooaT0000Moooo00<0003oooooool03?ooo`005_oo
o`80000doooo6@0001WooolI00006OoooaT0000Loooo0P00027oool20000=?oooaT0000Ioooo6@00
01WooolI00007Oooo`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool0
0`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool00`000?oo
ooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo
00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003ooooo
ool0cOooo`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?oo
ooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool00`000?ooooooo`1U
ooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool0
01Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOoo
o`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0O
oooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`00
01goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool0
0`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000
oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0
003oooooool0cOooo`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool0
0`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool00`000?oo
ooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo
00coool001Koool20000I_oood/0000Loooo0P00027oool20000c_ooo`030000oooooooo00coool0
01Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOoo
o`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0O
oooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`00
01goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool0
0`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000
oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0
003oooooool0cOooo`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool0
0`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool001Koool00`000?oo
ooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo
00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?ooooooo`0Ooooo00<0003ooooo
ool0cOooo`030000oooooooo00coool001Koool00`000?ooooooo`1UooooB`0001goool00`000?oo
ooooo`0Ooooo00<0003oooooool0cOooo`030000oooooooo00coool0013oool00`000?ooooooo`03
oooo00<0003oooooool0IOoood/0000Moooo00<0003oooooool06_ooo`030000oooooooo00;oool0
0`000?ooooooo`3=oooo00<0003oooooool03?ooo`003oooo`030000oooo000000Coool00`000?oo
ooooo`1UooooB`0001goool00`000?ooooooo`0Ioooo00<0003oool000000oooo`030000oooooooo
0<goool00`000?ooooooo`0<oooo000?oooo00<0003oool000001?ooo`80001VooooB`0001coool2
00006oooo`030000oooo000000?oool30000c?ooo`80000>oooo000@oooo00<0003oooooool00ooo
o`030000oooooooo0<goool00`000?ooooooo`0Joooo00<0003oooooool00_ooo`030000oooooooo
0<goool00`000?ooooooo`0<oooo000?oooo00<0003oool000001?ooo`030000oooooooo0<goool0
0`000?ooooooo`0Ioooo00<0003oool000000oooo`030000oooooooo0<goool00`000?ooooooo`0<
oooo000@oooo00<0003oooooool00oooo`050000oooooooooooo0000037oool00`000?ooooooo`0_
oooo00<0003oooooool0;oooo`030000oooooooo02ooool01@000?ooooooooooo`00000Loooo00<0
003oooooool00_ooo`050000oooooooooooo0000037oool00`000?ooooooo`0_oooo00<0003ooooo
ool0;oooo`030000oooooooo02ooool01@000?ooooooooooo`00000>oooo000Fooood@00027ooooA
00003_ooo`00ooooonSoool00?oooooXoooo003oooooj?ooo`00ooooonSoool00?oooooXoooo003o
ooooj?ooo`00\
\>"],
  ImageRangeCache->{{{0, 486.875}, {231.313, 0}} -> {-0.0524277, -0.0238146, 
  0.0043232, 0.0043232}, {{12.125, 232.375}, {225.75, 
  5.5}} -> {-1.05592, -0.846127, 0.0399715, 0.0399715}, {{254.438, 474.688}, {
  225.75, 5.5}} -> {-10.7415, -0.846127, 0.0399715, 0.0399715}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(fourierWavelet[i, j, coif6]\)], "Input"],

Cell[BoxData[
    \({{0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.`, 0.`, 
        0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.236457782851115716`, 0.`, 0.`, 0.`, 
        0.`}, {0.`, 0.`, 0.0765974639642927979`, 0.253883546916906155`, 
        0.403291081236659731`, 0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 
        0.235364828340263354`, 0.`, 0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.`, 0.`, 
        0.`, 0.`, 0.`}, {0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`, 0.`}, {0.`, 0.`, 
        0.`, 0.`, 0.`, 0.`, 0.`, 0.`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(k = 
      ListDensityPlot[fourierWavelet[i, j, coif6], \n\t\tMesh -> False, 
        PlotLabel -> "\<difference\>", \n\t\tDisplayFunction -> Identity]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[i, Mesh -> False], 
          ListDensityPlot[j, Mesh -> False], k}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
000000FFFFFF00FF
00FF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -32 0 ]
[.5 1.0125 32 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -93 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(difference) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000000000
0000000000000000
0000009600000000
000030A1FF000000
0000009500000000
0000000000000000
0000000000000000
0000000000000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{560.188, 174.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008`0000[QP00`40o`000?l0003ooooooooooolb
oooo003ooooooooooc;oool00?oooooooooo<_ooo`00oooooooooolboooo003ooooooooooc;oool0
01_oool00`000?ooooooo`0Poooo0`0002?oool300008Oooo`80000Toooo00<0003oooooool08?oo
o`030000oooooooo027oool300008_ooo`<0000Qoooo0P0002Coool00`000?ooooooo`0Voooo00<0
003oooooool07_ooo`<0000Poooo0`0001goool200008Oooo`030000oooooooo01Woool001[oool0
0`000?ooo`00000Qoooo00<0003oooooool09?ooo`030000oooooooo023oool00`000?ooo`00000R
oooo00<0003oool000008?ooo`030000oooo000002;oool00`000?ooooooo`0Soooo00<0003ooooo
ool08?ooo`030000oooo000002;oool00`000?ooo`00000Voooo00<0003oool000007oooo`030000
oooooooo027oool00`000?ooooooo`0Loooo00<0003oool000007oooo`030000oooo000001[oool0
01[oool00`000?ooo`00000Roooo00<0003oooooool08Oooo`@0000Qoooo00<0003oool000008_oo
o`030000oooo0000023oool00`000?ooo`00000Soooo00<0003oooooool08?ooo`@0000Qoooo00<0
003oool000008_ooo`030000oooo000002Koool00`000?ooo`00000Poooo00<0003oooooool07_oo
o`@0000Moooo00<0003oool000007oooo`030000oooo000001[oool001[oool00`000?ooo`00000R
oooo00<0003oooooool08Oooo`030000oooo000002;oool200009?ooo`030000oooooooo01ooool0
0`000?ooo`00000Soooo00<0003oooooool08?ooo`030000oooo000002;oool200009?ooo`030000
oooooooo02Goool00`000?ooo`00000Poooo00<0003oooooool07_ooo`030000oooo000001koool2
00008Oooo`030000oooooooo01Woool001[oool00`000?ooo`00000Qoooo00<0003oool000008ooo
o`80000Roooo00<0003oooooool08_ooo`030000oooo0000023oool00`000?ooo`00000Roooo00<0
003oool000008_ooo`80000Roooo00<0003oooooool08_ooo`030000oooo000002Koool00`000?oo
o`00000Ooooo00<0003oool000008?ooo`80000Noooo00<0003oooooool07oooo`030000oooo0000
01[oool001_oool00`000?ooooooo`0Qoooo00<0003oooooool08oooo`030000oooooooo027oool2
00008oooo`030000oooooooo023oool00`000?ooooooo`0Roooo00<0003oooooool08_ooo`030000
oooooooo027oool200008oooo`030000oooooooo02Koool00`000?ooooooo`0Ooooo00<0003ooooo
ool08?ooo`030000oooooooo01goool200008?ooo`030000oooooooo01Woool00?oooooooooo<_oo
o`00oooooooooolboooo003ooooooooooc;oool00?oooooooooo<_ooo`006?oooiX0000LooooV`00
01goool00`000?ooooooo`02ooooS@0001Soool001?oool00`000?ooooooo`02oooo00@0003ooooo
ool0000Toooo00<0003oooooool08_ooo`030000oooooooo02;oool00`000?ooooooo`0Qoooo00@0
003oooooool0000Goooo00<0003oooooool00_ooo`040000oooooooo00009?ooo`030000oooooooo
02;oool00`000?ooooooo`0Roooo00<0003oooooool08_ooo`040000oooooooo00007?ooo`030000
oooo000000?oool00`000?ooooooo`29oooo00<0003oooooool05_ooo`004_ooo`030000oooo0000
00?oool00`000?ooooooo`2Foooo00<0003oooooool05?ooo`030000oooo000000?oool00`000?oo
ooooo`2Goooo00<0003oooooool06_ooo`030000oooo000000?oool20000ROooo`80000Hoooo000B
oooo00<0003oool000000oooo`80002Foooo0P0001Koool00`000?ooo`000003oooo0P0009Ooool2
00007?ooo`030000oooo000000?oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool0
01;oool00`000?ooo`000003oooo00<0003oooooool04_oooa<0000Uoooo=`0001Goool00`000?oo
ooooo`0Doooo00<0003oool000000oooo`030000oooooooo01?ooolB00009OooocP0000Eoooo00<0
003oooooool06_ooo`030000oooo000000?oool00`000?ooooooo`2600000oooo`030000oooooooo
01Koool001;oool00`000?ooo`000003oooo00<0003oooooool04_oooa<0000Uoooo=`0001Goool0
0`000?ooooooo`0Doooo00<0003oool000000oooo`030000oooooooo01?ooolB00009OooocP0000E
oooo00<0003oooooool06oooo`030000oooooooo00;oool00`000?ooooooo`2600000oooo`030000
oooooooo01Koool001?oool00`000?ooooooo`02oooo00<0003oooooool04_oooa<0000Uoooo=`00
01Goool00`000?ooooooo`0Eoooo00<0003oooooool00_ooo`030000oooooooo01?ooolB00009Ooo
ocP0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_oo
o`006?ooo`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0003oooooool06_ooo`030000
oooooooo01?ooolB00009OooocP0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003
oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0
003oooooool06_ooo`030000oooooooo01?ooolB00009OooocP0000Eoooo00<0003oooooool08?oo
o`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC
00009OooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01?ooolB00009OooocP0000E
oooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?oo
o`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo
01?ooolB00009OooocP0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0
003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0003ooooo
ool06_ooo`030000oooooooo01?ooolB00009OooocP0000Eoooo00<0003oooooool08?ooo`030000
oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`80000Coooo4`0002Gooolg00005Ooo
o`030000oooooooo01[oool200005?oooa80000Uoooo>00001Coool200008_ooo`030000oooooooo
08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC00009OooocL0000E
oooo00<0003oooooool06_ooo`030000oooooooo01?ooolB00009OooocP0000Eoooo00<0003ooooo
ool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
01;ooolC00009OooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01?ooolB00009Ooo
ocP0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_oo
o`006?ooo`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0003oooooool06_ooo`030000
oooooooo01?ooolB00009OooocP0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003
oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0
003oooooool06_ooo`030000oooooooo01?ooolB00009OooocP0000Eoooo00<0003oooooool08?oo
o`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC
00009OooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01?ooolB00009OooocP0000E
oooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?oo
o`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo
01?ooolB00009OooocP0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0
003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC00009OooocL0000Eoooo00<0003ooooo
ool06_ooo`030000oooooooo01?ooolB00009OooocP0000Eoooo00<0003oooooool08?ooo`030000
oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC00009Ooo
ocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01?ooolB00009OooocP0000Eoooo00<0
003oooooool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`80000C
oooo4`0002Gooolg00005Oooo`030000oooooooo01[oool200005?oooa80000Uoooo>00001Coool2
00008_ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
02D00019oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool0>00003OooolC00005Ooo
o`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool001Soool0
0`000?ooooooo`0U0000BOoooa<0000Eoooo00<0003oooooool06_ooo`030000oooooooo03P0000g
oooo4`0001Goool00`000?ooooooo`0Poooo00<0003oooooool0QP0000?oool00`000?ooooooo`0F
oooo000Hoooo00<0003oooooool09@0004WooolC00005Oooo`030000oooooooo01[oool00`000?oo
ooooo`0h0000=ooooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0
003oooooool05_ooo`006?ooo`030000oooooooo02D00019oooo4`0001Goool00`000?ooooooo`0J
oooo00<0003oooooool0>00003OooolC00005Oooo`030000oooooooo023oool00`000?ooooooo`26
00000oooo`030000oooooooo01Koool001Soool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0
003oooooool06_ooo`030000oooooooo03P0000goooo4`0001Goool00`000?ooooooo`0Poooo00<0
003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool09@0004WooolC
00005Oooo`030000oooooooo01[oool00`000?ooooooo`0h0000=ooooa<0000Eoooo00<0003ooooo
ool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
02D00019oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool0>00003OooolC00005Ooo
o`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool001Soool0
0`000?ooooooo`0U0000BOoooa<0000Eoooo00<0003oooooool06_ooo`030000oooooooo03P0000g
oooo4`0001Goool00`000?ooooooo`0Poooo00<0003oooooool0QP0000?oool00`000?ooooooo`0F
oooo000Hoooo0P000003oooo0000000002<00019oooo4`0001Goool00`000?ooooooo`0Joooo0P00
0003oooo0000000003H0000goooo4`0001Coool200008_ooo`030000oooooooo08H00003oooo00<0
003oooooool05_ooo`006?ooo`030000oooooooo02D00019oooo4`0001Goool00`000?ooooooo`0J
oooo00<0003oooooool0>00003OooolC00005Oooo`030000oooooooo023oool00`000?ooooooo`26
00000oooo`030000oooooooo01Koool001Soool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0
003oooooool06_ooo`030000oooooooo03P0000goooo4`0001Goool00`000?ooooooo`0Poooo00<0
003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool09@0004WooolC
00005Oooo`030000oooooooo01[oool00`000?ooooooo`0h0000=ooooa<0000Eoooo00<0003ooooo
ool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
02D00019oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool0>00003OooolC00005Ooo
o`030000oooooooo01[oool300000oooo`030000oooooooo08H00003oooo00<0003oooooool05_oo
o`006?ooo`030000oooooooo02D00019oooo4`0001Goool00`000?ooooooo`0Joooo00<0003ooooo
ool0>00003OooolC00005Oooo`030000oooooooo01[oool00`000?ooooooo`03oooo00<0003ooooo
ool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool09@0004WooolC00005Ooo
o`030000oooooooo01[oool00`000?ooooooo`0h0000=ooooa<0000Eoooo00<0003oooooool06ooo
o`030000oooooooo00;oool2000000?oool000000000Q00000;oool200006?ooo`004_ooo`<00003
oooo00<0003oooooool09@0004WooolC00005Oooo`030000oooooooo01Coool300000oooo`030000
oooooooo03P0000goooo4`0001Goool00`000?ooooooo`0Koooo00<0003oooooool00_ooo`030000
oooooooo0380000AUYJF@`0000?oool00`000?ooooooo`0Foooo000Boooo00<0003oooooool00ooo
o`030000oooooooo02D00019oooo4`0001Goool00`000?ooooooo`0Doooo00<0003oooooool00ooo
o`030000oooooooo03P0000goooo4`0001Goool00`000?ooooooo`0Joooo00<0003oool000000ooo
o`030000oooooooo0380000AUYJF@`0000?oool00`000?ooooooo`0Foooo000Coooo00<0003ooooo
ool00_ooo`8000000oooo`000000000S0000BOoooa<0000Doooo0P0001Ooool00`000?ooooooo`02
oooo0P000003oooo0000000003H0000goooo4`0001Coool200007Oooo`030000oooooooo00;oool0
0`000?ooooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`004oooo`030000oooooooo
00;oool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0003oooooool05Oooo`030000oooooooo
00;oool00`000?ooooooo`0h0000=ooooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo
0380000AUYJF@`0000?oool00`000?ooooooo`0Foooo000Boooo00<0003oool000000oooo`030000
oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool05?ooo`030000oooo000000?oool0
0`000?ooooooo`0C00004_oooa<0000Boooo>00001Goool00`000?ooooooo`0Poooo00<0003ooooo
ool0<P00016FUYI300000oooo`030000oooooooo01Koool001?oool00`000?ooooooo`02oooo00<0
003oooooool09Ooooa80000Coooo=`0001Goool00`000?ooooooo`0Eoooo00<0003oooooool00_oo
o`030000oooooooo01<0000Boooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?oo
ooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02GooolB
00004oooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01<0000Boooo4`0001;ooolh
00005Oooo`030000oooooooo023oool00`000?ooooooo`0b00004IJFUT<00003oooo00<0003ooooo
ool05_ooo`006?ooo`030000oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool06_oo
o`030000oooooooo01<0000Boooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?oo
ooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02GooolB
00004oooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01<0000Boooo4`0001;ooolh
00005Oooo`030000oooooooo023oool00`000?ooooooo`0b00004IJFUT<00003oooo00<0003ooooo
ool05_ooo`006?ooo`030000oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool06_oo
o`030000oooooooo01<0000Boooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?oo
ooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02GooolB
00004oooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01<0000Boooo4`0001;ooolh
00005Oooo`030000oooooooo023oool00`000?ooooooo`0b00004IJFUT<00003oooo00<0003ooooo
ool05_ooo`006?ooo`030000oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool06_oo
o`030000oooooooo01<0000Boooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?oo
ooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`006?ooo`80000Voooo4P0001?ooolg
00005Oooo`030000oooooooo01[oool2000000?oool0000000004@0001;ooolC00004_ooocP0000D
oooo0P0002;oool00`000?ooooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`006?oo
o`030000oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo
01<0000Boooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?ooooooo`0b00004IJF
UT<00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02GooolB00004oooocL0000E
oooo00<0003oooooool06_ooo`030000oooooooo01<0000Boooo4`0001;ooolh00005Oooo`030000
oooooooo023oool00`000?ooooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`006?oo
o`030000oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo
01<0000Boooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?ooooooo`0b00004IJF
UT<00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02GooolB00004oooocL0000E
oooo00<0003oooooool06_ooo`030000oooooooo01<0000Boooo4`0001;ooolh00005Oooo`030000
oooooooo023oool00`000?ooooooo`0b00004IJFUT<00003oooo00<0003oooooool05_ooo`006?oo
o`030000oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo
01<0000Boooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?ooooooo`0R0000430`
<16QXJ4Aoooo<P0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool09Ooooa80000C
oooo=`0001Goool00`000?ooooooo`0Joooo00<0003oooooool04`0001;ooolC00004_ooocP0000E
oooo00<0003oooooool08?ooo`030000oooooooo0280000@<30`4J6QXA7ooolb00000oooo`030000
oooooooo01Koool001Soool00`000?ooooooo`0Uoooo4P0001?ooolg00005Oooo`030000oooooooo
01[oool00`000?ooooooo`0C00004_oooa<0000Boooo>00001Goool00`000?ooooooo`0Poooo00<0
003oooooool08P00010`<30AXJ6Q4Ooooc800003oooo00<0003oooooool05_ooo`006?ooo`030000
oooooooo02GooolB00004oooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo01<0000B
oooo4`0001;ooolh00005Oooo`030000oooooooo023oool00`000?ooooooo`0R0000430`<16QXJ4A
oooo<P0000?oool00`000?ooooooo`0Foooo000Hoooo0P0002KooolB00004oooocL0000Eoooo00<0
003oooooool06_ooo`8000000oooo`000000000A00004_oooa<0000Boooo>00001Coool200008_oo
o`030000oooooooo0280000@<30`4J6QXA7ooolb00000oooo`030000oooooooo01Koool001Soool0
0`000?ooooooo`1:oooo4P0001;ooolU00000oooo`030000oooooooo01[oool00`000?ooooooo`1:
oooo4`0001;ooolU00000oooo`030000oooooooo023oool00`000?ooooooo`0R0000430`<16QXJ4A
oooo<P0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool0B_oooa80000Boooo9@00
00?oool00`000?ooooooo`0Joooo00<0003oooooool0B_oooa<0000Boooo9@0000?oool00`000?oo
ooooo`0Poooo00<0003oooooool08P00010`<30AXJ6Q4Ooooc800003oooo00<0003oooooool05_oo
o`006?ooo`030000oooooooo04[ooolB00004_ooobD00003oooo00<0003oooooool06_ooo`030000
oooooooo04[ooolC00004_ooobD00003oooo00<0003oooooool08?ooo`030000oooooooo0280000@
<30`4J6QXA7ooolb00000oooo`030000oooooooo01Koool001Soool00`000?ooooooo`1:oooo4P00
01;ooolU00000oooo`030000oooooooo01[oool00`000?ooooooo`1:oooo4`0001;ooolU00000ooo
o`030000oooooooo023oool00`000?ooooooo`0R0000430`<16QXJ4Aoooo<P0000?oool00`000?oo
ooooo`0Foooo000Hoooo00<0003oooooool0B_oooa80000Boooo9@0000?oool00`000?ooooooo`0J
oooo00<0003oooooool0B_oooa<0000Boooo9@0000?oool00`000?ooooooo`0Poooo00<0003ooooo
ool08P00010`<30AXJ6Q4Ooooc800003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
04[ooolB00004_ooobD00003oooo00<0003oooooool06_ooo`030000oooooooo04[ooolC00004_oo
obD00003oooo00<0003oooooool08?ooo`030000oooooooo0280000@<30`4J6QXA7ooolb00000ooo
o`030000oooooooo01Koool001Soool00`000?ooooooo`1:oooo4P0001;ooolU00000oooo`030000
oooooooo01[oool00`000?ooooooo`1:oooo4`0001;ooolU00000oooo`030000oooooooo023oool0
0`000?ooooooo`0R0000430`<16QXJ4Aoooo<P0000?oool00`000?ooooooo`0Foooo000Hoooo00<0
003oooooool0B_oooa80000Boooo9@0000?oool00`000?ooooooo`0Joooo00<0003oooooool0B_oo
oa<0000Boooo9@0000?oool00`000?ooooooo`0Poooo00<0003oooooool08P00010`<30AXJ6Q4Ooo
oc800003oooo00<0003oooooool05_ooo`006?ooo`80001;oooo4P0001;ooolU00000oooo`030000
oooooooo01[oool20000Booooa<0000Boooo9@0000;oool200008_ooo`030000oooooooo0280000@
<30`4J6QXA7ooolb00000oooo`030000oooooooo01Koool001Soool00`000?ooooooo`1:oooo4P00
01;ooolU00000oooo`030000oooooooo01[oool00`000?ooooooo`1:oooo4`0001;ooolU00000ooo
o`030000oooooooo01_oool300000_ooo`030000oooooooo0280000@<30`4J6QXA7ooolb00000ooo
o`030000oooooooo01Koool001Soool00`000?ooooooo`1:oooo4P0001;ooolU00000oooo`030000
oooooooo01[oool00`000?ooooooo`1:oooo4`0001;ooolU00000oooo`030000oooooooo01coool0
1@000?ooooooooooo`000002oooo8P00010`<30AXJ6Q4Ooooc800003oooo00<0003oooooool05_oo
o`006?ooo`030000oooooooo04[ooolB00004_ooobD00003oooo00<0003oooooool06_ooo`030000
oooooooo04[ooolC00004_ooobD00003oooo00<0003oooooool06_ooo`@00002oooo0P000003oooo
000000000200000@<30`4J6QXA7ooolb00000_ooo`80000Hoooo000Hoooo00<0003oooooool0B_oo
oa80000Boooo9@0000?oool00`000?ooooooo`0Joooo00<0003oooooool0B_oooa<0000Boooo9@00
00?oool00`000?ooooooo`0Joooo00<0003oool000000oooo`030000oooooooo0380000AUIFE@`00
00?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool0B_oooa80000Boooo9@0000?oool0
0`000?ooooooo`0Joooo00<0003oooooool0B_oooa<0000Boooo9@0000?oool00`000?ooooooo`0K
oooo0P0000?oool00`000?ooooooo`0b00004IFEUD<00003oooo00<0003oooooool05_ooo`006?oo
o`030000oooooooo04[ooolB00004_ooobD00003oooo00<0003oooooool06_ooo`030000oooooooo
04[ooolC00004_ooobD00003oooo00<0003oooooool07?ooo`050000oooooooooooo000000;ooolb
00004IFEUD<00003oooo00<0003oooooool05_ooo`004oooo`<00002oooo00<0003oooooool0B_oo
oa80000Boooo9@0000?oool00`000?ooooooo`0Eoooo0`0000;oool00`000?ooooooo`1:oooo4`00
01;ooolU00000oooo`030000oooooooo023oool00`000?ooooooo`0b00004IFEUD<00003oooo00<0
003oooooool05_ooo`005?ooo`050000oooooooooooo000004cooolB00004_ooobD00003oooo00<0
003oooooool05_ooo`050000oooooooooooo000004cooolC00004_ooobD00003oooo00<0003ooooo
ool08?ooo`030000oooooooo0380000AUIFE@`0000?oool00`000?ooooooo`0Foooo000Boooo1000
00;oool20000Booooa80000Boooo9@0000;oool200005_ooo`@00002oooo0P0004_ooolC00004_oo
obD00002oooo0P0002;oool00`000?ooooooo`0b00004IFEUD<00003oooo00<0003oooooool05_oo
o`004_ooo`030000oooo000000?oool00`000?ooooooo`1:oooo4P0001;ooolU00000oooo`030000
oooooooo01Coool00`000?ooo`000003oooo00<0003oooooool0B_oooa<0000Boooo9@0000?oool0
0`000?ooooooo`0Poooo00<0003oooooool0<P00016EUIE300000oooo`030000oooooooo01Koool0
01?oool200000oooo`030000oooooooo01;ooolC00009Ooooa80000Boooo4`0001Goool00`000?oo
ooooo`0Eoooo0P0000?oool00`000?ooooooo`0Coooo4P0002GooolC00004_oooa<0000Eoooo00<0
003oooooool08?ooo`030000oooooooo0380000AUIFE@`0000?oool00`000?ooooooo`0Foooo000D
oooo00D0003oooooooooool000005?oooa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo
01Koool01@000?ooooooooooo`00000Eoooo4P0002GooolC00004_oooa<0000Eoooo00<0003ooooo
ool08?ooo`030000oooooooo0380000AUIFE@`0000?oool00`000?ooooooo`0Foooo000Hoooo00<0
003oooooool04_oooa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?oo
ooooo`0Coooo4P0002GooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo
0380000AUIFE@`0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool04_oooa<0000U
oooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?ooooooo`0Coooo4P0002GooolC
00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo0380000AUIFE@`0000?oool0
0`000?ooooooo`0Foooo000Hoooo00<0003oooooool04_oooa<0000Uoooo4P0001;ooolC00005Ooo
o`030000oooooooo01[oool00`000?ooooooo`0Coooo4P0002GooolC00004_oooa<0000Eoooo00<0
003oooooool08?ooo`030000oooooooo0380000AUIFE@`0000?oool00`000?ooooooo`0Foooo000H
oooo00<0003oooooool04_oooa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo01[oool0
0`000?ooooooo`0Coooo4P0002GooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000
oooooooo0380000AUIFE@`0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool04_oo
oa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?ooooooo`0Coooo4P00
02GooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo0380000AUIFE@`00
00?oool00`000?ooooooo`0Foooo000Hoooo0P0001?ooolC00009Ooooa80000Boooo4`0001Goool0
0`000?ooooooo`0Joooo0P0001CooolB00009Ooooa<0000Boooo4`0001Coool200008_ooo`030000
oooooooo0380000AUIFE@`0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool04_oo
oa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?ooooooo`0Coooo4P00
02GooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo0380000AUIFE@`00
00?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool04_oooa<0000Uoooo4P0001;ooolC
00005Oooo`030000oooooooo01[oool00`000?ooooooo`0Coooo4P0002GooolC00004_oooa<0000E
oooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?oo
o`030000oooooooo01;ooolC00009Ooooa80000Boooo4`0001Goool00`000?ooooooo`0Joooo00<0
003oooooool04ooooa80000Uoooo4`0001;ooolC00005Oooo`030000oooooooo023oool00`000?oo
ooooo`2600000oooo`030000oooooooo01Koool001Soool00`000?ooooooo`0Boooo4`0002GooolB
00004_oooa<0000Eoooo00<0003oooooool06_ooo`030000oooooooo01?ooolB00009Ooooa<0000B
oooo4`0001Goool00`000?ooooooo`0Poooo00<0003oooooool0QP0000?oool00`000?ooooooo`0F
oooo000Hoooo00<0003oooooool04_oooa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo
01[oool00`000?ooooooo`0Coooo4P0002GooolC00004_oooa<0000Eoooo00<0003oooooool08?oo
o`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC
00009Ooooa80000Boooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool04ooooa80000U
oooo4`0001;ooolC00005Oooo`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000
oooooooo01Koool001Soool00`000?ooooooo`0Boooo4`0002GooolB00004_oooa<0000Eoooo00<0
003oooooool06_ooo`030000oooooooo01?ooolB00009Ooooa<0000Boooo4`0001Goool00`000?oo
ooooo`0Poooo00<0003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003ooooo
ool04_oooa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?ooooooo`0C
oooo4P0002GooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003
oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo01;ooolC00009Ooooa80000Boooo4`00
01Goool00`000?ooooooo`0Joooo00<0003oooooool04ooooa80000Uoooo4`0001;ooolC00005Ooo
o`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool001Soool2
00004ooooa<0000Uoooo4P0001;ooolC00005Oooo`030000oooooooo01[oool200005?oooa80000U
oooo4`0001;ooolC00005?ooo`80000Roooo00<0003oooooool0QP0000?oool00`000?ooooooo`0F
oooo000Hoooo00<0003oooooool09@0004WooolC00005Oooo`030000oooooooo01[oool00`000?oo
ooooo`0U0000B_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0
003oooooool05_ooo`006?ooo`030000oooooooo02D00019oooo4`0001Goool00`000?ooooooo`0J
oooo00<0003oooooool09@0004[ooolC00005Oooo`030000oooooooo023oool00`000?ooooooo`26
00000oooo`030000oooooooo01Koool001Soool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0
003oooooool06_ooo`030000oooooooo02D0001:oooo4`0001Goool00`000?ooooooo`0Poooo00<0
003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool09@0004WooolC
00005Oooo`030000oooooooo01[oool00`000?ooooooo`0U0000B_oooa<0000Eoooo00<0003ooooo
ool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
02D00019oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool09@0004[ooolC00005Ooo
o`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool001Soool0
0`000?ooooooo`0U0000BOoooa<0000Eoooo00<0003oooooool06_ooo`030000oooooooo02D0001:
oooo4`0001Goool00`000?ooooooo`0Joooo0P0000Coool00`000?ooooooo`2600000oooo`030000
oooooooo01Koool001Soool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0003oooooool06_oo
o`030000oooooooo02D0001:oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oool000000ooo
o`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02D00019
oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool09@0004[ooolC00005Oooo`030000
oooooooo01[oool00`000?ooo`000003oooo0P000003oooo0000000008@00002oooo0P0001Soool0
01Soool2000000?oool0000000008`0004WooolC00005Oooo`030000oooooooo01[oool2000000?o
ool0000000008`0004[ooolC00005?ooo`80000Loooo0P0000Coool00`000?ooooooo`2600000ooo
o`030000oooooooo01Koool001Soool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0003ooooo
ool06_ooo`030000oooooooo02D0001:oooo4`0001Goool00`000?ooooooo`0Joooo00<0003ooooo
ool00oooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
02D00019oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool09@0004[ooolC00005Ooo
o`030000oooooooo01_oool200000oooo`030000oooooooo08H00003oooo00<0003oooooool05_oo
o`006?ooo`030000oooooooo02D00019oooo4`0001Goool00`000?ooooooo`0Joooo00<0003ooooo
ool09@0004[ooolC00005Oooo`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000
oooooooo01Koool001Soool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0003oooooool06_oo
o`030000oooooooo02D0001:oooo4`0001Goool00`000?ooooooo`0Poooo00<0003oooooool0QP00
00?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool09@0004WooolC00005Oooo`030000
oooooooo01[oool00`000?ooooooo`0U0000B_oooa<0000Eoooo00<0003oooooool08?ooo`030000
oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02D00019oooo4`00
01Goool00`000?ooooooo`0Joooo00<0003oooooool09@0004[ooolC00005Oooo`030000oooooooo
023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool001;oool200001?ooo`030000
oooooooo02D00019oooo4`0001Goool00`000?ooooooo`0Doooo0P0000Coool00`000?ooooooo`0U
0000B_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0003ooooo
ool05_ooo`004_ooo`030000oooo000000?oool00`000?ooooooo`0U0000BOoooa<0000Eoooo00<0
003oooooool05?ooo`030000oooo000000?oool00`000?ooooooo`0U0000B_oooa<0000Eoooo00<0
003oooooool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`004_ooo`030000
oooo000000?oool2000000?oool0000000008`0004WooolC00005?ooo`80000Foooo00<0003oool0
00000oooo`8000000oooo`000000000S0000B_oooa<0000Doooo0P0002;oool00`000?ooooooo`26
00000oooo`030000oooooooo01Koool001;oool200001?ooo`030000oooooooo02GooolB00004ooo
oa80000Boooo4`0001Goool00`000?ooooooo`0Doooo0P0000Coool00`000?ooooooo`0Uoooo4`00
01;ooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0
003oooooool05_ooo`004_ooo`030000oooooooo00?oool00`000?ooooooo`0Uoooo4P0001?ooolB
00004_oooa<0000Eoooo00<0003oooooool05?ooo`030000oooooooo00?oool00`000?ooooooo`0U
oooo4`0001;ooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003
oooo00<0003oooooool05_ooo`004oooo`800003oooo00<0003oooooool09Ooooa80000Coooo4P00
01;ooolC00005Oooo`030000oooooooo01Goool200000oooo`030000oooooooo02GooolC00004_oo
oa<0000Boooo4`0001Goool00`000?ooooooo`0Poooo00<0003oooooool0QP0000?oool00`000?oo
ooooo`0Foooo000Hoooo00<0003oooooool09Ooooa80000Coooo4P0001;ooolC00005Oooo`030000
oooooooo01[oool00`000?ooooooo`0Uoooo4`0001;ooolC00004_oooa<0000Eoooo00<0003ooooo
ool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
02GooolB00004ooooa80000Boooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool09Ooo
oa<0000Boooo4`0001;ooolC00005Oooo`030000oooooooo023oool00`000?ooooooo`2600000ooo
o`030000oooooooo01Koool001Soool00`000?ooooooo`0Uoooo4P0001?ooolB00004_oooa<0000E
oooo00<0003oooooool06_ooo`030000oooooooo02GooolC00004_oooa<0000Boooo4`0001Goool0
0`000?ooooooo`0Poooo00<0003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0
003oooooool09Ooooa80000Coooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?oo
ooooo`0Uoooo4`0001;ooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo
08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02GooolB00004ooooa80000B
oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool09Ooooa<0000Boooo4`0001;ooolC
00005Oooo`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool0
01Soool200009_oooa80000Coooo4P0001;ooolC00005Oooo`030000oooooooo01[oool200009_oo
oa<0000Boooo4`0001;ooolC00005?ooo`80000Roooo00<0003oooooool0QP0000?oool00`000?oo
ooooo`0Foooo000Hoooo00<0003oooooool09Ooooa80000Coooo4P0001;ooolC00005Oooo`030000
oooooooo01[oool00`000?ooooooo`0Uoooo4`0001;ooolC00004_oooa<0000Eoooo00<0003ooooo
ool08?ooo`030000oooooooo08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo
02GooolB00004ooooa80000Boooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool09Ooo
oa<0000Boooo4`0001;ooolC00005Oooo`030000oooooooo023oool00`000?ooooooo`2600000ooo
o`030000oooooooo01Koool001Soool00`000?ooooooo`0Uoooo4P0001?ooolB00004_oooa<0000E
oooo00<0003oooooool06_ooo`030000oooooooo02GooolC00004_oooa<0000Boooo4`0001Goool0
0`000?ooooooo`0Poooo00<0003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0
003oooooool09Ooooa80000Coooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?oo
ooooo`0Uoooo4`0001;ooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo
08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo02GooolB00004ooooa80000B
oooo4`0001Goool00`000?ooooooo`0Joooo00<0003oooooool09Ooooa<0000Boooo4`0001;ooolC
00005Oooo`030000oooooooo023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool0
01Soool00`000?ooooooo`0Uoooo4P0001?ooolB00004_oooa<0000Eoooo00<0003oooooool06_oo
o`030000oooooooo02GooolC00004_oooa<0000Boooo4`0001Goool00`000?ooooooo`0Poooo00<0
003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool09Ooooa80000C
oooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?ooooooo`0Uoooo4`0001;ooolC
00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0003ooooo
ool05_ooo`006?ooo`030000oooooooo02GooolB00004ooooa80000Boooo4`0001Goool00`000?oo
ooooo`0Joooo00<0003oooooool09Ooooa<0000Boooo4`0001;ooolC00005Oooo`030000oooooooo
023oool00`000?ooooooo`2600000oooo`030000oooooooo01Koool001Soool200009_oooa80000C
oooo4P0001;ooolC00005Oooo`030000oooooooo01[oool200009_oooa<0000Boooo4`0001;ooolC
00005?ooo`80000Roooo00<0003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0
003oooooool09Ooooa80000Coooo4P0001;ooolC00005Oooo`030000oooooooo01[oool00`000?oo
ooooo`0Uoooo4`0001;ooolC00004_oooa<0000Eoooo00<0003oooooool08?ooo`030000oooooooo
08H00003oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo04[ooolg00005Oooo`030000
oooooooo01[oool00`000?ooooooo`2Goooo00<0003oooooool08?ooo`030000oooooooo08H00003
oooo00<0003oooooool05_ooo`006?ooo`030000oooooooo04[ooolg00005Oooo`030000oooooooo
01[oool00`000?ooooooo`2Goooo00<0003oooooool08?ooo`030000oooooooo08H00003oooo00<0
003oooooool05_ooo`006?ooo`030000oooooooo04[ooolg00005Oooo`030000oooooooo01[oool0
0`000?ooooooo`2Goooo00<0003oooooool06oooo`030000oooooooo00;oool00`000?ooooooo`26
00000oooo`030000oooooooo01Koool001Soool00`000?ooooooo`1:oooo=`0001Goool00`000?oo
ooooo`0Joooo00<0003oooooool0Uoooo`030000oooooooo01[oool00`000?ooo`000003oooo00<0
003oooooool0QP0000?oool00`000?ooooooo`0Foooo000Hoooo00<0003oooooool0B_ooocL0000E
oooo00<0003oooooool06_ooo`030000oooooooo09Ooool00`000?ooooooo`0Joooo00<0003oool0
00000oooo`8000000oooo`000000002400000_ooo`80000Hoooo000Hoooo00<0003oooooool0B_oo
ocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo09Ooool00`000?ooooooo`0Koooo00<0
003oooooool00_ooo`030000oooooooo08Woool00`000?ooooooo`0Foooo000Hoooo00<0003ooooo
ool0B_ooocL0000Eoooo00<0003oooooool06_ooo`030000oooooooo09Ooool00`000?ooooooo`0J
oooo00<0003oool000000oooo`040000oooooooo00001oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_oo
o`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`040000oooooooo00006?ooo`006?oo
o`030000oooooooo04[ooolg00005Oooo`030000oooooooo01[oool00`000?ooooooo`2Goooo00<0
003oooooool06oooo`030000oooooooo00;ooon=00006?ooo`006?ooo`80001;oooo=`0001Goool0
0`000?ooooooo`0Joooo0P0009Ooool20000aoooo`006?ooo`030000oooooooo04[ooolg00005Ooo
o`030000oooooooo01[oool00`000?ooooooo`2Goooo00<0003oooooool0aOooo`006?ooo`030000
oooooooo04[ooolg00005Oooo`030000oooooooo01[oool00`000?ooooooo`2Goooo00<0003ooooo
ool0aOooo`006?ooo`030000oooooooo04[ooolg00005Oooo`030000oooooooo01[oool00`000?oo
ooooo`2Goooo00<0003oooooool0aOooo`006?ooo`030000oooooooo04[ooolg00005Oooo`030000
oooooooo01[oool00`000?ooooooo`2Goooo00<0003oooooool0aOooo`006?ooo`030000oooooooo
04[ooolg00005Oooo`030000oooooooo01[oool00`000?ooooooo`2Goooo00<0003oooooool0B_oo
o`<000001?ooo`000000000000;oool300000_ooo`<00003oooo0P0000;oool300000oooo`800000
0oooo`0000000002oooo00<0003oool000000P0000?oool20000C?ooo`006?ooo`030000oooooooo
04[ooolg00005Oooo`030000oooooooo01[oool00`000?ooooooo`2Goooo00<0003oooooool0BOoo
o`040000oooooooo00000_ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00D0003ooooo
ooooool000001Oooo`050000oooooooooooo000000Coool01P000?ooooooo`000?ooo`0000Coool0
0`000?ooooooo`1<oooo000Coooo00<0003oooooool00_ooo`030000oooooooo04[ooolg00005Ooo
o`030000oooooooo01Goool00`000?ooooooo`02oooo00<0003oooooool0Uoooo`030000oooooooo
04Woool010000?ooooooo`0000;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`040000
oooooooooooo0`0000?oool010000?ooooooooooo`<00002oooo00H0003oooooool0003oool00004
oooo0`0004coool001;oool00`000?ooo`000003oooo00<0003oooooool0B_ooocL0000Eoooo00<0
003oooooool05?ooo`030000oooo000000?oool00`000?ooooooo`2Goooo00<0003oooooool0B_oo
o`<000000oooo`0000000003oooo0`0000;oool300000_ooo`<00002oooo10000005oooo00000000
0000oooo00@00002oooo0`0000;oool30000C?ooo`004_ooo`030000oooo000000?oool20000Booo
ocL0000Doooo0P0001Koool00`000?ooo`000003oooo0P0009Ooool20000C_ooo`030000oooooooo
00Goool00`000?ooooooo`02oooo00<0003oooooool0JOooo`004oooo`030000oooooooo00;oool0
0`000?ooooooo`2Foooo00<0003oooooool05Oooo`030000oooooooo00;oool00`000?ooooooo`2G
oooo00<0003oooooool0Boooo`800002oooo00<0003oooooool00oooo`030000oooooooo00;oool0
0`000?ooooooo`1Xoooo000Boooo00<0003oool000000oooo`040000oooooooo00002?ooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01_ooo`030000oooooooo00Koool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`06
oooo00<0003oooooool01_ooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Koool00`000?ooooooo`06oooo00<0003oooooool01_ooo`040000
oooooooo00005_ooo`030000oooo000000?oool010000?ooooooo`0000Woool00`000?ooooooo`06
oooo00<0003oooooool01_ooo`030000oooooooo00Koool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`06oooo00<0003oooooool01_ooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Koool0
0`000?ooooooo`06oooo00<0003oooooool01_ooo`030000oooooooo00Ooool010000?ooooooo`00
0<Ooool001?oool00`000?ooooooo`02ooooVP0001Ooool00`000?ooooooo`02ooooV`000<Ooool0
0?oooooooooo<_ooo`00oooooooooolboooo003ooooooooooc;oool00?oooooooooo<_ooo`00oooo
oooooolboooo0000\
\>"],
  ImageRangeCache->{{{0, 559.188}, {173.938, 0}} -> {-0.0823376, -0.0234425, 
  0.00565942, 0.00565942}, {{14.5, 180.188}, {169.75, 
  4.125}} -> {-1.49972, -0.980446, 0.0543245, 0.0543245}, {{196.75, 
  362.375}, {169.75, 4.125}} -> {-11.3987, -0.980446, 0.0543245, 
  0.0543245}, {{378.938, 544.625}, {169.75, 4.125}} -> {-23.6166, -1.0464, 
  0.059326, 0.059326}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell["\<\
fourierWavelet2[sample_,test_,base_]:=
\tModule[{n,m,wMatrix,varyPartSpect,partSpect,testFourier},
\t\tn=Length[sample];
\t\tm=Ceiling[Log[2.,Length[Transpose[base]]]]-1;
\t\twMatrix=waveletMatrix[n,base];
\t\ttestFourier=Fourier[test];
\t\tvaryPartSpect=
\t\t\twMatrix.Re[InverseFourier[
\t\t\t\t(imageNormalize[Abs[testFourier]]-
\t\t\t\t\timageNormalize[Abs[Fourier[sample]]])*
\t\t\t\t\ttestFourier]].Transpose[wMatrix];
\t\t\timageNormalize[Transpose[wMatrix].varyPartSpect.wMatrix]
\t];\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell[BoxData[
    \(fourierWavelet2[i, j, coif6]\)], "Input"],

Cell[BoxData[
    \({{0.199208881723151627`, 0.748681818276387112`, 0.201672101516985868`, 
        0.0923156059181869892`, 0.612498306271402359`, 0.551279569201000718`, 
        0.793024134798370994`, 0.384936759571151867`}, {
        0.507420673106621045`, 0.755113230195172135`, 0.197716034195085743`, 
        0.132978356566717104`, 0.`, 0.0943281541168579273`, 
        0.66118776295595607`, 0.271007101874933997`}, {0.03465915017792216`, 
        0.3415469678488106`, 0.204950842740755057`, 0.144987407566690373`, 
        0.518597585446626396`, 0.496795580631826894`, 0.390169014700936465`, 
        0.189332696414354408`}, {0.279201842813138245`, 
        0.334265987632765382`, 0.231045856263710946`, 0.3426558628017911`, 
        0.74283709321978586`, 0.639336899577388173`, 0.937423989730709728`, 
        0.69289720219347668`}, {0.263570035418721815`, 0.648964207376166779`, 
        0.026590918922944704`, 0.169968461510333419`, 0.631357506950609081`, 
        0.299798089540764536`, 0.933529646016097736`, 
        0.471803127425465973`}, {0.632262103679321807`, 
        0.866149216663977838`, 0.300138160525269359`, 0.305754177514127034`, 
        0.240488256564119051`, 0.260258587076426195`, 0.578006649745550227`, 
        0.441160111868206339`}, {0.31077578687897871`, 0.59815192520880096`, 
        0.441716230536828291`, 0.363918396319926529`, 0.504529476605435966`, 
        0.495174752494940317`, 0.667320822722413531`, 
        0.491383302115431064`}, {0.338677159073303002`, 0.63004800696465022`, 
        0.37300651178291746`, 0.646753627362760408`, 0.953860854260426371`, 
        0.871779363854904509`, 1.`, 0.570935247224866415`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(k2 = 
      ListDensityPlot[fourierWavelet2[i, j, coif6], \n\t\tMesh -> False, 
        PlotLabel -> "\<difference\>", \n\t\tDisplayFunction -> Identity]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[i, Mesh -> False], 
          ListDensityPlot[j, Mesh -> False], k2}]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
000000FFFFFF00FF
00FF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -32 0 ]
[.5 1.0125 32 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -93 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(difference) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
32BF33179C8DCB62
81C132220018A945
08573425847F6330
47553B57BEA3EFB1
43A6062BA14CEE78
A1DD4C4E3D429370
4F99715D817EAA7D
56A15FA5F4DFFF92
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{515.188, 160.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000830000X1P00`40o`000?l0003oooooooooool5
oooo003oooooooooo`Goool00?oooooooooo1Oooo`00ooooooooool5oooo000Ioooo00<0003ooooo
ool07_ooo`<0000Ooooo0`0001koool200008?ooo`030000oooooooo01ooool00`000?ooooooo`0M
oooo0`00023oool300007Oooo`80000Qoooo00<0003oooooool09?ooo`030000oooooooo01_oool3
00007?ooo`<0000Koooo0P0001goool00`000?ooooooo`0Hoooo000Hoooo00<0003oool000007ooo
o`030000oooooooo023oool00`000?ooooooo`0Moooo00<0003oool000007_ooo`030000oooo0000
01ooool00`000?ooo`00000Noooo00<0003oooooool08Oooo`030000oooooooo01coool00`000?oo
o`00000Ooooo00<0003oool000009?ooo`030000oooo000001coool00`000?ooooooo`0Moooo00<0
003oooooool06_ooo`030000oooo000001_oool00`000?ooo`00000Ioooo000Hoooo00<0003oool0
00008?ooo`030000oooooooo01goool400007_ooo`030000oooo000001koool00`000?ooo`00000O
oooo00<0003oool000007oooo`030000oooooooo01koool400007Oooo`030000oooo000001ooool0
0`000?ooo`00000Toooo00<0003oool000007Oooo`030000oooooooo01[oool400006oooo`030000
oooo000001_oool00`000?ooo`00000Ioooo000Hoooo00<0003oool000008?ooo`030000oooooooo
01goool00`000?ooo`00000Ooooo0P00023oool00`000?ooooooo`0Noooo00<0003oool000007ooo
o`030000oooooooo01koool00`000?ooo`00000Noooo0P00027oool00`000?ooooooo`0Soooo00<0
003oool000007Oooo`030000oooooooo01[oool00`000?ooo`00000Loooo0P0001goool00`000?oo
ooooo`0Hoooo000Hoooo00<0003oool000007oooo`030000oooo000001ooool200007oooo`030000
oooooooo01koool00`000?ooo`00000Ooooo00<0003oool000007_ooo`030000oooo0000023oool2
00007_ooo`030000oooooooo01ooool00`000?ooo`00000Toooo00<0003oool000007?ooo`030000
oooo000001coool200007?ooo`030000oooooooo01_oool00`000?ooo`00000Ioooo000Ioooo00<0
003oooooool07oooo`030000oooooooo01ooool00`000?ooooooo`0Noooo0P0001ooool00`000?oo
ooooo`0Ooooo00<0003oooooool07_ooo`030000oooooooo023oool00`000?ooooooo`0Moooo0P00
023oool00`000?ooooooo`0Toooo00<0003oooooool07?ooo`030000oooooooo01coool00`000?oo
ooooo`0Koooo0P0001coool00`000?ooooooo`0Hoooo003oooooooooo`Goool00?oooooooooo1Ooo
o`00ooooooooool5oooo003oooooooooo`Goool001Oooon=00006_ooohd0000Loooo00<0003ooooo
ool00_oooh00000Goooo000Boooo00<0003oooooool00_ooo`040000oooooooo00001oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`040000
oooooooo00005_ooo`050000oooooooooooo000000;oool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Koool0
0`000?ooooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oool0
00006oooo`030000oooo000000?oool00`000?ooo`00000Noooo00<0003oooooool07?ooo`030000
oooooooo01_oool00`000?ooooooo`0Loooo00<0003oool000005oooo`004Oooo`030000oooo0000
00?oool00`000?ooooooo`29oooo00<0003oooooool04oooo`030000oooo000000;oool00`000?oo
ooooo`29oooo00<0003oooooool06Oooo`030000oooo000000?oool20000O?ooo`80000Goooo000A
oooo00<0003oool000000oooo`800029oooo0P0001Goool00`000?ooo`000002oooo0P0008Woool2
00006oooo`030000oooo000000?oool00`000?oooc8b<P0><S8b4;no_`lc<c<@5aLG3ibLW0n=SHd@
bl_;3f9RHP;oool00`000?ooooooo`0Eoooo000Aoooo00<0003oool000000oooo`030000oooooooo
017ooolA00008Ooooc80000Doooo00<0003oooooool04oooo`030000oooo000000;oool00`000?oo
ooooo`0Aoooo4@0002;ooolb00004oooo`030000oooooooo01Woool00`000?ooo`000003oooo00<0
003ooolb<S803S8b<Q2o_kl?<c<c41LG5`nLW9`?SHf=4<_;b`mRHV82oooo00<0003oooooool05Ooo
o`004Oooo`030000oooo000000?oool00`000?ooooooo`0Aoooo4@00027ooolb00005?ooo`030000
oooooooo01?oool00`000?ooo`000002oooo00<0003oooooool04Ooooa40000Roooo<P0001?oool0
0`000?ooooooo`0Joooo00<0003oooooool00_ooo`030000oooo<S8b00hb<S8@_kno3c<c<a0G5aL?
W9bL3hf=SA3;bl/?HV9R0_ooo`030000oooooooo01Goool001;oool00`000?ooooooo`02oooo00<0
003oooooool04Ooooa40000Qoooo<P0001Coool00`000?ooooooo`0Doooo00D0003oooooooooool0
00004ooooa40000Roooo<P0001?oool00`000?ooooooo`0Ooooo00<0003ooolb<S803S8b<Q2o_kl?
<c<c41LG5`nLW9`?SHf=4<_;b`mRHV82oooo00<0003oooooool05Oooo`005oooo`030000oooooooo
017ooolA00008Ooooc80000Doooo00<0003oooooool06?ooo`030000oooooooo017ooolA00008_oo
oc80000Coooo00<0003oooooool07oooo`030000oooo<S8b00hb<S8@_kno3c<c<a0G5aL?W9bL3hf=
SA3;bl/?HV9R0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00027ooolb
00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Aoooo4@0002;ooolb00004oooo`030000
oooooooo01ooool00`000?oooc8b<P0><S8b4;no_`lc<c<@5aLG3ibLW0n=SHd@bl_;3f9RHP;oool0
0`000?ooooooo`0Eoooo000Goooo00<0003oooooool04Ooooa40000Qoooo<P0001Coool00`000?oo
ooooo`0Hoooo00<0003oooooool04Ooooa40000Roooo<P0001?oool00`000?ooooooo`0Ooooo00<0
003ooolb<S803S8b<Q2o_kl?<c<c41LG5`nLW9`?SHf=4<_;b`mRHV82oooo00<0003oooooool05Ooo
o`005oooo`030000oooooooo017ooolA00008Ooooc80000Doooo00<0003oooooool06?ooo`030000
oooooooo017ooolA00008_oooc80000Coooo00<0003oooooool07oooo`030000oooo<S8b00hb<S8@
_kno3c<c<a0G5aL?W9bL3hf=SA3;bl/?HV9R0_ooo`030000oooooooo01Goool001Ooool00`000?oo
ooooo`0Aoooo4@00027ooolb00004oooo`80000Joooo0P0001;ooolA00008_oooc80000Coooo00<0
003oooooool07oooo`030000oooo<S8b00hb<S8@_kno3c<c<a0G5aL?W9bL3hf=SA3;bl/?HV9R0_oo
o`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00027ooolb00005?ooo`030000
oooooooo01Soool00`000?ooooooo`0Aoooo4@0002;ooolb00004oooo`030000oooooooo01ooool0
0`000?oooc8b<P0><S8b4;no_`lc<c<@5aLG3ibLW0n=SHd@bl_;3f9RHP;oool00`000?ooooooo`0E
oooo000Goooo00<0003oooooool04Ooooa40000Qoooo<P0001Coool00`000?ooooooo`0Hoooo00<0
003oooooool04Ooooa40000Roooo<P0001?oool00`000?ooooooo`0Ooooo00<0003ooolb<S803S8b
<Q2o_kl?<c<c41LG5`nLW9`?SHf=4<_;b`mRHV82oooo00<0003oooooool05Oooo`005oooo`030000
oooooooo017ooolA00008Ooooc80000Doooo00<0003oooooool06?ooo`030000oooooooo017ooolA
00008_oooc80000Coooo00<0003oooooool07oooo`030000oooo<S8b00hb<S8@_kno3c<c<a0G5aL?
W9bL3hf=SA3;bl/?HV9R0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00
027ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Aoooo4@0002;ooolb00004ooo
o`030000oooooooo01ooool00`000?oooc8b<P0><S8b4;no_`lc<c<@5aLG3ibLW0n=SHd@bl_;3f9R
HP;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool04Ooooa40000Qoooo<P0001Coool0
0`000?ooooooo`0Hoooo00<0003oooooool04Ooooa40000Roooo<P0001?oool00`000?ooooooo`0O
oooo00<0003ooolb<S803S8b<Q2o_kl?<c<c41LG5`nLW9`?SHf=4<_;b`mRHV82oooo00<0003ooooo
ool05Oooo`005oooo`030000oooooooo017ooolA00008Ooooc80000Doooo00<0003oooooool06?oo
o`030000oooooooo017ooolA00008_oooc80000Coooo00<0003oooooool07oooo`030000oooo<S8b
00hb<S8@_kno3c<c<a0G5aL?W9bL3hf=SA3;bl/?HV9R0_ooo`030000oooooooo01Goool001Ooool0
0`000?ooooooo`0Aoooo4@00027ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`0A
oooo4@0002;ooolb00004oooo`030000oooooooo01ooool00`000?oooh61P@0>PH614<71`@lb<S8@
8R8R3`0000lH61P@ZJVY3dE5A@;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool04Ooo
oa40000Qoooo<P0001Coool00`000?ooooooo`0Hoooo00<0003oooooool04Ooooa40000Roooo<P00
01?oool00`000?ooooooo`0Ooooo00<0003ooon1PH403X61PA31`L4?<S8b428R8Pl0000?61PH4:VY
Z@m5ADD2oooo00<0003oooooool05Oooo`005oooo`030000oooooooo017ooolA00008Ooooc80000C
oooo0P0001[oool200004_oooa40000Roooo<P0001?oool00`000?ooooooo`0Ooooo00<0003ooon1
PH403X61PA31`L4?<S8b428R8Pl0000?61PH4:VYZ@m5ADD2oooo00<0003oooooool05Oooo`005ooo
o`030000oooooooo02800013oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool0<`00
03;ooolA00004oooo`030000oooooooo01ooool00`000?oooh61P@0>PH614<71`@lb<S8@8R8R3`00
00lH61P@ZJVY3dE5A@;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08P0004?oool@
00005?ooo`030000oooooooo01Soool00`000?ooooooo`0c0000<_oooa40000Coooo00<0003ooooo
ool07oooo`030000ooooPH6100j1PH4@`L713c8b<Q0R8R8?00003aPH612YZJT?ADE50_ooo`030000
oooooooo01Goool001Ooool00`000?ooooooo`0R0000@ooooa00000Doooo00<0003oooooool06?oo
o`030000oooooooo03<0000boooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooon1PH403X61
PA31`L4?<S8b428R8Pl0000?61PH4:VYZ@m5ADD2oooo00<0003oooooool05Oooo`005oooo`030000
oooooooo02800013oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool0<`0003;ooolA
00004oooo`030000oooooooo01ooool00`000?oooh61P@0>PH614<71`@lb<S8@8R8R3`0000lH61P@
ZJVY3dE5A@;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08P0004?oool@00005?oo
o`030000oooooooo01Soool00`000?ooooooo`0c0000<_oooa40000Coooo00<0003oooooool07ooo
o`030000ooooPH6100j1PH4@`L713c8b<Q0R8R8?00003aPH612YZJT?ADE50_ooo`030000oooooooo
01Goool001Ooool00`000?ooooooo`0R0000@ooooa00000Doooo00<0003oooooool06?ooo`030000
oooooooo03<0000boooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooon1PH403X61PA31`L4?
<S8b428R8Pl0000?61PH4:VYZ@m5ADD2oooo00<0003oooooool05Oooo`005oooo`030000oooooooo
02800013oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool0<`0003;ooolA00004ooo
o`030000oooooooo01ooool00`000?oooh61P@0>PH614<71`@lb<S8@8R8R3`0000lH61P@ZJVY3dE5
A@;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08P0004?oool@00004oooo`80000J
oooo0P000003oooo000000000340000boooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooon1
PH403X61PA31`L4?<S8b428R8Pl0000?61PH4:VYZ@m5ADD2oooo00<0003oooooool05Oooo`005ooo
o`030000oooooooo02800013oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool0<`00
03;ooolA00004oooo`030000oooooooo01ooool00`000?oooh61P@0>PH614<71`@lb<S8@8R8R3`00
00lH61P@ZJVY3dE5A@;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08P0004?oool@
00005?ooo`030000oooooooo01Soool00`000?ooooooo`0c0000<_oooa40000Coooo00<0003ooooo
ool07oooo`030000ooooPH6100j1PH4@`L713c8b<Q0R8R8?00003aPH612YZJT?ADE50_ooo`030000
oooooooo01Goool001Ooool00`000?ooooooo`0R0000@ooooa00000Doooo00<0003oooooool06?oo
o`030000oooooooo03<0000boooo4@0001?oool00`000?ooooooo`0Ioooo0`0000?oool00`000?oo
oh61P@0>PH614<71`@lb<S8@8R8R3`0000lH61P@ZJVY3dE5A@;oool00`000?ooooooo`0Eoooo000G
oooo00<0003oooooool08P0004?oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0c
0000<_oooa40000Coooo00<0003oooooool06Oooo`030000oooooooo00?oool00`000?oooh61P@0>
PH614<71`@lb<S8@8R8R3`0000lH61P@ZJVY3dE5A@;oool00`000?ooooooo`0Eoooo000Goooo00<0
003oooooool08P0004?oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0c0000<_oo
oa40000Coooo00<0003oooooool06_ooo`030000oooooooo00;oool200003h61PA31`L4?<S8b428R
8Pl0000?61PH4:VYZ@m5ADD00oooo`000000000Goooo000Aoooo0`0000?oool00`000?ooooooo`0R
0000@ooooa00000Doooo00<0003oooooool04oooo`<00002oooo00<0003oooooool0<`0003;ooolA
00004oooo`030000oooooooo01[oool00`000?ooooooo`02oooo00<0003oool820P03PP8211GEeL?
=3@d42DU9@n4Q8@?Ogmo46=SH`l`<302oooo00<0003oooooool05Oooo`004Oooo`030000oooooooo
00?oool00`000?ooooooo`0R0000@ooooa00000Doooo00<0003oooooool04oooo`030000oooooooo
00;oool00`000?ooooooo`0c0000<_oooa40000Coooo00<0003oooooool06Oooo`030000oooo0000
00?oool00`000?ooo`P8200>20P845MGE`ld=3@@9BDU3hB4Q0moOgl@Hf=S3c0`<0;oool00`000?oo
ooooo`0Eoooo000Boooo00<0003oooooool00_ooo`8000000oooo`000000000P0000@ooooa00000C
oooo0P0001Koool010000?ooooooooooo`8000000oooo`000000000a0000<_oooa40000Boooo0P00
01coool00`000?ooooooo`02oooo00<0003oool820P03PP8211GEeL?=3@d42DU9@n4Q8@?Ogmo46=S
H`l`<302oooo00<0003oooooool05Oooo`004_ooo`030000oooooooo00;oool00`000?ooooooo`0R
0000@ooooa00000Doooo00<0003oooooool05?ooo`050000oooooooooooo000000;ooolc0000<_oo
oa40000Coooo00<0003oooooool07oooo`030000oooo20P800h820P@EeMG3c@d=10U9BD?Q8B43gmo
Oa1SHf<?<30`0_ooo`030000oooooooo01Goool0017oool00`000?ooo`000003oooo00<0003ooooo
ool08_oooa00000Aoooo<P0001Coool00`000?ooooooo`0Coooo00<0003oool000000_ooo`030000
oooooooo0140000Aoooo4@00017ooolb00004oooo`030000oooooooo01ooool00`000?ooo`P8200>
20P845MGE`ld=3@@9BDU3hB4Q0moOgl@Hf=S3c0`<0;oool00`000?ooooooo`0Eoooo000Boooo00<0
003oooooool00_ooo`030000oooooooo02;oool@00004Ooooc80000Doooo00<0003oooooool05?oo
o`050000oooooooooooo000000;ooolA00004Ooooa40000Aoooo<P0001?oool00`000?ooooooo`0O
oooo00<0003oool820P03PP8211GEeL?=3@d42DU9@n4Q8@?Ogmo46=SH`l`<302oooo00<0003ooooo
ool05Oooo`005oooo`030000oooooooo02;oool@00004Ooooc80000Doooo00<0003oooooool06?oo
o`030000oooooooo0140000Aoooo4@00017ooolb00004oooo`030000oooooooo01ooool00`000?oo
o`P8200>20P845MGE`ld=3@@9BDU3hB4Q0moOgl@Hf=S3c0`<0;oool00`000?ooooooo`0Eoooo000G
oooo00<0003oooooool08_oooa00000Aoooo<P0001Coool00`000?ooooooo`0Hoooo00<0003ooooo
ool04@00017ooolA00004Ooooc80000Coooo00<0003oooooool07oooo`030000oooo20P800h820P@
EeMG3c@d=10U9BD?Q8B43gmoOa1SHf<?<30`0_ooo`030000oooooooo01Goool001Ooool00`000?oo
ooooo`0Roooo4000017ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`0A00004Ooo
oa40000Aoooo<P0001?oool00`000?ooooooo`0Ooooo00<0003oool820P03PP8211GEeL?=3@d42DU
9@n4Q8@?Ogmo46=SH`l`<302oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02;oool@
00004Ooooc80000Doooo00<0003oooooool06?ooo`030000oooooooo0140000Aoooo4@00017ooolb
00004oooo`030000oooooooo01ooool00`000?ooo`P8200>20P845MGE`ld=3@@9BDU3hB4Q0moOgl@
Hf=S3c0`<0;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08_oooa00000Aoooo<P00
01Coool00`000?ooooooo`0Hoooo00<0003oooooool04@00017ooolA00004Ooooc80000Coooo00<0
003oooooool07oooo`030000oooo20P800h820P@EeMG3c@d=10U9BD?Q8B43gmoOa1SHf<?<30`0_oo
o`030000oooooooo01Goool001Ooool00`000?ooooooo`0Roooo4000017ooolb00004oooo`80000J
oooo0P000003oooo0000000000l0000Aoooo4@00017ooolb00004oooo`030000oooooooo01ooool0
0`000?ooo`P8200>20P845MGE`ld=3@@9BDU3hB4Q0moOgl@Hf=S3c0`<0;oool00`000?ooooooo`0E
oooo000Goooo00<0003oooooool08_oooa00000Aoooo<P0001Coool00`000?ooooooo`0Hoooo00<0
003oooooool04@00017ooolA00004Ooooc80000Coooo00<0003oooooool07oooo`030000oooo20P8
00h820P@EeMG3c@d=10U9BD?Q8B43gmoOa1SHf<?<30`0_ooo`030000oooooooo01Goool001Ooool0
0`000?ooooooo`0Roooo4000017ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`0A
00004Ooooa40000Aoooo<P0001?oool00`000?ooooooo`0Ooooo00<0003oool820P03PP8211GEeL?
=3@d42DU9@n4Q8@?Ogmo46=SH`l`<302oooo00<0003oooooool05Oooo`005oooo`030000oooooooo
02;oool@00004Ooooc80000Doooo00<0003oooooool06?ooo`030000oooooooo0140000Aoooo4@00
017ooolb00004oooo`030000oooooooo01ooool00`000?ooo`P8200>20P845MGE`ld=3@@9BDU3hB4
Q0moOgl@Hf=S3c0`<0;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08_oooa00000A
oooo<P0001Coool00`000?ooooooo`0Hoooo00<0003oooooool04@00017ooolA00004Ooooc80000C
oooo00<0003oooooool07oooo`030000ooooAdM700i7AdL@EEEE3c/k>a1GEeL?_[jn3j>SXa3_knl?
/K6a0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Roooo4000017ooolb00005?oo
o`030000oooooooo01Soool00`000?ooooooo`0A00004Ooooa40000Aoooo<P0001?oool00`000?oo
ooooo`0Ooooo00<0003ooom7AdL03TM7Aa1EEED?>c/k45MGE`nn_[h?Xj>S4>o_k`na/K42oooo00<0
003oooooool05Oooo`005oooo`030000oooooooo02;oool@00004Ooooc80000Doooo00<0003ooooo
ool06?ooo`030000oooooooo0140000Aoooo4@00017ooolb00004oooo`030000oooooooo01ooool0
0`000?ooodM7A`0>AdM745EEE@lk>c/@EeMG3kjn_PnSXj<@kno_3k6a/@;oool00`000?ooooooo`0E
oooo000Goooo00<0003oooooool08_oooa00000Aoooo<P0001Coool00`000?ooooooo`0Hoooo00<0
003oooooool04@00017ooolA00004Ooooc80000Coooo00<0003oooooool07oooo`030000ooooAdM7
00i7AdL@EEEE3c/k>a1GEeL?_[jn3j>SXa3_knl?/K6a0_ooo`030000oooooooo01Goool001Ooool0
0`000?ooooooo`0Roooo4000017ooolb00004oooo`80000Joooo0P000003oooo0000000000l0000A
oooo4@00017ooolb00004oooo`030000oooooooo01ooool00`000?ooodM7A`0>AdM745EEE@lk>c/@
EeMG3kjn_PnSXj<@kno_3k6a/@;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool0@ooo
oa40000Aoooo8@0000?oool00`000?ooooooo`0Hoooo00<0003oooooool0A?oooa00000Aoooo8P00
00;oool00`000?ooooooo`0Ooooo00<0003ooom7AdL03TM7Aa1EEED?>c/k45MGE`nn_[h?Xj>S4>o_
k`na/K42oooo00<0003oooooool05Oooo`005oooo`030000oooooooo04?ooolA00004Oooob400003
oooo00<0003oooooool06?ooo`030000oooooooo04Coool@00004Oooob800002oooo00<0003ooooo
ool07oooo`030000ooooAdM700i7AdL@EEEE3c/k>a1GEeL?_[jn3j>SXa3_knl?/K6a0_ooo`030000
oooooooo01Goool001Ooool00`000?ooooooo`13oooo4@00017ooolQ00000oooo`030000oooooooo
01Soool00`000?ooooooo`14oooo4000017ooolR00000_ooo`030000oooooooo01ooool00`000?oo
odM7A`0>AdM745EEE@lk>c/@EeMG3kjn_PnSXj<@kno_3k6a/@;oool00`000?ooooooo`0Eoooo000G
oooo00<0003oooooool0@ooooa40000Aoooo8@0000?oool00`000?ooooooo`0Hoooo00<0003ooooo
ool0A?oooa00000Aoooo8P0000;oool00`000?ooooooo`0Ooooo00<0003ooom7AdL03TM7Aa1EEED?
>c/k45MGE`nn_[h?Xj>S4>o_k`na/K42oooo00<0003oooooool05Oooo`005oooo`030000oooooooo
04?ooolA00004Oooob400003oooo00<0003oooooool06?ooo`030000oooooooo04Coool@00004Ooo
ob800002oooo00<0003oooooool07oooo`030000ooooAdM700i7AdL@EEEE3c/k>a1GEeL?_[jn3j>S
Xa3_knl?/K6a0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`13oooo4@00017ooolQ
00000oooo`030000oooooooo01Soool00`000?ooooooo`14oooo4000017ooolR00000_ooo`030000
oooooooo01ooool00`000?ooodM7A`0>AdM745EEE@lk>c/@EeMG3kjn_PnSXj<@kno_3k6a/@;oool0
0`000?ooooooo`0Eoooo000Goooo00<0003oooooool0@ooooa40000Aoooo8@0000?oool00`000?oo
ooooo`0Hoooo00<0003oooooool0A?oooa00000Aoooo8P0000;oool00`000?ooooooo`0Ooooo00<0
003ooom7AdL03TM7Aa1EEED?>c/k45MGE`nn_[h?Xj>S4>o_k`na/K42oooo00<0003oooooool05Ooo
o`005oooo`030000oooooooo04?ooolA00004Oooob400003oooo00<0003oooooool06?ooo`030000
oooooooo04Coool@00004Oooob800002oooo00<0003oooooool07oooo`030000ooooAdM700i7AdL@
EEEE3c/k>a1GEeL?_[jn3j>SXa3_knl?/K6a0_ooo`030000oooooooo01Goool001Ooool00`000?oo
ooooo`13oooo4@00017ooolQ00000_ooo`80000Joooo0P0004Goool@00004Oooob800002oooo00<0
003oooooool06_ooo`<00002oooo00<0003ooom7AdL03TM7Aa1EEED?>c/k45MGE`nn_[h?Xj>S4>o_
k`na/K42oooo00<0003oooooool05Oooo`005oooo`030000oooooooo04?ooolA00004Oooob400003
oooo00<0003oooooool06?ooo`030000oooooooo04Coool@00004Oooob800002oooo00<0003ooooo
ool06oooo`060000oooooooooooo0000oooo3dM7Aa1EEED?>c/k45MGE`nn_[h?Xj>S4>o_k`na/K42
oooo00<0003oooooool05Oooo`005oooo`030000oooooooo04?ooolA00004Oooob400003oooo00<0
003oooooool06?ooo`030000oooooooo04Coool@00004Oooob800002oooo00<0003oooooool06Ooo
o`@00002oooo0P0000m7AdL@EEEE3c/k>a1GEeL?_[jn3j>SXa3_knl?/K6a00?oool0000000005ooo
o`005oooo`030000oooooooo04?ooolA00004Oooob400003oooo00<0003oooooool06?ooo`030000
oooooooo04Coool@00004Oooob800002oooo00<0003oooooool06Oooo`030000oooo000000?oool0
0`000?oood=3@`0>@d=34:JVYPl61PH@:b/[3j6QX@m<C4`@k^k^3gQhN0;oool00`000?ooooooo`0E
oooo000Goooo00<0003oooooool0@ooooa40000Aoooo8@0000?oool00`000?ooooooo`0Hoooo00<0
003oooooool0A?oooa00000Aoooo8P0000;oool00`000?ooooooo`0Joooo0P0000?oool00`000?oo
od=3@`0>@d=34:JVYPl61PH@:b/[3j6QX@m<C4`@k^k^3gQhN0;oool00`000?ooooooo`0Eoooo000G
oooo00<0003oooooool0@ooooa40000Aoooo8@0000?oool00`000?ooooooo`0Hoooo00<0003ooooo
ool0A?oooa00000Aoooo8P0000;oool00`000?ooooooo`0Koooo00H0003oooooooooool0003oool?
@d=34:JVYPl61PH@:b/[3j6QX@m<C4`@k^k^3gQhN0;oool00`000?ooooooo`0Eoooo000Boooo0`00
00;oool00`000?ooooooo`13oooo4@00017ooolQ00000oooo`030000oooooooo01Coool3000000?o
ool0003oool0AOoooa00000Aoooo8P0000;oool00`000?ooooooo`0Ooooo00<0003ooom3@d<03T=3
@a2VYZH?1PH642/[:`nQXJ4?C4a<4>k^kPmhN7P2oooo00<0003oooooool05Oooo`004oooo`050000
oooooooooooo000004GooolA00004Oooob400003oooo00<0003oooooool05Oooo`040000oooooooo
0000A_oooa00000Aoooo8P0000;oool00`000?ooooooo`0Ooooo00<0003ooom3@d<03T=3@a2VYZH?
1PH642/[:`nQXJ4?C4a<4>k^kPmhN7P2oooo00<0003oooooool05Oooo`004Oooo`@00002oooo0P00
04CooolA00004Oooob400002oooo0P0001Goool4000000?oool000000000AOoooa00000Aoooo8P00
0003oooo00000000027oool00`000?oood=3@`0>@d=34:JVYPl61PH@:b/[3j6QX@m<C4`@k^k^3gQh
N0;oool00`000?ooooooo`0Eoooo000Aoooo00<0003oool000000oooo`030000oooooooo017ooolA
00008Ooooa40000Aoooo400001Coool00`000?ooooooo`0Coooo00<0003oool000000_ooo`030000
oooooooo017ooolA00008_oooa00000Aoooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooom3
@d<03T=3@a2VYZH?1PH642/[:`nQXJ4?C4a<4>k^kPmhN7P2oooo00<0003oooooool05Oooo`004_oo
o`800003oooo00<0003oooooool04Ooooa40000Qoooo4@00017oool@00005?ooo`030000oooooooo
01Coool200000_ooo`030000oooooooo017ooolA00008_oooa00000Aoooo4@0001?oool00`000?oo
ooooo`0Ooooo00<0003ooom3@d<03T=3@a2VYZH?1PH642/[:`nQXJ4?C4a<4>k^kPmhN7P2oooo00<0
003oooooool05Oooo`004oooo`050000oooooooooooo000001?ooolA00008Ooooa40000Aoooo4000
01Coool00`000?ooooooo`0Eoooo00@0003oooooool0000Coooo4@0002;oool@00004Ooooa40000C
oooo00<0003oooooool07oooo`030000oooo@d=300i3@d<@YZJV3`H61Q0[:b/?XJ6Q3da<C13^k^h?
N7Qh0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00027ooolA00004Ooo
oa00000Doooo00<0003oooooool06?ooo`030000oooooooo017ooolA00008_oooa00000Aoooo4@00
01?oool00`000?ooooooo`0Ooooo00<0003ooom3@d<03T=3@a2VYZH?1PH642/[:`nQXJ4?C4a<4>k^
kPmhN7P2oooo00<0003oooooool05Oooo`005oooo`030000oooooooo017ooolA00008Ooooa40000A
oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool04Ooooa40000Roooo4000017ooolA
00004oooo`030000oooooooo01ooool00`000?oood=3@`0>@d=34:JVYPl61PH@:b/[3j6QX@m<C4`@
k^k^3gQhN0;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool04Ooooa40000Qoooo4@00
017oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Aoooo4@0002;oool@00004Ooo
oa40000Coooo00<0003oooooool07oooo`030000oooo@d=300i3@d<@YZJV3`H61Q0[:b/?XJ6Q3da<
C13^k^h?N7Qh0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00027ooolA
00004Ooooa00000Doooo00<0003oooooool06?ooo`030000oooooooo017ooolA00008_oooa00000A
oooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooom3@d<03T=3@a2VYZH?1PH642/[:`nQXJ4?
C4a<4>k^kPmhN7P2oooo00<0003oooooool05Oooo`005oooo`030000oooooooo017ooolA00008Ooo
oa40000Aoooo400001?oool200006_ooo`80000Boooo4@0002;oool@00004Ooooa40000Coooo00<0
003oooooool07oooo`030000oooo@d=300i3@d<@YZJV3`H61Q0[:b/?XJ6Q3da<C13^k^h?N7Qh0_oo
o`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00027ooolA00004Ooooa00000D
oooo00<0003oooooool06?ooo`030000oooooooo017ooolA00008_oooa00000Aoooo4@0001?oool0
0`000?ooooooo`0Ooooo00<0003ooom3@d<03T=3@a2VYZH?1PH642/[:`nQXJ4?C4a<4>k^kPmhN7P2
oooo00<0003oooooool05Oooo`005oooo`030000oooooooo017ooolA00008Ooooa40000Aoooo4000
01Coool00`000?ooooooo`0Hoooo00<0003oooooool04Ooooa40000Roooo4000017ooolA00004ooo
o`030000oooooooo01ooool00`000?oooj6QX@0>XJ6Q4=gMg@m<C4`@CTi>3cdm?@m2@T8@Ti>C3g1`
L0;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool04Ooooa40000Qoooo4@00017oool@
00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Aoooo4@0002;oool@00004Ooooa40000C
oooo00<0003oooooool07oooo`030000ooooXJ6Q00jQXJ4@gMgM3da<C11>CTh??Cdm3d92@Q2CTi<?
L71`0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00027ooolA00004Ooo
oa00000Doooo00<0003oooooool06?ooo`030000oooooooo017ooolA00008_oooa00000Aoooo4@00
01?oool00`000?ooooooo`0Ooooo00<0003ooonQXJ403Z6QXA3MgMd?C4a<44i>CPlm?Cd?@T9249>C
T`m`L702oooo00<0003oooooool05Oooo`005oooo`030000oooooooo017ooolA00008Ooooa40000A
oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool04Ooooa40000Roooo4000017ooolA
00004oooo`030000oooooooo01ooool00`000?oooj6QX@0>XJ6Q4=gMg@m<C4`@CTi>3cdm?@m2@T8@
Ti>C3g1`L0;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool04Ooooa40000Qoooo4@00
017oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Aoooo4@0002;oool@00004Ooo
oa40000Coooo00<0003oooooool07oooo`030000ooooXJ6Q00jQXJ4@gMgM3da<C11>CTh??Cdm3d92
@Q2CTi<?L71`0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Aoooo4@00027ooolA
00004Ooooa00000Doooo00<0003oooooool06?ooo`030000oooooooo017ooolA00008_oooa00000A
oooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooonQXJ403Z6QXA3MgMd?C4a<44i>CPlm?Cd?
@T9249>CT`m`L702oooo00<0003oooooool05Oooo`005oooo`030000oooooooo017ooolA00008Ooo
oa40000Aoooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool04Ooooa40000Roooo4000
017ooolA00004oooo`030000oooooooo01ooool00`000?oooj6QX@0>XJ6Q4=gMg@m<C4`@CTi>3cdm
?@m2@T8@Ti>C3g1`L0;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool04Ooooa40000Q
oooo4@00017oool@00004oooo`80000Joooo0P0001;ooolA00008_oooa00000Aoooo4@0001?oool0
0`000?ooooooo`0Ooooo00<0003ooonQXJ403Z6QXA3MgMd?C4a<44i>CPlm?Cd?@T9249>CT`m`L702
oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02800013oooo400001Coool00`000?oo
ooooo`0Hoooo00<0003oooooool08P0004?ooolA00004oooo`030000oooooooo01ooool00`000?oo
oj6QX@0>XJ6Q4=gMg@m<C4`@CTi>3cdm?@m2@T8@Ti>C3g1`L0;oool00`000?ooooooo`0Eoooo000G
oooo00<0003oooooool08P0004?oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0R
0000@ooooa40000Coooo00<0003oooooool07oooo`030000ooooXJ6Q00jQXJ4@gMgM3da<C11>CTh?
?Cdm3d92@Q2CTi<?L71`0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0R0000@ooo
oa00000Doooo00<0003oooooool06?ooo`030000oooooooo02800013oooo4@0001?oool00`000?oo
ooooo`0Ooooo00<0003ooonQXJ403Z6QXA3MgMd?C4a<44i>CPlm?Cd?@T9249>CT`m`L702oooo00<0
003oooooool05Oooo`005oooo`030000oooooooo02800013oooo400001Coool00`000?ooooooo`0H
oooo00<0003oooooool08P0004?ooolA00004oooo`030000oooooooo01ooool00`000?oooj6QX@0>
XJ6Q4=gMg@m<C4`@CTi>3cdm?@m2@T8@Ti>C3g1`L0;oool00`000?ooooooo`0Eoooo000Goooo00<0
003oooooool08P0004?oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0R0000@ooo
oa40000Coooo00<0003oooooool06Oooo`800004oooo00<0003ooonQXJ403Z6QXA3MgMd?C4a<44i>
CPlm?Cd?@T9249>CT`m`L702oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02800013
oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool08P0004?ooolA00004oooo`030000
oooooooo01Woool00`000?ooo`000003oooo00<0003ooonQXJ403Z6QXA3MgMd?C4a<44i>CPlm?Cd?
@T9249>CT`m`L702oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02800013oooo4000
01Coool00`000?ooooooo`0Hoooo00<0003oooooool08P0004?ooolA00004oooo`030000oooooooo
01Woool00`000?ooo`000003oooo0P0000nQXJ4@gMgM3da<C11>CTh??Cdm3d92@Q2CTi<?L71`00?o
ool0000000005oooo`005oooo`030000oooooooo02800013oooo400001?oool200006_ooo`800000
0oooo`000000000P0000@ooooa40000Coooo00<0003oooooool06Oooo`800004oooo00<0003ooom?
Cdl03Tm?Ca2IVIT?LG5a45eMG@n1PH4?OWin4:ZZZPmmOGd2oooo00<0003oooooool05Oooo`005ooo
o`030000oooooooo02800013oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool08P00
04?ooolA00004oooo`030000oooooooo01Woool00`000?ooooooo`03oooo00<0003ooom?Cdl03Tm?
Ca2IVIT?LG5a45eMG@n1PH4?OWin4:ZZZPmmOGd2oooo00<0003oooooool05Oooo`005oooo`030000
oooooooo02800013oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool08P0004?ooolA
00004oooo`030000oooooooo01[oool200000oooo`030000ooooCdm?00i?Cdl@VIVI3g5aLA1MGEd?
PH613ginOQ2ZZZX?OGem0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0R0000@ooo
oa00000Doooo00<0003oooooool06?ooo`030000oooooooo02800013oooo4@0001?oool00`000?oo
ooooo`0Ooooo00<0003ooom?Cdl03Tm?Ca2IVIT?LG5a45eMG@n1PH4?OWin4:ZZZPmmOGd2oooo00<0
003oooooool05Oooo`005oooo`030000oooooooo02800013oooo400001Coool00`000?ooooooo`0H
oooo00<0003oooooool08P0004?ooolA00004oooo`030000oooooooo01ooool00`000?ooodm?C`0>
Cdm?49VIV@maLG4@GEeM3h61P@mnOWh@ZZZZ3gemO@;oool00`000?ooooooo`0Eoooo000Goooo00<0
003oooooool08P0004?oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0R0000@ooo
oa40000Coooo00<0003oooooool07oooo`030000ooooCdm?00i?Cdl@VIVI3g5aLA1MGEd?PH613gin
OQ2ZZZX?OGem0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0R0000@ooooa00000D
oooo00<0003oooooool06?ooo`030000oooooooo02800013oooo4@0001?oool00`000?ooooooo`0O
oooo00<0003ooom?Cdl03Tm?Ca2IVIT?LG5a45eMG@n1PH4?OWin4:ZZZPmmOGd2oooo00<0003ooooo
ool05Oooo`004Oooo`800004oooo00<0003oooooool08P0004?oool@00005?ooo`030000oooooooo
01?oool200000oooo`030000oooooooo02800013oooo4@0001?oool00`000?ooooooo`0Ooooo00<0
003ooom?Cdl03Tm?Ca2IVIT?LG5a45eMG@n1PH4?OWin4:ZZZPmmOGd2oooo00<0003oooooool05Ooo
o`004Oooo`030000oooo000000?oool00`000?ooooooo`0R0000@ooooa00000Doooo00<0003ooooo
ool04oooo`030000oooo000000;oool00`000?ooooooo`0R0000@ooooa40000Coooo00<0003ooooo
ool07oooo`030000ooooCdm?00i?Cdl@VIVI3g5aLA1MGEd?PH613ginOQ2ZZZX?OGem0_ooo`030000
oooooooo01Goool0017oool00`000?ooo`000003oooo0P000003oooo0000000002000013oooo4000
01?oool200005Oooo`030000oooo000000;oool2000000?oool000000000800004?ooolA00004_oo
o`80000Qoooo00<0003ooom?Cdl03Tm?Ca2IVIT?LG5a45eMG@n1PH4?OWin4:ZZZPmmOGd2oooo00<0
003oooooool05Oooo`004Oooo`800004oooo00<0003oooooool08_oooa00000Aoooo4@00017oool@
00005?ooo`030000oooooooo01?oool200000oooo`030000oooooooo02;ooolA00004Ooooa00000A
oooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooom?Cdl03Tm?Ca2IVIT?LG5a45eMG@n1PH4?
OWin4:ZZZPmmOGd2oooo00<0003oooooool05Oooo`004Oooo`030000oooooooo00?oool00`000?oo
ooooo`0Roooo4000017ooolA00004Ooooa00000Doooo00<0003oooooool04oooo`030000oooooooo
00;oool00`000?ooooooo`0Roooo4@00017oool@00004Ooooa40000Coooo00<0003oooooool07ooo
o`030000ooooCdm?00i?Cdl@VIVI3g5aLA1MGEd?PH613ginOQ2ZZZX?OGem0_ooo`030000oooooooo
01Goool001;oool200000oooo`030000oooooooo02;oool@00004Ooooa40000Aoooo400001Coool0
0`000?ooooooo`0Doooo0P0000;oool00`000?ooooooo`0Roooo4@00017oool@00004Ooooa40000C
oooo00<0003oooooool07oooo`030000ooooCdm?00i?Cdl@VIVI3g5aLA1MGEd?PH613ginOQ2ZZZX?
OGem0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Roooo4000017ooolA00004Ooo
oa00000Doooo00<0003oooooool06?ooo`030000oooooooo02;ooolA00004Ooooa00000Aoooo4@00
01?oool00`000?ooooooo`0Ooooo00<0003ooom?Cdl03Tm?Ca2IVIT?LG5a45eMG@n1PH4?OWin4:ZZ
ZPmmOGd2oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02;oool@00004Ooooa40000A
oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool08_oooa40000Aoooo4000017ooolA
00004oooo`030000oooooooo01ooool00`000?ooodm?C`0>Cdm?49VIV@maLG4@GEeM3h61P@mnOWh@
ZZZZ3gemO@;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08_oooa00000Aoooo4@00
017oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Roooo4@00017oool@00004Ooo
oa40000Coooo00<0003oooooool07oooo`030000ooooCdm?00i?Cdl@VIVI3g5aLA1MGEd?PH613gin
OQ2ZZZX?OGem0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Roooo4000017ooolA
00004Ooooa00000Doooo00<0003oooooool06?ooo`030000oooooooo02;ooolA00004Ooooa00000A
oooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooomFEUH03UIFEQ2QXJ4?GemO4:FUY@odm?@?
gmoO4?ooo`nBTY82oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02;oool@00004Ooo
oa40000Aoooo400001?oool200006_ooo`80000Soooo4@00017oool@00004Ooooa40000Coooo00<0
003oooooool07oooo`030000ooooEUIF00iFEUH@XJ6Q3emOGa2UYJD?m?Cd3moOga3oool?TY:B0_oo
o`030000oooooooo01Goool001Ooool00`000?ooooooo`0Roooo4000017ooolA00004Ooooa00000D
oooo00<0003oooooool06?ooo`030000oooooooo02;ooolA00004Ooooa00000Aoooo4@0001?oool0
0`000?ooooooo`0Ooooo00<0003ooomFEUH03UIFEQ2QXJ4?GemO4:FUY@odm?@?gmoO4?ooo`nBTY82
oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02;oool@00004Ooooa40000Aoooo4000
01Coool00`000?ooooooo`0Hoooo00<0003oooooool08_oooa40000Aoooo4000017ooolA00004ooo
o`030000oooooooo01ooool00`000?oooeIFEP0>EUIF4:6QX@mOGel@YJFU3oCdm0oOgml@oooo3i:B
TP;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08_oooa00000Aoooo4@00017oool@
00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Roooo4@00017oool@00004Ooooa40000C
oooo00<0003oooooool07oooo`030000ooooEUIF00iFEUH@XJ6Q3emOGa2UYJD?m?Cd3moOga3oool?
TY:B0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Roooo4000017ooolA00004Ooo
oa00000Doooo00<0003oooooool06?ooo`030000oooooooo02;ooolA00004Ooooa00000Aoooo4@00
01?oool00`000?ooooooo`0Ooooo00<0003ooomFEUH03UIFEQ2QXJ4?GemO4:FUY@odm?@?gmoO4?oo
o`nBTY82oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02;oool@00004Ooooa40000A
oooo400001Coool00`000?ooooooo`0Hoooo00<0003oooooool08_oooa40000Aoooo4000017ooolA
00004oooo`030000oooooooo01ooool00`000?oooeIFEP0>EUIF4:6QX@mOGel@YJFU3oCdm0oOgml@
oooo3i:BTP;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool08_oooa00000Aoooo4@00
017oool@00005?ooo`030000oooooooo01Soool00`000?ooooooo`0Roooo4@00017oool@00004Ooo
oa40000Coooo00<0003oooooool07oooo`030000ooooEUIF00iFEUH@XJ6Q3emOGa2UYJD?m?Cd3moO
ga3oool?TY:B0_ooo`030000oooooooo01Goool001Ooool00`000?ooooooo`0Roooo4000017ooolA
00004Ooooa00000Doooo00<0003oooooool06?ooo`030000oooooooo02;ooolA00004Ooooa00000A
oooo4@0001?oool00`000?ooooooo`0Ooooo00<0003ooomFEUH03UIFEQ2QXJ4?GemO4:FUY@odm?@?
gmoO4?ooo`nBTY82oooo00<0003oooooool05Oooo`005oooo`030000oooooooo02;oool@00004Ooo
oa40000Aoooo400001?oool200006_ooo`80000Soooo4@00017oool@00004Ooooa40000Coooo00<0
003oooooool07oooo`030000ooooEUIF00iFEUH@XJ6Q3emOGa2UYJD?m?Cd3moOga3oool?TY:B0_oo
o`030000oooooooo01Goool001Ooool00`000?ooooooo`13oooo<P0001Coool00`000?ooooooo`0H
oooo00<0003oooooool0ROooo`030000oooooooo01ooool00`000?oooeIFEP0>EUIF4:6QX@mOGel@
YJFU3oCdm0oOgml@oooo3i:BTP;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool0@ooo
oc80000Doooo00<0003oooooool06?ooo`030000oooooooo08Woool00`000?ooooooo`0Ooooo00<0
003ooomFEUH03UIFEQ2QXJ4?GemO4:FUY@odm?@?gmoO4?ooo`nBTY82oooo00<0003oooooool05Ooo
o`005oooo`030000oooooooo04?ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`29
oooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?oooeIFEP0>EUIF4:6QX@mOGel@
YJFU3oCdm0oOgml@oooo3i:BTP;oool00`000?ooooooo`0Eoooo000Goooo00<0003oooooool0@ooo
oc80000Doooo00<0003oooooool06?ooo`030000oooooooo08Woool00`000?ooooooo`0Ioooo00<0
003oool000000oooo`030000ooooEUIF00iFEUH@XJ6Q3emOGa2UYJD?m?Cd3moOga3oool?TY:B0_oo
o`030000oooooooo01Goool001Ooool00`000?ooooooo`13oooo<P0001Coool00`000?ooooooo`0H
oooo00<0003oooooool0ROooo`030000oooooooo01Woool00`000?ooo`000003oooo0P0000mFEUH@
XJ6Q3emOGa2UYJD?m?Cd3moOga3oool?TY:B00?oool0000000005oooo`005oooo`030000oooooooo
04?ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`29oooo00<0003oooooool06_oo
o`030000oooooooo00;oool00`000?ooo`00000Noooo00<0003oooooool07?ooo`030000oooooooo
01_oool00`000?ooooooo`0Loooo00<0003oool000005oooo`005oooo`030000oooooooo04?ooolb
00005?ooo`030000oooooooo01Soool00`000?ooooooo`29oooo00<0003oooooool06Oooo`030000
oooo000000?ooon000005oooo`005oooo`030000oooooooo04?ooolb00005?ooo`030000oooooooo
01Soool00`000?ooooooo`29oooo00<0003oooooool06_ooo`030000oooooooo09Woool001Ooool0
0`000?ooooooo`13oooo<P0001?oool200006_ooo`80002:oooo00<0003oooooool0]_ooo`005ooo
o`030000oooooooo04?ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`29oooo00<0
003oooooool0]_ooo`005oooo`030000oooooooo04?ooolb00005?ooo`030000oooooooo01Soool0
0`000?ooooooo`29oooo00<0003oooooool0]_ooo`005oooo`030000oooooooo04?ooolb00005?oo
o`030000oooooooo01Soool00`000?ooooooo`29oooo00<0003oooooool0]_ooo`005oooo`030000
oooooooo04?ooolb00005?ooo`030000oooooooo01Soool00`000?ooooooo`29oooo00<0003ooooo
ool0]_ooo`005oooo`030000oooooooo04?ooolb00005?ooo`030000oooooooo01Soool00`000?oo
ooooo`29oooo00<0003oooooool0@oooo`<000001?ooo`000000000000;oool300000_ooo`<00003
oooo0P0000;oool300000oooo`8000000oooo`0000000002oooo00<0003oool000000P0000?oool2
0000A?ooo`004_ooo`030000oooooooo00;oool00`000?ooooooo`13oooo<P0001Coool00`000?oo
ooooo`0Doooo00D0003oooooooooool00000Roooo`030000oooooooo04;oool010000?ooooooo`00
00;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`050000oooooooooooo000000Goool0
1@000?ooooooooooo`000004oooo00H0003oooooool0003oool00004oooo00<0003oooooool0A?oo
o`004Oooo`030000oooo000000?oool00`000?ooooooo`13oooo<P0001Coool00`000?ooooooo`0C
oooo00<0003oool000000_ooo`030000oooooooo08Woool00`000?ooooooo`12oooo00@0003ooooo
ool00002oooo00<0003oooooool00_ooo`030000oooooooo00;oool010000?ooooooooooo`<00003
oooo00@0003oooooooooool300000_ooo`060000oooooooo0000oooo00001?ooo`<00014oooo000A
oooo00<0003oool000000oooo`800014oooo<P0001?oool200005Oooo`030000oooo000000;oool2
0000ROooo`800015oooo0`000003oooo0000000000?oool300000_ooo`<00002oooo0`0000;oool4
000000Goool000000000003oool0100000;oool300000_ooo`<00014oooo000Boooo00<0003ooooo
ool00_ooo`030000oooooooo08Woool00`000?ooooooo`0Doooo00D0003oooooooooool00000Rooo
o`030000oooooooo04Goool00`000?ooooooo`05oooo00<0003oooooool00_ooo`030000oooooooo
067oool0017oool00`000?ooo`000003oooo00@0003oooooool00007oooo00<0003oooooool01Ooo
o`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0
003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00@0003oooooool0000E
oooo00<0003oool000000_ooo`040000oooooooo00001oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0
003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo
00Koool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooo000004Koool200000_oo
o`030000oooooooo00?oool00`000?ooooooo`02oooo00<0003oooooool0H?ooo`004_ooo`030000
oooooooo00;ooon=00005_ooo`040000ooooooooooooS@000;Soool00?oooooooooo1Oooo`00oooo
ooooool5oooo003oooooooooo`Goool00?oooooooooo1Oooo`00ooooooooool5oooo0000\
\>"],
  ImageRangeCache->{{{0, 514.188}, {159.938, 0}} -> {-0.0823631, -0.0234425, 
  0.00615482, 0.00615482}, {{13.375, 165.688}, {156.125, 
  3.75}} -> {-1.54903, -1.02648, 0.0595075, 0.0595075}, {{180.875, 333.25}, {
  156.125, 3.75}} -> {-11.5184, -1.02648, 0.0595075, 0.0595075}, {{348.438, 
  500.75}, {156.125, 3.75}} -> {-23.977, -1.10133, 0.0653495, 0.0653495}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{734, 379},
WindowMargins->{{22, Automatic}, {Automatic, 52}},
ShowCellLabel->False
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 204, 4, 90, "Input"],
Cell[1916, 55, 65, 1, 30, "Input"],
Cell[1984, 58, 205, 4, 70, "Input"],
Cell[2192, 64, 63, 1, 30, "Input"],
Cell[2258, 67, 414, 12, 210, "Input"],
Cell[2675, 81, 80, 1, 30, "Input"],
Cell[2758, 84, 660, 18, 300, "Input"],
Cell[3421, 104, 190, 4, 30, "Input"],
Cell[3614, 110, 178, 4, 30, "Input"],
Cell[3795, 116, 86, 1, 30, "Input"],
Cell[3884, 119, 310, 10, 30, "Text",
  Evaluatable->False],
Cell[4197, 131, 385, 6, 110, "Input"],
Cell[4585, 139, 65, 1, 30, "Input"],
Cell[4653, 142, 413, 13, 152, "Input"],
Cell[5069, 157, 209, 6, 54, "Input"],
Cell[5281, 165, 360, 10, 110, "Input"],
Cell[5644, 177, 262, 8, 82, "Input"],
Cell[5909, 187, 62, 1, 30, "Input"],
Cell[5974, 190, 288, 4, 70, "Input"],
Cell[6265, 196, 288, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[6578, 204, 142, 3, 30, "Input"],
Cell[6723, 209, 44286, 1105, 268, 7942, 652, "GraphicsData", 
"PostScript", "Graphics"],
Cell[51014, 1317, 135, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51186, 1325, 60, 1, 30, "Input"],
Cell[51249, 1328, 514, 7, 86, "Output"]
}, Open  ]],
Cell[51778, 1338, 215, 4, 90, "Input"],

Cell[CellGroupData[{
Cell[52018, 1346, 145, 3, 30, "Input"],
Cell[52166, 1351, 48746, 1456, 194, 12848, 1009, "GraphicsData", 
"PostScript", "Graphics"],
Cell[100917, 2810, 135, 3, 29, "Output"]
}, Open  ]],
Cell[101067, 2816, 288, 4, 70, "Input"],
Cell[101358, 2822, 286, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[101669, 2830, 142, 3, 30, "Input"],
Cell[101814, 2835, 39891, 1051, 241, 7942, 652, "GraphicsData", 
"PostScript", "Graphics"],
Cell[141708, 3888, 135, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[141880, 3896, 60, 1, 30, "Input"],
Cell[141943, 3899, 515, 7, 86, "Output"]
}, Open  ]],
Cell[142473, 3909, 195, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[142693, 3917, 145, 3, 30, "Input"],
Cell[142841, 3922, 46674, 1432, 183, 12848, 1009, "GraphicsData", 
"PostScript", "Graphics"],
Cell[189518, 5356, 135, 3, 29, "Output"]
}, Open  ]],
Cell[189668, 5362, 542, 15, 246, "Input"],

Cell[CellGroupData[{
Cell[190235, 5381, 61, 1, 30, "Input"],
Cell[190299, 5384, 1674, 23, 162, "Output"]
}, Open  ]],
Cell[191988, 5410, 197, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[192210, 5418, 146, 3, 30, "Input"],
Cell[192359, 5423, 48429, 1452, 169, 12848, 1009, "GraphicsData", 
"PostScript", "Graphics"],
Cell[240791, 6877, 135, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

