(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    466580,      11835]*)
(*NotebookOutlinePosition[    467250,      11859]*)
(*  CellTagsIndexPosition[    467206,      11855]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
<<Utilities`MemoryConserve`
$MemoryIncrement=1000000;
<< LinearAlgebra`MatrixManipulation`;
Off[General::spell1,MemoryConserve::start,MemoryConserve::end];\
\>", "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", " ", 
      StyleBox["Data",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Cut",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
dataCutout=Compile[{{xOrigin,_Integer},{yOrigin,_Integer},
\t{xLength,_Integer},{yLength,_Integer},{dataMatrix, _Real, 2},
\t{marker,_Integer}},
\tModule[{i=0,j=0,xS=xOrigin-Ceiling[xLength/2],
\t\tyS=yOrigin-Ceiling[yLength/2],
\t\txL=xOrigin+Ceiling[xLength/2]-1,yL=yOrigin+
\t\tCeiling[yLength/2]-1,mark=0.,outMatrix={{0.}}},
\tmark=0.5 (Max[dataMatrix]+Min[dataMatrix]); 
\toutMatrix=Table[dataMatrix[[i,j]],{i,yS,yL},{j,xS,xL}];
\tIf[marker==1,
\t\tDo[outMatrix[[yL-yOrigin,j]]=mark,{j,xL-xOrigin-5,xL-xOrigin+5}];
\t\tDo[outMatrix[[i,xL-xOrigin]]=mark,{i,yL-yOrigin-5,yL-yOrigin+5}]];
\toutMatrix]];\
\>", "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Normalization",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(imageNormalize = 
      Compile[{{data2D, _Real, 2}}, \n\t\t
        Module[{minimum = Min[data2D]}, \n\t\t\t
          \((data2D - minimum)\)/Max[data2D - minimum]]]; \)\)], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Round",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Window",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
roundWin=Compile[{{xOrigin,_Integer},{yOrigin,_Integer},
\t{radius,_Integer},{dataMatrix, _Real, 2}},
\tModule[{i=0,j=0,k=0,win={{0.}},dim={0}},
\t\tdim=Table[Dimensions[dataMatrix][[i]],{i,2}];
\t\twin=Table[0.,{dim[[1]]},{dim[[2]]}];
\t\tDo[
\t\t\tj=Round[Sqrt[radius^2-i^2]];
\t\t\tDo[win[[yOrigin+i,k]]=1.,
\t\t\t{k,xOrigin-j,xOrigin+j}],
\t\t{i,-radius,radius}];
\t\twin dataMatrix]];\
\>", "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Difference",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Check",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["by",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
fourierWaveletDiff[sample_,test_,base_]:=
\tModule[{n,n2,m,highSol,lowSol,
\t\twMatrix,varyPartSpect,partSpect,testFourier},
\t\tn=Length[sample];n2=n/2;
\t\tm=Ceiling[Log[2.,Length[Transpose[base]]]]-1;
\t\twMatrix=waveletMatrix[n,base];
\t\ttestFourier=Fourier[test];
\t\tvaryPartSpect=
\t\t\twMatrix.Re[InverseFourier[
\t\t\t\t(imageNormalize[Abs[testFourier]]-
\t\t\t\t\timageNormalize[Abs[Fourier[sample]]])*
\t\t\t\t\t\ttestFourier]].Transpose[wMatrix];
\t\tpartSpect=varyPartSpect;
\t\t\tDo[partSpect[[i,j]]=0,{i,n2},{j,n2}];
\t\t\thighSol=
\t\t\t\timageNormalize[Transpose[wMatrix].partSpect.wMatrix];
\t\tpartSpect=ZeroMatrix[n];
\t\tDo[partSpect[[i,j]]=varyPartSpect[[i,j]],{i,2^m},{j,2^m}];
\t\t\tlowSol=
\t\t\t\timageNormalize[Transpose[wMatrix].partSpect.wMatrix];
\t\troundWin[n2,n2,n2-3,highSol+lowSol]
\t];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", " ", 
      StyleBox["Base",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Functions",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
daub2={{1.,1.},{1.,-1.}}/Sqrt[2.];
daub4={{1.+Sqrt[3.], 3.+Sqrt[3.],3.-Sqrt[3.], 1.-Sqrt[3.]},
\t{1.-Sqrt[3.],-3.+Sqrt[3.],3.+Sqrt[3.],-1.-Sqrt[3.]}}/
\t(4 Sqrt[2.]);
daub6={{ .332670552950, .806891509311, .459877502118,
\t\t-.135011020010, -.085441273882, .035226291882},
\t   { .035226291882, .085441273882,-.135011020010,
\t    -.459877502118,.806891509311,-.332670552950}};
daub8={{ 0.325803428051, 1.010945715092, 0.892200138246,
\t    -0.039575026236,-0.264507167369, 0.043616300475,
\t     0.046503601071,-0.014986989330},
\t   {-0.014986989330,-0.046503601071, 0.043616300475,
\t\t 0.264507167369,-0.039575026236,-0.892200138246,
\t\t 1.010945715092,-0.325803428051}}/Sqrt[2.];
daub10={{ .160102397974, .603829269797, .724308528438,
\t\t  .138428145901,-.242294887066,-.032244869585,
\t\t  .077571493840,-.006241490213,-.012580751999,
\t\t  .003335725285},
\t    { .003335725285, .012580751999,-.006241490213,
\t     -.077571493840,-.032244869585, .242294887066,
\t      .138428145901,-.724308528438, .603829269797,
\t     -.160102397974}};
daub12={{ 0.111540743350, 0.494623890398, 0.751133908021,
\t\t  0.315250351709,-0.226264693965,-0.129766867567,
\t\t  0.097501605587, 0.027522865530,-0.031582039318,
\t\t  0.000553842201, 0.004777257511,-0.001077301085},
\t\t{-0.001077301085,-0.004777257511, 0.000553842201,
\t\t  0.031582039318, 0.027522865530,-0.097501605587,
\t\t -0.129766867567, 0.226264693965, 0.315250351709,
\t\t -0.751133908021, 0.494623890398,-0.111540743350}};
daub14={{ .077852054085, .396539319482, .729132090846, 
 \t\t  .469782287405,-.143906003929,-.224036184994,
 \t\t  .071309219267, .080612609151,-.038029936935, 
\t\t -.016574541631, .012550998556, .000429577973, 
\t\t -.001801640704, .000353713800},
\t\t{ .000353713800, .001801640704, .000429577973, 
\t\t -.012550998556,-.016574541631, .038029936935,
\t\t  .080612609151,-.071309219267,-.224036184994,
\t\t  .143906003929, .469782287405,-.729132090846,
\t\t  .396539319482,-.077852054085}};
daub16={{ .054415842243, .312871590914, .675630736297, 
 \t\t  .585354683654,-.015829105256,-.284015542962,
 \t\t  .000472484574, .128747426620,-.017369301002, 
\t\t -.044088253931, .013981027917, .008746094047, 
\t\t -.004870352993,-.000391740373, .000675449406,
\t\t -.000117476784},
\t\t{-.000117476784,-.000675449406,-.000391740373,
\t\t  .004870352993, .008746094047,-.013981027917,
\t\t -.044088253931, .017369301002, .128747426620,
\t\t -.000472484574,-.284015542962, .015829105256,
\t\t  .585354683654,-.675630736297, .312871590914,
\t\t -.054415842243}};
daub18={{ .038077947364, .243834674613, .604823123690, 
 \t\t  .657288078051, .133197385825,-.293273783279, 
\t\t -.096840783223, .148540749338, .030725681479,
\t\t -.067632829061, .000250947115, .022361662124,
\t\t -.004723204758,-.004281503682, .001847646883,
          .000230385764,-.000251963189, .000039347320},
        { .000039347320, .000251963189, .000230385764,
         -.001847646883,-.004281503682, .004723204758,
          .022361662124,-.000250947115,-.067632829061,
         -.030725681479, .148540749338, .096840783223,
         -.293273783279,-.133197385825, .657288078051, 
         -.604823123690, .243834674613,-.038077947364}};
daub20={{ 0.026670057901, 0.188176800078, 0.527201188932,
\t\t  0.688459039454, 0.281172343661,-0.249846424327,
\t\t -0.195946274377, 0.127369340336, 0.093057364604,
\t\t -0.071394147166,-0.029457536822, 0.033212674059,
\t\t  0.003606553567,-0.010733175483, 0.001395351747,
\t\t  0.001992405295,-0.000685856695,-0.000116466855,
\t\t  0.000093588670,-0.000013264203},
\t\t{-0.000013264203,-0.000093588670,-0.000116466855,
\t\t  0.000685856695, 0.001992405295,-0.001395351747,
\t\t -0.010733175483,-0.003606553567, 0.033212674059,
\t\t  0.029457536822,-0.071394147166,-0.093057364604,
\t\t  0.127369340336, 0.195946274377,-0.249846424327,
\t\t -0.281172343661, 0.688459039454,-0.527201188932,
\t\t  0.188176800078,-0.026670057901}};\
\>", "Input",
  FontSize->9],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Construction",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["of",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Functions",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  FontSize->9],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["MRA",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
expanMatrix2D[spect2D_,wMatL_,wMatR_,anaW_]:=
\tBlock[{dim=Dimensions[spect2D],is=Length[Transpose[anaW]],
\t\tmother,transwMatL,emat2D,exPan2D},
\t\tmother=Ceiling[Log[2.,is]]-1;transwMatL=Transpose[wMatL];
\t\tWhich[\tdim[[1]]>=dim[[2]],nLdata=Log[2,dim[[1]]];size=dim[[1]],
\t\t\t\tdim[[2]]>dim[[1]],nLdata=Log[2,dim[[2]]];size=dim[[2]]];
\t\tinputMatrix=ZeroMatrix[size,size];
\t\t\tDo[inputMatrix[[i,j]]=spect2D[[i,j]],
\t\t\t\t{i,dim[[1]]},{j,dim[[2]]}];
\t\texPan2D=ZeroMatrix[dim[[1]],dim[[2]]];
\t\t\tDo[Do[exPan2D[[i,j]]=spect2D[[i,j]],{i,2^mother}],
\t\t\t\t{j,2^mother}];
\t\t\temat2D=transwMatL.exPan2D.wMatR;
\t\tpartInverse2D[i_]:=
\t\t\t(\tdummyMat=ZeroMatrix[size,size];
\t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
\t\t\t\t\t{k,2^i},{m,1+2^(i-1),2^i}];
   \t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
   \t\t\t\t\t{k,1+2^(i-1),2^i},{m,2^i}];
   \t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
   \t\t\t\t\t{k,1+2^(i-1),2^i},{m,1+2^(i-1),2^i}];
   \t\t\t\ttranswMatL.Table[dummyMat[[k,m]],
   \t\t\t\t\t{k,dim[[1]]},{m,dim[[2]]}].wMatR);
    \texPan2D=Table[partInverse2D[i],{i,mother+1,nLdata}];
    \t\tFlatten[{{emat2D},exPan2D},1]
    ];\
\>", "Input",
  FontSize->9],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Difference",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Check",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["by",
        FontVariations->{"Underline"->True}], 
      StyleBox["  ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
waveletDifference[modelData_,testData_,nMother_,wMatrix_]:=
\tModule[{wTMat,dummy,dummx,size},
\t\twTMat=Transpose[wMatrix];
\t\tsize=Dimensions[wMatrix];
\t\tdummy=imageNormalize[TakeMatrix[wMatrix.
\t\t\ttestData.wTMat,{1,1},{nMother,nMother}]]-
\t\t\timageNormalize[TakeMatrix[wMatrix.modelData.
\t\t\twTMat,{1,1},{nMother,nMother}]];
\t\tdummx=ZeroMatrix[size[[1]]];
\t\tDo[dummx[[i,j]]=dummy[[i,j]],
\t\t\t{i,nMother},{j,nMother}];
\t\timageNormalize[wTMat.dummx.wMatrix]
\t];\
\>", "Input",
  FormatType->InputForm,
  FontSize->9],

Cell[BoxData[
    RowBox[{"\[Section]", 
      StyleBox[
        RowBox[{" ", 
          StyleBox[" ",
            FontVariations->{"Underline"->True}]}]], 
      StyleBox["Outlines",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["and",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Sketch",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", " ", 
      StyleBox["1",
        FontVariations->{"Underline"->True}], 
      StyleBox["st",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["sample",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(sampleDataA = {{1, 1, 1, 1, 1, 1, 1, 1}, \n
        \t\t{1, 1, 1, 0, 0, 0, 1, 1}, \n\t\t{1, 1, 1, 0, 0, 0, 1, 1}, \n
        \t\t{1, 1, 1, 0, 0, 0, 1, 1}, \n\t\t{1, 1, 1, 0, 0, 0, 1, 1}, \n
        \t\t{1, 1, 1, 0, 0, 0, 0, 0}, \n\t\t{1, 1, 1, 1, 1, 0, 0, 0}, \n
        \t\t{1, 1, 1, 1, 1, 1, 1, 1}}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(sampleFigureA = 
      ListDensityPlot[sampleDataA, \n\tPlotLabel -> "\<Sample figure A\>", \n
        \tMesh -> False]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -47.2188 0 ]
[.5 1.0125 47.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -108.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(figure) show
147.187500 13.000000 moveto
(A) show
153.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFF
FFFFFF000000FFFF
FFFFFF000000FFFF
FFFFFF000000FFFF
FFFFFF000000FFFF
FFFFFF0000000000
FFFFFFFFFF000000
FFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01Ooool00`000?ooooooo`0joooo0`0003coool30000>_ooo`80000moooo00<0003oooooool03_oo
o`005_ooo`030000oooo000003_oool00`000?ooooooo`0moooo00<0003oooooool0>Oooo`030000
oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool00000??ooo`030000oooooooo
03[oool40000>_ooo`030000oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool0
0000??ooo`030000oooooooo03[oool00`000?ooo`00000koooo0P0003goool00`000?ooooooo`0>
oooo000Foooo00<0003oool00000>oooo`030000oooo000003coool20000>oooo`030000oooooooo
03_oool00`000?ooo`00000?oooo000Goooo00<0003oooooool0>oooo`030000oooooooo03coool0
0`000?ooooooo`0joooo0P0003coool00`000?ooooooo`0>oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000Booooo`0000D0000:oooo000B
oooo00<0003oooooool00_ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`02oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`003?ooo`030000
oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool000_oool00`000?oo
o`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000;oooo00<0003oool0
00001?ooo`<0003noooo0`0000[oool000_oool00`000?ooo`000004oooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool0
01;oool20000ooooo`7oool200002_ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_oo
o`80003ooooo0Oooo`80000:oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
oeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo
00Soool001;oool20000H?oooeh00012oooo0P0000[oool001;oool00`000?ooooooo`1OooooGP00
04?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
oeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000;oooo0`0000Coool00`000?ooooooo`1O
ooooGP0004?oool00`000?ooooooo`08oooo000;oooo00<0003oooooool01?ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool000coool00`000?ooooooo`03oooo0`0005oooomN
0000@Oooo`<0000:oooo000<oooo00<0003oooooool00oooo`030000oooooooo05oooomN0000@ooo
o`030000oooooooo00Soool000_oool00`000?ooo`000004oooo00<0003oooooool0Gooooeh00013
oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo00?oool00`000?ooooooo`1OooooGP00
04?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
oeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool20000H?oo
oeh00012oooo0P0000[oool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP00
04?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
oeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool20000H?oo
oeh00012oooo0P0000[oool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP00
04?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
oeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool20000H?oo
oeh00012oooo0P0000[oool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP00
04?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
oeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool000coool300000oooo`030000oooooooo05oooomN
0000@oooo`030000oooooooo00Soool000goool00`000?ooooooo`02oooo00<0003oooooool0Gooo
oeh00013oooo00<0003oooooool02?ooo`002oooo`@00003oooo0`0005oooomN0000@Oooo`<0000:
oooo000;oooo00<0003oool000001?ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo
00Soool000coool200001?ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool0
00goool00`000?ooooooo`02oooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN
0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1O
ooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0
003oooooool02?ooo`004_ooo`80001PooooGP0004;oool200002_ooo`004_ooo`030000oooooooo
05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN0000@oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooomN
0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooGP0004?oool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Gooooeh00013oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo05oooomN0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1O
ooooGP0004?oool00`000?ooooooo`08oooo000Boooo0P00063ooomN0000@_ooo`80000:oooo000B
oooo00<0003oooooool0Gooooi`00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooonL00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooW00000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooi`00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooonL00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1OooooW00000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooi`00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooonL00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1OooooW00000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Gooooi`00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooonL
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooW00000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Gooooi`00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo05oooonL00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1O
ooooW00000Goool00`000?ooooooo`08oooo000Boooo0P00063ooonL00001?ooo`80000:oooo000B
oooo00<0003oooooool0Gooooi`00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
05oooonL00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooW00000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooi`00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo05oooonL00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1OooooW00000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooooi`00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooonL00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1OooooW00000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Gooooi`00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo05oooonL
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1OooooW00000Goool00`000?oo
ooooo`08oooo000;oooo0P0000Goool00`000?ooooooo`1OooooW00000Goool00`000?ooooooo`08
oooo000;oooo00<0003oool000001?ooo`030000oooooooo05oooonL00001Oooo`030000oooooooo
00Soool000_oool00`000?ooo`000004oooo0`0005oooonL00000oooo`<0000:oooo000;oooo0P00
00Goool00`000?ooooooo`2NooooG@0000Goool00`000?ooooooo`08oooo000;oooo00<0003ooooo
ool01?ooo`030000oooooooo09kooomM00001Oooo`030000oooooooo00Soool000coool200001?oo
o`030000oooooooo09kooomM00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`2N
ooooG@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0W_oooed00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo09kooomM00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`2NooooG@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0W_oooed00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo09kooomM00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`2NooooG@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0W_oooed00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo09kooomM00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`2NooooG@00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0W_oooed00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo09kooomM00001Oooo`030000oooooooo00Soool001;oool2
0000Wooooed00004oooo0P0000[oool001;oool00`000?ooooooo`2NooooG@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0W_oooed00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo09kooomM00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`2N
ooooG@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0W_oooed00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo09kooomM00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`2NooooG@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0W_oooed00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo09kooomM00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`2NooooG@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0W_oooed00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo09kooomM00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`2NooooG@00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0W_oooed00005oooo00<0003ooooo
ool02?ooo`004_ooo`80002OooooG@0000Coool200002_ooo`004_ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`004_ooo`80003ooooo0Oooo`80000:oooo000Boooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000<
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`002ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool000_oool0
0`000?ooo`000004oooo0`000?koool300002_ooo`003?ooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00Soool000_oool00`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`08oooo000<oooo00<0003oooooool00oooo`030000oooooooo
0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;oool00`000?ooooooo`0=
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03Oooo`030000
oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=
oooo00<0003oooooool00_ooo`030000oooooooo00Soool001;ooooo00001@0000[oool00?oooolQ
oooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00MOooo`<0000Toooo0P00
08;oool007Koool00`000?ooooooo`0Uoooo00<0003oooooool0Ooooo`00Ioooo`<00002oooo1@00
0005oooo0000oooo0000oooo00<00002oooo0`0000?oool200003_ooo`<00002oooo0`0000?oool3
00000_ooo`<000001?ooo`000000000000?oool200003_ooo`8000000oooo`000000001Poooo001W
oooo00<0003oool000000_ooo`<000002?ooo`000?ooo`000?ooo`000?ooo`0000;oool010000?oo
ooooo`0000?oool00`000?ooooooo`0?oooo00<0003oooooool00_ooo`050000oooooooooooo0000
00;oool00`000?ooo`000002oooo00@0003oooooool00003oooo00<0003oooooool03_ooo`050000
oooooooooooo0000063oool006Woool00`000?ooooooo`02oooo00T0003oool0003oool0003oool0
003oool000000_ooo`040000oooooooo00000oooo`<0000?oooo00<0003oooooool00_ooo`050000
oooooooooooo000000;oool00`000?ooo`000002oooo00@0003oooooool00003oooo0`0000ooool3
0000HOooo`00J?ooo`030000oooooooo00;oool2000000Koool00000003oool0003oool400000ooo
o`040000oooooooooooo0`0000koool300000_ooo`800004oooo1@000004oooo00000000oooo1000
0004oooo0000000000003oooo`030000oooo0000067oool006Ooool00`000?ooo`00000Boooo00<0
003oooooool04oooo`030000oooooooo02Soool00`000?ooooooo`1Poooo001Woooo0`00017oool2
00005_ooo`050000oooooooooooo000002Coool20000H_ooo`00ooooob7oool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.762352, -0.553541, 0.0321664, 
  0.0321664}}]
}, Open  ]],

Cell[TextData[{
  "weightenWaveletSegnetation[test_,m_]:=\n\t\
Module[{n,n2,m2,m3,m4,ms,me,mx,k,p,ps,pe,wMatrix,wTMatrix,\n\t\t\
partSpect,segment,out,gMax,maxAbs,minAbs,list={}},\n\t\t\t\
n=Length[test];n2=n/2;\n\t\t\tmx=m;Which[m<=0,mx=1,m>n,mx=n];m2=n/mx;\n\t\t\t\
wMatrix=waveletMatrix[n,daub2];\n\t\t\twTMatrix=Transpose[wMatrix];\n\t\t\t\
out=ZeroMatrix[n];\n\t\t\tsegment=wMatrix.test.wTMatrix;\n\t\t\t\
Do[segment[[i,j]]=0,{i,n2},{j,n2}];\n\t\t\tsegment=wTMatrix.segment.wMatrix;\n\
\t\t\tgMax=Max[Abs[segment]];\n\t\t\tminAbs=N[gMax/(mx mx)];\n\t\tDo[\n\t\t\t\
m3=k*m2;m4=p*m2;\n\t\t\t\tms=m3+1;me=ms+m2-1;\n\t\t\t\tps=m4+1;pe=ps+m2-1;\n\t\
\t\t\tpartSpect=ZeroMatrix[n];\n\t\t\t\
Do[partSpect[[i,j]]=segment[[i,j]],{i,ms,me},{j,ps,pe}];\t\n\t\t\t\
maxAbs=Max[Abs[partSpect]];\n\t\t\tIf[maxAbs>=",
  StyleBox["minAbs", "MR"],
  ",\n\t\t\t\tpartSpect=Round[partSpect/",
  StyleBox["maxAbs]", "MR"],
  ",\n\t\t\t\tpartSpect=0. partSpect];\n\t\t\tDo[out[[i,j]]=(maxAbs/gMax) \
Abs[partSpect[[i,j]]];\n\t\t\t\tIf[partSpect[[i,j]]>0,\n      \t\t\t\t\
list=Append[list,{RGBColor[1,1,0],\n      \t\t\t\t\tPoint[{j,i}]}]],\n      \t\
\t{i,ms,me},{j,ps,pe}],\n      \t\t\n      \t{p,0,mx-1},{k,0,mx-1}];\n\t\t\
{out,Map[Graphics,list]}\n\t];"
}], "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
Timing[segmentA16=weightenWaveletSegnetation[sampleDataA,16];]\
\>", "Input"],

Cell[BoxData[
    \({0.610000000000013642`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
sketchA16=ListDensityPlot[1-Abs[segmentA16[[1]]],
\tPlotLabel -> \"Sketch of sample A\",
\tMesh->False,DisplayFunction->Identity];
outlineA16=Show[segmentA16[[2]],
\tPlotLabel -> \"Outline of sample A\",
\tBackground->GrayLevel[0],AspectRatio->1,Frame->True,
\tDisplayFunction->Identity];
Show[GraphicsArray[{sampleFigureA,outlineA16,sketchA16}]];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -47.2188 0 ]
[.5 1.0125 47.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -108.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(figure) show
147.187500 13.000000 moveto
(A) show
153.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFF
FFFFFF000000FFFF
FFFFFF000000FFFF
FFFFFF000000FFFF
FFFFFF000000FFFF
FFFFFF0000000000
FFFFFFFFFF000000
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
0 g
MFill
% Scaling calculations
-0.547619 0.190476 0.0238095 0.119048 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .2619 -6 -4.5 ]
[-0.0125 .2619 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7381 -6 -4.5 ]
[-0.0125 .7381 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59.2188 0 ]
[.5 1.0125 59.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 g
.25 Mabswid
.02381 0 m
.02381 .00625 L
s
[(3)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(4)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(5)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(7)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(8)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.0619 0 m
.0619 .00375 L
s
.1 0 m
.1 .00375 L
s
.1381 0 m
.1381 .00375 L
s
.17619 0 m
.17619 .00375 L
s
.25238 0 m
.25238 .00375 L
s
.29048 0 m
.29048 .00375 L
s
.32857 0 m
.32857 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.44286 0 m
.44286 .00375 L
s
.48095 0 m
.48095 .00375 L
s
.51905 0 m
.51905 .00375 L
s
.55714 0 m
.55714 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.67143 0 m
.67143 .00375 L
s
.70952 0 m
.70952 .00375 L
s
.74762 0 m
.74762 .00375 L
s
.82381 0 m
.82381 .00375 L
s
.8619 0 m
.8619 .00375 L
s
.9 0 m
.9 .00375 L
s
.9381 0 m
.9381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .2619 m
.00625 .2619 L
s
[(2)] -0.0125 .2619 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .7381 m
.00625 .7381 L
s
[(6)] -0.0125 .7381 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(8)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .08333 m
.00375 .08333 L
s
0 .14286 m
.00375 .14286 L
s
0 .20238 m
.00375 .20238 L
s
0 .32143 m
.00375 .32143 L
s
0 .38095 m
.00375 .38095 L
s
0 .44048 m
.00375 .44048 L
s
0 .55952 m
.00375 .55952 L
s
0 .61905 m
.00375 .61905 L
s
0 .67857 m
.00375 .67857 L
s
0 .79762 m
.00375 .79762 L
s
0 .85714 m
.00375 .85714 L
s
0 .91667 m
.00375 .91667 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21429 .99375 m
.21429 1 L
s
.40476 .99375 m
.40476 1 L
s
.59524 .99375 m
.59524 1 L
s
.78571 .99375 m
.78571 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.0619 .99625 m
.0619 1 L
s
.1 .99625 m
.1 1 L
s
.1381 .99625 m
.1381 1 L
s
.17619 .99625 m
.17619 1 L
s
.25238 .99625 m
.25238 1 L
s
.29048 .99625 m
.29048 1 L
s
.32857 .99625 m
.32857 1 L
s
.36667 .99625 m
.36667 1 L
s
.44286 .99625 m
.44286 1 L
s
.48095 .99625 m
.48095 1 L
s
.51905 .99625 m
.51905 1 L
s
.55714 .99625 m
.55714 1 L
s
.63333 .99625 m
.63333 1 L
s
.67143 .99625 m
.67143 1 L
s
.70952 .99625 m
.70952 1 L
s
.74762 .99625 m
.74762 1 L
s
.82381 .99625 m
.82381 1 L
s
.8619 .99625 m
.8619 1 L
s
.9 .99625 m
.9 1 L
s
.9381 .99625 m
.9381 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .2619 m
1 .2619 L
s
.99375 .5 m
1 .5 L
s
.99375 .7381 m
1 .7381 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .08333 m
1 .08333 L
s
.99625 .14286 m
1 .14286 L
s
.99625 .20238 m
1 .20238 L
s
.99625 .32143 m
1 .32143 L
s
.99625 .38095 m
1 .38095 L
s
.99625 .44048 m
1 .44048 L
s
.99625 .55952 m
1 .55952 L
s
.99625 .61905 m
1 .61905 L
s
.99625 .67857 m
1 .67857 L
s
.99625 .79762 m
1 .79762 L
s
.99625 .85714 m
1 .85714 L
s
.99625 .91667 m
1 .91667 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
(Outline) show
111.000000 13.000000 moveto
(of) show
129.000000 13.000000 moveto
(sample) show
171.187500 13.000000 moveto
(A) show
177.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 0 r
.008 w
.02381 .14286 Mdot
.02381 .2619 Mdot
.02381 .38095 Mdot
.02381 .5 Mdot
.02381 .61905 Mdot
.02381 .7381 Mdot
.21429 .14286 Mdot
.40476 .14286 Mdot
.40476 .85714 Mdot
.40476 .97619 Mdot
.59524 .14286 Mdot
.59524 .97619 Mdot
.78571 .61905 Mdot
.78571 .97619 Mdot
.97619 .61905 Mdot
.97619 .97619 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -56.2188 0 ]
[.5 1.0125 56.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -117.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sketch) show
105.000000 13.000000 moveto
(of) show
123.000000 13.000000 moveto
(sample) show
165.187500 13.000000 moveto
(A) show
171.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFAAAA5555FFFF
FFFFAA005555FFFF
FFFF5555FFFFFFFF
FFFF5555FFFFFFFF
FFFF5555FFFF5555
FFFF5555FFFF5555
FFFFFFFFAA005555
FFFFFFFFAAAA5555
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{417, 130.313},
  ImageMargins->{{42, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Q0000PQP00`40o`000?l0003ooooooj;oool0
0?oooonRoooo003oooooX_ooo`00oooooj;oool001_oool00`000?ooooooo`0Doooo0`0001Koool3
00004oooo`80000Goooo00<0003oooooool05?ooo`h00002oooo4P0000?oool@000000?oool00000
00003P0000;ooolB000000?oool00000000040000003oooo0000000000d0000Ioooo00<0003ooooo
ool05?ooo`<0000Foooo0`0001?oool200005oooo`030000oooooooo01Soool001[oool00`000?oo
o`00000Eoooo00<0003oooooool05oooo`030000oooooooo01;oool00`000?ooo`00000Eoooo00<0
003oool000005Ooooa0000000oooo`000000000@000000?oool0000000003P000003oooo0000oooo
00l000000oooo`000?ooo`0A000000?oool0000000003`000003oooo0000oooo00h0000Hoooo00<0
003oool000005Oooo`030000oooooooo01Ooool00`000?ooooooo`0Boooo00<0003oool000005Ooo
o`030000oooo000001Woool001[oool00`000?ooo`00000Foooo00<0003oooooool05?ooo`@0000C
oooo00<0003oool000005Oooo`030000oooo000001Goool?000000?oool0000000003`0000CooolA
000000?oool0000000003@000003oooo0000oooo014000000oooo`000000000?000000?oool0003o
ool03P0001Soool00`000?ooo`00000Foooo00<0003oooooool05?ooo`@0000Coooo00<0003oool0
00005Oooo`030000oooo000001Woool001[oool00`000?ooo`00000Foooo00<0003oooooool05?oo
o`030000oooo000001Coool200005oooo`030000oooooooo01Coool@000000?oool0000000003P00
0003oooo0000oooo01000002oooo400000;ooolC000000?oool0000000003`000003oooo00000000
00d0000Hoooo00<0003oool000005_ooo`030000oooooooo01Coool00`000?ooo`00000Doooo0P00
01Ooool00`000?ooooooo`0Hoooo000Joooo00<0003oool000005Oooo`030000oooo000001Koool2
00005?ooo`030000oooooooo01Goool00`000?ooo`00000Eoooo3P000003oooo0000oooo01400002
oooo40000003oooo0000000000l000000oooo`000000000@000000?oool0003oool040000003oooo
0000oooo00h0000Hoooo00<0003oool000005Oooo`030000oooo000001Koool200005?ooo`030000
oooooooo01Goool00`000?ooo`00000Ioooo000Koooo00<0003oooooool05Oooo`030000oooooooo
01Koool00`000?ooooooo`0Coooo0P0001Koool00`000?ooooooo`0Doooo3`000003oooo00000000
014000000oooo`000000000>00000ooooa000002oooo400000?ooolA000000?oool0000000003@00
01Woool00`000?ooooooo`0Eoooo00<0003oooooool05_ooo`030000oooooooo01?oool200005_oo
o`030000oooooooo01Soool0097ooomm0000Toooo`00TOooogd0002Coooo002AooooO@0009?oool0
01Goool00`000?ooooooo`1iooooO@0001Coool00`000?ooooooo`1loooo000Doooo00<0003oool0
00000oooof<0000Doooo2@000004oooo000000000000I?ooo``0000Coooo00<0003oool000000_oo
of@0000Goooo000Doooo00<0003oool000000oooo`030000oooooooo05ooool00`000?ooooooo`0B
oooo20000003oooo0000oooo008000000oooo`000000001P000000?oool0000000002P0001?oool0
0`000?ooo`000002oooo00<0003oooooool0Goooo`80000Goooo000Doooo00<0003oool000000ooo
o`030000oooooooo05ooool00`000?ooooooo`0Boooo20000003oooo0000oooo00800002ooooH000
00;oool<00004oooo`030000oooo000000;oool00`000?ooooooo`0Goooo6:ZZZQMEEEDJoooo00<0
003oooooool05Oooo`005?ooo`030000oooo000000?oool00`000?ooooooo`1Ooooo00<0003ooooo
ool04_ooo`P000000oooo`000?ooo`02000000?oool000000000H0000003oooo0000000000X0000C
oooo00<0003oool000000_ooo`030000oooooooo01OooolHZZZZ5eEEEA[oool00`000?ooooooo`0E
oooo000Eoooo00<0003oooooool00_ooo`030000oooooooo05ooool00`000?ooooooo`0Boooo2000
0003oooo0000oooo008000000oooo`000000001P000000?oool0000000002P0001Coool01@000?oo
ooooooooo`00000Ioooo6:ZZZQMEEEDJoooo00<0003oooooool05Oooo`006_ooo`030000oooooooo
05ooool00`000?ooooooo`0Boooo2@000005oooo000000000000oooo068000000oooo`000000000:
00006?ooo`030000oooooooo01OooolHZZZZ5eEEEA[oool00`000?ooooooo`0Eoooo000Joooo00<0
003oooooool0Goooo`030000oooooooo01;oool=000000?oool000000000H0000003oooo00000000
00X0000Hoooo00<0003oooooool05ooooaRZZZXGEEEE6_ooo`030000oooooooo01Goool001[oool0
0`000?ooooooo`1Ooooo00<0003oooooool04_ooo`d000000oooo`000000001P000000?oool00000
00002P0001Soool00`000?ooooooo`0Goooo6:ZZZQMEEEDIoooo0P0001Ooool001[oool00`000?oo
ooooo`1Ooooo00<0003oooooool04_ooo`d000000oooo`000000001O00000_ooo``0000Hoooo00<0
003oooooool05ooooaRZZZXGEEEE6_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`1O
oooo00<0003oooooool04_ooo`d000000oooo`000000001P000000?oool0000000002P0001Soool0
0`000?ooooooo`0Goooo6:ZZZQMEEEDJoooo00<0003oooooool05Oooo`006_ooo`030000oooooooo
05ooool00`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?oo
o`030000oooooooo01OooolHZZZZ5eEEEA[oool00`000?ooooooo`0Eoooo000Joooo00<0003ooooo
ool0Goooo`030000oooooooo01;oool=000000?oool000000000H0000003oooo0000000000X0000H
oooo00<0003oooooool05ooooaRZZZXGEEEE6_ooo`030000oooooooo01Goool001[oool00`000?oo
ooooo`1Ooooo00<0003oooooool04_ooo`d000000oooo`000000001P000000?oool0000000002P00
01Soool00`000?ooooooo`0Goooo6:ZZZQMEEEDJoooo00<0003oooooool05Oooo`006_ooo`030000
oooooooo05ooool00`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:
00006?ooo`030000oooooooo01OooolHZZZZ5eEEEAWoool200005oooo`006_ooo`030000oooooooo
02?ooolS00006Oooo`030000oooooooo01;oool=000000Coool00000003oo`0A000000?oo`000000
000040000003ool000000000010000000ooo00000000000T00000_ooo``0000Hoooo00<0003ooooo
ool05oooo`bZZZX<00005eEEEA[oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool08ooo
ob<0000Ioooo00<0003oooooool04_ooo`d000000oooo`000000001P000000?oool0000000002P00
01Soool00`000?ooooooo`0Goooo3:ZZZP`0000GEEEE6_ooo`030000oooooooo01Goool001[oool0
0`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo0000000006000000
0oooo`000000000:00006?ooo`030000oooooooo01Ooool<ZZZZ300001MEEEDJoooo00<0003ooooo
ool05Oooo`006_ooo`030000oooooooo02?ooolS00006Oooo`030000oooooooo01;oool=000000?o
ool000000000H0000003oooo0000000000X0000Hoooo00<0003oooooool05oooo`bZZZX<00005eEE
EA[oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool08oooob<0000Ioooo00<0003ooooo
ool04_ooo`d000000oooo`000000001P000000?oool0000000002P0001Soool00`000?ooooooo`0G
oooo3:ZZZP`0000GEEEE6_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo8`00
01Woool00`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?oo
o`030000oooooooo01Ooool<ZZZZ300001MEEEDIoooo0P0001Ooool001[oool00`000?ooooooo`0S
oooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo0000000005l00002oooo300001Soool0
0`000?ooooooo`0Goooo3:ZZZP`0000GEEEE6_ooo`030000oooooooo01Goool001[oool00`000?oo
ooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`00
0000000:00006?ooo`030000oooooooo01Ooool<ZZZZ300001MEEEDJoooo00<0003oooooool05Ooo
o`006_ooo`030000oooooooo02?ooolS00006Oooo`030000oooooooo01;oool=000000?oool00000
0000H0000003oooo0000000000X0000Hoooo00<0003oooooool05oooo`bZZZX<00005eEEEA[oool0
0`000?ooooooo`0Eoooo000Doooo0`0000?oool00`000?ooooooo`0Soooo8`0001Woool00`000?oo
ooooo`0Boooo200000?oool2000000?oool000000000H0000003oooo0000000000X0000Coooo0`00
00;oool00`000?ooooooo`0Goooo3:ZZZP`0000GEEEE6_ooo`030000oooooooo01Goool001Coool0
0`000?ooooooo`03oooo00<0003oooooool08oooob<0000Ioooo00<0003oooooool04_ooo`P00000
0oooo`0000000002000000?oool000000000H0000003oooo0000000000X0000Coooo00<0003ooooo
ool00_ooo`030000oooooooo01Ooool<ZZZZ300001MEEEDJoooo00<0003oooooool05Oooo`005Ooo
o`030000oooooooo00;oool00`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo2@00
0004oooo0000000000000_ooo`030000ool0000005d00002oooo300001Coool01@000?oooooooooo
o`00000Ioooo3:ZZZP`0000GEEEE6Oooo`80000Goooo000Eoooo00<0003oooooool00_ooo`030000
oooooooo02?ooolS00006Oooo`030000oooooooo01;oool9000000Goool000000000003oool0HP00
0003oooo0000000000X0000Doooo00D0003oooooooooool000006OoooaQEEEDaoooo00<0003ooooo
ool05Oooo`005?ooo`030000oooo000000?oool00`000?ooooooo`0Soooo8`0001Woool00`000?oo
ooooo`0Boooo20000003oooo0000oooo008000000oooo`000000001P000000?oool0000000002P00
01?oool00`000?ooo`000002oooo00<0003oooooool05ooooaQEEEDaoooo00<0003oooooool05Ooo
o`005Oooo`030000oooooooo00;oool00`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0B
oooo2@000005oooo000000000000oooo068000000oooo`000000000:00005?ooo`050000oooooooo
oooo000001WooolHEEEE<Oooo`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo8`00
01Woool00`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?oo
o`030000oooooooo01OooolHEEEE<Oooo`030000oooooooo01Goool001[oool00`000?ooooooo`0S
oooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:
00006?ooo`030000oooooooo01OooolHEEEE<Oooo`030000oooooooo01Goool001[oool00`000?oo
ooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo0000000005l00002oooo3000
01Soool00`000?ooooooo`0Goooo65EEEC3oool200005oooo`006_ooo`030000oooooooo02?ooolS
00006Oooo`030000oooooooo01;oool=000000?oool000000000H0000003oooo0000000000X0000H
oooo00<0003oooooool05ooooaQEEEDaoooo00<0003oooooool05Oooo`006_ooo`030000oooooooo
02?ooolS00006Oooo`030000oooooooo01;oool=000000?oool000000000H0000003oooo00000000
00X0000Hoooo00<0003oooooool05ooooaQEEEDaoooo00<0003oooooool05Oooo`006_ooo`030000
oooooooo02?ooolS00006Oooo`030000oooooooo01;oool=000000?oool000000000H0000003oooo
0000000000X0000Hoooo00<0003oooooool05ooooaQEEEDaoooo00<0003oooooool05Oooo`006_oo
o`030000oooooooo02?ooolS00006Oooo`030000oooooooo01;oool=000000?oool000000000H000
0003oooo0000000000X0000Hoooo00<0003oooooool05ooooaQEEEDaoooo00<0003oooooool05Ooo
o`006_ooo`030000oooooooo02?ooolS00006Oooo`030000oooooooo01;oool=000000?oool00000
0000H0000003oooo0000000000X0000Hoooo00<0003oooooool05ooooaQEEEDaoooo00<0003ooooo
ool05Oooo`006_ooo`030000oooooooo02?ooolS00006Oooo`030000oooooooo01;oool=000000Co
ool00000003oo`1N00000_ooo``0000Hoooo00<0003oooooool05ooooaQEEED`oooo0P0001Ooool0
01[oool00`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo00000000
060000000oooo`000000000:00006?ooo`030000oooooooo01OooolHEEEE<Oooo`030000oooooooo
01Goool001[oool00`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo
00000000060000000oooo`000000000:00006?ooo`030000oooooooo01OooolHEEEE<Oooo`030000
oooooooo01Goool001[oool00`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo3@00
0003oooo00000000060000000oooo`000000000:00006?ooo`030000oooooooo01OooolHEEEE<Ooo
o`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0B
oooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000oooooooo01OooolH
EEEE<Oooo`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo8`0001Woool00`000?oo
ooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000oooooooo
01OooolHEEEE<Oooo`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo8`0001Woool0
0`000?ooooooo`0Boooo3@000003oooo0000000005l00002oooo300001Soool00`000?ooooooo`0G
oooo65EEEC3oool200005oooo`006_ooo`030000oooooooo02?ooolS00006Oooo`030000oooooooo
01;oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0003oooooool05ooo
oaQEEEDaoooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02?ooolS00006Oooo`030000
oooooooo01;oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0003ooooo
ool05ooooaQEEEDaoooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02?ooolS00006Ooo
o`030000oooooooo01;oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0
003oooooool05ooooaQEEEDaoooo00<0003oooooool05Oooo`005Oooo`<00002oooo00<0003ooooo
ool08oooob<0000Ioooo00<0003oooooool04_ooo`T00003oooo00<0003oool00000H@000003oooo
0000000000X0000Doooo0`000003oooo0000oooo01SooolHEEEE<Oooo`030000oooooooo01Goool0
01Koool01@000?ooooooooooo`00000Uoooo8`0001Woool00`000?ooooooo`0Boooo2P000004oooo
00000000ooooHP000003oooo0000000000X0000Eoooo00@0003oooooool0000Ioooo65EEEC7oool0
0`000?ooooooo`0Eoooo000Doooo100000;oool00`000?ooooooo`0Soooo8`0001Woool00`000?oo
ooooo`0Boooo200000Coool01@000?ooooooo`000?oo001N00000_ooo``0000Coooo10000003oooo
0000oooo01SooolHEEEE<?ooo`80000Goooo000Doooo00<0003oool000000oooo`030000oooooooo
02?ooolS00006Oooo`030000oooooooo01;oool8000000?oool0003oool00P000003oooo00000000
060000000oooo`000000000:00004oooo`030000oooo000000;oool00`000?ooooooo`0Goooo65EE
EAOooolHEEEE0_ooo`030000oooooooo01Goool001Goool200000oooo`030000oooooooo02?ooolS
00006Oooo`030000oooooooo01;oool900000_ooo`8000000oooo`000000001P000000?oool00000
00002P0001Coool200000_ooo`030000oooooooo01OooolHEEEE5ooooaQEEED2oooo00<0003ooooo
ool05Oooo`005_ooo`050000oooooooooooo000002GooolS00006Oooo`030000oooooooo01;oool:
000000Coool00000003ooomR000000?oool0000000002P0001Goool010000?ooooooo`0001WooolH
EEEE5ooooaQEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02?ooolS00006Ooo
o`030000oooooooo01;oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0
003oooooool05ooooaQEEEDGoooo65EEE@;oool00`000?ooooooo`0Eoooo000Joooo00<0003ooooo
ool08oooob<0000Ioooo00<0003oooooool04_ooo`d000000oooo`000000001P000000?oool00000
00002P0001Soool00`000?ooooooo`0Goooo65EEEAOooolHEEEE0_ooo`030000oooooooo01Goool0
01[oool00`000?ooooooo`0Soooo8`0001Woool00`000?ooooooo`0Boooo3@000003oooo00000000
05l00002oooo300001Soool00`000?ooooooo`0Goooo65EEEAOooolHEEEE00?oool0000000005ooo
o`006_ooo`030000oooooooo02?ooolS00006Oooo`030000oooooooo01;oool=000000?oool00000
0000H0000003oooo0000000000X0000Hoooo00<0003oooooool05ooooaQEEEDGoooo65EEE@;oool0
0`000?ooooooo`0Eoooo000Joooo00<0003oooooool08oooob<0000Ioooo00<0003oooooool04_oo
o`d000000oooo`000000001P000000?oool0000000002P0001Soool00`000?ooooooo`0Goooo65EE
EAOooolHEEEE0_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo8`0001Woool0
0`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000
oooooooo01OooolHEEEE5ooooaQEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo
02?ooolS00006Oooo`030000oooooooo01;oool=000000?oool000000000H0000003oooo00000000
00X0000Hoooo00<0003oooooool05ooooaQEEEDGoooo65EEE@;oool00`000?ooooooo`0Eoooo000J
oooo00<0003oooooool08oooob<0000Ioooo00<0003oooooool04_ooo`d000000oooo`000000001P
000000?oool0000000002P0001Soool00`000?ooooooo`0Goooo65EEEAOooolHEEEE0_ooo`030000
oooooooo01Goool001[oool00`000?ooooooo`0Soooo>`000003oooo0000oooo01?oool=000000Co
ool00000003oo`1:000000?oo`000000000040000003ool0oooooooo00`0000Hoooo00<0003ooooo
ool05ooooaQEEEDGoooo65EEE@03oooo0000000001Ooool001[oool00`000?ooooooo`0Soooo>`00
0003oooo0000oooo01?oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0
003oooooool05ooooaQEEEDGoooo65EEE@;oool00`000?ooooooo`0Eoooo000Joooo00<0003ooooo
ool08ooooc/000000oooo`000?ooo`0Coooo3@000003oooo00000000060000000oooo`000000000:
00006?ooo`030000oooooooo01OooolHEEEE5ooooaQEEED2oooo00<0003oooooool05Oooo`006_oo
o`030000oooooooo02?ooolk000000?oool0003oool04oooo`d000000oooo`000000001P000000?o
ool0000000002P0001Soool00`000?ooooooo`0Goooo65EEEAOooolHEEEE0_ooo`030000oooooooo
01Goool001[oool00`000?ooooooo`0Soooo>`000003oooo0000oooo01?oool=000000?oool00000
0000H0000003oooo0000000000X0000Hoooo00<0003oooooool05ooooaQEEEDGoooo65EEE@;oool0
0`000?ooooooo`0Eoooo000Joooo00<0003oooooool08ooooc/000000oooo`000?ooo`0Coooo3@00
0003oooo00000000060000000oooo`000000000:00006?ooo`030000oooooooo01OooolHEEEE5ooo
oaQEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02?ooolk000000?oool0003o
ool04oooo`d000000oooo`000000001O00000_ooo``0000Hoooo00<0003oooooool05ooooaQEEEDG
oooo65EEE@03oooo0000000001Ooool001[oool00`000?ooooooo`0Soooo>`000003oooo0000oooo
01?oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0003oooooool05ooo
oaQEEEDGoooo65EEE@;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool08ooooc/00000
0oooo`000?ooo`0Coooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000
oooooooo01OooolHEEEE5ooooaQEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo
02?ooolk000000?oool0003oool04oooo`P00002oooo0`000003oooo00000000060000000oooo`00
0000000:00006?ooo`030000oooooooo01OooolHEEEE5ooooaQEEED2oooo00<0003oooooool05Ooo
o`005?ooo`800004oooo00<0003oooooool08ooooc/000000oooo`000?ooo`0Coooo20000003oooo
0000oooo008000000oooo`000000001P000000?oool0000000002P0001?oool200000oooo`030000
oooooooo01OooolHEEEE5ooooaQEEED2oooo00<0003oooooool05Oooo`005?ooo`030000oooo0000
00?oool00`000?ooooooo`0Soooo>`000003oooo0000oooo01?oool8000000?oool0003oool00P00
00;oool00`000?oo0000001M00000_ooo``0000Coooo00<0003oool000000_ooo`030000oooooooo
01OooolHEEEE5ooooaQEEED2oooo00<0003oooooool05Oooo`005?ooo`030000oooo000000?oool0
0`000?ooooooo`0joooo90000003oooo0000oooo01?oool800000_ooo`<000000oooo`000000001P
000000?oool0000000002P0001?oool00`000?ooo`000002oooo00<0003oooooool0;oooo`^ZZZX<
000065EEE@03oooo0000000001Ooool001Coool200001?ooo`030000oooooooo03[ooolT000000?o
ool0003oool04oooo`P000000oooo`0000000002000000?oool000000000H0000003oooo00000000
00X0000Coooo0P0000?oool00`000?ooooooo`0_oooo2jZZZP`0000HEEEE0_ooo`030000oooooooo
01Goool001Coool00`000?ooooooo`03oooo00<0003oooooool0>_ooob@000000oooo`000?ooo`0C
oooo2@0000;oool2000000?oool000000000H0000003oooo0000000000X0000Coooo00<0003ooooo
ool00_ooo`030000oooooooo02ooool;ZZZZ300001QEEED2oooo00<0003oooooool05Oooo`005Ooo
o`800003oooo00<0003oooooool0>_ooob@000000oooo`000?ooo`0Coooo3@000003oooo00000000
060000000oooo`000000000:00005?ooo`800002oooo00<0003oooooool0;oooo`^ZZZX<000065EE
E@;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool0>_ooob@000000oooo`000?ooo`0C
oooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000oooooooo02ooool;
ZZZZ300001QEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo03[ooolT000000?o
ool0003oool04oooo`d000000oooo`000000001O00000_ooo``0000Hoooo00<0003oooooool0;ooo
o`^ZZZX<000065EEE@;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool0>_ooob@00000
0oooo`000?ooo`0Coooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000
oooooooo02ooool;ZZZZ300001QEEED00oooo`000000000Goooo000Joooo00<0003oooooool0>_oo
ob@000000oooo`000?ooo`0Coooo3@000003oooo00000000060000000oooo`000000000:00006?oo
o`030000oooooooo02ooool;ZZZZ300001QEEED2oooo00<0003oooooool05Oooo`006_ooo`030000
oooooooo03[ooolT000000?oool0003oool04oooo`d000000oooo`000000001P000000?oool00000
00002P0001Soool00`000?ooooooo`0_oooo2jZZZP`0000HEEEE0_ooo`030000oooooooo01Goool0
01[oool00`000?ooooooo`0joooo90000003oooo0000oooo01?oool=000000?oool000000000H000
0003oooo0000000000X0000Hoooo00<0003oooooool0;oooo`^ZZZX<000065EEE@;oool00`000?oo
ooooo`0Eoooo000Joooo00<0003oooooool0>_ooob@000000oooo`000?ooo`0Coooo3@000003oooo
00000000060000000oooo`000000000:00006?ooo`030000oooooooo02ooool;ZZZZ300001QEEED2
oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo03[ooolT000000?oool0003oool04ooo
o`d000000oooo`000000000U000000?oo`0000000000=`0000;oool<00006?ooo`030000oooooooo
02ooool;ZZZZ300001QEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo05ooool0
0`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000
oooooooo02oooolGZZZZ65EEE@03oooo0000000001Ooool001[oool00`000?ooooooo`1Ooooo00<0
003oooooool04_ooo`d000000oooo`000000001P000000?oool0000000002P0001Soool00`000?oo
ooooo`0_oooo5jZZZQQEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo05ooool0
0`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000
oooooooo02oooolGZZZZ65EEE@;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool0Gooo
o`030000oooooooo01;oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0
003oooooool0;ooooaNZZZXHEEEE0_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`1O
oooo00<0003oooooool04_ooo`d000000oooo`000000001P000000?oool0000000002P0001Soool0
0`000?ooooooo`0_oooo5jZZZQQEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo
05ooool00`000?ooooooo`0Boooo3@000003oooo0000000005l00002oooo300001Soool00`000?oo
ooooo`0_oooo5jZZZQQEEED00oooo`000000000Goooo000Joooo00<0003oooooool0Goooo`030000
oooooooo01;oool=000000?oool000000000H0000003oooo0000000000X0000Hoooo00<0003ooooo
ool0;ooooaNZZZXHEEEE0_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`1Ooooo00<0
003oooooool04_ooo`d000000oooo`000000001P000000?oool0000000002P0001Soool00`000?oo
ooooo`0_oooo5jZZZQQEEED2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo05ooool0
0`000?ooooooo`0Boooo3@000003oooo00000000060000000oooo`000000000:00006?ooo`030000
oooooooo02oooolGZZZZ65EEE@;oool00`000?ooooooo`0Eoooo000Eoooo00<0003oooooool00_oo
o`030000oooooooo05ooool00`000?ooooooo`0Boooo2@000005oooo000000000000oooo06800000
0oooo`000000000:00005?ooo`050000oooooooooooo0000037ooolGZZZZ65EEE@;oool00`000?oo
ooooo`0Eoooo000Doooo00<0003oool000000oooo`030000oooooooo05ooool00`000?ooooooo`0B
oooo20000003oooo0000oooo008000000oooo`000000001P000000?oool0000000002P0001?oool0
0`000?ooo`000002oooo00<0003oooooool0;ooooaNZZZXHEEEE0_ooo`030000oooooooo01Goool0
01Coool00`000?ooo`000003oooo00<0003oooooool0Goooo`030000oooooooo01;oool8000000?o
ool0003oool00P0000;ooolV000000?oo`000000000040000003ool000000000010000000ooo0000
0000000@000000?oo`3oooooool0300001?oool00`000?ooo`000002oooo00<0003oooooool0;ooo
oaNZZZXHEEEE00?oool0000000005oooo`005Oooo`030000oooooooo00;oool00`000?ooooooo`1O
oooo00<0003oooooool04_ooo`T000001Oooo`00000000000?ooo`1R000000?oool0000000002P00
01Coool01@000?ooooooooooo`00001Roooo00<0003oooooool05Oooo`005?ooo`030000oooo0000
00?ooomS00005?ooo`P000000oooo`000?ooo`020000I?ooo``0000Coooo00<0003oool000000_oo
of@0000Goooo000Eoooo00<0003oooooool0NOooo`T000000oooo`000000001a00005?ooo`030000
oooooooo07coool0097ooomm0000Toooo`00TOooogd0002Coooo000]oooo0`0002Coool20000>ooo
oeH00003oooo900005koool30000<_ooo`00;_ooo`030000oooooooo02Goool00`000?ooooooo`0h
ooooE`000003oooo0000000002<0001Ooooo00<0003oooooool0<Oooo`007oooo`<00002oooo1@00
0005oooo0000oooo0000oooo00<00002oooo0`0000?oool200003_ooo`<00002oooo0`0000?oool3
00000_ooo`<000001?ooo`000000000000?oool200003Oooo`8000000oooo`000000000Joooo1`00
00;oool300000oooo`800002oooo0P0000?oool200000oooo`030000oooooooo008000000oooo`00
00000002oooo400000;oool200000oooo`X00002oooo0`0000Goool01@000?ooo`000?ooo`000003
oooo0P0000?oool300000_ooo`d00002oooo00<0003oooooool01`0001Coool3000000Coool00000
003oool200000_ooo`800003oooo0P0000;oool3000000Koool000000000003oool0000>oooo0P00
00;oool300002_ooo`800003oooo1@000005oooo0000oooo0000oooo00<00002oooo0`0000?oool2
00003Oooo`8000000oooo`000000000Eoooo000Ooooo00<0003oool000000_ooo`<000002?ooo`00
0?ooo`000?ooo`000?ooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`0?oooo00<0
003oooooool00_ooo`050000oooooooooooo000000;oool00`000?ooo`000002oooo00@0003ooooo
ool00003oooo00<0003oooooool03Oooo`050000oooooooooooo000001[oool6000000Koool00000
003oool0003oool2000000?oool0003oool00P000004oooo00000000oooo10000005oooo00000000
0000oooo008000000oooo`000?ooo`0A000000Coool00000003oool2000000?oool0000000002`00
0003oooo0000000000?oool020000?ooo`000?ooo`000?ooo`000?ooo`8000001?ooo`0000000?oo
o`<000000oooo`000000000=000000Goool000000000003oool01`0001Coool00`000?ooo`000002
oooo00<0003oool000000_ooo`030000oooooooo00;oool01P000?ooooooo`000?ooo`0000Coool0
10000?ooooooo`0000goool010000?ooooooo`0000;oool00`000?ooooooo`0;oooo00<0003ooooo
ool00`000008oooo0000oooo0000oooo0000oooo00000_ooo`040000oooooooo00000oooo`030000
oooooooo00goool01@000?ooooooooooo`00000Eoooo000Qoooo00<0003oooooool00_ooo`090000
oooo0000oooo0000oooo0000oooo000000;oool010000?ooooooo`0000?oool300003oooo`030000
oooooooo00;oool01@000?ooooooooooo`000002oooo00<0003oool000000_ooo`040000oooooooo
00000oooo`<0000>oooo0`0001_oool6000000Koool00000003oool0003oool2000000?oool0003o
ool01@000003oooo00000000008000001Oooo`00000000000?ooo`02000000?oool0003oool00_oo
o`l000001?ooo`0000000?ooo`8000000oooo`000000000:000000?oool0000000000`000009oooo
0000oooo0000oooo0000oooo0000oooo008000001?ooo`0000000?ooo`<00003oooo3P0000?oool8
00005_ooo`030000oooooooo00<00002oooo0`0000;oool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`040000oooooooo00003Oooo`040000oooooooo00000_ooo`030000oooooooo00[oool0
0`000?ooooooo`03oooo00T0003oool0003oool0003oool0003oool000000_ooo`040000oooooooo
00000oooo`<0000>oooo0`0001Koool0023oool00`000?ooooooo`02oooo0P000006oooo00000000
oooo0000oooo100000?oool010000?ooooooooooo`<0000>oooo0`0000;oool200001?ooo`D00000
1?ooo`0000000?ooo`@000001?ooo`000000000000koool00`000?ooo`00000Koooo1P000003oooo
0000000000?oool00`000?ooooooo`04oooo0`000004oooo0000000000000_ooo`800004oooo0P00
00?oool@00000_ooo`800003oooo2`0000;oool300000_ooo`060000oooooooo0000oooo00001?oo
o`<000001?ooo`000000000000?oool>000000?oool0003oool0200001Goool01P000?oooooooooo
o`000?ooo`8000001Oooo`00000000000?ooo`0400000_ooo`<00002oooo0`0000ooool200000_oo
o`<0000;oooo0P0000?oool2000000Koool00000003oool0003oool400000oooo`040000oooooooo
oooo0`0000koool00`000?ooo`00000Foooo000Ooooo00<0003oool000004_ooo`030000oooooooo
01?oool00`000?ooooooo`0Woooo00<0003oooooool06_ooo`H000001?ooo`0000000?ooo`H00000
0oooo`0000000003000000?oool0000000008`000003oooo0000000001h000000oooo`000000000C
000000?oool0000000001`0001Coool00`000?ooo`000002oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`0Doooo00<0003oooooool07_ooo`030000oooooooo01?oool0
0`000?ooooooo`0Eoooo000Ooooo0`00017oool200005_ooo`050000oooooooooooo000002?oool2
00007?ooo`L00002oooo300000;oool4000000?oool0000000007`000003oooo0000000001`00002
oooo500000;oool900005?ooo`<000000oooo`000000000Boooo0P0001Ooool00`000?ooooooo`0L
oooo0P0001Coool200005oooo`00TOooogd0002Coooo002AooooO@0009?oool0097ooomm0000Tooo
o`00TOooogd0002Coooo003oooooX_ooo`00oooooj;oool00001\
\>"],
  ImageRangeCache->{{{0, 416}, {129.313, 0}} -> {-0.0833895, -0.0234425, 
  0.00761246, 0.00761246}, {{10.9375, 134.063}, {126.188, 
  3.0625}} -> {-2.36488, -1.28531, 0.0842282, 0.0842282}, {{146.375, 
  269.563}, {126.188, 3.0625}} -> {-5.55327, -1.33612, 0.0531487, 
  0.0850376}, {{281.875, 405}, {126.188, 3.0625}} -> {-24.9442, -1.28531, 
  0.0842282, 0.0842282}}]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Photo",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["sample",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
fukuzawa={\\012{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, \
1, 1, 1, 0, 
0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 
1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 
0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 
1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 
0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, \
1, 
0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 
0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, \
0, 
1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 
0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 
1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, \
0, 
1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 
1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 
0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 
1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, \
0},\\012{0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, \
0, 
0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 
0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 
1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 
1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, \
0, 
0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 
0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 
0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 
1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, \
0},\\012{0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, \
1, 
0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 
0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 
1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 
1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
1, 
1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 
1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 
0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 
0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, \
0},\\012{0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, \
1, 
0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 
0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 
0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, \
0, 
0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 
0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 
0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 
0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, \
1, 
0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 
1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 
1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 
1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, \
0, 
0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 
1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 
0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 
0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 
1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, \
1, 
1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 
0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 
1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 
0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 
0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, \
0, 
1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 
0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 
0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 
0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 
0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, \
0},\\012{0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, \
1, 
0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 
1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 
0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 
0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, \
0},\\012{0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, \
1, 
1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 
0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 
0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 
1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, \
0, 
0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 
1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, \
0, 
1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 
0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 
1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 
0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 
0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, \
1, 
0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 
1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 
1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 
0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, \
1, 
0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 
1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 
1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, \
0, 
1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 
1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 
0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, \
1},\\012{0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, \
0, 
1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 
0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 
0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 
0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, \
1, 
1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 
0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 
0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 
1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 
0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, \
0, 
1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 
0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 
0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, \
0, 
0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 
1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 
0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 
0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 
1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, \
1},\\012{0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, \
1, 
0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 
0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 
0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 
0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, \
0, 
1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 
1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 
0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 
1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 
0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, \
0},\\012{0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 
1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, \
0},\\012{1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 
1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 
1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 
1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 
0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 
0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 
0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, \
1},\\012{1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 
0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 
0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 
1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 
0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 
0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, \
1, 
1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 
0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, \
0, 
0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 
0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, \
0, 
1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 
0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 
0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, \
1, 
0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 
1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 
1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 
0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 
1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 
1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, \
0, 
0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 
1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, \
0, 
0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 
1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 
1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, \
1, 
0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 
0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, \
1, 
0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 
0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, \
1, 
1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, \
1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 
1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, \
1, 
0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, \
0, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 
0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, \
1, 
0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 
1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, \
1, 
1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 
0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, \
1, 
0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 
0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, \
0},\\012{1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, \
1, 
0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, \
0},\\012{1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, \
0, 
1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 
1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, \
0},\\012{1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, \
1, 
0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, \
0},\\012{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, \
1, 
1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 
1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 
1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, \
1, 
1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, \
0},\\012{1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, \
1, 
0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 
0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, \
0},\\012{1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, \
1, 
0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 
0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, \
0},\\012{0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, \
1, 
0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 
1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, \
0},\\012{1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, \
0, 
0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 
1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 
1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 
0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, \
0, 
1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 
1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, \
1, 
1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 
1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 
0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, \
0, 
1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 
1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 
1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, \
0},\\012{0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, \
0, 
1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 
1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 
1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, \
0, 
0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 
0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, \
0, 
0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 
1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 
1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 
0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 
1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 
0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, \
0, 
0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, \
1, 
0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 
1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, \
1, 
1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 
0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 
0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, \
1, 
1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 
1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 
0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 
0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, \
1},\\012{0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 
0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 
1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
0},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 
0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 
1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 
0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 
0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 
0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 
0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 
1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 
0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, \
1, 
1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, \
1, 
0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, \
0, 
1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, \
1},\\012{0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, \
1, 
0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, \
1, 
1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, \
0, 
1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 
1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, \
0, 
1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 
1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 
1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, \
1},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 
1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 
1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 
1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 
1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
1, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 
1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 
1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 
1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 
1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 
1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 
1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 
0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 
0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 
1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 
0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 
0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 
0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 
1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 
0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 
0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0},\\012{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};\
\>", "Input",
  Evaluatable->True,
  ImageSize->{144, 160},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(\(sampleData = Table[fukuzawa[\([i, j]\)], {i, 30, 157}, {j, 5, 132}]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
sampleFigure = 
\tListDensityPlot[sampleData,
\t\tMesh -> False,PlotLabel->\"Sample data\",
\t\tBackground->GrayLevel[1]]; \
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -35 0 ]
[.5 1.0125 35 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -96 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(data) show
129.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000FFFFFFFF0000000000000000000000
0000000000000000FF00000000000000000000000000FF00
0000000000000000000000000000000000000000000000FF
FF000000000000000000000000000000FF00000000000000
000000000000000000000000000000000000000000000000
0000FFFF00FFFFFF
000000000000000000000000000000000000000000000000
000000000000000000FF000000FFFFFFFF0000FFFF00FFFF
FFFFFFFF000000FF00FFFFFF000000FF0000FFFFFF00FFFF
0000000000FFFFFF00000000FF0000FF000000FFFF0000FF
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000FF000000000000FF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FF00FF00FFFFFFFF0000000000000000FF00
00FF00000000FFFFFFFF00FFFFFF00FFFF00000000FFFF00
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
00000000FF000000FFFF000000000000FF000000FFFFFFFF
FFFFFFFFFF00000000FFFF00000000FF0000FF000000FFFF
FF00FFFF00FFFF00000000000000FF0000000000FF000000
00000000000000000000FF00FF00FFFFFF00FFFFFFFFFF00
0000000000000000
000000000000000000FFFFFF0000FFFF0000000000000000
00000000000000000000FF00000000000000FF000000FFFF
00FFFFFFFFFF00FF00FFFF00FF0000FFFFFFFF0000000000
FFFF00FF000000FFFFFFFF00000000000000000000000000
00000000000000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFF
FFFF00000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFF0000000000000000FF0000FFFF
0000000000FFFFFFFFFFFFFFFFFF0000FF0000FF00000000
000000FFFF0000FF00FF00000000000000000000000000FF
00000000000000000000FF00FFFFFFFFFFFFFFFF0000FFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
000000000000FF0000FFFFFF000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFF0000000000000000000000000000FF
FF0000000000000000000000FFFFFF000000000000FFFFFF
0000FF00000000FF
FFFFFFFFFFFFFFFFFF0000000000000000000000000000FF
00FF0000FFFFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FF
FFFFFF000000000000000000FFFFFFFFFF00FF0000FFFFFF
00FFFF000000FFFF
0000000000000000FFFFFFFF000000000000000000000000
0000FF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFF00000000000000FFFFFFFFFF00FF0000FFFFFF
00FFFFFFFF00FFFF
0000000000000000FFFFFFFF00000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFF00000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFFFFFF00000000FFFFFFFFFF00FFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFF00FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00
FFFFFFFF00FFFF00000000000000FFFF0000FF0000FFFFFF
0000FFFFFF0000FF
0000000000000000FFFF0000000000FFFFFF000000FFFFFF
FF00FF00FF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFF00FFFF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFF00000000000000000000FFFFFF
0000FF00FF0000FF
0000000000000000FF0000000000FFFFFFFFFF00FFFFFFFF
000000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFF00FFFFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFF00FFFF000000FFFFFFFFFF00000000FFFF
0000FFFF00FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF
0000FFFFFF00FFFF
000000000000000000000000FFFFFFFFFFFF00FF00FFFFFF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFF
FFFFFFFFFF0000FFFF00000000FFFFFFFF00FFFFFF00FFFF
FF000000FFFFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF00
0000FFFFFF0000FF
00000000000000000000FFFFFFFFFFFFFFFFFFFF00FF0000
FFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFF00000000FFFFFF000000FFFF00FFFF
FF000000FFFFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF
0000FFFF00FFFFFF
00000000FF00000000000000FFFFFFFFFFFFFFFFFF000000
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFF
FFFFFFFFFFFF0000FFFF00000000FFFFFFFFFFFFFF00FFFF
FF0000FFFFFFFF00FFFFFF00000000FFFFFFFFFFFF000000
0000FFFFFFFFFFFF
00000000FF00FF0000FF00FFFF000000FFFFFF00000000FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFF
FFFF0000FFFF00FFFF00FFFF000000FFFFFFFFFFFF000000
0000FFFF00FFFFFF
000000000000FF00FFFFFFFFFF00FF00FFFF0000000000FF
0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF00FF00FFFF
FFFF00FF00FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF
000000000000FFFF
0000000000FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFF00FF00FF0000FFFFFF
FFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000000000FFFF00
000000FFFFFFFFFF00FF00FF000000FF0000FFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FF
FFFFFFFFFFFFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFF
FF0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFF0000000000
000000FF00FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFF
FF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF
FF0000FF00FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
00000000000000FF
000000FFFF00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFF
FF00FFFFFFFF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00
FF00000000000000
00000000FFFFFFFF000000FF000000FFFFFFFFFF00FFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF
FFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000000000000000
00000000FFFFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF
FFFFFFFFFFFFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFF
FFFF0000FF00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF00
00000000000000FF
00000000FFFF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFF
FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FF
FFFFFFFF00FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF
00FFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FF00FFFF00FFFFFFFFFFFFFF0000FF00FFFF0000
00000000FF0000FF
000000000000000000FFFFFFFFFFFF000000FFFFFF00FFFF
0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FF
FFFFFFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
00FF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00FF00FFFFFF0000FF0000FF00FF0000
000000000000FFFF
0000000000FF000000FFFFFFFFFFFF0000FFFFFF00FF0000
00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF000000000000FF
FFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF
00FFFFFFFFFF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFF
FF00FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000FFFF
000000FF00FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FF00000000FF
FFFFFF00FFFF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF0000000000FF0000FFFF00000000FFFF000000
0000000000000000
00FFFFFFFFFF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF
00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FF
FFFF0000FFFF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
00FFFFFF000000000000FF00FFFFFFFF0000FFFFFF000000
000000FF0000FF00
FF00FFFFFFFFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF
00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000
FFFFFFFF00FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF000000FFFFFFFFFFFFFF000000FFFF00000000
000000000000FF00
FFFFFFFFFFFFFFFFFFFF00FFFFFF0000000000FFFF0000FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
FFFF00FFFFFFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FF
FF0000FFFFFF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00
FFFFFFFF00FF00FFFF000000FFFFFF0000FFFFFF00000000
0000000000000000
FFFF00FFFFFFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF00
00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00
FFFF00FFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000
FF0000FFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00
FFFF00FF00FF00FFFFFF000000FFFF000000FF0000000000
0000000000000000
FFFFFFFF00FFFF00FFFF0000FFFF00FFFF00FFFF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00
FF00FFFFFF0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF
00FF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF
00FFFF00FFFF00FFFFFF000000FFFF000000FFFF00000000
0000FF0000000000
FFFFFFFFFFFFFFFF00FF0000FFFF00000000FFFF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00
FFFFFF00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFF00FF0000FF00FF0000FF00FF00FF000000000000
00FFFFFFFF000000
FFFFFFFFFFFFFFFFFFFF0000FFFF0000FF00FFFF00000000
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFF
FFFFFF00FF000000FF00FF00FFFFFF000000000000000000
0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFF0000FF00FF0000000000
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00
FFFF0000FF00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FF
FFFF0000FF00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFF
FFFF0000FFFFFF00FFFF0000FF000000FF00FF000000FFFF
00FFFFFF00000000
00000000000000FFFFFFFF00FF000000FF000000FFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FF000000FFFFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFF
FFFFFF00FFFF0000FF0000000000000000000000FFFF0000
FFFFFFFFFFFFFFFF
00000000000000000000FF00FFFF00FFFF0000FFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FF
FFFF00FF000000FF00FFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FF
FF0000FFFFFF0000FFFFFF000000FF000000FF0000FF0000
0000FFFFFFFFFF00
00000000000000000000FFFFFFFFFF00FF000000FFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00
FF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFF
FF00FFFFFF000000FFFFFF00000000FF000000FFFFFFFFFF
00FFFF00000000FF
FFFFFFFFFF00FFFFFFFFFFFF00FFFF00FF000000FFFF0000
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
FFFFFFFF0000FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFF00FF00FFFF0000FF00FF0000FF
FFFFFFFF0000FF00
00000000000000000000FFFF00000000FF00000000FF0000
00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF
0000FFFF00FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFF0000FF0000FFFF0000FF0000FF000000FFFF
00FFFF00FF00FFFF
00000000000000000000FFFF0000FF00FFFF000000FF0000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00
0000000000000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF00
00FFFFFF0000FF00FF00000000FFFF00FF0000FFFFFFFF00
FF00FFFF00FFFFFF
00000000000000000000FFFF000000000000000000FFFF00
00FF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000
FFFF00FFFF00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000
FFFFFFFFFFFF0000FF00FFFFFF00FFFFFF0000000000FFFF
FF00FFFFFFFFFFFF
00000000000000000000FFFF00000000FF00FF0000FFFF00
00FFFF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFF
FFFFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF00
0000FF00FFFFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FF
FFFFFFFFFFFF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
00000000000000000000FFFFFF000000000000FF0000FF00
0000FFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000
FF00FFFF00FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFF
00000000000000000000FFFF00000000000000FFFFFFFF00
0000FFFFFF000000FFFFFF00FFFF00FFFF00FFFF00FFFF00
FFFFFFFFFFFFFFFFFFFF000000FF00FF0000FFFF000000FF
FFFFFF0000FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF0000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF
00000000000000000000FFFF000000000000FFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00
FFFFFFFFFFFFFFFFFF000000FF0000FFFF00FFFFFFFFFF00
00000000FF0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FF00FF00FFFFFFFF
00000000000000000000FFFF000000000000FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00
FFFFFFFFFFFFFFFF0000FFFFFF000000FFFFFF000000FF00
FFFF0000000000FF00FFFF00FFFFFFFFFF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFF
FF0000FFFFFF00000000FF000000000000000000FFFFFF00
FF000000000000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00
FF00FFFF0000000000FFFF0000000000000000000000FF00
000000FF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00
FFFFFFFF00FF0000FF00000000000000000000000000FF00
000000FF000000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF
00FFFFFF00FF00FF00000000000000000000000000000000
FF0000FF000000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF0000000000FF0000000000000000000000000000000000
FF00FF00000000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00
FF0000000000000000000000000000000000000000000000
00000000000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FFFF000000000000000000000000000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FF0000000000000000000000000000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FFFF000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFF00000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFFFF000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000000000000000000000FFFF00FF000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000000000000000FFFFFF000000000000FF00
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000FF0000FFFF0000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
00000000FF000000FF000000000000000000000000FF0000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000FFFF00000000000000FFFFFF00000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000FF0000FF00FF000000FFFF00000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FF0000FFFF00FFFF0000000000000000000000FF00
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
0000000000FF00FFFFFFFFFFFFFFFFFF00FFFF0000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
00000000FFFFFF00FFFFFFFF0000FF0000000000FF000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FF00FFFFFFFFFFFFFF000000000000FFFF00FF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000FF00000000FF00FF0000000000000000000000FF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000FFFFFF0000FFFF00FF00000000000000000000FF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
FFFFFFFFFFFF00FFFF00FFFF00FF000000FF00FFFFFF0000
00FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
00FFFFFFFFFFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFF
FFFFFF0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
00FFFFFF0000000000FFFF00FF00FF000000FF0000000000
00FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFF00FF00000000FFFFFFFFFF0000FF000000000000
00FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
00000000000000000000FFFFFFFFFFFF000000FF00000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
FF0000000000000000000000FFFFFFFF0000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000FF00FF00000000000000FFFF000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
0000000000FFFFFF0000000000FFFF00000000FF000000FF
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FF00FF0000FFFFFF000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000000000000000000000FFFFFFFF0000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00
FF00FFFFFF00FF0000000000FF00FFFF000000000000FFFF
FFFF00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF
00FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FF00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FFFFFFFFFFFFFF00FFFFFFFF000000FF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF00FFFFFFFFFFFF00000000FFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
00FF0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00
00FF00FFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FFFFFFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFF
FFFFFF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FF0000FF000000000000000000FFFF00FFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFF
00000000FF000000FF00FF000000FFFFFF00FFFFFFFFFFFF
FFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000000000FFFF00FF000000FF0000FFFFFF00FF0000FF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFFFF00
FFFF00FFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
00000000000000FF000000000000FF0000000000FFFF00FF
00FFFF00FF00FFFF00FFFFFF00FF00FFFFFFFFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFF00FF
FF00FF00FFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FF0000000000000000000000FF00FF00
000000FF00FFFFFF0000FF00FFFFFF000000FFFFFFFF00FF
FFFF00FF00FFFFFFFF00FFFFFF00FF00FFFFFFFFFFFF00FF
00FFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFFFFFF
00000000000000000000000000000000000000000000FF00
00000000FF0000000000FFFFFFFF00FF0000FFFFFFFFFFFF
FFFF00FF0000FFFF00FFFF0000FFFF00FFFFFFFFFF0000FF
FFFF00FFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FF00FFFFFFFFFF
00000000000000000000000000000000000000FF00000000
00000000FF00FF00000000FF00000000FF0000FFFF000000
FFFFFFFF00FF00FF00FFFF0000FFFF00FFFFFF00FFFFFFFF
FF00FFFF00FFFF00FFFFFF00FFFFFFFFFF00FFFFFF00FFFF
FFFFFFFFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFF00FFFFFF
FF00FFFFFF00FFFF
00FF000000000000000000000000000000FF000000000000
000000000000FFFF00FF0000FFFF00FF00000000FF00FFFF
FF00000000FF0000FF00000000FFFFFFFF00FFFFFF00FF00
FF00FFFF0000FF0000FFFF00FF00FF000000FFFFFF00FFFF
00FF00FF0000FFFFFF00FF00FFFFFF0000FFFFFF00FFFF00
00FFFF00FF0000FF
000000000000000000000000000000000000000000000000
00000000000000000000FF0000FF000000000000FF0000FF
000000FFFF00000000FFFF000000FF00FF00FFFF00000000
FF0000FF0000FFFF00FF00FF00FFFFFFFFFFFFFF00FF0000
FFFFFFFF00FFFF00000000FF00FFFFFFFFFF00FFFFFFFF00
FF00FF00FFFF0000
0000000000000000FF000000000000000000000000000000
000000FFFF000000000000000000000000000000000000FF
000000FF00000000000000FFFFFF00000000FF000000FF00
FFFF0000FF000000FF00FF0000FF00FF000000FF0000FFFF
0000000000000000FF00FFFF00FF0000FFFFFF000000FF00
00000000FF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF0000FF0000
000000000000000000000000000000FFFF0000000000FFFF
FF00FF0000FF00000000FF00FFFF00FFFF0000FFFF00FF00
0000000000FFFF00FF000000000000FF0000FF0000000000
FF0000FF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FF0000000000000000
0000FF00000000000000FFFF000000000000FF000000FF00
0000FF0000FF000000000000000000000000FFFF0000FFFF
00000000FF00FF00000000000000FF000000000000000000
0000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`02oooo4P0000OooolU00000_oooaT00002oooo;`00
00CooolM00000_oood000004oooo0P0000_oool00`000?ooooooo`02oooo000Aoooo00<0003oool0
00001?ooo`030000oooooooo00;ooolB00001oooobD00002oooo6@0000;oool_00001?oooad00002
oooo@00000Coool200002oooo`030000oooooooo00;oool001;oool00`000?ooooooo`03oooo00<0
003oooooool00_oood000002oooo1P0000Soool400001?ooo`030000oooooooo00[oool600000_oo
o`800006oooo1P0000;oool300001_ooo`800004oooo2P0000Koool700000_ooo`@00002oooo1P00
00Coool400000_oooch00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooom0
00000_ooo`H00008oooo100000Coool00`000?ooooooo`0:oooo1P0000;oool200001_ooo`H00002
oooo0`0000Koool200001?ooo`X00006oooo1`0000;oool400000_ooo`H00004oooo100000;oooln
00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo<`0000;oool;00000_oo
o`@0000Koooo200000;oool200000_ooo`800008oooo3`0000;oool400000_ooo`P00008oooo00<0
003oooooool01?ooo`800004oooo200000Cooom000001Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`02oooo<`0000;oool;00000_ooo`@0000Koooo200000;oool200000_ooo`800008
oooo3`0000;oool400000_ooo`P00008oooo00<0003oooooool01?ooo`800004oooo200000Cooom0
00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo=P0000;oool600001?oo
o``00002oooo1P00017oool800001?ooo`P00002oooo0`0000;oool600001_ooo`800004oooo0P00
00Coool=00000_ooo`X00002oooo6@0000;oool200000_ooo`800006oooo0P0000WooolB00001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo=P0000;oool600001?ooo``00002
oooo1P00017oool800001?ooo`P00002oooo0`0000;oool600001_ooo`800004oooo0P0000Coool=
00000_ooo`X00002oooo6@0000;oool200000_ooo`800006oooo0P0000WooolB00001Oooo`030000
oooooooo00;oool001Soool200000ooooa800005oooo100000CooolS00000_ooo`h00002oooo1@00
00Coool200002_ooo`800002oooo0P0000Coool200000_ooo`@00007oooo2P0000Coool200000_oo
o`H00007oooo;@0000;oool200005oooo`800008oooo0P0000Soool200001?ooo`006?ooo`030000
oooooooo00;ooolB00001Oooo`@00004oooo8`0000;oool>00000_ooo`D00004oooo0P0000[oool2
00000_ooo`800004oooo0P0000;oool400001oooo`X00004oooo0P0000;oool600001oooobd00002
oooo0P0001Ooool200002?ooo`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00Kooold00003?oooa000002oooo0`0000Coool:00004_ooo`@000000oooo`000000000200000_oo
o`h00004oooo100000;oool200000_oooaT00002oooo4`0000;oool200004?ooo`@00003oooo0P00
00Soool200002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`06oooo=00000coool@
00000_ooo`<00004oooo2P0001;oool4000000?oool0000000000P0000;oool>00001?ooo`@00002
oooo0P0000;ooolI00000_oooa<00002oooo0P00013oool400000oooo`800008oooo0P0000Woool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooocX00002oooo100000KooolG0000<ooo
o`80000<oooo6`0000CooolE00001_ooo``00005oooo100000;oool800001oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooo>P0000;oool400001_oooaL0000coooo0P0000cooolK
00001?oooaD00006oooo300000Goool400000_ooo`P00007oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo01CooolK00000_ooo`800002oooo0`0000Soool200002?ooo`@0000<oooo00<0
003oooooool00P0004Koool200001?ooo`800002oooo0P0000Soool200002?oooa40000:oooo0P00
00;oool400001Oooo`800004oooo1P0000Woool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool05?oooa/00002oooo0P0000;oool300002?ooo`800008oooo100000coool00`000?ooooooo`02
0000A_ooo`800004oooo0P0000;oool200002?ooo`800008oooo4@0000[oool200000_ooo`@00005
oooo0P0000Coool600002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo4000
00OooolL00000_ooo`030000oooooooo00Soool200006Oooo`80000Foooo0P0002coool200005?oo
o`800002oooo0P0000Ooool>00002_ooo`800002oooo100000Goool200002?ooo`800009oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool@00001ooooa@0000`oooo0P0000coool2
00002?ooo`@0000Soooo0P0000;oool200005oooo`80000=oooo3P0002[oool00`000?ooooooo`02
oooo000Hoooo0P0000?oool@00001ooooa@0000`oooo0P0000coool200002?ooo`@0000Soooo0P00
00;oool200005oooo`80000=oooo3P0002Woool200001?ooo`006?ooo`030000oooooooo00;oool@
00001oooo`P0000:oooo0P0000[oool00`000?ooooooo`0>oooo0P0001?oool200002?ooo`800004
oooo0P0000[oool200009Oooo`8000000oooo`000000000200003_ooo`800004oooo0P0000Soool0
0`000?ooooooo`02oooo3P0000Coool400000_ooo`@00005oooo100000Koool400001oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo400000Ooool800002_ooo`80000:oooo00<0
003oooooool03_ooo`80000Coooo0P0000Soool200001?ooo`80000:oooo0P0002Goool2000000?o
ool0000000000P0000koool200001?ooo`800008oooo00<0003oooooool00_ooo`h00004oooo1000
00;oool400001Oooo`@00006oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_oooa000003oooo2P0000Koool600002?ooo`800002oooo00<0003oooooool00P0000Koool4
00005oooo`800006oooo0P0000Coool200000_ooo`800006oooo0P0000Woool200000_ooo`80000H
oooo0P000003oooo000000000080000<oooo0P0000Koool600004Ooooa@00005oooo100000;oool2
00000_ooo`@00007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool@00000ooo
o`X00006oooo1P0000Soool200000_ooo`030000oooooooo00800006oooo100001Ooool200001_oo
o`800004oooo0P0000;oool200001_ooo`800009oooo0P0000;oool200006?ooo`8000000oooo`00
0000000200003?ooo`800006oooo1P00017ooolD00001Oooo`@00002oooo0P0000;oool400001ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo400000;oool900002_ooo`800008
oooo1P0000?oool200008Oooo`800006oooo0P0000Soool200002?ooo`80000;oooo0P0001Coool2
00001?ooo`D0000:oooo200000Coool400001?ooo`030000oooooooo0080000<oooo100000;oool4
00001?ooo`@00003oooo100000Koool200002Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo400000;oool900002_ooo`800008oooo1P0000?oool200008Oooo`800006oooo0P00
00Soool200002?ooo`80000;oooo0P0001Coool200001?ooo`D0000:oooo200000Coool400001?oo
o`030000oooooooo0080000<oooo100000;oool400001?ooo`@00003oooo100000Koool200002Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo5`0000coool200000_ooo`80000<
oooo0`0002?oool200004?ooo`800008oooo0P0000Ooool200001?ooo`80000>oooo100000Coool7
00002?ooo`800006oooo0P0000Koool600005Oooo`800004oooo1P0000?oool600001_ooo`@00007
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooolG00003?ooo`800002oooo0P00
00coool300008oooo`80000@oooo0P0000Soool200001oooo`800004oooo0P0000koool400001?oo
o`L00008oooo0P0000Koool200001_ooo`H0000Eoooo0P0000Coool600000oooo`H00006oooo1000
00Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oooa<0000Doooo0P0000;oool4
00001_ooo`030000oooooooo00[oool200005oooo`80000Boooo0P0000Soool200002Oooo`@0000F
oooo1`0000Koool600001?ooo`800006oooo1P0000Goool400005_ooo`@00003oooo100000Coool2
00002oooo`030000oooooooo00;oool001Soool200000ooooa<0000Doooo0P0000;oool400001_oo
o`030000oooooooo00[oool200005oooo`80000Boooo0P0000Soool200002Oooo`@0000Foooo1`00
00Koool600001?ooo`800006oooo1P0000Goool400005_ooo`@00003oooo100000Coool200002_oo
o`800004oooo000Hoooo00<0003oooooool00_ooo`P00002oooo3@0001;oool600004oooo`80000G
oooo0P0001coool400002Oooo`80000@oooo100000Coool700003_ooo`800006oooo100000Ooool2
00001_ooo`P0000<oooo2@00017oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`P00002oooo3@0001;oool600004oooo`80000Goooo0P0001coool400002Oooo`80000@oooo1000
00Coool700003_ooo`800006oooo100000Ooool200001_ooo`P0000<oooo2@00017oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00002oooo0P0000;oool4000000?oool00000
00001?ooo`H00006oooo200000;oool200000_ooo`80000Voooo0P0001coool400008oooo`L0000:
oooo0P0000coool400000oooo`800004oooo0P0000Coool600003?ooo`T00004oooo0P0000_oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00002oooo0P0000;oool4000000?o
ool0000000001?ooo`H00006oooo200000;oool200000_ooo`80000Voooo0P0001coool400008ooo
o`L0000:oooo0P0000coool400000oooo`800004oooo0P0000Coool600003?ooo`T00004oooo0P00
00_oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo``00002oooo0P0000Woool2
00000_ooo`800004oooo2P0000;oool400003oooo`80000Eoooo100001koool200008Oooo`T0000:
oooo0P0000;oool200002?ooo`800002oooo00<0003oooooool03_ooo`800006oooo100000Koool0
0`000?ooooooo`0<00002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo3000
00;oool200002Oooo`800002oooo0P0000Coool:00000_ooo`@0000?oooo0P0001Goool400007_oo
o`80000Qoooo2@0000[oool200000_ooo`800008oooo0P0000;oool00`000?ooooooo`0>oooo0P00
00Koool400001_ooo`030000oooooooo00`00009oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool:00000_ooo`80000;oooo0P0000;oool200000_ooo`@00002oooo0P0000Koool4
0000:?ooo`80000Loooo0P0000;oool00`000?ooooooo`04oooo100001Coool200000_ooo`<00006
oooo0P0000;oool200000_ooo`@0000:oooo100000Ooool200006oooo``00004oooo0P0000Goool0
0`000?ooooooo`02oooo000<oooo0`0000?oool00`000?ooooooo`03oooo00<0003oooooool00_oo
o`X00002oooo0P0000_oool200000_ooo`800002oooo100000;oool200001_ooo`@0000Xoooo0P00
01coool200000_ooo`030000oooooooo00Coool400005?ooo`800002oooo0`0000Koool200000_oo
o`800002oooo100000[oool400001oooo`80000Koooo300000Coool200001Oooo`030000oooooooo
00;oool000coool00`000?ooooooo`02oooo00<0003oool000001?ooo`030000oooooooo00;oool6
00002_ooo`8000000oooo`0000000002oooo1P0000;oool400001?ooo`80000:oooo0P0002Koool2
00007_ooo`<0000:oooo0P0001;oool200001Oooo`800004oooo0P0000Soool200002?ooo`@00002
oooo00<0003oooooool06_ooo`800007oooo0P0000Coool:00001Oooo`030000oooooooo00;oool0
00goool01`000?ooooooooooo`000?ooo`000004oooo0`0000;oool600002_ooo`8000000oooo`00
00000002oooo1P0000;oool400001?ooo`80000:oooo0P0002Koool200007_ooo`<0000:oooo0P00
01;oool200001Oooo`800004oooo0P0000Soool200002?ooo`@00002oooo00<0003oooooool06_oo
o`800007oooo0P0000Coool:00000oooo`<00004oooo000=oooo00L0003oooooooooool0003oool0
00001?ooo`030000oooooooo00;oool600000_ooo`800006oooo0`0000Coool200001?ooo`H0000>
oooo0P0000goool200005_ooo`<0000Noooo0P0000;oool300002?ooo`80000Goooo0P00013oool2
00002?ooo`@00002oooo00<0003oooooool00_ooo`80000@oooo100000_oool>00001oooo`030000
oooooooo00;oool000coool00`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo
00;oool600000_ooo`800006oooo0`0000Coool200001?ooo`H0000>oooo0P0000goool200005_oo
o`<0000Noooo0P0000;oool300002?ooo`80000Goooo0P00013oool200002?ooo`@00002oooo00<0
003oooooool00_ooo`80000@oooo100000_oool>00001oooo`030000oooooooo00;oool000goool0
0`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo00;oool600001?ooo`800006
oooo00<0003oooooool01?ooo`H0000@oooo0P0002Ooool300006?ooo`800002oooo0P00017oool2
00005?ooo`<0000@oooo0P0000Soool200001oooo`800002oooo100000;oool200002?ooo`@00009
oooo0P0000;oool>00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo1P00
00Coool200001_ooo`030000oooooooo00Coool600004?ooo`80000Woooo0`0001Soool200000_oo
o`80000Aoooo0P0001Coool300004?ooo`800008oooo0P0000Ooool200000_ooo`@00002oooo0P00
00Soool400002Oooo`800002oooo3P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`P00008oooo1@0000;oool600002_ooo`800006oooo100001ooool200001Oooo`800008
oooo100001Woool200002?ooo`80000<oooo0P00017oool400001?ooo`80000<oooo0P000003oooo
00000000027ooolB00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2000
00Soool500000_ooo`H0000:oooo0P0000Koool400007oooo`800005oooo0P0000Soool400006Ooo
o`800008oooo0P0000coool200004Oooo`@00004oooo0P0000coool2000000?oool0000000008Ooo
oa800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800001_ooo`800002
oooo00<0003oooooool0100000coool200001_ooo`80000Zoooo0P0000Soool200002?ooo`80000A
oooo100001Koool200001Oooo`800004oooo0P0000Koool200000_ooo`80000:oooo10000003oooo
0000000000;oool400004?ooo`800009oooo400000Ooool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_ooo`P00006oooo0P0000;oool00`000?ooooooo`0400003?ooo`800006oooo0P00
02[oool200002?ooo`800008oooo0P00017oool400005_ooo`800005oooo0P0000Coool200001_oo
o`800002oooo0P0000[oool4000000?oool0000000000_ooo`@0000@oooo0P0000Woool@00001ooo
o`030000oooooooo00;oool001Soool200000oooo`P00004oooo100000Goool200002_ooo`800004
oooo0P0001?oool200000_ooo`80000Boooo0P0000;oool300002_ooo`800002oooo0P0000;oool2
00004Oooo`@00008oooo0P0000coool700007_ooo`@000000oooo`0000000004oooo0P0000koool4
00000_ooo`800004oooo2`0000;oool400001_ooo`800004oooo000Hoooo00<0003oooooool00_oo
oa80000;oooo1P0000Koool200001?ooo`@00009oooo0P0001;oool200000_ooo`800002oooo0`00
00coool200000_ooo`80000:oooo0P0000_oool200001_ooo`800002oooo0P0000Soool20000:?oo
o`@00002oooo0P0000;oool200001_ooo`@00002oooo100000;oool200000_ooo`l00009oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;ooolB00002oooo`H00006oooo0P0000Coool4
00002Oooo`80000Boooo0P0000;oool200000_ooo`<0000<oooo0P0000;oool200002_ooo`80000;
oooo0P0000Koool200000_ooo`800008oooo0P0002Soool400000_ooo`800002oooo0P0000Koool4
00000_ooo`@00002oooo0P0000;oool?00002Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo2P0000;oool600002oooo`@00006oooo0P0000;oool600003oooo`80000>oooo2`00
00Koool400003_ooo`80000?oooo0P0000Koool200002_ooo`800007oooo0P0000Coool200002?oo
o`80000:oooo0P0000Goool800006?oooa400009oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool:00000_ooo`H0000;oooo100000Koool200000_ooo`H0000?oooo0P0000koool;
00001_ooo`@0000>oooo0P0000ooool200001_ooo`80000:oooo0P0000Ooool200001?ooo`800008
oooo0P0000[oool200001Oooo`P0000Hoooo4@0000Woool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_ooo`H00002oooo0P0000Coool200003oooo`800006oooo0P0001?oool200004_oo
o`800002oooo1`0000Soool200001?ooo`@00002oooo100002?oool200008oooo`800007oooo2P00
00;oool400001?ooo`P00004oooo5@0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`H00002oooo0P0000Coool200003oooo`800006oooo0P0001?oool200004_ooo`800002
oooo1`0000Soool200001?ooo`@00002oooo100002?oool200008oooo`800007oooo2P0000;oool4
00001?ooo`P00004oooo5@0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`80000:oooo0P0000ooool600000_ooo`800002oooo0P0000Coool200002oooo`80000Doooo0P00
00;oool500001_ooo`@00004oooo0P0000Coool400004oooo`80000Boooo0P0000Woool200005?oo
o`800006oooo2`0000;oool200002?ooo`@00006oooo2`0000;oool400000_ooo`800005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool200002_ooo`80000?oooo1P0000;oool2
00000_ooo`800004oooo0P0000_oool200005?ooo`800002oooo1@0000Koool400001?ooo`800004
oooo100001?oool200004_ooo`800009oooo0P0001Coool200001_ooo`/00002oooo0P0000Soool4
00001_ooo`/00002oooo100000;oool200001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`04oooo0P0000ooool200000_ooo`@00004oooo0P0000Koool200001_ooo`80000?oooo0P00
01Coool700002?ooo`800006oooo0P0000koool00`000?ooooooo`08oooo0P0000koool200008Ooo
o`800007oooo1P0000koool600001?oooa<00002oooo0P0000Goool00`000?ooooooo`02oooo000H
oooo0P0000Goool200003oooo`800002oooo100000Coool200001_ooo`800006oooo0P0000ooool2
00005?ooo`L00008oooo0P0000Koool200003_ooo`030000oooooooo00Soool200003_ooo`80000Q
oooo0P0000Ooool600003_ooo`H00004oooo4`0000;oool200001?ooo`800004oooo000Hoooo00<0
003oooooool05Oooo`800006oooo2P0000Coool400000_ooo`80000Woooo1@0000Coool200004_oo
o`800004oooo0`0000Soool400001?ooo`@00006oooo0P0000Woool200002_ooo`@00006oooo0P00
00Soool00`000?ooooooo`0200001?ooo`H00006oooo100000KooolG00001Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`0Eoooo0P0000Koool:00001?ooo`@00002oooo0P0002Ooool5
00001?ooo`80000Boooo0P0000Coool300002?ooo`@00004oooo100000Koool200002Oooo`80000:
oooo100000Koool200002?ooo`030000oooooooo00800004oooo1P0000Koool400001_oooaL00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Koool200002?ooo`800005oooo0P00
00Koool400002?ooo`800002oooo100000ooool200004_ooo`@00003oooo0P0000Coool200001_oo
o`800002oooo100000[oool200002oooo`@00002oooo100000Koool200005Oooo`@00006oooo0P00
00Coool200000_ooo`030000oooooooo00800006oooo1P0000Coool600000_oooaT00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00Koool200002?ooo`800005oooo0P0000Koool4
00002?ooo`800002oooo100000ooool200004_ooo`@00003oooo0P0000Coool200001_ooo`800002
oooo100000[oool200002oooo`@00002oooo100000Koool200005Oooo`@00006oooo0P0000Coool2
00000_ooo`030000oooooooo00800006oooo1P0000Coool600000_oooaT00005oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00[oool200001?ooo`800003oooo100000Coool200001?oo
o`800004oooo200002Ooool300000_ooo`800002oooo0P0000Koool400004_ooo`<00006oooo1000
00;oool200000_ooo`80000<oooo0P00017oool200001?ooo`800002oooo0P0000Coool200000ooo
o`800006oooo1P0000Coool600001?ooo`/00002oooo2P0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool02_ooo`800004oooo0P0000?oool400001?ooo`800004oooo0P0000Coool8
00009oooo`<00002oooo0P0000;oool200001_ooo`@0000Boooo0`0000Koool400000_ooo`800002
oooo0P0000coool200004Oooo`800004oooo0P0000;oool200001?ooo`800003oooo0P0000Koool6
00001?ooo`H00004oooo2`0000;oool:00001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`0Boooo0P000003oooo0000000000800004oooo200000Coool200000_ooo`@0000Yoooo00<0
003oooooool00P0000Koool200000_ooo`@0000Ooooo1P0002Ooool200002_ooo`030000oooooooo
00@00002oooo0P0000;oool400000_ooo`800002oooo0P0000;oool=00002?ooo`H00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo01;oool2000000?oool0000000000P0000Coool8
00001?ooo`800002oooo100002Woool00`000?ooooooo`0200001_ooo`800002oooo100001ooool6
00009oooo`80000:oooo00<0003oooooool0100000;oool200000_ooo`@00002oooo0P0000;oool2
00000_ooo`d00008oooo1P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool05Ooo
o`@00004oooo100000;oool200001?ooo`P0000Aoooo0P0001Koool00`000?ooooooo`04oooo0P00
00Coool400005oooo`80000@oooo0P0000ooool200002?ooo`@00004oooo0P0000[oool2000000?o
ool000000000100000;oool200000_ooo`800006oooo5@00017oool00`000?ooooooo`02oooo000H
oooo0P0001Koool400001?ooo`@00002oooo0P0000Coool800004Oooo`80000Foooo00<0003ooooo
ool01?ooo`800004oooo100001Ooool200004?ooo`80000?oooo0P0000Soool400001?ooo`80000:
oooo0P000003oooo0000000000@00002oooo0P0000;oool200001_oooaD0000@oooo0P0000Coool0
01Soool00`000?ooooooo`0Goooo0P0000Coool400000_ooo`800002oooo2P00017oool200005_oo
o`030000oooooooo00800004oooo100000;oool200004?ooo`800005oooo100000Coool200001_oo
o`@00002oooo0P0000Soool00`000?ooooooo`0200002_ooo`800004oooo0P0000Soool400001Ooo
o`800004oooo100000;oool600000_ooo`800002oooo1P0000?oool200001_ooo`P00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo01Ooool200001?ooo`@00002oooo0P0000;oool:
00004Oooo`80000Foooo00<0003oooooool00P0000Coool400000_ooo`80000@oooo0P0000Goool4
00001?ooo`800006oooo100000;oool200002?ooo`030000oooooooo0080000:oooo0P0000Coool2
00002?ooo`@00005oooo0P0000Coool400000_ooo`H00002oooo0P0000;oool600000oooo`800006
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`h00007oooo0P00
00;oool600000_ooo`H00004oooo100002Woool00`000?ooooooo`04oooo1P0000Koool200000_oo
o`800004oooo0P0001_oool200003oooo`80000:oooo100000;oool200002_ooo`800003oooo1000
00;ooolF00001?ooo`<0000Eoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool>
00001oooo`800002oooo1P0000;oool600001?ooo`@0000Yoooo00<0003oooooool01?ooo`H00006
oooo0P0000;oool200001?ooo`80000Koooo0P0000ooool200002_ooo`@00002oooo0P0000[oool2
00000oooo`@00002oooo5P0000Coool300005Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo4`0000;oool200001?ooo`800004oooo100000Koool400008Oooo`@00004oooo0`00
00Koool200000_ooo`H00002oooo0P00017oool600003?ooo`800004oooo0P0001Goool400000_oo
o`@00004oooo100000Goool400001_ooo`H00002oooo1P0000;oool400000_ooo`L0000:oooo0P00
00Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oooa<00002oooo0P0000Coool2
00001?ooo`@00006oooo1000027oool400001?ooo`<00006oooo0P0000;oool600000_ooo`80000A
oooo1P0000coool200001?ooo`80000Eoooo100000;oool400001?ooo`@00005oooo100000Koool6
00000_ooo`H00002oooo100000;oool700002_ooo`800005oooo00<0003oooooool00_ooo`003Ooo
o`<00002oooo00<0003oooooool00oooo`030000oooooooo00;ooolC00002_ooo`800002oooo1P00
00Coool400008oooo`800002oooo0`0000;oool200000_ooo`800006oooo0P0000Koool200008ooo
o`80000;oooo0P0000[oool200000_ooo`800002oooo0P0000Koool200001Oooo`H00006oooo2000
00;oool600002Oooo`800004oooo200000Ooool00`000?ooooooo`02oooo000>oooo00H0003ooooo
ool0003oool00004oooo00<0003oooooool00_oooa<0000:oooo0P0000;oool600001?ooo`@0000S
oooo0P0000;oool300000_ooo`800002oooo0P0000Koool200001_ooo`80000Soooo0P0000_oool2
00002_ooo`800002oooo0P0000;oool200001_ooo`800005oooo1P0000Koool800000_ooo`H00009
oooo0P0000Coool800001oooo`030000oooooooo00;oool000coool4000000Coool0003oool00004
oooo0`0000coool200002oooo`800004oooo0P0000;oool600001?ooo`H00005oooo0P0001[oool2
00000_ooo`<00006oooo0P0000[oool200005oooo`800002oooo0P0000[oool400000_ooo`800002
oooo0P0000?oool200002?ooo`80000<oooo1000017oool200000_ooo`800004oooo100000;oool2
00000_ooo`<0000:oooo100000;oool200000oooo`<00004oooo000<oooo00<0003oool000000_oo
o`030000oooo000000Coool00`000?ooooooo`0<oooo0P0000_oool200001?ooo`800002oooo1P00
00Coool600001Oooo`80000Joooo0P0000;oool300001_ooo`80000:oooo0P0001Ooool200000_oo
o`80000:oooo100000;oool200000_ooo`800003oooo0P0000Soool200003?ooo`@0000Aoooo0P00
00;oool200001?ooo`@00002oooo0P0000;oool300002_ooo`@00002oooo0P0000Goool00`000?oo
ooooo`02oooo000=oooo0P0000;oool00`000?ooo`000004oooo00<0003oooooool00_oooa<00004
oooo200000;oool800000_ooo`H00007oooo0P0001Soool700001?ooo`@00004oooo0P0000;oool2
00001_ooo`@00008oooo00<0003oooooool05?ooo`@0000Soooo0P0000Woool400000_ooo`@00004
oooo100000;oool400000_ooo`H00003oooo0P0000Coool200000_ooo`800009oooo00<0003ooooo
ool00_ooo`003_ooo`050000oooooooooooo000000Goool00`000?ooooooo`02oooo4`0000Coool4
00000_ooo`800004oooo1P0000;oool600009Oooo`<00002oooo4P0000Koool200000_ooo`800009
oooo0P00013oool400005Oooo`H00006oooo100000Koool300000_ooo`800002oooo200000Coool2
00000_ooo`@00007oooo0P0000;oool200001?ooo`80000;oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;ooolC00001?ooo`@00002oooo0P0000Coool600000_ooo`H0000Uoooo0`00
00;ooolB00001_ooo`800002oooo0P0000Woool200004?ooo`@0000Eoooo1P0000Koool400001_oo
o`<00002oooo0P0000;oool800001?ooo`800002oooo100000Ooool200000_ooo`800004oooo0P00
00_oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oooa<00004oooo4P0000Coool4
00000_ooo`80000=oooo0P0001;oool300003?ooo`80000>oooo0P0000_oool400000_ooo`@00004
oooo0P0000Coool200002oooo`800008oooo0P0000;oool200001?ooo`@0000;oooo100000;oool2
00001_ooo`800006oooo2P0000Goool200004Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo4`0000CooolB00001?ooo`@00002oooo0P0000goool200004_ooo`<0000<oooo0P00
00koool200002oooo`@00002oooo100000Coool200001?ooo`80000;oooo0P0000Soool200000_oo
o`800004oooo100000_oool400000_ooo`800006oooo0P0000Koool:00001Oooo`80000Aoooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;ooolC00001?ooo`P00002oooo0P0000;oool4
00001?ooo`@00004oooo00<0003oooooool01?ooo`800004oooo0P0001;oool300002_ooo`@0000>
oooo0P0000goool400000_ooo`H00002oooo0P0000[oool200000oooo`80000<oooo0P0000Coool2
00003Oooo`H0000:oooo100000ooool200004oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo4`0000Coool800000_ooo`800002oooo100000Coool400001?ooo`030000oooooooo
00Coool200001?ooo`80000Boooo0`0000[oool400003_ooo`80000=oooo100000;oool600000_oo
o`80000:oooo0P0000?oool200003?ooo`800004oooo0P0000goool600002_ooo`@0000?oooo0P00
01?oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oooa<00006oooo300000;oool4
00000_ooo`H00005oooo0P0000;oool200005_ooo`80000;oooo0P0001Soool200001Oooo`800004
oooo100000;oool200001?ooo`800006oooo0P0000?oool200003?ooo`@00002oooo100002Goool2
00002oooo`80000Aoooo00<0003oooooool00_ooo`006?ooo`800003oooo4`0000Koool<00000_oo
o`@00002oooo1P0000Goool200000_ooo`80000Foooo0P0000_oool200006?ooo`800005oooo0P00
00Coool400000_ooo`800004oooo0P0000Koool200000oooo`80000<oooo100000;oool400009Ooo
o`80000;oooo0P00013oool200001?ooo`006?ooo`030000oooooooo00;ooolC00001?ooo`h00008
oooo1P0000Goool600001_ooo`800004oooo0P0000Coool200001?ooo`800003oooo0P0001Coool6
00000_ooo`800002oooo0`0000Coool600002?ooo`@00006oooo0P0000?oool200004?ooo`800002
oooo1P0002koool200004Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo4`00
00Coool>00002?ooo`H00005oooo1P0000Koool200001?ooo`800004oooo0P0000Coool200000ooo
o`80000Doooo1P0000;oool200000_ooo`<00004oooo1P0000Soool400001_ooo`800003oooo0P00
013oool200000_ooo`H0000^oooo0P00017oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_oooa<00004oooo300000coool400003Oooo`800006oooo0P0000coool200000oooo`80000B
oooo1P0000;oool400000oooo`80000:oooo2P0000;oool400000_ooo`800003oooo0P0000koool2
0000<Oooo`800005oooo0P0000;oool200003Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo4`0000Coool<00003?ooo`@0000=oooo0P0000Koool200003?ooo`800003oooo0P00
01;oool600000_ooo`@00003oooo0P0000[oool:00000_ooo`@00002oooo0P0000?oool200003_oo
o`80000aoooo0P0000Goool200000_ooo`80000=oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;ooolC00001?ooo``0000Goooo0P0000coool400002_ooo`800003oooo0P00013oool4
00001_ooo`H00005oooo1P0000;oool200001?ooo`X00002oooo0P0000?oool200002_ooo`H0000a
oooo0P0000goool200002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo4`00
00Coool<00005oooo`80000<oooo100000[oool200000oooo`80000@oooo100000Koool600001Ooo
o`H00002oooo0P0000Coool:00000_ooo`800003oooo0P0000[oool60000<Oooo`80000=oooo0P00
00Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_ooo`80000hoooo100000Coool2
00001?ooo`800002oooo0P0000Coool200001oooo`@00006oooo200000;ooolA00001_ooo`800002
oooo300000Koool00`000?ooooooo`04oooo100003koool200000_ooo`800006oooo0P0000Ooool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool01_ooo`80000hoooo100000Coool200001?oo
o`800002oooo0P0000Coool200001oooo`@00006oooo200000;ooolA00001_ooo`800002oooo3000
00Koool00`000?ooooooo`04oooo100003koool200000_ooo`800006oooo0P0000Ooool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0B?ooo`800002oooo100000;oool200002Oooo`800002
oooo0P0000Coool:00001?oooaD00002oooo200000;oool600001_ooo`D00018oooo300000Goool0
0`000?ooooooo`02oooo000Hoooo0P0004Woool200000_ooo`@00002oooo0P0000Woool200000_oo
o`800004oooo2P0000CooolE00000_ooo`P00002oooo1P0000Koool50000B?ooo``00004oooo0P00
00Coool001Soool00`000?ooooooo`1@oooo0P0000;oool200001oooo`800008oooo0P0000;oool4
00000_oooaT00002oooo200000;oool600001?ooo`<0001Foooo0P0000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0D?ooo`800002oooo0P0000Ooool200002?ooo`800002oooo1000
00;ooolI00000_ooo`P00002oooo1P0000Coool30000E_ooo`800005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo05;oool200000_ooo`@00005oooo0P0000Koool200000_ooo`800002
oooo7`0000;oool400000_ooo`H00004oooo0`0004?oool500002_ooo`800009oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo05;oool200000_ooo`@00005oooo0P0000Koool200000_oo
o`800002oooo7`0000;oool400000_ooo`H00004oooo0`0004?oool500002_ooo`800009oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo05Coool200002oooo`X00002oooo8@0000;oool2
00000_ooo`P00004oooo0P0004ooool200000_ooo`800009oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo05Coool200002oooo`X00002oooo8@0000;oool200000_ooo`P00004oooo0P00
04ooool200000_ooo`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Soool2
00000oooo`800002oooo>`0000;oool20000Doooo`80000;oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo05Soool200000oooo`800002oooo>`0000;oool20000Doooo`80000;oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo05goool400001?oooc/0001Poooo00<0003ooooo
ool00_ooo`006?ooo`80001Noooo100000Cooolk0000Goooo`800004oooo000Hoooo00<0003ooooo
ool0HOooo`800002oooo>@0006;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0HOoo
o`800002oooo>@0006;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0Goooo`800002
oooo0P0000;ooolc0000I_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo0P00
00;ooole0000J?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo0P0000;ooole
0000J?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Moooo100000Cooolc0000J?oo
o`030000oooooooo00;oool000coool200001?ooo`030000oooooooo00?oool00`000?ooooooo`1M
oooo100000Cooolc0000J?ooo`030000oooooooo00;oool000coool00`000?ooo`000002oooo00<0
003oool000001?ooo`030000oooooooo06?ooolc0000J_ooo`030000oooooooo00;oool000coool0
0`000?ooo`000002oooo00<0003oool000001?ooo`<0001Soooo<`0006Soool300001?ooo`003?oo
o`800003oooo00<0003oool000001?ooo`030000oooooooo067ooola0000K_ooo`030000oooooooo
00;oool000coool00`000?ooooooo`02oooo00<0003oool000001?ooo`030000oooooooo067ooola
0000K_ooo`030000oooooooo00;oool000goool200000oooo`030000oooooooo00?oool00`000?oo
ooooo`1Uoooo:`00073oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0IOooob/0001`
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo06Goool]0000K_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Uoooo;@0006koool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0HOooo`h00006oooo7`0006coool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0HOooo`h00006oooo7`0006coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0HOoo
o`h00008oooo7`0006[oool00`000?ooooooo`02oooo000Hoooo0P0006;oool>00002?oooal0001Y
oooo0P0000Coool001Soool00`000?ooooooo`1Ooooo5P0000Coool200000_oooaT0001Zoooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo05oooolF00001?ooo`800002oooo6@0006[oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0GooooaX00006oooo2`0000;oool<0000J?oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo6P0000Koool;00000_ooo``0001X
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05[oool?00000_ooo`@00004oooo9@00
06Soool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0F_ooo`l00002oooo100000CooolU
0000J?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Koooo300000;oool600000_oo
oaL00002oooo4P0006Coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0Foooo``00002
oooo1P0000;ooolG00000_oooa80001Toooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
05_oool>00001?ooo`h00005oooo700006Coool00`000?ooooooo`02oooo000Hoooo0P0005coool>
00001?ooo`h00005oooo700006?oool200001?ooo`006?ooo`030000oooooooo05[oool;00000_oo
o`@00002oooo0P0000;oool600001?ooob40001Toooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo05[oool;00000_ooo`@00002oooo0P0000;oool600001?ooob40001Toooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo05Soool=00000_ooo`@00004oooo0P0000CooolE00000_oo
oa00001Toooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Soool=00000_ooo`@00004
oooo0P0000CooolE00000_oooa00001Toooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
05SooolA00000_ooo`80000Boooo00<0003oooooool00_oooaX0001Roooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo05Soool2000000?oool0000000002P0000Koool200002?ooo`@00002
oooo2@0000;ooolF0000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Hoooo0P00
0003oooo0000000000X00006oooo0P0000Soool400000_ooo`T00002oooo5P0006;oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0F?ooo`d00002oooo0P0000koool;00001?ooo`800002
oooo500006;oool00`000?ooooooo`02oooo000Hoooo0P0005Woool=00000_ooo`80000>oooo2`00
00Coool200000_oooa@0001Qoooo0P0000Coool001Soool00`000?ooooooo`1Foooo3@0000;oool8
00000_ooo`800002oooo5@0000;ooolD0000H_ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1Foooo3@0000;oool800000_ooo`800002oooo5@0000;ooolD0000H_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Foooo3@0000Koool400001?ooo`800002oooo4`0000;ooolD
0000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Foooo3@0000Koool400001?oo
o`800002oooo4`0000;ooolD0000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1F
oooo2@0000coool200001?ooo`800004oooo0P0000;oool500000_ooo`800006oooo1P0000;oool<
0000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Foooo2@0000coool200001?oo
o`800004oooo0P0000;oool500000_ooo`800006oooo1P0000;oool<0000H_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Hoooo2@0000koool200001?ooo`800006oooo1@0001;oool:
0000H_ooo`030000oooooooo00;oool000goool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo05Soool900003_ooo`800004oooo0P0000Koool500004_ooo`X0001Roooo00<0
003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003ooooo
ool0F?ooo`T00006oooo2P0000Coool200000_ooo`800002oooo1@0000;oool<00001?ooo`P0001T
oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo0`00
05Soool900001_ooo`X00004oooo0P0000;oool200000_ooo`D00002oooo300000Coool80000H_oo
o`<00004oooo000=oooo00L0003oooooooooool0003oool000001?ooo`030000oooooooo05Koool7
00002_ooo`800002oooo200000[oool300000_ooo`h00004oooo200006Coool00`000?ooooooo`02
oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`1Foooo1`00
00[oool200000_ooo`P0000:oooo0`0000;oool>00001?ooo`P0001Toooo00<0003oooooool00_oo
o`003Oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool0F?oooa/0000<
oooo1@0000;ooolF0000I?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Hoooo6`00
00coool500000_oooaH0001Toooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Koool9
00000_oooaH00008oooo7@0006Coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_oo
o`T00002oooo5P0000SooolM0000I?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1F
oooo3`0000;oool200000_ooo`h00004oooo7`0006Coool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0E_ooo`l00002oooo0P0000;oool>00001?oooal0001Toooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo05Koool400001Oooo`X00006oooo2P0000Coool700000_ooo`H00002
oooo3P0006Coool00`000?ooooooo`02oooo000Hoooo0P0005Ooool400001Oooo`X00006oooo2P00
00Coool700000_ooo`H00002oooo3P0006?oool200001?ooo`006?ooo`030000oooooooo05Koool2
00001oooo`800002oooo0P0000;oool400001_ooob/0001Toooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo05Koool200001oooo`800002oooo0P0000;oool400001_ooob/0001Toooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo05Koool200002OoooaH00008oooo6@0000;oool2
0000I?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Foooo0P0000WooolF00002?oo
oaT00002oooo0P0006Coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0F?ooo`800003
oooo0P0000;oool200001_ooo`800002oooo2P0000;oool200001?ooo`/00008oooo0P0000Coool4
0000I?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Hoooo0P0000?oool200000_oo
o`800006oooo0P0000;oool:00000_ooo`800004oooo2`0000Soool200001?ooo`@0001Toooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo05Soool300004_ooo`80000Coooo100000;oool2
00003_ooo`80001Voooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05ooool200004_oo
o`80000?oooo0P0000;oool200001?ooo`800004oooo0P0000;oool20000I_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Ooooo0P0001;oool200003oooo`800002oooo0P0000Coool2
00001?ooo`800002oooo0P0006Koool00`000?ooooooo`02oooo000Hoooo0P0005_oool30000;Ooo
o`@00002oooo0P0000;oool40000Ioooo`800004oooo000Hoooo00<0003oooooool0F_ooo`<0000]
oooo100000;oool200000_ooo`@0001Xoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
06_oool200004oooo`@00008oooo0P0007;oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0Joooo`80000Coooo100000Soool20000L_ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1Moooo0P0002Ooool200000_ooo`800002oooo0P0000;oool20000K?ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Moooo0P0002Ooool200000_ooo`800002oooo0P0000;oool2
0000K?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo200002Goool60000K_oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo200002Goool60000K_ooo`030000
oooooooo00;oool001Soool00`000?ooooooo`1Qoooo100000koool200002?ooo`D00002oooo0P00
00;oool200000_ooo`80001boooo00<0003oooooool00_ooo`006?ooo`80001Roooo100000koool2
00002?ooo`D00002oooo0P0000;oool200000_ooo`80001aoooo0P0000Coool001Soool00`000?oo
ooooo`1Woooo0P0000;oool200003?ooo`L00006oooo100007Koool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0Ioooo`800002oooo0P0000coool700001_ooo`@0001foooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo06Woool200002?ooo`80000:oooo00<0003oooooool0O_oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1Yoooo0P0000Soool200002_ooo`030000
oooooooo07koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo0006oooo1@0000;oool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`002?oo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo0008oooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000Coool30000o_ooo`<00004oooo0008oooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000Soool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`001oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool2
00001oooo`80003goooo0P0000Coool001Soool00`000?ooooooo`06oooo0P000?Soool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool02_ooo`800009oooo0P000>Woool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool02_ooo`800009oooo0P000>Woool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool05oooo`80003Woooo00<0003oooooool00_ooo`006?ooo`80000Hoooo0P000>Koool200001?oo
o`006?ooo`030000oooooooo00[oool20000m?ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`0:oooo0P000?Coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_ooo`80000<
oooo00<0003oooooool0jOooo`030000oooooooo00;oool001Soool00`000?ooooooo`06oooo0P00
00coool00`000?ooooooo`3Yoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool2
00000_ooo`X0003Yoooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`800002oooo2P000>Woool200001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo0P0000;oool200002_ooo`800009oooo0P0000coool20000doooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo0P0000;oool200002_ooo`800009oooo0P0000coool20000dooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo1P0000Soool400004Oooo`800002
oooo0P0000coool00`000?ooooooo`0200000_ooo`800030oooo00<0003oooooool00_ooo`006?oo
o`800003oooo1P0000Soool400004Oooo`800002oooo0P0000coool00`000?ooooooo`0200000_oo
o`80002ooooo0P0000Coool001Soool00`000?ooooooo`02oooo1P0000;oool200002?ooo`030000
oooooooo00H00006oooo0P0000;oool200003oooo`800036oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool600000_ooo`800008oooo00<0003oooooool01P0000Koool200000_oo
o`80000?oooo0P000<Koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01?ooo`@00002
oooo4@0000Coool200002?ooo`80000Uoooo0P0001Ooool400003_ooo`80000Moooo0P0000_oool2
00001_ooo`80000Doooo00<0003oooooool06?ooo`80000Noooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00Coool400000_oooa400004oooo0P0000Soool200009Oooo`80000Goooo1000
00koool200007Oooo`80000;oooo0P0000Koool200005?ooo`030000oooooooo01Soool200007_oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200000;oool600000_ooo`030000
oooooooo00H00006oooo0P00013oool200001oooo`80000Ooooo0P0003ooool200004oooo`800019
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800000_ooo`H00002oooo00<0
003oooooool01P0000Koool200004?ooo`800007oooo0P0001ooool20000?oooo`80000Coooo0P00
04Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo``00004oooo0P000003oooo
0000000000@00002oooo100000Koool200000_ooo`@00008oooo0`0001Koool200001?ooo`800005
oooo0P0000Coool200004?ooo`800002oooo0P0008Goool00`000?ooooooo`02oooo0006oooo1@00
0004oooo0000000000000oooo`030000oooooooo00?oool00`000?ooooooo`02oooo300000Coool2
000000?oool000000000100000;oool400001_ooo`800002oooo100000Soool300005_ooo`800004
oooo0P0000Goool200001?ooo`80000@oooo0P0000;oool20000QOooo`030000oooooooo00;oool0
00Soool01@000?ooooooooooo`000004oooo00<0003oool000001?ooo`030000oooooooo00;oool>
00000_ooo`/00002oooo2P0000Coool200000_ooo`800004oooo00<0003oooooool00P0000Coool2
00001_ooo`800002oooo0P0000goool200002?ooo`80000@oooo0P0000Koool00`000?ooooooo`08
oooo0P0000Coool200000_ooo`800006oooo0P0000Ooool200001?ooo`80000<oooo0P0000ooool2
0000=?ooo`030000oooooooo00;oool000Soool00`000?ooooooo`02oooo00L0003oooooooooool0
003oool000001?ooo`<00002oooo3P0000;oool;00000_ooo`X00004oooo0P0000;oool200001?oo
o`030000oooooooo00800004oooo0P0000Koool200000_ooo`80000=oooo0P0000Soool200004?oo
o`800006oooo00<0003oooooool02?ooo`800004oooo0P0000;oool200001_ooo`800007oooo0P00
00Coool200003?ooo`80000?oooo0P0003;oool300001?ooo`002?ooo`030000oooooooo00;oool0
1`000?ooooooooooo`000?ooo`000004oooo00<0003oooooool00_oooa000002oooo5@0000;oool2
00000_ooo`P000000oooo`0000000006oooo100000;oool200001_ooo`H00007oooo0P0000Koool2
00000_ooo`800008oooo0P0000Koool200000_ooo`80000;oooo0P0000;oool200001_ooo`80000;
oooo0P0000koool200009oooo`800006oooo100000Ooool200003oooo`030000oooooooo00;oool0
00Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo
00;oool[00000_ooo`T00002oooo2P0000Soool200000_ooo`@0000?oooo0P0000;oool400001?oo
o`800004oooo100000Coool200002Oooo`@00006oooo0P0000coool200001oooo`80000@oooo0P00
00_oool400006_ooo`<00002oooo0P0000;oool200003oooo`030000oooooooo00;oool000Ooool2
00001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00_ooob/00002
oooo2@0000;oool:00002?ooo`800002oooo100000ooool200000_ooo`@00004oooo0P0000Coool4
00001?ooo`800009oooo100000Koool200003?ooo`800007oooo0P00013oool200002oooo`@0000J
oooo0`0000;oool200000_ooo`80000?oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;ooolU00000_ooo`l00002oooo0P0000;oool800000_ooo`P00002oooo100000Coool500002?oo
o`800002oooo0P0000;oool200001?ooo`@00004oooo0P0000Goool200002_ooo`800004oooo0P00
00Coool200001Oooo`80000:oooo0P0000Koool200005Oooo`800004oooo0P0000koool200001ooo
o`800006oooo0P0000Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooobD00002
oooo3`0000;oool200000_ooo`P00002oooo200000;oool400001?ooo`D00008oooo0P0000;oool2
00000_ooo`800004oooo100000Coool200001Oooo`80000:oooo0P0000Coool200001?ooo`800005
oooo0P0000[oool200001_ooo`80000Eoooo0P0000Coool200003_ooo`800007oooo0P0000Koool2
00002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo0P0000;ooolM00000_oo
oaL00004oooo0P0000;oool400001?ooo`800002oooo200000;oool00`000?ooooooo`04oooo2000
00;oool400000_ooo`P00007oooo0P0000Koool200000_ooo`800002oooo0P0000Coool400000_oo
o`@00003oooo0P0000;oool200000_ooo`H00006oooo0P0000Coool200000_ooo`800002oooo0`00
00Koool200000_ooo`800006oooo100000Koool200000oooo`@00004oooo0P0000;oool400001ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo0P0000;ooolM00000_oooaL00004
oooo0P0000;oool400001?ooo`800002oooo200000;oool00`000?ooooooo`04oooo200000;oool4
00000_ooo`P00007oooo0P0000Koool200000_ooo`800002oooo0P0000Coool400000_ooo`@00003
oooo0P0000;oool200000_ooo`H00006oooo0P0000Coool200000_ooo`800002oooo0`0000Koool2
00000_ooo`800006oooo100000Koool200000oooo`@00004oooo0P0000;oool400001oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo@P0000;oool400000_ooo``00002oooo0`00
00;oool600001?ooo`P00004oooo1P0000;oool2000000?oool0000000001?ooo`P00002oooo1000
00;oool400001?ooo`800002oooo00<0003oooooool00P0000koool200000_ooo`@00008oooo00<0
003oooooool00_ooo`P00002oooo0P0000[oool200001oooo`800002oooo0P0000;oool200001?oo
o`@00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooom200000_ooo`@00002
oooo300000;oool300000_ooo`H00004oooo200000Coool600000_ooo`8000000oooo`0000000004
oooo200000;oool400000_ooo`@00004oooo0P0000;oool00`000?ooooooo`0200003_ooo`800002
oooo100000Soool00`000?ooooooo`02oooo200000;oool200002_ooo`800007oooo0P0000;oool2
00000_ooo`800004oooo100000Goool00`000?ooooooo`02oooo000Hoooo0P0000?oool@00000_oo
ob<00003oooo8`0000;oool600000_ooo`h00006oooo1`0000;oool600000_ooo`800004oooo1000
00;oool600000_ooo`8000000oooo`000000000200000_ooo`800002oooo1P0000;oool400001?oo
o`l00002oooo0P0000Coool200000_ooo`@00006oooo1P000003oooo0000000000P00002oooo1P00
00Coool200001?ooo`006?ooo`030000oooooooo00;oool@00000_ooob<00003oooo8`0000;oool6
00000_ooo`h00006oooo1`0000;oool600000_ooo`800004oooo100000;oool600000_ooo`800000
0oooo`000000000200000_ooo`800002oooo1P0000;oool400001?ooo`l00002oooo0P0000Coool2
00000_ooo`@00006oooo1P000003oooo0000000000P00002oooo1P0000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_oooe800002oooo10000003oooo0000000002000003oooo2P00
00Koool200000_ooo`@00002oooo20000003oooo0000000000Coool200001?ooo`@00004oooo0P00
00;oool;00001?ooo`800002oooo300000;oool400000_ooo`T00002oooo100000;oool800001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02ooooDP0000;oool4000000?oool00000
0000800000?oool:00001_ooo`800002oooo100000;oool8000000?oool0000000001?ooo`800004
oooo100000Coool200000_ooo`/00004oooo0P0000;oool<00000_ooo`@00002oooo2@0000;oool4
00000_ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooom<00000_oo
oa<00002oooo3P0000Coool;00000_ooo`H00002oooo1P0000;oool400000_oooaL00004oooo1000
00Coool8000000?oool0000000000_ooo`h00002oooo8@0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_oood`00002oooo4`0000;oool>00001?ooo`/00002oooo1P0000;oool6
00000_ooo`@00002oooo5`0000Coool400001?ooo`P000000oooo`0000000002oooo3P0000;ooolQ
00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool200000oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo0P0000Coool001Sooooo00001@00
00Coool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00R?oo
o`<0002Eoooo0029oooo00<0003oooooool0U?ooo`00N_ooo`<00002oooo1@000005oooo0000oooo
0000oooo00<00002oooo0`0000?oool200003oooo`<000000oooo`000000000200000_ooo`800002
oooo100006Woool007[oool00`000?ooo`000002oooo0`000008oooo0000oooo0000oooo0000oooo
00000_ooo`040000oooooooo00000oooo`030000oooooooo00koool01@000?ooooooo`000?ooo`03
00000_ooo`050000oooooooo0000oooo00<0001Zoooo001loooo00<0003oooooool00_ooo`090000
oooo0000oooo0000oooo0000oooo000000;oool010000?ooooooo`0000?oool300003_ooo`040000
oooooooo00000oooo`040000oooooooo00001_ooo`030000oooooooo06Soool007_oool00`000?oo
ooooo`02oooo0P000006oooo00000000oooo0000oooo100000?oool010000?ooooooooooo`<0000?
oooo0`0000;oool2000000?oool0000000000P0000?oool20000J_ooo`00N_ooo`030000oooo0000
01;oool00`000?ooooooo`0Eoooo00<0003oooooool01?ooo`030000oooooooo06ooool007[oool3
00004Oooo`80000Foooo0P0007Soool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}]
}, Open  ]],

Cell[TextData[{
  "weightenWaveletSegnetation[test_,m_]:=\n\t\
Module[{n,n2,m2,m3,m4,ms,me,mx,k,p,ps,pe,wMatrix,wTMatrix,\n\t\t\
partSpect,segment,out,gMax,maxAbs,minAbs,list={}},\n\t\t\t\
n=Length[test];n2=n/2;\n\t\t\tmx=m;Which[m<=0,mx=1,m>n,mx=n];m2=n/mx;\n\t\t\t\
wMatrix=waveletMatrix[n,daub2];\n\t\t\twTMatrix=Transpose[wMatrix];\n\t\t\t\
out=ZeroMatrix[n];\n\t\t\tsegment=wMatrix.test.wTMatrix;\n\t\t\t\
Do[segment[[i,j]]=0,{i,n2},{j,n2}];\n\t\t\tsegment=wTMatrix.segment.wMatrix;\n\
\t\t\tgMax=Max[Abs[segment]];\n\t\t\tminAbs=N[gMax/(mx mx)];\n\t\tDo[\n\t\t\t\
m3=k*m2;m4=p*m2;\n\t\t\t\tms=m3+1;me=ms+m2-1;\n\t\t\t\tps=m4+1;pe=ps+m2-1;\n\t\
\t\t\tpartSpect=ZeroMatrix[n];\n\t\t\t\
Do[partSpect[[i,j]]=segment[[i,j]],{i,ms,me},{j,ps,pe}];\t\n\t\t\t\
maxAbs=Max[Abs[partSpect]];\n\t\t\tIf[maxAbs>=",
  StyleBox["minAbs", "MR"],
  ",\n\t\t\t\tpartSpect=Round[partSpect/",
  StyleBox["maxAbs]", "MR"],
  ",\n\t\t\t\tpartSpect=0. partSpect];\n\t\t\tDo[out[[i,j]]=(maxAbs/gMax) \
Abs[partSpect[[i,j]]];\n\t\t\t\tIf[partSpect[[i,j]]>0,\n      \t\t\t\t\
list=Append[list,{RGBColor[1,1,0],\n      \t\t\t\t\tPoint[{j,i}]}]],\n      \t\
\t{i,ms,me},{j,ps,pe}],\n      \t\t\n      \t{p,0,mx-1},{k,0,mx-1}];\n\t\t\
{out,Map[Graphics,list]}\n\t];"
}], "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["Timing[segment1=weightenWaveletSegnetation[sampleData,1];]", "Input"],

Cell[BoxData[
    \({10.7099999999999795`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Show[segment1[[2]],
\tPlotLabel -> \"1 Segmented outline\",
\tFrame->True,AspectRatio->1,Background->GrayLevel[0]];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
0 g
MFill
% Scaling calculations
0.0238095 0.00744048 0.0238095 0.00744048 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.17262 -0.0125 -6 -9 ]
[.17262 -0.0125 6 0 ]
[.32143 -0.0125 -6 -9 ]
[.32143 -0.0125 6 0 ]
[.47024 -0.0125 -6 -9 ]
[.47024 -0.0125 6 0 ]
[.61905 -0.0125 -6 -9 ]
[.61905 -0.0125 6 0 ]
[.76786 -0.0125 -9 -9 ]
[.76786 -0.0125 9 0 ]
[.91667 -0.0125 -9 -9 ]
[.91667 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .17262 -12 -4.5 ]
[-0.0125 .17262 0 4.5 ]
[-0.0125 .32143 -12 -4.5 ]
[-0.0125 .32143 0 4.5 ]
[-0.0125 .47024 -12 -4.5 ]
[-0.0125 .47024 0 4.5 ]
[-0.0125 .61905 -12 -4.5 ]
[-0.0125 .61905 0 4.5 ]
[-0.0125 .76786 -18 -4.5 ]
[-0.0125 .76786 0 4.5 ]
[-0.0125 .91667 -18 -4.5 ]
[-0.0125 .91667 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59 0 ]
[.5 1.0125 59 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 g
.25 Mabswid
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.17262 0 m
.17262 .00625 L
s
[(20)] .17262 -0.0125 0 1 Mshowa
.32143 0 m
.32143 .00625 L
s
[(40)] .32143 -0.0125 0 1 Mshowa
.47024 0 m
.47024 .00625 L
s
[(60)] .47024 -0.0125 0 1 Mshowa
.61905 0 m
.61905 .00625 L
s
[(80)] .61905 -0.0125 0 1 Mshowa
.76786 0 m
.76786 .00625 L
s
[(100)] .76786 -0.0125 0 1 Mshowa
.91667 0 m
.91667 .00625 L
s
[(120)] .91667 -0.0125 0 1 Mshowa
.125 Mabswid
.06101 0 m
.06101 .00375 L
s
.09821 0 m
.09821 .00375 L
s
.13542 0 m
.13542 .00375 L
s
.20982 0 m
.20982 .00375 L
s
.24702 0 m
.24702 .00375 L
s
.28423 0 m
.28423 .00375 L
s
.35863 0 m
.35863 .00375 L
s
.39583 0 m
.39583 .00375 L
s
.43304 0 m
.43304 .00375 L
s
.50744 0 m
.50744 .00375 L
s
.54464 0 m
.54464 .00375 L
s
.58185 0 m
.58185 .00375 L
s
.65625 0 m
.65625 .00375 L
s
.69345 0 m
.69345 .00375 L
s
.73065 0 m
.73065 .00375 L
s
.80506 0 m
.80506 .00375 L
s
.84226 0 m
.84226 .00375 L
s
.87946 0 m
.87946 .00375 L
s
.95387 0 m
.95387 .00375 L
s
.99107 0 m
.99107 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .17262 m
.00625 .17262 L
s
[(20)] -0.0125 .17262 1 0 Mshowa
0 .32143 m
.00625 .32143 L
s
[(40)] -0.0125 .32143 1 0 Mshowa
0 .47024 m
.00625 .47024 L
s
[(60)] -0.0125 .47024 1 0 Mshowa
0 .61905 m
.00625 .61905 L
s
[(80)] -0.0125 .61905 1 0 Mshowa
0 .76786 m
.00625 .76786 L
s
[(100)] -0.0125 .76786 1 0 Mshowa
0 .91667 m
.00625 .91667 L
s
[(120)] -0.0125 .91667 1 0 Mshowa
.125 Mabswid
0 .06101 m
.00375 .06101 L
s
0 .09821 m
.00375 .09821 L
s
0 .13542 m
.00375 .13542 L
s
0 .20982 m
.00375 .20982 L
s
0 .24702 m
.00375 .24702 L
s
0 .28423 m
.00375 .28423 L
s
0 .35863 m
.00375 .35863 L
s
0 .39583 m
.00375 .39583 L
s
0 .43304 m
.00375 .43304 L
s
0 .50744 m
.00375 .50744 L
s
0 .54464 m
.00375 .54464 L
s
0 .58185 m
.00375 .58185 L
s
0 .65625 m
.00375 .65625 L
s
0 .69345 m
.00375 .69345 L
s
0 .73065 m
.00375 .73065 L
s
0 .80506 m
.00375 .80506 L
s
0 .84226 m
.00375 .84226 L
s
0 .87946 m
.00375 .87946 L
s
0 .95387 m
.00375 .95387 L
s
0 .99107 m
.00375 .99107 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.17262 .99375 m
.17262 1 L
s
.32143 .99375 m
.32143 1 L
s
.47024 .99375 m
.47024 1 L
s
.61905 .99375 m
.61905 1 L
s
.76786 .99375 m
.76786 1 L
s
.91667 .99375 m
.91667 1 L
s
.125 Mabswid
.06101 .99625 m
.06101 1 L
s
.09821 .99625 m
.09821 1 L
s
.13542 .99625 m
.13542 1 L
s
.20982 .99625 m
.20982 1 L
s
.24702 .99625 m
.24702 1 L
s
.28423 .99625 m
.28423 1 L
s
.35863 .99625 m
.35863 1 L
s
.39583 .99625 m
.39583 1 L
s
.43304 .99625 m
.43304 1 L
s
.50744 .99625 m
.50744 1 L
s
.54464 .99625 m
.54464 1 L
s
.58185 .99625 m
.58185 1 L
s
.65625 .99625 m
.65625 1 L
s
.69345 .99625 m
.69345 1 L
s
.73065 .99625 m
.73065 1 L
s
.80506 .99625 m
.80506 1 L
s
.84226 .99625 m
.84226 1 L
s
.87946 .99625 m
.87946 1 L
s
.95387 .99625 m
.95387 1 L
s
.99107 .99625 m
.99107 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .17262 m
1 .17262 L
s
.99375 .32143 m
1 .32143 L
s
.99375 .47024 m
1 .47024 L
s
.99375 .61905 m
1 .61905 L
s
.99375 .76786 m
1 .76786 L
s
.99375 .91667 m
1 .91667 L
s
.125 Mabswid
.99625 .06101 m
1 .06101 L
s
.99625 .09821 m
1 .09821 L
s
.99625 .13542 m
1 .13542 L
s
.99625 .20982 m
1 .20982 L
s
.99625 .24702 m
1 .24702 L
s
.99625 .28423 m
1 .28423 L
s
.99625 .35863 m
1 .35863 L
s
.99625 .39583 m
1 .39583 L
s
.99625 .43304 m
1 .43304 L
s
.99625 .50744 m
1 .50744 L
s
.99625 .54464 m
1 .54464 L
s
.99625 .58185 m
1 .58185 L
s
.99625 .65625 m
1 .65625 L
s
.99625 .69345 m
1 .69345 L
s
.99625 .73065 m
1 .73065 L
s
.99625 .80506 m
1 .80506 L
s
.99625 .84226 m
1 .84226 L
s
.99625 .87946 m
1 .87946 L
s
.99625 .95387 m
1 .95387 L
s
.99625 .99107 m
1 .99107 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
(1) show
75.000000 13.000000 moveto
(Segmented) show
135.000000 13.000000 moveto
(outline) show
177.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 0 r
.008 w
.09821 .03125 Mdot
.10565 .03125 Mdot
.1131 .03125 Mdot
.12054 .03125 Mdot
.26935 .03125 Mdot
.56696 .03125 Mdot
.68601 .03125 Mdot
.93899 .03125 Mdot
.94643 .03125 Mdot
.96131 .03125 Mdot
.96875 .03125 Mdot
.97619 .03125 Mdot
.27679 .03869 Mdot
.30655 .03869 Mdot
.31399 .03869 Mdot
.32143 .03869 Mdot
.32887 .03869 Mdot
.35119 .03869 Mdot
.35863 .03869 Mdot
.38839 .03869 Mdot
.39583 .03869 Mdot
.40327 .03869 Mdot
.41071 .03869 Mdot
.44048 .03869 Mdot
.45536 .03869 Mdot
.4628 .03869 Mdot
.47024 .03869 Mdot
.5 .03869 Mdot
.52232 .03869 Mdot
.52976 .03869 Mdot
.5372 .03869 Mdot
.60417 .03869 Mdot
.61161 .03869 Mdot
.61905 .03869 Mdot
.65625 .03869 Mdot
.67857 .03869 Mdot
.70833 .03869 Mdot
.71577 .03869 Mdot
.7381 .03869 Mdot
.2247 .04613 Mdot
.29911 .04613 Mdot
.30655 .04613 Mdot
.31399 .04613 Mdot
.32143 .04613 Mdot
.34375 .04613 Mdot
.35119 .04613 Mdot
.43304 .04613 Mdot
.44792 .04613 Mdot
.47768 .04613 Mdot
.48512 .04613 Mdot
.5744 .04613 Mdot
.62649 .04613 Mdot
.63393 .04613 Mdot
.64881 .04613 Mdot
.65625 .04613 Mdot
.66369 .04613 Mdot
.67857 .04613 Mdot
.68601 .04613 Mdot
.72321 .04613 Mdot
.73065 .04613 Mdot
.23958 .05357 Mdot
.40327 .05357 Mdot
.41071 .05357 Mdot
.41815 .05357 Mdot
.45536 .05357 Mdot
.5 .05357 Mdot
.52232 .05357 Mdot
.56696 .05357 Mdot
.58185 .05357 Mdot
.58929 .05357 Mdot
.60417 .05357 Mdot
.67113 .05357 Mdot
.71577 .05357 Mdot
.81994 .05357 Mdot
.83482 .05357 Mdot
.8497 .05357 Mdot
.85714 .05357 Mdot
.86458 .05357 Mdot
.87946 .05357 Mdot
.8869 .05357 Mdot
.89435 .05357 Mdot
.90179 .05357 Mdot
.90923 .05357 Mdot
.09821 .06101 Mdot
.10565 .06101 Mdot
.1131 .06101 Mdot
.13542 .06101 Mdot
.14286 .06101 Mdot
.28423 .06101 Mdot
.34375 .06101 Mdot
.39583 .06101 Mdot
.40327 .06101 Mdot
.41071 .06101 Mdot
.5 .06101 Mdot
.52232 .06101 Mdot
.56696 .06101 Mdot
.5744 .06101 Mdot
.58929 .06101 Mdot
.61905 .06101 Mdot
.64137 .06101 Mdot
.81994 .06101 Mdot
.89435 .06101 Mdot
.90179 .06101 Mdot
.93155 .06101 Mdot
.95387 .06101 Mdot
.03125 .06845 Mdot
.03869 .06845 Mdot
.24702 .06845 Mdot
.25446 .06845 Mdot
.2619 .06845 Mdot
.26935 .06845 Mdot
.27679 .06845 Mdot
.28423 .06845 Mdot
.35119 .06845 Mdot
.52976 .06845 Mdot
.58929 .06845 Mdot
.59673 .06845 Mdot
.61905 .06845 Mdot
.7381 .06845 Mdot
.81994 .06845 Mdot
.93155 .06845 Mdot
.95387 .06845 Mdot
.27679 .07589 Mdot
.7381 .07589 Mdot
.90179 .07589 Mdot
.93899 .07589 Mdot
.03125 .08333 Mdot
.03869 .08333 Mdot
.04613 .08333 Mdot
.05357 .08333 Mdot
.06101 .08333 Mdot
.06845 .08333 Mdot
.07589 .08333 Mdot
.08333 .08333 Mdot
.09077 .08333 Mdot
.20238 .08333 Mdot
.21726 .08333 Mdot
.23958 .08333 Mdot
.24702 .08333 Mdot
.27679 .08333 Mdot
.29911 .08333 Mdot
.32143 .08333 Mdot
.32887 .08333 Mdot
.33631 .08333 Mdot
.34375 .08333 Mdot
.35119 .08333 Mdot
.35863 .08333 Mdot
.37351 .08333 Mdot
.64137 .08333 Mdot
.64881 .08333 Mdot
.66369 .08333 Mdot
.67113 .08333 Mdot
.68601 .08333 Mdot
.70089 .08333 Mdot
.70833 .08333 Mdot
.71577 .08333 Mdot
.72321 .08333 Mdot
.7381 .08333 Mdot
.76042 .08333 Mdot
.86458 .08333 Mdot
.87946 .08333 Mdot
.90179 .08333 Mdot
.93155 .08333 Mdot
.93899 .08333 Mdot
.37351 .09077 Mdot
.4628 .09077 Mdot
.7381 .09077 Mdot
.19494 .09821 Mdot
.20238 .09821 Mdot
.20982 .09821 Mdot
.21726 .09821 Mdot
.37351 .09821 Mdot
.4628 .09821 Mdot
.7381 .09821 Mdot
.10565 .10565 Mdot
.1131 .10565 Mdot
.16518 .10565 Mdot
.17262 .10565 Mdot
.18006 .10565 Mdot
.2247 .10565 Mdot
.37351 .10565 Mdot
.43304 .10565 Mdot
.47768 .10565 Mdot
.62649 .10565 Mdot
.64137 .10565 Mdot
.66369 .10565 Mdot
.73065 .10565 Mdot
.74554 .10565 Mdot
.75298 .10565 Mdot
.8497 .10565 Mdot
.85714 .10565 Mdot
.87946 .10565 Mdot
.90179 .10565 Mdot
.95387 .10565 Mdot
.97619 .10565 Mdot
.14286 .1131 Mdot
.1875 .1131 Mdot
.2247 .1131 Mdot
.37351 .1131 Mdot
.44048 .1131 Mdot
.48512 .1131 Mdot
.62649 .1131 Mdot
.64137 .1131 Mdot
.66369 .1131 Mdot
.73065 .1131 Mdot
.80506 .1131 Mdot
.8125 .1131 Mdot
.81994 .1131 Mdot
.90179 .1131 Mdot
.95387 .1131 Mdot
.97619 .1131 Mdot
.09077 .12054 Mdot
.16518 .12054 Mdot
.23214 .12054 Mdot
.23958 .12054 Mdot
.37351 .12054 Mdot
.45536 .12054 Mdot
.47768 .12054 Mdot
.54464 .12054 Mdot
.61161 .12054 Mdot
.66369 .12054 Mdot
.76042 .12054 Mdot
.76786 .12054 Mdot
.85714 .12054 Mdot
.87946 .12054 Mdot
.8869 .12054 Mdot
.95387 .12054 Mdot
.12054 .12798 Mdot
.12798 .12798 Mdot
.17262 .12798 Mdot
.20982 .12798 Mdot
.21726 .12798 Mdot
.2247 .12798 Mdot
.24702 .12798 Mdot
.37351 .12798 Mdot
.45536 .12798 Mdot
.47768 .12798 Mdot
.5372 .12798 Mdot
.61905 .12798 Mdot
.66369 .12798 Mdot
.70089 .12798 Mdot
.70833 .12798 Mdot
.71577 .12798 Mdot
.74554 .12798 Mdot
.8497 .12798 Mdot
.86458 .12798 Mdot
.87202 .12798 Mdot
.90179 .12798 Mdot
.95387 .12798 Mdot
.10565 .13542 Mdot
.1131 .13542 Mdot
.1875 .13542 Mdot
.29167 .13542 Mdot
.37351 .13542 Mdot
.5 .13542 Mdot
.61161 .13542 Mdot
.61905 .13542 Mdot
.66369 .13542 Mdot
.71577 .13542 Mdot
.74554 .13542 Mdot
.79018 .13542 Mdot
.83482 .13542 Mdot
.84226 .13542 Mdot
.90923 .13542 Mdot
.91667 .13542 Mdot
.06101 .14286 Mdot
.18006 .14286 Mdot
.29167 .14286 Mdot
.37351 .14286 Mdot
.5372 .14286 Mdot
.68601 .14286 Mdot
.69345 .14286 Mdot
.71577 .14286 Mdot
.74554 .14286 Mdot
.76786 .14286 Mdot
.79018 .14286 Mdot
.89435 .14286 Mdot
.06101 .1503 Mdot
.07589 .1503 Mdot
.12054 .1503 Mdot
.16518 .1503 Mdot
.20238 .1503 Mdot
.21726 .1503 Mdot
.37351 .1503 Mdot
.70089 .1503 Mdot
.93899 .1503 Mdot
.94643 .1503 Mdot
.96131 .1503 Mdot
.07589 .15774 Mdot
.12054 .15774 Mdot
.13542 .15774 Mdot
.20238 .15774 Mdot
.49256 .15774 Mdot
.70089 .15774 Mdot
.76786 .15774 Mdot
.83482 .15774 Mdot
.91667 .15774 Mdot
.12054 .16518 Mdot
.13542 .16518 Mdot
.1503 .16518 Mdot
.1875 .16518 Mdot
.37351 .16518 Mdot
.5 .16518 Mdot
.51488 .16518 Mdot
.63393 .16518 Mdot
.67113 .16518 Mdot
.72321 .16518 Mdot
.96131 .16518 Mdot
.96875 .16518 Mdot
.05357 .17262 Mdot
.14286 .17262 Mdot
.1875 .17262 Mdot
.20982 .17262 Mdot
.21726 .17262 Mdot
.37351 .17262 Mdot
.49256 .17262 Mdot
.51488 .17262 Mdot
.5372 .17262 Mdot
.54464 .17262 Mdot
.63393 .17262 Mdot
.64137 .17262 Mdot
.64881 .17262 Mdot
.67113 .17262 Mdot
.72321 .17262 Mdot
.76786 .17262 Mdot
.93155 .17262 Mdot
.93899 .17262 Mdot
.05357 .18006 Mdot
.06845 .18006 Mdot
.12798 .18006 Mdot
.13542 .18006 Mdot
.20982 .18006 Mdot
.35863 .18006 Mdot
.38095 .18006 Mdot
.55952 .18006 Mdot
.64137 .18006 Mdot
.72321 .18006 Mdot
.74554 .18006 Mdot
.79018 .18006 Mdot
.80506 .18006 Mdot
.8125 .18006 Mdot
.97619 .18006 Mdot
.05357 .1875 Mdot
.06101 .1875 Mdot
.09077 .1875 Mdot
.12054 .1875 Mdot
.1503 .1875 Mdot
.15774 .1875 Mdot
.21726 .1875 Mdot
.35863 .1875 Mdot
.38095 .1875 Mdot
.50744 .1875 Mdot
.51488 .1875 Mdot
.55208 .1875 Mdot
.72321 .1875 Mdot
.74554 .1875 Mdot
.79762 .1875 Mdot
.92411 .1875 Mdot
.1131 .19494 Mdot
.38095 .19494 Mdot
.40327 .19494 Mdot
.52976 .19494 Mdot
.61905 .19494 Mdot
.72321 .19494 Mdot
.76042 .19494 Mdot
.7753 .19494 Mdot
.90923 .19494 Mdot
.09077 .20238 Mdot
.10565 .20238 Mdot
.12798 .20238 Mdot
.20982 .20238 Mdot
.21726 .20238 Mdot
.38095 .20238 Mdot
.40327 .20238 Mdot
.61161 .20238 Mdot
.68601 .20238 Mdot
.69345 .20238 Mdot
.72321 .20238 Mdot
.7753 .20238 Mdot
.90923 .20238 Mdot
.97619 .20238 Mdot
.06101 .20982 Mdot
.06845 .20982 Mdot
.1503 .20982 Mdot
.1875 .20982 Mdot
.20982 .20982 Mdot
.21726 .20982 Mdot
.25446 .20982 Mdot
.34375 .20982 Mdot
.35863 .20982 Mdot
.38095 .20982 Mdot
.4256 .20982 Mdot
.44048 .20982 Mdot
.5744 .20982 Mdot
.61161 .20982 Mdot
.7753 .20982 Mdot
.8125 .20982 Mdot
.8497 .20982 Mdot
.85714 .20982 Mdot
.87946 .20982 Mdot
.95387 .20982 Mdot
.18006 .21726 Mdot
.25446 .21726 Mdot
.34375 .21726 Mdot
.35863 .21726 Mdot
.38095 .21726 Mdot
.41815 .21726 Mdot
.43304 .21726 Mdot
.52232 .21726 Mdot
.52976 .21726 Mdot
.5744 .21726 Mdot
.61161 .21726 Mdot
.62649 .21726 Mdot
.63393 .21726 Mdot
.76042 .21726 Mdot
.76786 .21726 Mdot
.7753 .21726 Mdot
.8125 .21726 Mdot
.86458 .21726 Mdot
.8869 .21726 Mdot
.06845 .2247 Mdot
.15774 .2247 Mdot
.1875 .2247 Mdot
.32887 .2247 Mdot
.38095 .2247 Mdot
.43304 .2247 Mdot
.44048 .2247 Mdot
.4628 .2247 Mdot
.74554 .2247 Mdot
.7753 .2247 Mdot
.8125 .2247 Mdot
.86458 .2247 Mdot
.87202 .2247 Mdot
.89435 .2247 Mdot
.96875 .2247 Mdot
.97619 .2247 Mdot
.05357 .23214 Mdot
.06845 .23214 Mdot
.07589 .23214 Mdot
.15774 .23214 Mdot
.1875 .23214 Mdot
.19494 .23214 Mdot
.20238 .23214 Mdot
.32887 .23214 Mdot
.34375 .23214 Mdot
.38095 .23214 Mdot
.40327 .23214 Mdot
.47024 .23214 Mdot
.75298 .23214 Mdot
.7753 .23214 Mdot
.89435 .23214 Mdot
.03869 .23958 Mdot
.12054 .23958 Mdot
.12798 .23958 Mdot
.18006 .23958 Mdot
.21726 .23958 Mdot
.38095 .23958 Mdot
.44792 .23958 Mdot
.61161 .23958 Mdot
.75298 .23958 Mdot
.89435 .23958 Mdot
.94643 .23958 Mdot
.96875 .23958 Mdot
.03125 .24702 Mdot
.15774 .24702 Mdot
.1875 .24702 Mdot
.21726 .24702 Mdot
.40327 .24702 Mdot
.41071 .24702 Mdot
.45536 .24702 Mdot
.61905 .24702 Mdot
.75298 .24702 Mdot
.7753 .24702 Mdot
.80506 .24702 Mdot
.8125 .24702 Mdot
.96875 .24702 Mdot
.1131 .25446 Mdot
.18006 .25446 Mdot
.20238 .25446 Mdot
.21726 .25446 Mdot
.35863 .25446 Mdot
.41071 .25446 Mdot
.44792 .25446 Mdot
.45536 .25446 Mdot
.49256 .25446 Mdot
.55952 .25446 Mdot
.56696 .25446 Mdot
.58929 .25446 Mdot
.61905 .25446 Mdot
.73065 .25446 Mdot
.78274 .25446 Mdot
.79762 .25446 Mdot
.8497 .25446 Mdot
.87202 .25446 Mdot
.10565 .2619 Mdot
.13542 .2619 Mdot
.15774 .2619 Mdot
.18006 .2619 Mdot
.19494 .2619 Mdot
.21726 .2619 Mdot
.36607 .2619 Mdot
.37351 .2619 Mdot
.41071 .2619 Mdot
.49256 .2619 Mdot
.56696 .2619 Mdot
.58929 .2619 Mdot
.61905 .2619 Mdot
.73065 .2619 Mdot
.78274 .2619 Mdot
.79762 .2619 Mdot
.8497 .2619 Mdot
.14286 .26935 Mdot
.1503 .26935 Mdot
.37351 .26935 Mdot
.41815 .26935 Mdot
.44048 .26935 Mdot
.55952 .26935 Mdot
.5744 .26935 Mdot
.7381 .26935 Mdot
.79762 .26935 Mdot
.84226 .26935 Mdot
.8497 .26935 Mdot
.87946 .26935 Mdot
.8869 .26935 Mdot
.1875 .27679 Mdot
.35863 .27679 Mdot
.37351 .27679 Mdot
.41815 .27679 Mdot
.44048 .27679 Mdot
.50744 .27679 Mdot
.51488 .27679 Mdot
.55208 .27679 Mdot
.7381 .27679 Mdot
.81994 .27679 Mdot
.84226 .27679 Mdot
.85714 .27679 Mdot
.87202 .27679 Mdot
.93155 .27679 Mdot
.95387 .27679 Mdot
.1503 .28423 Mdot
.26935 .28423 Mdot
.35863 .28423 Mdot
.40327 .28423 Mdot
.41071 .28423 Mdot
.52976 .28423 Mdot
.58185 .28423 Mdot
.66369 .28423 Mdot
.70833 .28423 Mdot
.71577 .28423 Mdot
.76042 .28423 Mdot
.81994 .28423 Mdot
.8497 .28423 Mdot
.95387 .28423 Mdot
.96131 .28423 Mdot
.96875 .28423 Mdot
.97619 .28423 Mdot
.10565 .29167 Mdot
.1503 .29167 Mdot
.26935 .29167 Mdot
.35863 .29167 Mdot
.41815 .29167 Mdot
.66369 .29167 Mdot
.70833 .29167 Mdot
.71577 .29167 Mdot
.79018 .29167 Mdot
.86458 .29167 Mdot
.87946 .29167 Mdot
.90923 .29167 Mdot
.91667 .29167 Mdot
.93155 .29167 Mdot
.08333 .29911 Mdot
.09077 .29911 Mdot
.09821 .29911 Mdot
.10565 .29911 Mdot
.1503 .29911 Mdot
.35863 .29911 Mdot
.41815 .29911 Mdot
.4256 .29911 Mdot
.43304 .29911 Mdot
.44792 .29911 Mdot
.52232 .29911 Mdot
.52976 .29911 Mdot
.58185 .29911 Mdot
.71577 .29911 Mdot
.76042 .29911 Mdot
.92411 .29911 Mdot
.93155 .29911 Mdot
.10565 .30655 Mdot
.14286 .30655 Mdot
.1503 .30655 Mdot
.17262 .30655 Mdot
.35863 .30655 Mdot
.41071 .30655 Mdot
.44048 .30655 Mdot
.45536 .30655 Mdot
.58185 .30655 Mdot
.71577 .30655 Mdot
.76786 .30655 Mdot
.81994 .30655 Mdot
.8497 .30655 Mdot
.87946 .30655 Mdot
.13542 .31399 Mdot
.1503 .31399 Mdot
.35119 .31399 Mdot
.38839 .31399 Mdot
.60417 .31399 Mdot
.68601 .31399 Mdot
.74554 .31399 Mdot
.81994 .31399 Mdot
.8869 .31399 Mdot
.97619 .31399 Mdot
.03125 .32143 Mdot
.03869 .32143 Mdot
.04613 .32143 Mdot
.05357 .32143 Mdot
.06101 .32143 Mdot
.07589 .32143 Mdot
.08333 .32143 Mdot
.09077 .32143 Mdot
.09821 .32143 Mdot
.13542 .32143 Mdot
.1503 .32143 Mdot
.35119 .32143 Mdot
.38839 .32143 Mdot
.68601 .32143 Mdot
.79018 .32143 Mdot
.79762 .32143 Mdot
.81994 .32143 Mdot
.83482 .32143 Mdot
.87946 .32143 Mdot
.96875 .32143 Mdot
.1875 .32887 Mdot
.21726 .32887 Mdot
.40327 .32887 Mdot
.41071 .32887 Mdot
.4256 .32887 Mdot
.44048 .32887 Mdot
.70089 .32887 Mdot
.70833 .32887 Mdot
.75298 .32887 Mdot
.7753 .32887 Mdot
.78274 .32887 Mdot
.80506 .32887 Mdot
.82738 .32887 Mdot
.83482 .32887 Mdot
.85714 .32887 Mdot
.87946 .32887 Mdot
.93155 .32887 Mdot
.95387 .32887 Mdot
.13542 .33631 Mdot
.1875 .33631 Mdot
.21726 .33631 Mdot
.34375 .33631 Mdot
.35119 .33631 Mdot
.4628 .33631 Mdot
.75298 .33631 Mdot
.79018 .33631 Mdot
.80506 .33631 Mdot
.84226 .33631 Mdot
.8497 .33631 Mdot
.86458 .33631 Mdot
.8869 .33631 Mdot
.89435 .33631 Mdot
.90179 .33631 Mdot
.92411 .33631 Mdot
.96131 .33631 Mdot
.1875 .34375 Mdot
.19494 .34375 Mdot
.21726 .34375 Mdot
.23214 .34375 Mdot
.29167 .34375 Mdot
.4256 .34375 Mdot
.48512 .34375 Mdot
.54464 .34375 Mdot
.56696 .34375 Mdot
.5744 .34375 Mdot
.58929 .34375 Mdot
.66369 .34375 Mdot
.70089 .34375 Mdot
.80506 .34375 Mdot
.8497 .34375 Mdot
.85714 .34375 Mdot
.92411 .34375 Mdot
.1503 .35119 Mdot
.16518 .35119 Mdot
.1875 .35119 Mdot
.19494 .35119 Mdot
.21726 .35119 Mdot
.2247 .35119 Mdot
.29167 .35119 Mdot
.4256 .35119 Mdot
.48512 .35119 Mdot
.55208 .35119 Mdot
.58185 .35119 Mdot
.66369 .35119 Mdot
.70089 .35119 Mdot
.7381 .35119 Mdot
.8125 .35119 Mdot
.87946 .35119 Mdot
.8869 .35119 Mdot
.89435 .35119 Mdot
.90179 .35119 Mdot
.93155 .35119 Mdot
.12054 .35863 Mdot
.17262 .35863 Mdot
.19494 .35863 Mdot
.23958 .35863 Mdot
.25446 .35863 Mdot
.4628 .35863 Mdot
.47024 .35863 Mdot
.49256 .35863 Mdot
.50744 .35863 Mdot
.51488 .35863 Mdot
.5372 .35863 Mdot
.54464 .35863 Mdot
.60417 .35863 Mdot
.63393 .35863 Mdot
.64137 .35863 Mdot
.71577 .35863 Mdot
.7381 .35863 Mdot
.92411 .35863 Mdot
.17262 .36607 Mdot
.18006 .36607 Mdot
.1875 .36607 Mdot
.19494 .36607 Mdot
.23958 .36607 Mdot
.5 .36607 Mdot
.55952 .36607 Mdot
.60417 .36607 Mdot
.63393 .36607 Mdot
.64137 .36607 Mdot
.70089 .36607 Mdot
.70833 .36607 Mdot
.72321 .36607 Mdot
.92411 .36607 Mdot
.29911 .37351 Mdot
.36607 .37351 Mdot
.37351 .37351 Mdot
.44792 .37351 Mdot
.47768 .37351 Mdot
.5 .37351 Mdot
.5372 .37351 Mdot
.54464 .37351 Mdot
.55208 .37351 Mdot
.59673 .37351 Mdot
.61905 .37351 Mdot
.63393 .37351 Mdot
.64137 .37351 Mdot
.70089 .37351 Mdot
.89435 .37351 Mdot
.20982 .38095 Mdot
.21726 .38095 Mdot
.29911 .38095 Mdot
.36607 .38095 Mdot
.37351 .38095 Mdot
.4628 .38095 Mdot
.47024 .38095 Mdot
.47768 .38095 Mdot
.55208 .38095 Mdot
.56696 .38095 Mdot
.5744 .38095 Mdot
.61905 .38095 Mdot
.63393 .38095 Mdot
.64137 .38095 Mdot
.89435 .38095 Mdot
.30655 .38839 Mdot
.31399 .38839 Mdot
.32887 .38839 Mdot
.38839 .38839 Mdot
.41815 .38839 Mdot
.4256 .38839 Mdot
.4628 .38839 Mdot
.5372 .38839 Mdot
.54464 .38839 Mdot
.55208 .38839 Mdot
.56696 .38839 Mdot
.61905 .38839 Mdot
.64881 .38839 Mdot
.94643 .38839 Mdot
.95387 .38839 Mdot
.96131 .38839 Mdot
.97619 .38839 Mdot
.26935 .39583 Mdot
.27679 .39583 Mdot
.30655 .39583 Mdot
.32887 .39583 Mdot
.38839 .39583 Mdot
.45536 .39583 Mdot
.4628 .39583 Mdot
.55208 .39583 Mdot
.58929 .39583 Mdot
.61905 .39583 Mdot
.67113 .39583 Mdot
.67857 .39583 Mdot
.33631 .40327 Mdot
.35119 .40327 Mdot
.4256 .40327 Mdot
.44792 .40327 Mdot
.55208 .40327 Mdot
.58929 .40327 Mdot
.61905 .40327 Mdot
.62649 .40327 Mdot
.64881 .40327 Mdot
.90923 .40327 Mdot
.91667 .40327 Mdot
.32887 .41071 Mdot
.34375 .41071 Mdot
.4256 .41071 Mdot
.44048 .41071 Mdot
.56696 .41071 Mdot
.58929 .41071 Mdot
.61905 .41071 Mdot
.62649 .41071 Mdot
.64881 .41071 Mdot
.38839 .41815 Mdot
.43304 .41815 Mdot
.56696 .41815 Mdot
.58185 .41815 Mdot
.61905 .41815 Mdot
.62649 .41815 Mdot
.95387 .41815 Mdot
.38839 .4256 Mdot
.61905 .4256 Mdot
.63393 .4256 Mdot
.96131 .4256 Mdot
.39583 .43304 Mdot
.40327 .43304 Mdot
.38839 .44048 Mdot
.40327 .44048 Mdot
.39583 .44792 Mdot
.41071 .44792 Mdot
.39583 .45536 Mdot
.60417 .45536 Mdot
.40327 .4628 Mdot
.40327 .48512 Mdot
.5744 .48512 Mdot
.40327 .49256 Mdot
.44792 .5 Mdot
.45536 .5 Mdot
.4628 .5 Mdot
.38839 .50744 Mdot
.44792 .50744 Mdot
.45536 .50744 Mdot
.47768 .51488 Mdot
.49256 .51488 Mdot
.37351 .52232 Mdot
.38095 .52232 Mdot
.48512 .52232 Mdot
.49256 .52232 Mdot
.5 .52232 Mdot
.55208 .52232 Mdot
.60417 .52232 Mdot
.4256 .52976 Mdot
.44792 .52976 Mdot
.45536 .52976 Mdot
.60417 .52976 Mdot
.41815 .5372 Mdot
.44792 .5372 Mdot
.54464 .5372 Mdot
.61905 .5372 Mdot
.4256 .54464 Mdot
.43304 .54464 Mdot
.49256 .54464 Mdot
.5 .54464 Mdot
.50744 .54464 Mdot
.61905 .54464 Mdot
.35863 .55208 Mdot
.41071 .55208 Mdot
.44792 .55208 Mdot
.47768 .55208 Mdot
.48512 .55208 Mdot
.61905 .55208 Mdot
.41071 .55952 Mdot
.45536 .55952 Mdot
.4628 .55952 Mdot
.55208 .55952 Mdot
.61905 .55952 Mdot
.44048 .56696 Mdot
.47768 .56696 Mdot
.48512 .56696 Mdot
.51488 .56696 Mdot
.52232 .56696 Mdot
.36607 .5744 Mdot
.43304 .5744 Mdot
.5372 .5744 Mdot
.41071 .58185 Mdot
.4256 .58185 Mdot
.4628 .58185 Mdot
.47024 .58185 Mdot
.52232 .58185 Mdot
.52976 .58185 Mdot
.54464 .58185 Mdot
.40327 .58929 Mdot
.54464 .58929 Mdot
.34375 .59673 Mdot
.44048 .59673 Mdot
.44792 .59673 Mdot
.34375 .60417 Mdot
.38839 .60417 Mdot
.39583 .60417 Mdot
.44048 .60417 Mdot
.44792 .60417 Mdot
.48512 .60417 Mdot
.51488 .60417 Mdot
.52976 .60417 Mdot
.5744 .60417 Mdot
.39583 .61161 Mdot
.41815 .61161 Mdot
.4256 .61161 Mdot
.43304 .61161 Mdot
.44048 .61161 Mdot
.45536 .61161 Mdot
.4628 .61161 Mdot
.49256 .61161 Mdot
.5372 .61161 Mdot
.54464 .61161 Mdot
.55208 .61161 Mdot
.55952 .61161 Mdot
.58185 .61161 Mdot
.39583 .61905 Mdot
.45536 .61905 Mdot
.4628 .61905 Mdot
.49256 .61905 Mdot
.58185 .61905 Mdot
.61905 .61905 Mdot
.38095 .62649 Mdot
.38839 .62649 Mdot
.39583 .62649 Mdot
.40327 .62649 Mdot
.41071 .62649 Mdot
.4256 .62649 Mdot
.51488 .62649 Mdot
.5744 .62649 Mdot
.58185 .62649 Mdot
.61905 .62649 Mdot
.52976 .63393 Mdot
.61905 .63393 Mdot
.34375 .64137 Mdot
.38839 .64137 Mdot
.61905 .64137 Mdot
.34375 .64881 Mdot
.41071 .64881 Mdot
.4256 .64881 Mdot
.61905 .64881 Mdot
.34375 .65625 Mdot
.4256 .65625 Mdot
.48512 .65625 Mdot
.49256 .65625 Mdot
.52976 .65625 Mdot
.55952 .65625 Mdot
.61905 .65625 Mdot
.34375 .66369 Mdot
.39583 .66369 Mdot
.41071 .66369 Mdot
.44792 .66369 Mdot
.61905 .66369 Mdot
.38839 .67113 Mdot
.60417 .67113 Mdot
.61905 .67113 Mdot
.38839 .67857 Mdot
.40327 .67857 Mdot
.41071 .67857 Mdot
.41815 .67857 Mdot
.43304 .67857 Mdot
.55208 .67857 Mdot
.55952 .67857 Mdot
.56696 .67857 Mdot
.5744 .67857 Mdot
.58929 .67857 Mdot
.59673 .67857 Mdot
.61905 .67857 Mdot
.5372 .68601 Mdot
.59673 .68601 Mdot
.35863 .69345 Mdot
.36607 .69345 Mdot
.52232 .69345 Mdot
.5372 .69345 Mdot
.59673 .69345 Mdot
.55208 .70833 Mdot
.38839 .71577 Mdot
.39583 .71577 Mdot
.40327 .71577 Mdot
.41071 .71577 Mdot
.55952 .71577 Mdot
.5744 .71577 Mdot
.55208 .72321 Mdot
.49256 .73065 Mdot
.5372 .73065 Mdot
.51488 .7381 Mdot
.1131 .83482 Mdot
.10565 .84226 Mdot
.03869 .86458 Mdot
.03869 .87202 Mdot
.05357 .87202 Mdot
.06101 .87202 Mdot
.06845 .87202 Mdot
.05357 .87946 Mdot
.09821 .87946 Mdot
.12054 .87946 Mdot
.12798 .87946 Mdot
.17262 .87946 Mdot
.23958 .87946 Mdot
.05357 .8869 Mdot
.09077 .8869 Mdot
.16518 .8869 Mdot
.24702 .8869 Mdot
.03125 .89435 Mdot
.05357 .89435 Mdot
.12798 .89435 Mdot
.06101 .90179 Mdot
.09077 .90179 Mdot
.10565 .90179 Mdot
.09821 .90923 Mdot
.12798 .90923 Mdot
.1503 .90923 Mdot
.15774 .90923 Mdot
.16518 .90923 Mdot
.20238 .90923 Mdot
.2247 .90923 Mdot
.24702 .90923 Mdot
.37351 .90923 Mdot
.41071 .90923 Mdot
.47768 .90923 Mdot
.13542 .91667 Mdot
.20238 .91667 Mdot
.2247 .91667 Mdot
.23958 .91667 Mdot
.38095 .91667 Mdot
.40327 .91667 Mdot
.48512 .91667 Mdot
.09077 .92411 Mdot
.18006 .92411 Mdot
.19494 .92411 Mdot
.23214 .92411 Mdot
.24702 .92411 Mdot
.25446 .92411 Mdot
.2619 .92411 Mdot
.31399 .92411 Mdot
.41071 .92411 Mdot
.4256 .92411 Mdot
.44792 .92411 Mdot
.47768 .92411 Mdot
.49256 .92411 Mdot
.55952 .92411 Mdot
.79018 .92411 Mdot
.79762 .92411 Mdot
.94643 .92411 Mdot
.19494 .93155 Mdot
.23958 .93155 Mdot
.32143 .93155 Mdot
.41071 .93155 Mdot
.45536 .93155 Mdot
.48512 .93155 Mdot
.49256 .93155 Mdot
.55952 .93155 Mdot
.89435 .93155 Mdot
.94643 .93155 Mdot
.17262 .93899 Mdot
.23958 .93899 Mdot
.29167 .93899 Mdot
.32887 .93899 Mdot
.35119 .93899 Mdot
.35863 .93899 Mdot
.40327 .93899 Mdot
.41071 .93899 Mdot
.4256 .93899 Mdot
.44048 .93899 Mdot
.45536 .93899 Mdot
.4628 .93899 Mdot
.48512 .93899 Mdot
.56696 .93899 Mdot
.60417 .93899 Mdot
.61161 .93899 Mdot
.64137 .93899 Mdot
.68601 .93899 Mdot
.71577 .93899 Mdot
.7753 .93899 Mdot
.78274 .93899 Mdot
.80506 .93899 Mdot
.90179 .93899 Mdot
.92411 .93899 Mdot
.95387 .93899 Mdot
.03869 .94643 Mdot
.15774 .94643 Mdot
.27679 .94643 Mdot
.29911 .94643 Mdot
.30655 .94643 Mdot
.32143 .94643 Mdot
.35863 .94643 Mdot
.37351 .94643 Mdot
.38095 .94643 Mdot
.4256 .94643 Mdot
.44792 .94643 Mdot
.48512 .94643 Mdot
.56696 .94643 Mdot
.61161 .94643 Mdot
.64137 .94643 Mdot
.71577 .94643 Mdot
.80506 .94643 Mdot
.90179 .94643 Mdot
.93155 .94643 Mdot
.95387 .94643 Mdot
.28423 .95387 Mdot
.30655 .95387 Mdot
.35863 .95387 Mdot
.38095 .95387 Mdot
.41071 .95387 Mdot
.41815 .95387 Mdot
.45536 .95387 Mdot
.4628 .95387 Mdot
.49256 .95387 Mdot
.50744 .95387 Mdot
.58929 .95387 Mdot
.61161 .95387 Mdot
.61905 .95387 Mdot
.63393 .95387 Mdot
.64881 .95387 Mdot
.66369 .95387 Mdot
.68601 .95387 Mdot
.69345 .95387 Mdot
.72321 .95387 Mdot
.74554 .95387 Mdot
.75298 .95387 Mdot
.76042 .95387 Mdot
.76786 .95387 Mdot
.78274 .95387 Mdot
.79018 .95387 Mdot
.84226 .95387 Mdot
.8497 .95387 Mdot
.85714 .95387 Mdot
.8869 .95387 Mdot
.89435 .95387 Mdot
.90179 .95387 Mdot
.90923 .95387 Mdot
.92411 .95387 Mdot
.93899 .95387 Mdot
.09077 .96131 Mdot
.23214 .96131 Mdot
.23958 .96131 Mdot
.38095 .96131 Mdot
.41071 .96131 Mdot
.47024 .96131 Mdot
.47768 .96131 Mdot
.48512 .96131 Mdot
.55208 .96131 Mdot
.59673 .96131 Mdot
.62649 .96131 Mdot
.64137 .96131 Mdot
.66369 .96131 Mdot
.73065 .96131 Mdot
.7381 .96131 Mdot
.80506 .96131 Mdot
.84226 .96131 Mdot
.87946 .96131 Mdot
.90923 .96131 Mdot
.34375 .96875 Mdot
.36607 .96875 Mdot
.5 .96875 Mdot
.50744 .96875 Mdot
.56696 .96875 Mdot
.58185 .96875 Mdot
.60417 .96875 Mdot
.64137 .96875 Mdot
.65625 .96875 Mdot
.66369 .96875 Mdot
.67857 .96875 Mdot
.68601 .96875 Mdot
.71577 .96875 Mdot
.78274 .96875 Mdot
.79018 .96875 Mdot
.80506 .96875 Mdot
.85714 .96875 Mdot
.87946 .96875 Mdot
.92411 .96875 Mdot
.94643 .96875 Mdot
.32143 .97619 Mdot
.40327 .97619 Mdot
.4628 .97619 Mdot
.47024 .97619 Mdot
.52232 .97619 Mdot
.58185 .97619 Mdot
.60417 .97619 Mdot
.7753 .97619 Mdot
.79018 .97619 Mdot
.8497 .97619 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01h000000oooo`000000000P00000oooo`<000000oooo`000000000N00000oooo`8000000oooo`00
0000000N00000_ooo`@000000oooo`000000000N000000?oool0000000000P000003oooo00000000
01X00005oooo0P000003oooo00000000008000000oooo`000000000H00001Oooo`040000oooooooo
oooo0`000003oooo0000000001800001oooo000M000000?oool0003oool08@000003oooo00000000
008000000oooo`000?ooo`0P000000Koool00000003oool0003ooolO000000?oool0003oool00P00
0003oooo0000oooo01h000000oooo`000?ooo`02000000?oool0003oool07@000007oooo00000000
0000oooo0000oooo008000000oooo`000?ooo`0K000000Goool000000000003oool010000003oooo
0000oooo01<00001oooo000M000000?oool0003oool08P000007oooo000000000000oooo0000oooo
01h00004oooo00@0003oool0003ooolO000000?oool0003oool00P000003oooo0000oooo01h00000
0oooo`000?ooo`02000000?oool0003oool07@000007oooo000000000000oooo0000oooo00800000
0oooo`000?ooo`0K000000?oool0000000000P000007oooo000000000000oooo0000oooo01<00001
oooo000M000000?oool0003oool08P000007oooo000000000000oooo0000oooo01h000000oooo`00
0?ooo`02000000?oool0003oool07`0000;oool3000000?oool0003oool07`000007oooo00000000
0000oooo0000oooo01d000001oooo`00000000000?ooo`000?ooo`02000000?oool0003oool06`00
0003oooo00000000008000001oooo`00000000000?ooo`000?ooo`0C00000Oooo`007@000003oooo
0000oooo024000000oooo`000?ooo`02000000?oool0003oool07`0000;oool2000000?oool0003o
ool07`000003oooo00000000008000000oooo`000?ooo`0N000000?oool0003oool00P000003oooo
0000oooo01d000001oooo`00000000000?ooo`000?ooo`02000000?oool0003oool06`000007oooo
000000000000oooo0000oooo008000000oooo`000?ooo`0C00000Oooo`007P000003oooo00000000
024000000oooo`0000000002000000?oool0000000007`000005oooo000000000000oooo02400002
oooo0`000003oooo0000000001h000000oooo`0000000002000000?oool0000000006`0000;oool4
000000?oool0000000000P000003oooo0000000001T00002oooo10000003oooo0000000000800000
0oooo`000000000B00000Oooo`00o`0002000001oooo003o00008000007oool00?l0000P00000Ooo
o`00o`0002000001oooo003o00008000007oool00?l0000P00000Oooo`0060000?ooool5oooo0`00
007oool001P000000oooo`0000000003000000?oool0000000001`000003oooo0000000000L00000
0oooo`0000000006000000?oool0000000001`000003oooo0000000000H000000oooo`0000000007
000000?oool0000000001`000003oooo0000000000H000000oooo`0000000007000000?oool00000
00001`000003oooo0000000000H000000oooo`0000000007000000?oool0000000001P000003oooo
0000000000L000000oooo`0000000007000000?oool0000000001P000003oooo0000000000L00000
0oooo`0000000007000000?oool0000000001P000003oooo0000000000L000000oooo`0000000006
000000?oool0000000001`000003oooo0000000000L000000oooo`0000000006000000?oool00000
00001`000003oooo0000000000L000000oooo`000?ooo`0300000Oooo`0060000003oooo00000000
0?l00001000000Coool0000000000001oooo000H000000?oool000000000o`00004000001?ooo`00
00000000007oool0018000000oooo`0000000003000000?oool000000000o`00004000001?ooo`00
00000000007oool0014000000oooo`000?ooo`04000000?oool000000000o`00004000001?ooo`00
00000000007oool0014000000oooo`000?ooo`0400000oooooh00003oooo0`00007oool001400000
0oooo`000?ooo`04000000?oool0000000005P0000Soo`0T00000_oo04/00002ool07@0000;oo`10
00001?oo00030000ool0ool000Coo`05000000Coool0000000000001oooo000A000000?oool0003o
ool010000003oooo0000000001H00008ool0900000;oo`1;00000_oo01d00002ool0@00000Coo`00
0`000?oo0?oo0004ool01@000004oooo0000000000000Oooo`004P000003oooo0000000000<00000
0oooo`000000001400000_oo00H00008ool0100000?oo`0600002?oo00H00002ool00P0000Goo`06
00000_oo00@00006ool03`0000Koo`0700000_oo00@00002ool01P0000Coo`0400000_oo04800000
1?ooo`0000000000007oool001P000000oooo`000000001400000_oo00H00008ool0100000?oo`06
00002?oo00H00002ool00P0000Goo`0600000_oo00@00006ool03`0000Koo`0700000_oo00@00002
ool01P0000Coo`0400000_oo048000001?ooo`0000000000007oool001P000000oooo`000000000g
00000_oo01400008ool0100000Coo`0C00000_oo00800002ool01@0000Coo`0E00000_oo00`00004
ool00P0000Goo`0200001?oo00P00004ool0A0000004oooo0000000000000Oooo`0060000003oooo
0000000003L00002ool04@0000Soo`0400001?oo01<00002ool00P0000;oo`0500001?oo01D00002
ool0300000Coo`0200001Ooo00800004ool0200000Coo`14000000Coool0000000000001oooo000H
000000?oool000000000>`0000;oo`0X00001_oo00P00002ool02@0000;oo`0400000_oo00T00002
ool00P0000Coo`0200000_oo00l00002ool02P0000;oo`0I00000_oo00800002ool00P0000Goo`02
00002_oo01H000001?ooo`0000000000007oool001P000000oooo`000000000k00000_oo02P00006
ool0200000;oo`0900000_oo00@00002ool02@0000;oo`0200001?oo00800002ool03`0000;oo`0:
00000_oo01T00002ool00P0000;oo`0200001Ooo0080000:ool05P000004oooo0000000000000Ooo
o`0060000003oooo0000000001H00006ool0100000Coo`0R00000_oo00h00002ool02`0000Koo`0E
00000_oo00@00002ool02@0000Coo`0200000_oo00H00002ool0100000;oo`0/00000_oo01400004
ool01P0000;oo`0300000_oo00/000001?ooo`0000000000007oool001P00002oooo5`0000Koo`04
00001?oo02800002ool03P0000;oo`0;00001_oo01D00002ool0100000;oo`0900001?oo00800002
ool01P0000;oo`0400000_oo02`00002ool04@0000Coo`0600000_oo00<00002ool02P0000;oool3
00000Oooo`0060000003oooo0000000000D00004ool0=00000_oo`0@00000_oo02`00002ool03@00
00Coo`0400000_oo01d00002ool04`0000;oo`0K00000_oo00<00002ool02`000004oooo00000000
00000Oooo`0060000003oooo0000000000D00004ool0=00000_oo`0@00000_oo02`00002ool03@00
00Coo`0400000_oo01d00002ool04`0000;oo`0K00000_oo00<00002ool02`000004oooo00000000
00000Oooo`0060000003oooo0000000004@00002ool0MP0000;oo`0X00000_oo00P00002ool03P00
0004oooo0000000000000Oooo`0060000003oooo0000000004@00002ool0MP0000;oo`0X00000_oo
00P00002ool03P000004oooo0000000000000Oooo`0060000003oooo0000000000D0000Aool06`00
00;oo`0200000_oo00@00004ool01@0000;oo`0400000_oo00@0000;ool00P0000;oo`1400001?oo
00030000ool0ool000;oo`0200000_oo00800008ool00P0000;oo`0300000_oo01T00002ool00P00
00;oo`0400000_oo00H00004ool03P000004oooo0000000000000Oooo`0060000003oooo00000000
00D0000Aool06`0000;oo`0200000_oo00@00004ool01@0000;oo`0400000_oo00@0000;ool00P00
00;oo`1400001?oo00030000ool0ool000;oo`0200000_oo00800008ool00P0000;oo`0300000_oo
01T00002ool00P0000;oo`0400000_oo00H00004ool03P000004oooo0000000000000Oooo`006000
0003oooo0000000005d00002ool05@0000;oo`1600000_oo048000001?ooo`0000000000007oool0
01P000000oooo`000000001M00000_oo01D00002ool0AP0000;oo`12000000Coool0000000000001
oooo000H00000_oooc000008ool09P0000;oo`0E00000_oo04H00002ool0@@0000;oool300000Ooo
o`0060000003oooo0000000002l00008ool09P0000;oo`0E00000_oo04H00002ool0@P000004oooo
0000000000000Oooo`0060000003oooo0000000001P00004ool02`0000Koo`0:00000_oo02@00002
ool03P0000;oo`0900000_oo02D00002ool00P0000;oo`0300000_oo01000002ool00P0000?oo`0H
00000ooo00@00002ool0100000;oo`0;00000_oo00@00002ool01@000004oooo0000000000000Ooo
o`0060000003oooo0000000001P00004ool01P0000;oo`0300002?oo00P00002ool0900000;oo`0>
00001?oo00L00004ool08`0000;oo`0200000_oo00<00002ool0400000;oo`0200000ooo00`00006
ool01P0000?oo`0400000_oo00@00002ool02`0000;oo`0400000_oo00D000001?ooo`0000000000
007oool001P000000oooo`000000000R00000_oo00T00002ool0200000;oo`0T00000_oo01000002
ool02@0000;oo`0S00000_oo00800002ool00`0000;oo`0@00000_oo01400006ool04`0000;oo`0;
00000_oo00@00002ool01@000004oooo0000000000000Oooo`0060000003oooo0000000001@00002
ool04@0000;oo`0@00001?oo02000002ool0500000;oo`0300000_oo01000002ool03`0000;oo`0;
00000_oo01L00004ool05@0000;oo`0400001?oo00l00002ool02`000004oooo0000000000000Ooo
o`0060000003oooo0000000001@00002ool04@0000;oo`0@00001?oo02000002ool0500000;oo`03
00000_oo01000002ool03`0000;oo`0;00000_oo01L00004ool05@0000;oo`0400001?oo00l00002
ool02`000004oooo0000000000000Oooo`0060000003oooo0000000001`00004ool02@0000;oo`08
00001_oo00@00002ool07P0000;oo`0D00000_oo00<00002ool03P0000;oo`0C00000_oo00T00002
ool0200000Koo`0600000_oo01T00002ool000<0003oo`3oo`000_oo00H00002ool02`0000;oo`0;
000000Coool0000000000001oooo000H000000?oool000000000700000Coo`0900000_oo00P00006
ool0100000;oo`0N00000_oo01@00002ool00`0000;oo`0>00000_oo01<00002ool02@0000;oo`08
00001_oo00H00002ool06@0000;oo`000`000?oo0?oo0002ool01P0000;oo`0;00000_oo00/00000
1?ooo`0000000000007oool001P000000oooo`000000000H00001?oo01400002ool06@0000;oo`0C
00000_oo01l00002ool06`0000Coo`0900000_oo00`00002ool01P0000;oo`0900000_oo00X00004
ool03`0000Coo`0D000000Coool0000000000001oooo000H00000_oooaT00004ool04@0000;oo`0I
00000_oo01<00002ool07`0000;oo`0K00001?oo00T00002ool0300000;oo`0600000_oo00T00002
ool02P0000Coo`0?00001?oo01<00002oooo0`00007oool001P000000oooo`000000000=00000_oo
01`00002ool06`0000;oo`0C00000_oo02T00002ool0900000Coo`0400000_oo00H00002ool00`00
00;oo`0400000_oo01T00002ool06P000004oooo0000000000000Oooo`0060000003oooo00000000
00d00002ool0700000;oo`0K00000_oo01<00002ool0:@0000;oo`0T00001?oo00@00002ool01P00
00;oo`0300000_oo00@00002ool06@0000;oo`0J000000Coool0000000000001oooo000H000000?o
ool0000000003@0000;oo`000`000?oo0?oo000:00000_oo00T00002ool0200000;oo`0200000_oo
02H00002ool0D`0000;oo`0l00001?oo00030000ool0ool000T000001?ooo`0000000000007oool0
01P000000oooo`000000000=00000_oo00030000ool0ool000X00002ool02@0000;oo`0800000_oo
00800002ool09P0000;oo`1C00000_oo03`00004ool000<0003oo`3oo`002@000004oooo00000000
00000Oooo`0060000003oooo0000000001000002ool02P0000;oo`0200000_oo00l00002ool0B@00
00;oo`0d00000_oo00l00002ool0400000;oo`0C00000_oo01@000001?ooo`0000000000007oool0
01P000000oooo`000000000@00000_oo00X00002ool00P0000;oo`0?00000_oo04T00002ool0=000
00;oo`0?00000_oo01000002ool04`0000;oo`0D000000Coool0000000000001oooo000<00000ooo
o`<000000oooo`0000000003000000?oool000000000700000;oo`0200000_oo00800002ool01`00
00;oo`0^00000_oo01l00002ool00P0000;oo`0M00000_oo00L00002ool0300000;oo`0k00001?oo
00L000001?ooo`0000000000007oool000`000000oooo`0000000002000000?oool0003oool01000
0003oooo0000000001`00002ool00P0000;oo`0200000_oo00L00002ool0;P0000;oo`0O00000_oo
00800002ool07@0000;oo`0700000_oo00`00002ool0>`0000Coo`07000000Coool0000000000001
oooo000=000000Ooool000000000003oool0003oool0100000?oool;00000_oo01D00002ool02@00
00;oo`0400001?oo02H00002ool07@0000;oo`0400000_oo00@00004ool05@0000Koo`0300000_oo
00`00002ool02@0000;oo`0Y00001?oo00`00003oooo0`00007oool000d000001oooo`0000000000
0?ooo`000?ooo`04000000?oool0000000002`0000;oo`0E00000_oo00T00002ool0100000Coo`0V
00000_oo01d00002ool0100000;oo`0400001?oo01D00006ool00`0000;oo`0<00000_oo00T00002
ool0:@0000Coo`0>000000Coool0000000000001oooo000<000000?oool0003oool00P000003oooo
0000oooo00@000000oooo`000000000;00000_oo00030000ool0ool000h00004ool04@0000;oo`0T
00000_oo00@00002ool0;00000;oo`0D00000_oo01<00002ool0100000;oo`0900000_oo00800004
ool0:00000;oo`05000000Coool0000000000001oooo000=000000?oool0000000000P000003oooo
0000000000<000000oooo`000000000;00000_oo00030000ool0ool000h00004ool04@0000;oo`0T
00000_oo00@00002ool0;00000;oo`0D00000_oo01<00002ool0100000;oo`0900000_oo00800004
ool0:00000;oo`05000000Coool0000000000001oooo000H000000?oool0000000002`0000Coo`05
00000_oo00H00002ool01P0000Coo`0=00000_oo02800002ool0100000;oo`0O00001?oo00P00002
ool0:P0000;oo`0400000_oo00/00002ool07`0000;oo`0B000000Coool0000000000001oooo000H
000000?oool0000000002`0000Coo`0500000_oo00H00002ool01P0000Coo`0=00000_oo02800002
ool0100000;oo`0O00001?oo00P00002ool0:P0000;oo`0400000_oo00/00002ool07`0000;oo`0B
000000Coool0000000000001oooo000H000000?oool0000000006P0000;oo`1300000_oo00@00002
ool07`0000;oo`0E00000_oo01T00002ool01`0000;oo`0200000_oo02400002ool05P000004oooo
0000000000000Oooo`0060000003oooo0000000001X00002ool0@`0000;oo`0400000_oo01l00002
ool05@0000;oo`0I00000_oo00L00002ool00P0000;oo`0Q00000_oo01H000001?ooo`0000000000
007oool001P000000oooo`000000000D00000_oo00800002ool0100000;oo`0C00001?oo02P00002
ool0100000;oo`0d00000_oo01400004ool01P0000;oo`0;00000_oo02400002ool03`0000;oo`05
000000Coool0000000000001oooo000H000000?oool000000000500000;oo`0200000_oo00@00002
ool04`0000Coo`0X00000_oo00@00002ool0=00000;oo`0A00001?oo00H00002ool02`0000;oo`0Q
00000_oo00l00002ool01@000004oooo0000000000000Oooo`00600000;oool>00000ooo01@00002
ool01`0000;oo`0400001?oo00P00002ool05@0000;oo`000`000?oo0?oo000400000_oo00X00002
ool00P0000;oo`0P00000_oo00P00002ool0:00000;oo`0800000_oo00P00003ool0100000;oo`0A
00000_oo00X00002oooo0`00007oool001P000000oooo`000000000=00000ooo01@00002ool01@00
00Coo`0400001?oo00P00002ool05@0000;oo`000`000?oo0?oo000400000_oo00P00008ool04`00
00Coo`0900000_oo00P00002ool00P0000Coo`0N00001_oo00P00002ool0200000Goo`0200001?oo
00l00002ool02`000004oooo0000000000000Oooo`0060000003oooo0000000002/00002ool04P00
00;oo`0E00000_oo00030000ool0ool000@00002ool0200000;oo`0200000_oo01D00004ool02@00
00;oo`0800000_oo00800004ool07P0000Koo`0800000_oo00/00002ool0100000;oo`0L000000Co
ool0000000000001oooo000H000000?oool0000000003P0000;oo`0F00000_oo00D00002ool08`00
00;oo`0;00000_oo00`00004ool00`0000;oo`1800000_oo00D00002ool0200000;oo`0;00001?oo
00@00002ool04@0000Coo`05000000Coool0000000000001oooo000H000000?oool0000000003P00
00;oo`0F00000_oo00D00002ool08`0000;oo`0;00000_oo00`00004ool00`0000;oo`1800000_oo
00D00002ool0200000;oo`0;00001?oo00@00002ool04@0000Coo`05000000Coool0000000000001
oooo000H000000?oool0000000002`0000;oo`000`000?oo0?oo0002ool0500000;oo`0500001_oo
01l00002ool00P0000;oo`0700000_oo00@00002ool03`0000;oo`1700000_oo00@00002ool07@00
00;oo`0J000000Coool0000000000001oooo000H000000?oool0000000002`0000;oo`000`000?oo
0?oo0002ool0500000;oo`0500001_oo01l00002ool00P0000;oo`0700000_oo00@00002ool03`00
00;oo`1700000_oo00@00002ool07@0000;oo`0J000000Coool0000000000001oooo000H000000?o
ool0000000001`0000;oo`0C00001?oo00/00002ool0200000;oo`0X00000_oo01000002ool0:000
00;oo`0R00000_oo02<00002ool0300000;oo`0300000_oo00L000001?ooo`0000000000007oool0
01P000000oooo`000000000700000_oo01<00004ool02`0000;oo`0800000_oo02P00002ool04000
00;oo`0X00000_oo02800002ool08`0000;oo`0<00000_oo00<00002ool01`000004oooo00000000
00000Oooo`0060000003oooo0000000000D00002ool07`0000;oo`0500000_oo00H00002ool0;P00
00Coo`0:00000_oo02P00002ool0800000;oo`0400000_oo00H00004ool09P0000;oo`07000000Co
ool0000000000001oooo000H00000_ooo`H00002ool07`0000;oo`0500000_oo00H00002ool0;P00
00Coo`0:00000_oo02P00002ool0800000;oo`0400000_oo00H00004ool09P0000;oo`0600000_oo
o`<00001oooo000H000000?oool0000000006P0000;oo`0?00000_oo00@00002ool00P0000;oo`0R
00000_oo00`00002ool0200000Coo`0700000_oo00l00004ool0100000;oo`0600000_oo01/00002
ool02`0000;oo`0200000_oo00`00002ool00`0000;oo`0P000000Coool0000000000001oooo000H
000000?oool0000000006P0000;oo`0?00000_oo00@00002ool00P0000;oo`0R00000_oo00`00002
ool0200000Coo`0700000_oo00l00004ool0100000;oo`0600000_oo01/00002ool02`0000;oo`02
00000_oo00`00002ool00`0000;oo`0P000000Coool0000000000001oooo000H000000?oool00000
0000600000;oo`0600000_oo00@00002ool00`0000;oo`0200000_oo00@00002ool0900000Coo`08
00000_oo01<00002ool04@0000;oo`0400000_oo00H00002ool06`0000;oo`0;00000_oo00800002
ool0300000;oo`0U000000Coool0000000000001oooo000H000000?oool000000000600000;oo`06
00000_oo00@00002ool00`0000;oo`0200000_oo00@00002ool0900000Coo`0800000_oo01<00002
ool04@0000;oo`0400000_oo00H00002ool06`0000;oo`0;00000_oo00800002ool0300000;oo`0U
000000Coool0000000000001oooo000H000000?oool0000000008P0000Coo`0g00000_oo00X00002
ool0100000;oo`0L00000_oo00800002ool0:@0000;oo`0=00000_oo00X00004ool01@0000Coo`0L
000000Coool0000000000001oooo000H000000?oool0000000008P0000Coo`0g00000_oo00X00002
ool0100000;oo`0L00000_oo00800002ool0:@0000;oo`0=00000_oo00X00004ool01@0000Coo`0L
000000Coool0000000000001oooo000H000000?oool000000000;@0000;oo`0Z00000_oo00800002
ool02P0000;oo`0400000_oo00l00004ool0200000;oo`0^00000_oo01<00002ool0100000;oo`00
0`000?oo0?oo000200000_oo00h00002ool00`0000;oo`0;000000Coool0000000000001oooo000H
000000?oool000000000;@0000;oo`0Z00000_oo00800002ool02P0000;oo`0400000_oo00l00004
ool0200000;oo`0^00000_oo01<00002ool0100000;oo`000`000?oo0?oo000200000_oo00h00002
ool00`0000;oo`0;000000Coool0000000000001oooo000H00000_ooobD00002ool0700000;oo`0E
00000_oo00X00004ool07@0000;oo`0;00000_oo01<00002ool02P0000Coo`0900000_oo00h00002
ool01P0000;oo`0H00002?oo00@00002oooo0`00007oool001P000000oooo`000000000T00000_oo
01`00002ool05@0000;oo`0:00001?oo01d00002ool02`0000;oo`0C00000_oo00X00004ool02@00
00;oo`0>00000_oo00H00002ool0600000Soo`05000000Coool0000000000001oooo000H000000?o
ool000000000600000;oo`0:00000_oo01`00002ool05@0000;oo`0>00000_oo03d00002ool02P00
00Coo`0A00000_oo01400002ool00P0000;oo`0600001?oo00800002ool040000004oooo00000000
00000Oooo`0060000003oooo0000000001P00002ool02P0000;oo`0L00000_oo01D00002ool03P00
00;oo`0m00000_oo00X00004ool04@0000;oo`0A00000_oo00800002ool01P0000Coo`0200000_oo
010000001?ooo`0000000000007oool001P000000oooo`000000000B00002?oo00X00002ool0<`00
00;oo`0>00001_oo00800002ool04@0000Coo`0;00000_oo02400002ool02@0000;oo`0Y00001?oo
010000001?ooo`0000000000007oool001P000000oooo`000000000B00002?oo00X00002ool0<`00
00;oo`0>00001_oo00800002ool04@0000Coo`0;00000_oo02400002ool02@0000;oo`0Y00001?oo
010000001?ooo`0000000000007oool001P000000oooo`000000000H00000_oo00P00004ool00`00
00;oo`0^00000_oo00`00002ool01P0000;oo`0200000_oo01h00002ool08@0000;oo`0;00000_oo
00`00002ool01P0000;oo`0500000_oo01h000001?ooo`0000000000007oool001P000000oooo`00
0000000H00000_oo00H00006ool00`0000;oo`0]00000ooo00H00002ool0100000;oo`0600000_oo
00800002ool07P0000;oo`0400000_oo01<00002ool01P0000;oo`0600000_oo00<00002ool03000
00;oo`0600000_oo00D00004ool05@0000;oo`05000000Coool0000000000001oooo000=00000ooo
o`8000000oooo`0000000003000000?oool000000000800000;oo`0200000_oo03800002ool01`00
00;oo`0f00000_oo01<00002ool03P0000;oo`0A00000_oo00l00002ool05@0000;oo`05000000Co
ool0000000000001oooo000>000000Koool00000003oool0003oool4000000?oool0000000001@00
00[oo`000`000?oo0?oo0006ool0200000;oo`0200000_oo03800002ool01`0000;oo`1;00000_oo
01T00004ool0100000;oo`0200000_oo00T00002ool05@0000;oo`07000000Coool0000000000001
oooo000<00001?ooo`040000oooo0000oooo100000?oool500002_oo00030000ool0ool000Koo`08
00000_oo00800002ool0<P0000;oo`0700000_oo04/00002ool06@0000Coo`0400000_oo00800002
ool02@0000;oo`0E00000_oo00D00003oooo0`00007oool000`000000oooo`000?ooo`02000000?o
ool0003oool010000003oooo0000000002d00002ool01P0000;oo`0^00001?oo00800002ool00P00
00;oo`1100001?oo00T00002ool0100000Coo`0400000_oo00@00004ool00`0000;oo`0400000_oo
00`00002ool00`0000;oo`0;000000Coool0000000000001oooo000=00000_ooo`8000000oooo`00
0?ooo`04000000?oool000000000;@0000;oo`0600000_oo02h00004ool00P0000;oo`0200000_oo
04400004ool02@0000;oo`0400001?oo00@00002ool0100000Coo`0300000_oo00@00002ool03000
00;oo`0300000_oo00/000001?ooo`0000000000007oool000h000001Oooo`00000000000?ooo`05
000000?oool000000000800000;oo`0;00000_oo00H00002ool07`0000Coo`0J00000_oo04T00002
ool0200000;oo`0200000_oo00P00004ool000<0003oo`3oo`00100000Koo`0400000_oo00L00002
ool02@000004oooo0000000000000Oooo`0060000003oooo0000000002000002ool02`0000;oo`06
00000_oo01l00004ool06P0000;oo`1900000_oo00P00002ool00P0000;oo`0800001?oo00030000
ool0ool000@00006ool0100000;oo`0700000_oo00T000001?ooo`0000000000007oool001P00000
0oooo`000000000]00001?oo00@00002ool00P0000;oo`0=00000_oo02400002ool03@0000;oo`0>
00000_oo00<00004ool00P0000;oo`0A00000_oo00P00002ool06@0000;oo`0:00000ooo01000002
ool04P000004oooo0000000000000Oooo`0060000003oooo0000000002d00004ool0100000;oo`02
00000_oo00d00002ool08@0000;oo`0=00000_oo00h00002ool00`0000Coo`0200000_oo01400002
ool0200000;oo`0I00000_oo00X00003ool0400000;oo`0B000000Coool0000000000001oooo000H
000000?oool000000000900000;oo`000`000?oo0?oo000400001?oo00@00004ool03`0000;oo`0Q
00000_oo00d00002ool0400000;oo`0500000_oo01<00002ool0200000;oo`0800000_oo01400002
ool03`0000Soo`0600000_oo010000001?ooo`0000000000007oool001P000000oooo`000000000T
00000_oo00030000ool0ool000@00004ool0100000Coo`0?00000_oo02400002ool03@0000;oo`0@
00000_oo00D00002ool04`0000;oo`0800000_oo00P00002ool04@0000;oo`0?00002?oo00H00002
ool040000004oooo0000000000000Oooo`00600000;ooolM00000_oo00/00002ool0100000;oo`0:
00000_oo00800002ool0<`0000Coo`0400000_oo00800004ool0100000Coo`0=00000_oo00H00004
ool04@0000;oo`0400000_oo02h00002ool04@0000;oool300000Oooo`0060000003oooo00000000
01`00002ool02`0000;oo`0400000_oo00X00002ool00P0000;oo`0c00001?oo00@00002ool00P00
00Coo`0400001?oo00d00002ool01P0000Coo`0A00000_oo00@00002ool0;P0000;oo`0B000000Co
ool0000000000001oooo000H000000?oool000000000:@0000Soo`0:00000_oo04400002ool03@00
00;oo`0:00000_oo00H00004ool03@0000Coo`0200000_oo03800002ool04P000004oooo00000000
00000Oooo`0060000003oooo0000000002T00008ool02P0000;oo`1100000_oo00d00002ool02P00
00;oo`0600001?oo00d00004ool00P0000;oo`0b00000_oo018000001?ooo`0000000000007oool0
01P000000oooo`000000001:00000_oo00l00004ool04P0000;oo`0500000_oo00@00002ool02000
00Koo`0900000_oo00@00002ool00P0000Coo`0=00000_oo03000002ool06P000004oooo00000000
00000Oooo`0060000003oooo0000000004X00002ool03`0000Coo`0B00000_oo00D00002ool01000
00;oo`0800001_oo00T00002ool0100000;oo`0200001?oo00d00002ool0<00000;oo`0J000000Co
ool0000000000001oooo000H000000?oool000000000<`0000Coo`0C00000_oo00l00004ool05@00
00Koo`0B00000_oo00030000ool0ool000;oo`0:00000_oo00800004ool0?`0000;oo`0J000000Co
ool0000000000001oooo000H000000?oool000000000<`0000Coo`0C00000_oo00l00004ool05@00
00Koo`0B00000_oo00030000ool0ool000;oo`0:00000_oo00800004ool0?`0000;oo`0J000000Co
ool0000000000001oooo000H000000?oool000000000C00000Coo`0200000_oo00d00002ool01P00
00Coo`0700000_oo01800006ool000<0003oo`3oo`00300000;oo`0600000_oo04/00005ool00P00
00;oo`05000000Coool0000000000001oooo000H000000?oool000000000C00000Coo`0200000_oo
00d00002ool01P0000Coo`0700000_oo01800006ool000<0003oo`3oo`00300000;oo`0600000_oo
04/00005ool00P0000;oo`05000000Coool0000000000001oooo000H00000_oood<00004ool01P00
00;oo`0400000_oo00d00002ool0400000?oo`0F00000_oo00L00002ool01P0000;oo`0;00001?oo
05400002oooo0`00007oool001P000000oooo`000000001200001?oo00H00002ool0100000;oo`0=
00000_oo01000003ool05P0000;oo`0700000_oo00H00002ool02`0000Coo`1B000000Coool00000
00000001oooo000H000000?oool000000000E00000;oo`0200000_oo01400002ool0100000;oo`0I
00000_oo00L00002ool01P0000Coo`0400000_oo04400004ool050000004oooo0000000000000Ooo
o`0060000003oooo0000000005800008ool04@0000;oo`0200001?oo01T00002ool000<0003oo`3o
o`00100000;oo`0600001?oo00@00002ool0@@0000Coo`0D000000Coool0000000000001oooo000H
000000?oool000000000DP0000;oo`0200000_oo01<00002ool00P0000;oo`0N00000_oo00@00002
ool01P0000Coo`0400000_oo05T000001?ooo`0000000000007oool001P000000oooo`000000001Q
00000_oo00X00002ool0800000;oo`0200000_oo00P00004ool0DP0000;oo`0;000000Coool00000
00000001oooo000H000000?oool000000000H@0000;oo`0:00000_oo02000002ool00P0000;oo`08
00001?oo05800002ool02`000004oooo0000000000000Oooo`0060000003oooo0000000006400002
ool0>P0000;oo`0200000_oo05800002ool02@000004oooo0000000000000Oooo`0060000003oooo
0000000006400002ool0>P0000;oo`0200000_oo05800002ool02@000004oooo0000000000000Ooo
o`0060000003oooo0000000006<00004ool0V@000004oooo0000000000000Oooo`00600000;ooomT
00001?oo09P00002oooo0`00007oool001P000000oooo`000000001Q00000_oo00800002ool0V@00
0004oooo0000000000000Oooo`0060000003oooo0000000006400002ool00P0000;oo`2I000000Co
ool0000000000001oooo000H000000?oool000000000H`0000;oo`0200000_oo09L000001?ooo`00
00000000007oool001P000000oooo`000000001S00000_oo00800002ool0U`000004oooo00000000
00000Oooo`0060000003oooo0000000006<00002ool0=00000;oo`1U000000Coool0000000000001
oooo000H000000?oool000000000H`0000;oo`0d00000_oo06D000001?ooo`0000000000007oool0
00`00002oooo10000003oooo0000000000<000000oooo`000000001U00000_oo09T000001?ooo`00
00000000007oool000`000000oooo`000?ooo`02000000?oool0003oool010000003oooo00000000
06D00002ool0V@000004oooo0000000000000Oooo`0030000003oooo0000oooo008000000oooo`00
0?ooo`0400000oooooh00003oooo0`00007oool000`00002oooo0`000003oooo0000oooo00@00000
0oooo`000000003o00000@000004oooo0000000000000Oooo`0030000003oooo0000000000800000
0oooo`000?ooo`04000000?oool000000000o`00004000001?ooo`0000000000007oool000d00002
oooo0`000003oooo0000000000<000000oooo`000000003o00000@000004oooo0000000000000Ooo
o`0060000003oooo0000000006D00002ool0:P0000;oo`1]000000Coool0000000000001oooo000H
000000?oool000000000I@0000;oo`0Z00000_oo06d000001?ooo`0000000000007oool001P00000
0oooo`000000001U00000_oo09T000001?ooo`0000000000007oool001P000000oooo`000000001U
00000_oo09T000001?ooo`0000000000007oool001P000000oooo`000000001a00001Ooo08X00000
1?ooo`0000000000007oool001P000000oooo`000000001Q00000_oo00h00005ool0RP000004oooo
0000000000000Oooo`00600000;ooomR00000_oo00h00004ool0RP0000;oool300000Oooo`006000
0003oooo0000000007P00002ool00P0000;oo`22000000Coool0000000000001oooo000H000000?o
ool000000000N00000;oo`0200000_oo088000001?ooo`0000000000007oool001P000000oooo`00
0000001M00001?oo01T00006ool0300000;oo`0;00000_oo06D000001?ooo`0000000000007oool0
01P000000oooo`000000001M00001?oo01T00006ool0300000;oo`0;00000_oo06D000001?ooo`00
00000000007oool001P000000oooo`000000001[00000_oo00@00004ool0900000;oo`1U000000Co
ool0000000000001oooo000H000000?oool000000000J`0000;oo`0400001?oo02@00002ool0I@00
0004oooo0000000000000Oooo`0060000003oooo0000000006T00002ool01P0000;oo`0G00000_oo
01400002ool0H@000004oooo0000000000000Oooo`0060000003oooo0000000006T00002ool01P00
00;oo`0G00000_oo01400002ool0H@000004oooo0000000000000Oooo`0060000003oooo00000000
06/00004ool03@0000Koo`0K00000_oo064000001?ooo`0000000000007oool001P00002ooooK000
00Coo`0=00001_oo01/00002ool0H00000;oool300000Oooo`0060000003oooo0000000005T00002
ool0300000;oo`0800000_oo00D00004ool08@0000;oo`1Q000000Coool0000000000001oooo000H
000000?oool000000000F@0000;oo`0<00000_oo00P00002ool01@0000Coo`0Q00000_oo06400000
1?ooo`0000000000007oool001P000000oooo`000000001W00000_oo00X00003ool05P0000;oo`0?
00000_oo064000001?ooo`0000000000007oool001P000000oooo`000000001W00000_oo00X00003
ool05P0000;oo`0?00000_oo064000001?ooo`0000000000007oool001P000000oooo`000000001_
00000_oo00L00004ool01P0000Coo`1j000000Coool0000000000001oooo000H000000?oool00000
0000K`0000;oo`0700001?oo00H00004ool0NP000004oooo0000000000000Oooo`0060000003oooo
0000000005/00002ool0400000;oo`0I00000_oo07H000001?ooo`0000000000007oool001P00000
0oooo`000000001K00000_oo01000002ool06@0000;oo`1f000000Coool0000000000001oooo000H
00000_ooofP00002ool00P0000;oo`0700001?oo00`00004ool00P0000;oo`1c00000_ooo`<00001
oooo000H000000?oool000000000I`0000;oo`0200000_oo00L00004ool0300000Coo`0200000_oo
07@000001?ooo`0000000000007oool001P000000oooo`000000001U00000_oo02<00002ool0M000
0004oooo0000000000000Oooo`0060000003oooo0000000006D00002ool08`0000;oo`1d000000Co
ool0000000000001oooo000H000000?oool000000000EP0000;oo`0G00001?oo08d000001?ooo`00
00000000007oool001P000000oooo`000000001F00000_oo01L00004ool0S@000004oooo00000000
00000Oooo`0060000003oooo0000000005H00002ool02@0000Coo`0:00001?oo00L00002ool01P00
00;oo`0200000_oo00T00002ool0K@000004oooo0000000000000Oooo`0060000003oooo00000000
05H00002ool02@0000Coo`0400003Ooo00@00004ool0100000;oo`0200002Ooo00800004ool0J`00
0004oooo0000000000000Oooo`003@000003oooo00000000008000000oooo`0000000003000000?o
ool000000000H`0000;oo`0400002?oo00800003ool01P0000;oo`0:00001ooo00@00002ool0J`00
0004oooo0000000000000Oooo`0030000003oooo0000oooo008000000oooo`000?ooo`04000000?o
ool000000000H`0000;oo`0>00000ooo00H00002ool05@0000;oo`0800000_oo064000001?ooo`00
00000000007oool000`000000oooo`000?ooo`02000000?oool0003oool0100000?ooomS00000_oo
00h00003ool01P0000;oo`0E00000_oo00P00002ool0G`0000?oool300000Oooo`003@000007oooo
000000000000oooo0000oooo00@000000oooo`000000001O00002_oo00800002ool05@0000;oo`0=
00001?oo00P00002ool0H@000004oooo0000000000000Oooo`0030000003oooo0000oooo00800000
0oooo`000?ooo`04000000?oool000000000G`0000[oo`0200000_oo01D00002ool03@0000Coo`08
00000_oo064000001?ooo`0000000000007oool000d000000oooo`0000000002000000?oool00000
00000`000003oooo0000000008H00002ool05@0000;oo`1Q000000Coool0000000000001oooo000H
000000?oool000000000QP0000;oo`0E00000_oo064000001?ooo`0000000000007oool001P00000
0oooo`000000001F00000_oo00T00002ool0>P0000;oo`1Q000000Coool0000000000001oooo000H
000000?oool000000000EP0000;oo`0900000_oo03X00002ool0H@000004oooo0000000000000Ooo
o`0060000003oooo0000000005H00002ool03`0000;oo`0200000_oo03000002ool0H@000004oooo
0000000000000Oooo`0060000003oooo0000000005H00002ool03`0000;oo`0200000_oo03000002
ool0H@000004oooo0000000000000Oooo`00600000;ooomG00000_oo01<00002ool03@0000Coo`08
00000_oo00D00002ool03P0000;oo`1P00000_ooo`<00001oooo000H000000?oool000000000EP00
00;oo`0C00000_oo00d00004ool0200000;oo`0500000_oo00h00002ool0H@000004oooo00000000
00000Oooo`0060000003oooo0000000005H00002ool02`0000;oo`0200000_oo00P00002ool0:P00
00;oo`1Q000000Coool0000000000001oooo000H000000?oool000000000EP0000;oo`0;00000_oo
00800002ool0200000;oo`0Z00000_oo064000001?ooo`0000000000007oool001P000000oooo`00
0000001Q00000_oo03H00002ool00P0000;oo`1Q000000Coool0000000000001oooo000H000000?o
ool000000000H@0000;oo`0f00000_oo00800002ool0H@000004oooo0000000000000Oooo`006000
0003oooo0000000006400002ool00P0000Koo`0200000_oo01d00007ool00P0000Coo`0400000_oo
064000001?ooo`0000000000007oool001P000000oooo`000000001Q00000_oo00800006ool00P00
00;oo`0M00001ooo00800004ool0100000;oo`1Q000000Coool0000000000001oooo000H000000?o
ool000000000R00000;oo`0=00000_oo06L000001?ooo`0000000000007oool001P000000oooo`00
0000002800000_oo00d00002ool0I`000004oooo0000000000000Oooo`00600000;ooomJ00001?oo
02L00002ool00P0000;oo`0=00000_oo06H00002oooo0`00007oool001P000000oooo`000000001I
00001?oo02L00002ool00P0000;oo`0=00000_oo06L000001?ooo`0000000000007oool001P00000
0oooo`000000003o00000@000004oooo0000000000000Oooo`0060000003oooo0000000008`00002
ool0LP000004oooo0000000000000Oooo`0060000003oooo0000000008`00002ool0LP000004oooo
0000000000000Oooo`0060000003oooo0000000006400008ool0900000;oo`0200000_oo06d00000
1?ooo`0000000000007oool001P000000oooo`000000001Q00002?oo02@00002ool00P0000;oo`1]
000000Coool0000000000001oooo000H000000?oool000000000S00000;oo`1b000000Coool00000
00000001oooo000H000000?oool000000000S00000;oo`1b000000Coool0000000000001oooo000H
000000?oool000000000O00000;oo`0:00000_oo07H000001?ooo`0000000000007oool001P00002
ooooO@0000;oo`0:00000_oo07D00002oooo0`00007oool001P000000oooo`000000002200000_oo
07`000001?ooo`0000000000007oool001P000000oooo`000000002200000_oo07`000001?ooo`00
00000000007oool001P000000oooo`000000003o00000@000004oooo0000000000000Oooo`006000
0003oooo000000000?l00001000000Coool0000000000001oooo000H000000?oool000000000o`00
004000001?ooo`0000000000007oool001P000000oooo`000000003o00000@000004oooo00000000
00000Oooo`001P0000Goool2000000?oool0000000000P000003oooo0000000000<000000oooo`00
0000003o00000@000004oooo0000000000000Oooo`0020000007oooo000000000000oooo0000oooo
008000000oooo`000?ooo`04000000?oool000000000o`00004000001?ooo`0000000000007oool0
00P000001oooo`00000000000?ooo`000?ooo`02000000?oool0003oool0100000?oooon00000ooo
o`<00001oooo0008000000Ooool000000000003oool0003oool00P000003oooo0000oooo00@00000
0oooo`000000003o00000@000004oooo0000000000000Oooo`0020000007oooo000000000000oooo
0000oooo008000000oooo`000?ooo`04000000?oool000000000o`00004000001?ooo`0000000000
007oool000L00002oooo10000003oooo00000000008000000oooo`0000000003000000?oool00000
0000o`00004000001?ooo`0000000000007oool001P000000oooo`000000003o00000@000004oooo
0000000000000Oooo`0060000003oooo000000000?l00001000000Coool0000000000001oooo000H
000000?oool000000000o`00004000001?ooo`0000000000007oool001P000000oooo`000000003o
00000@000004oooo0000000000000Oooo`0060000003oooo000000000?l00001000000Coool00000
00000001oooo000H000000?oool000000000o`00004000001?ooo`0000000000007oool001P00002
ooooo`0000400002oooo0`00007oool001P000000oooo`000000003o00000@000004oooo00000000
00000Oooo`0060000003oooo000000000?l00001000000Coool0000000000001oooo000H000000?o
ool000000000o`00004000001?ooo`0000000000007oool001P000000oooo`000000003o00000@00
0004oooo0000000000000Oooo`0060000003oooo000000000?l00001000000Coool0000000000001
oooo000H000000?oool000000000o`00004000001?ooo`0000000000007oool001P000000oooo`00
0000000J00000_oo0>@000001?ooo`0000000000007oool001P000000oooo`000000000J00000_oo
0>@000001?ooo`0000000000007oool001P000000oooo`000000000H00000_oo0>H000001?ooo`00
00000000007oool001P00002oooo6@0000;oo`3U00000_ooo`<00001oooo000H000000?oool00000
0000o`00004000001?ooo`0000000000007oool001P000000oooo`000000003o00000@000004oooo
0000000000000Oooo`0060000003oooo000000000?l00001000000Coool0000000000001oooo000H
000000?oool000000000o`00004000001?ooo`0000000000007oool001P000000oooo`0000000007
00000_oo0?L000001?ooo`0000000000007oool001P000000oooo`000000000700000_oo0?L00000
1?ooo`0000000000007oool001P000000oooo`000000000700000_oo00800005ool0l0000004oooo
0000000000000Oooo`0060000003oooo0000000000L00002ool00P0000Goo`3`000000Coool00000
00000001oooo000H00000_ooo``00002ool02@0000;oo`0400001?oo00T00002ool0400000;oo`32
00000_ooo`<00001oooo000H000000?oool0000000002`0000;oo`0900000_oo00@00004ool02@00
00;oo`0@00000_oo0<<000001?ooo`0000000000007oool001P000000oooo`000000000;00000_oo
00L00002ool04@0000;oo`0D00000_oo0<4000001?ooo`0000000000007oool001P000000oooo`00
0000000;00000_oo00L00002ool04@0000;oo`0D00000_oo0<4000001?ooo`0000000000007oool0
01P000000oooo`000000000500000_oo00@00002ool04@0000;oo`3P000000Coool0000000000001
oooo000H000000?oool0000000001@0000;oo`0400001?oo00D00002ool00P0000;oo`0400000_oo
0>0000001?ooo`0000000000007oool001P000000oooo`000000000=00000_oo00D00002ool00P00
00;oo`3V000000Coool0000000000001oooo000H000000?oool0000000005P0000;oo`0600000_oo
00@00005ool0200000;oo`0400000_oo00@00002ool07P0000;oo`0800000_oo00l00002ool0QP00
0004oooo0000000000000Oooo`001P0000Goool010000?ooooooooooo`<000000oooo`0000000003
000000?oool0000000005P0000;oo`0600000_oo00@00005ool0200000;oo`0400000_oo00@00002
ool07P0000;oo`0800000_oo00l00002ool0QP000004oooo0000000000000Oooo`0020000005oooo
000000000000oooo00@000000oooo`000?ooo`04000000?oool000000000800000;oo`0?00000_oo
00@00002ool00P0000;oo`0R00000_oo00@00002ool04`0000;oo`24000000Coool0000000000001
oooo0008000000?oool0000000000P000007oooo000000000000oooo0000oooo00@00003oooo8000
00;oo`0?00000_oo00@00002ool00P0000;oo`0R00000_oo00@00002ool04`0000;oo`2200000ooo
o`<00001oooo0008000000?oool0000000000P000007oooo000000000000oooo0000oooo00@00000
0oooo`000000000D00000_oo01D00002ool00P0000;oo`0800000_oo00800005ool0300000;oo`0G
00000_oo00800002ool0100000;oo`0500000_oo00800002ool03`0000;oo`0j00001?oo02D00002
ool030000004oooo0000000000000Oooo`0020000007oooo000000000000oooo0000oooo00800000
0oooo`000?ooo`04000000?oool000000000500000;oo`0E00000_oo00800002ool0200000;oo`02
00001Ooo00`00002ool05`0000;oo`0200000_oo00@00002ool01@0000;oo`0200000_oo00l00002
ool0>P0000Coo`0U00000_oo00`000001?ooo`0000000000007oool000L00002oooo10000003oooo
00000000008000000oooo`0000000003000000?oool000000000;`0000;oo`0:00000_oo01<00002
ool05@0000;oo`0:00000_oo00D00004ool03`0000;oo`1E00000_oo00`00002ool030000004oooo
0000000000000Oooo`0060000003oooo0000000002l00002ool02P0000;oo`0C00000_oo01D00002
ool02P0000;oo`0500001?oo00l00002ool0E@0000;oo`0<00000_oo00`000001?ooo`0000000000
007oool001P000000oooo`000000000Y00000_oo01000002ool02`0000;oo`0800000_oo00@00003
ool02P0000Coo`0200000_oo00800002ool00P0000?oo`0400000_oo01<00002ool0200000Coo`06
00000_oo00T00002ool01P0000;oo`0=00001?oo00@00002ool05`0000;oo`0400000_oo00D00002
ool02`000004oooo0000000000000Oooo`0060000003oooo0000000002T00002ool0400000;oo`0;
00000_oo00P00002ool0100000?oo`0:00001?oo00800002ool00P0000;oo`0200000ooo00@00002
ool04`0000;oo`0800001?oo00H00002ool02@0000;oo`0600000_oo00d00004ool0100000;oo`0G
00000_oo00@00002ool01@0000;oo`0;000000Coool0000000000001oooo000H000000?oool00000
00001`0000;oo`0M00000_oo01`00002ool0100000Coo`0200000_oo00L00002ool00P0000Coo`0:
00000_oo00@00002ool01`0000;oo`0C00000_oo00X00002ool01P0000;oo`0A00000_oo01D00002
ool05`0000;oo`0600000_oo00<00002ool02`000004oooo0000000000000Oooo`0060000003oooo
0000000000L00002ool07@0000;oo`0L00000_oo00@00004ool00P0000;oo`0700000_oo00800004
ool02P0000;oo`0400000_oo00L00002ool04`0000;oo`0:00000_oo00H00002ool04@0000;oo`0E
00000_oo01L00002ool01P0000;oo`0300000_oo00/000001?ooo`0000000000007oool001P00002
ooooA`0000;oo`0400000_oo00/00002ool0100000;oo`0600001?oo00P00003ool01P0000;oo`02
00000_oo01<00002ool0100000Coo`0200000_oo00800002ool000<0003oo`3oo`00100000Coo`06
00000_oo00@00007ool00P0000Coo`0<00001Ooo00H00008ool00P0000;oo`0200000_oo00d00002
oooo0`00007oool001P000000oooo`000000001600000_oo00@00002ool02`0000;oo`0400000_oo
00H00004ool0200000?oo`0600000_oo00800002ool04`0000;oo`0400001?oo00800002ool00P00
00;oo`000`000?oo0?oo000400001?oo00H00002ool0100000Ooo`0200001?oo00`00005ool01P00
00Soo`0200000_oo00800002ool03P000004oooo0000000000000Oooo`0060000003oooo00000000
01@00002ool08`0000Coo`0R00000_oo00H00002ool03@0000Koo`0@00000_oo00T00002ool01P00
00;oo`0200000_oo00<00002ool0400000Coo`0?00000_oo00P00002ool01`0000;oo`0600000_oo
01H000001?ooo`0000000000007oool001P000000oooo`000000000D00000_oo02<00004ool08P00
00;oo`0600000_oo00d00006ool0400000;oo`0900000_oo00H00002ool00P0000;oo`0300000_oo
01000004ool03`0000;oo`0800000_oo00L00002ool01P0000;oo`0F000000Coool0000000000001
oooo000H000000?oool000000000EP0000;oo`0300000_oo02400004ool03@0000;oo`0200000_oo
00@00002ool0200000;oo`000`000?oo0?oo0002ool00P0000Coo`0600000_oo00l00004ool00P00
00;oo`0;00000_oo00@00002ool02P0000;oo`0400000_oo00`000001?ooo`0000000000007oool0
01P000000oooo`000000001F00000_oo00<00002ool08@0000Coo`0=00000_oo00800002ool01000
00;oo`0800000_oo00030000ool0ool000;oo`0200001?oo00H00002ool03`0000Coo`0200000_oo
00/00002ool0100000;oo`0:00000_oo00@00002ool030000004oooo0000000000000Oooo`006000
0003oooo0000000005000002ool04`0000;oo`0=00001?oo00`00002ool03@0000;oo`0400000_oo
02X00002ool00P0000;oo`0>00000_oo02D000001?ooo`0000000000007oool001P000000oooo`00
0000001@00000_oo01<00002ool03@0000Coo`0<00000_oo00d00002ool0100000;oo`0Z00000_oo
00800002ool03P0000;oo`0U000000Coool0000000000001oooo000H000000?oool000000000o`00
004000001?ooo`0000000000007oool001P000000oooo`000000003o00000@000004oooo00000000
00000Oooo`00600000;ooooo00000@0000;oool300000Oooo`0060000003oooo0000000000<00000
0oooo`0000000007000000?oool0000000001`000003oooo0000000000H000000oooo`0000000007
000000?oool0000000001P000003oooo0000000000L000000oooo`0000000007000000?oool00000
00001P000003oooo0000000000L000000oooo`0000000007000000?oool0000000001P000003oooo
0000000000L000000oooo`0000000006000000?oool0000000001`000003oooo0000000000L00000
0oooo`0000000006000000?oool0000000001`000003oooo0000000000L000000oooo`0000000006
000000?oool0000000001`000003oooo0000000000H000000oooo`0000000007000000?oool00000
00001`000003oooo0000000000H000000oooo`0000000007000000?oool0000000001`000003oooo
0000oooo00<00001oooo000H0000ooooo`Goool300000Oooo`00o`0002000001oooo003o00008000
007oool00?l0000P00000Oooo`00o`0002000001oooo003o00008000007oool007T00002ooooY000
007oool007/000000oooo`000000002Q00000Oooo`00H@0000Goool800000oooo`<00002oooo0`00
00Coool010000?ooo`000?ooo`800002oooo00<0003oooooool00P000003oooo0000000000;oool3
00000_ooo`<00003oooo4@0000;oool300000oooo`800002oooo0P0000?oool200000oooo`030000
oooooooo008000000oooo`0000000002ooooE000007oool006<000000oooo`0000000008000000?o
ool0003oool00P000003oooo00000000008000000oooo`0000000002oooo00H0003oool0003oool0
003oool4000000Koool00000003oool0003oool2000000?oool0003oool010000004oooo00000000
oooo40000006oooo00000000oooo0000oooo0P000003oooo0000oooo008000001?ooo`0000000?oo
o`@000001Oooo`00000000000?ooo`02000000?oool0003oool0EP00007oool006<000000oooo`00
0000000:000000?oool0000000000oooo`8000000oooo`0000000002oooo00D0003oool0003oool0
00000oooo`8000001_ooo`0000000?ooo`000?ooo`@00003oooo0P000004oooo00000000oooo4000
0006oooo00000000oooo0000oooo0P000003oooo0000oooo00D000000oooo`0000000002000000Go
ool000000000003oool00P000003oooo0000oooo00;ooomD00000Oooo`00H`000003oooo00000000
00T000001?ooo`000000000000?oool300001Oooo`040000oooo000000000oooo`030000oooooooo
00;oool00`000?ooooooo`02oooo0P0000?oool300000ooooa400002oooo00@0003oooooool00006
oooo0`000004oooo0000000000000_ooo`800004oooo0P0000?ooomD00000Oooo`00H`000003oooo
0000000000P000000oooo`000?ooo`0K000000?oool0000000002P000003oooo0000000001P00000
0oooo`0000000003000000?oool000000000HP00007oool006800002oooo2P0000?ooolW00000_oo
oal00002oooo10000003oooo0000000005d00001oooo003o00008000007oool00?l0000P00000Ooo
o`00o`0002000001oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-16.0479, -9.55716, 0.519609, 
  0.519609}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[1-segment1[[1]],
\tPlotLabel->\"1 segment sketch\",Mesh->False];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -50 0 ]
[.5 1.0125 50 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
75.000000 13.000000 moveto
(segment) show
123.000000 13.000000 moveto
(sketch) show
159.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFFFFFF0000FFFFFFFFFFFFFF00
00000000FFFFFFFFFFFF0000FFFFFFFFFFFF0000FFFF00FF
00FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FF000000
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFFFF00000000FFFF0000FFFFFF
00000000FFFFFF00FF000000FFFFFF00FFFF000000FFFFFF
FFFFFFFFFF000000FFFFFFFF00FFFF00FFFFFF0000FFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFF00000000FFFF0000FFFFFFFF
FFFF0000FFFF00FF0000FFFF0000FFFFFFFFFFFFFFFFFF00
00000000FFFFFFFF0000FF000000000000FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF00000000FFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF00000000FF000000FFFFFFFF
FFFF000000FFFFFF0000FF000000FF00FFFF00FFFFFFFFFF
00000000FF00FF000000FFFF00000000FFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFF00FF00FF000000FF0000000000FF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF000000FFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000FFFFFFFFFFFF0000FFFFFFFF
FF000000FFFF00FF00FFFF00FF00FF00FFFF0000FFFFFFFF
00000000FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFF
0000FFFF0000FFFF
0000FFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000FFFFFFFFFFFF0000FFFFFFFF
FFFF000000FFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFF
0000000000FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFF
0000FFFF0000FFFF
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FF000000FFFFFFFFFFFF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFF000000FFFFFFFFFFFF000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF0000FFFF
FFFF0000FFFF00FF
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFF0000FFFF0000FFFF00FFFF000000000000FF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FF0000FF00FF000000000000
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF0000FFFF
FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000FF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF0000
00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF
00FFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFF00FFFFFF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00000000FFFF
FFFF0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000
FFFFFFFF00FF0000FFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFF00FF0000
0000FFFF00FFFF000000FFFFFFFF0000FFFF00FF0000FFFF
FFFFFFFF00000000
FFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00000000FFFF
FF000000FF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFF0000
FFFFFF00FFFF000000FFFFFF0000FFFFFFFF00FF00FFFFFF
FFFFFFFFFFFFFFFF000000000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF000000FFFFFF0000FFFFFFFF0000FFFF
FFFFFF0000000000
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFFFF0000FFFFFFFF
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFF00FFFFFFFF0000FFFF0000FFFFFFFFFFFF0000FFFF
FFFFFFFFFFFF0000FFFFFFFF0000FFFFFFFF0000FFFFFFFF
FFFF000000FF00FFFFFFFFFFFF00000000000000FFFFFFFF
FFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF000000FFFFFF
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFF0000FFFF0000FFFFFFFF00FF0000FFFF
FFFFFFFFFF000000FF00FFFF0000FFFFFF00000000FFFFFF
00FF0000FFFFFFFFFFFFFFFFFFFF000000000000FF00FF00
FFFFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFF
FFFFFF00FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FF00FFFFFF00FFFF000000FF0000FFFF
0000FFFFFFFF000000FFFFFF0000FFFFFFFFFFFFFFFF0000
FFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFF0000FFFF
0000FF00FFFF0000FFFFFF00000000FFFFFFFFFF00FF0000
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FF00FF0000FFFFFFFF00FFFFFF0000
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
FFFFFFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFFFF00FFFF
FFFF0000FF00FFFF
FFFFFFFFFFFF0000FFFFFFFF000000FFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF0000FF00FFFF
FFFFFF0000FFFFFFFFFFFFFF00FFFFFFFF0000FFFFFFFF00
FFFF0000FFFFFFFF
FFFFFFFF00FF00FFFFFFFFFF00FF000000FF00FF0000FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF
FFFFFFFFFFFFFFFF00000000FFFF0000FF00FF000000FFFF
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFF0000FF
FFFFFF00FFFFFFFF00FF00FFFFFF0000FFFFFFFF0000FFFF
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF000000FF
FFFFFFFFFFFFFFFF0000000000FF0000FFFFFFFF0000FFFF
FF00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FFFFFFFFFF
FFFF00000000FFFFFFFFFFFF000000FF0000FFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF
000000FF00FF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00
FFFF00000000FFFF00FFFFFF0000FFFF0000FFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
0000FFFFFFFF00000000FF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFF00FFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF0000
FFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFF0000FFFF0000FFFF
FFFF00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FF0000FF00FFFFFFFFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFF00FFFF00FF000000FF0000FFFF
FFFFFFFF0000FF0000FFFFFFFFFFFFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFF00
FFFFFFFF0000FFFFFFFFFF00FFFFFFFF00FFFFFF0000FFFF
0000FFFFFFFF0000FF00FFFFFFFFFFFFFFFF000000000000
FFFFFFFF0000000000FFFFFFFFFFFFFFFFFF0000FFFFFFFF
0000FFFFFFFF0000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFF0000FFFFFFFF0000FFFF0000FFFFFFFF
FFFFFFFF00FF00FF
FFFFFFFF0000FFFF00FFFFFFFFFFFF00FFFFFFFF0000FFFF
0000FFFFFFFF0000FFFFFFFFFFFFFFFFFF00000000000000
FFFFFFFF00000000FFFFFFFFFF00FFFFFFFF000000FFFFFF
000000FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF000000FFFFFF000000FF000000FFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFFFFFFFF000000FFFF00000000
00FFFFFFFFFFFFFFFF00FFFFFFFFFFFF0000FFFFFFFF0000
FFFFFFFFFFFF0000FFFF0000FFFFFFFFFFFFFFFF00FFFFFF
00FFFFFFFFFF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFF
0000FFFF0000FFFFFF00FFFFFFFFFFFF0000FFFF0000FFFF
FFFFFFFFFFFF0000
FFFFFF00000000FFFFFFFFFFFFFFFFFF0000FFFF00000000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF000000FFFFFF0000
FFFF00FFFFFF0000FF000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF0000FFFFFFFFFF0000FFFF00000000FF0000FFFF
FFFFFFFFFFFF0000
0000FFFFFFFF00FFFFFFFFFF0000FF00FFFFFF000000FFFF
0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF0000FFFF00FF000000FFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFF0000FF00FFFFFFFFFFFFFFFF00FFFFFF
FFFFFF00FFFF0000
0000FFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFF0000FFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000FFFFFF0000FFFFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00FF00000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFF0000FFFFFFFF0000FFFF00FF000000FFFFFFFF00FF00
00000000FFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFF0000
FFFFFFFF00000000FF00FFFFFFFF0000FF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFF00FFFF0000FFFF00FFFF00FFFF00000000
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00000000FF
FFFF0000FFFF00FF0000FFFFFFFF0000FFFFFFFFFFFFFFFF
00000000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF00FF00000000FFFFFFFF00FF0000FFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFF00FFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FF00FFFF00000000FFFFFFFFFFFFFFFF0000FFFFFF000000
FF0000FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF0000
00FFFF00FFFFFF00FFFFFFFF00000000FFFF0000FFFFFFFF
FFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
FFFFFF0000000000FFFFFFFFFFFFFFFF0000FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFF00FFFFFFFF0000FF00000000FF000000FFFFFFFF
FF00FFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF0000FFFF
FF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFF0000000000FFFF
FFFF00FFFF00FFFFFF0000FFFFFF00FFFFFFFFFFFFFF0000
FFFFFFFF00000000
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF0000FF00
FFFF000000FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FF
FFFFFFFFFF00FFFFFFFF00FF0000FFFFFFFF00000000FFFF
FFFFFFFFFFFF00FFFFFFFFFFFF00FFFF00FF00FFFFFF0000
FF00FFFF00000000
FFFFFFFFFFFFFF0000000000FF00FFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FF00FFFF000000000000FFFF00FFFFFFFFFF0000FFFFFFFF
FFFF0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FFFF
FFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000FFFFFF000000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000FF
FFFFFF00000000000000FFFFFFFFFFFFFFFF000000FFFFFF
FFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF000000FF
FF000000FFFFFFFFFFFF00FFFFFF00FFFFFF00FF00FFFFFF
0000FFFFFFFFFF00
00000000FFFF00000000FFFFFFFF00000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00
0000FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFF00FFFFFFFF0000FF00FF00FFFF
00FFFFFFFF000000FFFF0000FFFF00FFFFFF0000FFFFFFFF
00FFFF00FFFF0000
0000000000FF00000000FFFF00FF00000000FFFFFFFFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
FFFFFFFFFFFFFF00FF00FFFF00FFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF0000FFFF000000FFFFFFFFFF0000FF0000FF
FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF0000FFFF
0000FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
FFFF0000FF00FF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
0000FFFF0000FFFF0000FF0000000000FFFF00000000FFFF
0000FF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF0000FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00
FFFF0000FFFFFFFFFFFF00FFFF00FFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF00
0000FFFF000000FF0000FFFF0000000000FF00000000FF00
0000FFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
00000000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFFFFFFFFFF0000FFFFFFFFFF00FF00FFFF
00000000FF00FFFFFFFFFFFF0000FFFFFF000000FFFFFFFF
FFFFFFFFFFFFFFFF0000FFFFFF000000FF0000000000FFFF
0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00000000
00000000FFFFFF00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFF00FF
00000000FFFFFFFFFF00FFFF0000FFFFFFFF0000FFFFFF00
FFFFFFFFFFFFFFFF0000FFFFFFFF0000FFFF00000000FFFF
0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
FFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFF0000FFFF00000000FF000000FFFF
FF00FFFF0000FFFF00000000FFFFFFFFFFFF00000000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFFFFFF0000FFFFFFFFFF00FFFF00FFFF00FFFF00FFFF00
FFFFFFFFFFFFFFFFFFFF000000FF00000000FFFF0000FF00
FFFFFF000000FFFF00000000FFFFFFFFFFFF00000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFF0000FFFFFFFFFFFF00000000
FFFFFFFFFFFFFFFF00FF00000000FF00FF00FFFF00000000
0000FFFF00FF000000000000FFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FF00FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFF00FFFFFFFFFF000000FFFFFFFFFF00000000
FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF0000000000
0000FFFFFFFF000000000000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF000000FF0000FFFF00FFFFFF
000000FF0000FFFFFFFF0000FFFFFFFFFFFFFFFF00000000
00FFFFFFFFFF0000FFFFFF00FFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFF000000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF0000FFFF0000FFFFFFFFFF00
0000FFFF0000FFFFFF000000FFFFFFFFFFFFFFFF00000000
FFFFFF00FFFF0000FFFFFFFF00FF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFF00
FFFFFFFF0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFF0000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF
00FFFFFF0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF0000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF000000FF00FF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFF0000FFFFFF000000FFFFFFFFFFFF00FF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
FFFFFFFFFF00FFFF0000FFFFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000FFFF00FFFFFFFFFF0000FFFFFFFFFF00FFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF000000FFFFFFFFFFFFFF000000FFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFF0000FFFFFF000000FFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FFFFFFFF000000FF0000FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFF0000FFFFFFFF0000FF00FFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FF00FFFFFFFF0000FFFFFFFFFFFF00000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFF0000FFFF00FF00FF0000FFFFFFFFFFFF00000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
0000FFFFFF0000000000FF00FFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
0000FFFFFFFF00000000FFFFFF00FFFFFF00FF00FFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF0000000000000000FFFF0000FFFFFFFF00000000
FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF0000000000000000FF000000FFFFFF0000000000
00FF0000FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00
00000000FF00FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF
FF0000FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
FFFFFF00FF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFF0000FFFFFFFF00FFFFFF00
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFF
FF00FF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00
0000000000FF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF0000
0000FF0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
00FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FF0000FFFF
00FFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF0000FFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000FFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00
0000FF000000FFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFF000000FFFF0000FFFFFFFF000000FFFFFF
FFFFFF000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF000000FFFFFF0000FF000000FFFFFF000000FFFFFFFF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
00FFFF00FFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFF00FF00FFFFFFFFFFFF00FFFFFFFFFFFF
FFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF000000FFFF000000
FFFF00000000FFFFFFFFFFFFFFFFFFFF00FFFF00FFFF0000
FFFF0000FFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFF00FF0000FFFFFFFF0000
00FF00000000FFFF00FFFFFF00FF00FFFFFFFFFFFFFF0000
FFFF0000FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFF00FF
FF00FF00FFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF0000
FFFFFF0000000000FFFFFF00FFFF0000FFFFFFFFFFFF00FF
FFFF0000FF00FFFF0000FFFF00000000FFFFFFFFFFFF0000
00FFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF0000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFF00000000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFF0000FF0000000000FFFFFFFFFF000000
FFFF00FFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
00FF0000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFF00FFFFFF000000FFFF00FFFF0000000000
FFFF00000000FF00000000FF0000FF00FFFFFF00FFFFFFFF
0000FFFFFF000000FFFF0000FFFFFFFF00FFFFFF0000FFFF
FFFFFFFF0000FFFF0000FFFF00FFFFFFFFFFFFFF0000FFFF
0000FFFF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFF0000FF00FFFFFFFF00000000
FF0000000000FFFF0000FFFF0000FFFFFF00FFFFFF00FF00
0000FFFFFFFF000000FF0000FF00FF00FFFFFFFF0000FFFF
00FF00FF0000FFFF0000FF00FFFFFF0000FFFFFF0000FF00
0000FF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFF00FFFFFFFFFFFF00FF0000
FFFF000000FFFFFFFF000000000000FF00FFFFFFFFFFFFFF
FF00FF00FFFF0000000000000000FFFF0000FFFFFF000000
00000000FF0000FFFFFF00FF00000000FFFF000000000000
00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FFFF0000FFFFFFFFFFFF00000000FFFFFFFFFF00FFFF00FF
FFFFFFFF00FF000000000000000000FF000000FFFFFF0000
00000000FFFFFFFF00FFFFFF00000000FFFF000000000000
FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFF0000FFFFFFFFFFFFFF
00FF00000000FFFFFFFF00FF0000FF0000FF00FF00FFFF00
FFFFFFFF0000000000FFFFFFFFFF0000FFFF00FFFFFFFFFF
00FFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFF0000FFFFFFFFFFFF00FFFFFFFF00
FFFF00000000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFFFFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`0Doooo1`0002Goool400002?ooo`@0000=oooo2P00
00coool400002oooo`@00004oooo0P0000;oool200002_ooo`@0000?oooo0P00043oool400000_oo
o`H00005oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`0D
oooo1`0002Goool400002?ooo`@0000=oooo2P0000coool400002oooo`@00004oooo0P0000;oool2
00002_ooo`@0000?oooo0P00043oool400000_ooo`H00005oooo00<0003oooooool00_ooo`004_oo
o`030000oooooooo00?oool00`000?ooooooo`0Eoooo100002Ooool400001_ooo`P00004oooo1000
00Goool800001_ooo`800002oooo1P0000Koool200000oooo`H0000@oooo1P0000Ooool200001?oo
o`800006oooo100000Coool20000<_ooo`@00004oooo100000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool05Oooo`@0000Woooo100000Koool800001?ooo`@00005oooo200000Koool2
00000_ooo`H00006oooo0P0000?oool600004?ooo`H00007oooo0P0000Coool200001_ooo`@00004
oooo0P0003;oool400001?ooo`@00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
03Goool200002Oooo`800006oooo200000Coool400002oooo`@00004oooo0P0000;oool400001?oo
o`@0000Aoooo2P0000Soool4000000?oool0000000002P0000Koool600007Oooo`@00004oooo2000
01Soool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0=Oooo`800009oooo0P0000Koool8
00001?ooo`@0000;oooo100000Coool200000_ooo`@00004oooo1000017oool:00002?ooo`@00000
0oooo`000000000:00001_ooo`H0000Moooo100000Coool800006?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`0hoooo0P0000koool800000_ooo`H0000;oooo1P0000Koool400000_oo
o`H00002oooo0P0000?oool200002_ooo`P00002oooo0P0000;oool600000oooo`P00008oooo1000
01Ooool200000_ooo`800002oooo1P0000;oool900005oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`0hoooo0P0000koool800000_ooo`H0000;oooo1P0000Koool400000_ooo`H00002
oooo0P0000?oool200002_ooo`P00002oooo0P0000;oool600000oooo`P00008oooo100001Ooool2
00000_ooo`800002oooo1P0000;oool900005oooo`030000oooooooo00;oool001Soool200000ooo
o`@0000>oooo1@0000Coool400006oooo``0000<oooo100000Woool600001?ooo`800002oooo0P00
00Coool200000_ooo`800002oooo0P0000?oool400002?ooo`P00004oooo100000Coool00`000?oo
ooooo`0[oooo1000013oool400000oooo`@00004oooo100000Soool200001?ooo`006?ooo`030000
oooooooo00;oool400003_ooo`D00004oooo100001_oool<00003?ooo`@00009oooo1P0000Coool2
00000_ooo`800004oooo0P0000;oool200000_ooo`800003oooo100000Soool800001?ooo`@00004
oooo00<0003oooooool0:oooo`@0000@oooo100000?oool400001?ooo`@00009oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool400003oooo`@00004oooo100001Woool>00003?oo
o`@0000;oooo1P0001Ooool600002?ooo`X00002oooo1P0001_oool200004oooo`@0000@oooo1000
00?oool400001?ooo`@00009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool4
00003oooo`@00004oooo100001Woool>00003?ooo`@0000;oooo1P0001Ooool600002?ooo`X00002
oooo1P0001_oool200004oooo`@0000@oooo100000?oool400001?ooo`@00009oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool@00009_ooo`@00002oooo1P0000coool80000>_oo
o`80000<oooo1@0000coool<00000_ooo`80000Ioooo0P0000Soool400001oooo`@00004oooo0P00
00Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oooa00000Voooo100000;oool6
00003?ooo`P0000joooo0P0000coool500003?ooo``00002oooo0P0001Woool200002?ooo`@00007
oooo100000Coool200001oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo4P00
01_oool200000_ooo`800003oooo100000Coool400001?ooo`800004oooo30000003oooo00000000
04Goool300000_ooo`@00002oooo0P0000;oool<00001?ooo`80000Ioooo0P0000;oool200000_oo
o`@00005oooo1P0000goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oooa80000K
oooo0P0000;oool200000oooo`@00004oooo100000Coool200001?ooo``000000oooo`0000000015
oooo0`0000;oool400000_ooo`800002oooo300000Coool200006Oooo`800002oooo0P0000;oool4
00001Oooo`H0000=oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo02goool800000_oo
o`030000oooooooo00Soool200005oooo`@0000Doooo100002coool200005?ooo`H00007oooo0P00
01Koool200000_ooo`@00005oooo0P0000Soool200002Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`0]oooo200002Koool400003?ooo`800006oooo1P0002?oool200000_ooo`80000G
oooo100001Ooool20000:_ooo`030000oooooooo00;oool001Soool20000;_ooo`P0000Voooo1000
00coool200001_ooo`H0000Soooo0P0000;oool200005oooo`@0000Goooo0P0002Woool200001?oo
o`006?ooo`030000oooooooo01Goool400003?ooo`P00008oooo0`00013oool200004Oooo`@00008
oooo0P0000;oool400002?ooo`@0000Soooo2`0000coool200000_ooo`P00004oooo00<0003ooooo
ool00_ooo`H00008oooo100000Coool200000_ooo`@0000;oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool05Oooo`@0000<oooo200000Soool300004?ooo`80000Aoooo1000
00Soool200000_ooo`@00008oooo100002?oool;00003?ooo`800002oooo200000Coool00`000?oo
ooooo`02oooo1P0000Soool400001?ooo`800002oooo100000_oool800001Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`0Eoooo100000Koool200001?ooo`P00006oooo1@0000;oool2
00001_ooo`@0000Eoooo100000Koool200001?ooo`H00006oooo100000Ooool200000_ooo`80000F
oooo2`0000[oool200001?ooo`P0000;oooo1P0000Koool400002?ooo`@00009oooo2P0000Goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool05Oooo`@00006oooo0P0000Coool800001_oo
o`D00002oooo0P0000Koool400005Oooo`@00006oooo0P0000Coool600001_ooo`@00007oooo0P00
00;oool200005_ooo`/0000:oooo0P0000Coool800002oooo`H00006oooo100000Soool400002Ooo
o`X00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo01;oool200001Oooo`@00008
oooo100000Soool;00007oooo`@00006oooo0P0000Soool400001?ooo`@0000;oooo1000013oool4
00001oooo`@00008oooo100000coool500000_ooo`80000<oooo3P0000ooool400002Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0Boooo0P0000Goool400002?ooo`@00008oooo2`00
01ooool400001_ooo`800008oooo100000Coool400002oooo`@0000@oooo100000Ooool400002?oo
o`@0000<oooo1@0000;oool200003?ooo`h0000?oooo100000Woool00`000?ooooooo`02oooo000H
oooo00<0003oooooool06Oooo`@00008oooo1P0000Koool;00007oooo`@0000@oooo100000Coool4
00001oooo`800002oooo100000koool600000_ooo`800003oooo100000Koool800001_ooo`800002
oooo100001?oool<00000_ooo`8000000oooo`0000000008oooo1P0000Ooool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool06Oooo`@00008oooo1P0000Koool;00007oooo`@0000@oooo1000
00Coool400001oooo`800002oooo100000koool600000_ooo`800003oooo100000Koool800001_oo
o`800002oooo100001?oool<00000_ooo`8000000oooo`0000000008oooo1P0000Ooool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool05Oooo`@0000@oooo100000[oool00`000?ooooooo`0:
oooo100001?oool400004_ooo`80000:oooo0P0001_oool400000_ooo`800005oooo0P0000Coool6
00000_ooo`@00004oooo100000Ooool600001_ooo`@0000@oooo0`0000Soool200002oooo`030000
oooooooo00;oool001Soool200005_ooo`@0000@oooo100000[oool00`000?ooooooo`0:oooo1000
01?oool400004_ooo`80000:oooo0P0001_oool400000_ooo`800005oooo0P0000Coool600000_oo
o`@00004oooo100000Ooool600001_ooo`@0000@oooo0`0000Soool200002_ooo`800004oooo000H
oooo00<0003oooooool02_ooo`800009oooo1000013oool400005oooo`@0000Coooo100002Ooool2
00004_ooo`@0000?oooo100000Coool400001?ooo`@00002oooo0P0000?oool400001_ooo`P0000:
oooo0P0000;oool300005Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`0:oooo0P00
00Woool400004?ooo`@0000Goooo100001?oool400009oooo`80000Boooo100000ooool400001?oo
o`@00004oooo100000;oool200000oooo`@00006oooo200000[oool200000_ooo`<0000Eoooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00[oool200000_ooo`H000000oooo`0000000002
oooo100000Soool200001_ooo`@00002oooo100002Coool20000E?ooo`@0000Coooo0P0000Coool2
00002?ooo`80000<oooo0P0000Ooool400000_ooo`800009oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00[oool200000_ooo`H000000oooo`0000000002oooo100000Soool200001_oo
o`@00002oooo100002Coool20000E?ooo`@0000Coooo0P0000Coool200002?ooo`80000<oooo0P00
00Ooool400000_ooo`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00koool4
00001oooo`H0000>oooo100001?oool20000=Oooo`80000Soooo0P0000ooool400000_ooo`80000:
oooo0`0000koool200002?ooo`@00007oooo0P0000Coool400003Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`0>oooo100000Ooool600003_ooo`@0000Coooo0P0003Goool200008ooo
o`80000?oooo100000;oool200002_ooo`<0000>oooo0P0000Soool400001oooo`800004oooo1000
00goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool02_ooo`800002oooo0P0000Woool2
00000_ooo`H00002oooo0P0000;oool400001?ooo`@0000Voooo100001coool700001?ooo`@0000D
oooo1`0000Coool400000_ooo`800002oooo1P0001?oool200006oooo`80000:oooo100000Ooool0
0`000?ooooooo`02oooo000<oooo0`0000?oool00`000?ooooooo`03oooo00<0003oooooool02_oo
o`800002oooo0P0000Woool200000_ooo`H00002oooo0P0000;oool400001?ooo`@0000Voooo1000
01coool700001?ooo`@0000Doooo1`0000Coool400000_ooo`800002oooo1P0001?oool200006ooo
o`80000:oooo100000Ooool00`000?ooooooo`02oooo000<oooo00<0003oooooool00_ooo`030000
oooo000000Coool00`000?ooooooo`08oooo0P0000Soool2000000?oool0000000001_ooo`@00008
oooo100000Coool600009?ooo`@0000Loooo1`0000Coool600004_ooo`T00002oooo100000Soool4
00001_ooo`800002oooo0`0001coool200002Oooo`@0000?oooo00<0003oooooool00_ooo`003Ooo
o`070000oooooooooooo0000oooo000000Coool300002?ooo`800008oooo0P000003oooo00000000
00Koool400002?ooo`@00004oooo1P0002Coool400007?ooo`L00004oooo1P0001;oool900000_oo
o`@00008oooo100000Koool200000_ooo`<0000Loooo0P0000Woool400003Oooo`<00004oooo000=
oooo00L0003oooooooooool0003oool000001?ooo`030000oooooooo00Koool800002oooo`H00002
oooo100000coool400003Oooo`80000Doooo1`0001coool200000_ooo`<00008oooo100001Coool0
0`000?ooooooo`0@oooo100000Coool600000_ooo`030000oooooooo00P0000Yoooo0P0000Goool0
0`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?oo
ooooo`06oooo200000_oool600000_ooo`@0000<oooo100000goool200005?ooo`L0000Loooo0P00
00;oool300002?ooo`@0000Doooo00<0003oooooool04?ooo`@00004oooo1P0000;oool00`000?oo
ooooo`080000:Oooo`800005oooo00<0003oooooool00_ooo`003Oooo`030000oooooooo00;oool0
0`000?ooooooo`03oooo00<0003oooooool01_ooo`P00004oooo0P0000Goool400001?ooo`@0000<
oooo100002?oool700005_ooo`800002oooo0P0000Coool300002?ooo`@0000Woooo100000Coool4
00001oooo`P00002oooo0P0001Goool400004oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`06oooo200000Coool200001Oooo`@00004oooo100000coool400008oooo`L0000Foooo0P00
00;oool200001?ooo`<00008oooo100002Ooool400001?ooo`@00007oooo200000;oool200005Ooo
o`@0000Coooo00<0003oooooool00_ooo`006?ooo`030000oooooooo01Goool400001?ooo`80000:
oooo0P0000Koool400007oooo`800005oooo100000Coool600006oooo`800006oooo0P0000coool4
00003oooo`@00004oooo100000Soool200000_ooo`<0000Poooo0`0001Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool05Oooo`@00004oooo0P0000[oool200001_ooo`@0000Ooooo0P00
00Goool400001?ooo`H0000Koooo0P0000Koool200003?ooo`@0000?oooo100000Coool400002?oo
o`800002oooo0`00023oool300005Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`0@
oooo10000003oooo0000000000800002oooo0P0000[oool200001_ooo`H0000Voooo100000Coool4
00002?ooo`80000Yoooo100000Goool200001?ooo`800002oooo1P0000;oool400003?ooo`<00002
oooo1000013oool200002?ooo`<0000>oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool04?ooo`@000000oooo`000000000200000_ooo`80000:oooo0P0000Koool600009_oo
o`@00004oooo100000Soool20000:Oooo`@00005oooo0P0000Coool200000_ooo`H00002oooo1000
00coool300000_ooo`@0000@oooo0P0000Soool300003_ooo`800005oooo00<0003oooooool00_oo
o`006?ooo`80000;oooo100000Woool200002?ooo`800006oooo100000Coool400001oooo`@00002
oooo0P00013oool;00002?ooo`X0000Aoooo100000Soool400002?ooo`T0000Noooo1`0000Coool4
00002?ooo`@00004oooo100000ooool200000_ooo`800006oooo0P0000Coool001Soool00`000?oo
ooooo`0:oooo100000Coool200002oooo`800008oooo100000Coool400001oooo`@0000Boooo3@00
00Soool800002_ooo`800007oooo1P0000Koool600001_ooo`P0000Ooooo2@0000;oool600001_oo
o`H00002oooo1P0001[oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool02_ooo`@00004
oooo0P0000_oool200002?ooo`@00004oooo100000Ooool400004_ooo`d00008oooo200000[oool2
00001oooo`H00006oooo1P0000Koool800007oooo`T00002oooo1P0000Koool600000_ooo`H0000J
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00[oool400001?ooo`80000;oooo1P00
00Coool:00003oooo`80000<oooo100000Ooool400003?ooo`@00004oooo100000ooool200001_oo
o`80000:oooo0P0000Ooool200001?ooo`800008oooo0P0000Soool400001?ooo`<00006oooo0P00
00coool400001?ooo`@0000?oooo100000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool02_ooo`@00004oooo0P0000_oool600001?ooo`X0000?oooo0P0000coool400001oooo`@0000<
oooo100000Coool400003oooo`800006oooo0P0000[oool200001oooo`800004oooo0P0000Soool2
00002?ooo`@00004oooo0`0000Koool200003?ooo`@00004oooo100000ooool400001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`08oooo2000017oool400001?ooo`P0000=oooo0P00
013oool600001Oooo`@00004oooo0P0000Koool400000_ooo`H0000Qoooo0P0002?oool400001?oo
o`<0000:oooo100000Coool800000_ooo`@0000?oooo100000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool02?ooo`P0000Aoooo100000Coool800003Oooo`80000@oooo1P0000Goool4
00001?ooo`800006oooo100000;oool600008Oooo`80000Soooo100000Coool300002_ooo`@00004
oooo200000;oool400003oooo`@00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool400002?ooo`800009oooo100000;oool200001_ooo`H00004oooo100000Woool200005?oo
o`800007oooo0P0000Coool400001?ooo`800002oooo1P0001?oool200004?ooo`@00009oooo0P00
01Coool400002oooo`@00002oooo0P00013oool200002oooo`800004oooo100000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`@00008oooo0P0000Woool400000_ooo`800006
oooo1P0000Coool400002Oooo`80000Doooo0P0000Ooool200001?ooo`@00004oooo0P0000;oool6
00004oooo`80000@oooo100000Woool200005?ooo`@0000;oooo100000;oool200004?ooo`80000;
oooo0P0000Coool400001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo1000
00ooool200000_ooo`@00006oooo0P0000Coool400001?ooo`@0000=oooo0P0001ooool600001_oo
o`@0000<oooo00<0003oooooool02?ooo`80000>oooo100001ooool400001?ooo`030000oooooooo
00Coool400002_ooo`80000Koooo100000Goool00`000?ooooooo`02oooo000Hoooo0P0000?oool4
00003oooo`800002oooo100000Koool200001?ooo`@00004oooo100000goool200007oooo`H00006
oooo100000coool00`000?ooooooo`08oooo0P0000koool400007oooo`@00004oooo00<0003ooooo
ool01?ooo`@0000:oooo0P0001_oool400001?ooo`800004oooo000Hoooo00<0003oooooool05Ooo
o`@0000<oooo0P0000;oool<00008oooo`<00008oooo100000Soool400001?ooo`800002oooo1@00
00Soool200000_ooo`X00004oooo100000Ooool200004_ooo`@00008oooo1`0000;oool200002?oo
o`@00002oooo0P00023oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool05Oooo`@0000<
oooo0P0000;oool<00008oooo`<00008oooo100000Soool400001?ooo`800002oooo1@0000Soool2
00000_ooo`X00004oooo100000Ooool200004_ooo`@00008oooo1`0000;oool200002?ooo`@00002
oooo0P00023oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_ooo`800008oooo0P00
00?oool400001?ooo`800004oooo0P0000Coool<00003Oooo`80000Boooo1`0000Koool400001?oo
o`800002oooo100000Soool400003oooo`P00004oooo100001_oool400001?ooo`800002oooo1`00
00Soool200000_ooo`@00006oooo0P0001coool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool01_ooo`800008oooo0P0000?oool400001?ooo`800004oooo0P0000Coool<00003Oooo`80000B
oooo1`0000Koool400001?ooo`800002oooo100000Soool400003oooo`P00004oooo100001_oool4
00001?ooo`800002oooo1`0000Soool200000_ooo`@00006oooo0P0001coool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool02_ooo`800004oooo0P0000goool40000>?ooo`@00002oooo0P00
00Coool800004?ooo`<00006oooo1P0000;oool400003?ooo`80000Aoooo0P0000Coool600001?oo
o`800005oooo0P0000Soool800001?ooo`@0000=oooo0P0000goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool02_ooo`800004oooo0P0000goool40000>?ooo`@00002oooo0P0000Coool8
00004?ooo`<00006oooo1P0000;oool400003?ooo`80000Aoooo0P0000Coool600001?ooo`800005
oooo0P0000Soool800001?ooo`@0000=oooo0P0000goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool04_ooo`80000Goooo0P0002_oool2000000?oool0000000000P0000Koool:00004?oo
o`<00008oooo100002_oool400002?ooo`030000oooooooo00Koool400000_ooo`P00002oooo1P00
00Woool200001?ooo`80000;oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo01;oool2
00005oooo`80000[oooo0P000003oooo0000000000800006oooo2P00013oool300002?ooo`@0000[
oooo100000Soool00`000?ooooooo`06oooo100000;oool800000_ooo`H00009oooo0P0000Coool2
00002oooo`030000oooooooo00;oool001Soool00`000?ooooooo`0Qoooo100001_oool400005?oo
o`<00006oooo1P0001goool200003?ooo`80000Aoooo100000Koool:00002?ooo`800003oooo0P00
00Koool400001_ooo`80000>oooo0`0000Soool800001Oooo`030000oooooooo00;oool001Soool2
00008_ooo`@0000Koooo100001Coool300001_ooo`H0000Moooo0P0000coool200004Oooo`@00006
oooo2P0000Soool200000oooo`800006oooo100000Koool200003_ooo`<00008oooo200000Coool2
00001?ooo`006?ooo`030000oooooooo01Goool200002_ooo`@00002oooo0P0001Ooool400005?oo
o`<00002oooo0P0000Coool600004_ooo`80000=oooo0P0000coool200002?ooo`030000oooooooo
00@00008oooo200000ooool200003?ooo`800004oooo0P0000;oool200001_ooo`<00002oooo0P00
00Coool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`0Eoooo0P0000[oool4
00000_ooo`80000Goooo100001Coool300000_ooo`800004oooo1P0001;oool200003Oooo`80000<
oooo0P0000Soool00`000?ooooooo`0400002?ooo`P0000?oooo0P0000coool200001?ooo`800002
oooo0P0000Koool300000_ooo`800004oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool04?ooo`T00002oooo0P0000Coool40000<oooo`<00006oooo0P0000Coool<00001?oo
o`800009oooo100000coool400003oooo`80000>oooo100000Soool400002Oooo`80000Koooo1000
017oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool04?ooo`T00002oooo0P0000Coool4
0000<oooo`<00006oooo0P0000Coool<00001?ooo`800009oooo100000coool400003oooo`80000>
oooo100000Soool400002Oooo`80000Koooo1000017oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool04_ooo`L00006oooo1P0000;oool20000:Oooo`@00002oooo1@0000Soool>00003ooo
o`H0000:oooo100000Coool200006Oooo`H00004oooo1P0000_oool200001_ooo`800006oooo0P00
00;oool200001Oooo`@0000:oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool04_ooo`L00006oooo1P0000;oool20000:Oooo`@00002oooo1@0000Soool>00003oooo`H0000:
oooo100000Coool200006Oooo`H00004oooo1P0000_oool200001_ooo`800006oooo0P0000;oool2
00001Oooo`@0000:oooo0P0000Goool00`000?ooooooo`02oooo000=oooo0`0000;oool00`000?oo
ooooo`03oooo00<0003oooooool00_ooo`P00004oooo1`0000Soool80000;oooo`@00005oooo1P00
00Koool200001_ooo`80000Uoooo0P0000Woool200002?ooo`@00002oooo0P0000;oool200001?oo
o`800007oooo1P0000Coool400001?ooo`800006oooo100000Ooool200001?ooo`800004oooo1000
00Goool00`000?ooooooo`02oooo000>oooo00H0003oooooool0003oool00004oooo00<0003ooooo
ool00_ooo`P00004oooo1`0000Soool80000;oooo`@00005oooo1P0000Koool200001_ooo`80000U
oooo0P0000Woool200002?ooo`@00002oooo0P0000;oool200001?ooo`800007oooo1P0000Coool4
00001?ooo`800006oooo100000Ooool200001?ooo`800004oooo100000Goool00`000?ooooooo`02
oooo000<oooo10000004oooo0000oooo00001?ooo`<00002oooo2P0000;oool700001?ooo`800002
oooo200000coool200001Oooo`80000Joooo100000Ooool400002_ooo`80000Goooo0P0000;oool2
00004?ooo`800002oooo0P0000?oool200001_ooo`@0000Goooo100000Coool600002_ooo`@00002
oooo0`0000koool400000oooo`<00004oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`02oooo2P0000;oool700001?ooo`800002oooo200000coool200001Ooo
o`80000Joooo100000Ooool400002_ooo`80000Goooo0P0000;oool200004?ooo`800002oooo0P00
00?oool200001_ooo`@0000Goooo100000Coool600002_ooo`@00002oooo0`0000koool400001Ooo
o`030000oooooooo00;oool000goool200000_ooo`030000oooo000000Coool00`000?ooooooo`0S
oooo0P0000Coool400001?ooo`@00005oooo0P0001Soool400002oooo`@00002oooo0P0000;oool2
00004?ooo`030000oooooooo02ooool400002?ooo`@00004oooo0`0000Coool400000_ooo`X00004
oooo200000?oool400000_ooo`H00009oooo00<0003oooooool00_ooo`003_ooo`050000oooooooo
oooo000000Goool00`000?ooooooo`0Moooo0P0000[oool400001?ooo`@0000Ooooo100000Goool2
00001?ooo`@0000<oooo0P0000Coool200002Oooo`80000Yoooo1P0000Koool600001?ooo`D00002
oooo100000Coool:00000_ooo`P000000oooo`000000000400001?ooo`@00009oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo01goool200002_ooo`@00004oooo100001ooool400001Ooo
o`800004oooo100000coool200001?ooo`800009oooo0P0002Woool600001_ooo`H00004oooo1@00
00;oool400001?ooo`X00002oooo20000003oooo0000000000@00004oooo100000Woool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0:Oooo`l0000<oooo100001ooool400003?ooo`@00009
oooo0P0000;oool200001?ooo`P00002oooo0P0000_oool400001_ooo`H0000Goooo100000Koool6
00000_ooo`X00003oooo1000017oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0:Ooo
o`l0000<oooo100001ooool400003?ooo`@00009oooo0P0000;oool200001?ooo`P00002oooo0P00
00_oool400001_ooo`H0000Goooo100000Koool600000_ooo`X00003oooo1000017oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool08Oooo`800002oooo0P0000;oool?00001_ooo`800004
oooo100001goool600003?ooo`@0000?oooo0P0000;oool800002_ooo`800003oooo100000Soool4
00001_ooo`80000?oooo100000Soool400001?ooo`P00003oooo1000017oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool08Oooo`800002oooo0P0000;oool?00001_ooo`800004oooo1000
01goool600003?ooo`@0000?oooo0P0000;oool800002_ooo`800003oooo100000Soool400001_oo
o`80000?oooo100000Soool400001?ooo`P00003oooo1000017oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool06Oooo`80000:oooo300000Ooool600006?ooo`80000;oooo0P0000koool4
00001?ooo`L00002oooo1P0000Koool200001?ooo`@00004oooo1`0000coool800000_ooo`80000S
oooo0P0000Woool400004Oooo`030000oooooooo00;oool001Soool200006_ooo`80000:oooo3000
00Ooool600006?ooo`80000;oooo0P0000koool400001?ooo`L00002oooo1P0000Koool200001?oo
o`@00004oooo1`0000coool800000_ooo`80000Soooo0P0000Woool400004?ooo`800004oooo000H
oooo00<0003oooooool09Oooo``00007oooo100000[oool200001?ooo`800004oooo0P0000Coool2
00000oooo`80000Doooo1P0000;oool700001?ooo`@00002oooo0P0000Koool600001?ooo`L0000<
oooo200000Coool20000;?ooo`@0000Aoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
02Goool<00001oooo`@0000:oooo0P0000Coool200001?ooo`800004oooo0P0000?oool200005?oo
o`H00002oooo1`0000Coool400000_ooo`800006oooo1P0000Coool700003?ooo`P00004oooo0P00
02coool400004Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`0aoooo100000goool2
00001?ooo`@0000<oooo1`00013oool200000_ooo`P00002oooo0P000003oooo0000000000Coool<
00001?ooo`800002oooo2`0000coool20000<Oooo`@00005oooo0P0000;oool200003Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0aoooo100000goool200001?ooo`@0000<oooo1`00
013oool200000_ooo`P00002oooo0P000003oooo0000000000Coool<00001?ooo`800002oooo2`00
00coool20000<Oooo`@00005oooo0P0000;oool200003Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`0aoooo100000Ooool200002_ooo`H0000:oooo1`0001Coool800002Oooo`h00008
oooo2`0000[oool20000<oooo`@0000=oooo0P0000Woool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0<Oooo`@00007oooo0P0000[oool600002_ooo`L0000Doooo200000Woool>00002?oo
o`/0000:oooo0P0003?oool400003Oooo`800009oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00Koool20000>?ooo`@00004oooo1P0000;oool400001?ooo`800005oooo1P0000;oool4
00002?ooo`@0000?oooo2P0000[oool400001Oooo`800004oooo100003koool200001?ooo`H00002
oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_ooo`80000hoooo1000
00Coool600000_ooo`@00004oooo0P0000Goool600000_ooo`@00008oooo100000ooool:00002_oo
o`@00005oooo0P0000Coool40000?_ooo`800004oooo1P0000;oool200001Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`10oooo100000Coool400001?ooo`@00009oooo1P0000Coool4
00001_ooo`H0000?oooo200000Koool200001?ooo`@00007oooo0P0000;oool40000A_ooo`@00009
oooo00<0003oooooool00_ooo`006?ooo`800011oooo100000Coool400001?ooo`@00009oooo1P00
00Coool400001_ooo`H0000?oooo200000Koool200001?ooo`@00007oooo0P0000;oool40000A_oo
o`@00008oooo0P0000Coool001Soool00`000?ooooooo`1@oooo200000Goool200002?ooo`@00004
oooo0P0001Woool200001_ooo`@00004oooo2`0004?oool300003_ooo`800005oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo053oool800001Oooo`800008oooo100000Coool200006Ooo
o`800006oooo100000Coool;0000@oooo`<0000>oooo0P0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0D?ooo`X00005oooo0P0000Koool400000_ooo`80000Ooooo0P0000;oool4
00001?ooo`/00011oooo1@0000[oool200002Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1@oooo2P0000Goool200001_ooo`@00002oooo0P0001ooool200000_ooo`@00004oooo2`00
047oool500002_ooo`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Coool2
00002Oooo`@00008oooo0P00027oool200000_ooo`800006oooo200004ooool600002Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`1Doooo0P0000Woool400002?ooo`80000Qoooo0P00
00;oool200001_ooo`P0001?oooo1P0000Woool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0F?ooo`800003oooo1P0003Ooool80000DOooo`@00009oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo05Soool200000oooo`H0000goooo2000057oool400002Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Moooo2P0003Ooool20000H?ooo`030000oooooooo00;oool0
01Soool20000G_ooo`X0000goooo0P0005ooool200001?ooo`006?ooo`030000oooooooo05ooool8
0000VOooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo200009Woool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0Goooo`@00002oooo0P0009Woool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0Goooo`@0000eoooo0P0006Koool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0Goooo`@0000eoooo0P0006Koool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0GOooo`@00002oooo0P00037oool20000J?ooo`030000oooooooo00;oool000coool2
00001?ooo`030000oooooooo00?oool00`000?ooooooo`1Moooo100000;oool20000<Oooo`80001X
oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000
oooo000000Coool30000o_ooo`<00004oooo000<oooo0P0000?oool00`000?ooo`000004oooo00<0
003oooooool0HOooo`80002Moooo00<0003oooooool00_ooo`003?ooo`030000oooooooo00;oool0
0`000?ooo`000004oooo00<0003oooooool0HOooo`80002Moooo00<0003oooooool00_ooo`003Ooo
o`800003oooo00<0003oooooool00oooo`030000oooooooo06?oool20000:oooo`80001^oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo06?oool20000:oooo`80001^oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo06?oool200002_ooo`@0002=oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo06?oool200002_ooo`@0002=oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo067oool200003?ooo`H0000Moooo0P0006coool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0HOooo`80000<oooo1P0001goool20000K?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1Ooooo0P0000koool40000SOooo`030000oooooooo00;oool001Soool2
0000H?ooo`80000>oooo100008coool200001?ooo`006?ooo`030000oooooooo06ooool600000_oo
o`800002oooo0P0008?oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0Koooo`H00002
oooo0P0000;oool20000Poooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Koooo1000
013oool400001_ooo`H0000;oooo0P0000[oool40000I_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`1Koooo1000013oool400001_ooo`H0000;oooo0P0000[oool40000I_ooo`030000
oooooooo00;oool001Soool00`000?ooooooo`1Joooo1@0000[oool200001?ooo`@00008oooo1000
01Ooool40000I_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Joooo1@0000[oool2
00001?ooo`@00008oooo100001Ooool40000I_ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1Woooo100000Coool200002_ooo`@00009oooo0P00013oool40000H_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Woooo100000Coool200002_ooo`@00009oooo0P00013oool4
0000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Woooo1P0000koool500006_oo
o`@0001Roooo00<0003oooooool00_ooo`006?ooo`80001Xoooo1P0000koool500006_ooo`@0001Q
oooo0P0000Coool001Soool00`000?ooooooo`1Hoooo0P0000Woool400001_ooo`H00004oooo1000
01ooool40000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Hoooo0P0000Woool4
00001_ooo`H00004oooo100001ooool40000H_ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1Soooo100000Soool600000_ooo`@0000?oooo0P0000koool40000H_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Soooo100000Soool600000_ooo`@0000?oooo0P0000koool4
0000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Woooo0P0000;oool400002?oo
o`@00005oooo100007coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0F_ooo`030000
oooooooo00koool400002?ooo`@00002oooo0P0000Ooool20000N?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1Joooo00<0003oooooool03_ooo`@00008oooo100000;oool200001ooo
o`80001hoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo06?oool400000_ooo`800008
oooo100000_oool80000M_ooo`030000oooooooo00;oool001Soool20000I?ooo`@00002oooo0P00
00Soool400002oooo`P0001eoooo0P0000Coool001Soool00`000?ooooooo`1Foooo0P0000_oool4
00001?ooo`800002oooo0P0000;oool400002oooo`P0001foooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo05Koool200002oooo`@00004oooo0P0000;oool200000_ooo`@0000;oooo2000
07Koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E?ooo`@00007oooo100000Koool:
00000_ooo`80000?oooo0P0007Soool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E?oo
o`@00007oooo100000Koool:00000_ooo`80000?oooo0P0007Soool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0E?ooo`@00007oooo100000Soool800001_ooo`800005oooo0P0000;oool2
00002_ooo`80001^oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Coool400001ooo
o`@00008oooo200000Koool200001Oooo`800002oooo0P0000[oool20000K_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Ooooo100000Coool@00001?ooo`@00007oooo200000Coool4
0000J_ooo`030000oooooooo00;oool000goool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo05ooool400001?oooa000004oooo100000Ooool800001?ooo`@0001Zoooo00<0
003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003ooooo
ool0Goooo`@00004oooo400000;oool600001Oooo``00002oooo100000Koool20000H_ooo`030000
oooooooo00;oool000coool00`000?ooo`000002oooo00<0003oool000001?ooo`<0001Ooooo1000
00Coool@00000_ooo`H00005oooo300000;oool400001_ooo`80001Poooo0`0000Coool000goool0
1`000?ooooooooooo`000?ooo`000004oooo00<0003oooooool0E_ooo`800005oooo2P0000;oool2
00004_ooo`8000000oooo`000000000>oooo100000Koool40000H_ooo`030000oooooooo00;oool0
00coool00`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo05Koool200001Ooo
o`X00002oooo0P0001;oool2000000?oool0000000003_ooo`@00006oooo100006;oool00`000?oo
ooooo`02oooo000=oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`1O
oooo200001goool200005?ooo`@0001Roooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
05ooool800007Oooo`80000Doooo100006;oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0E?ooo`@00007oooo0P0003Woool40000H_ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1Doooo100000Ooool20000>Oooo`@0001Roooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo05Coool400003Oooo`800002oooo0P0000coool200001?ooo`80000Koooo100006;oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0E?ooo`@0000=oooo0P0000;oool200003?oo
o`800004oooo0P0001_oool40000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1D
oooo1P0000ooool200003_ooo`@00007oooo0P0000Koool200003?ooo`@0001Roooo00<0003ooooo
ool00_ooo`006?ooo`80001Eoooo1P0000ooool200003_ooo`@00007oooo0P0000Koool200003?oo
o`@0001Qoooo0P0000Coool001Soool00`000?ooooooo`1Doooo100000Woool200000_ooo`800008
oooo0P0002Woool40000H_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Doooo1000
00Woool200000_ooo`800008oooo0P0002Woool40000H_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`1Foooo0P0000Ooool800008oooo`P00004oooo200006;oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0E_ooo`800007oooo200002?oool800001?ooo`P0001Roooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo05Soool200000oooo``00002oooo0P0000coool2
00003oooo`P00002oooo2P0006;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0F?oo
o`800003oooo300000;oool200003?ooo`80000?oooo200000;oool:0000H_ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1Hoooo0`0001;oool200005oooo`@0000<oooo100006Koool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0F?ooo`<00004oooo0P0001;oool200003Ooo
o`800002oooo100000Coool200001?ooo`H0001Voooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo05Soool300001?ooo`80000Boooo0P0000goool200000_ooo`@00004oooo0P0000Coool6
0000I_ooo`030000oooooooo00;oool001Soool20000Foooo`<0000coooo0P0000;oool40000Iooo
o`800004oooo000Hoooo00<0003oooooool0F_ooo`<0000coooo0P0000;oool40000J?ooo`030000
oooooooo00;oool001Soool00`000?ooooooo`1[oooo0P0001?oool400001_ooo`80001doooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo06_oool200004oooo`@00006oooo0P0007Coool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0GOooo`X0000Ooooo0P0000;oool400000_oo
o`@0001/oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05goool:00007oooo`800002
oooo100000;oool40000K?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo2000
02?oool40000L_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Ooooo200002?oool4
0000L_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Qoooo100000koool200001_oo
o`800007oooo100000Coool20000L_ooo`030000oooooooo00;oool001Soool20000H_ooo`@0000>
oooo0P0000Koool200001oooo`@00004oooo0P00077oool200001?ooo`006?ooo`030000oooooooo
06Ooool200000_ooo`80000<oooo0P0000Goool20000O_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`1Woooo0P0000;oool200003?ooo`800005oooo0P0007koool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0JOooo`800008oooo0P0000[oool00`000?ooooooo`1noooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo06Woool200002?ooo`80000:oooo00<0003ooooo
ool0O_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool000Koool500000_ooo`030000oooooooo00;oool0
0`000?ooooooo`03oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0008oooo00L0
003oooooooooool0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00001?ooo`<0003noooo0`0000Coool000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`002?ooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo0007oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`800007
oooo0P000?Ooool200001?ooo`006?ooo`030000oooooooo00Koool20000n?ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`0:oooo0P0000Woool40000ioooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`0:oooo0P0000Woool40000ioooo`030000oooooooo00;oool001Soool00`000?ooooooo`0E
oooo10000>Ooool00`000?ooooooo`02oooo000Hoooo0P0001Koool40000i_ooo`800004oooo000H
oooo00<0003oooooool02_ooo`80003doooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00[oool20000m?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`06oooo0P0000coool0
0`000?ooooooo`3Yoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Koool200003?oo
o`030000oooooooo0>Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`@00004
oooo1P000>Woool200001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo1000
00Coool60000jOooo`800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool4
00000_ooo`H00004oooo0P0000Woool200003?ooo`80003Coooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool400000_ooo`H00004oooo0P0000Woool200003?ooo`80003Coooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00Koool400001_ooo`D00004oooo100000Soool6
00003?ooo`D00002oooo0P000<3oool00`000?ooooooo`02oooo000Hoooo0P0000Ooool400001_oo
o`D00004oooo100000Soool600003?ooo`D00002oooo0P000;ooool200001?ooo`006?ooo`030000
oooooooo00Koool600001_ooo`<00002oooo1P0000Koool600003oooo`@00034oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00Koool600001_ooo`<00002oooo1P0000Koool600003ooo
o`@00034oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool200001?ooo`80000A
oooo0P0000;oool200002?ooo`80000Uoooo0P0001Ooool400003_ooo`80000Moooo0P0000_oool2
00001_ooo`80000Doooo00<0003oooooool06?ooo`80000Noooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool200001?ooo`80000Aoooo0P0000;oool200002?ooo`80000Uoooo0P00
01Ooool400003_ooo`80000Moooo0P0000_oool200001_ooo`80000Doooo00<0003oooooool06?oo
o`80000Noooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00[oool200001_ooo`800000
0oooo`000000000<oooo0P00013oool200001oooo`80000Ooooo0P0003ooool200004oooo`800019
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00[oool200001_ooo`8000000oooo`00
0000000<oooo0P00013oool200001oooo`80000Ooooo0P0003ooool200004oooo`800019oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo01Coool00`000?ooooooo`04oooo0P0000Coool6
00001?ooo`H00004oooo1`0001Coool200001?ooo`800003oooo100000Coool400003_ooo`H00025
oooo00<0003oooooool00_ooo`001_ooo`D000001?ooo`000000000000?oool00`000?ooooooo`03
oooo00<0003oooooool05?ooo`030000oooooooo00Coool200001?ooo`H00004oooo1P0000Coool7
00005?ooo`800004oooo0P0000?oool400001?ooo`@0000>oooo1P0008Goool00`000?ooooooo`02
oooo0008oooo00D0003oooooooooool000001?ooo`030000oooo000000Coool00`000?ooooooo`0>
oooo0P0000goool200000_ooo`@00008oooo1P0000;oool700001?ooo`800006oooo0P0000;oool2
00003Oooo`@00004oooo1000013oool400001?ooo`030000oooooooo00Soool200001?ooo`800002
oooo0P0000Koool200001oooo`800004oooo0P0000coool200003oooo`80000doooo00<0003ooooo
ool00_ooo`002?ooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000004oooo0`00
00koool200003Oooo`800002oooo100000Soool600000_ooo`L00004oooo0P0000Koool200000_oo
o`80000=oooo100000Coool400004?ooo`@00004oooo00<0003oooooool02?ooo`800004oooo0P00
00;oool200001_ooo`800007oooo0P0000Coool200003?ooo`80000?oooo0P0003;oool300001?oo
o`002?ooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000004oooo00<0003ooooo
ool04_ooo`80000Eoooo0P0000;oool400001_ooo`T00006oooo0P0000Coool400002oooo`800006
oooo100000;oool200001?ooo`@00004oooo200000_oool600001_ooo`80000;oooo0P0000koool2
00004oooo`@0000@oooo0P00017oool400003Oooo`030000oooooooo00;oool000Soool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo02goool400001ooo
o`P0000<oooo100001?oool400002?ooo`@00002oooo2P0000Woool600001?ooo`80000<oooo0P00
00Ooool200004?ooo`80000;oooo100001Soool200000_ooo`030000oooooooo00800002oooo1000
00goool00`000?ooooooo`02oooo0007oooo0P0000Coool00`000?ooooooo`02oooo00<0003ooooo
ool00oooo`030000oooooooo02goool400001oooo`P0000<oooo100001?oool400002?ooo`@00002
oooo2P0000Woool600001?ooo`80000<oooo0P0000Ooool200004?ooo`80000;oooo100001Soool2
00000_ooo`030000oooooooo00800002oooo100000goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool09oooo`80000?oooo0P0000Coool200001_ooo`H00004oooo0P0000Coool900001?oo
o`P00002oooo200000;oool400000_ooo`800005oooo0P0000Soool400001_ooo`H00004oooo0`00
00Soool200001_ooo`@0000<oooo0`0000Coool400001?ooo`80000>oooo100000?oool400001?oo
o`@00009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo02Ooool200003oooo`800004
oooo0P0000Koool600001?ooo`800004oooo2@0000Coool800000_ooo`P00002oooo100000;oool2
00001Oooo`800008oooo100000Koool600001?ooo`<00008oooo0P0000Koool400003?ooo`<00004
oooo100000Coool200003_ooo`@00003oooo100000Coool400002Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`04oooo0P0001goool200007Oooo`800004oooo100000;oool200002?oo
o`L00002oooo2P0000Coool400001?ooo`@00005oooo0P0000Koool200000_ooo`H00008oooo1P00
00;oool300000_ooo`800002oooo0P0000Soool400001?ooo`800002oooo0P0000;oool300001?oo
o`@00002oooo0P0000Koool400001_ooo`@000000oooo`000000000400000_ooo`P00007oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00Coool200007Oooo`80000Moooo0P0000Coool4
00000_ooo`800008oooo1`0000;oool:00001?ooo`@00004oooo100000Goool200001_ooo`800002
oooo1P0000Soool600000_ooo`<00002oooo0P0000;oool200002?ooo`@00004oooo0P0000;oool2
00000_ooo`<00004oooo100000;oool200001_ooo`@00006oooo10000003oooo0000000000@00002
oooo200000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0A?ooo`800004oooo0P00
00coool2000000?oool0000000000P0000Coool600002?ooo``00002oooo00<0003oooooool03_oo
o`800002oooo0P0000Coool?00001?ooo`@00006oooo3P000003oooo0000000000800006oooo0P00
00;oool800001?ooo`d00002oooo0P0000ooool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0A?ooo`800004oooo0P0000coool2000000?oool0000000000P0000Coool600002?ooo``00002
oooo00<0003oooooool03_ooo`800002oooo0P0000Coool?00001?ooo`@00006oooo3P000003oooo
0000000000800006oooo0P0000;oool800001?ooo`d00002oooo0P0000ooool00`000?ooooooo`02
oooo000Hoooo0P0001?oool200008oooo`<0000Qoooo100000Coool400003?ooo`P00009oooo0P00
00Coool200002_ooo`800002oooo4@0000;oool600001_ooo``00007oooo0P0000Koool800001?oo
o`/0000:oooo0P0000Soool200001?ooo`006?ooo`030000oooooooo01;oool200008oooo`<0000Q
oooo100000Coool400003?ooo`P00009oooo0P0000Coool200002_ooo`800002oooo4@0000;oool6
00001_ooo``00007oooo0P0000Koool800001?ooo`/0000:oooo0P0000Woool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0E?ooo`800004oooo00<0003oooooool05_ooo`@00006oooo0`00
00koool200000_ooo`P00008oooo00<0003oooooool0100000;oool400000_ooo`800002oooo0P00
00Coool200002?ooo`T0000:oooo100000Coool200002Oooo`800004oooo0P0000goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0E?ooo`800004oooo00<0003oooooool05_ooo`@00006
oooo0`0000koool200000_ooo`P00008oooo00<0003oooooool0100000;oool400000_ooo`800002
oooo0P0000Coool200002?ooo`T0000:oooo100000Coool200002Oooo`800004oooo0P0000goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0C_ooo`80000Coooo0P0000koool400002ooo
o`800008oooo0P0000Coool800002oooo`@0000Loooo1`0000coool400009?ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`1>oooo0P0001?oool200003_ooo`@0000;oooo0P0000Soool2
00001?ooo`P0000;oooo100001coool700003?ooo`@0000Toooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`800003oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool200001?ooo`006?ooool0000500001?ooo`00ooooob7oool00?oooolQoooo003o
oooo8Oooo`00ooooob7oool00?oooolQoooo0022oooo0P0009coool008Coool00`000?ooooooo`2I
oooo001Zoooo1@0000Soool200001?ooo`800003oooo10000004oooo0000oooo00000_ooo`800000
0oooo`0000000002oooo00<0003oooooool00P0000ooool200000_ooo`8000000oooo`0000000002
oooo0P0000?oool200000_ooo`<000001_ooo`00000000000?ooo`0005coool006coool00`000?oo
ooooo`0:oooo00@0003oooooool00004oooo00<0003oooooool00P000006oooo0000oooo0000oooo
00001?ooo`060000oooooooo0000oooo00000_ooo`030000oooooooo00koool01P000?ooooooo`00
0?ooo`0000;oool00`000?ooooooo`02oooo00H0003oooooool0003oool00004oooo00@0003ooooo
ool0001Loooo001/oooo00<0003oooooool02Oooo`040000oooooooooooo0`0000;oool00`000?oo
ooooo`02000000Goool0003oool0003oool00`0000;oool01P000?ooooooo`000?ooo`0001;oool0
10000?ooooooooooo`<00002oooo0`0000;oool00`000?ooooooo`02oooo00<0003oooooool00_oo
o`040000oooooooo0000G?ooo`00K?ooo`030000oooooooo00Woool200000_ooo`<00003oooo1@00
0004oooo0000oooooooo0`000003oooo00000000008000000oooo`000000000200004?ooo`800002
oooo00D0003oool00000003oool00`000003oooo0000000000800002oooo0`0000;oool30000GOoo
o`00K?ooo`030000oooooooo02Koool00`000?ooooooo`0Doooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`1Moooo001[oooo0P0003koool200004_ooo`80001Ooooo003o
oooo8Oooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Timing[segment16=weightenWaveletSegnetation[sampleData,16];]", "Input"],

Cell[BoxData[
    \({80.4099999999999681`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell["\<\
Show[segment16[[2]], 
\tPlotLabel -> \"16 by 16 Segments\",
\tBackground->GrayLevel[0],AspectRatio->1,Frame->True];\
\>", "Input"],

Cell["\<\
ListDensityPlot[1-segment16[[1]],
\tPlotLabel->\"16 by 16 segmented sketch\",Mesh->False];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["2",
        FontVariations->{"Underline"->True}], 
      StyleBox["nd",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["sample",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(sampleDataA = {{1, 1, 1, 1, 1, 1, 1, 1}, \n
        \t\t{1, 1, 1, 0, 0, 1, 1, 0}, \n\t\t{1, 1, 1, 1, 0, 1, 1, 0}, \n
        \t\t{1, 1, 1, 1, 0, 0, 1, 1}, \n\t\t{1, 1, 1, 1, 1, 1, 1, 1}, \n
        \t\t{1, 1, 1, 0, 0, 1, 1, 0}, \n\t\t{1, 1, 1, 1, 1, 1, 1, 0}, \n
        \t\t{1, 1, 1, 1, 1, 1, 1, 1}}; \)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
sampleFigureA=ListDensityPlot[sampleDataA,
\tPlotLabel->\"Sample figure A\",
\tMesh->False];
sampleFigureB=ListDensityPlot[sampleDataB,
\tPlotLabel->\"Sample figure B\",
\tDisplayFunction->Identity,Mesh->False];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -47.2188 0 ]
[.5 1.0125 47.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -108.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(figure) show
147.187500 13.000000 moveto
(A) show
153.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFF
FFFFFF0000FFFF00
FFFFFFFF00FFFF00
FFFFFFFF0000FFFF
FFFFFFFFFFFFFFFF
FFFFFF0000FFFF00
FFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01Ooool00`000?ooooooo`0joooo0`0003coool30000>_ooo`80000moooo00<0003oooooool03_oo
o`005_ooo`030000oooo000003_oool00`000?ooooooo`0moooo00<0003oooooool0>Oooo`030000
oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool00000??ooo`030000oooooooo
03[oool40000>_ooo`030000oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool0
0000??ooo`030000oooooooo03[oool00`000?ooo`00000koooo0P0003goool00`000?ooooooo`0>
oooo000Foooo00<0003oool00000>oooo`030000oooo000003coool20000>oooo`030000oooooooo
03_oool00`000?ooo`00000?oooo000Goooo00<0003oooooool0>oooo`030000oooooooo03coool0
0`000?ooooooo`0joooo0P0003coool00`000?ooooooo`0>oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000Booooo`0000D0000:oooo000B
oooo00<0003oooooool00_ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`02oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`003?ooo`030000
oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool000_oool00`000?oo
o`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000;oooo00<0003oool0
00001?ooo`<0003noooo0`0000[oool000_oool00`000?ooo`000004oooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool0
01;oool20000ooooo`7oool200002_ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_oo
o`80003ooooo0Oooo`80000:oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
ocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000n
oooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000B
oooo0P00063ooolo0000?_oooal00004oooo0P0000[oool001;oool00`000?ooooooo`1Ooooo?`00
03kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1O
oooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`00
03kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Ooo
o`030000oooooooo00Soool000_oool300001?ooo`030000oooooooo05oooolo0000?_oooal00005
oooo00<0003oooooool02?ooo`002oooo`030000oooooooo00Coool00`000?ooooooo`1Ooooo?`00
03kooolO00001Oooo`030000oooooooo00Soool000coool00`000?ooooooo`03oooo0`0005oooolo
0000?_oooal00003oooo0`0000[oool000coool00`000?ooooooo`03oooo00<0003oooooool0Oooo
oal0000noooo7`0000Goool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000
oooooooo07oooolO0000?_oooal00005oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo
00?oool00`000?ooooooo`1ooooo7`0003kooolO00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1ooooo7`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1ooooo7`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1o
oooo7`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1ooooo7`00
03kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1ooooo7`0003kooolO
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1ooooo7`0003kooolO00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`1ooooo7`0003kooolO00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1ooooo7`0003kooolO00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1ooooo7`0003kooolO00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`1ooooo7`0003kooolO00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1ooooo7`0003kooolO00001Oooo`030000oooooooo00Soool001;oool20000P?oo
oal0000noooo7`0000Coool200002_ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo07oooolO0000?_oooal00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo07oooolO0000?_oooal00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
07oooolO0000?_oooal00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07oooolO
0000?_oooal00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oo
oal00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo07oooolO0000?_oooal00005oooo00<0003oooooool02?ooo`004_oo
o`800020oooo7`0003kooolO00001?ooo`80000:oooo000Boooo00<0003oooooool0Oooooch00013
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07ooooln0000@oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1ooooo?P0004?oool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Oooooch00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07ooooln
0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1ooooo?P0004?oool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Oooooch00013oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo07ooooln0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1o
oooo?P0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Oooooch00013oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo07ooooln0000@oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`1ooooo?P0004?oool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0Oooooch00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07ooooln0000@ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`1ooooo?P0004?oool00`000?ooooooo`08
oooo000Boooo0P00083oooln0000@_ooo`80000:oooo000Boooo00<0003oooooool0Oooooch00013
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07ooooln0000@oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1ooooo?P0004?oool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Oooooch00013oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo07ooooln
0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1ooooo?P0004?oool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Oooooch00013oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo07ooooln0000@oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1o
oooo?P0004?oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Oooooch00013oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo07ooooln0000@oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`1ooooo?P0004?oool00`000?ooooooo`08oooo000<oooo0`0000?oool0
0`000?ooooooo`1ooooo?P0004?oool00`000?ooooooo`08oooo000=oooo00<0003oooooool00_oo
o`030000oooooooo07ooooln0000@oooo`030000oooooooo00Soool000_oool400000oooo`<0001o
oooo?P00047oool300002_ooo`002oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool000coool200001?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`003Oooo`030000oooooooo00;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool20000ooooo`7oool200002_ooo`004_oo
o`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`004_ooo`80003ooooo0Ooo
o`80000:oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Gooo
ocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000n
oooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0Goooocl0000noooo7`0000Goool00`000?ooooooo`08oooo000Boooo0P00063ooolo0000?_oo
oal00004oooo0P0000[oool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1O
oooo?`0003kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`00
03kooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`1Ooooo?`0003kooolO00001Oooo`030000oooooooo
00Soool000_oool200001Oooo`030000oooooooo05oooolo0000?_oooal00005oooo00<0003ooooo
ool02?ooo`002oooo`030000oooo000000Coool00`000?ooooooo`1Ooooo?`0003kooolO00001Ooo
o`030000oooooooo00Soool000_oool00`000?ooo`000004oooo0`0005oooolo0000?_oooal00003
oooo0`0000[oool000_oool200001Oooo`030000oooooooo0=cooolO00001Oooo`030000oooooooo
00Soool000_oool00`000?ooooooo`04oooo00<0003oooooool0g?oooal00005oooo00<0003ooooo
ool02?ooo`003?ooo`800004oooo00<0003oooooool0g?oooal00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0=cooolO00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`3Loooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0g?oooal00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0=cooolO00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`3Loooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0g?oooal00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0=cooolO
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3Loooo7`0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0g?oooal00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo0=cooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3L
oooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0g?oooal00005oooo00<0
003oooooool02?ooo`004_ooo`80003Moooo7`0000Coool200002_ooo`004_ooo`030000oooooooo
0=cooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3Loooo7`0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0g?oooal00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo0=cooolO00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`3Loooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool0g?oooal00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0=cooolO00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`3Loooo7`0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0g?oooal00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo0=cooolO
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3Loooo7`0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0g?oooal00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo0=cooolO00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3L
oooo7`0000Goool00`000?ooooooo`08oooo000Boooo0P000=gooolO00001?ooo`80000:oooo000B
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000B
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`08oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08
oooo000Boooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`08oooo000Boooo0P000?ooool1oooo0P0000[oool001;oool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00Soool000coool00`000?ooooooo`03oooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`002oooo`030000oooo000000Coool30000o_ooo`<0000:oooo000<oooo00<0
003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`002oooo`030000
oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool000coool00`000?oo
ooooo`03oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000
oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool0
0`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<
oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003ooooo
ool03?ooo`030000oooooooo00goool00`000?ooooooo`02oooo00<0003oooooool02?ooo`004_oo
ool0000500002_ooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQ
oooo001eoooo0`0002Coool20000P_ooo`00M_ooo`030000oooooooo02Goool00`000?ooooooo`1o
oooo001Woooo0`0000;oool5000000Goool0003oool0003oool00`0000;oool300000oooo`80000>
oooo0`0000;oool300000oooo`<00002oooo0`000004oooo0000000000000oooo`80000>oooo0P00
0003oooo00000000063oool006Ooool00`000?ooo`000002oooo0`000008oooo0000oooo0000oooo
0000oooo00000_ooo`040000oooooooo00000oooo`030000oooooooo00ooool00`000?ooooooo`02
oooo00D0003oooooooooool000000_ooo`030000oooo000000;oool010000?ooooooo`0000?oool0
0`000?ooooooo`0>oooo00D0003oooooooooool00000H?ooo`00JOooo`030000oooooooo00;oool0
2@000?ooo`000?ooo`000?ooo`000?ooo`000002oooo00@0003oooooool00003oooo0`0000ooool0
0`000?ooooooo`02oooo00D0003oooooooooool000000_ooo`030000oooo000000;oool010000?oo
ooooo`0000?oool300003oooo`<0001Qoooo001Xoooo00<0003oooooool00_ooo`8000001_ooo`00
00000?ooo`000?ooo`@00003oooo00@0003oooooooooool300003_ooo`<00002oooo0P0000Coool5
000000Coool00000003oool4000000Coool000000000000?oooo00<0003oool00000HOooo`00Iooo
o`030000oooo000001;oool00`000?ooooooo`0Coooo00<0003oooooool0:?ooo`030000oooooooo
063oool006Ooool300004Oooo`80000Foooo00D0003oooooooooool000009?ooo`80001Roooo003o
oooo8Oooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.762352, -0.553541, 0.0321664, 
  0.0321664}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Timing[segmentA16=weightenWaveletSegnetation[sampleDataA,16];]\
\>", "Input"],

Cell[BoxData[
    \({0.159999999999968167`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
sketchA16=ListDensityPlot[1-Abs[segmentA16[[1]]],
\tPlotLabel -> \"Sketch of sample A\",
\tMesh->False,DisplayFunction->Identity];
outlineA16=Show[segmentA16[[2]],
\tPlotLabel -> \"Outline of sample A\",
\tBackground->GrayLevel[0],AspectRatio->1,Frame->True,
\tDisplayFunction->Identity];
Show[GraphicsArray[{sampleFigureA,outlineA16,sketchA16}]];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -47.2188 0 ]
[.5 1.0125 47.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -108.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(figure) show
147.187500 13.000000 moveto
(A) show
153.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFF
FFFFFF0000FFFF00
FFFFFFFF00FFFF00
FFFFFFFF0000FFFF
FFFFFFFFFFFFFFFF
FFFFFF0000FFFF00
FFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
0 g
MFill
% Scaling calculations
-0.547619 0.190476 0.0238095 0.119048 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02381 -6 -4.5 ]
[-0.0125 .02381 0 4.5 ]
[-0.0125 .2619 -6 -4.5 ]
[-0.0125 .2619 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7381 -6 -4.5 ]
[-0.0125 .7381 0 4.5 ]
[-0.0125 .97619 -6 -4.5 ]
[-0.0125 .97619 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -59.2188 0 ]
[.5 1.0125 59.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 g
.25 Mabswid
.02381 0 m
.02381 .00625 L
s
[(3)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(4)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(5)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(7)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(8)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.0619 0 m
.0619 .00375 L
s
.1 0 m
.1 .00375 L
s
.1381 0 m
.1381 .00375 L
s
.17619 0 m
.17619 .00375 L
s
.25238 0 m
.25238 .00375 L
s
.29048 0 m
.29048 .00375 L
s
.32857 0 m
.32857 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.44286 0 m
.44286 .00375 L
s
.48095 0 m
.48095 .00375 L
s
.51905 0 m
.51905 .00375 L
s
.55714 0 m
.55714 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.67143 0 m
.67143 .00375 L
s
.70952 0 m
.70952 .00375 L
s
.74762 0 m
.74762 .00375 L
s
.82381 0 m
.82381 .00375 L
s
.8619 0 m
.8619 .00375 L
s
.9 0 m
.9 .00375 L
s
.9381 0 m
.9381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02381 m
.00625 .02381 L
s
[(0)] -0.0125 .02381 1 0 Mshowa
0 .2619 m
.00625 .2619 L
s
[(2)] -0.0125 .2619 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .7381 m
.00625 .7381 L
s
[(6)] -0.0125 .7381 1 0 Mshowa
0 .97619 m
.00625 .97619 L
s
[(8)] -0.0125 .97619 1 0 Mshowa
.125 Mabswid
0 .08333 m
.00375 .08333 L
s
0 .14286 m
.00375 .14286 L
s
0 .20238 m
.00375 .20238 L
s
0 .32143 m
.00375 .32143 L
s
0 .38095 m
.00375 .38095 L
s
0 .44048 m
.00375 .44048 L
s
0 .55952 m
.00375 .55952 L
s
0 .61905 m
.00375 .61905 L
s
0 .67857 m
.00375 .67857 L
s
0 .79762 m
.00375 .79762 L
s
0 .85714 m
.00375 .85714 L
s
0 .91667 m
.00375 .91667 L
s
.25 Mabswid
0 0 m
0 1 L
s
.02381 .99375 m
.02381 1 L
s
.21429 .99375 m
.21429 1 L
s
.40476 .99375 m
.40476 1 L
s
.59524 .99375 m
.59524 1 L
s
.78571 .99375 m
.78571 1 L
s
.97619 .99375 m
.97619 1 L
s
.125 Mabswid
.0619 .99625 m
.0619 1 L
s
.1 .99625 m
.1 1 L
s
.1381 .99625 m
.1381 1 L
s
.17619 .99625 m
.17619 1 L
s
.25238 .99625 m
.25238 1 L
s
.29048 .99625 m
.29048 1 L
s
.32857 .99625 m
.32857 1 L
s
.36667 .99625 m
.36667 1 L
s
.44286 .99625 m
.44286 1 L
s
.48095 .99625 m
.48095 1 L
s
.51905 .99625 m
.51905 1 L
s
.55714 .99625 m
.55714 1 L
s
.63333 .99625 m
.63333 1 L
s
.67143 .99625 m
.67143 1 L
s
.70952 .99625 m
.70952 1 L
s
.74762 .99625 m
.74762 1 L
s
.82381 .99625 m
.82381 1 L
s
.8619 .99625 m
.8619 1 L
s
.9 .99625 m
.9 1 L
s
.9381 .99625 m
.9381 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .02381 m
1 .02381 L
s
.99375 .2619 m
1 .2619 L
s
.99375 .5 m
1 .5 L
s
.99375 .7381 m
1 .7381 L
s
.99375 .97619 m
1 .97619 L
s
.125 Mabswid
.99625 .08333 m
1 .08333 L
s
.99625 .14286 m
1 .14286 L
s
.99625 .20238 m
1 .20238 L
s
.99625 .32143 m
1 .32143 L
s
.99625 .38095 m
1 .38095 L
s
.99625 .44048 m
1 .44048 L
s
.99625 .55952 m
1 .55952 L
s
.99625 .61905 m
1 .61905 L
s
.99625 .67857 m
1 .67857 L
s
.99625 .79762 m
1 .79762 L
s
.99625 .85714 m
1 .85714 L
s
.99625 .91667 m
1 .91667 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -120.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
(Outline) show
111.000000 13.000000 moveto
(of) show
129.000000 13.000000 moveto
(sample) show
171.187500 13.000000 moveto
(A) show
177.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 0 r
.008 w
.02381 .14286 Mdot
.02381 .2619 Mdot
.02381 .61905 Mdot
.02381 .7381 Mdot
.21429 .14286 Mdot
.21429 .61905 Mdot
.40476 .14286 Mdot
.40476 .61905 Mdot
.59524 .14286 Mdot
.59524 .2619 Mdot
.59524 .38095 Mdot
.59524 .61905 Mdot
.59524 .7381 Mdot
.78571 .14286 Mdot
.78571 .2619 Mdot
.78571 .38095 Mdot
.78571 .5 Mdot
.78571 .61905 Mdot
.78571 .7381 Mdot
.78571 .85714 Mdot
.78571 .97619 Mdot
.97619 .14286 Mdot
.97619 .5 Mdot
.97619 .61905 Mdot
.97619 .97619 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -56.2188 0 ]
[.5 1.0125 56.2188 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -117.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sketch) show
105.000000 13.000000 moveto
(of) show
123.000000 13.000000 moveto
(sample) show
165.187500 13.000000 moveto
(A) show
171.437500 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFAAAAAAAAAAAA
FFFFAA0000AAAA00
FFFFFFFFAA00AA00
FFFFFFFFAAAAAAAA
FFFFAAAAAAAAAAAA
FFFFAA0000AAAA00
FFFFFFFFFFFFAA00
FFFFFFFFFFFFAAAA
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{420, 131.25},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006T0000PaP00`40o`000?l0003oooooojGoool0
0?oooonUoooo003oooooYOooo`00ooooojGoool001_oool00`000?ooooooo`0Doooo0`0001Koool3
00005?ooo`80000Goooo00<0003oooooool05?ooo`h00002oooo4P0000?oool@000000?oool00000
00003`0000;ooolB000000?oool00000000040000003oooo0000000000d0000Ioooo00<0003ooooo
ool05?ooo`<0000Foooo0`0001Coool200005oooo`030000oooooooo01Soool001[oool00`000?oo
o`00000Eoooo00<0003oooooool05oooo`030000oooooooo01?oool00`000?ooo`00000Eoooo00<0
003oool000005Ooooa0000000oooo`000000000@000000?oool0000000003P000003oooo0000oooo
010000000oooo`000?ooo`0A000000?oool0000000003`000003oooo0000oooo00h0000Hoooo00<0
003oool000005Oooo`030000oooooooo01Ooool00`000?ooooooo`0Coooo00<0003oool000005Ooo
o`030000oooo000001Woool001[oool00`000?ooo`00000Foooo00<0003oooooool05?ooo`@0000D
oooo00<0003oool000005Oooo`030000oooo000001Goool?000000?oool0000000003`0000CooolA
000000?oool0000000003P000003oooo0000oooo014000000oooo`000000000?000000?oool0003o
ool03P0001Soool00`000?ooo`00000Foooo00<0003oooooool05?ooo`@0000Doooo00<0003oool0
00005Oooo`030000oooo000001Woool001[oool00`000?ooo`00000Foooo00<0003oooooool05?oo
o`030000oooo000001Goool200005oooo`030000oooooooo01Coool@000000?oool0000000003P00
0003oooo0000oooo01000002oooo4@0000;ooolC000000?oool0000000003`000003oooo00000000
00d0000Hoooo00<0003oool000005_ooo`030000oooooooo01Coool00`000?ooo`00000Eoooo0P00
01Ooool00`000?ooooooo`0Hoooo000Joooo00<0003oool000005Oooo`030000oooo000001Koool2
00005Oooo`030000oooooooo01Goool00`000?ooo`00000Eoooo3P000003oooo0000oooo01400002
oooo40000003oooo00000000010000000oooo`000000000@000000?oool0003oool040000003oooo
0000oooo00h0000Hoooo00<0003oool000005Oooo`030000oooo000001Koool200005Oooo`030000
oooooooo01Goool00`000?ooo`00000Ioooo000Koooo00<0003oooooool05Oooo`030000oooooooo
01Koool00`000?ooooooo`0Doooo0P0001Koool00`000?ooooooo`0Doooo3`000003oooo00000000
014000000oooo`000000000>00000ooooa400002oooo400000?ooolA000000?oool0000000003@00
01Woool00`000?ooooooo`0Eoooo00<0003oooooool05_ooo`030000oooooooo01Coool200005_oo
o`030000oooooooo01Soool009;ooomn0000U?ooo`00T_ooogh0002Doooo002BooooOP0009Coool0
09;ooomn0000U?ooo`005_ooo`040000ooooooooooooI00001Coool9000000Coool000000000001U
oooo300001Coool010000?ooooooooooofD0000Goooo000Eoooo00<0003oool000000_ooo`030000
oooooooo063oool00`000?ooooooo`0Boooo20000003oooo0000oooo008000000oooo`000000001Q
000000?oool0000000002P0001?oool00`000?ooo`000002oooo00<0003oooooool0HOooo`030000
oooooooo01Goool001Goool00`000?ooo`000002oooo00<0003oooooool0H?ooo`030000oooooooo
01;oool8000000?oool0003oool00P0000;ooomQ00000_ooo``0000Coooo00<0003oool000000_oo
o`80000HooooB:ZZZP03oooo0000000001Ooool001Goool00`000?ooo`000002oooo00<0003ooooo
ool0H?ooo`030000oooooooo01;oool8000000?oool0003oool00P000003oooo0000000006400000
0oooo`000000000:00004oooo`030000oooo000000;oool00`000?ooooooo`0GooooB:ZZZP;oool0
0`000?ooooooo`0Eoooo000Eoooo00<0003oool000000_ooo`030000oooooooo063oool00`000?oo
ooooo`0Boooo20000003oooo0000oooo008000000oooo`000000001Q000000?oool0000000002P00
01?oool00`000?ooo`000002oooo00<0003oooooool05oooodRZZZX2oooo00<0003oooooool05Ooo
o`005_ooo`050000oooooooooooo000006;oool00`000?ooooooo`0Boooo2@000005oooo00000000
0000oooo06<000000oooo`000000000:00005?ooo`050000oooooooooooo000001Wooom8ZZZZ0_oo
o`030000oooooooo01Goool001[oool00`000?ooooooo`1Poooo00<0003oooooool04_ooo`d00000
0oooo`000000001Q000000?oool0000000002P0001Soool00`000?ooooooo`0GooooB:ZZZP;oool0
0`000?ooooooo`0Eoooo000Joooo00<0003oooooool0H?ooo`030000oooooooo01;oool=000000?o
ool000000000H@000003oooo0000000000X0000Hoooo00<0003oooooool05oooodRZZZX2oooo00<0
003oooooool05Oooo`006_ooo`030000oooooooo063oool00`000?ooooooo`0Boooo3@000003oooo
0000000006000002oooo300001Soool00`000?ooooooo`0GooooB:ZZZP03oooo0000000001Ooool0
01[oool00`000?ooooooo`1Poooo00<0003oooooool04_ooo`d000000oooo`000000001Q000000?o
ool0000000002P0001Soool00`000?ooooooo`0GooooB:ZZZP;oool00`000?ooooooo`0Eoooo000J
oooo00<0003oooooool0H?ooo`030000oooooooo01;oool=000000?oool000000000H@000003oooo
0000000000X0000Hoooo00<0003oooooool05oooodRZZZX2oooo00<0003oooooool05Oooo`006_oo
o`030000oooooooo063oool00`000?ooooooo`0Boooo3@000003oooo00000000064000000oooo`00
0000000:00006?ooo`030000oooooooo01Oooom8ZZZZ0_ooo`030000oooooooo01Goool001[oool0
0`000?ooooooo`1Poooo00<0003oooooool04_ooo`d000000oooo`000000001Q000000?oool00000
00002P0001Soool00`000?ooooooo`0GooooB:ZZZP;oool00`000?ooooooo`0Eoooo000Joooo00<0
003oooooool0H?ooo`030000oooooooo01;oool=000000?oool000000000H@000003oooo00000000
00X0000Hoooo00<0003oooooool05oooodRZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000
oooooooo02?ooolH00006?ooo``000000oooo`000?ooo`0Coooo3@000004oooo00000000ool04P00
0003ool000000000010000000ooo00000000000@000000?oo`000000000040000003ool000000000
010000000ooo0?ooooooo`0<00006?ooo`030000oooooooo01Ooool<ZZZZ600001RZZZX<000000?o
ool0000000005oooo`006_ooo`030000oooooooo02?ooolH00006?ooo``000000oooo`000?ooo`0C
oooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000oooooooo01Ooool<
ZZZZ600001RZZZX<00000_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo6000
01Soool<000000?oool0003oool04oooo`d000000oooo`000000001Q000000?oool0000000002P00
01Soool00`000?ooooooo`0Goooo3:ZZZQP0000HZZZZ300000;oool00`000?ooooooo`0Eoooo000J
oooo00<0003oooooool08ooooaP0000Hoooo30000003oooo0000oooo01?oool=000000?oool00000
0000H@000003oooo0000000000X0000Hoooo00<0003oooooool05oooo`bZZZXH00006:ZZZP`00002
oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02?ooolH00006?ooo``000000oooo`00
0?ooo`0Coooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000oooooooo
01Ooool<ZZZZ600001RZZZX<00000_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`0S
oooo600001Soool<000000?oool0003oool04oooo`d000000oooo`000000001Q000000?oool00000
00002P0001Soool00`000?ooooooo`0Goooo3:ZZZQP0000HZZZZ300000;oool00`000?ooooooo`0E
oooo000Joooo00<0003oooooool08ooooaP0000Hoooo30000003oooo0000oooo01?oool=000000?o
ool000000000H00000;oool<00006?ooo`030000oooooooo01Ooool<ZZZZ600001RZZZX<000000?o
ool0000000005oooo`006_ooo`030000oooooooo02?ooolH00006?ooo``000000oooo`000?ooo`0C
oooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000oooooooo01Ooool<
ZZZZ600001RZZZX<00000_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo6000
01Soool<000000?oool0003oool04oooo`d000000oooo`000000001Q000000?oool0000000002P00
01Soool00`000?ooooooo`0Goooo3:ZZZQP0000HZZZZ300000;oool00`000?ooooooo`0Eoooo000J
oooo00<0003oooooool08ooooaP0000Hoooo30000003oooo0000oooo01?oool=000000?oool00000
0000H@000003oooo0000000000X0000Hoooo00<0003oooooool05oooo`bZZZXH00006:ZZZP`00002
oooo00<0003oooooool05Oooo`005Oooo`<00002oooo00<0003oooooool08ooooaP0000Hoooo3000
0003oooo0000oooo01?oool800000oooo`8000000oooo`000000001Q000000?oool0000000002P00
01?oool300000_ooo`030000oooooooo01Ooool<ZZZZ600001RZZZX<00000_ooo`030000oooooooo
01Goool001Goool00`000?ooooooo`02oooo00<0003oooooool08ooooaP0000Hoooo30000003oooo
0000oooo01?oool8000000?oool0000000000P000003oooo00000000064000000oooo`000000000:
00004oooo`030000oooooooo00;oool00`000?ooooooo`0Goooo3:ZZZQP0000HZZZZ300000;oool0
0`000?ooooooo`0Eoooo000Foooo00D0003oooooooooool00000<Oooo``0000Hoooo30000003oooo
0000oooo01?oool9000000Coool0000000000002oooo00<0003oo`000000=`000003ool000000000
010000000ooo00000000000A00000_ooo``0000Doooo00@0003oooooooooool20000<?ooo`bZZZX<
00003:ZZZP`000000oooo`000000000Goooo000Foooo00D0003oooooooooool00000<Oooo``0000H
oooo30000003oooo0000oooo01?oool9000000Goool000000000003oool0H`000003oooo00000000
00X0000Doooo00D0003oooooooooool00000<Oooo`bZZZX<00003:ZZZP`00002oooo00<0003ooooo
ool05Oooo`005Oooo`030000oooo000000;oool00`000?ooooooo`0_oooo300001Soool<000000?o
ool0003oool04oooo`P000000oooo`000?ooo`02000000?oool000000000H@000003oooo00000000
00X0000Coooo00<0003oool000000_ooo`030000oooooooo02ooool<ZZZZ300000bZZZX<00000_oo
o`030000oooooooo01Goool001Koool01@000?ooooooooooo`00000aoooo300001Soool<000000?o
ool0003oool04oooo`T000001Oooo`00000000000?ooo`1S000000?oool0000000002P0001Coool0
1@000?ooooooooooo`00000aoooo3:ZZZP`0000<ZZZZ300000;oool00`000?ooooooo`0Eoooo000J
oooo00<0003oooooool0;oooo``0000Hoooo30000003oooo0000oooo01?oool=000000?oool00000
0000H@000003oooo0000000000X0000Hoooo00<0003oooooool0;oooo`bZZZX<00003:ZZZP`00002
oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02ooool<00006?ooo``000000oooo`00
0?ooo`0Coooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000oooooooo
02ooool<ZZZZ300000bZZZX<000000?oool0000000005oooo`006_ooo`030000oooooooo02ooool<
00006?ooo``000000oooo`000?ooo`0Coooo3@000003oooo0000000006000002oooo300001Soool0
0`000?ooooooo`0_oooo3:ZZZP`0000<ZZZZ300000;oool00`000?ooooooo`0Eoooo000Joooo00<0
003oooooool0;oooo``0000Hoooo30000003oooo0000oooo01?oool=000000?oool000000000H@00
0003oooo0000000000X0000Hoooo00<0003oooooool0;oooo`bZZZX<00003:ZZZP`00002oooo00<0
003oooooool05Oooo`006_ooo`030000oooooooo02ooool<00006?ooo``000000oooo`000?ooo`0C
oooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000oooooooo02ooool<
ZZZZ300000bZZZX<00000_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`0_oooo3000
01Soool<000000?oool0003oool04oooo`d000000oooo`000000001Q000000?oool0000000002P00
01Soool00`000?ooooooo`0_oooo3:ZZZP`0000<ZZZZ300000;oool00`000?ooooooo`0Eoooo000J
oooo00<0003oooooool0;oooo``0000Hoooo30000003oooo0000oooo01?oool=000000?oool00000
0000H@000003oooo0000000000X0000Hoooo00<0003oooooool0;oooo`bZZZX<00003:ZZZP`00002
oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02ooool<00006?ooo``000000oooo`00
0?ooo`0Coooo3@000003oooo0000000003T000000ooo00000000000@000000?oo`00000000004P00
0003oooo0000000000X0000Hoooo00<0003oooooool0;oooo`bZZZX<00003:ZZZP`000000oooo`00
0000000Goooo000Joooo00<0003oooooool0;ooooaP0000Ioooo00<0003oooooool04_ooo`d00000
0oooo`000000001P00000_ooo``0000Hoooo00<0003oooooool0;ooooc2ZZZX2oooo00<0003ooooo
ool05Oooo`006_ooo`030000oooooooo02oooolH00006Oooo`030000oooooooo01;oool=000000?o
ool000000000H@000003oooo0000000000X0000Hoooo00<0003oooooool0;ooooc2ZZZX2oooo00<0
003oooooool05Oooo`006_ooo`030000oooooooo02oooolH00006Oooo`030000oooooooo01;oool=
000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0003oooooool0;ooooc2ZZZX2
oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02oooolH00006Oooo`030000oooooooo
01;oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0003oooooool0;ooo
oc2ZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02oooolH00006Oooo`030000
oooooooo01;oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0003ooooo
ool0;ooooc2ZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02oooolH00006Ooo
o`030000oooooooo01;oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0
003oooooool0;ooooc2ZZZX00oooo`000000000Goooo000Joooo00<0003oooooool0;ooooaP0000I
oooo00<0003oooooool04_ooo`d000000oooo`000000001P00000_ooo``0000Hoooo00<0003ooooo
ool0;ooooc2ZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02oooolH00006Ooo
o`030000oooooooo01;oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0
003oooooool0;ooooc2ZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo02oooolH
00006Oooo`030000oooooooo01;oool=000000?oool000000000H@000003oooo0000000000X0000H
oooo00<0003oooooool0;ooooc2ZZZX2oooo00<0003oooooool05Oooo`005_ooo`<000000oooo`00
0?ooo`0`oooo600001Woool00`000?ooooooo`0Boooo2@0000?oool00`000?ooo`00001R000000?o
ool0000000002P0001Coool3000000?oool0003oool0<?oooc2ZZZX2oooo00<0003oooooool05Ooo
o`005oooo`040000oooooooo0000<OoooaP0000Ioooo00<0003oooooool04_ooo`X000001?ooo`00
00000?ooof<000000oooo`000000000:00005Oooo`040000oooooooo0000<Ooooc2ZZZX2oooo00<0
003oooooool05Oooo`005Oooo`@000000oooo`000?ooo`0`oooo600001Woool00`000?ooooooo`0B
oooo200000Coool00`000?ooooooo`1=000000?oo`000000000040000003ool0oooooooo00`0000C
oooo10000003oooo00000000033oool`ZZZZ00?oool0000000005oooo`005Oooo`030000oooo0000
00;oool00`000?ooooooo`1Poooo00<0003oooooool04_ooo`P000000oooo`000?ooo`02000000?o
ool000000000H@000003oooo0000000000X0000Coooo00<0003oool000000_ooo`030000oooooooo
01Oooom8ZZZZ0_ooo`030000oooooooo01Goool001Koool200000_ooo`030000oooooooo063oool0
0`000?ooooooo`0Boooo2@0000;oool2000000?oool000000000H@000003oooo0000000000X0000D
oooo0P0000;oool00`000?ooooooo`0GooooB:ZZZP;oool00`000?ooooooo`0Eoooo000Goooo00@0
003oooooool0001Roooo00<0003oooooool04_ooo`X000001?ooo`0000000?ooof<000000oooo`00
0000000:00005Oooo`040000oooooooo00006OooodRZZZX2oooo00<0003oooooool05Oooo`006_oo
o`030000oooooooo063oool00`000?ooooooo`0Boooo3@000003oooo00000000064000000oooo`00
0000000:00006?ooo`030000oooooooo01Oooom8ZZZZ0_ooo`030000oooooooo01Goool001[oool0
0`000?ooooooo`1Poooo00<0003oooooool04_ooo`d000000oooo`000000001Q000000?oool00000
00002P0001Soool00`000?ooooooo`0GooooB:ZZZP;oool00`000?ooooooo`0Eoooo000Joooo00<0
003oooooool0H?ooo`030000oooooooo01;oool=000000?oool000000000H00000;oool<00006?oo
o`030000oooooooo01Oooom8ZZZZ00?oool0000000005oooo`006_ooo`030000oooooooo063oool0
0`000?ooooooo`0Boooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000
oooooooo01Oooom8ZZZZ0_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`1Poooo00<0
003oooooool04_ooo`d000000oooo`000000001Q000000?oool0000000002P0001Soool00`000?oo
ooooo`0GooooB:ZZZP;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool0H?ooo`030000
oooooooo01;oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0003ooooo
ool05oooodRZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo063oool00`000?oo
ooooo`0Boooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000oooooooo
01Oooom8ZZZZ0_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`1Poooo00<0003ooooo
ool04_ooo`d000000oooo`000000001Q000000?oool0000000002P0001Soool00`000?ooooooo`0G
ooooB:ZZZP;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool0H?ooo`030000oooooooo
01;oool=000000Coool00000003oo`0B000000?oo`000000000040000003ool00000000001000000
0ooo00000000000@000000?oo`000000000040000003ool0oooooooo00`0000Hoooo00<0003ooooo
ool05oooodRZZZX00oooo`000000000Goooo000Joooo00<0003oooooool08ooooaP0000Hoooo3000
0003oooo0000oooo01?oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0
003oooooool05oooo`bZZZXH00006:ZZZP`00002oooo00<0003oooooool05Oooo`006_ooo`030000
oooooooo02?ooolH00006?ooo``000000oooo`000?ooo`0Coooo3@000003oooo0000000006400000
0oooo`000000000:00006?ooo`030000oooooooo01Ooool<ZZZZ600001RZZZX<00000_ooo`030000
oooooooo01Goool001[oool00`000?ooooooo`0Soooo600001Soool<000000?oool0003oool04ooo
o`d000000oooo`000000001Q000000?oool0000000002P0001Soool00`000?ooooooo`0Goooo3:ZZ
ZQP0000HZZZZ300000;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool08ooooaP0000H
oooo30000003oooo0000oooo01?oool=000000?oool000000000H@000003oooo0000000000X0000H
oooo00<0003oooooool05oooo`bZZZXH00006:ZZZP`00002oooo00<0003oooooool05Oooo`006_oo
o`030000oooooooo02?ooolH00006?ooo``000000oooo`000?ooo`0Coooo3@000003oooo00000000
064000000oooo`000000000:00006?ooo`030000oooooooo01Ooool<ZZZZ600001RZZZX<00000_oo
o`030000oooooooo01Goool001[oool00`000?ooooooo`0Soooo600001Soool<000000?oool0003o
ool04oooo`d000000oooo`000000001P00000_ooo``0000Hoooo00<0003oooooool05oooo`bZZZXH
00006:ZZZP`000000oooo`000000000Goooo000Joooo00<0003oooooool08ooooaP0000Hoooo3000
0003oooo0000oooo01?oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0
003oooooool05oooo`bZZZXH00006:ZZZP`00002oooo00<0003oooooool05Oooo`006_ooo`030000
oooooooo02?ooolH00006?ooo``000000oooo`000?ooo`0Coooo3@000003oooo0000000006400000
0oooo`000000000:00006?ooo`030000oooooooo01Ooool<ZZZZ600001RZZZX<00000_ooo`030000
oooooooo01Goool001[oool00`000?ooooooo`0Soooo600001Soool<000000?oool0003oool04ooo
o`d000000oooo`000000001Q000000?oool0000000002P0001Soool00`000?ooooooo`0Goooo3:ZZ
ZQP0000HZZZZ300000;oool00`000?ooooooo`0Eoooo000Eoooo0P0000?oool00`000?ooooooo`0S
oooo600001Soool<000000?oool0003oool04oooo`P00002oooo0`000003oooo0000000006400000
0oooo`000000000:00004oooo`800003oooo00<0003oooooool05oooo`bZZZXH00006:ZZZP`00002
oooo00<0003oooooool05Oooo`005Oooo`030000oooo000000;oool00`000?ooooooo`0Soooo6000
01Soool<000000?oool0003oool04oooo`P000000oooo`000?ooo`02000000?oool000000000H@00
0003oooo0000000000X0000Coooo00<0003oool000000_ooo`030000oooooooo01Ooool<ZZZZ6000
01RZZZX<00000_ooo`030000oooooooo01Goool001Goool00`000?ooo`000002oooo00<0003ooooo
ool08ooooaP0000Hoooo30000003oooo0000oooo01?oool8000000?oool0003oool00P0000;oool0
0`000?oo0000000g000000?oo`000000000040000003ool00000000001400002oooo300001?oool0
0`000?ooo`000002oooo0P0001Soool<ZZZZ600001RZZZX<000000?oool0000000005oooo`005Ooo
o`800003oooo00<0003oooooool0Doooo``000000oooo`000?ooo`0Coooo200000;oool3000000?o
ool000000000H@000003oooo0000000000X0000Coooo0P0000?oool00`000?ooooooo`17oooo3:ZZ
ZP`00002oooo00<0003oooooool05Oooo`005Oooo`030000oooooooo00;oool00`000?ooooooo`1C
oooo30000003oooo0000oooo01?oool8000000?oool0000000000P000003oooo0000000006400000
0oooo`000000000:00004oooo`030000oooooooo00;oool00`000?ooooooo`17oooo3:ZZZP`00002
oooo00<0003oooooool05Oooo`005_ooo`800002oooo00<0003oooooool0Doooo``000000oooo`00
0?ooo`0Coooo2@0000;oool2000000?oool000000000H@000003oooo0000000000X0000Doooo0P00
00;oool00`000?ooooooo`17oooo3:ZZZP`00002oooo00<0003oooooool05Oooo`006_ooo`030000
oooooooo05?oool<000000?oool0003oool04oooo`d000000oooo`000000001Q000000?oool00000
00002P0001Soool00`000?ooooooo`17oooo3:ZZZP`00002oooo00<0003oooooool05Oooo`006_oo
o`030000oooooooo05?oool<000000?oool0003oool04oooo`d000000oooo`000000001Q000000?o
ool0000000002P0001Soool00`000?ooooooo`17oooo3:ZZZP`00002oooo00<0003oooooool05Ooo
o`006_ooo`030000oooooooo05?oool<000000?oool0003oool04oooo`d000000oooo`000000001P
00000_ooo``0000Hoooo00<0003oooooool0Aoooo`bZZZX<000000?oool0000000005oooo`006_oo
o`030000oooooooo05?oool<000000?oool0003oool04oooo`d000000oooo`000000001Q000000?o
ool0000000002P0001Soool00`000?ooooooo`17oooo3:ZZZP`00002oooo00<0003oooooool05Ooo
o`006_ooo`030000oooooooo05?oool<000000?oool0003oool04oooo`d000000oooo`000000001Q
000000?oool0000000002P0001Soool00`000?ooooooo`17oooo3:ZZZP`00002oooo00<0003ooooo
ool05Oooo`006_ooo`030000oooooooo05?oool<000000?oool0003oool04oooo`d000000oooo`00
0000001Q000000?oool0000000002P0001Soool00`000?ooooooo`17oooo3:ZZZP`00002oooo00<0
003oooooool05Oooo`006_ooo`030000oooooooo05?oool<000000?oool0003oool04oooo`d00000
0oooo`000000001Q000000?oool0000000002P0001Soool00`000?ooooooo`17oooo3:ZZZP`00002
oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo05?oool<000000?oool0003oool04ooo
o`d000000oooo`000000001Q000000?oool0000000002P0001Soool00`000?ooooooo`17oooo3:ZZ
ZP`00002oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo05?oool<000000?oool0003o
ool04oooo`d000000oooo`000000001<000000?oo`00000000004@0000;oool<00006?ooo`030000
oooooooo04Ooool<ZZZZ30000003oooo0000000001Ooool001[oool00`000?ooooooo`1Poooo00<0
003oooooool04_ooo`d000000oooo`000000001Q000000?oool0000000002P0001Soool00`000?oo
ooooo`17oooo6:ZZZP;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool0H?ooo`030000
oooooooo01;oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0003ooooo
ool0AooooaRZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo063oool00`000?oo
ooooo`0Boooo3@000003oooo00000000064000000oooo`000000000:00006?ooo`030000oooooooo
04OooolHZZZZ0_ooo`030000oooooooo01Goool001[oool00`000?ooooooo`1Poooo00<0003ooooo
ool04_ooo`d000000oooo`000000001Q000000?oool0000000002P0001Soool00`000?ooooooo`17
oooo6:ZZZP;oool00`000?ooooooo`0Eoooo000Joooo00<0003oooooool0H?ooo`030000oooooooo
01;oool=000000?oool000000000H@000003oooo0000000000X0000Hoooo00<0003oooooool0Aooo
oaRZZZX2oooo00<0003oooooool05Oooo`006_ooo`030000oooooooo063oool00`000?ooooooo`0B
oooo3@000003oooo0000000006000002oooo300001Soool00`000?ooooooo`17oooo6:ZZZP03oooo
0000000001Ooool001[oool00`000?ooooooo`1Poooo00<0003oooooool04_ooo`d000000oooo`00
0000001Q000000?oool0000000002P0001Soool00`000?ooooooo`17oooo6:ZZZP;oool00`000?oo
ooooo`0Eoooo000Joooo00<0003oooooool0H?ooo`030000oooooooo01;oool=000000?oool00000
0000H@000003oooo0000000000X0000Hoooo00<0003oooooool0AooooaRZZZX2oooo00<0003ooooo
ool05Oooo`006_ooo`030000oooooooo063oool00`000?ooooooo`0Boooo3@000003oooo00000000
064000000oooo`000000000:00006?ooo`030000oooooooo04OooolHZZZZ0_ooo`030000oooooooo
01Goool001Koool01@000?ooooooooooo`00001Roooo00<0003oooooool04_ooo`T000001Oooo`00
000000000?ooo`1S000000?oool0000000002P0001Coool01@000?ooooooooooo`000019oooo6:ZZ
ZP;oool00`000?ooooooo`0Eoooo000Eoooo00<0003oool000000_ooo`030000oooooooo063oool0
0`000?ooooooo`0Boooo20000003oooo0000oooo008000000oooo`000000001Q000000?oool00000
00002P0001?oool00`000?ooo`000002oooo00<0003oooooool0AooooaRZZZX2oooo00<0003ooooo
ool05Oooo`005Oooo`030000oooo000000;oool00`000?ooooooo`1Poooo00<0003oooooool04_oo
o`P000000oooo`000?ooo`0200000_ooodd000000ooo00000000000@000000?oo`3oooooool03000
01?oool00`000?ooo`000002oooo0P0004SooolHZZZZ00?oool0000000005oooo`005_ooo`050000
oooooooooooo000006;oool00`000?ooooooo`0Boooo2@000005oooo000000000000oooo06<00000
0oooo`000000000:00005?ooo`050000oooooooooooo000006?oool00`000?ooooooo`0Eoooo000E
oooo00<0003oool000000_ooof@0000Doooo20000003oooo0000oooo0080001Uoooo300001?oool0
0`000?ooo`000002ooooI@0001Ooool001Koool00`000?ooooooo`1ioooo2@000003oooo00000000
0780000Doooo00<0003oooooool0OOooo`00T_ooogh0002Doooo002BooooOP0009Coool002goool3
00009?ooo`80000looooE`0000?ooolT0000Goooo`<0000boooo000^oooo00<0003oooooool09Ooo
o`030000oooooooo03WooomH000000?oool0000000008`00063oool00`000?ooooooo`0aoooo000O
oooo0`0000;oool5000000Goool0003oool0003oool00`0000;oool300000oooo`80000>oooo0`00
00;oool300000oooo`<00002oooo0`000004oooo0000000000000oooo`80000>oooo0P000003oooo
0000000001[oool800000_ooo`<00003oooo0P0000;oool200000oooo`800003oooo00<0003ooooo
ool00P000003oooo0000000000;oool@00000_ooo`800003oooo2P0000;oool300001Oooo`050000
oooo0000oooo000000?oool200000oooo`<00002oooo3@0000;oool00`000?ooooooo`0700005Ooo
o`<000001?ooo`0000000?ooo`800002oooo0P0000?oool200000_ooo`<000001_ooo`0000000000
0?ooo`0000koool200000_ooo`<0000:oooo0P0000?oool5000000Goool0003oool0003oool00`00
00;oool300000oooo`80000=oooo0P000003oooo0000000001Goool001ooool00`000?ooo`000002
oooo0`000008oooo0000oooo0000oooo0000oooo00000_ooo`040000oooooooo00000oooo`030000
oooooooo00ooool00`000?ooooooo`02oooo00D0003oooooooooool000000_ooo`030000oooo0000
00;oool010000?ooooooo`0000?oool00`000?ooooooo`0>oooo00D0003oooooooooool000006_oo
o`L000001_ooo`0000000?ooo`000?ooo`8000000oooo`000?ooo`02000000Coool00000003oool4
000000Goool000000000003oool00P000003oooo0000oooo014000001?ooo`0000000?ooo`800000
0oooo`000000000;000000?oool0000000000oooo`080000oooo0000oooo0000oooo0000oooo0P00
0004oooo00000000oooo0`000003oooo0000000000d000001Oooo`00000000000?ooo`0700005Ooo
o`030000oooo000000;oool00`000?ooo`000002oooo00<0003oooooool00_ooo`060000oooooooo
0000oooo00001?ooo`040000oooooooo00003Oooo`040000oooooooo00000_ooo`030000oooooooo
00_oool00`000?ooooooo`03000000Soool0003oool0003oool0003oool00002oooo00@0003ooooo
ool00003oooo00<0003oooooool03Oooo`050000oooooooooooo000001Goool0027oool00`000?oo
ooooo`02oooo00T0003oool0003oool0003oool0003oool000000_ooo`040000oooooooo00000ooo
o`<0000?oooo00<0003oooooool00_ooo`050000oooooooooooo000000;oool00`000?ooo`000002
oooo00@0003oooooool00003oooo0`0000ooool300006oooo`L000001_ooo`0000000?ooo`000?oo
o`8000000oooo`000?ooo`05000000?oool0000000000P000005oooo000000000000oooo00800000
0oooo`000?ooo`02oooo3`000004oooo00000000oooo0P000003oooo0000000000X000000oooo`00
00000003000000Woool0003oool0003oool0003oool0003oool00P000004oooo00000000oooo0`00
00?oool>00000oooo`P0000Goooo00<0003oooooool00`0000;oool300000_ooo`030000oooooooo
00;oool00`000?ooooooo`02oooo00@0003oooooool0000=oooo00@0003oooooool00002oooo00<0
003oooooool02_ooo`030000oooooooo00?oool02@000?ooo`000?ooo`000?ooo`000?ooo`000002
oooo00@0003oooooool00003oooo0`0000koool300005_ooo`008?ooo`030000oooooooo00;oool2
000000Koool00000003oool0003oool400000oooo`040000oooooooooooo0`0000koool300000_oo
o`800004oooo1@000004oooo00000000oooo10000004oooo0000000000003oooo`030000oooo0000
01_oool7000000?oool0000000000oooo`030000oooooooo00Coool3000000Coool0000000000002
oooo0P0000Coool200000ooooa000002oooo0P0000?oool;00000_ooo`<00002oooo00H0003ooooo
ool0003oool00004oooo0`000004oooo0000000000000oooo`h000000oooo`000?ooo`0800005_oo
o`060000oooooooooooo0000oooo0P000005oooo000000000000oooo00@00002oooo0`0000;oool3
00003oooo`800002oooo0`0000_oool200000oooo`8000001_ooo`0000000?ooo`000?ooo`@00003
oooo00@0003oooooooooool300003_ooo`030000oooo000001Koool001ooool00`000?ooo`00000B
oooo00<0003oooooool04oooo`030000oooooooo02Soool00`000?ooooooo`0Joooo1`000004oooo
00000000oooo1P000003oooo0000000000<000000oooo`000000000S000000?oool0000000007P00
0003oooo0000000001<000000oooo`000000000700005Oooo`030000oooo000000;oool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`030000oooooooo01Coool00`000?ooooooo`0Noooo00<0
003oooooool04oooo`030000oooooooo01Goool001ooool300004Oooo`80000Foooo00D0003ooooo
ooooool000009?ooo`80000Loooo200000;oool<00000_ooo`@000000oooo`000000000O000000?o
ool000000000700000;ooolD00000_ooo`T0000Eoooo0`000003oooo0000000001;oool200005ooo
o`030000oooooooo01coool200005?ooo`80000Goooo002BooooOP0009Coool009;ooomn0000U?oo
o`00T_ooogh0002Doooo002BooooOP0009Coool00?oooonUoooo003oooooYOooo`00\
\>"],
  ImageRangeCache->{{{0, 419}, {130.25, 0}} -> {-0.0833292, -0.0234425, 
  0.00755766, 0.00755766}, {{11, 135.063}, {127.125, 
  3.0625}} -> {-2.35203, -1.27594, 0.0834555, 0.0834555}, {{147.438, 271.5}, {
  127.125, 3.0625}} -> {-5.53086, -1.32666, 0.0526611, 0.0842575}, {{283.875, 
  407.938}, {127.125, 3.0625}} -> {-24.9043, -1.27594, 0.0834555, 0.0834555}}]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{484, 426},
WindowMargins->{{0, Automatic}, {Automatic, 5}},
ShowCellLabel->False
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 180, 5, 102, "Input"],
Cell[1892, 56, 267, 7, 30, "Input"],
Cell[2162, 65, 630, 14, 336, "Input"],
Cell[2795, 81, 141, 3, 30, "Input"],
Cell[2939, 86, 205, 4, 70, "Input"],
Cell[3147, 92, 272, 7, 30, "Input"],
Cell[3422, 101, 414, 12, 210, "Input"],
Cell[3839, 115, 833, 23, 30, "Input"],
Cell[4675, 140, 872, 24, 462, "Input"],
Cell[5550, 166, 273, 7, 30, "Input"],
Cell[5826, 175, 3966, 80, 1104, "Input"],
Cell[9795, 257, 557, 15, 30, "Input"],
Cell[10355, 274, 387, 12, 152, "Input"],
Cell[10745, 288, 183, 5, 54, "Input"],
Cell[10931, 295, 334, 9, 110, "Input"],
Cell[11268, 306, 236, 7, 82, "Input"],
Cell[11507, 315, 131, 3, 30, "Input"],
Cell[11641, 320, 1201, 28, 376, "Input"],
Cell[12845, 350, 694, 19, 30, "Input"],
Cell[13542, 371, 546, 16, 194, "Input"],
Cell[14091, 389, 516, 15, 30, "Input"],
Cell[14610, 406, 335, 9, 30, "Input"],
Cell[14948, 417, 339, 5, 170, "Input"],

Cell[CellGroupData[{
Cell[15312, 426, 158, 3, 70, "Input"],
Cell[15473, 431, 23959, 608, 296, 5161, 371, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[39447, 1042, 1280, 22, 660, "Input"],

Cell[CellGroupData[{
Cell[40752, 1068, 87, 2, 48, "Input"],
Cell[40842, 1072, 71, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40950, 1078, 372, 9, 156, "Input"],
Cell[41325, 1089, 40984, 1489, 140, 16276, 1179, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[82324, 2581, 272, 7, 30, "Input"],
Cell[82599, 2590, 71667, 1125, 31710, "Input",
  Evaluatable->True],
Cell[154269, 3717, 111, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[154405, 3723, 148, 5, 84, "Input"],
Cell[154556, 3730, 88435, 1862, 296, 40095, 1261, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[243006, 5595, 1280, 22, 660, "Input"],

Cell[CellGroupData[{
Cell[244311, 5621, 75, 0, 30, "Input"],
Cell[244389, 5623, 70, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[244496, 5629, 140, 4, 66, "Input"],
Cell[244639, 5635, 68134, 2163, 296, 28673, 1671, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[312810, 7803, 130, 4, 48, "Input"],
Cell[312943, 7809, 85199, 1824, 296, 40135, 1263, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[398179, 9638, 77, 0, 48, "Input"],
Cell[398259, 9640, 70, 1, 29, "Output"]
}, Open  ]],
Cell[398344, 9644, 140, 4, 66, "Input"],
Cell[398487, 9650, 140, 4, 48, "Input"],
Cell[398630, 9656, 336, 9, 30, "Input"],
Cell[398969, 9667, 339, 5, 170, "Input"],

Cell[CellGroupData[{
Cell[399333, 9676, 261, 8, 120, "Input"],
Cell[399597, 9686, 24797, 618, 296, 5161, 371, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[424431, 10309, 87, 2, 48, "Input"],
Cell[424521, 10313, 71, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[424629, 10319, 372, 9, 156, "Input"],
Cell[425004, 10330, 41560, 1502, 140, 16439, 1188, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

