(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    706847,      13524]*)
(*NotebookOutlinePosition[    707498,      13547]*)
(*  CellTagsIndexPosition[    707454,      13543]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    StyleBox[\(Discrete\ Fourier\ Transform\ \((2\ dimension)\)\),
      FontVariations->{"Underline"->True}]], "Input"],

Cell[BoxData[
    \(\(fukuzawa3 = Table[fukuzawa[\([i, j]\)], {i, 20, 147}, {j, 10, 137}]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ 128\[Times]128\ simple\)], "Input"],

Cell[BoxData[
    \(\(sample = fukuzawa3; \)\)], "Input"],

Cell[CellGroupData[{

Cell["size=Dimensions[sample]", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \({128, 128}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SamplePhoto=ListDensityPlot[sample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Sample Photo\"];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`02oooo100000coool700001_ooo`800006oooo0P00
00;oool200000_ooo`l00006oooo0P0000Coool200001?ooo`800008oooo1@0000;oool@00000_oo
o`800002oooo3@0000;oool400001?ooo`X00002oooo0P0000Coool300001_ooo`800002oooo0P00
00Coool200001?ooo`H00002oooo10000003oooo0000000000800002oooo0P0000Coool:00000_oo
o`@00006oooo0`0001Goool00`000?ooooooo`02oooo000Aoooo00<0003oool000001?ooo`030000
oooooooo00;oool400003?ooo`L00006oooo0P0000Koool200000_ooo`800002oooo3`0000Koool2
00001?ooo`800004oooo0P0000Soool500000_oooa000002oooo0P0000;oool=00000_ooo`@00004
oooo2P0000;oool200001?ooo`<00006oooo0P0000;oool200001?ooo`800004oooo1P0000;oool4
000000?oool0000000000P0000;oool200001?ooo`X00002oooo100000Koool300005Oooo`030000
oooooooo00;oool001;oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`@00004oooo1P00
00;oool200001Oooo`800004oooo0P0000;oool200001?ooo`X00002oooo0P0000?oool:00001?oo
o`@00004oooo4`0000;oool200000_ooo`H00002oooo0P0000;oool400001oooo`@00002oooo0P00
00Koool600000_ooo`@00002oooo0P00017oool200001_ooo`80000:oooo0P0000?oool600001_oo
o`@0000:oooo100000;oool00`000?ooooooo`04oooo0P0000Koool200001oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooo100000Coool600000_ooo`800005oooo0P0000Coool2
00000_ooo`800004oooo2P0000;oool200000oooo`X00004oooo100000CooolC00000_ooo`800002
oooo1P0000;oool200000_ooo`@00007oooo100000;oool200001_ooo`H00002oooo100000;oool2
00004Oooo`800006oooo0P0000[oool200000oooo`H00006oooo100000[oool400000_ooo`030000
oooooooo00Coool200001_ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool200000_ooo`800002oooo100000;oool500001?ooo`800002oooo0P0000Soool200000_oo
o`P00004oooo1@0000Soool400002?ooo`@00002oooo100000?oool400001?ooo`H00004oooo0P00
00;oool200001?ooo`@00003oooo0P0000Soool200000_ooo`H00002oooo0P0000;oool200001ooo
o`H00006oooo3P0000;oool200002Oooo`800002oooo0P0000;oool400000_ooo`X00002oooo1@00
00;oool:00000_ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool2
00000_ooo`800002oooo100000;oool500001?ooo`800002oooo0P0000Soool200000_ooo`P00004
oooo1@0000Soool400002?ooo`@00002oooo100000?oool400001?ooo`H00004oooo0P0000;oool2
00001?ooo`@00003oooo0P0000Soool200000_ooo`H00002oooo0P0000;oool200001oooo`H00006
oooo3P0000;oool200002Oooo`800002oooo0P0000;oool400000_ooo`X00002oooo1@0000;oool:
00000_ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool200000_oo
o`800006oooo0P0000Coool00`000?ooooooo`02oooo1P0000;oool400000_ooo`P00004oooo0P00
00;oool300000_ooo`X00004oooo200000;oool;00000_ooo`P00002oooo100000Coool800000_oo
o`L00002oooo300000;oool400000_ooo`P00003oooo0P0000;oool400000_ooo`@00002oooo1P00
00Coool900001_ooo`800002oooo1P0000;oool200000_ooo`X000000oooo`0000000002oooo1P00
00;oool200002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo0P0000;oool2
00001_ooo`800004oooo00<0003oooooool00_ooo`H00002oooo100000;oool800001?ooo`800002
oooo0`0000;oool:00001?ooo`P00002oooo2`0000;oool800000_ooo`@00004oooo200000;oool7
00000_ooo``00002oooo100000;oool800000oooo`800002oooo100000;oool400000_ooo`H00004
oooo2@0000Koool200000_ooo`H00002oooo0P0000;oool:000000?oool0000000000_ooo`H00002
oooo0P0000Woool00`000?ooooooo`02oooo000Hoooo0P0000?oool800000_ooo`800006oooo1`00
00Koool600003_ooo`D00006oooo2P0000;oool600000_ooo`800005oooo100000;oool200001?oo
o`800002oooo0P0000;oool200001?ooo`800002oooo0P0000;oool200000oooo`H00002oooo1P00
00Koool200001_ooo`/00006oooo100000;oool800000_ooo`800009oooo1P0000;oool<00001?oo
o`800002oooo0P000003oooo0000000000Koool200001?ooo`800006oooo0P0000Coool001Soool0
0`000?ooooooo`02oooo200000;oool200001_ooo`L00006oooo1P0000koool500001_ooo`X00002
oooo1P0000;oool200001Oooo`@00002oooo0P0000Coool200000_ooo`800002oooo0P0000Coool2
00000_ooo`800002oooo0P0000?oool600000_ooo`H00006oooo0P0000Koool;00001_ooo`@00002
oooo200000;oool200002Oooo`H00002oooo300000Coool200000_ooo`8000000oooo`0000000006
oooo0P0000Coool200001oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo1000
00Coool200001_ooo`<00002oooo0P0000Coool200002_ooo`P00004oooo0P0000?oool400000_oo
o`H00002oooo0P0000Coool?00001_ooo``00002oooo100000;oool200001?ooo`800005oooo0P00
00;oool200000_ooo`800002oooo0P0000;oool200001?ooo`800004oooo0P000003oooo00000000
00X00008oooo100000Coool=00001_ooo`@00004oooo100000;oool200000_ooo`@00003oooo0P00
00Coool200001?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool4
00001?ooo`800006oooo0`0000;oool200001?ooo`80000:oooo200000Coool200000oooo`@00002
oooo1P0000;oool200001?ooo`l00006oooo300000;oool400000_ooo`800004oooo0P0000Goool2
00000_ooo`800002oooo0P0000;oool200000_ooo`800004oooo0P0000Coool2000000?oool00000
00002P0000Soool400001?ooo`d00006oooo100000Coool400000_ooo`800002oooo100000?oool2
00001?ooo`800004oooo0P0000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool02?oo
o`800002oooo0P0000;oool4000000?oool0000000000_ooo`X00002oooo100000;oool200002_oo
o`D00006oooo0P0000Coool600002_ooo`<00006oooo2P0000;oool600000_ooo`800002oooo2`00
00;oool200000_ooo`@00004oooo0P0000Coool200002?ooo`<00002oooo0P0000;oool200000_oo
o`800004oooo0P0000Koool200000_ooo`@0000?oooo100000Soool200001?ooo`D00006oooo1P00
00;oool200001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08oooo0P0000;oool2
00000_ooo`@000000oooo`0000000002oooo2P0000;oool400000_ooo`80000:oooo1@0000Koool2
00001?ooo`H0000:oooo0`0000Koool:00000_ooo`H00002oooo0P0000;oool;00000_ooo`800002
oooo100000Coool200001?ooo`800008oooo0`0000;oool200000_ooo`800002oooo0P0000Coool2
00001_ooo`800002oooo100000ooool400002?ooo`800004oooo1@0000Koool600000_ooo`800005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Coool600001?ooo`H00003oooo0P00
00;oool200000_ooo`P00002oooo100000Coool200001?ooo`<00006oooo6P000003oooo00000000
00;oool600002_ooo`@00002oooo0P0000Coool4000000?oool0000000001_ooo`800004oooo1P00
00;oool200000_ooo`800004oooo0`0000Koool<00001_ooo`800002oooo0P0000;oool200000ooo
o`P00004oooo0P0000;oool>00000_ooo`030000oooooooo00coool200001oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`04oooo1P0000Coool600000oooo`800002oooo0P0000;oool8
00000_ooo`@00004oooo0P0000Coool300001_oooaX000000oooo`0000000002oooo1P0000[oool4
00000_ooo`800004oooo10000003oooo0000000000Koool200001?ooo`H00002oooo0P0000;oool2
00001?ooo`<00006oooo300000Koool200000_ooo`800002oooo0P0000?oool800001?ooo`800002
oooo3P0000;oool00`000?ooooooo`0<oooo0P0000Ooool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool03_ooo`800009oooo0P0000;oool200001?ooo`800004oooo0P0000Koool400000_oo
o`030000oooooooo00@00002oooo0P0000;oool400002?ooo`P00002oooo00<0003oooooool01?oo
o`800004oooo0P0000;oool200000_ooo`H00004oooo0P0000;oool200001Oooo`P00002oooo0P00
00Soool200001_ooo`L00008oooo0P0000;oool400000_ooo`P0000;oooo0P0000;oool400000_oo
o`H00002oooo0P0000;oool600000oooo`P00002oooo1P0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooob<00002ooooEP00027oool200000_ooo`<0000:oooo0P0000coool2
00001_ooo`<00004oooo0P0000[oool200001?ooo`800004oooo0P0000Woool400000_ooo`H00005
oooo00<0003oooooool00_ooo`006?ooo`800003oooo8`0000;ooomF00008Oooo`800002oooo0`00
00[oool200003?ooo`800006oooo0`0000Coool200002_ooo`800004oooo0P0000Coool200002Ooo
o`@00002oooo1P0000Coool200001?ooo`006?ooo`030000oooooooo00;oool800002?ooobD00000
0oooo`000000000H00000_ooobh00004oooo7@0000;ooom100000oooo`800006oooo0P0000;oool2
00002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200000SooolU000000?o
ool000000000600000;oool^00001?oooad00002oooo@@0000?oool200001_ooo`800002oooo0P00
00Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooocH00002oooo1P0000Soool4
00001?ooo`80000;oooo1P0000;oool200001_ooo`H00002oooo100000Koool00`000?ooooooo`02
oooo2P0000Koool800000_ooo`@000000oooo`000000000400001?ooo`@00002ooooB00000Goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooocH00002oooo1P0000Soool400001?oo
o`80000;oooo1P0000;oool200001_ooo`H00002oooo100000Koool00`000?ooooooo`02oooo2P00
00Koool800000_ooo`@000000oooo`000000000400001?ooo`@00002ooooB00000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooobT00002oooo2`0000;oool400007?ooo`L00002
oooo0P0000;oool200002?ooo`l00002oooo100000;oool800002?ooo`800006oooo0P0000?oool8
00001?ooodX00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooolY00000_oo
o`/00002oooo100001coool700000_ooo`800002oooo0P0000Soool?00000_ooo`@00002oooo2000
00Soool200001_ooo`800003oooo200000Cooom:00001Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`02oooo;@0000;oool600000oooo``00002oooo1P00017oool800001?ooo`P00002
oooo100000;oool500001_ooo`800004oooo0P0000Coool>00000_ooo`T00002oooo6@0000;oool2
00000_ooo`800006oooo0P0000[ooolK00001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo;@0000;oool600000oooo``00002oooo1P00017oool800001?ooo`P00002oooo1000
00;oool500001_ooo`800004oooo0P0000Coool>00000_ooo`T00002oooo6@0000;oool200000_oo
o`800006oooo0P0000[ooolK00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo200000Koool400000oooob<00002oooo3P0000;oool600001?ooo`800009oooo0P0000;oool2
00001?ooo`800002oooo100000Soool900001?ooo`800002oooo1P0000Soool/00000_ooo`80000H
oooo0P0000Ooool200003?ooo`800005oooo00<0003oooooool00_ooo`006?ooo`800003oooo2000
00Koool400000oooob<00002oooo3P0000;oool600001?ooo`800009oooo0P0000;oool200001?oo
o`800002oooo100000Soool900001?ooo`800002oooo1P0000Soool/00000_ooo`80000Hoooo0P00
00Ooool200003?ooo`800004oooo0P0000Coool001Soool00`000?ooooooo`02oooo;`0000_oool@
00000_ooo`@00004oooo2@0001;oool400000_ooo`@00002oooo3@0000Coool400000_ooo`800002
oooo6@0000;ooolC00000_ooo`80000@oooo100000Coool200001oooo`800008oooo0P0000Woool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooobl0000;oooo400000;oool400001?oo
o`T0000Boooo100000;oool400000_ooo`d00004oooo100000;oool200000_oooaT00002oooo4`00
00;oool200004?ooo`@00004oooo0P0000Ooool200002?ooo`800009oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;ooola00000_ooo`<00006oooo600003;oool200003?oooa/00004
oooo5@0000Koool<00001_ooo`@00002oooo1`0000Coool400002Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo<@0000;oool300001_oooaP0000boooo0P0000cooolK00001?oo
oaD00006oooo300000Koool400000_ooo`L00004oooo100000Woool00`000?ooooooo`02oooo000H
oooo00<0003oooooool02_oooa/00002oooo0P0000;oool400002?ooo`030000oooooooo00Koool4
00003?ooo`800002oooo0P0004Koool200001?ooo`030000oooooooo00800008oooo0P0000SooolA
00002_ooo`800002oooo100000Koool200001?ooo`D00004oooo0P0000;oool200002Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0:oooo6`0000;oool200000_ooo`@00008oooo00<0
003oooooool01_ooo`@0000<oooo0P0000;oool20000A_ooo`800004oooo00<0003oooooool00P00
00Soool200002?oooa40000:oooo0P0000;oool400001_ooo`800004oooo1@0000Coool200000_oo
o`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool600002?oooa/00002
oooo0P0000Woool200006_ooo`80000Eoooo0P0002goool200004oooo`800002oooo0P0000Soool=
00002_ooo`800002oooo100000Koool200001oooo`800008oooo0P0000Woool00`000?ooooooo`02
oooo000<oooo0`0000?oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`H00008oooo6`00
00;oool200002Oooo`80000Joooo0P0001Goool20000;Oooo`80000Coooo0P0000;oool200002?oo
o`d0000:oooo0P0000;oool400001_ooo`800007oooo0P0000Soool200002Oooo`030000oooooooo
00;oool000coool00`000?ooooooo`02oooo00<0003oool000001?ooo`030000oooooooo00;oool6
00002?oooa<0000aoooo0P0000_oool200002?ooo`@0000Soooo0P0000;oool200005oooo`80000>
oooo3@0002Woool200002Oooo`030000oooooooo00;oool000goool01`000?ooooooooooo`000?oo
o`000004oooo0`0000;oool600002?oooa<0000aoooo0P0000_oool200002?ooo`@0000Soooo0P00
00;oool200005oooo`80000>oooo3@0002Woool200001oooo`<00004oooo000=oooo00L0003ooooo
ooooool0003oool000001?ooo`030000oooooooo00;oool600002?ooo`L0000:oooo0P0000[oool2
00003oooo`80000Doooo0P0000Ooool200001?ooo`80000:oooo0P0002Goool200000_ooo`@0000=
oooo0P0000Coool200002?ooo`800004oooo3@0000Coool400000_ooo`@00006oooo100000Goool4
00001_ooo`800009oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?oo
o`000004oooo00<0003oooooool00_ooo`H00008oooo1`0000[oool200002_ooo`80000?oooo0P00
01Coool200001oooo`800004oooo0P0000[oool200009Oooo`800002oooo100000goool200001?oo
o`800008oooo0P0000Coool=00001?ooo`@00002oooo100000Koool400001Oooo`@00006oooo0P00
00Woool00`000?ooooooo`02oooo000=oooo00<0003oooooool00_ooo`030000oooooooo00?oool0
0`000?ooooooo`02oooo1P0000Coool900001_ooo`H00008oooo0P0000;oool200000_ooo`800005
oooo100001Soool200001Oooo`800004oooo0P0000;oool200001_ooo`80000:oooo0P0000;oool2
00005oooo`800002oooo100000_oool200001_ooo`H0000Aoooo500000Koool400000_ooo`030000
oooooooo00@00006oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`H00004oooo2@0000Koool600002?ooo`800002oooo0P0000;oool200001Oooo`@0000Hoooo0P00
00Goool200001?ooo`800002oooo0P0000Koool200002_ooo`800002oooo0P0001Ooool200000_oo
o`@0000;oooo0P0000Koool600004Ooooa@00006oooo100000;oool00`000?ooooooo`0400001_oo
o`@00007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool600000_ooo`X00009
oooo0P0000Soool600001?ooo`80000Qoooo0P0000Goool200002?ooo`800008oooo0P0000coool2
00004oooo`800004oooo1P0000Woool800001?ooo`@00004oooo0P0000;oool200002oooo`@00002
oooo100000Coool400001?ooo`@00005oooo0P0000Soool400001oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo1P0000;oool:00002Oooo`800008oooo1P0000Coool200008Ooo
o`800005oooo0P0000Soool200002?ooo`80000<oooo0P0001?oool200001?ooo`H00009oooo2000
00Coool400001?ooo`800002oooo0P0000_oool400000_ooo`@00004oooo100000Coool400001Ooo
o`800008oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`h0000;
oooo0P0000;oool200003?ooo`@0000Soooo0P0000ooool200002?ooo`800008oooo0P0000Coool0
0`000?ooooooo`0<oooo100000Coool800001oooo`800006oooo0P0000Koool600005Oooo`800004
oooo1P0000Coool600001Oooo`@00006oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_ooo`h0000;oooo0P0000;oool200003?ooo`@0000Soooo0P0000ooool200002?oo
o`800008oooo0P0000Coool00`000?ooooooo`0<oooo100000Coool800001oooo`800006oooo0P00
00Koool600005Oooo`800004oooo1P0000Coool600001Oooo`@00006oooo100000Ooool00`000?oo
ooooo`02oooo000Hoooo0P0000?oool:00004oooo`800002oooo100000Koool200002oooo`80000H
oooo0P00017oool200002?ooo`80000:oooo0`0001Koool800001Oooo`H00004oooo0P0000Koool6
00001_ooo`@0000Eoooo100000Coool400000oooo`80000:oooo0P0000Soool200001?ooo`006?oo
o`030000oooooooo00;oool>00004Oooo`H0000Coooo0P0001Soool200006oooo`@0000:oooo00<0
003oooooool03_ooo`@00004oooo200000goool200001_ooo`@00008oooo0P0000Goool800003?oo
o`X0000?oooo0P0000Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`h0000A
oooo1P0001?oool200006?ooo`80000Koooo100000[oool00`000?ooooooo`0>oooo100000Coool8
00003Oooo`800006oooo100000Soool200001Oooo`P0000<oooo2P0000ooool200002Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo0P0000;oool400000_ooo`800004oooo1@00
00Koool800000_ooo`800002oooo0P0002Ooool200006oooo`@0000Soooo200000Woool200003?oo
o`@00004oooo0P0000Coool00`000?ooooooo`02oooo1P0000coool:00000oooo`800008oooo1000
00Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`800002oooo100000;oool2
00001?ooo`D00006oooo200000;oool200000_ooo`80000Woooo0P0001_oool400008oooo`P00009
oooo0P0000coool400001?ooo`800004oooo00<0003oooooool00_ooo`H0000<oooo2P0000?oool2
00002?ooo`@00009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool200000_oo
o`80000:oooo0P000003oooo0000000000Coool:00000_ooo`@0000?oooo0P0001Koool400007Ooo
o`80000Qoooo2P0000Woool200000_ooo`800008oooo0P0000;oool200003oooo`800006oooo1000
00Koool200000_ooo`/00006oooo100000Woool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`800002oooo0P0000[oool2000000?oool0000000001?ooo`X00002oooo100000ooool2
00005_ooo`@0000Moooo0P00027oool:00002Oooo`800002oooo0P0000Soool200000_ooo`80000?
oooo0P0000Koool400001_ooo`800002oooo2`0000Koool400002Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`04oooo0P0000coool2000000?oool0000000000_ooo`@00002oooo0P00
00Koool40000:Oooo`80000Koooo0P0000;oool200001_ooo`<0000Doooo0P0000;oool400001_oo
o`030000oooooooo00800002oooo100000[oool400002?ooo`80000Koooo2`0000Coool:00001ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`04oooo0P0000coool2000000?oool00000
00000_ooo`@00002oooo0P0000Koool40000:Oooo`80000Koooo0P0000;oool200001_ooo`<0000D
oooo0P0000;oool400001_ooo`030000oooooooo00800002oooo100000[oool400002?ooo`80000K
oooo2`0000Coool:00001oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08oooo0P00
00;oool200000_ooo`D00002oooo100000Coool200002_ooo`80000Woooo0P0001goool400002Ooo
o`80000Boooo0P0000Koool200001?ooo`030000oooooooo00Koool200002?ooo`@00002oooo0P00
01_oool200002?ooo`800004oooo3`0000Woool00`000?ooooooo`02oooo000Hoooo0P0000Woool2
00000_ooo`800002oooo1@0000;oool400001?ooo`80000:oooo0P0002Ooool200007Oooo`@00009
oooo0P0001;oool200001_ooo`800004oooo00<0003oooooool01_ooo`800008oooo100000;oool2
00006oooo`800008oooo0P0000Coool?00002?ooo`800004oooo000Hoooo00<0003oooooool02?oo
o`@00004oooo0P0000?oool600003_ooo`80000=oooo0P0001Koool400007Oooo`800002oooo1000
00Ooool200006?ooo`80000?oooo0P0000Soool400000_ooo`800004oooo0P0000ooool400003?oo
o`d00002oooo100000Coool200001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08
oooo100000Coool200000oooo`H0000>oooo0P0000goool200005_ooo`@0000Moooo0P0000;oool4
00001oooo`80000Hoooo0P0000ooool200002?ooo`@00002oooo0P0000Coool200003oooo`@0000<
oooo3@0000;oool400001?ooo`800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool200001_ooo`800006oooo1@00013oool200009oooo`@0000Goooo0P0000;oool200004Ooo
o`80000Doooo100000ooool200002?ooo`800008oooo0P0000;oool300000_ooo`800008oooo1000
00[oool200000_oooa400004oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`800006oooo0P0000Koool500004?ooo`80000Woooo100001Ooool200000_ooo`80000A
oooo0P0001Coool400003oooo`800008oooo0P0000Soool200000_ooo`<00002oooo0P0000Soool4
00002_ooo`800002oooo4@0000Coool200001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`08oooo1P0000;oool500002_ooo`800006oooo100001ooool200001_ooo`800007oooo1000
01[oool200001oooo`80000<oooo0P00017oool400001?ooo`80000<oooo0P0000;oool200008Ooo
oa400004oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool02?ooo`H00002
oooo1@0000[oool200001_ooo`@0000Ooooo0P0000Koool200001oooo`@0000Joooo0P0000Ooool2
00003?ooo`80000Aoooo100000Coool200003?ooo`800002oooo0P00027ooolA00001?ooo`@00007
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Koool200000_ooo`800002oooo1000
00_oool200001_ooo`80000[oooo0P0000Ooool200002?ooo`80000Boooo100001Goool200001_oo
o`800004oooo0P0000Goool200000_ooo`80000:oooo100000;oool200000_ooo`@0000?oooo0P00
00[oool?00002?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Koool2
00000_ooo`800002oooo100000_oool200001_ooo`80000[oooo0P0000Ooool200002?ooo`80000B
oooo100001Goool200001_ooo`800004oooo0P0000Goool200000_ooo`80000:oooo100000;oool2
00000_ooo`@0000?oooo0P0000[oool?00002?ooo`800007oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00Coool400001_ooo`800009oooo0P0000Coool200005?ooo`8000000oooo`00
0000000Boooo0P0000;oool400002Oooo`800002oooo0P0000;oool200004_ooo`@00007oooo0P00
00coool800007Oooo`@00002oooo0P0000Coool200003Oooo`@00002oooo0P0000Coool;00000_oo
o`@00002oooo200000Ooool00`000?ooooooo`02oooo000Hoooo0P0000Goool400001_ooo`800009
oooo0P0000Coool200005?ooo`8000000oooo`000000000Boooo0P0000;oool400002Oooo`800002
oooo0P0000;oool200004_ooo`@00007oooo0P0000coool800007Oooo`@00002oooo0P0000Coool2
00003Oooo`@00002oooo0P0000Coool;00000_ooo`@00002oooo200000Koool200001?ooo`006?oo
o`030000oooooooo00;oool800002oooo`H00006oooo0P0000Coool400002_ooo`80000Aoooo0P00
00;oool200000_ooo`@0000;oooo0P0000;oool200002_ooo`80000<oooo0P0000Goool200000_oo
o`800008oooo0P0002Woool400000_ooo`8000000oooo`0000000006oooo100000;oool400000_oo
o`800002oooo3`0000Coool200001?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool800002oooo`H00006oooo0P0000Coool400002_ooo`80000Aoooo0P0000;oool2
00000_ooo`@0000;oooo0P0000;oool200002_ooo`80000<oooo0P0000Goool200000_ooo`800008
oooo0P0002Woool400000_ooo`8000000oooo`0000000006oooo100000;oool400000_ooo`800002
oooo3`0000Coool200001?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00Coool600002oooo`@00006oooo0P0000;oool600003oooo`80000>oooo300000Koool300003_oo
o`80000@oooo0P0000Goool200002_ooo`800008oooo0P0000Coool200001oooo`80000:oooo0P00
00Koool800005ooooa400004oooo0P0000Coool200001oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`04oooo1P0000_oool400001_ooo`800002oooo1P0000ooool200003_ooo``00006
oooo0`0000koool200004?ooo`800005oooo0P0000[oool200002?ooo`800004oooo0P0000Ooool2
00002_ooo`800006oooo200001OooolA00001?ooo`800004oooo0P0000Ooool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool01_ooo`80000?oooo0P0000Koool200005?ooo`80000Aoooo0P00
00;oool800001oooo`800004oooo100000;oool400008oooo`80000Soooo0P0000Soool900000_oo
o`@00004oooo200000CooolO00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`06
oooo0P0000ooool200001_ooo`80000Doooo0P00017oool200000_ooo`P00007oooo0P0000Coool4
00000_ooo`@0000Soooo0P0002?oool200002?ooo`T00002oooo100000Coool800001?oooal00005
oooo00<0003oooooool00_ooo`003Oooo`<00002oooo00<0003oooooool00oooo`030000oooooooo
00Coool200003oooo`H00002oooo0P0000;oool200001?ooo`80000<oooo0P0001?oool200000_oo
o`H00006oooo0`0000Coool200001?ooo`@0000Doooo00<0003oooooool04?ooo`80000:oooo0P00
01?oool200001_ooo`/00002oooo0P0000Soool400001_ooo``000000oooo`000000000200000_oo
o`@00002oooo100000Ooool00`000?ooooooo`02oooo000>oooo00H0003oooooool0003oool00004
oooo00<0003oooooool01?ooo`80000?oooo1P0000;oool200000_ooo`800004oooo0P0000coool2
00004oooo`800002oooo1P0000Koool300001?ooo`800004oooo100001Coool00`000?ooooooo`0@
oooo0P0000[oool200004oooo`800006oooo2`0000;oool200002?ooo`@00006oooo30000003oooo
0000000000800002oooo100000;oool400001oooo`030000oooooooo00;oool000coool4000000Co
ool0003oool00004oooo0`0000coool200000_ooo`@00003oooo0P0000Koool200001_ooo`80000?
oooo0P0001Coool800001oooo`800006oooo0P0000koool200002Oooo`80000>oooo0P00027oool2
00002?ooo`H0000=oooo1P0000CooolC00000_ooo`@00002oooo1P0000?oool300001?ooo`003?oo
o`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool03?ooo`800002oooo1000
00?oool200001_ooo`800006oooo0P0000ooool200005?ooo`P00007oooo0P0000Koool200003_oo
o`800009oooo0P0000koool200008Oooo`800008oooo1P0000goool600001?oooa<00002oooo1000
00;oool600001Oooo`030000oooooooo00;oool000goool200000_ooo`030000oooo000000Coool0
0`000?ooooooo`0<oooo0P0000Koool900001?ooo`@00002oooo0P0002Ooool600001?ooo`030000
oooooooo013oool200001?ooo`@00008oooo0`0000Coool400001_ooo`80000:oooo0P0000Woool4
00001_ooo`800008oooo0P0000;oool200001?ooo`D00006oooo100000KooolQ00001Oooo`030000
oooooooo00;oool000koool01@000?ooooooooooo`000005oooo00<0003oooooool01_ooo`800006
oooo0P0000Goool400002?ooo`800002oooo100000ooool200004_ooo`@00004oooo0P0000Coool0
0`000?ooooooo`04oooo0P0000;oool400002_ooo`80000;oooo100000;oool400001_ooo`80000E
oooo100000Koool200001?ooo`800002oooo0P0000;oool200001Oooo`H00004oooo1P0000;ooolI
00001?ooo`800002oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_oo
o`800006oooo0P0000Goool400002?ooo`800002oooo100000ooool200004_ooo`@00004oooo0P00
00Coool00`000?ooooooo`04oooo0P0000;oool400002_ooo`80000;oooo100000;oool400001_oo
o`80000Eoooo100000Koool200001?ooo`800002oooo0P0000;oool200001Oooo`H00004oooo1P00
00;ooolI00001?ooo`800002oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool01_ooo`800004oooo100000Coool00`000?ooooooo`02oooo0P0000Coool800009oooo`@00002
oooo0P0000;oool200001Oooo`@0000Boooo100000Koool300000_ooo`800002oooo0P0000coool2
00004Oooo`800004oooo0P0000;oool200001?ooo`800004oooo0P0000Goool600001?ooo`H00004
oooo300000;oool900001_ooo`@00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00Koool200001?ooo`@00004oooo00<0003oooooool00_ooo`800004oooo200002Ooool400000_oo
o`800002oooo0P0000Goool400004_ooo`@00006oooo0`0000;oool200000_ooo`80000<oooo0P00
017oool200001?ooo`800002oooo0P0000Coool200001?ooo`800005oooo1P0000Coool600001?oo
o``00002oooo2@0000Koool400001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08
oooo0P0000;oool400001?ooo`L00004oooo0P0000;oool40000:Oooo`800002oooo0P0000Goool2
00000_ooo`@0000Ooooo1P0002Ooool200002_ooo`800002oooo100000;oool00`000?ooooooo`04
00000_ooo`800002oooo0P0000;oool>00001oooo`H00002oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool02?ooo`800002oooo100000Coool700001?ooo`800002oooo1000
02Woool200000_ooo`800005oooo0P0000;oool400007oooo`H0000Woooo0P0000[oool200000_oo
o`@00002oooo00<0003oooooool0100000;oool200000_ooo`800002oooo3P0000Ooool600000_oo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00coool400001?ooo`<00002
oooo0P0000Coool800004Oooo`80000Foooo0P0000Koool200000oooo`@0000Hoooo0P0000ooool2
00004?ooo`800007oooo100000Coool200002_ooo`800002oooo1P0000;oool00`000?ooooooo`02
00001_oooaH0000;oooo1P0000;oool200001Oooo`030000oooooooo00;oool001Soool200003Ooo
o`@00004oooo0`0000;oool200001?ooo`P0000Aoooo0P0001Koool200001_ooo`800003oooo1000
01Soool200003oooo`80000@oooo0P0000Ooool400001?ooo`80000:oooo0P0000;oool600000_oo
o`030000oooooooo00800006oooo5P0000_oool600000_ooo`800004oooo0P0000Coool001Soool0
0`000?ooooooo`0>oooo0P0000Coool300000_ooo`800002oooo2P00017oool200005_ooo`800002
oooo0P0000Coool300000_ooo`80000@oooo0P0000Koool400000oooo`800006oooo100000;oool2
00002?ooo`800002oooo0P0000Woool200001?ooo`800008oooo100000Koool200000oooo`@00002
oooo1P0000;oool200000_ooo`H00004oooo0P0000Goool800000_ooo`H00007oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00koool200001?ooo`<00002oooo0P0000;oool:00004Ooo
o`80000Foooo0P0000;oool200001?ooo`<00002oooo0P00013oool200001_ooo`@00003oooo0P00
00Koool400000_ooo`800008oooo0P0000;oool200002Oooo`800004oooo0P0000Soool400001_oo
o`800003oooo100000;oool600000_ooo`800002oooo1P0000Coool200001Oooo`P00002oooo1P00
00Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`@00008oooo0P0000;oool5
00000_ooo`H00004oooo100002Woool200001_ooo`D00006oooo0P0000;oool200001?ooo`80000K
oooo0P00013oool200002Oooo`@00002oooo0P0000[oool200001?ooo`@00002oooo5@0000Coool4
00003oooo`80000=oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool400002?oo
o`800002oooo1@0000;oool600001?ooo`@0000Yoooo0P0000Koool500001_ooo`800002oooo0P00
00Coool200006oooo`80000@oooo0P0000Woool400000_ooo`80000:oooo0P0000Coool400000_oo
oaD00004oooo100000ooool200003Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo2P0000;oool200001?ooo`030000oooooooo00;oool400001_ooo`@0000Qoooo100000Coool4
00001_ooo`030000oooooooo00H00002oooo0P0001;oool600002oooo`800004oooo0P0001Goool4
00000_ooo`@00004oooo100000Koool400001Oooo`H00002oooo1P0000;oool400000_ooo`P00009
oooo0P0000;oool200002oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P00
00;oool200001?ooo`030000oooooooo00;oool400001_ooo`@0000Qoooo100000Coool400001_oo
o`030000oooooooo00H00002oooo0P0001;oool600002oooo`800004oooo0P0001Goool400000_oo
o`@00004oooo100000Koool400001Oooo`H00002oooo1P0000;oool400000_ooo`P00009oooo0P00
00;oool200002oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Woool2
00000_ooo`H00004oooo100002?oool200000_ooo`@00002oooo0P0000;oool200001Oooo`800006
oooo0P0002?oool200003?ooo`800009oooo0P0000;oool200000_ooo`800006oooo0P0000Koool6
00001Oooo`P00002oooo1P0000[oool200001?ooo`L0000Aoooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool:00002Oooo`800002oooo1P0000Coool400008oooo`800002oooo1000
00;oool200000_ooo`800005oooo0P0000Koool200008oooo`80000<oooo0P0000Woool200000_oo
o`800002oooo0P0000Koool200001_ooo`H00005oooo200000;oool600002_ooo`800004oooo1`00
017oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`80000<oooo0P0000?oool2
00000_ooo`H00004oooo1P0000Koool200006Oooo`800002oooo100000Koool200002Oooo`80000H
oooo0P000003oooo0000000000[oool400000_ooo`800002oooo0P0000Coool200001oooo`80000<
oooo1000017oool200000_ooo`800004oooo100000;oool200000_ooo`@00009oooo100000;oool2
00003oooo`030000oooooooo00;oool001Soool200000oooo`80000<oooo0P0000?oool200000_oo
o`H00004oooo1P0000Koool200006Oooo`800002oooo100000Koool200002Oooo`80000Hoooo0P00
0003oooo0000000000[oool400000_ooo`800002oooo0P0000Coool200001oooo`80000<oooo1000
017oool200000_ooo`800004oooo100000;oool200000_ooo`@00009oooo100000;oool200003_oo
o`800004oooo000Hoooo00<0003oooooool00_ooo`X00004oooo1`0000;oool800000_ooo`H00008
oooo0P0001Ooool800001?ooo`@00003oooo0P0000;oool200001_ooo`@00008oooo0P0001Goool4
00008oooo`80000:oooo100000;oool300001?ooo`@00002oooo100000;oool600001?ooo`800004
oooo00<0003oooooool00P0001?oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`X00004oooo1`0000;oool800000_ooo`H00008oooo0P0001Ooool800001?ooo`@00003oooo0P00
00;oool200001_ooo`@00008oooo0P0001Goool400008oooo`80000:oooo100000;oool300001?oo
o`@00002oooo100000;oool600001?ooo`800004oooo00<0003oooooool00P0001?oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`X00004oooo10000003oooo0000000000Coool6
00000_ooo`H0000Uoooo100000;ooolA00001_ooo`800002oooo0P0000[oool200003oooo`@0000E
oooo1P0000Koool400001_ooo`@00002oooo0P0000;oool700001?ooo`800002oooo100000Soool2
00000_ooo`800003oooo0P0000koool200001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo2P0000Coool4000000?oool0000000001?ooo`H00002oooo1P0002Goool400000_oo
oa400006oooo0P0000;oool200002_ooo`80000?oooo100001Goool600001_ooo`@00006oooo1000
00;oool200000_ooo`L00004oooo0P0000;oool400002?ooo`800002oooo0P0000?oool200003_oo
o`800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?oooa400004
oooo100000;oool200003Oooo`80000Boooo100000_oool200003_ooo`80000<oooo10000003oooo
0000000000800004oooo0P0000Coool200003?ooo`800007oooo0P0000;oool200001?ooo`@0000<
oooo100000;oool00`000?ooooooo`04oooo0P0000Koool:00001_ooo`80000?oooo0P0000Woool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`X00004oooo4@0000Coool400000_oo
o`80000=oooo0P0001;oool400002oooo`80000>oooo0P0000coool4000000?oool0000000000P00
00Coool200001?ooo`80000<oooo0P0000Ooool200000_ooo`800004oooo100000coool400000_oo
o`030000oooooooo00Coool200001_ooo`X00006oooo0P0000ooool200002Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooo2P0000Coool700000_ooo`800002oooo100000Coool4
00001?ooo`800006oooo0P0000?oool200004_ooo`@00009oooo100000koool200003_ooo`<00002
oooo1P0000;oool200002_ooo`800004oooo0P0000_oool200001?ooo`80000>oooo1P0000Woool4
00004?ooo`80000Eoooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`X00004oooo1`0000;oool200000_ooo`@00004oooo100000Coool200001_ooo`800003oooo0P00
01;oool400002Oooo`@0000>oooo0P0000koool300000_ooo`H00002oooo0P0000[oool200001?oo
o`80000;oooo0P0000Coool200003_ooo`H00009oooo1000013oool200005Oooo`800005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001_ooo`/00002oooo100000;oool6
00001_ooo`800002oooo0P0001Goool200003?ooo`030000oooooooo01Koool200001_ooo`800003
oooo100000;oool200001?ooo`800006oooo0P0000Coool200002oooo`@00002oooo100002Goool2
00003?ooo`80000Aoooo0P0000Ooool00`000?ooooooo`02oooo000Hoooo0P0000?oool:00001_oo
o`/00002oooo100000;oool600001_ooo`800002oooo0P0001Goool200003?ooo`030000oooooooo
01Koool200001_ooo`800003oooo100000;oool200001?ooo`800006oooo0P0000Coool200002ooo
o`@00002oooo100002Goool200003?ooo`80000Aoooo0P0000Koool200001?ooo`006?ooo`030000
oooooooo00;oool:00001?ooo`d00008oooo1P0000Koool600001Oooo`800004oooo0P0000Coool2
00001?ooo`800004oooo0P0001?oool600000_ooo`800002oooo100000Coool500002?ooo`@00006
oooo0P0000Coool200003oooo`800002oooo1P0002ooool200004Oooo`800007oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool:00001?ooo`d00008oooo1P0000Koool600001Ooo
o`800004oooo0P0000Coool200001?ooo`800004oooo0P0001?oool600000_ooo`800002oooo1000
00Coool500002?ooo`@00006oooo0P0000Coool200003oooo`800002oooo1P0002ooool200004Ooo
o`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?ooo`/0000<
oooo100000goool200001_ooo`80000<oooo0P0000Coool200004Oooo`H00002oooo100000Coool2
00002Oooo`X00002oooo100000;oool200001?ooo`80000=oooo0P00037oool200001_ooo`800002
oooo00<0003oooooool02_ooo`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool:00001?ooo`/0000Hoooo0P0000_oool400002_ooo`800004oooo0P0000ooool400001_oo
o`H00006oooo1@0000;oool200001?ooo`X00002oooo0P0000Coool200002Oooo`H0000aoooo0P00
00goool200004oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Coool;
00006?ooo`80000;oooo100000[oool200001?ooo`80000?oooo100000Koool600001_ooo`D00002
oooo0P0000Coool:00000_ooo`800004oooo0P0000Woool60000<Oooo`80000=oooo0P0001?oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0=oooo`<00004oooo0P0000Coool200000_oo
o`800004oooo0P0000Soool300001_ooo`P00002oooo4P0000Goool200000_ooo``00006oooo0P00
00Koool30000?oooo`800002oooo0P0000Goool200002?ooo`@00005oooo00<0003oooooool00_oo
o`003?ooo`800004oooo00<0003oooooool00oooo`030000oooooooo03Ooool300001?ooo`800004
oooo0P0000;oool200001?ooo`800008oooo0`0000Koool800000_oooa800005oooo0P0000;oool<
00001_ooo`800006oooo0`0003ooool200000_ooo`800005oooo0P0000Soool400001Oooo`030000
oooooooo00;oool000coool00`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo
03koool200000_ooo`@00002oooo0P0000[oool200000_ooo`800003oooo2P0000CooolE00000_oo
o`P00002oooo1P0000Koool60000B?ooo`d00006oooo0P0000Goool00`000?ooooooo`02oooo000<
oooo00<0003oool000000_ooo`030000oooo000000Coool30000?_ooo`800002oooo100000;oool2
00002_ooo`800002oooo0P0000?oool:00001?oooaD00002oooo200000;oool600001_ooo`H00018
oooo3@0000Koool200000oooo`<00004oooo000<oooo0P0000?oool00`000?ooo`000004oooo00<0
003oooooool0A_ooo`800002oooo0P0000Soool200001oooo`800002oooo100000;ooolI00000_oo
o`P00002oooo1P0000Coool40000EOooo`X00007oooo00<0003oooooool00_ooo`003?ooo`030000
oooooooo00;oool00`000?ooo`000004oooo00<0003oooooool0A_ooo`800002oooo0P0000Soool2
00001oooo`800002oooo100000;ooolI00000_ooo`P00002oooo1P0000Coool40000EOooo`X00007
oooo00<0003oooooool00_ooo`003Oooo`800003oooo00<0003oooooool00oooo`030000oooooooo
04Soool200000_ooo`@00006oooo0P0000Goool200000_ooo`800002oooo7`0000;oool400000_oo
o`H00004oooo100004;oool600002Oooo`800004oooo0P0000;oool200000_ooo`800005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo04Soool200000_ooo`@00006oooo0P0000Goool2
00000_ooo`800002oooo7`0000;oool400000_ooo`H00004oooo100004;oool600002Oooo`800004
oooo0P0000;oool200000_ooo`800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
04[oool200003?ooo`T00002oooo8@0000;oool200000_ooo`P00004oooo0P00053oool00`000?oo
ooooo`0200004oooo`030000oooooooo00;oool001Soool00`000?ooooooo`1:oooo0P0000coool9
00000_ooob400002oooo0P0000;oool800001?ooo`80001@oooo00<0003oooooool00P0001?oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0C_ooo`800004oooo0P0000;ooolj00000_oo
o`80001Coooo0P0001Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C_ooo`800004
oooo0P0000;ooolj00000_ooo`80001Coooo0P0001Goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0E?ooo`@00003oooo>`0006[oool00`000?ooooooo`02oooo000Hoooo0P0005Goool4
00000ooooc/0001Yoooo0P0000Coool001Soool00`000?ooooooo`1Hoooo0P000003oooo00000000
03L0001/oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Soool2000000?oool00000
0000=`0006coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_ooo`800002oooo00<0
003oooooool0<`00073oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_ooo`800002
oooo00<0003oooooool0<`00073oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_oo
o`800002oooo=00007;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_ooo`800002
oooo=00007;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E?ooo`@00003oooo<`00
07;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E?ooo`@00003oooo<`0007;oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0F_oooc80001doooo00<0003oooooool00_oo
o`006?ooo`80001Koooo<P0007?oool200001?ooo`006?ooo`030000oooooooo05Soool`0000N?oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1Hoooo<00007Soool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0Foooob/0001joooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo05_oool[0000N_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Koooo;@00
07Soool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0F?ooo`d00006oooo7`0007Koool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0F?ooo`d00006oooo7`0007Koool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0F?ooo`d00008oooo7`0007Coool00`000?ooooooo`02
oooo000Hoooo0P0005Woool=00002?oooal0001coooo0P0000Coool001Soool00`000?ooooooo`1F
oooo5@0000Coool200000_oooaT0001doooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
05KooolE00001?ooo`800002oooo6@0007Coool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0E_oooaT00006oooo2`0000;oool<0000L_ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1Foooo6@0000Koool;00000_ooo``0001boooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo053oool?00000_ooo`@00004oooo9@0007;oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0D?ooo`l00002oooo100000CooolU0000L_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`1Boooo2`0000;oool600000_oooaP000000oooo`000000000@0000K_ooo`030000
oooooooo00;oool000goool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo
05;oool;00000_ooo`H00002oooo60000003oooo000000000100001^oooo00<0003oooooool00_oo
o`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0D_ooo`d00004
oooo3P0000KooolK0000K_ooo`030000oooooooo00;oool000coool00`000?ooo`000002oooo00<0
003oool000001?ooo`<0001Boooo3@0000Coool>00001_oooa/0001/oooo0`0000Coool000goool0
1`000?ooooooooooo`000?ooo`000004oooo00<0003oooooool0D?ooo`/00002oooo100000;oool2
00000_ooo`H00004oooo8@0006koool00`000?ooooooo`02oooo000<oooo00<0003oool000000_oo
o`030000oooo000000Coool00`000?ooooooo`1@oooo2`0000;oool400000_ooo`800002oooo1P00
00CooolQ0000K_ooo`030000oooooooo00;oool000goool00`000?ooooooo`02oooo00<0003ooooo
ool00oooo`030000oooooooo04koool=00000_ooo`@00004oooo0P0000CooolE00000_oooa00001^
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04koool=00000_ooo`@00004oooo0P00
00CooolE00000_oooa00001^oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04kooolA
00000_ooo`80000Boooo0P0000CooolI0000K?ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1>oooo4@0000;oool200004_ooo`800004oooo6@0006coool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0C_ooo`800002oooo2`0000Koool200002?ooo`@00002oooo2P0000;ooolE
0000K?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1>oooo0P0000;oool;00001_oo
o`800008oooo100000;oool:00000_oooaD0001/oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04koool=00000_ooo`80000>oooo300000Coool2000000?oool0000000004P0006coool0
0`000?ooooooo`02oooo000Hoooo0P0004ooool=00000_ooo`80000>oooo300000Coool2000000?o
ool0000000004P0006_oool200001?ooo`006?ooo`030000oooooooo04coool>000000?oool00000
00001P0000;oool200000_oooaH000000oooo`000000000B0000K?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1<oooo3P000003oooo0000000000H00002oooo0P0000;ooolF000000?o
ool0000000004P0006coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C?ooo`h00005
oooo100000Coool200000_oooa@000000oooo`000000000B0000K?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1<oooo3P0000Goool400001?ooo`800002oooo50000003oooo00000000
0180001/oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04coool:00002oooo`800004
oooo0P0000Coool200000_ooo`H00002oooo0P0000Goool600000_ooo``0001/oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo04coool:00002oooo`800004oooo0P0000Coool200000_oo
o`H00002oooo0P0000Goool600000_ooo``0001/oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04koool:00003Oooo`800004oooo0P0000Koool600004Oooo`X0001/oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo04koool:00001Oooo`X00004oooo0P0000;oool200000_oo
o`H00002oooo2`0000Coool80000K_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1>
oooo2P0000Goool:00001?ooo`800002oooo0P0000;oool600000_ooo`/00004oooo200006koool0
0`000?ooooooo`02oooo000Hoooo0P0004goool800002Oooo`800002oooo200000[oool400000_oo
o`d00004oooo200006goool200001?ooo`006?ooo`030000oooooooo04coool800002Oooo`800002
oooo200000[oool400000_ooo`d00004oooo200006koool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0C_oooa/0000<oooo1P0000;ooolE0000K_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`1>oooo6`0000coool600000_oooaD0001^oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo04coool:00000_oooaD00008oooo7@0006koool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0C?ooo`X00002oooo5@0000SooolM0000K_ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1<oooo3`0000;oool200000_ooo`h00004oooo7`0006koool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0C?ooo`l00002oooo0P0000;oool>00001?oooal0001^
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04coool400001_ooo`T00006oooo2P00
00Coool800000_ooo`D00002oooo3P0006koool00`000?ooooooo`02oooo000Hoooo0P0004goool4
00001_ooo`T00006oooo2P0000Coool800000_ooo`D00002oooo3P0006goool200001?ooo`006?oo
o`030000oooooooo04coool200002?ooo`800002oooo00<0003oooooool0100000Koool[0000K_oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1<oooo0P0000Soool200000_ooo`030000
oooooooo00@00006oooo:`0006koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C?oo
o`80000:oooo5@0000SooolI00000_ooo`80001^oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04coool200002_oooaD00008oooo6@0000;oool20000K_ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1>oooo0P0000Coool200000_ooo`800005oooo0P0000;oool:00000_oo
o`800004oooo2`0000Soool200001?ooo`@0001^oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04koool200001?ooo`800002oooo0P0000Goool200000_ooo`X00002oooo0P0000Coool;
00002?ooo`800004oooo100006koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C_oo
o`@0000Aoooo0P0001Coool400000_ooo`030000oooooooo00coool20000L?ooo`030000oooooooo
00;oool000Koool500000_ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003ooooo
ool0C_ooo`@0000Aoooo0P0001Coool400000_ooo`030000oooooooo00coool20000L?ooo`030000
oooooooo00;oool000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?oo
o`030000oooooooo05Koool200004Oooo`80000@oooo0P0000;oool00`000?ooooooo`02oooo0P00
00Coool200000_ooo`80001`oooo00<0003oooooool00_ooo`002?ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000004oooo0`0005Koool200004Oooo`80000@oooo0P0000;oool0
0`000?ooooooo`02oooo0P0000Coool200000_ooo`80001^oooo0`0000Coool000Soool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo053oool40000;?oo
o`@00002oooo0P0000;oool40000L_ooo`030000oooooooo00;oool000Soool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo053oool40000;?ooo`@00002
oooo0P0000;oool40000L_ooo`030000oooooooo00;oool000Ooool200001?ooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool0HOooo`80000Doooo100000Ooool20000O?oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1Qoooo0P0001Coool400001oooo`80001l
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Coool200009oooo`8000000oooo`00
00000002oooo0P0000;oool20000M_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1D
oooo0P0002Ooool2000000?oool0000000000_ooo`800002oooo0P0007Koool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0E_ooo`L0000Uoooo1P0007Soool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0E_ooo`L0000Uoooo1P0007Soool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0F?ooo`<0000>oooo0P0000Soool600000_ooo`800002oooo00<0003oooooool00P00
07coool00`000?ooooooo`02oooo000Hoooo0P0005koool200000_ooo`80000<oooo200000Koool3
0000Ooooo`800004oooo000Hoooo00<0003oooooool0GOooo`800002oooo0P0000coool800001_oo
o`<00020oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05ooool200002?ooo`80000:
oooo0P0008Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0Goooo`800008oooo0P00
00[oool20000ROooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Ooo
o`800004oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool03?ooo`80003boooo00<0003ooooo
ool00_ooo`001_ooo`D000001?ooo`000000000000?oool00`000?ooooooo`03oooo00<0003ooooo
ool03?ooo`80003boooo00<0003oooooool00_ooo`002?ooo`050000oooooooooooo000000Coool0
0`000?ooo`000004oooo00<0003oooooool03_ooo`80003`oooo00<0003oooooool00_ooo`002?oo
o`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000004oooo0`0000koool20000k_oo
o`<00004oooo0008oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000Soool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oool000001?ooo`030000oooooooo00[oool20000m?ooo`030000oooooooo
00;oool000Ooool200001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003ooooo
ool02_ooo`80003doooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool40000jOoo
o`80000?oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool40000jOooo`80000?
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Soool200002_ooo`030000oooooooo
00[oool20000gOooo`030000oooooooo00;oool001Soool00`000?ooooooo`08oooo0P0000[oool0
0`000?ooooooo`0:oooo0P000=goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_oo
o`@0000Aoooo0P0000;oool200003?ooo`800002oooo0P0000;oool20000bOooo`030000oooooooo
00;oool001Soool00`000?ooooooo`06oooo1000017oool200000_ooo`80000<oooo0P0000;oool2
00000_ooo`800039oooo00<0003oooooool00_ooo`006?ooo`80000;oooo0P0000;oool600001Ooo
o`800002oooo0P00013oool20000c_ooo`800004oooo000Hoooo00<0003oooooool02_ooo`800002
oooo1P0000Goool200000_ooo`80000@oooo0P000<ooool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_oooa000003oooo0P0000Soool200009Oooo`80000Goooo100000koool200007Ooo
o`80000<oooo0P0000Goool200005?ooo`80000Ioooo0P0002Soool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_oooa000003oooo0P0000Soool200009Oooo`80000Goooo100000koool2
00007Oooo`80000<oooo0P0000Goool200005?ooo`80000Ioooo0P0002Soool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`H00002oooo0P0000;oool600001Oooo`80000@oooo0P00
00Soool200007oooo`80000noooo0P0001?oool20000A?ooo`80000=oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool600000_ooo`800002oooo1P0000Goool200004?ooo`800008
oooo0P0001ooool20000?_ooo`80000Coooo0P0004Coool200003Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool200000oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo0P0000Coool001Sooooo00001@0000Coool00?oooolQoooo003ooooo8Ooo
o`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00QOooo`<0002Hoooo0026oooo00<0003ooooo
ool0Uoooo`00Moooo`<00002oooo1@000005oooo0000oooo0000oooo00<00002oooo0`0000?oool2
00003Oooo`<00002oooo0`000004oooo0000oooooooo0P0000?oool200000oooo`80001Xoooo001g
oooo00<0003oool000000_ooo`<000002?ooo`000?ooo`000?ooo`000?ooo`0000;oool010000?oo
ooooo`0000?oool00`000?ooooooo`0>oooo00<0003oooooool00_ooo`060000oooooooo0000oooo
00000_ooo`030000oooo000000;oool00`000?ooo`000002oooo00<0003oooooool0IOooo`00NOoo
o`030000oooooooo00;oool02@000?ooo`000?ooo`000?ooo`000?ooo`000002oooo00@0003ooooo
ool00003oooo0`0000koool300000_ooo`060000oooooooo0000oooo00000_ooo`030000oooo0000
00Coool010000?ooooooo`0006Ooool007Soool00`000?ooooooo`02oooo0P000006oooo00000000
oooo0000oooo100000?oool010000?ooooooooooo`<0000>oooo00D0003oooooool0003oool00`00
00?oool2000000?oool0000000000P0000?oool20000J?ooo`00Moooo`030000oooo000001;oool0
0`000?ooooooo`0Boooo00H0003oooooool0003oool00009oooo00<0003oooooool0KOooo`00Mooo
o`<0000Aoooo0P0001?oool4000000?oool000000000NOooo`00ooooob7oool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ Black\ Frame\)], "Input"],

Cell[BoxData[
    \(\(sample2 = sample; \)\)], "Input"],

Cell[BoxData[
    \(\(Do[sample2[\([i, j]\)] = 0, \n\t\t{i, 4}, {j, 128}]; \)\)], "Input"],

Cell[BoxData[
    \(\(Do[sample2[\([i, j]\)] = 0, \n\t\t{i, 128}, {j, 125, \ 128}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Do[sample2[\([i, j]\)] = 0, \n\t\t{i, 125, 128}, {j, \ 128}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Do[sample2[\([i, j]\)] = 0, \n\t\t{i, 128}, {j, 4}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(SamplePhoto = 
      ListDensityPlot[sample2, \n\tMesh -> False, 
        AspectRatio -> size[\([1]\)]/size[\([2]\)], \n\t
        PlotLabel -> "\<Sample Photo\>"]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF0000000000
0000000000FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF0000000000
00000000FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF0000000000
00000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFF00000000
00000000FFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
0000000000000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF000000000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF0000000000
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFF00000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFF00000000
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF00000000
000000000000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF0000000000
00000000FFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFF00000000
00000000FFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFF00000000
00000000FF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFF00000000
000000000000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFF00000000
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFF00000000
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFF00000000
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFF00000000
00000000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF00000000
00000000FFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF00000000
00000000FFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF000000000000
00000000FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
0000000000000000
0000000000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000000000
0000000000FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000000000
000000000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FF00000000
0000000000FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFF00000000
00000000FFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF0000000000
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF0000000000
00000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF0000000000
00000000FFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
00000000FFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF000000000000
00000000FF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF000000000000
00000000FF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
00000000FFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FF00000000
00000000FF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FF00000000
00000000FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
00000000FF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF0000000000
00000000FFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF00000000
00000000FFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF0000000000
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00000000
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFF00000000
00000000FFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FF00000000
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFF00000000
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFF00000000
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFF00000000
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFF00000000
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFF00000000
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00000000
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFF00000000
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF0000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00000000
00000000FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`02oooo000A
oooo00<0003oool000001?ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00;oool0
01;oool00`000?ooooooo`03oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`02oooo000Hoooo0P00
00?oool800000_ooo`800006oooo1`0000Koool600003_ooo`D00006oooo2P0000;oool600000_oo
o`800005oooo100000;oool200001?ooo`800002oooo0P0000;oool200001?ooo`800002oooo0P00
00;oool200000oooo`H00002oooo1P0000Koool200001_ooo`/00006oooo100000;oool800000_oo
o`800009oooo1P0000;oool<00001?ooo`800002oooo0P000003oooo0000000000Koool:00001?oo
o`800004oooo000Hoooo00<0003oooooool00_ooo`P00002oooo0P0000Koool700001_ooo`H0000>
oooo1@0000Koool:00000_ooo`H00002oooo0P0000Goool400000_ooo`800004oooo0P0000;oool2
00000_ooo`800004oooo0P0000;oool200000_ooo`800003oooo1P0000;oool600001_ooo`800006
oooo2`0000Koool400000_ooo`P00002oooo0P0000Woool600000_ooo``00004oooo0P0000;oool2
000000?oool0000000001_ooo`X00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool:00001_ooo`<00002oooo0P0000Coool200002_ooo`P00004oooo0P0000?oool400000_oo
o`H00002oooo0P0000Coool?00001_ooo``00002oooo100000;oool200001?ooo`800005oooo0P00
00;oool200000_ooo`800002oooo0P0000;oool200001?ooo`800004oooo0P000003oooo00000000
00X00008oooo100000Coool=00001_ooo`@00004oooo100000;oool200000_ooo`@00003oooo0P00
00Coool:00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Koool3
00000_ooo`800004oooo0P0000[oool800001?ooo`800003oooo100000;oool600000_ooo`800004
oooo3`0000Koool<00000_ooo`@00002oooo0P0000Coool200001Oooo`800002oooo0P0000;oool2
00000_ooo`800002oooo0P0000Coool200001?ooo`8000000oooo`000000000:00002?ooo`@00004
oooo3@0000Koool400001?ooo`@00002oooo0P0000;oool400000oooo`800004oooo2P0000Goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00002oooo0P0000;oool4000000?o
ool0000000000_ooo`X00002oooo100000;oool200002_ooo`D00006oooo0P0000Coool600002_oo
o`<00006oooo2P0000;oool600000_ooo`800002oooo2`0000;oool200000_ooo`@00004oooo0P00
00Coool200002?ooo`<00002oooo0P0000;oool200000_ooo`800004oooo0P0000Koool200000_oo
o`@0000?oooo100000Soool200001?ooo`D00006oooo2P0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooo`P00002oooo0P0000;oool4000000?oool0000000000_ooo`X00002
oooo100000;oool200002_ooo`D00006oooo0P0000Coool600002_ooo`<00006oooo2P0000;oool6
00000_ooo`800002oooo2`0000;oool200000_ooo`@00004oooo0P0000Coool200002?ooo`<00002
oooo0P0000;oool200000_ooo`800004oooo0P0000Koool200000_ooo`@0000?oooo100000Soool2
00001?ooo`D00006oooo2P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`P00004oooo1P0000?oool200000_ooo`800002oooo200000;oool400001?ooo`800004oooo0`00
00KooolJ000000?oool0000000000_ooo`H0000:oooo100000;oool200001?ooo`@000000oooo`00
00000006oooo0P0000Coool600000_ooo`800002oooo0P0000Coool300001_ooo``00006oooo0P00
00;oool200000_ooo`800003oooo200000Coool200000_ooo`h00002oooo00<0003oooooool02?oo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800001?ooo`H00003
oooo0P0000;oool200000_ooo`P00002oooo100000Coool200001?ooo`<00006oooo6P000003oooo
0000000000;oool600002_ooo`@00002oooo0P0000Coool4000000?oool0000000001_ooo`800004
oooo1P0000;oool200000_ooo`800004oooo0`0000Koool<00001_ooo`800002oooo0P0000;oool2
00000oooo`P00004oooo0P0000;oool>00000_ooo`030000oooooooo00Soool800001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo200000Coool200002Oooo`800002oooo0P00
00Coool200001?ooo`800006oooo100000;oool00`000?ooooooo`0400000_ooo`800002oooo1000
00Soool800000_ooo`030000oooooooo00Coool200001?ooo`800002oooo0P0000;oool600001?oo
o`800002oooo0P0000Goool800000_ooo`800008oooo0P0000Koool700002?ooo`800002oooo1000
00;oool800002oooo`800002oooo100000;oool600000_ooo`800002oooo1P0000?oool@00001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo8`0000;ooomF00008Oooo`800002
oooo0`0000[oool200003?ooo`800006oooo0`0000Coool200002_ooo`800004oooo0P0000Coool2
00002Oooo``00005oooo00<0003oooooool00_ooo`006?ooo`800003oooo8`0000;ooomF00008Ooo
o`800002oooo0`0000[oool200003?ooo`800006oooo0`0000Coool200002_ooo`800004oooo0P00
00Coool200002Oooo``00004oooo0P0000Coool001Soool00`000?ooooooo`02oooo200000SooolU
000000?oool000000000600000;oool^00001?oooad00002oooo@@0000?oool200001_ooo`X00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800002?ooobD000000oooo`00
0000000H00000_ooobh00004oooo7@0000;ooom100000oooo`800006oooo2P0000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooocH00002oooo1P0000Soool400001?ooo`80000;
oooo1P0000;oool200001_ooo`H00002oooo100000Koool00`000?ooooooo`02oooo2P0000Koool8
00000_ooo`@000000oooo`000000000400001?ooo`@00002ooooB00000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooocH00002oooo1P0000Soool400001?ooo`80000;oooo1P00
00;oool200001_ooo`H00002oooo100000Koool00`000?ooooooo`02oooo2P0000Koool800000_oo
o`@000000oooo`000000000400001?ooo`@00002ooooB00000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooobT00002oooo2`0000;oool400007?ooo`L00002oooo0P0000;oool2
00002?ooo`l00002oooo100000;oool800002?ooo`800006oooo0P0000?oool800001?ooodX00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooolY00000_ooo`/00002oooo1000
01coool700000_ooo`800002oooo0P0000Soool?00000_ooo`@00002oooo200000Soool200001_oo
o`800003oooo200000Cooom:00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo;@0000;oool600000oooo``00002oooo1P00017oool800001?ooo`P00002oooo100000;oool5
00001_ooo`800004oooo0P0000Coool>00000_ooo`T00002oooo6@0000;oool200000_ooo`800006
oooo0P0000[ooolK00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo;@00
00;oool600000oooo``00002oooo1P00017oool800001?ooo`P00002oooo100000;oool500001_oo
o`800004oooo0P0000Coool>00000_ooo`T00002oooo6@0000;oool200000_ooo`800006oooo0P00
00[ooolK00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200000Koool4
00000oooob<00002oooo3P0000;oool600001?ooo`800009oooo0P0000;oool200001?ooo`800002
oooo100000Soool900001?ooo`800002oooo1P0000Soool/00000_ooo`80000Hoooo0P0000Ooool2
00001_ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`800003oooo200000Koool400000ooo
ob<00002oooo3P0000;oool600001?ooo`800009oooo0P0000;oool200001?ooo`800002oooo1000
00Soool900001?ooo`800002oooo1P0000Soool/00000_ooo`80000Hoooo0P0000Ooool200001_oo
o`P00004oooo0P0000Coool001Soool00`000?ooooooo`02oooo;`0000_oool@00000_ooo`@00004
oooo2@0001;oool400000_ooo`@00002oooo3@0000Coool400000_ooo`800002oooo6@0000;ooolC
00000_ooo`80000@oooo100000Coool200001oooo`800006oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooobl0000;oooo400000;oool400001?ooo`T0000Boooo1000
00;oool400000_ooo`d00004oooo100000;oool200000_oooaT00002oooo4`0000;oool200004?oo
o`@00004oooo0P0000Ooool200001_ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;ooola00000_ooo`<00006oooo600003;oool200003?oooa/00004oooo5@0000Koool<
00001_ooo`@00002oooo1`0000Coool800001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo<@0000;oool300001_oooaP0000boooo0P0000cooolK00001?oooaD00006oooo3000
00Koool400000_ooo`L00004oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooob<00002oooo0P0000;oool400002?ooo`030000oooooooo00Koool400003?ooo`800002
oooo0P0004Koool200001?ooo`030000oooooooo00800008oooo0P0000SooolA00002_ooo`800002
oooo100000Koool200001?ooo`D00004oooo2P0000Goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_ooob<00002oooo0P0000;oool400002?ooo`030000oooooooo00Koool400003?oo
o`800002oooo0P0004Koool200001?ooo`030000oooooooo00800008oooo0P0000SooolA00002_oo
o`800002oooo100000Koool200001?ooo`D00004oooo2P0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooo`P00006oooo6`0000;oool200002Oooo`80000Joooo0P0001Goool2
0000;Oooo`80000Coooo0P0000;oool200002?ooo`d0000:oooo0P0000;oool400001_ooo`800007
oooo0P0000Koool800001Oooo`030000oooooooo00;oool000coool300000oooo`030000oooooooo
00?oool00`000?ooooooo`02oooo200000KooolK00000_ooo`800009oooo0P0001[oool200005Ooo
o`80000]oooo0P0001?oool200000_ooo`800008oooo3@0000[oool200000_ooo`@00006oooo0P00
00Ooool200001_ooo`P00005oooo00<0003oooooool00_ooo`003?ooo`030000oooooooo00;oool0
0`000?ooo`000004oooo00<0003oooooool00_ooo`P00006oooo4`00037oool200002oooo`800008
oooo100002?oool200000_ooo`80000Goooo0P0000koool=00009oooo`P00005oooo00<0003ooooo
ool00_ooo`003Oooo`070000oooooooooooo0000oooo000000Coool300000_ooo`P00006oooo4`00
037oool200002oooo`800008oooo100002?oool200000_ooo`80000Goooo0P0000koool=00009ooo
o`P00003oooo0`0000Coool000goool01`000?ooooooooooo`000?ooo`000004oooo00<0003ooooo
ool00_ooo`P00006oooo1`0000[oool200002_ooo`80000?oooo0P0001Coool200001oooo`800004
oooo0P0000[oool200009Oooo`800002oooo100000goool200001?ooo`800008oooo0P0000Coool=
00001?ooo`@00002oooo100000Koool400001Oooo`@00004oooo200000Goool00`000?ooooooo`02
oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`02oooo2000
00Koool700002_ooo`80000:oooo0P0000ooool200005?ooo`800007oooo0P0000Coool200002_oo
o`80000Uoooo0P0000;oool400003Oooo`800004oooo0P0000Soool200001?ooo`d00004oooo1000
00;oool400001_ooo`@00005oooo100000Coool800001Oooo`030000oooooooo00;oool000goool0
0`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo00;oool800000_ooo`T00006
oooo1P0000Soool200000_ooo`800002oooo0P0000Goool400006?ooo`800005oooo0P0000Coool2
00000_ooo`800006oooo0P0000[oool200000_ooo`80000Goooo0P0000;oool400002oooo`800006
oooo1P00017ooolD00001_ooo`@00002oooo00<0003oooooool0100000Coool800001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo200000;oool900001_ooo`H00008oooo0P00
00;oool200000_ooo`800005oooo100001Soool200001Oooo`800004oooo0P0000;oool200001_oo
o`80000:oooo0P0000;oool200005oooo`800002oooo100000_oool200001_ooo`H0000Aoooo5000
00Koool400000_ooo`030000oooooooo00@00004oooo200000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_oooa800009oooo0P0000Soool600001?ooo`80000Qoooo0P0000Goool2
00002?ooo`800008oooo0P0000coool200004oooo`800004oooo1P0000Woool800001?ooo`@00004
oooo0P0000;oool200002oooo`@00002oooo100000Coool400001?ooo`@00005oooo0P0000Koool8
00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo4P0000Woool200002?oo
o`H00004oooo0P00027oool200001Oooo`800008oooo0P0000Soool200003?ooo`80000Coooo0P00
00Coool600002Oooo`P00004oooo100000Coool200000_ooo`80000;oooo100000;oool400001?oo
o`@00004oooo100000Goool200001_ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool>00002oooo`800002oooo0P0000coool400008oooo`80000?oooo0P0000Soool2
00002?ooo`800004oooo00<0003oooooool03?ooo`@00004oooo200000Ooool200001_ooo`800006
oooo1P0001Goool200001?ooo`H00004oooo1P0000Goool400001?ooo`P00005oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool>00002oooo`800002oooo0P0000coool400008ooo
o`80000?oooo0P0000Soool200002?ooo`800004oooo00<0003oooooool03?ooo`@00004oooo2000
00Ooool200001_ooo`800006oooo1P0001Goool200001?ooo`H00004oooo1P0000Goool400001?oo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`800003oooo2P0001?oool200000_ooo`@00006
oooo0P0000_oool200006?ooo`80000Aoooo0P0000Soool200002_ooo`<0000Foooo200000Goool6
00001?ooo`800006oooo1P0000Koool400005Oooo`@00004oooo100000?oool200002?ooo`P00004
oooo0P0000Coool001Soool00`000?ooooooo`02oooo3P00017oool600004oooo`80000Hoooo0P00
01_oool400002_ooo`030000oooooooo00koool400001?ooo`P0000=oooo0P0000Koool400002?oo
o`800005oooo200000coool:00003Oooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool>00004Oooo`H0000Coooo0P0001Soool200006oooo`@0000:oooo00<0003ooooo
ool03_ooo`@00004oooo200000goool200001_ooo`@00008oooo0P0000Goool800003?ooo`X0000=
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00002oooo0P00
00Coool500001_ooo`P00002oooo0P0000;oool200009oooo`80000Koooo100002?oool800002Ooo
o`80000<oooo100000Coool200001?ooo`030000oooooooo00;oool600003?ooo`X00003oooo0P00
00Soool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200000;oool2
00001?ooo`D00006oooo200000;oool200000_ooo`80000Woooo0P0001_oool400008oooo`P00009
oooo0P0000coool400001?ooo`800004oooo00<0003oooooool00_ooo`H0000<oooo2P0000?oool2
00002?ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800002?oo
o`8000000oooo`0000000004oooo2P0000;oool400003oooo`80000Foooo100001goool200008Ooo
o`X00009oooo0P0000;oool200002?ooo`800002oooo0P0000ooool200001_ooo`@00006oooo0P00
00;oool;00001_ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool8
00002?ooo`8000000oooo`0000000004oooo2P0000;oool400003oooo`80000Foooo100001goool2
00008Oooo`X00009oooo0P0000;oool200002?ooo`800002oooo0P0000ooool200001_ooo`@00006
oooo0P0000;oool;00001_ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool800002?ooo`8000000oooo`0000000002oooo100000;oool200001_ooo`@0000Yoooo0P00
01_oool200000_ooo`800006oooo0`0001Coool200000_ooo`@00006oooo00<0003oooooool00P00
00;oool400002_ooo`@00008oooo0P0001_oool;00001?ooo``00005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool800002?ooo`8000000oooo`0000000002oooo100000;oool2
00001_ooo`@0000Yoooo0P0001_oool200000_ooo`800006oooo0`0001Coool200000_ooo`@00006
oooo00<0003oooooool00P0000;oool400002_ooo`@00008oooo0P0001_oool;00001?ooo``00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800000_ooo`800002oooo1@00
00;oool400001?ooo`80000:oooo0P0002Ooool200007Oooo`@00009oooo0P0001;oool200001_oo
o`800004oooo00<0003oooooool01_ooo`800008oooo100000;oool200006oooo`800008oooo0P00
00CooolC00001Oooo`030000oooooooo00;oool001Soool200000oooo`P00002oooo0P0000;oool5
00000_ooo`@00004oooo0P0000[oool200009oooo`80000Moooo100000Woool200004_ooo`800006
oooo0P0000Coool00`000?ooooooo`06oooo0P0000Soool400000_ooo`80000Koooo0P0000Soool2
00001?oooa<00004oooo0P0000Coool001Soool00`000?ooooooo`02oooo2P0000Coool200000ooo
o`H0000>oooo0P0000goool200005_ooo`@0000Moooo0P0000;oool400001oooo`80000Hoooo0P00
00ooool200002?ooo`@00002oooo0P0000Coool200003oooo`@0000<oooo3@0000;oool:00001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Coool200000oooo`H0000>
oooo0P0000goool200005_ooo`@0000Moooo0P0000;oool400001oooo`80000Hoooo0P0000ooool2
00002?ooo`@00002oooo0P0000Coool200003oooo`@0000<oooo3@0000;oool:00001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Koool500004?ooo`80000Woooo1000
01Ooool200000_ooo`80000Aoooo0P0001Coool400003oooo`800008oooo0P0000Soool200000_oo
o`<00002oooo0P0000Soool400002_ooo`800002oooo5`0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooo`X00006oooo1@00013oool200009oooo`@0000Goooo0P0000;oool2
00004Oooo`80000Doooo100000ooool200002?ooo`800008oooo0P0000;oool300000_ooo`800008
oooo100000[oool200000_oooaL00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool<00000_ooo`D0000:oooo0P0000Koool400007oooo`800006oooo0P0000Ooool400006_oo
o`800007oooo0P0000coool200004Oooo`@00004oooo0P0000coool200000_ooo`80000Qoooo4@00
00;oool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo300000;oool5
00002_ooo`800006oooo100001ooool200001_ooo`800007oooo100001[oool200001oooo`80000<
oooo0P00017oool400001?ooo`80000<oooo0P0000;oool200008Ooooa400002oooo200000Goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`X00002oooo100000_oool200001_oo
o`80000[oooo0P0000Ooool200002?ooo`80000Boooo100001Goool200001_ooo`800004oooo0P00
00Goool200000_ooo`80000:oooo100000;oool200000_ooo`@0000?oooo0P0000[oool?00001?oo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00000_ooo`@0000;
oooo0P0000Koool20000:oooo`800007oooo0P0000Soool200004_ooo`@0000Eoooo0P0000Koool2
00001?ooo`800005oooo0P0000;oool200002_ooo`@00002oooo0P0000;oool400003oooo`80000:
oooo3`0000Coool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2000
00Coool200002Oooo`800004oooo0P0001Coool2000000?oool0000000004_ooo`800002oooo1000
00Woool200000_ooo`800002oooo0P0001;oool400001oooo`80000<oooo200001goool400000_oo
o`800004oooo0P0000goool400000_ooo`800004oooo2`0000;oool400000_ooo`X00005oooo00<0
003oooooool00_ooo`006?ooo`800003oooo200000Coool200002Oooo`800004oooo0P0001Coool2
000000?oool0000000004_ooo`800002oooo100000Woool200000_ooo`800002oooo0P0001;oool4
00001oooo`80000<oooo200001goool400000_ooo`800004oooo0P0000goool400000_ooo`800004
oooo2`0000;oool400000_ooo`X00004oooo0P0000Coool001Soool00`000?ooooooo`02oooo2000
00_oool600001_ooo`800004oooo100000[oool200004Oooo`800002oooo0P0000;oool400002ooo
o`800002oooo0P0000[oool200003?ooo`800005oooo0P0000;oool200002?ooo`80000Yoooo1000
00;oool2000000?oool0000000001_ooo`@00002oooo100000;oool200000_ooo`l00004oooo2P00
00Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0000;oooo1P0000Koool2
00001?ooo`@0000:oooo0P00017oool200000_ooo`800002oooo100000_oool200000_ooo`80000:
oooo0P0000coool200001Oooo`800002oooo0P0000Soool20000:Oooo`@00002oooo0P000003oooo
0000000000Koool400000_ooo`@00002oooo0P0000;oool?00001?ooo`X00005oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool800002oooo`@00006oooo0P0000;oool600003ooo
o`80000>oooo300000Koool300003_ooo`80000@oooo0P0000Goool200002_ooo`800008oooo0P00
00Coool200001oooo`80000:oooo0P0000Koool800005ooooa400004oooo2P0000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0000;oooo100000Koool200000_ooo`H0000?
oooo0P0000koool<00001_ooo`<0000>oooo0P00013oool200001Oooo`80000:oooo0P0000Soool2
00001?ooo`800007oooo0P0000[oool200001_ooo`P0000Goooo4@0000Coool:00001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo200000goool200001_ooo`80000Doooo0P00
017oool200000_ooo`P00007oooo0P0000Coool400000_ooo`@0000Soooo0P0002?oool200002?oo
o`T00002oooo100000Coool800001?oooal00005oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool800003Oooo`800006oooo0P0001Coool200004Oooo`800002oooo200000Ooool2
00001?ooo`@00002oooo100002?oool200008oooo`800008oooo2@0000;oool400001?ooo`P00004
oooo7`0000Goool00`000?ooooooo`02oooo000=oooo0`0000;oool00`000?ooooooo`03oooo00<0
003oooooool00_ooo`P0000;oooo1P0000;oool200000_ooo`800004oooo0P0000coool200004ooo
o`800002oooo1P0000Koool300001?ooo`800004oooo100001Coool00`000?ooooooo`0@oooo0P00
00[oool200004oooo`800006oooo2`0000;oool200002?ooo`@00006oooo30000003oooo00000000
00800002oooo300000Goool00`000?ooooooo`02oooo000>oooo00H0003oooooool0003oool00004
oooo00<0003oooooool00_ooo`P0000;oooo1P0000;oool200000_ooo`800004oooo0P0000coool2
00004oooo`800002oooo1P0000Koool300001?ooo`800004oooo100001Coool00`000?ooooooo`0@
oooo0P0000[oool200004oooo`800006oooo2`0000;oool200002?ooo`@00006oooo30000003oooo
0000000000800002oooo300000Goool00`000?ooooooo`02oooo000<oooo10000004oooo0000oooo
00001?ooo`<00002oooo200000;oool200000_ooo`@00003oooo0P0000Koool200001_ooo`80000?
oooo0P0001Coool800001oooo`800006oooo0P0000koool200002Oooo`80000>oooo0P00027oool2
00002?ooo`H0000=oooo1P0000CooolC00000_ooo``00003oooo0`0000Coool000coool00`000?oo
o`000002oooo00<0003oool000001?ooo`030000oooooooo00;oool800000_ooo`800002oooo1000
00?oool200001_ooo`800006oooo0P0000ooool200005?ooo`P00007oooo0P0000Koool200003_oo
o`800009oooo0P0000koool200008Oooo`800008oooo1P0000goool600001?oooa<00002oooo3000
00Goool00`000?ooooooo`02oooo000=oooo0P0000;oool00`000?ooo`000004oooo00<0003ooooo
ool00_ooo`P00002oooo0P0000Koool900001?ooo`@00002oooo0P0002Ooool600001?ooo`030000
oooooooo013oool200001?ooo`@00008oooo0`0000Coool400001_ooo`80000:oooo0P0000Woool4
00001_ooo`800008oooo0P0000;oool200001?ooo`D00006oooo100000KooolQ00001Oooo`030000
oooooooo00;oool000koool01@000?ooooooooooo`000005oooo00<0003oooooool00_ooo`P00004
oooo0P0000Goool400002?ooo`800002oooo100000ooool200004_ooo`@00004oooo0P0000Coool0
0`000?ooooooo`04oooo0P0000;oool400002_ooo`80000;oooo100000;oool400001_ooo`80000E
oooo100000Koool200001?ooo`800002oooo0P0000;oool200001Oooo`H00004oooo1P0000;ooolI
00000_ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800001?oo
o`800005oooo100000Soool200000_ooo`@0000?oooo0P0001;oool400001?ooo`800004oooo00<0
003oooooool01?ooo`800002oooo100000[oool200002oooo`@00002oooo100000Koool200005Ooo
o`@00006oooo0P0000Coool200000_ooo`800002oooo0P0000Goool600001?ooo`H00002oooo6@00
00;oool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200000;oool4
00001?ooo`030000oooooooo00;oool200001?ooo`P0000Woooo100000;oool200000_ooo`800005
oooo100001;oool400001_ooo`<00002oooo0P0000;oool200003?ooo`80000Aoooo0P0000Coool2
00000_ooo`800004oooo0P0000Coool200001Oooo`H00004oooo1P0000Coool<00000_ooo`T00002
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00002oooo1000
00Coool00`000?ooooooo`02oooo0P0000Coool800009oooo`@00002oooo0P0000;oool200001Ooo
o`@0000Boooo100000Koool300000_ooo`800002oooo0P0000coool200004Oooo`800004oooo0P00
00;oool200001?ooo`800004oooo0P0000Goool600001?ooo`H00004oooo300000;oool900000_oo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800000_ooo`@00004
oooo1`0000Coool200000_ooo`@0000Yoooo0P0000;oool200001Oooo`800002oooo100001ooool6
00009oooo`80000:oooo0P0000;oool400000_ooo`030000oooooooo00@00002oooo0P0000;oool2
00000_ooo`h00007oooo1P0000;oool800001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo200000;oool400001?ooo`L00004oooo0P0000;oool40000:Oooo`800002oooo0P00
00Goool200000_ooo`@0000Ooooo1P0002Ooool200002_ooo`800002oooo100000;oool00`000?oo
ooooo`0400000_ooo`800002oooo0P0000;oool>00001oooo`H00002oooo200000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00002oooo100000Coool300000_ooo`800004
oooo2000017oool200005_ooo`800006oooo0P0000?oool400006?ooo`80000?oooo0P00013oool2
00001oooo`@00004oooo0P0000[oool200000_ooo`H00002oooo00<0003oooooool00P0000KooolF
00002oooo`X00005oooo00<0003oooooool00_ooo`006?ooo`800003oooo200000;oool400001?oo
o`<00002oooo0P0000Coool800004Oooo`80000Foooo0P0000Koool200000oooo`@0000Hoooo0P00
00ooool200004?ooo`800007oooo100000Coool200002_ooo`800002oooo1P0000;oool00`000?oo
ooooo`0200001_oooaH0000;oooo2P0000Coool200001?ooo`006?ooo`030000oooooooo00;oool8
00001?ooo`800004oooo0`0000;oool200000_ooo`X0000Aoooo0P0001Koool200000_ooo`800004
oooo0`0000;oool200004?ooo`800006oooo100000?oool200001_ooo`@00002oooo0P0000Soool2
00000_ooo`800009oooo0P0000Coool200002?ooo`@00006oooo0P0000?oool400000_ooo`H00002
oooo0P0000;oool600001?ooo`800005oooo200000;oool800001Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo200000Coool200001?ooo`<00002oooo0P0000;oool:00004Ooo
o`80000Foooo0P0000;oool200001?ooo`<00002oooo0P00013oool200001_ooo`@00003oooo0P00
00Koool400000_ooo`800008oooo0P0000;oool200002Oooo`800004oooo0P0000Soool400001_oo
o`800003oooo100000;oool600000_ooo`800002oooo1P0000Coool200001Oooo`P00002oooo2000
00Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00004oooo0P0000;oool5
00000_ooo`H00004oooo100002Woool200001_ooo`D00006oooo0P0000;oool200001?ooo`80000K
oooo0P00013oool200002Oooo`@00002oooo0P0000[oool200001?ooo`@00002oooo5@0000Coool4
00003oooo`X00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool800001?oo
o`800002oooo1@0000;oool600001?ooo`@0000Yoooo0P0000Koool500001_ooo`800002oooo0P00
00Coool200006oooo`80000@oooo0P0000Woool400000_ooo`80000:oooo0P0000Coool400000_oo
oaD00004oooo100000ooool:00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo2P0000;oool200001?ooo`030000oooooooo00;oool400001_ooo`@0000Qoooo100000Coool4
00001_ooo`030000oooooooo00H00002oooo0P0001;oool600002oooo`800004oooo0P0001Goool4
00000_ooo`@00004oooo100000Koool400001Oooo`H00002oooo1P0000;oool400000_ooo`P00009
oooo0P0000;oool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P00
00;oool200001?ooo`030000oooooooo00;oool400001_ooo`@0000Qoooo100000Coool400001_oo
o`030000oooooooo00H00002oooo0P0001;oool600002oooo`800004oooo0P0001Goool400000_oo
o`@00004oooo100000Koool400001Oooo`H00002oooo1P0000;oool400000_ooo`P00009oooo0P00
00;oool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Woool2
00000_ooo`H00004oooo100002?oool200000_ooo`@00002oooo0P0000;oool200001Oooo`800006
oooo0P0002?oool200003?ooo`800009oooo0P0000;oool200000_ooo`800006oooo0P0000Koool6
00001Oooo`P00002oooo1P0000[oool200001?ooo`L00004oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`X00009oooo0P0000;oool600001?ooo`@0000Soooo0P00
00;oool400000_ooo`800002oooo0P0000Goool200001_ooo`80000Soooo0P0000coool200002Ooo
o`800002oooo0P0000;oool200001_ooo`800006oooo1P0000Goool800000_ooo`H0000:oooo0P00
00Coool700001?ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool8
00001_ooo`800003oooo0P0000;oool600001?ooo`H00006oooo0P0001Woool200000_ooo`@00006
oooo0P0000Woool200006?ooo`8000000oooo`000000000:oooo100000;oool200000_ooo`800004
oooo0P0000Ooool200003?ooo`@0000Aoooo0P0000;oool200001?ooo`@00002oooo0P0000;oool4
00002Oooo`@00002oooo0P0000;oool800001Oooo`030000oooooooo00;oool001Soool200000ooo
o`P00006oooo0P0000?oool200000_ooo`H00004oooo1P0000Koool200006Oooo`800002oooo1000
00Koool200002Oooo`80000Hoooo0P000003oooo0000000000[oool400000_ooo`800002oooo0P00
00Coool200001oooo`80000<oooo1000017oool200000_ooo`800004oooo100000;oool200000_oo
o`@00009oooo100000;oool200000_ooo`P00004oooo0P0000Coool001Soool00`000?ooooooo`02
oooo2P0000Coool700000_ooo`P00002oooo1P0000Soool200005oooo`P00004oooo100000?oool2
00000_ooo`800006oooo100000Soool200005Oooo`@0000Soooo0P0000[oool400000_ooo`<00004
oooo100000;oool400000_ooo`H00004oooo0P0000Coool00`000?ooooooo`0200001_ooo`P00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?ooo`L00002oooo2000
00;oool600002?ooo`80000Goooo200000Coool400000oooo`800002oooo0P0000Koool400002?oo
o`80000Eoooo100002?oool200002_ooo`@00002oooo0`0000Coool400000_ooo`@00002oooo1P00
00Coool200001?ooo`030000oooooooo00800006oooo200000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooo`X00004oooo10000003oooo0000000000Coool600000_ooo`H0000U
oooo100000;ooolA00001_ooo`800002oooo0P0000[oool200003oooo`@0000Eoooo1P0000Koool4
00001_ooo`@00002oooo0P0000;oool700001?ooo`800002oooo100000Soool200000_ooo`800003
oooo0P0000Soool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P00
00Coool4000000?oool0000000001?ooo`H00002oooo1P0002Goool400000_oooa400006oooo0P00
00;oool200002_ooo`80000?oooo100001Goool600001_ooo`@00006oooo100000;oool200000_oo
o`L00004oooo0P0000;oool400002?ooo`800002oooo0P0000?oool200002?ooo`P00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?oooa400004oooo100000;oool2
00003Oooo`80000Boooo100000_oool200003_ooo`80000<oooo10000003oooo0000000000800004
oooo0P0000Coool200003?ooo`800007oooo0P0000;oool200001?ooo`@0000<oooo100000;oool0
0`000?ooooooo`04oooo0P0000Koool:00001_ooo`80000=oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`X00004oooo4@0000Coool400000_ooo`80000=oooo0P00
01;oool400002oooo`80000>oooo0P0000coool4000000?oool0000000000P0000Coool200001?oo
o`80000<oooo0P0000Ooool200000_ooo`800004oooo100000coool400000_ooo`030000oooooooo
00Coool200001_ooo`X00006oooo0P0000goool800001Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`02oooo2P0000Coool700000_ooo`800002oooo100000Coool400001?ooo`800006
oooo0P0000?oool200004_ooo`@00009oooo100000koool200003_ooo`<00002oooo1P0000;oool2
00002_ooo`800004oooo0P0000_oool200001?ooo`80000>oooo1P0000Woool400004?ooo`80000?
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`X00004oooo1`00
00;oool200000_ooo`@00004oooo100000Coool200001_ooo`800003oooo0P0001;oool400002Ooo
o`@0000>oooo0P0000koool300000_ooo`H00002oooo0P0000[oool200001?ooo`80000;oooo0P00
00Coool200003_ooo`H00009oooo1000013oool200003oooo`P00005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool:00001_ooo`/00002oooo100000;oool600001_ooo`800002
oooo0P0001Goool200003?ooo`030000oooooooo01Koool200001_ooo`800003oooo100000;oool2
00001?ooo`800006oooo0P0000Coool200002oooo`@00002oooo100002Goool200003?ooo`80000=
oooo200000Goool00`000?ooooooo`02oooo000Hoooo0P0000?oool:00001_ooo`/00002oooo1000
00;oool600001_ooo`800002oooo0P0001Goool200003?ooo`030000oooooooo01Koool200001_oo
o`800003oooo100000;oool200001?ooo`800006oooo0P0000Coool200002oooo`@00002oooo1000
02Goool200003?ooo`80000=oooo200000Coool200001?ooo`006?ooo`030000oooooooo00;oool:
00001?ooo`d00008oooo1P0000Koool600001Oooo`800004oooo0P0000Coool200001?ooo`800004
oooo0P0001?oool600000_ooo`800002oooo100000Coool500002?ooo`@00006oooo0P0000Coool2
00003oooo`800002oooo1P0002ooool200003Oooo`P00005oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool:00001?ooo`d00008oooo1P0000Koool600001Oooo`800004oooo0P00
00Coool200001?ooo`800004oooo0P0001?oool600000_ooo`800002oooo100000Coool500002?oo
o`@00006oooo0P0000Coool200003oooo`800002oooo1P0002ooool200003Oooo`P00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?ooo`/0000<oooo100000goool2
00001_ooo`80000<oooo0P0000Coool200004Oooo`H00002oooo100000Coool200002Oooo`X00002
oooo100000;oool200001?ooo`80000=oooo0P00037oool200001_ooo`800002oooo00<0003ooooo
ool02?ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?oo
o`/0000Hoooo0P0000_oool400002_ooo`800004oooo0P0000ooool400001_ooo`H00006oooo1@00
00;oool200001?ooo`X00002oooo0P0000Coool200002Oooo`H0000aoooo0P0000goool200001_oo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?ooo`/0000H
oooo0P0000_oool400002_ooo`800004oooo0P0000ooool400001_ooo`H00006oooo1@0000;oool2
00001?ooo`X00002oooo0P0000Coool200002Oooo`H0000aoooo0P0000goool200001_ooo`P00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000;Oooo`<00004oooo0P00
00Coool200000_ooo`800004oooo0P0000Soool300001_ooo`P00002oooo4P0000Goool200000_oo
o``00006oooo0P0000Koool30000?oooo`800002oooo0P0000Goool200001?ooo`P00005oooo00<0
003oooooool00_ooo`003?ooo`800004oooo00<0003oooooool00oooo`030000oooooooo00;oool8
0000;Oooo`<00004oooo0P0000Coool200000_ooo`800004oooo0P0000Soool300001_ooo`P00002
oooo4P0000Goool200000_ooo``00006oooo0P0000Koool30000?oooo`800002oooo0P0000Goool2
00001?ooo`P00005oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?oo
o`000004oooo00<0003oooooool00_ooo`P0000doooo0P0000;oool400000_ooo`80000:oooo0P00
00;oool200000oooo`X00004oooo5@0000;oool800000_ooo`H00006oooo1P0004SooolE00001Ooo
o`030000oooooooo00;oool000coool00`000?ooo`000002oooo00<0003oool000001?ooo`<00002
oooo200003Coool200000_ooo`@00002oooo0P0000[oool200000_ooo`800003oooo2P0000CooolE
00000_ooo`P00002oooo1P0000Koool60000B?oooaD00003oooo0`0000Coool000coool200000ooo
o`030000oooo000000Coool00`000?ooooooo`02oooo200003coool200000_ooo`800008oooo0P00
00Ooool200000_ooo`@00002oooo6@0000;oool800000_ooo`H00004oooo100005Goool<00001Ooo
o`030000oooooooo00;oool000coool00`000?ooooooo`02oooo00<0003oool000001?ooo`030000
oooooooo00;oool80000??ooo`800002oooo0P0000Soool200001oooo`800002oooo100000;ooolI
00000_ooo`P00002oooo1P0000Coool40000EOooo``00005oooo00<0003oooooool00_ooo`003Ooo
o`800003oooo00<0003oooooool00oooo`030000oooooooo00;oool80000?_ooo`800002oooo1000
00Koool200001Oooo`800002oooo0P0000;ooolO00000_ooo`@00002oooo1P0000Coool40000@_oo
o`H00009oooo0P0000Coool:00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo200003koool200000_ooo`@00006oooo0P0000Goool200000_ooo`800002oooo7`0000;oool4
00000_ooo`H00004oooo100004;oool600002Oooo`800004oooo2P0000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`P00010oooo0P0000coool900000_ooob400002oooo0P00
00;oool800001?ooo`80001@oooo00<0003oooooool00P0000Koool800001Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooo2000043oool200003?ooo`T00002oooo8@0000;oool2
00000_ooo`P00004oooo0P00053oool00`000?ooooooo`0200001_ooo`P00005oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool80000A?ooo`800004oooo0P0000;ooolj00000_oo
o`80001Coooo0P0000Soool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo200004Coool200001?ooo`800002oooo>P0000;oool20000Doooo`800008oooo200000Goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0001:oooo100000?ooolk0000GOoo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`800003oooo200004[oool400000ooooc/0001M
oooo200000Coool200001?ooo`006?ooo`030000oooooooo00;oool80000C_ooo`8000000oooo`00
0000000g0000Goooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool8
0000C_ooo`8000000oooo`000000000g0000Goooo`P00005oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool80000C?ooo`800002oooo00<0003oooooool0<`0006?oool800001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200004coool200000_ooo`030000
oooooooo03<0001Soooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`P0001<oooo0P0000;ooold0000IOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool80000C?ooo`800002oooo=00006Goool800001Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo200004[oool400000ooooc<0001Uoooo200000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0001:oooo100000?ooolc0000IOooo`P00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000D?oooc80001Woooo2000
00Goool00`000?ooooooo`02oooo000Hoooo0P0000?oool80000D?oooc80001Woooo200000Coool2
00001?ooo`006?ooo`030000oooooooo00;oool80000C_oooc00001[oooo200000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0001>oooo<00006_oool800001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo2000057oool[0000KOooo`P00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000DOooob/0001]oooo200000Goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0001Aoooo;@0006_oool800001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200004koool=00001_oooal0001Y
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0001>oooo3@00
00KooolO0000JOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool8
0000C_ooo`d00008oooo7`0006Ooool800001Oooo`030000oooooooo00;oool001Soool200000ooo
o`P0001>oooo3@0000SooolO0000Ioooo`P00004oooo0P0000Coool001Soool00`000?ooooooo`02
oooo200004cooolE00001?ooo`800002oooo6@0006Ooool800001Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo200004cooolE00001?ooo`800002oooo6@0006Ooool800001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200004cooolI00001_ooo`/00002
oooo300006Goool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2000
04cooolI00001_ooo`/00002oooo300006Goool800001Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`02oooo200004Koool?00000_ooo`@00004oooo9@0006Goool800001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo200004Koool?00000_ooo`@00004oooo9@00
06Goool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200004Soool;
00000_ooo`H00002oooo60000003oooo000000000100001Qoooo200000Goool00`000?ooooooo`02
oooo000=oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`02oooo2000
04Soool;00000_ooo`H00002oooo60000003oooo000000000100001Qoooo200000Goool00`000?oo
ooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`02
oooo200004Soool=00001?ooo`h00006oooo6`00067oool800001Oooo`030000oooooooo00;oool0
00coool00`000?ooo`000002oooo00<0003oool000001?ooo`<00002oooo200004Soool=00001?oo
o`h00006oooo6`00067oool800000oooo`<00004oooo000=oooo00L0003oooooooooool0003oool0
00001?ooo`030000oooooooo00;oool80000A_ooo`/00002oooo100000;oool200000_ooo`H00004
oooo8@00067oool800001Oooo`030000oooooooo00;oool000coool00`000?ooo`000002oooo00<0
003oool000001?ooo`030000oooooooo00;oool80000A_ooo`/00002oooo100000;oool200000_oo
o`H00004oooo8@00067oool800001Oooo`030000oooooooo00;oool000goool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo00;oool80000A?ooo`d00002oooo100000Coool2
00001?oooaD00002oooo4000067oool800001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo200004Coool=00000_ooo`@00004oooo0P0000CooolE00000_oooa00001Qoooo2000
00Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00014oooo4@0000;oool2
00004_ooo`800004oooo6@0005ooool800001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo200004CooolA00000_ooo`80000Boooo0P0000CooolI0000Goooo`P00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000A?ooo`800002oooo2`0000Koool2
00002?ooo`@00002oooo2P0000;ooolE0000Goooo`P00005oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool80000A?ooo`800002oooo2`0000Koool200002?ooo`@00002oooo2P00
00;ooolE0000Goooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool8
0000A?ooo`d00002oooo0P0000koool<00001?ooo`8000000oooo`000000000B0000Goooo`P00005
oooo00<0003oooooool00_ooo`006?ooo`800003oooo200004Coool=00000_ooo`80000>oooo3000
00Coool2000000?oool0000000004P0005ooool800001?ooo`800004oooo000Hoooo00<0003ooooo
ool00_ooo`P00012oooo3P000003oooo0000000000H00002oooo0P0000;ooolF000000?oool00000
00004P0005ooool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2000
04;oool>000000?oool0000000001P0000;oool200000_oooaH000000oooo`000000000B0000Gooo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000@_ooo`h00005
oooo100000Coool200000_oooa@000000oooo`000000000B0000Goooo`P00005oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool80000@_ooo`h00005oooo100000Coool200000_oo
oa@000000oooo`000000000B0000Goooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool80000@_ooo`X0000;oooo0P0000Coool200001?ooo`800002oooo1P0000;oool2
00001Oooo`H00002oooo300005ooool800001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo200004;oool:00002oooo`800004oooo0P0000Coool200000_ooo`H00002oooo0P00
00Goool600000_ooo``0001Ooooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`P00014oooo2P0000goool200001?ooo`800006oooo1P00017oool:0000Goooo`P00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000A?ooo`X00005oooo2P00
00Coool200000_ooo`800002oooo1P0000;oool;00001?ooo`P0001Qoooo200000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00014oooo2P0000Goool:00001?ooo`800002
oooo0P0000;oool600000_ooo`/00004oooo2000067oool800001Oooo`030000oooooooo00;oool0
01Soool200000oooo`P00012oooo200000Woool200000_ooo`P0000:oooo100000;oool=00001?oo
o`P0001Qoooo200000Coool200001?ooo`006?ooo`030000oooooooo00;oool80000@_ooo`P00009
oooo0P0000;oool800002_ooo`@00002oooo3@0000Coool80000HOooo`P00005oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool80000A?oooa/0000<oooo1P0000;ooolE0000HOoo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000A?oooa/0000<
oooo1P0000;ooolE0000HOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool80000@_ooo`X00002oooo5@0000SooolM0000HOooo`P00005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool80000@_ooo`X00002oooo5@0000SooolM0000HOooo`P00005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000@_ooo`l00002oooo0P00
00;oool>00001?oooal0001Qoooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`P00012oooo3`0000;oool200000_ooo`h00004oooo7`00067oool800001Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo200004;oool400001_ooo`T00006oooo2P00
00Coool800000_ooo`D00002oooo3P00067oool800001Oooo`030000oooooooo00;oool001Soool2
00000oooo`P00012oooo100000Koool900001_ooo`X00004oooo200000;oool500000_ooo`h0001Q
oooo200000Coool200001?ooo`006?ooo`030000oooooooo00;oool80000@_ooo`800008oooo0P00
00;oool00`000?ooooooo`0400001_ooob/0001Qoooo200000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooo`P00012oooo0P0000Soool200000_ooo`030000oooooooo00@00006
oooo:`00067oool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2000
04;oool200002_oooaD00008oooo6@0000;oool20000HOooo`P00005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool80000@_ooo`80000:oooo5@0000SooolI00000_ooo`80001Q
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00014oooo0P00
00Coool200000_ooo`800005oooo0P0000;oool:00000_ooo`800004oooo2`0000Soool200001?oo
o`@0001Qoooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P00014
oooo0P0000Coool200000_ooo`800005oooo0P0000;oool:00000_ooo`800004oooo2`0000Soool2
00001?ooo`@0001Qoooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`P00014oooo1000017oool200005?ooo`@00002oooo00<0003oooooool03?ooo`80001Soooo2000
00Goool00`000?ooooooo`02oooo0006oooo1@0000;oool00`000?ooooooo`02oooo00<0003ooooo
ool00oooo`030000oooooooo00;oool80000A?ooo`@0000Aoooo0P0001Coool400000_ooo`030000
oooooooo00coool20000Hoooo`P00005oooo00<0003oooooool00_ooo`002?ooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool00_ooo`P0001<oooo0P00
017oool200004?ooo`800002oooo00<0003oooooool00_ooo`800004oooo0P0000;oool20000Hooo
o`P00005oooo00<0003oooooool00_ooo`002?ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000004oooo0`0000;oool80000C?ooo`80000Aoooo0P00013oool200000_ooo`030000
oooooooo00;oool200001?ooo`800002oooo0P0006?oool800000oooo`<00004oooo0008oooo00L0
003oooooooooool0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`02oooo2000
04Koool40000;?ooo`@00002oooo0P0000;oool40000IOooo`P00005oooo00<0003oooooool00_oo
o`002?ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003ooooo
ool00_ooo`P00016oooo100002coool400000_ooo`800002oooo100006Goool800001Oooo`030000
oooooooo00;oool000Ooool200001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool00_ooo`P0001Goooo0P0001Coool400001oooo`80001_oooo200000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0001Goooo0P0001Coool400001oooo`80001_
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0001:oooo0P00
02Ooool2000000?oool0000000000_ooo`800002oooo0P0006Woool800001Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooo200004[oool200009oooo`8000000oooo`0000000002
oooo0P0000;oool20000JOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool80000C?ooo`L0000Uoooo1P0006_oool800001Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`02oooo200004coool700009Oooo`H0001[oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`P0001>oooo0`0000koool200002?ooo`H00002oooo0P00
00;oool00`000?ooooooo`020000Koooo`P00005oooo00<0003oooooool00_ooo`006?ooo`800003
oooo200005?oool200000_ooo`80000<oooo200000Koool30000Loooo`P00004oooo0P0000Coool0
01Soool00`000?ooooooo`02oooo200005?oool200000_ooo`80000<oooo200000Koool30000Looo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool80000EOooo`800008
oooo0P0000[oool20000O?ooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool80000EOooo`800008oooo0P0000[oool20000O?ooo`P00005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool80000jOooo`P00005oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool80000jOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool80000jOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool80000jOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool8
0000jOooo`P00005oooo00<0003oooooool00_ooo`006?ooo`800003oooo20000>Woool800001?oo
o`800004oooo000Hoooo00<0003oooooool00_ooo`P0003Yoooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`P0003Yoooo200000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooo`P0003Yoooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_ooo`P0003Yoooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`P0003Yoooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`P0003Yoooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0003Y
oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0003Yoooo2000
00Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0003Yoooo200000Goool0
0`000?ooooooo`02oooo000Hoooo0P0000?oool80000jOooo`P00004oooo0P0000Coool001Soool0
0`000?ooooooo`02oooo20000>Woool800001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo20000>Woool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo20000>Woool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2000
0>Woool800001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo20000>Woool8
00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo20000>Woool800001Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200000;oool20000iOooo`P00005
oooo00<0003oooooool00_ooo`001_ooo`D000001?ooo`000000000000?oool00`000?ooooooo`03
oooo00<0003oooooool00_ooo`P00002oooo0P000>Goool800001Oooo`030000oooooooo00;oool0
00Soool01@000?ooooooooooo`000004oooo00<0003oool000001?ooo`030000oooooooo00;oool8
00001?ooo`80003Soooo200000Goool00`000?ooooooo`02oooo0008oooo00<0003oooooool00_oo
o`070000oooooooooooo0000oooo000000Coool300000_ooo`P00004oooo0P000>?oool800000ooo
o`<00004oooo0008oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool0
0`000?ooooooo`02oooo20000>Woool800001Oooo`030000oooooooo00;oool000Soool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo00;oool:0000iooo
o`P00005oooo00<0003oooooool00_ooo`001oooo`800004oooo00<0003oooooool00_ooo`030000
oooooooo00?oool00`000?ooooooo`02oooo2P000>Ooool800001Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo20000>Goool200000_ooo`P00005oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool80000iOooo`800002oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`P0000:oooo00<0003oooooool02_ooo`80003@oooo2000
00Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`P0000:oooo00<0003ooooo
ool02_ooo`80003@oooo200000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00;oool001Soool200000oooooT00004oooo0P0000Coool001Soool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`800003oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool200001?ooo`006?oo
ool0000500001?ooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQ
oooo0025oooo0`0009Soool008Koool00`000?ooooooo`2Goooo001goooo0`0000;oool5000000Go
ool0003oool0003oool00`0000;oool300000oooo`80000=oooo0`0000;oool3000000Coool0003o
ooooool200000oooo`800003oooo0P0006Soool007Ooool00`000?ooo`000002oooo0`000008oooo
0000oooo0000oooo0000oooo00000_ooo`040000oooooooo00000oooo`030000oooooooo00koool0
0`000?ooooooo`02oooo00H0003oooooool0003oool00002oooo00<0003oool000000_ooo`030000
oooo000000;oool00`000?ooooooo`1Uoooo001ioooo00<0003oooooool00_ooo`090000oooo0000
oooo0000oooo0000oooo000000;oool010000?ooooooo`0000?oool300003_ooo`<00002oooo00H0
003oooooool0003oool00002oooo00<0003oool000001?ooo`040000oooooooo0000Ioooo`00N?oo
o`030000oooooooo00;oool2000000Koool00000003oool0003oool400000oooo`040000oooooooo
oooo0`0000koool01@000?ooooooo`000?ooo`0300000oooo`8000000oooo`000000000200000ooo
o`80001Xoooo001goooo00<0003oool000004_ooo`030000oooooooo01;oool01P000?ooooooo`00
0?ooo`0000Woool00`000?ooooooo`1]oooo001goooo0`00017oool200004oooo`@000000oooo`00
0000001ioooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ 0, 1\  - \ Normalization\)], "Input"],

Cell["\<\
imageNormalize=Compile[{{data2D,_Real,2}},
\t\tModule[{minimum=Min[data2D]},
\t\t\t(data2D-minimum)/Max[data2D-minimum]]];\
\>", "Input",
  FormatType->InputForm],

Cell["nsample=imageNormalize[sample2]; ", "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Shifted\ Photo\)], "Input"],

Cell["\<\
ssample=Table[1,{size[[1]]},{size[[2]]}];
\tDo[ssample[[i,j-3]]=sample[[i,j]],
\t\t{i,1,size[[1]]},{j,4,size[[2]]}];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\(Do[ssample[\([i, j]\)] = 0, \n\t\t{i, 4}, {j, 128}]; \)\)], "Input"],

Cell[BoxData[
    \(\(Do[ssample[\([i, j]\)] = 0, \n\t\t{i, 128}, {j, 125, \ 128}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Do[ssample[\([i, j]\)] = 0, \n\t\t{i, 125, 128}, {j, \ 128}]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(Do[ssample[\([i, j]\)] = 0, \n\t\t{i, 128}, {j, 4}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
ShiftedSimplePhoto=ListDensityPlot[ssample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Shifted Simple Photo\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SamplePhoto,ShiftedSimplePhoto}]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF0000000000
0000000000FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF0000000000
00000000FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF0000000000
00000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFF00000000
00000000FFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
0000000000000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF000000000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF0000000000
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFF00000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFF00000000
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF00000000
000000000000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF0000000000
00000000FFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFF00000000
00000000FFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFF00000000
00000000FF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFF00000000
000000000000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFF00000000
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFF00000000
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFF00000000
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFF00000000
00000000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF00000000
00000000FFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF00000000
00000000FFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF000000000000
00000000FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
0000000000000000
0000000000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000000000
0000000000FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000000000
000000000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FF00000000
0000000000FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFF00000000
00000000FFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF0000000000
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF0000000000
00000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF0000000000
00000000FFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
00000000FFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF000000000000
00000000FF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF000000000000
00000000FF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
00000000FFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FF00000000
00000000FF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FF00000000
00000000FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
00000000FF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF0000000000
00000000FFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF00000000
00000000FFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF0000000000
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00000000
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFF00000000
00000000FFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FF00000000
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFF00000000
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFF00000000
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFF00000000
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFF00000000
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFF00000000
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00000000
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFF00000000
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF0000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00000000
00000000FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -62 0 ]
[.5 1.0125 62 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -123 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Shifted) show
111.000000 13.000000 moveto
(Simple) show
153.000000 13.000000 moveto
(Photo) show
183.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
00000000FFFF00000000FFFFFF000000FFFFFFFFFFFFFF00
0000FFFFFF0000000000FF000000FF00FFFFFF0000FF00FF
FF00FF00FF00FFFF00FF00FF00FFFF000000FF000000FFFF
FF00FFFFFF000000000000FFFFFF0000FF00000000FF00FF
FFFFFFFF000000FF000000000000FFFF00FF00FF00FFFFFF
00FFFF0000000000
00000000FF0000FF00FFFF00FFFFFFFFFF00000000FFFF00
FFFF0000FF000000FF00FFFF0000000000000000FFFFFF00
0000000000FF0000FF00FFFF00FFFFFF00FF00FF00FF00FF
00FFFF00FFFF00FF000000000000FFFFFFFF0000FFFF0000
0000000000FFFFFF0000FFFF0000FF00FF0000FFFF00FFFF
00FFFF0000000000
000000000000FF00FF0000000000FF0000FF00FFFFFFFFFF
000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFFFF0000
000000FF000000FF00FF000000000000FF00FF0000FFFF00
FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF00FF00
00FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000FFFFFF
000000FF00000000
000000000000FFFF00FF00FF00000000FF0000FFFF00FFFF
0000FFFFFF00000000000000000000000000FF00FF000000
FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF000000
FF00FF00FFFF0000FFFFFF000000000000FFFFFF00FF00FF
00FFFF00000000FFFF00FF00000000000000FF00FFFFFFFF
FFFFFF0000000000
00000000FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF0000FF
00FF0000FF00FF0000FFFFFFFF00000000FF00FFFFFF00FF
FF00FF00FF000000FFFF00FF00FFFFFF00000000FF00FFFF
FFFF00FFFFFF00000000FFFFFFFF00FF0000FF00000000FF
FFFFFFFFFF00FF0000FF000000FF00FF000000FFFF000000
00FF000000000000
000000000000000000000000000000FF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF00FFFF
FF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFFFFFF00
00FF000000000000
00000000FF00000000000000000000000000000000000000
FF00000000000000000000000000FF000000000000000000
000000000000000000000000000000FFFF00000000000000
0000000000000000FF000000000000000000000000000000
000000000000000000000000000000000000FFFF00FFFFFF
00FF00FF00000000
000000000000000000000000000000000000000000000000
00FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF000000FF
00FFFFFF000000FF0000FFFFFF00FFFF0000000000FFFFFF
00000000FF0000FF000000FFFF0000FF0000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000FF0000000000
00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF00
FF00FFFFFFFF0000000000000000FF0000FF00000000FFFF
FFFF00FFFFFF00FFFF00000000FFFF000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000FF000000
FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF000000
00FFFF00000000FF0000FF000000FFFFFF00FFFF00FFFF00
000000000000FF0000000000FF0000000000000000000000
0000FF00FF00FFFFFF00FFFFFFFFFF000000000000000000
0000000000000000
000000000000FFFF00000000000000000000000000000000
0000FF00000000000000FF000000FFFF00FFFFFFFFFF00FF
00FFFF00FF0000FFFFFFFF0000000000FFFF00FF000000FF
FFFFFF000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF
FFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFF0000000000000000FF0000FFFF0000000000FFFFFF
FFFFFFFFFFFF0000FF0000FF00000000000000FFFF0000FF
00FF00000000000000000000000000FF0000000000000000
0000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FFFF
FFFF00FF00000000
00000000000000000000000000000000000000000000FF00
00FFFFFF000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF0000000000000000000000000000FFFF00000000000000
00000000FFFFFF000000000000FFFFFF0000FF00000000FF
FF0000FF00000000
000000000000000000000000000000FF00FF0000FFFFFFFF
00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000000000
00000000FFFFFFFFFF00FF0000FFFFFF00FFFF000000FFFF
00FF00FF00000000
000000000000000000000000000000000000FF00FFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF000000
00000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF00FFFF
FFFF00FF00000000
0000000000000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00000000
0000000000000000FFFFFFFFFF00FFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF00
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00FFFF00
000000000000FFFF0000FF0000FFFFFF0000FFFFFF0000FF
FFFF00FF00000000
00000000000000FFFFFF000000FFFFFFFF00FF00FF00FFFF
FF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00FF
00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFF
FF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFFFFFFFF
FFFFFF00000000000000000000FFFFFF0000FF00FF0000FF
FFFF000000000000
000000000000FFFFFFFFFF00FFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00FF00FF
FFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF00FFFF
FFFF000000000000
00000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF0000FF
FF00000000FFFFFFFF00FFFFFF00FFFFFF000000FFFFFFFF
FFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF0000FF
FFFF000000000000
00000000FFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FF00000000FFFFFF000000FFFF00FFFFFF000000FFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00FFFFFF
FFFF00FF00000000
00000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFF0000
FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFFFFFF00
FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFFFFFFFF
FFFF00FF00000000
00000000FF000000FFFFFF00000000FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FFFF00FF
FF00FFFF000000FFFFFFFFFFFF0000000000FFFF00FFFFFF
FF0000FF00000000
00000000FF00FF00FFFF0000000000FF0000FFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00FFFFFF
FFFFFFFFFF00FFFFFF0000FFFFFF00FF000000000000FFFF
FF0000FF00000000
00000000FF00FF00FF0000FF00FFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFFFFFFFF
00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFF00
0000000000000000
00000000000000FF0000FFFF00FFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFF
00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000000000
000000FF00000000
0000000000FFFF000000FFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00FFFF00
FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00000000000000FF
0000FFFF00000000
00000000FF000000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFF00FF
0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000000000
0000FFFF00000000
00000000000000FFFFFFFFFF00FFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FFFF000000000000
0000000000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFF
00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF00
FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF00FF00
00FFFFFFFFFFFFFFFF00FFFFFFFFFF0000000000000000FF
FFFFFF0000000000
00000000FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FF00FF
00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFFFF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FFFF
00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF0000FF
0000000000000000
00000000FFFFFF000000FFFFFF00FFFF0000FFFFFFFFFF00
FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF00FF00
FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FF00FFFFFF0000FF0000FF00FF0000000000000000FFFF
00FFFF0000000000
00000000FFFFFF0000FFFFFF00FF000000FFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFF000000000000FFFFFF0000FFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFF00FF
FFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF000000
00FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFF
00FFFF0000000000
00000000FFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FFFF0000
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF000000
0000FF0000FFFF00000000FFFF0000000000000000000000
0000000000000000
00000000FFFFFF000000FF00FF00FFFF00FFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FFFF00FF
FF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00000000
0000FF00FFFFFFFF0000FFFFFF000000000000FF0000FF00
00FF000000000000
000000000000FFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00FFFFFF
00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF000000
FFFFFFFFFFFFFF000000FFFF00000000000000000000FF00
00FF000000000000
00000000FFFF0000000000FFFF0000FF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFFFFFFFF
FFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFFFF00FF
FFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00FF00FF
FF000000FFFFFF0000FFFFFF000000000000000000000000
0000000000000000
00000000FFFFFF0000FFFFFFFF00FF0000FFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFFFF00FF
0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFFFF00FF
FFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00FF00FF
FFFF000000FFFF000000FF00000000000000000000000000
FFFF00FF00000000
00000000FFFF00FFFF00FFFF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF0000FF
FFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FFFF00FF
FFFF000000FFFF000000FFFF000000000000FF0000000000
FFFFFF0000000000
00000000FFFF00000000FFFF00FF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FF0000
FF00FF0000FF00FF00FF00000000000000FFFFFFFF000000
FF00000000000000
00000000FFFF0000FF00FFFF00000000FFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF000000
FF00FF00FFFFFF0000000000000000000000FFFFFFFFFFFF
000000FF00000000
00000000FFFF0000FF00FF0000000000FFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF00FFFF
FFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF00FFFF
FFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FFFFFF00
FFFF0000FF000000FF00FF000000FFFF00FFFFFF00000000
FF00000000000000
00000000FF000000FF000000FFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FFFFFF00
FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FFFF0000
FF0000000000000000000000FFFF0000FFFFFFFFFFFFFFFF
00FFFFFF00000000
00000000FFFF00FFFF0000FFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF000000FF
00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFFFF0000
FFFFFF000000FF000000FF0000FF00000000FFFFFFFFFF00
FF00FFFF00000000
00000000FFFFFF00FF000000FFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF00FFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF000000
FFFFFF00000000FF000000FFFFFFFFFF00FFFF00000000FF
FFFFFFFF00000000
0000000000FFFF00FF000000FFFF000000FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF0000FF00
FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF0000FF00
FFFFFFFF00000000
0000000000000000FF00000000FF000000FFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00FF00FF
FFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF0000
FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF00FFFF
FFFFFFFF00000000
000000000000FF00FFFF000000FF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000000000
FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF0000FF00
FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00FFFFFF
FFFFFFFF00000000
00000000000000000000000000FFFF0000FF00FFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF00FFFF
FFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFFFF0000
FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFFFFFFFF
FFFF00FF00000000
0000000000000000FF00FF0000FFFF0000FFFF00FFFFFF00
FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FFFFFFFF
FF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFF0000
00FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FF000000000000FF0000FF000000FFFFFF00FF00
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00FFFFFF
00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFF
FFFFFF0000000000
0000000000000000000000FFFFFFFF000000FFFFFF000000
FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF000000FF00FF0000FFFF000000FFFFFFFF0000FFFFFF
00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FFFFFF0000000000
00000000000000000000FFFFFFFFFFFF0000FFFFFFFFFFFF
FF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FF000000FF0000FFFF00FFFFFFFFFF0000000000FF0000FF
00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FFFFFFFF
FFFF00FF00000000
00000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
0000FFFFFF000000FFFFFF000000FF00FFFF0000000000FF
00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFFFF0000
0000FF000000000000000000FFFFFF00FF000000000000FF
FFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
FFFFFF0000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00000000
00FFFF0000000000000000000000FF00000000FF000000FF
FFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00FFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00FF0000
FF00000000000000000000000000FF00000000FF000000FF
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00FF00FF
00000000000000000000000000000000FF0000FF000000FF
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF00FFFF
00FF00FF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF0000000000FF00
00000000000000000000000000000000FF00FF00000000FF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000000000
0000000000000000000000000000000000000000000000FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000000000
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00000000
00000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFFFF00000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFFFFFF00000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000FFFF00FF00000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
0000000000FFFFFF000000000000FF000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF0000
FFFF00000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF000000
FF000000000000000000000000FF000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFF00
000000000000FFFFFF0000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF0000FF00
FF000000FFFF0000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000FFFF
00FFFF0000000000000000000000FF0000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FF00FF
FFFFFFFFFFFFFFFF00FFFF00000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FFFFFF00
FFFFFFFF0000FF0000000000FF0000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00FFFFFF
FFFFFFFF000000000000FFFF00FF00000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000FF00000000FF
00FF0000000000000000000000FF00000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF0000FF
FF00FF00000000000000000000FF00000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFF00FF
FF00FFFF00FF000000FF00FFFFFF000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFFFF
00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00000000
00FFFF00FF00FF000000FF000000000000FFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00FF0000
0000FFFFFFFFFF0000FF00000000000000FFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
0000FFFFFFFFFFFF000000FF0000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000000000
00000000FFFFFFFF000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00FF0000
0000000000FFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000FFFFFF
0000000000FFFF00000000FF000000FF00000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF0000FFFF
FF00000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000000000
00000000FFFFFFFF00000000000000000000000000FF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF00FF00
00000000FF00FFFF000000000000FFFFFFFF00FFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
FFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFF00000000
00000000FFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
0000000000000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{512, 243.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000800000laP00`40o`000?l0003oooooooooool2
oooo003oooooooooo`;oool00?oooooooooo0_ooo`00ooooooooool2oooo003oooooooooo`;oool0
0?oooooooooo0_ooo`00ooooooooool2oooo000Woooo00<0003oooooool06Oooo`<00003oooo00<0
003oooooool05_ooo`<00002oooo00<0003oooooool05_ooo`800004oooo00<0003oooooool05ooo
o`030000oooooooo00;oool00`000?ooooooo`0Boooo1@0000;oool00`000?ooooooo`02oooo00<0
003oooooool03oooo`D000001?ooo`000000000000?oool00`000?ooooooo`0ooooo00<0003ooooo
ool06?ooo`<00003oooo00<0003oooooool05_ooo`<00002oooo00<0003oooooool05_ooo`800004
oooo00<0003oooooool05oooo`030000oooooooo00;oool00`000?ooooooo`0Boooo1@0000;oool0
0`000?ooooooo`02oooo00<0003oooooool04?ooo`D000001?ooo`000000000000?oool00`000?oo
ooooo`0Joooo000Voooo00<0003oool000006_ooo`030000oooooooo00;oool00`000?ooo`00000H
oooo00H0003oooooool0003oool0000Goooo00<0003oool000000_ooo`030000oooo000001Ooool0
0`000?ooo`000002oooo00<0003oool000005Oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`00000Boooo00D0003oooooooooool000001?ooo`030000oooo000003ooool00`000?oo
o`00000Ioooo00<0003oooooool00_ooo`030000oooo000001Soool01P000?ooooooo`000?ooo`00
01Ooool00`000?ooo`000002oooo00<0003oool000005oooo`030000oooo000000;oool00`000?oo
o`00000Eoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000001?oool01@000?oo
ooooooooo`000004oooo00<0003oool000006oooo`009_ooo`030000oooo000001_oool01`000?oo
ooooooooo`000?ooo`00000Foooo10000004oooo0000oooo00005oooo`030000oooo000000;oool0
0`000?ooo`00000Goooo00<0003oool000000_ooo`030000oooo000001Goool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000004_ooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`00000ooooo00<0003oool000006_ooo`070000oooooooooooo0000oooo000001Koool4
000000Coool0003oool0000Goooo00<0003oool000000_ooo`030000oooo000001Ooool00`000?oo
o`000002oooo00<0003oool000005Oooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`00000Coooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000001_oool002Koool0
0`000?ooo`00000Koooo00L0003oooooooooool0003oool000005_ooo`030000oooo000000;oool0
0`000?ooo`00000Goooo0P0000?oool00`000?ooo`00000Hoooo00L0003oooooooooool0003oool0
00005Oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Boooo00<0003ooooo
ool00_ooo`070000oooooooooooo0000oooo000003ooool00`000?ooo`00000Joooo00L0003ooooo
ooooool0003oool000005_ooo`030000oooo000000;oool00`000?ooo`00000Goooo0P0000?oool0
0`000?ooo`00000Hoooo00L0003oooooooooool0003oool000005Oooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`00000Coooo00<0003oooooool00_ooo`070000oooooooooooo0000
oooo000001_oool002Koool00`000?ooo`00000Joooo00<0003oool000000_ooo`030000oooo0000
01Ooool200000_ooo`030000oooo000001Ooool00`000?ooooooo`02oooo00<0003oool000005ooo
o`030000oooo000000;oool00`000?ooo`00000Eoooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000001;oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool00000?ooo
o`030000oooo000001Woool00`000?ooo`000002oooo00<0003oool000005oooo`800002oooo00<0
003oool000005oooo`030000oooooooo00;oool00`000?ooo`00000Goooo00<0003oool000000_oo
o`030000oooo000001Goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000004ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo000Woooo00<0003ooooo
ool06_ooo`030000oooooooo00;oool00`000?ooooooo`0Goooo00D0003oooooooooool000006Ooo
o`800003oooo00<0003oooooool05oooo`030000oooooooo00;oool00`000?ooooooo`0Coooo0P00
00Coool00`000?ooooooo`02oooo00<0003oooooool04?ooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo03ooool00`000?ooooooo`0Ioooo00<0003oooooool00_ooo`030000oooooooo
01Ooool01@000?ooooooooooo`00000Ioooo0P0000?oool00`000?ooooooo`0Goooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool200001?ooo`030000oooooooo00;oool00`000?ooooooo`0A
oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool06_ooo`00ooooooooool2oooo003o
ooooooooo`;oool00?oooooooooo0_ooo`00ooooooooool2oooo000Tooooc@00037oooo=00004Ooo
o`009?ooo`050000oooooooooooo000000Ooool00`000?ooooooo`04oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`04oooo0P00037oool01@000?ooooooooooo`000007oooo00<0003oooooool01?ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01?ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01?ooo`80000Aoooo000Noooo00<0003oooooool00oooo`030000oooooooo
0<Woool00`000?ooooooo`0Zoooo00<0003oooooool00_ooo`030000oooooooo0<Woool00`000?oo
ooooo`0?oooo000Moooo00<0003oool000001?ooo`030000oooooooo0<Woool00`000?ooooooo`0Y
oooo00<0003oool000000oooo`030000oooooooo0<Woool00`000?ooooooo`0?oooo000Moooo00<0
003oool000001?ooo`800039oooo0P0002_oool00`000?ooo`000003oooo0P000<Woool200004Ooo
o`007Oooo`030000oooo000000Coool010000?oooooooooool@00004oooo00<0003oooooool0:Ooo
o`030000oooo000000?oool010000?oooooooooool@00004oooo00<0003oooooool03oooo`007Ooo
o`030000oooo000000Coool010000?oooooooooool@00004oooo00<0003oooooool0:Oooo`030000
oooo000000?oool010000?oooooooooool@00004oooo00<0003oooooool03oooo`007_ooo`030000
oooooooo00?oool010000?oooooooooool@00004oooo00<0003oooooool0:_ooo`030000oooooooo
00;oool010000?oooooooooool@00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooo
ooooa00000Coool00`000?ooooooo`0_oooo00@0003oooooooooooo400001?ooo`030000oooooooo
00ooool002Coool010000?oooooooooool@00004oooo00<0003oooooool0;oooo`040000oooooooo
ooooa00000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooooo400001?ooo`030000
oooooooo02ooool010000?oooooooooool@00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo1P0000;oool00`000?ooooooo`03oooo1P0000Goool400002oooo`@00005oooo2000
0003oooo0000000000<000000oooo`0000000004oooo10000003oooo0000000000?oool010000?oo
ooooo`0000;oool010000?ooooooooooo`8000001?ooo`0000000?ooo`800003oooo1@000003oooo
0000000000<00004oooo0P0000Goool900001?ooo`<00002oooo1P0000;oool00`000?ooooooo`06
oooo100000;oool900000oooo`8000001?ooo`0000000?ooo`800004oooo200000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool600000oooo`H00005oooo1@0000[oool500001?ooo`P00002
oooo100000;oool00`000?ooooooo`03oooo0`000003oooo0000000000?oool2000000Coool00000
003oool200000oooo`040000oooooooo00000_ooo`040000oooooooooooo1@0000;oool400001Ooo
o`030000oooooooo00?oool900001Oooo`<000000oooo`000000000400000_ooo`030000oooooooo
00Koool5000000?oool0000000001`0000Coool010000?ooooooo`0000;oool00`000?ooooooo`03
oooo00@0003oooooooooool800001?ooo`030000oooooooo00ooool002Coool200000_ooo`H00002
oooo00<0003oooooool00oooo`H00005oooo100000_oool400001Oooo`P000000oooo`0000000003
000000?oool0000000001?ooo`@000000oooo`0000000003oooo00@0003oooooool00002oooo00@0
003oooooooooool2000000Coool00000003oool200000oooo`D000000oooo`000000000300001?oo
o`800005oooo2@0000Coool300000_ooo`H00002oooo00<0003oooooool01_ooo`@00002oooo2@00
00?oool2000000Coool00000003oool200001?ooo`P00003oooo0P00037oool200000_ooo`H00003
oooo1P0000Goool500002_ooo`D00004oooo200000;oool400000_ooo`030000oooooooo00?oool3
000000?oool0000000000oooo`8000001?ooo`0000000?ooo`800003oooo00@0003oooooool00002
oooo00@0003oooooooooool500000_ooo`@00005oooo00<0003oooooool00oooo`T00005oooo0`00
0003oooo0000000000@00002oooo00<0003oooooool01_ooo`D000000oooo`000000000700001?oo
o`040000oooooooo00000_ooo`030000oooooooo00?oool010000?ooooooooooo`P00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo200000Coool300000_ooo`040000oooooooo
oooo0P0000Soool600000oooo`040000oooooooooooo0`0000;oool5000000?oool0000000000ooo
o``00005oooo2@000004oooo0000000000000_ooo`040000oooooooooooo0P0000Goool010000?oo
ooooo`0000;oool010000?ooooooo`0000;oool010000?ooooooooooo`800003oooo0P000003oooo
0000000000L00006oooo0`0000Coool:00001Oooo`<00003oooo0`0000;oool00`000?ooooooo`03
00000oooo`040000oooooooooooo200000Coool00`000?ooooooo`0_oooo00@0003oooooooooool6
00000_ooo`<000000oooo`0000000003oooo00<0003oooooool01_ooo`H00003oooo0P0000?oool3
000000?oool0000000000`0000;oool010000?ooooooooooo``00005oooo2@0000;oool3000000?o
ool0000000000oooo`030000oooooooo00?oool2000000Coool00000003oool2000000Coool00000
003oool200000oooo`040000oooooooooooo0P0000;oool900001_ooo`<00003oooo2`0000Coool3
00000oooo`<00002oooo0P000004oooo0000000000000oooo`800003oooo00@0003oooooooooool8
00001?ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H00002oooo00<0003ooooo
ool00`000004oooo00000000oooo200000;oool3000000?oool0000000001oooo`D00005oooo00@0
003oooooooooool500001oooo`<00005oooo20000003oooo0000000000<000001?ooo`0000000?oo
o`X000001?ooo`0000000?ooo`<00003oooo0P0000?oool00`000?ooooooo`05oooo0`000004oooo
00000000oooo0P000003oooo0000000000?oool00`000?ooooooo`03oooo0P000004oooo00000000
00003?ooo`<00007oooo00@0003oooooooooool500001?ooo`P00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo2@0000;oool00`000?ooooooo`0700000_ooo`<00002oooo00<0003ooooo
ool01_ooo`@00005oooo00<0003oooooool00_ooo`@00008oooo0`0000Coool800000_ooo`@00002
oooo00<0003oooooool02@0000;oool00`000?ooooooo`0300000oooo`040000oooooooooooo0P00
00Koool300000_ooo`040000oooooooo00000_ooo`040000oooooooooooo0P0000Coool2000000?o
ool0000000000P0000coool300001_ooo`800003oooo100000Goool400000_ooo`H00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo1P0000;oool00`000?ooooooo`03000000Co
ool00000003oool800000_ooo`<000000oooo`0000000007oooo1@0000Goool010000?oooooooooo
o`D00007oooo0`0000Goool8000000?oool0000000000`000004oooo00000000oooo2P000004oooo
00000000oooo0`0000?oool200000oooo`030000oooooooo00Goool3000000Coool00000003oool2
000000?oool0000000000oooo`030000oooooooo00?oool2000000Coool000000000000<oooo0`00
00Ooool010000?ooooooooooo`D00004oooo200000Coool00`000?ooooooo`0_oooo00@0003ooooo
ooooool900000_ooo`030000oooooooo00L00002oooo0`0000;oool00`000?ooooooo`06oooo1000
00Goool00`000?ooooooo`02oooo100000Soool300001?ooo`P00002oooo100000;oool00`000?oo
ooooo`0900000_ooo`030000oooooooo00<00003oooo00@0003oooooooooool200001_ooo`<00002
oooo00@0003oooooool00002oooo00@0003oooooooooool200001?ooo`8000000oooo`0000000002
00003?ooo`<00006oooo0P0000?oool400001Oooo`@00002oooo1P0000Coool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool600000oooo`D00003oooo00@0003oooooool00002oooo1P00
00;oool300000oooo`040000oooooooooooo0`0000GooolD000000?oool0000000000_ooo`@00008
oooo0`000003oooo0000000000?oool300000_ooo`030000oooooooo00?oool010000?oooooooooo
o`D000001?ooo`0000000?ooo`800003oooo0`0000Goool900001?ooo`800002oooo00@0003ooooo
ool00003oooo1P0000?oool2000000?oool0000000002@0000;oool00`000?ooooooo`06oooo1P00
00Coool00`000?ooooooo`0_oooo00@0003oooooooooool900000oooo`8000001?ooo`0000000?oo
o`L000001?ooo`000000000000?oool200000oooo`<00004oooo500000;oool00`000?ooooooo`05
00001oooo`<00002oooo00@0003oooooooooool300000_ooo`030000oooooooo00?oool200000ooo
o`@00002oooo00@0003oooooool00003oooo100000Coool900001Oooo`040000oooooooo00000_oo
o`800003oooo1P0000?oool00`000?ooooooo`0;000000?oool0000000002_ooo`P00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo1P0000?oool200001oooo`8000000oooo`00
00000003oooo0P0000?oool00`000?ooooooo`03oooo0`000004oooo00000000oooo0`0000;oool2
000000Coool0000000000006oooo1P0000;oool00`000?ooooooo`03oooo0P0000?oool010000?oo
ooooo`0000;oool400000oooo`8000000oooo`0000000005oooo1P000003oooo0000000000Koool0
0`000?ooooooo`03oooo1P0000Koool2000000Coool0000000000002oooo1P0000Woool2000000Co
ool0000000000002oooo1@000004oooo00000000oooo1@0000?oool<00001?ooo`030000oooooooo
02ooool010000?ooooooooooo`H00008oooo00@0003oooooool00003oooo0P0000?oool200001?oo
o`<00002oooo00<0003oooooool00`000004oooo00000000oooo100000Koool6000000?oool00000
00001?ooo`800003oooo0P000004oooo00000000oooo1@0000?oool010000?ooooooo`0000Goool6
00000_ooo`030000oooooooo00Coool200001?ooo`L00006oooo00<0003oooooool00`000003oooo
0000000000@0000:oooo00<0003oooooool00`000003oooo0000000000<000000oooo`0000000002
oooo100000?oool600000_ooo`T00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooo
oooo1P0000?oool200001oooo`8000000oooo`0000000003oooo0P0000?oool00`000?ooooooo`03
oooo0`000004oooo00000000oooo0`0000;oool2000000Coool0000000000006oooo1P0000;oool0
0`000?ooooooo`03oooo0P0000?oool010000?ooooooo`0000;oool400000oooo`8000000oooo`00
00000005oooo1P000003oooo0000000000Koool00`000?ooooooo`03oooo1P0000Koool2000000Co
ool0000000000002oooo1P0000Woool2000000Coool0000000000002oooo1@000004oooo00000000
oooo1@0000?oool<00001?ooo`030000oooooooo02ooool010000?ooooooooooo`H00008oooo00@0
003oooooool00003oooo0P0000?oool200001?ooo`<00002oooo00<0003oooooool00`000004oooo
00000000oooo100000Koool6000000?oool0000000001?ooo`800003oooo0P000004oooo00000000
oooo1@0000?oool010000?ooooooo`0000Goool600000_ooo`030000oooooooo00Coool200001?oo
o`L00006oooo00<0003oooooool00`000003oooo0000000000@0000:oooo00<0003oooooool00`00
0003oooo0000000000<000000oooo`0000000002oooo100000?oool600000_ooo`T00004oooo00<0
003oooooool03oooo`009?ooo`800002oooo70000003oooo000000000440000Koooo00<0003ooooo
ool00`0000Ooool200002Oooo`800004oooo0`0000?oool200001oooo`800003oooo0P0000?oool0
0`000?ooooooo`06oooo2@0000?oool20000<Oooo`800002oooo5`0000;ooom300006_ooo`030000
oooooooo00<00008oooo00<0003oooooool01oooo`800005oooo0`0000?oool00`000?ooooooo`06
oooo00@0003oooooooooool200000oooo`800007oooo0`0000;oool900001?ooo`030000oooooooo
00ooool002Coool010000?ooooooooooo`H00006oooo7@0000;ooolD000000?oool0000000008`00
00?ooolG00000_oooc800003oooo0P0000Coool800001?ooo`030000oooooooo02ooool010000?oo
ooooooooo`H00002oooo7@000003oooo0000000001800002oooo900000CooolG000000?oool00000
0000<@0000?oool00`000?ooooooo`03oooo00@0003oooooool00002oooo1P0000Coool00`000?oo
ooooo`0?oooo000Toooo00@0003oooooooooool600001_oooad00002oooo50000003oooo00000000
02<00003oooo5`0000;ooolb00000oooo`800004oooo200000Coool00`000?ooooooo`0_oooo00@0
003oooooooooool600000_oooad000000oooo`000000000B00000_ooob@00004oooo5`000003oooo
0000000003400003oooo00<0003oooooool00oooo`040000oooooooo00000_ooo`H00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo:`000003oooo0000000000<00006oooo0`00
00?oool200002Oooo`D000000oooo`0000000004oooo1@000004oooo0000000000001Oooo`800003
oooo1`0000Goool600000_ooo`<000000oooo`000000000300000oooo`<000000oooo`000000000g
00001?ooo`030000oooooooo02ooool010000?ooooooooooobH00002oooo100000Ooool300000ooo
o`030000oooooooo00Ooool500000_ooo`030000oooooooo00?oool400000_ooo`<00004oooo0P00
00?oool800001?ooo`H00002oooo0`0000;oool400000oooo`<00002oooo?@0000Coool00`000?oo
ooooo`0?oooo000Toooo00@0003ooooooooooolP00000_ooo`T000001?ooo`000000000001Koool6
00000_ooo`040000oooooooo00001_ooo`d000001?ooo`000000000000;oool600001_ooo`030000
oooooooo00?oool200000oooo`H00003oooo>P0000Coool00`000?ooooooo`0_oooo00@0003ooooo
oooooolL000000?oool0000000001`0000;oool300005Oooo`H00002oooo0P000003oooo00000000
00Koool<000000?oool0000000000P000003oooo0000000000@00006oooo0P0000Coool200000ooo
o`H00003oooo?`0000Coool00`000?ooooooo`0?oooo000Toooo00@0003ooooooooooolP00000_oo
o`T000001?ooo`000000000001Koool600000_ooo`040000oooooooo00001_ooo`d000001?ooo`00
0000000000;oool600001_ooo`030000oooooooo00?oool200000oooo`H00003oooo>P0000Coool0
0`000?ooooooo`0_oooo00@0003ooooooooooolL000000?oool0000000001`0000;oool300005Ooo
o`H00002oooo0P000003oooo0000000000Koool<000000?oool0000000000P000003oooo00000000
00@00006oooo0P0000Coool200000oooo`H00003oooo?`0000Coool00`000?ooooooo`0?oooo000T
oooo00@0003ooooooooooolS00000_ooo`@00003oooo2P000003oooo0000000000<0000>oooo1P00
00?oool6000000Coool0000000000002oooo1@0000Coool200000oooo`040000oooooooooooo2`00
00;oool700000_oooa@000001?ooo`0000000?ooo`800004oooo0P0000SooolE00001?ooo`030000
oooooooo02ooool010000?oooooooooooal000000oooo`000000000300000oooo`T00002oooo1000
00koool600000oooo`H00002oooo0`000003oooo0000000000<00005oooo00@0003oooooooooool2
00000oooo`X00002oooo20000003oooo0000000001800002oooo00@0003oooooool00005oooo00<0
003oooooool01_oooaX00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P00
00Goool300000ooooa/00002oooo2`000003oooo0000000000<00003oooo00<0003oooooool01_oo
o`8000000oooo`0000000003oooo00<0003oooooool00`0000Koool800000oooo`030000oooooooo
00@00006oooo90000003oooo0000000001;oool200001_ooo`030000oooooooo00?oool600001?oo
o`030000oooooooo02ooool010000?ooooooooooo`T00003oooo70000003oooo0000000000T00002
oooo100000?oool200001oooo`800002oooo00@0003oooooooooool2000000Coool0000000000006
oooo200000?oool2000000?oool0000000000`0000KooolS00000_ooo`030000oooooooo017oool0
0`000?ooooooo`04oooo0P0000Woool600001?ooo`030000oooooooo00ooool002Coool200000_oo
o`H00005oooo0`0000?ooolK00000_ooo`/000000oooo`000000000300000oooo`030000oooooooo
00Koool2000000?oool0000000000oooo`030000oooooooo00<00006oooo200000?oool00`000?oo
ooooo`0400001_ooob@000000oooo`000000000Boooo0P0000Koool00`000?ooooooo`03oooo1P00
00?oool20000<Oooo`800002oooo2@0000?ooolL000000?oool0000000002@0000;oool400000ooo
o`800007oooo0P0000;oool010000?ooooooooooo`8000001?ooo`000000000000Koool800000ooo
o`8000000oooo`000000000300001_ooob<00002oooo00<0003oooooool04Oooo`030000oooooooo
00Coool200002Oooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo9@00
00Woool<00000_ooo`<00003oooo200000goool300000_ooo`<000000oooo`000000000900000ooo
o`<00002oooo00<0003oooooool050000003oooo0000000000h000000oooo`000000000<oooo0`00
00?oool200001_ooo`030000oooooooo00?oool600001?ooo`030000oooooooo02ooool010000?oo
ooooooooob000009oooo3@000004oooo0000000000000oooo`P0000>oooo0`000004oooo00000000
00000_ooo`/00003oooo0`000004oooo00000000oooo500000;oool?00000_ooo`030000oooooooo
00[oool300001?ooo`030000oooooooo00Coool200001_ooo`030000oooooooo00H00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo9@0000Woool<00000_ooo`<00003oooo2000
00goool300000_ooo`<000000oooo`000000000900000oooo`<00002oooo00<0003oooooool05000
0003oooo0000000000h000000oooo`000000000<oooo0`0000?oool200001_ooo`030000oooooooo
00?oool600001?ooo`030000oooooooo02ooool010000?ooooooooooob000009oooo3@000004oooo
0000000000000oooo`P0000>oooo0`000004oooo0000000000000_ooo`/00003oooo0`000004oooo
00000000oooo500000;oool?00000_ooo`030000oooooooo00[oool300001?ooo`030000oooooooo
00Coool200001_ooo`030000oooooooo00H00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo9P0000;oool300001?oooa<0000Xoooo00<0003oooooool01ooooaH00003oooo4@00
00Coool:00001?ooo`<00002oooo1P0000?oool600001?ooo`030000oooooooo02ooool010000?oo
ooooooooob8000001?ooo`000000000000GooolB0000:?ooo`800009oooo5@0000?ooolA00001Ooo
o`T00005oooo0`000003oooo0000000000@00003oooo0`0000;oool600001?ooo`030000oooooooo
00ooool002Coool010000?oooooooooooa`000001?ooo`0000000?ooo`<00006oooo0P0000Koool3
00002Oooo`8000000oooo`000000000goooo0P0000?oool010000?ooooooo`0000Koool200001_oo
o`h00007oooo0P000003oooo0000000000800004oooo0P0000?oool400000oooo`P00004oooo00<0
003oooooool0;oooo`040000oooooooooooo5`0000;oool00`000?ooooooo`0300001_ooo`030000
oooooooo00Coool300002_ooo`040000oooooooo0000=oooo`800003oooo0P000003oooo00000000
00Koool00`000?ooooooo`04oooo3P0000Soool00`000?ooooooo`0300001Oooo`040000oooooooo
oooo1@0000?oool010000?ooooooo`0000;oool600001?ooo`030000oooooooo00ooool002Coool0
10000?oooooooooooa`000001?ooo`0000000?ooo`<00006oooo0P0000Koool300002Oooo`800000
0oooo`000000000goooo0P0000?oool010000?ooooooo`0000Koool200001_ooo`h00007oooo0P00
0003oooo0000000000800004oooo0P0000?oool400000oooo`P00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo5`0000;oool00`000?ooooooo`0300001_ooo`030000oooooooo00Coool3
00002_ooo`040000oooooooo0000=oooo`800003oooo0P000003oooo0000000000Koool00`000?oo
ooooo`04oooo3P0000Soool00`000?ooooooo`0300001Oooo`040000oooooooooooo1@0000?oool0
10000?ooooooo`0000;oool600001?ooo`030000oooooooo00ooool001Soool300000oooo`030000
oooooooo00?oool010000?ooooooooooo`H00005oooo5@0000;oool00`000?ooooooo`06oooo00<0
003oooooool04_ooo`80000Aoooo00<0003oooooool08Oooo`80000?oooo0P000003oooo00000000
00Koool;00001oooo`8000000oooo`000000000200001?ooo`800006oooo00<0003oooooool00ooo
o`H00004oooo00<0003oooooool09?ooo`<00003oooo00<0003oooooool00_ooo`040000oooooooo
oooo70000003oooo0000000000Ooool200005?ooo`030000oooooooo00ooool200008oooo`030000
oooooooo00koool010000?ooooooo`0000Koool;00002?ooo`030000oooooooo00<00005oooo00<0
003oooooool01?ooo`800006oooo00<0003oooooool01P0000Coool00`000?ooooooo`0?oooo000H
oooo00<0003oooooool00_ooo`030000oooo000000Coool010000?ooooooooooo`H00005oooo3`00
02Koool200002Oooo`800006oooo0`0001_oool2000000?oool0000000004_ooo`80000;oooo2P00
01ooool600001?ooo`030000oooooooo02Coool00`000?ooooooo`02oooo00<0003oool000000ooo
o`040000oooooooooooo5@0002Ooool00`000?ooooooo`07oooo0P0000Koool300007?ooo`040000
oooooooo00004oooo`030000oooooooo00Woool;00008?ooo`030000oooooooo00H00004oooo00<0
003oooooool03oooo`006Oooo`070000oooooooooooo0000oooo000000Coool200000_ooo`H00005
oooo3`0002Koool200002Oooo`800006oooo0`0001_oool2000000?oool0000000004_ooo`80000;
oooo2P0001ooool600000oooo`80000Woooo00L0003oooooooooool0003oool000000oooo`800002
oooo5@0002Ooool00`000?ooooooo`07oooo0P0000Koool300007?ooo`040000oooooooo00004ooo
o`030000oooooooo00Woool;00008?ooo`030000oooooooo00H00003oooo0P00017oool001Woool0
1`000?ooooooooooo`000?ooo`000004oooo00@0003oooooooooool600001Oooo`H00008oooo00<0
003oooooool01_ooo`030000oooooooo00[oool200003oooo`800006oooo0P0000?oool00`000?oo
ooooo`06oooo00<0003oooooool06oooo`8000000oooo`000000000200002_ooo`800003oooo00<0
003oooooool01?ooo`800003oooo2`0000?oool3000000?oool0000000000P0000Coool300001Ooo
o`<00003oooo1P0000Coool00`000?ooooooo`0Uoooo00L0003oooooooooool0003oool000000ooo
o`040000oooooooooooo300000Soool00`000?ooooooo`06oooo0P0000coool00`000?ooooooo`0>
oooo00<0003oooooool01?ooo`800003oooo0P0000Ooool200007Oooo`030000oooooooo00<0000;
oooo00@0003oooooooooool200001_ooo`040000oooooooooooo2`0000?oool300000_ooo`<00005
oooo0`0000Coool300001Oooo`030000oooooooo00H00004oooo00<0003oooooool03oooo`006?oo
o`030000oooo000000;oool00`000?ooo`000004oooo00@0003oooooooooool600000_ooo`L00005
oooo1@0000Koool010000?ooooooo`0000;oool00`000?ooooooo`03oooo0`0001;oool200001?oo
o`800003oooo0P000003oooo0000000000Coool200001oooo`8000000oooo`000000000Boooo0P00
0003oooo0000000000800009oooo00<0003oooooool00oooo`@0000>oooo400000Coool300000_oo
o`030000oooooooo00<00003oooo1P0000Coool00`000?ooooooo`0Toooo00<0003oool000000_oo
o`030000oooo000000?oool010000?ooooooooooo`/00004oooo1@0000Koool2000000Coool00000
003oool200001?ooo`<0000Coooo00<0003oooooool00oooo`040000oooooooooooo0P0000;oool0
0`000?ooooooo`03oooo00<0003oooooool01_ooo`040000oooooooo00004oooo`030000oooooooo
00<00009oooo0P0000Coool500003_ooo`l00005oooo0`000004oooo00000000oooo0`0000Goool9
00001?ooo`030000oooooooo00ooool001Woool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`040000oooooooooooo1P0000;oool700001Oooo`D00006oooo00@0003oooooool00002oooo00<0
003oooooool00oooo`<0000Boooo0P0000Coool200000oooo`8000000oooo`0000000004oooo0P00
00Ooool2000000?oool0000000004_ooo`8000000oooo`000000000200002Oooo`030000oooooooo
00?oool400003_oooa000004oooo0`0000;oool00`000?ooooooo`0300000oooo`H00004oooo00<0
003oooooool09Oooo`030000oooooooo00;oool00`000?ooooooo`02oooo00@0003oooooooooool;
00001?ooo`D00006oooo0P000004oooo00000000oooo0P0000Coool300004oooo`030000oooooooo
00?oool010000?ooooooooooo`800002oooo00<0003oooooool00oooo`030000oooooooo00Koool0
10000?ooooooo`0001?oool00`000?ooooooo`0300002Oooo`800004oooo1@0000koool?00001Ooo
o`<000001?ooo`0000000?ooo`<00005oooo2@0000Coool00`000?ooooooo`0?oooo000Toooo00@0
003oooooooooool>00001oooo`800006oooo1@0000?oool00`000?ooooooo`0Hoooo0P0000Coool2
00001_ooo`800006oooo00<0003oooooool01oooo`80000?oooo0P0000?oool500001oooo`H00003
oooo0`0000?oool200000_ooo`030000oooooooo00Ooool300000_ooo`<00003oooo0`0000?oool3
00001Oooo`030000oooooooo00?oool600001?ooo`030000oooooooo02ooool010000?oooooooooo
o`T00008oooo00<0003oooooool01Oooo`@00003oooo0P0001[oool00`000?ooooooo`03oooo00<0
003oooooool01Oooo`030000oooooooo00Coool200002Oooo`030000oooooooo00koool010000?oo
ooooooooo`D00008oooo1P0000?oool300000oooo`040000oooooooo00002_ooo`<000001?ooo`00
0000000000?oool300001?ooo`<00004oooo0P0000Koool900001?ooo`030000oooooooo00ooool0
02Coool010000?ooooooooooo`/00009oooo00<0003oooooool00P0000Woool300006oooo`80000<
oooo0P0000Koool00`000?ooooooo`04oooo0P0000?oool200002_ooo`<00003oooo1`0000Koool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`@0000Aoooo0P0000?oool500000oooo`@00005
oooo0`0000?oool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H00009oooo0P00
0003oooo0000000000Woool300007?ooo`030000oooooooo00_oool00`000?ooooooo`04oooo0P00
00Koool010000?ooooooooooo`80000;oooo0`0000?oool600001_ooo`800004oooo0P0000Coool5
00004Oooo`040000oooooooooooo1@0000?oool500001?ooo`<00005oooo2@0000Coool00`000?oo
ooooo`0?oooo000Toooo00@0003oooooooooool;00002Oooo`030000oooooooo00800009oooo0`00
01_oool200003?ooo`800006oooo00<0003oooooool01?ooo`800003oooo0P0000[oool300000ooo
o`L00006oooo00<0003oooooool00oooo`030000oooooooo00?oool400004Oooo`800003oooo1@00
00?oool400001Oooo`<00003oooo1P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool6
00002Oooo`8000000oooo`0000000009oooo0`0001coool00`000?ooooooo`0;oooo00<0003ooooo
ool01?ooo`800006oooo00@0003oooooooooool200002oooo`<00003oooo1P0000Koool200001?oo
o`800004oooo1@00017oool010000?ooooooooooo`D00003oooo1@0000Coool300001Oooo`T00004
oooo00<0003oooooool03oooo`009?ooo`800002oooo200000ooool2000000Coool0000000000005
oooo00<0003oooooool01oooo`80000Boooo0P0000koool00`000?ooooooo`04oooo0P0000Ooool4
00004?ooo`L00004oooo1@0000?oool00`000?ooooooo`03oooo100000Goool300004Oooo`<00003
oooo0`0000?oool200001_ooo`H00003oooo0P00037oool200000_ooo`H0000<oooo0P000003oooo
0000000000800004oooo0P0000Woool00`000?ooooooo`0Aoooo00<0003oooooool03?ooo`800006
oooo00<0003oooooool01_ooo`<0000Aoooo1P0000Goool400000oooo`800004oooo1@0000Coool4
00004?ooo`<00004oooo0`0000?oool00`000?ooooooo`06oooo00<0003oooooool01P0000Coool0
0`000?ooooooo`0?oooo000Toooo00@0003oooooooooool;00003_ooo`@0000?oooo0P0001;oool2
00005Oooo`<00008oooo0P0000coool300000oooo`H0000;oooo00<0003oooooool00oooo`<00006
oooo0P0000Coool600002_ooo`L0000;oooo1P0000Coool00`000?ooooooo`0_oooo00@0003ooooo
ooooool600003_ooo`D0000?oooo00<0003oooooool04Oooo`030000oooooooo01Coool300001ooo
o`80000<oooo0`0000?oool600002oooo`800004oooo0`0000Koool200001Oooo`H00009oooo2000
00coool00`000?ooooooo`0600001?ooo`030000oooooooo00ooool002Coool010000?oooooooooo
o`/0000>oooo100000ooool200004_ooo`80000Eoooo0`0000Soool200003?ooo`<00003oooo1P00
00_oool00`000?ooooooo`03oooo0`0000Koool200001?ooo`H0000:oooo1`0000_oool600001?oo
o`030000oooooooo02ooool010000?ooooooooooo`H0000>oooo1@0000ooool00`000?ooooooo`0A
oooo00<0003oooooool05?ooo`<00007oooo0P0000coool300000oooo`H0000;oooo0P0000Coool3
00001_ooo`800005oooo1P0000Woool800003?ooo`030000oooooooo00H00004oooo00<0003ooooo
ool03oooo`009?ooo`040000oooooooooooo1P0000;oool010000?ooooooooooo`D00004oooo1`00
0004oooo00000000oooo0P0001koool200005Oooo`<0000Loooo1P0000Soool00`000?ooooooo`07
oooo0`0000Coool010000?ooooooooooo`800003oooo100000[oool700000oooo`800006oooo1P00
00Coool00`000?ooooooo`0_oooo00@0003oooooooooool600000_ooo`@00005oooo1P0000;oool0
10000?ooooooo`0001ooool00`000?ooooooo`0Doooo0`0001_oool600002?ooo`800009oooo0`00
00?oool00`000?ooooooo`02oooo00@0003oooooooooool500002Oooo`P00003oooo00<0003ooooo
ool01?ooo`<00002oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool6
00001_ooo`8000000oooo`0000000003oooo20000004oooo0000000000003?ooo`80000Aoooo0`00
01Ooool00`000?ooooooo`0Hoooo200000Soool010000?ooooooo`0000Koool2000000?oool00000
00003?ooo`800004oooo0`0000Goool2000000?oool0000000001`0000Goool600001?ooo`030000
oooooooo02ooool010000?ooooooooooo`H00002oooo00@0003oooooool00003oooo200000;oool3
00003?ooo`030000oooooooo00ooool300005oooo`80000Joooo1`0000Soool2000000?oool00000
00001_ooo`040000oooooooo00003Oooo`030000oooooooo00?oool300001?ooo`800002oooo2@00
00Coool300000_ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P00
00Koool2000000?oool0000000000oooo`P000001?ooo`000000000000coool200004Oooo`<0000G
oooo00<0003oooooool06?ooo`P00008oooo00@0003oooooool00006oooo0P000003oooo00000000
00coool200001?ooo`<00005oooo0P000003oooo0000000000L00005oooo1P0000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool600000_ooo`040000oooooooo00000oooo`P00002oooo0`00
00coool00`000?ooooooo`0?oooo0`0001Ooool200006_ooo`L00008oooo0P000003oooo00000000
00Koool010000?ooooooo`0000goool00`000?ooooooo`03oooo0`0000Coool200000_ooo`T00004
oooo0`0000;oool600001?ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H00006
oooo0P000004oooo00000000oooo0`0000;oool200001?ooo`<0000Poooo0P0001Goool2000000?o
ool0000000001?ooo`@0000?oooo00<0003oooooool00`0000Goool010000?ooooooo`0000;oool3
00001oooo`<00007oooo00<0003oooooool05?ooo`T00003oooo2@0000Coool00`000?ooooooo`0_
oooo00@0003oooooooooool600000_ooo`040000oooooooo00000_ooo`<000000oooo`0000000005
oooo0`00023oool00`000?ooooooo`0Doooo00@0003oooooool00005oooo0`0000ooool2000000Co
ool0000000000005oooo0P000004oooo00000000oooo0`0000Soool300001_ooo`80000Eoooo2@00
00?oool>00001?ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H00002oooo00<0
003oooooool0100000;oool300000oooo`800007oooo0P0001koool200005oooo`<00008oooo00<0
003oooooool03?ooo`030000oooooooo00?oool200000oooo`030000oooooooo00Coool200001_oo
o`<000000oooo`000000000Eoooo0P0000Koool200000oooo`l00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo2`000004oooo0000000000000oooo`800008oooo00<0003oooooool07Ooo
o`030000oooooooo01Goool300002?ooo`030000oooooooo00coool200001?ooo`800003oooo0P00
00Koool00`000?ooooooo`04oooo0`0000;oool00`000?ooooooo`0Doooo00<0003oooooool01Ooo
o`040000oooooooooooo300000;oool600001?ooo`030000oooooooo00ooool002Coool200000_oo
o`H00002oooo00<0003oooooool0100000;oool300000oooo`800007oooo0P0001koool200005ooo
o`<00008oooo00<0003oooooool03?ooo`030000oooooooo00?oool200000oooo`030000oooooooo
00Coool200001_ooo`<000000oooo`000000000Eoooo0P0000Koool200000oooo`l00003oooo0P00
037oool200000_ooo`/000001?ooo`000000000000?oool200002?ooo`030000oooooooo01goool0
0`000?ooooooo`0Eoooo0`0000Soool00`000?ooooooo`0<oooo0P0000Coool200000oooo`800006
oooo00<0003oooooool01?ooo`<00002oooo00<0003oooooool05?ooo`030000oooooooo00Goool0
10000?ooooooooooo``00002oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003ooooo
ooooool800000oooo`040000oooooooooooo1@0000_oool00`000?ooooooo`09oooo00<0003ooooo
ool03oooo`<0000Goooo0P000004oooo0000000000001oooo`030000oooooooo013oool200003?oo
o`800006oooo0`000003oooo0000000000?oool200003?ooo`<00009oooo2`000003oooo00000000
00H00004oooo00<0003oooooool0;oooo`040000oooooooooooo200000?oool400002oooo`80000:
oooo0P00017oool300005oooo`030000oooooooo00<00006oooo00<0003oooooool04Oooo`030000
oooooooo00_oool00`000?ooooooo`04oooo0`0000;oool010000?ooooooooooo`80000<oooo0`00
00[oool:00000_ooo`<00003oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003ooooo
ooooool800001?ooo`D0000<oooo0P0001koool300004oooo`040000oooooooo00003_ooo`80000?
oooo0`0000coool200001_ooo`030000oooooooo00Goool00`000?ooooooo`03000000?oool00000
00001_ooo`<00008oooo00<0003oooooool04P0000Coool00`000?ooooooo`0_oooo00@0003ooooo
ooooool600000_ooo`@0000=oooo00<0003oooooool07Oooo`<0000Boooo0P000003oooo00000000
00goool200003oooo`<0000=oooo00<0003oooooool01?ooo`800006oooo00<0003oooooool00`00
00;oool00`000?ooooooo`04oooo0`0000Soool2000000?oool000000000300000?oool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`P00004oooo1@0000coool200007_oo
o`<0000Coooo00@0003oooooool0000>oooo0P0000ooool300003?ooo`800006oooo00<0003ooooo
ool01Oooo`030000oooooooo00<000000oooo`0000000006oooo0`0000Soool00`000?ooooooo`0B
00001?ooo`030000oooooooo02ooool010000?ooooooooooo`H00002oooo100000goool00`000?oo
ooooo`0Moooo0`0001;oool2000000?oool0000000003Oooo`80000?oooo0`0000goool00`000?oo
ooooo`04oooo0P0000Koool00`000?ooooooo`0300000_ooo`030000oooooooo00Coool300002?oo
o`8000000oooo`000000000<00000oooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo2@0000;oool400002?ooo`800004oooo0`0001Woool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`@0000Coooo0P0000Koool200002Oooo`030000oooooooo00coool300000ooo
o`800009oooo00<0003oooooool00P0001[oool=00000_ooo`H00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo2`0000Ooool200001Oooo`<0000Hoooo0P0000Coool200001_ooo`<0000D
oooo00<0003oooooool01?ooo`800009oooo0P0000koool300000oooo`030000oooooooo00Ooool2
000000?oool0000000006_ooo`h00003oooo2@0000Coool00`000?ooooooo`0?oooo000Toooo00@0
003oooooooooool900000_ooo`@00008oooo0P0000Coool300006Oooo`030000oooooooo00?oool0
0`000?ooooooo`04oooo100001?oool200001_ooo`800009oooo00<0003oooooool03?ooo`<00003
oooo0P0000Woool00`000?ooooooo`0200006_ooo`d00002oooo1P0000Coool00`000?ooooooo`0_
oooo00@0003oooooooooool;00001oooo`800005oooo0`0001Soool200001?ooo`800006oooo0`00
01Coool00`000?ooooooo`04oooo0P0000Woool200003_ooo`<00003oooo00<0003oooooool01ooo
o`8000000oooo`000000000Joooo3P0000?oool900001?ooo`030000oooooooo00ooool002Coool0
10000?ooooooooooo`P000001?ooo`000000000000Woool200001Oooo`030000oooooooo023oool0
0`000?ooooooo`04oooo0P0000Koool200003Oooo`<0000Aoooo0P0000Coool200000oooo`800004
oooo0P000003oooo0000000000Ooool300000_ooo`8000001?ooo`000000000000coool200002?oo
o``00003oooo1P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool800002Oooo`030000
oooooooo00?oool200008Oooo`800006oooo00<0003oooooool01Oooo`030000oooooooo00coool3
00004Oooo`030000oooooooo00?oool010000?ooooooooooo`800005oooo00@0003oooooool00008
oooo0`000004oooo00000000oooo100000coool00`000?ooooooo`06oooo300000Koool800001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H00003oooo0P0000Ooool200000ooo
o`80000?oooo00@0003oooooool0000>oooo0P000004oooo0000000000002?ooo`8000001?ooo`00
00000?ooo`80000=oooo0`0000Ooool00`000?ooooooo`07oooo1P0001Ooool300000_ooo`800003
oooo00<0003oooooool02Oooo`<000000oooo`0000000003oooo2@0000;oool3000000?oool00000
00001P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool600002?ooo`040000oooooooo
oooo0P0000ooool2000000?oool0000000003_ooo`030000oooooooo00<00007oooo0P000003oooo
0000000000;oool00`000?ooooooo`0<oooo0`0000Koool200002Oooo`H0000Goooo0`000003oooo
0000000000?oool200002_ooo`<00002oooo00@0003oooooooooool:000000Coool0000000000002
oooo300000Coool00`000?ooooooo`0?oooo000Toooo0P0000;oool600000oooo`800007oooo0P00
00?oool200003oooo`040000oooooooo00003_ooo`8000001?ooo`000000000000Soool2000000Co
ool00000003oool200003Oooo`<00007oooo00<0003oooooool01oooo`H0000Goooo0`0000;oool2
00000oooo`030000oooooooo00Woool3000000?oool0000000000oooo`T00002oooo0`000003oooo
0000000000H00003oooo0P00037oool200000_ooo`H00008oooo00@0003oooooooooool200003ooo
o`8000000oooo`000000000>oooo00<0003oooooool00`0000Ooool2000000?oool0000000000_oo
o`030000oooooooo00coool300001_ooo`800009oooo1P0001Ooool3000000?oool0000000000ooo
o`80000:oooo0`0000;oool010000?ooooooooooo`X000001?ooo`000000000000;oool<00001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H00009oooo1@0000Goool010000?oo
ooooooooo`<00008oooo00<0003oooooool03?ooo`8000001?ooo`0000000?ooo`<0000:oooo00@0
003oooooool00008oooo00<0003oooooool01oooo`800005oooo00@0003oooooool00006oooo0P00
023oool300000_ooo`040000oooooooo00001Oooo`<000001?ooo`000000000000;oool2000000?o
ool0000000002P0000?oool800001?ooo`030000oooooooo02ooool010000?ooooooooooo`H00005
oooo100000Goool00`000?ooooooo`02oooo0`0000Ooool200003_ooo`040000oooooooo00000_oo
o`<00009oooo00<0003oooooool00P0000Ooool200002Oooo`030000oooooooo00?oool2000000?o
ool0000000001_ooo`030000oooooooo01koool300000_ooo`8000000oooo`0000000004oooo0`00
00;oool3000000Coool00000003oool=00000oooo`040000oooooooooooo200000Coool00`000?oo
ooooo`0?oooo000Toooo00@0003oooooooooool600002Oooo`<00005oooo0P000003oooo00000000
00<0000<oooo00<0003oooooool02Oooo`T00005oooo0`0000_oool00`000?ooooooo`0:oooo0P00
00Goool00`000?ooooooo`06oooo00<0003oooooool01?ooo`800003oooo0P0000Koool00`000?oo
ooooo`06oooo00<0003oooooool00oooo`H0000Coooo3@0000?oool800001?ooo`030000oooooooo
02ooool010000?ooooooooooo`H00005oooo0`0000Coool2000000?oool0000000000`0000coool2
00002oooo`T00004oooo0`0000_oool200003?ooo`030000oooooooo00?oool200001oooo`800006
oooo00@0003oooooooooool200001_ooo`800007oooo0P0000Coool700004_ooo`h00003oooo00@0
003oooooooooool800001?ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H00009
oooo0`0000Goool2000000?oool0000000000`0000coool00`000?ooooooo`09oooo2@0000Goool3
00002oooo`030000oooooooo00[oool200001Oooo`030000oooooooo00Koool00`000?ooooooo`04
oooo0P0000?oool200001_ooo`030000oooooooo00Koool00`000?ooooooo`03oooo1P0001?oool=
00000oooo`P00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0000Goool300001?oo
o`8000000oooo`000000000300003?ooo`80000;oooo2@0000Coool300002oooo`80000<oooo00<0
003oooooool00oooo`800007oooo0P0000Koool010000?ooooooooooo`800006oooo0P0000Ooool2
00001?ooo`L0000Boooo3P0000?oool010000?ooooooooooo`P00004oooo00<0003oooooool03ooo
o`009?ooo`040000oooooooooooo1P0000_oool00`000?ooooooo`03oooo0P0000ooool00`000?oo
ooooo`0<oooo0P000003oooo0000000000@00006oooo0P0000?oool300000_ooo`<0000Koooo0P00
01_oool200001_ooo`P000001?ooo`000000000000?oool600001?oooaP00004oooo00<0003ooooo
ool0;oooo`040000oooooooooooo1P0000Koool200001?ooo`80000?oooo0P0000koool00`000?oo
ooooo`0600001_ooo`040000oooooooooooo10000004oooo0000000000007?ooo`030000oooooooo
01[oool00`000?ooooooo`04oooo200000;oool300000oooo`H00003oooo7@0000Coool00`000?oo
ooooo`0?oooo000Ioooo0`0000;oool00`000?ooooooo`03oooo00@0003oooooooooool600002Ooo
o`D000000oooo`0000000002oooo00@0003oooooooooool200002Oooo`030000oooooooo00koool0
0`000?ooooooo`0400001Oooo`<00003oooo0P0000?oool300003oooo`80000=oooo0P0000Soool0
0`000?ooooooo`0=oooo0P0000Coool:000000?oool0000000001_ooo`<00005oooo2@000004oooo
0000000000000_ooo`T00004oooo00<0003oooooool09Oooo`<00002oooo00<0003oooooool00_oo
o`040000oooooooooooo1P0000Goool400000_ooo`040000oooooooo00001?ooo`030000oooooooo
00Ooool200003oooo`8000000oooo`000000000300001?ooo`<00003oooo0P0000?oool300003ooo
o`80000>oooo00<0003oooooool01_ooo`030000oooooooo00koool00`000?ooooooo`03oooo2@00
00;oool00`000?ooooooo`04oooo0`0000Goool900000_ooo`<000001?ooo`000000000000;oool9
00001?ooo`030000oooooooo00ooool001[oool01P000?ooooooo`000?ooo`0000Coool010000?oo
ooooooooo`H00009oooo1@000003oooo0000000000;oool010000?ooooooooooo`800009oooo00<0
003oooooool03_ooo`030000oooooooo00@00005oooo0`0000?oool200000oooo`<0000?oooo0P00
00goool200002?ooo`030000oooooooo00goool200001?ooo`X000000oooo`0000000006oooo0`00
00Goool9000000Coool0000000000002oooo2@0000Coool00`000?ooooooo`0Voooo00H0003ooooo
ool0003oool00003oooo00@0003oooooooooool600001Oooo`@00002oooo00@0003oooooool00004
oooo00<0003oooooool01oooo`80000?oooo0P000003oooo0000000000<00004oooo0`0000?oool2
00000oooo`<0000?oooo0P0000koool00`000?ooooooo`06oooo00<0003oooooool03_ooo`030000
oooooooo00?oool900000_ooo`030000oooooooo00Coool300001Oooo`T00002oooo0`000004oooo
0000000000000_ooo`T00004oooo00<0003oooooool03oooo`006?ooo`@000001?ooo`000?ooo`00
00Coool200000_ooo`H00002oooo00<0003oooooool00`0000?oool00`000?ooooooo`03oooo0P00
00Coool200003?ooo`030000oooooooo00koool600001_ooo`800004oooo0P0000[oool200002?oo
o`030000oooooooo00Woool00`000?ooooooo`0Hoooo0P0000Koool500002_ooo`D00003oooo3`00
00;oool900000oooo`80000Voooo10000004oooo0000oooo00000oooo`800002oooo2@0000?oool2
00001?ooo`800005oooo00<0003oooooool02_ooo`80000?oooo1P0000Koool200001Oooo`030000
oooooooo00Woool00`000?ooooooo`06oooo00<0003oooooool02Oooo`80000Joooo00<0003ooooo
ool01?ooo`D0000;oooo100000?oool@000000Coool0000000000002oooo2@0000?oool200004Ooo
o`006?ooo`030000oooo000000;oool00`000?ooo`000004oooo00@0003oooooooooool600000_oo
o`030000oooooooo00?oool700001?ooo`<000000oooo`000000000Noooo1@0000?oool00`000?oo
ooooo`0<oooo0P0000?oool300001_ooo`<00003oooo0`0000Goool00`000?ooooooo`06oooo0P00
00Ooool300001Oooo`030000oooooooo00Coool200000_ooo`040000oooooooooooo1@0000Coool3
00001OoooaX00004oooo00<0003oooooool09?ooo`030000oooo000000;oool00`000?ooo`000003
oooo00@0003oooooooooool600000oooo`P00003oooo0`0000;oool00`000?ooooooo`0Moooo1000
00?oool200003_ooo`040000oooooooooooo0`0000Koool300001?ooo`<00004oooo0P0000Ooool2
00002?ooo`<00004oooo0P0000Koool010000?ooooooo`0000Coool400001Oooo`<00004oooo7`00
00Coool00`000?ooooooo`0?oooo000Ioooo0P0000;oool00`000?ooo`000004oooo00@0003ooooo
ooooool600000_ooo`030000oooooooo00?oool700001?ooo`<000000oooo`000000000Noooo1@00
00?oool00`000?ooooooo`0<oooo0P0000?oool300001_ooo`<00003oooo0`0000Goool00`000?oo
ooooo`06oooo0P0000Ooool300001Oooo`030000oooooooo00Coool200000_ooo`040000oooooooo
oooo1@0000Coool300001OoooaX00004oooo00<0003oooooool09Oooo`800002oooo00<0003oool0
00000oooo`040000oooooooooooo1P0000?oool800000oooo`<00002oooo00<0003oooooool07Ooo
o`@00003oooo0P0000koool010000?ooooooooooo`<00006oooo0`0000Coool300001?ooo`800007
oooo0P0000Soool300001?ooo`800006oooo00@0003oooooool00004oooo100000Goool300001?oo
oal00004oooo00<0003oooooool03oooo`006_ooo`050000oooooooooooo000000Goool010000?oo
ooooooooo`H00003oooo0P0000Coool300001oooo`030000oooooooo00<0000<oooo00<0003ooooo
ool03?ooo`<00003oooo0P0000?oool00`000?ooooooo`03oooo0P000004oooo0000000000002?oo
o`030000oooooooo00Soool3000000Coool0000000000005oooo00<0003oooooool03oooo`<00005
oooo00@0003oooooooooool2000000?oool0000000000_ooo`030000oooooooo00?oool400000ooo
o`D000000oooo`000000000B00000_ooo`H00004oooo00<0003oooooool09_ooo`050000oooooooo
oooo000000Coool010000?ooooooooooo`H00005oooo0`0000Koool00`000?ooooooo`0300003?oo
o`80000>oooo0`0000?oool010000?ooooooooooo`800004oooo0P0000;oool300001oooo`800009
oooo0`0000;oool300001?ooo`80000Aoooo0`0000Coool200000oooo`040000oooooooo00000_oo
o`030000oooooooo00?oool500000oooo`@00002oooo500000?oool00`000?ooooooo`0600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H00002oooo0`0000?oool010000?oo
ooooooooo`800003oooo1P0001ooool3000000Coool00000003oool200001Oooo`<0000=oooo0`00
00Goool300000_ooo`040000oooooooo00002Oooo`80000>oooo00@0003oooooooooool2000000?o
ool0000000000oooo`030000oooooooo00;oool00`000?ooooooo`03oooo100000?oool500000ooo
o`T00002oooo1`0000;oool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H00003
oooo0P0000?oool010000?ooooooooooo`L0000Noooo0`0000;oool010000?ooooooo`0000Goool3
00003_ooo`<00004oooo0`0000;oool2000000?oool0000000002Oooo`030000oooooooo00coool2
00000oooo`040000oooooooo00000oooo`800003oooo00<0003oooooool00oooo`D00003oooo1000
00?oool:000000?oool0000000001P0000Coool800001?ooo`030000oooooooo00ooool002Coool0
10000?ooooooooooo`H00002oooo0`0000?oool010000?ooooooooooo`800003oooo1P0001ooool3
000000Coool00000003oool200001Oooo`<0000=oooo0`0000Goool300000_ooo`040000oooooooo
00002Oooo`80000>oooo00@0003oooooooooool2000000?oool0000000000oooo`030000oooooooo
00;oool00`000?ooooooo`03oooo100000?oool500000oooo`T00002oooo1`0000;oool600001?oo
o`030000oooooooo02ooool010000?ooooooooooo`H00003oooo0P0000?oool010000?oooooooooo
o`L0000Noooo0`0000;oool010000?ooooooo`0000Goool300003_ooo`<00004oooo0`0000;oool2
000000?oool0000000002Oooo`030000oooooooo00coool200000oooo`040000oooooooo00000ooo
o`800003oooo00<0003oooooool00oooo`D00003oooo100000?oool:000000?oool0000000001P00
00Coool800001?ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H00002oooo0`00
00?oool600000oooo`8000001?ooo`0000000000023oool2000000?oool0000000001?ooo`800002
oooo0`0001Soool500007_ooo`800007oooo0P0000;oool3000000Coool00000003oool300000_oo
o`040000oooooooo00000_ooo`/00006oooo100000;oool600001?ooo`030000oooooooo02ooool0
10000?ooooooooooo`H00003oooo1P0000?oool2000000?oool0000000000P00023oool010000?oo
ooooo`0000Goool00`000?ooooooo`0300006?ooo`D0000Ooooo00<0003oooooool01_ooo`030000
oooooooo00<00002oooo00<0003oooooool00`000004oooo00000000oooo0P000003oooo00000000
00T00006oooo1@000003oooo0000000000T00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo1P0000;oool300000oooo`<000000oooo`0000000003oooo1P0000koool00`000?oo
ooooo`0?oooo0P0000Coool200000oooo`<0000Boooo0P0000coool200003?ooo`800006oooo0`00
00?oool00`000?ooooooo`06oooo00<0003oooooool01@000004oooo00000000oooo0P0000CooolA
00002Oooo`P00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0000?oool300000_oo
o`040000oooooooooooo1`0000goool200004Oooo`030000oooooooo00?oool010000?oooooooooo
o`<0000Coooo00<0003oooooool02oooo`030000oooooooo00[oool200001_ooo`<00003oooo0P00
00Ooool2000000?oool0000000000`0000;oool010000?ooooooo`0000GooolA00002Oooo`@00002
oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo0P0000;oool600000_ooo`<00003oooo0`00
0003oooo0000000000?oool600003_ooo`030000oooooooo00ooool200001?ooo`800003oooo0`00
01;oool200003?ooo`80000<oooo0P0000Koool300000oooo`030000oooooooo00Koool00`000?oo
ooooo`05000000Coool00000003oool200001?oooa400009oooo200000?oool20000<Oooo`800002
oooo1P0000?oool300000_ooo`040000oooooooooooo1`0000goool200004Oooo`030000oooooooo
00?oool010000?ooooooooooo`<0000Coooo00<0003oooooool02oooo`030000oooooooo00[oool2
00001_ooo`<00003oooo0P0000Ooool2000000?oool0000000000`0000;oool010000?ooooooo`00
00GooolA00002Oooo`@00002oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003ooooo
ooooool600000oooo`800003oooo0`000004oooo00000000oooo200000koool00`000?ooooooo`0?
oooo0P000003oooo0000000000?oool300000_ooo`030000oooooooo00[oool200001?ooo`<00004
oooo00<0003oooooool00oooo`<000000oooo`0000000006oooo00<0003oooooool00P0000Ooool2
00000oooo`030000oooooooo00Coool300001Oooo`800003oooo0`000003oooo0000000000<00000
1?ooo`0000000?ooo`D00003oooo0P0000Coool600000_ooo`H00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo1P0000?oool300000_ooo`030000oooooooo00P0000=oooo0P00017oool0
10000?ooooooo`0000?oool300000_ooo`030000oooooooo00_oool00`000?ooooooo`03oooo0`00
00?oool00`000?ooooooo`03oooo0`0000;oool00`000?ooooooo`04oooo0P000003oooo00000000
00Soool010000?ooooooooooo`800006oooo0`0000Coool200000oooo`<00002oooo100000;oool0
0`000?ooooooo`0400001?ooo`030000oooooooo00?oool6000000?oool0000000002@0000Coool0
0`000?ooooooo`0?oooo000Toooo00@0003oooooooooool600000oooo`8000000oooo`0000000003
000000?oool0000000000`0000?oool300008?ooo`800004oooo1@0000Goool010000?ooooooo`00
00?oool200005Oooo`80000<oooo0P0000Ooool300000_ooo`030000oooooooo00Koool00`000?oo
ooooo`02oooo0`000003oooo0000000000l00003oooo0`0000coool800001?ooo`030000oooooooo
02ooool010000?ooooooooooo`H00002oooo100000;oool400000oooo`@0000Poooo00<0003ooooo
ool00oooo`@00005oooo0P000003oooo0000000000?oool00`000?ooooooo`0Doooo00<0003ooooo
ool02_ooo`800008oooo0`000003oooo0000000000Ooool200000oooo`<00002oooo400000?oool4
00003?ooo`030000oooooooo00?oool600001?ooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`H00003oooo0P000003oooo0000000000<000000oooo`000000000300000oooo`<0000P
oooo0P0000Coool500001Oooo`040000oooooooo00000oooo`80000Eoooo0P0000coool200001ooo
o`<00002oooo00<0003oooooool01_ooo`030000oooooooo00;oool3000000?oool0000000003`00
00?oool300003?ooo`P00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0000;oool4
00000_ooo`@00003oooo1000023oool00`000?ooooooo`03oooo100000Goool2000000?oool00000
00000oooo`030000oooooooo01Coool00`000?ooooooo`0:oooo0P0000Soool3000000?oool00000
00001oooo`800003oooo0`0000;oool@00000oooo`@0000<oooo00<0003oooooool00oooo`H00004
oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo20000003oooo0000000000?oool0
10000?ooooooooooo`<00005oooo0`0001[oool300000oooo`<00005oooo00<0003oooooool01@00
0003oooo0000000000goool500002Oooo`800003oooo00<0003oooooool03oooo`<00002oooo0`00
00?oool300001Oooo`<00004oooo1@000003oooo0000000000<000000oooo`0000000002000000?o
ool000000000100000Soool00`000?ooooooo`0600001?ooo`030000oooooooo02ooool010000?oo
ooooooooo`H00003oooo0P0000?oool300001?ooo`@0000Joooo0`0000?oool300001?ooo`800000
0oooo`000000000300000_ooo`030000oooooooo00coool400002_ooo`040000oooooooooooo0P00
017oool3000000Coool0000000000003oooo0`0000Goool300001Oooo`@00002oooo100000;oool3
000000?oool0000000001@0000Ooool2000000?oool0000000000oooo`H00004oooo00<0003ooooo
ool03oooo`009?ooo`040000oooooooooooo20000003oooo0000000000?oool010000?oooooooooo
o`<00005oooo0`0001[oool300000oooo`<00005oooo00<0003oooooool01@000003oooo00000000
00goool500002Oooo`800003oooo00<0003oooooool03oooo`<00002oooo0`0000?oool300001Ooo
o`<00004oooo1@000003oooo0000000000<000000oooo`0000000002000000?oool0000000001000
00Soool00`000?ooooooo`0600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H00003
oooo0P0000?oool300001?ooo`@0000Joooo0`0000?oool300001?ooo`8000000oooo`0000000003
00000_ooo`030000oooooooo00coool400002_ooo`040000oooooooooooo0P00017oool3000000Co
ool0000000000003oooo0`0000Goool300001Oooo`@00002oooo100000;oool3000000?oool00000
00001@0000Ooool2000000?oool0000000000oooo`H00004oooo00<0003oooooool03oooo`009?oo
o`040000oooooooooooo200000Ooool2000000?oool0000000000`0000?oool300007?ooo`030000
oooooooo00<000001?ooo`0000000?ooo`800005oooo00<0003oooooool00oooo`030000oooooooo
01[oool00`000?ooooooo`07oooo0P0000Soool010000?ooooooo`0000;oool00`000?ooooooo`03
oooo00<0003oooooool00oooo`D00004oooo1P0000;oool400002?ooo`800003oooo1P0000?oool6
00001?ooo`030000oooooooo02ooool010000?ooooooooooo`H00005oooo00<0003oooooool01000
00?oool400006oooo`8000001?ooo`000000000000;oool010000?ooooooo`0000Goool00`000?oo
ooooo`03oooo0P0001_oool200002Oooo`030000oooooooo00Koool2000000Coool00000003oool2
00001?ooo`800004oooo1@0000Goool6000000?oool0000000000`0000Soool010000?oooooooooo
o`H00008oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool600001Ooo
o`040000oooooooooooo0P000003oooo0000000000<00003oooo1@0000Coool200005?ooo`030000
oooooooo00<00004oooo0P0000Soool00`000?ooooooo`0@oooo0P0000;oool00`000?ooooooo`06
oooo0`000004oooo00000000oooo0P0000?oool200001_ooo`030000oooooooo00Ooool300003_oo
o`8000000oooo`0000000003oooo0`000003oooo0000000000;oool300001oooo`<00002oooo00<0
003oooooool01P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool800000oooo`030000
oooooooo00@00003oooo1@0000Goool00`000?ooooooo`0Boooo0P000004oooo0000000000001Ooo
o`030000oooooooo00Koool200004_ooo`040000oooooooo00002?ooo`<00002oooo00@0003ooooo
ool00003oooo0P0000Koool200002Oooo`<0000>oooo00@0003oooooool00003oooo0`0000;oool0
0`000?ooooooo`0300002?ooo`<000000oooo`0000000006oooo1P0000Coool00`000?ooooooo`0?
oooo000Toooo0P0000;oool600001Oooo`040000oooooooooooo0P000003oooo0000000000<00003
oooo1@0000Coool200005?ooo`030000oooooooo00<00004oooo0P0000Soool00`000?ooooooo`0@
oooo0P0000;oool00`000?ooooooo`06oooo0`000004oooo00000000oooo0P0000?oool200001_oo
o`030000oooooooo00Ooool300003_ooo`8000000oooo`0000000003oooo0`000003oooo00000000
00;oool300001oooo`<00002oooo00<0003oooooool01P0000?oool20000<Oooo`800002oooo2000
00?oool00`000?ooooooo`0400000oooo`D00005oooo00<0003oooooool04_ooo`8000001?ooo`00
0000000000Goool00`000?ooooooo`06oooo0P0001;oool010000?ooooooo`0000Soool300000_oo
o`040000oooooooo00000oooo`800006oooo0P0000Woool300003_ooo`040000oooooooo00000ooo
o`<00002oooo00<0003oooooool00`0000Soool3000000?oool0000000001_ooo`H00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo200000?oool6000000?oool0000000001@00
0003oooo0000000000<00006oooo00<0003oooooool04Oooo`H00003oooo0`0000?oool2000000?o
ool0000000001?ooo`<00006oooo0P00017oool300006oooo`800008oooo0`000004oooo00000000
00000oooo`<00002oooo0`000003oooo0000000000<00003oooo0P0000?oool010000?ooooooo`00
00Goool600001?ooo`030000oooooooo02ooool010000?ooooooooooo``00002oooo1P000003oooo
0000000000<00006oooo0P0001;oool600000oooo`<00003oooo0P000003oooo0000000000Goool3
00001_ooo`030000oooooooo00ooool300007?ooo`030000oooooooo00Koool300000_ooo`<00003
oooo0`000004oooo0000000000000_ooo`@00004oooo00@0003oooooooooool2000000?oool00000
00002Oooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo200000?oool3
000000?oool0000000000oooo`D000000oooo`000000000300007Oooo`<000000oooo`000000000<
00001Oooo`040000oooooooo00002?ooo`030000oooooooo00_oool300004Oooo`@00005oooo0`00
00Coool4000000Coool00000003oool600000oooo`8000001?ooo`000000000000Ooool010000?oo
ooooo`0000?oool200001_ooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo2@00
00;oool010000?ooooooooooo`D000000oooo`000000000300007Oooo`<00002oooo3P0000Coool2
000000?oool0000000001oooo`80000<oooo0`00017oool500001?ooo`<00005oooo0`000003oooo
0000000000;oool600000oooo`030000oooooooo00<00006oooo0P000003oooo0000000000?oool0
0`000?ooooooo`09oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool8
00000oooo`<000000oooo`0000000003oooo1@000003oooo0000000000<0000Moooo0`000003oooo
0000000000`00005oooo00@0003oooooool00008oooo00<0003oooooool02oooo`<0000Aoooo1000
00Goool300001?ooo`@000001?ooo`0000000?ooo`H00003oooo0P000004oooo0000000000001ooo
o`040000oooooooo00000oooo`800006oooo1P0000Coool00`000?ooooooo`0_oooo00@0003ooooo
ooooool900000_ooo`040000oooooooooooo1@000003oooo0000000000<0000Moooo0`0000;oool>
00001?ooo`8000000oooo`0000000007oooo0P0000coool300004Oooo`D00004oooo0`0000Goool3
000000?oool0000000000_ooo`H00003oooo00<0003oooooool00`0000Koool2000000?oool00000
00000oooo`030000oooooooo00Woool600001?ooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`P00003oooo3P0000?oool3000000?oool0000000002_ooo`80000>oooo0`0000Woool2
00002_ooo`800009oooo0`0000;oool300000oooo`040000oooooooooooo0P0000Woool200001_oo
o`040000oooooooo00000oooo`<0000:oooo0`000003oooo0000000000Coool200001?ooo`P00005
oooo00<0003oooooool02Oooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo5000
00?oool300000_ooo`030000oooooooo00Woool00`000?ooooooo`0<oooo0`0000Woool200002ooo
o`030000oooooooo00Ooool300000_ooo`<00003oooo0P0000?oool00`000?ooooooo`07oooo0P00
00Koool2000000?oool0000000000oooo`<00009oooo0`0000;oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`L00005oooo0P0000coool00`000?ooooooo`0600001?ooo`030000oooooooo
00ooool002Coool010000?ooooooooooo`P00003oooo1P000004oooo00000000oooo100000?oool3
00000oooo`030000oooooooo00?oool010000?ooooooooooo`80000>oooo0`0000Ooool400002_oo
o`80000:oooo10000003oooo0000000000<000000oooo`0000000007oooo0P0000?oool200002Ooo
o`040000oooooooooooo0P0000_oool400002?ooo`<0000<oooo0P0000coool600001?ooo`030000
oooooooo02ooool010000?ooooooooooo``00002oooo00<0003oooooool00`0000?oool300000ooo
o`800004oooo0P0000?oool00`000?ooooooo`0<oooo0`0000Soool300002oooo`030000oooooooo
00Woool3000000?oool0000000000`0000;oool00`000?ooooooo`06oooo00@0003oooooooooool2
00002Oooo`800003oooo00<0003oooooool02Oooo`D00007oooo0`0000goool00`000?ooooooo`0?
oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool800000oooo`H00000
1?ooo`0000000?ooo`@00003oooo0`0000?oool00`000?ooooooo`03oooo00@0003oooooooooool2
00003_ooo`<00007oooo100000[oool200002_ooo`@000000oooo`0000000003000000?oool00000
00001oooo`800003oooo0P0000Woool010000?ooooooooooo`80000;oooo100000Soool300003?oo
o`80000<oooo1P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool<00000_ooo`030000
oooooooo00<00003oooo0`0000?oool200001?ooo`800003oooo00<0003oooooool03?ooo`<00008
oooo0`0000_oool00`000?ooooooo`09oooo0`000003oooo0000000000<00002oooo00<0003ooooo
ool01_ooo`040000oooooooooooo0P0000Woool200000oooo`030000oooooooo00Woool500001ooo
o`<0000=oooo00<0003oooooool03oooo`H00004oooo00<0003oooooool03oooo`009?ooo`800002
oooo200000Coool900000_ooo`<00002oooo100000Goool010000?ooooooo`00017oool200002Ooo
o`030000oooooooo017oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`<000000oooo`00
00000003oooo00<0003oooooool00oooo`040000oooooooooooo0P0000Woool300000_ooo`<0000M
oooo00<0003oooooool02?ooo`030000oooooooo00Woool600000oooo`80000aoooo0P0000;oool6
00000_ooo`T000001?ooo`000000000000;oool500001?ooo`8000000oooo`000000000Aoooo00<0
003oooooool01oooo`80000Boooo0P0000Coool200000oooo`<00002oooo00@0003oooooooooool2
00001?ooo`800003oooo00<0003oooooool02?ooo`<000001?ooo`000000000001goool200002Ooo
o`80000=oooo200000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool800000ooo
o`X00007oooo100000Goool400001Oooo`030000oooooooo00;oool010000?ooooooooooo`800003
oooo00@0003oooooooooool200003oooo`D000001?ooo`0000000?ooo`<00003oooo1@0000Koool3
00001Oooo`040000oooooooooooo0P0000coool2000000?oool0000000000`0002Goool00`000?oo
ooooo`09oooo1P0000Coool00`000?ooooooo`0_oooo00@0003ooooooooooolA00001_ooo`D00004
oooo1@0000Coool200000oooo`030000oooooooo00;oool010000?ooooooooooo`800003oooo00<0
003oooooool03_ooo`@00002oooo00<0003oooooool00`0000?oool400001oooo`<00004oooo0P00
00?oool00`000?ooooooo`0;oooo00<0003oooooool0100002Goool200003Oooo`P00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo200000?oool:00001oooo`@00005oooo1000
00Goool00`000?ooooooo`02oooo00@0003oooooooooool200000oooo`040000oooooooooooo0P00
00ooool5000000Coool00000003oool300000oooo`D00006oooo0`0000Goool010000?oooooooooo
o`80000<oooo0P000003oooo0000000000<0000Uoooo00<0003oooooool02Oooo`H00004oooo00<0
003oooooool0;oooo`040000oooooooooooo4@0000Koool500001?ooo`D00004oooo0P0000?oool0
0`000?ooooooo`02oooo00@0003oooooooooool200000oooo`030000oooooooo00koool400000_oo
o`030000oooooooo00<00003oooo100000Ooool300001?ooo`800003oooo00<0003oooooool02ooo
o`030000oooooooo00@0000Uoooo0P0000goool800001?ooo`030000oooooooo00ooool002Coool0
10000?ooooooooooo`P00003oooo2@0000Woool300002oooo`030000oooooooo00?oool200002Ooo
o`040000oooooooooooo0P0000koool400000_ooo`<00003oooo00<0003oooooool01_ooo`P00000
1?ooo`000000000000;oool010000?ooooooooooo`80000;oooo00<0003oooooool09Oooo`030000
oooooooo00?oool010000?ooooooo`0000Soool600001?ooo`030000oooooooo02ooool010000?oo
ooooooooo`l0000:oooo0`0000[oool200001?ooo`800009oooo0P0000?oool00`000?ooooooo`0<
oooo1@000004oooo0000000000000oooo`800007oooo200000;oool3000000?oool0000000000ooo
o`030000oooooooo00Woool200009_ooo`030000oooooooo00?oool2000000?oool0000000002Ooo
o`030000oooooooo00H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo2000
00?oool900004_ooo`800009oooo0`0000Soool010000?ooooooooooo`80000<oooo0`0000Goool4
00001Oooo`D000000oooo`0000000003oooo1`0000;oool010000?ooooooooooo`800008oooo1000
02Ooool00`000?ooooooo`09oooo00<0003oooooool00oooo`H00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo3`0001?oool00`000?ooooooo`07oooo0`0000Soool200000oooo`030000
oooooooo00_oool300001?ooo`D00004oooo1@000003oooo0000000000?oool8000000?oool00000
00000oooo`030000oooooooo00Koool500009_ooo`030000oooooooo00Woool200002Oooo`H00004
oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo200000?oool900004_ooo`800009
oooo0`0000Soool010000?ooooooooooo`80000<oooo0`0000Goool400001Oooo`D000000oooo`00
00000003oooo1`0000;oool010000?ooooooooooo`800008oooo100002Ooool00`000?ooooooo`09
oooo00<0003oooooool00oooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo3`00
01?oool00`000?ooooooo`07oooo0`0000Soool200000oooo`030000oooooooo00_oool300001?oo
o`D00004oooo1@000003oooo0000000000?oool8000000?oool0000000000oooo`030000oooooooo
00Koool500009_ooo`030000oooooooo00Woool200002Oooo`H00004oooo00<0003oooooool03ooo
o`006?ooo`800004oooo00<0003oooooool00oooo`040000oooooooooooo1P0002?oool300000ooo
o`800003oooo0P000003oooo0000000000?oool00`000?ooooooo`04oooo0`0000Goool600000_oo
o`d00005oooo0P000003oooo0000000000L00005oooo00<0003oooooool00oooo`<0000aoooo0P00
0003oooo0000000000Coool200000oooo`H00004oooo00<0003oooooool09?ooo`800004oooo00<0
003oooooool00_ooo`040000oooooooooooo1P0001ooool300000oooo`040000oooooooooooo0P00
00;oool010000?ooooooooooo`800006oooo0`0000Coool7000000?oool000000000300000Coool2
00000_ooo`T00004oooo0P0000Coool40000<Oooo`040000oooooooo00001Oooo`030000oooooooo
00Coool800001?ooo`030000oooooooo00ooool001Soool00`000?ooo`000002oooo00<0003oool0
00001?ooo`040000oooooooooooo1P0002Woool200000_ooo`<000000oooo`0000000007oooo0P00
0003oooo0000000000?oool800000ooooa4000000oooo`000000000400000_ooo`@00005oooo1@00
03SooolA00001?ooo`030000oooooooo02Coool00`000?ooo`000002oooo00<0003oool000000ooo
o`040000oooooooooooo1P0002Goool00`000?ooooooo`0300000_ooo`030000oooooooo00Koool0
10000?ooooooo`0000?oool800000ooooa4000000oooo`0000000005000000?oool0000000000`00
00Coool50000>Oooo`X00005oooo1P0000Coool00`000?ooooooo`0?oooo000Hoooo00<0003oool0
00000_ooo`030000oooo000000Coool200000_ooo`H0000Yoooo0P0000;oool3000000?oool00000
00001oooo`8000000oooo`0000000003oooo200000?ooolA000000?oool000000000100000;oool4
00001Oooo`D0000hoooo4@0000?oool200009_ooo`030000oooo000000;oool00`000?ooo`000003
oooo0P0000;oool600009Oooo`030000oooooooo00<00002oooo00<0003oooooool01_ooo`040000
oooooooo00000oooo`P00003oooo4@000003oooo0000000000D000000oooo`000000000300001?oo
o`D0000ioooo2P0000Goool600000oooo`80000Aoooo000Hoooo0P0000?oool00`000?ooo`000004
oooo00@0003oooooooooool60000<?ooo`040000oooooooo00001_ooo`800006oooo0P000004oooo
0000000000000_oooa@000000oooo`000000000400000_ooo`@00003oooo0`0004Coool900001?oo
o`030000oooooooo02Coool200000oooo`030000oooo000000?oool010000?ooooooooooo`H0000[
oooo0P000003oooo0000000000Koool00`000?ooooooo`04oooo0P000003oooo0000000000800000
0oooo`000000000B000000?oool0000000001@000003oooo0000000000<00003oooo0`0004?oool>
00001?ooo`030000oooooooo00ooool001Soool00`000?ooooooo`02oooo00<0003oool000001?oo
o`040000oooooooooooo1P00037oool2000000Coool0000000000005oooo00<0003oooooool00ooo
o`8000001?ooo`0000000?oooaT000001?ooo`000000000000;oool400000oooo`<0000eoooo1000
00Soool010000?ooooooooooo`P00004oooo00<0003oooooool09?ooo`030000oooooooo00;oool0
0`000?ooo`000003oooo00@0003oooooooooool60000;Oooo`030000oooooooo00<00004oooo0P00
00Coool2000000?oool0000000000_oooaP00002oooo0`000003oooo0000000000<00003oooo0`00
03Coool500001oooo`800003oooo00@0003oooooool00002oooo1P0000Coool00`000?ooooooo`0?
oooo000Ioooo0P0000?oool00`000?ooooooo`03oooo00@0003oooooooooool60000<Oooo`800000
1?ooo`000000000000Goool00`000?ooooooo`03oooo0P000004oooo00000000oooo6@000004oooo
0000000000000_ooo`@00003oooo0`0003Goool400002?ooo`040000oooooooooooo200000Coool0
0`000?ooooooo`0Uoooo0P0000?oool00`000?ooooooo`02oooo00@0003oooooooooool60000;Ooo
o`030000oooooooo00<00004oooo0P0000Coool2000000?oool0000000000_oooaP00002oooo0`00
0003oooo0000000000<00003oooo0`0003Coool500001oooo`800003oooo00@0003oooooool00002
oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000<oooo`030000
oooooooo00Ooool800000_oooaX000001?ooo`0000000?ooo`H00003oooo0P0003ooool010000?oo
ooooo`0000Goool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H0000^oooo0P00
00Woool700000_oooaX00002oooo00<0003oooooool01P0000?oool00`000?ooooooo`0moooo0P00
0003oooo0000000000Woool600001?ooo`030000oooooooo00ooool002Coool010000?oooooooooo
o`H0000foooo00@0003oooooooooool2000000?oool000000000;00000;oool00`000?ooooooo`10
oooo0P0000Koool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H0000aoooo0P00
00?oool00`000?ooooooo`0^000000?oool000000000@_ooo`030000oooooooo00Woool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H0000foooo00@0003oooooooooool2
000000?oool000000000;00000;oool00`000?ooooooo`10oooo0P0000Koool600001?ooo`030000
oooooooo02ooool010000?ooooooooooo`H0000aoooo0P0000?oool00`000?ooooooo`0^000000?o
ool000000000@_ooo`030000oooooooo00Woool600001?ooo`030000oooooooo00ooool002Coool0
10000?ooooooooooo`H0000joooo0`0000?oool^0000B_ooo`H00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo1P0003Koool300000oooobh0001>oooo1P0000Coool00`000?ooooooo`0?
oooo000Toooo0P0000;oool60000>_ooo`<00003oooo;P0004[oool600000oooo`80000aoooo0P00
00;oool60000=_ooo`<00003oooo;P0004koool600001?ooo`030000oooooooo00ooool002Coool0
10000?ooooooooooo`H0000moooo0P000003oooo0000000002/0001;oooo1P0000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool60000>Oooo`030000oooooooo02`0001@oooo1P0000Coool0
0`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000??ooo`040000oooooooo00000_oo
obP0001>oooo1P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool60000=oooo`800000
1?ooo`0000000?ooobP0001Coooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003ooooo
ooooool60000??ooo`040000oooooooo00000_ooobP0001>oooo1P0000Coool00`000?ooooooo`0_
oooo00@0003oooooooooool60000=oooo`8000001?ooo`0000000?ooobP0001Coooo1P0000Coool0
0`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000??ooo`030000oooooooo02T0001@
oooo1P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool60000=oooo`8000000oooo`00
0000000X0000E?ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P00
03[oool300000oooobP0001@oooo1P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool6
0000=_ooo`<00003oooo:00005Coool600001?ooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`H0000joooo0`0000?ooolX0000D?ooo`H00004oooo00<0003oooooool0;oooo`040000
oooooooooooo1P0003Koool300000oooobP0001Doooo1P0000Coool00`000?ooooooo`0?oooo000T
oooo0P0000;oool60000?oooobP0001Aoooo1P0000?oool20000<Oooo`800002oooo1P0003[ooolX
0000E_ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P0003gooolW
0000E?ooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0003WooolV0000FOoo
o`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P0003gooolW0000E?oo
o`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0003WooolV0000FOooo`H00004
oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P00043ooolR0000E_ooo`H00004
oooo00<0003oooooool0;oooo`040000oooooooooooo1P0003cooolR0000F_ooo`H00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo1P00043ooolT0000E?ooo`H00004oooo00<0
003oooooool0;oooo`040000oooooooooooo1P0003cooolS0000FOooo`H00004oooo00<0003ooooo
ool03oooo`009?ooo`040000oooooooooooo1P00043ooolT0000E?ooo`H00004oooo00<0003ooooo
ool0;oooo`040000oooooooooooo1P0003cooolS0000FOooo`H00004oooo00<0003oooooool03ooo
o`009?ooo`040000oooooooooooo1P0003goool;00001OoooaP0001Coooo1P0000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool60000>Oooo`/00004oooo6@0005Ooool600001?ooo`030000
oooooooo00ooool002Coool010000?ooooooooooo`H0000moooo2`0000KooolI0000DOooo`H00004
oooo00<0003oooooool0;oooo`040000oooooooooooo1P0003Woool;00001_oooaP0001Foooo1P00
00Coool00`000?ooooooo`0?oooo000Toooo0P0000;oool60000?Oooo`/00006oooo6@00057oool6
00000oooo`80000aoooo0P0000;oool60000>Oooo`/00006oooo600005Koool600001?ooo`030000
oooooooo00ooool002Coool010000?ooooooooooo`H0000loooo4@0000?oool00`000?ooooooo`0D
0000DOooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0003OooolA00000ooo
o`8000000oooo`000000000B0000E_ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo1P0003cooolD00001?ooo`X000000oooo`00000000070000D?ooo`H00004oooo00<0
003oooooool0;oooo`040000oooooooooooo1P0003OooolD00001Oooo`T000000oooo`0000000008
0000E?ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P0003cooolD
00001?ooo`X000000oooo`00000000070000D?ooo`H00004oooo00<0003oooooool0;oooo`040000
oooooooooooo1P0003OooolD00001Oooo`T000000oooo`00000000080000E?ooo`H00004oooo00<0
003oooooool03oooo`009?ooo`040000oooooooooooo1P0003Ooool=000000Coool0000000000003
oooo7@00053oool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H0000coooo3000
0003oooo0000000000800003oooo7@0005Coool600001?ooo`030000oooooooo00ooool002Coool0
10000?ooooooooooo`H0000ioooo2@0000;oool400000_oooa800002oooo3@0004goool600001?oo
o`030000oooooooo02ooool010000?ooooooooooo`H0000doooo2@0000;oool5000000?oool00000
0000400000;oool>0000DOooo`H00004oooo00<0003oooooool03oooo`006Oooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00@0003oooooooooool60000>Oooo`T00002oooo100000;ooolB
00000_ooo`d0001=oooo1P0000Coool00`000?ooooooo`0Uoooo00<0003oooooool00_ooo`030000
oooooooo00;oool010000?ooooooooooo`H0000doooo2@0000;oool5000000?oool0000000004000
00;oool>0000DOooo`H00004oooo00<0003oooooool03oooo`006?ooo`030000oooo000000;oool0
0`000?ooo`000004oooo00@0003oooooooooool60000>Oooo`/00003oooo2P0000GooolE0000COoo
o`H00004oooo00<0003oooooool09?ooo`030000oooo000000;oool00`000?ooo`000003oooo00@0
003oooooooooool60000=?ooo`/00003oooo2`0000CooolF0000DOooo`H00004oooo00<0003ooooo
ool03oooo`006?ooo`030000oooo000000;oool00`000?ooo`000004oooo0P0000;oool60000>Ooo
o`/00003oooo2P0000GooolE0000COooo`H00003oooo0P0002Koool00`000?ooo`000002oooo00<0
003oool000000oooo`800002oooo1P0003Coool;00000oooo`/00004oooo5P00057oool600000ooo
o`80000Aoooo000Ioooo00L0003oooooooooool0003oool000001?ooo`040000oooooooooooo1P00
03Ooool900000_ooo`<00002oooo00<0003oooooool0100000?ooolJ0000COooo`H00004oooo00<0
003oooooool09Oooo`070000oooooooooooo0000oooo000000?oool010000?ooooooooooo`H0000c
oooo2@000004oooo0000000000000_ooo`8000000oooo`000000000300000ooooaX0001Aoooo1P00
00Coool00`000?ooooooo`0?oooo000Hoooo00<0003oool000000_ooo`030000oooo000000Coool0
10000?ooooooooooo`H0000foooo2P0000;oool300000oooo`800003oooo4@000003oooo00000000
00X0001=oooo1P0000Coool00`000?ooooooo`0Toooo00<0003oool000000_ooo`030000oooo0000
00?oool010000?ooooooooooo`H0000aoooo2`000004oooo0000000000001?ooo`040000oooooooo
oooo4@000003oooo0000000000/0001Aoooo1P0000Coool00`000?ooooooo`0?oooo000Ioooo00<0
003oooooool00_ooo`030000oooooooo00?oool010000?ooooooooooo`H0000foooo2P0000;oool3
00000oooo`800003oooo4@000003oooo0000000000X0001=oooo1P0000Coool00`000?ooooooo`0U
oooo00<0003oooooool00_ooo`030000oooooooo00;oool010000?ooooooooooo`H0000aoooo2`00
0004oooo0000000000001?ooo`040000oooooooooooo4@000003oooo0000000000/0001Aoooo1P00
00Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000=_ooo`h000000oooo`00
0000000=oooo0P0000?ooolD0000Boooo`H00004oooo00<0003oooooool0;oooo`040000oooooooo
oooo1P00037oool>000000?oool0000000003_ooo`040000oooooooooooo5000053oool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H0000foooo00<0003oooooool02@00
00Goool00`000?ooooooo`04oooo0`0000;oool700000_oooa40001;oooo1P0000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool60000<Oooo`8000000oooo`000000000700001Oooo`800006
oooo0`000003oooo0000000000H000000oooo`000000000?0000D?ooo`H00004oooo00<0003ooooo
ool03oooo`009?ooo`040000oooooooooooo1P0003Koool00`000?ooooooo`0900001Oooo`030000
oooooooo00Coool300000_ooo`L00002oooo4@0004_oool600001?ooo`030000oooooooo02ooool0
10000?ooooooooooo`H0000aoooo0P000003oooo0000000000L00005oooo0P0000Koool3000000?o
ool0000000001P000003oooo0000000000l0001@oooo1P0000Coool00`000?ooooooo`0?oooo000T
oooo0P0000;oool60000=_ooo`X00002oooo0P0000[oool900000oooo`800002oooo3`0004_oool6
00000oooo`80000aoooo0P0000;oool60000<Oooo`/000000oooo`000000000;oooo2@0000?oool0
0`000?ooooooo`0?0000D?ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooo
oooo1P0003Coool;000000?oool0000000001@000004oooo00000000oooo4@0000;oool?0000Booo
o`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P00033oool:00000_ooo`H00002
oooo00<0003oooooool0400000;oool?0000D?ooo`H00004oooo00<0003oooooool03oooo`009?oo
o`040000oooooooooooo1P0003Coool;000000?oool0000000001@000004oooo00000000oooo4@00
00;oool?0000Boooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P00033oool:
00000_ooo`H00002oooo00<0003oooooool0400000;oool?0000D?ooo`H00004oooo00<0003ooooo
ool03oooo`009?ooo`040000oooooooooooo1P0003Coool;00001Oooo`<00003oooo00<0003ooooo
ool03`0000;oool?0000Boooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P00
033oool:00001Oooo`<00003oooo0P000003oooo0000000000d00002oooo3`00053oool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H0000doooo200000Woool200000ooo
o`040000oooooooooooo0P000003oooo0000000000<000000oooo`0000000005oooo100000;oool9
0000Boooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P00033oool700002Ooo
o`800003oooo0P0000?oool00`000?ooooooo`0400000_ooo`030000oooooooo00?oool5000000?o
ool0000000001`00053oool600001?ooo`030000oooooooo00ooool002Coool010000?oooooooooo
o`H0000doooo200000Woool200000oooo`040000oooooooooooo0P000003oooo0000000000<00000
0oooo`0000000005oooo100000;oool90000Boooo`H00004oooo00<0003oooooool0;oooo`040000
oooooooooooo1P00033oool700002Oooo`800003oooo0P0000?oool00`000?ooooooo`0400000_oo
o`030000oooooooo00?oool5000000?oool0000000001`00053oool600001?ooo`030000oooooooo
00ooool002Coool010000?ooooooooooo`H0000foooo1`0000_oool200000oooo`030000oooooooo
00?oool400003_ooo`P0001;oooo1P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool6
0000<Oooo`P0000;oooo00@0003oooooooooool200001?ooo`D0000>oooo1`00053oool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H0000foooo1`0000Goool800000ooo
o`040000oooooooo00000_ooo`@00002oooo2@0000?oool60000COooo`H00004oooo00<0003ooooo
ool0;oooo`040000oooooooooooo1P00037oool800001?ooo`P00003oooo0P000004oooo00000000
oooo1@000003oooo0000000000P00003oooo1P00057oool600001?ooo`030000oooooooo00ooool0
02Coool200000_ooo`H0000foooo1`0000Goool800000oooo`040000oooooooo00000_ooo`@00002
oooo2@0000?oool60000COooo`H00003oooo0P00037oool200000_ooo`H0000aoooo200000Coool8
00000oooo`8000001?ooo`0000000?ooo`D000000oooo`000000000800000oooo`H0001Aoooo1P00
00Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000=?ooo`H00008oooo0P00
0003oooo0000000000@00008oooo0`000003oooo0000000000T00003oooo1P0004goool600001?oo
o`030000oooooooo02ooool010000?ooooooooooo`H0000`oooo1P0000Ooool2000000?oool00000
00001@0000Ooool300000_ooo`/00003oooo1P00057oool600001?ooo`030000oooooooo00ooool0
02Coool010000?ooooooooooo`H0000foooo5@0000Woool5000000?oool0000000003`0004goool6
00001?ooo`030000oooooooo02ooool010000?ooooooooooo`H0000aoooo5P0000Woool400000_oo
oa40001Aoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000=_oo
oaD00009oooo1@000003oooo0000000000l0001=oooo1P0000Coool00`000?ooooooo`0_oooo00@0
003oooooooooool60000<OoooaH00009oooo100000;ooolA0000DOooo`H00004oooo00<0003ooooo
ool03oooo`009?ooo`040000oooooooooooo1P0003Coool8000000?oool0000000003`0000KooolG
0000COooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P00033oool700000_oo
oa400006oooo5`00057oool600001?ooo`030000oooooooo00ooool002Coool010000?oooooooooo
o`H0000doooo300000;oool2000000?oool0000000002@0000?ooolH0000COooo`H00004oooo00<0
003oooooool0;oooo`040000oooooooooooo1P00033oool<000000Coool00000003oool;00000ooo
oaT0001Aoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000=?oo
o``00002oooo0P000003oooo0000000000T00003oooo600004goool600001?ooo`030000oooooooo
02ooool010000?ooooooooooo`H0000`oooo30000004oooo00000000oooo2`0000?ooolI0000DOoo
o`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P0003Coool300001Ooo
o`P00004oooo200000?oool6000000?oool0000000000`0000;oool:0000COooo`H00004oooo00<0
003oooooool0;oooo`040000oooooooooooo1P00033oool300001?ooo`P00005oooo1`0000?oool6
00000_ooo`@00002oooo2`00057oool600001?ooo`030000oooooooo00ooool002Coool200000_oo
o`H0000doooo0P0000Koool010000?ooooooo`0000;oool300001Oooob40001=oooo1P0000?oool2
0000<Oooo`800002oooo1P00033oool00`000?ooooooo`04oooo0P000004oooo00000000oooo0`00
00GooolR0000DOooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo1P00
03Coool200001_ooo`040000oooooooo00000_ooo`<00005oooo8@0004goool600001?ooo`030000
oooooooo02ooool010000?ooooooooooo`H0000`oooo00<0003oooooool01?ooo`8000001?ooo`00
00000?ooo`<00005oooo8P00057oool600001?ooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`H0000doooo0P0000OooolA00001_oooa@00002oooo00<0003oooooool0Boooo`H00004
oooo00<0003oooooool0;oooo`040000oooooooooooo1P00033oool00`000?ooooooo`06oooo4@00
00KooolD000000?oool000000000DOooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo1P0003Coool200001ooooa400006oooo500000;oool00`000?ooooooo`1;oooo1P00
00Coool00`000?ooooooo`0_oooo00@0003oooooooooool60000<?ooo`030000oooooooo00KooolA
00001_oooa@000000oooo`000000001Aoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0
003oooooooooool60000=_ooo`040000oooooooooooo0P000003oooo0000000000Goool00`000?oo
ooooo`0700000_ooo`040000oooooooooooo2P0000Koool010000?ooooooooooo`<0001=oooo1P00
00Coool00`000?ooooooo`0_oooo00@0003oooooooooool60000<Oooo`800003oooo00@0003ooooo
ool00005oooo00<0003oooooool020000003oooo0000000000?oool900001_ooo`800003oooo0`00
057oool600001?ooo`030000oooooooo00ooool001;oool500000_ooo`030000oooooooo00;oool0
0`000?ooooooo`03oooo00@0003oooooooooool60000=_ooo`<0000>oooo00<0003oooooool03Ooo
o`<00002oooo0P0000[oool20000C_ooo`H00004oooo00<0003oooooool07_ooo`D00002oooo00<0
003oooooool00_ooo`030000oooooooo00;oool010000?ooooooooooo`H0000aoooo0`0000koool2
00003oooo`<000000oooo`000000000;oooo00<0003oooooool0DOooo`H00004oooo00<0003ooooo
ool03oooo`005?ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00@0
003oooooooooool60000=_ooo`<0000>oooo00<0003oooooool03Oooo`<00002oooo0P0000[oool2
0000C_ooo`H00004oooo00<0003oooooool08?ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000003oooo00@0003oooooooooool60000<Oooo`<0000>oooo0P0000ooool3000000?o
ool0000000002oooo`030000oooooooo057oool600001?ooo`030000oooooooo00ooool001Coool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`800002oooo1P0003coool0
0`000?ooooooo`0<oooo0P0000coool00`000?ooooooo`0200000oooo`040000oooooooooooo0P00
0003oooo0000000004koool600000oooo`80000Roooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000?oool200000_ooo`H0000goooo0P0000koool00`000?ooooooo`0:oooo0P00
0003oooo0000000000?oool200000oooo`040000oooooooo0000Doooo`H00003oooo0P00017oool0
01Coool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`040000oooooooo
oooo1P0003Ooool300009?ooo`<000001?ooo`0000000?ooo`<0001@oooo1P0000Coool00`000?oo
ooooo`0Poooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool010000?oo
ooooooooo`H0000coooo0`0002?oool300000_ooo`030000oooooooo00<0001Doooo1P0000Coool0
0`000?ooooooo`0?oooo000Doooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00Coool010000?ooooooooooo`H0000goooo0`0002Coool3000000Coool00000003oool30000D?oo
o`H00004oooo00<0003oooooool08?ooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`000003oooo00@0003oooooooooool60000<oooo`<0000Soooo0`0000;oool00`000?ooooooo`03
0000E?ooo`H00004oooo00<0003oooooool03oooo`004oooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo00?oool010000?ooooooooooo`H00015oooo0P0000ooool300001_ooo`80001G
oooo1P0000Coool00`000?ooooooo`0Ooooo0P0000Coool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`040000oooooooooooo1P00043oool200003oooo`<00006oooo0P0005coool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H0000joooo0P0001koool200000_oo
o`040000oooooooo00000_ooo`030000oooooooo057oool600001?ooo`030000oooooooo02ooool0
10000?ooooooooooo`H0000foooo00<0003oooooool07Oooo`040000oooooooo00000_ooo`800000
0oooo`000000001Goooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool6
0000>_ooo`80000Noooo0P0000;oool010000?ooooooo`0000;oool00`000?ooooooo`1Aoooo1P00
00Coool00`000?ooooooo`0_oooo00@0003oooooooooool60000=_ooo`030000oooooooo01goool0
10000?ooooooo`0000;oool2000000?oool000000000Eoooo`H00004oooo00<0003oooooool03ooo
o`009?ooo`040000oooooooooooo1P0003coool600007Oooo`D0001Doooo1P0000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool60000=oooo`H0000Moooo1@0005Woool600001?ooo`030000
oooooooo00ooool002Coool010000?ooooooooooo`H0000moooo0`0000_oool200001_ooo`@00002
oooo00<0003oooooool00P000003oooo0000000005Ooool600001?ooo`030000oooooooo02ooool0
10000?ooooooooooo`H0000ioooo0`0000_oool00`000?ooooooo`04oooo1@000004oooo00000000
oooo0P000003oooo0000000005coool600001?ooo`030000oooooooo00ooool002Coool200000_oo
o`H0000moooo0`0000_oool200001_ooo`@00002oooo00<0003oooooool00P000003oooo00000000
05Ooool600000oooo`80000aoooo0P0000;oool60000>Oooo`<0000;oooo00<0003oooooool01?oo
o`D000001?ooo`0000000?ooo`8000000oooo`000000001Loooo1P0000Coool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool60000@_ooo`8000000oooo`0000000009oooo1P0000Coool4
0000F_ooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0003goool2000000?o
ool0000000002Oooo`H00005oooo0`0005ooool600001?ooo`030000oooooooo00ooool002Coool0
10000?ooooooooooo`H00014oooo00<0003oooooool01?ooo`800007oooo0P0006;oool600001?oo
o`030000oooooooo02ooool010000?ooooooooooo`H0000ooooo00<0003oooooool01Oooo`030000
oooooooo00Koool00`000?ooooooo`1Uoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0
003oooooooooool60000A?ooo`030000oooooooo00Coool200001oooo`80001Roooo1P0000Coool0
0`000?ooooooo`0_oooo00@0003oooooooooool60000?oooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool0IOooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo1P000;Soool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H0002h
oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000^?ooo`H00004
oooo00<0003oooooool0;oooo`040000oooooooooooo1P000;Soool600001?ooo`030000oooooooo
00ooool002Coool010000?ooooooooooo`H0002hoooo1P0000Coool00`000?ooooooo`0_oooo00@0
003oooooooooool60000^?ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000oooooooo
oooo1P000;Soool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H0002hoooo1P00
00Coool00`000?ooooooo`0?oooo000Toooo0P0000;oool60000^?ooo`H00003oooo0P00037oool2
00000_ooo`H0002hoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool6
0000^?ooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P000;Soool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H0002hoooo1P0000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool60000^?ooo`H00004oooo00<0003oooooool03oooo`009?oo
o`040000oooooooooooo1P000;Soool600001?ooo`030000oooooooo02ooool010000?oooooooooo
o`H0002hoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool60000^?oo
o`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P000;Soool600001?ooo`030000
oooooooo00ooool002Coool010000?ooooooooooo`H0002hoooo1P0000Coool00`000?ooooooo`0_
oooo00@0003oooooooooool60000^?ooo`H00004oooo00<0003oooooool03oooo`009?ooo`040000
oooooooooooo1P000;Soool600001?ooo`030000oooooooo02ooool010000?ooooooooooo`H0002h
oooo1P0000Coool00`000?ooooooo`0?oooo000Toooo0P0000;oool60000^?ooo`H00003oooo0P00
037oool200000_ooo`H0002hoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003ooooo
ooooool60000^?ooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P000;Soool6
00001?ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H0002hoooo1P0000Coool0
0`000?ooooooo`0_oooo00@0003oooooooooool60000^?ooo`H00004oooo00<0003oooooool03ooo
o`009?ooo`040000oooooooooooo1P000;Soool600001?ooo`030000oooooooo02ooool010000?oo
ooooooooo`H0002hoooo1P0000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool6
0000^?ooo`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P000;Soool600001?oo
o`030000oooooooo00ooool002Coool010000?ooooooooooo`H0002hoooo1P0000Coool00`000?oo
ooooo`0_oooo00@0003oooooooooool60000^?ooo`H00004oooo00<0003oooooool03oooo`004_oo
o`D000001?ooo`000000000000?oool00`000?ooooooo`03oooo00@0003oooooooooool600000_oo
o`030000oooooooo0;?oool600001?ooo`030000oooooooo01koool5000000Coool0000000000003
oooo00<0003oooooool00_ooo`040000oooooooooooo1P000;Soool600001?ooo`030000oooooooo
00ooool001Coool01@000?ooooooooooo`000004oooo00<0003oool000001?ooo`040000oooooooo
oooo1P0000?oool20000/oooo`H00004oooo00<0003oooooool08?ooo`050000oooooooooooo0000
00Coool00`000?ooo`000003oooo00@0003oooooooooool60000^?ooo`H00004oooo00<0003ooooo
ool03oooo`005?ooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000004oooo0P00
00;oool600000oooo`80002coooo1P0000?oool200008_ooo`030000oooooooo00;oool01`000?oo
ooooooooo`000?ooo`000003oooo0P0000;oool60000^?ooo`H00003oooo0P00017oool001Coool0
0`000?ooooooo`02oooo00L0003oooooooooool0003oool000001?ooo`040000oooooooooooo1P00
0;Soool600001?ooo`030000oooooooo023oool00`000?ooooooo`02oooo00L0003oooooooooool0
003oool000000oooo`040000oooooooooooo1P000;Soool600001?ooo`030000oooooooo00ooool0
01Coool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`040000oooooooo
oooo20000;Koool600001?ooo`030000oooooooo023oool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oool000000oooo`040000oooooooooooo1P000;Soool600001?ooo`030000oooooooo
00ooool001?oool200001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00@0003ooooo
ooooool80000]_ooo`H00004oooo00<0003oooooool07oooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo00;oool010000?ooooooooooo`H0002hoooo1P0000Coool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool60000]Oooo`030000oooooooo00H00004oooo00<0003ooooo
ool0;oooo`040000oooooooooooo1P000;3oool200001_ooo`H00004oooo00<0003oooooool03ooo
o`009?ooo`040000oooooooooooo1P0000Soool00`000?ooooooo`08oooo00<0003oooooool0X_oo
o`H00004oooo00<0003oooooool0;oooo`040000oooooooooooo1P0000?oool200002Oooo`030000
oooooooo0:Ooool600001?ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H00008
oooo00<0003oooooool02?ooo`030000oooooooo0:;oool600001?ooo`030000oooooooo02ooool0
10000?ooooooooooo`H00003oooo0P0000Woool00`000?ooooooo`2Woooo1P0000Coool00`000?oo
ooooo`0?oooo000Toooo00@0003oooooooooooo400001?ooo`030000oooooooo02ooool010000?oo
oooooooool@00004oooo00<0003oooooool03oooo`009?ooo`800002ooooa00000?oool20000<Ooo
o`800002ooooa00000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooooo400001?oo
o`030000oooooooo02ooool010000?oooooooooool@00004oooo00<0003oooooool03oooo`009?oo
o`040000ooooooooooooa00000Coool00`000?ooooooo`0_oooo00@0003oooooooooooo400001?oo
o`030000oooooooo00ooool002Coool010000?oooooooooool@00004oooo00<0003oooooool0;ooo
o`040000ooooooooooooa00000Coool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooooo4
00001?ooo`030000oooooooo02ooool010000?oooooooooool@00004oooo00<0003oooooool03ooo
o`009?ooo`030000oooooooo0<Woool00`000?ooooooo`0_oooo00<0003oooooool0bOooo`030000
oooooooo00ooool002Coool00`000?ooooooo`39oooo00<0003oooooool0;oooo`030000oooooooo
0<Woool00`000?ooooooo`0?oooo000Toooo0P0000;oool00`000?ooooooo`0Loooo00<0003ooooo
ool06oooo`030000oooooooo01coool00`000?ooooooo`0Loooo00<0003oooooool06oooo`030000
oooooooo01coool00`000?ooooooo`0<oooo0P00037oool200000_ooo`030000oooooooo01coool0
0`000?ooooooo`0Koooo00<0003oooooool07?ooo`030000oooooooo01coool00`000?ooooooo`0K
oooo00<0003oooooool07?ooo`030000oooooooo00goool00`000?ooooooo`0?oooo000Tooooc@00
037oooo=00004Oooo`00ooooooooool2oooo003oooooooooo`;oool00?oooooooooo0_ooo`00oooo
ooooool2oooo003oooooooooo`;oool007Goool30000oooooaCoool30000L_ooo`00M_ooo`030000
oooooooo0?oooolDoooo00<0003oooooool0LOooo`00Ioooo`<00002oooo1@000005oooo0000oooo
0000oooo00<00002oooo0`0000?oool200003Oooo`<00002oooo0`000004oooo0000oooooooo0P00
00?oool200000oooo`80002Uoooo0`000007oooo000000000000oooo0000oooo00<00002oooo0`00
00?oool200000oooo`800003oooo0`0000koool300000_ooo`<000001oooo`000?ooo`000?ooo`00
0?ooo`0300000_ooo`<00003oooo0P0000goool300000_ooo`<000001?ooo`000?ooooooo`800003
oooo0P0000?oool20000@_ooo`00Ioooo`030000oooo000000;oool3000000Soool0003oool0003o
ool0003oool00002oooo00@0003oooooool00003oooo00<0003oooooool03_ooo`030000oooooooo
00;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooo`000002oooo00<0003oool000000_oo
o`030000oooooooo0:;oool00`000?ooo`000002oooo00@0003oooooool00002oooo00<0003ooooo
ool00_ooo`050000oooooooooooo000000;oool00`000?ooo`000004oooo00@0003oooooool0000>
oooo00<0003oool000000oooo`0:0000oooooooo0000oooo0000oooo0000oooo00000_ooo`040000
oooooooo00000oooo`030000oooooooo00koool00`000?ooooooo`02oooo00H0003oooooool0003o
ool00002oooo00<0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`0ooooo001Y
oooo00<0003oooooool00_ooo`090000oooo0000oooo0000oooo0000oooo000000;oool010000?oo
ooooo`0000?oool300003_ooo`<00002oooo00H0003oooooool0003oool00002oooo00<0003oool0
00001?ooo`040000oooooooo0000Y_ooo`040000oooooooo00000_ooo`040000oooooooo00001?oo
o`050000oooooooooooo000000Coool300000_ooo`040000oooooooo00004?ooo`050000oooooooo
oooo000000;oool01`000?ooo`000?ooo`000?ooo`000002oooo00@0003oooooool00003oooo0`00
00koool300000_ooo`060000oooooooo0000oooo00000_ooo`030000oooo000000Coool010000?oo
ooooo`00047oool006Soool00`000?ooooooo`02oooo0P000006oooo00000000oooo0000oooo1000
00?oool010000?ooooooooooo`<0000>oooo00D0003oooooool0003oool00`0000?oool2000000?o
ool0000000000P0000?oool20000Y_ooo`040000oooooooooooo0`0000;oool200000oooo`<00000
0oooo`000000000200000_ooo`<00003oooo0`0000ooool010000?ooooooooooo`800002oooo0P00
0003oooo0000oooo00@00003oooo00@0003oooooooooool300003_ooo`050000oooooooo0000oooo
00<00003oooo0P000003oooo0000000000800003oooo0P0004;oool006Ooool00`000?ooo`00000B
oooo00<0003oooooool04_ooo`060000oooooooo0000oooo00002Oooo`030000oooooooo0:[oool0
0`000?ooo`000002oooo00<0003oooooool02?ooo`050000oooooooooooo000000coool00`000?oo
ooooo`0<oooo00<0003oool000004_ooo`030000oooooooo01;oool01P000?ooooooo`000?ooo`00
00Woool00`000?ooooooo`17oooo001Woooo0`00017oool200004oooo`@000000oooo`000000002f
oooo0`000003oooo0000000000Goool00`000?ooooooo`03oooo00<0003oooooool03?ooo`80000>
oooo0`0000?oool00`000?ooooooo`0;oooo0P0001?oool4000000?oool000000000Doooo`00oooo
ooooool2oooo003oooooooooo`;oool00?oooooooooo0_ooo`00ooooooooool2oooo003ooooooooo
o`;oool00?oooooooooo0_ooo`00ooooooooool2oooo003oooooooooo`;oool00001\
\>"],
  ImageRangeCache->{{{0, 511}, {242.688, 0}} -> {-0.0528037, -0.0238146, 
  0.00412057, 0.00412057}, {{12.8125, 243.938}, {236.875, 
  5.75}} -> {-26.3718, -13.8837, 0.652088, 0.652088}, {{267, 498.125}, {
  236.875, 5.75}} -> {-192.124, -13.8837, 0.652088, 0.652088}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Correlation\)], "Input"],

Cell["\<\
corRelation=
\tCompile[{{vectorA,_Real,1},{vectorB,_Real,1}},
\t\tModule[{meanA=0.,meanB=0.,normA=0.,normB=0.,
\t\t\t\tvectorAprime={0.},vectorBprime={0.}},
\t\t\tmeanA=Apply[Plus,vectorA]/Length[vectorA];
\t\t\tmeanB=Apply[Plus,vectorB]/Length[vectorB];
\t\t\tvectorAprime=vectorA-meanA;
\t\t\tnormA=Sqrt[vectorAprime.vectorAprime];
\t\t\tvectorBprime=vectorB-meanB;
\t\t\tnormB=Sqrt[vectorBprime.vectorBprime];
\t\t\tvectorAprime.vectorBprime/(normA normB)]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["corRelation[Flatten[nsample],Flatten[ssample]]", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(0.588651192773800513`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Discrete\ Fourier\ transform\)], "Input"],

Cell["\<\
SampleFourier=Chop[Abs[Fourier[nsample]]];
ShiftedSampleFourier=Chop[Abs[Fourier[ssample]]];\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
SampleSpect=ListDensityPlot[SampleFourier,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Sample Spectrum\",
\tDisplayFunction->Identity];
ShiftedSampleSpect=ListDensityPlot[ShiftedSampleFourier,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Shifted Sample Spectrum\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SampleSpect,ShiftedSampleSpect}]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -47.125 0 ]
[.5 1.0125 47.125 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -108.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Spectrum) show
153.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFDC727CFF5DFFFFFFFFFF
FFFFFFFFFFFF64387FE1CA969D7BE6FFFFBAFF8F72A4646F
799F4F6F8CFF69FFFFEBFF926AA9B961C561B9A96A92FFEB
FFFF69FF8C6F4F9F796F64A4728FFFBAFFFFE67B9D96CAE1
7F3864FFFFFFFFFFFFFFFFFFFFFF5DFF7C72DCFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFB0FFFF4CFF77FF97A3BC7961FFFFBC7F88FFBA
C3D44E6BAE8833F65F4D506776925731368C709D75596D8D
5DA5743DA053343A95D5595188498A01A4693F238E123F37
7A6F4E14846B5512AE4616611B964851465D86716FB645CE
328B5089D07330615E6B8670908FADCF46972BFF58F418FF
68FFFFFFFFFFFFFF
FFFFFFFF9FFFECFF458BFFF9CBFFC8BC46A654FF9F8445DA
918F72847FAD55A97E79505B825B3821936E613B30453B6D
5C1964402A4B3775A3662F461E3A4232501F292E2435574B
5734483C221B5F7C4F5841589756687C8181271D0A1F4832
25287424BDB2067371671DA9858EFA228EAE561CF6C88555
2CD567FFFFFF99FF
FFD9FFFFFFFF706DFFFF35E2FFAC5986FF2E7DFFD1628DF5
66FFC340A69DB4B59B707F7C9F2055725A62BA3645282167
380E3072766F4527514AAA5D1A34493676562E0354336348
666034186654408F51260C84EA7D17687F8B0C39412CA51E
55288E656A5D2A12FB7036AECF62C049545B79C7DDFFFFBC
FAFB9DFFFF3B538D
FFFFFFFFFF7BFFDAFF7F7DE5EA67444ED15D4B1490609E75
B6FF21536AFB919C5AC26D464B2D2480473ECC227896476A
7E9273719F86230F481E7C3D5124484497663D313D673078
A65A601B2E331E31AD2437789D534F6A9F858C4838445C73
60764EAB3784A7A0FECA1A90CDCFDEBBA04D1C8D876973FF
B8FFC442FF90E8FF
FFF3FFFFD443FDFFFFFF5161FF541272FF73668156421E76
A9A6592898EE7BDD5B945F8D5E4442168255B235039E207E
90694A6815774D426518BB3E385C542293353D602E8D2E55
92523D35143D3367775A524E2293E7394C9C55701D646049
0D45889485D08AA1CD6B7CDA3E373391707C37A813FFE17D
906ADAFFFFFFB4FF
FFFFCEFF6976B9E43204A8A441248769DFA182489CA85094
9041303A77B975967C632B50614B6E8B2F5B98226A4E507D
5527054F3AA155354A367664679F3827251A2A58795E474E
B1A223364C3A35783545807F36ACE851525855576764D73C
2D504D1295AA8994E553B09019438E40457A7AA8F06521C1
F358AFCCFF76FFC0
FFAEFFA23B99FF82ACA14E0E8795C8FF1483768955271FA3
526E146119B25366A5AA2C7A786C7564544462454F347B1B
352639775B8144060B456070307231862957172A79621A64
060E6C864835468A5855C29915B5E95A2431A10C3F8CC148
BA2070D25A43629D9770A04872798F0958C022FF56F1C7DD
75DB353F24D7FFFF
FFDA6091FABC538474729F37AECBC466BE707D3477145377
5F3A503E1E604392874E5140BD77B574A15EA21A262C242C
084A65652740183A2D7E714F389F2C211C314D6721847159
88552495287C5B0229637E1F4B4D9E1B38117C6114577182
745641B65A5A5859993CB96159B69D43A7F3FF5696F0BBD1
77BB54E3DB1DC2FF
FFC9FF7C34FF8036366C3A96881CE6BE4F4C31276B2D308A
9F4A33504D42393738251B5A2C4A8A28BA3A8338760D1059
5933A369343167100A767069562607181C644E3D111D826C
764D7A2155563E4252533F478A7D56366D30706565189E72
59915EC5475C8475D57C512A44DB37A27DABA59F349FD963
3ACCFFB5FFFEFFD4
FF94FFE7B4FF6249497235AE775B56650A6A4F683DE26238
A8896A276B0A2E87824A246C9483698F8C1B56496F270F70
941D3E536538A1322074587B3A34077D6F5F2A4052717E59
80622D1F404938393E547643325B77103136614C65359B85
2D74625D2E5D582690A74C7C67FFAA43678A4B4CA1AFC381
86E2318B8145592E
FFD7B3354A89CCB43AB52589758EA91A457222BF454FA430
B04D6E34882B4088A645356DA64D4897302181161A2E63D9
9E1D1A14454E4C463A5C1E0654295435525F17A14B7E5665
283B663E2A672E8A374D3E335E462E595D1065214D12489D
12BD452A632B92DC7B64269E45E748457FCE56A64CA8127D
9A63FF5EABCA59FF
FF589AAA1995C68CD26B4D3D47924A6F5C291F778C4E832A
D1D23F9A8B4F2E597B6A6A24577C375D495F9E5930764A97
833C1F54484F2B76312E6F4C2D554050952219774A7E4294
3C2E331B6D5806EB381B4448284F6930523C58984C432727
361A6CB4E23A72D11A515A874A757EFC6C46BE47D9516797
9267FFA179FFFFB0
F2FF942C0BA2FF80C8FF245F66B8977F6945696A1BA97C75
81CC913F4EAE77826D43713787484D103052681F6D832B37
63142A9985622E50124C4F645E4C4F6046374836165D0665
19193E502129245645357272550F7C0E743420656E55302D
5A8D7D0E680E1FB7813EA3964E466A3A1D5A43F329823C90
EC25EE369928FF52
46C4F040FB2B4368FF84925C321E2B783A50955246823C6F
51A59E5B1B918519641220994D69592924440E2A95391C75
2224529A4866562D2A5234504A21593A5522232428194B2C
200A5C979C416A3E762F2E4D353C8D2D8B36386F31372C52
697060361B467E788274550D2B60243EA2061EA02AEA8449
7FC0598DA74FFFA8
D0E26CFF1767B165FFC0C26DAD2E3432110E9679C63A8DDA
61845FC74723678549365268357D4F3E3E2F603227597F3C
19424D7D45776E3F2C51543D5E3B2059514E243E15363B2D
724A1A8897171C3A243C674D3E463C60573F69351F26434E
9730842750665C5D444E0F081C9239D42FB06A8C906FA072
2F3847C1BAEC9947
FFE357B0979F37889B88215EF7C34A5A84AF0FC297342764
1C367B8F761C53AF562D10341D539F25437B1244246C47A4
83495A6E882993472724365F353DA03527854C353908243B
6233437F8B4E3B401E664D682A10441A502E18581723854C
594A3655732F7F90691B2D38258A276850AE343B5C213C3E
6EB52C549049685A
ED916C9547349A98823E691862287CBD26399E624B25262C
2E2B151821542B334B2A3E4A2F1C4474C3336C406A233125
3F5CBE28131F5C17381D30296B653C7A054C293F66454C4F
7A315B3257358A3B6C27541F1D56794F76692A4A195E3959
9B502A6FA5E0232D9D549D98694074072149472F22706493
931C8B307ABB411D
C7A65291243D22545C6C7B2B574D48953F5A383757915087
4A205274513490A02533141E6F20491A5C312E2F2892371B
3E6278502A7666171E4D275240B7583C1E374C467C392D13
9B7C580C3932552548192F3A6B509D6A63696F3458908867
651A6B9B33AC5D2476813F276246234E3908235E8B18B990
499C370E5B90526E
FF8B396972853F0C1F21741E479871532965456A8962316E
542F2A7F35742230673D2E38559F1B37674E50483658A468
5F47298421338F2D8135381874854386364B691B89706553
518F4456305778455742291A43452B31586D31986C6C236F
AF311FA53E892D44257E06818671556C140812633C5F6CE1
4267927848D5CF92
FFF645994E796878A01B141C0F4ED62E7A598CC84AAF5962
78281360236441638B284D7234FF4C181C26561F40475721
2768407A0F33413A76543C192854555842274675352E3E41
9623584332082E1F504C40251661054C4E1D4661391A3E5C
5C36246E55674628CC5796854564562E48211B4F503A41FF
307E66B4524F5AA3
FF189993384565120E4C7A282F1DB71CD75E238A1D593177
7F417C657C4FAF474A66088C3B8E301229424E4B23282337
7A6B1B4F2C5A0B4B75895768484F6A928151179066712928
684D56260E483C272F1F302B505941351D53384031619E88
50726E313E3374766409532C6F6C264437380D2D8E808786
4950287B8F0C7590
FF8C3D3A892F7D1C45115F3C56725663FF24275823B74761
545D72917E23925A5B1D5A75583D3E463E0C335D2555501A
8A586C262E5D2C5E1B6B557231183F3E34193D2B547CAF3D
2C6D363163234832395360284D3360844C60351543A68382
525422400B48320C624685B4144B25487331120C8494855C
1F57784696437295
FFFFF18634347C743C2050334C06263F892B954E60A8A17E
154E54805E392090661330310EAF493639312265305E6349
4F48466B43640D283C780F22346E698D3F4D59543755605C
3D462F3E414B1D27532326459F3B8851A152926638360D18
576455677663591941526D19252F403C582C332635446E66
4A9F5D6D626C5E85
7F7F47363D8B258FBA9628743D6648368D68345546379D42
32431910393F2F1E41471B6727534B37291C65194B559338
4372393170591E13156960933F323403383E308776670E62
453B2B53C592726C870318306B1B0A41345380495E864552
1325953219882C7842575A30425E41342B20938328F735BE
44498F22880975BD
FFEB9951632F15588A2C499F257C4B4D5A6D884483577122
2D480F154E3F250C081D1A4F23215E4A293923075B2D716D
305A3A2420594E7C435821504935A63818784B063C385730
2653BA3E3567903C2834533F52494189164C5D350A7F2836
834B5373605136957862A53260511A37766532237F5E6A7D
9C4E7279D53383C7
FF737DD92A174332CF4C23A30D7530295627975767221B5A
61267D9C613D3B4A2E1D1C3615786E5E331A311A0E835073
3A3C27498230705648471D35166F4A20467C381D2F86504A
7A27575B78BC695C63343E3441106942292F3B8D6E434D4B
6A504533155E17443F785D47307F4709754952807B761F8D
39225B6694685DAF
FFB1058428352656AD7D7E3C4DA32F2B194B4829536A6C2E
62664780F289172A4E103B54492E7F0E4F4525273B503A25
2D16202C2C282C39472566898A66A0736F3A1374263C2A17
9135703C290B4B906D30945249223A502349336B648D3740
624B75716132306B1A34693F500B21262F8B64766B027547
57240D3A97B41AFF
F66C316E50267739624A868750593D42435D7145191A7C46
4180486C4C0F566E678E637B28257A24574538362D3B263B
48726A5916376B5F5D7A2D1F140C6F252272212B1839147F
645B1379304D507C576D7E641729221F5D5C3A716F847122
692187392A7E453A1A1E6F403D23383C380C3E6A323FBE4D
1F580B63508A76FF
FF5C4F26696B683747134C0B1F1C5154562675554B938D63
685E5A1D68291F3688696F2D8A81361429872A506375401E
6AA6825D933724346E642D575B5B302F4F4E111611344654
306C0A4A035E5E4C182133353C54495445355E2715485C5D
3B6E4019322A3B1D141B1327514D77195548956DB83C1795
46109E4F803954FF
6D22CD271C361D426A50306F5A4D8DB82E5468934F696850
7A42215B662958883279454F1C1A8440436B4E6C4B574217
4E597232300B284C1B910F582B393F472E483624231C6616
085136460A5B4E6D655126560D627946172A0F1A5E707E11
9251023B4E2E3B14282B708B34ACA15E3646381DAC6C52BE
461F2489687EAEC2
9B76719E506E064A2963906A38B0AA598A8C7119514B836C
6C5893213764236D4F52846E1D574AB2217C311257983D62
3E09502C4C5D485F1CA93D4C0F61213A36452F33593F5985
50193068595927413D5660719F8C83145A25244B3F331F2D
5E6B3A36510C074B1F44545483B16A1D2E5D510B5A5B6038
357F6D8626BB8AF6
6A77485964A7555A0851754A70414C6112555F406FB0D014
660D1C31072B3E5E560D1E4748527A56562C554446632E73
505E5D4E984F50364941243442821C5D55204B30393D531C
6940105F1C3A6E2337729442591D41732D522117564F2A2F
2116371F38295C71A516265D47438A2A52444260344D6A27
6916534D66732C7F
8E43906D54624E2C4F195E3C4B2A254A355A64463F2F3B28
3830315945724567521F2C38743A953B5F230C2253456432
4A3443211BA81D293937230B277989683948956562605D36
C947423F6A2A490C6A1D748C44423770442242514D89153A
4C214C4E9954366E9F6B3E68366D46A16627126A417B4335
5C92111791558F58
8C3C4048632D3065653C3234370848653A594C210D5E142F
446A3B23485D82983B5E616E5B376165486D183A50AD285B
571A73603D2559BC3B644749780F5150043C6B155A40565A
946D1A8A396F2B1C19634A677D73674E3F4CAA6C2B62205F
4B44282C981A4D1132348368344F30767A476F1E3A2671C1
0F4B1C3481BA4FFF
9A6C3F3B2B104E2A5C95D48ABD55559470784A361CA71447
213B163E8761303F2F5C491F4A16CA435A5C9E4E1A13455C
181E127769141B7E4F2C1155444D35296B294B5F0D260B4B
4A591255321A570B210D47188D1459741819545C20124B30
25294E47545A2146202747403B564523333C5E640F9B6E56
40454C982022AF5D
EB12526293678F175307555B76B449815E558F3F3A8E533B
315F6E0C29292F047FA1693F2A9C6251C85C4D46192B4F3D
69486A179B4E3E3D4219121E961D32404F482A654C1C5329
521B597A522C8118A79F19B60F4E3E390A571B873516402F
3E2962402A6220560F34121138682453A81D55376E7E1A43
5745A4236929427E
FF2C8E96425B3D3665644E7A3E6F1C0A6920551F143D6A1D
4B1B606224293968605A06584F514B094E42612787753B39
3A5E7D59743C50584E4F4A2A9831302D9F5D154E1B4B3D2C
2502293C49AE566A3068A9A95F4BAE5C05562294122A1237
45183618352E245C6D86571E9E5861747A18B945329FEC68
1673720A8264429E
FE7F7A6331675EB81238088B21274045308C617431243734
3A470C2A7E243A4B49183823824A563B1C3F38871E534934
580A54242A5A6B108E1E0A353F45723B464D4F2F42615C65
4D2B3A57167D405B52104A7C3A465E2B1A5C643E14173522
211F701B4D6D6B4A0331395F795839A81D2A594343508349
6B247148653AB762
FF5C4B554830A2395F22250F363D392E5A703C225139130B
14721328A79F4C3A33242A407C5C1F685B371B8C7EA37057
A611533A3D695A453F2B165C332E3F3C117C3D5161284321
B6430C640C4C342448535D3C411424417526302A1320105B
3A2746373D30526521651E164948275A7839151A0E1A5DEE
4656353A2C30567C
FF5E20A220536E71183651652D701D2F85420D19552C3D33
173B6362375A6A482F390A495862670E354D4F4A4D8F713E
C94856505D1E21512D280C3A38374C272E346C8488631F2D
77314C2D46281C4A306A4A69724940627525472D1A7D3957
4F2D3C2223417C489A86303F891F106A763E09762B1B7559
5761324F0D567C7B
F65373A96A453E185B2F705F37890D63810D5224263E624E
4C1F55151F1C0B3A353240292C236F465243551513615C2D
412E19643A0844574E4828346328573F4E5155522E716935
31344A7F6443466E6A773E3B6E623B2E652E212A3BB30A33
2F37784E5249656E604E4B4D2B57674354183523494C5D24
39693B2082414F28
6F363B0B4C786B545812B61C09362120B25042213636123D
C8643C2B624E0D312F15386631096E0A3D0B688373273B2D
394A6445211494476A462B1A676A3C3053631840226E4F1F
2038091870628B87333F6E2C40111A55492F583835340F26
3D1963623C20545041244F723852357667806D562A787B71
6B4322512C5D0576
792C2E87678F76615F6C9D501378151F3C5155616B39203A
761734702F3F3C251A264E2B4E476F643826133F1A414E2C
434AA05A0C6D3D422E2A1158153D51153C0632594E271B5B
2F452A06A65D407E164D403E0F2C1C36883AB71E5D261864
3D7F566B5E5C742C37482D113A411A21564116441B855C68
1C853B426442B397
78554D80645F7D2598B2532B1D73AC84286B22285A1A2F2F
344D21224E7237090C3249365B50555E890E272D45247455
5F5A054264234C374C454F948A683F7CA44A4027515E523B
2F5634528B56444B055546652C3E631176089F4C2025510D
4646473669145C1159421F1CA22975806F254D5E5C442A7B
501D455C3A583DAD
CF375F600A9733571E6615161F7E7E2C0A29230B2E230D27
432F6F383C3A4A393A116311291491184031281B25416120
AF6F1F0F1929193148AA09820C9867512564623729383046
20600B119B633F2B1B30164618191C413F305F864C345C3B
103425582663663E4C1E2D53722994583D51215185558E3F
89A6489B37AA7C87
E95D552845702137302C47305A646A224B38234763493568
2139B075314523643E34610F38295B1434431051695F6641
884C32272D500592143627822C291F59287E5D2C4F255049
3B4F5832742F3C1F200D2A223467095E5837542B495F412F
3863635134711E535985894A1D10552A336238213B0D7572
4BB74F249A40A731
FF17B3292A1E3A427853474ACA1E6F72453F1A282E176565
7224603A40199F71172B9744563C87293A59791C2F533C56
322572293F0C7B6A20264121627F616A6489402F8A6F522B
36571A53173D543F493E498C3C5F5146633B1A2A74520E63
2B1E380D2A5A3C35325F494A6A2B144B12453808505B4160
186B33558724647E
9D05483D324D4E704D2B322C77414C5548B4154F2E2C1F9C
2F6533421C556B096C29A13B8614471D22A9555466690C57
714A2E256439811B3F11194E446D3D6D4D44727A572A6E02
2F574964220F3A0B2D474162348373064A50303B642E1C23
103431210659592F54387E1A7559245B426C5E376B28953F
136957774C7A5550
3461183E1B3F1E7AA443955C325F38582264D4B421274F6D
2232574734488C33374C411533204D802D5068792B0B3A70
3475492A835E513C241E1F207F232279BC3AAC1D2B654D4F
2C585724336E131A382031594731BB63517215537A4C2E3A
4C3F41211A414E5C25735E42265331664E342A3D3B27A47B
24374C1D6D242E5F
244B5F41244435314F7E11C55D155657428085610D20725E
404F23411661532A751123293A503F9E0F5B71672A275514
174810354A5B52086A22347764504E546E861B3A2E341C1C
25533C030869612B1D1F35454B7F4F0D315D4D9A9D5D290B
1D1872255B3035083165560D411526221F73371D614A1B66
261B12515F5A44B5
61314C39464E7A1F458B76652E522C5F6A46412137397617
B325229143293D8007564B468C13737C624741806F55320F
1022333A1D523F58622D525641855E6D4F3640484D530A65
63260D54283D2A4C182917263256452F4518995C7935230A
6372611B5F583247235A385C6341175EB7215C1538574B40
0A423E7958132F6A
D75A246F403D6D06494276143853343B3B3A39463727732A
A240208F7C3C43530C3D393E4A4F6A221D5B6B1511144116
1715475B365E187B27175534570C576E082D4D2B64573E4A
3A623F76191D3C483A4C411D4D170A5B6A24832E64494461
B756362B16551F21576C673B522128131D4B2F20662879C2
2B2C812F31156855
DC3329952E5E24712F03556C672D6D422F7DA53171424762
551B33386936272D2B4A353C445C451423584F0711142222
26570B282B474459301F5D4348803A2C27475A1817583A28
6E3A4961315056355A59412F59520A4D43380B882D58521F
773837220E5D5C2A0F201672555D2D501A19314137192F82
2F366A644F59A6C0
B2530F7F295872193652B14A52751F286C5C1D525C454768
863530141D092723065E432D781062601D4343402032214F
31BF5B423671385B3A5346305C7C7A3A1A16312B1624301D
3D83541A6A91112D59621D39399C7D513E17298A1E446733
939B2B3C22182350071F19443C3F293A6F4122935C625A42
382F3752472B6266
FF46511B3F8566445D5E7A76545C76323959447749631724
57465D5D5F221A1D326B424E3A4C3C69296225594640410D
69471B1F1F181B1D4510327F3A395446444C111127250D64
1464152593AD643E442F218A0A405A5676132919072B5331
3FD53D23091A2C2F436E4036214D694D21671E34612B166A
4D80748B38174E79
D57F655C337F3E164682726D2A59526976383B3F3A4F0C5C
56321D17450D11375A1D5B47450C55415723596E2D4B5D24
2F5F3F2D343B613D2695813522834443292A272B6353432F
6C91368DB69A421E69242C367B7A8944363D465424384F50
43654833402B32692B30322F48433451560C724360422A2F
353059667176BAB6
FF6D3882561F24396D3B21556F54454A0A768B656B4F3279
302223435A0A242F192E6357384A193E4E4073234D5F5B49
2C0C5F7D8E2132701F6659676B7634482326490A8F35527B
4059466B9D3041484E1B170F367D9D1A2D124C862355289A
37312B6C5427905D38383C2F25263C185C3354807F174B3F
8A7134493027774E
FB2F5D90337938622045346B40204E1F4D1E238C5715774D
6615148043362D7C6F408D52374B42601E213625876F2A4A
1E3B40131677176E240B3376AC3133444732891B15420A22
64775E1819462D201E4B52776A201B4143483763321F8380
7844726C47465F48693E263C23456D5C15173E175D703B38
4A449E332E447676
EB5FB83613601E51484D18624C550D217762460F481C1B79
09481956395358668D125821593778307B1E45339E402705
2835503B25172D56054B09197B586C423A39222B1C144151
6A95352076401735151C70311D355C544013177A2659784A
286C305C29305C4740404F3929526858462689854069652E
AB16660F42257056
44B882314953104B444C67535536522B46716D3D1A4C3D79
4B383B74113D691A143C1B3A278136549541592136381733
2F337202460A554715132340324E2F4C301F4C4D6A371F30
1D752B4D3B3F384107186648262DA46D4E1A4D5C562F2989
463C338B4339686A6B3A0F5624352329322B7E98442A4632
9313344B30328021
BB6558562F134F8A527158611C615D1A1E052E265D0B4C2B
A95F7E334C32134077722C112B882A6514735D9A33811342
29754E0F5238302A444C372A333E578D2F1D30570D403A41
62504B3E3F542431412E1B482229552225306220230A66AA
183144581F1E5F1C1110263124296E1E3E4B5D6D3C2C5D6F
5052573D2D6B5299
4F803595401C39734F1D7752412462491334647935722457
754B83843C301B6C923D26085471695F3531096F243D1850
1B9918192E21397436754C23133543902D083D375A5C259C
565D36091A1E29069E44162E2256292D111E382546254F47
2D2B2D18212A7F1A085511661F2A5298741A323725415E5C
20758369341E8F64
865B1719343B0E3A5EB73C15555D294D5F86643138123138
2D085B2A201F53328F43134B09226E42431E1D51290E2B55
59674C5743404A6E234B6A2C585745393A47443A32140E51
517442224B1F6C49423B2F7F382E164B3D22225F4E701320
2B183D1C121F261528511E323B4952693D3D41492C510736
243D756C957B4595
0C66903E2C4E24355193195A415A4C7389326448674A581B
1E2E2B433F2C3C483A19157C4F3F295E305B38572426380D
155D2E6E7F1B76890D3873430D465833023358460D437338
0D89761B7F6E2E5D150D38262457385B305E293F4F7C1519
3A483C2C3F432B2E1E1B584A6748643289734C5A415A1993
5135244E2C3E9066
8695457B956C753D243607512C49413D3D6952493B321E51
2815261F121C3D182B2013704E5F22223D4B162E387F2F3B
42496C1F4B22427451510E14323A44473A394557582C6A4B
236E4A4043574C6759552B0E29511D1E43426E22094B1343
8F32531F202A5B082D383112383164865F4D295D55153CB7
5E3A0E3B3419175B
4F648F1E34698375205C5E412537321A7498522A1F661155
081A7F2A21182D2B2D474F254625381E112D2956222E1644
9E06291E1A09365D569C255C5A373D082D90433513234C75
367439212E1918991B50183D246F0931355F69715408263D
926C1B303C84834B7557247235796434134962244152771D
4F73391C40953580
BB99526B2D3D5752506F5D2C3C6D5D4B3E1E6E2924312610
111C5F1E1F58443118AA660A232062302522552922481B2E
413124543F3E4B5062413A400D57301D2F8D573E332A374C
442A3038520F4E7529421381339A5D7314652A882B112C72
774013324C337E5FA92B4C0B5D262E051E1A5D611C615871
528A4F132F565865
44218032304B34139332462A44987E2B3229233524560F3A
6B6A6839438B333C4689292F565C4D1A4E6DA42D26486618
0741383F3B4D2B751D301F376A4D4C1F304C2F4E32402313
1547550A460272332F3317383621594195543681273A1B3C
141A693D11743B384B793D4C1A3D6D71462B52365553674C
444B1053493182B8
EB567025420F6616AB2E6569408589264658685229394F40
40475C30295C306C284A7859267A171340545C351D31701C
15351740762035956A5141141C2B22393A426C587B19094B
05562D17253B5035280527409E33451E7B30783759215812
8D6658533956194809791B1C480F466277210D554C62184D
48511E601336B85F
FB7676442E339E444A383B705D173E17155C6D45233C263E
69485F46476C72447880831F3263374843411B206A77524B
1E202D4619185E7764220A42151B893247443331AC76330B
246E17771613403B1E4A2A6F872536211E60424B37528D40
6F7C2D3643801415664D7715578C231E4D1F4E20406B3445
2062387933905D2F
FF4E7727304934718A3F4B177F8054335C183C26252F3C38
385D9027546C2B31379A285523864C122D1A9D7D360F171B
4E4841309D6B4659407B52358F0A4926234834766B675966
1F7032218E7D5F0C2C495B5F4D2373404E3E194A3857632E
192F240A5A4323223079324F6B658B760A4A45546F55213B
6D39241F5682386D
D5B6BA7671665930352F2A426043720C56513443482F3230
2B69322B4033486543504F382454463D3644897A7B362C24
691E429AB68D36916C2F4353632B272A2943448322358195
263D613B342D3F5F2F245D4B2D6E59235741550C45475B1D
5A37110D45171D32565C0C4F3A3F3B38766952592A6D7282
46163E7F335C657F
FF794E17388B74804D6A162B61341E67214D694D2136406E
432F2C1A09233DD53F31532B0719291376565A400A8A212F
443E64AD9325156414640D252711114C444654393A7F3210
451D1B181F1F1B47690D41404659256229693C4C3A4E426B
321D1A225F5D5D4657241763497744593932765C54767A5E
5D4466853F1B5146
B266622B4752372F38425A625C9322416F3A293F3C44191F
07502318223C2B9B933367441E8A29173E517D9C39391D62
592D11916A1A54833D1D3024162B31161A3A7A7C5C304653
3A5B387136425BBF314F2132204043431D606210782D435E
062327091D143035866847455C521D5C6C281F75524AB152
36197258297F0F53
DCC0A6594F646A362F822F19374131191A502D5D55721620
0F2A5C5D0E223738771F52582D880B38434D0A52592F4159
5A3556503161493A6E283A5817185A47272C3A8048435D1F
305944472B280B572622221411074F582314455C443C354A
2B2D27366938331B556247427131A57D2F426D2D676C5503
2F71245E2E952933
D7556815312F812C2BC2792866202F4B1D132821523B676C
57211F55162B3656B7614449642E83246A5B0A174D1D414C
3A483C1D19763F623A4A3E57642B4D2D086E570C57345517
277B185E365B47151716411411156B5B1D226A4F4A3E393D
0C53433C7C8F2040A22A73273746393A3B3B345338147642
49066D3D406F245A
616A2F1358793E420A404B5738155C21B75E1741635C385A
234732585F1B6172630A2335795C9918452F455632261729
184C2A3D28540D2663650A534D4840364F6D5E854156522D
62583F521D3A3322100F32556F804147627C73138C464B56
07803D2943912225B3177639372141466A5F2C522E65768B
451F7A4E46394C31
24B5445A5F51121B26661B4A611D37731F222615410D5665
310835305B2572181D0B295D9D9A4D5D310D4F7F4B45351F
1D2B616908033C53251C1C342E3A1B866E544E5064773422
6A08525B4A351048171455272A67715B0F9E3F503A292311
752A53611641234F405E72200D618580425756155DC5117E
4F31354424415F4B
345F2E246D1D4C37247BA4273B3D2A344E66315326425E73
255C4E411A21413F4C3A2E4C7A5315725163BB3147593120
381A136E332457582C4F4D652B1DAC3ABC7922237F201F1E
243C515E832A497534703A0B2B7968502D804D203315414C
37338C4834475732226D4F2721B4D4642258385F325C9543
A47A1E3F1B3E1861
9D50557A4C775769133F95286B375E6C425B2459751A7E38
542F59590621313410231C2E643B30504A06738334624147
2D0B3A0F226449572F026E2A577A72444D6D3D6D444E1911
3F1B813964252E4A71570C69665455A9221D4714863BA129
6C096B551C4233652F9C1F2C2E4F15B448554C41772C322B
4D704E4D323D4805
FF7E64248755336B1860415B50083845124B142B6A4A495F
32353C5A2A0D381E2B630E52742A1A3B6346515F3C8C493E
493F543D17531A57362B526F8A2F4089646A617F62214126
206A7B0C3F29722532563C532F1C79593A29873C5644972B
17719F19403A6024726565172E281A3F45726F1ECA4A4753
78423A1E2A29B317
E931A7409A244FB74B72750D3B213862332A55101D4A8985
59531E7134516363382F415F492B5437585E096734222A0D
201F3C2F7432584F3B4950254F2C5D7E28591F292C822736
149205502D27324C8841665F6951104334145B29380F6134
3E6423453175B03921683549634723384B226A645A30472C
303721704528555D
CF877CAA379B48A6893F8E55855121513D58942972532D1E
4C3E666326582534103B5C344C865F303F411C1918461630
1B2B3F639B110B602046303829376264255167980C8209AA
48311929190F1F6FAF206141251B28314018911429116311
3A394A3A3C386F2F43270D232E0B23290A2C7E7E1F161566
1E5733970A605F37
78AD3D583A5C451D507B2A445C5E4D256F807529A21C1F42
59115C1469364746460D5125204C9F087611633E2C654655
054B44568B5234562F3B525E5127404AA47C3F688A944F45
4C374C236442055A5F557424452D270E895E55505B364932
0C0937724E22214D342F2F1A5A28226B2884AC731D2B53B2
98257D5F64804D55
7997B34264423B851C685C851B44164156211A413A112D48
372C745C5E6B567F3D6418265D1EB73A88361C2C0F3E404D
167E405DA6062A452F5B1B274E5932063C15513D1558112A
2E423D6D0C5AA04A432C4E411A3F132638646F474E2B4E26
1A253C3F2F703417763A20396B6155513C1F157813509D6C
5F61768F67872E2C
6F76055D2C5122436B717B782A566D806776355238724F24
415054203C6263193D260F343538582F49551A11402C6E3F
33878B6270180938201F4F6E2240186353303C6A671A2B46
6A4794142145644A392D3B277383680B3D0A6E0931663815
2F310D4E622B3C64C83D123636214250B2202136091CB612
58546B784C0B3B36
F6284F4182203B6939245D4C49233518544367572B4D4B4E
606E6549524E78372F330AB33B2A212E652E3B626E3B3E77
6A6E4643647F4A34313569712E5255514E3F572863342848
4E5744083A64192E412D5C611315554352466F232C294032
353A0B1C1F15551F4C4E623E2624520D81630D89375F702F
5B183E456AA97353
FF7B7C560D4F32615759751B2B76093E766A101F893F3086
9A487C4123223C2D4F57397D1A2D47257562404972694A6A
304A1C28462D4C31772D1F6388846C342E274C37383A0C28
2D51211E5D505648C93E718F4D4A4F4D350E676258490A39
2F486A5A3762633B17333D2C55190D42852F1D702D655136
18716E5320A2205E
FF7C56302C3A355646EE5D1A0E1A1539785A274849161E65
216552303D3746273A5B1020132A302675412414413C5D53
4824344C0C640C43B621432861513D7C113C3F2E335C162B
3F455A693D3A5311A65770A37E8C1B375B681F5C7C402A24
333A4C9FA7281372140B133951223C705A2E393D360F2522
5F39A23048554B5C
FE62B73A654871246B4983504343592A1DA83958795F3931
034A6B6D4D1B701F21223517143E645C1A2B5E463A7C4A10
525B407D16573A2B4D655C61422F4F4D463B72453F350A1E
8E106B5A2A24540A583449531E87383F1C3B564A82233818
494B3A247E2A0C473A3437243174618C30454027218B0838
12B85E6731637A7F
FF9E4264820A72731668EC9F3245B9187A7461589E1E5786
6D5C242E351836184537122A12942256055CAE4B5FA9A968
306A56AE493C2902252C3D4B1B4E155D9F2D3031982A4A4F
4E58503C74597D5E3A393B75872761424E094B514F58065A
606839292462601B4B1D6A3D141F5520690A1C6F3E7A4E64
65363D5B42968E2C
EB7E42296923A44557431A7E6E37551DA853246838111234
0F5620622A4062293E2F401635871B570A393E4E0FB6199F
A718812C527A591B5229531C4C652A484F40321D961E1219
423D3E4E9B176A48693D4F2B19464D5CC851629C2A3F69A1
7F042F29290C6E5F313B538E3A3F8F555E8149B4765B5507
53178F6793625212
9A5DAF2220984C4540566E9B0F645E3C332345563B404727
2046215A54474E2925304B12205C5419187459148D18470D
210B571A325512594A4B0B260D5F4B296B29354D4455112C
4F7E1B146977121E185C45131A4E9E5C5A43CA164A1F495C
2F3F3061873E163B214714A71C364A7870945555BD8AD495
5C2A4E102B3B3F6C
8CFF4FBA81341C4B0FC171263A1E6F477A76304F34688334
32114D1A982C28444B5F20622B6CAA4C3F4E67737D674A63
191C2B6F398A1A6D945A56405A156B3C0450510F78494764
3BBC59253D60731A575B28AD503A186D486561375B6E615E
3B98825D48233B6A442F145E0D214C593A6548083734323C
6565302D6348403C
8E588F55911711925C35437B416A122766A1466D36683E6B
9F6E3654994E4C214C3A15894D51422244703742448C741D
6A0C492A6A3F4247C9365D606265954839688979270B2337
39291DA81B2143344A32644553220C235F3B953A74382C1F
526745724559313038283B2F3F46645A354A252A4B3C5E19
4F2C4E62546D9043
6A7F2C73664D531669276A4D34604244522A8A43475D2616
A5715C29381F3716212F2A4F561721522D73411D59429472
37236E3A1C5F1040691C533D39304B20555D1C8242342441
4936504F984E5D5E50732E634644552C56567A5248471E0D
565E3E2B07311C0D6614D0B06F405F5512614C41704A7551
085A55A764594877
9BF68ABB26866D7F3538605B5A0B515D2E1D6AB183545444
1F4B070C51363A6B5E2D1F333F4B24255A14838C9F716056
3D412759596830195085593F59332F45363A21610F4C3DA9
1C5F485D4C2C50093E623D985712317C21B24A571D6E8452
4F6D2364372193586C6C834B5119718C8A59AAB0386A9063
294A066E509E7176
6DC2AE7E6889241F46BE526CAC1D3846365EA1AC348B702B
28143B2E4E3B025192117E705E1A0F2A174679620D562651
656D4E5B0A4636510816661C232436482E473F392B580F91
1B4C280B303272594E1742574B6C4E6B4340841A1C4F4579
32885829665B21427A5068694F9368542EB88D4D5A6F3050
6A421D361C27CD22
FFFF5439804F9E104695173CB86D95485519774D5127131B
141D3B2A3219406E3B5D5C4815275E35455449543C353321
184C5E5E034A0A6C305446341116114E4F2F305B5B572D64
6E342437935D82A66A1E407563502A87291436818A2D6F69
88361F29681D5A5E68638D934B5575265654511C1F0B4C13
4737686B69264F5C
F6FF768A50630B581F4DBE3F326A3E0C383C38233D406F1E
1A3A457E2A398721692271846F713A5C5D1F222917647E6D
577C504D3079135B647F1439182B217222256F0C141F2D7A
5D5F6B3716596A72483B263B2D36384557247A25287B638E
676E560F4C6C488041467C1A1945715D43423D595087864A
62397726506E316C
FFFF1AB4973A0D24574775026B76648B2F26210B503F6934
1A6B30326171754B6240378D646B334923503A2249529430
6D904B0B293C703591172A3C2674133A6F73A0668A896625
47392C282C2C20162D253A503B2725454F0E7F2E49543B10
4E2A1789F2804766622E6C6A5329484B192B2FA34D3C7E7D
AD562635288405B1
FFAF5D6894665B22398D1F767B8052497509477F30475D78
3F44175E153345506A4B4D436E8D3B2F2942691041343E34
635C69BC785B57277A4A50862F1D387C46204A6F16351D47
485670308249273C3A7350830E1A311A335E6E7815361C1D
2E4A3B3D619C7D26615A1B2267579727562930750DA3234C
CF3243172AD97D73
FFC78333D579724E9C7D6A5E7F23326576371A516032A562
789536516073534B8336287F0A355D4C16894149523F5334
283C9067353EBA53263057383C064B781838A63549502158
437C4E5920243A5A306D712D5B072339294A5E21234F1A1D
080C253F4E150F482D2271578344886D5A4D4B7C259F492C
8A58152F635199EB
7FBD750988228F4944BE35F7288393202B34415E42305A57
42782C8819329525135245865E49805334410A1B6B301803
876C7292C5532B3B45620E677687303E380334323F936069
15131E5970313972433893554B19651C29374B5327671B47
411E2F3F3910194332429D37465534688D3648663D742896
BA8F258B3D36477F
FF855E6C626D5D9F4A666E443526332C583C402F25196D52
411959637667556457180D3638669252A151883B9F452623
53271D4B413E2F463D5C60553754594D3F8D696E34220F78
3C280D64436B46484F49635E30652231393649AF0E313013
669020395E80544E157EA1A8604E952B893F26064C335020
3C747C343486F1FF
FF957243964678571F5C8594840C12317348254B14B48546
620C32480B402254528283A6431535604C8460334D286053
393248236331366D2C3DAF7C542B3D19343E3F183172556B
1B5E2C5D2E266C588A1A5055255D330C3E463E3D58755A1D
5B5A92237E91725D546147B723582724FF635672563C5F11
451C7D2F893A3D8C
FF90750C8F7B2850498687808E2D0D383744266C6F2C5309
647674333E316E7250889E61314038531D354159502B301F
2F273C480E26564D682829716690175181926A4F48685789
754B0B5A2C4F1B6B7A372328234B4E422912308E3B8C0866
4A47AF4F7C657C417F7731591D8A235ED71CB71D2F287A4C
0E12654538939918
FFA35A4F52B4667E30FF413A504F1B21482E566445859657
CC284667556E24365C5C3E1A3961461D4E4C05611625404C
501F2E083243582396413E2E357546274258555428193C54
763A41330F7A406827215747401F56261C184CFF34724D28
8B63416423601328786259AF4AC88C597A2ED64E0F1C141B
A07868794E9945F6
FF92CFD54878926742E16C5F3C631208146C55718681067E
25442D893EA51F31AF6F236C6C98316D58312B45431A2942
574578573056448F51536570891B694B3686438574183835
812D8F33218429475F68A4583648504E67371B9F55382E3D
67302274357F2A2F546E3162896A456529537198471E7421
1F0C3F857269398B
C76E52905B0E379C4990B9188B5E2308394E234662273F81
76245DAC339B6B1A6567889058346F69636A9D506B3A2F19
48255532390C587C9B132D397C464C371E3C58B74052274D
1E1766762A5078623E1B3792282F2E315C1A49206F1E1433
25A09034517452204A8750915737385A3F95484D572B7B6C
5C54223D249152A6
ED1D41BB7A308B1C93936470222F47492107744069989D54
9D2D23E0A56F2A509B59395E194A2A69764F79561D1F5427
6C3B8A3557325B317A4F4C45663F294C057A3C656B29301D
38175C1F1328BE5C3F2531236A406C33C374441C2F4A3E2A
4B332B542118152B2E2C26254B629E3926BD7C286218693E
82989A3447956C91
FF5A684990542CB56E3E3C215C3B34AE5068278A25382D1B
69907F2F7355364A594C85231758182E501A44102A684D66
1E403B4E8B7F4333623B240839354C852735A03D355F3624
27479329886E5A4983A4476C2444127B43259F531D34102D
56AF531C768F7B361C64273497C20FAF845A4AC3F75E2188
9B88379F97B057E3
D04799ECBAC147382F72A06F908C6AB02FD439921C080F4E
445D5C6650278430974E43261F35693F57603C463E4D673C
243A1C1797881A4A722D3B36153E244E5159203B5E3D5451
2C3F6E77457D4D42193C7F592732602F3E3E4F7D35685236
4985672347C75F8461DA8D3AC679960E1132342EAD6DC2C0
FF65B16717FF6CE2
46A8FF4FA78D59C07F4984EA2AA01E06A23E24602B0D5574
82787E461B36607069522C37316F38368B2D8D3C354D2E2F
763E6A419C975C0A202C4B1928242322553A59214A503452
2A2D5666489A522422751C39952A0E44242959694D992012
641985911B5B9EA5516F3C82465295503A782B1E325C9284
FF68432BFB40F0C4
F252FF289936EE25EC903C8229F3435A1D3A6A464E96A33E
81B71F0E680E7D8D5A2D30556E652034740E7C0F55727235
4556242921503E191965065D1636483746604F4C5E644F4C
12502E6285992A1463372B836D1F685230104D4887377143
6D8277AE4E3F91CC81757CA91B6A6945697F97B8665F24FF
C880FFA20B2C94FF
FFB0FFFF79A1FF6792976751D947BE466CFC7E754A875A51
1AD1723AE2B46C1A362727434C98583C5230694F2848441B
38EB06586D1B332E3C94427E4A771922955040552D4C6F2E
31762B4F48541F3C83974A7630599E5F495D377C57246A6A
7B592E4F8B9A3FD2D12A834E8C771F295C6F4A92473D4D6B
D28CC69519AA9A58
FFFF59CAAB5EFF639A7D12A84CA656CE7F4548E7459E2664
7BDC922B632A45BD129D48124D2165105D592E465E333E4D
378A2E672A3E663B2865567E4BA1175F5235542954061E5C
3A464C4E45141A1D9ED9632E1A1681213097484DA66D3545
A688402B88346E4DB030A44F45BF2272451AA98E758925B5
3AB4CC894A35B3D7
FF2E5945818B31E28681C3AFA14C4B8A6743AAFF677C4CA7
9026585D2E5D62742D859B35654C61363110775B32437654
3E393849401F2D6280597E7152402A5F6F7D07343A7B5874
2032A13865533E1D94700F276F49561B8C8F6983946C244A
82872E0A6B276A89A83862E23D684F6A0A65565B77AE3572
494962FFB4E7FF94
FFD4FFFEFFB5FFCC3A63D99F349FA5AB7DA237DB442A517C
D575845C47C55E9159729E18656570306D36567D8A473F53
52423E5655217A4D766C821D113D4E641C18072656697076
0A1067313469A3335959100D7638833ABA288A4A2C5A1B25
383739424D50334A9F8A302D6B27314C4FBEE61C88963A6C
363680FF347CFFC9
FFFFC21DDBE354BB77D1BBF09656FFF3A7439DB65961B93C
9959585A5AB641567482715714617C11381B9E4D4B1F7E63
29025B7C289524558859718421674D311C212C9F384F717E
2D3A18402765654A082C242C261AA25EA174B577BD40514E
879243601E3E503A5F77531477347D70BE66C4CBAE379F72
748453BCFA9160DA
FFFFFFD7243F35DB75DDC7F156FF22C058098F797248A070
979D62435AD27020BA48C18C3F0CA131245AE9B51599C255
588A463548866C0E06641A62792A17572986317230706045
0B0644815B773926351B7B344F4562445464756C787A2CAA
A56653B21961146E52A31F275589768314FFC895870E4EA1
AC82FF993BA2FFAE
FFC0FF76FFCCAF58F3C12165F0A87A7A45408E431990B053
E59489AA95124D502D3CD764675755585251E8AC367F8045
3578353A4C3623A2B14E475E79582A1A2527389F67647636
4A3555A13A4F0527557D504E6A22985B2F8B6E4B61502B63
7C9675B9773A3041909450A89C4882A1DF69872441A4A804
32E4B97669FFCEFF
FFFFB4FFFFFFDA6A907DE1FF13A8377C709133373EDA7C6B
CDA18AD0859488450D4960641D70559C4C39E793224E525A
7767333D14353D5292552E8D2E603D359322545C383EBB18
65424D7715684A69907E209E0335B255821642445E8D5F94
5BDD7BEE982859A6A9761E4256816673FF721254FF6151FF
FFFFFD43D4FFFFF3
FFFFE890FF42C4FFB8FF7369878D1C4DA0BBDECFCD901ACA
FEA0A78437AB4E7660735C4438488C859F6A4F539D783724
AD311E332E1B605AA67830673D313D6697444824513D7C1E
480F23869F7173927E6A47967822CC3E4780242D4B466DC2
5A9C91FB6A5321FFB6759E6090144B5DD14E4467EAE57D7F
FFDAFF7BFFFFFFFF
FF8D533BFFFF9DFBFABCFFFFDDC7795B5449C062CFAE3670
FB122A5D6A658E28551EA52C41390C8B7F68177DEA840C26
518F4054661834606648633354032E56763649341A5DAA4A
5127456F7672300E386721284536BA625A7255209F7C7F70
9BB5B49DA640C3FF66F58D62D1FF7D2EFF8659ACFFE235FF
FF6D70FFFFFFFFD9
FFFF99FFFFFF67D52C5585C8F61C56AE8E22FA8E85A91D67
717306B2BD2474282532481F0A1D2781817C685697584158
4F7C5F1B223C4834574B5735242E291F5032423A1E462F66
A375374B2A4064195C6D3B45303B616E9321385B825B5079
7EA955AD7F84728F91DA45849FFF54A646BCC8FFCBF9FF8B
45FFECFF9FFFFFFF
FFFFFFFFFFFFFFFF68FF18F458FF2B9746CFAD8F9070866B
5E613073D089508B32CE45B66F71865D465148961B611646
AE12556B84144E6F7A373F128E233F69A4018A49885159D5
953A3453A03D74A55D8D6D59759D708C363157927667504D
5FF63388AE6B4ED4C3BAFF887FBCFFFF6179BCA397FF77FF
4CFFFFB0FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -71.125 0 ]
[.5 1.0125 71.125 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -132.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Shifted) show
111.000000 13.000000 moveto
(Sample) show
153.000000 13.000000 moveto
(Spectrum) show
201.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFE29C7FDFFFFFFFFFFFFF
DFFFFFDDFFFFFF645288FFAB9871FFFFFFBBFFB390C3A82C
4D9E12CC96ECFF9EFFFFB3FFFF72AD5A9C5AAD72FFFFB3FF
FF9EFFEC96CC129E4D2CA8C390B3FFBBFFFFFF7198ABFF88
5264FFFFFFDDFFFFDFFFFFFFFFFFFFDF7F9CE2FFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF98FF21FDEEAAFF61FF468548FFCB9E2B66D6FF
FE8C6DA8D3D723C5464961676571346E468088A158725A7E
6AB58140BD442D5B73A36F466C4FA116904B61415E431259
86725D419A697A328D270465109D34366221C47CBDA2139C
506C2463A7DBCA78B4BD89F738FF3CCC52A83BFF74AFF3FF
C6B6FFFFFFFFFFFF
FFFFFFFFC5FFB6FF4A4DFFFFADD8EADA58AC57FFA18143BB
8CB7978AA2B63BB16C735E6972703834B35E5333374E3F7B
48254D343B4A5262BC880F52183242395C352D2B49305636
3A5B401E101D5C7A4E5C3E4994504C5E6F794707233D3B35
35297736ADA02F51A34F54DB80BFD4186F92550BCCFD9181
1DFF69FFFFFFB8FF
FFDAFFFFFFFFC5B7FFFF8B9BFF8B7682FF53A1F1F05EAEC0
39FFA363C56F94D67E5A8D7F9E1D5C83606BB6552540463E
42340B72B0326B525E68A65923443B524E583C4920681990
6D811F045C533C9D4E3C215CD86E0D558F80153E303A9325
492289597D4F3639F5691E94AE4BD34042378AD4FFC2FFFF
CEFF5AFFFF434E8F
FFFFFFFFFF91EAFFFF7C96BEFF843055EE2C7E1C73679275
A7FF175868F27D925FAD6C5F351E23A84B20F00A54A0254C
84986C8AA18C0D2A69314B1B8522304E615D522D156F188A
AE644B3C585924258B53354197643C47BA6E712B2B41455C
558E6ECF666C6865BF8626CCFAA6F7B29C352F938E4F34F6
FFFFB007FFC9FFFF
FFE0FFFFD932FFFFFFF33A8FFF5331ACFD728C8A6E572A4B
9BDC2B1373D48BB62F637B7A4B1374317D5AD216189D1B86
9363645B0D9A6221893E8A46492D4849724345562D911D3F
73783D5034711D356F5C262612B4CB223C894D6D1D514E2F
2847ABBC8DB06786D96468D74B501FA45E7737B424FFC47F
6396A7FFFFFF91FF
FFFFF7FF674F72DD423C76A35E229654C5927660E59C594D
76782F3781BF87815A372C2C248C73791F36B231724B5870
690A21345D9E693A4F227F58719C3B21201C205F6B53375F
A0B42423544E206A4C537E6246B1CB6C5133306E4548C741
1D67503172D2B76FB141C09B3C46724A477B798BC76E40E5
EF8FE5FFFF97FFB4
FF9DFFAD3393FF719F96703292C4F5E340895FB6574B258A
4F7A06722FCD5F40C07A1A4C46908B34305F735E623F821F
413B207060646C2A384E75643F7C247C1D630C3965443A4F
241A5E773151587F4E73BD6E4B94B67636158B183483B42E
AF3B67E9206FA47C664BC3728669930852D00AFF37DAF4FD
40E65C6A0BBEFFFF
FFE88E8CFFFB8BC5B442BB3BA4D3C3568FAA647C4B62194D
646628492C7C5567B519336582A3C444C764BC3009493E33
26664A583735135B129F556A28913321143D5F4A3B609653
8B61228D27826F1D0B665C123B267C07480E8563194C5C5C
683064C15B4A6365A432C84D3BA3B133B1F0FF4DACECA5AE
78B555E3F522C0FF
FFD0FF527AF3D65947B37BD77543D9A6426F535F51321A7A
7787062B74643A361A3E2A3F37597C4ADD59A22B6D102B5A
714992683641582217876E6555210E132855592D0A1D9361
75458A2C6B4A4540583734348F7C533064315E644015887B
3DA549D357787551AC795D5D61AE58B78FA69BBF41DE9615
4A86FF7AFFFFFFE4
FF9BFFE4A8FF3F7B184F63B367444764075D436169B98D6E
B3766A1C63232D91823A3B697B6750A8A43A7431632D0A71
981047407B468E3310734C863E2B108962562C35457E6D69
86514128563D4F273C456E4726666605181D4546511BA292
417F665221614D3481AE538571FFB63C6E8D4161BA99B882
93C747818A4F5E29
FFE4CB52728DD180108A2A507C9E9013477516A52D2E7963
E1715D586B313F8DAB462C828E36549E163A6E1313255AD9
97180A28604939202A441226742F3E3649571E944C8B2F7F
232976660D801F7A2E4E44324A5C125B422E493A431C50A4
0CB55339732DB0C39744248140FD3A4578D64D8724D94446
D4A0D565BBD375FF
FF5AC27B5757854DB03924136488536D430F2B5A6C3A7314
CCF253849243274F7A637220597E3560445F996228724799
81371460334E445445094D6F4D5933418E20257148901F99
1D1C5F4370701BD9431D4C3A17506D3732204BB24B443424
241952C5D76A50DC486B726D537F74FF6A699C76A9939755
D19CD7A39EFFFFC5
FFFFAA501EC2FF7AB4FF345F59C0A967635F52600A987E77
7ECF963958A86E7F7C3B6740785657172B596D19687E332F
571F1E9B73761C41233C3F7459574B574032512F23630A64
101751412C36264F3F3A7575541B7E09662D246B764B3F3B
4E94692C502937A3963CAC944B397753176F45CD4D622E7F
FF20ED329232FF41
30DAFD3DFF274E69FF7E9946430F3E7E3658A04A53922E6B
61A1A9552492792873072F80625149391843102B933A0C7E
101D578D367754212D5133534521503E4B2E2F1C2F174B2D
1E0A54A1964F5B4E683B3952383F80228143436024431372
6066412B30357B689A5B4A304D4D4849991F0C861DDA874C
8CAF797F993BEFBB
A5FF4EFF317BA75CFFBFAC899C3F1B4820149F6BCF3D90D7
568F6CCC3925618556246D4E1A71382E4E266635224E8537
2C24675A4895582D285B5140562D0C44695823322A404033
744210919624272E313171463C47365A4D46724E19152165
860C624835776D555A38121D288667A538B44B7CAF51927A
333432E590D9C145
FFF22F91B98F3B6B98881E58FFB92B7D919337A3A93C2374
2A3277976E2352B44D4124212F4496263F78114A277C379B
874633788D4B8633231F3955312E92420B9026443D290850
56293E7E913E312F0B5162612D1D51105628125A131D8252
4A3D295F66418F887019332C1E8D3549728366217A3C2A5A
5CBC2E5F79297483
FF797398622EA1849332641E691F70C7114C866745172B18
371C1A0F2047233D522F3A50341D3F7BBD28733B7D3A460A
395FB0320430600E341E342163792E60295A1A544D51345F
6C29553E4645722D6743391E046F76488265345520574955
9C3E235DACDE2E2F9956A690613F6D1B2C424C1E15637494
941F8B3177B3542A
C6A151972C4538686E6F5F473E5F4389405B3630638B5178
471E615D422284AD2D3513216816571357223F2019A13927
4959784E297C61121C47235436BE51442E3F5C566F38310E
997C580C353852174B1338258042AB5D755B662C53918B61
6A27609343AC451E5E8B33256A532C53380B2B60832ECB98
5887480F437C617B
FF7D417A74735316241B6D0E61968E4F3B55465C83501D5E
37413F6C196322437147322F5690254B51663A402D58B267
63452A8923358E25783339207187428B31526A21916B6855
4A8B3D5E32547C41533F261F4E3A362E585C428A6A7B2678
AC3221A54388223C327F116F9D66447F030D1D6336596AEF
455A89874BB8ECA8
FFE04CBB645E8F6BA6312D3A1149D643656679A72B895A4E
8A47174F40474668883B595F44FF501B152354142A586815
3266397810334234735B41132659525A3E213E7F441F4D31
811E49533B1526204C4B37230F50165D350D5A50442E4968
56392472535F501BD557967E515E4E393C2F13614F4536FF
1C8A68B1535363A6
FF098DA81E2E4C2D2C6360392121AB14C7520D7A12681664
955A7B6C6A45AD4D46760A7A38931E0A36384E50212C2632
786E1851335312437D8956603E53678C8352158F73633714
4F5643412757332E2A1C2C1F40573A54293F563D48579D91
4E717538412E6A8B791D582E755E2048373B1727A393766E
604D3A6A91147B97
FF8131358319632058076D3E53665D61FF1D324A35C94978
505A8B7B8A3192515619606B4E4C2C5A40223149135A511A
935A682C305737561E714779250A4435331C3E2C5876B53E
236C3925712F4D283D5263264C3E5793515B3713529A8E79
4E5D2D410638371E723596A90F4A2D416F3E1B1E95A86E63
2E4486398A4B6E93
FFFFF17D30487085491B5D2F431C1D409E437D614AC09E95
1951656B73230E8A5717323A04B44840432312532B6B5257
5B443F70465F1223337E16204061708A385B66493C495B68
313B2F4B3C460E30431C2942A9308D539A44A2592B3C0222
5A645F7066545C102B4F792A34293D3C5D33423133336C83
5E895A5961696B94
98984B3C36A35758F45F5E434D78474B9C712C42231FAE55
4A56312C21452115375227682F5C4F2A23156727594D8D45
4E64404281522A0B1D64619B39352218245226A4616D2551
4A392855BEA36973721B13416A191830483E992E487D623C
161B90340E7311843F53392230574A1F3A22A37140D35AD0
307252589D3785DB
FFDB9F57624335328C141C750A84445C47738F4581527C20
375A182C5F2A39060C281947241A62411448361666257780
3A51352D305E546E2B652C6F591FA2461E705204313A6520
325FB551405B873F2C3255424F4543791F60603D0C961B3A
774F537A53404C7AA18B84442F2D1A236270312B755D4E4E
B43B3B9BF457A8C9
FF7691C136132759A82A218F1D772E35453B886D792E326D
531E8199663D305523102A2B1F6C7D4F371121241D7E5977
383D303F97295A432C411145087841133A823413466D3860
66155B6A82AB62455650583744186D402A3A4D9855573C55
814352381D522825519E844A0F695E0F7342439480794C6C
1A2E4A5A9C786EB0
FFB30D861C493945B3676B4D42A938341E423B355C716A35
5F664779F58E193E421F2969581A781B5D4F1E144E5D2E1B
450F1210492F1320423B539881669C75684506880E242826
9128783D280B478C683A9F56551940502B4E3A7453814A44
67576D735E2A3C6F332573235024103831826C746D145B2C
5242255088C81EFF
F7632185340E5B2478598A7D525B4550584457343204625F
4E8D3C6B430A6D50837E629A3E3E732A6A55354A36431D4B
5D6C575B1C30666157853F342D2856343960373C2D35187D
60591376334946895E5D7F501D1839335F505064688E6823
6B1F8B2A3E65635239184D562E353A40331031702A4ABF40
25381349459184FF
FF51633E535548106E29410C10144C486B1B5B5361706C7E
51556626662E1E418553843A81972A1B308425495F74462E
6EA2766F972B2D3A6D5A216455682223594812231D3E4749
33650946045D5D4E1327372F405C485F3A3550331E415157
43723F1F2B264106070C120C4759782360488A7CAE480F82
67187E56644C5AFF
7E15DB171B2E062777463096346170AE39505999574A5A77
544311438A0B68742D7150412B1F732E525F3456326B4822
555C70363B1A2C5F168D0B67234235422E443E181D2A8120
1F421D301C504F6A5F5D374C1D465C49243A182654747E0B
935A132E54343F212F2E6C8833AAA16C42522F1DA7624AB9
512C0D747365C0B1
928A76AF53600C4834558E7E34A8AB6179897F194A518B70
6D5F8430375D3862444E896B234E57A7307D1D0D4D98495B
40064F28495A545D2CAA3852245E122E354A2F3451446191
5D0F2A603D643E44465B636F9C837A2F760B37412E492D2B
6A68382A642115641A30535C86BE6229296F3E0B44704B36
2B776D882BB297E9
6E7F576F748A705028705E49833E44640A556B357BB3BE27
5E0D31291B392D6A55121C434D56765B5D32514D4D592C68
43644E4EA5595233473F263C398B265B462E5B21474A4816
63400D5D193C73203F7F89386A1B46713E472E1B5D4B2A2E
2F09232C50115A868A09304C544A91215B47284E4343654B
481046606D803288
8B4193706451631C310C515F53283A49464E5F4245252D2E
2D4B243C6A50306B5937192A7D3F90476D360C28662B7029
3927383427B9131A2840391E2F8E81582C4CA159705B6030
B458275A74296018651477894D3B4C6041372F5069791B3D
5117475C8D512C7289754B6546743B915837186755654A21
4B93072CA5589354
964943475B2A2A6A6439313A3E1253612F664717135B1630
486D342E3B4E8A8A49696069633A656C40780E494EA82E5D
4C247064402764B0466D493883184340123D6B145A3F5466
8D7D2C7D526B14242E4C5D5A8974644A494DA98129452747
4459401A9B114B0F333585634360187165506816362F67C8
104C1E3188B051FF
9367413D250A4E3A6EA3C49CAB48569179794D3321A20945
1238274C896C3F482F534C1E4917CE3D56539E560D0B4F4F
211105756B1F1C7B522F1851464B2C355C1938611F311959
54571754351350162A0F4315A0085B690F1C5162261B4723
2C39475049501B461F233F37494741194039655F0F9B6A4E
46373DA82033BA6A
F00448598D5A971D63225E406B994D856C578C3D3B844333
39458A20363847168D966F3A2B9F6550C35151352734612F
75375F23935A4D33361E19199322333F3D3B40596803543B
4709527E4C2C7905C08811CF214926340C6513913D224225
300D603311522F600F320F1925543C62AF2E45286D8C1B4F
483792367B18588A
FF238C904A505832438B307F1D5E220D73215D1C26204E25
432F786326313C70685B0457616744153C44563E77863842
425C8060743B5E483C3E561F92322B32976A205027432916
111323364AAA4E77306DA1BE44629376136921A21F390D47
30084F23313121686D7F692994506C878E05BB3C2F9EF666
2C67552A6F4C3389
FF7D7C58275F809626162C8B2A26484D30896E6A4D3A0C28
6A543B345C3F47494D1D3E35846F35363C422E940F46542E
5E095D30166E58287A13162B374A7239404E473742555B5A
543336561E703B5D58164D8D2F4B5134296451530A03460D
140B7F2656697551131A3D7A724456B80F2E593E4157915F
6341753348209F56
F851383F5F1ABD22503425252A2C44255F6D391E454C2D27
32861F0D98AC49452C2131437B67186A66351D9F72A0685A
A70B49352A7551443117274D3C263E31056E2D5B69145630
A541165916561F23334D6F2F3C1B2132722F2F32041B2A3E
492269542350364E126E261252452264782F1B172A2465DB
5141312C362A4B7D
FF5F39811E7B71661B26734B42751A318C4220254A3C351D
152E6464395D6A4F244111425E5A640B3147523E5A847A35
C74F535158252B512C1B1A29383B3E1B2923599285723436
643A3C344A2D253D37555449844A434C8F23582E127A3D4E
5F17502C1B30493D6AB15C547C2D066B7F3221790221AC3A
368A043112447C7A
F747868F7140441E4D417D60288D0471950D5416355D415B
581A402A0C2013483C352F2821156A4161394B1226517323
3A3E0F6F440546574D492239603251364E4C525B1F816444
282855766D3848607B714E4167732F337A1D354030B9232B
1C2C6C45533E5463476E69564B3E7C3B5A13331C3E636B32
1C8623376F524824
733F4413457177446D03AA2B19202E36C15D4936273B1A34
CF603D1E594E2049291D294F260B6F0D400A6C8074274428
41405F541F249338743832256A614032536417421C78451F
2233131579717F764536801F3A1D13564B31523742422131
2C05515A4E2C565841304561474145745B8C69522B6D7B6B
7C4A0B63424A0F66
6743229D5A9E6869576F9D4D0C85233238526C546D333329
6A212A77343F3D271B2C5433493E6B55431E192E2B48502A
4951A355116F4650332116620F443C2A340B2665442B1657
30373113B76E307123434A330D2324398633BD1D5F291965
3B815A655E5A7B2632453009424B1E2548320A391591546D
1D8643426B3BA689
8744527E7E617C4281CD6943336B9F9B135C280F49343C1A
304A2C2F556B39111C365B4B53423F51A122371E4B1C7158
625B11485E3A661F582B32869F6A506DAA474D2B415F5C23
2A4A3D5AA35E474B0B49496230386D16680D975529365705
3D434536691B5A09632F321B92226A896C244A504A502E87
59016064534A49BB
BA2B6D56139E285B11701C132A737038151B1C1723291A21
432878383A3A4938350B6C1B1A07802B51313D0634314D34
A0791A0218230F2E588B2C6728A7733A1B565A3A1D3F4835
2F4B2015AA5740251F27114113262C55403648874E236431
103228521E596B49401541625D30886B2F462453805D8A48
8AA863B33EAC989C
EF644F2C45721D3E322C4B284D61641F543E1F4369423460
2630BA6C2F48245D462A551B2C3052132A45114376675757
726029141C6418812639306D38322F4240674B3E4433605C
265D46306827290B2F101D1A2656106E6F463F35384E4125
3264684B2D672A5B5D77944C26175E302A5C321D3E0E786A
55BA5E2B9236AA32
FF24AA2F2F1B3B3D89415252BB196573494A1D272F145D60
68326B3F3320937C20329244554081313357771D385A455B
352D6B2F380E7F66282E4B1F5984576D6A7E3B3486775923
3C571D491E34533753444F8441614847633624237548045F
3423350526514638425852507E1E08440C3A39034D5A3E5B
07592158742E7877
AE1436343D5256765B2D433274275E3F5AA50C442C35239D
276345532A4E630F6F23A73094213823199E494860760261
76493329613778223E222A4753752D79433F6E795628680D
2C643E5B2E074306334C3A5D2B8A79064F562E3C68291728
193C3C2E09575B315442712B81432D413E7069276723953B
1065426B318B555E
334C2F3B3B5332969F5C824E405147642751C3BC19235C76
143D605838428C2F3B40361A3C193975305360781E192D85
416B5E31704F58452017181890222593A6409A1D25694D4C
36505211217D240F432433573F2EC9556382185A6F492F3A
4C4C481B334050431568684D2B513D54604A305E211C8C96
0A214A117F304578
2F43673B302B1D4F686D29B2660B5A56487A75720E168A49
51462B441965533A75080D461E3C288B1F6472682728662D
17512B192E415F137826397C665657675A77122C403F2823
2B513D0407725E28251939474C8157142C5B3CAB9A641906
1D24652D63293A181E665E23492E3C2F2A6E4B07632E1A85
430F33347A5E32B9
632E493A4C567923418E766B254D30507E322C314B2A8518
B628229A46373E711C6737627C265E73624C437E74553B25
13351821084850456E37525346835B74462A344745640F72
582018511E42274E152E192435554C36440E8E67893E2212
646756115F5D334826573A645B4B0F6AAE26541B3C5E4B3C
0C403E7A58122E67
E34E2E654D2A851F57505E163443263B472E3D4D34286D2E
A14517998148394710402F494253671E13536C0125193516
1C164754454F327341166B5341214A69142B4D265868513A
4B6923850918263F42484A22531B0A6169227D326B444568
B35332241A5E2133487B5628412331151E49381B583A89B9
2733734B5116686A
D9332C983856398244193E5B65286643307F9C3E62395758
48103C366C3230273937493030594F16275A441220182F0F
3973121A154A34683B19725138814B4A1D3E681C215E2E2B
753A4272305B44225F4F4E3A5E5413553B2D0C80335D5623
773D3A1D1767532F1B2D1F5E4B66355A1C1B363E32213F73
36226E4B696FA8CF
B34E14893264681F3951A9445575232475502B534933575D
8D382C1823111D231A4B352A811D64651A4B4A3F26341441
4DC5545E1E534A473F4A422C5D756B3F2F151E472B1B3133
5275601168920C284D6C0C244F888D543E0B347C2A4C6D31
90A2333B2123233E1A2023462D3533337446209A55695433
433A2A5B3E34686A
FF40531B477D6640615F7B7A50576F2F354E4D844D591A20
554A59635D261B2D425A31544B5A4A60325B255D49483B1D
66362336221F2F1139152A7E3A374D3B563A132A311B2568
2555241A99AF6835513833761F2D6A41712720220F31532D
42DB442F0E14264437694B2C19496A4E1C60213E5A2C166F
4487788A39165175
D96F6C682C7B3C184C85736F3055585F7F2A3D4E43470850
4B3B1414440C1338611754443C09574F5B2E577E204E5320
2D62413138455C2D3985774B368D433633212B2B635A3822
6D7D4D77C6AF4D2C6921233673868E35254240542D2B4649
4B6D5140421D4171213727304445364F5C0868545052212C
31285B69726FC4B0
FF694390551D202F7E2E255C6854454607738F5F73483776
332622455D08282A162B6C5743401D3852446E1F5060553F
340A7180790C20652E616260717C2B3C211E5C208C28587A
42504A64A23E3F5642171519437B9D1D2B0F557F27443995
4639286F56219A5747284023261C4A24612B4C8083065F3B
75793F432F1D6F52
FF27648D287D2E6B1E4939654815432E561113885F277A3E
74201F814B36337678399C47413B4F4B341B3A10766D3654
174345220B612C553F174583AB244447523A9517263E1137
73676E251F39392C18544F71761A203D4A4234682C2B8F7C
7F3D6A744F415F456E3F1F30122F6B6F28142E1666723F2E
5039A83D193A6F5D
D547D027334F0E6D4E652166514E0E16855954095E272E64
15491746464C5D66910E5F1B4D45733D6F2C4743914C330B
223C4C3A27152E5105490F267F4D7B36413E17211D193F4F
6F8F3F206552204323236D2C17385D5047090A7A246E8034
3158316B373153444A423F271B45786A563C71A05A515526
B52656144F28824C
56B9924562331528512491775618401E477275372461275D
3C20278227487D0F0A36173B267E3A569147592C2B3C0A24
3926750F3711594D201E1A462C4F2A52271F545979263322
1B7C1C4A34463E42071C6C432F28AA655724454F5F3F387B
3B342F934931745A7D290E420A2D2C36443F6CAC5C134326
8F2C2A6F22476C26
B17A4A4C28084D7956597A833B403E09241740295315591C
966B7134634C1D2B766A3D081C7F345A1D6A659A33891137
366746203F23441A4E542A3235455A92281F3A63203D492B
7B45592E4555262F463611452D235C2B333A541A220C66A8
18314A4C1A22512A121C2E232A245E2D413E686432265F64
593A715443603781
42774F79331959743B12866A413C4830061C6A7F45623B51
6B48729122492B5A7E3A25094C786D592B261263334E1949
12A20D1F2B19426E3B774529122D4C89310F433961502F8E
65614510261A2102A14214332D482D2412312814552C544A
2C3433201A3E6B331B462361252A4DA36910351808345177
3E6B8E562B217E54
974D2D232130272D45A45F3834760A3C58875D403011372B
1C0E493D2E1966277F4210500E226B3A3B26274F2B122C52
587046683E2F575A27356823655844452E43534832242253
3D60330B48255F5C4D382A7E3A3315474B251F505E7C102A
231B3D1B1C2D1C152660152049445A62413B3337324B204B
214775687D72307D
1868891E113B29274E802B563153515E9F21605A5B495C17
27251F4F33354642381816774C483452236A3E4E14303F17
274F366A6B2167712B1C8826105E5D281D285D5E1026881C
2B7167216B6A364F27173F30144E3E6A235234484C771618
38424635334F1F2527175C495B5A60219F5E515331562B80
4E27293B111E8968
977D30727D687547214B204B3237333B41625A4449201560
26151C2D1C1B3D1B232A107C5E501F254B4715333A7E2A38
4D5C5F25480B33603D532224324853432E45445865236835
275A572F3E68467058522C122B4F27263B3A6B220E501042
7F2766192E3D490E1C2B371130405D87583C0A7634385FA4
452D273021232D4D
42547E212B568E6B3E7751340818351069A34D2A25612346
1B336B3E1A2033342C4A542C5514283112242D482D331442
A102211A26104561658E2F506139430F31894C2D12294577
3B6E42192B1F0DA21249194E336312262B596D784C09253A
7E5A2B49229172486B513B62457F6A1C0630483C416A8612
3B74591933794F77
B18137604354713A59645F263264683E412D5E242A232E1C
122A51221A4C4A3118A8660C221A543A332B5C232D451136
462F2655452E59457B2B493D20633A1F28925A4535322A54
4E1A44233F20466736371189339A656A1D5A347F1C083D6A
762B1D4C6334716B961C59155329401724093E403B837A59
56794D08284C4A7A
56266C47226F2A2C8F2643135CAC6C3F44362C2D0A420E29
7D5A743149932F343B7B383F5F4F45245765AA282F436C1C
07423E46344A1C7C1B2233267959541F27522A4F2C461A1E
204D5911370F752639240A3C2B2C594791563A7E263B1736
0A0F7D48278227203C5D276124377572471E401856779124
51281533624592B9
D54C82284F145626B52655515AA0713C566A78451B273F42
4A445331376B31583134806E247A0A0947505D38172C6D23
2343205265203F8F6F4F3F191D21173E41367B4D7F260F49
05512E15273A4C3C220B334C9143472C6F3D73454D1B5F0E
91665D4C4646174915642E275E09545985160E4E51662165
4E6D0E4F3327D047
FF5D6F3A193DA839502E3F7266162E14286F6B2F12301F3F
6E455F414F746A3D7F7C8F2B2C6834424A3D201A76714F54
182C39391F256E677337113E2617953A52474424AB834517
3F552C610B2245431754366D76103A1B344B4F3B41479C39
787633364B811F20743E7A275F881311562E431548653949
1E6B2E7D288D6427
FF526F1D2F433F79753B5F0683804C2B61244A1C26234028
47579A21566F283946953944277F550F2B1D9D7B43191517
42563F3EA2644A50427A58288C205C1E213C2B7C71606261
2E65200C7980710A343F5560501F6E4452381D4043576C2B
162A28085D45222633763748735F8F7307464554685C252E
7E2F201D55904369
D9B0C46F72695B28312C2152505468085C4F364544302737
2171411D4240516D4B49462B2D54404225358E8673362321
692C4DAFC6774D7D6D22385A632B2B213336438D364B7785
392D5C45383141622D20534E207E572E5B4F57093C445417
6138130C4414143B4B500847434E3D2A7F5F5855306F7385
4C183C7B2C686C6F
FF755116398A7887446F162C5A3E21601C4E6A49192C4B69
374426140E2F44DB422D53310F22202771416A2D1F763338
513568AF991A24552568251B312A133A563B4D373A7E2A15
39112F1F22362336661D3B48495D255B32604A5A4B54315A
422D1B265D63594A55201A594D844D4E352F6F57507A7B5F
6140667D471B5340
B36A68343E5B2A3A43335469559A2046743333352D462320
1A3E2323213B33A290316D4C2A7C340B3E548D884F240C6C
4D280C92681160755233311B2B471E152F3F6B755D2C424A
3F474A531E5E54C54D411434263F4A4B1A65641D812A354B
1A231D1123182C388D5D573349532B50752423755544A951
391F68643289144E
D9CFA86F694B6E2236733F21323E361B1C5A35664B5E1F2D
1B2F5367171D3A3D7723565D33800C2D3B5513545E3A4E4F
5F22445B3072423A752B2E5E211C683E1D4A4B8138517219
3B68344A151A1273390F2F182012445A27164F5930304937
392730326C363C1048585739623E9C7F30436628655B3E19
4482395638982C33
E36A6816514B733327B9893A581B38491E1531234128567B
4833215E1A243253B36845446B327D2269610A1B53224A48
423F2618098523694B3A516858264D2B14694A2141536B16
4173324F455447161C16351925016C53131E675342492F40
1047394881991745A12E6D28344D3D2E473B264334165E50
571F852A4D652E4E
63672E12587A3E400C3C4B5E3C1B5426AE6A0F4B5B643A57
2648335D5F1156676412223E89678E0E44364C553524192E
154E27421E51182058720F644547342A46745B8346535237
6E4550480821183513253B55747E434C62735E267C623767
1C713E37469A2228B618852A4B312C327E50304D256B768E
412379564C3A492E
2FB9325E7A34330F43851A2E63074B6E2A2F3C2E49235E66
1E183A29632D65241D0619649AAB3C5B2C1457814C473919
25285E7207043D512B23283F402C12775A675756667C3926
78135F412E192B51172D6628276872641F8B283C1E460D08
753A536519442B4651498A160E72757A48565A0B66B2296D
684F1D2B303B6743
337845307F114A210A968C1C215E304A60543D512B4D6868
15435040331B484C4C3A2F496F5A18826355C92E3F573324
430F247D21115250364C4D69251D9A40A693252290181817
2045584F70315E6B41852D191E786053307539193C1A3640
3B2F8C423858603D14765C2319BCC35127644751404E825C
9F9632533B3B2F4C
AE5E558B316B4265103B9523672769703E412D43812B7142
54315B57092E3C3C19281729683C2E564F06798A2B5D3A4C
330643072E5B3E642C0D682856796E3F43792D7553472A22
3E22783761293349766102766048499E192338219430A723
6F0F634E2A534563279D23352C440CA55A3F5E277432432D
5B7656523D343614
FF77782E74582159075B3E5A4D03393A0C44081E7E505258
4238465126053523345F0448752324366347486141844F44
533753341E491D573C23597786343B7E6A6D5784591F4B2E
28667F0E382F6B2D355B455A381D77573331814055449232
207C9320333F6B3268605D142F271D4A49736519BB525241
893D3B1B2F2FAA24
EF32AA36922B5EBA556A780E3E1D325C2A305E17264C9477
5D5B2A672D4B68643225414E38353F466F6E1056261A1D10
2F0B29276830465D265C6033443E4B6740422F32386D3039
268118641C14296072575767764311452A1352302C1B552A
465D24482F6CBA302660344269431F3E541F64614D284B2C
323E1D72452C4F64
BA9C98AC3EB363A88A488A5D805324462F6B88305D624115
40496B591E522832103164234E87483640552C2613411127
1F254057AA15204B2F35483F1D3A5A561B3A73A728672C8B
582E0F2318021A79A0344D3134063D31512B80071A1B6C0B
3538493A3A38782843211A2923171C1B153870732A131C70
115B289E13566D2B
87BB494A5364600159872E504A504A246C896A22921B322F
63095A1B693645433D0557362955970D68166D3830624949
0B4B475EA35A3D4A2A235C5F412B4D47AA6D506A9F86322B
581F663A5E48115B6258711C4B1E3722A1513F42534B5B36
1C11396B552F2C4A301A3C34490F285C139B9F6B334369CD
81427C617E7E5244
6789A63B6B4243861D6D549115390A3248251E4B42093045
32267B5A5E655A813B6519295F1DBD33863924230D334A43
2371306EB71331373057162B4465260B342A3C440F621621
3350466F1155A351492A50482B2E191E43556B3E4933542C
1B273D3F34772A216A2933336D546C52383223850C4D9D6F
5769689E5A9D2243
73660F4A42630B4A7C6B7B6D2B52698C5B74454147614530
4158562C4E5A51052C312142423752314B56131D3A1F8036
45767F7179151333221F45781C421764533240616A253238
743893241F545F404128442774806C0A400D6F0B264F291D
2949204E591E3D60CF341A3B2736495DC1362E20192BAA03
6D4477714513443F
F72448526F3723861C326B633E1C33135A3B7C3E4B56696E
4763543E53456C2C1C2B23B93040351D7A332F7367414E71
7B6048386D765528284464811F5B524C4E36513260392249
4D574605446F0F3E3A23735126124B3961416A1521282F35
3C4813200C2A401A585B415D3516540D9571048D28607D41
4D1E4440718F8647
FF7A7C441231048A363AAC21027921327F6B062D7C545CB1
6A3D49301B2C50175F4E3D7A122E58238F4C434A84495455
373D252D4A343C3A6436347285925923291B3E3B38291A1B
2C512B255851534FC7357A845A3E5247310B645A5E421141
244F6A5D3964642E151D353C4A2520428C311A75424B7326
1B66717B1E81395F
F87D4B2A362C314151DB65242A171B2F786422455212266E
124E365023546922493E2A1B04322F2F7232211B3C2F6F4D
33231F5616591641A5305614695B2D6E05313E263C4D2717
314451752A35490BA75A68A0729F1D35666A18677B433121
2C4549AC980D1F8632272D4C451E396D5F25442C2A252534
5022BD1A5F3F3851
FF569F2048337541635F9157413E592E0FB85644727A3D1A
1351756956267F0B140D46030A5351642934514B2F8D4D16
585D3B701E563633545A5B554237474E4039724A372B1613
7A28586E16305D095E2E54460F942E423C36356F84353E1D
4D49473F5C343B546A280C3A4D6A6E89304D48262A8B2C16
2696805F27587C7D
FF89334C6F2A55672C66F69E2F3CBB058E876C509429697F
6D68213131234F0830470D391FA221691376936244BEA16D
30774EAA4A362313111629432750206A97322B32921F563E
3C485E3B7460805C42423886773E56443C1544676157045B
68703C312663782F43254E20261C5D21730D225E1D7F308B
433258504A908C23
F08A58187B369237484F1B8C6D28452EAF623C5425190F32
0F602F521133600D302542223D9113650C34264921CF1188
C005792C4C7E5209473B54036859403B3D3F33229319191E
36334D5A93235F37752F613427355151C350659F2B3A6F96
8D16473836208A45393343843B3D8C576C854D996B405E22
631D975A8D594804
936ABA3320A83D37464E6A9B0F5F65394019414749373F23
1F461B50495047392C23471B2662511C0F695B08A015430F
2A16501335541757545919311F6138195C352C4B4651182F
527B1C1F6B750511214F4F0B0D569E53563DCE17491E4C53
2F483F6C894C2738124509A221334D7979915648AB9CC4A3
6E3A4E0A253D4167
96FF51B088311E4C10C8672F361668506571186043638535
330F4B119B1A4059444727452981A94D494A6474895A5D4C
2E24146B527D2C7D8D66543F5A146B3D124043188338496D
46B06427406470244C5D2EA84E490E78406C653A63696069
498A8A4E3B2E346D4830165B131747662F6153123E3A3139
646A2A2A5B474349
8B549358A52C07934B214A655567183758913B7446654B75
89722C518D5C4717513D1B7969502F3741604C3B4D897714
65186029745A2758B430605B7059A14C2C58818E2F1E3940
281A13B9273438273929702B66280C366D47903F7D2A1937
596B30506A3C244B2D2E2D2545425F4E46493A28535F510C
311C635164709341
6E8832806D604610484B6543434E28475B21914A544C3009
8A865A11502C23092F2E2A4B5D1B2E473E71461B6A38897F
3F20733C195D0D406316484A47215B2E465B268B393C263F
47335259A54E4E6443682C594D4D51325D5B76564D431C12
556A2D391B29310D5E27BEB37B356B550A64443E83495E70
2850708A746F577F
92E997B22B886D772B364B70440B3E6F292962BE865C5330
1A641521642A38686A2B2D492E41370B762F7A839C6F635B
46443E643D602A0F5D91614451342F4A352E125E245238AA
2C5D545A49284F06405B49984D0D1D7D30A7574E236B894E
4462385D3730845F6D708B514A197F897961ABA8347E8E55
34480C6053AF768A
7EB1C06573740D2C51B94A62A71D2F52426CA1AA33886C2E
2F213F34542E135A930B7E745426183A24495C461D4C375D
5F6A4F501C301D421F20812A1D183E442E42354223670B8D
165F2C1A3B36705C5522486B3256345F522E731F2B415071
2D74680B8A43114354775A4A5799595039AE706134963046
7727062E1B17DB15
FFFF5A4C64567E1867820F48AE7C8A4860237859470C120C
070641262B1F3F72435751411E3350353A5F485C402F3727
134E5D5D044609653349473E1D231248592322685564215A
6D3A2D2B976F76A26E2E46745F492584301B2A97813A8453
85411E2E66266655517E6C7061535B1B6B484C14100C4129
6E104855533E6351
F7FF8491454913382540BF4A2A70311033403A352E564D18
395263653E2A8B1F6B23688E686450505F3339181D507F5D
5E89464933761359607D18352D3C3760393456282D343F85
576166301C5B576C5D4B1D43364A35556A2A733E3E9A627E
83506D0A436B3C8D4E5F6204323457445850455B527D8A59
78245B0E34852163
FFFF1EC888502542522C5B146D746C823138102450237325
336F3C2A5E736D5767444A8153743A4E2B50401955569F3A
688C470B283D7828912628240E88064568759C668198533B
4220132F4910120F451B2E5D4E141E4F5D1B781A5869291F
423E198EF57947665F356A715C353B421E3438A9424D6B67
B34539491C860DB3
FFB06E789C5A4A2E1A6C4C7980944342730F5E690F4A849E
512528521D38524381553C5755984D3A2A406D1844375850
564562AB826A5B156660386D461334823A13417808451141
2C435A29973F303D3877597E1D242111374F7D6C1F2B2A10
2355303D6699811E536D322E796D883B45352E771D8F212A
A859271336C19176
FFC9A857F49B3B3BB44E4E5D752B317062231A2D2F44848B
A17A4C40537A534F773A1B960C3D60601F7943454F425532
2C3F875B4051B55F3220653A310452701E46A21F596F2C65
2B6E545E302D35513A807725661636481441621A24471928
0C06392A5F2C185A37207C5281458F73475C44840A751C14
8C32354362579FDB
98DB85379D58527230D05AD34071A3223A1F4A5730223953
3F8411730E34901B163C627D482E993E483018196A41131B
727369A3BE5528394A51256D61A4265224182235399B6164
1D0B2A52814240644E458D4D59276715232A4F5C2F682752
37152145212C31564A55AE1F23422C719C4B47784D435E5F
F45857A3363C4B98
FF946B6961595A895E836C33333142335D3C3D29342A794F
2B105C5466705F645A22023C2B59A2449A538D30A942291C
43300E463C4B2F3B31685B493C49665B388A70614020167E
3323125F46703F445B57526B2B531223434048B4043A3217
578A0E23736B655119959EC04A617D439E401D1C432F5D1B
49857048307DF1FF
FF936E4B8A3986442E636EA8951E1B3E6F412D4A0FA99635
721E373806412D5D4E798E9A5213375B5193573E4C266352
3D284D2F7125396C233EB576582C3E1C3335440A25794771
1E563757302C685A931A515A13493122405A2C4C4E6B6019
565192318A7B8B5A507849C9354A321DFF615D66533E6D07
5820631983353181
FF977B14916A3A4D606E7693A327173B3748205E752E581D
798B6A2E413875714E919D57483D563F29543A57401F2C1C
2A2E3357274143564F143763738F1552838C67533E605689
7D4312533351186E7832262C21504E38360A1E93387A0A76
464DAD456A6C7B5A95641668127A0D52C714AB2121396063
2C2D4C2E1EA88D09
FFA6635353B1688A1CFF36454F61132F3C394E5E517E9657
D51B505F537224395668492E44505A0D355D16500F23374B
4C2026153B53491E81314D1F447F3E213E5A52592613415B
7334423310783966321568582A145423151B50FF445F593B
88684647404F17478A4E5A892BA779666543D649113A2D31
A66B8F5E64BB4CE0
FFA8ECB84B87895A45EF6A5936631D0D037F44669D6F117F
323C228843A52132AC78267B6A8A425C582E363A4E1F263F
53417C54325E3D8B4A55686B91216A52318B428771203933
78258E3523892A456367B2582D403A66514B2590562F3247
71432263196C3F41375E1D50835C46553B4F8E96610E6D1B
24165373747A417D
C67B617C430F48875898CB2E83602B0B38532C536A25338B
5E1E45AC439360276A618B91532C665B755DAB4280253813
4B175238350C587C990E31386F565C3F2E4451BE36542347
1C12617C294E7859492739A119203F225713571668211335
2DAD8422425D611E4778518B6330365B4089435F3E475F6F
6E6838452C9751A1
FF2A54B377318B1F94947463151E4C422C1B6D3F6190A656
992F2EDEAC5D233E9C554957205534658248766F041E3943
672D7245463E55296C5F34514D541A5A29602E796321341E
340E60300432B05F390A463A7D3B7328BD7B3F1D34503A2F
523D2347200F1A1C37182B174567864C11C7701F691E6432
9384A12E62987379
FF837429795F2EBC5C5A2A3C7A2166837249358D1E2C3319
70888F41665F293D4A52821D135A12285610511D2D616251
0B2F313E917E3E29565008293D4426900B42922E3155391F
2333864B8D783346879B377C274A11783F2696442F212441
4DB452236E9777322A74233CA9A33793917D2BB9FF581E88
986B3B8FB9912FF2
A545C1D990E53234337A9251AF7C4BB438A56786281D1238
5A556D773548620C86652115194E72464D5A36473C467131
312E272496911042743340402A32235869440C2D5640515B
282D5895485A67242C37854E223566264E2E38711A4E6D24
5685612539CC6C8F56D7903DCF6B9F1420481B3F9C89ACBF
FF5CA77B31FF4EFF
30BBEF3B997F79AF8C4C87DA1D860C1F9949484D4D304A5B
9A687B35302B416660721343246043438122803F3852393B
684E5B4F96A1540A1E2D4B172F1C2F2E4B3E502145533351
2D215477368D571D107E0C3A932B10431839495162802F07
732879922455A9A1616B2E92534AA058367E3E0F4346997E
FF694E27FF3DFDDA
FF41FF329232ED20FF7F2E624DCD456F175377394B94AC3C
96A33729502C69944E3B3F4B766B242D66097E1B5475753A
3F4F26362C41511710640A63232F513240574B5759743F3C
23411C76739B1E1F572F337E68196D592B1757567840673B
7C7F6EA8583996CF7E777E980A60525F6367A9C0595F34FF
B47AFFC21E50AAFF
FFC5FFFF9EA3D79CD1559793A9769C696AFF747F536D726B
48DC506AD7C55219242434444BB24B2032376D50173A4C1D
43D91B7070435F1C1D991F90487125208E4133594D6F4D09
4554444E33601437819947722862995F4460357E59207263
7A4F2743928453F2CC14733A6C5A2B0F436D538864132439
B04D8557577BC25A
FFFF75D3BB65D5A0D44644D924874DD678453AFD40812444
97C3B02D733953B50CA4501C433A492E425B125C4A32444E
2E7A1F800D667629237F2F8B4C941E5749363E2F74261244
2A20394960280A1897D95A2513136E3A169E54368E822C46
AB8D3F316B585D71E163792E2DA516754713909E7C502A8A
1080D18D7252CBE4
FF295E4F8A8147C79382B899BA61418D6E3CB6FF718553AE
81344D612152667F4192A21B5146451D1805666626476E45
3C274F3D5628415186696D7E45352C566289102B3E864C73
10338E467B40471098710A2D6331743AA4A850677B693B3A
82912D23631C6A76B36E8DB96961435D0764474467B3634F
187B3FFFA8E4FF9B
FFE4FFFFFF7AFF864A1596DE41BF9BA68FB758AE615D5D79
AC51757857D349A53D7B881540645E316430537C8F343437
5840454A6B2C8A457561931D0A2D595528130E2155656E87
1722584136689249715A2B106D2BA259DD4A7C59373F2A3E
1A363A64742B0687777A1A32515F536F42A6D94375D77BB3
4759D6F37A52FFD0
FFFFC022F5E355B578AEA5ECAC4DFFF0B133B1A33B4DC832
A465634A5BC16430685C5C4C1963850E48077C263B125C66
0B1D6F82278D22618B5396603B4A5F3D14213391286A559F
125B133537584A6626333E490930BC64C744C4A382653319
B567557C2C492866644D19624B7C64AA8F56C3D3A43BBB42
B4C58BFBFF8C8EE8
FFFFFFBE0B6A5CE640FDF4DA37FF0AD0520893698672C34B
667CA46F20E9673BAF2EB48334188B153676B6944B6EBD73
4E7F585131775E1A244F3A4465390C631D7C247C3F64754E
382A6C646070203B411F823F625E735F30348B90464C1A7A
C0405FCD2F72067A4F8A254B57B65F8940E3F5C492327096
9F71FF9333ADFF9D
FFB4FF97FFFFE58FEFE5406EC78B797B474A72463C9BC041
B16FB7D2723150671D41C748456E3033516CCBB146627E53
4C6A204E542324B4A05F37536B5F201C20213B9C71587F22
4F3A699E5D34210A6970584B7231B2361F79738C242C2C37
5A8187BF81372F78764D599CE5607692C55496225EA3763C
42DD724F67FFF7FF
FFFF91FFFFFFA796637FC4FF24B437775EA41F504BD76864
D98667B08DBCAB47282F4E511D6D4D893C22CBB41226265C
6F351D7134503D78733F1D912D5645437249482D49468A3E
8921629A0D5B646393861B9D1816D25A7D3174134B7A7B63
2FB68BD473132BDC9B4B2A576E8A8C72FDAC3153FF8F3AF3
FFFFFF32D9FFFFE0
FFFFFFC9FF07B0FFFFF6344F8E932F359CB2F7A6FACC2686
BF65686C66CF6E8E555C45412B2B716EBA473C6497413553
8B252459583C4B64AE8A186F152D525D614E3022851B4B31
692A0D8CA18A6C98844C25A0540AF0204BA8231E355F6CAD
5F927DF2685817FFA7759267731C7E2CEE553084FFBE967C
FFFFEA91FFFFFFFF
FF8F4E43FFFF5AFFCEFFFFC2FFD48A374240D34BAE941E69
F539364F7D5989224925933A303E15808F550D6ED85C213C
4E9D3C535C041F816D90196820493C584E523B442359A668
5E526B32B0720B34423E46402555B66B60835C1D9E7F8D5A
7ED6946FC563A3FF39C0AE5EF0F1A153FF82768BFF9B8BFF
FFB7C5FFFFFFFFDA
FFFFB8FFFFFF69FF1D8191FDCC0B55926F18D4BF80DB544F
A3512FA0AD36772935353B3D230747796F5E4C5094493E5C
4E7A5C1D101E405B3A365630492B2D355C39423218520F88
BC62524A3B344D25487B3F4E3733535EB334387072695E73
6CB13BB6A28A97B78CBB4381A1FF57AC58DAEAD8ADFFFF4D
4AFFB6FFC5FFFFFF
FFFFFFFFFFFFFFB6C6FFF3AF74FF3BA852CC3CFF38F789BD
B478CADBA763246C509C13A2BD7CC4216236349D10650427
8D327A699A415D72865912435E41614B9016A14F6C466FA3
735B2D44BD4081B56A7E5A7258A18880466E347165676149
46C523D7D3A86D8CFEFFD6662B9ECBFF488546FF61FFAAEE
FD21FF98FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{457, 217.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000790000fAP00`40o`000?l0003ooooool[oool0
0?ooooo:oooo003ooooob_ooo`00oooool[oool00?ooooo:oooo003ooooob_ooo`009Oooo`030000
oooooooo01Goool300000oooo`030000oooooooo01?oool300000_ooo`030000oooooooo01;oool2
00001?ooo`030000oooooooo01?oool00`000?ooooooo`02oooo00<0003oooooool03_ooo`D00002
oooo00<0003oooooool00_ooo`030000oooooooo00coool5000000Coool0000000000003oooo00<0
003oooooool0>Oooo`030000oooooooo01Goool300000oooo`030000oooooooo01?oool300000_oo
o`030000oooooooo01;oool200001?ooo`030000oooooooo01?oool00`000?ooooooo`02oooo00<0
003oooooool03_ooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo00coool5000000Co
ool0000000000003oooo00<0003oooooool05oooo`009?ooo`030000oooo000001Koool00`000?oo
ooooo`02oooo00<0003oool000005Oooo`060000oooooooo0000oooo00004oooo`030000oooo0000
00;oool00`000?ooo`00000Coooo00<0003oool000000_ooo`030000oooo0000017oool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000003oooo`050000oooooooooooo000000Coool0
0`000?ooo`00000ioooo00<0003oool000005_ooo`030000oooooooo00;oool00`000?ooo`00000E
oooo00H0003oooooool0003oool0000Coooo00<0003oool000000_ooo`030000oooo000001?oool0
0`000?ooo`000002oooo00<0003oool000004Oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`00000?oooo00D0003oooooooooool000001?ooo`030000oooo000001Soool002Coool0
0`000?ooo`00000Goooo00L0003oooooooooool0003oool000004oooo`@000001?ooo`000?ooo`00
01?oool00`000?ooo`000002oooo00<0003oool000004oooo`030000oooo000000;oool00`000?oo
o`00000Aoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000ooool00`000?oo
ooooo`02oooo00L0003oooooooooool0003oool00000>Oooo`030000oooo000001Ooool01`000?oo
ooooooooo`000?ooo`00000Coooo10000004oooo0000oooo00004oooo`030000oooo000000;oool0
0`000?ooo`00000Coooo00<0003oool000000_ooo`030000oooo0000017oool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000003oooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`00000Hoooo000Toooo00<0003oool000005oooo`070000oooooooooooo0000oooo0000
01?oool00`000?ooo`000002oooo00<0003oool000004oooo`800003oooo00<0003oool000005?oo
o`070000oooooooooooo0000oooo0000017oool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000003oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000ioooo00<0
003oool000005oooo`070000oooooooooooo0000oooo000001?oool00`000?ooo`000002oooo00<0
003oool000004oooo`800003oooo00<0003oool000005?ooo`070000oooooooooooo0000oooo0000
017oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000003oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Hoooo000Toooo00<0003oool000005_ooo`030000
oooo000000;oool00`000?ooo`00000Doooo0P0000;oool00`000?ooo`00000Coooo00<0003ooooo
ool00_ooo`030000oooo000001?oool00`000?ooo`000002oooo00<0003oool000004Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000?oooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000003Woool00`000?ooo`00000Foooo00<0003oool000000_ooo`030000
oooo000001Coool200000_ooo`030000oooo000001?oool00`000?ooooooo`02oooo00<0003oool0
00004oooo`030000oooo000000;oool00`000?ooo`00000Aoooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000000ooool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006?ooo`009Oooo`030000oooooooo01Koool00`000?ooooooo`02oooo00<0003oooooool05?oo
o`050000oooooooooooo000001Goool200000oooo`030000oooooooo01?oool00`000?ooooooo`02
oooo00<0003oooooool03oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo00goool2
00001?ooo`030000oooooooo00;oool00`000?ooooooo`0ioooo00<0003oooooool05_ooo`030000
oooooooo00;oool00`000?ooooooo`0Doooo00D0003oooooooooool000005Oooo`800003oooo00<0
003oooooool04oooo`030000oooooooo00;oool00`000?ooooooo`0?oooo0P0000Coool00`000?oo
ooooo`02oooo00<0003oooooool03Oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
01Ooool00?ooooo:oooo003ooooob_ooo`00oooool[oool00?ooooo:oooo000Roooo]@0002kooone
00003oooo`008_ooo`050000oooooooooooo000000Goool00`000?ooooooo`04oooo00<0003ooooo
ool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo0P0002koool010000?ooooooo`0000Koool00`000?ooooooo`04oooo00<0
003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo0P0000ooool001goool00`000?ooooooo`02oooo00<0003ooooo
ool0/Oooo`030000oooooooo02Ooool00`000?ooooooo`02oooo00<0003oooooool0/Oooo`030000
oooooooo00goool001coool00`000?ooo`000003oooo00<0003oooooool0/Oooo`030000oooooooo
02Koool00`000?ooo`000003oooo00<0003oooooool0/Oooo`030000oooooooo00goool001coool0
0`000?ooo`000003oooo0P000;7oool20000:?ooo`030000oooo000000?oool20000/Oooo`80000?
oooo000Loooo00<0003oool000000oooo`030000oooooooo01Coool01McLg79bLW9bLWalO?ooo`02
GEeM3oooo`06I6AT>3PhOgmoOgmohN7Qb/[:0YJFUP04WIfMNg]ki^KVi^KV0_ooo`:j^[X01Oooohn?
Sg9bLW9bLZBTY002I6AT00I_KfmiNGVOWinOWim?Cdm_Kfl2S8b<00?ooomYJFWoool00_ooo`05jn_[
ooooooooTY:BJVYZ00:YZJT01KVi^F5QHF5QHLG5aF5QH@02^KVi00JYZJUZJVZBTY:BTY;oooo[jn/3
oooo00EYJFWooooooon<S8a_Kfl00Tm?C`05WinONGUiKfm_Kfm_I6AT00:TY:@01G9bLXn?Sooooooo
okZj^P03oooo00KVi^IkNg^MWIfMWIfFUYK:b/X2hN7Q00AoOglh>3QTI6ATI6@?oooo00IMGEgoooml
O7alO7abLW;Lg=`Eoooo00<0003oooooool09_ooo`030000oooo000000?oool00`000?ooooooo`0C
oooo00GRh^:LW9bLW9aoOgoOgml02Oooo`05gmoOoooooooooooogMgM00Coool2I6AT00IBDU:8R8So
oooooon[Zj^HV9P2LG5a1?ooo`05^k^koooo/k>c/k>cT92@00;3`l<01ZRXZ2`/;4e=CDe=CIjNWQ8B
4P;<c<`01IJFU^c/k?oooooooijNWP03oooo00Fc/k?ooooooooooombLW800Zf][@06FUYJW9bLFUYJ
FUYJ[Jf]LW9b0oooo`:c/k<2oooo0YjNWP06ooook>c/UYJFUYJFc<c<4Q8B0YjNWP05CDe=;2`/Z:RX
Z:RX`l?300:@T9001;>c/ooook^k^k^k^`Coool01G5aLIRHV:^[Zj^[Zoooo`02R8R800=BDU9TI6Co
ool00oooo`;MgMd2oooo0]oOg`Soool01MoOggmoOgmoOibLW>;RhP0Eoooo00<0003oooooool03Ooo
o`007?ooo`030000oooo000000?oool00`000?ooooooo`08oooo00F`/;3ooooooooooom<C4`00_oo
o`06MgMgooooUiNGUiNGXj>S_;bl0WUiN@06HF5Qoooooooooooo_;blOgmo0XR8R006oooo^[Zj`l?3
`l?3e=CDCTi>0V][J`05[Zj^R8R8R8R8<c<cm_Kf009OGel01Te=CE1@D6MWIfMWIgIfMY:BTP9GEeL0
1S4a<CHf=Xb<S8b<S71`L9fMW@9eMGD01EUIFFe]KFe]KHf=SEeMG@02YJFU00IdM7@m?CfPX:2PX:1C
De<d=3@2>SXj00JEUIGEeMEIFEUIFEUADE68R8P2BDU900F:RXX10@410@6TY:AYJFT00Slo?`068b<S
SXj>4Q8B4Q8B?clo=cLg0WYjNP06Kfm_CTi>51@D51@DQ8B4Jf][0UEEE@054Q8B[Zj^ATI6ATI65QHF
009QHF401Q/K6iJFUTQ8B4Q8B55ADDI6AP9MGEd01XJ6QW5aLFm_Kfm_KkJf]TE5A@;>c/h01C8b<X^;
Re1@D51@D8V9R@02d=3@00IcLg<`<31QHF5QHF5NGUi[Jf/2QXJ600I`L72@T92?Shn?Shn][Jg?cll2
ATI600JGUiL[:b_ooooooomHF5Sdm?@261PH00?ooomXJ6QXJ6P03?ooo`030000oooooooo02Koool0
0`000?ooo`000003oooo00<0003oooooool01oooo`05V9RHoooooooo8B4QoOgm00;^k^h01ZZZZ_oo
of5QHF5QHOooodI6AP:5QHD01DQ8B?oool_;bl_;bijNWP02:b/[00IVIVKFe]Koooooooono_j<S8`2
KFe]00FXZ:SCdm?GemOGemLS8b<00/G5a@06ATI6BDU9HF5QHF5QIfMWIFEU0W5aL@06=3@dKVi^ATI6
ATI6P820R8R80Z6QX@05F5QHLW9bLW9bFUYJOWin009ZJVX01[Fe]H61PD10@410@;fm_DA4A08];Bd0
1E]KFg=cLj>SXj>SXfm_K`02ATI600I/K6a?CdnQXJ6QXJ4F5QJ@T902Bd];00EQHF51@D5NGUiNGUi3
@d<00Q8B4P06FEUIQXJ6LW9bLW9bGEeM@D510YZJVP06JFUYNWYj<S8b<S8bSHf=9bLW0P@41005IFEU
410@410@WIfM=3@d008f=SH01V9RHR4Q8LC4a<C4a7alO;fm_@:RXZ801A<C4ibLW9bLW51@D6a/K002
92@T00ISHf>WYjOKfm_Kfm_:b/YhN7P2];Bd00Fm_Kf9RHWgmoOgmoLh>3P00_ooo`06?3`lc<c<DU9B
DU9BZ:RX>c/k0_ooo`06M7Ad[jn_lo?clo?cooooa/K60[Jf]P_oool00`000?ooooooo`0=oooo000M
oooo00<0003oooooool00_ooo`030000oooooooo00Soool01K2`/?oooooooooooda<C002oooo00Ig
MgOooonGUiNGUiNSXj>l_;`2NGUi00IQHF7ooooooooooonl_;aoOgl2R8R800Kooonj^[[3`l?3`l?D
e=A>CTh2Jf][00F^[Zj8R8R8R8Pc<c?fm_H00UmOG`06CDe=D51@IfMWIfMWMWIfTY:B0UMGE`06<C4a
=SHfS8b<S8b<L71`WIfM0WEeM@05FEUIKFe]KFe]SHf=GEeM00:UYJD01WAdM3dm?J2PX:2PX5=CDc@d
=08j>SX01YFEUMGEeEUIFEUIFE5ADHR8R099BDT01HZ:RP410@410JBTY6UYJ@02?clo00HS8b>>SXhB
4Q8B4Q8o?clg=cL2NWYj00I_Kfm>CThD51@D51B4Q8A[Jf/2EEEE00DB4Q:^[Zi6ATI6ATHF5QH00V5Q
H@066a/KUYJFB4Q8B4Q8DE5AATI60UeMG@06QXJ6LG5aKfm_Kfm_][JfADE50/k>cP05<S8bRh^;D51@
D51@RHV900;@d=001W=cLc0`<65QHF5QHEiNGV][J`:6QXH01W1`L92@T8n?Shn?Sjf][Lo?c`96ATH0
1YNGUb/[:ooooooooeQHF?Cdm08H61P00oooofQXJ6QXJ00<oooo00<0003oooooool09oooo`030000
oooooooo00;oool00`000?ooooooo`07oooo00FHV9SooooooolQ8B7moOd00^k^kP06ZZZZooooHF5Q
HF5QooooATI60XF5Q@05B4Q8oooobl_;bl_;WYjN008[:b/01VIVI]KFe_ooooooooknoXb<S09]KFd0
1JRXZ=?CdmOGemOGeb<S8`02aLG500I6ATI9BDUQHF5QHF5WIfMUIFD2LG5a00Hd=3A^KVi6ATI6ATJ0
P828R8P2XJ6Q00EHF5QbLW9bLW9JFUYnOWh00VYZJP06]KFePH61@410@410_KfmA4A40Rd];@05Fe]K
Lg=cXj>SXj>SKfm_0096ATH01Va/K4m?Cj6QXJ6QXAHF5Y2@T09;Bd/01F5QHD51@EiNGUiNGT=3@`02
4Q8B00IIFEV6QXIbLW9bLW9MGEe1@D42VYZJ00IYJFUjNWXb<S8b<S:=SHdW9bL210@400EUIFD@410@
412MWIdd=3@00SHf=P06HV9R8B4Qa<C4a<C4O7al_Kfm0Z:RXP054a<CW9bLW9bLD51@K6a/008T92@0
1V=SHjNWYm_Kfm_Kfl[:bWQhN0:d];@01Kfm_HV9ROOgmoOgmcPh>002oooo00Hl?3c<c<aBDU9BDU:X
Z:Pk>c/2oooo00IdM7B_[joclo?clo?oooo6a/H2][Jf2oooo`030000oooooooo00goool002;oool0
0`000?ooooooo`06oooo0YnOW`05ooook>c/ooooooooADE500:;Rh/01_ooooWinL_;bl_;boooolS8
b0:l_;`01TI6AZJVYUADE5ADE?oooinOW`:4Q8@01TE5AM[JfY6ATI6ATHn?Sg9bLP:4Q8@01GmoOjf]
[Jf][EEEEJVYZ@02OWin00IiNGU@D51KFe]KFe^2PX9KFe/2>3Ph00HQ8B6CTi=^KVi^KViQHF4k>c/2
<30`00E5ADDk>c/k>c]]KFeLG5`00QTI6@06I6AT@410:RXZ:RXZBd];=cLg0WEeM@06Xj>SIVIV;bl_
;bl_ATI67QhN0SXj>P05@T92<S8b<S8bD51@7alO008Y:BT01Rh^;R@T93De=CDe=EMGEd];B`9GEeL0
1S@d=4Q8B3`l?3`l?28R8Q/K6`9OGel01GalO4m?CeQHF5QHF451@@02F5QH00FGUiMFEUIXJ6QXJ6Ql
O7`00h61P@069bLW7AdM2PX:2PX:7alOB4Q80S8b<P059BDU:2PXM7AdM7Ad92@T00:m_Kd01[:b/PH6
1W=cLg=cLg5aLFMWI`8M7Ad01ZVYZHF5QHj>SXj>S_[jnR8R8P:>SXh01Zj^[UIFEQ`L71`L7?Kfm/S8
b0:5QHD01EEEEB`/;2`/;=GEeFMWI`04oooo0YVIV@Coool00`000?ooooooo`0/oooo00<0003ooooo
ool01Oooo`;5aLD01OoookJf][Jf]_ooodY:BP02CDe=0_ooo`:][Jd01]SHf>[Zj][Jf][JfUQHF:b/
[09GEeL01Ooooj6QXJ6QXH61PD=3@`02^k^k00J<S8bg]kNGUiNGUiN:RXZRXZ82][Jf00Dk>c^a/K6a
/K5/K6acLg<00UiNGP06JFUYLW9bL71`L71`>3Ph=3@d0[>c/`05GUiNDe=C<c<c<c<c=cLg009>CTh0
1Slo?g]kNdQ8B4Q8B2DU9De=C@8d=3@01S/k>dY:BU9BDU9BDV9RH[bl_0:8R8P01@l?3e9BDU9BDQPH
638b<P02@T9200Hi>CULG5`e=CDe=CD];Bd[:b/2BDU900D`<31FEUIFEUHf=SHj>SX00U]KF`06@410
7QhN410@410@7AdMG5aL0WYjNP05CTi>G5aL?Shn?ShnBDU900:DU9@01U1@D4a<C5iNGUiNGVm_KgUi
N@97AdL01@L71b<S8cdm?Cdm?C/k>`03=CDe00DY:BUgMgMgMgLf=SJ][Jd00Z2PX006;bl_DE5AXj>S
Xj>SCdm?E5AD0]_Kf`05P820_kno_knoe=CD61PH009_Kfl01Y:BTUEEE@/;2`/;2lc<c?gmo@:ATI40
1H61PAdM7OooooooofUYJ@04oooo0[Rh^0Coool00`000?ooooooo`0=oooo000Roooo00<0003ooooo
ool00_ooo`;IfMT5oooo00=`L71]KFe]KFd00oooo`06=CDeh^;Roooooooo[:b/FEUI0XJ6QP06oooo
;Rh^OGemOGemoooodM7A0V9RHP06SHf=mOGeIVIVIVIVoooo`l?30T10@005YZJVWIfMWIfM];Bd]KFe
00:KVi/01W1`L7moOgalO7alO9nOWb0P809EEED01W9bLUYJFV9RHV9RH[Zj^SHf=P95ADD01BPX:24Q
8B4Q8FMWIcPh>0023Ph>00H`<31bLW9fMWIfMWI_Kfm5ADD29bLW00IADE5:BTZZZZZZZZYMGEdJ6QX2
=3@d00E9BDTf=SHf=SIfMWIFEUH00Rh^;P060`<3E5AD<c<c<c<cHf=SB4Q80VIVIP06H61P=3@d61PH
61PHIVIVE5AD0T10@005Shn?DE5A9RHV9RHV30`<00:4Q8@01^[ZjWemOALG5aLG5fQXJ7moO`:;Rh/0
1P`<33Ti>D51@D51@B`/;:FUY@8N7Qh01EEEEBPX:8j>SXj>SVEUI@02JVYZ00IMGEdZ:RXB4Q8B4Q;k
no]`L702=SHf00J^[Zk?clmRHV9RHV;0`<19BDT2E5AD00EKFe]iNGW7alO7alOMgMd00oooo`05_;bl
n_[jn_[jno_kWIfM00?oool013/k>e=CDe=CDhf=S@?oool00`000?ooooooo`0/oooo00@0003ooooo
ooooool2f][J1Oooo`;5aLD01[Ng]ooooooooooooh^;Ri^KV`;oool01X^;RgIfMX:2PX:2P_oooe=C
D`:QXJ401O7alO3`l?3`l5iNGZj^[P02`<3000Hi>CWooonSXj>SXj=SHf?5aLD2Kfm_00FDU9CFe]KF
e]InOWiJFUX00Xf=S@06OgmoWYjN7AdM7AdMG5aLPh>30V1PH005Jf][][JfEEEEEEEE9BDU0090@400
1TI6AShn?T92@T92@S@d=0/;2`9bLW801[2`/38b<V][Jf][Je9BDUiNGP9XJ6P01JJVYUUIFEUIFB<S
8dA4A002>c/k00IBDU9>CTiHF5QHF5Pl?3a9BDT2820P00EXJ6PI6ATI6AV@T91]KFd00X61P@067alO
10@4G5aLG5aLDe=C?3`l0YfMW@05CTi>?3`l8B4Q8B4QG5aL00;Hf=P01Vi^KPd=3EEEEEEEEHn?Sh20
P08E5AD01Chn?S0`<3Xj>SXj>Y>CT`029BDU00I9BDTR8R:9RHV9RHUIFEUmOGd2Cdm?00Hf=SHi>CWe
mOGemOEYJFTN7Qh2U9BD00F^[Zi;Bd];Bd_Cdm=0@4000T92@P06=cLgRXZ:e=CDe=CDoooo`/;20ooo
o`04c/k>ooooooooFUYJ0oooo`04@d=3CTi>CTi>Shn?0oooo`030000oooooooo00goool002;oool0
0`000?ooooooo`08oooo00EkNg_ooooJf][Jf][oool00WmoO`06OGemiNGUj^[Zj^[ZIfMWA4A40Ti>
CP06dM7AGEeMBd];Bd];51@DT92@0V1PH006WYjNMGEe][Jf][Jfoooo8B4Q0U=CD`05JVYZno_kno_k
TI6AW9bL009JFUX01/;2`Ve]KDI6ATI6AT];Bbd];@8T92@01X20P4M7Achn?Shn?/c<c28R8P9hN7P0
1IJFUTM7AdM7AfYZJWinOP02TY:B00IcLg=aLG6OWinOWin6QXHS8b<23`l?00I8B4PN7QilO7alO7`m
?CeADE4292@T00E8B4Q4A4A4A4BGUiMVIVH00Sdm?@06<C4a?CdmIfMWIfMW<30`N7Qh0ZJVYP06FUYJ
H61P6a/K6a/K;Rh^<c<c0QhN7P05<C4a[Jf]92@T92@T=cLg009hN7P01YfMWE=CDdm?Cdm?CfYZJYnO
W`:5QHD01Xb<S4Q8B3Ph>3Ph>4A4A5aLG09cLg<01F1PH7IfMTi>CTi>CZ^[Z`02=cLg00J4Q8BWYjNP
X:2PX:3no_k:b/X26QXJ00J@T93=cLg?clo?cloNg]jk^k/2X:2P00I=CDdL71b=SHf=SHf7QhMYJFT2
Lg=c00Gooonh^;Rh^;Soooo4a<@00T92@P04ooooT92@j>SXj>SX1?ooo`030000oooooooo02coool0
0`000?ooooooo`07oooo00>ATI7Zj^[Zj^X00_ooo`9lO7`01YJFU[jn__ooooooohB4Q30`<09EEED0
1Nk^kR`/;7inOWinOQ`L7002Lg=c00IWIfNBTY9eMGEeMGFWYjOoool25aLG00EHF5QXJ6Sbl_;bl_9m
OGd00Y:BTP06GemO[Jf]K6a/K6a/GemO=CDe0QhN7P068b<SZ:RXBd];Bd];820Pl?3`0PX:2P05E5AD
X:2PX:2P9BDUC4a<00:4Q8@01YRHV6a/K8Z:RXZ:RZ6QXHb<S08=3@d01BXZ:VUYJC4a<C4a<D];B`02
6a/K00J5QHDR8R8`<30`<31>CTiQHF42GEeM00EBDU8];BdE5ADE5AE_Kfl00QPH6006RXZ:[Zj^I6AT
I6ATBd];?3`l0UQHF006FEUI92@T9BDU9BDURh^;De=C0SDe=@05@D51UiNGUiNGI6AT?3`l0097AdL0
1;Zj^Vi^KW5aLG5aL@8[:b/2@D5100E5ADELG5aLG5aEEEF>SXh00Vi^KP06clo?IVIVK6a/K6a/J6QX
IFEU0[no_`05QXJ69RHVc<c<c<c<n_[j00:VYZH01_Ogmk:b/YbLW9bLW3De=Bl_;`:CTi<01Hj>STm?
Cc@d=3@d=?KfmP03oooo00F`/;071`L71`Ooooo9bLT01_ooo`030000oooooooo00goool002;oool2
00002Oooo`05Ng]koooof][Jf][Joooo009oOgl01WemONGUiN[Zj^[ZjVMWIdA4A09>CTh01]7AdEeM
GD];Bd];Ba@D592@T09PH6001YjNWWEeMKJf][Jf]_ooob4Q8@9CDe<01FYZJ__kno_kni6ATIbLW002
FUYJ00K2`/9]KFe6ATI6ATI;Bd/];Bd292@T00J0P817AdLn?Shn?Sk<c<`R8R82N7Qh00FFUYI7AdM7
AdMZJVYnOWh00Y:BTP06Lg=cLG5aWinOWinOQXJ68b<S0Pl?3`06B4Q87QhNO7alO7al?CdmDE5A0R@T
9005B4Q8A4A4A4A4UiNGIVIV008m?Cd01S4a<Cdm?FMWIfMWIc0`<7QhN0:VYZH01UYJFV1PH1/K6a/K
6bh^;S<c<`8N7Qh01C4a<Jf][B@T92@T93Lg=`02N7Qh00JMWIeCDe=?Cdm?CdmZJVZOWil2QHF500J<
S8a8B4Ph>3Ph>3Q4A4ALG5`2Lg=c00EPH61fMWI>CTi>CTj[Zj/00SLg=`06Q8B4YjNWX:2PX:2Po_kn
b/[:0QXJ6P06T92@cLg=clo?clo?g]kN^k^k0Z2PX006CDe=71`LSHf=SHf=QhN7JFUY0W=cL`05oooo
^;Rh^;Rhooooa<C40092@T801?oooi2@T>SXj>SXj0?oool20000;_ooo`800008oooo00>ATI7Zj^[Z
j^X00_ooo`9lO7`01YJFU[jn__ooooooohB4Q30`<09EEED01Nk^kR`/;7inOWinOQ`L7002Lg=c00IW
IfNBTY9eMGEeMGFWYjOoool25aLG00EHF5QXJ6Sbl_;bl_9mOGd00Y:BTP06GemO[Jf]K6a/K6a/GemO
=CDe0QhN7P068b<SZ:RXBd];Bd];820Pl?3`0PX:2P05E5ADX:2PX:2P9BDUC4a<00:4Q8@01YRHV6a/
K8Z:RXZ:RZ6QXHb<S08=3@d01BXZ:VUYJC4a<C4a<D];B`026a/K00J5QHDR8R8`<30`<31>CTiQHF42
GEeM00EBDU8];BdE5ADE5AE_Kfl00QPH6006RXZ:[Zj^I6ATI6ATBd];?3`l0UQHF006FEUI92@T9BDU
9BDURh^;De=C0SDe=@05@D51UiNGUiNGI6AT?3`l0097AdL01;Zj^Vi^KW5aLG5aL@8[:b/2@D5100E5
ADELG5aLG5aEEEF>SXh00Vi^KP06clo?IVIVK6a/K6a/J6QXIFEU0[no_`05QXJ69RHVc<c<c<c<n_[j
00:VYZH01_Ogmk:b/YbLW9bLW3De=Bl_;`:CTi<01Hj>STm?Cc@d=3@d=?KfmP03oooo00F`/;071`L7
1`Ooooo9bLT01Oooo`80000?oooo000Roooo00<0003oooooool00_ooo`;clo<2oooo0]CDe003@d=3
oOgmoooo00Coool01U5ADF5QHOoooooooeADE18B4P9bLW801_ooog=cLfIVIVIVIX61PEIFEP92@T80
1QhN7WIfMZVYZJVYZJJVYUUIF@8X:2P01IRHV>k^k^k^kW]kNmgMg@02Fe]K00JDU9AOGen=SHf=SHeN
GUi4A4@2@T9200HF5QJ2PX9EEEEEEEFb/[8e=CD20`<300FNWYhP820P821nOWj@T9000VUYJ@06BTY:
J6QX5ADE5ADEMgMgCDe=0T92@P06IFEU61PH^k^k^k^k?Shn>3Ph0UaLG005E5AD8R8R8R8RTi>C=CDe
008m?Cd01V1PH2h^;Xf=SHf=SBh^;UEEE@:BTY801U9BDSdm?CDe=CDe=A@D53dm?@8c<c<01FMWIgMg
MeYJFUYJFU9BDP02CTi>00HR8R:CTi?WinOWinLi>CU<C4`2W9bL00IEEEE`L70M7AdM7AeTI6APH602
BDU900D=3@e5ADF8R8R8R8RDU9@00XF5Q@06d=3@RXZ:XJ6QXJ6QcLg=Jf][0WalO006f][J?Shn=cLg
=cLg<c<cTI6A0W1`L006O7al=cLgZ:RXZ:RX4a<Coooo0^7Qh@05OGemT92@T92@JVYZf][J00Coool2
];Bd1?ooo`030000oooooooo02coool010000?ooooooooooo`;Ph>02oooo0]WIf@03<S8boooooooo
00;oool2lo?c00Hj>SZ?ShoooooooomCDe<a<C42[:b/00GmoOebLW:<S8b<S8b:RXX00Vi^KP06EeMG
:RXZBd];Bd];Vi^Kg=cL0R/[:`054a<CLg=ce=CDe=CDRh^;00:f][H01Rl_;f=SHg]kNg]kNgYjNT];
B`8C4a<01WAdM34a<GemOGemOEYJF];BdP8F5QH01APH69fMWIfMWA/K6hJ6QP02Ti>C00ISHf=TI6AK
Fe]KFe/=3@fJVYX2HV9R00DQ8B69RHTn?Shn?Sj:RXX00TI6AP06BDU9;Bd]B4Q8B4Q8BDU9LW9b0T=3
@`05ADE5EUIF;Bd];Bd]TI6A008M7Ad01Slo?g=cLgQhN7QhN3dm?E1@D08d=3@01W5aLAdM7CDe=CDe
=Fm_KeaLG0<V9RH24Q8B00Jd];C;bl/R8R8R8R8l?3b9RHT2CDe=00E]KFdM7AeADE5ADE5>CTh00Rl_
;`06:2PXAdM7Zj^[Zj^[_;blSHf=0[2`/006IfMWQXJ6fMWIfMWII6ATJ6QX0]OGe`05Bd];D51@D51@
7alOY:BT009NGUh01WMgMcLg=kBd];Bd]2@T9?ooo`;4a<@01GmoOf=SHiJFUYJFUZNWY`04oooo0Y6A
T@Coool00`000?ooooooo`0=oooo000Roooo00<0003oooooool01?ooo`06c/k>ooooJFUYJFUYMWIf
^KVi0^CTi005<S8b10@410@4Z:RXY:BT0091@D401R@T98N7QfUYJFUYJMoOgj6QX@:2PX801TQ8B9bL
W:RXZ:RXZ51@D9BDU0:@T9001D51@C0`<3Xj>SXj>WMgM`02^KVi00IeMGFFUYIlO7alO7aSHf<[:b/2
D51@00IQHF5;Bd]^KVi^KVj;Rh/_;bl2Fe]K00FHV9PR8R9ZJVYZJVY>CTh00U1@D006OGemEEEE9bLW
9bLW1@D5Cdm?0SXj>P06XJ6QEEEE=CDe=CDeBTY:=SHf0WIfMP05I6ATIfMWWinOWinO>3Ph008W9bL0
1RDU9AXJ6RXZ:RXZ:UQHF7UiN@9NGUh01TM7Adi>C[6a/K6a/J:RXR<S8`8f=SH01Ta<C3Xj>SDe=CDe
=GQhN3De=@95ADD01H20P7moOgmoOcHf=Zb/[002j>SX00IADE5BDU9HF5QHF5QEEEEGEeL2IfMW00IT
I6CGemLl?3`l?3`];Be@D502CDe=00DB4Q:EUIFEUIFZZZZ9RHT00YBDU006iNGUDe=C/;2`/;2`T92@
6ATI0T=3@`04SXj>@410ADE5ADE50WYjNP:XZ:P01O3`l6EUIB4Q8B4Q8L71`@02lo?c00IHF5R_[jo<
c<c<c<cooomfMWH2oooo00G0`<3oooooooooool00000;_ooo`030000oooooooo00?oool01OOgmooo
ofMWIfMWIdm?C`02LW9b00KMgMe2@T8l?3`l?3afMWJSXj<2GUiN00HR8R:FUYIDE5ADE5C5aLFBTY82
MWIf00EPH63UiNGUiNFLW9aIFET00Te=C@06MWIfN7Qh;bl_;bl_=cLgPH610[no_`05QhN7PH61PH61
FUYJ=cLg00</;2`01B@T98b<S8b<S7=cLgUiN@027alO00Df=SJb/[8a<C4a<C5bLW800T];B`06F5QH
L71`JFUYJFUY2PX:8B4Q0S@d=006GEeMWYjNJFUYJFUY>SXjCdm?0R8R8P05OgmoF5QHF5QHLG5aW9bL
008k>c/01R4Q8B0P81`L71`L720P85mOG`9[Jf/01E=CDcLg=cLg=emOGj2PX002];Bd00HT92@S8b=D
E5ADE5A>CThP8202JVYZ00E<C4aCDe=nOWinOWiRHV800TI6AP06/K6abl_;K6a/K6a/DE5A<c<c0S0`
<005KVi^ADE5B4Q8B4Q8alO70091@D401QdM7FMWIe1@D51@D34a<G9bLP;Bd]801[Ng]fm_Kk6a/K6a
/D51@L30`0:KVi/01C`l?4I6ATI6AW9bLTY:BP02AdM700IkNg]iNGV;Rh^;Rh_7alM^KVh2@41000GU
iNG_knn?Shn?ShoUiND00oooo`04UiNGoooooooo];Bd0oooo`030000oooooooo00goool002;oool0
0`000?ooooooo`02oooo0Zj^[P06ooooXZ:R>c/k>c/kVIVIoooo0X:2PP05[:b/XJ6QXJ6QCTi>3Ph>
00:7QhL01YFEULS8b?oooooooa@D58>3P`9fMWH01XV9REEEEBLW9bLW9alO7j>SX`9BDU801Fi^KQ@D
565QHF5QHATI6@02/[:b00ICDe=VIVJUYJFUYJFZZZX/;2`2NWYj00IhN7Q/K6aeMGEeMGETI6ADE5@2
A4A400ERHV95ADE?Cdm?Cdld=3@00W]kN`066a/K=CDe9RHV9RHV>CTiMgMg0U]KF`06PH61A4A41PH6
1PH62`/;ADE50V1PH005L71`<30`LW9bLW9b<C4a00:6QXH01RTY:EMGEaLG5aLG5bXZ:WUiN@9RHV80
1QXJ6VATI0H61PH61Ph>3Va/K0:6QXH01TQ8B3De=DI6ATI6AXZ:RUQHF09EEED01L;2`YVIVIVIVADE
5KFe]@02jNWY00IJFUXT92@a<C4a<C6QXJ4<30`2?clo00J<S8c1`L58B4Q8B4Rj^[XP8202L71`00GB
d]9JFUYJFUY3@d=RHV800YfMW@06UiNGL71`X:2PX:2PB4Q8LW9b0WUiN@06Shn?2@T9F5QHF5QH`<30
8R8R0_ooo`05EUIFlO7aalO7alO7gMgM009eMGD01]_KfcDe=Clo?clo?b@T9=OGe`Koool00`000?oo
ooooo`0/oooo00@0003oooooooooool2WIfM00Gooon][Jdc<c<c<c>CTi<00_ooo`06LG5aWinOUYJF
UYJFL71`<S8b0Y:BTP06a<C4mOGehn?Shn?S@410RHV90UmOG`05][JfEeMGEeMGBd];9BDU00::RXX0
1Tm?CgYjNPH61PH61W9bLRl_;`;=cLd01EmOGd10@410@<30`7YjNP026QXJ00I<C4a6ATJ@T92@T92;
Rh/d=3@2<30`00EOGemcLg=NGUiNGUiRHV800Slo?`06PX:27alO@D51@D51>c/k820P0W1`L006H61P
I6ATK6a/K6a/:RXZ>3Ph0Ti>CP05MGEeI6ATI6AT?cloO7al008T92@01WalO1dM7F=SHf=SH``<33Ti
>@9UIFD01DA4A3Xj>SXj>Tm?Cb@T90026QXJ00INGUigMgLa<C4a<C5ADE5HF5P2Ogmo00E>CTicLg>m
_Kfm_Ke^KVh00T];B`06U9BD][JfMWIfMWIf=SHf5ADE0X^;R`0561PH=3@dPh>3Ph>3];Bd008^;Rh0
1Zn_[c/k>fMWIfMWInWYjB0P809_Kfl01ZBTY7alO6IVIVIVIT];Bl?3``9bLW801HJ6QVUYJFUYJI>C
T`P82002DU9B00K@d=0:2P[ooooooolg=cOJf]X2m?Cd00GmoOe0@43Vi^KVi^ILG5`00VYZJP032`/;
_[jnoooo00Goool00`000?ooooooo`0=oooo000Roooo00<0003oooooool00_ooo`:^[Zh01_oooj:R
XS/k>c/k>iVIVOooo`:2PX801Jb/[:6QXJ6QXDi>CPh>3P02QhN700JEUIG8b<SooooooolD51B3Ph<2
MWIf00J9RHUEEEDW9bLW9bLO7anSXj<2DU9B00E^KVhD51AQHF5QHF4I6AT00[:b/P06De=CIVIVYJFU
YJFUZZZZ;2`/0WYjNP06N7QhK6a/MGEeMGEeI6ATE5AD0TA4A005HV9RADE5Cdm?Cdm?=3@d009kNg/0
1Q/K6cDe=BHV9RHV9STi>GMgM`9KFe/01X61PDA4A0H61PH61P/;2dE5A@9PH6001G1`L30`<79bLW9b
LS4a<@02QXJ600HY:BUGEeLG5aLG5aLZ:RYiNGT2HV9R00HJ6QYTI6@61PH61PH>3Pi/K6`2QXJ600I8
B4Pe=CE6ATI6ATJ:RXYHF5P2EEEE00G2`/:IVIVIVITE5AFe]KD00^WYj@06FUYJ92@T<C4a<C4aXJ6Q
30`<0Slo?`06S8b<`L71B4Q8B4Q8^[Zj820P0W1`L005d];BFUYJFUYJ@d=3HV9R00:MWId01YNGUg1`
L:2PX:2PX4Q8B79bLP9iNGT01Xn?S`T92EQHF5QHF<30`28R8P;oool01EIFE_7alLO7alO7amgMg@02
MGEe00KKfm/e=CDo?clo?clT92CGemL6oooo00<0003oooooool0;?ooo`040000oooooooooooo0YfM
W@05oooo[Jf]<c<c<c<cTi>C00;oool01W5aLInOWiJFUYJFUW1`L38b<P:BTY801/C4a?GemN?Shn?S
hd10@8V9R@9OGel01KJf]UMGEeMGEd];BbDU9@02RXZ:00I?CdmjNWX61PH61PIbLW8_;bl2cLg=00EO
Gem0@410@430`<1jNWX00QXJ6P06C4a<ATI6T92@T92@Rh^;=3@d0S0`<005GemOLg=cGUiNGUiNHV9R
008o?cl01X:2PQlO7d51@D51@C/k>b0P809`L7001V1PH6ATI6a/K6a/K2XZ:SPh>09>CTh01GEeMFAT
I6ATI3lo?galO00292@T00IlO7`M7AeSHf=SHf<<30`i>CT2IFEU00E4A4@j>SXj>SY?CdlT92@00QXJ
6P06GUiNMgMg<C4a<C4aDE5AF5QH0WmoO`05CTi>Lg=c_Kfm_KfmKVi^009;Bd/01YBDU;Jf]WIfMWIf
MSHf=QDE5@:;Rh/01APH63@d=8>3Ph>3PkBd]002;Rh^00J_[jlk>c]WIfMWIfOYjNTP8202Kfm_00JT
Y:AlO7aVIVIVIVI;Bd_3`l<2LW9b00F6QXIYJFUYJFVCTi<820P00U9BDP06d=3@2PX:oooooooo=cLg
f][J0_Cdm005oOgm@410i^KVi^KVG5aL009ZJVX00`/;2kjn__ooo`05oooo00<0003oooooool03Ooo
o`008_ooo`030000oooooooo00;oool2f][J00IPH62ATI7jn_[jn_Zl_;aCDe<2Q8B400EdM7AbLW9b
LW:OWilg=cL00Zj^[P06bl_;a<C4IVIVIVIV_[jnL71`0WemO@06=3@dMgMg51@D51@DDe=CMgMg0UmO
G`05>SXjD51@?Shn?Shn7QhN009PH6001T=3@i:BTXN7QhN7Qdi>CU5AD@90@4001[fm_GMgMkFe]KFe
]GAdM:6QX@9NGUh01J:RXQXJ6RHV9RHV9R`/;00292@T00@/;2`820Q:BTY:BTX2IFEU0RLW9`06@410
61PH>SXj>SXj;Bd]OWin0W5aL@05Cdm?>3PhWinOWinO;2`/008Q8B401Q`L734a<De=CDe=CFMWIb4Q
8@:4Q8@01W5aLEUIFHR8R8R8R5EEEB@T90:EUID01RPX:7alO5]KFe]KF`820RTY:@9SHf<01GinOQlO
7alO7d];Bde=C@02WYjN00HK6a/h>3PA4A4A4A5lO7aQHF4251@D00IGEeMaLG62PX:2PX9dM7AFEUH2
@D5100Ff][IJFUYJFUYJFUYHF5P00UUIF@06VIVI?3`l^KVi^KViHF5QFEUI0[Jf]P06WIfM@d=3YjNW
YjNWlo?coooo0UIFEP05UYJFl?3`^k^k^k^kdM7A009gMgL01[^k^eADE>?Shn?Shm_KfadM7@;2`/84
oooo00<0003oooooool0;?ooo`040000oooooooooooo0^SXj005SXj>S8b<oooooooono_k00:;Rh/0
1/G5aKBd]492@T92@[^k^c/k>`:TY:@01]?Cdl?3`eIFEUIFEXn?SjZZZP9TI6@01GalO4];Bd];Bf9R
HQTI6@02CDe=00ITI6AVIVHX:2PX:2Q9BDT/;2`2O7al00EEEEEWIfMWIfNe]KDI6AT00S<c<`06IFEU
PX:2Xj>SXj>Sa<C4A4A40/O7a`05I6AT_;bl<30`<30`2@T90099BDT01Shn?S<c<bHV9RHV9VIVITY:
BP9HF5P01SLg=cDe=A<C4a<C4e]KFa8B4P:OWil01EEEEFYZJVYZJRPX:96AT@02<c<c00HQ8B4D51@m
?Cdm?CeOGem:BTX2>c/k00EPH62FUYJFUYICDe>;Rh/00V5QH@068R8RSHf=9bLW9bLWPX:2Kfm_0QdM
7@052`/;IVIVG5aLG5aL4Q8B008k>c/01RHV9WalO0L71`L71dQ8B0h>3P:5QHD016=SHaTI6Da<C4a<
C0=LG5`01VQXJ30`<6ATI6ATI<71`E]KF`9:BTX01V=SHfEUIJBTY:BTY38b</S8b09=CDd01C/k>j>S
Xj>SXk6a/C<c<`02/K6a00K`l?3ooom=CDe=CDf/[:c/k>`2YJFU00F^[ZihN7Re]KFe]KEEEED00^?S
h`04mOGe8R8R`<30`<301?ooo`030000oooooooo00goool002;oool200000oooo`;9bLT01_ooogal
O3@d=3@d=?oooh20P0<f=SH2K6a/00Hj>SZFUYJ8R8R8R8PL71cVi^H2_[jn00I?Cdm<C4`a<C4a<C4W
9bM[Jf/2;Bd]00H`<32:RXZOWinOWim:BTXc<c<2D51@00E=CDe2@T92@T8i>CTg=cL00SPh>0069BDU
6a/KFUYJFUYJ;2`/BTY:0XZ:RP06:2PX^[Zj>SXj>SXjPh>3>3Ph0WIfMP033@d=410@410@009IFET2
<c<c00JSXj=YJFTd=3@d=3@a<C5WIfL2410@00H:2PYfMWI`L71`L71YJFUFEUH29RHV00D71`LH61PH
61PL71aTI6@00Ti>CP06?Cdm4A4A7AdM7AdMPX:2K6a/0WIfMP06CDe=NWYj8B4Q8B4QEEEEEUIF0Shn
?P05@T92DU9BDe=CDe=C?clo0097AdL01XZ:RWemOEIFEUIFESHf=Ve]K@8`<3001W1`L6EUIFEUIFEU
IAPH69jNWP9bLW801EUIFI6ATEiNGUiNG/G5a@02AdM700ILG5b4Q8AeMGEeMGGEeMElO7`2DE5A00HZ
:RY4A4CKfm_Kfm/g=cNRXZ82OGem00J[Zj^UYJFOWinOWild=3BOWil2fMWI00ESHf<j>SXj>S[<c<co
ool00[Fe]@05ooooo_knooooooooe=CD00;oool20000;_ooo`800002oooo0]3@d005ooooDU9BNWYj
NWYjlo?c00;Fe]H01UUIFDM7Ak>c/k>c/g]kNmOGe`9eMGD01T=3@mWIfJJVYZJVYT92@Vm_K`9CDe<0
1EmOGe5ADE5ADC8b<QXJ6P02NWYj00IgMgN7QhL61PH61PH[:b]dM7@2I6AT00Dj>SXf=SHf=SHJ6QXn
?Sh00RXZ:P06?clo=cLgFEUIFEUIO7alBTY:0]gMg@05FEUIXZ:R:b/[:b/[KFe]008@41001R/[:eYJ
FW5aLG5aLDU9BI:BTP9XJ6P01SHf=T51@EQHF5QHF28R8QLG5`:7QhL01Fi^KVEUIFEUIEEEEB4Q8@02
3Ph>00HC4a<X:2QEEEEEEEEIFET];Bd22PX:00DM7AfCTi>CTi=QHF5eMGD00TE5A@06RXZ:;2`/Jf][
Jf][BTY:ADE50T10@003F5QH=cLg=3@d008d=3@2Shn?00IlO7aCDe<`<30`<31TI6@a<C42GUiN00ET
I6A0@40E5ADE5AF8R8P00W]kN`06?CdmYJFUBDU9BDU9dm?CEeMG0WQhN005MGEeDE5A[:b/[:b/NGUi
00=MGEd01F5QHJj^[Zj^[UQHF;Ng]`02Shn?00JVYZJKVi^o_kno_km1@D7Ng]h2UYJF00DE5AE:BTZ6
QXJ6QXKoool00WYjNPCoool00nCTi?ooooooo`0200003oooo`008_ooo`030000oooooooo00;oool2
bLW900KooomlO7`d=3@d=3Cooon0P803=SHf0Va/K006>SXjUYJFR8R8R8R871`Li^KV0[jn_P06Cdm?
C4a<<C4a<C4a9bLWJf][0Rd];@06<30`RXZ:WinOWinOBTY:<c<c0U1@D005CDe=@T92@T92>CTi=cLg
008h>3P01RDU9A/K6eYJFUYJFR`/;4Y:BP::RXX01RPX:;Zj^SXj>SXj>X>3PcPh>09fMWH00`d=3A0@
410@4002FEUI0S<c<`06Xj>SJFUY=3@d=3@d<C4aIfMW0Q0@40062PX:MWIfL71`L71`JFUYEUIF0RHV
9P051`L761PH61PH71`LI6AT009>CTh01Sdm?A4A4AdM7AdM7H:2PVa/K09fMWH01Te=CGYjNR4Q8B4Q
8EEEEEIFEP8n?Sh01D92@U9BDU=CDe=CDclo?`02AdM700J:RXYmOGeFEUIFEUHf=SI]KFd2<30`00I`
L71UIFEUIFEUIFDH61RNWYh2LW9b00EIFEVATI5NGUiNGUk5aLD00TM7A`06G5aLQ8B4MGEeMGEeeMGE
O7al0U5AD@06:RXZA4A4fm_Kfm_K=cLgXZ:R0WemO@06Zj^[YJFUWinOWinO=3@dWinO0]WIf@05Hf=S
>SXj>SXjc<c<oooo00:e]KD01Oooookno_ooooooomCDe003oooo00<0003oooooool0;?ooo`040000
oooooooooooo0]3@d005ooooDU9BNWYjNWYjlo?c00;Fe]H01UUIFDM7Ak>c/k>c/g]kNmOGe`9eMGD0
1T=3@mWIfJJVYZJVYT92@Vm_K`9CDe<01EmOGe5ADE5ADC8b<QXJ6P02NWYj00IgMgN7QhL61PH61PH[
:b]dM7@2I6AT00Dj>SXf=SHf=SHJ6QXn?Sh00RXZ:P06?clo=cLgFEUIFEUIO7alBTY:0]gMg@05FEUI
XZ:R:b/[:b/[KFe]008@41001R/[:eYJFW5aLG5aLDU9BI:BTP9XJ6P01SHf=T51@EQHF5QHF28R8QLG
5`:7QhL01Fi^KVEUIFEUIEEEEB4Q8@023Ph>00HC4a<X:2QEEEEEEEEIFET];Bd22PX:00DM7AfCTi>C
Ti=QHF5eMGD00TE5A@06RXZ:;2`/Jf][Jf][BTY:ADE50T10@003F5QH=cLg=3@d008d=3@2Shn?00Il
O7aCDe<`<30`<31TI6@a<C42GUiN00ETI6A0@40E5ADE5AF8R8P00W]kN`06?CdmYJFUBDU9BDU9dm?C
EeMG0WQhN005MGEeDE5A[:b/[:b/NGUi00=MGEd01F5QHJj^[Zj^[UQHF;Ng]`02Shn?00JVYZJKVi^o
_kno_km1@D7Ng]h2UYJF00DE5AE:BTZ6QXJ6QXKoool00WYjNPCoool01NCTi?ooooooooooo`00000?
oooo000Roooo00<0003oooooool00_ooo`:DU9@01_ooonOWikBd];Bd]?ooof9RHP=9BDT2LW9b00He
=CF^[ZigMgMgMgMKFe]FEUH2IFEU00H:2PYZJVY?Cdm?CdmXJ6Pm?Cd2h^;R00IRHV8h>3RXZ:RXZ:R9
RHUZJVX29bLW00E[Jf/:2PX:2PX^;Rj7QhL00X:2PP06BTY:92@TK6a/K6a/U9BDPh>30VUYJ@06Shn?
S8b<6a/K6a/KEUIFBDU90Vm_K`059bLW3`l?3`l?L71`U9BD008M7Ad01Shn?U=CDfEUIFEUICPh>:6Q
X@8b<S801R0P87AdM5QHF5QHF7]kNcXj>P8d=3@01@L71gemOGemOFm_KemOG`02:RXZ00I0@41BDU9a
LG5aLG5nOWiIFET2P82000IRHV8];BdO7alO7am0@419BDT2>3Ph00Di>CTn?SiDE5ADE5AfMWH00T=3
@`06<S8bFe]KMgMgMgMg410@<C4a0SHf=P06HF5QC4a<IFEUIFEU=CDeVi^K0XF5Q@05;Bd]M7AdHV9R
HV9RGEeM008^;Rh01UeMGEQHF2HV9RHV9Y2@T:NWY`9<C4`01WalO6MWIoooooooojZZZT=3@`9WIfL0
1XZ:RT];Bda<C4a<C:6QXJn_[`;3`l<01H61PHJ6QXJ6Q^;RhS4a<@02Rh^;00F1PH55ADEIFEUIFET^
;Rh00oooo`030000oooooooo02coool010000?ooooooooooo`:KVi/01OooonCTi:RXZ:RXZ?ooo`02
?clo00IkNg/H61Q?Cdm?CdmSHf>c/k<2IfMW00I4A4A7AdMTI6ATI6@71`MMGEd2@d=300EQHF5YJFUY
JFVi^KV=SHd00Vi^KP06/k>cMWIfJVYZJVYZ71`LHf=S0R<S8`05;Bd]TI6ATI6APX:2>SXj008k>c/0
1VUYJG]kNfMWIfMWIe1@D:RXZ0:TY:@01CXj>WAdM34a<C4a<F=SH`02;Bd]00H:2PYaLG6HV9RHV9P@
4117AdL2@41000IkNg]6ATJ>SXj>SXhc<c<@4102Lg=c00E<C4b6QXJ6QXHn?Sh[:b/00Q0@4006RHV9
HV9REUIFEUIF;2`/=CDe0TE5A@05OWinKFe]KFe]JFUYQXJ6009ADE401T51@BPX:5IFEUIFESdm?Dm?
C`8W9bL01C`l?4E5AFi^KVi^KTM7A`029RHV0VIVIP851@D01QPH61dM7DE5ADE5ADI6AU5AD@8K6a/0
1J:RXY:BTY:BTT51@GmoO`02IVIV00IBDU8Q8B5QHF5QHF5=CDdd=3@2PH6100F^[ZiCDe>5QHF5QHEa
LG400_ooo`06][Jf?3`lKVi^KVi^SHf=@D510V5QH@06^[ZjVIVI^;Rh^;RhPX:2Ti>C0/O7a`05AdM7
PH61PH61RXZ:Cdm?009NGUh01BTY:Oooooooooooo`00000?oooo000Roooo00<0003oooooool00_oo
o`;GemL01[>c/cDe=DY:BTY:BXV9RLc<c0:d];@01CXj>[Fe]KFe]BDU9HV9R@02MGEe00J>SXjYZJTJ
6QXJ6QY5ADEbLW828R8R00Jo_km5ADE?Cdm?CdnTY:@`<302/;2`00E=CDe^KVhd=3@d=3B8R8P00R/[
:`06@410R8R8YZJVYZJVADE5=CDe0Ve]K@06YZJVCDe=B4Q8B4Q8UiNG<30`0R4Q8@05PH615QHF6QXJ
6QXJ;Rh^009SHf<01]WIfIjNWQdM7AdM7AXJ6Q@D5095ADD01Ti>CTa<C4I6ATI6ASXj>UaLG08N7Qh0
1@H61UADE2TY:BTY:EADE002=CDe00IBDU9OGelG5aLG5aNQXJ5;Bd/2OWin00IFEUIUIFDX:2PX:2Pk
>c]VIVH2?Shn00HZ:RYWIfL^;Rh^;Rj:RXXg=cL2CDe=00Dn?Shc<c<c<c=NGUi6ATH00Rh^;P06FEUI
GEeM410@410@IFEU8B4Q0Te=C@064Q8BB4Q8WIfMWIfM4Q8B_Kfm0TE5A@05:RXZHf=SHf=S:b/[TY:B
00;Lg=`01W]kNfATI2HV9RHV9YjNWTE5A@;WinL01TQ8B4E5AGmoOgmoOlk>cUIFEP:VYZH01Da<C:RX
Z18B4Q8B4WemO@02VYZJ00ISHf?ooomNGUiNGUj[Zj_:b/X2FEUI1?ooo`030000oooooooo02coool0
10000?ooooooooooo`;Ti>@01L_;be9BDW9bLW9bLXf=S@02dM7A00J0P80@412:RXZ:RXXZ:RY@D502
O7al00JNWYj@T90C4a<C4a=7AdMeMGD25QHF00FUYJD];Bd];Bd^;RiiNGT00V=SH`06hN7QLG5aGEeM
GEeMF5QHJf][0S4a<@05?cloSHf=SHf=Zj^[ATI6008/;2`01X:2PXj>SSHf=SHf=UADE9jNWP8F5QH0
0cXj>Vi^KQ<C4`024a<C0RDU9@06FUYJfMWIUiNGUiNG61PH2PX:0RPX:006H61PBDU9>CTi>CTi820P
:RXZ0TA4A0054Q8B9RHV9RHVM7Ad;bl_008n?Sh01SHf=TU9BEMGEeMGEahN7YBDU09<C4`01H^;Rbl_
;bl_;gmoOb<S8`02:BTY00IfMWIVIVH=3@d=3@f0P80O7al2NWYj00D^;Ri>CTi4A4A4A4@b<S800TY:
BP06G5aL4Q8BFe]KFe]K@T92;Rh^0TU9B@05>SXj@d=371`L71`LD51@00:TY:@01P`<3;Fe]E=CDe=C
DcTi>G=cL`8];Bd01[2`/<?3`iNGUiNGUdA4A2@T90:1PH401D10@?gmoOgmoCXj>TE5A@02N7Qh00KF
e]I=CDf7QhN7QhLT92CIfMT2A4A400E6ATKDe=BPX:2PX:3EeMD00VEUI@04^k^kdm?CMGEeMGEe1?oo
o`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0UQHF006VYZJZZZZ6ATI6ATIUIFE
a/K60Xb<S005d];BJf][Jf][CDe=?Cdm0097AdL01Y:BTTY:BVm_Kfm_KeaLG2TY:@8O7al01WMgMhb<
S4i>CTi>CX>3PbXZ:P;AdM401M;BdSlo?iZJVYZJVX^;R`02Cdm?00@^;RiIFEUkNg]kNg/2JVYZ0R@T
9006EeMGO7al=cLg=cLgGEeMBDU90UmOG`05WYjNFEUI<30`<30`MWIf009:BTX01YNGUh>3Pc`l?3`l
?1lO7eADE098B4P01Tm?Cb/[:gIfMWIfMS4a<Bh^;P9_Kfl01Da<C2d];EEEEEEEED10@002D51@00JE
UIDR8R8I6ATI6AUgMgM:BTX2OWin00I2@T:DU9@l?3`l?3`^;Rhc<c<26a/K00I]KFeHF5P61PH61PK[
jn/h>3P26a/K00E4A4A8B4Q8B4PX:2Q?Cdl00VUYJ@06<30`DU9B?3`l?3`lF5QHV9RH0Ta<C006@d=3
9bLW9bLW9bLW=SHf6QXJ0Va/K005];Bdh^;Rh^;R>SXjLW9b00;AdM401QXJ6U5ADEYJFUYJFXN7QdY:
BP9eMGD01WinO_clo6a/K6a/K4I6A[jn_P97AdL01MWIfE5ADFMWIfMWIiNGU`02TY:B00EWIfOooonQ
XJ6QXJ5iNGT00oooo`05/;2`oooooooooooo000002koool010000?ooooooooooo`9JFUX00l;2`W]k
NeMGE`02EeMG0XF5Q@06CDe=/;2`>CTi>CTi92@T4a<C0VATI006R8R8De=CKFe]KFe]@d=33`l?0R/[
:`05FUYJK6a/K6a/>SXjLg=c008D51@01/c<c?;blU=CDe=CDhB4Q9:BTP93@d<01BLW9dm?Cdm?CgYj
NV=SH`02LW9b00HP821IFEUnOWinOWhe=CEPH602A4A400EOGenIVIURHV9RHV8X:2P00W9bLP06AdM7
VIVIPH61PH61=cLg51@D0V1PH006<c<cCTi>A4A4A4A4E5ADADE50PT92@05CDe=Kfm_Kfm_CDe=FEUI
008c<c<01T51@Hj>SR0P820P82DU9G5aL@98B4P01I2@T1lO7alO7iVIVAdM7@0271`L00=OGem3@d=`
L7000W1`L0056a/KfMWIfMWI@d=37AdM009<C4`01CXj>QLG5aLG5e1@D6e]K@02=cLg00Hb<S8P821;
Bd];Bd^b/[9;Bd/2A4A400Dd=3@T92@T92@T92@I6AT00U9BDP06aLG5emOGJVYZJVYZD51@g=cL0TQ8
B005Jf][LW9bKFe]KFe]De=C009oOgl01WAdM?ooofYZJVYZJVUYJIbLW09fMWH01ZVYZI>CTiNGUiNG
UeEEEM7Ad@:LW9`01=OGej>SXj>SXijNWP?oool01LG5aOooooooooooo`00000?oooo000Roooo00<0
003oooooool00_ooo`9HF5P01YZJVZZZZQTI6ATI6IFEULK6aP:<S8`01M;BdV][Jf][Jde=CCdm?@02
AdM700JBTY9:BTY_Kfm_KfmLG5`Y:BT27alO00IgMgN<S8a>CTi>CTj3Ph<Z:RX2dM7A00GBd]8o?cnJ
VYZJVYZ;Rh/00Tm?C`04;Rh^FEUINg]kNg]k0VYZJP8T92@01UMGEgalO3Lg=cLg=eeMGDU9B@9OGel0
1IjNWUUIFC0`<30`<7IfMP02BTY:00JGUiN3Ph<l?3`l?3`O7amDE5@2B4Q800I?Cdl[:b]fMWIfMWHa
<C4^;Rh2Kfm_00E<C4`];BeEEEEEEEE0@4000U1@D006UIFE8R8R6ATI6ATIMgMgBTY:0WinOP06@T92
U9BD?3`l?3`l;Rh^<c<c0Q/K6`06KFe]F5QH1PH61PH6jn_[>3Ph0Q/K6`05A4A4B4Q8B4Q8:2PXCdm?
009YJFT01S0`<59BDS`l?3`l?5QHF9RHV09<C4`01T=3@bLW9bLW9bLW9cHf=QXJ6P9/K6`01KBd]>;R
h^;RhSXj>W9bLP02dM7A00HJ6QYADE5JFUYJFUZ7QhM:BTX2MGEe00InOWklo?a/K6a/K6a6ATJn_[h2
AdM700GIfMUADE5WIfMWIfNGUiL00Y:BTP05IfMWooooXJ6QXJ6QNGUi00?oool01K2`/?oooooooooo
o`00000^oooo00@0003oooooooooool2FUYJ00?2`/9kNg]GEeL00UMGE`:5QHD01Te=CK2`/3Ti>CTi
>B@T91<C4`9TI6@01XR8R5=CDfe]KFe]KD=3@`l?3`8[:b/01EYJFVa/K6a/K3Xj>W=cL`0251@D00K<
c<cbl_9CDe=CDe>4Q8BBTY82@d=300DW9bM?Cdm?CdmjNWYSHf<00W9bLP06820PFEUIOWinOWin=CDe
H61P0TA4A005GemOVIVIHV9RHV9R:2PX009bLW801TM7AiVIVH61PH61PCLg=a@D509PH6001S<c<di>
CTA4A4A4A5ADE4E5A@892@T01De=CFm_Kfm_Kde=CEUIF@02<c<c00I1@D6>SXhP820P820U9BEaLG42
B4Q800F@T90O7alO7anIVITM7Ad00Q`L7003GemO@d=3L71`009`L7001A/K6mWIfMWIfD=3@adM7@02
C4a<00Dj>SXG5aLG5aM@D51]KFd00SLg=`06<S8b820PBd];Bd];/[:bBd];0TA4A005=3@d92@T92@T
92@T6ATI009BDU801/G5aMOGefYZJVYZJU1@D=cLg098B4P01F][Jg9bLVe]KFe]KE=CD`02Ogmo00Id
M7CooomZJVYZJVYYJFVLW9`2MWIf00JYZJVCTi>GUiNGUiMEEEGAdM42W9bL00CGemNSXj>SXj>NWYh3
oooo00G5aLGoooooooooool000003oooo`008_ooo`050000ooooooooooool_;b00;oool01YBDU2`/
;0/;2`/;2j:RX_ooo`:0P8001LS8b?ooooooob@T95mOG`02IVIV00Jh^;RGUiMoOgmoOgmYJFU5ADD2
JFUY00IZJVXK6a^YZJVYZJUlO7aeMGD2PH6100G<c<bATI4o?clo?cm>CTh00Zj^[P06MgMgPX:2KFe]
KFe]@d=3LG5a0SLg=`06QhN7B4Q8CDe=CDe=410@<30`0U9BDP05J6QX7alOKFe]KFe]Ph>3008[:b/0
1SLg=f=SHa@D51@D52XZ:YVIV@:5QHD01V9RHRh^;U1@D51@D18B4Ta<C09?Cdl01FATI5iNGTa<C4a<
C4m?C`02H61P00I6ATHg=cM8B4Q8B4Pf=SHF5QH2GEeM00<61PIUIFDI6AT00QTI6@05?ShnD51@D51@
8B4Q:BTY008T92@015IFETE5ACDe=CDe=@=bLW801UEEE@l?3galO7alO0h>3WAdM08d=3@01R0P86EU
IFi^KVi^KUEEEC0`<08];Bd01EYJFXf=SGemOGemO@h>3P02J6QX00H>3PhO7ang]kNg]kN1PH4n?Sh2
Xj>S00JFUYI>CTi6ATI6ATIZJVXj>SX27AdM00IJFUY3@d?clo?clo<Y:BV2PX82?3`l00F@T93/k>c/
k>`U9BG^k^h00SHf=P05VIVI:2PXooooooooDU9B00?oool00`000?ooooooo`0/oooo00<0003ooooo
ool00oooo`05ZZZZD51@7QhN7QhN`/;200;oool01WYjN[Bd]?oooooooc@d=5mOG`9IFET01/30`:VY
ZFMWIfMWIf=SHemOG`9BDU801F1PH0X:2PX:2YRHV7inOP02MgMg00InOWk?clnFUYJFUYHi>CUHF5P2
Z:RX00E^KVioOgmoOgmlO7`k>c/00VMWI`06@410N7QhEUIFEUIFEeMG5aLG0R/[:`05FEUIKFe]6ATI
6ATIJ6QX009nOWh01S<c<bl_;eMGEeMGEalO7ahN7P:KVi/01W=cLgIfMQ`L71`L7451@B<S8`8l?3`0
1Clo?gAdM7AdM5UIFEMGE`02Bd];00IGEeM0@40b<S8b<S9ADE4_;bl28b<S00ESHf<:2PX:2PYTI6@@
41000QLG5`06DE5A@D51;2`/;2`/=SHf9RHV0Tm?C`03?clo>SXjMGEe009eMGD2E5AD00HK6a]nOWh9
2@T92@UVIVH];Bd292@T00E[Jf]fMWI;Bd];Bd/o?cl00S/k>`06CTi>U9BDJFUYJFUY;2`/D51@0RTY
:@06=cLgXj>SUYJFUYJF?3`l[:b/0YBDU005Bd];>CTi>CTiMgMgDe=C008G5aL01Vm_KdE5ALg=cLg=
cDe=CF9RHP8^;Rh01GmoOoooob0P820P8>g]k@02<S8b00FBTY8b<S;ooooooom1@D400oooo`030000
oooooooo00goool002;oool200000_ooo`05ATI6a<C4a<C4l?3`@41000;kno/01B/[:d=3@fQXJ6QX
J?ooo`02Q8B400JBTY9LG5`b<S8b<S8N7Qh[:b/2N7Qh00Hj>SY@D52EUIFEUIEBDU96ATH2PX:200Hl
?3a_KfmADE5ADE6UYJFNWYh2Fe]K00DK6a^ATI6ATI65QHDI6AT00VATI0064Q8B820PVIVIVIVICDe=
JFUY0UUIF@06:BTY92@TA4A4A4A43Ph>:RXZ0YFEU@05>CTi71`L71`LMGEe8R8R008T92@01U9BDYZJ
VTQ8B4Q8B6IVIUIFEP8];Bd01RXZ:U9BDS@d=3@d=51@D4Y:BP8Q8B401EUIFCXj>SXj>UEEEB8R8P02
8b<S00HT92@X:2PI6ATI6AU;Bd//;2`2820P00H:2PYLG5bGUiNGUiNLW9a1@D42JVYZ00Dn?SifMWH_
;bl_;bl^;Rh00Te=C@06=CDe?3`lSHf=SHf=;Bd]Rh^;0SHf=P06>3PhKfm_<C4a<C4a=cLg;2`/0U9B
DP05JFUYL71`H61PH61P=SHf008K6a/01TI6AWinOWQhN7QhN8:2PWAdM09EEED01Pd=3B/[:f1PH61P
H2@T93hn?P:RXZ801PH61QhN7Z2PX:2PX2XZ:^[ZjP:4Q8@01DU9BGmoOgmoOl30`5UIF@02SHf=00FW
YjM?CdoooooooonXZ:P00_ooo`80000^oooo0P000006oooo<30`f][Jf][JoOgm?Cdm0_ooo`059bLW
CTi>CTi>JFUYoooo009nOWh01YVIVDI6AT=3@d=3@`l?3chn?P9nOWh01CHf=UQHF:2PX:2PX4Y:BP02
De=C00JBTY8^;Ri[Jf][Jf]QHF6QXJ42ZJVY00EEEEDT92BBTY:BTY9iNGT00RPX:006Lg=c1`L7;bl_
;bl_P820HV9R0U5AD@06BDU9>CTi61PH61PH@d=3410@0R/[:`05Ti>C>SXj>SXj30`<OWin008@4100
1QdM7EMGEhf=SHf=SCHf=WMgM`9DE5@01B4Q8Bd];E5ADE5ADC<c<`02De=C00I5ADDQ8B5@D51@D50n
?Si;Bd/2;Rh^00D_;blL71`_;bl_;blG5aL00T];B`06;Bd]7QhN2PX:2PX:E5ADXJ6Q0YJFUP06Cdm?
Fe]KCTi>CTi>J6QX>c/k0STi>@05DU9B>3Ph>3Ph?cloP820008R8R801X61PD=3@d=3@d=3@f1PH2@T
9093@d<01A<C4g9bLW9bLV1PH6IVIP02@D5100H[:b/`<30e=CDe=CEkNg]XJ6P2VYZJ00AKFe]:BTX`
<30`<303CDe=00I8B4Q9BDVIVIVIVITO7al<30`2QXJ600HM7AgJf]Z7QhN7QhM<C4b<S8`2[jn_00Ei
NGUoOgmoOgnIVITk>c/00^o_k`03^k^koooooooo0080000?oooo000Roooo00D0003oooooooooooo@
d=000^;RhP06K6a/oooo5aLG5aLGIfMW/K6a0VEUI@05oooo`<30`<30`/;2KFe]00:][Jd01Rh^;S@d
=38b<S8b<Q4A4@h>3P:FUYH01WUiNLK6aSXj>SXj>Xf=SM[JfP9QHF401HB4Q5mOGlO7alO7adM7A`02
8b<S00IWIfN5QHE9BDU9BDTf=SIBDU82J6QX00@e=CEmOGe?Cdm?Cdl2?Shn0Rl_;`05H61P<S8b9bLW
9bLWFEUI009oOgl01S`l?1TI6D92@T92@Te=CGemO@95ADD01WMgMfi^KSlo?clo?b`/;55AD@9DE5@0
1Cdm?EiNGS/k>c/k>b0P8002FEUI00IADE5>CThT92@T92@n?ShE5AD2=SHf00Hk>c/];BebLW9bLW9:
BTXJ6QX2R8R800JGUiLG5aLL71`L71`j>SXT92@2?3`l00EWIfM=CDe=CDdn?Si6ATH00S`l?006H61P
EeMG?clo?cloJFUY=CDe0QlO7`069RHV@d=3CTi>CTi>UiNG<30`0XB4Q0059bLWD51@D51@IVIVG5aL
009MGEd01TA4A4i>CPl?3`l?3`P821`L70:BTY801STi>MCDe2l_;bl_;k2`/6YZJP:<S8`01I2@T6m_
Kj2PX:2PX79bLP02;bl_00Hh>3Q7AdO1`L71`L6j^[[/k>`2VIVI00E7AdOoooooooooool00000;_oo
o`040000ooooooooYJFU0_ooo`05CTi>oooo<C4a<C4aNg]k00:WYjL01UaLG?oookno_kno_jb/[8V9
R@:LW9`01Slo?a/K6dQ8B4Q8B20P81@D50:OWil01F][Jlo?clo?ccdm?I2@T002emOG00IFEUJ?Shm/
K6a/K6c<c<`i>CT29BDU00EQHF65QHF5QHEFEUHT92@00Ve]K@06CTi>6QXJLG5aLG5a>3Ph;Rh^0Ti>
CP059RHVIVIV=CDe=CDe8R8R009>CTh01XF5QCLg=b`/;2`/;2@T96MWI`9JFUX01TQ8B9FEUEQHF5QH
F2d];BPX:09KFe/01E5ADD10@410@5IFERd];@0230`<00I4A4AYJFUHF5QHF5PS8b<b<S82:RXZ0d10
@006<c<cM7Ad@T92@T92410@TI6A0YJFUP0492@T9bLW;Rh^;Rh^0S4a<@9aLG401DI6AS`l?3`l?4M7
AcHf=P02FUYJ00I=CDe6ATIbLW9bLW9>CThI6AT25ADE00DQ8B5UIFEUIFF6QXH<30`00V9RHP06B4Q8
=CDeMgMgMgMgKFe]EEEE0UYJFP05>3Ph4Q8B7AdM7AdM:2PX00:6QXH01VMWIjFUYCPh>3Ph>;Bd]4];
B`9lO7`01Zn_[e5ADI:BTY:BTWYjNS<c<`8d=3@01C8b<^GUiNGUiI2@T=WIf@02`L7100E5ADGooooo
ooooool000003oooo`008_ooo`050000ooooooooooood=3@00;Rh^801Va/K?oooaLG5aLG5fMWIk6a
/@9UIFD01Ooool30`<30`<;2`Ve]K@02[Jf]00H^;Rhd=3@b<S8b<S8A4A4>3Ph2UYJF00IiNGW6a/Hj
>SXj>SZ=SHgJf]X2HF5Q00F4Q8AOGeo7alO7alM7AdL00R<S8`06IfMWQHF5BDU9BDU9=SHfDU9B0VQX
J004=CDeOGemCdm?Cdm?0Shn?P8_;bl01F1PH38b<RLW9bLW9eUIF@02Ogmo00Hl?3`I6AU2@T92@T9=
CDemOGd2ADE500IgMgM^KVho?clo?cl/;2aADE42E5AD00Dm?CeNGUhk>c/k>c/P82000UUIF@06DE5A
CTi>92@T92@T?Shn5ADE0SHf=P06>c/k;Bd]LW9bLW9bBTY:6QXJ0XR8R006UiNG5aLG71`L71`L>SXj
92@T0S`l?005IfMWCDe=CDe=?ShnATI6008l?3`01V1PH5MGEclo?clo?fUYJCDe=@8O7al01RHV9T=3
@di>CTi>CYNGUc0`<0:4Q8@01BLW9e1@D51@D6IVIUaLG002GEeM00I4A4A>CTh?3`l?3`l820PL71`2
TY:B00Hi>CWDe=@_;bl_;bn`/;1ZJVX2S8b<00F@T91_KfnPX:2PX:1bLW800Rl_;`06>3PhAdM7`L71
`L71^[Zjk>c/0YVIV@05AdM7oooooooooooo000002koool010000?ooooooojFUY@;oool01Di>C_oo
oc4a<C4a<G]kN`02YjNW00ILG5cooono_kno_kn/[:b9RHT2W9bL00Ho?clK6a]8B4Q8B4PP820D51@2
WinO00E[Jf_?clo?cllm?Cf@T9000]OGe`06EUIFShn?K6a/K6a/c<c<>CTi0RDU9@05HF5QQHF5QHF5
EUIF92@T009]KFd01Ti>CQXJ6W5aLG5aLCPh>2h^;P9>CTh01BHV9VIVISDe=CDe=B8R8P02CTi>00J5
QHDg=cL/;2`/;2`T92AWIfL2FUYJ00I8B4REUIEHF5QHF5P];BdX:2P2Fe]K00EADE50@410@41FEUH]
;Bd00P`<3006A4A4JFUYF5QHF5QH8b<S<S8b0RXZ:P=0@4001S<c<gAdM492@T92@Q0@496AT@:FUYH0
12@T92LW9bh^;Rh^;P8a<C42LG5a00E6ATHl?3`l?3a7AdLf=SH00UYJFP06CDe=ATI6LW9bLW9bCTi>
6ATI0QDE5@058B4QIFEUIFEUQXJ630`<009RHV801TQ8B3De=GMgMgMgMfe]KEEEE@9JFUX01CPh>18B
4QdM7AdM7BPX:002QXJ600IWIfNUYJDh>3Ph>3Rd];A;Bd/2O7al00J_[jmADE6BTY:BTY9jNWXc<c<2
=3@d00Db<S;UiNGUiNF@T93IfMT00/71`@05ADE5oooooooooooo000000ooool002;oool00`000?oo
ooooo`02oooo0^?Sh`06EeMG/;2`UiNGUiNGWinO=cLg0XR8R005Vi^KR8R8R8R88B4QGUiN00;gmoL0
1/?3`dY:BUYJFUYJFXB4Q:n_[`8?3`l01/;2`YNGUc@d=3@d=2LW9fATI08L71`01CHf=W]kNhn?Shn?
SgIfMP0271`L00ICDe>_[jmFEUIFEUH];Bd@4102=3@d00HM7AeCDe>OWinOWilU9BE3@d<2Ng]k00DB
4Q94A4@T92@T92A/K6`00TM7A`06Y:BTPh>3BDU9BDU9FUYJKVi^0XR8R006:BTYTi>CAdM7AdM79bLW
92@T0SHf=P05GemO=CDe?Cdm?CdmX:2P008e=CD01RLW9hF5QDa<C4a<C3De=CTi>@8820P01R@T93/k
>f9RHV9RHS<c<d=3@`9oOgl01X^;Rdi>CS/k>c/k>d10@1hN7P9VIVH01De=CFQXJ6QXJ2XZ:Q0@4002
A4A400HJ6QY@D50^;Rh^;RhH61QHF5P25aLG00HS8b>5QHE<C4a<C4aIFEU:BTX2=SHf00EEEEEcLg=c
Lg<_;bmoOgl00Y2@T006JFUY6a/K;Bd];Bd]>3Ph9BDU0XZ:RP069bLWJ6QXD51@D51@[Zj^=3@d0S/k
>`05G5aL8B4Q?3`l?3`l?Shn009^KVh01[Fe]B`/;5ADE5ADE92@T4U9B@9XJ6P01EYJF_oooooooooo
o`00000^oooo00@0003oooooooooool2l_;b00D_;bnATI6i^KVi^KV?Shl00S/k>`06Jf][V9RHR8R8
R8R87QhNF5QH0_ooo`06^KVi:b/[OGemOGemTI6ATi>C0SLg=`05Xj>SZJVYZJVY?3`l8b<S009dM7@0
1RXZ:S8b<WMgMgMgMiNGUfi^KP8S8b<01E9BD[Bd];Bd]4e=CD51@@0292@T00HQ8B4_;bm4A4A4A4BF
UYHV9RH2?clo00EhN7PA4A5:BTY:BTXW9bL00WalO006=cLgVi^KQhN7QhN7ATI6<c<c0WQhN006SHf=
Bd];QXJ6QXJ6<c<c8b<S0QlO7`05>CTiEEEEEEEE<C4a;Rh^00:BTY801T92@P/;2i2@T92@T2HV9TA4
A08m?Cd01BTY:@P820P8251@D5IFEP02:BTY00Hn?SinOWjATI6ATI4n?Sha<C42;bl_00D;2`]ADE5R
HV9RHV9QHF400Rd];@067AdMDE5A410@410@EUIF:2PX0Q8B4P05FUYJ4a<C7AdM7AdMPX:2009BDU80
1TY:BSdm?BTY:BTY:EmOGfIVIP91@D401Xn?ShR8R71`L71`L1TI6C<c<`8/;2`01AhN7Xf=SHf=SCDe
=DU9B@02LW9b00J3Ph=VIVHQ8B4Q8B5jNWXl?3`2:RXZ00EJFUYLG5bl_;bl_;`^;Rh00UmOG`05NGUi
:BTYM7AdM7AdPh>300?oool00`000?ooooooo`0=oooo000Roooo00D0003oooooooooooo]kNd00Y6A
T@06K6a/UIFEAdM7AdM7=3@dVYZJ0YRHV005PX:2?Shn?ShnJFUY61PH009RHV801RPX:7alO;fm_Kfm
_BHV9STi>@:NWYh01V9RHT];BbDU9BDU9BHV9R`/;08^;Rh01B/[:aDE5APH61PH624Q8@02E5AD00H[
:b/c<c=;Bd];Bd/Z:RXn?Sh2BTY:00H_;blL71a4A4A4A4AdM7C3`l<2<c<c00E/K6a0@41ZJVYZJVXS
8b<00S4a<@069BDU?cloG5aLG5aL_[jn:2PX0Q<C4`067alOG5aL5aLG5aLG>3Ph7AdM0S0`<005:BTY
Jf][IFEUIFEU?3`l009jNWX01PD51Da<C2TY:BTY:Clo?fIVIP95ADD01Ta<C4m?CgYjNWYjNS4a<E]K
F`8b<S801UMGEcDe=HZ:RXZ:RS/k>fa/K08W9bL01EADE1lO7alO7adM7EIFEP02NGUi00I?CdmfMWIY
JFUYJFTZ:RY:BTX26ATI00INGUhi>CUIFEUIFEVKVi]@D502:RXZ00E_KfnUYJFUYJGPh>0S8b<00Rd]
;@06WIfME5ADWIfMWIfMV9RHJFUY0T10@006M7Ad1`L78B4Q8B4QBDU9AdM70Rl_;`048R8RL71`I6AT
I6AT0i>CT`0671`LRh^;<30`<30`NWYj^k^k0T51@@057AdMoooooooooooo000002koool010000?oo
ooooooooo`9iNGT01G=cLiRHV69RHV9RHRh^;P02XJ6Q00J4Q8BCTi<b<S8b<S9TI6@N7Qh2JFUY00HO
7am`L737alO7alLA4A5<C4`2QXJ600EWIfM5ADE5ADDG5aL[:b/00QPH6006=cLg71`L6QXJ6QXJ3`l?
820P0TM7A`058b<S?Cdm?CdmDU9B;bl_008j>SX01U1@D3@d=1dM7AdM7Clo?g]kN`:m_Kd01BPX:7=c
Lc/k>c/k>gemO@02>SXj00I6ATH:2PXi>CTi>CUOGen`/;02<S8b00H410@`<31PH61PH60>3Phd=3@2
7QhN00Dd=3@Q8B4Q8B5SHf=iNGT00Rh^;P06H61P:BTYFUYJFUYJ6QXJE5AD0Te=C@05DE5A=3@d=3@d
GemOK6a/008Y:BT01UEEEChn?TI6ATI6ATE5AG9bLP8];Bd01FMWId=3@cTi>CTi>AhN7P0210@400I_
KfmfMWI8B4Q8B4R2PX9UIFD2=3@d00EEEEDP821GEeMGEeM9BDT00UEEE@06W9bL?Shn8b<S8b<SGEeM
[:b/0]kNgP06;Rh^;bl_VIVIVIVIEUIFYZJV0Y2@T005HF5Q?clo?cloKFe]6a/K008/;2`01T92@Ta<
C1hN7QhN7QDE5F=SH`9dM7@2U9BD0QlO7`05Rh^;<C4a<C4aMgMg/k>c009DE5@01BXZ:_oooooooooo
o`00000?oooo000Goooo0`0000?oool00`000?ooooooo`02oooo00D0003oooooooooooo7alL00ZJV
YP06DU9BTI6A92@T92@T?Cdm8R8R0UADE005G5aLK6a/K6a/Ng]k:b/[009GEeL01Te=CDQ8B9FEUIFE
UClo?eYJFP8h>3P01SLg=eMGEi6ATI6ATE1@D8N7Q`9:BTX01B0P859BDWAdM7AdM55AD@02=3@d00J@
T92PX:0U9BDU9BDc<c<D51@27QhN00I_KflP8219BDU9BDTJ6QYLG5`2<C4a00D^;Rh_;blX:2PX:2RB
TY800SLg=`066a/K?ShnHV9RHV9RN7QhD51@0RXZ:P06MWIfIVIV5aLG5aLG7QhNCDe=0RLW9`05DU9B
@410]kNg]kNgF5QH008l?3`01QhN7SLg=da<C4a<C4I6AWalO08i>CT01Rd];A<C4i^KVi^KVgalO5QH
F08<30`01STi>C8b<UEEEEEEEBDU9DQ8B08I6AT01Bl_;cXj>SXj>V][Je1@D002WIfM00IZJVYSHf=Y
JFUYJFU_Kfld=3@2F5QH00J@T928R8QWIfMWIfMUIFDJ6QX2Jf][00FKVi/c<c<c<c>/[:aMGEd00R@T
9006MWIfPH61?clo?clo9bLWHV9R0TI6AP068b<SCTi>>CTi>CTi20P88b<S0UiNGP05Rh^;61PH^KVi
^KViT92@0099BDT01YbLW3Lg=`h>3Ph>3U]KFi2@T09BDU801Fi^K_ooooooooooo`00000Soooo0`00
00?oool00`000?ooooooo`02oooo00@0003oooooooo6a/H2XJ6Q00EADE6GUiL/;2`/;2a5ADD00SPh
>006J6QXKVi^Kfm_Kfm_GemOAdM70Shn?P06GemO@d=3RHV9RHV9@410Fe]K0SHf=P05<30`Hf=SHf=S
Rh^;DE5A009hN7P01TM7AahN7V5QHF5QHEeMGD92@P8R8R801HB4Q:f][Jf][Bd];CDe=@024a<C00HQ
8B5XJ6PF5QHF5QIGEeLC4a<2EeMG00DR8R8o?clP820P820I6AT00Z6QX@06>CTi9bLWBDU9BDU9FEUI
N7Qh0Ti>CP06:BTYO7alHF5QHF5Q4Q8B71`L0TM7A`058b<SE5ADE5AD=SHf_[jn009ADE401TA4A2h^
;Slo?clo?eaLG5IFEP9_Kfl01CPh>34a<C4a<@h>3YVIV@02O7al00IHF5P<30`e=CDe=CDh>3QBDU82
5aLG00E;Bd/C4a<h>3Ph>3PU9BD00X20P006@T92Zj^[GEeMGEeMMGEeFe]K0VIVIP05;2`/De=CTI6A
TI6ARh^;009QHF401VYZJRLW9f1PH61PH9>CTd=3@`:/[:`01TE5AAhN7UiNGUiNGX^;Rc<c<`8U9BD0
1FYZJU=CDe=CDb`/;5=CD`02>3Ph00H;2`/[:b]PH61PH623Ph<^;Rh2bl_;00FHV9QHF5R7QhN7QhM8
B4P00Pl?3`05@d=3O7alHF5QHF5QNg]k00?oool00`000?ooooooo`0=oooo000Goooo00<0003ooooo
ool00_ooo`030000oooo000000?oool01@000?ooooooooooolO7a`02YZJV00IBDU:ATI4T92@T92@m
?CdR8R82E5AD00ELG5a/K6a/K6akNg/[:b/00UMGE`06CDe=B4Q8UIFEUIFE?cloFUYJ0SPh>006=cLg
EeMGTI6ATI6AD51@QhN70TY:BP05820PDU9BM7AdM7AdDE5A008d=3@01Y2@T:2PX2DU9BDU9C<c<a@D
508N7Qh01Vm_Kb0P84U9BDU9BAXJ6UaLG08a<C401Bh^;Rl_;bPX:2PX:9:BTP02=cLg00HK6a/n?SiR
HV9RHV9hN7Q@D502:RXZ00IfMWIVIVHG5aLG5aLN7Qi=CDd29bLW00EBDU90@42g]kNg]kMHF5P00S`l
?0067QhN=cLgC4a<C4a<ATI6O7al0STi>@06;Bd]4a<CVi^KVi^KO7alF5QH0P`<3006>CTi<S8bEEEE
EEEE9BDUB4Q80QTI6@05;bl_>SXj>SXjJf][D51@00:MWId01VYZJV=SHfUYJFUYJFm_Kc@d=09HF5P0
1Y2@T8R8R6MWIfMWIfEUIAXJ6P9[Jf/01I^KVc<c<c<c<jb/[5eMG@0292@T00IfMWJ1PH4o?clo?clW
9bMRHV82ATI600HS8b=>CThi>CTi>CT820PS8b<2GUiN00F;Rh/H61Ri^KVi^KV@T9000TU9B@06W9bL
=cLg3Ph>3Ph>Fe]KT92@0U9BDP05KVi^oooooooooooo000002?oool00`000?ooooooo`02oooo00<0
003oool000000oooo`040000ooooooooa/K60Z6QX@05DE5AUiNG;2`/;2`/ADE5008h>3P01VQXJ6i^
KVm_Kfm_KemOGdM7A`8n?Sh01UmOGd=3@hV9RHV9RD10@5]KF`8f=SH01C0`<6=SHf=SHh^;Re5AD@02
N7Qh00I7AdLN7QiQHF5QHF5MGEe2@T828R8R00F4Q8B][Jf][Jd];Bde=CD00Q<C4`068B4QJ6QX5QHF
5QHFEeMG4a<C0UMGE`058R8R?clo820P820P6ATI00:QXJ401STi>BLW9dU9BDU9BEUIFGQhN09>CTh0
1RTY:GalO65QHF5QHA8B4Q`L7097AdL01B<S8eADE5ADE3Hf=[jn_P02DE5A00I4A4@^;Rho?clo?cmL
G5aFEUH2Kfm_00Dh>3Pa<C4a<C4>3PjIVIT00WalO006F5QH30`<=CDe=CDe>3PhDU9B0QLG5`05Bd];
4a<C>3Ph>3Ph9BDU00:0P8001T92@Z^[ZeeMGEeMGGEeME]KF`9VIVH01B`/;5=CDi6ATI6ATH^;R`02
HF5Q00IZJVXW9bMPH61PH62CTi=3@d<2[:b/00I5ADDN7QiNGUiNGUj;Rh/c<c<29BDU00EZJVYCDe=C
De</;2aCDe<00SPh>0062`/;:b/[H61PH61PPh>3;Rh^0/_;b`05V9RHF5QHQhN7QhN7B4Q8008?3`l0
1D=3@galO65QHF5QHG]kN`03oooo00<0003oooooool03Oooo`006?ooo`070000oooooooooooo0000
oooo000000?oool200000oooo`:;Rh/01STi>FUYJG9bLW9bLXF5QClo?`8<30`01AlO7b4Q8B4Q8GAd
M1hN7P02AdM700JHV9QaLG5CDe=CDe<Y:BUUIFD2ADE500IZJVZ9RHURHV9RHV8a<C5^KVh2E5AD00D_
;blZ:RYoOgmoOgle=CD00WAdM0068R8R<30`IfMWIfMW?Cdm;Rh^0SPh>006EEEEWinO6a/K6a/K=cLg
IfMW0Ti>CP05D51@B4Q8=SHf=SHfF5QH00:TY:@01VQXJ5mOGdM7AdM7AbTY:HB4Q08Q8B401S<c<hn?
Sbd];Bd];H61PCDe=@8h>3P01APH67AdM8F5QHF5QD=3@`02QXJ600Hf=SI;Bd]YJFUYJFTK6a^9RHT2
L71`00IUIFECDe=ADE5ADE6?Shm4A4@2EUIF00H`<31GEeMhN7QhN7Q5ADEGEeL2@T9200DY:BTJ6QXJ
6QY3@d=5ADD00R/[:`06<C4aF5QHKFe]KFe]<C4aV9RH0fa/K0058b<SKfm_Kfm_[jn_<C4a008O7al0
1JFUYChn?Shn?XV9RBd];@02A4A400HU9BEnOWh61PH61PJ1PH66QXH2LG5a00IEEEE/K6`D51@D51@8
20PB4Q82Hf=S00Dl?3aOGem/K6a/K6cQhN400T92@P06IfMWTY:BN7QhN7QhB4Q8eMGE0/o?c`03TY:B
oooooooo0080000Toooo00L0003oooooooooool0003oool000000oooo`800002oooo0WemO@05@D51
NWYjM7AdM7AdLg=c009CDe<01QHF5R@T91/K6a/K6fe]K@h>3P9QHF401YJFUXj>STm?Cdm?Cc/k>eEE
E@96ATH01EaLG8>3Ph>3Pe1@D1dM7@02GUiN00Hg=cM1@D4o?clo?cm/K6`I6AT2Hf=S00DR8R93@d=3
@d=aLG57AdL00S8b<P06;bl_EUIFT92@T92@9BDUBd];0U5AD@05IVIV>SXj@410@410;Bd]009HF5P0
1[:b/VMWIf=SHf=SHdE5ABXZ:P:9RHT01R<S8cDe=Hj>SXj>SRDU9GQhN08c<c<01CTi>B0P820P875a
LHN7Q`02@T9200J;Rh/a<C5BDU9BDU9ZJVXQ8B42TI6A00E[Jf]XJ6QXJ6QEEEE:BTX00X^;R`06?Cdm
GUiN<S8b<S8bE5ADO7al0T51@@05De=C?clo9RHV9RHV7alO009>CTh01SXj>SHf=Rh^;Rh^;UQHF5aL
G092@T801HZ:RVYZJW]kNg]kNbHV9P02N7Qh00J/[:`b<S8Q8B4Q8B6UYJE3@d<2R8R800HR8R8l?3`b
<S8b<S9oOglA4A42Kfm_00FMWIeVIVIVIVI4A4AoOgl00P<30`063@d=7AdMHf=SHf=S=SHfFEUI0VYZ
JP05kno_ADE5FUYJFUYJRHV900:7QhL01D];BkRh^>c/k>c/k:RXZ002oooo0P0000ooool001Soool0
1`000?ooooooooooo`000?ooo`000003oooo00<0003oooooool00_ooo`;fm_H01TE5AIVIVDi>CTi>
CWUiNFQXJ09hN7P01J2PX1/K6a/K6a@D51`L70023`l?00I>CTkFe]H^;Rh^;RijNWYIFET2S8b<00K8
b<Q:BTZ_[jn_[jmIFEURHV82N7Qh00DX:2PC4a=PH61PH60S8b<00VATI006@D51Hf=SRh^;Rh^;:2PX
CDe=0W9bLP06=3@dooooC4a<C4a<61PH71`L0RHV9P05EUIF7alO@410@410AdM7009GEeL01R4Q8BLW
9fQXJ6QXJ410@7YjNP8?3`l01S<c<d51@CXj>SXj>WIfMUADE08l?3`01ATI6BPX:5ADE5ADE5EEE@02
F5QH00I2@T8W9bM6ATI6ATIeMGDe=CD2;Rh^00Hn?Si1@D6FUYJFUYHS8b=HF5P2@d=300Hb<S8820P^
;Rh^;RhO7am@D502C4a<00E0@40U9BDU9BDF5QIQHF400PD51@06C4a<CTi>7AdM7AdMATI6HF5Q0STi
>@036QXJ?ShnG5aL009LG5`013Hf=R@T92@T96i^KP9EEED01VMWIdI6ARPX:2PX:<c<c5MGE`:FUYH0
1XF5QDE5AFATI6ATI5IFERh^;P98B4P01R4Q8A/K6dm?Cdm?Ce1@D3Xj>P91@D401Ooooc0`<30`<7in
OVIVIP02];Bd00EBDU9?CdmJFUYJFUZSXj<00oooo`030000oooooooo02;oool01`000?oooooooooo
o`000?ooo`000003oooo00@0003oooooooooool2h>3P00E<C4bk^k]TI6ATI6ANGUh00Xn?S`06Jf][
YZJV<C4a<C4a;Bd]>SXj0Q4A4@06BDU9e]KF@d=3@d=3IFEUIVIV0WUiN@05YjNW:b/[:b/[RHV9FUYJ
009>CTh01XZ:RTM7AaLG5aLG5dm?Cd10@097AdL01DI6AVQXJ6QXJ8R8R3/k>`02FEUI00IOGem4A4Co
oooooom@D50K6a/25ADE00DS8b=DE5@D51@D51@Z:RX00UQHF006J6QX5ADE<S8b<S8bIVIV>CTi0WQh
N006410@<c<c@T92@T92=3@dLg=c0U]KF`05@D514a<C4a<C9RHVFEUI009BDU801UYJFShn?R4Q8B4Q
8Chn?WmoO`94A4@01AlO7de=CDe=CC4a<H61P@027QhN00I9BDUCDe<k>c/k>c/E5ADV9RH2820P00E<
C4a;Bd/g=cLg=cLS8b<00Pl?3`06D51@5QHFGEeMGEeM=CDe3@d=0UYJFP05D51@A4A4;Rh^;Rh^BDU9
009XJ6P01UIFESTi>B@T92@T979bLU=CD`9OGel01U1@D1/K6mGEeMGEeEMGEiJFUP9nOWh01E5ADEiN
GUiNGTi>CSTi>@02?3`l00H_;blC4a=QHF5QHF5?Cdm5ADD2=SHf00GooolL71b:RXZ:RXYXJ6P00[6a
/@9CDe<2Hf=S00FVYZKoooooooooool000003oooo`005oooo`030000oooo000000;oool00`000?oo
o`000003oooo00<0003oooooool00_ooo`8H61P01YVIVI>CTcPh>3Ph>4E5AFEUI@8B4Q801@h>3Ta<
C4a<C7YjNRPX:002;bl_00HM7Afg]kLL71`L71cGemMNGUh28b<S00J:RXXM7AeIFEUIFETa<C5gMgL2
Ogmo00E1@D5lO7aUIFEUIFElO7`00Tm?C`06[jn_AdM7BTY:BTY:IVIV20P80Xb<S006>c/kSXj><30`
<30`4Q8B:BTY0T92@P05CTi>Bd];8b<S8b<S:2PX008S8b<01SLg=gYjNV][Jf][Ja/K6dm?C`8/;2`0
1UYJFP/;2d];Bd];BgEeMHV9R@9GEeL01FQXJ4Q8B4m?Cdm?CfYZJP02TY:B00J1PH5ADE4G5aLG5aN@
T91VIVH2LG5a00HY:BTX:2QXJ6QXJ6Q=CDeFEUH29RHV00H>3Pi8B4Pl?3`l?3`W9bL_;bl27alO00D`
<30[:b/[:b]@D51IFET00T51@@06=CDe7AdMDe=CDe=C>3Ph@4100S4a<@06HF5QWYjNR8R8R8R8D51@
LW9b0Vi^KP05<C4a?Shn?Shn<c<cM7Ad009fMWH01VATI0T92E=CDe=CDb`/;6m_K`9/K6`01RHV9TA4
A3Lg=cLg=cPh>0d=3@8];Bd01Hj>SX20P8N7QhN7QhJ6QP02BDU900I@D50X:2QkNg]kNg^?Shl<30`2
MGEe00F@T93oooooooooool000008oooo`030000oooo000000;oool00`000?ooo`000003oooo00@0
003oooooooooool22@T900F=SHfXZ:PN7QhN7Qh^;Rh00Ta<C006;Bd];2`/Hf=SHf=SH61P>CTi0b4Q
8@05Zj^[51@D51@DalO7DU9B008=3@d01GYjNQ8B4Q8B4VQXJ1HF5P02I6AT00JEUIEJFUYkNg]kNg]/
K6aZJVX2ADE500F][Je=CDe=CDe6ATIfMWH00PX:2P06NWYj>3PhTi>CTi>C7QhN2PX:0SHf=P05>3Ph
CTi>D51@D51@8B4Q008/;2`01RHV9S8b<WQhN7QhN6i^KQPH609ADE401S<c<e=CDa8B4Q8B4T=3@gem
O@:9RHT01EIFEV1PH61PH3hn?U=CD`02IfMW00J<S8b3Ph=BDU9BDU8E5AF?Shl2Lg=c00ESHf<g=cLg
=cLD51A?Cdl00UIFEP06@d=3@D519bLW9bLWEeMG<c<c0Rh^;P05:RXZ71`L;2`/;2`/7alO0090@400
1UMGEcXj>UADE5ADE2TY:Clo?`9FEUH01Cdm?DQ8B5MGEeMGEifMW@02TI6A00I>CTiaLG5eMGEeMGDh
>3Q1@D42;Rh^00IZJVZ;Rh]iNGUiNGTM7AeHF5P2;Rh^00EeMGENGUiNGUhP8218B4P00SLg=`06>c/k
5aLG9bLW9bLWXj>STi>C0WIfMP05KVi^H61PCDe=CDe=>SXj009ZJVX01I6ATA@D57]kNg]kNiNGU`03
oooo00<0003oooooool03Oooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`8H61P01YVIVI>CTcPh>3Ph>4E5AFEUI@8B4Q801@h>3Ta<C4a<C7YjNRPX:002
;bl_00HM7Afg]kLL71`L71cGemMNGUh28b<S00J:RXXM7AeIFEUIFETa<C5gMgL2Ogmo00E1@D5lO7aU
IFEUIFElO7`00Tm?C`06[jn_AdM7BTY:BTY:IVIV20P80Xb<S006>c/kSXj><30`<30`4Q8B:BTY0T92
@P05CTi>Bd];8b<S8b<S:2PX008S8b<01SLg=gYjNV][Jf][Ja/K6dm?C`8/;2`01UYJFP/;2d];Bd];
BgEeMHV9R@9GEeL01FQXJ4Q8B4m?Cdm?CfYZJP02TY:B00J1PH5ADE4G5aLG5aN@T91VIVH2LG5a00HY
:BTX:2QXJ6QXJ6Q=CDeFEUH29RHV00H>3Pi8B4Pl?3`l?3`W9bL_;bl27alO00D`<30[:b/[:b]@D51I
FET00T51@@06=CDe7AdMDe=CDe=C>3Ph@4100S4a<@06HF5QWYjNR8R8R8R8D51@LW9b0Vi^KP05<C4a
?Shn?Shn<c<cM7Ad009fMWH01VATI0T92E=CDe=CDb`/;6m_K`9/K6`01RHV9TA4A3Lg=cLg=cPh>0d=
3@8];Bd01Hj>SX20P8N7QhN7QhJ6QP02BDU900I@D50X:2QkNg]kNg^?Shl<30`2MGEe00F@T93ooooo
ooooool000009?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00@0003oooooooooool2
2@T900F=SHfXZ:PN7QhN7Qh^;Rh00Ta<C006;Bd];2`/Hf=SHf=SH61P>CTi0b4Q8@05Zj^[51@D51@D
alO7DU9B008=3@d01GYjNQ8B4Q8B4VQXJ1HF5P02I6AT00JEUIEJFUYkNg]kNg]/K6aZJVX2ADE500F]
[Je=CDe=CDe6ATIfMWH00PX:2P06NWYj>3PhTi>CTi>C7QhN2PX:0SHf=P05>3PhCTi>D51@D51@8B4Q
008/;2`01RHV9S8b<WQhN7QhN6i^KQPH609ADE401S<c<e=CDa8B4Q8B4T=3@gemO@:9RHT01EIFEV1P
H61PH3hn?U=CD`02IfMW00J<S8b3Ph=BDU9BDU8E5AF?Shl2Lg=c00ESHf<g=cLg=cLD51A?Cdl00UIF
EP06@d=3@D519bLW9bLWEeMG<c<c0Rh^;P05:RXZ71`L;2`/;2`/7alO0090@4001UMGEcXj>UADE5AD
E2TY:Clo?`9FEUH01Cdm?DQ8B5MGEeMGEifMW@02TI6A00I>CTiaLG5eMGEeMGDh>3Q1@D42;Rh^00IZ
JVZ;Rh]iNGUiNGTM7AeHF5P2;Rh^00EeMGENGUiNGUhP8218B4P00SLg=`06>c/k5aLG9bLW9bLWXj>S
Ti>C0WIfMP05KVi^H61PCDe=CDe=>SXj009ZJVX01I6ATA@D57]kNg]kNiNGU`03oooo00<0003ooooo
ool03Oooo`008_ooo`030000oooooooo00;oool2S8b<00Hm?Cdj>SZ9RHV9RHT_;bmmOGd271`L00E5
ADDA4A4A4A5OGell?3`00UIFEP06LW9bEUIFHf=SHf=Soooo92@T0RLW9`06F5QH8b<S]kNg]kNgAdM7
HF5Q0UADE005GEeMLW9bTI6ATI6AOWin008S8b<01Y:BTUYJFU]KFe]KFadM7EYJFP9eMGD01UQHF3dm
?Chn?Shn?TI6AShn?P8<30`01C<c<eeMGBDU9BDU9EEEE@02D51@00HJ6QZ:RXYHF5QHF5Q/K6`V9RH2
;Rh^00IMGEd/;2aNGUiNGUhK6a][Jf/2EEEE00EbLW8a<C4H61PH61Po?cl00Shn?P06=3@d6ATI?Cdm
?Cdm:b/[E5AD0WalO006[jn_?Cdm;2`/;2`/KFe]=SHf0S4a<@06Hf=S8b<SB4Q8B4Q8<S8b>CTi0U=C
D`05H61P:2PX:2PXCDe=<c<c009PH6001XB4Q4a<C61PH61PH3De=ADE5@93@d<01ZJVYX>3Ph:2PX:2
PU9BDUADE08R8R801D10@0/;2`/;2dQ8B38b<P0230`<00IRHV96ATJ5QHF5QHFd];@D51@2Bd];00HU
9BE8B4QcLg=cLg<a<C4B4Q8230`<00F4Q8BDU9B5QHF5QHELG5`00QlO7`06EeMGN7QhATI6ATI6UYJF
@d=30W9bLP05UIFEoooooooooooo000002koool010000?ooooooooooo`:1PH401C4a<CDe=H>3Ph>3
PaTI6@02Hf=S00HP821HF5P71`L71`M]KFdn?Sh2De=C00IVIVIMGEeQHF5QHF7ooolM7Ad2<S8b00E:
BTXe=CDe=CG9bLU9BDT00WQhN006D51@FUYJRh^;Rh^;Ng]kRXZ:0S4a<@05TY:BDE5ADE5AEUIF6ATI
009PH6001V][Jdi>CTa<C4a<C2`/;5YJFP90@4001B8R8S4a<DU9BDU9BA<C4`02FUYJ00IADE4J6QZC
Ti>CTi=JFUYXJ6P2;2`/00H`<31GEeLg=cLg=cMFEUHN7Qh2LG5a00E7AdMiNGUiNGTU9BD:2PX00TA4
A006=CDe<c<c71`L71`L?Shn;2`/0UQHF005MWIf]KFe]KFe?Shn8b<S009/K6`01STi>BDU9G5aLG5a
LBl_;de=C@8X:2P01Cdm?E9BDV=SHf=SHbHV9P02C4a<00Hn?SiGEeNCTi>CTi=ADE5KFe/2=cLg00DC
4a=BDU:JVYZJVYZ>SXh00WUiN@06CTi>GEeM;Bd];Bd]@D511PH60SPh>006=cLg7QhNLW9bLW9b=CDe
UYJF0ZVYZ@053`l?BTY:BTY:;Bd]@D51009_Kfl01Shn?Q/K6ahN7QhN7YFEUJRXZ09^KVh01F=SHbh^
;TA4A4A4A8J6QP02>CTi00F:RXY;Bd]^KVi^KVjCTi<00oooo`030000oooooooo00goool002;oool0
0`000?ooooooo`04oooo00?alO66QXHd=3@00S@d=004O7alM7AdM7Ad?3`l0R0P8006D51@<c<cC4a<
C4a<1PH69RHV0Slo?`06RHV9:b/[UIFEUIFECTi>H61P0ZRXZ006XJ6QOWin5ADE5ADECTi>E5AD0X20
P005GUiN>CTi>CTi820PT92@009VIVH01Q<C4c0`<34a<C4a<@h>3Zn_[`99BDT01SHf=STi>C4a<C4a
<B8R8VEUI@8`<3001EiNGV=SHf=SHdU9BDm?C`02B4Q800I6ATI[Jf]3@d=3@d=TI6@=3@d2:2PX00Hl
?3ahN7P?3`l?3`lR8R8d=3@2KVi^00EYJFV=SHf=SHdo?cm=CDd00UUIF@06E5AD=cLgEEEEEEEEH61P
G5aL0Sdm?@06ATI6;bl_?Shn?Shn@D51Bd];0QdM7@059bLWDe=C8b<S8b<S9RHV0095ADD01YnOWc/k
>hR8R8R8R55ADJ6QX@9BDU801Y:BTVIVISPh>3Ph>3Hf=Pd=3@8H61P01EMGEfATI5EEEEEEEFMWI`02
MWIf00ISHf=IFETI6ATI6AU1@D5BDU82KFe]00HI6ATU9BD_;bl_;bm0@40l?3`2F5QH00H/;2`c<c<V
9RHV9RHe=CE4A4@2KVi^00EVIVI:BTY:BTZOWimMGEd00Ve]K@05HV9RK6a/GUiNGUiNQHF500?oool0
0`000?ooooooo`0/oooo00<0003oooooool00oooo`05lO7aOGem<30`<30`B4Q8009`L7001XF5QDU9
BA/K6a/K6eeMGBl_;`93@d<01Q`L71dM7D10@410@9jNWT=3@`9mOGd01F5QHDY:BTY:B/30`9jNWP02
UIFE00HI6AUADE5UIFEUIFE[Jf]cLg<28b<S00D>3Pj:RXZ:RXYGEeLG5aL00S8b<P06>SXj10@4];Bd
];BdB4Q8@4100T=3@`058b<S4Q8BDe=CDe=C:b/[009[Jf/01U9BDUMGEe]KFe]KFdA4A3lo?`9`L700
1TI6AUmOGa8B4Q8B4R<S8c<c<`9nOWh01AHF5R0P820P8410@65QH@02L71`00J:RXXh>3QKFe]KFe]V
IVI9BDT2?3`l00E9BDUKFe]KFe]XJ6Pa<C400S/k>`06;bl_Bd];?3`l?3`lATI63Ph>0S0`<005@d=3
71`L:BTY:BTY@T9200:YZJT01S0`<8f=SE=CDe=CDiZJVTA4A0:RXZ801EUIFB/[:c`l?3`l?0820P02
8R8R00IJFUYTI6AOGemOGem`L71VIVH2E5AD00ILG5`@410[:b/[:b]?CdmiNGT2:RXZ00Dd=3@Y:BTY
:BTm?Cdl?3`00UeMG@04<c<c@T92<C4a<C4a0S<c<`9/K6`01H>3PeiNGXV9RHV9REYJFP02FEUI00EQ
HF5YJFU[Jf][Jf^DU9@00oooo`030000oooooooo00goool002;oool010000?ooooooooooo`=oOgl0
1TM7AcHf=Sdm?Cdm?H^;RbDU9@:?Shl01KZj^YJFUYJFURPX:7AdM002?Cdm00IVIVI8B4Pf=SHf=SJ=
SHeXJ6P2=3@d00IEEEE6ATHg=cLg=cNMWIe2@T82<S8b00E3@d<I6AT@410@410i>CT00Slo?`06;bl_
7QhN@D51@D51AdM76a/K0VMWI`069bLWDe=CBd];Bd];=cLg:BTY0Q`L7005IFEU6ATIBd];Bd];EEEE
00:CTi<01SPh>4=3@g9bLW9bLSTi>C4a<@9`L7001UUIFAhN7Q<C4a<C4aDE5FUYJ@9PH6001I>CTclo
?c8b<S8b<S@d=0020`<300Hh>3Pn?Sh`<30`<327QhMfMWH2IfMW00H>3PiRHV95ADE5ADDk>c/[:b/2
De=C00K5aLFBTY9bLW9bLW9/K6b7QhL20`<300DH61P`<30`<31[Jf/K6a/00PX:2P06@D51=3@dDe=C
De=CP820BDU90UiNGP06QXJ6ADE5DU9BDU9B4a<C9BDU0YFEU@05<S8b6ATI6ATIR8R8;2`/009hN7P0
1T92@UMGEeYJFUYJFS0`<492@P9NGUh01T51@C@d=2/[:b/[:b0P89>CT`:3Ph<01BPX:?OgmcDe=CDe
=Kjn_P02A4A400I9BDV?ShlR8R8R8R:8R8P92@T2MGEe00Fm_Kgoooooooooool00000;_ooo`030000
oooooooo00>HV9P01D];Bc`l?3Hf=SHf=Z>SX`02EeMG00IHF5Sdm?AOGemOGemNGUi3@d<2CDe=00Ih
N7Q7AdM;Bd];Bd^LW9aaLG42;2`/00E2@T8S8b<S8b<O7an^[Zh00UEEE@06BTY:EUIF<C4a<C4a;2`/
8B4Q0TE5A@058B4Q5ADE5ADE=cLgDU9B008W9bL01VQXJ2l_;eaLG5aLG4m?CbXZ:P8S8b<01ADE5FMW
IbLW9bLW9eUIF@02CDe=00J=SHe5ADE>CTi>CTiTI6A0@402@T9200J1PH5BDU8Z:RXZ:RX;2`/M7Ad2
I6AT00EQHF6KVi^KVi/i>CTe=CD00R8R8P0661PH92@TDU9BDU9B9RHVY:BT0V5QH@05KFe]9BDU9BDU
DE5ABTY:008i>CT01RPX:5EEEKjn_[jn_Z>SXfUYJ@9cLg<01G9bLQ/K6a<C4a<C4d51@@02JVYZ00HI
6ATH61P`<30`<318B4Pn?Sh2VIVI00D^;Ri8B4QmOGemOGeRHV800S`l?0065QHF6a/KT92@T92@=3@d
3Ph>0W=cL`064A4AQ8B4?clo?cloDe=C>CTi0R8R8P05<30`EeMGEeMGBTY:7alO008j>SX01R8R8Z>S
Xg5aLG5aLD10@=?Cd`9JFUX01M3@d30`<79bLW9bLU9BDP02F5QH00FMWIdg=cN5QHF5QHGKfm/00ooo
o`030000oooooooo00goool002;oool200000_ooo`=oOgl01TM7AcHf=Sdm?Cdm?H^;RbDU9@:?Shl0
1KZj^YJFUYJFURPX:7AdM002?Cdm00IVIVI8B4Pf=SHf=SJ=SHeXJ6P2=3@d00IEEEE6ATHg=cLg=cNM
WIe2@T82<S8b00E3@d<I6AT@410@410i>CT00Slo?`06;bl_7QhN@D51@D51AdM76a/K0VMWI`069bLW
De=CBd];Bd];=cLg:BTY0Q`L7005IFEU6ATIBd];Bd];EEEE00:CTi<01SPh>4=3@g9bLW9bLSTi>C4a
<@9`L7001UUIFAhN7Q<C4a<C4aDE5FUYJ@9PH6001I>CTclo?c8b<S8b<S@d=0020`<300Hh>3Pn?Sh`
<30`<327QhMfMWH2IfMW00H>3PiRHV95ADE5ADDk>c/[:b/2De=C00K5aLFBTY9bLW9bLW9/K6b7QhL2
0`<300DH61P`<30`<31[Jf/K6a/00PX:2P06@D51=3@dDe=CDe=CP820BDU90UiNGP06QXJ6ADE5DU9B
DU9B4a<C9BDU0YFEU@05<S8b6ATI6ATIR8R8;2`/009hN7P01T92@UMGEeYJFUYJFS0`<492@P9NGUh0
1T51@C@d=2/[:b/[:b0P89>CT`:3Ph<01BPX:?OgmcDe=CDe=Kjn_P02A4A400I9BDV?ShlR8R8R8R:8
R8P92@T2MGEe00>m_Kgoooooool00P0002koool2000000KooonHV9RHV9RHV9Q;Bd/l?3`2=SHf00FS
Xj=GEeMGEeMHF5Sdm?@00UmOG`06GUiN@d=3CDe=CDe=N7QhAdM70T];B`05W9bLLG5a;2`/;2`/@T92
008S8b<01QlO7jj^[UEEEEEEEDY:BUIFEP8a<C401B`/;24Q8DE5ADE5AB4Q8@025ADE00Hg=cMBDU8W
9bLW9bMXJ6P_;bl2G5aL00I?CdlZ:RXS8b<S8b<E5AEWIfL29bLW00EIFEU=CDe=CDf=SHe5ADD00Ti>
CP06I6AT@410@T92@T92PH61DU9B0RXZ:P052`/;7AdMI6ATI6ATHF5Q00:KVi/01STi>CDe=B8R8R8R
8QPH62@T909BDU801BHV9ZBTY65QHF5QHFe]K@029BDU00IADE5:BTXi>CTi>CTX:2QEEED2_[jn00JS
Xj=YJFUcLg=cLg=bLW8K6a/24a<C00E1@D5ZJVYZJVXI6ATH61P00S0`<006B4Q8?ShnVIVIVIVI;Rh^
B4Q80WemO@05HV9R?3`l?3`l5QHF6a/K00:@T9001S@d=0h>3W=cLg=cLa4A4HB4Q08o?cl01E=CDcTi
>B8R8R8R8S0`<002EeMG00I:BTXO7alj>SXj>SXR8R:SXj<2LG5a00I0@43Cdm=JFUYJFU[@d=0`<302
LW9b00EBDU9HF5QHF5RMWIdg=cL00XF5Q@03fm_Koooooooo0080000?oooo000Roooo00<0003ooooo
ool00_ooo`;[jn/01YVIVE5ADF=SHf=SHbl_;aDE5@9HF5P01HZ:RR`/;2`/;4U9BInOW`029BDU00Il
O7a;Bd]=CDe=CDeJFUY]KFd2R8R800I4A4B3Ph=GEeMGEeMaLG4R8R82;Bd]00E8B4P?3`lE5ADE5AE>
CTh00Slo?`069BDU30`<20P820P87AdM6QXJ0Tm?C`068b<S8B4QGUiNGUiNBTY::BTY0STi>@058b<S
1`L7Fe]KFe]K;Bd]009aLG401Ve]KC0`<5YJFUYJFSXj>R@T908P82001UUIFDi>CWalO7alO4=3@eQH
F08Q8B401E1@D4U9BCDe=CDe=JJVYP02>3Ph00HH61QhN7Q;Bd];Bd/61PHl?3`2>3Ph00IGEeL`<30V
9RHV9RICDe>j^[X2?Shn00He=CEWIfN@T92@T90l?3`X:2P2=3@d00ECDe<o?clo?cmBDU99BDT00T51
@@06RHV95QHFC4a<C4a<GEeM=CDe0PX:2P06Ogmo:2PX=SHf=SHfPh>3Bd];0U=CD`05Lg=cH61PH61P
DE5A=SHf00:EUID01WQhN69RHZFUYJFUYC8b<V1PH09ADE401QXJ6SLg=gIfMWIfMVEUIC8b<P8S8b<0
1GmoOeiNGVYZJVYZJWemO@02W9bL00I>CTibLW9iNGUiNGWEeMDc<c<2Ph>300G7alOoooooooooool0
0000;_ooo`040000oooooooooooo0]_Kf`05WinOEeMGHV9RHV9R@d=3008e=CD01S8b<Xb<S1@D51@D
51`L77EeM@8:2PX01XB4Q4A4A5aLG5aLG4M7Ag=cL`:?Shl01DE5AH61PH61PE9BDWalO002820P00Hg
=cMJFUXH61PH61P/;2aOGel2:RXZ00Di>CT61PH61PH<30`X:2P00QTI6@06AdM792@T6QXJ6QXJHV9R
@D510Q@D5005B4Q8=SHf5QHF5QHFIVIV008U9BD01WMgMh20P3Xj>SXj>U5ADCDe=@8];Bd01S0`<5iN
GUADE5ADE6i^KR/[:`9UIFD01B`/;6m_Kfm_KeUIFAlO7`02XZ:R00I6ATHN7Qi`L71`L71BDU8410@2
<C4a00Dj>SYUIFEUIFDP820b<S800UmOG`06]KFeDE5A@410@410Fe]KQhN70Slo?`05;2`/<S8bEEEE
EEEE@T92009?Cdl01DE5AD=3@gUiNGUiNAlO7`03H61P00Dm?Cd<30bFUYJFUYHK6a/00SXj>P06MgMg
Cdm?De=CDe=CNWYjDe=C0T10@006C4a<NWYjXJ6QXJ6QRh^;Q8B40TA4A005;bl_;Bd];Bd]6QXJ8b<S
009RHV801W1`L34a<B/[:b/[:gEeMEeMG@=>CTh01;Bd]3/k>c/k>c/k>`:KVi/01OCdm5MGEjRXZ:RX
Z<W9b@03oooo00<0003oooooool03Oooo`008_ooo`030000oooooooo00;oool2Lg=c00ImOGgIfMTZ
:RXZ:RXG5aM3@d<2<S8b00G?clm<C4a<C4`S8b>SXj<00Pd=3@06MGEe<30`:BTY:BTYEUIF9bLW0YNG
U`06EeMGIfMW8R8R8R8R6a/KFUYJ0V5QH@059RHVOGemW9bLW9bLHF5Q008m?Cd01S/k>dY:BRh^;Rh^
;QdM7A`L708f=SH01QDE5GQhN6i^KVi^KUiNGS<c<`8J6QX01C4a<AXJ6Ph>3Ph>3X>3P`02D51@00Ic
Lg<j>SXl?3`l?3`W9bM9BDT2PX:200H`<31`L71FEUIFEUI8B4Q7AdL27AdM00De=CDF5QI_Kfm_Kfm:
BTX00R0P8006ATI6O7al>3Ph>3Ph7AdM;bl_0XJ6QP06D51@BTY:NWYjNWYj9bLWEeMG0U]KF`06N7Qh
_;blJFUYJFUYG5aLHf=S0S@d=005?Shn=3@d=3@d@D51410@009YJFT01T92@RTY:Bl_;bl_;c/k>hf=
S@9^KVh01T=3@de=CD];Bd];BfYZJU1@D095ADD01C<c<aDE5ADE5EiNGQLG5`02A4A400Ho?cmhN7QM
GEeMGEe7AdL`<302Ogmo00I7AdL92@UeMGEeMGE9BDUBDU82P82000EkNg]fMWHO7alO7an=SHd00STi
>@068R8RFe]KIVIVIVIVU9BDJ6QX0UeMG@05[jn_oooooooooooo000002koool010000?oooooooooo
o`9fMWH01I6ATL71`CHf=SHf=Q<C4`029bLW00IIFEVXZ:PZ:RXZ:RXQ8B6?Shl27AdM00IgMgL^;Rhe
=CDe=CE5ADDk>c/2R8R800E]KFeiNGUiNGT^;Rhb<S800Ve]K@06De=C7QhNPH61PH61VIVIIVIV0Sdm
?@05<30`EEEEEEEE8b<S410@008Z:RX01R/[:alO7fa/K6a/K7emODm?C`8g=cL01A4A4B4Q8B@T92@T
91dM7@02OWin00IIFEUgMgLh>3Ph>3Pm?Cd`<302?clo00JGUiLY:BUJFUYJFUY3@d</;2`2@D5100DA
4A55ADE5ADD820QhN7P00T51@@064a<C>SXjPX:2PX:2=3@d4a<C0TI6AP05KFe]>3Ph>3PhH61PIVIV
008E5AD01U]KFfYZJX:2PX:2PZ^[Zf9RHP95ADD01EIFEU1@D5QHF5QHF3Lg=`02A4A400HH61Q]KFe0
@410@40Z:RXj>SX2CDe=00FHV9QEEEEGEeMGEeLl?3`00UEEE@06PH61@d=3DU9BDU9B>3Ph7AdM0U9B
DP06:2PX9BDUDE5ADE5AWYjNQ8B40TY:BP053`l?JFUYJFUYGUiN3`l?009cLg<01T92@T=3@iBDU9BD
U820P7UiN@9<C4`01Fa/K1XJ6Rh^;Rh^;TY:BP02FUYJ00FLW9ahN7Q^KVi^KVj`/;000oooo`030000
oooooooo00goool002;oool00`000?ooooooo`02oooo0[6a/@061@D5Q8B4:2PX:2PX=CDe9RHV0UIF
EP05[Jf]OGemOGemOWin?3`l009=CDd01Z>SXbl_;b/[:b/[:aTI6D];B`98B4P01RTY:E=CDfYZJVYZ
JVa/K2h^;P9RHV801FIVITM7Ah20P820P?;blP02RHV900HG5aLZ:RY>CTi>CTh@410k>c/2E5AD00I9
BDT^;RioOgmoOgl>3Pi?Cdl2ADE500DU9BDW9bLk>c/k>c]@D5000SXj>P059BDU;Bd]5QHF5QHF820P
00</;2`01RPX:2`/;3Ti>CTi>DM7AbDU9@9VIVH01HV9RHZ:RVIVIVIVIZ2PX002Lg=c00I_Kflj>SXC
4a<C4a=dM7@V9RH2?3`l00HZ:RXG5aNATI6ATI4e=CE`L702?3`l00HY:BT;2`];Bd];Bd^@T91]KFd2
<30`00FDU9ABDU9BDU99BDTR8R800SXj>P06D51@8b<SBDU9BDU9<c<cJf][0VATI006SHf==cLg@410
@410HV9RBd];0WEeM@05LG5aHF5QHF5Q<S8b<30`009[Jf/01QXJ6S@d=6UYJFUYJClo?e1@D08;2`/0
1R4Q8BHV9Rl_;bl_;h^;RfATI09fMWH01F][J`820WEeMGEeMDM7A`02EeMG00HT92@=3@dj>SXj>SZG
UiNd];@26QXJ1?ooo`030000oooooooo02coool010000?ooooooooooo`:c/k<01@d=3HJ6QQ`L71`L
74U9B@02>CTi00I5ADFc/k=WIfMWIfM[Jf]=CDd2@T9200JYZJTh>3Pd=3@d=3@N7Qi2@T82>c/k00De
=CELG5aLG5aaLG5ZJVX00SDe=@06GemOIVIVAdM7AdM7NGUimOGe0Xj>SP056ATI?Shn?Shn@T927alO
008Y:BT01VUYJEQHF1XJ6QXJ6WQhN1/K6`9MGEd01Dm?CahN7Q@D51@D54i>CP02GEeM00H^;RhK6a]5
ADE5ADD?3`lB4Q82410@00I9BDT_;blC4a<C4a<P8212@T82>c/k00ECDe>HV9RHV9R1PH5VIVH00YbL
W006MGEeJ6QXADE5ADE51PH6R8R80Ph>3P0592@T:2PX:2PX9RHVTI6A008X:2P01WQhN3dm?BPX:2PX
:0/;2dM7A`:<S8`01FQXJ3Xj>YnOWinOWeIFEP02EEEE00HI6AU0@41@D51@D50[:b]>CTh2>SXj00Ed
M7ACDe>1PH61PH5:BTX00TA4A006IfMWEeMGKFe]KFe]Lg=cGUiN0RXZ:P06?3`lKfm_<c<c<c<c9BDU
Lg=c0R<S8`05D51@92@T92@T410@>3Ph008a<C401X:2PVa/K7AdM7AdM6e]KA@D509KFe/01B`/;59B
DT92@T92@RDU9@02D51@00B8R8S8b<PN7QhN7Qh4oooo00<0003oooooool03Oooo`008_ooo`030000
oooooooo00;oool2/K6a00H51@F4Q8@X:2PX:2Pe=CDV9RH2EUIF00F][JemOGemOGenOWhl?3`00Te=
C@06Xj>S;bl_:b/[:b/[6ATIBd];0TQ8B006:BTYDe=CJVYZJVYZK6a/;Rh^0V9RHP05IVIVAdM7P820
P820l_;b00:9RHT01QLG5bXZ:Ti>CTi>CQ0@43/k>`9DE5@01TU9BBh^;WmoOgmoO`h>3Tm?C`95ADD0
1BDU9BLW9c/k>c/k>e1@D002>SXj00DU9BD];BdF5QHF5QHP82000b`/;006:2PX;2`/>CTi>CTiAdM7
9BDU0VIVIP05RHV9RXZ:IVIVIVIVX:2P009cLg<01Vm_KcXj>Q<C4a<C4gAdM2HV9P8l?3`01RXZ:QLG
5i6ATI6ATCDe=G1`L08l?3`01RTY:@/;2d];Bd];Bi2@T6e]K@8`<3001IBDU59BDU9BDTU9BB8R8P02
>SXj00I@D50S8b=9BDU9BDTc<c=[Jf/2I6AT00J=SHdg=cM0@410@41RHV9;Bd/2MGEe00EaLG5QHF5Q
HF4b<S8`<3000V][J`066QXJ=3@dJFUYJFUY?cloD51@0P/;2`068B4Q9RHV;bl_;bl_Rh^;I6AT0WIf
MP05Jf][0P82MGEeMGEeAdM7009GEeL01R@T90d=3CXj>SXj>YNGUkBd]08J6QX4oooo00<0003ooooo
ool0;?ooo`040000oooooooooooo0[>c/`053@d=QXJ671`L71`LBDU9008i>CT01TE5AK>c/fMWIfMW
If][Jde=C@92@T801ZVYZCPh>3@d=3@d=1hN7T92@P8k>c/01CDe=EaLG5aLG75aLFYZJP02=CDe00IO
GemVIVI7AdM7AdMiNGWemOD2SXj>00DI6ATn?Shn?Si2@T8O7al00RTY:@06JFUYF5QH6QXJ6QXJN7Qh
6a/K0UeMG@05Cdm?7QhN51@D51@DCTi>009MGEd01Rh^;Q/K6dE5ADE5A@l?3a8B4P8@41001TU9BBl_
;a<C4a<C4b0P8492@P8k>c/01E=CDiRHV9RHV861PFIVIP02W9bL00IeMGEXJ6Q5ADE5ADD61PJ8R8P2
3Ph>00DT92@X:2PX:2PV9RJATI400RPX:006N7Qh?Cdm:2PX:2PX2`/;AdM70Xb<S005J6QX>SXjWinO
WinOEUIF009EEED01QTI6D10@51@D51@D2/[:di>CP8j>SX01GAdM5=CDh61PH61PDY:BP02A4A400IW
IfMGEeM]KFe]KFecLg=NGUh2:RXZ00Hl?3a_Kflc<c<c<c<U9BEcLg<28b<S00E@D50T92@T92@@410h
>3P00S4a<@06PX:2K6a/M7AdM7AdKFe]51@D0U]KF`05;2`/DU9B@T92@T929BDU009@D50018R8R<S8
b1hN7QhN7PCoool00`000?ooooooo`0=oooo000Roooo00D0003oooooooooooofm_H00Va/K006<C4a
KVi^D51@D51@9RHVMgMg0STi>@05HV9RBTY:BTY:QXJ6QhN7009@D5001UUIFCdm?D92@T92@T=3@eeM
G@9aLG401TE5AATI6AXJ6QXJ6WalO4I6AP91@D401H20P4Q8B6a/K6a/K4a<C0023`l?00IFEUI^KViW
IfMWIfN>SXiSHf<2Ng]k00HX:2PU9BEjNWYjNWXT92AGEeL2ADE500Dh>3Pf=SH];Bd];Bdk>c/00RHV
9P06>c/kB4Q8LW9bLW9bJVYZFEUI0QHF5P06=cLgJf][GemOGemOGEeMNWYj0Rd];@057alO51@D30`<
30`<Kfm_008U9BD01R8R8W9bLR4Q8B4Q8B/[:aPH608i>CT01Q@D57moOfATI6ATI5]KFa<C4`9iNGT0
1S0`<4e=CE1@D51@D7alO5MGE`9]KFd01GinOVATI6ATI1LG5bTY:@028R8R00HO7amMGEeLG5aLG5`j
>SYaLG42Kfm_00J4Q8AaLG4R8R8R8R9YJFTQ8B42QhN700Di>CTZ:RXZ:RYnOWi5ADD00SXj>P066QXJ
7QhNKfm_Kfm_@410?Cdm0R<S8`06>3Ph?3`l>3Ph>3Ph30`<?Shn0VYZJP05<S8b?clo_[jn_[jnCDe=
008O7al01UQHF0/;2f=SHf=SHe1@D8Z:RP9fMWH4oooo00<0003oooooool0;?ooo`040000oooooooo
moOg0V=SH`058B4QQHF5=3@d=3@d3Ph>009KFe/01R@T97QhN5UIFEUIFHZ:RWemO@9BDU801U]KFdE5
AE1@D51@D5QHF4A4A09GEeL01C@d=38b<S8b<P@4169RHP02GemO00I>CTj=SHdl?3`l?3a[Jf]3@d<2
2PX:00E]KFe@D51@D523Ph=nOWh00V9RHP06VYZJ?Shn?Shn?ShnLg=c:RXZ0VYZJP05EEEE=CDeBTY:
BTY:=SHf0093@d<01QdM7D];BeeMGEeMGFa/K5MGE`9KFe/01Q`L730`<6IVIVIVIV5QHEMGE`:5QHD0
1Clo?c@d=3@d=2d];BPX:002EUIF00Hd=3@i>CUPH61PH60g=cLl?3`2;Bd]00De=CDH61PH61QmOGeP
H6000UUIF@064a<CMWIf<c<c<c<cBDU9ATI60XV9R@05GUiNGEeMOgmoOgmoD51@008M7Ad01APH63Ti
>C<c<c<c<emOG`03D51@00ETI6AXJ6R>SXj>SXiXJ6P00R<S8`06Jf][7alORh^;Rh^;:RXZ?Shn0VEU
I@06Hf=SDU9B>CTi>CTi61PHCDe=0UIFEP05;Rh^=CDe=CDe>SXj@410008c<c<01Q0@434a<G1`L71`
L2XZ:TY:BP:o_kl01D10@2DU9CPh>3Ph>1<C4`02BDU900A5ADFATI64Q8B4Q8@4oooo00<0003ooooo
ool03Oooo`008_ooo`800003oooo0UaLG006Cdm?9RHVJFUYJFUYJf][J6QX0SLg=`05AdM74a<C4a<C
C4a<2`/;008O7al01Q`L755ADEADE5ADE5IFERHV9P9eMGD01UEEED];Bi>CTi>CThf=SF=SH`9XJ6P0
1EiNGUYJFQdM7AdM7FQXJ002:BTY00HO7alf=SJ8R8R8R8QYJFU_Kfl2;Bd]00J:RXZ1PH4f=SHf=SHD
51@Y:BT2QhN700DZ:RY@D51SHf=SHf=eMGD00T10@0067QhNJVYZYZJVYZJVPX:2GEeM0Y>CT`06=cLg
92@T=3@d=3@dKVi^I6AT0Rd];@05EeMGFe]KFe]KFe]K<30`008_;bl01Tm?Cdi>CQ4A4A4A4AHF5Q4A
4@8d=3@01TI6AUADE30`<30`<6a/K0X:2P9:BTX01P<30eiNGUiNGUiNGTa<C1PH608Q8B401C<c<cDe
=CDe=C`l?5ADE002BDU900IDE5A5ADDe=CDe=CENGUhW9bL25ADE00I8B4QLG5aMGEeMGEdk>c]^KVh2
@41000DI6ATb<S8b<S8Z:RXk>c/00QdM7@0651@D6a/K4a<C4a<C9bLWDE5A0Te=C@06MgMg6ATIEEEE
EEEEB4Q8UIFE0Ve]K@05^;Rh?3`l5aLG5aLGUIFE0096ATH01Q0@49jNWTm?Cdm?Ch20P3Ti>@9DE5@3
oooo0P0002koool200000_ooo`9ADE401F=SHchn?U=CDe=CDeEEE@02B4Q800H@411^KVhY:BTY:BU1
@D4<30`2410@00HD51A<C4a8B4Q8B4Q[Jf/K6a/2Fe]K00ECDe=QHF5QHF5`L71/K6`00WinOP06DE5A
EEEEIVIVIVIV9RHVIVIV0Rh^;P057QhN@D51@D51QHF5De=C00:4Q8@01SXj>X61PINGUiNGUbXZ:Q/K
6`8`<3001HB4Q2DU9DU9BDU9BEmOG`02M7Ad00I6ATH^;Ri^KVi^KVjRXZ9fMWH2Kfm_00JGUiL[:b/]
;Bd];Bdj>SY]KFd2FUYJ00DQ8B5TI6ATI6AEEEEXJ6P00R8R8P068b<SFEUIB4Q8B4Q84Q8B8b<S0QdM
7@05?ShnAdM7AdM7BDU9<c<c009UIFD010T92DI6AP@410@4109MGEd2CTi>00DC4a<W9bLg=cLg=cL_
;bl00T10@006G5aLB4Q8GemOGemO>SXj=CDe0U1@D005<c<c7QhN@D51@D51DE5A009GEeL01T=3@g9b
LSlo?clo?alO7b/[:`8V9RH01T51@@H61PL71`L71``<318B4P8<30`01DM7AeUIFEUIFGQhN2<S8`02
H61P00I8B4R:RXYlO7alO7b^[Zi8B4P23`l?00F2PX9WIfLH61PH61QnOWh00UIFEP04I6ATC4a<FUYJ
FUYJ0oooo`80000?oooo000Roooo00<0003oooooool00_ooo`9LG5`01Tm?CbHV9VUYJFUYJF][JfQX
J08g=cL01DM7Aa<C4a<C4da<C0/;2`027alO00HL71aADE5DE5ADE5AFEUHV9RH2MGEe00IEEEE;Bd^C
Ti>CTi>=SHeSHf<2J6QX00ENGUiJFUXM7AdM7AeXJ6P00RTY:@067alO=SHfR8R8R8R8JFUYKfm_0Rd]
;@06RXZ:PH61=SHf=SHf51@D:BTY0XN7Q`05:RXZD51@Hf=SHf=SMGEe0090@4001QhN7VYZJZJVYZJV
YX:2PUeMG@:CTi<01SLg=b@T93@d=3@d=6i^KVATI08];Bd01EMGEe]KFe]KFe]KFc0`<002;bl_00I?
Cdm>CThA4A4A4A4F5QHA4A42=3@d00I6ATIDE5@`<30`<31/K6`:2PX2BTY:00H30`=NGUiNGUiNGUi<
C4`H61P28B4Q00Dc<c<e=CDe=CDl?3aDE5@00TU9B@06E5ADADE5=CDe=CDeGUiN9bLW0QDE5@06B4Q8
G5aLGEeMGEeM>c/kKVi^0T10@0056ATI<S8b<S8b:RXZ>c/k008M7Ad01Q@D51/K6a<C4a<C4bLW9e5A
D@9=CDd01WMgMaTI6EEEEEEEEDQ8B9FEU@9]KFd01KRh^3`l?1LG5aLG5iFEU@02ATI600H@412NWYi?
Cdm?Cdn0P80i>CT2E5AD1?ooo`030000oooooooo02coool010000?ooooooooooo`9ADE401F=SHchn
?U=CDe=CDeEEE@02B4Q800H@411^KVhY:BTY:BU1@D4<30`2410@00HD51A<C4a8B4Q8B4Q[Jf/K6a/2
Fe]K00ECDe=QHF5QHF5`L71/K6`00WinOP06DE5AEEEEIVIVIVIV9RHVIVIV0Rh^;P057QhN@D51@D51
QHF5De=C00:4Q8@01SXj>X61PINGUiNGUbXZ:Q/K6`8`<3001HB4Q2DU9DU9BDU9BEmOG`02M7Ad00I6
ATH^;Ri^KVi^KVjRXZ9fMWH2Kfm_00JGUiL[:b/];Bd];Bdj>SY]KFd2FUYJ00DQ8B5TI6ATI6AEEEEX
J6P00R8R8P068b<SFEUIB4Q8B4Q84Q8B8b<S0QdM7@05?ShnAdM7AdM7BDU9<c<c009UIFD010T92DI6
AP@410@4109MGEd2CTi>00DC4a<W9bLg=cLg=cL_;bl00T10@006G5aLB4Q8GemOGemO>SXj=CDe0U1@
D005<c<c7QhN@D51@D51DE5A009GEeL01T=3@g9bLSlo?clo?alO7b/[:`8V9RH01T51@@H61PL71`L7
1``<318B4P8<30`01DM7AeUIFEUIFGQhN2<S8`02H61P00I8B4R:RXYlO7alO7b^[Zi8B4P23`l?00F2
PX9WIfLH61PH61QnOWh00UIFEP04I6ATC4a<FUYJFUYJ1?ooo`030000oooooooo00goool002;oool0
1@000?ooooooooooofe]K@028R8R00K=cLdW9bLL71`L71`f=SHM7Ad2@T9200EZJVY@D51@D50`<31_
Kfl00UYJFP06CDe=SHf=^;Rh^;Rh;Rh^E5AD0VQXJ006Ti>CCdm?JFUYJFUYJ6QXD51@0WYjNP05@T92
8B4QFe]KFe]KIVIV008Y:BT01UQHF8R8R38b<S8b<WUiNDE5A@9?Cdl01Q`L71XJ6XB4Q8B4Q410@4=3
@`9[Jf/01Di>CVa/K4];Bd];BeMGE`02@T9200HG5aM>CTiIFEUIFEUbLW8b<S82<30`00H;2`/X:2Q<
C4a<C4`K6a^ATI423`l?00EHF5P[:b/i>CTi>CTo?cl00TM7A`06;Rh^B4Q8=SHf=SHf92@T8b<S0Q`L
7006IVIV5QHF20P820P8DE5A=SHf0TI6AP062PX:Fe]KCTi>CTi>KFe]IFEU0U5AD@059RHVEUIFEUIF
3@d=HV9R009iNGT01TI6AQLG5bXZ:RXZ:Pl?3aXJ6P9NGUh01W1`L7inOQ4A4A4A4I:BTU5AD@820P80
1C/k>di>CTi>CRh^;S/k>`0251@D00HX:2P[:b]`L71`L72;Rh/d=3@2[:b/00JQXJ5NGUhf=SHf=SI6
ATHh>3P27AdM00F/[:a/K6aBDU9BDU:n_[h00TI6AP067alO92@TRHV9RHV9J6QXOWin0Zj^[P05`/;2
oooooooooooo000002koool010000?oooooooginOP8E5AD01M_KfaLG5a/K6a/K6bh^;P021PH600HW
9bMgMgM6ATI6ATH`<32FUYH2=3@d00IQHF5`L72^[Zj^[Zhi>CU@D502FEUI00FIVIUGEeMGEeM:BTYJ
FUX00WMgM`06E5AD@d=34A4A4A4A@d=3RXZ:0P/;2`05J6QXM7AdM7Ad;Bd]LG5a009@D5001T51@B/[
:alO7alO7g=cLbh^;P9BDU801EmOGc@d=5IFEUIFES8b<P02Jf][00I8B4PR8R9EEEEEEEELG5a`L702
=SHf00Hk>c/J6QX/;2`/;2aOGelF5QH2SHf=00D;2`]WIfMWIfLS8b=2@T800SDe=@06@T92;Rh^A4A4
A4A4?Shn61PH0QdM7@05:RXZPH61PH61820P7alO0092@T801QdM7C0`<1`L71`L751@D4m?C`9ZJVX0
1EmOGeeMGCLg=cLg=da<C0027AdM00I6ATILG5a9BDU9BDTT92@j>SX261PH00DV9RIDE5AdM7AdM7An
OWh00P/;2`06Ti>CFUYJ4a<C4a<C;Rh^E5AD0S@d=006?clo8B4Q;bl_;bl_;Rh^K6a/0XR8R005<c<c
ZZZZZZZZXJ6QK6a/0092@T801U9BDRl_;adM7AdM7JNWYf9RHP9:BTX01KVi^E5ADB`/;2`/;0d=3@02
M7Ad00EcLg=UIFG0`<30`<2a/K400oooo`030000oooooooo00goool002;oool01@000?oooooooooo
oi^KV`02MWIf00IaLG6NWYi@D51@D51^KVh61PH2BTY:00DY:BUSHf=SHf>@T91ZJVX00SPh>006/;2`
ZZZZFEUIFEUIRXZ:S8b<0W5aL@056ATIDE5ABd];Bd];Ph>300=/K6`01EQHF9>CTb4Q8B4Q8CLg=`02
I6AT00HS8b=]KFe?Cdm?CdmBDU:4Q8@2KVi^00HM7AeGEeM:BTY:BTZb/[8Q8B42O7al00Da<C4B4Q9G
EeMGEeNHV9P00Sdm?@06HV9R?Shn2@T92@T9D51@;2`/0Ta<C006GEeMB4Q8GemOGemO71`LZJVY0Sdm
?@05C4a<3`l?HF5QHF5Q8B4Q008j>SX01SHf=TE5ABl_;bl_;c<c<eUIF@8o?cl01UUIFHF5QE1@D51@
D1TI6C0`<09XJ6P2FEUI0RLW9`05@D51?CdmEUIFEUIFH61P009aLG401YnOWhb<S8>3Ph>3Pa@D55YJ
FP8U9BD01R@T94];Bclo?clo?c<c<alO7`8];Bd01EiNGV][JcXj>SXj>SHf=P02DE5A00H<30`71`M;
Bd];Bd/O7am4A4@3E5AD00F3Ph>a/K6a/K5ZJVXM7Ad00Rh^;P06GEeMDE5A2`/;2`/;FUYJFe]K0V1P
H005>3Ph=CDe=CDeOgmoKFe]00:6QXH01BHV9[^k^hZ:RXZ:R_KfmP03oooo00<0003oooooool0;?oo
o`040000ooooooooTY:B0XZ:RP05MWIf[jn_De=CDe=CH61P008<30`01TQ8B3@d=5EEEEEEEHj>SWin
OP8d=3@01ZRXZ:^[Zf5QHF5QHGUiNHV9R@9oOgl01ATI6DY:BTY:BU5ADH^;R`02L71`00I]KFeOGen4
Q8B4Q8@`<30g=cL2GEeM00Dh>3QRHV9RHV94A4A>CTh00XV9R@06Jf][8b<SCTi>CTi>EeMGYjNW0S0`
<005OGem7AdM3@d=3@d=CDe=00:HV9P01TU9BE]KFd10@410@0H61Tm?C`8X:2P01TU9BEYJFUADE5AD
E5eMGB`/;0:ZZZX01CPh>59BDU9BDR@T95iNGP024Q8B00H^;Rhe=CE:BTY:BTX_;bld=3@2DE5A00E4
A4AQHF5QHF6ATI5MGEd00Pl?3`06:RXZH61P?Cdm?CdmI6AT?Shn0TA4A005ATI6Fe]KHf=SHf=SKfm_
00:LW9`01X>3PgYjNRl_;bl_;gIfMP/;2`8g=cL01D51@Bh^;TU9BDU9BBd];@02:b/[00IZJVYXJ6Ph
>3Ph>3PZ:RYTI6@28B4Q00HE5AETI6@J6QXJ6QX`<31CDe<2G5aL00B6QXJn_[jn_[iRHV83:BTY00I_
Kfln?Sh;2`/;2`]4A4A`L702Bd];00Df=SH[:b]gMgMgMgM]KFd00XR8R005:b/[/[:bUiNGUiNGjNWY
00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooomZJVX00WMgM`06B4Q8FEUII6AT
I6ATYjNWEEEE0UYJFP0520P8DE5ADE5AMGEeBTY:009`L7001T51@Da<C65QHF5QHA8B4UEEE@9OGel0
1T10@6m_Kk2`/;2`/=3@d1@D509VIVH01@d=3A`L734a<C4a<@L71`02:b/[00Hn?SiNGUiFEUIFEUH=
3@dN7Qh2AdM700A8B4QBDU9jNWYjNWX2EUIF0R`/;005EEEEA4A4ATI6ATI6Hf=S008^;Rh01W=cLe1@
D5iNGUiNGUeMGDi>CP:HV9P01Tm?Ce1@D3Hf=SHf=TU9BD51@@8T92@01C@d=492@X:2PX:2PQ`L7002
GEeM00IEEEDP821;Bd];Bd/`<30i>CT2?Cdm00ICDe<L71aYJFUYJFU0@40@4102GemO00HL71`j>SY^
KVi^KVhS8b<g=cL2LW9b00FDU9A2@T92@T9IFETM7Ad00T51@@06Lg=c;Bd]DU9BDU9B8B4Q5aLG0UIF
EP06Cdm?:RXZ;bl_;bl_8B4Q5QHF0SLg=`057alO>3Ph>3Ph:BTYG5aL009aLG401ZFUYAHF5RHV9RHV
9UeMGDM7A`93@d<01XZ:RRXZ:U9BDU9BDTA4A492@P9PH6001C@d=4e=CFYZJVYZJRLW9`02JFUY00HF
5QICDe==CDe=CDeVIVIcLg<2;2`/00EoOgooooooooooool00000;_ooo`040000ooooooooKVi^0Wmo
O`05EeMGKfm_M7AdM7AdRXZ:009`L7001U1@D2PX:71`L71`L5iNGTU9B@:3Ph<01Shn?TA4A6ATI6AT
I0X:2UEEE@9[Jf/01CDe=G]kNg]kNk>c/kjn_P029bLW00INGUh=3@da<C4a<C4Y:BTK6a/2>CTi00D]
;BeZJVYZJVYEEEDB4Q800Q`L7006@d=3CDe=EUIFEUIFMWIfFe]K0UeMG@03<S8bDE5ACDe=009=CDd2
FEUI00D/;2aXJ6Q3@d=3@d=TI6@00di>CP06YJFUFEUIDU9BDU9B<c<cAdM70Slo?`059RHV?3`l?3`l
>CTiRh^;008V9RH01U]KFdI6ARh^;Rh^;U]KFb4Q8@97AdL01DY:BTQ8B4Q8B1HF5V=SH`02@41000H=
3@eMGEdI6ATI6ATl?3acLg<2820P00Do?cmoOgn9RHV9RHTh>3P00VYZJP066a/KATI6LG5aLG5a?Shn
AdM70Rh^;P056a/KGEeMBd];Bd];:RXZ008^;Rh01Rl_;`T92B<S8b<S8b`/;51@D08A4A401UYJFXJ6
QXZ:RXZ:RPT92C0`<09<C4`01EADE4Y:BTY:BY6ATB4Q8@02Fe]K00A7AdLX:2Q>CTi>CTh2@d=30VEU
I@05Bd];B4Q8410@410@ATI6009PH6001Fe]KH20P38b<S8b<XR8R003oooo00<0003oooooool03Ooo
o`008_ooo`050000ooooooooooooJVYZ009gMgL01TQ8B5UIFFATI6ATI:NWYeEEE@9JFUX01@P8255A
DE5ADGEeMDY:BP02L71`00I1@D5<C4aQHF5QHF4B4Q9EEED2GemO00I0@41_Kfn`/;2`/;3@d=0D51@2
IVIV00D=3@dL71`a<C4a<C471`L00R/[:`06?ShnGUiNEUIFEUIF3@d=7QhN0TM7A`04B4Q8DU9BNWYj
NWYj0UIFEP8/;2`01EEEEDA4A4I6ATI6AV=SH`02;Rh^00IcLg=@D51NGUiNGUiMGEe>CTh2V9RH00I?
Cdm@D50f=SHf=SI9BDU1@D4292@T00Dd=3A2@T:2PX:2PX8L71`00UeMG@06EEEE820PBd];Bd];<30`
>CTi0Sdm?@06De=C71`LJFUYJFUY@410410@0UmOG`0671`L>SXjKVi^KVi^8b<S=cLg0W9bLP05U9BD
@T92@T92FEUI7AdM0091@D401W=cLbd];E9BDU9BDR4Q8ALG5`9FEUH01Tm?CbXZ:Rl_;bl_;b4Q8AHF
5P8g=cL01AlO7cPh>3Ph>2TY:EaLG002LG5a00JUYJDF5QHV9RHV9RIMGEe7AdL2@d=300J:RXXZ:RYB
DU9BDU94A4A2@T82H61P00Dd=3A=CDeZJVYZJVXW9bL00VUYJ@065QHFDe=CCDe=CDe=IVIVLg=c0R`/
;005Ogmooooooooooooo000002koool010000?ooooooofi^KP9oOgl01EMGEfm_KgAdM7AdM8Z:RP02
L71`00I@D50X:2Q`L71`L71NGUi9BDT2Ph>300Hn?Si4A4ATI6ATI6@:2PYEEED2Jf][00De=CEkNg]k
Ng^c/k>n_[h00RLW9`06GUiN3@d=<C4a<C4a:BTY6a/K0STi>@05;Bd]JVYZJVYZEEEE4Q8B008L71`0
1T=3@de=CEIFEUIFEWIfMU]KF`9MGEd00c8b<U5ADDe=C@02CDe=0UUIF@05;2`/J6QX@d=3@d=3I6AT
00=>CTh01ZFUYEUIFE9BDU9BDS<c<dM7A`8o?cl01BHV9S`l?3`l?3Ti>H^;R`029RHV00IKFe]6ATH^
;Rh^;RiKFe/Q8B42AdM700E:BTY8B4Q8B4PF5QISHf<00T10@0063@d=GEeM6ATI6ATI?3`lLg=c0R0P
8005?cloOgmoRHV9RHV9>3Ph009ZJVX01Q/K6dI6AW5aLG5aLChn?TM7A`8^;Rh01A/K6eeMGD];Bd];
BbXZ:P02;Rh^00H_;bl92@TS8b<S8b</;2a@D5024A4A00IJFUZ6QXJ:RXZ:RXX92@T`<302C4a<00ED
E5A:BTY:BTZATI4Q8B400U]KF`04AdM7:2PXCTi>CTi>0T=3@`9UIFD01D];BdQ8B10@410@44I6AP02
H61P00E]KFf0P80b<S8b<S:8R8P00oooo`030000oooooooo00goool002;oool01@000?oooooooooo
ohj>SP02@d=300J@T91]KFeDE5ADE5ARHV9>CTh2;2`/00E?CdlI6ATI6AUNGUhl?3`00T];B`06:RXZ
9BDUBTY:BTY:=CDeFUYJ0VATI006ATI6?clo;bl_;bl_>c/k:2PX0SPh>005<30`<C4aFEUIFEUIADE5
009bLW801TE5AFMWIe9BDU9BDQlO7b`/;08h>3P01WAdM3Xj>YFEUIFEUC/k>emOG`8S8b<01@`<328R
8U=CDe=CDdE5A@02I6AT00Hb<S9:BTXd=3@d=3A3@d<Q8B426a/K00JXZ:PM7AdY:BTY:BTi>CTg=cL2
8b<S00D;2`/W9bMiNGUiNGV9RHT00VQXJ006>CTiB4Q8UIFEUIFEIFEUHV9R0V1PH006GEeM=SHfbLW9
bLW9AdM7@T920Slo?`06JVYZ:RXZBDU9BDU930`<JVYZ0QdM7@05M7AdS8b<S8b<A4A4@T92008g=cL0
1W1`L4A4A28R8R8R8T92@U5AD@9=CDd01XV9RADE5CXj>SXj>Ta<C24Q8@9<C4`01Di>CYVIVIVIVEAD
E3Hf=P02KVi^00JOWim[Jf/n?Shn?SiXJ6Pf=SH2KFe]00I6ATJQXJ5VIVIVIVHW9bLB4Q82JVYZ00E1
@D5kNg]3@d=3@d<e=CD00UaLG006TY:B4A4A5aLG5aLGTI6AEEEE0Xn?S`05F5QHoooooooooooo0000
02koool010000?oooooooh^;R`91@D401I>CTg1`L6ATI6ATI55AD@02Hf=S00HL71`a<C4<30`<30aA
DE5OGel2De=C00HX:2Pj>SY9BDU9BDU6ATI>CTh2GemO00E2@T95ADE5ADDU9BD];Bd00Rh^;P06;Bd]
Bd];92@T92@T?3`lJVYZ0U1@D005<30`Jf][Jf][FEUI=cLg008I6AT01RXZ:WemOClo?clo?i2@T4M7
A`9]KFd01CHf=P`<32PX:2PX:6IVIP02:b/[00I`L70Y:BTi>CTi>CTW9bLh>3P2=3@d00HW9bNi^KTC
4a<C4a<J6QXX:2P2@41000Di>CTN7QhN7Qh_;bn>SXh00X61P@06F5QH;2`/C4a<C4a<XJ6QFEUI0W1`
L005Fe]KH61PH61P<30`];Bd009HF5P01RLW9eYJFWAdM7AdM2TY:F1PH08H61P01FEUIA@D57MgMgMg
MhV9R@02CDe=00Hk>c]<C4aPH61PH611@D4g=cL2;bl_00E@D51YJFUiNGUiNGTK6a/00Sdm?@06DE5A
5aLGAdM7AdM7G5aLSHf=0U5AD@06;2`/LW9bRHV9RHV9MGEeBd];0VEUI@05ATI6M7AdM7Ad>c/kTI6A
009HF5P01SLg=aPH66MWIfMWIeEEEFEUI@9:BTX01B4Q8D];Bi>CTi>CT`L71`02;2`/00FUYJEHF5RC
Ti>CTi=DE5@00oooo`030000oooooooo00goool002;oool200000_ooo`05S8b<?3`l?3`l@410B4Q8
009SHf<00bd];C0`<6EUI@02IFEU0S`l?006<S8b=3@d=cLg=cLg20P8B4Q80VEUI@06>SXjFEUIC4a<
C4a<8B4Q3@d=0UiNGP0651@D;bl_A4A4A4A4JVYZ>c/k0R<S8`05B4Q8GEeMGEeMPX:2V9RH008k>c/0
1UiNGV5QHFi^KVi^KU]KFcLg=`9QHF401VEUIDQ8B6e]KFe]KAPH63Xj>P9@D5001Jf][BPX:2PX:5]K
FeMGE`026QXJ00IcLg=PH60m?Cdm?CdU9BEIFET2_;bl00Hk>c]TI6A7AdM7AdM9BDUhN7P23`l?00EA
DE5@D51@D50410@l?3`00V][J`065ADEFUYJ@410@410EUIFFUYJ0YBDU006KFe]6QXJRXZ:RXZ:>CTi
Kfm_0R/[:`0571`L6ATIHf=SHf=SBTY:009WIfL01WemOG=cLfMWIfMWIdi>CSlo?`9<C4`01ZZZZVa/
K2/[:b/[:f9RHR0P809OGel01D];BdA4A2PX:2PX:2`/;002V9RH00HJ6QY=CDdA4A4A4A4b<S8d=3@2
Ph>300IXJ6Pd=3A?Cdm?Cdl`<31fMWH2NWYj00I7AdM_KflN7QhN7Qhj>SXV9RH2LG5a00G1`L4?3`l?
3`m;Bd/L71`00S@d=004PH61^[ZjCdm?Cdm?0oooo`80000^oooo0P000006ooooUYJFBDU9BDU9@d=3
AdM70U]KF`<Z:RX01VYZJVATI3Ti>CTi>C4a<CXj>P8n?Sh01Q8B4U=CDf5QHF5QHBl_;fIVIP97AdL0
1ALG5a<C4a<C4e]KFaHF5P02<30`00I8B4Q]KFdd=3@d=3@^;Rhk>c/2CTi>0hZ:RP06BDU9JFUYH61P
H61PJFUYHf=S0SXj>P06IFEUK6a/@410@410N7Qh3Ph>0TU9B@05CTi>Z:RXZ:RX;Rh^GEeM009<C4`0
1R@T971`L6ATI6ATI410@2LW9`9TI6@01K2`/4I6AVe]KFe]KDU9B@02>3Ph00J3Ph<H61Q3@d=3@d=0
@40B4Q82?Cdm00E[Jf/D51AJFUYJFUXo?cl00UADE006IVIVSHf=OGemOGem;2`/OGem0U9BDP06Jf][
51@D92@T92@T;Rh^C4a<0UeMG@05FUYJRHV9RHV9M7AdI6AT009:BTX01TU9BDe=CJVYZJVYZH61PBTY
:@95ADD01BLW9dM7AdM7AdA4A5UIF@02@41000HJ6QZKVi/A4A4A4A5;Bd/?3`l2<c<c00De=CF5QHES
Hf=SHf=3@d<00V1PH00661PHLG5aIFEUIFEUD51@J6QX0QHF5P06=SHf;bl_IfMWIfMWb<S8410@0Ta<
C0057QhN<C4a<C4aR8R8/;2`009ADE43oooo0P0000ooool002;oool01@000?oooooooooooiZJVP02
K6a/00Ho?clk>c/[:b/[:b/@411>CTh2:RXZ00ELG5bEUIFEUIGDe=B:RXX00[fm_@9EEED2U9BD00I`
L71hN7Q:BTY:BTXf=SHL71`2YjNW00HD51A7AdLQ8B4Q8B4k>c/F5QH2?Shn00F7QhMQHF5QHF4`<30o
?cl00Rl_;`06G5aLBDU97alO7alOBTY:5QHF0/[:bP06@d=3FUYJG5aLG5aLWYjNCTi>0QXJ6P054a<C
ADE5ADE5G5aL61PH008N7Qh01Q8B4WMgMfUYJFUYJA@D51/K6`9nOWh01Tm?Cb`/;14A4A4A4EEEEDA4
A09=CDd01CDe=BTY:BTY:F][JbTY:@02Bd];00IOGel=3@dV9RHV9RH;2`];Bd/2BTY:00IIFETB4Q9E
EEEEEEDb<S8J6QX2EeMG00D;2`/Q8B4=3@d=3@e7AdL00QPH6006SHf=51@DFEUIFEUIM7Ad61PH0QTI
6@06E5ADG5aL820P820P4Q8BBd];0S0`<0059BDU:BTYCTi>CTi>AdM7009DE5@01UYJFR4Q8DI6ATI6
AR0P82LW9`97AdL01T10@3/k>eIFEUIFETE5AB<S8`8c<c<01S`l?5iNGVATI6ATI0l?3i^KV`9^KVh0
1EIFET10@410@4E5ADa<C002V9RH00DP820R8R:_[jn_[jmMGEd00oooo`030000oooooooo02coool0
10000?oooooooi>CT`9WIfL01D51@Cdm?BDU9BDU9@X:2P02CTi>00Hj>SY^KVjSXj>SXj?4a<BLW9`2
Zj^[00A8B4QFEUJATI6ATI42NGUi0Te=C@05<c<c8B4Q8B4QXZ:R2@T90095ADD01Q8B4SPh>2LW9bLW
9da<C8V9R@9/K6`01Clo?dQ8B4Q8B2l_;e=CD`02C4a<00HN7Qi9BDTG5aLG5aO>c/hm?Cd2EUIF00EC
De>NWYiFEUIFEUH=3@d00P/;2`9?Cdl28B4Q00HA4A451@EeMGEeMGE[Jf/O7al271`L00EkNg]BDU8_
;bl_;blH61P00U5AD@06ATI6Bd];;2`/;2`/=CDeG5aL0QTI6@05>3PhHF5Q7alO7alO<C4a008I6AT0
1UUIFEADE5MGEeMGEaLG5eADE08e=CD01Q<C4e1@D1HF5QHF5RXZ:Pl?3`93@d<01ADE5J2PX:2PX0P8
25]KF`02JFUY00H?3`lL71aADE5ADE5RHV8V9RH26a/K00E7AdLS8b<S8b</;2`i>CT00TM7A`06D51@
BDU9D51@D51@6a/KATI60QlO7`058b<S?clo=cLg=cLgBDU90097AdL01T51@ATI6D10@410@3Ti>FEU
I@9OGel01Pl?3i^KVfYZJVYZJTi>CTI6AP8g=cL01Cdm?JRXZ:RXZ20P83<c<`02^[Zj00EZJV[ooooo
ooooool000003oooo`008_ooo`050000ooooooooooooVYZJ009/K6`01Slo?c/k>b/[:b/[:a0@44i>
CP8Z:RX01EaLG9FEUIFEUMCDe8Z:RP02_Kfm0UEEE@:DU9@01W1`L7QhN4Y:BTY:BSHf=Q`L70:WYjL0
1Q@D54M7Ab4Q8B4Q8C/k>aHF5P8n?Sh01HN7Qf5QHF5QHC0`<3lo?`02;bl_00ILG5a9BDTO7alO7am:
BTXF5QH2b/[:00I3@d=JFUYLG5aLG5bNWYi>CTh26QXJ00DC4a=5ADE5ADELG5`H61P00QhN7P064Q8B
MgMgJFUYJFUY51@D6a/K0WinOP06Cdm?;2`/4A4A4A4AEEEEA4A40Te=C@05=CDe:BTY:BTYJf][:BTY
009;Bd/01UmOG`d=3BHV9RHV9P/;2d];B`9:BTX01UUIFA8B4UEEEEEEEC8b<QXJ6P9GEeL01@/;2b4Q
8@d=3@d=3DM7A`0261PH00J=SHdD51AIFEUIFEUdM7@H61P26ATI00IDE5ALG5`P820P820B4Q9;Bd/2
<30`00DU9BDY:BU>CTi>CTi7AdL00UADE006FUYJ8B4QATI6ATI6820P9bLW0TM7A`06@410>c/kEUIF
EUIFADE58b<S0S<c<`06?3`lGUiNI6ATI6AT3`l?Vi^K0Vi^KP05EUIF@410@410ADE5C4a<00:HV9P0
1B0P828R8Zn_[jn_[eeMG@03oooo00<0003oooooool0;?ooo`040000ooooooooTi>C0VMWI`05@D51
?Cdm9BDU9BDU2PX:009>CTh01SXj>Vi^KZ>SXj>SXlC4a9bLW0:[Zj/014Q8B5IFEY6ATI6AT@9iNGT2
CDe=00Dc<c<Q8B4Q8B6RXZ892@T00TE5A@064Q8B>3Ph9bLW9bLWC4a<RHV90Va/K005?cloB4Q8B4Q8
;bl_De=C009<C4`01QhN7TU9BALG5aLG5lk>cSdm?@9FEUH01E=CDijNWUIFEUIFEPd=3@022`/;0Tm?
C`8Q8B401Q4A4@D51GEeMGEeMF][JalO7`8L71`01G]kNe9BDRl_;bl_;aPH6002DE5A00I6ATI;Bd//
;2`/;2`e=CELG5`26ATI00Dh>3QQHF4O7alO7ala<C400QTI6@06FEUIE5ADEeMGEeMG5aLGE5AD0SDe
=@064a<CD51@5QHF5QHF:RXZ3`l?0T=3@`055ADEX:2PX:2P20P8Fe]K009YJFT01Pl?3a`L755ADE5A
DF9RHRHV9P8K6a/01DM7Ab<S8b<S8b`/;3Ti>@02AdM700I@D519BDU@D51@D50K6a]6ATH27alO00DS
8b<o?clg=cLg=cM9BDT00TM7A`06@D516ATI@410@410>CTiIFEU0UmOG`063`l?Vi^KJVYZJVYZCTi>
ATI60SLg=`05?CdmZ:RXZ:RX820P<c<c00:j^[X01FYZJ_ooooooooooo`00000?oooo000Roooo00D0
003oooooooooooo[jn/00Q8B4P06DU9BHV9RTi>CTi>CIfMWShn?0QLG5`05De=C1`L71`L7EEEEFe]K
009fMWH01[Bd]4U9BH61PH61PEiNGUEEE@:?Shl01Slo?cXj>Xj>SXj>SU=CDc/k>`8a<C4015mOGfi^
KP`<30`<30<Y:BT01Rl_;`@417moOgmoOj6QXFUYJ@8o?cl01RXZ:YbLW69RHV9RHU5ADLS8b09LG5`0
1De=CDI6AQTI6ATI6B/[:`02Cdm?00Hm?CeYJFU8B4Q8B4QZJVXG5aL2Vi^K00I>CThn?Shm?Cdm?Ce2
@T8I6AT24Q8B00DN7QjFUYHM7AdM7Adb<S800T10@006Cdm?B4Q8:RXZ:RXZIFEUC4a<0Q`L7006De=C
:BTYDU9BDU9B6a/KFEUI0WYjNP06DU9B;2`/PH61PH6161PHYjNW0YnOW`056ATI][Jf][Jf3`l?CTi>
008n?Sh01STi>@X:2UMGEeMGEa/K6hN7Q`8e=CD01QHF5T10@2l_;bl_;chn?RTY:@9RHV801D10@2XZ
:RXZ:V9RHR0P8002EUIF00H?3`ld=3@B4Q8B4Q8A4A4h>3P2J6QX00HT92ACDe>XZ:RXZ:PM7AeEEED2
=cLg00E^KVinOWhJ6QXJ6QY3@d<00UMGE`06ADE5Y:BT8b<S8b<SJFUY:BTY0T92@P05OWinoooooooo
oooo000002koool010000?oooooooo3`l08410@01DQ8B5UIFHf=SHf=SEYJFP02UiNG00HM7AeSHf<R
8R8R8R9NGUi0@402Jf][00JIVIU=CDf5QHF5QHE/K6aGEeL2S8b<00Dm?Cdk>c/k>c^4Q8A3@d<00S<c
<`06>CTiADE5RXZ:RXZ:820P=SHf0SPh>005AdM75QHF5QHFSHf=UYJF009_Kfl01SXj>R/[:inOWinO
WfEUIE1@D0;3`l<2DE5A0SDe=@059bLW=3@d=3@dHF5Q;bl_009eMGD01SLg=emOGb<S8b<S8i>CTeYJ
FP9=CDd013<c<cHf=QhN7QhN7P<I6AT01Y>CTb8R8S<c<c<c<clo?cdm?@8k>c/01D10@5UIFFQXJ6QX
J0<30`02E5AD00Hk>c]7AdL92@T92@UBDU9nOWh2C4a<00H/;2aiNGT51@D51@G0`<28R8P24A4A00G?
cllQ8B4Q8B59BDTV9RH00S@d=00630`<IFEU4a<C4a<CTI6A?Cdm0R8R8P05@T929BDU9BDU<30`3@d=
009PH6001S<c<a4A4E9BDU9BDRl_;f1PH08?3`l01C8b<Pl?3aTI6ATI6BDU9@02E5AD00Hl?3aRHV:_
[jn_[jl^;Ri5ADD2:2PX00I]KFf<S8`K6a/K6a]?Cdm8B4P2=cLg00FBTY8f=SHf=SIkNg/H61P00UQH
F005RXZ:oooooooooooo000000ooool002;oool00`000?ooooooo`02oooo0R`/;006SXj>UYJF@T92
@T92Fe]K?Cdm0SHf=P05IFEUI6ATI6ATCTi>NWYj008n?Sh01Vm_Ka`L70X:2PX:2VUYJB0P809EEED0
1QlO7a@D53dm?Cdm?FYZJQdM7@9;Bd/01A/K6f1PH69RHV9RHR@T9002:BTY00Hi>CUXJ6QPH61PH61J
FUX61PH2F5QH00I?CdmADE5;Bd];Bd/92@U>CTh2@T9200EQHF4W9bN7QhN7QhMeMGD00S/k>`06>CTi
>SXjGUiNGUiNOGemFEUI0WAdM006?3`lD51@F5QHF5QHCTi>Cdm?0TY:BP05:RXZV9RH<C4a<C4a<30`
008];Bd01YnOWeeMGADE5ADE5Di>CQ/K6`9;Bd/01Sdm?B`/;2DU9BDU9@820RTY:@8l?3`01TU9BJj^
[UIFEUIFEVYZJS0`<09XJ6P3ZJVY00IOGem;Bd^^[Zj^[ZiLG5`51@D2EUIF00HR8R:DU9@B4Q8B4Q8Z
:RXB4Q82=cLg00E5ADDH61Pf=SHf=SHH61P00SDe=@06;Rh^92@TG5aLG5aLKFe]QXJ60UMGE`067QhN
WYjNF5QHF5QHHF5QM7Ad0WYjNP0661PH^KViADE5ADE5<S8bWinO0^c/k005J6QX5QHF5QHFLg=cLW9b
008:2PX01H:2PVATI492@T92@YjNWP03oooo00<0003oooooool0;?ooo`040000oooooooooooo0R<S
8`05S8b<T92@BTY:BTY:D51@009HF5P01S8b<T=3@h^;Rh^;Rc0`<7moO`8M7Ad01UiNGR8R8Pd=3@d=
3G=cLb4Q8@9MGEd01A`L72HV9RHV9R0P84i>CP029BDU00I3@d<_;bmhN7QhN7QSHf<V9RH2<C4a00Dl
?3a`L71`L71XJ6QKFe/00P@41006EeMGHF5QIfMWIfMWA4A45ADE0S`l?005A4A4EUIF?Shn?ShnMgMg
00:6QXH01SPh>492@T92@T92@UaLG820P09PH6001WAdM3/k>eiNGUiNGTQ8B3`l?08n?Sh01EIFEQlO
7alO7i:BTS8b<P02:b/[00Hb<S:GUiMZJVYZJVXP821@D5029bLW00E3@d<Y:BTY:BTF5QHA4A400Q<C
4`068b<S=SHfBTY:BTY:ZZZZCTi>0WMgM`05<30`KFe]XJ6QXJ6Q_[jn0094A4@01V9RHY>CTgIfMWIf
MQ<C4fUYJ@8Q8B401J:RXQlO7cTi>CTi>@d=3@02AdM700D`<30820Q?Cdm?CdlS8b<00c4a<@068B4Q
J6QXKFe]KFe]OgmoJFUY0RTY:@05U9BDD51@D51@K6a/QhN700:>SXh01PD51K^k^c`l?3`l?2l_;ijN
WP;fm_H01FIVIR`/;6MWIfMWIeEEE@02:RXZ00E_Kfm<C4`c<c<c<c>9RHT00oooo`030000oooooooo
00goool001Soool300000_ooo`030000oooooooo00;oool01@000?ooooooooooooknoP02Ogmo00Ij
NWYSHf<a<C4a<C5WIfMNGUh2^;Rh00DB4Q8h>3Ph>3P820R;Rh/00R4Q8@069bLW@410ADE5ADE5<30`
S8b<0V5QH@06M7Ad<C4a92@T92@T=cLg=3@d0SXj>P05AdM730`<:RXZ:RXZOWin008T92@01SXj>T];
BdU9BDU9BAPH63Ph>08S8b<01X:2PTY:BUIFEUIFES/k>a`L708o?cl01CPh>8N7QahN7QhN7U=CD`02
BDU900Hd=3AHF5P:2PX:2PYDE5@T92@2:RXZ00IJFUY[Jf/@410@412>SXhN7Qh22PX:00De=CDo?cm5
ADE5ADEbLW800S/k>`06ATI6CDe=Cdm?Cdm?;bl_@T920V5QH@06G5aLIFEUCDe=CDe=:b/[>SXj0UMG
E`065QHFOGem@410@410Fe]KDU9B0Q0@4005BTY:O7alO7al>SXjATI6009NGUh01R/[:aXJ6UaLG5aL
G6ATI3hn?P8D51@01QLG5cDe=B8R8R8R8R4Q8AlO7`9`L7001A/K6de=CDe=CFe]KF][J`02BTY:00H3
0`<a<C4i>CTi>CUOGemiNGT2F5QH00Hi>CVXZ:PM7AdM7AdZ:RYIFET3@d=300A@D523Ph>3Ph=9BDT2
Jf][00HT92AaLG58B4Q8B4QUIFDj>SX2]kNg00ERHV;oooooooooool000009?ooo`<00002oooo00<0
003oooooool00_ooo`040000oooooooooooo0WemO@05O7alF5QH9bLW9bLWGemO00:0P8001YJFURHV
9QHF5QHF5R`/;8^;R`8Z:RX01RHV9TQ8B4e=CDe=CC0`<8V9R@9^KVh01FYZJTe=CDe=CCXj>P`<3002
:2PX00IZJVYDE5@k>c/k>c/d=3ALG5`2?clo00E7AdM9BDU9BDU=CDdM7Ad00Shn?P06=CDeQ8B4Kfm_
Kfm_=CDe=SHf0S`l?005@T92;Rh^U9BDU9BD3`l?0096ATH01UADE2h^;UiNGUiNGPT92EeMG@8`<300
1QHF5Vi^KUQHF5QHF2PX:7YjNP8C4a<01AHF5R/[:b/[:cLg=dY:BP02LW9b00Hi>CU0@41>CTi>CTi7
AdLg=cL2@T9200EEEEEKFe]KFe]JFUYDE5@00S<c<`06=SHfEUIF7QhN7QhNL71`>c/k0UeMG@05F5QH
5QHFCDe=CDe=SHf=008_;bl01T];Be5ADC@d=3@d=2TY:FATI09ADE401E=CD`X:2P<30`<30dI6AP02
3@d=00HD51@;2`]oOgmoOglV9RIFEUH2JFUY00IeMGEADE4C4a<C4a<J6QXm?Cd2NWYj00EbLW94A4A4
A4AFEUJh^;P00Pl?3`06;Rh^FEUI?Shn?Shn@D51EeMG0Y6AT@05GemOHf=S@D51@D51MGEe008c<c<0
1DQ8B20P89nOWinOWeIFEP03oooo00<0003oooooool03Oooo`006Oooo`060000oooooooo0000oooo
00000oooo`050000ooooooooooooo_kn009oOgl01WYjNV=SHc4a<C4a<FMWIeiNGP:h^;P01A8B4SPh
>3Ph>0P828^;R`028B4Q00HW9bM0@415ADE5ADD`<32<S8`2HF5Q00IdM7@a<C4T92@T92@g=cLd=3@2
>SXj00E7AdL<30`Z:RXZ:RYnOWh00R@T9006>SXjBd];BDU9BDU961PH>3Ph0R<S8`06PX:2BTY:EUIF
EUIF>c/k71`L0Slo?`05>3PhQhN77QhN7QhNDe=C0099BDT01S@d=5QHF0X:2PX:2UADE2@T908Z:RX0
1UYJFV][Ja0@410@48j>SQhN7P8:2PX01CDe=Clo?dE5ADE5AG9bLP02>c/k00I6ATI=CDe?Cdm?Cdl_
;bm2@T82HF5Q00ILG5aUIFE=CDe=CDd[:b/j>SX2EeMG00HF5QImOGe0@410@41KFe]BDU82410@00E:
BTYlO7alO7`j>SY6ATH00UiNGP06:b/[6QXJG5aLG5aLI6AT?Shn0Q@D50065aLG=CDe8R8R8R8R8B4Q
7alO0W1`L0056a/KCDe=CDe=KFe]Jf][009:BTX01P<30c4a<CTi>CTi>EmOGgUiN@9HF5P01STi>JRX
Z1dM7AdM7BXZ:UUIF@=3@d<0151@D8>3Ph>3PdU9B@9[Jf/01R@T975aLDQ8B4Q8B6EUICXj>P:g]kL0
1F9RH_ooooooooooo`00000Uoooo00H0003oooooool0003oool00003oooo00@0003oooooooooool2
OGem00ElO7aHF5PW9bLW9bMOGel00X20P006UYJF9RHV5QHF5QHF;2`/Rh^;0RXZ:P069RHVB4Q8CDe=
CDe=<30`RHV90Vi^KP05JVYZCDe=CDe=>SXj30`<008X:2P01VYZJUADE3/k>c/k>c@d=5aLG08o?cl0
1DM7AdU9BDU9BDe=CAdM7@02?Shn00He=CF4Q8A_Kfm_Kfle=CDf=SH2?3`l00E2@T8^;RjDU9BDU9@?
3`l00TI6AP06E5AD;Rh^GUiNGUiN2@T9GEeM0S0`<0065QHFKVi^F5QHF5QH:2PXNWYj0Q<C4`055QHF
:b/[:b/[=cLgBTY:009bLW801STi>D10@4i>CTi>CTM7AcLg=`92@T801EEEEE]KFe]KFeYJFUADE002
<c<c00Hf=SIFEUHN7QhN7Qi`L70k>c/2GEeM00EHF5PF5QI=CDe=CDf=SHd00Rl_;`06Bd];DE5A=3@d
=3@d:BTYI6AT0U5AD@05De=C2PX:0`<30`<3ATI6008=3@d01Q@D50/;2gmoOgmoObHV9UIFEP9YJFT0
1WEeME5ADA<C4a<C4aXJ6Sdm?@9jNWX01G9bLTA4A4A4A5IFE[Rh^0023`l?00H^;RiIFETn?Shn?Si1
@D5GEeL2TI6A00EOGemSHf=1@D51@D5eMGD00S<c<`05B4Q8820PWinOWinOEUIF00?oool00`000?oo
ooooo`0=oooo000Goooo10000004oooo0000oooo00000oooo`800003oooo0UaLG006Bd];EEEEB4Q8
B4Q8<30`XZ:R0STi>@05GemO8R8R8R8R9BDU3`l?008f=SH01Sdm?CTi>Bh^;Rh^;UYJFW1`L08l?3`0
1R8R8U5ADCTi>CTi>A<C4`/;2`8D51@01G9bLQ<C4bPX:2PX::NWY`02WinO00I<C4`j>SXc<c<c<c<T
92@Z:RX2@41000IlO7aLG5`O7alO7amXJ6QKFe/2=cLg00DK6a^<S8anOWinOWjSXj<00W1`L006EeMG
YZJV4A4A4A4ADe=C>SXj0Sdm?@06JFUYFUYJADE5ADE5?clo:b/[0QHF5P05G5aL<c<c;Rh^;Rh^?clo
008l?3`01Q4A4GalO3dm?Cdm?E5ADF5QH@8X:2P01T=3@b4Q8KJf][Jf]T=3@``<309TI6@01P`<34a<
C3@d=3@d=2@T94Q8B09CDe<01EeMGC`l?3`l?451@A@D500292@T00I1@D5eMGDV9RHV9RH`<30Z:RX2
4a<C00HP820@411KFe]KFe/j>SXW9bL2ATI600Dg=cLm?Cdm?Cd`<31BDU800VEUI@068B4QIFEU7QhN
7QhN5QHFBDU90TQ8B0069bLWFUYJN7QhN7Qh>CTi5ADE0QXJ6P053Ph>6QXJGEeMGEeMk^k^0096ATH0
1UIFESDe=CXj>SXj>R`/;30`<09FEUH00galO?ooooooo`0200008oooo`@000001?ooo`000?ooo`00
00?oool2000000Koooohn?QADE5ADE4h>3Po?cl2GemO00DJ6QZm_Kfm_KdR8R9@D5000S@d=08U9BD2
:RXZ00H/;2a4A4@U9BDU9BEOGem]KFd2>CTi00DN7Qi5ADE5ADE<C4`];Bd00RLW9`06<S8bQXJ67alO
7alO3@d=V9RH0Zb/[005BDU9ADE5ADE5;2`/8B4Q008a<C401T=3@g]kNfMWIfMWIaPH66YZJP9VIVH0
1CDe=AdM7InOWinOWg9bLP02X:2P00IXJ6QJFUZWYjNWYjL;2`]9BDT2=CDe00HZ:RYeMGEADE5ADE54
A4@a<C425aLG00DW9bM=CDe=CDdl?3`V9RH00Shn?P06<C4a1@D5KVi^KVi^;Bd]Fe]K0VUYJ@0551@D
EUIFEUIF<30`YJFU0091@D401QHF5UUIFAHF5QHF5UIFEQlO7`8S8b<01C<c<de=CFm_Kfm_Kbl_;`02
?3`l00DK6a/Q8B4b<S8b<S9bLW800bl_;`05<S8b10@46a/K6a/K:RXZ008n?Sh01TU9BB8R8VUYJFUY
JEADE2<S8`9@D5001SHf=Ti>CQ8B4Q8B4Vi^KRHV9P8B4Q801E9BDTE5ADE5AB8R8VATI002N7Qh00H_
;blK6a/G5aLG5aLZ:RXT92@2IFEU00GKfm]ADE51@D51@D4a<C400R`/;005=SHf:RXZBd];Bd];OGem
00;oool200003oooo`005oooo`030000oooo000000;oool00`000?ooo`000003oooo00<0003ooooo
ool00_ooo`9NGUh01R0P8::RXR0P820P85=CDfi^KP9aLG401APH63Hf=SHf=U5ADFEUI@02;Bd]00I`
L70M7Ad_;bl_;bn5QHE2@T823@d=00HI6AUEEED/;2`/;2`m?Cdc<c<25aLG00Dk>c]SHf=RHV9RHV8g
=cL00UYJFP06JVYZB4Q8;bl_;bl_>CTi2PX:0TU9B@06F5QHHV9RIfMWIfMW3Ph>=CDe0Te=C@05Cdm?
BTY:CDe=CDe=Shn?009aLG401Shn?/W9bDQ8B4Q8B5IFEU1@D09MGEd01QhN7R4Q8E5ADE5ADBd];BPX
:08<30`01CXj>SPh>3Lg=cLg=da<C0029bLW00H^;Rhd=3A/K6a/K6b4Q8B8R8P2Hf=S00HO7al];Beg
MgMgMgLa<C5<C4`2;Bd]00I6ATHX:2PL71`L71a:BTX`<302JVYZ00E:BTYYJFUYJFUbLW99BDT00T10
@006HV9RMGEe9BDU9BDUAdM7;Bd]0QXJ6P06OGem>CTiEeMGEeMGCdm?;Bd]0S`l?0058R8R8b<S8b<S
@D51O7al0098B4P01YZJVXJ6QS0`<30`<3lo?hV9R@8O7al01Q0@46YZJWIfMWIfMShn?PT92@9fMWH0
1B/[:a/K6gEeMGEeMEUIF@02EeMG00IQHF4b<S9?Cdm?Cdl=3@eFEUH2O7al00EkNg_oooooooooool0
00008oooo`030000oooo000000;oool00`000?ooo`000003oooo00@0003oooooooooool2GemO00Di
>CV1PH4N7QhN7QikNg/00W5aL@06IVIV6a/K9RHV9RHVLg=cBd];0T92@P06MGEe6QXJ<C4a<C4aS8b<
@T920R0P80059BDUBTY:BTY:?3`l=CDe008M7Ad00aDE5Bh^;VATI002I6AT00@i>CUMGEeMGEeZJVX2
Cdm?00HT92A1@D4A4A4A4A52@T9NGUh2FUYJ00ITI6@;2`/a<C4a<C57AdMBDU82?Shn00EJFUZ4Q8B4
Q8AjNWXe=CD00/O7a`06Cdm?De=CDE5ADE5AF5QH9BDU0R/[:`05DE5A;2`/6a/K6a/K6QXJ008Y:BT0
1SPh>3/k>chn?Shn?Q/K6bTY:@8S8b<01EUIFI:BTXF5QHF5QG9bLP02=3@d00Hf=SITI6@j>SXj>SXl
?3`d=3@2BTY:00H];BdU9BDm?Cdm?Cdg=cMEEED2E5AD00E9BDV4Q8B4Q8A:BTY3@d<00Ta<C006Shn?
8b<SF5QHF5QH;Rh^4Q8B0WYjNP05?CdmCTi>CTi>GemO5aLG009@D5001R`/;1/K6c0`<30`<4U9BCdm
?@9ZJVX01K6a/EaLG5ADE5ADE7alO002;Bd]00H61PI[Jf]oOgmoOglb<S8Q8B42NGUi00H20P8Q8B6/
[:b/[:`j>SXf=SH2RXZ:00D410@a<C4a<C4B4Q94A4@00WalO005NWYjoooooooooooo000000ooool0
01Soool200000_ooo`030000oooo000000?oool01@000?ooooooooooooKfmP02De=C00IcLg>YZJUZ
JVYZJVY5ADDn?Sh261PH00EKFe/_;bl_;bm`L71OGel00SLg=`06RHV93@d=Hf=SHf=SPH613@d=0U9B
DP0692@T9RHV?Shn?ShnHV9RCTi>0Ta<C0057alOEEEE5ADE5ADE7alO008L71`01P/;2cXj>SDe=CDe
=C8b<T10@08Y:BT01R`/;2<S8fm_Kfm_KdI6AU9BDP93@d<01EEEEADE5A<C4a<C4f5QH@02G5aL00H]
;Be1@D4^;Rh^;RhI6AUTI6@2>SXj00H820Q4A4AGEeMGEeM>CTi8B4P2:2PX00Dd=3ASHf<X:2PX:2QG
EeL00Slo?`06CTi>DE5AEEEEEEEEDU9B;Rh^0W5aL@06JFUY=CDe<C4a<C4a=3@dBTY:0WmoO`06I6AT
@d=3ATI6ATI6KVi^JVYZ0WMgM`05?Shn>c/k>c/kKVi^HV9R008k>c/01Rh^;VEUIBh^;Rh^;R4Q8BXZ
:P8k>c/01[>c/`X:2S<c<c<c<bl_;cLg=`9hN7P01Di>CU9BDU9BDTU9BFEUI@02KVi^00IPH61>CTi;
Bd];Bd]=CDd[:b/2EeMG00IWIfM3@d=DE5ADE5@H61Pe=CD28b<S00E9BDU<C4aMGEeMGEdT92@00STi
>@06JFUY>c/k820P820PPX:2@D510Tm?C`05:2PXoooooooooooo000002Coool200000_ooo`030000
oooo000000?oool010000?ooooooooOgm`97AdL01HJ6QXn?Sg5aLG5aLD10@002A4A400HN7Qi=CDe1
@D51@D5mOGePH602:2PX00J=SHd410AaLG5aLG6EUID=3@d2E5AD00DF5QHe=CDe=CEMGEe1@D400U]K
F`06F5QH6QXJ@410@410:RXZ30`<0R0P80054a<CB4Q8B4Q8?3`l=CDe008_;bl01RPX:24Q8ADE5ADE
5FYZJT51@@9QHF401CTi>D];Ba8B4Q8B4RHV9P02DE5A00IcLg<S8b<j>SXj>SXn?Sh?3`l2Kfm_00I4
A4@51@E6ATI6ATIGEeM=CDd2BDU900DR8R8i>CTi>CUPH60b<S800U5AD@06=SHfCTi>C4a<C4a<DU9B
Fe]K0QlO7`04PH61I6ATI6ATA4A40bPX:006EEEEMWIfKFe]KFe]>3PhB4Q80V1PH005Ng]kLG5aCTi>
CTi>@D51009WIfL01W=cLbl_;c<c<c<c<gYjNQdM7@8e=CD01D10@30`<;Vi^KVi^B<S8`02:b/[00HL
71`/;2a/K6a/K6a5ADECDe<2?Shn00IDE5ASHf=7AdM7AdM^KViYJFT2EUIF00E;Bd/n?Shn?SilO7`k
>c/00UYJFP064a<C<c<c71`L71`L?ShnHf=S0V][J`05<S8b71`LQXJ6QXJ68b<S008g=cL01Fm_Ke9B
DTQ8B4Q8B2@T9003oooo00<0003oooooool03Oooo`006Oooo`050000oooooooooooo000000Coool0
1@000?ooooooooooooKfmP02De=C00IcLg>YZJUZJVYZJVY5ADDn?Sh261PH00EKFe/_;bl_;bm`L71O
Gel00SLg=`06RHV93@d=Hf=SHf=SPH613@d=0U9BDP0692@T9RHV?Shn?ShnHV9RCTi>0Ta<C0057alO
EEEE5ADE5ADE7alO008L71`01P/;2cXj>SDe=CDe=C8b<T10@08Y:BT01R`/;2<S8fm_Kfm_KdI6AU9B
DP93@d<01EEEEADE5A<C4a<C4f5QH@02G5aL00H];Be1@D4^;Rh^;RhI6AUTI6@2>SXj00H820Q4A4AG
EeMGEeM>CTi8B4P2:2PX00Dd=3ASHf<X:2PX:2QGEeL00Slo?`06CTi>DE5AEEEEEEEEDU9B;Rh^0W5a
L@06JFUY=CDe<C4a<C4a=3@dBTY:0WmoO`06I6AT@d=3ATI6ATI6KVi^JVYZ0WMgM`05?Shn>c/k>c/k
KVi^HV9R008k>c/01Rh^;VEUIBh^;Rh^;R4Q8BXZ:P8k>c/01[>c/`X:2S<c<c<c<bl_;cLg=`9hN7P0
1Di>CU9BDU9BDTU9BFEUI@02KVi^00IPH61>CTi;Bd];Bd]=CDd[:b/2EeMG00IWIfM3@d=DE5ADE5@H
61Pe=CD28b<S00E9BDU<C4aMGEeMGEdT92@00STi>@06JFUY>c/k820P820PPX:2@D510Tm?C`05:2PX
oooooooooooo000002Goool01@000?ooooooooooo`000004oooo00@0003oooooooogmoL2AdM700F6
QXJ?ShmaLG5aLG50@4000TA4A0067QhNCDe=@D51@D51OGemH61P0RPX:006SHf=10@4LG5aLG5aUIFE
3@d=0UADE0055QHF=CDe=CDeGEeM@D51009KFe/01UQHF1XJ6T10@410@2XZ:P`<308P82001A<C4dQ8
B4Q8B3`l?3De=@02;bl_00HX:2PQ8B4E5ADE5AEZJVY1@D42HF5Q00Di>CU;Bd/B4Q8B4Q8V9RH00U5A
D@06Lg=c8b<S>SXj>SXj?Shn3`l?0Vm_K`06A4A41@D5ATI6ATI6EeMGCDe=0TU9B@058R8R>CTi>CTi
H61P<S8b009ADE401SHf=Ti>CTa<C4a<C59BDU]KF`8O7al01861PFATI6ATI4A4A0<X:2P01UEEEGIf
MVe]KFe]KCPh>4Q8B09PH6001G]kNg5aLDi>CTi>CT51@@02IfMW00IcLg<_;blc<c<c<c=jNWXM7Ad2
=CDe00E0@40`<32i^KVi^KTS8b<00R/[:`0671`L;2`/K6a/K6a/ADE5De=C0Shn?P06E5ADHf=SAdM7
AdM7KVi^JFUY0UIFEP05Bd];?Shn?ShnO7al>c/k009JFUX01Q<C4c<c<a`L71`L73hn?V=SH`9[Jf/0
1C8b<Q`L78J6QXJ6QR<S8`02=cLg00E_KfmBDU98B4Q8B4PT92@00oooo`030000oooooooo00goool0
02;oool01@000?ooooooooooofm_K`02=SHf00Hk>c/;2`]<C4a<C4ahN7Q[Jf/2E5AD00EHF5PB4Q8B
4Q:f][HL71`00PT92@06=SHf8B4Q820P820P/[:bD51@0T92@P068B4Q=SHf=SHf=SHf4Q8B?Cdm0/S8
b005I6AT?3`l:b/[:b/[HV9R009>CTh01Pd=3C4a<Bl_;bl_;aDE5CPh>09VIVH01S4a<@T92Fi^KVi^
KPX:2Sdm?@8;2`/01FQXJ8>3Pg=cLg=cLbLW9`02>c/k00H];Bdi>CU:BTY:BTYTI6A5ADD28B4Q00HD
51BDU9A7AdM7AdMZJVY6ATH2:b/[00DJ6QYWIfMZJVYZJVXl?3`00S0`<006De=CHf=S61PH61PH@410
8R8R0Vi^KP06Cdm?7alO820P820P>3Ph2@T90QPH6006L71`HV9RRh^;Rh^;QhN7<c<c0Slo?`05KVi^
;2`/;2`/@4104A4A008J6QX01UEEEDU9BBl_;bl_;eQHF3Ph>08e=CD01S@d=0l?3bHV9RHV9Sdm?ATI
6@9SHf<01F9RHS`l?3`l?20P85ADE002D51@00I1@D4T92A?Cdm?CdmbLW8h>3P2DU9B00He=CEfMWIW
IfMWIfN0P81]KFd2EUIF00DZ:RYhN7QkNg]kNg]aLG400V][J`06@d=38R8RDE5ADE5A;2`/GEeM0PD5
1@05MWIfoooooooooooo000002koool010000?ooooooog=cL`8o?cl01DA4A1<C4dE5ADE5AG5aL@02
MgMg00I4A4A]KFd30`<30`>ZZZX[:b/26ATI00HP820^;Rhf=SHf=SK1`L5MGEd2BDU900Df=SHW9bLW
9bLk>c/J6QX00S@d=006clo?H61P?Cdm?Cdm7QhNFEUI0Ti>CP05820PBDU9BDU9:BTY7AdM008Y:BT0
1Tm?CbHV9P/;2`/;2fm_K`d=3@90@4001@X:2Va/K820P820P7AdM0029bLW00I4A4@X:2Q1@D51@D50
@41OGel2E5AD00HO7alT92BCTi>CTi<h>3QdM7@2>3Ph00Db<S8U9BDU9BEZJVYQHF400T10@006<S8b
De=CI6ATI6AT5aLG@T920Q`L7005N7QhADE5ADE57alO8R8R008c<c<01Q<C4aDE5GUiNGUiNG5aLGmo
O`9fMWH01DE5ACHf=X20P820P1lO7`02>SXj00HM7AdC4a=FEUIFEUI;Bd/a<C42DU9B00Dg=cM2@T92
@T92@T8Q8B400S4a<@06;2`/1@D5DE5ADE5AFUYJCTi>0R`/;006EUIFF5QH@D51@D51<30`ADE50V5Q
H@05AdM7@D51@D51ADE5M7Ad009KFe/01Xb<S6UYJE9BDU9BDR/[:fe]K@9kNg/01F][JgalO4Y:BTY:
BP/;2`02Hf=S00E2@T9:BTX?3`l?3`mVIVH00oooo`030000oooooooo00goool002;oool01@000?oo
ooooooooogUiN@02;2`/00H^;Rj7QhMWIfMWIfN?ShmfMWH2HF5Q00EOGem/K6a/K6bMWIe@D5000Q<C
4`06N7Qh5ADE7alO7alO?3`lDE5A0UEEE@06HF5QJf][>CTi>CTi820P>SXj0WIfMP055aLG=3@dL71`
L71`;bl_008o?cl01S`l?2DU9AXJ6QXJ6RHV9Ti>CP8[:b/01Ti>CTM7Afm_Kfm_KfATI3Ph>08V9RH0
1A<C4clo?aXJ6QXJ6T51@@02CTi>00H/;2a3@d=:BTY:BTZPX:1JFUX230`<00I]KFdm?Ce2@T92@T8^
;RhZ:RX24A4A00EHF5PE5ADm?Cdm?CeADE400QDE5@06?3`l1PH6<S8b<S8bFEUICTi>0RLW9`066a/K
Fe]K;bl_;bl_ADE5:RXZ0PH61P06YZJVGEeM@410@410OWin5QHF0Te=C@05@410?Shn?Shn3`l?;2`/
008L71`01SHf=XR8R3Xj>SXj>[Ng]ahN7P9MGEd01RHV9QPH66ATI6ATI3dm?GmoO`9FEUH01F][JeiN
GUiNGUaLG7AdM002;2`/00Hg=cM8B4P];Bd];BdA4A4j>SX2@D5100HJ6QXQ8B5FEUIFEUI1@D4F5QH2
A4A400DK6a^5QHELG5aLG5aXJ6P00Q`L7006QHF5>c/k@T92@T92I6AT@T920[>c/`05UiNGoooooooo
oooo000002koool010000?ooooooofMWI`93@d<01B8R8YfMWEYJFUYJFYjNWP02J6QX00IYJFUGEeM_
Kfm_KfnMWIe=CDd230`<00J5QHDS8b<b<S8b<S8h>3QBDU82K6a/00=DE5A]KFe]KFd00S<c<`8Y:BT0
1VYZJR4Q8BXZ:RXZ:WMgMc@d=08o?cl01Cdm?BLW9bLW9a/K6b`/;002E5AD00Hc<c=9BDTn?Shn?Si[
Jf]EEED2@d=300DN7QhI6AT^;Rh^;Rh[:b/00TQ8B006D51@:RXZBDU9BDU9DE5AXj>S0UEEE@064A4A
Kfm_ATI6ATI6D51@<c<c0R4Q8@055QHFHV9RHV9R3`l?A4A4008l?3`01RXZ:S@d=0/;2`/;2bHV9VEU
I@94A4@01B/[:aHF5QHF5UMGEc0`<002=cLg00Ha<C4C4a>g]kNg]kM^KVh`<302LG5a00DS8b=3@d=:
BTY:BTXc<c<00Pd=3@068b<S92@T>CTi>CTiQXJ6<c<c0[fm_@057AdMGemO:BTY:BTY6ATI009UIFD0
1S/k>h61PEYJFUYJFVEUIEiNGP9JFUX01W]kNbHV9S8b<S8b<TE5AC0`<0892@T01D92@T];Bd];BahN
7RDU9@02B4Q800Hb<S8:2PXi>CTi>CTE5AFATI42E5AD00E]KFdM7Af6QXJ6QXI3@d<00T92@P05Jf][
>c/kYZJVYZJVRHV900?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooomhN7P00UEE
E@06CDe=P820I6ATI6ATGemOOGem0RDU9@05V9RH/[:b/[:bDe=C:b/[008M7Ad01W=cLjb/[8B4Q8B4
Q2PX:6][J`8R8R8012PX:5YJFQXJ6QXJ6P8_;bl2=3@d00E=CDdQ8B4R8R8R8R9>CTh00W9bLP06=cLg
2@T930`<30`<<S8bBDU90SHf=P06Fe]KD51@EEEEEEEEGUiNRHV90Ph>3P059bLW;Bd]ADE5ADE592@T
009dM7@01UEEEEmOGeYJFUYJFPD51D92@P9TI6@01R<S8da<C3Lg=cLg=da<C4E5A@9?Cdl01IBDU8Z:
RVQXJ6QXJ3lo?`02O7al00JTY:A:BTY0@410@40W9bMADE42GUiN00IBDU8k>c/_;bl_;bmFEUHd=3@2
DU9B00J;Rh]FEUI4A4A4A4A;Bd/51@D2EEEE00E6ATIUIFEUIFD/;2`n?Sh00V=SH`064A4AMWIf20P8
20P8WinOC4a<0R0P80049BDUDE5A3@d=3@d=0TI6AP97AdL01CHf=VUYJFUYJA@D55aLG0024A4A00II
FEU2@T8O7alO7alL71bRXZ82:BTY00IeMGF0P81_Kfm_KflU9BE=CDd2GUiN00ELG5a4A4@Z:RXZ:RYk
Ng/00U1@D0067AdMADE5G5aLG5aL>SXjF5QH0Sdm?@05[Jf]oooooooooooo000002koool010000?oo
ooooohN7Q`94A4@01E9BDWinOWinOWinOV5QH@02O7al00I2@T:1PH7=cLg=cLeYJFU3@d<2<c<c00I[
Jf^OWinKVi^KVi/C4a=LG5`2:2PX00D?3`m9BDU9BDTd=3@l?3`00QXJ6P06<30`BTY:;2`/;2`/;bl_
EEEE0V][J`05>CTi4A4A4A4A71`L=SHf009KFe/01T];Be=CDd92@T92@Slo?e5AD@:QXJ401B8R8SLg
=ahN7QhN7T];B`0271`L00IaLG5HF5QRHV9RHV9KFe/A4A42B4Q800INGUhj>SYVIVIVIVHO7amHF5P2
:b/[00Db<S:6QXJ6QXJOWimZJVX00U1@D006KFe]ZZZZAdM7AdM7CDe=:b/[0T51@@05GemOG5aLG5aL
8b<S:RXZ009:BTX01Sdm?EYJFZ>SXj>SXeiNGTM7A`9;Bd/01@/;2dU9BDU9BDU9BF9RHP02<30`00Hh
>3Q]KFdF5QHF5QIXJ6P=3@d2UiNG00EEEEDY:BTf=SHf=SIGEeL00PD51@06?Cdm@d=3ADE5ADE5=SHf
JFUY0Q/K6`06FUYJ2@T9Hf=SHf=S;bl_<S8b0Q/K6`05TY:B8R8R8R8RJVYZRHV9009/K6`01R@T94Y:
BU1@D51@D4Y:BU1@D08^;Rh01HN7QeUIF@410@410F1PH002I6AT00ECDe=:BTY9BDU9BDVk^k/00ooo
o`030000oooooooo00goool002;oool200000_ooo`05N7QhEEEEEEEECDe=P820009TI6@01EmOGgem
OBDU9BDU9IRHV002/[:b00ICDe<[:b/M7AdM7AecLg>/[:`2Q8B400HX:2Q[Jf/R8R8R8R8X:2QJFUX2
6QXJ0Rl_;`8d=3@01De=CB4Q8B8R8R8R8Ti>CP02LW9b00Hg=cL92@T<30`<30`b<S99BDT2=SHf00IK
Fe]@D51EEEEEEEENGUj9RHT23Ph>00DW9bL];Be5ADE5ADDT92@00WAdM006EEEEGemOFUYJFUYJ1@D5
@T920VATI0068b<SC4a<=cLg=cLgC4a<ADE50Tm?C`05U9BDRXZ:J6QXJ6QX?clo009lO7`01ZBTY4Y:
BT10@410@2LW9e5AD@9NGUh01U9BDS/k>bl_;bl_;eIFES@d=09BDU801X^;ReIFETA4A4A4A4];B`D5
1@9EEED01DI6AVEUIFEUIB`/;3hn?P02Hf=S00HA4A5fMWH820P820ROWim<C4`2820P00@U9BEADE4=
3@d=3@d2ATI60TM7A`05=SHfJFUYJFUY51@DG5aL008A4A401UUIFD92@QlO7alO7a`L7::RXP8Y:BT0
1WEeMH20P6m_Kfm_KbDU9De=C@9NGUh01EaLG4A4A2XZ:RXZ:W]kN`02D51@00HM7Ae5ADELG5aLG5`j
>SYHF5P2?Cdm00>][Jgoooooool00P0002koool2000000Gooon7QhM4A4A4A4ABDU800ginOP05HF5Q
O7alO7al@T92PH6100;=cLd01VUYJD=3@c<c<c<c<f][JinOW`:KVi/01A<C4eaLG2PX:2PX:0l?3`02
BDU900Hd=3@l?3`J6QXJ6QX`<31:BTX2;2`/00D_;bmEEEE[Jf][Jf/i>CT00Q4A4@0671`L=SHfFe]K
Fe]KBd];De=C0T92@P06?cloDE5AXJ6QXJ6Q8R8R=cLg0QhN7P05Bd];71`L71`LLG5aF5QH009RHV80
1U]KFa4A4DQ8B4Q8B5iNGSXj>P9VIVH01AlO7eQHF2/[:b/[:c8b<P02QXJ600JOWimZJVY@D51@D51]
KFfZZZX2AdM700E=CDd[:b]1@D51@D5OGel00UaLG0068b<S:RXZBTY:BTY:?CdmFUYJ0Z>SX`05GUiN
AdM7Bd];Bd];2`/;00=9BDT01F9RHS0`<30`<3Ph>6e]K@025QHF00IXJ6P=3@fGUiNGUiMEEEDY:BT2
=SHf00EGEeL51@D51@Dm?Ce3@d<00TE5A@06=SHfJFUY6a/K6a/KFUYJ2@T90V=SH`05;bl_<S8b6a/K
6a/KTY:B008R8R801VYZJXV9RFa/K6a/K2@T94Y:BP9@D5001TY:BU1@D2h^;Rh^;XN7QeUIF@810@40
1F1PH6ATI6ATI5=CDdY:BP02BDU900>k^k_oooooool00P0000ooool002;oool01@000?oooooooooo
olo?c`02=cLg00IOGemPH60:2PX:2PZGUiLc<c<2EeMG00DN7QiVIVIVIVHE5ADF5QH00QlO7`9nOWh2
;2`/00H:2PXY:BTS8b<S8b<;2`/^;Rh28b<S00H=3@dW9bM3@d=3@d<_;bm_Kfl2>3Ph00Dl?3`j>SXj
>SY:BTXi>CT00SXj>P064A4AHf=S4A4A4A4A:BTY51@D0Y6AT@0661PH@410<C4a<C4a:2PX6a/K0RDU
9@05@D51HF5QHF5Q820P[jn_009_Kfl01QlO7`l?3aTI6ATI6BTY:ATI6@8a<C401TQ8B:ZZZPT92@T9
2H:2PP`<30:HV9P01FMWIe5ADE5ADBDU9FATI002HV9R00Hg=cLY:BTh>3Ph>3P`<316ATH2820P00IP
H60;2`/A4A4A4A6KVi]SHf<2?clo00D[:b/K6a/`<30`<30F5QH00TI6AP0661PH6ATI71`L71`L@D51
?clo0S0`<006GemOQXJ6C4a<C4a<=3@dG5aL0S/k>`05410@=3@d9BDU9BDUF5QH008V9RH01V=SHfIV
IShn?Shn?Ta<C1hN7P8];Bd01U=CDg9bLRTY:BTY:IBDU5QHF08m?Cd01U5ADB4Q8E5ADE5ADHF5QEEE
E@:>SXh01Clo?hV9RHV9RJJVYTQ8B002Vi^K00Dg=cNZZZYlO7alO7b7QhL00oooo`030000oooooooo
02coool010000?oooooookZj^P8[:b/01Fe]KEIFEQ<C4a<C4ijNWP02:2PX00IKFe/A4A5`L71`L70L
71`C4a<2:RXZ00IcLg=`L70h>3Ph>3PE5ADK6a/271`L00DG5aLS8b<S8b<Y:BTJ6QX00R4Q8@05@d=3
:2PXN7QhN7Qh>3Ph00<j>SX01DU9BCPh>3Ph>3De=@/;2`02K6a/00HK6a/J6QX71`L71`N0P80[:b/2
DE5A00Da<C4m?Cd61PH61PHd=3@00S4a<@06CDe==3@dX:2PX:2PNGUi6QXJ0P820P0661PH8b<S3`l?
3`l?;Rh^F5QH0X^;R`05;2`/IfMWIfMW:2PXYjNW009cLg<01SXj>Q/K6eIFEUIFEUYJFSXj>P8M7Ad0
1Clo?dQ8B4Q8B3De=Bl_;`02Bd];00HP820E5AFZZZZZZZYGEeM0@4029BDU00DO7alW9bLA4A4A4A51
@D400Q<C4`069RHV;2`/EEEEEEEE@410=SHf0TQ8B005QhN7CTi>8b<S8b<SI6AT008a<C401Q0@438b
<RPX:2PX:59BDQhN7P9IFET01V][JdU9BD10@410@1DE5D51@@9RHV801EeMGC0`<30`<8R8R6][J`02
;bl_00I6ATHT92ACDe=CDe>0P81MGEd2RXZ:00E8B4R:RXZXZ:RXZ:QSHf<00[>c/`05?Shn[:b/V9RH
V9RHW9bL00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooooYjNT00UeMG@06EEEE
:2PXADE5ADE5L71`8B4Q0SLg=`05<30`;2`/;2`/AdM7<30`009JFUX01VATI6YZJR8R8R8R8T];BcPh
>08S8b<01TM7Af=SHdU9BDU9BCDe=FQXJ08Q8B401CTi>K2`/7EeMGEeMC4a<@02ADE500HS8b=TI6@n
?Shn?Shd=3AQHF423`l?00Hh>3PY:BUKFe]KFe/D51@d=3@2@d=300D@411ADE5YJFUYJFUOGel00VIV
IP06@D51R8R8C4a<C4a<<S8b9bLW0Rd];@06D51@1@D5TY:BTY:B51@D=SHf0RLW9`05PX:2;2`/:BTY
:BTY7alO009IFET01RPX:7inOUeMGEeMGB`/;4m?C`8U9BD01U1@D4U9BC/k>c/k>dm?CeQHF08b<S80
1WAdM2l_;c`l?3`l?1lO7b0P808=3@d01BXZ:R8R8R8R8S@d=6MWI`022@T900INGUiHF5Pg=cLg=cMD
E5@[:b/2BDU900EOGem1@D4_;bl_;blh>3P00f=SH`05DE5A=3@d=3@dLG5a7QhN009CDe<01UUIFHF5
QHV9RHV9RDY:BQdM7@8@41001UEEEBXZ:S<c<c<c<f9RHSPh>08Q8B401C/k>`d=3GEeMGEeMG9bLP02
Bd];00Jg]kM?CdlT92@T92BJVYY0@402YjNW00Da<C7oooooooooool00000;_ooo`040000oooooooo
kno_0VATI005Cdm?;2`/ADE5ADE5LW9b008M7Ad01Shn?S8b<R`/;2`/;4];BbPX:09=CDd01V5QHFAT
I1lO7alO7eADE3hn?P8O7al01D=3@fUYJFUYJD92@S@d=002H61P00HV9RH`<32j^[Zj^[Y/K6`_;bl2
B4Q800DT92AMGEeMGEe6ATHZ:RX00UEEE@066a/K;2`/<30`<30`DU9B4a<C0RXZ:P05ADE54A4A@d=3
@d=3MWIf009WIfL2EeMG0W9bLP06H61P:BTY51@D51@D71`LI6AT0QPH6005PH619RHV>CTi>CTi<30`
009]KFd01SPh>38b<Rl_;bl_;d92@T10@09WIfL01D];Bchn?TA4A4A4A3<c<`02H61P00ILG5`V9RIM
GEeMGEe6ATH`<302J6QX00HW9bLY:BT;2`/;2`/_;bl@41027AdM00DJ6QXV9RHV9RIFEUH@41000Vi^
KP06Kfm_ATI6?clo?clo=CDe>3Ph0Ti>CP05@D519BDU9BDU<S8bI6AT009XJ6P01T];Bbd];FMWIfMW
IbXZ:U]KF`9MGEd01GMgMiBDU4a<C4a<C2HV9P025aLG00INGUh`<30Z:RXZ:RYLG5`b<S827AdM00Hn
?Sh>3PihN7QhN7QZJVYEEED2^[Zj00ENGUh[:b/[:b^BTY8f=SH00ZZZZP05<S8boooooooooooo0000
00ooool002;oool01@000?ooooooooooonWYj@02GEeM00IEEEDX:2Q5ADE5ADE`L70Q8B42=cLg00D`
<30/;2`/;2a7AdL`<3000UYJFP06I6ATJVYZ8R8R8R8RBd];>3Ph0R<S8`06AdM7Hf=SBDU9BDU9=CDe
J6QX0R4Q8@05>CTi/;2`MGEeMGEe<C4a0095ADD01R<S8fATI3hn?Shn?S@d=65QH@8?3`l01SPh>2TY
:E]KFe]KFa@D53@d=093@d<01A0@455ADFUYJFUYJEmOG`02IVIV00I1@D68R8Q<C4a<C4`b<S8W9bL2
;Bd]00I@D5051@FBTY:BTY8D51@f=SH29bLW00F2PX8/;2`Y:BTY:BTO7al00UUIF@06:2PXOWinGEeM
GEeM;2`/Cdm?0RDU9@06D51@BDU9>c/k>c/kCdm?F5QH0S8b<P06M7Ad;bl_?3`l?3`l7alO820P0Pd=
3@05:RXZ8R8R8R8R=3@dIfMW00892@T01UiNGUQHF3Lg=cLg=eADE2/[:`99BDT01EmOGd51@Bl_;bl_
;cPh>003Hf=S00EADE4d=3@d=3AaLG4N7Qh00U=CD`06FEUIQHF5RHV9RHV9BTY:7AdM0Q0@4006EEEE
:RXZ<c<c<c<cHV9R>3Ph0R4Q8@05>c/k3@d=MGEeMGEeLW9b009;Bd/01[Ng]dm?Cb@T92@T99ZJVT10
@0:WYjL01C4a<Oooooooooooo`00000^oooo00@0003oooooooo_knl2I6AT00E?Cdl/;2a5ADE5ADEb
LW800QdM7@06?Shn<S8b;2`/;2`/Bd];:2PX0Te=C@06HF5QI6AT7alO7alOE5AD?Shn0QlO7`05@d=3
JFUYJFUY@T92=3@d009PH6001RHV9S0`<;Zj^[Zj^Va/K2l_;`98B4P01B@T95eMGEeMGDI6ARXZ:P02
EEEE00HK6a//;2``<30`<31BDU8C4a<2:RXZ00E5ADDA4A53@d=3@d=fMWH00VMWI`9GEeL2LW9b00IP
H60Y:BTD51@D51@L71aTI6@261PH00F1PH4V9RHi>CTi>CT`<3000Ve]K@06>3Ph<S8b;bl_;bl_@T92
@4100VMWI`05Bd];?ShnA4A4A4A4<c<c009PH6001UaLG2HV9UeMGEeMGDI6AS0`<09XJ6P01RLW9bTY
:@/;2`/;2bl_;a0@408M7Ad01AXJ6RHV9RHV9UIFEQ0@4002KVi^00I_Kfm6ATHo?clo?cle=CDh>3P2
CTi>00E1@D4U9BDU9BDb<S9TI6@00VQXJ006Bd];;Bd]IfMWIfMW:RXZFe]K0UeMG@05MgMgU9BDC4a<
C4a<9RHV008G5aL01UiNGS0`<2XZ:RXZ:UaLG38b<P8M7Ad01Shn?Ph>3WQhN7QhN6YZJUEEE@:j^[X0
1EiNGR/[:b/[:i:BTSHf=P02ZZZZ00Db<S;oooooooooool000003oooo`008_ooo`030000oooooooo
00;oool25aLG00Jc/k<Y:BTZ:RXZ:RXN7Qhj>SX2@T9200EhN7QCDe=CDe=7AdM:BTX00/[:bP067QhN
Kfm_LW9bLW9bADE5?clo0QXJ6P04:2PX;Rh^5aLG5aLG0VEUI@9bLW801B@T961PH3Xj>SXj>T10@002
6ATI00JOWimaLG4G5aLG5aL[:b^GUiL2A4A400IFEUHl?3b7QhN7QhLY:BTj>SX2FEUI00EiNGTL71`_
;bl_;bmCDe<00S`l?006EUIF<S8b9BDU9BDULW9b:BTY0Slo?`0630`<Ng]kJVYZJVYZ820P9RHV0T51
@@058B4QHV9ROgmoOgmoHF5Q009ZJVX01VATI8V9RD10@410@2l_;hZ:RP9_Kfl01U9BDR/[:cHf=SHf
=UMGEaXJ6P9CDe<01QLG5cdm?EADE5ADE3lo?dU9B@8n?Sh01DU9BHb<S8b<S3`l?5mOG`02DE5A00I6
ATISHf<k>c/k>c/J6QXZ:RX2M7Ad00IBDU8>3PiSHf=SHf<[:b/N7Qh2>3Ph00D=3@dZ:RXZ:RYJFUXl
?3`00SDe=@06<S8bGemOBDU9BDU9BTY:JVYZ0R/[:`0651@DBd];4Q8B4Q8BADE5>3Ph0PP82005D51@
Fe]K@D51@D51H61P008H61P01V][Jc<c<eEEEEEEEHN7Qb@T909TI6@01GinO_ooooooooooo`00000^
oooo00@0003oooooooooool292@T00FZZZX_;bl_;bl_;blK6a/00S/k>`04?CdmRHV9@D51@D510U9B
DP:k^k/01QTI6FEUIG=cLg=cLdU9BDY:BP8M7Ad01BLW9bl_;bl_;a@D55eMG@02H61P00IXJ6Pb<S9[
Jf][Jf/o?clc<c<2820P00FCTi=lO7alO7`P820b<S800Y:BTP06A4A4EEEE@410@410PH61<C4a0S<c
<`05EeMGMgMg7AdM7AdM>3Ph009JFUX01TE5AE]KFcDe=CDe=Bd];F][J`8_;bl01SPh>0h>3WmoOgmo
OfIVIRPX:08^;Rh01D];BalO7alO7eUIFHB4Q002EeMG00I]KFeZJVYnOWinOWhk>c/d=3@2QXJ600Eg
MgMIFEUIFETS8b<l?3`00UMGE`067AdMBDU97QhN7QhN=3@dDe=C0SLg=`05De=CA4A4Cdm?Cdm?Q8B4
0091@D401V5QHDQ8B4M7AdM7Af=SHcHf=P8T92@01B<S8gEeMDQ8B4Q8B0@41002GemO00Hd=3@S8b<e
=CDe=CD51@DV9RH2DE5A00I6ATHh>3Q2@T92@T9HF5QBDU82D51@00EnOWhN7QhN7Qh820Q4A4@00P`<
3006>SXj>CTi0`<30`<3CDe=FUYJ0Shn?P05Fe]K1`L7FEUIFEUI8B4Q009HF5P01GAdM2h^;WQhN7Qh
N7MgM`03oooo00<0003oooooool03Oooo`008_ooo`050000ooooooooooooWIfM00851@D01TQ8B3dm
?C8b<S8b<Te=CDi>CP9`L7001De=CB/[:b/[:c8b<R`/;002MgMg00I1@D5<C4aEEEEEEEE8B4Rd];@2
5ADE00I?Cdl^;Rh/;2`/;2`O7anLW9`2;bl_00EUIFDc<c=2@T92@T8L71`00UEEE@06Jf][2@T9K6a/
K6a/:BTYXJ6Q0S/k>`06QXJ651@DAdM7AdM77AdM8R8R0ZVYZ@05EEEEE5ADIVIVIVIVJFUY008<30`0
1UMGEg5aLDY:BTY:BRh^;RDU9@9TI6@01STi>H61PA/K6a/K6clo?a4A4@8I6AT01Di>CTA4A6e]KFe]
KCdm?@02KFe]00I=CDe4A4AbLW9bLW9jNWYGEeL2:RXZ00I^KVh20P8_;bl_;bmGEeM9BDT2I6AT00HR
8R8?3`lj>SXj>SX;2`/];Bd2AdM700E1@D5RHV9RHV8d=3B3Ph<00W=cL`061PH6BTY:D51@D51@<30`
>c/k0VATI006;Rh^71`L8b<S8b<S410@=3@d0S4a<@038B4Q1PH61PH6009IFET2;bl_00IDE5@h>3Qn
OWinOWhJ6QYeMGD2FEUI00HT92AKFe]2@T92@T9/K6aNGUh2=cLg00E[Jf/X:2REUIFEUIDo?cl00Q<C
4`06JFUYEeMGMgMgMgMgC4a<NWYj0UEEE@05D51@oooooooooooo000002koool010000?ooooooojj^
[P8D51@01CHf=S@d=3dm?Cdm?E9BDP02EUIF00IfMWIKFe/];Bd];Be3@d<b<S82M7Ad00HW9bMNGUho
?clo?cmJFUZUYJD230`<00E4A4@/;2`/;2`e=CDS8b<00YfMW@069bLWHf=SADE5ADE5De=C:RXZ0Ti>
CP05Hf=S3`l?3`l?Kfm_8b<S00:WYjL01S0`<9BDU24Q8B4Q8CPh>2<S8`8I6AT01IjNWTU9BDQ8B4Q8
B61PH002MWIf00H20P9QHF5fMWIfMWI9BDTc<c<2:BTY00IQHF4g=cMhN7QhN7PR8R8n?Sh28R8R00DZ
:RY7AdM7AdMCDe=eMGD00Rd];@06NGUi@d=3?clo?cloKVi^NGUi0UIFEP05:2PXJ6QXJ6QX3@d=;2`/
009TI6@01Shn?U]KFbh^;Rh^;PL71d=3@`861PH01C<c<da<C3Xj>SXj>UeMG@02:b/[00J:RXYiNGT6
1PH61PI?CdmFEUH2;Rh^00Dl?3aXJ6PY:BTY:BTG5aL00RPX:0066ATI?3`l?3`l?3`l;Rh^2@T90UMG
E`06Fe]K<C4aE5ADE5AD@T92LG5a0R/[:`05PH61@d=3@d=3;Bd]@D51008n?Sh01W1`L6UYJBLW9bLW
9fMWIb<S8`:EUID01C/k>a0@46EUIFEUID92@P02Jf][00Da<C6;Rh]EEEEEEEENGUh00oooo`030000
oooooooo00goool002;oool200000_ooo`05=3@dHF5QHF5Q61PH?Shn008K6a/01Clo?ahN7WYjNWYj
NZBTY002@d=300JEUIELG5`b<S8b<S9OGelh>3P2F5QH00HR8R9TI6CDe=CDe=Bd];@Q8B429bLW00I?
Cdm]KFdR8R8R8R8b<S9GEeL2AdM700Dd=3A8B4Q8B4R<S8`c<c<00SLg=`06C4a<@D515ADE5ADE<c<c
820P0Te=C@06P820;Bd]D51@D51@J6QXNGUi0R/[:`052`/;>SXj>SXjL71`=3@d009eMGD01TU9BBXZ
:X>3Ph>3PeiNGU5AD@8l?3`01R@T91hN7QlO7alO7b0P87moO`8S8b<01B8R8WUiNGUiNKbl_3Xj>P02
[:b/00HM7Ad[:b]UIFEUIFE=CDe?Cdl2;2`/00IHF5QGEeLT92@T92@c<c=^KVh24a<C00DJ6QXh>3PP
820P820a<C400UUIF@06AdM7<C4a^k^k^k^kHf=SDE5A0W9bLP065ADEDe=CNWYjNWYjC4a<;Rh^0SXj
>P05C4a<?clo@D51@D518B4Q008J6QX01T51@Di>CUaLG5aLG2DU9G=cL`9NGUh01T92@RHV9U=CDe=C
Dc4a<FIVIP9>CTh01S@d=2XZ:Sdm?Cdm?C/k>bLW9`:TY:@01G]kNb@T92@T93Lg=da<C0027AdM00E]
KFdT92@^;Rh^;RiOGel00_ooo`80000^oooo0P000005oooo<c<cC4a<C4a<;bl_00<k>c/01E=CDc8b
<S8b<YJFUYnOW`02G5aL00J2PX9>CTi0@410@41ADE57AdL2I6AT00DW9bMADE73`l?3`l>l_;`00QTI
6@068b<SG5aLMWIfMWIf51@D?Cdm0V1PH005F5QH>3Ph@T92@T92S8b<008_;bl01S/k>d10@3Hf=SHf
=QXJ6S`l?08I6AT01STi>GEeMC0`<30`<5=CDf1PH09hN7P01AhN7QTI6ATI6Bd];HF5Q@02@D5100I[
Jf]NGUha<C4a<C5`L71?Cdl2F5QH00A5ADDP820G5aLG5aL361PH00J@T90R8R8U9BDU9BFCTi>VYZH2
@41000FJVYXM7AdU9BDU9BEYJFT00Te=C@06C4a<=SHfD51@D51@DU9B4A4A0R4Q8@06OGem92@T3`l?
3`l?@d=392@T0S<c<`05EeMG?clo?clo;Rh^bLW9009EEED01V=SHh:2PQPH61PH65YJFVm_K`99BDT0
0bl_;cXj>SXj>P02C4a<0TQ8B0066a/K<c<c@410@410D51@@d=30QDE5@9XJ6P2CDe=00D[:b]ADE5A
DE4m?CeDE5@00V1PH006BTY:<30`GUiNGUiN8B4Q71`L0Xb<S005UYJF2PX:8B4Q8B4QBTY:008A4A40
1GmoOc0`<4E5ADE5AGQhN002oooo0P0000ooool002;oool01@000?oooooooooooc@d=002HF5Q00HH
61Pn?ShK6a/K6a/o?clN7Qh2NWYj00FTY:A3@d=3@d>EUIELG5`00S8b<P06GemO>3PhF5QHF5QH8R8R
I6AT0]CDe006];Bd8B4Q9bLW9bLWCdm?KFe]0R8R8P05<S8bEeMGAdM7AdM7=3@d0098B4P01Xb<S3<c
<cLg=cLg=da<C451@@8E5AD01S<c<b0P84e=CDe=CH20P2d];@9@D5001FQXJ7UiNB/[:b/[:`/;2`02
>SXj00I`L70d=3AeMGEeMGE9BDTZ:RX2Ph>300INGUiADE4l?3`l?3`T92@N7Qh27alO00DP821oOglS
8b<S8b<R8R800WUiN@06_;bl>SXj[:b/[:b/7AdM:b/[0VEUI@06CDe=Cdm?;2`/;2`/F5QHEeMG0R@T
9006<c<cKVi^4a<C4a<C6QXJ>3Ph0R0P8005<C4aFEUIFEUIAdM7<C4a00:k^k/01V=SHe5ADG9bLW9b
LQDE5E=CD`9jNWX01Ta<C2h^;SXj>SXj>Ta<C3lo?`91@D401B4Q8AXJ6QXJ6T51@Di>CP02G5aL00HU
9BEcLg=NGUiNGUi2@T8V9RH2De=C00Ha<C5VIVI>CTi>CThd=3@Z:RX2?Cdm00Dk>c/W9bNTY:BTY:Ak
Ng/00R@T9006=cLgC4a<7AdM7AdMKFe]92@T0Rh^;P05GemOoooooooooooo000002koool010000?oo
oooooc<c<`9<C4`01Bl_;c/k>c/k>c/k>e=CD`02<S8b00JFUYJOWimLG5aLG5b2PX9>CTh2@41000IA
DE57AdMTI6ATI6@W9bMADE42`l?300Fl_;`I6ATI6ATS8b=LG5`00WIfMP0651@D?CdmH61PH61PF5QH
>3Ph0T92@P05S8b<;bl_;bl_>c/k@410008f=SH01QXJ6S`l?1TI6ATI6CTi>GEeM@8`<3001E=CDf1P
H7QhN7QhN1hN7P026ATI00H];Bf5QHE1@D51@D5[Jf]NGUh2<C4a00I`L71?CdmHF5QHF5Q5ADDP8202
5aLG0aPH6006T92@8R8R9BDU9BDUTi>CYZJV0T10@005VYZJ7AdM9BDU9BDUJFUY009=CDd01Ta<C3Hf
=U1@D51@D59BDQ4A4@8Q8B401WemOB@T90l?3`l?3d=3@b@T908c<c<01EMGEclo?clo?bh^;/W9b@02
EEEE00ISHf>2PX8H61PH61QJFUY_Kfl2BDU900<_;blj>SXj>SX00Ta<C098B4P01Q/K6c<c<d10@410
@51@D4=3@`8E5AD2J6QX0Te=C@05:b/[DE5ADE5A?CdmE5AD009PH6001TY:BS0`<5iNGUiNGR4Q8A`L
70:<S8`01IJFUPX:2R4Q8B4Q8DY:BP024A4A00EoOgl`<315ADE5ADEhN7P00oooo`030000oooooooo
00goool002;oool01@000?ooooooooooob@T9002Bd];00IOGem1@D4T92@T92A4A4@e=CD2<C4a00E?
CdmnOWinOWhA4A75aLD00UeMG@065ADEEUIFEeMGEeMG@T92P8200XF5Q@06HF5Q3@d=820P820PLW9b
GUiN0T10@005Cdm?8b<S@D51@D515QHF009QHF401U=CDbXZ:WEeMGEeMA4A4B<S8`8Y:BT01SXj>U1@
D3lo?clo?ijNWPl?3`9KFe/01G5aLFMWIbXZ:RXZ:RLW9`02EEEE00HD51@G5aM8B4Q8B4P@410e=CD2
BTY:00IKFe]BDU8820P820QZJVXR8R82=3@d00EgMgMTI6A@D51@D51>CTh00UADE006KVi^QXJ66a/K
6a/K>SXj;Rh^0S@d=08L71`29BDU00ICDe<l?3`30`<30`<820QYJFT2HF5Q00D[:b/M7AdO7alO7ale
=CD00TE5A@06Bd];OgmoCdm?Cdm?3@d=<C4a0UeMG@06CDe=VYZJWIfMWIfMGEeM:BTY0P/;2`057AdM
61PHLW9bLW9b9BDU009KFe/01S0`<3De=@P820P8234a<FEUI@9FEUH01Pd=3D51@ADE5ADE5BHV9R8R
8P8O7al01W=cLcLg=adM7AdM7F5QHDY:BP8K6a/01FIVIRHV9RHV9Q/K6a8B4P02DE5A00EOGemJFUY4
A4A4A4Be]KD00oooo`030000oooooooo02coool010000?ooooooobl_;`93@d<01FMWIc/k>c0`<30`
<2/[:`027AdM00I?CdmXJ6Q]KFe]KFdY:BVb/[82IVIV00H;2`]JFUYFEUIFEUI8B4QjNWX2MGEe00Eb
LW8>3Ph>3PhF5QJ:RXX00TU9B@06DE5AATI6:b/[:b/[A4A46ATI0VEUI@05De=C>SXj>SXjMGEe20P8
008=3@d01TI6AQhN7S`l?3`l?2PX:8^;R`8O7al01FATI79bLVQXJ6QXJ2LW9`02:2PX00IVIVH];BdG
5aLG5aMADE4[:b/26ATI00H^;Ri1@D5OGemOGelC4a=hN7P29RHV00Di>CUlO7alO7aVIVIFEUH00UMG
E`06IfMWFUYJMgMgMgMg4Q8B;2`/0T10@005?clo:2PX:2PX8b<S:b/[009ADE401Sdm?@@410L71`L7
1g9bLUiNGP8X:2P01BDU9ATI6CTi>CTi>DM7A`02C4a<00J1PH5GEeLD51@D51@/;2aKFe/2?3`l00F[
Zj^JVYYTI6ATI6@I6AT00PH61P067AdM92@TIFEUIFEU;Bd]Hf=S0RTY:@06>SXj61PH7QhN7QhNIVIV
GUiN0R<S8`05BDU9;Rh^;Rh^?3`l;bl_008Z:RX01Vi^KT];B`L71`L71f=SHbh^;P8J6QX01HF5QD=3
@`l?3`l?3c<c<`02=3@d00EjNWYNGUhb<S8b<S:i^KT00oooo`030000oooooooo00goool002;oool0
1@000?ooooooooooof5QH@02<C4a00I<C4`i>CU6ATI6ATI>CTijNWX27alO00E5ADF;Rh^;Rh]fMWIU
IFD00Rh^;P06DU9B;2`/GemOGemOJVYZATI60T51@@068B4Q=cLg>CTi>CTiMWIf5aLG0[>c/`059BDU
8R8RTI6ATI6A@d=3008Y:BT01Sdm?H20P0L71`L71eIFET];B`96ATH01Xb<S1<C4g=cLg=cLgalO69R
HP97AdL01D51@H20P6m_Kfm_KeEEE@02<S8b00H?3`l@410R8R8R8R8c<c<j>SX27AdM00IBDU8o?cmH
F5QHF5QRHV8];Bd2DU9B00EFEUI1@D65QHF5QHENGUh00Ve]K@06Cdm?=SHf@410@410B4Q8CDe=0U=C
D`062PX:IFEUHf=SHf=S9RHV3@d=0UADE006:2PX?Cdm:RXZ:RXZC4a<61PH0RTY:@055aLG9RHV9RHV
<S8bEUIF0095ADD01Rl_;dE5AAPH61PH69VIVEaLG09iNGT01SDe=B<S8`X:2PX:2V=SHg9bLP9QHF40
1A/K6emOGemOGeQHF38b<P02AdM700HS8b=JFUXh>3Ph>3QLG5aSHf<2@D5100HG5aMNGUjg]kNg]kLQ
8B5LG5`25ADE00Dh>3QGEeM;Bd];Bd]0@4000PX:2P06@T92?ShnNGUiNGUiF5QH4a<C0Rl_;`05JVYZ
oooooooooooo000002koool010000?ooooooof=SH`8^;Rh01DU9BCXj>Ta<C4a<C5IFEP02NGUi00HS
8b=1@D6>SXj>SXifMWI[Jf/29BDU00I=CDd`<31@D51@D51nOWhb<S82;2`/00Da<C5;Bd];Bd/Z:RZ5
QHD00QPH6006][Jf:2PX8R8R8R8RVYZJATI60SLg=`05?ShnLG5aLG5a71`LIfMW008g=cL01V9RHWal
O2HV9RHV9UiNGW=cL`9RHV801Da<C4=3@ginOWinOWAdM002EEEE00Hk>c/U9BDC4a<C4a<e=CDH61P2
8B4Q00H820Q8B4Q@D51@D515ADE^KVh2=cLg00EBDU9CDe=CDe=6ATJ3Ph<00U]KF`06M7AdATI6:RXZ
:RXZ=3@dAdM70TE5A@05I6AT3`l?3`l?LW9bF5QH008P82001QPH655ADAhN7QhN7T92@RLW9`9>CTh0
1ADE5Bh^;QTI6ATI6B@T9002=CDe00IEEEE<C4`f=SHf=SI4A4@>3Ph2SXj>00EWIfN9RHTn?Shn?ShR
8R800Q8B4P06I6ATIfMWEUIFEUIF4A4AGemO0UeMG@06<c<cB4Q89RHV9RHVEeMG>SXj0VATI005Fe]K
Bd];Bd];3`l?JVYZ00:^[Zh01RHV9UADE1/K6a/K6c`l?5iNGP9;Bd/01C`l?0`<3410@410@3hn?P02
NWYj00EHF5PB4Q8^;Rh^;RiWIfL00oooo`030000oooooooo00goool002;oool01@000?oooooooooo
omOGe`02FUYJ00HT92A_Kfm0@410@40m?Ce]KFd21PH600E9BDU2@T92@T9fMWHD51@00SPh>003De=C
=3@d>c/k008k>c/01CXj>STi>CTi>DI6ASLg=`029bLW00IcLg<Z:RZRXZ:RXZ90@40P8202Shn?00El
O7`l?3`l?3a3@d=CDe<00P`<3006?Cdm>CTi?Shn?ShnBTY:Cdm?0VYZJP068R8R7AdMFe]KFe]KJf][
5ADE0Q4A4@0551@D@D51@D515QHF5aLG008E5AD01TM7Ae]KFcHf=SHf=UiNGQPH609kNg/01RLW9aLG
5eEEEEEEEC@d=5MGE`8<30`01EMGEfi^KVi^KPP822d];@02CDe=00H[:b]TI6AGEeMGEeLn?Si:BTX2
>SXj00IRHV8o?cmfMWIfMWHI6ATM7Ad2?3`l00E8B4Pj>SY<C4a<C4a1@D400QdM7@06CDe=5aLG2PX:
2PX:Fe]KJVYZ0R@T9006Ph>3;Rh^I6ATI6ATBDU9A4A40V5QH@05]kNgEUIF=SHf=SHf:b/[008F5QH0
1UEEEAlO7b4Q8B4Q8EMGEfa/K09WIfL01S/k>e9BDR4Q8B4Q8BPX:1<C4`8M7Ad01T];Bbl_;b0P820P
86IVIRPX:09iNGT01L;2`R/[:b/[:b`/;861P@02;bl_00Da<C4E5AEXJ6QXJ6QEEED00oooo`030000
oooooooo02coool010000?ooooooon?Sh`9>CTh01Bh^;VEUIDe=CDe=CBXZ:P02QHF500HO7amGEeM@
D51@D51NGUhF5QH2=3@d00I3@d<V9RHk>c/k>c]7AdL^;Rh2?Cdm00E=CDdd=3@d=3@X:2Q]KFd00Rh^
;P06XJ6QADE55aLG5aLGVIVIPH610TQ8B005>CTiAdM7AdM7410@@410008_;bl01TU9BD92@U=CDe=C
DfMWIahN7P8C4a<01E=CDfa/K0410@410BDU9@026ATI00He=CDF5QHL71`L71`F5QI7AdL2E5AD00I5
ADE?Cdlb<S8b<S9cLg=1@D425QHF00E[Jf]CDe=CDe=1@D4Q8B400TY:BP06JFUY51@D:b/[:b/[CDe=
9RHV0UQHF005J6QXDE5ADE5A>SXjBd];009YJFT01R<S8hF5Q@T92@T92APH62HV9P8o?cl01D92@TQ8
B4Y:BTY:BR8R8P02De=C00HK6a/:2PYQHF5QHF5YJFTR8R82OGem00Db<S9[Jf]4A4A4A4A5ADD00VQX
J006/k>cDe=C<S8b<S8b92@T6QXJ0UiNGP068B4Q<c<cB4Q8B4Q8Ng]kEUIF0RPX:005@D518b<S8b<S
<C4a5ADE008N7Qh01TU9BCPh>1/K6a/K6eQHF3Xj>P:9RHT01KVi^BLW9c<c<c<c<g=cL`02Bd];00EA
DE4F5QIXJ6QXJ6QZJVX00oooo`030000oooooooo00goool002;oool01@000?ooooooooooomOGe`02
FUYJ00HT92A_Kfm0@410@40m?Ce]KFd21PH600E9BDU2@T92@T9fMWHD51@00SPh>003De=C=3@d>c/k
008k>c/01CXj>STi>CTi>DI6ASLg=`029bLW00IcLg<Z:RZRXZ:RXZ90@40P8202Shn?00ElO7`l?3`l
?3a3@d=CDe<00P`<3006?Cdm>CTi?Shn?ShnBTY:Cdm?0VYZJP068R8R7AdMFe]KFe]KJf][5ADE0Q4A
4@0551@D@D51@D515QHF5aLG008E5AD01TM7Ae]KFcHf=SHf=UiNGQPH609kNg/01RLW9aLG5eEEEEEE
EC@d=5MGE`8<30`01EMGEfi^KVi^KPP822d];@02CDe=00H[:b]TI6AGEeMGEeLn?Si:BTX2>SXj00IR
HV8o?cmfMWIfMWHI6ATM7Ad2?3`l00E8B4Pj>SY<C4a<C4a1@D400QdM7@06CDe=5aLG2PX:2PX:Fe]K
JVYZ0R@T9006Ph>3;Rh^I6ATI6ATBDU9A4A40V5QH@05]kNgEUIF=SHf=SHf:b/[008F5QH01UEEEAlO
7b4Q8B4Q8EMGEfa/K09WIfL01S/k>e9BDR4Q8B4Q8BPX:1<C4`8M7Ad01T];Bbl_;b0P820P86IVIRPX
:09iNGT01L;2`R/[:b/[:b`/;861P@02;bl_00Da<C4E5AEXJ6QXJ6QEEED00oooo`030000oooooooo
02coool010000?ooooooon?Sh`9>CTh01Bh^;VEUIDe=CDe=CBXZ:P02QHF500HO7amGEeM@D51@D51N
GUhF5QH2=3@d00I3@d<V9RHk>c/k>c]7AdL^;Rh2?Cdm00E=CDdd=3@d=3@X:2Q]KFd00Rh^;P06XJ6Q
ADE55aLG5aLGVIVIPH610TQ8B005>CTiAdM7AdM7410@@410008_;bl01TU9BD92@U=CDe=CDfMWIahN
7P8C4a<01E=CDfa/K0410@410BDU9@026ATI00He=CDF5QHL71`L71`F5QI7AdL2E5AD00I5ADE?Cdlb
<S8b<S9cLg=1@D425QHF00E[Jf]CDe=CDe=1@D4Q8B400TY:BP06JFUY51@D:b/[:b/[CDe=9RHV0UQH
F005J6QXDE5ADE5A>SXjBd];009YJFT01R<S8hF5Q@T92@T92APH62HV9P8o?cl01D92@TQ8B4Y:BTY:
BR8R8P02De=C00HK6a/:2PYQHF5QHF5YJFTR8R82OGem00Db<S9[Jf]4A4A4A4A5ADD00VQXJ006/k>c
De=C<S8b<S8b92@T6QXJ0UiNGP068B4Q<c<cB4Q8B4Q8Ng]kEUIF0RPX:005@D518b<S8b<S<C4a5ADE
008N7Qh01TU9BCPh>1/K6a/K6eQHF3Xj>P:9RHT01KVi^BLW9c<c<c<c<g=cL`02Bd];00EADE4F5QIX
J6QXJ6QZJVX00oooo`030000oooooooo00goool002;oool01@000?ooooooooooomcLg002<c<c00HY
:BVEUID^;Rh^;RiNGUhT92@2LG5a00D_;bl30`<30`=EEEE/K6`00VMWI`06;Bd]KFe]@T92@T92;bl_
OGem0ZFUY@06<C4aLG5a@T92@T92AdM7HV9R0UEEE@056a/K<c<c>3Ph>3PhJFUY008f=SH01RLW9bd]
;B/[:b/[:dY:BSDe=@8l?3`01TA4A5aLG4E5ADE5AA@D52<S8`9HF5P01Dm?C`L71a4A4A4A4A@D5003
8R8R00DV9RIGEeMGEeL;2`/X:2P00R/[:`06AdM7A4A4FEUIFEUI<30`7alO0UeMG@05@d=3B4Q8P820
P820>SXj008/;2`01RLW9dM7AeYJFUYJFQPH61LG5`9HF5P01SXj>RPX:6i^KVi^KSXj>TU9B@9QHF40
1S4a<E1@D5IFEUIFESDe=EYJFP9IFET01D51@Bl_;bl_;eUIFE9BDP022PX:00I=CDe3@d<h>3Ph>3P;
2`^8R8P2;Bd]00IHF5QBDU8O7alO7amgMgLh>3P2=cLg00DR8R8>3Ph>3PiMGEeLG5`00RXZ:P063`l?
820P5QHF5QHFLW9bEEEE0UeMG@06;Bd]D51@6QXJ6QXJ6ATI<C4a0T51@@05=cLg6ATI;bl_;bl_PX:2
008_;bl01SHf=VYZJVATI6ATI4m?CeUIF@:VYZH01L30`?ooooooooooo`00000^oooo00@0003ooooo
oooIfMT2<c<c00D/;2bHV9Ph>3Ph>3QFEUH00STi>@06PX:2A4A46ATI6ATI?ShnFe]K0VEUI@06:2PX
IVIV@d=3@d=3<30`Ogmo0YbLW005?ShnHV9RHV9R>CTiEeMG009HF5P01TQ8B10@43`l?3`l?3Hf=Va/
K08b<S801C0`<2LW9bLW9cTi>CLg=`02BDU90S0`<09IFET01Tm?CaHF5RLW9bLW9eYJFTA4A08B4Q80
1B0P81PH61PH62l_;`l?3`02>CTi00IcLg<B4Q8J6QXJ6QXE5AE:BTX2=3@d00EXJ6Pk>c/I6ATI6AUb
LW800U5AD@06>3PhPH61Bd];Bd];BTY:7AdM0Shn?P05J6QX71`L8B4Q8B4QGUiN008^;Rh01R/[:gEe
MCXj>SXj>T92@W9bLP8`<3001U]KFdA4A28R8R8R8UmOGdm?C`9>CTh01CXj>UiNGUiNGUADE1<C4`02
EEEE00Hk>c/];Bd<30`<30b0P80c<c<2GEeM00EFEUHS8b<S8b=gMgLm?Cd00SXj>P067AdM5aLGIfMW
IfMWDe=C;bl_0Q/K6`05;Bd]7alOGUiNGUiNBd];009VIVH01SDe=EYJFQ`L71`L71/K6cHf=P8n?Sh0
1S8b<R4Q8Clo?clo?g=cLcHf=P8R8R801Fi^KT];Bd];BfUYJFm_K`02Z:RX00G?clooooooooooool0
00003oooo`008_ooo`800002oooo00Fb/[9CDe=CDe<?3`moOgl00RTY:@05F5QHLW9b6ATI6ATI=SHf
009BDU801[6a/DY:BU9BDU9BDWEeMAlO7`8X:2P01Va/K5aLG1dM7AdM7E9BDUaLG095ADD01TM7AfQX
J8J6QXJ6QSDe=C0`<08D51@01AdM7@T92@T92BLW9b<S8`021PH600INGUi3@d<];Bd];BehN7P@4102
HV9R00=PH60M7Ae3@d<00T=3@`04@410820P820P<S8b0R4Q8@06Cdm?<C4a_kno_knoFe]K@T920SHf
=P06LG5a>3PhFe]KFe]K>SXjDe=C0TI6AP05<30`G5aLO7alO7alNWYj008j>SX01QXJ6QHF5S4a<C4a
<B/[:aHF5P8T92@01S0`<1dM7Cdm?Cdm?H>3PeADE08J6QX01VYZJY6ATA4A4A4A4Bd];EUIF@9RHV80
1AdM7CTi>CTi>CTi>IbLW002OGem00IADE4n?ShG5aLG5aLY:BV:RXX27QhN00I4A4AWIfLc<c<c<c>C
Ti>KVi/2:b/[00Dl?3`R8R8R8R8H61PS8b<00U1@D0061`L77alO6ATI6ATIA4A4?3`l0Slo?`06:BTY
>SXjKfm_Kfm_@D518R8R0Y>CT`05G5aLHV9RFUYJFUYJ@T92008h>3P01Rl_;cLg=e9BDU9BDTM7Ab/[
:`9RHV800fIVI_ooooooo`020000;_ooo`8000001_oook>c/di>CTi>CQ@D58V9R@8b<S801FATI6QX
J6QXJ1lO7cTi>@02DE5A00JYZJU4A4AEEEEEEEEeMGDS8b<292@T00EeMGE@D50[:b/[:b]CDe<00TU9
B@06<c<cEeMGGEeMGEeMSHf=>3Ph0R`/;00561PH8b<S4A4A4A4A7AdM008S8b<01QXJ6T];BcDe=CDe
=BXZ:X61P@8M7Ad01VATI6EUIAXJ6QXJ6T];BdY:BP8o?cl01BHV9S@d=3@d=1@D5451@@02CDe=00K5
aLEDE5ANGUiNGUhN7QiCDe<2BTY:00E7AdLo?cm:BTY:BTY2@T800R`/;006GEeMMGEeJf][Jf][?clo
;bl_0QDE5@057QhNAdM7:b/[:b/[6a/K008a<C401S<c<e9BDWEeMGEeMF1PH14A4@9XJ6P01Y:BTP`<
32PX:2PX:4e=CFa/K08<30`01B@T94m?Cdm?ChR8R8f=S@02E5AD00Hn?Sh;2`/d=3@d=3AlO7`Z:RX2
C4a<00E]KFda<C4a<C6@T92RXZ800S<c<`03>c/k8B4Q8b<S008S8b<01Chn?QXJ6QXJ6R0P82<S8`02
ATI600<];Bde=CDe=CD00S<c<`9dM7@01TI6AR0P89ZJVYZJVUEEEFUYJ@9DE5@01C<c<d=3@cXj>SXj
>RXZ:P02Fe]K00Dn?Shd=3AXJ6QXJ6QZJVX00_ooo`80000?oooo000Roooo00<0003oooooool00_oo
o`96ATH01U5ADA/K6clo?clo?hF5QFIVIP94A4@01EeMGEiNGUiNGWYjNWIfMP02E5AD00ILG5afMWHb
<S8b<S8i>CUIFET2A4A400IgMgM9BDUSHf=SHf<G5aLT92@2EeMG00E6ATIMGEeMGEeMGEeOGel00R8R
8P066QXJ7AdM<S8b<S8bJf][@T920Ti>CP06>SXjC4a<?3`l?3`lJFUY:BTY0V9RHP059BDUFEUIATI6
ATI6@4100091@D401@d=3FUYJDM7AdM7Aa/K6`037alO00HH61PK6a/M7AdM7Ae5ADD@4102<S8b00Eo
Oglj>SXi>CTi>CUDE5@00TI6AP03A4A4C4a<4A4A008A4A401BLW9bDU9BDU9@d=3FATI00251@D00IT
I6@E5ADU9BDU9BFCTi>][Jd2I6AT00Dn?Si4A4@_;bl_;blQ8B400XZ:RP062PX:@410FUYJFUYJEUIF
MWIf0Q<C4`06:BTY6ATI1`L71`L7:b/[De=C0S4a<@05?cloeMGE?Cdm?Cdm8b<S00892@T01QXJ6R`/
;2l_;bl_;d=3@fi^KP90@4001SHf=R4Q8De=CDe=CFUYJDe=C@8Q8B401VMWIahN7S@d=3@d=65QHB/[
:`8F5QH01FYZJTe=CDe=CH20P7AdM002Rh^;00Dh>3PG5aM>CTi>CTiiNGT00oooo`030000oooooooo
02coool010000?ooooooooooo`90@4001E=CDa/K6dM7AdM7AgemO@02IVIV00I0@41QHF5OGemOGemk
Ng]jNWX2D51@00IGEeM_Kfl_;bl_;ble=CE>CTh2CDe=00F4Q8A=CDe=CDeIFETJ6QX00R0P8006EEEE
BTY:FEUIFEUIHf=SGEeM0RHV9P056a/K;Bd];Bd]@T92FUYJ008a<C401UADE4];BeYJFUYJFTY:BV1P
H08b<S801E]KFbDU9EeMGEeMGDU9B@02B4Q800Hk>c/M7AeVIVIVIVHf=SHS8b<2=SHf00HR8R8O7al_
;bl_;blA4A4i>CT25ADE00DZ:RYnOWinOWhj>SXg=cL00Te=C@06>c/kEUIF>SXj>SXj4a<C:RXZ0S4a
<@056a/K9BDU9BDUJ6QX9BDU009EEED01R@T91XJ6YVIVIVIVJn_[fQXJ08e=CD01E5ADCPh>3<c<c<c
<gIfMP027alO00H];BeZJVY1@D51@D5aLG4W9bL2820P00DR8R8?3`la<C4a<C5CDe<00Rd];@06@T92
fm_KA4A4A4A4;bl_3Ph>0Q@D50069RHVA4A4=cLg=cLgJFUYBd];0R`/;0056ATIBDU9BDU9JVYZCTi>
008L71`01V1PH24Q8Chn?Shn?UYJFR`/;08F5QH01Fm_KdA4A8N7QhN7QgQhN002RXZ:00Di>CTF5QIA
DE5ADE5eMGD00oooo`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0TI6AP06DE5A
6a/K?clo?cloQHF5IVIV0TA4A005GEeMGUiNGUiNNWYjMWIf009DE5@01UaLG7IfMS8b<S8b<STi>EUI
F@94A4@01WMgMdU9BF=SHf=SHaLG5b@T909GEeL01DI6AUeMGEeMGEeMGEmOG`028R8R00HJ6QXM7Adb
<S8b<S9[Jf]2@T82CTi>00Hj>SY<C4`l?3`l?3aYJFTY:BT2HV9R00DU9BEIFEU6ATI6ATI0@4000T51
@@053@d=JFUYAdM7AdM76a/K00<O7al01QPH61/K6adM7AdM7DE5AA0@408b<S801GmoOcXj>STi>CTi
>EADE002ATI600=4A4A<C4`A4A400Q4A4@059bLW9BDU9BDU3@d=I6AT008D51@01VATI1DE5BDU9BDU
9I>CTjf][@9TI6@01Chn?TA4A2l_;bl_;b4Q8@02RXZ:00H:2PY0@41JFUYJFUYFEUIfMWH24a<C00HY
:BTI6AT71`L71`L[:b]CDe<2<C4a00Do?coEeMDm?Cdm?CdS8b<00PT92@066QXJ;2`/;bl_;bl_@d=3
KVi^0T10@006=SHf8B4QCDe=CDe=JFUYCDe=0R4Q8@06IfMW7QhN=3@d=3@dHF5Q:b/[0QHF5P05JVYZ
CDe=CDe=P820M7Ad00:;Rh/01CPh>1LG5di>CTi>CWUiN@03oooo00<0003oooooool0;?ooo`040000
oooooooooooo0T10@005De=C6a/KAdM7AdM7OGem009VIVH01T10@65QHEmOGemOGg]kNgYjNP9@D500
1UMGEfm_Kbl_;bl_;cDe=Di>CP9=CDd01HB4Q4e=CDe=CEUIFAXJ6P02820P00IEEEE:BTYIFEUIFEUS
Hf=MGEd29RHV00DK6a/];Bd];Be2@T9JFUX00S4a<@06E5ADBd];FUYJFUYJBTY:H61P0S8b<P05Fe]K
9BDUGEeMGEeMBDU90098B4P01S/k>adM7FIVIVIVISHf=R<S8`8f=SH01R8R8QlO7bl_;bl_;a4A4CTi
>@8E5AD01BXZ:WinOWinOSXj>SLg=`02CDe=00Hk>c]FEUHj>SXj>SXC4a<Z:RX2<C4a00DK6a/U9BDU
9BEXJ6PU9BD00UEEE@0692@T6QXJVIVIVIVI[jn_J6QX0SDe=@05DE5A>3Ph<c<c<c<cMWIf008O7al0
1Rd];FYZJT51@D51@G5aLBLW9`8P82001B8R8Pl?3c4a<C4a<E=CD`02;Bd]00I2@T;Kfm]4A4A4A4@_
;bl>3Ph251@D00HV9RI4A4@g=cLg=cMYJFU;Bd/2;2`/00DI6AU9BDU9BDUZJVY>CTh00Q`L7006H61P
8B4Q?Shn?ShnFUYJ;2`/0QHF5P05Kfm_A4A4QhN7QhN7N7Qh00::RXX01CTi>AHF5U5ADE5ADGEeM@03
oooo00<0003oooooool03Oooo`008_ooo`050000ooooooooooooeMGE009oOgl01VEUIEaLG3<c<c<c
<gmoOchn?P8F5QH01DI6AX:2PX:2PW9bLVe]K@02:RXZ00IIFEUBDU9YJFUYJFUfMWHh>3P2>c/k00Ho
?clj>SY?Cdm?Cdl<30aLG5`2EUIF00Db<S8M7AdG5aLG5aM5ADD00Pd=3@064A4A=cLgFUYJFUYJ7AdM
Fe]K0TM7A`06ADE530`<EEEEEEEE@D51EeMG0R<S8`05FEUIKVi^;Bd];Bd]Bd];009MGEd01R@T92l_
;emOGemOGclo?bd];@8d=3@01S/k>f5QHCdm?Cdm?BHV9YFEU@:1PH401CDe=B8R8X>3Ph>3PdA4A002
@d=300HY:BTZ:RXW9bLW9bL[:b]SHf<2De=C00I3@d<_;bm/K6a/K6bATI4f=SH2SHf=00Jf][JJVYY2
@T92@T8N7QiYJFT292@T00D/;2`f=SHf=SIkNg]jNWX00XV9R@06A4A4=SHf?Cdm?CdmATI6E5AD0R@T
9006>3PhCdm?D51@D51@@d=3IFEU0TQ8B005<c<c@410@410:b/[<S8b009YJFT01R/[:c0`<38b<S8b
<Rl_;dQ8B093@d<01S@d=55ADEIFEUIFEP`<379bLP93@d<01F1PH492@RXZ:RXZ:Rl_;`02=CDe00H`
<31IFEUVIVIVIVIaLG5fMWH2^[Zj00Ff][Koooooooooool00000;_ooo`040000oooooooofMWI0Vm_
K`05K6a/J6QX;2`/;2`/Ng]k008l?3`01QPH64a<C8F5QHF5QG=cLfm_K`8`<3001UEEEEQHF5mOGemO
GgmoObXZ:P8m?Cd01Di>CT=3@d=3@dM7A`P82002D51@00=;Bd/k>c/D51@00Q@D5004A4A430`<30`<
4a<C0SPh>006HF5Q5aLGE5ADE5ADA4A4?3`l0PT92@06EeMGCdm?Fe]KFe]K;Rh^EeMG0WinOP05820P
CTi>CTi>De=C820P008];Bd01V9RHT51@C4a<C4a<CPh>4E5A@9LG5`01Bd];CTi>HF5QHF5QGMgM`02
Bd];00Hf=SJ=SHe3@d=3@d<f=SHc<c<28B4Q0R/[:`9SHf<01EYJFSPh>3Ph>28R8Ve]K@02OGem00I=
CDegMgO6a/K6a/J_[jm=CDd2;2`/00EYJFTQ8B4S8b<S8b<f=SH00W=cL`06QXJ6SXj>=CDe=CDe9BDU
@T920T10@005E5AD;Bd]:b/[:b/[ATI60099BDT01T];Bfe]KE5ADE5ADD10@492@P8M7Ad01T51@G5a
LB4Q8B4Q8CLg=bLW9`8`<3001DA4A4E5ADE5ACHf=Tm?C`02G5aL00H820QXJ6QDE5ADE5A@D51BDU82
8B4Q00D/;2`a<C4X:2PX:2QKFe/00VUYJ@05LW9bKfm_a<C4a<C4/;2`00?oool00`000?ooooooo`0=
oooo000Roooo00<0003oooooool00_ooo`9]KFd01SPh>8:2PUIFEUIFEQlO7b@T908i>CT01Fe]KC/k
>c/k>b4Q8EEEE@02Kfm_00IDE5A5ADE:BTY:BTX:2PYfMWH2Rh^;00IUIFE[Jf]?Cdm?Cdlb<S9iNGT2
<30`00DR8R8S8b=3@d=3@d=JFUX00PX:2P0692@T;bl_6ATI6ATI;Rh^Hf=S0UMGE`06>3PhBTY:6ATI
6ATI?ShnCTi>0T10@005Lg=c8b<SCDe=CDe=GemO009KFe/01TU9BB`/;0`<30`<35mOGgemO@:>SXh0
1R4Q8C8b<W1`L71`L1lO7fIVIP9IFET01FMWIf][JgIfMWIfMS@d=002B4Q800HS8b<V9RI9BDU9BDT:
2PZ?Shl2=CDe00IBDU9kNg]0@410@41IFEU6ATH2Jf][00JMWId`<311@D51@D58B4Q>CTh26a/K00DG
5aL?3`l?3`lf=SImOGd00YfMW@066QXJ;Bd]4Q8B4Q8BC4a<QXJ60R<S8`06EEEE:2PXVYZJVYZJ=cLg
<C4a0R/[:`05K6a/E5ADE5AD9bLWT92@009MGEd2>3Ph0S`l?006;bl_9BDU9RHV9RHV?3`l61PH0UaL
G006<c<cE5ADP820P820Ogmo5aLG0T];B`05?cloRXZ:RXZ:LG5a=3@d0099BDT01C0`<2LW9gMgMgMg
Mdi>CP03oooo00<0003oooooool0;?ooo`040000oooooooooooo0VUYJ@05@d=3T92@EEEEEEEE7AdM
008P82001Rl_;ginORh^;Rh^;RDU9EaLG09XJ6P01UADE4E5ADI6ATI6APL71g=cL`:?Shl01EmOGg=c
Lg=cLdQ8B3Lg=`02MWIf00Hc<c<V9RHR8R8R8R95ADEMGEd220P800DX:2PZ:RXZ:RXF5QH[:b/00Va/
K006EeMG@d=3@410@4107AdM>3Ph0U9BDP05A4A4KVi^7alO7alOD51@009PH6001UEEEClo?c@d=3@d
=0X:2W5aL@:0P8001WUiN@`<320P820P86EUIBh^;P9QHF401F9RHV1PH61PH75aLGalO002:b/[00Hl
?3`Q8B4N7QhN7QiLG5`P8202S8b<00DX:2QHF5QHF5QjNWY2@T800U1@D006BTY:I6ATXZ:RXZ:R?Shn
?clo0UIFEP05@T925aLG5ADE5ADE6ATI0093@d<01W]kNifMWAdM7AdM7B/[:`l?3`9EEED01GmoObLW
9dA4A4A4A3Ti>@02UIFE00I6ATHi>CTX:2PX:2Q_KfmFEUH28B4Q00JJVYYGEeM7AdM7AdLX:2Q0@402
8b<S00DV9RHL71`L71a:BTXT92@00V5QH@06:b/[C4a<P820P820Ph>31PH60UmOG`05>c/kMGEeNGUi
NGUi?clo0093@d<01Bl_;adM7Fm_Kfm_Ke9BDP03oooo00<0003oooooool03Oooo`005oooo`800004
oooo00<0003oooooool00_ooo`050000oooooooooooono_k008_;bl01UeMGI2@T3<c<c<c<gUiNCPh
>09RHV801B0P84E5ADE5AC@d=6][J`02@41000HP821>CThO7alO7am=CDdN7Qh28b<S00J<S8aGEeLE
5ADE5AEgMgM=CDd2IVIV00DE5ADD51B0P820P813@d<00SHf=P06;Bd]O7alKfm_Kfm_@410SHf=0U9B
DP06=cLgBd];@T92@T92H61P7QhN0R4Q8@05=SHf9BDUQhN7QhN7Kfm_008Z:RX01TY:BQhN7S/k>c/k
>d10@1<C4`8F5QH01WMgMaLG5fi^KVi^KR@T90/;2`8c<c<01GIfMZb/[34a<C4a<C<c<`02A4A400I7
AdLb<S:9RHV9RHTK6a/E5AD2@T9200H:2PXR8R9TI6ATI6AgMgMNGUh261PH00HI6AU6ATH];Bd];BdP
820N7Qh2Bd];00EBDU9gMgMgMgMZJVXP82000Q/K6`06@D51@d=3B4Q8B4Q8=cLgHf=S0S8b<P067alO
Ph>3P820P820N7QhA4A40W9bLP05K6a/AdM7AdM7ATI6GemO0098B4P01VUYJChn?RHV9RHV9S`l?2<S
8`95ADD01Ve]KEaLG1DE5ADE5ALG5chn?P8G5aL01EeMGG1`L3/k>c/k>cPh>002BTY:00I4A4BNWYhc
<c<c<c<^;Ri4A4@3MWIf0oooo`030000oooooooo027oool200001?ooo`030000oooooooo00;oool0
10000?ooooooooooo`8W9bL01FATI8f=SBPX:2PX:7emO@02;Rh^00I[Jf/N7Qi9BDU9BDTi>CUUIFD2
B4Q800HE5AE3@d<^;Rh^;RiFEUHA4A424a<C00F8R8QOGemOGelW9bMjNWX00Shn?P06M7Ad820P7alO
7alOPH61Bd];0SHf=P05<c<cMWIfMWIfN7Qh>CTi00:LW9`01TM7Ad51@C/k>c/k>dm?Cd];B`8d=3@0
1A/K6cXj>Q0@410@47IfMP02KFe]00Hf=SIDE5@G5aLG5aM3@d=5ADD28R8R00H;2`]QHF4/;2`/;2aE
EEDo?cl25aLG00E5ADF3Ph>3Ph>[Zj/T92@00TA4A006AdM7DU9B>SXj>SXjUIFE5aLG0RHV9P05?Shn
4A4A4A4A=cLgLg=c009WIfL016i^KRDU9AlO7alO7`8i>CT2;2`/00DH61QDE5A?Cdm?CdmaLG400WIf
MP066QXJ820P?Cdm?CdmBTY:@T920S@d=005J6QX;2`/:b/[:b/[Shn?009lO7`01WmoOcdm?FYZJVYZ
JWAdM4m?C`91@D401UmOGdE5AFi^KVi^KSlo?alO7`8`<3001A8B4Rl_;bl_;f][Jfm_K`02:2PX00HD
51@^;RhF5QHF5QIVIVIbLW82?clo00D^;Ri@D50i>CTi>CVXZ:P00Sdm?@056ATI>SXjKfm_Kfm_GEeM
00?oool00`000?ooooooo`0=oooo000Goooo00<0003oool000000_ooo`030000oooo000000?oool0
1@000?oooooooooooo_kn`02;bl_00IMGEf@T90c<c<c<c=iNGTh>3P2HV9R00DP8215ADE5ADDd=3A[
Jf/00T10@006820PCTi>7alO7alOCDe=7QhN0R<S8`06S8b<EeMG5ADE5ADEMgMgCDe=0VIVIP055ADE
51@DP820P820@d=3008f=SH01Rd];GalO6m_Kfm_Kd10@8f=S@9BDU801SLg=d];Bd92@T92@V1PH1hN
7P8Q8B401CHf=RDU9HN7QhN7Qfm_K`02:RXZ00I:BTXN7Qhk>c/k>c]0@40C4a<25QHF00IgMgLG5aM^
KVi^KVhT92@;2`/2<c<c00EfMWJ/[:`a<C4a<C4c<c<00TA4A006AdM7<S8bRHV9RHV96a/K5ADE0T92
@P062PX:8R8RI6ATI6ATMgMgGUiN0QPH60066ATIATI6;Bd];Bd]820P7QhN0T];B`05DU9BMgMgMgMg
JVYZ820P008K6a/01T51@D=3@dQ8B4Q8B3Lg=f=SH`8b<S801QlO7h>3Ph20P820P7QhN4A4A09bLW80
1Fa/K4M7AdM7AdI6AUmOG`02B4Q800IYJFTn?ShV9RHV9RHl?3`S8b<2ADE500I]KFeLG5`E5ADE5ADG
5aLn?Sh25aLG00EMGEe`L70k>c/k>c/h>3P00TY:BP06A4A4WYjN<c<c<c<c;Rh^A4A40gIfMP?oool0
0`000?ooooooo`0Qoooo00<0003oool000000_ooo`030000oooo000000?oool010000?oooooooooo
o`8W9bL01FATI8f=SBPX:2PX:7emO@02;Rh^00I[Jf/N7Qi9BDU9BDTi>CUUIFD2B4Q800HE5AE3@d<^
;Rh^;RiFEUHA4A424a<C00F8R8QOGemOGelW9bMjNWX00Shn?P06M7Ad820P7alO7alOPH61Bd];0SHf
=P05<c<cMWIfMWIfN7Qh>CTi00:LW9`01TM7Ad51@C/k>c/k>dm?Cd];B`8d=3@01A/K6cXj>Q0@410@
47IfMP02KFe]00Hf=SIDE5@G5aLG5aM3@d=5ADD28R8R00H;2`]QHF4/;2`/;2aEEEDo?cl25aLG00E5
ADF3Ph>3Ph>[Zj/T92@00TA4A006AdM7DU9B>SXj>SXjUIFE5aLG0RHV9P05?Shn4A4A4A4A=cLgLg=c
009WIfL016i^KRDU9AlO7alO7`8i>CT2;2`/00DH61QDE5A?Cdm?CdmaLG400WIfMP066QXJ820P?Cdm
?CdmBTY:@T920S@d=005J6QX;2`/:b/[:b/[Shn?009lO7`01WmoOcdm?FYZJVYZJWAdM4m?C`91@D40
1UmOGdE5AFi^KVi^KSlo?alO7`8`<3001A8B4Rl_;bl_;f][Jfm_K`02:2PX00HD51@^;RhF5QHF5QIV
IVIbLW82?clo00D^;Ri@D50i>CTi>CVXZ:P00Sdm?@056ATI>SXjKfm_Kfm_GEeM00?oool00`000?oo
ooooo`0=oooo000Goooo00<0003oool000000_ooo`030000oooo000000?oool200000_ooo`05jn_[
GemOGemO^;Rh=SHf008C4a<01F1PH1hN7U5ADE5ADDQ8B002CDe=00HH61QRHV9<C4a<C4aEEED=3@d2
8B4Q00IgMgMRHV96ATI6ATH?3`m8B4P271`L00HK6a]iNGT92@T92@U8B4PI6AT2EUIF00Di>CUCDe=C
De=HF5QVIVH00Xf=S@064Q8BF5QH8B4Q8B4QFEUI=cLg0WQhN006<30`Ng]k7QhN7QhNADE5<c<c0YjN
WP05@4109bLW9bLW1@D5:2PX008e=CD01U1@D3/k>bDU9BDU9ALG5bd];@9FEUH01PD51D];B`T92@T9
2ATI6G]kN`9HF5P01Fa/K492@T92@SXj>STi>@028R8R00H[:b/L71`D51@D51A1@D5ADE42JVYZ00JE
UIDe=CDP820P821fMWI0@4025aLG00De=CDE5ADL71`L71a`L7000S4a<@067AdM=CDeG5aLG5aLE5AD
@4100Q<C4`065aLGNWYj9RHV9RHVFEUIN7Qh0TY:BP05:2PXK6a/<30`<30`G5aL008Y:BT0130`<5aL
G4M7AdM7A`90@402Cdm?00Hi>CTY:BUBDU9BDU9XJ6QHF5P2ATI600HV9RJ9RHV5QHF5QHE0@41YJFT2
IFEU00D^;Rj[Zj^[Zj/F5QIVIVH00Pl?3`05@T929BDUL71`L71`EUIF00;oool200008oooo`030000
oooo000000;oool00`000?ooo`000003oooo0P000006ooooeMGEAdM7AdM7d=3@9bLW0S<c<`05Cdm?
3Ph>3Ph>KFe]CTi>009UIFD01R4Q8FIVIU5ADE5ADDi>CPh>3P8F5QH01HF5QEUIFEADE5ADE0T92@02
GUiN00HW9bL^;RiTI6ATI6@E5AE9BDT25aLG0TI6AP9<C4`01EeMGFIVIVIVIY6AT@h>3P02GemO00HK
6a]=CDe5ADE5ADEcLg<m?Cd2Kfm_00D/;2a7AdM3@d=3@d>ATI400Ta<C006<c<c2`/;8R8R8R8R?3`l
C4a<0SXj>P069bLW5ADE;Rh^;Rh^DE5A1@D50TU9B@053`l?9RHV9RHVOgmoCDe=009kNg/01SHf=T51
@Chn?Shn?QLG5b4Q8@8M7Ad01ATI6Clo?clo?dm?Cfm_K`02Shn?00Ho?clP821UIFEUIFEBDU8P8202
@d=30R<S8`9]KFd01B`/;1LG5aLG5cPh>5eMG@02D51@00I7AdL92@T:2PX:2PYjNWXT92@2KVi^00F0
P80d=3@d=3@a<C5HF5P00S4a<@06Jf][=cLg<C4a<C4aDe=CA4A40TY:BP05@T92?clo9bLW9bLW6a/K
0095ADD01WQhN6YZJUIFEUIFES`l?75aL@:PX:001UYJFU5ADEEEEEEEEBHV9[Fe]@8V9RH01EIFEQ@D
51@D54m?CbPX:002PX:200=<C4coooooool00P0000ooool001Ooool200000oooo`030000oooo0000
00?oool01@000?ooooooooooodA4A002^;Rh00J2PX8a<C59BDU9BDUCDe<@4102Bd];00E4A4A<C4a<
C4aWIfMCDe<00UEEE@06=SHfDU9B:b/[:b/[ATI6LG5a0Ve]K@06?Cdm6QXJC4a<C4a<?CdmNGUi0T];
B`05>3Ph>c/kM7AdM7Ad4A4A008m?Cd01VUYJAXJ6Q@D51@D53`l?1/K6`8j>SX01RLW9h61PCHf=SHf
=UADE9FEU@91@D401EUIFB4Q8CHf=SHf=SPh>0025aLG00Hc<c<_;blc<c<c<c=bLW820P82ATI600H:
2PYEEEE7AdM7AdLE5ADC4a<28b<S00E0@40b<S9>CTi>CTh_;bl00Ta<C006<30`7alOC4a<C4a<CDe=
JVYZ0SLg=`067alO<30`7AdM7AdMMGEe:b/[0Te=C@06>c/k?clo>3Ph>3Ph@D511`L70QPH6005IVIV
B4Q8B4Q89RHV;Bd]00:TY:@01Ve]KDi>CQXJ6QXJ6Te=CEaLG09FEUH01Rl_;bTY:HV9RHV9RDI6AS`l
?08c<c<01H^;Rd=3@d=3@cTi>FQXJ002JVYZ00I[Jf/j>SX?3`l?3`mFEUHT92@2=CDe00HS8b<Y:BTb
<S8b<S8[:b]nOWh2V9RH00E4A4@Z:RY6ATI6ATHb<S800Y>CT`064a<C=3@dBd];Bd];<30`<S8b0X20
P0058B4Qoooooooooooo000002?oool200000oooo`030000oooo000000?oool010000?oooooooeIF
EP:i^KT01I:BTTE5AF9RHV9RHS<c<`025ADE00HX:2QADE4T92@T92BATI5gMgL2EUIF00HH61Q0@40N
7QhN7Qi7AdMbLW82MGEe00Dg=cLT92@T92AQHF4W9bL00UeMG@06?3`l820P9bLW9bLWPX:29bLW0TQ8
B005OGem3`l?3`l?2PX:=SHf008G5aL01S/k>bHV9WinOWinOSXj>UIFEP:ATI401DM7AeUIFB`/;2`/
;2/[:`02?3`l00H:2PXT92@i>CTi>CTV9RIeMGD23`l?00Hg=cLA4A5IFEUIFEU=CDdP82027QhN00DJ
6QY6ATI6ATH/;2a?Cdl00RXZ:P06DU9B9bLW7alO7alOE5ADFEUI0WUiN@059RHV<c<c<c<c8R8R6a/K
009lO7`01Q`L74Y:BS@d=3@d=4I6AShn?P92@T801@L71a`L76a/K6a/K4=3@`02;bl_00HX:2RZZZYU
IFEUIFEGEeLT92@2ADE500E?CdmOGelo?clo?clh>3P00W]kN`06>c/k=3@d;bl_;bl_Ti>CBDU90S4a
<@06M7AdFUYJOGemOGem:BTY3Ph>0T92@P052PX:;Bd];Bd];2`/=SHf0094A4@01Slo?fa/K:b/[:b/
[5aLG1<C4`93@d<01BHV9Xn?Sb`/;2`/;2XZ:P02Kfm_00DR8R97AdM/K6a/K6`V9RH00oooo`030000
oooooooo00goool001Ooool00`000?ooooooo`02oooo00<0003oool000000oooo`050000oooooooo
oooo^k^k009UIFD01UQHF5IFERl_;bl_;a<C4dm?C`::RXX01E9BDW5aLG5aLEQHF65QH@0271`L00IQ
HF5MGEdJ6QXJ6QXN7Qh51@D2;Rh^00HV9RIMGEd;2`/;2`]<C4`[:b/2ZJVY00EOGemnOWhc<c<c<c=<
C4`00S8b<P064a<C@410MgMgMgMgLW9b;2`/0Q4A4@06:b/[R8R8:RXZ:RXZIFEU51@D0W=cL`05GEeM
VYZJ<c<c<c<cPH61008C4a<01T92@RTY:GEeMGEeMDi>CPl?3`9BDU801SPh>30`<2XZ:RXZ:TA4A4a<
C08g=cL01BXZ:S<c<chn?Shn?UMGE`02SHf=00H_;blM7Ad`<30`<31GEeL=3@d2@41000Hj>SY1@D5R
HV9RHV9@D51;Bd/2?Shn00Ho?cmDE5@T92@T92@a<C51@D42;Rh^00DK6a]8B4Q8B4PR8R8Y:BT00UEE
E@068R8R9BDU<30`<30`HV9R820P0R<S8`062PX:IVIVZZZZZZZZ61PH<C4a0TA4A005F5QH7alO7alO
7QhNGemO008L71`01Q4A4A0@42HV9RHV9S4a<B@T908Y:BT01Vi^KQhN7Shn?Shn?T];BeeMG@9]KFd0
1C`l?2`/;5eMGEeMGFm_K`02D51@00IBDU9GEeLm?Cdm?Cd];Be[Jf/2DU9B00FIVIWoooooooooool0
00008oooo`030000oooooooo00;oool00`000?ooo`000003oooo00@0003ooooooona/K42NWYj00E:
BTY<C4`X:2PX:2P820P00Te=C@06NGUiEUIFFEUIFEUINWYjPh>30S/k>`06@410?Shn2@T92@T992@T
5aLG0T10@005:BTYDe=CDe=C5ADEFEUI008L71`01YJFUV][Jg5aLG5aLC@d=6=SH`9<C4`01AdM7B/[
:b/[:gIfMVYZJP02?Cdm00H820PL71aoOgmoOgld=3AJFUX27AdM00EZJVYUIFFJVYZJVYXc<c<00XV9
R@064A4A=cLg=SHf=SHfIfMWATI60R0P8006?clo8b<SA4A4A4A46QXJCTi>0UADE005:RXZ<S8b<S8b
=CDeADE5009JFUX01Y:BTRPX:1lO7alO7cXj>V=SH`8P82001Cdm?DU9BDU9BB/[:g]kN`02ADE500II
FET^;Ri5ADE5ADEEEEDV9RH2;bl_00E6ATHf=SHA4A4A4A55ADD00Rd];@068b<SG5aL:b/[:b/[<c<c
>SXj0UADE0056QXJ8R8R30`<30`<IVIV00:XZ:P01QPH634a<DY:BTY:BTa<C1XJ6P8R8R801U5ADBXZ
:Q8B4Q8B4Q`L72h^;P8S8b<01BXZ:R@T92@T95iNGRd];@02@D5100Hn?SiXJ6QTI6ATI6@b<S8V9RH2
GemO00ETI6AIFETj>SXj>SYaLG400UADE005@d=3H61P=cLg=cLgPH6100?oool00`000?ooooooo`0=
oooo000Hoooo0P0000?oool00`000?ooooooo`02oooo00D0003ooooooooooonk^k/00VEUI@06F5QH
EUIF;bl_;bl_4a<CCdm?0XZ:RP05DU9BLG5aLG5aF5QHHF5Q008L71`01V5QHEeMGAXJ6QXJ6QhN7PD5
1@8^;Rh01RHV9UeMG@/;2`/;2da<C2/[:`:YZJT01EmOGginOS<c<c<c<da<C002<S8b00HC4a=0@41g
MgMgMgMbLW8/;2`24A4A00H[:b^8R8PZ:RXZ:RYUIFDD51@2Lg=c00EMGEfJVYXc<c<c<c>1PH400Q<C
4`06@T92:BTYMGEeMGEeCTi>3`l?0U9BDP06>3Ph<30`:RXZ:RXZA4A4C4a<0SLg=`05:RXZ<c<c?Shn
?ShnEeMG00:=SHd01Rl_;adM7C0`<30`<5MGE`d=3@90@4001SXj>T51@F9RHV9RHU1@D4];B`8n?Sh0
1Slo?eADE2@T92@T934a<D51@@8^;Rh01A/K6dQ8B4Q8B28R8RTY:@02EEEE00HR8R8U9BD`<30`<31R
HV8P82028b<S00H:2PYVIVJZZZZZZZXH61Pa<C42A4A400EHF5PO7alO7alN7QiOGel00Q`L70064A4A
410@9RHV9RHV<C4a92@T0RTY:@06KVi^7QhN?Shn?ShnBd];GEeM0Ve]K@05?3`l;2`/GEeMGEeMKfm_
009@D5001U9BDUMGEcdm?Cdm?Bd];F][J`9BDU801IVIVOooooooooooo`00000Toooo0P0000?oool0
0`000?ooooooo`02oooo00@0003ooooooona/K42NWYj00E:BTY<C4`X:2PX:2P820P00Te=C@06NGUi
EUIFFEUIFEUINWYjPh>30S/k>`06@410?Shn2@T92@T992@T5aLG0T10@005:BTYDe=CDe=C5ADEFEUI
008L71`01YJFUV][Jg5aLG5aLC@d=6=SH`9<C4`01AdM7B/[:b/[:gIfMVYZJP02?Cdm00H820PL71ao
OgmoOgld=3AJFUX27AdM00EZJVYUIFFJVYZJVYXc<c<00XV9R@064A4A=cLg=SHf=SHfIfMWATI60R0P
8006?clo8b<SA4A4A4A46QXJCTi>0UADE005:RXZ<S8b<S8b=CDeADE5009JFUX01Y:BTRPX:1lO7alO
7cXj>V=SH`8P82001Cdm?DU9BDU9BB/[:g]kN`02ADE500IIFET^;Ri5ADE5ADEEEEDV9RH2;bl_00E6
ATHf=SHA4A4A4A55ADD00Rd];@068b<SG5aL:b/[:b/[<c<c>SXj0UADE0056QXJ8R8R30`<30`<IVIV
00:XZ:P01QPH634a<DY:BTY:BTa<C1XJ6P8R8R801U5ADBXZ:Q8B4Q8B4Q`L72h^;P8S8b<01BXZ:R@T
92@T95iNGRd];@02@D5100Hn?SiXJ6QTI6ATI6@b<S8V9RH2GemO00ETI6AIFETj>SXj>SYaLG400UAD
E005@d=3H61P=cLg=cLgPH6100?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooom?
Cdl00X20P006=CDeUIFE@410@41071`L>CTi0W=cL`05Cdm?7AdM7AdMMgMgDU9B0091@D401R@T969R
HTU9BDU9BA<C4c@d=09TI6@01WUiNCDe=G9bLW9bLR@T95MGE`9eMGD01D];Bh>3PhB4Q8B4Q3`l?002
<30`00HK6a]/K6bBTY:BTY8m?CdV9RH220P800IDE5AaLG5YJFUYJFUOGele=CD2<C4a00D92@U_KflT
92@T92@m?Cd00QPH6006D51@6a/KVIVIVIVI61PH6ATI0Rh^;P068B4Q>CTiM7AdM7Ad=SHfMGEe0Ta<
C0058b<S4a<C=CDe=CDe@d=300:@T9001Rd];@P823dm?Cdm?CLg=eYJFP9LG5`01RDU9IbLW5IFEUIF
EUeMGCHf=P892@T01QXJ6QhN7RTY:BTY:@H61YjNWP94A4@01AHF5Rh^;Rh^;R8R8UIFEP02:BTY00H]
;BdA4A4N7QhN7Qhh>3PU9BD2ATI600HU9BE?Cdm7AdM7AdL];Bd[:b/2;Bd]00DH61PQ8B4Q8B4Z:RYo
Ogl00QXJ6P0620P8EEEE4A4A4A4AIVIV7alO0RXZ:P06DU9BV9RHM7AdM7Ad6QXJ<S8b0SLg=`059BDU
@D51GUiNGUiNG5aL008P82001WEeMH>3PfUYJFUYJC@d=1hN7P:?Shl01FATI?ooooooooooo`00000^
oooo00@0003ooooooom2@T82MgMg00E?CdmiNGTc<c<c<c<I6AT00UUIF@06M7Ad>c/k4Q8B4Q8BQXJ6
JVYZ0T51@@06?3`lB4Q8<30`<30`1PH671`L0VYZJP05OgmoADE5ADE5HV9R>c/k009ADE401V][JdQ8
B79bLW9bLY6ATB8R8P99BDT01B/[:eYJFUYJFWinOSXj>P029BDU00H92@U<C4ahN7QhN7Q]KFeIFET2
:b/[00DV9RHB4Q9SHf=SHf<c<c<00Ti>CP066ATIBDU94Q8B4Q8BXZ:R3@d=0QlO7`06:b/[6ATI@T92
@T92KVi^>c/k0WMgM`05ADE5:BTY:BTY4Q8B;Bd]009<C4`01XV9RC4a<@l?3`l?3d=3@cTi>@9QHF40
1E1@D2l_;bl_;hj>SVEUI@02HF5Q00I5ADD@410V9RHV9RHJ6QXQ8B420P8200FQXJ52@T8D51@D51@c
<c<00Rd];@06B4Q8;Bd]92@T92@T4Q8B<C4a0RPX:00551@DEEEE;2`/;2`/E5AD009:BTX01R`/;3@d
=3<c<c<c<b0P81XJ6P8n?Sh01V][Jc<c<a/K6a/K6dI6AR<S8`9QHF401BDU9BXZ:RXZ:Te=CJ>SX`02
JFUY00H@410e=CDH61PH61P820Pd=3@2DE5A00EgMgLn?Si[Jf][Jf^>SXh00UIFEP05:b/[8B4QOWin
OWinE5AD00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooon6QXH00U]KF`065aLG
6ATI=3@d=3@d>c/k3Ph>0SXj>P05GUiN]kNg]kNg?3`l5ADE009EEED01UeMGBTY:De=CDe=CEmOGhJ6
QP9TI6@01S4a<CPh>18B4Q8B4S4a<CPh>08];Bd01@P825]KFbXZ:RXZ:R0P80027alO00ICDe<b<S:?
Shn?Shm3@d<C4a<2Bd];00H92@TR8R9^KVi^KVi2@T93@d<27QhN00DM7AeADE4Y:BTY:BT>3Ph00R/[
:`06EEEEFEUIIfMWIfMWC4a<EeMG0T=3@`06@410BTY:KVi^KVi^8b<SBd];0VYZJP05;2`/F5QHEeMG
EeMGADE5008i>CT01SXj>TM7AdA4A4A4A3Xj>S8b<P8D51@01Ph>3U5ADE5ADE5ADGAdM492@P8R8R80
1T];BalO7fa/K6a/K4U9BD92@P8k>c/01Bl_;gmoOgmoOcPh>2h^;P025QHF00=;Bd/m?CdR8R800R8R
8P05GemOCTi>CTi>L71`4a<C008P82001B/[:aPH63dm?Cdm?A`L70024Q8B00HO7alV9RHE5ADE5ADX
:2QADE427QhN00Hb<S8k>c]9BDU9BDUBDU9YJFT3?Cdm00E1@D59BDU9BDT/;2aADE400PL71`05=SHf
92@T92@T?CdmMGEe009/K6`01IFEUG]kNdE5ADE5AIFEU@03oooo00<0003oooooool0;?ooo`040000
ooooooooUiNG0Te=C@05;Bd]8b<S8B4Q8B4Q<30`008W9bL01Rd];DE5AJBTY:BTY5mOGcPh>08d=3@0
1WIfMPX:2S`l?3`l?5QHF8N7Q`9MGEd01D10@30`<30`<14A4CLg=`02:b/[00HL71`>3Pi9BDU9BDTm
?Cd^;Rh26ATI00EVIVHW9bLW9bMoOgm2@T800Q0@4006D51@3Ph>8R8R8R8RJf][>SXj0S/k>`059RHV
9bLWCdm?Cdm?:b/[008B4Q801R`/;59BDUQHF5QHF71`L4I6AP9XJ6P01Shn?Rl_;eMGEeMGEeYJFRLW
9`8e=CD01FQXJ2<S8b<S8fEUIEQHF002A4A400I5ADD^;Ri3@d=3@d=CDe=8B4P2<S8b00DT92@R8R8R
8R9CDe<m?Cd00V1PH006<c<c2`/;B4Q8B4Q89BDUGemO0UaLG005CDe=>3Ph:RXZ:RXZOWin008j>SX0
1S<c<aDE5DM7AdM7Ad];BbDU9@8O7al01E1@D5iNGWalO7alO10@4002:RXZ00HS8b<K6a/m?Cdm?CdK
6a/L71`2;Bd]00HL71`E5ADV9RHV9RIPH60E5AD2820P00E9BDU4A4A4A4AJFUYRHV800T51@@06>c/k
<c<c=cLg=cLg<S8bBd];0R0P8005Bd];8B4QAdM7AdM7MGEe009XJ6P01GemOG9bLS0`<30`<7emO@03
oooo00<0003oooooool03Oooo`008_ooo`050000ooooooooooooQXJ6009KFe/01QLG5aTI6C@d=3@d
=3/k>`h>3P8j>SX01EiNG[Ng]kNg]c`l?1DE5@02EEEE00IMGEdY:BU=CDe=CDeOGen6QXH2I6AT00Ha
<C4h>3PB4Q8B4Q8a<C4h>3P2;Bd]00D820QKFe/Z:RXZ:RXP82000QlO7`06De=C<S8bShn?Shn?@d=3
4a<C0T];B`062@T98R8RKVi^KVi^@T92@d=30QhN7P057AdMDE5A:BTY:BTY3Ph>008[:b/01UEEEEUI
FFMWIfMWIda<C5MGE`93@d<01T10@4Y:BVi^KVi^KR<S8d];B`9ZJVX01B`/;5QHF5MGEeMGEdE5A@02
>CTi00Hj>SY7AdM4A4A4A4@j>SXb<S8251@D00H>3PiADE5ADE5ADE5dM7A2@T828R8R00I;Bd/O7am/
K6a/K6a9BDU2@T82>c/k00D_;bmoOgmoOglh>3P^;Rh00QHF5P03Bd];?Cdm8R8R008R8R801EmOGdi>
CTi>CW1`L1<C4`02820P00D[:b/H61Pm?Cdm?CdL71`00Q8B4P067alO9RHV5ADE5ADE:2PXDE5A0QhN
7P06<S8b>c/kBDU9BDU9DU9BJFUY0cdm?@05@D51BDU9BDU9;2`/DE5A00871`L01CHf=R@T92@T93dm
?GEeM@02K6a/00FEUIEkNg]5ADE5ADFEUID00oooo`030000oooooooo02coool010000?oooooooiNG
U`9=CDd01Bd];B<S8b4Q8B4Q8C0`<0029bLW00H];Be5ADFTY:BTY:AOGelh>3P2=3@d00IfMWH:2PXl
?3`l?3aHF5R7QhL2GEeM00E0@40`<30`<30A4A4g=cL00R/[:`0671`L3Ph>BDU9BDU9?Cdm;Rh^0QTI
6@05IVIV9bLW9bLWOgmo@T92008@41001U1@D0h>3R8R8R8R8V][JcXj>P8k>c/01BHV9RLW9dm?Cdm?
Cb/[:`024Q8B00H/;2aBDU9HF5QHF5Q`L716ATH2J6QX00Hn?Sh_;bmGEeMGEeMJFUXW9bL2=CDe00EX
J6PS8b<S8b=UIFEHF5P00TA4A006ADE5;Rh^@d=3@d=3De=CB4Q80S8b<P0592@T8R8R8R8RDe=C?Cdm
009PH6001S<c<`/;2dQ8B4Q8B2DU9EmOG`9LG5`01De=CCPh>2XZ:RXZ:WinOP02>SXj00Hc<c<E5AE7
AdM7AdM;Bd/U9BD27alO00E@D51NGUilO7alO7`@41000RXZ:P068b<S6a/K?Cdm?Cdm6a/K71`L0Rd]
;@0671`L5ADE9RHV9RHVH61P5ADE0R0P8005BDU9A4A4A4A4FUYJHV9R0091@D401S/k>c<c<cLg=cLg
=c8b<T];B`8P82001D];Bb4Q8DM7AdM7AgEeM@02J6QX00EmOGebLW8`<30`<31mOGd00oooo`030000
oooooooo00goool002;oool200000_ooo`0530`<IVIVIVIVT92@?Shn008/;2`01Di>CR@T93De=CDe
=E5AD@02Ti>C00HI6AUJFUY1@D51@D5JFUY<C4`2Lg=c00J9RHTb<S9TI6ATI6A8B4QWIfL2BTY:00IH
F5PK6a/N7QhN7Qh^;Rh[:b/2@d=300Do?cl/;2`/;2`l?3a8B4P00SXj>P066ATI5ADEO7alO7alCdm?
?clo0RTY:@06GUiN<30`Fe]KFe]K>3PhEeMG0R@T90059RHV>3Ph>3Ph3@d=5ADE009MGEd01Rh^;Vi^
KWmoOgmoOa/K6gIfMP:9RHT01Pd=3CPh>7=cLg=cLd=3@`d=3@96ATH01EQHF3<c<c<c<`820S<c<`02
F5QH00I6ATH=3@e3@d=3@d=cLg<h>3P23@d=00J9RHUfMWHK6a/K6a]oOgm^KVh2;Rh^00EMGEdE5AD=
3@d=3@dh>3P00RHV9P0692@TEeMG>3Ph>3PhFe]K<30`0UiNGP06:BTY?cloCdm?Cdm?O7al5ADE0QTI
6@05>SXjB4Q8?3`l?3`l;2`/008o?cl01T=3@b/[:bh^;Rh^;QhN7Q/K6`9HF5P01TY:BVMWIdQ8B4Q8
B6ATI38b<P:9RHT01W=cLda<C5YJFUYJFT51@EYJFP8I6AT01I>CTe5ADE5ADCDe=B@T9002CTi>00D/
;2`n?Sj@T92@T91VIVH00_ooo`80000^oooo0P000006oooo61PHJ6QXJ6QXRHV97QhN0Q4A4@05>c/k
:BTY:BTY9bLWCTi>00:0P8001R/[:eIFES4a<C4a<E=CDe5AD@9NGUh01InOWb4Q8F1PH61PH5YJFP02
Fe]K00I9BDULG5`G5aLG5aLW9bLU9BD27alO00E?Cdlc<c<e=CDe=CE6ATH00T92@P06>3Ph61PH5QHF
5QHFMgMgC4a<0TQ8B006=3@dDU9B8b<S8b<SJVYZ?Shn0Ti>CP0551@D<30`<30`?clo5aLG008W9bL0
1Tm?CcHf=VYZJVYZJV][Jb4Q8@9WIfL01G5aLB/[:a`L71`L78R8R0029RHV00H@411NGUiMGEeMGEdX
:2PM7Ad2:2PX00EMGEeNGUh@410@410V9RH00XR8R00671`L:b/[LG5aLG5aIfMW8B4Q0V][J`06JVYZ
=SHfCdm?Cdm?9bLW5aLG0Slo?`05<30`51@D51@DCTi>?Shn009ZJVX01R<S8e9BDS@d=3@d=4Q8B4a<
C09gMgL01AHF5QPH61PH63Ph>492@P02ATI600He=CDc<c=?Cdm?CdlO7alU9BD29bLW00DG5aMLG5a9
BDU9BDUKFe/00UYJFP06H61P8B4QWinOWinOGUiNDE5A0U=CD`06<C4aEUIF:b/[:b/[P820CTi>0RLW
9`05:BTY>c/k>c/k4A4A7QhN00:9RHT00fQXJ?ooooooo`0200003oooo`008_ooo`050000oooooooo
ooooQXJ600:EUID01TE5AG]kNiFEUIFEUFa/K7EeM@8m?Cd01B@T93Hf=SHf=PL71e5AD@02;2`/00=9
BDU1@D4m?Cd00Sdm?@05JFUYDU9BDU9BBDU9>c/k008b<S801QhN7U5ADBPX:2PX:1DE5BHV9P8O7al0
1A8B4Q`L71`L73dm?APH6002:b/[00HP820C4a=`L71`L71>CTiOGel38R8R00Dm?Ce;Bd];Bd/F5QH^
;Rh00SPh>005Ogmo;bl_;bl_>c/k@T920099BDT01Va/K1lO7d];Bd];Bb8R8T92@P9dM7@2DE5A0Ph>
3P0551@D<S8b>SXj>SXjA4A40097AdL01SXj>STi>DE5ADE5AEMGEeQHF08/;2`01VYZJT];Bb<S8b<S
8fi^KTY:BP90@4001T=3@eMGEda<C4a<C6MWIeUIF@9EEED01B/[:`h>3Ph>3RTY:E5AD@027AdM00HN
7Qi3@d=2@T92@T9^KVhR8R822@T900I;Bd/C4a=3@d=3@d>?Shlb<S82De=C00DO7alP820P820Z:RYK
Fe/00PP82006;Bd]>3Ph<C4a<C4a4Q8B>3Ph0S4a<@06I6ATQXJ6GemOGemOCDe=:BTY0UeMG@05EEEE
5ADE?3`l?3`l]kNg009NGUh01SXj>Ph>3S/k>c/k>c@d=1TI6@8G5aL01E]KFoooooooooooo`00000^
oooo00@0003ooooooonGUiL2OGem00D`<31bLW9mOGemOGeXJ6P00WEeM@06AdM78B4QBd];Bd];820P
Bd];0S8b<P06=cLg<c<c>c/k>c/k@D51HV9R0UYJFP05A4A4BDU9BDU9820P5ADE009PH6001RHV9QDE
5A`L71`L72d];A`L708K6a/01Cdm?A/K6a/K6b<S8bXZ:P02410@00IlO7aNGUi@D51@D50O7alU9BD2
Bd];00E7AdLE5ADc<c<c<c<j>SX00WinOP06:RXZ>3PhCDe=CDe=G5aLGemO0RDU9@06B4Q82`/;<c<c
<c<cH61P?Cdm0U=CD`058R8R92@T92@T<S8bB4Q8009CDe<01T=3@bh^;TE5ADE5ADA4A5QHF09UIFD0
1B<S8fQXJ6QXJ3De=BLW9`02FUYJ00IGEeL_;bln?Shn?SiXJ6Q6ATH2L71`00EHF5QBDU8/;2`/;2`B
4Q800R/[:`06Cdm?9bLW9RHV9RHV>c/k>SXj0V][J`058R8R3Ph>D51@D51@410@0092@T801WmoObLW
9fIVIVIVIQTI6Bh^;P8m?Cd01TU9B@h>3Q`L71`L72/[:cLg=`8A4A401C0`<410@410@5eMGHN7Q`02
F5QH00Hl?3`:2PYfMWIfMWHd=3@h>3P2GemO00FTY:A5ADD];Bd];BdW9bL00S0`<0058B4Q8b<S;Bd]
;Bd]CDe=00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooom?Cdl00VATI006Shn?
7QhN=3@d=3@dJFUYPh>30WEeM@05820PG5aLG5aLGUiN@D51008U9BD01SLg=c8b<QXJ6QXJ6WAdM9RH
V09BDU801RXZ:QlO7fIVIVIVIQ4A4EEEE@8820P01AXJ6WmoObXZ:RXZ:R4Q8@0261PH00H];Bd[:b/]
;Bd];Be7AdM?Cdl29BDU00I6ATHU9BDh>3Ph>3PN7QhA4A42;Bd]00DY:BUFEUHR8R8R8R8^;Rh00QHF
5P06A4A4WYjN1PH61PH6:BTY7QhN0QXJ6P062@T9=SHfGEeMGEeMEUIFW9bL0RDU9@05G5aLFUYJ=cLg
=cLg?Cdm008820P01Rd];I2@T4=3@d=3@cDe=A<C4`8S8b<01Ta<C7EeMCHf=SHf=WAdM3Ti>@8Q8B40
1Rh^;QTI6APH61PH69VIVA/K6`9@D5001APH63dm?Cdm?B@T96m_K`022@T900Ha<C4e=CEOGemOGemY
JFUaLG42E5AD00H820PV9RHm?Cdm?CfBTY9/K6`26a/K00D`<30l?3`l?3b4Q8B3Ph<00T];B`06MGEe
EeMG92@T92@TLW9b=CDe0WUiN@06I6AT=3@d4a<C4a<CBDU9HV9R0R@T9005@D51DU9BMgMgMgMg7AdM
009?Cdl01W=cLcTi>A`L71`L7410@9FEU@8e=CD01H20P?ooooooooooo`00000^oooo00@0003ooooo
oom2@T82E5AD00EnOWhQ8B4[:b/[:b]FEUH00Xj>SP06Jf][?ShnMgMgMgMgDE5A=3@d0PP8200661PH
=CDe410@410@JFUYXj>S0Te=C@05:RXZ9BDU9BDUHF5Q8b<S0096ATH01Q/K6c<c<f][Jf][Jchn?QXJ
6P8P82001C<c<c@d=3@d=2`/;4Y:BP02E5AD00H/;2aEEEDD51@D51@X:2Pa<C424Q8B00DT92@];Be8
B4Q8B4P];Bd00S<c<`0651@D@T92XJ6QXJ6Q0P828B4Q0QXJ6P069RHV410@ADE5ADE5HF5QIFEU0Xj>
SP05;bl_D51@D51@HF5Q>CTi0093@d<01Pl?3c4a<HV9RHV9RDa<C2d];@8B4Q801BTY:DE5ADE5AGMg
Mc/k>`02KVi^00I2@T8I6AT[:b/[:b/O7al=3@d2XZ:R00DB4Q99BDTI6ATI6AU>CTh00S<c<`06Hf=S
4Q8B9RHV9RHV:b/[FEUI0Ve]K@05N7QhC4a<2@T92@T99BDU008j>SX01WinOUYJFR/[:b/[:dU9BB8R
8P:ATI401W9bLTQ8B6][Jf][Je5ADC/k>`9RHV801DE5AGmoOgmoOfYZJQ`L70021PH600H`<318B4Pl
?3`l?3a1@D5ZJVX2QXJ600DB4Q8k>c]dM7AdM7AIFET00QTI6@05<c<cNGUiCdm?Cdm?MgMg00?oool0
0`000?ooooooo`0=oooo000Roooo00D0003ooooooooooom?Cdl00VATI006Shn?7QhN=3@d=3@dJFUY
Ph>30WEeM@05820PG5aLG5aLGUiN@D51008U9BD01SLg=c8b<QXJ6QXJ6WAdM9RHV09BDU801RXZ:QlO
7fIVIVIVIQ4A4EEEE@8820P01AXJ6WmoObXZ:RXZ:R4Q8@0261PH00H];Bd[:b/];Bd];Be7AdM?Cdl2
9BDU00I6ATHU9BDh>3Ph>3PN7QhA4A42;Bd]00DY:BUFEUHR8R8R8R8^;Rh00QHF5P06A4A4WYjN1PH6
1PH6:BTY7QhN0QXJ6P062@T9=SHfGEeMGEeMEUIFW9bL0RDU9@05G5aLFUYJ=cLg=cLg?Cdm008820P0
1Rd];I2@T4=3@d=3@cDe=A<C4`8S8b<01Ta<C7EeMCHf=SHf=WAdM3Ti>@8Q8B401Rh^;QTI6APH61PH
69VIVA/K6`9@D5001APH63dm?Cdm?B@T96m_K`022@T900Ha<C4e=CEOGemOGemYJFUaLG42E5AD00H8
20PV9RHm?Cdm?CfBTY9/K6`26a/K00D`<30l?3`l?3b4Q8B3Ph<00T];B`06MGEeEeMG92@T92@TLW9b
=CDe0WUiN@06I6AT=3@d4a<C4a<CBDU9HV9R0R@T9005@D51DU9BMgMgMgMg7AdM009?Cdl01W=cLcTi
>A`L71`L7410@9FEU@8e=CD01H20P?ooooooooooo`00000^oooo00@0003ooooooom2@T82E5AD00En
OWhQ8B4[:b/[:b]FEUH00Xj>SP06Jf][?ShnMgMgMgMgDE5A=3@d0PP8200661PH=CDe410@410@JFUY
Xj>S0Te=C@05:RXZ9BDU9BDUHF5Q8b<S0096ATH01Q/K6c<c<f][Jf][Jchn?QXJ6P8P82001C<c<c@d
=3@d=2`/;4Y:BP02E5AD00H/;2aEEEDD51@D51@X:2Pa<C424Q8B00DT92@];Be8B4Q8B4P];Bd00S<c
<`0651@D@T92XJ6QXJ6Q0P828B4Q0QXJ6P069RHV410@ADE5ADE5HF5QIFEU0Xj>SP05;bl_D51@D51@
HF5Q>CTi0093@d<01Pl?3c4a<HV9RHV9RDa<C2d];@8B4Q801BTY:DE5ADE5AGMgMc/k>`02KVi^00I2
@T8I6AT[:b/[:b/O7al=3@d2XZ:R00DB4Q99BDTI6ATI6AU>CTh00S<c<`06Hf=S4Q8B9RHV9RHV:b/[
FEUI0Ve]K@05N7QhC4a<2@T92@T99BDU008j>SX01WinOUYJFR/[:b/[:dU9BB8R8P:ATI401W9bLTQ8
B6][Jf][Je5ADC/k>`9RHV801DE5AGmoOgmoOfYZJQ`L70021PH600H`<318B4Pl?3`l?3a1@D5ZJVX2
QXJ600DB4Q8k>c]dM7AdM7AIFET00QTI6@05<c<cNGUiCdm?Cdm?MgMg00?oool00`000?ooooooo`0=
oooo000Roooo00D0003ooooooooooonk^k/00YVIV@06DU9BJf][;Bd];Bd]?CdmEeMG0U9BDP05D51@
Kfm_Kfm_GEeM;2`/008l?3`01Ve]KEeMGD];Bd];Bchn?QhN7P9^KVh01RTY:B@T934a<C4a<BHV9Q0@
408A4A401A`L75mOGahN7QhN7QlO7`02F5QH00I4A4@a<C4H61PH61RZZZYVIVH22PX:00HS8b<P821R
HV9RHV8`<30U9BD28R8R00EEEEDY:BTR8R8R8R98B4P00Q/K6`06;Rh^@D51<C4a<C4a92@TE5AD0Slo
?`06?ShnBd];D51@D51@HV9R@D510SXj>P05@4103@d=EeMGEeMG<30`008M7Ad01Rl_;hf=SEMGEeMG
Echn?S<c<`8Z:RX01SLg=da<C4A4A4A4A2XZ:S0`<08h>3P01U9BDPl?3di>CTi>CWEeMBTY:@92@T80
1A<C4h61PH61PC<c<iZJVP02GEeM00IcLg<D51AUIFEUIFDZ:RZ8R8P2:b/[00HA4A4/;2abLW9bLW9g
MgM0@4024a<C00Db<S9<C4a<C4`c<c=nOWh00UmOG`06ZJVY:b/[C4a<C4a<2`/;GEeM0RHV9P06;Rh^
1@D57QhN7QhN6QXJGEeM0V5QH@0571`LHF5QF5QHF5QHLG5a009BDU801XZ:RTm?Ca<C4a<C4bl_;eIF
EP9HF5P01FEUIOooooooooooo`00000^oooo00@0003ooooooona/K42PH6100Dg=cMPH613@d=3@d=D
E5@00W5aL@06>SXjFEUII6ATI6ATGemO9RHV0S8b<P06I6ATJ6QX?Shn?Shn@D51;Bd]0UiNGP0592@T
:RXZ:RXZ8b<S;Rh^008L71`01Q8B4RXZ:U5ADE5ADB8R8QXJ6P9<C4`01DY:BS4a<C4a<APH6:RXZ002
IVIV00H<30`R8R8J6QXJ6QYDE5@j>SX2<c<c00D[:b]LG5`S8b<S8b<];Bd00TE5A@064A4A=SHfATI6
ATI6;bl_9RHV0UEEE@06ADE5;Rh^FEUIFEUIADE5Ng]k0R/[:`05BDU9?Cdm?Cdm820PHf=S008j>SX0
1QlO7bPX:9:BTY:BTUYJFTE5A@8e=CD01C8b<RXZ:RXZ:UADE4i>CP026QXJ00I4A4@S8b<o?clo?clP
8216ATH2IfMW00Df=SHg=cLA4A4A4A69RHT00S<c<`06VYZJIFEUJVYZJVYZ7AdMFUYJ0S@d=005Ogmo
71`L20P820P8?Cdm009ZJVX01WIfMR/[:adM7AdM7Da<C6=SH`8d=3@01W5aLF][JiJFUYJFUQ`L75UI
F@8E5AD01E=CDbTY:BTY:D10@1LG5`0292@T00H92@Tn?Si0@410@40k>c^3Ph<2NWYj00EIFEUFEUIi
NGUiNGU=CDd00PP82005:2PXC4a<BTY:BTY:NWYj00?oool00`000?ooooooo`0=oooo000Roooo00D0
003ooooooooooom4A4@00R4Q8@06P820<S8b<30`<30`Bd];=3@d0Q<C4`05Ti>C<S8b<S8bATI6:RXZ
0094A4@01YRHV7inOR/[:b/[:c8b<RTY:@8S8b<01SDe=B@T95IFEUIFEPl?3cXj>P9[Jf/01FYZJVQX
J3Ti>CTi>D=3@`02Rh^;00Hc<c<l?3a6ATI6ATJ9RHTY:BT2;bl_00IFEUILG5a=CDe=CDdJ6QY>CTh2
KFe]00FTY:@];BdV9RHV9RI8B4P00VIVIP0661PH1`L7@D51@D51>3Ph?clo0S/k>`06CDe=:b/[MGEe
MGEe7AdM<30`0QlO7`05=cLgJVYZCDe=CDe=C4a<008O7al01S0`<4a<C2l_;bl_;di>CS8b<P90@400
1R<S8a<C4aDE5ADE5DM7AeEEE@8:2PX01TI6AP820W9bLW9bLS<c<bl_;`8c<c<01ALG5cPh>3Ph>3Hf
=R4Q8@02FEUI00I1@D6EUIEDE5ADE5@f=SJ1PH429bLW00Hj>SXK6a/l?3`l?3`D51@J6QX2JFUY00Dm
?CdA4A4A4A5dM7@k>c/00SPh>006Bd];NGUi?Cdm?CdmC4a<6QXJ0Sdm?@06KFe]LG5aATI6ATI6:b/[
DU9B0SHf=P05EEEEDe=CIfMWIfMWC4a<0094A4@01T];Ba0@45=CDe=CDdU9BC4a<@:2PX801KRh^?oo
ooooooooo`00000^oooo00@0003ooooooomFEUH29RHV00E/K6a7AdLR8R8R8R9_Kfl00RXZ:P06;2`/
Shn?9RHV9RHV@d=34a<C0UaLG006[:b/K6a/?clo?cloA4A4=SHf0R`/;005;Bd]2PX:2PX:@T923Ph>
008Y:BT01WemOEYJFWAdM7AdM34a<DU9B@:CTi<01Bl_;c@d=3@d=3/k>g]kN`02>3Ph00Ho?cmOGem?
Cdm?Cdm5ADDT92@2EeMG00EUIFFZZZXX:2PX:2P_;bl00T=3@`06K6a/71`L1`L71`L7@T92?Shn0TI6
AP06=3@dBTY:71`L71`LO7al6a/K0R8R8P05<c<c9RHV9RHVNGUiFEUI009DE5@01QlO7bLW9e9BDU9B
DRXZ:Tm?C`8/;2`01DI6AQXJ6QXJ6QhN7R0P8002CDe=00IIFETA4A4g=cLg=cL?3`meMGD29RHV00Di
>CTT92@:2PX:2PXl?3`00R/[:`06;2`/FEUIAdM7AdM7TI6AEUIF0SXj>P05OWin9RHV>c/k>c/k5aLG
008f=SH01PX:2Pl?3gemOGemODQ8B2LW9`:2PX801RLW9b0P83`l?3`l?5eMGBLW9`9QHF401B@T93Lg
=cLg=gEeMG9bLP02AdM700HN7Qi0@40H61PH61QFEUIgMgL2TI6A00DT92AADE4X:2PX:2PE5AD00S<c
<`05HV9RADE5TY:BTY:B^KVi00?oool00`000?ooooooo`0=oooo000Roooo0P0000;oool01N_[jeIF
EUIFEW1`L2DU9@02@T9200D?3`mVIVHF5QHF5QJ[Zj/00Rh^;P06IFEUJFUY@410@410QHF5RHV90RHV
9P06ATI6F5QHJ6QXJ6QXDU9B:BTY0STi>@06Cdm?@410@410@410AdM7G5aL0S0`<005:BTYG5aLG5aL
<30`K6a/008X:2P01TY:BWQhN5UIFEUIFBHV9WYjNP8G5aL01Q<C4d10@5ADE5ADE5aLG3De=@8M7Ad0
1C4a<G1`L71`L1`L71DE5@02=CDe00HG5aM0@41fMWIfMWHP820e=CD2UIFE00IZJVYADE51@D51@D4D
51@L71`2:b/[00DR8R8i>CTi>CTj>SY2@T800Va/K006F5QHNg]k6ATI6ATI2@T9Bd];0PD51@06EUIF
;Bd]5aLG5aLG9BDU>c/k0U1@D005=CDe:2PX1@D51@D59bLW0090@4001YjNWS<c<dE5ADE5AAhN7W]k
N`8`<3001WQhN3Lg=eUIFEUIFB4Q8EQHF08B4Q801Hf=SFIVIUQHF5QHF5=CD`02>CTi00IFEUHI6AU8
B4Q8B4P92@UiNGT26a/K00HL71a8B4P?3`l?3`m6ATIRHV82MgMg00HQ8B4=3@eEEEEEEEE<C4aRHV82
61PH00E=CDe8B4Q8B4QADE4N7Qh00V1PH0054a<C=SHf^;Rh^;RhGemO00;oool20000;_ooo`800000
1_ooomGEeDa<C4a<C8:2PRPX:09?Cdl01A@D55IFEUIFERHV9[Fe]@029RHV00IEEEEADE5JFUYJFUZP
X:1aLG42?3`l00EFEUIZJVYhN7QhN7Q5ADD00Q/K6`069bLW?clo@T92@T92BTY:A4A40U=CD`05<C4a
=cLgJf][Jf][<C4a009HF5P01S4a<C@d=820P820P6i^KR@T909jNWX01PX:2PT92DM7AdM7Ae1@D5eM
G@8h>3P011LG5b`/;2`/;6e]K@<S8b<01T=3@b0P859BDU9BDVEUIB0P808o?cl01Hn?Sfm_Kdm?Cdm?
Cclo?`026ATI00HM7AdQ8B4G5aLG5aLn?Si1@D42=SHf00EkNg]=CDeoOgmoOglV9RH00Pl?3`06BDU9
1@D5DE5ADE5A;Rh^5ADE0RLW9`06>SXjC4a<?3`l?3`l8R8R2`/;0S<c<`05C4a<TI6ATI6A@d=3AdM7
008/;2`01Vm_Kcdm?G=cLg=cLdE5ADe=C@8K6a/01EmOG`h>3Ph>3Y6ATFIVIP02GEeM00I<C4a6ATI6
ATI6ATHG5aM9BDT25ADE00ETI6@^;RhW9bLW9bMNGUh00PT92@06E5ADFEUIQHF5QHF55QHF3Ph>0Ti>
CP06DE5AIVIV8B4Q8B4QIFEUCTi>0Ve]K@053Ph>Cdm?Cdm?<c<c9bLW00;@d=000dM7Aoooooooo`02
00003oooo`008_ooo`050000oooooooooooojn_[009FEUH01W1`L2DU9D92@T92@Pl?3fIVIP8F5QH0
1J^[Zbh^;Rh^;VEUIFUYJ@02@41000J5QHF9RHTV9RHV9RI6ATIHF5P2J6QX00EBDU8Y:BTi>CTi>CU?
Cdl00d10@005AdM7G5aL<30`<30`:BTY009LG5`01S0`<6a/K2PX:2PX:4Y:BWQhN09IFET01RHV9WYj
NQLG5aLG5a<C4d10@09DE5@01EaLG3De=AdM7AdM7C4a<@02L71`00HL71`E5ADe=CDe=CDG5aM0@402
MWIf00HP820e=CFEUIFEUIEZJVYADE42@D5100DD51@L71`[:b/[:b/R8R800STi>@06>SXj@T92K6a/
K6a/F5QHNg]k0QTI6@062@T9Bd];1@D51@D5EUIF;Bd]0QLG5`069BDU>c/kD51@D51@=CDe:2PX0PD5
1@059bLW@410@410WYjN<c<c0095ADD01QhN7W]kNc0`<30`<7QhN3Lg=`9IFET01R4Q8EQHF18B4Q8B
4Xf=SFIVIP9HF5P01E=CDcTi>CTi>EIFEQTI6@02B4Q800H92@UiNGTK6a/K6a/L71a8B4P23`l?00I6
ATIRHV9gMgMgMgLQ8B4=3@d2EEEE00E<C4aRHV8H61PH61Q=CDd00TQ8B006DE5A7QhNH61PH61P4a<C
=SHf0[Rh^005GemOoooooooooooo000002koool010000?ooooooomGEe@9<C4`01H:2PRPX:4m?Cdm?
Ca@D5002EUIF00HV9RJe]KDV9RHV9RIEEEEADE42FUYJ00JPX:1aLG4l?3`l?3aFEUIZJVX2N7Qh00E5
ADDK6a/K6a/W9bLo?cl00T92@P06BTY:A4A4De=CDe=C<C4a=cLg0V][J`05<C4aF5QHF5QH<C4a=3@d
00:0P8001Vi^KR@T97YjNWYjNPX:2PT92@97AdL01E1@D5eMGCPh>3Ph>1LG5`02;2`/00I]KFdS8b<S
8b<S8b=3@d<P8202DU9B00IUIFDP820o?clo?cn?Shm_Kfl2Cdm?00Do?clI6ATI6ATM7AdQ8B400QLG
5`06?Shn@D51=SHf=SHfNg]kCDe=0WmoO`059RHV3`l?3`l?BDU91@D5009ADE401Rh^;QDE5BLW9bLW
9cXj>Ta<C08l?3`01B8R8P/;2c<c<c<c<da<C002TI6A00I3@d=7AdL/;2`/;2a_Kflm?Cd2Lg=c00E5
ADE=CDdK6a/K6a]OGel00Ph>3P05TI6AIVIVGEeMGEeMC4a<00=6ATH01QLG5dU9BADE5ADE5FATI2h^
;P8W9bL01EiNGPT92@T92EADE5UIF@02QHF500HF5QH>3Pi>CTi>CTiADE5VIVH28B4Q00EUIFE>CTi]
KFe]KFd>3Ph00Tm?C`05<c<c9bLWd=3@d=3@AdM700?oool00`000?ooooooo`0=oooo000Roooo00D0
003ooooooooooookno/00gIfMP05A4A4;Rh^;Rh^<c<cWYjN0094A4@01DY:BSPh>3Ph>3/k>g1`L002
GEeM00HG5aLn?ShG5aLG5aLE5AELG5`2KFe]00I5ADDS8b<l?3`l?3`V9RHn?Sh2JFUY00E8B4QOGem6
ATI6ATI7AdL00Va/K006LW9bA4A4N7QhN7QhP820Ph>30QlO7`06<S8bHf=S=cLg=cLgB4Q8@d=30T51
@@056a/K820PJVYZJVYZMgMg009BDU801T];BahN7R0P820P82d];DI6AP8I6AT01QPH65iNGWMgMgMg
MfATI28R8P8:2PX01D92@QDE5A/K6a/K6hV9R@02<S8b00I7AdM4A4@c<c<c<c<a<C6/[:`2MWIf00Hc
<c<;2`/T92@T92A^KVhG5aL2MgMg00HF5QHC4a=0@410@40k>c/N7Qh2BTY:00DZ:RY_Kfm_Kfn7QhLU
9BD00SHf=P068B4Q7QhNH61PH61P@T92Bd];0SLg=`06DU9BSHf=@410@410Kfm_O7al0Rd];@05=SHf
@d=3@d=3P82051@D008E5AD01VIVITe=CGMgMgMgMaDE5EMGE`:<S8`01R<S8ahN7Te=CDe=CAlO7di>
CP8P82001D10@6][Jc@d=3@d=4E5A@02820P00IRHV8h>3QiNGUiNGTc<c>@T902GEeM00D_;boooooo
ooooool00000;_ooo`040000oooooooooooo0UeMG@05Kfm_>SXj6ATI6ATI?Cdm00:XZ:P01STi>E1@
D2h^;Rh^;Slo?g9bLP9VIVH01QHF5Rh^;Q@D51@D52PX:6m_K`9[Jf/01Bl_;a8B4Q8B4S0`<1lO7`02
?clo00I^KVi5ADEOGemOGem1@D5?Cdl2M7Ad00EZJVXm?Cdm?CeoOgmlO7`00Xn?S`06:b/[;2`/J6QX
J6QX=3@d@T920TY:BP05?Cdm820P6QXJ6QXJMWIf009aLG401Dm?CeADE1PH61PH62`/;003>CTi00HO
7alU9BE^KVi^KViWIfMcLg<2=cLg00DA4A4n?Shn?ShV9RHG5aL00YFEU@06>SXjDU9BAdM7AdM7A4A4
92@T0Z^[Z`05Ph>3ADE5ADE55aLG?clo009EEED01R`/;65QH@/;2`/;2b8R8TE5A@93@d<01ALG5eAD
E3Hf=SHf=Ve]K@02MWIf00H@410j>SXK6a/K6a/d=3A;Bd/2Cdm?00Dk>c]1@D57AdM7AdNLW9`00STi
>@06N7QhMWIf<c<c<c<c=SHfBd];0X61P@067alO820PM7AdM7Ad?ShnNWYj0RLW9`05GemOR8R8R8R8
4a<C4A4A009FEUH01Rh^;T=3@aDE5ADE5DQ8B6EUI@8i>CT01DU9BAhN7V][Jf][Jbh^;P02OGem00DX
:2R=SHeTI6ATI6@W9bL00oooo`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0Ti>
CP06MgMg9bLW<30`<30`BDU9=3@d0W5aL@05RXZ:?clo?cloBd];5aLG009oOgl01X20P5ADE3<c<c<c
<eaLG1PH608l?3`01BHV9RDU9Bl_;bl_;c`l?003>3Ph00EMGEf@T90W9bLW9bMDE5@00Va/K006:b/[
<C4a=cLg=cLgVYZJ:2PX0UEEE@068b<SQXJ6C4a<C4a<4Q8B;Bd]0QXJ6P05WIfMOGem=SHf=SHf3`l?
008G5aL01Q/K6di>CTQ8B4Q8B451@C0`<0:MWId01V][JdI6AUUIFEUIFD10@7]kN`9BDU801CDe=Hn?
S`X:2PX:2TU9B@029RHV00HS8b=8B4Pd=3@d=3AfMWI[Jf/2IfMW00IIFEUVIVHO7alO7am`L70b<S82
8B4Q00J>SXimOGeOGemOGel<30`/;2`2BDU900EKFe]OGemOGem=CDdS8b<00W=cL`06@410CTi>?Shn
?Shn6ATIBTY:0SPh>006EeMGHf=S;Rh^;Rh^6ATI;bl_0R@T90052PX:FUYJFUYJ@d=38b<S008R8R80
1S0`<7UiNC8b<S8b<Tm?Cf][J`9UIFD01X^;RgIfMPX:2PX:2TY:BTE5A@9DE5@01Fm_KeEEEB4Q8B4Q
8C/k>`02KFe]00Hi>CTT92@O7alO7amFEUJ2PX82>3Ph00E]KFgoooooooooool00000;_ooo`040000
oooooooooooo0U9BDP05Kfm_7AdM;bl_;bl_@d=3008o?cl01WUiNGEeMC/k>c/k>emOG`H61P:3Ph<0
1X20P4a<C2/[:b/[:f5QHB@T909:BTX01A`L72HV9RHV9R<S8d10@002:2PX00I7AdMGEeNJVYZJVYXQ
8B5FEUH2Kfm_00DX:2Pi>CTi>CU6ATJEUID00STi>@06A4A49bLWOgmoOgmoEEEE3`l?0R/[:`057AdM
WIfMNg]kNg]k@d=3008I6AT01QDE5ALG5d92@T92@UIFESlo?`8n?Sh01Z:RXVATI4Y:BTY:BU1@D492
@P9jNWX01EQHF2PX:2PX:8b<S20P8002G5aL00HN7QhQ8B4l?3`l?3`[:b]lO7`2LG5a00EPH61RHV9R
HV9QHF4^;Rh00VEUI@06820P30`<NGUiNGUiP820LG5a0PX:2P05=3@d?cloEEEEEEEEH61P009@D500
1QlO7fi^KTA4A4A4A59BDSPh>08M7Ad01D10@4=3@eMGEeMGEfa/K002:b/[00HF5QHZ:RXX:2PX:2P8
20QMGEd2ADE500HR8R8V9RHc<c<c<c=fMWHg=cL2B4Q800EcLg=OGemOGen?ShmcLg<00PL71`06ATI6
ADE5E5ADE5ADJ6QXG5aL0RDU9@05;Rh^OWin;bl_;bl_820P008M7Ad01EEEEI2@T4=3@d=3@fUYJ@03
oooo00<0003oooooool03Oooo`008_ooo`050000ooooooooooooeMGE00:f][H01[Zj^WIfMW5aLG5a
LFIVIUUIF@8`<3001CDe=Bl_;bl_;bXZ:T92@P02H61P00I3@d=bLW8<30`<30aFEUIADE42=3@d00I3
@d=8B4P_;bl_;blb<S8`<302:b/[00EYJFTb<S8[:b/[:b]0@4000S<c<`06B4Q8IFEU@d=3@d=3D51@
Cdm?0SPh>00692@TE5ADATI6ATI6?Cdm=SHf0TA4A005RHV9NWYjNg]kNg]k=SHf008/;2`01R@T96UY
JAhN7QhN7T92@YZJVP:f][H01Xf=SCHf=Y6ATI6ATFa/K2l_;`93@d<01E=CDf=SHb/[:b/[:bLW9`02
:RXZ00HY:BU3@d=4A4A4A4B3Ph<R8R82=CDe00J1PH6EUIDV9RHV9RHm?CeQHF42>c/k00Hd=3@];Bdo
?clo?cmOGel_;bl292@T00EMGEe;Bd];Bd/];Be^KVh00UUIF@068b<SEeMG@D51@D51EEEE30`<0TE5
A@06AdM7Fe]K7AdM7AdMFUYJ=cLg0Q4A4@053@d=ADE5ADE55aLG7AdM008b<S801UIFEUaLG0`<30`<
34m?CcXj>P8o?cl01S/k>cPh>7IfMWIfMVUYJE9BDP9IFET01BXZ:Ve]KG9bLW9bLX:2PP02ATI600HF
5QHn?SioOgmoOglc<c=LG5`2IFEU00EoOgooooooooooool00000;_ooo`040000oooooooofMWI0[2`
/005a<C4Kfm_LW9bLW9bJFUY009KFe/01RPX:34a<B`/;2`/;24Q8E9BDP9@D5001UADE6QXJ0P820P8
25aLG4m?C`8f=SH01DE5ADA4A4A4A30`<2LW9`02=cLg00HQ8B5aLG51@D51@D4M7Ae2@T82@41000EA
DE5]KFe]KFe;Bd]9BDT00TI6AP06:b/[;Bd]E5ADE5AD@410@T920RDU9@05=CDeSXj>QXJ6QXJ6Lg=c
008f=SH01R<S8b4Q8FUYJFUYJB`/;4e=C@:_[jl01/K6aWMgMde=CDe=CGemOFe]K@8R8R8013Ph>5YJ
FUYJFV=SH`<[:b/01R4Q8C<c<cHf=SHf=T=3@hf=S@8f=SH01D];BgMgMgMgMhF5QCTi>@02;Bd]00IL
G5a5ADDh>3Ph>3Pa<C51@D42HV9R00D];BdP821CDe=CDe=>CTh00R0P8006OWinEeMG;Rh^;Rh^Fe]K
Cdm?0UMGE`052@T9?3`lA4A4A4A4E5AD008G5aL01V5QHCPh>1<C4a<C4``<34A4A0<D51@01C/k>d];
Bd];Be1@D0P82002AdM700E3@d=>CTi>CThm?CdZ:RX00WmoO`06GemOF5QHEEEEEEEE<30`Kfm_0W=c
L`05QHF5C4a<61PH61PH?3`l009kNg/01B`/;6QXJ6a/K6a/K6m_K`03oooo00<0003oooooool03Ooo
o`008_ooo`050000ooooooooooooeMGE00:f][H01[Zj^WIfMW5aLG5aLFIVIUUIF@8`<3001CDe=Bl_
;bl_;bXZ:T92@P02H61P00I3@d=bLW8<30`<30aFEUIADE42=3@d00I3@d=8B4P_;bl_;blb<S8`<302
:b/[00EYJFTb<S8[:b/[:b]0@4000S<c<`06B4Q8IFEU@d=3@d=3D51@Cdm?0SPh>00692@TE5ADATI6
ATI6?Cdm=SHf0TA4A005RHV9NWYjNg]kNg]k=SHf008/;2`01R@T96UYJAhN7QhN7T92@YZJVP:f][H0
1Xf=SCHf=Y6ATI6ATFa/K2l_;`93@d<01E=CDf=SHb/[:b/[:bLW9`02:RXZ00HY:BU3@d=4A4A4A4B3
Ph<R8R82=CDe00J1PH6EUIDV9RHV9RHm?CeQHF42>c/k00Hd=3@];Bdo?clo?cmOGel_;bl292@T00EM
GEe;Bd];Bd/];Be^KVh00UUIF@068b<SEeMG@D51@D51EEEE30`<0TE5A@06AdM7Fe]K7AdM7AdMFUYJ
=cLg0Q4A4@053@d=ADE5ADE55aLG7AdM008b<S801UIFEUaLG0`<30`<34m?CcXj>P8o?cl01S/k>cPh
>7IfMWIfMVUYJE9BDP9IFET01BXZ:Ve]KG9bLW9bLX:2PP02ATI600HF5QHn?SioOgmoOglc<c=LG5`2
IFEU00EoOgooooooooooool00000;_ooo`040000oooooooofMWI0[2`/005a<C4Kfm_LW9bLW9bJFUY
009KFe/01RPX:34a<B`/;2`/;24Q8E9BDP9@D5001UADE6QXJ0P820P825aLG4m?C`8f=SH01DE5ADA4
A4A4A30`<2LW9`02=cLg00HQ8B5aLG51@D51@D4M7Ae2@T82@41000EADE5]KFe]KFe;Bd]9BDT00TI6
AP06:b/[;Bd]E5ADE5AD@410@T920RDU9@05=CDeSXj>QXJ6QXJ6Lg=c008f=SH01R<S8b4Q8FUYJFUY
JB`/;4e=C@:_[jl01/K6aWMgMde=CDe=CGemOFe]K@8R8R8013Ph>5YJFUYJFV=SH`<[:b/01R4Q8C<c
<cHf=SHf=T=3@hf=S@8f=SH01D];BgMgMgMgMhF5QCTi>@02;Bd]00ILG5a5ADDh>3Ph>3Pa<C51@D42
HV9R00D];BdP821CDe=CDe=>CTh00R0P8006OWinEeMG;Rh^;Rh^Fe]KCdm?0UMGE`052@T9?3`lA4A4
A4A4E5AD008G5aL01V5QHCPh>1<C4a<C4``<34A4A0<D51@01C/k>d];Bd];Be1@D0P82002AdM700E3
@d=>CTi>CThm?CdZ:RX00WmoO`06GemOF5QHEEEEEEEE<30`Kfm_0W=cL`05QHF5C4a<61PH61PH?3`l
009kNg/01B`/;6QXJ6a/K6a/K6m_K`03oooo00<0003oooooool03Oooo`008_ooo`030000oooooooo
00;oool2NGUi00I>CThG5aLh>3Ph>3R;Rh]dM7@2P82000E=CDeZJVYZJVXF5QH[:b/00V5QH@06=3@d
7QhNIfMWIfMW8B4QCDe=0VUYJ@06CDe=8B4Q=SHf=SHf@410KVi^0T=3@`05;bl_;2`/6QXJ6QXJ2@T9
008S8b<01Sdm?MGEeClo?clo?c4a<E=CD`8[:b/01PL71aTI6BTY:BTY:A<C4gIfMP9FEUH01EYJFT10
@0X:2PX:2XZ:RP028B4Q00H_;bm4A4@n?Shn?SiTI6B][Jd2Ti>C00HU9BDE5AETI6ATI6@D51ATI6@2
3@d=00<U9BDW9bLA4A400Q4A4@9<C4`01TA4A4I6AUADE5ADE3Ti>CXj>P9oOgl01S8b<Q0@44E5ADE5
AAdM7A/K6`8H61P27alO0Q/K6`05AdM7JFUY3@d=3@d=@D510090@4001TI6AUUIFBDU9BDU9F9RHRTY
:@9YJFT01S`l?4a<C3Xj>SXj>Ti>CT92@P9[Jf/01C8b<QdM7AXJ6QXJ6R8R8P02GemO0UeMG@96ATH0
1UMGEb@T91LG5aLG5f=SHdU9B@9gMgL01TA4A5UIFCTi>CTi>C8b<WIfMP9LG5`01EADE7IfMWYjNWYj
NUiNGP02GEeM00I4A4AVIVJ5QHF5QHDo?clK6a/2DE5A00E6ATKoooooooooool00000;_ooo`040000
oooooooooooo0WEeM@05DE5A5QHF>CTi>CTiRXZ:009hN7P01XN7QdA4A6m_Kfm_KaHF5R`/;09JFUX0
1Shn?R4Q8F1PH61PH1`L74i>CP9ZJVX01DU9BATI6ATI6B`/;4];B`02JFUY00Hg=cM4A4@V9RHV9RHD
51@>3Ph2;bl_00E4A4CKfm_Kfm]2@T8];Bd00U=CD`06<C4a3`l?8R8R8R8R820P9bLW0W5aL@05@D51
JVYZ;Bd];Bd]7alO009fMWH01S<c<cPh>55ADE5ADCDe=FQXJ0:_[jl01YVIVAXJ6R@T92@T95EEEBDU
9@9XJ6P01BDU9A/K6a/K6c4a<BXZ:P024a<C00Hj>SYFEUHk>c/k>c]=CDdg=cL2>SXj00EnOWhZ:RXZ
:RXE5ADi>CT00Q4A4@06;bl_7alO8R8R8R8R=SHf8b<S0SHf=P05IVIV7AdM>c/k>c/kB4Q80099BDT0
1UeMGBDU9E]KFe]KFc8b<V1PH09:BTX01EYJFT];BeADE5ADE34a<@02FUYJ00I2@T8];BdK6a/K6a/V
9RIMGEd2Hf=S00IIFEU:BTYEEEEEEEDP820J6QX2FEUI00E=CDf4Q8B4Q8A=CDe>CTh00SDe=@06;bl_
Kfm_EeMGEeMGD51@NWYj0W]kN`05GemOHF5Q@410@410IVIV009mOGd01DM7Aa/K6e=CDe=CDd10@003
oooo00<0003oooooool03Oooo`008_ooo`800002oooo00Fb/[9VIVIVIVIRHV8[:b/00TM7A`05DU9B
=cLg;bl_;bl_>3Ph0092@T801UYJFV9RHUaLG5aLG9>CTb8R8P91@D401Vm_KcXj>RTY:BTY:Clo?c`l
?094A4@01QTI6AlO7`L71`L71e1@D2<S8`8H61P01B8R8S`l?3`l?2/[:i^KV`02Ti>C00Hc<c=WIfM4
A4A4A4@N7Qj:RXX2:BTY00HG5aLn?SiADE5ADE5mOGfLW9`3>CTi0QdM7@06HV9RFEUI;Bd];Bd]4A4A
TI6A0VYZJP066QXJE5ADPh>3Ph>3?Cdm7AdM0S0`<00592@T5QHF:b/[:b/[<C4a008F5QH01QXJ6SXj
>WYjNWYjNWalO5aLG08`<3001TI6AU=CDcXj>SXj>U]KFcPh>09aLG401SHf=T92@U]KFe]KFkno_c4a
<@9?Cdl01B4Q8C8b<S8b<R0P8410@003@d=300DM7AePH61PH61RHV8@41000WQhN006;Bd]@d=3GUiN
GUiN1PH68b<S0RLW9`052@T97AdM7AdM51@D<30`008e=CD01XJ6QVQXJ4M7AdM7AdE5AEaLG09BDU80
1QdM7EaLG6a/K6a/K2PX:1lO7`9eMGD01E9BDTY:B[6a/K6a/E9BDP02=SHf00HI6AUbLW9HF5QHF5PY
:BUoOgl23`l?00=CDe?oooooool00P0002koool2000000Kooonc/k=ZJVYZJVYXJ6Pd=3@2?Shn00EK
Fe/Z:RXZ:RXj>SY3@d<00S<c<`06E5ADJFUYEEEEEEEEVYZJ820P0TI6AP05M7Ad<c<c<c<c<c<c=CDe
008];Bd01TI6AR<S8b0P820P81XJ6Shn?P<S8b<0124Q8C/k>c/k>c<c<`:RXZ801Y2@T34a<Fe]KFe]
KDa<C2XZ:P9lO7`01S@d=0/;2chn?Shn?UADE8f=S@:8R8P01Dm?Cb@T92@T90`<36a/K002CDe=00HX
:2P<30bBTY:BTY9XJ6PA4A42H61P00EeMGEBDU8c<c<c<c<a<C400Q/K6`06:b/[AdM77QhN7QhN5ADE
;bl_0Slo?`05Jf][MGEeGEeMGEeM;2`/0092@T801TY:BSlo?dM7AdM7AdY:BU=CD`8N7Qh01UiNGUAD
E<G5aLG5aDe=CD51@@8D51@01C@d=2HV9RHV9Slo?dY:BP02Bd];00HJ6QYUIFETI6ATI6@M7Af1PH42
:RXZ00De=CE;Bd];Bd/J6QXS8b<00QdM7@064A4A8b<S61PH61PH;2`/>3Ph0Xf=S@05GEeMEeMG<c<c
<c<cBDU9009CDe<01R/[:e1@D7EeMGEeMB@T92<S8`9eMGD01UEEEDA4A:VYZJVYZE5ADCTi>@8O7al0
1FQXJ6ATI6ATI38b<XV9R@0251@D00=>CTkoooooool00P0000ooool002;oool01@000?oooooooooo
omcLg002`<3000JVYZIIFEU?Cdm?CdmTI6AZJVX2=SHf00D_;bn2PX:2PX8_;blI6AT00SLg=`06@D51
<C4a6ATI6ATI6QXJD51@0Rd];@06GEeMEEEELW9bLW9b5QHF820P0Pl?3`05:RXZG5aLGEeMGEeM3Ph>
008R8R801SLg=cPh>7MgMgMgMalO7e9BDP9HF5P01Rd];HR8R0/;2`/;2cPh>4=3@`9=CDd01@X:2U9B
DUUIFEUIFBl_;`02@D5100IIFEUJFUXe=CDe=CEFEUI@D502<C4a00IQHF59BDTj>SXj>SY^KVhX:2P2
>SXj00EHF5PG5aLH61PH61QJFUX00TM7A`069bLW;2`/>SXj>SXjP820B4Q80T=3@`06GEeM7alO<30`
<30`FEUIA4A40TM7A`06:b/[:2PX2`/;2`/;EeMG9RHV0b8R8P8D51@01Q4A4@L71dm?Cdm?CeQHF2<S
8`8D51@01TE5AEaLG4A4A4A4A3`l?3De=@9:BTX01B/[:bd];BLW9bLW9cHf=P02JFUY00Hh>3Pc<c<K
6a/K6a]EEEERHV82AdM700I2@T9aLG4a<C4a<C6UYJEmOGd2;bl_00I2@T9]KFd];Bd];BeWIfM/K6`2
EEEE00D30`<_;bl_;bmaLG4T92@00UiNGP05;Rh^UIFE:BTY:BTY<c<c00?oool00`000?ooooooo`0/
oooo00@0003ooooooooIfMT2clo?00FXZ:Q_KfmYJFUYJFU;Bd/00Vi^KP068R8R=SHfLg=cLg=c?clo
8B4Q0S8b<P06?Shn=SHf6a/K6a/K71`LFUYJ0SDe=@05IVIVBd];Bd];GUiN7alO008];Bd01Q/K6bl_
;e=CDe=CDfMWIaLG5`8M7Ad01CXj>Sdm?Cdm?GMgMb<S8`02EUIF00IMGEdc<c>0P820P80<30`];Bd2
>c/k00EEEEDC4a=DE5ADE5ANGUh00SXj>P06CTi>Cdm?GemOGemO8R8RA4A40U]KF`06<30`LW9b@T92
@T92>SXjMGEe0R/[:`05;Rh^GUiNGUiN8B4Q71`L009XJ6P01Shn?QdM7DY:BTY:BT];Bh61P@8h>3P0
1E5ADG9bLW9bLQTI6C/k>`02J6QX00Hd=3A:BTXE5ADE5ADJ6QXB4Q82Lg=c00Di>CT?3`l_;bl_;blH
61P00R0P80064Q8BA4A4FUYJFUYJ9bLW5QHF0Tm?C`05FEUI<30`<30`<30`BDU9008g=cL01STi>BLW
9c0`<30`<38b<Va/K08f=SH01S`l?10@44Q8B4Q8B5QHF5MGE`8i>CT01F9RHShn?Shn?YbLW7moO`02
<30`00I3@d=VIVHX:2PX:2QUIFEKFe/2?Shn00DI6AU4A4B2PX:2PX8i>CT00UIFEP05>3PhV9RH;2`/
;2`/<c<c00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooooLg=`00/30`006YZJV
FEUICdm?Cdm?I6ATJVYZ0SHf=P05;bl_PX:2PX:2;bl_6ATI008g=cL01T51@C4a<ATI6ATI6AXJ6U1@
D08];Bd01UeMGEEEEG9bLW9bLQHF5R0P808?3`l01BXZ:UaLG5eMGEeMG@h>3P028R8R00Hg=cLh>3Qg
MgMgMgLO7amBDU82F5QH00H];Bf8R8P;2`/;2`/h>3Q3@d<2CDe=00D:2PYBDU9IFEUIFET_;bl00T51
@@06FEUIFUYJ=CDe=CDeEUIFD51@0S4a<@06HF5QBDU9>SXj>SXjKVi^:2PX0SXj>P05F5QH5aLG61PH
61PHFUYJ0097AdL01RLW9b`/;3Xj>SXj>X20P4Q8B093@d<01UeMGAlO7c0`<30`<5UIFDA4A097AdL0
1R/[:bPX:0/;2`/;2eMGEbHV9P<R8R8251@D00HA4A471`M?Cdm?CdmHF5PS8b<251@D00I5ADELG5a4
A4A4A4@l?3`e=CD2BTY:00D[:b/];BdW9bLW9bLf=SH00VUYJ@06>3Ph<c<c6a/K6a/KEEEEHV9R0TM7
A`06@T92LG5a<C4a<C4aYJFUOGem0Rl_;`06@T92KFe];Bd];Bd]IfMWK6a/0UEEE@050`<3;bl_;bl_
LG5a92@T009NGUh01Bh^;YFEUBTY:BTY:C<c<`03oooo00<0003oooooool0;?ooo`040000oooooooo
fMWI0/o?c`05Z:RXKfm_JFUYJFUYBd];009^KVh01R8R8SHf=W=cLg=cLclo?b4Q8@8b<S801Shn?SHf
=Q/K6a/K6a`L75YJFP8e=CD01FIVIT];Bd];BeiNGQlO7`02;Bd]00HK6a/_;bmCDe=CDe=WIfLG5aL2
7AdM00Dj>SXm?Cdm?CegMgLS8b<00UIFEP06GEeM<c<cP820P82030`<;Bd]0S/k>`05EEEE4a<CE5AD
E5ADGUiN008j>SX01Ti>CTm?CemOGemOGb8R8TA4A09KFe/01S0`<79bLT92@T92@SXj>WEeM@8[:b/0
1Bh^;UiNGUiNGR4Q8A`L7002J6QX00Hn?ShM7Ae:BTY:BTY;Bd^1PH42>3Ph00EADE5bLW9bLW8I6ATk
>c/00VQXJ006=3@dBTY:5ADE5ADE6QXJ4Q8B0W=cL`05>CTi3`l?;bl_;bl_61PH008P82001Q8B4TA4
A5YJFUYJFRLW9aHF5P9?Cdl01EUIFC0`<30`<30`<4U9B@02=cLg00Hi>CTW9bL`<30`<30b<S9/K6`2
=SHf00Hl?3`@4118B4Q8B4QHF5QGEeL2>CTi00ERHV8n?Shn?SjLW9aoOgl00S0`<006@d=3IVIV:2PX
:2PXIFEUFe]K0Shn?P056ATIA4A4PX:2PX:2>CTi009FEUH01CPh>9RHV2`/;2`/;3<c<`03oooo00<0
003oooooool03Oooo`008_ooo`050000ooooooooooooemOG009EEED01VQXJ1DE5C4a<C4a<Bl_;h61
P@8/;2`01B/[:l;2`/;2`WUiNBPX:002IVIV00HP820_;bm;Bd];Bd/M7AdC4a<2:2PX00HQ8B5BDU8k
>c/k>c]WIfM/K6`2EeMG00DQ8B4O7amEEEEEEEDF5QH00R/[:`06=SHfEUIF]kNg]kNgHF5QA4A40TU9
B@06I6AT;Rh^Ph>3Ph>392@TJVYZ0U]KF`052PX:5aLGCDe=CDe=7AdM0091@D401Ta<C3Xj>TQ8B4Q8
B3`l?1dM7@8I6AT01WIfMSlo?f9RHV9RHSXj>TY:BP8n?Sh01EMGEfATI2/[:b/[:de=C@02;Bd]00H8
20Q^KViGEeMGEeL<30aGEeL2=3@d00IEEEDG5aLW9bLW9bMkNg/H61P2GUiN00Hf=SIKFe]7AdM7AdLE
5ADG5aL25QHF00E1@D4D51@D51@A4A4E5AD00V][J`06Fe]K7AdM8R8R8R8RJVYZCdm?0TY:BP06?Shn
>CTi?Cdm?Cdm30`<De=C0T=3@`05?3`lO7alO7alShn?820P0090@4001Z:RXRXZ:W=cLg=cLbLW9cLg
=`96ATH00cTi>CXj>S/k>`02>c/k00Dd=3ACDe=CDe<h>3PD51@00WIfMP05@T92BDU9BDU91PH6KFe]
008m?Cd01D10@6m_Kb@T92@T95YJFP03oooo00<0003oooooool0;?ooo`040000oooooooohn?S0VYZ
JP05J6QX5QHFDE5ADE5ABd];009cLg<01S<c<bLW9kVi^KVi^HV9RCXj>P9HF5P01Q/K6cPh>4U9BDU9
BAhN7QDE5@8a<C401B<S8d51@D51@BPX:5IFEP02Ng]k00I8B4Pc<c<Q8B4Q8B5NGUhJ6QX292@T00Db
<S9CDe=CDe>c/k=XJ6P00TE5A@06A4A4Jf][<S8b<S8bOGem8R8R0VUYJ@05HF5Q2PX:6a/K6a/KDe=C
008R8R801TY:BTQ8B492@T92@Slo?bHV9P8H61P01PT92HF5QB<S8b<S8fUYJD];B`8j>SX01E5ADFQX
J6QXJ5QHF2HV9P02CDe=00H[:b/D51AYJFUYJFU:BTXQ8B42@D5100ECDe=[Jf][Jf/F5QI1@D400W=c
L`06<S8bCdm?ADE5ADE5E5ADAdM70QHF5P0571`L5QHF=CDe=CDe6ATI008U9BD01P410Fa/K5=CDe=C
Da<C4ahN7P9WIfL01E=CDd92@TU9BDU9BBl_;`02@41000H@4117AdLi>CTi>CU8B4R1PH42VIVI00HG
5aM5ADFQXJ6QXJ4^;Ri]KFd2:2PX00Dd=3A=CDe=CDdm?Cd^;Rh00TM7A`06>c/k9RHV@d=3@d=3=3@d
5QHF0UiNGP05D51@EeMG7alO7alOQHF5008Z:RX01De=CFEUIBh^;Rh^;Ti>CP03oooo00<0003ooooo
ool03Oooo`008_ooo`050000ooooooooooooHF5Q009ZJVX01Rl_;a<C4eQHF5QHF7UiNChn?P92@T80
1@X:2T10@410@4];BeMGE`02>3Ph00HE5AELG5`Q8B4Q8B6g]kMNGUh25aLG00I1@D5SHf=LG5aLG5`h
>3QJFUX28b<S00E7AdLb<S9HF5QHF5QOGel00Q/K6`06HF5QLW9bHf=SHf=S2PX:8b<S0SDe=@06NGUi
G5aLVIVIVIVI61PHADE50Rl_;`05ADE5EUIF<S8b<S8b9RHV008G5aL01RTY:APH64a<C4a<C2XZ:Sdm
?@8X:2P01UADE0d=3BHV9RHV9V=SHfEUI@8:2PX01E=CDde=CDQ8B4Q8B410@002=SHf00I?Cdm]KFeN
GUiNGUj5QHE1@D42EUIF00IBDU8];BeRHV9RHV9HF5Po?cl2DU9B00HM7Adj>SXc<c<c<c<R8R8@4102
3`l?00Db<S9EEEEEEEE_Kfn0P8000T51@@06AdM7HV9RO7alO7alLg=c4a<C0Xb<S006ATI6Bd];EUIF
EUIF1`L7P8200Sdm?@05:BTY@d=3@d=3TI6A8R8R008U9BD01[>c/aLG5gIfMWIfMSTi>CLg=`8Q8B40
1T51@DI6AVYZJVYZJUmOGb`/;09BDU801Bh^;VEUIGIfMWIfMX^;R`02ADE500HO7amjNWY>CTi>CTi6
ATHi>CT2C4a<00Da<C7oooooooooool00000;_ooo`040000ooooooooHf=S0VMWI`05;Rh^4Q8BF5QH
F5QHNWYj008n?Sh01T10@0`<33`l?3`l?4];BeiNGP8l?3`01Q/K6eADE2HV9RHV9Zj^[VYZJP8?3`l0
1D];Be]KFe]KFfATI3Xj>P02EeMG00HV9RI8B4Pc<c<c<c=MGEeOGel24A4A00EFEUIWIfMWIfMTI6@B
4Q800R8R8P06?ShnRHV9IfMWIfMWSXj>3Ph>0TA4A005=SHfC4a<EEEEEEEE=CDe008T92@01QTI6Bh^
;QDE5ADE5Di>CRLW9`92@T801QhN7U5ADAPH61PH620P85QHF09bLW801@l?3fATI6ATI4E5ADM7A`02
=3@d00HZ:RY6ATIdM7AdM7AKFe^3Ph<2ATI600ECDe=BDU9BDU8g=cM^KVh00TE5A@06D51@B4Q820P8
20P88B4Q61PH0SDe=@054a<C9BDU>c/k>c/kEEEE009dM7@01WinOT=3@da<C4a<C69RHW=cL`9NGUh0
1BHV9WalO69RHV9RHSLg=`02IfMW00HL71aaLG4n?Shn?Shg=cM6ATH2VYZJ00HR8R8X:2Rf][Jf][HH
61R5QHD2:RXZ00E;Bd/a<C4a<C4/;2`b<S800WinOP06D51@<30`CDe=CDe=9BDUJf][0WIfMP05SXj>
@D518b<S8b<SNGUi009FEUH01Da<C3Xj>TU9BDU9BBh^;P03oooo00<0003oooooool03Oooo`006?oo
o`030000oooooooo00;oool00`000?ooooooo`02oooo00D0003ooooooooooolT92@00[Fe]@06A4A4
FUYJGemOGemODE5A4Q8B0Q/K6`059RHVIVIVIVIV6a/KBTY:009QHF401QdM7CLg=g=cLg=cLalO7b8R
8P8V9RH01QDE5D51@@d=3@d=3EIFEVEUI@8a<C401@P823De=C0`<30`<5]KF`029BDU00IbLW8H61PM
7AdM7Ad;2`/Y:BT2GEeM00JMWIfJVYY=CDe=CDeMGEda<C423@d=00E?CdmoOgm;Bd];Bd]5ADD00SDe
=@067alO7AdM:b/[:b/[HF5QJFUY0PP820050`<3?3`lDe=CDe=C9BDU00<L71`01C@d=2h^;SXj>SXj
>Q/K6`02QXJ600I^KViDE5A>CTi>CTi@D51TI6@2MgMg00Hd=3@R8R9ZJVYZJVX820QBDU82Fe]K00I:
BTXe=CD@410@4118B4PG5aL251@D00EEEEDW9bLW9bLZ:RYWIfL00W5aL@06Fe]K3`l?WYjNWYjN?clo
D51@0SXj>P06:BTY8b<S4A4A4A4AMGEe:RXZ0U=CD`05HF5Q5QHF5QHF@D518b<S009?Cdl01T10@5iN
GW9bLW9bLR0P80d=3@9QHF401XF5QH20P492@T92@UMGEeIFEP8E5AD01EeMGLG5aA4A4A4A4GinOP02
Cdm?00Ha<C4e=CE4A4A4A4@T92A1@D42GemO00E;Bd_oooooooooool000009?ooo`030000oooooooo
00;oool00`000?ooooooo`02oooo00@0003oooooool_;bl2^KVi00Db<S9NGUijNWYjNWXd=3@00S<c
<`063`l?@d=3QHF5QHF56QXJ;Rh^0V=SH`061`L7Bd];KVi^KVi^:RXZ;bl_0S`l?005;Rh^BDU9BDU9
8b<SGUiN009VIVH01QhN7QPH63Xj>SXj>RTY:F=SH`8];Bd01FEUIB@T92@T91dM7@H61P026ATI00IT
I6BJVYZ[Zj^[Zj/l?3aKFe/2;2`/00DD51AGEeN1PH61PH5<C4`00TM7A`06>CTi6ATI9BDU9BDU:2PX
GUiN0W9bLP061`L710@4?Cdm?CdmDE5A:b/[0R<S8`05:2PX?clo?clo@410;2`/008B4Q801WMgMeYJ
FVMWIfMWIeMGEeIFEP9VIVH01GalO3Ti>CTi>BHV9WQhN0024a<C00IOGem1@D4^;Rh^;RhI6AT[:b/2
DE5A00DG5aL];BeVIVIVIVHX:2P00RLW9`06J6QXLW9bI6ATI6AT7alORh^;0RPX:005?3`l7QhNATI6
ATI63@d=008820P01WEeMCXj>U=CDe=CDfEUIATI6@94A4@01R/[:dI6AU5ADE5ADDU9BHZ:RP8F5QH0
1@h>3W9bLW9bLWEeMGYjNP02B4Q800IFEUIJFUX;2`/;2`]VIVJb/[82:BTY00E]KFeXJ6Q?Cdm?CdlM
7Ad00R/[:`05<30`>c/kIfMWIfMW@d=300?oool00`000?ooooooo`0=oooo000Goooo00<0003oool0
00000_ooo`030000oooo000000?oool01@000?ooooooooooob@T9002]KFe00I4A4AJFUYOGemOGemA
DE4B4Q826a/K00DV9RIVIVIVIVHK6a]:BTX00V5QH@067AdM=cLgLg=cLg=c7alO8R8R0RHV9P065ADE
@D513@d=3@d=EUIFIFEU0S4a<@0520P8=CDe<30`<30`Fe]K008U9BD01W9bLQPH61dM7AdM7@/;2bTY
:@9MGEd01YfMWIZJVTe=CDe=CEeMGC4a<@8=3@d01Dm?CgmoOd];Bd];BdE5A@02=CDe00HO7alM7Ad[
:b/[:b]QHF5YJFT220P800D30`<l?3aCDe=CDe<U9BD00a`L7005=3@d;Rh^>SXj>SXj6a/K00:6QXH0
1Vi^KUADE4i>CTi>CU1@D6ATI09gMgL01S@d=28R8VYZJVYZJPP8259BDP9KFe/01TY:BSDe=A0@410@
44Q8B1LG5`8D51@01EEEEBLW9bLW9bXZ:VMWI`02LG5a00IKFe/?3`nNWYjNWYho?cm@D502>SXj00HY
:BTS8b<A4A4A4A5eMGDZ:RX2De=C00EQHF4F5QHF5QI1@D4S8b<00Tm?C`06@410GUiNLW9bLW9b820P
3@d=0V5QH@06QHF5P820@T92@T92EeMGEUIF0QDE5@05GEeMaLG54A4A4A4AOWin009?Cdl01S4a<CDe
=DA4A4A4A2@T9451@@9OGel01D];Boooooooooooo`00000Soooo00<0003oool000000_ooo`030000
oooo000000?oool010000?ooooooobl_;`:i^KT01C8b<UiNGWYjNWYjNS@d=002<c<c00H?3`m3@d>5
QHF5QHDJ6QX^;Rh2Hf=S00H71`M;Bd]^KVi^KVhZ:RX_;bl2?3`l00D^;Ri9BDU9BDTS8b=NGUh00VIV
IP067QhN61PH>SXj>SXj:BTYHf=S0Rd];@05IFEU92@T92@T7AdM1PH6008I6AT01VATI9ZJVZ^[Zj^[
Zc`l?5]KF`8/;2`01A@D55MGEh61PH61PDa<C002AdM700Hi>CTI6ATU9BDU9BDX:2QNGUh2LW9b00H7
1`L410@m?Cdm?CeADE4[:b/28b<S00DX:2Po?clo?cm0@40/;2`00Q8B4P06MgMgFUYJIfMWIfMWEeMG
EUIF0VIVIP05O7al>CTi>CTi9RHVN7Qh008C4a<01UmOGd51@Bh^;Rh^;QTI6B/[:`9ADE401ALG5bd]
;FIVIVIVIRPX:0029bLW00IXJ6QbLW9TI6ATI6@O7an;Rh/2:2PX00Dl?3`N7Qi6ATI6ATH=3@d00PP8
2006MGEe>SXjDe=CDe=CIFEU6ATI0TA4A006:b/[ATI6DE5ADE5ABDU9RXZ:0QHF5P053Ph>LW9bLW9b
MGEeNWYj0098B4P01UIFEUYJFP/;2`/;2fIVI[:b/P8Y:BT01Fe]KFQXJ4m?Cdm?CadM7@02:b/[00D`
<30k>c]WIfMWIfM3@d<00oooo`030000oooooooo00goool001Ooool00`000?ooo`000002oooo00<0
003oool000000oooo`800002oooo00Dd=3AOGemOGel^;RhT92@00Ve]K@057AdMC4a<=cLg=cLg92@T
009kNg/01ZBTY2LW9c/k>c/k>cdm?BXZ:P8d=3@01Ti>CVIVIS4a<C4a<E=CDbHV9P92@T801UiNGW=c
LbDU9BDU9EaLG4i>CP91@D401AXJ6R4Q8B4Q8D51@Clo?`02C4a<00Hj>SX^;Ri<C4a<C4ajNWYCDe<2
5ADE00IbLW9ADE5SHf=SHf>k^k/a<C42AdM700EIFETa<C4a<C4P820h>3P00QXJ6P064a<CKVi^<c<c
<c<c92@TEeMG0UQHF006;2`/Cdm?CDe=CDe=IFEU:b/[0QdM7@05[:b/>SXj>SXj_;blNGUi008R8R80
1R<S8gmoOb0P820P81lO7ahN7P8T92@01S`l?55ADEiNGUiNGX>3PbXZ:P99BDT01GEeMC@d=71`L71`
L3Xj>P022`/;00H[:b]iNGUXJ6QXJ6Q@D50];Bd2P82000I=CDdP820c<c<c<c<E5AE1@D42C4a<00Dg
=cLc<c><S8b<S8a8B4P00S@d=006AdM7EeMG<S8b<S8b8R8RKFe]0Tm?C`069bLW8B4Q];Bd];Bde=CD
I6AT0R8R8P06F5QH>3PhGemOGemO<S8bG5aL0YFEU@05@d=3Y:BTY:BTNWYj7QhN008o?cl01A/K6chn
?QPH61PH665QH@02oooo0P0002?oool00`000?ooo`000002oooo00<0003oool000000oooo`800000
1_oooc<c<gQhN7QhN4E5AC0`<09oOgl01A4A4DY:BTY:BR4Q8@X:2P02UYJF00J<S8`L71`Q8B4Q8B5N
GUh`<302BTY:00EPH61DE5@m?Cdm?CeADE400R/[:`06CDe=J6QXJ6QXJ6QX5ADE@d=30U1@D005@410
<c<c6a/K6a/KB4Q800=<C4`01CXj>Rl_;bl_;dU9BFm_K`02FUYJ00HH61R2PX9SHf=SHf=EEEG9bLT2
;Rh^00Do?cmGEeMGEeLc<c<T92@00T=3@`063`l?92@TOGemOGem8B4Q4A4A0U9BDP05D51@=SHfC4a<
C4a<CDe=009YJFT01RDU9AdM7IZJVYZJVT10@:JVYP:CTi<012DU9B8R8Y2@T92@T0<H61P01QLG5b0P
84E5ADE5AEQHF4m?C`9`L7001S4a<EiNGV][Jf][Jd51@HF5Q@8];Bd01ATI6AhN7QhN7WQhN61PH002
De=C00H`<31eMGDi>CTi>CTI6ATl?3`26QXJ00Df=SI0@410@40k>c/_;bl00Xb<S006@T92>3PhF5QH
F5QHH61P?Cdm0Q@D5005MWIfG5aL8b<S8b<S6ATI00:l_;`01/?3`e5ADBLW9bLW9fATI4M7A`9ADE40
1T10@4i>CX:2PX:2PUaLG9nOW`:FUYH00c8b<U=CDe=CD`02>c/k0Rl_;`03C4a<oooooooo0080000?
oooo000Hoooo00L0003oooooooooool0003oool000000oooo`050000ooooooooooooWIfM009@D500
1UEEEGYjNTa<C4a<C7MgMeMGE`9YJFT01A<C4clo?clo?iFEUBPX:002Jf][00Hg=cMNGUi/K6a/K6a2
@T9KFe/292@T00IIFEUeMGDJ6QXJ6QYnOWhh>3P2E5AD00D_;bmIFEUIFEUIFET61PH00R4Q8@06<C4a
=3@d410@410@8b<S71`L0Rh^;P06I6AT>c/k<30`<30`D51@BTY:0PH61P05Lg=cPh>3=3@d=3@dHV9R
0091@D401TM7Abd];@/;2`/;2cXj>Pl?3`8R8R801VATI4U9BEMGEeMGEbl_;`820P9^KVh01BXZ:UMG
EgYjNWYjNW9bLP02A4A400I=CDe]KFdm?Cdm?Ce]KFe4A4@2CTi>00HI6ATA4A4o?clo?clK6a^1PH42
>CTi00ITI6@U9BD^;Rh^;Ri:BTYaLG42EeMG00D<30aYJFUYJFUVIVIDE5@00UEEE@06ZJVY8R8R7AdM
7AdMAdM751@D0XJ6QP06>c/kXJ6Q:BTY:BTYK6a/2@T90V][J`05EEEE71`L71`L@T92<c<c009UIFD0
1Rl_;ibLW1lO7alO7b`/;2h^;P9?Cdl01QDE5KBd]4Q8B4Q8B5EEEDa<C091@D401GMgMb`/;38b<S8b
<R/[:`02CDe=00I`L71>CTi=CDe=CDdb<S8m?Cd2B4Q800D51@Goooooooooool000009?ooo`070000
oooooooooooo0000oooo000000?oool010000?ooooooojj^[P9NGUh01EEEEH^;Rc4a<C4a<F][J`02
@T9200IUIFD@410k>c/k>c^EUIDS8b<2IfMW00HW9bMYJFU`L71`L70n?Si1@D42;Bd]00E3@d>1PH61
PH4[:b]aLG400T92@P06E5AD<C4aFe]KFe]KEeMG2@T90Rh^;P<l?3`01QTI6BPX:1LG5aLG5bTY:FQX
J08l?3`01Rh^;UIFETm?Cdm?C`H61WUiN@::RXX01B/[:eeMGEeMGCXj>Ta<C002<c<c00H61PI3@d<7
1`L71`L^;RiKFe/2?Shn00ETI6@/;2`=3@d=3@eXJ6P00RPX:006EUIFNGUiKVi^KVi^?clo@d=30WUi
N@05;Bd]MGEeDe=CDe=CAdM7008Z:RX01R8R8Shn?R8R8R8R8WQhN3Lg=`9QHF401RTY:C<c<dU9BDU9
BGIfMV5QH@820P801GIfMV1PH61PH4Q8B4U9B@02WYjN00HI6ATS8b<h>3Ph>3PQ8B6DU9@2<30`00FW
YjLS8b<S8b=_Kfl?3`l00V=SH`06CTi>:RXZDe=CDe=CADE5Hf=S0RLW9`05WIfM8b<S=CDe=CDe;2`/
0094A4@01P`<3:FUYEYJFUYJFSlo?eiNGP8W9bL01WAdM38b<T=3@d=3@bd];E]KF`9fMWH01EIFEU9B
DU9BDSdm?C@d=002=SHf00DD51Coooooooooool000003oooo`005oooo`030000oooo000000;oool0
0`000?ooo`000003oooo00<0003oooooool00_ooo`9nOWh01VATI2@T98N7QhN7QeEEEC<c<`9[Jf/0
1APH661PH61PH451@E]KF`02D51@00H820Ph>3Q5ADE5ADDB4Q9;Bd/251@D00H[:b]ZJVY:BTY:BTY9
BDUOGel2<S8b00De=CDl?3aJFUYJFUXZ:RX00Pd=3@06>3Ph7QhN:b/[:b/[Hf=S3Ph>0U9BDP06M7Ad
:RXZ6QXJ6QXJ>c/kHf=S0TI6AP05DE5AGemO?3`l?3`lS8b<0099BDT01Shn?TU9BClo?clo?eADE3dm
?@8G5aL01U=CDaXJ6UMGEeMGEcHf=R/[:`9BDU801Fm_KhZ:RRl_;bl_;d10@002RHV900ITI6AZJVYQ
HF5QHF5oOgmRHV828B4Q00I1@D4V9RHP820P821ZJVYkNg/230`<00Ho?clY:BUbLW9bLW8U9BDb<S82
EUIF00Dl?3aCDe=CDe<_;blL71`00WUiN@06FEUI>SXj:BTY:BTYQhN7?3`l0UIFEP06A4A4UiNG:b/[
:b/[5aLGLG5a0YnOW`056ATI@410@410>SXjH61P008T92@01W9bLVEUIFEUIFEUIALG5bh^;P8X:2P0
1QXJ6Slo?dE5ADE5AG9bLVm_K`8N7Qh01L[:bTY:BTM7AdM7Ae=CD`02N7Qh00I2@T8j>SXN7QhN7QhZ
:RXY:BT2/k>c00DG5aOoooooooooool000008oooo`030000oooo000000;oool00`000?ooo`000003
oooo00@0003oooooooooool2MgMg00EhN7P^;RidM7AdM7AHF5P00R4Q8@06FEUI1`L7Fe]KFe]K?Shn
FUYJ0Te=C@060`<3>CTi>SXj>SXj30`<A4A40PP820057QhNOWinOWinD51@DU9B009HF5P01T92@SPh
>4I6ATI6AU5ADBHV9P851@D01CDe=B<S8b<S8c@d=5mOG`0210@400I8B4QeMGDS8b<S8b<T92@f=SH2
Hf=S00E7AdM8B4QQHF5QHF51@D400XB4Q006Cdm?A4A4De=CDe=C=cLgDe=C0S@d=0067QhNBDU97AdM
7AdMEeMG?3`l0R<S8`05FEUIMgMgMgMgQXJ6=3@d008k>c/01WinOVYZJVe]KFe]KEMGEhB4Q09IFET0
1AlO7d];Bd];Bbh^;RPX:002IVIV00IoOgl>3Phh>3Ph>3P_;bm[Jf/2;Bd]00De=CEKFe]5ADE5ADEJ
FUX00SPh>0067AdMMgMgEeMGEeMG<c<c<C4a0X61P@05@410EEEEA4A4A4A4TY:B008b<S801R0P87al
O9>CTi>CTb0P83<c<`8o?cl01V][Jc8b<VQXJ6QXJ61PH5eMG@8D51@01Bl_;bLW9bLW9adM7DY:BP02
BDU900EcLg=UIFDI6ATI6AVk^k/00e9BDP05@D51RHV9?Cdm?Cdm>c/k008K6a/2;bl_0ZZZZP0592@T
oooooooooooo000000ooool001Soool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000
oooooooo00;oool2OWin00ITI6@T92B7QhN7QhMEEEDc<c<2Jf][00DH61QPH61PH611@D5KFe/00U1@
D00620P8>3PhADE5ADE54Q8BBd];0Q@D5006:b/[JVYZBTY:BTY:BDU9GemO0S8b<P05=CDe?3`lFUYJ
FUYJ:RXZ008=3@d01SPh>1hN7R/[:b/[:f=SH`h>3P9BDU801WAdM2XZ:QXJ6QXJ6S/k>f=SH`96ATH0
1E5ADEmOGc`l?3`l?8b<S002BDU900Hn?Si9BDTo?clo?cmDE5@m?Cd25aLG00ICDe<J6QYGEeMGEeLf
=SH[:b/2DU9B00E_Kfn:RXX_;bl_;bm0@4000XV9R@06I6ATJVYZHF5QHF5QOgmoHV9R0R4Q8@06@D51
9RHV820P820PJVYZNg]k0P`<3006?clo:BTYLW9bLW9b9BDU<S8b0UIFEP05?3`lDe=CDe=C;bl_71`L
009iNGT01UUIFCXj>RTY:BTY:HN7Qc`l?09FEUH01TA4A9NGUb/[:b/[:aLG5g5aL@:OWil01ATI6D10
@410@3Xj>V1PH00292@T00IbLW9UIFEUIFEUIFDG5aL^;Rh2:2PX00HJ6QXo?cm5ADE5ADEbLW9_Kfl2
7QhN00G:b/Y:BTY7AdM7AdMCDe<00WQhN006@T92>SXj7QhN7QhN:RXZ:BTY0[>c/`055aLGoooooooo
oooo000002Coool00`000?ooooooo`02oooo00<0003oooooool00_ooo`040000oooooooooooo0WMg
M`05N7Qh;Rh^M7AdM7AdF5QH008Q8B401UUIF@L71e]KFe]KFchn?UYJFP9=CDd01P<30cTi>CXj>SXj
>P`<34A4A08820P01AhN7WinOWinOU1@D59BDP02F5QH00I2@T8h>3Q6ATI6ATIADE4V9RH21@D500De
=CDS8b<S8b<d=3AOGel00P@41006B4Q8MGEe8b<S8b<S92@T=SHf0V=SH`05AdM7B4Q8HF5QHF5Q@D51
00:4Q8@01Tm?CdA4A5=CDe=CDcLg=e=CD`8d=3@01QhN7TU9BAdM7AdM7EMGEc`l?08S8b<01EUIFGMg
MgMgMhJ6QS@d=002>c/k00InOWiZJVY]KFe]KFeGEeN4Q8@2FEUI00DO7am;Bd];Bd/^;RhX:2P00VIV
IP06Ogmo3Ph>>3Ph>3Ph;bl_Jf][0Rd];@05=CDeFe]KADE5ADE5FUYJ008h>3P01QdM7GMgMeMGEeMG
Ec<c<c4a<@:1PH401D10@5EEEDA4A4A4A9:BTP02<S8b00HP821lO7bCTi>CTi<P820c<c<2?clo00I[
Jf/b<S9XJ6QXJ6QPH61MGEd251@D00D_;blW9bLW9bLM7Ae:BTX00TU9B@05Lg=cIFEU6ATI6ATI^k^k
00=BDU801D51@HV9RCdm?Cdm?C/k>`026a/K0Rl_;`:ZZZX01B@T9?ooooooooooo`00000?oooo000R
oooo00D0003ooooooooooooYjNT00S4a<@06YjNW@410VYZJVYZJ92@TCdm?0[Ng]`05Bd];LW9bLW9b
MGEe3@d=008k>c/01R4Q8CPh>69RHV9RHS<c<bXZ:P9EEED01Q0@41dM7DY:BTY:BXV9RHF5Q@9IFET0
1E=CDahN7W5aLG5aLC@d=002DE5A0V=SH`8h>3P01Rl_;d51@EmOGemOGdU9BB/[:`9DE5@01SLg=eQH
F5iNGUiNGPT92FMWI`8d=3@01B8R8RXZ:RXZ:Pd=3B0P80027alO00Hl?3`_;bmdM7AdM7@b<S9HF5P2
Cdm?00Hk>c]9BDU@D51@D50U9BE?Cdl2;2`/00EMGEenOWinOWhX:2QIFET00QlO7`06:BTY;2`/PX:2
PX:29bLW=SHf0Q@D5006TY:B1@D5D51@D51@;Bd]9bLW0S8b<P05C4a<R8R8@D51@D51IVIV009OGel0
1VUYJE5ADA0@410@44=3@c@d=08D51@01U]KFbTY:CPh>3Ph>0l?3f5QH@8d=3@01Chn?VATI2<S8b<S
8dE5A@02<C4a00IeMGF`/;0i>CTi>CTQ8B5XJ6P2=CDe00I9BDUSHf=7AdM7AdLS8b<h>3P2Bd];00HR
8R9ZJVYTI6ATI6AJFUX`<302AdM700D/;2``<30`<30g=cLQ8B400W1`L005ADE5:2PXEEEEEEEEGEeM
00?oool00`000?ooooooo`0/oooo00@0003oooooooo_knl2<S8b00FZZZXf=SJBTY:BTY8[:b/00UiN
GP06^[ZjEEEEJVYZJVYZN7Qh3Ph>0Shn?P067AdM<S8bG5aLG5aL:RXZ<30`0UiNGP055aLG9RHV9RHV
C4a<U9BD009gMgL01UeMGE]KFbXZ:RXZ:VMWIbd];@9;Bd/01FQXJ6ATI6ATI38b<RDU9@02@D5100I>
CThh>3Pe=CDe=CDo?cm6ATH2Kfm_00E^KVh@411FEUIFEUHV9RH00QXJ6P067AdM410@;bl_;bl_2`/;
:BTY0RLW9`06J6QX<30`ATI6ATI6GEeM9RHV0UaLG005H61P<c<c<c<cA4A4?Shn009;Bd/01VMWId10
@492@T92@Rl_;c8b<P8h>3P01Fe]KC0`<30`<3Ti>BHV9P02PH6100HH61QTI6@L71`L71`D51@Y:BT2
H61P00EbLW9GEeMGEeMGEeMWIfL00WIfMP06@d=34A4AADE5ADE5:RXZ4a<C0U9BDP05<30`;2`/6a/K
6a/KEEEE008Z:RX01TI6AUeMGB@T92@T94Q8B2l_;`9/K6`01[Zj^S0`<2HV9RHV9V1PH3@d=092@T80
1FUYJD=3@d=3@alO7chn?P02E5AD00HO7amTI6AQHF5QHF5=CDdX:2P2Bd];00D/;2`b<S8n?Shn?ShM
7Ad00W9bLP05ADE5;2`/Cdm?Cdm?I6AT00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooo
ooooooo?cll00XN7Q`06O7alZZZZ=cLg=cLgVi^KB4Q80ZJVYP05RHV9?clo?cloSXj>EEEE00:5QHD0
1U5ADB4Q8E5ADE5ADCdm?EQHF0:DU9@01RTY:G9bLU=CDe=CDbd];AhN7P9<C4`01Chn?VIVIV=SHf=S
HbHV9P02F5QH00HU9BDd=3@@410@410k>c]LG5`2=3@d00I<C4b6QXIOGemOGel`<30o?cl2@D5100DL
71`I6ATH61PH61Q6ATH00QHF5P06<30`6a/K:b/[:b/[?cloHf=S0Y^KV`064A4A2`/;H61PH61P820P
ATI60S0`<005>3Ph:BTY=cLg=cLgHV9R009TI6@01RDU9E5ADFMWIfMWIiRHV0`<30:2PX801PT92JZZ
ZTQ8B4Q8B34a<ATI6@8Y:BT01QTI6@l?3alO7alO7fm_Kjn_[`8P82001F5QHD51@D51@BDU9A/K6`02
:2PX00Ha<C50@40H61PH61RATI4D51@2:BTY00HA4A5SHf<A4A4A4A4j>SXi>CT2BTY:00Dj>SXl?3`l
?3`h>3Q_Kfl00Rl_;`06@d=39bLW3@d=3@d=8b<S;Rh^0P/;2`058b<S:BTY2PX:2PX:;2`/00=nOWh0
1AlO7aHF5QDE5ADE5FIVIP027QhN00IGEeLc<c>GUiNGUiL:2PYPH602GemO00Dg=cOoooooooooool0
0000;_ooo`040000oooooooo^[Zj0YbLW005V9RH[:b/?Shn?Shn/k>c009SHf<01ZRXZ8Z:RTQ8B4Q8
B8Z:RUeMG@:0P8001U=CDb@T94I6ATI6ARl_;f][J`:8R8P01C0`<5eMGEeMGF9RHT51@@025ADE00I0
@419BDU[Jf][Jf]IFETN7Qh2DU9B00DX:2Pb<S8b<S8@410a<C400VATI0068b<SCTi>QhN7QhN7B4Q8
=SHf0T10@005EEEE;2`/9RHV9RHV4a<C0091@D401Q4A4BLW9alO7alO7bDU9D10@09GEeL01ZZZZQDE
5B0P820P84];Bbl_;`8e=CD01DQ8B3lo?clo?adM7CXj>P02FUYJ00IFEUHK6a/j>SXj>SYcLg>WYjL2
:2PX00EWIfL/;2`/;2b;Rh]HF5P00Rh^;P063`l?8b<S61PH61PH0P826QXJ0WUiN@05X:2P=3@dCDe=
CDe=<C4a008d=3@01PH61Sdm?C4a<C4a<E5ADB/[:`:0P8001@L71aXJ6Q/K6a/K6fa/K0022`/;00@e
=CDh>3Q9BDU9BDT2>SXj0SPh>006N7Qh:2PX@d=3@d=38B4Q6QXJ0RTY:@058b<S5aLG5aLG71`L6a/K
008E5AD01SPh>71`L7=cLg=cLbXZ:Q<C4`8L71`01G1`L14A4E]KFe]KFbPX:002WYjN00DC4a=FEUI]
KFe]KFd[:b/00oooo`030000oooooooo00goool002;oool01@000?ooooooooooolo?c`02QhN700Il
O7bZZZXg=cLg=cNKVi]8B4P2YZJV00F9RHTo?clo?cn>SXiEEED00XF5Q@06DE5A8B4QDE5ADE5A?Cdm
F5QH0YBDU006:BTYLW9bDe=CDe=C;Bd]7QhN0Ta<C005?ShnIVIVHf=SHf=S9RHV009HF5P01RDU9C@d
=10@410@43/k>eaLG08d=3@01Ta<C8J6QUmOGemOGc0`<3lo?`91@D401A`L71TI6APH61PH64I6AP02
5QHF00H`<30K6a/[:b/[:b/o?cmSHf<2Vi^K00HA4A4;2`]PH61PH60P8216ATH2<30`00Dh>3PY:BTg
=cLg=cMRHV800VATI0069BDUDE5AIfMWIfMWV9RH30`<0X:2PP062@T9ZZZZB4Q8B4Q8<C4a6ATI0RTY
:@066ATI3`l?7alO7alOKfm_[jn_0R0P8005HF5Q@D51@D519BDU6a/K008X:2P01S4a<D10@1PH61PH
696ATA@D508Y:BT01Q4A4F=SHa4A4A4A4CXj>STi>@9:BTX01CXj>S`l?3`l?3Ph>6m_K`02;bl_00I3
@d<W9bL=3@d=3@dS8b<^;Rh22`/;00DS8b<Y:BT:2PX:2PX/;2`00ginOP057alO5QHF5ADE5ADEIVIV
008N7Qh01UMGEc<c<iNGUiNGU`X:2V1PH09OGel01CLg=oooooooooooo`00000^oooo00@0003ooooo
oonj^[X2W9bL00FHV9R/[:`n?Shn?Sjc/k<00V=SH`06Z:RXRXZ:B4Q8B4Q8RXZ:GEeM0X20P006De=C
92@TATI6ATI6;bl_Jf][0XR8R005<30`GEeMGEeMHV9R@D51008E5AD01T10@4U9BF][Jf][JeUIFAhN
7P9BDU801BPX:38b<S8b<Q0@434a<@02I6AT00HS8b=>CTj7QhN7QhM8B4Pf=SH2@41000EEEED/;2`V
9RHV9RHC4a<00T51@@064A4A9bLW7alO7alO9BDU@4100UMGE`06ZZZZ5ADE820P820PBd];;bl_0SDe
=@05B4Q8?clo?clo7AdM>SXj009JFUX01UIFEQ/K6cXj>SXj>W=cLjNWY`8X:2P01FMWIb`/;2`/;8^;
ReQHF002;Rh^00H?3`lS8b<H61PH61P20P8J6QX2NGUi00FPX:0d=3A=CDe=CDda<C400S@d=0061PH6
?Cdm<C4a<C4aDE5A:b/[0X20P0051`L76QXJ6a/K6a/KK6a/008;2`/013De=CPh>4U9BDU9B@8j>SX2
>3Ph00IhN7PX:2Q3@d=3@d<Q8B4J6QX2:BTY00DS8b<G5aLG5aLL71`K6a/00QDE5@06>3PhL71`Lg=c
Lg=c:RXZ4a<C0Q`L7005L71`4A4AFe]KFe]K:2PX00:NWYh01A<C4eIFEVe]KFe]KB/[:`03oooo00<0
003oooooool03Oooo`008_ooo`800002oooo00EhN7R][Jf][Jdm?CeHF5P00SXj>P05G5aLADE57AdM
7AdMD51@009kNg/01RXZ:TA4A5aLG5aLG5iNGTe=C@8U9BD01Vm_Kh20P7EeMGEeMBTY:J:RXP8L71`0
1QlO7d92@UUIFEUIFA4A4EaLG08D51@016UYJCHf=SHf=TM7A`=6ATH01Pd=3E5ADBDU9BDU9B0P84a<
C0:OWil01PP827IfMQ4A4A4A4F=SHchn?P8/;2`01FEUIDI6ATI6AUEEE@D51@02Bd];00I4A4AFEUJ;
Rh^;Rh]BDU8d=3@2EUIF00H_;blk>c]BDU9BDU9NGUiADE429bLW00E0@41:BTY:BTZTY:AlO7`00Slo
?`06J6QXRXZ:U9BDU9BDCdm?ADE50Ta<C006=cLgC4a<8b<S8b<SI6AT@T920PD51@05FUYJGemOEEEE
EEEEM7Ad008T92@01TE5ABd];BLW9bLW9`h>3XV9R@9NGUh01UEEEE1@D5]KFe]KFcHf=TU9B@8b<S80
1@`<30T92CLg=cLg=g9bLP02CTi>00DR8R8Q8B5=CDe=CDdd=3@00bl_;`066QXJFUYJ:2PX:2PX8R8R
Jf][0RPX:006Q8B4[:b/Lg=cLg=c7AdM:b/[0U=CD`05/[:bV9RHV9RH9BDUOGem009OGel01FATI820
P4e=CDe=CEEEE@02oooo0P0002koool2000000Kooon7QhNk^k^k^k]9BDU:BTX2De=C00ETI6APH61P
H6010@5IFET00XN7Q`06;Rh^D51@BTY:BTY:D51@BTY:0R@T9005K6a/RHV9JVYZJVYZ8R8R00:BTY80
1Q/K6c8b<Rl_;bl_;f=SH`T92@9JFUX01A/K6fUYJCHf=SHf=TE5A@02@d=300Hm?Cd51@EGEeMGEeLf
=SHY:BT2EEEE00JGUiL=3@eXJ6QXJ6PF5QI]KFd2>3Ph00<`<31RHV9RHV800TU9B@8;2`/01T];BdM7
AeiNGUiNGZ>SXeYJFP8m?Cd01DY:BRXZ:R<S8b<S8eaLG002GemO00I1@D4[:b]=CDe=CDe7AdNZZZX2
KFe]00E@D51ZJVZOWinOWin6QXH00S8b<P06:b/[F5QH7alO7alOIVIV>SXj0UiNGP06B4Q84A4AFe]K
Fe]KHV9RF5QH0W5aL@0571`LBd];Bd];7QhN=cLg008R8R801Z6QXE5ADClo?clo?d92@U=CD`9;Bd/0
1E]KFcHf=SHf=Q`L714A4@02>CTi00I[Jf]EEED_;bl_;bl/;2a:BTX2<30`00DJ6QXl?3`d=3@d=3A9
BDT00Pl?3`06:2PXG5aL4a<C4a<CVi^KWinO0V][J`06<c<c@d=3JFUYJFUYcLg=PH610T92@P03O7al
HF5QHF5Q009nOWh2DU9B00=4A4Coooooool00P0000ooool002;oool01@000?ooooooooooogUiN@02
UiNG00Jc/k=2@T9TI6ATI6A2@T8k>c/2QHF500DL71aXJ6QXJ6QLG5b5QHD00Q/K6`06A4A45QHF@D51
@D51EUIF8B4Q0QXJ6P06@D51>SXj4A4A4A4A;Bd]B4Q80SLg=`05;2`/M7AdG5aLG5aLGUiN009[Jf/0
1UIFEWmoOcdm?Cdm?FATI1PH608V9RH01UeMGAhN7[Ng]kNg]cXj>XR8R08f=SH01A`L72`/;0l?3`l?
3chn?P02@41000I=CDdF5QInOWinOWi0@41MGEd2YZJV00H61PHZ:RY5ADE5ADD_;bmKFe/26a/K00DW
9bM>CTiIFEUIFETb<S800PH61P06?3`l5ADEDE5ADE5A?Cdm5ADE0UQHF0064A4A:RXZ;Rh^;Rh^@T92
?Cdm0Ve]K@0630`<FUYJX:2PX:2PBTY:@d=30R`/;005CTi>@D51@D516QXJ?clo008C4a<01RHV9SPh
>6ATI6ATI6m_KdM7A`9>CTh01R/[:di>CRHV9RHV9QXJ6RDU9@8l?3`01Clo?bl_;bl_;g1`L3@d=002
5aLG00IfMWHj>SXP820P820i>CU[Jf/2HF5Q00IEEEEADE4l?3`l?3`O7alE5AD2N7Qh00DC4a=@D52M
WIfMWIe/K6`00UmOG`06HF5QMWIfShn?Shn?IfMWQhN70Rh^;P05;2`/oooooooooooo000002koool0
10000?ooooooofMWI`:9RHT01JJVYS/k>f][Jf][Jd92@P02@d=300J6QXHM7Ae]KFe]KFeDE5BATI42
5ADE00Hi>CT:2PXb<S8b<S98B4PU9BD27QhN00E;Bd]2@T92@T892@T`<3000TE5A@06<S8b9RHVNg]k
Ng]kFUYJGUiN0VEUI@05FUYJPH61PH61>c/kIFEU008I6AT01RTY:EmOGadM7AdM7Kfm_C<c<`:6QXH0
1CTi>B@T92<S8b<S8`d=3@02<c<c00I:BTY3@d<S8b<S8b=aLG4`<302KVi^00Jg]kLC4a<a<C4a<C4g
=cL`<302EeMG00DF5QH[:b/[:b]4A4AUIFD00RHV9P062`/;=3@d:RXZ:RXZ?3`lA4A40Pl?3`05HV9R
5QHF5QHF8B4Q<c<c009@D5001TI6AVm_Ka4A4A4A4EEEEJ>SX`9ADE401DU9BBXZ:U1@D51@D4Q8B002
:b/[00H^;RhI6ATN7QhN7Qi3@d=EEED2Jf][00Dn?Si9BDTc<c<c<c=DE5@00R`/;0066a/K9bLW?Cdm
?Cdm?clo=3@d0WMgM`05:RXZ8B4QJVYZJVYZ:BTY00<c<c<01Fe]KEADE5ADE6a/K59BDP02>3Ph00Hb
<S8S8b>5QHF5QHD<30a=CDd2WIfM00E_KfmGEeMYJFUYJFUXJ6P00YjNWP05FUYJWIfM8R8R8R8R@d=3
00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooom_Kfl00WIfMP061@D5GEeM;2`/
;2`/DE5A8R8R0T=3@`05Jf][LG5aLG5aNg]kN7Qh008Z:RX01UIFEVe]KH20P820P6MWIgIfMP8e=CD0
1U9BDSPh>79bLW9bLTm?Cb@T9091@D401E1@D5ADE20P820P83`l?002HV9R00ISHf<I6ATm?Cdm?CdV
9RH?3`l2=3@d00He=CDh>3QHF5QHF5P_;bm9BDT2EEEE00DJ6QXA4A50@410@40/;2`00Vi^KP06?clo
<c<cQhN7QhN7Rh^;HV9R0W1`L00661PH2@T9>3Ph>3Ph820P7alO0Tm?C`05KVi^8R8R@410@41061PH
009SHf<01U=CDc0`<3`l?3`l?6YZJVMWI`8J6QX01R/[:dI6AVYZJVYZJTM7AiBDU08D51@01R4Q8DE5
AFATI6ATI4Y:BSTi>@8];Bd01C/k>bLW9bLW9g=cLh>3P`02J6QX00H;2`/m?Cd:2PX:2PY^KVh92@T2
<C4a00IVIVHh>3PE5ADE5AD_;bla<C423@d=00E>CTiRHV9RHV8[:b/l?3`00VATI004b<S8?Cdm4Q8B
4Q8B0SHf=P8Q8B401T92@U1@D;:b/[:b/R0P824Q8@8f=SH01@T92A`L7;Jf][Jf]Q8B4P02F5QH00ID
E5A[Jf]hN7QhN7Q<C4`;2`/2>c/k00Df=SKoooooooooool00000;_ooo`040000ooooooooLg=c0VIV
IP053`l?BTY:@T92@T92Hf=S008;2`/01TY:BWalO6][Jf][Jg]kNfe]K@8[:b/01U9BDVUYJHb<S8b<
S5]KFgAdM095ADD01D51@DM7AdM7Af5QHDE5A@02<30`00I1@D5HF5QFEUIFEUH/;2a>CTh2FUYJ00EA
DE451@D51@D/;2`a<C400R4Q8@92@T82=cLg00IBDU8a<C5;Bd];Bd]FEUHC4a<27AdM00Dj>SXO7alO
7an0P80f=SH00TE5A@06MWIfOgmoLG5aLG5aNGUi5ADE0Q<C4`05<c<c8R8R7alO7alOADE5009hN7P0
1Q`L7492@QLG5aLG5fATI5=CD`8b<S801D10@65QHFYZJVYZJRDU9@02<S8b00Hh>3QdM7@h>3Ph>3RC
Ti<T92@27alO00IDE5AOGem0@410@411@D4X:2P2A4A400DW9bMdM7AdM7B0P81/K6`00PX:2P06@410
3@d=Kfm_Kfm_2`/;9RHV0Tm?C`05:BTY7AdM7AdM:BTYBDU9008P82001Ti>CUUIFAhN7QhN7Sdm?F1P
H0;?cll01C@d=1XJ6S/k>c/k>bLW9`02=SHf00I9BDUMGEg1`L71`L4f=SH^;Rh2820P00HI6AT[:b^Z
ZZZZZZX30`=]KFd2A4A400EgMgMaLG5aLG55ADDC4a<00TA4A005?clooooooooooooo000000ooool0
02;oool01@000?ooooooooooofm_K`02MWIf00H51@EMGEd/;2`/;2aADE4R8R82@d=300E[Jf]aLG5a
LG5kNg]hN7P00RXZ:P06EUIFKFe]P820P820IfMWMWIf0SDe=@06DU9B>3PhLW9bLW9bCdm?92@T0T51
@@05D51@E5AD820P820P?3`l009RHV801V=SHaTI6Cdm?Cdm?BHV9Pl?3`8d=3@01SDe=CPh>5QHF5QH
F2l_;dU9B@9EEED01AXJ6Q4A4D10@410@2`/;002KVi^00Ho?clc<c>7QhN7QhN;Rh]RHV82L71`00HH
61P92@Th>3Ph>3PP820O7al2Cdm?00E^KVhR8R90@410@40H61P00V=SH`06De=C<30`?3`l?3`lJVYZ
IfMW0QXJ6P06:b/[ATI6JVYZJVYZAdM7U9BD0Q@D50068B4QADE5I6ATI6ATBTY:>CTi0Rd];@05>c/k
9bLW9bLWLg=cPh>3009XJ6P01P/;2cdm?@X:2PX:2Vi^KPT92@8a<C401VIVISPh>1DE5ADE5Bl_;c4a
<@8=3@d01Di>CV9RHV9RHR/[:c`l?002I6AT00C8b<Pm?CdB4Q8B4Q82=SHf0R4Q8@06@T92D51@/[:b
/[:b820P8B4Q0SHf=P052@T971`L][Jf][Jf4Q8B009HF5P01UADE6][JgQhN7QhN4a<C0/;2`8k>c/0
1CHf=_ooooooooooo`00000^oooo00@0003ooooooomcLg<2IVIV00D?3`m:BTY2@T92@T9SHf<00P/;
2`06BTY:O7alJf][Jf][Ng]kKFe]0R/[:`06DU9BJFUYS8b<S8b<Fe]KM7Ad0TE5A@05@D51AdM7AdM7
HF5QADE5008`<3001T51@EQHF5IFEUIFER`/;4i>CP9JFUX01E5AD@D51@D51B`/;34a<@028B4Q0T92
@P8g=cL01U9BDS4a<D];Bd];BeIFEQ<C4`8M7Ad01CXj>QlO7alO7h20P3Hf=P02ADE500IfMWIoOgma
LG5aLG5iNGTE5AD24a<C00Dc<c<R8R8O7alO7am5ADD00WQhN00671`L@T925aLG5aLGI6ATDe=C0S8b
<P05@410HF5QJVYZJVYZ9BDU008b<S801SPh>7AdM3Ph>3Ph>9>CTb@T908O7al01UADE5mOGd10@410
@451@BPX:094A4@01BLW9gAdM7AdM820P6a/K0022PX:00I0@40=3@e_Kfm_Kfl;2`/V9RH2Cdm?00DY
:BTM7AdM7AdY:BU9BDT00R0P8006CTi>FEUI7QhN7QhN?CdmH61P0/o?c`05=3@d6QXJ>c/k>c/k9bLW
008f=SH01TU9BEeMGL71`L71`CHf=Rh^;P8P82001QTI6B/[:jZZZZZZZP<30fe]K@94A4@01GMgMg5a
LG5aLDE5AA<C4`02A4A400Do?cooooooooooool000003oooo`008_ooo`050000oooooooooooom_Kf
008X:2P01Tm?Cd51@H:2PX:2PR0P83/k>`9YJFT01CTi>B@T92@T95eMGDa<C002BDU900HS8b<e=CDH
61PH61QDE5A3@d<2IfMW00IGEeL[:b]=CDe=CDe;Bd]>CTh2H61P00E^KViUIFE9BDU9BDUBDU800Ti>
CP06N7Qh=cLg;bl_;bl_<c<c2PX:0[>c/`06>c/k:RXZ8B4Q8B4Q;Rh^IFEU0Rh^;P05>c/kHV9RKVi^
KVi^>c/k008n?Sh01WMgMfYZJVi^KVi^KTI6AT=3@`9TI6@01WmoOdY:BS@d=3@d=34a<CDe=@9YJFT0
1G5aLBh^;U9BDU9BDUEEE@02DE5A00I>CTho?cmGEeMGEeLX:2QSHf<2=3@d00HX:2Q8B4Q>CTi>CTiG
EeM4A4@220P800Hj>SYTI6@I6ATI6AT^;Ri1@D42;Bd]00ELG5aQHF5QHF4C4a<E5AD00UEEE@06@d=3
DU9BATI6ATI6Kfm_8b<S0R`/;006:BTY@410<S8b<S8b=CDe>SXj0P/;2`0571`L7alO7alO5ADEEEEE
008O7al01Ta<C4i>CV9RHV9RHShn?RHV9P8T92@01U9BDPd=3H61PH61PF=SH`d=3@:9RHT01CLg=emO
Gg1`L71`L2l_;`02Fe]K00HH61Pn?Si5ADE5ADEZJVZYZJT2Lg=c00ECDe?oooooooooool00000;_oo
o`040000oooooooomoOg0R@T9005B4Q8DU9BKfm_Kfm_=cLg008S8b<01XJ6QQ`L738b<S8b<V][Jf=S
H`8n?Sh01Q`L73<c<a<C4a<C4eYJFS/k>`9lO7`01Chn?T];Bd];BeIFEVUYJ@02KVi^00I7AdMSHf=D
E5ADE5@n?SiCDe<2ADE500E/K6`/;2`/;2`L71`[:b/00R<S8`06^KVi<30`@410@410=CDe7AdM0WYj
NP05<c<c;bl_Lg=cLg=cIfMW0091@D401Ti>CW5aLG]kNg]kNf1PH4Q8B08h>3P016e]KGIfMUEEEEEE
E@8X:2P2A4A400ETI6B1PH61PH4O7amKFe/00U9BDP06C4a<CTi>=SHf=SHfDE5A<S8b0V1PH005>CTi
8R8R8R8RBDU9CDe=009GEeL01TI6APD51DA4A4A4A6m_K`l?3`8n?Sh01CXj>R<S8g=cLg=cLe5AD@02
9RHV00HB4Q9;Bd/i>CTi>CUQHF51@D42JVYZ00DE5ADQ8B4X:2PX:2P_;bl00SDe=@06?3`lB4Q84a<C
4a<C820P30`<0RXZ:P06@4106QXJF5QHF5QHFe]K@D510UeMG@05=CDe5QHF5QHFE5AD3@d=00:EUID0
1W5aL@@418f=SHf=SBPX:61PH09mOGd01D51@De=CAhN7QhN7TA4A002@41000EaLG6?Shn6QXJ6QXI7
AdL00oooo`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0W]kN`06O7alEUIF3@d=
3@d=Cdm?<S8b0V5QH@05EeMGFEUIFEUIMGEe6a/K008[:b/01WIfMPT92Chn?Shn?WIfMVYZJP8@4100
1QlO7hV9RClo?clo?c0`<8J6QP:JVYX01DQ8B7alO451@D51@B<S8`028R8R00Hl?3`];Be?Cdm?CdmG
EeLi>CT2OGem00HJ6QX];Be7AdM7AdLU9BEeMGD2HV9R00E0@419BDUbLW9bLW9YJFT00TY:BP06JVYZ
<30`BTY:BTY:71`L:2PX0TI6AP06;Bd]C4a<<C4a<C4aMgMg;Bd]0QlO7`05Hf=SR8R8Q8B4Q8B4K6a/
008d=3@01Rh^;RLW9da<C4a<C3Lg=cPh>08j>SX01P`<32PX:2d];Bd];E5ADB4Q8@8N7Qh01UeMGE1@
D5IFEUIFETQ8B<W9b@8n?Sh01G5aLHn?Shn?Sde=CDY:BP02Cdm?00I=CDde=CD>3Ph>3PiWIfMRHV82
F5QH00I9BDT:2PXi>CTi>CT_;bm8B4P2JVYZ00EJFUXg=cLg=cMRHV9SHf<00S/k>`065aLG<c<c?Cdm
?Cdm;2`/EEEE0QTI6@063@d=@T92QHF5QHF5;bl_7AdM0W1`L005;Bd]IFEUDE5ADE5A=SHf008H61P0
1W5aLFi^KU=CDe=CDb0P8::RXP8P82001EiNG_ooooooooooo`00000^oooo00@0003oooooooooool2
NWYj00ElO7a4A4@B4Q8B4Q8a<C400P@41006RXZ:=SHf>SXj>SXj[:b/8B4Q0P820P06NGUi8B4Q<S8b
<S8bOgmoJf][0PH61P05;Bd]O7alO7alE5ADG5aL00:a/K401VYZJSdm?DU9BDU9BC0`<1/K6`8/;2`0
1E1@D1LG5aLG5emOGdi>CP02?Cdm00IjNWXB4Q8^;Rh^;RiHF5PS8b<2Shn?00E<C4a3@d=:BTY:BTZ4
Q8@00TU9B@06E5ADEEEE=cLg=cLg?Cdm9BDU0Rd];@06BTY:=3@d?3`l?3`l>SXjI6AT0SHf=P05=3@d
LW9bLW9bQHF5TY:B009IFET01R<S8bTY:A/K6a/K6chn?S/k>`8h>3P01BTY:AXJ6QXJ6Q/K6b`/;002
DE5A00H[:b/U9BEHF5QHF5QADE5CDe<2Cdm?00G7alLe=CEjNWYjNWZ4Q8@00UYJFP06?ShnDU9BAdM7
AdM7<C4a2`/;0VATI005FUYJGUiN@T92@T924A4A0091@D401R@T94m?CfYZJVYZJUeMGCTi>@=TI6@0
1Bh^;QDE5ADE5AdM7CDe=@02?3`l00E:BTXU9BDU9BDP8212@T800Xb<S006<C4a6QXJMGEeMGEe@T92
Bd];0W=cL`059RHV6a/KIVIVIVIVLG5a009kNg/01AhN7X61PCTi>CTi>EmOG`03oooo00<0003ooooo
ool03Oooo`008_ooo`800003oooo0WalO006EUIF<30`;2`/;2`/>SXj=CDe0UIFEP05ATI6k^k^k^k^
GEeM6QXJ008>3Ph01QXJ6QDE5CTi>CTi>GQhN5YJFP8W9bL01TQ8B4U9BAHF5QHF5QhN7VEUI@8Q8B40
1FEUIE9BDS0`<30`<3dm?@02=cLg00I6ATHW9bLj>SXj>SYKFe/@4102820P00HC4a<Z:RX`<30`<30V
9RIeMGD2@D5100DT92@D51A1@D51@D4l?3`00UeMG@06De=CB4Q892@T92@T=3@dC4a<0P`<3006I6AT
30`<@d=3@d=3][Jf8B4Q0T=3@`05:2PXHF5QDE5ADE5A?Cdm009lO7`01Q4A4C`l?3lo?clo?bh^;S<c
<`9LG5`01QHF5R/[:clo?clo?dE5AEYJFP9YJFT01Sdm?CXj>U=CDe=CDa4A4JJVYP9GEeL01G1`L:>S
Xj>SXginOXb<S0026a/K00Hg=cMKFe]XJ6QXJ6PO7amLG5`2O7al00I0@40Z:RXT92@T92@c<c<j>SX2
C4a<00FOWinWYjNWYjLX:2PC4a<00W9bLP0651@D2`/;4a<C4a<C>CTiDE5A0R8R8P06?3`lL71`FUYJ
FUYJ;Rh^>CTi0Sdm?@05=SHf3`l?9BDU9BDU8R8R009OGel01STi>J:RXS0`<30`<4Q8B5EEE@9;Bd/0
0eaLG?ooooooo`020000;_ooo`8000001_ooooShn7emOGemOD];BbXZ:P8f=SH01B`/;34a<C4a<D51
@E5AD@02fm_K00IUIFDT92@Z:RXZ:RXG5aLK6a/2;bl_00EhN7QTI6@R8R8R8R95ADD00U9BDP064Q8B
9RHVKVi^KVi^4Q8BCTi>0SHf=P05D51@8b<SE5ADE5ADJFUY008R8R801TU9BChn?RXZ:RXZ:Q/K6`@4
108b<S82;bl_0W9bLP05<S8b8B4Q6a/K6a/K?3`l008_;bl01Vm_Kde=CC<c<c<c<b<S8alO7`9FEUH0
1QHF5UUIFAHF5QHF5T51@JFUY@8`<3001EIFEQ@D51@D56UYJE]KF`02;Bd]00I^KVh51@Da<C4a<C4n
?ShV9RH2?3`l00E=CDdW9bLW9bLG5aLa<C400TA4A006DE5AMGEe:RXZ:RXZ=CDeBDU90P/;2`05YjNW
FUYJJ6QXJ6QXX:2P009bLW801YnOWadM7CDe=CDe=FIVIVYZJP8H61P01FMWIg]kNd=3@d=3@c4a<@02
8B4Q00H/;2a5ADE9BDU9BDV/[:bHV9P23@d=00HO7an6QXHb<S8b<S8W9bL];Bd2C4a<00E5ADDN7QhN
7Qhi>CU]KFd00UmOG`059BDUA4A4;2`/;2`/:RXZ00<U9BD01C@d=51@D28R8R8R8[fm_@026QXJ00EO
Gelo?clh>3Ph>3QADE400_ooo`80000?oooo000Roooo00<0003oooooool00_ooo`9lO7`01UIFES0`
<2`/;2`/;3Xj>SDe=@9FEUH01DI6A^k^k^k^kUeMGAXJ6P023Ph>00HJ6QXE5ADi>CTi>CUhN7QJFUX2
9bLW00I8B4Q9BDTF5QHF5QHN7QiUIFD28B4Q00EUIFEBDU8`<30`<30m?Cd00SLg=`06ATI69bLW>SXj
>SXjFe]K410@0R0P80064a<C:RXZ<30`<30`9RHVMGEe0T51@@0592@T51@D@D51@D51?3`l009MGEd0
1U=CDdQ8B2@T92@T93@d=4a<C08<30`01VATI0`<34=3@d=3@kJf]R4Q8@93@d<01BPX:65QHE5ADE5A
DCdm?@02O7al00HA4A4l?3`o?clo?cl^;Rhc<c<2G5aL00HF5QH[:b/o?clo?cm5ADEJFUX2JFUY00Hm
?Cdj>SYCDe=CDe<A4A6VYZH2EeMG00E`L72SXj>SXj=nOWj<S8`00Q/K6`06=cLgFe]KJ6QXJ6QX7alO
G5aL0WalO006@410:RXZ92@T92@T<c<c>SXj0Ta<C005WinOYjNWYjNW:2PX4a<C009bLW801Q@D50/;
2a<C4a<C4cTi>E5AD@8R8R801S`l?71`L5YJFUYJFRh^;STi>@8m?Cd01CHf=Pl?3bDU9BDU9B8R8P02
GemO00Hi>CVRXZ8`<30`<318B4QEEED2Bd];00ELG5coooooooooool00000;_ooo`040000oooooooo
n?Sh0WemO@05Bd];:RXZ=SHf=SHf;2`/008a<C401T51@E5ADM_Kfm_KffEUIB@T908Z:RX01QLG5a/K
6bl_;bl_;gQhN6ATI08R8R801DE5AE9BDU9BDQ8B4RHV9P02KVi^00HB4Q9>CThf=SHf=SI@D50S8b<2
E5AD00EYJFTR8R8R8R99BDTn?Sh00RXZ:P046a/K10@4<S8b<S8b0Rl_;`9bLW801C8b<R4Q8A/K6a/K
6c`l?002;bl_00I_Kfm=CDdc<c<c<c<S8b<O7al2EUIF00HF5QIIFETF5QHF5QI1@D6UYJD2<30`00EF
EUHD51@D51AYJFUKFe/00Rd];@06KVi^1@D5<C4a<C4a?Shn9RHV0S`l?005CDe=9bLW9bLW5aLG<C4a
0094A4@01U5ADGEeMBXZ:RXZ:SDe=DU9B@8;2`/01JNWYeYJFVQXJ6QXJ:2PX002LW9b00JOWilM7Ade
=CDe=CEVIVIZJVX261PH00EWIfMkNg]3@d=3@d<a<C400R4Q8@06;2`/ADE5BDU9BDU9[:b/V9RH0Pd=
3@067alOQXJ6<S8b<S8b9bLW;Bd]0Ta<C005ADE57QhN7QhN>CTiKFe]009OGel01BDU9DA4A2`/;2`/
;2XZ:P039BDU00Dd=3A@D50R8R8R8R:m_Kd00QXJ6P05GemO?clo>3Ph>3PhDE5A00?oool00`000?oo
ooooo`0=oooo000Roooo00D0003oooooooooooono_h00V9RHP06]kNg>SXjIFEUIFEUB4Q8LG5a0R@T
9005Jf][BDU9BDU9Ph>3D51@00=3@d<01EUIFBXZ:RXZ:QdM7JRXZ002>CTi00IHF5QiNGUOGemOGeli
>CTa<C420`<300E:BTY[Jf]]KFe]KFe=CDd00Q/K6`06L71`7alO8B4Q8B4Q8R8R=CDe0QLG5`0651@D
?ShnI6ATI6ATG5aL6QXJ0R/[:`05GUiNATI6>SXj>SXjO7al009:BTX01Q0@459BDU]KFe]KFd10@7em
O@8F5QH01UMGEcXj>R/[:b/[:de=CFEUI@9LG5`01F5QHD92@Rl_;bl_;dm?C`02CDe=00I6ATHk>c]b
LW9bLW95ADDo?cl2=CDe00H:2PXN7Qj>SXj>SXh@411[Jf/2FUYJ00HZ:RXT92ADE5ADE5@:2PYHF5P2
=3@d00E9BDUCDe=CDe<N7Qj7QhL00SPh>006?clo71`L>c/k>c/kEUIFBTY:0X:2PP068b<S>3Ph61PH
61PHBDU9Bd];0SXj>P0592@TOWinOWin:RXZ30`<0097AdL01SXj>S@d=3Lg=cLg=b@T934a<@9dM7@0
1V5QHHb<S30`<30`<4E5AD10@08W9bL01B4Q8H^;R`P820P823Ph>0024Q8B00Jh^;QNGUiWIfMWIfLa
<C5SHf<2NWYj00EoOgooooooooooool00000;_ooo`040000oooooooooooo0UIFEP05WinO820PB4Q8
B4Q8<c<c009eMGD01T51@F=SHemOGemOGi6ATEMGE`91@D401Shn?UUIFBh^;Rh^;Pl?3kRh^09FEUH0
1DA4A79bLW9bLWYjNSdm?@026QXJ00HC4a=ADE5eMGEeMGEYJFUFEUH29RHV00EoOgl;2`/;2`/D51@=
3@d00TI6AP060`<32PX:De=CDe=CDE5AI6AT0RTY:@05=3@dDE5ABd];Bd];;bl_00:=SHd01Te=CAHF
5UQHF5QHF5eMGC/k>`9`L7001QhN7UIFESHf=SHf=S<c<eADE09JFUX01E]KFeEEEEEEED92@SLg=`02
AdM700I>CTi0@40i>CTi>CUbLW9:BTX2=cLg00D[:b/F5QHF5QHC4a=jNWX00RPX:006F5QHKVi^5QHF
5QHF<30`GEeM0PT92@05GUiN;Rh^E5ADE5ADATI6008?3`l01YBDU2h^;T92@T92@S`l?3Hf=P8e=CD0
1Fm_KhB4Q3De=CDe=Chn?P027AdM00I=CDe9BDU7AdM7AdLo?cmLG5`2=3@d00Hk>c]DE5AZJVYZJVXX
:2P<30`2>SXj00E=CDeZJVYZJVY^KVj9RHT00S0`<006CDe=B4Q89RHV9RHV:RXZRh^;0R`/;0055QHF
9RHVUYJFUYJFP820009OGel01BLW9eQHF7alO7alO7emO@03oooo00<0003oooooool03Oooo`008_oo
o`030000oooooooo00;oool2WYjN00I2@T9TI6B2PX:2PX8:2PYbLW82Lg=c00DF5QIXJ6QXJ6S/k>bO
Wil00S8b<P06ADE5^KVi61PH61PHNWYjM7Ad0V5QH@06F5QHWYjN7QhN7QhNEeMGQXJ60Ve]K@05G5aL
92@T;Rh^;Rh^=CDe008H61P01SHf=QPH64E5ADE5ACLg=a8B4P8Z:RX01Q8B4YBDU28R8R8R8UIFEPD5
1@9LG5`01:j^[T];BemOGemOG`>YZJT01VQXJ30`<6YZJVYZJUIFEZj^[P99BDT01S`l?2TY:@820P82
0RDU9B`/;08m?Cd01D];Ba/K6di>CTi>CQDE5@02GEeM00JOWil];Bd`<30`<30a<C6HV9P2:RXZ00I:
BTY?Cdm>CTi>CTiHF5Q@D502?3`l00IdM7AIFEUmOGemOGeNGUhj>SX2>CTi00Dk>c]eMGEeMGF7QhLW
9bL00V5QH@06@T92CTi>2@T92@T9Bd];DE5A0Tm?C`06F5QH1PH6FUYJFUYJH61PJ6QX0STi>@05:BTY
92@T92@THV9RH61P008K6a/01T];BadM7FYZJVYZJSdm?A@D508O7al01UEEEB0P86UYJFUYJ@X:2Q`L
709_Kfl01Chn?WYjNTi>CTi>CVATI002IFEU00Hf=SHm?CeKFe]KFe]2@T:FUYH2SXj>00D/;2cooooo
ooooool00000;_ooo`040000oooooooooooo0XV9R@05<c<cC4a<Kfm_Kfm_:RXZ009EEED01VMWIb`/
;6IVIVIVI_KfmYjNWP8_;bl01S`l?;^k^`D51@D51Hj>SXN7Q`9/K6`01E1@D9BDU9BDU2TY:FUYJ@02
Ogmo00A]KFeXJ6PQ8B4Q8B42<C4a0R<S8`05Cdm?20P820P8<30`AdM7008=3@d01STi>AlO7j:RXZ:R
XR4Q8FUYJ@8C4a<01GIfMY>CTf9RHV9RHTA4A002_[jn00JQXJ5]KFd`<30`<31gMgM>CTh2ZZZZ00I:
BTXf=SHS8b<S8b<C4a<A4A425QHF00DY:BU3@d=3@d<W9bM@D5000R0P8006JVYZUiNG<S8b<S8b:b/[
<S8b0Y:BTP057alOEUIFEUIF?Shn?3`l0098B4P01UiNGS/k>gAdM7AdM61PH820P09LG5`2@T920SPh
>005QXJ6MgMgMgMg?ShnEUIF0094A4@01S`l?1DE5DA4A4A4A6MWIf5QH@9GEeL01@@415]KFe]KFfQX
J71`L002?3`l00Ha<C4V9RISHf=SHf=hN7P_;bl2@d=300DU9BE>CThP820P820V9RH00Q`L7006GEeM
8B4QLg=cLg=c3@d=8R8R0UiNGP067AdMOgmo<30`<30`Rh^;@d=30S8b<P05F5QHD51@D51@BTY:T92@
00:<S8`01B<S8oooooooooooo`00000?oooo000Roooo00D0003oooooooooooo[jn/00WinOP06@T92
:BTYJFUYJFUY8b<SY:BT0TE5A@05EeMG@d=3@d=36QXJOWin009^KVh01SLg=eEEEAdM7AdM7JRXZ5=C
D`8T92@01VQXJ3Ph>14A4A4A4A8B4S@d=08?3`l01EIFER0P869RHV9RHRXZ:P02@41000IRHV8Y:BTn
?Shn?Sh_;bm0@4025QHF00He=CF7QhLK6a/K6a]GEeL:2PX2>CTi00Dn?Si>CTh?3`l?3`nf][H00QTI
6@06WinOYjNW61PH61PHPH61;2`/0U9BDP06NWYjFEUI6a/K6a/KDU9B:BTY0U=CD`0571`LC4a<IFEU
IFEU:RXZ0098B4P01Tm?Cd10@38b<S8b<QdM7IJFUP8N7Qh01Q8B4QTI6D92@T92@Sdm?Chn?P9>CTh0
1Y^KVaLG5fYZJVYZJTQ8B6UYJ@8m?Cd01Dm?Cb/[:b/[:aTI6DI6AP02CDe=00ILG5c8b<QADE5ADE5R
HV:LW9`2:RXZ00Ho?cmYJFVQXJ6QXJ5oOgl410@2;bl_0bTY:@0630`<KVi^GemOGemO<C4a>c/k0U=C
D`06SXj>>SXj?clo?cloShn?EEEE0UiNGP06PH61BDU9];Bd];BdMWIfFe]K0UEEE@051`L7De=CDe=C
5aLGShn?009WIfL01I>CTf9RHU9BDU9BDQ8B4P03oooo00<0003oooooool0;?ooo`040000oooooooo
l?3`0XZ:RP05F5QH61PHNg]kNg]k=SHf00:BTY801SLg=dQ8B4m?Cdm?Ca/K6hb<S09]KFd01RPX:4E5
ABh^;Rh^;Zn_[f9RHP8l?3`01EADE2DU9BDU9ATI6@l?3`02<S8b00H?3`mPH60_;bl_;bmBDU8A4A42
<c<c00EPH60=3@d=3@d`<30U9BD00T92@P068R8R?CdmTI6ATI6A4a<CIFEU0P`<3005=3@d9RHVBDU9
BDU98B4Q00;?cll01Q4A4HR8R<30`<30`0D51GUiN@8/;2`01Ta<C7inOU9BDU9BDPT92DM7A`8k>c/0
1EADE0<30`<30fQXJ5UIF@02@41000Hk>c/m?Cdo?clo?clc<c<R8R82Ti>C0aTI6@067QhN=SHf<c<c
<c<cCDe=FUYJ0Y>CT`068b<SGemO=cLg=cLgMGEe;bl_0V5QH@04=3@d9bLW9bLW=CDe0e5AD@06`l?3
D51@IFEUIFEUWinO:b/[0SXj>P05Kfm_UYJFUYJFSHf=5QHF0097AdL01SPh>3Hf=R0P820P88Z:RTE5
A@8i>CT01C<c<d=3@hB4Q8B4Q3/k>`02?Cdm00J<S8aGEeM/K6a/K6b5QHE=CDd2VIVI00I[Jf]0@41N
GUiNGUhR8R9SHf<27AdM00FGUiMJFUYJFUZ=SHeIFET00TQ8B00510@4oooooooooooo000000ooool0
02;oool01@000?ooooooooooon_[j`02OWin00I2@T8Y:BUYJFUYJFTS8b>TY:@2ADE500EGEeM3@d=3
@d<J6QYnOWh00Vi^KP06=cLgEEEE7AdM7AdMZ:RXDe=C0R@T9006J6QX>3Ph4A4A4A4A4Q8B=3@d0Pl?
3`05EUIF820PHV9RHV9R:RXZ0090@4001V9RHRTY:Chn?Shn?Rl_;d10@08F5QH01SDe=HN7Qa/K6a/K
6eMGE`X:2P8i>CT01Chn?Ti>CPl?3`l?3kJf]P026ATI00JOWinWYjLH61PH61R1PH4/;2`2DU9B00Ij
NWYIFETK6a/K6a]BDU8Y:BT2De=C00DL71a<C4aUIFEUIFDZ:RX00TQ8B006Cdm?@410<S8b<S8b7AdM
UYJF0QhN7P064Q8B6ATI@T92@T92?Cdm?Shn0Ti>CP06Vi^K5aLGJVYZJVYZB4Q8JFUY0Sdm?@05Cdm?
:b/[:b/[6ATIATI6009=CDd01UaLG<S8b55ADE5ADF9RHYbLW08Z:RX01Slo?fUYJJ6QXJ6QXGmoO`@4
108_;bl3:BTY00H<30a^KViOGemOGela<C4k>c/2De=C00J>SXhj>SXo?clo?cn?ShmEEED2GUiN00J1
PH59BDVd];Bd];AfMWIKFe/2EEEE00D71`MCDe=CDe<G5aN?Shl00VMWI`05Ti>CHV9RDU9BDU9B4Q8B
00?oool00`000?ooooooo`0/oooo00@0003oooooooo`l?02RXZ:00EHF5PH61QkNg]kNg/f=SH00Y:B
TP06=cLgB4Q8Cdm?Cdm?6a/KS8b<0Ve]K@06:2PXADE5;Rh^;Rh^[jn_HV9R0S`l?005E5AD9BDU9BDU
6ATI3`l?008b<S801Pl?3f1PH2l_;bl_;e9BDQ4A4@8c<c<01F1PH0d=3@d=3C0`<2DU9@02@T9200HR
8R8m?CfATI6ATI4C4a=UIFD230`<00Dd=3@V9RI9BDU9BDTQ8B400/o?c`064A4AR8R8`<30`<301@D5
NGUi0R`/;006C4a<OWinDU9BDU9B2@T9AdM70S/k>`05E5AD0`<30`<3J6QXFEUI0090@4001S/k>cdm
?Clo?clo?c<c<b8R8P:CTi<36ATI00HN7Qhf=SHc<c<c<c==CDeJFUX2Ti>C00HS8b=OGelg=cLg=cMe
MGD_;bl2HF5Q00@d=3@W9bLW9bLe=CD3DE5A00K3`l=@D51UIFEUIFFOWil[:b/2>SXj00E_KfnFUYJF
UYJ=SHdF5QH00TM7A`06>3Ph=SHf820P820PRXZ:ADE50STi>@05<c<c@d=3Q8B4Q8B4>c/k008m?Cd0
1Xb<S5MGEfa/K6a/K8F5QDe=C@:IVIT01V][Jd10@5iNGUiNGR8R8V=SH`8M7Ad01INGUeYJFUYJFXf=
SEUIF@02B4Q800D410Coooooooooool000003oooo`008_ooo`050000ooooooooooooVYZJ009MGEd0
1Zn_[b8R8R0P820P89RHV4a<C095ADD01D10@5IFEUIFEVi^KY^KV`023`l?00ITI6ANGUhl?3`l?3`c
<c<S8b<2ADE500IFEUHk>c]0@410@417AdLW9bL2820P00E6ATHQ8B5JFUYJFUYDE5@00TM7A`06CTi>
:BTY9BDU9BDU<30`Bd];0Q8B4P06820PG5aLE5ADE5AD6ATI61PH0WAdM005FEUI51@DSHf=SHf=61PH
0097AdL01Pd=3B4Q8@/;2`/;2eMGEaXJ6P8b<S801UEEEA8B4UUIFEUIFDY:BT];B`8;2`/01BHV9Pd=
3EmOGemOGd];B`02:BTY00I[Jf/Y:BTe=CDe=CE=CDe4A4@2EEEE00HA4A4/;2a?Cdm?CdmnOWhK6a/2
51@D00IYJFUgMgLB4Q8B4Q8N7QhH61P2G5aL00E5ADDC4a<C4a<J6QY>CTh00YjNWP06G5aLFUYJ@d=3
@d=3b/[:5QHF0TY:BP067alOBDU9G5aLG5aL;bl_?clo0S0`<005HF5QQhN7QhN7?Shn5QHF008k>c/0
1R4Q8DM7Aa@D51@D5:NWYa`L708f=SH01DY:BWQhN71`L71`L9BDU003EEEE00Fm_Kf:RX[De=CDe=BE
UID00UaLG006:RXZCTi>410@410@:b/[>c/k0Slo?`05K6a/oooooooooooo000002koool010000?oo
oooooi>CT`9ZJVX01KZj^S<c<b0P820P8:RXZ002?Cdm00Hg=cM6ATI>CTi>CTiZJVZKVi/23`l?00IO
GemUIFDi>CTi>CU0@40I6AT2@D5100E7AdM9BDU9BDTg=cLo?cl00R<S8`067alOATI66a/K6a/KD51@
BDU90U1@D005AdM7>CTi>CTi;2`/8b<S0097AdL01Q/K6bHV9V9RHV9RHU5ADA`L708?3`l01FUYJE]K
F`P820P82:2PX0025ADE00I3@d<?3`lZ:RXZ:RXF5QI@D5024a<C00He=CEDE5@G5aLG5aMGEeMDE5@2
FEUI00DI6ATa<C4a<C4O7amQHF400SPh>0066ATIG5aL=CDe=CDe;2`/Bd];0TI6AP05DE5A61PH61PH
;bl_DU9B009kNg/01Q`L71lO7f][Jf][JgEeM@D51@8A4A401B4Q8Dm?Cdm?Cdm?C`/;2`023@d=00IF
EUJNWYiCDe=CDe=FEUHm?Cd2c/k>00DG5aM9BDTN7QhN7Qi<C4`00U=CD`06;bl_B4Q8?clo?cloK6a/
RHV90Ta<C0069bLW>3Ph4Q8B4Q8BADE52@T90Z:RXP048B4Q<c<c<c<cCDe=0gUiN@06TI6AEUIFB4Q8
B4Q8Zj^[W9bL0/C4a005Xj>SKVi^>SXj>SXjCTi>008:2PX01BDU9Cdm?D51@D51@FMWI`03oooo00<0
003oooooool03Oooo`008_ooo`800002oooo00F<S8cooooooom?Cdnj^[X00X61P@05=3@d71`LBd];
Bd];3`l?00;1`L401W5aLBHV9SXj>SXj>QhN7Vm_K`97AdL01WYjNWIfMS0`<30`<4m?Cc@d=09XJ6P0
1X>3Pc@d=38b<S8b<Q4A4De=C@8J6QX01IRHV2`/;2`/;2PX:4A4A002Bd];00IOGelP821RHV9RHV8[
:b]/K6`2ZZZZ00I<C4`o?cm>CTi>CTiWIfMcLg<2OGem00EWIfM:BTY:BTYSHf<I6AT00Q`L7006:b/[
Kfm_>CTi>CTiRXZ:6QXJ0Ve]K@06U9BDFUYJEUIFEUIF@410FUYJ0QDE5@05Jf][?3`l?3`l10@4D51@
009ADE401Pl?3gQhN4U9BDU9BDM7AfATI08k>c/01[bl_5UIFBDU9BDU9Cdm?F1PH09cLg<01AXJ6UMG
Ee]KFe]KFbPX:002[Jf]00I@D50j>SXH61PH61Q]KFe8B4P2IFEU00IQHF4g=cMKFe]KFe]^KViQHF42
GUiN00Dk>c^HV9R2PX:2PX9MGEd00TQ8B0068b<S>c/kJVYZJVYZA4A4;bl_0Q@D5006GUiN3@d=8B4Q
8B4QC4a<FEUI0SXj>P06IFEUB4Q820P820P8=cLg=3@d0S8b<P05?3`lIFEUIFEUIFEU<30`008];Bd0
1F=SHdQ8B410@410@3`l?002oooo0P0002koool2000000KooonFUYKooooooomADE6`/;02R8R800Da
<C4N7QhN7Qi<C4`@41000/S8b006IfMW;bl_=SHf=SHf5QHFJ6QX0U1@D005IFEULG5a61PH61PHH61P
0093@d<01V=SHhF5QCDe=CDe=C<c<`l?3`9;Bd/01A4A4I^KVaXJ6QXJ6T10@002FEUI00I4A4A7AdLW
9bLW9bM5ADDY:BT2PH6100JYZJU=CDe9BDU9BDU:BTYTI6@2M7Ad00F9RHUJFUYJFUYMGEe<C4`00Rh^
;P0692@T51@DJf][Jf][DU9BOGem0R`/;005OGemSHf=IVIVIVIVE5AD008o?cl01UYJFQ@D56][Jf][
Jcdm?A8B4P90@4001D=3@aPH68>3Ph>3PcPh>002BDU900I]KFe6ATJ`/;2`/;1TI6@W9bL2@41000IT
I6A`L70T92@T92A<C4aMGEd2;Rh^00FXZ:Q>CTi>CTi9BDT>3Ph00WQhN006@410K6a/IFEUIFEU>SXj
Hf=S0VUYJ@04H61PJFUYJFUYBDU90hZ:RP06CTi>>c/k;Rh^;Rh^=3@dKFe]0TQ8B005<30`5QHFFe]K
Fe]K4a<C008G5aL01TM7AfIVIRl_;bl_;f5QHE=CD`8B4Q801Shn?SXj>S4a<C4a<CTi>FATI09ZJVX3
:RXZ00EKFe]7AdM3@d=3@d=9BDT00_ooo`80000?oooo000Roooo00D0003ooooooooooon>SXh00UQH
F006Shn?EEEETI6ATI6A5aLG4A4A0Y:BTP05G5aL=CDe=CDe@d=3Ng]k0091@D401VYZJQ8B4RLW9bLW
9fIVIZ6QX@96ATH01Ve]KCHf=VQXJ6QXJ3hn?V][J`:OWil01Fi^KSHf=UADE5ADE9VIV@02CTi>00I<
C4`Q8B5<C4a<C4`j>SXE5AD2RHV900I=CDeADE52@T92@T8R8R94A4@2L71`00Dg=cM2@T94A4A4A4B<
S8`00WAdM0067AdMJVYZ30`<30`<BDU9:RXZ0VYZJP06?clo@T92AdM7AdM7bLW9=SHf0UeMG@05H61P
HV9RIFEUIFEUUIFE0098B4P01STi>FQXJ8V9RHV9RGUiNBLW9`8;2`/01R<S8cLg=cTi>CTi>BTY:AdM
7@:XZ:P01Q/K6b4Q8D=3@d=3@c@d=4Y:BP8b<S801FATI4E5ADE5AE=CDb8R8P0230`<00HS8b=OGelk
>c/k>c^EUIDj>SX2M7Ad00Hh>3P/;2`O7alO7amBDU9WIfL2ADE500EbLW95ADE5ADEIFETa<C400S0`
<006>3Ph:2PX>c/k>c/k;bl_?clo0TI6AP06I6ATFUYJ=CDe=CDeBTY:9BDU0RXZ:P05Bd];?3`lGUiN
GUiN6ATI009?Cdl01R`/;4i>CV9RHV9RHUADE6e]K@:@T9001D=3@oooooooooooo`00000^oooo00@0
003ooooooon;Rh/2E5AD00FCTi=HF5RUYJFUYJD/;2`00PL71`06Ti>CBd];8B4Q8B4QBTY:IFEU0UEE
E@06IfMW61PH=cLg=cLgF5QHTI6A0S/k>`05M7AdATI6ATI6IFEUBd];009eMGD01XV9RG9bLR`/;2`/
;55ADHf=S@9LG5`01DM7AaLG5aLG5e5ADCdm?@026a/K00IiNGUYJFU@D51@D50_;blg=cL2@D5100EP
H61<C4`k>c/k>c]=CDd00XV9R@06MgMg51@DIFEUIFEU61PHH61P0RTY:@06M7AdFUYJ9bLW9bLWF5QH
];Bd0S0`<005H61PFe]KFe]KL71`FEUI00:QXJ401Ta<C2`/;5QHF5QHF861PHj>SP8_;bl01AhN7STi
>CTi>D10@2PX:0026QXJ00HC4a>i^KTW9bLW9bLd=3@h>3P29bLW00Di>CTY:BU`L71`L70[:b/00VIV
IP06:2PX30`<=SHf=SHfKFe]AdM70Y2@T005?cloOGem:RXZ:RXZ6ATI008g=cL01UUIFF][Jc0`<30`
<51@D6YZJP8l?3`01R@T94];Bbd];Bd];Bh^;Rd];@8U9BD01DE5AD92@T92@UmOGdi>CP02ATI600I9
BDTj>SXX:2PX:2QCDe=OGel2DE5A00D<30`a<C4L71`L71aSHf<00U5AD@05I6ATL71`Ti>CTi>C@D51
00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooon>SXh00UQHF006Shn?EEEETI6A
TI6A5aLG4A4A0Y:BTP05G5aL=CDe=CDe@d=3Ng]k0091@D401VYZJQ8B4RLW9bLW9fIVIZ6QX@96ATH0
1Ve]KCHf=VQXJ6QXJ3hn?V][J`:OWil01Fi^KSHf=UADE5ADE9VIV@02CTi>00I<C4`Q8B5<C4a<C4`j
>SXE5AD2RHV900I=CDeADE52@T92@T8R8R94A4@2L71`00Dg=cM2@T94A4A4A4B<S8`00WAdM0067AdM
JVYZ30`<30`<BDU9:RXZ0VYZJP06?clo@T92AdM7AdM7bLW9=SHf0UeMG@05H61PHV9RIFEUIFEUUIFE
0098B4P01STi>FQXJ8V9RHV9RGUiNBLW9`8;2`/01R<S8cLg=cTi>CTi>BTY:AdM7@:XZ:P01Q/K6b4Q
8D=3@d=3@c@d=4Y:BP8b<S801FATI4E5ADE5AE=CDb8R8P0230`<00HS8b=OGelk>c/k>c^EUIDj>SX2
M7Ad00Hh>3P/;2`O7alO7amBDU9WIfL2ADE500EbLW95ADE5ADEIFETa<C400S0`<006>3Ph:2PX>c/k
>c/k;bl_?clo0TI6AP06I6ATFUYJ=CDe=CDeBTY:9BDU0RXZ:P05Bd];?3`lGUiNGUiN6ATI009?Cdl0
1R`/;4i>CV9RHV9RHUADE6e]K@:@T9001D=3@oooooooooooo`00000^oooo00@0003ooooooon;Rh/2
E5AD00FCTi=HF5RUYJFUYJD/;2`00PL71`06Ti>CBd];8B4Q8B4QBTY:IFEU0UEEE@06IfMW61PH=cLg
=cLgF5QHTI6A0S/k>`05M7AdATI6ATI6IFEUBd];009eMGD01XV9RG9bLR`/;2`/;55ADHf=S@9LG5`0
1DM7AaLG5aLG5e5ADCdm?@026a/K00IiNGUYJFU@D51@D50_;blg=cL2@D5100EPH61<C4`k>c/k>c]=
CDd00XV9R@06MgMg51@DIFEUIFEU61PHH61P0RTY:@06M7AdFUYJ9bLW9bLWF5QH];Bd0S0`<005H61P
Fe]KFe]KL71`FEUI00:QXJ401Ta<C2`/;5QHF5QHF861PHj>SP8_;bl01AhN7STi>CTi>D10@2PX:002
6QXJ00HC4a>i^KTW9bLW9bLd=3@h>3P29bLW00Di>CTY:BU`L71`L70[:b/00VIVIP06:2PX30`<=SHf
=SHfKFe]AdM70Y2@T005?cloOGem:RXZ:RXZ6ATI008g=cL01UUIFF][Jc0`<30`<51@D6YZJP8l?3`0
1R@T94];Bbd];Bd];Bh^;Rd];@8U9BD01DE5AD92@T92@UmOGdi>CP02ATI600I9BDTj>SXX:2PX:2QC
De=OGel2DE5A00D<30`a<C4L71`L71aSHf<00U5AD@05I6ATL71`Ti>CTi>C@D5100?oool00`000?oo
ooooo`0=oooo000Roooo00D0003ooooooooooomZJVX00WmoO`06;2`/Lg=cIVIVIVIVCDe=De=C0QHF
5P05JFUY9bLW9bLWJVYZCDe=008d=3@01V1PH492@TA4A4A4A59BDRXZ:P::RXX01T=3@dM7AeeMGEeM
GBHV9QHF5P:UYJD01G5aLEaLG2TY:BTY:CPh>0027alO00Hg=cLF5QHQ8B4Q8B4_;blZ:RX2Cdm?00IF
EUHG5aLQ8B4Q8B5BDU8];Bd2Lg=c00E1@D4M7AeIFEUIFEU2@T800YBDU006LW9b=cLg8b<S8b<SKVi^
>SXj0Q`L7006GemO410@@410@410JFUY71`L0U=CD`05?Cdm>CTi<30`<30`Bd];008P82001UEEEEeM
GA`L71`L78:2PT92@P8d=3@01R@T9451@DU9BDU9BCHf=U1@D09?Cdl01YRHV4i>CUeMGEeMGEiNGU1@
D09cLg<01Bh^;V=SHf=SHdI6ATA4A002EEEE00H/;2aFEUIFEUIFEUIjNWYBDU82B4Q800I7AdLN7Qh=
3@d=3@eFEUINGUh2?Shn00D[:b/71`L71`La<C4L71`00Pd=3@06IVIV51@Dd=3@d=3@/;2`Kfm_0T10
@006GemOEEEE4Q8B4Q8BHF5QC4a<0T51@@05L71`BTY:MGEeMGEeDE5A008820P01UYJFUEEEJNWYjNW
YfATI5UIF@98B4P01GMgMoooooooooooo`00000^oooo00@0003ooooooom^KVh2R8R800Db<S:0P81]
KFe]KFePH6000TI6AP05410@B4Q8Bd];Bd];IFEU00=3@d<01Ti>CRPX:4M7AdM7Ae]KFb4Q8@:ATI40
1DY:BUADE5ADE4a<C30`<0022@T900J:RXZ6QXIJFUYJFUXA4A5@D502;2`/00DS8b<92@T92@T_;bl^
;Rh00RXZ:P06Bd];GEeM6a/K6a/K;Rh^AdM70Shn?P05LG5aATI66a/K6a/KJVYZ008h>3P01XV9RGmo
Oclo?clo?b0P87=cL`8l?3`01QTI6EeMG@d=3@d=3D10@6=SH`8F5QH01DQ8B4Y:BTY:BTM7Ab4Q8@02
Fe]K00H^;Ri6ATIKFe]KFe/V9RJ;Rh/2>CTi00Dl?3`V9RHV9RHo?cm7AdL00S<c<`04DU9BFEUIYJFU
YJFU0Ti>CP9TI6@01D=3@fQXJ2`/;2`/;5UIF@03CDe=00EADE4b<S8b<S9MGEeKFe/00WIfMP05EUIF
CDe=@d=3@d=371`L008B4Q801UEEEFYZJRd];Bd];CTi>A/K6`8Y:BT01S4a<@d=3EiNGUiNGRLW9kjn
_P:c/k<01G]kNcDe=CDe=F][JeEEE@022PX:00ITI6A4A4@n?Shn?Sj3Ph=9BDT2GUiN00E`L70X:2Q@
D51@D51`L7000XZ:RP05M7AdKfm_EeMGEeMGOgmo00?oool00`000?ooooooo`0=oooo000Roooo00D0
003ooooooooooonKVi/00_KfmP06RXZ:^k^k9RHV9RHVQXJ6KFe]0WmoO`05=CDe>3Ph>3PhH61PFe]K
009JFUX01P/;2e5ADEeMGEeMGBh^;QdM7@9ZJVX00k6a/H>3PeADE002E5AD00E4A4@O7alO7am;Bd/7
1`L00P`<3005DE5A=SHf=SHf>SXjJf][009NGUh01Rd];AlO7c<c<c<c<clo?d];B`8T92@01RDU9EYJ
FQ@D51@D58>3Phb<S0:OWil01G5aLF1PH61PH5IFESdm?@02@D5100HW9bMIFEUIFEUIFEUXJ6P`<302
6ATI00I@D525QHEIFEUIFETo?cmIFET2<c<c00D_;bm5ADE5ADDf=SHj>SX00R4Q8@06HF5Q3`l?C4a<
C4a<?CdmZJVY0Q`L7006GemOB4Q8GEeMGEeMC4a<;2`/0U1@D0052@T9?ShnHV9RHV9R?Cdm00:HV9P0
1UMGEa8B4S4a<C4a<GalO24Q8@:b/[801TY:BUMGEadM7AdM7Fi^KXB4Q09BDU801Dm?Cfe]KB<S8b<S
8fATI002=cLg00@Q8B6CTi=HF5QHF5P2K6a/0X>3P`06Bd];DE5A6ATI6ATILG5aS8b<0XZ:RP06FEUI
ZZZZ/;2`/;2`>3PhJVYZ0Y2@T005Hf=S:BTY:BTYBTY:1PH6009^KVh01E1@D9jNWW5aLG5aLGIfMP03
oooo00<0003oooooool0;?ooo`040000ooooooooTY:B0^WYj@05UiNG/[:b:b/[:b/[R8R8009]KFd0
1WMgMb/[:cHf=SHf=T];Bg1`L094A4@010/;2chn?Vm_Kfm_K`8Y:BT2HV9R00Fn_[j6QXJ6QXILG5aC
De<00S0`<0066QXJI6AT5ADE5ADE8B4QI6AT0RXZ:P05>3PhJ6QXJ6QXJVYZ:b/[008];Bd01TU9BBh^
;T51@D51@CLg=`/;2`9fMWH01Bl_;gYjNX>3Ph>3PibLW002Kfm_00ISHf=KFe]6ATI6ATI4A4@n?Sh2
I6AT00Hm?CePH60Z:RXZ:RX?3`mMGEd2TI6A00EQHF54A4A4A4AADE4d=3@00Rl_;`06BTY:=CDe;Rh^
;Rh^4Q8BGUiN0R@T9005DU9B>3Ph>3PhZZZZ;2`/009MGEd01UADE5YJFTU9BDU9BBPX:4m?C`861PH0
1D10@5]KFdU9BDU9BIRHV002CDe=00H=3@dM7AemOGemOGd`<32WYjL2EeMG00E>CThS8b=[Jf][Jf^9
RHT00Ti>CP06A4A4HV9R>3Ph>3PhGEeM=cLg0S0`<006Q8B4GemOKFe]KFe]L71`Rh^;0U5AD@05BTY:
6ATI6ATIOgmoRHV9009iNGT01V5QHJ^[ZjRXZ:RXZ3@d=7inOP:>SXh01EEEEC@d=4Q8B4Q8B0`<3002
H61P00ECDe>_[jmfMWIfMWJ:RXX00oooo`030000oooooooo00goool0017oool500000_ooo`030000
oooooooo00;oool00`000?ooooooo`02oooo00D0003ooooooooooom]KFd00/;2`P06[Zj^OWinJ6QX
J6QXRHV992@T0QlO7`05ATI6_[jn_[jnDU9BK6a/00:/[:`01QdM7CPh>4I6ATI6ASHf=UiNGP:QXJ40
1Zb/[3@d=8^;Rh^;Rg1`L2/[:`8X:2P01A@D53/k>bh^;Rh^;Ti>CP02>c/k00H20P9ADE6BTY:BTY8A
4A5nOWh2L71`00INGUhJ6QX?3`l?3`lZ:RXG5aL2ATI600EiNGURHV8=3@d=3@eFEUH00RHV9P06DE5A
IFEUKFe]KFe]CTi>Fe]K0PX:2P06ATI6=SHfDE5ADE5A20P85QHF0VIVIP0571`L8b<S92@T92@T=SHf
0098B4P01Rh^;TM7Aclo?clo?cTi>B/[:`9HF5P01Pl?3i6ATA/K6a/K6da<C2PX:08;2`/01S0`<38b
<W9bLW9bLUUIFDi>CP8G5aL01D92@UMGEeMGEd];Bfa/K002CTi>00I[Jf]3@d=0@410@424Q8@J6QX2
71`L00I?Cdm5ADEiNGUiNGTb<S:8R8P2F5QH00DY:BUVIVIVIVIKFe/Q8B400T92@P06NWYjD51@J6QX
J6QXJFUYCdm?0Y>CT`06J6QXE5AD;Rh^;Rh^^;RhSHf=0Te=C@05FUYJKfm_<30`<30`D51@009ZJVX0
1T92@QdM7CHf=SHf=Q`L72LW9`;=cLd01B8R8_ooooooooooo`00000Moooo1@0000;oool00`000?oo
ooooo`02oooo00<0003oooooool00_ooo`040000ooooooooOWin0[6a/@05`<30IFEULg=cLg=cM7Ad
008=3@d01R`/;55ADKVi^KVi^DY:BV9RHP:WYjL01QdM7Bl_;e9BDU9BDT92@Va/K0:QXJ401JZZZS<c
<c<c<hR8R6a/K002;Rh^00H_;blQ8B4o?clo?cld=3ADE5@2;Rh^00DC4a=JFUYJFUZCTi<;2`/00Win
OP06M7AdE5AD9RHV9RHV61PH>SXj0R@T9005BDU9G5aLATI6ATI67AdM009<C4`01SLg=eeMGEmOGemO
GfYZJTm?C`9@D5001Q`L730`<1dM7AdM7D92@QlO7`8P82001H61PBXZ:RXZ:QdM7APH6002?Shn00I4
A4@^;Ri2@T92@T8e=CE2@T828b<S00EWIfL;2`/;2`^=SHdF5QH00UmOG`06;2`/6QXJ>c/k>c/k=SHf
L71`0UaLG005EEEE8R8RB4Q8B4Q8Jf][008b<S801UIFES@d=5mOGemOGe9BDRh^;P9cLg<01AlO7b/[
:d51@D51@E1@D002LG5a00H];BedM7AXJ6QXJ6P;2`^:RXX2@d=300HA4A53@d=DE5ADE5AgMgMJFUX2
BTY:00EGEeNIVIVIVIUIFEU@D5000STi>@06[Zj^L71`HF5QHF5Q=3@dUYJF0S0`<005ATI6MgMg9bLW
9bLW1PH6008^;Rh01A/K6aLG5m_Kfm_KfaDE5@03oooo00<0003oooooool03Oooo`004oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`000003oooo00D0003ooooooooooom]KFd00/;2
`P06[Zj^OWinJ6QXJ6QXRHV992@T0QlO7`05ATI6_[jn_[jnDU9BK6a/00:/[:`01QdM7CPh>4I6ATI6
ASHf=UiNGP:QXJ401Zb/[3@d=8^;Rh^;Rg1`L2/[:`8X:2P01A@D53/k>bh^;Rh^;Ti>CP02>c/k00H2
0P9ADE6BTY:BTY8A4A5nOWh2L71`00INGUhJ6QX?3`l?3`lZ:RXG5aL2ATI600EiNGURHV8=3@d=3@eF
EUH00RHV9P06DE5AIFEUKFe]KFe]CTi>Fe]K0PX:2P06ATI6=SHfDE5ADE5A20P85QHF0VIVIP0571`L
8b<S92@T92@T=SHf0098B4P01Rh^;TM7Aclo?clo?cTi>B/[:`9HF5P01Pl?3i6ATA/K6a/K6da<C2PX
:08;2`/01S0`<38b<W9bLW9bLUUIFDi>CP8G5aL01D92@UMGEeMGEd];Bfa/K002CTi>00I[Jf]3@d=0
@410@424Q8@J6QX271`L00I?Cdm5ADEiNGUiNGTb<S:8R8P2F5QH00DY:BUVIVIVIVIKFe/Q8B400T92
@P06NWYjD51@J6QXJ6QXJFUYCdm?0Y>CT`06J6QXE5AD;Rh^;Rh^^;RhSHf=0Te=C@05FUYJKfm_<30`
<30`D51@009ZJVX01T92@QdM7CHf=SHf=Q`L72LW9`;=cLd01B8R8_ooooooooooo`00000Ooooo00L0
003oooooooooool0003oool000000_ooo`030000oooo000000?oool010000?oooooooginOP:a/K40
1L30`6EUIG=cLg=cLgAdM0023@d=00H/;2aADE6i^KVi^KU:BTYRHV82YjNW00HM7Ad_;bmBDU9BDU92
@T9/K6`2XJ6Q00FZZZXc<c<c<c>8R8Q/K6`00Rh^;P06;bl_8B4Q?clo?clo=3@dE5AD0Rh^;P054a<C
FUYJFUYJTi>C2`/;009nOWh01WAdM5ADE2HV9RHV9QPH63Xj>P8T92@01DU9BEaLG4I6ATI6AQdM7@02
C4a<00Hg=cMMGEeOGemOGemZJVY?Cdl2D51@00HL71``<30M7AdM7Ae2@T8O7al2820P00F1PH4Z:RXZ
:RXM7AdH61P00Shn?P06A4A4;Rh^@T92@T92=CDe@T920R<S8`05IfMW2`/;2`/;SHf=5QHF009OGel0
1R`/;1XJ6S/k>c/k>cHf=W1`L09LG5`01EEEEB8R8TQ8B4Q8B6][J`02<S8b00IFEUHd=3AOGemOGemB
DU8^;Rh2Lg=c00DO7al[:b]1@D51@D5@D5000W5aL@06;Bd]M7AdJ6QXJ6QX2`/;RXZ:0T=3@`064A4A
@d=3E5ADE5ADMgMgFUYJ0TY:BP05EeMGVIVIVIVIFEUID51@008i>CT01Zj^[W1`L65QHF5QHC@d=9JF
UP8`<3001DI6AWMgMbLW9bLW9`H61P02;Rh^00DK6a/G5aOKfm_Kfm/E5AD00oooo`030000oooooooo
00goool001?oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`800005
oooo00IDE5@i>CV0P820P81?CdnNWYh2410@00E6ATJEUIFEUIDG5aLl?3`00[Rh^006KFe]UIFEB4Q8
B4Q8EEEE6ATI0WMgM`06CDe=DE5A9bLW9bLW4a<C6a/K0Q@D50057AdM>c/k:RXZ:RXZ<S8b008I6AT0
1T10@6i^KS/k>c/k>eeMGEaLG098B4P01QDE5BLW9eiNGUiNGSDe=DE5A@9DE5@01DU9BEADE3`l?3`l
?3De=@02<c<c00@Q8B4H61Q<C4a<C4`2GUiN0P<30`06BTY:2PX:K6a/K6a/<30`E5AD0TI6AP05=3@d
4A4A5QHF5QHF4A4A009>CTh014m?Cbl_;c0`<30`<09KFe/2EeMG00H];BeTI6A^KVi^KVhd=3@T92@2
=cLg00JCTi=MGEf2PX:2PX:VYZIZJVX27QhN00E0@41eMGEeMGESHf=@D5000RXZ:P06QhN7:BTY51@D
51@D=SHfPH610XZ:RP06;Bd]Kfm_JFUYJFUYR8R8=SHf0QlO7`05:BTYJ6QXJ6QX7AdMFUYJ009NGUh0
1VQXJ6=SHhf=SHf=SI>CTd];B`9EEED01WEeMBHV9UIFEUIFEUADE55AD@8L71`01AlO7`/;2da<C4a<
C1<C4`02AdM700Hg=cMXJ6Q[Jf][Jf]YJFTV9RH2Cdm?00=LG5coooooool00P0001ooool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000000oooo`800004oooo00EJFUY<C4aTI6ATI6AF
EUH00WinOP0661PHIfMWPX:2PX:23`l?B4Q80Zj^[P06O7alRXZ:B4Q8B4Q8H61P8b<S0WQhN005FEUI
AdM7AdM730`<4Q8B008<30`01PL71`H61T51@D51@BHV9R/[:`8O7al01Clo?g9bLW9bLT=3@eMGE`02
DE5A00I1@D4N7Qhc<c<c<c=@D50e=CD2>SXj00EOGem8B4QLG5aLG5a0@4000Rl_;`05=cLg9bLW4a<C
4a<CCTi>00=MGEd01P@414I6APT92@T92FEUIC<c<`99BDT01DM7Achn?Shn?QdM7B<S8`024Q8B00I8
B4QIFETS8b<S8b<R8R9XJ6P2EEEE00ETI6@Q8B4Q8B5JFUY]KFd00SXj>P06;Bd]:b/[UiNGUiNGKfm_
MWIf0Z:RXP05KVi^;Rh^ATI6ATI6M7Ad009OGel01TU9BBDU9HB4Q8B4Q30`<1/K6`8Z:RX01INGUh61
PCXj>SXj>XB4Q002De=C00J5QHE1@D4N7QhN7Qh^;RiVIVH29RHV00IVIVIEEEEADE5ADE5nOWi/K6`2
L71`00EQHF5CDe=CDe=KFe/K6a/00V][J`06B4Q8C4a<51@D51@D410@30`<0T51@@05:BTYKVi^410@
410@B4Q8009EEED01E=CDchn?V=SHf=SHe5AD@02oooo0P0000ooool001?oool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000000oooo`050000oooooooooooom_Kf00;oool01WIfMXZ:
RU1@D51@D6=SH`/;2`9HF5P01AlO7de=CDe=CKjn_Slo?`02<S8b00IZJVXn?Sh<30`<30`h>3Pl?3`2
>3Ph00HS8b<m?Ce0@410@41_KflN7Qh26QXJ00Dj>SY5ADEnOWinOWhZ:RX00STi>@06QhN78B4QJFUY
JFUY8R8RLG5a0XB4Q006Kfm_LG5a>SXj>SXjG5aLGEeM0QlO7`058R8R:BTY5aLG5aLGI6AT009nOWh0
1Ve]KEMGEgalO7alO51@D4e=C@8`<3001WUiNA<C4e]KFe]KFfATI7moO`8D51@01CTi>APH62/[:b/[
:b4Q8@02LW9b00HR8R8U9BE_Kfm_Kfl<30`D51@27alO00H];BejNWYMGEeMGEeOGem[Jf/2=cLg00HF
5QIIFEUZJVYZJVYbLW98B4P2>c/k00DV9RHk>c/k>c/];Bdf=SH00SPh>006ADE5EeMG92@T92@TNWYj
9BDU0RPX:006Ng]kHf=SSXj>SXj>IfMWKVi^0UIFEP053`l?C4a<C4a<K6a/B4Q800:0P8001T51@DI6
AWalO7alO1XJ6QTI6@95ADD01W5aLEeMGD=3@d=3@d92@Sdm?@9IFET01E1@D8N7QhJ6QXJ6QTY:BP02
HV9R00Hi>CUgMgLV9RHV9RI@D51^KVh2<C4a00E/K6coooooooooool000007oooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000003oooo00@0003oooooooogmoL2oooo00F4Q8BATI55
ADE5ADE9BDT00Q<C4`06>3Ph9BDU@410@410_knoBTY:0RXZ:P06L71`<C4a410@410@<c<c@4100SXj
>P05=CDe;Rh^;Rh^EUIFCDe=008H61P01STi>E9BDV=SHf=SHfEUIChn?P8Z:RX01H^;RalO7alO7f][
Jb<S8`02J6QX00B>SXiXJ6QTI6ATI6@2D51@0UmOG`05<c<c>CTi61PH61PH7AdM009@D5001WmoOeeM
GEiNGUiNGXV9RDI6AP99BDT01S<c<gIfMQ<C4a<C4eUIFF1PH09mOGd01APH63De=CDe=Bd];C`l?002
=cLg00IPH60i>CTd=3@d=3AFEUHX:2P2;Bd]00Dd=3@o?clo?cn5QHEGEeL00V5QH@06IVIV<30`71`L
71`LFe]KEeMG0Va/K005GEeMBd];7AdM7AdM@d=3008f=SH01TY:BSDe=EEEEEEEEFYZJRXZ:P9cLg<2
?Shn0YZJVP05HV9ROWinOWinPh>3D51@009]KFd01PX:2T=3@f][Jf][Jc`l?8f=S@9>CTh01EmOGf9R
HP@410@4138b<P02=3@d00IGEeM4A4AHF5QHF5Q@D515ADD2Fe]K00IBDU9mOGf:RXZ:RXYIFEUhN7P2
92@T00EKFe/>3Ph>3Phd=3B5QHD00R4Q8@05Hf=Soooooooooooo000000ooool001?oool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000000oooo`050000oooooooooooom_Kf00;oool0
1WIfMXZ:RU1@D51@D6=SH`/;2`9HF5P01AlO7de=CDe=CKjn_Slo?`02<S8b00IZJVXn?Sh<30`<30`h
>3Pl?3`2>3Ph00HS8b<m?Ce0@410@41_KflN7Qh26QXJ00Dj>SY5ADEnOWinOWhZ:RX00STi>@06QhN7
8B4QJFUYJFUY8R8RLG5a0XB4Q006Kfm_LG5a>SXj>SXjG5aLGEeM0QlO7`058R8R:BTY5aLG5aLGI6AT
009nOWh01Ve]KEMGEgalO7alO51@D4e=C@8`<3001WUiNA<C4e]KFe]KFfATI7moO`8D51@01CTi>APH
62/[:b/[:b4Q8@02LW9b00HR8R8U9BE_Kfm_Kfl<30`D51@27alO00H];BejNWYMGEeMGEeOGem[Jf/2
=cLg00HF5QIIFEUZJVYZJVYbLW98B4P2>c/k00DV9RHk>c/k>c/];Bdf=SH00SPh>006ADE5EeMG92@T
92@TNWYj9BDU0RPX:006Ng]kHf=SSXj>SXj>IfMWKVi^0UIFEP053`l?C4a<C4a<K6a/B4Q800:0P800
1T51@DI6AWalO7alO1XJ6QTI6@95ADD01W5aLEeMGD=3@d=3@d92@Sdm?@9IFET01E1@D8N7QhJ6QXJ6
QTY:BP02HV9R00Hi>CUgMgLV9RHV9RI@D51^KVh2<C4a00E/K6coooooooooool000007oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`000003oooo00@0003oooooooogmoL2oooo00F4
Q8BATI55ADE5ADE9BDT00Q<C4`06>3Ph9BDU@410@410_knoBTY:0RXZ:P06L71`<C4a410@410@<c<c
@4100SXj>P05=CDe;Rh^;Rh^EUIFCDe=008H61P01STi>E9BDV=SHf=SHfEUIChn?P8Z:RX01H^;RalO
7alO7f][Jb<S8`02J6QX00B>SXiXJ6QTI6ATI6@2D51@0UmOG`05<c<c>CTi61PH61PH7AdM009@D500
1WmoOeeMGEiNGUiNGXV9RDI6AP99BDT01S<c<gIfMQ<C4a<C4eUIFF1PH09mOGd01APH63De=CDe=Bd]
;C`l?002=cLg00IPH60i>CTd=3@d=3AFEUHX:2P2;Bd]00Dd=3@o?clo?cn5QHEGEeL00V5QH@06IVIV
<30`71`L71`LFe]KEeMG0Va/K005GEeMBd];7AdM7AdM@d=3008f=SH01TY:BSDe=EEEEEEEEFYZJRXZ
:P9cLg<2?Shn0YZJVP05HV9ROWinOWinPh>3D51@009]KFd01PX:2T=3@f][Jf][Jc`l?8f=S@9>CTh0
1EmOGf9RHP@410@4138b<P02=3@d00IGEeM4A4AHF5QHF5Q@D515ADD2Fe]K00IBDU9mOGf:RXZ:RXYI
FEUhN7P292@T00EKFe/>3Ph>3Phd=3B5QHD00R4Q8@05Hf=Soooooooooooo000000ooool001;oool2
00001?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool01?ooo`066QXJ
];BdUiNGUiNG>SXj3@d=0R@T9005EeMGAdM7AdM7MGEe0P82009[Jf/01WIfMVATI8^;Rh^;Rbl_;bHV
9P8Q8B401P/;2e1@D3lo?clo?fUYJC@d=08J6QX01F][Jc0`<38b<S8b<V5QH@02LG5a00IeMGE;Bd]R
HV9RHV90@40g=cL2SHf=00ITI6A[Jf/c<c<c<c=9BDTS8b<2D51@00Dj>SXR8R99BDU9BDUBDU800YBD
U006<30`KFe]T92@T92@Bd];2`/;0RTY:@06?3`lL71`=CDe=CDeTI6A5aLG0RXZ:P05?3`l9RHVM7Ad
M7Ad4a<C008j>SX01Vm_Kg=cLj2PX:2PX6IVIXZ:RP:9RHT01VIVIRDU9DM7AdM7AcTi>B`/;08X:2P2
;2`/0R0P80055QHF;Bd]9BDU9BDU>SXj009@D5001S/k>bLW9bDU9BDU9DE5ADm?C`8>3Ph01WmoObh^
;TU9BDU9BEADE3/k>`8@41001Di>CRXZ:QLG5aLG5hV9R@02l_;b00J0P817AdMVIVIVIVIRHV8^;Rh2
K6a/00IZJVYCDe<Y:BTY:BU8B4Q;Bd/26ATI00H[:b/_;bnSXj>SXj==CDdl?3`2OWin00EmOGf][Jf]
[JeFEUHV9RH00SDe=@05:2PXQ8B41@D51@D5/K6a00?oool00`000?ooooooo`0Loooo0P0000Coool0
0`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo00?oool01AhN7/S8b8R8R8R8
R51@D0029BDU00I2@T9BDU8/;2`/;2aKFe/D51@2KFe]00IdM7A/K6b2PX:2PX8a<C4h>3P2410@00DT
92A@D51@D50S8b=cLg<00RDU9@06<c<cKfm_?3`l?3`l:RXZGUiN0W=cL`05KFe]EeMGEeMGIfMWA4A4
009:BTX01X61PE=CDgAdM7AdM3Xj>Ti>CP8[:b/01E1@D410@1TI6ATI6EEEE@02EUIF00JOWilj>SYX
J6QXJ6R<S8a7AdL22`/;00HX:2Pm?CehN7QhN7PX:2RATI429RHV00DX:2PT92@T92@>3Pj8R8P00PH6
1P06ADE5J6QXMGEeMGEeW9bLIVIV0X61P@05V9RHDe=CDe=C>c/k@T92008P82001Q<C4bl_;dU9BDU9
BA0@418B4P8?3`l01DE5AA/K6bh^;Rh^;UeMG@02CTi>00HD51@N7Qi?Cdm?CdmMGEdK6a/2N7Qh00DJ
6QYHF5QYJFUYJFTY:BT00QlO7`06@T92?Shn6ATI6ATISXj>mOGe0WUiN@06AdM7IVIVGemOGemO=CDe
JVYZ0W5aL@05G5aL=CDe=CDe>c/k@T92008N7Qh01S@d=3Ph>:VYZJVYZD92@Te=C@9[Jf/01FMWIk>c
/dE5ADE5ACTi>@02BDU900DL71b6QXH=3@d=3@fc/k<00oooo`030000oooooooo00goool002;oool0
0`000?ooooooo`02oooo0Zn_[`06GEeMJ6QXU9BDU9BDIVIVFe]K0R8R8P05>CTiSHf=SHf=7alOMWIf
009kNg/01X20P59BDTU9BDU9BGEeM@T92@97AdL01WmoOc0`<4M7AdM7AeeMGGQhN08o?cl01DA4A1LG
5eiNGUiNGQDE5@02<c<c00I5ADE@D51ZJVYZJVY;Bd]=CDd2@d=300I^KVj=SHdk>c/k>c/_;blY:BT2
@T9200EYJFT@4111@D51@D4d=3@00Shn?P06=3@dHf=SG5aLG5aLJFUY_;bl0WQhN006Fe]KEeMG9bLW
9bLWNWYjBTY:0U1@D005QXJ6;bl_7AdM7AdM>3Ph009lO7`01TI6AR0P84Y:BTY:BVm_KaHF5P8e=CD0
1QdM7DM7AdQ8B4Q8B5IFEW1`L08`<3001X:2PTU9BBLW9bLW9c`l?3Xj>P9cLg<01E1@D8>3Ph>3P`h>
3QXJ6P02<C4a00HJ6QXc<c=NGUiNGUi^KVihN7P25ADE00Hf=SHL71`M7AdM7Ad^;Ri:BTX2>c/k00Dm
?CeQHF5QHF6LW9amOGd00RHV9P06HF5QFUYJ6a/K6a/K8R8RIfMW0UMGE`06UiNG9bLWEUIFEUIF:BTY
<30`0WEeM@053@d=Xj>S8b<S8b<SC4a<00;?cll01S8b<T=3@aLG5aLG5bXZ:]WIf@9mOGd01G=cLooo
ooooooooo`00000^oooo00@0003oooooooooool2/;2`00E^KVihN7RLW9bLW9aJFUX00TY:BP06;Rh^
6QXJK6a/K6a/C4a<NGUi0X20P006U9BD@d=3@T92@T92Lg=c3`l?0UiNGP05JFUY3`l?3`l?BTY:Q8B4
00:NWYh01U5ADBDU9BPX:2PX:59BDQdM7@8h>3P01E9BDT=3@d=3@h61PEEEE@02?3`l00IGEeMEEEFH
V9RHV9Q=CDdj>SX2:RXZ00E0@41]KFdH61PH61Q4A4@00SLg=`06F5QHD51@EUIFEUIFADE5HV9R0Z^[
Z`06PX:2JVYZFe]KFe]K5ADEIVIV0V1PH005>3PhKFe]KFe]ATI64a<C008d=3@01X:2PSXj>Q<C4a<C
4d51@GQhN08820P01DE5AA4A4A4A4D51@B`/;002@d=300IJFUXY:BVGUiNGUiLo?cl`<302?Cdm00Dh
>3QgMgMIFEUIFEUnOWh00QdM7@0692@T8B4Q4A4A4A4A=cLgCdm?0WemO@05K6a/7alO:b/[:b/[:RXZ
008@41001R<S8eEEEC0`<30`<3dm?FIVIP:IVIT01X61PAhN7U=CDe=CDfe]KC8b<P8^;Rh01GUiNFe]
KFe]KHR8R3/k>`02ADE500He=CD^;RigMgMgMgLM7Af?Shl28B4Q00DZ:RZXZ:QIFEUIFETW9bL00Q<C
4`05=SHf`L71TI6ATI6AMWIf00?oool00`000?ooooooo`0=oooo000Roooo00<0003oooooool00_oo
o`;7alL01X>3Pc<c<mGEeMGEeGUiNG9bLP9>CTh01IbLW7emOGemOFYZJUiNGP02Ogmo00HS8b<b<S9U
IFEUIFEfMWHg=cL26QXJ00IADE5PH60b<S8b<S:UYJERHV82N7Qh00FEUIDf=SIADE5ADE5PH6000W=c
L`06De=CBd];Ph>3Ph>3=SHf:2PX0WmoO`062PX:=CDeGEeMGEeMC4a<5QHF0XV9R@05@D51BDU9DU9B
DU9B?clo009CDe<01S@d=2PX:3`l?3`l?92@T6MWI`8e=CD01Shn?[Zj^U=CDe=CDbHV9S0`<09GEeL0
1CPh>3`l?0H61PH61T];B`02N7Qh00HH61Ph>3RVYZJVYZHe=CE9BDT2D51@00HQ8B5HF5Q3@d=3@d=l
O7a>CTh2FEUI00HP820T92@j>SXj>SYJFUX`<302KFe]00EaLG4];Bd];BeKFe/71`L00R<S8`06>CTi
:BTYBTY:BTY:GUiN8B4Q0R<S8`06Cdm?6QXJ7AdM7AdM20P830`<0RDU9@05?cloCTi>CTi>5ADE3`l?
0098B4P01Rd];B8R8W5aLG5aLEMGEh>3P`94A4@01XR8R6e]KEYJFUYJFTe=CD];B`9lO7`01BDU9InO
WdU9BDU9BB`/;002RXZ:00IHF5PE5AD_;bl_;bmSHf=ADE42VIVI00G[jn_oooooooooool00000;_oo
o`040000oooooooooooo0/W9b@05Z:RXEeMGm?Cdm?CdVi^K00<k>c/01KBd]4i>CTi>CTi>CUeMG@02
MGEe00H[:b/a<C5`L71`L71RHV8S8b<26QXJ00D];Bd_;bl_;bm4A4B4Q8@00X^;R`06XJ6QNWYjC4a<
C4a<@410De=C0WYjNP05De=CCdm?Cdm?MgMg>SXj008K6a/019JFUP`<33dm?Cdm?@9PH6027alO00Ei
NGU3@d=5ADE5ADE?Cdl00T92@P06EEEE<S8b;2`/;2`/?cloQhN70U]KF`06@410DE5A]KFe]KFeGemO
<S8b0R0P8005IFEU>SXj>SXj<C4a10@4009BDU801W1`L1hN7TI6ATI6AZ:RXQlO7`9IFET01Fm_Kb`/
;2`/;6EUIB/[:`02KVi^00IDE5ANGUh`<30`<30];Bde=CD2DE5A00Dj>SZ0P81gMgMgMgLU9BD00VIV
IP065QHF=SHfB4Q8B4Q851@D@D510V9RHP056QXJ92@TAdM7AdM76ATI008X:2P01P`<30H61STi>CTi
>BXZ:UmOG`8/;2`01QPH65YJFSLg=cLg=b0P87alO09BDU801H61PDE5ADE5AHn?Sg=cL`02AdM700IL
G5a4A4B4Q8B4Q8@:2PYeMGD271`L00DD51B<S8`b<S8b<S8e=CD00T=3@`05HV9REeMGWinOWinOfm_K
00?oool00`000?ooooooo`0=oooo000Roooo00<0003oooooool00_ooo`;7alL01X>3Pc<c<mGEeMGE
eGUiNG9bLP9>CTh01IbLW7emOGemOFYZJUiNGP02Ogmo00HS8b<b<S9UIFEUIFEfMWHg=cL26QXJ00IA
DE5PH60b<S8b<S:UYJERHV82N7Qh00FEUIDf=SIADE5ADE5PH6000W=cL`06De=CBd];Ph>3Ph>3=SHf
:2PX0WmoO`062PX:=CDeGEeMGEeMC4a<5QHF0XV9R@05@D51BDU9DU9BDU9B?clo009CDe<01S@d=2PX
:3`l?3`l?92@T6MWI`8e=CD01Shn?[Zj^U=CDe=CDbHV9S0`<09GEeL01CPh>3`l?0H61PH61T];B`02
N7Qh00HH61Ph>3RVYZJVYZHe=CE9BDT2D51@00HQ8B5HF5Q3@d=3@d=lO7a>CTh2FEUI00HP820T92@j
>SXj>SYJFUX`<302KFe]00EaLG4];Bd];BeKFe/71`L00R<S8`06>CTi:BTYBTY:BTY:GUiN8B4Q0R<S
8`06Cdm?6QXJ7AdM7AdM20P830`<0RDU9@05?cloCTi>CTi>5ADE3`l?0098B4P01Rd];B8R8W5aLG5a
LEMGEh>3P`94A4@01XR8R6e]KEYJFUYJFTe=CD];B`9lO7`01BDU9InOWdU9BDU9BB`/;002RXZ:00IH
F5PE5AD_;bl_;bmSHf=ADE42VIVI00G[jn_oooooooooool00000;_ooo`040000oooooooooooo0/W9
b@05Z:RXEeMGm?Cdm?CdVi^K00<k>c/01KBd]4i>CTi>CTi>CUeMG@02MGEe00H[:b/a<C5`L71`L71R
HV8S8b<26QXJ00D];Bd_;bl_;bm4A4B4Q8@00X^;R`06XJ6QNWYjC4a<C4a<@410De=C0WYjNP05De=C
Cdm?Cdm?MgMg>SXj008K6a/019JFUP`<33dm?Cdm?@9PH6027alO00EiNGU3@d=5ADE5ADE?Cdl00T92
@P06EEEE<S8b;2`/;2`/?cloQhN70U]KF`06@410DE5A]KFe]KFeGemO<S8b0R0P8005IFEU>SXj>SXj
<C4a10@4009BDU801W1`L1hN7TI6ATI6AZ:RXQlO7`9IFET01Fm_Kb`/;2`/;6EUIB/[:`02KVi^00ID
E5ANGUh`<30`<30];Bde=CD2DE5A00Dj>SZ0P81gMgMgMgLU9BD00VIVIP065QHF=SHfB4Q8B4Q851@D
@D510V9RHP056QXJ92@TAdM7AdM76ATI008X:2P01P`<30H61STi>CTi>BXZ:UmOG`8/;2`01QPH65YJ
FSLg=cLg=b0P87alO09BDU801H61PDE5ADE5AHn?Sg=cL`02AdM700ILG5a4A4B4Q8B4Q8@:2PYeMGD2
71`L00DD51B<S8`b<S8b<S8e=CD00T=3@`05HV9REeMGWinOWinOfm_K00?oool00`000?ooooooo`0=
oooo000Roooo0P0000;oool01GmoOkfm_Kfm_GEeM@T92@02R8R800DR8R:?Shm9BDU9BDU4A4@00[jn
_P06=CDemoOg:2PX:2PXPh>3Ti>C0R0P8006:b/[=3@d@D51@D51GUiN@T920S0`<006FUYJEeMG@T92
@T92N7Qh;2`/0XR8R0056ATI<S8b<S8bUIFE9BDU008C4a<01U9BDTE5AHJ6QXJ6QUiNGTU9B@:0P800
1U=CDc@d=451@D51@@X:2Q/K6`9[Jf/01C0`<1PH61PH60<30hN7Q`02K6a/00IbLW:BTY;5aLG5aLEC
De<[:b/2>c/k00I5ADERHV8>3Ph>3PiWIfMfMWH2QhN700D`<30n?Shn?Shh>3P30`<00S@d=006<S8b
?cloTi>CTi>CH61PJFUY0QDE5@064a<C7QhNFEUIFEUIL71`<C4a0STi>@05LW9b@d=3>3Ph>3PhTi>C
009EEED01T];BaTI6FEUIFEUIA`L72TY:@8g=cL01T];Be=CDbLW9bLW9fMWIa/K6`97AdL01D51@AhN
7Rl_;bl_;clo?`02>CTi00H@410I6AU3@d=3@d<b<S92@T82WIfM00Hg=cM6ATIEEEEEEEDd=3AXJ6P2
SHf=00Hf=SI8B4QVIVIVIVHm?CedM7@2:2PX00FFUYJj^[Zj^[Z?ShlU9BD00X^;R`05?Cdm=SHfAdM7
AdM7Ogmo00;oool20000;_ooo`8000001_oooiRHV=_Kfm_KfhF5QCLg=`:MWId01EQHF59BDU9BDW9b
LS0`<002d=3@00IJFU[Cdm=0@410@41aLG6SXj<28R8R00Dj>SXO7am:BTY:BTYGEeL00S0`<0068R8R
>CTiDe=CDe=C?cloQ8B40Q4A4@05Lg=c3Ph>=3@d=3@dT92@008K6a/01QHF5S`l?69RHV9RHWemODQ8
B08^;Rh01YVIVChn?TQ8B4Q8B30`<1PH608I6AT01FYZJT51@D51@A<C4a/K6`02LW9b00IcLg=YJFVS
Xj>SXj>n_[iEEED2:2PX00Di>CU:BTYADE5ADE4U9BD00Ve]K@06HF5QY:BT9RHV9RHVDU9B92@T0QPH
60058R8R=CDe>CTi>CTiVi^K009QHF401VATI1dM7@/;2`/;2bXZ:U9BDP:1PH401T92@T10@6ATI6AT
I4i>CTE5A@:=SHd01De=CEUIFEUIFBLW9fMWI`025ADE00HS8b<Z:RY?Cdm?CdmLG5`_;bl2J6QX00DW
9bMBDU9BDU8g=cLE5AD00R4Q8@06ADE58B4Q;2`/;2`/<C4aEUIF0TY:BP05EEEE[Zj^7alO7alO8b<S
0092@T801R`/;75aLIbLW9bLW4];BdM7A`9hN7P01Te=CD=3@eiNGUiNGUmOGoCdm09HF5P01EMGEj>S
Xj>SXcHf=S`l?002Bd];00>HV9Soooooool00P0000ooool002;oool00`000?ooooooo`02oooo0XF5
Q@06GUiNK6a/HV9RHV9RKFe]GEeM0YnOW`05BTY:IVIVIVIVKVi^A4A4008e=CD01RHV9S<c<b`/;2`/
;5QHF3`l?090@4001Rl_;bDU9ATI6ATI6Fe]KE9BDP91@D401ATI6EUIFF=SHf=SHgIfMP02IfMW00IE
EEETI6AGEeMGEeLH61P=3@d2=SHf00Hh>3QVIVJBTY:BTY9BDU:QXJ42DE5A00F8R8Pk>c^OWinOWim5
ADD00RHV9P068b<SDe=C9bLW9bLW7AdMBd];0T51@@06?Shn;bl_ATI6ATI6?CdmG5aL0V1PH005EEEE
=cLgE5ADE5ADFEUI009=CDd01Slo?hf=SFUYJFUYJFi^KS@d=08R8R801Pl?3gQhN3`l?3`l?2PX:0d=
3@9TI6@01T=3@f][JdI6ATI6ATQ8B4m?C`99BDT01F=SHeiNGUiNGS0`<6EUI@028R8R00Ha<C4i>CTf
=SHf=SI9BDV_[jl23Ph>00Ha<C4`<30C4a<C4a=VIVJ@T902820P00Di>CUNGUiNGUj0P81DE5@00Ti>
CP065ADEOWinXJ6QXJ6QZ:RXH61P0Ti>CP06UIFE:b/[RHV9RHV9?clo9RHV0PH61P05C4a<<c<cD51@
D51@820P008l?3`00gAdM7alO3@d=002=3@d00>6QXKalO7alO401?ooo`030000oooooooo02coool0
10000?ooooooooooo`:DU9@01F][JfUYJF5QHF5QHEUIF@02FUYJ00F9RHUNGUj3Ph>3Ph=/K6`00c<c
<`06<C4a@T92<c<c<c<cGEeM?3`l0Sdm?@05:BTY=3@d=3@d:RXZNGUi009?Cdl01R/[:a0@45aLG5aL
G5ADE6IVIP9`L7001EmOGfATI6ATI5YJFR8R8P020P8200Hl?3`[:b]IFEUIFEVRXZ94A4@2VYZJ00EC
De>=SHd`<30`<32YZJT00T92@P06:BTY71`L@d=3@d=3<30`3Ph>0TI6AP06?3`lBd];;bl_;bl_>c/k
<C4a0VQXJ005Fe]KBDU9BDU9?3`lBDU9009VIVH01U]KFcPh>8Z:RXZ:RW1`L65QH@90@4001B0P81HF
5QHF5WinOS<c<`028b<S00HB4Q9OGem6ATI6ATI`L70o?cl2A4A400EKFe]GEeMBDU9BDU9[Jf/00R/[
:`06De=C4Q8B8b<S8b<S@d=3@4100TQ8B005];Bd10@4>SXj>SXj<S8b008G5aL01UMGEhZ:RPh>3Ph>
3R<S8g=cL`9[Jf/01VEUIE5ADATI6ATI6IFEUIjNWP;0`<001DY:BV5QHF5QHGemOD=3@`02WYjN00I0
@40M7AdL71`L71a3@d<_;bl2GEeM00DK6a]9BDV5QHF5QHE`L7000TQ8B004<30`OGemlO7alO7a1?oo
o`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0YFEU@06LW9b@d=3UYJFUYJFATI6
N7Qh0UMGE`057alOG5aLG5aLQHF5U9BD00:4Q8@01P`<318B4S4a<C4a<G=cLdQ8B08U9BD01T];Ba@D
5;Bd];Bd]8F5QDI6AP9RHV801@`<338b<TQ8B4Q8B0/;2`02@41000HR8R9DE5ABDU9BDU:2PX:3Ph<2
YZJV00I3@d<E5ADe=CDe=CEPH61<C4`2Q8B400EPH60c<c==CDe=CDdX:2P00V1PH006De=C>CTi<S8b
<S8bB4Q88b<S0V=SH`06<C4a=SHfKFe]KFe];2`/?Cdm0Zn_[`05O7alE5AD:b/[:b/[?Cdm008I6AT0
1S@d=3hn?Slo?clo?aPH634a<@9bLW801UEEEF][Ja/K6a/K6eiNGR`/;09MGEd01Rh^;RHV9Va/K6a/
K5QHF8Z:RP8J6QX01E1@D5EEEEEEEBDU9EeMG@02<c<c00H<30`n?Si6ATI6ATHn?Shm?Cd2F5QH00Ie
MGEJFUXM7AdM7AeKFe]JFUX2TY:B00DS8b=nOWinOWjATI5bLW800UeMG@06E5ADHF5QAdM7AdM7]kNg
8b<S0UQHF0069bLW92@TooooooooHf=SEUIF0W9bLP05EUIF?3`lGemOGemO4A4A0095ADD01Q`L77em
OBl_;bl_;hV9RCXj>P8m?Cd01Hb<S?ooooooooooo`00000^oooo00@0003oooooooooool2Ti>C00E^
KVi;Bd^:RXZ:RXXi>CT00XJ6QP06A4A4;Rh^Hf=SHf=SKVi^Z:RX0YFEU@067QhN6a/K?Shn?ShnKfm_
@D510Rd];@05BTY:3`l?3`l?ZJVYUYJF008e=CD01W9bLQhN7SLg=cLg=cPh>0H61P91@D401Bd];EeM
GEeMGDi>CWUiN@02SXj>00JJVYYBDU8C4a<C4a<g=cMKFe/2DE5A00FCTi=GEeLn?Shn?Si<C4`00RHV
9P06Hf=SDU9B?Cdm?Cdm:2PXCDe=0Rl_;`06LG5a9BDU>CTi>CTiK6a/8b<S0Shn?P05]KFeMWIfMWIf
F5QH;2`/008n?Sh01Q`L73<c<cDe=CDe=DA4A0X:2P8U9BD01GUiNDM7AdM7Ag5aLAhN7P02EUIF00Hg
=cMGEeL`<30`<30/;2aXJ6P2FUYJ00FCTi<J6QYADE5ADE5JFUX00Q<C4`06BDU9<C4a8R8R8R8R@410
FUYJ0R`/;005C4a<CTi>Jf][Jf][H61P008I6AT01UIFEU5ADI:BTY:BTS4a<HZ:RP9kNg/01X^;ReYJ
FU1@D51@D7QhN4U9B@;9bLT01CDe=DY:BTY:BS8b<QdM7@02oooo00IQHF5MGEeVIVIVIVICDe<n?Sh2
KFe]00D71`MHF5PP820P821SHf<00QTI6@05Ph>3=CDe<C4a<C4aPH6100?oool00`000?ooooooo`0=
oooo000Roooo00<0003oooooool00_ooo`:EUID01W9bLT=3@iJFUYJFUTI6AWQhN09GEeL01AlO7eaL
G5aLG8F5QIBDU002Q8B400H<30`B4Q8a<C4a<C5cLg=8B4P29BDU00I;Bd/D51Bd];Bd];B5QHE6ATH2
HV9R00D<30`b<S98B4Q8B4P;2`/00T10@0068R8RE5ADDU9BDU9BPX:2Ph>30ZJVYP06@d=35ADE=CDe
=CDeH61PC4a<0XB4Q005H61P<c<cCDe=CDe=:2PX009PH6001U=CDcTi>C8b<S8b<TQ8B2<S8`9SHf<0
1S4a<CHf=Ve]KFe]KB`/;3dm?@:_[jl01GalO5ADE2/[:b/[:cdm?@026ATI00Hd=3@n?Sho?clo?clH
61Pa<C42LW9b00IEEEE[Jf/K6a/K6a]NGUh/;2`2GEeM00H^;RhV9RI/K6a/K6aHF5R:RXX26QXJ00E@
D51EEEEEEEDU9BEMGEd00S<c<`0630`<?ShnATI6ATI6?Shn?Cdm0UQHF006MGEeFUYJ7AdM7AdMFe]K
FUYJ0Y:BTP058b<SOWinOWinTI6ALW9b009MGEd01UADE65QHDM7AdM7AkNg]b<S8`9HF5P01RLW9b@T
9?ooooooof=SHeIFEP9bLW801EIFES`l?5mOGemOGa4A4@02ADE500HL71amOGd_;bl_;bn9RHTj>SX2
?Cdm00F<S8coooooooooool00000;_ooo`040000oooooooooooo0Y>CT`05KVi^Bd];RXZ:RXZ:>CTi
00:6QXH01TA4A2h^;V=SHf=SHfi^KZRXZ0:EUID01QhN7Q/K6chn?Shn?Vm_Kd51@@8];Bd01DY:BPl?
3`l?3jVYZIJFUP02=CDe00IbLW8N7Qhg=cLg=cLh>3P61PH2@D5100D];BeMGEeMGEe>CTiiNGT00Xj>
SP06VYZJDU9B4a<C4a<C=cLgFe]K0U5AD@05Ti>CEeMG?Shn?ShnC4a<008V9RH01V=SHe9BDSdm?Cdm
?BPX:4e=C@8_;bl01W5aLBDU9CTi>CTi>Fa/K2<S8`8n?Sh01KFe]GIfMWIfMUQHF2`/;002?Shn00HL
71`c<c<e=CDe=CE4A4@:2PX29BDU00EiNGU7AdM7AdMaLG4N7Qh00UIFEP06=cLgEeMG<30`<30`;2`/
J6QX0UYJFP05Ti>C6QXJDE5ADE5AFUYJ008C4a<01TU9BC4a<B8R8R8R8T10@5YJFP8/;2`01Da<C4i>
CV][Jf][Jf1PH0026ATI00IFEUIADE6BTY:BTY8a<C6:RXX2Ng]k00J;Rh]JFUY@D51@D51hN7Q9BDT2
bLW900De=CE:BTY:BTXb<S8M7Ad00_ooo`06HF5QGEeMIVIVIVIVDe=C?Shn0Ve]K@051`L7F5QH820P
820PHf=S008I6AT01H>3PcDe=C4a<C4a<H61P@03oooo00<0003oooooool03Oooo`008_ooo`030000
oooooooo00;oool2T92@00IeMGD<30b?Shn?ShmkNg/X:2P2D51@00E9BDV6QXJ6QXJ7QhN0P8000Xj>
SP06;Bd]3@d=>3Ph>3Ph=cLgA4A40RHV9P06K6a/Kfm_;2`/;2`/De=C2@T90VATI005MWIfM7Ad<c<c
<c<c?Shn008a<C401Vi^KW9bLU1@D51@D8R8R9jNWP9QHF401S4a<D10@3Ph>3Ph>5=CDadM7@8e=CD0
1D51@EUIFE1@D51@D2/[:`02<30`00HO7al_;blW9bLW9bLl?3a8B4P23Ph>00HV9RIFEUI=CDe=CDeX
J6PX:2P2:BTY00EaLG5VIVJ@T92@T90G5aL00U5AD@06PH61TY:BJVYZJVYZCdm?B4Q80VQXJ006EeMG
RHV9MGEeMGEeBd];2`/;0UYJFP06;2`/Cdm?6a/K6a/KJf][NWYj0SLg=`058b<S:2PX:2PX8b<SBd];
009>CTh01T92@RTY:A8B4Q8B4S0`<8j>SP8k>c/01Xb<S0P826IVIVIVITY:BTM7A`:_[jl01Dm?Cgal
O7alO6EUIGalO002@D5100IoOgmgMgLa<C4a<C5IFETM7Ad2RXZ:00HS8b=NGUkGemOGemLL71bg]kL2
7AdM00D_;blX:2QjNWYjNWY<C4`00Ph>3P064Q8BIFEUADE5ADE5>3PhTi>C0YVIV@0561PHoooooooo
oooo000002koool010000?ooooooooooo`:GUiL01G]kNa@D596ATI6ATFYZJP02>SXj00I=CDePH61^
KVi^KVifMWJCTi<2Xj>S00HW9bLG5aLk>c/k>c/g=cM8B4P2820P00ENGUieMGEeMGD^;RiHF5P00QdM
7@06NGUiRh^;JVYZJVYZ;Rh^@D510SPh>005MGEeLG5aLG5aCTi>TI6A00:MWId01UMGEdQ8B3dm?Cdm
?EIFESlo?`8Y:BT01EADE3Xj>UMGEeMGEd10@0027alO00H/;2`L71`Z:RXZ:RX^;Rhc<c<2EeMG00HW
9bM1@D53@d=3@d=FEUI?Cdl251@D00Dg=cMSHf=SHf=cLg>?Shl00QDE5@06DU9BPh>3S8b<S8b<IfMW
De=C0Shn?P05H61PEUIFEUIFRHV9OGem0093@d<01Q8B4U=CDc<c<c<c<e5ADAPH609^KVh01GQhN38b
<RHV9RHV9R`/;0028B4Q00I@D51>CThh>3Ph>3Pf=SH:2PX27QhN00FCTi<h>3QjNWYjNWX:2PX00WIf
MP06ATI6CDe=[Jf][Jf]ADE5JVYZ0Va/K006Ng]kFUYJUIFEUIFEI6AT5QHF0VQXJ0054Q8BNWYjNWYj
3@d=DU9B00;7alL00a@D5:^[Zb4Q8@028B4Q00Di>CUPH61PH61SHf</;2`00Rd];@05C4a<;Rh^;Rh^
7QhNZ:RX00:=SHd01@T92Oooooooooooo`00000?oooo000Roooo00<0003oooooool00_ooo`:SXj<0
1UYJFTm?Ce9BDU9BD[Bd]6IVIP9nOWh01C0`<?oooooood51@CXj>P02D51@00I?CdlK6a/Q8B4Q8B58
B4P^;Rh2EUIF00ITI6A5ADF5QHF5QHFFUYIGEeL2c<c<00DX:2Q6ATIWIfMWIfMEEED00Vi^KP0392@T
=SHfG5aL009LG5`01Chn?QXJ6QXJ6STi>F5QH@02ATI600HM7Ae>CTi<C4a<C4`51@EQHF425QHF00DU
9BE0@410@41<C4a@D5000QlO7`06;Rh^20P8<S8b<S8b@d=3F5QH0R<S8`06UYJF@D51?Shn?Shn;Rh^
=CDe0WEeM@05ATI69bLW9bLW@T92F5QH009EEED01UADE2PX:1TI6ATI6C`l?5ADE09fMWH01SXj>T51
@C<c<c<c<`l?3gYjNP90@4001FQXJ2LW9b4Q8B4Q8EMGE`02AdM700I0@40O7amFEUIFEUHV9RHL71`2
61PH00I<C4cooold=3@d=3AbLW9=CDd2:2PX00F;Rh]SHf=1@D51@D5TI6@00R<S8`06H61P4a<C:2PX
:2PXN7QhHV9R0UUIF@06[jn_BTY:b<S8b<S8S8b<FEUI0WYjNP06;Rh^e]KFCTi>CTi>3`l?71`L0Q@D
50056a/KX:2PX:2PN7QhJ6QX009iNGT01Di>CYVIVDE5ADE5AOKfmP03oooo00<0003oooooool0;?oo
o`040000oooooooooooo0ZJVYP05Hf=SDe=CDe=CDe=C/K6a009XJ6P01XZ:RQ`L7?ooooooocHf=TE5
A@9?Cdl01V5QHA<C4bl_;bl_;c`l?3Ti>@9>CTh01EiNGU5ADE5ADGinOYJFUP02EeMG00KEeMDK6a]@
D51@D51OGemCDe<2LW9b00DT92@i>CTi>CUFEUIXJ6P00TU9B@06;Rh^A4A4D51@D51@FUYJ3@d=0SDe
=@05GEeM5QHFD51@D51@3`l?008S8b<01SLg=d];Bda<C4a<C20P82HV9P8E5AD01S/k>e=CDdU9BDU9
BAhN7X61P@8a<C401De=CAlO7alO7dA4A7moO`02?Shn00HQ8B4n?SiJFUYJFUYBDU9IFET29RHV00DC
4a=1@D51@D5KFe]cLg<00S@d=006@T92<c<c410@410@N7Qh>CTi0VIVIP05<S8b5ADEJ6QXJ6QXF5QH
008Z:RX01Q@D55ADE2<S8b<S8aDE5A/K6`9@D5001OooodA4A5mOGemOGeUIF@02>c/k00J8R8QXJ6Q6
ATI6ATI7AdM0@402Cdm?00HG5aM7AdN:RXZ:RXY>CTiJFUX2RHV900D[:b^WYjNWYjMiNGUVIVH00VEU
I@06@d=3e]KFBDU9BDU94A4A>SXj0Rd];@05<C4aYZJVJf][Jf][Shn?009NGUh01FATI;^k^da<C4a<
C>3Ph003oooo00<0003oooooool03Oooo`008_ooo`800003oooo0Y:BTP06clo?eMGEB4Q8B4Q8N7Qh
TY:B0VMWI`05@T92hN7QhN7QK6a/GemO008l?3`01V=SHa8B4PP820P821@D56a/K09EEED01W5aLHJ6
QX61PH61P@H61WinOP8U9BD01DA4A2d];HV9RHV9RChn?P02YJFU00HO7ala<C6_[jn_[jm_KflS8b<3
K6a/00FHV9Pa<C4a<C5]KFeHF5P00S4a<@05:b/[ADE5@d=3@d=36QXJ008Y:BT01T92@UMGEdE5ADE5
AGQhN5MGE`8`<3001UIFETA4A8n?Shn?Se5ADE=CD`9UIFD01G1`L8V9RA/K6a/K6fUYJ@02Bd];00Hf
=SJ6QXI3@d=3@d>5QHEdM7@261PH00Hh>3Pe=CF1PH61PH4];Bf?Shl2<c<c00HQ8B64Q8@Y:BTY:BU7
AdMOGel2J6QX00FTY:AHF5QHF5Pf=SI8B4P00U1@D006CTi>IfMW=cLg=cLg6a/KWinO0UEEE@06>3Ph
;Rh^?Cdm?CdmIfMW<30`0R8R8P05M7Ad=CDe=CDeOgmo:RXZ008_;bl01UADE6i^KS4a<C4a<F9RHXV9
R@9ZJVX01TE5AFEUIBTY:BTY:E=CDg5aL@:HV9P01DM7AahN7WAdM7AdM24Q8@027alO00H<30`o?cn5
QHF5QHEbLW9YJFT2>CTi00>;Rh_oooooool00P0002koool200000_ooo`:XZ:P01Nc/k;Rh^4];Bd];
BhN7Q`02RHV900IJFUY5ADG_kno_knmZJVYIFET2=SHf00ISHf<M7Ad=3@d=3@d30`=oOgl2A4A400EV
IVJMWIfMWIe_KflA4A400WmoO`06<S8b?3`l8R8R8R8RR8R8@d=30ZFUY@058B4Q<S8b<S8b[:b/N7Qh
008V9RH01W]kNfYZJXZ:RXZ:RT92@UaLG09HF5P01Bh^;SHf=SXj>SXj>Ti>CP027alO00HV9RHo?cmC
De=CDe=1@D5lO7`2E5AD00Hb<S9NGUhm?Cdm?Cf;Rh]:BTX2EEEE00EXJ6Q[Jf][Jf^ATI4Q8B400VYZ
JP06DU9B<C4aRh^;Rh^;@T92QhN70W5aL@05820P>CTi>CTi<c<cN7Qh008U9BD01Xj>SSDe=B<S8b<S
8hV9RBXZ:P95ADD01F=SHfMWIk:b/[:b/UQHF002;Bd]00I0@40j>SYVIVIVIVIADE5;Bd/29BDU00F@
T91FEUH_;bl_;blb<S800TM7A`06LG5a@d=38R8R8R8RHf=S6ATI0Va/K006?clo@D51=cLg=cLgGUiN
7AdM0U1@D005Ph>3G5aLG5aLATI6EEEE008k>c/01Tm?Chj>SYJFUYJFUV5QH@h>3P9]KFd01A/K6b@T
91HF5QHF5U=CD`02Lg=c00EdM7AjNWY1@D51@D5mOGd00_ooo`80000?oooo000Roooo00<0003ooooo
ool00_ooo`:BTY801/o?cmGEeDQ8B4Q8B7QhN9:BTP9WIfL01D92@^7QhN7QhFa/K5mOG`02?3`l00IS
Hf<B4Q8820P820PD51A/K6`2EEEE00IaLG66QXJ1PH61PH461PInOWh29BDU00E4A4@];Bf9RHV9RHTn
?Sh00ZFUY@067alO<C4a[jn_[jn_Kfm_8b<S0fa/K005V9RH<C4a<C4aKFe]F5QH008a<C401B/[:dE5
AD=3@d=3@aXJ6P02:BTY00I2@T9GEeM5ADE5ADEhN7QGEeL2<30`00IFEUI4A4B?Shn?ShmADE5CDe<2
IFEU00E`L729RHTK6a/K6a]YJFT00T];B`06=SHfQXJ6@d=3@d=3QHF5M7Ad0QPH6006>3Ph=CDePH61
PH61;Bd]Shn?0S<c<`068B4QQ8B4:BTY:BTYAdM7GemO0VQXJ005Y:BTF5QHF5QH=SHfB4Q8009@D500
1Ti>CVMWIcLg=cLg=a/K6inOW`9EEED01SPh>2h^;Sdm?Cdm?FMWIc0`<08R8R801GAdM3De=CDe=Gmo
ObXZ:P02;bl_00IDE5A^KVha<C4a<C5RHV:9RHT2JVYZ00I5ADEUIFDY:BTY:BUCDe=aLG42V9RH00E7
AdLN7QidM7AdM7@Q8B400QlO7`0630`<?cloQHF5QHF5LW9bJFUY0STi>@05Rh^;oooooooooooo0000
02koool010000?ooooooooooo`:XZ:P01Nc/k;Rh^4];Bd];BhN7Q`02RHV900IJFUY5ADG_kno_knmZ
JVYIFET2=SHf00ISHf<M7Ad=3@d=3@d30`=oOgl2A4A400EVIVJMWIfMWIe_KflA4A400WmoO`06<S8b
?3`l8R8R8R8RR8R8@d=30ZFUY@058B4Q<S8b<S8b[:b/N7Qh008V9RH01W]kNfYZJXZ:RXZ:RT92@UaL
G09HF5P01Bh^;SHf=SXj>SXj>Ti>CP027alO00HV9RHo?cmCDe=CDe=1@D5lO7`2E5AD00Hb<S9NGUhm
?Cdm?Cf;Rh]:BTX2EEEE00EXJ6Q[Jf][Jf^ATI4Q8B400VYZJP06DU9B<C4aRh^;Rh^;@T92QhN70W5a
L@05820P>CTi>CTi<c<cN7Qh008U9BD01Xj>SSDe=B<S8b<S8hV9RBXZ:P95ADD01F=SHfMWIk:b/[:b
/UQHF002;Bd]00I0@40j>SYVIVIVIVIADE5;Bd/29BDU00F@T91FEUH_;bl_;blb<S800TM7A`06LG5a
@d=38R8R8R8RHf=S6ATI0Va/K006?clo@D51=cLg=cLgGUiN7AdM0U1@D005Ph>3G5aLG5aLATI6EEEE
008k>c/01Tm?Chj>SYJFUYJFUV5QH@h>3P9]KFd01A/K6b@T91HF5QHF5U=CD`02Lg=c00EdM7AjNWY1
@D51@D5mOGd00oooo`030000oooooooo00goool002;oool01@000?ooooooooooolO7a`02KVi^00IB
DU:@T91KFe]KFe/>3Phg=cL2W9bL00E9BDV@T92@T92i^KTH61P00X^;R`06GUiN8b<S20P820P8>CTi
CTi>0R<S8`06ATI6HV9R9bLW9bLW?cloPH610WIfMP0592@TGEeM[:b/[:b/<c<c00:KVi/01V][JaXJ
6VEUIFEUIFMWIhR8R0:@T9001UQHF3@d=6m_Kfm_KfUYJF=SH`9ZJVX01IfMWE1@D6][Jf][JcXj>P02
;bl_00HI6AU8B4PU9BDU9BEEEEDb<S82>CTi00H<30aHF5QlO7alO7bKVi/C4a<2;Bd]00Di>CUlO7a6
ATI6ATI<C4`00SLg=`067QhN?3`lF5QHF5QH]kNg@4100U9BDP069bLWCDe=7QhN7QhN5aLGIVIV0WIf
MP06:RXZD51@N7QhN7QhHV9R?Shn0Q/K6`05=cLgTY:BTY:B:2PX;bl_008^;Rh01S4a<EaLG1XJ6QXJ
6TU9BB0P809_Kfl01QhN7Q@D53<c<c<c<bDU9J2PX0:@T9001C@d=55ADE5ADGAdM59BDP02820P00I:
BTZ7QhM@D51@D52ATI5GEeL2=cLg00Hh>3QJFUXo?clo?cnEUIE8B4P2CDe=00EGEeL[:b]kNg]kNg]/
K6`00UaLG006E5AD8R8R?Cdm?Cdm92@TTI6A0U9BDP05YZJVoooooooooooo000002koool010000?oo
ooooolK6aP9kNg/01F5QHGalO4=3@d=3@`l?3`02B4Q800J7QhMHF5RHV9RHV9S;bl/^;Rh2Ph>300IP
H60[:b/;2`/;2`/h>3QCDe<2;2`/00ECDe=ZJVYZJVXU9BDc<c<00X^;R`06GUiN7QhNADE5ADE5[:b/
@d=30Y>CT`05H61P9bLW9bLWJVYZHF5Q00:;Rh/01Y6ATE=CDb`/;2`/;6IVIU]KF`9eMGD01EeMGJ^[
Zd92@T92@X20P0029BDU00Hh>3PC4a=;Bd];Bd/G5aMBDU82>3Ph00He=CD<30aHF5QHF5QlO7bIVIT2
3Ph>00Da<C4h>3Ph>3Q_KfmFEUH00UaLG006?clo;Rh^A4A4A4A4DE5A_[jn0SHf=P05E5AD8b<S8b<S
AdM771`L008B4Q801V5QHGalO2TY:BTY:Di>CWQhN09IFET01DU9BBLW9cTi>CTi>J6QX@026ATI00HP
820o?clR8R8R8R9GEeLC4a<2EeMG00DF5QIXJ6PQ8B4Q8B4C4a<00SDe=@06;Bd][Jf]Q8B4Q8B48R8R
@T920UeMG@06HF5Q7QhNAdM7AdM7N7QhDE5A0X^;R`05Hf=S<30`<30`=SHfFe]K0090@4001XV9RD=3
@emOGemOGchn?TM7A`9OGel01Fm_Kfi^KVQXJ6QXJ3Ph>002ADE500D/;2bGUiMADE5ADE6QXJ400ooo
o`030000oooooooo00goool002;oool01@000?ooooooooooong]k@027AdM00I1@D6k^k]jNWYjNWX`
<32;Rh/271`L0i>CT`06I6ATL71`8R8R8R8R;bl_AdM70TU9B@068B4Q1`L7M7AdM7Ad@410JFUY0YRH
V006WIfME5ADWIfMWIfM;Bd]8b<S0^3Ph005YJFUKfm_Kfm_:RXZD51@00:KVi/01UUIFCTi>EiNGUiN
GQTI6DY:BP8Z:RX01VUYJGIfMTm?Cdm?CgUiNEIFEP8M7Ad01AlO7eADE5ADE2LW9fa/K002>c/k00J:
RXXe=CEGEeMGEeLb<S9KFe/2<C4a00IjNWY?Cdm<C4a<C4a5ADEVIVH2?clo00DY:BU<C4a<C4`51@Ej
NWX00S`l?006IFEUJf][:BTY:BTY<30`7AdM0SPh>0065aLGG5aL7alO7alO4a<C:2PX0[jn_P05G5aL
?clo9BDU9BDU<C4a008S8b<01VYZJT10@6a/K6a/K3<c<l?3``9dM7@01TA4A1`L72l_;bl_;dY:BShn
?P8Z:RX01D];Bc<c<b/[:b/[:eADE0028B4Q00HH61PE5AD[:b/[:b/^;Rh/;2`29RHV00HU9BE;Bd]R
HV9RHV:NWYhi>CT29RHV00Jm_KelO7`X:2PX:2QRHV8H61P2JFUY00Dn?Sj2PX:2PX:HV9RJVYX00S@d
=005AdM7UIFEK6a/K6a/TI6A00?oool00`000?ooooooo`0/oooo00@0003oooooooooool2:RXZ00ED
E5Bc/k=gMgMgMgLa<C400X^;R`067alOU9BDU9BDU9BDM7AdHf=S0QDE5@067QhNC4a<@T92@T92;2`/
6a/K0Ve]K@05?cloHF5QHF5QT92@YZJV009FEUH01YVIVBl_;bh^;Rh^;]kNgZb/[09MGEd01B<S8chn
?Shn?YbLW5EEE@02BDU900IGEeLP821EEEEEEEDd=3AUIFD2PX:200E8B4QfMWI_Kfm_Kfl410@00QhN
7P06>CTi@d=3IfMWIfMW;Bd]LW9b0TE5A@06ATI6?ShnEEEEEEEE:BTYK6a/0UmOG`05=3@dDE5ADE5A
CDe=E5AD008J6QX01UYJFRTY:F1PH61PH2h^;WUiN@9SHf<01B4Q8C@d=3@d=1hN7S@d=0023Ph>00IP
H60`<30410@410@b<S:`/;02GemO00Di>CT:2PY6ATI6ATHj>SX00WemO@06>c/kLg=c:2PX:2PX_Kfm
Ng]k0Slo?`057AdM=3@dD51@D51@>SXj008_;bl01U9BDSdm?B<S8b<S8dM7Ab0P808?3`l01QXJ6Q`L
73Lg=cLg=aPH62/[:`8G5aL01DE5AFMWIfMWIhJ6QTa<C0024A4A00K7alM`L70O7alO7amYJFTN7Qh2
I6AT00Db<S:CTi>4Q8B4Q8BQXJ400Rh^;P05HV9RV9RHLg=cLg=cNGUi00?oool00`000?ooooooo`0=
oooo000Roooo00<0003oooooool00_ooo`9JFUX01VQXJ4U9BI2@T92@T5ADE2`/;0:e]KD01Fi^KShn
?Shn?S`l?24Q8@02G5aL00Hk>c/d=3B^[Zj^[Zi@D51XJ6P29bLW00J:RXXU9BDh>3Ph>3P];BdK6a/2
JFUY00F@T91oOgl_;bl_;bmcLg<00UEEE@06=SHfBTY:FEUIFEUIC4a<QHF50R<S8`065aLGF5QH61PH
61PH;Rh^D51@0QXJ6P05A4A4410@:RXZ:RXZJ6QX009=CDd01VIVIQhN7T10@410@3/k>di>CP:;Rh/0
1WmoOd=3@c<c<c<c<f9RHS/k>`8T92@01@P823Ti>CDe=CDe=Da<C002QHF500HW9bLe=CFPX:2PX:0m
?Cde=CD2GemO00Hf=SHT92@W9bLW9bM7AdNCTi<2:BTY00J8R8Q^KViJFUYJFUY9BDV3Ph<2Y:BT00E7
AdM/K6a/K6`T92A4A4@00Q8B4P06Ng]k@d=39BDU9BDUWinODe=C0QdM7@06=3@d410@;Bd];Bd]EUIF
[jn_0U=CD`0571`LMWIfMWIfShn?Ng]k008f=SH01Q`L76ATI2LW9bLW9c@d=9NGU`;2`/801Pl?3jn_
[hB4Q8B4Q5YJFTY:BP;3`l<01OOgmeiNGR4Q8B4Q8HR8R002Vi^K00J8R8Pg=cNOWinOWinGUiN`/;02
EeMG00GShn?oooooooooool00000;_ooo`040000oooooooooooo0X>3P`05M7Ad:BTYNGUiNGUiGemO
008^;Rh01[bl_5aLG5YJFUYJFRXZ:S`l?09jNWX01R4Q8FIVIX>3Ph>3Pg9bLTU9B@8e=CD01Hf=SAhN
7QhN7R`/;3<c<`026ATI00I`L728R8R?Shn?Shm1@D5VIVH2GemO00DY:BTm?Cdm?Ce:BTYBDU800X:2
PP067AdM4a<CFUYJFUYJ4Q8B:2PX0UIFEP05410@DE5A7AdM7AdM;Bd]009QHF401V9RHU5AD@/;2`/;
2bl_;c4a<@8n?Sh01Y6ATGinOShn?Shn?RTY:EIFEP9@D5001@P822TY:BTY:Cdm?DA4A0029RHV00J@
T90;2`]2@T92@T:BTY8^;Rh2<C4a00EEEEDi>CTi>CTO7alS8b<00S<c<`06QXJ6Bd];SHf=SHf=N7Qh
<c<c0TI6AP05QhN7Vi^K=cLg=cLgO7al008W9bL01TY:BQ4A4GQhN7QhN3lo?bHV9P:FUYH01DA4A2l_
;b4Q8B4Q8B@T9002@D5100I=CDfd];ABDU9BDU8S8b=^KVh2UiNG00IgMgLb<S8Z:RXZ:RYdM7@S8b<2
?3`l00FYZJVSXj>SXj<g=cNCTi<00Y6AT@06OGem:b/[^KVi^KViooooF5QH0QhN7P05R8R8V9RHJf][
Jf][>c/k00:?Shl01KVi^I6ATBl_;bl_;o;blP03oooo00<0003oooooool03Oooo`008_ooo`030000
oooooooo00;oool2FUYJ00IXJ6Q9BDV@T92@T91DE5@/;2`2]KFe00E^KVhn?Shn?Shl?3`Q8B400UaL
G006>c/k=3@d[Zj^[Zj^D51@J6QX0RLW9`06RXZ:9BDU>3Ph>3Ph;Bd]6a/K0VUYJ@05T92@Ogmo;bl_
;bl_Lg=c009EEED01SHf=TY:BUUIFEUIFDa<C8F5Q@8S8b<01QLG5eQHF1PH61PH62h^;U1@D08J6QX0
1DA4A10@42XZ:RXZ:VQXJ002CDe=00IVIVHN7Qi0@410@40k>c]>CTh2Rh^;00IoOgm3@d<c<c<c<c=R
HV8k>c/292@T00D820Pi>CTe=CDe=CE<C4`00XF5Q@069bLW=CDeX:2PX:2P?Cdm=CDe0UmOG`06=SHf
92@T9bLW9bLWAdM7Ti>C0RTY:@06R8R8KVi^FUYJFUYJBDU9Ph>30ZBTY005AdM7K6a/K6a/92@TA4A4
008B4Q801W]kNd=3@bDU9BDU9InOWe=CD`8M7Ad01S@d=10@42d];Bd];EIFEZn_[`9CDe<01A`L77If
MWIfMXn?Sg]kN`02=SHf00HL71aTI6@W9bLW9bLd=3BGUiL2`/;200H?3`n_[jn4Q8B4Q8AJFUY:BTX2
`l?300GgmoMNGUhQ8B4Q8B68R8P00Y^KV`06R8R8=cLgWinOWinOUiNG/;2`0UMGE`05hn?Soooooooo
oooo000002koool010000?ooooooooooo`:3Ph<01GAdM2TY:GUiNGUiNEmOG`02;Rh^00Jl_;aLG5aJ
FUYJFUXZ:RXl?3`2NWYj00HQ8B5VIVJ3Ph>3Ph=bLW99BDT2=CDe00F=SHdN7QhN7Qh/;2`c<c<00QTI
6@06L71`R8R8Shn?Shn?@D51IVIV0UmOG`05:BTY?Cdm?CdmBTY:DU9B00:2PX801QdM7A<C4eYJFUYJ
FQ8B4RPX:09FEUH01A0@455ADAdM7AdM7Bd];@02HF5Q00IRHV9ADE4;2`/;2`/_;bla<C42?Shn00JA
TI5nOWhn?Shn?ShY:BUFEUH2D51@00D820PY:BTY:BTm?Ce4A4@00RHV9P06T92@2`/;@T92@T92TY:B
;Rh^0S4a<@05EEEE>CTi>CTi7alO8b<S008c<c<01XJ6QT];Bhf=SHf=SGQhN3<c<`96ATH01HN7Qi^K
VcLg=cLg=galO0029bLW00I:BTXA4A5hN7QhN7Po?clV9RH2UYJF00E4A4@_;blQ8B4Q8B4T92@00T51
@@06CDe=];BdDU9BDU9B8b<SKVi^0YNGU`06MgMg<S8b:RXZ:RXZM7Ad8b<S0S`l?005ZJVYXj>SXj>S
=cLgTi>C00:ATI401WemOB/[:kVi^KVi^OoooeQHF08N7Qh01HR8R9RHV6][Jf][Jc/k>`02Shn?00Fi
^KVATI4_;bl_;bobl_800oooo`030000oooooooo00goool002;oool01@000?ooooooooooom3@d002
AdM700JIVIW/k>bj^[Zj^[[1`L57AdL2>3Ph00D_;bmbLW9bLW:PX:1_Kfl00Y2@T006S8b<JVYZ/;2`
/;2`;bl_e=CD0STi>@06TY:B71`L20P820P83`l?CTi>0TA4A005GEeMG5aLIVIVIVIVD51@008W9bL0
1XB4Q30`<9NGUiNGUdi>CT=3@`8V9RH01QlO7cDe=FUYJFUYJClo?eMGE`9PH6001C`l?4I6AShn?Shn
?Te=C@02IfMW00Hl?3`T92@j>SXj>SXL71`G5aL2UiNG00J8R8PJ6QY:BTY:BTYbLW8];Bd2>c/k00Df
=SHE5ADn?Shn?ShT92@00Ti>CP06DE5AFEUI820P820P>c/kGUiN0Sdm?@06E5ADDE5A;2`/;2`/?clo
KVi^0WMgM`06ADE5OGemCDe=CDe=@T926ATI0S`l?005OgmoFEUIFEUI9bLW<S8b009PH6001Rl_;chn
?Shn?Shn?Tm?CgemO@8e=CD01VQXJ59BDSHf=SHf=TU9BHF5Q@9WIfL01B<S8dM7AdM7AlO7aemOG`02
Q8B400IQHF7Jf]Z=SHf=SHdj>S[6a/H2NGUi00JFUYH>3PhA4A4A4A4b<S8d=3@2;Rh^00F][Je]KFg2
`/;2`/;0`<000_ooo`06IFEU/K6aIfMWIfMW5aLGoooo0Va/K005h^;Roooooooooooo000002koool0
10000?ooooooojFUY@95ADD01L71`MWIfI2@T92@T>GUi@02<S8b00Hd=3@c<c=jNWYjNWZBTY9ADE42
[jn_00IlO7a;Bd^d];Bd];@h>3RUYJD2IfMW00F6QXHX:2PX:2PM7AdB4Q800SPh>006FUYJEEEEKFe]
KFe]MgMg=CDe0TQ8B005HV9R30`<30`<QXJ6IFEU008Q8B401QDE5ATI6Di>CTi>CW9bLTI6AP9=CDd0
1EYJFSHf=TM7AdM7Ac`l?002ATI600IaLG4a<C4a<C4a<C4^;RhW9bL292@T00JFUYJATI4@410@4112
@T9dM7@2<c<c0d10@006:RXZ<S8b8b<S8b<SF5QHJFUY0TA4A00530`<;Bd]EUIFEUIF@410009ADE40
1U]KFbPX:2d];Bd];EQHF9FEU@98B4P01UYJFVMWIb@T92@T92`/;3Lg=`:5QHD01Di>CR8R8R8R8SDe
=FIVIP029RHV00I>CTh^;Rhh>3Ph>3QaLG4J6QX2CTi>00E]KFdT92@T92AFEUJ5QHD00V5QH@069BDU
>CTic<c<c<c<K6a/Shn?0UIFEP05emOGT92@?Cdm?Cdmclo?009[Jf/01YnOWa@D520P820P84Q8B1/K
6`8o?cl01YbLW8V9RJb/[:b/[;no_oooo`9LG5`01JNWYg]kNg]kNc4a<Oooo`02CTi>1?ooo`030000
oooooooo00goool002;oool200000_ooo`05ATI6Z:RXZ:RXooooCdm?00:WYjL01Hf=SEUIFL30`<30
`7moO`02BDU900J4Q8CZj^XZ:RXZ:RZPX:0N7Qh21PH600JRXZ8n?ShT92@T92APH60[:b/23@d=00IE
EEEdM7B2PX:2PX9hN7QnOWh2ATI600DK6a/f=SHf=SIPH61`L7000VUYJ@06DU9B;2`/=cLg=cLg<C4a
Kfm_0SPh>006=SHfRh^;;Bd];Bd]SHf=?3`l0SDe=@05CDe=;Rh^;Rh^;bl_MWIf008n?Sh01VYZJT51
@IbLW9bLW9NGUeaLG08:2PX01R0P82`/;4];Bd];BaTI6BPX:08T92@01B<S8b8R8R8R8UEEECXj>P02
FEUI00HQ8B5:BTY@D51@D50d=3ABDU82:RXZ00H];BeFEUIVIVIVIVI8B4RJVYX2DU9B00DT92@R8R9e
MGEeMGDL71`00STi>@06UIFE:RXZ3Ph>3Ph>A4A492@T0RTY:@06FEUIJFUYCDe=CDe=VIVI820P0Q8B
4P05I6AT6ATIQHF5QHF5TI6A008K6a/01U]KFijNWZFUYJFUYE5ADFm_K`8l?3`01X:2PTI6AU9BDU9B
DYFEUE1@D08j>SX01WQhN2/[:ahN7QhN7S8b<UaLG0:BTY801HB4Q?ooooooofQXJ4=3@`02:b/[00Gk
no]0@43`l?3`l?34a<@00_ooo`80000^oooo0P000006oooo<30`^k^k^k^kkno_>c/k0YVIV@05Ogmo
NGUiNGUi[jn_S8b<009<C4`01XN7Qm[JfQdM7AdM7HJ6QP`<308O7al019VIVDU9BDQ8B4Q8B0==CDd0
1S0`<4Y:BU]KFe]KFiZJVVQXJ09kNg/01CDe=C0`<2/[:b/[:d51@@02IVIV00IPH61bLW8C4a<C4a=3
@d<T92@2H61P0T=3@`:1PH401B8R8X20P3lo?clo?cPh>002DU9B00Hi>CTk>c]XJ6QXJ6Q>CTiKFe/2
Cdm?00JFUYJQXJ5DE5ADE5@:2PXN7Qh2;Bd]00E;Bd/G5aLG5aL_;blL71`00Rl_;`06;Rh^Bd];?Shn
?ShnD51@8B4Q0TE5A@05De=C<c<c<c<cDE5A;Bd]008Q8B401UADE7MgMcHf=SHf=Xf=SEMGE`8M7Ad0
1A0@47inOP`<30`<33Xj>P02Ti>C00H[:b/@4113@d=3@d<H61Pi>CT2BDU900EADE5RHV:0P820P80_
;bl00PL71`06Lg=c:2PXNGUiNGUiTY:B92@T0UEEE@06ZJVYXJ6QHF5QHF5QJf][;Rh^0Y:BTP05De=C
BTY:BTY:X:2PF5QH008f=SH01WinOShn?Pl?3`l?3d=3@dI6AP:IVIT01GinO_ooofUYJFUYJDi>CP02
9bLW00Gooolm?CgmoOgmoOgJf]X00_ooo`80000?oooo000Roooo00D0003oooooooooooobl_800U9B
DP06oooo:2PXVIVIVIVI=SHfk^k^0RDU9@05k>c/T92@T92@?3`lPX:2008Y:BT01_?cld=3@eYJFUYJ
FQdM7CXj>P9ZJVX01TI6ATi>CYJFUYJFUZ>SXchn?P:1PH401KNg]alO7`h>3Ph>3VQXJ0023Ph>00Im
OGf=SHeJFUYJFUX];Bd`<302EEEE00I^KViUIFDP820P820d=3AdM7@23Ph>00AlO7`?3`mEEEEEEED3
LW9b00He=CE5ADEFEUIFEUHT92@Y:BT28B4Q00=@D50n?ShI6AT00QTI6@05IFEU1PH61PH6GEeM5QHF
008f=SH01DQ8B3Lg=cLg=dI6AV1PH002Cdm?00I<C4aNGUiTI6ATI6A?Cdm<C4`24Q8B00I@D50^;RiR
HV9RHV:5QHFIVIT2:RXZ00DD51ASHf<g=cLg=cL[:b/00X>3P`06KFe]7alOJ6QXJ6QXDU9B<30`0Q0@
4006CDe=B4Q8QhN7QhN7=cLgLG5a0T=3@`05KFe]PX:2MgMgMgMg[Zj^009>CTh01Slo?i6ATLc<c<c<
c861PGEeM@9lO7`01ZVYZA/K6fYZJVYZJVUYJDE5A@9YJFT01WmoOiNGUkRh^;Rh^6IVIUmOG`8T92@0
1OooolS8b<S8b820P?ooo`02XZ:R00@;2`//;2bDU9BDU9@4oooo00<0003oooooool0;?ooo`040000
oooooooooooo0T51@@05oooo<S8bTY:BTY:B<S8b00;]kNd01R0P8?ooogmoOgmoObh^;V9RHP9=CDd0
1/g=cDE5AFm_Kfm_KaLG5e=CD`9gMgL01CTi>D];Bd];BiBDU:b/[002?3`l00JFUYJSXj<g=cLg=cLY
:BU@D502;2`/00EYJFVDU9BDU9A>CThk>c/00Slo?`06Bd];MWIfJf][Jf][92@T;Bd]0VIVIP052@T9
OWin6a/K6a/KE5AD00=eMGD01CXj>Slo?clo?dm?CbHV9P02=SHf00H/;2a1@D5ADE5ADE4G5aL@4102
I6AT00D:2PYSHf=SHf<S8b<_;bl00U5AD@06<S8b@410EeMGEeMGBd];EeMG0UUIF@05M7Ad?clo?clo
?3`l8b<S0091@D401Q`L77IfMW=cLg=cLi^KVahN7P8O7al01EMGEbl_;c<c<c<c<ginOP02J6QX00HI
6AU]KFeIFEUIFET[:b/G5aL2EeMG00EFEUIhN7Q0@410@41WIfL00S/k>`06O7alOgmoKVi^KVi^Z:RX
F5QH0STi>@06UYJFclo?OWinOWinMgMgOWin0YRHV0052PX:H61PH61PDU9BGemO009SHf<01VMWIjVY
ZL30`<30`5UIFEmOG`8d=3@01OoookBd]7YjNWYjN_ooo`02`/;200@N7Qi@D52ZZZZZZZX4oooo00<0
003oooooool03Oooo`008_ooo`050000ooooooooooool_;b009BDU801_ooobPX:9VIVIVIVCHf=^k^
kP8U9BD01Nc/k92@T92@T3`l?8:2PP02:BTY00Kclo=3@d=JFUYJFUXM7Adj>SX2JVYZ00I6ATI>CTjF
UYJFUYJSXj<n?Sh2PH6100Fg]kLO7al>3Ph>3PiXJ6P00Ph>3P06OGemSHf=FUYJFUYJ;Bd]<30`0UEE
E@06KVi^IFEU820P820P=3@dM7Ad0Ph>3P04O7al3`l?EEEEEEEE0g9bLP06=CDeADE5EUIFEUIF92@T
:BTY0R4Q8@03D51@?Shn6ATI008I6AT01FEUI@H61PH61UeMGAHF5P02=SHf00E8B4Pg=cLg=cM6ATIP
H6000Tm?C`06C4a<GUiNI6ATI6ATCdm?C4a<0Q8B4P06D51@;Rh^HV9RHV9RQHF5VIVI0RXZ:P0551@D
Hf=S=cLg=cLg:b/[00:3Ph<01Ve]KAlO7fQXJ6QXJ59BDS0`<08@41001Te=CDQ8B8N7QhN7QcLg=g5a
L@93@d<01Fe]KH:2PWMgMgMgMjj^[P02CTi>00Ho?cnATI7<c<c<c<b1PH5eMGD2O7al00JYZJTK6a]Z
JVYZJVYYJFU5ADD2JFUY00IoOgnGUiNh^;Rh^;QVIVIOGel292@T00Goooo8b<S8b<R0P83oool00Z:R
XP042`/;;2`/U9BDU9BD1?ooo`030000oooooooo02coool010000?ooooooooooo`91@D401Ooooc8b
<Y:BTY:BTS8b<P02kNg]00HP823ooomoOgmoOgl^;RiRHV82CDe=00K=cLe5ADE_Kfm_KflG5aMCDe<2
MgMg00Di>CU;Bd];Bd^DU9B/[:`00S`l?006UYJFXj>S=cLg=cLg:BTYD51@0R`/;005JFUYU9BDU9BD
CTi>>c/k008o?cl01T];BgIfMV][Jf][Jb@T92d];@9VIVH01@T92GinOQ/K6a/K6eADE003MGEe00Dj
>SXo?clo?cm?CdlV9RH00SHf=P06;2`/@D51DE5ADE5A5aLG410@0VATI0052PX:Hf=SHf=S8b<S;bl_
009ADE401S8b<T10@5MGEeMGEd];BeMGE`9IFET01GAdM3lo?clo?c`l?2<S8`02@D5100HL71afMWIc
Lg=cLg>KVi/N7Qh27alO00EGEeL_;blc<c<c<c=nOWh00VQXJ0066ATIKFe]FEUIFEUI:b/[5aLG0UMG
E`05EUIFN7Qh@410@410IfMW008k>c/01WalO7moOfi^KVi^KZRXZ5QHF08i>CT01YJFU/o?cginOWin
OWMgMginOP:HV9P01@X:2V1PH61PH59BDUmOG`02Hf=S00IWIfNYZJW0`<30`<1IFEUOGel2=3@d00Go
oond];AjNWYjNW[oool00/;2`P047QhND51@ZZZZZZZZ1?ooo`030000oooooooo00goool002;oool0
0`000?ooooooo`02oooo0[2`/0;oool2NGUi00FQXJ7ooomWIfMWIfNBTY800YNGU`06IfMWDE5AfMWI
fMWIAdM7_[jn0TI6AP06K6a/o?clOWinOWinMGEeBTY:0XN7Q`06FUYJDE5A6QXJ6QXJdM7ALW9b0SXj
>P05h^;R];Bd];BdK6a/6QXJ008f=SH29bLW0T=3@`06C4a<V9RHF5QHF5QH?3`lDU9B0S0`<005JFUY
Cdm?:2PX:2PXB4Q80094A4@01Q/K6cPh>>_[jn_[j`H61UQHF09]KFd01Q/K6c<c<bh^;Rh^;S`l?9BD
U092@T801GinOTY:BWMgMgMgMaTI6@028R8R00JEUIE@D510@410@41EEED];Bd2C4a<00I_Kfl^;Rha
<C4a<C5fMWH[:b/2Cdm?00I8B4QDE5@O7alO7all?3b3Ph<2UiNG00E:BTYfMWIfMWH`<31IFET00YjN
WP06GemOBDU9GEeMGEeM=cLgO7al0UMGE`0692@TJVYZJVYZJVYZNg]kFEUI0Rh^;P05Cdm?Rh^;Rh^;
VYZJ?clo00;Bd]801]7AdBXZ:X>3Ph>3Pdi>CXb<S09gMgL01QlO7bTY:EaLG5aLG6m_KdY:BP:BTY80
1DM7Acdm?De=CDe=CF][J`02d];B00J<S8c6a/JEUIFEUIDI6AVZZZX2VYZJ00EHF5Soooooooooool0
0000;_ooo`040000oooooooooooo0/G5a@;oool2WYjN00FSXj?GemOGemNLW9cAdM400UEEE@06UiNG
Ti>CZJVYZJVYMWIfW9bL0VUYJ@05JVYZooooM7AdM7AdOgmo009CDe<01Ve]KG9bLV][Jf][JdQ8B=cL
g09@D5001FYZJ]OGelG5aLG5aE9BDP026ATI0R@T908d=3@01TA4A4];Bk:b/[:b/T];Bb0P808b<S80
1CLg=fe]KE1@D51@D1LG5`02>SXj00I<C4`M7Ae3@d=3@d?IfMTK6a/3L71`00E3@d=OGemOGelL71`M
7Ad00YVIV@057alOT92@T92@B4Q8LG5a008U9BD01R0P88j>ST51@D51@C<c<eUIF@9=CDd01Fm_Kde=
CDe=C@T92DE5A@02E5AD00I4A4A>CThc<c<c<c=PH60D51@2=cLg00F1PH6IVIU7AdM7AdMbLW800RPX
:006HV9RVIVIGemOGemOA4A4H61P0SDe=@05OWinFEUI820P820PLW9b009SHf<01WYjNTm?CbLW9bLW
9d=3@i:BTP:4Q8@01U=CDo;bl/c<c<c<c1@D57=cL`8j>SX01Fa/K5YJFUYJFR/[:`l?3`02@d=300I]
KFeCDe>8R8R8R8QTI6@C4a<292@T00Di>CV`/;1=CDe=CDf5QHD00eMGE`04Ng]k`/;2`/;2FUYJ0ooo
o`030000oooooooo00goool002;oool00`000?ooooooo`04oooo00IIFEW:b/Z[Zj^[Zj]NGUkoool2
Hf=S00FJVYYmOGemOGdB4Q:XZ:P00Ta<C006YZJVEUIFc/k>c/k>OgmoADE50TQ8B006inOWADE5WYjN
WYjN9RHVI6AT0W]kN`05g=cLTY:B:b/[:b/[Hf=S008Z:RX01TE5AKfm_A8B4Q8B4YfMWDQ8B08B4Q80
1Te=CB4Q8FEUIFEUIA0@45eMG@9IFET01Bh^;TI6AUiNGUiNGS<c<`02?Shn00I=CDdg=cN:RXZ:RXX^
;RiWIfL2:RXZ00Hn?SiVIVHk>c/k>c/X:2QUIFD2EUIF00EnOWi;Bd^QXJ6QXJ4G5aL00UmOG`06DU9B
=CDeE5ADE5AD:BTYE5AD0PH61P067QhNG5aL>SXj>SXjATI6C4a<0Ti>CP06ADE551@D6QXJ6QXJ7AdM
WYjN0]WIf@05Hf=S;Rh^;Rh^6QXJ5QHF00:1PH401R4Q8C0`<9NGUiNGUdQ8B4e=C@:VYZH01Ve]KCDe
=DE5ADE5AJJVYXR8R090@4001B/[:hR8R8R8R3@d=6i^KP02CDe=00J`/;0`<32TY:BTY:A?Cdm5ADD2
_kno00HR8R9bLW95ADE5ADDJ6QZYZJT2SXj>00EeMGF9RHTU9BDU9BFe]KD00SXj>P06];Bdc<c<RHV9
RHV9BTY:=CDe0[>c/`05emOGoooooooooooo000002koool00`000?ooooooo`03oooo00EeMGGCdm>k
^k^k^k]UIFD00]GEe@06X:2Pe=CDATI6ATI6A4A4fMWI0R@T9006QhN7CDe=e]KFe]KFN7QhADE50SXj
>P05oOgm@410@410PH6192@T0094A4@01YNGUl?3`k2`/;2`/2d];G=cL`8i>CT01E=CDkFe]KFe]@`<
3:BTY002D51@00HL71a3@d<j>SXj>SY9BDT^;Rh2@T9200EKFe/B4Q9LG5aLG5a:BTX00S8b<P06A4A4
CTi>;Rh^;Rh^NWYj7alO0X20P0063@d=IVIVMWIfMWIf:BTY8b<S0WmoO`05;bl_Rh^;Rh^;C4a<U9BD
008N7Qh01UMGEdU9BCHf=SHf=Shn?Rl_;`9dM7@01BHV9Q8B4Q8B4TA4A2XZ:P02820P00Hi>CU9BDUP
H61PH60X:2P:2PX261PH00FGUiOIfMUJFUYJFUXU9BD00a<C4`05KVi^>SXj>SXj5QHFWYjN009DE5@0
1CHf=Xj>SX:2PX:2PR`/;002ATI600J[Zj^=SHdo?clo?cla<C5[Jf/2F5QH00IMGEeaLG7QhN7QhN5S
Hf=iNGT2;Rh^00D];BfUYJFUYJDF5QIeMGD00TM7A`064a<CT92@WYjNWYjNO7alD51@0RXZ:P05RXZ:
410@P820P820dM7A00:=SHd01G9bLU9BD/_;bl_;bnCTi003oooo00<0003oooooool03Oooo`004Ooo
o`D000001?ooo`000000000000?oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`8^;Rh0
1UUIFDE5AH61PH61PH^;Rc4a<@;Rh^801HJ6QX61PH61PL?3`jn_[`02XJ6Q00I<C4a;Bd^:RXZ:RXYW
IfM3@d<2ZZZZ00KooomWIfMlO7alO7a<C4bWYjL2T92@00DV9RIHF5QMGEeMGEd^;Rh00UeMG@06HV9R
M7Ad;Bd];Bd]QHF5Vi^K0SDe=@06IFEUC4a<HF5QHF5Q=SHf<C4a0Q0@4005MgMgFe]K<S8b<S8b@d=3
009fMWH01UADE3hn?STi>CTi>CPh>4U9B@90@4001QlO7bd];F9RHV9RHX20P5UIF@9nOWh01G5aLE9B
DT10@410@2XZ:P02GemO00I_KfmmOGd71`L71`Ld=3@j>SX2Ng]k00IHF5QdM7@P820P820b<S:QXJ42
>3Ph00IUIFECDe<n?Shn?ShM7AfDU9@2L71`00D?3`lW9bLW9bM_Kfm9BDT00UIFEP066a/KS8b<Shn?
Shn?JFUYPh>30YBDU006K6a/92@TBTY:BTY:PX:2QhN70Rh^;P052PX:Jf][Jf][9bLWJVYZ00:9RHT0
1ZRXZ3Ph>69RHV9RH^;RhSdm?@9XJ6P01Tm?CfYZJPX:2PX:2VEUIEIFEP9KFe/01GMgMjj^[SDe=CDe
=G9bLP03BDU900ERHV;ooooooond];CWinL00_ooo`05U9BDoooooooooooo000001goool5000000Co
ool0000000000003oooo00<0003oooooool00_ooo`040000oooooooooooo0RTY:@05GUiNCdm?RXZ:
RXZ:PH610097AdL01/O7ai>CTh:2PX:2P[Rh^9VIV@:j^[X01V5QHD51@Hf=SHf=SFi^KS`l?0:f][H0
1Oooog5aLG5aLHF5QE=CD`02[Zj^00J1PH4d=3A=CDe=CDeQHF4Q8B42DU9B00EVIVIoOgmoOgm1@D6B
TY800Z:RXP066a/KDE5AATI6ATI6ADE57AdM0QPH60051@D5IVIVIVIVIVIV9RHV0097AdL01Vi^KTE5
AC`l?3`l?2LW9dm?C`8m?Cd01UIFERPX:451@D51@E5ADHJ6QP9YJFT01Fe]KGinOWinOTE5ACDe=@02
;2`/00IFEUIRHV:9RHV9RHT@410[:b/2?Shn00F6QXI<C4a<C4acLg<@41000S<c<`06SXj>ATI6Ng]k
Ng]k@410AdM70Q0@4005V9RHLG5a2PX:2PX:;Bd]009SHf<01S4a<GAdM3Xj>SXj>ZBTY:RXZ09@D500
1FMWIg]kNfUYJFUYJC/k>`02>SXj00J2PX:ATI4];Bd];BdS8b=SHf<271`L00IZJVYfMWJc/k>c/k=^
KVj=SHd2^KVi00EYJFUQHF5QHF53@d=MGEd00PL71`06I6ATAdM7A4A4A4A4IfMW/k>c0V=SH`05Cdm?
61PHNg]kNg]k?clo00;oool01JRXZ>CTi?oooooooi^KV`03oooo00<0003oooooool03Oooo`004ooo
o`050000oooooooooooo000000Coool00`000?ooo`000003oooo00<0003oooooool00_ooo`8^;Rh0
1UUIFDE5AH61PH61PH^;Rc4a<@;Rh^801HJ6QX61PH61PL?3`jn_[`02XJ6Q00I<C4a;Bd^:RXZ:RXYW
IfM3@d<2ZZZZ00KooomWIfMlO7alO7a<C4bWYjL2T92@00DV9RIHF5QMGEeMGEd^;Rh00UeMG@06HV9R
M7Ad;Bd];Bd]QHF5Vi^K0SDe=@06IFEUC4a<HF5QHF5Q=SHf<C4a0Q0@4005MgMgFe]K<S8b<S8b@d=3
009fMWH01UADE3hn?STi>CTi>CPh>4U9B@90@4001QlO7bd];F9RHV9RHX20P5UIF@9nOWh01G5aLE9B
DT10@410@2XZ:P02GemO00I_KfmmOGd71`L71`Ld=3@j>SX2Ng]k00IHF5QdM7@P820P820b<S:QXJ42
>3Ph00IUIFECDe<n?Shn?ShM7AfDU9@2L71`00D?3`lW9bLW9bM_Kfm9BDT00UIFEP066a/KS8b<Shn?
Shn?JFUYPh>30YBDU006K6a/92@TBTY:BTY:PX:2QhN70Rh^;P052PX:Jf][Jf][9bLWJVYZ00:9RHT0
1ZRXZ3Ph>69RHV9RH^;RhSdm?@9XJ6P01Tm?CfYZJPX:2PX:2VEUIEIFEP9KFe/01GMgMjj^[SDe=CDe
=G9bLP03BDU900ERHV;ooooooond];CWinL00_ooo`05U9BDoooooooooooo000001ooool01@000?oo
ooooooooo`000004oooo00<0003oool000000oooo`040000oooooooooooo0RTY:@05GUiNCdm?RXZ:
RXZ:PH610097AdL01/O7ai>CTh:2PX:2P[Rh^9VIV@:j^[X01V5QHD51@Hf=SHf=SFi^KS`l?0:f][H0
1Oooog5aLG5aLHF5QE=CD`02[Zj^00J1PH4d=3A=CDe=CDeQHF4Q8B42DU9B00EVIVIoOgmoOgm1@D6B
TY800Z:RXP066a/KDE5AATI6ATI6ADE57AdM0QPH60051@D5IVIVIVIVIVIV9RHV0097AdL01Vi^KTE5
AC`l?3`l?2LW9dm?C`8m?Cd01UIFERPX:451@D51@E5ADHJ6QP9YJFT01Fe]KGinOWinOTE5ACDe=@02
;2`/00IFEUIRHV:9RHV9RHT@410[:b/2?Shn00F6QXI<C4a<C4acLg<@41000S<c<`06SXj>ATI6Ng]k
Ng]k@410AdM70Q0@4005V9RHLG5a2PX:2PX:;Bd]009SHf<01S4a<GAdM3Xj>SXj>ZBTY:RXZ09@D500
1FMWIg]kNfUYJFUYJC/k>`02>SXj00J2PX:ATI4];Bd];BdS8b=SHf<271`L00IZJVYfMWJc/k>c/k=^
KVj=SHd2^KVi00EYJFUQHF5QHF53@d=MGEd00PL71`06I6ATAdM7A4A4A4A4IfMW/k>c0V=SH`05Cdm?
61PHNg]kNg]k?clo00;oool01JRXZ>CTi?oooooooi^KV`03oooo00<0003oooooool03Oooo`004ooo
o`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000003oooo0P0000?oool2e=CD00Ko
ooono_kooooooone]KGoool2c<c<00Dj>SYSHf=SHf?IfMVOWil00S@d=006WinOYJFUZj^[Zj^[OGem
XZ:R0SLg=`06fm_KA4A4:RXZ:RXZDE5AO7al0]GEe@05MGEeQ8B4G5aLG5aLAdM700;5aLD01UiNGY6A
TEUIFEUIFG9bLYjNWP8H61P2IFEU0W1`L006<30`KFe]=SHf=SHfEUIFOGem0XZ:RP05AdM7?clo?clo
De=CDU9B0092@T801Shn?UIFEUEEEEEEEB4Q8GYjNP9=CDd01WIfMVa/K8:2PX:2PQdM7A4A4@8m?Cd0
1Di>CVATI6ATI1`L71PH60021`L700HV9RIFEUIYJFUYJFU`L71fMWH22PX:00H@411WIfLa<C4a<C4d
=3AYJFT2Xj>S00Dc<c=IFEUIFEUIFET@41000Pd=3@06MWIf>3PhPh>3Ph>3>SXj^[Zj0RPX:006RXZ:
BTY:;2`/;2`/FUYJ6a/K0RDU9@05>3Ph=cLg>CTi>CTi@T92009=CDd01U1@D3<c<dY:BTY:BYnOWhZ:
RP8`<3001Rd];F][JbLW9bLW9c4a<Da<C09?Cdl01[jn_^KViQ`L71`L78R8R9JFUP8j>SX01Fa/K3Hf
=SHf=SHf=X20P002oooo00Dd=3AlO7coooooooo9bLT00_ooo`80000Ooooo00<0003oooooool00_oo
o`070000oooooooooooo0000oooo000000?oool200000_ooo`;Ti>@4oooo00EjNW[ooooooon6QXI:
BTX00QDE5@06UYJFg]kN@D51@D51_knoVi^K0ZJVYP05Shn?]kNgF5QHF5QH[Zj^009QHF42GEeM0WUi
N@06[:b/DE5AMGEeMGEeN7QhEeMG0]?Cd`05BDU9YJFUYJFU?CdmNg]k00:8R8P01QDE5D10@6ATI6AT
I5iNGS4a<@9TI6@01C0`<5=CDgalO7alO8n?S`03=3@d00Dg=cMHF5QHF5Q0@415ADD00TY:BP06Jf][
;2`/RXZ:RXZ:ADE5MGEe0V5QH@05Ti>C7AdM7AdM2PX:;Bd]009IFET01UEEEBPX:1<C4a<C4`h>3R4Q
8@9EEED01FEUIFi^KVi^KXN7QaLG5`028R8R00IHF5Q1@D4f=SHf=SIXJ6RBTY82BDU900EaLG5JFUX[
:b/[:b/@41000Ve]K@06:b/[XZ:RFEUIFEUIgMgMBTY:0WalO005FEUI=cLg?clo?clo:RXZ008n?Sh0
1QXJ6SHf=SXj>SXj>VATI7AdM08[:b/01PH61XN7QgMgMgMgMgYjNQXJ6P8b<S801E5ADEmOGemOGe=C
Dfm_K`02@T9200JVYZKIfMU3@d=3@d=eMGGGemL2Ng]k00Fc/k=7AdMIFEUIFEWFe]H00_?cl`05NWYj
DU9Booooooood=3@00;oool200003oooo`004oooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`000003oooo00<0003oooooool01?ooo`06`/;27AdMfm_Kfm_Khn?SE5AD0[^k^`05MgMg
dM7AdM7A^k^kl?3`00:FUYH01UIFE_oooo?clo?cljNWYd=3@`:MWId01[Jf]UUIFF5QHF5QHKVi^C`l
?0:IVIT00eUIFEQHF5YJFP02FUYJ0[Jf]P06@D51EUIFM7AdM7AdPX:2LG5a0UMGE`0651@DHF5QO7al
O7al4A4A>3Ph0Q/K6`05WYjNCDe=Bd];Bd];7alO009nOWh01V=SHbTY:@820P820U]KFgalO08X:2P0
1YFEUB@T95EEEEEEEHR8R5UIF@9aLG401HB4Q24Q8FMWIfMWIde=C@02<C4a00HL71`Q8B4/;2`/;2bO
Wilh>3P2Cdm?00IaLG5nOWh];Bd];Bdj>SXH61P2@41000HW9bMUIFEUIFEUIFE:BTX820P2;2`/00DT
92@/;2`/;2`V9RHJ6QX00Z:RXP06GUiNXJ6QM7AdM7Ad]KFeMgMg0[fm_@06@410DE5ACTi>CTi>QhN7
TY:B0T=3@`05H61P7QhN7QhN?ShnD51@008j>SX01UmOGgMgMe=CDe=CDa@D57MgM`8d=3@01WemOG1`
L;jn_[jn_VIVI/C4a0;;bl/01Jj^[SLg=inOWinOWg9bLP02M7Ad00J4Q8ACDe>l_;bl_;cjn_ZATI42
H61P00GJf][oooooooooool000007oooo`030000oooooooo00;oool01`000?ooooooooooo`000?oo
o`000003oooo00<0003oooooool00oooo`05`<308R8RmOGemOGehn?S009EEED01[Fe]GQhN:j^[Zj^
[ZFUYNc/k0:/[:`01Te=COoooo3`l?3`l;6a/C<c<`:a/K401J>SXc/k>c/k>de=CLS8b002<S8b00JT
Y:AUIFESHf=SHf=:BTYKFe/2`L7100ATI6@`<30`<31XJ6P3G5aL00I<C4`I6AUSHf=SHf>5QHD>3Ph2
B4Q800D71`MlO7`V9RHV9RHk>c/00Q8B4P06G5aLIVIV2`/;2`/;7AdMKfm_0X:2PP069bLWSHf=8R8R
8R8RHF5QRh^;0U=CD`05UYJFH61PH61P>c/kBTY:009OGel01Sdm?A@D524Q8B4Q8C<c<i6AT@8X:2P0
1FYZJUEEEEEEEInOWa8B4P02Fe]K00HC4a<e=CDg=cLg=cMHF5Q:BTX2IVIV00DV9RHc<c<n?Shn?Si9
BDT00PT92@06<30`_;blI6ATI6ATalO7A4A40/C4a005Xj>SPX:2IFEUIFEU<c<c008I6AT01[Fe]FMW
IeEEEEEEEGalO2`/;099BDT01RPX:6IVIVATI6ATI4e=CATI6@9RHV801D];BgalO7alO6ATI:ZZZP02
Shn?00IFEUK3`l?Cdm?Cdm>TY:@k>c/2^k^k00E2@T:d];C5aLG5aLF;Rh/00__kn`05ooooS8b<SXj>
SXj>j>SX00?oool00`000?ooooooo`0=oooo000Coooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000?oool00`000?ooooooo`04oooo00K2`/8M7AgKfm_Kfm_Shn=DE5@2^k^k00Eg
MgOAdM7AdM6k^k_`l?000YJFUP06EUIFoooolo?clo?cYjNW@d=30YfMW@06][JfFEUIHF5QHF5Q^KVi
?3`l0YVIV@03FEUIF5QHFUYJ009JFUX2][Jf00I1@D5FEUIdM7AdM7B2PX9aLG42EeMG00HD51AQHF5l
O7alO7`A4A4h>3P26a/K00FNWYi=CDe;Bd];Bd/O7al00WinOP06Hf=S:BTY0P820P82Fe]KO7al0RPX
:006UIFE92@TEEEEEEEER8R8FEUI0W5aL@05Q8B48B4QIfMWIfMWCDe=008a<C401Q`L724Q8B`/;2`/
;9nOWcPh>09?Cdl01W5aLGinORd];Bd];CXj>QPH6090@4001RLW9fEUIFEUIFEUIDY:BPP8208/;2`0
1B@T92`/;2`/;2HV9QXJ6P02XZ:R00INGUjQXJ5dM7AdM7Be]KEgMgL2_Kfm00I0@41ADE5>CTi>CTj7
QhNBTY82@d=300EPH60N7QhN7Qhn?Si@D5000SXj>P06GemOMgMgDe=CDe=C51@DMgMg0S@d=006OGem
L71`_[jn_[jnIVIVa<C40/_;b`05[Zj^=cLgWinOWinOLW9b009dM7@01XB4Q5=CDkbl_;bl_?[jnY6A
T@9PH6001M[Jf_ooooooooooo`00000Ooooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000?oool00`000?ooooooo`03oooo00G0`<0R8R;emOGemOGShn<00UEEE@06]KFeN7Qh[Zj^
[Zj^YJFUk>c/0Zb/[006CDe=ooool?3`l?3`/K6a<c<c0[6a/@05Xj>S>c/k>c/kCDe=b<S8008b<S80
1ZBTY6EUIF=SHf=SHdY:BU]KF`;1`L4016ATI30`<30`<6QXJ0=LG5`01Ta<C1TI6F=SHf=SHhF5Q@h>
3P98B4P01@L71galO2HV9RHV9S/k>`024Q8B00ILG5aVIVH;2`/;2`/M7Ae_Kfl2PX:200HW9bN=SHdR
8R8R8R9QHF6;Rh/2De=C00FFUYIPH61PH60k>c]:BTX00UmOG`06?Cdm51@D8B4Q8B4Q<c<cTI6A0RPX
:005JVYZEEEEEEEEWinO4Q8B009KFe/01Q<C4cDe=CLg=cLg=eQHF4Y:BP9VIVH01BHV9S<c<chn?Shn
?TU9B@022@T900H`<32l_;aTI6ATI6C7alM4A4@2a<C400FSXj>2PX9UIFEUIFDc<c<00QTI6@06]KFe
IfMWEEEEEEEEO7al;2`/0TU9B@06:2PXIVIVI6ATI6ATCDe=6ATI0V9RHP05Bd];O7alO7alI6ATZZZZ
00:?Shl01UIFE/?3`m?Cdm?CdjBTY3/k>`:k^k/01D92@[Bd]<G5aLG5aH^;R`02no_k00Gooon<S8b>
SXj>SXkXj>P00oooo`030000oooooooo00goool001;oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`02oooo00<0003oooooool01Oooo`05emOG92@T92@T?clo=CDe00;Kfm/01GEeMMgM
gMgMgLO7ao7al@02EUIF00KooolR8R;0`<30`<1HF5P92@T2Shn?00IiNGUbLW98B4Q8B4RPX:1`L702
UiNG00FMWIeRHV93@d=3@d=JFUX00];BdP06L71`820P^[Zj^[ZjB4Q8`L710Xb<S006?clo30`<XJ6Q
XJ6Q<C4a92@T0UYJFP05jNWY]KFe5ADE5ADEVIVI00;2`/801UEEEEQHF8Z:RXZ:RTI6ASDe=@98B4P0
1XJ6QVa/K0h>3Ph>3PH61VATI08J6QX01F9RHWUiNBXZ:RXZ:QLG5`02EeMG00HY:BV6QXHa<C4a<C5b
LW8`<302L71`00IPH615ADD;2`/;2`/61PI4A4@2PH6100IKFe]gMgLi>CTi>CTV9RHe=CD26a/K00Ek
Ng/d=3@d=3A?Cdm5ADD00V9RHP06A4A4E5ADI6ATI6ATMGEeK6a/0WQhN006NWYj;2`/ZZZZZZZZYJFU
IVIV0U=CD`05/[:b6ATI6ATIHF5Q51@D009^KVh01U9BDZ>SXalO7alO7bLW9eEEE@:9RHT01WIfMX>3
Pa@D51@D5?ooolS8b0:EUID01HN7Q`h>3Ti>CTi>CZ6QX@02[:b/00J2PX;ooonIVIVIVITk>c^RXZ82
oooo00F^[Zkoooooooooool000007_ooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`04oooo00Bn_[h;2`/;2`]ZJVX2G5aL00KVi^I0@43moOgmoOgdm?CJf]X2
=cLg00Koool:2P[@d=3@d=1BDU8820P2Ti>C00EYJFV6QXJ6QXIbLW;3`l<00T];B`06IVIVO7alY:BT
Y:BTKfm_820P0^WYj@05IfMW>c/k>c/k[jn_;Rh^00:d];@01X>3Pc@d=1PH61PH68^;RaDE5@8f=SH0
1GIfM[Jf]YBDU9BDU4];B`02KVi^00Jm_KecLg=>CTi>CTioOgmHF5P2DE5A00Ha<C5gMgMNGUiNGUhJ
6QXT92@2Cdm?00Dj>SY4A4A4A4AUIFDi>CT00P`<3006Hf=S7AdMO7alO7al92@TO7al0Slo?`05I6AT
MGEeMGEeCTi>>3Ph008Z:RX01Va/K6ATI61PH61PH71`L20P808k>c/01D51@AlO7h:2PX:2PSlo?`02
HV9R00INGUicLg=OGemOGel`<30d=3@2Rh^;00F@T916ATI<C4a<C4`J6QX00WYjNP06`<30@410GemO
GemOcLg=;bl_0W9bLP061PH6NWYjCdm?Cdm?RXZ:9BDU0T];B`05EeMG][Jf][JfGemORHV90090@400
1^?ShoGemLC4a<C4a9:BTS8b<P9`L7001IJFUYnOWg5aLG5aLOooo`02Ti>C00Dc<c>][JgooooooonM
WId00oooo`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0/30`006ooooMWIfoooo
ooooc<c<[jn_0UQHF005lo?c`L71`L718B4QIFEU00;`l?001ZRXZ7YjNWYjNWYjNTE5AD10@0:>SXh0
1T=3@aTI6I2@T92@T;2`/5=CD`;UiND01IBDU8V9RJZZZZZZZYFEU@024Q8B00I=CDe@D50];Bd];Bdl
?3cGemL2I6AT00IWIfMGEeMEEEEEEEEHF5QBDU82DE5A00GXj>R/[:`f=SHf=SIoOgl00X20P006ADE5
=CDeN7QhN7Qh=CDe>SXj0Ta<C006=SHf8b<SXZ:RXZ:R/K6aCTi>0TM7A`05GUiNNGUiF5QHF5QH:RXZ
008J6QX01RDU9BLW9cPh>3Ph>9nOWfMWI`9TI6@01WIfMSHf=TY:BTY:BSDe=EEEE@:QXJ401SXj>Tm?
C`D51@D51BLW9eEEE@9mOGd01E1@D4i>CTi>CVYZJR8R8P02V9RH00IKFe/_;bn;Rh^;Rh]^KVi;Bd/2
HF5Q00I@D50[:b]SHf=SHf=lO7bFUYH2MGEe00Fi^KUgMgMgMgLj>SX`<3000T51@@06T92@U9BDD51@
D51@Z:RXW9bL0TQ8B006PX:2XJ6QgmoOgmoOJFUYQhN70R@T9005@D51Y:BTZ:RXZ:RX10@4008b<S80
1^CTi;Vi^GIfMWIfMVUYJOooo`;>c/h4oooo00<0003oooooool0;?ooo`040000oooooooooooo0[Bd
]003ooooUiNGoooo00;oool2iNGU00J?Sho_knoUiNGUiNE0@41^KVh2alO700J;Rh]iNGUkNg]kNg]7
AdM:BTX2LW9b00E6ATHl?3`l?3bKVi_0`<000T51@@06/K6aKfm_]kNg]kNgd];BLW9b0S4a<@05D51@
IfMWIfMW7AdM@D5100;7alL01TQ8B4E5AFi^KVi^KS0`<3<c<`9ADE401Fa/K<_;bk6a/K6a/DI6AP02
HV9R00InOWiCDe=<C4a<C4aZJVXP8202CTi>00IDE5@S8b<T92@T92Bd];BPX:02GemO00Dg=cMCDe=C
De=[Jf]OGel00R0P800671`L820P8B4Q8B4Q>c/kW9bL0W5aL@05F5QHOgmoOgmo8R8RCdm?008j>SX0
1VUYJIjNWUeMGEeMGC@d=24Q8@8:2PX01FUYJG1`L5QHF5QHF4];B`02LW9b00Ha<C6b/[8f=SHf=SHO
7amiNGT2Lg=c00><S8`T92@/;2`00R`/;08g=cL01UYJFX61PHN7QhN7Qkno_h61P@8g=cL01Rl_;gQh
N7IfMWIfMTe=CEUIF@:LW9`01NGUiF1PH61PH7IfMY:BTP02aLG500IDE5BFUYHR8R8R8R9NGUjSXj<2
MWIf00Dl?3a2@T;MgMgMgMebLW800Tm?C`04IfMWoooomoOgmoOg1?ooo`030000oooooooo00goool0
02;oool00`000?ooooooo`04oooo00>d];Coooooool00_ooo`04f][JJVYZJVYZT92@0WemO@06hN7Q
oooo4a<C4a<CZ:RX=cLg0WalO006L71`TI6A<c<c<c<c=cLg?Shn0][JfP06O7alJf][cLg=cLg=XJ6Q
RXZ:0]3@d005QHF5U9BDU9BDR8R8ADE5008=3@d01TU9BF1PH6ATI6ATI1dM7G1`L09EEED01YbLW4a<
C3Ti>CTi>NOWii>CT`8R8R801Di>CU9BDU9BDUYJFWMgM`02IfMW00Hc<c<m?CdD51@D51@e=CDm?Cd2
DU9B00JBTY9EEED^;Rh^;Rj=SHd^;Rh2H61P00Dm?Cde=CDe=CFCTi<R8R800UADE006G5aL>3Ph?Shn
?Shn^k^k61PH0VEUI@06@T92CDe=MgMgMgMg5ADEJ6QX0TY:BP05JFUYT92@OWinOWin820P00:NWYh0
1P<30cDe=K:b/[:b/UEEEH:2PP8F5QH01T92@TA4A5iNGUiNGXf=SEmOG`:DU9@01E]KFmgMgG]kNg]k
Nnk^kP02V9RH00HX:2QIFEVVYZJVYZJYZJUfMWH27QhN00I2@T9FEUJ1PH61PH5VIVIcLg<2oooo00Ib
LW8B4Q9DE5ADE5CooomQHF42DE5A1?ooo`04oOgm@d=3@d=3e=CD0oooo`05lo?coooooooooooo0000
02koool00`000?ooooooo`03oooo00>ATI7oooooool00_ooo`:WYjL01YJFUV=SHgmoOgmoOlC4a?oo
o`8T92@01[Bd]3Lg=gMgMgMgMeiNGZBTY08O7al01E1@D4];Bd];BmOGefQXJ002I6AT00KIfMV6QXIW
IfMWIfN`/;2=SHd2_;bl00F[Zj]7AdM7AdLX:2P_;bl00Ti>CP06DE5A7AdMKFe]KFe]CDe=RHV90S`l
?0058R8Rbl_;];Bd];Bd4Q8B00<V9RH01EaLG6m_Kfm_KcDe=AdM7@02LG5a00Hd=3A@D50m?Cdm?Ceh
N7QcLg<2?clo00DM7AfATI6ATI4];BeFEUH00TE5A@06@d=3LW9bBDU9BDU9B4Q8;Bd]0TU9B@05ATI6
RXZ:RXZ:?ShnRHV9008Q8B401V9RHYZJVPd=3@d=3E]KFfATI09SHf<01I>CThJ6QQ/K6a/K6ifMW@02
61PH00HF5QKBd]9JFUYJFUYmOGda<C42M7Ad00DC4a=;Bd]jNWYjNWYkNg/00V=SH`06;bl_][JfRh^;
Rh^;e=CDLg=c0Q<C4`06:b/[g=cLVi^KVi^KBd];:RXZ0UMGE`05KVi^RXZ:RXZ:S8b<LW9b00;moOd0
1Zb/[34a<E=CDe=CDoooohn?S`8j>SX00o?cloooooooo`02oooo0S8b<P05fMWIooooooooooooh>3P
00?oool00`000?ooooooo`0=oooo000Roooo00<0003oooooool01?ooo`03];Bdoooooooo00;oool0
1=[JfVYZJVYZJY2@T09mOGd01^7QhOoooa<C4a<C4jRXZ3Lg=`9lO7`01W1`L96ATC<c<c<c<cLg=chn
?P;Jf]X01WalO6][Jlg=cLg=cJ6QXHZ:RP;@d=001HF5QIBDU9BDU8R8R4E5A@023@d=00I9BDUPH61T
I6ATI6@M7Ae`L702EEEE00JLW9a<C4`i>CTi>CWWinNCTi<28R8R00E>CTiBDU9BDU9JFUYgMgL00VMW
I`06<c<c?Cdm51@D51@D=CDe?Cdm0U9BDP06TY:BEEEE;Rh^;Rh^SHf=;Rh^0V1PH005?Cdm=CDe=CDe
Ti>C8R8R009DE5@01UaLG3Ph>3hn?Shn?[^k^aPH609UIFD01T92@Te=CGMgMgMgMaDE5FQXJ09:BTX0
1FUYJI2@T7inOWinOR0P8002WYjN00H30`<e=CFb/[:b/[9EEEF2PX825QHF00I2@T94A4ANGUiNGUj=
SHeOGel2U9BD00EKFe_MgMekNg]kNg_^k^h00YRHV006:2PXFEUIYZJVYZJVZJVYMWIf0QhN7P06@T92
EUIFPH61PH61IVIVLg=c0_ooo`06LW9b4Q8BE5ADE5ADooooHF5Q0U5AD@Coool01?gmoD=3@d=3@mCD
e0?oool01O?cloooooooooooo`00000^oooo00<0003oooooool00oooo`03TI6Aoooooooo00;oool2
YjNW00JFUYISHf=oOgmoOgo4a<Coool292@T00Jd];@g=cMgMgMgMgMNGUjTY:@27alO00E@D51;Bd];
Bd_GemMXJ6P00VATI006fMWIQXJ6IfMWIfMW/;2`SHf=0[bl_005Zj^[AdM7AdM7:2PX;bl_009>CTh0
1U5ADAdM7Fe]KFe]KDe=CHV9R@8l?3`01B8R8/_;bkBd];Bd]18B4P039RHV00ELG5a_Kfm_Kfle=CDM
7Ad00W5aL@06=3@dD51@?Cdm?CdmN7QhLg=c0Slo?`057AdMTI6ATI6A;Bd]EUIF0095ADD01T=3@g9b
LTU9BDU9BDQ8B2d];@99BDT01DI6AXZ:RXZ:RShn?XV9R@028B4Q00IRHV:JVYX=3@d=3@eKFe]TI6@2
Hf=S00FCTi>6QXHK6a/K6a^MWId00QPH60065QHFd];BFUYJFUYJOGem<C4a0WAdM0054a<CBd];NWYj
NWYjNg]k009SHf<01Rl_;kJf]X^;Rh^;RmCDe7=cL`8C4a<01R/[:mcLg9^KVi^KVd];BbXZ:P9GEeL0
1Fi^KXZ:RXZ:RXb<S79bLP02oOgm00J/[:`a<C5CDe=CDe?ooon?Shl2>SXj00?clo?oooooool00_oo
o`8b<S801MWIfOooooooooooon3Ph003oooo00<0003oooooool03Oooo`008_ooo`800005oooo00KX
j>R@T93ooooooom2@T;4a<@2oooo00Fh^;SooooooomcLg=YJFT00XN7Q`06SHf=71`LCDe=CDe=X:2P
^k^k0]kNgP06clo?cLg=T92@T92@6QXJb/[:0_knoP05X:2PYjNWQ8B4Q8B4=cLg00:[Zj/01Ti>CWIf
MV1PH61PH7=cLeaLG094A4@01SPh>4Q8B8b<S8b<S8F5QInOW`9ZJVX01Dm?Ce=CDifMWIfMWGQhN002
=cLg00HT92B][Jda<C4a<C4N7Qhc<c<2;Rh^00HK6a]PH61JFUYJFUZVYZIhN7P2<30`00EWIfLm?Cda
<C4a<C4m?Cd00VIVIP06UiNGA4A4B4Q8B4Q892@TDE5A0Sdm?@06O7al7QhNB4Q8B4Q83`l?8b<S0XJ6
QP06WinOLG5aLg=cLg=cTY:BOWin0VYZJP05AdM7UYJFUYJFN7Qh8R8R00;<c<`01Shn?TM7Ah20P820
P2@T92d];@9;Bd/01TI6AVe]KL;2`/;2`UYJFYbLW0:ATI401O_knfYZJVYZJU=CDb4Q8@02oooo00Jf
][IeMGFNWYjNWYiPH62@T90251@D00I;Bd]MGEgAdM7AdM5>CTi4A4@2IfMW00GZj^[UiNEmOGemOGeo
Ogl00_ooo`04f][JooooNg]kNg]k1oooo`80000^oooo0P0000Goool01<W9bOooooooo`L71`:`/;02
oooo0_KfmP06=3@dCdm?SXj>SXj>Ti>C;bl_0SDe=@05W9bL/[:bmoOgmoOgYZJV00;jn_X01/c<c2HV
9XJ6QXJ6Q[no_fEUI@9XJ6P01Fa/K6IVI/o?clo?cfi^KP02SXj>00EEEEELG5a5ADE5ADE1@D400b/[
:`06LG5aKVi^^[Zj^[ZjAdM7?3`l0VATI005UiNG@D51@D51=CDeDe=C00:;Rh/01RDU9B@T95UIFEUI
FEQHF3`l?09;Bd/01FATI:j^[XZ:RXZ:RQPH6002Kfm_00HE5AD];BeBDU9BDU9MGEeQHF42CTi>00D`
<30R8R:5QHF5QHDK6a/00T];B`06<C4aJFUY:RXZ:RXZ3@d=S8b<0Z6QX@06RXZ:K6a/V9RHV9RHQ8B4
C4a<0RDU9@05X:2PE5ADE5AD2PX:l?3`008P82001T];BjRXZ2<S8b<S8ahN7SDe=@9OGel01Fa/K:f]
[Jf][EmOGi:BTP02OGem00Kbl_9XJ6QHF5QHF5PG5aOoool2YjNW00EeMGFBTY9WIfMWIfMcLg<00Q`L
7006OWin;2`/k^k^k^k^EEEE<30`0XB4Q005oooo_[jnUYJFUYJFO7al00?oool00n[ZjY6ATI6AT@07
oooo0P0000ooool002;oool00`000?ooooooo`02oooo0Xf=S@03De=C>c/koooo00;oool019fMWO_k
no_kno[jnP:l_;`2oooo0]gMg@06alO7NGUiFe]KFe]KE5ADBDU90/30`006HV9Rclo?[Zj^[Zj^=SHf
L71`0__kn`054Q8B:RXZGEeMGEeMJVYZ009UIFD01Xj>SRPX:5EEEEEEEAhN7ZFUY@8/;2`01T51@CTi
>@`<30`<38^;RgmoO`9XJ6P01ALG5gemON[Zj^[ZjXB4Q00230`<00HV9RIADE6?Shn?Shm0@41DE5@2
IVIV00HH61Pd=3APH61PH61VIVI8B4P2Hf=S00Dc<c=DE5@30`<30`<^;Rh00UIFEP06MWIf=SHfBDU9
BDU9=3@d6QXJ0UeMG@06ZZZZBTY:DE5ADE5A9bLWADE50Vm_K`06MWIfLW9b<30`<30`3Ph>>3Ph0VMW
I`058B4Q:2PX:2PXADE5=SHf00:j^[X01V9RHUYJFW9bLW9bLUEEEB0P80:OWil01WalO7moOg1`L71`
L9^KVkFe]@:d];@01IfMWJJVYZJVYT10@<?3``02oooo00IVIVKemOF=SHf=SHeRHV;AdM42oooo00Im
OGd^;Rkooooooon6QXIIFET2[:b/00CooooRh^8e=CDe=CD3oooo00=]KFe`L73oool01Oooo`05fMWI
oooooooooooo000002koool010000?ooooooooooo`:?Shl00di>CT=3@oooo`02oooo0UYJFP03oooo
c/k>oooo00;oool01L;2`_ooooooomCDe8Z:RP02=cLg00E2@T90@43Cdm?Cdm=;Bd/00Zj^[P06U9BD
7QhNJFUYJFUYmOGe>CTi0SHf=P05Cdm?OGemFEUIFEUIRHV9008R8R801TU9BBDU9I>CTi>CTcXj>S0`
<08n?Sh01QDE5H20P8n?Shn?SeEEE@d=3@9^KVh01MSHf5aLG5aLG24Q8C`l?002CTi>00JMWIdl?3aC
De=CDe=LG5`410@27alO00F1PH5]KFf@T92@T90I6AT00VQXJ006820PBDU9?3`l?3`lF5QHCTi>0U9B
DP05>c/kA4A48b<S8b<SFEUI00:VYZH01VQXJ5iNGU9BDU9BDV][Jc8b<P:`/;001W9bLP/;2c@d=3@d
=492@Shn?P96ATH01D10@2DU9BDU9EEEEKJf]P02Jf][00IPH623Ph=LG5aLG5`M7AfNWYh2Ogmo00F=
SHeJFUYJFUYnOWkFe]H00YBDU006Kfm_aLG5Hf=SHf=SXj>Soooo0STi>@05`<30[Zj^GUiNGUiNl?3`
00;alO401Z6QXE=CDooooooooh:2PWIfMP:;Rh/01?oooi^KVh^;Rh^;R`;oool2]kNg00?5aLGooooo
ool01?ooo`05f][Joooooooooooo000000ooool002;oool00`000?ooooooo`04oooo00>IVIWooooo
ool00_ooo`04IfMWeMGEeMGE;2`/0UEEE@06QHF5b<S8m_Kfm_Kf71`LEUIF0Zj^[P06SXj>8R8Rn_[j
n_[jSXj>QHF50ZVYZ@067AdMIfMWLG5aLG5aLg=c1PH60[:b/P05_Kfm92@T92@TM7Ad:2PX008U9BD0
1S8b<TQ8B1lO7alO7`X:2QdM7@8W9bL2PH610WalO005J6QXEUIFUiNGUiNGF5QH0091@D401UQHF4m?
CgalO7alO5mOGa/K6`8R8R801S`l?4Q8B3@d=3@d=5MGEd];B`9GEeL01CDe=B@T92h^;Rh^;RTY:@02
7alO00I@D50b<S92@T92@T8j>SXN7Qh2ATI600H_;bmVIVJSXj>SXj=eMGDg=cL2Bd];00HZ:RY0@41T
I6ATI6@I6AULG5`2KFe]00Dk>c]5ADE5ADD`<30k>c/00V5QH@06KVi^Ti>C8B4Q8B4Q>3PhFe]K0X:2
PP06Fe]KD51@NGUiNGUiOWinZJVY0UEEE@05[Jf]OgmoOgmoQ8B4LW9b00:?Shl01Y6ATM[JfTE5ADE5
AHB4Q9nOW`;oool01UADE:JVYTI6ATI6A[bl_<S8b0;oool01L_;boWinOoooooooh^;R`02ADE500Go
ooo/k>cooooooonOWil01oooo`030000oooooooo02coool00`000?ooooooo`03oooo00>h^;Sooooo
ool00_ooo`9YJFT01_oooadM7H61PH61PI6ATOgmo@;<c<`01P/;2eEEEI:BTY:BTVm_KaPH60;De=@0
1Kno_h20P820P=_KfeADE002Cdm?00JSXj=ADE4_;bl_;bnPX:2][Jd2=SHf00=gMgLY:BTY:BT00SDe
=@8k>c/01Sdm?B<S8`L71`L71dM7AgUiN@9_Kfl01EiNGTa<C51@D51@D9BDU002BDU900Hn?SiLG5a>
CTi>CTijNWYLG5`27AdM00H@410N7Qi0@410@41KFe/j>SX2=SHf00EFEUH`<30`<319BDT[:b/00Rd]
;@06=CDeG5aL>CTi>CTi@T92<S8b0QPH6005DU9B3`l?3`l?R8R8_;bl009RHV801U9BDTY:BS/k>c/k
>c@d=4e=C@8U9BD01DQ8B7]kNclo?clo?di>CP02=cLg00Hc<c=CDe=NGUiNGUjc/k<d=3@2>3Ph00E`
L71bLW9YJFUYJFUNGUh00W=cL`06K6a//K6a>c/k>c/k][JfXZ:R0XZ:RP06UiNG]kNgS8b<S8b<^k^k
@d=30X61P@05XJ6QooooooooEeMG[:b/009HF5P01M[Jf^[Zj]SHf=SHf:f][@03oooo00E=CDe:BT[o
oooooonf][H00_ooo`03aLG5oooooooo00Goool00`000?ooooooo`0=oooo000Roooo00<0003ooooo
ool01?ooo`03VIVIoooooooo00;oool016MWImGEeMGEeB`/;09EEED01XF5QLS8b?Kfm_KfmQ`L75IF
EP:^[Zh01Xj>SR8R8_[jn_[jnXj>SXF5Q@:YZJT01QdM7FMWIg5aLG5aLG=cL`H61P:b/[801Kfm_B@T
92@T97AdM2PX:0029BDU00Hb<S98B4PO7alO7al:2PXM7Ad29bLW0X61P@9lO7`01FQXJ5IFEYNGUiNG
UeQHF002@D5100IHF5Q?CdmlO7alO7aOGelK6a/28R8R00Hl?3a8B4Pd=3@d=3AGEeM;Bd/2EeMG00De
=CDT92@^;Rh^;RhY:BT00QlO7`06D51@<S8b@T92@T92>SXj7QhN0TI6AP06;bl_IVIVXj>SXj>SMGEe
=cLg0T];B`06:RXZ@410I6ATI6AT6ATIG5aL0Ve]K@05>c/kADE5ADE5<30`>c/k009QHF401Vi^KY>C
Tb4Q8B4Q8CPh>5]KF`:2PX801U]KFe1@D7UiNGUiNGinOZVYZ@9EEED01Jf][GmoOgmoOhB4Q79bLP02
Shn?00JATI7Jf]Y5ADE5ADF4Q8BOWil2oooo00IDE5BVYZI6ATI6ATJl_;c8b<P2oooo00G;bl_inOWo
oooooon;Rh/00TE5A@05ooook>c/ooooooooWinO00Ooool00`000?ooooooo`0/oooo00<0003ooooo
ool00oooo`03^;Rhoooooooo00;oool2JFUY00KooolM7Af1PH61PH6ATI7moOd2c<c<00H;2`]EEEFB
TY:BTY9_KflH61P2e=CD00Fo_kn0P820P83Kfm]DE5@00Tm?C`06Xj>SDE5A;bl_;bl_X:2P[Jf]0SHf
=P03MgMg:BTY:BTY008e=CD2>c/k00Hm?CdS8b<71`L71`M7AdMiNGT2Kfm_00ENGUi<C4a@D51@D52D
U9@00TU9B@06?ShnG5aLCTi>CTi>NWYjG5aL0QdM7@06410@7QhN@410@410Fe]K>SXj0SHf=P05EUIF
<30`<30`BDU9:b/[008];Bd01SDe=EaLG3Ti>CTi>D92@S8b<P8H61P01E9BDPl?3`l?3hR8R;bl_002
HV9R00IBDU9:BTXk>c/k>c/d=3A=CDd29BDU00E8B4QkNg/o?clo?cm>CTh00SLg=`06<c<cDe=CGUiN
GUiN/k>c=3@d0SPh>005L71`LW9bJFUYJFUYGUiN009cLg<01Va/K;6a/C/k>c/k>kJf]Z:RXP::RXX0
1YNGUkNg]hb<S8b<S;^k^d=3@`:1PH401J6QXOoooooooeMGEjb/[002F5QH00GJf][Zj^[Hf=SHf=R]
[Jd00oooo`05CDe=BTY:oooooooo][Jf00;oool00lG5aOooooooo`05oooo00<0003oooooool03Ooo
o`008_ooo`030000oooooooo00coool01FQXJ?oooooooaPH6?Cdm002F5QH00Koool[:b^GUiNGUiM6
ATK?cll2[Jf]00J?Shn@T91`L71`L726QXI[Jf/2GUiN00EQHF4`<31cLg=cLg?@d=000XV9R@06D51@
Rh^;<S8b<S8bc/k>ADE50[Jf]P06Kfm_LG5aQXJ6QXJ6GEeMATI60U5AD@05B4Q8UYJF6a/K6a/KHF5Q
008F5QH01TI6AZj^[Q8B4Q8B4UEEEF][J`:4Q8@01Q@D54i>CVm_Kfm_KgYjNSLg=`8o?cl01A8B4Xj>
SR<S8b<S8clo?`02JFUY00JTY:@10@6:RXZ:RXY9BDV8R8P2DE5A00IIFEWEeMFEUIFEUIDj>SXd=3@2
De=C00JPX:0m?CedM7AdM7BUYJEMGEd2SHf=00E]KFeIFEUIFEUeMGFMWId00W1`L006S8b<=SHf<C4a
<C4aEeMGTY:B0WIfMP06IfMWD51@CDe=CDe=GemOm_Kf0S<c<`05R8R8[Zj^[Zj^Jf][CTi>00;De=@0
1/?3`kZj^_ooooooohR8R7moO`:l_;`2oooo0V5QH@06NGUi_;blXj>SXj>SUiNGoooo0WMgM`03oooo
C4a<C4a<00;oool2/;2`2?ooo`030000oooooooo02coool00`000?ooooooo`0:oooo00Jf][K6a/Ko
oooooooclo>_[jl2M7Ad00Kooolk>c^XZ:RXZ:QBDU;<c<`2?3`l00Gooolh>3Ph>3SgmoN9RHT00[fm
_@06];BdN7Qhb/[:b/[:fm_KYjNW0V=SH`0592@TK6a/K6a/D51@W9bL008C4a<01Z:RX[fm_GalO7al
O<C4a24Q8@9RHV801CHf=S@d=9fMWIfMWA0@4002IFEU00H410@W9bN=SHf=SHdb<S9jNWX2JFUY00JJ
VYY1@D5MGEeMGEebLW:6QXH2FEUI00DB4Q93@d=3@d=NGUi1@D400V5QH@06Bd];T92@5QHF5QHFXJ6Q
Cdm?0Va/K005ATI6Kfm_Kfm_Xj>SLg=c009KFe/01Rd];DA4A;fm_Kfm_D10@861P@:e]KD01FYZJWin
OUYJFUYJFW9bLP02F5QH00JQXJ68R8R0P820P816ATI^KVh2=3@d00EaLG5UIFEWIfMWIfMQHF400TU9
B@06ATI6aLG58b<S8b<SemOGdm?C0ZRXZ006KFe]S8b<o_kno_knooooe]KF0VIVIP05:b/[WYjNWYjN
bl_;oooo0098B4P01XF5QDI6A_ooooooof5QHOooo`:ZZZX01Nk^k_gmoB4Q8B4Q8Oooo`02V9RH2?oo
o`030000oooooooo00goool002;oool00`000?ooooooo`2aoooo00<0003oooooool0;?ooo`030000
oooooooo0;7oool00`000?ooooooo`0=oooo000Roooo0P0000;oool00`000?ooooooo`0Hoooo00<0
003oooooool06?ooo`030000oooooooo01Soool00`000?ooooooo`0Hoooo00<0003oooooool06?oo
o`030000oooooooo01Soool00`000?ooooooo`0:oooo0P0002koool2000000?oool0003oool06_oo
o`030000oooooooo01Soool00`000?ooooooo`0Hoooo00<0003oooooool06?ooo`030000oooooooo
01Soool00`000?ooooooo`0Hoooo00<0003oooooool02_ooo`80000?oooo000Roooo]@0002kooone
00003oooo`00oooool[oool00?ooooo:oooo003ooooob_ooo`00oooool[oool005koool300007Ooo
o`<0003Hoooo0`0001goool30000COooo`00Goooo`030000oooooooo01goool00`000?ooooooo`3H
oooo00<0003oooooool07Oooo`030000oooooooo04coool0053oool300000_ooo`D000001Oooo`00
0?ooo`000?ooo`0300000_ooo`<00003oooo0P0000koool300000_ooo`<00003oooo0P0000;oool3
00000oooo`800002oooo0`0000?oool4000000Coool0003oool0001joooo0`000007oooo00000000
0000oooo0000oooo00<00002oooo0`0000?oool200000oooo`800003oooo0`0000koool300000_oo
o`D000001Oooo`000?ooo`000?ooo`0300000_ooo`<00003oooo0P0000koool300000_ooo`<00003
oooo0P0000;oool300000oooo`800002oooo0`0000?oool4000000Coool0003oool0000]oooo001@
oooo00<0003oool000000_ooo`<000002?ooo`000?ooo`000?ooo`000?ooo`0000;oool010000?oo
ooooo`0000?oool00`000?ooooooo`0>oooo00<0003oool000000_ooo`060000oooooooo0000oooo
00001?ooo`030000oooooooo00;oool010000?ooooooo`0000;oool01@000?ooooooooooo`000002
oooo0P000004oooo0000oooo0000N_ooo`030000oooo000000;oool010000?ooooooo`0000;oool0
0`000?ooooooo`02oooo00D0003oooooooooool000000_ooo`030000oooo000000Coool010000?oo
ooooo`0000koool00`000?ooo`000002oooo0`000008oooo0000oooo0000oooo0000oooo00000_oo
o`040000oooooooo00000oooo`030000oooooooo00koool00`000?ooo`000002oooo00H0003ooooo
ool0003oool00004oooo00<0003oooooool00_ooo`040000oooooooo00000_ooo`050000oooooooo
oooo000000;oool2000000Coool0003oool0000]oooo001Boooo00<0003oooooool00_ooo`090000
oooo0000oooo0000oooo0000oooo000000;oool010000?ooooooo`0000?oool300004?ooo`040000
oooooooo00000_ooo`030000oooo000000800002oooo00<0003oooooool00_ooo`030000oooooooo
00?oool01@000?ooooooooooo`000002oooo0P000004oooo0000oooo0000O?ooo`040000oooooooo
00000_ooo`040000oooooooo00001?ooo`050000oooooooooooo000000Coool300000_ooo`040000
oooooooo00004?ooo`030000oooooooo00;oool02@000?ooo`000?ooo`000?ooo`000?ooo`000002
oooo00@0003oooooool00003oooo0`00013oool010000?ooooooo`0000;oool00`000?ooo`000002
00000_ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00D0003oooooooooool000000_oo
o`8000001?ooo`000?ooo`0002goool0057oool00`000?ooooooo`02oooo0P000006oooo00000000
oooo0000oooo100000?oool010000?ooooooooooo`<0000?oooo00<0003oooooool0100000;oool3
00000_ooo`<000000oooo`000000000200000_ooo`H000000oooo`0000000002000000?oool0003o
ool0Noooo`040000oooooooooooo0`0000;oool200000oooo`<000000oooo`000000000200000_oo
o`<00003oooo0`0000ooool00`000?ooooooo`02oooo0P000006oooo00000000oooo0000oooo1000
00?oool010000?ooooooooooo`<0000?oooo00<0003oooooool0100000;oool300000_ooo`<00000
0oooo`000000000200000_ooo`H000000oooo`0000000002000000?oool0003oool0;Oooo`00D?oo
o`030000oooo000001;oool00`000?ooooooo`0Boooo00<0003oool000004Oooo`030000oooooooo
08[oool00`000?ooo`000002oooo00<0003oooooool02?ooo`050000oooooooooooo000000coool0
0`000?ooooooo`0<oooo00<0003oool000004_ooo`030000oooooooo01;oool00`000?ooo`00000A
oooo00<0003oooooool0?Oooo`00D?ooo`<0000Aoooo0P0001Coool30000W_ooo`<000000oooo`00
00000005oooo00<0003oooooool00oooo`030000oooooooo00coool200003_ooo`<0000Aoooo0P00
01Coool30000DOooo`00oooool[oool00?ooooo:oooo003ooooob_ooo`00oooool[oool00?ooooo:
oooo003ooooob_ooo`00oooool[oool00?ooooo:oooo0000\
\>"],
  ImageRangeCache->{{{0, 456}, {216.563, 0}} -> {-0.0528233, -0.0238146, 
  0.00461765, 0.00461765}, {{11.4375, 217.688}, {211.375, 
  5.125}} -> {-28.2299, -14.7243, 0.740064, 0.740064}, {{238.313, 444.5}, {
  211.375, 5.125}} -> {-196.109, -14.7243, 0.740064, 0.740064}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ Correlation\ after\ Fourier\ transfroms\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
corRelation[Flatten[SampleFourier],Flatten[ShiftedSampleFourier]]\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(0.995115010395650045`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{523, 362},
WindowMargins->{{126, Automatic}, {Automatic, 18}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 134, 2, 30, "Input"],
Cell[1846, 53, 111, 2, 30, "Input"],
Cell[1960, 57, 72, 1, 30, "Input"],
Cell[2035, 60, 57, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[2117, 65, 65, 1, 30, "Input"],
Cell[2185, 68, 44, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2266, 74, 165, 5, 66, "Input"],
Cell[2434, 81, 90559, 1889, 296, 40096, 1261, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[93008, 1973, 62, 1, 27, "Input"],
Cell[93073, 1976, 55, 1, 30, "Input"],
Cell[93131, 1979, 90, 1, 50, "Input"],
Cell[93224, 1982, 102, 2, 50, "Input"],
Cell[93329, 1986, 102, 2, 50, "Input"],
Cell[93434, 1990, 90, 1, 50, "Input"],

Cell[CellGroupData[{
Cell[93549, 1995, 202, 4, 70, "Input"],
Cell[93754, 2001, 89550, 1876, 296, 40096, 1261, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[183319, 3880, 74, 1, 27, "Input"],
Cell[183396, 3883, 172, 5, 66, "Input"],
Cell[183571, 3890, 50, 0, 30, "Input"],
Cell[183624, 3892, 64, 1, 30, "Input"],
Cell[183691, 3895, 166, 5, 66, "Input"],
Cell[183860, 3902, 90, 1, 50, "Input"],
Cell[183953, 3905, 102, 2, 50, "Input"],
Cell[184058, 3909, 102, 2, 50, "Input"],
Cell[184163, 3913, 90, 1, 50, "Input"],

Cell[CellGroupData[{
Cell[184278, 3918, 265, 7, 102, "Input"],
Cell[184546, 3927, 167424, 3617, 252, 80512, 2540, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[351985, 7547, 63, 1, 27, "Input"],
Cell[352051, 7550, 512, 13, 210, "Input"],

Cell[CellGroupData[{
Cell[352588, 7567, 88, 1, 30, "Input"],
Cell[352679, 7570, 55, 1, 29, "Output"]
}, Open  ]],
Cell[352749, 7574, 80, 1, 30, "Input"],
Cell[352832, 7577, 142, 4, 48, "Input"],

Cell[CellGroupData[{
Cell[352999, 7585, 436, 11, 174, "Input"],
Cell[353438, 7598, 353091, 5909, 226, 80543, 2540, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[706544, 13510, 89, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[706658, 13515, 115, 3, 30, "Input"],
Cell[706776, 13520, 55, 1, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

