(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1082109,      22875]*)
(*NotebookOutlinePosition[   1082759,      22898]*)
(*  CellTagsIndexPosition[   1082715,      22894]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(fukuzawa3 = Table[fukuzawa[\([i, j]\)], {i, 20, 147}, {j, 10, 137}]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ 128\[Times]128\ simple\)], "Input"],

Cell[BoxData[
    \(\(sample = fukuzawa3; \)\)], "Input"],

Cell[CellGroupData[{

Cell["size=Dimensions[sample]", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \({128, 128}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SamplePhoto=ListDensityPlot[sample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Sample Photo\"];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`02oooo100000coool700001_ooo`800006oooo0P00
00;oool200000_ooo`l00006oooo0P0000Coool200001?ooo`800008oooo1@0000;oool@00000_oo
o`800002oooo3@0000;oool400001?ooo`X00002oooo0P0000Coool300001_ooo`800002oooo0P00
00Coool200001?ooo`H00002oooo10000003oooo0000000000800002oooo0P0000Coool:00000_oo
o`@00006oooo0`0001Goool00`000?ooooooo`02oooo000Aoooo00<0003oool000001?ooo`030000
oooooooo00;oool400003?ooo`L00006oooo0P0000Koool200000_ooo`800002oooo3`0000Koool2
00001?ooo`800004oooo0P0000Soool500000_oooa000002oooo0P0000;oool=00000_ooo`@00004
oooo2P0000;oool200001?ooo`<00006oooo0P0000;oool200001?ooo`800004oooo1P0000;oool4
000000?oool0000000000P0000;oool200001?ooo`X00002oooo100000Koool300005Oooo`030000
oooooooo00;oool001;oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`@00004oooo1P00
00;oool200001Oooo`800004oooo0P0000;oool200001?ooo`X00002oooo0P0000?oool:00001?oo
o`@00004oooo4`0000;oool200000_ooo`H00002oooo0P0000;oool400001oooo`@00002oooo0P00
00Koool600000_ooo`@00002oooo0P00017oool200001_ooo`80000:oooo0P0000?oool600001_oo
o`@0000:oooo100000;oool00`000?ooooooo`04oooo0P0000Koool200001oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooo100000Coool600000_ooo`800005oooo0P0000Coool2
00000_ooo`800004oooo2P0000;oool200000oooo`X00004oooo100000CooolC00000_ooo`800002
oooo1P0000;oool200000_ooo`@00007oooo100000;oool200001_ooo`H00002oooo100000;oool2
00004Oooo`800006oooo0P0000[oool200000oooo`H00006oooo100000[oool400000_ooo`030000
oooooooo00Coool200001_ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool200000_ooo`800002oooo100000;oool500001?ooo`800002oooo0P0000Soool200000_oo
o`P00004oooo1@0000Soool400002?ooo`@00002oooo100000?oool400001?ooo`H00004oooo0P00
00;oool200001?ooo`@00003oooo0P0000Soool200000_ooo`H00002oooo0P0000;oool200001ooo
o`H00006oooo3P0000;oool200002Oooo`800002oooo0P0000;oool400000_ooo`X00002oooo1@00
00;oool:00000_ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool2
00000_ooo`800002oooo100000;oool500001?ooo`800002oooo0P0000Soool200000_ooo`P00004
oooo1@0000Soool400002?ooo`@00002oooo100000?oool400001?ooo`H00004oooo0P0000;oool2
00001?ooo`@00003oooo0P0000Soool200000_ooo`H00002oooo0P0000;oool200001oooo`H00006
oooo3P0000;oool200002Oooo`800002oooo0P0000;oool400000_ooo`X00002oooo1@0000;oool:
00000_ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool200000_oo
o`800006oooo0P0000Coool00`000?ooooooo`02oooo1P0000;oool400000_ooo`P00004oooo0P00
00;oool300000_ooo`X00004oooo200000;oool;00000_ooo`P00002oooo100000Coool800000_oo
o`L00002oooo300000;oool400000_ooo`P00003oooo0P0000;oool400000_ooo`@00002oooo1P00
00Coool900001_ooo`800002oooo1P0000;oool200000_ooo`X000000oooo`0000000002oooo1P00
00;oool200002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo0P0000;oool2
00001_ooo`800004oooo00<0003oooooool00_ooo`H00002oooo100000;oool800001?ooo`800002
oooo0`0000;oool:00001?ooo`P00002oooo2`0000;oool800000_ooo`@00004oooo200000;oool7
00000_ooo``00002oooo100000;oool800000oooo`800002oooo100000;oool400000_ooo`H00004
oooo2@0000Koool200000_ooo`H00002oooo0P0000;oool:000000?oool0000000000_ooo`H00002
oooo0P0000Woool00`000?ooooooo`02oooo000Hoooo0P0000?oool800000_ooo`800006oooo1`00
00Koool600003_ooo`D00006oooo2P0000;oool600000_ooo`800005oooo100000;oool200001?oo
o`800002oooo0P0000;oool200001?ooo`800002oooo0P0000;oool200000oooo`H00002oooo1P00
00Koool200001_ooo`/00006oooo100000;oool800000_ooo`800009oooo1P0000;oool<00001?oo
o`800002oooo0P000003oooo0000000000Koool200001?ooo`800006oooo0P0000Coool001Soool0
0`000?ooooooo`02oooo200000;oool200001_ooo`L00006oooo1P0000koool500001_ooo`X00002
oooo1P0000;oool200001Oooo`@00002oooo0P0000Coool200000_ooo`800002oooo0P0000Coool2
00000_ooo`800002oooo0P0000?oool600000_ooo`H00006oooo0P0000Koool;00001_ooo`@00002
oooo200000;oool200002Oooo`H00002oooo300000Coool200000_ooo`8000000oooo`0000000006
oooo0P0000Coool200001oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo1000
00Coool200001_ooo`<00002oooo0P0000Coool200002_ooo`P00004oooo0P0000?oool400000_oo
o`H00002oooo0P0000Coool?00001_ooo``00002oooo100000;oool200001?ooo`800005oooo0P00
00;oool200000_ooo`800002oooo0P0000;oool200001?ooo`800004oooo0P000003oooo00000000
00X00008oooo100000Coool=00001_ooo`@00004oooo100000;oool200000_ooo`@00003oooo0P00
00Coool200001?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool4
00001?ooo`800006oooo0`0000;oool200001?ooo`80000:oooo200000Coool200000oooo`@00002
oooo1P0000;oool200001?ooo`l00006oooo300000;oool400000_ooo`800004oooo0P0000Goool2
00000_ooo`800002oooo0P0000;oool200000_ooo`800004oooo0P0000Coool2000000?oool00000
00002P0000Soool400001?ooo`d00006oooo100000Coool400000_ooo`800002oooo100000?oool2
00001?ooo`800004oooo0P0000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool02?oo
o`800002oooo0P0000;oool4000000?oool0000000000_ooo`X00002oooo100000;oool200002_oo
o`D00006oooo0P0000Coool600002_ooo`<00006oooo2P0000;oool600000_ooo`800002oooo2`00
00;oool200000_ooo`@00004oooo0P0000Coool200002?ooo`<00002oooo0P0000;oool200000_oo
o`800004oooo0P0000Koool200000_ooo`@0000?oooo100000Soool200001?ooo`D00006oooo1P00
00;oool200001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08oooo0P0000;oool2
00000_ooo`@000000oooo`0000000002oooo2P0000;oool400000_ooo`80000:oooo1@0000Koool2
00001?ooo`H0000:oooo0`0000Koool:00000_ooo`H00002oooo0P0000;oool;00000_ooo`800002
oooo100000Coool200001?ooo`800008oooo0`0000;oool200000_ooo`800002oooo0P0000Coool2
00001_ooo`800002oooo100000ooool400002?ooo`800004oooo1@0000Koool600000_ooo`800005
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Coool600001?ooo`H00003oooo0P00
00;oool200000_ooo`P00002oooo100000Coool200001?ooo`<00006oooo6P000003oooo00000000
00;oool600002_ooo`@00002oooo0P0000Coool4000000?oool0000000001_ooo`800004oooo1P00
00;oool200000_ooo`800004oooo0`0000Koool<00001_ooo`800002oooo0P0000;oool200000ooo
o`P00004oooo0P0000;oool>00000_ooo`030000oooooooo00coool200001oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`04oooo1P0000Coool600000oooo`800002oooo0P0000;oool8
00000_ooo`@00004oooo0P0000Coool300001_oooaX000000oooo`0000000002oooo1P0000[oool4
00000_ooo`800004oooo10000003oooo0000000000Koool200001?ooo`H00002oooo0P0000;oool2
00001?ooo`<00006oooo300000Koool200000_ooo`800002oooo0P0000?oool800001?ooo`800002
oooo3P0000;oool00`000?ooooooo`0<oooo0P0000Ooool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool03_ooo`800009oooo0P0000;oool200001?ooo`800004oooo0P0000Koool400000_oo
o`030000oooooooo00@00002oooo0P0000;oool400002?ooo`P00002oooo00<0003oooooool01?oo
o`800004oooo0P0000;oool200000_ooo`H00004oooo0P0000;oool200001Oooo`P00002oooo0P00
00Soool200001_ooo`L00008oooo0P0000;oool400000_ooo`P0000;oooo0P0000;oool400000_oo
o`H00002oooo0P0000;oool600000oooo`P00002oooo1P0000Goool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_ooob<00002ooooEP00027oool200000_ooo`<0000:oooo0P0000coool2
00001_ooo`<00004oooo0P0000[oool200001?ooo`800004oooo0P0000Woool400000_ooo`H00005
oooo00<0003oooooool00_ooo`006?ooo`800003oooo8`0000;ooomF00008Oooo`800002oooo0`00
00[oool200003?ooo`800006oooo0`0000Coool200002_ooo`800004oooo0P0000Coool200002Ooo
o`@00002oooo1P0000Coool200001?ooo`006?ooo`030000oooooooo00;oool800002?ooobD00000
0oooo`000000000H00000_ooobh00004oooo7@0000;ooom100000oooo`800006oooo0P0000;oool2
00002Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo200000SooolU000000?o
ool000000000600000;oool^00001?oooad00002oooo@@0000?oool200001_ooo`800002oooo0P00
00Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooocH00002oooo1P0000Soool4
00001?ooo`80000;oooo1P0000;oool200001_ooo`H00002oooo100000Koool00`000?ooooooo`02
oooo2P0000Koool800000_ooo`@000000oooo`000000000400001?ooo`@00002ooooB00000Goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooocH00002oooo1P0000Soool400001?oo
o`80000;oooo1P0000;oool200001_ooo`H00002oooo100000Koool00`000?ooooooo`02oooo2P00
00Koool800000_ooo`@000000oooo`000000000400001?ooo`@00002ooooB00000Goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooobT00002oooo2`0000;oool400007?ooo`L00002
oooo0P0000;oool200002?ooo`l00002oooo100000;oool800002?ooo`800006oooo0P0000?oool8
00001?ooodX00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;ooolY00000_oo
o`/00002oooo100001coool700000_ooo`800002oooo0P0000Soool?00000_ooo`@00002oooo2000
00Soool200001_ooo`800003oooo200000Cooom:00001Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`02oooo;@0000;oool600000oooo``00002oooo1P00017oool800001?ooo`P00002
oooo100000;oool500001_ooo`800004oooo0P0000Coool>00000_ooo`T00002oooo6@0000;oool2
00000_ooo`800006oooo0P0000[ooolK00001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo;@0000;oool600000oooo``00002oooo1P00017oool800001?ooo`P00002oooo1000
00;oool500001_ooo`800004oooo0P0000Coool>00000_ooo`T00002oooo6@0000;oool200000_oo
o`800006oooo0P0000[ooolK00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo200000Koool400000oooob<00002oooo3P0000;oool600001?ooo`800009oooo0P0000;oool2
00001?ooo`800002oooo100000Soool900001?ooo`800002oooo1P0000Soool/00000_ooo`80000H
oooo0P0000Ooool200003?ooo`800005oooo00<0003oooooool00_ooo`006?ooo`800003oooo2000
00Koool400000oooob<00002oooo3P0000;oool600001?ooo`800009oooo0P0000;oool200001?oo
o`800002oooo100000Soool900001?ooo`800002oooo1P0000Soool/00000_ooo`80000Hoooo0P00
00Ooool200003?ooo`800004oooo0P0000Coool001Soool00`000?ooooooo`02oooo;`0000_oool@
00000_ooo`@00004oooo2@0001;oool400000_ooo`@00002oooo3@0000Coool400000_ooo`800002
oooo6@0000;ooolC00000_ooo`80000@oooo100000Coool200001oooo`800008oooo0P0000Woool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooobl0000;oooo400000;oool400001?oo
o`T0000Boooo100000;oool400000_ooo`d00004oooo100000;oool200000_oooaT00002oooo4`00
00;oool200004?ooo`@00004oooo0P0000Ooool200002?ooo`800009oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;ooola00000_ooo`<00006oooo600003;oool200003?oooa/00004
oooo5@0000Koool<00001_ooo`@00002oooo1`0000Coool400002Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo<@0000;oool300001_oooaP0000boooo0P0000cooolK00001?oo
oaD00006oooo300000Koool400000_ooo`L00004oooo100000Woool00`000?ooooooo`02oooo000H
oooo00<0003oooooool02_oooa/00002oooo0P0000;oool400002?ooo`030000oooooooo00Koool4
00003?ooo`800002oooo0P0004Koool200001?ooo`030000oooooooo00800008oooo0P0000SooolA
00002_ooo`800002oooo100000Koool200001?ooo`D00004oooo0P0000;oool200002Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0:oooo6`0000;oool200000_ooo`@00008oooo00<0
003oooooool01_ooo`@0000<oooo0P0000;oool20000A_ooo`800004oooo00<0003oooooool00P00
00Soool200002?oooa40000:oooo0P0000;oool400001_ooo`800004oooo1@0000Coool200000_oo
o`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool600002?oooa/00002
oooo0P0000Woool200006_ooo`80000Eoooo0P0002goool200004oooo`800002oooo0P0000Soool=
00002_ooo`800002oooo100000Koool200001oooo`800008oooo0P0000Woool00`000?ooooooo`02
oooo000<oooo0`0000?oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`H00008oooo6`00
00;oool200002Oooo`80000Joooo0P0001Goool20000;Oooo`80000Coooo0P0000;oool200002?oo
o`d0000:oooo0P0000;oool400001_ooo`800007oooo0P0000Soool200002Oooo`030000oooooooo
00;oool000coool00`000?ooooooo`02oooo00<0003oool000001?ooo`030000oooooooo00;oool6
00002?oooa<0000aoooo0P0000_oool200002?ooo`@0000Soooo0P0000;oool200005oooo`80000>
oooo3@0002Woool200002Oooo`030000oooooooo00;oool000goool01`000?ooooooooooo`000?oo
o`000004oooo0`0000;oool600002?oooa<0000aoooo0P0000_oool200002?ooo`@0000Soooo0P00
00;oool200005oooo`80000>oooo3@0002Woool200001oooo`<00004oooo000=oooo00L0003ooooo
ooooool0003oool000001?ooo`030000oooooooo00;oool600002?ooo`L0000:oooo0P0000[oool2
00003oooo`80000Doooo0P0000Ooool200001?ooo`80000:oooo0P0002Goool200000_ooo`@0000=
oooo0P0000Coool200002?ooo`800004oooo3@0000Coool400000_ooo`@00006oooo100000Goool4
00001_ooo`800009oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?oo
o`000004oooo00<0003oooooool00_ooo`H00008oooo1`0000[oool200002_ooo`80000?oooo0P00
01Coool200001oooo`800004oooo0P0000[oool200009Oooo`800002oooo100000goool200001?oo
o`800008oooo0P0000Coool=00001?ooo`@00002oooo100000Koool400001Oooo`@00006oooo0P00
00Woool00`000?ooooooo`02oooo000=oooo00<0003oooooool00_ooo`030000oooooooo00?oool0
0`000?ooooooo`02oooo1P0000Coool900001_ooo`H00008oooo0P0000;oool200000_ooo`800005
oooo100001Soool200001Oooo`800004oooo0P0000;oool200001_ooo`80000:oooo0P0000;oool2
00005oooo`800002oooo100000_oool200001_ooo`H0000Aoooo500000Koool400000_ooo`030000
oooooooo00@00006oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`H00004oooo2@0000Koool600002?ooo`800002oooo0P0000;oool200001Oooo`@0000Hoooo0P00
00Goool200001?ooo`800002oooo0P0000Koool200002_ooo`800002oooo0P0001Ooool200000_oo
o`@0000;oooo0P0000Koool600004Ooooa@00006oooo100000;oool00`000?ooooooo`0400001_oo
o`@00007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool600000_ooo`X00009
oooo0P0000Soool600001?ooo`80000Qoooo0P0000Goool200002?ooo`800008oooo0P0000coool2
00004oooo`800004oooo1P0000Woool800001?ooo`@00004oooo0P0000;oool200002oooo`@00002
oooo100000Coool400001?ooo`@00005oooo0P0000Soool400001oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`02oooo1P0000;oool:00002Oooo`800008oooo1P0000Coool200008Ooo
o`800005oooo0P0000Soool200002?ooo`80000<oooo0P0001?oool200001?ooo`H00009oooo2000
00Coool400001?ooo`800002oooo0P0000_oool400000_ooo`@00004oooo100000Coool400001Ooo
o`800008oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`h0000;
oooo0P0000;oool200003?ooo`@0000Soooo0P0000ooool200002?ooo`800008oooo0P0000Coool0
0`000?ooooooo`0<oooo100000Coool800001oooo`800006oooo0P0000Koool600005Oooo`800004
oooo1P0000Coool600001Oooo`@00006oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_ooo`h0000;oooo0P0000;oool200003?ooo`@0000Soooo0P0000ooool200002?oo
o`800008oooo0P0000Coool00`000?ooooooo`0<oooo100000Coool800001oooo`800006oooo0P00
00Koool600005Oooo`800004oooo1P0000Coool600001Oooo`@00006oooo100000Ooool00`000?oo
ooooo`02oooo000Hoooo0P0000?oool:00004oooo`800002oooo100000Koool200002oooo`80000H
oooo0P00017oool200002?ooo`80000:oooo0`0001Koool800001Oooo`H00004oooo0P0000Koool6
00001_ooo`@0000Eoooo100000Coool400000oooo`80000:oooo0P0000Soool200001?ooo`006?oo
o`030000oooooooo00;oool>00004Oooo`H0000Coooo0P0001Soool200006oooo`@0000:oooo00<0
003oooooool03_ooo`@00004oooo200000goool200001_ooo`@00008oooo0P0000Goool800003?oo
o`X0000?oooo0P0000Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`h0000A
oooo1P0001?oool200006?ooo`80000Koooo100000[oool00`000?ooooooo`0>oooo100000Coool8
00003Oooo`800006oooo100000Soool200001Oooo`P0000<oooo2P0000ooool200002Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`02oooo0P0000;oool400000_ooo`800004oooo1@00
00Koool800000_ooo`800002oooo0P0002Ooool200006oooo`@0000Soooo200000Woool200003?oo
o`@00004oooo0P0000Coool00`000?ooooooo`02oooo1P0000coool:00000oooo`800008oooo1000
00Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`800002oooo100000;oool2
00001?ooo`D00006oooo200000;oool200000_ooo`80000Woooo0P0001_oool400008oooo`P00009
oooo0P0000coool400001?ooo`800004oooo00<0003oooooool00_ooo`H0000<oooo2P0000?oool2
00002?ooo`@00009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool200000_oo
o`80000:oooo0P000003oooo0000000000Coool:00000_ooo`@0000?oooo0P0001Koool400007Ooo
o`80000Qoooo2P0000Woool200000_ooo`800008oooo0P0000;oool200003oooo`800006oooo1000
00Koool200000_ooo`/00006oooo100000Woool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`800002oooo0P0000[oool2000000?oool0000000001?ooo`X00002oooo100000ooool2
00005_ooo`@0000Moooo0P00027oool:00002Oooo`800002oooo0P0000Soool200000_ooo`80000?
oooo0P0000Koool400001_ooo`800002oooo2`0000Koool400002Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`04oooo0P0000coool2000000?oool0000000000_ooo`@00002oooo0P00
00Koool40000:Oooo`80000Koooo0P0000;oool200001_ooo`<0000Doooo0P0000;oool400001_oo
o`030000oooooooo00800002oooo100000[oool400002?ooo`80000Koooo2`0000Coool:00001ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`04oooo0P0000coool2000000?oool00000
00000_ooo`@00002oooo0P0000Koool40000:Oooo`80000Koooo0P0000;oool200001_ooo`<0000D
oooo0P0000;oool400001_ooo`030000oooooooo00800002oooo100000[oool400002?ooo`80000K
oooo2`0000Coool:00001oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08oooo0P00
00;oool200000_ooo`D00002oooo100000Coool200002_ooo`80000Woooo0P0001goool400002Ooo
o`80000Boooo0P0000Koool200001?ooo`030000oooooooo00Koool200002?ooo`@00002oooo0P00
01_oool200002?ooo`800004oooo3`0000Woool00`000?ooooooo`02oooo000Hoooo0P0000Woool2
00000_ooo`800002oooo1@0000;oool400001?ooo`80000:oooo0P0002Ooool200007Oooo`@00009
oooo0P0001;oool200001_ooo`800004oooo00<0003oooooool01_ooo`800008oooo100000;oool2
00006oooo`800008oooo0P0000Coool?00002?ooo`800004oooo000Hoooo00<0003oooooool02?oo
o`@00004oooo0P0000?oool600003_ooo`80000=oooo0P0001Koool400007Oooo`800002oooo1000
00Ooool200006?ooo`80000?oooo0P0000Soool400000_ooo`800004oooo0P0000ooool400003?oo
o`d00002oooo100000Coool200001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08
oooo100000Coool200000oooo`H0000>oooo0P0000goool200005_ooo`@0000Moooo0P0000;oool4
00001oooo`80000Hoooo0P0000ooool200002?ooo`@00002oooo0P0000Coool200003oooo`@0000<
oooo3@0000;oool400001?ooo`800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool200001_ooo`800006oooo1@00013oool200009oooo`@0000Goooo0P0000;oool200004Ooo
o`80000Doooo100000ooool200002?ooo`800008oooo0P0000;oool300000_ooo`800008oooo1000
00[oool200000_oooa400004oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool00_ooo`800006oooo0P0000Koool500004?ooo`80000Woooo100001Ooool200000_ooo`80000A
oooo0P0001Coool400003oooo`800008oooo0P0000Soool200000_ooo`<00002oooo0P0000Soool4
00002_ooo`800002oooo4@0000Coool200001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`08oooo1P0000;oool500002_ooo`800006oooo100001ooool200001_ooo`800007oooo1000
01[oool200001oooo`80000<oooo0P00017oool400001?ooo`80000<oooo0P0000;oool200008Ooo
oa400004oooo100000Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool02?ooo`H00002
oooo1@0000[oool200001_ooo`@0000Ooooo0P0000Koool200001oooo`@0000Joooo0P0000Ooool2
00003?ooo`80000Aoooo100000Coool200003?ooo`800002oooo0P00027ooolA00001?ooo`@00007
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Koool200000_ooo`800002oooo1000
00_oool200001_ooo`80000[oooo0P0000Ooool200002?ooo`80000Boooo100001Goool200001_oo
o`800004oooo0P0000Goool200000_ooo`80000:oooo100000;oool200000_ooo`@0000?oooo0P00
00[oool?00002?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Koool2
00000_ooo`800002oooo100000_oool200001_ooo`80000[oooo0P0000Ooool200002?ooo`80000B
oooo100001Goool200001_ooo`800004oooo0P0000Goool200000_ooo`80000:oooo100000;oool2
00000_ooo`@0000?oooo0P0000[oool?00002?ooo`800007oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00Coool400001_ooo`800009oooo0P0000Coool200005?ooo`8000000oooo`00
0000000Boooo0P0000;oool400002Oooo`800002oooo0P0000;oool200004_ooo`@00007oooo0P00
00coool800007Oooo`@00002oooo0P0000Coool200003Oooo`@00002oooo0P0000Coool;00000_oo
o`@00002oooo200000Ooool00`000?ooooooo`02oooo000Hoooo0P0000Goool400001_ooo`800009
oooo0P0000Coool200005?ooo`8000000oooo`000000000Boooo0P0000;oool400002Oooo`800002
oooo0P0000;oool200004_ooo`@00007oooo0P0000coool800007Oooo`@00002oooo0P0000Coool2
00003Oooo`@00002oooo0P0000Coool;00000_ooo`@00002oooo200000Koool200001?ooo`006?oo
o`030000oooooooo00;oool800002oooo`H00006oooo0P0000Coool400002_ooo`80000Aoooo0P00
00;oool200000_ooo`@0000;oooo0P0000;oool200002_ooo`80000<oooo0P0000Goool200000_oo
o`800008oooo0P0002Woool400000_ooo`8000000oooo`0000000006oooo100000;oool400000_oo
o`800002oooo3`0000Coool200001?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo00;oool800002oooo`H00006oooo0P0000Coool400002_ooo`80000Aoooo0P0000;oool2
00000_ooo`@0000;oooo0P0000;oool200002_ooo`80000<oooo0P0000Goool200000_ooo`800008
oooo0P0002Woool400000_ooo`8000000oooo`0000000006oooo100000;oool400000_ooo`800002
oooo3`0000Coool200001?ooo`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00Coool600002oooo`@00006oooo0P0000;oool600003oooo`80000>oooo300000Koool300003_oo
o`80000@oooo0P0000Goool200002_ooo`800008oooo0P0000Coool200001oooo`80000:oooo0P00
00Koool800005ooooa400004oooo0P0000Coool200001oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`04oooo1P0000_oool400001_ooo`800002oooo1P0000ooool200003_ooo``00006
oooo0`0000koool200004?ooo`800005oooo0P0000[oool200002?ooo`800004oooo0P0000Ooool2
00002_ooo`800006oooo200001OooolA00001?ooo`800004oooo0P0000Ooool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool01_ooo`80000?oooo0P0000Koool200005?ooo`80000Aoooo0P00
00;oool800001oooo`800004oooo100000;oool400008oooo`80000Soooo0P0000Soool900000_oo
o`@00004oooo200000CooolO00001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`06
oooo0P0000ooool200001_ooo`80000Doooo0P00017oool200000_ooo`P00007oooo0P0000Coool4
00000_ooo`@0000Soooo0P0002?oool200002?ooo`T00002oooo100000Coool800001?oooal00005
oooo00<0003oooooool00_ooo`003Oooo`<00002oooo00<0003oooooool00oooo`030000oooooooo
00Coool200003oooo`H00002oooo0P0000;oool200001?ooo`80000<oooo0P0001?oool200000_oo
o`H00006oooo0`0000Coool200001?ooo`@0000Doooo00<0003oooooool04?ooo`80000:oooo0P00
01?oool200001_ooo`/00002oooo0P0000Soool400001_ooo``000000oooo`000000000200000_oo
o`@00002oooo100000Ooool00`000?ooooooo`02oooo000>oooo00H0003oooooool0003oool00004
oooo00<0003oooooool01?ooo`80000?oooo1P0000;oool200000_ooo`800004oooo0P0000coool2
00004oooo`800002oooo1P0000Koool300001?ooo`800004oooo100001Coool00`000?ooooooo`0@
oooo0P0000[oool200004oooo`800006oooo2`0000;oool200002?ooo`@00006oooo30000003oooo
0000000000800002oooo100000;oool400001oooo`030000oooooooo00;oool000coool4000000Co
ool0003oool00004oooo0`0000coool200000_ooo`@00003oooo0P0000Koool200001_ooo`80000?
oooo0P0001Coool800001oooo`800006oooo0P0000koool200002Oooo`80000>oooo0P00027oool2
00002?ooo`H0000=oooo1P0000CooolC00000_ooo`@00002oooo1P0000?oool300001?ooo`003?oo
o`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool03?ooo`800002oooo1000
00?oool200001_ooo`800006oooo0P0000ooool200005?ooo`P00007oooo0P0000Koool200003_oo
o`800009oooo0P0000koool200008Oooo`800008oooo1P0000goool600001?oooa<00002oooo1000
00;oool600001Oooo`030000oooooooo00;oool000goool200000_ooo`030000oooo000000Coool0
0`000?ooooooo`0<oooo0P0000Koool900001?ooo`@00002oooo0P0002Ooool600001?ooo`030000
oooooooo013oool200001?ooo`@00008oooo0`0000Coool400001_ooo`80000:oooo0P0000Woool4
00001_ooo`800008oooo0P0000;oool200001?ooo`D00006oooo100000KooolQ00001Oooo`030000
oooooooo00;oool000koool01@000?ooooooooooo`000005oooo00<0003oooooool01_ooo`800006
oooo0P0000Goool400002?ooo`800002oooo100000ooool200004_ooo`@00004oooo0P0000Coool0
0`000?ooooooo`04oooo0P0000;oool400002_ooo`80000;oooo100000;oool400001_ooo`80000E
oooo100000Koool200001?ooo`800002oooo0P0000;oool200001Oooo`H00004oooo1P0000;ooolI
00001?ooo`800002oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_oo
o`800006oooo0P0000Goool400002?ooo`800002oooo100000ooool200004_ooo`@00004oooo0P00
00Coool00`000?ooooooo`04oooo0P0000;oool400002_ooo`80000;oooo100000;oool400001_oo
o`80000Eoooo100000Koool200001?ooo`800002oooo0P0000;oool200001Oooo`H00004oooo1P00
00;ooolI00001?ooo`800002oooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool01_ooo`800004oooo100000Coool00`000?ooooooo`02oooo0P0000Coool800009oooo`@00002
oooo0P0000;oool200001Oooo`@0000Boooo100000Koool300000_ooo`800002oooo0P0000coool2
00004Oooo`800004oooo0P0000;oool200001?ooo`800004oooo0P0000Goool600001?ooo`H00004
oooo300000;oool900001_ooo`@00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00Koool200001?ooo`@00004oooo00<0003oooooool00_ooo`800004oooo200002Ooool400000_oo
o`800002oooo0P0000Goool400004_ooo`@00006oooo0`0000;oool200000_ooo`80000<oooo0P00
017oool200001?ooo`800002oooo0P0000Coool200001?ooo`800005oooo1P0000Coool600001?oo
o``00002oooo2@0000Koool400001Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`08
oooo0P0000;oool400001?ooo`L00004oooo0P0000;oool40000:Oooo`800002oooo0P0000Goool2
00000_ooo`@0000Ooooo1P0002Ooool200002_ooo`800002oooo100000;oool00`000?ooooooo`04
00000_ooo`800002oooo0P0000;oool>00001oooo`H00002oooo200000Goool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool02?ooo`800002oooo100000Coool700001?ooo`800002oooo1000
02Woool200000_ooo`800005oooo0P0000;oool400007oooo`H0000Woooo0P0000[oool200000_oo
o`@00002oooo00<0003oooooool0100000;oool200000_ooo`800002oooo3P0000Ooool600000_oo
o`P00005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00coool400001?ooo`<00002
oooo0P0000Coool800004Oooo`80000Foooo0P0000Koool200000oooo`@0000Hoooo0P0000ooool2
00004?ooo`800007oooo100000Coool200002_ooo`800002oooo1P0000;oool00`000?ooooooo`02
00001_oooaH0000;oooo1P0000;oool200001Oooo`030000oooooooo00;oool001Soool200003Ooo
o`@00004oooo0`0000;oool200001?ooo`P0000Aoooo0P0001Koool200001_ooo`800003oooo1000
01Soool200003oooo`80000@oooo0P0000Ooool400001?ooo`80000:oooo0P0000;oool600000_oo
o`030000oooooooo00800006oooo5P0000_oool600000_ooo`800004oooo0P0000Coool001Soool0
0`000?ooooooo`0>oooo0P0000Coool300000_ooo`800002oooo2P00017oool200005_ooo`800002
oooo0P0000Coool300000_ooo`80000@oooo0P0000Koool400000oooo`800006oooo100000;oool2
00002?ooo`800002oooo0P0000Woool200001?ooo`800008oooo100000Koool200000oooo`@00002
oooo1P0000;oool200000_ooo`H00004oooo0P0000Goool800000_ooo`H00007oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00koool200001?ooo`<00002oooo0P0000;oool:00004Ooo
o`80000Foooo0P0000;oool200001?ooo`<00002oooo0P00013oool200001_ooo`@00003oooo0P00
00Koool400000_ooo`800008oooo0P0000;oool200002Oooo`800004oooo0P0000Soool400001_oo
o`800003oooo100000;oool600000_ooo`800002oooo1P0000Coool200001Oooo`P00002oooo1P00
00Ooool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`@00008oooo0P0000;oool5
00000_ooo`H00004oooo100002Woool200001_ooo`D00006oooo0P0000;oool200001?ooo`80000K
oooo0P00013oool200002Oooo`@00002oooo0P0000[oool200001?ooo`@00002oooo5@0000Coool4
00003oooo`80000=oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool400002?oo
o`800002oooo1@0000;oool600001?ooo`@0000Yoooo0P0000Koool500001_ooo`800002oooo0P00
00Coool200006oooo`80000@oooo0P0000Woool400000_ooo`80000:oooo0P0000Coool400000_oo
oaD00004oooo100000ooool200003Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02
oooo2P0000;oool200001?ooo`030000oooooooo00;oool400001_ooo`@0000Qoooo100000Coool4
00001_ooo`030000oooooooo00H00002oooo0P0001;oool600002oooo`800004oooo0P0001Goool4
00000_ooo`@00004oooo100000Koool400001Oooo`H00002oooo1P0000;oool400000_ooo`P00009
oooo0P0000;oool200002oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P00
00;oool200001?ooo`030000oooooooo00;oool400001_ooo`@0000Qoooo100000Coool400001_oo
o`030000oooooooo00H00002oooo0P0001;oool600002oooo`800004oooo0P0001Goool400000_oo
o`@00004oooo100000Koool400001Oooo`H00002oooo1P0000;oool400000_ooo`P00009oooo0P00
00;oool200002oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Woool2
00000_ooo`H00004oooo100002?oool200000_ooo`@00002oooo0P0000;oool200001Oooo`800006
oooo0P0002?oool200003?ooo`800009oooo0P0000;oool200000_ooo`800006oooo0P0000Koool6
00001Oooo`P00002oooo1P0000[oool200001?ooo`L0000Aoooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo00;oool:00002Oooo`800002oooo1P0000Coool400008oooo`800002oooo1000
00;oool200000_ooo`800005oooo0P0000Koool200008oooo`80000<oooo0P0000Woool200000_oo
o`800002oooo0P0000Koool200001_ooo`H00005oooo200000;oool600002_ooo`800004oooo1`00
017oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`80000<oooo0P0000?oool2
00000_ooo`H00004oooo1P0000Koool200006Oooo`800002oooo100000Koool200002Oooo`80000H
oooo0P000003oooo0000000000[oool400000_ooo`800002oooo0P0000Coool200001oooo`80000<
oooo1000017oool200000_ooo`800004oooo100000;oool200000_ooo`@00009oooo100000;oool2
00003oooo`030000oooooooo00;oool001Soool200000oooo`80000<oooo0P0000?oool200000_oo
o`H00004oooo1P0000Koool200006Oooo`800002oooo100000Koool200002Oooo`80000Hoooo0P00
0003oooo0000000000[oool400000_ooo`800002oooo0P0000Coool200001oooo`80000<oooo1000
017oool200000_ooo`800004oooo100000;oool200000_ooo`@00009oooo100000;oool200003_oo
o`800004oooo000Hoooo00<0003oooooool00_ooo`X00004oooo1`0000;oool800000_ooo`H00008
oooo0P0001Ooool800001?ooo`@00003oooo0P0000;oool200001_ooo`@00008oooo0P0001Goool4
00008oooo`80000:oooo100000;oool300001?ooo`@00002oooo100000;oool600001?ooo`800004
oooo00<0003oooooool00P0001?oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`X00004oooo1`0000;oool800000_ooo`H00008oooo0P0001Ooool800001?ooo`@00003oooo0P00
00;oool200001_ooo`@00008oooo0P0001Goool400008oooo`80000:oooo100000;oool300001?oo
o`@00002oooo100000;oool600001?ooo`800004oooo00<0003oooooool00P0001?oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool00_ooo`X00004oooo10000003oooo0000000000Coool6
00000_ooo`H0000Uoooo100000;ooolA00001_ooo`800002oooo0P0000[oool200003oooo`@0000E
oooo1P0000Koool400001_ooo`@00002oooo0P0000;oool700001?ooo`800002oooo100000Soool2
00000_ooo`800003oooo0P0000koool200001Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`02oooo2P0000Coool4000000?oool0000000001?ooo`H00002oooo1P0002Goool400000_oo
oa400006oooo0P0000;oool200002_ooo`80000?oooo100001Goool600001_ooo`@00006oooo1000
00;oool200000_ooo`L00004oooo0P0000;oool400002?ooo`800002oooo0P0000?oool200003_oo
o`800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?oooa400004
oooo100000;oool200003Oooo`80000Boooo100000_oool200003_ooo`80000<oooo10000003oooo
0000000000800004oooo0P0000Coool200003?ooo`800007oooo0P0000;oool200001?ooo`@0000<
oooo100000;oool00`000?ooooooo`04oooo0P0000Koool:00001_ooo`80000?oooo0P0000Woool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool00_ooo`X00004oooo4@0000Coool400000_oo
o`80000=oooo0P0001;oool400002oooo`80000>oooo0P0000coool4000000?oool0000000000P00
00Coool200001?ooo`80000<oooo0P0000Ooool200000_ooo`800004oooo100000coool400000_oo
o`030000oooooooo00Coool200001_ooo`X00006oooo0P0000ooool200002Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`02oooo2P0000Coool700000_ooo`800002oooo100000Coool4
00001?ooo`800006oooo0P0000?oool200004_ooo`@00009oooo100000koool200003_ooo`<00002
oooo1P0000;oool200002_ooo`800004oooo0P0000_oool200001?ooo`80000>oooo1P0000Woool4
00004?ooo`80000Eoooo0P0000Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool00_oo
o`X00004oooo1`0000;oool200000_ooo`@00004oooo100000Coool200001_ooo`800003oooo0P00
01;oool400002Oooo`@0000>oooo0P0000koool300000_ooo`H00002oooo0P0000[oool200001?oo
o`80000;oooo0P0000Coool200003_ooo`H00009oooo1000013oool200005Oooo`800005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001_ooo`/00002oooo100000;oool6
00001_ooo`800002oooo0P0001Goool200003?ooo`030000oooooooo01Koool200001_ooo`800003
oooo100000;oool200001?ooo`800006oooo0P0000Coool200002oooo`@00002oooo100002Goool2
00003?ooo`80000Aoooo0P0000Ooool00`000?ooooooo`02oooo000Hoooo0P0000?oool:00001_oo
o`/00002oooo100000;oool600001_ooo`800002oooo0P0001Goool200003?ooo`030000oooooooo
01Koool200001_ooo`800003oooo100000;oool200001?ooo`800006oooo0P0000Coool200002ooo
o`@00002oooo100002Goool200003?ooo`80000Aoooo0P0000Koool200001?ooo`006?ooo`030000
oooooooo00;oool:00001?ooo`d00008oooo1P0000Koool600001Oooo`800004oooo0P0000Coool2
00001?ooo`800004oooo0P0001?oool600000_ooo`800002oooo100000Coool500002?ooo`@00006
oooo0P0000Coool200003oooo`800002oooo1P0002ooool200004Oooo`800007oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo00;oool:00001?ooo`d00008oooo1P0000Koool600001Ooo
o`800004oooo0P0000Coool200001?ooo`800004oooo0P0001?oool600000_ooo`800002oooo1000
00Coool500002?ooo`@00006oooo0P0000Coool200003oooo`800002oooo1P0002ooool200004Ooo
o`800007oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool:00001?ooo`/0000<
oooo100000goool200001_ooo`80000<oooo0P0000Coool200004Oooo`H00002oooo100000Coool2
00002Oooo`X00002oooo100000;oool200001?ooo`80000=oooo0P00037oool200001_ooo`800002
oooo00<0003oooooool02_ooo`800009oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00;oool:00001?ooo`/0000Hoooo0P0000_oool400002_ooo`800004oooo0P0000ooool400001_oo
o`H00006oooo1@0000;oool200001?ooo`X00002oooo0P0000Coool200002Oooo`H0000aoooo0P00
00goool200004oooo`030000oooooooo00;oool001Soool00`000?ooooooo`02oooo2P0000Coool;
00006?ooo`80000;oooo100000[oool200001?ooo`80000?oooo100000Koool600001_ooo`D00002
oooo0P0000Coool:00000_ooo`800004oooo0P0000Woool60000<Oooo`80000=oooo0P0001?oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0=oooo`<00004oooo0P0000Coool200000_oo
o`800004oooo0P0000Soool300001_ooo`P00002oooo4P0000Goool200000_ooo``00006oooo0P00
00Koool30000?oooo`800002oooo0P0000Goool200002?ooo`@00005oooo00<0003oooooool00_oo
o`003?ooo`800004oooo00<0003oooooool00oooo`030000oooooooo03Ooool300001?ooo`800004
oooo0P0000;oool200001?ooo`800008oooo0`0000Koool800000_oooa800005oooo0P0000;oool<
00001_ooo`800006oooo0`0003ooool200000_ooo`800005oooo0P0000Soool400001Oooo`030000
oooooooo00;oool000coool00`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo
03koool200000_ooo`@00002oooo0P0000[oool200000_ooo`800003oooo2P0000CooolE00000_oo
o`P00002oooo1P0000Koool60000B?ooo`d00006oooo0P0000Goool00`000?ooooooo`02oooo000<
oooo00<0003oool000000_ooo`030000oooo000000Coool30000?_ooo`800002oooo100000;oool2
00002_ooo`800002oooo0P0000?oool:00001?oooaD00002oooo200000;oool600001_ooo`H00018
oooo3@0000Koool200000oooo`<00004oooo000<oooo0P0000?oool00`000?ooo`000004oooo00<0
003oooooool0A_ooo`800002oooo0P0000Soool200001oooo`800002oooo100000;ooolI00000_oo
o`P00002oooo1P0000Coool40000EOooo`X00007oooo00<0003oooooool00_ooo`003?ooo`030000
oooooooo00;oool00`000?ooo`000004oooo00<0003oooooool0A_ooo`800002oooo0P0000Soool2
00001oooo`800002oooo100000;ooolI00000_ooo`P00002oooo1P0000Coool40000EOooo`X00007
oooo00<0003oooooool00_ooo`003Oooo`800003oooo00<0003oooooool00oooo`030000oooooooo
04Soool200000_ooo`@00006oooo0P0000Goool200000_ooo`800002oooo7`0000;oool400000_oo
o`H00004oooo100004;oool600002Oooo`800004oooo0P0000;oool200000_ooo`800005oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo04Soool200000_ooo`@00006oooo0P0000Goool2
00000_ooo`800002oooo7`0000;oool400000_ooo`H00004oooo100004;oool600002Oooo`800004
oooo0P0000;oool200000_ooo`800005oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
04[oool200003?ooo`T00002oooo8@0000;oool200000_ooo`P00004oooo0P00053oool00`000?oo
ooooo`0200004oooo`030000oooooooo00;oool001Soool00`000?ooooooo`1:oooo0P0000coool9
00000_ooob400002oooo0P0000;oool800001?ooo`80001@oooo00<0003oooooool00P0001?oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0C_ooo`800004oooo0P0000;ooolj00000_oo
o`80001Coooo0P0001Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C_ooo`800004
oooo0P0000;ooolj00000_ooo`80001Coooo0P0001Goool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0E?ooo`@00003oooo>`0006[oool00`000?ooooooo`02oooo000Hoooo0P0005Goool4
00000ooooc/0001Yoooo0P0000Coool001Soool00`000?ooooooo`1Hoooo0P000003oooo00000000
03L0001/oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Soool2000000?oool00000
0000=`0006coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_ooo`800002oooo00<0
003oooooool0<`00073oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_ooo`800002
oooo00<0003oooooool0<`00073oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_oo
o`800002oooo=00007;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E_ooo`800002
oooo=00007;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E?ooo`@00003oooo<`00
07;oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0E?ooo`@00003oooo<`0007;oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0F_oooc80001doooo00<0003oooooool00_oo
o`006?ooo`80001Koooo<P0007?oool200001?ooo`006?ooo`030000oooooooo05Soool`0000N?oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1Hoooo<00007Soool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0Foooob/0001joooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo05_oool[0000N_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1Koooo;@00
07Soool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0F?ooo`d00006oooo7`0007Koool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0F?ooo`d00006oooo7`0007Koool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0F?ooo`d00008oooo7`0007Coool00`000?ooooooo`02
oooo000Hoooo0P0005Woool=00002?oooal0001coooo0P0000Coool001Soool00`000?ooooooo`1F
oooo5@0000Coool200000_oooaT0001doooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
05KooolE00001?ooo`800002oooo6@0007Coool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0E_oooaT00006oooo2`0000;oool<0000L_ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1Foooo6@0000Koool;00000_ooo``0001boooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo053oool?00000_ooo`@00004oooo9@0007;oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0D?ooo`l00002oooo100000CooolU0000L_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`1Boooo2`0000;oool600000_oooaP000000oooo`000000000@0000K_ooo`030000
oooooooo00;oool000goool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo
05;oool;00000_ooo`H00002oooo60000003oooo000000000100001^oooo00<0003oooooool00_oo
o`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0D_ooo`d00004
oooo3P0000KooolK0000K_ooo`030000oooooooo00;oool000coool00`000?ooo`000002oooo00<0
003oool000001?ooo`<0001Boooo3@0000Coool>00001_oooa/0001/oooo0`0000Coool000goool0
1`000?ooooooooooo`000?ooo`000004oooo00<0003oooooool0D?ooo`/00002oooo100000;oool2
00000_ooo`H00004oooo8@0006koool00`000?ooooooo`02oooo000<oooo00<0003oool000000_oo
o`030000oooo000000Coool00`000?ooooooo`1@oooo2`0000;oool400000_ooo`800002oooo1P00
00CooolQ0000K_ooo`030000oooooooo00;oool000goool00`000?ooooooo`02oooo00<0003ooooo
ool00oooo`030000oooooooo04koool=00000_ooo`@00004oooo0P0000CooolE00000_oooa00001^
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04koool=00000_ooo`@00004oooo0P00
00CooolE00000_oooa00001^oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04kooolA
00000_ooo`80000Boooo0P0000CooolI0000K?ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`1>oooo4@0000;oool200004_ooo`800004oooo6@0006coool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0C_ooo`800002oooo2`0000Koool200002?ooo`@00002oooo2P0000;ooolE
0000K?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1>oooo0P0000;oool;00001_oo
o`800008oooo100000;oool:00000_oooaD0001/oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04koool=00000_ooo`80000>oooo300000Coool2000000?oool0000000004P0006coool0
0`000?ooooooo`02oooo000Hoooo0P0004ooool=00000_ooo`80000>oooo300000Coool2000000?o
ool0000000004P0006_oool200001?ooo`006?ooo`030000oooooooo04coool>000000?oool00000
00001P0000;oool200000_oooaH000000oooo`000000000B0000K?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1<oooo3P000003oooo0000000000H00002oooo0P0000;ooolF000000?o
ool0000000004P0006coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C?ooo`h00005
oooo100000Coool200000_oooa@000000oooo`000000000B0000K?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1<oooo3P0000Goool400001?ooo`800002oooo50000003oooo00000000
0180001/oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04coool:00002oooo`800004
oooo0P0000Coool200000_ooo`H00002oooo0P0000Goool600000_ooo``0001/oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo04coool:00002oooo`800004oooo0P0000Coool200000_oo
o`H00002oooo0P0000Goool600000_ooo``0001/oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04koool:00003Oooo`800004oooo0P0000Koool600004Oooo`X0001/oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo04koool:00001Oooo`X00004oooo0P0000;oool200000_oo
o`H00002oooo2`0000Coool80000K_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1>
oooo2P0000Goool:00001?ooo`800002oooo0P0000;oool600000_ooo`/00004oooo200006koool0
0`000?ooooooo`02oooo000Hoooo0P0004goool800002Oooo`800002oooo200000[oool400000_oo
o`d00004oooo200006goool200001?ooo`006?ooo`030000oooooooo04coool800002Oooo`800002
oooo200000[oool400000_ooo`d00004oooo200006koool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0C_oooa/0000<oooo1P0000;ooolE0000K_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`1>oooo6`0000coool600000_oooaD0001^oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo04coool:00000_oooaD00008oooo7@0006koool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0C?ooo`X00002oooo5@0000SooolM0000K_ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1<oooo3`0000;oool200000_ooo`h00004oooo7`0006koool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0C?ooo`l00002oooo0P0000;oool>00001?oooal0001^
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo04coool400001_ooo`T00006oooo2P00
00Coool800000_ooo`D00002oooo3P0006koool00`000?ooooooo`02oooo000Hoooo0P0004goool4
00001_ooo`T00006oooo2P0000Coool800000_ooo`D00002oooo3P0006goool200001?ooo`006?oo
o`030000oooooooo04coool200002?ooo`800002oooo00<0003oooooool0100000Koool[0000K_oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1<oooo0P0000Soool200000_ooo`030000
oooooooo00@00006oooo:`0006koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C?oo
o`80000:oooo5@0000SooolI00000_ooo`80001^oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04coool200002_oooaD00008oooo6@0000;oool20000K_ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`1>oooo0P0000Coool200000_ooo`800005oooo0P0000;oool:00000_oo
o`800004oooo2`0000Soool200001?ooo`@0001^oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo04koool200001?ooo`800002oooo0P0000Goool200000_ooo`X00002oooo0P0000Coool;
00002?ooo`800004oooo100006koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0C_oo
o`@0000Aoooo0P0001Coool400000_ooo`030000oooooooo00coool20000L?ooo`030000oooooooo
00;oool000Koool500000_ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003ooooo
ool0C_ooo`@0000Aoooo0P0001Coool400000_ooo`030000oooooooo00coool20000L?ooo`030000
oooooooo00;oool000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?oo
o`030000oooooooo05Koool200004Oooo`80000@oooo0P0000;oool00`000?ooooooo`02oooo0P00
00Coool200000_ooo`80001`oooo00<0003oooooool00_ooo`002?ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000004oooo0`0005Koool200004Oooo`80000@oooo0P0000;oool0
0`000?ooooooo`02oooo0P0000Coool200000_ooo`80001^oooo0`0000Coool000Soool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo053oool40000;?oo
o`@00002oooo0P0000;oool40000L_ooo`030000oooooooo00;oool000Soool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo053oool40000;?ooo`@00002
oooo0P0000;oool40000L_ooo`030000oooooooo00;oool000Ooool200001?ooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool0HOooo`80000Doooo100000Ooool20000O?oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`1Qoooo0P0001Coool400001oooo`80001l
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05Coool200009oooo`8000000oooo`00
00000002oooo0P0000;oool20000M_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`1D
oooo0P0002Ooool2000000?oool0000000000_ooo`800002oooo0P0007Koool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0E_ooo`L0000Uoooo1P0007Soool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0E_ooo`L0000Uoooo1P0007Soool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0F?ooo`<0000>oooo0P0000Soool600000_ooo`800002oooo00<0003oooooool00P00
07coool00`000?ooooooo`02oooo000Hoooo0P0005koool200000_ooo`80000<oooo200000Koool3
0000Ooooo`800004oooo000Hoooo00<0003oooooool0GOooo`800002oooo0P0000coool800001_oo
o`<00020oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo05ooool200002?ooo`80000:
oooo0P0008Woool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0Goooo`800008oooo0P00
00[oool20000ROooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Ooo
o`800004oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool03?ooo`80003boooo00<0003ooooo
ool00_ooo`001_ooo`D000001?ooo`000000000000?oool00`000?ooooooo`03oooo00<0003ooooo
ool03?ooo`80003boooo00<0003oooooool00_ooo`002?ooo`050000oooooooooooo000000Coool0
0`000?ooo`000004oooo00<0003oooooool03_ooo`80003`oooo00<0003oooooool00_ooo`002?oo
o`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000004oooo0`0000koool20000k_oo
o`<00004oooo0008oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000Soool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oool000001?ooo`030000oooooooo00[oool20000m?ooo`030000oooooooo
00;oool000Ooool200001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003ooooo
ool02_ooo`80003doooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool40000jOoo
o`80000?oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00;oool40000jOooo`80000?
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00Soool200002_ooo`030000oooooooo
00[oool20000gOooo`030000oooooooo00;oool001Soool00`000?ooooooo`08oooo0P0000[oool0
0`000?ooooooo`0:oooo0P000=goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool01_oo
o`@0000Aoooo0P0000;oool200003?ooo`800002oooo0P0000;oool20000bOooo`030000oooooooo
00;oool001Soool00`000?ooooooo`06oooo1000017oool200000_ooo`80000<oooo0P0000;oool2
00000_ooo`800039oooo00<0003oooooool00_ooo`006?ooo`80000;oooo0P0000;oool600001Ooo
o`800002oooo0P00013oool20000c_ooo`800004oooo000Hoooo00<0003oooooool02_ooo`800002
oooo1P0000Goool200000_ooo`80000@oooo0P000<ooool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool00_oooa000003oooo0P0000Soool200009Oooo`80000Goooo100000koool200007Ooo
o`80000<oooo0P0000Goool200005?ooo`80000Ioooo0P0002Soool00`000?ooooooo`02oooo000H
oooo00<0003oooooool00_oooa000003oooo0P0000Soool200009Oooo`80000Goooo100000koool2
00007Oooo`80000<oooo0P0000Goool200005?ooo`80000Ioooo0P0002Soool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool00_ooo`H00002oooo0P0000;oool600001Oooo`80000@oooo0P00
00Soool200007oooo`80000noooo0P0001?oool20000A?ooo`80000=oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00;oool600000_ooo`800002oooo1P0000Goool200004?ooo`800008
oooo0P0001ooool20000?_ooo`80000Coooo0P0004Coool200003Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool200000oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo0P0000Coool001Sooooo00001@0000Coool00?oooolQoooo003ooooo8Ooo
o`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00QOooo`<0002Hoooo0026oooo00<0003ooooo
ool0Uoooo`00Moooo`<00002oooo1@000005oooo0000oooo0000oooo00<00002oooo0`0000?oool2
00003Oooo`<00002oooo0`000004oooo0000oooooooo0P0000?oool200000oooo`80001Xoooo001g
oooo00<0003oool000000_ooo`<000002?ooo`000?ooo`000?ooo`000?ooo`0000;oool010000?oo
ooooo`0000?oool00`000?ooooooo`0>oooo00<0003oooooool00_ooo`060000oooooooo0000oooo
00000_ooo`030000oooo000000;oool00`000?ooo`000002oooo00<0003oooooool0IOooo`00NOoo
o`030000oooooooo00;oool02@000?ooo`000?ooo`000?ooo`000?ooo`000002oooo00@0003ooooo
ool00003oooo0`0000koool300000_ooo`060000oooooooo0000oooo00000_ooo`030000oooo0000
00Coool010000?ooooooo`0006Ooool007Soool00`000?ooooooo`02oooo0P000006oooo00000000
oooo0000oooo100000?oool010000?ooooooooooo`<0000>oooo00D0003oooooool0003oool00`00
00?oool2000000?oool0000000000P0000?oool20000J?ooo`00Moooo`030000oooo000001;oool0
0`000?ooooooo`0Boooo00H0003oooooool0003oool00009oooo00<0003oooooool0KOooo`00Mooo
o`<0000Aoooo0P0001?oool4000000?oool000000000NOooo`00ooooob7oool00?oooolQoooo003o
oooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ 0, 1\  - \ Normalization\)], "Input"],

Cell["\<\
imageNormalize=Compile[{{data2D,_Real,2}},
\t\tModule[{minimum=Min[data2D]},
\t\t\t(data2D-minimum)/Max[data2D-minimum]]];\
\>", "Input",
  FormatType->InputForm],

Cell["nsample=imageNormalize[sample]; ", "Input"],

Cell[BoxData[
    \(\[FilledSquare]\ Shifted\ Photo\)], "Input"],

Cell["\<\
ssample=Table[1,{size[[1]]},{size[[2]]}];
\tDo[ssample[[i,j-3]]=sample[[i,j]],
\t\t{i,1,size[[1]]},{j,4,size[[2]]}];\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
ShiftedSimplePhoto=ListDensityPlot[ssample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Shifted Simple Photo\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SamplePhoto,ShiftedSimplePhoto}]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -62 0 ]
[.5 1.0125 62 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -123 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Shifted) show
111.000000 13.000000 moveto
(Simple) show
153.000000 13.000000 moveto
(Photo) show
183.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00000000
00000000FFFFFF00FFFF00FFFF00FFFFFFFF000000FF0000
000000000000FF00FF00000000000000FF0000FFFF000000
0000FF00FFFF0000FFFFFF00FF00FFFF00FFFF000000FF00
00FF0000FF00FFFF0000000000FF0000FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFF
FF000000FF00FFFFFF00FFFF00FF00FFFF0000000000FF00
FFFF0000000000FFFF0000FFFF00000000000000000000FF
00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF000000
FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FFFFFF00
FFFFFF00FFFFFFFF
FF0000FF000000FFFF00FF00FFFFFFFF00FF00000000FFFF
000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF0000FFFF
000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF000000
FF00FF00FFFFFFFF000000FFFFFF00000000000000FF00FF
FFFFFFFF00FF00FF0000FF0000000000FF000000FF000000
0000FF00FFFFFFFF
FFFFFF00FFFF00FFFF000000FF0000FF00000000FFFF00FF
0000FF0000000000FFFF00000000FF000000000000FF0000
0000FF0000FFFF00000000FF00000000FF000000000000FF
0000FF00000000FFFF00FF0000FF0000FF000000FFFF0000
000000FFFFFF00FF000000FF00FF0000000000FF00FF0000
00FF00FFFFFFFFFF
00FF00FFFFFF00000000FFFFFF000000FFFFFFFFFFFFFF00
0000FFFFFF0000000000FF000000FF00FFFFFF0000FF00FF
FF00FF00FF00FFFF00FF00FF00FFFF000000FF000000FFFF
FF00FFFFFF000000000000FFFFFF0000FF00000000FF00FF
FFFFFFFF000000FF000000000000FFFF00FF00FF00FFFFFF
00FFFF00FFFFFFFF
FF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000FFFF00
FFFF0000FF000000FF00FFFF0000000000000000FFFFFF00
0000000000FF0000FF00FFFF00FFFFFF00FF00FF00FF00FF
00FFFF00FFFF00FF000000000000FFFFFFFF0000FFFF0000
0000000000FFFFFF0000FFFF0000FF00FF0000FFFF00FFFF
00FFFF00FFFFFFFF
00FF00FF0000FF00FF0000000000FF0000FF00FFFFFFFFFF
000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFFFF0000
000000FF000000FF00FF000000000000FF00FF0000FFFF00
FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF00FF00
00FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000FFFFFF
000000FF00FFFFFF
00FFFF000000FFFF00FF00FF00000000FF0000FFFF00FFFF
0000FFFFFF00000000000000000000000000FF00FF000000
FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF000000
FF00FF00FFFF0000FFFFFF000000000000FFFFFF00FF00FF
00FFFF00000000FFFF00FF00000000000000FF00FFFFFFFF
FFFFFF00FFFFFFFF
FFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF0000FF
00FF0000FF00FF0000FFFFFFFF00000000FF00FFFFFF00FF
FF00FF00FF000000FFFF00FF00FFFFFF00000000FF00FFFF
FFFF00FFFFFF00000000FFFFFFFF00FF0000FF00000000FF
FFFFFFFFFF00FF0000FF000000FF00FF000000FFFF000000
00FF000000FFFFFF
000000000000000000000000000000FF0000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF00FFFF
FF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFFFFFF00
00FF000000FFFFFF
00FFFFFFFF00000000000000000000000000000000000000
FF00000000000000000000000000FF000000000000000000
000000000000000000000000000000FFFF00000000000000
0000000000000000FF000000000000000000000000000000
000000000000000000000000000000000000FFFF00FFFFFF
00FF00FFFFFFFFFF
000000000000000000000000000000000000000000000000
00FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF000000FF
00FFFFFF000000FF0000FFFFFF00FFFF0000000000FFFFFF
00000000FF0000FF000000FFFF0000FF0000000000000000
000000000000000000000000000000000000000000000000
0000000000FFFFFF
000000000000000000000000000000000000FF0000000000
00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF00
FF00FFFFFFFF0000000000000000FF0000FF00000000FFFF
FFFF00FFFFFF00FFFF00000000FFFF000000000000000000
000000000000000000000000000000000000000000000000
0000000000FFFFFF
0000000000000000000000000000000000000000FF000000
FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF000000
00FFFF00000000FF0000FF000000FFFFFF00FFFF00FFFF00
000000000000FF0000000000FF0000000000000000000000
0000FF00FF00FFFFFF00FFFFFFFFFF000000000000000000
0000000000FFFFFF
00FFFFFF0000FFFF00000000000000000000000000000000
0000FF00000000000000FF000000FFFF00FFFFFFFFFF00FF
00FFFF00FF0000FFFFFFFF0000000000FFFF00FF000000FF
FFFFFF000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF
FFFFFFFF00FFFFFF
000000000000000000000000000000000000000000FFFFFF
FFFFFF0000000000000000FF0000FFFF0000000000FFFFFF
FFFFFFFFFFFF0000FF0000FF00000000000000FFFF0000FF
00FF00000000000000000000000000FF0000000000000000
0000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF00FFFF
FFFF00FFFFFFFFFF
00000000000000000000000000000000000000000000FF00
00FFFFFF000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF0000000000000000000000000000FFFF00000000000000
00000000FFFFFF000000000000FFFFFF0000FF00000000FF
FF0000FFFFFFFFFF
FF0000000000000000000000000000FF00FF0000FFFFFFFF
00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000000000
00000000FFFFFFFFFF00FF0000FFFFFF00FFFF000000FFFF
00FF00FFFFFFFFFF
FFFFFFFF0000000000000000000000000000FF00FFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF000000
00000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF00FFFF
FFFF00FFFFFFFFFF
FFFFFFFF00000000000000000000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF00
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00FFFF00
000000000000FFFF0000FF0000FFFFFF0000FFFFFF0000FF
FFFF00FFFFFFFFFF
FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF00FFFF
FF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00FF
00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFF
FF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFFFFFFFF
FFFFFF00000000000000000000FFFFFF0000FF00FF0000FF
FFFF0000FFFFFFFF
FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00FF00FF
FFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF00FFFF
FFFF0000FFFFFFFF
00000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF0000FF
FF00000000FFFFFFFF00FFFFFF00FFFFFF000000FFFFFFFF
FFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF0000FF
FFFF0000FFFFFFFF
0000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFF
FF00000000FFFFFF000000FFFF00FFFFFF000000FFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00FFFFFF
FFFF00FFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFF0000
FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFFFFFF00
FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFFFFFFFF
FFFF00FFFFFFFFFF
00FF00FFFF000000FFFFFF00000000FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FFFF00FF
FF00FFFF000000FFFFFFFFFFFF0000000000FFFF00FFFFFF
FF0000FFFFFFFFFF
FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00FFFFFF
FFFFFFFFFF00FFFFFF0000FFFFFF00FF000000000000FFFF
FF0000FFFFFFFFFF
FFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFFFFFFFF
00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FFFF00
00000000FFFFFFFF
00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFF
00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000000000
000000FFFFFFFFFF
0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00FFFF00
FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00000000000000FF
0000FFFF00FFFFFF
FF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFF00FF
0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000000000
0000FFFF00FFFFFF
000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FFFF0000FFFFFFFF
FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFF
00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF00
FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF00FF00
00FFFFFFFFFFFFFFFF00FFFFFFFFFF0000000000000000FF
FFFFFF00FFFFFFFF
FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FF00FF
00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFFFF00
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FFFF
00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF0000FF
00000000FFFFFFFF
00FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFFFFFF00
FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF00FF00
FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FF00FFFFFF0000FF0000FF00FF0000000000000000FFFF
00FFFF00FFFFFFFF
00FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFF000000000000FFFFFF0000FFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFF00FF
FFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF000000
00FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FFFF
00FFFF00FFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FFFF0000
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF000000
0000FF0000FFFF00000000FFFF0000000000000000000000
0000000000FFFFFF
FFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FFFF00FF
FF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00000000
0000FF00FFFFFFFF0000FFFFFF000000000000FF0000FF00
00FF0000FFFFFFFF
FFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00FFFFFF
00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF000000
FFFFFFFFFFFFFF000000FFFF00000000000000000000FF00
00FF000000FFFFFF
FFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFFFFFFFF
FFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFFFF00FF
FFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00FF00FF
FF000000FFFFFF0000FFFFFF000000000000000000000000
0000000000FFFFFF
FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFFFF00FF
0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFFFF00FF
FFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00FF00FF
FFFF000000FFFF000000FF00000000000000000000000000
FFFF00FF00FFFFFF
FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF0000FF
FFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FFFF00FF
FFFF000000FFFF000000FFFF000000000000FF0000000000
FFFFFF0000FFFFFF
00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00FF0000
FF00FF0000FF00FF00FF00000000000000FFFFFFFF000000
FF00000000FFFFFF
FFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF000000
FF00FF00FFFFFF0000000000000000000000FFFFFFFFFFFF
000000FF00FFFFFF
FFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF00FFFF
FFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF00FFFF
FFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FFFFFF00
FFFF0000FF000000FF00FF000000FFFF00FFFFFF00000000
FF000000FFFFFFFF
FFFFFF00FF000000FF000000FFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FFFFFF00
FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FFFF0000
FF0000000000000000000000FFFF0000FFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
0000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF000000FF
00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FFFF00FF
FFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFFFF0000
FFFFFF000000FF000000FF0000FF00000000FFFFFFFFFF00
FF00FFFFFFFFFFFF
0000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF00FFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF000000
FFFFFF00000000FF000000FFFFFFFFFF00FFFF00000000FF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF0000FF00
FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF0000FF00
FFFFFFFFFFFFFFFF
0000FFFF00000000FF00000000FF000000FFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00FF00FF
FFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF0000
FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF00FFFF
FFFFFFFFFFFFFFFF
0000FFFF0000FF00FFFF000000FF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000000000
FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF0000FF00
FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00FFFFFF
FFFFFFFF00FFFFFF
0000FFFF000000000000000000FFFF0000FF00FFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF00FFFF
FFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFFFF0000
FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFFFFFFFF
FFFF00FFFFFFFFFF
0000FFFF00000000FF00FF0000FFFF0000FFFF00FFFFFF00
FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FFFFFFFF
FF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFF0000
00FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFF00FFFFFF
0000FFFFFF000000000000FF0000FF000000FFFFFF00FF00
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00FFFFFF
00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFFFF
0000FFFF00000000000000FFFFFFFF000000FFFFFF000000
FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF000000FF00FF0000FFFF000000FFFFFFFF0000FFFFFF
00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFFFF
0000FFFF000000000000FFFFFFFFFFFF0000FFFFFFFFFFFF
FF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FF000000FF0000FFFF00FFFFFFFFFF0000000000FF0000FF
00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FFFFFFFF
FFFF00FFFFFFFFFF
0000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
0000FFFFFF000000FFFFFF000000FF00FFFF0000000000FF
00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFFFF0000
0000FF000000000000000000FFFFFF00FF000000000000FF
FFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00000000
00FFFF0000000000000000000000FF00000000FF000000FF
FFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
00FFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00FF0000
FF00000000000000000000000000FF00000000FF000000FF
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00FF00FF
00000000000000000000000000000000FF0000FF000000FF
FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF00FFFF
00FF00FF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF0000000000FF00
00000000000000000000000000000000FF00FF00000000FF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000000000
0000000000000000000000000000000000000000000000FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000000000
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00000000
00000000000000000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFFFF00000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFFFFFF00000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
000000FFFF00FF00000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
0000000000FFFFFF000000000000FF000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF0000
FFFF00000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF000000
FF000000000000000000000000FF000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFF00
000000000000FFFFFF0000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF0000FF00
FF000000FFFF0000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000FFFF
00FFFF0000000000000000000000FF0000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000FF00FF
FFFFFFFFFFFFFFFF00FFFF00000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FFFFFF00
FFFFFFFF0000FF0000000000FF0000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00FFFFFF
FFFFFFFF000000000000FFFF00FF00000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000FF00000000FF
00FF0000000000000000000000FF00000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF0000FF
FF00FF00000000000000000000FF00000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFF00FF
FF00FFFF00FF000000FF00FFFFFF000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFFFFFF
00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00000000
00FFFF00FF00FF000000FF000000000000FFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00FF0000
0000FFFFFFFFFF0000FF00000000000000FFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000000
0000FFFFFFFFFFFF000000FF0000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000000000
00000000FFFFFFFF000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00FF0000
0000000000FFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000FFFFFF
0000000000FFFF00000000FF000000FF00000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF0000FFFF
FF00000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000000000
00000000FFFFFFFF00000000000000000000000000FF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF00FF00
00000000FF00FFFF000000000000FFFFFFFF00FFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
FFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{512, 243.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000800000laP00`40o`000?l0003oooooooooool2
oooo003oooooooooo`;oool00?oooooooooo0_ooo`00ooooooooool2oooo003oooooooooo`;oool0
0?oooooooooo0_ooo`00ooooooooool2oooo000Woooo00<0003oooooool06Oooo`<00003oooo00<0
003oooooool05_ooo`<00002oooo00<0003oooooool05_ooo`800004oooo00<0003oooooool05ooo
o`030000oooooooo00;oool00`000?ooooooo`0Boooo1@0000;oool00`000?ooooooo`02oooo00<0
003oooooool03oooo`D000001?ooo`000000000000?oool00`000?ooooooo`0ooooo00<0003ooooo
ool06?ooo`<00003oooo00<0003oooooool05_ooo`<00002oooo00<0003oooooool05_ooo`800004
oooo00<0003oooooool05oooo`030000oooooooo00;oool00`000?ooooooo`0Boooo1@0000;oool0
0`000?ooooooo`02oooo00<0003oooooool04?ooo`D000001?ooo`000000000000?oool00`000?oo
ooooo`0Joooo000Voooo00<0003oool000006_ooo`030000oooooooo00;oool00`000?ooo`00000H
oooo00H0003oooooool0003oool0000Goooo00<0003oool000000_ooo`030000oooo000001Ooool0
0`000?ooo`000002oooo00<0003oool000005Oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`00000Boooo00D0003oooooooooool000001?ooo`030000oooo000003ooool00`000?oo
o`00000Ioooo00<0003oooooool00_ooo`030000oooo000001Soool01P000?ooooooo`000?ooo`00
01Ooool00`000?ooo`000002oooo00<0003oool000005oooo`030000oooo000000;oool00`000?oo
o`00000Eoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000001?oool01@000?oo
ooooooooo`000004oooo00<0003oool000006oooo`009_ooo`030000oooo000001_oool01`000?oo
ooooooooo`000?ooo`00000Foooo10000004oooo0000oooo00005oooo`030000oooo000000;oool0
0`000?ooo`00000Goooo00<0003oool000000_ooo`030000oooo000001Goool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000004_ooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`00000ooooo00<0003oool000006_ooo`070000oooooooooooo0000oooo000001Koool4
000000Coool0003oool0000Goooo00<0003oool000000_ooo`030000oooo000001Ooool00`000?oo
o`000002oooo00<0003oool000005Oooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`00000Coooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000001_oool002Koool0
0`000?ooo`00000Koooo00L0003oooooooooool0003oool000005_ooo`030000oooo000000;oool0
0`000?ooo`00000Goooo0P0000?oool00`000?ooo`00000Hoooo00L0003oooooooooool0003oool0
00005Oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Boooo00<0003ooooo
ool00_ooo`070000oooooooooooo0000oooo000003ooool00`000?ooo`00000Joooo00L0003ooooo
ooooool0003oool000005_ooo`030000oooo000000;oool00`000?ooo`00000Goooo0P0000?oool0
0`000?ooo`00000Hoooo00L0003oooooooooool0003oool000005Oooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`00000Coooo00<0003oooooool00_ooo`070000oooooooooooo0000
oooo000001_oool002Koool00`000?ooo`00000Joooo00<0003oool000000_ooo`030000oooo0000
01Ooool200000_ooo`030000oooo000001Ooool00`000?ooooooo`02oooo00<0003oool000005ooo
o`030000oooo000000;oool00`000?ooo`00000Eoooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000001;oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool00000?ooo
o`030000oooo000001Woool00`000?ooo`000002oooo00<0003oool000005oooo`800002oooo00<0
003oool000005oooo`030000oooooooo00;oool00`000?ooo`00000Goooo00<0003oool000000_oo
o`030000oooo000001Goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000004ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo000Woooo00<0003ooooo
ool06_ooo`030000oooooooo00;oool00`000?ooooooo`0Goooo00D0003oooooooooool000006Ooo
o`800003oooo00<0003oooooool05oooo`030000oooooooo00;oool00`000?ooooooo`0Coooo0P00
00Coool00`000?ooooooo`02oooo00<0003oooooool04?ooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo03ooool00`000?ooooooo`0Ioooo00<0003oooooool00_ooo`030000oooooooo
01Ooool01@000?ooooooooooo`00000Ioooo0P0000?oool00`000?ooooooo`0Goooo00<0003ooooo
ool00_ooo`030000oooooooo01?oool200001?ooo`030000oooooooo00;oool00`000?ooooooo`0A
oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool06_ooo`00ooooooooool2oooo003o
ooooooooo`;oool00?oooooooooo0_ooo`00ooooooooool2oooo000Tooooc@00037oooo=00004Ooo
o`009?ooo`050000oooooooooooo000000Ooool00`000?ooooooo`04oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`04oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?oo
ooooo`04oooo0P00037oool01@000?ooooooooooo`000007oooo00<0003oooooool01?ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01?ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool0
0`000?ooooooo`05oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01?ooo`80000Aoooo000Noooo00<0003oooooool00oooo`030000oooooooo
0<Woool00`000?ooooooo`0Zoooo00<0003oooooool00_ooo`030000oooooooo0<Woool00`000?oo
ooooo`0?oooo000Moooo00<0003oool000001?ooo`030000oooooooo0<Woool00`000?ooooooo`0Y
oooo00<0003oool000000oooo`030000oooooooo0<Woool00`000?ooooooo`0?oooo000Moooo00<0
003oool000001?ooo`800039oooo0P0002_oool00`000?ooo`000003oooo0P000<Woool200004Ooo
o`007Oooo`030000oooo000000Coool010000?ooooooooooo`<00009oooo1P0000Goool200001?oo
o`8000001?ooo`0000000?ooo``00005oooo0P0000?oool010000?ooooooooooo`800006oooo1@00
0003oooo0000000000X00002oooo00<0003oooooool02`000004oooo0000000000000oooo`P00000
0oooo`0000000003oooo0`0000Goool010000?ooooooo`0000?oool200000oooo`D000001?ooo`00
0000000000;oool3000000?oool0000000000oooo`P000001?ooo`000000000000Goool300004?oo
o`030000oooooooo02Woool00`000?ooo`000003oooo00<0003oooooool02Oooo`H00004oooo0P00
00Goool010000?ooooooo`0000;oool<00001?ooo`800003oooo0P0000?oool00`000?ooooooo`04
oooo1@000003oooo0000000000/000001?ooo`0000000?ooo`/00002oooo0`0000?oool700000_oo
o`040000oooooooooooo100000Coool2000000?oool0000000000oooo`040000oooooooooooo1@00
0003oooo00000000008000001?ooo`000000000000;oool010000?ooooooooooo`P000000oooo`00
0000000200001?ooo`<0000Eoooo00<0003oooooool03oooo`007Oooo`030000oooo000000Coool0
10000?ooooooooooo`<00009oooo1P0000Goool200001?ooo`8000001?ooo`0000000?ooo``00005
oooo0P0000?oool010000?ooooooooooo`800006oooo1@000003oooo0000000000X00002oooo00<0
003oooooool02`000004oooo0000000000000oooo`P000000oooo`0000000003oooo0`0000Goool0
10000?ooooooo`0000?oool200000oooo`D000001?ooo`000000000000;oool3000000?oool00000
00000oooo`P000001?ooo`000000000000Goool300004?ooo`030000oooooooo02Woool00`000?oo
o`000003oooo00<0003oooooool02Oooo`H00004oooo0P0000Goool010000?ooooooo`0000;oool<
00001?ooo`800003oooo0P0000?oool00`000?ooooooo`04oooo1@000003oooo0000000000/00000
1?ooo`0000000?ooo`/00002oooo0`0000?oool700000_ooo`040000oooooooooooo100000Coool2
000000?oool0000000000oooo`040000oooooooooooo1@000003oooo00000000008000001?ooo`00
0000000000;oool010000?ooooooooooo`P000000oooo`000000000200001?ooo`<0000Eoooo00<0
003oooooool03oooo`007_ooo`030000oooooooo00?oool010000?ooooooooooo`<00003oooo1@00
0003oooo0000000000Coool200000oooo`8000000oooo`0000000003oooo1`0000;oool010000?oo
ooooooooo`P00003oooo0`0000?oool@000000Coool00000003oool5000000Coool00000003oool3
00001oooo`<000000oooo`0000000004oooo1@000004oooo0000000000000_ooo`80000=oooo0P00
00Coool200002?ooo`040000oooooooooooo1@0000Coool300002?ooo`<00002oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool0:_ooo`030000
oooooooo00;oool00`000?ooooooo`03oooo100000;oool00`000?ooooooo`03oooo00@0003ooooo
ooooool2000000?oool0000000000oooo`P000000oooo`0000000003oooo1`0000Coool300000ooo
o`l00002oooo00<0003oooooool0100000;oool00`000?ooooooo`0300001_ooo`<00002oooo00<0
003oooooool00oooo`@00002oooo0`000003oooo0000000000koool00`000?ooooooo`03oooo00<0
003oooooool01_ooo`800003oooo100000Goool300002?ooo`<000000oooo`0000000004oooo0P00
00Coool200002_ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`8000001?ooo`00
00000?ooo`<00002oooo100000?oool2000000?oool0000000001_ooo`8000000oooo`0000000004
00000oooo`D00006oooo0`0000Koool300000_ooo`<00003oooo0`0000?oool500000oooo`040000
oooooooo00000oooo`<00004oooo00<0003oooooool01?ooo`8000000oooo`0000000003000000Co
ool00000003oool200001_ooo`D00004oooo2`0000;oool00`000?ooooooo`06oooo00@0003ooooo
ool00002oooo0`000003oooo0000000000H00002oooo100000;oool700000_ooo`030000oooooooo
00Coool00`000?ooooooo`0_oooo00<0003oooooool00oooo`<000000oooo`000000000300000ooo
o`040000oooooooo00001oooo`030000oooooooo00H00003oooo100000Koool400001_ooo`<00000
1?ooo`000000000000?oool300001?ooo`@00003oooo0P000003oooo0000000000?oool300000ooo
o`030000oooooooo00Goool00`000?ooooooo`0400000_ooo`040000oooooooo00001oooo`@00005
oooo2P0000;oool00`000?ooooooo`06oooo0P000004oooo00000000oooo0`0000;oool8000000?o
ool0000000000`000003oooo0000000000H000000oooo`000000000:oooo00<0003oooooool03ooo
o`009?ooo`040000oooooooooooo0P000004oooo00000000oooo0`0000;oool400000oooo`800000
0oooo`0000000006oooo0P000003oooo0000000000@00003oooo1@0000Koool300001_ooo`<00002
oooo0`0000?oool300000oooo`D00003oooo00@0003oooooool00003oooo0`0000Coool00`000?oo
ooooo`04oooo0P000003oooo0000000000<000001?ooo`0000000?ooo`800006oooo1@0000Coool;
00000_ooo`030000oooooooo00Koool010000?ooooooo`0000;oool3000000?oool0000000001P00
00;oool400000_ooo`L00002oooo00<0003oooooool01?ooo`030000oooooooo02ooool00`000?oo
ooooo`03oooo0`000003oooo0000000000<00003oooo00@0003oooooool00007oooo00<0003ooooo
ool01P0000?oool400001_ooo`@00006oooo0`000004oooo0000000000000oooo`<00004oooo1000
00?oool2000000?oool0000000000oooo`<00003oooo00<0003oooooool01Oooo`030000oooooooo
00@00002oooo00@0003oooooool00007oooo100000Goool:00000_ooo`030000oooooooo00Koool2
000000Coool00000003oool300000_ooo`P000000oooo`0000000003000000?oool0000000001P00
0003oooo0000000000[oool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool2000000?o
ool0000000001?ooo`800003oooo00@0003oooooooooool500000_ooo`<000000oooo`0000000004
00000oooo`8000001?ooo`000000000000;oool800000oooo`H000000oooo`0000000008000000?o
ool000000000100000;oool300000oooo`H000000oooo`0000000005000000?oool0000000001`00
00;oool3000000?oool0000000001@0000?oool00`000?ooooooo`03000000Coool0000000000002
oooo100000Coool700001Oooo`030000oooooooo00@00002oooo0P000003oooo0000000000H00000
1?ooo`0000000?ooo`D000000oooo`0000000007oooo00<0003oooooool0;oooo`030000oooooooo
00Koool010000?ooooooooooo`800003oooo100000;oool300000_ooo`H00003oooo00<0003ooooo
ool00`000003oooo0000000000H00003oooo1P0000;oool9000000?oool0000000001@000004oooo
0000000000000oooo`H00002oooo1P0000;oool9000000Coool0000000000002oooo1P0000?oool2
000000Coool0000000000002oooo0`000003oooo0000000000<00003oooo200000Coool2000000?o
ool0000000000`000004oooo00000000oooo200000;oool00`000?ooooooo`0400000_ooo`030000
oooooooo00[oool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool600000_ooo`030000
oooooooo00?oool600001Oooo`@0000;oooo100000Goool8000000?oool0000000000`000003oooo
0000000000Coool4000000?oool0000000000oooo`040000oooooooo00000_ooo`040000oooooooo
oooo0P000004oooo00000000oooo0P0000?oool5000000?oool0000000000`0000Coool200001Ooo
o`T00004oooo0`0000;oool600000_ooo`030000oooooooo00Koool400000_ooo`T00003oooo0P00
0004oooo00000000oooo0P0000Coool200000oooo`030000oooooooo00Coool00`000?ooooooo`0_
oooo00@0003oooooooooool2000000?oool0000000001?ooo`H00005oooo1@0000[oool500001?oo
o`P00002oooo100000;oool00`000?ooooooo`03oooo0`000003oooo0000000000?oool2000000Co
ool00000003oool200000oooo`040000oooooooo00000_ooo`040000oooooooooooo1@0000;oool4
00001Oooo`030000oooooooo00?oool900001Oooo`<000000oooo`000000000400000_ooo`030000
oooooooo00Koool5000000?oool0000000001`0000Coool010000?ooooooo`0000;oool00`000?oo
ooooo`03oooo00@0003oooooooooool200002_ooo`030000oooooooo00ooool002Coool200000_oo
o`H00002oooo00<0003oooooool00oooo`H00005oooo100000_oool400001Oooo`P000000oooo`00
00000003000000?oool0000000001?ooo`@000000oooo`0000000003oooo00@0003oooooool00002
oooo00@0003oooooooooool2000000Coool00000003oool200000oooo`D000000oooo`0000000003
00001?ooo`800005oooo2@0000Coool300000_ooo`H00002oooo00<0003oooooool01_ooo`@00002
oooo2@0000?oool2000000Coool00000003oool200001?ooo`800003oooo00<0003oooooool00ooo
o`80000aoooo0P0000;oool2000000?oool0000000001?ooo`H00005oooo1@0000[oool500001?oo
o`P00002oooo100000;oool00`000?ooooooo`03oooo0`000003oooo0000000000?oool2000000Co
ool00000003oool200000oooo`040000oooooooo00000_ooo`040000oooooooooooo1@0000;oool4
00001Oooo`030000oooooooo00?oool900001Oooo`<000000oooo`000000000400000_ooo`030000
oooooooo00Koool5000000?oool0000000001`0000Coool010000?ooooooo`0000;oool00`000?oo
ooooo`03oooo00@0003oooooooooool200002_ooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`<00003oooo0P0000Coool300000_ooo`040000oooooooooooo0P0000Soool600000ooo
o`040000oooooooooooo0`0000;oool5000000?oool0000000000oooo``00005oooo2@000004oooo
0000000000000_ooo`040000oooooooooooo0P0000Goool010000?ooooooo`0000;oool010000?oo
ooooo`0000;oool010000?ooooooooooo`800003oooo0P000003oooo0000000000L00006oooo0`00
00Coool:00001Oooo`<00003oooo0`0000;oool00`000?ooooooo`0300000oooo`040000oooooooo
oooo0P0000?oool00`000?ooooooo`04oooo00<0003oooooool0;oooo`030000oooooooo00?oool0
0`000?ooooooo`03oooo0`000003oooo0000000000?oool00`000?ooooooo`06oooo1P0000?oool2
00000oooo`<000000oooo`000000000300000_ooo`040000oooooooooooo300000Goool900000_oo
o`<000000oooo`0000000003oooo00<0003oooooool00oooo`8000001?ooo`0000000?ooo`800000
1?ooo`0000000?ooo`800003oooo00@0003oooooooooool200000_ooo`T00006oooo0`0000?oool;
00001?ooo`<00003oooo0`0000;oool2000000Coool0000000000003oooo0P0000?oool010000?oo
ooooooooo`80000:oooo00<0003oooooool03oooo`009?ooo`030000oooooooo00Koool010000?oo
ooooo`0000;oool3000000Coool00000003oool800000_ooo`<000000oooo`0000000007oooo1@00
00Goool010000?ooooooooooo`D00007oooo0`0000Goool8000000?oool0000000000`000004oooo
00000000oooo2P000004oooo00000000oooo0`0000?oool200000oooo`030000oooooooo00Goool3
000000Coool00000003oool2000000?oool0000000000oooo`030000oooooooo00?oool2000000Co
ool000000000000<oooo0`0000Ooool010000?ooooooooooo`D00004oooo1@000003oooo00000000
00Coool00`000?ooooooo`0_oooo00@0003oooooooooool2000000Coool00000003oool300000_oo
o`030000oooooooo00L00002oooo0`0000;oool00`000?ooooooo`06oooo100000Goool00`000?oo
ooooo`02oooo100000Soool300001?ooo`P00002oooo100000;oool00`000?ooooooo`0900000_oo
o`030000oooooooo00<00003oooo00@0003oooooooooool200001_ooo`<00002oooo00@0003ooooo
ool00002oooo00@0003oooooooooool200001?ooo`8000000oooo`000000000200003?ooo`<00006
oooo0P0000?oool400001Oooo`@00002oooo00<0003oooooool01oooo`030000oooooooo00ooool0
02Coool00`000?ooooooo`06oooo00@0003oooooool00002oooo0`000004oooo00000000oooo2000
00;oool3000000?oool0000000001oooo`D00005oooo00@0003oooooooooool500001oooo`<00005
oooo20000003oooo0000000000<000001?ooo`0000000?ooo`X000001?ooo`0000000?ooo`<00003
oooo0P0000?oool00`000?ooooooo`05oooo0`000004oooo00000000oooo0P000003oooo00000000
00?oool00`000?ooooooo`03oooo0P000004oooo0000000000003?ooo`<00007oooo00@0003ooooo
ooooool500001?ooo`D000000oooo`0000000004oooo00<0003oooooool0;oooo`040000oooooooo
oooo0P000004oooo00000000oooo0`0000;oool00`000?ooooooo`0700000_ooo`<00002oooo00<0
003oooooool01_ooo`@00005oooo00<0003oooooool00_ooo`@00008oooo0`0000Coool800000_oo
o`@00002oooo00<0003oooooool02@0000;oool00`000?ooooooo`0300000oooo`040000oooooooo
oooo0P0000Koool300000_ooo`040000oooooooo00000_ooo`040000oooooooooooo0P0000Coool2
000000?oool0000000000P0000coool300001_ooo`800003oooo100000Goool400000_ooo`030000
oooooooo00Ooool00`000?ooooooo`0?oooo000Toooo00<0003oooooool00oooo`@00003oooo1@00
00?oool010000?ooooooo`0000;oool600000_ooo`<00003oooo00@0003oooooooooool300001Ooo
oa@000000oooo`0000000002oooo100000Soool3000000?oool0000000000oooo`<00002oooo00<0
003oooooool00oooo`040000oooooooooooo1@000004oooo00000000oooo0P0000?oool300001Ooo
o`T00004oooo0P0000;oool010000?ooooooo`0000?oool600000oooo`8000000oooo`0000000009
00000_ooo`030000oooooooo00Woool00`000?ooooooo`04oooo00<0003oooooool0;oooo`040000
oooooooooooo0P0000?oool400000oooo`8000001?ooo`0000000?ooo`L000001?ooo`0000000000
00?oool200000oooo`<00004oooo500000;oool00`000?ooooooo`0500001oooo`<00002oooo00@0
003oooooooooool300000_ooo`030000oooooooo00?oool200000oooo`@00002oooo00@0003ooooo
ool00003oooo100000Coool900001Oooo`040000oooooooo00000_ooo`800003oooo1P0000?oool0
0`000?ooooooo`0;000000?oool0000000002_ooo`80000:oooo00<0003oooooool03oooo`009?oo
o`030000oooooooo00[oool200001oooo`8000000oooo`0000000003oooo0P0000?oool00`000?oo
ooooo`03oooo0`000004oooo00000000oooo0`0000;oool2000000Coool0000000000006oooo1P00
00;oool00`000?ooooooo`03oooo0P0000?oool010000?ooooooo`0000;oool400000oooo`800000
0oooo`0000000005oooo1P000003oooo0000000000Koool00`000?ooooooo`03oooo1P0000Koool2
000000Coool0000000000002oooo1P0000Woool2000000Coool0000000000002oooo1@000004oooo
00000000oooo1@0000?oool6000000?oool0000000000`0000Coool00`000?ooooooo`0_oooo00<0
003oooooool01_ooo`030000oooooooo00Koool010000?ooooooo`0000?oool200000oooo`800004
oooo0`0000;oool00`000?ooooooo`03000000Coool00000003oool400001_ooo`H000000oooo`00
00000004oooo0P0000?oool2000000Coool00000003oool500000oooo`040000oooooooo00001Ooo
o`H00002oooo00<0003oooooool01?ooo`800004oooo1`0000Koool00`000?ooooooo`03000000?o
ool000000000100000[oool00`000?ooooooo`03000000?oool0000000000`000003oooo00000000
00;oool400000oooo`H00002oooo100000Woool00`000?ooooooo`0?oooo000Toooo00<0003ooooo
ool02_ooo`800007oooo0P000003oooo0000000000?oool200000oooo`030000oooooooo00?oool3
000000Coool00000003oool300000_ooo`8000001?ooo`000000000000Koool600000_ooo`030000
oooooooo00?oool200000oooo`040000oooooooo00000_ooo`@00003oooo0P000003oooo00000000
00Goool6000000?oool0000000001_ooo`030000oooooooo00?oool600001_ooo`8000001?ooo`00
0000000000;oool600002Oooo`8000001?ooo`000000000000;oool5000000Coool00000003oool5
00000oooo`H000000oooo`000000000300001?ooo`030000oooooooo02ooool00`000?ooooooo`06
oooo00<0003oooooool01_ooo`040000oooooooo00000oooo`800003oooo0P0000Coool300000_oo
o`030000oooooooo00<000001?ooo`0000000?ooo`@00006oooo1P000003oooo0000000000Coool2
00000oooo`8000001?ooo`0000000?ooo`D00003oooo00@0003oooooool00005oooo1P0000;oool0
0`000?ooooooo`04oooo0P0000Coool700001_ooo`030000oooooooo00<000000oooo`0000000004
00002_ooo`030000oooooooo00<000000oooo`0000000003000000?oool0000000000_ooo`@00003
oooo1P0000;oool400002Oooo`030000oooooooo00ooool002Coool200000_oooa`000000oooo`00
0000001100006oooo`030000oooooooo00<00007oooo0P0000Woool200001?ooo`<00003oooo0P00
00Ooool200000oooo`800003oooo00<0003oooooool01_ooo`<000000oooo`000000000300000ooo
o`80000aoooo0P0000;ooolG00000_oood<0000Joooo00<0003oooooool00`0000Soool00`000?oo
ooooo`07oooo0P0000Goool300000oooo`030000oooooooo00Koool010000?ooooooooooo`800003
oooo0P0000Ooool300000_ooo`@00009oooo00<0003oooooool03oooo`009?ooo`040000oooooooo
oooo1P0000KooolM00000_oooa@000000oooo`000000000S00000ooooaL00002oooo<P0000?oool2
00001?ooo`8000000oooo`0000000007oooo00<0003oooooool0;oooo`040000oooooooooooo0P00
00KooolM000000?oool0000000004P0000;ooolT00001?oooaL000000oooo`000000000a00000ooo
o`030000oooooooo00?oool010000?ooooooo`0000coool00`000?ooooooo`0?oooo000Toooo00@0
003oooooooooool600001_oooad00002oooo50000003oooo0000000002<00003oooo5`0000;ooolb
00000oooo`800004oooo0P000003oooo0000000000Ooool00`000?ooooooo`0_oooo00@0003ooooo
ooooool200001_oooad000000oooo`000000000B00000_ooob@00004oooo5`000003oooo00000000
03400003oooo00<0003oooooool00oooo`040000oooooooo00003?ooo`030000oooooooo00ooool0
02Coool010000?ooooooooooob/000000oooo`000000000300001_ooo`<00003oooo0P0000Woool5
000000?oool0000000001?ooo`D000001?ooo`000000000000Goool200000oooo`L00005oooo1P00
00;oool3000000?oool0000000000`0000?oool3000000?oool000000000=`0000Coool00`000?oo
ooooo`0_oooo00@0003ooooooooooolV00000_ooo`@00007oooo0`0000?oool00`000?ooooooo`07
oooo1@0000;oool00`000?ooooooo`03oooo100000;oool300001?ooo`800003oooo200000Coool6
00000_ooo`<00002oooo100000?oool300000_ooocP00009oooo00<0003oooooool03oooo`009?oo
o`040000oooooooooooo800000;oool9000000Coool000000000000Foooo1P0000;oool010000?oo
ooooo`0000Koool=000000Coool0000000000002oooo1P0000Koool00`000?ooooooo`03oooo0P00
00?oool600000oooocX00004oooo00<0003oooooool0;oooo`040000oooooooooooo70000003oooo
0000000000L00002oooo0`0001Goool600000_ooo`8000000oooo`0000000006oooo30000003oooo
00000000008000000oooo`000000000400001_ooo`800004oooo0P0000?oool600000oooocX00009
oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo800000;oool9000000Coool00000
0000000Foooo1P0000;oool010000?ooooooo`0000Koool=000000Coool0000000000002oooo1P00
00Koool00`000?ooooooo`03oooo0P0000?oool600000oooocX00004oooo00<0003oooooool0;ooo
o`040000oooooooooooo70000003oooo0000000000L00002oooo0`0001Goool600000_ooo`800000
0oooo`0000000006oooo30000003oooo00000000008000000oooo`000000000400001_ooo`800004
oooo0P0000?oool600000oooocX00009oooo00<0003oooooool03oooo`009?ooo`040000oooooooo
oooo8`0000;oool400000oooo`X000000oooo`000000000300003_ooo`H00003oooo1P000004oooo
0000000000000_ooo`D00004oooo0P0000?oool010000?ooooooooooo`/00002oooo1`0000;ooolD
000000Coool00000003oool200001?ooo`800008oooo5@0000Coool00`000?ooooooo`0_oooo00@0
003ooooooooooolO000000?oool0000000000`0000?oool900000_ooo`@0000>oooo1P0000?oool6
00000_ooo`<000000oooo`000000000300001Oooo`040000oooooooooooo0P0000?oool:00000_oo
o`P000000oooo`000000000B00000_ooo`040000oooooooo00001Oooo`030000oooooooo00KooolE
00002Oooo`030000oooooooo00ooool002Coool010000?ooooooooooo`H00005oooo0`0000?ooolK
00000_ooo`/000000oooo`000000000300000oooo`030000oooooooo00Koool2000000?oool00000
00000oooo`030000oooooooo00<00006oooo200000?oool00`000?ooooooo`0400001_ooob@00000
0oooo`000000000Boooo0P0000Koool00`000?ooooooo`07oooo0P0000Coool00`000?ooooooo`0_
oooo00@0003oooooooooool200001?ooo`<00003oooo70000003oooo0000000000T00002oooo1000
00?oool200001oooo`800002oooo00@0003oooooooooool2000000Coool0000000000006oooo2000
00?oool2000000?oool0000000000`0000KooolS00000_ooo`030000oooooooo017oool00`000?oo
ooooo`04oooo0P0000Woool00`000?ooooooo`07oooo00<0003oooooool03oooo`009?ooo`800002
oooo1P0000Goool300000ooooa/00002oooo2`000003oooo0000000000<00003oooo00<0003ooooo
ool01_ooo`8000000oooo`0000000003oooo00<0003oooooool00`0000Koool800000oooo`030000
oooooooo00@00006oooo90000003oooo0000000001;oool200001_ooo`030000oooooooo00Ooool2
00000oooo`80000aoooo0P0000;oool200001?ooo`<00003oooo70000003oooo0000000000T00002
oooo100000?oool200001oooo`800002oooo00@0003oooooooooool2000000Coool0000000000006
oooo200000?oool2000000?oool0000000000`0000KooolS00000_ooo`030000oooooooo017oool0
0`000?ooooooo`04oooo0P0000Woool00`000?ooooooo`07oooo00<0003oooooool03oooo`009?oo
o`040000oooooooooooo9@0000Woool<00000_ooo`<00003oooo200000goool300000_ooo`<00000
0oooo`000000000900000oooo`<00002oooo00<0003oooooool050000003oooo0000000000h00000
0oooo`000000000<oooo0`0000?oool200001_ooo`030000oooooooo00Coool200001oooo`030000
oooooooo02ooool010000?ooooooooooob000009oooo3@000004oooo0000000000000oooo`P0000>
oooo0`000004oooo0000000000000_ooo`/00003oooo0`000004oooo00000000oooo500000;oool?
00000_ooo`030000oooooooo00[oool300001?ooo`030000oooooooo00Coool200001_ooo`030000
oooooooo00[oool00`000?ooooooo`0?oooo000Toooo00@0003ooooooooooolU00002Oooo``00002
oooo0`0000?oool800003Oooo`<00002oooo0`000003oooo0000000000T00003oooo0`0000;oool0
0`000?ooooooo`0D000000?oool0000000003P000003oooo0000000000coool300000oooo`800006
oooo00<0003oooooool01?ooo`800007oooo00<0003oooooool0;oooo`040000oooooooooooo8000
00Woool=000000Coool0000000000003oooo200000koool3000000Coool0000000000002oooo2`00
00?oool3000000Coool00000003ooolD00000_ooo`l00002oooo00<0003oooooool02_ooo`<00004
oooo00<0003oooooool01?ooo`800006oooo00<0003oooooool02_ooo`030000oooooooo00ooool0
02Coool010000?ooooooooooobH00002oooo0`0000CooolC0000:?ooo`030000oooooooo00OooolF
00000ooooa400004oooo2P0000Coool300000_ooo`H00003oooo0`0000Ooool00`000?ooooooo`0_
oooo00@0003ooooooooooolR000000Coool0000000000005oooo4P0002Soool200002OoooaD00003
oooo4@0000Goool900001Oooo`<000000oooo`000000000400000oooo`<0000<oooo00<0003ooooo
ool03oooo`009?ooo`030000oooooooo00OooolF000000Coool00000003oool300001_ooo`800006
oooo0`0000Woool2000000?oool000000000=oooo`800003oooo00@0003oooooool00006oooo0P00
00Koool>00001oooo`8000000oooo`000000000200001?ooo`800003oooo100000?oool2000000?o
ool0000000001oooo`030000oooooooo02ooool00`000?ooooooo`03oooo5@0000;oool00`000?oo
ooooo`0300001_ooo`030000oooooooo00Coool300002_ooo`040000oooooooo0000=oooo`800003
oooo0P000003oooo0000000000Koool00`000?ooooooo`04oooo3P0000Soool00`000?ooooooo`03
00001Oooo`040000oooooooooooo1@0000?oool010000?ooooooo`0000coool00`000?ooooooo`0?
oooo000Toooo00<0003oooooool01ooooaH000001?ooo`0000000?ooo`<00006oooo0P0000Koool3
00002Oooo`8000000oooo`000000000goooo0P0000?oool010000?ooooooo`0000Koool200001_oo
o`h00007oooo0P000003oooo0000000000800004oooo0P0000?oool400000oooo`8000000oooo`00
00000007oooo00<0003oooooool0;oooo`030000oooooooo00?ooolE00000_ooo`030000oooooooo
00<00006oooo00<0003oooooool01?ooo`<0000:oooo00@0003oooooool0000goooo0P0000?oool2
000000?oool0000000001_ooo`030000oooooooo00Coool>00002?ooo`030000oooooooo00<00005
oooo00@0003oooooooooool500000oooo`040000oooooooo00003?ooo`030000oooooooo00ooool0
01Soool300000oooo`030000oooooooo00?oool010000?ooooooooooo`D00006oooo5@0000;oool0
0`000?ooooooo`06oooo00<0003oooooool04_ooo`80000Aoooo00<0003oooooool08Oooo`80000?
oooo0P000003oooo0000000000Koool;00001oooo`8000000oooo`000000000200001?ooo`800006
oooo00<0003oooooool01?ooo`800007oooo00<0003oooooool09?ooo`<00003oooo00<0003ooooo
ool00_ooo`030000oooooooo00OooolF000000?oool0000000001oooo`80000Doooo00<0003ooooo
ool03oooo`80000Soooo00<0003oooooool03_ooo`040000oooooooo00001_ooo`/00008oooo00<0
003oooooool00`0000Goool00`000?ooooooo`04oooo0P0000Koool00`000?ooooooo`0:oooo00<0
003oooooool03oooo`006?ooo`030000oooooooo00;oool00`000?ooo`000004oooo00@0003ooooo
ooooool500001_ooo`l0000Voooo0P0000Woool200001_ooo`<0000Koooo0P000003oooo00000000
01;oool200002oooo`X0000Poooo0P0000Ooool00`000?ooooooo`0Toooo00<0003oooooool00_oo
o`030000oooo000000?oool00`000?ooooooo`07oooo3`0002Ooool00`000?ooooooo`07oooo0P00
00Koool300007?ooo`040000oooooooo00004oooo`030000oooooooo00Woool;00008?ooo`030000
oooooooo00[oool00`000?ooooooo`0?oooo000Ioooo00L0003oooooooooool0003oool000001?oo
o`800002oooo1@0000Koool?00009_ooo`800009oooo0P0000Koool300006oooo`8000000oooo`00
0000000Boooo0P0000_oool:00008?ooo`800006oooo0P0002Ooool01`000?ooooooooooo`000?oo
o`000003oooo0P0000Soool?00009oooo`030000oooooooo00Ooool200001_ooo`<0000Loooo00@0
003oooooool0000Coooo00<0003oooooool02Oooo`/0000Poooo00<0003oooooool02Oooo`80000A
oooo000Ioooo00L0003oooooooooool0003oool000001?ooo`040000oooooooooooo1@0000Koool6
00002?ooo`030000oooooooo00Koool00`000?ooooooo`0:oooo0P0000ooool200001_ooo`800003
oooo00<0003oooooool01_ooo`030000oooooooo01_oool2000000?oool0000000000P0000[oool2
00000oooo`030000oooooooo00Coool200000oooo`/00003oooo0`000003oooo0000000000800004
oooo0`0000Goool300001?ooo`800007oooo00<0003oooooool09Oooo`070000oooooooooooo0000
oooo000000?oool00`000?ooooooo`07oooo1P0000Soool00`000?ooooooo`06oooo0P0000coool0
0`000?ooooooo`0>oooo00<0003oooooool01?ooo`800003oooo0P0000Ooool200007Oooo`030000
oooooooo00<0000;oooo00@0003oooooooooool200001_ooo`040000oooooooooooo2`0000?oool3
00000_ooo`<00005oooo0`0000Coool300001Oooo`030000oooooooo00[oool00`000?ooooooo`0?
oooo000Hoooo00<0003oool000000_ooo`030000oooo000000Coool010000?ooooooooooo`D00003
oooo1`0000Goool500001_ooo`040000oooooooo00000_ooo`030000oooooooo00?oool300004_oo
o`800004oooo0P0000?oool2000000?oool0000000001?ooo`800007oooo0P000003oooo00000000
01;oool2000000?oool0000000000P0000Woool00`000?ooooooo`03oooo100000koool@00001?oo
o`<00002oooo00<0003oooooool00`0000Coool300001_ooo`030000oooooooo02Coool00`000?oo
o`000002oooo00<0003oool000000oooo`030000oooooooo00Coool800001?ooo`D00006oooo0P00
0004oooo00000000oooo0P0000Coool300004oooo`030000oooooooo00?oool010000?oooooooooo
o`800002oooo00<0003oooooool00oooo`030000oooooooo00Koool010000?ooooooo`0001?oool0
0`000?ooooooo`0300002Oooo`800004oooo1@0000koool?00001Oooo`<000001?ooo`0000000?oo
o`<00005oooo0`0000[oool00`000?ooooooo`0?oooo000Ioooo00<0003oooooool00_ooo`030000
oooooooo00?oool010000?ooooooooooo`D00003oooo1`0000Goool500001_ooo`040000oooooooo
00000_ooo`030000oooooooo00?oool300004_ooo`800004oooo0P0000?oool2000000?oool00000
00001?ooo`800007oooo0P000003oooo0000000001;oool2000000?oool0000000000P0000Woool0
0`000?ooooooo`03oooo100000koool@00001?ooo`<00002oooo00<0003oooooool00`0000Coool3
00001_ooo`030000oooooooo02Goool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000
oooooooo00Coool800001?ooo`D00006oooo0P000004oooo00000000oooo0P0000Coool300004ooo
o`030000oooooooo00?oool010000?ooooooooooo`800002oooo00<0003oooooool00oooo`030000
oooooooo00Koool010000?ooooooo`0001?oool00`000?ooooooo`0300002Oooo`800004oooo1@00
00koool?00001Oooo`<000001?ooo`0000000?ooo`<00005oooo0`0000[oool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool5000000?oool0000000001P0000Ooool200001_ooo`D00003
oooo00<0003oooooool06?ooo`800004oooo0P0000Koool200001_ooo`030000oooooooo00Ooool2
00003oooo`800003oooo1@0000Ooool600000oooo`<00003oooo0P0000;oool00`000?ooooooo`07
oooo0`0000;oool300000oooo`<00003oooo0`0000Goool00`000?ooooooo`04oooo0`0000Koool0
0`000?ooooooo`0_oooo00<0003oooooool00oooo`L00008oooo00<0003oooooool01Oooo`@00003
oooo0P0001[oool00`000?ooooooo`03oooo00<0003oooooool01Oooo`030000oooooooo00Coool2
00002Oooo`030000oooooooo00koool010000?ooooooooooo`D00008oooo1P0000?oool300000ooo
o`040000oooooooo00002_ooo`<000001?ooo`000000000000?oool300001?ooo`<00004oooo0P00
00Koool300002_ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`/00009oooo00<0
003oooooool00P0000Woool300006oooo`80000<oooo0P0000Koool00`000?ooooooo`04oooo0P00
00?oool200002_ooo`<00003oooo1`0000Koool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`@0000Aoooo0P0000?oool500000oooo`@00005oooo0`0000Coool300001_ooo`030000oooooooo
02ooool010000?ooooooooooo`H00009oooo0P000003oooo0000000000Woool300007?ooo`030000
oooooooo00_oool00`000?ooooooo`04oooo0P0000Koool010000?ooooooooooo`80000;oooo0`00
00?oool600001_ooo`800004oooo0P0000Coool500004Oooo`040000oooooooooooo1@0000?oool5
00001?ooo`<00005oooo0`0000[oool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool;
00002Oooo`030000oooooooo00800009oooo0`0001_oool200003?ooo`800006oooo00<0003ooooo
ool01?ooo`800003oooo0P0000[oool300000oooo`L00006oooo00<0003oooooool00oooo`030000
oooooooo00?oool400004Oooo`800003oooo1@0000?oool400001Oooo`<00004oooo0`0000Koool0
0`000?ooooooo`0_oooo00@0003oooooooooool600002Oooo`8000000oooo`0000000009oooo0`00
01coool00`000?ooooooo`0;oooo00<0003oooooool01?ooo`800006oooo00@0003oooooooooool2
00002oooo`<00003oooo1P0000Koool200001?ooo`800004oooo1@00017oool010000?oooooooooo
o`D00003oooo1@0000Coool300001Oooo`<0000:oooo00<0003oooooool03oooo`009?ooo`800002
oooo200000ooool2000000Coool0000000000005oooo00<0003oooooool01oooo`80000Boooo0P00
00koool00`000?ooooooo`04oooo0P0000Ooool400004?ooo`L00004oooo1@0000?oool00`000?oo
ooooo`03oooo100000Goool300004Oooo`<00003oooo0`0000?oool200001oooo`800006oooo0P00
037oool200000_ooo`<0000?oooo0P000003oooo0000000000800004oooo0P0000Woool00`000?oo
ooooo`0Aoooo00<0003oooooool03?ooo`800006oooo00<0003oooooool01_ooo`<0000Aoooo1P00
00Goool400000oooo`800004oooo1@0000Coool400004?ooo`<00004oooo0`0000?oool00`000?oo
ooooo`06oooo00<0003oooooool02_ooo`030000oooooooo00ooool002Coool010000?oooooooooo
o`/0000>oooo100000ooool200004_ooo`80000Eoooo0`0000Soool200003?ooo`<00003oooo1P00
00_oool00`000?ooooooo`03oooo0`0000Koool200001?ooo`H0000:oooo1`0000coool200001ooo
o`030000oooooooo02ooool010000?ooooooooooo`H0000>oooo1@0000ooool00`000?ooooooo`0A
oooo00<0003oooooool05?ooo`<00007oooo0P0000coool300000oooo`H0000;oooo0P0000Coool3
00001_ooo`800005oooo1P0000Woool800003?ooo`030000oooooooo00[oool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool;00003_ooo`@0000?oooo0P0001;oool200005Oooo`<00008
oooo0P0000coool300000oooo`H0000;oooo00<0003oooooool00oooo`<00006oooo0P0000Coool6
00002_ooo`L0000<oooo0P0000Ooool00`000?ooooooo`0_oooo00@0003oooooooooool600003_oo
o`D0000?oooo00<0003oooooool04Oooo`030000oooooooo01Coool300001oooo`80000<oooo0`00
00?oool600002oooo`800004oooo0`0000Koool200001Oooo`H00009oooo200000coool00`000?oo
ooooo`0:oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo0P000004oooo00000000
00000_ooo`040000oooooooooooo1@0000Coool7000000Coool00000003oool200007_ooo`80000E
oooo0`0001coool600002?ooo`030000oooooooo00Ooool300001?ooo`040000oooooooooooo0P00
00?oool400002_ooo`L00003oooo0P0000Koool300001oooo`030000oooooooo02ooool010000?oo
ooooooooo`8000000oooo`0000000003oooo100000Goool600000_ooo`040000oooooooo00007ooo
o`030000oooooooo01Coool300006oooo`H00008oooo0P0000Woool300000oooo`030000oooooooo
00;oool010000?ooooooooooo`D00009oooo200000?oool00`000?ooooooo`04oooo0`0000coool0
0`000?ooooooo`0?oooo000Toooo00@0003oooooooooool2000000?oool0000000001oooo`800000
0oooo`0000000003oooo20000004oooo0000000000003?ooo`80000Aoooo0`0001Ooool00`000?oo
ooooo`0Hoooo200000Soool010000?ooooooo`0000Koool2000000?oool0000000003?ooo`800004
oooo0`0000Goool2000000?oool0000000001`0000Goool300001oooo`030000oooooooo02ooool0
0`000?ooooooo`09oooo00@0003oooooool00003oooo200000;oool300003?ooo`030000oooooooo
00ooool300005oooo`80000Joooo1`0000Soool2000000?oool0000000001_ooo`040000oooooooo
00003Oooo`030000oooooooo00?oool300001?ooo`800002oooo2@0000Coool300003?ooo`030000
oooooooo00ooool002Coool010000?ooooooooooo`8000000oooo`0000000007oooo0P000003oooo
0000000000?oool8000000Coool000000000000<oooo0P00017oool300005oooo`030000oooooooo
01Soool800002?ooo`040000oooooooo00001_ooo`8000000oooo`000000000<oooo0P0000Coool3
00001Oooo`8000000oooo`000000000700001Oooo`<00007oooo00<0003oooooool0;oooo`030000
oooooooo00Woool010000?ooooooo`0000?oool800000_ooo`<0000<oooo00<0003oooooool03ooo
o`<0000Goooo0P0001[oool700002?ooo`8000000oooo`0000000006oooo00@0003oooooool0000=
oooo00<0003oooooool00oooo`<00004oooo0P0000;oool900001?ooo`<0000<oooo00<0003ooooo
ool03oooo`009?ooo`030000oooooooo00?oool00`000?ooooooo`07oooo0P000004oooo00000000
oooo0`0000;oool200001?ooo`<0000Poooo0P0001Goool2000000?oool0000000001?ooo`@0000?
oooo00<0003oooooool00`0000Goool010000?ooooooo`0000;oool300001oooo`<00007oooo00<0
003oooooool05?ooo`T00003oooo1`0000Koool00`000?ooooooo`0_oooo00<0003oooooool02Ooo
o`040000oooooooo00000_ooo`<000000oooo`0000000005oooo0`00023oool00`000?ooooooo`0D
oooo00@0003oooooool00005oooo0`0000ooool2000000Coool0000000000005oooo0P000004oooo
00000000oooo0`0000Soool300001_ooo`80000Eoooo2@0000?oool800002_ooo`030000oooooooo
00ooool002Coool00`000?ooooooo`06oooo00@0003oooooool00002oooo100000;oool300000ooo
o`800007oooo0P0001koool200005oooo`<00008oooo00<0003oooooool03?ooo`030000oooooooo
00?oool200000oooo`030000oooooooo00Coool200001_ooo`<000000oooo`000000000Eoooo0P00
00Koool200000oooo``00007oooo00<0003oooooool0;oooo`040000oooooooooooo0P000004oooo
00000000oooo1@000004oooo0000000000000oooo`800008oooo00<0003oooooool07Oooo`030000
oooooooo01Goool300002?ooo`030000oooooooo00coool200001?ooo`800003oooo0P0000Koool0
0`000?ooooooo`04oooo0`0000;oool00`000?ooooooo`0Doooo00<0003oooooool01Oooo`040000
oooooooooooo300000coool00`000?ooooooo`0?oooo000Toooo0P0000Ooool010000?ooooooo`00
00;oool400000_ooo`<00003oooo0P0000Ooool200007_ooo`80000Goooo0`0000Soool00`000?oo
ooooo`0<oooo00<0003oooooool00oooo`800003oooo00<0003oooooool01?ooo`800006oooo0`00
0003oooo0000000001Goool200001_ooo`800003oooo300000Koool20000<Oooo`800002oooo0P00
0004oooo00000000oooo1@000004oooo0000000000000oooo`800008oooo00<0003oooooool07Ooo
o`030000oooooooo01Goool300002?ooo`030000oooooooo00coool200001?ooo`800003oooo0P00
00Koool00`000?ooooooo`04oooo0`0000;oool00`000?ooooooo`0Doooo00<0003oooooool01Ooo
o`040000oooooooooooo300000coool00`000?ooooooo`0?oooo000Toooo00<0003oooooool01_oo
o`<00003oooo00@0003oooooooooool500002oooo`030000oooooooo00Woool00`000?ooooooo`0?
oooo0`0001Ooool2000000Coool0000000000007oooo00<0003oooooool04?ooo`80000<oooo0P00
00Koool3000000?oool0000000000oooo`80000<oooo0`0000Woool;000000Coool0000000000003
oooo0P0000Coool00`000?ooooooo`0_oooo00@0003oooooooooool300000oooo`800003oooo1000
00_oool200002_ooo`80000Aoooo0`0001Ooool00`000?ooooooo`0300001_ooo`030000oooooooo
017oool00`000?ooooooo`0;oooo00<0003oooooool01?ooo`<00002oooo00@0003oooooooooool2
00003?ooo`<0000:oooo2P0000;oool300000oooo`030000oooooooo00Ooool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool200001?ooo`800004oooo1@0000coool200007_ooo`<0000C
oooo00@0003oooooool0000>oooo0P0000ooool300003?ooo`800006oooo00<0003oooooool01Ooo
o`030000oooooooo00<000000oooo`0000000006oooo0`0000Soool00`000?ooooooo`0=00000ooo
o`800004oooo00<0003oooooool0;oooo`030000oooooooo00?oool00`000?ooooooo`03oooo1000
00goool00`000?ooooooo`0Moooo0`0001;oool2000000?oool0000000003Oooo`80000?oooo0`00
00goool00`000?ooooooo`04oooo0P0000Koool00`000?ooooooo`0300000_ooo`030000oooooooo
00Coool300002?ooo`8000000oooo`000000000<00000oooo`030000oooooooo00Ooool00`000?oo
ooooo`0?oooo000Toooo00@0003oooooooooool200001?ooo`800004oooo1@0000coool200007_oo
o`<0000Coooo00@0003oooooool0000>oooo0P0000ooool300003?ooo`800006oooo00<0003ooooo
ool01Oooo`030000oooooooo00<000000oooo`0000000006oooo0`0000Soool00`000?ooooooo`0=
00000oooo`800004oooo00<0003oooooool0;oooo`030000oooooooo00?oool00`000?ooooooo`03
oooo100000goool00`000?ooooooo`0Moooo0`0001;oool2000000?oool0000000003Oooo`80000?
oooo0`0000goool00`000?ooooooo`04oooo0P0000Koool00`000?ooooooo`0300000_ooo`030000
oooooooo00Coool300002?ooo`8000000oooo`000000000<00000oooo`030000oooooooo00Ooool0
0`000?ooooooo`0?oooo000Toooo00<0003oooooool01_ooo`@00002oooo100000Soool200001?oo
o`<0000Ioooo00<0003oooooool00oooo`030000oooooooo00Coool400004oooo`800006oooo0P00
00Woool00`000?ooooooo`0<oooo0`0000?oool200002Oooo`030000oooooooo0080000Joooo3@00
00?oool300001_ooo`030000oooooooo02ooool010000?ooooooooooo`D000000oooo`0000000003
00001oooo`800005oooo0`0001Soool200001?ooo`800006oooo0`0001Coool00`000?ooooooo`04
oooo0P0000Woool200003_ooo`<00003oooo00<0003oooooool01oooo`8000000oooo`000000000J
oooo3P0000?oool300002_ooo`030000oooooooo00ooool002Coool00`000?ooooooo`06oooo1000
00;oool400002?ooo`800004oooo0`0001Woool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`@0000Coooo0P0000Koool200002Oooo`030000oooooooo00coool300000oooo`800009oooo00<0
003oooooool00P0001[oool=00000oooo`<00006oooo00<0003oooooool0;oooo`040000oooooooo
oooo1@000003oooo0000000000<00007oooo0P0000Goool300006?ooo`800004oooo0P0000Koool3
00005?ooo`030000oooooooo00Coool200002Oooo`80000>oooo0`0000?oool00`000?ooooooo`07
oooo0P000003oooo0000000001[oool>00000oooo`<0000:oooo00<0003oooooool03oooo`009?oo
o`030000oooooooo00Coool2000000Coool00000003oool300002Oooo`800005oooo00<0003ooooo
ool08?ooo`030000oooooooo00Coool200001_ooo`80000=oooo0`00017oool200001?ooo`800003
oooo0P0000Coool2000000?oool0000000001oooo`<00002oooo0P000004oooo0000000000003?oo
o`800008oooo300000Koool00`000?ooooooo`04oooo00<0003oooooool0;oooo`030000oooooooo
00?oool00`000?ooooooo`0300002Oooo`030000oooooooo00?oool200008Oooo`800006oooo00<0
003oooooool01Oooo`030000oooooooo00coool300004Oooo`030000oooooooo00?oool010000?oo
ooooooooo`800005oooo00@0003oooooool00008oooo0`000004oooo00000000oooo100000coool0
0`000?ooooooo`06oooo300000Koool200002_ooo`030000oooooooo00ooool002Coool00`000?oo
ooooo`03oooo0`0000Coool200001oooo`800003oooo0P0000ooool010000?ooooooo`0000koool2
000000Coool0000000000008oooo0P000004oooo00000000oooo0P0000goool300001oooo`030000
oooooooo00Ooool600005oooo`<00002oooo0P0000?oool00`000?ooooooo`09oooo0`000003oooo
0000000000?oool900000_ooo`<000000oooo`000000000400001_ooo`030000oooooooo02ooool0
0`000?ooooooo`06oooo00<0003oooooool01_ooo`040000oooooooooooo0P0000ooool2000000?o
ool0000000003_ooo`030000oooooooo00<00007oooo0P000003oooo0000000000;oool00`000?oo
ooooo`0<oooo0`0000Koool200002Oooo`H0000Goooo0`000003oooo0000000000?oool200002_oo
o`<00002oooo00@0003oooooooooool:000000Coool0000000000002oooo1P0000[oool00`000?oo
ooooo`0?oooo000Toooo0P0000Coool300001?ooo`800007oooo0P0000?oool200003oooo`040000
oooooooo00003_ooo`8000001?ooo`000000000000Soool2000000Coool00000003oool200003Ooo
o`<00007oooo00<0003oooooool01oooo`H0000Goooo0`0000;oool200000oooo`030000oooooooo
00Woool3000000?oool0000000000oooo`T00002oooo0`000003oooo0000000000@00005oooo0P00
037oool200001oooo`030000oooooooo00Koool010000?ooooooooooo`80000?oooo0P000003oooo
0000000000koool00`000?ooooooo`0300001oooo`8000000oooo`0000000002oooo00<0003ooooo
ool03?ooo`<00006oooo0P0000Woool600005oooo`<000000oooo`0000000003oooo0P0000[oool3
00000_ooo`040000oooooooooooo2P000004oooo0000000000000_ooo`H0000:oooo00<0003ooooo
ool03oooo`009?ooo`040000oooooooooooo1P0000Woool500001Oooo`040000oooooooooooo0`00
00Soool00`000?ooooooo`0<oooo0P000004oooo00000000oooo0`0000[oool010000?ooooooo`00
00Soool00`000?ooooooo`07oooo0P0000Goool010000?ooooooo`0000Koool200008?ooo`<00002
oooo00@0003oooooool00005oooo0`000004oooo0000000000000_ooo`8000000oooo`000000000:
00000oooo`800003oooo00<0003oooooool01?ooo`030000oooooooo02ooool010000?oooooooooo
o`800009oooo100000Goool00`000?ooooooo`02oooo0`0000Ooool200003_ooo`040000oooooooo
00000_ooo`<00009oooo00<0003oooooool00P0000Ooool200002Oooo`030000oooooooo00?oool2
000000?oool0000000001_ooo`030000oooooooo01koool300000_ooo`8000000oooo`0000000004
oooo0`0000;oool3000000Coool00000003oool=00000oooo`040000oooooooooooo0P0000[oool0
0`000?ooooooo`0?oooo000Toooo00<0003oooooool00oooo`@00009oooo0`0000Goool2000000?o
ool0000000000`0000coool00`000?ooooooo`09oooo2@0000Goool300002oooo`030000oooooooo
00[oool200001Oooo`030000oooooooo00Koool00`000?ooooooo`04oooo0P0000?oool200001_oo
o`030000oooooooo00Koool00`000?ooooooo`03oooo1P0001?oool=00000oooo`800003oooo00<0
003oooooool01?ooo`030000oooooooo02ooool010000?ooooooooooo`800009oooo0`0000Coool2
000000?oool0000000000`0000coool200002oooo`T00004oooo0`0000_oool200003?ooo`030000
oooooooo00?oool200001oooo`800006oooo00@0003oooooooooool200001_ooo`800007oooo0P00
00Coool700004_ooo`h00003oooo00@0003oooooooooool200002_ooo`030000oooooooo00ooool0
02Coool00`000?ooooooo`03oooo100000Woool300001Oooo`8000000oooo`000000000300003?oo
o`030000oooooooo00Woool900001Oooo`<0000;oooo00<0003oooooool02_ooo`800005oooo00<0
003oooooool01_ooo`030000oooooooo00Coool200000oooo`800006oooo00<0003oooooool01_oo
o`030000oooooooo00?oool600004oooo`d00003oooo0P0000?oool00`000?ooooooo`04oooo00<0
003oooooool0;oooo`040000oooooooooooo0P0000Woool300001?ooo`8000000oooo`0000000003
00003?ooo`80000;oooo2@0000Coool300002oooo`80000<oooo00<0003oooooool00oooo`800007
oooo0P0000Koool010000?ooooooooooo`800006oooo0P0000Ooool200001?ooo`L0000Boooo3P00
00?oool010000?ooooooooooo`80000:oooo00<0003oooooool03oooo`009?ooo`030000oooooooo
00Coool200003?ooo`030000oooooooo00?oool200003oooo`030000oooooooo00coool2000000?o
ool000000000100000Koool200000oooo`<00002oooo0`0001_oool200006oooo`800006oooo2000
0004oooo0000000000000oooo`H00004oooo600000Coool00`000?ooooooo`0_oooo00<0003ooooo
ool03Oooo`800004oooo0P0000ooool200003_ooo`030000oooooooo00H00006oooo00@0003ooooo
ooooool4000000Coool000000000000Loooo00<0003oooooool06_ooo`030000oooooooo00Coool8
00000_ooo`<00003oooo1P0000?ooolH00002Oooo`030000oooooooo00ooool001Woool300000_oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool02_ooo`D000000oooo`00
00000002oooo00@0003oooooooooool200002Oooo`030000oooooooo00koool00`000?ooooooo`04
00001Oooo`<00003oooo0P0000?oool300003oooo`80000=oooo0P0000Soool00`000?ooooooo`0=
oooo0P0000Coool:000000?oool0000000001_ooo`<00005oooo2@000004oooo0000000000000_oo
o`<000001?ooo`000000000000Koool00`000?ooooooo`0Uoooo0`0000;oool00`000?ooooooo`02
oooo00<0003oooooool03?ooo`@00002oooo00@0003oooooool00004oooo00<0003oooooool01ooo
o`80000?oooo0P000003oooo0000000000<00004oooo0`0000?oool200000oooo`<0000?oooo0P00
00koool00`000?ooooooo`06oooo00<0003oooooool03_ooo`030000oooooooo00?oool900000_oo
o`030000oooooooo00Coool300001Oooo`T00002oooo0`000004oooo0000000000000_ooo`<0000:
oooo00<0003oooooool03oooo`006_ooo`060000oooooooo0000oooo00001?ooo`030000oooooooo
00?oool00`000?ooooooo`0:oooo1@000003oooo0000000000;oool010000?ooooooooooo`800009
oooo00<0003oooooool03_ooo`030000oooooooo00@00005oooo0`0000?oool200000oooo`<0000?
oooo0P0000goool200002?ooo`030000oooooooo00goool200001?ooo`X000000oooo`0000000006
oooo0`0000Goool9000000Coool0000000000002oooo0`000004oooo0000000000001_ooo`030000
oooooooo02Koool01P000?ooooooo`000?ooo`0000?oool00`000?ooooooo`0<oooo100000;oool0
10000?ooooooo`0000Coool00`000?ooooooo`07oooo0P0000ooool2000000?oool0000000000`00
00Coool300000oooo`800003oooo0`0000ooool200003_ooo`030000oooooooo00Koool00`000?oo
ooooo`0>oooo00<0003oooooool00oooo`T00002oooo00<0003oooooool01?ooo`<00005oooo2@00
00;oool3000000Coool0000000000002oooo0`0000[oool00`000?ooooooo`0?oooo000Hoooo1000
0004oooo0000oooo00001?ooo`80000:oooo00<0003oooooool00`0000?oool00`000?ooooooo`03
oooo0P0000Coool200003?ooo`030000oooooooo00koool600001_ooo`800004oooo0P0000[oool2
00002?ooo`030000oooooooo00Woool00`000?ooooooo`0Hoooo0P0000Koool500002_ooo`D00003
oooo3`0000;oool3000000?oool0000000000`0000?oool200009_ooo`@000001?ooo`000?ooo`00
00?oool200001Oooo`8000001?ooo`000000000000?oool200001?ooo`800005oooo00<0003ooooo
ool02_ooo`80000?oooo1P0000Koool200001Oooo`030000oooooooo00Woool00`000?ooooooo`06
oooo00<0003oooooool02Oooo`80000Joooo00<0003oooooool01?ooo`D0000;oooo100000?oool@
000000Coool0000000000002oooo100000Soool200004Oooo`006?ooo`030000oooo000000;oool0
0`000?ooo`000004oooo00<0003oooooool02Oooo`030000oooooooo00?oool700001?ooo`<00000
0oooo`000000000Noooo1@0000?oool00`000?ooooooo`0<oooo0P0000?oool300001_ooo`<00003
oooo0`0000Goool00`000?ooooooo`06oooo0P0000Ooool300001Oooo`030000oooooooo00Coool2
00000_ooo`040000oooooooooooo1@0000Coool300001OoooaX00004oooo00<0003oooooool09?oo
o`030000oooo000000;oool00`000?ooo`000003oooo00<0003oooooool01?ooo`800004oooo2000
00?oool300000_ooo`030000oooooooo01goool400000oooo`80000>oooo00@0003oooooooooool3
00001_ooo`<00004oooo0`0000Coool200001oooo`800008oooo0`0000Coool200001_ooo`040000
oooooooo00001?ooo`@00005oooo0`0000CooolJ00002Oooo`030000oooooooo00ooool001Woool2
00000_ooo`030000oooo000000Coool00`000?ooooooo`09oooo00<0003oooooool00oooo`L00004
oooo0`000003oooo0000000001koool500000oooo`030000oooooooo00coool200000oooo`<00006
oooo0`0000?oool300001Oooo`030000oooooooo00Koool200001oooo`<00005oooo00<0003ooooo
ool01?ooo`800002oooo00@0003oooooooooool500001?ooo`<00005oooo6P0000Coool00`000?oo
ooooo`0Uoooo0P0000;oool00`000?ooo`000003oooo00<0003oooooool01?ooo`800004oooo2000
00?oool300000_ooo`030000oooooooo01goool400000oooo`80000>oooo00@0003oooooooooool3
00001_ooo`<00004oooo0`0000Coool200001oooo`800008oooo0`0000Coool200001_ooo`040000
oooooooo00001?ooo`@00005oooo0`0000CooolJ00002Oooo`030000oooooooo00ooool001[oool0
1@000?ooooooooooo`000005oooo00<0003oooooool01?ooo`800004oooo0P0000Coool300001ooo
o`030000oooooooo00<0000<oooo00<0003oooooool03?ooo`<00003oooo0P0000?oool00`000?oo
ooooo`03oooo0P000004oooo0000000000002?ooo`030000oooooooo00Soool3000000Coool00000
00000005oooo00<0003oooooool03oooo`<00005oooo00@0003oooooooooool2000000?oool00000
00000_ooo`030000oooooooo00?oool400000oooo`D000000oooo`000000000B00000oooo`800000
0oooo`0000000004oooo00<0003oooooool09_ooo`050000oooooooooooo000000Coool00`000?oo
ooooo`06oooo00<0003oooooool00oooo`<00006oooo00<0003oooooool00`0000coool200003_oo
o`<00003oooo00@0003oooooooooool200001?ooo`800002oooo0`0000Ooool200002Oooo`<00002
oooo0`0000Coool200004Oooo`<00004oooo0P0000?oool010000?ooooooo`0000;oool00`000?oo
ooooo`03oooo1@0000?oool400000_oooa@00003oooo00@0003oooooool00009oooo00<0003ooooo
ool03oooo`009?ooo`030000oooooooo00Coool200000oooo`<00003oooo00@0003oooooooooool2
00000oooo`H0000Ooooo0`000004oooo00000000oooo0P0000Goool300003Oooo`<00005oooo0`00
00;oool010000?ooooooo`0000Woool200003_ooo`040000oooooooooooo0P000003oooo00000000
00?oool00`000?ooooooo`02oooo00<0003oooooool00oooo`@00003oooo1@0000?oool900000_oo
o`L00005oooo0`0000Coool00`000?ooooooo`0_oooo00<0003oooooool01?ooo`<00003oooo0P00
00?oool010000?ooooooooooo`L0000Noooo0`0000;oool010000?ooooooo`0000Goool300003_oo
o`<00004oooo0`0000;oool2000000?oool0000000002Oooo`030000oooooooo00coool200000ooo
o`040000oooooooo00000oooo`800003oooo00<0003oooooool00oooo`D00003oooo100000?oool:
000000?oool0000000001P0000Coool300002Oooo`030000oooooooo00ooool002Coool00`000?oo
ooooo`04oooo0P0000?oool300000oooo`040000oooooooooooo0P0000?oool600007oooo`<00000
1?ooo`0000000?ooo`800005oooo0`0000goool300001Oooo`<00002oooo00@0003oooooool00009
oooo0P0000koool010000?ooooooooooo`8000000oooo`0000000003oooo00<0003oooooool00_oo
o`030000oooooooo00?oool400000oooo`D00003oooo2@0000;oool700001Oooo`<00004oooo00<0
003oooooool0;oooo`030000oooooooo00Coool300000oooo`800003oooo00@0003oooooooooool7
00007_ooo`<00002oooo00@0003oooooool00005oooo0`0000koool300001?ooo`<00002oooo0P00
0003oooo0000000000Woool00`000?ooooooo`0<oooo0P0000?oool010000?ooooooo`0000?oool2
00000oooo`030000oooooooo00?oool500000oooo`@00003oooo2P000003oooo0000000000H00004
oooo0`0000Woool00`000?ooooooo`0?oooo000Toooo00<0003oooooool01_ooo`030000oooooooo
00<00003oooo1P0000?oool2000000Coool000000000000Poooo0P000003oooo0000000000Coool2
00000_ooo`<0000Hoooo1@0001koool200001oooo`800002oooo0`000004oooo00000000oooo0`00
00;oool010000?ooooooo`0000;oool;00001_ooo`@00002oooo1P0000Coool00`000?ooooooo`0_
oooo00@0003oooooooooool2000000Coool0000000000003oooo1P0000?oool2000000?oool00000
00000P00023oool010000?ooooooo`0000Goool00`000?ooooooo`0300006?ooo`D0000Ooooo00<0
003oooooool01_ooo`030000oooooooo00<00002oooo00<0003oooooool00`000004oooo00000000
oooo0P000003oooo0000000000T00006oooo1@000003oooo0000000000@00009oooo00<0003ooooo
ool03oooo`009?ooo`030000oooooooo00Woool300000oooo`<000000oooo`0000000003oooo1P00
00koool00`000?ooooooo`0?oooo0P0000Coool200000oooo`<0000Boooo0P0000coool200003?oo
o`800006oooo0`0000?oool00`000?ooooooo`06oooo00<0003oooooool01@000004oooo00000000
oooo0P0000CooolA00002Oooo`D000000oooo`0000000004oooo00<0003oooooool0;oooo`030000
oooooooo00Coool300000oooo`<00002oooo00@0003oooooooooool700003Oooo`80000Aoooo00<0
003oooooool00oooo`040000oooooooooooo0`0001?oool00`000?ooooooo`0;oooo00<0003ooooo
ool02_ooo`800006oooo0`0000?oool200001oooo`8000000oooo`000000000300000_ooo`040000
oooooooo00001Ooooa400009oooo100000;oool00`000?ooooooo`07oooo00<0003oooooool03ooo
o`009?ooo`80000:oooo0`0000?oool3000000?oool0000000000oooo`H0000>oooo00<0003ooooo
ool03oooo`800004oooo0P0000?oool300004_ooo`80000<oooo0P0000coool200001_ooo`<00003
oooo00<0003oooooool01_ooo`030000oooooooo00D000001?ooo`0000000?ooo`800004oooo4@00
00Woool5000000?oool0000000000oooo`80000aoooo0P0000Goool300000oooo`<00002oooo00@0
003oooooooooool700003Oooo`80000Aoooo00<0003oooooool00oooo`040000oooooooooooo0`00
01?oool00`000?ooooooo`0;oooo00<0003oooooool02_ooo`800006oooo0`0000?oool200001ooo
o`8000000oooo`000000000300000_ooo`040000oooooooo00001Ooooa400009oooo100000;oool0
0`000?ooooooo`07oooo00<0003oooooool03oooo`009?ooo`030000oooooooo00[oool200000ooo
o`<000001?ooo`0000000?ooo`P0000>oooo00<0003oooooool03oooo`8000000oooo`0000000003
oooo0`0000;oool00`000?ooooooo`0:oooo0P0000Coool300001?ooo`030000oooooooo00?oool3
000000?oool0000000001_ooo`030000oooooooo00800007oooo0P0000?oool00`000?ooooooo`04
oooo0`0000Goool200000oooo`<000000oooo`0000000003000000Coool00000003oool500000ooo
o`800004oooo1P0000;oool400001_ooo`030000oooooooo02ooool00`000?ooooooo`06oooo00@0
003oooooooooool300000_ooo`030000oooooooo00P0000=oooo0P00017oool010000?ooooooo`00
00?oool300000_ooo`030000oooooooo00_oool00`000?ooooooo`03oooo0`0000?oool00`000?oo
ooooo`03oooo0`0000;oool00`000?ooooooo`04oooo0P000003oooo0000000000Soool010000?oo
ooooooooo`800006oooo0`0000Coool200000oooo`<00002oooo100000;oool00`000?ooooooo`04
00001?ooo`030000oooooooo00?oool6000000?oool0000000000`0000[oool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool300001_ooo`8000000oooo`0000000003000000?oool00000
00000`0000?oool300008?ooo`800004oooo1@0000Goool010000?ooooooo`0000?oool200005Ooo
o`80000<oooo0P0000Ooool300000_ooo`030000oooooooo00Koool00`000?ooooooo`02oooo0`00
0003oooo0000000000l00003oooo0`0000coool200002_ooo`030000oooooooo02ooool00`000?oo
ooooo`06oooo00<0003oooooool0100000;oool400000oooo`@0000Poooo00<0003oooooool00ooo
o`@00005oooo0P000003oooo0000000000?oool00`000?ooooooo`0Doooo00<0003oooooool02_oo
o`800008oooo0`000003oooo0000000000Ooool200000oooo`<00002oooo400000?oool400003?oo
o`030000oooooooo00goool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool300001_oo
o`8000000oooo`0000000003000000?oool0000000000`0000?oool300008?ooo`800004oooo1@00
00Goool010000?ooooooo`0000?oool200005Oooo`80000<oooo0P0000Ooool300000_ooo`030000
oooooooo00Koool00`000?ooooooo`02oooo0`000003oooo0000000000l00003oooo0`0000coool2
00002_ooo`030000oooooooo02ooool00`000?ooooooo`06oooo00<0003oooooool0100000;oool4
00000oooo`@0000Poooo00<0003oooooool00oooo`@00005oooo0P000003oooo0000000000?oool0
0`000?ooooooo`0Doooo00<0003oooooool02_ooo`800008oooo0`000003oooo0000000000Ooool2
00000oooo`<00002oooo400000?oool400003?ooo`030000oooooooo00goool00`000?ooooooo`0?
oooo000Toooo00@0003oooooooooool8000000?oool0000000000oooo`040000oooooooooooo0`00
00Goool300006_ooo`<00003oooo0`0000Goool00`000?ooooooo`05000000?oool0000000003Ooo
o`D00009oooo0P0000?oool00`000?ooooooo`0?oooo0`0000;oool300000oooo`<00005oooo0`00
00Coool5000000?oool0000000000`000003oooo00000000008000000oooo`000000000400002?oo
o`040000oooooooo00002Oooo`030000oooooooo02ooool010000?ooooooooooo`<00002oooo00@0
003oooooooooool200000oooo`<00004oooo100001[oool300000oooo`<00004oooo0P000003oooo
0000000000<00002oooo00<0003oooooool03?ooo`@0000:oooo00@0003oooooooooool200004Ooo
o`<000001?ooo`000000000000?oool300001Oooo`<00005oooo100000;oool400000_ooo`<00000
0oooo`000000000500001oooo`8000000oooo`000000000=oooo00<0003oooooool03oooo`009?oo
o`040000oooooooooooo20000003oooo0000000000?oool010000?ooooooooooo`<00005oooo0`00
01[oool300000oooo`<00005oooo00<0003oooooool01@000003oooo0000000000goool500002Ooo
o`800003oooo00<0003oooooool03oooo`<00002oooo0`0000?oool300001Oooo`<00004oooo1@00
0003oooo0000000000<000000oooo`0000000002000000?oool000000000100000Soool010000?oo
ooooo`0000Woool00`000?ooooooo`0_oooo00@0003oooooooooool300000_ooo`040000oooooooo
oooo0P0000?oool300001?ooo`@0000Joooo0`0000?oool300001?ooo`8000000oooo`0000000003
00000_ooo`030000oooooooo00coool400002_ooo`040000oooooooooooo0P00017oool3000000Co
ool0000000000003oooo0`0000Goool300001Oooo`@00002oooo100000;oool3000000?oool00000
00001@0000Ooool2000000?oool0000000003Oooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`P00007oooo0P000003oooo0000000000<00003oooo0`0001coool00`000?ooooooo`03
000000Coool00000003oool200001Oooo`030000oooooooo00?oool00`000?ooooooo`0Joooo00<0
003oooooool01oooo`800008oooo00@0003oooooool00002oooo00<0003oooooool00oooo`030000
oooooooo00?oool500001?ooo`H00002oooo100000Soool200000oooo`H0000=oooo00<0003ooooo
ool0;oooo`040000oooooooooooo0`0000Soool00`000?ooooooo`0400000oooo`@0000Koooo0P00
0004oooo0000000000000_ooo`040000oooooooo00001Oooo`030000oooooooo00?oool200006ooo
o`800009oooo00<0003oooooool01_ooo`8000001?ooo`0000000?ooo`800004oooo0P0000Coool5
00001Oooo`H000000oooo`000000000300002?ooo`040000oooooooooooo1P0001;oool00`000?oo
ooooo`0?oooo000Toooo00@0003oooooooooool200002Oooo`040000oooooooooooo0P000003oooo
0000000000<00003oooo1@0000Coool200005?ooo`030000oooooooo00<00004oooo0P0000Soool0
0`000?ooooooo`0@oooo0P0000;oool00`000?ooooooo`06oooo0`000004oooo00000000oooo0P00
00?oool200001_ooo`030000oooooooo00Ooool300003_ooo`8000000oooo`0000000003oooo0`00
0003oooo0000000000;oool300001oooo`<00002oooo00<0003oooooool02_ooo`030000oooooooo
02ooool00`000?ooooooo`07oooo0P0000?oool00`000?ooooooo`0400000oooo`D00005oooo00<0
003oooooool04_ooo`8000001?ooo`000000000000Goool00`000?ooooooo`06oooo0P0001;oool0
10000?ooooooo`0000Soool300000_ooo`040000oooooooo00000oooo`800006oooo0P0000Woool3
00003_ooo`040000oooooooo00000oooo`<00002oooo00<0003oooooool00`0000Soool3000000?o
ool0000000004?ooo`030000oooooooo00ooool002Coool200000_ooo`800009oooo00@0003ooooo
ooooool2000000?oool0000000000`0000?oool500001?ooo`80000Doooo00<0003oooooool00`00
00Coool200002?ooo`030000oooooooo013oool200000_ooo`030000oooooooo00Koool3000000Co
ool00000003oool200000oooo`800006oooo00<0003oooooool01oooo`<0000>oooo0P000003oooo
0000000000?oool3000000?oool0000000000_ooo`<00007oooo0`0000;oool00`000?ooooooo`09
oooo0P00037oool200002?ooo`800003oooo00<0003oooooool0100000?oool500001Oooo`030000
oooooooo01;oool2000000Coool0000000000005oooo00<0003oooooool01_ooo`80000Boooo00@0
003oooooool00008oooo0`0000;oool010000?ooooooo`0000?oool200001_ooo`800009oooo0`00
00koool010000?ooooooo`0000?oool300000_ooo`030000oooooooo00<00008oooo0`000003oooo
00000000013oool00`000?ooooooo`0?oooo000Toooo00@0003oooooooooool800000oooo`H00000
0oooo`0000000005000000?oool0000000000`0000Koool00`000?ooooooo`0Aoooo1P0000?oool3
00000oooo`8000000oooo`0000000004oooo0`0000Koool200004Oooo`<0000Koooo0P0000Soool3
000000Coool0000000000003oooo0`0000;oool3000000?oool0000000000`0000?oool200000ooo
o`040000oooooooo00003oooo`030000oooooooo02ooool010000?ooooooooooo`<00003oooo1P00
00;oool6000000?oool0000000000`0000Koool200004_ooo`H00003oooo0`0000?oool2000000?o
ool0000000001Oooo`<00006oooo00<0003oooooool03oooo`<0000Loooo00<0003oooooool01_oo
o`<00002oooo0`0000?oool3000000Coool0000000000002oooo100000Coool010000?oooooooooo
o`8000000oooo`000000000Coooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo2000
00?oool3000000?oool0000000000oooo`D000000oooo`000000000300007Oooo`<000000oooo`00
0000000<00001Oooo`040000oooooooo00002?ooo`030000oooooooo00_oool300004Oooo`@00005
oooo0`0000Coool4000000Coool00000003oool600000oooo`8000001?ooo`000000000000Ooool0
10000?ooooooo`0000?oool200002_ooo`800004oooo00<0003oooooool0;oooo`040000oooooooo
oooo0`0000?oool300000_ooo`040000oooooooooooo1@000003oooo0000000000<0000Moooo0`00
00;oool>00001?ooo`8000000oooo`0000000007oooo0P0000coool300004Oooo`D00004oooo0`00
00Goool3000000?oool0000000000_ooo`H00003oooo00<0003oooooool00`0000Koool2000000?o
ool0000000000oooo`030000oooooooo00Woool00`000?ooooooo`07oooo00<0003oooooool03ooo
o`009?ooo`040000oooooooooooo200000?oool3000000?oool0000000000oooo`D000000oooo`00
0000000300007Oooo`<000000oooo`000000000<00001Oooo`040000oooooooo00002?ooo`030000
oooooooo00_oool300004Oooo`@00005oooo0`0000Coool4000000Coool00000003oool600000ooo
o`8000001?ooo`000000000000Ooool010000?ooooooo`0000?oool200002_ooo`800004oooo00<0
003oooooool0;oooo`040000oooooooooooo0`0000?oool300000_ooo`040000oooooooooooo1@00
0003oooo0000000000<0000Moooo0`0000;oool>00001?ooo`8000000oooo`0000000007oooo0P00
00coool300004Oooo`D00004oooo0`0000Goool3000000?oool0000000000_ooo`H00003oooo00<0
003oooooool00`0000Koool2000000?oool0000000000oooo`030000oooooooo00Woool00`000?oo
ooooo`07oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo200000?oool>00000ooo
o`<000000oooo`000000000:oooo0P0000koool300002Oooo`80000:oooo0P0000Woool300000_oo
o`<00003oooo00@0003oooooooooool200002Oooo`800006oooo00@0003oooooool00003oooo0`00
00[oool3000000?oool0000000001?ooo`800004oooo200000Goool00`000?ooooooo`0:oooo0P00
00Ooool00`000?ooooooo`0_oooo00@0003oooooooooool300000oooo`h00003oooo0`0000;oool0
0`000?ooooooo`09oooo00<0003oooooool03?ooo`<00009oooo0P0000_oool00`000?ooooooo`07
oooo0`0000;oool300000oooo`800003oooo00<0003oooooool01oooo`800006oooo0P000003oooo
0000000000?oool300002Oooo`<00002oooo00<0003oooooool00oooo`030000oooooooo00?oool7
00001Oooo`80000<oooo00<0003oooooool02_ooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`P00003oooo1P000004oooo00000000oooo100000?oool300000oooo`030000oooooooo
00?oool010000?ooooooooooo`80000>oooo0`0000Ooool400002_ooo`80000:oooo10000003oooo
0000000000<000000oooo`0000000007oooo0P0000?oool200002Oooo`040000oooooooooooo0P00
00_oool400002?ooo`<0000<oooo0P00013oool200001?ooo`030000oooooooo02ooool010000?oo
ooooooooo`<00003oooo1P0000;oool00`000?ooooooo`0300000oooo`<00003oooo0P0000Coool2
00000oooo`030000oooooooo00coool300002?ooo`<0000;oooo00<0003oooooool02Oooo`<00000
0oooo`000000000300000_ooo`030000oooooooo00Koool010000?ooooooooooo`800009oooo0P00
00?oool00`000?ooooooo`09oooo1@0000Ooool300003Oooo`030000oooooooo00ooool00`000?oo
ooooo`07oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo200000?oool6000000Co
ool00000003oool400000oooo`<00003oooo00<0003oooooool00oooo`040000oooooooooooo0P00
00koool300001oooo`@0000:oooo0P0000[oool4000000?oool0000000000`000003oooo00000000
00Ooool200000oooo`800009oooo00@0003oooooooooool200002oooo`@00008oooo0`0000coool2
00004?ooo`800004oooo00<0003oooooool0;oooo`040000oooooooooooo0`0000?oool600000_oo
o`030000oooooooo00<00003oooo0`0000?oool200001?ooo`800003oooo00<0003oooooool03?oo
o`<00008oooo0`0000_oool00`000?ooooooo`09oooo0`000003oooo0000000000<00002oooo00<0
003oooooool01_ooo`040000oooooooooooo0P0000Woool200000oooo`030000oooooooo00Woool5
00001oooo`<0000=oooo00<0003oooooool03oooo`030000oooooooo00Ooool00`000?ooooooo`0?
oooo000Toooo0P0000;oool800001?ooo`T00002oooo0`0000;oool400001Oooo`040000oooooooo
00004Oooo`800009oooo00<0003oooooool04Oooo`030000oooooooo00?oool00`000?ooooooo`02
oooo0`000003oooo0000000000?oool00`000?ooooooo`03oooo00@0003oooooooooool200002Ooo
o`<00002oooo0`0001goool00`000?ooooooo`08oooo00<0003oooooool03?ooo`030000oooooooo
00?oool20000<Oooo`800002oooo0`0000Goool9000000Coool0000000000002oooo1@0000Coool2
000000?oool0000000004Oooo`030000oooooooo00Ooool200004_ooo`800004oooo0P0000?oool3
00000_ooo`040000oooooooooooo0P0000Coool200000oooo`030000oooooooo00Soool3000000Co
ool000000000000Moooo0P0000Woool200003Oooo`80000:oooo00<0003oooooool03oooo`009?oo
o`040000oooooooooooo200000?oool:00001oooo`@00005oooo100000Goool00`000?ooooooo`02
oooo00@0003oooooooooool200000oooo`040000oooooooooooo0P0000ooool5000000Coool00000
003oool300000oooo`D00006oooo0`0000Goool010000?ooooooooooo`80000<oooo0P000003oooo
0000000000<0000Uoooo00<0003oooooool03?ooo`030000oooooooo00Coool00`000?ooooooo`0_
oooo00@0003oooooooooool300000oooo`/00006oooo1@0000Coool500001?ooo`800003oooo00<0
003oooooool00_ooo`040000oooooooooooo0P0000?oool00`000?ooooooo`0>oooo100000;oool0
0`000?ooooooo`0300000oooo`@00007oooo0`0000Coool200000oooo`030000oooooooo00_oool0
0`000?ooooooo`0400009Oooo`80000=oooo0P0000[oool00`000?ooooooo`0?oooo000Toooo00@0
003oooooooooool800000oooo`X00007oooo100000Goool400001Oooo`030000oooooooo00;oool0
10000?ooooooooooo`800003oooo00@0003oooooooooool200003oooo`D000001?ooo`0000000?oo
o`<00003oooo1@0000Koool300001Oooo`040000oooooooooooo0P0000coool2000000?oool00000
00000`0002Goool00`000?ooooooo`0<oooo00<0003oooooool01?ooo`030000oooooooo02ooool0
10000?ooooooooooo`<00003oooo2`0000Koool500001?ooo`D00004oooo0P0000?oool00`000?oo
ooooo`02oooo00@0003oooooooooool200000oooo`030000oooooooo00koool400000_ooo`030000
oooooooo00<00003oooo100000Ooool300001?ooo`800003oooo00<0003oooooool02oooo`030000
oooooooo00@0000Uoooo0P0000goool200002_ooo`030000oooooooo00ooool002Coool010000?oo
ooooooooo`P00003oooo2@0000Woool300002oooo`030000oooooooo00?oool200002Oooo`040000
oooooooooooo0P0000koool400000_ooo`<00003oooo00<0003oooooool01_ooo`P000001?ooo`00
0000000000;oool010000?ooooooooooo`80000;oooo00<0003oooooool09Oooo`030000oooooooo
00?oool010000?ooooooo`0000Woool200001oooo`030000oooooooo02ooool010000?oooooooooo
o`<00003oooo2@0000[oool300002_ooo`800004oooo0P0000Woool200000oooo`030000oooooooo
00coool5000000Coool0000000000003oooo0P0000Ooool800000_ooo`<000000oooo`0000000003
oooo00<0003oooooool02Oooo`80000Voooo00<0003oooooool00oooo`8000000oooo`0000000009
oooo00<0003oooooool02_ooo`030000oooooooo00ooool002Coool010000?ooooooooooo`P00003
oooo2@0001;oool200002Oooo`<00008oooo00@0003oooooooooool200003?ooo`<00005oooo1000
00Goool5000000?oool0000000000oooo`L00002oooo00@0003oooooooooool200002?ooo`@0000W
oooo00<0003oooooool02Oooo`030000oooooooo00goool00`000?ooooooo`0_oooo00@0003ooooo
ooooool300000oooo`T0000Coooo00<0003oooooool01oooo`<00008oooo0P0000?oool00`000?oo
ooooo`0;oooo0`0000Coool500001?ooo`D000000oooo`0000000003oooo20000003oooo00000000
00?oool00`000?ooooooo`06oooo1@0002Koool00`000?ooooooo`09oooo0P0001?oool00`000?oo
ooooo`0?oooo000Toooo00@0003oooooooooool800000oooo`T0000Boooo0P0000Woool300002?oo
o`040000oooooooooooo0P0000coool300001Oooo`@00005oooo1@000003oooo0000000000?oool7
00000_ooo`040000oooooooooooo0P0000Soool400009oooo`030000oooooooo00Woool00`000?oo
ooooo`0=oooo00<0003oooooool0;oooo`040000oooooooooooo0`0000?oool900004oooo`030000
oooooooo00Ooool300002?ooo`800003oooo00<0003oooooool02oooo`<00004oooo1@0000Coool5
000000?oool0000000000oooo`P000000oooo`0000000003oooo00<0003oooooool01_ooo`D0000V
oooo00<0003oooooool02Oooo`80000Coooo00<0003oooooool03oooo`006?ooo`800004oooo00<0
003oooooool00oooo`030000oooooooo02[oool300000oooo`800003oooo0P000003oooo00000000
00?oool00`000?ooooooo`04oooo0`0000Goool600000_ooo`d00005oooo0P000003oooo00000000
00L00005oooo00<0003oooooool00oooo`<0000aoooo0P000003oooo0000000000Coool200001_oo
o`<00004oooo00<0003oooooool09?ooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
02Koool300000oooo`040000oooooooooooo0P0000;oool010000?ooooooooooo`800006oooo0`00
00Coool7000000?oool000000000300000Coool200000_ooo`T00004oooo0P0000Coool40000<Ooo
o`040000oooooooo00001Oooo`030000oooooooo00Coool300002Oooo`030000oooooooo00ooool0
01Soool00`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo033oool200000_oo
o`<000000oooo`0000000007oooo0P000003oooo0000000000?oool800000ooooa4000000oooo`00
0000000400000_ooo`@00005oooo1@0003Soool;00001?ooo`800004oooo00<0003oooooool09?oo
o`030000oooo000000;oool00`000?ooo`000003oooo00<0003oooooool0;?ooo`030000oooooooo
00<00002oooo00<0003oooooool01_ooo`040000oooooooo00000oooo`P00003oooo4@000003oooo
0000000000D000000oooo`000000000300001?ooo`D0000ioooo2P0000Goool00`000?ooooooo`07
oooo00<0003oooooool03oooo`006?ooo`030000oooo000000;oool00`000?ooo`000004oooo0P00
037oool200000_ooo`<000000oooo`0000000007oooo0P000003oooo0000000000?oool800000ooo
oa4000000oooo`000000000400000_ooo`@00005oooo1@0003Soool;00001?ooo`800003oooo0P00
02Koool00`000?ooo`000002oooo00<0003oool000000oooo`80000]oooo00<0003oooooool00`00
00;oool00`000?ooooooo`06oooo00@0003oooooool00003oooo200000?ooolA000000?oool00000
00001@000003oooo0000000000<00004oooo1@0003Woool:00001Oooo`030000oooooooo00Koool2
00004Oooo`006?ooo`800003oooo00<0003oool000001?ooo`030000oooooooo03Ooool010000?oo
ooooo`0000Koool200001_ooo`8000001?ooo`000000000000;ooolD000000?oool0000000001000
00;oool400000oooo`<00014oooo1`0000Koool00`000?ooooooo`0Toooo0P0000?oool00`000?oo
o`000003oooo00<0003oooooool0<_ooo`8000000oooo`0000000006oooo00<0003oooooool01?oo
o`8000000oooo`0000000002000000?oool0000000004P000003oooo0000000000D000000oooo`00
0000000300000oooo`<00013oooo200000[oool00`000?ooooooo`0?oooo000Hoooo00<0003ooooo
ool00_ooo`030000oooo000000Coool00`000?ooooooo`0hoooo0P000004oooo0000000000001Ooo
o`030000oooooooo00?oool2000000Coool00000003ooolI000000Coool0000000000002oooo1000
00?oool30000=Oooo`@00008oooo00@0003oooooooooool2000000Coool00000003oool200001?oo
o`030000oooooooo02Coool00`000?ooooooo`02oooo00<0003oool000000oooo`030000oooooooo
03Coool00`000?ooooooo`0300001?ooo`800004oooo0P000003oooo0000000000;ooolH00000_oo
o`<000000oooo`000000000300000oooo`<0000doooo1@0000Ooool200000oooo`040000oooooooo
00000_ooo`030000oooooooo00Ooool00`000?ooooooo`0?oooo000Ioooo0P0000?oool00`000?oo
ooooo`03oooo00<0003oooooool0>?ooo`8000001?ooo`000000000000Goool00`000?ooooooo`03
oooo0P000004oooo00000000oooo6@000004oooo0000000000000_ooo`@00003oooo0`0003Goool4
00002?ooo`040000oooooooooooo0P000004oooo00000000oooo0P0000Coool00`000?ooooooo`0U
oooo0P0000?oool00`000?ooooooo`02oooo00<0003oooooool0=?ooo`030000oooooooo00<00004
oooo0P0000Coool2000000?oool0000000000_oooaP00002oooo0`000003oooo0000000000<00003
oooo0`0003Coool500001oooo`800003oooo00@0003oooooool00002oooo00<0003oooooool01ooo
o`030000oooooooo00ooool002Coool00`000?ooooooo`0joooo00<0003oooooool01oooo`P00002
oooo6P000004oooo00000000oooo1P0000?oool20000?oooo`040000oooooooo00003oooo`030000
oooooooo02ooool00`000?ooooooo`0eoooo0P0000Woool700000_oooaX00002oooo00<0003ooooo
ool01P0000?oool00`000?ooooooo`0moooo0P000003oooo0000000001?oool00`000?ooooooo`0?
oooo000Toooo00<0003oooooool0?Oooo`040000oooooooooooo0P000003oooo0000000002`00002
oooo00<0003oooooool0@?ooo`80000@oooo00<0003oooooool0;oooo`030000oooooooo03Soool2
00000oooo`030000oooooooo02h000000oooo`0000000012oooo00<0003oooooool04oooo`030000
oooooooo00ooool002Coool00`000?ooooooo`0moooo00@0003oooooooooool2000000?oool00000
0000;00000;oool00`000?ooooooo`10oooo0P00013oool00`000?ooooooo`0_oooo00<0003ooooo
ool0>?ooo`800003oooo00<0003oooooool0;P000003oooo0000000004;oool00`000?ooooooo`0C
oooo00<0003oooooool03oooo`009?ooo`030000oooooooo047oool300000oooobh0001Doooo00<0
003oooooool0;oooo`030000oooooooo03goool300000oooobh0001Hoooo00<0003oooooool03ooo
o`009?ooo`800012oooo0`0000?oool^0000Doooo`80000aoooo0P0003koool300000oooobh0001H
oooo00<0003oooooool03oooo`009?ooo`030000oooooooo04Coool2000000?oool000000000:`00
05Goool00`000?ooooooo`0_oooo00<0003oooooool0@?ooo`030000oooooooo02`0001Joooo00<0
003oooooool03oooo`009?ooo`030000oooooooo04?oool010000?ooooooo`0000;ooolX0000F?oo
o`030000oooooooo02ooool00`000?ooooooo`0noooo0P000004oooo00000000oooo:00005goool0
0`000?ooooooo`0?oooo000Toooo00<0003oooooool0@oooo`040000oooooooo00000_ooobP0001H
oooo00<0003oooooool0;oooo`030000oooooooo03koool2000000Coool00000003ooolX0000GOoo
o`030000oooooooo00ooool002Coool00`000?ooooooo`13oooo00<0003oooooool0:@0005[oool0
0`000?ooooooo`0_oooo00<0003oooooool0?_ooo`8000000oooo`000000000X0000G_ooo`030000
oooooooo00ooool002Coool00`000?ooooooo`11oooo0`0000?ooolX0000F_ooo`030000oooooooo
02ooool00`000?ooooooo`0moooo0`0000?ooolX0000G_ooo`030000oooooooo00ooool002Coool0
0`000?ooooooo`11oooo0`0000?ooolX0000F_ooo`030000oooooooo02ooool00`000?ooooooo`0m
oooo0`0000?ooolX0000G_ooo`030000oooooooo00ooool002Coool20000AoooobP0001Joooo0P00
037oool20000@_ooobP0001Poooo00<0003oooooool03oooo`009?ooo`030000oooooooo04CooolW
0000G_ooo`030000oooooooo02ooool00`000?ooooooo`10oooo9P0006?oool00`000?ooooooo`0?
oooo000Toooo00<0003oooooool0A?ooobL0001Noooo00<0003oooooool0;oooo`030000oooooooo
043ooolV0000Hoooo`030000oooooooo00ooool002Coool00`000?ooooooo`17oooo8P00063oool0
0`000?ooooooo`0_oooo00<0003oooooool0@oooob80001Toooo00<0003oooooool03oooo`009?oo
o`030000oooooooo04OooolT0000G_ooo`030000oooooooo02ooool00`000?ooooooo`13oooo8`00
06?oool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0Aoooob@0001Noooo00<0003ooooo
ool0;oooo`030000oooooooo04?ooolS0000Hoooo`030000oooooooo00ooool002Coool00`000?oo
ooooo`14oooo2`0000GooolH0000GOooo`030000oooooooo02ooool00`000?ooooooo`10oooo2`00
00CooolI0000HOooo`030000oooooooo00ooool002Coool00`000?ooooooo`14oooo2`0000KooolI
0000Foooo`030000oooooooo02ooool00`000?ooooooo`10oooo2`0000KooolH0000H?ooo`030000
oooooooo00ooool002Coool20000AOooo`/00006oooo6@0005[oool20000<Oooo`800011oooo2`00
00KooolH0000H?ooo`030000oooooooo00ooool002Coool00`000?ooooooo`13oooo4@0000?oool0
0`000?ooooooo`0D0000Foooo`030000oooooooo02ooool00`000?ooooooo`0noooo4@0000?oool2
000000?oool0000000004P00063oool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0@ooo
oa@00004oooo2P000003oooo0000000000L0001Joooo00<0003oooooool0;oooo`030000oooooooo
03kooolD00001Oooo`T000000oooo`00000000080000G_ooo`030000oooooooo00ooool002Coool0
0`000?ooooooo`13oooo500000Coool:000000?oool0000000001`0005[oool00`000?ooooooo`0_
oooo00<0003oooooool0?_oooa@00005oooo2@000003oooo0000000000P0001Noooo00<0003ooooo
ool03oooo`009?ooo`030000oooooooo03koool=000000Coool0000000000003oooo7@0005[oool0
0`000?ooooooo`0_oooo00<0003oooooool0>_ooo``000000oooo`000000000200000ooooad0001N
oooo00<0003oooooool03oooo`009?ooo`030000oooooooo043oool900000_ooo`@00002oooo4P00
00;oool=0000Eoooo`030000oooooooo02ooool00`000?ooooooo`0koooo2@0000;oool5000000?o
ool000000000400000;oool>0000Foooo`030000oooooooo00ooool001Woool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo043oool900000_ooo`@00002oooo4P0000;oool=
0000Eoooo`030000oooooooo02Goool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000
oooooooo03_oool900000_ooo`D000000oooo`000000000@00000_ooo`h0001Koooo00<0003ooooo
ool03oooo`006?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0@?oo
o`/00003oooo2P0000GooolE0000Eoooo`030000oooooooo02Coool00`000?ooo`000002oooo00<0
003oool000000oooo`030000oooooooo03_oool;00000oooo`/00004oooo5P0005_oool00`000?oo
ooooo`0?oooo000Hoooo00<0003oool000000_ooo`030000oooo000000Coool20000@Oooo`/00003
oooo2P0000GooolE0000E_ooo`80000Voooo00<0003oool000000_ooo`030000oooo000000?oool2
0000??ooo`/00003oooo2`0000CooolF0000F_ooo`80000Aoooo000Ioooo00L0003oooooooooool0
003oool000001?ooo`030000oooooooo03koool900000_ooo`<00002oooo00<0003oooooool01000
00?ooolJ0000Eoooo`030000oooooooo02Goool01`000?ooooooooooo`000?ooo`000003oooo00<0
003oooooool0>_ooo`T000001?ooo`000000000000;oool2000000?oool0000000000`0000?ooolJ
0000Foooo`030000oooooooo00ooool001Soool00`000?ooo`000002oooo00<0003oool000001?oo
o`030000oooooooo03goool:00000_ooo`<00003oooo0P0000?ooolA000000?oool0000000002P00
05Ooool00`000?ooooooo`0Toooo00<0003oool000000_ooo`030000oooo000000?oool00`000?oo
ooooo`0hoooo2`000004oooo0000000000001?ooo`040000oooooooooooo4@000003oooo00000000
00/0001Koooo00<0003oooooool03oooo`006Oooo`030000oooooooo00;oool00`000?ooooooo`03
oooo00<0003oooooool0?Oooo`X00002oooo0`0000?oool200000ooooa4000000oooo`000000000:
0000Eoooo`030000oooooooo02Goool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000
oooooooo03Soool;000000Coool0000000000004oooo00@0003ooooooooooolA000000?oool00000
00002`0005_oool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0?Oooo`h000000oooo`00
0000000=oooo0P0000?ooolD0000EOooo`030000oooooooo02ooool00`000?ooooooo`0hoooo3P00
0003oooo0000000000koool010000?oooooooooooa@0001Joooo00<0003oooooool03oooo`009?oo
o`030000oooooooo03goool00`000?ooooooo`0900001Oooo`030000oooooooo00Coool300000_oo
o`L00002oooo4@0005Goool00`000?ooooooo`0_oooo00<0003oooooool0>?ooo`8000000oooo`00
0000000700001Oooo`800006oooo0`000003oooo0000000000H000000oooo`000000000?0000F_oo
o`030000oooooooo00ooool002Coool00`000?ooooooo`0moooo00<0003oooooool02@0000Goool0
0`000?ooooooo`04oooo0`0000;oool700000_oooa40001Eoooo00<0003oooooool0;oooo`030000
oooooooo03Soool2000000?oool0000000001`0000Goool200001_ooo`<000000oooo`0000000006
000000?oool0000000003`0005[oool00`000?ooooooo`0?oooo000Toooo0P0003koool:00000_oo
o`80000:oooo2@0000?oool200000_ooo`l0001Doooo0P00037oool20000>Oooo`/000000oooo`00
0000000;oooo2@0000?oool00`000?ooooooo`0?0000F_ooo`030000oooooooo00ooool002Coool0
0`000?ooooooo`0koooo2`000003oooo0000000000D000001?ooo`0000000?oooa400002oooo3`00
05Goool00`000?ooooooo`0_oooo00<0003oooooool0=oooo`X00002oooo1P0000;oool00`000?oo
ooooo`0@00000_ooo`l0001Joooo00<0003oooooool03oooo`009?ooo`030000oooooooo03_oool;
000000?oool0000000001@000004oooo00000000oooo4@0000;oool?0000EOooo`030000oooooooo
02ooool00`000?ooooooo`0goooo2P0000;oool600000_ooo`030000oooooooo01000002oooo3`00
05[oool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0>oooo`/00005oooo0`0000?oool0
0`000?ooooooo`0?00000_ooo`l0001Eoooo00<0003oooooool0;oooo`030000oooooooo03Ooool:
00001Oooo`<00003oooo0P000003oooo0000000000d00002oooo3`0005[oool00`000?ooooooo`0?
oooo000Toooo00<0003oooooool0>oooo`P00009oooo0P0000?oool010000?ooooooooooo`800000
0oooo`0000000003000000?oool0000000001Oooo`@00002oooo2@0005Goool00`000?ooooooo`0_
oooo00<0003oooooool0=oooo`L00009oooo0P0000?oool200000oooo`030000oooooooo00@00002
oooo00<0003oooooool00oooo`D000000oooo`00000000070000F_ooo`030000oooooooo00ooool0
02Coool00`000?ooooooo`0koooo200000Woool200000oooo`040000oooooooooooo0P000003oooo
0000000000<000000oooo`0000000005oooo100000;oool90000EOooo`030000oooooooo02ooool0
0`000?ooooooo`0goooo1`0000Woool200000oooo`800003oooo00<0003oooooool0100000;oool0
0`000?ooooooo`03oooo1@000003oooo0000000000L0001Joooo00<0003oooooool03oooo`009?oo
o`030000oooooooo03goool700002oooo`800003oooo00<0003oooooool00oooo`@0000>oooo2000
05Goool00`000?ooooooo`0_oooo00<0003oooooool0>?ooo`P0000;oooo00@0003oooooooooool2
00001?ooo`D0000>oooo1`0005[oool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0?Ooo
o`L00005oooo200000?oool010000?ooooooo`0000;oool400000_ooo`T00003oooo1P0005Ooool0
0`000?ooooooo`0_oooo00<0003oooooool0>?ooo`P00004oooo200000?oool2000000Coool00000
003oool5000000?oool000000000200000?oool60000Foooo`030000oooooooo00ooool002Coool2
0000?_ooo`L00005oooo200000?oool010000?ooooooo`0000;oool400000_ooo`T00003oooo1P00
05Koool20000<Oooo`80000ioooo200000Coool800000oooo`8000001?ooo`0000000?ooo`D00000
0oooo`000000000800000oooo`H0001Koooo00<0003oooooool03oooo`009?ooo`030000oooooooo
03_oool600002?ooo`8000000oooo`000000000400002?ooo`<000000oooo`000000000900000ooo
o`H0001Goooo00<0003oooooool0;oooo`030000oooooooo03Ooool600001oooo`8000000oooo`00
0000000500001oooo`<00002oooo2`0000?oool60000Foooo`030000oooooooo00ooool002Coool0
0`000?ooooooo`0moooo5@0000Woool5000000?oool0000000003`0005Ooool00`000?ooooooo`0_
oooo00<0003oooooool0>?oooaH00009oooo100000;ooolA0000Foooo`030000oooooooo00ooool0
02Coool00`000?ooooooo`0moooo5@0000Woool5000000?oool0000000003`0005Ooool00`000?oo
ooooo`0_oooo00<0003oooooool0>?oooaH00009oooo100000;ooolA0000Foooo`030000oooooooo
00ooool002Coool00`000?ooooooo`0koooo20000003oooo0000000000l00006oooo5`0005Ooool0
0`000?ooooooo`0_oooo00<0003oooooool0=oooo`L00002oooo4@0000KooolG0000Foooo`030000
oooooooo00ooool002Coool00`000?ooooooo`0koooo300000;oool2000000?oool0000000002@00
00?ooolH0000Eoooo`030000oooooooo02ooool00`000?ooooooo`0goooo30000004oooo00000000
oooo2`0000?ooolI0000Foooo`030000oooooooo00ooool002Coool00`000?ooooooo`0koooo3000
00;oool2000000?oool0000000002@0000?ooolH0000Eoooo`030000oooooooo02ooool00`000?oo
ooooo`0goooo30000004oooo00000000oooo2`0000?ooolI0000Foooo`030000oooooooo00ooool0
02Coool00`000?ooooooo`0koooo0`0000Goool800001?ooo`P00003oooo1P000003oooo00000000
00<00002oooo2P0005Ooool00`000?ooooooo`0_oooo00<0003oooooool0=oooo`<00004oooo2000
00Goool700000oooo`H00002oooo100000;oool;0000Foooo`030000oooooooo00ooool002Coool2
0000??ooo`800006oooo00@0003oooooool00002oooo0`0000GooolQ0000E_ooo`80000aoooo0P00
03Soool00`000?ooooooo`04oooo0P000004oooo00000000oooo0`0000GooolR0000Foooo`030000
oooooooo00ooool002Coool00`000?ooooooo`0koooo0P0000Koool010000?ooooooo`0000;oool3
00001Oooob40001Goooo00<0003oooooool0;oooo`030000oooooooo03Ooool00`000?ooooooo`04
oooo0P000004oooo00000000oooo0`0000GooolR0000Foooo`030000oooooooo00ooool002Coool0
0`000?ooooooo`0koooo0P0000OooolA00001_oooa@00002oooo00<0003oooooool0EOooo`030000
oooooooo02ooool00`000?ooooooo`0goooo00<0003oooooool01_oooa400006oooo50000003oooo
0000000005_oool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0>oooo`800007oooo4@00
00KooolD00000_ooo`030000oooooooo05Goool00`000?ooooooo`0_oooo00<0003oooooool0=ooo
o`030000oooooooo00KooolA00001_oooa@000000oooo`000000001Koooo00<0003oooooool03ooo
o`009?ooo`030000oooooooo03goool010000?ooooooooooo`8000000oooo`0000000005oooo00<0
003oooooool01`0000;oool010000?ooooooooooo`X00006oooo00@0003oooooooooool30000Eooo
o`030000oooooooo02ooool00`000?ooooooo`0hoooo0P0000?oool010000?ooooooo`0000Goool0
0`000?ooooooo`08000000?oool0000000000oooo`T00006oooo0P0000?oool30000Foooo`030000
oooooooo00ooool001;oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool0?Oooo`<0000>oooo00<0003oooooool03Oooo`<00002oooo0P0000[oool20000F?oo
o`030000oooooooo01koool500000_ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oooooool0>?ooo`<0000>oooo0P0000ooool3000000?oool0000000002oooo`030000oooooooo
05_oool00`000?ooooooo`0?oooo000Doooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000Coool00`000?ooooooo`0moooo0`0000koool00`000?ooooooo`0=oooo0`0000;oool2
00002_ooo`80001Hoooo00<0003oooooool08?ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000003oooo00<0003oooooool0>?ooo`<0000>oooo0P0000ooool3000000?oool00000
00002oooo`030000oooooooo05_oool00`000?ooooooo`0?oooo000Doooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000000Coool20000A?ooo`030000oooooooo00coool200003?oo
o`030000oooooooo00800003oooo00@0003oooooooooool2000000?oool000000000Eoooo`80000R
oooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool20000?oooo`80000>
oooo00<0003oooooool02_ooo`8000000oooo`0000000003oooo0P0000?oool010000?ooooooo`00
05coool200004Oooo`005?ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004
oooo00<0003oooooool0?_ooo`<0000Toooo0`000004oooo00000000oooo0`0005[oool00`000?oo
ooooo`0Poooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool00`000?oo
ooooo`0joooo0`0002?oool300000_ooo`030000oooooooo00<0001Noooo00<0003oooooool03ooo
o`005?ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003ooooo
ool0?_ooo`<0000Toooo0`000004oooo00000000oooo0`0005[oool00`000?ooooooo`0Poooo00L0
003oooooooooool0003oool000000_ooo`030000oooo000000?oool00`000?ooooooo`0joooo0`00
02?oool300000_ooo`030000oooooooo00<0001Noooo00<0003oooooool03oooo`004oooo`800004
oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`1<oooo0P0000ooool3
00001_ooo`80001Qoooo00<0003oooooool07oooo`800004oooo00<0003oooooool00_ooo`030000
oooooooo00;oool00`000?ooooooo`17oooo0P0000ooool300001_ooo`80001Voooo00<0003ooooo
ool03oooo`009?ooo`030000oooooooo047oool200007_ooo`800002oooo00@0003oooooool00002
oooo00<0003oooooool0Foooo`030000oooooooo02ooool00`000?ooooooo`0moooo00<0003ooooo
ool07Oooo`040000oooooooo00000_ooo`8000000oooo`000000001Qoooo00<0003oooooool03ooo
o`009?ooo`030000oooooooo047oool200007_ooo`800002oooo00@0003oooooool00002oooo00<0
003oooooool0Foooo`030000oooooooo02ooool00`000?ooooooo`0moooo00<0003oooooool07Ooo
o`040000oooooooo00000_ooo`8000000oooo`000000001Qoooo00<0003oooooool03oooo`009?oo
o`030000oooooooo04?oool600007Oooo`D0001Noooo00<0003oooooool0;oooo`030000oooooooo
03koool600007Oooo`D0001Soooo00<0003oooooool03oooo`009?ooo`030000oooooooo04Coool3
00002oooo`800006oooo100000;oool00`000?ooooooo`02000000?oool000000000HOooo`030000
oooooooo02ooool00`000?ooooooo`10oooo0`0000_oool00`000?ooooooo`04oooo1@000004oooo
00000000oooo0P000003oooo0000000006Koool00`000?ooooooo`0?oooo000Toooo0P0004Goool3
00002oooo`800006oooo100000;oool00`000?ooooooo`02000000?oool000000000H?ooo`80000a
oooo0P00047oool300002oooo`030000oooooooo00Coool5000000Coool00000003oool2000000?o
ool000000000I_ooo`030000oooooooo00ooool002Coool00`000?ooooooo`19oooo0P000003oooo
0000000000Woool600001?ooo`@0001Toooo00<0003oooooool0;oooo`030000oooooooo04Coool2
000000?oool0000000002Oooo`H00005oooo0`0006Woool00`000?ooooooo`0?oooo000Toooo00<0
003oooooool0Boooo`030000oooooooo00Coool200001oooo`80001/oooo00<0003oooooool0;ooo
o`030000oooooooo04Koool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
06ooool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0Boooo`030000oooooooo00Coool2
00001oooo`80001/oooo00<0003oooooool0;oooo`030000oooooooo04Koool00`000?ooooooo`05
oooo00<0003oooooool01_ooo`030000oooooooo06ooool00`000?ooooooo`0?oooo000Toooo00<0
003oooooool0bOooo`030000oooooooo02ooool00`000?ooooooo`39oooo00<0003oooooool03ooo
o`009?ooo`030000oooooooo0<Woool00`000?ooooooo`0_oooo00<0003oooooool0bOooo`030000
oooooooo00ooool002Coool00`000?ooooooo`39oooo00<0003oooooool0;oooo`030000oooooooo
0<Woool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0bOooo`030000oooooooo02ooool0
0`000?ooooooo`39oooo00<0003oooooool03oooo`009?ooo`800039oooo0P00037oool20000b_oo
o`030000oooooooo00ooool002Coool00`000?ooooooo`39oooo00<0003oooooool0;oooo`030000
oooooooo0<Woool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0bOooo`030000oooooooo
02ooool00`000?ooooooo`39oooo00<0003oooooool03oooo`009?ooo`030000oooooooo0<Woool0
0`000?ooooooo`0_oooo00<0003oooooool0bOooo`030000oooooooo00ooool002Coool00`000?oo
ooooo`39oooo00<0003oooooool0;oooo`030000oooooooo0<Woool00`000?ooooooo`0?oooo000T
oooo00<0003oooooool0bOooo`030000oooooooo02ooool00`000?ooooooo`39oooo00<0003ooooo
ool03oooo`009?ooo`030000oooooooo0<Woool00`000?ooooooo`0_oooo00<0003oooooool0bOoo
o`030000oooooooo00ooool002Coool20000bOooo`80000aoooo0P000<[oool00`000?ooooooo`0?
oooo000Toooo00<0003oooooool0bOooo`030000oooooooo02ooool00`000?ooooooo`39oooo00<0
003oooooool03oooo`009?ooo`030000oooooooo0<Woool00`000?ooooooo`0_oooo00<0003ooooo
ool0bOooo`030000oooooooo00ooool002Coool00`000?ooooooo`39oooo00<0003oooooool0;ooo
o`030000oooooooo0<Woool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0bOooo`030000
oooooooo02ooool00`000?ooooooo`39oooo00<0003oooooool03oooo`009?ooo`030000oooooooo
0<Woool00`000?ooooooo`0_oooo00<0003oooooool0bOooo`030000oooooooo00ooool001;oool5
000000Coool0000000000003oooo00<0003oooooool00oooo`030000oooooooo00Woool00`000?oo
ooooo`2moooo00<0003oooooool07_ooo`D000001?ooo`000000000000?oool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`800033oooo00<0003oooooool03oooo`005?ooo`050000oooooooo
oooo000000Coool00`000?ooo`000004oooo00<0003oooooool02_ooo`80002moooo00<0003ooooo
ool08?ooo`050000oooooooooooo000000Coool00`000?ooo`000003oooo00<0003oooooool01_oo
o`030000oooooooo0<3oool00`000?ooooooo`0?oooo000Doooo00<0003oooooool00_ooo`070000
oooooooooooo0000oooo000000Coool200002oooo`80002loooo0P0002;oool00`000?ooooooo`02
oooo00L0003oooooooooool0003oool000000oooo`800007oooo00<0003oooooool0_oooo`80000A
oooo000Doooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool00`000?oo
ooooo`39oooo00<0003oooooool08?ooo`030000oooooooo00;oool01`000?ooooooooooo`000?oo
o`000003oooo00<0003oooooool0bOooo`030000oooooooo00ooool001Coool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo00Ooool20000`?ooo`030000
oooooooo023oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`030000
oooooooo00?oool00`000?ooooooo`33oooo00<0003oooooool03oooo`004oooo`800004oooo00<0
003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`07oooo0P000<3oool00`000?oo
ooooo`0Ooooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo
00?oool00`000?ooooooo`33oooo00<0003oooooool03oooo`009?ooo`040000oooooooooooo0`00
0;Soool00`000?ooooooo`0:oooo00<0003oooooool0;oooo`030000oooooooo0;Ooool200004?oo
o`030000oooooooo00ooool002Coool00`000?ooooooo`06oooo00<0003oooooool01_ooo`030000
oooooooo00Soool00`000?ooooooo`2/oooo00<0003oooooool0;oooo`040000oooooooooooo0P00
00Ooool200002Oooo`030000oooooooo0;7oool00`000?ooooooo`0?oooo000Toooo00<0003ooooo
ool01_ooo`030000oooooooo00Koool00`000?ooooooo`08oooo00<0003oooooool0[?ooo`030000
oooooooo02ooool010000?ooooooooooo`800007oooo0P0000Woool00`000?ooooooo`2aoooo00<0
003oooooool03oooo`009?ooo`030000oooooooo00Coool300003_ooo`030000oooooooo00800009
oooo00@0003oooooool00002oooo00<0003oooooool0WOooo`030000oooooooo02ooool010000?oo
ooooooooo`80000=oooo0P000003oooo0000000000Woool2000000Coool00000003oool20000Xooo
o`030000oooooooo00ooool002Coool200002?ooo`8000000oooo`000000000300001?ooo`800000
0oooo`000000000<oooo0P000:;oool20000<Oooo`800004oooo00<0003oooooool0100000Goool0
10000?ooooooo`0000goool00`000?ooooooo`2Voooo00<0003oooooool03oooo`009?ooo`030000
oooooooo00Ooool2000000?oool0000000000`0000Coool2000000?oool0000000003?ooo`80002S
oooo00<0003oooooool0;oooo`030000oooooooo00?oool00`000?ooooooo`0400001Oooo`040000
oooooooo00003Oooo`030000oooooooo0:Koool00`000?ooooooo`0?oooo000Toooo00@0003ooooo
ooooool<00000oooo`800006oooo0P0001goool00`000?ooooooo`0Aoooo0`0000[oool200005ooo
o`030000oooooooo00Soool00`000?ooooooo`03oooo00<0003oooooool03Oooo`80000Doooo00<0
003oooooool07_ooo`030000oooooooo02ooool010000?ooooooooooo`P00003oooo00<0003ooooo
ool01?ooo`80000Moooo0P0001;oool300002oooo`030000oooooooo01Goool200002Oooo`030000
oooooooo00?oool200003oooo`030000oooooooo01;oool200009?ooo`030000oooooooo00ooool0
02Coool010000?ooooooooooo`D000001?ooo`0000000?ooo`D00004oooo0P0000coool200001_oo
o`030000oooooooo01Ooool00`000?ooooooo`0_oooo0P0000ooool20000=Oooo`80000:oooo00<0
003oooooool0;oooo`030000oooooooo00?oool00`000?ooooooo`0400001Oooo`030000oooooooo
00_oool00`000?ooooooo`04oooo0P0001Soool20000<Oooo`030000oooooooo00koool00`000?oo
ooooo`0doooo00<0003oooooool03Oooo`030000oooooooo00ooool002Coool010000?oooooooooo
o`D000001?ooo`0000000?ooo`D00004oooo0P0000coool200001_ooo`030000oooooooo01Ooool0
0`000?ooooooo`0_oooo0P0000ooool20000=Oooo`80000:oooo00<0003oooooool0;oooo`030000
oooooooo00?oool00`000?ooooooo`0400001Oooo`030000oooooooo00_oool00`000?ooooooo`04
oooo0P0001Soool20000<Oooo`030000oooooooo00koool00`000?ooooooo`0doooo00<0003ooooo
ool03Oooo`030000oooooooo00ooool002Coool00`000?ooooooo`39oooo00<0003oooooool0;ooo
o`030000oooooooo0<Woool00`000?ooooooo`0?oooo000Toooo00<0003oooooool0bOooo`030000
oooooooo02ooool00`000?ooooooo`39oooo00<0003oooooool03oooo`009?ooo`800002oooo00<0
003oooooool07?ooo`030000oooooooo01_oool00`000?ooooooo`0Loooo00<0003oooooool07?oo
o`030000oooooooo01_oool00`000?ooooooo`0Loooo00<0003oooooool03?ooo`80000aoooo0P00
00;oool00`000?ooooooo`0Loooo00<0003oooooool06oooo`030000oooooooo01coool00`000?oo
ooooo`0Loooo00<0003oooooool06oooo`030000oooooooo01coool00`000?ooooooo`0=oooo00<0
003oooooool03oooo`009?ooold0000aooooc@00017oool00?oooooooooo0_ooo`00ooooooooool2
oooo003oooooooooo`;oool00?oooooooooo0_ooo`00ooooooooool2oooo001eoooo0`000?oooolD
oooo0`0007;oool007Koool00`000?ooooooo`3ooooo5?ooo`030000oooooooo077oool006Ooool3
00000_ooo`D000001Oooo`000?ooo`000?ooo`0300000_ooo`<00003oooo0P0000goool300000_oo
o`<000001?ooo`000?ooooooo`800003oooo0P0000?oool20000YOooo`<000001oooo`0000000000
0?ooo`000?ooo`0300000_ooo`<00003oooo0P0000?oool200000oooo`<0000>oooo0`0000;oool3
000000Ooool0003oool0003oool0003oool00`0000;oool300000oooo`80000=oooo0`0000;oool3
000000Coool0003oooooool200000oooo`800003oooo0P0004;oool006Ooool00`000?ooo`000002
oooo0`000008oooo0000oooo0000oooo0000oooo00000_ooo`040000oooooooo00000oooo`030000
oooooooo00koool00`000?ooooooo`02oooo00H0003oooooool0003oool00002oooo00<0003oool0
00000_ooo`030000oooo000000;oool00`000?ooooooo`2Roooo00<0003oool000000_ooo`040000
oooooooo00000_ooo`030000oooooooo00;oool01@000?ooooooooooo`000002oooo00<0003oool0
00001?ooo`040000oooooooo00003_ooo`030000oooo000000?oool02P000?ooooooo`000?ooo`00
0?ooo`000?ooo`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`0>oooo00<0003ooooo
ool00_ooo`060000oooooooo0000oooo00000_ooo`030000oooo000000;oool00`000?ooo`000002
oooo00<0003oooooool0?oooo`00JOooo`030000oooooooo00;oool02@000?ooo`000?ooo`000?oo
o`000?ooo`000002oooo00@0003oooooool00003oooo0`0000koool300000_ooo`060000oooooooo
0000oooo00000_ooo`030000oooo000000Coool010000?ooooooo`000:Koool010000?ooooooo`00
00;oool010000?ooooooo`0000Coool01@000?ooooooooooo`000004oooo0`0000;oool010000?oo
ooooo`00013oool01@000?ooooooooooo`000002oooo00L0003oool0003oool0003oool000000_oo
o`040000oooooooo00000oooo`<0000>oooo0`0000;oool01P000?ooooooo`000?ooo`0000;oool0
0`000?ooo`000004oooo00@0003oooooool00011oooo001Xoooo00<0003oooooool00_ooo`800000
1_ooo`0000000?ooo`000?ooo`@00003oooo00@0003oooooooooool300003_ooo`050000oooooooo
0000oooo00<00003oooo0P000003oooo0000000000800003oooo0P000:Koool010000?oooooooooo
o`<00002oooo0P0000?oool3000000?oool0000000000P0000;oool300000oooo`<0000?oooo00@0
003oooooooooool200000_ooo`8000000oooo`000?ooo`0400000oooo`040000oooooooooooo0`00
00koool01@000?ooooooo`000?ooo`0300000oooo`8000000oooo`000000000200000oooo`800012
oooo001Woooo00<0003oool000004_ooo`030000oooooooo01;oool01P000?ooooooo`000?ooo`00
00Woool00`000?ooooooo`2Zoooo00<0003oool000000_ooo`030000oooooooo00Soool01@000?oo
ooooooooo`00000<oooo00<0003oooooool03?ooo`030000oooo000001;oool00`000?ooooooo`0B
oooo00H0003oooooool0003oool00009oooo00<0003oooooool0Aoooo`00Ioooo`<0000Aoooo0P00
01?oool4000000?oool000000000]_ooo`<000000oooo`0000000005oooo00<0003oooooool00ooo
o`030000oooooooo00coool200003_ooo`<00003oooo00<0003oooooool02oooo`80000Coooo1000
0003oooo0000000005?oool00?oooooooooo0_ooo`00ooooooooool2oooo003oooooooooo`;oool0
0?oooooooooo0_ooo`00ooooooooool2oooo003oooooooooo`;oool00?oooooooooo0_ooo`00oooo
ooooool2oooo0000\
\>"],
  ImageRangeCache->{{{0, 511}, {242.688, 0}} -> {-0.0528037, -0.0238146, 
  0.00412057, 0.00412057}, {{12.8125, 243.938}, {236.875, 
  5.75}} -> {-26.3718, -13.8837, 0.652088, 0.652088}, {{267, 498.125}, {
  236.875, 5.75}} -> {-192.124, -13.8837, 0.652088, 0.652088}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Correlation\)], "Input"],

Cell["\<\
corRelation=
\tCompile[{{vectorA,_Real,1},{vectorB,_Real,1}},
\t\tModule[{meanA=0.,meanB=0.,normA=0.,normB=0.,
\t\t\t\tvectorAprime={0.},vectorBprime={0.}},
\t\t\tmeanA=Apply[Plus,vectorA]/Length[vectorA];
\t\t\tmeanB=Apply[Plus,vectorB]/Length[vectorB];
\t\t\tvectorAprime=vectorA-meanA;
\t\t\tnormA=Sqrt[vectorAprime.vectorAprime];
\t\t\tvectorBprime=vectorB-meanB;
\t\t\tnormB=Sqrt[vectorBprime.vectorBprime];
\t\t\tvectorAprime.vectorBprime/(normA normB)]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["corRelation[Flatten[nsample],Flatten[ssample]]", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(0.422565335217431936`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Discrete\ Fourier\ transform\)], "Input"],

Cell["\<\
SampleFourier=Chop[Abs[Fourier[nsample]]];
ShiftedSampleFourier=Chop[Abs[Fourier[ssample]]];\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
SampleSpect=ListDensityPlot[SampleFourier,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Sample Spectrum\",
\tDisplayFunction->Identity];
ShiftedSampleSpect=ListDensityPlot[ShiftedSampleFourier,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Shifted Sample Spectrum\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SampleSpect,ShiftedSampleSpect}]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -47.125 0 ]
[.5 1.0125 47.125 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -108.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Spectrum) show
153.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFAF4EFF46A59FFF1E4F83FFA242FF939F5C
D17350A268DA944344736D2D9CAC6CA21B4D7AAF4E486441
54E54F63FF29AB97BA6F285D63413D5DBC5D3D41635D286F
BA97AB29FF634FE5544164484EAF7A4D1BA26CAC9C2D6D73
444394DA68A25073D15C9F93FF42A2FF834F1EFF9FA546FF
4EAFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFBDB8B487AFFB8A6C74FFEEA52C49D9FA
9BB70767D9D51DA75B3C654A835C18671C45636E82972588
6EC4674BAD62433770AA51418D6C8A02945C394563303429
814E4C3D81546F128E32067B429740321243884F64A14A95
60534282D48BB2955FAC298713FC59DC38B94DFF9654BE5C
D7FFFFFFE9FFFFFF
FFFFFFFFCEFFFFFF7E64FFFFD3DBD1BE52AA47FF737244BF
749A6597ADB344A06850585C5D563932955F3959107C3F76
6F56680E3E5850417D6735302E146C36512A410C193C3363
2541423429207F8A36744E4B706A524B6E91371822576B11
1C538212C5CA4280723E42C99BD2AE135D817A41E2AD3915
3FE589FFFFFFBEFF
FF77FFDEFFFFF0E6FFFF52FEB2ED67B2FC5887E1F75C8ECC
4DFFBA41B9609CDD8B5A8082CC29586D7662B9574A547148
6E4F3B56933558512D34B664354332415544084032384A43
8D612E0F6268557460302562AB7F2D4650A6244753099F14
434494637774351EE95E34BDCC8F7A4314207FF1E7AEABFF
64D9CAFFFFCEFAF8
FFFFFFFFFFD2D6F6FF7DC19AFF83024AD21F5D4289499561
99FE128587FF8CAE50DD5D3633523E7A7850BD0C64812D4A
7A89347397862E1F3D058142671E655179485B5F284C3963
7D7241494F66252065231646887E56819A9A9562704A8365
588E5BC96249875FC48C34BCFB9EE9C9A12E3DCE4C394BFF
D9FFD936FF7BCCFF
FFCEFFFFD9B6FFFFFFFF3F24FF3A3D82FA4D828A812C1541
77A88765ABFC7CDD7C838C3268356F266B76A33144644565
8D7D534A268261217F2DA23C1F45891FA4237E9D3C54293B
64982F7240760E2934504A4322A3F23E4EBE696C5D521D3F
283B93A98E994E5AE26054EA997B6CAF5DA22E6832EEFA47
7F9AFFFFBBFF93FF
FFFFFFF14E05A5D8523B66A56E418887A0BC7D35B3A2597D
59596D5D8EC7AC9B8B700F24687686652E43992764502C65
6326353D478B4D3A693F61427DBC48181C1D395F42312A78
90CE3E2D74430F7B331B537E4A93ED54334C4F3F5D4FE72D
3350511680B26E9ED940AF9A184CA6553D9C5583C2663ABF
FA4A73E1FF55D27A
BCFFFFFF4875BC76CA3CB27BFFA8FFB047B34192843A12B1
5854315441DB6845B5660E7027747B47234867532C249F0E
2A433E69735B88401E3E46912A782296294B46275E5A2771
1A16708C53432287614CA19227B8B4642155C12DA0BEC557
8D3448E83C60705A5D4BB768966D790D7D9D3DFD6CFFB89C
8099482363D3FFFF
FFA1786ADABD7D9A8C72BA53D7FFA52EAF822F838039144F
6861106830622F638231265FA68A944FE056BE3F232B6C2F
407D4C3A50471D822DA951553D596D4237353377208F7380
684D249F436A622A2666761D5D6590222B38B578647F3551
244E75CA7B44696C9340A37280C87044A4BBFF2FBAE59F9C
61820AA6F453DBA3
F0FFFF36AF55B12D50A487D12F44AEAD2761444353271C8B
736234644D4341462D193018294A6455D567A93A49142956
934D605D2D3565323AA446725C1E2906265F3D241F227789
504A821D67364D35633D133A9E82774D5C395E8352249F85
48B646D933687074B597265050BF31AD6FABA0952364D476
4BD3E0BFCD8DFF98
FF6FEF5C3CFF536E3F726BDE43585E4625601F3169D37D49
B5559D545D175A7D644F3873A55C499A6B386B3467521883
9F1D3E5B60239C23337D4E8F322429736D6E4B5B4F64694C
736B2E2934384C4C41678B321F575923382E505C793B7DA3
295A7739373D563576BA35836FFFB5458560353181C1E34D
90FF7D692A368466
FFA1FE4E99FFF6A538963874217D8E13546A2F991F51794A
BC729B1B6D46758AB7161E78992C458B372B661D275A87D2
8A300F33692C3D2D2231191B7831250E6C79328363553E5B
202A6C3722831461174F6926503E334F2A14574528263B86
269551205E0983E5695220924FCA555350D23B6E22A83971
9879FFA85E8340FF
FF7B669141B1E1A9AF7D49326A8842796D3B2777693C6F17
BCC136A296592F589469500E456C41561C4F7862397A8799
A03433712F3D36473E134355317D384CA6213045845A3CC5
374A554D4D6612965C05375948664C1F53214A7E3B574E25
4F0C5FABCD5372B3135856972D7A5EFD58749F7F8A6D7868
AE64FFD063FFFF78
FFFFBD4C1DE4FF6DB0FF204E699461A2602F699312D96760
97F64972689D8279664A53499C5C501C264B50315B744731
6E1C2793925B2A4A304E3185414D6359404A5B3A39571983
2B27512936290F503B553C826D086B34A24505359527651F
3D847A1F6830149C6E577BB8403872751561599F6D4F4F61
FF07D820AD5BFF1B
FFA8B519D3793F51FF6E93582B0E196F3A66AE7F7B883A45
78C0E666395E68308543107C14577040324A07288F3A3177
120C48925E594D3D406C3B403635572A591436434D34412E
15174CA68D2F725C862D0F4627459A2681222B621F692261
3B7B4D3E27627C5A6E714724346A3456A30828AA26EC7437
8CC25D71C686FFC6
F5D1A3FF11469373FFA7A68077201C45320BA578E74C91B9
3A8163C8391F418F7A38475D57653B34182D44412B5D8A2C
3C296F6D52805D394C3A495E65182553555808493A523C5A
72310AA9791518202B298F30504B4B534339671B2F152D69
78105F2A2A4F6C4E394117152B933DD125A7578F8394AC59
453360AAD1C0B973
5CCB4FA791B2138A97A73263E4CD21667298269170532861
180F5D566D3858C14B51113C3E59A8223884035D18736C77
812A334FA54B742529292E5C3A14BA1D2C865D2E1F1E1661
46554B509558422A2068596828194529204A34354848A654
694F244D60377B89620E343A0883266C607C691258073448
80BC5B7D664C9370
68927089630A6AA1935E812F50637DA75145846115431C2F
3F502A430C37374A5B0D353D37315B85D11F7E258E4B432D
288099571B283B1652471A385C933D870F3D344D612C5B6B
7954704B584776167A43601A0E5685447C77295D56805844
BB532070B9E9244B993BAB8759374F3F28302A2A1B71848C
641D7F394D6B6C3A
A4BB8590092B23543C5F722C4E3979955845244C67B22D89
541E31682A3386BC0F150C284D17602268243B280A8C572E
335763391E6970214057342821834B3A353B627562364F27
B76E6E0F34543640460D5D25713BA05096635D1362777D6E
6F2454AD3CA5650A858546205E271451301B45687F41B48C
77754B1F2D5B5E9F
BFB41D587962492E1737611250B4584F37541B6F52572C67
3D383448217F154C6D49272843851F3E435833421846C443
5F4426992F3C6F319320340E5599249A1F55733B90666035
5486407A31616B667B3D44053E482E4B2C47565D4E943A68
97312AB032714351117A1271837652623331318D697192C8
4874956C33DBA770
EEFF56724C916980900513162B73E63B7A6678AD3574534E
8E56255B4571398A93254C6A4AF9431218264C243C544128
3A6D3971192F44287164400F24716A77363138664E143C0F
8622595C331E2A2F57256D2C165E0133692C61717D516366
615506672F475038BE567F7E1C653D13441E313F6C6F5FE3
329B768682843D8C
7D47B57F4B4B5B220944821E463AD325BB63407240712676
687193478E51A5533773288D377A32203446426731460C1F
5B670E41554E16534C724864425E82857B3519A75E6E4009
3157552F2A5B2D2A38326531463B42400A59375E543D9E8C
658F672B19206D7A6A12493D7768433F294F1B3B849A866E
673A3365684D4070
DD4F36468742533145076F472F5A565BE010144118BF4A66
2A39AA53B72E9E2E4813608058493E38401B1B632A3C270B
875A6846474E52681F5C40892C413F2A2F23364C5A5F9920
43763435755B63254B617B2F555639AA4D4A555232A27765
5864272B0276362C4C4D7CC60F640B3B624D472E91868E63
1A576A428F724685
4BB0C3AD3D4D9841671363463A570C54A33E436214928C92
0931398D681715BA49234B5A14BC264B44191145405B7B47
6345437940572C273278171E4071728C2E5A63504A365246
6A4F443E3A35312B73163E40AC26922FC5229C7A4F20350A
555E377C8B2971411F4A68431A31423464334B342E076B82
696A47507A664C66
E47B3E3C54B83581C778645244B77983C391164A0E199755
48713C2023301022196426733A64483630227E075F53964A
256D3E446A504206215F69913F113A2E1B3C2F974586195A
5643544799B54988773515296813093E20466A673DA33547
0416863A3A53119F505F3D2647388F256051AE5255BA3FDE
6D5A654BB15B5EB4
F6C98E32516B2A396C111F692184708B7698962B74296424
3C762A4870412E3F032B3D362C1B4F600F5F5B4959085A71
4531360C01534B6E0E54285A4A0DCB28305D521324245E1F
1B56C75122808D5835553F323F3E3886136844212E7D292A
72526274605A3A7DA477905B3F155B414F9774276B3C8D7F
C953697CDB5796BD
FFB573DB2215372ACD500995275538175D2493618C012865
4433967961263E7A28113B0A2E6083282716064F19653882
46373C6C661F72321228231F259D7843397E421C3C6D4444
92284662878A71686A5C643F452B632D4B4331A767383C43
7E35662C36581F09227A6E54196A4F0F722E62638C7D0982
1C0A5D52745C7DBE
72E50D4B2E582950AC7C8242347D0F21186D502357386133
5166336EBD70104128223884621B75314D502F21386E4F26
500B2B3E26344738244751AC7E7F7A7F64521F7A30482223
6A3148370F2F3E8E38349F3F572F304C36271F946D913B4E
6C586D564C591A711A3B596753344834128F9E479411704A
6339124987C516FF
3BC22A904A0A72215D398F6B646648604B56851D401B706C
5D8542615D31647792785ABB4D50692679463C5242363723
647E696B232973432B84473C3A347A2037672F4B37532277
3F5E0E6933664F6C29815E571C14302D5D6C3F5B5F666934
681D863F518E3C4F30215C2C165949172C22798C3239906C
2561217F554B56FF
738765497D686B184E3449103312544A7E297E5F204E7F53
717A792B7D32440B72506A0C808F371A3C6330287777191F
72B367646C3A3834785133536A4259554A5D20151C3C424A
40571831124F5A392D472C482B47435E35134C3D34375852
1D563E213D1144231F111F1A292B5C3843358E79BC332798
431A8C40771559FF
2E21B42819571A3E5B484A6F5A5071933A40787867645D67
75473A6B3D1D61AA53793F7D20296A2B5A5943734A6F2030
4F477820270A253B459E0D581A2E5F3B373E40260B065B1A
2A311846213055654B3A29521B375E40290A1A2E62747D35
AD31224B642441341D17614F1FA99B5B1B402C0FA06D25B1
3E1A0B677774A9B4
379B53E9336A2473386F79643F92AD7C6DA47E254C5B7A5D
575E8F201142407575647493323A4EA44A8E3F2F5E91655D
2B1F6E3B374D4F69188F303D217821224E563B254F2C757E
411B306C443121464184726EA385702D662E292A2B31324B
7D5C2A3B51391C53111C559284C4642F133C2B074B3B3023
369456972C77B1C4
347D4C71617E6A6637833B3C783C3382234B80225B76AB39
590831191058425C5C0E1D25515278553B186F6C5B4D5976
4C505432AA514B2D692029465A82498358325021423A5616
443F0A6B295179223D65A0305D202B8A2A47442C68291735
250B42253D2463676B231B3A69469E3E810031513F1D4B2F
6F214B654B4B1B73
5D75767754545B2634115D615D5236676B1963246B6A2931
4B3F424F534C35422930235B795780478A1F1C1036263137
4328465234B34530562D2C0B25587563264E8E4583674335
AC5C2044814855224E2B61712928367C3D1B4D4445781025
212D4F40AB5F3887B06A328336775FA351290F6C27653B4B
5E84161072609051
651C4472643A2A5061494D4B3D22408F325A342018073431
49803C36498B6C6C2950648D3F0A45595D85141A5EA05F75
3A20505F3E3566BF0F373A52430336301D5A782C38622370
7F6A358A615817243E63484E996F6A6831837A7239652C4C
4049331E70195427594C7B8E4B683267404543103C3E76B9
203C065C75D64EF2
465E4418320E45246792A192AA294E9E7550551E318C0B47
143B3D627B9D5731503E4C30303BA249746BBC6946081155
093B1866571A367B601E174A633F5D1F6F4A63430D141349
325709712A273B1E17134E34850F566C22254C5F232F4A3A
1A2D423B35521C5943444E452F5F600E2B6B554C25726C4E
3D3C3A912948BD53
4A4A62A6A25F9111600660425487516B7B758A4916BF4835
3A4C52084D575F1A918E5D632C7D604EC662713E16213018
6760453C766262351E3623148809531D44591B525115510B
4D273F7F1A29690DB16921BF185C2A321B5E0E9A2F1A450C
2A0C611F33492B52374D223F3F521B3A8C23492D53762042
7136942A5C304585
BF6D9ACD7570315C5367537824900E2565543E2532626414
67137C563D4F184E2068145373884527234B5C5A52811659
4B633F2B7B4C664B5359392C7C124B49977222610B554542
1612092C7A973D78477A90D73B5A86890EA12DAE26272740
3A072617382F295387676624882A5465971ED53E3FA0F33C
285F630B75862B9A
8B77734C3A57619417221B941341481B586E566A475E2815
6D594213550D084A2B2F4239738B312A584B468146477E03
641E301D256878039B2F1848602A644F4554591F435F5041
5E3823601D70206752192A99104055362C9D2B5C0E103E15
280C882B41625F312714479C794250A71C41754839309F6A
5E166425334CB353
80093F186A21A8185D37180E43533239495B312A50731917
37882D17B2C85B3B3124324B824C176251253B8827953744
923D2F3B336C284E46082F31111D2B6910783C435D1E4F15
B34E0864242F1134442C754B43132247872B1E2D122E274F
572363383D40403E2E6A271F495B215D6D5728171C3564C7
506D37353B5E639A
CD49295B17637E55121C61602A451F408F3C11056355312D
1F3F6B5B5069484C2F4B12274A455F13075262551E736F49
B1465D697A213A52202A28513B1D6237302B5F9878622633
70254E1E43360F3A3E517B5F573F444A67545D272A8A4831
712F3D161A42612E79B25B7F6B1F2E67744D1C66221B9D49
5247454A3A659893
BD21749875333A0C5C5275711D7D0A698E05762D27835350
6827252621181E424333232C11265A4829396B3F44597A2D
22232D7D513C3D48576221065814342A3A3E4D2D326B7238
2D4152723F3D3D5B754F4E50646935337E40554D3BB13249
193B4B2681547F832A726466375D9C6B450E1A0F17545963
497124528F405033
C724471E59767936601DA122245346229E5F422F4962093B
DC63591B6C7F0549530E2A6423126B13450B57836120613D
49304C372F1C543A875D0E1C825D1C2538660F5A18635225
222506196C6E8069433F4A335A15105147653533312D252E
29183F50591382714829485D237C2A84858099351589824C
98602E5745551081
904C38A750906B695676906815962A32213D375D59101D2F
76173A56415A3B2A4340523D48305A4F1926115A633F6846
4650BD422A8055322C17383424334145371D1D892E2D2829
291D4611D263566D1833603927142A288559CB325D2A104B
34714C72436052383A402F1C3E2B473F521827490F873C6B
3B8F373A6F5393A0
796B4BAE8938885885EC875E55718392244C1E406C441B40
2566321241830B13072963433F5732458F2E5A328B138D71
597B193E5A247C254618659F90615951B030630F375B6556
18483B437850344A035275513A2669178A4893642926560F
404241407C16330E49302D298F088083522D6434375453B6
92243D3E566D2998
548254841F981A721B603A10425243502A0F293546143330
363A75275D285034500B6C0C1711742F753F3B34181D654F
916F152E444131274CAC308C17B0406242736A542F3B3836
15761F03905C6A1925463A37192F265B1B5C3976462F6E3F
12331F383058812F362335735C0DA8522A283D2769717762
86C143923F80706A
2789475241512F2B38481E3177774B1B36324372584F6A81
0E1A9250531E296534184E0B352C64180E3C1D4A545B3443
604C1423524541852E5551B9252A34431A734242531F686E
335974208F3F703F231A11124552157297494C28273A3727
265C4C3F1B5F5168567E784E1529763B395E414134215A7B
1CA27A439D28B02C
58869244183D4D567F682452BE3F8A64382929514E333B79
563575432B117471063D8C4D563D9F1F4D4C733D54545656
3840702A4B258E602D0B65486580786A7E5D292A826B3D17
2F5A1652324B70531F353580305A5A4D622B272F54491F3A
3531380F1037594928794D335D3625381565231A43574779
3843102D792C7E45
9F6F3A5F57406287542D3C30474C2A564AAA276433462563
2C6A513B464E6E056010AE16982C371F3E8923469364286D
66314E2445284B38123124673F770F801F6F486951295834
113A2F58180A66092C5C1E401F8073124D85481D5E21281F
0A353A241543894A652C7738902E3E5A3A5047347D1B7A5E
336C586E30524239
C395173B134B1B778B3E935A645D5477193DA586330F236C
1D46332D4533A32E382133182F0A2765196972726C036471
1D7B57297C3B434413024A38850F0E68C646AC3E0B67441E
467E55195170440C5238213C272BAF588B98155379411B52
39491D342F4B67593CA4425A4E3E1E6A5970295020189093
37107434884E3361
82AD601D053632305E7605A7542048764F5E5E460E2E8C63
3135104E2A675A2F8C151826354F1E7C3B837A882B348012
0861272959605E1E7B3148936E485877624D284E3A5A4108
2F6B4C09235F8D2929382C343D734D10403D568E833B3719
142A6E186F1967272C83520A3C195B4427724C2568231D4B
0715591A6C781BAC
C889534C295D59254C687C4C226F114C5C3F4F15354E8E43
A0333B815B394A7B2B52503B80197C618E1F5BA68B663933
0E3F3A2317661F528D075350459A76762B232527364E1D9A
2F360F41103C585D182A241943604B39532A8F5777250F21
646A421D595158532178206780531250A2274625404D421A
3B30608942404574
B38424574D336A0D2B5184164251084A3E55204F1F134748
895E2389705E4A25244A3C4D36477F1E3D6B38443C1D1E14
1A1660535340288C2A2A874C5E144A721319550E3D754553
37591B6E30243E342E23661D473815548A43651A64392F71
AE63171317635B28589A5E465932351D205A270D64318783
4E34745E4E3F6F77
5E7C3E610845366C42195B425E0D64602A7D9A486652633A
55161F484A1A350D4F51354E4E5E27133B4B1724370C3020
3F7B161E213F2C806D1E344E4F8B3C4A175178181876371A
923949614448561C6528574D404704435C190D7927405B10
69463A2116797145164216885D542C461D403D5337322A68
19345F275C8CBBD3
798A098913705319372DA0264D9531346E642B2B6C713A36
6C1F2F1D2B302E22385931246608714C4C1D056C334E165F
4FC6446032594E466C405A2F73936A2E311B192D1C223B41
5E6C5F0E47752E27737119293F976E492D37199016284936
83A90C4B104A443B1A5716374C4B4025686B3C8B61715751
22382D703B596868
8F6B542B447D6B45643E73725E4D3D263F601F894C813D44
435F544656322F565E4834654E562F4E56610C9147584621
50302A3113171C245C281373665236515441272B231F094C
2C49100A86A78131385A327625505A442D2E221F14324F29
3FD31F35091C2C58386D510E15458E352740452E71340F78
4C7B49982E3D4A70
756E654C2BAE6D21288A78B8381A7F337A3E587C584D101F
62272F0D5A221F266A1E4F684A156051691A5B7E245A411B
0C5331384B59523D3390844557963C201C423F3461555227
4B6B3669C6A9531D7F2828445D6F7E3346222B512117493D
4B5B543146423A6426151B3B20414943621C58423E57254C
1C286850586DA2AF
9E3A4165542E3B5043441833876E57521C45B35C941A5469
483D0D3458214D2E131D605942442D3744537C26545A4D51
3B0E607A7A261F73357C826389694341362477238B2C427D
5E2F5475933935426A242B1637988E0F3D355A822F2C4A7F
4A305A7668365A5C4435392A2500210D4B517381632F764D
468131463A254F60
7359498A33A314722E48391E3B162C3E6D2032AC47125635
522C0E673F470C4184258A385C3641374929472A6D474663
323F51171A51276526104C859C0448515A28921C305B0D37
6E4169350F3D3921385A4C8175341D386F383C551722856A
821A798A3D5C6B1A7C581B421F269157423242205D444247
1A388A341B465C65
6C30AC492082453A605F053A70543E12A46D7F416D5F3927
2133174E553D8C7E66065326303E784B85262620772E4412
1C47451D20243559195B2616476C651737481C2922114555
4D7A2A19664D1B42321382342C395A4D342C1174214E633E
307336552D3B8A167F2B231434539472583E61AB77565C67
9D3352232C206081
32958538554A2A36344869676D4E4420433FA55144923578
4608216C144B5E23262E1C2C0C7C4056774E5E3B2D311720
0C2D6A1E202F4D4C2D17234F336E345D2D432A5A56341832
387F27612A392039293C5A3B3638AB5C211A47555D4E3E7E
42380A8B512F456C8210221F163A403B332B82BB603B3E42
92283C5B2E2B6042
63825F6E2137236439765F931E481B1E1E04232F3F345A5E
7E547B59403A31415475301B2E842D7C136367B42C783334
1F6A41063428311D4562422C094657A63C2B284E1C2E333F
476150585228331F66122B5133335A2C1938421B2C2943A1
201D2B5E144B800236491549380167253E388C6A27504469
6653633F1A564897
21863A9A4F3132654837637946255E4D1D2C7B9C48404166
7541709C422D2C8B925A1C1C79605F693F2A157729600D60
4285121B2630207823855A3A303D4192351D49175C441D82
4A3A302622453026CB193B1A3137332519452103684E5956
3518460403628416282310513A37329B672056201D603690
397B896E3527908B
815E1F0744342C3A5DC3365853625371827E663B25102F69
341A315832074655906016693F26490D1A1E1D3920164032
7A5B4438454C2C6C30467A311D634C2D3D4D2F25381E0D40
54604920372C5550496C20A3202B153F3E61194974781138
2D1E632A164626323D7F355F15386066493E6A301F860C18
272F7A4EA37B40AC
0F8B80404532213753A60A923F3D53857035682864763B35
032B22771A387E432A160B664445426D465456551A40390F
215E21607334688810306240401E454E024E451E40406230
108868347360215E210F39401A555654466D424544660B16
2A437E381A77222B03353B76642868357085533D3F920AA6
533721324540808B
81AC407BA34E7A2F27180C861F306A3E49666038155F357F
3D322646162A631E2D381178744919613E3F152B20A3206C
4950552C3720496054400D1E38252F4D3D2D4C631D317A46
306C2C4C4538445B7A32401620391D1E1A0D49263F691660
905546073258311A34692F10253B667E82715362535836C3
5D3A2C3444071F5E
218B9027356E897B399036601D205620679B32373A511023
28168462030446183556594E6803214519253337311A3B19
CB2630452226303A4A821D445C17491D3592413D303A5A85
23782030261B128542600D602977152A3F695F60791C1C5A
928B2C2D429C704175664140489C7B2C1D4D5E2546796337
486532314F9A3A86
639748561A3F635366694450276A8C383E25670138491549
3602804B145E2B1D20A143292C1B4238192C5A3333512B12
661F332852585061473F332E1C4E282B3CA65746092C4262
451D31283406416A1F3433782CB46763137C2D842E1B3075
5441313A40597B547E5E5A343F2F23041E1E1B481E935F76
39642337216E5F82
3242602B2E5B3C2892423E3B60BB822B333B403A161F2210
826C452F518B0A38427E3E4E5D55471A215CAB38363B5A3C
293920392A61277F38321834565A2A432D5D346E334F2317
2D4C4D2F201E6A2D0C2017312D3B5E4E7756407C0C2C1C2E
26235E4B146C2108467835924451A53F4320444E6D676948
34362A4A55388595
6C8160202C2352339D675C5677AB613E587294533414232B
7F168A3B2D553673303E634E2174112C344D5A392C348213
32421B4D66192A7A4D55451122291C483717656C4716265B
19593524201D45471C12442E77202626854B783E30265306
667E8C3D554E17332127395F6D417F6DA4123E54703A055F
603A45822049AC30
73655C461B348A381A4742445D204232425791261F421B58
7C1A6B5C3D8A791A826A852217553C386F381D3475814C5A
3821393D0F3569416E370D5B301C92285A5148049C854C10
266527511A17513F326346476D2A4729493741365C388A25
84410C473F670E2C5235561247AC32206D3E2C163B1E3948
2E7214A3338A4959
9E604F253A463181464D762F638173514B0D2100252A3935
445C5A3668765A304A7F4A2C2F825A353D0F8E9837162B24
6A4235399375542F5E7D422C8B237724364143698963827C
35731F267A7A600E3B514D5A54267C5344372D444259601D
132E4D2158340D3D4869541A945CB3451C52576E87331844
43503B2E5465413A
75AFA26D585068281C4C25573E42581C62434941203B1B15
26643A424631545B4B3D491721512B2246337E6F5D442828
7F1D53A9C669366B4B27525561343F421C203C9657458490
333D52594B3831530C1B415A247E5B1A695160154A684F1E
6A261F225A0D2F27621F104D587C583E7A337F1A38B8788A
28216DAE2B4C656E
8F704A3D2E98497B4C780F34712E454027358E45150E516D
38582C1C09351FD33F294F32141F222E2D445A502576325A
383181A7860A10492C4C091F232B27415451365266731328
5C241C1713312A305021465847910C61564E2F564E653448
5E562F325646545F43443D814C891F603F263D4D5E72733E
64456B7D442B546B
796868593B702D3822515771618B3C6B6825404B4C371657
1A3B444A104B0CA983364928169019372D496E973F291971
73272E75470E5F6C5E413B221C2D191B312E6A93732F5A40
6C464E59326044C64F5F164E336C051D4C4C710866243159
38222E302B1D2F1F6C363A716C2B2B646E3431954D26A02D
371953701389098A
5ED3BB8C5C275F3419682A3237533D401D462C545D881642
1645717916213A4669105B4027790D195C430447404D5728
651C564844614939921A377618187851174A3C8B4F4E341E
6D802C3F211E167B3F20300C3724174B3B13275E4E4E3551
4F0D351A4A481F16553A635266489A7D2A60640D5E425B19
426C364508613E7C
B3776F3F4E5E74344E838731640D275A201D353259465E9A
58285B6317131763AE712F39641A65438A541538471D6623
2E343E24306E1B59375345753D0E551913724A145E4C872A
2A8C2840535360161A141E1D3C44386B3D1E7F47364D3C4A
24254A5E7089235E894847131F4F20553E4A085142168451
2B0D6A334D572484
C8744540428960303B1A424D40254627A250125380672078
21535851591D426A64210F2577578F2A53394B604319242A
185D583C10410F362F9A1D4E362725232B76769A45505307
8D521F6617233A3F0E3339668BA65B1F8E617C19803B5052
2B7B4A395B813B33A0438E4E35154F3F5C4C116F224C7C68
4C25595D294C5389
82AC1B786C1A5915074B1D2368254C7227445B193C0A5283
2C2767196F186E2A1419373B838E563D40104D733D342C38
29298D5F23094C6B2F08415A3A4E284D627758486E934831
7B1E5E6059292761081280342B887A833B7C1E4F35261815
8C2F5A672A4E103531638C2E0E465E5E4F76482054A70576
5E303236051D60AD
C361334E883474103793901820502970596A1E3E4E5A42A4
3C59674B2F341D4939521B41795315988B58AF2B273C2138
520C44705119557E461E44670B3EAC46C6680E0F85384A02
1344433B7C29577B1D7164036C7272691965270A2F183321
382EA333452D33461D6C230F3386A53D1977545D645A933E
8B771B4B133B1795
9F394252306E586C335E7A1B7D3447503A5A3E2E9038772C
654A894315243A350A1F28215E1D48854D1273801F401E5C
2C09660A18582F3A113458295169486F1F800F773F672431
12384B2845244E31666D2864934623893E1F372C9816AE10
60056E4E463B516A2C632546336427AA4A562A4C47303C2D
54876240575F3A6F
58457E2C792D104338794757431A2365153825365D334D79
28495937100F3831353A1F49542F272B624D5A5A30803535
1F53704B3252165A2F173D6B822A295D7E6A78806548650B
2D608E254B2A704038565654543D734C4D1F9F3D564D8C3D
067174112B43753556793B334E51292938648A3FBE522468
7F564D3D18449286
272CB0289D437AA21C7B5A213441415E393B7629154E787E
5668515F1B3F4C5C2627373A27284C49977215524512111A
233F703F8F207459336E681F534242731A43342A25B95155
2E8541455223144C6043345B544A1D3C0E18642C350B4E18
3465291E5350921A0E816A4F58724332361B4B7777311E48
382B2F5141524789
546A70803F9243C18662777169273D282A52A80D5C733523
362F815830381F33123F6E2F4676395C1B5B262F19373A46
25196A5C90031F761536383B2F546A73426240B0178C30AC
4C273141442E156F914F651D18343B3F752F7411170C6C0B
503450285D27753A363033144635290F2A50435242103A60
1B721A981F845482
7998296D563E3D2492B653543734642D528380088F292D30
490E33167C404142400F5626296493488A1769263A517552
034A345078433B481856655B370F6330B0515961909F6518
46257C245A3E197B59718D138B325A2E8F4532573F436329
07130B834112326625401B446C401E4C24928371555E87EC
8558883889AE4B6B
90A093536F3A378F3B6B3C870F492718523F472B3E1C2F40
3A38526043724C71344B102A5D32CB5985282A1427396033
186D5663D211461D2929282D2E891D1D3745413324343817
2C3255802A42BD504646683F635A1126194F5A30483D5240
432A3B5A41563A17762F1D10595D373D21322A9615689076
56696B9050A7384C
C781105545572E60984C82891535998085842A7C235D4829
4871821359503F18292E252D31333565475110155A334A3F
4369806E6C19062522255263185A0F6638251C5D821C0E5D
873A541C2F374C30493D61206183570B45136B1223642A0E
5349057F6C1B5963DC3B0962492F425F9E2246532422A11D
60367976591E4724
BD3350408F52247149635954170F1A0E456B9C5D37666472
2A837F5481264B3B194932B13B4D55407E33356964504E4F
755B3D3D3F7252412D38726B322D4D3E3A2A341458062162
57483D3C517D2D23222D7A59443F6B3929485A26112C2333
43421E182126252768505383272D76058E690A7D1D717552
5C0C3A3375987421
CD9398653A4A454752499D1B22661C4D74672E1F6B7F5BB2
792E61421A163D2F7131488A2A275D54674A443F575F7B51
3E3A0F36431E4E257033266278985F2B3037621D3B51282A
20523A217A695D46B1496F731E55625207135F454A27124B
2F4C4869505B6B3F1F2D31556305113C8F401F452A60611C
12557E63175B2949
809A635E3B35376D50C764351C1728576D5D215B491F276A
2E3E40403D386323574F272E122D1E2B87472213434B752C
4434112F2464084EB3154F1E5D433C7810692B1D11312F08
464E286C333B2F3D9244379527883B255162174C824B3224
313B5BC8B2172D8837171973502A315B49393253430E1837
5D18A8216A183F09
8B53B34C332564165E6A9F30394875411CA75042799C4714
27315F62412B880C28153E100E5C2B9D2C36554010992A19
526720701D6023385E41505F431F5954454F642A6048182F
9B037868251D301E64037E474681464B582A318B7339422F
2B4A080D551342596D15285E476A566E581B484113941B22
179461573A4C7377
BF9A2B86750B635F283CF3A03F3ED51E9765542A88246667
8753292F381726073A40272726AE2DA10E89865A3BD7907A
47783D977A2C0912164245550B61227297494B127C2C3959
534B664C7B2B3F634B591681525A5C4B2327458873531468
204E184F3D567C136714646232253E5465250E9024785367
535C317075CD9A6D
4A8545305C2A943671422076532D49238C3A1B523F3F224D
37522B49331F610C2A0C451A2F9A0E5E1B322A5C18BF2169
B10D69291A7F3F274D0B511551521B59441D530988142336
1E356262763C456067183021163E7162C64E607D2C635D8E
911A5F574D08524C3A3548BF16498A757B6B518754426006
6011915FA2A6624A
4653BD4829913A3C3D4E6C72254C556B2B0E605F2F454E44
43591C52353B422D1A3A4A2F235F4C25226C560F85344E13
171E3B272A710957324913140D43634A6F1F5D3F634A171E
607B361A5766183B095511084669BC6B7449A23B30304C3E
5031579D7B623D3B14470B8C311E5550759E4E29AA92A192
6724450E3218445E
65F24ED6755C063C20B9763E3C104345406732684B8E7B4C
59275419701E3349404C2C6539727A8331686A6F994E4863
3E241758618A356A7F702362382C785A1D30360343523A37
0FBF66353E5F50203A755FA05E1A14855D59450A3F8D6450
296C6C8B49363C80493134071820345A328F40223D4B4D49
61502A3A6472441C
5D519060721016845E4B3B65276C0F2951A35F773683326A
B087385FAB404F2D2125107845444D1B3D7C36282971612B
4E2255488144205CAC35436783458E4E26637558250B2C2D
563045B3345246284337312636101C1F8A478057795B2330
2942354C534F423F4B31296A6B2463196B6736525D615D11
34265B5454777675
34731B4B4B654B216F2F4B1D3F513100813E9E46693A1B23
6B6763243D25420B25351729682C44472A8A2B205D30A065
3D227951296B0A3F4416563A42215032588349825A462920
692D4B51AA3254504C76594D5B6C6F183B55785251251D0E
5C5C4258101931085939AB765B22804B2382333C783C3B83
37666A7E61714C7D
37C4B1772C9756943623303B4B072B3C132F64C48492551C
11531C39513B2A5C7D4B32312B2A292E662D7085A36E7284
41462131446C301B417E752C4F253B564E222178213D308F
18694F4D373B6E1F2B5D65915E2F3F8E4AA44E3A32937464
7575404211208F5E575D7A5B4C257EA46D7CAD923F64796F
3873246A33E9539B
2EB4A97477670B1A3EB1256DA00F2C401B5B9BA91F4F6117
1D344124644B2231AD357D74622E1A0A29405E371B52293A
4B655530214618312A1A5B060B26403E373B5F2E1A580D9E
453B250A272078474F30206F4A7343595A2B6A29207D3F79
53AA611D3D6B3A4775675D64677878403A9371505A6F4A48
5B3E1A571928B421
73FF591577408C1A43982733BC798E3543385C2B291A1F11
1F2344113D213E561D525837343D4C13355E43472B482C47
2D395A4F12311857404A423C1C15205D4A5559426A533351
7834383A6C6467B3721F1977772830633C1A378F800C6A50
720B44327D2B797A71537F4E205F7E297E4A541233104934
4E186B687D496587
3BFF564B557F2161256C9039328C79222C174959162C5C21
304F3C8E513F861D683469665F5B3F6C5D2D30141C575E81
296C4F6633690E5E3F772253374B2F6737207A343A3C4784
2B437329236B697E6423373642523C46792669504DBB5A78
927764315D6142855D6C701B401D85564B604866646B8F39
5D21720A4A902AC2
72FF16C587491239634A701194479E8F123448345367593B
1A711A594C566D586C4E3B916D941F27364C302F573F9F34
388E3E2F0F3748316A232248307A1F52647F7A7F7EAC5147
24384734263E2B0B50264F6E38212F504D31751B62843822
28411070BD6E3366513361385723506D18210F7D3442827C
AC5029582E4B0DE5
FFBE7D5C74525D0A1C82097D8C63622E720F4F6A19546E7A
22091F58362C66357E433C3867A731434B2D632B453F645C
6A68718A876246289244446D3C1C427E3943789D251F2328
1232721F666C3C3746823865194F0616272883602E0A3B11
287A3E2661799633446528018C6193245D17385527950950
CD2A371522DB73B5
F6BD9657DB7C6953C97F8D3C6B2774974F415B153F5B9077
A47D3A5A60746252722A297D2E2144681386383E3F323F55
35588D802251C7561B1F5E242413525D3028CB0D4A5A2854
0E6E4B53010C363145715A0859495B5F0F604F1B2C363D2B
033F2E4170482A763C246429742B9698768B708421691F11
6C392A6B51328EC9
E4B45E5BB14B655A6DDE3FBA5552AE5160258F3847263D5F
509F11533A3A8616044735A33D676A46203E091368291535
778849B599475443565A198645972F3C1B2E3A113F91695F
210642506A443E6D254A96535F077E22303648643A732664
1922103023203C71485597190E4A1691C38379B744526478
C78135B8543C3E7B
4B664C667A50476A69826B072E344B33643442311A43684A
1F4171298B7C375E550A35204F7A9C22C52F9226AC403E16
732B31353A3E444F6A4652364A50635A2E8C7271401E1778
32272C574079434563477B5B40451119444B26BC145A4B23
49BA1517688D393109928C921462433EA3540C573A466313
6741984D3DADC3B0
DD8546728F426A571A638E86912E474D623B0B640FC67C4D
4C2C3676022B2764586577A23252554A4DAA3956552F7B61
4B25635B753534764320995F5A4C36232F2A3F412C89405C
1F68524E4746685A870B273C2A631B1B40383E4958806013
482E9E2EB753AA392A664ABF18411410E05B565A2F476F07
453153428746364F
7D70404D6865333A676E869A843B1B4F293F4368773D4912
6A7A6D20192B678F658C9E3D545E37590A40423B46316532
382A2D5B2A2F55573109406E5EA719357B85825E42644872
4C53164E55410E675B1F0C46316742463420327A378D2873
3753A5518E4793716876267140724063BB25D33A461E8244
09225B4B4B7FB547
EE8C3D848286769B32E35F6F6C3F311E44133D651C7E7F56
BE3850472F670655616663517D71612C6933015E162C6D25
572F2A1E335C5922860F3C144E66383136776A71240F4064
7128442F1971396D3A2841543C244C26181243F94A6A4C25
938A3971455B25568E4E537435AD78667A3BE6732B161305
908069914C7256FF
BF70A7DB336C957448C89271698D3131336252768371127A
1151437132B02A3197683A944E5D56472C4B2E483E05443D
7B666B61317A408654356066903B73551F9A2499550E3420
93316F3C2F9926445F43C44618423358433E1F8543282749
6D4C157F214834383D672C57526F1B54374F58B450126137
172E496279581DB4
A49F5E5B2D1F4B75778CB4417F68451B305114275E204685
850A65A53CAD54246F6E7D7762135D639650A03B71255D0D
46403654340F6E6EB7274F366275623B353A4B8321283457
402170691E396357332E578C0A283B24682260174D280C15
0FBC86332A68311E54892DB2674C2445589579394E2C725F
3C54232B099085BB
683A6C6B4D397F1D648C84711B2A2A30283F4F375987AB3B
994B24E9B9702053BB445880565D29777C4485560E1A6043
7A167647584B7054796B5B2C614D343D0F873D935C381A47
52163B281B579980282D434B8E257E1FD1855B31373D350D
5B4A37370C432A503F2F1C431561844551A77D63502F815E
93A16A0A63897092
5C70934C667D5BBC804834075812697C606C2683083A340E
62897B37604D244F6954A6484835344A2029451928685968
202A425895504B554661161E1F2E5D862C1DBA143A5C2E29
2925744BA54F332A81776C73185D03843822A8593E3C1151
4BC158386D565D0F1861285370912698726621CDE46332A7
978A13B291A74FCB
F573B9C0D1AA60334559AC94838F57A725D13D932B151741
394E6C4F2A2A5F1078692D152F1B673943534B4B50308F29
2B20181579A90A31725A3C523A49085855532518655E493A
4C395D80526D6F293C2C8A5D2B41442D18343B65575D4738
7A8F411F39C863813AB9914CE778A50B32451C207780A6A7
FF73934611FFA3D1
FFC6FF86C6715DC28C3774EC26AA2808A356346A34244771
6E5A7C62273E4D7B3B6122691F622B2281269A4527460F2D
865C722F8DA64C17152E41344D433614592A573536403B6C
403D4D595E92480C1277313A8F28074A32407057147C1043
8530685E3966E6C078453A887B7FAE663A6F190E2B58936E
FF513F79D319B5A8
FF1BFF5BAD20D807FF614F4F6D9F59611575723840B87B57
6E9C1430681F7A843D1F652795350545A2346B086D823C55
3B500F29362951272B831957393A5B4A4059634D4185314E
304A2A5B9293271C6E3147745B31504B261C505C9C49534A
6679829D687249F6976067D91293692F60A26194694E20FF
B06DFFE41D4CBDFF
FF78FFFF63D0FF64AE68786D8A7F9F7458FD5E7A2D975658
13B37253CDAB5F0C4F254E573B7E4A21531F4C6648593705
5C9612664D4D554A37C53C5A84453021A64C387D31554313
3E47363D2F713334A099877A3962784F1C56416C450E5069
94582F5996A236C1BC176F3C6977273B6D7942886A32497D
AFA9E1B14191667B
FFFF40835EA8FF79987139A8226E3BD2505355CA4F922052
69E583095E20519526863B26284557142A4F333E5026694F
1761148322376C2A205B3E55638332796C0E2531781B1931
222D3D2C69330F308AD2875A271D662B378B452C99781E16
B78A75466D1B9B72BC4A79511F992F6A54138E7D21743896
38A5F6FF994EFEA1
FF6684362A697DFF904DE3C1813135608545B5FF6F8335BA
7635563D3739775A29A37D3B795C502E382359571F328B67
414C4C3834292E6B734C69644F5B4B6E6D732924328F4E7D
33239C23605B3E1D9F83185267346B386B9A495CA573384F
647D5A175D549D55B5497DD369311F6025465E5843DE6B72
3F6E53FF3C5CEF6F
F098FF8DCDBFE0D34B76D4642395A0AB6FAD31BF50502697
B574706833D946B648859F2452835E395C4D77829E3A133D
63354D36671D824A508977221F243D5F2606291E5C7246A4
3A3265352D5D604D93562914493AA967D555644A29183019
2D4641434D643462738B1C275343446127ADAE442FD187A4
502DB155AF36FFFF
FFA3DB53F4A60A82619C9FE5BA2FFFBBA44470C88072A340
936C69447BCA754E2451357F6478B5382B2290655D1D7666
262A626A439F244D6880738F2077333537426D593D5551A9
2D821D47503A4C7D402F6C2B233FBE56E04F948AA65F2631
82632F6230681061684F143980832F82AF2EA5FFD753BA72
8C9A7DBDDA6A78A1
BCFFFFD363234899809CB8FF6CFD3D9D7D0D796D9668B74B
5D5A70603CE848348D57C5BEA02DC1552164B4B82792A14C
61872243538C70161A71275A5E27464B299622782A91463E
1E40885B73693E432A0E9F242C53674823477B7427700E66
B54568DB4154315458B1123A849241B347B0FFA8FF7BB23C
CA76BC7548FFFFFF
FF7AD255FFE1734AFABF3A66C283559C3D55A64C189AAF40
D99E6EB280165150332DE74F5D3F4F4C3354ED934A7E531B
337B0F43742D3ECE90782A31425F391D1C1848BC7D42613F
693A4D8B473D352663652C50642799432E65867668240F70
8B9BACC78E5D6D59597D59A2B3357DBCA08788416EA5663B
52D8A5054EF1FFFF
FFFF93FFBBFFFF9A7F47FAEE32682EA25DAF6C7B99EA5460
E25A4E998EA9933B283F1D525D6C69BE4E3EF2A322434A50
34290E7640722F98643B29543C9D7E23A41F89451F3CA22D
7F216182264A537D8D6545644431A3766B266F3568328C83
7CDD7CFCAB6587A87741152C818A824DFA823D3AFF243FFF
FFFFFFB6D9FFFFCE
FFFFCC7BFF36D9FFD9FF4B394CCE3D2EA1C9E99EFBBC348C
C45F874962C95B8E5865834A7062959A9A81567E88461623
652025664F4941727D63394C285F5B487951651E67428105
3D1F2E86977334897A4A2D81640CBD50787A3E5233365DDD
50AE8CFF878512FE9961954989425D1FD24A0283FF9AC17D
FFF6D6D2FFFFFFFF
FFF8FACEFFFFCAD964FFABAEE7F17F2014437A8FCCBD345E
E91E35747763944443149F09534724A650462D7FAB622530
60745568620F2E618D434A3832400844554132433564B634
2D51583593563B4F6E4871544A57B962766D5829CC82805A
8BDD9C60B941BAFF4DCC8E5CF7E18758FCB267EDB2FE52FF
FFE6F0FFFFDEFF77
FFFFBEFFFFFF89E53F1539ADE2417A815D13AED29BC9423E
728042CAC51282531C116B57221837916E4B526A704B4E74
368A7F20293442412563333C190C412A51366C142E303567
7D4150583E0E68566F763F7C1059395F953239565D5C5850
68A044B3AD97659A74BF447273FF47AA52BED1DBD3FFFF64
7EFFFFFFCEFFFFFF
FFFFFFFFE9FFFFFFD75CBE5496FF4DB938DC59FC138729AC
5F95B28BD482425360954AA1644F884312324097427B0632
8E126F54813D4C4E812934306345395C94028A6C8D4151AA
70374362AD4B67C46E882597826E63451C67185C834A653C
5BA71DD5D96707B79BFAD9492CA5EEFF746C8AFBAF87B4B8
BDFFFFFFFFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -71.125 0 ]
[.5 1.0125 71.125 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -132.125 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Shifted) show
111.000000 13.000000 moveto
(Sample) show
153.000000 13.000000 moveto
(Spectrum) show
201.250000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFF96FFC3A3E0F9FFD0EFB28BFF71F668FFFFAE
FF51DFAE196E9CA28CB58E14688159B01A457FB656446B57
7DCD1B54C85A6D9AFFAE3D607B55A01D5B1DA0557B603DAE
FF9A6D5AC8541BCD7D576B4456B67F451AB0598168148EB5
8CA29C6E19AEDF51FFAEFFFF68F671FF8BB2EFD0FFF9E0A3
C3FF96FFFFFFFFFF
FFFFFFFFFF66FFC15CD92AFF1BC8A5ECB5FFDB61832EFFFF
EE774CA2939F34CF74587B2C6C4A0A711D466A7A77913E83
51C3402187402651A5C03221AE34C93E683D5E5D6531355E
B51F254A5D4C5623A63C0A80479B483B11597332448B4FCE
2387163A82BAA35CAB7A9EED6EFF5179AE914AFF18E862FF
3DFFFFFFFFFFFFFF
FFFFFFFFC1FFFFFF5A61FFFFB8E7D6AF56B438FF885D32BF
83A46EA8BBC43B9E5F44626852602E279769424D0770326A
764B6F183250494A795A442934206B435C363915243B3362
1C49432E272583863675554A7A614B437B833F1513515522
164F8410CEAF23637C5A30B276C0AF1F84AD7147FE91653E
2DBBA2FFFFFF97FF
FF3FFFFFFFFFCCC4FFFF62B2FFA5548ADE2661FFC48CA5D6
4CFFEC2ED86789D97C417F9CB9364A637260BC4F504C6A55
6F45464F854A4B3D2124BB7845454F4E393C175B28433B5E
9C6B3521526D5B696A2B2268B27A273F59A8243E6613B827
5E5C984C9A6B2E47E55514989363B533493570C5C2F7D9E9
95ACDFD6FF9CD0FF
FFFFFFFFFFCBD9EBFF4CC4CED475322DBA4B3B50A643A564
BFFF116D6BFF769A51C8633022432F796C48C1116C89384E
817F40798B942F2C4F0C7030782F614F68496456155E2A71
8A62513C405919126D180C4E9078527F9996915D6B528869
67814FB94E5D9B7AD09D16A1DBB3DBCE8A0E2FA57B3F38F3
EEFFA830FFB1FAFF
FFBCFFFFDB88E9FFFFFF452FFF5B2457FF605D818137125E
98A277579DF97FCB6A76823D5B2963187B67A53432784E7A
97766A4A0F8C570C873D9821302E6F2090376D86316D164C
6785305F2D671E313A535545149BEB303FAF5A5D4D583150
112B8E94A2AA6680F68335C17C7040AD357D0E9E09FFDC76
7E68FFFFF7FF94FF
FFFFFFE8430AA8E44B3464A16C3F8884A2BA8032BAA25A79
585D69588FC2A5A18F750A2E6E6D826E3B4E931D59533766
701B3F385288543C68386A3C86B850141517335A44383072
98C9392C6C3F0E8033255D754293E25D263E45386457F940
48495B0898A45CB6EE579E8A1D63B5425298687CB75535D5
EB507AF2FF62C86C
E1D6FFF31562EE79AE6C8B4FEA8FF6D1388E4E8C653C149B
3D6D196A53EB5C52C270097A216F7E4A274769552F28A714
334938756953803E1B314F872683158925583D285750326D
240D6F86524A2285644DA08F2EB5AD65154EB72297B2D05E
A81B65CE494158808473BF546C61942262C527D741FFBED3
68C52F1B3EE0FFFF
FF939A4BC8DD6A8D8A5AA83BC9F2B042B47E408772381D44
5F6B117032672D648334295DAC8B9054E652C7471B357130
49804F45463F12792EA15C4C4060683C333B2E751F8D777F
6B4D24A1456A6729236E7915565B88153328A66D536E4259
324962B26045687AA922C15265A8943A8CDEFA4D98FF919D
83682886FF76FF98
E6FFFF4392758F0A2D8C6AB7522CD09517735D525B230E7B
7A75204F5D502E423E1D31222F3F6058D769B03F4C172A56
944C635C313667383DAB477259272C063069342D2C2A6B99
46438D16763C5B3064301C2D9E81694D6C2A58776321B28D
59A659D42257877FCD8A39393BCB2C936FB78CAE1D83B557
37B3D19EF1A6FFAC
FF71FF8264FF614B275E57BA5065565F2E67374079D9724F
9F6785407223476E675A2B7EA85B55926333673B6B4E197F
9D1A4557602B992F3F8A5A8C2B331A70777B3D51416B5A5C
7B5E36213D3C5B413B64863D214E5E1D3B345656814286A9
2D507E41453566248BAF376F6CFFA62C6D7C364E9FC2C463
77ED5A6B511C6341
FFC2F63982F0D1A310AB175C4AA69639724711A742418546
CB5D811F623A5F92A32B3272A831418742217118275682D1
8630122E64303E322B39211A6F262A196676277D59613355
1728653F248E135B1E586E2052423452291458462A233C88
248F5B2C691194DA7C4123824FDA453B69C148883D8A2077
8E5DFF8B7FAA31FF
FF7B906C4C8EBE85B962523E5BA95F738F4F088B844E6C31
D5BA20B18748324B8B615B0B416F3F561C527964387C8BA0
A63D3C7338333A4D381945562A703648981C2251756836B8
2F3C4F47596C099E5A0A3D5443674D1C54214E7F4251521C
440054B1CD6664B428656480367D6FEE5256AF62AA4A6089
9348FFB953FFFF88
FFFFC35B26F5FF67A4FF294264A15DA0662F6D9B16D6736B
8FEE496E5FA7887E5B57593CAB51431A333D463F6B854135
7B2132A495622B3F344023933750624D3D4F5E44335E157C
26204D2F33260D5439543D836D096D37A74A033097276D27
3884742860371D937C548AAB47436A6914545AB061594E6D
FF0DD0319F50FF17
FF9EAC29CE6C5056FF6F9B462005196E4064B66C717A2D54
6AB6D16723726C227037207D29515F3631351A3AA14B2167
23193A9E656641393662334A372E6023601536484E37422D
15174DA7902D765988300E4B2D4098288229326321682262
43754D46226B8262687945252F703A51A90121A41FEE6E2F
96CD5973D293FFC8
F2C7B1FF1740A174FFB2A18D6B2E144C3709A173E45886C6
44785ACD3F154D85732F4A5C4E6B372C21254C4233658632
372D6B7156815E3A4C394B5E65182452565B074838503F57
76300EA77B12132526308B364B45484F3D406F2338142F65
810A5F2B2E536C56314A160D269D44D21EB04E87868CA856
463B60A2D7CEB074
58C84FAD97B0168995A63162E8CF206875972A906D4E2267
14125B61663B5EBF4E5F1C2E4D4AA0163180154C0A6C6A8A
723C3F5993418937272634672C21AA2D2499531D270E0E58
4C4D3F558E5838342A68556123214B232649313A4845A35A
664E1F515C3E828766092C43057D2B6D587F641C5D0C3E48
87C2658769559D74
6881649D6E147C9B975274285D5872A747477C650F3B1B25
41462037082E354F6A1E3B424B1D5D72D8316B3D76382927
4569B73B122454144D2A341C757E4B771053243A6F444B56
704A5E55493D73088441571A145C8A4884722863517B554A
B4501E6AB2F5244299419F8F65355E2D2D2C1539066C7C79
78239329637C6140
BBCC6D84213C385B544F64303A50678C474E174672A2407D
45103A5E33388AC2120B161C5B1D56236E2F2F3618804B26
2D577349187A6313335625382392432E333C5A7163404423
B07966192E4F3A3D400B5D267439A4539666601068748368
732B4EA843A3590A79873C116A3A18623A0D38648832A38C
70853E164574488E
C4C50F517B6E45341A425A1948C05B483F56226D51532768
3B3C374A2281174D6E4A282943852241415C31411445CA43
644122962D3C71369A21320B56952A9C1A5A71409762673B
5581427D2C66666F853C4407345126492A544A6B488A2F5F
9C3420B4396535450C8101618F734272222121865E7183CA
596C897827E7A863
EEFF597B57956F749C12050E2F67DE2F836087BE44854B5E
8148194F3775487DA031566056F2440E1D20561E38554A2B
3F7633741E253B327C5B36082E6B6D75422B315F5510441A
8718505A3D13233D652C723A145F0C3E6D21577A73485963
5A4D046B35424B31C850857922613816401F333D676B5CEC
2D96708F7B7E3F8F
7844A98D3D3E4D300756771D3E2DCE26C96A53824B64347D
6260864C8F4CB6432A85247F3980241243394F63263C192B
576B15434E4D0D4E4F774B5E3B5F7F827D3C1DAD5A753D08
3756582B26582E2C3C306531443C424408593B5D573BA18D
689369281622717B680F453F7E643F472A49193C7D978D7A
5D3C29726B464670
D5452F43893C493D4A12794E26516052EE1C1B4912BE425B
343AA159AE249C35560F67774D4D34423F2021581D3C2E0A
96515F3B3E59446E1C5B507D32374225211626596B52AD2F
346644387652533358546B37474A4CA4545C444630A18455
5074381D0F6D402C474585CE1E5703436A4140278881995F
0F63674E9C72498F
57B6D2A23058904859065742434A154B9637485B199B989D
0C2C44856C100EB44E2A455B13BC28483E1B163F38657747
6E4C3E7A366720303B69232A486B5FA21E606B3A4B214A5B
55412D53443E2A197E042953993A8B33C5368E8641212C05
4965438380207039174F6B4A202F433663314C3132086784
656C504975615573
DEA34C1532AA337ECE715C4958935571A2811C46261AA360
4858240B1F230C120F6F2E7A426B4D3032207F0661569447
297244466E5B3D061C51759C3B013F41254F1F9C477F2555
49364338AAAD5A7E842D182B661B00451A436C663CA53944
03168538455E14AC41514F223D4E7930473A946B3BAD52C0
4C6F5B48985685DA
E3CB9C296F5B34498A261673196C587A5F8A9E3B883D6138
3964173660541D30142035471F0F59551252503C620C4E6A
43383D100C58526A0E5928654E16CD313059541529276020
1959C75323808D5B3A52443244363F800872481A2C8E1A35
64635963735F2D938D5F9653552B513E687B58166855716B
BB34616ACD5AB3DD
FFBC7ED41D1D2D36C3440A8A2F553A1F5D17A55894102861
4629868C5A1A48683C23280F1B75713A2C0719480A762971
5348315C662863390C34212E22986B362F7A37144A6A3D45
902852647F96716F76535D46412E5A334D4939AE60403C43
833B6326345F1E0C1E776C581B6E5110752F64638F7C0887
1E096157745779BB
89F92140165E435A9E6D6C5520842212105A5727554E4E46
5D5C3A71CA6113312C1B417659266E2A525C3D2646744A19
5E191F3B2F263C2E253F56A0897D728A5B4712712D4B161D
752B53300D26499A313398385C2B324B3722288E6B9A4046
76547163484E276B0B3D6A5D432C3C2E268793488A08814E
5223073282B310FF
34C3318B510C7827563893746365516950567F2141216B69
587E4B65612A607D917463BD524E622580503C5C45393026
657A6B722B2E6E4A32834336372F8122366F284833582776
495C0961385E4A7629796854231D312854723D5068736440
6E1F8C434795344C26195E1F224E41232C206F8928339463
205918784C465FFF
6E7A5C46717561134623591C3F025E5B79378C4F2E528048
6669732975433908634575058F8F4521456838318270161E
6CAF6B6871363C367B5234536C415C59496125171E424846
4350112D0949613A2F4323492F424D61321247472F37554A
235D3A1A3B184522260A1B172B265B343D3F8C84C52A30A0
4E1083396E1652FF
2E22B8291954193D6143456B5C4A799C324283707362696A
773B2F5F441270A14E6D4A761A2379294F5A517F57682425
483D761A300D1C4245A2096018295B3937423E2A0A075E1D
2B301645242D59684F3A294F163B62472B051332636F7C30
A6391D475C2D3A342618664F27B3965B21472710A06A28AF
3C1C0E6A7976AAB6
2B8B5AD93E76146336617C743E88B58865AF7D1E545F7960
53658E270A46417A6F5E7D8C2B4148A9418D4B3964915B5E
212C642E3D53485D129C244A2E6D172E5A55421F542C7E7C
481A2C6E403525474486726DA88375306B2D293223392E41
7B553140432F114315295B838DBB6D32014F1D1337502132
2282649F19879FDA
3D6C545F6786665E2A7542367233397D24598723656FA940
530E38170E5D405E5E101C2551517A553F1A73705F485A70
4C564C38B55A4B275F2B323D667C4485642F462C39306212
4E450865214E7C1F43689E31621D2C8B2E49482D6E25142F
20124A28441C5A6D6D1A15395B39962F77112F56312A3A3E
6011397A4C5F2983
56816D8351614F2A390C565860482B5D5E266F316E5D2235
424738465D403740323A1751785F8D408214280F312F342D
502C3B4F3DB839244A2D3A023466685D195E89537E6F3E34
B75429357A444A1955285C70371D43773B1044424C730729
242C4E43A9653C84B469348335795FA450290F6F2766364A
617E1816786A9B5A
6F253B7B61302C576F554D3C351F37893A4B4229140E2325
4F762A30377C6D6024625D824C1C58694F7E2515679A5E6C
461D5355462B64BA1742354B4207362A1F61802D465D3063
895E28975162291B2C743751867F6268477E7B8536512A39
305A3E0C7A1059195F4C7493445D40664C3B4D1A3C387EB3
1D3B0D567CD756ED
4D5F46142807482F749D999EA024529F834D501E339C023E
1D35315581914C2B464B44233B33AF3D6D61BE7240000D4E
113E116C531D32815D1F184C66405D1E6E486147101A0D4C
2F501073313146221D205C2A7C11486E162B5C562B263A2F
1D325349435012523D364C3A335E560F2560634D217B7155
353D4389333EB54B
4D4861A6A25F9110600563425689536B7C778D4B17BF4834
3B4A550B4F58641B948C605F2E7A5C54C66A76461E19281B
656A4B367F5A5C38262D1B0B8A0C4E153C5326535C135715
4520397F142C7306AC731BBF125A2C2F1C590B9A34214311
2E07631F2F462F583B52254343551B388E264C3155742240
74359728602E4785
C86896CF72712D5D596657772A9115225F5045213958591D
5C1E775E39511E5E2C600A58637F3A16224D634E62711146
386D513E853B6343434A361E6C1F3D52957A2F70095E4B3D
0F1D0329779F42774C7296D14554958002962FAC30362450
300F3724283E354D9767591B912D53598F26DC4C4D98FF33
345F5B13767F2494
8A7E7953415067911F22258A18473C284E65555E4F5A1E20
6A4A3E245B0611582B2F3534868629374652547341456E11
581C3F2C156B6F0F8D22273B5B37575D4F5C65273E6B4B47
673F19631B6C1F714D12349919395E2E239634570708441B
21068A33496265382A104299764750AB193E734A3933A06C
5C186228344EB755
8C164F215C259B265E2A1001405F373A54502920467B1B16
3D853411B8C55F402A1E33448A52116A4D2B3F892B913741
913E324036692D4C450B333410212F6D147A3E41611E5211
B54A0C6020340C343F2B754A431A1F408B2425291A2F1D5A
5428592F3F354B4A3B5F21234C5A28676D5527162B3268C1
5562292B4A556594
CC531F5E1F697065092B60672D521B4194321C0A5D4F3B30
1649715649714F4E2C4E12234C405B0F0B5862581A796E4B
B3475E687D1C375926282C4D38235D342C265A9F76682B33
6F234D2240340E3C3D527B605840464A6956602A29884937
6C313B0F1D40692A7DAE55757719285F824827741418A63C
4556383C31628B8C
AD17818F8228461C5B617E750D891963890F7D3B24785E4B
622A291D241C25493C30262611275B462E396F3C475C7B2D
271F297A4D393E4A545F1D0355133825403A542737687B31
3543586F473846528150585C5D75283D84474B4A34A72543
293B5C3571446F711E7D666444559B5C571C1E082C485150
3D6B383F8E3B4E42
C41F4A1E577381306721A52429554B269E6547344D5E093A
D9685520707E0B44500A29672814700D4312528A5D27633D
47294C3827155733895611148156251C4260175E23595F1B
1731120E616D89695031582B5F24045958574539211D1526
341F5062490B74625738484F336E3A8778908F3523857758
8F562F583F5D0A8A
865033A15E946C5E596E855D0F9D2C3629493D645205282C
6C0C305E4B56332B3A405439502D5958142B15625E3C664B
4049C242318057392B113E391F363C4C3123208A2D292C2E
28224411D0615A701637603925152C2A8459CC30612C114D
34715170465C5833363F35244632433B4F1D1F41188D3E6C
3198394565608FAE
6C59629A864877498ADE7A4B42839885195B173A5D50273A
1D5A4322527515140A2E59364D5131538B24533A831B8E6C
62722449512E841E4F105FA09862604EAE35600C3D5C6159
1F45374B7B583D470A4F785A3C23610E984A9A5D281E5516
504F53356B0541053B38293D8F0B8F6F5B404F2D2B4446AB
8911544F696437AF
50736676108F1E641A5D3005365A4D451D0C1E293C152C2B
2C31822D5323523A5C0868081F1B7A2A7635322A15246449
946911243D3834224FA92A861EB93E5E43706B5B323F3539
177625068B6472172D4A3A411E2E1F571159437B433D684D
0A402B2E2249873E27254171571FB8543525333177606958
78B141A1528E7E7D
2F7E56443A602234403D242A6A773F0F433B37764E576588
16218A5858242A622F174F08342B63180F3D1D4C545C3442
614C11214E46428133564EB72C262F4414744A445918646C
365D7627963C703E1E190D1244501473994A4D27283C3829
285A503D185C556959797E4E192A7F45335541473E165D89
0F9E6E3FAA2CB229
4C7998351938494B90573051BA488C552B3A204441434D83
6624793439227D6612348640554098264E4F764256505851
3C3E732B4C259161300E65466B7E7B6C7A652D2D8963360C
2E640E4E3B44784A2C32437835594E4A641F212A5E3F1641
352A4110183E5446237F4B375B35293812681F1B4659477A
404C09327E227352
A8642E554C40567C542D393A5451345348A1245F3051216B
2670583E43496B036313A91B942B361B3F8F274A97622B6B
66334E2347294D39103024663E79127D246F4E6E4C27522F
134228551E04701136631C3B29836A0E457C402668182328
0E3842300C47834059217D2C85384667335A3B408928825C
3A6050762A604E46
CE8E242E0E5A137F7F36905A576B476C1B45A29527043060
1C3E2D374F399B38412D3D12320E237111616A6D660C5E7A
2276602779354B4810064A3E810A1064CD49B23C0F65431B
4A7E53184F7345085636253E2A2BAE5B879515567D471653
3B4D223233496E54349E4956463F166F55673048251B9D90
44056B2F924F406E
88AA5F1A00312E38667005A3531F4F724669624404398967
372E0C431F714F399B0F0E21374C1E883576757E34288109
145B35205157672B893C419A654D5B6F6D572C5432553804
277545102966882C28362E3A43704F133F3B5392853D3417
152A6F186D1867262D86510B3A195C472A734F246C251B4B
0912561E69771FB0
D186534A2E6258294B6E794F2273104F5C415114354F9042
A3353A81593848812B564F3D80148169892656A095613B32
124134250E5E1E4E98085D57459E7D72341E1F2333481894
37390B46163C575B1328211D445D4E3C552A8D5B7B280A26
696B4520555753521C7726617D4D194DA92E442445494821
3B305D86433A426F
BA841E574627730E374C7C13384D0A49424B224F2718474D
8F572B817558522A204544473B45842442713649381D2317
18136152583F298B29288A4F5F144973141A570E3F744354
36591E6D2D2342362B25641B453612588C3F611D6B393279
AD6215161F6C5A2D54A4563F543440272A652A1868287F8E
4D307A5543366C6D
6E70326E1346427450154F385D115A642177A643715B5C44
5D1B184648133B07574C3B484D592C0E3F4D1A23350F2E1D
3D7B1C24203B2F86722339544B913C4A154E7D141A733516
923B495E4648571E632B5749424305465915117D2C3B630D
63483E241E83704611430E7E555636511D3C454E37252078
26355B354F7FB8C8
768B0A8F1671561E3B29A3224E942E316B6530306E743938
711C311A28312C20375E3523640B704F4A21086C364E175E
53C7456430575244703E5D3076976D2F2F18192C1A243B40
5D6F5E0D47772D2873741929419870482C391B93172A4937
83AD0E4A1349483C1E5519334C4C412569683A8A61725554
253632743A5A6869
926B542B457D6C45663D7372614F3F273E631D884F853F42
4161524957342E59614833675059314D57610C9248584721
51312B3113171D245C2714736851385354432A2925210C49
2F480E0E87AC872E3C593172274C5A43302B1E1C1036552D
41D1223608202A5735724F1214479134293F493174330E7C
4D7C4B982E3C4B70
64616C5D1CA2620F34916AAD282476457443516C495B221F
5E2825174F271235742A477455206B4E6112647B2855411F
0856353A4A59513D3491854558973E1E1A46433366535328
476D396AC5AF591E862623445C737A3645282757221E5041
455554354042426430181246194D4F4E571259374D4A3055
13345F49625FB5AA
8B2A4571641C303D55340B357D695D440C58A55F8C10577A
463416254B1A4432062A5964385035393C56862B58534F4E
4215678077271E70377A86618E6D4144342377228B2D427E
5F305475963A34456A262E1A3B9B8B0A433D548830334185
41295E765E2A6650522D462F3310321D484B6C706D326850
5172354533386557
616E5C7947931D642240282D48153B41601C319F55184D29
5B37187047460D4086208A3A5E374339472B4A2D72434564
2C46551D214D2B5E2B0B5481A80E455C502F89142558072E
6F4D60320537421C306343847F3020347630355D1F1A8074
7A2476813B5863257161264C2A2C845E372732105B554335
2E3D82490E5A705F
4E26CB303F63274A4A711B405F43321E8D6E6B2A564F2935
0E401A62474F837275075C2F29467B4D82292621782D4414
1C4545251C1C2F5410611B1B555F6A192F482927320B3757
4685230D644F28383909793C313C604F3826127921546439
326D3B5C343C7F247A21342042678B5E4726759360715451
A32A6317391B7D6A
4286953D663C222638397A736A3F44163C4E9D4F3A873A84
4813256E0B45571F212B212A087941537B4C6238312F1C25
0931691C2829484B291324502A662A59234130645F2D222C
36861E6428412A333239533E2F3CAD5E221D4B59604E3E80
42380B8E542D496A8415201D144338353A2B8CB455483836
96203C4D2F297136
5F8B596C1A312A6B3E7A5B8E174F2220170C1D2946365D5C
7E52816048412D3A59703923288036750D5B70AC367B2D35
187341043D32281F455A4D2C0A4650AF32212A4F13323C35
525A4E4F51312A295D0B33552E3755281D3B4B1E2F204D9F
211F35570F457C083D480C4E4007701D393F86712D534D62
634E6C4722524292
1D8E3A9B5829316E503B5C77451F675522337D9A46483F6D
70486CA5453128859352251C70636661341E226C2B640255
37950A2332372A713077662B3D4C31A42D2539284C442785
574B281624362317BE12361A2443261D1A3A2B0F5F4F604F
2D1E510707637F1528281849433D349B712551271A683F8B
3375936C30298884
7F631C0B473629375DC934565467506E7F7D663E21142C69
391835532F074058965F0E623D1E5306191F192E2C1F3D25
79694543493E395D2B3876271E67523C424A2B143F12043E
6371592F4222514A3B5F1B982A271A443958234A72771B36
271E632D194C24353A80355E183863664A3D6A2F1E860C1B
25327952A28042AF
168D8548493A1A344DA9088D3F3F537F7531692F5D7B372E
0A322B722232774C2B1A065E4747426E465D4F5C1536310F
26671E6A78317488052E5B3F3A233E4409443E233A3F5B2E
05887431786A1E67260F3136155C4F5D466E4247475E061A
2B4C773222722B320A2E377B5D2F6931757F533F3F8D08A9
4D341A3A4948858D
7FAF4280A2527932251B0C861E2F6A3D4A666338185E3580
3A35244C192D631E27361B77724A235839441A272A981B5F
3B4A5122422F5971633E04123F142B4A423C52671E277638
2B5D393E4943456979253D1F2C2E191F1906531E3D620E5F
965840072F53351839692C14213E667D7F6E5067545634C9
5D372936470B1C63
1D848829306C9375338B3F681A275125719B343D43491828
28157F630707511E2D4F604F5F0F2B3A1A1D2643241A3612
BE1723362416284B578527444C2839252DA4314C3D2B6677
30712A3732230A95375502642B6C221E34616663701C2552
9385283145A56C48706D3F48469A7D332255671F45775C3B
506E3129589B3A8E
5F92425222476C4E63624D532D71863F391D7007404E0C48
3D087C450F57351F219F4D202F1E4B3B1D2855372E55330B
5D292A31514F4E5A52353C32134F2A2132AF50460A2C4D5A
451F28323D04417318352D7B36AC705B0D75368028233970
593A2D41486081527E5C5D3646291D0C1720224F178E5B7A
3E6B2A311A6C598B
423671292F4D3C209636384855B48C2B3A353843141D2015
846A492D548E0B3842803E4E60594B1D225EAD3C2F3E5339
32332A4128641E86362C222D5F64304123592A662A502413
294B4829281C693109251C2F3138624C7B534179082A212B
211F57450B6E251348843A873A4F9D4E3C16443F6A737A39
3826223C663D9586
4E6A7D1B3917632AA351547160937526475E8B6742203421
7A247F3C345C3B6D3239645421791226384F603C313C7909
3938284F640D23854657370B322729482F196A5F551B1B61
10542F1C1C2545451C14442D78212629824D7B46292F5C07
7572834F47621A400E35294F562A6B6E8D1E32435F401B71
4A4A27633F30CB26
615F705A0E49823D2E3543555B103227375E842C2A4C2661
712563583B8176247A74801A1F5D3530763420307F844363
301C42370532604D6F2E07582514892F505C450EA881540B
2B5E2B4D211D55462C644543722D4A2B473943375E3A8A20
86400D46477018375B294D18559F311C60413B15482D2840
22641D9347795C6E
8B57653833453572515068326D706C4B481D3210332F462D
5250662A5E765E29418541333088543D430A8B9B3B1A2E26
6A45343A967554305F7E422D8B2277233444416D8E61867A
37701E2777806715424E4F53582B86563C3935503864592A
0632441A4B251634467A57108C5FA5580C445D697D350B34
553D301C6471452A
64AAB55F62495F341355304A4D375912574E4F4D19461218
30644242403554554541501E2257272845367A735C442326
861E59AFC56A396D47285353663343461A1E3E9758458591
343D51594A3A3556081F4155287B6412614E6B205574472A
743512274F1725285E1F225B496C51437445762428AD6A91
340F62A21C5D6C61
92704B3C2E984B7C4D7C0E337431493F2934914714124F72
35572A20083622D1412D5536101C1E2B30435A4C27723159
3C2E87AC870E0E482F490C2125292A435453385168731427
5C241D1713312B315121475848920C61574D315950673348
61592E345749526141423F854F881D633E273F4F6172733D
66456C7D452B546B
7669685A3A74323625545572618A3A686925414C4C331955
1E3C4849134A0EAD8337492A17931B392C48709841291974
73282D77470D5E6F5D403B241A2C19182F2F6D9776305D3E
70445257306445C7535E174E366C08214A4F700B6423355E
37202C31281A311C713839746E3030656B312E944E22A329
3B1E5671168F0A8B
6EC8B87F4F355B3526782025374E453C1D513656557E0E43
114670831E243E48630D633B2C7D1115594605434249572B
631E5748465E493B921635731A147D4E154A3C914B543923
72862F3B20241C7B3D1D2E0F35231A4D3F0E2C594D483B4C
57073B134846181B5D445C5B7143A67721645A115D384F15
50744246136E3270
BA6D6C3643557A304D8E7F2868182A652A274034543F56A4
542D5A6C1F161562AD7932396B1D613F8C581236451B6425
2B3642232D6D1E59365443743F0E571A147349145F4F8A28
298B293F585261131817231D38493671422484453B474445
202A525875812B578F4D4718274F224B42490A4D38137C4C
370E732746571E84
D16F423A43865D303B2148494524442EA94D194D7D612677
1C5253575520456B69260A287B5B8D2A553C4E5D441D2128
135B573C16460B393794184833231F1E34727D9E45575D08
984E1E5E0E25344112323B6195A0562689698114803D4F56
2B81483859813A35A342904F351451415C4F1073224F796E
4B2958622E4A5386
88B01F77691E5612094B1B256C244F732A475C193A0B5186
2D2667186D186F2A1517343D8592533B3F134F70433A2E36
282C8866291045752704385532542C576D6F5B4D659A413C
892B67575120355B14098128347E757635881E4C37210E0F
9B394F711F430C2E376789390444626946724F1F53A30570
66382E31001A5FAA
CE6E404F922F6B0544909D1B25483067556F163F4656499E
34546E493332224D3B5316477D561595875BAE2B2A3E2536
560845734F18537E4A1B43650F3CB249CD64100A813E4A06
10484B3579276076227A5E0C666D6A611171230E32123D2D
41389B394F372D3E1C6030042795A2451B6C476B575A9036
7F7F135A0E2E248E
A8464E602A7650603A5C822889403B5A33674638852C7D21
594083470C3042380E2823186826407C450E6A83293B1C63
361170041E552842132F52274C6E4E6F247D12793E662430
10394D2947234E33666B2B62974A278F3F1B362B941BA913
63036B49433E5870266B2151305F24A148533451543A392D
547C56404C552E64
4C5273227E32094C407A4759461B1F68123829355B374B7F
2346543E1810412A3541163F5E2A211F644A4E5935784332
2C4A78443B4E0E642E0C3663892D2D657A6C7B7E6B46650E
306191254C2B733E3C5158505642764F4E26984055408634
12667D223934792466834D434144203A2B558C48BA513057
904B493819359879
2F29B22CAA3F6E9E0F895D163E47415533457F2A194E7E79
5969555C183D505A2829383C28274D4A9973145044120D19
1E3E703C9627765D366C641859444A7414442F262CB74E56
338142464E21114C6142345C544C1D3D0F18632B34084F17
2F622A2458588A21168865574E76373B430F3F776A2A243D
403422603A44567E
507D7E8E52A141B178586960773133253554B81F57714125
273E8749222E2B400A4D683D437B435911571F2E1E413A4A
2D1772648B0625761739353F325B6B70435E3EB91E862AA9
4F2234383D24116994496424152A3235762A7A1B1F086808
5C3A5223532D82312C2B2C153C291E0C1D454D5A3605305D
1A641E8F10766673
6CAF3764694F541189AB46442B2D4F405B6F8F0B8F3D2938
3B0541056B35534F5016551E285D9A4A980E61233C5A784F
0A473D587B4B37451F59615C3D0C6035AE4E606298A05F10
4F1E842E51492472626C8E1B833A53248B5331514D36592E
0A1415755222435A1D3A27505D3A175B19859883424B7ADE
8A497748869A6259
86AE8F6065453998316C3E8D18411F1D4F3B43324624353F
3633585C46705171344D112C6130CC59842A2C1525396037
16705A61D0114422282E2C292D8A2023314C3C361F393E11
2B3957803142C249404B663C5E62152B1458592D50395440
3A2B33564B5E300C6C2C280552643D4929362C9D0F5D856E
595E6C945EA13350
C48A0A5D3F582F568F58778523358F9078873A6E334F4838
5762740B4962501F3426151D21394557585904245F2B5831
5069896D610E1231171B5F59235E1760421C255681141156
8933571527384C29473D63275D8A5212430D70142867290A
50440B7E70205568D93A095E4D3447659E264B552924A521
67308173571E4A1F
AD424E3B8E3F386B3D5051482C081E1C575C9B554464667D
1E716F4471355C3B294325A7344A4B47843D28755D5C5850
81524638476F584335317B683727543A4025381355031D5F
544A3E394D7A291F272D7B5C473C6F392E465B2711262630
3C49251C241D292A624B5E78243B7D0F896319890D757E61
5B1C4628828F8117
CC8C8B62313C3856453CA61814742748825F2819777555AE
7D2A69401D0F3B316C374988292A6056694A464058607B52
3D3C0E3440224D236F332B68769F5A262C345D23384D2C28
2659371C7D685E47B34B6E791A5862580B0F5B404C23124E
2C4E4F714956714916303B4F5D0A1C3294411B522D67602B
096570691F5E1F53
8C9465554A2B296255C168322B1627556D67285A4C23215F
3B4A4B353F2F5928545A1D2F1A2925248B401F1A434A752B
3F340C3420600C4AB511521E61413E7A146D2F211034330B
454C2D693640323E914137912B893F2B4D6A11528A44331E
2A405FC5B81134853D161B7B46202950543A375F4001102A
5E269B255C214F16
8A55B74E342862185C6CA033394A733E19AB504776994210
2A38656249338A06211B440807573496232E5E3919993412
4D711F6C1B63193F67474B6B3E27655C4F5D57375B3B2722
8D0F6F6B152C3F1C58116E4541735452463729868634352F
2B5811065B243E4A6A201E5A4F5E55654E283C47188A2522
1F9167504153797E
C894247F76135B5F3433FF984D4CDC268F59532D911B5967
974D353E2824370F3050243630AC2F960280955445D19672
4C77429F7729031D0F3D4B5E09702F7A95523D1F6C1E364A
4343633B853E516D38461171624E634D22163A7F63580A60
2C5E1E51395E771E5C1D5958392145505F2215912A775766
595D2D7172CF9668
4D85472E602897357440227455314C268E381B5543432552
3B582F462F1F63072E114321349A0B591C2F2C5A12BF1B73
AC06732C147F3920451557135C5326533C154E0C8A0B1B2D
26385C5A7F364B6A651B28191E46766AC6545C7A2E5F608C
941B64584F0B554A3B3448BF174B8D777C6B538956426305
6010915FA2A66148
4D4BB53E3389433D3555717B214D6360250F565E333A4C36
3D521250434953321D2F3A262B565C2B166E48117C2A5C20
1D224631317310502F4C0D1A104761486E1E5D40664C181F
5D81321D536C113E114E0D004072BE616D3DAF333B23444B
462B4C91815531351D3E029C331E504D839F5224A09E999D
742F48072814465F
6FED56D77C560D3B1DB37E383C1A4D3B4C66405D4493744C
5F1959107A0C3E5A30392A5136857B7E4768627F86513774
2C1B29625197285E8963305D462D80611F2A3607424B3542
17BA642B4655531D466C5E9A6715257E4F69581C4C825D62
24606D7C37302A764F25230E1429424B3A89371F353C4D55
6F572C30617B3B25
565A9B6A7816187E614A3666276F0F2950A45F7935833469
B4843C65A9434E2C242907734C4244103B77431D37705C28
55194A447A352954B7343E6F7E53895E195D686634023A2D
4A2439B83D4F3B2C502D342F310F281482408D5F7851173A
324037405D4638474235225D6E316F265E5D2B486058560C
392A4F6151836D81
3D83295F4C7A3911603E3A2A31562F11772F96395B39151A
6D6D5A1C44284A12202F14256E2D48492E8B2C1D62319E68
431F7C4E216508454E126230392C462F6485447C663D322B
5F274B5AB5384C564C705A485F70731A3F557A5151251C10
5E5E405D0E17380E5340A96F65238759247D393372364275
2A5E6686675F546C
2BDA9F87199F64822232215037131D4F01326DBB8D835B29
1543112F434031557B412E392332292D6B307583A86D7286
44472535406E2C1A487C7E2C541F42555A2E176D2E4A249C
125D48533D2E642C215E5B9164394B8D41A948412B8C7D5E
6F7A41460A278E655360795F541E7DAF6588B5883E747C61
366314763ED95A8B
2EB6AA76796A0E1C3CAF286AA0102747215B96B3274F6618
26343A2D5C471D39A6307C6F633213052B47623B164F293A
4F68592D244516302B1D5E070A2A3E4237395B29186009A2
45421C0D301A763D48252468577F515A4F2979231A764A6D
4EA17012445F2F3B776A696273708342329C794A5C6B4543
613D19541929B822
6EFF52166E3983104EA0302AC5848C3F3D345B262B171B0A
262245183B1A3A5D234A55372F47471232614D422F492343
2F3A6149092D1150434648421E17256149595C416C533452
7B363C3671686BAF6C1E1670823138684521458F8F057545
6308394375297369664880522E4F8C37795B5E023F1C5923
4613617571465C7A
34FF5F464C7818592063943328896F202C23414E221F5E19
264C349547438C1F6E40647368503D725428311D23546879
29764A5E3861095C497627583348286F3622812F37364383
324A6E2E2B726B7A65263039455C3C508025624E52BD6374
917D602A61654B7E58696B2141217F565069516563749338
5627780C518B31C3
89FF10B382320723524E81088A489387262E3C2C435D6A3D
0B6B274E486371547646409A6B8E2822374B322B5C389833
319A49260D30532B751D164B2D7112475B8A727D89A0563F
252E3C262F3B1F195E194A7446263D5C522A6E265976411B
2C311361CA713A5C5D464E4E5527575A1012228420556C6D
9E5A435E164021F9
FFBB7957745761091E87087C8F63642F7510516E1B586C77
1E0C1E5F3426633B83433C4060AE39494D335A2E41465D53
766F71967F64522890453D6A4A14377A2F366B98222E2134
0C396328665C3148537129760A4819072C3A71751B0F2823
3C68481A5A8C8629466128109458A5175D1F3A552F8A0A44
C3362D1D1DD47EBC
E3DDB35ACD6A6134BB6B71556816587B683E512B5553965F
8D932D5F7363596364351A8E2C1A487208803F3644324452
3A5B8D802353C75919206027291554593031CD164E652859
0E6A52580C103D38436A4E0C623C50521255590F1F473520
14301D54603617643938613D883B9E8A5F7A586C19731626
8A49345B6F299CCB
DEDA855698485B6F4CC052AD3B6B943A4730794E3D224F51
41AC145E45388516034439A53C666C431A45001B662B182D
847E5AADAA3843364955257F479C1F4F25413F013B9C7551
1C063D5B6E4644722947945661067F2032304D6B427A2E6F
0F120C231F0B24584860A31A26461C81A271559358495C71
CE7E33AA32154CA3
577355617549506C6584670832314C316336432F204A6B4F
173970208083436549052C2141868E36C5338B3A99532904
7E192A3E44532D41555B4A214B3A6B601EA25F6B482A2369
3B302067367A3E4C6E477765383F161B3E4828BC135B452A
4EB40E106C85442C0C9D989B195B4837964B154A43425706
5948905830A2D2B6
D58F49729C4E67630F5F9981882740416A4303571ECE8545
472C406D0F1D3874505584A13046445C54A44C4A47376B54
5833535276384466342FAD526B59261621254237327D505B
1C6E44593E3B5F51960A2E3C1D5821203F42344D4D77670F
56359C24AE59A13A345B42BE12491B1CEE526051264E7912
4A3D493C89432F45
787046466B72293C5D7A8D977D3C19492A473F647E3F450F
687B712216286993688DA13B575D3B590844423C44316530
3C2C2E58262B585637083D755AAD1D3C7D827F5F3B5E4B77
4F4E0D4D4E43156B572B193C26634F3943122480397F2485
2A43B64C8F4C8660627D34644B82536AC926CE2D3E1D7756
07304D3E3D8DA944
EE8F3F7E7B8F70962DEC5C6B673D331F4016386122798550
C8314B42356B044D5A635948737A57216D3E0C5F143A722C
653D23133D5A5018871A4410555F312B42756D6B2E08365B
7C323B251E7433763F2B4A55381E56201D0E44F256605631
A07D4875374F1948815E4B8544BE8760832FDE672F0E0512
9C746F95577B59FF
C463A8E72778896C59CA83715E862121227242738F610181
0C45356539B420349C5F2F8A486B4A542A4926513407443C
856F66662C7D4281553B67629740715A1A9C2A95560B3221
9A36713C2D9622416443CA451441315C414122854329284A
6E4D1781224A373C3B682753516D22563F485BC048195A42
1A34456E7B510FC5
BB8E487445163E85708CA3328864380D3A62183A6A113C87
790A59A343A84E2B73688374681060669653A43974265D0B
403D3A4F2E196679B023444063715A3C332E439223382556
3313637A184973572D264B8018362F2F6E23561D5B1C160B
12C28A38335E3A10457D40A27246174E478C67503A30644F
545B383C21846DCC
6840617C6329932378797C6C0639152C2D2D5E35658F9F41
994224F5B26A1E50B44A557B5163287284488A5C141A5741
8408733D49555E4A70564B446F3A245310774B7E751C342A
4D145424123BB76945272938763D6B31D8725D1D4B423B1E
6A4F352E0837204641251B3B0F657C4747A772585D287452
979B7C146E9D6481
58749D55698765C287483E0C5D1C647F586D2B7D05432C09
6687823E5C511F4E665AA345483A314926234B2123615568
2A3438588E553F4D4C580E0E271D5399242DAA212C673426
2737894193593F3C728A6A6C0A4C15803116A04A4D2E1C5F
4EBF5E3B66615B121467224E6D902A97756820CFE86231A6
958916B097AD4FC8
F274B0CED7A2603B4656A88C86874EB01ED2449D260D164A
31566C532E2B5F0A81652F1438236F403D4F48454B368B30
262513127BA70E3076573F503848075B56522418655E4B39
4C3A5E8156716B2D3732866533424C25212C376B4E5C4A2F
73854D153FCD5A7844C68658E473A109374C142E6B8DA1B2
FF74A14017FFB1C7
FFC8FF93D27359CD962F6EEE1FA42101A9513A702F254579
6862826B22464D754362226821633229822898402D4B0E30
8859762D90A74D17152D42374E4836156023602E374A3362
36394166659E3A192367214BA13A1A3531365F51297D2037
70226C722367D1B66A542D7A716CB664406E190520469B6F
FF56506CCE29AC9E
FF17FF509F31D00DFF6D4E5961B05A5414696A4347AB8A54
7C931D376028748438276D279730034AA7376D096D833D54
39540D26332F4D20267C155E33445E4F3D4D625037932340
343F2B6295A432217B3541856B3F463D331A4351AB3C5957
5B7E88A75F6E49EE8F6B73D6169B6D2F66A05DA1644229FF
A467FFF5265BC3FF
FF88FFFF53B9FF489389604AAA62AF5652EE6F7D36806465
28B46466CDB15400441C5251427F4E21541C4D6743543D0A
5A9E096C59474F3C2FB836687551221C984836702A564519
384D3A3338733C3DA6A08B7C386479521C563F6F410B5B61
8B4B324887B120BAD5316C4E848B084F8F735FA95B3E5262
B985BE8E4C6C907B
FFFF31AA7F8BFF5D8E77208A3D8848C1693B45DA4F822341
7CDA9411692C5B8F24883C232A4658142952344252206E58
1E5B138E243F652817553361597D277666192A266F1A2139
2B323E30642E123086D182562718712142874131A872322B
A3925F3A621F815DCB46854142A71147723996A64A5C17AB
10A3D1F08239F6C2
FF41631C516B5AED7763C4C29F4E367C6D2CA6FF6C6F37AF
8B24663545417E502DA98642815656343B1D5E4E213D8664
3B415B3C3D21365E7B5C5A6B41513D7B77701A332B8C5A8A
3F2F992B6057451A9D7F194E6B3B67336392555BA87E2B5A
676E4723724085679F4F72D9794037672E5F566550BA575E
274B61FF6482FF71
E6ACFFA6F19ED1B33757B5831DAE8CB76F932CCB3B39398A
CD7F875722D459A6598DB2216377582A6C4D69819E2D1C30
64305B3C76168D4346996B2A2C2D346930062C27597247AB
3D386736315C634C94562A174C3FB069D758603F2F22311D
3E422E505D4F20757A7B0E235B525D731795D02C52B76A8C
2D0A8F759243FFFF
FF98FF76FF862868839D91FF984DFADE8C3A94A86552C122
A97A684560B262493259426E536DA6283315885B5615796E
2329676A45A1244D6B7F778D1F752E3B333C6860404C5CA1
2E79123F46454F80493071351B47C752E654908BAC5D2934
83642D673270116B5F441D387287407EB442B0F2C93BA85A
8A8D6ADDC84B9A93
E1FFFFE03E1B2FC568D3BEFF41D727C5622294616C54BF73
8480584149CE651BA85ED0B29722B74E1565ADB52E8FA04D
6485224A52866F0D246D325057283D582589158326874F31
1B3E8053697538493314A7282F556947274A7E6F217A0970
C2525CEB536A196D3D9B143C658C4E8E38D1F68FEA4F8B6C
AE79EE6215F3FFD6
FF6CC862FFF27A50EBD53555B77C68985242B5631D8A9E57
EEB65CA498085B494840F9576438453E265DE29342755D25
33800E3F6C2C39C998723038445A3317151450B8863C6A38
683C548852383F1B70663753591D934E3B6E826D6E2E0A75
8FA1A5C28F58695D58795AA2BA3280BAA284883F6CA16434
4BE4A80A43E8FFFF
FFFF94FFF7FFFF687E76DCFF099E0E7D35AD40707CC13583
F68066AAA2948E2B115031584D5D5AAF3F30EB9B14455553
3A311E672D5F3085674C166D31866D3790206F2E3021983D
870C578C0F4A6A76977A4E783234A5677B1863295B3D8276
6ACB7FF99D5777A2985E123781815D60FF57245BFF2F45FF
FFFFE988DBFFFFBC
FFFFFAB1FF30A8FFEEF3383F7BA52F0E8ACEDBB3DBA1169D
D07A9B5D4EB94F81676988526B5D9196997F5278904E0C18
6D121959403C51628A712A5E15566449684F612F7830700C
4F2C2F948B79407F814E38896C11C1486C792F43223063C8
519A76FF6B6D11FFBF64A543A6503B4BBA2D3275D4CEC44C
FFEBD9CBFFFFFFFF
FFFFD09CFFD6DFAC95E9D9F7C2C570354933B56393981455
E5472E6B9A4C985C5E27B813663E24A8593F277AB268222B
6A695B6D5221356B9C5E3B43285B173C394E4F454578BB24
213D4B4A854F46456F556A4C504FBC6072634A36B99C7F41
7CD98967D82EECFF4CD6A58CC4FF6126DE8A54A5FFB262FF
FFC4CCFFFFFFFF3F
FFFF97FFFFFFA2BB2D3E6591FE4771AD841FAFC076B2305A
7C6323AFCE10844F1622555113153F837B434B617A4A5575
36868325272E43491C62333B241539365C436B203429445A
794A495032186F4B766A3270074D426997272E6052686244
5F9E3BC4BBA86EA483BF325D88FF38B456AFD6E7B8FFFF61
5AFFFFFFC1FFFFFF
FFFFFFFFFFFFFFFF3DFF62E818FF4A91AE7951FF6EED9E7A
AB5CA3BA823A168723CE4F8B44327359113B489B47800A3C
A623564C5D4A251FB55E3531655D5E3D683EC934AE2132C0
A5512640872140C351833E91777A6A461D710A4A6C2C7B58
74CF349F93A24C77EEFFFF2E8361DBFFB5ECA5C81BFF2AD9
5CC1FF66FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{457, 217.563},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000790000fAP00`40o`000?l0003ooooool[oool0
0?ooooo:oooo003ooooob_ooo`00oooool[oool00?ooooo:oooo003ooooob_ooo`009Oooo`030000
oooooooo01Goool300000oooo`030000oooooooo01?oool300000_ooo`030000oooooooo01;oool2
00001?ooo`030000oooooooo01?oool00`000?ooooooo`02oooo00<0003oooooool03_ooo`D00002
oooo00<0003oooooool00_ooo`030000oooooooo00coool5000000Coool0000000000003oooo00<0
003oooooool0>Oooo`030000oooooooo01Goool300000oooo`030000oooooooo01?oool300000_oo
o`030000oooooooo01;oool200001?ooo`030000oooooooo01?oool00`000?ooooooo`02oooo00<0
003oooooool03_ooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo00coool5000000Co
ool0000000000003oooo00<0003oooooool05oooo`009?ooo`030000oooo000001Koool00`000?oo
ooooo`02oooo00<0003oool000005Oooo`060000oooooooo0000oooo00004oooo`030000oooo0000
00;oool00`000?ooo`00000Coooo00<0003oool000000_ooo`030000oooo0000017oool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000003oooo`050000oooooooooooo000000Coool0
0`000?ooo`00000ioooo00<0003oool000005_ooo`030000oooooooo00;oool00`000?ooo`00000E
oooo00H0003oooooool0003oool0000Coooo00<0003oool000000_ooo`030000oooo000001?oool0
0`000?ooo`000002oooo00<0003oool000004Oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`00000?oooo00D0003oooooooooool000001?ooo`030000oooo000001Soool002Coool0
0`000?ooo`00000Goooo00L0003oooooooooool0003oool000004oooo`@000001?ooo`000?ooo`00
01?oool00`000?ooo`000002oooo00<0003oool000004oooo`030000oooo000000;oool00`000?oo
o`00000Aoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000ooool00`000?oo
ooooo`02oooo00L0003oooooooooool0003oool00000>Oooo`030000oooo000001Ooool01`000?oo
ooooooooo`000?ooo`00000Coooo10000004oooo0000oooo00004oooo`030000oooo000000;oool0
0`000?ooo`00000Coooo00<0003oool000000_ooo`030000oooo0000017oool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000003oooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`00000Hoooo000Toooo00<0003oool000005oooo`070000oooooooooooo0000oooo0000
01?oool00`000?ooo`000002oooo00<0003oool000004oooo`800003oooo00<0003oool000005?oo
o`070000oooooooooooo0000oooo0000017oool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000003oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000ioooo00<0
003oool000005oooo`070000oooooooooooo0000oooo000001?oool00`000?ooo`000002oooo00<0
003oool000004oooo`800003oooo00<0003oool000005?ooo`070000oooooooooooo0000oooo0000
017oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000003oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Hoooo000Toooo00<0003oool000005_ooo`030000
oooo000000;oool00`000?ooo`00000Doooo0P0000;oool00`000?ooo`00000Coooo00<0003ooooo
ool00_ooo`030000oooo000001?oool00`000?ooo`000002oooo00<0003oool000004Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000?oooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000003Woool00`000?ooo`00000Foooo00<0003oool000000_ooo`030000
oooo000001Coool200000_ooo`030000oooo000001?oool00`000?ooooooo`02oooo00<0003oool0
00004oooo`030000oooo000000;oool00`000?ooo`00000Aoooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000000ooool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006?ooo`009Oooo`030000oooooooo01Koool00`000?ooooooo`02oooo00<0003oooooool05?oo
o`050000oooooooooooo000001Goool200000oooo`030000oooooooo01?oool00`000?ooooooo`02
oooo00<0003oooooool03oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo00goool2
00001?ooo`030000oooooooo00;oool00`000?ooooooo`0ioooo00<0003oooooool05_ooo`030000
oooooooo00;oool00`000?ooooooo`0Doooo00D0003oooooooooool000005Oooo`800003oooo00<0
003oooooool04oooo`030000oooooooo00;oool00`000?ooooooo`0?oooo0P0000Coool00`000?oo
ooooo`02oooo00<0003oooooool03Oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
01Ooool00?ooooo:oooo003ooooob_ooo`00oooool[oool00?ooooo:oooo000Roooo]@0002kooone
00003oooo`008_ooo`050000oooooooooooo000000Goool00`000?ooooooo`04oooo00<0003ooooo
ool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?ooo`030000
oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo00Coool0
0`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`04
oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003ooooo
ool00oooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000
oooooooo00?oool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool0
0`000?ooooooo`03oooo0P0002koool010000?ooooooo`0000Koool00`000?ooooooo`04oooo00<0
003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0003oooooool01?oo
o`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool00oooo`030000oooooooo
00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00?oool00`000?oo
ooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool00ooo
o`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo
00?oool00`000?ooooooo`04oooo0P0000ooool001goool00`000?ooooooo`02oooo00<0003ooooo
ool0/Oooo`030000oooooooo02Ooool00`000?ooooooo`02oooo00<0003oooooool0/Oooo`030000
oooooooo00goool001coool00`000?ooo`000003oooo00<0003oooooool0/Oooo`030000oooooooo
02Koool00`000?ooo`000003oooo00<0003oooooool0/Oooo`030000oooooooo00goool001coool0
0`000?ooo`000003oooo0P000;7oool20000:?ooo`030000oooo000000?oool20000/Oooo`80000?
oooo000Loooo00<0003oool000000oooo`030000oooooooo00[oool2[jn_00E>CTkooooooom6ATJU
YJD00YnOW`06oooo7QhNCdm?Cdm?Ph>3oooo0Z:RXP06@T92ooooTi>CTi>CWinOG5aL0]7Ad@05Lg=c
D51@XZ:RXZ:RJ6QX00;Jf]X01YBDU4=3@dA4A4A4A7=cLfe]K@8];Bd01YbLW:b/[6a/K6a/K::RXQ/K
6`9=CDd01GYjNZn_[di>CTi>CTQ8B002I6AT00I1@D5DE5CUiNGUiNE?CdmSHf<2oooo00HY:BV[Zj^G
UiNGUiNj^[Y_Kfl2:2PX00EMGEeSHf=1@D51@D4m?Cd00UeMG@06_;blGEeM?Cdm?Cdm@D51Hf=S0UeM
G@06:2PXKfm_^[Zj^[ZjUiNGZj^[0RTY:@06ooooHf=SCdm?Cdm?iNGUE5AD0T51@@05I6ATB4Q8B4Q8
CTi>[jn_009jNWX01Te=CA/K6j:RXZ:RXVa/K:b/[0:LW9`01Rd];Fe]KG=cLg=cLdA4A4=3@`:DU9@0
1M[JfVQXJ6QXJ::RXU1@D002Lg=c00KAdM5LG5bOWinOWinCTi?oool2@T9200JRXZ;ooon3Ph>3Ph=?
CdlN7Qh2oooo00FOWinUYJE6ATI6ATKoool00Ti>CP03[jn_oooooooo00Woool00`000?ooooooo`0V
oooo00<0003oool000000oooo`030000oooooooo00Soool2UYJF00Koooo3`l>SXj>SXj?Ph>3inOT2
oooo00K@d=3_knnb/[:b/[:;Rh_oool2LG5a00?fm_IXJ6QXJ6P00_ooo`:^[Zh01_oooe5ADMoOgmoO
gjj^[QTI6@9^KVh01IbLW::RXZ:RXXb<S;Fe]@02SXj>00HD51AXJ6R1PH61PH5IFEV`/;026QXJ00E5
ADEoOgnf][Jf][IFEUH00TA4A006Jf][EeMGOGemOGemcLg=6a/K0UADE006b<S8FUYJKFe]KFe]VYZJ
oooo0Zj^[P05?CdmH61PH61PNg]kEEEE00:PX:001QdM7E]KFadM7AdM7J2PX5EEE@9kNg/01F1PH3dm
?Cdm?Jj^[_ooo`02VYZJ00I]KFeJFU[8b<S8b<QDE5@K6a/2cLg=00EmOGeGEeM[Jf][Jf]4A4@00UIF
EP06][JfOgmoADE5ADE56QXJ/;2`0UUIF@05PH61J6QX51@D51@DSXj>00:e]KD01Xb<S::RXYbLW9bL
W6i^KQTI6@:^[Zh01MoOge5ADOooooooojj^[P03oooo00EXJ6Sfm_Kfm_IaLG7oool00X^;R`06/[:b
kno_d=3@d=3@oooonOWi0^3Ph005Xj>S`l?3ooooooooUYJF00[oool00`000?ooooooo`0=oooo000L
oooo00<0003oool000000oooo`030000oooooooo00coool01Kfm_KRh^;Rh^;Bd]8N7Q`02[jn_00Kk
no^:RXY/K6a/K6adM7Coool2k^k^00JUYJD/;2a9BDU9BDWIfMWjn_X2Vi^K00Fg]kL71`MWIfMWIfOI
fMT00]GEe@067AdMYjNWFe]KFe]K?3`lIFEU0TY:BP06Ph>3G5aL61PH61PHIfMW71`L0TE5A@05Hf=S
KVi^PX:2PX:2UiNG008U9BD01XR8R6i^K/C4a<C4a6MWId];B`:][Jd01V9RHT=3@cLg=cLg=g1`L:ZZ
ZP9ADE401D51@Hf=SFa/K6a/K8Z:RP020P8200JDU9ALG5`i>CTi>CU5ADESHf<2<30`00Hd=3@Y:BV1
PH61PH5>CTi<C4`2?Cdm00J1PH5DE5A_Kfm_KflB4Q:>SXh2<S8b00D61PIkNg]kNg]2@T:GUiL00T10
@006<S8b4Q8B@d=3@d=3R8R8Cdm?0VATI006XJ6QBTY:UIFEUIFEH61PDe=C0T92@P05PX:2e=CDe=CD
Rh^;/[:b00:EUID01UmOGjb/[2TY:BTY:HN7Qa<C4`;lo?`01UUIFMcLg3Ph>3Ph>;Vi^De=C@;oool0
1IJFUUADE;jn_[jn_UaLG002emOG1?ooo`03jNWYoooooooo00Goool00`000?ooooooo`0Voooo00<0
003oool000000oooo`030000oooooooo00Ooool01FIVI_oooooool71`EaLG002fMWI00HZ:R[ooolK
6a/K6a_8b<RUYJD2k>c/00Fe]KGooooKfm_Kfm]QHF400X>3P`06;Rh^ooooooooooook^k^MgMg0Ta<
C005XZ:RTi>CWinOWinO=3@d00;?cll01WAdM5QHF7]kNg]kNb`/;6a/K09:BTX01PX:2W5aLAdM7AdM
7DI6AVYZJP9jNWX01GMgMi6ATI6ATChn?X>3P`02DE5A00K3`l=0@40Q8B4Q8B67QhM0@4029RHV00EA
DE6UYJG0`<30`<0b<S800R4Q8@06[Zj^=3@dbLW9bLW9?ShnJ6QX0Sdm?@05GUiNGEeMIFEUIFEU<C4a
008e=CD01UiNG[Fe]AlO7alO7bDU9DY:BP9MGEd01Ta<C5IFER<S8b<S8jJVYS`l?08:2PX01H20P4M7
AdM7Ai^KVdQ8B002>c/k00HA4A5IFEUcLg=cLg<b<S94A4@2Rh^;00E?Cdo>c/k>c/hS8b>7QhL00QHF
5P06>SXjPX:2^[Zj^[ZjXj>SG5aL0Z^[Z`05NWYjWYjNkNg]kNg]KVi^00;oool01U5ADGUiNJj^[Zj^
[Y6ATDY:BP;oool01QPH6>SXj69RHV9RH_ooocdm?@goool00`000?ooooooo`0=oooo000Moooo00<0
003oooooool00_ooo`030000oooooooo00coool01Kfm_KRh^;Rh^;Bd]8N7Q`02[jn_00Kkno^:RXY/
K6a/K6adM7Coool2k^k^00JUYJD/;2a9BDU9BDWIfMWjn_X2Vi^K00Fg]kL71`MWIfMWIfOIfMT00]GE
e@067AdMYjNWFe]KFe]K?3`lIFEU0TY:BP06Ph>3G5aL61PH61PHIfMW71`L0TE5A@05Hf=SKVi^PX:2
PX:2UiNG008U9BD01XR8R6i^K/C4a<C4a6MWId];B`:][Jd01V9RHT=3@cLg=cLg=g1`L:ZZZP9ADE40
1D51@Hf=SFa/K6a/K8Z:RP020P8200JDU9ALG5`i>CTi>CU5ADESHf<2<30`00Hd=3@Y:BV1PH61PH5>
CTi<C4`2?Cdm00J1PH5DE5A_Kfm_KflB4Q:>SXh2<S8b00D61PIkNg]kNg]2@T:GUiL00T10@006<S8b
4Q8B@d=3@d=3R8R8Cdm?0VATI006XJ6QBTY:UIFEUIFEH61PDe=C0T92@P05PX:2e=CDe=CDRh^;/[:b
00:EUID01UmOGjb/[2TY:BTY:HN7Qa<C4`;lo?`01UUIFMcLg3Ph>3Ph>;Vi^De=C@;oool01IJFUUAD
E;jn_[jn_UaLG002emOG1?ooo`03jNWYoooooooo00Goool00`000?ooooooo`0Woooo00<0003ooooo
ool00_ooo`030000oooooooo00Ooool01FIVI_oooooool71`EaLG002fMWI00HZ:R[ooolK6a/K6a_8
b<RUYJD2k>c/00Fe]KGooooKfm_Kfm]QHF400X>3P`06;Rh^ooooooooooook^k^MgMg0Ta<C005XZ:R
Ti>CWinOWinO=3@d00;?cll01WAdM5QHF7]kNg]kNb`/;6a/K09:BTX01PX:2W5aLAdM7AdM7DI6AVYZ
JP9jNWX01GMgMi6ATI6ATChn?X>3P`02DE5A00K3`l=0@40Q8B4Q8B67QhM0@4029RHV00EADE6UYJG0
`<30`<0b<S800R4Q8@06[Zj^=3@dbLW9bLW9?ShnJ6QX0Sdm?@05GUiNGEeMIFEUIFEU<C4a008e=CD0
1UiNG[Fe]AlO7alO7bDU9DY:BP9MGEd01Ta<C5IFER<S8b<S8jJVYS`l?08:2PX01H20P4M7AdM7Ai^K
VdQ8B002>c/k00HA4A5IFEUcLg=cLg<b<S94A4@2Rh^;00E?Cdo>c/k>c/hS8b>7QhL00QHF5P06>SXj
PX:2^[Zj^[ZjXj>SG5aL0Z^[Z`05NWYjWYjNkNg]kNg]KVi^00;oool01U5ADGUiNJj^[Zj^[Y6ATDY:
BP;oool01QPH6>SXj69RHV9RH_ooocdm?@goool00`000?ooooooo`0=oooo000Roooo00<0003ooooo
ool01_ooo`;>c/h4oooo00=nOWiTI6ATI6@00_ooo`;Cdm<01]_Kfm7AdKjn_[jn_U9BDZZZZP97AdL0
1_ooog=cLg9bLW9bLTA4A;no_`9dM7@01IZJVVEUIINGUiNGUjf][@02/k>c00I4A4BPX:1XJ6QXJ6Q@
D51HF5P2G5aL00IMGEeFEUHi>CTi>CTb<S:EUID2GemO00Di>CUIFET@410@411lO7`00Slo?`06MWIf
Kfm_EUIFEUIFJ6QX3Ph>0Shn?P06F5QHD51@@D51@D51OGemIfMW0SDe=@05<30`;Rh^51@D51@DK6a/
008f=SH01U5ADBXZ:T51@D51@@`<31TI6@8l?3`01S<c<f=SHbDU9BDU9D51@D92@P8d=3@01RTY:B0P
87moOgmoOhZ:RSHf=P9dM7@01Di>CT];Bd];Bg1`L6YZJP02DU9B00I;Bd]^KVjATI6ATI4g=cLH61P2
8R8R00IGEeM[Jf/A4A4A4A4L71aCDe<2PX:200DB4Q;5aLG5aLG:b/Y2@T800X20P006LW9b?Shn@T92
@T92bLW9Vi^K0];BdP06[Zj^4a<CGEeMGEeMPH61NWYj0T51@@05h^;R[Jf]>CTi>CTi5ADE008o?cl0
0nGUiHV9ROooo`03oooo0[jn_PCoool00`000?ooooooo`0/oooo00<0003oooooool01Oooo`;1`L44
oooo00=JFUYQHF5QHF400_ooo`:h^;P01^OWimKFeZn_[jn_[eIFE[Bd]08h>3P01OooohR8R8R8R5eM
GC8b<P02_kno00J3Ph>TY:A^KVi^KVjXZ:Rk^k/2a<C400Dk>c^NWYjNWYiOGem4A4@00V9RHP06J6QX
DU9BH61PH61P;Rh^9bLW0YNGU`05JFUY@T92CDe=CDe=1`L7009`L7001S8b<VYZJWIfMWIfMT];Bfm_
K`8H61P01S8b<U1@D4U9BDU9BDY:BWUiN@9JFUX01DA4A2TY:BTY:C@d=20P8002Jf][00I3@d=LG5`f
=SHf=SHi>CTE5AD292@T00Dk>c/c<c<c<c=RHV8L71`00TU9B@06@d=3;Rh^9bLW9bLW9BDUPh>30XJ6
QP05=SHfMGEeEEEEEEEEBTY:009jNWX01V5QHD];Bd=3@d=3@g]kNh>3P`8o?cl01ADE5A<C4e5ADE5A
DEEEE@028R8R00HF5QI?Cdn4Q8B4Q8@@413>c/h2[jn_00HS8b=SHf=lO7alO7aJFUX`<302/[:b00Ef
MWK0`<30`<2_[jlO7al00XB4Q006[Jf]LG5aAdM7AdM7o_knTI6A0VEUI@05?Shn;Bd]^k^k^k^kXZ:R
00Coool2UiNG1?ooo`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0WMgM`03oooo
g]kNoooo00;oool00o3`l>KVi^KViP03oooo00IBDU;no_jb/[:b/[;]kNeWIfL2/[:b00Klo?aHF5R7
QhN7QhOQhN7gmoL2G5aL00J>SXk<c<a=CDe=CDgooonj^[X2@D5100Fi^KUPH61PH62LW9cMgMd00X^;
R`06FUYJP820PX:2PX:2c<c<:BTY0UQHF006KFe]MWIfHV9RHV9R^KViEeMG0TY:BP05E5ADLG5aLG5a
B4Q8KVi^009?Cdl01S/k>eIFEY>CTi>CTcDe=EQHF09ADE401Rd];C@d=;Jf][Jf]VATI3De=@93@d<0
1C8b<T51@D51@EEEEDA4A00220P800I0@40b<S8h>3Ph>3Q:BTY3@d<2SHf=00IQHF4^;Rh?3`l?3`mR
HV9XJ6P2EEEE00EdM7APH60`<30`<30U9BD00V9RHP06Zj^[Ogmo;Bd];Bd]ATI6D51@0ZJVYP0692@T
AdM7De=CDe=C2@T9WinO0Q@D5005@d=3A4A4U9BDU9BDHf=S009gMgL01WAdM3De=AhN7QhN7^WYjEiN
GP8d=3@01[fm_Lc<c8n?Shn?SgYjNT=3@`8D51@01R0P87moOo7alO7alNOWijj^[P:[Zj/01OooofAT
I6ATI=WIfL[:bP03oooo00C>c/kjn_[jn_[hn?P3oooo00<0003oooooool0;?ooo`040000oooooooo
oooo0Slo?`Goool2c<c<00K4a<CooooooooooomRHV:b/[82oooo00JUYJEDE5B:RXZ:RX[Ng]hV9RH2
HF5Q00Goooo4a<C4a<B<S8bUYJD00]KFeP06C4a<ooook>c/k>c/;Rh^f=SH0VMWI`05RHV9fMWIfMWI
O7al@D51009oOgl01YbLW;Vi^CHf=SHf=TY:BV=SH`9bLW801F1PH;bl_4m?Cdm?Ce1@D002C4a<00IZ
JVYEEEE_Kfm_Kfm5ADE6ATH2Cdm?00J5QHE:BTY;Bd];Bd/m?CdQ8B4292@T00>k^k]hN7QhN7P00TE5
A@9?Cdl01Ti>CSTi>C`l?3`l?1LG5e]KF`8X:2P01D=3@c/k>c/k>eiNGYbLW002Jf][00He=CDQ8B5B
DU9BDU9]KFeKFe/2JFUY00EZJVX[:b/R8R8R8R9XJ6P00[:b/P06NWYj9bLW?clo?cloFEUIZ:RX0R@T
9005?ShnIVIV4a<C4a<C^;Rh008W9bL01UiNGUaLG9RHV9RHV4a<C9ZJVP9[Jf/01Rh^;TM7AnGUiNGU
iEEEEA@D50:HV9P01I>CTf=SHf=SHkFe]C<c<`02BDU900He=CE`L735aLG5aLG2`/;gmoL2fMWI00GY
jNVEUIF/[:b/[:cOgml00]KFeP04ooooW9bLd=3@d=3@1?ooo`030000oooooooo00goool002;oool0
0`000?ooooooo`08oooo00GBd];Fe]Kfm_Kfm_Koool00WemO@06`L71VYZJooooooooPh>30P820TY:
BP06d];B7alOGEeMGEeM@T92RHV90TU9B@06UIFEHF5QVIVIVIVIo_kn4Q8B0XF5Q@05QhN7oooooooo
S8b<[Zj^009@D5001]gMgEeMGCHf=SHf=S<c<e9BDP8n?Sh01WYjNWQhN51@D51@D;fm_@`<309TI6@0
1H61PBd];Bd];DY:BWYjNP02RHV900Hd=3AcLg>GUiNGUiN6QXH^;Rh27alO00Hm?Cd51@F1PH61PH52
@T9WIfL27QhN00EUIFEADE5ADE5iNGU8B4P00U]KF`06GemO:2PXC4a<C4a<>CTiHf=S0WemO@06LW9b
@D51BDU9BDU9Cdm?IVIV0RDU9@05820PIFEU8b<S8b<S5QHF0096ATH01HR8R7inOUIFEUIFEX61P@03
VYZJ00JEUIERHV9`L71`L71:BTZ3Ph<2IFEU00EHF5R>SXiKFe]KFe_9bLT00V9RHP06BDU9QhN7GemO
GemOa<C4S8b<0S@d=006_;blno_kWYjNWYjNjNWYbLW90Z6QX@06;Rh^?Cdmc/k>c/k>C4a<>CTi0T];
B`05oooofMWIfMWIoooofMWI008f=SH01?ooog]kNlc<c<c<c0Coool00`000?ooooooo`0/oooo00<0
003oooooool01oooo`05bl_;fMWIfMWIjn_[oooo009<C4`01/C4a<k>c]CDe=CDe7EeMC8b<P8];Bd0
1KZj^T];Bc/k>c/k>e1@D002YZJV00I3@d>UYJETI6ATI6Bo_kooool24A4A00E]KFe[Jf_ooooooomf
MWH00YZJVP06DE5Ab<S8Hf=SHf=S<30`8R8R0T=3@`06;bl_NGUiK6a/K6a/B4Q8`L710Q4A4@05K6a/
RHV9RHV9>3PhCTi>00:1PH401WmoOd10@7UiNGUiNH^;RiBDU08_;bl01B`/;4m?C``<30`<371`L002
<30`00IhN7P_;bmQHF5QHF5?CdmXJ6P2BDU900ETI6AFEUHE5ADE5AENGUh00RXZ:P06LG5aRXZ:HV9R
HV9RDE5A?3`l0T10@006FEUI6ATI4Q8B4Q8BKFe]61PH0P`<3005CTi>T92@T92@N7QhDU9B009oOgl0
1YVIVIJFUY6ATI6ATEeMGF][J`9BDU801HR8R6UYJFUYJFMWIh61P@02Cdm?00Ji^KU>CTiMGEeMGEfK
Vi]jNWX2d=3@00FMWIdF5QJQXJ6QXJ7Kfm/00[>c/`06fm_Kc/k>RXZ:RXZ:3Ph>;bl_0ZFUY@06Ng]k
?clo>3Ph>3Phlo?ck^k^0_ooo`05Z:RX<30`<30`oooo/K6a00;jn_X4oooo00<0003oooooool03Ooo
o`008_ooo`800009oooo00GBd];Fe]Kfm_Kfm_Koool00WemO@06`L71VYZJooooooooPh>30P820TY:
BP06d];B7alOGEeMGEeM@T92RHV90TU9B@06UIFEHF5QVIVIVIVIo_kn4Q8B0XF5Q@05QhN7oooooooo
S8b<[Zj^009@D5001]gMgEeMGCHf=SHf=S<c<e9BDP8n?Sh01WYjNWQhN51@D51@D;fm_@`<309TI6@0
1H61PBd];Bd];DY:BWYjNP02RHV900Hd=3AcLg>GUiNGUiN6QXH^;Rh27alO00Hm?Cd51@F1PH61PH52
@T9WIfL27QhN00EUIFEADE5ADE5iNGU8B4P00U]KF`06GemO:2PXC4a<C4a<>CTiHf=S0WemO@06LW9b
@D51BDU9BDU9Cdm?IVIV0RDU9@05820PIFEU8b<S8b<S5QHF0096ATH01HR8R7inOUIFEUIFEX61P@03
VYZJ00JEUIERHV9`L71`L71:BTZ3Ph<2IFEU00EHF5R>SXiKFe]KFe_9bLT00V9RHP06BDU9QhN7GemO
GemOa<C4S8b<0S@d=006_;blno_kWYjNWYjNjNWYbLW90Z6QX@06;Rh^?Cdmc/k>c/k>C4a<>CTi0T];
B`05oooofMWIfMWIoooofMWI008f=SH01?ooog]kNlc<c<c<c0?oool20000;_ooo`800008oooo00G;
bl_IfMWIfMW[jn_oool00Ta<C006a<C4c/k>e=CDe=CDMGEe<S8b0Rd];@05^[ZjBd];>c/k>c/kD51@
00:VYZH01T=3@jFUYFATI6ATI;no_oooo`8A4A401Fe]KF][JoooooooogIfMP02VYZJ00IADE78b<QS
Hf=SHf<`<30R8R82@d=300H_;bmiNGU/K6a/K6a8B4S1`L424A4A00E/K6b9RHV9RHTh>3Q>CTh00X61
P@06Ogmo@410NGUiNGUiRh^;U9BD0Rl_;`05;2`/Cdm?30`<30`<L71`008`<3001WQhN2l_;f5QHF5Q
HDm?CfQXJ099BDT01FATI5IFEQDE5ADE5EiNGP02:RXZ00IaLG6:RXYRHV9RHV9ADE4l?3`2@41000II
FETI6ATB4Q8B4Q9]KFdH61P230`<00E>CTj@T92@T91hN7QBDU800WmoO`06VIVIUYJFTI6ATI6AGEeM
Jf][0U9BDP05R8R8JFUYJFUYIfMWPH61009?Cdl01[Vi^Di>CUeMGEeMGI^KVgYjNP;@d=001IfMWAHF
5Z6QXJ6QXM_Kf`02/k>c00KKfm_>c/j:RXZ:RXX>3Ph_;bl2YJFU00IkNg/o?clh>3Ph>3Sclo?^k^h2
oooo00FXZ:P`<30`<33ooona/K400_[jnP?oool200003oooo`008_ooo`030000oooooooo00;oool2
c/k>0_ooo`;IfMT00kJf]_ooooooo`04oooo00Ho?clT92Cooooooolj>SXm?Cd2PX:200Kjn_Y=CDf2
PX:2PX::RXZ1PH42;2`/00HE5AE1@D5gMgMgMgNXZ:R7QhL2IFEU00F[Zj_lo?clo?alO7cMgMd00Wal
O006Ph>3S8b<<S8b<S8bJ6QX=CDe0Vm_K`069RHVJf][MWIfMWIfXj>S<C4a0TA4A005I6ATADE5ADE5
IFEUSHf=009mOGd01U=CDdY:BRHV9RHV9X:2PV5QH@8Q8B401WmoObd];J:RXZ:RXS`l?1lO7`95ADD0
1HV9RAlO7alO7jBTY2<S8`02OWin00JMWIdl?3aDE5ADE5@Y:BTk>c/2I6AT00JHV9P_;bmbLW9bLW90
@41fMWH23Ph>00DY:BTd=3A@D51@D51:BTX00T=3@`068R8RXj>Sl_;bl_;b?ShnCTi>0[jn_P06JFUY
K6a/GEeMGEeMDU9B7AdM0Slo?`05:2PX>c/kTi>CTi>CZJVY00:>SXh01YVIVDi>CUYJFUYJF^;RhV1P
H09DE5@01^[ZjYVIVG]kNg]kNfa/K:n_[`9MGEd01Z:RXRh^;VQXJ6QXJ38b<^k^kP;jn_X014M7Agmo
OgmoOiZJVP?oool01;^k^ooooi>CTi>CT`Coool00`000?ooooooo`0/oooo00@0003oooooooooool2
_;bl0_ooo`;Kfm/00hR8R>WYjNWYj@04oooo00I5ADD_;boooooooomKFe/T92@2EeMG00CooomPH61M
GEeMGEd3PH6100Hg=cLB4Q9NGUiNGUjHV9RRXZ82MgMg00EGEeNMWIginOWinOUoOgl00/_;b`06JVYZ
MWIfPX:2PX:2?CdmFe]K0RTY:@06Hf=S61PHNg]kNg]kIfMWYJFU0S@d=005<S8bN7QhN7QhCTi>NWYj
00:GUiL01WIfMVYZJTY:BTY:BPl?3hb<S09GEeL01@`<38N7Qcdm?Cdm?IRHV0028B4Q00H`<30^;Ri_
Kfm_KflP822@T902=cLg00E]KFf6QXHa<C4a<C5]KFd00QHF5P06C4a<IfMWQHF5QHF5<30`GemO0Rd]
;@06IfMW7QhN<C4a<C4a>SXjDe=C0UEEE@05ADE551@D51@DVi^Kjn_[008`<3001Slo?jn_[eYJFUYJ
FUeMGDe=C@9HF5P01C4a<E1@D51@D14A4B/[:`02SXj>00JDU9BRXZ:ZZZZZZZYVIVJ0P802m_Kf00F3
Ph<e=CG1`L71`L5lO7`00W1`L006@410[Jf]=CDe=CDeOGem3Ph>0YjNWP062@T9oooog=cLg=cLMWIf
OWin0VQXJ0?oool01?OgmooooiBDU9BDU0Coool00`000?ooooooo`0=oooo000Roooo00<0003ooooo
ool01Oooo`05lO7aCTi>CTi>1@D5YJFU00;Hf=P01E9BDS/k>c/k>fIVIZFUY@02KVi^00I1@D68R8R7
QhN7QhNPX:2l_;`2OGem00He=CFc/k>RXZ:RXZ9IFEUmOGd3FEUI00A]KFeMGEeMGEf>SXh2alO700J/
[:bKVi^;Rh^;Rh]`L70?3`l292@T00IXJ6QfMWJ6QXJ6QXIUIFD^;Rh2@d=300FIVITW9bMTI6ATI6A@
D5000R`/;006IFEUHf=S9RHV9RHV=CDe?Cdm0TM7A`06Rh^;CDe=>SXj>SXjJFUY?clo0V5QH@05@T92
OGem_;bl_;blB4Q8008H61P01Q`L71dM7CTi>CTi>EmOGd92@P8a<C401RXZ:WQhN92@T92@T<k>cShn
?P8];Bd01WAdM4=3@`l?3`l?3g]kNc<c<`8K6a/01E=CDginOWinOTY:BY>CT`02kNg]00IDE5@c<c=<
C4a<C4a?Cdlo?cl2GEeM00I?CdoWinL];Bd];Bdc<c=@D502DE5A00DF5QJ0P820P82b/[9^KVh00YjN
WP06fMWI@410[jn_[jn_VYZJ61PH0Ta<C006YZJVEEEE?Cdm?CdmW9bLEEEE0X>3P`05`/;2IVIV>SXj
>SXj_kno00;jn_X01TY:BW=cLn7QhN7QhOoooeEEE@;Bd]801GYjN_ooooooooooo`00000^oooo00<0
003oooooool01?ooo`04j>SX@d=3@d=32PX:0ZRXZ006i>CTBd];=3@d=3@dI6ATXJ6Q0Va/K006?clo
R8R8Q8B4Q8B4XZ:R^[Zj0X20P005<S8b^[Zj^[ZjXZ:RFUYJ009iNGT01UQHF5eMGFUYJFUYJEQHF8n?
S`;2`/801JFUYJ6QXJ6QXHn?SgEeM@022PX:00H^;Ri^KVi]KFe]KFf2PX9^KVh2>c/k00E>CTjCTi<M
7AdM7AeIFET00U=CD`06=cLgIVIVL71`L71`6a/K?clo0SPh>006DU9BR8R8E5ADE5AD?3`lJ6QX0SPh
>005JVYZ?3`l?3`lQXJ6^;Rh009@D5001Q@D51DE5ALG5aLG5c<c<eYJFP94A4@01CPh>30`<30`<79b
LYRHV002bLW900Hi>CT/;2a/K6a/K6`o?cl>3Ph2P82000Dc<c<U9BEMGEeMGEeeMGD00T92@P06Ti>C
h^;RGEeMGEeM9RHV?Shn0TE5A@05>3PhI6ATEeMGEeMGnOWi0090@4001TQ8B4U9BE]KFe]KF`P829RH
V0:TY:@01UaLG;Jf]^k^k^k^kUMGEijNWP::RXX01AdM7F=SHf=SHkFe]D92@P02DU9B00JHV9QXJ6Ql
O7alO7bg]kMEEED2=CDe00GEeMG[jn]@D51@D51jNWX00_;blP05ooooHV9Rb<S8b<S8K6a/00?oool0
0`000?ooooooo`0=oooo000Roooo00D0003ooooooooooonl_;`01?ooo`98B4P01GEeMKbl_7IfMWIf
M/[:bP02?3`l00Jb/[9kNg_ooooooonXZ:Soool2/;2`00I7AdNc/k=1@D51@D6BTY:4Q8@2>SXj00HB
4Q:a/K5HF5QHF5QDE5@a<C42E5AD00E1@D7Kfm_Kfm]XJ6Q5ADD00[Fe]@06IVIV3Ph>L71`L71`9bLW
M7Ad0W]kN`06AdM78b<SB4Q8B4Q8IfMWDe=C0R`/;00592@TWinOWinO3Ph>:RXZ0093@d<01Shn?VUY
JG=cLg=cLe]KFhR8R090@4001QhN7Shn?TI6ATI6AY6ATBXZ:P9hN7P01B8R8YJFUYJFURTY:D];B`02
ATI600HW9bMNGUiJFUYJFUXW9bMaLG426QXJ00HF5QI`L72<S8b<S8aCDe=3@d<28R8R00F7QhMQHF5<
C4a<C4bQXJ400Y:BTP069bLW^;Rh];Bd];BdI6AT8B4Q0UEEE@06`L71;Bd]X:2PX:2P_[jnaLG50UMG
E`05SHf==3@dB4Q8B4Q8j>SX008l?3`01V1PH71`L5YJFUYJFUeMGD];B`:g]kL01VQXJ9JFUVe]KFe]
KGUiN@d=3@9mOGd01YfMWCdm?OgmoOgmoFa/K?ooo`:h^;P01IbLW820P820P9VIVDQ8B0028b<S00=S
Hf?Cdm?oool01Oooo`030000oooooooo02coool010000?ooooooon7Qh@;Fe]H01Ooooo?claDE5ADE
5F9RHP02k^k^00IiNGV^[Zi/K6a/K6b;Rh]?Cdl2j^[Z00J?Shofm_KAdM7AdM4h>3R>SXh2CTi>00F<
S8aUIFEUIFDl?3`D51@00Y^KV`06?CdmKFe]6ATI6ATIJVYZDe=C0^_[j`05G5aLDU9BDU9B`/;2L71`
00892@T01WYjNR4Q8Fm_Kfm_KginOTY:BP8W9bL01DM7AfUYJEEEEEEEEBl_;`02:2PX00JWYjLD51@c
<c<c<c=9BDTh>3P2MGEe00IYJFUCDe>0P820P80n?ShK6a/2<C4a00E?Cdn7QhN7QhLV9RJ3Ph<00QDE
5@06RHV99BDUF5QHF5QH?Cdm:2PX0UMGE`05D51@<S8b<S8bKFe]92@T008=3@d01Vm_KhJ6QU9BDU9B
DTY:BR8R8P:5QHD01FATI4e=CJ2PX:2PX8n?S`02;Rh^00Je]KF][JeUIFEUIFDE5AE>CTh2]kNg00DR
8R:GUiNb/[:b/[;@d=000UiNGP06Z:RX6a/KIFEUIFEUc/k>BDU90T51@@06F5QHP820Q8B4Q8B4Lg=c
_kno0UADE005K6a/HF5QHF5QU9BD8R8R009RHV801/G5aBLW9mOGemOGed51@Oooo`:n_[h01M?CdfQX
J<G5aLG5aBl_;`026a/K00<n?SkPh>3oool01Oooo`030000oooooooo00goool002;oool01@000?oo
oooooooookbl_004oooo0TQ8B005MGEe_;blMWIfMWIfb/[:008l?3`01[:b/W]kNoooooooojRXZ?oo
o`:`/;001TM7Ak>c/d51@D51@I:BTXB4Q08j>SX01Q8B4[6a/EQHF5QHF5ADE34a<@9DE5@01D51@M_K
fm_KffQXJ4E5A@02]KFe00IVIVH>3Pi`L71`L70W9bMdM7@2Ng]k00I7AdLS8b=8B4Q8B4QWIfMCDe<2
;2`/00DT92BOWinOWil>3PhZ:RX00T=3@`06?ShnJFUYLg=cLg=cFe]KR8R80T10@0067QhN?ShnATI6
ATI6TI6A:RXZ0WQhN0058R8RUYJFUYJF:BTYBd];0096ATH01RLW9eiNGUYJFUYJFRLW9g5aL@8J6QX0
1QHF5W1`L8b<S8b<S5=CDd=3@`8R8R801HN7Qf5QHDa<C4a<C:6QX@02TY:B00HW9bNh^;Rd];Bd];AT
I6@Q8B42EEEE00K1`L4];BfPX:2PX:2n_[k5aLD2EeMG00F=SHdd=3A8B4Q8B4SXj>P00S`l?006H61P
L71`FUYJFUYJGEeMBd];0[Ng]`06J6QXUYJFKFe]KFe]NGUi3@d=0WemO@06WIfM?CdmoOgmoOgmK6a/
oooo0[Rh^005W9bLP820P820VIVIB4Q8008S8b<00f=SHm?Cdoooo`05oooo00<0003oooooool0;?oo
o`040000oooooooohN7Q0]KFeP05oooolo?c5ADE5ADEHV9R00;^k^h01WUiNJj^[Va/K6a/K8^;Rdm?
C`;Zj^X01Xn?SoKfm]7AdM7AdCPh>8j>SP9>CTh01Hb<S6EUIFEUIC`l?1@D5002Vi^K00Hm?Ce]KFdI
6ATI6AUZJVYCDe<2jn_[00ELG5aBDU9BDU;2`/9`L7000PT92@06NWYj8B4QKfm_Kfm_OWinBTY:0RLW
9`05AdM7JFUYEEEEEEEE;bl_008X:2P01ZNWYa@D53<c<c<c<dU9BCPh>09eMGD01VUYJE=CDh20P820
P3hn?Q/K6`8a<C401Dm?ChN7QhN7QbHV9X>3P`025ADE00J9RHTU9BEHF5QHF5Pm?CdX:2P2EeMG00E@
D50b<S8b<S9]KFdT92@00Pd=3@06Kfm_QXJ6DU9BDU9BBTY:8R8R0XF5Q@05I6ATCDe=X:2PX:2PShn?
008^;Rh01[Fe]Jf][FEUIFEUIADE5Di>CP:g]kL01B8R8YNGUk:b/[:b/]3@d002GUiN00JXZ:PK6a]U
IFEUIFG>c/i9BDT2@D5100IHF5R0P824Q8B4Q8AcLg>o_kl2E5AD00E/K6aQHF5QHF6DU9@R8R800V9R
HP06aLG59bLWemOGemOG@D51oooo0[jn_P05dm?CJ6QXaLG5aLG5;bl_008K6a/00chn?^3Ph?ooo`05
oooo00<0003oooooool03Oooo`008_ooo`030000oooooooo00;oool2XJ6Q00IhN7QZJV[Jf][Jf]Zm
_KemOGd2VYZJ00F<S8abLW9bLW:j^[YCDe<00]OGe`06ooooYJFU;Rh^;Rh^[jn_PX:20Rl_;`06Ph>3
P820>CTi>CTi51@DCdm?0VQXJ005HF5Q410@J6QXJ6QX<30`009RHV801Rl_;f=SHh:2PX:2PS4a<BHV
9P9OGel01ZJVYXZ:RYBDU9BDU4m?Cn3Ph09FEUH01Kjn_Slo?b<S8b<S8b/[:`02K6a/00H_;bm0@41m
OGemOGe<C4`j>SX2D51@00I7AdLM7Af2PX:2PX8];BfYZJT2DE5A00EEEEDm?CeIFEUIFEU]KFd00T92
@P06=cLg=CDe<c<c<c<cMgMg820P0Xn?S`06Lg=cP820J6QXJ6QXCDe=92@T0YnOW`06@d=3JVYZHV9R
HV9R:RXZ9RHV0VIVIP05MWIf7AdM7AdMGEeMIFEU00:@T9001R8R8R/[:cPh>3Ph>;Fe]GQhN09TI6@0
1WmoOcDe=E5ADE5ADB@T94i>CP9eMGD01L[:bW]kNg]kNdA4A6UYJ@02K6a/00JCTi=0@42SXj>SXj=b
LW:0P802b<S800I`L714A4BTY:BTY:Bk^k_oool2;bl_00Fj^[[UiNFOWinOWinLW9`00V5QH@06PX:2
2PX:YZJVYZJVm?CdDe=C0]_Kf`05Xj>Soooooooooooo000002koool010000?ooooooooooo`:CTi<0
1IZJVT];BlS8b<S8b=gMg@02JVYZ00J=SHf:RXYJFUYJFUZXZ:Pk>c/2bLW900Kbl_:`/;12@T92@T:d
];AnOWh2@41000F7QhMbLW9bLW8h>3PM7Ad00TA4A006GemOJf][4A4A4A4AL71`<S8b0VMWI`05;Bd]
I6ATI6ATPh>3=3@d008Y:BT01UeMGJb/[8^;Rh^;Ri2@T5ADE0;Vi^H01E9BD/O7adM7AdM7Aa/K6`02
=CDe00IaLG4`<319BDU9BDV0P81?Cdl2ADE500I6ATHo?clB4Q8B4Q9iNGT^;Rh2XJ6Q00ELG5a<C4a<
C4a0@41PH6000VQXJ006?3`l<c<c>c/k>c/k;Rh^MGEe0QlO7`05SHf=MgMgMgMgOgmoJf][009=CDd0
1R@T9:6QXDE5ADE5AFYZJVMWI`8Y:BT01B<S8fi^KWUiNGUiNADE5@02EUIF00IKFe^8R8PE5ADE5ADc
<c<X:2P2YZJV00E]KFeCDe=^KVi^KVi2@T800UUIF@06<S8bBDU9HV9RHV9R/[:bH61P0TE5A@06J6QX
NWYjZJVYZJVY8R8R`L710U9BDP05IFEUZ:RXZ:RXU9BD>SXj00:<S8`01]kNg_[jnTe=CDe=CIRHV?oo
o`:ATI401IfMWH>3PfQXJ6QXJ2PX:002QXJ600GooomfMWKooooooonHV9P00oooo`030000oooooooo
00goool002;oool200000_ooo`05l?3`oooooooooooo=SHf00:_[jl01EEEEK6a/Bd];Bd];E1@D002
Y:BT00J7QhOAdM4_;bl_;bm4A4B^[Zh2[Jf]00HW9bMQHF54A4A4A4A3@d=CDe<29bLW00HL71b;Rh]c
Lg=cLg=RHV8d=3@2I6AT00E=CDe3@d=3@d=1@D56ATH00Rd];@066ATI<30`61PH61PH:BTYBTY:0VAT
I006EEEEeMGEIfMWIfMWZJVY>SXj0TU9B@0551@D:BTY:BTYEUIFTi>C009=CDd01V1PH5eMGBd];Bd]
;CDe=FEUI@8b<S801SXj>ZBTY4I6ATI6AW9bLUaLG08N7Qh01BTY:@H61PH61RHV9UmOG`02?Cdm00HT
92@O7alR8R8R8R9gMgN9RHT2D51@00I:BTZ2PX8M7AdM7AeWIfLf=SH2CDe=00De=CESHf<m?Cdm?CdC
4a<00SXj>P06WYjNPX:2MgMgMgMgCDe=G5aL0STi>@06GUiNPh>3DU9BDU9B92@TWinO0XF5Q@05B4Q8
][JfATI6ATI6fMWI008c<c<01VQXJ71`L7AdM7AdM;Fe]INGU`8V9RH2D51@0[no_`06<C4a[Jf]Kfm_
Kfm_Zj^[X:2P0YFEU@058b<SI6ATe=CDe=CDMWIf009;Bd/01]?Cdn3Ph;no_kno_lg=cHf=S@;oool0
0iRHV?ooooooo`020000;_ooo`8000000oooonKVi_ooo`02oooo00A3@d>BTY:BTY9eMGD2Shn?00H:
2PX];Bf<S8b<S8aZJVZg]kL2DU9B00H/;2c@d=2EUIFEUIDG5aMcLg<2GEeM00EBDU9KFe]KFe/S8b<>
3Ph00W]kN`06NWYjMGEe820P820PCdm?GEeM0U1@D005;Rh^@T92@T92?Shn7AdM008a<C401R8R8Rl_
;clo?clo?f1PH5QHF0;GemL01FUYJK2`/3lo?clo?da<C0025aLG00HZ:RYFEUJDU9BDU9A<C4aSHf<2
G5aL00Ha<C4f=SIWIfMWIfLh>3Pm?Cd2Zj^[00E7AdMbLW9bLW9IFETW9bL00R`/;0061PH6<30`JFUY
JFUY=3@d;Bd]0R`/;005:RXZJf][Jf][VIVIATI60093@d<01Xf=SAHF5WIfMWIfMS`l?5]KF`8`<300
1FATI30`<1`L71`L72d];@02WYjN00J1PH5YJFU=CDe=CDe/K6`Z:RX2F5QH00EgMgMSHf<Q8B4Q8B6b
/[800Xf=S@06FEUIYZJVFEUIFEUIe=CD8R8R0UMGE`05QhN7OgmocLg=cLg=RXZ:00<i>CT01C/k>l_;
bl_;bb`/;9>CT`02Kfm_00Jg]kN<S8b^[Zj^[ZhM7Af3Ph<2]KFe00EGEeLg=cNc/k>c/k?AdM400YjN
WP05lO7aYZJVoooooooo[:b/00;oool200003oooo`008_ooo`050000ooooooooooool?3`00?oool0
1CHf=Zn_[jn_[eEEEK6a/@02;Bd]00E@D52TY:BTY:B7QhOAdM400Rl_;`06A4A4[Zj^[Jf][Jf]9bLW
HF5Q0TA4A006@d=3De=C9bLW9bLW71`LRh^;0W=cL`05HV9R=3@dI6ATI6ATCDe=0093@d<01T51@DI6
ARd];Bd];ATI6C0`<08H61P01RTY:DY:BVATI6ATI5EEEMGEe@9WIfL01JVYZCXj>TU9BDU9BA@D5002
:BTY00IFEUJCTi==CDe=CDePH61MGEd2;Bd]00He=CEUIFDb<S8b<S8j>SZTY:@2ATI600EbLW9LG5`N
7QhN7QhY:BT00PH61P069RHVGemO?Cdm?Cdm92@T7alO0R8R8P06MgMgRHV9D51@D51@BTY:PX:20QdM
7@06IfMW=SHfCDe=CDe==CDeHf=S0Sdm?@054a<C>SXj>SXjWYjNPX:2009gMgL01Te=CEaLG3Ti>CTi
>EiNGX>3P`9BDU801R@T99nOWhF5QHF5QDQ8B;Jf]P96ATH01MWIfC<c<c<c<fQXJ71`L002M7Ad00Be
]KFGUiLV9RHV9RH2D51@0[no_`06<C4a[Jf]Kfm_Kfm_Zj^[X:2P0YFEU@058b<SI6ATe=CDe=CDMWIf
009;Bd/01]?Cdn3Ph;no_kno_lg=cHf=S@;oool01IRHV?ooooooooooo`00000^oooo00@0003ooooo
oooVi^H3oooo00A3@d>BTY:BTY9eMGD2Shn?00H:2PX];Bf<S8b<S8aZJVZg]kL2DU9B00H/;2c@d=2E
UIFEUIDG5aMcLg<2GEeM00EBDU9KFe]KFe/S8b<>3Ph00W]kN`06NWYjMGEe820P820PCdm?GEeM0U1@
D005;Rh^@T92@T92?Shn7AdM008a<C401R8R8Rl_;clo?clo?f1PH5QHF0;GemL01FUYJK2`/3lo?clo
?da<C0025aLG00HZ:RYFEUJDU9BDU9A<C4aSHf<2G5aL00Ha<C4f=SIWIfMWIfLh>3Pm?Cd2Zj^[00E7
AdMbLW9bLW9IFETW9bL00R`/;0061PH6<30`JFUYJFUY=3@d;Bd]0R`/;005:RXZJf][Jf][VIVIATI6
0093@d<01Xf=SAHF5WIfMWIfMS`l?5]KF`8`<3001FATI30`<1`L71`L72d];@02WYjN00J1PH5YJFU=
CDe=CDe/K6`Z:RX2F5QH00EgMgMSHf<Q8B4Q8B6b/[800Xf=S@06FEUIYZJVFEUIFEUIe=CD8R8R0UMG
E`05QhN7OgmocLg=cLg=RXZ:00<i>CT01C/k>l_;bl_;bb`/;9>CT`02Kfm_00Jg]kN<S8b^[Zj^[ZhM
7Af3Ph<2]KFe00EGEeLg=cNc/k>c/k?AdM400YjNWP05lO7aYZJVoooooooo[:b/00?oool00`000?oo
ooooo`0=oooo000Roooo00<0003oooooool00_ooo`9_Kfl01^o_keaLG3`l?3`l??oooe=CD`9^KVh0
1Clo?g9bLW9bLV][JmkNgP02@d=300IHF5QNGUi6ATI6ATHU9BEPH6027alO00Ha<C5YJFWCdm?Cdm=m
OGe9BDT2]KFe00EEEEFMWIeDE5ADE5AMGEd00QLG5`06FUYJOGemI6ATI6ATCdm?>3Ph0W=cL`06YJFU
G5aLBDU9BDU9VYZJJf][0SPh>005Jf][=3@dIfMWIfMWDU9B008H61P01X>3PinOWadM7AdM7Chn?U]K
F`9PH6001R<S8ibLW2<S8b<S8c<c<gemO@9>CTh01Hn?Sc8b<R@T92@T92TY:@02Lg=c00I]KFe^KVi;
Bd];Bd]KFe]?Cdl2I6AT00IYJFU<C4acLg=cLg=[Jf/^;Rh2:BTY00<d=3@h>3Q<C4`00Ta<C004@D51
IfMWIfMWRh^;0S8b<P067alOEeMGFEUIFEUI8b<S>3Ph0Rh^;P06D51@G5aLNGUiNGUi>c/kOGem0Z>S
X`05:BTYFUYJMgMgMgMg>CTi008g=cL01Sdm?EIFESDe=CDe=GIfM[Zj^P8e=CD01X>3Pfm_Kooooooo
okFe]DE5A@:5QHD01V1PH3De=C4a<C4a<H61PL71`@;Shn<01De=CI2@T92@T?ooogemO@02JFUY00DZ
:RXf=SJ4Q8B4Q8AVIVH00oooo`030000oooooooo02coool010000?ooooooooooo`9aLG401Ooooh:2
PVATI6ATI?ooo`02HF5Q00I;Bd/W9bMNGUiNGUiGEeNj^[X2D51@00IUIFEFEUIOGemOGel^;RiWIfL2
=cLg00E0@41iNGUiNGWIfMUbLW800Tm?C`06WinOIfMWQHF5QHF5@410LW9b0R<S8`05AdM7KVi^KVi^
IfMWFUYJ008[:b/01WinOZRXZ5]KFe]KFeEEEI:BTP9SHf<01C<c<fMWIc/k>c/k>f][J`02CTi>00HI
6AUoOgnMWIfMWIdJ6QY5ADD2EeMG00IPH60[:b^IVIVIVIT_;blo?cl2RXZ:00EJFUZ<S8b<S8`[:b/c
<c<00QXJ6P06L71`MgMgNg]kNg]k?CdmDE5A0T51@@05Jf][FUYJFUYJG5aLNg]k009NGUh01SHf=R4Q
8Cdm?Cdm?C`l?5]KF`91@D401C/k>fATI8J6QXJ6QSdm?@028B4Q00I>CTiNGUhM7AdM7Adk>c/d=3@3
EUIF00B1PH52@T92@T:6QXH2ZJVY00H];Be@D51nOWinOWi1@D55ADD2=CDe00IVIVHT92B;Rh^;Rh^_
[jlg=cL2Kfm_00E/K6cooooooonVYZH/;2`00Ve]K@06O7al=SHfCTi>CTi>WinO`/;20/C4a005Hf=S
MgMgkNg]kNg]FUYJ009[Jf/01E5ADA`L76=SHf=SHd51@@03oooo00<0003oooooool03Oooo`008_oo
o`030000oooooooo00;oool2XJ6Q00Kno_i>CTjIVIVIVIWoooofm_H2YJFU00Dh>3RFUYJFUYHh>3Qd
M7@00R4Q8@06OGemSXj>4a<C4a<CE5ADJVYZ0Rl_;`06VIVI7alODE5ADE5ANGUiBTY:0[bl_005LW9b
Vi^K6a/K6a/KKFe]0096ATH01WEeMHZ:R[Ng]kNg]aHF5QhN7P9hN7P01YVIVB`/;4E5ADE5AH^;RcLg
=`8[:b/01FIVIQdM7BLW9bLW9eYJFP02QhN700KBd]::RXX`<30`<30?3`lc<c<2JFUY00H/;2`m?Cd]
;Bd];BdR8R8a<C426ATI00DK6a]hN7Pa<C4a<C4U9BD00Ph>3P06K6a/NGUi<S8b<S8bPh>3Hf=S0UEE
E@06?ShnFe]K820P820P:RXZK6a/0SLg=`068R8RPh>351@D51@DHF5Q5aLG0Tm?C`05JFUY9RHV9RHV
D51@?Shn008c<c<01Tm?CbXZ:Q@D51@D55MGEdE5A@8X:2P01RHV9S/k>hJ6QXJ6QRHV9YFEU@9ADE40
1B0P85iNGUiNGPT92H>3P`02iNGU00IYJFUBDU8P820P822BTY9?Cdl2b/[:00IEEEECDe=@D51@D53B
d]8k>c/2KVi^00DR8R:XZ:Pi>CTi>CUaLG400YRHV006NGUiooooZ:RXZ:RXGUiNPh>30T10@0Coool0
0`000?ooooooo`0/oooo00@0003oooooooooool2`/;200Gfm_Hi>CV2PX:2PX;`l?000]7Ad@06Xj>S
410@Zj^[Zj^[5aLGG5aL0TY:BP06YZJVUYJF>CTi>CTiLW9bAdM70Q4A4@05YjNW@T92@T92@D51QHF5
0096ATH01/_;beeMGH61PH61PAlO7f9RHP8j>SX01EmOGi:BTY:BTZ>SXb/[:`02<S8b00IbLW:XZ:Pa
<C4a<C51@D67QhL2@T9200DQ8B5aLG4H61PH61PW9bL00UIFEP06PX:2dM7AQXJ6QXJ6<30`4Q8B0Rh^
;P06I6AT<30`?Shn?Shn<S8b:b/[0STi>@058B4Q6QXJ6QXJKfm_9RHV008Z:RX01QTI6FIVIWIfMWIf
MRLW9gemO@9IFET01F5QHC<c<c<c<eEEEALG5`02:2PX00IUIFDo?clT92@T92B>SXhC4a<2Fe]K00DN
7QiHF5Q^KVi^KVhP82000U9BDP06@T92=3@dDU9BDU9B:BTY51@D0UQHF005ATI6:RXZ8b<S8b<S?3`l
00:8R8P01R@T98n?Se]KFe]KFb`/;6UYJ@8A4A401YBDU=[JfWalO7alO451@B<S8`:2PX801Dm?Cm[J
f][JfTE5AC/k>`02JFUY00K1`L58B4R8R8R8R8Pm?Cf:RXX2820P00EgMgN>SXiMGEeMGEgoool00X^;
R`04OgmoZZZZ<C4a<C4a1?ooo`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0W]k
N`06IVIVTI6A@D51@D51/K6ahN7Q0ZVYZ@05[jn_OGemOGemBDU9<S8b009ZJVX01XR8R492@WUiNGUi
NFe]KC/k>`8W9bL01WMgMfUYJC`l?3`l?6m_KaLG5`:l_;`01L71`CHf=Z:RXZ:RXYJFUP02FEUI00H_
;bmHF5RDU9BDU9AYJFU@D5023Ph>00I5ADE/K6a1@D51@D5FEUHL71`2Cdm?00EhN7QRHV8i>CTi>CUj
NWX00XN7Q`06VIVIX:2P=3@d=3@d<c<cLG5a0Rl_;`06?Cdm=SHfAdM7AdM7?Shn4a<C0T=3@`05EEEE
<C4aOGemOGem>3Ph009<C4`01ZJVYR4Q8C0`<30`<4E5AHB4Q09JFUX01S`l?<G5aCLg=cLg=dY:BUEE
E@==CDd01FIVIQ8B4Q8B4YJFUUaLG0021@D500Dg=cMIFEUIFEU8B4QVIVH00Ta<C0067alODe=C8B4Q
8B4QBTY:OWin0S/k>`06EeMGCTi>9BDU9BDUCdm?30`<0UmOG`05Zj^[cLg=cLg=De=CLW9b00:c/k<0
1Q<C4eQHF5IFEUIFEYNGUbd];@9jNWX01UiNG_gmoEQHF5QHF7AdM9nOW`9oOgl01HZ:RVe]KGQhN7Qh
N6QXJ002[Zj^00ETI6Coooo@d=3@d=1SHf<00oooo`05N7Qhoooooooooooo000002koool010000?oo
ooooooooo`9kNg/01I2@T6a/K4a<C4a<C8j>SP02_[jn00J5QHFi^KURHV9RHV9BDU8n?Sh2Fe]K00JY
ZJUOGemcLg=cLg>?Shm?Cdl220P800F;Rh^4Q8B4Q8A>CTi/K6`00S4a<@06eMGE^[Zj820P820P/K6a
QhN70TQ8B005<S8bBd];Bd];Rh^;HF5Q009KFe/01P/;2d51@Fm_Kfm_Kclo?eIFEP8L71`01E9BDWUi
NFATI6ATI3Ph>002O7al00J;Rh^PX:2VYZJVYZHm?Cdl?3`2Lg=c00Hh>3Pc<c<j>SXj>SY=CDdh>3P2
6ATI00E5ADEFEUIFEUHZ:RY`L7000SHf=P06B4Q8V9RH71`L71`L8R8RDE5A0WEeM@05J6QX=SHf=SHf
^;Rh;bl_008l?3`01Tm?CdM7AeUIFEUIFFa/K0T92@:NWYh01EYJFPX:2Sdm?Cdm?EADE002@d=300IW
IfM=CDdL71`L71aDE5@Q8B42CTi>00EoOgm2@T9ADE5ADE5BDU800Q`L7006A4A40000E5ADE5AD/K6a
cLg=0VIVIP06I6AT];Bd:2PX:2PXIFEUI6AT0X20P005=SHfOGemOGemKfm_k^k^009BDU801UIFEZn_
[f9RHV9RHZZZZTY:BP9PH6001HV9RI>CTdQ8B4Q8B?ooo`02^KVi00ECDe?ooooooooooon8R8P00ooo
o`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0W]kN`06IVIVTI6A@D51@D51/K6a
hN7Q0ZVYZ@05[jn_OGemOGemBDU9<S8b009ZJVX01XR8R492@WUiNGUiNFe]KC/k>`8W9bL01WMgMfUY
JC`l?3`l?6m_KaLG5`:l_;`01L71`CHf=Z:RXZ:RXYJFUP02FEUI00H_;bmHF5RDU9BDU9AYJFU@D502
3Ph>00I5ADE/K6a1@D51@D5FEUHL71`2Cdm?00EhN7QRHV8i>CTi>CUjNWX00XN7Q`06VIVIX:2P=3@d
=3@d<c<cLG5a0Rl_;`06?Cdm=SHfAdM7AdM7?Shn4a<C0T=3@`05EEEE<C4aOGemOGem>3Ph009<C4`0
1ZJVYR4Q8C0`<30`<4E5AHB4Q09JFUX01S`l?<G5aCLg=cLg=dY:BUEEE@==CDd01FIVIQ8B4Q8B4YJF
UUaLG0021@D500Dg=cMIFEUIFEU8B4QVIVH00Ta<C0067alODe=C8B4Q8B4QBTY:OWin0S/k>`06EeMG
CTi>9BDU9BDUCdm?30`<0UmOG`05Zj^[cLg=cLg=De=CLW9b00:c/k<01Q<C4eQHF5IFEUIFEYNGUbd]
;@9jNWX01UiNG_gmoEQHF5QHF7AdM9nOW`9oOgl01HZ:RVe]KGQhN7QhN6QXJ002[Zj^00ETI6Coooo@
d=3@d=1SHf<00oooo`05N7Qhoooooooooooo000002koool010000?ooooooooooo`9kNg/01I2@T6a/
K4a<C4a<C8j>SP02_[jn00J5QHFi^KURHV9RHV9BDU8n?Sh2Fe]K00JYZJUOGemcLg=cLg>?Shm?Cdl2
20P800F;Rh^4Q8B4Q8A>CTi/K6`00S4a<@06eMGE^[Zj820P820P/K6aQhN70TQ8B005<S8bBd];Bd];
Rh^;HF5Q009KFe/01P/;2d51@Fm_Kfm_Kclo?eIFEP8L71`01E9BDWUiNFATI6ATI3Ph>002O7al00J;
Rh^PX:2VYZJVYZHm?Cdl?3`2Lg=c00Hh>3Pc<c<j>SXj>SY=CDdh>3P26ATI00E5ADEFEUIFEUHZ:RY`
L7000SHf=P06B4Q8V9RH71`L71`L8R8RDE5A0WEeM@05J6QX=SHf=SHf^;Rh;bl_008l?3`01Tm?CdM7
AeUIFEUIFFa/K0T92@:NWYh01EYJFPX:2Sdm?Cdm?EADE002@d=300IWIfM=CDdL71`L71aDE5@Q8B42
CTi>00EoOgm2@T9ADE5ADE5BDU800Q`L7006A4A40000E5ADE5AD/K6acLg=0VIVIP06I6AT];Bd:2PX
:2PXIFEUI6AT0X20P005=SHfOGemOGemKfm_k^k^009BDU801UIFEZn_[f9RHV9RHZZZZTY:BP9PH600
1HV9RI>CTdQ8B4Q8B?ooo`02^KVi00ECDe?ooooooooooon8R8P00oooo`030000oooooooo00goool0
02;oool00`000?ooooooo`04oooo00Jm_Ke<C4`M7AdM7AgTi>Coool2KFe]00F`/;3ooooooolP821>
CTh00VUYJ@06U9BDHF5QXZ:RXZ:RH61P;bl_0VUYJ@06Ti>C4Q8BfMWIfMWIIfMWH61P0YNGU`05m_Kf
BDU9LW9bLW9bJ6QX00:MWId01X:2PWUiNFIVIVIVITY:BU=CD`99BDT01YbLW5aLG51@D51@D1`L72HV
9P9;Bd/01E1@D34a<E]KFe]KFgAdM002AdM700Ha<C5^KVhL71`L71`W9bNCTi<2TY:B00IKFe/Z:RY:
BTY:BTX`<31>CTh2<C4a00F5QHE1@D5=CDe=CDeSHf<00UUIF@06@410BTY:Fe]KFe]K>SXj>CTi0UMG
E`066ATIPh>3:b/[:b/[9bLWDE5A0RTY:@06=SHf:BTY3`l?3`l?D51@>c/k0UEEE@05?3`lPX:2PX:2
KFe]20P8009[Jf/01S@d=::RXTE5ADE5A@D51CDe=@:EUID01RLW9fEUIAlO7alO7cdm?HB4Q09jNWX0
1AlO7fQXJ6QXJ30`<1@D5002W9bL00I^KViGEeMkNg]kNg^h^;Q0@402>3Ph00IbLW9eMGDE5ADE5AEQ
HF5IFET2WinO00E]KFe?Cdm?Cdm?CdmQHF400_ooo`061`L7f=SH820P820P[Jf]Fe]K0_ooo`056a/K
oooooooooooo000002koool00`000?ooooooo`03oooo00G3`l=KFe/V9RHV9RKemOD00_ooo`06IfMW
Y:BToooooooo:BTY@T920VATI006XJ6QGEeMX:2PX:2PIVIV;bl_0Ve]K@05Vi^K5QHF5QHFe]KFLg=c
009[Jf/01Xn?Snk^kTU9BDU9BFi^KUmOG`:WYjL01HR8R7inOWinOU]KFeMGE`02FEUI00Hl?3b[Zj]A
DE5ADE53@d<J6QX2<c<c00Dm?Ce6ATHo?clo?cm[Jf/00XF5Q@06@D51=CDeNg]kNg]k8B4Q<S8b0ZBT
Y006UIFEHV9R:b/[:b/[?clo=3@d0T10@0058b<STi>CTi>C=cLgD51@009RHV801Te=CCdm?Dm?Cdm?
CeiNGTA4A08c<c<01EiNGQDE5ADE5GalO2HV9P02820P00I=CDd_;blc<c<c<c<V9RH=3@d2E5AD00Di
>CUDE5@m?Cdm?Cf3Ph<00Ve]K@062@T9KFe]=cLg=cLgYjNWBTY:0P<30`05<30`UiNG9bLW9bLWKFe]
008W9bL01SPh>8B4Q7AdM7AdM2PX:61PH08g=cL01QdM7I>CTgalO7alO5ADE8Z:RP:[Zj/01DM7Ad=3
@d=3@fYZJVUYJ@0251@D00IDE5AJFUZ`/;2`/;1QHF5IFET2CTi>00E]KFgoool=3@d=3@g@d=000S4a
<@05WinOD51@oooooooo5aLG00?oool00`000?ooooooo`0=oooo000Roooo0P0000?oool2Z:RX00Je
]KDI6AWCdm?Cdm=iNGTo?cl2DE5A00Gooom^KVi^KVjCTi=HF5P00R/[:`063Ph>6ATIKfm_Kfm_>SXj
IVIV0Zj^[P06OgmoNg]kR8R8R8R8>SXjADE50WQhN005`<30i^KVIVIVIVIV>CTi009NGUh01VQXJ30`
<8F5QHF5QD=3@a0@409lO7`01Q@D55MGEg1`L71`L410@38b<P9:BTX01@L71bPX:8n?Shn?ScXj>P02
<C4a00IgMgLB4Q8<30`<30a8B4RBTY82GUiN00IIFEU=CDdm?Cdm?Ce0@41/K6`2>c/k00E0@40f=SHe
=CDe=CEGEeL00RXZ:P06FEUI51@D=SHf=SHf@d=3CDe=0S@d=006@D51;Rh^5ADE5ADE5aLGC4a<0ZJV
YP06SHf=;bl_LW9bLW9bG5aLQXJ60Rd];@053`l?ATI6ATI69bLWADE500:JVYX01RHV9X61PB8R8R8R
8R/[:f9RHP8O7al01VUYJB8R8V5QHF5QHC/k>g]kN`9=CDd01Chn?RLW9bLW9f9RHWalO002FUYJ00I^
KViaLG57AdM7AdLT92@d=3@2JVYZ00Hd=3AFEUJSXj>SXj<820PX:2P2ZZZZ00DV9RK/k>adM7AdM7@g
=cL00Xb<S006`/;2GEeMLG5aLG5aa/K6QXJ60_ooo`03a/K6oooooooo0080000^oooo0P0000;oool2
WYjN00F/[:`Y:BW>c/k>c/i/K6`00U1@D006EUIFooooKfm_Kfm_Vi^KATI60R0P80061@D56ATIKVi^
KVi^@410I6AT0[Jf]P05K6a/LG5aLG5aNWYj;Bd]009DE5@01VYZJ[Jf]]7AdM7AdFMWIb<S8`9bLW80
1Fa/K28R8R8R8W1`L3Lg=`02820P00ImOGdY:BUADE5ADE5OGelf=SH2<C4a00De=CDJ6QXj>SXj>SZQ
XJ400T];B`068B4QIfMW8b<S8b<S6ATI>SXj0YjNWP06IFEUIVIV@D51@D51>CTi=SHf0V9RHP05<c<c
BTY:BTY:=cLg;Rh^009PH6001R<S8f1PH1DE5ADE5CHf=TQ8B09>CTh01CLg=d92@T92@Rd];ADE5@02
5aLG00I=CDfWYjN@T92@T90];BefMWH2FEUI00F8R8P`<30>3Ph>3Pi;Bd/00Rd];@06@410V9RH:2PX
:2PXPX:2:BTY0S8b<P05Hf=S8B4QJ6QXJ6QX8R8R009RHV801T=3@gEeMDe=CDe=CDI6AR8R8P9[Jf/0
1X:2PV9RHVQXJ6QXJ7UiNDE5A@8U9BD01Bl_;g1`L71`L3Xj>U5AD@02ZJVY00H10@4Q8B6TY:BTY:@O
7ao^k^h2KVi^00D_;bnFUYK=cLg=cLeIFET00W=cL`05d];BTi>Coooooooob<S800;oool200003ooo
o`008_ooo`050000oooooooooooomOGe00;AdM401Z>SXooooa4A4A4A4DI6AY>CT`9cLg<01OooojNW
YjNWYjJVYX20P002MgMg00HP820L71a5ADE5ADDb<S8;2`/2YJFU00IhN7SWinM<C4a<C4bATI6i^KT2
>SXj00F1PH5SHf?8b<S8b<Pi>CT00QlO7`06@D51Shn?NWYjNWYj>3PhAdM70UeMG@06EeMGIFEU>c/k
>c/k=3@d61PH0Rd];@05A4A4@D51:b/[:b/[GEeM00::RXX01R`/;3`l?2TY:BTY:Fm_Kfe]K@9BDU80
1X20P5eMGCTi>CTi>Da<C3Xj>P99BDT01EiNGVEUIAPH61PH62DU9@02De=C00IEEEEHF5P820P820Q9
BDTj>SX2DU9B00Hl?3aJFUYbLW9bLW8a<C4:2PX2ZJVY00IiNGTE5ADH61PH61PP820[:b/2:BTY00B?
Shl`<30`<31@D503Bd];00ICDe=3@d<i>CTi>CUWIfLK6a/2;bl_00HE5AD];BeYJFUYJFUhN7P@4102
GemO0bXZ:P06Cdm?K6a/CTi>CTi>>CTi@D510QLG5`065ADE:b/[Ti>CTi>C?CdmdM7A0RDU9@06YjNW
EeMGShn?Shn?Ph>3U9BD0Zb/[005FEUIADE5ADE5<c<cH61P00:ZZZX01M7AdL30`;Vi^KVi^G=cL`03
oooo00<0003oooooool0;?ooo`040000ooooooool_;b0/O7a`05/K6aoooo5aLG5aLG@41000:QXJ40
1WAdM?oook:b/[:b/Z6QXHf=S@9[Jf/01Rh^;Q@D54a<C4a<C3Lg=`T92@:QXJ401G=cLnCTi>CTi5QH
F8J6QP02a/K600I4A4AhN7QJFUYJFU[=cLdo?cl25ADE00E=CDf5QHF5QHEcLg<_;bl00TY:BP06G5aL
CTi>Jf][Jf][=cLg;2`/0R4Q8@059BDUC4a<@T92@T92<c<c009UIFD01XJ6QS8b<SLg=cLg=bd];F][
J`9aLG401UIFEX61PEiNGUiNGSXj>Ta<C08i>CT01D];BeiNGUiNGVEUIAPH600292@T00IBDU9FEUIK
Fe]KFe/71`M8B4P2>3Ph00E@D50o?clo?cmGEeMfMWH00S0`<0063Ph>YjNWNg]kNg]k4Q8B4a<C0RDU
9@059RHV<30`Rh^;Rh^;=SHf009;Bd/01TE5ADQ8B4m?Cdm?Ccdm?D10@09_Kfl01B<S8cPh>1@D51@D
52l_;`02IFEU00J1PH4:2PYOGemOGel[:b/^;Rh2De=C00I/K6aFEUHa<C4a<C5:BTXF5QH23@d=00DV
9RJMWIfMWIe4A4CBd]800QhN7P06/;2`CTi>QhN7QhN7QXJ6S8b<0ZRXZ005EUIFATI6>c/k>c/kH61P
00:RXZ801MOGelk>c[2`/;2`/7AdM003oooo00<0003oooooool03Oooo`008_ooo`050000oooooooo
oooomOGe00;AdM401Z>SXooooa4A4A4A4DI6AY>CT`9cLg<01OooojNWYjNWYjJVYX20P002MgMg00HP
820L71a5ADE5ADDb<S8;2`/2YJFU00IhN7SWinM<C4a<C4bATI6i^KT2>SXj00F1PH5SHf?8b<S8b<Pi
>CT00QlO7`06@D51Shn?NWYjNWYj>3PhAdM70UeMG@06EeMGIFEU>c/k>c/k=3@d61PH0Rd];@05A4A4
@D51:b/[:b/[GEeM00::RXX01R`/;3`l?2TY:BTY:Fm_Kfe]K@9BDU801X20P5eMGCTi>CTi>Da<C3Xj
>P99BDT01EiNGVEUIAPH61PH62DU9@02De=C00IEEEEHF5P820P820Q9BDTj>SX2DU9B00Hl?3aJFUYb
LW9bLW8a<C4:2PX2ZJVY00IiNGTE5ADH61PH61PP820[:b/2:BTY00B?Shl`<30`<31@D503Bd];00IC
De=3@d<i>CTi>CUWIfLK6a/2;bl_00HE5AD];BeYJFUYJFUhN7P@4102GemO0bXZ:P06Cdm?K6a/CTi>
CTi>>CTi@D510QLG5`065ADE:b/[Ti>CTi>C?CdmdM7A0RDU9@06YjNWEeMGShn?Shn?Ph>3U9BD0Zb/
[005FEUIADE5ADE5<c<cH61P00:ZZZX01M7AdL30`;Vi^KVi^G=cL`03oooo00<0003oooooool0;?oo
o`040000ooooooool_;b0/O7a`05/K6aoooo5aLG5aLG@41000:QXJ401WAdM?oook:b/[:b/Z6QXHf=
S@9[Jf/01Rh^;Q@D54a<C4a<C3Lg=`T92@:QXJ401G=cLnCTi>CTi5QHF8J6QP02a/K600I4A4AhN7QJ
FUYJFU[=cLdo?cl25ADE00E=CDf5QHF5QHEcLg<_;bl00TY:BP06G5aLCTi>Jf][Jf][=cLg;2`/0R4Q
8@059BDUC4a<@T92@T92<c<c009UIFD01XJ6QS8b<SLg=cLg=bd];F][J`9aLG401UIFEX61PEiNGUiN
GSXj>Ta<C08i>CT01D];BeiNGUiNGVEUIAPH600292@T00IBDU9FEUIKFe]KFe/71`M8B4P2>3Ph00E@
D50o?clo?cmGEeMfMWH00S0`<0063Ph>YjNWNg]kNg]k4Q8B4a<C0RDU9@059RHV<30`Rh^;Rh^;=SHf
009;Bd/01TE5ADQ8B4m?Cdm?Ccdm?D10@09_Kfl01B<S8cPh>1@D51@D52l_;`02IFEU00J1PH4:2PYO
GemOGel[:b/^;Rh2De=C00I/K6aFEUHa<C4a<C5:BTXF5QH23@d=00DV9RJMWIfMWIe4A4CBd]800QhN
7P06/;2`CTi>QhN7QhN7QXJ6S8b<0ZRXZ005EUIFATI6>c/k>c/kH61P00:RXZ801MOGelk>c[2`/;2`
/7AdM003oooo00<0003oooooool03Oooo`008_ooo`050000ooooooooooooG5aL00;;bl/01Tm?CjNW
Yi6ATI6ATK:b/Q<C4`::RXX01INGUjNWYjNWYc8b<V=SH`02i>CT00K=cLdQ8B5VIVIVIVIbLW:HV9P2
9RHV00JATI5`L71CDe=CDe<X:2QQHF4261PH00D?3`mMGEeFEUIFEUI]KFd00SPh>006F5QH`L71Bd];
Bd];DE5A4A4A0S`l?006?ShnFEUIZ:RXZ:RX8R8R>3Ph0XB4Q0050`<3GEeM61PH61PHLg=c009/K6`0
1WMgMh61PBXZ:RXZ:S<c<dm?C`:UYJD014];BgAdM2DU9BDU9@8Y:BT2;Rh^00ELG5`j>SXD51@D51Bj
^[X00QdM7@06;2`/QXJ6GEeMGEeM;Rh^7alO0QhN7P065QHFHF5QATI6ATI6EEEEBd];0U1@D006UIFE
F5QH@T92@T92:RXZ820P0VQXJ005FEUIJ6QXJ6QX:2PX6ATI0095ADD01RTY:B0P84Y:BTY:BS@d=3De
=@=8B4P01JJVYUADE5ADE6UYJDm?C`0292@T00E=CDePH61PH60g=cMkNg/00XV9R@06HV9R3Ph>=3@d
=3@d>SXj20P80X>3P`069RHVK6a/H61PH61PO7alJFUY0Q8B4P05F5QH1`L7=3@d=3@dB4Q800:0P800
1[bl_5]KFgemOGemOFIVITa<C0:CTi<01G1`L?ooooooooooo`00000^oooo00@0003ooooooomHF5P2
b<S800E?Cdn][JfGUiNGUiN`/;000QHF5P06RHV9UIFEYZJVYZJV<C4aHV9R0^SXj006clo?820PJ6QX
J6QXMGEeUiNG0RXZ:P05T92@KFe]KFe]CTi>8R8R009WIfL01Q@D518B4U]KFe]KFf5QHFIVIP8k>c/0
1EiNG[no_kno_di>CUmOG`0271`L00H^;Ri=CDe:BTY:BTZPX:0F5QH2<C4a00F0P80E5AE<C4a<C4`:
2PX00Va/K006JVYZRXZ:LW9bLW9b?3`l?clo0UUIF@06Ti>C@D51RHV9RHV9=cLg9bLW0RHV9P05=3@d
IfMWIfMW;2`/8B4Q00:ZZZX01Rd];B@T99VIVIVIVE=CDadM7@8W9bL33Ph>00IHF5Q<C4a=CDe=CDdo
?cmEEED2SXj>00IHF5Ph>3Pd=3@d=3@Z:RYXJ6P2EEEE00EQHF4S8b<S8b<Q8B5;Bd/00R<S8`069RHV
BDU9<C4a<C4a>SXjB4Q80TE5A@05Xj>SFUYJFUYJIVIVCTi>008O7al01U5ADEaLG3hn?Shn?X:2PXN7
Q`9VIVH01@T92B`/;4=3@d=3@`D51@02OGem00H[:b]]KFeHF5QHF5QoOgmTI6@271`L00IMGEd<30`n
?Shn?Si8B4R7QhL2`/;200EUIFF7QhN7QhMYJFUEEED00YfMW@05M7Adoooooooooooo000000ooool0
02;oool01@000?ooooooooooofQXJ002TY:B00I`L729RHUSHf=SHf<:2PYZJVX2XJ6Q00FCTi=NGUiN
GUj1PH4_;bl00U1@D006Hf=SOGemYjNWYjNWDE5AADE50XB4Q006HF5Q5ADE@d=3@d=371`L;bl_0Slo
?`05D51@:RXZ@d=3@d=330`<00<g=cL01DY:BU]KFe]KF`d=3CDe=@02?Cdm00Hg=cLa<C5KFe]KFe^5
QHGAdM427alO00EnOWhU9BF>SXj>SXi;Bd/00T=3@`06;Bd]:2PXP820P820VIVIEeMG0Q/K6`06:2PX
>c/k5QHF5QHFDU9BAdM70QXJ6P05>3PhG5aLTi>CTi>C?Cdm00:7QhL01Pl?3cdm?C@d=3@d=4e=CF5Q
H@8/;2`01U]KFf][JgUiNGUiNEADE71`L09;Bd/01UQHF4M7AgIfMWIfMQHF5WYjNP93@d<01F1PH1XJ
6QXJ6Ph>3UIFEP02QHF500I4A4AlO7agMgMgMgLY:BUMGEd2EUIF00J0P81HF5Q4A4A4A4Bk^k]CDe<2
820P00E`L72i^KVi^KWYjNTT92@00T];B`06VIVI>c/kZj^[Zj^[QhN7FEUI0SLg=`05Cdm??clo:2PX
:2PX<30`00<Z:RX01A/K6g5aLHB4Q8B4Q8b<S002I6AT00HM7AeoOgli>CTi>CU=CDe[Jf/2K6a/00Dj
>S[oooooooooool00000;_ooo`040000ooooooooJ6QX0X61P@05I6ATWIfMKVi^KVi^51@D009lO7`0
1Y^KViNGUe9BDU9BDWAdM2PX:09MGEd015QHF79bLZNWYjNWY`97AdL2O7al00EUIFD?3`l?3`lk>c/K
6a/00RDU9@06@D51ATI6820P820P=cLg20P80Rh^;P05=CDeCdm?Cdm?JVYZ7QhN008k>c/01T92@T];
BadM7AdM7EeMGG9bLP;Hf=P01C4a<F][Jcdm?Cdm?GIfMP02>3Ph00HY:BTW9bM5ADE5ADEYJFVg]kL2
>c/k00HB4Q8T92ADE5ADE5@D51A=CDd2:RXZ00Dd=3@L71`L71aeMGEnOWh00T];B`06MgMg410@De=C
De=C92@T>SXj0Vm_K`05A4A4Bd];Bd];EUIFL71`009:BTX01UiNGUEEEDU9BDU9BCdm?G=cL`8820P0
1HB4Q451@EMGEeMGEaXJ6P0251@D00ILG5b:RXY8B4Q8B4R4Q8AbLW82:2PX00ESHf=ADE5kNg]kNg]E
EED00TY:BP06];BdD51@7QhN7QhNJVYZ/[:b0_Gem@0692@T@T92VIVIVIVI@D51WinO0Xn?S`04IFEU
=CDe=CDeGUiN0bd];@06;2`/5ADE>CTi>CTi1PH6K6a/0WalO005NGUiN7Qh8b<S8b<STi>C008Y:BT0
1F=SHgalO65QHF5QHD10@003oooo00<0003oooooool03Oooo`005oooo`<00003oooo00<0003ooooo
ool00_ooo`050000ooooooooooooY:BT00:k^k/01XF5QI2@T0T92@T92B/[:b<S8`9DE5@01C`l?5mO
GemOGg9bLR`/;002CTi>00Hi>CUiNGVEUIFEUIEHF5Q5ADD292@T00I<C4aWIfNb/[:b/[8];Bf9RHT2
E5AD00DN7Qha<C5XJ6QXJ6PZ:RX00S<c<`06QXJ6_;bl3`l?3`l?5ADE30`<0RPX:006CDe=5aLGH61P
H61P8R8RJ6QX0R@T9005>c/k:2PX2PX:2PX:S8b<009GEeL01Rh^;S<c<eMGEeMGEf=SHcTi>@8N7Qh0
1VUYJG1`L24Q8B4Q8D10@5MGE`8d=3@01BPX:24Q8H>3Ph>3Pd];B`02>SXj00He=CDk>c]RHV9RHV9e
MGERHV82=SHf00A?CdlW9bNg]kNg]kL2KVi^0Pl?3`06=3@dE5AD=SHf=SHf@410ATI60Pd=3@05GEeM
9BDU9BDULG5a>c/k00:PX:001U1@D9JFUV=SHf=SHeeMGA<C4`9RHV801WMgMgemOFi^KVi^KVm_Kb@T
909DE5@01Jf][C`l?3`l?:FUYFEUI@022PX:0XF5Q@96ATH01R0P85iNGRLW9bLW9a@D555AD@8`<300
1Q/K6dE5AFQXJ6QXJ7moOd51@@:d];@01Hb<S7MgMgMgMgEeMD];B`027alO00D];BeKFe]NGUiNGUjO
Wil00oooo`030000oooooooo027oool300000oooo`030000oooooooo00;oool010000?oooooook^k
^`;<c<`01Fe]KHB4Q24Q8B4Q8C`l?002>3Ph00IKFe]DE5A?Cdm?CdmTI6@`<302>SXj00I@D51WIfN<
S8b<S8a7AdM>CTh25aLG00E6ATIbLW9bLW:RXZ90@4000WemO@06ADE5410@>SXj>SXjGUiN<c<c0SPh
>005RXZ:`/;2`/;24Q8B2`/;008F5QH01Q`L75]KFadM7AdM7EIFER<S8`9^KVh2;bl_0SHf=P0561PH
P820P820Bd];9RHV008];Bd01UMGEg=cLdU9BDU9BAPH67YjNP9SHf<01A<C4c<c<eIFEUIFERDU9@02
>3Ph00HS8b>BTY93@d=3@d<^;Rhc<c<2?3`l00EJFUYaLG5SHf=SHf=0@4000TA4A0068b<S/;2`NGUi
NGUiIVIV6ATI0Rh^;P06Cdm?>SXj?Cdm?Cdm@4102`/;0UeMG@059RHVM7AdM7Ad>CTiY:BT009CDe<0
1YJFUVIVIV1PH61PH10@46QXJ09dM7@01H>3PfQXJ6QXJ7=cLb/[:`02CTi>00JXZ:Q3@d>SXj>SXj=I
FET:2PX2NGUi00F7QhLl?3`A4A4A4A5ZJVX00SXj>P0661PHHV9R>SXj>SXj3@d=>3Ph0VATI006R8R8
<S8bXj>SXj>SS8b<L71`0XF5Q@05?Shn5QHF5QHFADE5M7Ad0098B4P01Hj>S_ooooooooooo`00000?
oooo000Goooo00<0003oooooool00_ooo`030000oooo000000?oool01@000?ooooooooooojBTY002
^k^k00J5QHF@T9092@T92@T[:b/S8b<2E5AD00Dl?3aOGemOGembLW8/;2`00Ti>CP06>CTiNGUiUIFE
UIFEF5QHADE50R@T9006C4a<IfMW/[:b/[:b;Bd]RHV90UADE0057QhN<C4aJ6QXJ6QX:RXZ008c<c<0
1XJ6Q[bl_0l?3`l?3aDE5@`<308X:2P01Te=CALG5f1PH61PH28R8VQXJ08T92@01C/k>bPX:0X:2PX:
2Xb<S002EeMG00H^;Rhc<c=GEeMGEeMSHf<i>CT27QhN00IYJFU`L70Q8B4Q8B50@41GEeL2=3@d00DX
:2PQ8B63Ph>3Ph=;Bd/00SXj>P06=CDe>c/kHV9RHV9RMGEeHV9R0SHf=P04Cdm?9bLW]kNg]kNg0Vi^
KP8?3`l01S@d=5ADE3Hf=SHf=T10@4I6AP8=3@d01EeMGBDU9BDU9G5aLC/k>`02X:2P00I@D52FUYIS
Hf=SHf=MGEdC4a<2HV9R00IgMgMmOGe^KVi^KVi_KflT92@2E5AD00F][Jdl?3`l?3bUYJEUIFD00PX:
2P:5QHD2ATI600HP821NGUhW9bLW9bLD51AADE42<30`00HK6a]5ADEXJ6QXJ6QoOgm1@D42];Bd00F<
S8agMgMgMgMeMGE;Bd/00QlO7`05;Bd]Fe]KGUiNGUiNWinO00?oool00`000?ooooooo`0Qoooo00<0
003oooooool00_ooo`030000oooo000000?oool010000?oooooook^k^`;<c<`01Fe]KHB4Q24Q8B4Q
8C`l?002>3Ph00IKFe]DE5A?Cdm?CdmTI6@`<302>SXj00I@D51WIfN<S8b<S8a7AdM>CTh25aLG00E6
ATIbLW9bLW:RXZ90@4000WemO@06ADE5410@>SXj>SXjGUiN<c<c0SPh>005RXZ:`/;2`/;24Q8B2`/;
008F5QH01Q`L75]KFadM7AdM7EIFER<S8`9^KVh2;bl_0SHf=P0561PHP820P820Bd];9RHV008];Bd0
1UMGEg=cLdU9BDU9BAPH67YjNP9SHf<01A<C4c<c<eIFEUIFERDU9@02>3Ph00HS8b>BTY93@d=3@d<^
;Rhc<c<2?3`l00EJFUYaLG5SHf=SHf=0@4000TA4A0068b<S/;2`NGUiNGUiIVIV6ATI0Rh^;P06Cdm?
>SXj?Cdm?Cdm@4102`/;0UeMG@059RHVM7AdM7Ad>CTiY:BT009CDe<01YJFUVIVIV1PH61PH10@46QX
J09dM7@01H>3PfQXJ6QXJ7=cLb/[:`02CTi>00JXZ:Q3@d>SXj>SXj=IFET:2PX2NGUi00F7QhLl?3`A
4A4A4A5ZJVX00SXj>P0661PHHV9R>SXj>SXj3@d=>3Ph0VATI006R8R8<S8bXj>SXj>SS8b<L71`0XF5
Q@05?Shn5QHF5QHFADE5M7Ad0098B4P01Hj>S_ooooooooooo`00000?oooo000Hoooo00L0003ooooo
ooooool0003oool000000oooo`800002oooo00Fo_knd];Bd];@M7AeHF5P00WUiN@05HV9RBDU9;Rh^
;Rh^5aLG008g=cL01V5QHA8B4U1@D51@D;Bd]5QHF09?Cdl01SLg=eADE1/K6a/K6fm_Ke9BDP9GEeL0
1R`/;6MWIcdm?Cdm?CPh>3@d=098B4P01B4Q8GmoOgmoOaDE5Da<C002KFe]00I9BDTW9bLX:2PX:2Q3
@d>5QHD27alO00Hn?Si3@d=HF5QHF5Pc<c=2@T8261PH00E6ATK4a<C4a<A3@d=OGel00TA4A0069RHV
VIVI;bl_;bl_?3`lKfm_0S4a<@06Ti>C820P=3@d=3@d3Ph>EEEE0YVIV@0592@TVYZJVYZJ7alOEEEE
009cLg<01S/k>i2@T6IVIVIVIV1PH3De=@9DE5@01XJ6QT10@7YjNWYjNS4a<F5QH@9[Jf/01FIVIW]k
Ncdm?Cdm?DA4A0021@D500Hn?Si8B4P^;Rh^;Ri;Bd//;2`2AdM700IFEUIMGEe>CTi>CTjDU9@j>SX2
J6QX00FGUiLa<C4Z:RXZ:RZ`/;000S8b<P06LG5a@d=3DE5ADE5A4A4ANWYj0Q8B4P06LG5aPh>3MWIf
MWIfDU9BHV9R0S<c<`8a<C42SHf=00EYJFUaLG6BTY:BTY;8b<P00TQ8B006M7AdUIFEK6a/K6a/<c<c
fm_K0ZNWY`03L71`oooooooo0080000Toooo00L0003oooooooooool0003oool000000oooo`800000
1_ooolC4a<G5aLG5a@l?3e5AD@9kNg/01Fi^KTE5ADE5AC@d=1XJ6P02@T9200IJFUXI6AU8B4Q8B4S0
`<1KFe/2B4Q800Do?cmFEUHR8R8R8R9]KFd00U5AD@06De=C9bLWJ6QXJ6QX>c/k?3`l0SLg=`05BTY:
8R8RPH61PH615aLG009=CDd01Vi^KTY:BRPX:2PX:2TY:D=3@`:5QHD01R8R8T51@D51@D51@EaLG34a
<@91@D401A@D54E5ADE5AL[:bT=3@`02I6AT00I1@D4R8R:FUYJFUYH];Bdl?3`2LG5a00Df=SJJVYXQ
8B4Q8B4b<S800P/;2`06EUIFUIFE:RXZ:RXZW9bL6QXJ0UYJFP05LG5a@410UiNGUiNGHV9R009WIfL0
1S/k>eEEEH61PH61PD92@WemO@8/;2`2IVIV0Vm_K`05QHF5?3`lA4A4A4A41`L7008d=3@01U5ADBHV
9TU9BDU9BBXZ:UADE09:BTX01F][JdQ8B8Z:RXZ:RRl_;`02GemO00JLW9`d=3@P820P822d];@i>CT2
IFEU00He=CE5ADD<30`<30b1PH410@42HF5Q00F?ShmcLg=cLg=2@T9bLW800R8R8P8Q8B42QXJ600IN
GUiaLG63Ph>3Ph?:b/YIFET2K6a/00F9RHUhN7QhN7PW9bOWinL00ZRXZ003Hf=Soooooooo0080000?
oooo000Hoooo00L0003oooooooooool0003oool000000oooo`050000ooooooooooook^k^00;oool0
1UIFEW9bLTa<C4a<C96ATFUYJ@:0P8001I2@T0D51@D51A<C4aHF5P02:b/[00IcLg?Vi^Hk>c/k>c]j
NWYVIVH2N7Qh00J][Jde=CEdM7AdM7ACDe=>CTh2SXj>00EFEUHU9BEKFe]KFe]5ADD00W5aL@06>CTi
RXZ:Ti>CTi>C9BDUC4a<0VYZJP06BTY:nOWi@d=3@d=34Q8B61PH0RHV9P05C4a<92@T?3`l?3`lE5AD
0091@D401RPX:3Xj>Ve]KFe]KCTi>G5aL@8I6AT01Rl_;dA4A2PX:2PX:75aLFATI090@4001@l?3b@T
975aLG5aLFYZJP02MgMg00Hf=SHa<C4h>3Ph>3QVIVI>CTh251@D00Hl?3`?3`n6QXJ6QXHR8R9IFET2
G5aL00Hc<c<N7QhZ:RXZ:RX_;bmGEeL29BDU00E]KFd/;2`/;2`F5QINGUh00P410@06<c<cJFUY;2`/
;2`/HF5QLG5a0WemO@06DE5AHf=SIVIVIVIVHF5QEEEE0PH61P05IfMW;bl_;bl_AdM7D51@008h>3P0
1[jn_UIFEWmoOgmoOginOQ`L709UIFD01Sdm?A<C4dA4A4A4A1hN7S4a<@8o?cl01Fa/K6m_KemOGemO
Gn?Sh`02<S8b00JKVi]fMWJ6QXJ6QXJ2PX:4Q8@2?Cdm00F<S8coooooooooool000009?ooo`070000
oooooooooooo0000oooo000000?oool010000?ooooooonk^kP;oool01EUIFG]kNeMGEeMGEiFEU@02
Kfm_00IdM7BLW9`B4Q8B4Q851@D>3Ph2;bl_00IWIfONg]h_;bl_;bn3Ph=PH602QhN700Fn_[i4A4A4
A4B5QHE;Bd/00UiNGP06PH61B4Q86ATI6ATICdm?=cLg0WEeM@05B4Q8OGemOGemX:2P<C4a009FEUH0
1V1PH5IFE_;bl_;blTA4A0h>3P8M7Ad01B0P85IFEQhN7QhN7SPh>002EEEE00I:BTX[:b/o?clo?cmf
MWHc<c<2M7Ad00HN7QhU9BDk>c/k>c/b<S9lO7`2Fe]K00Df=SH820P820P^;Ri[Jf/00Ve]K@06MGEe
@T92:b/[:b/[<C4aGemO0UEEE@05410@A4A4A4A46QXJQhN7008H61P01U1@D5YJFSdm?Cdm?A<C4b<S
8`8m?Cd01FEUIB`/;79bLW9bLSXj>P0251@D00IOGel<30`n?Shn?Si]KFdQ8B42EeMG00EjNWYcLg=8
B4Q8B4QIFET00V=SH`06FUYJCDe=10@410@4Jf][=CDe0T92@P06Bd];<C4ab<S8b<S8D51@QHF50WUi
N@058R8RHF5QHF5Q>3Ph5QHF0090@4001QlO7c<c<cdm?Cdm?FMWIf][J`9LG5`01Nc/k2d];IJFUYJF
UW1`L002Shn?00EkNg]nOWho?clo?cn?Shl00oooo`030000oooooooo00goool001Ooool00`000?oo
o`000002oooo00<0003oool000000oooo`050000ooooooooooooOGem0097AdL00kFe]GmoOd];B`02
Bd];00AKFe/R8R8R8R892@T2A4A400J2PX8N7Qi6ATI6ATHj>S[Cdm<29BDU00Jk^k]SHf=0@410@41b
LW90@402LG5a00HV9RIfMWIXJ6QXJ6QaLG6CTi<2AdM700F>SXiADE5ADE6UYJECDe<00SLg=`06Lg=c
:2PXSHf=SHf==cLgNWYj0S8b<P06820P=3@dATI6ATI6@T92IfMW0S4a<@05ATI630`<30`<7alOFe]K
009WIfL01Ph>3T51@EEEEEEEEDi>CQHF5P9CDe<01Ta<C79bLTQ8B4Q8B6ATI492@P9NGUh01H:2PXF5
QHF5QG]kNcDe=@026ATI00JWYjMNGUi^KVi^KVi0@4092@T2<C4a00IGEeMEEED_;bl_;blZ:RYKFe/2
;Bd]00DZ:RXh>3Pb<S8b<S9UIFD00S4a<@06ATI6>c/k@T92@T92@4102PX:0UUIF@06=cLgGUiNE5AD
E5AD?CdmWYjN0Xb<S005IFEUShn?IfMWIfMW:b/[008I6AT01R0P86e]KGYjNWYjNVYZJQ8B4P99BDT0
1Sdm?GMgMfQXJ6QXJ4=3@clo?`8Y:BT01Tm?Ca/K6c/k>c/k>hB4Q9ZJVP:6QXH01Fi^KVMWIfMWIcXj
>S<c<`02IFEU00EXJ6Q=CDe0@410@41`L7000oooo`030000oooooooo027oool00`000?ooo`000002
oooo00<0003oool000000oooo`040000ooooooooN7Qh0TA4A005ZJVYSHf=?Cdm?Cdm?Shn009=CDd0
1S0`<0L71eIFEUIFEWMgMadM7@8n?Sh01Rd];Lk>cRHV9RHV9/W9bFYZJP9CDe<01H:2PT];Bd];BfAT
I3@d=002OGem00IRHV9PH626QXJ6QXI<C4b?Shl2C4a<00Ff][I3@d=3@d<Z:RZ5QHD00R@T9006Ogmo
>CTiP820P82092@T4Q8B0T=3@`05>CTiCdm?Hf=SHf=S9RHV008l?3`01QTI6B/[:eMGEeMGEf][JaDE
5@93@d<01Ti>CTe=C@d=3@d=3Di>CTm?C`9gMgL01D];BeiNGUiNGS/k>emOG`02Ogmo00J2PX9mOGdl
?3`l?3`M7Af][Jd2FUYJ00EeMGDm?Cdm?Cd820Pg=cL00UIFEP06F5QH:b/[9RHV9RHVF5QH;Rh^0R`/
;005?3`l<30`IFEUIFEU<C4a0094A4@01S`l?492@TA4A4A4A0P825UIF@8k>c/01EeMGEMGEc/k>c/k
>j6QX@02SHf=00IXJ6RCTi=YJFUYJFTX:2PF5QH28R8R00IaLG5kNg]XJ6QXJ6P?3`m5ADD2?clo00En
OWiTI6ATI6@o?cm7AdL00RXZ:P06BDU96ATI?3`l?3`lOGemUiNG0Xf=S@05NWYjGEeM?3`l?3`l:BTY
009bLW801F][JdI6ATI6ATI6AW1`L003oooo00<0003oooooool03Oooo`006?ooo`030000oooooooo
00;oool00`000?ooooooo`02oooo00D0003ooooooooooommOGd00TM7A`03]KFeOgmoBd];009;Bd/0
15]KFb8R8R8R8PT92@94A4@01X:2PQhN7TI6ATI6ASXj>]?Cd`8U9BD01[^k^f=SHd10@410@79bLT10
@09aLG401RHV9WIfMVQXJ6QXJ75aLI>CT`97AdL01Hj>SU5ADE5ADJFUYE=CD`02=cLg00IcLg<X:2R=
SHf=SHdg=cMjNWX2<S8b00HP820d=3A6ATI6ATI2@T9WIfL2<C4a00E6ATH<30`<30`O7amKFe/00VMW
I`063Ph>@D51EEEEEEEECTi>5QHF0U=CD`06C4a<LW9bB4Q8B4Q8I6AT@T920UiNGP05PX:2QHF5QHF5
Ng]k=CDe008I6AT01ZNWYeiNGVi^KVi^KT10@0T92@8a<C401UMGEeEEEBl_;bl_;bXZ:U]KF`8];Bd0
1BXZ:SPh>38b<S8b<VEUI@02<C4a00I6ATHk>c]2@T92@T90@40:2PX2FEUI00Hg=cMNGUiDE5ADE5@m
?CfNWYh2S8b<00EUIFF?ShmWIfMWIfL[:b/00QTI6@06820PKFe]NWYjNWYjJVYZ4Q8B0TU9B@06?Cdm
MgMgJ6QXJ6QX@d=3?clo0RTY:@06Cdm?6a/K>c/k>c/kQ8B4VYZJ0XJ6QP05KVi^IfMWIfMW>SXj<c<c
009UIFD01FQXJ4e=CD10@410@71`L003oooo00<0003oooooool08_ooo`030000oooooooo00;oool0
0`000?ooooooo`02oooo00@0003ooooooomhN7P2A4A400FYZJV=SHdm?Cdm?Cdn?Sh00Te=C@06<30`
1`L7EUIFEUIFMgMg7AdM0Shn?P06;Bd]c/k>9RHV9RHVbLW9JVYZ0U=CD`05PX:2Bd];Bd];I6AT=3@d
009mOGd01V9RHV1PH8J6QXJ6QTa<C8n?S`9<C4`01KJf]T=3@d=3@bXZ:XF5Q@0292@T00IoOgli>CV0
P820P80T92@B4Q82@d=300Di>CU?CdmSHf=SHf<V9RH00S`l?0066ATI:b/[EeMGEeMGJf][5ADE0T=3
@`06CTi>CDe=3@d=3@d=CTi>Cdm?0WMgM`05Bd];GUiNGUiN>c/kGemO009oOgl01X:2PWemOC`l?3`l
?1dM7Jf][@9JFUX01GEeMCdm?Cdm?@P823Lg=`02EUIF00IHF5P[:b/V9RHV9RIHF5P^;Rh2;2`/00Dl
?3``<31UIFEUIFDa<C400TA4A006?3`l@T92A4A4A4A420P8FEUI0S/k>`05GEeMEeMG>c/k>c/kXJ6Q
00:=SHd01VQXJ9>CTfUYJFUYJBPX:1HF5P8R8R801W5aLG]kNfQXJ6QXJ0l?3dE5A@8o?cl01GinOVAT
I6ATI3lo?dM7A`02:RXZ00I9BDTI6ATl?3`l?3amOGfGUiL2SHf=00EjNWYMGEdl?3`l?3`Y:BT00W9b
LP05Jf][ATI6ATI6ATI6L71`00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooooM
gMd00Tm?C`06=SHfATI6QhN7QhN7@T92De=C0S4a<@05ADE51`L71`L7Kfm_AdM7008_;bl01UYJFUIF
EU]KFe]KFn3Ph10@408D51@01T51@APH6;no_kno_dY:BVIVIP8Z:RX01CTi>JZZZU=CDe=CDkNg]`02
;Rh^00JNWYh^;Ri8B4Q8B4PC4a=PH602P82000IHF5Q9BDTn?Shn?Shh>3Q0@4036a/K00ASHf<Z:RXZ
:RXl?3`29bLW00H;2`^7QhMJFUYJFUYXJ6Q6ATH2AdM700I>CTiBDU9XJ6QXJ6PO7amLG5`2@41000F9
RHT/;2a1@D51@D4o?cl00RXZ:P06;bl_8b<S=SHf=SHfC4a<FUYJ0UmOG`06VIVI820P@d=3@d=3MWIf
=3@d0SDe=@06MGEeFe]KHf=SHf=S9BDUBd];0V5QH@05Ng]k;bl_;bl_EEEEEUIF008i>CT01ZZZZTe=
CDY:BTY:BUEEEE9BDP8b<S801Z:RXWMgMfEUIFEUIEQHF6ATI08W9bL01B/[:`820P820WIfMSHf=P02
;2`/00I<C4a=CDelO7alO7c6a/H?3`l2I6AT00H;2`/k>c]RHV9RHV9=CDe7AdL2;Rh^00FATI66QXJ>
SXj>SXiSHf<00QXJ6P06EeMGJVYZ@T92@T92Shn?LW9b0TI6AP05QHF5oooooooooooo000002koool0
10000?ooooooomGEe@95ADD01Bl_;d=3@hV9RHV9RC`l?002BDU900Hm?Ce:BTXB4Q8B4Q9iNGU>CTh2
9RHV00IADE5PH61BDU9BDU;^k^hL71`26a/K00E9BDTB4Q8B4Q:n_[i2@T800U]KF`06=3@d>SXjXJ6Q
XJ6QFEUI[Zj^0R@T9005W9bL=CDe=CDeEUIF3`l?009WIfL01WMgMde=CDe=CDe=CC@d=492@P8o?cl0
1B0P824Q8EQHF5QHF1dM7@02?3`l00H^;Rh:2PZFUYJFUYIADE5OGel2>c/k00Hn?SiIFEU4A4A4A4A^
KVhL71`2Fe]K00E@D51mOGemOGdb<S8g=cL00T92@P069BDU8B4Q5QHF5QHF9RHVFEUI0V][J`05DU9B
[Jf][Jf];bl_=3@d009VIVH01TA4A3Ph>7IfMWIfMU9BDU=CD`8c<c<01EQHF5ADE6][Jf][JcLg=`02
AdM700I:BTY<C4bTY:BTY:ADE5ALG5`2A4A400E6ATH`<32QXJ6QXJ64Q8@00UEEE@06D51@M7Ad>3Ph
>3Ph7AdM3`l?0Ve]K@06@410;2`/AdM7AdM7ADE5QHF50/k>cP057QhNEeMGEeMG0`<3@d=3009ZJVX0
1T51@D10@2LW9bLW9hR8R861P@:IVIT01EmOG`l?3f=SHf=SHfMWI`02CTi>00FLW9abLW99BDU9BDV?
Shl00oooo`030000oooooooo00goool002;oool01@000?oooooooooood];B`02/;2`00K3`l>][Jdm
?Cdm?Ce=CDfHV9P2@D5100EWIfLC4a<C4a=SHf=6ATH00SXj>P06EeMG30`<E5ADE5ADXj>S?Shn0T=3
@`06HV9R51@DTY:BTY:BS8b<TY:B0PT92@05<C4a>CTiSHf=SHf=J6QX008G5aL01QDE5KZj^TU9BDU9
BB<S8d];B`9JFUX01Q@D5;bl_2HV9RHV9T];BdA4A08I6AT01A4A4DE5AD10@410@5]KF`02Ng]k00I7
AdMSHf=5ADE5ADE3@d=iNGT2@41000IGEeL/;2`W9bLW9bLb<S9hN7P25aLG00DN7Qi0@41aLG5aLG5b
LW800Xb<S006;Rh^FUYJHf=SHf=SD51@BTY:0SHf=P06DU9BATI6JVYZJVYZCdm?A4A40Shn?P06>SXj
=CDe<C4a<C4a:b/[Lg=c0QHF5P05?Shn@410@410[:b/9RHV00:BTY801Rl_;lG5aB8R8R8R8YbLW7Yj
NP9?Cdl01R0P83De=@X:2PX:2UEEEEiNGP8g=cL01GalO8^;Rh^;RbTY:G5aL@02@D5100HO7am:BTYX
J6QXJ6Q3@d<J6QX2<C4a00I2@T8d=3ATI6ATI6@c<c=;Bd/2=3@d00D^;Rh71`M[Jf][Jf^2PX800VUY
J@06JVYZAdM7D51@D51@NWYjIVIV0Ta<C005IVIVoooooooooooo000002koool010000?oooooooeMG
E`:f][H01M;BdZ:RXS0`<30`<5QHF002T92@00I8B4QIFET61PH61PIGEeM2@T82@d=300I:BTXE5AE;
Bd];Bd^FUYHg=cL2B4Q800EKFe/I6ATI6AVKVi^HV9P00YfMW@0630`<;2`/A4A4A4A4QHF5K6a/0Q0@
40053Ph>];Bd];BdCTi>:RXZ0095ADD01U]KFa<C4kbl_;bl_2PX:4Q8B08n?Sh01A/K6aHF5Slo?clo
?cPh>002IFEU00IgMgM7AdM^KVi^KVi<C4`n?Sh2NWYj00Hf=SIWIfLP820P820`<30k>c/2JFUY00DS
8b<Z:RXZ:RY8B4Q[Jf/00UmOG`06XZ:R7QhNH61PH61PJf][>SXj0T];B`058B4QBTY:BTY:Fe]KEEEE
0091@D401Rd];E=CDdA4A4A4A3hn?RXZ:P8I6AT01GinOP@412TY:BTY:E=CD`02VIVI00Hj>SZ;Rh/c
<c<c<c?5aLDf=SH2SXj>00F6QXI1@D4Q8B4Q8B4/;2`00PD51@06BDU9IFEU@d=3@d=3Ph>3P8200R0P
8006L71`>CTi5aLG5aLGCdm?Jf][0TY:BP05820P;bl_;bl_@d=3=SHf009SHf<01S4a<Da<C34a<C4a
<C8b<PP8209WIfL01HB4Q6EUIFa/K6a/K51@D002BDU900EeMGEQHF5EEEEEEEEcLg<00oooo`030000
oooooooo00goool002;oool01@000?ooooooooooonCTi002Ng]k00Hn?Shl?3aDE5ADE5Bh^;Pe=CD2
PH6100G7alMhN7QhN7QTI6ABDU800TA4A006]kNgNGUiPh>3Ph>3`l?3TI6A0QHF5P06BTY:3Ph>6ATI
6ATIUiNGEEEE0TQ8B005LG5a?3`l820P820P8b<S008`<3001Q0@428R8QTI6ATI6FATI2HV9P9cLg<0
1SXj>VATI4Q8B4Q8B3Hf=S0`<08R8R801GinOPL71emOGemOGe=CD`02UYJF00I:BTXU9BE]KFe]KFdn
?Si4A4@2JVYZ00I@D512@T861PH61PHQ8B5OGel2JFUY00FATI4o?clA4A4A4A4j>SX00Rh^;P066a/K
?3`l;bl_;bl_UiNGADE50XJ6QP066ATIFUYJEUIFEUIF@d=3E5AD0TM7A`06VIVI]KFeBDU9BDU9R8R8
MgMg0SDe=@055ADE:BTY:BTYJ6QX4a<C00892@T01Shn?R0P84I6ATI6AVYZJVMWI`8m?Cd01Z>SXcDe
=DM7AdM7A`@411HF5P:6QXH3>SXj00ICDe<A4A6OWinOWim@D51OGel2?Cdm00HV9RI7AdLh>3Ph>3R?
ShlU9BD2H61P00IADE6^[ZiBDU9BDU9EEEFj^[X2?clo00GNg]i]KFe]KFeJFUYUIFD00T];B`05/K6a
Fe]KGUiNGUiN];Bd00?oool00`000?ooooooo`0/oooo00@0003ooooooooNg]h2Xj>S00E<C4`E5ADb
<S8b<S:ZZZX00S<c<`06OWinc/k>LG5aLG5aG5aLBDU90UQHF006Ti>CEEEELG5aLG5aXZ:RPH610Q`L
7005ATI69RHV9RHV6QXJXj>S009PH6001TQ8B5QHF2@T92@T90/;2alO7`8S8b<01@`<318B4Q8B4Pl?
3fm_K`02;Rh^00IjNWY2@T9[Jf][Jf]=CDd`<302<S8b00DP821oOgl61PH61PIQHF400UIFEP06U9BD
AdM7:BTY:BTYLW9bA4A40TI6AP06KVi^Fe]K?Cdm?Cdm1PH671`L0U5AD@05MGEeW9bLW9bL>c/k0@41
008o?cl01T51@BDU9Dm?Cdm?CalO7ibLW097AdL01GmoObDU9BDU9EEEEDU9B@02=SHf00I3@d<h>3RZ
ZZZZZZZ][JeJFUX2OWin00F4Q8@];BdH61PH61P[:b/00VIVIP066a/K0000ADE5ADE56QXJ@d=30Va/
K005IVIV?3`lYJFUYJFU>CTi0094A4@01P<30aHF5XF5QHF5QCPh>4E5A@9NGUh01Q@D5:b/[451@D51
@E5ADDm?C`8R8R801Cdm?Di>CTi>CWUiNC0`<002AdM700Hj>SZDU9A[Jf][Jf/k>c^][Jd2DU9B00G0
`<1<C4a_Kfm_KfmKFe/00TQ8B005V9RHEUIFQHF5QHF5f][J00?oool00`000?ooooooo`0=oooo000R
oooo0P0000;oool01NCTi7]kNg]kNchn?S`l?002E5AD00Fh^;Pe=CF1PH61PH77alL00WQhN006I6AT
DU9BA4A4A4A4]kNgNGUi0X>3P`06`l?3TI6A5QHF5QHFBTY:3Ph>0QTI6@06UiNGEEEEB4Q8B4Q8LG5a
?3`l0R0P80058b<S<30`<30`410@8R8R008I6AT01VATI2HV9W=cLg=cLcXj>VATI098B4P01SHf=S0`
<28R8R8R8WinOPL71`9OGel01E=CDiJFUYJFUTY:BRDU9@02KFe]00Hn?Si4A4AZJVYZJVY@D512@T82
1PH600HQ8B5OGemYJFUYJFVATI4o?cl24A4A00Dj>SX^;Rh^;RhK6a/l?3`00Rl_;`06UiNGADE5QXJ6
QXJ66ATIFUYJ0UIFEP06@d=3E5ADAdM7AdM7VIVI]KFe0TU9B@05R8R8MgMg=CDe=CDe5ADE008Y:BT0
1VQXJ1<C4`T92@T92Chn?R0P8096ATH01VYZJVMWIcdm?Cdm?J>SXcDe=@97AdL010@411HF5XJ6QXJ6
QP<j>SX01U=CDa4A4InOWinOWe1@D5mOG`8m?Cd01RHV9TM7AcPh>3Ph>8n?SbDU9@9PH6001U5ADJj^
[U9BDU9BDUEEEKZj^P8o?cl01MkNgVe]KFe]KEYJFVEUI@02Bd];00Fa/K5KFe]NGUiNGUjd];@00_oo
o`80000^oooo0P000006oooog]kNXj>SXj>SC4a<5ADE0S8b<P05ZZZZ<c<c<c<cOWinc/k>009aLG40
1UaLG4U9BEQHF5QHF9>CTeEEE@9aLG401J:RXX61PA`L71`L74I6AP029RHV00HJ6QZSXj=PH61PH618
B4QHF5P292@T00D;2`/O7alS8b<S8b<<30`00Q8B4P063`l?Kfm_;Rh^;Rh^NWYj@T920V][J`06CDe=
<30`<S8b<S8b820POgmo0PH61P05HF5QEUIFEUIFU9BDAdM7008Y:BT01W9bLTA4A4I6ATI6AVi^KU]K
F`8m?Cd01@H61Q`L755ADE5ADGEeM@02W9bL00Hk>c/10@4o?clo?cm1@D4U9BD2Cdm?00DO7anLW9a7
AdM7AdMoOgl00RDU9@06EEEEBDU9=SHf=SHf@d=3>3Ph0ZZZZP06[Jf]FUYJOWinOWinQ8B4;Bd]0QPH
6005:b/[IVIVIVIV6a/K00000095ADD01QXJ6T=3@fa/K6a/K6IVIS`l?0:UYJD01CTi>DA4A4A4A0<3
0aHF5P02QHF500Hh>3Q5ADENGUiNGUhD51B/[:`2@D5100EADE5?CdlR8R8R8R8m?Cd00Ti>CP06NGUi
<30`AdM7AdM7>SXjU9BD0V][J`06>c/k[Jf]DU9BDU9B`<30C4a<0Vm_K`05Fe]KB4Q8B4Q8V9RHEUIF
00:5QHD00m[Jf_ooooooo`0200003oooo`008_ooo`050000oooooooooooom_Kf00;9bLT01Xj>SS8b
<U5ADE5ADF][JbXZ:P8i>CT01Fa/K14A4A4A4AlO7fUYJ@028B4Q00J4Q8A`L72;Rh^;Rh]fMWJHV9P2
UYJF00H[:b]dM7@Y:BTY:BUTI6@T92@2?3`l00EfMWHZ:RY8B4Q8B4Q`L7000T51@@06;Rh^?clo0`<3
0`<3:b/[?Cdm0SHf=P06;2`/6a/KCdm?Cdm?H61P3`l?0UmOG`05Fe]KBDU9FEUIFEUI20P8009JFUX0
1W5aLDE5AC4a<C4a<CHf=P`<30810@401U=CDd];Bfi^KVi^KPh>3UADE08X:2P01EYJFTY:BPd=3@d=
3L_;b`02:2PX00D`<31MGEeBDU9BDU8C4a<00b@T9006GUiN7alO6a/K6a/KEUIFalO70U5AD@068R8R
P820SHf=SHf=F5QH=CDe0UEEE@05?clo<S8b<S8b?clo?Shn008h>3P01XJ6QQ<C4fQXJ6QXJ4A4A24Q
8@8^;Rh01WemOBTY:BXZ:RXZ:W9bLU9BDP9RHV801GAdM61PH61PH5YJFSXj>P02OGem00JTY:AgMgN@
T92@T91KFe/o?cl25ADE00IKFe]1@D5?Cdm?CdnGUiMdM7@29bLW00E[Jf/l?3b=SHf=SHeoOgl00/W9
b@06De=CJFUYO7alO7alfm_KEeMG0YJFUP05_Kfmoooooooooooo000002koool010000?ooooooon?S
h`;;bl/01IbLW2TY:Fm_Kfm_Ke]KF`02=3@d00I9BDV:RXXV9RHV9RHF5QIcLg<26ATI00I/K6aHF5Qj
NWYjNWYOGen:RXX2WYjN00Dk>c^8R8R8R8Pm?CeQHF400SPh>006>CTiI6AT5aLG5aLG=SHfH61P0UAD
E0057AdM<30`<30`51@D820P008e=CD01TM7AalO7`l?3`l?3eUIFEEEE@8B4Q801E9BDU1@D3`l?3`l
?69RHP0230`<00I>CTiZJVY3@d=3@d<h>3Pm?Cd2410@00H<30aHF5QBDU9BDU9ZJVX>3Ph2FEUI00DX
:2QUIFEUIFE>CThF5QH00/g=c@06<C4a<30`FEUIFEUIE5AD5ADE0RTY:@059bLWH61PH61P820P6ATI
009IFET01/O7ae=CDb<S8b<S8h20P8f=S@9KFe/01CXj>U9BDTA4A4A4A38b<P02A4A400Hf=SHo?cn0
P820P80820QbLW82B4Q800DJ6QX/;2b>SXj>SXhJ6QX00SDe=@06I6ATHf=SFEUIFEUIHf=SLg=c0UmO
G`06;Bd]Ti>CSHf=SHf=GemOUYJF0U=CD`05EEEE:b/[:b/[DE5A?Shn009XJ6P01W]kNeQHF1HF5QHF
5VQXJ5EEE@9aLG401F][Jk^k^c@d=3@d=65QH@02JVYZ00G=cLeJFUZc/k>c/k?MgMd00oooo`030000
oooooooo00goool002;oool00`000?ooooooo`02oooo0[Fe]@06Lg=cfm_K8R8R8R8R5ADE=cLg0RXZ
:P05cLg=D51@D51@2@T9UIFE008W9bL01UEEECPh>1LG5aLG5eeMGB@T90:CTi<01V5QHHb<S0410@41
0BPX:6EUI@94A4@01C<c<iJFUWUiNGUiNF5QH@029RHV00Hn?SijNWXX:2PX:2PA4A4k>c/22PX:00H^
;RiPH623Ph>3Ph<X:2PW9bL25QHF00D61PI?CdlI6ATI6AUUIFD00SPh>006PX:2ATI6=cLg=cLg?3`l
K6a/0VIVIP067alOLW9b<S8b<S8b4Q8B:2PX0R<S8`057alO9BDUWIfMWIfMN7Qh0093@d<01STi>Gin
OT92@T92@Q`L73`l?09]KFd2A4A40Y:BTP06:2PXATI6HV9RHV9RQhN7RXZ:0W5aL@05J6QXJVYZG5aL
G5aLI6AT008o?cl01TE5AB/[:f=SHf=SHbd];D];B`93@d<01S4a<JNWYfMWIfMWIcPh>3`l?093@d<0
1GinOSDe=FIVIVIVIR`/;002=SHf00IHF5PO7al92@T92@TR8R9jNWX2KVi^00IDE5@I6AUZJVYZJVY?
Cdl?3`l2LW9b00H^;RiRHV9SHf=SHf><S8amOGd22@T900F2PX8L71`L71`:2PYMGEd00U9BDP05M7Ad
G5aLOGemOGem_[jn00?oool00`000?ooooooo`0/oooo00@0003oooooooooool2_;bl00=nOWkDe=@M
7Ad00QdM7@8];Bd01SHf=/?3`dA4A4A4A0X:2XZ:RP8_;bl01UEEECXj>QlO7alO7eeMGALG5`:UYJD0
1EQHF9BDU9BDU10@42PX:002HF5Q00I6ATHY:BV6QXJ6QXJ<S8aJFUX26QXJ00E8B4QXJ6QXJ6Pl?3`S
8b<00RPX:0063`l?6a/KMGEeMGEeLG5a>SXj0R`/;0051`L76ATIB4Q8B4Q82PX:009fMWH01RTY:G5a
LE=CDe=CDdQ8B34a<@9LG5`01VIVIRPX:6=SHf=SHcTi>@`<308d=3@01B4Q8Bh^;Rh^;R8R8YRHV002
Jf][00Hf=SH_;bmjNWYjNWXg=cLD51@2BTY:00EZJVXm?Cdm?Ce5ADF@T9000RPX:006DU9BI6ATOgmo
OgmoUYJFLG5a0Vm_K`05MWIfDe=CGEeMGEeMATI60091@D401Rh^;UYJFS<c<c<c<de=CDU9B@8i>CT0
1Jj^[V1PH410@410@3`l?002@d=300J3Ph<k>c]SHf=SHf<V9RHd=3@2GemO00HN7Qh<30`N7QhN7Qig
MgM/K6`2F5QH00DK6a]^KVi^KViADE4@41000WEeM@06;bl_I6ATHf=SHf=SShn?O7al0PP82005QhN7
7QhN2@T92@T9HF5Q009GEeL01GAdM5MGEgUiNGUiNK^k^`03oooo00<0003oooooool03Oooo`008_oo
o`050000ooooooooooooLW9b00;UiND01Pd=3D];Bbh^;Rh^;UQHF2TY:@9@D5001Jb/[7alO7alO8:2
PT92@P02=3@d00ImOGd?3`lQ8B4Q8B4H61Q]KFd2D51@00HS8b=GEeLh>3Ph>3QQHF4c<c<2DE5A00EV
IVHc<c=^KVi^KVjm_Kd00W1`L006410@@D51:2PX:2PX8R8R>3Ph0XB4Q006HV9R6a/KMGEeMGEe<C4a
CDe=0U1@D005;bl_8B4Q>3Ph>3PhKVi^009?Cdl01RHV9U1@D0/;2`/;2b/[:chn?P8V9RH01S@d=4M7
AcPh>3Ph>2@T94M7A`9ADE401Jb/[7inOWmoOgmoOgYjNP02Ogmo00ITI6ABDU8O7alO7amjNWX`<302
B4Q800HR8R8S8b=ZJVYZJVXa<C58B4P2=cLg00H?3`l_;bln?Shn?Sj>SXhh>3P2=3@d00FOWilo?clo
?cmGEeL_;bl00S0`<006C4a<=SHf9bLW9bLW7alOU9BD0Ve]K@06TI6A>c/kCTi>CTi>K6a/F5QH0Ve]
K@05EUIFC4a<C4a<FEUI6QXJ009aLG401QXJ6S/k>eUIFEUIFFMWIe=CD`8d=3@01TQ8B3@d=18B4Q8B
4Xn?SijNWP97AdL01IBDU14A4G1`L71`L4Y:BP02Hf=S00Hi>CTB4Q99BDU9BDV7QhO5aLD25QHF1?oo
o`030000oooooooo02coool010000?ooooooohV9R@;inOT01B4Q8D10@1HF5QHF5UiNGP02@d=300IJ
FUZNWYi]KFe]KFe/K6aEEED2820P00J4Q8@R8R8B4Q8B4Q8@411JFUX2EeMG00<W9bMEEEEEEED00Ti>
CP96ATH01UeMGEaLG3Xj>SXj>W5aLL[:bP9QHF401A<C4c4a<C4a<B`/;1/K6`02@D5100IfMWIIFETV
9RHV9RI^KVhZ:RX2DU9B00ELG5`m?CdV9RHV9RI6ATH00WAdM006BTY:6ATIGUiNGUiN6ATI7alO0S/k
>`06;bl_9RHV?3`l?3`l;Rh^9BDU0Slo?`05EUIFX:2PX:2PRHV9OGem009bLW801XZ:RU]KFdM7AdM7
Aa8B4W5aL@8];Bd01D];BaHF5QHF5QdM7GEeM@02:b/[00ICDe<`<30=3@d=3@dV9RI9BDT2VYZJ00Da
<C4c<c>HV9RHV9Ph>3P00UaLG006:b/[<S8bBd];Bd];=cLg8R8R0RPX:005SXj>Jf][VYZJVYZJ@410
0096ATH01WIfMUADE75aLG5aLF=SHdQ8B09>CTh01RLW9f][J`/;2`/;2cdm?FYZJP9MGEd01D=3@b`/
;2`/;3`l?2h^;P029RHV00J7QhNCTi=8B4Q8B4R:RXX820P2PH6100E>CTiBDU8S8b<S8b<71`L00S8b
<P04PX:2/k>c410@410@1?ooo`030000oooooooo00goool002;oool01@000?ooooooooooog9bLP02
iNGU00H=3@e;Bd/^;Rh^;RiHF5PY:BT2D51@00F/[:alO7alO7b2PX92@T800S@d=006OGem3`l?8B4Q
8B4Q61PHKFe]0U1@D0068b<SEeMG>3Ph>3PhHF5Q<c<c0U5AD@05IVIV<c<cKVi^KVi^_Kfm009`L700
1Q0@4451@BPX:2PX:28R8SPh>0:4Q8@01V9RHQ/K6gEeMGEeMC4a<De=C@9@D5001Bl_;b4Q8CPh>3Ph
>6i^KP02Cdm?00HV9RI@D50;2`/;2`/[:b/n?Sh29RHV00Hd=3A7AdLh>3Ph>3PT92A7AdL2DE5A00F/
[:anOWioOgmoOgmjNWX00WmoO`06I6ATDU9B7alO7alONWYj<30`0TQ8B0068R8R8b<SJVYZJVYZ<C4a
B4Q80SLg=`063`l?;bl_?Shn?ShnSXj>>3Ph0S@d=005WinO?clo?cloEeMG;bl_008`<3001Ta<C3Hf
=RLW9bLW9alO7iBDU09]KFd01Y6ATC/k>di>CTi>CVa/K5QHF09]KFd01EIFETa<C4a<C5UIFAXJ6P02
LG5a00HJ6QXk>c]IFEUIFEUWIfMCDe<2=3@d00I8B4Pd=3@B4Q8B4Q:?ShnNWYh2AdM700FDU9@A4A5`
L71`L71:BTX00V=SH`06>CTi4Q8BBDU9BDU9QhN7aLG50QHF5PCoool00`000?ooooooo`0/oooo00@0
003ooooooon9RHT2nOWi00DQ8B50@40F5QHF5QINGUh00T=3@`06FUYJWYjNKFe]KFe]K6a/EEEE0R0P
8006Q8B48R8R4Q8B4Q8B410@FUYJ0UMGE`039bLWEEEEEEEE009>CTh2ATI600IMGEeLG5`j>SXj>SYa
LG7:b/X2HF5Q00DC4a<a<C4a<C4/;2`K6a/00T51@@06MWIfFEUI9RHV9RHVKVi^:RXZ0U9BDP05G5aL
?Cdm9RHV9RHVATI6009dM7@01TY:BQTI6EiNGUiNGQTI6AlO7`8k>c/01Rl_;bHV9S`l?3`l?2h^;RDU
9@8o?cl01EIFEZ2PX:2PX8V9RGemO@02LW9b00J:RXYKFe]7AdM7AdLB4Q9aLG42;Bd]00E;Bd/F5QHF
5QHM7AeeMGD00R/[:`06De=C<30`3@d=3@d=9RHVBDU90YZJVP05<C4a<c<cV9RHV9RH>3Ph009LG5`0
1R/[:c8b<T];Bd];BcLg=b8R8P8X:2P01Hj>SV][JiZJVYZJVT10@002ATI600IfMWIDE5AaLG5aLG5S
Hf=8B4P2CTi>00HW9bM[Jf/;2`/;2`/m?CeZJVX2GEeM00E3@d</;2`/;2`l?3`^;Rh00RHV9P06QhN7
Ti>CB4Q8B4Q8RXZ:20P80X61P@05CTi>DU9B8b<S8b<S1`L7008b<S8018:2P[>c/a0@410@40Coool0
0`000?ooooooo`0=oooo000Roooo00D0003ooooooooooolk>c/00/;2`P06:RXZT92@BTY:BTY:2PX:
LW9b0R4Q8@05GEeM>CTi>CTiShn?Jf][009TI6@01VIVITQ8B61PH61PH4];BeIFEP:5QHD01QdM7D10
@1/K6a/K6g1`L6a/K09MGEd01HF5QD92@V5QHF5QHEeMG@02<C4a00ITI6AgMgNBTY:BTY9hN7QJFUX2
^k^k00I=CDe@D51YJFUYJFTV9RIiNGT2ATI600Dl?3aBDU92@T92@T8f=SH00SLg=`068b<SI6ATOWin
OWinJFUYJf][0R<S8`06:BTYLg=c@d=3@d=3:b/[Q8B40TM7A`05?3`l>SXj=3@d=3@dNWYj008P8200
1SLg=fMWIbl_;bl_;d];BcLg=`9CDe<01R8R8WMgMclo?clo?eiNGPh>3P9YJFT01S<c<fIVITm?Cdm?
Cfa/K2TY:@:1PH401EiNGUMGEeMGEa`L71@D5002<30`00H];BeMGEe/K6a/K6`o?cmKFe/2GemO00IV
IVIYJFTd=3@d=3AXJ6PM7Ad2QXJ600Do?cmADE5ADE6>SXhl?3`00Tm?C`06<30`8B4QG5aLG5aL;2`/
5QHF0UUIF@06BDU95aLG;2`/;2`/8R8RNGUi0Xb<S005<S8b>CTiT92@T92@K6a/008U9BD01V5QHB4Q
8GmoOgmoOeEEED];B`9FEUH4oooo00<0003oooooool0;?ooo`040000oooooooo=3@d0/?3``05<C4a
Rh^;DE5ADE5A30`<009hN7P01RLW9eIFESPh>3Ph>9>CTgAdM09SHf<01VEUIE5ADFUYJFUYJE1@D5IF
EP9oOgl01B4Q8D51@D51@B4Q8F][J`02JFUY00IHF5QnOWi;Bd];Bd]UIFEQHF42:RXZ00EPH61mOGem
OGfATI5dM7@00V=SH`06_KfmDU9BCTi>CTi>HV9R9BDU0X20P005D51@?3`lG5aLG5aLADE5008i>CT0
1S0`<2HV9VEUIFEUIGYjNV][J`9bLW801R/[:bh^;Vi^KVi^KTY:BS8b<P:3Ph<01D=3@cHf=SHf=SLg
=bl_;`02PH6100HR8R8f=SI_Kfm_KflX:2Q8B4P2<c<c00EHF5PW9bLW9bMfMWI9BDT00UaLG0062@T9
HF5Q>3Ph>3PhGUiNBTY:0WIfMP05:BTYNGUiJ6QXJ6QXE5AD008S8b<01QdM7C4a<BPX:2PX:5ADE79b
LP8m?Cd01E1@D6QXJ7=cLg=cLfATI002@41000I^KVhO7an<S8b<S8a3@d=7AdL2UIFE00Hd=3A<C4`V
9RHV9RHI6AUNGUh27alO00DR8R9>CTi>CTi1@D4S8b<00R`/;006820PKfm_RHV9RHV9:2PX<c<c0YBD
U005Hf=S820PFEUIFEUI61PH009hN7P014a<C4I6AUmOGemOG`Coool00`000?ooooooo`0=oooo000R
oooo0P0000;oool01G=cLhN7QhN7QfEUIDU9B@02OGem00EXJ6Q[Jf/H61PH61Q>CTh00S@d=006BDU9
410@<c<c<c<c4Q8BE5AD0TY:BP06OWin:BTYOWinOWinGemO820P0Ti>CP06OgmoDe=CLG5aLG5aNWYj
NGUi0R/[:`05OGem<S8b<S8bA4A42`/;009bLW801U1@D6YZJP`<30`<3820P8n?S`8g=cL01QXJ6S`l
?6=SHf=SHc0`<2PX:0=gMgL26ATI00HO7ambLW:c/k>c/k=WIfMTI6@2K6a/00Hj>SXh>3Pd=3@d=3Ah
N7QADE42<c<c00ECDe=ZJVY2@T92@T9IFET00UEEE@06BTY:GEeM820P820P5ADE71`L0S`l?006@T92
BTY:@410@410EeMG61PH0S4a<@064Q8BCdm?FUYJFUYJ>CTi;Bd]0TM7A`05;2`/B4Q8B4Q8:b/[AdM7
0093@d<01UiNGSDe=A<C4a<C4da<C3dm?@8d=3@01SLg=eQHF59BDU9BDQdM7EIFEP8n?Sh01B4Q8Cdm
?Cdm?A4A4DA4A0028b<S00HO7alA4A4O7alO7alJ6QXY:BT2:b/[00ILG5`h>3Q3@d=3@d<e=CF>SXh2
NGUi00Fl_;`c<c<W9bLW9bNHV9P00T=3@`066QXJS8b<@410@410MgMg5ADE0UUIF@?oool20000;_oo
o`8000001_ooofi^KWYjNWYjNUaLG4I6AP9aLG401GEeMF5QHF5QHA<C4dI6AP028b<S00IIFETL71`o
?clo?cl20P9NGUh2Fe]K00EiNGTg=cN<S8b<S8a?Cdl00Rh^;P06DU9BP820B4Q8B4Q8IVIVJFUY0W=c
L`05:BTYMGEe@d=3@d=3>CTi008820P01F=SHdE5AGEeMGEeM@D51@03Shn?00I5ADDQ8B55ADE5ADEX
J6Ph>3P2<C4a00F2PX9`L71`L70F5QHN7Qh00Va/K006[jn_Jf][J6QXJ6QXLG5a=SHf0S`l?005=SHf
Ng]kDU9BDU9B=3@d009CDe<01Va/K451@EaLG5aLG5UIFDU9B@9QHF401BDU9ALG5ahN7QhN7T92@P02
B4Q800I6ATI3@d=@D51@D50A4A4];Bd22@T900I9BDUQHF4j>SXj>SX_;bm3@d<28b<S00E9BDT_;bl_
;bm2@T9=CDd00V5QH@03<S8b4Q8BAdM70097AdL012l_;cLg=cLg=eEEE@9:BTX01R<S8eeMGCXj>SXj
>QXJ6S/k>`8H61P01TE5AB8R8RHV9RHV9PX:2Q/K6`8G5aL01B/[:bHV9RHV9U]KFc@d=002?Cdm00Ho
?cn<S8b4Q8B4Q8C5aLDZ:RX2<30`00FPX:1>CTh@410@4123Ph<00STi>@04KVi^5QHFDU9BDU9B0ooo
o`80000?oooo000Roooo00D0003ooooooooooomcLg<00XN7Q`06IFEUBDU9OGemOGemJ6QXJf][0QPH
6005CTi>=3@d=3@dBDU9410@008c<c<01Q8B4UADE4Y:BTY:BWinORTY:@9nOWh01UmOGb0P84i>CTi>
CWmoOe=CD`9aLG401GYjNWUiNB/[:b/[:gemO@02<S8b00I4A4@;2`]bLW9bLW9@D51ZJVX230`<00J0
P82?Shlg=cLg=cLJ6QXl?3`2Hf=S00<`<30X:2QgMgL00WMgM`8I6AT01QlO7g9bL[>c/k>c/fMWIfAT
I09/K6`01SXj>SPh>3@d=3@d=7QhN55AD@8c<c<01E=CDfYZJT92@T92@UUIF@02EEEE00I:BTYMGEdP
820P820E5ADL71`2?3`l00I2@T9:BTY0@410@41GEeLH61P2<C4a00HB4Q9?CdmJFUYJFUXi>CT];Bd2
AdM700D/;2a8B4Q8B4P[:b]7AdL00T=3@`06GUiN=CDe4a<C4a<CC4a<?Cdm0S@d=006=cLgF5QHDU9B
DU9B7AdMEUIF0Shn?P058B4Q?Cdm?Cdm4A4AA4A4008S8b<01QlO7a4A4AlO7alO7aXJ6RTY:@8[:b/0
1UaLG3Ph>4=3@d=3@cDe=Hj>SP9iNGT01Kbl_3<c<bLW9bLW9iRHV002@d=300HJ6QZ<S8a0@410@41g
MgLE5AD2FEUI1?ooo`030000oooooooo02coool010000?ooooooofi^KP9jNWX01EaLG4I6AW5aLG5a
LGEeM@02HF5Q00HC4a=6ATHS8b<S8b=IFETL71`2?clo00H20P9NGUiKFe]KFe]iNGTg=cL2S8b<00E?
Cdl^;Rh^;RiBDU:0P8000TQ8B006IVIVJFUYLg=cLg=c:BTYMGEe0T=3@`05>CTi20P820P8Hf=SADE5
009eMGD01PD51Hn?Shn?Shn?SdE5AB4Q8@95ADD01FQXJ3Ph>34a<C4a<H:2PP02L71`00HF5QHN7Qi/
K6a/K6b_[jm[Jf/2J6QX00IaLG4f=SHl?3`l?3`f=SIkNg/2DU9B00Dd=3ACDe=CDe=/K6a1@D400UaL
G006FEUIBDU9HF5QHF5Q9BDU5aLG0QhN7P05@T92B4Q8B4Q8ATI6@d=3009@D5001Q4A4Bd];@T92@T9
2DU9BF5QH@8j>SX01Bl_;d=3@b<S8b<S8dU9B@02;bl_00I2@T9=CDeQHF5QHF4b<S8B4Q83AdM700@_
;blg=cLg=cMEEED2BTY:00HS8b=MGEdj>SXj>SXJ6QXk>c/261PH00I5ADDR8R8V9RHV9RH:2PXK6a/2
5aLG00D[:b/V9RHV9RIKFe/d=3@00Sdm?@06?cloS8b<Q8B4Q8B4aLG5:RXZ0S0`<005X:2PCTi>410@
410@Ph>3008i>CT016i^KQHF5U9BDU9BDPCoool00`000?ooooooo`0=oooo000Roooo00D0003ooooo
ooooool^;Rh00R4Q8@06];Bd:2PX6ATI6ATIEeMG6QXJ0Shn?P05Fe]KB4Q8B4Q8BTY:Kfm_009JFUX0
1U1@D75aLI>CTi>CTcXj>T10@0=hN7P01FMWIfATI6ATI5eMGFMWI`02MGEe00E7AdLj>SY[Jf][Jf/m
?Cd00QdM7@06HF5QZZZZDe=CDe=CNGUi?clo0WemO@06820P:BTYJVYZJVYZ:b/[FUYJ0UUIF@05@d=3
Lg=cBTY:BTY:Kfm_008P82001S0`<4m?CdM7AdM7AgQhN20P808W9bL01PX:2RDU9C/k>c/k>dE5AIjN
WP8=3@d01EQHF1XJ6Rh^;Rh^;UmOG`02>c/k00Hg=cLn?Si0@410@40V9RH;2`/21PH600IKFe/J6QXZ
:RXZ:RXa<C4H61P2ATI600HQ8B4`<31EEEEEEEEUIFE;Bd/2>SXj00DY:BUBDU9BDU8K6a/g=cL00UiN
GP06@410:BTY2PX:2PX:6QXJ;Rh^0V9RHP06M7AdOGem=CDe=CDe[Jf]<C4a0R8R8P05Bd];I6ATI6AT
92@T@D51008d=3@01QdM7ALG5f5QHF5QHDm?CalO7`:YZJT01Y^KVe]KFa/K6a/K6d10@2`/;08?3`l0
1J2PX6e]KBDU9BDU9K6a/@02?Shn00HJ6QX;2`]WIfMWIfMgMgMdM7@2ZJVY00Fd];Coooooooooool0
0000;_ooo`040000oooooooo;Rh^0R8R8P05^;Rh:BTY6ATI6ATIE5AD008I6AT01Sdm?F5QHD=3@d=3
@dE5AF][J`9LG5`01TY:BWUiNIbLW9bLW38b<T92@P:3Ph<01G1`L7=cLg=cLf9RHVUYJ@02JVYZ00Ig
MgLk>c/_;bl_;bmOGem4A4@24Q8B00E`L72QXJ6QXJ5>CTi]KFd00TY:BP06MWIf6QXJ8b<S8b<SNGUi
:BTY0Tm?C`05FUYJDE5AOgmoOgmoEeMG009XJ6P01R@T92DU9DQ8B4Q8B3dm?GIfMP8J6QX01S0`<0d=
3A`L71`L7492@TE5A@:RXZ801@T92F1PH61PH1PH62TY:@02Fe]K00Hi>CTg=cM2@T92@T8n?ShZ:RX2
2PX:00D71`MNGUiNGUhM7Ad[:b/00S0`<0065QHFADE592@T92@T;Bd]FEUI0VQXJ005Cdm?>SXj:BTY
:BTYCdm?008F5QH01S/k>f9RHTM7AdM7Ab/[:`D51@8C4a<01C8b<V=SHfm_Kfm_KgalO002<30`00JV
YZHi>CTM7AdM7Ae7AdMLG5`2;Bd]00Hj>SXd=3@V9RHV9RHH61QVIVH2Cdm?00DW9bNc/k>c/k>FUYIK
Fe/00R4Q8@06AdM79bLW410@410@X:2PJVYZ0RPX:005[jn_?3`l71`L71`L3Ph>009ZJVX01GUiNGIf
MZZZZZZZZ[Jf]P03oooo00<0003oooooool03Oooo`008_ooo`050000oooooooooooo=cLg00:KVi/0
1U=CDnWYjC<c<c<c<fYZJR@T909cLg<01CPh>6m_Kfm_KgUiNFATI002?clo00JBTY:][JelO7alO7a]
KFfTY:@2OWin00HU9BE<C4aKFe]KFe]jNWYMGEd2EeMG00ENGUj?ShlP820P820A4A400T92@P06@410
MGEeMGEeMGEeI6ATM7Ad0Y>CT`06<S8b>SXjCTi>CTi>Y:BTBTY:0Xj>SP05?clo;bl_GUiNGUiNTI6A
009UIFD01UeMGB/[:alO7alO7fi^KS/k>`8g=cL01Te=CDm?CfUYJFUYJAPH68n?S`8`<3001Cdm?B4Q
8GQhN7QhN24Q8@028R8R00I>CTiFEUHk>c/k>c/U9BE?Cdl2;2`/00IeMGEnOWi1@D51@D4K6a/`<302
K6a/00I4A4@a<C4Q8B4Q8B56ATI1@D42Q8B400EbLW9^KVi^KVjSXj>5QHD00W1`L006;Bd]IVIV;Rh^
;Rh^:BTY:RXZ0R/[:`06<C4a<S8bBd];Bd];OGemG5aL0RXZ:P05>c/kDE5ADE5A>CTi71`L009CDe<0
1Q4A4A`L75EEEEEEEI:BTXB4Q0;4a<@01VATI2l_;a<C4a<C4c`l?2/[:`871`L01D];Bc/k>c0`<30`
<2<S8`02=SHf00JDU9AFEUJGUiNGUiL/;2agMgL2/K6a00G4a<Coooooooooool00000;_ooo`040000
oooooooo:b/[0X^;R`05FUYJfMWI?Shn?ShnMWIf008D51@01V=SHcHf=V5QHF5QHGalO7AdM08n?Sh0
1XR8R;Fe]HR8R8R8R6EUIJn_[`9mOGd01AhN7UADE5ADE5mOGgUiN@02H61P00ICDe=UIFF>SXj>SXhW
9bL:2PX2ATI600E1@D5jNWYjNWY_KfmNGUh00WemO@06S8b<:b/[@D51@D51B4Q8ZJVY0T51@@05SHf=
Bd];>CTi>CTiI6AT00:ATI401U]KFeiNGR4Q8B4Q8B`/;6ATI08^;Rh01Sdm?E=CDdQ8B4Q8B5eMGA8B
4P:LW9`01B@T94Y:BTY:BRh^;Ve]K@025aLG00H^;RiJFUYEEEEEEEE2@T8O7al2E5AD00D/;2anOWin
OWilO7a8B4P00QXJ6P06;2`/KVi^@410@410=CDe9BDU0TM7A`05A4A4QXJ6LW9bLW9bKFe]00:XZ:P0
1X>3PgEeMC0`<30`<6][Jbd];@8Y:BT01C8b<R<S8cTi>CTi>Bh^;P02@D5100IkNg]EEEDa<C4a<C50
@413@d<2;bl_00HA4A53@d<E5ADE5ADY:BUKFe/2Ph>300F=SHfk^k^k^k]]KFdb<S800P410@06Cdm?
7AdM4a<C4a<C=cLgD51@0R4Q8@05<S8b8R8RPX:2PX:2I6AT00:OWil01ATI6HN7QinOWinOWm[JfP03
oooo00<0003oooooool03Oooo`008_ooo`050000oooooooooooo=3@d009mOGd01Ta<C75aLF5QHF5Q
HGinOVYZJP9VIVH01CLg=h>3Ph>3Pc/k>c`l?002N7Qh00Hl?3`c<c>2PX:2PX8S8b=;Bd/2P82000HR
8R9KFe]fMWIfMWJ[Zj/i>CT2FEUI00D820Pa<C4I6ATI6AT@41000UQHF006@T92G5aLG5aLG5aL3Ph>
7AdM0RDU9@06DE5ADU9BN7QhN7QhEEEE>c/k0QPH6005Kfm_K6a/Fe]KFe]KCDe=009IFET01WIfMTa<
C51@D51@D5ADE38b<P:ZZZX01U5ADD];Bbd];Bd];FUYJB0P808Y:BT01DI6AUYJFX:2PX:2PTU9B@02
Ph>300IHF5Pb<S9@D51@D50Q8B52@T82>SXj00IFEUHF5QI4A4A4A4@o?cl:2PX2Jf][00HY:BUADE5i
NGUiNGTR8R8m?Cd2IFEU00FPX:0`<30`<31MGEdP82000R/[:`06RXZ::RXZAdM7AdM7A4A4;2`/0VQX
J006:BTY5aLG=CDe=CDe9BDU2`/;0T92@P059BDU?Cdm?Cdm92@THf=S009WIfL01V][Jb<S8a/K6a/K
6cXj>VUYJ@96ATH01YjNWShn?X61PH61P@00034a<@9ADE401Clo?adM7D];Bd];Bbl_;`02Kfm_00@Q
8B5;Bd]UIFEUIFD2Bd];0Q/K6`05Lg=coooooooooooo000002koool010000?ooooooocdm?@9/K6`0
1EADE5mOGfMWIfMWIhJ6QP02IVIV00INGUhZ:RYeMGEeMGE2@T8f=SH2LW9b00Hc<c<i>CUmOGemOGdT
92AIFET2QhN700DS8b=UIFEUIFE_KfnYZJT00T10@006De=C3Ph>>3Ph>3Ph5aLG3Ph>0UeMG@05@410
GUiNGUiNGUiN410@008L71`01RDU9E5ADE5ADE5ADGYjNUEEE@8o?cl01AXJ6W=cLg1`L71`L5mOG`02
B4Q800IJFUY`L71<C4a<C4aFEUI<C4`2>3Ph00Je]KEJFUY;Bd];Bd/W9bMOGel2:b/[00Db<S8m?Cdm
?CeVIVIlO7`00TA4A006QHF5I6AT;bl_;bl_ATI6;2`/0STi>@05<30`HV9RHV9R4Q8BCTi>0095ADD0
1PP826EUIB4Q8B4Q8Di>CWalO08O7al01D=3@fQXJ9jNWYjNWS4a<@02HV9R00HM7Ad/;2b;Rh^;Rh/^
;Ri9BDT2B4Q800D];Be^KVhU9BDU9BDD51@00Rl_;`06820P4Q8BBTY:BTY::2PXA4A40Q`L7006FUYJ
KFe]KFe]KFe]6QXJ5ADE0STi>@05Fe]K>CTi>CTiUYJF;bl_009gMgL01Q4A4Bl_;eIFEUIFES4a<BXZ
:P8j>SX01Chn?V1PH14A4A4A4CTi>@02NWYj00E<C4aOGelY:BTY:BV3Ph<00oooo`030000oooooooo
00goool002;oool01@000?oooooooooooc@d=002OGem00I<C4aaLG5QHF5QHF5nOWiZJVX2IVIV00Dg
=cN3Ph>3Ph<k>c/l?3`00WQhN006?3`l<c<cPX:2PX:28b<SBd];0X20P0068R8RFe]KMWIfMWIfZj^[
>CTi0UUIF@0520P8<C4a6ATI6ATI410@009HF5P01T92@UaLG5aLG5aLG0h>3QdM7@8U9BD01U5ADE9B
DWQhN7QhN5EEEC/k>`8H61P01Fm_Kfa/K5]KFe]KFde=C@02FEUI00IfMWI<C4a@D51@D51DE5@b<S82
ZZZZ00IADE5;Bd/];Bd];BeYJFTP8202:BTY00E6ATIJFUZ2PX:2PX99BDT00X>3P`06F5QH<S8bD51@
D51@8B4Q@T920SXj>P06EUIF5QHFA4A4A4A4?clo2PX:0V][J`06:BTYDE5ANGUiNGUi8R8R?Cdm0VEU
I@05X:2P<30`<30`GEeM820P008[:b/01XZ:RRXZ:TM7AdM7AdA4A2`/;09XJ6P01RTY:ALG5cDe=CDe
=BDU9@/;2`92@T801BDU9Cdm?Cdm?B@T96=SH`02IfMW00I[Jf/S8b<K6a/K6a/j>SYYJFT2ATI600JN
WYhn?Sj1PH61PH40000a<C42DE5A00Do?clM7Ae;Bd];Bd/_;bl00Vm_K`048B4QBd];IFEUIFEU0T];
B`8K6a/01G=cLoooooooooooo`00000^oooo00@0003ooooooolm?Cd2K6a/00EDE5AOGemWIfMWIfN6
QXH00VIVIP06GUiN:RXZMGEeMGEe@T92=SHf0W9bLP06<c<c>CTiOGemOGem92@TFEUI0XN7Q`058b<S
IFEUIFEUKfm_ZJVY0090@4001U=CD`h>3SPh>3Ph>1LG5`h>3P9MGEd01D10@5iNGUiNGUiNGQ0@4002
71`L00HU9BEADE5ADE5ADE5jNWYEEED2?clo00DJ6QYcLg=`L71`L71OGel00TQ8B006FUYJL71`C4a<
C4a<EUIFC4a<0SPh>006]KFeFUYJBd];Bd];9bLWGemO0R/[:`05<S8b?Cdm?CdmIVIVO7al0094A4@0
1XF5QFATI2l_;bl_;dI6AR`/;08i>CT01C0`<69RHV9RHQ8B4Ti>CP02ADE500H820QUIFDQ8B4Q8B5>
CTilO7`27alO00E3@d=XJ6RNWYjNWYha<C400V9RHP067AdM;2`/Rh^;Rh^;;Rh^BDU90TQ8B005;Bd]
KVi^9BDU9BDU51@D008_;bl01R0P818B4TY:BTY:BRPX:4A4A08L71`01UYJFVe]KFe]KFe]KAXJ6QDE
5@8i>CT01E]KFcTi>CTi>IJFURl_;`02MgMg00HA4A4_;bmFEUIFEUHa<C4Z:RX2>SXj00Dn?SiPH60A
4A4A4A4i>CT00WYjNP05C4a<GemO:BTY:BTYPh>300?oool00`000?ooooooo`0=oooo000Roooo00D0
003ooooooooooomMGEd00WEeM@03MWIfMgMgE5AD009DE5@015]KFbHV9RHV9S@d=08A4A401UeMGF5Q
HEeMGEeMGE9BDSHf=P9WIfL01V][JaTI6F=SHf=SHb@T96][J`9ZJVX01RTY:C4a<D];Bd];Bclo?d92
@P9?Cdl01E=CDda<C4a<C3De=D92@P02:BTY00H`<30S8b=KFe]KFe]iNGUGEeL2P82000I7AdN:RXXO
7alO7alL71`@4102=SHf00DV9RHa<C4a<C4g=cM3@d<00RPX:006ATI6DU9B=3@d=3@d/k>cADE50S0`
<006EUIF;Bd];2`/;2`/2`/;9BDU0UQHF005MGEeHf=SHf=S9RHVCTi>00:>SXh01TE5AH>3PfMWIfMW
Id=3@cDe=@:/[:`01UaLG20P84A4A4A4A861PDQ8B09EEED01B8R8Ti>CR/[:b/[:f5QH@02LG5a00HY
:BTX:2Pf=SHf=SIlO7`m?Cd26a/K00I=CDe4A4A5ADE5ADEhN7P@41029BDU00DQ8B4];Be?Cdm?Cdm0
@4000Z^[Z`06GemO>3PhQhN7QhN7/;2`JVYZ0S8b<P06Ph>3=SHfMgMgMgMgGemOXj>S0U5AD@06:BTY
3`l?K6a/K6a/9bLWIFEU0S/k>`05Bd];GUiNGUiNQ8B45QHF008@41001G9bLV1PH92@T92@T55AD@03
oooo00<0003oooooool0;?ooo`040000ooooooooEUIF0X61P@05KFe]Ph>3DE5ADE5AHF5Q009?Cdl0
1RXZ:STi>@`<30`<35IFEUQHF09PH6001TQ8B2/[:eeMGEeMGEiNGRHV9P9_Kfl01C4a<Fi^KVi^KUeM
GB8R8P02=CDe00I2@T97AdLh>3Ph>3Q6ATIMGEd2@41000Dg=cM0@410@40b<S8j>SX00QLG5`06DE5A
N7QhGemOGemOSHf=@4100X:2PP0551@D:2PX3`l?3`l?<C4a008_;bl01S@d=2d];E1@D51@D2`/;3/k
>`9?Cdl01Sdm?KRh^3Ti>CTi>B@T94Y:BP8];Bd01CXj>P820P820S@d=6IVIP02J6QX00IMGEdI6AUN
GUiNGUj9RHUCDe<2OWin00E_Kfln?Shn?Shd=3Bg]kL00UADE006:BTY=CDeNWYjNWYjA4A4BTY:0QTI
6@05EEEE:2PXG5aLG5aLL71`008g=cL01QdM7D=3@gMgMgMgMc/k>a0@4094A4@01D92@Ta<C7=cLg=c
L`L71`02:BTY00HT92@/;2a>CTi>CTi3@d>YZJT2IFEU00Hl?3b4Q8Bd];Bd];AYJFTd=3@2Ph>300De
=CEiNGUiNGUOGenTY:@00U1@D006:BTY3`l?Kfm_Kfm_9bLWIVIV0SHf=P05BTY:HF5QOWinOWin61PH
008F5QH01GQhN6YZJY^KVi^KVeYJFP03oooo00<0003oooooool03Oooo`008_ooo`800002oooo00EU
IFDL71`L71a4A4AbLW800VATI005>SXj:RXZD51@D51@HF5Q0099BDT01Te=CD];Bcdm?Cdm?B8R8T10
@0:?Shl01S8b<UYJFS@d=3@d=20P81PH60871`L01S@d=34a<DU9BDU9BH20P3`l?08f=SH00dU9BH^;
Rh^;R`02K6a/0RTY:@06D51@I6ATSHf=SHf=?clo2PX:0TE5A@06FEUIGEeMQHF5QHF551@D6QXJ0UiN
GP05X:2PGemOGemOMGEe>SXj008P82001U1@D5mOGchn?Shn?SDe=FIVIP:o_kl01Pl?3cLg=cXj>SXj
>U9BDT=3@`830`<01CHf=S0`<30`<1dM7EYJFP02N7Qh00H/;2`h>3QRHV9RHV8S8b=`L702Ogmo00IZ
JVXe=CF:RXZ:RXYQHF5HF5P25aLG00DT92@n?SiSHf=SHf=8B4P00Ti>CP06VIVIKfm_JVYZJVYZJ6QX
<C4a0X>3P`06NWYjLW9b>CTi>CTiIFEU;2`/0Ta<C005@410BDU9<c<c<c<c7QhN009`L7001QTI6EAD
E2LW9bLW9eUIFDa<C09kNg/01Xj>ST];BfQXJ6QXJ38b<VMWI`90@4001TE5AD=3@a0@410@43`l?3hn
?P9fMWH01KVi^B0P820P83`l?0H61P02G5aL00EeMGGFe]I>CTi>CTkbl_800_ooo`80000^oooo0P00
0006ooooKfm_9BDU9BDU>c/kNg]k0V5QH@05<30`;2`/;2`/EeMGKfm_009EEED01Te=CC`l?3De=CDe
=AlO7cLg=`:9RHT01CXj>T];Bd92@T92@RTY:@0251@D00H>3PhS8b<U9BDU9BE?CdmfMWH2:RXZ00D`
<30g=cMlO7alO7a]KFd00V1PH00692@THV9RGEeMGEeMPX:2C4a<0Q`L7006F5QHJFUYCdm?Cdm?OWin
9BDU0QDE5@05IfMWVYZJVYZJGUiNK6a/0096ATH01QdM7E=CDeEEEEEEEDI6AR/[:`9TI6@01KZj^QLG
5d92@T92@SDe=@02Bd];00I2@T871`Lf=SHf=SHZ:RXO7al2HF5Q00F0P80];Be6ATI6ATIMGEd00S0`
<006Hf=SRHV9GUiNGUiN:2PXUiNG0U5AD@06HV9R:BTY6a/K6a/K;2`/M7Ad0SLg=`05DE5AQXJ6QXJ6
OgmoHV9R009XJ6P01TM7AginOW]kNg]kNhF5QCHf=P9ADE401BXZ:STi>CTi>C0`<5YJFP02?Shn00H<
30ajNWX@410@411IFETI6AT2GemO00E<C4adM7BCTi>CTi=4A4@00UeMG@06@410IVIVC4a<C4a<>c/k
CDe=0QXJ6P06?3`l>3PhOWinOWin/k>c7AdM0S/k>`053@d=EUIFEUIFO7alemOG009FEUH00ng]kOoo
ooooo`0200003oooo`008_ooo`050000ooooooooooooATI6009NGUh01TA4A1PH638b<S8b<Ph>3TE5
A@8T92@01FMWIi:BTY:BTZ6QXI:BTP02ZZZZ00HY:BU>CTjNWYjNWYieMGE@D502EEEE00HN7Qha<C6<
S8b<S8`;2`]7AdL251@D00Dk>c/m?CeRHV9RHV9kNg/00YfMW@06EeMG<C4aD51@D51@?ShnC4a<0c0`
<005>c/kXZ:RXZ:RBDU9M7Ad009[Jf/01Kbl_6UYJDI6ATI6APP820024A4A00IEEED92@Tk>c/k>c/H
61QVIVH2EeMG00HJ6QXf=SIkNg]kNg]PH60N7Qh25aLG00E:BTYSHf<o?clo?cmMGEd00QlO7`06Kfm_
BTY:Hf=SHf=S@d=33@d=0Q@D50064a<CBDU9<S8b<S8bEeMG2@T90W5aL@06:RXZ9bLW>c/k>c/k7QhN
5aLG0Q<C4`05CTi>=3@d=3@dQHF53`l?009FEUH01Va/K28R8RDU9BDU9Da<C5mOG`8S8b<01Rl_;dY:
BSXj>SXj>QXJ6Rd];@92@T801C/k>cDe=CDe=E9BDQ`L7002FEUI00I3@d=4A4A>CTi>CTi5ADD_;bl2
GemO00IPH60>3Ph[:b/[:b][Jf]EEED2C4a<00DU9BEbLW9/K6a/K6a>CTh00Sdm?@06?3`l>SXjTI6A
TI6A:BTYB4Q80[fm_@05De=Coooooooooooo000002koool010000?ooooooode=C@9OGel01DI6AQ@D
52PX:2PX:0L71`02B4Q800H_;bmdM7BMWIfMWIfIVIVNWYh2X:2P00HT92ABDU:OWinOWin3Ph==CDd2
D51@00DN7Qhc<c<c<c>LW9`20P800Shn?P067AdM=CDe<C4a<C4aEEEEPH610Y6AT@05C4a<:b/[:b/[
ATI6Bd];0094A4@01R<S8c/k>c<c<c<c<jn_[cdm?@9]KFd01F5QHKjn_W9bLW9bLT10@002000000H=
3@e>CThA4A4A4A4n?ShA4A42K6a/00ICDe<M7Adb<S8b<S:1PH5MGEd27alO00DH61Q<C4a<C4aVIVI0
@4000UeMG@067QhNKVi^B4Q8B4Q8HF5QAdM70Q0@40056QXJ3@d=3@d=C4a<;bl_009@D5000a0@47=c
Lc4a<@02<C4a00E6ATHR8R8R8R8M7AdP82000UaLG005:RXZO7alO7al4A4AB4Q8009^KVh01QHF5R/[
:eaLG5aLG5IFER/[:`8V9RH01CXj>Rl_;bl_;adM7C8b<P02De=C00I9BDU3@d=@D51@D50B4Q9BDU82
?Cdm00Df=SI<C4`j>SXj>SXc<c<00UiNGP06EUIF3`l?9BDU9BDUH61PHf=S0Te=C@068B4QNg]kLG5a
LG5aEEEE=CDe0Sdm?@05@d=3RHV9RHV9<c<c?Shn00:e]KD01D];Boooooooooooo`00000?oooo000R
oooo00D0003ooooooooooom6ATH00UiNGP06A4A461PH<S8b<S8b3Ph>ADE50R@T9005IfMWTY:BTY:B
XJ6QTY:B00:ZZZX01RTY:Di>CYjNWYjNWWEeME1@D09EEED01QhN7S4a<Hb<S8b<S0/;2dM7A`8D51@0
1C/k>cdm?F9RHV9RHW]kN`02WIfM00IGEeLa<C5@D51@D50n?Si<C4`3<30`00Dk>c^RXZ:RXZ99BDUd
M7@00V][J`05_;blJFUYATI6ATI620P8008A4A401UEEE@T92C/k>c/k>aPH66IVIP9GEeL01QXJ6SHf
=W]kNg]kNf1PH1hN7P8G5aL01DY:BV=SHclo?clo?eeMG@027alO00I_Kfm:BTYSHf=SHf=3@d<=3@d2
51@D00HC4a=9BDTb<S8b<S9GEeL92@T2LG5a00HZ:RXW9bLk>c/k>c/N7QhG5aL24a<C00E>CThd=3@d
=3B5QHD?3`l00UIFEP06K6a/8R8R9BDU9BDUC4a<GemO0R<S8`06;bl_BTY:>SXj>SXj6QXJ;Bd]0T92
@P05>c/k=CDe=CDeDU9B71`L009IFET01T=3@dA4A4i>CTi>CTE5ABl_;`9OGel01V1PH0h>3R/[:b/[
:f][JeEEE@9<C4`01BDU9G9bLVa/K6a/K4i>CP02?Cdm00Hl?3`j>SZATI6ATI4Y:BU8B4P2_Kfm00EC
De?oooooooooool00000;_ooo`040000ooooooooCDe=0UmOG`05ATI651@D:2PX:2PX1`L70098B4P0
1Rl_;gAdM9fMWIfMWIVIVIjNWP:PX:001R@T959BDYnOWinOWh>3Pde=C@9@D5001AhN7S<c<c<c<ibL
W0820P02?Shn00HM7Ade=CDa<C4a<C5EEEF1PH42TI6A00E<C4`[:b/[:b]6ATI;Bd/00TA4A0068b<S
>c/k<c<c<c<c[jn_?Cdm0Ve]K@05HF5Q_[jnLW9bLW9b@410008000001Pd=3Di>CQ4A4A4A4Chn?Q4A
4@9/K6`01U=CDadM7C8b<S8b<X61PEeMG@8O7al01APH64a<C4a<C6IVIT10@002GEeM00HN7Qi^KVi8
B4Q8B4QQHF57AdL2410@00DJ6QX=3@d=3@e<C4`_;bl00U1@D003410@Lg=c<C4a008a<C401DI6AR8R
8R8R8QdM7B0P8002G5aL00DZ:RYlO7alO7`A4A58B4P00Vi^KP065QHF:b/[G5aLG5aLEUIF:b/[0RHV
9P05>SXj;bl_;bl_7AdM<S8b009CDe<01TU9BD=3@e1@D51@D18B4U9BDP8m?Cd01CHf=Ta<C3Xj>SXj
>S<c<`02GUiN00IFEUH?3`lU9BDU9BEPH61SHf<2CDe=00HQ8B5kNg]aLG5aLG5EEEDe=CD2?Cdm00E3
@d>9RHV9RHTc<c<n?Sh00[Fe]@05Bd];oooooooooooo000000ooool002;oool010000?oooooooooo
o`=:BTX01V9RHZJVYZ:RXZ:RXUmOGi6AT@8A4A401F1PH0H61PH61V1PH492@P02E5AD00J7QhMADE5[
Jf][Jf]kNg]eMGD2RXZ:00I9BDTF5QJo_kno_km8B4Pe=CD2>SXj00E<C4aBDU8820P820Q=CDd00UMG
E`06GemO6QXJTI6ATI6ASXj>GEeM0V=SH`06;2`/OGemH61PH61PCTi>a/K60V9RHP05LG5a?Shn5QHF
5QHF8B4Q008`<3001QPH66MWIf1PH61PH4E5AC`l?09fMWH2HV9R0SDe=@067QhN=SHf8b<S8b<S51@D
R8R80PT92@05De=C7AdM7AdMA4A4FEUI008K6a/01U9BDU5ADADE5ADE5E5AD@/;2`9=CDd01RLW9clo
?gmoOgmoOaXJ6RTY:@9YJFT01@d=3K6a/FUYJFUYJB4Q8@02_kno00HH61QLG5`Z:RXZ:RXb<S8K6a/2
GUiN00H>3PjJVYX_;bl_;blJ6QY5ADD230`<00DZ:RX<30aQHF5QHF4O7al00S<c<`06BDU9:b/[DU9B
DU9B=cLgCDe=0R8R8P8o?cl2DU9B00HK6a/j>SZ<S8b<S8`S8b=9BDT2;Bd]00ECDe=fMWHP820P8212
@T800W5aL@06=SHfU9BD:RXZ:RXZG5aL<30`0TE5A@05QHF5oooooooooooo000002koool010000?oo
ooooode=C@98B4P01F5QHJJVYZ:RXZ:RXUmOG`02TI6A00H@411PH6051@D51@ESHf=2@T82EUIF00J9
RHUCDe=[Jf][Jf]lO7agMgL2SHf=00E;Bd/G5aLG5aNo_km8B4P00S@d=006>c/kBTY:EEEEEEEE2`/;
Cdm?0UQHF005I6AT6a/K6a/KU9BDS8b<009PH6001UmOGbh^;WYjNWYjNUaLG5ADE0;6a/H01FYZJWIf
MTI6ATI6AQhN7P026ATI00HX:2PK6a]UIFEUIFEZJVY;Bd/2=SHf00IoOgmJFUYLG5aLG5`h>3PV9RH2
;Bd]00DK6a/;2`/;2`^:RXX<30`00Ti>CP065ADE?3`lDe=CDe=C9RHVDe=C0UaLG0054a<CEeMGEeMG
5ADEADE5008P82001STi>GmoOa@D51@D52`/;7=cL`861PH01Jb/[7=cLa/K6a/K6kno_`024Q8B00IJ
FUX/;2`_;bl_;blL71aIFET22`/;00FJVYXd=3@Q8B4Q8B53@d<00Q4A4@06;Rh^1`L7Hf=SHf=S7alO
;bl_0TI6AP06;bl_F5QH>c/k>c/kDU9B9BDU0d=3@`9EEED01Q/K6cPh>8j>SXj>SRHV9Ta<C08a<C40
1UEEEGAdM28R8R8R8T10@7AdM08e=CD01INGUbPX:2PX:61PH2h^;P02AdM700F5QHGoooooooooool0
00003oooo`008_ooo`050000oooooooooooo_kno009]KFd01YZJV/g=cGEeMGEeMG1`L34a<@9LG5`0
1E=CDfMWIfMWIe=CDgQhN00292@T00J@T90>3PhU9BDU9BEUIFEDE5@2?Shn00HU9BDb<S9RHV9RHV9T
I6@D51@2IfMW00DC4a=lO7aFEUIFEUHm?Cd00Tm?C`0661PHCTi>820P820PJ6QX51@D0U=CD`06Lg=c
R8R8ADE5ADE59bLW8b<S0T];B`05G5aLFUYJDU9BDU9BPH61008F5QH01UUIFD];Bf=SHf=SHclo?b/[
:`9kNg/01Ta<C6IVIT];Bd];Be=CDeUIF@8i>CT01B`/;7alO18B4Q8B4T];B`02BDU900JGUiMbLW8R
8R8R8R9QHF4;2`/2EEEE00I5ADE2@T8F5QHF5QHB4Q892@T2;2`/00IjNWZGUiLm?Cdm?CehN7Q7AdL2
NWYj00F@T93GemOGemLk>c]JFUX00XJ6QP06RHV93Ph>XJ6QXJ6Q;Bd][Zj^0RHV9P8W9bL2@41000Dj
>SX71`LV9RHV9RHG5aL00SPh>006;bl_:BTYDe=CDe=CQhN7IfMW0VIVIP0692@TR8R8:RXZ:RXZE5AD
IFEU0YNGU`067QhNeMGE?Shn?Shn?cloX:2P0_?cl`05?3`l:2PX:2PXGemOHf=S008;2`/01GEeMHJ6
QR/[:b/[:iZJVP03oooo00<0003oooooool0;?ooo`040000oooooooob<S80VQXJ005UYJFclo?LW9b
LW9bLG5a008];Bd01UeMGEUIFFIVIVIVIUMGEgMgM`8Z:RX01Y6ATADE5B8R8R8R8UmOGe1@D095ADD0
1B4Q8CTi>CTi>EQHF5UIF@027AdM00ILG5`N7QigMgMgMgMNGUhi>CT2DE5A00DN7QiNGUiNGUh/;2aP
H6000PX:2P06F5QHHf=SOgmoOgmo>SXj5QHF0R8R8P05CDe=Hf=SCTi>CTi>HV9R009aLG401Q4A4DI6
ASPh>3Ph>6e]KE5AD@8n?Sh018F5QC/k>f=SHf=SH`93@d<2BTY:00Df=SHN7QhN7Qi/K6`O7al00Sdm
?@06DU9BUIFENWYjNWYj;bl_L71`0PT92@05GUiNBd];Bd];?Cdm3`l?008M7Ad01P<30bTY:GMgMgMg
MinOWd92@P9gMgL01Da<C79bLYJFUYJFU]7Ad@02ADE500IDE5BEUIF0P820P8020P:FUYH2;bl_00F/
[:``<30f=SHf=SHT92@00U1@D006<30`3`l?=cLg=cLg92@T:2PX0Shn?P06=CDeCDe=UiNGUiNGIfMW
FEUI0Q/K6`05TI6A;Bd];Bd]De=CFEUI00:?Shl01RHV9]cLg4a<C4a<C4e=CIRHV0;oool01C<c<c@d
=5mOGemOGe]KF`024a<C00EfMWIoOglT92@T92BDU9@00oooo`030000oooooooo00goool001Soool3
00000_ooo`030000oooooooo00;oool01@000?oooooooooooh^;R`02MgMg00IcLg=<C4`j>SXj>SYG
EeMQHF42U9BD00DG5aLR8R8R8R8K6a^DU9@00Q<C4`06@D51B4Q86a/K6a/KF5QHKVi^0UIFEP06JVYZ
AdM7GUiNGUiN:2PX5ADE0Ve]K@05FEUI@T924a<C4a<CEEEE008=3@d01PP824Y:BR/[:b/[:bl_;d92
@P8i>CT01W=cLh^;Rc4a<C4a<BXZ:UQHF09;Bd/01DI6AX61PDI6ATI6ATM7A`02OWin00H30`=TI6@N
7QhN7Qh`<30M7Ad29BDU00IXJ6QhN7P30`<30`>KVi/_;bl261PH00E8B4QPH60Z:RXZ:RYTI6@00Tm?
C`06ADE5E5ADFEUIFEUI7alO@d=30UmOG`06D51@@D51GUiNGUiN>3Ph8b<S0V1PH0067AdML71`820P
820PIfMWDU9B0QTI6@05:RXZVIVIVIVI410@@410009EEED01SHf=R`/;9fMWIfMWB/[:eaLG08>3Ph0
1Q0@43hn?QDE5ADE5BPX:0`<30:8R8P01B/[:d51@D51@F9RHUmOG`02<C4a00HW9bLD51A7AdM7AdNL
W9aiNGT2@T9200I@D52WYjLL71`L71a1@D5eMGD2B4Q800Di>CT`<32OWinOWimZJVX00UiNGP065QHF
I6AT9BDU9BDU<c<cC4a<0[>c/`05De=Coooooooooooo000002Coool300000_ooo`030000oooooooo
00;oool010000?ooooooohZ:RP9nOWh01GUiNE=CDd51@D51@E1@D002IfMW00JATI4O7alR8R8R8R8U
9BF:RXX261PH00I7AdLl?3`X:2PX:2Q>CTiUIFD2EEEE00ENGUi?Cdm?CdmJFUXN7Qh00R0P8006JVYZ
BTY:?Shn?Shn92@TFe]K0PH61P054A4AF5QHF5QH:b/[;bl_008e=CD01S@d=8J6QXJ6QXJ6QRTY:CLg
=`96ATH01E9BDUADE7=cLg=cLd51@@02ADE500I^KVhA4A5HF5QHF5PL71`o?cl2;2`/00HE5AE[Jf]_
Kfm_Kfl?3`n=SHd28R8R00DW9bLk>c/k>c]KFe/g=cL00UMGE`06GEeMCdm?G5aLG5aLIFEU9bLW0Shn
?P05Jf][Bd];Bd];AdM7IfMW008o?cl01QTI6F=SHa/K6a/K6fa/K1lO7`9aLG401De=CA8B4S@d=3@d
=9VIV@026ATI00Hi>CUNGUh^;Rh^;RhS8b>FUYH2=3@d00EGEeL71`L820P820Q4A4@00Q/K6`068B4Q
1PH6RXZ:RXZ:<c<cBDU90V9RHP06IFEU>3Ph:RXZ:RXZ410@@T920YVIV@05MWIfAdM7AdM7D51@Zj^[
008I6AT01Shn?W=cLdY:BTY:BSTi>C<c<`:PX:001Fa/K5aLG1PH61PH669RHP02:2PX00Dd=3A>CTjg
]kNg]kMEEED00oooo`030000oooooooo00goool001Woool01P000?ooooooo`000?ooo`0000?oool0
1@000?oooooooooooh^;R`02MgMg00IcLg=<C4`j>SXj>SYGEeMQHF42U9BD00DG5aLR8R8R8R8K6a^D
U9@00Q<C4`06@D51B4Q86a/K6a/KF5QHKVi^0UIFEP06JVYZAdM7GUiNGUiN:2PX5ADE0Ve]K@05FEUI
@T924a<C4a<CEEEE008=3@d01PP824Y:BR/[:b/[:bl_;d92@P8i>CT01W=cLh^;Rc4a<C4a<BXZ:UQH
F09;Bd/01DI6AX61PDI6ATI6ATM7A`02OWin00H30`=TI6@N7QhN7Qh`<30M7Ad29BDU00IXJ6QhN7P3
0`<30`>KVi/_;bl261PH00E8B4QPH60Z:RXZ:RYTI6@00Tm?C`06ADE5E5ADFEUIFEUI7alO@d=30UmO
G`06D51@@D51GUiNGUiN>3Ph8b<S0V1PH0067AdML71`820P820PIfMWDU9B0QTI6@05:RXZVIVIVIVI
410@@410009EEED01SHf=R`/;9fMWIfMWB/[:eaLG08>3Ph01Q0@43hn?QDE5ADE5BPX:0`<30:8R8P0
1B/[:d51@D51@F9RHUmOG`02<C4a00HW9bLD51A7AdM7AdNLW9aiNGT2@T9200I@D52WYjLL71`L71a1
@D5eMGD2B4Q800Di>CT`<32OWinOWimZJVX00UiNGP065QHFI6AT9BDU9BDU<c<cC4a<0[>c/`05De=C
oooooooooooo000002Goool01P000?ooooooo`000?ooo`0000?oool010000?ooooooohZ:RP9nOWh0
1GUiNE=CDd51@D51@E1@D002IfMW00JATI4O7alR8R8R8R8U9BF:RXX261PH00I7AdLl?3`X:2PX:2Q>
CTiUIFD2EEEE00ENGUi?Cdm?CdmJFUXN7Qh00R0P8006JVYZBTY:?Shn?Shn92@TFe]K0PH61P054A4A
F5QHF5QH:b/[;bl_008e=CD01S@d=8J6QXJ6QXJ6QRTY:CLg=`96ATH01E9BDUADE7=cLg=cLd51@@02
ADE500I^KVhA4A5HF5QHF5PL71`o?cl2;2`/00HE5AE[Jf]_Kfm_Kfl?3`n=SHd28R8R00DW9bLk>c/k
>c]KFe/g=cL00UMGE`06GEeMCdm?G5aLG5aLIFEU9bLW0Shn?P05Jf][Bd];Bd];AdM7IfMW008o?cl0
1QTI6F=SHa/K6a/K6fa/K1lO7`9aLG401De=CA8B4S@d=3@d=9VIV@026ATI00Hi>CUNGUh^;Rh^;RhS
8b>FUYH2=3@d00EGEeL71`L820P820Q4A4@00Q/K6`068B4Q1PH6RXZ:RXZ:<c<cBDU90V9RHP06IFEU
>3Ph:RXZ:RXZ410@@T920YVIV@05MWIfAdM7AdM7D51@Zj^[008I6AT01Shn?W=cLdY:BTY:BSTi>C<c
<`:PX:001Fa/K5aLG1PH61PH669RHP02:2PX00Dd=3A>CTjg]kNg]kMEEED00oooo`030000oooooooo
00goool001Ooool4000000Coool0003oool00003oooo0P0000;oool01H20P0T92@T92Clo?aPH6002
JVYZ00DQ8B6XZ:PH61PH61QMGEd00SLg=`0661PH3Ph>@d=3@d=3De=C<S8b0STi>@06BDU9Fe]K<C4a
<C4a:RXZD51@0W=cL`066ATI5aLG=cLg=cLgR8R8;Bd]0QLG5`05/[:bb<S8b<S8Fe]K>c/k008a<C40
1R@T938b<T];Bd];Bh:2PTa<C08G5aL01V9RHU5ADBDU9BDU9C/k>hR8R08W9bL01IFEUCLg=cLg=dA4
A9:BTP02?Cdm00H_;blk>c/c<c<c<c=/K6`X:2P2CTi>00I6ATH820P_;bl_;bla<C4A4A427AdM00D[
:b]YJFUYJFT@411hN7P00S`l?006@d=3GEeM7QhN7QhNCdm?5ADE0[>c/`06CTi>20P8I6ATI6AT92@T
;bl_0Q4A4@05=3@dA4A4;2`/;2`/MGEe009;Bd/01T=3@a<C4b8R8R8R8TM7AhN7Q`8[:b/01QhN7Rd]
;A8B4Q8B4Rh^;RLW9`9?Cdl01EMGEb<S8f=SHf=SHcPh>002?Cdm0T10@08n?Sh01Rh^;VYZJRLW9bLW
9alO7dU9B@9KFe/01R4Q8EeMGFe]KFe]KEMGEbPX:08G5aL01A`L73De=FATI6ATI<O7a`02D51@00I]
KFdg=cLe=CDe=CDk>c]NGUh2Hf=S00>JVY[oooooool00P0002?oool4000000Coool0003oool00003
oooo0P000006ooooS8b<5QHF5QHFCdm?8B4Q0UaLG0059BDUVi^KVi^K9RHVGUiN008Z:RX01Q0@4041
0D10@410@5mOGcLg=`8j>SX01EADE51@D2TY:BTY:B0P8002ATI600IkNg/K6a/F5QHF5QHm?Cf5QHD2
=3@d00DA4A6h^;S5aLG5aLEOGel00T10@006:RXZ7QhN<c<c<c<cA4A4RXZ:0U9BDP064A4AJVYZCDe=
CDe=:b/[?clo0XV9R@05:b/[TI6ATI6A=cLg@D5100:ATI401Shn?S8b<T10@410@3Hf=VUYJ@8];Bd0
1Da<C4E5A@/;2`/;2c<c<`02=3@d00H@410Q8B4_;bl_;bm]KFdD51@2NWYj00Dn?Si1@D5QHF5QHF4N
7Qh00U9BDP064A4A]KFeBTY:BTY:30`<H61P0R0P8006=3@d30`<=3@d=3@d?clo:b/[0WEeM@05BTY:
@d=3@d=36QXJ7alO0090@4001X^;Rb@T92DU9BDU9BTY:AXJ6P8_;bl01AdM7EYJFUYJFUADE2PX:002
FEUI00H_;blo?cle=CDe=CE;Bd]:BTX2>c/k00EOGelQ8B4S8b<S8b=<C4`00UYJFP06:2PXIfMWKFe]
KFe]EEEE9bLW0QHF5P06:b/[<S8bJ6QXJ6QX`L71EEEE0V9RHP05:BTY:b/[:b/[BTY:EEEE009UIFD0
0iBDU?ooooooo`0200003oooo`005oooo`030000oooo000000;oool00`000?ooo`000003oooo00D0
003oooooooooooo=cLd00TU9B@06:BTYFe]K5aLG5aLGHf=SOWin0UEEE@054Q8B71`L71`LHF5QH61P
008Z:RX01TE5AAlO7d10@410@8n?Sc`l?08A4A401PD51F=SHeEEEEEEEC4a<Bd];@8O7al01Clo?f][
Je]KFe]KFe1@D002JFUY00I8B4Q<C4`_;bl_;bm;Bd/B4Q829bLW00I:BTY5ADEOGemOGelC4a<71`L2
DU9B00ERHV9EEEDN7QhN7QicLg<00Vm_K`06BDU9/K6aATI6ATI6GEeMJFUY0WYjNP068B4Q>SXjDU9B
DU9B820P:RXZ0RPX:005DE5A>c/k7AdM7AdMHV9R008g=cL01S0`<2/[:emOGemOGiRHV7QhN09RHV80
1RHV9S<c<g1`L71`L2DU9Di>CP8N7Qh01T=3@cHf=Pl?3`l?3cXj>Shn?P9ADE401G]kNemOGemOGeMG
Eclo?`02A4A400I:BTYWIfMDE5ADE5AMGEdW9bL2:RXZ00J:RXY8B4Pa<C4a<C5aLG4_;bl2?Cdm00DF
5QHJ6QXJ6QY2@T9QHF400Rh^;P06NGUi/[:bFe]KFe]KOgmoJf][0QlO7`06;Rh^IfMWM7AdM7AdCDe=
71`L0VIVIP058R8R6a/KWIfMWIfMBDU9009BDU801TM7AdE5ADY:BTY:BSXj>VEUI@:HV9P01I>CTooo
ooooooooo`00000Soooo00<0003oool000000_ooo`030000oooo000000?oool010000?ooooooolc<
c09CDe<01AlO7eiNGQlO7alO7fUYJ@02L71`00IUIFD92@T[:b/[:b]PH61WIfL2;Bd]00IBDU8K6a]1
@D51@D6DU9@b<S8271`L00D:2PYMGEeMGEe?Cdlk>c/00S0`<0065QHFBDU9LG5aLG5aEUIFBDU90W5a
L@05Cdm?CTi>CTi>;2`/CTi>008B4Q801R<S8da<C410@410@5]KF`l?3`8;2`/01EQHF69RHUQHF5QH
F1XJ6P02NGUi00I^KVi;Bd^c/k>c/k=7AdMNGUh2J6QX00ImOGdL71`g=cLg=cMIFETV9RH2:2PX00D/
;2a=CDe=CDdh>3PS8b<00UeMG@06=3@d;2`/9RHV9RHVFUYJWinO0WIfMP05J6QX:b/[:b/[<c<cKfm_
008S8b<01Te=CB8R8T10@410@3@d=0h>3P8l?3`01Cdm?E9BDW]kNg]kNf1PH002F5QH00I0@416ATI:
BTY:BTYYJFUFEUH2H61P00DZ:RXY:BV8R8R8R8Q9BDT00SLg=`06K6a/<C4a>c/k>c/k3`l?7AdM0T10
@006JFUY:RXZOGemOGem[Zj^EEEE0WEeM@05MgMg6ATI6ATI:2PXGemO00:2PX801TQ8B2LW9gAdM7Ad
M1@D51PH60:VYZH01C`l?4E5AEIFEUIFESPh>002?3`l00Da<C5RHV:;Rh^;Rh^<S8`00oooo`030000
oooooooo00goool001Soool200000_ooo`030000oooo000000?oool01@000?oooooooooookfm_@02
8B4Q00IdM7BHV9QeMGEeMGDc<c<j>SX230`<00ELG5aBDU9BDU9eMGEaLG400QdM7@06OGem2PX:JFUY
JFUYSXj>1@D50WIfMP06;Bd]9bLWPh>3Ph>3De=CD51@0VQXJ0059bLW9BDU9RHV9RHV8B4Q008H61P0
1QhN7T92@T=3@d=3@c<c<b<S8`8/;2`01Q4A4BHV9UYJFUYJFTQ8B2TY:@8i>CT01F][Jclo?dA4A4A4
A5UIF@02NWYj00H];BdR8R8S8b<S8b<];BemOGd2DE5A00Hl?3`m?Ce8B4Q8B4QGEeMRHV828B4Q00D6
1PIHF5PD51@D51@d=3@00RXZ:P06>SXj?ShnCDe=CDe=;Bd]<S8b0V][J`06LW9b>3Ph;Bd];Bd]@D51
DU9B0W9bLP06?clo?Cdm?Cdm?CdmFe]KMGEe0Tm?C`05CTi>D51@D51@I6ATJFUY008e=CD01S<c<gin
OT10@410@5EEEDe=C@8k>c/01[6a/C8b<TU9BDU9BATI6C/k>`9;Bd/01BHV9X61PH61PEADE7moO`02
Ph>300HZ:RYbLW9TI6ATI6AVIVHg=cL2GEeM00JLW9a[Jf]5ADE5ADD>3PhJ6QX23`l?00DG5aMDE5AI
FEUIFEUSHf<00TU9B@06LG5a92@TDU9BDU9BShn?@4100U1@D005<c<coooooooooooo000002Coool2
00000_ooo`030000oooo000000?oool010000?ooooooojf][@8G5aL01H61PHn?Sh:2PX:2PRPX:002
ATI600HL71aKFe]QHF5QHF5nOWieMGD23@d=00J9RHTI6AUSHf=SHf>9RHT?3`l2OGem00Dk>c/T92@T
92AhN7QNGUh00T];B`06HV9R:RXZ:BTY:BTY7AdM92@T0Q`L70059BDUBDU9BDU9?3`l<30`00<V9RH0
1A4A4BLW9bLW9e]KFdI6AP02;Rh^00Di>CU_Kfll?3`l?3a7AdL00UaLG006Ng]k;Bd]9bLW9bLW7alO
:BTY0WYjNP06CDe=>CTi?Shn?ShnBTY:E5AD0UmOG`057AdM0`<30`<3EEEE4a<C008h>3P01RDU9D10
@3Xj>SXj>UADE2LW9`8g=cL01FQXJ7]kNg]kNc4a<CDe=@02@d=300IHF5Q_Kfm7AdM7AdLh>3Q6ATH2
DU9B00F1PH5@D51HF5QHF5QLG5`00UeMG@06MGEe:2PX?Cdm?CdmQ8B4AdM70T];B`05BTY:=3@dYjNW
YjNW9BDU0093@d<01RTY:C/k>eaLG5aLG3De=G5aL@94A4@01Vm_Kg5aLAhN7QhN7WemOFIVIP9TI6@0
1DA4A5EEEEEEEI^KVeaLG002EeMG00HL71`N7Qh820P820P/;2a8B4P2DE5A00E@D50m?Ce[Jf][Jf/h
>3P00Slo?`05SXj>>c/kCTi>CTi>@T9200?oool00`000?ooooooo`0=oooo000Ioooo00D0003ooooo
ooooool000001?ooo`050000oooooooooooo_Kfm008Q8B401WAdM9RHV7EeMGEeMC<c<cXj>P8<30`0
1EaLG59BDU9BDWEeMG5aL@027AdM00ImOGd:2PYYJFUYJFV>SXh51@D2MWIf00H];BdW9bN3Ph>3Ph=C
De=@D502J6QX00DW9bLU9BDV9RHV9RHQ8B400QPH60067QhN@T92@d=3@d=3<c<c8b<S0R`/;0064A4A
9RHVFUYJFUYJB4Q8:BTY0STi>@05Jf][?cloA4A4A4A4FEUI009jNWX01Rd];B8R8R<S8b<S8bd];Gem
O@9ADE401S`l?3dm?DQ8B4Q8B5MGEf9RHP8Q8B401@H61UQHF1@D51@D53@d=002:RXZ00Hj>SXn?Si=
CDe=CDd];Bdb<S82Jf][00IbLW8h>3P];Bd];Be1@D5BDU82LW9b00Ho?clm?Cdm?Cdm?CeKFe]eMGD2
Cdm?00E>CTi@D51@D51TI6AYJFT00SDe=@06<c<cOWin@410@410EEEECDe=0S/k>`06/K6a<S8bBDU9
BDU96ATI>c/k0T];B`059RHVPH61PH61E5ADOgmo00:3Ph<01RXZ:W9bLVATI6ATI6IVISLg=`9MGEd0
1YbLW6][JdE5ADE5A@h>3QXJ6P8?3`l01ALG5eADE5UIFEUIFF=SH`02BDU900IaLG4T92ABDU9BDU:?
Shm0@402D51@00Dc<c?oooooooooool000009Oooo`050000oooooooooooo000000Coool010000?oo
ooooojf][@8G5aL01H61PHn?Sh:2PX:2PRPX:002ATI600HL71aKFe]QHF5QHF5nOWieMGD23@d=00J9
RHTI6AUSHf=SHf>9RHT?3`l2OGem00Dk>c/T92@T92AhN7QNGUh00T];B`06HV9R:RXZ:BTY:BTY7AdM
92@T0Q`L70059BDUBDU9BDU9?3`l<30`00<V9RH01A4A4BLW9bLW9e]KFdI6AP02;Rh^00Di>CU_Kfll
?3`l?3a7AdL00UaLG006Ng]k;Bd]9bLW9bLW7alO:BTY0WYjNP06CDe=>CTi?Shn?ShnBTY:E5AD0UmO
G`057AdM0`<30`<3EEEE4a<C008h>3P01RDU9D10@3Xj>SXj>UADE2LW9`8g=cL01FQXJ7]kNg]kNc4a
<CDe=@02@d=300IHF5Q_Kfm7AdM7AdLh>3Q6ATH2DU9B00F1PH5@D51HF5QHF5QLG5`00UeMG@06MGEe
:2PX?Cdm?CdmQ8B4AdM70T];B`05BTY:=3@dYjNWYjNW9BDU0093@d<01RTY:C/k>eaLG5aLG3De=G5a
L@94A4@01Vm_Kg5aLAhN7QhN7WemOFIVIP9TI6@01DA4A5EEEEEEEI^KVeaLG002EeMG00HL71`N7Qh8
20P820P/;2a8B4P2DE5A00E@D50m?Ce[Jf][Jf/h>3P00Slo?`05SXj>>c/kCTi>CTi>@T9200?oool0
0`000?ooooooo`0=oooo000Roooo00D0003oooooooooooo7alL00R@T9006AdM77QhNFEUIFEUIMWIf
NGUi0SHf=P05H61P7AdM7AdMXJ6Q8R8R008T92@01U=CDdI6AR8R8R8R8YjNWUmOG`92@T801Rl_;dU9
BF9RHV9RHPT92C/k>`;Lg=`01F=SHeUIFA/K6a/K6fa/K002Ogmo00H51@E9BDUCDe=CDe<>3PhZ:RX2
I6AT00HS8b<B4Q9[Jf][Jf/C4a=5ADD22`/;00EGEeN3Ph=QHF5QHF4P82000V5QH@06?CdmBDU9<30`
<30`C4a<=cLg0Rl_;`0671`LE5AD>SXj>SXjQhN7GEeM0Ph>3P0571`LPX:2GEeMGEeM71`L008U9BD0
1SPh>6IVIPl?3`l?3eYJFQPH609SHf<01U9BDRDU9B8R8R8R8RDU9@H61P8I6AT01Va/K6i^KX20P820
P6UYJD=3@`8o?cl01DY:BS<c<c<c<eYJFQDE5@02410@00IADE57AdMUIFEUIFDe=CDc<c<2<C4a00H]
;BdU9BD^;Rh^;RhY:BTH61P2?clo00E@D51IFEUIFETC4a>2PX800W5aL@06B4Q8:BTYB4Q8B4Q8GEeM
8b<S0WalO006:RXZQ8B4QHF5QHF5P820VIVI0SDe=@055ADERHV9PX:2PX:2C4a<00:HV9P01V1PH2h^
;UMGEeMGEdE5AEEEE@8@41001H61POooooooooooo`00000^oooo00@0003oooooooo4a<@27alO00E:
BTXN7QiGEeMGEeMcLg<00X61P@06<30`IfMW8B4Q8B4QYJFU92@T0RTY:@06EEEEBd];9RHV9RHVWYjN
IFEU0TM7A`05=3@dCDe=CDe=GUiN2@T9008j>SX01]WIfFQXJ5EEEEEEEB0P871`L09nOWh01@/;2dA4
A4A4A51@D0X:2P02:BTY00IWIfLX:2PD51@D51A`L70=3@d2@d=300DB4Q9BDU::RXZ:RXYMGEd00RLW
9`06Hf=S?CdmAdM7AdM7:BTYC4a<0SPh>0069bLW5ADEEeMGEeMG<c<cRHV90UIFEP054A4A51@D51@D
PH61EUIF008U9BD01Q`L7492@V1PH61PH1LG5eiNGP8S8b<01EUIFEmOGemOGa/K6aLG5`02<C4a00HB
4Q8>3PiQHF5QHF5]KFf9RHT2JFUY00E@D50a<C5HF5QHF5P[:b/00UmOG`0692@T10@4FEUIFEUIF5QH
EeMG0TE5A@05>CTi8B4Q7AdM7AdM5ADE008V9RH01S@d=1lO7e1@D51@D69RHTU9B@8;2`/01WAdM69R
HUMGEeMGEcPh>4Q8B09?Cdl01C<c<fi^KVi^KSXj>XN7Q`02N7Qh00J@T92?Shle=CDe=CDS8b>5QHD2
MgMg00EHF5R?ShmFEUIFEUH_;bl00UQHF005?cloGEeM2PX:2PX:RXZ:00?oool00`000?ooooooo`0=
oooo000Roooo00D0003ooooooooooon@T9000Ta<C006>3PhYjNWD51@D51@T92@Jf][0VUYJ@05EUIF
MWIfMWIfT92@J6QX008E5AD01YJFURXZ:S8b<S8b<R4Q8Cdm?@8g=cL01UeMGEUIFA0@410@41dM7Bl_
;`9fMWH01ALG5cXj>UIFEUIFET51@@02FUYJ00Hk>c/Z:RY3@d=3@d=0@41BDU82?Cdm00I8B4P`<31J
FUYJFUY?CdlI6AT29RHV00DA4A5JFUYSHf=SHf<o?cl00VQXJ096ATH2D51@00Jm_Ke2@T8Z:RXZ:RZ0
P81EEED2<S8b00H/;2`G5aLh>3Ph>3Pd=3@T92@2<c<c00A1@D55ADE5ADDg=cL37AdM00F9RHT^;Rh]
;Bd];BdX:2P00bTY:@067AdMATI64A4A4A4Ad];BHf=S0UIFEP05KFe]61PH<c<c<c<cH61P008i>CT0
1RLW9a@D52XZ:RXZ:RPX:8F5Q@9IFET01/_;bc8b<UeMGEeMGBXZ:Q0@409;Bd/01C@d=75aLDa<C4a<
C79bLP02@d=300IPH61BDU8h>3Ph>3Pj>SY0@402;bl_00HL71`n?Sh[:b/[:b]7AdLo?cl2DU9B00HH
61PW9bM9BDU9BDT?3`n7QhL2?3`l00E[Jf/k>c/k>c^?Shlg=cL00SXj>P05Kfm_De=CTi>CTi>CX:2P
00?oool00`000?ooooooo`0/oooo00@0003ooooooon6QXH2D51@00Dc<c>QXJ5NGUiNGUjDU9@00Va/
K006GUiNFEUIKVi^KVi^QHF5GEeM0Pl?3`06WIfM;2`/=SHf=SHf:BTYBDU90Sdm?@05I6ATDU9BDU9B
1@D5:2PX008/;2`01Va/K0`<330`<30`<5iNGT];B`9FEUH01C<c<b/[:b/[:cXj>T10@002E5AD00Hi
>CU@D50];Bd];BeIFEUHF5P251@D00D[:b/E5AERHV9RHV9NGUh00S`l?006IVIVBd];@410@410BDU9
`/;20T92@P06<C4aP820EeMGEeMG>CTi:b/[0Q4A4@05?Shn>CTi>CTi7alO=SHf008l?3`01Ta<C34a
<B<S8b<S8b0P88Z:RP8];Bd01BTY:B`/;2`/;2h^;RPX:0028R8R00I4A4@A4A7@d=3@d=1QHF5JFUX2
L71`00DF5QHg=cMPH61PH60i>CT00RDU9@065ADE;2`/:RXZ:RXZQ8B4FEUI0/c<c005<30`HF5Q;2`/
;2`/4A4A009=CDd01S@d=75aLE5ADE5ADG1`L4I6AP9LG5`01UQHF3<c<cHf=SHf=Slo?cDe=@8T92@0
1DI6AS8b<S8b<T=3@c/k>`02Cdm?00HM7AdO7am1@D51@D4H61R=SHd2?Shn00E/K6`a<C6HV9RHV9Pi
>CT00TE5A@05IFEUH61PShn?Shn?[Zj^00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooo
oooooomiNGT00V][J`06Bd];[Zj^RHV9RHV9>3PhR8R80UQHF005QHF5k>c/k>c/QhN7GUiN009EEED0
1W5aLH>3Pi:BTY:BTR@T94a<C08N7Qh01T10@6a/K4A4A4A4A1/K6d10@08U9BD01FIVIS8b<Q8B4Q8B
4T51@@02Ph>300H;2`/C4a<71`L71`LY:BUSHf<2@d=300Ho?cmGEeLb<S8b<S95ADF?Shl2;Rh^00EJ
FUXb<S:;Rh^;Rh/C4a<00Xf=S@06LG5aFEUINg]kNg]k6ATI?Shn0UYJFP0692@TO7al9BDU9BDUATI6
61PH0VEUI@05WinOT92@HF5QHF5QFEUI009ADE401[2`/30`<6=SHf=SH`l?3cLg=`9KFe/01VEUIEIF
EQPH61PH64Q8B3/k>`93@d<01WQhN51@D3@d=3@d=4Y:BP<30`9BDU801GEeME5ADE5ADCXj>RHV9P02
JFUY00HG5aN:RXY8B4Q8B4RCTi=TI6@2:BTY00HV9RIFEUH?3`l?3`m0@412@T82@D5100E0@41lO7al
O7`F5QHc<c<00Ph>3P06BDU9<30`;Bd];Bd]:BTYShn?0PP82006P820Ph>3DU9BDU9B;Bd]I6AT0S@d
=005=cLgE5ADDe=CDe=C][Jf00:BTY801R@T93dm?Chn?Shn?UIFEVe]K@8Y:BT01IRHV?oooooooooo
o`00000^oooo00@0003ooooooom/K6`2FEUI00ERHV:JVYZ6QXJ6QXI8B4P00WMgM`06BDU9RXZ:g]kN
g]kNNWYjBd];0T92@P06Ph>3V9RHQHF5QHF56ATIFe]K0QLG5`05>SXjGEeMGEeMD51@9bLW008j>SX0
1QdM7EYJFT=3@d=3@b8R8U9BDP9eMGD01ADE5A@D51@D50X:2Rh^;P02FEUI00Hf=SI=CDeADE5ADE4a
<C5CDe<2Rh^;00DT92ACDe<j>SXj>SZ3Ph<00Q/K6`06SXj>K6a/HV9RHV9RLW9b92@T0TU9B@06DE5A
;Rh^Q8B4Q8B47QhNCdm?0Q0@4005GemOX:2PX:2PV9RHHV9R009PH6001Ti>CZj^[SDe=CDe=F1PH0`<
308m?Cd01EaLG65QHF5QHEUIFAlO7`02ADE500Hg=cM;Bd]kNg]kNg]HF5Pm?Cd2AdM700D:2PY?Cdmh
N7QhN7QJFUX00S`l?0068b<SHF5Q3Ph>3Ph>V9RHBTY:0YZJVP05GEeM:2PX7QhN7QhNEEEE008F5QH0
1U1@D4m?Ce=CDe=CDcDe=F][J`851@D01T51@@D51C/k>c/k>cPh>2TY:@8m?Cd01Hn?S`/;2`/;2hn?
Sfm_K`02Fe]K00I0@41?Cdl];Bd];Bd[:b]4A4@2ATI600F[Zj^9RHTA4A4A4A5DE5@00Tm?C`05JFUY
I6AT=cLg=cLg[jn_00?oool00`000?ooooooo`0=oooo000Roooo0P0000;oool01GUiNF][Jf][Jd];
Bjj^[P02RHV900Dh>3R8R8QHF5QHF5R5QHD00^c/k006QhN7GUiNEEEEEEEELG5aPh>30Y:BTP0692@T
C4a<7QhN7QhN@410K6a/0TA4A0066a/K@4109BDU9BDUIVIV<S8b0Q8B4P05@D51Ph>3Ph>32`/;4a<C
00871`L01RTY:F=SHd=3@d=3@clo?eMGE`8b<S801TE5AHn?Sbh^;Rh^;UYJFS8b<P:;Rh/01A<C4hf=
SHf=SG5aLEUIF@02Ng]k00HI6ATn?SiJFUYJFUXT92AlO7`29BDU00I6ATHH61QUIFEUIFFOWin@T902
HF5Q00EIFEUADE5ADE6`/;0`<3000V=SH`063`l?=cLgFe]KFe]KIFEUEUIF0QPH6006B4Q8>c/k@d=3
@d=3N7QhD51@0S@d=005BTY:0`<3DU9BDU9BMGEe009ADE401SXj>RHV9VUYJFUYJALG5hZ:RP98B4P0
1Y>CTfATI2TY:BTY:BHV9UIFEP8?3`l01D10@492@T51@D51@D10@002O7al00HF5QHc<c<>3Ph>3Pi9
BDT`<302;Bd]00HY:BV?Shl820P820R0P823Ph<2DU9B00H];BeTI6@d=3@d=3@g=cMDE5@2De=C00Ff
][JBTY:BTY8T92@m?Cd00Shn?P05EUIFKFe]:BTY:BTYV9RH00;oool20000;_ooo`8000001_ooofa/
K5UIFEUIFF9RHYZJVP:6QXH01DQ8B7MgMgMgMdU9BHZ:RP02g]kN00IjNWY;Bd]2@T92@T:3Ph>HV9P2
QHF500DI6AUKFe/G5aLG5aLj>SX00UeMG@06D51@9bLW>SXj>SXj7AdMFUYJ0T=3@`058R8RDU9BMGEe
MGEe5ADE008D51@01PX:2Rh^;UUIFEUIFCHf=Te=C@9ADE401S4a<E=CDh^;Rh^;Rb@T95=CD`8j>SX0
1H>3Pa/K6a/K6hj>SVa/K002HV9R00IbLW8T92A9BDU9BDUADE4^;Rh2Q8B400DN7Qi?Cdl@410@411O
Gel00Z2PX006V9RHHV9RH61PH61PCTi>[Zj^0SDe=@05H61P30`<?Cdm?CdmG5aL009QHF401UUIFAlO
7dE5ADE5ACLg=d];B`9kNg/01UQHF3dm?DM7AdM7A`X:2Tm?C`9hN7P01EYJFS`l?3`l?2<S8f5QH@02
3Ph>00JHV9Q:BTZJVYZJVYYMGEdX:2P27QhN00EEEEDF5QHF5QI@D51?Cdl00U=CD`06=CDeJf][1@D5
1@D5@D511@D50S/k>`05>3Ph:BTY?Cdm?CdmShn?008;2`/01Xn?Sfm_Ke]KFe]KFd10@4m?C`8];Bd0
1R/[:dA4A4I6ATI6AZ^[ZhV9R@8A4A401EADE4m?Cdm?CfUYJFATI002=cLg00>_[jooooooool00P00
00ooool002;oool01@000?oooooooooooeADE002PX:200IDE5B4Q8@O7alO7anHV9PJ6QX2LW9b00DK
6a]PH61PH60j>SX@41000T92@P06DU9B@d=3D51@D51@:RXZ3`l?0RTY:@06=CDeATI651@D51@D<c<c
<30`0SHf=P05>SXjMGEe9bLW9bLWGEeM008X:2P01U1@D3@d=51@D51@D0/;2fa/K08<30`01QLG5a4A
4GAdM7AdM2l_;gEeM@8o?cl01C/k>c@d=1PH61PH61dM7@02IFEU00I?CdnATI5_Kfm_KflE5AD^;Rh2
A4A400I1@D4a<C4W9bLW9bM<C4b/[:`2<30`00F<S8`G5aN`/;2`/;10@4000V9RHP06@T92Lg=cJVYZ
JVYZE5AD;bl_0S/k>`06>3Ph=SHf5ADE5ADEMWIf7alO0P<30`06T92@G5aLJVYZJVYZ6ATI9BDU0TI6
AP05>SXj=cLg=cLg6ATI;bl_008V9RH01U]KFa/K6eaLG5aLG3Ti>GIfMP96ATH01Rl_;fi^KSlo?clo
?a8B4S<c<`8O7al01CPh>30`<30`<5QHF861P@02;bl_00Hf=SHS8b<e=CDe=CEcLg=LG5`23@d=00JX
Z:QBDU8Z:RXZ:RXX:2Pm?Cd29bLW00EYJFUaLG5gMgMgMgMRHV800XJ6QP06`L71@d=3TY:BTY:B?clo
P8200W1`L005JVYZoooooooooooo000002koool010000?oooooooe1@D09cLg<01FIVIWIfMQ0@410@
48n?S`027QhN00ITI6@J6QYMGEeMGEd`<3051@D2=SHf00IJFUY=CDe5ADE5ADDM7Ad<30`27QhN00DY
:BTl?3`l?3`E5AD/;2`00R/[:`06;2`/<C4aPX:2PX:2;Bd]De=C0R<S8`05DU9B>SXj>SXjG5aL20P8
009XJ6P01PP821lO7a/K6a/K6gYjNRXZ:P9fMWH01CDe=C8b<RXZ:RXZ:QDE5@0292@T00ITI6A9BDVD
U9BDU9AYJFTA4A4292@T00Hm?Cdh>3Pd=3@d=3@R8R9?Cdl2ZJVY00DZ:RZ6QXJ6QXHN7Qji^KT00Shn
?P06GUiN@d=3L71`L71`Jf][Fe]K0S8b<P05?clo=CDe=CDe>CTi5aLG009fMWH01RDU9@H61X^;Rh^;
RfATI79bLP8G5aL01Bd];DY:BSXj>SXj>T51@@027QhN00H^;RhO7amGEeMGEeLA4A5IFET2@d=300Ek
Ng]3@d<m?Cdm?CeXJ6P00Te=C@062PX:@410:b/[:b/[;Rh^8R8R0TU9B@06QhN7?Shn9bLW9bLW9BDU
@D510W5aL@05EeMG7alO7alO^;RhE5AD008e=CD01RDU9C<c<c4a<C4a<GMgMf1PH09YJFT01EQHF7Qh
N;6a/K6a/D51@@02XJ6Q00EBDU:>SXinOWinOWimOGd00oooo`030000oooooooo00goool002;oool0
1@000?ooooooooooobLW9`02RHV900I7AdMBDU91@D51@D5ADE4_;bl2:b/[00Dh>3Q8B4Q8B4PN7Qha
<C400gMgM`05Bd];6a/K6a/K=SHf<S8b0093@d<01W9bLUQHF4m?Cdm?CfYZJX61P@8>3Ph01AXJ6Y:B
TU1@D51@D5=CD`027QhN00HY:BUUIFDd=3@d=3@H61Q>CTh22`/;00He=CD/;2aTI6ATI6@H61P>3Ph2
?3`l00DM7Ae:BTYDE5ADE5AKFe/00S@d=006@d=3H61PC4a<C4a<51@D8b<S0U9BDP06ADE5@D51QHF5
QHF5;Rh^EEEE0U5AD@05^KVi9BDU:RXZ:RXZ=3@d0093@d<00aXJ6W=cLd92@P02@T9200ECDe<O7alO
7amXJ6Q^KVh00S<c<`06FEUIM7Ad820P820PShn??clo0W1`L005?clo8b<S6QXJ6QXJ4A4A008B4Q80
1TE5AE9BDQDE5ADE5G9bLYNGU`99BDT01Ta<C2PX:2LW9bLW9cXj>SLg=`8W9bL01BHV9UaLG4a<C4a<
C3lo?`026a/K00IOGemADE5XJ6QXJ6QFEUInOWh2N7Qh00I>CThE5ADY:BTY:BUfMWHk>c/2>CTi00IN
GUi1@D51@D51@D4d=3@Q8B42FUYJ00EkNg/L71`L71bRXZ9jNWX00T=3@`05WIfM:2PX/;2`/;2`;2`/
00?oool00`000?ooooooo`0/oooo00@0003oooooool_;bl2OWin00EFEUI4A4@j>SXj>SYPH6000R8R
8P06=3@d@410?Cdm?Cdm92@T:RXZ0VYZJP06MgMg?clo3`l?3`l?@d=3>c/k0SLg=`05MWIfCTi>CTi>
EeMGIFEU00:8R8P011HF5R4Q8HZ:RXZ:RP9HF5P292@T00DZ:RYRHV9RHV8_;blG5aL00Tm?C`0620P8
=3@d:b/[:b/[Hf=S61PH0Pl?3`05?Cdm7AdMC4a<C4a<E5AD009LG5`01S@d=492@V5QHF5QHDa<C14A
4@8Q8B401Ti>CTI6AT92@T92@X61PC<c<`9FEUH01Di>C[Ng]kNg]b`/;2HV9P02;bl_00I4A4@D51Ad
M7AdM7A:BTY4A4@2FEUI00DH61QTI6ATI6A/K6`f=SH00UeMG@06MWIf9bLWUYJFUYJF?3`lL71`0Shn
?P057QhN6ATI3@d=3@d=4Q8B0094A4@01U1@D1@D57=cLg=cLiVIVDY:BP9=CDd01BLW9bPX:3`l?3`l
?3Ph>002:BTY00HX:2QJFUY@D51@D50m?CdH61P2G5aL00IEEEEYJFUIFEUIFEUiNGUnOWh2CTi>00DI
6ATZ:RXZ:RYoOgm5ADD00S<c<`06EEEE@D51AdM7AdM7?Shn5QHF0UeMG@05RHV93`l?WYjNWYjNKVi^
008o?cl01JZZZR`/;;:b/[:b/RTY:@03oooo00<0003oooooool03Oooo`008_ooo`050000oooooooo
oooo9bLW00:9RHT01TM7Ae9BDT51@D51@E5ADBl_;`8[:b/01CPh>4Q8B4Q8B1hN7S4a<@03MgMg00E;
Bd/K6a/K6a/f=SHb<S800T=3@`06LW9bF5QHCdm?Cdm?JVYZPH610Ph>3P056QXJTY:BD51@D51@De=C
008N7Qh01RTY:FEUIC@d=3@d=1PH64i>CP8;2`/01SDe=B`/;6ATI6ATI1PH60h>3P8l?3`01AdM7DY:
BUADE5ADE5]KF`02=3@d00I3@d=PH61<C4a<C4`D51@S8b<2DU9B00I5ADE1@D65QHF5QHD^;RiEEED2
DE5A00Fi^KTU9BDZ:RXZ:RXd=3@00T=3@`036QXJLg=c@T920092@T801E=CDalO7alO7fQXJ6i^KP02
<c<c00IIFEUdM7@P820P822?Shlo?cl2L71`00Do?clS8b<J6QXJ6QXA4A400Q8B4P06ADE5DU9B5ADE
5ADELW9bUiNG0TU9B@06C4a<:2PX9bLW9bLW>SXj=cLg0RLW9`059RHVG5aLC4a<C4a<?clo008K6a/0
1UmOGe5ADFQXJ6QXJ5IFEWinOP9hN7P01Ti>CQDE5BTY:BTY:GIfMS/k>`8i>CT01UiNGT51@D51@D51
@C@d=24Q8@9JFUX01G]kNa`L71`L7::RXWYjNP02@d=300FMWIdX:2R`/;2`/;0/;2`00oooo`030000
oooooooo02coool010000?ooooooobl_;`9nOWh01EIFETA4A3Xj>SXj>V1PH0028R8R00Hd=3A0@40m
?Cdm?CdT92@Z:RX2JVYZ00IgMgLo?cl?3`l?3`m3@d<k>c/2=cLg00EfMWI>CTi>CTiGEeMUIFD00XR8
R0045QHF8B4QRXZ:RXZ:0UQHF08T92@01BXZ:V9RHV9RHRl_;aLG5`02Cdm?00H820Pd=3@[:b/[:b]S
Hf<H61P23`l?00Dm?CdM7Ae<C4a<C4aDE5@00UaLG006=3@d@T92HF5QHF5QC4a<4A4A0R4Q8@06CTi>
ATI6@T92@T92PH61<c<c0UIFEP05CTi>]kNg]kNg;2`/9RHV008_;bl01TA4A1@D57AdM7AdM4Y:BTA4
A09IFET01APH66ATI6ATI6a/K3Hf=P02GEeM00IfMWHW9bNFUYJFUYHl?3a`L702?Shn00DN7QhI6AT=
3@d=3@dB4Q800TA4A006D51@51@DLg=cLg=cVIVIBTY:0Te=C@059bLW:2PX?3`l?3`l>3Ph008Y:BT0
1RPX:5YJFU1@D51@D3dm?APH609LG5`01UEEEFUYJEUIFEUIFGUiNGinOP9>CTh01ATI6BXZ:RXZ:Wmo
OdE5A@02<c<c00IEEEE1@D57AdM7AdLn?ShF5QH2GEeM00F9RHT?3`nNWYjNWYi^KVh00Slo?`05ZZZZ
;2`//[:b/[:b:BTY00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooomHF5P00XJ6
QP06TY:BA4A461PH61PH?CdmCDe=0UIFEP05OgmoJ6QXJ6QX92@TDU9B00:n_[h01Clo?hZ:RVATI6AT
I3Ph>003:BTY00IADE5>CThc<c<c<c<k>c]iNGT2EUIF00De=CEeMGE3@d=3@d<[:b/00Q4A4@06M7Ad
LG5a1PH61PH6?CdmS8b<0Te=C@06EUIF?CdmWinOWinO7alOCDe=0Ta<C003Lg=c?CdmE5AD009DE5@3
EUIF00Dh>3Q0@410@41`L70Z:RX00T];B`069BDUSXj>H61PH61P;Bd]2`/;0VEUI@05B4Q8IFEUP820
P820N7Qh009ZJVX01WinOUeMGBTY:BTY:BXZ:X:2PP9[Jf/01Sdm?ALG5bl_;bl_;eYJFQHF5P9BDU80
1S8b<T];Bg1`L71`L5=CDalO7`<e=CD2P82000H`<31JFUYJFUYJFUY=CDeRHV82:b/[00HW9bL_;bmD
E5ADE5A9BDTO7al2>SXj00De=CDa<C4h>3Ph>3P?3`l00Q0@4006=cLgFEUIBDU9BDU9:2PXNGUi0Te=
C@06<c<cGEeM=SHf=SHf9BDU>3Ph0QDE5@06IFEU8b<S6QXJ6QXJ@d=3EeMG0TM7A`05NGUi>3Ph>3Ph
@d=3410@008];Bd01GUiNB`/;7inOWinOTE5A@03oooo00<0003oooooool0;?ooo`040000oooooooo
C4a<0WUiN@05V9RH=CDe6ATI6ATI>3Ph0099BDT01T];Bi2@T5MGEeMGEc0`<55AD@:j^[X01TQ8B8b<
S5EEEEEEEB/[:cXj>P8P82001DA4A451@D51@D=3@de=C@02Ph>300IVIVHT92AiNGUiNGTd=3@i>CT2
8R8R00EmOGeVIVIVIVHB4Q8d=3@00XJ6QP06@410EEEE@410@410V9RH9RHV0Ti>CP05Cdm?MWIf@T92
@T92EUIF009@D5001UQHF55ADC`l?3`l?3hn?W=cL`8[:b/01Ta<C2DU9I6ATI6ATF5QHC0`<08>3Ph0
1FEUIDI6ATI6AV][JginOP02Ng]k00A/K6ajNWYUIFEUIFD2;Bd]0XV9R@05Hf=S=SHf=SHf30`<;Rh^
009TI6@01Ph>3Ti>CS/k>c/k>dA4A7QhN09:BTX01B`/;38b<T=3@d=3@gQhN002=CDe00IIFEU>CTi:
BTY:BTYTI6@O7al28B4Q00DZ:RYNGUho?clo?clF5QH00T51@@06=CDe:RXZ@D51@D51410@61PH0Shn
?P06E5ADATI68b<S8b<SOgmoBd];0SLg=`05Fe]K=CDe=CDe:BTY>3Ph008B4Q801VQXJ1lO7a/K6a/K
6dI6AUUIF@97AdL01GYjNT10@4a<C4a<C0T92@02<S8b00EnOWhR8R9cLg=cLg=BDU800oooo`030000
oooooooo00goool002;oool01@000?oooooooooooinOW`02Kfm_00Hj>SYOGemGEeMGEeM0@41RHV82
QhN700EDE5@];Bd];Bdl?3``<3000TM7A`06C4a<:RXZEUIFEUIFBTY:ZZZZ0RLW9`06I6AT<c<cATI6
ATI69BDUHf=S0R`/;005JVYZDE5A>c/k>c/kATI6009>CTh01Vi^KPD51F1PH61PH10@4:j^[P8F5QH0
1YRHV2`/;3Lg=cLg=alO7chn?P:9RHT01B<S8dI6AY>CTi>CTfATI002:2PX00I]KFeVIVHa<C4a<C5>
CThT92@2ADE500HX:2Q;Bd/h>3Ph>3PB4Q8a<C4292@T00EWIfLo?cmgMgMgMgL?3`l00X20P0067alO
Kfm_B4Q8B4Q8JFUYDE5A0RTY:@06F5QH=3@d4A4A4A4A>SXj;bl_0UQHF00661PH2PX:IVIVIVIV2@T9
;2`/0UaLG0057QhN@410@4107alOP820009cLg<01Q8B4Te=CHF5QHF5QDQ8B1dM7@9NGUh01R4Q8BPX
:1lO7alO7`X:2SDe=@8j>SX01B@T91DE5ADE5D=3@hV9R@02BTY:00IUIFD/;2agMgMgMgLh>3R@T902
;Rh^00Hn?SiJFUXj>SXj>SY@D517AdL2=3@d00EmOGdK6a]jNWYjNWYNGUh00S<c<`06K6a/F5QHKVi^
KVi^<30`DU9B0T92@P05>CTioooooooooooo000002koool010000?ooooooojRXZ09TI6@01Bh^;UEE
EDa<C4a<C410@002EUIF00IlO7aDE5@];Bd];Bdi>CTj>SX2E5AD00IADE4d=3ACDe=CDe=8B4RQXJ42
92@T00EOGel`<30`<31ADE4Q8B400V][J`069RHVL71`F5QHF5QH?Shn@d=30TU9B@05Jf][0`<30`<3
Hf=S4a<C00:YZJT01Q/K6iBDU2/[:b/[:cHf=Q/K6`8o?cl01Hn?SbLW9dY:BTY:BYNGU`02HV9R00H[
:b][Jf]VIVIVIVHc<c=>CTh28b<S00I7AdLY:BU=CDe=CDdi>CT@4102<30`00DT92AVIVIVIVHn?Sii
NGT00Q8B4P06OGem92@TKfm_Kfm_CTi>KVi^0Ta<C0059bLWDU9BDU9B;bl_4a<C0092@T801RPX:5EE
EAhN7QhN7P@4171`L08A4A401CHf=V=SHa`L71`L73/k>`02:BTY00J3Ph=ZJVX>3Ph>3Pi5ADElO7`2
@41000DV9RIXJ6PH61PH61PS8b<00RPX:0063Ph>>3Ph@T92@T92<30`30`<0TM7A`06Ph>3@410FEUI
FEUI8B4QOGem0R`/;005QHF5>3Ph>3PhATI6IfMW008c<c<01UYJFS/k>d10@410@8V9RBPX:0:2PX80
1EaLG3Xj>V1PH61PH51@D002MWIf00DZ:RYPH61>CTi>CTi6ATH00oooo`030000oooooooo00goool0
02;oool200000_ooo`05`l?3UIFEUIFE5aLG>c/k008C4a<01D];Ba/K6gMgMgMgMh^;R`02?Shn00JC
Ti=JFUYTI6ATI6AMGEeDE5@2MgMg00HI6ATm?CfUYJFUYJF6QXHc<c<23`l?00HS8b=/K6`M7AdM7Ae6
ATHc<c<2;Bd]00E5ADDc<c<c<c>SXj<^;Rh00SPh>0068B4Q<c<c61PH61PH;bl_2PX:0RLW9`04IFEU
6ATIJFUYJFUY0W9bLP9/K6`01@<30fATI6ATI75aLAdM7@02Ng]k00IGEeLY:BUlO7alO7`k>c]3@d<2
A4A400HC4a<20P9:BTY:BTXh>3R5QHD23`l?00D>3PiXJ6QXJ6S6a/I6ATH00Zb/[006?Shn2`/;IfMW
IfMWA4A47QhN0TI6AP06OWinEEEE6ATI6ATIDE5AL71`0TA4A00530`<DU9B>3Ph>3Ph8B4Q008l?3`0
1RLW9b/[:jn_[jn_[eQHF8^;R`:HV9P01QDE5E=CDgUiNGUiND51@A/K6`9BDU801CTi>DU9BAdM7AdM
7C@d=002;bl_00I;Bd]WIfMIFEUIFETl?3bTY:@2@T9200IJFUY>CThn?Shn?ShN7QiZJVX2FEUI00I`
L70Y:BU@D51@D50P820H61P2T92@00FCTi<g=cLg=cL@411dM7@00S@d=005R8R8CTi><c<c<c<cHF5Q
00;oool20000;_ooo`8000001_ooolk>cXj>SXj>SR@T92h^;P8>3Ph00eYJFQ<C4a<C4`02Ogmo0SHf
=P06T92@FUYJEeMGEeMGJf][AdM70Va/K0056a/KADE5XZ:RXZ:RUIFE008W9bL01P@4130`<61PH61P
H1`L73hn?P8];Bd01CLg=dm?CcTi>CTi>I^KV`02>3Ph00I1@D4];Bdm?Cdm?CdB4Q8b<S823Ph>00HS
8b=aLG4A4A4A4A5QHF5ZJVX2KFe]00EVIVH<30`<30aNGUijNWX00R8R8P06MWIfH61P9bLW9bLWNGUi
=CDe0T];B`05B4Q8410@1PH61PH6BTY:008n?Sh01X61P@X:2Q0@410@46ATI<g=c@99BDT01K:b/S`l
?0l?3`l?3fEUI@02@d=300HK6a]:BTYnOWinOWiCDe<H61P2Cdm?00IcLg=5ADD820P820QFEUHf=SH2
9BDU00Dn?ShZ:RXZ:RX[:b^^[Zh00U]KF`06QhN7UIFE5ADE5ADEEUIFOGem0TM7A`055QHFDe=CDe=C
>c/kCDe=008R8R801S8b<S<c<dU9BDU9BFi^KUADE08d=3@01IjNWTU9BEIFEUIFETI6AP02?clo00HF
5QI_KfmEEEEEEEEWIfL`<302B4Q800HU9BDK6a^MWIfMWIf@T914A4@21@D500E[Jf/_;bl_;bnBTY9?
Cdl00T10@003KVi^oooooooo0080000?oooo000Roooo00D0003oooooooooooo3`l<00YFEU@065aLG
>c/k4a<C4a<CBd];6a/K0WMgM`05Rh^;?Shn?ShnTi>CFUYJ009TI6@01UeMGEADE7MgMgMgMaTI6Cdm
?@:UYJD01XJ6QS<c<`l?3`l?3b<S8fa/K08M7Ad01DI6AS<c<bd];Bd];DE5A@02<c<c00JSXj<^;Rhh
>3Ph>3PQ8B4c<c<261PH00H_;bl:2PXW9bLW9bMUIFDI6AT2JFUY0W9bLP9/K6`01@<30fATI6ATI75a
LAdM7@02Ng]k00IGEeLY:BUlO7alO7`k>c]3@d<2A4A400HC4a<20P9:BTY:BTXh>3R5QHD23`l?00D>
3PiXJ6QXJ6S6a/I6ATH00Zb/[006?Shn2`/;IfMWIfMWA4A47QhN0TI6AP06OWinEEEE6ATI6ATIDE5A
L71`0TA4A00530`<DU9B>3Ph>3Ph8B4Q008l?3`01RLW9b/[:jn_[jn_[eQHF8^;R`:HV9P01QDE5E=C
DgUiNGUiND51@A/K6`9BDU801CTi>DU9BAdM7AdM7C@d=002;bl_00I;Bd]WIfMIFEUIFETl?3bTY:@2
@T9200IJFUY>CThn?Shn?ShN7QiZJVX2FEUI00I`L70Y:BU@D51@D50P820H61P2T92@00FCTi<g=cLg
=cL@411dM7@00S@d=005R8R8CTi><c<c<c<cHF5Q00?oool00`000?ooooooo`0/oooo00@0003ooooo
ooo>c/h2SXj>00DT92@^;Rh>3Ph>3PiJFUX00Q<C4`9oOgl2=SHf00J@T91JFUYGEeMGEeM[Jf]7AdL2
K6a/00DK6a]5ADFRXZ:RXZ:EUID00RLW9`0610@4<30`H61PH61P71`L?Shn0Rd];@05=cLgCdm?>CTi
>CTiVi^K008h>3P01T51@Bd];Cdm?Cdm?A8B4S8b<P8>3Ph01R<S8g5aLA4A4A4A4F5QHFYZJP9]KFd0
1FIVIP`<30`<35iNGWYjNP028R8R00IfMWIPH60W9bLW9bMiNGTe=CD2Bd];00E8B4P@41061PH61PI:
BTX00Shn?P06PH612PX:410@410@I6ATcLg=0TU9B@05/[:b?3`l3`l?3`l?IFEU0093@d<01Q/K6dY:
BWinOWinOU=CDaPH609?Cdl01W=cLdE5A@P820P825IFESHf=P8U9BD01Chn?RXZ:RXZ:R/[:jj^[P02
Fe]K00J7QhNEUIDE5ADE5AEFEUImOGd2AdM700DF5QICDe=CDe<k>c]=CDd00R8R8P06<S8b<c<cBDU9
BDU9KVi^E5AD0S@d=005WYjNBDU9EUIFEUIFATI6008o?cl01QHF5Vm_KeEEEEEEEFMWIc0`<098B4P0
1RDU9A/K6ifMWIfMWI2@T4A4A0851@D01F][Jbl_;bl_;i:BTTm?C`02@41000E^KVkoooooooooool0
00003oooo`008_ooo`050000ooooooooooooPX:200:][Jd01V1PH1dM7@D51@D51CHf=S8b<P8`<300
1EiNGWIfMWIfMPD51JNWY`02E5AD00DP8218B4QfMWIfMWI?Cdl00eiNGP06ATI63Ph>;Rh^;Rh^S8b<
Hf=S0S4a<@05=CDe410@CTi>CTi>:RXZ009WIfL01UYJFRl_;hb<S8b<S1DE5APH608V9RH01SDe=Dm?
CahN7QhN7WalO3/k>`:3Ph<01GYjNXR8R2/[:b/[:c@d=002P82000HB4Q8820QQHF5QHF4W9bLY:BT2
FEUI00IPH61NGUhN7QhN7QikNg/a<C42B4Q800FCTi=^KVi8B4Q8B4QHF5P00WMgM`06HV9RCDe=:2PX
:2PXCTi>>SXj0UYJFP06@D5120P8;bl_;bl_Jf][C4a<0PT92@048b<SGemOSHf=SHf=0RTY:@8h>3P0
1B`/;3@d=3@d=3dm?G=cL`02CDe=00H@4110@40m?Cdm?CeFEUJ>SXh2Ph>300Hk>c/g=cLI6ATI6ATD
51@Z:RX2KVi^00DH61Q_Kfm_KflI6AUWIfL00RLW9`06;2`/Ph>3DU9BDU9B2PX:?3`l0QTI6@06Fe]K
A4A49bLW9bLWLW9bC4a<0RDU9@05J6QX8b<S7AdM7AdMBd];00871`L01QDE5EUIFAXJ6QXJ6Va/K7Qh
N08K6a/01Jb/[?ooooooooooo`00000^oooo00@0003ooooooon8R8P2ZZZZ00EOGelJ6QX00000000a
<C400Rh^;P06>3PhIVIVL71`L71`1@D5Xj>S0U=CD`067alOCdm?LW9bLW9bATI6JFUY0V9RHP05A4A4
10@410@4>CTiRHV9009WIfL01SLg=bh^;P`<30`<34=3@alO7`9aLG401Dm?CcTi>CTi>I^KV`l?3`02
3Ph>00HQ8B4g=cM<C4a<C4`N7Qj8R8P2=CDe00EfMWIeMGEnOWinOWhd=3@00RPX:006PH612@T951@D
51@DFe]K=CDe0R0P8006DE5AEeMGIfMWIfMW:b/[RHV90S`l?005@D51VYZJVYZJIFEUCDe=009KFe/0
1Vm_Kfe]KEMGEeMGEb`/;5ADE08b<S801EEEECPh>3Ph>0@412LW9`02MGEe00I5ADD@410Y:BTY:BUV
IVJ8R8P2;2`/00DX:2Pf=SH^;Rh^;Rhj>SX00T=3@`06L71`Cdm?4a<C4a<C?clo>c/k0U=CD`05TY:B
QHF5?Cdm?Cdm=3@d008G5aL01QDE5BXZ:Vm_Kfm_KaPH66e]K@8H61P01VMWIbHV9Rd];Bd];HJ6QU5A
D@8;2`/01CXj>QTI6ATI6EaLG4M7A`02:RXZ00IcLg=?CdlT92@T92A/K6`U9BD26a/K00E;Bd/92@TB
4Q8B4Q9FEUH00QhN7P05JFUYMgMg7alO7alO/;2`00?oool00`000?ooooooo`0=oooo000Roooo00D0
003oooooooooooo8b<P00XV9R@06De=CC4a<:BTY:BTYGEeMFEUI0RDU9@05C4a<J6QXJ6QXO7alC4a<
008R8R801Vm_Ka4A4Da<C4a<C5aLG3lo?`9?Cdl01QDE5CDe=Di>CTi>CXj>ST=3@`:PX:001C<c<c/k
>h61PH61PE]KF`02>CTi00I:BTYkNg/[:b/[:b]BDU9@D502>c/k00J0P80I6AUlO7alO7aQHF6>SXh2
7alO00EKFe^VYZJ;Rh^;Rh]VIVH00STi>@06<c<c3Ph>?clo?clo>SXj8b<S0QLG5`06IVIV7alODU9B
DU9BSHf=1`L70U=CD`04D51@ADE5VYZJVYZJ0gIfMP06:b/[8b<S9BDU9BDU9bLW=SHf0Ti>CP067AdM
VYZJ;bl_;bl_=SHf3`l?0T51@@06410@?3`lF5QHF5QHGEeM61PH0RXZ:P0592@T6ATI6ATI@d=3H61P
009;Bd/01STi>E=CDbXZ:RXZ:Xn?SeMGE`9gMgL01RDU9@l?3b4Q8B4Q8FATI6YZJP92@T801AdM7EUI
FEUIFE5ADEQHF002De=C00HQ8B5hN7PP820P821WIfN0P802De=C00HB4Q9@D52RXZ:RXZ8W9bM6ATH2
9BDU00E0@41=CDe2@T92@T8J6QX00S/k>`06<30`H61PRHV9RHV9@T92@4100TE5A@05M7Adoooooooo
oooo000002koool010000?ooooooom7Ad@:6QXH01E=CDdY:BRh^;Rh^;V9RHP02F5QH00HY:BU;Bd]^
KVi^KViiNGU?Cdl28R8R00IcLg<@411?Cdm?CdmLG5a1@D42DE5A00DD51@e=CDe=CE?Cdn@T9000T92
@P06Xj>S=CDe>SXj>SXjPH61FEUI0SPh>005B4Q8PH61PH61:b/[EUIF009?Cdl01Sdm?H20P1@D51@D
5861PFUYJ@:9RHT01BHV9UIFEZ2PX:2PX9FEU@02HF5Q00Hk>c/b<S8B4Q8B4Q91@D4d=3@29BDU00H>
3PiNGUhN7QhN7Qi>CTjHV9P220P800EMGEeGEeMGEeM5ADFNWYh00WemO@06LW9b=3@d7QhN7QhN7alO
8b<S0S<c<`05B4Q861PH61PHU9BD=cLg008i>CT01P/;2dI6AQHF5QHF5S`l?5MGE`9KFe/01A<C4bPX
:24Q8B4Q8AdM7@02A4A400IMGEe>CThl?3`l?3aEEEDZ:RX2SHf=00EKFe]kNg/X:2PX:2P:2PX00RHV
9P06JFUYJf][ADE5ADE5820PEEEE0UMGE`06De=CDU9B71`L71`LMgMg9RHV0V5QH@05OGemCDe=CDe=
6ATICDe=00:YZJT01Rh^;TA4A2@T92@T94E5ADU9B@98B4P01B4Q8C/k>c0`<30`<5eMG@02QXJ600E3
@d<j>SY2@T92@T9_Kfl00oooo`030000oooooooo00goool002;oool01@000?oooooooooook>c/`02
Q8B400HT92AGEeM=CDe=CDdc<c=ZJVX23@d=00D[:b]ADE5ADE64Q8@F5QH00T92@P06DE5A20P8BTY:
BTY:?ShnEEEE0R0P8006Cdm?7alO4a<C4a<CAdM7B4Q80XV9R@05GUiN8b<SRHV9RHV9L71`009NGUh0
1TY:BRDU9B@T92@T94Y:BS`l?09=CDd01SHf=TM7AgmoOgmoOahN7Sdm?@9[Jf/01CPh>4A4A3`l?3`l
?1dM7@027QhN00DD51@J6QXF5QHF5QIPH6000e=CD`04@410:2PXS8b<S8b<0RXZ:P:7QhL01Da<C5iN
GQ@D51@D54Y:BP02LW9b00HC4a<I6AUEEEEEEED>3Phm?Cd2MGEe00I5ADECDe<g=cLg=cMIFETK6a/2
KVi^00H`<30T92@n?Shn?Shd=3@^;Rh28b<S00EVIVHM7AdM7Ae7AdLh>3P00QDE5@06E5ADRXZ:@d=3
@d=3IFEU6QXJ0VATI006>CTi;bl_LG5aLG5a[Zj^Hf=S0QLG5`054a<C5aLG5aLGHf=SFe]K008X:2P0
1UQHF9ZJVUiNGUiNGTI6AUUIF@8b<S801SDe=AdM7B0P820P85YJFRLW9`8=3@d01FATI34a<HN7QhN7
Qh>3P`02CTi>00Hd=3AdM7ANGUiNGUi>CTho?cl2Kfm_00EgMgOoooooooooool00000;_ooo`040000
oooooooo^[Zj0XB4Q0057QhNEeMGATI6ATI69bLW009cLg<01Ph>3SLg=da<C4a<C7alO1<C4`8h>3P0
1Te=C@X:2TU9BDU9BD92@T];B`8R8R801Dm?CbLW9bLW9aPH64M7A`02CDe=00J?ShmGEeL[:b/[:b^1
PH5eMGD2F5QH00EBDU8Z:RXZ:RXP8215ADD00TA4A006AdM7>c/kADE5ADE5Q8B492@T0T92@P05LG5a
=SHfBDU9BDU9>3Ph008M7Ad01R<S8aLG5aPH61PH61<C4f5QH@9BDU801UQHF3lo?bTY:BTY:H^;RbTY
:@8X:2P01HZ:RTm?Cdm?CemOGa@D5002BDU900IcLg<D51@J6QXJ6QYGEeL>3Ph2?clo00EdM7A3@d=3
@d=DE5@f=SH00UUIF@067QhNKFe];Bd];Bd]8b<S@T920SHf=P05:b/[9BDUI6ATI6AT6a/K0095ADD0
1SHf=Q8B4UQHF5QHF8b<S3lo?`9QHF401AdM7F][JcTi>CTi>C8b<P02NGUi00J][JeRHV8E5ADE5ADF
5QHO7al2K6a/00IJFUX];BeDE5ADE5BTY:AFEUH2?clo00EDE5@d=3@d=3A0@40W9bL00RXZ:P06IFEU
:RXZ61PH61PHJ6QX:2PX0WmoO`05SXj>CDe=<30`<30`NWYj009EEED01D=3@cHf=Va/K6a/K6e]K@03
oooo00<0003oooooool03Oooo`008_ooo`050000oooooooooooo/k>c00:4Q8@01R@T95MGEde=CDe=
CC<c<fYZJP8=3@d01B/[:e5ADE5ADHB4Q1HF5P02@T9200IADE4820Q:BTY:BTXn?SiEEED2820P00I?
CdlO7alC4a<C4a=7AdM8B4P2RHV900ENGUhS8b>9RHV9RHU`L7000UiNGP06BTY:9BDU92@T92@TBTY:
?3`l0Te=C@06=SHfAdM7OgmoOgmo7QhN?Cdm0V][J`05>3PhA4A4?3`l?3`l7AdM008N7Qh01A@D51XJ
6QHF5QHF5V1PH003De=C00A0@40X:2R<S8b<S8`2:RXZ0XN7Q`05C4a<GUiN51@D51@DBTY:009bLW80
1Q<C4aTI6EEEEEEEE@h>3Sdm?@9eMGD01TE5AE=CDcLg=cLg=eUIFA/K6`9^KVh01S0`<2@T93hn?Shn
?S@d=2h^;P8S8b<01FIVIQdM7AdM7DM7AcPh>0025ADE00IDE5B:RXY3@d=3@d=UIFDJ6QX2I6AT00Hi
>CT_;bmaLG5aLG6^[ZiSHf<25aLG00DC4a<G5aLG5aMSHf=KFe/00RPX:006F5QHVYZJGUiNGUiNATI6
FEUI0S8b<P06=CDe7AdM820P820PFUYJ9bLW0Pd=3@05I6AT<C4aQhN7QhN7Ph>3009>CTh01S@d=7Ad
M5iNGUiNGTi>CSlo?`9_Kfl01GMgMoooooooooooo`00000^oooo00@0003ooooooonj^[X2Q8B400DN
7QiGEeM6ATI6ATHW9bL00W=cL`063Ph>=cLgC4a<C4a<O7al4a<C0SPh>006CDe=2PX:BDU9BDU9@T92
Bd];0R8R8P05Cdm?9bLW9bLW61PHAdM7009=CDd01Xn?SeMGEb/[:b/[:h61PGEeM@9HF5P01E9BDRXZ
:RXZ:R0P84E5A@02A4A400I7AdLk>c]5ADE5ADF4Q8@T92@2@T9200EaLG4f=SI9BDU9BDTh>3P00QdM
7@068b<S5aLG61PH61PH4a<CHF5Q0U9BDP06F5QH?clo:BTY:BTYRh^;:BTY0RPX:005RXZ:Cdm?Cdm?
GemO51@D0099BDT01W=cLa@D51XJ6QXJ6UMGE`h>3P8o?cl01GAdM4=3@d=3@eADE3Hf=P02FEUI00HN
7Qi]KFd];Bd];BdS8b=2@T82=SHf00D[:b/U9BETI6ATI6@K6a/00TE5A@06=SHf4Q8BF5QHF5QHS8b<
?clo0V5QH@057AdMJf][>CTi>CTi<S8b009iNGT01Zf][F9RHQDE5ADE5AHF5QlO7`9/K6`01UYJFRd]
;EADE5ADE:BTY5IFEP8o?cl01EADE3@d=3@d=410@2LW9`02:RXZ00IUIFDZ:RXH61PH61QXJ6PX:2P2
Ogmo00F>SXi=CDd`<30`<31jNWX00UEEE@05@d=3=SHfK6a/K6a/KFe]00?oool00`000?ooooooo`0=
oooo000Roooo00D0003ooooooooooomNGUh00WalO006?ShnHF5Q20P820P8ADE5=SHf0Va/K005@T92
6ATI6ATIFe]K@T92009NGUh01Pd=3FATI61PH61PH2XZ:WemO@:JVYX01TQ8B6IVIU9BDU9BDV=SHcXj
>P9EEED01AHF5QlO7dQ8B4Q8B4Y:BP026QXJ00He=CD=3@e?Cdm?CdmADE4e=CD3CTi>00ENGUhW9bLW
9bLC4a<k>c/00T];B`055aLG92@T=cLg=cLg30`<008`<3001R0P83lo?g]kNg]kNaHF5QhN7P8Q8B40
1Slo?b`/;820P820P6e]KAhN7P8d=3@01Di>CTm?Ch^;Rh^;Rc`l?002BTY:00@G5aMADE5hN7QhN7P2
61PH0WIfMP06=cLg6QXJTY:BTY:B>CTiBDU90V5QH@06A4A4B4Q8EUIFEUIF71`LIFEU0RPX:005EeMG
CDe=CDe=@410AdM7008410@01T=3@eaLG1TI6ATI6@d=3GUiN@8W9bL01T10@5]KFa0@410@46UYJDI6
AP8j>SX01B4Q8AHF5QHF5WUiNG5aL@02ADE500HF5QI2@T8F5QHF5QJ8R8QMGEd2E5AD00H/;2a6ATHM
7AdM7Ae0@40m?Cd2De=C00Dg=cLb<S8Z:RXZ:RYXJ6P00QTI6@06=3@dGemO9bLW9bLWG5aLS8b<0[^k
^`05dm?Coooooooooooo000002koool010000?ooooooofi^KP9`L7001C8b<Vi^KQ<C4a<C4dI6AP02
@T9200IdM7A@D50E5ADE5AE?Cdlh>3P2GEeM00HA4A5JFUYTI6ATI6@Q8B5gMgL2YZJV00E3@d=aLG5a
LG5KFe]LG5`00TA4A006GEeM6a/K61PH61PHATI6B4Q80Q<C4`05>c/k1`L71`L7EeMGC4a<008k>c/0
1TQ8B4e=CEUIFEUIFB`/;0h>3P8o?cl01De=CAXJ6R<S8b<S8cDe=@023`l?00H^;RhM7Adm?Cdm?Cek
Ng/L71`292@T00HP820k>c/_;bl_;bn6QXIbLW828b<S00Di>CUDE5ADE5A;Bd^ATI400S`l?006BTY:
5ADECTi>CTi>OGem51@D0QXJ6P05Lg=c=CDe=CDe5QHFTY:B008k>c/01TU9BEiNGTI6ATI6ATQ8B5MG
E`8N7Qh01F=SHb/[:eMGEeMGEdU9B@02@T9200I3@d<51@E6ATI6ATIIFETE5AD24A4A00EmOGd/;2`k
>c/k>c]SHf<00Pd=3@06Hf=SB4Q8?Shn?Shn92@T7QhN0X>3P`06L71`ATI64A4A4A4A@d=33Ph>0Win
OP05EEEEEUIFEUIF=SHfDE5A008M7Ad01S`l?4E5ADi>CTi>CSLg=bDU9@8P82001GQhN2HV9SDe=CDe
=E]KF`02=CDe00E?CdmoOgnh^;Rh^;S8b<P00oooo`030000oooooooo00goool002;oool200000_oo
o`05NGUiRXZ:RXZ:2@T9RHV9008C4a<01G1`L5=CDaTI6ATI6CLg=`02;Bd]00JPX:0V9RI=CDe=CDfE
UIDa<C42=3@d00=^KViTI6@[:b/00R/[:`05K6a/LG5aLG5a>SXj=SHf009/K6`01AlO7bl_;adM7AdM
7B/[:`02<30`00H^;RhR8R8h>3Ph>3QIFETa<C4292@T00AVIVH820QaLG5aLG42C4a<0QdM7@051@D5
K6a/<c<c<c<cCTi>008F5QH01UmOGdm?ClK6a/K6aTA4A61PH08b<S801UUIFDi>CTI6ATI6AVa/K410
@09JFUX01Bl_;g=cLi>CTi>CTfYZJP02;Rh^00Ha<C4K6a/I6ATI6AT];BdL71`28R8R00Hk>c]1@D5N
GUiNGUi/K6aOGel23Ph>00I7AdMeMGD^;Rh^;RhW9bMcLg<2LG5a00DI6ATY:BTY:BTo?cnGUiL00Vi^
KP06BDU9;Bd]=cLg=cLg6ATIT92@0QHF5P06:2PXBDU9=SHf=SHfPh>3ZJVY0P`<3005Bd];410@410@
BTY:A4A4008k>c/01QXJ6UMGEaHF5QHF5SLg=da<C09;Bd/01T10@2DU9FQXJ6QXJ6][Jc`l?0:;Rh/0
1F5QHG5aLEMGEeMGEe5AD@028R8R00Hh>3P];Be`L71`L70k>c]IFET3J6QX0_ooo`80000^oooo0P00
0006ooooMWIfRh^;Rh^;2PX:Shn?0QHF5P05LG5aEUIFEUIF7QhN>c/k008Y:BT01Z>SXb8R8Ti>CTi>
CYBDU2h^;P8a<C400f][JfEUIC0`<002<30`0Vi^KP06M7Ad>CTi>3Ph>3PhLG5a71`L0S4a<@056QXJ
:2PX<C4a<C4a;2`/008P82001SLg=eiNGSDe=CDe=B<S8fATI08;2`/01W1`L4m?CdY:BTY:BR4Q8@P8
209/K6`01CHf=Ti>CTi>CQLG5eiNGP02De=C00K7alM5ADETI6ATI6@`<31GEeL2DU9B00E4A4A`L70n
?Shn?SiMGEd00S0`<004MWIfUiNGKFe]KFe]0Rl_;`8H61P01ATI6B`/;1XJ6QXJ6R@T9002>c/k00I0
@41MGEe_Kfm_KfmNGUh=3@d2AdM700IgMgL];BdX:2PX:2QcLg=dM7@26ATI00DY:BU1@D51@D6HV9Q`
L7000TQ8B006;2`/>CTi6a/K6a/KTi>C5aLG0RXZ:P05BDU9=cLg=cLgPh>3[Jf]008>3Ph01TY:BQ<C
4dU9BDU9BDQ8B3`l?08N7Qh015EEEATI6C<c<c<c<`=<C4`01T51@BDU9FUYJFUYJFQXJ3Xj>P::RXX0
1V5QHG9bLUEEEEEEEEADE2DU9@8f=SH01C8b<WAdM7AdM3Xj>UYJFP02J6QX00=YJFWoooooool00P00
00ooool002;oool01@000?ooooooooooohn?S`02Jf][00IDE5@[:b]4A4A4A4AmOGe[Jf/2ADE500ET
I6@n?Shn?SicLg=bLW800UiNGP06CDe=?Cdm9RHV9RHV?cloH61P0QlO7`06RHV9C4a<PH61PH61?Cdm
A4A40T=3@`05GemOE5ADATI6ATI6EUIF008b<S801Rl_;eIFEUiNGUiNGTQ8B3@d=09UIFD01Ti>CUIF
ERl_;bl_;di>CUIFEP9QHF401@`<396ATDM7AdM7AeQHF002ATI600HQ8B5@D50`<30`<30Z:RXa<C42
4a<C00HG5aLL71`T92@T92ALG5`X:2P24a<C00EcLg=VIVIBDU9BDU8f=SH00U5AD@06E5AD@D519bLW
9bLW:b/[8b<S0QlO7`062@T9C4a<;2`/;2`/BDU9410@0PX:2P06QXJ6YjNWPH61PH61<C4a>3Ph0UYJ
FP05<S8bMWIfMWIf9BDUD51@009JFUX01TA4A2d];Bh^;Rh^;R8R8QlO7`8D51@01S8b<Tm?CbTY:BTY
:Clo?m?Cd`8O7al01CDe=@T92@T92A`L72`/;002F5QH00Hh>3Q]KFeADE5ADE4>3PhE5AD2ADE500J>
SXhe=CDW9bLW9bM0@415ADD2;Rh^00EaLG4d=3@?3`l?3`mhN7P00Ta<C006Ng]kBDU9V9RHV9RH;Rh^
?Cdm0TY:BP05L71`oooooooooooo000002koool010000?oooooooi:BTP9[Jf/01EADE2/[:dE5ADE5
AGemO@02K6a/00I5ADEVIVHm?Cdm?CecLg=bLW82HF5Q00I?Cdlo?clW9bLW9bLn?SiSHf<27AdM00F8
R8Q?Cdm?Cdn5QHDo?cl00T92@P06@D51HF5QDU9BDU9BBDU9EeMG0S@d=005;Rh^FEUIFEUIHF5QB4Q8
008c<c<01VMWIe1@D5UIFEUIFC4a<De=C@9GEeL01F5QH@`<39:BTY:BTTQ8B002F5QH00I7AdLQ8B5A
DE5ADE4a<C4[:b/2<C4a00HC4a<G5aLM7AdM7AdT92ALG5`29bLW00DD51AcLg=cLg=XJ6QADE400SPh
>006De=CE5AD@d=3@d=3:RXZ:BTY0RDU9@058B4Q30`<30`<BDU9;bl_0098B4P23Ph>0XN7Q`06[:b/
QhN7;Rh^;Rh^?3`lFEUI0S4a<@05LW9b9bLW9bLWC4a<FUYJ0093@d<01S0`<2/[:ahN7QhN7Q`L710@
408f=SH01EEEEBd];Bd];D51@M7Ad@028R8R00Hf=SH820PP820P820Z:RYGEeL2=CDe00EbLW9?CdlB
4Q8B4Q8D51@00TM7A`06TI6A=3@d:BTY:BTY?cloBDU90S4a<@06M7Ad<c<c3Ph>3Ph>O7alCDe=0Wal
O005Bd];V9RHV9RH;Rh^?3`l009;Bd/01G1`L?ooooooooooo`00000?oooo000Roooo00D0003ooooo
oooooon?Shl00V][J`06E5AD:b/[A4A4A4A4OGemJf][0TE5A@05I6AT?Shn?ShnLg=cLW9b009NGUh0
1Te=CCdm?BHV9RHV9Slo?f1PH08O7al01XV9RDa<C861PH61PCdm?DA4A093@d<01EmOGeADE4I6ATI6
AUIFEP02<S8b00H_;bmFEUINGUiNGUi8B4Pd=3@2IFEU00I>CTiFEUH_;bl_;bm>CTiFEUH2HF5Q00D<
30bATI57AdM7AdMHF5P00TI6AP068B4QD51@<30`<30`:RXZ<C4a0Q<C4`065aLG71`L92@T92@TG5aL
:2PX0Q<C4`05Lg=cIVIVDU9BDU9B=SHf009ADE401UADE451@BLW9bLW9b/[:b<S8`8O7al01PT92Da<
C2`/;2`/;4U9BA0@408:2PX01XJ6QZNWYh61PH61PC4a<CPh>09JFUX01C8b<WIfMWIfMRDU9E1@D002
FUYJ00I4A4@];Bd^;Rh^;RhR8R8O7al251@D00Hb<S9?CdlY:BTY:BTo?coCdm<27alO00De=CD92@T9
2@TL71`/;2`00UQHF006>3PhKFe]DE5ADE5A3Ph>5ADE0TE5A@06SXj>=CDe9bLW9bLW@410ADE50Rh^
;P05LG5a=3@d3`l?3`l?N7Qh009<C4`01W]kNdU9BIRHV9RHV2h^;Sdm?@9:BTX01G1`L?oooooooooo
o`00000^oooo00@0003ooooooonBTY82Jf][00EDE5@[:b]5ADE5ADEmOGd00Va/K006ADE5IVIV?Cdm
?CdmLg=cLW9b0V5QH@06Cdm??clo9bLW9bLW?ShnHf=S0QdM7@05R8R8Cdm?Cdm?QHF5?clo0092@T80
1T51@F5QHE9BDU9BDTU9BEMGE`8d=3@01Bh^;UUIFEUIFF5QHDQ8B002<c<c00IWIfM@D51IFEUIFETa
<C5=CDd2EeMG00EQHF4<30bBTY:BTY98B4P00UQHF006AdM78B4QDE5ADE5A<C4a:b/[0S4a<@064a<C
5aLG7AdM7AdM92@TG5aL0RLW9`0551@DLg=cLg=cJ6QXDE5A008h>3P01U=CDeADE4=3@d=3@bXZ:RTY
:@8U9BD01B4Q8@`<30`<34U9BBl_;`02B4Q80Ph>3P:7QhL01Zb/[8N7Qbh^;Rh^;S`l?5UIF@8a<C40
1G9bLRLW9bLW9da<C5YJFP02@d=300H`<30[:b/N7QhN7QhL71`@4102=SHf00EEEED];Bd];Be1@D7A
dM400R8R8P06=SHf20P8820P820P:RXZEeMG0SDe=@05LW9bCdm?4Q8B4Q8B51@D0097AdL01Y6ATC@d
=2TY:BTY:Clo?dU9B@8a<C401WAdM3<c<`h>3Ph>3WalO4e=C@9lO7`01D];BiRHV9RHV2h^;S`l?002
Bd];00E`L73oooooooooool000003oooo`008_ooo`050000ooooooooooooMGEe009^KVh01VEUIDa<
C2/[:b/[:jj^[Ve]K@8Q8B401BPX:8Z:RXZ:RWQhN;Rh^002>3Ph00HJ6QYoOglc<c<c<c=jNWXn?Sh2
F5QH00IlO7aHF5Q=CDe=CDd@410O7al2HV9R00DW9bL_;bl=3@d=3@eJFUX00R8R8P067alO9RHVJVYZ
JVYZ7QhNCdm?0VQXJ006BTY:5ADEH61PH61PDE5AJFUY0QXJ6P05Fe]KOWin92@T92@TFUYJ0091@D40
1Q/K6``<35=CDe=CDc4a<CPh>09;Bd/01UUIFE9BDSdm?Cdm?C<c<i2@T0:4Q8@01DE5AEMGEiJFUYJF
US`l?002820P00HL71a2@T8o?clo?cld=3AQHF42EEEE00IBDU8W9bM;Bd];Bd][Jf/f=SH2JFUY00K6
a/JYZJUCDe=CDe<M7AeoOgl3:2PX0TA4A006GEeMKfm_OWinOWin<c<cATI60R8R8P06:b/[DE5A8B4Q
8B4Q5aLGBDU90Sdm?@05Bd];Fe]KE5ADE5AD<C4a0096ATH01T92@SXj>VATI6ATI2HV9QDE5@8K6a/0
1S/k>b0P8451@D51@DU9BD=3@`9RHV801Q`L75QHF492@T92@Shn?UMGE`8U9BD01Da<C1`L71`L72PX
:6QXJ002D51@00EHF5Q]KFfRXZ:RXZ:_[jl00oooo`030000oooooooo02coool010000?ooooooofAT
I09QHF401Fa/K5eMGA`L71`L7::RXP02HV9R00H?3`ld=3BATI6ATI5ZJVZ][Jd2:2PX00HT92AfMWI5
ADE5ADEdM7A3@d<2DE5A00E/K6a9BDU9BDUKFe/R8R800QlO7`06GUiN:2PX9BDU9BDU5aLGCdm?0RLW
9`054Q8B=CDe=CDeM7Ad:RXZ0097AdL01WAdM5EEEB0P820P86][Jdi>CP9QHF401A8B4VATI7]kNg]k
NbPX:002EEEE00I1@D4O7al820P820QFEUHe=CD2>SXj00I:BTYIFEUADE5ADE4m?Cdd=3@2TI6A00F5
QHE5ADE5ADEHF5RGUiL00Shn?P067QhN6QXJATI6ATI6@d=3<c<c0VIVIP=CDe<01RPX:4M7Afe]KFe]
KCTi>FYZJP;5aLD01Zn_[eUIFAhN7QhN7XJ6QRHV9P8S8b<01DA4A5aLG5aLG7=cLgYjNP02=SHf00I5
ADDX:2PW9bLW9bMGEeLR8R827QhN00E@D511@D51@D55ADEEEED00UADE003=CDe@410@T920092@T80
1FATI30`<30`<1PH618B4P02ATI600DI6AU=CDe=CDe?Cdm>CTh00UMGE`064Q8BFEUI=cLg=cLgCDe=
BTY:0S0`<005EEEE4a<C=3@d=3@dGemO0099BDT01F9RHUmOGkFe]KFe]JZZZP03oooo00<0003ooooo
ool03Oooo`008_ooo`050000ooooooooooooWYjN008j>SX01T51@FEUIEADE5ADE2h^;S/k>`9@D500
1D=3@dA4A4A4A1PH63<c<`02QhN700I^KViGEeMBDU9BDU8L71a5ADD2/k>c00ILG5bDU9@J6QXJ6QYD
E5AYJFT2B4Q800Dm?Cd=3@dd=3@d=3AHF5P00R4Q8@06CDe=;Rh^4a<C4a<C7AdMH61P0UUIF@06@T92
A4A4;Bd];Bd]=cLgA4A40U=CD`05O7al9RHVE5ADE5ADFUYJ009=CDd01E5ADC/k>`h>3Ph>3V1PH003
NWYj00HV9RHO7amcLg=cLg<e=CElO7`2PX:200ESHf>9RHUYJFUYJFU3@d<00T51@@06=SHf92@TMgMg
MgMg8b<SRh^;0R`/;006@T92OGemGUiNGUiN;bl_E5AD0WEeM@06Ti>C>CTi=CDe=CDe@T92JVYZ0R@T
9005:b/[5QHF5QHF=cLgV9RH00:>SXh01Pl?3cdm?CDe=CDe=EYJFX:2PP8_;bl01R`/;4Y:BWmoOgmo
OdY:BS0`<09JFUX01GIfMVQXJ6QXJ3Hf=UYJFP02G5aL00I4A4@e=CDi>CTi>CTZ:RXU9BD2000000HQ
8B4=3@e;Bd];Bd]ADE5cLg<2PH6100ESHf<_;bmfMWIfMWI=CDd00TI6AP06PH61<C4aATI6ATI6>SXj
9BDU0Tm?C`05H61Poooooooooooo000002koool010000?oooooooh^;R`8Z:RX01DE5AG5aLFATI6AT
I1`L7002<30`00Hm?CeEEEDd=3@d=3@;2`/e=CD2OGem00IYJFUMGEe4A4A4A4@<30aHF5P2YJFU00EO
Gen<S8b<S8`@411GEeL00WYjNP06ATI6=3@d5QHF5QHF9BDUBd];0QXJ6P05A4A4<S8b<S8b1PH6:RXZ
009IFET01VATI3Ph>51@D51@D3De=CTi>@8l?3`01EIFEXJ6QR/[:b/[:eQHF002De=C00I?Cdm>CTi2
@T92@T8E5AEWIfL2P82000IgMgLW9bLN7QhN7Qi`L70g=cL2NWYj00F6QXIQHF5QHF6>SXi]KFd00T51
@@06A4A4=3@d8b<S8b<SMgMg8R8R0X^;R`05;Bd]@T92@T92OWinGemO008`<3001UADE7EeMIJFUYJF
USXj>S@d=095ADD01FYZJRHV9Rh^;Rh^;QXJ6P02>c/k00JKVi^;Rh/:2PX:2PY3@d<m?Cd2E5AD00F8
R8P`<30c<c<c<c=1@D400XF5Q@06@D51:BTYGUiNGUiNMWIfGUiN0RXZ:P06IVIVD51@DU9BDU9B;Bd]
ATI60Rl_;`05<c<c410@410@<S8b7AdM0098B4P01T];Bfa/K71`L71`L6e]KC8b<P9XJ6P01E1@D55A
DG9bLW9bLSDe=@02ADE500Dc<c<h>3QUIFEUIFEGEeL00oooo`030000oooooooo00goool001Ooool2
00001?ooo`030000oooooooo00;oool01@000?ooooooooooog=cL`02FEUI00I9BDV:RXXc<c<c<c>S
Xj<D51@2LW9b00D^;Ri8B4Q8B4Pi>CTN7Qh00S/k>`065QHF;2`/?Shn?ShnKFe]820P0S8b<P06[:b/
AdM74Q8B4Q8BEUIF=CDe0U9BDP05;2`/3Ph>IfMWIfMW?clo0097AdL01P`<3451@HB4Q8B4Q2DU9HZ:
RP8h>3P01UaLG3Hf=T51@D51@CLg=dU9B@8Y:BT01DM7AbXZ:Ve]KFe]KDM7A`02ATI600ISHf<b<S8o
?clo?cmADE4G5aL26QXJ00IADE4W9bMUIFEUIFDV9RH@4102C4a<00F5QHFLW9`410@410A8B4P00U5A
D@06FUYJ:2PXTY:BTY:B71`L<30`0U]KF`063@d==cLgKVi^KVi^@D51JFUY0SDe=@063`l??Cdm>CTi
>CTi8B4Q>3Ph0UYJFP05C4a<PH61PH61MGEe=3@d008M7Ad01SPh>6m_KcPh>3Ph>3`l?5EEE@8G5aL0
1R8R8XF5QFYZJVYZJX:2PQXJ6P9iNGT01HZ:RSdm?Cdm?EaLG6][J`026QXJ00IlO7aHF5PK6a/K6a]2
@T8O7al29RHV00JATI5GEeM2@T92@T8b<S92@T82820P00EMGEe4A4A2@T92@T97AdL00QXJ6P06>3Ph
RXZ:=3@d=3@d6a/KATI60UaLG005IFEUoooooooooooo000002?oool200001?ooo`030000oooooooo
00;oool010000?ooooooof5QH@9^KVh01EaLG7UiNDM7AdM7Ai>CT`027AdM00ITI6@R8R90@410@40X
:2P];Bd2B4Q800HE5ADk>c]1@D51@D5PH60L71`2<C4a00FOWimEEEEEEEDH61Q=CDd00RTY:@06Fe]K
=cLg61PH61PHL71`AdM70TI6AP053@d=@410@410QXJ6820P00::RXX01SXj>UiNGSLg=cLg=d=3@cTi
>@97AdL01B/[:dY:BRd];Bd];G9bLP02@d=300I5ADETI6@/;2`/;2a6ATIEEED27AdM00HQ8B5=CDd[
:b/[:b]NGUh[:b/22`/;00EDE5B1PH61PH6XZ:P>3Ph00TE5A@06G5aLD51@;bl_;bl_RHV951@D0RDU
9@05F5QH1`L71`L7;Rh^Kfm_009=CDd01V1PH38b<PD51@D51CLg=d92@P8L71`01C0`<6=SHd=3@d=3
@hB4Q002Ogmo00H`<30P820d=3@d=3AfMWH`<302=CDe00EMGEdO7alJ6QXJ6QZ0P8000WAdM006NWYj
92@TMWIfMWIfPH61>c/k0UQHF006Hf=S9BDULG5aLG5aHF5Q9RHV0Ta<C005:RXZ;2`/;2`/Q8B4GUiN
008g=cL01RLW9c8b<Q0@410@45]KFeEEE@93@d<01CDe=Bh^;Sdm?Cdm?H:2PP02BDU900D>3PiJFUY`
L71`L71OGel00oooo`030000oooooooo00goool001Ooool00`000?ooo`000002oooo00<0003oool0
00000oooo`050000ooooooooooooLg=c009IFET01TU9BHZ:RS<c<c<c<j>SXa@D509bLW801Bh^;TQ8
B4Q8B3Ti>AhN7P02>c/k00HF5QH/;2`n?Shn?Si]KFdP8202<S8b00J/[:a7AdLB4Q8B4Q9FEUHe=CD2
DU9B00D/;2`>3PiWIfMWIfLo?cl00TM7A`0630`<@D51Q8B4Q8B49BDURXZ:0SPh>006G5aL=SHf@D51
@D51=cLgBDU90RTY:@05AdM7:RXZKFe]KFe]AdM70096ATH01V=SHc8b<Slo?clo?e5ADALG5`8J6QX0
1U5ADBLW9fEUIFEUIBHV9Q0@409<C4`01HF5QIbLW0@410@414Q8B002DE5A00IJFUXX:2RBTY:BTY8L
71``<302Fe]K00H=3@dg=cM^KVi^KVi1@D5YJFT2=CDe00H?3`lm?Cdi>CTi>CTQ8B4h>3P2FUYJ00E<
C4b1PH61PH5eMGDd=3@00QdM7@06>3PhKfm_>3Ph>3Ph?3`lEEEE0QLG5`068R8RQHF5JVYZJVYZPX:2
6QXJ0WUiN@05RXZ:?Cdm?CdmG5aLJf][008J6QX01WalO5QHF1/K6a/K6d92@QlO7`8V9RH01Y6ATEMG
Ed92@T92@S8b<T92@P8P82001EeMGDA4A492@T92@TM7A`026QXJ00Hh>3R:RXXd=3@d=3@K6a]6ATH2
G5aL00EUIFGoooooooooool000008oooo`030000oooo000000;oool00`000?ooo`000003oooo00@0
003ooooooomQHF42KVi^00ELG5aiNGU7AdM7AdNCTi<00QdM7@06I6AT8R8R@410@410:2PX;Bd]0TQ8
B0065ADE>c/k@D51@D51H61P71`L0S4a<@05WinOEEEEEEEE61PHCDe=008Y:BT01U]KFcLg=aPH61PH
671`L4M7A`96ATH01@d=3D10@410@8J6QR0P8002RXZ:00Hj>SYNGUhg=cLg=cM3@d<i>CT2AdM700D[
:b]:BTX];Bd];BebLW800T=3@`06ADE5I6AT;2`/;2`/ATI6EEEE0QdM7@068B4QCDe=:b/[:b/[GUiN
:b/[0P/;2`05E5ADPH61PH61Z:RX3Ph>0095ADD01UaLG51@D2l_;bl_;hV9RA@D508U9BD01EQHF0L7
1`L71bh^;Vm_K`02CDe=00IPH60b<S851@D51@Dg=cM2@T8271`L00D`<31SHf=3@d=3@d>4Q8@00Wmo
O`06<30`820P=3@d=3@dMWIf<30`0SDe=@05GEeM7alO6QXJ6QXJP820009dM7@01WYjNR@T97IfMWIf
MX61PC/k>`9HF5P01V=SHbDU9G5aLG5aLF5QHBHV9P9<C4`01BXZ:R`/;2`/;8B4Q5iNGP02=cLg00HW
9bLb<S8@410@411KFe]EEED2@d=300De=CD^;Rhm?Cdm?Cf2PX800TU9B@053Ph>FUYJL71`L71`GemO
00?oool00`000?ooooooo`0=oooo000Goooo00<0003oool000000_ooo`030000oooo000000?oool2
00000_ooo`05K6a/<30`<30`[:b/BDU9008P82001H:2PTE5ACXj>SXj>V1PH002GemO00H51@Dj>SY`
L71`L71DE5@n?Sh24Q8B00JTY:A]KFeoOgmoOgm1@D5]KFd2GemO00Hi>CTW9bLQ8B4Q8B4c<c<G5aL2
CTi>00EEEEDm?Cdm?Cf<S8anOWh00VIVIP061PH6De=C9RHV9RHV<30`?Shn0WQhN003Bd];QHF59RHV
008V9RH0120P87MgMgMgMbh^;P94A4@01Q8B4Q`L74M7AdM7AdE5AAdM7@8P82001R@T93De=EUIFEUI
FATI6E]KF`8V9RH01AHF5TM7Afa/K6a/K6EUI@025aLG00Hg=cM8B4PL71`L71`Y:BTR8R824A4A00I5
ADEEEEE=CDe=CDejNWXZ:RX26ATI00IVIVI=CDdK6a/K6a]2@T8b<S824a<C00F2PX8d=3@d=3@/;2`i
>CT00UYJFP06CDe==3@d;2`/;2`/4A4AM7Ad0R4Q8@06CTi>Hf=S?Shn?Shn<30`Lg=c0SHf=P05EEEE
;Bd];Bd]>c/kRXZ:008F5QH01WmoOb/[:b<S8b<S8a@D53@d=09CDe<01YBDU79bLUQHF5QHF3hn?V5Q
H@:[Zj/01GMgMeIFEUaLG5aLG6MWI`02WIfM00Hc<c=BDU8S8b<S8b</;2`P8202H61P00>1PH7ooooo
ool00P0002?oool00`000?ooo`000002oooo00<0003oool000000oooo`8000001_ooodi>CRHV9RHV
9/_;bc0`<08o?cl00f=SHbLW9bLW9`02BTY:0W5aL@066a/K@410GemOGemO@d=3<S8b0QhN7P05SHf=
KVi^Jf][Jf][:RXZ009FEUH01Tm?CbTY:CDe=CDe=@h>3T10@08J6QX01F9RHTM7Adm?Cdm?Ch>3P`02
LW9b00IeMGD71`MLG5aLG5`_;blY:BT2ATI600IkNg]=CDf2PX:2PX8Y:BTV9RH28B4Q00EhN7P];Bd]
;Be4A4@D51@00Q`L7095ADD29BDU0Q`L708_;bl015ADE10@465QHF5QH@<K6a/01UEEEEmOGfYZJVYZ
JQTI6Bl_;`98B4P01BTY:BLW9c8b<S8b<P/;2`02=cLg00IGEeM6ATJ5QHF5QHDS8b<=3@d2I6AT00I?
CdlX:2Ph>3Ph>3Pi>CT92@T2NGUi00Dl?3`a<C4a<C4l?3aPH6000Tm?C`06>3Ph9RHV4Q8B4Q8BNGUi
8B4Q0UADE005I6AT>CTi>CTi<S8bKFe]008k>c/01UaLG3@d=3`l?3`l?7moOb@T909jNWX01B4Q8C@d
=20P820P8492@P02IfMW00J;Rh]NGUi7AdM7AdLV9RIeMGD2Ti>C00IPH61aLG5DE5ADE5AADE6SXj<2
:RXZ00ESHf<G5aLG5aLi>CTK6a/00WemO@03JVYZoooooooo0080000?oooo000Goooo0P0000?oool0
0`000?ooo`000003oooo00D0003ooooooooooolb<S800YFEU@06QHF5>3PhEEEEEEEEBTY::RXZ0SHf
=P05=3@dB4Q8B4Q8JFUYIfMW009]KFd01Ti>CTA4A20P820P84=3@clo?`:UYJD01U5ADDA4A9:BTY:B
TSDe=GQhN096ATH01@P8224Q8Fa/K6a/K1@D5002Bd];00INGUhS8b<V9RHV9RH^;RhL71`2;2`/00H<
30alO7a0@410@41FEUIgMgL2CTi>00ENGUhk>c/];Bd];Bda<C400QLG5`06820P30`<;Bd];Bd]JVYZ
7QhN0R0P8006;bl_CDe=C4a<C4a<;Bd]5aLG0R<S8`05Cdm?<c<cKVi^KVi^=3@d009MGEd01Rd];D=3
@bXZ:RXZ:UYJFUIFEP8d=3@01QPH638b<SPh>3Ph>7moObLW9`9QHF401RXZ:STi>B0P820P83Ti>BTY
:@8l?3`01EYJFS/k>c/k>cHf=SPh>002Zj^[00ILG5`Q8B4J6QXJ6QY7AdMEEED2GEeM00I>CThn?Sin
OWinOWi2@T8h>3P22PX:00F;Rh]ADE5ADE4_;bm5ADD00Va/K006PX:2410@8R8R8R8R7alO5QHF0SXj
>P06@410>c/k<c<c<c<c:b/[PX:20[^k^`05H61P>c/k?Shn?Shn@T9200:BTY801RPX:3`l?5]KFe]K
Fbh^;R/[:`9PH6001D92@_ooooooooooo`00000Soooo0P0000?oool00`000?ooo`000003oooo00@0
003ooooooom2@T82QXJ600FEUIDm?CeVIVIVIVHl?3`00R8R8P069RHV>3Ph>CTi>CTiNWYjLg=c0VYZ
JP06?cloA4A45QHF5QHF?3`lCTi>0YfMW@05Cdm?>SXj>SXjQhN7>SXj00:4Q8@01TQ8B1<C4bDU9BDU
9Fi^KP/;2`95ADD01EMGEalO7alO7b4Q8B/[:`028B4Q00HZ:RX820QiNGUiNGU1@D5CDe<2Ng]k00E<
C4aRHV8h>3Ph>3Pa<C400Rl_;`0671`L9BDU2@T92@T9<C4aJFUY0Q`L7006:2PX:BTYB4Q8B4Q8Bd];
:BTY0Q<C4`0592@TD51@D51@:RXZIVIV008Z:RX01UUIFB<S8d51@D51@C0`<6ATI09OGel01Bd];B8R
8R8R8R`/;3Hf=P02QXJ600HN7QiTI6@X:2PX:2Q1@D4Z:RX2<c<c00Db<S8i>CUCDe=CDe<n?Sh00Rl_
;`06?3`l[Jf]GUiNGUiN8R8R7AdM0T];B`05FEUIH61PCTi>CTi>?Shn00:0P8001T92@SPh>0/;2`/;
2hj>SUADE08];Bd01TU9BFYZJXB4Q8B4Q1DE5B0P808M7Ad01A@D54=3@d=3@cPh>3De=@02>SXj00H[
:b^<S8bd];Bd];AEEEE8B4P2>3Ph00Df=SJFUYHP820P820l?3`00Te=C@05;bl_:BTYLG5aLG5a=SHf
00?oool00`000?ooooooo`0=oooo000Goooo00<0003oooooool00_ooo`030000oooo000000?oool0
1@000?ooooooooooof=SH`02PX:200IOGem^KVhQ8B4Q8B4g=cLS8b<2I6AT00Di>CUfMWIfMWIOGenC
Ti<00QhN7P03B4Q86a/K7QhN008N7Qh01@@412<S8b<S8bl_;clo?`02=3@d00IJFUYNGUinOWinOWiD
E5AkNg/2FEUI00E0@40j>SXj>SXa<C51@D400UADE006MGEe<30`6a/K6a/K;Rh^Q8B40Rd];@06O7al
4a<CHf=SHf=SIfMW];Bd0R`/;005N7Qh<c<c<c<c=3@d7alO009ZJVX01T51@@H61S@d=3@d=2PX:34a
<@8M7Ad01TE5AF9RHT92@T92@R`/;0T92@96ATH01EMGEjJVYZJVYS`l?2/[:`02:2PX00I>CThL71`^
;Rh^;Rhc<c<o?cl2AdM700IQHF5@D51HF5QHF5QBDU8X:2P2<c<c00DO7amVIVHB4Q8B4Q8[:b/00U5A
D@8c<c<2FUYJ00H/;2`I6ATh>3Ph>3Q2@T8K6a/2;2`/00HY:BU3@d>QXJ6QXJ4P820M7Ad2:b/[00EN
GUhD51@D51A;Bd^0P8000P820P06=SHfBDU95ADE5ADEBDU9>3Ph0P410@06IfMW9BDU?Shn?Shn>3Ph
S8b<0VYZJP059bLWD51@A4A4A4A4JFUY009VIVH01U=CDf=SHclo?clo?aXJ6UIFEP98B4P01INGUooo
ooooooooo`00000Soooo00<0003oooooool00_ooo`030000oooo000000?oool010000?oooooooemO
G`:;Rh/01EUIFFa/K1XJ6QXJ6S4a<@02:RXZ00I[Jf/n?SijNWYjNWYKFe^>SXh25aLG00I?CdlR8R8P
820P820G5aL<30`27AdM00DY:BU6ATI6ATHf=SIMGEd00UaLG006OWinDU9BPH61PH61H61PB4Q80T51
@@05;Bd]>SXj>SXjFEUIL71`008i>CT01R<S8bPX:820P820P3Hf=WEeM@8=3@d01E]KFg1`L:b/[:b/
[3Hf=P02Ng]k00H];Bde=CDH61PH61QcLg=1@D4210@400Hm?Cdb<S8X:2PX:2PO7am5ADD2FUYJ00E=
CDd/;2`/;2`:2PY6ATH00U1@D006[jn_<S8b8B4Q8B4Q:RXZCdm?0Q<C4`05<S8b?3`l?3`l=CDeDU9B
009JFUX01Ti>CTm?Ce5ADE5ADC4a<BXZ:P8Y:BT01EeMG@/;2c<c<c<c<eEEE@02;Rh^00Hg=cMEEEDX
:2PX:2PM7Adk>c/2Bd];00DN7Qh_;blP820P821=CDd00YnOW`068B4Q7alO=CDe=CDeEeMG3`l?0TE5
A@06O7al20P8?Cdm?CdmB4Q830`<0Ti>CP05@4101`L71`L7L71`7AdM008i>CT01Slo?hJ6QW5aLG5a
LBd];E=CD`9=CDd01F9RHV=SHdi>CTi>CVa/K002AdM700DR8R9BDU92@T92@T:BTY800oooo`030000
oooooooo00goool001Soool200000oooo`030000oooooooo00;oool01@000?ooooooooooof=SH`02
PX:200IOGem^KVhQ8B4Q8B4g=cLS8b<2I6AT00Di>CUfMWIfMWIOGenCTi<00QhN7P03B4Q86a/K7QhN
008N7Qh01@@412<S8b<S8bl_;clo?`02=3@d00IJFUYNGUinOWinOWiDE5AkNg/2FEUI00E0@40j>SXj
>SXa<C51@D400UADE006MGEe<30`6a/K6a/K;Rh^Q8B40Rd];@06O7al4a<CHf=SHf=SIfMW];Bd0R`/
;005N7Qh<c<c<c<c=3@d7alO009ZJVX01T51@@H61S@d=3@d=2PX:34a<@8M7Ad01TE5AF9RHT92@T92
@R`/;0T92@96ATH01EMGEjJVYZJVYS`l?2/[:`02:2PX00I>CThL71`^;Rh^;Rhc<c<o?cl2AdM700IQ
HF5@D51HF5QHF5QBDU8X:2P2<c<c00DO7amVIVHB4Q8B4Q8[:b/00U5AD@8c<c<2FUYJ00H/;2`I6ATh
>3Ph>3Q2@T8K6a/2;2`/00HY:BU3@d>QXJ6QXJ4P820M7Ad2:b/[00ENGUhD51@D51A;Bd^0P8000P82
0P06=SHfBDU95ADE5ADEBDU9>3Ph0P410@06IfMW9BDU?Shn?Shn>3PhS8b<0VYZJP059bLWD51@A4A4
A4A4JFUY009VIVH01U=CDf=SHclo?clo?aXJ6UIFEP98B4P01INGUoooooooooooo`00000Toooo0P00
00?oool00`000?ooooooo`02oooo00@0003ooooooomOGel2Rh^;00EIFEU/K6`J6QXJ6QXa<C400RXZ
:P06Jf][?ShnNWYjNWYjFe]KSXj>0QLG5`06Cdm?8R8R820P820P5aLG30`<0QdM7@05:BTYATI6ATI6
=SHfGEeM009LG5`01WinOU9BDX61PH61PF1PH4Q8B091@D401Bd];CXj>SXj>UUIFG1`L002>CTi00HS
8b<X:2R0P820P80f=SIeMGD23@d=00EKFe]`L72/[:b/[:`f=SH00W]kN`06;Bd]=CDe61PH61PHLg=c
@D510P@41006?Cdm<S8b:2PX:2PX7alOADE50UYJFP05CDe=;2`/;2`/2PX:ATI6009@D5001Zn_[c8b
<R4Q8B4Q8BXZ:Tm?C`8C4a<01C8b<S`l?3`l?3De=E9BDP02FUYJ00I>CTi?CdmADE5ADE4a<C4Z:RX2
:BTY00EMGEd;2`/c<c<c<c=EEED00Rh^;P06=cLgEEEE:2PX:2PX7AdM>c/k0T];B`057QhN;bl_820P
820PCDe=00:OWil01R4Q8AlO7cDe=CDe=EMGE`l?3`95ADD01WalO0P823dm?Cdm?DQ8B0`<309>CTh0
1D10@0L71`L71g1`L1dM7@02>CTi00Ho?cn6QXIaLG5aLG4];BeCDe<2CDe=00ERHV9SHf=>CTi>CTi/
K6`00TM7A`058R8RDU9B@T92@T92TY:B00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooo
oooooolQ8B400XJ6QP06>SXjVYZJCdm?Cdm?<C4a<S8b0VEUI@05B4Q8=cLg=cLgHf=SNGUi0096ATH0
1RDU9EiNGTe=CDe=CAdM7B`/;09kNg/01YbLW4Q8B410@410@451@FIVIP9eMGD01D51@G1`L9bLW9bL
W492@P02;Bd]00D/;2b;Rh^BTY:BTY9JFUX00a`L7006NGUiH61PGemOGemOJFUY?clo0RXZ:P055ADE
MgMg:BTY:BTYH61P008=3@d01V1PH492@XF5QHF5QA8B4Q/K6`8V9RH01S0`<20P87QhN7QhN2<S8hF5
Q@9JFUX01CXj>S0`<3dm?Cdm?D51@@02TY:B00He=CDM7Ae9BDU9BDTG5aMLG5`2A4A400HM7Af2PX9:
BTY:BTXj>SX`<3029RHV00HR8R95ADD`<30`<30V9RK;bl/26ATI00Dk>c/J6QXJ6QXa<C4g=cL00S<c
<`069BDU6ATIADE5ADE58B4Q0`<30VQXJ006CTi>FEUIEUIFEUIF=CDe61PH0TI6AP0510@40`<30`<3
HV9RQ8B4008F5QH01RPX:2<S8a0@410@455ADCXj>P8g=cL01S8b<Y^KVfMWIfMWIb0P85IFEP8P8200
1AdM7F1PH3Hf=SHf=Y2@T002>CTi00IkNg^9RHU^KVi^KVhe=CDW9bL2T92@00F;Rh_oooooooooool0
0000;_ooo`040000oooooooo7AdM0Xj>SP05>SXjVi^KF5QHF5QH:BTY008a<C401Vi^KU1@D3/k>c/k
>eaLG7MgM`95ADD01QlO7fMWIeEEEEEEEB8R8S<c<`9mOGd01IZJVTI6ATI6ATQ8B3lo?`02KFe]00I`
L718B4Q/K6a/K6bUYJE5ADD2<C4a00DX:2R5QHF5QHFCTi=BDU800RDU9@0671`LL71`Hf=SHf=SIVIV
HF5Q0S@d=0057QhN8R8RK6a/K6a/:b/[009TI6@01P820UEEECLg=cLg=iFEU@X:2P8S8b<01S8b<SLg
=bXZ:RXZ:W5aLC0`<09gMgL01FIVIR/[:b/[:cdm?Da<C002<C4a00JTY:@];BdU9BDU9BDi>CTX:2P2
C4a<00E4A4@W9bLW9bN5QHEGEeL00T];B`06:2PX5QHF92@T92@T=SHf8b<S0QLG5`05_[jn4Q8B=SHf
=SHf6QXJ008T92@01T=3@bHV9QdM7AdM7AXJ6SXj>P8[:b/01@l?3emOGdm?Cdm?Cf1PH002Cdm?00@]
;BdN7QiADE5ADE421`L70V=SH`03Ogmo5ADE:2PX008X:2P011PH64U9BDU9BD=3@`8m?Cd01S@d=9^K
Vg5aLG5aLBDU9E5AD@8W9bL01QXJ6VQXJ3lo?clo?h^;Rc<c<`9eMGD01I>CTfa/K6a/K30`<2TY:@02
R8R800F4Q8Coooooooooool000003oooo`008_ooo`050000ooooooooooooPH61009NGUh01QlO7`L7
1dA4A4A4A3@d=2`/;08j>SX01EeMGL?3`l?3`cHf=UQHF002De=C00IRHV9CDe=aLG5aLG62PX9nOWh2
IVIV00Hk>c/U9BD@410@410_;bmYJFT2=3@d00DJ6QXa<C5HF5QHF5Pb<S800PL71`06ATI6EEEET92@
T92@H61P5QHF0VUYJ@06?clo9RHVBDU9BDU93@d=6QXJ0QhN7P057AdM>CTi820P820P5QHF0090@400
1S8b<WYjNU]KFe]KFdA4A3Ph>095ADD01Ta<C2`/;6a/K6a/K30`<4I6AP9jNWX01C4a<AdM7F=SHf=S
Hda<C002;Bd]00Hm?Ce=CDd_;bl_;blU9BDh>3P27QhN00H=3@e0@41DE5ADE5APH619BDT2820P00Hg
=cL/;2aEEEEEEEE@D519BDT2K6a/00DP822SXj>SXj<P820[:b/00QDE5@06?clo?ShnHF5QHF5Q6ATI
BDU90WAdM006N7Qh4A4A>3Ph>3Ph;Bd]7QhN0V=SH`05:RXZ5QHF5QHFATI69RHV008b<S801Sdm?Gmo
OcDe=CDe=EmOGaDE5@8h>3P01V1PH6IVITU9BDU9BChn?VYZJP8`<3001AlO7hJ6QP`<30`<31PH6002
9bLW00H_;bmjNWY>CTi>CTjSXj=kNg/2@41000F/[:coooooooooool00000;_ooo`040000oooooooo
Ogmo0V=SH`0571`L2`/;AdM7AdM7=SHf008Y:BT01SLg=eeMGLW9bLW9bC@d=5IFEP9DE5@01VMWIe1@
D6i^KVi^KWmoOgemO@9VIVH01Chn?R4Q8B4Q8A@D52`/;002JFUY00Hi>CTH61Pe=CDe=CECDe<_;bl2
1`L700E0@41HF5QHF5RFUYIOGel00Ph>3P06HV9R?Cdm7QhN7QhNDe=C1PH60QTI6@057alO6ATI;Rh^
;Rh^;2`/008O7al01Sdm?BDU9GUiNGUiNFUYJDE5A@93@d<01TU9BChn?STi>CTi>EeMGB/[:`8h>3P0
1GIfMRLW9bLW9ahN7VMWI`02DU9B00Hl?3a2@T9:BTY:BTX[:b/D51@2?clo00DB4Q8410@410@n?SiS
Hf<00W5aL@06FEUI;bl_@T92@T928R8RDE5A0TY:BP05>c/kGemO6a/K6a/KV9RH008Z:RX01RLW9aXJ
6TA4A4A4A3Ti>EQHF08S8b<01DY:BW9bLWMgMgMgMa/K6`02=SHf00HW9bLN7QiSHf=SHf<];BdI6AT2
C4a<00HT92@e=CDj>SXj>SZ0P80e=CD2GUiN00DH61Ph>3Ph>3QSHf=VIVH00TY:BP06?CdmJVYZ;bl_
;bl_7QhNQXJ60P`<30056a/K9BDU<S8b<S8bNGUi009BDU801J:RXX20P492@T92@Zn_[`03oooo00<0
003oooooool03Oooo`008_ooo`050000ooooooooooooPH61009NGUh01QlO7`L71dA4A4A4A3@d=2`/
;08j>SX01EeMGL?3`l?3`cHf=UQHF002De=C00IRHV9CDe=aLG5aLG62PX9nOWh2IVIV00Hk>c/U9BD@
410@410_;bmYJFT2=3@d00DJ6QXa<C5HF5QHF5Pb<S800PL71`06ATI6EEEET92@T92@H61P5QHF0VUY
J@06?clo9RHVBDU9BDU93@d=6QXJ0QhN7P057AdM>CTi820P820P5QHF0090@4001S8b<WYjNU]KFe]K
FdA4A3Ph>095ADD01Ta<C2`/;6a/K6a/K30`<4I6AP9jNWX01C4a<AdM7F=SHf=SHda<C002;Bd]00Hm
?Ce=CDd_;bl_;blU9BDh>3P27QhN00H=3@e0@41DE5ADE5APH619BDT2820P00Hg=cL/;2aEEEEEEEE@
D519BDT2K6a/00DP822SXj>SXj<P820[:b/00QDE5@06?clo?ShnHF5QHF5Q6ATIBDU90WAdM006N7Qh
4A4A>3Ph>3Ph;Bd]7QhN0V=SH`05:RXZ5QHF5QHFATI69RHV008b<S801Sdm?GmoOcDe=CDe=EmOGaDE
5@8h>3P01V1PH6IVITU9BDU9BChn?VYZJP8`<3001AlO7hJ6QP`<30`<31PH60029bLW00H_;bmjNWY>
CTi>CTjSXj=kNg/2@41000F/[:coooooooooool00000;_ooo`040000ooooooooOgmo0V=SH`0571`L
2`/;AdM7AdM7=SHf008Y:BT01SLg=eeMGLW9bLW9bC@d=5IFEP9DE5@01VMWIe1@D6i^KVi^KWmoOgem
O@9VIVH01Chn?R4Q8B4Q8A@D52`/;002JFUY00Hi>CTH61Pe=CDe=CECDe<_;bl21`L700E0@41HF5QH
F5RFUYIOGel00Ph>3P06HV9R?Cdm7QhN7QhNDe=C1PH60QTI6@057alO6ATI;Rh^;Rh^;2`/008O7al0
1Sdm?BDU9GUiNGUiNFUYJDE5A@93@d<01TU9BChn?STi>CTi>EeMGB/[:`8h>3P01GIfMRLW9bLW9ahN
7VMWI`02DU9B00Hl?3a2@T9:BTY:BTX[:b/D51@2?clo00DB4Q8410@410@n?SiSHf<00W5aL@06FEUI
;bl_@T92@T928R8RDE5A0TY:BP05>c/kGemO6a/K6a/KV9RH008Z:RX01RLW9aXJ6TA4A4A4A3Ti>EQH
F08S8b<01DY:BW9bLWMgMgMgMa/K6`02=SHf00HW9bLN7QiSHf=SHf<];BdI6AT2C4a<00HT92@e=CDj
>SXj>SZ0P80e=CD2GUiN00DH61Ph>3Ph>3QSHf=VIVH00TY:BP06?CdmJVYZ;bl_;bl_7QhNQXJ60P`<
30056a/K9BDU<S8b<S8bNGUi009BDU801J:RXX20P492@T92@Zn_[`03oooo00<0003oooooool03Ooo
o`008_ooo`800002oooo00D?3`n;Rh^;Rh^0P810@4000TE5A@05<S8b8B4Q=cLg=cLgDe=C00:VYZH0
1PX:2Y:BTSlo?clo?cdm?E=CD`:5QHD01W1`L3De=FQXJ6QXJ2PX:6ATI09fMWH01S/k>cDe=@<30`<3
0b/[:b8R8P9gMgL01AXJ6SPh>3Ph>7inOT=3@`02:RXZ00HF5QH;2`]VIVIVIVI4A4A5ADD2@T9200I]
KFe6ATIDE5ADE5AFEUIEEED26QXJ00E0@40i>CTi>CT?3`lQ8B400UiNGP068B4QH61PLg=cLg=c=3@d
J6QX0XR8R004410@<30`HV9RHV9R0T10@08N7Qh01DE5ADi>CTi>CP820Ti>CP02ADE500HN7Qi0@410
@410@41RHV8`<302410@00J8R8QXJ6Pd=3@d=3AcLg=PH6028B4Q00ENGUhQ8B4?3`l?3`li>CT00T10
@0066QXJEEEEEUIFEUIFE5ADATI60Ve]K@06@T92ADE5A4A4A4A4IVIV2`/;0QHF5P05:RXZ@d=3OWin
OWin>3Ph008J6QX01WMgMb8R8R/[:b/[:`<30cDe=@8k>c/01WIfMVATI2PX:2PX:6QXJ3De=@9`L700
1XF5QE=CDcdm?Cdm?Clo?i:BTP8:2PX01JJVYU=CDe=CDcLg=b4Q8@02<S8b00E5ADE0@420P820P82;
Rh/00_ooo`80000^oooo0P000006oooo5QHFSHf=SHf=QHF5B4Q80TU9B@05>SXj6QXJ6QXJ=3@dCDe=
00:YZJT00`P828f=SClo?`02?clo00ECDe=oOgmoOgmeMGDa<C400VUYJ@05;bl_GEeMGEeMNg]k=cLg
008^;Rh01PX:2S8b<R/[:b/[:g9bLR8R8P8b<S801GMgMda<C4a<C2/[:aXJ6P021PH600INGUi7AdM7
AdM7AdM2@T9^KVh2ATI600EMGEe?CdmLG5aLG5`E5AD00SHf=P06<C4a3`l?9RHV9RHVIfMW7QhN0VYZ
JP06N7Qh<C4aM7AdM7AdR8R81@D50Rh^;P05Fe]K?clo?clo>SXj8b<S008n?Sh01TA4A0T92DA4A4A4
A3hn?R<S8`8j>SX01Clo?e]KFe]KFbh^;PD51@02R8R800IdM7@a<C5hN7QhN7QZJVXN7Qh2IfMW00DV
9RH?3`la<C4a<C4f=SH00QDE5@06G5aLCdm?GEeMGEeMATI6KVi^0T92@P97AdL2GUiN00D61PHJ6QXJ
6QX[:b]<C4`00WMgM`06<S8b8R8RLW9bLW9b:b/[<S8b0PX:2P05;Rh^=cLgNg]kNg]kGEeM008_;bl0
1VUYJC4a<GEeMGEeMGmoOe=CD`<o?cl01Hf=S@P820P82:VYZDe=C@02=3@d00DJ6QXj>SXj>SY9BDU8
B4P00XF5Q@03SHf=oooooooo0080000?oooo000Roooo00D0003ooooooooooon1PH400Zb/[006@410
Ng]kXj>SXj>SCTi>NWYj0Rl_;`059bLW61PH61PH30`<QXJ6008O7al01S0`<6YZJShn?Shn?TU9BFIV
IP9PH6001SPh>1DE5EmOGemOGcDe=GmoO`8m?Cd01C8b<RHV9TI6ATI6AQHF5P02:RXZ00ISHf<N7Qh]
;Bd];Bdh>3PA4A42N7Qh00IdM7A9BDTI6ATI6AUQHF4n?Sh2?clo00DE5AD[:b/P820P822SXj<00R0P
8006K6a/BDU9D51@D51@EEEE;2`/0SLg=`06820PBDU9H61PH61PE5AD@4100Pd=3@057QhN>3Ph9BDU
9BDU;bl_009=CDd01Sdm?Bd];Da<C4a<C6=SHadM7@8a<C401WYjNTI6AS0`<30`<6a/K2`/;09<C4`0
1TE5ACPh>4A4A4A4A5]KFgYjNP8b<S801D10@1HF5QHF5R0P83Ti>@027AdM00HN7QhJ6QX=3@d=3@e9
BDTV9RH2?clo00IYJFTF5QIPH61PH62@T91EEED2ATI600D71`Lb<S8b<S9HF5Pa<C400QXJ6P06=3@d
JFUY;bl_;bl_410@9BDU0S/k>`06IVIVOWinPX:2PX:2LG5aDe=C0V9RHP05De=CF5QH=SHf=SHf`l?3
009MGEd01SXj>R`/;3@d=3@d=4A4A0L71`8O7al01EiNG_ooooooooooo`00000^oooo00@0003ooooo
oomoOgl2[jn_00E2@T:0P82RXZ:RXZ9BDU800WUiN@06<S8b9BDU6a/K6a/K30`<QXJ60QhN7P06;bl_
JVYZ?Cdm?CdmBTY:IVIV0V=SH`05>3Ph61PH61PHGUiN=CDe00:0P8001SXj>SDe=B@T92@T94a<C1TI
6@8];Bd01F=SHahN7QhN7RLW9cHf=P026a/K00IgMgMbLW9:BTY:BTXS8b=HF5P2>CTi00E4A4@J6QXW
9bLW9bLZ:RX00YRHV0066a/KGemO>c/k>c/kBTY:DE5A0R8R8P06@T92;bl_FEUIFEUILG5aHf=S0Shn
?P0510@44Q8B4Q8B?clo51@D008[:b/01TY:BT92@S`l?3`l?59BDVMWI`8N7Qh01BLW9gIfMWIfMSPh
>2/[:`02GEeM00Hi>CTn?Si9BDU9BDU3@d=5ADD2JFUY00EiNGTU9BDm?Cdm?CdO7al00R`/;006;Rh^
6ATI7alO7alO6ATI1PH60U=CD`057QhN?CdmHV9RHV9R3Ph>009OGel01YJFUUQHF410@410@0L71bl_
;`9CDe<01SDe=APH63Ti>CTi>FUYJB`/;08D51@01B4Q8Chn?Shn?VIVIWemO@02Ogmo00I^KVi@D51W
IfMWIfMDE5AFEUH2=3@d00G9bLUMGEdg=cLg=cLY:BT00SHf=P05AdM72`/;71`L71`LHf=S00?oool0
0`000?ooooooo`0=oooo000Roooo00D0003ooooooooooolQ8B400X^;R`06T92@9bLW=CDe=CDeKVi^
RHV90W]kN`05>CTiT92@T92@=SHfH61P008M7Ad01R0P85IFER0P820P86MWIi^KV`8b<S801SLg=cXj
>U5ADE5ADA0@42<S8`8X:2P01AHF5XB4Q69RHV9RHP<30`0210@400I6ATHH61Pe=CDe=CEFEUIIFET2
CTi>00IXJ6P30`<Q8B4Q8B55ADDI6AT29BDU00Dc<c<g=cLa<C4a<C4J6QX00S/k>`066ATIbl_;9RHV
9RHV<30`ADE50R8R8P069RHV<30`>SXj>SXjBTY:PX:20QdM7@05A4A4G5aL5aLG5aLGBDU9008M7Ad0
1SDe=I:BTT51@D51@Cdm?C0`<08j>SX01UYJFXF5QB<S8b<S8gQhN20P808`<3001RHV9Q/K6a8B4Q8B
4XF5QD92@P9PH6001@d=3F1PH61PH2TY:GMgM`025ADE00HZ:RXo?cmYJFUYJFUOGemPH602NGUi0Q`L
709JFUX01I:BTX^;Rb`/;2`/;2d];@02@T9200JLW9a`L711@D51@D5eMGEVIVH2@D5100I0@418B4RL
W9bLW9akNg//;2`27AdM00I=CDeNGUhU9BDU9BE6ATIiNGT2Hf=S00Dg=cM8B4Q8B4QUIFDb<S800S4a
<@05Cdm?VYZJ>SXj>SXjQXJ600?oool00`000?ooooooo`0/oooo00@0003ooooooolM7Ad2Q8B400F8
R8PY:BT`<30`<31/K6`00Y>CT`06MGEe<c<cRh^;Rh^;?cloJ6QX0QXJ6P069bLWDE5A9BDU9BDULG5a
Vi^K0S@d=005?Cdm@d=3@d=3BDU961PH00<X:2P011DE5GmoOgmoOf=SH`<71`L01E5ADAhN7QhN7Rd]
;Dm?C`02H61P00I?CdmOGel?3`l?3`l[:b/j>SX26QXJ00DM7AdV9RI3@d=3@d<T92@00QXJ6P06=SHf
4Q8B_[jn_[jn5aLG8b<S0SHf=P0692@T5QHF:2PX:2PXBd];EeMG0XF5Q@059bLWA4A4A4A4C4a<:2PX
008i>CT01RDU9Bd];JBTY:BTY34a<Da<C08m?Cd01B/[:fIVIVIVIWMgMc0`<002LG5a00HZ:RXg=cLb
<S8b<S8S8b<:2PX2UIFE00Dg=cMEEED20P820P9TI6@00R/[:`06K6a/8R8R7QhN7QhN=3@dHF5Q0VIV
IP05Hf=SL71`71`L71`L9BDU009BDU801Y>CThF5QBPX:2PX:34a<DE5A@:UYJD01Va/K4Q8B71`L71`
L6e]KClo?`98B4P01DI6AYZJVYZJVWemOC<c<`028R8R00IEEEEWIfLO7alO7am5ADEgMgL2G5aL00Dk
>c]@D51^KVi^KVha<C400RTY:@05F5QHVi^K>SXj>SXjSXj>00?oool00`000?ooooooo`0=oooo000R
oooo00D0003ooooooooooolQ8B400X^;R`06T92@9bLW=CDe=CDeKVi^RHV90W]kN`05>CTiT92@T92@
=SHfH61P008M7Ad01R0P85IFER0P820P86MWIi^KV`8b<S801SLg=cXj>U5ADE5ADA0@42<S8`8X:2P0
1AHF5XB4Q69RHV9RHP<30`0210@400I6ATHH61Pe=CDe=CEFEUIIFET2CTi>00IXJ6P30`<Q8B4Q8B55
ADDI6AT29BDU00Dc<c<g=cLa<C4a<C4J6QX00S/k>`066ATIbl_;9RHV9RHV<30`ADE50R8R8P069RHV
<30`>SXj>SXjBTY:PX:20QdM7@05A4A4G5aL5aLG5aLGBDU9008M7Ad01SDe=I:BTT51@D51@Cdm?C0`
<08j>SX01UYJFXF5QB<S8b<S8gQhN20P808`<3001RHV9Q/K6a8B4Q8B4XF5QD92@P9PH6001@d=3F1P
H61PH2TY:GMgM`025ADE00HZ:RXo?cmYJFUYJFUOGemPH602NGUi0Q`L709JFUX01I:BTX^;Rb`/;2`/
;2d];@02@T9200JLW9a`L711@D51@D5eMGEVIVH2@D5100I0@418B4RLW9bLW9akNg//;2`27AdM00I=
CDeNGUhU9BDU9BE6ATIiNGT2Hf=S00Dg=cM8B4Q8B4QUIFDb<S800S4a<@05Cdm?VYZJ>SXj>SXjQXJ6
00?oool00`000?ooooooo`0/oooo00@0003ooooooolM7Ad2Q8B400F8R8PY:BT`<30`<31/K6`00Y>C
T`06MGEe<c<cRh^;Rh^;?cloJ6QX0QXJ6P069bLWDE5A9BDU9BDULG5aVi^K0S@d=005?Cdm@d=3@d=3
BDU961PH00<X:2P011DE5GmoOgmoOf=SH`<71`L01E5ADAhN7QhN7Rd];Dm?C`02H61P00I?CdmOGel?
3`l?3`l[:b/j>SX26QXJ00DM7AdV9RI3@d=3@d<T92@00QXJ6P06=SHf4Q8B_[jn_[jn5aLG8b<S0SHf
=P0692@T5QHF:2PX:2PXBd];EeMG0XF5Q@059bLWA4A4A4A4C4a<:2PX008i>CT01RDU9Bd];JBTY:BT
Y34a<Da<C08m?Cd01B/[:fIVIVIVIWMgMc0`<002LG5a00HZ:RXg=cLb<S8b<S8S8b<:2PX2UIFE00Dg
=cMEEED20P820P9TI6@00R/[:`06K6a/8R8R7QhN7QhN=3@dHF5Q0VIVIP05Hf=SL71`71`L71`L9BDU
009BDU801Y>CThF5QBPX:2PX:34a<DE5A@:UYJD01Va/K4Q8B71`L71`L6e]KClo?`98B4P01DI6AYZJ
VYZJVWemOC<c<`028R8R00IEEEEWIfLO7alO7am5ADEgMgL2G5aL00Dk>c]@D51^KVi^KVha<C400RTY
:@05F5QHVi^K>SXj>SXjSXj>00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooomS
Hf<00YNGU`06B4Q8EUIF6QXJ6QXJ?cloHf=S0U=CD`05IVIVJFUYJFUYA4A4D51@008W9bL01VYZJXb<
S3Ph>3Ph>3hn?RDU9@9WIfL01P410CPh>4U9BDU9BADE5DU9B@8f=SH01@820X20P4];Bd];Ba@D5002
GUiN00H[:b/M7AdP820P822QXJ53@d<2:BTY00H/;2`K6a]2@T92@T8h>3PI6AT2;2`/00EJFUXc<c<c
<c<c<c=ADE400R/[:`064Q8BIVIV7alO7alO<c<c:2PX0U9BDP06F5QHD51@HF5QHF5QAdM7?clo0S<c
<`05;Rh^71`LCTi>CTi>:2PX008[:b/01S`l?:JVYUMGEeMGEdI6APT92@8/;2`01T92@V9RHTE5ADE5
AAdM7C4a<@8X:2P01S@d=0H61T51@D51@FYZJQlO7`8d=3@01C<c<gQhN7QhN2`/;;Bd]002IfMW00IS
Hf<C4a=lO7alO7`];Bf4Q8@2;Rh^00HK6a/`<31eMGEeMGEDE5A1@D42<C4a00Dj>SY0@410@41IFEUk
Ng/00UADE006OWinGUiNFUYJFUYJ=3@d?clo0Rl_;`038b<S10@47QhN008N7Qh01A/K6dQ8B4Q8B1hN
7Y>CT`02GemO00EfMWHi>CTi>CUTI6@S8b<00SLg=`058B4QKVi^GemOGemOPX:200?oool00`000?oo
ooooo`0/oooo00@0003ooooooomOGel2TY:B00E2@T9BDU8R8R8R8R97AdL00Va/K006CTi>Hf=SHV9R
HV9RCDe=De=C0Rd];@06LG5aQXJ6?clo?clo>CTi7AdM0W1`L0051`L7@410@410CTi>30`<0098B4P0
1Sdm?@P827alO7alO4E5A@l?3`9GEeL01CDe=AlO7alO7b4Q8InOW`02CDe=00HP820_;blN7QhN7Qi;
Bd/k>c/27AdM00DX:2QEEEDg=cLg=cL^;Rh00UEEE@06<c<c2`/;GEeMGEeM:BTY:RXZ0S4a<@06DE5A
Cdm?CTi>CTi>FUYJDU9B0SDe=@05?3`l<S8b<S8b4a<CCdm?008Z:RX01R4Q8C8b<Zn_[jn_[e1@D4I6
AP8:2PX01B`/;4e=CDe=CEYJFTE5A@027alO00HX:2Pb<S8m?Cdm?Cd410A1@D42Lg=c00DH61Pe=CD]
;Bd];BekNg/00SHf=P06[:b/L71`Fe]KFe]K3@d=MGEe0SHf=P05P820:2PX8b<S8b<S>CTi009`L700
1UUIFCXj>Rd];Bd];D51@DQ8B09PH6001X61PE9BDWinOWinOUaLG5eMG@8f=SH01DI6ARTY:BTY:AdM
7@`<30025aLG00HP820R8R9?Cdm?CdlG5aN>SXh2Fe]K00EjNWXn?Si[Jf][Jf/Z:RX00S4a<@056QXJ
K6a/FEUIFEUIRh^;00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooolb<S800T92
@P06H61P:b/[;Rh^;Rh^Fe]K?3`l0RPX:005TY:B@T92@T92?Shn>c/k009PH6001[^k^h:2PR/[:b/[
:c<c<c/k>`90@4001SXj>QHF5QlO7alO7b8R8Q0@40:2PX801Fa/K4E5ABl_;bl_;e5AD@02Rh^;00H:
2PXh>3Q2@T92@T9nOWhn?Sh2CTi>00IMGEeEEEE7AdM7AdLJ6QXQ8B42G5aL00F[Zj/h>3Pf=SHf=SHk
>c/00UYJFP06?3`l:BTY>CTi>CTi820P>CTi0RXZ:P06HF5Q9bLWOgmoOgmo>3Ph<S8b0QPH6005=3@d
EUIFFUYJFUYJ:RXZ0093@d<01Rd];EeMGC@d=3@d=6i^KS<c<`9?Cdl01R<S8aLG5bd];Bd];Da<C4e=
C@8_;bl01R0P81hN7VYZJVYZJRd];@`<308P82001ALG5c4a<C4a<Bd];C/k>`02GUiN00I>CTigMgMF
EUIFEUI0@41lO7`230`<00H/;2`L71`^;Rh^;RhV9RHS8b<2GUiN00E;Bd/D51@D51A/K6`Q8B400PP8
2006ATI6N7Qh=CDe=CDeTY:BA4A40U5AD@06YJFU?clo@d=3@d=3820PA4A40Ti>CP05KFe]IfMWJFUY
JFUYB4Q8008d=3@01SHf=RXZ:TY:BTY:BUEEECPh>0:5QHD01IFEUOooooooooooo`00000^oooo00@0
003ooooooom2@T82=SHf00EaLG4Y:BT_;bl_;bm=CDd00S`l?006820PUYJF=SHf=SHf>3PhB4Q80UEE
E@06];BdS8b<:b/[:b/[>SXj=CDe0SPh>005@d=351@D51@D7AdM820P008E5AD01XB4Q6YZJTU9BDU9
BBd];EADE0:>SXh01@/;2cPh>3Ph>492@X20P002?Shn00I>CTiPH61IFEUIFEU;Bd/M7Ad28R8R00EN
GUj][Jdl?3`l?3`_;bl00Shn?P06De=C>CTi<S8b<S8b<c<c:RXZ0T51@@06:2PXI6AT7QhN7QhNQXJ6
=SHf0R`/;0058R8R;Bd];Bd]GemOI6AT008`<3001T51@B<S8eUIFEUIFBXZ:VIVIP8Z:RX01E1@D2@T
92@T91<C4bTY:@02Bd];00I8B4PY:BTX:2PX:2PL71aYJFT2<C4a00D92@TU9BDL71`L71`_;bl00S4a
<@06>3PhHV9RC4a<C4a<Ng]kDe=C0T51@@05NGUi20P8:RXZ:RXZ8B4Q008[:b/01R4Q8AlO7eMGEeMG
EdE5A@/;2`9^KVh01RDU9A<C4dQ8B4Q8B8B4Q3Xj>P:7QhL01CXj>Tm?Cdm?CifMWDi>CP02?3`l00HF
5QI4A4@o?clo?cmZJVYcLg<2NWYj00Di>CTh>3PV9RHV9RHR8R800S`l?005IVIV?CdmUIFEUIFEQXJ6
00?oool00`000?ooooooo`0=oooo000Roooo0P0000;oool01Fa/K861PH61PF1PH20P8002;2`/00DS
8b=BDU8c<c<c<c>MWId00VMWI`06G5aLEUIFMgMgMgMgZj^[HF5Q0Shn?P06F5QHLW9bU9BDU9BDDe=C
=3@d0Q@D50068b<S:b/[OgmoOgmo5QHFRXZ:0S/k>`05;Bd]EEEEEEEE=SHfLg=c008`<3001Shn?V=S
Hdi>CTi>CR4Q8GAdM08A4A401R`/;3@d=4e=CDe=CEYJFSTi>@8/;2`01C@d=8:2PX:2PQ<C4c8b<P02
@T9200HK6a]=CDeVIVIVIVHI6ATZ:RX2NWYj00I=CDeEEEE5ADE5ADDA4A4R8R82:BTY00DL71a8B4Q8
B4Pg=cLG5aL00VEUI@06K6a/AdM75QHF5QHF9RHVFe]K0QTI6@06FEUI=CDe92@T92@T820P7AdM0TE5
A@05AdM771`L4Q8B4Q8BA4A4008^;Rh00gMgMb0P82HV9P029RHV00F5QHE;Bd];Bd]hN7Pn?Sh00S0`
<0069RHVDe=C1PH61PH6IVIVOWin0Xb<S005?CdmEEEEEEEECTi>5aLG008c<c<01R4Q8BLW9cTi>CTi
>EmOGfe]K@91@D401WmoOfe]KJBTY:BTY18B4Shn?P9DE5@01G1`L3Xj>PD51@D51EmOG`02H61P00Hj
>SY5ADF2PX:2PX8P8219BDT2[:b/00<`<33oooooool00P0002koool2000000Kooom>CTiZJVYZJVYm
OGdK6a/2>CTi00DG5aMSHf=SHf<Z:RZSXj<00U5AD@06E5ADLG5aH61PH61PTi>CMGEe0RHV9P05AdM7
GUiNRh^;Rh^;IfMW0092@T801R0P83@d=24Q8B4Q8GYjNR@T909oOgl01C`l?3@d=5aLG5aLG3/k>`02
KFe]00Hb<S8i>CUTI6ATI6ADE5@Q8B42NGUi00HB4Q8V9RHh>3Ph>3Q?CdmPH602?3`l00Da<C4l?3`l
?3aiNGT92@T00STi>@06>3Ph:2PXCdm?Cdm?I6AT3@d=0R<S8`05QHF5ATI6EeMGEeMG=cLg008;2`/0
1S8b<RLW9bTY:BTY:DQ8B2l_;`8I6AT016YZJUmOGeEEEEEEE@<K6a/01F5QHA0@45ADE5ADE2l_;`03
71`L00HU9BE5ADE5ADE5ADDL71`D51@2A4A400D];BehN7QhN7PQ8B4V9RH00RTY:@06PX:2CDe=Ng]k
Ng]kATI6:BTY0Rl_;`05G5aL1`L71`L7MGEeLW9b00:3Ph<01Tm?CdM7Af9RHV9RHQXJ6T10@08>3Ph0
1CDe=BTY:Dm?Cdm?CeIFEP02:RXZ00I[Jf]^KVj=SHf=SHdN7Qhb<S82@d=300EOGem0@40K6a/K6a]a
LG400dY:BP059bLWHf=SHf=S?clo<30`00;;bl/00bHV9_ooooooo`0200003oooo`008_ooo`050000
ooooooooooooK6a/00:1PH401V1PH20P82`/;2`/;2<S8e9BDP8c<c<01IfMWFMWIfMWIeaLG5IFEP02
MgMg00J[Zj]QHF4n?Shn?SiHF5QbLW82U9BD00ICDe<d=3@D51@D51@S8b<[:b/2Ogmo00DF5QJ:RXXk
>c/k>c/];Bd00UEEE@06=SHfLg=c<30`<30`?ShnHf=S0Ti>CP068B4QM7Ad4A4A4A4A;2`/=3@d0Te=
C@05FUYJ>CTi;2`/;2`/=3@d00:2PX801Q<C4c8b<T92@T92@Q/K6de=C@9VIVH01QTI6BXZ:WYjNWYj
NTe=CEEEE@95ADD01A4A4B8R8RTY:BTY:A`L7002B4Q800Hg=cLG5aMUIFEUIFE/K6a7AdL25QHF00HV
9RIKFe/I6ATI6AUIFETe=CD292@T00HP820M7Ae5ADE5ADE7AdLL71`24Q8B00E4A4@^;Rh^;RigMgLP
82000bHV9P05QHF5Bd];Bd];N7Qh?Shn008`<3001RHV9U=CD`H61PH61VIVIWinOP:<S8`01Cdm?EEE
EEEEEDi>CQLG5`02<c<c00HQ8B4W9bLi>CTi>CUOGem]KFd2@D5100IoOgm]KFfTY:BTY:@B4Q8n?Sh2
E5AD00E`L70j>SX51@D51@EOGel00V1PH006>SXjADE5PX:2PX:2820PBDU90Zb/[005<30`oooooooo
oooo000002koool010000?ooooooodi>CP9ZJVX01GemOA/K6cTi>CTi>ALG5`02Hf=S00HZ:RZSXj=A
DE5ADE5DE5AaLG42H61P00JCTi=eMGDV9RHV9RI7AdMNGUh2Rh^;00EWIfM2@T92@T8P820d=3@00R4Q
8@06NWYj92@TOgmoOgmo?3`l=3@d0UaLG005>c/kKFe]KFe]<S8b>CTi009TI6@01UADE24Q8GUiNGUi
NA8B4RHV9P8h>3P01Dm?Cf1PH3`l?3`l?34a<@02?3`l00IiNGT92@Ti>CTi>CTh>3PX:2P2Cdm?00IT
I6@=3@dS8b<S8b>5QHE6ATH2EeMG00Dg=cL;2`/;2`/b<S8W9bL00RTY:@06B4Q8;bl_6ATI6ATIJVYZ
GemO0UEEE@<K6a/01F5QHA0@45ADE5ADE2l_;`0371`L00HU9BE5ADE5ADE5ADDL71`D51@2A4A400D]
;BehN7QhN7PQ8B4V9RH00RTY:@06PX:2CDe=Ng]kNg]kATI6:BTY0Rl_;`05G5aL1`L71`L7MGEeLW9b
00:3Ph<01Tm?CdM7Af9RHV9RHQXJ6T10@08>3Ph01CDe=BTY:Dm?Cdm?CeIFEP02:RXZ00I[Jf]^KVj=
SHf=SHdN7Qhb<S82@d=300EOGem0@40K6a/K6a]aLG400dY:BP059bLWHf=SHf=S?clo<30`00;;bl/0
1BHV9_ooooooooooo`00000?oooo000Roooo00D0003ooooooooooomcLg<00VEUI@06G5aLATI66a/K
6a/K=3@dRXZ:0SPh>0056QXJAdM7AdM7@T92A4A4009MGEd01R0P8492@S8b<S8b<T92@UMGE`:ATI40
1RHV9QlO7d92@T92@Q/K6eQHF09lO7`01AXJ6V][JeaLG5aLG3dm?@02RXZ:00IiNGTJ6QZ2PX:2PX9Z
JVZ5QHD28R8R00HG5aMEEEDl?3`l?3`h>3Q_Kfl2>3Ph00DM7Add=3AeMGEeMGF1PH400Ta<C006FUYJ
>3Ph8B4Q8B4Q>CTi?Cdm0Pl?3`06=CDeJFUY@D51@D51KVi^=cLg0Pd=3@05Fe]K<30`71`L71`LTY:B
008X:2P01UYJFU5ADDQ8B4Q8B0@419bLW0:5QHD01Ta<C10@42HV9RHV9VEUIBLW9`9ADE401QXJ6QLG
5e5ADE5ADClo?c8b<P9SHf<01DI6ATM7AdM7Afe]KBXZ:P02AdM700HY:BU9BDTg=cLg=cM1@D4f=SH2
G5aL00Hh>3R:RXXU9BDU9BF4Q8A1@D4230`<00E7AdLo?clo?cmWIfL>3Ph00R`/;006DU9B=CDeEUIF
EUIF4Q8BAdM70Zb/[006<S8b820PKFe]KFe]?Shn;2`/0QHF5P05>c/k7QhN>CTi>CTiB4Q8008^;Rh0
1W9bLQ@D5:>SXj>SXc<c<hZ:RP99BDT01EUIFOooooooooooo`00000^oooo00@0003ooooooomQHF42
GemO00E`L71JFUX>3Ph>3Pi9BDT00X:2PP06?Cdm;Rh^=CDe=CDe@d=3EEEE0U]KF`06410@<S8b9bLW
9bLW=cLgGUiN0XB4Q005;2`/:RXZ:RXZC4a<9RHV009QHF401W5aLBDU9F=SHf=SHeQHF3/k>`:1PH40
1GIfMR@T92@T97YjNWAdM002P82000HJ6QXO7amMGEeMGEde=CD`<302MWIf00Dd=3@P820`<30`<31o
Ogl00XB4Q006@d=3Hf=S<30`<30`71`L@T920SLg=`061@D5<S8bH61PH61PCDe=Kfm_0Rh^;P051`L7
F5QHF5QH9BDU51@D00:9RHT01Rl_;e1@D5aLG5aLG4E5A@h>3P:XZ:P01H61PEADE5ADE0/;2b/[:`02
GUiN00H[:b]=CDdQ8B4Q8B4M7AeEEED2ATI600D/;2aTI6A5ADE5ADE3@d<00W9bLP06;Bd]BTY::b/[
:b/[AdM7>CTi0T=3@`05=cLgGUiN>SXj>SXjRXZ:008P82001XJ6QT10@0d=3@d=3DI6ATM7A`9`L700
1QPH63Lg=e]KFe]KFbTY:De=C@8H61P01EEEEInOWinOWc4a<A`L7002H61P00I1@D4k>c/E5ADE5AE8
B4P];Bd2:2PX00E0@40R8R9TI6ATI6@M7Ad00Y>CT`05AdM7NGUiG5aLG5aLKVi^00?oool00`000?oo
ooooo`0=oooo000Roooo00D0003ooooooooooonNWYh00V1PH006Cdm?9BDU>SXj>SXjATI6<C4a0X61
P@05ATI6CDe=CDe=MWIf;bl_009SHf<01X61PG=cLe5ADE5ADD];B`d=3@8Q8B401P0002DU9BXZ:RXZ
:STi>CDe=@94A4@01EaLG5YJFSHf=SHf=VQXJ002MWIf00IJFUX`<31:BTY:BTYoOgm:BTX2;2`/00H_
;bn2PX9JFUYJFUXe=CDm?Cd23`l?00F>SXjHV9Pg=cLg=cLF5QH00R/[:`0692@TJVYZ@T92@T92=CDe
>CTi0Y>CT`06MGEeE5AD;bl_;bl_GUiNOGem0T92@P05;2`/Rh^;8b<S8b<SMgMg008T92@01SHf=T51
@D=3@d=3@fUYJHV9R@9SHf<01X:2PWalO3De=CDe=G=cLalO7`8V9RH2NWYj0V1PH0053Ph>>c/kDE5A
DE5ACDe=009JFUX01UADE2HV9WalO7alO5=CDdA4A08g=cL01Rd];DA4A492@T92@UUIFF1PH08M7Ad0
1A<C4bh^;Te=CDe=CB4Q8@02F5QH00Hd=3@=3@dm?Cdm?Ce8B4QYJFT2E5AD00HJ6QZDU9ALG5aLG5bc
/k=5ADD271`L00IBDU9GEeM^KVi^KVj7QhLc<c<261PH00E4A4A3@d=3@d=@D50k>c/00Rh^;P05E5AD
IFEU@D51@D51>SXj00?oool00`000?ooooooo`0/oooo00@0003ooooooon;Rh/2EeMG00EUIFDh>3Pc
<c<c<c=5ADD00SDe=@06LW9bDE5AD51@D51@J6QX<S8b0Ve]K@06L71`K6a/Bd];Bd];B4Q87AdM0S8b
<P05410@<c<c<c<c;bl_ATI6008];Bd01U9BDU1@D6IVIVIVIRXZ:UiNGP9fMWH01EiNGRTY:BTY:D51
@HF5Q@02@D5100Hc<c<`<328R8R8R8QDE5@m?Cd2@d=300D:2PZ;Rh^KVi^KVi/k>c/00QXJ6P06;Rh^
9RHVJVYZJVYZADE5=3@d0SXj>P06UYJFMGEeE5ADE5AD<30`GemO0WinOP05@T92;Bd];Bd]Rh^;8R8R
009gMgL01R<S8c@d=4A4A4A4A451@Fe]K@:>SXh01F5QHHJ6QXJ6QWYjNSLg=`02L71`00HN7QhW9bMg
MgMgMgN0P81WIfL25ADE00E2@T9>CTi?Cdm?CdmCDe<00UQHF006:b/[QXJ6EUIFEUIF?3`l>CTi0SDe
=@05D51@>3PhI6ATI6ATFEUI008Z:RX01PH61S8b<TA4A4A4A1XJ6T];B`8U9BD01QHF5S@d=4I6ATI6
AWYjNUMGE`8@41001Hb<S5mOGemOGjFUYEQHF00230`<00I4A4AMGEeYJFUYJFUmOGde=CD22`/;00Dd
=3AEEEDm?Cdm?Cd`<3000Q`L7005I6ATLG5aADE5ADE5:RXZ00?oool00`000?ooooooo`0=oooo000R
oooo00D0003ooooooooooomeMGD00Zn_[`06XZ:RKFe]F5QHF5QHD51@J6QX0RPX:00571`LC4a<C4a<
9BDUEeMG008n?Sh01T92@UQHF1`L71`L769RHT=3@`99BDT01T51@B0P83/k>c/k>a/K6aDE5@8V9RH0
1FATI3Xj>T92@T92@TI6AP02<C4a00IDE5AKFe];Bd];Bd/m?Ce9BDT25aLG00HQ8B5ADE4[:b/[:b/R
8R96ATH2<c<c00EnOWi_KfmMGEeMGEe4A4@00bPX:005Ogmo7AdM7AdMDe=CZJVY00;6a/H01VUYJCHf
=V][Jf][Jd];BbLW9`9BDU801EEEEF5QHC@d=3@d=3lo?`02@T9200HL71`P820l?3`l?3bFUYIGEeL2
ADE500J4Q8B@T90c<c<c<c<m?CeBDU82FEUI00I;Bd/h>3Pa<C4a<C5CDe<<30`26a/K00E1@D5JFUYJ
FUXT92AnOWh00U]KF`066QXJJFUYDE5ADE5AH61P5ADE0TY:BP06J6QXCdm?7QhN7QhNJVYZ9RHV0QlO
7`058R8RFUYJFUYJ3@d=;bl_008W9bL01V9RHQlO7a0@410@44e=CEQHF09lO7`01UQHF3hn?WYjNWYj
NS<c<gmoO`8J6QX01CPh>;Rh^7QhN7QhN8Z:RP02:2PX00HQ8B5]KFf^[Zj^[Zh[:b]<C4`2IFEU00E^
KVkoooooooooool00000;_ooo`040000ooooooooI6AT0ZZZZP05]KFeGemOHV9RHV9RBDU9009OGel0
1S@d=1<C4eEEEEEEEC0`<4Y:BP9=CDd01SLg=eUIFA8B4Q8B4UMGEdi>CP9?Cdl01De=CATI6ATI6DI6
AQ8B4P0261PH00<`<31TI6A2@T800T92@P04@410=CDe=CDeE5AD0UEEE@06ADE5@D51D51@D51@7QhN
8R8R0UMGE`069bLW:2PXADE5ADE5=SHfNWYj0W=cL`05G5aLA4A4A4A48b<S9RHV00:6QXH01QhN7UUI
FJn_[jn_[lG5aFYZJP8i>CT016e]KDM7AbPX:2PX:0=CDe<01VIVIS<c<d=3@d=3@dI6AQXJ6P8N7Qh0
1Chn?YNGUeQHF5QHF4E5A@02QHF500JATI4d=3@m?Cdm?CeADE5IFET2BTY:00Hj>SXe=CEFEUIFEUH8
20PO7al2@D5100EEEEDX:2PX:2QkNg]TI6@00Q8B4P06HF5QCTi>Jf][Jf][820PEEEE0WAdM005AdM7
:RXZ:RXZM7Ad=CDe008B4Q801RLW9dm?CaLG5aLG5bDU9BPX:09NGUh01AlO7b8R8U]KFe]KFdU9B@02
K6a/00IADE53@d=dM7AdM7A5ADEfMWH292@T00HX:2R][JeZJVYZJVZATI4d=3@23`l?00ERHV:RXZ:R
XZ8L71aMGEd00Va/K005HF5Qoooooooooooo000000ooool002;oool01@000?ooooooooooogEeM@02
[jn_00JRXZ9]KFeHF5QHF5Q@D51XJ6P2:2PX00DL71a<C4a<C4`U9BEGEeL00Shn?P06@T92F5QH71`L
71`LHV9R@d=30TU9B@06@D51820P>c/k>c/k6a/K5ADE0RHV9P05I6AT>SXj@T92@T92ATI6008a<C40
1UADE5]KFd];Bd];Bcdm?DU9B@8G5aL01R4Q8E5ADB/[:b/[:b8R8TI6AP8c<c<01GinOVm_KeeMGEeM
GDA4A003:2PX00EoOglM7AdM7AeCDe>YZJT00/K6aP06JFUY=SHfJf][Jf][Bd];9bLW0U9BDP05EEEE
HF5Q=3@d=3@d?clo0092@T801Q`L720P83`l?3`l?9JFUUMGE`95ADD01XB4Q92@T3<c<c<c<cdm?E9B
DP9IFET01T];BcPh>34a<C4a<E=CD``<308K6a/01D51@EYJFUYJFR@T97inOP02Fe]K00HJ6QYYJFUA
DE5ADE5PH60E5AD2BTY:00IXJ6Q?CdlN7QhN7QiZJVXV9RH27alO00DR8R9JFUYJFUX=3@d_;bl00RLW
9`06HV9R7alO410@410@CDe=F5QH0WalO006F5QH?ShnNWYjNWYj<c<cOgmo0QXJ6P05>3Ph^;RhN7Qh
N7QhRXZ:008X:2P01R4Q8Fe]KJj^[Zj^[R/[:da<C09UIFD01Fi^K_ooooooooooo`00000^oooo00@0
003ooooooomTI6@2ZZZZ00Fe]KEOGemRHV9RHV99BDT00UmOG`06=3@d4a<CEEEEEEEE<30`BTY:0Te=
C@06=cLgFEUI4Q8B4Q8BEeMGCTi>0Tm?C`05CDe=6ATI6ATIATI64Q8B008H61P00c0`<6ATI492@P02
@T9200A0@40e=CDe=CEDE5@2EEEE00I5ADE1@D5@D51@D50N7QhR8R82EeMG00HW9bLX:2Q5ADE5ADDf
=SIjNWX2Lg=c00ELG5a4A4A4A4@S8b<V9RH00XJ6QP067QhNFEUI[jn_[jn_aLG5JVYZ0STi>@04KFe]
AdM7:2PX:2PX0e=CD`06IVIV<c<c@d=3@d=3ATI66QXJ0QhN7P05?ShnUiNGF5QHF5QHADE500:5QHD0
1Y6ATC@d=3dm?Cdm?E5ADEUIF@9:BTX01SXj>SDe=EIFEUIFEPP821lO7`91@D401EEEEBPX:2PX:7]k
NfATI0024Q8B00IQHF5>CTi[Jf][Jf/P821EEED2M7Ad00E7AdLZ:RXZ:RYdM7@e=CD00Q8B4P069bLW
Cdm?5aLG5aLG9BDU:2PX0UiNGP057alO8R8RFe]KFe]KBDU9009/K6`01U5ADD=3@gAdM7AdM4E5AGIf
MP8T92@01RPX::f][FYZJVYZJY6ATC@d=08?3`l01F9RHZ:RXZ:RXQ`L75eMG@02K6a/00EQHF7ooooo
ooooool000003oooo`008_ooo`050000ooooooooooooShn?009`L7001TY:BSdm?Bh^;Rh^;YRHV4U9
B@9kNg/01Da<C7QhN7QhN0l?3c@d=002LG5a00H^;Ri5ADE0@410@40W9bLe=CD2SXj>00I5ADDE5AD>
3Ph>3PiADE5]KFd2>3Ph00EHF5P/;2`L71`L71`92@T00SDe=@067alOdm?C?clo?clo:BTYCdm?0S8b
<P0651@D7alO8R8R8R8R;Rh^;Bd]0TA4A005FUYJD51@9BDU9BDUMWIf008b<S801UYJFSPh>34a<C4a
<H61PJNWY`:6QXH01PX:2Q0@44U9BDU9BB`/;4a<C0892@T01AlO7b<S8b/[:b/[:bLW9`02@D5100ID
E5AADE4f=SHf=SIBDU9VIVH2Lg=c00HC4a<X:2QLG5aLG5`T92@L71`25aLG00HC4a<a<C4Z:RXZ:RX`
<31@D5028B4Q00E6ATIHF5QHF5Q7AdNATI400P`<3006HF5QEUIFCTi>CTi>;bl_EUIF0Ti>CP06IFEU
=3@dB4Q8B4Q8GUiNEUIF0Rl_;`05<S8bEUIFEUIFATI6E5AD009OGel01T=3@dA4A3dm?Cdm?H61PDa<
C0:9RHT01QlO7f1PH3lo?clo?bHV9Sdm?@9=CDd01EiNGW9bLW=cLg=cLchn?P02I6AT00I5ADE[Jf]m
OGemOGe4A4@[:b/2E5AD00E[Jf_oooooooooool00000;_ooo`040000ooooooooTY:B0W1`L005Bd];
?3`l;Rh^;Rh^V9RH009;Bd/01WalO4e=CGalO7alO0h>3S<c<`9dM7@01S4a<DU9BClo?clo?bTY:C@d
=0:ATI401DM7Aa@D51@D518B4Tm?C`02LW9b00He=CEGEeLZ:RXZ:RXP820820P2=SHf00DR8R;AdM7A
dM51@D4];Bd00UEEE@06=SHf410@71`L71`L7QhN:b/[0S0`<005@d=3FUYJC4a<C4a<9bLW009bLW80
1S4a<EUIFC`l?3`l?2h^;XN7Q`:/[:`01XN7Q`h>3Ph>3Ph>3TQ8B2l_;`99BDT01@`<324Q8B4Q8BDU
9BTY:@02:RXZ00I3@d=DE5ACDe=CDe<h>3QADE42J6QX00EcLg<D51@D51@W9bMLG5`00R@T90067AdM
5aLG4a<C4a<C<C4a:b/[0S4a<@05DE5A8B4QAdM7AdM7F5QH0098B4P01Y:BTP`<365QHF5QHEMGEde=
C@8a<C401EUIFE1@D6MWIfMWIc<c<`02B4Q800IQHF5IFET^;Rh^;Rhd=3AGEeL2BDU900IBDU9QHF51
@D51@D52@T8o?cl2QHF500E?Cdn8R8R8R8PM7AeSHf<00Shn?P069bLW?cloCdm?Cdm?HF5QLW9b0W=c
L`05?CdmIVIVADE5ADE5K6a/009mOGd01DE5AB/[:eADE5ADE6][J`03oooo00<0003oooooool03Ooo
o`008_ooo`800002oooo00EiNGUXJ6QXJ6QXJ6QIFET00S/k>`05L71`;Bd]>3Ph>3Ph8R8R009ADE40
1UMGEg5aLF5QHF5QHH^;Rc`l?09[Jf/01VQXJ2DU9D10@410@4];Bda<C08g=cL01QHF5UMGEaXJ6QXJ
6S/k>dA4A09:BTX01A0@44];Bd];B``<3:VYZ@02Ph>300Hf=SI9BDTX:2PX:2PF5QJ@T9026ATI00Hg
=cL];Be9BDU9BDU^KVjGUiL2?clo00DY:BTI6ATI6AUaLG5cLg<00RLW9`06;Rh^MGEeAdM7AdM73Ph>
GemO0Va/K006GUiN@D51>c/k>c/k8R8R71`L0Rd];@056ATI6a/K6a/K<C4a;Rh^009ZJVX01Y>CTg=c
Lbl_;bl_;eYJFT10@09/K6`01TI6ATi>CUUIFEUIFC8b<V1PH094A4@01LK6aTm?CemOGemOGaHF5P02
CTi>00Dc<c=/K6`51@D51@DM7Ad00da<C006LG5a20P8IVIVIVIV92@T<C4a0UUIF@05>3Ph8R8R;Rh^
;Rh^<30`008[:b/01QdM7Bl_;alO7alO7fa/K3Hf=P8j>SX00g5aLFa/K2/[:`02:b/[00ETI6A^KVi^
KVhd=3@a<C400YFEU@05CDe=9RHVX:2PX:2P;Bd]008g=cL01QTI6E=CDg1`L71`L1<C4hV9R@892@T0
0hZ:R_ooooooo`020000;_ooo`8000001_ooogIfMVUYJFUYJFQXJ5YJFP8j>SX01GAdM38b<S8b<SHf
=RDU9@02E5AD00IEEEEbLW9QHF5QHF6:RXXj>SX2J6QX00AYJFTU9BE1@D51@D43C4a<00Hc<c<I6AUE
EEEEEEDN7Qhl?3`2B4Q800E9BDTC4a=:BTY:BTX>3Ph00Zf][@06Ph>3=cLgBDU9BDU9:RXZ5aLG0Y>C
T`066a/K>CTi;2`/;2`/B4Q8L71`0YRHV005@D51:BTY:BTY6ATIM7Ad009cLg<01RPX:2d];GMgMgMg
MdM7A`d=3@9NGUh01Fm_KeeMGD10@410@3/k>`0292@T00DJ6QX/;2`I6ATI6ATH61P00bl_;`05KFe]
UiNGMWIfMWIf<30`009MGEd01Shn?W1`L4A4A4A4A59BDUMGE`8`<3001VATI4E5ALO7alO7ae=CDeiN
GP8G5aL01Di>CSHf=SHf=Va/K0P820028B4Q00I:BTY?Cdm`L71`L70;2`]TI6@28b<S00De=CENGUiN
GUhg=cLP82000R`/;006<C4a:2PX6QXJ6QXJ<C4a71`L0W5aL@05>3Ph>CTiM7AdM7AdKVi^00<`<300
1FEUIF][Jf][Jc4a<Bh^;P02U9BD00I>CThR8R:SXj>SXj<Y:BTk>c/27QhN00EFEUIaLG5aLG4F5QJ?
Shl00PX:2P03Rh^;oooooooo0080000?oooo000Roooo00D0003ooooooooooomNGUh00]?Cd`06^k^k
S8b<G5aLG5aL9bLWGemO0S@d=0056ATIJ6QXJ6QX:RXZ<S8b008g=cL01U=CDcdm?D10@410@1dM7DI6
AP8/;2`01UADE5eMGHR8R8R8R1HF5T92@P8F5QH01DE5AG5aLGUiNGUiNAHF5P028B4Q00Hj>SY6ATIY
JFUYJFT@411KFe/2@41000HW9bMiNGT=3@d=3@dI6AULG5`2@d=300D410A7AdM0@410@41=CDd00UMG
E`06:2PXIFEU71`L71`LEUIFB4Q80TA4A006HF5QBDU9>CTi>CTiTY:B6QXJ0SLg=`05MWIf61PH61PH
61PHN7Qh009ADE401QLG5dY:BS`l?3`l?8^;Rdm?C`9>CTh01S@d=1hN7Ve]KFe]KH20P2`/;08o?cl0
1R4Q8AhN7QHF5QHF5W]kNclo?`8P82001C0`<0`<30`<33Lg=b@T90025aLG00I;Bd/k>c/C4a<C4a<W
9bMNGUh3CTi>00De=CEADE5ADE5?Cdl=3@d00SDe=@056QXJBTY:BTY:B4Q87alO008F5QH01UEEECXj
>V=SHf=SHe9BDVIVIP98B4P01YZJVWemOBXZ:RXZ:V1PH6ATI08=3@d01EiNGT92@U]KFe]KFaTI6@02
@T9200I/K6`f=SI5ADE5ADD820QQHF42?Shn00ElO7coooooooooool00000;_ooo`040000oooooooo
KVi^0/S8b005^;RhOgmoCdm?Cdm?=CDe009KFe/01SDe=BHV9WQhN7QhN20P82DU9@8g=cL01Ti>CTE5
AC`l?3`l?1dM7E5AD@8f=SH01EIFEUEEEEEEEGinOPh>3P02@d=300HA4A56ATI`L71`L723Ph<N7Qh2
92@T00Dn?Si8B4Q8B4QSHf<=3@d00V=SH`06>c/k;2`/OGemOGem4A4A5ADE0UUIF@05ATI61@D5@d=3
@d=3@T920099BDT01UMGEb/[:f=SHf=SHahN7UMGE`98B4P01TI6AUiNGTU9BDU9BC/k>i:BTP8F5QH0
1CDe=G=cLg=cLaXJ6Q@D5002OGem00I>CThE5AE:BTY:BTXl?3bATI42Bd];00EDE5@i>CTi>CTS8b=b
LW800XJ6QP06;bl_>c/k820P820P92@T71`L0W]kN`05?Cdm7AdM;Rh^;Rh^3`l?008e=CD01R<S8aXJ
6Te=CDe=CClo?`h>3P8/;2`01EUIFDe=CDQ8B4Q8B3/k>`02C4a<00IGEeL71`Lk>c/k>c/C4a=8B4P2
ATI600HH61PK6a]MGEeMGEe4A4ALG5`2Fe]K00EaLG53@d=3@d>VYZIgMgL00R4Q8@06I6ATFUYJ4A4A
4A4AGEeM>3Ph0Tm?C`055ADED51@M7AdM7Ad@T920096ATH01A<C4fi^KS8b<S8b<W1`L003oooo00<0
003oooooool03Oooo`008_ooo`050000ooooooooooooGUiN00;Cdm<01[^k^hb<S5aLG5aLG2LW9emO
G`8d=3@01ATI6FQXJ6QXJ2XZ:S8b<P02=cLg00ICDe<m?Ce0@410@40M7Ae6ATH2;2`/00IDE5AMGEf8
R8R8R8PF5QI2@T825QHF00E5ADEaLG5iNGUiNGTF5QH00R4Q8@06>SXjATI6JFUYJFUY410@Fe]K0T10
@0069bLWNGUi3@d=3@d=6ATIG5aL0T=3@`0510@4AdM7@410@410CDe=009GEeL01RPX:6EUIA`L71`L
75IFETQ8B094A4@01V5QHDU9BCTi>CTi>I:BTQXJ6P8g=cL01GIfMQPH61PH61PH67QhN002DE5A00HG
5aM:BTXl?3`l?3b;Rh]?Cdl2CTi>00Hd=3@N7Qi]KFe]KFf0P80/;2`2?clo00HQ8B4N7QhF5QHF5QIk
Ng/o?cl2820P00D`<30<30`<30`g=cLT92@00QLG5`06Bd];>c/k4a<C4a<C9bLWGUiN0di>CP05=CDe
DE5ADE5ACdm?3@d=008e=CD01AXJ6TY:BTY:BTQ8B1lO7`025QHF00IEEEDj>SYSHf=SHf=BDU9VIVH2
B4Q800JJVYYmOGdZ:RXZ:RYPH61TI6@23@d=00ENGUi2@T9KFe]KFe/I6AT00T92@P06K6a/=SHfADE5
ADE520P8HF5Q0Shn?P05O7aloooooooooooo000002koool010000?ooooooofi^KP;8b<P01KRh^7mo
Odm?Cdm?CcDe=@02Fe]K00He=CDV9RIhN7QhN7PP820U9BD2=cLg00I>CTi5ADDl?3`l?3`M7AeADE42
=SHf00EFEUIEEEEEEEEnOWh>3Ph00T=3@`064A4AATI6L71`L71`Ph>37QhN0R@T9005?ShnB4Q8B4Q8
Hf=S3@d=009SHf<01S/k>b`/;7emOGemOA4A4ADE5@9IFET01DI6APD51D=3@d=3@d92@P02BDU900IG
EeL[:b]SHf=SHf<N7QiGEeL2B4Q800I6ATINGUi9BDU9BDTk>c^BTY825QHF00De=CEcLg=cLg<J6QXD
51@00WemO@06CTi>5ADEBTY:BTY:?3`lTI6A0T];B`05E5AD>CTi>CTi8b<SLW9b00:6QXH01Rl_;c/k
>b0P820P82@T91`L709kNg/01Cdm?AdM7Bh^;Rh^;Pl?3`02=CDe00HS8b<J6QY=CDe=CDdo?cl>3Ph2
;2`/00EIFEU=CDe8B4Q8B4Pk>c/00Ta<C006EeMG1`L7>c/k>c/k4a<CB4Q80TI6AP0661PH6a/KGEeM
GEeMA4A4G5aL0U]KF`05LG5a@d=3@d=3YZJVMgMg008Q8B401VATI5YJFQ4A4A4A4EeMGCPh>09?Cdl0
1ADE5E1@D7AdM7AdM492@P02ATI600DC4a=^KVhb<S8b<S9`L7000oooo`030000oooooooo00goool0
02;oool01@000?oooooooooook>c/`02MgMg00I_Kflo?cm>CTi>CTiNGUidM7@2=3@d00E>CTj3Ph>3
Ph>7QhLa<C400VATI0063@d=9bLWFUYJFUYJ820P7AdM0SDe=@06<S8bFEUIATI6ATI6GUiNVYZJ0UQH
F005:2PXFe]KHf=SHf=S5aLG008C4a<01QLG5f=SHjj^[Zj^[W5aLBl_;`8i>CT01VATI1XJ6VEUIFEU
ID=3@hZ:RP9DE5@01ADE5CPh>4M7AdM7AadM7@02IVIV00HS8b<^;Rhd=3@d=3@n?ShT92@2<30`00I^
KVhK6a]IFEUIFETg=cMCDe<2ADE500EeMGDm?Cd>3Ph>3PiEEED00QTI6@064a<CLW9bBTY:BTY:51@D
GUiN0Ta<C006QhN7:RXZ:RXZ:RXZS8b<:2PX0T10@09CDe<2H61P00DF5QHJ6QXD51@D51@N7Qh00QdM
7@06?3`lA4A4>3Ph>3PhJf][?Cdm0QhN7P06OgmoAdM7=SHf=SHfCDe=?3`l0TY:BP0592@T9BDUBTY:
BTY:GUiN009`L7001XV9RB<S8eiNGUiNGXV9RDQ8B097AdL01Q<C4alO7dm?Cdm?Cb0P85EEE@8n?Sh0
1TY:BPP8255ADE5ADD92@QHF5P:4Q8@01E5ADB/[:b/[:`d=3FYZJP02<c<c00E=CDeGEeLT92@T92B4
Q8@00oooo`030000oooooooo02coool010000?oooooookZj^P9]KFd01Fa/K3Hf=T=3@d=3@eEEE@02
NWYj00H`<31=CDf>SXj>SXioOglX:2P2J6QX00HH61PZ:RYUIFEUIFDZ:RXW9bL2@41000Dd=3ADE5AD
E5@o?cmFEUH00ZBTY006E5AD;Bd]FUYJFUYJK6a/7alO0QHF5P055ADEHV9RHV9R[Jf]NGUi008b<S80
1STi>F][JadM7AdM7F5QHClo?`:<S8`01EQHF18B4SHf=SHf=TE5A@026a/K00ITI6@U9BD[:b/[:b/f
=SI2@T828b<S00H];Be]KFdN7QhN7QiIFETf=SH2E5AD00E3@d=dM7AdM7@o?cl>3Ph00UMGE`066QXJ
51@DLg=cLg=cBDU951@D0UmOG`05Cdm?RXZ:RXZ::2PX:BTY00:;Rh/01RTY:Clo?eQHF5QHF59BDV5Q
H@8C4a<01APH61LG5b<S8b<S8adM7@02>3Ph00I9BDTf=SIaLG5aLG52@T8T92@2Q8B400E5ADDk>c]7
AdM7AdM4A4@00TE5A@06820P:RXZDU9BDU9BF5QHMGEe0X61P@06:b/[EeMGShn?Shn?CDe=AdM70QPH
60059bLWCdm?Cdm?8R8RBd];0092@T801TU9B@X:2Te=CDe=CCPh>1<C4`9lO7`01Da<C3Lg=`h>3Ph>
3W=cL`029bLW00E6ATIGEeLN7QhN7Qj4Q8@00oooo`030000oooooooo00goool002;oool01@000?oo
ooooooooolS8b002M7Ad00I5ADE0@412@T92@T:9RHUPH602<30`00Dk>c/J6QXJ6QY2@T9=CDd00T10
@0069BDUATI69bLW9bLWXZ:RD51@0Q8B4P06De=CP820IfMWIfMW820PN7Qh0R4Q8@05De=CF5QHDE5A
DE5AFEUI008M7Ad01T92@VYZJVATI6ATI24Q8@l?3`8U9BD01WMgMeMGEhn?Shn?SbXZ:U=CD`8i>CT0
1D];Bf1PH4=3@d=3@aTI6@0292@T00HZ:RXH61QMGEeMGEeHF5Pl?3`2410@00I1@D4?3`lf=SHf=SH_
;bnJVYX27AdM00E>CThf=SHW9bLW9bLU9BD00R<S8`06:b/[MWIfMWIfMWIfVYZJADE50U1@D006De=C
1`L7SHf=SHf=DU9B7alO0VIVIP065aLG8b<S>SXj>SXj?clo3Ph>0S<c<`05>CTiIVIVIVIVRh^;YZJV
009KFe/01QlO7hj>SV5QHF5QHGalO1TI6@:0P8001S/k>e1@D59BDU9BDR/[:g]kN`9:BTX01CTi>E]K
Fe]KFh61PC/k>`02<c<c00JPX:13@d>>SXj>SXi>CThe=CD25ADE00I?Cdlo?cmLG5aLG5a<C4`A4A42
Kfm_00DR8R9<C4alO7alO7aXJ6P00Ta<C0069BDUFEUIGEeMGEeM:BTYC4a<0U=CD`05RHV9oooooooo
oooo000002koool010000?ooooooom7Ad@9_Kfl01D92@SXj>T=3@d=3@hJ6QP02GEeM00H`<30k>c/Q
8B4Q8B58B4Q9BDT2ADE500HT92A4A4@^;Rh^;RjYZJU=CDd26ATI00E=CDemOGemOGeQHF4V9RH00WMg
M`0671`LDU9BDe=CDe=CEeMGEEEE0R0P8005ADE5Jf][Jf][JFUY9RHV008:2PX01RPX:7]kNe]KFe]K
Fhf=SBXZ:P9EEED01C`l?4i>CUeMGEeMGDA4A0027AdM00HQ8B4X:2PC4a<C4a=KFe]GEeL2?3`l00HF
5QI6ATH;2`/;2`/i>CTg=cL2U9BD00DH61Q8B4Q8B4Pc<c<S8b<00QlO7`067QhN=3@dLW9bLW9bOGem
WYjN0TE5A@05EeMGGEeMGEeM20P8V9RH009>CTh01QhN7UiNGPh>3Ph>3RDU9C@d=091@D401A8B4S8b
<S/k>c/k>f5QH@02UIFE00JPX:1FEUHV9RHV9RJ9RHUYJFT2PH6100DD51B0P80m?Cdm?Ce?Cdl00UIF
EP06:b/[PH61B4Q8B4Q8>3PhFEUI0X61P@06>SXj=CDeXj>SXj>S@T92T92@0Tm?C`05=CDe51@D51@D
DE5A@D51009LG5`01Tm?Ca0@47=cLg=cLb8R8Tm?C`9iNGT01Fi^KT];BbTY:BTY:EQHF002HV9R00D^
;Ri:BTYCDe=CDe>6QXH00oooo`030000oooooooo00goool001Soool00`000?ooooooo`02oooo00<0
003oooooool00_ooo`050000ooooooooooooPX:200:/[:`01Q/K6gQhN6a/K6a/K1XJ6UUIF@8E5AD0
1@L71d];Bd];BadM7B<S8`02J6QX00HU9BE<C4abLW9bLW8W9bM4A4@2Fe]K00HI6ATl?3`:2PX:2PYB
DU:3Ph<2;2`/00DW9bMWIfLI6ATI6AU_Kfl00QPH6006KVi^:RXZ51@D51@D6ATI=cLg0S/k>`06Ph>3
SXj>EUIFEUIF?Cdm@4100Q0@4005CDe=Lg=c?Cdm?Cdm=3@d008/;2`01SPh>2TY:BTY:BTY:Hf=SEmO
G`8S8b<01PT92Da<C6][Jf][Jbl_;`P82091@D401EYJFSXj>Ti>CTi>CRPX:002CDe=00IRHV9gMgMH
F5QHF5Q8B4Q^KVh2Ti>C00I8B4Pa<C5kNg]kNg/N7QiNGUh2H61P00IIFETY:BTW9bLW9bMQHF4820P2
4Q8B00F0P80d=3@d=3@[:b^8R8P00WYjNP06Ph>3>c/kO7alO7al7QhNCdm?0SDe=@069RHV61PH5ADE
5ADES8b<;bl_0UYJFP05IfMW:RXZ:RXZCTi>410@008e=CD01S4a<F=SHhb<S8b<S2h^;Ph>3P96ATH2
GUiN0Tm?C`06MWIfB4Q8820P820PE5ADYjNW0PD51@05MWIfGUiNGUiN<30`<S8b008f=SH01@D51AdM
7F1PH61PH:f][@03oooo00<0003oooooool08_ooo`030000oooooooo00;oool00`000?ooooooo`02
oooo00@0003ooooooon8R8P2/;2`00DO7amgMgMYJFUYJFTN7Qh00UIFEP064Q8B2@T9Bd];Bd];6a/K
9BDU0Va/K00692@TCdm?Lg=cLg=c:RXZAdM70UaLG0056ATI>SXj>SXj2`/;DE5A00:6QXH01Rd];BHV
9VMWIfMWIaPH66e]K@8H61P01Fm_KbXZ:RXZ:QDE5ALG5`02=3@d00Hm?Cf5QHFBTY:BTY9CDe<k>c/2
?clo00DC4a=?Cdm`L71`L713@d<00SXj>P06;Rh^=SHf:2PX:2PX;2`/R8R80VIVIP06:BTY410@ADE5
ADE5MGEe9bLW0P@41005>3PhEEEEEEEE<S8bE5AD008/;2`01UMGEfe]KFm_Kfm_Ke]KFde=C@9UIFD0
1IZJVT51@D51@C`l?8V9R@02:b/[00IWIfMGEeMADE5ADE4P820e=CD2Fe]K00DD51@92@V1PH61PH4X
:2P00S@d=006OWinMGEeMWIfMWIf=CDeR8R80QhN7P05C4a<=cLg8B4Q8B4Q3Ph>008?3`l01Y^KVcTi
>Dm?Cdm?Cg5aLAlO7`93@d<01P`<32h^;SLg=cLg=fMWIhV9R@8i>CT01@@414A4A4A4A69RHVUYJ@02
ATI600IbLW9?CdlO7alO7amCDe>SXj<21@D500E`L71VIVHh>3Ph>3P^;Rh00S4a<@0500006QXJGemO
GemOZZZZ00?oool00`000?ooooooo`0=oooo000Goooo00<0003oool000000_ooo`030000oooo0000
00?oool01@000?oooooooooooh:2PP02[:b/00HK6a]hN7Q/K6a/K6`J6QYIFET25ADE00D71`M;Bd];
Bd/M7AdS8b<00VQXJ0069BDUC4a<LW9bLW9b9bLWA4A40U]KF`066ATI?3`l2PX:2PX:DU9BPh>30R`/
;0059bLWIfMW6ATI6ATIKfm_008H61P01Vi^KRXZ:Q@D51@D51TI6CLg=`8k>c/01X>3Phj>SUIFEUIF
ESdm?D10@08@41001De=CG=cLcdm?Cdm?C@d=002;2`/00Hh>3PY:BTY:BTY:BV=SHeOGel28b<S00H9
2@U<C4a[Jf][Jf/_;bl820P2@D5100EJFUXj>SY>CTi>CThX:2P00Te=C@06HV9RMgMgF5QHF5QHB4Q8
KVi^0Y>CT`06B4Q8<C4aNg]kNg]k7QhNGUiN0V1PH006FEUI:BTY9bLW9bLWHF5Q20P80Q8B4P05P820
=3@d=3@d:b/[R8R8009jNWX01X>3Pc/k>galO7alO1hN7Tm?C`8e=CD01RHV9QPH61DE5ADE5Hb<S2l_
;`9JFUX01FMWIbXZ:RXZ:Ti>CQ0@4002=CDe00Ha<C5SHf><S8b<S8`^;Rh>3Ph2ATI60UiNGP9?Cdl0
1WIfMTQ8B20P820P85ADE:NWY`851@D01GIfMUiNGUiNGS0`<38b<P02=SHf00D51@DM7AePH61PH62]
[Jd00oooo`030000oooooooo027oool00`000?ooo`000002oooo00<0003oool000000oooo`040000
ooooooooR8R80[2`/0057alOMgMgJFUYJFUY7QhN009FEUH01Q8B4PT92D];Bd];Ba/K6bDU9@9/K6`0
1R@T94m?Cg=cLg=cLbXZ:TM7A`9LG5`01ATI6CXj>SXj>P/;2e5AD@02QXJ600H];BdV9RIWIfMWIfLH
61Q]KFd261PH00E_KflZ:RXZ:RXE5ADG5aL00S@d=006?CdmQHF5TY:BTY:BDe=C>c/k0Slo?`054a<C
Cdm?L71`L71`@d=3008j>SX01Rh^;SHf=RPX:2PX:2`/;8R8R09VIVH01RTY:A0@44E5ADE5AGEeMBLW
9`8410@01CPh>5EEEEEEEC8b<UADE002;2`/00IGEeM]KFe_Kfm_KfmKFe]=CDd2IFEU00FJVYY1@D51
@D4l?3b9RHT00R/[:`06IfMWEeMGDE5ADE5A820P=CDe0U]KF`0551@D2@T9PH61PH61:2PX008d=3@0
1WinOWEeMGIfMWIfMSDe=HR8R08N7Qh01Da<C3Lg=b4Q8B4Q8@h>3P023`l?00JKVi/i>CU?Cdm?Cdma
LG4O7al2@d=300H<30`^;Rhg=cLg=cMWIfN9RHT2>CTi00D410A4A4A4A4ARHV9YJFT00TI6AP06LW9b
Cdm?7alO7alODe=CXj>S0PD51@05L71`IVIV>3Ph>3Ph;Rh^008a<C401@0001XJ6UmOGemOGjZZZP03
oooo00<0003oooooool03Oooo`005oooo`030000oooo000000;oool00`000?ooo`000003oooo0P00
00;oool01L?3`f5QHF5QHC<c<di>CP02R8R800Dd=3AdM7@@410@410g=cL00Y>CT`06T92@61PH820P
820PD51@:BTY0W1`L006FEUIJVYZ7QhN7QhN?ShnCTi>0UYJFP06@T92Y:BT?3`l?3`lFEUIIfMW0T];
B`05;bl_=3@d=3@d7AdMBDU9008i>CT01U9BDQ/K6d51@D51@GUiNE=CD`8E5AD01YRHV8^;ReQHF5QH
F:n_[b/[:`8W9bL01C`l?24Q8B4Q8CPh>59BDP0230`<00I4A4A`L71ADE5ADE4I6AUEEED2OWin00I6
ATHN7Qi4A4A4A4AWIfL;2`/2?Shn00F/[:a6ATI6ATK6a/IXJ6P00Ph>3P063`l?QHF5>3Ph>3PhBTY:
0P820Q<C4`06A4A4@d=3>c/k>c/kO7al:BTY0UMGE`05Ng]k7AdMLG5aLG5aI6AT00830`<01Va/K79b
LW9bLW9bLVUYJATI6@9UIFD01RLW9`X:2Rl_;bl_;aPH63<c<`8Q8B401CPh>2h^;Z>SXj>SXc<c<`02
ADE500H];Bdc<c=6ATI6ATHM7Ae/K6`28b<S00H?3`lc<c>6QXJ6QXJUYJDm?Cd26ATI00IgMgMDE5AM
GEeMGEeTI6AJFUX2Ti>C00Dn?Sj;Rh^;Rh]gMgLK6a/00T];B`054a<C>c/k5aLG5aLGUIFE00;oool2
00008oooo`030000oooo000000;oool00`000?ooo`000003oooo0P000006ooooc/k>KVi^KVi^@410
Cdm?0Y:BTP05;bl_Jf][Jf][1@D5A4A400:@T9001YfMWA/K6bDU9BDU9DQ8B30`<09WIfL01EEEEFm_
KaHF5QHF5Slo?`02ATI600IFEUI9BDVNWYjNWYhd=3ADE5@2KVi^00E9BDTc<c<b<S8b<S8R8R800Te=
C@06>c/kDe=C5QHF5QHFAdM7OGem0UIFEP065ADEUIFEQhN7QhN7Fe]K[Zj^0R/[:`05:RXZ?Shn?Shn
9BDU=SHf009FEUH01PP824E5AG=cLg=cLdm?CaPH609CDe<01GinOTY:BQ/K6a/K6d=3@`02IFEU00H?
3`ll?3bb/[:b/[99BDW=cLd2I6AT00D@410:2PZ1PH61PH4n?Sh00TY:BP061PH6410@B4Q8B4Q8Bd];
=CDe0WUiN@069bLWH61PMWIfMWIf8R8RNWYj0UiNGP0530`<IVIVIVIVKFe]JVYZ009QHF401Q4A4G5a
LB<S8b<S8`h>3S8b<P8B4Q801Cdm?Bd];Bd];D51@CPh>002Vi^K00Hi>CU?Cdlg=cLg=cL];Bdn?Sh2
71`L00EPH60`<30410@410@W9bL00YFEU@06XZ:RADE56a/K6a/KK6a/AdM70V][J`05EeMGFUYJT92@
T92@=SHf00=oOgl01A<C4eYJFUYJFPh>3Rh^;P0292@T00>>SXkoooooool00P0000ooool001Soool0
1`000?ooooooooooo`000?ooo`000003oooo00D0003ooooooooooonOWil00STi>@06@T92DU9B<30`
<30`KVi^F5QH0Va/K005<c<cGUiNGUiNNWYj6a/K009mOGd01S@d=4M7Ae1@D51@D3Xj>UYJFP8n?Sh0
1Rh^;Y2@T3Ph>3Ph>7MgMb`/;09UIFD01DY:BXV9RD=3@d=3@aDE5@0292@T00Hj>SXe=CD:2PX:2PXO
7alX:2P28B4Q00INGUhM7Ae8B4Q8B4R5QHE=CDd24Q8B00EcLg>0P80O7alO7am0@4000QhN7P06G5aL
;2`/2@T92@T9IVIV2PX:0QPH6006F5QH;bl_>SXj>SXj4A4A=3@d0UQHF005:BTYDE5AJFUYJFUYB4Q8
009_Kfl01QlO7h20P0l?3`l?3gMgMclo?`9WIfL01R@T934a<A8B4Q8B4SPh>4];B`8X:2P01TE5AB@T
94i>CTi>CS4a<FIVIP9]KFd01BPX:6ATI6ATI9>CTdI6AP028b<S00J9RHTn?ShO7alO7alg=cL/;2`2
V9RH00HF5QJ^[Zh@410@411PH6051@D2KVi^00E>CTi6ATI6ATHk>c]ADE400VYZJP06;2`/Hf=S9BDU
9BDUATI6<c<c0VATI0069bLWZZZZBTY:BTY:EUIF:RXZ0Ta<C005AdM7<30`?3`l?3`l;Bd]009DE5@0
1XN7Qf9RHT10@410@5MGEemOG`8j>SX01Fm_Koooooooooooo`00000Toooo00L0003oooooooooool0
003oool000000oooo`040000ooooooooZ:RX0TI6AP05CTi>H61P:RXZ:RXZMWIf009@D5001V1PH3Xj
>UaLG5aLG8:2PRPX:0:9RHT01T10@3/k>eYJFUYJFS<c<fMWI`96ATH01CPh>8F5QHF5QB`/;7emO@02
8B4Q00IIFEU0@423Ph>3Ph=7AdL<30`2<30`00E2@T8h>3Ph>3P>3PhX:2P00R<S8`0661PHJ6QX9RHV
9RHV@410O7al0TE5A@053Ph>JVYZPh>3Ph>3:BTY008k>c/01Q`L76=SHcHf=SHf=Q4A4G1`L08410@0
1QhN7UEEEBPX:2PX:492@Q<C4`8_;bl01E9BDRLW9bLW9da<C6i^KP02CTi>00I_KflT92AmOGemOGdB
4Q9iNGT2?Shn00EVIVHT92@T92@`<30@41000STi>@06CDe=:BTYAdM7AdM78b<SCTi>0S<c<`05IVIV
Jf][:b/[:b/[HV9R00:GUiL01TY:BRLW9hn?Shn?Sclo?a/K6`8f=SH01B/[:iBDU1/K6a/K6jVYZ@02
4a<C00ISHf<30`=[Jf][Jf]9BDU3@d<2?Shn00IHF5Q`L70V9RHV9RI[Jf/Q8B42DE5A00D`<31OGemO
GelT92BQXJ400TQ8B006De=C=3@dDE5ADE5AE5AD>SXj0STi>@05;Bd]E5ADO7alO7alEUIF0090@400
1Da<C5EEEBh^;Rh^;VATI003oooo00<0003oooooool03Oooo`005oooo`030000oooo000000;oool0
0`000?ooo`000003oooo00D0003ooooooooooomHF5P00TE5A@06OWin;2`/NGUiNGUi;Bd]410@0T=3
@`05>3PhNGUiNGUiAdM7EeMG0093@d<01QXJ6R<S8fEUIFEUIADE5CPh>08U9BD01SHf=UeMGC<c<c<c
<de=CGUiN@8X:2P01DU9BEUIFCLg=cLg=a0@40023`l?00Hh>3Pa<C4e=CDe=CDj>SXO7al2BDU900ID
E5@_;blW9bLW9bL[:b]RHV82CDe=0UYJFP8`<3001H20P3De=CDe=CDe=AlO7`02De=C00I`L71;Bd/b
<S8b<S9BDU8F5QH2FUYJ00H_;blG5aLm?Cdm?Ce[Jf^2PX82:RXZ00DY:BUMGEeMGEenOWiZJVX00WQh
N006P820IFEUB4Q8B4Q8IFEU2`/;0Rd];@06H61PSXj>9BDU9BDUBd];:RXZ0W1`L003@410>3PhEUIF
009FEUH3E5AD00Dm?CecLg=cLg=<C4a=CDd00QlO7`06WinO?CdmEUIFEUIFCDe=S8b<0Sdm?@051PH6
LG5aM7AdM7Ad4A4A008[:b/01T=3@gEeMCDe=CDe=EIFEWUiN@8k>c/013<c<di>CU5ADE5AD@8Y:BT2
>3Ph00ITI6B:RXXo?clo?cnn_[iBDU8292@T00EXJ6QoOgmoOgmFEUI=CDd00Sdm?@0561PHA4A4TY:B
TY:BQXJ600?oool00`000?ooooooo`0Qoooo00<0003oool000000_ooo`030000oooo000000?oool0
10000?oooooooda<C09BDU801G=cLb8R8WinOWinOS8b<P022@T900I<C4a0@41jNWYjNWY7AdMIFET2
ATI600HK6a/O7amXJ6QXJ6PB4Q8h>3P2:BTY00De=CEKFe]KFe/g=cM;Bd/00WmoO`068b<SATI6E5AD
E5AD?Shn61PH0Q0@4005@D51:RXZ:RXZ=CDe@D51008F5QH01Slo?eiNGRXZ:RXZ:R4Q8AlO7`9TI6@0
1DY:BTi>CUUIFEUIFCDe=@02N7Qh00I3@d<b<S8/;2`/;2a:BTYhN7P2A4A400Hk>c]>CTh>3Ph>3PiT
I6@^;Rh230`<00@f=SISHf=SHf>9RHT3;Bd]00IUIFEjNWY/K6a/K6akNg]nOWh2Jf][00E6ATIUIFEU
IFD>3Ph`<3000V5QH@06TI6A9BDUC4a<C4a<:b/[Lg=c0Shn?P05?3`lDE5AF5QHF5QHD51@009FEUH0
1T92@WIfMTm?Cdm?Cdi>CRHV9P:HV9P01D10@5EEED10@410@8J6QP02=3@d00HB4Q9VIVImOGemOGdR
8R8i>CT2=3@d00IiNGTT92AVIVIVIVJ3Ph==CDd2@d=300E1@D54A4A4A4@P820j>SX00R/[:`06EEEE
S8b<B4Q8B4Q8^[ZjDE5A0S0`<005EeMGT92@Bd];Bd];BDU9008h>3P01ATI6CDe=IRHV9RHV7UiN@03
oooo00<0003oooooool03Oooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00D0
003ooooooooooomHF5P00TE5A@06OWin;2`/NGUiNGUi;Bd]410@0T=3@`05>3PhNGUiNGUiAdM7EeMG
0093@d<01QXJ6R<S8fEUIFEUIADE5CPh>08U9BD01SHf=UeMGC<c<c<c<de=CGUiN@8X:2P01DU9BEUI
FCLg=cLg=a0@40023`l?00Hh>3Pa<C4e=CDe=CDj>SXO7al2BDU900IDE5@_;blW9bLW9bL[:b]RHV82
CDe=0UYJFP8`<3001H20P3De=CDe=CDe=AlO7`02De=C00I`L71;Bd/b<S8b<S9BDU8F5QH2FUYJ00H_
;blG5aLm?Cdm?Ce[Jf^2PX82:RXZ00DY:BUMGEeMGEenOWiZJVX00WQhN006P820IFEUB4Q8B4Q8IFEU
2`/;0Rd];@06H61PSXj>9BDU9BDUBd];:RXZ0W1`L003@410>3PhEUIF009FEUH3E5AD00Dm?CecLg=c
Lg=<C4a=CDd00QlO7`06WinO?CdmEUIFEUIFCDe=S8b<0Sdm?@051PH6LG5aM7AdM7Ad4A4A008[:b/0
1T=3@gEeMCDe=CDe=EIFEWUiN@8k>c/013<c<di>CU5ADE5AD@8Y:BT2>3Ph00ITI6B:RXXo?clo?cnn
_[iBDU8292@T00EXJ6QoOgmoOgmFEUI=CDd00Sdm?@0561PHA4A4TY:BTY:BQXJ600?oool00`000?oo
ooooo`0Roooo00<0003oooooool00_ooo`030000oooooooo00;oool010000?oooooooda<C09BDU80
1G=cLb8R8WinOWinOS8b<P022@T900I<C4a0@41jNWYjNWY7AdMIFET2ATI600HK6a/O7amXJ6QXJ6PB
4Q8h>3P2:BTY00De=CEKFe]KFe/g=cM;Bd/00WmoO`068b<SATI6E5ADE5AD?Shn61PH0Q0@4005@D51
:RXZ:RXZ=CDe@D51008F5QH01Slo?eiNGRXZ:RXZ:R4Q8AlO7`9TI6@01DY:BTi>CUUIFEUIFCDe=@02
N7Qh00I3@d<b<S8/;2`/;2a:BTYhN7P2A4A400Hk>c]>CTh>3Ph>3PiTI6@^;Rh230`<00@f=SISHf=S
Hf>9RHT3;Bd]00IUIFEjNWY/K6a/K6akNg]nOWh2Jf][00E6ATIUIFEUIFD>3Ph`<3000V5QH@06TI6A
9BDUC4a<C4a<:b/[Lg=c0Shn?P05?3`lDE5AF5QHF5QHD51@009FEUH01T92@WIfMTm?Cdm?Cdi>CRHV
9P:HV9P01D10@5EEED10@410@8J6QP02=3@d00HB4Q9VIVImOGemOGdR8R8i>CT2=3@d00IiNGTT92AV
IVIVIVJ3Ph==CDd2@d=300E1@D54A4A4A4@P820j>SX00R/[:`06EEEES8b<B4Q8B4Q8^[ZjDE5A0S0`
<005EeMGT92@Bd];Bd];BDU9008h>3P01ATI6CDe=IRHV9RHV7UiN@03oooo00<0003oooooool03Ooo
o`008_ooo`050000oooooooooooo9bLW008/;2`01[2`/2PX:9fMWIfMWD=3@gYjNP:RXZ801A`L77]k
Ng]kNeYJFR4Q8@02=3@d0T51@@9NGUh01STi>C/k>gIfMWIfMRTY:ADE5@9>CTh01WQhN7inOUIFEUIF
EVQXJ55AD@9OGel01A/K6clo?clo?da<C5aLG0029RHV00HW9bLg=cLj>SXj>SXW9bLX:2P2C4a<00I9
BDVGUiMbLW9bLW8E5AEBDU82ADE500DB4Q8A4A4A4A4J6QXS8b<00Slo?`06L71`?cloShn?Shn?820P
M7Ad0UUIF@06<c<cKVi^J6QXJ6QX7alODe=C0d92@P9cLg<01QXJ6T=3@c@d=3@d=2XZ:RDU9@:i^KT0
1U5ADEEEEBh^;Rh^;XF5QD51@@95ADD01U9BDR<S8a@D51@D54a<C61PH093@d<01C@d=5]KFe]KFeAD
E4Y:BP027AdM00Hl?3`>3PhH61PH61QTI6@/;2`2=CDe00H;2`]>CThH61PH61Pd=3AUIFD2:BTY00DN
7QiCDe=CDe=@D52BTY800QXJ6P063Ph>PH61JVYZJVYZCdm?F5QH0W9bLP06@d=3<S8b=SHf=SHf6a/K
Bd];0gMgM`04<C4a7QhN7QhNB4Q80SPh>006:b/[;bl_DE5ADE5A@D51DU9B0TM7A`05RHV9oooooooo
oooo000002koool010000?ooooooobl_;`8Y:BT01K:b/R`/;:ZZZZZZZSlo?`02KVi^00JNWYh?3`n9
RHV9RHUMGEdF5QH2?Shn00I7AdM1@D5EEEEEEEDc<c=5ADD2Ogmo00DZ:RXI6ATI6AU>CTinOWh00WUi
N@06FEUIJFUYEEEEEEEEG5aL61PH0Sdm?@05D51@FUYJFUYJ:2PX:BTY008h>3P01S`l?2PX:2LW9bLW
9de=CDY:BP:IVIT01G=cLa@D551@D51@D4A4A0024Q8B00H=3@dI6ATN7QhN7Qhn?Si`L702?3`l00JF
UYHW9bMfMWIfMWIMGEdf=SH2K6a/00ETI6@H61PH61QIFEU4A4@00TY:BP06M7Ad51@DA4A4A4A4;bl_
9RHV0R`/;005]kNgCTi>CTi>EUIF<c<c00:1PH401T92@TI6ATi>CTi>CR4Q8A4A4@9<C4`01F5QHD92
@S@d=3@d=5aLG002E5AD00I<C4`M7Adm?Cdm?Cd?3`lH61P2Hf=S00D[:b/d=3@820P820Q?Cdl00QLG
5`05;bl_HV9R:RXZ:RXZ92@T00=HF5P01XZ:RR4Q8AHF5QHF5XR8R6EUI@9GEeL01Di>CWIfMWIfMSLg
=c/k>`02@d=300H?3`lo?cmgMgMgMgMZJVXZ:RX292@T00Dm?Ce0@40d=3@d=3@R8R800V1PH005>SXj
A4A4EUIFEUIFOWin00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooomDE5@00VYZ
JP06L71`P820?clo?cloTY:B@d=30/71`@05QXJ6HV9RHV9RMgMgLG5a009YJFT01RLW9cdm?BPX:2PX
:2XZ:U9BDP:XZ:P01Pd=3EaLG7=cLg=cLcDe=B<S8`8f=SH01Bl_;h61PEQHF5QHF30`<002>3Ph00HO
7alc<c<B4Q8B4Q8o?cm^KVh2;bl_00I6ATIfMWHi>CTi>CULG5`K6a/2Fe]K00DV9RH_;blI6ATI6ATg
=cL00SXj>P06ATI69BDU6ATI6ATIJVYZG5aL0Y2@T0060`<37alOMWIfMWIf5ADE=SHf0SPh>005>c/k
;bl_E5ADE5ADJVYZ009cLg<01T92@V9RHT10@410@;2`/1LG5`:<S8`01S0`<:b/[4a<C4a<C2LW9c4a
<@91@D401TA4A2h^;QDE5ADE5Fm_Ki6AT@9?Cdl01FEUIAdM7AdM7APH63@d=002>c/k00Ho?cmeMGD_
;bl_;bmdM7@A4A425aLG00H<30a/K6`;2`/;2`]@D50d=3@2D51@00DX:2QMGEeMGEdW9bMeMGD00SXj
>P06=SHf<30`<c<c<c<c51@DATI60SDe=@06:BTY3`l?:RXZ:RXZD51@@d=30U9BDP05@T92410@>SXj
>SXjH61P008K6a/01W9bLQXJ6YRHV9RHV1lO7hB4Q09DE5@01H:2P_ooooooooooo`00000^oooo00@0
003ooooooom@D502OGem00EnOWj>SXiBDU9BDU:QXJ400T51@@06/K6aN7QhF5QHF5QHJFUYH61P0WMg
M`06<C4a<c<c9BDU9BDU=CDeE5AD0[Rh^0057alOEeMGEeMGLG5a@D51008U9BD01RLW9chn?XN7QhN7
QdU9BB8R8P8^;Rh01B/[:d10@410@0X:2Te=C@02J6QX00Hm?Ce3@d=kNg]kNg]3@d=IFET24A4A00EG
EeLO7al^;Rh^;RhN7Qh00T51@@06>SXjBTY:;Bd];Bd]5aLGLW9b0VATI006Rh^;1PH69BDU9BDUMWIf
5aLG0STi>@05=CDe?clo?clo<S8bFe]K009[Jf/01W1`L4=3@eiNGUiNGShn?[Vi^@8N7Qh01HJ6QRXZ
:RXZ:ZVYZDm?C`028R8R00Hd=3@h>3Pm?Cdm?CdT92@A4A42JFUY00FDU9A9BDUTI6ATI6@T92@00QDE
5@06:RXZ<S8b=CDe=CDeMWIf:RXZ0WYjNP056a/K7alO20P820P8J6QX008820P01UaLG3Xj>U9BDU9B
DR<S8e=CD`8];Bd01X:2PS4a<B`/;2`/;2/[:b`/;08E5AD01C`l?2TY:BTY:AhN7P`<30027AdM00I5
ADE=CDeJFUYJFUXf=SH51@D2<30`00EMGEdJ6QYTI6ATI6@N7Qh00Xn?S`05410@MWIfIVIVIVIVLg=c
00?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooomDE5@00VYZJP06L71`P820?clo
?cloTY:B@d=30/71`@05QXJ6HV9RHV9RMgMgLG5a009YJFT01RLW9cdm?BPX:2PX:2XZ:U9BDP:XZ:P0
1Pd=3EaLG7=cLg=cLcDe=B<S8`8f=SH01Bl_;h61PEQHF5QHF30`<002>3Ph00HO7alc<c<B4Q8B4Q8o
?cm^KVh2;bl_00I6ATIfMWHi>CTi>CULG5`K6a/2Fe]K00DV9RH_;blI6ATI6ATg=cL00SXj>P06ATI6
9BDU6ATI6ATIJVYZG5aL0Y2@T0060`<37alOMWIfMWIf5ADE=SHf0SPh>005>c/k;bl_E5ADE5ADJVYZ
009cLg<01T92@V9RHT10@410@;2`/1LG5`:<S8`01S0`<:b/[4a<C4a<C2LW9c4a<@91@D401TA4A2h^
;QDE5ADE5Fm_Ki6AT@9?Cdl01FEUIAdM7AdM7APH63@d=002>c/k00Ho?cmeMGD_;bl_;bmdM7@A4A42
5aLG00H<30a/K6`;2`/;2`]@D50d=3@2D51@00DX:2QMGEeMGEdW9bMeMGD00SXj>P06=SHf<30`<c<c
<c<c51@DATI60SDe=@06:BTY3`l?:RXZ:RXZD51@@d=30U9BDP05@T92410@>SXj>SXjH61P008K6a/0
1W9bLQXJ6YRHV9RHV1lO7hB4Q09DE5@01H:2P_ooooooooooo`00000^oooo00@0003ooooooom@D502
OGem00EnOWj>SXiBDU9BDU:QXJ400T51@@06/K6aN7QhF5QHF5QHJFUYH61P0WMgM`06<C4a<c<c9BDU
9BDU=CDeE5AD0[Rh^0057alOEeMGEeMGLG5a@D51008U9BD01RLW9chn?XN7QhN7QdU9BB8R8P8^;Rh0
1B/[:d10@410@0X:2Te=C@02J6QX00Hm?Ce3@d=kNg]kNg]3@d=IFET24A4A00EGEeLO7al^;Rh^;RhN
7Qh00T51@@06>SXjBTY:;Bd];Bd]5aLGLW9b0VATI006Rh^;1PH69BDU9BDUMWIf5aLG0STi>@05=CDe
?clo?clo<S8bFe]K009[Jf/01W1`L4=3@eiNGUiNGShn?[Vi^@8N7Qh01HJ6QRXZ:RXZ:ZVYZDm?C`02
8R8R00Hd=3@h>3Pm?Cdm?CdT92@A4A42JFUY00FDU9A9BDUTI6ATI6@T92@00QDE5@06:RXZ<S8b=CDe
=CDeMWIf:RXZ0WYjNP056a/K7alO20P820P8J6QX008820P01UaLG3Xj>U9BDU9BDR<S8e=CD`8];Bd0
1X:2PS4a<B`/;2`/;2/[:b`/;08E5AD01C`l?2TY:BTY:AhN7P`<30027AdM00I5ADE=CDeJFUYJFUXf
=SH51@D2<30`00EMGEdJ6QYTI6ATI6@N7Qh00Xn?S`05410@MWIfIVIVIVIVLg=c00?oool00`000?oo
ooooo`0=oooo000Roooo0P0000;oool01GUiNIRHV9RHV2TY:Fe]K@02EUIF00Dn?Shm?CdT92@T92BB
TY800[Jf]P06De=CE5AD=cLg=cLg=3@dI6AT0Rd];@06DU9BPh>3P820P82020P8Shn?0RTY:@06;Bd]
<30`BDU9BDU93Ph><c<c0QHF5P05O7al@410@410@D51@T920090@4001Pl?3eIFERHV9RHV9RTY:FAT
I0:CTi<01TQ8B8Z:RQLG5aLG5fUYJBHV9P8j>SX01E5ADGEeMGEeME9BDP<30`02BTY:00Hd=3A@D51h
N7QhN7Q3@d<k>c/2B4Q800HH61QFEUIUIFEUIFEKFe/g=cL23`l?00ESHf<`<30`<32`/;1ADE400UUI
F@06HF5QT92@WinOWinOIFEU61PH0TI6AP069BDUO7al92@T92@TFUYJ?Shn0QTI6@05Ng]kFEUILG5a
LG5aSHf=008C4a<01X^;Rc8b<UYJFUYJFRh^;Xn?S`95ADD01S8b<UMGEclo?clo?d=3@f=SH`8Y:BT0
1@L71a<C4`/;2`/;2h>3P`02@D5100HB4Q8b<S9VIVIVIVHU9BE0@4026a/K00I4A4A/K6a0@410@40N
7Qi<C4`292@T00JBTY:3Ph=aLG5aLG5EEEENGUh2QhN700G/k>b5QHF5QHEHF5R8R8P00SPh>005RHV9
[Zj^Bd];Bd];Jf][00;oool20000;_ooo`8000001_ooofa/K:n_[jn_[cLg=fATI09YJFT01Dm?CeAD
E5ADE14A4HV9R@02Zj^[00I6ATI4A4@[:b/[:b/];Be?Cdl2@41000EKFe]_Kfn?Shn?Shl;2`/00Xn?
S`06?Cdm:BTY>3Ph>3Ph>c/k1@D50T51@@051@D5Jf][=CDe=CDeDe=C009?Cdl01U1@D1HF5UEEEEEE
EAhN7RPX:09MGEd01YZJVTY:BYRHV9RHV0h>3V5QH@8S8b<01C`l?5YJFUYJFWQhN4m?C`022PX:00I7
AdLm?CeHF5QHF5QkNg];Bd/2=cLg00E5ADDO7amIFEUIFEUQHF400UaLG006?Cdm30`<H61PH61P=CDe
[Zj^0Ti>CP05H61PHV9RV9RHV9RHX:2P009OGel01Q0@44m?CahN7QhN7XB4Q2h^;P9ADE401TU9BB@T
979bLW9bLV9RHVa/K0:>SXh01A/K6h>3Ph>3PcXj>U=CD`0292@T00J;Rh]CDe<a<C4a<C5ADE5=CDd2
=SHf00EIFET^;Rh^;Rh:2PXD51@00QDE5@06MGEeDU9B8R8R8R8R@d=3FUYJ0QdM7@05>SXj9bLWD51@
D51@GEeM008j>SX01QLG5e]KFaTI6ATI6HF5QIRHV0:3Ph<01T92@T];BgYjNWYjN]kNgXZ:RP99BDT0
1GMgMdQ8B4Q8B8J6QYZJVP02HV9R00=IFEWoooooool00P0000ooool002;oool01@000?oooooooooo
oi2@T002X:2P00JCTi=CDe=_Kfm_Kflj>SXg=cL2Shn?00Dk>c][Jf][Jf/l?3b7QhL00Pl?3`06BDU9
9bLW61PH61PHDU9B?clo0TM7A`06:b/[?Shn71`L71`L;bl_@4100SXj>P05>3PhDU9BH61PH61P@d=3
009bLW801Ta<C75aLC@d=3@d=4];Ba0@408Z:RX01UeMGC8b</_;bl_;beUIFHF5Q@8X:2P01BXZ:Q@D
52LW9bLW9cTi>@02H61P00Hc<c<H61Q]KFe]KFeFEUISHf<2d];B00@A4A56ATHM7AdM7Ad2:BTY0RPX
:004;Bd];Rh^RHV9RHV90adM7@06=cLgADE5@D51@D51<c<c92@T0S@d=006>3Ph5aLG;2`/;2`/<S8b
EEEE0X20P005:RXZ@T92_Kfm_KfmD51@00=6ATH01FQXJ3lo?clo?f=SHeYJFP024A4A00HV9RHI6AU?
Cdm?CdmJFUX`<302B4Q800Hm?CeBDU90@410@413@d<Z:RX2>c/k00EJFUY1@D51@D5FEUHj>SX00QLG
5`06MWIf;bl_7AdM7AdM410@FEUI0UeMG@06=cLg?Cdm8B4Q8B4Q<S8b:RXZ0YJFUP055ADEJ6QXT92@
T92@MWIf009FEUH01VUYJF][Ji2@T92@T51@D:NWY`8h>3P01Da<C?ooooooooooo`00000^oooo00@0
003ooooooon6QXH2[Zj^00F?ShmPH61UIFEUIFE5ADD00STi>@06V9RH<C4aK6a/K6a/?ShnSHf=0QPH
6006@D517alO7AdM7AdMCdm?>c/k0T=3@`05<S8bATI6ATI692@T=CDe008o?cl01SHf=S<c<eQHF5QH
F5aLG4I6AP9`L7001E5ADG5aLG5aLC@d=4e=C@024A4A00H/;2aQHF4`<30`<33<c<aIFET2Q8B400DZ
:RX/;2`E5ADE5ADU9BD00STi>@06H61P=cLg5QHF5QHFL71`FUYJ0V5QH@06d=3@4A4AA4A4A4A48R8R
:2PX0Rh^;P05;2`/:BTY:BTY;Bd]RXZ:008P82001R<S8c4a<Da<C4a<C3`l?3Hf=P8O7al01CTi>Chn
?Shn?Q4A4B/[:`02>CTi00IGEeN0P80a<C4a<C52@T;2`/82BDU900E0@41;Bd]VIVIVIVHl?3`00UiN
GP06HV9R5ADE:b/[:b/[51@DF5QH0UUIF@05;Bd]D51@>CTi>CTiE5AD0090@4001SXj>R/[:c<c<c<c
<eIFET];B`9NGUh01S0`<0`<36a/K6a/K2`/;2PX:0851@D01E9BDVATI6ATI3dm?DU9B@02:BTY00Hf
=SH/;2bMWIfMWId?3`mMGEd2QHF500E^KViIFEUNGUiNGUi/K6`00YBDU005GUiNXJ6Q<c<c<c<cD51@
00?oool00`000?ooooooo`0=oooo000Roooo00D0003oooooooooooo7alL00X61P@06410@EEEEADE5
ADE5EeMG;Rh^0V1PH005V9RHC4a<C4a<PX:2RHV9008E5AD01SDe=IVIVH20P820P8F5QHB4Q08Z:RX0
1WalO2<S8eeMGEeMGDQ8B2TY:@98B4P01G5aLH:2PQ<C4a<C4eUIF@02D51@00Ho?clH61PY:BTY:BT^
;RhU9BD2;Bd]00Ha<C4c<c<e=CDe=CEUIFE7AdL2DE5A00D@410E5AEJFUYJFUXc<c<00TY:BP06?clo
@d=3JFUYJFUYP820KVi^0Va/K0066ATI1PH69BDU9BDU8R8R9BDU0U9BDP05Hf=S61PHFUYJFUYJ3`l?
009VIVH01SPh>2DU9A`L71`L75eMGH:2PP8L71`01Ph>3UeMGHN7QhN7QcXj>UADE08L71`01Rl_;cLg
=da<C4a<C30`<4U9B@8m?Cd01F5QHB0P820P865QHH>3P`02EeMG00H;2`]5ADDC4a<C4a=[Jf/B4Q82
8b<S00ITI6@Z:RX>3Ph>3PiCDe=9BDT21@D500EoOgm/K6a/K6`K6a]IFET00V=SH`06g=cL>c/k2@T9
2@T9HV9RBDU90Rl_;`06@T92GemOWYjNWYjN8R8RATI60U=CD`0592@T8R8RXJ6QXJ6Q7AdM009PH600
1SHf=WUiNGIfMWIfMUUIFAhN7P97AdL01B@T9?ooooooooooo`00000^oooo00@0003oooooooo4a<@2
RXZ:00D:2PYMGEdo?clo?cmHF5P00Rl_;`06EUIFShn?F5QHF5QHMgMgQHF50R<S8`06=CDeShn?T92@
T92@N7QhQhN70SXj>P05KVi^<c<c<c<cCdm?B4Q8008h>3P01UMGEf9RHWAdM7AdM0/;2dU9B@9RHV80
1E1@D1lO7alO7c@d=2HV9P025ADE00HM7AdQ8B4i>CTi>CU5ADEGEeL2F5QH00EIFET410@T92@T92AO
Gel00R/[:`06F5QH<C4aD51@D51@JFUYRHV90Ve]K@06HF5Q3Ph>4Q8B4Q8B<C4a5aLG0Q/K6`05GemO
FEUIFEUI8b<SGUiN008G5aL01V1PH492@Q`L71`L72DU9EIFEP:1PH401A@D514A4A4A4EIFEXV9R@02
<c<c00IGEeLE5ADW9bLW9bLh>3Q<C4`2:BTY00E7AdLm?CeSHf=SHf<W9bL00UeMG@06RXZ:DU9B4Q8B
4Q8B@d=33@d=0W1`L00551@D:2PXIfMWIfMW:BTY008:2PX01U1@D4A4A0/;2`/;2ginOW1`L08P8200
1UEEEFQXJ=WIfMWIfCXj>PT92@9NGUh01De=CC@d=3@d=4M7AfEUI@02WYjN00HV9RI;Bd]EEEEEEEDY
:BTT92@2YJFU00DQ8B5WIfL`<30`<321PH400W=cL`05EeMG7QhNBTY:BTY:7alO00?oool00`000?oo
ooooo`0=oooo000Roooo00D0003oooooooooooo7alL00X61P@06410@EEEEADE5ADE5EeMG;Rh^0V1P
H005V9RHC4a<C4a<PX:2RHV9008E5AD01SDe=IVIVH20P820P8F5QHB4Q08Z:RX01WalO2<S8eeMGEeM
GDQ8B2TY:@98B4P01G5aLH:2PQ<C4a<C4eUIF@02D51@00Ho?clH61PY:BTY:BT^;RhU9BD2;Bd]00Ha
<C4c<c<e=CDe=CEUIFE7AdL2DE5A00D@410E5AEJFUYJFUXc<c<00TY:BP06?clo@d=3JFUYJFUYP820
KVi^0Va/K0066ATI1PH69BDU9BDU8R8R9BDU0U9BDP05Hf=S61PHFUYJFUYJ3`l?009VIVH01SPh>2DU
9A`L71`L75eMGH:2PP8L71`01Ph>3UeMGHN7QhN7QcXj>UADE08L71`01Rl_;cLg=da<C4a<C30`<4U9
B@8m?Cd01F5QHB0P820P865QHH>3P`02EeMG00H;2`]5ADDC4a<C4a=[Jf/B4Q828b<S00ITI6@Z:RX>
3Ph>3PiCDe=9BDT21@D500EoOgm/K6a/K6`K6a]IFET00V=SH`06g=cL>c/k2@T92@T9HV9RBDU90Rl_
;`06@T92GemOWYjNWYjN8R8RATI60U=CD`0592@T8R8RXJ6QXJ6Q7AdM009PH6001SHf=WUiNGIfMWIf
MUUIFAhN7P97AdL01B@T9?ooooooooooo`00000^oooo00@0003oooooooo4a<@2RXZ:00D:2PYMGEdo
?clo?cmHF5P00Rl_;`06EUIFShn?F5QHF5QHMgMgQHF50R<S8`06=CDeShn?T92@T92@N7QhQhN70SXj
>P05KVi^<c<c<c<cCdm?B4Q8008h>3P01UMGEf9RHWAdM7AdM0/;2dU9B@9RHV801E1@D1lO7alO7c@d
=2HV9P025ADE00HM7AdQ8B4i>CTi>CU5ADEGEeL2F5QH00EIFET410@T92@T92AOGel00R/[:`06F5QH
<C4aD51@D51@JFUYRHV90Ve]K@06HF5Q3Ph>4Q8B4Q8B<C4a5aLG0Q/K6`05GemOFEUIFEUI8b<SGUiN
008G5aL01V1PH492@Q`L71`L72DU9EIFEP:1PH401A@D514A4A4A4EIFEXV9R@02<c<c00IGEeLE5ADW
9bLW9bLh>3Q<C4`2:BTY00E7AdLm?CeSHf=SHf<W9bL00UeMG@06RXZ:DU9B4Q8B4Q8B@d=33@d=0W1`
L00551@D:2PXIfMWIfMW:BTY008:2PX01U1@D4A4A0/;2`/;2ginOW1`L08P82001UEEEFQXJ=WIfMWI
fCXj>PT92@9NGUh01De=CC@d=3@d=4M7AfEUI@02WYjN00HV9RI;Bd]EEEEEEEDY:BTT92@2YJFU00DQ
8B5WIfL`<30`<321PH400W=cL`05EeMG7QhNBTY:BTY:7alO00?oool00`000?ooooooo`0=oooo000R
oooo00D0003ooooooooooonm_Kd00S<c<`06D51@@410Shn?Shn?DU9B92@T0W5aL@05BDU9Hf=SHf=S
FEUIE5AD008G5aL01Pl?3aXJ6Ph>3Ph>3TE5AF][J`:LW9`01UeMGCLg=fIVIVIVIVATI79bLP8Z:RX0
1H>3PgmoOeADE5ADE861P@029RHV00I;Bd/k>c/I6ATI6AU9BDTb<S82/K6a00Hk>c]=CDeEEEEEEEE0
@41nOWh2<c<c00De=CEYJFUTI6ATI6A@D5000Ti>CP04Cdm?MGEeFe]KFe]K0Sdm?@8o?cl01W9bLU9B
DT51@D51@Bd];CPh>09bLW801F][Jc8b<Rd];Bd];De=C@02?Shn00Hj>SXZ:RXd=3@d=3@D51AHF5P2
1PH600HQ8B5RHV9GEeMGEeM8B4Pm?Cd2?3`l00IADE5mOGd];Bd];BdS8b<R8R82;Bd]00EjNWYIFEUI
FEU4A4@o?cl00V][J`06>CTi:BTYB4Q8B4Q8FUYJ9RHV0Q4A4@06;2`/8b<S<c<c<c<c@d=3@T920QhN
7P0561PH8B4Q8B4Q9RHV9BDU008W9bL01VQXJ51@D5=CDe=CDh>3PbLW9`8];Bd01WIfMPD51Hj>SXj>
SVUYJ@X:2P9mOGd01AdM7G5aLGEeMGEeME9BDP02G5aL00H<30`j>SXc<c<c<c=eMGFHV9P2M7Ad00DQ
8B7oooooooooool00000;_ooo`040000oooooooo[Jf]0T92@P05CTi>>c/kSXj>SXj>?clo008h>3P0
1V][Jcdm?E1@D51@D55ADDQ8B08/;2`01PP821hN7Q`L71`L75MGEeaLG0:KVi/01EEEEDA4A4A4A6AT
I6IVIP02OGem00HN7QiaLG5_Kfm_Kfm4A4AaLG42=CDe00ELG5`k>c/k>c/Y:BU3@d<00RDU9@06YjNW
=3@dBTY:BTY:Bd];AdM70XB4Q005?Cdm:2PXMGEeMGEeGEeM009LG5`01UQHF51@D861PH61PE9BDTI6
AP8h>3P01TM7Afm_KeQHF5QHF4=3@cDe=@8a<C401G]kNfQXJ6QXJ3Lg=bLW9`02E5AD00Hj>SY0@40U
9BDU9BDh>3PC4a<2EEEE00D30`<M7AdM7AeOGemDE5@00TY:BP06?Shn>CTiCDe=CDe=NWYj:BTY0QlO
7`059bLW;Bd]Ng]kNg]kG5aL0097AdL01S`l?6m_KcTi>CTi>Bh^;TI6AP9KFe/00bLW9a4A4BHV9P02
9RHV0S0`<006?3`lBDU99BDU9BDU71`L92@T0QdM7@06:BTY:RXZHV9RHV9RBd];GUiN0WQhN00592@T
>c/k>c/kOGem3`l?00:9RHT01V=SHaTI6HV9RHV9R@d=3GEeM@9nOWh01F5QHE]KFa`L71`L74I6AP02
:2PX00F2PX:?Shn1PH61PH4G5aL00oooo`030000oooooooo00goool002;oool01@000?oooooooooo
olg=c@02Ti>C00JHV9QUIFDj>SXj>SY:BTY5ADD2AdM700EBDU99BDU9BDVMWIdK6a/00R8R8P06IVIV
71`LCDe=CDe=M7AdIfMW0Rh^;P067alOJf][OgmoOgmoFe]K/[:b0WUiN@05;Rh^HF5Q@T92@T926QXJ
008F5QH01Sdm?Bl_;g5aLG5aLC4a<DQ8B0::RXX01RXZ:RLW9eeMGEeMGEADE6MWI`9:BTX01DA4A3lo
?eMGEeMGEemOG`02Ng]k00IADE4n?Shj>SXj>SX?3`lf=SH2@d=300HN7Qi>CThU9BDU9BE`L70c<c<2
9RHV00ERHV9hN7RHV9RHV9QOGel00R/[:`06<30`=cLgHV9RHV9R7AdM>c/k0U5AD@06:2PX:RXZ820P
820PDU9B>SXj0R4Q8@06NWYjJFUYGEeMGEeMATI6/K6a0TU9B@05Kfm_Lg=cLg=c7QhNEEEE009RHV80
1U9BDPL71a<C4a<C4emOGdE5A@9:BTX01RLW9a8B4T];Bd];Bbl_;da<C098B4P01FUYJE1@D51@D5]K
Ff][J`02?clo00HO7al];Bda<C4a<C5EEEESHf<21@D500HA4A4l?3b?Shn?Shm0@40O7al2ADE500DZ
:RYPH61QHF5QHF4L71`00Q8B4P06EEEEOWinHf=SHf=S5aLGFe]K0RTY:@05BDU9oooooooooooo0000
02koool010000?ooooooolc<c0:<S8`01H^;Rf9RHS4a<C4a<C`l?002>3Ph00IFEUI5ADDl?3`l?3bV
YZHH61P251@D00IdM7@W9bM8B4Q8B4R2PX9OGel2:2PX00DI6AUgMgMgMgMeMGEEEED00Zj^[P06OGem
:RXZJFUYJFUY@4107AdM0Pl?3`05>c/k<C4a<C4aK6a/=cLg0099BDT01XR8R2TY:BXZ:RXZ:V1PH5IF
EP9YJFT01DY:BTI6AT10@410@5QHF002H61P00IkNg]BDU8m?Cdm?Cdl?3`>3Ph2=3@d00I0@40R8R9=
CDe=CDdS8b=_Kfl2<c<c00D[:b]XJ6QXJ6QfMWJOWil00UYJFP069RHV;2`/=3@d=3@dGEeM8b<S0SPh
>005CDe=;2`/;2`/:2PX9RHV009IFET01SLg=a`L77emOGemOFQXJ5iNGP97AdL01K>c/d];Bfi^KVi^
KWUiN@026QXJ00IHF5QRHV9HF5QHF5P;2`/?3`l2Fe]K00E0@41<C4`S8b<S8b<B4Q800Ti>CP06;2`/
CTi>Cdm?Cdm?LG5aBDU90UIFEP06LG5aBDU95QHF5QHF<30`>c/k0Tm?C`05GEeM2PX:2PX:71`L<S8b
00:DU9@01T51@A/K6e9BDU9BDRd];FMWI`9PH6001B/[:`T92FEUIFEUIG1`L002JFUY00DO7amNGUhO
7alO7amCDe<00oooo`030000oooooooo00goool002;oool200000_ooo`05P820VYZJVYZJHf=SGUiN
008k>c/01CDe=CLg=fe]KFe]KE1@D002alO700ITI6@e=CDL71`L71`G5aLX:2P2EeMG00I]KFeMGEdQ
8B4Q8B5KFe]9BDT27alO00DW9bMZJVX^;Rh^;Rhn?Sh00d10@005?Cdm>3Ph>3PhHf=S8b<S009GEeL0
1Tm?CbLW9bh^;Rh^;Q8B4Rd];@8N7Qh01R/[:hN7QdM7AdM7Ab8R8Q<C4`93@d<01D];BgEeMGEeMB`/
;4A4A002=3@d00HA4A4_;blT92@T92ATI6@820P2CTi>00Jc/k<E5AE?Cdm?CdlN7QiMGEd2@d=300Dl
?3ahN7QhN7P@411YJFT00R/[:`067AdM4A4A<C4a<C4a;bl_20P80TI6AP06CTi>:2PXK6a/K6a/<c<c
>c/k0Rl_;`05?CdmTY:BA4A4A4A4=cLg00:EUID01RLW9hR8R3/k>c/k>bDU9E5AD@9RHV801QLG5da<
C8:2PX:2PT];Bc8b<P8T92@01C4a<C/k>e]KFe]KFlS8b002/[:b00HG5aL];Bf8R8R8R8Pg=cLG5aL2
6ATI00IcLg=@D50Z:RXZ:RXa<C5KFe/2BDU900Hi>CTb<S9CDe=CDe=3@d<>3Ph261PH00Dg=cMMGEeM
GEdH61RXZ:P00R4Q8@05JVYZ61PH?clo?clo2@T900;oool20000;_ooo`8000001_ooohb<S9BDU9BD
U6EUIEEEE@9:BTX01B/[:bTY:BTY:F9RHUEEE@02`L7100IXJ6Pb<S8[:b/[:b/F5QHW9bL2EEEE00E]
KFeWIfLX:2PX:2QJFUX00Ta<C0068b<S8B4QGemOGemO>c/kBTY:0T];B`05=CDe?clo;bl_;bl_FEUI
008X:2P01UADE5YJFQdM7AdM7Bl_;aXJ6P8Y:BT01RDU9B@T98^;Rh^;Rd10@1lO7`8J6QX01D=3@dY:
BTY:BWEeMB/[:`02?clo00Hd=3@<30`d=3@d=3@P821PH60230`<00E:BTZe]KDA4A4A4A5BDU800QhN
7P06HF5Q@D51?Shn?ShnNWYj51@D0Ve]K@05;bl_8B4Q410@410@=3@d008c<c<01P/;2dE5ADa<C4a<
C2d];FUYJ@8f=SH01T10@38b<Shn?Shn?Y6ATD51@@8g=cL01I6ATB/[:b/[:hV9RClo?`02:b/[00I=
CDeZJVXA4A4A4A5BDU::RXX2A4A400Dc<c<N7QhN7QhZ:RY0@4000UmOG`06aLG5^;Rh4A4A4A4A=3@d
QHF50Sdm?@055QHF6a/KNg]kNg]kATI6008P82001RTY:E1@D5ADE5ADE3Xj>SLg=`9OGel01T10@041
0A0@410@42XZ:UiNGP8V9RH01I^KVbDU9BDU9EaLG24Q8@02Cdm?00<F5QKoooooool00P0000ooool0
02;oool01@000?oooooooooooh20P002VYZJ00ISHf=NGUhk>c/k>c/e=CDg=cL2KFe]00E@D537alO7
alMTI6@e=CD00Q`L70065aLG:2PXEeMGEeMGKFe]GEeM0R4Q8@06Fe]KBDU97alO7alO9bLWJVYZ0Rh^
;P05?Shn@410@410@410?Cdm008h>3P01V=SHb<S8eMGEeMGEdm?CbLW9`8^;Rh01Q8B4Rd];AhN7QhN
7R/[:hN7Q`97AdL01B8R8Q<C4d=3@d=3@d];B`02MGEe00H/;2a4A4@d=3@d=3@A4A4_;bl292@T00IT
I6@820Q>CTi>CTjc/k<E5AD2Cdm?00DN7QiMGEe3@d=3@d<l?3`00WQhN006410@JFUY:b/[:b/[7AdM
4A4A0S4a<@06;bl_20P8ATI6ATI6CTi>:2PX0Va/K006<c<c>c/k;bl_;bl_?CdmTY:B0TA4A005=cLg
UIFEUIFE9bLWR8R8008k>c/01RDU9E5ADF9RHV9RHQLG5da<C0:2PX801T];Bc8b<R@T92@T934a<C/k
>`9KFe/01LS8b;:b/[:b/QLG5bd];@02R8R800Hg=cLG5aLI6ATI6AUcLg=@D502:RXZ00Ha<C5KFe]9
BDU9BDTi>CTb<S82De=C00E3@d<>3PhH61PH61Pg=cL00UeMG@0661PHZ:RX8B4Q8B4QJVYZ61PH0Slo
?`052@T9oooooooooooo000002koool010000?ooooooohb<S0:DU9@01FEUIEEEEDY:BTY:BR/[:`02
:BTY00IRHV9EEEG1`L71`L5XJ6Pb<S82:b/[00HF5QHW9bMEEEEEEEE]KFeWIfL2:2PX00EJFUY<C4a<
C4`S8b<Q8B400UmOG`06>c/kBTY:Bd];Bd];=CDe?clo0Rl_;`05FEUI:2PX:2PXE5ADFUYJ008M7Ad0
1Rl_;aXJ6RTY:BTY:BDU9B@T90:;Rh/01D10@1lO7aXJ6QXJ6T=3@`02BTY:00IeMGD[:b/o?clo?cld
=3@<30`2=3@d00HP821PH60<30`<30a:BTZe]KD24A4A00EBDU8N7QhN7QiQHF51@D400Shn?P06NWYj
51@DKFe]KFe];bl_8B4Q0Q0@4005=3@d<c<c<c<c2`/;ADE5009<C4`01Rd];FUYJCHf=SHf=T10@38b
<P8n?Sh01I6ATD51@CLg=cLg=i6AT@02:b/[00J9RHTo?cl[:b/[:b]=CDeZJVX24A4A00EBDU::RXY4
A4A4A4@c<c<00QhN7P06:RXZ@410GemOGemOaLG5^;Rh0Q4A4@06=3@dQHF5?Cdm?Cdm5QHF6a/K0W]k
N`05ATI6820P820P:BTYD51@009DE5@01SXj>SLg=emOGemOGd10@0410@8@41001BXZ:UiNGRHV9RHV
9Y^KV`029BDU00ELG5`Q8B5?Cdm?CdlF5QH00oooo`030000oooooooo00goool002;oool01@000?oo
oooooooooh^;R`02De=C00Jc/k=<C4`c<c<c<c<U9BETI6@25QHF00ENGUiZJVYZJVZOWil`<3000STi
>@06B4Q8MGEe@D51@D5171`LYjNW0U1@D006@T92NGUiW9bLW9bLAdM751@D0RLW9`05<C4aGemOHV9R
HV9R@D51008[:b/01XR8R0`<32PX:2PX:1DE5Chn?P8@41001Ph>3UaLG2/[:b/[:ifMWB`/;08f=SH0
1EEEED10@10@410@49VIV@02:RXZ00HI6AUBDU9WIfMWIfLP821`L7027AdM00IPH60S8b<h>3Ph>3QN
GUi1@D42D51@00EOGem3@d<O7alO7amIFET00UADE006ADE5Cdm?I6ATI6AT:RXZH61P0TQ8B00661PH
;bl_Vi^KVi^K0`<3N7Qh0VQXJ0069BDU7AdM<30`<30`7QhNI6AT0P<30`05OWinAdM7AdM7ATI6PH61
0096ATH01T];BeQHF2XZ:RXZ:S4a<H^;R`9cLg<01STi>D92@Rl_;bl_;b/[:dY:BP8820P01@d=3EEE
EEEEEA<C4d92@P02FEUI00I]KFdE5ADX:2PX:2QNGUi7AdL2JVYZ00IFEUI^KViHF5QHF5PK6a]8B4P2
@D5100DC4a>DU9@K6a/K6a/R8R800QLG5`06U9BDHF5QEeMGEeMG>SXjC4a<0W=cL`05MgMgoooooooo
oooo000002koool010000?ooooooohZ:RP9EEED01KNg]di>CS@d=3@d=2PX:002HV9R00HH61QLG5a/
K6a/K6bPX:0c<c<2>CTi00I:BTYcLg<n?Shn?ShI6AV[Zj/2D51@00E7AdMfMWIfMWJIVIU2@T800Q0@
4006:RXZ>3PhIFEUIFEUHV9RBDU90S<c<`05RXZ:1PH61PH68B4Q6a/K0094A4@01PP820L71eMGEeMG
Ec@d=9JFUP8S8b<01Bh^;UiNGSTi>CTi>ATI6@02VIVI00Hd=3@B4Q9=CDe=CDeaLG4O7al2K6a/00HK
6a]SHf<I6ATI6ATo?cmWIfL2AdM700E;Bd][Jf][Jf/n?ShW9bL00VEUI@06G5aLCdm?GEeMGEeMEeMG
=cLg0U]KF`05>c/k9bLW9bLW8R8RSHf=008?3`l01Vm_Kf][JaDE5ADE5B`/;3lo?`8L71`01EQHF14A
4Fi^KVi^KTE5A@02@D5100IcLg=DE5ABDU9BDU96ATHg=cL2:BTY0XJ6QP8d=3@01CDe=Bl_;bl_;b/[
:eQHF0024A4A00H61PIKFe/T92@T92@n?Si:BTX2JVYZ00DP820N7QiJFUYJFUY?Cdl00UiNGP06EEEE
IFEUCTi>CTi>:2PX?3`l0TM7A`0661PHRXZ:9BDU9BDU8R8R7alO0Y6AT@05IfMWD51@D51@@D51De=C
009iNGT01GinO_ooooooooooo`00000?oooo000Roooo00D0003ooooooooooono_kl00YZJVP06:b/[
QXJ6MGEeMGEe2`/;Hf=S0UmOG`05:2PX?3`l?3`llo?cX:2P008o?cl01Shn?]GEeAhN7QhN7YNGUfEU
I@9DE5@01RXZ:XR8R2@T92@T96IVIVMWI`:7QhL01E=CDbTY:Bl_;bl_;cPh>0025aLG00DV9RH71`Lj
>SXj>SY0@4000bLW9`069RHV[Zj^;Bd];Bd]XJ6Q3Ph>0XV9R@05QXJ6FUYJ>c/k>c/kemOG00:@T900
1WYjNTM7AgQhN7QhN3dm?INGU`9jNWX01R`/;0T92A8B4Q8B4QHF5T92@P95ADD01EEEE@/;2f5QHF5Q
HB8R8P02LW9b00JGUiM9BDU;Bd];Bd/B4Q9lO7`2;2`/00Hi>CUIFEUCDe=CDe=;Bd]VIVH2C4a<00Ik
Ng/[:b/o?clo?cmSHf=;Bd/2FEUI00DF5QJ1PH61PH5BDU9JFUX00UaLG006Bd];8b<S9bLW9bLWADE5
R8R80W=cL`06De=C51@DJ6QXJ6QX820PCTi>0QPH6005Cdm??Cdm?CdmEUIFO7al008C4a<01VMWIa@D
56ATI6ATI69RHS8b<P8U9BD01Shn?UADE6EUIFEUIBDU9@h>3P:@T9001B@T97QhN5=CDe=CDfMWI`02
De=C00ILG5`a<C5`L71`L71eMGG=cLd2VYZJ00E]KFgoooooooooool00000;_ooo`040000oooooooo
b<S80YBDU00592@TOgmoMWIfMWIf4a<C009KFe/01UmOGc@d=3<c<c<c<ooooiRHV09=CDd01Ta<C=cL
g2HV9RHV9Xn?SeUIF@9CDe<01Bd];I6ATI6ATA/K6eUIF@02IfMW00JGUiM=CDde=CDe=CDn?ShX:2P2
92@T00Dg=cL?3`l?3`l`<31@D5000R@T9006=SHf<30`[:b/[:b/;bl_UYJF0P820P05P820UIFEE5AD
E5ADADE500;AdM401YJFUW9bLTa<C4a<C7MgMd92@P:OWil01WMgMbTY:@<30`<30adM7@l?3`8m?Cd0
1D];BeiNGUiNGPT92G1`L002;bl_00IjNWZEUIEBDU9BDU8m?CdO7al2K6a/00@N7Qhf=SHf=SI:BTX3
@d=300ISHf<k>c^5QHF5QHDn?SiADE42KFe]00Dh>3Q6ATHA4A4A4A5aLG400V9RHP06CTi>Hf=SCDe=
CDe=8R8R5QHF0SXj>P05OgmoHf=SF5QHF5QH2PX:009PH6001R`/;5iNGQhN7QhN7U5ADCTi>@9NGUh0
1WMgMahN7UaLG5aLG1dM7EUIF@9HF5P01CTi>B4Q8B4Q8DE5AE1@D002GemO00HR8R8E5AFATI6ATI4Z
:RYgMgL2EeMG00EVIVIIFEUMGEeMGEd];Bd00W5aL@05LW9bclo?UYJFUYJFJ6QX00?oool00`000?oo
ooooo`0=oooo000Roooo00D0003ooooooooooom:BTX00XF5Q@06ADE5<30`G5aLG5aL:RXZU9BD0SHf
=P05LG5a@T92@T92820PMWIf009CDe<01Rd];DU9BB<S8b<S8hb<S3Xj>P8K6a/01U9BDSlo?clo?clo
?b8R8Te=C@8g=cL01E9BDR/[:dU9BDU9BC<c<`027alO00IQHF4<30`Z:RXZ:RX<30a5ADD26QXJ00H_
;bnJVYX>3Ph>3PiNGUhK6a/2<S8b00DZ:RYLG5`H61PH61Ro_kl00R4Q8@06JFUY/K6a3@d=3@d=JFUY
:BTY0QXJ6P06Ogmo?clo9bLW9bLWCDe=2`/;0U5AD@055ADEDE5ADU9BDU9B6a/K009IFET01TA4A1dM
7E=CDe=CD`T92HR8R08D51@01B<S8cHf=QhN7QhN7SDe=@03HV9R00IfMWHl?3a5ADE5ADEPH61WIfL2
61PH00D`<30Q8B4Q8B4F5QHn?Sh00W5aL@06HV9Ra/K6CTi>CTi>H61POGem0R`/;006Hf=SGEeMSXj>
SXj>TI6A6QXJ0UmOG`05EeMGCDe=CDe=20P8DU9B009<C4`01SXj>SDe=DQ8B4Q8B;no_aHF5P99BDT0
1XZ:RWEeMG]kNg]kNf][Je5AD@:7QhL01EADE492@V1PH61PH0H61P02H61P00HA4A6ATI5OGemOGenR
XZ:VYZH2HV9R00E:BT[oooooooooool00000;_ooo`040000ooooooooCDe=0XF5Q@05AdM7;Rh^H61P
H61P:2PX00:GUiL01SDe=GAdM410@410@28R8WAdM09EEED01S4a<Da<C2HV9RHV9Xj>SSPh>08K6a/0
1EEEED=3@d=3@d=3@bDU9@02DU9B00Hk>c]HF5P_;bl_;bm6ATH_;bl27alO00ESHf<71`L71`L^;RhA
4A400T=3@`068B4Q=3@dVYZJVYZJ2`/;FEUI0Q`L7005;bl_;2`/FUYJFUYJ4Q8B00:o_kl01Q/K6g=c
Ljb/[:b/[0H61W=cL`8/;2`01Q@D57moOcTi>CTi>B0P84E5A@8E5AD01EMGEa<C4a<C4eaLG5=CD`02
9RHV00ICDe<l?3`E5ADE5AE>CTh<30`2RXZ:00D;2`/K6a/K6a/];BdV9RH00SPh>006G5aLFUYJOgmo
Ogmo=SHfBd];0VYZJP05IFEU6a/K:2PX:2PX6ATI008N7Qh01TI6AWIfMVYZJVYZJ/K6aUADE09LG5`0
1GYjNRh^;UmOGemOGf1PH002S8b<00JDU9@K6a]TI6ATI6AHF5Q?Cdl22`/;00IEEEE:BTXk>c/k>c/d
=3A8B4P2_kno00DG5aM;Bd];Bd^=SHegMgL00WalO006Jf][De=CRHV9RHV9EUIF@T920V=SH`051@D5
H61P410@410@TI6A009OGel01J:RXZJVYV5QHF5QHDQ8B003oooo00<0003oooooool03Oooo`008_oo
o`050000ooooooooooooBTY:00:5QHD01TE5AC0`<5aLG5aLG2XZ:YBDU08f=SH01G5aLD92@T92@R0P
87IfMP02De=C00H];Be9BDTS8b<S8b><S8`j>SX26a/K00IBDU8o?clo?clo?clR8R9=CDd2=cLg00EB
DU8[:b]9BDU9BDTc<c<00QlO7`06HF5Q30`<:RXZ:RXZ30`<ADE50QXJ6P06;bl_VYZJ3Ph>3Ph>GUiN
6a/K0S8b<P05:RXZG5aL61PH61PH_kno008Q8B401VUYJK6a/@d=3@d=3FUYJBTY:@8J6QX01WmoOclo
?bLW9bLW9de=C@/;2`9ADE401ADE5E5ADE9BDU9BDQ/K6`02FEUI00I4A4@M7AeCDe=CDe<92@V8R8P2
51@D00DS8b<f=SHN7QhN7Qhe=CD00f9RHP06MWIf?3`lADE5ADE5H61PIfMW0QPH6005<30`8B4Q8B4Q
5QHF?Shn009aLG401V9RH/K6aTi>CTi>CV1PH7emO@8/;2`01V=SHeeMGHj>SXj>SY6ATAXJ6P9OGel0
1EMGEde=CDe=C@P8259BDP02C4a<00Hj>SXe=CE8B4Q8B4Ro_klF5QH2BDU900J:RXYeMGEkNg]kNg][
Jf]ADE42QhN700EDE5A2@T9PH61PH6061PH00V1PH0064A4ATI6AGemOGemOXZ:RYZJV0V9RHP05BTY:
oooooooooooo000002koool010000?ooooooode=C@:5QHD01DM7Abh^;V1PH61PH2PX:002UiNG00He
=CEdM7A0@410@40R8R9dM7@2EEEE00Ha<C5<C4`V9RHV9RJ>SXhh>3P26a/K00EEEEE3@d=3@d=3@d<U
9BD00U9BDP06>c/kF5QH;bl_;bl_ATI6;bl_0QlO7`05Hf=S1`L71`L7;Rh^4A4A0093@d<01R4Q8C@d
=9ZJVYZJVP/;2eUIF@8L71`01Bl_;b`/;5YJFUYJFQ8B4P02_kno00HK6a]cLg>/[:b/[:`61PIcLg<2
;2`/00HD51AoOgli>CTi>CTP8215ADD25ADE00EGEeLC4a<C4a=LG5aCDe<00RHV9P06De=C?3`l5ADE
5ADECTi>30`<0XZ:RP052`/;6a/K6a/K;Bd]9RHV008h>3P01UaLG5YJFWmoOgmoOcHf=T];B`9ZJVX0
1FEUIA/K6bPX:2PX:1TI6@027QhN00I6ATIfMWIZJVYZJV[6a/IDE5@2G5aL00EjNWX^;RiOGemOGemP
H6000Xb<S006U9BD6a/KI6ATI6ATF5QHCdm?0P/;2`06EEEEBTY:>c/k>c/k=3@dB4Q80[no_`055aLG
Bd];Bd];SHf=MgMg009lO7`01V][Je=CDhV9RHV9REIFET92@P9SHf<01@D51F1PH10@410@496AT@02
GemO00FRXZ:VYZIQHF5QHF58B4P00oooo`030000oooooooo00goool002;oool01@000?oooooooooo
odI6AP02De=C00Jm_Ke8B4PY:BTY:BVATI4j>SX2?3`l00Dm?Ce>CTi>CTi/K6abLW800RDU9@06C4a<
EEEEJf][Jf][:b/[3Ph>0V1PH006GemO;bl_ADE5ADE5CTi>A4A40T=3@`05FEUI71`LDU9BDU9B=CDe
008k>c/01T92@Rd];AXJ6QXJ6SXj>TY:BP8_;bl01R<S8emOGda<C4a<C2DU9B8R8P9/K6`01EIFEPl?
3hF5QHF5QC@d=002CTi>00HC4a<G5aLN7QhN7Qhk>c/W9bL2:RXZ00IaLG492@UGEeMGEeLb<S99BDT2
4a<C00DD51@=3@e3@d=3@d=SHf<00TY:BP06Kfm_7alOGEeMGEeM?cloHf=S0TY:BP065aLG7QhNH61P
H61PNg]k=SHf0QXJ6P06EeMGIVIV61PH61PH>c/k2@T90UEEE@054A4A20P820P8ATI6JFUY00:l_;`0
1V][JgAdM4U9BDU9BJ:RXS/k>`<`<3001Da<C3hn?Shn?U1@D34a<@02EeMG00FMWIekNg]kNg]RHV8m
?Cd00S/k>`0651@DAdM72`/;2`/;S8b<<C4a0QhN7P06EEEED51@MGEeMGEeWYjNCTi>0RTY:@05ZZZZ
TY:BXJ6QXJ6QTY:B009WIfL01R@T94E5A@h>3Ph>3S8b<QPH6094A4@01EiNG_ooooooooooo`00000^
oooo00@0003ooooooom=CDd2Bd];00Fe]KDn?Shc<c<c<c>9RHT00T=3@`06?Cdm=CDeEEEEEEEELG5a
Ng]k0R4Q8@06CDe=Hf=SH61PH61P9BDU3`l?0UIFEP05GUiN<c<c<c<c>SXjC4a<008f=SH01Sdm?E9B
DQ8B4Q8B4U1@D4=3@`99BDT01E=CDc8b<S8b<QdM7Bl_;`02>SXj00HV9RH[:b]FEUIFEUILG5`[:b/2
5QHF00E^KVi8B4PA4A4A4A5lO7`00RXZ:P06G5aL820P7AdM7AdM8R8RATI60c4a<@05Lg=c410@410@
D51@;bl_009<C4`01@d=3AXJ6QXJ6Q0@44M7A`02HF5Q00I8B4Q^KVhN7QhN7QiMGEe0@402IVIV00E<
C4`H61PH61PO7amMGEd00X61P@06<S8b7AdMDe=CDe=CK6a/4A4A0Shn?P054A4ACTi>3@d=3@d=0000
0090@4001W9bL[jn_V5QHF5QHFe]KCdm?@:_[jl01C<c<c/k>b<S8b<S8dA4A002Bd];00I6ATH[:b]<
C4a<C4bATI61PH42EEEE00Ha<C4e=CDM7AdM7Adn?Sh20P82W9bL00Dc<c<N7QhN7Qi@D51=CDd00X>3
P`06WinODU9B92@T92@TX:2PWYjN0YVIV@05WIfMM7Ad;bl_;bl_B4Q800871`L01BPX:1@D54I6ATI6
AUmOG`03oooo00<0003oooooool03Oooo`008_ooo`800002oooo00EUIFGbl_;bl_9>CTkFe]H00WEe
M@05G5aL1PH6?3`l?3`l820P00:i^KT01WIfMShn?S`l?3`l?10@44=3@`95ADD01T10@6MWIc8b<S8b
<VQXJ4];B`:>SXh01W]kNda<C5UIFEUIFBLW9eADE08I6AT01G1`L1hN7QhN7S<c<dU9B@02@41000I<
C4`/;2aUIFEUIFDi>CUbLW82NWYj00J3Ph<a<C5XJ6QXJ6QZJVY_Kfl2VIVI00E>CTi8B4Q8B4QSHf<n
?Sh00R@T90065aLGF5QHHF5QHF5QRXZ:=CDe0VYZJP06OgmoL71`8b<S8b<SHV9R>3Ph0R`/;005N7Qh
FUYJFUYJ7AdM<30`008f=SH01P<30d=3@e9BDU9BDSXj>SLg=`8?3`l01[no_fIVISDe=CDe=Chn?UmO
G`9@D5001B0P83Xj>WEeMGEeMEmOG`02X:2P00INGUhJ6QXD51@D51B5QHEMGEd2FEUI00I5ADD:2PXo
?clo?cn=SHeTI6@2D51@00DY:BU/K6a/K6a/K6b;Rh/00TU9B@06=SHf?3`lP820P820BDU9<C4a0S@d
=0061`L761PH820P820P=3@dFUYJ0S8b<P06Shn?@4108R8R8R8R?CdmBd];0Te=C@05BDU9HF5QHF5Q
D51@:RXZ008j>SX01FATI79bLTA4A4A4A1`L7002oooo0P0002koool2000000Kooom_Kfo]kNg]kNeF
EUKGemL2O7al00EFEUH=3@d=3@dk>c/M7Ad00[>c/`06OWin>3Ph?3`l?3`l6QXJCDe=0S/k>`05C4a<
IVIV@410@410GEeM0094A4@01Y>CTgAdM4a<C4a<C5mOGaTI6@9IFET01A0@47YjNP`<30`<33hn?P02
FUYJ00H`<30i>CTZ:RXZ:RYADE4f=SH2QHF500IkNg]nOWi7AdM7AdMXJ6QRHV82Ogmo00F6QXIADE5A
DE4g=cMdM7@00R`/;0066a/K:BTYHV9RHV9RDE5AUiNG0RPX:005GUiNRHV9Hf=SHf=S<30`009MGEd0
1TI6ARd];H20P820P65QHAlO7`8Z:RX01CHf=PL71d92@T92@T];B`02=CDe00I2@T8G5aNj^[Zj^[YT
I6@[:b/2ATI600IEEEECDe<M7AdM7Ae6ATI/K6`2GUiN00FJVYYWIfMWIfLE5ADU9BD00WinOP06Cdm?
JFUYF5QHF5QH71`LC4a<0X:2PP05GEeMHV9RHV9R92@TH61P009]KFd01WalO3Lg=c0`<30`<2XZ:WIf
MP9?Cdl01BDU9B<S8`h>3Ph>3Q@D5002:BTY00I2@T9;Bd/j>SXj>SZ9RHTg=cL27alO00He=CDl?3a=
CDe=CDeEEEE_Kfl2EeMG00D/;2``<30`<31QHF5kNg/00S/k>`039BDUoooooooo0080000?oooo000R
oooo00D0003ooooooooooomMGEd00U5AD@06T92@H61PLW9bLW9b410@5QHF0XB4Q005GUiNBd];Bd];
>c/kIFEU008W9bL01Va/K0l?3bTY:BTY:E5ADJ>SX`9OGel01WMgMcHf=X>3Ph>3Pc8b<VYZJP:`/;00
1HN7QcPh>5mOGemOGj^[Z`02@41000I?Cdl];BdQ8B4Q8B4U9BD@4102N7Qh00I5ADE4A4A=CDe=CDdK
6a/m?Cd2O7al00Df=SHX:2PY:BTY:BUaLG400V5QH@06:b/[CTi>8R8R8R8REEEEB4Q80X61P@06A4A4
820PG5aLG5aL[:b/=CDe0T=3@`05IfMWPh>3ADE5ADE5SXj>009>CTh01RHV9V=SHgEeMGEeMEQHF2DU
9@8;2`/01R`/;2d];EIFEUIFES0`<4E5A@:c/k<01S@d=59BDTI6ATI6ARPX:4=3@`8g=cL01C4a<BHV
9RHV9SHf=Q0@400271`L00HO7an:RXY7AdM7AdN0P81GEeL2NGUi00IKFe/S8b<`<30`<30Y:BU2@T82
=CDe00E<C4aCDe=CDe=?Cdm2@T800Slo?`06Bd];<C4a:BTY:BTYJVYZJf][0R@T9006Hf=S6ATIJf][
Jf][IfMW=SHf0U9BDP05GEeMHF5QGEeMGEeM4A4A008d=3@00bHV9U]KFeADE002E5AD00AgMgMfMWIf
MWIeMGD3oooo00<0003oooooool0;?ooo`040000ooooooooEUIF0UYJFP05Vi^KJVYZN7QhN7Qh5QHF
008H61P01WinOV5QHDY:BTY:BSHf=VIVIP8W9bL01Vm_K`l?3bTY:BTY:E1@D:BTY09OGel01GUiNCDe
=CDe=H>3Pc@d=002JFUY00Jd];B4Q8@l?3`l?3aUIFFYZJT2@d=300E>CTh/;2`/;2`T92@Y:BT00PL7
1`06Lg=cC4a<@T92@T92A4A4410@0S/k>`05MgMg@d=37AdM7AdM=cLg009`L7001UaLG2PX:5EEEEEE
EATI6DY:BP94A4@01WYjNSDe=BTY:BTY:EADE;Ng]`8d=3@01Chn?Vm_Kfm_KginOU=CD`02RHV900IN
GUhI6AUMGEeMGEeXJ6QVIVH2=3@d00D20P8j>SXj>SX];Be:BTX00R@T9006>CTi^;Rh?Cdm?CdmCdm?
>c/k0R`/;005D51@;Bd]=3@d=3@d;bl_008a<C401Pl?3bPX:1@D51@D58:2PT10@0:=SHd01EmOGgQh
N55ADE5ADALG5`02>SXj00Hb<S90@40g=cLg=cM0@41MGEd2ATI600Hh>3Q7AdM2@T92@T8e=CDR8R82
GEeM00E^KVha<C4a<C5_KflV9RH00UiNGP06GEeM:b/[B4Q8B4Q8H61PF5QH0UIFEP0530`<>CTi:RXZ
:RXZCdm?009QHF401E5ADH>3Pfe]KFe]KH61P@03oooo00<0003oooooool03Oooo`008_ooo`050000
ooooooooooooGEeM009ADE401Y2@T61PH79bLW9bLQ0@41HF5P:4Q8@01EiNGT];Bd];Bc/k>fEUI@02
9bLW00I/K6`?3`lY:BTY:BUADE6SXj<2GemO00IgMgLf=SJ3Ph>3Ph<b<S9ZJVX2/;2`00F7QhLh>3QO
GemOGen[Zj/00T10@006Cdm?;Bd]8B4Q8B4Q9BDU410@0WQhN006ADE5A4A4CDe=CDe=6a/K?Cdm0Wal
O005=SHf:2PX:BTY:BTYLG5a009QHF401R/[:di>CR8R8R8R8UEEEDQ8B0:1PH401TA4A20P85aLG5aL
G:b/[3De=@93@d<01FMWIh>3PdE5ADE5AHj>SP02CTi>00HV9RISHf=eMGEeMGEHF5PU9BD22`/;00H/
;2`];BeFEUIFEUH`<315ADD2/k>c00Hd=3ABDU96ATI6ATHX:2Q3@d<2=cLg00Da<C4V9RHV9RHf=SH@
41000Q`L70067alORXZ:AdM7AdM7P820EeMG0WUiN@06Fe]K8b<S<30`<30`:BTY@T920SDe=@05C4a<
De=CDe=CCdm?@T92008o?cl01T];Bc4a<BTY:BTY:FYZJV][J`8T92@01V=SHaTI6F][Jf][JfMWIcHf
=P9BDU801EeMGF5QHEeMGEeMGA4A4@02=3@d00<V9RIKFe]DE5@00UADE004MgMgMWIfMWIfMGEe0ooo
o`030000oooooooo02coool010000?oooooooeIFEP9JFUX01I^KVfYZJWQhN7QhN1HF5P0261PH00In
OWiQHF5:BTY:BTXf=SIVIVH29bLW00I_Kfl?3`lY:BTY:BU@D52TY:@2GemO00EiNGTe=CDe=CF3Ph<d
=3@00VUYJ@06];BdQ8B4?3`l?3`lIFEUZJVY0T=3@`05CTi>;2`/;2`/92@T:BTY00871`L01W=cLda<
C492@T92@TA4A10@408k>c/01GMgMd=3@adM7AdM7CLg=`02L71`00ILG5`X:2QEEEEEEEDI6AU:BTX2
A4A400IjNWXe=CDY:BTY:BUDE5Bg]kL2=3@d00Dn?Si_Kfm_KfmnOWiCDe<00XV9R@06GUiN6ATIGEeM
GEeMJ6QXIVIV0S@d=0050P82>SXj>SXj;Bd]BTY:008T92@01STi>KRh^3dm?Cdm?Dm?Cc/k>`8/;2`0
1E1@D2d];C@d=3@d=2l_;`02<C4a00H?3`lX:2PD51@D51B2PX90@402SHf=00EOGemhN7QADE5ADE4G
5aL00SXj>P06<S8b@410=cLg=cLg@410GEeM0TI6AP06>3PhAdM7@T92@T92=CDe8R8R0UeMG@05KVi^
<C4a<C4aKfm_9RHV009NGUh01UeMGB/[:dQ8B4Q8B61PH5QHF09FEUH01@`<33Ti>BXZ:RXZ:Tm?C`02
HF5Q00EADE63Ph=]KFe]KFf1PH400oooo`030000oooooooo00goool002;oool01@000?oooooooooo
oc@d=002Lg=c00HK6a];Bd];Bd];Bd]UIFE;Bd/28B4Q00E_Kfl_;bl_;bm;Bd/M7Ad00Slo?`06DE5A
<C4a00000000PH61?Shn0YjNWP06ATI6JFUY>SXj>SXj6a/K8b<S0V][J`05IfMWHf=S92@T92@T?Cdm
008U9BD01T92@P/;2bDU9BDU9CDe=ALG5`8Y:BT01VQXJ2`/;4A4A4A4A4M7AbXZ:P::RXX01B/[:b0P
85eMGEeMGC0`<002X:2P00IUIFDm?CdR8R8R8R9iNGUADE42:BTY00I[Jf/:2PXo?clo?cm4A4@F5QH2
EUIF00Dj>SY2@T8Q8B4Q8B5@D5000S8b<P06F5QHPh>3BDU9BDU9PX:2FUYJ0TI6AP06:BTY820PJFUY
JFUY;Bd]Bd];0U5AD@06ZZZZ<S8bE5ADE5ADD51@C4a<0WIfMP05FEUICDe=CDe=Fe]KK6a/009_Kfl0
1QPH63/k>eEEEEEEEGQhN59BDP9ADE4012DU9AdM7@h>3Ph>3P9LG5`2@T9200EHF5P@410@410I6ATa
<C400PP82006FEUI>CTiZj^[Zj^[MWIfFe]K0R8R8P06P820Bd];8b<S8b<SPX:2<c<c0S`l?005N7Qh
?3`l>c/k>c/kPh>3008g=cL01VIVIVYZJWinOWinOV5QHG5aL@9<C4`01GemOOooooooooooo`00000^
oooo00@0003ooooooolm?Cd2Ph>300DY:BUOGem<C4a<C4ajNWX00STi>@064A4AH61P?Shn?Shn>SXj
:RXZ0S4a<@06EUIF;bl_4A4A4A4AMgMg;bl_0YJFUP05>CTiFe]KFe]K>CTi5ADE008J6QX2KFe]0UYJ
FP0571`LA4A4:2PX:2PXBTY:008B4Q801R0P82l_;a@D51@D52DU9Fi^KP8];Bd01TQ8B4U9BBh^;Rh^
;X^;Rb`/;08M7Ad01F9RHS4a<C4a<IjNWVQXJ002@d=300HO7amlO7a>CTi>CThQ8B5UIFD220P800E5
ADE>CThB4Q8B4Q9RHV800S0`<006>CTi;2`/ATI6ATI6;bl_I6AT0XF5Q@05A4A4O7alIVIVIVIV?Cdm
008b<S801R/[:emOGbLW9bLW9d];BeYJFP:e]KD01SPh>4a<C5IFEUIFETa<C71`L09JFUX01DQ8B5mO
GemOGg1`L7=cL`026QXJ00@o?cmEEEEjNWYjNWX2DE5A0RDU9@0371`L410@410@009NGUh2@41000IM
GEd>3PhG5aLG5aLh>3P>3Ph2De=C00E0@42YZJU_Kfm_KfmUIFD00R<S8`06QhN7FEUI92@T92@TOGem
>CTi0S<c<`06LW9b=SHf@T92@T92MGEe:RXZ0UiNGP05IVIVQXJ6QXJ6IfMWGemO009DE5@01Fa/K?oo
ooooooooo`00000?oooo000Roooo00D0003ooooooooooolg=cL00/C4a006/K6aMgMg;2`/;2`/UiNG
EUIF0YBDU005=SHf8b<S8b<S<30`>c/k009;Bd/01PL71b/[:c`l?3`l?1<C4bl_;`9TI6@01/C4a8B4
Q9:BTY:BTUEEEA`L708A4A401E=CDa`L73Ti>CTi>E5AD@02>c/k00HZ:RYLG5amOGemOGe;Bd/b<S82
<C4a00H[:b/Z:RXY:BTY:BT^;RiVIVH2;Bd]00E`L725QHFSXj>SXj=^KVh00W9bLP06Q8B4@D51ATI6
ATI68B4Q<C4a0TA4A006K6a/<30`6a/K6a/K@D51OWin0WEeM@05;2`/Cdm?9BDU9BDU>c/k009FEUH0
1Ti>CR8R8R4Q8B4Q8GQhN24Q8@8m?Cd01S0`<8n?SaPH61PH66UYJDm?C`9=CDd01SLg=c/k>fi^KVi^
KQlO7b/[:`9MGEd01FEUII6ATI6ATEiNGRl_;`02?clo00J>SXi:BTZTY:BTY:A>CThj>SX2<S8b00BC
Ti=dM7ATI6ATI6@2MGEe0T10@005@T924A4A4A4A820PShn?009NGUh01UMGEeeMGGYjNWYjNU]KFda<
C08U9BD01WinOZBTY6e]KFe]KGalO:f][@:BTY801Clo?fATI7UiNGUiNFm_K`02>3Ph00IcLg<T92AZ
JVYZJVXc<c?YjNT2De=C00FKVi_oooooooooool00000;_ooo`040000oooooooo:b/[0][JfP05WinO
QhN76ATI6ATIWinO009TI6@01X:2PR8R8S8b<S8b<R4Q8E1@D08g=cL01Q<C4adM7Dm?Cdm?C`410C8b
<P9]KFd01K^k^hf=SHf=SH>3Pe]KF`02:BTY00HE5AE3@d<A4A4A4A4_;bm3@d<2@41000Da<C5EEEEE
EEEkNg]1@D400Rh^;P06>CTi8b<S<S8b<S8b:BTY;Bd]0V][J`05<30`MGEePh>3Ph>3Z:RX009]KFd0
1W9bLXJ6QTA4A4A4A4M7AbDU9@8e=CD01T10@6i^KR`/;2`/;1XJ6TQ8B09lO7`01GinOR`/;2`/;5AD
E1lO7`02@T9200IEEEEJFUX^;Rh^;RhG5aM]KFd2;Rh^00E:BTXT92@T92BLW9`B4Q800UeMG@06B4Q8
De=C?Cdm?Cdm;Rh^I6AT0R`/;0058B4QGUiNFe]KFe]KTI6A009TI6@01STi>D];Bhf=SHf=SD51@JVY
Z@98B4P01D51@B/[:hb<S8b<S7emO@02GUiN00I_KfmjNWY1@D51@D56ATH:2PX29bLW00J>SXiUIFEC
De=CDe=PH61iNGT2GemO00EDE5@N7QhN7QimOGf_[jl00VEUI@06R8R8]KFeR8R8R8R8?ShnM7Ad0Wal
O005HF5Q=SHfHf=SHf=S51@D009fMWH01Chn?]WIfEYJFUYJFX^;R`03oooo00<0003oooooool03Ooo
o`004Oooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo00;oool01@000?oooooooooo
obh^;P02];Bd00JYZJUdM7AgMgMgMgMWIfL;2`/26QXJ00Dn?Sja/K6a/K4U9BE]KFd00Z2PX0063`l?
;2`/@410@4106a/KFe]K0Y^KV`06ZJVY7alOCdm?Cdm?HF5Q5aLG0QdM7@05=3@d@D5192@T92@TI6AT
009;Bd/01R8R8S4a<Jf][Jf][CDe=GemO@9dM7@01V9RHRh^;QXJ6QXJ6PX:2RTY:@90@4001EiNGSLg
=a/K6a/K6e9BDP02:BTY00Hj>SY;Bd]UIFEUIFEEEED`<3028B4Q00I6ATHH61Pa<C4a<C4Z:RXJ6QX2
Fe]K00D61PH;2`/V9RHV9RI0@4000Shn?P06=cLg>c/kGemOGemO;Rh^6QXJ0UQHF0063@d=WYjNADE5
ADE5>c/k9BDU0PX:2P069bLW820PN7QhN7QhAdM7Cdm?0S0`<005820PKfm_Kfm_BTY:Lg=c0093@d<0
1UUIFEYJFR/[:b/[:fYZJRTY:@8P82001WemOClo?gUiNGUiNE=CDjZZZP9QHF401AdM7Cdm?Cdm?F][
JcXj>P02AdM700IeMGEWIfMMGEeMGEeTI6AWIfL3N7Qh00E0@40j>SXj>SZCTi=aLG400U1@D005FUYJ
Kfm_BTY:BTY:B4Q8009KFe/01Shn?QXJ6UMGEeMGEaTI6BPX:0:d];@01B4Q8Oooooooooooo`00000M
oooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`040000oooooooo;Rh^0[Jf
]P05ZZZZMWIfNGUiNGUiJVYZ008>3Ph01Q`L73`l?:n_[jn_[bPX:6YZJP:PX:001Q0@42LW9dM7AdM7
Ab4Q8E]KF`:FUYH01K>c/bLW9bLW9dm?CfIVIP0261PH00HV9RHd=3@j>SXj>SX];BeLG5`2AdM700DM
7Adi>CTi>CVVYZH`<3000WalO006Kfm_Hf=S<S8b<S8b4a<C1@D50R/[:`05AdM7HV9R>c/k>c/k5QHF
009?Cdl01RTY:CXj>Tm?Cdm?CfQXJ5UIF@8];Bd01R@T94E5AAHF5QHF5S0`<2/[:`8M7Ad01EiNGPL7
1`L71`X:2RXZ:P02?Shn00I2@T8g=cLi>CTi>CUKFe/Y:BT261PH00EPH6092@T92@VRXZ95ADD00T92
@P0671`L3@d=<30`<30`6QXJMWIf0Sdm?@05B4Q89BDU92@T92@TJ6QX009GEeL01WmoOe5ADEYJFUYJ
FTm?CbTY:@9iNGT01B<S8aXJ6WIfMWIfMTY:BP02KFe]00I>CTjQXJ5`L71`L70B4Q94A4@2GemO00H_
;blk>c]gMgMgMgMZJVYYJFT2HV9R00EcLg=`L71`L723Ph=2@T800S8b<P06W9bLNGUiBTY:BTY:G5aL
Jf][0TE5A@05@d=3HF5Q?Cdm?Cdm6ATI009DE5@01ATI6BTY:KRh^;Rh^28R8P03oooo00<0003ooooo
ool03Oooo`004oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003oooo00D0
003oooooooooool^;Rh00[Bd]006ZJVYM7AdMgMgMgMgIfMW2`/;0QXJ6P05?Shn/K6a/K6a9BDUKFe]
00:PX:001Pl?3b`/;410@410@1/K6e]KF`:KVi/01ZVYZAlO7dm?Cdm?Cf5QHALG5`8M7Ad01C@d=451
@B@T92@T96ATI002Bd];00HR8R8a<C6][Jf][Jde=CEmOGd2M7Ad00IRHV8^;RhJ6QXJ6QX:2PXY:BT2
@41000ENGUhg=cLK6a/K6a]BDU800RTY:@06>SXjBd];IFEUIFEUEEEE<30`0R4Q8@06ATI661PH<C4a
<C4a:RXZ6QXJ0U]KF`051PH62`/;9RHV9RHV@410008n?Sh01SLg=c/k>emOGemOGbh^;QXJ6P9HF5P0
1Pd=3IjNWTE5ADE5AC/k>bDU9@8:2PX01RLW9b0P87QhN7QhN4M7Adm?C`8`<3001B0P86m_Kfm_KdY:
BW=cL`02@d=300IIFEUJFUX[:b/[:b]ZJVXY:BT2820P00ImOGdo?cmiNGUiNGUCDe>ZZZX2HF5Q00DM
7Adm?Cdm?Ce[Jf/j>SX00TM7A`06MGEeIfMWGEeMGEeMI6ATIfMW0gQhN005@410>SXj>SXjTi>CLG5a
009@D5001EYJFVm_KdY:BTY:BTQ8B002Fe]K00Hn?ShJ6QYGEeMGEeLI6ATX:2P2];Bd00DQ8B7ooooo
ooooool000007oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003oooo00@0
003oooooool^;Rh2][Jf00FZZZYfMWIiNGUiNGUZJVX00Ph>3P0671`L?3`l[jn_[jn_:2PXJVYZ0Z2P
X006410@9bLWAdM7AdM78B4QFe]K0YJFUP05/k>c9bLW9bLWCdm?IVIV008H61P01RHV9S@d=3Xj>SXj
>Rd];EaLG097AdL01AdM7CTi>CTi>JJVYS0`<002O7al00I_KfmSHf<b<S8b<S8C4a<51@D2:b/[00E7
AdMRHV8k>c/k>c/F5QH00Tm?C`06:BTY>SXjCdm?Cdm?J6QXFEUI0Rd];@0692@TADE55QHF5QHF<30`
:b/[0QdM7@05GUiN1`L71`L72PX::RXZ008n?Sh01T92@SLg=cTi>CTi>E]KFbTY:@8H61P01F1PH0T9
2@T92J:RXTE5A@02@T9200HL71`=3@d`<30`<30J6QYfMWH2?Cdm00E8B4PU9BDT92@T92AXJ6P00UMG
E`06OgmoDE5AFUYJFUYJCdm?:BTY0WUiN@058b<S6QXJMWIfMWIfBTY:009]KFd01Ti>CZ6QXG1`L71`
L18B4TA4A09OGel01Rl_;c/k>gMgMgMgMfYZJVUYJ@9RHV801G=cLg1`L71`L8>3Pd92@P02<S8b00JL
W9aiNGU:BTY:BTYLG5a[Jf/2ADE500E3@d=QHF4m?Cdm?CdI6AT00UADE0056ATI:BTY^;Rh^;Rh8R8R
00?oool00`000?ooooooo`0=oooo000Coooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000?oool200000_ooo`05Lg=cooooooooFEUI5ADE009gMgL01D10@8b<S1XJ6QXJ6T=3@`02
V9RH00HW9bLc<c>l_;bl_;aiNGV>SXh2=CDe00I3@d<h>3QLG5aLG5`[:b/Y:BT26QXJ00HO7alA4A4O
7alO7alS8b=4A4@24A4A00Dm?CdQ8B4Q8B4n?SiFEUH00QdM7@06DU9BF5QH=cLg=cLg=3@d?Cdm0Ta<
C0064a<C=CDeGUiNGUiN@d=3AdM70R/[:`05B4Q8;2`/;2`/AdM7;Bd]008i>CT01UYJFTm?Ca8B4Q8B
4S4a<APH609GEeL01T10@4Y:BT92@T92@S`l?1`L708E5AD01B0P85eMGEeMGDY:BUEEE@02FEUI00I2
@T9ZJVYCDe=CDe<c<c=ADE42N7Qh00Hd=3@h>3Pj>SXj>SY/K6aTI6@2IfMW00Fc/k=bLW8O7alO7alI
6AT00gMgM`05:2PX<30`<30`Hf=S?3`l008J6QX01SLg=hn?Sh20P820P0`<36YZJP9@D5001G9bLP/;
2dA4A4A4A38b<P02OGem00H[:b]iNGUjNWYjNWYaLG5CDe<2Ogmo00I>CThP821OGemOGemnOWhY:BT2
OWin00I:BTYDE5@B4Q8B4Q8c<c<@4102BDU900Dd=3A>CTi>CThH61Q[Jf/00VQXJ005OGemBDU9IFEU
IFEUQhN700;oool200007oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003
oooo0P000006ooooKVi^ooooooooDU9B5QHF0Vi^KP05>CTiPh>3Ph>3410@CTi>00:PX:001S0`<2XZ
:/G5aLG5aHB4Q8b<S08o?cl01Cdm?C@d=5]KFe]KFbHV9P02:b/[00HG5aLK6a/:2PX:2PXV9RHR8R82
ADE500DH61Pk>c/J6QXJ6QXj>SX00UeMG@068b<SBTY:EEEEEEEE=cLg;bl_0dM7A`054Q8B<S8b<S8b
HF5QCDe=0092@T801Bl_;dU9BDU9BB<S8d=3@`02;bl_00Hj>SYQHF59BDU9BDT92@T];Bd24A4A00E@
D513@d=6ATI6ATI8B4P00T92@P067QhN5aLG9BDU9BDUHF5QBDU90UUIF@05G5aL@D51K6a/K6a/De=C
008d=3@01U9BDW]kNcHf=SHf=S`l?3Hf=P9aLG401VQXJ6][Jjn_[jn_[fa/K1hN7P8F5QH01G1`L8:2
PX:2PS4a<CPh>002J6QX00A5ADDQ8B55ADE5ADD2Shn?0PD51@05MGEeADE5ADE5Hf=S20P8008i>CT0
1T=3@gEeMBTY:BTY:G=cLfUYJ@9VIVH01DQ8B820P59BDU9BDRh^;P02Cdm?00J<S8`g=cMiNGUiNGUK
Fe]NGUh20P8200Ho?clL71aIFEUIFETS8b=6ATH24a<C00EQHF5eMGEeMGEaLG56ATH00UaLG003NWYj
oooooooo0080000?oooo000Coooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00?oool01@000?oooooooooooc/k>`02oooo00IFEUI;Bd]EEEEEEEEoOglQ8B42HF5Q00DU9BE/K6a/
K6b@T90i>CT00S8b<P06S8b<NGUi8R8R8R8R;2`/5aLG0TU9B@06FEUI5QHF;2`/;2`/G5aL8B4Q0S0`
<005Cdm??3`lSXj>SXj>DE5A008o?cl01XJ6QQdM7FQXJ6QXJ3@d=6UYJ@9VIVH01UmOGe]KFclo?clo
?fa/K5eMG@8];Bd01C0`<1@D51`L71`L75MGE`02GUiN00J1PH4Y:BU/K6a/K6a?CdmVIVH2<c<c00IY
JFT>3PiNGUiNGUho?cmgMgL28R8R00ECDe<g=cM;Bd];Bd/_;bl00VMWI`06=cLg820PNWYjNWYj=3@d
>SXj0S`l?006AdM7Q8B4:b/[:b/[@d=3Lg=c0RTY:@068b<SJf][JFUYJFUYOWinI6AT0R<S8`05=cLg
=SHf=SHf@T92DU9B008l?3`01TI6AWUiNBHV9RHV9VUYJE1@D09=CDd01[^k^eYJFWQhN7QhN9:BTWMg
M`9TI6@01C4a<EeMGEeMGF5QHD92@P02QHF500IMGEe/K6a`L71`L70K6a]0@4027AdM00J5QHEFEUI;
Bd];Bd]PH618B4P2IVIV00ETI6A[Jf^?Shn?Shli>CT00UeMG@068B4QLW9b2PX:2PX:BTY:T92@0RXZ
:P05`/;2oooooooooooo000001ooool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00000oooo`040000oooooooo=3@d0_ooo`05GemOATI6C4a<C4a<N7Qh008H61P01UUIFB0P86=SHf=S
HiBDU3<c<`8X:2P01XV9RFm_Kb0P820P82`/;2<S8`91@D401Di>CR8R8R8R8QlO7eiNGP026ATI00HV
9RI<C4`d=3@d=3BEUIE7AdL2@d=300F<S8`O7alO7am^KVi0@4000VATI006Lg=cJ6QXD51@D51@?Cdm
LW9b0UADE005:2PX<C4a7AdM7AdM8b<S009DE5@01VQXJ7UiNBTY:BTY:GIfMTY:BP9NGUh01SPh>65Q
H@T92@T92EaLG4U9B@9fMWH01BLW9eQHF5QHF3<c<dQ8B002:2PX00I_Kflf=SHR8R8R8R:1PH4_;bl2
=cLg00Df=SI3@d=3@d>3Ph<b<S800TY:BP06KVi^;Rh^:b/[:b/[LW9bJf][0WYjNP05IFEU9RHV<30`
<30`>CTi0095ADD01UaLG3`l?51@D51@D820P2DU9@9RHV801Di>CU9BD[fm_Kfm_F=SH`02M7Ad00JA
TI5mOGePH61PH60Z:RYQHF42IFEU00I;Bd]nOWiHF5QHF5QYJFU[Jf/28B4Q00E1@D4Q8B4Q8B5oOgmF
EUH00U1@D006JFUYDE5AIFEUIFEUHf=SM7Ad0Y>CT`05>3PhEUIF9bLW9bLWN7Qh008<30`01E5ADH^;
Rc4a<C4a<L?3``03oooo00<0003oooooool03Oooo`004oooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`000003oooo00D0003ooooooooooolk>c/00_ooo`06EUIFBd];EEEEEEEEOgmo
8B4Q0V5QH@059BDUK6a/K6a/T92@>CTi008b<S801Xb<S7UiNB8R8R8R8R`/;1LG5`99BDT01UUIFAHF
5R`/;2`/;5aLG24Q8@8`<3001Dm?Cc`l?8j>SXj>SU5AD@02?clo00J6QXHM7AeXJ6QXJ6Pd=3AYJFT2
IVIV00IOGemKFe/o?clo?cm/K6aMGEd2;Bd]00D`<30D51@L71`L71aGEeL00UiNGP06PH61:BTYK6a/
K6a/Cdm?IVIV0S<c<`06JFUY3Ph>GUiNGUiN?cloMgMg0R8R8P05De=C=cLgBd];Bd];;bl_009WIfL0
1SLg=b0P87YjNWYjNS@d=3Xj>P8l?3`01TM7AhB4Q2/[:b/[:d=3@g=cL`8Y:BT01R<S8f][JfUYJFUY
JGinOVATI08S8b<01CLg=cHf=SHf=T92@U9BDP02?3`l00I6ATIiNGTV9RHV9RIYJFU@D502CDe=00Jk
^k]JFUYhN7QhN7RBTY9gMgL2I6AT00Da<C5MGEeMGEeQHF52@T800XF5Q@06GEeMK6a/L71`L71`6a/K
@4100QdM7@06QHF5EUIFBd];Bd];H61PB4Q80VIVIP05I6ATJf][Shn?Shn?>CTi009MGEd01R4Q8G9b
LPX:2PX:2TY:BY2@T08Z:RX01L;2`_ooooooooooo`00000Ooooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000000?oool010000?oooooooc@d=0;oool01EmOGdI6ATa<C4a<C7QhN002
61PH00IIFETP821SHf=SHf>DU9@c<c<2:2PX00J9RHU_KflP820P820/;2`S8b<2@D5100E>CThR8R8R
8R8O7amNGUh00QTI6@069RHVC4a<=3@d=3@dUIFEAdM70T=3@`05S8b<7alO7alOKVi^@410009TI6@0
1W=cLfQXJ51@D51@D3dm?G9bLP9DE5@01BPX:34a<AdM7AdM7B<S8`02E5AD00IXJ6QiNGTY:BTY:BUf
MWI:BTX2GUiN00Hh>3QQHF492@T92@ULG5a9BDT2MWIf00DW9bMHF5QHF5Pc<c=8B4P00RPX:006Kfm_
=SHf8R8R8R8RPH61;bl_0SLg=`05=SHf@d=3@d=3Ph>3<S8b009:BTX01Vi^KRh^;R/[:b/[:g9bLV][
J`9jNWX01FEUIBHV9S0`<30`<3Ti>@02ADE500ILG5`l?3a@D51@D520P80U9BD2HV9R00E>CTiBDU:m
_Kfm_KeSHf<00WAdM006TI6AOGemH61PH61P:RXZHF5Q0VEUI@06Bd];OWinF5QHF5QHJFUYJf][0R4Q
8@05@D518B4Q8B4QOgmoEUIF009@D5001VUYJE5ADFEUIFEUIF=SHgAdM0:CTi<01CPh>5IFERLW9bLW
9gQhN00230`<00EADE6;Rh/a<C4a<C73`l<00oooo`030000oooooooo00goool001;oool200001?oo
o`030000oooooooo00;oool00`000?ooooooo`02oooo00D0003ooooooooooombLW800_ooo`065QHF
aLG5QhN7QhN7BDU94Q8B0STi>@05Hf=SBTY:BTY:L71`4A4A00:DU9@01TM7AijNWXn?Shn?Sa8B4S@d
=098B4P01S@d=5=CDfMWIfMWIeUIFC/k>`8J6QX01G5aLAXJ6UUIFEUIFDa<C002EUIF00I]KFeHF5Q/
K6a/K6a>CThk>c/2TI6A00I]KFfDU9@O7alO7alW9bLf=SH2C4a<00D`<30_;bmGEeMGEeLo?cl00YnO
W`06=3@d>3PhSXj>SXj>?Shn;bl_0Pl?3`06=cLgB4Q8<C4a<C4aJVYZ8b<S0R8R8P05B4Q8<30`NWYj
NWYj7alO009BDU801VATI7moOgYjNWYjNWmoOginOP:/[:`01U5ADDM7Ab@T92@T93Ph>4M7A`8d=3@0
1RHV9Shn?R/[:b/[:`/;2e1@D08V9RH01Dm?Cfi^KVi^KSPh>24Q8@02;bl_00I@D51=CDda<C4a<C5e
MGDK6a/2HV9R00J4Q8@h>3PR8R8R8R8X:2Q1@D42410@00E`L72m_Kfm_Ke^KVhc<c<00VIVIP06DE5A
<c<cHF5QHF5Q>3PhEeMG0R<S8`06D51@KFe]61PH61PH8B4Q3`l?0WemO@05=3@d@T92PX:2PX:2O7al
00:/[:`01U1@D2TY:EQHF5QHF2h^;T];B`8=3@d01NGUiOooooooooooo`00000Noooo0P0000Coool0
0`000?ooooooo`02oooo00<0003oooooool00_ooo`040000ooooooooRHV90_ooo`05410@/k>cPX:2
PX:2<S8b00871`L01R<S8e9BDTi>CTi>CX61P@P820::RXX01TQ8B9>CThN7QhN7QbHV9Rh^;P8l?3`0
1B`/;4=3@d=3@eeMGFYZJP02?Cdm00H;2`][Jf/W9bLW9bM>CTi8B4P2Hf=S00EaLG5DE5ADE5AfMWI6
ATH00T10@006VYZJJf][SXj>SXj>:2PX8R8R0SLg=`05Bd];<S8b:b/[:b/[G5aL008h>3P01YRHV3<c
<c4a<C4a<IZJVTU9B@8V9RH01Pd=3C0`<5=CDe=CDb/[:gEeM@8M7Ad01AHF5T];Bd];Bbd];G5aL@02
4Q8B00I7AdMKFe^:RXZ:RXYbLW9mOGd2RHV900FPX:1FEUIFEUHo?clU9BD00Rh^;P06?3`l9RHV;bl_
;bl_>c/k7alO0QTI6@05GUiN6ATIBTY:BTY:M7Ad0096ATH01RHV9Sdm?EaLG5aLG59BDRXZ:P9^KVh0
1BHV9UUIFGIfMWIfMT51@@026a/K00H/;2`a<C4C4a<C4a=QHF7:b/X2LG5a00Dj>SYLG5aMGEeMGEe6
ATH00di>CP05EEEE9bLW9bLWEeMGFUYJ008@41001Q8B4R8R8XB4Q8B4Q20P85EEE@9/K6`01Fe]KIjN
WUYJFUYJFT=3@`02GUiN00DF5QI0@40Q8B4Q8B7inOT00oooo`030000oooooooo00goool002;oool0
0`000?ooooooo`02oooo0[jn_P06OGemG5aLM7AdM7AdDU9BGEeM0PX:2P0571`LPX:2PX:22@T9OGem
00:<S8`01V=SHf9RHRh^;Rh^;W9bLPl?3`9?Cdl01VYZJQTI6EADE5ADE6i^KWYjNP8R8R801@T92AlO
7eQHF5QHF3Hf=P02;2`/00IVIVHe=CEnOWinOWi3@d<l?3`2>3Ph00IWIfNWYjLa<C4a<C53@d=;Bd/2
;Bd]00ESHf<[:b]5ADE5ADDo?cl00VATI006G5aLJVYZJ6QXJ6QXLG5aRXZ:0XN7Q`05HV9RATI6:2PX
:2PXTY:B00=4A4@01Fe]KC`l?1`L71`L7492@P02OWin00Hi>CU3@d=hN7QhN7RMWIdU9BD27alO00HS
8b<X:2PB4Q8B4Q8b<S9bLW827alO00IVIVI/K6`l?3`l?3`g=cM6ATH2PX:200Dh>3QUIFEUIFDI6AU?
Cdl00PH61P065QHF9bLW:2PX:2PXPh>3H61P0Rh^;P062PX:>c/k4A4A4A4A:2PXNWYj0Shn?P059RHV
HF5QHF5QNGUiUYJF008c<c<01TA4A6EUIBPX:2PX:0410Hb<S09QHF401Y>CTb@T95eMGEeMGALG5cPh
>09EEED01BLW9iFEU@T92@T92E1@D002cLg=00HZ:RXg=cLE5ADE5ADR8R;Kfm/2Lg=c00Fe]KGooooo
ooooool00000;_ooo`040000oooooooooooo0[^k^`05NGUiEeMGM7AdM7AdEeMG009QHF401PT92AhN
7XN7QhN7Q`P827alO0:?Shl01V=SHfATI2l_;bl_;gEeMA0@409ADE401Fi^KQ/K6a/K6eQHF6a/K002
MgMg00HN7Qh<30`N7QhN7QiOGeld=3@29RHV00ESHf<k>c/k>c^3Ph=3@d<00S`l?006@410H61P[Zj^
[Zj^>CTiBDU90Te=C@05<c<cFUYJ;Rh^;Rh^@D510096ATH01UeMGE=CDgIfMWIfMVm_Kg5aL@:FUYH0
1WmoOfATI59BDU9BDRPX:92@T095ADD01Cdm?FYZJVYZJTY:BQ@D5002=cLg00IjNWX_;blf=SHf=SI[
Jf^HV9P28R8R00D^;RhQ8B4Q8B4d=3@<30`00STi>@06Hf=S:2PXIVIVIVIVG5aL<C4a0TQ8B005De=C
LG5a:BTY:BTYMWIf008:2PX01TQ8B1TI6@L71`L71b`/;3Xj>P9aLG401GEeMA/K6`l?3`l?3bPX:002
8b<S00Hl?3aXJ6Q8B4Q8B4PJ6QYJFUX2S8b<00J6QXHY:BU6ATI6ATIQHF4X:2P2410@00FDU9AHF5QH
F5RUYJDG5aL00UeMG@067alO>SXjEEEEEEEE;bl_RXZ:0PX:2P05A4A4`l?3=SHf=SHf;Bd]00<M7Ad0
1=CDe7inOWinO[bl_0?oool00`000?ooooooo`0=oooo000Roooo00D0003oooooooooooofm_H00[fm
_@06UYJFEeMGfm_Kfm_KO7alJFUY0U=CD`05bLW9OgmoOgmoSHf=?3`l009[Jf/01RLW9gAdM9NGUiNG
Udm?Cd51@@9KFe/01QDE5Clo?e]KFe]KFi2@T7MgM`:TY:@01GemOCXj>UYJFUYJFV1PH002M7Ad00IR
HV9BDU9bLW9bLW8Z:RXY:BT2OGem00H^;RhQ8B54A4A4A4AXJ6PC4a<2QXJ600Dh>3Pn?Sho?clo?clb
<S800Slo?`06EEEE=CDeF5QHF5QHSHf=P8200R8R8P06DE5AalO7EUIFEUIF6a/K7alO0UiNGP8T92@2
4a<C00EBDU9MGEeMGEd`<30X:2P00/_;b`063@d=BTY:FUYJFUYJ:2PXE5AD0Ph>3P06KVi^Bd];De=C
De=C0@4130`<0SHf=P05<C4aADE5LG5aLG5aFUYJ008820P01UUIFDU9BE]KFe]KFemOG`l?3`9PH600
1Tm?Ca/K6b`/;2`/;3Hf=Sdm?@8[:b/01@<30clo?bh^;Rh^;T51@@02L71`00I8B4PZ:RYfMWIfMWHl
?3`T92@2I6AT00HY:BUdM7@[:b/[:b^FUYJHV9P2MWIf00J;Rh]`L724Q8B4Q8@Q8B5YJFT27alO00DA
4A5/K6a/K6`i>CTZ:RX00V][J`05DE5A<S8bSXj>SXj>bLW900?oool00`000?ooooooo`0/oooo00@0
003ooooooooShn<2gMgM00Fc/k=JFU[=cLg=cLeZJVX00V5QH@06=3@d^k^kJf][Jf][LG5aEEEE0VQX
J0065QHFF5QHNg]kNg]kJ6QX?Shn0U5AD@05:b/[EEEEEEEEDe=CUYJF009OGel01Xf=SI>CTbd];Bd]
;EmOGg=cL`9SHf<01EUIFF=SHf=SHfATI3De=@026QXJ00J>SXh/;2`J6QXJ6QY8B4QbLW8220P800F0
P80o?clf=SHf=SI4A4@00S8b<P06A4A4DU9B>SXj>SXjFe]KSHf=0X20P0068b<SDe=CalO7alO7FEUI
6ATI0R0P8005H61P9bLW9bLW:BTY5ADE009DE5@01UUIFC0`<34a<C4a<Lg=cAHF5P9>CTh01FEUIBPX
:2PX:5UIF@h>3P02JVYZ00IBDU9HF5P<30`<30`@410m?Cd2>3Ph00E3@d=ZJVY>CTi>CTh<30`00V9R
HP06?3`lD51@DU9BDU9B4Q8BEEEE0UUIF@053`l?7alOAdM7AdM7=CDe008P82001Q@D530`<1dM7AdM
7EADE61PH08f=SH01QLG5fATI3Ti>CTi>CPh>65QH@8m?Cd01HR8R3/k>c/k>ijNWXZ:RP02GemO00Ij
NWYHF5Q/K6a/K6`I6AUcLg<25QHF00DV9RJ:RXY9BDU9BDTd=3@00U]KF`05Kfm_:BTYW9bLW9bLbl_;
00?oool00`000?ooooooo`0=oooo000Roooo00D0003oooooooooooofm_H00[fm_@06UYJFEeMGfm_K
fm_KO7alJFUY0U=CD`05bLW9OgmoOgmoSHf=?3`l009[Jf/01RLW9gAdM9NGUiNGUdm?Cd51@@9KFe/0
1QDE5Clo?e]KFe]KFi2@T7MgM`:TY:@01GemOCXj>UYJFUYJFV1PH002M7Ad00IRHV9BDU9bLW9bLW8Z
:RXY:BT2OGem00H^;RhQ8B54A4A4A4AXJ6PC4a<2QXJ600Dh>3Pn?Sho?clo?clb<S800Slo?`06EEEE
=CDeF5QHF5QHSHf=P8200R8R8P06DE5AalO7EUIFEUIF6a/K7alO0UiNGP8T92@24a<C00EBDU9MGEeM
GEd`<30X:2P00/_;b`063@d=BTY:FUYJFUYJ:2PXE5AD0Ph>3P06KVi^Bd];De=CDe=C0@4130`<0SHf
=P05<C4aADE5LG5aLG5aFUYJ008820P01UUIFDU9BE]KFe]KFemOG`l?3`9PH6001Tm?Ca/K6b`/;2`/
;3Hf=Sdm?@8[:b/01@<30clo?bh^;Rh^;T51@@02L71`00I8B4PZ:RYfMWIfMWHl?3`T92@2I6AT00HY
:BUdM7@[:b/[:b^FUYJHV9P2MWIf00J;Rh]`L724Q8B4Q8@Q8B5YJFT27alO00DA4A5/K6a/K6`i>CTZ
:RX00V][J`05DE5A<S8bSXj>SXj>bLW900?oool00`000?ooooooo`0/oooo00@0003ooooooooShn<2
gMgM00Fc/k=JFU[=cLg=cLeZJVX00V5QH@06=3@d^k^kJf][Jf][LG5aEEEE0VQXJ0065QHFF5QHNg]k
Ng]kJ6QX?Shn0U5AD@05:b/[EEEEEEEEDe=CUYJF009OGel01Xf=SI>CTbd];Bd];EmOGg=cL`9SHf<0
1EUIFF=SHf=SHfATI3De=@026QXJ00J>SXh/;2`J6QXJ6QY8B4QbLW8220P800F0P80o?clf=SHf=SI4
A4@00S8b<P06A4A4DU9B>SXj>SXjFe]KSHf=0X20P0068b<SDe=CalO7alO7FEUI6ATI0R0P8005H61P
9bLW9bLW:BTY5ADE009DE5@01UUIFC0`<34a<C4a<Lg=cAHF5P9>CTh01FEUIBPX:2PX:5UIF@h>3P02
JVYZ00IBDU9HF5P<30`<30`@410m?Cd2>3Ph00E3@d=ZJVY>CTi>CTh<30`00V9RHP06?3`lD51@DU9B
DU9B4Q8BEEEE0UUIF@053`l?7alOAdM7AdM7=CDe008P82001Q@D530`<1dM7AdM7EADE61PH08f=SH0
1QLG5fATI3Ti>CTi>CPh>65QH@8m?Cd01HR8R3/k>c/k>ijNWXZ:RP02GemO00IjNWYHF5Q/K6a/K6`I
6AUcLg<25QHF00DV9RJ:RXY9BDU9BDTd=3@00U]KF`05Kfm_:BTYW9bLW9bLbl_;00?oool00`000?oo
ooooo`0=oooo000Roooo0P0000;oool01NCTi;Bd];Bd]5iNGU]KF`02/K6a00E;Bd]UIFEJFUYJFUY]
KFd00]kNgP06?clo^[ZjEEEEEEEEDU9B[Zj^0U5AD@06H61P9BDUShn?Shn?>3PhAdM70RHV9P06?Cdm
GemOD51@D51@WinO4A4A0U=CD`<j>SX01XJ6QQHF5P@410@414M7AcDe=@:SXj<01Sdm?FMWIfYZJVYZ
JTI6AR0P808n?Sh01@T92A<C4fQXJ6QXJ2TY:@025ADE00He=CEgMgN8R8R8R8Q9BDVe]KD2VIVI00I7
AdMDE5A3@d=3@d=FEUIJFUX26ATI00F6QXI5ADFGUiNGUiL_;bl00S`l?0066a/K;Rh^>SXj>SXj4A4A
?clo0Y6AT@06JFUYGemO8B4Q8B4Q1PH6@T920U1@D006JVYZA4A4?Shn?ShnKFe]9BDU0TY:BP05UYJF
De=CDe=CGemO1`L7009nOWh01R8R8S0`<3Hf=SHf=TQ8B6ATI08j>SX01W=cLbHV9VATI6ATI1TI6B8R
8P8@41001C0`<2<S8b<S8b0P83`l?002LG5a00I8B4QEEEFGUiNGUiLI6AT>3Ph2BTY:00HF5QJATI73
`l?3`l>3Ph=iNGT2]kNg00E4A4ABDU9TI6ATI6AhN7P00/O7a`06PH61=CDe^;Rh^;RhE5AD?3`l0Shn
?P03Ng]koooooooo0080000^oooo0P000006oooog]kNf][Jf][JQHF5EUIF0YRHV005B4Q8Fe]KFe]K
Kfm_C4a<00;0`<001U9BDZf][C/k>c/k>f][JiBDU08j>SX01DM7Ac0`<7UiNGUiNDi>CP02?Cdm00HR
8R9?CdmADE5ADE51@D6/[:`251@D00ENGUi5ADDh>3Ph>3R5QHD00QHF5P060`<3A4A4>CTi>CTiYJFU
?3`l0VIVIP06K6a/@d=36QXJ6QXJADE500000Q/K6`05IVIV:b/[:b/[61PH;Bd]00:4Q8@01WinOUYJ
FZf][Jf][JZZZSPh>093@d<01CHf=TU9BEEEEEEEEBDU9@02Ogmo00I7AdNLW9`O7alO7am?CdlU9BD2
@D5100Do?cl10@4k>c/k>c^LW9`00WEeM@06DE5A71`L1PH61PH6?CdmFe]K0Vi^KP06ATI6A4A4LW9b
LW9b:BTYAdM70YBDU005EUIFHF5QHF5Q1PH6Ogmo008P82001S8b<S0`<4e=CDe=CF][Jd92@P9jNWX0
1Bh^;Vm_Kfm_K`l?3a8B4P0230`<00HS8b<O7al;2`/;2`/T92AHF5P2B4Q800EPH62SXj<J6QXJ6QXV
9RH00TI6AP0671`LPH61XZ:RXZ:RLG5aEEEE0Y>CT`06F5QHBDU9G5aLG5aLLG5ac/k>0WinOP05<c<c
ZZZZZZZZ<S8b5ADE009<C4`00j>SXoooooooo`0200003oooo`008_ooo`050000ooooooooooooBd];
009VIVH01Ta<C6IVIWYjNWYjNU1@D4M7A`9ZJVX01FUYJH:2PX:2PV][J`L71`02;Rh^00Hd=3A;Bd/c
<c<c<c=TI6@d=3@2@T9200Ha<C4J6QY3@d=3@d=XJ6Q:BTX27alO00E1@D5aLG4Y:BTY:BV;Rh/00Wal
O006=cLgGUiNEEEEEEEE2PX:=CDe0R0P8006Cdm?NWYjW9bLW9bL8R8RaLG50Rl_;`05TY:B9RHV[:b/
[:b/@410008n?Sh01QHF5W=cLb/[:b/[:c4a<CDe=@8j>SX01Shn?TA4A4m?Cdm?CfYZJTI6AP9BDU80
1CHf=TY:BU1@D51@D6=SH`02FUYJ00H^;Rj<S8abLW9bLW9aLG50@4027QhN00HG5aMhN7Pb<S8b<S8W
9bL/;2`2EeMG00I0@41iNGU3@d=3@d=5ADESHf<2AdM700EkNg]KFe]KFe]0@415ADD00Q4A4@066ATI
A4A4Bd];Bd];9RHV_;bl0Q@D5006FUYJBd];8b<S8b<SBDU9^[Zj0QDE5@055aLGJ6QXJ6QXSHf=>CTi
008a<C401PT92I:BTXb<S8b<S9:BTQ@D509RHV801T=3@chn?Z>SXj>SXeADE0`<309GEeL01CXj>TI6
AV=SHf=SHa<C4`02IfMW00I1@D6HV9Q=CDe=CDdm?Cf][Jd2`l?300F`/;3oooooooooool00000;_oo
o`040000ooooooooEeMG0W=cL`05EEEEHF5QMGEeMGEeBDU9009@D5001Va/K6EUIHB4Q8B4Q6MWI`P8
208b<S801S4a<Da<C34a<C4a<F=SHcHf=P93@d<01Bl_;b0P820P84Y:BV][J`02Cdm?00HG5aLi>CU`
L71`L70P8220P802Ph>300E3@d=UIFEUIFE9BDT51@D00R`/;0068B4Q@D51QXJ6QXJ6SXj>=SHf0/G5
a@05<c<cRh^;>SXj>SXjVIVI009CDe<01RTY:@@417inOWinOQTI6BXZ:P8n?Sh01TA4A5=CDbd];Bd]
;D51@EEEE@9KFe/01DY:BR4Q8B4Q8D];BcXj>P02Jf][00IPH60N7QjRXZ:RXZ9OGem[Jf/2B4Q800DZ
:RXS8b<S8b=YJFTk>c/00S0`<006820PIfMW=SHf=SHfNWYj?Shn0Ta<C005KVi^AdM7MgMgMgMgIFEU
008h>3P01Slo?aHF5Q/K6a/K6chn?TQ8B08X:2P01Kbl_1<C4e]KFe]KFdE5A@02:RXZ00I>CTjd];@>
3Ph>3Ph@411/K6`2QHF500I4A4@/;2`<30`<30bMWIfHV9P2Vi^K00DI6AUKFe]KFe]8B4Pg=cL00YJF
UP06Bd];5ADEBTY:BTY:@d=3@T920UMGE`051PH6FEUIB4Q8B4Q8T92@009HF5P01C0`<::RX];Bd];B
d[Jf]P03oooo00<0003oooooool03Oooo`008_ooo`050000oooooooooooogMgM00:5QHD01TI6AW9b
LXn?Shn?Sd92@VYZJP9GEeL01AXJ6V=SHf=SHhj>SXJ6QP02TI6A00H^;Ri7AdM=CDe=CDeRHV8k>c/2
2`/;00ITI6@?3`o6a/K6a/IlO7a=CDd2C4a<00D/;2`f=SIfMWIfMWH20P800R/[:`069bLWI6ATF5QH
F5QHIFEUMgMg0Z:RXP06<S8bDU9BEEEEEEEEBTY:CDe=0ZZZZP05>CTiEUIFEEEEEEEE;bl_009kNg/0
1V5QHD];BbDU9BDU9F=SHe]KF`9eMGD01SDe=C@d=7IfMWIfMT=3@b0P80:IVIT01EmOGeYJFTa<C4a<
C3Hf=P028b<S00H_;blZ:RXo?clo?cm1@D4/;2`2RHV900I0@41LG5`O7alO7amXJ6QBDU82CTi>00I7
AdM6ATIXJ6QXJ6QJFUZ7QhL22`/;00DW9bLl?3`l?3`Z:RYSHf<00a/K6`05@410>3Ph>3Ph?ShnBDU9
009HF5P01X20P61PH1<C4a<C4dQ8B2h^;P:NWYh01Bh^;[Ng]kNg]e=CDjZZZP02>CTi00HZ:RYVIVI:
BTY:BTZo_klH61P2@D5100HD51@@413Ph>3Ph>1KFe]FEUH2FUYJ00D_;bm7AdM_Kfm_Kfl71`L00TE5
A@06<C4aDe=C@T92@T92QhN7ATI60SHf=P05Cdm?oooooooooooo000002koool010000?ooooooomGE
e@:?Shl01DU9BG9bLYbLW9bLW4i>CP02IfMW00ISHf<?3`mOGemOGenIVIV1PH42R8R800HW9bM0@411
@D51@D5ZJVY3@d<20`<300EGEeLN7QhN7Qk>c/j5QHD00TE5A@06AdM7;2`/@410@410KFe]3`l?0QdM
7@05>3PhM7AdM7AdD51@EEEE00:4Q8@01Z6QXC0`<4I6ATI6ATA4A5aLG09DE5@01JBTY4a<C4Y:BTY:
BTM7A`02=cLg00I[Jf]DE5AHF5QHF5Pc<c=CDe<2DU9B00IfMWHh>3Q4A4A4A4AVIVHd=3@2;bl_00F]
[JeBDU9BDU9[Jf]IFET00RHV9P065QHF8B4Q9BDU9BDU@T92=cLg0S8b<P05OGemD51@D51@Fe]K71`L
009^KVh01TA4A5UIFChn?Shn?S/k>emOG`9ADE401IJFUPX:2Rh^;Rh^;S`l?0027AdM00IHF5PQ8B4P
820P820o?cm2@T82=3@d0Te=C@9gMgL01FMWI`l?3`l?3eIFESDe=@02W9bL00HT92B^[ZiIFEUIFEVQ
XJ4j>SX2=3@d00EKFe]2@T:n_[jn_[hB4Q800TU9B@066a/K71`Lk^k^k^k^DU9BH61P0U5AD@069RHV
CTi>NGUiNGUi4Q8BBTY:0Sdm?@05BDU9?3`l?3`lRHV9@d=3008_;bl01DE5AOooooooooooo`00000?
oooo000Roooo00D0003ooooooooooooMgMd00XF5Q@06ATI6LW9bShn?Shn?@T92JVYZ0UMGE`056QXJ
Hf=SHf=SSXj>QXJ600:ATI401Rh^;TM7Ade=CDe=CF9RHS/k>`8;2`/01VATI0l?3lK6a/K6aWalO4e=
C@9<C4`01B`/;3Hf=WIfMWIfMP820P02:b/[00HW9bMTI6AHF5QHF5QUIFEgMgL2XZ:R00Hb<S9BDU9E
EEEEEEE:BTY=CDd2ZZZZ00Di>CUFEUIEEEEEEED_;bl00W]kN`06HF5QBd];9BDU9BDUHf=SFe]K0WEe
M@06=CDe=3@dMWIfMWIf@d=3820P0YVIV@05GemOFUYJC4a<C4a<=SHf008S8b<01Rl_;bXZ:Slo?clo
?d51@B`/;0:9RHT01T10@5aLG1lO7alO7fQXJ59BDP9>CTh01TM7AdI6AVQXJ6QXJ5YJFXN7Q`8;2`/0
1BLW9c`l?3`l?2XZ:V=SH`036a/K00E0@40h>3Ph>3Pn?Si9BDT00UQHF006P820H61P4a<C4a<CB4Q8
;Rh^0YjNWP05;Rh^]kNg]kNgDe=CZZZZ008i>CT01RXZ:VIVITY:BTY:B[no_aPH6091@D401Q@D510@
4>3Ph>3Ph5]KFeIFEP9JFUX01Bl_;dM7Afm_Kfm_K`L71`02ADE500Ha<C5CDe=2@T92@T:7QhM6ATH2
=SHf00E?Cdooooooooooool00000;_ooo`040000ooooooooeMGE0Xn?S`05BDU9LW9bW9bLW9bLCTi>
009WIfL01V=SH`l?3emOGemOGiVIVH61P@:8R8P01RLW9d10@451@D51@FYZJT=3@`830`<01EMGEahN
7QhN7/k>cXF5Q@02ADE500I7AdL/;2a0@410@41]KFd?3`l27AdM00Dh>3QdM7AdM7A@D51EEED00XB4
Q006XJ6Q<30`ATI6ATI6A4A4G5aL0UADE005Y:BTC4a<BTY:BTY:AdM7008g=cL01V][JeADE5QHF5QH
F3<c<e=CD`9BDU801WIfMSPh>4A4A4A4A6IVIS@d=08_;bl01Jf][E9BDU9BDV][JeUIF@029RHV00HF
5QHQ8B4U9BDU9BE2@T8g=cL2<S8b00EmOGe@D51@D51KFe/L71`00Vi^KP06A4A4FEUI?Shn?Shn>c/k
GemO0U5AD@05UYJF2PX:;Rh^;Rh^?3`l008M7Ad01UQHF24Q8B0P820P83lo?d92@P8d=3@2CDe=0WMg
M`05IfMW3`l?3`l?EUIF=CDe00:LW9`01R@T9:j^[UUIFEUIFJ6QXCXj>P8d=3@01E]KFd92@[jn_[jn
_Q8B4P02BDU900HK6a/L71c^k^k^k^iBDU9PH602DE5A00HV9RI>CTiiNGUiNGTB4Q9:BTX2?Cdm00E9
BDTl?3`l?3b9RHU3@d<00Rl_;`05ADE5oooooooooooo000000ooool002;oool01@000?oooooooooo
ogemO@02L71`00I0@41=CDeXJ6QXJ6QUIFDc<c<2>SXj00EWIfM^KVi^KVj6QXJJVYX00XB4Q006>c/k
6a/KCdm?Cdm?:BTY?clo0T=3@`06J6QXMgMg?Cdm?CdmBDU94Q8B0VYZJP05NWYjKFe]820P820P6ATI
008[:b/01VMWIhn?SfEUIFEUIHb<S9jNWP8m?Cd01UADE5iNGSLg=cLg=eUIF@X:2P90@4001D92@S/k
>dI6ATI6AS4a<@02IFEU00Hb<S8h>3PZ:RXZ:RX];BeKFe/2:RXZ00H_;bmEEEEGEeMGEeLa<C492@T2
@41000E^KViNGUjWYjNWYjLI6AT00SDe=@06Ng]kQHF5PX:2PX:2GUiN@T920VATI006B4Q8LW9bC4a<
C4a<De=C5QHF0Ti>CP06EEEE@D513Ph>3Ph>IfMWFe]K0QlO7`0530`<ATI6ATI6<C4aIfMW0092@T80
1TI6AS@d=20P820P838b<WYjNP8g=cL01Xf=SBPX:7=cLg=cLcLg=e=CD`:UYJD01E5ADHj>SXj>STM7
Ai>CT`02LG5a00IXJ6QfMWHV9RHV9RIaLG50@402LW9b00I0@41SHf>k^k^k^k/U9BGCdm<2>SXj00E6
ATHN7Qj2PX:2PX94A4@00PT92@038R8RFe]KBd];009;Bd/017moOkFe]KFe]DM7A`?oool00`000?oo
ooooo`0/oooo00@0003ooooooomhN7P2L71`0TI6AP9[Jf/01G9bLRTY:BTY:C`l?5eMG@02NWYj00J=
SHfGUiMmOGemOGdl?3`I6AT2BDU900DZ:RY7AdLo?clo?cmTI6@00WinOP06?cloADE53`l?3`l?J6QX
Ng]k0W5aL@058R8R5QHF:2PX:2PXJFUY00:CTi<01VQXJ8f=SJ6QXJ6QXC/k>eMGE`9MGEd01S/k>eUI
F@P820P824A4A492@P8l?3`01DA4A34a<C4a<FEUIC0`<002?3`l00H/;2`^;RiHF5QHF5PV9RH[:b/2
F5QH00EFEUHg=cL820P820Pm?Cd00WEeM@06FUYJ[Jf]7AdM7AdM?3`lOGem0X:2PP05OgmoGemO>c/k
>c/kGUiN009;Bd/01WMgMdm?Cdi>CTi>CPd=3De=C@9>CTh01T=3@aDE5F][Jf][JeMGEb/[:`8I6AT0
1C`l?2HV9RHV9V=SHdm?C`02>CTi00I3@d<B4Q8T92@T92B0P80i>CT2Ogmo00DT92B5QHF5QHDZ:RY3
@d<00[Jf]P06C4a<Shn?C4a<C4a<QXJ6H61P0V9RHP05OGem=3@dI6ATI6ATBd];00:2PX801U=CDfYZ
J/W9bLW9bBHV9/k>cP8];Bd01Shn?QdM7GMgMgMgMeIFEPL71`8`<3001De=CChn?Shn?Sdm?Hf=S@02
ZJVY00E4A4Coooooooooool000003oooo`008_ooo`050000ooooooooooook^k^00:<S8`01Sdm?HB4
Q8:2PX:2PXJ6QWIfMP:KVi/01C8b<^?Shn?ShemOGfm_K`02K6a/00Ho?cla<C4N7QhN7Qi4A4@C4a<2
?Cdm00IUIFDL71anOWinOWioOgmFEUH2_[jn00Dh>3Q@D517AdM7AdL_;bl00VMWI`061PH6EEEEHF5Q
HF5QIVIVHf=S0U5AD@06OGemLG5aHF5QHF5Q;2`/JFUY0S<c<`050@41GUiN5QHF5QHF;2`/009]KFd0
1RDU9EMGEbl_;bl_;bXZ:QhN7P8c<c<01UaLG5UIFB8R8R8R8XJ6QPl?3`8l?3`01A@D54i>CVIVIVIV
ISPh>002<C4a00Hf=SIgMgMZJVYZJVYaLG4T92@23`l?00I0@41TI6AaLG5aLG4X:2Q4A4@2;bl_00HI
6AUaLG4i>CTi>CU]KFdj>SX2:2PX00E1@D5DE5ADE5@l?3`T92@00Ta<C0069RHV61PH4Q8B4Q8B@d=3
nOWi0TY:BP06JVYZC4a<9BDU9BDUTi>CRXZ:0STi>@05LG5aADE5ADE5Fe]K9BDU009FEUH01Xj>STi>
CU=CDe=CDgAdM3De=@:][Jd01WQhN6IVIWYjNWYjNS/k>nKViP9cLg<01B/[:aHF5Q<C4a<C4`D51@02
T92@00J0P81YJFVATI6ATI5<C4abLW82EUIF1?ooo`030000oooooooo02coool010000?ooooooonk^
kP:?Shl01Clo?ginOW]kNg]kNhn?S`02L71`00JFUYH];Bg/k>c/k>aLG5a[Jf/2IfMW00Hm?Cdc<c<O
7alO7am0@40F5QH2>3Ph00EQHF4R8R8R8R9iNGV5QHD00U1@D006b<S8<C4aBd];Bd];@T92=CDe0V][
J`0510@4CDe=CDe=FUYJHf=S009IFET01TQ8B7=cLgYjNWYjNUMGEb4Q8@9]KFd01Chn?P`<35mOGemO
Ga@D5002>SXj00IbLW8/;2aUIFEUIFDm?CdS8b<24a<C00Hm?CeJFUY@D51@D50H61R7QhL26QXJ00E4
A4@@410@411EEEEOGel00S4a<@06:b/[@T92MGEeMGEeKFe]Jf][0Rh^;P0520P8=SHf=SHfFe]KO7al
008b<S801S/k>bDU9AhN7QhN7WAdM3<c<`9fMWH01Clo?b/[:dY:BTY:BUEEE@02>3Ph00HN7QiFEUHP
820P820M7Ad>3Ph2A4A400Gbl_9FEUIPH61PH61FEUH00S4a<@06X:2POGemB4Q8B4Q8MGEe=cLg0Tm?
C`066ATIB4Q8PH61PH61GUiNBd];0XF5Q@05A4A4_[jn_[jnQhN7H61P00:3Ph<01Rl_;mkNgVMWIfMW
Ibl_;`h>3P851@D01A8B4YbLW7AdM7AdM6m_K`02UIFE00AGEeMkNg]IFEUIFET4oooo00<0003ooooo
ool03Oooo`008_ooo`800002oooo00Fo_km`L71`L72WYjOKfm/00S<c<`05K6a/UIFEM7AdM7AdB4Q8
00;8b<P01I:BTW5aLFUYJFUYJHf=S@03<C4a00Hc<c=RHV9BDU9BDU9fMWJ3Ph<2LG5a00HB4Q9jNWXA
4A4A4A5ADE53@d<2LG5a00Db<S:`/;2`/;0Z:RXa<C400YNGU`06J6QX>SXjU9BDU9BDCTi>GEeM0UIF
EP06AdM7;2`/Bd];Bd];;Rh^B4Q80Shn?P051@D5A4A4A4A4?CdmNg]k009VIVH01V][Jf5QHC4a<C4a
<GYjNT10@0:6QXH01UADE3De=F1PH61PH6IVIY2@T08k>c/01G=cLeEEEEEEEAlO7iZJVP0292@T00JI
VIUEEED>3Ph>3Phd=3@P8202Ti>C00Ha<C5_Kfll?3`l?3`_;bnIVIT29RHV00E4A4AOGem3@d=3@d?4
a<@00TI6AP0661PH@T92<c<c<c<cF5QH@d=30Shn?P067alOQHF5@d=3@d=3:2PX9bLW0TU9B@05KFe]
C4a<5ADE5ADEOgmo008Q8B401TQ8B3@d=3Ph>3Ph>3dm?FMWI`8/;2`01UMGEe9BDVm_Kfm_Ka/K6eAD
E08g=cL01Tm?CeQHF;Bd];Bd]51@D18B4P9QHF401CLg=aLG5aLG5bh^;TU9B@02HV9R00EiNGUHF5PM
7AdM7Afd];@00_ooo`80000^oooo0P000006ooooa<C4Hf=SHf=SZ:RXinOW0RLW9`05N7QhRHV9RHV9
K6a/FEUI00;:b/X01H>3Pg5aLEiNGUiNGXJ6QP038B4Q00DR8R9bLW92@T92@T9cLg<00Xn?S`06HF5Q
0@41PH61PH6130`<ADE50SDe=@05IFEU>CTi];Bd];Bd820P008d=3@01YbLW5mOGbl_;bl_;hZ:RTQ8
B09[Jf/01TY:BUADE2XZ:RXZ:TU9BBHV9P9ADE401C@d=0L71`L71dA4A3`l?002QHF500I_KfmVIVIV
IVIVIVH/;2amOGd2@T9200F1PH5EEEDk>c/k>c]WIfL00V9RHP06UiNG@410LG5aLG5aFUYJ6QXJ0YbL
W005:RXZUIFEEUIFEUIF2`/;008b<S801R4Q8IZJVSHf=SHf=W5aLC`l?08];Bd01YJFUR8R8T51@D51
@FATI4=3@`;:b/X01DE5AA@D51@D5451@C4a<@02G5aL0T51@@8R8R801HF5QD=3@bTY:BTY:BPX:002
BTY:00I^KVi=CDdG5aLG5aN1PH4R8R82BTY:00Hg=cLl?3`k>c/k>c]XJ6PW9bL2De=C00EADE5]KFe]
KFdR8R9FEUH00Slo?`06B4Q8Fe]K`<30`<30B4Q86ATI0UYJFP05@T926QXJ=3@d=3@dADE5009^KVh0
1G]kNe5AD@l?3`l?3lG5a@02oooo0P0000ooool002;oool01@000?oooooooooookno_`02L71`00JW
YjOKfm/c<c<c<c=/K6bEUID2M7Ad00E8B4S8b<S8b<RBTY9aLG400VUYJ@06SHf=<C4a<C4a<C4a<c<c
HV9R0U9BDP06MWIfPh>3LG5aLG5a4Q8BNWYj0Q4A4@05DE5A@d=3LG5aLG5a<S8b00:`/;001RXZ:S4a
<INGUiNGUfQXJ3Xj>P:DU9@01Ti>CUeMGEIFEUIFETM7Ab`/;09;Bd/01Bh^;TQ8B3hn?Shn?PD51@02
A4A400Hm?CekNg]VIVIVIVI[Jf]QHF42<C4a00IjNWY0@426QXJ6QXIDE5@e=CD2H61P00EVIVJ@T90k
>c/k>c]cLg<00UEEE@067alOVYZJ92@T92@TVIVIEEEE0Ph>3P06=3@d820PTi>CTi>C<C4aKfm_0S`l
?006;bl_VIVI9RHV9RHVA4A4GemO0T=3@`05a<C4ATI6ATI661PH@T92008c<c<01UQHF4=3@chn?Shn
?QlO7hF5Q@93@d<01RPX:2LW9dU9BDU9BFe]KDa<C08E5AD01GmoOb4Q8B4Q8DQ8B3@d=002>3Ph00Hm
?CeWIfL/;2`/;2aGEeMBDU82Kfm_00HK6a]DE5@g=cLg=cM?CdmHF5P2];Bd00E@D50B4Q9QHF5QHF4g
=cL00QLG5`06;Rh^BDU9HV9RHV9RNGUiF5QH0QdM7@05];Bdoooooooooooo000002koool010000?oo
ooooolC4a09SHf<01JRXZ>OWibLW9bLW9gQhN002RHV900I/K6aIFEW:b/[:b/Z3Ph=aLG42GUiN00J6
QXHQ8B4Q8B4Q8B4R8R9bLW82@T9200EcLg>?Shn?ShmQHF410@400X61P@0630`<ADE5=CDe=CDeIFEU
>CTi0[Bd]005820P=3@d=3@dW9bLGemO008_;bl01XZ:RTQ8B6][Jf][JdY:BUADE08Z:RX01DU9BBHV
9U5ADE5ADC@d=0021`L700E4A4@l?3b5QHF5QHE_Kfl00fIVIP06;2`/OGem@T92@T92PH61EEEE0S/k
>`05IfMWHV9RHV9RUiNG@410009aLG401UYJFQXJ6YbLW9bLW2XZ:YFEU@9FEUH01@/;2c8b<S8b<R4Q
8IZJVP02=SHf00IaLG4l?3`];Bd];BfFUYHR8R82@D5100ETI6A3@d?:b/[:b/Y5ADD00Q@D5004@D51
<C4aG5aLG5aL0T51@@8R8R801HF5QD=3@bTY:BTY:BPX:002BTY:00I^KVi=CDdG5aLG5aN1PH4R8R82
BTY:00Hg=cLl?3`k>c/k>c]XJ6PW9bL2De=C00EADE5]KFe]KFdR8R9FEUH00Slo?`06B4Q8Fe]K`<30
`<30B4Q86ATI0UYJFP05@T926QXJ=3@d=3@dADE5009^KVh01G]kNe5AD@l?3`l?3lG5a@03oooo00<0
003oooooool03Oooo`008_ooo`050000ooooooooooooY:BT00:OWil01UiNGU]KFbd];Bd];AlO7d];
B`9eMGD01GMgMhb<S8b<S;Bd]451@@02Ogmo00IXJ6Q5ADDK6a/K6a/`<31ADE4251@D00DW9bMNGUhP
820P8216ATH00hF5Q@052PX:IFEUYJFUYJFU?3`l00:][Jd01UADE2@T96m_Kfm_Kfi^KWemO@9gMgL0
1V9RHQ<C4eeMGEeMGF=SHiJFUP9@D5001J2PX3/k>g5aLG5aLBDU9@02GEeM00H=3@e6ATI0@410@40f
=SIDE5@2=3@d00H?3`m^KVi^KVi^KVjg]kLW9bL2Cdm?00Df=SIRHV9eMGEeMGERHV800S/k>`06=CDe
>SXjBd];Bd];Ph>38B4Q0RPX:006=3@dEeMG@410@4108B4QL71`0VUYJ@067QhN>CTiHf=SHf=SEeMG
<c<c0Rh^;P05EeMGS8b<S8b<2PX::2PX008k>c/01R@T96QXJ28R8R8R8V1PH1LG5`9=CDd01RPX:0`<
31DE5ADE5@l?3kbl_0:6QXH01C<c<bXZ:RXZ:VQXJ34a<@027QhN00IDE5B9RHT];Bd];Bfb/[9WIfL2
C4a<00HT92A5ADEHF5QHF5REUIEiNGT2>CTi00E>CTh/;2abLW9bLW9OGel00S`l?006E5AD8b<S:b/[
:b/[2@T9T92@0XF5Q@05^k^koooooooooooo000002koool010000?oooooook^k^`:>SXh01DQ8B7Ad
M4E5ADE5AAHF5P02?Shn00J5QHE`L72<S8b<S8bSXj<b<S82R8R800ITI6@h>3P=3@d=3@dj>SYRHV82
61PH00Dj>SYZJVYZJVXA4A4l?3`00XN7Q`06NGUi2PX:FEUIFEUIXj>S@d=30ZRXZ005CTi>:b/[:b/[
Lg=cJ6QX00:3Ph<01WAdM6QXJ10@410@461PH6IVIP:FUYH01E=CDjBTY3Ti>CTi>GAdM0029RHV00IM
GEd;2`]0@410@40m?Cdj>SX2Cdm?00H^;RhI6AUVIVIVIVIiNGV`/;028b<S00E4A4A0@410@41SHf=a
LG400UYJFP06?3`l<c<c;Rh^;Rh^@d=3TY:B0R<S8`05>3Ph9BDU9BDUEUIF<c<c008C4a<01V=SHgYj
NQPH61PH64U9BG=cL`9GEeL01Bd];BHV9T];Bd];Bh20P00261PH00Hf=SH_;bl_;bl_;bm^KVhS8b<2
EUIF00DM7AeKFe/L71`L71`F5QH00P/;2`064Q8B`/;2RXZ:RXZ:>3Ph<c<c0UiNGP06>SXj410@ADE5
ADE5OGem@4100Z:RXP05LW9bATI6ATI65aLGCTi>0097AdL01Xb<S6MWIe1@D51@D3Xj>S0`<09TI6@0
1Dm?CeADE5]KFe]KFcPh>002?3`l00DQ8B64Q8A]KFe]KFg<c<`00oooo`030000oooooooo00goool0
02;oool01@000?ooooooooooofQXJ002>SXj00I/K6a[Jf]=CDe=CDdi>CUoOgl27AdM00ETI6B<S8b<
S8b4Q8AaLG400Q/K6`8Z:RX2<30`00HX:2Po?cm?Cdm?Cdlg=cMIFET2QhN700J[Zj/k>c^IVIVIVIU;
Bd/T92@2jNWY00Fi^KU`L71`L70P821CDe<00[^k^`06A4A4F5QHP820P820EUIFGEeM0RTY:@06MgMg
O7alA4A4A4A4QHF5EUIF0Ph>3P056QXJH61PH61P@d=3NWYj008F5QH01WIfMTM7AeQHF5QHF4];Bg1`
L09DE5@01WUiNF][Je]KFe]KFb`/;65QH@9=CDd01C@d=3dm?Cdm?@l?3hN7Q`02?Cdm00JCTi=LG5`h
>3Ph>3PJ6QY7AdL2DU9B00HF5QHk>c/X:2PX:2PK6a]GEeL2VIVI00F0P80X:2P];Bd];Be3@d<00T];
B`06SXj>9BDUOWinOWin7alOdM7A0XF5Q@06Fe]K<C4a=cLg=cLg?Cdm=CDe0Pd=3@03Fe]KBTY:=cLg
008g=cL230`<00I3@d<Z:RY@D51@D50o?cl_;bl271`L00I3@d<E5AEQHF5QHF64Q8A5ADD2DE5A00JW
YjMmOGeSHf=SHf=@D50_;bl2PH6100ENGUjCTi>CTi>QXJ5ZJVX00PX:2P05Hf=SRHV9L71`L71`TY:B
00?oool00`000?ooooooo`0/oooo00@0003ooooooomXJ6P2@41000EQHF5lO7aSHf=SHf<Y:BT00Y>C
T`068b<SN7QhNGUiNGUiO7alK6a/0PH61P04>CTi5ADE;2`/;2`/0Rd];@9NGUh01CDe=FEUIFEUIHn?
SinOW`02@D5100JIVIU2@T8T92@T92CemOFb/[82JVYZ00DN7Qi@D51@D52d];A:BTX00UEEE@06Ng]k
DE5AHf=SHf=S:2PXLW9b0XB4Q005B4Q8RXZ:G5aLG5aL51@D008J6QX01UMGEd51@HB4Q8B4Q0P827=c
L`8m?Cd01TU9BEEEEEiNGUiNGTY:BW1`L09FEUH01D];BdA4A4A4A6m_KcXj>P0292@T00ICDe<@411g
MgMgMgM;Bd]nOWh2MGEe00DL71`d=3@d=3@Z:RY=CDd00Q@D5006E5AD92@T4Q8B4Q8B>c/k]kNg0VUY
J@05ADE59bLW:BTY:BTY>3Ph009fMWH01Sdm?F][Jc4a<C4a<MSHf79bLP9MGEd01AdM7D];Bd92@T92
@S/k>`027QhN00IZJVY?Cdle=CDe=CD^;Rh820P2=cLg00HP8216ATI1@D51@D4U9BDK6a/2>c/k00@?
3`mUIFEUIFElO7`3AdM700JWYjMbLW9HF5QHF5QMGEdX:2P2M7Ad00EBDU:GUiNKVi^KVi]lO7`00Q@D
5005KVi^WIfMI6ATI6ATPH6100?oool00`000?ooooooo`0=oooo000Roooo00D0003ooooooooooomL
G5`00W1`L006Ti>CC4a<IVIVIVIVOGemFe]K0[bl_005P820B4Q8B4Q8=3@d1`L7009HF5P01Q8B4VUY
JGalO7alO61PH6a/K08V9RH01X>3P`P823Xj>SXj>S@d=0h>3P9RHV801HV9RG]kNcLg=cLg=f1PH002
CDe=00HT92A?CdmYJFUYJFUDE5BVYZH3B4Q800De=CDd=3@d=3A:BTXP82000RTY:@05ADE56ATI:2PX
:2PXJ6QX009IFET01VQXJ20P82XZ:RXZ:T92@UQHF0:EUID01U1@D4];BeEEEEEEEDI6AV5QH@8F5QH0
1AhN7QlO7bh^;Rh^;UeMG@02QXJ600H/;2`M7Afj^[Zj^[XD51@j>SX2G5aL00H^;RhY:BTY:BTY:BTU
9BEdM7@2Bd];00JUYJE?Cdlc<c<c<c<Z:RZ1PH42MgMg00E/K6acLg=cLg<H61QMGEd00P<30`06Q8B4
>3Ph8R8R8R8RZ:RXFEUI0Shn?P06?3`l4A4ADE5ADE5ABd];`L710UQHF005>3PhKFe]KFe]EUIFGEeM
008?3`l01QPH665QHBPX:2PX:5=CDg1`L0:ATI401RHV9YRHV79bLW9bLVIVIR4Q8@;=cLd01NCTi6=S
Hc8b<S8b<ZNWY`02UiNG00J:RXXC4a>b/[:b/[:ATI6WYjL2Cdm?00G;bl_oooooooooool00000;_oo
o`040000ooooooooF5QH0WAdM005WIfMEEEEJFUYJFUYQhN7009UIFD01/;2`XN7QdQ8B4Q8B3hn?P`<
309MGEd01Q`L76ATI7moOgmoOeQHF6e]K@8[:b/01GemO@D51@D51D=3@b`/;0022@T900IVIVJ7QhN2
PX:2PX8n?SiLG5`2DE5A00DO7am>CTi>CTiVIVIJFUX00Z>SX`06ADE5B4Q8>SXj>SXj<C4aBDU90RHV
9P058b<SBd];8B4Q8B4Q8b<S009QHF401UEEEFQXJ2XZ:RXZ:S@d=3Ph>09HF5P01Xj>SUEEEClo?clo
?de=CDa<C09HF5P33Ph>00HW9bLM7AeCDe=CDe>IVITT92@2;Bd]00FZZZXQ8B4/;2`/;2aWIfL00S@d
=0069RHV9bLW=cLg=cLgRHV9@D510Y>CT`06FEUI?clo?3`l?3`lLW9bRXZ:0VYZJP05K6a/2PX:2PX:
C4a<5ADE00:0P8001S4a<AHF5Z2PX:2PX4Y:BTe=C@8^;Rh01A`L75mOGemOGdi>C[no_`02GUiN00Hk
>c]VIVIQHF5QHF5KFe/B4Q8251@D00EWIfLR8R9>CTi>CTi]KFd00Y2@T006:RXZUiNGMGEeMGEeJ6QX
820P0/o?c`06j>SXHV9R<C4a<C4aYZJVUIFE0XV9R@055QHF/;2`/;2`UiNG[Jf]009?Cdl01LS8b?oo
ooooooooo`00000?oooo000Roooo00D0003ooooooooooomLG5`00W1`L006Ti>CC4a<IVIVIVIVOGem
Fe]K0[bl_005P820B4Q8B4Q8=3@d1`L7009HF5P01Q8B4VUYJGalO7alO61PH6a/K08V9RH01X>3P`P8
23Xj>SXj>S@d=0h>3P9RHV801HV9RG]kNcLg=cLg=f1PH002CDe=00HT92A?CdmYJFUYJFUDE5BVYZH3
B4Q800De=CDd=3@d=3A:BTXP82000RTY:@05ADE56ATI:2PX:2PXJ6QX009IFET01VQXJ20P82XZ:RXZ
:T92@UQHF0:EUID01U1@D4];BeEEEEEEEDI6AV5QH@8F5QH01AhN7QlO7bh^;Rh^;UeMG@02QXJ600H/
;2`M7Afj^[Zj^[XD51@j>SX2G5aL00H^;RhY:BTY:BTY:BTU9BEdM7@2Bd];00JUYJE?Cdlc<c<c<c<Z
:RZ1PH42MgMg00E/K6acLg=cLg<H61QMGEd00P<30`06Q8B4>3Ph8R8R8R8RZ:RXFEUI0Shn?P06?3`l
4A4ADE5ADE5ABd];`L710UQHF005>3PhKFe]KFe]EUIFGEeM008?3`l01QPH665QHBPX:2PX:5=CDg1`
L0:ATI401RHV9YRHV79bLW9bLVIVIR4Q8@;=cLd01NCTi6=SHc8b<S8b<ZNWY`02UiNG00J:RXXC4a>b
/[:b/[:ATI6WYjL2Cdm?00G;bl_oooooooooool00000;_ooo`040000ooooooooF5QH0WAdM005WIfM
EEEEJFUYJFUYQhN7009UIFD01/;2`XN7QdQ8B4Q8B3hn?P`<309MGEd01Q`L76ATI7moOgmoOeQHF6e]
K@8[:b/01GemO@D51@D51D=3@b`/;0022@T900IVIVJ7QhN2PX:2PX8n?SiLG5`2DE5A00DO7am>CTi>
CTiVIVIJFUX00Z>SX`06ADE5B4Q8>SXj>SXj<C4aBDU90RHV9P058b<SBd];8B4Q8B4Q8b<S009QHF40
1UEEEFQXJ2XZ:RXZ:S@d=3Ph>09HF5P01Xj>SUEEEClo?clo?de=CDa<C09HF5P33Ph>00HW9bLM7AeC
De=CDe>IVITT92@2;Bd]00FZZZXQ8B4/;2`/;2aWIfL00S@d=0069RHV9bLW=cLg=cLgRHV9@D510Y>C
T`06FEUI?clo?3`l?3`lLW9bRXZ:0VYZJP05K6a/2PX:2PX:C4a<5ADE00:0P8001S4a<AHF5Z2PX:2P
X4Y:BTe=C@8^;Rh01A`L75mOGemOGdi>C[no_`02GUiN00Hk>c]VIVIQHF5QHF5KFe/B4Q8251@D00EW
IfLR8R9>CTi>CTi]KFd00Y2@T006:RXZUiNGMGEeMGEeJ6QX820P0/o?c`06j>SXHV9R<C4a<C4aYZJV
UIFE0XV9R@055QHF/;2`/;2`UiNG[Jf]009?Cdl01LS8b?ooooooooooo`00000?oooo000Roooo00D0
003ooooooooooooemOD00W=cL`06^KVi`<30dM7AdM7AZZZZH61P0S<c<`05ADE5FEUIFEUI[:b/U9BD
00:3Ph<01Xn?SeMGEjNWYjNWYbDU9M7Ad@8m?Cd01Y>CTb/[:aDE5ADE5ALG5d51@@8i>CT014i>CVa/
K4m?Cdm?C`<Z:RX01UmOGa0@47QhN7QhN6UYJBd];@8E5AD01Rl_;a/K6fMWIfMWIcTi>D=3@`9CDe<2
Bd];0U1@D005<30`Shn?Shn?:BTY:b/[008P82001QPH61DE5GUiNGUiNJVYZ@X:2P8a<C401W9bLUYJ
FS`l?3`l?59BDSXj>P99BDT01@P825QHF5QHF5EEEE=CD`029BDU00HH61QUIFENGUiNGUi9BDTj>SX2
C4a<00Hi>CUMGEf0P820P81BDU9]KFd2Kfm_00DY:BTl?3`/;2`/;2b:RXX00UeMG@06:b/[@D51A4A4
A4A4;Bd]61PH0S@d=006>c/kIFEUEeMGEeMGGEeMAdM70SPh>005NWYjShn?@D51@D517alO008i>CT0
1/S8b6=SHh61PH61PCXj>[Vi^@:ATI401Ta<C>OWigQhN7QhN:FUY@/;2`8b<S801TE5AA`L720P820P
87MgMh20P0:VYZH01JNWYoooooooog=cLi>CT`02ATI600DA4A7ooonSXj>SXj?AdM400oooo`030000
oooooooo02coool010000?oooooooo;blP9dM7@01K2`/<k>c]OGemOGej:RXP02H61P00Hk>c]6ATIF
EUIFEUJXZ:R<S8`2QXJ600J7QhM>CTj`/;2`/;0N7QkBd]82A4A400FMWIdV9RHV9RH=3@dF5QH00TY:
BP06<C4aEUIFK6a/K6a/De=C;Rh^0R/[:`05GemO2PX:2PX:PH61IFEU008_;bl01Q@D53Ph>2<S8b<S
8fm_Kd10@08m?Cd01Dm?CdQ8B4E5ADE5AD];B`02=SHf00J;Rh/`<30V9RHV9RHU9BDC4a<24Q8B00Ik
Ng^WYjL>3Ph>3Ph`<31fMWH2EeMG00Do?cm@D51@D50h>3Q8B4P00PL71`06Fe]KEUIFDU9BDU9B92@T
61PH0VEUI@05GUiNBd];Bd];>CTiC4a<008j>SX01UiNGX61PEIFEUIFEW5aLF][J`8];Bd01CLg=c8b
<XJ6QXJ6QVEUI@02<c<c00I2@T9<C4`U9BDU9BDQ8B4/;2`2=cLg00E[Jf]>CTiLG5aLG5a:BTX00Rl_
;`06Lg=cQHF5CDe=CDe=5ADE?clo0/g=c@06FUYJN7QhA4A4A4A4a/K6QXJ60UQHF005i>CTLg=cLg=c
XJ6Q2@T9008g=cL01Ta<C1@D52h^;Rh^;V][Jhf=S@:QXJ401K:b/_ooogAdM7AdM:6QX@02@41000DG
5aOooona/K6a/K77alL00oooo`030000oooooooo00goool002;oool200000oooo`;6a/H01_ooohJ6
Q/K6a/K6aW5aLEeMG@;2`/801Hb<S3Lg=cLg=gAdM>c/k0029RHV00JZZZXX:2P820P820RSXj=FEUH2
=3@d00IZJVXd=3@T92@T92A7AdMaLG42KVi^00EJFUYlO7aRHV9RHV8W9bL00Shn?P06CDe=Ng]k>c/k
>c/kHF5Q8R8R0VUYJ@067alOHV9R:b/[:b/[8R8RPH610RHV9P05VYZJADE59bLW9bLWATI6008?3`l0
1Rd];HJ6QUaLG5aLG79bLRl_;`:=SHd01ZJVYTa<C1LG5aLG5aDE5Bh^;P91@D401C@d=4e=CD=3@d=3
@cHf=P0251@D00IIFETZ:RYGEeMGEeLe=CDf=SH2@41000Hk>c]/K6a0@410@40m?Ce=CDd2FEUI00IN
GUjBTY98B4Q8B4P<30`B4Q82MgMg00Da<C4j>SXj>SZ?ShlX:2P00PL71`06BTY:<S8b@410@410L71`
EeMG0Q@D5006O7al410@@d=3@d=3QHF5<30`0VQXJ005GUiN>CTi>CTiIVIVi^KV00;0`<001WQhN4E5
ACXj>SXj>XR8R7]kN`9oOgl01Zj^[VIVISXj>SXj>Vm_KaTI6@8>3Ph01B/[:eQHF9>CTi>CTfi^KP02
oooo00IADE4o?cmiNGUiNGWCdm<I6AT2]KFe00>XZ:Soooooool00P0002koool200000_ooo`;8b<P0
1Ooooi>CTm;Bd];BdW=cL`02FEUI00K=cLfFUYH_;bl_;bm^KVk^k^h27alO00JTY:@Q8B410@410@6Y
ZJUADE42>SXj00E`L70_;bl_;blU9BE5ADD00WUiN@06J6QXHV9RPX:2PX:2Jf][8R8R0TI6AP05CDe=
MGEeMGEe@d=3HV9R008R8R801VQXJ24Q8F=SHf=SHc8b<RTY:@:2PX801BPX:9RHV410@410@2d];@02
Bd];00H>3Ph`<328R8R8R8QIFEUfMWH2;Bd]00J@T92WYjM=CDe=CDdG5aLE5AD2;Bd]00E2@T8g=cLg
=cM>CTi8B4P00SHf=P065ADEH61P8b<S8b<SH61P;Rh^0SLg=`05BTY:<c<c<c<cHV9R=SHf008i>CT0
1T51@FIVIVEUIFEUIIjNWSXj>P8I6AT01B<S8fMWIb4Q8B4Q8D];B`02XJ6Q00Hj>SXJ6QXe=CDe=CDa
<C4f=SH2GemO00EADE4Y:BUmOGemOGdP82000SLg=`06L71`8R8RK6a/K6a/LW9b8b<S0VMWI`06dM7A
][JfJVYZJVYZE5AD;Bd]0WYjNP05LG5aK6a/K6a/][JfI6AT0090@4001Vi^KQTI6@D51@D51B0P84I6
AP:KVi/01Fm_KooooeIFEUIFEU1@D002K6a/00G>c/hY:BV/[:b/[:bNWYh00_ooo`80000?oooo000R
oooo00<0003oooooool00_ooo`8K6a/01_oooe]KFjf][Jf][B0P8=SHf0871`L00oooof5QHF5QH@02
Cdm?0Ve]K@06WinOFEUIHF5QHF5Q5ADEMGEe0W9bLP06>3Ph@410^;Rh^;RhNg]kEeMG0Vi^KP05W9bL
51@D<30`<30`J6QX008O7al01WYjNXB4Q3dm?Cdm?AlO7fEUI@8W9bL01YFEUCDe=@D51@D51DE5AJ:R
XP8d=3@01F][J`P826e]KFe]KH:2PP02?3`l00IEEEDk>c]@D51@D50?3`lY:BT2=SHf00HY:BUADE4W
9bLW9bL[:b^3Ph<26ATI00EGEeLi>CTj>SXj>SYKFe/00TY:BP06@410FEUIHf=SHf=SCDe=@D510XF5
Q@06<C4aCTi><30`<30`BTY::RXZ0U]KF`06TY:BTi>C9bLW9bLW71`LKVi^0S4a<@05AdM7M7AdM7Ad
Fe]K<C4a009@D5001T];BbHV9Q`L71`L751@D5aLG0:LW9`01TU9BE=CDdY:BTY:BVIVIWUiN@:2PX80
1IfMWFQXJ6QXJ79bLTU9B@02m_Kf00JGUiMPH61WIfMWIfOIfMTB4Q82Ti>C00IYJFT_;bmPH61PH62R
XZ9QHF42U9BD00EYJFU>CThP820P823oool00[2`/006KFe]ooooi>CTi>CT7AdMC4a<0[fm_@Coool0
0`000?ooooooo`0/oooo00@0003oooooooooool25aLG00Gooom@D52OWinOWila<C400]3@d0063@d=
ooooKFe]KFe]CTi>FEUI0V5QH@06/;2`FUYJE5ADE5AD51@DJFUY0VYZJP05@d=3AdM7AdM7Zj^[RXZ:
009DE5@01WalO9>CTadM7AdM7CLg=f1PH08X:2P01GAdM8B4Q8B4Q3Ph>2LW9`02KFe]00HW9bNGUiL`
<30`<3030`=:BTX2YjNW00Dg=cM]KFd92@T92@U]KFd00X>3P`06?CdmE5AD>CTi>CTiE5AD3@d=0RHV
9P06<c<c;bl_CDe=CDe=820P9RHV0WalO0055ADEGUiNGUiN<c<cA4A4009NGUh01Tm?Ccdm?De=CDe=
CF9RHU1@D08g=cL01I>CTb<S8b<S8d10@3@d=002?clo00H[:b]RHV:EUIFEUIFTY:@b<S828B4Q00Ek
Ng/e=CE1@D51@D65QHD00V][J`06?cloATI6?Cdm?Cdm<c<c6QXJ0T=3@`05DE5AZj^[?3`l?3`lFEUI
009GEeL01U]KFginOXR8R8R8R:NWYemOG`9^KVh01TU9BNk^kXn?Shn?Sf][Jg=cL`;Fe]H01AHF5Y^K
Vi^KVfe]KBl_;`02IVIV00JPX:1MGEfQXJ6QXJ5TI6A2@T82:BTY00GooonTY:AWIfMWIfOoool00_Ge
m@049RHVFe]K`l?3`l?31?ooo`030000oooooooo00goool002;oool00`000?ooooooo`02oooo0Q/K
6`06ooooFe]K[Jf][Jf]820Pf=SH0PL71`03ooooHF5QHF5Q009?Cdl2KFe]00JOWimIFEUQHF5QHF4E
5AEeMGD2LW9b00Hh>3Q0@42h^;Rh^;QkNg]GEeL2KVi^00FLW9`D51@`<30`<31XJ6P00QlO7`06NWYj
Q8B4?Cdm?Cdm7alOIFEU0RLW9`06UIFE=CDe1@D51@D5ADE5XZ:R0S@d=005Jf][20P8KFe]KFe]PX:2
008l?3`01UEEEC/k>e1@D51@D0l?3bTY:@8f=SH01RTY:E5ADBLW9bLW9b/[:h>3P`8I6AT01EMGEcTi
>CXj>SXj>U]KF`02BTY:00I0@41IFEUSHf=SHf==CDe1@D42QHF500Ha<C5>CTh`<30`<31:BTXZ:RX2
Fe]K00JBTY:CTi<W9bLW9bLL71a^KVh2<C4a00E7AdMdM7AdM7AKFe/a<C400U1@D006Bd];9RHV71`L
71`LD51@G5aL0YbLW006BDU9De=CBTY:BTY:IVIVNGUi0X:2PP05WIfMJ6QXJ6QXLW9bBDU900;fm_H0
1YNGUf1PH6MWIfMWImWIfA8B4P:CTi<01VUYJBl_;f1PH61PH::RXV5QH@:DU9@01FUYJDi>CR0P820P
8?ooo`02/;2`00I]KFgooooTi>CTi>@M7Ae<C4`2_Kfm1?ooo`030000oooooooo02coool010000?oo
ooooooooo`8G5aL01Ooooe1@D9nOWinOWc4a<@02d=3@00H=3@gooom]KFe]KFe>CTiIFET2HF5Q00J`
/;1JFUYDE5ADE5@D51AYJFT2JVYZ00E3@d=7AdM7AdN[Zj^:RXX00UADE006O7alTi>C7AdM7AdM=cLg
H61P0RPX:005M7AdQ8B4Q8B4>3Ph9bLW009]KFd01RLW9iNGUc0`<30`<0<30dY:BP:WYjL01CLg=fe]
K@T92@T92Fe]K@02Ph>300Hm?CeDE5@i>CTi>CUDE5@=3@d29RHV00Hc<c<_;bm=CDe=CDdP820V9RH2
O7al00DE5AENGUiNGUhc<c=4A4@00UiNGP06Cdm??CdmCDe=CDe=HV9RD51@0SLg=`05Ti>C8b<S8b<S
@410=3@d008o?cl01R/[:f9RHYFEUIFEUJBTY38b<P8Q8B401G]kNcDe=D51@D51@HF5Q@02Jf][00Ho
?cm6ATHm?Cdm?Cdc<c<J6QX2@d=300EADE6[Zj/l?3`l?3aIFET00UMGE`06Fe]KOWinR8R8R8R8YjNW
GemO0Vi^KP06BDU9k^k^Shn?Shn?Jf][Lg=c0]KFeP055QHFVi^KVi^KKFe];bl_009VIVH01Z2PX5eM
GJ6QXJ6QXFATI492@P8Y:BT01OooojBTY6MWIfMWIoooo`02mOGe00@V9RIKFe_3`l?3`l<4oooo00<0
003oooooool03Oooo`008_ooo`030000oooooooo00;oool2N7Qh0_ooo`9SHf<01M3@d?ooofATI6AT
I:j^[P02J6QX00IhN7Q]KFf:RXZ:RXYoOgnOWil2M7Ad00IHF5SmoOeNGUiNGUijNWX];Bd2UiNG00IF
EUIHF5PC4a<C4a>c/k=bLW82De=C00G=cLf[Zj^[Zj]OGel<30`00Tm?C`069BDUCTi>EeMGEeMG>c/k
OWin0TY:BP068B4QDe=C7alO7alOC4a<IVIV0TQ8B005FEUI=cLg=cLg1@D5G5aL00:FUYH00a8B4VIV
ITe=C@02CDe=00EEEEE:BTY:BTXg=cO5aLD00S`l?005FUYJQ8B4ADE5ADE5<30`008Q8B401ZJVYTa<
C3Ph>3Ph>7emOC4a<@9EEED01T=3@a<C4chn?Shn?TM7AcHf=P8m?Cd01Rl_;g5aLC<c<c<c<c@d=:2P
X0:IVIT01HN7QgYjNWYjNSTi>F9RHP02N7Qh00I?CdlL71aFEUIFEUI1@D5/K6`2ADE500H>3Pi@D51Y
JFUYJFVDU9AHF5P2;bl_00EIFEVFUYJFUYJRXZ8f=SH00/71`@06_;bl5aLGKfm_Kfm_?3`lJFUY0WMg
M`069bLW>c/kKFe]KFe]NGUi@T920XR8R005JVYZ<S8bBDU9BDU9OGem00:_[jl01ZVYZN7QhK6a/K6a
/D51@I6AT@9VIVH01G]kNoooooooooooo`00000^oooo00@0003oooooooooool2R8R80_ooo`9CDe<0
1KVi^OooooooodQ8B9>CT`02RHV900IPH61:BTZZZZZZZZYRHV:_[jl2EUIF00EBDU;^k^i_Kfm_Kfmm
OGd00SHf=P06P820I6ATIFEUIFEU:2PX];Bd0VATI005IVIVcLg=/K6a/K6aE5AD008000001TA4A1`L
759BDU9BDU5ADD92@P9oOgl01Ti>CR4Q8EADE5ADE1`L74e=C@9WIfL01D=3@eADE5ADE3dm?@X:2P02
FUYJ00JNWYh92@U/K6a/K6aIFEU7AdL2Cdm?00Dl?3`_;bnh^;Rh^;Pf=SH00VQXJ006MGEeDE5A8R8R
8R8R71`LV9RH0TQ8B005=SHfL71`:RXZ:RXZEUIF0095ADD01QTI6CPh>4e=CDe=CCXj>S<c<`8h>3P0
1W=cLc`l?3dm?Cdm?JJVYZ2PX0:;Rh/01GalO3Ph>3Ph>6ATI7UiN@02DU9B00HL71aFEUHo?clo?cm_
Kfm1@D422`/;00EKFe]QHF5QHF6;Rh];Bd/00S8b<P06B4Q8QhN7/K6a/K6a820P^[Zj0]GEe@05<C4a
K6a/CTi>CTi>Q8B400:;Rh/01PP824m?Chn?Shn?Sg=cLemOG`:YZJT01U]KFchn?U9BDU9BDV9RH[Vi
^@:5QHD01Kjn_Xj>SXj>STa<C6a/K002T92@00EkNg_oooooooooool000003oooo`008_ooo`030000
oooooooo00Coool01T10@8>3PeiNGUiNGZRXZ?ooo`9iNGT01IRHV75aLG5aLCTi>JRXZ0028R8R00I^
KVhk>c_Bd];Bd]9@D51CDe<2EEEE00K:b/Y?CdnBTY:BTY8P821BDU82JFUY00GUiNF3Ph<92@T92@UN
GUh00R0P8006DE5AUIFE9RHV9RHVQXJ6>c/k0RHV9P06:2PXADE5EeMGEeMG51@D:RXZ0Tm?C`05<c<c
?ShnD51@D51@9RHV009YJFT01Tm?CaLG5f5QHF5QHA@D58>3P`8R8R801SLg=fa/K2XZ:RXZ:R0P85]K
F`8n?Sh01EEEEF=SHh>3Ph>3Pc8b<P02NGUi00I/K6`>3PhU9BDU9BDa<C5hN7P26a/K00HI6ATa<C4R
8R8R8R8];Bdm?Cd2;2`/00IYJFTc<c<?3`l?3`l`<32:RXX2d];B00F7QhMJFUYJFUXW9bLM7Ad00VIV
IP06:b/[=cLgRh^;Rh^;ADE5;2`/0YVIV@06N7Qh7QhN5QHF5QHF]kNgRXZ:0WEeM@05ATI6KFe]KFe]
6a/KVi^K009bLW801[bl_4Y:BWUiNGUiNE5ADAlO7`:IVIT01Rl_;fYZJUADE5ADE1<C4hj>SP9mOGd0
1B4Q8GAdM3Ph>3Ph>9JFUP02>3Ph00JUYJGfm_KooooooonIVIU>CTh2o_kn00FQXJ7oooooooooool0
0000;_ooo`030000oooooooo00?oool01C4a<JZZZWmoOgmoOh^;R`02oooo00IMGEf>SXigMgMgMgLP
822:RXX2?Cdm00J8R8Q8B4S1`L71`L5YJFTk>c/2ADE500GJf]Y?Cdm?Cdn2PX8S8b<00T51@@06O7al
f][JU9BDU9BD4A4AJFUY0R`/;005Fe]KShn?Shn?92@TR8R8008l?3`01R<S8bXZ:TI6ATI6AUQHF1@D
508Y:BT01E9BDS@d=492@T92@U9BDP02820P00I^KViHF5PN7QhN7QiKFe/C4a<2SXj>00HT92@o?cmU
IFEUIFDX:2PG5aL2EEEE00Dc<c=QHF5QHF5IFEUmOGd00RLW9`06MWIfIVIV6ATI6ATI:RXZ9RHV0Vm_
K`056QXJ8B4Q8B4Q>CTi:b/[008b<S801Shn?S0`<6ATI6ATI2h^;Q8B4P8`<3001HJ6Q]7AdH:2PX:2
PUIFEP029bLW00HH61QaLG4Q8B4Q8B52@T:7QhL2@D5100Da<C6XZ:QbLW9bLW8b<S800R/[:`06Xj>S
TY:BGemOGemO>SXjHV9R0QlO7`06PH61GEeMbl_;bl_;ATI6QHF50T51@@05@T92YjNWYjNW4A4AAdM7
009bLW801STi>IJFUZJVYZJVYTY:BUaLG08G5aL01J^[Za0@4:>SXj>SXm7Ad@02l?3`00F2PX8i>CWf
m_Kfm_K2`/800oooo`030000oooooooo00goool0017oool5000000Coool0000000000003oooo00<0
003oooooool00_ooo`030000oooooooo00;oool2IVIV00J4Q8@f=SHZ:RXZ:RYYJFUmOGd2oooo00F@
T91=CDe=CDgShn?1`L400X61P@06<C4a=CDeH61PH61PQHF5ADE50[Fe]@06ooooKfm_Ph>3Ph>3=CDe
^[Zj0WIfMP05=CDeEUIF?Cdm?Cdm=cLg008i>CT01WMgMeYJFRTY:BTY:J>SXgemO@8k>c/01WUiNEaL
G51@D51@D2h^;SPh>08S8b<01EUIFEMGEalO7alO7c8b<P02Rh^;00=WIfM1@D5<C4`00Ta<C005>3Ph
=3@d=3@d:BTY;Rh^009[Jf/01W=cLda<C6UYJFUYJFATI4m?C`9KFe/01D];Bfi^KVi^KVe]KG=cL`02
:BTY00HT92@b<S:?Shn?Shm>CTimOGd2<c<c00HS8b>LW9`S8b<S8b=PH61KFe/2?Shn00DM7AfOWin3
Ph>3Ph<H61P00U9BDP06IfMW=3@dJf][Jf][>3PhJf][0YZJVP06BDU9G5aLYJFUYJFULg=c>3Ph0Tm?
C`05I6ATOGemFUYJFUYJ5aLG009MGEd01UADE9fMWEEEEEEEEKFe]DU9B@9mOGd01]?CdfUYJC4a<C4a
<AlO7f1PH08U9BD01TI6AUiNGUQHF5QHF4=3@mkNgP9[Jf/01G9bLSlo?clo?fi^KU=CD`02oooo00Dl
?3aLG5c_kno_knm_Kfl00oooo`030000oooooooo01_oool5000000Coool0000000000003oooo00<0
003oooooool00_ooo`040000oooooooooooo0T51@@05Hf=S71`LDE5ADE5AJf][009JFUX01^g]kGMg
Mf=SHf=SHlC4a<;2`P:OWil01Ti>CSHf=WalO7alO6e]KB`/;0:VYZH01Oooofa/K6a/K6m_KcLg=`02
[jn_00J;Rh/T92AVIVIVIVHe=CE5ADD2@D5100EnOWi@D51@D50];BfYZJT00XJ6QP03@T92PH61EUIF
009FEUH01C@d=3/k>c/k>adM7EiNGP02CTi>00DQ8B4m?Cdm?Cf6QXITI6@00S/k>`06@D51Fe]K?3`l
?3`l?Cdm8B4Q0SHf=P05GUiNNg]kG5aLG5aLFUYJ009[Jf/01T51@E5ADCdm?Cdm?G]kNgMgM`9`L700
1AXJ6S<c<b/[:b/[:hb<S002FUYJ00J:RXXo?cl_;bl_;bnIVIT[:b/2H61P00IGEeM5ADDJ6QXJ6QZM
WIeoOgl26ATI00E>CTi[Jf][Jf/k>c]WIfL00S<c<`06Hf=STY:BEEEEEEEEFe]KZ:RX0WinOP05:b/[
FUYJFUYJIfMWKVi^0097AdL01R<S8g9bLT10@410@8F5QFMWI`:OWil01Dm?Cg9bL]WIfMWIfGUiN@02
@41000Hg=cMWIfL^;Rh^;RiOGemFEUH2IFEU00I@D52j^[YGEeMGEeMNGUhW9bL2Bd];00EQHF7ooooo
oomTI6B2PX800_ooo`05LG5aoooooooooooo000000ooool001?oool01@000?ooooooooooo`000004
oooo00<0003oool000000oooo`030000oooooooo00;oool2IVIV00J4Q8@f=SHZ:RXZ:RYYJFUmOGd2
oooo00F@T91=CDe=CDgShn?1`L400X61P@06<C4a=CDeH61PH61PQHF5ADE50[Fe]@06ooooKfm_Ph>3
Ph>3=CDe^[Zj0WIfMP05=CDeEUIF?Cdm?Cdm=cLg008i>CT01WMgMeYJFRTY:BTY:J>SXgemO@8k>c/0
1WUiNEaLG51@D51@D2h^;SPh>08S8b<01EUIFEMGEalO7alO7c8b<P02Rh^;00=WIfM1@D5<C4`00Ta<
C005>3Ph=3@d=3@d:BTY;Rh^009[Jf/01W=cLda<C6UYJFUYJFATI4m?C`9KFe/01D];Bfi^KVi^KVe]
KG=cL`02:BTY00HT92@b<S:?Shn?Shm>CTimOGd2<c<c00HS8b>LW9`S8b<S8b=PH61KFe/2?Shn00DM
7AfOWin3Ph>3Ph<H61P00U9BDP06IfMW=3@dJf][Jf][>3PhJf][0YZJVP06BDU9G5aLYJFUYJFULg=c
>3Ph0Tm?C`05I6ATOGemFUYJFUYJ5aLG009MGEd01UADE9fMWEEEEEEEEKFe]DU9B@9mOGd01]?CdfUY
JC4a<C4a<AlO7f1PH08U9BD01TI6AUiNGUQHF5QHF4=3@mkNgP9[Jf/01G9bLSlo?clo?fi^KU=CD`02
oooo00Dl?3aLG5c_kno_knm_Kfl00oooo`030000oooooooo01goool01@000?ooooooooooo`000004
oooo00<0003oool000000oooo`040000oooooooooooo0T51@@05Hf=S71`LDE5ADE5AJf][009JFUX0
1^g]kGMgMf=SHf=SHlC4a<;2`P:OWil01Ti>CSHf=WalO7alO6e]KB`/;0:VYZH01Oooofa/K6a/K6m_
KcLg=`02[jn_00J;Rh/T92AVIVIVIVHe=CE5ADD2@D5100EnOWi@D51@D50];BfYZJT00XJ6QP03@T92
PH61EUIF009FEUH01C@d=3/k>c/k>adM7EiNGP02CTi>00DQ8B4m?Cdm?Cf6QXITI6@00S/k>`06@D51
Fe]K?3`l?3`l?Cdm8B4Q0SHf=P05GUiNNg]kG5aLG5aLFUYJ009[Jf/01T51@E5ADCdm?Cdm?G]kNgMg
M`9`L7001AXJ6S<c<b/[:b/[:hb<S002FUYJ00J:RXXo?cl_;bl_;bnIVIT[:b/2H61P00IGEeM5ADDJ
6QXJ6QZMWIeoOgl26ATI00E>CTi[Jf][Jf/k>c]WIfL00S<c<`06Hf=STY:BEEEEEEEEFe]KZ:RX0Win
OP05:b/[FUYJFUYJIfMWKVi^0097AdL01R<S8g9bLT10@410@8F5QFMWI`:OWil01Dm?Cg9bL]WIfMWI
fGUiN@02@41000Hg=cMWIfL^;Rh^;RiOGemFEUH2IFEU00I@D52j^[YGEeMGEeMNGUhW9bL2Bd];00EQ
HF7ooooooomTI6B2PX800_ooo`05LG5aoooooooooooo000000ooool001?oool00`000?ooooooo`02
oooo00L0003oooooooooool0003oool000000oooo`800002oooo00G`l?2HV9RHV9Sooon=SHd00/g=
c@05_knoh>3Pdm?Cdm?CBd];009fMWH01]CDe6ATI2<S8b<S8iFEUJ2PX0:[Zj/01Fm_Kjf][C4a<C4a
<Kno_`03D51@00HV9RJGUiNe]KFe]KEdM7A`L702J6QX00Dc<c?IfMWIfMU6ATJf][H00TQ8B006QHF5
WinO92@T92@TDU9BPh>30UiNGP06>CTiG5aLCDe=CDe=MgMgPX:20YjNWP05>SXj4a<C4a<C?CdmHf=S
008e=CD01Te=CCHf=VMWIfMWIadM7H:2PP9:BTX01U1@D8V9RGMgMgMgMb8R8QlO7`8T92@01Cdm?EmO
GemOGbHV9PH61P02:BTY00HN7QiLG5abLW9bLW96ATJTY:@2>SXj00Hb<S9UIFDe=CDe=CD];BeMGEd2
H61P00E=CDfCTi=FEUIFEUHY:BT00Q@D5006BDU9>SXjZJVYZJVYIfMWeMGE0UEEE@06I6ATBTY::BTY
:BTY61PH<30`0QTI6@05;Bd]ATI6@D51@D51@d=3009=CDd01VATI3@d=69RHV9RHW=cLh^;R`8L71`0
1RLW9e=CDd=3@d=3@dA4A65QH@8W9bL01Zf][Jj^[TA4A4A4A2l_;m7Ad@:7QhL01JBTY51@D51@D2d]
;K6a/@02EEEE00>_[jlf=SKoool01?ooo`80000Ooooo00<0003oooooool00_ooo`070000oooooooo
oooo0000oooo000000?oool2000000KooooVi^J/[:b/[:cooonVYZH2lO7a00FNWYkAdM7AdM6c/k<g
=cL00UMGE`06]KFePh>37AdM7AdM[Zj^S8b<0[Ng]`05Kfm_Ti>C;2`/;2`/bl_;008k>c/2>CTi0XZ:
RP06cLg=OgmoQhN7QhN7EeMG8R8R0]CDe005FEUIYZJVYZJVFEUISHf=00:b/[801R4Q8F=SHgMgMgMg
MeQHF2XZ:P9/K6`01De=CFUYJH61PH61PIjNWP02;Bd]00HL71``<31TI6ATI6@`<31KFe/2?3`l00If
MWHF5QJ=SHf=SHe3@d=6ATH2VIVI00E[Jf/Z:RXZ:RX/;2`];Bd00S@d=006JFUY<30`1PH61PH6;2`/
9bLW0UUIF@05LW9bAdM7AdM7Zj^[?Cdm008h>3P01VMWIcHf=S4a<C4a<EaLG6=SH`9<C4`01IBDU5IF
ERXZ:RXZ:QLG5`02C4a<00Ho?cn`/;1YJFUYJFWGemMHF5P2H61P00Do?cl_;blR8R8R8R8a<C400QdM
7@06?Shn@T92;Rh^;Rh^D51@GEeM0Tm?C`06820PMGEeNWYjNWYjNg]k3Ph>0R<S8`05Fe]KDU9BDU9B
GEeMLg=c008G5aL01YFEUM3@d2`/;2`/;59BD[Ng]`9ZJVX01Hb<S2d];@X:2PX:2Xn?S`02MGEe00>B
TY93@d?oool01?ooo`80000?oooo000Coooo00<0003oooooool00_ooo`070000oooooooooooo0000
oooo000000?oool00`000?ooooooo`02oooo0Z>SX`06fm_KDe=Cm?Cdm?CdYZJV2PX:0X:2PP05HF5Q
W9bLW9bLWinOiNGU00:j^[X01Rl_;ooook^k^k^k^jBTY4A4A09`L7001/S8b820P79bLW9bLZ>SXd10
@0:CTi<01Fa/K6UYJDA4A4A4A7]kN`02b/[:00IeMGE>CThT92@T92AADE4e=CD2Ogmo00ITI6AhN7Re
]KFe]KDh>3P[:b/28R8R00F@T91UIFEMGEeMGEdM7Ad00WIfMP06IVIV9RHV:RXZ:RXZHV9RJVYZ0T=3
@`06WinO92@TCDe=CDe=J6QXP8200W=cL`05Shn?820PMgMgMgMg<c<c008e=CD01SLg=d92@Ve]KFe]
KEUIFCdm?@9EEED01U5ADJVYZBd];Bd];H:2PQdM7@97AdL01U1@D3Xj>Ta<C4a<C7emOD10@08_;bl0
1Fa/K2/[:b/[:b<S8clo?`02_[jn00IFEUKPh>1?Cdm?CdnDU9B:RXX2YZJV00IOGelV9RHa<C4a<C62
PX9SHf<2;bl_00ERHV8`<30`<31XJ6P@41000V5QH@06J6QXCdm?51@D51@D>CTiP8200X>3P`06;bl_
PX:2[jn_[jn_;Rh^YJFU0_ooo`05emOGDe=C^[Zj^[ZjLW9b00:<S8`01YZJVWemOKfm_Kfm_M[JfVYZ
JP9hN7P01J6QXOooooooooooo`00000Ooooo00<0003oooooool00_ooo`070000oooooooooooo0000
oooo000000?oool010000?ooooooooooo`:HV9P01OooogIfM_ooooooohJ6QP02:2PX00IXJ6R3Ph>M
WIfMWIfATI7oool2V9RH00I=CDgjn_[Ng]kNg]j<S8`j>SX2U9BD00FXZ:QUIFEUIFEBDU;1`L400R8R
8P06ZJVYNWYjJ6QXJ6QXADE5H61P0[:b/P05HV9RBDU9BDU9<S8bFEUI0092@T801Vi^KU=CDfe]KFe]
KJJVYRPX:08c<c<01ADE5HR8R5]KFe]KFeIFEP025ADE00IiNGU^KVhS8b<S8b<Y:BUWIfL2JVYZ00I5
ADFQXJ4T92@T92A=CDe[Jf/2Ogmo00EgMgN=SHf=SHdO7ameMGD00Rh^;P06>c/k<c<c?3`l?3`lJ6QX
H61P0T10@005C4a<G5aLG5aLXJ6Q;Rh^009iNGT01Q8B4Slo?dI6ATI6ATE5ADm?C`:0P8001DU9BC0`
<75aLG5aLCDe=@026a/K00I7AdO7alMBDU9BDU;Vi^IDE5@2T92@00F;Rh^/[:aMGEeMGEdY:BT00S@d
=006Ph>3I6AT;Bd];Bd]IfMW<S8b0W1`L0064A4AJf][GemOGemOA4A47AdM0SPh>005LW9bQhN7QhN7
@410OWin00:d];@01T92@[2`/?;bl_;bl/W9bC/k>`:XZ:P01EYJFXZ:RXf=SHf=SFYZJP02gMgM00G8
b<Q;Bd^JVYZJVYZCTi<00oooo`030000oooooooo00goool001?oool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oool000000oooo`030000oooooooo00;oool2Xj>S00KKfm]CDe?dm?Cdm?BV
YZH:2PX2PX:200EQHF6LW9bLW9bOWioUiND00[Zj^P06;bl_oooo^k^k^k^kY:BTA4A40W1`L006b<S8
P820LW9bLW9bXj>S@4100Y>CT`05K6a/JFUYA4A4A4A4Ng]k00;:b/X01WEeMDi>CR@T92@T955ADCDe
=@9oOgl01VATI7QhN;Fe]KFe]CPh>2/[:`8R8R801I2@T6EUIEeMGEeMGAdM7@02MWIf00IVIVHV9RHZ
:RXZ:RYRHV9ZJVX2@d=300JOWilT92A=CDe=CDeXJ6R0P802Lg=c00F?ShlP821gMgMgMgLc<c<00SDe
=@06=cLg@T92KFe]KFe]FEUI?Cdm0UEEE@06DE5AZJVY;Bd];Bd]PX:27AdM0TM7A`06D51@>SXjC4a<
C4a<OGem@4100Rl_;`05K6a/:b/[:b/[8b<S?clo00:n_[h01UIFE^3Ph4m?Cdm?CiBDU8Z:RP:VYZH0
1UmOGbHV9S4a<C4a<H:2PV=SH`8_;bl01F9RHS0`<30`<6QXJ10@4002HF5Q00IXJ6Q?CdlD51@D51@i
>CV0P802Ph>300H_;bn2PX:_[jn_[jl^;RjUYJD2oooo00GGemMCDe>j^[Zj^[YbLW800Xb<S006VYZJ
OGem_Kfm_Kfmf][JJVYZ0WQhN005XJ6Qoooooooooooo000001ooool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oool000000oooo`040000oooooooooooo0YRHV005ooooMWIfooooooooQXJ6
008X:2P01VQXJ8>3PifMWIfMWI6ATOooo`:HV9P01Te=CO[jn]kNg]kNgXb<S3Xj>P:DU9@01JRXZ6EU
IFEUIE9BD/71`@028R8R00JYZJUjNWYXJ6QXJ6Q5ADEPH602/[:b00ERHV99BDU9BDTb<S9IFET00T92
@P06KVi^De=CKFe]KFe]YZJV:2PX0S<c<`055ADER8R8Fe]KFe]KEUIF008E5AD01WUiNFi^KR<S8b<S
8bTY:FMWI`9ZJVX01TE5AJ6QXB@T92@T94e=CF][J`9oOgl01GMgMhf=SHf=SAlO7gEeM@02;Rh^00Hk
>c/c<c<l?3`l?3aXJ6QPH602@41000E<C4aLG5aLG5bQXJ4^;Rh00WUiN@064Q8B?cloATI6ATI6ADE5
Cdm?0X20P005BDU9<30`LG5aLG5a=CDe008K6a/01TM7AlO7ae9BDU9BD^KViUADE0:@T9001H^;Rjb/
[5eMGEeMGBTY:@02=3@d00J3Ph=TI6@];Bd];BeWIfLb<S82L71`00HA4A5[Jf]OGemOGem4A4@M7Ad2
>3Ph00EbLW:7QhN7QhM0@41nOWh00[Bd]006@T92/;2`l_;bl_;bbLW9>c/k0ZRXZ005FUYJRXZ:SHf=
SHf=JVYZ00;MgMd01LS8b4];BiZJVYZJVY>CT`03oooo00<0003oooooool03Oooo`004_ooo`800004
oooo00<0003oooooool00_ooo`030000oooooooo00;oool01@000?oooooooooookbl_003oooo00GC
dm=SHf=SHf<S8b=8B4P00YVIV@05P820W9bLW9bL^;Rhoooo009/K6`01_gmoCdm?IfMWIfMWGemO@d=
3@9iNGT01Ve]KIJFUVQXJ6QXJ;Ng]d];B`9MGEd01EYJFW1`L61PH61PH3`l?002j>SX00I8B4Pd=3B=
SHf=SHeGEeO5aLD2_[jn00JPX:0];Bg1`L71`L5EEEDQ8B42I6AT00Fd];Bh^;PW9bLW9bNBTY800Z6Q
X@06C4a<HF5QQhN7QhN78R8R@d=30U=CD`06S8b<L71`5QHF5QHF6QXJLG5a0RLW9`05FUYJGUiN9bLW
9bLWATI6009;Bd/01RTY:IJFUR8R8R8R8WQhN2XZ:P:ATI401TI6AShn?QhN7QhN7T10@8R8R09KFe/0
1W=cLfUYJChn?Shn?T=3@bXZ:P8>3Ph01InOWb@T92@T92`/;5=CD`02IfMW00I8B4PS8b=7AdM7AdMk
Ng]dM7@29bLW00I`L70>3PiVIVIVIVJe]KE5ADD2J6QX00GKfm]1@D51@D5DE5@a<C400UADE006F5QH
/K6a4Q8B4Q8B>SXjQ8B40Y:BTP06@D51/k>cAdM7AdM7/;2`oooo0ZRXZ005ooooNg]k/[:b/[:b?3`l
00;:b/X01GIfM[bl_7EeMGEeMDQ8B007oooo00<0003oooooool07?ooo`800004oooo00<0003ooooo
ool00_ooo`030000oooooooo00;oool010000?ooooooon7Qh@?oool01>3Ph3hn?Shn?Q/K6`8_;bl0
1/G5aFQXJ=?Cdm?Cdkjn__ooo`91@D401]OGebLW9lG5aLG5aF9RHR8R8P:DU9@01F5QHFa/K6a/K5AD
E;no_`02Lg=c00J4Q8B0P81HF5QHF5Q1@D59BDT2c/k>00EUIFDK6a/K6a^XZ:QNGUh00]3@d006/[:b
UiNG8R8R8R8R]kNgCTi>0QDE5@05IFEU[Jf]]KFe]KFe;Rh^00:?Shl01Z2PX4e=CFATI6ATI8F5QB8R
8P9:BTX01U9BDXJ6QVm_Kfm_K`d=3B@T909]KFd01C8b<U1@D51@D5MGEbPX:002?Cdm00IHF5PU9BF9
RHV9RHTE5AF3Ph<29RHV00F7QhM?Cdm?Cdla<C4K6a/00Shn?P06P820De=CJFUYJFUYMGEe>3Ph0TU9
B@05<c<c51@DYjNWYjNW:2PX008_;bl01UEEEFUYJDM7AdM7AbLW9dY:BP9nOWh01Fm_Kb4Q8GYjNWYj
NPT92@02L71`00K2`/9BDU9LG5aLG5c[jn]CDe<2JVYZ00HI6AU]KFdm?Cdm?CfKVi/D51@2?3`l00EU
IFF<S8b<S8a>CTj>SXh00SPh>006dM7Am_KfShn?Shn?j^[ZCdm?0X^;R`05K6a/[Zj^NGUiNGUik^k^
009RHV801ADE5O?cloooooooomKFeP03oooo00<0003oooooool03Oooo`008_ooo`030000oooooooo
00;oool2NWYj00KBd]9EEEGooooooooQhN5cLg<2BTY:00Gjn_Zo_kno_klj>SYVIVH00/;2`P06Ph>3
EEEEW9bLW9bL?CdmEEEE0ZJVYP06C4a<61PHVYZJVYZJ[jn_@4100]WIf@05WYjNKVi^/[:b/[:bP820
008F5QH01U5ADE1@D3<c<c<c<bd];NOWi`9?Cdl01UeMGClo?dm?Cdm?Cda<C3<c<`9DE5@01Ng]kI>C
TdY:BTY:BWinOP02De=C00HK6a/c<c=kNg]kNg/?3`m3@d<2M7Ad00H];Bdn?Sk>c/k>c/j@T91hN7P2
:RXZ00Da<C52@T9OGemOGeli>CT00QdM7@0671`L61PHB4Q8B4Q8_;blOGem0T92@P06HF5Q?cloJFUY
JFUY>SXjCDe=0X^;R`06AdM7?Cdm=CDe=CDe9RHVHf=S0VEUI@05;2`/D51@D51@I6AT9bLW00:IVIT0
1T=3@bh^;VEUIFEUIHJ6QWIfMP9XJ6P01R@T90l?3g1`L71`L8^;Ri^KV`:/[:`01LO7ahj>SXj>SUeM
GFe]K@03FEUI00EmOGeIFEUIFEVRXZ:c/k<00SDe=@06OGem_;blX:2PX:2PQhN7R8R80T51@@05KVi^
YJFUIVIVIVIV>c/k009BDU801]SHf:FUY@D51@D51Di>C_7al@Koool00`000?ooooooo`0/oooo00@0
003oooooooooool2K6a/00G8b<QRHV;oooooooobl_800WYjNP06D51@jn_[eMGEeMGE=CDeEEEE0[Ng
]`06O7alJ6QXV9RHV9RHDU9B@T920[Fe]@05Hf=S7AdM7AdMRXZ:WYjN009GEeL01^k^k[Jf]UaLG5aL
G:BTY9RHV08820P01E]KFdU9BDU9BDQ8B410@002nOWi00IGEeMTI6@h>3Ph>3Q5ADDn?Sh29RHV00EM
GEgRh^:CTi>CTi=2@T800WEeM@06GEeM9BDU<c<c<c<cP8203Ph>0Slo?`06K6a/;2`/>CTi>CTibLW9
V9RH0W9bLP05<30`>3Ph>3PhA4A4FUYJ008c<c<01QLG5aDE5A@D51@D551@D;Rh^0:6QXH01C`l?6YZ
JVYZJSPh>6QXJ002?3`l00IDE5B8R8QBDU9BDU8h>3Po?cl26a/K00E`L71VIVHg=cLg=cMCDe<00UUI
F@067AdMTi>CCTi>CTi>>c/kKVi^0X:2PP05KFe]KVi^;Rh^;Rh^2PX:009eMGD01Xn?Sj6QXJFUYJFU
YL;2`Xn?S`9HF5P01VUYJEeMGEQHF5QHF7UiNEYJFP:RXZ801KZj^S8b<S8b<X20P;Zj^P02XZ:R00J4
Q8B8R8Po?clo?cm/K6bQXJ42I6AT00Dd=3A;Bd_Ti>CTi>BXZ:P00PX:2P03@d=3j>SXoooo00Goool0
0`000?ooooooo`0=oooo000Roooo00<0003oooooool01?ooo`04Ti>Coooo^k^k^k^k0_ooo`:JVYX0
1GmoOdM7AdM7Ao[jn^k^kP02<S8b00IXJ6P^;RjRXZ:RXZ9MGEf_[jl2K6a/00IkNg^IVIWZj^[Zj^YD
E5APH602h^;R00EJFUY>CTjIVIVIVIV>SXh00ZVYZ@06Ti>C>c/k:2PX:2PX?clo7AdM0U9BDP06GEeM
K6a/JFUYJFUY_[jnCTi>0Shn?P05l_;bXj>S8R8R8R8R@d=3009:BTX01U1@D3@d=2TY:BTY:@h>3WIf
MP90@4001W9bLRl_;iRHV9RHV6ATI3/k>`8Y:BT01EADE3`l?9fMWIfMWGinOP028b<S00JTY:@O7an9
RHV9RHU5ADDO7al2?3`l00JRXZ8];BeoOgmoOglQ8B5QHF42PX:200HV9RI:BTYCDe=CDe=mOGf=SHd2
IFEU00E5ADETI6ATI6A4A4@a<C400Z>SX`06MWIfJf][9RHV9RHVKfm_=CDe0VQXJ006<S8bS8b<Ph>3
Ph>3O7algMgM0WalO005o?clZj^[Zj^[IFEUQhN700:XZ:P01WMgMd51@ADE5ADE5B`/;861P@::RXX0
1X:2PTe=CO[jn_[jnX:2PSdm?@8j>SX01?ooob@T93lo?clo?`Goool2][Jf00GIfMWoooooooooooo>
c/h00oooo`030000oooooooo02coool00`000?ooooooo`03oooo00BDU9CoooogmoOgmoL3oooo00IX
J6QnOWifMWIfMWKLg=coool22@T900JNWYh>3PimOGemOGde=CF][Jd2@41000E`L71lO7alO7c1`L4e
=CD00X>3P`06m_KfP820IVIVIVIVZZZZXZ:R0YBDU005SXj>:b/[:b/[4A4AD51@008a<C401UQHF4e=
CEeMGEeMGEYJFZn_[`8o?cl01C0`<>_[ji^KVi^KVa@D5002ADE500IEEEECDe<j>SXj>SXa<C4N7Qh2
IfMW00H];BeOGel`<30`<325QHEWIfL2C4a<00DF5QI]KFe]KFda<C66QXH00Ve]K@06=cLgT92@820P
820PKfm_;Rh^0S0`<0058B4QV9RHV9RH?CdmQhN7008<30`01UMGEhb<S0l?3`l?3dY:BVYZJP9fMWH0
1INGUgYjNTi>CTi>CWQhN002<S8b00Hd=3BUYJEWIfMWIfMkNg/H61P2Hf=S00DY:BUKFe/m?Cdm?Cf2
PX800WIfMP06JVYZbl_;OgmoOgmonOWiWIfM0UMGE`06MgMgXZ:RV9RHV9RHGUiN4Q8B0SLg=`>1PH40
1UeMGF1PH?oooooooeMGEb@T909KFe/01?ooobl_;dE5ADE5A@Coool01>WYjHR8R8R8R=_Kf`?oool0
1Kbl_?ooooooooooo`00000?oooo000Roooo00<0003oooooool01?ooo`04Ti>Coooo^k^k^k^k0_oo
o`:JVYX01GmoOdM7AdM7Ao[jn^k^kP02<S8b00IXJ6P^;RjRXZ:RXZ9MGEf_[jl2K6a/00IkNg^IVIWZ
j^[Zj^YDE5APH602h^;R00EJFUY>CTjIVIVIVIV>SXh00ZVYZ@06Ti>C>c/k:2PX:2PX?clo7AdM0U9B
DP06GEeMK6a/JFUYJFUY_[jnCTi>0Shn?P05l_;bXj>S8R8R8R8R@d=3009:BTX01U1@D3@d=2TY:BTY
:@h>3WIfMP90@4001W9bLRl_;iRHV9RHV6ATI3/k>`8Y:BT01EADE3`l?9fMWIfMWGinOP028b<S00JT
Y:@O7an9RHV9RHU5ADDO7al2?3`l00JRXZ8];BeoOgmoOglQ8B5QHF42PX:200HV9RI:BTYCDe=CDe=m
OGf=SHd2IFEU00E5ADETI6ATI6A4A4@a<C400Z>SX`06MWIfJf][9RHV9RHVKfm_=CDe0VQXJ006<S8b
S8b<Ph>3Ph>3O7algMgM0WalO005o?clZj^[Zj^[IFEUQhN700:XZ:P01WMgMd51@ADE5ADE5B`/;861
P@::RXX01X:2PTe=CO[jn_[jnX:2PSdm?@8j>SX01?ooob@T93lo?clo?`Goool2][Jf00GIfMWooooo
ooooooo>c/h00oooo`030000oooooooo02coool00`000?ooooooo`03oooo00BDU9CoooogmoOgmoL3
oooo00IXJ6QnOWifMWIfMWKLg=coool22@T900JNWYh>3PimOGemOGde=CF][Jd2@41000E`L71lO7al
O7c1`L4e=CD00X>3P`06m_KfP820IVIVIVIVZZZZXZ:R0YBDU005SXj>:b/[:b/[4A4AD51@008a<C40
1UQHF4e=CEeMGEeMGEYJFZn_[`8o?cl01C0`<>_[ji^KVi^KVa@D5002ADE500IEEEECDe<j>SXj>SXa
<C4N7Qh2IfMW00H];BeOGel`<30`<325QHEWIfL2C4a<00DF5QI]KFe]KFda<C66QXH00Ve]K@06=cLg
T92@820P820PKfm_;Rh^0S0`<0058B4QV9RHV9RH?CdmQhN7008<30`01UMGEhb<S0l?3`l?3dY:BVYZ
JP9fMWH01INGUgYjNTi>CTi>CWQhN002<S8b00Hd=3BUYJEWIfMWIfMkNg/H61P2Hf=S00DY:BUKFe/m
?Cdm?Cf2PX800WIfMP06JVYZbl_;OgmoOgmonOWiWIfM0UMGE`06MgMgXZ:RV9RHV9RHGUiN4Q8B0SLg
=`>1PH401UeMGF1PH?oooooooeMGEb@T909KFe/01?ooobl_;dE5ADE5A@Coool01>WYjHR8R8R8R=_K
f`?oool01Kbl_?ooooooooooo`00000?oooo000Roooo0P0000Goool01/c<c7]kNoooooooocHf=]WI
f@;oool01MWIfOoooooood];BcTi>@02C4a<00K>c/hm?Cd^;Rh^;RjQXJ79bLT2jNWY00JNWYkkno^l
_;bl_;`d=3B<S8`2a<C400EOGen7QhM9BDU9BDURHV800/W9b@06Fe]KSXj>F5QHF5QHIFEUPh>30TY:
BP04L71`HV9RUIFEUIFE0YZJVP:1PH401EIFEWinOXR8R8R8R4I6AP025QHF00HS8b=UIFDP820P820U
9BEVIVH2Cdm?00I9BDU1@D5bLW9bLW9mOGeSHf<2>CTi00E<C4`X:2QOGemOGemKFe/00TQ8B006NGUi
DE5AIFEUIFEU7QhNIfMW0T92@P06PH611@D5?Cdm?Cdm7alO;Rh^0XJ6QP06UiNGLg=c=3@d=3@dRHV9
NWYj0TY:BP05;Bd]PH61PH61I6AT30`<00:m_Kd01U1@D7QhN7YjNWYjNShn?U9BDP8c<c<01SHf=UeM
GMgMgMgMgE1@D:j^[P:<S8`01OooohN7QhN7QhF5QA8B4P02o_kn00JIVIUQHF6EUIFEUIE9BDV9RHT2
@T9200IMGEdO7aoBd];Bd]9:BTX20P82Ph>300GooonJVY[1`L71`L5mOGd00_ooo`04m_Kfe]KFd];B
d];B1oooo`80000^oooo0P0000Coool01O[jn[6a/Ooooooooc0`<002Z:RX00Koooo^k^kclo?clo<h
>3Po?cl2Ng]k00JUYJD_;bl>3Ph>3Pj:RX[>c/h2fm_K00Fc/k?Kfm_Kfm^QXJ4F5QH00YfMW@06d=3@
NWYjVi^KVi^KGEeMCTi>0[Vi^@05Cdm?PH61PH61IfMWJFUY00:8R8P01U9BDV][JeeMGEeMGI6ATIJF
UP:IVIT01GmoOe9BDWQhN7QhN92@T002CTi>00H<30`H61Q]KFe]KFdB4Q8I6AT2FEUI00I0@40l?3aA
DE5ADE5RHV::RXX2LG5a00DZ:RYNGUiNGUhE5AEFEUH00VATI006BDU9J6QXCdm?Cdm?HF5Q;bl_0WQh
N005<30`L71`L71`30`<Cdm?008/;2`01Rl_;iBDU8^;Rh^;RgUiND10@09oOgl01H61PDi>CSPh>3Ph
>8V9R@02K6a/00HA4A71`L58B4Q8B4Q/K6aiNGT2;bl_00E3@d<R8R8`<30`<31SHf<00/S8b006DE5A
VYZJMWIfMWIfooooJf][0Ve]K@064A4Aoooo_kno_knoI6ATYJFU0T=3@`05YZJVD51@D51@>c/kBd];
00:j^[X01Rd];C8b<WEeMGEeMMCDe<k>cP;4a<@01Da<C?ooon_[jn_[jmWIf@02bl_;1oooo`80000?
oooo000Roooo00<0003oooooool00_ooo`;hn?P00o[jn/k>c_ooo`02oooo00C:b/[IfMWIfMUTI6@2
oooo00J[Zj^^[ZkWinOWinOalO5oOgl2820P00HD51A3@d=jNWYjNWZ?Sho<c<`2_Kfm00Hd=3ANGUkY
jNWYjNTN7Qhe=CD2M7Ad00EgMgMSHf=SHf>DU9A4A4@00T=3@`0651@DWinO2@T92@T9De=CAdM70R@T
9006YZJVD51@ATI6ATI6;Bd]Ogmo0Z^[Z`05HV9R9BDU9BDU<30`H61P009dM7@01UEEEFQXJ69RHV9R
HPl?3bh^;P9QHF401Xf=SD=3@dY:BTY:BSPh>38b<P90@4001@P824A4A4A4A5EEED51@@02<S8b00I3
@d<e=CETI6ATI6Bf][Hd=3@2;Bd]00IADE5HF5Pe=CDe=CFCTi=FEUH2>c/k00E?Cdm^KVi8B4Q8B4Qa
LG400UADE006BTY:EeMG^KVi^KViHV9RMWIf0Ve]K@06F5QH:BTYc<c<c<c<PX:2P8200UYJFP05Rh^;
gMgMW9bLW9bLH61P00:i^KT01T51@KZj^_ooooooode=CLc<c0:>SXh01UaLG?Ogmn7QhN7QhHN7QeQH
F0;lo?`01[:b/VMWIng]kNg]kK:b/_knoP9BDU83oooo00?Vi^K`l?3oool00_ooo`04g]kNoooooooo
MgMg0oooo`030000oooooooo02coool00`000?ooooooo`03oooo00G@d=2LW9cooooooooFe]H00]oO
g`06[:b/UIFEjNWYjNWYfMWImoOg0/;2`P06aLG5L71`=CDe=CDeBDU9<c<c0[Fe]@05Hf=STi>CTi>C
V9RH51@D009EEED01^GUiDM7Abh^;Rh^;V][JiZJVP9<C4`01IRHV5aLG5aLG5iNGRLW9`02^;Rh00HC
4a=VIVHn?Shn?ShT92BXZ:P2FEUI00Do?clW9bMjNWYjNWZb/[800VQXJ0068R8R:b/[JVYZJVYZJFUY
Fe]K0Ve]K@06DU9B8B4Q=CDe=CDeJf][W9bL0UiNGP05>c/k@d=3@d=3:2PXFe]K008G5aL01C`l?3Ti
>Di>CTi>CTm?C`03ADE500EhN7Rk^k^k^k/T92@Q8B400Sdm?@06Bd];BTY:QHF5QHF5Cdm?ATI60TE5
A@05Kfm_EEEEJVYZJVYZC4a<009@D5001Tm?Ckbl_61PH61PH79bLV=SH`9:BTX01CHf=[Vi^IbLW9bL
W7moO`02@D5100IlO7cIfMV9RHV9RHUWIfOHf=P2;Rh^00K/k>cooom<C4a<C4cFe]JUYJD2S8b<00G4
a<CooooooomQHF4V9RH00]kNgP06RXZ:E5ADYJFUYJFUoooo/[:b0V9RHP;oool2a<C400?<c<cooooo
ool01?ooo`05?clooooooooooooo000000ooool002;oool00`000?ooooooo`04oooo00>n_[kooooo
ool00_ooo`04RHV9iNGUiNGU?clo0QDE5@06>CTi[Jf]h^;Rh^;R@D51NWYj0X61P@06GEeM4a<C[Zj^
[Zj^d];BVi^K0/W9b@06@T92?ShnLW9bLW9bP820@T920/[:bP05aLG54Q8B4Q8BPX:2De=C008L71`0
1Q4A4F][JeMGEeMGEb8R8QPH608g=cL01Y6ATFi^KT];Bd];Be9BDVYZJP9`L7001D];Bdi>CTi>CWAd
M3Hf=P02RXZ:00IoOglP820Y:BTY:BTd=3A2@T82@D5100HU9BESHf<c<c<c<c<l?3`I6AT230`<00E1
@D4Z:RXZ:RYADE4f=SH00Va/K00651@D;Rh^<30`<30`=CDeIfMW0WemO@06@D51D51@F5QHF5QH?Shn
3Ph>0VQXJ005EUIFKfm_MWIfMWIf?clo009lO7`01Q0@45UIFCTi>CTi>EmOGiFEU@8b<S801STi>EIF
EUeMGEeMGEaLG5QHF09@D5001FQXJ:2PX4A4A4A4A;>c/`02[Jf]00JGUiMUIFFJVYZJVYYdM7Bo_kl2
A4A400IbLW9cLg?ooooooom7AdNZZZX2DU9B00Fn_[kAdM7Kfm_Kfm_Cdm<00oooo`03I6ATOWinOWin
00Coool00lk>c_ooooooo`05oooo00<0003oooooool0;?ooo`030000oooooooo00?oool00iNGUooo
ooooo`02oooo0Z:RXP06^k^k;Bd]?Shn?ShnIFEUTI6A0_knoP06AdM7LG5a[Jf][Jf]Q8B47alO0Zn_
[`05`<30MWIfMWIf/[:b<30`009JFUX01WalO6=SHb<S8b<S8jn_[lk>cP8@41001HB4Q4m?Cdm?CaHF
5R8R8P02EEEE00IADE4C4a<E5ADE5ADo?cn3Ph<2Ng]k00E3@d=;Bd]QHF5QHF5jNWX00TY:BP06EEEE
MGEe=SHf=SHfQXJ6Ph>30RDU9@069bLW;Rh^@d=3@d=3BDU971`L0V9RHP05<c<c>c/k>c/k92@T5ADE
008i>CT01SHf=UaLG4=3@d=3@f][Jb0P808d=3@01BTY:DA4A4A4A5YJFWUiN@02BTY:00I9BDU@D50b
<S8b<S8H61Q_Kfl2Bd];00EfMWIZJVXb<S8b<S9`L7000PL71`06CDe=@T92JFUYJFUYUiNG9bLW0Rh^
;P05H61PDU9BJ6QXJ6QXHV9R0094A4@01UmOGijNWS/k>c/k>lC4a;^k^`:XZ:P01Vi^KZBTY8>3Ph>3
Pkno_c8b<P9MGEd01HR8R?ooooooocPh>;Bd]002EUIF00F_[joFe]KWinOWinNh^;P00oooo`03HF5Q
FUYJoooo00Coool00l71`Oooooooo`05oooo00<0003oooooool03Oooo`008_ooo`030000oooooooo
00Coool00kjn__ooooooo`02oooo00B9RHWUiNGUiNDo?cl25ADE00Hi>CV][JgRh^;Rh^91@D5jNWX2
PH6100IMGEdC4a>^[Zj^[ZkBd]:KVi/2bLW900I2@T8n?SibLW9bLW:0P812@T82b/[:00G5aLDB4Q8B
4Q:2PX9CDe<00Q`L70064A4AJf][EeMGEeMG8R8R61PH0SLg=`06TI6AKVi^Bd];Bd];DU9BJVYZ0W1`
L005Bd];CTi>CTi>M7Ad=SHf00::RXX01WmoOb0P82TY:BTY:C@d=492@P91@D401RDU9F=SHc<c<c<c
<c`l?1TI6@8<30`01D51@BXZ:RXZ:U5ADCHf=P02K6a/00HD51@^;Rh`<30`<30e=CEWIfL2OGem00I1
@D5@D51HF5QHF5Pn?Sh>3Ph2J6QX00EFEUI_KfmfMWIfMWHo?cl00WalO006410@FEUI>CTi>CTiGemO
UIFE0S8b<P06>CTiEUIFGEeMGEeMG5aLF5QH0U1@D005J6QXX:2PA4A4A4A4/k>c00:][Jd01YNGUfEU
IIZJVYZJVWAdM;no_`94A4@01W9bLW=cLoooooooodM7AjZZZP9BDU801Kjn_]7AdM_Kfm_Kfm?Cd`03
oooo00=TI6AnOWinOWh01?ooo`03c/k>oooooooo00Goool00`000?ooooooo`0/oooo00<0003ooooo
ool00oooo`03UiNGoooooooo00;oool2XZ:R00Jk^k/];Bdn?Shn?SiUIFFATI42o_kn00I7AdMaLG6]
[Jf][Jf4Q8@O7al2[jn_00G0`<1fMWIfMWJb/[8`<3000UYJFP06O7alHf=S8b<S8b<S[jn_c/k>0Q0@
4005Q8B4Cdm?Cdm?5QHF8R8R009EEED01U5ADA<C4aDE5ADE5Clo?h>3P`9kNg/01D=3@d];Bf5QHF5Q
HGYjNP02BTY:00IEEEEeMGDf=SHf=SJ6QXJ3Ph<29BDU00HW9bL^;Ri3@d=3@d=9BDTL71`2HV9R00Dc
<c<k>c/k>c/T92@E5AD00STi>@06=SHfG5aL@d=3@d=3Jf][820P0S@d=005:BTYA4A4A4A4FUYJNGUi
009:BTX01TU9BE1@D38b<S8b<QPH66m_K`9;Bd/01GIfMVYZJS8b<S8b<W1`L0021`L700I=CDe2@T9Y
JFUYJFVGUiLW9bL2;Rh^00EPH61BDU9XJ6QXJ6QRHV800TA4A006GemOWYjN>c/k>c/ka<C4^k^k0ZRX
Z006KVi^Y:BTPh>3Ph>3_kno<S8b0UeMG@05R8R8oooooooo>3Ph];Bd009FEUH01Jn_[mKFe^OWinOW
ikRh^003oooo00=QHF5JFU[oool01?ooo`03`L71oooooooo00Goool00`000?ooooooo`0=oooo000R
oooo00<0003oooooool01_ooo`;YjNT4oooo00GGemMLG5aLG5bn_[iDE5@00YJFUP06ooooCDe=^KVi
^KVi>3Phg=cL0UUIF@06o?cl4a<CQhN7QhN7:BTY[:b/0UmOG`05UIFE/[:bRh^;Rh^;e=CD00:2PX80
1T92@U=CDf1PH61PH9FEUDY:BP:QXJ401VATI4m?ChR8R8R8R4=3@a8B4P8b<S801D10@9NGUd92@T92
@W]kN`021PH600Hb<S:>SXhB4Q8B4Q9_KfmDE5@2PH6100Hm?Ce<C4a>CTi>CTj1PH4Y:BT2=3@d00D`
<31SHf=5ADE5ADDi>CT00UaLG006U9BD0P82RXZ:RXZ:K6a/SHf=0T51@@06DE5AZZZZL71`L71`=cLg
@d=30V9RHP06[Jf]Bd];IfMWIfMWa<C4KVi^0XR8R0059BDUUiNGUiNGPX:2KVi^009SHf<01TE5AA`L
76MWIfMWIaPH65aLG0:3Ph<01TY:BVEUIC`l?3`l?5]KFjNWY`8M7Ad01MGEeMWIfMWIfFMWI`L71`02
]kNg00JKVi_jn_[IfMWIfMU9BDT/;2`2YJFU00K^k^kooomdM7AdM7A/K6b:RXX2no_k00F_[jn7QhNd
];Bd];Bh^;P00[fm_@coool00`000?ooooooo`0/oooo00<0003oooooool02oooo`05?Cdmoooooooo
HV9Rj>SX008H61P01_ooodY:BY6ATI6ATJj^[WUiN@9ADE401Oooofi^KVi^K^g]kIjNWP02NWYj00J[
Zj]LG5bSXj>SXj>j^[Z2PX82>SXj00DF5QJ7QhN7QhLS8b?>c/h00Tm?C`06Rh^;A4A4<S8b<S8bLg=c
FEUI0Q4A4@05>c/kB4Q8Vi^KVi^KAdM700:0P8001PX:2S`l?:JVYZJVYR<S8eIFEP9<C4`01UeMGDY:
BRDU9BDU9AlO7kFe]@9NGUh01CDe=C4a<C4a<FEUIEeMG@02GUiN00Hm?CeXJ6Pn?Shn?Sk9bLTd=3@2
[Zj^00DQ8B4b<S8b<S;0`<2UYJD00U5AD@069RHV@410QhN7QhN78B4Q@4100/?3``05DE5APh>3?Shn
?ShnTI6A009gMgL01WYjNVYZJTI6ATI6AQdM7G5aL@8:2PX01DY:BVa/K2`/;2`/;7]kN`02F5QH00Id
M7C?clld=3@d=3BOWinCTi<2XZ:R00A<C4agMgO^k^k^k^h2oooo0Rh^;P05Ph>3HF5QHF5Qfm_Koooo
00:e]KD01^c/k:FUYLS8b<S8b1/K6oooo`8Z:RX01MWIfEaLG<71`L71`Oooo`02IVIV2?ooo`030000
oooooooo00goool002;oool00`000?ooooooo`2aoooo00<0003oooooool0;?ooo`030000oooooooo
0;7oool00`000?ooooooo`0=oooo000Roooo0P0000;oool00`000?ooooooo`0Hoooo00<0003ooooo
ool06?ooo`030000oooooooo01Soool00`000?ooooooo`0Hoooo00<0003oooooool06?ooo`030000
oooooooo01Soool00`000?ooooooo`0:oooo0P0002koool2000000?oool0003oool06_ooo`030000
oooooooo01Soool00`000?ooooooo`0Hoooo00<0003oooooool06?ooo`030000oooooooo01Soool0
0`000?ooooooo`0Hoooo00<0003oooooool02_ooo`80000?oooo000Roooo]@0002kooone00003ooo
o`00oooool[oool00?ooooo:oooo003ooooob_ooo`00oooool[oool005koool300007Oooo`<0003H
oooo0`0001goool30000COooo`00Goooo`030000oooooooo01goool00`000?ooooooo`3Hoooo00<0
003oooooool07Oooo`030000oooooooo04coool0053oool300000_ooo`D000001Oooo`000?ooo`00
0?ooo`0300000_ooo`<00003oooo0P0000koool300000_ooo`<00003oooo0P0000;oool300000ooo
o`800002oooo0`0000?oool4000000Coool0003oool0001joooo0`000007oooo000000000000oooo
0000oooo00<00002oooo0`0000?oool200000oooo`800003oooo0`0000koool300000_ooo`D00000
1Oooo`000?ooo`000?ooo`0300000_ooo`<00003oooo0P0000koool300000_ooo`<00003oooo0P00
00;oool300000oooo`800002oooo0`0000?oool4000000Coool0003oool0000]oooo001@oooo00<0
003oool000000_ooo`<000002?ooo`000?ooo`000?ooo`000?ooo`0000;oool010000?ooooooo`00
00?oool00`000?ooooooo`0>oooo00<0003oool000000_ooo`060000oooooooo0000oooo00001?oo
o`030000oooooooo00;oool010000?ooooooo`0000;oool01@000?ooooooooooo`000002oooo0P00
0004oooo0000oooo0000N_ooo`030000oooo000000;oool010000?ooooooo`0000;oool00`000?oo
ooooo`02oooo00D0003oooooooooool000000_ooo`030000oooo000000Coool010000?ooooooo`00
00koool00`000?ooo`000002oooo0`000008oooo0000oooo0000oooo0000oooo00000_ooo`040000
oooooooo00000oooo`030000oooooooo00koool00`000?ooo`000002oooo00H0003oooooool0003o
ool00004oooo00<0003oooooool00_ooo`040000oooooooo00000_ooo`050000oooooooooooo0000
00;oool2000000Coool0003oool0000]oooo001Boooo00<0003oooooool00_ooo`090000oooo0000
oooo0000oooo0000oooo000000;oool010000?ooooooo`0000?oool300004?ooo`040000oooooooo
00000_ooo`030000oooo000000800002oooo00<0003oooooool00_ooo`030000oooooooo00?oool0
1@000?ooooooooooo`000002oooo0P000004oooo0000oooo0000O?ooo`040000oooooooo00000_oo
o`040000oooooooo00001?ooo`050000oooooooooooo000000Coool300000_ooo`040000oooooooo
00004?ooo`030000oooooooo00;oool02@000?ooo`000?ooo`000?ooo`000?ooo`000002oooo00@0
003oooooool00003oooo0`00013oool010000?ooooooo`0000;oool00`000?ooo`00000200000_oo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00D0003oooooooooool000000_ooo`800000
1?ooo`000?ooo`0002goool0057oool00`000?ooooooo`02oooo0P000006oooo00000000oooo0000
oooo100000?oool010000?ooooooooooo`<0000?oooo00<0003oooooool0100000;oool300000_oo
o`<000000oooo`000000000200000_ooo`H000000oooo`0000000002000000?oool0003oool0Nooo
o`040000oooooooooooo0`0000;oool200000oooo`<000000oooo`000000000200000_ooo`<00003
oooo0`0000ooool00`000?ooooooo`02oooo0P000006oooo00000000oooo0000oooo100000?oool0
10000?ooooooooooo`<0000?oooo00<0003oooooool0100000;oool300000_ooo`<000000oooo`00
0000000200000_ooo`H000000oooo`0000000002000000?oool0003oool0;Oooo`00D?ooo`030000
oooo000001;oool00`000?ooooooo`0Boooo00<0003oool000004Oooo`030000oooooooo08[oool0
0`000?ooo`000002oooo00<0003oooooool02?ooo`050000oooooooooooo000000coool00`000?oo
ooooo`0<oooo00<0003oool000004_ooo`030000oooooooo01;oool00`000?ooo`00000Aoooo00<0
003oooooool0?Oooo`00D?ooo`<0000Aoooo0P0001Coool30000W_ooo`<000000oooo`0000000005
oooo00<0003oooooool00oooo`030000oooooooo00coool200003_ooo`<0000Aoooo0P0001Coool3
0000DOooo`00oooool[oool00?ooooo:oooo003ooooob_ooo`00oooool[oool00?ooooo:oooo003o
oooob_ooo`00oooool[oool00?ooooo:oooo0000\
\>"],
  ImageRangeCache->{{{0, 456}, {216.563, 0}} -> {-0.0528233, -0.0238146, 
  0.00461765, 0.00461765}, {{11.4375, 217.688}, {211.375, 
  5.125}} -> {-28.2299, -14.7243, 0.740064, 0.740064}, {{238.313, 444.5}, {
  211.375, 5.125}} -> {-196.109, -14.7243, 0.740064, 0.740064}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ Correlation\ after\ Fourier\ transfroms\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
corRelation[Flatten[SampleFourier],Flatten[ShiftedSampleFourier]]\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(0.997314502019633231`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ Filter\)], "Input"],

Cell["\<\
filterMatrix=
imageNormalize[ShiftedSampleFourier]-imageNormalize[SampleFourier];\
\>", "Input",
  FormatType->InputForm],

Cell["defectSpect=filterMatrix Fourier[ssample];", "Input",
  FormatType->InputForm],

Cell["\<\
defectPosition=imageNormalize[Chop[InverseFourier[defectSpect]]];\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False,AspectRatio->size[[1]]/size[[2]]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Identified) show
129.000000 13.000000 moveto
(Defect) show
165.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000000000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000000000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000000000000000000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000000000000000000000000000000000
00000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FFFF00000000000000000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
000000000000000000000000000000000000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
0000000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000000000000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000FF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF000000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF000000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF000000000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000000000000000000000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0017oool0
0`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Boooo00<0
003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000oooo
o`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`003?ooo`<00003oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`003?ooo`030000oooooooo00;oool00`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000=oooo00L0003oooooooooool0003oool000001?oo
o`<0003noooo0`0000Coool000goool01`000?ooooooooooo`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool2
0000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`003Oooo`<00002oooo00<0003oooooool00ooo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003_ooo`060000oooooooo0000oooo
00001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?ooo`@000001?ooo`00
0?ooo`0000Coool30000o_ooo`<00004oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool200000_ooo`030000
oooo000000Coool00`000?ooooooo`14oooo100000;oool20000]?ooo`030000oooooooo00;oool0
00koool01@000?ooooooooooo`000005oooo00<0003oooooool0@_ooo``0002boooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo04;oool<0000/_ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`0noooo4P000;3oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0?_oo
oa80002`oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo03OooolI0000/?ooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0goooo6@000;3oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0;oooob40002`oooo00<0003oooooool00_ooo`006?ooo`80000`oooo8@00
0:ooool200001?ooo`006?ooo`030000oooooooo02_ooolU0000/?ooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`0[oooo9@000;3oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool07Oooo`800002oooo<@000:koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool07Ooo
o`800002oooo<@000:koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool06oooocT0002/
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo01_oooli0000[?ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`0Eoooo?`000:coool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool05Oooocl0002/oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo01;ooom2
0000[?ooo`030000oooooooo00;oool001Soool200004ooood80002[oooo0P0000Coool001Soool0
0`000?ooooooo`0BooooA0000:[oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool04_oo
od@0002Zoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo00kooom80000Z_ooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0>ooooB0000:[oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool03_ooodP0002Zoooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
00kooom80000Z_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`0>ooooB0000:[oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool03_ooodP0002Zoooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo00kooom80000Z_ooo`030000oooooooo00;oool001Soool200003ooo
odP0002Yoooo0P0000Coool001Soool00`000?ooooooo`0Boooo0P0000?ooolm0000[?ooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0Boooo0P0000?ooolm0000[?ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`0Koooo>@000:coool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool08ooooc40002/oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo02?ooola
0000[?ooo`030000oooooooo00;oool001Soool00`000?ooooooo`0Uoooo;@000:koool00`000?oo
ooooo`02oooo000<oooo0P0000Coool00`000?ooooooo`03oooo00<0003oooooool09Oooobd0002^
oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0
003oooooool09oooobL0002boooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool0
0`000?ooo`000004oooo0`0002OooolW0000/?ooo`<00004oooo000<oooo0P0000?oool00`000?oo
o`000004oooo00<0003oooooool0:ooooal0002foooo00<0003oooooool00_ooo`003?ooo`030000
oooooooo00;oool00`000?ooo`000004oooo00<0003oooooool0:ooooal0002foooo00<0003ooooo
ool00_ooo`003Oooo`800003oooo00<0003oooooool00oooo`030000oooooooo02_ooolK0000^_oo
o`030000oooooooo00;oool001Soool00`000?ooooooo`0[oooo6`000;[oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0;Ooooa400032oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo02gooolA0000`_ooo`030000oooooooo00;oool001Soool00`000?ooooooo`0aoooo2`00
0<Coool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0<Oooo`/00034oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003o
oooo0Oooo`800004oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000ooooo`7oool200001?oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003Ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool000coool00`000?ooo`000002oooo00<0003oool000001?oo
o`<0003noooo0`0000Coool000goool01`000?ooooooooooo`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0U_ooo`X0001Poooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo09Koool:0000H?ooo`030000oooooooo00;oool0
01Soool20000UOooo`l0001Loooo0P0000Coool001Soool00`000?ooooooo`2Doooo3`0005goool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0T_oooaT00002oooo0P00057oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0T_oooaT00002oooo0P00057oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0T?oooal0001Aoooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo093ooolO0000DOooo`030000oooooooo00;oool001Soool00`000?ooooooo`2@oooo8`00
04goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0T?ooob<0001=oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo093ooolS0000COooo`030000oooooooo00;oool001Soool2
0000TOooob<0001<oooo0P0000Coool001Soool00`000?ooooooo`2Boooo8@0004goool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0T_ooob40001=oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo09KooolM0000COooo`030000oooooooo00;oool001Soool00`000?ooooooo`2F
oooo7@0004goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0V?oooa/0001=oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo09SooolK0000COooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`2Foooo6@00057oool00`000?ooooooo`02oooo0006oooo1@0000;oool0
0`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo09KooolI0000DOooo`030000
oooooooo00;oool000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?oo
o`030000oooooooo09SooolG0000DOooo`030000oooooooo00;oool000Soool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000001?ooo`<0002Hoooo5`0004ooool300001?ooo`002?oo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0V?oo
oaD0001Coooo00<0003oooooool00_ooo`002?ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000004oooo00<0003oooooool0V?oooaD0001Coooo00<0003oooooool00_ooo`001ooo
o`800004oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`2Hoooo5@00
05?oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0V?oooaD0001Coooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo09SooolC0000EOooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`2Hoooo4`0005Goool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0W?oo
o`/0001Ioooo00<0003oooooool00_ooo`006?ooo`030000oooooooo09coool;0000FOooo`030000
oooooooo00;oool001Soool00`000?ooooooo`2Roooo00<0003oooooool0Foooo`030000oooooooo
00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P00
0?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool000Koool5000000Coool0000000000003oooo00<0003oooooool00oooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`002?ooo`050000oooooooooooo000000Coool0
0`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0008oooo00<0
003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool30000o_ooo`<00004oooo0008
oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`001oooo`800004
oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`800003oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool200001?ooo`006?ooool0000500001?oo
o`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Ooo
o`00ooooob7oool006Soool300000oooo`<00002oooo0P000003oooo0000000000;oool00`000?oo
ooooo`0200000_ooo`<00002oooo0`0000;oool300000oooo`800003oooo0`00013oool400000ooo
o`800002oooo0`0000?oool200000_ooo`<00003oooo0P0005[oool006Woool01@000?oooooooooo
o`000002oooo00<0003oool000001?ooo`060000oooooooo0000oooo00000_ooo`040000oooooooo
00001?ooo`030000oooooooo00;oool01@000?ooooooooooo`000004oooo00@0003oooooool0000A
oooo00H0003oooooool0003oool00005oooo00D0003oooooooooool000001?ooo`030000oooooooo
00;oool010000?ooooooo`0005Woool006Woool01@000?ooooooooooo`000002oooo00<0003oool0
00000P0000;oool01P000?ooooooo`000?ooo`0000Goool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`040000oooooooooooo0`0000;oool010000?ooooooo`00017oool01@000?ooooooo`00
0?ooo`0300000oooo`040000oooooooooooo0`0000;oool00`000?ooooooo`02oooo00<0003ooooo
ool0F_ooo`00JOooo`030000oooooooo00;oool3000000Goool000000000003oool010000003oooo
0000000000800002oooo0P0000?oool300000_ooo`800003oooo0`0000?oool300004Oooo`050000
oooooooo0000oooo00<00002oooo0`0000;oool300000_ooo`<000000oooo`00000000020000F_oo
o`00JOooo`030000oooooooo00Coool00`000?ooooooo`09oooo00<0003oooooool02?ooo`030000
oooooooo00koool00`000?ooooooo`0?oooo00@0003oooooool00007oooo00<0003oooooool02ooo
o`030000oooooooo05[oool006Soool300001?ooo`80000Aoooo00<0003oooooool00oooo`050000
oooooooooooo000000[oool200004?ooo`@00009oooo00<0003oooooool0Ioooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ Bad\ Photo\)], "Input"],

Cell[BoxData[
    \(\(sample2 = sample; \)\)], "Input"],

Cell["\<\
Do[sample2[[i,j]]=0,
\t\t{i,50,52},{j,30, 33}];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\(bsample = sample2; \)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
BadSamplePhoto=ListDensityPlot[bsample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Bad Sample Photo\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SamplePhoto,BadSamplePhoto}]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -50 0 ]
[.5 1.0125 50 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Bad) show
87.000000 13.000000 moveto
(Sample) show
129.000000 13.000000 moveto
(Photo) show
159.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFF00000000FFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFF00000000FFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{392, 186.625},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000680000^QP00`40o`000?l0003oooooohWoool0
0?oooon9oooo003oooooROooo`00ooooohWoool00?oooon9oooo000Roooo00<0003oooooool04Ooo
o`<00003oooo00<0003oooooool03_ooo`<00002oooo00<0003oooooool03_ooo`800004oooo00<0
003oooooool03oooo`030000oooooooo00;oool00`000?ooooooo`0:oooo1@0000;oool00`000?oo
ooooo`02oooo00<0003oooooool02?ooo`D000001?ooo`000000000000?oool00`000?ooooooo`0b
oooo00<0003oooooool04?ooo`<00003oooo00<0003oooooool03oooo`<00002oooo00<0003ooooo
ool03_ooo`800004oooo00<0003oooooool03_ooo`030000oooooooo00;oool00`000?ooooooo`0:
oooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool02?ooo`D000001?ooo`0000000000
00?oool00`000?ooooooo`0Coooo000Qoooo00<0003oool000004_ooo`030000oooooooo00;oool0
0`000?ooo`00000@oooo00H0003oooooool0003oool0000?oooo00<0003oool000000_ooo`030000
oooo000000ooool00`000?ooo`000002oooo00<0003oool000003Oooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`00000;oooo00D0003oooooooooool000001?ooo`030000oooo0000
03;oool00`000?ooo`00000Aoooo00<0003oooooool00_ooo`030000oooo0000017oool01P000?oo
ooooo`000?ooo`0000ooool00`000?ooo`000002oooo00<0003oool000003_ooo`030000oooo0000
00;oool00`000?ooo`00000=oooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00_oool01@000?ooooooooooo`000004oooo00<0003oool000005?ooo`008Oooo`030000oooo0000
01?oool01`000?ooooooooooo`000?ooo`00000>oooo10000004oooo0000oooo00003oooo`030000
oooo000000;oool00`000?ooo`00000?oooo00<0003oool000000_ooo`030000oooo000000goool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000002oooo`030000oooooooo00;oool0
1`000?ooooooooooo`000?ooo`00000boooo00<0003oool000004_ooo`070000oooooooooooo0000
oooo000000ooool4000000Coool0003oool0000?oooo00<0003oool000000_ooo`030000oooo0000
00koool00`000?ooo`000002oooo00<0003oool000003Oooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`00000;oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo0000
01Coool0027oool00`000?ooo`00000Coooo00L0003oooooooooool0003oool000003_ooo`030000
oooo000000;oool00`000?ooo`00000?oooo0P0000?oool00`000?ooo`00000@oooo00L0003ooooo
ooooool0003oool000003Oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000;
oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000003;oool00`000?ooo`00000B
oooo00L0003oooooooooool0003oool000003oooo`030000oooo000000;oool00`000?ooo`00000?
oooo0P0000?oool00`000?ooo`00000?oooo00L0003oooooooooool0003oool000003Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000;oooo00<0003oooooool00_ooo`070000
oooooooooooo0000oooo000001Coool0027oool00`000?ooo`00000Boooo00<0003oool000000_oo
o`030000oooo000000ooool200000_ooo`030000oooo000000ooool00`000?ooooooo`02oooo00<0
003oool000003oooo`030000oooo000000;oool00`000?ooo`00000=oooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000000_oool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool00000<_ooo`030000oooo0000017oool00`000?ooo`000002oooo00<0003oool000004?oo
o`800002oooo00<0003oool000003oooo`030000oooooooo00;oool00`000?ooo`00000>oooo00<0
003oool000000_ooo`030000oooo000000goool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000002oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Doooo000R
oooo00<0003oooooool04_ooo`030000oooooooo00;oool00`000?ooooooo`0?oooo00D0003ooooo
ooooool000004Oooo`800003oooo00<0003oooooool03oooo`030000oooooooo00;oool00`000?oo
ooooo`0;oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool02Oooo`800004oooo00<0
003oooooool00_ooo`030000oooooooo03;oool00`000?ooooooo`0Aoooo00<0003oooooool00_oo
o`030000oooooooo013oool01@000?ooooooooooo`00000Aoooo0P0000?oool00`000?ooooooo`0>
oooo00<0003oooooool00_ooo`030000oooooooo00_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`09oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04oooo`00oooo
ohWoool00?oooon9oooo003oooooROooo`00ooooohWoool0023ooonH0000:ooooiP0000=oooo000K
oooo00<0003oooooool00_ooo`040000oooooooo00001Oooo`030000oooooooo00;oool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`02oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`0Toooo00<0003oooooool00_ooo`030000oooo0000
00Goool00`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo0P0000goool001[oool0
0`000?ooo`000003oooo00<0003oooooool0U?ooo`030000oooooooo02?oool00`000?ooo`000003
oooo00<0003oooooool0U?ooo`030000oooooooo00_oool001[oool00`000?ooo`000003oooo0P00
09Coool200009Oooo`030000oooo000000?oool00`000?ooooooo`2Coooo0P0000goool001[oool0
0`000?ooo`000003oooo00<0003oooooool00P0000Ooool500000oooo`030000oooooooo00;oool0
10000?ooo`000?ooo`T00004oooo00@0003oooooool00002oooo00<0003oooooool00oooo`<00002
oooo2@000003oooo0000oooo00P000000oooo`0000000003oooo1@000003oooo0000oooo00;oool2
00000oooo`8000001Oooo`000?ooooooo`000002oooo10000004oooo00000000oooo0`000004oooo
0000oooooooo1P000003oooo0000000000Coool200003?ooo`030000oooooooo02?oool00`000?oo
o`000003oooo00@0003oool000000007oooo1@0000?oool00`000?ooooooo`02oooo00@0003oool0
003oool900001?ooo`040000oooooooo00000oooo`030000oooooooo00;oool4000000?oool00000
00001`000003oooo0000oooo00P00002oooo0P0000;oool6000000Coool0003oooooool300000ooo
o`040000oooo000000000_ooo`030000oooooooo00@000001?ooo`0000000?ooo`800002oooo00<0
003oooooool01P000003oooo0000000000Coool200003?ooo`030000oooooooo00_oool001[oool0
0`000?ooo`000003oooo00<0003oooooool00P0000?oool3000000?oool0003oool00oooo`060000
oooooooo0000oooo00000oooo`D000000oooo`0000000002oooo1P0000;oool200000_ooo``00000
0oooo`000?ooo`0300000_ooo`040000oooo000000001Oooo`8000000oooo`000?ooo`03oooo0`00
0004oooo00000000oooo0P0000[oool01@000?ooooooooooo`000006oooo00@0003oooooooooool3
00000oooo`<00005oooo0`000003oooo0000oooo00;oool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`030000oooooooo02?oool00`000?ooo`000003oooo00@0003oool000000003oooo0`00
0003oooo0000oooo00?oool01@000?ooooooo`000?ooo`0200000_ooo`H000001?ooo`000?oooooo
o`H00002oooo0P0000?oool;000000?oool0003oool010000003oooo0000oooo00<00004oooo0P00
00;oool010000?ooooooooooo`@000001Oooo`0000000?ooo`00000;oooo00D0003oooooooooool0
00001_ooo`030000oooooooo00@00003oooo0P0000Koool200000_ooo`050000oooooooooooo0000
00Coool00`000?ooooooo`02oooo00<0003oooooool02oooo`006oooo`030000oooooooo00;oool0
1P000?ooooooo`000?ooo`0000;oool2000000Coool0000000000003oooo00<0003oool000001Ooo
o`030000oooo000000<00003oooo0`0000Goool200001?ooo`<000000oooo`0000000002oooo0`00
00;oool300000_ooo`8000001?ooo`000?ooooooo`800003oooo00<0003oooooool00_ooo`030000
oooooooo00<000001?ooo`000?ooo`0000Goool300001?ooo`P000000oooo`000?ooo`05oooo00@0
003oool0003oool200000_ooo`D000000oooo`0000000002000000?oool00000000010000003oooo
0000oooo00?oool00`000?ooooooo`0Toooo00<0003oooooool00_ooo`050000oooo0000oooo0000
00;oool2000000Coool0000000000003oooo00<0003oool000001Oooo`030000oooo000000@00002
oooo0`0000Goool200001Oooo`8000000oooo`0000000003oooo0P0000;oool400000_ooo`030000
oooo000000?oool200000_ooo`030000oooooooo00?oool00`000?ooo`000003000000Coool0003o
ool00005oooo0`0000Coool8000000?oool0003oool01?ooo`8000000oooo`000?ooo`02000000?o
ool00000000010000003oooo00000000008000000oooo`0000000004000000?oool0003oool00ooo
o`030000oooooooo00_oool0023oool01P000?ooooooo`000?ooo`0000Coool010000?ooooooo`00
00?oool3000000?oool0000000000_ooo`@00002oooo00<0003oooooool00P000003oooo00000000
00@00002oooo100000;oool600000_ooo`@000000oooo`0000000003oooo10000003oooo00000000
00<000000oooo`0000000005000000Coool00000003oool500000_ooo`030000oooo000000800000
1?ooo`0000000?ooo`@00002oooo1P0000?oool00`000?ooo`000003000000?oool0003oool01P00
0003oooo0000oooo00<00002oooo00<0003oooooool00oooo`030000oooooooo02Woool01@000?oo
o`000?ooo`000004oooo00@0003oooooool00003oooo0`000005oooo000000000000oooo00@00003
oooo00D0003oool00000003oool01P0000;oool5000000?oool0000000001@000003oooo00000000
00800002oooo0P0000;oool5000000?oool0000000000P0000;oool600000_ooo`8000000oooo`00
0000000300000_ooo`040000oooo000000000_ooo`8000001?ooo`000000000000?oool500001?oo
o`030000oooo000000800002oooo00<0003oool000001@000003oooo0000oooo00<00002oooo00<0
003oooooool00oooo`030000oooooooo00_oool0023oool01P000?ooooooo`000?ooo`0000Coool0
10000?ooooooo`0000?oool3000000?oool0000000000_ooo`@00002oooo00<0003oooooool00P00
0003oooo0000000000@00002oooo100000;oool600000_ooo`@000000oooo`0000000003oooo1000
0003oooo0000000000<000000oooo`0000000005000000Coool00000003oool500000_ooo`030000
oooo0000008000001?ooo`0000000?ooo`@00002oooo1P0000?oool00`000?ooo`000003000000?o
ool0003oool01P000003oooo0000oooo00<00002oooo00<0003oooooool00oooo`030000oooooooo
02Woool01@000?ooo`000?ooo`000004oooo00@0003oooooool00003oooo0`000005oooo00000000
0000oooo00@00003oooo00D0003oool00000003oool01P0000;oool5000000?oool0000000001@00
0003oooo0000000000800002oooo0P0000;oool5000000?oool0000000000P0000;oool600000_oo
o`8000000oooo`000000000300000_ooo`040000oooo000000000_ooo`8000001?ooo`0000000000
00?oool500001?ooo`030000oooo000000800002oooo00<0003oool000001@000003oooo0000oooo
00<00002oooo00<0003oooooool00oooo`030000oooooooo00_oool0023oool2000000?oool00000
00000`000003oooo0000oooo00;oool500000oooo`@00007oooo100000?oool6000000Coool00000
00000002oooo00@0003oooooooooool200000_ooo`070000oooooooo0000oooo0000oooo00800002
oooo00@0003oool0003oool200000_ooo`<000000oooo`000000000200000oooo`030000oooooooo
00;oool600001?ooo`8000000oooo`0000000003000000?oool0003oool01Oooo`<000000oooo`00
0000000500000_ooo`060000oooooooo0000oooo00000oooo`050000oooooooooooo000000Coool0
0`000?ooooooo`0Yoooo00<0003oool0000010000003oooo0000oooo00;oool500000oooo`@00008
oooo0`0000Coool5000000?oool0000000000P000003oooo0000oooo00;oool3000000Goool0003o
ooooool000000_ooo`030000oooo000000;oool01P000?ooooooo`000?ooo`0000;oool4000000Co
ool0000000000004oooo00@0003oooooooooool700001?ooo`8000000oooo`0000000003000000?o
ool0003oool01?ooo`@000000oooo`000000000500000_ooo`060000oooo00000000oooo00000ooo
o`050000oooooooooooo000000?oool200003Oooo`008?ooo`030000oooooooo00800003oooo00@0
003oooooooooool2000000?oool0000000000_ooo`030000oooooooo00Coool400000_ooo`800002
oooo0P000003oooo00000000008000001?ooo`000?ooooooo`T00004oooo1P0000;oool2000000Co
ool0003oooooool200000oooo`040000oooo0000oooo0P000004oooo0000oooo00000_ooo`060000
oooooooooooo0000oooo1`0000Coool300000_ooo`P00003oooo0P0000?oool2000000?oool0003o
ool00`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`02oooo00<0003oooooool0:Ooo
o`040000oooo000000000oooo`040000oooooooooooo0P0000;oool010000?ooooooo`0000Koool4
00000oooo`030000oooooooo00800002oooo0`000004oooo0000oooooooo2P0000?oool7000000Co
ool00000003oool200000_ooo`040000oooooooooooo0P000006oooo0000oooo0000oooo00000_oo
o`040000oooooooo00000_ooo`8000000oooo`000000000500001?ooo`800003oooo200000?oool2
00000oooo`8000000oooo`000?ooo`0300000_ooo`040000oooooooo00000oooo`030000oooooooo
00;oool00`000?ooooooo`0;oooo000Poooo00<0003oooooool00oooo`8000000oooo`000?ooo`02
000000Coool0003oooooool5000000Koool000000000003oool00006oooo0`0000?oool200000_oo
o`<00006oooo0P0000Coool5000000?oool0000000000P000003oooo0000oooo00L000000oooo`00
0?ooo`0300000_ooo`040000oooooooo00001Oooo`8000001oooo`000?ooooooo`000?ooo`000002
oooo00<0003oooooool00_ooo`040000oooo000000002Oooo`<00004oooo00@0003oooooooooool3
00000oooo`@000000oooo`000?ooo`02oooo00<0003oooooool0:Oooo`030000oooooooo00;oool2
000000?oool0003oool00P000004oooo00000000oooo1@0000;oool2000000?oool0003oool01Ooo
o`<00004oooo00<0003oooooool00`0000Koool200001?ooo`H000001_ooo`00000000000?ooo`00
00;oool600000_ooo`040000oooo000000000_ooo`800002oooo00<0003oooooool00oooo`800000
1?ooo`000?ooo`0000;oool010000?ooooooo`0000Coool010000?ooo`00000000Woool200001Ooo
o`030000oooooooo00@00003oooo10000003oooo0000oooo00;oool00`000?ooooooo`0;oooo000P
oooo00@0003oooooooooool400000_ooo`<00002oooo0P000003oooo0000oooo00D000000oooo`00
00000002oooo00@0003oooooooooool200000oooo`l000000oooo`000?ooo`0400001Oooo`<00000
1?ooo`000?ooooooo`<000000oooo`000?ooo`02oooo00@0003oooooooooool3000000Coool0003o
ool00003oooo0P0000?oool700001?ooo`050000oooo0000oooo000000?oool400000_ooo`030000
oooooooo00P000000oooo`000?ooo`07oooo00<0003oooooool00_ooo`030000oooooooo02Woool0
0`000?ooooooo`0400000_ooo`<00003oooo00@0003oool0003oool5000000?oool0000000000_oo
o`800002oooo0P0000Coool>000000Coool00000003oool300001_ooo`8000000oooo`000?ooo`02
oooo0P000003oooo0000oooo00?oool00`000?ooooooo`04000000Coool0003oool00002oooo0`00
00?oool700000oooo`8000001?ooo`000?ooo`0000;oool500000_ooo`030000oooo000000L00002
oooo00<0003oooooool01_ooo`030000oooooooo00;oool00`000?ooooooo`0;oooo000Poooo00<0
003oooooool01oooo`030000oooooooo00Coool00`000?ooo`000002oooo00D0003oooooooooool0
00000oooo`800002oooo00H0003oool00000003oool00002oooo0P0000Coool5000000?oool0003o
ool00oooo`070000oooooooo0000oooo0000oooo00@00002oooo00@0003oool000000003oooo1000
00;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`@00005oooo00D0003oool00000003o
ool01@0000Ooool01@000?ooo`0000000?ooo`04000000?oool0003oool0100000;oool400000_oo
o`<00003oooo00<0003oooooool0:Oooo`030000oooooooo00Koool00`000?ooooooo`04oooo00<0
003oool000000_ooo`800002oooo00@0003oooooooooool3000000?oool0003oool00P0000;oool0
10000?ooo`00000000Goool4000000?oool0003oool00oooo`040000oooooooo00000_ooo`030000
oooo000000800003oooo00<0003oool000000oooo`D000000oooo`000?ooo`04oooo00@0003ooooo
ooooool500001Oooo`050000oooo00000000oooo00D00007oooo00D0003oool00000003oool01000
0003oooo0000oooo00@00002oooo100000;oool300000oooo`030000oooooooo00_oool0023oool2
000000?oool0000000004P0000;ooola00005?ooo`040000oooo000000001_ooo`030000oooooooo
00Goool010000?ooooooooooo`<00002oooo00<0003oooooool01?ooo`040000oooooooo00000_oo
o`800005oooo0P0000;oool300000oooo`030000oooooooo02Woool00`000?ooo`00000D000000?o
ool000000000<00001?oool00`000?ooooooo`0200001_ooo`030000oooooooo00Goool010000?oo
ooooooooo`800003oooo00<0003oooooool00oooo`800002oooo00@0003oooooool00006oooo0P00
00;oool300000_ooo`80000=oooo000Poooo00<0003oooooool01@0000CooolF000000?oool00000
0000300000;ooolK00000_oooa4000000oooo`000000000T00000_ooo`050000oooooooooooo0000
00;oool00`000?ooooooo`03oooo00<0003oooooool0:Oooo`030000oooo000000@00004oooo5P00
0003oooo0000000000d000000oooo`000000000I00000ooooa4000000oooo`000000000S00000ooo
o`050000oooooooooooo000000;oool00`000?ooooooo`03oooo00<0003oooooool02oooo`008?oo
o`030000oooooooo020000001?ooo`000000000000Goool200000_ooo`030000oooooooo00Goool4
000000?oool0003oool00_ooo`@000000oooo`0000000004oooo00<0003oooooool01P0000?oool4
00000_ooo`8000001?ooo`000000000000?oool2000000?oool000000000:00000?oool00`000?oo
ooooo`0Yoooo00<0003oool000007`000003oooo0000000000800004oooo0P0000?oool00`000?oo
ooooo`05oooo0`000003oooo0000oooo00?oool3000000Coool0000000000003oooo00<0003ooooo
ool01P0000Coool4000000Goool000000000003oool00`0000;oool3000000?oool000000000:000
00?oool00`000?ooooooo`0;oooo000Poooo00<0003oooooool080000004oooo0000000000001Ooo
o`800002oooo00<0003oooooool01Oooo`@000000oooo`000?ooo`02oooo10000003oooo00000000
00Coool00`000?ooooooo`0600000oooo`@00002oooo0P000004oooo0000000000000oooo`800000
0oooo`000000000X00000oooo`030000oooooooo02Woool00`000?ooo`00000O000000?oool00000
00000P0000Coool200000oooo`030000oooooooo00Goool3000000?oool0003oool00oooo`<00000
1?ooo`000000000000?oool00`000?ooooooo`0600001?ooo`@000001Oooo`00000000000?ooo`03
00000_ooo`<000000oooo`000000000X00000oooo`030000oooooooo00_oool0023oool00`000?oo
ooooo`0H000000?oool0000000001@000003oooo00000000013oool5000000Coool0003oool00005
oooo2@000004oooo00000000oooo1@0000Coool00`000?ooooooo`02oooo00<0003oooooool01@00
00;oool[00000oooo`030000oooooooo02Woool00`000?ooo`00000G000000?oool0000000001@00
0003oooo00000000013oool5000000Coool0003oool00005oooo2@000005oooo000000000000oooo
00@00005oooo00@0003oooooooooool200000_ooo`@00003oooo:`0000?oool00`000?ooooooo`0;
oooo000Poooo00<0003oooooool06P000003oooo0000000000800002oooo1`000004oooo00000000
00002_ooo`D00002oooo1@000004oooo00000000oooo100000?oool00`000?ooooooo`0200000_oo
o`P000000oooo`0000000004000000?oool000000000300000;oool00`000?ooo`000003oooo00<0
003oooooool01?oooa000003oooo00<0003oooooool0:Oooo`030000oooo000001T000000oooo`00
0000000200000_ooo`L000001?ooo`000000000000_oool400000oooo`@000001Oooo`0000000000
0?ooo`0300001?ooo`040000oooooooo00000_ooo`P00002oooo1@000003oooo0000000000d00000
1Oooo`000?ooooooo`000003oooo00<0003oooooool01?oooa000003oooo00<0003oooooool02ooo
o`008?ooo`8000000oooo`000000000300000oooo`800002oooo5@000003oooo0000000000H00000
1?ooo`000000000000?oool00`000?ooooooo`04oooo00<0003oool000000_ooo`030000oooo0000
00800004oooo1P0000;oool00`000?ooo`00000300001?oooaX00002oooo00<0003oooooool02ooo
o`030000oooooooo00?oool00`000?ooooooo`05oooo00D0003oooooooooool00000:oooo`030000
oooo000000@00003oooo0P0000?ooolD000000?oool0000000001P000003oooo0000000000800002
oooo00<0003oooooool01?ooo`030000oooo000000?oool010000?ooo`00000000Goool500000ooo
o`030000oooo000000800005oooo6P000003oooo0000oooo00goool00`000?ooooooo`03oooo00<0
003oooooool01Oooo`030000oooooooo0080000=oooo000Poooo00<0003oooooool06`0000Ooool9
000000?oool0000000000oooo`D0000;oooo0P000004oooo00000000oooo200000?oool2000000?o
ool0003oool03`000003oooo0000000000T00002oooo00<0003oooooool01oooo`800002oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool0:Ooo
o`030000oooo000001X00007oooo2@000004oooo0000000000000_ooo`H0000:oooo0P000005oooo
000000000000oooo00P00002oooo0P0000;oool00`000?ooo`00000>000000?oool0000000002@00
0003oooo0000oooo00Woool200000_ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00_oool0023oool00`000?ooooooo`0L000000Coool00000
00000003oooo3P0001goool00`000?ooooooo`05oooo400000;oool=00000oooo`L00003oooo0`00
0003oooo0000000000800002oooo0`0000Goool00`000?ooooooo`0Yoooo00<0003oool000007000
0003oooo0000000000?oool>00007_ooo`030000oooooooo00Goool@00000_ooo``00004oooo1`00
00?oool200000_ooo`@00002oooo0`0000Goool00`000?ooooooo`0;oooo000Poooo00<0003ooooo
ool01Oooo`l00002oooo00@0003oool000000005oooo00<0003oooooool00_ooo`<00006oooo00@0
003oooooool0000Xoooo0P0000;oool00`000?ooo`000005oooo00<0003oooooool00_ooo`/00005
oooo00<0003oooooool00P0000?oool010000?ooooooooooo`<00002oooo00@0003oooooool00005
oooo00<0003oooooool0:Oooo`030000oooooooo00Coool@000000?oool0003oool00P0000Goool0
0`000?ooooooo`03oooo0P0000Ooool00`000?ooo`00000Yoooo00L0003oooooooooool0003oool0
00001Oooo`030000oooooooo00;oool:00001_ooo`030000oooo000000800003oooo00@0003ooooo
ooooool300000_ooo`040000oooooooo00001Oooo`030000oooooooo00_oool001Goool300000ooo
o`030000oooooooo00;oool00`000?ooooooo`0300001Ooooa0000000oooo`000?ooo`05oooo00<0
003oooooool03Oooo`030000oooooooo00[oool00`000?ooooooo`0Hoooo00<0003oooooool02_oo
o`030000oooo000000Goool800001Oooo`030000oooooooo00800003oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool07_ooo`<00003oooo00<0
003oooooool00_ooo`030000oooo000000800005oooo40000003oooo0000oooo00Goool00`000?oo
ooooo`0=oooo00<0003oooooool02oooo`030000oooooooo01Soool00`000?ooooooo`0:oooo00<0
003oool000001Oooo`L00006oooo00<0003oool000000P0000?oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`0;oooo000Eoooo00<0003ooooo
ool00_ooo`030000oooo000000?oool00`000?ooooooo`0300001Ooooa0000000oooo`000?ooo`05
oooo00<0003oooooool03Oooo`030000oooooooo00[oool00`000?ooooooo`0Hoooo00<0003ooooo
ool02_ooo`030000oooo000000Goool800001Oooo`030000oooooooo00800003oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool07_ooo`030000
oooooooo00;oool00`000?ooo`000003oooo00<0003oool000000P0000Goool@000000?oool0003o
ool01Oooo`030000oooooooo00goool00`000?ooooooo`0;oooo00<0003oooooool06?ooo`030000
oooooooo00[oool00`000?ooo`000005oooo1`0000Koool00`000?ooo`00000200000oooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00_oool0
01Koool01`000?ooooooooooo`000?ooo`000003oooo0P000004oooo0000000000001Oooo`/0000M
oooo00<0003oooooool01Oooo`030000oooooooo00;oool200005Oooo`030000oooo000000koool0
0`000?ooooooo`06oooo200001Soool00`000?ooooooo`02oooo0P00027oool01`000?oooooooooo
o`000?ooo`000003oooo00<0003oool000000P0000Goool;00007Oooo`030000oooooooo00Goool0
0`000?ooooooo`03oooo0P0001Coool2000000?oool0003oool03Oooo`030000oooooooo00Koool8
00006?ooo`030000oooooooo00;oool200003Oooo`005_ooo`070000oooooooooooo0000oooo0000
00?oool00`000?ooooooo`0300001Oooo`@00006oooo00<0003oooooool01?ooo`030000oooooooo
00Ooool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`050000oooooooooooo000000Goool2
00005Oooo`030000oooo000000800008oooo00@0003oooooool00005oooo00<0003oooooool02000
00;oool200000_ooo`800003oooo0`0000?oool200001?ooo`030000oooooooo00?oool00`000?oo
ooooo`0Ooooo00L0003oooooooooool0003oool000000oooo`030000oooo000000800005oooo1@00
00Goool00`000?ooooooo`04oooo00<0003oooooool01oooo`80000;oooo00<0003oooooool00ooo
o`040000oooooooo00001_ooo`030000oooooooo01Coool010000?ooo`00000000Soool01@000?oo
ooooooooo`000004oooo0P0000;oool800000_ooo`8000001?ooo`000000000000?oool200001?oo
o`800004oooo00<0003oooooool00oooo`030000oooooooo00_oool001Goool00`000?ooo`000002
oooo00<0003oool000000oooo`030000oooooooo00<00003oooo1@0000Coool300001Oooo`050000
oooo0000oooo000000Coool200003_ooo`050000oooooooooooo000000?oool00`000?ooo`000003
oooo00<0003oooooool01?ooo`040000oooo000000003Oooo`030000oooo000000800006oooo0P00
00?oool300002oooo`/00003oooo0`000003oooo0000oooo00800004oooo0P0000Coool00`000?oo
ooooo`0Noooo00<0003oool000000_ooo`030000oooo000000?oool00`000?ooo`00000200000ooo
o`D00004oooo0`0000Goool010000?ooo`000?ooo`800003oooo0P0000koool010000?oooooooooo
o`800002oooo00<0003oool000001?ooo`030000oooooooo00Coool00`000?ooo`00000>oooo00@0
003oool000000007oooo00<0003oooooool00_ooo`<0000:oooo300000?oool200000_ooo`040000
oooo000000001?ooo`800004oooo00<0003oooooool02oooo`005_ooo`030000oooooooo00;oool0
0`000?ooooooo`02oooo00<0003oooooool00`0000;oool500001_ooo`030000oooooooo00?oool3
00000_ooo`030000oooooooo01;oool01@000?ooooooooooo`000005oooo00<0003oooooool00_oo
o`800006oooo0P0000_oool00`000?ooooooo`0400001Oooo`D00002oooo0P0000?oool00`000?oo
o`000007oooo0P000003oooo0000000000?oool200000_ooo`<00003oooo00<0003oooooool00ooo
o`800004oooo00<0003oooooool07oooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oool000000P0000;oool500001_ooo`030000oooooooo00?oool300000_ooo`80000Coooo00@0
003oooooooooool200001?ooo`030000oooooooo00?oool00`000?ooooooo`05oooo00<0003ooooo
ool02Oooo`800002oooo0`0000Koool500000_ooo`800002oooo0P000003oooo0000oooo00Koool2
000000?oool0000000000oooo`800002oooo0P0000Coool00`000?ooooooo`03oooo0P0000Coool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool0200000Ooool00`000?ooo`000007oooo0P00
01Goool00`000?ooooooo`07oooo00<0003oooooool00_ooo`800004oooo00D0003oooooooooool0
00002?ooo`800002oooo1@0000Coool00`000?ooooooo`02oooo00@0003oooooooooool400003?oo
o`030000oooooooo00@00002oooo100000?oool200001?ooo`800004oooo00<0003oooooool0:Ooo
o`030000oooo000000L00007oooo00<0003oool000001oooo`80000Eoooo00<0003oooooool01ooo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00@0003oooooool00008oooo0P0000?oool4
00001Oooo`040000oooooooooooo0P0000?oool300003Oooo`030000oooooooo00@00002oooo0`00
00Coool200001?ooo`800004oooo00<0003oooooool02oooo`008?ooo`8000000oooo`0000000004
00002oooo`030000oooo000000800003oooo00<0003oooooool01Oooo`030000oooooooo00coool0
0`000?ooooooo`08oooo00<0003oooooool00oooo`030000oooooooo00?oool300003?ooo`D00003
oooo0`0000?oool010000?ooooooooooo`@00003oooo0P0000goool200000_ooo`<00002oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`0Yoooo00<0003oool000001@00
00_oool00`000?ooo`00000200000oooo`030000oooooooo00Goool00`000?ooooooo`0<oooo00<0
003oooooool02?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo0P0000goool400001?oo
o`<00002oooo0P0000?oool300001?ooo`80000=oooo0P0000;oool200000oooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0P0000goool0023oool00`000?ooooooo`0800002_ooo`@0000;
oooo00<0003oooooool03?ooo`030000oooooooo00koool200001_ooo`030000oooooooo00Ooool2
00000_ooo`D00008oooo00@0003oooooooooool200001Oooo`030000oooooooo00;oool400001ooo
o`H00009oooo00<0003oooooool00oooo`030000oooooooo02Woool00`000?ooo`00000700002_oo
o`@0000;oooo00<0003oooooool03?ooo`030000oooooooo00koool200001_ooo`030000oooooooo
00Ooool300000_ooo`@00008oooo0P0000?oool200001Oooo`040000oooooooooooo1@0000Ooool5
00002_ooo`030000oooooooo00?oool00`000?ooooooo`0;oooo000Poooo00D0003oooooool0003o
ool00`000004oooo0000oooooooo0`0000Coool400000_ooo`030000oooo000001Ooool00`000?oo
ooooo`0>oooo0P0001Coool500001Oooo`800006oooo0`0000;oool010000?ooooooo`0000?oool3
00001oooo`H00002oooo00<0003oooooool00_ooo`<00005oooo00<0003oooooool0:Oooo`040000
oooo0000oooo0`000004oooo0000oooooooo100000?oool5000000Coool0003oool0000Goooo00<0
003oooooool03_ooo`80000Eoooo100000Koool00`000?ooooooo`05oooo0P0000?oool010000?oo
ooooo`0000;oool400001oooo`D00003oooo00<0003oooooool00_ooo`<00005oooo00<0003ooooo
ool02oooo`008?ooo`050000oooooooo0000oooo00<000001?ooo`000?ooooooo`<00004oooo1000
00;oool00`000?ooo`00000Goooo00<0003oooooool03_ooo`80000Doooo1@0000Goool200001_oo
o`<00002oooo00@0003oooooool00003oooo0`0000Ooool600000_ooo`030000oooooooo00;oool3
00001Oooo`030000oooooooo02Woool010000?ooo`000?ooo`<000001?ooo`000?ooooooo`@00003
oooo1@000004oooo0000oooo00005oooo`030000oooooooo00koool200005Oooo`@00006oooo00<0
003oooooool01Oooo`800003oooo00@0003oooooool00002oooo100000Ooool500000oooo`030000
oooooooo00;oool300001Oooo`030000oooooooo00_oool0023oool01P000?ooooooo`000?ooo`00
00Koool00`000?ooo`000003oooo1@0000;oool200002Oooo`030000oooooooo00[oool300004Ooo
o`030000oooooooo017oool600001Oooo`8000000oooo`000?ooo`03oooo00@0003oooooool00009
oooo00@0003oooooooooool300000oooo`030000oooo000000H00003oooo0`0000Goool00`000?oo
ooooo`0Yoooo00D0003oool0003oool000001_ooo`040000oooo000000000_ooo`H000000oooo`00
00000009oooo00<0003oooooool02oooo`80000Aoooo00<0003oooooool04_ooo`D00006oooo00@0
003oool000000004oooo00@0003oool000000009oooo00@0003oooooooooool200001?ooo`030000
oooo000000H00003oooo0`0000Goool00`000?ooooooo`0;oooo000Poooo00D0003oooooooooool0
00001oooo`030000oooo000000;oool2000000?oool0003oool00oooo`80000Hoooo00<0003ooooo
ool03_ooo`030000oooo000000?oool300002oooo`040000oooo000000001?ooo`040000oooo0000
oooo0`0000Goool300001?ooo`030000oooooooo00koool700000_ooo`H00004oooo00<0003ooooo
ool0:Oooo`040000oooooooo00001oooo`050000oooo00000000oooo008000000oooo`000?ooo`03
oooo0P0001Soool00`000?ooooooo`0>oooo00<0003oool000001?ooo`80000<oooo00@0003oool0
00000004oooo00@0003oool0003oool200001_ooo`800005oooo00<0003oooooool03_ooo`L00002
oooo1P0000Coool00`000?ooooooo`0;oooo000Poooo0P0000Coool2000000?oool0003oool00`00
0004oooo0000000000000_ooo`030000oooooooo00Coool00`000?ooooooo`0Eoooo00<0003ooooo
ool03oooo`800006oooo00<0003oooooool02?ooo`040000oooooooooooo0P0000;oool00`000?oo
ooooo`03oooo00<0003oooooool00_ooo`800002oooo00<0003oooooool03_ooo`030000oooooooo
00;oool010000?ooooooooooo`T00005oooo00<0003oooooool0:Oooo`030000oooooooo00;oool2
000000?oool0003oool00`0000;oool200000_ooo`030000oooooooo00Coool00`000?ooooooo`0E
oooo00<0003oooooool03oooo`800006oooo00<0003oooooool02Oooo`050000oooooooooooo0000
00?oool00`000?ooooooo`02oooo00<0003oooooool00oooo`8000000oooo`000000000?oooo0P00
00Coool010000?ooooooooooo`T00004oooo0P0000goool0023oool00`000?ooooooo`03oooo0`00
00;oool00`000?ooooooo`0400002?ooo`030000oooooooo00Koool00`000?ooooooo`0:oooo0`00
017oool010000?ooo`00000000Goool00`000?ooooooo`0;oooo00<0003oooooool02?ooo`030000
oooooooo00;oool200000_ooo`040000oooooooo00002Oooo`800007oooo20000004oooo00000000
00000_ooo`050000oooooooooooo000002_oool00`000?ooooooo`02oooo0`0000;oool00`000?oo
ooooo`0400002?ooo`030000oooooooo00Koool00`000?ooooooo`0;oooo0P00017oool00`000?oo
o`00000200001?ooo`030000oooooooo00coool00`000?ooooooo`07oooo00<0003oooooool00ooo
o`8000000oooo`0000000002oooo00<0003oooooool01oooo`800007oooo20000004oooo00000000
00000_ooo`050000oooooooooooo000000goool0023oool010000?ooooooo`0000Coool010000?oo
ooooooooo`<0000:oooo00<0003oooooool05?ooo`<0000=oooo00@0003oool00000000:oooo00<0
003oooooool02Oooo`80000:oooo00<0003oooooool00_ooo`030000oooooooo00?oool010000?oo
o`00000000;oool00`000?ooooooo`02oooo0P0000Koool00`000?ooo`00000:00000_ooo`050000
oooooooooooo000002_oool00`000?ooo`000004oooo00@0003oooooooooool400002Oooo`030000
oooooooo01Goool200003_ooo`030000oooo000000[oool00`000?ooooooo`0:oooo0P0000Woool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`060000oooo00000000oooo00001Oooo`800006
oooo00<0003oool000002P0000;oool01@000?ooooooooooo`00000=oooo000Poooo00<0003ooooo
ool00oooo`@000001?ooo`000000000000Koool00`000?ooooooo`02oooo0P0001;oool010000?oo
ooooooooo`800004oooo0P0000ooool00`000?ooooooo`03oooo00<0003oooooool01Oooo`030000
oooooooo00Soool200000oooo`030000oooooooo00Coool2000000?oool0003oool04_ooo`X00003
oooo0P0000Coool00`000?ooooooo`0Yoooo00<0003oooooool00_ooo`@000001?ooo`0000000000
00Koool00`000?ooooooo`02oooo0P0001;oool00`000?ooooooo`02oooo00<0003oooooool00_oo
o`<0000?oooo00<0003oooooool00_ooo`030000oooooooo00Goool00`000?ooooooo`09oooo0P00
00;oool00`000?ooooooo`05oooo00@0003oooooool0000Coooo2P0000?oool200001?ooo`030000
oooooooo00_oool0023oool00`000?ooooooo`02oooo00D0003oooooool0003oool00P0000Ooool0
10000?ooooooooooo`80000Hoooo0P0000Coool00`000?ooooooo`03oooo00<0003oooooool02?oo
o`80000=oooo00D0003oooooooooool000000oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`03oooo0`000003oooo0000oooo00800009oooo00<0003oooooool01?ooo`T00005oooo00<0
003oooooool00_ooo`030000oooooooo02Woool01@000?ooooooooooo`000002oooo00@0003oool0
00000007oooo00<0003oooooool00_ooo`030000oooooooo01Ooool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`09oooo0P0000coool200000oooo`030000oooooooo00800003oooo00<0
003oool000001_ooo`800002oooo00@0003oool000000009oooo00<0003oooooool01?ooo`T00005
oooo00<0003oooooool00_ooo`030000oooooooo00_oool0023oool00`000?ooooooo`02oooo00D0
003oooooool0003oool00P0000Ooool010000?ooooooooooo`80000Hoooo0P0000Coool00`000?oo
ooooo`03oooo00<0003oooooool02?ooo`80000=oooo00D0003oooooooooool000000oooo`050000
oooooooooooo000000;oool00`000?ooooooo`03oooo0`000003oooo0000oooo00800009oooo00<0
003oooooool01?ooo`T00005oooo00<0003oooooool00_ooo`030000oooooooo02Woool01@000?oo
ooooooooo`000002oooo00@0003oool000000007oooo00<0003oooooool00_ooo`030000oooooooo
01Ooool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`09oooo0P0000coool200000ooo
o`030000oooooooo00800003oooo00<0003oool000001_ooo`800002oooo00@0003oool000000009
oooo00<0003oooooool01?ooo`T00005oooo00<0003oooooool00_ooo`030000oooooooo00_oool0
023oool200000_ooo`800004oooo00<0003oooooool01?ooo`040000oooooooo00002oooo`800000
0oooo`000?ooo`09oooo00<0003oool000000P0000Goool01P000?ooooooo`000?ooo`0000[oool2
00001Oooo`030000oooooooo00Goool400004Oooo`<000001Oooo`000?ooooooo`000008oooo0P00
00;oool00`000?ooooooo`07000000Coool00000003oool500001?ooo`030000oooooooo02Woool0
0`000?ooooooo`0200001?ooo`030000oooooooo00Coool010000?ooooooo`0000coool00`000?oo
o`00000:oooo00<0003oooooool00P0000Koool01@000?ooo`000?ooo`00000;oooo0P0000Coool2
00001_ooo`D0000Aoooo0P0000;oool010000?ooooooo`0000Soool2000000?oool0000000000_oo
o`L000001?ooo`0000000?ooo`D00003oooo0P0000goool0023oool00`000?ooooooo`0500001_oo
o`@00003oooo00@0003oooooooooool200001Oooo`80000:oooo00@0003oool0003oool300001_oo
o`8000000oooo`000?ooo`04oooo0P0000Koool200000oooo`030000oooo000000Goool00`000?oo
ooooo`0Foooo0P000003oooo0000oooo00800003oooo0P000007oooo000000000000oooo0000oooo
00T00002oooo00D0003oooooooooool000001?ooo`030000oooooooo02Woool00`000?ooo`000004
00001_ooo`@00003oooo00@0003oooooooooool200001_ooo`030000oooooooo00Soool00`000?oo
o`000002oooo0P0000Ooool00`000?ooo`000006oooo00<0003oooooool01Oooo`040000oooooooo
oooo0P000003oooo0000oooo00?oool200006?ooo`8000001?ooo`000?ooo`0000Coool2000000?o
ool0000000000_ooo`030000oooo000000P00002oooo00D0003oooooooooool000001?ooo`030000
oooooooo00_oool0023oool010000?ooooooooooo`@00006oooo0`0000?oool00`000?ooo`000003
00002Oooo`030000oooooooo00Koool700000oooo`800008oooo00<0003oooooool01oooo`800003
oooo00<0003oooooool01?ooo`030000oooooooo00;oool01@000?ooooooooooo`000004oooo0P00
00Goool00`000?ooooooo`02oooo100000koool:00000_ooo`050000oooooooooooo000000Coool0
0`000?ooooooo`0Yoooo00<0003oooooool0100000Koool300000oooo`030000oooo000000<00009
oooo00<0003oooooool01_ooo`L00003oooo0`0000Soool00`000?ooooooo`07oooo00@0003ooooo
ooooool200001Oooo`030000oooooooo00?oool00`000?ooooooo`0200001?ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo100000koool:00000_ooo`050000oooooooooooo000000Coool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool00_ooo`030000oooooooo00Ooool200000ooo
o`030000oooooooo00Woool200002_ooo`030000oooo000000@00004oooo00@0003oooooooooool2
000000?oool0000000005Oooo`030000oooooooo01;oool00`000?ooooooo`03oooo1@0000;oool2
00000_ooo`D00002oooo4P0000?oool00`000?ooooooo`0Yoooo00D0003oooooooooool000002_oo
o`050000oooooooooooo000000coool00`000?ooooooo`08oooo00<0003oool00000100000Coool2
00000_ooo`8000001?ooo`000000000001Coool00`000?ooooooo`0Coooo00<0003oooooool00ooo
o`D000001?ooo`000000000000;oool400000ooooa800003oooo00<0003oooooool02oooo`005_oo
o`<00002oooo00<0003oooooool00_ooo`050000oooooooooooo000000Woool4000000Coool0003o
ool00003oooo00<0003oooooool01?ooo`80000;oooo00<0003oool000000`0000?oool200000ooo
o`030000oooooooo0080000<oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?oo
ooooo`09oooo00<0003oooooool00_ooo`H00002oooo00<0003oooooool00_ooo`800004oooo1`00
0004oooo00000000oooo0P0000;oool200001?ooo`030000oooooooo01ooool300000_ooo`030000
oooooooo00;oool010000?ooooooo`0000Woool4000000Coool0003oool00003oooo00<0003ooooo
ool01Oooo`030000oooooooo00Woool00`000?ooo`00000300000oooo`<00002oooo00<0003ooooo
ool00`0000_oool00`000?ooooooo`08oooo0P0000Goool00`000?ooooooo`0:oooo00@0003ooooo
ooooool7000000?oool0003oool01?ooo`800004oooo1`000004oooo00000000oooo0P0000;oool2
00001?ooo`030000oooooooo00_oool001Ooool01P000?ooooooo`000?ooo`0000?oool00`000?oo
ooooo`06oooo00@0003oool000000002oooo0P0000?oool00`000?ooooooo`02oooo00<0003ooooo
ool01oooo`030000oooooooo00Woool500001?ooo`030000oooooooo00;oool00`000?ooooooo`06
oooo00<0003oooooool01?ooo`030000oooooooo00Koool00`000?ooooooo`0Aoooo00<0003ooooo
ool00oooo`<00008oooo0`0000?oool;000000?oool0000000000_ooo`<00003oooo00<0003ooooo
ool08?ooo`060000oooooooo0000oooo00000oooo`030000oooooooo00Goool010000?ooo`000000
00?oool01@000?ooooooooooo`000004oooo00<0003oooooool01oooo`030000oooooooo00Woool5
00001Oooo`050000oooooooooooo000000Soool00`000?ooooooo`04oooo00<0003oooooool01_oo
o`030000oooooooo01;oool00`000?ooooooo`03oooo0`0000Soool300000oooo`/000000oooo`00
00000002oooo0`0000?oool00`000?ooooooo`0;oooo000Eoooo10000004oooo0000oooo00000ooo
o`800007oooo00@0003oooooooooool600000_ooo`800002oooo00<0003oooooool05?ooo`@00002
oooo00<0003oooooool02?ooo`040000oooooooooooo0P0000Goool200000_ooo`800004oooo00<0
003oooooool00oooo`800005oooo0`0000?oool00`000?ooooooo`03oooo00<0003oool000000_oo
o`@00003oooo0P0000CooolC00000_ooo`80000Poooo10000004oooo0000oooo00000oooo`030000
oooooooo00Goool010000?ooooooooooo`H00002oooo0`000003oooo0000oooo01Koool300000_oo
o`030000oooooooo00Woool00`000?ooooooo`0200001Oooo`800003oooo0P0000?oool00`000?oo
ooooo`04oooo00<0003oooooool01?ooo`800004oooo00<0003oooooool00_ooo`8000001?ooo`00
0?ooooooo`<00004oooo0P0000CooolC00000_ooo`80000=oooo000Eoooo00<0003oool000000_oo
o`030000oooo000000?oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`040000oooooooo
oooo0`0000Coool00`000?ooo`00000200002Oooo`030000oooooooo00Soool200000oooo`040000
oooooooo00001?ooo`040000oooo000000001_ooo`030000oooooooo00Goool2000000?oool00000
00001?ooo`030000oooooooo00[oool300000oooo`040000oooooooo00000_ooo`030000oooo0000
00?oool400000_ooo`<00002oooo3P0000?oool00`000?ooo`000003oooo00<0003oooooool07_oo
o`030000oooo000000;oool00`000?ooo`000003oooo00D0003oooooooooool000001?ooo`040000
oooooooooooo0`0000Coool00`000?ooooooo`0200002Oooo`030000oooooooo00Soool300000_oo
o`040000oooooooo00001?ooo`040000oooo000000001_ooo`030000oooooooo00Goool200000_oo
o`800003oooo00<0003oooooool02oooo`800004oooo00D0003oooooool0003oool00P000003oooo
0000oooo00;oool400000_ooo`<000000oooo`000000000=00000oooo`030000oooo000000?oool0
0`000?ooooooo`0;oooo000Foooo0P0000;oool00`000?ooo`000003oooo00<0003oooooool00_oo
o`030000oooooooo00;oool010000?ooooooooooo`<00004oooo00<0003oool000000P0000Woool0
0`000?ooooooo`08oooo0P0000?oool010000?ooooooo`0000Coool010000?ooo`00000000Koool0
0`000?ooooooo`05oooo0P000003oooo0000000000Coool00`000?ooooooo`0:oooo0`0000?oool0
10000?ooooooo`0000;oool00`000?ooo`000003oooo100000;oool300000_ooo`h00003oooo00<0
003oool000000oooo`030000oooooooo01ooool200000_ooo`030000oooo000000?oool01@000?oo
ooooooooo`000004oooo00@0003oooooooooool300001?ooo`030000oooooooo00800009oooo00<0
003oooooool02?ooo`<00002oooo00@0003oooooool00004oooo00@0003oool000000006oooo00<0
003oooooool01Oooo`800002oooo0P0000?oool00`000?ooooooo`0;oooo0P0000Coool01@000?oo
ooooo`000?ooo`02000000?oool0003oool00_ooo`@00002oooo0`000003oooo0000000000d00003
oooo00<0003oool000000oooo`030000oooooooo00_oool001Ooool01@000?ooooooooooo`000004
oooo00<0003oooooool00_ooo`040000oooooooooooo0P0000;oool01@000?ooooooooooo`000002
oooo1@0001Koool200000_ooo`030000oooo000000?oool300002_ooo`800004oooo0P000004oooo
0000oooo00001oooo`030000oooooooo00Soool200000_ooo`030000oooo000000;oool200000_oo
o`040000oooooooooooo100000;oool300000oooo`L000000oooo`000000000300001?ooo`800003
oooo00<0003oooooool08?ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003
oooo0P0000;oool01@000?ooooooooooo`000002oooo1@0001Koool3000000Coool0003oool00004
oooo0P0000[oool300000oooo`8000001Oooo`0000000?ooo`000007oooo00<0003oooooool02?oo
o`070000oooooooooooo0000oooo000000;oool01@000?ooooooooooo`000003oooo100000;oool3
00000oooo`H00002oooo1@0000Coool200000oooo`030000oooooooo00_oool0023oool00`000?oo
ooooo`03oooo0P000003oooo0000000000;oool500000_ooo`030000oooo00000080000Goooo00@0
003oooooool00003oooo00<0003oool000000P0001;oool300005oooo`030000oooooooo00Coool0
1P000?ooo`0000000?ooo`0000;oool2000000Goool0003oool0003oool0200000Goool3000000?o
ool0000000000`0000?oool00`000?ooooooo`0Yoooo00<0003oooooool00_ooo`8000000oooo`00
00000002oooo1@0000;oool00`000?ooo`00000200006?ooo`030000oooo000000?oool2000000?o
ool0000000004_ooo`@0000Goooo00<0003oooooool00oooo`8000001_ooo`0000000?ooo`000?oo
o`<000001Oooo`000?ooo`000?ooo`0800001Oooo`<000000oooo`000000000300000oooo`030000
oooooooo00_oool0023oool200001oooo`800002oooo0P0000;oool00`000?ooooooo`0500002_oo
o`030000oooooooo00[oool00`000?ooooooo`02oooo00<0003oooooool00`0000goool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`800004oooo0P0000?oool00`000?ooooooo`03oooo0P00
0006oooo000000000000oooo00000_ooo`040000oooooooooooo3@0000Koool4000000?oool0003o
ool00_ooo`030000oooooooo02Woool00`000?ooooooo`05oooo0P0000;oool3000000Coool0003o
ooooool500002_ooo`030000oooooooo00_oool01@000?ooooooooooo`000003oooo0P0000koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00?oool200000_ooo`800005
oooo00<0003oooooool00`000004oooo0000oooo00001?ooo``00007oooo10000004oooo0000oooo
oooo0P0000goool0023oool00`000?ooooooo`07oooo00<0003oooooool00P0000;oool00`000?oo
o`00000500002_ooo`030000oooooooo00[oool010000?ooooooo`0000;oool2000000?oool00000
00002Oooo`040000oooooooooooo0P0000?oool010000?ooooooooooo`800002oooo00<0003ooooo
ool00_ooo`040000oooo000000001Oooo`050000oooooooooooo000000Coool300000oooo`030000
oooooooo00<000001_ooo`00000000000?ooo`0000;oool300000_ooo`030000oooooooo00;oool4
000000?oool0000000000P0000Coool00`000?ooooooo`0Yoooo00<0003oooooool01_ooo`030000
oooooooo00<000000oooo`000?ooo`0600002_ooo`030000oooooooo00_oool00`000?ooo`000002
oooo0`000003oooo0000oooo00Soool00`000?ooooooo`02oooo0P0000;oool00`000?ooooooo`02
oooo0P000003oooo0000oooo00Coool00`000?ooo`000006oooo00<0003oooooool00P0000Coool2
00001?ooo`030000oooooooo00800002oooo0`000003oooo0000oooo00@00002oooo00<0003ooooo
ool00_ooo`@000000oooo`000000000200001?ooo`030000oooooooo00_oool0023oool00`000?oo
ooooo`0200001Oooo`030000oooo000000800002oooo0`0000;oool300005oooo`030000oooooooo
00;oool300001?ooo`030000oooo000000;oool00`000?ooooooo`0>oooo00<0003oooooool01ooo
o`800005oooo0`000003oooo0000oooo00Coool200000_ooo`8000000oooo`000000000;00000_oo
o`800009oooo00<0003oooooool01_ooo`030000oooooooo02Woool010000?ooo`00000000Goool0
0`000?ooo`000003000000Coool0000000000002oooo0`0001Soool010000?ooooooooooo`@00003
oooo00<0003oool000000oooo`030000oooooooo00koool00`000?ooooooo`07oooo00<0003ooooo
ool01?ooo`8000000oooo`0000000005oooo00@0003oooooooooool2000000?oool0000000002`00
00;oool200002Oooo`030000oooooooo00Koool00`000?ooooooo`0;oooo000Poooo00<0003ooooo
ool01P000005oooo0000oooooooo000000?oool200000oooo`<0000Coooo0P0000;oool300000ooo
o`030000oooo000000<000000oooo`000?ooo`09oooo100000Koool01@000?ooooooooooo`00000<
oooo0`000003oooo0000000000;oool200001?ooo`800004oooo0`000004oooo0000000000000_oo
o`8000000oooo`000000000300001Oooo`040000oooo000000001_ooo`030000oooooooo02Woool0
0`000?ooo`000005000000Goool0003oooooool000000oooo`800003oooo0`0001?oool200000ooo
o`800003oooo00<0003oooooool00`000003oooo0000oooo00[oool300001oooo`040000oooooooo
00003Oooo`8000001?ooo`000000000000;oool200001?ooo`800003oooo10000005oooo00000000
0000oooo00<000000oooo`000000000200001_ooo`040000oooo000000001_ooo`030000oooooooo
00_oool0023oool00`000?ooooooo`0600001Oooo`030000oooooooo00<00002oooo0`0001Coool0
10000?ooo`00000000;oool00`000?ooo`000003oooo0P0000?oool00`000?ooooooo`0Boooo0P00
00Koool00`000?ooooooo`04oooo00H0003oool00000003oool00003oooo00<0003oooooool00_oo
o`<00004oooo10000003oooo0000000000800005oooo00@0003oooooooooool400002_ooo`030000
oooooooo02Woool00`000?ooo`00000500001Oooo`8000001?ooo`000000000000;oool300005?oo
o`030000oooo0000008000001?ooo`000?ooo`0000Coool01@000?ooooooooooo`00000Eoooo00<0
003oooooool01Oooo`030000oooooooo00Coool010000?ooo`000?ooo`800003oooo00<0003ooooo
ool00_ooo`<00003oooo1@000004oooo0000000000001_ooo`040000oooooooooooo100000[oool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool01P0000Goool00`000?ooooooo`0300000_oo
o`<0000Doooo00@0003oool000000002oooo00<0003oool000000oooo`800003oooo00<0003ooooo
ool04_ooo`800006oooo00<0003oooooool01?ooo`060000oooo00000000oooo00000oooo`030000
oooooooo00;oool300001?ooo`@000000oooo`000000000200001Oooo`040000oooooooooooo1000
00[oool00`000?ooooooo`0Yoooo00<0003oool000001@0000Goool2000000Coool0000000000002
oooo0`0001Coool00`000?ooo`000002000000Coool0003oool00004oooo00D0003oooooooooool0
00005Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00@0003oool0003oool200000ooo
o`030000oooooooo00;oool300000oooo`D000001?ooo`000000000000Koool010000?oooooooooo
o`@0000:oooo00<0003oooooool02oooo`008?ooo`8000000oooo`000?ooo`06oooo00@0003ooooo
ool00002oooo0`0000;oool400000oooo`030000oooooooo00goool010000?ooo`00000000Coool0
0`000?ooooooo`04oooo00<0003oooooool02oooo`8000000oooo`000?ooo`04oooo0`000004oooo
0000oooo00000_ooo`800004oooo00<0003oooooool01Oooo`80000;oooo00<0003oool000000_oo
o`800002oooo00@0003oool000000006oooo0P000003oooo0000oooo00Soool00`000?ooooooo`0Y
oooo00<0003oool000001oooo`030000oooooooo008000001?ooo`000000000000;oool400000ooo
o`030000oooooooo00Coool500001?ooo`030000oooo000000800003oooo00<0003oooooool01?oo
o`030000oooooooo00coool00`000?ooo`000006oooo0P000005oooo00000000oooo000000;oool0
0`000?ooooooo`03oooo00<0003oooooool01Oooo`80000:oooo00@0003oooooool00002oooo0P00
0004oooo00000000oooo0P0000Koool2000000?oool0003oool01oooo`80000=oooo000Poooo00<0
003oooooool01P0000;oool400000_ooo`@000000oooo`000000000200001?ooo`030000oooooooo
00coool400000oooo`800002oooo00@0003oooooool00003oooo0P0000Goool00`000?ooooooo`0:
oooo0`0001Coool00`000?ooooooo`04oooo0P000004oooo0000000000000_ooo`8000000oooo`00
00000002oooo0`0000;oool01`000?ooooooooooo`000?ooo`00000;oooo00<0003oooooool0:Ooo
o`030000oooo000000D00002oooo1@000003oooo00000000008000000oooo`000000000200001?oo
o`800004oooo1@0000Coool500000_ooo`800003oooo00<0003oool000000oooo`<00004oooo00<0
003oooooool02oooo`80000Eoooo00<0003oooooool01?ooo`8000000oooo`0000000003oooo0P00
0004oooo00000000oooo100000;oool01`000?ooooooooooo`000?ooo`00000;oooo00<0003ooooo
ool02oooo`008?ooo`030000oooooooo00H00002oooo0P000003oooo0000oooo00;oool3000000?o
ool0000000000P0001Goool200000_ooo`X00003oooo00@0003oool000000005oooo00<0003ooooo
ool01oooo`<0000<oooo100000?oool200001?ooo`8000000oooo`000?ooo`0500000_ooo`030000
oooo000000800004oooo00@0003oool000000002oooo00<0003oooooool01_ooo`050000oooooooo
oooo000002_oool00`000?ooo`00000500000_ooo`8000000oooo`0000000002oooo0`000003oooo
000000000080000:oooo1@0000Koool3000000?oool000000000200000Coool00`000?ooo`000006
oooo00<0003oooooool01oooo`80000=oooo0`0000Coool200000oooo`<000000oooo`000?ooo`05
00000_ooo`040000oooo000000001Oooo`030000oooo000000?oool00`000?ooooooo`06oooo00D0
003oooooooooool000003Oooo`008?ooo`030000oooooooo00H00002oooo2P0000;oool3000000?o
ool0003oool01oooo`030000oooooooo00Soool200001oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo0`000003oooo0000000000;oool01@000?ooooooooooo`000006oooo0P0000Coool0
10000?ooo`00000000;oool200001oooo`8000000oooo`000?ooo`03oooo00@0003oooooooooool6
00000oooo`800009oooo00<0003oooooool00oooo`030000oooooooo02Woool00`000?ooo`000005
00000_ooo`X00003oooo0P000003oooo0000oooo00Ooool00`000?ooooooo`08oooo0`0000Ooool0
0`000?ooooooo`06oooo00<0003oooooool01Oooo`8000000oooo`0000000003oooo00@0003ooooo
ool00007oooo00<0003oooooool00oooo`030000oooo000000?oool200001oooo`8000000oooo`00
0?ooo`03oooo00@0003oooooooooool600000oooo`030000oooooooo00Soool00`000?ooooooo`03
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo00H00002oooo100000;oool010000?oo
o`00000000;oool300000_ooo`040000oooooooooooo0P0000;oool00`000?ooooooo`08oooo0P00
00Koool200002?ooo`030000oooooooo00Koool3000000Koool000000000003oool00006oooo00<0
003oooooool00P0000Koool200000_ooo`030000oooooooo00Koool300001_ooo`800009oooo00<0
003oooooool02oooo`050000oooooooooooo000002_oool00`000?ooo`00000500000_ooo`D00000
0oooo`000?ooo`0200000oooo`800002oooo00<0003oooooool00_ooo`040000oooooooo00002_oo
o`<00005oooo0`0000Soool00`000?ooooooo`06oooo0P000003oooo00000000008000000oooo`00
0?ooo`05oooo00@0003oooooool00007oooo00D0003oooooooooool000002?ooo`<00006oooo0P00
00Woool00`000?ooooooo`0;oooo00D0003oooooooooool000003Oooo`008?ooo`030000oooooooo
00H00003oooo1`000004oooo00000000oooo100000?oool010000?ooo`00000000coool00`000?oo
ooooo`05oooo00<0003oooooool03?ooo`050000oooooooooooo000000?oool2000000Coool0003o
ooooool200000oooo`040000oooooooo00001oooo`<000000oooo`000000000Eoooo0P0000Koool2
00002_ooo`030000oooooooo00;oool00`000?ooooooo`0Yoooo00<0003oool000001@0000?oool7
000000?oool0000000000_ooo`<00003oooo0P000003oooo0000oooo00_oool00`000?ooooooo`05
oooo00<0003oooooool03?ooo`030000oooooooo00;oool00`000?ooooooo`0200000_ooo`040000
oooooooo00001?ooo`040000oooooooo00001oooo`8000001?ooo`000000000001Goool00`000?oo
ooooo`05oooo00<0003oooooool02Oooo`030000oooooooo00;oool00`000?ooooooo`0;oooo000P
oooo0P000003oooo0000000000@00002oooo200000Coool400000oooo`@00003oooo00<0003ooooo
ool00P0000;oool010000?ooooooo`0000?oool00`000?ooooooo`09oooo0`0000;oool010000?oo
o`00000000;oool400001?ooo`<00003oooo00@0003oooooool0000:oooo00<0003oool000000P00
01_oool200002_ooo`030000oooooooo00;oool00`000?ooooooo`0Yoooo00<0003oool000001@00
00;oool800001Oooo`<00003oooo100000?oool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00P0000;oool00`000?ooooooo`09oooo10000003oooo0000oooo00<00002oooo0`0000Goool2
00001?ooo`040000oooooooo00002Oooo`030000oooooooo00<0000Koooo00<0003oooooool02Ooo
o`040000oooooooooooo0P0000goool0023oool00`000?ooooooo`0600000_ooo`L00007oooo0P00
00Soool01@000?ooooooooooo`000007oooo00D0003oooooooooool000002_ooo`<000001?ooo`00
0000000000;oool00`000?ooooooo`04oooo1@0000;oool2000000Goool0003oooooool000002?oo
o`80000Loooo00@0003oooooooooool2000000?oool0003oool01_ooo`030000oooooooo00?oool0
0`000?ooooooo`0Yoooo00<0003oool000001@0000;oool700001oooo`800008oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool200000_ooo`030000oooooooo00Soool4000000?oool00000
00000_ooo`800005oooo1P000003oooo0000000000;oool010000?ooooooo`0000Soool00`000?oo
ooooo`0Koooo00D0003oooooooooool000000_ooo`030000oooooooo00Goool00`000?ooooooo`03
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo00H00002oooo1`0000Ooool200002?oo
o`050000oooooooooooo000000Ooool01@000?ooooooooooo`00000:oooo0`000004oooo00000000
00000_ooo`030000oooooooo00Coool500000_ooo`8000001Oooo`000?ooooooo`000008oooo0P00
01coool010000?ooooooooooo`8000000oooo`000?ooo`06oooo00<0003oooooool00oooo`030000
oooooooo02Woool00`000?ooo`00000500000_ooo`L00007oooo0P0000Soool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`800002oooo00<0003oooooool02?ooo`@000000oooo`0000000002
oooo0P0000Goool6000000?oool0000000000_ooo`040000oooooooo00002?ooo`030000oooooooo
01_oool01@000?ooooooooooo`000002oooo00<0003oooooool01Oooo`030000oooooooo00?oool0
0`000?ooooooo`0;oooo000Eoooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool01P00
00;oool700003Oooo`030000oooooooo00Goool300001Oooo`050000oooooooooooo000000Woool2
00000oooo`@00003oooo10000004oooo0000oooooooo1P000005oooo0000oooooooo000000Koool4
00007?ooo`030000oooooooo00Koool00`000?ooooooo`09oooo00<0003oooooool07_ooo`800004
oooo00<0003oooooool00_ooo`030000oooo000000D00002oooo1`0000koool00`000?ooooooo`05
oooo0P0000Goool200000_ooo`030000oooooooo00Ooool200001?ooo`<00004oooo0`000003oooo
0000oooo00;oool500000_ooo`040000oooooooo00001_ooo`<0000Moooo00<0003oooooool01_oo
o`030000oooooooo00Woool00`000?ooooooo`0;oooo000Eoooo00<0003oool000000_ooo`030000
oooo000000?oool00`000?ooooooo`0Ooooo0P0000;oool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oooooool00oooo`800004oooo10000003oooo0000000000P00004oooo00<0003oool0
00001P0000?oool00`000?ooooooo`02oooo0P0002Coool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo0P0000?oool00`000?ooooooo`0Noooo00<0003oool000000_ooo`030000oooo0000
00?oool00`000?ooooooo`0Noooo0P0000;oool200000_ooo`030000oooo000000;oool200001?oo
o`800004oooo100000;oool:00000oooo`030000oooooooo00H00004oooo00@0003oooooooooool3
00009?ooo`040000oooo000000000oooo`030000oooooooo00?oool200000oooo`030000oooooooo
00_oool001Goool00`000?ooo`000002oooo00<0003oool000000oooo`80000Toooo00<0003oool0
00000P000003oooo0000oooo00Goool00`000?ooo`000002oooo1P0000;oool=000000?oool00000
00000P000003oooo0000000000800003oooo100002[oool700001?ooo`030000oooooooo0080000P
oooo00<0003oool000000_ooo`030000oooo000000?oool00`000?ooooooo`0Roooo0P000005oooo
00000000oooo000000Koool00`000?ooo`000003oooo1@0000?oool<000000?oool0000000000`00
0004oooo0000000000001?ooo`<0000Zoooo200000Coool00`000?ooooooo`0200003Oooo`005Ooo
o`800003oooo00<0003oool000000oooo`030000oooooooo02Soool00`000?ooo`000005oooo00<0
003oooooool00_ooo`030000oooooooo008000000oooo`000000000=000000?oool0000000000P00
0003oooo0000000000800002oooo0P0003;oool600001?ooo`030000oooooooo01koool200000ooo
o`030000oooo000000?oool00`000?ooooooo`0Woooo00<0003oool000001Oooo`030000oooooooo
00?oool01@000?ooo`0000000?ooo`0?000000?oool0000000000`000004oooo0000000000000ooo
o`80000boooo1P0000Coool00`000?ooooooo`0;oooo000Eoooo00<0003oooooool00_ooo`030000
oooo000000?oool00`000?ooooooo`0Yoooo00@0003oool000000004oooo00D0003oooooooooool0
00000_ooo`030000oooo0000014000001?ooo`0000000?ooo`@00002oooo0P0002Ooool300001_oo
o`040000oooooooo00000_ooo`030000oooo000000?oool00`000?ooooooo`0Noooo00<0003ooooo
ool00_ooo`030000oooo000000?oool00`000?ooooooo`0Xoooo00<0003oool000000P0000?oool0
0`000?ooooooo`02oooo00@0003oool0003ooolB00000_ooo`8000001?ooo`000000000000?oool2
00009oooo`<00006oooo00@0003oooooool00002oooo00<0003oool000000oooo`030000oooooooo
00_oool001Koool200000oooo`030000oooooooo00;oool00`000?ooooooo`0Zoooo00<0003ooooo
ool01Oooo`H000000oooo`000000000A000000?oool0003oool01@0000;oool00`000?ooooooo`0]
oooo00<0003oool000002oooo`030000oooooooo01ooool200000oooo`030000oooooooo00;oool0
0`000?ooooooo`0Yoooo00<0003oooooool01Oooo`H000000oooo`000000000A00000_ooo`030000
oooo000000<00003oooo00<0003oooooool0;Oooo`030000oooo000000_oool00`000?ooooooo`0;
oooo000Poooo00<0003oooooool0;?ooo`060000oooooooooooo0000oooo8P000003oooo0000oooo
033oool00`000?ooooooo`0:oooo00<0003oooooool0:Oooo`030000oooooooo02_oool200000_oo
o`030000oooo000002400002oooo00<0003oooooool0;oooo`030000oooooooo00[oool00`000?oo
ooooo`0;oooo000Poooo00<0003oooooool0;?ooo`060000oooooooooooo0000oooo8P000003oooo
0000oooo033oool00`000?ooooooo`0:oooo00<0003oooooool0:Oooo`030000oooooooo02_oool2
00000_ooo`030000oooo000002400002oooo00<0003oooooool0;oooo`030000oooooooo00[oool0
0`000?ooooooo`0;oooo000Poooo0P00037oool200000_ooob80000noooo00<0003oooooool0:Ooo
o`030000oooooooo02ooool200000_ooob<0000moooo0P0000goool0023oool00`000?ooooooo`0b
oooo00<0003oool00000800003ooool00`000?ooooooo`0Yoooo00<0003oooooool0<Oooo`030000
oooo00000240000ooooo00<0003oooooool02oooo`008?ooo`030000oooooooo037oool010000?oo
o`000?oooah00011oooo00<0003oooooool0:Oooo`030000oooooooo033oool00`000?ooo`000002
oooo7@0004;oool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0<Oooo`030000oooo0000
01h00012oooo00<0003oooooool0:Oooo`030000oooooooo033oool00`000?ooo`00000N0000@ooo
o`030000oooooooo00_oool0023oool00`000?ooooooo`0`oooo0P0000;ooolN0000@_ooo`030000
oooooooo02Woool00`000?ooooooo`0_oooo0P0000;ooolN0000@oooo`030000oooooooo00_oool0
023oool00`000?ooooooo`0coooo7@0004Coool00`000?ooooooo`0Yoooo00<0003oooooool0<_oo
oah00014oooo00<0003oooooool02oooo`008?ooo`80000coooo700004Koool00`000?ooooooo`0Y
oooo00<0003oooooool0<Ooooad00015oooo0P0000goool0023oool00`000?ooooooo`0doooo6@00
04Ooool00`000?ooooooo`0Yoooo00<0003oooooool0<ooooaX00017oooo00<0003oooooool02ooo
o`008?ooo`030000oooooooo03CooolI0000Aoooo`030000oooooooo02Woool00`000?ooooooo`0c
oooo6P0004Ooool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0=?oooaX00016oooo00<0
003oooooool0:Oooo`030000oooooooo03?ooolK0000A_ooo`030000oooooooo00_oool0023oool0
0`000?ooooooo`0boooo200000?ooolB0000AOooo`030000oooooooo02Woool00`000?ooooooo`0a
oooo200000CooolB0000AOooo`030000oooooooo00_oool0023oool20000<oooo`P00004oooo4P00
04Coool00`000?ooooooo`0Yoooo00<0003oooooool0<Oooo`P00005oooo4P0004?oool200003Ooo
o`008?ooo`030000oooooooo037oool<00000_ooo`8000000oooo`000000000<0000A?ooo`030000
oooooooo02Woool00`000?ooooooo`0`oooo3@0000;oool00`000?ooo`00000>0000A?ooo`030000
oooooooo00_oool0023oool00`000?ooooooo`0aoooo3P0000Coool7000000?oool0000000001@00
04;oool00`000?ooooooo`0Yoooo00<0003oooooool0<?ooo`l00003oooo1`000003oooo00000000
00D00013oooo00<0003oooooool02oooo`008?ooo`030000oooooooo02goool900000_ooo`800002
oooo5P0004;oool00`000?ooooooo`0Yoooo00<0003oooooool0;Oooo`T000000oooo`0000000002
oooo5P0004?oool00`000?ooooooo`0;oooo000Foooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0^oooo1`000003oooo00000000008000000oooo`000000000<000000?o
ool0000000002000043oool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0^oooo1`000005oooo000000000000oooo00h000000oooo`0000000008
0000@Oooo`030000oooooooo00_oool001Goool00`000?ooo`000002oooo00<0003oool000000ooo
o`030000oooooooo02koool800000oooo`P00003oooo4000043oool00`000?ooooooo`0Noooo00<0
003oool000000_ooo`030000oooo000000?oool00`000?ooooooo`0^oooo200000;oool800000ooo
oa000011oooo00<0003oooooool02oooo`005Oooo`030000oooo000000;oool00`000?ooo`000003
oooo0P0002ooool800000oooo`P00003oooo400003ooool200008?ooo`030000oooo000000;oool0
0`000?ooo`000003oooo00<0003oooooool0;_ooo`P00002oooo200000?oool@0000@?ooo`80000=
oooo000Foooo00L0003oooooooooool0003oool000000oooo`030000oooooooo02goool7000000Oo
ool000000000003oool0003oool00`0000?ooolC0000@?ooo`030000oooooooo01ooool01`000?oo
ooooooooo`000?ooo`000003oooo00<0003oooooool0;Oooo`H00002oooo0P000003oooo0000oooo
00@00002oooo4`00047oool00`000?ooooooo`0;oooo000Eoooo00<0003oool000000_ooo`030000
oooo000000?oool00`000?ooooooo`0/oooo20000004oooo0000000000000_ooo`030000oooooooo
00d000000oooo`00000000070000@?ooo`030000oooooooo01koool00`000?ooo`000002oooo00<0
003oool000000oooo`030000oooooooo02_oool800000_ooo`800002oooo00@0003oooooooooool<
000000?oool0000000001`00047oool00`000?ooooooo`0;oooo000Foooo00<0003oooooool00_oo
o`030000oooooooo00;oool00`000?ooooooo`0/oooo2P0000;oool00`000?ooooooo`08oooo00<0
003oooooool03`0003ooool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0[oooo2`000003oooo0000oooo00Woool010000?ooooooooooo`l0000o
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo02coool00`000?ooo`00000600001?oo
o`030000oooooooo00;oool3000000?oool0000000000`0000;oool<0000?oooo`030000oooooooo
02Woool00`000?ooooooo`0[oooo0P000003oooo0000000000D00003oooo00<0003oooooool00ooo
o`8000000oooo`0000000004000000?oool0000000002`0003ooool00`000?ooooooo`0;oooo000P
oooo00<0003oooooool0;?ooo`P000000oooo`000?ooo`07oooo1`0000;oool2000000?oool00000
00002@0003ooool00`000?ooooooo`0Yoooo00<0003oooooool0:oooo`P00002oooo00<0003ooooo
ool01_ooo`L00002oooo00<0003oool000002`0003ooool00`000?ooooooo`0;oooo000Poooo0P00
02coool8000000?oool0000000000`000003oooo0000oooo00d000000oooo`00000000090000?ooo
o`030000oooooooo02Woool00`000?ooooooo`0Zoooo20000003oooo0000000000<000000oooo`00
0?ooo`0=000000?oool0000000002P0003koool200003Oooo`008?ooo`030000oooooooo02_oool8
00000oooo`<00002oooo00<0003oool000002`000003oooo0000000000T0000ooooo00<0003ooooo
ool0:Oooo`030000oooooooo02[oool800001?ooo`800002oooo00<0003oooooool02`000003oooo
0000000000X0000ooooo00<0003oooooool02oooo`008?ooo`030000oooooooo02_oool800000ooo
o`<00002oooo00<0003oool000002`000003oooo0000000000T0000ooooo00<0003oooooool0:Ooo
o`030000oooooooo02[oool800001?ooo`800002oooo00<0003oooooool02`000003oooo00000000
00X0000ooooo00<0003oooooool02oooo`008?ooo`030000oooooooo02_oool600001oooo`040000
oooooooo00000_ooo`030000oooooooo00<000000oooo`000?ooo`03oooo0`000003oooo00000000
00D0000ooooo00<0003oooooool0:Oooo`030000oooooooo02[oool600001oooo`040000oooooooo
00000oooo`030000oooo000000800002oooo00@0003oooooooooool4000000?oool0000000001@00
03ooool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0;?ooo`H00008oooo00@0003ooooo
ool00004oooo0`0000[oool60000?oooo`030000oooooooo02Woool00`000?ooooooo`0[oooo1P00
00Soool01@000?ooooooooooo`000003oooo100000[oool60000?oooo`030000oooooooo00_oool0
023oool20000;Oooo`H00003oooo1P0000;oool01@000?ooo`0000000?ooo`03000000?oool00000
00001@0000;oool50000@?ooo`030000oooooooo02Woool00`000?ooooooo`0[oooo1P0000Coool5
00000oooo`040000oooo0000oooo10000003oooo0000000000D00002oooo1000043oool200003Ooo
o`008?ooo`030000oooooooo02_oool500001Oooo`030000oooooooo00@00006oooo0P000003oooo
0000000000H00002oooo1@00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`D00006
oooo00<0003oool000000`0000Koool200000_ooo`P00002oooo1000047oool00`000?ooooooo`0;
oooo000Poooo00<0003oooooool0;?oooa000007oooo0`000003oooo0000000000/00010oooo00<0
003oooooool0:Oooo`030000oooooooo02_oool@00001oooo`@000000oooo`000000000:0000@Ooo
o`030000oooooooo00_oool0023oool00`000?ooooooo`0[oooo1P000003oooo0000000000X00005
oooo4@00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`H000000oooo`000000000;
00001?oooa400011oooo00<0003oooooool02oooo`008?ooo`030000oooooooo02_oool9000000Co
ool0003oooooool700000ooooa800010oooo00<0003oooooool0:Oooo`030000oooooooo02[oool9
00000_ooo`030000oooo000000L00002oooo4P00047oool00`000?ooooooo`0;oooo000Poooo00<0
003oooooool0:oooo`800004oooo1@0000Coool500000oooo`@000000oooo`0000000002000000?o
ool0000000001P00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`<00003oooo1P00
00?oool600000_ooo`D000001Oooo`00000000000?ooo`080000@Oooo`030000oooooooo00_oool0
023oool20000;?ooo`800004oooo1@0000Coool500000oooo`@000000oooo`0000000002000000?o
ool0000000001P00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`<00003oooo1P00
00?oool600000_ooo`D000001Oooo`00000000000?ooo`080000@?ooo`80000=oooo000Poooo00<0
003oooooool0:oooo`030000oooooooo00?oool010000?ooo`000?ooo`<00003oooo6@00043oool0
0`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`030000oooooooo00?oool00`000?ooo`000002
oooo0P0000?ooolI0000@Oooo`030000oooooooo00_oool0023oool00`000?ooooooo`0[oooo00<0
003oooooool01?ooo``00005oooo3`000003oooo0000oooo03ooool00`000?ooooooo`0Yoooo00<0
003oooooool0:_ooo`030000oooooooo00Coool=00001?ooo`l000000oooo`000?ooo`10oooo00<0
003oooooool02oooo`008?ooo`030000oooooooo02coool01`000?ooooooooooo`000?ooo`000003
oooo0P000003oooo0000000000<000000oooo`0000000002oooo1`0000Coool010000?oooooooooo
o`800010oooo00<0003oooooool0:Oooo`030000oooooooo02_oool200000_ooo`030000oooo0000
00Coool00`000?ooo`000005000000Coool0003oooooool700001Oooo`030000oooooooo00800011
oooo00<0003oooooool02oooo`003oooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0/oooo0P0000_oool00`000?ooooooo`09oooo0P0000;oool00`000?oo
ooooo`06oooo00<0003oooooool0?oooo`030000oooooooo01Soool500000_ooo`030000oooooooo
00;oool00`000?ooooooo`02oooo00<0003oooooool0:oooo`<0000:oooo00<0003oooooool02_oo
o`8000000oooo`000?ooo`07oooo00<0003oooooool0@?ooo`030000oooooooo00_oool0017oool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`030000oooooooo037oool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`040000oooooooo00000_ooo`040000oooooooo
00000_ooo`030000oooooooo03ooool00`000?ooooooo`0Joooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000000?oool00`000?ooooooo`0`oooo00<0003oooooool02?ooo`800009
oooo00<0003oool000000_ooo`800002oooo00<0003oool00000@_ooo`030000oooooooo00_oool0
017oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`80000^oooo0`00
01[oool2000000?oool0003oool00`00047oool200007?ooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`000003oooo00<0003oooooool0;Oooo`80000Joooo0P0000;oool010000?oo
o`00000004;oool200003Oooo`004Oooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`000003oooo00<0003oooooool0>?ooo`030000oooooooo00Woool200001Oooo`030000oooooooo
04Koool00`000?ooooooo`0Joooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00?oool00`000?ooooooo`0goooo00<0003oooooool02Oooo`<00004oooo00<0003oooooool0Aooo
o`030000oooooooo00_oool0017oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00000oooo`030000oooooooo03Soool00`000?ooooooo`09oooo0P0000Goool00`000?ooooooo`16
oooo00<0003oooooool06_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003
oooo00<0003oooooool0=oooo`030000oooooooo00Woool300001?ooo`030000oooooooo04Ooool0
0`000?ooooooo`0;oooo000@oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00_oo
o`030000oooooooo033oool00`000?ooooooo`0Doooo0P000006oooo0000oooo0000oooo0000AOoo
o`030000oooooooo01Woool200001?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oooooool0;oooo`030000oooooooo01Goool010000?ooo`000?ooo`8000000oooo`000?ooo`14
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo037oool400005_ooo`<00016oooo00<0
003oooooool0:Oooo`030000oooooooo033oool500005Oooo`@00016oooo00<0003oooooool02ooo
o`008?ooo`80000coooo0P0000Soool00`000?ooooooo`03oooo0`000007oooo0000oooooooo0000
oooo000004Soool00`000?ooooooo`0Yoooo00<0003oooooool0<Oooo`800008oooo0P0000Coool4
000000Koool0003oool0003oool00018oooo0P0000goool0023oool00`000?ooooooo`0eoooo00@0
003oooooool00006oooo1@0000?oool30000B_ooo`030000oooooooo02Woool00`000?ooooooo`0e
oooo00<0003oool000001oooo`@00004oooo0P0004_oool00`000?ooooooo`0;oooo000Poooo00<0
003oooooool0=_ooo`800004oooo00<0003oooooool01?ooo`030000oooooooo04koool00`000?oo
ooooo`0Yoooo00<0003oooooool0=_ooo`030000oooooooo00;oool200001Oooo`030000oooooooo
04ooool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0U?ooo`030000oooooooo02Woool0
0`000?ooooooo`2Doooo00<0003oooooool02oooo`008?ooo`030000oooooooo09Coool00`000?oo
ooooo`0Yoooo00<0003oooooool0U?ooo`030000oooooooo00_oool0023oool00`000?ooooooo`2D
oooo00<0003oooooool0:Oooo`030000oooooooo09Coool00`000?ooooooo`0;oooo000Poooo0P00
09Goool00`000?ooooooo`0Yoooo00<0003oooooool0Toooo`80000=oooo000Poooo00<0003ooooo
ool0U?ooo`030000oooooooo02Woool00`000?ooooooo`2Doooo00<0003oooooool02oooo`008?oo
o`030000oooooooo09Coool00`000?ooooooo`0Yoooo00<0003oooooool0U?ooo`030000oooooooo
00_oool0023oool00`000?ooooooo`2Doooo00<0003oooooool0:Oooo`030000oooooooo09Coool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool0U?ooo`030000oooooooo02Woool00`000?oo
ooooo`2Doooo00<0003oooooool02oooo`008?ooo`030000oooooooo09Coool00`000?ooooooo`0Y
oooo00<0003oooooool0U?ooo`030000oooooooo00_oool0023oool20000UOooo`030000oooooooo
02Woool00`000?ooooooo`2Coooo0P0000goool0023oool00`000?ooooooo`2Doooo00<0003ooooo
ool0:Oooo`030000oooooooo09Coool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0U?oo
o`030000oooooooo02Woool00`000?ooooooo`2Doooo00<0003oooooool02oooo`003oooo`D00000
1?ooo`000000000000?oool00`000?ooooooo`02oooo00<0003oooooool0U?ooo`030000oooooooo
01Soool5000000Coool0000000000003oooo00<0003oooooool00_ooo`030000oooooooo09Coool0
0`000?ooooooo`0;oooo000Aoooo00D0003oooooooooool000001?ooo`030000oooo000000?oool0
0`000?ooooooo`06oooo00<0003oooooool0Roooo`030000oooooooo01[oool01@000?oooooooooo
o`000004oooo00<0003oool000000oooo`030000oooooooo00Goool00`000?ooooooo`2<oooo00<0
003oooooool02oooo`004Oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000003
oooo0P0000Soool00`000?ooooooo`29oooo0P0001coool00`000?ooooooo`02oooo00L0003ooooo
ooooool0003oool000000oooo`030000oooooooo00Koool00`000?ooooooo`2:oooo0P0000goool0
017oool00`000?ooooooo`02oooo00L0003oooooooooool0003oool000000oooo`030000oooooooo
09Coool00`000?ooooooo`0Joooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo0000
00?oool00`000?ooooooo`2Doooo00<0003oooooool02oooo`004Oooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000003oooo00<0003oooooool01Oooo`030000oooooooo08coool0
0`000?ooooooo`0Joooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool0
0`000?ooooooo`04oooo00<0003oooooool0SOooo`030000oooooooo00_oool0013oool200001?oo
o`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool00P0008Soool00`000?oo
ooooo`07oooo00<0003oooooool06Oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
00;oool010000?ooo`00000008Woool00`000?ooooooo`07oooo00<0003oooooool02oooo`008?oo
o`030000oooooooo00?oool200001Oooo`030000oooooooo00Goool00`000?ooooooo`1ooooo00<0
003oooooool0:Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo00Goool00`000?oo
ooooo`20oooo00<0003oooooool02oooo`008?ooo`030000oooooooo00;oool300002_ooo`030000
oooo000000Ooool010000?ooo`000?ooo`80001eoooo00<0003oooooool0:Oooo`040000oooooooo
oooo0`0000[oool00`000?ooo`000007oooo00H0003oool00000003oool0001foooo00<0003ooooo
ool02oooo`008?ooo`800003oooo0`0000[oool00`000?ooo`000007oooo00@0003oool0003oool2
0000MOooo`030000oooooooo02Woool010000?ooooooooooo`<0000:oooo00<0003oool000001ooo
o`060000oooo00000000oooo0000MOooo`80000=oooo000Poooo00<0003oooooool01Oooo`030000
oooo000000800004oooo00<0003oool000002Oooo`030000oooooooo07Ooool00`000?ooooooo`0Y
oooo00<0003oooooool01?ooo`030000oooo000000800004oooo00<0003oool000002Oooo`030000
oooooooo07Soool00`000?ooooooo`0;oooo000Poooo00<0003oooooool02@0000;oool00`000?oo
ooooo`03oooo00<0003oooooool05?ooo`030000oooooooo00_oool300002?ooo`030000oooooooo
00ooool00`000?ooooooo`05oooo00D0003oooooooooool000003?ooo`030000oooooooo00coool2
00005oooo`030000oooooooo02Woool00`000?ooo`00000800000_ooo`800004oooo00<0003ooooo
ool05?ooo`030000oooooooo00coool200002?ooo`030000oooooooo00ooool00`000?ooooooo`05
oooo00<0003oooooool00_ooo`030000oooooooo00Woool200003_ooo`030000oooooooo01Koool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool00`0000;oool00`000?ooo`00000200001?oo
o`030000oooooooo00Ooool00`000?ooooooo`02oooo0P0001;oool00`000?ooooooo`0Roooo00<0
003oooooool02_ooo`030000oooooooo02Goool00`000?ooooooo`06oooo00<0003oooooool0:Ooo
o`030000oooo000000800002oooo00<0003oool000000P0000Coool00`000?ooooooo`07oooo00<0
003oooooool00oooo`030000oooooooo013oool00`000?ooooooo`0Soooo00<0003oooooool02Ooo
o`030000oooooooo02Koool00`000?ooooooo`06oooo00<0003oooooool02oooo`008?ooo`030000
oooooooo09Coool00`000?ooooooo`0Yoooo00<0003oooooool0U?ooo`030000oooooooo00_oool0
023oool010000?ooooooo`0001Koool00`000?ooooooo`0Coooo00<0003oooooool05?ooo`030000
oooooooo01Coool00`000?ooooooo`0Doooo00<0003oooooool04oooo`030000oooooooo00Woool0
0`000?ooooooo`0Yoooo00<0003oool000005_ooo`030000oooooooo01Coool00`000?ooooooo`0D
oooo00<0003oooooool04oooo`030000oooooooo01Coool00`000?ooooooo`0Doooo00<0003ooooo
ool02Oooo`030000oooooooo00_oool0023ooonH0000:ooooiP0000=oooo003oooooROooo`00oooo
ohWoool00?oooon9oooo003oooooROooo`00Eoooo`<0003;oooo0`00063oool005Soool00`000?oo
ooooo`3;oooo00<0003oooooool0Goooo`00BOooo`<00002oooo1@000005oooo0000oooo0000oooo
00<00002oooo0`0000?oool200003Oooo`<00002oooo0`000004oooo0000oooooooo0P0000?oool2
00000oooo`80001doooo100000;oool400000_ooo`<0000:oooo0`0000;oool5000000Goool0003o
ool0003oool00`0000;oool300000oooo`80000=oooo0`0000;oool3000000Coool0003oooooool2
00000oooo`800003oooo0P00033oool004Woool00`000?ooo`000002oooo0`000008oooo0000oooo
0000oooo0000oooo00000_ooo`040000oooooooo00000oooo`030000oooooooo00koool00`000?oo
ooooo`02oooo00H0003oooooool0003oool00002oooo00<0003oool000000_ooo`030000oooo0000
00;oool00`000?ooooooo`1boooo00D0003oooooool0003oool00`0000;oool010000?ooooooo`00
00[oool00`000?ooo`000002oooo0`000008oooo0000oooo0000oooo0000oooo00000_ooo`040000
oooooooo00000oooo`030000oooooooo00koool00`000?ooooooo`02oooo00H0003oooooool0003o
ool00002oooo00<0003oool000000_ooo`030000oooo000000;oool00`000?ooooooo`0]oooo001;
oooo00<0003oooooool00_ooo`090000oooo0000oooo0000oooo0000oooo000000;oool010000?oo
ooooo`0000?oool300003_ooo`<00002oooo00H0003oooooool0003oool00002oooo00<0003oool0
00001?ooo`040000oooooooo0000M?ooo`040000oooooooo00000oooo`040000oooooooo00000_oo
o`030000oooooooo00[oool00`000?ooooooo`02oooo00T0003oool0003oool0003oool0003oool0
00000_ooo`040000oooooooo00000oooo`<0000>oooo0`0000;oool01P000?ooooooo`000?ooo`00
00;oool00`000?ooo`000004oooo00@0003oooooool0000_oooo001:oooo00<0003oooooool00_oo
o`8000001_ooo`0000000?ooo`000?ooo`@00003oooo00@0003oooooooooool300003_ooo`050000
oooooooo0000oooo00<00003oooo0P000003oooo0000000000800003oooo0P0007Goool300000ooo
o`800003oooo0`0000_oool00`000?ooooooo`02oooo0P000006oooo00000000oooo0000oooo1000
00?oool010000?ooooooooooo`<0000>oooo00D0003oooooool0003oool00`0000?oool2000000?o
ool0000000000P0000?oool20000<?ooo`00BOooo`030000oooo000001;oool00`000?ooooooo`0B
oooo00H0003oooooool0003oool00009oooo00<0003oooooool0N_ooo`040000oooooooo00002Ooo
o`030000oooooooo00Soool00`000?ooo`00000Boooo00<0003oooooool04_ooo`060000oooooooo
0000oooo00002Oooo`030000oooooooo03Goool004Woool300004Oooo`80000Coooo10000003oooo
0000000008Goool400002Oooo`80000:oooo0`00017oool200004oooo`@000000oooo`0000000011
oooo003oooooROooo`00ooooohWoool00?oooon9oooo003oooooROooo`00ooooohWoool00?oooon9
oooo003oooooROooo`00\
\>"],
  ImageRangeCache->{{{0, 391}, {185.625, 0}} -> {-0.0532081, -0.0238146, 
  0.00538726, 0.00538726}, {{9.875, 186.625}, {181.188, 
  4.375}} -> {-31.2292, -16.0587, 0.880674, 0.880674}, {{204.313, 381.125}, {
  181.188, 4.375}} -> {-202.493, -16.0587, 0.880674, 0.880674}}]
}, Closed]],

Cell[BoxData[
    \(\(BadSampleFourier = Chop[Abs[Fourier[bsample]]]; \)\)], "Input"],

Cell["\<\
filterMatrix=
imageNormalize[BadSampleFourier]-imageNormalize[SampleFourier];\
\>", "Input",
  FormatType->InputForm],

Cell["defectSpect=filterMatrix Fourier[bsample];", "Input",
  FormatType->InputForm],

Cell["\<\
defectPosition=imageNormalize[Chop[InverseFourier[defectSpect]]];\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False,AspectRatio->size[[1]]/size[[2]]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Identified) show
129.000000 13.000000 moveto
(Defect) show
165.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0017oool0
0`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Boooo00<0
003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000oooo
o`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`003?ooo`<00003oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`003?ooo`030000oooooooo00;oool00`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000=oooo00L0003oooooooooool0003oool000001?oo
o`<0003noooo0`0000Coool000goool01`000?ooooooooooo`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool2
0000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`003Oooo`<00002oooo00<0003oooooool00ooo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003_ooo`060000oooooooo0000oooo
00001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?ooo`@000001?ooo`00
0?ooo`0000Coool30000o_ooo`<00004oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool200000_ooo`030000
oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000koool01@000?oo
ooooooooo`000005oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`0l
oooo10000<3oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0??ooo`@00030oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo03[oool80000__ooo`030000oooooooo00;oool0
01Soool20000>oooo`P0002moooo0P0000Coool001Soool00`000?ooooooo`0joooo20000;koool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0>_ooo`P0002noooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo03[oool80000__ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`0joooo20000;koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0??ooo`@00030
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo03coool40000`?ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?ooo`800004
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?oo
o`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool30000o_ooo`<00004
oooo000<oooo0P0000?oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000<oooo00<0003oooooool00_ooo`030000oooo000000Coool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool000goool200000oooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000ooooo`7oool2
00001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool00`000?oo
ooooo`02oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool30000o_oo
o`<00004oooo000=oooo00L0003oooooooooool0003oool000001?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000=oooo00<0003oooooool00_ooo`030000
oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Ooo
o`800004oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1
oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool000Koool500000_ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo0008oooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000Soool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`<0003noooo0`0000Coool0
00Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`002?ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0007oooo0P00
00Coool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`001_ooo`D000001?ooo`000000000000?oool0
0`000?ooooooo`03oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0008oooo00D0
003oooooooooool000001?ooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool000Soool00`000?ooooooo`02oooo00L0003oooooooooool0003oool000001?oo
o`<0003noooo0`0000Coool000Soool00`000?ooooooo`02oooo00L0003oooooooooool0003oool0
00001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`002?ooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo0007oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Ooo
o`800004oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P0000?oool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`800004
oooo000Hooooo`0000D00004oooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Ooo
o`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00J?ooo`<00003oooo0`0000;oool2000000?o
ool0000000000_ooo`030000oooooooo00800002oooo0`0000;oool300000_ooo`<00003oooo0P00
00?oool300004?ooo`@00003oooo0P0000;oool300000oooo`800002oooo0`0000?oool20000F_oo
o`00JOooo`050000oooooooooooo000000;oool00`000?ooo`000004oooo00H0003oooooool0003o
ool00002oooo00@0003oooooool00004oooo00<0003oooooool00_ooo`050000oooooooooooo0000
00Coool010000?ooooooo`00017oool01P000?ooooooo`000?ooo`0000Goool01@000?oooooooooo
o`000004oooo00<0003oooooool00_ooo`040000oooooooo0000FOooo`00JOooo`050000oooooooo
oooo000000;oool00`000?ooo`00000200000_ooo`060000oooooooo0000oooo00001Oooo`030000
oooooooo00;oool00`000?ooooooo`02oooo00@0003oooooooooool300000_ooo`040000oooooooo
00004Oooo`050000oooooooo0000oooo00<00003oooo00@0003oooooooooool300000_ooo`030000
oooooooo00;oool00`000?ooooooo`1Joooo001Yoooo00<0003oooooool00_ooo`<000001Oooo`00
000000000?ooo`04000000?oool0000000000P0000;oool200000oooo`<00002oooo0P0000?oool3
00000oooo`<0000Aoooo00D0003oooooool0003oool00`0000;oool300000_ooo`<00002oooo0`00
0003oooo000000000080001Joooo001Yoooo00<0003oooooool01?ooo`030000oooooooo00Woool0
0`000?ooooooo`08oooo00<0003oooooool03_ooo`030000oooooooo00ooool010000?ooooooo`00
00Ooool00`000?ooooooo`0;oooo00<0003oooooool0F_ooo`00J?ooo`<00004oooo0P00017oool0
0`000?ooooooo`03oooo00D0003oooooooooool000002_ooo`80000@oooo100000Woool00`000?oo
ooooo`1Woooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ Bad\ Photo2\)], "Input"],

Cell[BoxData[
    \(\(sample3 = sample; \)\)], "Input"],

Cell["\<\
Do[sample3[[i,j]]=0,
\t\t{i,50,60},{j,30, 40}];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\(bsample = sample3; \)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
BadSamplePhoto=ListDensityPlot[bsample,
\tMesh->False,AspectRatio->size[[1]]/size[[2]],
\tPlotLabel->\"Bad Sample Photo\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SamplePhoto,BadSamplePhoto}]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -38 0 ]
[.5 1.0125 38 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Sample) show
105.000000 13.000000 moveto
(Photo) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -50 0 ]
[.5 1.0125 50 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Bad) show
87.000000 13.000000 moveto
(Sample) show
129.000000 13.000000 moveto
(Photo) show
159.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFF000000000000000000000000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFF000000000000000000000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFF000000000000000000000000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF000000000000000000000000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF000000000000000000000000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFF0000000000000000000000FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFF0000000000000000000000FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF000000000000000000000000FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFF0000000000000000000000FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00000000000000000000000000FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000000000000000000000FFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 137.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000RAP00`40o`000?l0003oooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000Noooo00<0003oooooool02Ooo
o`<00003oooo00<0003oooooool02?ooo`<00002oooo00<0003oooooool01oooo`800004oooo00<0
003oooooool02?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo1@0000;oool00`000?oo
ooooo`02oooo00@0003oooooooooool5000000Coool0000000000003oooo00<0003oooooool0:?oo
o`030000oooooooo00Woool300000oooo`030000oooooooo00Soool300000_ooo`030000oooooooo
00Koool200001?ooo`030000oooooooo00Soool00`000?ooooooo`02oooo00<0003oooooool01?oo
o`D00002oooo00<0003oooooool00_ooo`030000oooooooo00D000001?ooo`000000000000?oool0
0`000?ooooooo`0=oooo000Moooo00<0003oool000002_ooo`030000oooooooo00;oool00`000?oo
o`00000:oooo00H0003oooooool0003oool00008oooo00<0003oool000000_ooo`030000oooo0000
00Soool00`000?ooo`000002oooo00<0003oool000001_ooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`000004oooo00D0003oooooooooool000001?ooo`030000oooo000002Soool0
0`000?ooo`00000:oooo00<0003oooooool00_ooo`030000oooo000000[oool01P000?ooooooo`00
0?ooo`0000Ooool00`000?ooo`000002oooo00<0003oool000002?ooo`030000oooo000000;oool0
0`000?ooo`000007oooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool0
1@000?ooooooooooo`000004oooo00<0003oool000003_ooo`007Oooo`030000oooo000000_oool0
1`000?ooooooooooo`000?ooo`000008oooo10000004oooo0000oooo00002?ooo`030000oooo0000
00;oool00`000?ooo`000008oooo00<0003oool000000_ooo`030000oooo000000Koool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo00;oool01`000?oo
ooooooooo`000?ooo`00000Xoooo00<0003oool000002oooo`070000oooooooooooo0000oooo0000
00Soool4000000Coool0003oool00007oooo00<0003oool000000_ooo`030000oooo000000Soool0
0`000?ooo`000002oooo00<0003oool000001oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000003oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000koool0
01goool00`000?ooo`00000;oooo00L0003oooooooooool0003oool000002?ooo`030000oooo0000
00;oool00`000?ooo`000008oooo0P0000?oool00`000?ooo`000009oooo00L0003oooooooooool0
003oool000001_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0
003oooooool00_ooo`070000oooooooooooo0000oooo000002Soool00`000?ooo`00000;oooo00L0
003oooooooooool0003oool000002?ooo`030000oooo000000;oool00`000?ooo`000007oooo0P00
00?oool00`000?ooo`000009oooo00L0003oooooooooool0003oool000001oooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000003oooo00<0003oooooool00_ooo`070000oooooooo
oooo0000oooo000000koool001goool00`000?ooo`00000:oooo00<0003oool000000_ooo`030000
oooo000000Woool200000_ooo`030000oooo000000Soool00`000?ooooooo`02oooo00<0003oool0
00002?ooo`030000oooo000000;oool00`000?ooo`000006oooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000000Coool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
0000:?ooo`030000oooo000000[oool00`000?ooo`000002oooo00<0003oool000002Oooo`800002
oooo00<0003oool000001oooo`030000oooooooo00;oool00`000?ooo`000008oooo00<0003oool0
00000_ooo`030000oooo000000Ooool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00000oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000>oooo000Noooo00<0
003oooooool02_ooo`030000oooooooo00;oool00`000?ooooooo`09oooo00D0003oooooooooool0
00002_ooo`800003oooo00<0003oooooool02?ooo`030000oooooooo00;oool00`000?ooooooo`04
oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00_ooo`800004oooo00<0003ooooo
ool00_ooo`030000oooooooo02Soool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`030000
oooooooo00Woool01@000?ooooooooooo`000009oooo0P0000?oool00`000?ooooooo`08oooo00<0
003oooooool00_ooo`030000oooooooo00Goool200001?ooo`030000oooooooo00;oool010000?oo
ooooooooo`800004oooo00<0003oooooool00_ooo`030000oooooooo00goool00?oooolQoooo003o
oooo8Oooo`00ooooob7oool001Soool010000?ooooooooooof/0000Poooo00@0003ooooooooooomZ
00002oooo`005oooo`030000oooo000000;oool00`000?ooo`00000?oooo00<0003oooooool03Ooo
o`030000oooooooo00goool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo
00goool00`000?ooooooo`06oooo00<0003oooooool07Oooo`030000oooo000000;oool00`000?oo
o`00000?oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0
003oooooool03Oooo`030000oooooooo00goool00`000?ooooooo`05oooo00<0003oooooool02Ooo
o`005oooo`030000oooo000000;oool20000Ioooo`80000Ooooo00<0003oool000000_ooo`80001W
oooo00<0003oooooool02Oooo`005oooo`030000oooo000000;oool010000?ooo`00000000Coool4
00000_ooo`050000oooooooo0000oooo00P00002oooo00<0003oool000000_ooo`040000oooooooo
oooo0P000003oooo0000000000H000000oooo`0000000003000000Coool00000003oool4000000?o
ool0003oool00P0000;oool01@000?ooo`000?ooo`000002oooo0P000003oooo0000000000800000
0oooo`000?ooo`04000000?oool0000000000_ooo`800008oooo00<0003oooooool07Oooo`030000
oooo000000;oool010000?ooo`00000000Coool400000_ooo`030000oooooooo008000000oooo`00
0000000500000_ooo`050000oooo0000oooo000000?oool3000000?oool00000000010000003oooo
0000000000D000001?ooo`000?ooooooo`D00002oooo0P0000;oool200000_ooo`030000oooo0000
00@000001Oooo`000?ooo`000?ooo`04000000?oool0000000000_ooo`800008oooo00<0003ooooo
ool02Oooo`005oooo`030000oooo000000;oool01@000?ooo`0000000?ooo`05000000?oool0003o
ool00`000003oooo0000000000<000000oooo`000000000700000_ooo`P000000oooo`0000000007
00000_ooo`040000oooo0000oooo200000;oool300000_ooo`L000000oooo`000?ooo`0>000000?o
ool0000000000`0000?oool00`000?ooooooo`0Moooo00<0003oool000000_ooo`050000oooo0000
0000oooo00D000000oooo`000?ooo`03000000?oool0000000003@000003oooo0000000001400000
1?ooo`0000000?ooo`8000001?ooo`0000000?ooo`<00002oooo0`0000;oool7000000?oool0003o
ool03P000003oooo0000000000<00003oooo00<0003oooooool02Oooo`006?ooo`060000oooooooo
oooo0000oooo0P0000?oool010000?ooo`000?ooo`<000000oooo`000?ooo`0300000_ooo`<00000
0oooo`0000000002000000?oool0000000001`000005oooo000000000000oooo008000000oooo`00
00000005000000?oool0000000000`000003oooo0000oooo00<00002oooo0`000003oooo00000000
00<000000oooo`000000000200000oooo`D000000oooo`0000000002000000?oool0000000000P00
0003oooo0000oooo00;oool00`000?ooooooo`0Noooo00H0003oooooooooool0003oool200000ooo
o`040000oooo0000oooo0`000003oooo0000oooo00<00002oooo0`000003oooo0000000000800000
1Oooo`00000000000?ooo`05000000?oool0000000000`0000;oool3000000Goool000000000003o
ool010000003oooo0000000000@000000oooo`000?ooo`07000000?oool0000000000`0000;oool5
000000?oool0000000000P000003oooo00000000008000000oooo`000?ooo`02oooo00<0003ooooo
ool02Oooo`007?ooo`D000001?ooo`000?ooooooo`<00003oooo0P0000Koool200000_ooo`T00003
oooo00`0003oool0003oool0003oool0003oool0003oool0003oool2000000Goool000000000003o
ool00P0000;oool010000?ooooooooooo`D00002oooo1`0000Coool800000_ooo`8000001oooo`00
0?ooooooo`000?ooo`000002oooo0P0002Coool00`000?ooo`000002000000Coool0003oooooool3
00000oooo`800005oooo0`0000;oool4000000Goool00000003oool000000_ooo`8000000oooo`00
0?ooo`02000000Woool0003oool0003oool0003oool0003oool01P0000;oool00`000?ooooooo`05
00000_ooo`L00004oooo200000;oool2000000Ooool0003oooooool0003oool000000oooo`030000
oooooooo00Woool001coool01P000?ooo`0000000?ooo`0000;oool2000000Coool0003oool00004
oooo0`0000;oool00`000?ooo`000004000000?oool0003oool01`0000;oool7000000Coool0003o
ool00002oooo00d0003oool00000003oool0003oool0003oool0003oool0003oool01@0000?oool2
000000?oool000000000100000;oool2000000Coool00000003oool300000_ooo`050000oooo0000
oooo000000?oool00`000?ooooooo`0Roooo00H0003oool00000003oool00002oooo0P000004oooo
0000oooo00001?ooo`<000001?ooo`000?ooooooo`H00002oooo1P0000;oool5000000Coool00000
00000002oooo00<0003oooooool00P000007oooo00000000oooo0000oooo000000;oool600000ooo
o`8000000oooo`000000000400000_ooo`8000001?ooo`0000000?ooo`<00002oooo00D0003oool0
003oool000000oooo`030000oooooooo00Woool001coool00`000?ooooooo`02000000Goool00000
0000003oool02P000003oooo0000oooo00<000000oooo`000000000@000000Koool00000003oool0
003oool4000000?oool0000000001`000005oooo000000000000oooo00H00002oooo10000003oooo
00000000008000000oooo`000000000800000_ooo`@00002oooo00<0003oooooool08_ooo`030000
oooooooo008000001Oooo`00000000000?ooo`0900000_ooo`030000oooo0000008000000oooo`00
0000000:000000?oool0000000001`000003oooo0000000000<000000oooo`0000000003000000?o
ool0000000000_ooo`8000000oooo`000000000400000_ooo`@000000oooo`0000000002000000?o
ool000000000200000;oool400000_ooo`030000oooooooo00Woool001coool00`000?ooooooo`04
oooo00T0003oooooooooool0003oool0003oool000000_ooo`030000oooooooo00<000001Oooo`00
000000000?ooo`0200000oooo`<000002_ooo`000?ooooooo`000?ooo`000?ooo`000?ooo`800002
oooo0P0000;oool500000oooo`030000oooooooo00@00003oooo0`000004oooo0000000000001Ooo
o`<000001_ooo`0000000?ooo`000?ooo`800002oooo0`000003oooo0000000000;oool00`000?oo
ooooo`0Roooo00<0003oooooool01?ooo`090000oooooooooooo0000oooo0000oooo000000;oool0
0`000?ooooooo`03000000Goool000000000003oool00P0000;oool500000oooo`050000oooo0000
0000oooo00<000001?ooo`000?ooo`0000;oool3000000?oool0003oool00_ooo`030000oooooooo
00<00003oooo00@0003oool0003oool300001Oooo`040000oooo0000oooo0P000003oooo0000oooo
00800002oooo0`000003oooo0000000000;oool00`000?ooooooo`09oooo000Loooo40000003oooo
000000000240000>oooo0`0000Coool00`000?ooooooo`02oooo00D0003oooooooooool000000_oo
o`030000oooooooo00;oool01@000?ooo`000?ooo`000004oooo0P000004oooo00000000oooo0P00
02Coool00`000?ooo`00000=000000?oool0000000008@0000goool00`000?ooo`000004oooo00<0
003oooooool00oooo`030000oooooooo008000000oooo`000?ooo`03oooo00D0003oool0003oool0
00001?ooo`8000000oooo`0000000002oooo00<0003oooooool02Oooo`007?ooo`030000oooo0000
00800003oooo;`000003oooo0000000000X000000oooo`000000000H00000_ooo`060000oooooooo
0000oooo00000oooo`030000oooooooo02;oool00`000?ooo`00000200000oooo`l000000oooo`00
00000008000000?oool0000000004@0000;ooolV00000_ooo`060000oooooooo0000oooo00000ooo
o`030000oooooooo00Woool001coool00`000?ooo`00000E000000Coool0000000000003oooo00@0
003oooooool00003oooo1P0000;oool>00000_ooo`<000000oooo`000?ooo`0T00000_ooo`030000
oooooooo02;oool00`000?ooo`00000E000000?oool0000000000oooo`8000000oooo`000?ooo`02
oooo1`000003oooo0000000000H000000oooo`0000000004000000Goool000000000003oool09P00
00;oool00`000?ooooooo`09oooo000Loooo00<0003oool000004@000005oooo000000000000oooo
00D000000oooo`0000000007oooo10000005oooo000000000000oooo00D00002oooo00<0003oool0
00000_ooo`X000000oooo`000000000:000000Goool0003oooooool000001?ooo`/00002oooo00<0
003oooooool08_ooo`030000oooo0000014000000oooo`0000000002oooo200000Ooool3000000?o
ool00000000010000003oooo0000000000?oool010000?ooo`000?ooo`H000000oooo`000000000>
000000Goool0003oooooool000001?ooo`/00002oooo00<0003oooooool02Oooo`007?ooo`D00002
oooo0P0000;oool>000000?oool0000000001`000003oooo0000oooo00?oool01`000?ooo`000?oo
o`000?ooo`000003oooo100000;oool400000ooooa@0000:oooo00D0003oooooooooool000001?oo
o`040000oooo000000009?ooo`030000oooo000000800002oooo0P0000;oool>000000?oool00000
00000`000003oooo0000000000;oool00`000?ooooooo`02oooo0P000003oooo0000oooo00800003
oooo10000003oooo0000oooo00800003oooo500000[oool01@000?ooooooooooo`000004oooo00@0
003oooooool0000;oooo000Loooo00<0003oool000004P0000Goool6000000Coool00000003oool4
00001oooo`8000000oooo`0000000006000000Coool00000003ooolF00001_ooo`800002oooo00D0
003oooooooooool000000oooo`050000oooooooooooo000002Coool00`000?ooo`00000B00001Ooo
o`H000001?ooo`000?ooooooo`@00007oooo10000003oooo0000000000<00002oooo00@0003oool0
003oool:000000?oool0000000001`0000Koool200000_ooo`050000oooooooooooo000000?oool0
1@000?ooooooooooo`00000;oooo000Boooo0`0000?oool01P000?ooooooooooo`000?oooa@00000
0oooo`000?ooo`02oooo2@0001Goool00`000?ooooooo`02oooo30000003oooo0000000000L00002
oooo1@0000?oool00`000?ooo`000002000000Coool0000000000003oooo00<0003oooooool06?oo
o`<00003oooo00H0003oooooooooool0003ooolF00000_ooo`X0000Doooo00<0003oooooool00ooo
o`/000000oooo`000000000700000oooo`@00003oooo00<0003oool000000P000004oooo00000000
00000oooo`030000oooooooo00Woool001;oool00`000?ooooooo`02oooo00<0003oool000000_oo
o`040000oooo000000000oooo`d00004oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`0@oooo00<0003oooooool01_ooo`800003oooo1P0000Coool00`000?ooo`000003
oooo00D0003oooooooooool000000oooo`050000oooooooooooo000001[oool00`000?ooooooo`02
oooo00<0003oool000000_ooo`040000oooo000000000oooo`d00004oooo00<0003oooooool02?oo
o`030000oooooooo00Koool00`000?ooooooo`0@oooo00<0003oooooool01_ooo`030000oooo0000
00?oool500001?ooo`030000oooo000000?oool01@000?ooooooooooo`000003oooo00D0003ooooo
ooooool000002oooo`004oooo`070000oooooooooooo0000oooo000000;oool400000oooo`T0000C
oooo00<0003oooooool00oooo`040000oooooooooooo0P0000koool200002_ooo`030000oooooooo
00?oool600004Oooo`030000oooooooo0080000Koooo00L0003oooooooooool0003oool000000_oo
o`@00003oooo2@0001?oool00`000?ooooooo`03oooo00<0003oooooool00P0000koool00`000?oo
o`000009oooo00<0003oooooool00oooo`H0000Aoooo00D0003oooooooooool000002oooo`004ooo
o`070000oooooooooooo0000oooo000000;oool010000?ooo`00000000;oool5000000?oool00000
00000P0000;oool2000000Coool0003oooooool2000000?oool0003oool01_ooo`060000oooooooo
oooo0000oooo0`0000;oool200000oooo`800009oooo00@0003oool000000004oooo0P0000;oool2
00000_ooo`030000oooo000000X00003oooo00D0003oool0003oool000000oooo`050000oooooooo
oooo000001_oool01`000?ooooooooooo`000?ooo`000002oooo00@0003oool000000002oooo1@00
0003oooo0000000000800002oooo0P000004oooo0000oooooooo0`0000Soool00`000?ooooooo`02
000000?oool0000000000_ooo`800003oooo00<0003oool000002Oooo`<00005oooo0P000003oooo
0000000000;oool00`000?ooo`00000:00000oooo`050000oooo0000oooo000000?oool01@000?oo
ooooooooo`00000;oooo000Boooo00<0003oool000000_ooo`030000oooo000000;oool01@000?oo
o`0000000?ooo`0400001?ooo`040000oooooooooooo0`000003oooo0000oooo00coool01@000?oo
ooooooooo`000003oooo00D0003oooooooooool000001?ooo`030000oooooooo00Koool00`000?oo
o`00000200001?ooo`<000000oooo`0000000002oooo0P0000Goool4000000?oool0000000000_oo
o`050000oooooooooooo000000?oool01@000?ooooooooooo`00000Joooo00<0003oool000000_oo
o`030000oooo000000;oool01@000?ooo`0000000?ooo`0400001?ooo`040000oooooooooooo0P00
00;oool00`000?ooooooo`0;oooo00@0003oooooool00003oooo00D0003oooooooooool000001Ooo
o`030000oooooooo00Goool00`000?ooooooo`0200001?ooo`<00002oooo00<0003oooooool00P00
00Goool4000000?oool0000000000_ooo`050000oooooooooooo000000?oool01@000?oooooooooo
o`00000;oooo000Coooo00<0003oooooool00_ooo`060000oooooooooooo0000oooo1P0000Coool0
0`000?ooo`000004oooo0P0000koool00`000?ooooooo`05oooo00D0003oooooooooool000000ooo
o`030000oooo000000Goool2000000?oool0000000000P0000?oool010000?ooooooo`0000;oool3
00002?ooo`030000oooooooo00800002oooo0P0000?oool01@000?ooooooooooo`000003oooo00<0
003oooooool06Oooo`030000oooooooo00;oool01P000?ooooooooooo`000?ooo`H00004oooo00<0
003oool000001?ooo`80000>oooo00<0003oooooool01?ooo`050000oooooooooooo000000?oool0
0`000?ooo`000006oooo00<0003oooooool00`0000?oool010000?ooooooo`0000;oool300002Ooo
o`040000oooo000000000_ooo`800003oooo00D0003oooooooooool000000oooo`030000oooooooo
00Woool001coool600002?ooo`<00002oooo00<0003oooooool00oooo`030000oooooooo00Ooool0
0`000?ooooooo`05oooo00D0003oooooooooool000001?ooo`800008oooo100000;oool3000000Co
ool0003oooooool300000_ooo`800008oooo0P0000;oool010000?ooooooo`0000Coool00`000?oo
ooooo`0200009?ooo`030000oooo000000<00008oooo0`0000;oool00`000?ooooooo`03oooo00<0
003oooooool01oooo`030000oooooooo00Goool01@000?ooooooooooo`000004oooo00<0003ooooo
ool01oooo`<00002oooo0`000004oooo0000oooooooo0`0000;oool200002?ooo`800002oooo00@0
003oooooool00004oooo00D0003oooooooooool000002oooo`007?ooo`030000oooo000000P00002
oooo1@000003oooo0000oooo00Coool00`000?ooooooo`07oooo00<0003oooooool02Oooo`800004
oooo00<0003oooooool01?ooo`8000000oooo`000000000200000oooo`030000oooo000000;oool3
000000Coool00000003oool500001?ooo`@00002oooo00@0003oooooooooool200000oooo`030000
oooooooo02;oool00`000?ooo`00000800000_ooo`H00006oooo00<0003oooooool01oooo`030000
oooooooo00Woool200000oooo`030000oooooooo00Coool200000_ooo`<00004oooo0P0000;oool3
000000Coool00000003oool500001?ooo`@00002oooo00@0003oooooooooool200000oooo`030000
oooooooo00Woool001coool010000?ooo`00000000Coool010000?ooo`000?ooo`@000000oooo`00
00000006oooo00<0003oooooool01oooo`030000oooooooo00[oool00`000?ooooooo`0;oooo1@00
00?oool00`000?ooo`000003oooo00<0003oool000001_ooo`030000oooooooo00800002oooo00<0
003oool00000100000;oool200000oooo`030000oooooooo02;oool010000?ooo`00000000Coool0
10000?ooo`000?ooo`@000000oooo`0000000006oooo00<0003oooooool01_ooo`80000<oooo00<0
003oooooool02oooo`@00004oooo0P0000?oool00`000?ooo`000006oooo00<0003oooooool00P00
00;oool00`000?ooo`00000400000_ooo`800003oooo00<0003oooooool02Oooo`007?ooo`040000
oooooooo00001?ooo`030000oooo0000008000001?ooo`000?ooooooo`80000@oooo00<0003ooooo
ool02Oooo`030000oooo000000;oool200002?ooo`<00002oooo00<0003oool000000P0000Coool2
00000oooo`030000oooooooo00Woool5000000?oool0000000000P0000?oool00`000?ooooooo`0R
oooo00@0003oooooool00004oooo00<0003oool000000P000004oooo0000oooooooo0P00013oool0
0`000?ooooooo`09oooo0P0000?oool00`000?ooooooo`06oooo00<0003oool000000oooo`800000
0oooo`0000000003oooo0P0000?oool00`000?ooooooo`09oooo1@000003oooo0000000000800003
oooo00<0003oooooool02Oooo`007?ooo`800002oooo00<0003oool000000`000005oooo0000oooo
oooo000000Coool00`000?ooooooo`0=oooo00<0003oooooool02_ooo`800004oooo00<0003ooooo
ool01Oooo`060000oooooooo0000oooo00000oooo`040000oooooooooooo0P000003oooo0000oooo
00[oool01P000?ooooooooooo`000?ooo`L00002oooo0P0002Coool01P000?ooooooooooo`000?oo
o`@000001Oooo`000?ooooooo`000003oooo00<0003oooooool03_ooo`030000oooooooo00[oool0
0`000?ooooooo`02oooo00<0003oooooool01Oooo`040000oooooooo00000_ooo`050000oooooooo
oooo000000;oool2000000?oool0003oool02_ooo`060000oooooooooooo0000oooo1`0000?oool0
0`000?ooooooo`09oooo000Loooo00@0003oool0003oool2000000?oool0000000000`0000Goool2
00001Oooo`030000oooooooo00Ooool200002Oooo`040000oooo0000oooo0P0000?oool00`000?oo
ooooo`06oooo0P0000Koool010000?ooooooooooo`8000000oooo`000000000400000oooo`800004
oooo2@000005oooo0000oooooooo000002Coool010000?ooo`000?ooo`8000000oooo`0000000003
00001Oooo`800005oooo00<0003oooooool01_ooo`800009oooo00<0003oool000000`0000?oool2
00002?ooo`030000oooooooo00Goool00`000?ooooooo`02000000?oool000000000100000?oool2
00001?ooo`T000001Oooo`000?ooooooo`00000;oooo000Loooo00@0003oooooooooool600001?oo
o`030000oooooooo0080000<oooo00D0003oooooooooool000000oooo`030000oooooooo00Woool0
10000?ooooooo`0000Goool00`000?ooooooo`05oooo0P000003oooo0000oooo00Coool200003_oo
o`L00002oooo00D0003oooooooooool000009?ooo`040000oooooooooooo1P0000Coool00`000?oo
ooooo`0200003?ooo`040000oooooooo00000oooo`80000:oooo00D0003oooooooooool000001?oo
o`030000oooooooo00Goool200000_ooo`030000oooooooo00;oool00`000?ooo`00000=oooo1`00
00;oool01@000?ooooooooooo`00000;oooo000Loooo00P0003oooooool0003oool0003oool00005
oooo00@0003oooooool0000Boooo00D0003oooooooooool000000oooo`030000oooooooo00Goool0
0`000?ooooooo`07oooo00H0003oooooool0003oool00003oooo0P0000Coool3000000?oool00000
00001_ooo`030000oooooooo00;oool600000oooo`050000oooooooooooo000002Coool020000?oo
ooooo`000?ooo`000?ooo`0000Goool010000?ooooooo`00017oool01@000?ooooooooooo`000003
oooo00<0003oooooool01Oooo`800008oooo00@0003oooooool00002oooo00H0003oooooool0003o
ool00003oooo0P000004oooo0000000000001_ooo`030000oooooooo00;oool600000oooo`050000
oooooooooooo000000_oool001coool2000000?oool0003oool00_ooo`050000oooooooooooo0000
00;oool00`000?ooooooo`06oooo0P0000Ooool010000?ooo`00000000?oool01@000?ooo`000?oo
o`000007oooo00D0003oooooooooool000001Oooo`<0000<oooo0`0000;oool00`000?ooooooo`03
oooo0P000003oooo0000oooo00D000000oooo`000?ooo`0300000_ooo`80000Toooo00@0003ooooo
ool00003oooo00D0003oooooooooool000000_ooo`030000oooooooo00Goool00`000?ooo`000007
oooo0`0000Coool010000?ooo`00000000Ooool200000oooo`030000oooooooo00;oool400002ooo
o`8000001?ooo`000?ooo`0000Goool2000000?oool0003oool01@000003oooo0000oooo00<00003
oooo00<0003oooooool02Oooo`007?ooo`030000oooo000000800005oooo0P0000;oool500001?oo
o`800006oooo1@0000;oool3000000Ooool0003oooooool0003oool000001?ooo`060000oooooooo
0000oooo00000_ooo`800002oooo00<0003oool000000oooo`030000oooooooo00;oool00`000?oo
ooooo`0500000oooo`030000oooo000000X000001?ooo`000?ooo`0000?oool00`000?ooooooo`0R
oooo00<0003oool000000P0000Goool200000_ooo`D00003oooo00<0003oool000001Oooo`D00002
oooo0P000003oooo0000000000;oool00`000?ooo`000005oooo00<0003oooooool00P0000;oool2
00000_ooo`040000oooooooo00000oooo`050000oooooooooooo000000?oool3000000Coool0003o
ooooool=000000Coool0003oool00003oooo00<0003oooooool02Oooo`004oooo`<00002oooo00D0
003oooooooooool000000_ooo`030000oooooooo00Goool010000?ooooooo`0000Soool00`000?oo
ooooo`05oooo1@0000?oool00`000?ooo`00000300003_ooo`030000oooooooo00coool010000?oo
ooooooooo`L000000oooo`0000000002000000?oool0000000002`0000;oool00`000?ooooooo`0I
oooo0`0000;oool01@000?ooooooooooo`000002oooo00<0003oooooool01Oooo`040000oooooooo
00001oooo`030000oooooooo00Goool00`000?ooo`00000200000oooo`050000oooooooo0000oooo
0080000>oooo00<0003oooooool03?ooo`040000oooooooooooo1P0000;oool3000000?oool00000
00002`0000;oool00`000?ooooooo`09oooo000Doooo00H0003oooooool0003oool00002oooo00@0
003oooooool00006oooo0P000006oooo0000oooo0000oooo00001Oooo`030000oooooooo00Goool0
0`000?ooo`00000200000_ooo`8000000oooo`000?ooo`0200002?ooo`030000oooooooo00Goool0
0`000?ooooooo`02oooo00<0003oooooool01Oooo`040000oooooooooooo1P0000?oool200000_oo
o`D000000oooo`0000000002000000?oool0003oool00_ooo`030000oooooooo01[oool01P000?oo
ooooo`000?ooo`0000;oool010000?ooooooo`0000Koool2000000Koool0003oool0003oool00004
oooo00<0003oooooool01_ooo`040000oooo000000000_ooo`800002oooo00@0003oool000000007
oooo00<0003oooooool01Oooo`030000oooooooo00;oool00`000?ooooooo`06oooo00<0003ooooo
ool01P0000?oool200000_ooo`D000000oooo`0000000002000000?oool0003oool00_ooo`030000
oooooooo00Woool001;oool4000000Coool0003oool00002oooo0P0000Coool7000000Goool00000
003oool000001_ooo`030000oooooooo00Koool300000_ooo`800003oooo00D0003oooooool0003o
ool00P0000?oool2000000?oool0000000000_ooo`030000oooooooo00;oool00`000?ooooooo`02
oooo00D0003oooooooooool000000oooo`<000000oooo`0000000002oooo0`000003oooo00000000
00`000000oooo`000000000Joooo10000004oooo0000oooo00000_ooo`800004oooo1`000005oooo
00000000oooo000000Koool00`000?ooooooo`06oooo0`000004oooo0000oooo00000_ooo`040000
oooooooo00000_ooo`040000oooooooooooo0P0000;oool010000?ooooooo`0000Coool00`000?oo
ooooo`02oooo0P0000;oool200000_ooo`<000000oooo`0000000003oooo0P000003oooo00000000
00`00002oooo00<0003oooooool02Oooo`004_ooo`030000oooo000000;oool00`000?ooo`000002
oooo00@0003oooooool00003oooo00<0003oooooool00P0000?oool300001_ooo`030000oooooooo
00Goool2000000Goool0003oooooool000000_ooo`030000oooo000000Coool00`000?ooooooo`03
oooo00@0003oool000000002oooo00<0003oooooool01oooo`080000oooooooooooo0000oooo0000
oooo0P0000;oool3000000Goool000000000003oool02P0000;oool200000_ooo`030000oooooooo
01Soool00`000?ooo`000002oooo00<0003oool000000_ooo`040000oooooooo00000oooo`030000
oooooooo00800003oooo0`0000Koool00`000?ooooooo`05oooo0P000004oooo0000oooo00000ooo
o`<00004oooo00<0003oooooool00_ooo`8000001Oooo`000?ooooooo`000009oooo0P0000;oool0
10000?ooo`000?ooo`800003oooo0P0000;oool2000000?oool000000000200000;oool200000_oo
o`030000oooooooo00Woool001?oool200000_ooo`030000oooo000000;oool010000?ooooooo`00
00;oool2000000Coool0003oool00002oooo0`00013oool3000000Coool0003oooooool200001ooo
o`800002oooo0`000003oooo0000oooo00?oool00`000?ooooooo`05oooo00<0003oooooool00P00
00;oool00`000?ooo`000002oooo0`000005oooo000000000000oooo00D000000oooo`0000000002
00000_ooo`800002oooo00<0003oooooool06Oooo`800002oooo00<0003oool000000_ooo`040000
oooooooo00000_ooo`8000001?ooo`000?ooo`0000;oool300004?ooo`050000oooo0000oooo0000
00;oool200001_ooo`800002oooo0P000003oooo0000000000Goool00`000?ooooooo`05oooo00T0
003oool0003oool0003oool0003oool000000oooo`800002oooo0P000003oooo0000000000<00000
0oooo`000000000200000_ooo`800002oooo00<0003oooooool02Oooo`005?ooo`050000oooooooo
oooo000000?oool01P000?ooooooooooo`000?ooo`8000001?ooo`000000000000;oool300004Ooo
o`800003oooo0`0000coool300004?ooo`030000oooooooo00;oool3000000Goool000000000003o
ool00P000003oooo0000000000@00003oooo0P000004oooo0000000000000_ooo`030000oooooooo
01[oool01@000?ooooooooooo`000003oooo00H0003oooooooooool0003oool2000000Coool00000
00000002oooo0`00013oool00`000?ooo`000002oooo00@0003oool00000000<oooo0`0000ooool0
0`000?ooooooo`02oooo0`000005oooo000000000000oooo008000000oooo`000000000400000ooo
o`8000001?ooo`000000000000;oool00`000?ooooooo`09oooo000Loooo0P0000Coool2000000Go
ool000000000003oool0100000Ooool00`000?ooooooo`07oooo0P000003oooo0000000000800006
oooo00D0003oooooooooool000000_ooo`030000oooooooo00<00003oooo00<0003oool000000ooo
o`8000000oooo`000?ooo`02oooo1@000004oooo00000000oooo2P0000;oool7000000?oool00000
00009?ooo`030000oooooooo00?oool2000000Goool000000000003oool0100000Ooool00`000?oo
ooooo`06oooo00@0003oool0003oool400001_ooo`030000oooooooo008000001?ooo`000?oooooo
o`8000000oooo`000?ooo`02oooo0P0000?oool2000000?oool0003oool00_ooo`8000001?ooo`00
00000?ooo`8000000oooo`000000000800000_ooo`L00002oooo00<0003oooooool02Oooo`007?oo
o`040000oooo000