(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     93008,       2462]*)
(*NotebookOutlinePosition[     93657,       2485]*)
(*  CellTagsIndexPosition[     93613,       2481]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Utilities`MemoryConserve`\n$MemoryIncrement; 
    \n<< \ LinearAlgebra`MatrixManipulation`; \n
    Off[General::spell1, MemoryConserve::start, MemoryConserve::end]; \)], 
  "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[TextData[{
  StyleBox["\:3000     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Daubechies:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
daub2={{1.,1.},{1.,-1.}}/Sqrt[2.];
daub4={{1.+Sqrt[3.], 3.+Sqrt[3.],3.-Sqrt[3.], 1.-Sqrt[3.]},
\t{1.-Sqrt[3.],-3.+Sqrt[3.],3.+Sqrt[3.],-1.-Sqrt[3.]}}/
\t(4 Sqrt[2.]);
daub6={{ .332670552950, .806891509311, .459877502118,
\t\t-.135011020010, -.085441273882, .035226291882},
\t   { .035226291882, .085441273882,-.135011020010,
\t    -.459877502118,.806891509311,-.332670552950}};
daub8={{ 0.325803428051, 1.010945715092, 0.892200138246,
\t    -0.039575026236,-0.264507167369, 0.043616300475,
\t     0.046503601071,-0.014986989330},
\t   {-0.014986989330,-0.046503601071, 0.043616300475,
\t\t 0.264507167369,-0.039575026236,-0.892200138246,
\t\t 1.010945715092,-0.325803428051}}/Sqrt[2.];
daub10={{ .160102397974, .603829269797, .724308528438,
\t\t  .138428145901,-.242294887066,-.032244869585,
\t\t  .077571493840,-.006241490213,-.012580751999,
\t\t  .003335725285},
\t    { .003335725285, .012580751999,-.006241490213,
\t     -.077571493840,-.032244869585, .242294887066,
\t      .138428145901,-.724308528438, .603829269797,
\t     -.160102397974}};
daub12={{ 0.111540743350, 0.494623890398, 0.751133908021,
\t\t  0.315250351709,-0.226264693965,-0.129766867567,
\t\t  0.097501605587, 0.027522865530,-0.031582039318,
\t\t  0.000553842201, 0.004777257511,-0.001077301085},
\t\t{-0.001077301085,-0.004777257511, 0.000553842201,
\t\t  0.031582039318, 0.027522865530,-0.097501605587,
\t\t -0.129766867567, 0.226264693965, 0.315250351709,
\t\t -0.751133908021, 0.494623890398,-0.111540743350}};
daub14={{ .077852054085, .396539319482, .729132090846, 
 \t\t  .469782287405,-.143906003929,-.224036184994,
 \t\t  .071309219267, .080612609151,-.038029936935, 
\t\t -.016574541631, .012550998556, .000429577973, 
\t\t -.001801640704, .000353713800},
\t\t{ .000353713800, .001801640704, .000429577973, 
\t\t -.012550998556,-.016574541631, .038029936935,
\t\t  .080612609151,-.071309219267,-.224036184994,
\t\t  .143906003929, .469782287405,-.729132090846,
\t\t  .396539319482,-.077852054085}};
daub16={{ .054415842243, .312871590914, .675630736297, 
 \t\t  .585354683654,-.015829105256,-.284015542962,
 \t\t  .000472484574, .128747426620,-.017369301002, 
\t\t -.044088253931, .013981027917, .008746094047, 
\t\t -.004870352993,-.000391740373, .000675449406,
\t\t -.000117476784},
\t\t{-.000117476784,-.000675449406,-.000391740373,
\t\t  .004870352993, .008746094047,-.013981027917,
\t\t -.044088253931, .017369301002, .128747426620,
\t\t -.000472484574,-.284015542962, .015829105256,
\t\t  .585354683654,-.675630736297, .312871590914,
\t\t -.054415842243}};
daub18={{ .038077947364, .243834674613, .604823123690, 
 \t\t  .657288078051, .133197385825,-.293273783279, 
\t\t -.096840783223, .148540749338, .030725681479,
\t\t -.067632829061, .000250947115, .022361662124,
\t\t -.004723204758,-.004281503682, .001847646883,
          .000230385764,-.000251963189, .000039347320},
        { .000039347320, .000251963189, .000230385764,
         -.001847646883,-.004281503682, .004723204758,
          .022361662124,-.000250947115,-.067632829061,
         -.030725681479, .148540749338, .096840783223,
         -.293273783279,-.133197385825, .657288078051, 
         -.604823123690, .243834674613,-.038077947364}};
daub20={{ 0.026670057901, 0.188176800078, 0.527201188932,
\t\t  0.688459039454, 0.281172343661,-0.249846424327,
\t\t -0.195946274377, 0.127369340336, 0.093057364604,
\t\t -0.071394147166,-0.029457536822, 0.033212674059,
\t\t  0.003606553567,-0.010733175483, 0.001395351747,
\t\t  0.001992405295,-0.000685856695,-0.000116466855,
\t\t  0.000093588670,-0.000013264203},
\t\t{-0.000013264203,-0.000093588670,-0.000116466855,
\t\t  0.000685856695, 0.001992405295,-0.001395351747,
\t\t -0.010733175483,-0.003606553567, 0.033212674059,
\t\t  0.029457536822,-0.071394147166,-0.093057364604,
\t\t  0.127369340336, 0.195946274377,-0.249846424327,
\t\t -0.281172343661, 0.688459039454,-0.527201188932,
\t\t  0.188176800078,-0.026670057901}};\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[daub2]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.707106781186547461`", "0.707106781186547461`"},
            {"0.707106781186547461`", \(-0.707106781186547461`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[daub4]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.482962913144533967`", "0.836516303737807653`", 
              "0.224143868042013405`", \(-0.129409522551260325`\)},
            {\(-0.129409522551260325`\), \(-0.224143868042013405`\), 
              "0.836516303737807653`", \(-0.482962913144533967`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[daub6]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {
              StyleBox["0.332670552949999986`",
                StyleBoxAutoDelete->True,
                PrintPrecision->12], 
              StyleBox["0.806891509311000021`",
                StyleBoxAutoDelete->True,
                PrintPrecision->12], 
              StyleBox["0.459877502117999981`",
                StyleBoxAutoDelete->True,
                PrintPrecision->12], 
              RowBox[{"-", 
                StyleBox["0.135011020010000004`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->12]}], 
              RowBox[{"-", 
                StyleBox["0.0854412738819999972`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->11]}], 
              StyleBox["0.0352262918819999981`",
                StyleBoxAutoDelete->True,
                PrintPrecision->11]},
            {
              StyleBox["0.0352262918819999981`",
                StyleBoxAutoDelete->True,
                PrintPrecision->11], 
              StyleBox["0.0854412738819999972`",
                StyleBoxAutoDelete->True,
                PrintPrecision->11], 
              RowBox[{"-", 
                StyleBox["0.135011020010000004`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->12]}], 
              RowBox[{"-", 
                StyleBox["0.459877502117999981`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->12]}], 
              StyleBox["0.806891509311000021`",
                StyleBoxAutoDelete->True,
                PrintPrecision->12], 
              RowBox[{"-", 
                StyleBox["0.332670552949999986`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->12]}]}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
coif6={{-.051429728471, .238929728471, .602859456942, 
 \t\t .272140543058,-.051429972847,-.011070271529},
 \t   {-.011070271529, .051429972847, .272140543058,
\t\t-.602859456942, .238929728471, .051429728471}}*
\t\tSqrt[2.];
coif12={{ .011587596739,-.029320137980,-.047639590310, 
 \t\t  .273021046535, .574682393857, .294867193696,
\t\t -.054085607092,-.042026480461, .016744410163, 
 \t\t  .003967883613,-.001289203356,-.000509505399},
 \t\t{-.000509505399, .001289203356, .003967883613,
 \t\t -.016744410163,-.042026480461, .054085607092,
 \t\t  .294867193696,-.574682393857, .273021046535,
\t\t  .047639590310,-.029320137980,-.011587596739}}*
\t\t Sqrt[2.];
coif18={{-.002682418671, .005503126709, .016583560479, 
\t\t -.046507764479,-.043220763560, .286503335274,
 \t\t  .561285256870, .302983571773,-.050770140755, 
\t\t -.058196250762, .024434094321, .011229240962, 
\t\t -.006369601011,-.001820458916, .000790205101,
 \t\t  .000329665174,-.000050192775,-.000024465734},
 \t\t{-.000024465734, .000050192775, .000329665174,
 \t\t -.000790205101,-.001820458916, .006369601011,
 \t\t  .011229240962,-.024434094321,-.058196250762,
 \t\t  .050770140755, .302983571773,-.561285256870,
 \t\t  .286503335274, .043220763560,-.046507764479,
 \t\t -.016583560479, .005503126709, .002682418671}}*
 \t\tSqrt[2.];
coif24={{ .000630961046,-.001152224852,-.005194524026, 
 \t\t  .011362459244, .018867235378,-.057464234429, 
\t\t -.039652648517, .293667390895, .553126452562, 
 \t\t  .307157326198,-.047112738865,-.068038127051,
 \t\t  .027813640153, .017735837438,-.010756318517,
\t\t -.004001012886, .002652665946, .000895594529,
\t\t -.000416500571,-.000183829769, .000044080354, 
 \t\t  .000022082857,-.000002304942,-.000001262175},
 \t\t{-.000001262175, .000002304942, .000022082857,
 \t\t -.000044080354,-.000183829769, .000416500571,
 \t\t  .000895594529,-.002652665946,-.004001012886,
 \t\t  .010756318517, .017735837438,-.027813640153,
 \t\t -.068038127051, .047112738865, .307157326198,
 \t\t -.553126452562, .293667390895, .039652648517,
 \t\t -.057464234429,-.018867235378, .011362459244,
 \t\t  .005194524026,-.001152224852,-.000630961046}}*
 \t\tSqrt[2.];
coif30={{-.000149963800, .000253561200, .001540245700, 
\t\t -.002941110800,-.007163781900, .016552066400, 
 \t\t  .019917804300,-.064997262800,-.036800073600,
 \t\t  .298092323500, .547505429400, .309706849000, 
\t\t -.043866050800,-.074652238900, .029195879500, 
 \t\t  .023110777000,-.013973687900,-.006480090000, 
 \t\t  .004783001400, .001720654700,-.001175822200,
\t\t -.000451227000, .000213729800, .000099377600,
\t\t -.000029232100,-.000015072000, .000002640800, 
 \t\t  .000001459300,-.000000118400,-.000000067300},
 \t\t{-.000000067300, .000000118400, .000001459300,
 \t\t -.000002640800,-.000015072000, .000029232100,
 \t\t  .000099377600,-.000213729800,-.000451227000,
 \t\t  .001175822200, .001720654700,-.004783001400,
 \t\t -.006480090000, .013973687900, .023110777000,
 \t\t -.029195879500,-.074652238900, .043866050800,
 \t\t  .309706849000,-.547505429400, .298092323500,
 \t\t  .036800073600,-.064997262800,-.019917804300,
 \t\t  .016552066400, .007163781900,-.002941110800,
 \t\t -.001540245700, .000253561200, .000149963800}}*
 \t\tSqrt[2.]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[coif6]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-0.0727326195128538977`\), "0.337897662457809211`", 
              "0.852572020212255488`", "0.384864846864202867`", 
              \(-0.0727329651127074239`\), \(-0.015655728135464539`\)},
            {\(-0.015655728135464539`\), "0.0727329651127074239`", 
              "0.384864846864202867`", \(-0.852572020212255488`\), 
              "0.337897662457809211`", "0.0727326195128538977`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    \(\[FilledSquare]\ \ Examples\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(waveletMatrix[4, daub2]\)], "Input"],

Cell[BoxData[
    \({{0.499999999999999911`, 0.499999999999999911`, 0.499999999999999911`, 
        0.499999999999999911`}, {0.499999999999999911`, 
        0.499999999999999911`, \(-0.499999999999999911`\), 
        \(-0.499999999999999911`\)}, {0.707106781186547461`, 
        \(-0.707106781186547461`\), 0.`, 0.`}, {0.`, 0.`, 
        0.707106781186547461`, \(-0.707106781186547461`\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.499999999999999911`", "0.499999999999999911`", 
              "0.499999999999999911`", "0.499999999999999911`"},
            {"0.499999999999999911`", "0.499999999999999911`", 
              \(-0.499999999999999911`\), \(-0.499999999999999911`\)},
            {"0.707106781186547461`", \(-0.707106781186547461`\), "0.`", 
              "0.`"},
            {"0.`", "0.`", "0.707106781186547461`", 
              \(-0.707106781186547461`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[waveletMatrix[4, daub4]]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.482962913144533967`", "0.836516303737807653`", 
              "0.224143868042013405`", \(-0.129409522551260325`\)},
            {"0.224143868042013405`", \(-0.129409522551260325`\), 
              "0.482962913144533967`", "0.836516303737807653`"},
            {\(-0.129409522551260325`\), \(-0.224143868042013405`\), 
              "0.836516303737807653`", \(-0.482962913144533967`\)},
            {"0.836516303737807653`", \(-0.482962913144533967`\), 
              \(-0.129409522551260325`\), \(-0.224143868042013405`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.482962913144533967`", "0.836516303737807653`", 
              "0.224143868042013405`", \(-0.129409522551260325`\)},
            {"0.224143868042013405`", \(-0.129409522551260325`\), 
              "0.482962913144533967`", "0.836516303737807653`"},
            {\(-0.129409522551260325`\), \(-0.224143868042013405`\), 
              "0.836516303737807653`", \(-0.482962913144533967`\)},
            {"0.836516303737807653`", \(-0.482962913144533967`\), 
              \(-0.129409522551260325`\), \(-0.224143868042013405`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[waveletMatrix[6, daub6]]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.332670552949999986`", "0.806891509311000021`", 
              "0.459877502117999981`", \(-0.135011020010000004`\), 
              \(-0.0854412738819999972`\), "0.0352262918819999981`"},
            {\(-0.0854412738819999972`\), "0.0352262918819999981`", 
              "0.332670552949999986`", "0.806891509311000021`", 
              "0.459877502117999981`", \(-0.135011020010000004`\)},
            {"0.459877502117999981`", \(-0.135011020010000004`\), 
              \(-0.0854412738819999972`\), "0.0352262918819999981`", 
              "0.332670552949999986`", "0.806891509311000021`"},
            {"0.0352262918819999981`", "0.0854412738819999972`", 
              \(-0.135011020010000004`\), \(-0.459877502117999981`\), 
              "0.806891509311000021`", \(-0.332670552949999986`\)},
            {"0.806891509311000021`", \(-0.332670552949999986`\), 
              "0.0352262918819999981`", "0.0854412738819999972`", 
              \(-0.135011020010000004`\), \(-0.459877502117999981`\)},
            {\(-0.135011020010000004`\), \(-0.459877502117999981`\), 
              "0.806891509311000021`", \(-0.332670552949999986`\), 
              "0.0352262918819999981`", "0.0854412738819999972`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[waveletMatrix[6, coif6]]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(-0.0727326195128538977`\), "0.337897662457809211`", 
              "0.852572020212255488`", "0.384864846864202867`", 
              \(-0.0727329651127074239`\), \(-0.015655728135464539`\)},
            {\(-0.0727329651127074239`\), \(-0.015655728135464539`\), 
              \(-0.0727326195128538977`\), "0.337897662457809211`", 
              "0.852572020212255488`", "0.384864846864202867`"},
            {"0.852572020212255488`", "0.384864846864202867`", 
              \(-0.0727329651127074239`\), \(-0.015655728135464539`\), 
              \(-0.0727326195128538977`\), "0.337897662457809211`"},
            {\(-0.015655728135464539`\), "0.0727329651127074239`", 
              "0.384864846864202867`", \(-0.852572020212255488`\), 
              "0.337897662457809211`", "0.0727326195128538977`"},
            {"0.337897662457809211`", "0.0727326195128538977`", 
              \(-0.015655728135464539`\), "0.0727329651127074239`", 
              "0.384864846864202867`", \(-0.852572020212255488`\)},
            {"0.384864846864202867`", \(-0.852572020212255488`\), 
              "0.337897662457809211`", "0.0727326195128538977`", 
              \(-0.015655728135464539`\), "0.0727329651127074239`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ Inverse\ Matrices\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[waveletMatrix[4, daub2]]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.499999999999999911`", "0.499999999999999911`", 
              "0.499999999999999911`", "0.499999999999999911`"},
            {"0.499999999999999911`", "0.499999999999999911`", 
              \(-0.499999999999999911`\), \(-0.499999999999999911`\)},
            {"0.707106781186547461`", \(-0.707106781186547461`\), "0.`", 
              "0.`"},
            {"0.`", "0.`", "0.707106781186547461`", 
              \(-0.707106781186547461`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[Transpose[waveletMatrix[4, daub2]]]\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.499999999999999911`", "0.499999999999999911`", 
              "0.707106781186547461`", "0.`"},
            {"0.499999999999999911`", "0.499999999999999911`", 
              \(-0.707106781186547461`\), "0.`"},
            {"0.499999999999999911`", \(-0.499999999999999911`\), "0.`", 
              "0.707106781186547461`"},
            {"0.499999999999999911`", \(-0.499999999999999911`\), "0.`", 
              \(-0.707106781186547461`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      Transpose[waveletMatrix[4, daub2]] . \ waveletMatrix[4, daub2]]\)], 
  "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.999999999999999644`", \(-1.11022302462515654`*^-16\), "0.`", 
              "0.`"},
            {\(-1.11022302462515654`*^-16\), "0.999999999999999644`", "0.`", 
              "0.`"},
            {"0.`", "0.`", "0.999999999999999644`", 
              \(-1.11022302462515654`*^-16\)},
            {"0.`", "0.`", \(-1.11022302462515654`*^-16\), 
              "0.999999999999999644`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[Transpose[waveletMatrix[6, coif6]] . waveletMatrix[6, coif6]]
      \)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1.000000050273804`", "0.`", \(-2.69512842127062057`*^-7\), 
              \(-3.46944695195361418`*^-18\), \(-2.69512842113184269`*^-7\), 
              "0.`"},
            {"0.`", "1.00000005027380378`", "0.`", 
              \(-2.69512842113184269`*^-7\), \(-3.46944695195361418`*^-18\), 
              \(-2.69512842106245376`*^-7\)},
            {\(-2.69512842127062057`*^-7\), "0.`", "1.00000005027380378`", 
              \(-1.38777878078144567`*^-17\), \(-2.69512842117521067`*^-7\), 
              "0.`"},
            {\(-3.46944695195361418`*^-18\), \(-2.69512842113184269`*^-7\), 
              \(-1.38777878078144567`*^-17\), "1.00000005027380378`", 
              "4.55364912443911862`*^-18", \(-2.69512842111449568`*^-7\)},
            {\(-2.69512842113184269`*^-7\), \(-3.46944695195361418`*^-18\), 
              \(-2.69512842117521067`*^-7\), "4.55364912443911862`*^-18", 
              "1.00000005027380378`", \(-2.81892564846231152`*^-18\)},
            {"0.`", \(-2.69512842106245376`*^-7\), "0.`", 
              \(-2.69512842111449568`*^-7\), \(-2.81892564846231152`*^-18\), 
              "1.00000005027380378`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Wavelet\ Transform\)], "Input"],

Cell[BoxData[
    \(\(a = {{1, 0, 1, 1}, {0, 0, 1, 1}, {1, 1, 0, 1}, {1, 1, 1, 1}}; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[a, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.240385 0.0192308 0.240385 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(2)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(3)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(4)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(2)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(3)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(4)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
4 string
4 4 8 [4 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF
0000FFFF
FFFF00FF
FFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0moooo1@0003koool30000?oooo`800011oooo0`0000Koool000koool0
0`000?ooo`000010oooo00<0003oooooool0?_ooo`030000oooooooo047oool00`000?ooooooo`0o
oooo00<0003oooooool01Oooo`003_ooo`030000oooo0000043oool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03koool400001_ooo`003_ooo`030000oooo0000043oool0
0`000?ooooooo`0ooooo00<0003oooooool0@?ooo`030000oooooooo03goool00`000?ooo`000007
oooo000>oooo00<0003oool00000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo00<0
003oool00000@?ooo`800007oooo000?oooo00<0003oooooool0?_ooo`800011oooo00<0003ooooo
ool0?oooo`030000oooooooo043oool00`000?ooooooo`05oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool02_ooo`030000
oooooooo00[oool00`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00_oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0:
oooo00<0003oooooool02oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool00_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0ooooo00<0003oooooool0?ooo
o`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0003oooooool00_ooo`400001oooo0Ooo
o`001?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000
oooo000000Coool30000ooooo`ooool300000_ooo`000oooo`030000oooo000000Coool00`000?oo
ooooo`15oooo@P0008Woool100000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003ooooo
ool0AOoood800029oooo0@00007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`800016oooo@P00
08Soool200000_ooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`800016oooo@P0008Soool200000_ooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`800016oooo@P0008Soool200000_ooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`800016oooo@P0008Soool200000_ooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`000_ooo`D00003oooo00<0003ooooo
ool0AOoood800029oooo0@00007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool30000AOoood800027
oooo0`0000;oool000Coool00`000?ooooooo`03oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo00?ooon40000ROooo`400001
oooo0Oooo`000oooo`800005oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo0P0000Cooon40000R?ooo`800002oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo0P00
00Cooon40000R?ooo`800002oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo0P0000Cooon4
0000R?ooo`800002oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo0P0000Cooon40000R?oo
o`800002oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03ooooQ00008Woool100000Oooo`7oool0
00?oool00`000?ooooooo`04oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`<00003ooooQ00008Ooool300000_ooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`27oooo@P0004Ooool100000Oooo`7oool000?oool00`000?ooo`000004
oooo00<0003oooooool0Qooood800017oooo0@00007oool1oooo0004oooo00<0003oooooool00ooo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`800028oooo@P0004Koool200000_ooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`800028oooo@P0004Koool200000_oo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`800028oooo@P0004Koool200000_ooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`800028oooo@P0004Koool200000_ooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`000oooo`800005
oooo00<0003oooooool0Qooood800017oooo0@00007oool1oooo0005oooo00<0003oooooool00_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool3
0000Qooood800015oooo0`0000;oool000Goool00`000?ooooooo`02oooo00<0003oooooool0oooo
oa7oool100000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000Coool00`000?ooooooo`03oooo00<0003oooooool0oooooa7oool100000Ooo
o`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool0
00[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolA
oooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00
007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool20000oooo
oa7oool200000_ooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0
003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003ooooo
ool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooo
oa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo0?oooolAoooo0@00007oool1oooo000:oooo0P000?oooolAoooo0P0000;oool000[oool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00
007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1
oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3o
oooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:
oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0
003oooooool0oooooa7oool100000Oooo`7oool000[oool20000oooooa7oool200000_ooo`002_oo
o`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Ooo
o`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool0
00[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolA
oooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`80003ooooo4Oooo`800002oooo000:
oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0
003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003ooooo
ool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooo
oa7oool100000Oooo`7oool000Coool300000oooo`030000oooooooo0?oooolAoooo0@00007oool1
oooo0005oooo00<0003oooooool00_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003
oooo100000?oool30000ooooo`ooool300000_ooo`000oooo`030000oooo000000Coool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`001?ooo`800004oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000Goool00`000?ooooooo`02oooo00<0003oooooool0oooooa7oool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo00<0003oooooool02_ooo`030000oooooooo00[oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00_oool00`000?ooooooo`0:
oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000
oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool02_ooo`030000oooooooo00[oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00_oool00`000?ooooooo`02
oooo0@00007oool1oooo000:ooooo`0001D00002oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.244708, -0.268382, 0.0151512, 
  0.0151512}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(b = waveletMatrix[4, daub2] . a; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[b, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.240385 0.0192308 0.240385 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(2)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(3)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(4)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(2)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(3)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(4)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
4 string
4 4 8 [4 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
D5AAD5FF
2A008055
91555555
55551855
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0moooo1@0003koool30000?oooo`800011oooo0`0000Koool000koool0
0`000?ooo`000010oooo00<0003oooooool0?_ooo`030000oooooooo047oool00`000?ooooooo`0o
oooo00<0003oooooool01Oooo`003_ooo`030000oooo0000043oool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03koool400001_ooo`003_ooo`030000oooo0000043oool0
0`000?ooooooo`0ooooo00<0003oooooool0@?ooo`030000oooooooo03goool00`000?ooo`000007
oooo000>oooo00<0003oool00000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo00<0
003oool00000@?ooo`800007oooo000?oooo00<0003oooooool0?_ooo`800011oooo00<0003ooooo
ool0?oooo`030000oooooooo043oool00`000?ooooooo`05oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool02_ooo`030000
oooooooo00[oool00`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00_oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0:
oooo00<0003oooooool02oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool00_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0ooooo00<0003oooooool0?ooo
o`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0003oooooool00_ooo`400001oooo0Ooo
o`001?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000
oooo000000Coool30000ooooo`ooool300000_ooo`000oooo`030000oooo000000Coool00`000?oo
ooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`000oooo`030000oooo000000Coool0
0`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2
eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2
eMGEAoooo`400001oooo0Oooo`002_ooo`800004oooo@]GEeD:ZZZY2eMGEA_ooo`800002oooo000:
oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GE
eDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GE
eDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool200001?oo
od;EeME2ZZZZ@]GEeDKoool200000_ooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GE
eD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GE
eD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`800004oooo@]GEeD:ZZZY2eMGEA_ooo`800002
oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2
ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2
ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1
oooo000:oooo0P0000Cooom2eMGE@ZZZZT;EeME6oooo0P0000;oool000[oool00`000?ooooooo`03
oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZ
ZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom2eMGE@ZZZZT;EeME7oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2eMGE@ZZZ
ZT;EeME7oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@]GEeD:ZZZY2eMGEAoooo`400001oooo0Ooo
o`000_ooo`D00003oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Oooo`7oool0
00Coool00`000?ooooooo`03oooo00<0003oooooool00ooood;EeME2ZZZZ@]GEeDOoool100000Ooo
o`7oool000Coool00`000?ooooooo`03oooo0`0000?ooom2eMGE@ZZZZT;EeME5oooo0`0000;oool0
00Coool00`000?ooooooo`03oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00
007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo00?ooom2:RXZ@P0004:0P812
EEEE1Oooo`400001oooo0Oooo`000oooo`800005oooo00<0003oooooool00ooood8Z:RY20000@X20
P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY2
0000@X20P49EEED5oooo0@00007oool1oooo000:oooo0P0000Cooom2:RXZ@P0004:0P812EEEE1?oo
o`800002oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY2
0000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20
P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo0P00
00Cooom2:RXZ@P0004:0P812EEEE1?ooo`800002oooo000:oooo00<0003oooooool00ooood8Z:RY2
0000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20
P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY2
0000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20
P49EEED5oooo0@00007oool1oooo000:oooo0P0000Cooom2:RXZ@P0004:0P812EEEE1?ooo`800002
oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY2
0000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20
P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo0P00
00Cooom2:RXZ@P0004:0P812EEEE1?ooo`800002oooo000:oooo00<0003oooooool00ooood8Z:RY2
0000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20
P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03
oooo@RXZ:T800012P820@UEEE@Goool100000Oooo`7oool000?oool00`000?ooooooo`04oooo00<0
003oooooool00ooood8Z:RY20000@X20P49EEED5oooo0@00007oool1oooo0004oooo00<0003ooooo
ool00oooo`<00003oooo@RXZ:T800012P820@UEEE@?oool300000_ooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000Coool00`000?oo
ooooo`03oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6A
TLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`800004oooo@Y6A
TLIEEED4oooo0P0000;oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6A
TLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5
oooo0@00007oool1oooo000:oooo0P0000Cooom2TI6AaUEEE@Coool200000_ooo`002_ooo`030000
oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6A
TLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Ooo
o`002_ooo`800004oooo@Y6ATLIEEED4oooo0P0000;oool000[oool00`000?ooooooo`03oooo@Y6A
TLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool200001?oo
od:ATI76EEEE1?ooo`800002oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2TI6AaUEEE@Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2TI6AaUEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@Y6ATLIEEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Ooo
o`000oooo`800005oooo00<0003oooooool00ooood:ATI76EEEE1Oooo`400001oooo0Oooo`001Ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo@Y6ATLIEEED5oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`<00003oooo@Y6ATLIEEED3oooo0`0000;oool000Goool00`000?oo
ooooo`02oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000?oool0
0`000?ooo`000004oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool0
00Coool00`000?ooooooo`03oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EE
ED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool200001?ooohAEEEE261PH@UEE
E@Coool200000_ooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohAEEEE2
61PH@UEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohAEEEE2
61PH@UEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1
oooo000:oooo0P0000Cooon4EEEE@QPH649EEED4oooo0P0000;oool000[oool00`000?ooooooo`03
ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH
649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03
ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH
649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool200001?ooohAEEEE2
61PH@UEEE@Coool200000_ooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2
EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2
EEEE1Oooo`400001oooo0Oooo`002_ooo`800004ooooQ5EEED8H61Q2EEEE1?ooo`800002oooo000:
oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4
EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEE
E@Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooon4EEEE@QPH649EEED5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooohAEEEE261PH@UEEE@Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03ooooQ5EEED8H61Q2EEEE1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4
EEEE@QPH649EEED5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohAEEEE261PH@UEE
E@Goool100000Oooo`7oool000Coool300000oooo`030000oooooooo00?ooon4EEEE@QPH649EEED5
oooo0@00007oool1oooo0005oooo00<0003oooooool00_ooo`030000oooooooo00?ooon4EEEE@QPH
649EEED5oooo0@00007oool1oooo0003oooo100000?oool300000oooohAEEEE261PH@UEEE@?oool3
00000_ooo`000oooo`030000oooo000000Coool00`000?ooooooo`3ooooo4Oooo`400001oooo0Ooo
o`001?ooo`800004oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000Goool00`000?oo
ooooo`02oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00_oool00`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000
oooooooo00[oool00`000?ooooooo`0:oooo00<0003oooooool02oooo`030000oooooooo00[oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0;
oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00_oool00`000?ooooooo`02oooo0@00007oool1oooo000:ooooo`00
01D00002oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.244708, -0.268382, 0.0151512, 
  0.0151512}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Inverse\ Wavelet\ Transform\)], "Input"],

Cell[BoxData[
    \(\(c = Transpose[waveletMatrix[4, daub2]] . b; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[c, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.240385 0.0192308 0.240385 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(2)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(3)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(4)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(2)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(3)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(4)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
4 string
4 4 8 [4 0 0 4 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF
0000FFFF
FFFF00FF
FFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0moooo1@0003koool30000?oooo`800011oooo0`0000Koool000koool0
0`000?ooo`000010oooo00<0003oooooool0?_ooo`030000oooooooo047oool00`000?ooooooo`0o
oooo00<0003oooooool01Oooo`003_ooo`030000oooo0000043oool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03koool400001_ooo`003_ooo`030000oooo0000043oool0
0`000?ooooooo`0ooooo00<0003oooooool0@?ooo`030000oooooooo03goool00`000?ooo`000007
oooo000>oooo00<0003oool00000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo00<0
003oool00000@?ooo`800007oooo000?oooo00<0003oooooool0?_ooo`800011oooo00<0003ooooo
ool0?oooo`030000oooooooo043oool00`000?ooooooo`05oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool02_ooo`030000
oooooooo00[oool00`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00_oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0:
oooo00<0003oooooool02oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02_ooo`030000oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool00_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0ooooo00<0003oooooool0?ooo
o`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0003oooooool00_ooo`400001oooo0Ooo
o`001?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000
oooo000000Coool30000ooooo`ooool300000_ooo`000oooo`030000oooo000000Coool00`000?oo
ooooo`15oooo@P0008Woool100000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003ooooo
ool0AOoood800029oooo0@00007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`800016oooo@P00
08Soool200000_ooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`800016oooo@P0008Soool200000_ooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`800016oooo@P0008Soool200000_ooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`800016oooo@P0008Soool200000_ooo`002_ooo`030000oooooooo04Gooom2
0000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001
oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000
oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROoo
o`400001oooo0Oooo`002_ooo`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`002_oo
o`030000oooooooo04Gooom20000ROooo`400001oooo0Oooo`000_ooo`D00003oooo00<0003ooooo
ool0AOoood800029oooo0@00007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo
04Gooom20000ROooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool30000AOoood800027
oooo0`0000;oool000Coool00`000?ooooooo`03oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo00?ooon40000ROooo`400001
oooo0Oooo`000oooo`800005oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo0P0000Cooon40000R?ooo`800002oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo0P00
00Cooon40000R?ooo`800002oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo0P0000Cooon4
0000R?ooo`800002oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo0P0000Cooon40000R?oo
o`800002oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
oh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooooh@00029oooo0@00007oool1oooo000:oooo00<0003oooooool00ooooh@00029oooo0@00
007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03ooooQ00008Woool100000Oooo`7oool0
00?oool00`000?ooooooo`04oooo00<0003oooooool00ooooh@00029oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`<00003ooooQ00008Ooool300000_ooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`27oooo@P0004Ooool100000Oooo`7oool000?oool00`000?ooo`000004
oooo00<0003oooooool0Qooood800017oooo0@00007oool1oooo0004oooo00<0003oooooool00ooo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`800028oooo@P0004Koool200000_ooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`800028oooo@P0004Koool200000_oo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`800028oooo@P0004Koool200000_ooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`800028oooo@P0004Koool200000_ooo`002_ooo`030000
oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aooo
o`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom2
0000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo
08Oooom20000Aoooo`400001oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001
oooo0Oooo`002_ooo`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`000oooo`800005
oooo00<0003oooooool0Qooood800017oooo0@00007oool1oooo0005oooo00<0003oooooool00_oo
o`030000oooooooo08Oooom20000Aoooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool3
0000Qooood800015oooo0`0000;oool000Goool00`000?ooooooo`02oooo00<0003oooooool0oooo
oa7oool100000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000Coool00`000?ooooooo`03oooo00<0003oooooool0oooooa7oool100000Ooo
o`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool0
00[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolA
oooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00
007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool20000oooo
oa7oool200000_ooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0
003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003ooooo
ool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooo
oa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo0?oooolAoooo0@00007oool1oooo000:oooo0P000?oooolAoooo0P0000;oool000[oool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00
007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1
oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3o
oooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:
oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0
003oooooool0oooooa7oool100000Oooo`7oool000[oool20000oooooa7oool200000_ooo`002_oo
o`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Ooo
o`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool0
00[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolA
oooo0@00007oool1oooo000:oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`80003ooooo4Oooo`800002oooo000:
oooo00<0003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0
003oooooool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003ooooo
ool0oooooa7oool100000Oooo`7oool000[oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo000:oooo00<0003oooooool0oooo
oa7oool100000Oooo`7oool000Coool300000oooo`030000oooooooo0?oooolAoooo0@00007oool1
oooo0005oooo00<0003oooooool00_ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003
oooo100000?oool30000ooooo`ooool300000_ooo`000oooo`030000oooo000000Coool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`001?ooo`800004oooo00<0003oooooool0oooooa7oool1
00000Oooo`7oool000Goool00`000?ooooooo`02oooo00<0003oooooool0oooooa7oool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo00<0003oooooool02_ooo`030000oooooooo00[oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00_oool00`000?ooooooo`0:
oooo00<0003oooooool02_ooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003ooooo
ool02oooo`030000oooooooo00[oool00`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000
oooooooo00[oool00`000?ooooooo`0;oooo00<0003oooooool02_ooo`030000oooooooo00[oool0
0`000?ooooooo`0:oooo00<0003oooooool02_ooo`030000oooooooo00_oool00`000?ooooooo`02
oooo0@00007oool1oooo000:ooooo`0001D00002oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.244708, -0.268382, 0.0151512, 
  0.0151512}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{748, 248},
WindowMargins->{{Automatic, -1}, {5, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 204, 4, 90, "Input"],
Cell[1916, 55, 190, 4, 30, "Input"],
Cell[2109, 61, 319, 10, 30, "Text",
  Evaluatable->False],
Cell[2431, 73, 3992, 81, 1104, "Input"],

Cell[CellGroupData[{
Cell[6448, 158, 50, 1, 30, "Input"],
Cell[6501, 161, 244, 6, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6782, 172, 50, 1, 30, "Input"],
Cell[6835, 175, 383, 8, 40, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7255, 188, 50, 1, 30, "Input"],
Cell[7308, 191, 1861, 47, 66, "Output"]
}, Open  ]],
Cell[9184, 241, 310, 10, 30, "Text",
  Evaluatable->False],
Cell[9497, 253, 3291, 68, 922, "Input"],

Cell[CellGroupData[{
Cell[12813, 325, 50, 1, 30, "Input"],
Cell[12866, 328, 520, 10, 40, "Output"]
}, Open  ]],
Cell[13401, 341, 65, 1, 30, "Input"],
Cell[13469, 344, 413, 13, 152, "Input"],
Cell[13885, 359, 209, 6, 54, "Input"],
Cell[14097, 367, 360, 10, 110, "Input"],
Cell[14460, 379, 262, 8, 82, "Input"],
Cell[14725, 389, 60, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[14810, 394, 56, 1, 30, "Input"],
Cell[14869, 397, 403, 6, 48, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15309, 408, 48, 1, 30, "Input"],
Cell[15360, 411, 569, 12, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15966, 428, 68, 1, 30, "Input"],
Cell[16037, 431, 653, 12, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16727, 448, 48, 1, 30, "Input"],
Cell[16778, 451, 653, 12, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17468, 468, 68, 1, 30, "Input"],
Cell[17539, 471, 1334, 22, 118, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18910, 498, 68, 1, 30, "Input"],
Cell[18981, 501, 1334, 22, 118, "Output"]
}, Open  ]],
Cell[20330, 526, 67, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[20422, 531, 68, 1, 30, "Input"],
Cell[20493, 534, 569, 12, 86, "Output"]
}, Open  ]],
Cell[21077, 549, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[21128, 553, 79, 1, 30, "Input"],
Cell[21210, 556, 569, 12, 86, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21816, 573, 117, 3, 30, "Input"],
Cell[21936, 578, 513, 12, 98, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22486, 595, 112, 2, 30, "Input"],
Cell[22601, 599, 1261, 22, 136, "Output"]
}, Open  ]],
Cell[23877, 624, 70, 1, 30, "Input"],
Cell[23950, 627, 102, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[24077, 633, 66, 1, 30, "Input"],
Cell[24146, 636, 21589, 581, 296, 4213, 362, "GraphicsData", 
"PostScript", "Graphics"],
Cell[45738, 1219, 137, 3, 29, "Output"]
}, Open  ]],
Cell[45890, 1225, 70, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[45985, 1230, 66, 1, 30, "Input"],
Cell[46054, 1233, 24797, 621, 296, 4213, 362, "GraphicsData", 
"PostScript", "Graphics"],
Cell[70854, 1856, 137, 3, 29, "Output"]
}, Open  ]],
Cell[71006, 1862, 79, 1, 30, "Input"],
Cell[71088, 1865, 81, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[71194, 1870, 66, 1, 30, "Input"],
Cell[71263, 1873, 21589, 581, 296, 4213, 362, "GraphicsData", 
"PostScript", "Graphics"],
Cell[92855, 2456, 137, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

