(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    627730,      15475]*)
(*NotebookOutlinePosition[    628380,      15498]*)
(*  CellTagsIndexPosition[    628336,      15494]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Utilities`MemoryConserve`\n$MemoryIncrement; 
    \n<< \ LinearAlgebra`MatrixManipulation`; \n
    Off[General::spell1, MemoryConserve::start, MemoryConserve::end]; \)], 
  "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
coif6={{-.051429728471, .238929728471, .602859456942, 
 \t\t .272140543058,-.051429972847,-.011070271529},
 \t   {-.011070271529, .051429972847, .272140543058,
\t\t-.602859456942, .238929728471, .051429728471}}*
\t\tSqrt[2.];
coif12={{ .011587596739,-.029320137980,-.047639590310, 
 \t\t  .273021046535, .574682393857, .294867193696,
\t\t -.054085607092,-.042026480461, .016744410163, 
 \t\t  .003967883613,-.001289203356,-.000509505399},
 \t\t{-.000509505399, .001289203356, .003967883613,
 \t\t -.016744410163,-.042026480461, .054085607092,
 \t\t  .294867193696,-.574682393857, .273021046535,
\t\t  .047639590310,-.029320137980,-.011587596739}}*
\t\t Sqrt[2.];
coif18={{-.002682418671, .005503126709, .016583560479, 
\t\t -.046507764479,-.043220763560, .286503335274,
 \t\t  .561285256870, .302983571773,-.050770140755, 
\t\t -.058196250762, .024434094321, .011229240962, 
\t\t -.006369601011,-.001820458916, .000790205101,
 \t\t  .000329665174,-.000050192775,-.000024465734},
 \t\t{-.000024465734, .000050192775, .000329665174,
 \t\t -.000790205101,-.001820458916, .006369601011,
 \t\t  .011229240962,-.024434094321,-.058196250762,
 \t\t  .050770140755, .302983571773,-.561285256870,
 \t\t  .286503335274, .043220763560,-.046507764479,
 \t\t -.016583560479, .005503126709, .002682418671}}*
 \t\tSqrt[2.];
coif24={{ .000630961046,-.001152224852,-.005194524026, 
 \t\t  .011362459244, .018867235378,-.057464234429, 
\t\t -.039652648517, .293667390895, .553126452562, 
 \t\t  .307157326198,-.047112738865,-.068038127051,
 \t\t  .027813640153, .017735837438,-.010756318517,
\t\t -.004001012886, .002652665946, .000895594529,
\t\t -.000416500571,-.000183829769, .000044080354, 
 \t\t  .000022082857,-.000002304942,-.000001262175},
 \t\t{-.000001262175, .000002304942, .000022082857,
 \t\t -.000044080354,-.000183829769, .000416500571,
 \t\t  .000895594529,-.002652665946,-.004001012886,
 \t\t  .010756318517, .017735837438,-.027813640153,
 \t\t -.068038127051, .047112738865, .307157326198,
 \t\t -.553126452562, .293667390895, .039652648517,
 \t\t -.057464234429,-.018867235378, .011362459244,
 \t\t  .005194524026,-.001152224852,-.000630961046}}*
 \t\tSqrt[2.];
coif30={{-.000149963800, .000253561200, .001540245700, 
\t\t -.002941110800,-.007163781900, .016552066400, 
 \t\t  .019917804300,-.064997262800,-.036800073600,
 \t\t  .298092323500, .547505429400, .309706849000, 
\t\t -.043866050800,-.074652238900, .029195879500, 
 \t\t  .023110777000,-.013973687900,-.006480090000, 
 \t\t  .004783001400, .001720654700,-.001175822200,
\t\t -.000451227000, .000213729800, .000099377600,
\t\t -.000029232100,-.000015072000, .000002640800, 
 \t\t  .000001459300,-.000000118400,-.000000067300},
 \t\t{-.000000067300, .000000118400, .000001459300,
 \t\t -.000002640800,-.000015072000, .000029232100,
 \t\t  .000099377600,-.000213729800,-.000451227000,
 \t\t  .001175822200, .001720654700,-.004783001400,
 \t\t -.006480090000, .013973687900, .023110777000,
 \t\t -.029195879500,-.074652238900, .043866050800,
 \t\t  .309706849000,-.547505429400, .298092323500,
 \t\t  .036800073600,-.064997262800,-.019917804300,
 \t\t  .016552066400, .007163781900,-.002941110800,
 \t\t -.001540245700, .000253561200, .000149963800}}*
 \t\tSqrt[2.]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    \(\[FilledSquare]\ \ Sample\)], "Input"],

Cell[BoxData[
    \(\(a = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 
          0, 0, 0, 1}, {1, 1, 1, 1, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 0, 0, 1}, {
          0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 1, 0, 0
          \ , 0, 1}}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[a, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0noooo0`00043oool30000?_ooo`800011oooo00<0003oooooool01_oo
o`003_ooo`030000oooo000003ooool00`000?ooooooo`11oooo00<0003oooooool0?Oooo`030000
oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool00000@?ooo`030000oooooooo
03koool40000?_ooo`030000oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool0
0000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo0P00047oool00`000?ooooooo`06
oooo000>oooo00<0003oool00000?oooo`030000oooo0000043oool20000?oooo`030000oooooooo
03ooool00`000?ooo`000007oooo000?oooo00<0003oooooool0?oooo`030000oooooooo043oool0
0`000?ooooooo`0noooo0P00043oool00`000?ooooooo`06oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`02oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooo`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03ooool00`000?ooooooo`02oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<0003ooooo3oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0004oooo00<0003oooooool00ooo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool200009Oooob400012ooooH`00
02Goool200000_ooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`80000Uoooo8@00
04;ooomS00009Oooo`800002oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool200001?oood800024
oooo8@0002Goool200000_ooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001
oooo0Oooo`000oooo`030000oooooooo00Coool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`001?ooo`030000oooooooo00?oool300000ooood800024oooo8@0002Coool3
00000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`15oooo8@00027ooomS
00009_ooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo0P0004KooolQ00008Oooof<0000Uoooo0P0000;oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool20000A_ooob40000QooooH`0002Goool200000_oo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo0P0008SooolQ00008Ooood800004oooo0P0000;oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`001?ooo`<00003
oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000Goool00`000?oo
ooooo`02oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000?oool4
00000oooo`<00027oooo8@00027ooom200000oooo`<00002oooo0003oooo00<0003oool000001?oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0004oooo0P0000Coool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`001Oooo`030000oooooooo
00;oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo0P0002GooolQ0000@_oo
of<0000Uoooo0P0000;oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ
0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ
0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool200009Ooo
ob400012ooooH`0002Goool200000_ooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
08CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
08CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo0P0000Cooom2
0000Q?ooob40000Uoooo0P0000;oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`000oooo`800005oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003oooooool00ooood800024oooo8@00
02Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo0`0000?ooom20000Q?ooob40000T
oooo0`0000;oool000?oool200001Oooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@00
02Koool100000Oooo`7oool000?oool00`000?ooooooo`04oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`001?ooo`800004oooo00<0003oooooool0AOoo
ob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ
00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Ooo
ob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ
00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00
027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Q
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Ooo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool1
00000Oooo`7oool000[oool20000A_ooob40000Qoooo8@00027ooolQ00009Oooo`800002oooo000:
oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15
oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOoo
ob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ
00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Ooo
ob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ
00008Oooob40000Voooo0@00007oool1oooo000:oooo0P0004KooolQ00008Oooob40000Qoooo8@00
02Goool200000_ooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`800028ooooH`0002Goool200000_ooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`001?ooo`030000oooooooo00?oool00`000?ooooooo`27ooooH`0002Koool100000Oooo`7oool0
00?oool00`000?ooo`000004oooo00<0003oooooool0Qoooof<0000Voooo0@00007oool1oooo0003
oooo00<0003oool000001?ooo`<00027ooooH`0002Coool300000_ooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0=
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool00_ooo`400001oooo0Oooo`002_ooool0000E00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, 
  0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ Fourier\ Transform\)], "Input"],

Cell[BoxData[
    \(\(fa = Fourier[a]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Abs[fa], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF84817D9F7D8184
11071A1E11071A1E
1152357158255886
111E312A111E312A
356F403A113A406F
112A311E112A311E
1186582558713552
111E1A07111E1A07
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0noooo0`00043oool30000?_ooo`800011oooo00<0003oooooool01_oo
o`003_ooo`030000oooo000003ooool00`000?ooooooo`11oooo00<0003oooooool0?Oooo`030000
oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool00000@?ooo`030000oooooooo
03koool40000?_ooo`030000oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool0
0000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo0P00047oool00`000?ooooooo`06
oooo000>oooo00<0003oool00000?oooo`030000oooo0000043oool20000?oooo`030000oooooooo
03ooool00`000?ooo`000007oooo000?oooo00<0003oooooool0?oooo`030000oooooooo043oool0
0`000?ooooooo`0noooo0P00043oool00`000?ooooooo`06oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`02oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooo`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03ooool00`000?ooooooo`02oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<0003ooooo3oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
02CooolQQ8B48H61PB5mOGdQWinO8GemOB61PH4QQ8B41Oooo`400001oooo0Oooo`000oooo`030000
oooo000000Coool00`000?ooooooo`0Toooo8HB4Q261PH4QOGem8InOWb5mOGdQPH618HB4Q0Goool1
00000Oooo`7oool000Coool00`000?ooooooo`03oooo00<0003oooooool09?ooob64Q8@QPH618Gem
OB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@Q
PH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0
003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61
PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQ
OGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618Gem
OB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@Q
PH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo0P00
02GooolQQ8B48H61PB5mOGdQWinO8GemOB61PH4QQ8B41?ooo`800002oooo000:oooo00<0003ooooo
ool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0
003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61
PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQ
OGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618Gem
OB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@Q
PH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:oooo00<0
003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5oooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob64Q8@QPH618GemOB6OWilQOGem8H61PB64Q8@5
oooo0@00007oool1oooo000:oooo0P0002GooolQQ8B48H61PB5mOGdQWinO8GemOB61PH4QQ8B41?oo
o`800002oooo000:oooo00<0003oooooool00oooob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ
7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A
4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B471`LQ
6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ7QhN1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ
7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A
4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B471`LQ
6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ7QhN1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ
7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A
4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B471`LQ
6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ7QhN1Oooo`400001oooo0Oooo`002_ooo`800004
oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh4oooo0P0000;oool000[oool00`000?oo
ooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ7QhN1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN
7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q
1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q1`L78AXJ
6R4N7QhQ4A4A8@L71b4J6QXQ7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
4A4A8@L71b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4A4A4Q1`L78AXJ6R4N7QhQ4A4A8@L71b4J6QXQ7QhN1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN
7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q
1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q1`L78AXJ
6R4N7QhQ4A4A8@L71b4J6QXQ7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
4A4A8@L71b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5oooo0@00007oool1oooo0003
oooo0`0000Coool00`000?ooooooo`03oooo8A4A4B471`LQ6QXJ8AhN7R4A4A4Q1`L78AXJ6R4N7Qh5
oooo0@00007oool1oooo0003oooo00<0003oooooool01?ooo`030000oooooooo00?ooolQ4A4A8@L7
1b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN7PGoool100000Oooo`7oool000Coool00`000?ooooooo`03
oooo0`0000?ooolQ4A4A8@L71b4J6QXQ7QhN8A4A4B471`LQ6QXJ8AhN7P?oool300000_ooo`001?oo
o`030000oooooooo00?oool00`000?ooooooo`03oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQH
F266QXH5oooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`030000oooooooo00?ooolQ
4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool100000Oooo`7oool000Coool00`000?oo
ooooo`03oooo00<0003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4QF5QH8BDU9B5HF5PQQXJ61Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQ
F5QH8HJ6QPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B5BDU8Q=CDe8G5a
LB5HF5PQ9BDU8EQHF266QXH5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q
DU9B8CDe=B5aLG4QF5QH8BDU9B5HF5PQQXJ61Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQHF266QXH5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4QF5QH8BDU9B5HF5PQQXJ61Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQ
F5QH8HJ6QPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B5BDU8Q=CDe8G5a
LB5HF5PQ9BDU8EQHF266QXH5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q
DU9B8CDe=B5aLG4QF5QH8BDU9B5HF5PQQXJ61Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQHF266QXH5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4QF5QH8BDU9B5HF5PQQXJ61Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQ
F5QH8HJ6QPGoool100000Oooo`7oool000[oool200001?ooob4A4A4QDU9B8CDe=B5aLG4QF5QH8BDU
9B5HF5PQQXJ61?ooo`800002oooo000:oooo00<0003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4Q
F5QH8BDU9B5HF5PQQXJ61Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8E9B
DR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQHF266QXH5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4QF5QH8BDU9B5HF5PQQXJ61Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQH
F266QXH5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4Q
F5QH8BDU9B5HF5PQQXJ61Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8E9B
DR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQHF266QXH5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4QF5QH8BDU9B5HF5PQQXJ61Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQH
F266QXH5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4QDU9B8CDe=B5aLG4Q
F5QH8BDU9B5HF5PQQXJ61Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8E9B
DR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8A4A4B5BDU8Q=CDe8G5aLB5HF5PQ9BDU8EQHF266QXH5oooo0@00007oool1oooo000:oooo0P00
00CooolQ4A4A8E9BDR4e=CDQLG5a8EQHF24U9BDQF5QH8HJ6QPCoool200000_ooo`002_ooo`030000
oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q7QhN8C4a<B4Z:RX5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q
:RXZ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A
4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ
<C4a8BXZ:R4A4A4Q7QhN8C4a<B4Z:RX5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q7QhN8C4a<B4Z:RX5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q
:RXZ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A
4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ
<C4a8BXZ:R4A4A4Q7QhN8C4a<B4Z:RX5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q7QhN8C4a<B4Z:RX5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q
:RXZ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A
4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool000[oool200001?ooob4A4A4Q7QhN8C4a<B4Z:RXQ
4A4A8AhN7R4a<C4Q:RXZ1?ooo`800002oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a
<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
4A4A8AhN7R4a<C4Q:RXZ8A4A4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q7QhN8C4a<B4Z:RX5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A4B4N7QhQ<C4a8BXZ
:PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q
7QhN8C4a<B4Z:RX5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a
<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
4A4A8AhN7R4a<C4Q:RXZ8A4A4B4N7QhQ<C4a8BXZ:PGoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q7QhN8C4a<B4Z:RX5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4a<C4Q:RXZ8A4A4B4N7QhQ<C4a8BXZ
:PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q
7QhN8C4a<B4Z:RX5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8C4a
<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001oooo0Oooo`001?ooo`<00003oooo00<0003ooooo
ool00oooob4A4A4Q7QhN8C4a<B4Z:RXQ4A4A8AhN7R4a<C4Q:RXZ1Oooo`400001oooo0Oooo`001Ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo8A4A4B4N7QhQ<C4a8BXZ:R4A4A4Q7QhN8C4a
<B4Z:RX5oooo0@00007oool1oooo0003oooo100000?oool300000oooob4A4A4Q7QhN8C4a<B4Z:RXQ
4A4A8AhN7R4a<C4Q:RXZ0oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
00?ooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Oooo`7oool000Coool2
00001?ooo`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool1
00000Oooo`7oool000Goool00`000?ooooooo`02oooo00<0003oooooool00oooob4e=CDQKfm_8D10
@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8CDe=B5_KflQ@4108CXj>R4A4A4Q>SXj8D10@25_Kfl5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_
K`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8CDe=B5_KflQ@4108CXj>R4A4A4Q
>SXj8D10@25_Kfl5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4e=CDQKfm_8D10
@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8CDe=B5_KflQ@4108CXj>R4A4A4Q>SXj8D10@25_Kfl5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_
K`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8CDe=B5_KflQ@4108CXj>R4A4A4Q
>SXj8D10@25_Kfl5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4e=CDQKfm_8D10
@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Oooo`7oool000[oool200001?oo
ob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj>R50@40QKfm_1?ooo`800002oooo000:oooo00<0003ooooo
ool00oooob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8CDe=B5_KflQ@4108CXj>R4A4A4Q>SXj8D10@25_Kfl5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj
>R50@40QKfm_1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q
>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8CDe
=B5_KflQ@4108CXj>R4A4A4Q>SXj8D10@25_Kfl5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8CDe=B5_KflQ@4108CXj>R4A4A4Q>SXj8D10@25_Kfl5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj
>R50@40QKfm_1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q
>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8CDe
=B5_KflQ@4108CXj>R4A4A4Q>SXj8D10@25_Kfl5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob4e=CDQKfm_8D10@24j>SXQ4A4A8CXj>R50@40QKfm_1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_K`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8CDe=B5_KflQ@4108CXj>R4A4A4Q>SXj8D10@25_Kfl5
oooo0@00007oool1oooo000:oooo0P0000CooolQ=CDe8Fm_Kb50@40Q>SXj8A4A4B4j>SXQ@4108Fm_
K`Coool200000_ooo`002_ooo`030000oooooooo00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ
<C4a8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4Z:RXQ<C4a8AhN
7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q
:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ<C4a8AhN7PGoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8A4A4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ
<C4a8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4Z:RXQ<C4a8AhN
7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q
:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ<C4a8AhN7PGoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8A4A4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ
<C4a8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4Z:RXQ<C4a8AhN
7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q
:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ<C4a8AhN7PGoool100000Oooo`7oool000[oool2
00001?ooob4A4A4Q:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1?ooo`800002oooo000:oooo00<0
003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ<C4a8AhN7PGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a
<B4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ
4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8BXZ
:R4a<C4Q7QhN8A4A4B4Z:RXQ<C4a8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8A4A4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQ4A4A8BXZ:R4a<C4Q7QhN8A4A4B4Z:RXQ<C4a8AhN7PGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a
<B4N7Qh5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ
4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8BXZ
:R4a<C4Q7QhN8A4A4B4Z:RXQ<C4a8AhN7PGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8A4A4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q7QhN1Oooo`400001oooo0Ooo
o`000oooo`800005oooo00<0003oooooool00oooob4A4A4Q:RXZ8C4a<B4N7QhQ4A4A8BXZ:R4a<C4Q
7QhN1Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`03oooo8A4A
4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a<B4N7Qh5oooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<00003oooo8A4A4B4Z:RXQ<C4a8AhN7R4A4A4Q:RXZ8C4a<B4N7Qh3oooo0`0000;oool0
00?oool200001Oooo`030000oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9B
DPGoool100000Oooo`7oool000?oool00`000?ooooooo`04oooo00<0003oooooool00oooob4A4A4Q
QXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Oooo`001?ooo`800004oooo00<0
003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B66QXHQF5QH8BDU9B5HF5PQLG5a8CDe
=B5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQ
F5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6
QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8A4A4B66QXHQF5QH8BDU9B5HF5PQLG5a8CDe=B5BDU85oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B66QXHQF5QH8BDU9B5HF5PQLG5a8CDe
=B5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQ
F5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6
QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8A4A4B66QXHQF5QH8BDU9B5HF5PQLG5a8CDe=B5BDU85oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPGoool1
00000Oooo`7oool000[oool200001?ooob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQDU9B1?oo
o`800002oooo000:oooo00<0003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQ
DU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQH
F25aLG4Q=CDe8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B66QXHQ
F5QH8BDU9B5HF5PQLG5a8CDe=B5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8A4A4B66QXHQF5QH8BDU9B5HF5PQLG5a8CDe=B5BDU85oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQ
DU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQH
F25aLG4Q=CDe8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B66QXHQ
F5QH8BDU9B5HF5PQLG5a8CDe=B5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8A4A4B66QXHQF5QH8BDU9B5HF5PQLG5a8CDe=B5BDU85oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob4A4A4QQXJ68EQHF24U9BDQF5QH8G5aLB4e=CDQ
DU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8HJ6QR5HF5PQ9BDU8EQH
F25aLG4Q=CDe8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B66QXHQ
F5QH8BDU9B5HF5PQLG5a8CDe=B5BDU85oooo0@00007oool1oooo000:oooo0P0000CooolQ4A4A8HJ6
QR5HF5PQ9BDU8EQHF25aLG4Q=CDe8E9BDPCoool200000_ooo`002_ooo`030000oooooooo00?ooolQ
4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L71`Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN7R4J6QXQ1`L71Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L7
1`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q
7QhN8AXJ6R471`L5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ
6R471`LQ4A4A8AhN7R4J6QXQ1`L71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L71`Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN7R4J6QXQ1`L71Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L7
1`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q
7QhN8AXJ6R471`L5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ
6R471`LQ4A4A8AhN7R4J6QXQ1`L71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L71`Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN7R4J6QXQ1`L71Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L7
1`Goool100000Oooo`7oool000[oool200001?ooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN7R4J6QXQ
1`L71?ooo`800002oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN
7R4J6QXQ1`L71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ
1`L78A4A4B4N7QhQ6QXJ8@L71`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A
4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN7R4J6QXQ1`L71Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L71`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN
7R4J6QXQ1`L71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ
1`L78A4A4B4N7QhQ6QXJ8@L71`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8A4A
4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN7R4J6QXQ1`L71Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L71`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob4A4A4Q7QhN8AXJ6R471`LQ4A4A8AhN
7R4J6QXQ1`L71Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo8A4A4B4N7QhQ6QXJ8@L71b4A4A4Q7QhN8AXJ6R471`L5oooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo00?ooolQ4A4A8AhN7R4J6QXQ1`L78A4A4B4N7QhQ6QXJ8@L7
1`Goool100000Oooo`7oool000?oool00`000?ooo`000004oooo0`0000?ooolQ4A4A8AhN7R4J6QXQ
1`L78A4A4B4N7QhQ6QXJ8@L71`?oool300000_ooo`001?ooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`3o
oooo4Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo4Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0=oooo00<0003ooooo
ool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000
oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool0
0`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`0=
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool00_ooo`400001oooo0Oooo`002_ooool0000E00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, 
  0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[InverseFourier[fa], Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
83007C830000007C
00008383897C0083
838300830000007C
83838383007C0000
83007C830000007C
00008383897C0083
838300830089007C
838383830000007C
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0noooo0`00043oool30000?_ooo`800011oooo00<0003oooooool01_oo
o`003_ooo`030000oooo000003ooool00`000?ooooooo`11oooo00<0003oooooool0?Oooo`030000
oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool00000@?ooo`030000oooooooo
03koool40000?_ooo`030000oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool0
0000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo0P00047oool00`000?ooooooo`06
oooo000>oooo00<0003oool00000?oooo`030000oooo0000043oool20000?oooo`030000oooooooo
03ooool00`000?ooo`000007oooo000?oooo00<0003oooooool0?oooo`030000oooooooo043oool0
0`000?ooooooo`0noooo0P00043oool00`000?ooooooo`06oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`02oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooo`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03ooool00`000?ooooooo`02oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<0003ooooo3oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`030000oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1
oooo0004oooo00<0003oooooool00oooo`030000oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00
025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q00008GalO263Ph=S
00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3
Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQPh>38@00025lO7`Q
Ph>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q00008Gal
O263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3Pb40000Q
O7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQPh>38@00
025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q
00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3
Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Ph>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool200001?oo
ob63Ph<Q00008GalO263Ph=S00008GalO0Coool200000_ooo`002_ooo`030000oooooooo00?ooolQ
Ph>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001
oooo0Oooo`002_ooo`800004oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1?ooo`800002oooo000:
oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3
P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000Q
Ph>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@00
0263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q
00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98Gal
O240000QPh>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQ
O7al8@000263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9
RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000[oool200001?oood800012Ph>38HV9RB5lO7`Q
00008H>3P`Coool200000_ooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@00
0263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q
00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98Gal
O240000QPh>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQ
O7al8@000263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9
RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<Q
RHV98GalO240000QPh>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3
Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012
Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
04:3Ph<QRHV98GalO240000QPh>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
0000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0004:3Ph<QRHV98GalO240000QPh>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1oooo0003oooo0`0000Coool0
0`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Oooo`400001oooo0Oooo`000ooo
o`030000oooooooo00Coool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Ooo
o`400001oooo0Oooo`001?ooo`030000oooooooo00?oool300000ooood800012Ph>38HV9RB5lO7`Q
00008H>3P`?oool300000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo@X>3
Pb40000QPh>3H`00025lO7`5oooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`030000
oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool000Coool00`000?oo
ooooo`03oooo00<0003oooooool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool000[oool200001?oood:3Ph<Q00008H>3
Pf<0000QO7al1?ooo`800002oooo000:oooo00<0003oooooool00ooood:3Ph<Q00008H>3Pf<0000Q
O7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph=S00008Gal
O0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood:3Ph<Q00008H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom2Ph>38@000263Ph=S00008GalO0Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@X>3Pb40000QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo0P00
00Cooom2Ph>38@000263Ph=S00008GalO0Coool200000_ooo`002_ooo`030000oooooooo00?ooon4
Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00
025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4
Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00
025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Ooo
o`002_ooo`800004ooooQ8>3Pb40000QO7al@P0000Coool200000_ooo`002_ooo`030000oooooooo
00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4
Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00
025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4
Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>38@00
025lO7a200001Oooo`400001oooo0Oooo`001?ooo`<00003oooo00<0003oooooool00oooohB3Ph<Q
00008GalO4800005oooo0@00007oool1oooo0005oooo00<0003oooooool00_ooo`030000oooooooo
00?ooon4Ph>38@00025lO7a200001Oooo`400001oooo0Oooo`000oooo`@00003oooo0`0000?ooon4
Ph>38@00025lO7a200000oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo0004oooo0P0000Coool0
0`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`001Ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q00008GalO263Ph=S00008Gal
O0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000Q
O7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00
025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q00008GalO263Ph=S
00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3
Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQPh>38@00025lO7`Q
Ph>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q00008Gal
O263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3Pb40000Q
O7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQPh>38@00
025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q
00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3
Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Ph>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo0P0000CooolQPh>38@00
025lO7`QPh>3H`00025lO7`4oooo0P0000;oool000[oool00`000?ooooooo`03oooo8H>3Pb40000Q
O7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQPh>38@00
025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob63Ph<Q
00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8H>3
Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Ph>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8H>3Pb40000QO7al8H>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQPh>38@00025lO7`QPh>3H`00025lO7`5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob63Ph<Q00008GalO263Ph=S00008GalO0Goool100000Oooo`7oool0
00[oool200001?ooob63Ph<Q00008GalO263Ph=S00008GalO0Coool200000_ooo`002_ooo`030000
oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5oooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3
P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000Q
Ph>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@00
0263Ph<5oooo0@00007oool1oooo000:oooo0P0000Cooom20000@X>3Pb69RHTQO7al8@000263Ph<4
oooo0P0000;oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000QPh>31Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@000263Ph<5
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3
P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98GalO240000Q
Ph>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQO7al8@00
0263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q
00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<QRHV98Gal
O240000QPh>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3Pb69RHTQ
O7al8@000263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012Ph>38HV9
RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0004:3Ph<Q
RHV98GalO240000QPh>31Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000@X>3
Pb69RHTQO7al8@000263Ph<5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800012
Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
04:3Ph<QRHV98GalO240000QPh>31Oooo`400001oooo0Oooo`000oooo`800005oooo00<0003ooooo
ool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Oooo`7oool000?oool00`000?oo
o`000004oooo00<0003oooooool00ooood800012Ph>38HV9RB5lO7`Q00008H>3P`Goool100000Ooo
o`7oool000?oool00`000?ooo`000004oooo0`0000?ooom20000@X>3Pb69RHTQO7al8@000263Ph<3
oooo0`0000;oool000?oool200001Oooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9
RB40000QO7al1Oooo`400001oooo0Oooo`000oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo@X>3Pb40000QPh>38@000269RHTQ00008GalO0Goool100000Oooo`7oool000Coool200001?oo
o`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000Q
O7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9
RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q
00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@00
0263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000Q
O7al1Oooo`400001oooo0Oooo`002_ooo`800004oooo@X>3Pb40000QPh>38@000269RHTQ00008Gal
O0Coool200000_ooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000Q
O7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9
RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q
00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@00
0263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000QO7al1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9RB40000Q
O7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q00008HV9
RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@000263Ph<Q
00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2Ph>38@00
0263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
Ph>38@000263Ph<Q00008HV9RB40000QO7al1Oooo`400001oooo0Oooo`002_ooo`800004oooo@X>3
Pb40000QPh>38@000269RHTQ00008GalO0Coool200000_ooo`002_ooo`030000oooooooo00?ooon4
Ph>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohB3Ph=S00008Gal
O0Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>3H`00025lO7`5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooohB3Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4
Ph>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohB3Ph=S00008Gal
O0Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>3H`00025lO7`5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooohB3Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4
Ph>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohB3Ph=S00008Gal
O0Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>3H`00025lO7`5oooo0@00007oool1oooo000:
oooo0P0000Cooon4Ph>3H`00025lO7`4oooo0P0000;oool000[oool00`000?ooooooo`03ooooQ8>3
Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>3H`00025lO7`5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohB3Ph=S00008GalO0Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooon4Ph>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooohB3Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ8>3
Pf<0000QO7al1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooon4Ph>3H`00025lO7`5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooohB3Ph=S00008GalO0Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooon4Ph>3H`00025lO7`5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooohB3Ph=S00008GalO0Goool100000Oooo`7oool000[oool00`000?ooooooo`03ooooQ8>3
Pf<0000QO7al1Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`03
ooooQ8>3Pf<0000QO7al1Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?oo
ooooo`03ooooQ8>3Pf<0000QO7al1Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool3
00000oooohB3Ph=S00008GalO0?oool300000_ooo`001?ooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`3o
oooo4Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo4Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0=oooo00<0003ooooo
ool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000
oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool0
0`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`0=
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool00_ooo`400001oooo0Oooo`002_ooool0000E00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, 
  0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Wavelet\ Transform\)], "Input"],

Cell[BoxData[
    \(\(wa = waveletMatrix[8, coif6] . a; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[wa, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
CEDD96F07CA55AC7
C76DFFF0839F5ACC
CEDD96F07CD75AF0
C76DFFF083795AF2
4B28315A690F5AB4
B48C385A002B5A52
4B28315A69925A5A
B48C385A00065A52
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0noooo0`00043oool30000?_ooo`800011oooo00<0003oooooool01_oo
o`003_ooo`030000oooo000003ooool00`000?ooooooo`11oooo00<0003oooooool0?Oooo`030000
oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool00000@?ooo`030000oooooooo
03koool40000?_ooo`030000oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool0
0000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo0P00047oool00`000?ooooooo`06
oooo000>oooo00<0003oool00000?oooo`030000oooo0000043oool20000?oooo`030000oooooooo
03ooool00`000?ooo`000007oooo000?oooo00<0003oooooool0?oooo`030000oooooooo043oool0
0`000?ooooooo`0noooo0P00043oool00`000?ooooooo`06oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`02oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooo`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03ooool00`000?ooooooo`02oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<0003ooooo3oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQFUYJ8LO7a`Goool100000Oooo`7oool000?oool0
0`000?ooo`000004oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQ
alO71Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo8Lk>
cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQFUYJ8LO7a`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFU
YB5JFUXQalO71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQ
l?3`8GalO26UYJDQFUYJ8LO7a`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>
cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQFUYJ8LO7a`Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFU
YB5JFUXQalO71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQ
l?3`8GalO26UYJDQFUYJ8LO7a`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>
cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Oooo`400001oooo0Oooo`002_oo
o`800004oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL4oooo0P0000;oool000[oool0
0`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQ
FUYJ8LO7a`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`
l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQ
gMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQFUYJ8LO7a`Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQ
FUYJ8LO7a`Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`
l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQ
gMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQFUYJ8LO7a`Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QYJFU8EYJFR77alL5oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFUYB5JFUXQalO71Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO26UYJDQ
FUYJ8LO7a`Goool100000Oooo`7oool000[oool200001?ooob7>c/hQgMgM8IJFUR7`l?0QO7al8JFU
YB5JFUXQalO71?ooo`800002oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0Q
Ph>38InOWb5JFUXQc<c<1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]
KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38InOWb5JFUXQc<c<1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJ
FR7<c<`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0Q
Ph>38InOWb5JFUXQc<c<1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]
KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38InOWb5JFUXQc<c<1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJ
FR7<c<`5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0Q
Ph>38InOWb5JFUXQc<c<1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]
KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38InOWb5JFUXQc<c<1Oooo`400001oooo0Ooo
o`002_ooo`800004oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJFR7<c<`4oooo0P0000;oool0
00[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38InOWb5JFUXQ
c<c<1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3
Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQ
oooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob77alLQKFe]8Oooob7`l?0QPh>38InOWb5JFUXQc<c<1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38InOWb5JFUXQ
c<c<1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3
Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQ
oooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob77alLQKFe]8Oooob7`l?0QPh>38InOWb5JFUXQc<c<1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QWinO8EYJFR7<c<`5oooo0@00
007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<Q
WinO8EYJFR7<c<`5oooo0@00007oool1oooo0003oooo00<0003oooooool01?ooo`030000oooooooo
00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0Goool100000Oooo`7oool000Coool0
0`000?ooooooo`03oooo0`0000?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb6OWilQFUYJ8Lc<c0?oool3
00000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`
l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`030000
oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQFUYJ8O3`l0Goool100000Oooo`7oool0
00Coool00`000?ooooooo`03oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8MOG
eb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQ
l?3`8GalO27GemLQFUYJ8O3`l0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>
cR7MgMdQUYJF8O3`l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8MOGeb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQFUYJ8O3`l0Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QemOG8EYJFR7`l?05
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8MOG
eb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQ
l?3`8GalO27GemLQFUYJ8O3`l0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>
cR7MgMdQUYJF8O3`l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8MOGeb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQFUYJ8O3`l0Goool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QemOG8EYJFR7`l?05
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8MOG
eb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQ
l?3`8GalO27GemLQFUYJ8O3`l0Goool100000Oooo`7oool000[oool200001?ooob7>c/hQgMgM8IJF
UR7`l?0QO7al8MOGeb5JFUXQl?3`1?ooo`800002oooo000:oooo00<0003oooooool00oooob7>c/hQ
gMgM8IJFUR7`l?0QO7al8MOGeb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQFUYJ8O3`l0Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8MOGeb5JFUXQl?3`1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQ
FUYJ8O3`l0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`
l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQ
gMgM8IJFUR7`l?0QO7al8MOGeb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQFUYJ8O3`l0Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob7>c/hQgMgM8IJFUR7`l?0QO7al8MOGeb5JFUXQl?3`1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQ
FUYJ8O3`l0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`
l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob7>c/hQ
gMgM8IJFUR7`l?0QO7al8MOGeb5JFUXQl?3`1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQFUYJ8O3`l0Goool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8Lk>cR7MgMdQUYJF8O3`l25lO7`QemOG8EYJFR7`l?05oooo0@00007oool1
oooo000:oooo0P0000CooolQc/k>8MgMgB6FUYHQl?3`8GalO27GemLQFUYJ8O3`l0Coool200000_oo
o`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QNGUi8EYJ
FR7bl_85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0Q
Ph>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]
KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8LO7ab5]KFdQoooo8O3`l263Ph<QNGUi8EYJFR7bl_85oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QNGUi8EYJ
FR7bl_85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0Q
Ph>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]
KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo8LO7ab5]KFdQoooo8O3`l263Ph<QNGUi8EYJFR7bl_85oooo0@00007oool1oooo000:oooo00<0
003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QNGUi8EYJ
FR7bl_85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0Q
Ph>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]
KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool100000Oooo`7oool000[oool200001?ooob77alLQ
KFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b1?ooo`800002oooo000:oooo00<0003oooooool00ooo
ob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QNGUi8EYJFR7bl_85oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQ
l_;b1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3
Pb5iNGTQFUYJ8O;blPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQ
oooo8O3`l263Ph<QNGUi8EYJFR7bl_85oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3Pb5iNGTQFUYJ8O;blPGoool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`l263Ph<QNGUi8EYJFR7bl_85oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQ
l_;b1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQalO78Fe]KB7ooolQl?3`8H>3
Pb5iNGTQFUYJ8O;blPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8LO7ab5]KFdQ
oooo8O3`l263Ph<QNGUi8EYJFR7bl_85oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b1Oooo`400001oooo0Oooo`001?ooo`<00003
oooo00<0003oooooool00oooob77alLQKFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b1Oooo`400001
oooo0Oooo`001Oooo`030000oooooooo00;oool00`000?ooooooo`03oooo8LO7ab5]KFdQoooo8O3`
l263Ph<QNGUi8EYJFR7bl_85oooo0@00007oool1oooo0003oooo100000?oool300000oooob77alLQ
KFe]8Oooob7`l?0QPh>38GUiNB5JFUXQl_;b0oooo`<00002oooo0003oooo00<0003oool000001?oo
o`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd]0Goool100000Ooo
o`7oool000Coool200001?ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQ
FUYJ8KBd]0Goool100000Oooo`7oool000Goool00`000?ooooooo`02oooo00<0003oooooool00ooo
ob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd]0Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQ3`l?8EYJFR6d];@5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ
];Bd1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUY
JB4?3`lQFUYJ8KBd]0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8D];Bb4X:2PQ
<C4a8EYJFR5YJFTQ3`l?8EYJFR6d];@5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd]0Goool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQ3`l?8EYJFR6d];@5oooo0@00
007oool1oooo000:oooo00<0003oooooool00oooob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ
];Bd1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUY
JB4?3`lQFUYJ8KBd]0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8D];Bb4X:2PQ
<C4a8EYJFR5YJFTQ3`l?8EYJFR6d];@5oooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
ob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd]0Goool100000Oooo`7oool0
00[oool200001?ooob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1?ooo`800002oooo000:
oooo00<0003oooooool00oooob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd
]0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQ
3`l?8EYJFR6d];@5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob5;Bd/Q:2PX8C4a
<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Bd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd]0Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQ3`l?8EYJFR6d];@5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd
]0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQ
3`l?8EYJFR6d];@5oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob5;Bd/Q:2PX8C4a
<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Bd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd]0Goool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQ3`l?8EYJFR6d];@5oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob5;Bd/Q:2PX8C4a<B5JFUXQJFUY8@l?3b5JFUXQ];Bd1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB4?3`lQFUYJ8KBd
]0Goool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQ
3`l?8EYJFR6d];@5oooo0@00007oool1oooo000:oooo0P0000CooolQBd];8BPX:24a<C4QFUYJ8FUY
JB4?3`lQFUYJ8KBd]0Coool200000_ooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQ
FUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd
]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[
:b5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQ
FUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd
]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[
:b5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQ
FUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd
]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Ooo
o`7oool000[oool200001?ooob6d];@QS8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1?ooo`800002
oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@00024[:b/Q
FUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJ
FR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@Q
S8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@00024[:b/Q
FUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJ
FR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@Q
S8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@00024[:b/QFUYJ8E9BDPGoool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008B/[:b5JFUXQDU9B1Ooo
o`400001oooo0Oooo`000oooo`800005oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ
00008B/[:b5JFUXQDU9B1Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?oo
ooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU85oooo0@00007oool1oooo0003
oooo00<0003oool000001?ooo`<00003oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q:b/[8EYJFR5BDU83
oooo0`0000;oool000?oool200001Oooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUY
JB6BTY92FUYJ1Oooo`400001oooo0Oooo`000oooo`030000oooooooo00Coool00`000?ooooooo`03
oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQTY:B@UYJFPGoool100000Oooo`7oool000Coool200001?oo
o`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92
FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUY
JB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4Q
FUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX
:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Bd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92
FUYJ1Oooo`400001oooo0Oooo`002_ooo`800004oooo8D];Bb4X:2PQ<C4a8EYJFR5YJFTQTY:B@UYJ
FPCoool200000_ooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92
FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUY
JB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4Q
FUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX
:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Bd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUYJB6BTY92
FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4QFUYJ8FUY
JB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX:24a<C4Q
FUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQBd];8BPX
:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
Bd];8BPX:24a<C4QFUYJ8FUYJB6BTY92FUYJ1Oooo`400001oooo0Oooo`002_ooo`800004oooo8D];
Bb4X:2PQ<C4a8EYJFR5YJFTQTY:B@UYJFPCoool200000_ooo`002_ooo`030000oooooooo00?ooolQ
];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H61R5JFUXQDU9B1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9B
DPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q
1PH68EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh
>25JFUXQ00008@H61R5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H61R5JFUXQDU9B1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9B
DPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q
1PH68EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh
>25JFUXQ00008@H61R5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ
];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85oooo0@00007oool1oooo000:
oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H61R5JFUXQDU9B1Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9B
DPGoool100000Oooo`7oool000[oool200001?ooob6d];@QS8b<8CPh>25JFUXQ00008@H61R5JFUXQ
DU9B1?ooo`800002oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H6
1R5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQ
FUYJ8@0002461PHQFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd
]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H61R5JFUXQDU9B1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9BDPGoool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H6
1R5JFUXQDU9B1Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQ
FUYJ8@0002461PHQFUYJ8E9BDPGoool100000Oooo`7oool000[oool00`000?ooooooo`03oooo8KBd
]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85oooo0@00007oool1oooo000:oooo00<0003ooooo
ool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H61R5JFUXQDU9B1Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9BDPGoool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85
oooo0@00007oool1oooo000:oooo00<0003oooooool00oooob6d];@QS8b<8CPh>25JFUXQ00008@H6
1R5JFUXQDU9B1Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`03
oooo8KBd]26<S8`Q>3Ph8EYJFR40000Q1PH68EYJFR5BDU85oooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo00?ooolQ];Bd8Hb<S24h>3PQFUYJ8@0002461PHQFUYJ8E9B
DPGoool100000Oooo`7oool000?oool00`000?ooo`000004oooo0`0000?ooolQ];Bd8Hb<S24h>3PQ
FUYJ8@0002461PHQFUYJ8E9BDP?oool300000_ooo`001?ooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`3o
oooo4Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo4Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0=oooo00<0003ooooo
ool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000
oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool0
0`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`0=
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool00_ooo`400001oooo0Oooo`002_ooool0000E00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, 
  0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[Transpose[waveletMatrix[8, coif6]] . wa, Mesh -> False]
      \)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0noooo0`00043oool30000?_ooo`800011oooo00<0003oooooool01_oo
o`003_ooo`030000oooo000003ooool00`000?ooooooo`11oooo00<0003oooooool0?Oooo`030000
oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool00000@?ooo`030000oooooooo
03koool40000?_ooo`030000oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool0
0000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo0P00047oool00`000?ooooooo`06
oooo000>oooo00<0003oool00000?oooo`030000oooo0000043oool20000?oooo`030000oooooooo
03ooool00`000?ooo`000007oooo000?oooo00<0003oooooool0?oooo`030000oooooooo043oool0
0`000?ooooooo`0noooo0P00043oool00`000?ooooooo`06oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`02oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooo`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03ooool00`000?ooooooo`02oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<0003ooooo3oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0004oooo00<0003oooooool00ooo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool200009Oooob400012ooooH`00
02Goool200000_ooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`80000Uoooo8@00
04;ooomS00009Oooo`800002oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool200001?oood800024
oooo8@0002Goool200000_ooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001
oooo0Oooo`000oooo`030000oooooooo00Coool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`001?ooo`030000oooooooo00?oool300000ooood800024oooo8@0002Coool3
00000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`15oooo8@00027ooomS
00009_ooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo0P0004KooolQ00008Oooof<0000Uoooo0P0000;oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool20000A_ooob40000QooooH`0002Goool200000_oo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo0P0008SooolQ00008Ooood800004oooo0P0000;oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`001?ooo`<00003
oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000Goool00`000?oo
ooooo`02oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000?oool4
00000oooo`<00027oooo8@00027ooom200000oooo`<00002oooo0003oooo00<0003oool000001?oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0004oooo0P0000Coool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`001Oooo`030000oooooooo
00;oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo0P0002GooolQ0000@_oo
of<0000Uoooo0P0000;oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ
0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ
0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool200009Ooo
ob400012ooooH`0002Goool200000_ooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
08CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
08CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo0P0000Cooom2
0000Q?ooob40000Uoooo0P0000;oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`000oooo`800005oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003oooooool00ooood800024oooo8@00
02Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo0`0000?ooom20000Q?ooob40000T
oooo0`0000;oool000?oool200001Oooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@00
02Koool100000Oooo`7oool000?oool00`000?ooooooo`04oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`001?ooo`800004oooo00<0003oooooool0AOoo
ob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ
00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Ooo
ob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ
00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00
027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Q
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Ooo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool1
00000Oooo`7oool000[oool20000A_ooob40000Qoooo8@00027ooolQ00009Oooo`800002oooo000:
oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15
oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOoo
ob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ
00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Ooo
ob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ
00008Oooob40000Voooo0@00007oool1oooo000:oooo0P0004KooolQ00008Oooob40000Qoooo8@00
02Goool200000_ooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`800028ooooH`0002Goool200000_ooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`001?ooo`030000oooooooo00?oool00`000?ooooooo`27ooooH`0002Koool100000Oooo`7oool0
00?oool00`000?ooo`000004oooo00<0003oooooool0Qoooof<0000Voooo0@00007oool1oooo0003
oooo00<0003oool000001?ooo`<00027ooooH`0002Coool300000_ooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0=
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool00_ooo`400001oooo0Oooo`002_ooool0000E00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, 
  0.0303025}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ \ Shifted\ Sample\)], "Input"],

Cell[BoxData[
    \(\(b = {{1, 1, 0, 1, 1, 0, 0, 0}, {1, 0, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 
          1, 0, 0, 0}, {1, 1, 1, 1, 1, 0, 1\ , 0}, {1, 1, 0, 1, 1, 0, 0, 0}, {
          1, 0, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 0, 1, 0, 1, 0}, {1, 1, 1, 1, 1, 
          0, 0\ , 0}}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[a, Mesh -> False], 
          ListDensityPlot[b, Mesh -> False]}]]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{198.688, 198.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000360000aQP00`40o`000?l0003oa_ooo`003Ooo
o`030000oooooooo02Soool30000:oooo`<0000Yoooo0P0002_oool00`000?ooooooo`04oooo000<
oooo00<0003oool00000:Oooo`030000oooooooo02coool00`000?ooooooo`0Xoooo00<0003oool0
0000:Oooo`030000oooo000000Goool000coool00`000?ooo`00000Zoooo00<0003oooooool0:Ooo
o`@0000Yoooo00<0003oool00000:Oooo`030000oooo000000Goool000coool00`000?ooo`00000Z
oooo00<0003oooooool0:Oooo`030000oooo000002[oool20000:oooo`030000oooooooo00Coool0
00coool00`000?ooo`00000Yoooo00<0003oool00000:oooo`80000Zoooo00<0003oooooool0:Ooo
o`030000oooo000000Goool000goool00`000?ooooooo`0Yoooo00<0003oooooool0:oooo`030000
oooooooo02Woool20000:_ooo`030000oooooooo00Coool00<Koool00<Koool00<Koool00<Koool0
00[ooonj00000_ooo`002_ooo`040000oooooooo00002_ooo`030000oooooooo00Woool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`040000oooooooo00000_ooo`001?oo
o`030000oooooooo00?oool00`000?ooooooo`2foooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`030000oooooooo0;Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo0P00
0;Koool200000_ooo`000oooo`030000oooo000000Coool00`000?ooooooo`0Foooo5`0002gooom3
00006Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`0Foooo5`00
02gooom300006Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`0F
oooo5`0002gooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG0000;Ooo
od<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`0001Woool1
00000Oooo`7oool000[oool00`000?ooooooo`0Foooo5`0002gooom300006Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00007oool1oooo000:oooo00<0
003oooooool05_oooaL0000]oooo@`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0F
oooo5`0002gooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG0000;Ooo
od<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`0001Soool2
00000_ooo`002_ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00007oool1oooo000:
oooo00<0003oooooool05_oooaL0000]oooo@`0001Woool100000Oooo`7oool000[oool00`000?oo
ooooo`0Foooo5`0002gooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG
0000;Ooood<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`00
01Woool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo5`0002gooom300006Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00007oool1oooo000:
oooo00<0003oooooool05_oooaL0000]oooo@`0001Woool100000Oooo`7oool000[oool00`000?oo
ooooo`0Foooo5`0002gooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG
0000;Ooood<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`00
01Soool200000_ooo`002_ooo`030000oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool0
00[oool00`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1oooo000:oooo00<0003ooooo
ool0;@0005WooolG00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02d0001Ioooo5`00
01Woool100000Oooo`7oool000[oool00`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1
oooo000:oooo00<0003oooooool0;@0005WooolG00006Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]0000FOoo
oaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;@0005WooolG00006Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool000[oool0
0`000?ooooooo`0]0000FOoooaL0000Hoooo0P0000;oool000[oool00`000?ooooooo`0]0000FOoo
oaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;@0005WooolG00006Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool000[oool0
0`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;@00
05WooolG00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02d0001Ioooo5`0001Woool1
00000Oooo`7oool000[oool00`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1oooo000:
oooo00<0003oooooool0;@0005WooolG00006Oooo`400001oooo0Oooo`000oooo`<00004oooo00<0
003oooooool0;@0005WooolG00006Oooo`400001oooo0Oooo`000oooo`030000oooooooo00Coool0
0`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1oooo0004oooo00<0003oooooool00ooo
o`8000000oooo`000000000[0000FOoooaL0000Hoooo0P0000;oool000Coool00`000?ooooooo`03
oooo00<0003oooooool0;@0005WooolG00006Oooo`400001oooo0Oooo`000oooo`030000oooo0000
00Coool00`000?ooooooo`0]oooo5P0001Oooom300006Oooo`400001oooo0Oooo`001?ooo`030000
oooooooo00?oool00`000?ooooooo`0]oooo5P0001Oooom300006Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo02gooolF00005ooood<0000Ioooo0@00007oool1oooo000:oooo00<0003ooooo
ool0;OoooaH0000Goooo@`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P00
01Oooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF00005ooood<0000I
oooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000Goooo@`0001Woool100000Ooo
o`7oool000[oool00`000?ooooooo`0]oooo5P0001Oooom300006Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo02gooolF00005ooood<0000Ioooo0@00007oool1oooo000:oooo00<0003ooooo
ool0;OoooaH0000Goooo@`0001Soool200000_ooo`002_ooo`030000oooooooo02gooolF00005ooo
od<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000Goooo@`0001Woool1
00000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0001Oooom300006Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo02gooolF00005ooood<0000Ioooo0@00007oool1oooo000:oooo00<0
003oooooool0;OoooaH0000Goooo@`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]
oooo5P0001Oooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF00005ooo
od<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000Goooo@`0001Woool1
00000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0001Oooom300006Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo02gooolF00005ooood<0000Ioooo0@00007oool1oooo000:oooo00<0
003oooooool0;OoooaH0000Goooo@`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]
oooo5P0001Oooom300006?ooo`800002oooo000:oooo00<0003oooooool0F_oooaH0000Foooo;@00
00?oool100000Oooo`7oool000[oool00`000?ooooooo`1Joooo5P0001Koool]00000oooo`400001
oooo0Oooo`002_ooo`030000oooooooo05[ooolF00005_ooobd00003oooo0@00007oool1oooo000:
oooo00<0003oooooool0F_oooaH0000Foooo;@0000?oool100000Oooo`7oool000[oool00`000?oo
ooooo`1Joooo5P0001Koool]00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo05[ooolF
00005_ooobd00003oooo0@00007oool1oooo000:oooo00<0003oooooool0F_oooaH0000Foooo;@00
00?oool100000Oooo`7oool000[oool00`000?ooooooo`1Joooo5P0001Koool]00000oooo`400001
oooo0Oooo`002_ooo`030000oooooooo05[ooolF00005_ooobd00003oooo0@00007oool1oooo000:
oooo00<0003oooooool0F_oooaH0000Foooo;@0000?oool100000Oooo`7oool000[oool00`000?oo
ooooo`1Joooo5P0001Koool]00000_ooo`800002oooo000:oooo00<0003oooooool0F_oooaH0000F
oooo;@0000?oool100000Oooo`7oool000[oool00`000?ooooooo`1Joooo5P0001Koool]00000ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo05[ooolF00005_ooobd00003oooo0@00007oool1
oooo000:oooo00<0003oooooool0F_oooaH0000Foooo;@0000?oool100000Oooo`7oool000[oool0
0`000?ooooooo`1Joooo5P0001Koool]00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo
05[ooolF00005_ooobd00003oooo0@00007oool1oooo000:oooo00<0003oooooool0F_oooaH0000F
oooo;@0000?oool100000Oooo`7oool000[oool00`000?ooooooo`1Joooo5P0001Koool]00000ooo
o`400001oooo0Oooo`001?ooo`<00003oooo00<0003oooooool0F_oooaH0000Foooo;@0000?oool1
00000Oooo`7oool000Goool00`000?ooooooo`02oooo00<0003oooooool0F_oooaH0000Foooo;@00
00?oool100000Oooo`7oool000?oool400000oooo`80001Koooo5P0001Koool]00000_ooo`800002
oooo0003oooo00<0003oool000001?ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00
007oool1oooo0004oooo0P0000Coool00`000?ooooooo`0Foooo5`0002gooom300006Oooo`400001
oooo0Oooo`001Oooo`030000oooooooo00;oool00`000?ooooooo`0Foooo5`0002gooom300006Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00007oool1
oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`0001Woool100000Oooo`7oool000[oool0
0`000?ooooooo`0Foooo5`0002gooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
01KooolG0000;Ooood<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool05_oooaL0000]
oooo@`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo5`0002gooom300006Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00007oool1
oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`0001Soool200000_ooo`002_ooo`030000
oooooooo01KooolG0000;Ooood<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool05_oo
oaL0000]oooo@`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo5`0002gooom3
00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00
007oool1oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`0001Woool100000Oooo`7oool0
00[oool00`000?ooooooo`0Foooo5`0002gooom300006Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo01KooolG0000;Ooood<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool05_oo
oaL0000]oooo@`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo5`0002gooom3
00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo01KooolG0000;Ooood<0000Ioooo0@00
007oool1oooo000:oooo00<0003oooooool05_oooaL0000]oooo@`0001Soool200000_ooo`002_oo
o`030000oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]
0000FOoooaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;@0005WooolG00006Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool0
00[oool00`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1oooo000:oooo00<0003ooooo
ool0;@0005WooolG00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02d0001Ioooo5`00
01Woool100000Oooo`7oool000[oool00`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1
oooo000:oooo00<0003oooooool0;@0005WooolG00006Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]0000FOoo
oaL0000Hoooo0P0000;oool000[oool00`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1
oooo000:oooo00<0003oooooool0;@0005WooolG00006Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]0000FOoo
oaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;@0005WooolG00006Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo02d0001Ioooo5`0001Woool100000Oooo`7oool000[oool0
0`000?ooooooo`0]0000FOoooaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;@00
05WooolG00006Oooo`400001oooo0Oooo`000oooo`800005oooo00<0003oooooool0;@0005WooolG
00006Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`0]0000FOoo
oaL0000Ioooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`8000000oooo`000000000[
0000FOoooaL0000Hoooo0P0000;oool000?oool200001Oooo`030000oooooooo02d0001Ioooo5`00
01Woool100000Oooo`7oool000?oool00`000?ooooooo`04oooo00<0003oooooool0;OoooaH0000G
oooo5P0001KooolG00006Oooo`400001oooo0Oooo`001?ooo`800004oooo00<0003oooooool0;Ooo
oaH0000Goooo5P0001KooolG00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF
00005ooooaH0000Foooo5`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P00
01OooolF00005_oooaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000G
oooo5P0001KooolG00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF00005ooo
oaH0000Foooo5`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0001OooolF
00005_oooaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000Goooo5P00
01KooolG00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF00005ooooaH0000F
oooo5`0001Woool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0001OooolF00005_oo
oaL0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000Goooo5P0001KooolG
00006?ooo`800002oooo000:oooo00<0003oooooool0;OoooaH0000Goooo5P0001KooolG00006Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF00005ooooaH0000Foooo5`0001Woool1
00000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0001OooolF00005_oooaL0000Ioooo0@00
007oool1oooo000:oooo00<0003oooooool0;OoooaH0000Goooo5P0001KooolG00006Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo02gooolF00005ooooaH0000Foooo5`0001Woool100000Ooo
o`7oool000[oool00`000?ooooooo`0]oooo5P0001OooolF00005_oooaL0000Ioooo0@00007oool1
oooo000:oooo00<0003oooooool0;OoooaH0000Goooo5P0001KooolG00006Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo02gooolF00005ooooaH0000Foooo5`0001Woool100000Oooo`7oool0
00[oool00`000?ooooooo`0]oooo5P0001OooolF00005_oooaL0000Ioooo0@00007oool1oooo000:
oooo00<0003oooooool0;OoooaH0000Goooo5P0001KooolG00006Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo02gooolF00005ooooaH0000Foooo5`0001Soool200000_ooo`002_ooo`030000
oooooooo05[ooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo05[ooom300006Ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo05[ooom300006Oooo`400001oooo0Oooo`002_oo
o`030000oooooooo05[ooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo05[ooom3
00006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo05[ooom300006Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo05[ooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo
05[ooom300006Oooo`400001oooo0Oooo`002_ooo`030000oooooooo05[ooom300006Oooo`400001
oooo0Oooo`002_ooo`030000oooooooo05[ooom300006Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo05[ooom300006?ooo`800002oooo000:oooo00<0003oooooool0F_oood<0000Ioooo0@00
007oool1oooo000:oooo00<0003oooooool0F_oood<0000Ioooo0@00007oool1oooo000:oooo00<0
003oooooool0F_oood<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0F_oood<0000I
oooo0@00007oool1oooo000:oooo00<0003oooooool0F_oood<0000Ioooo0@00007oool1oooo000:
oooo00<0003oooooool0F_oood<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0F_oo
od<0000Ioooo0@00007oool1oooo000:oooo00<0003oooooool0F_oood<0000Ioooo0@00007oool1
oooo0004oooo00<0003oooooool00oooo`030000oooooooo05[ooom300006Oooo`400001oooo0Ooo
o`000oooo`030000oooo000000Coool00`000?ooooooo`1Joooo@`0001Woool100000Oooo`7oool0
00?oool00`000?ooo`000004oooo0P0005_ooom300006?ooo`800002oooo0004oooo00<0003ooooo
ool00oooo`030000oooooooo0;Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo00@0
003oooooool0000/oooo00<0003oooooool0:Oooo`030000oooooooo02[oool00`000?ooooooo`0Z
oooo00@0003oooooool00002oooo0004oooo00<0003oooooool00oooo`040000oooooooo00002_oo
o`030000oooooooo00Woool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`09oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02Ooo
o`040000oooooooo00000_ooo`002_oookX00002oooo0000\
\>"],
  ImageRangeCache->{{{0, 197.688}, {197.688, 0}} -> {-0.618703, -0.667854, 
  0.0448679, 0.0448679}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF000000
FFFFFFFFFF00FF00
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF00FF00
FFFFFFFFFF000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{198.688, 198.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000360000aQP00`40o`000?l0003oa_ooo`003Ooo
o`030000oooooooo02Soool30000:oooo`<0000Yoooo0P0002_oool00`000?ooooooo`04oooo000<
oooo00<0003oool00000:Oooo`030000oooooooo02coool00`000?ooooooo`0Xoooo00<0003oool0
0000:Oooo`030000oooo000000Goool000coool00`000?ooo`00000Zoooo00<0003oooooool0:Ooo
o`@0000Yoooo00<0003oool00000:Oooo`030000oooo000000Goool000coool00`000?ooo`00000Z
oooo00<0003oooooool0:Oooo`030000oooo000002[oool20000:oooo`030000oooooooo00Coool0
00coool00`000?ooo`00000Yoooo00<0003oool00000:oooo`80000Zoooo00<0003oooooool0:Ooo
o`030000oooo000000Goool000goool00`000?ooooooo`0Yoooo00<0003oooooool0:oooo`030000
oooooooo02Woool20000:_ooo`030000oooooooo00Coool00<Koool00<Koool00<Koool00<Koool0
00[ooonj00000_ooo`002_ooo`040000oooooooo00002_ooo`030000oooooooo00Woool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`09oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`040000oooooooo00000_ooo`001?oo
o`030000oooooooo00?oool00`000?ooooooo`2foooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`030000oooooooo0;Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo0P00
0;Koool200000_ooo`000oooo`030000oooo000000Coool00`000?ooooooo`0]oooo5P0002gooom3
00000oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`0]oooo5P00
02gooom300000oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`0]
oooo5P0002gooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF0000;Ooo
od<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000]oooo@`0000?oool1
00000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0002gooom300000oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo02gooolF0000;Ooood<00003oooo0@00007oool1oooo000:oooo00<0
003oooooool0;OoooaH0000]oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0]
oooo5P0002gooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF0000;Ooo
od<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000]oooo@`0000;oool2
00000_ooo`002_ooo`030000oooooooo02gooolF0000;Ooood<00003oooo0@00007oool1oooo000:
oooo00<0003oooooool0;OoooaH0000]oooo@`0000?oool100000Oooo`7oool000[oool00`000?oo
ooooo`0]oooo5P0002gooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF
0000;Ooood<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000]oooo@`00
00?oool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0002gooom300000oooo`400001
oooo0Oooo`002_ooo`030000oooooooo02gooolF0000;Ooood<00003oooo0@00007oool1oooo000:
oooo00<0003oooooool0;OoooaH0000]oooo@`0000?oool100000Oooo`7oool000[oool00`000?oo
ooooo`0]oooo5P0002gooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF
0000;Ooood<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000]oooo@`00
00;oool200000_ooo`002_ooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1
oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool000[oool0
0`000?ooooooo`0Foooo;@0005[ooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo
01Koool]0000F_oooaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool05_ooobd0001J
oooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo;@0005[ooolF00000ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1
oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool000[oool0
0`000?ooooooo`0Foooo;@0005[ooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo
01Koool]0000F_oooaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool05_ooobd0001J
oooo5P0000;oool200000_ooo`002_ooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00
007oool1oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool0
00[oool00`000?ooooooo`0Foooo;@0005[ooolF00000oooo`400001oooo0Oooo`002_ooo`030000
oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool05_oo
obd0001Joooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo;@0005[ooolF
00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00
007oool1oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool0
00?oool300001?ooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1oooo0003
oooo00<0003oooooool01?ooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1
oooo0004oooo00<0003oooooool00oooo`80000Goooo;@0005[ooolF00000_ooo`800002oooo0004
oooo00<0003oooooool00oooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1
oooo0003oooo00<0003oool000001?ooo`030000oooooooo04?ooolG00005_oood<00003oooo0@00
007oool1oooo0004oooo00<0003oooooool00oooo`030000oooooooo04?ooolG00005_oood<00003
oooo0@00007oool1oooo000:oooo00<0003oooooool0@ooooaL0000Foooo@`0000?oool100000Ooo
o`7oool000[oool00`000?ooooooo`13oooo5`0001Kooom300000oooo`400001oooo0Oooo`002_oo
o`030000oooooooo04?ooolG00005_oood<00003oooo0@00007oool1oooo000:oooo00<0003ooooo
ool0@ooooaL0000Foooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`13oooo5`00
01Kooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo04?ooolG00005_oood<00003
oooo0@00007oool1oooo000:oooo00<0003oooooool0@ooooaL0000Foooo@`0000?oool100000Ooo
o`7oool000[oool00`000?ooooooo`13oooo5`0001Kooom300000_ooo`800002oooo000:oooo00<0
003oooooool0@ooooaL0000Foooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`13
oooo5`0001Kooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo04?ooolG00005_oo
od<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0@ooooaL0000Foooo@`0000?oool1
00000Oooo`7oool000[oool00`000?ooooooo`13oooo5`0001Kooom300000oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04?ooolG00005_oood<00003oooo0@00007oool1oooo000:oooo00<0
003oooooool0@ooooaL0000Foooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`13
oooo5`0001Kooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo04?ooolG00005_oo
od<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0@ooooaL0000Foooo@`0000?oool1
00000Oooo`7oool000[oool00`000?ooooooo`13oooo5`0001Kooom300000oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04?ooolG00005_oood<00002oooo0P0000;oool000[oool00`000?oo
ooooo`1`oooo5P0001OooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo073ooolF
00005ooooaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool0L?oooaH0000Goooo5P00
00?oool100000Oooo`7oool000[oool00`000?ooooooo`1`oooo5P0001OooolF00000oooo`400001
oooo0Oooo`002_ooo`030000oooooooo073ooolF00005ooooaH00003oooo0@00007oool1oooo000:
oooo00<0003oooooool0L?oooaH0000Goooo5P0000?oool100000Oooo`7oool000[oool00`000?oo
ooooo`1`oooo5P0001OooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo073ooolF
00005ooooaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool0L?oooaH0000Goooo5P00
00?oool100000Oooo`7oool000[oool00`000?ooooooo`1`oooo5P0001OooolF00000oooo`400001
oooo0Oooo`002_ooo`030000oooooooo073ooolF00005ooooaH00002oooo0P0000;oool000[oool0
0`000?ooooooo`1`oooo5P0001OooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo
073ooolF00005ooooaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool0L?oooaH0000G
oooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`1`oooo5P0001OooolF00000ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo073ooolF00005ooooaH00003oooo0@00007oool1
oooo000:oooo00<0003oooooool0L?oooaH0000Goooo5P0000?oool100000Oooo`7oool000[oool0
0`000?ooooooo`1`oooo5P0001OooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo
073ooolF00005ooooaH00003oooo0@00007oool1oooo0004oooo0`0000?oool00`000?ooooooo`1`
oooo5P0001OooolF00000oooo`400001oooo0Oooo`001Oooo`030000oooooooo00;oool00`000?oo
ooooo`1`oooo5P0001OooolF00000oooo`400001oooo0Oooo`000oooo`@00003oooo0P00077ooolF
00005ooooaH00002oooo0P0000;oool000?oool00`000?ooo`000004oooo00<0003oooooool0;Ooo
oaH0000]oooo@`0000?oool100000Oooo`7oool000Coool200001?ooo`030000oooooooo02gooolF
0000;Ooood<00003oooo0@00007oool1oooo0005oooo00<0003oooooool00_ooo`030000oooooooo
02gooolF0000;Ooood<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000]
oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0002gooom300000ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF0000;Ooood<00003oooo0@00007oool1
oooo000:oooo00<0003oooooool0;OoooaH0000]oooo@`0000?oool100000Oooo`7oool000[oool0
0`000?ooooooo`0]oooo5P0002gooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo
02gooolF0000;Ooood<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;OoooaH0000]
oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0002gooom300000_oo
o`800002oooo000:oooo00<0003oooooool0;OoooaH0000]oooo@`0000?oool100000Oooo`7oool0
00[oool00`000?ooooooo`0]oooo5P0002gooom300000oooo`400001oooo0Oooo`002_ooo`030000
oooooooo02gooolF0000;Ooood<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;Ooo
oaH0000]oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0002gooom3
00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo02gooolF0000;Ooood<00003oooo0@00
007oool1oooo000:oooo00<0003oooooool0;OoooaH0000]oooo@`0000?oool100000Oooo`7oool0
00[oool00`000?ooooooo`0]oooo5P0002gooom300000oooo`400001oooo0Oooo`002_ooo`030000
oooooooo02gooolF0000;Ooood<00003oooo0@00007oool1oooo000:oooo00<0003oooooool0;Ooo
oaH0000]oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0]oooo5P0002gooom3
00000_ooo`800002oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Ooo
o`7oool000[oool00`000?ooooooo`0Foooo;@0005[ooolF00000oooo`400001oooo0Oooo`002_oo
o`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1oooo000:oooo00<0003ooooo
ool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo;@00
05[ooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo01Koool]0000F_oooaH00003
oooo0@00007oool1oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Ooo
o`7oool000[oool00`000?ooooooo`0Foooo;@0005[ooolF00000oooo`400001oooo0Oooo`002_oo
o`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1oooo000:oooo00<0003ooooo
ool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0Foooo;@00
05[ooolF00000_ooo`800002oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool1
00000Oooo`7oool000[oool00`000?ooooooo`0Foooo;@0005[ooolF00000oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1oooo000:oooo00<0
003oooooool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`0F
oooo;@0005[ooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo01Koool]0000F_oo
oaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool1
00000Oooo`7oool000[oool00`000?ooooooo`0Foooo;@0005[ooolF00000oooo`400001oooo0Ooo
o`000oooo`800005oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Oooo`7oool0
00?oool00`000?ooo`000004oooo00<0003oooooool05_ooobd0001Joooo5P0000?oool100000Ooo
o`7oool000?oool00`000?ooo`000004oooo0P0001Ooool]0000F_oooaH00002oooo0P0000;oool0
00?oool200001Oooo`030000oooooooo01Koool]0000F_oooaH00003oooo0@00007oool1oooo0003
oooo00<0003oooooool01?ooo`030000oooooooo04?ooolG00005_oooaH0000Goooo5P0000?oool1
00000Oooo`7oool000Coool200001?ooo`030000oooooooo04?ooolG00005_oooaH0000Goooo5P00
00?oool100000Oooo`7oool000[oool00`000?ooooooo`13oooo5`0001KooolF00005ooooaH00003
oooo0@00007oool1oooo000:oooo00<0003oooooool0@ooooaL0000Foooo5P0001OooolF00000ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo04?ooolG00005_oooaH0000Goooo5P0000?oool1
00000Oooo`7oool000[oool00`000?ooooooo`13oooo5`0001KooolF00005ooooaH00003oooo0@00
007oool1oooo000:oooo00<0003oooooool0@ooooaL0000Foooo5P0001OooolF00000oooo`400001
oooo0Oooo`002_ooo`030000oooooooo04?ooolG00005_oooaH0000Goooo5P0000?oool100000Ooo
o`7oool000[oool00`000?ooooooo`13oooo5`0001KooolF00005ooooaH00003oooo0@00007oool1
oooo000:oooo00<0003oooooool0@ooooaL0000Foooo5P0001OooolF00000oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04?ooolG00005_oooaH0000Goooo5P0000;oool200000_ooo`002_oo
o`030000oooooooo04?ooolG00005_oooaH0000Goooo5P0000?oool100000Oooo`7oool000[oool0
0`000?ooooooo`13oooo5`0001KooolF00005ooooaH00003oooo0@00007oool1oooo000:oooo00<0
003oooooool0@ooooaL0000Foooo5P0001OooolF00000oooo`400001oooo0Oooo`002_ooo`030000
oooooooo04?ooolG00005_oooaH0000Goooo5P0000?oool100000Oooo`7oool000[oool00`000?oo
ooooo`13oooo5`0001KooolF00005ooooaH00003oooo0@00007oool1oooo000:oooo00<0003ooooo
ool0@ooooaL0000Foooo5P0001OooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo
04?ooolG00005_oooaH0000Goooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`13
oooo5`0001KooolF00005ooooaH00003oooo0@00007oool1oooo000:oooo00<0003oooooool0@ooo
oaL0000Foooo5P0001OooolF00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo04?ooolG
00005_oooaH0000Goooo5P0000?oool100000Oooo`7oool000[oool00`000?ooooooo`13oooo5`00
01KooolF00005ooooaH00002oooo0P0000;oool000[oool00`000?ooooooo`1`oooo@`0000?oool1
00000Oooo`7oool000[oool00`000?ooooooo`1`oooo@`0000?oool100000Oooo`7oool000[oool0
0`000?ooooooo`1`oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`1`oooo@`00
00?oool100000Oooo`7oool000[oool00`000?ooooooo`1`oooo@`0000?oool100000Oooo`7oool0
00[oool00`000?ooooooo`1`oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`1`
oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`1`oooo@`0000?oool100000Ooo
o`7oool000[oool00`000?ooooooo`1`oooo@`0000?oool100000Oooo`7oool000[oool00`000?oo
ooooo`1`oooo@`0000?oool100000Oooo`7oool000[oool00`000?ooooooo`1`oooo@`0000;oool2
00000_ooo`002_ooo`030000oooooooo073ooom300000oooo`400001oooo0Oooo`002_ooo`030000
oooooooo073ooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo073ooom300000ooo
o`400001oooo0Oooo`002_ooo`030000oooooooo073ooom300000oooo`400001oooo0Oooo`002_oo
o`030000oooooooo073ooom300000oooo`400001oooo0Oooo`002_ooo`030000oooooooo073ooom3
00000oooo`400001oooo0Oooo`002_ooo`030000oooooooo073ooom300000oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo073ooom300000oooo`400001oooo0Oooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`1`oooo@`0000?oool100000Oooo`7oool000?oool00`000?ooo`000004
oooo00<0003oooooool0L?oood<00003oooo0@00007oool1oooo0003oooo00<0003oool000001?oo
o`80001aoooo@`0000;oool200000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`2f
oooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`040000oooooooo0000;?ooo`030000
oooooooo02Woool00`000?ooooooo`0Zoooo00<0003oooooool0:_ooo`040000oooooooo00000_oo
o`001?ooo`030000oooooooo00?oool010000?ooooooo`0000[oool00`000?ooooooo`09oooo00<0
003oooooool02?ooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02?oo
o`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool02Oooo`030000oooooooo
00Soool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Soool00`000?oo
ooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Woool010000?ooooooo`0000;oool0
00[ooonj00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 197.688}, {197.688, 0}} -> {-0.618703, -0.667854, 
  0.0448679, 0.0448679}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF000000
FFFFFFFFFF00FF00
FFFF00FFFF000000
FF0000FFFFFFFF00
FFFFFF00FF00FF00
FFFFFFFFFF000000
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{287.875, 137.063},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O0000RAP00`40o`000?l0003oooooob3oool0
0?oooolPoooo003ooooo8?ooo`00ooooob3oool00?oooolPoooo000Boooo00<0003oooooool06?oo
o`<0000Koooo0`0001Soool200006oooo`030000oooooooo01_oool00`000?ooooooo`0Hoooo0`00
01[oool300006?ooo`80000Koooo00<0003oooooool02oooo`004Oooo`030000oooo000001Woool0
0`000?ooooooo`0Loooo00<0003oooooool05oooo`030000oooo000001Woool00`000?ooo`00000K
oooo00<0003oool000006Oooo`030000oooooooo01_oool00`000?ooooooo`0Goooo00<0003oool0
00006Oooo`030000oooo000000coool0017oool00`000?ooo`00000Joooo00<0003oooooool06Ooo
o`@0000Hoooo00<0003oool000006Oooo`030000oooo000001_oool00`000?ooo`00000Joooo00<0
003oooooool06?ooo`@0000Hoooo00<0003oool000006Oooo`030000oooo000000coool0017oool0
0`000?ooo`00000Joooo00<0003oooooool06Oooo`030000oooo000001Woool200006oooo`030000
oooooooo01[oool00`000?ooo`00000Joooo00<0003oooooool06?ooo`030000oooo000001Woool2
00006oooo`030000oooooooo00_oool0017oool00`000?ooo`00000Ioooo00<0003oool000006ooo
o`80000Ioooo00<0003oooooool06Oooo`030000oooo000001_oool00`000?ooo`00000Ioooo00<0
003oool000006_ooo`80000Ioooo00<0003oooooool06Oooo`030000oooo000000coool001;oool0
0`000?ooooooo`0Ioooo00<0003oooooool06oooo`030000oooooooo01Soool200006_ooo`030000
oooooooo01_oool00`000?ooooooo`0Ioooo00<0003oooooool06_ooo`030000oooooooo01Soool2
00006_ooo`030000oooooooo00_oool00?oooolPoooo003ooooo8?ooo`00ooooob3oool000coool0
0`000?ooooooo`02ooooM@0001Goool010000?ooooooooooogH0000:oooo000;oooo00<0003oool0
00000oooo`030000oooo000000Koool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000
oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool0
0`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04
oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003ooooo
ool01?ooo`030000oooooooo00Coool00`000?ooo`00000Doooo00<0003oool000000_ooo`030000
oooo000000Koool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Coool0
0`000?ooooooo`04oooo00<0003oooooool01?ooo`030000oooooooo00Goool00`000?ooooooo`04
oooo00<0003oooooool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003ooooo
ool01?ooo`030000oooooooo00Coool00`000?ooooooo`04oooo00<0003oooooool01?ooo`030000
oooooooo00Coool00`000?ooo`00000:oooo000;oooo00<0003oool000000oooo`030000oooooooo
077oool00`000?ooooooo`0Boooo00<0003oool000000_ooo`80001boooo0P0000[oool000_oool0
0`000?ooo`000003oooo00<0003oooooool03Oooo`h0000Loooo:P00013oool00`000?ooooooo`0B
oooo00<0003oool000000_ooo`030000oooooooo01_oool>00007OooobX00002oooo00<0003ooooo
ool02?ooo`002oooo`030000oooo000000?oool00`000?ooooooo`0=oooo3P0001cooolZ00004?oo
o`030000oooooooo01;oool00`000?ooo`000002oooo00<0003oooooool06oooo`h0000Moooo:P00
00;oool00`000?ooooooo`08oooo000<oooo00<0003oooooool00_ooo`030000oooooooo00goool>
00007?ooobX0000@oooo00<0003oooooool04oooo`050000oooooooooooo000001goool>00007Ooo
obX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo00goool>00007?ooobX0000@
oooo00<0003oooooool05oooo`030000oooooooo01_oool>00007OooobX00002oooo00<0003ooooo
ool02?ooo`004Oooo`030000oooooooo00goool>00007?ooobX0000@oooo00<0003oooooool05ooo
o`030000oooooooo01_oool>00007OooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000
oooooooo00goool>00007?ooobX0000@oooo00<0003oooooool05oooo`030000oooooooo01_oool>
00007OooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo00goool>00007?oo
obX0000@oooo00<0003oooooool05oooo`80000Loooo3P0001gooolZ00000_ooo`030000oooooooo
00Soool0017oool00`000?ooooooo`0=oooo3P0001cooolZ00004?ooo`030000oooooooo01Ooool0
0`000?ooooooo`0Koooo3P0001gooolZ00000_ooo`030000oooooooo00Soool0017oool00`000?oo
ooooo`0=oooo3P0001cooolZ00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0Koooo3P00
01gooolZ00000_ooo`030000oooooooo00Soool0017oool00`000?ooooooo`0=oooo3P0001cooolZ
00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0Koooo3P0001gooolZ00000_ooo`030000
oooooooo00Soool0017oool00`000?ooooooo`0=oooo3P0001cooolZ00004?ooo`030000oooooooo
01Ooool00`000?ooooooo`0Koooo3P0001gooolZ00000_ooo`030000oooooooo00Soool0017oool0
0`000?ooooooo`0=oooo3P0001cooolZ00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0K
oooo3P0001gooolZ00000_ooo`030000oooooooo00Soool0017oool00`000?ooooooo`0=oooo3P00
01cooolZ00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0Koooo3P0001gooolZ00000_oo
o`030000oooooooo00Soool0017oool00`000?ooooooo`0=oooo3P0001cooolZ00004?ooo`030000
oooooooo01Ooool200007?ooo`h0000Moooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0
003oool000006`0003Soool>00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0=oooo7000
03Woool>00000_ooo`030000oooooooo00Soool0017oool00`000?ooo`00000K0000>?ooo`h0000@
oooo00<0003oooooool05oooo`030000oooooooo00gooolL0000>Oooo`h00002oooo00<0003ooooo
ool02?ooo`004Oooo`030000oooo000001/0000hoooo3P00013oool00`000?ooooooo`0Goooo00<0
003oooooool03Ooooa`0000ioooo3P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003oool0
00006`0003Soool>00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0=oooo700003Woool>
00000_ooo`030000oooooooo00Soool0017oool00`000?ooo`00000K0000>?ooo`h0000@oooo00<0
003oooooool05oooo`030000oooooooo00gooolL0000>Oooo`h00002oooo00<0003oooooool02?oo
o`004Oooo`030000oooo000001/0000hoooo3P00013oool00`000?ooooooo`0Goooo00<0003ooooo
ool03Ooooa`0000ioooo3P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003oool000006`00
03Soool>00004?ooo`030000oooooooo01Ooool200003_oooa`0000ioooo3P0000;oool00`000?oo
ooooo`08oooo000Aoooo00<0003oool000006`0003Soool>00004?ooo`030000oooooooo01Ooool0
0`000?ooooooo`0=oooo700003Woool>00000_ooo`030000oooooooo00Soool0017oool00`000?oo
o`00000K0000>?ooo`h0000@oooo00<0003oooooool05oooo`030000oooooooo00gooolL0000>Ooo
o`h00002oooo00<0003oooooool02?ooo`004Oooo`030000oooo000001/0000hoooo3P00013oool0
0`000?ooooooo`0Goooo00<0003oooooool03Ooooa`0000ioooo3P0000;oool00`000?ooooooo`08
oooo000Aoooo00<0003oool000006`0003Soool>00004?ooo`030000oooooooo01Ooool00`000?oo
ooooo`0=oooo700003Woool>00000_ooo`030000oooooooo00Soool000_oool300000oooo`030000
oooo000001/0000hoooo3P00013oool00`000?ooooooo`0Boooo0`0000;oool00`000?ooooooo`0=
oooo700003Woool>00000_ooo`030000oooooooo00Soool000_oool00`000?ooooooo`03oooo00<0
003oool000006`0003Soool>00004?ooo`030000oooooooo01;oool00`000?ooooooo`02oooo00<0
003oooooool03Ooooa`0000ioooo3P0000;oool00`000?ooooooo`08oooo000<oooo00<0003ooooo
ool00_ooo`030000oooo000001/0000hoooo3P00013oool00`000?ooooooo`0Coooo00@0003ooooo
ooooool200003_oooa`0000ioooo3P000003oooo0000000000[oool000coool00`000?ooooooo`02
oooo00<0003oooooool06oooo`h0000>oooo:P00013oool00`000?ooooooo`0Coooo00D0003ooooo
ooooool00000:oooo`l0000>oooo:P0000;oool00`000?ooooooo`08oooo000;oooo00<0003oool0
00000oooo`030000oooooooo01_oool>00003_ooobX0000@oooo00<0003oooooool04_ooo`030000
oooo000000;oool00`000?ooooooo`0Yoooo3`0000kooolZ00000_ooo`030000oooooooo00Soool0
00coool00`000?ooooooo`02oooo00<0003oooooool06oooo`h0000>oooo:P00013oool00`000?oo
ooooo`0Coooo00D0003oooooooooool00000:oooo`l0000>oooo:P0000;oool00`000?ooooooo`08
oooo000Aoooo00<0003oooooool06oooo`h0000>oooo:P00013oool00`000?ooooooo`0Goooo00<0
003oooooool0:Oooo`l0000>oooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003ooooo
ool06oooo`h0000>oooo:P00013oool00`000?ooooooo`0Goooo00<0003oooooool0:Oooo`l0000>
oooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003oooooool06oooo`h0000>oooo:P00
013oool00`000?ooooooo`0Goooo00<0003oooooool0:Oooo`l0000>oooo:P0000;oool00`000?oo
ooooo`08oooo000Aoooo00<0003oooooool06oooo`h0000>oooo:P00013oool00`000?ooooooo`0G
oooo00<0003oooooool0:Oooo`l0000>oooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0
003oooooool06oooo`h0000>oooo:P00013oool00`000?ooooooo`0Goooo0P0002[oool?00003_oo
obX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo01_oool>00003_ooobX0000@
oooo00<0003oooooool05oooo`030000oooooooo02Woool?00003_ooobX00002oooo00<0003ooooo
ool02?ooo`004Oooo`030000oooooooo01_oool>00003_ooobX0000@oooo00<0003oooooool05ooo
o`030000oooooooo02Woool?00003_ooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000
oooooooo01_oool>00003_ooobX0000@oooo00<0003oooooool05oooo`030000oooooooo02Woool?
00003_ooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo01_oool>00003_oo
obX0000@oooo00<0003oooooool05oooo`030000oooooooo02Woool?00003_ooobX00002oooo00<0
003oooooool02?ooo`004Oooo`030000oooooooo01_oool>00003_ooobX0000@oooo00<0003ooooo
ool05oooo`030000oooooooo02Woool?00003_ooobX00002oooo00<0003oooooool02?ooo`004Ooo
o`030000oooooooo01_oool>00003_ooobX0000@oooo00<0003oooooool05oooo`030000oooooooo
02Woool?00003_ooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo03Ooool>
00003_oooa`00002oooo00<0003oooooool05oooo`800017oooo3P0000koool>00000_ooo`030000
oooooooo00Soool0017oool00`000?ooooooo`0goooo3P0000kooolL00000_ooo`030000oooooooo
01Ooool00`000?ooooooo`16oooo3P0000koool>00000_ooo`030000oooooooo00Soool0017oool0
0`000?ooooooo`0goooo3P0000kooolL00000_ooo`030000oooooooo01Ooool00`000?ooooooo`16
oooo3P0000koool>00000_ooo`030000oooooooo00Soool0017oool00`000?ooooooo`0goooo3P00
00kooolL00000_ooo`030000oooooooo01Ooool00`000?ooooooo`16oooo3P0000koool>00000_oo
o`030000oooooooo00Soool0017oool00`000?ooooooo`0goooo3P0000kooolL00000_ooo`030000
oooooooo01Ooool00`000?ooooooo`16oooo3P0000koool>00000_ooo`030000oooooooo00Soool0
017oool00`000?ooooooo`0goooo3P0000kooolL00000_ooo`030000oooooooo01Ooool00`000?oo
ooooo`16oooo3P0000koool>00000_ooo`030000oooooooo00Soool0017oool00`000?ooooooo`0g
oooo3P0000kooolL00000_ooo`030000oooooooo01Ooool00`000?ooooooo`16oooo3P0000koool>
00000_ooo`030000oooooooo00Soool0017oool00`000?ooooooo`0goooo3P0000kooolL00000_oo
o`030000oooooooo01Ooool20000Aoooo`h0000>oooo3P0000;oool00`000?ooooooo`08oooo000A
oooo00<0003oooooool0=oooo`h0000>oooo700000;oool00`000?ooooooo`0Goooo00<0003ooooo
ool0A_ooo`h0000>oooo3P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003oooooool0=ooo
o`h0000>oooo700000;oool00`000?ooooooo`0Goooo00<0003oooooool0A_ooo`h0000>oooo3P00
00;oool00`000?ooooooo`08oooo000Aoooo00<0003oooooool0=oooo`h0000>oooo700000;oool0
0`000?ooooooo`0Goooo00<0003oooooool0A_ooo`h0000>oooo3P0000;oool00`000?ooooooo`08
oooo000Aoooo00<0003oooooool0=oooo`h0000>oooo700000;oool00`000?ooooooo`0Goooo00<0
003oooooool0A_ooo`h0000>oooo3P0000;oool00`000?ooooooo`08oooo000<oooo0`0000;oool0
0`000?ooooooo`0goooo3P0000kooolL00000_ooo`030000oooooooo01?oool3000000?oool0003o
ool0Aoooo`h0000>oooo3P0000;oool00`000?ooooooo`08oooo000=oooo00D0003oooooooooool0
0000>Oooo`h0000>oooo700000;oool00`000?ooooooo`0Doooo00@0003oooooool00018oooo3P00
00koool>00000_ooo`030000oooooooo00Soool000_oool400000_ooo`030000oooooooo03Ooool>
00003_oooa`00002oooo00<0003oooooool04_ooo`@000000oooo`0000000017oooo3P0000koool>
000000?oool0000000002_ooo`002oooo`030000oooo000000?oool00`000?ooooooo`0=oooo3P00
01cooolZ00004?ooo`030000oooooooo01;oool00`000?ooo`000002oooo00<0003oooooool06ooo
o`h0000Moooo:P0000;oool00`000?ooooooo`08oooo000<oooo0P0000?oool00`000?ooooooo`0=
oooo3P0001cooolZ00004?ooo`030000oooooooo01?oool200000_ooo`030000oooooooo01_oool>
00007OooobX00002oooo00<0003oooooool02?ooo`003Oooo`050000oooooooooooo000000ooool>
00007?ooobX0000@oooo00<0003oooooool05?ooo`040000oooooooo00007Oooo`h0000Moooo:P00
00;oool00`000?ooooooo`08oooo000Aoooo00<0003oooooool03Oooo`h0000Loooo:P00013oool0
0`000?ooooooo`0Goooo00<0003oooooool06oooo`h0000Moooo:P0000;oool00`000?ooooooo`08
oooo000Aoooo00<0003oooooool03Oooo`h0000Loooo:P00013oool00`000?ooooooo`0Goooo00<0
003oooooool06oooo`h0000Moooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003ooooo
ool03Oooo`h0000Loooo:P00013oool00`000?ooooooo`0Goooo00<0003oooooool06oooo`h0000M
oooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003oooooool03Oooo`h0000Loooo:P00
013oool00`000?ooooooo`0Goooo0P0001coool>00007OooobX00002oooo00<0003oooooool02?oo
o`004Oooo`030000oooooooo00goool>00007?ooobX0000@oooo00<0003oooooool05oooo`030000
oooooooo01_oool>00007OooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo
00goool>00007?ooobX0000@oooo00<0003oooooool05oooo`030000oooooooo01_oool>00007Ooo
obX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo00goool>00007?ooobX0000@
oooo00<0003oooooool05oooo`030000oooooooo01_oool>00007OooobX00002oooo00<0003ooooo
ool02?ooo`004Oooo`030000oooooooo00goool>00007?ooobX0000@oooo00<0003oooooool05ooo
o`030000oooooooo01_oool>00007OooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000
oooooooo00goool>00007?ooobX0000@oooo00<0003oooooool05oooo`030000oooooooo01_oool>
00007OooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo00goool>00007?oo
obX0000@oooo00<0003oooooool05oooo`030000oooooooo01_oool>00007OooobX00002oooo00<0
003oooooool02?ooo`004Oooo`030000oooooooo00goool>00007?ooobX0000@oooo00<0003ooooo
ool05oooo`80000Loooo3P0001gooolZ00000_ooo`030000oooooooo00Soool0017oool00`000?oo
o`00000K0000>?ooo`h0000@oooo00<0003oooooool05oooo`030000oooooooo00gooolL0000>Ooo
o`h00002oooo00<0003oooooool02?ooo`004Oooo`030000oooo000001/0000hoooo3P00013oool0
0`000?ooooooo`0Goooo00<0003oooooool03Ooooa`0000ioooo3P0000;oool00`000?ooooooo`08
oooo000Aoooo00<0003oool000006`0003Soool>00004?ooo`030000oooooooo01Ooool00`000?oo
ooooo`0=oooo700003Woool>00000_ooo`030000oooooooo00Soool0017oool00`000?ooo`00000K
0000>?ooo`h0000@oooo00<0003oooooool05oooo`030000oooooooo00gooolL0000>Oooo`h00002
oooo00<0003oooooool02?ooo`004Oooo`030000oooo000001/0000hoooo3P00013oool00`000?oo
ooooo`0Goooo00<0003oooooool03Ooooa`0000ioooo3P0000;oool00`000?ooooooo`08oooo000A
oooo00<0003oool000006`0003Soool>00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0=
oooo700003Woool>00000_ooo`030000oooooooo00Soool0017oool00`000?ooo`00000K0000>?oo
o`h0000@oooo00<0003oooooool05oooo`80000>oooo700003Woool>00000_ooo`030000oooooooo
00Soool0017oool00`000?ooo`00000K0000>?ooo`h0000@oooo00<0003oooooool05oooo`030000
oooooooo00gooolL0000>Oooo`h00002oooo00<0003oooooool02?ooo`004Oooo`030000oooo0000
01/0000hoooo3P00013oool00`000?ooooooo`0Goooo00<0003oooooool03Ooooa`0000ioooo3P00
00;oool00`000?ooooooo`08oooo000Aoooo00<0003oool000006`0003Soool>00004?ooo`030000
oooooooo01Ooool00`000?ooooooo`0=oooo700003Woool>00000_ooo`030000oooooooo00Soool0
017oool00`000?ooo`00000K0000>?ooo`h0000@oooo00<0003oooooool05oooo`030000oooooooo
00gooolL0000>Oooo`h00002oooo00<0003oooooool02?ooo`002oooo`800004oooo00<0003oool0
00006`0003Soool>00004?ooo`030000oooooooo01;oool200000oooo`030000oooooooo00gooolL
0000>Oooo`h00002oooo00<0003oooooool02?ooo`002oooo`030000oooo000000?oool00`000?oo
o`00000K0000>?ooo`h0000@oooo00<0003oooooool04_ooo`030000oooo000000;oool00`000?oo
ooooo`0=oooo700003Woool>00000_ooo`030000oooooooo00Soool000_oool00`000?ooo`000003
oooo00<0003oool000006`0003Soool>00004?ooo`030000oooooooo01;oool00`000?ooo`000002
oooo0P0000kooolL0000>Oooo`h000000oooo`000000000:oooo000;oooo0P0000Coool00`000?oo
ooooo`0Koooo3P0000koool>00003_ooo`h0000@oooo00<0003oooooool04_ooo`800003oooo00<0
003oooooool0:Oooo`l0000>oooo3P0000koool>00000_ooo`030000oooooooo00Soool000_oool0
0`000?ooooooo`03oooo00<0003oooooool06oooo`h0000>oooo3P0000koool>00004?ooo`030000
oooooooo01;oool00`000?ooooooo`02oooo00<0003oooooool0:Oooo`l0000>oooo3P0000koool>
00000_ooo`030000oooooooo00Soool000coool200000oooo`030000oooooooo01_oool>00003_oo
o`h0000>oooo3P00013oool00`000?ooooooo`0Coooo0P0000;oool00`000?ooooooo`0Yoooo3`00
00koool>00003_ooo`h00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo01_oool>
00003_ooo`h0000>oooo3P00013oool00`000?ooooooo`0Goooo00<0003oooooool0:Oooo`l0000>
oooo3P0000koool>00000_ooo`030000oooooooo00Soool0017oool00`000?ooooooo`0Koooo3P00
00koool>00003_ooo`h0000@oooo00<0003oooooool05oooo`030000oooooooo02Woool?00003_oo
o`h0000>oooo3P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003oooooool06oooo`h0000>
oooo3P0000koool>00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0Yoooo3`0000koool>
00003_ooo`h00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo01_oool>00003_oo
o`h0000>oooo3P00013oool00`000?ooooooo`0Goooo0P0002[oool?00003_ooo`h0000>oooo3P00
00;oool00`000?ooooooo`08oooo000Aoooo00<0003oooooool06oooo`h0000>oooo3P0000koool>
00004?ooo`030000oooooooo01Ooool00`000?ooooooo`0Yoooo3`0000koool>00003_ooo`h00002
oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo01_oool>00003_ooo`h0000>oooo3P00
013oool00`000?ooooooo`0Goooo00<0003oooooool0:Oooo`l0000>oooo3P0000koool>00000_oo
o`030000oooooooo00Soool0017oool00`000?ooooooo`0Koooo3P0000koool>00003_ooo`h0000@
oooo00<0003oooooool05oooo`030000oooooooo02Woool?00003_ooo`h0000>oooo3P0000;oool0
0`000?ooooooo`08oooo000Aoooo00<0003oooooool06oooo`h0000>oooo3P0000koool>00004?oo
o`030000oooooooo01Ooool00`000?ooooooo`0Yoooo3`0000koool>00003_ooo`h00002oooo00<0
003oooooool02?ooo`004Oooo`030000oooooooo01_oool>00003_ooo`h0000>oooo3P00013oool0
0`000?ooooooo`0Goooo00<0003oooooool0:Oooo`l0000>oooo3P0000koool>00000_ooo`030000
oooooooo00Soool0017oool00`000?ooooooo`0Koooo3P0000koool>00003_ooo`h0000@oooo00<0
003oooooool05oooo`030000oooooooo02Woool?00003_ooo`h0000>oooo3P0000;oool00`000?oo
ooooo`08oooo000Aoooo00<0003oooooool06oooo`h0000>oooo3P0000koool>00004?ooo`030000
oooooooo01Ooool20000:_ooo`l0000>oooo3P0000koool>00000_ooo`030000oooooooo00Soool0
017oool00`000?ooooooo`0goooo:P00013oool00`000?ooooooo`0Goooo00<0003oooooool0A_oo
obX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo03OooolZ00004?ooo`030000
oooooooo01Ooool00`000?ooooooo`16oooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0
003oooooool0=oooobX0000@oooo00<0003oooooool05oooo`030000oooooooo04KooolZ00000_oo
o`030000oooooooo00Soool0017oool00`000?ooooooo`0goooo:P00013oool00`000?ooooooo`0G
oooo00<0003oooooool0A_ooobX00002oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo
03OooolZ00004?ooo`030000oooooooo01Ooool00`000?ooooooo`16oooo:P0000;oool00`000?oo
ooooo`08oooo000Aoooo00<0003oooooool0=oooobX0000@oooo00<0003oooooool05oooo`030000
oooooooo04KooolZ00000_ooo`030000oooooooo00Soool0017oool00`000?ooooooo`0goooo:P00
013oool00`000?ooooooo`0Goooo0P0004OooolZ00000_ooo`030000oooooooo00Soool0017oool0
0`000?ooooooo`0goooo:P00013oool00`000?ooooooo`0Goooo00<0003oooooool0A_ooobX00002
oooo00<0003oooooool02?ooo`004Oooo`030000oooooooo03OooolZ00004?ooo`030000oooooooo
01Ooool00`000?ooooooo`16oooo:P0000;oool00`000?ooooooo`08oooo000Aoooo00<0003ooooo
ool0=oooobX0000@oooo00<0003oooooool05oooo`030000oooooooo04KooolZ00000_ooo`030000
oooooooo00Soool0017oool00`000?ooooooo`0goooo:P00013oool00`000?ooooooo`0Goooo00<0
003oooooool0A_ooobX00002oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo00;oool0
0`000?ooooooo`0goooo:P00013oool00`000?ooooooo`0Coooo00D0003oooooooooool00000B?oo
obX00002oooo00<0003oooooool02?ooo`002oooo`030000oooo000000?oool00`000?ooooooo`0g
oooo:P00013oool00`000?ooooooo`0Boooo00<0003oool000000_ooo`030000oooooooo04KooolZ
00000_ooo`030000oooooooo00Soool000_oool00`000?ooo`000003oooo00<0003oooooool0=ooo
obX0000@oooo00<0003oooooool04_ooo`030000oooo000000;oool20000AoooobX000000oooo`00
0000000:oooo000<oooo00<0003oooooool00_ooo`030000oooo000001_oool00`000?ooooooo`0I
oooo00<0003oooooool06Oooo`030000oooooooo01Woool00`000?ooo`00000Eoooo00L0003ooooo
ooooool0003oool000006oooo`030000oooooooo01[oool00`000?ooooooo`0Ioooo00<0003ooooo
ool06Oooo`030000oooo000000[oool000_oool00`000?ooo`000003ooooM@0001Coool00`000?oo
o`000002ooooMP0000[oool000coool00`000?ooooooo`2<oooo00<0003oooooool0POooo`00oooo
ob3oool00?oooolPoooo003ooooo8?ooo`00ooooob3oool00001\
\>"],
  ImageRangeCache->{{{0, 286.875}, {136.063, 0}} -> {-0.0542125, -0.0238146, 
  0.00734964, 0.00734964}, {{7.375, 136.938}, {132.813, 
  3.1875}} -> {-1.37378, -1.13582, 0.0711656, 0.0711656}, {{149.875, 279.5}, {
  132.813, 3.1875}} -> {-11.5171, -1.13582, 0.0711656, 0.0711656}}]
}, Open  ]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Correlation",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
corRelation=
\tCompile[{{vectorA,_Real,1},{vectorB,_Real,1}},
\t\tModule[{meanA=0.,meanB=0.,normA=0.,normB=0.,
\t\t\t\tvectorAprime={0.},vectorBprime={0.}},
\t\t\tmeanA=Apply[Plus,vectorA]/Length[vectorA];
\t\t\tmeanB=Apply[Plus,vectorB]/Length[vectorB];
\t\t\tvectorAprime=vectorA-meanA;
\t\t\tnormA=Sqrt[vectorAprime.vectorAprime];
\t\t\tvectorBprime=vectorB-meanB;
\t\t\tnormB=Sqrt[vectorBprime.vectorBprime];
\t\t\tvectorAprime.vectorBprime/(normA normB)]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["corRelation[Flatten[a],Flatten[b]]", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(0.00201311590117981031`\)], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Discrete",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(fa = Fourier[a]; \)\)], "Input"],

Cell[BoxData[
    \(\(fb = Fourier[b]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(corRelation[Flatten[Abs[fa]], Flatten[Abs[fb]]]\)], "Input"],

Cell[BoxData[
    \(0.991480802264312544`\)], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wa = waveletMatrix[8, coif6] . a; \)\)], "Input"],

Cell[BoxData[
    \(\(wb = waveletMatrix[8, coif6] . b; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(corRelation[Flatten[wa], Flatten[wb]]\)], "Input"],

Cell[BoxData[
    \(0.455613437252285713`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[FilledSquare]\ Bad\ Sample\)], "Input"],

Cell[BoxData[
    \(\(d = {{1, 0, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 
          0, 0, 0, 1}, {1, 1, 1, 1, 0, 1\ , 0, 0}, {1, 0, 1, 1, 0, 1, 0, 1}, {
          0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 0, 1}, {1, 1, 1, 1, 0, 0
          \ , 0, 1}}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      GraphicsArray[{ListDensityPlot[a, Mesh -> False], 
          ListDensityPlot[d, Mesh -> False]}]]\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0noooo0`00043oool30000?_ooo`800011oooo00<0003oooooool01_oo
o`003_ooo`030000oooo000003ooool00`000?ooooooo`11oooo00<0003oooooool0?Oooo`030000
oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool00000@?ooo`030000oooooooo
03koool40000?_ooo`030000oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool0
0000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo0P00047oool00`000?ooooooo`06
oooo000>oooo00<0003oool00000?oooo`030000oooo0000043oool20000?oooo`030000oooooooo
03ooool00`000?ooo`000007oooo000?oooo00<0003oooooool0?oooo`030000oooooooo043oool0
0`000?ooooooo`0noooo0P00043oool00`000?ooooooo`06oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`02oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooo`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03ooool00`000?ooooooo`02oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<0003ooooo3oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0004oooo00<0003oooooool00ooo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool200009Oooob400012ooooH`00
02Goool200000_ooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`80000Uoooo8@00
04;ooomS00009Oooo`800002oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool200001?oood800024
oooo8@0002Goool200000_ooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001
oooo0Oooo`000oooo`030000oooooooo00Coool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`001?ooo`030000oooooooo00?oool300000ooood800024oooo8@0002Coool3
00000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`15oooo8@00027ooomS
00009_ooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo0P0004KooolQ00008Oooof<0000Uoooo0P0000;oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool20000A_ooob40000QooooH`0002Goool200000_oo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo0P0008SooolQ00008Ooood800004oooo0P0000;oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`001?ooo`<00003
oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000Goool00`000?oo
ooooo`02oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000?oool4
00000oooo`<00027oooo8@00027ooom200000oooo`<00002oooo0003oooo00<0003oool000001?oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0004oooo0P0000Coool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`001Oooo`030000oooooooo
00;oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?oo
ob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo0P0002GooolQ0000@_oo
of<0000Uoooo0P0000;oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ
0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ
0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool200009Ooo
ob400012ooooH`0002Goool200000_ooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
08CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P00
08CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo0P0000Cooom2
0000Q?ooob40000Uoooo0P0000;oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`000oooo`800005oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003oooooool00ooood800024oooo8@00
02Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo0`0000?ooom20000Q?ooob40000T
oooo0`0000;oool000?oool200001Oooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@00
02Koool100000Oooo`7oool000?oool00`000?ooooooo`04oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`001?ooo`800004oooo00<0003oooooool0AOoo
ob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ
00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Ooo
ob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ
00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00
027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Q
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Ooo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool1
00000Oooo`7oool000[oool20000A_ooob40000Qoooo8@00027ooolQ00009Oooo`800002oooo000:
oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15
oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOoo
ob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ
00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Ooo
ob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ
00008Oooob40000Voooo0@00007oool1oooo000:oooo0P0004KooolQ00008Oooob40000Qoooo8@00
02Goool200000_ooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`800028ooooH`0002Goool200000_ooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`001?ooo`030000oooooooo00?oool00`000?ooooooo`27ooooH`0002Koool100000Oooo`7oool0
00?oool00`000?ooo`000004oooo00<0003oooooool0Qoooof<0000Voooo0@00007oool1oooo0003
oooo00<0003oool000001?ooo`<00027ooooH`0002Coool300000_ooo`001?ooo`030000oooooooo
00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`000oooo`030000oooo000000Coool0
0`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000oooooooo00?oool00`000?ooooooo`0=
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool00_ooo`400001oooo0Oooo`002_ooool0000E00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, 
  0.0303025}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
00ooool00`000?ooooooo`0noooo0`00043oool30000?_ooo`800011oooo00<0003oooooool01_oo
o`003_ooo`030000oooo000003ooool00`000?ooooooo`11oooo00<0003oooooool0?Oooo`030000
oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool00000@?ooo`030000oooooooo
03koool40000?_ooo`030000oooo000003ooool00`000?ooo`000007oooo000>oooo00<0003oool0
0000@?ooo`030000oooooooo03koool00`000?ooo`00000ooooo0P00047oool00`000?ooooooo`06
oooo000>oooo00<0003oool00000?oooo`030000oooo0000043oool20000?oooo`030000oooooooo
03ooool00`000?ooo`000007oooo000?oooo00<0003oooooool0?oooo`030000oooooooo043oool0
0`000?ooooooo`0noooo0P00043oool00`000?ooooooo`06oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000:ooooo`0001D00002oooo000:
oooo00<0003oooooool00oooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool0
0`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>
oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`02oooo0@00007oool1
oooo000:oooo00<0003oooooool00oooo`030000oooooooo03ooool00`000?ooooooo`0ooooo00<0
003oooooool0?oooo`030000oooooooo03ooool00`000?ooooooo`02oooo0@00007oool1oooo0004
oooo00<0003oooooool00oooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0
003oool000001?ooo`030000oooooooo0?oooolAoooo0@00007oool1oooo0003oooo00<0003oool0
00001?ooo`<0003ooooo3oooo`<00002oooo0003oooo00<0003oool000001?ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`030000
oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo0004oooo00<0003oooooool00ooo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@00
04;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool200009Oooob400012ooooH`00
02Goool200000_ooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
02CooolQ0000@_ooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012ooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooomS00009_ooo`400001oooo0Oooo`002_ooo`80000Uoooo8@00
04;ooomS00009Oooo`800002oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03
oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?oo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool200001?oood800024
oooo8@0002Goool200000_ooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo0003oooo0`0000Coool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001
oooo0Oooo`000oooo`030000oooooooo00Coool00`000?ooooooo`03oooo@P0008CooolQ00009_oo
o`400001oooo0Oooo`001?ooo`030000oooooooo00?oool300000ooood800024oooo8@0002Coool3
00000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`000oooo`030000oooo000000Coool00`000?ooooooo`15oooo8@00027ooomS
00009_ooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00
027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000V
oooo0@00007oool1oooo000:oooo0P0004KooolQ00008Oooof<0000Uoooo0P0000;oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooof<0000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000QooooH`0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooof<0000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Q
ooooH`0002Koool100000Oooo`7oool000[oool20000A_ooob40000QooooH`0002Goool200000_oo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool1
00000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0
003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27
oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooo
od800005oooo0@00007oool1oooo000:oooo0P0008SooolQ00008Ooood800004oooo0P0000;oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooolQ00008Ooood800005oooo0@00007oool1oooo000:oooo00<0003oooooool0Qooo
ob40000Qoooo@P0000Goool100000Oooo`7oool000[oool00`000?ooooooo`27oooo8@00027ooom2
00001Oooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooolQ00008Ooood800005oooo0@00
007oool1oooo000:oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool0
00[oool00`000?ooooooo`27oooo8@00027ooom200001Oooo`400001oooo0Oooo`001?ooo`<00003
oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000Goool00`000?oo
ooooo`02oooo00<0003oooooool0Qoooob40000Qoooo@P0000Goool100000Oooo`7oool000?oool4
00000oooo`<00027oooo8@00027ooom200000oooo`<00002oooo0003oooo00<0003oool000001?oo
o`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool100000Oooo`7oool000Coool2
00001?ooo`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool100000Oooo`7oool0
00Goool00`000?ooooooo`02oooo00<0003oooooool09?ooob400012oooo8@00027ooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooolQ00008Oooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012oooo8@00027ooolQ00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooolQ00008Oooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool09?ooob400012oooo8@00027ooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`0Toooo8@0004;ooolQ00008Oooob40000Voooo0@00007oool1oooo000:
oooo00<0003oooooool09?ooob400012oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`0Toooo8@0004;ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool09?ooob400012oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool200009Ooo
ob400012oooo8@00027ooolQ00009Oooo`800002oooo000:oooo00<0003oooooool09?ooob400012
oooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_oo
ob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooolQ
00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012oooo8@00
027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooob40000Q
oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooolQ00008Ooo
ob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012oooo8@00027ooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooolQ00008Oooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool09?ooob400012oooo8@00027ooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooolQ00008Oooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool09?ooob400012oooo8@00027ooolQ00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo02CooolQ0000@_ooob40000Qoooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`0Toooo8@0004;ooolQ00008Oooob40000Voooo0@00007oool1
oooo000:oooo0P0002GooolQ0000@_ooob40000Qoooo8@0002Goool200000_ooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooo
od800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00
007oool1oooo000:oooo0P0000Cooom20000Q?ooob40000Uoooo0P0000;oool000[oool00`000?oo
ooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
0000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo00?ooom2
0000Q?ooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool00ooood800024oooo8@00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`03oooo@P0008CooolQ00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo00?ooom20000Q?ooob40000Voooo0@00007oool1oooo000:
oooo00<0003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`03oooo@P0008CooolQ00009_ooo`400001oooo0Oooo`000oooo`800005oooo00<0003ooooo
ool00ooood800024oooo8@0002Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo00<0
003oooooool00ooood800024oooo8@0002Koool100000Oooo`7oool000?oool00`000?ooo`000004
oooo0`0000?ooom20000Q?ooob40000Toooo0`0000;oool000?oool200001Oooo`030000oooooooo
04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000?oool00`000?ooooooo`04
oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`001?oo
o`800004oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:
oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0
003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?oo
ooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003ooooo
ool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool00`000?ooooooo`15
oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo00<0003oooooool0AOoo
ob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ
00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool20000A_ooob40000Qoooo8@00
027ooolQ00009Oooo`800002oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@00
02Koool100000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000V
oooo0@00007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool1
00000Oooo`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00
007oool1oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Ooo
o`7oool000[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1
oooo000:oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool0
00[oool00`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:
oooo00<0003oooooool0AOooob40000Qoooo8@00027ooolQ00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo04GooolQ00008Oooob40000Qoooo8@0002Koool100000Oooo`7oool000[oool0
0`000?ooooooo`15oooo8@00027ooolQ00008Oooob40000Voooo0@00007oool1oooo000:oooo0P00
04KooolQ00008Oooob40000Qoooo8@0002Goool200000_ooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`800028
ooooH`0002Goool200000_ooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001
oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000
oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_oo
o`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_oo
o`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS
00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Ooo
o`002_ooo`030000oooooooo08OooomS00009_ooo`400001oooo0Oooo`002_ooo`030000oooooooo
08OooomS00009_ooo`400001oooo0Oooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`27
ooooH`0002Koool100000Oooo`7oool000?oool00`000?ooo`000004oooo00<0003oooooool0Qooo
of<0000Voooo0@00007oool1oooo0003oooo00<0003oool000001?ooo`<00027ooooH`0002Coool3
00000_ooo`001?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Ooo
o`000oooo`030000oooo000000Coool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`001?oo
o`030000oooooooo00?oool00`000?ooooooo`3ooooo4Oooo`400001oooo0Oooo`002_ooo`030000
oooooooo00?oool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000oooooooo00goool0
0`000?ooooooo`0>oooo00<0003oooooool03Oooo`030000oooooooo00koool00`000?ooooooo`0=
oooo00<0003oooooool03_ooo`030000oooooooo00goool00`000?ooooooo`0>oooo00<0003ooooo
ool03Oooo`030000oooooooo00koool00`000?ooooooo`0=oooo00<0003oooooool03_ooo`030000
oooooooo00goool00`000?ooooooo`0>oooo00<0003oooooool00_ooo`400001oooo0Oooo`002_oo
ool0000E00000_ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.489418, -0.536766, 0.0303025, 
  0.0303025}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FF00FFFF000000FF
0000FFFFFFFF00FF
FFFF00FF000000FF
FFFFFFFF00FF0000
FF00FFFF00FF00FF
0000FFFFFFFF00FF
FFFF00FF00FF00FF
FFFFFFFF000000FF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{417.313, 198.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006Q0000aQP00`40o`000?l0003ooooooj;oool0
0?oooonRoooo003oooooX_ooo`00oooooj;oool00?oooonRoooo003oooooX_ooo`005oooo`030000
oooooooo02Koool30000:Oooo`<0000Voooo0P0002Woool00`000?ooooooo`0Soooo00<0003ooooo
ool09_ooo`<0000Yoooo0`0002Koool20000:Oooo`030000oooooooo00ooool001Koool00`000?oo
o`00000Woooo00<0003oooooool0:_ooo`030000oooooooo02Goool00`000?ooo`00000Woooo00<0
003oool000008oooo`030000oooo000002Ooool00`000?ooooooo`0Zoooo00<0003oooooool09Ooo
o`030000oooo000002Ooool00`000?ooo`00000@oooo000Foooo00<0003oool00000:?ooo`030000
oooooooo02Ooool400009_ooo`030000oooo000002Ooool00`000?ooo`00000Soooo00<0003oool0
0000:?ooo`030000oooooooo02Ooool400009_ooo`030000oooo000002Ooool00`000?ooo`00000@
oooo000Foooo00<0003oool00000:?ooo`030000oooooooo02Ooool00`000?ooo`00000Woooo0P00
02Woool00`000?ooooooo`0Roooo00<0003oool00000:?ooo`030000oooooooo02Ooool00`000?oo
o`00000Woooo0P0002Woool00`000?ooooooo`0?oooo000Foooo00<0003oool000009oooo`030000
oooo000002Woool200009oooo`030000oooooooo02Ooool00`000?ooo`00000Soooo00<0003oool0
00009oooo`030000oooo000002Woool200009oooo`030000oooooooo02Ooool00`000?ooo`00000@
oooo000Goooo00<0003oooooool09oooo`030000oooooooo02Woool00`000?ooooooo`0Voooo0P00
02Soool00`000?ooooooo`0Soooo00<0003oooooool09oooo`030000oooooooo02Woool00`000?oo
ooooo`0Voooo0P0002Soool00`000?ooooooo`0?oooo003oooooX_ooo`00oooooj;oool00?oooonR
oooo003oooooX_ooo`005?oook40000Noooo/@0000goool000ooool00`000?ooooooo`02oooo00D0
003oooooooooool00000:Oooo`030000oooooooo02Ooool00`000?ooooooo`0Woooo00<0003ooooo
ool0:?ooo`040000oooooooo00006Oooo`030000oooooooo00;oool01@000?ooooooooooo`00000Y
oooo00<0003oooooool09oooo`030000oooooooo02Soool00`000?ooooooo`0Woooo00@0003ooooo
ool0000=oooo000>oooo00<0003oool000000oooo`030000oooooooo0:goool00`000?ooooooo`0F
oooo00<0003oool000000oooo`030000oooooooo0:goool00`000?ooooooo`0;oooo000>oooo00<0
003oool000000oooo`80002]oooo0P0001Soool00`000?ooo`000003oooo0P000:goool200003Ooo
o`003_ooo`030000oooo000000?oool00`000?ooooooo`0Foooo5@0002_ooolo00006?ooo`030000
oooooooo01Koool00`000?ooo`000003oooo00<0003oooooool05_oooaD0000[oooo?`0001Soool0
0`000?ooooooo`0;oooo000>oooo00<0003oool000000oooo`030000oooooooo01KooolE0000:ooo
ocl0000Hoooo00<0003oooooool05_ooo`030000oooo000000?oool00`000?ooooooo`0Foooo5@00
02_ooolo00006?ooo`030000oooooooo00_oool000ooool00`000?ooooooo`02oooo00<0003ooooo
ool05_oooaD0000[oooo?`0001Soool00`000?ooooooo`0Goooo00<0003oooooool00_ooo`030000
oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo
01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:ooo
ocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000H
oooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003ooooo
ool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?oo
o`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000
oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE
0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:ooo
ocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0
003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003ooooo
ool07?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?oo
o`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo
01KooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`80000Goooo5@0002_ooolo
00005oooo`80000Noooo0P0001OooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?oo
o`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo
01KooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo01KooolE
0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:oooocl0000H
oooo00<0003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0
003oooooool07?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool02ooo
o`005?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000
oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo
01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:ooo
ocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000H
oooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003ooooo
ool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?oo
o`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000
oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE
0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:ooo
ocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0
003oooooool02oooo`005?ooo`80000Goooo5@0002_ooolo00005oooo`80000Noooo0P0001OooolE
0000:oooocl0000Hoooo00<0003oooooool02oooo`005?ooo`040000oooooooooooo:P0005GooolE
00006?ooo`030000oooooooo01coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?oo
ooooo`0;oooo000Doooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?oo
o`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo00_oool001Coool010000?oo
ooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0Loooo00@0003ooooooooooolZ0000EOoo
oaD0000Hoooo00<0003oooooool02oooo`005?ooo`040000oooooooooooo:P0005GooolE00006?oo
o`030000oooooooo01coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;
oooo000Doooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000
oooooooooooo:P0005GooolE00006?ooo`030000oooooooo00_oool001Coool010000?oooooooooo
obX0001Eoooo5@0001Soool00`000?ooooooo`0Loooo00@0003ooooooooooolZ0000EOoooaD0000H
oooo00<0003oooooool02oooo`005?ooo`040000oooooooooooo:P0005GooolE00006?ooo`030000
oooooooo01coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000D
oooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000oooooooo
oooo:P0005GooolE00006?ooo`030000oooooooo00_oool001Coool010000?ooooooooooobX0001E
oooo5@0001Soool00`000?ooooooo`0Loooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0
003oooooool02oooo`005?ooo`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo
01coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo0P00
00;ooolZ0000EOoooaD0000Goooo0P0001koool200000_ooobX0001Eoooo5@0001Soool00`000?oo
ooooo`0;oooo000Doooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?oo
o`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo00_oool001Coool010000?oo
ooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0Loooo00@0003ooooooooooolZ0000EOoo
oaD0000Hoooo00<0003oooooool02oooo`005?ooo`040000oooooooooooo:P0005GooolE00006?oo
o`030000oooooooo01coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;
oooo000Doooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000
oooooooooooo:P0005GooolE00006?ooo`030000oooooooo00_oool001Coool010000?oooooooooo
obX0001Eoooo5@0001Soool00`000?ooooooo`0Loooo00@0003ooooooooooolZ0000EOoooaD0000H
oooo00<0003oooooool02oooo`005?ooo`040000oooooooooooo:P0005GooolE00006?ooo`030000
oooooooo01coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000D
oooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000oooooooo
oooo:P0005GooolE00006?ooo`030000oooooooo00_oool000koool300000oooo`040000oooooooo
oooo:P0005GooolE00006?ooo`030000oooooooo01Koool300000oooo`040000oooooooooooo:P00
05GooolE00006?ooo`030000oooooooo00_oool000koool00`000?ooooooo`03oooo00@0003ooooo
oooooolZ0000EOoooaD0000Hoooo00<0003oooooool05_ooo`030000oooooooo00?oool010000?oo
ooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000?oooo00<0003oooooool00_oo
o`800002oooo:P0005GooolE00005oooo`80000Ioooo00<0003oooooool00_ooo`800002oooo:P00
05GooolE00005oooo`80000=oooo000?oooo00<0003oooooool00_ooo`030000oooooooo02_ooolE
00005_ooocl0000Hoooo00<0003oooooool05oooo`030000oooooooo00;oool00`000?ooooooo`0[
oooo5@0001Kooolo00006?ooo`030000oooooooo00_oool000koool00`000?ooo`000003oooo00<0
003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Foooo00<0003oool000000ooo
o`030000oooooooo02_ooolE00005_ooocl0000Hoooo00<0003oooooool02oooo`003oooo`030000
oooooooo00;oool00`000?ooooooo`0[oooo5@0001Kooolo00006?ooo`030000oooooooo01Ooool0
0`000?ooooooo`02oooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;
oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0
003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003ooooo
ool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000F
oooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`00
01Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?oo
ooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0L
oooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0
003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooo
oaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000F
oooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool0
0`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?oo
ooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000D
oooo0P0002cooolE00005_ooocl0000Goooo0P0001koool20000;?oooaD0000Foooo?`0001Soool0
0`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?oo
ooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000D
oooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0003ooooo
ool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooo
oaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`00
01Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool0
0`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;
oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0
003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003ooooo
ool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000F
oooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`00
01Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?oo
ooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0L
oooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0
003oooooool0:ooooaD0000Foooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooo
oaD0000Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000F
oooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo?`0001Soool0
0`000?ooooooo`0;oooo000Doooo0P0005OooolE00005OooobX00002oooo0P0001koool20000Eooo
oaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000E
oooo:P0000?oool00`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool0
0`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?oo
ooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000D
oooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0003ooooo
ool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oo
oaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P00
00?oool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool0
0`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;
oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0
003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000Doooo00<0003ooooo
ool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000E
oooo:P0000?oool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P00
00?oool00`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?oo
ooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0L
oooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000Doooo0P00
05OooolE00005OooobX00002oooo0P0001koool20000EooooaD0000Eoooo:P0000?oool00`000?oo
ooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0L
oooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000Doooo00<0
003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0003oooooool0E_oo
oaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000E
oooo:P0000?oool00`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool0
0`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?oo
ooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000D
oooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0003ooooo
ool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oo
oaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P00
00?oool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool0
0`000?ooooooo`0Loooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;
oooo000Doooo00<0003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0Loooo00<0
003oooooool0E_oooaD0000Eoooo:P0000?oool00`000?ooooooo`0;oooo000?oooo0`0000;oool0
0`000?ooooooo`1Foooo5@0001GooolZ00000oooo`030000oooooooo01Ooool300000_ooo`030000
oooooooo05KooolE00005OooobX00003oooo00<0003oooooool02oooo`004?ooo`050000oooooooo
oooo000005SooolE00005OooobX00003oooo00<0003oooooool06?ooo`050000oooooooooooo0000
05SooolE00005OooobX00003oooo00<0003oooooool02oooo`003_ooo`@00002oooo0P0005OooolE
00005OooobX00002oooo0P0001Soool400000_ooo`80001Goooo5@0001GooolZ00000_ooo`80000=
oooo000>oooo00<0003oool000000oooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0
003oooooool05_ooo`030000oooo000000?oool00`000?ooooooo`0Foooo5@0002_ooolE00005Ooo
oaD0000Hoooo00<0003oooooool02oooo`003oooo`800003oooo00<0003oooooool05_oooaD0000[
oooo?`0001Soool00`000?ooooooo`0Goooo0P0000?oool00`000?ooooooo`0Foooo5@0002_ooolE
00005OoooaD0000Hoooo00<0003oooooool02oooo`004?ooo`050000oooooooooooo000001SooolE
0000:oooocl0000Hoooo00<0003oooooool06?ooo`050000oooooooooooo000001SooolE0000:ooo
oaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool05_oooaD0000[
oooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool05_oooaD0000[oooo5@0001GooolE
00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`0Foooo5@0002_ooolo00006?oo
o`030000oooooooo01coool00`000?ooooooo`0Foooo5@0002_ooolE00005OoooaD0000Hoooo00<0
003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0003ooooo
ool07?ooo`030000oooooooo01KooolE0000:ooooaD0000Eoooo5@0001Soool00`000?ooooooo`0;
oooo000Doooo00<0003oooooool05_oooaD0000[oooo?`0001Soool00`000?ooooooo`0Loooo00<0
003oooooool05_oooaD0000[oooo5@0001GooolE00006?ooo`030000oooooooo00_oool001Coool0
0`000?ooooooo`0Foooo5@0002_ooolo00006?ooo`030000oooooooo01coool00`000?ooooooo`0F
oooo5@0002_ooolE00005OoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo
01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE0000:ooo
oaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo0P0001OooolE0000:oooocl0000G
oooo0P0001koool200005ooooaD0000[oooo5@0001GooolE00006?ooo`030000oooooooo00_oool0
01Coool00`000?ooooooo`0Foooo5@0002_ooolo00006?ooo`030000oooooooo01coool00`000?oo
ooooo`0Foooo5@0002_ooolE00005OoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000
oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE
0000:ooooaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool05_oo
oaD0000[oooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool05_oooaD0000[oooo5@00
01GooolE00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`0Foooo5@0002_ooolo
00006?ooo`030000oooooooo01coool00`000?ooooooo`0Foooo5@0002_ooolE00005OoooaD0000H
oooo00<0003oooooool02oooo`005?ooo`030000oooooooo01KooolE0000:oooocl0000Hoooo00<0
003oooooool07?ooo`030000oooooooo01KooolE0000:ooooaD0000Eoooo5@0001Soool00`000?oo
ooooo`0;oooo000Doooo00<0003oooooool05_oooaD0000[oooo?`0001Soool00`000?ooooooo`0L
oooo00<0003oooooool05_oooaD0000[oooo5@0001GooolE00006?ooo`030000oooooooo00_oool0
01Coool00`000?ooooooo`0Foooo5@0002_ooolo00006?ooo`030000oooooooo01coool00`000?oo
ooooo`0Foooo5@0002_ooolE00005OoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000
oooooooo01KooolE0000:oooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo01KooolE
0000:ooooaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool05_oo
oaD0000[oooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool05_oooaD0000[oooo5@00
01GooolE00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`0Foooo5@0002_ooolo
00006?ooo`030000oooooooo01coool00`000?ooooooo`0Foooo5@0002_ooolE00005OoooaD0000H
oooo00<0003oooooool02oooo`005?ooo`80000Goooo5@0002_ooolo00005oooo`80000Noooo0P00
01OooolE0000:ooooaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00@0003ooooo
oooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000oooooooooooo:P0005GooolE
00006?ooo`030000oooooooo00_oool001Coool010000?ooooooooooobX0001Eoooo5@0001Soool0
0`000?ooooooo`0Loooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool02ooo
o`005?ooo`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo01coool010000?oo
ooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00@0003ooooooooooolZ
0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000oooooooooooo:P0005GooolE00006?oo
o`030000oooooooo00_oool001Coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?oo
ooooo`0Loooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool02oooo`005?oo
o`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo01coool010000?oooooooooo
obX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00@0003ooooooooooolZ0000EOoo
oaD0000Hoooo00<0003oooooool07?ooo`040000oooooooooooo:P0005GooolE00006?ooo`030000
oooooooo00_oool001Coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0L
oooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`040000
oooooooooooo:P0005GooolE00006?ooo`030000oooooooo01coool010000?ooooooooooobX0001E
oooo5@0001Soool00`000?ooooooo`0;oooo000Doooo0P0000;ooolZ0000EOoooaD0000Goooo0P00
01koool200000_ooobX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00@0003ooooo
oooooolZ0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000oooooooooooo:P0005GooolE
00006?ooo`030000oooooooo00_oool001Coool010000?ooooooooooobX0001Eoooo5@0001Soool0
0`000?ooooooo`0Loooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool02ooo
o`005?ooo`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo01coool010000?oo
ooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00@0003ooooooooooolZ
0000EOoooaD0000Hoooo00<0003oooooool07?ooo`040000oooooooooooo:P0005GooolE00006?oo
o`030000oooooooo00_oool001Coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?oo
ooooo`0Loooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool02oooo`005?oo
o`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo01coool010000?oooooooooo
obX0001Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00@0003ooooooooooolZ0000EOoo
oaD0000Hoooo00<0003oooooool07?ooo`040000oooooooooooo:P0005GooolE00006?ooo`030000
oooooooo00_oool001Coool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0L
oooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool02oooo`003_ooo`800004
oooo00@0003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool05_ooo`800004oooo00@0
003ooooooooooolZ0000EOoooaD0000Hoooo00<0003oooooool02oooo`003_ooo`030000oooo0000
00?oool010000?ooooooooooobX0001Eoooo5@0001Soool00`000?ooooooo`0Foooo00<0003oool0
00000oooo`040000oooooooooooo:P0005GooolE00006?ooo`030000oooooooo00_oool000koool0
0`000?ooo`000003oooo0P0000;ooolZ0000EOoooaD0000Goooo0P0001Soool00`000?ooo`000003
oooo0P0000;ooolZ0000EOoooaD0000Goooo0P0000goool000koool200001?ooo`030000oooooooo
02_ooolE00005_oooaD0000Eoooo5@0001Soool00`000?ooooooo`0Foooo0P0000Coool00`000?oo
ooooo`0[oooo5@0001KooolE00005OoooaD0000Hoooo00<0003oooooool02oooo`003_ooo`030000
oooooooo00?oool00`000?ooooooo`0[oooo5@0001KooolE00005OoooaD0000Hoooo00<0003ooooo
ool05_ooo`030000oooooooo00?oool00`000?ooooooo`0[oooo5@0001KooolE00005OoooaD0000H
oooo00<0003oooooool02oooo`003oooo`800003oooo00<0003oooooool0:ooooaD0000Foooo5@00
01GooolE00006?ooo`030000oooooooo01Ooool200000oooo`030000oooooooo02_ooolE00005_oo
oaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000F
oooo5@0001GooolE00006?ooo`030000oooooooo01coool00`000?ooooooo`0[oooo5@0001KooolE
00005OoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo02_ooolE00005_oo
oaD0000Eoooo5@0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo5@00
01GooolE00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`0[oooo5@0001KooolE
00005OoooaD0000Hoooo00<0003oooooool07?ooo`030000oooooooo02_ooolE00005_oooaD0000E
oooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo5@00
01GooolE00006?ooo`030000oooooooo01coool00`000?ooooooo`0[oooo5@0001KooolE00005Ooo
oaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo02_ooolE00005_oooaD0000E
oooo5@0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000Foooo5@0001GooolE
00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`0[oooo5@0001KooolE00005Ooo
oaD0000Hoooo00<0003oooooool07?ooo`030000oooooooo02_ooolE00005_oooaD0000Eoooo5@00
01Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooooaD0000Foooo5@0001GooolE
00006?ooo`030000oooooooo01coool00`000?ooooooo`0[oooo5@0001KooolE00005OoooaD0000H
oooo00<0003oooooool02oooo`005?ooo`80000/oooo5@0001KooolE00005OoooaD0000Goooo0P00
01koool20000;?oooaD0000Foooo5@0001GooolE00006?ooo`030000oooooooo00_oool001Coool0
0`000?ooooooo`0[oooo5@0001KooolE00005OoooaD0000Hoooo00<0003oooooool07?ooo`030000
oooooooo02_ooolE00005_oooaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0
003oooooool0:ooooaD0000Foooo5@0001GooolE00006?ooo`030000oooooooo01coool00`000?oo
ooooo`0[oooo5@0001KooolE00005OoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000
oooooooo02_ooolE00005_oooaD0000Eoooo5@0001Soool00`000?ooooooo`0Loooo00<0003ooooo
ool0:ooooaD0000Foooo5@0001GooolE00006?ooo`030000oooooooo00_oool001Coool00`000?oo
ooooo`0[oooo5@0001KooolE00005OoooaD0000Hoooo00<0003oooooool07?ooo`030000oooooooo
02_ooolE00005_oooaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0003ooooo
ool0:ooooaD0000Foooo5@0001GooolE00006?ooo`030000oooooooo01coool00`000?ooooooo`0[
oooo5@0001KooolE00005OoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo
02_ooolE00005_oooaD0000Eoooo5@0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooo
oaD0000Foooo5@0001GooolE00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`0[
oooo5@0001KooolE00005OoooaD0000Hoooo00<0003oooooool07?ooo`030000oooooooo02_ooolE
00005_oooaD0000Eoooo5@0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0:ooo
oaD0000Foooo5@0001GooolE00006?ooo`030000oooooooo01coool00`000?ooooooo`0[oooo5@00
01KooolE00005OoooaD0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo02_ooolE
00005_oooaD0000Eoooo5@0001Soool00`000?ooooooo`0Loooo00<0003oooooool0:ooooaD0000F
oooo5@0001GooolE00006?ooo`030000oooooooo00_oool001Coool20000;?oooaD0000Foooo5@00
01GooolE00005oooo`80000Noooo0P0002cooolE00005_oooaD0000Eoooo5@0001Soool00`000?oo
ooooo`0;oooo000Doooo00<0003oooooool0E_ooocl0000Hoooo00<0003oooooool07?ooo`030000
oooooooo05Kooolo00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`1Foooo?`00
01Soool00`000?ooooooo`0Loooo00<0003oooooool0E_ooocl0000Hoooo00<0003oooooool02ooo
o`005?ooo`030000oooooooo05Kooolo00006?ooo`030000oooooooo01coool00`000?ooooooo`1F
oooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_ooocl0000Hoooo00<0
003oooooool07?ooo`030000oooooooo05Kooolo00006?ooo`030000oooooooo00_oool001Coool0
0`000?ooooooo`1Foooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0E_ooocl0000H
oooo00<0003oooooool02oooo`005?ooo`030000oooooooo05Kooolo00006?ooo`030000oooooooo
01coool00`000?ooooooo`1Foooo?`0001Soool00`000?ooooooo`0;oooo000Doooo00<0003ooooo
ool0E_ooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo05Kooolo00006?ooo`030000
oooooooo00_oool001Coool00`000?ooooooo`1Foooo?`0001Soool00`000?ooooooo`0Loooo00<0
003oooooool0E_ooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo05Kooolo
00006?ooo`030000oooooooo01coool00`000?ooooooo`1Foooo?`0001Soool00`000?ooooooo`0;
oooo000Doooo00<0003oooooool0E_ooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo
05Kooolo00006?ooo`030000oooooooo00_oool001Coool20000Eoooocl0000Goooo0P0001koool2
0000Eoooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000oooooooo05Kooolo00006?oo
o`030000oooooooo01coool00`000?ooooooo`1Foooo?`0001Soool00`000?ooooooo`0;oooo000D
oooo00<0003oooooool0E_ooocl0000Hoooo00<0003oooooool07?ooo`030000oooooooo05Kooolo
00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`1Foooo?`0001Soool00`000?oo
ooooo`0Loooo00<0003oooooool0E_ooocl0000Hoooo00<0003oooooool02oooo`005?ooo`030000
oooooooo05Kooolo00006?ooo`030000oooooooo01coool00`000?ooooooo`1Foooo?`0001Soool0
0`000?ooooooo`0;oooo000Doooo00<0003oooooool0E_ooocl0000Hoooo00<0003oooooool07?oo
o`030000oooooooo05Kooolo00006?ooo`030000oooooooo00_oool001Coool00`000?ooooooo`1F
oooo?`0001Soool00`000?ooooooo`0Loooo00<0003oooooool0E_ooocl0000Hoooo00<0003ooooo
ool02oooo`005?ooo`030000oooooooo05Kooolo00006?ooo`030000oooooooo01coool00`000?oo
ooooo`1Foooo?`0001Soool00`000?ooooooo`0;oooo000?oooo00<0003oooooool00_ooo`030000
oooooooo05Kooolo00006?ooo`030000oooooooo01Ooool00`000?ooooooo`02oooo00<0003ooooo
ool0E_ooocl0000Hoooo00<0003oooooool02oooo`003_ooo`030000oooo000000?oool00`000?oo
ooooo`1Foooo?`0001Soool00`000?ooooooo`0Foooo00<0003oool000000oooo`030000oooooooo
05Kooolo00006?ooo`030000oooooooo00_oool000koool00`000?ooo`000003oooo0P0005Oooolo
00005oooo`80000Hoooo00<0003oool000000oooo`80001Goooo?`0001Ooool200003Oooo`003ooo
o`030000oooooooo00;oool00`000?ooooooo`2]oooo00<0003oooooool05oooo`030000oooooooo
00;oool00`000?ooooooo`2]oooo00<0003oooooool02oooo`003_ooo`030000oooo000000?oool0
0`000?ooooooo`2]oooo00<0003oooooool05_ooo`030000oooo000000?oool00`000?ooooooo`2]
oooo00<0003oooooool02oooo`003oooo`030000oooooooo00;oool01@000?ooooooooooo`000009
oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003ooooo
ool01oooo`030000oooooooo00Soool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000
oooooooo00Soool00`000?ooooooo`07oooo00<0003oooooool02?ooo`030000oooooooo00Ooool0
0`000?ooooooo`08oooo00<0003oooooool02?ooo`030000oooooooo00Ooool00`000?ooooooo`08
oooo00@0003oooooool0000Ioooo00<0003oooooool00_ooo`050000oooooooooooo000000Woool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`08
oooo00<0003oooooool01oooo`030000oooooooo00Soool00`000?ooooooo`07oooo00<0003ooooo
ool02?ooo`030000oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool02?ooo`030000
oooooooo00Ooool00`000?ooooooo`08oooo00<0003oooooool01oooo`030000oooooooo00Soool0
10000?ooooooo`0000goool001Cooona00007_oook40000=oooo003oooooX_ooo`00oooooj;oool0
0?oooonRoooo003oooooX_ooo`00oooooj;oool00001\
\>"],
  ImageRangeCache->{{{0, 416.313}, {197.688, 0}} -> {-0.0529655, -0.0238146, 
  0.00505854, 0.00505854}, {{10.4375, 198.688}, {192.938, 
  4.6875}} -> {-1.13578, -0.914294, 0.047291, 0.047291}, {{217.563, 
  405.813}, {192.938, 4.6875}} -> {-10.9309, -0.914294, 0.047291, 0.047291}}]
}, Closed]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Discrete",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
imageNormalize=Compile[{{data2D,_Real,2}},
\t\tModule[{minimum=Min[data2D]},
\t\t\t(data2D-minimum)/Max[data2D-minimum]]];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\(fd = Fourier[d]; \)\)], "Input"],

Cell["\<\
filterMatrix=imageNormalize[Abs[fd]]-imageNormalize[Abs[fa]];\
\>", "Input",
  FormatType->InputForm],

Cell["defectSpect=filterMatrix fd;", "Input",
  FormatType->InputForm],

Cell["defectPosition=imageNormalize[InverseFourier[defectSpect]];", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Identified) show
129.000000 13.000000 moveto
(Defect) show
165.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000FF0000
0000000000000000
0000000000000000
0000000000FF0000
0000000000FF0000
0000000000FF0000
0000000000000000
0000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01Ooool00`000?ooooooo`0joooo0`0003coool30000>_ooo`80000moooo00<0003oooooool03_oo
o`005_ooo`030000oooo000003_oool00`000?ooooooo`0moooo00<0003oooooool0>Oooo`030000
oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool00000??ooo`030000oooooooo
03[oool40000>_ooo`030000oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool0
0000??ooo`030000oooooooo03[oool00`000?ooo`00000koooo0P0003goool00`000?ooooooo`0>
oooo000Foooo00<0003oool00000>oooo`030000oooo000003coool20000>oooo`030000oooooooo
03_oool00`000?ooo`00000?oooo000Goooo00<0003oooooool0>oooo`030000oooooooo03coool0
0`000?ooooooo`0joooo0P0003coool00`000?ooooooo`0>oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000Booooo`0000D0000:oooo000B
oooo00<0003oooooool00_ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`02oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`003?ooo`030000
oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool000_oool00`000?oo
o`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000;oooo00<0003oool0
00001?ooo`<0003noooo0`0000[oool000_oool00`000?ooo`000004oooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000
oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo
00?oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW000
01ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool200000ooo
oi`0000Ooooo?P0000Coool200002_ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL
00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_oo
o`800003ooooW00001ooooln00001?ooo`80000:oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool200000oooooT00004oooo0P0000[oool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000;oooo0`0000Coool0
0`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000;oooo00<0003oooooool01?oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool000coool00`000?ooooooo`03
oooo0`0000;ooooi00000oooo`<0000:oooo000<oooo00<0003oooooool00oooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool000_oool00`000?ooo`000004oooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo00?oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool200000oooooT00004oooo0P0000[oool001;oool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool200000oooooT00004oooo0P0000[oool001;oool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW000
01ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool200000ooooi`0000Ooooo?P0000Coool200002_ooo`004_ooo`030000oooooooo00;ooonL
00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL
00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`003?ooo`<00003oooo00<0003oooooool00_oooi`0000O
oooo?P0000Goool00`000?ooooooo`08oooo000=oooo00<0003oooooool00_ooo`030000oooooooo
00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`002oooo`@00003oooo0`0000;ooonL
00007ooooch00003oooo0`0000[oool000_oool00`000?ooo`000004oooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000<oooo0P0000Coool00`000?ooooooo`02
ooooW00001ooooln00001Oooo`030000oooooooo00Soool000goool00`000?ooooooo`02oooo00<0
003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000O
oooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo0P0000?ooonL00007ooooch00004
oooo0P0000[oool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW000
01ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool200000ooo
oi`0000Ooooo?P0000Coool200002_ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL
00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_oo
o`800003ooooW00001ooooln00001?ooo`80000:oooo000Boooo00<0003oooooool00_oooi`0000O
oooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000O
oooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P00
00Goool00`000?ooooooo`08oooo000;oooo0P0000Goool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool000_oool00`000?ooo`000004oooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`<00002
ooooW00001ooooln00000oooo`<0000:oooo000;oooo0P0000Goool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000;oooo00<0003oooooool01?ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool000coool200001?ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool001;oool200000oooooT00004oooo0P0000[oool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`800003oooon@00
00Coool200002_ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`800003oooon@00
00Coool200002_ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`003?ooo`030000oooooooo00?oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool000_oool00`000?ooo`000004oooo0`0000;ooooi
00000oooo`<0000:oooo000<oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0
003oooooool02?ooo`002oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00Soool000coool00`000?ooooooo`03oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooo`030000oooooooo00goool00`000?ooooooo`0<
oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003ooooo
ool03?ooo`030000oooooooo00goool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`02
oooo00<0003oooooool02?ooo`004_ooool0000500002_ooo`00ooooob7oool00?oooolQoooo003o
oooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool006;oool300000ooo
o`<00002oooo0P000003oooo0000000000;oool00`000?ooooooo`0200000_ooo`<00002oooo0`00
00;oool300000oooo`800003oooo0`00013oool400000oooo`800002oooo0`0000?oool200000_oo
o`<00003oooo0P00063oool006?oool01@000?ooooooooooo`000002oooo00<0003oool000001?oo
o`060000oooooooo0000oooo00000_ooo`040000oooooooo00001?ooo`030000oooooooo00;oool0
1@000?ooooooooooo`000004oooo00@0003oooooool0000Aoooo00H0003oooooool0003oool00005
oooo00D0003oooooooooool000001?ooo`030000oooooooo00;oool010000?ooooooo`0005ooool0
06?oool01@000?ooooooooooo`000002oooo00<0003oool000000P0000;oool01P000?ooooooo`00
0?ooo`0000Goool00`000?ooooooo`02oooo00<0003oooooool00_ooo`040000oooooooooooo0`00
00;oool010000?ooooooo`00017oool01@000?ooooooo`000?ooo`0300000oooo`040000oooooooo
oooo0`0000;oool00`000?ooooooo`02oooo00<0003oooooool0H?ooo`00Hoooo`030000oooooooo
00;oool3000000Goool000000000003oool010000003oooo0000000000800002oooo0P0000?oool3
00000_ooo`800003oooo0`0000?oool300004Oooo`050000oooooooo0000oooo00<00002oooo0`00
00;oool300000_ooo`<000000oooo`00000000020000H?ooo`00Hoooo`030000oooooooo00Coool0
0`000?ooooooo`09oooo00<0003oooooool02?ooo`030000oooooooo00koool00`000?ooooooo`0?
oooo00@0003oooooool00007oooo00<0003oooooool02oooo`030000oooooooo063oool006;oool3
00001?ooo`80000Aoooo00<0003oooooool00oooo`050000oooooooooooo000000[oool200004?oo
o`@00009oooo00<0003oooooool0KOooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.762352, -0.553541, 0.0321664, 
  0.0321664}}]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wd = waveletMatrix[8, coif6] . d; \)\)], "Input"],

Cell["filterMatrix=imageNormalize[wd]-imageNormalize[wa];", "Input",
  FormatType->InputForm],

Cell["defectSpect=filterMatrix wd;", "Input",
  FormatType->InputForm],

Cell["\<\
defectPosition=imageNormalize[Transpose[waveletMatrix[8,coif6]].defectSpect];\
\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.120192 0.0192308 0.120192 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.25962 -0.0125 -3 -9 ]
[.25962 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -6 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(2)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(4)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(6)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(8)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.07933 0 m
.07933 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.31971 0 m
.31971 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.92067 0 m
.92067 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(2)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(4)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(6)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(8)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .07933 m
.00375 .07933 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .31971 m
.00375 .31971 L
s
0 .37981 m
.00375 .37981 L
s
0 .4399 m
.00375 .4399 L
s
0 .5601 m
.00375 .5601 L
s
0 .62019 m
.00375 .62019 L
s
0 .68029 m
.00375 .68029 L
s
0 .80048 m
.00375 .80048 L
s
0 .86058 m
.00375 .86058 L
s
0 .92067 m
.00375 .92067 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.07933 .99625 m
.07933 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.31971 .99625 m
.31971 1 L
s
.37981 .99625 m
.37981 1 L
s
.4399 .99625 m
.4399 1 L
s
.5601 .99625 m
.5601 1 L
s
.62019 .99625 m
.62019 1 L
s
.68029 .99625 m
.68029 1 L
s
.80048 .99625 m
.80048 1 L
s
.86058 .99625 m
.86058 1 L
s
.92067 .99625 m
.92067 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .07933 m
1 .07933 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .31971 m
1 .31971 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .92067 m
1 .92067 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Identified) show
129.000000 13.000000 moveto
(Defect) show
165.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
8 string
8 8 8 [8 0 0 8 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000000000000000
0000000000000000
0000000000000000
0000000000FF0000
0000000000FF0000
0000000000FF0000
0000000000000000
0000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01Ooool00`000?ooooooo`0joooo0`0003coool30000>_ooo`80000moooo00<0003oooooool03_oo
o`005_ooo`030000oooo000003_oool00`000?ooooooo`0moooo00<0003oooooool0>Oooo`030000
oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool00000??ooo`030000oooooooo
03[oool40000>_ooo`030000oooo000003_oool00`000?ooo`00000?oooo000Foooo00<0003oool0
0000??ooo`030000oooooooo03[oool00`000?ooo`00000koooo0P0003goool00`000?ooooooo`0>
oooo000Foooo00<0003oool00000>oooo`030000oooo000003coool20000>oooo`030000oooooooo
03_oool00`000?ooo`00000?oooo000Goooo00<0003oooooool0>oooo`030000oooooooo03coool0
0`000?ooooooo`0joooo0P0003coool00`000?ooooooo`0>oooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo000Booooo`0000D0000:oooo000B
oooo00<0003oooooool00_ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000oooooooo00goool0
0`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`02oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo0?ooool1oooo00<0003oooooool02?ooo`003?ooo`030000
oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00Soool000_oool00`000?oo
o`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08oooo000;oooo00<0003oool0
00001?ooo`<0003noooo0`0000[oool000_oool00`000?ooo`000004oooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`002oooo`030000oooo000000Coool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000<oooo00<0003oooooool00oooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`800003oooon@0000Coool200002_ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`800003oooon@0000Coool200002_ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo0P0000?ooooi00001?ooo`80000:oooo000Boooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`002oooo`<00004oooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`002oooo`030000oooooooo00Coool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000<oooo00<0003oooooool00oooo`<00002
oooon@0000?oool300002_ooo`003?ooo`030000oooooooo00?oool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool000coool00`000?ooooooo`03oooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo0P00
00?ooooi00001?ooo`80000:oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
ooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo0P00
00?ooooi00001?ooo`80000:oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000O
oooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo0P00
00?ooonL00007ooooch00004oooo0P0000[oool001;oool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW000
01ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Ooo
o`030000oooooooo00Soool000coool300000oooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`003Oooo`030000oooooooo00;oool00`000?ooooooo`02ooooW000
01ooooln00001Oooo`030000oooooooo00Soool000_oool400000oooo`<00002ooooW00001ooooln
00000oooo`<0000:oooo000;oooo00<0003oool000001?ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`003?ooo`800004oooo00<0003oooooool00_oooi`0000O
oooo?P0000Goool00`000?ooooooo`08oooo000=oooo00<0003oooooool00_ooo`030000oooooooo
00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL
00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL
00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`004_ooo`800003ooooW00001ooooln00001?ooo`80000:
oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oo
oi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000O
oooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P00
00Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool0
0`000?ooooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000B
oooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_oooi`0000Ooooo?P0000Goool00`000?ooooooo`08oooo000Boooo0P0000?ooonL00007ooo
och00004oooo0P0000[oool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?oo
ooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW000
01ooooln00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000
oooooooo00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo
00Soool001;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool0
0`000?ooooooo`02ooooW00001ooooln00001Oooo`030000oooooooo00Soool001;oool200000ooo
oi`0000Ooooo?P0000Coool200002_ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003ooooo
ool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo
00;ooonL00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL
00007ooooch00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005
oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooonL00007ooooch00005oooo00<0
003oooooool02?ooo`002oooo`800005oooo00<0003oooooool00_oooi`0000Ooooo?P0000Goool0
0`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`030000oooooooo00;ooonL00007ooo
och00005oooo00<0003oooooool02?ooo`002oooo`030000oooo000000Coool300000_oooi`0000O
oooo?P0000?oool300002_ooo`002oooo`800005oooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`002oooo`030000oooooooo00Coool00`000?ooooooo`02oooon@0000Goool0
0`000?ooooooo`08oooo000<oooo0P0000Coool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000Boooo0P0000?ooooi00001?ooo`80000:oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool200000oooooT00004oooo0P00
00[oool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08
oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000
oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool200000oooooT00004oooo0P00
00[oool001;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0
003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi
00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02oooon@0000Goool00`000?oo
ooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0003oooooool02?ooo`004_oo
o`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool001;oool00`000?ooooooo`02
oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003oooooool00_ooooT00005oooo00<0
003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Oooo`030000oooooooo00Soool0
01;oool00`000?ooooooo`02oooon@0000Goool00`000?ooooooo`08oooo000Boooo00<0003ooooo
ool00_ooooT00005oooo00<0003oooooool02?ooo`004_ooo`030000oooooooo00;ooooi00001Ooo
o`030000oooooooo00Soool000coool00`000?ooooooo`03oooo00<0003oooooool00_ooooT00005
oooo00<0003oooooool02?ooo`002oooo`030000oooo000000Coool00`000?ooooooo`02oooon@00
00Goool00`000?ooooooo`08oooo000;oooo00<0003oool000001?ooo`<00002oooon@0000?oool3
00002_ooo`003?ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00Soool000_oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`08
oooo000<oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool02?oo
o`004_ooo`030000oooooooo00;oool00`000?ooooooo`0=oooo00<0003oooooool03?ooo`030000
oooooooo00goool00`000?ooooooo`0<oooo00<0003oooooool03Oooo`030000oooooooo00coool0
0`000?ooooooo`0=oooo00<0003oooooool03Oooo`030000oooooooo00coool00`000?ooooooo`0=
oooo00<0003oooooool03?ooo`030000oooooooo00goool00`000?ooooooo`0<oooo00<0003ooooo
ool03Oooo`030000oooooooo00coool00`000?ooooooo`0=oooo00<0003oooooool00_ooo`030000
oooooooo00Soool001;ooooo00001@0000[oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo001Roooo0`0000?oool300000_oo
o`8000000oooo`0000000002oooo00<0003oooooool00P0000;oool300000_ooo`<00002oooo0`00
00?oool200000oooo`<0000@oooo100000?oool200000_ooo`<00003oooo0P0000;oool300000ooo
o`80001Poooo001Soooo00D0003oooooooooool000000_ooo`030000oooo000000Coool01P000?oo
ooooo`000?ooo`0000;oool010000?ooooooo`0000Coool00`000?ooooooo`02oooo00D0003ooooo
ooooool000001?ooo`040000oooooooo00004Oooo`060000oooooooo0000oooo00001Oooo`050000
oooooooooooo000000Coool00`000?ooooooo`02oooo00@0003oooooool0001Ooooo001Soooo00D0
003oooooooooool000000_ooo`030000oooo000000800002oooo00H0003oooooool0003oool00005
oooo00<0003oooooool00_ooo`030000oooooooo00;oool010000?ooooooooooo`<00002oooo00@0
003oooooool0000Aoooo00D0003oooooool0003oool00`0000?oool010000?ooooooooooo`<00002
oooo00<0003oooooool00_ooo`030000oooooooo063oool006?oool00`000?ooooooo`02oooo0`00
0005oooo000000000000oooo00@000000oooo`000000000200000_ooo`800003oooo0`0000;oool2
00000oooo`<00003oooo0`00017oool01@000?ooooooo`000?ooo`0300000_ooo`<00002oooo0`00
00;oool3000000?oool0000000000P00063oool006?oool00`000?ooooooo`04oooo00<0003ooooo
ool02Oooo`030000oooooooo00Soool00`000?ooooooo`0>oooo00<0003oooooool03oooo`040000
oooooooo00001oooo`030000oooooooo00_oool00`000?ooooooo`1Poooo001Roooo0`0000Coool2
00004Oooo`030000oooooooo00?oool01@000?ooooooooooo`00000:oooo0P00013oool400002Ooo
o`030000oooooooo06goool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.762352, -0.553541, 0.0321664, 
  0.0321664}}]
}, Closed]],

Cell[BoxData[
    \(\[FilledSquare]\ Photo\ Example\)], "Input"],

Cell[BoxData[
    \(\(sample = Table[fukuzawa[\([i, j]\)], {i, 20, 147}, {j, 10, 137}]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(sample2 = sample; \)\)], "Input"],

Cell["\<\
Do[sample2[[i,j]]=0,
\t\t{i,50,52},{j,30, 33}];\
\>", "Input",
  FormatType->InputForm],

Cell[BoxData[
    \(\(bsample = sample2; \)\)], "Input"],

Cell[BoxData[
    \(\(SamplePhoto = 
      ListDensityPlot[sample, \n\tMesh -> False, \n\t
        PlotLabel -> "\<Bad Sample Photo\>", \n\t
        DisplayFunction -> Identity]; \)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
BadSamplePhoto=ListDensityPlot[bsample,
\tMesh->False,
\tPlotLabel->\"Bad Sample Photo\",
\tDisplayFunction->Identity];
Show[GraphicsArray[{SamplePhoto,BadSamplePhoto}]];\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -50 0 ]
[.5 1.0125 50 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Bad) show
87.000000 13.000000 moveto
(Sample) show
129.000000 13.000000 moveto
(Photo) show
159.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -50 0 ]
[.5 1.0125 50 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -111 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Bad) show
87.000000 13.000000 moveto
(Sample) show
129.000000 13.000000 moveto
(Photo) show
159.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
0000FFFFFFFFFFFF00000000FFFFFF00FFFFFF00FF00FF00
00000000000000FFFFFF00FFFF00FFFF00FFFFFFFF000000
FF0000000000000000FF00FF00000000000000FF0000FFFF
0000000000FF00FFFF0000FFFFFF00FF00FFFF00FFFF0000
00FF0000FF0000FF00FFFF0000000000FF0000FFFFFF0000
FFFFFFFFFFFFFFFF
0000FFFF000000FF00FFFFFF00FFFF00FF00FFFF00000000
00FF00FFFF0000000000FFFF0000FFFF0000000000000000
0000FF00FF000000FF00FF0000FFFFFFFF0000FF00FFFFFF
000000FF0000FF00FFFFFFFFFFFFFFFFFF00FFFFFF00FFFF
FFFFFF00FFFF000000FFFFFF0000FFFFFFFFFF0000FF00FF
FFFF00FFFFFF00FF
00FF00FF0000FF000000FFFF00FF00FFFFFFFF00FF000000
00FFFF000000FFFFFFFF0000FFFFFFFF0000FF0000FFFF00
00FFFF000000FFFF00FF00FFFF0000FFFF00FFFFFFFF00FF
000000FF00FF00FFFFFFFF000000FFFFFF00000000000000
FF00FFFFFFFFFF00FF00FF0000FF0000000000FF000000FF
0000000000FF00FF
00FF00FFFFFF00FFFF00FFFF000000FF0000FF00000000FF
FF00FF0000FF0000000000FFFF00000000FF000000000000
FF00000000FF0000FFFF00000000FF00000000FF00000000
0000FF0000FF00000000FFFF00FF0000FF0000FF000000FF
FF0000000000FFFFFF00FF000000FF00FF0000000000FF00
FF000000FF00FFFF
00000000FF00FFFFFF00000000FFFFFF000000FFFFFFFFFF
FFFF000000FFFFFF0000000000FF000000FF00FFFFFF0000
FF00FFFF00FF00FF00FFFF00FF00FF00FFFF000000FF0000
00FFFFFF00FFFFFF000000000000FFFFFF0000FF00000000
FF00FFFFFFFFFF000000FF000000000000FFFF00FF00FF00
FFFFFF00FFFF00FF
0000FFFF00FFFFFF0000FF00FFFF00FFFFFFFFFF00000000
FFFF00FFFF0000FF000000FF00FFFF0000000000000000FF
FFFF000000000000FF0000FF00FFFF00FFFFFF00FF00FF00
FF00FF00FFFF00FFFF00FF000000000000FFFFFFFF0000FF
FF00000000000000FFFFFF0000FFFF0000FF00FF0000FFFF
00FFFF00FFFF00FF
FFFFFF00FF00FF0000FF00FF0000000000FF0000FF00FFFF
FFFFFF000000FFFFFF00FFFF000000FFFFFFFFFF0000FFFF
FF0000000000FF000000FF00FF000000000000FF00FF0000
FFFF00FFFF00FFFFFFFF0000FF00FF00FF00FFFF00FFFFFF
00FF0000FFFFFFFFFFFFFFFF0000FFFFFFFF00FFFF000000
FFFFFF000000FF00
FF000000FFFF000000FFFF00FF00FF00000000FF0000FFFF
00FFFF0000FFFFFF00000000000000000000000000FF00FF
000000FFFFFFFFFF0000FF00FFFF0000FF00FFFFFF00FFFF
000000FF00FF00FFFF0000FFFFFF000000000000FFFFFF00
FF00FF00FFFF00000000FFFF00FF00000000000000FF00FF
FFFFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFF00FF00FFFF00FFFF00FFFFFF
0000FF00FF0000FF00FF0000FFFFFFFF00000000FF00FFFF
FF00FFFF00FF00FF000000FFFF00FF00FFFFFF00000000FF
00FFFFFFFF00FFFFFF00000000FFFFFFFF00FF0000FF0000
0000FFFFFFFFFFFF00FF0000FF000000FF00FF000000FFFF
00000000FF000000
000000000000000000000000000000000000FF0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF
00FFFFFF0000FFFF00FFFFFFFFFF00FFFF00FFFF00FFFFFF
FFFF0000FF000000
00000000FFFFFFFF00000000000000000000000000000000
000000FF00000000000000000000000000FF000000000000
000000000000000000000000000000000000FFFF00000000
0000000000000000000000FF000000000000000000000000
000000000000000000000000000000000000000000FFFF00
FFFFFF00FF00FFFF
000000000000000000000000000000000000000000000000
00000000FF000000FFFFFFFF0000FFFF00FFFFFFFFFFFF00
0000FF00FFFFFF000000FF0000FFFFFF00FFFF0000000000
FFFFFF00000000FF0000FF000000FFFF0000FF0000000000
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000FF0000
00000000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00FF00FF00FFFFFFFF0000000000000000FF0000FF000000
00FFFFFFFF00FFFFFF00FFFF00000000FFFF000000000000
000000000000000000000000000000000000000000000000
0000000000000000
0000000000000000000000000000000000000000000000FF
000000FFFF000000000000FF000000FFFFFFFFFFFFFFFFFF
00000000FFFF00000000FF0000FF000000FFFFFF00FFFF00
FFFF00000000000000FF0000000000FF0000000000000000
0000000000FF00FF00FFFFFF00FFFFFFFFFF000000000000
0000000000000000
00000000FFFFFF0000FFFF00000000000000000000000000
0000000000FF00000000000000FF000000FFFF00FFFFFFFF
FF00FF00FFFF00FF0000FFFFFFFF0000000000FFFF00FF00
0000FFFFFFFF000000000000000000000000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFFFFFFFFFF00
000000000000000000000000000000000000000000000000
FFFFFFFFFFFF0000000000000000FF0000FFFF0000000000
FFFFFFFFFFFFFFFFFF0000FF0000FF00000000000000FFFF
0000FF00FF00000000000000000000000000FF0000000000
0000000000FF00FFFFFFFFFFFFFFFF0000FFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
00FF0000FFFFFF000000000000000000000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFF0000000000000000000000000000FFFF00000000
00000000000000FFFFFF000000000000FFFFFF0000FF0000
0000FFFF0000FFFF
FFFFFFFF0000000000000000000000000000FF00FF0000FF
FFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FFFFFFFF0000
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFF0000
00FFFF00FF00FFFF
000000FFFFFFFF0000000000000000000000000000FF00FF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF
00000000000000FFFFFFFFFF00FF0000FFFFFF00FFFFFFFF
00FFFFFFFF00FFFF
000000FFFFFFFF00000000000000000000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF
FF00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFF
000000FFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00FFFFFFFF00
FFFF00000000000000FFFF0000FF0000FFFFFF0000FFFFFF
0000FFFFFF00FFFF
000000FFFF0000000000FFFFFF000000FFFFFFFF00FF00FF
00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFFFFFFFFFFFF
FFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF000000FFFFFF
FFFFFFFFFFFF00000000000000000000FFFFFF0000FF00FF
0000FFFFFF0000FF
000000FF0000000000FFFFFFFFFF00FFFFFFFF000000FFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFF000000FFFFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF0000FFFFFF
00FFFFFFFF0000FF
00000000000000FFFFFFFFFFFF00FF00FFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFFFF
0000FFFF00000000FFFFFFFF00FFFFFF00FFFFFF000000FF
FFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF000000FFFFFF
0000FFFFFF0000FF
0000000000FFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFFFFFFFFFFFF
FFFFFFFF00000000FFFFFF000000FFFF00FFFFFF000000FF
FFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFF00
FFFFFFFFFF00FFFF
00000000000000FFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFFFF
FF0000FFFF00000000FFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFF00000000FFFFFFFFFFFF0000000000FFFFFF
FFFFFFFFFF00FFFF
00FF0000FF00FFFF000000FFFFFF00000000FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFFFFFF0000FF
FF00FFFF00FFFF000000FFFFFFFFFFFF0000000000FFFF00
FFFFFFFF0000FFFF
00FF00FFFFFFFFFF00FF00FFFF0000000000FF0000FFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF0000000000FFFFFFFFFF00FF00FFFFFFFF00FF00
FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF0000000000
00FFFFFF0000FFFF
FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFFFFFFFFFFFF
FFFFFF00FF0000FFFFFF00FF00FF0000FFFFFFFFFF0000FF
FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
FFFF0000000000FF
FFFFFF00FF00FF000000FF0000FFFF00FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFFFFFFFFFF
FFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFFFF0000FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFF0000
000000000000FFFF
FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFFFF00FFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FF00
FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF0000000000
0000FF0000FFFF00
00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFF
FF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00FF00000000
0000000000FFFF00
FFFFFF000000FF000000FFFFFFFFFF00FFFFFF0000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFFFFFFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000
000000FFFF0000FF
FFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFF
FFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFFFFFF0000FF
00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF000000000000
0000FFFFFFFF00FF
FF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFFFFFFFFFFFF
FFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFF00
FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFF
FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FFFF00FFFFFFFFFFFFFF0000FF00FFFF000000000000FF
0000FF00000000FF
00000000FFFFFFFFFFFF000000FFFFFF00FFFF0000FFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FFFFFFFFFFFF
00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000FF00FF00FFFFFF0000FF0000FF00FF00000000000000
00FFFF00FFFF00FF
FF000000FFFFFFFFFFFF0000FFFFFF00FF000000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFF000000000000FFFFFF0000FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFF
FF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFFFF00FFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
00FFFF00FFFF00FF
FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFF00FF00000000FFFFFFFF00FF
FF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
0000000000FF0000FFFF00000000FFFF0000000000000000
0000000000000000
FF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FFFFFF0000FF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF00
0000000000FF00FFFFFFFF0000FFFFFF000000000000FF00
00FF0000FF0000FF
FFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFF00
FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
000000FFFFFFFFFFFFFF000000FFFF000000000000000000
00FF0000FF000000
FFFFFFFFFF00FFFFFF0000000000FFFF0000FF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFF00FFFF
FFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FFFF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00FFFFFFFF00
FF00FFFF000000FFFFFF0000FFFFFF000000000000000000
0000000000000000
FFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF0000FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFF00FFFF
FF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00FFFF00FF00
FF00FFFFFF000000FFFF000000FF00000000000000000000
000000FFFF00FF00
FFFF00FFFF0000FFFF00FFFF00FFFF00000000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF00FFFFFF
0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF00FF00FFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF00FFFF00FF
FF00FFFFFF000000FFFF000000FFFF000000000000FF0000
000000FFFFFF0000
FFFFFF00FF0000FFFF00000000FFFF00FF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF00FF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00
FF0000FF00FF0000FF00FF00FF00000000000000FFFFFFFF
000000FF00000000
FFFFFFFFFF0000FFFF0000FF00FFFF00000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF00
00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFFFFFFFF00FF
000000FF00FF00FFFFFF0000000000000000000000FFFFFF
FFFFFF000000FF00
FFFFFFFFFFFF00FFFF0000FF00FF0000000000FFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00FFFF0000FF
00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FFFFFF0000FF
00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFFFFFF0000FF
FFFF00FFFF0000FF000000FF00FF000000FFFF00FFFFFF00
000000FF000000FF
0000FFFFFFFF00FF000000FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF000000FF
FFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFFFFFFFF00FF
FF0000FF0000000000000000000000FFFF0000FFFFFFFFFF
FFFFFF00FFFFFFFF
0000000000FF00FFFF00FFFF0000FFFFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FFFFFF00FF00
0000FF00FFFFFFFFFFFFFFFFFF000000FFFFFFFFFFFF00FF
FF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FFFF0000FFFF
FF0000FFFFFF000000FF000000FF0000FF00000000FFFFFF
FFFF00FF00FFFFFF
0000000000FFFFFFFFFF00FF000000FFFF0000FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FF00FFFFFF
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFFFF00FFFFFF
000000FFFFFF00000000FF000000FFFFFFFFFF00FFFF0000
0000FFFFFFFFFFFF
00FFFFFFFFFFFF00FFFF00FF000000FFFF000000FFFFFF00
FFFFFFFFFF00000000FFFFFFFF00FF0000FFFFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFF00
00FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF0000FFFFFF
FFFFFFFFFFFF00FF00FFFF0000FF00FF0000FFFFFFFFFF00
00FF00FFFFFFFFFF
0000000000FFFF00000000FF00000000FF000000FFFFFFFF
00FFFFFFFF00000000FFFFFFFF00000000FFFF0000FFFF00
FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000FF0000FFFF0000FF0000FF000000FFFF00FFFF00FF
00FFFFFFFFFFFFFF
0000000000FFFF0000FF00FFFF000000FF000000FFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFF0000FF000000000000
000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFFFFFF00
00FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF0000FFFFFF00
00FF00FF00000000FFFF00FF0000FFFFFFFF00FF00FFFF00
FFFFFFFFFFFFFF00
0000000000FFFF000000000000000000FFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF00
FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000FFFF00FFFF
00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000FFFFFFFFFF
FF0000FF00FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF
FFFFFFFFFF00FFFF
0000000000FFFF00000000FF00FF0000FFFF0000FFFF00FF
FFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFFFF0000
FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF000000FF00FF
FFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFFFF
FF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFF00
0000000000FFFFFF000000000000FF0000FF000000FFFFFF
00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000FF00FFFF00
FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF00000000000000FFFFFFFF000000FFFFFF
000000FFFFFF00FFFF00FFFF00FFFF00FFFF00FFFFFFFFFF
FFFFFFFFFF000000FF00FF0000FFFF000000FFFFFFFF0000
FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFF00FF
0000000000FFFF000000000000FFFFFFFFFFFF0000FFFFFF
FFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFFFF000000FF0000FFFF00FFFFFFFFFF0000000000FF
0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF00FF
FFFFFFFFFF00FFFF
0000000000FFFF000000000000FFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00FFFFFFFFFF
FFFFFF0000FFFFFF000000FFFFFF000000FF00FFFF000000
0000FF00FFFF00FFFFFFFFFF000000FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFFFF0000FFFF
FF00000000FF000000000000000000FFFFFF00FF00000000
0000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFF
FF00FFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00FF00FFFF00
00000000FFFF0000000000000000000000FF00000000FF00
0000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
00000000FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00FFFFFFFF00
FF0000FF00000000000000000000000000FF00000000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF00FFFFFF00
FF00FF00000000000000000000000000000000FF0000FF00
0000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFFFFFF
00FFFF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFF00000000
00FF0000000000000000000000000000000000FF00FF0000
0000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00000000
000000000000000000000000000000000000000000000000
0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
000000000000000000000000000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00
000000000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000
000000000000000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000000000000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000000000000000000000000000000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
000000000000000000000000000000000000000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFF00000000000000000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FFFFFFFF00000000000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000000000FFFF00FF00000000000000000000000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000000000000000FFFFFF000000000000FF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000
FF0000FFFF00000000000000000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF
000000FF000000000000000000000000FF00000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000
FFFF00000000000000FFFFFF000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000FF00
00FF00FF000000FFFF000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
00FFFF00FFFF0000000000000000000000FF000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
FF00FFFFFFFFFFFFFFFFFF00FFFF00000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF000000000000FF
FFFF00FFFFFFFF0000FF0000000000FF0000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF00
FFFFFFFFFFFFFF000000000000FFFF00FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FF0000
0000FF00FF0000000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000000000FFFFFF
0000FFFF00FF00000000000000000000FF00000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF
FF00FFFF00FFFF00FF000000FF00FFFFFF000000FF000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFFFF
FFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFFFFFFFF0000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FFFFFF00
00000000FFFF00FF00FF000000FF000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00
FF00000000FFFFFFFFFF0000FF00000000000000FFFF0000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000
0000000000FFFFFFFFFFFF000000FF000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000FF00000000
00000000000000FFFFFFFF00000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FF00
FF00000000000000FFFF0000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF0000000000
FFFFFF0000000000FFFF00000000FF000000FF0000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00FF00FF00
00FFFFFF0000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF00000000
00000000000000FFFFFFFF00000000000000000000000000
FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFF
00FF0000000000FF00FFFF000000000000FFFFFFFF00FFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF00FFFF00FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFF00FFFFFFFF000000FF00FF00FF00FFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FF00FFFFFFFFFFFF00000000FFFFFF0000FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFF00FFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FF000000FFFFFF00FFFFFFFFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFF
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{392, 186.625},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000680000^QP00`40o`000?l0003oooooohWoool0
0?oooon9oooo003oooooROooo`00ooooohWoool00?oooon9oooo000Roooo00<0003oooooool04Ooo
o`<00003oooo00<0003oooooool03_ooo`<00002oooo00<0003oooooool03_ooo`800004oooo00<0
003oooooool03oooo`030000oooooooo00;oool00`000?ooooooo`0:oooo1@0000;oool00`000?oo
ooooo`02oooo00<0003oooooool02?ooo`D000001?ooo`000000000000?oool00`000?ooooooo`0b
oooo00<0003oooooool04?ooo`<00003oooo00<0003oooooool03oooo`<00002oooo00<0003ooooo
ool03_ooo`800004oooo00<0003oooooool03_ooo`030000oooooooo00;oool00`000?ooooooo`0:
oooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool02?ooo`D000001?ooo`0000000000
00?oool00`000?ooooooo`0Coooo000Qoooo00<0003oool000004_ooo`030000oooooooo00;oool0
0`000?ooo`00000@oooo00H0003oooooool0003oool0000?oooo00<0003oool000000_ooo`030000
oooo000000ooool00`000?ooo`000002oooo00<0003oool000003Oooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`00000;oooo00D0003oooooooooool000001?ooo`030000oooo0000
03;oool00`000?ooo`00000Aoooo00<0003oooooool00_ooo`030000oooo0000017oool01P000?oo
ooooo`000?ooo`0000ooool00`000?ooo`000002oooo00<0003oool000003_ooo`030000oooo0000
00;oool00`000?ooo`00000=oooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00_oool01@000?ooooooooooo`000004oooo00<0003oool000005?ooo`008Oooo`030000oooo0000
01?oool01`000?ooooooooooo`000?ooo`00000>oooo10000004oooo0000oooo00003oooo`030000
oooo000000;oool00`000?ooo`00000?oooo00<0003oool000000_ooo`030000oooo000000goool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000002oooo`030000oooooooo00;oool0
1`000?ooooooooooo`000?ooo`00000boooo00<0003oool000004_ooo`070000oooooooooooo0000
oooo000000ooool4000000Coool0003oool0000?oooo00<0003oool000000_ooo`030000oooo0000
00koool00`000?ooo`000002oooo00<0003oool000003Oooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`00000;oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo0000
01Coool0027oool00`000?ooo`00000Coooo00L0003oooooooooool0003oool000003_ooo`030000
oooo000000;oool00`000?ooo`00000?oooo0P0000?oool00`000?ooo`00000@oooo00L0003ooooo
ooooool0003oool000003Oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000;
oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000003;oool00`000?ooo`00000B
oooo00L0003oooooooooool0003oool000003oooo`030000oooo000000;oool00`000?ooo`00000?
oooo0P0000?oool00`000?ooo`00000?oooo00L0003oooooooooool0003oool000003Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000;oooo00<0003oooooool00_ooo`070000
oooooooooooo0000oooo000001Coool0027oool00`000?ooo`00000Boooo00<0003oool000000_oo
o`030000oooo000000ooool200000_ooo`030000oooo000000ooool00`000?ooooooo`02oooo00<0
003oool000003oooo`030000oooo000000;oool00`000?ooo`00000=oooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000000_oool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool00000<_ooo`030000oooo0000017oool00`000?ooo`000002oooo00<0003oool000004?oo
o`800002oooo00<0003oool000003oooo`030000oooooooo00;oool00`000?ooo`00000>oooo00<0
003oool000000_ooo`030000oooo000000goool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000002oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Doooo000R
oooo00<0003oooooool04_ooo`030000oooooooo00;oool00`000?ooooooo`0?oooo00D0003ooooo
ooooool000004Oooo`800003oooo00<0003oooooool03oooo`030000oooooooo00;oool00`000?oo
ooooo`0;oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool02Oooo`800004oooo00<0
003oooooool00_ooo`030000oooooooo03;oool00`000?ooooooo`0Aoooo00<0003oooooool00_oo
o`030000oooooooo013oool01@000?ooooooooooo`00000Aoooo0P0000?oool00`000?ooooooo`0>
oooo00<0003oooooool00_ooo`030000oooooooo00_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`09oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04oooo`00oooo
ohWoool00?oooon9oooo003oooooROooo`00ooooohWoool0023ooonH0000:ooooiP0000=oooo000K
oooo00<0003oooooool00_ooo`040000oooooooo00001Oooo`030000oooooooo00;oool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`02oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`0Toooo00<0003oooooool00_ooo`030000oooo0000
00Goool00`000?ooooooo`03oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?oo
ooooo`03oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo
00;oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?oo
ooooo`03oooo00<0003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00;oool00`000?ooooooo`03oooo0P0000goool001[oool0
0`000?ooo`000003oooo00<0003oooooool0U?ooo`030000oooooooo02?oool00`000?ooo`000003
oooo00<0003oooooool0U?ooo`030000oooooooo00_oool001[oool00`000?ooo`000003oooo0P00
09Coool200009Oooo`030000oooo000000?oool00`000?ooooooo`2Coooo0P0000goool001[oool0
0`000?ooo`000003oooo00<0003oooooool00P0000Ooool500000oooo`030000oooooooo00;oool0
10000?ooo`000?ooo`T00004oooo00@0003oooooool00002oooo00<0003oooooool00oooo`<00002
oooo2@000003oooo0000oooo00P000000oooo`0000000003oooo1@000003oooo0000oooo00;oool2
00000oooo`8000001Oooo`000?ooooooo`000002oooo10000004oooo00000000oooo0`000004oooo
0000oooooooo1P000003oooo0000000000Coool200003?ooo`030000oooooooo02?oool00`000?oo
o`000003oooo00@0003oool000000007oooo1@0000?oool00`000?ooooooo`02oooo00@0003oool0
003oool900001?ooo`040000oooooooo00000oooo`030000oooooooo00;oool4000000?oool00000
00001`000003oooo0000oooo00P00002oooo0P0000;oool6000000Coool0003oooooool300000ooo
o`040000oooo000000000_ooo`030000oooooooo00@000001?ooo`0000000?ooo`800002oooo00<0
003oooooool01P000003oooo0000000000Coool200003?ooo`030000oooooooo00_oool001[oool0
0`000?ooo`000003oooo00<0003oooooool00P0000?oool3000000?oool0003oool00oooo`060000
oooooooo0000oooo00000oooo`D000000oooo`0000000002oooo1P0000;oool200000_ooo``00000
0oooo`000?ooo`0300000_ooo`040000oooo000000001Oooo`8000000oooo`000?ooo`03oooo0`00
0004oooo00000000oooo0P0000[oool01@000?ooooooooooo`000006oooo00@0003oooooooooool3
00000oooo`<00005oooo0`000003oooo0000oooo00;oool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`030000oooooooo02?oool00`000?ooo`000003oooo00@0003oool000000003oooo0`00
0003oooo0000oooo00?oool01@000?ooooooo`000?ooo`0200000_ooo`H000001?ooo`000?oooooo
o`H00002oooo0P0000?oool;000000?oool0003oool010000003oooo0000oooo00<00004oooo0P00
00;oool010000?ooooooooooo`@000001Oooo`0000000?ooo`00000;oooo00D0003oooooooooool0
00001_ooo`030000oooooooo00@00003oooo0P0000Koool200000_ooo`050000oooooooooooo0000
00Coool00`000?ooooooo`02oooo00<0003oooooool02oooo`006oooo`030000oooooooo00;oool0
1P000?ooooooo`000?ooo`0000;oool2000000Coool0000000000003oooo00<0003oool000001Ooo
o`030000oooo000000<00003oooo0`0000Goool200001?ooo`<000000oooo`0000000002oooo0`00
00;oool300000_ooo`8000001?ooo`000?ooooooo`800003oooo00<0003oooooool00_ooo`030000
oooooooo00<000001?ooo`000?ooo`0000Goool300001?ooo`P000000oooo`000?ooo`05oooo00@0
003oool0003oool200000_ooo`D000000oooo`0000000002000000?oool00000000010000003oooo
0000oooo00?oool00`000?ooooooo`0Toooo00<0003oooooool00_ooo`050000oooo0000oooo0000
00;oool2000000Coool0000000000003oooo00<0003oool000001Oooo`030000oooo000000@00002
oooo0`0000Goool200001Oooo`8000000oooo`0000000003oooo0P0000;oool400000_ooo`030000
oooo000000?oool200000_ooo`030000oooooooo00?oool00`000?ooo`000003000000Coool0003o
ool00005oooo0`0000Coool8000000?oool0003oool01?ooo`8000000oooo`000?ooo`02000000?o
ool00000000010000003oooo00000000008000000oooo`0000000004000000?oool0003oool00ooo
o`030000oooooooo00_oool0023oool01P000?ooooooo`000?ooo`0000Coool010000?ooooooo`00
00?oool3000000?oool0000000000_ooo`@00002oooo00<0003oooooool00P000003oooo00000000
00@00002oooo100000;oool600000_ooo`@000000oooo`0000000003oooo10000003oooo00000000
00<000000oooo`0000000005000000Coool00000003oool500000_ooo`030000oooo000000800000
1?ooo`0000000?ooo`@00002oooo1P0000?oool00`000?ooo`000003000000?oool0003oool01P00
0003oooo0000oooo00<00002oooo00<0003oooooool00oooo`030000oooooooo02Woool01@000?oo
o`000?ooo`000004oooo00@0003oooooool00003oooo0`000005oooo000000000000oooo00@00003
oooo00D0003oool00000003oool01P0000;oool5000000?oool0000000001@000003oooo00000000
00800002oooo0P0000;oool5000000?oool0000000000P0000;oool600000_ooo`8000000oooo`00
0000000300000_ooo`040000oooo000000000_ooo`8000001?ooo`000000000000?oool500001?oo
o`030000oooo000000800002oooo00<0003oool000001@000003oooo0000oooo00<00002oooo00<0
003oooooool00oooo`030000oooooooo00_oool0023oool01P000?ooooooo`000?ooo`0000Coool0
10000?ooooooo`0000?oool3000000?oool0000000000_ooo`@00002oooo00<0003oooooool00P00
0003oooo0000000000@00002oooo100000;oool600000_ooo`@000000oooo`0000000003oooo1000
0003oooo0000000000<000000oooo`0000000005000000Coool00000003oool500000_ooo`030000
oooo0000008000001?ooo`0000000?ooo`@00002oooo1P0000?oool00`000?ooo`000003000000?o
ool0003oool01P000003oooo0000oooo00<00002oooo00<0003oooooool00oooo`030000oooooooo
02Woool01@000?ooo`000?ooo`000004oooo00@0003oooooool00003oooo0`000005oooo00000000
0000oooo00@00003oooo00D0003oool00000003oool01P0000;oool5000000?oool0000000001@00
0003oooo0000000000800002oooo0P0000;oool5000000?oool0000000000P0000;oool600000_oo
o`8000000oooo`000000000300000_ooo`040000oooo000000000_ooo`8000001?ooo`0000000000
00?oool500001?ooo`030000oooo000000800002oooo00<0003oool000001@000003oooo0000oooo
00<00002oooo00<0003oooooool00oooo`030000oooooooo00_oool0023oool2000000?oool00000
00000`000003oooo0000oooo00;oool500000oooo`@00007oooo100000?oool6000000Coool00000
00000002oooo00@0003oooooooooool200000_ooo`070000oooooooo0000oooo0000oooo00800002
oooo00@0003oool0003oool200000_ooo`<000000oooo`000000000200000oooo`030000oooooooo
00;oool600001?ooo`8000000oooo`0000000003000000?oool0003oool01Oooo`<000000oooo`00
0000000500000_ooo`060000oooooooo0000oooo00000oooo`050000oooooooooooo000000Coool0
0`000?ooooooo`0Yoooo00<0003oool0000010000003oooo0000oooo00;oool500000oooo`@00008
oooo0`0000Coool5000000?oool0000000000P000003oooo0000oooo00;oool3000000Goool0003o
ooooool000000_ooo`030000oooo000000;oool01P000?ooooooo`000?ooo`0000;oool4000000Co
ool0000000000004oooo00@0003oooooooooool700001?ooo`8000000oooo`0000000003000000?o
ool0003oool01?ooo`@000000oooo`000000000500000_ooo`060000oooo00000000oooo00000ooo
o`050000oooooooooooo000000?oool200003Oooo`008?ooo`030000oooooooo00800003oooo00@0
003oooooooooool2000000?oool0000000000_ooo`030000oooooooo00Coool400000_ooo`800002
oooo0P000003oooo00000000008000001?ooo`000?ooooooo`T00004oooo1P0000;oool2000000Co
ool0003oooooool200000oooo`040000oooo0000oooo0P000004oooo0000oooo00000_ooo`060000
oooooooooooo0000oooo1`0000Coool300000_ooo`P00003oooo0P0000?oool2000000?oool0003o
ool00`0000;oool010000?ooooooo`0000?oool00`000?ooooooo`02oooo00<0003oooooool0:Ooo
o`040000oooo000000000oooo`040000oooooooooooo0P0000;oool010000?ooooooo`0000Koool4
00000oooo`030000oooooooo00800002oooo0`000004oooo0000oooooooo2P0000?oool7000000Co
ool00000003oool200000_ooo`040000oooooooooooo0P000006oooo0000oooo0000oooo00000_oo
o`040000oooooooo00000_ooo`8000000oooo`000000000500001?ooo`800003oooo200000?oool2
00000oooo`8000000oooo`000?ooo`0300000_ooo`040000oooooooo00000oooo`030000oooooooo
00;oool00`000?ooooooo`0;oooo000Poooo00<0003oooooool00oooo`8000000oooo`000?ooo`02
000000Coool0003oooooool5000000Koool000000000003oool00006oooo0`0000?oool200000_oo
o`<00006oooo0P0000Coool5000000?oool0000000000P000003oooo0000oooo00L000000oooo`00
0?ooo`0300000_ooo`040000oooooooo00001Oooo`8000001oooo`000?ooooooo`000?ooo`000002
oooo00<0003oooooool00_ooo`040000oooo000000002Oooo`<00004oooo00@0003oooooooooool3
00000oooo`@000000oooo`000?ooo`02oooo00<0003oooooool0:Oooo`030000oooooooo00;oool2
000000?oool0003oool00P000004oooo00000000oooo1@0000;oool2000000?oool0003oool01Ooo
o`<00004oooo00<0003oooooool00`0000Koool200001?ooo`H000001_ooo`00000000000?ooo`00
00;oool600000_ooo`040000oooo000000000_ooo`800002oooo00<0003oooooool00oooo`800000
1?ooo`000?ooo`0000;oool010000?ooooooo`0000Coool010000?ooo`00000000Woool200001Ooo
o`030000oooooooo00@00003oooo10000003oooo0000oooo00;oool00`000?ooooooo`0;oooo000P
oooo00@0003oooooooooool400000_ooo`<00002oooo0P000003oooo0000oooo00D000000oooo`00
00000002oooo00@0003oooooooooool200000oooo`l000000oooo`000?ooo`0400001Oooo`<00000
1?ooo`000?ooooooo`<000000oooo`000?ooo`02oooo00@0003oooooooooool3000000Coool0003o
ool00003oooo0P0000?oool700001?ooo`050000oooo0000oooo000000?oool400000_ooo`030000
oooooooo00P000000oooo`000?ooo`07oooo00<0003oooooool00_ooo`030000oooooooo02Woool0
0`000?ooooooo`0400000_ooo`<00003oooo00@0003oool0003oool5000000?oool0000000000_oo
o`800002oooo0P0000Coool>000000Coool00000003oool300001_ooo`8000000oooo`000?ooo`02
oooo0P000003oooo0000oooo00?oool00`000?ooooooo`04000000Coool0003oool00002oooo0`00
00?oool700000oooo`8000001?ooo`000?ooo`0000;oool500000_ooo`030000oooo000000L00002
oooo00<0003oooooool01_ooo`030000oooooooo00;oool00`000?ooooooo`0;oooo000Poooo00<0
003oooooool01oooo`030000oooooooo00Coool00`000?ooo`000002oooo00D0003oooooooooool0
00000oooo`800002oooo00H0003oool00000003oool00002oooo0P0000Coool5000000?oool0003o
ool00oooo`070000oooooooo0000oooo0000oooo00@00002oooo00@0003oool000000003oooo1000
00;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`@00005oooo00D0003oool00000003o
ool01@0000Ooool01@000?ooo`0000000?ooo`04000000?oool0003oool0100000;oool400000_oo
o`<00003oooo00<0003oooooool0:Oooo`030000oooooooo00Koool00`000?ooooooo`04oooo00<0
003oool000000_ooo`800002oooo00@0003oooooooooool3000000?oool0003oool00P0000;oool0
10000?ooo`00000000Goool4000000?oool0003oool00oooo`040000oooooooo00000_ooo`030000
oooo000000800003oooo00<0003oool000000oooo`D000000oooo`000?ooo`04oooo00@0003ooooo
ooooool500001Oooo`050000oooo00000000oooo00D00007oooo00D0003oool00000003oool01000
0003oooo0000oooo00@00002oooo100000;oool300000oooo`030000oooooooo00_oool0023oool2
000000?oool0000000004P0000;ooola00005?ooo`040000oooo000000001_ooo`030000oooooooo
00Goool010000?ooooooooooo`<00002oooo00<0003oooooool01?ooo`040000oooooooo00000_oo
o`800005oooo0P0000;oool300000oooo`030000oooooooo02Woool00`000?ooo`00000D000000?o
ool000000000<00001?oool00`000?ooooooo`0200001_ooo`030000oooooooo00Goool010000?oo
ooooooooo`800003oooo00<0003oooooool00oooo`800002oooo00@0003oooooool00006oooo0P00
00;oool300000_ooo`80000=oooo000Poooo00<0003oooooool01@0000CooolF000000?oool00000
0000300000;ooolK00000_oooa4000000oooo`000000000T00000_ooo`050000oooooooooooo0000
00;oool00`000?ooooooo`03oooo00<0003oooooool0:Oooo`030000oooo000000@00004oooo5P00
0003oooo0000000000d000000oooo`000000000I00000ooooa4000000oooo`000000000S00000ooo
o`050000oooooooooooo000000;oool00`000?ooooooo`03oooo00<0003oooooool02oooo`008?oo
o`030000oooooooo020000001?ooo`000000000000Goool200000_ooo`030000oooooooo00Goool4
000000?oool0003oool00_ooo`@000000oooo`0000000004oooo00<0003oooooool01P0000?oool4
00000_ooo`8000001?ooo`000000000000?oool2000000?oool000000000:00000?oool00`000?oo
ooooo`0Yoooo00<0003oool000007`000003oooo0000000000800004oooo0P0000?oool00`000?oo
ooooo`05oooo0`000003oooo0000oooo00?oool3000000Coool0000000000003oooo00<0003ooooo
ool01P0000Coool4000000Goool000000000003oool00`0000;oool3000000?oool000000000:000
00?oool00`000?ooooooo`0;oooo000Poooo00<0003oooooool080000004oooo0000000000001Ooo
o`800002oooo00<0003oooooool01Oooo`@000000oooo`000?ooo`02oooo10000003oooo00000000
00Coool00`000?ooooooo`0600000oooo`@00002oooo0P000004oooo0000000000000oooo`800000
0oooo`000000000X00000oooo`030000oooooooo02Woool00`000?ooo`00000O000000?oool00000
00000P0000Coool200000oooo`030000oooooooo00Goool3000000?oool0003oool00oooo`<00000
1?ooo`000000000000?oool00`000?ooooooo`0600001?ooo`@000001Oooo`00000000000?ooo`03
00000_ooo`<000000oooo`000000000X00000oooo`030000oooooooo00_oool0023oool00`000?oo
ooooo`0H000000?oool0000000001@000003oooo00000000013oool5000000Coool0003oool00005
oooo2@000004oooo00000000oooo1@0000Coool00`000?ooooooo`02oooo00<0003oooooool01@00
00;oool[00000oooo`030000oooooooo02Woool00`000?ooo`00000G000000?oool0000000001@00
0003oooo00000000013oool5000000Coool0003oool00005oooo2@000005oooo000000000000oooo
00@00005oooo00@0003oooooooooool200000_ooo`@00003oooo:`0000?oool00`000?ooooooo`0;
oooo000Poooo00<0003oooooool06P000003oooo0000000000800002oooo1`000004oooo00000000
00002_ooo`D00002oooo1@000004oooo00000000oooo100000?oool00`000?ooooooo`0200000_oo
o`P000000oooo`0000000004000000?oool000000000300000;oool00`000?ooo`000003oooo00<0
003oooooool01?oooa000003oooo00<0003oooooool0:Oooo`030000oooo000001T000000oooo`00
0000000200000_ooo`L000001?ooo`000000000000_oool400000oooo`@000001Oooo`0000000000
0?ooo`0300001?ooo`040000oooooooo00000_ooo`P00002oooo1@000003oooo0000000000d00000
1Oooo`000?ooooooo`000003oooo00<0003oooooool01?oooa000003oooo00<0003oooooool02ooo
o`008?ooo`8000000oooo`000000000300000oooo`800002oooo5@000003oooo0000000000H00000
1?ooo`000000000000?oool00`000?ooooooo`04oooo00<0003oool000000_ooo`030000oooo0000
00800004oooo1P0000;oool00`000?ooo`00000300001?oooaX00002oooo00<0003oooooool02ooo
o`030000oooooooo00?oool00`000?ooooooo`05oooo00D0003oooooooooool00000:oooo`030000
oooo000000@00003oooo0P0000?ooolD000000?oool0000000001P000003oooo0000000000800002
oooo00<0003oooooool01?ooo`030000oooo000000?oool010000?ooo`00000000Goool500000ooo
o`030000oooo000000800005oooo6P000003oooo0000oooo00goool00`000?ooooooo`03oooo00<0
003oooooool01Oooo`030000oooooooo0080000=oooo000Poooo00<0003oooooool06`0000Ooool9
000000?oool0000000000oooo`D0000;oooo0P000004oooo00000000oooo200000?oool2000000?o
ool0003oool03`000003oooo0000000000T00002oooo00<0003oooooool01oooo`800002oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool0:Ooo
o`030000oooo000001X00007oooo2@000004oooo0000000000000_ooo`H0000:oooo0P000005oooo
000000000000oooo00P00002oooo0P0000;oool00`000?ooo`00000>000000?oool0000000002@00
0003oooo0000oooo00Woool200000_ooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00_oool0023oool00`000?ooooooo`0L000000Coool00000
00000003oooo3P0001goool00`000?ooooooo`05oooo400000;oool=00000oooo`L00003oooo0`00
0003oooo0000000000800002oooo0`0000Goool00`000?ooooooo`0Yoooo00<0003oool000007000
0003oooo0000000000?oool>00007_ooo`030000oooooooo00Goool@00000_ooo``00004oooo1`00
00?oool200000_ooo`@00002oooo0`0000Goool00`000?ooooooo`0;oooo000Poooo00<0003ooooo
ool01Oooo`l00002oooo00@0003oool000000005oooo00<0003oooooool00_ooo`<00006oooo00@0
003oooooool0000Xoooo0P0000;oool00`000?ooo`000005oooo00<0003oooooool00_ooo`/00005
oooo00<0003oooooool00P0000?oool010000?ooooooooooo`<00002oooo00@0003oooooool00005
oooo00<0003oooooool0:Oooo`030000oooooooo00Coool@000000?oool0003oool00P0000Goool0
0`000?ooooooo`03oooo0P0000Ooool00`000?ooo`00000Yoooo00L0003oooooooooool0003oool0
00001Oooo`030000oooooooo00;oool:00001_ooo`030000oooo000000800003oooo00@0003ooooo
ooooool300000_ooo`040000oooooooo00001Oooo`030000oooooooo00_oool001Goool300000ooo
o`030000oooooooo00;oool00`000?ooooooo`0300001Ooooa0000000oooo`000?ooo`05oooo00<0
003oooooool03Oooo`030000oooooooo00[oool00`000?ooooooo`0Hoooo00<0003oooooool02_oo
o`030000oooo000000Goool800001Oooo`030000oooooooo00800003oooo00<0003oooooool00ooo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool07_ooo`<00003oooo00<0
003oooooool00_ooo`030000oooo000000800005oooo40000003oooo0000oooo00Goool00`000?oo
ooooo`0=oooo00<0003oooooool02oooo`030000oooooooo01Soool00`000?ooooooo`0:oooo00<0
003oool000001Oooo`L00006oooo00<0003oool000000P0000?oool00`000?ooooooo`03oooo00<0
003oooooool00oooo`030000oooooooo00?oool00`000?ooooooo`0;oooo000Eoooo00<0003ooooo
ool00_ooo`030000oooo000000?oool00`000?ooooooo`0300001Ooooa0000000oooo`000?ooo`05
oooo00<0003oooooool03Oooo`030000oooooooo00[oool00`000?ooooooo`0Hoooo00<0003ooooo
ool02_ooo`030000oooo000000Goool800001Oooo`030000oooooooo00800003oooo00<0003ooooo
ool00oooo`030000oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool07_ooo`030000
oooooooo00;oool00`000?ooo`000003oooo00<0003oool000000P0000Goool@000000?oool0003o
ool01Oooo`030000oooooooo00goool00`000?ooooooo`0;oooo00<0003oooooool06?ooo`030000
oooooooo00[oool00`000?ooo`000005oooo1`0000Koool00`000?ooo`00000200000oooo`030000
oooooooo00?oool00`000?ooooooo`03oooo00<0003oooooool00oooo`030000oooooooo00_oool0
01Koool01`000?ooooooooooo`000?ooo`000003oooo0P000004oooo0000000000001Oooo`/0000M
oooo00<0003oooooool01Oooo`030000oooooooo00;oool200005Oooo`030000oooo000000koool0
0`000?ooooooo`06oooo200001Soool00`000?ooooooo`02oooo0P00027oool01`000?oooooooooo
o`000?ooo`000003oooo00<0003oool000000P0000Goool;00007Oooo`030000oooooooo00Goool0
0`000?ooooooo`03oooo0P0001Coool2000000?oool0003oool03Oooo`030000oooooooo00Koool8
00006?ooo`030000oooooooo00;oool200003Oooo`005_ooo`070000oooooooooooo0000oooo0000
00?oool00`000?ooooooo`0300001Oooo`@00006oooo00<0003oooooool01?ooo`030000oooooooo
00Ooool00`000?ooooooo`0:oooo00<0003oooooool00_ooo`050000oooooooooooo000000Goool2
00005Oooo`030000oooo000000800008oooo00@0003oooooool00005oooo00<0003oooooool02000
00;oool200000_ooo`800003oooo0`0000?oool200001?ooo`030000oooooooo00?oool00`000?oo
ooooo`0Ooooo00L0003oooooooooool0003oool000000oooo`030000oooo000000800005oooo1@00
00Goool00`000?ooooooo`04oooo00<0003oooooool01oooo`80000;oooo00<0003oooooool00ooo
o`040000oooooooo00001_ooo`030000oooooooo01Coool010000?ooo`00000000Soool01@000?oo
ooooooooo`000004oooo0P0000;oool800000_ooo`8000001?ooo`000000000000?oool200001?oo
o`800004oooo00<0003oooooool00oooo`030000oooooooo00_oool001Goool00`000?ooo`000002
oooo00<0003oool000000oooo`030000oooooooo00<00003oooo1@0000Coool300001Oooo`050000
oooo0000oooo000000Coool200003_ooo`050000oooooooooooo000000?oool00`000?ooo`000003
oooo00<0003oooooool01?ooo`040000oooo000000003Oooo`030000oooo000000800006oooo0P00
00?oool300002oooo`/00003oooo0`000003oooo0000oooo00800004oooo0P0000Coool00`000?oo
ooooo`0Noooo00<0003oool000000_ooo`030000oooo000000?oool00`000?ooo`00000200000ooo
o`D00004oooo0`0000Goool010000?ooo`000?ooo`800003oooo0P0000koool010000?oooooooooo
o`800002oooo00<0003oool000001?ooo`030000oooooooo00Coool00`000?ooo`00000>oooo00@0
003oool000000007oooo00<0003oooooool00_ooo`<0000:oooo300000?oool200000_ooo`040000
oooo000000001?ooo`800004oooo00<0003oooooool02oooo`005_ooo`030000oooooooo00;oool0
0`000?ooooooo`02oooo00<0003oooooool00`0000;oool500001_ooo`030000oooooooo00?oool3
00000_ooo`030000oooooooo01;oool01@000?ooooooooooo`000005oooo00<0003oooooool00_oo
o`800006oooo0P0000_oool00`000?ooooooo`0400001Oooo`D00002oooo0P0000?oool00`000?oo
o`000007oooo0P000003oooo0000000000?oool200000_ooo`<00003oooo00<0003oooooool00ooo
o`800004oooo00<0003oooooool07oooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oool000000P0000;oool500001_ooo`030000oooooooo00?oool300000_ooo`80000Coooo00@0
003oooooooooool200001?ooo`030000oooooooo00?oool00`000?ooooooo`05oooo00<0003ooooo
ool02Oooo`800002oooo0`0000Koool500000_ooo`800002oooo0P000003oooo0000oooo00Koool2
000000?oool0000000000oooo`800002oooo0P0000Coool00`000?ooooooo`03oooo0P0000Coool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool0200000Ooool00`000?ooo`000007oooo0P00
01Goool00`000?ooooooo`07oooo00<0003oooooool00_ooo`800004oooo00D0003oooooooooool0
00002?ooo`800002oooo1@0000Coool00`000?ooooooo`02oooo00@0003oooooooooool400003?oo
o`030000oooooooo00@00002oooo100000?oool200001?ooo`800004oooo00<0003oooooool0:Ooo
o`030000oooo000000L00007oooo00<0003oool000001oooo`80000Eoooo00<0003oooooool01ooo
o`030000oooooooo00?oool00`000?ooooooo`03oooo00@0003oooooool00008oooo0P0000?oool4
00001Oooo`040000oooooooooooo0P0000?oool300003Oooo`030000oooooooo00@00002oooo0`00
00Coool200001?ooo`800004oooo00<0003oooooool02oooo`008?ooo`8000000oooo`0000000004
00002oooo`030000oooo000000800003oooo00<0003oooooool01Oooo`030000oooooooo00coool0
0`000?ooooooo`08oooo00<0003oooooool00oooo`030000oooooooo00?oool300003?ooo`D00003
oooo0`0000?oool010000?ooooooooooo`@00003oooo0P0000goool200000_ooo`<00002oooo00<0
003oooooool01?ooo`030000oooooooo00?oool00`000?ooooooo`0Yoooo00<0003oool000001@00
00_oool00`000?ooo`00000200000oooo`030000oooooooo00Goool00`000?ooooooo`0<oooo00<0
003oooooool02?ooo`030000oooooooo00?oool00`000?ooooooo`04oooo0P0000goool400001?oo
o`<00002oooo0P0000?oool300001?ooo`80000=oooo0P0000;oool200000oooo`030000oooooooo
00Coool00`000?ooooooo`02oooo0P0000goool0023oool00`000?ooooooo`0800002_ooo`@0000;
oooo00<0003oooooool03?ooo`030000oooooooo00koool200001_ooo`030000oooooooo00Ooool2
00000_ooo`D00008oooo00@0003oooooooooool200001Oooo`030000oooooooo00;oool400001ooo
o`H00009oooo00<0003oooooool00oooo`030000oooooooo02Woool00`000?ooo`00000700002_oo
o`@0000;oooo00<0003oooooool03?ooo`030000oooooooo00koool200001_ooo`030000oooooooo
00Ooool300000_ooo`@00008oooo0P0000?oool200001Oooo`040000oooooooooooo1@0000Ooool5
00002_ooo`030000oooooooo00?oool00`000?ooooooo`0;oooo000Poooo00D0003oooooool0003o
ool00`000004oooo0000oooooooo0`0000Coool400000_ooo`030000oooo000001Ooool00`000?oo
ooooo`0>oooo0P0001Coool500001Oooo`800006oooo0`0000;oool010000?ooooooo`0000?oool3
00001oooo`H00002oooo00<0003oooooool00_ooo`<00005oooo00<0003oooooool0:Oooo`040000
oooo0000oooo0`000004oooo0000oooooooo100000?oool5000000Coool0003oool0000Goooo00<0
003oooooool03_ooo`80000Eoooo100000Koool00`000?ooooooo`05oooo0P0000?oool010000?oo
ooooo`0000;oool400001oooo`D00003oooo00<0003oooooool00_ooo`<00005oooo00<0003ooooo
ool02oooo`008?ooo`050000oooooooo0000oooo00<000001?ooo`000?ooooooo`<00004oooo1000
00;oool00`000?ooo`00000Goooo00<0003oooooool03_ooo`80000Doooo1@0000Goool200001_oo
o`<00002oooo00@0003oooooool00003oooo0`0000Ooool600000_ooo`030000oooooooo00;oool3
00001Oooo`030000oooooooo02Woool010000?ooo`000?ooo`<000001?ooo`000?ooooooo`@00003
oooo1@000004oooo0000oooo00005oooo`030000oooooooo00koool200005Oooo`@00006oooo00<0
003oooooool01Oooo`800003oooo00@0003oooooool00002oooo100000Ooool500000oooo`030000
oooooooo00;oool300001Oooo`030000oooooooo00_oool0023oool01P000?ooooooo`000?ooo`00
00Koool00`000?ooo`000003oooo1@0000;oool200002Oooo`030000oooooooo00[oool300004Ooo
o`030000oooooooo017oool600001Oooo`8000000oooo`000?ooo`03oooo00@0003oooooool00009
oooo00@0003oooooooooool300000oooo`030000oooo000000H00003oooo0`0000Goool00`000?oo
ooooo`0Yoooo00D0003oool0003oool000001_ooo`040000oooo000000000_ooo`H000000oooo`00
00000009oooo00<0003oooooool02oooo`80000Aoooo00<0003oooooool04_ooo`D00006oooo00@0
003oool000000004oooo00@0003oool000000009oooo00@0003oooooooooool200001?ooo`030000
oooo000000H00003oooo0`0000Goool00`000?ooooooo`0;oooo000Poooo00D0003oooooooooool0
00001oooo`030000oooo000000;oool2000000?oool0003oool00oooo`80000Hoooo00<0003ooooo
ool03_ooo`030000oooo000000?oool300002oooo`040000oooo000000001?ooo`040000oooo0000
oooo0`0000Goool300001?ooo`030000oooooooo00koool700000_ooo`H00004oooo00<0003ooooo
ool0:Oooo`040000oooooooo00001oooo`050000oooo00000000oooo008000000oooo`000?ooo`03
oooo0P0001Soool00`000?ooooooo`0>oooo00<0003oool000001?ooo`80000<oooo00@0003oool0
00000004oooo00@0003oool0003oool200001_ooo`800005oooo00<0003oooooool03_ooo`L00002
oooo1P0000Coool00`000?ooooooo`0;oooo000Poooo0P0000Coool2000000?oool0003oool00`00
0004oooo0000000000000_ooo`030000oooooooo00Coool00`000?ooooooo`0Eoooo00<0003ooooo
ool03oooo`800006oooo00<0003oooooool02?ooo`040000oooooooooooo0P0000;oool00`000?oo
ooooo`03oooo00<0003oooooool00_ooo`800002oooo00<0003oooooool03_ooo`030000oooooooo
00;oool010000?ooooooooooo`T00005oooo00<0003oooooool0:Oooo`030000oooooooo00;oool2
000000?oool0003oool00`0000;oool200000_ooo`030000oooooooo00Coool00`000?ooooooo`0E
oooo00<0003oooooool03oooo`800006oooo00<0003oooooool02Oooo`050000oooooooooooo0000
00?oool00`000?ooooooo`02oooo00<0003oooooool00oooo`8000000oooo`000000000?oooo0P00
00Coool010000?ooooooooooo`T00004oooo0P0000goool0023oool00`000?ooooooo`03oooo0`00
00;oool00`000?ooooooo`0400002?ooo`030000oooooooo00Koool00`000?ooooooo`0:oooo0`00
017oool010000?ooo`00000000Goool00`000?ooooooo`0;oooo00<0003oooooool02?ooo`030000
oooooooo00;oool200000_ooo`040000oooooooo00002Oooo`800007oooo20000004oooo00000000
00000_ooo`050000oooooooooooo000002_oool00`000?ooooooo`02oooo0`0000;oool00`000?oo
ooooo`0400002?ooo`030000oooooooo00Koool00`000?ooooooo`0;oooo0P00017oool00`000?oo
o`00000200001?ooo`030000oooooooo00coool00`000?ooooooo`07oooo00<0003oooooool00ooo
o`8000000oooo`0000000002oooo00<0003oooooool01oooo`800007oooo20000004oooo00000000
00000_ooo`050000oooooooooooo000000goool0023oool010000?ooooooo`0000Coool010000?oo
ooooooooo`<0000:oooo00<0003oooooool05?ooo`<0000=oooo00@0003oool00000000:oooo00<0
003oooooool02Oooo`80000:oooo00<0003oooooool00_ooo`030000oooooooo00?oool010000?oo
o`00000000;oool00`000?ooooooo`02oooo0P0000Koool00`000?ooo`00000:00000_ooo`050000
oooooooooooo000002_oool00`000?ooo`000004oooo00@0003oooooooooool400002Oooo`030000
oooooooo01Goool200003_ooo`030000oooo000000[oool00`000?ooooooo`0:oooo0P0000Woool0
0`000?ooooooo`03oooo00<0003oooooool00oooo`060000oooo00000000oooo00001Oooo`800006
oooo00<0003oool000002P0000;oool01@000?ooooooooooo`00000=oooo000Poooo00<0003ooooo
ool00oooo`@000001?ooo`000000000000Koool00`000?ooooooo`02oooo0P0001;oool010000?oo
ooooooooo`800004oooo0P0000ooool00`000?ooooooo`03oooo00<0003oooooool01Oooo`030000
oooooooo00Soool200000oooo`030000oooooooo00Coool2000000?oool0003oool04_ooo`X00003
oooo0P0000Coool00`000?ooooooo`0Yoooo00<0003oooooool00_ooo`@000001?ooo`0000000000
00Koool00`000?ooooooo`02oooo0P0001;oool00`000?ooooooo`02oooo00<0003oooooool00_oo
o`<0000?oooo00<0003oooooool00_ooo`030000oooooooo00Goool00`000?ooooooo`09oooo0P00
00;oool00`000?ooooooo`05oooo00@0003oooooool0000Coooo2P0000?oool200001?ooo`030000
oooooooo00_oool0023oool00`000?ooooooo`02oooo00D0003oooooool0003oool00P0000Ooool0
10000?ooooooooooo`80000Hoooo0P0000Coool00`000?ooooooo`03oooo00<0003oooooool02?oo
o`80000=oooo00D0003oooooooooool000000oooo`050000oooooooooooo000000;oool00`000?oo
ooooo`03oooo0`000003oooo0000oooo00800009oooo00<0003oooooool01?ooo`T00005oooo00<0
003oooooool00_ooo`030000oooooooo02Woool01@000?ooooooooooo`000002oooo00@0003oool0
00000007oooo00<0003oooooool00_ooo`030000oooooooo01Ooool00`000?ooooooo`02oooo0P00
00Coool00`000?ooooooo`09oooo0P0000coool200000oooo`030000oooooooo00800003oooo00<0
003oool000001_ooo`800002oooo00@0003oool000000009oooo00<0003oooooool01?ooo`T00005
oooo00<0003oooooool00_ooo`030000oooooooo00_oool0023oool00`000?ooooooo`02oooo00D0
003oooooool0003oool00P0000Ooool010000?ooooooooooo`80000Hoooo0P0000Coool00`000?oo
ooooo`03oooo00<0003oooooool02?ooo`80000=oooo00D0003oooooooooool000000oooo`050000
oooooooooooo000000;oool00`000?ooooooo`03oooo0`000003oooo0000oooo00800009oooo00<0
003oooooool01?ooo`T00005oooo00<0003oooooool00_ooo`030000oooooooo02Woool01@000?oo
ooooooooo`000002oooo00@0003oool000000007oooo00<0003oooooool00_ooo`030000oooooooo
01Ooool00`000?ooooooo`02oooo0P0000Coool00`000?ooooooo`09oooo0P0000coool200000ooo
o`030000oooooooo00800003oooo00<0003oool000001_ooo`800002oooo00@0003oool000000009
oooo00<0003oooooool01?ooo`T00005oooo00<0003oooooool00_ooo`030000oooooooo00_oool0
023oool200000_ooo`800004oooo00<0003oooooool01?ooo`040000oooooooo00002oooo`800000
0oooo`000?ooo`09oooo00<0003oool000000P0000Goool01P000?ooooooo`000?ooo`0000[oool2
00001Oooo`030000oooooooo00Goool400004Oooo`<000001Oooo`000?ooooooo`000008oooo0P00
00;oool00`000?ooooooo`07000000Coool00000003oool500001?ooo`030000oooooooo02Woool0
0`000?ooooooo`0200001?ooo`030000oooooooo00Coool010000?ooooooo`0000coool00`000?oo
o`00000:oooo00<0003oooooool00P0000Koool01@000?ooo`000?ooo`00000;oooo0P0000Coool2
00001_ooo`D0000Aoooo0P0000;oool010000?ooooooo`0000Soool2000000?oool0000000000_oo
o`L000001?ooo`0000000?ooo`D00003oooo0P0000goool0023oool00`000?ooooooo`0500001_oo
o`@00003oooo00@0003oooooooooool200001Oooo`80000:oooo00@0003oool0003oool300001_oo
o`8000000oooo`000?ooo`04oooo0P0000Koool200000oooo`030000oooo000000Goool00`000?oo
ooooo`0Foooo0P000003oooo0000oooo00800003oooo0P000007oooo000000000000oooo0000oooo
00T00002oooo00D0003oooooooooool000001?ooo`030000oooooooo02Woool00`000?ooo`000004
00001_ooo`@00003oooo00@0003oooooooooool200001_ooo`030000oooooooo00Soool00`000?oo
o`000002oooo0P0000Ooool00`000?ooo`000006oooo00<0003oooooool01Oooo`040000oooooooo
oooo0P000003oooo0000oooo00?oool200006?ooo`8000001?ooo`000?ooo`0000Coool2000000?o
ool0000000000_ooo`030000oooo000000P00002oooo00D0003oooooooooool000001?ooo`030000
oooooooo00_oool0023oool010000?ooooooooooo`@00006oooo0`0000?oool00`000?ooo`000003
00002Oooo`030000oooooooo00Koool700000oooo`800008oooo00<0003oooooool01oooo`800003
oooo00<0003oooooool01?ooo`030000oooooooo00;oool01@000?ooooooooooo`000004oooo0P00
00Goool00`000?ooooooo`02oooo100000koool:00000_ooo`050000oooooooooooo000000Coool0
0`000?ooooooo`0Yoooo00<0003oooooool0100000Koool300000oooo`030000oooo000000<00009
oooo00<0003oooooool01_ooo`L00003oooo0`0000Soool00`000?ooooooo`07oooo00@0003ooooo
ooooool200001Oooo`030000oooooooo00?oool00`000?ooooooo`0200001?ooo`030000oooooooo
00Coool00`000?ooooooo`02oooo100000koool:00000_ooo`050000oooooooooooo000000Coool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool00_ooo`030000oooooooo00Ooool200000ooo
o`030000oooooooo00Woool200002_ooo`030000oooo000000@00004oooo00@0003oooooooooool2
000000?oool0000000005Oooo`030000oooooooo01;oool00`000?ooooooo`03oooo1@0000;oool2
00000_ooo`D00002oooo4P0000?oool00`000?ooooooo`0Yoooo00D0003oooooooooool000002_oo
o`050000oooooooooooo000000coool00`000?ooooooo`08oooo00<0003oool00000100000Coool2
00000_ooo`8000001?ooo`000000000001Coool00`000?ooooooo`0Coooo00<0003oooooool00ooo
o`D000001?ooo`000000000000;oool400000ooooa800003oooo00<0003oooooool02oooo`005_oo
o`<00002oooo00<0003oooooool00_ooo`050000oooooooooooo000000Woool4000000Coool0003o
ool00003oooo00<0003oooooool01?ooo`80000;oooo00<0003oool000000`0000?oool200000ooo
o`030000oooooooo0080000<oooo00<0003oooooool02?ooo`030000oooooooo00Coool00`000?oo
ooooo`09oooo00<0003oooooool00_ooo`H00002oooo00<0003oooooool00_ooo`800004oooo1`00
0004oooo00000000oooo0P0000;oool200001?ooo`030000oooooooo01ooool300000_ooo`030000
oooooooo00;oool010000?ooooooo`0000Woool4000000Coool0003oool00003oooo00<0003ooooo
ool01Oooo`030000oooooooo00Woool00`000?ooo`00000300000oooo`<00002oooo00<0003ooooo
ool00`0000_oool00`000?ooooooo`08oooo0P0000Goool00`000?ooooooo`0:oooo00@0003ooooo
ooooool7000000?oool0003oool01?ooo`800004oooo1`000004oooo00000000oooo0P0000;oool2
00001?ooo`030000oooooooo00_oool001Ooool01P000?ooooooo`000?ooo`0000?oool00`000?oo
ooooo`06oooo00@0003oool000000002oooo0P0000?oool00`000?ooooooo`02oooo00<0003ooooo
ool01oooo`030000oooooooo00Woool500001?ooo`030000oooooooo00;oool00`000?ooooooo`06
oooo00<0003oooooool01?ooo`030000oooooooo00Koool00`000?ooooooo`0Aoooo00<0003ooooo
ool00oooo`<00008oooo0`0000?oool;000000?oool0000000000_ooo`<00003oooo00<0003ooooo
ool08?ooo`060000oooooooo0000oooo00000oooo`030000oooooooo00Goool010000?ooo`000000
00?oool01@000?ooooooooooo`000004oooo00<0003oooooool01oooo`030000oooooooo00Woool5
00001Oooo`050000oooooooooooo000000Soool00`000?ooooooo`04oooo00<0003oooooool01_oo
o`030000oooooooo01;oool00`000?ooooooo`03oooo0`0000Soool300000oooo`/000000oooo`00
00000002oooo0`0000?oool00`000?ooooooo`0;oooo000Eoooo10000004oooo0000oooo00000ooo
o`800007oooo00@0003oooooooooool600000_ooo`800002oooo00<0003oooooool05?ooo`@00002
oooo00<0003oooooool02?ooo`040000oooooooooooo0P0000Goool200000_ooo`800004oooo00<0
003oooooool00oooo`800005oooo0`0000?oool00`000?ooooooo`03oooo00<0003oool000000_oo
o`@00003oooo0P0000CooolC00000_ooo`80000Poooo10000004oooo0000oooo00000oooo`030000
oooooooo00Goool010000?ooooooooooo`H00002oooo0`000003oooo0000oooo01Koool300000_oo
o`030000oooooooo00Woool00`000?ooooooo`0200001Oooo`800003oooo0P0000?oool00`000?oo
ooooo`04oooo00<0003oooooool01?ooo`800004oooo00<0003oooooool00_ooo`8000001?ooo`00
0?ooooooo`<00004oooo0P0000CooolC00000_ooo`80000=oooo000Eoooo00<0003oool000000_oo
o`030000oooo000000?oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`040000oooooooo
oooo0`0000Coool00`000?ooo`00000200002Oooo`030000oooooooo00Soool200000oooo`040000
oooooooo00001?ooo`040000oooo000000001_ooo`030000oooooooo00Goool2000000?oool00000
00001?ooo`030000oooooooo00[oool300000oooo`040000oooooooo00000_ooo`030000oooo0000
00?oool400000_ooo`<00002oooo3P0000?oool00`000?ooo`000003oooo00<0003oooooool07_oo
o`030000oooo000000;oool00`000?ooo`000003oooo00D0003oooooooooool000001?ooo`040000
oooooooooooo0`0000Coool00`000?ooooooo`0200002Oooo`030000oooooooo00Soool300000_oo
o`040000oooooooo00001?ooo`040000oooo000000001_ooo`030000oooooooo00Goool200000_oo
o`800003oooo00<0003oooooool02oooo`800004oooo00D0003oooooool0003oool00P000003oooo
0000oooo00;oool400000_ooo`<000000oooo`000000000=00000oooo`030000oooo000000?oool0
0`000?ooooooo`0;oooo000Foooo0P0000;oool00`000?ooo`000003oooo00<0003oooooool00_oo
o`030000oooooooo00;oool010000?ooooooooooo`<00004oooo00<0003oool000000P0000Woool0
0`000?ooooooo`08oooo0P0000?oool010000?ooooooo`0000Coool010000?ooo`00000000Koool0
0`000?ooooooo`05oooo0P000003oooo0000000000Coool00`000?ooooooo`0:oooo0`0000?oool0
10000?ooooooo`0000;oool00`000?ooo`000003oooo100000;oool300000_ooo`h00003oooo00<0
003oool000000oooo`030000oooooooo01ooool200000_ooo`030000oooo000000?oool01@000?oo
ooooooooo`000004oooo00@0003oooooooooool300001?ooo`030000oooooooo00800009oooo00<0
003oooooool02?ooo`<00002oooo00@0003oooooool00004oooo00@0003oool000000006oooo00<0
003oooooool01Oooo`800002oooo0P0000?oool00`000?ooooooo`0;oooo0P0000Coool01@000?oo
ooooo`000?ooo`02000000?oool0003oool00_ooo`@00002oooo0`000003oooo0000000000d00003
oooo00<0003oool000000oooo`030000oooooooo00_oool001Ooool01@000?ooooooooooo`000004
oooo00<0003oooooool00_ooo`040000oooooooooooo0P0000;oool01@000?ooooooooooo`000002
oooo1@0001Koool200000_ooo`030000oooo000000?oool300002_ooo`800004oooo0P000004oooo
0000oooo00001oooo`030000oooooooo00Soool200000_ooo`030000oooo000000;oool200000_oo
o`040000oooooooooooo100000;oool300000oooo`L000000oooo`000000000300001?ooo`800003
oooo00<0003oooooool08?ooo`050000oooooooooooo000000Coool01@000?ooooooooooo`000003
oooo0P0000;oool01@000?ooooooooooo`000002oooo1@0001Koool3000000Coool0003oool00004
oooo0P0000[oool300000oooo`8000001Oooo`0000000?ooo`000007oooo00<0003oooooool02?oo
o`070000oooooooooooo0000oooo000000;oool01@000?ooooooooooo`000003oooo100000;oool3
00000oooo`H00002oooo1@0000Coool200000oooo`030000oooooooo00_oool0023oool00`000?oo
ooooo`03oooo0P000003oooo0000000000;oool500000_ooo`030000oooo00000080000Goooo00@0
003oooooool00003oooo00<0003oool000000P0001;oool300005oooo`030000oooooooo00Coool0
1P000?ooo`0000000?ooo`0000;oool2000000Goool0003oool0003oool0200000Goool3000000?o
ool0000000000`0000?oool00`000?ooooooo`0Yoooo00<0003oooooool00_ooo`8000000oooo`00
00000002oooo1@0000;oool00`000?ooo`00000200006?ooo`030000oooo000000?oool2000000?o
ool0000000004_ooo`@0000Goooo00<0003oooooool00oooo`8000001_ooo`0000000?ooo`000?oo
o`<000001Oooo`000?ooo`000?ooo`0800001Oooo`<000000oooo`000000000300000oooo`030000
oooooooo00_oool0023oool200001oooo`800002oooo0P0000;oool00`000?ooooooo`0500002_oo
o`030000oooooooo00[oool00`000?ooooooo`02oooo00<0003oooooool00`0000goool00`000?oo
ooooo`07oooo00<0003oooooool01oooo`800004oooo0P0000?oool00`000?ooooooo`03oooo0P00
0006oooo000000000000oooo00000_ooo`040000oooooooooooo3@0000Koool4000000?oool0003o
ool00_ooo`030000oooooooo02Woool00`000?ooooooo`05oooo0P0000;oool3000000Coool0003o
ooooool500002_ooo`030000oooooooo00_oool01@000?ooooooooooo`000003oooo0P0000koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00?oool200000_ooo`800005
oooo00<0003oooooool00`000004oooo0000oooo00001?ooo``00007oooo10000004oooo0000oooo
oooo0P0000goool0023oool00`000?ooooooo`07oooo00<0003oooooool00P0000;oool00`000?oo
o`00000500002_ooo`030000oooooooo00[oool010000?ooooooo`0000;oool2000000?oool00000
00002Oooo`040000oooooooooooo0P0000?oool010000?ooooooooooo`800002oooo00<0003ooooo
ool00_ooo`040000oooo000000001Oooo`050000oooooooooooo000000Coool300000oooo`030000
oooooooo00<000001_ooo`00000000000?ooo`0000;oool300000_ooo`030000oooooooo00;oool4
000000?oool0000000000P0000Coool00`000?ooooooo`0Yoooo00<0003oooooool01_ooo`030000
oooooooo00<000000oooo`000?ooo`0600002_ooo`030000oooooooo00_oool00`000?ooo`000002
oooo0`000003oooo0000oooo00Soool00`000?ooooooo`02oooo0P0000;oool00`000?ooooooo`02
oooo0P000003oooo0000oooo00Coool00`000?ooo`000006oooo00<0003oooooool00P0000Coool2
00001?ooo`030000oooooooo00800002oooo0`000003oooo0000oooo00@00002oooo00<0003ooooo
ool00_ooo`@000000oooo`000000000200001?ooo`030000oooooooo00_oool0023oool00`000?oo
ooooo`0200001Oooo`030000oooo000000800002oooo0`0000;oool300005oooo`030000oooooooo
00;oool300001?ooo`030000oooo000000;oool00`000?ooooooo`0>oooo00<0003oooooool01ooo
o`800005oooo0`000003oooo0000oooo00Coool200000_ooo`8000000oooo`000000000;00000_oo
o`800009oooo00<0003oooooool01_ooo`030000oooooooo02Woool010000?ooo`00000000Goool0
0`000?ooo`000003000000Coool0000000000002oooo0`0001Soool010000?ooooooooooo`@00003
oooo00<0003oool000000oooo`030000oooooooo00koool00`000?ooooooo`07oooo00<0003ooooo
ool01?ooo`8000000oooo`0000000005oooo00@0003oooooooooool2000000?oool0000000002`00
00;oool200002Oooo`030000oooooooo00Koool00`000?ooooooo`0;oooo000Poooo00<0003ooooo
ool01P000005oooo0000oooooooo000000?oool200000oooo`<0000Coooo0P0000;oool300000ooo
o`030000oooo000000<000000oooo`000?ooo`09oooo100000Koool01@000?ooooooooooo`00000<
oooo0`000003oooo0000000000;oool200001?ooo`800004oooo0`000004oooo0000000000000_oo
o`8000000oooo`000000000300001Oooo`040000oooo000000001_ooo`030000oooooooo02Woool0
0`000?ooo`000005000000Goool0003oooooool000000oooo`800003oooo0`0001?oool200000ooo
o`800003oooo00<0003oooooool00`000003oooo0000oooo00[oool300001oooo`040000oooooooo
00003Oooo`8000001?ooo`000000000000;oool200001?ooo`800003oooo10000005oooo00000000
0000oooo00<000000oooo`000000000200001_ooo`040000oooo000000001_ooo`030000oooooooo
00_oool0023oool00`000?ooooooo`0600001Oooo`030000oooooooo00<00002oooo0`0001Coool0
10000?ooo`00000000;oool00`000?ooo`000003oooo0P0000?oool00`000?ooooooo`0Boooo0P00
00Koool00`000?ooooooo`04oooo00H0003oool00000003oool00003oooo00<0003oooooool00_oo
o`<00004oooo10000003oooo0000000000800005oooo00@0003oooooooooool400002_ooo`030000
oooooooo02Woool00`000?ooo`00000500001Oooo`8000001?ooo`000000000000;oool300005?oo
o`030000oooo0000008000001?ooo`000?ooo`0000Coool01@000?ooooooooooo`00000Eoooo00<0
003oooooool01Oooo`030000oooooooo00Coool010000?ooo`000?ooo`800003oooo00<0003ooooo
ool00_ooo`<00003oooo1@000004oooo0000000000001_ooo`040000oooooooooooo100000[oool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool01P0000Goool00`000?ooooooo`0300000_oo
o`<0000Doooo00@0003oool000000002oooo00<0003oool000000oooo`800003oooo00<0003ooooo
ool04_ooo`800006oooo00<0003oooooool01?ooo`060000oooo00000000oooo00000oooo`030000
oooooooo00;oool300001?ooo`@000000oooo`000000000200001Oooo`040000oooooooooooo1000
00[oool00`000?ooooooo`0Yoooo00<0003oool000001@0000Goool2000000Coool0000000000002
oooo0`0001Coool00`000?ooo`000002000000Coool0003oool00004oooo00D0003oooooooooool0
00005Oooo`030000oooooooo00Goool00`000?ooooooo`04oooo00@0003oool0003oool200000ooo
o`030000oooooooo00;oool300000oooo`D000001?ooo`000000000000Koool010000?oooooooooo
o`@0000:oooo00<0003oooooool02oooo`008?ooo`8000000oooo`000?ooo`06oooo00@0003ooooo
ool00002oooo0`0000;oool400000oooo`030000oooooooo00goool010000?ooo`00000000Coool0
0`000?ooooooo`04oooo00<0003oooooool02oooo`8000000oooo`000?ooo`04oooo0`000004oooo
0000oooo00000_ooo`800004oooo00<0003oooooool01Oooo`80000;oooo00<0003oool000000_oo
o`800002oooo00@0003oool000000006oooo0P000003oooo0000oooo00Soool00`000?ooooooo`0Y
oooo00<0003oool000001oooo`030000oooooooo008000001?ooo`000000000000;oool400000ooo
o`030000oooooooo00Coool500001?ooo`030000oooo000000800003oooo00<0003oooooool01?oo
o`030000oooooooo00coool00`000?ooo`000006oooo0P000005oooo00000000oooo000000;oool0
0`000?ooooooo`03oooo00<0003oooooool01Oooo`80000:oooo00@0003oooooool00002oooo0P00
0004oooo00000000oooo0P0000Koool2000000?oool0003oool01oooo`80000=oooo000Poooo00<0
003oooooool01P0000;oool400000_ooo`@000000oooo`000000000200001?ooo`030000oooooooo
00coool400000oooo`800002oooo00@0003oooooool00003oooo0P0000Goool00`000?ooooooo`0:
oooo0`0001Coool00`000?ooooooo`04oooo0P000004oooo0000000000000_ooo`8000000oooo`00
00000002oooo0`0000;oool01`000?ooooooooooo`000?ooo`00000;oooo00<0003oooooool0:Ooo
o`030000oooo000000D00002oooo1@000003oooo00000000008000000oooo`000000000200001?oo
o`800004oooo1@0000Coool500000_ooo`800003oooo00<0003oool000000oooo`<00004oooo00<0
003oooooool02oooo`80000Eoooo00<0003oooooool01?ooo`8000000oooo`0000000003oooo0P00
0004oooo00000000oooo100000;oool01`000?ooooooooooo`000?ooo`00000;oooo00<0003ooooo
ool02oooo`008?ooo`030000oooooooo00H00002oooo0P000003oooo0000oooo00;oool3000000?o
ool0000000000P0001Goool200000_ooo`X00003oooo00@0003oool000000005oooo00<0003ooooo
ool01oooo`<0000<oooo100000?oool200001?ooo`8000000oooo`000?ooo`0500000_ooo`030000
oooo000000800004oooo00@0003oool000000002oooo00<0003oooooool01_ooo`050000oooooooo
oooo000002_oool00`000?ooo`00000500000_ooo`8000000oooo`0000000002oooo0`000003oooo
000000000080000:oooo1@0000Koool3000000?oool000000000200000Coool00`000?ooo`000006
oooo00<0003oooooool01oooo`80000=oooo0`0000Coool200000oooo`<000000oooo`000?ooo`05
00000_ooo`040000oooo000000001Oooo`030000oooo000000?oool00`000?ooooooo`06oooo00D0
003oooooooooool000003Oooo`008?ooo`030000oooooooo00H00002oooo2P0000;oool3000000?o
ool0003oool01oooo`030000oooooooo00Soool200001oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo0`000003oooo0000000000;oool01@000?ooooooooooo`000006oooo0P0000Coool0
10000?ooo`00000000;oool200001oooo`8000000oooo`000?ooo`03oooo00@0003oooooooooool6
00000oooo`800009oooo00<0003oooooool00oooo`030000oooooooo02Woool00`000?ooo`000005
00000_ooo`X00003oooo0P000003oooo0000oooo00Ooool00`000?ooooooo`08oooo0`0000Ooool0
0`000?ooooooo`06oooo00<0003oooooool01Oooo`8000000oooo`0000000003oooo00@0003ooooo
ool00007oooo00<0003oooooool00oooo`030000oooo000000?oool200001oooo`8000000oooo`00
0?ooo`03oooo00@0003oooooooooool600000oooo`030000oooooooo00Soool00`000?ooooooo`03
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo00H00002oooo100000;oool010000?oo
o`00000000;oool300000_ooo`040000oooooooooooo0P0000;oool00`000?ooooooo`08oooo0P00
00Koool200002?ooo`030000oooooooo00Koool3000000Koool000000000003oool00006oooo00<0
003oooooool00P0000Koool200000_ooo`030000oooooooo00Koool300001_ooo`800009oooo00<0
003oooooool02oooo`050000oooooooooooo000002_oool00`000?ooo`00000500000_ooo`D00000
0oooo`000?ooo`0200000oooo`800002oooo00<0003oooooool00_ooo`040000oooooooo00002_oo
o`<00005oooo0`0000Soool00`000?ooooooo`06oooo0P000003oooo00000000008000000oooo`00
0?ooo`05oooo00@0003oooooool00007oooo00D0003oooooooooool000002?ooo`<00006oooo0P00
00Woool00`000?ooooooo`0;oooo00D0003oooooooooool000003Oooo`008?ooo`030000oooooooo
00H00003oooo1`000004oooo00000000oooo100000?oool010000?ooo`00000000coool00`000?oo
ooooo`05oooo00<0003oooooool03?ooo`050000oooooooooooo000000?oool2000000Coool0003o
ooooool200000oooo`040000oooooooo00001oooo`<000000oooo`000000000Eoooo0P0000Koool2
00002_ooo`030000oooooooo00;oool00`000?ooooooo`0Yoooo00<0003oool000001@0000?oool7
000000?oool0000000000_ooo`<00003oooo0P000003oooo0000oooo00_oool00`000?ooooooo`05
oooo00<0003oooooool03?ooo`030000oooooooo00;oool00`000?ooooooo`0200000_ooo`040000
oooooooo00001?ooo`040000oooooooo00001oooo`8000001?ooo`000000000001Goool00`000?oo
ooooo`05oooo00<0003oooooool02Oooo`030000oooooooo00;oool00`000?ooooooo`0;oooo000P
oooo0P000003oooo0000000000@00002oooo200000Coool400000oooo`@00003oooo00<0003ooooo
ool00P0000;oool010000?ooooooo`0000?oool00`000?ooooooo`09oooo0`0000;oool010000?oo
o`00000000;oool400001?ooo`<00003oooo00@0003oooooool0000:oooo00<0003oool000000P00
01_oool200002_ooo`030000oooooooo00;oool00`000?ooooooo`0Yoooo00<0003oool000001@00
00;oool800001Oooo`<00003oooo100000?oool01@000?ooooooooooo`000002oooo00<0003ooooo
ool00P0000;oool00`000?ooooooo`09oooo10000003oooo0000oooo00<00002oooo0`0000Goool2
00001?ooo`040000oooooooo00002Oooo`030000oooooooo00<0000Koooo00<0003oooooool02Ooo
o`040000oooooooooooo0P0000goool0023oool00`000?ooooooo`0600000_ooo`L00007oooo0P00
00Soool01@000?ooooooooooo`000007oooo00D0003oooooooooool000002_ooo`<000001?ooo`00
0000000000;oool00`000?ooooooo`04oooo1@0000;oool2000000Goool0003oooooool000002?oo
o`80000Loooo00@0003oooooooooool2000000?oool0003oool01_ooo`030000oooooooo00?oool0
0`000?ooooooo`0Yoooo00<0003oool000001@0000;oool700001oooo`800008oooo00<0003ooooo
ool00_ooo`030000oooooooo00Coool200000_ooo`030000oooooooo00Soool4000000?oool00000
00000_ooo`800005oooo1P000003oooo0000000000;oool010000?ooooooo`0000Soool00`000?oo
ooooo`0Koooo00D0003oooooooooool000000_ooo`030000oooooooo00Goool00`000?ooooooo`03
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo00H00002oooo1`0000Ooool200002?oo
o`050000oooooooooooo000000Ooool01@000?ooooooooooo`00000:oooo0`000004oooo00000000
00000_ooo`030000oooooooo00Coool500000_ooo`8000001Oooo`000?ooooooo`000008oooo0P00
01coool010000?ooooooooooo`8000000oooo`000?ooo`06oooo00<0003oooooool00oooo`030000
oooooooo02Woool00`000?ooo`00000500000_ooo`L00007oooo0P0000Soool00`000?ooooooo`02
oooo00<0003oooooool01?ooo`800002oooo00<0003oooooool02?ooo`@000000oooo`0000000002
oooo0P0000Goool6000000?oool0000000000_ooo`040000oooooooo00002?ooo`030000oooooooo
01_oool01@000?ooooooooooo`000002oooo00<0003oooooool01Oooo`030000oooooooo00?oool0
0`000?ooooooo`0;oooo000Eoooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool01P00
00;oool700003Oooo`030000oooooooo00Goool300001Oooo`050000oooooooooooo000000Woool2
00000oooo`@00003oooo10000004oooo0000oooooooo1P000005oooo0000oooooooo000000Koool4
00007?ooo`030000oooooooo00Koool00`000?ooooooo`09oooo00<0003oooooool07_ooo`800004
oooo00<0003oooooool00_ooo`030000oooo000000D00002oooo1`0000koool00`000?ooooooo`05
oooo0P0000Goool200000_ooo`030000oooooooo00Ooool200001?ooo`<00004oooo0`000003oooo
0000oooo00;oool500000_ooo`040000oooooooo00001_ooo`<0000Moooo00<0003oooooool01_oo
o`030000oooooooo00Woool00`000?ooooooo`0;oooo000Eoooo00<0003oool000000_ooo`030000
oooo000000?oool00`000?ooooooo`0Ooooo0P0000;oool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oooooool00oooo`800004oooo10000003oooo0000000000P00004oooo00<0003oool0
00001P0000?oool00`000?ooooooo`02oooo0P0002Coool010000?ooooooo`0000?oool00`000?oo
ooooo`03oooo0P0000?oool00`000?ooooooo`0Noooo00<0003oool000000_ooo`030000oooo0000
00?oool00`000?ooooooo`0Noooo0P0000;oool200000_ooo`030000oooo000000;oool200001?oo
o`800004oooo100000;oool:00000oooo`030000oooooooo00H00004oooo00@0003oooooooooool3
00009?ooo`040000oooo000000000oooo`030000oooooooo00?oool200000oooo`030000oooooooo
00_oool001Goool00`000?ooo`000002oooo00<0003oool000000oooo`80000Toooo00<0003oool0
00000P000003oooo0000oooo00Goool00`000?ooo`000002oooo1P0000;oool=000000?oool00000
00000P000003oooo0000000000800003oooo100002[oool700001?ooo`030000oooooooo0080000P
oooo00<0003oool000000_ooo`030000oooo000000?oool00`000?ooooooo`0Roooo0P000005oooo
00000000oooo000000Koool00`000?ooo`000003oooo1@0000?oool<000000?oool0000000000`00
0004oooo0000000000001?ooo`<0000Zoooo200000Coool00`000?ooooooo`0200003Oooo`005Ooo
o`800003oooo00<0003oool000000oooo`030000oooooooo02Soool00`000?ooo`000005oooo00<0
003oooooool00_ooo`030000oooooooo008000000oooo`000000000=000000?oool0000000000P00
0003oooo0000000000800002oooo0P0003;oool600001?ooo`030000oooooooo01koool200000ooo
o`030000oooo000000?oool00`000?ooooooo`0Woooo00<0003oool000001Oooo`030000oooooooo
00?oool01@000?ooo`0000000?ooo`0?000000?oool0000000000`000004oooo0000000000000ooo
o`80000boooo1P0000Coool00`000?ooooooo`0;oooo000Eoooo00<0003oooooool00_ooo`030000
oooo000000?oool00`000?ooooooo`0Yoooo00@0003oool000000004oooo00D0003oooooooooool0
00000_ooo`030000oooo0000014000001?ooo`0000000?ooo`@00002oooo0P0002Ooool300001_oo
o`040000oooooooo00000_ooo`030000oooo000000?oool00`000?ooooooo`0Noooo00<0003ooooo
ool00_ooo`030000oooo000000?oool00`000?ooooooo`0Xoooo00<0003oool000000P0000?oool0
0`000?ooooooo`02oooo00@0003oool0003ooolB00000_ooo`8000001?ooo`000000000000?oool2
00009oooo`<00006oooo00@0003oooooool00002oooo00<0003oool000000oooo`030000oooooooo
00_oool001Koool200000oooo`030000oooooooo00;oool00`000?ooooooo`0Zoooo00<0003ooooo
ool01Oooo`H000000oooo`000000000A000000?oool0003oool01@0000;oool00`000?ooooooo`0]
oooo00<0003oool000002oooo`030000oooooooo01ooool200000oooo`030000oooooooo00;oool0
0`000?ooooooo`0Yoooo00<0003oooooool01Oooo`H000000oooo`000000000A00000_ooo`030000
oooo000000<00003oooo00<0003oooooool0;Oooo`030000oooo000000_oool00`000?ooooooo`0;
oooo000Poooo00<0003oooooool0;?ooo`060000oooooooooooo0000oooo8P000003oooo0000oooo
033oool00`000?ooooooo`0:oooo00<0003oooooool0:Oooo`030000oooooooo02_oool200000_oo
o`030000oooo000002400002oooo00<0003oooooool0;oooo`030000oooooooo00[oool00`000?oo
ooooo`0;oooo000Poooo00<0003oooooool0;?ooo`060000oooooooooooo0000oooo8P000003oooo
0000oooo033oool00`000?ooooooo`0:oooo00<0003oooooool0:Oooo`030000oooooooo02_oool2
00000_ooo`030000oooo000002400002oooo00<0003oooooool0;oooo`030000oooooooo00[oool0
0`000?ooooooo`0;oooo000Poooo0P00037oool200000_ooob80000noooo00<0003oooooool0:Ooo
o`030000oooooooo02ooool200000_ooob<0000moooo0P0000goool0023oool00`000?ooooooo`0b
oooo00<0003oool00000800003ooool00`000?ooooooo`0Yoooo00<0003oooooool0<Oooo`030000
oooo00000240000ooooo00<0003oooooool02oooo`008?ooo`030000oooooooo037oool010000?oo
o`000?oooah00011oooo00<0003oooooool0:Oooo`030000oooooooo033oool00`000?ooo`000002
oooo7@0004;oool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0<Oooo`030000oooo0000
01h00012oooo00<0003oooooool0:Oooo`030000oooooooo033oool00`000?ooo`00000N0000@ooo
o`030000oooooooo00_oool0023oool00`000?ooooooo`0`oooo0P0000;ooolN0000@_ooo`030000
oooooooo02Woool00`000?ooooooo`0_oooo0P0000;ooolN0000@oooo`030000oooooooo00_oool0
023oool00`000?ooooooo`0coooo7@0004Coool00`000?ooooooo`0Yoooo00<0003oooooool0<_oo
oah00014oooo00<0003oooooool02oooo`008?ooo`80000coooo700004Koool00`000?ooooooo`0Y
oooo00<0003oooooool0<Ooooad00015oooo0P0000goool0023oool00`000?ooooooo`0doooo6@00
04Ooool00`000?ooooooo`0Yoooo00<0003oooooool0<ooooaX00017oooo00<0003oooooool02ooo
o`008?ooo`030000oooooooo03CooolI0000Aoooo`030000oooooooo02Woool00`000?ooooooo`0c
oooo6P0004Ooool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0=?oooaX00016oooo00<0
003oooooool0:Oooo`030000oooooooo03?ooolK0000A_ooo`030000oooooooo00_oool0023oool0
0`000?ooooooo`0boooo200000?ooolB0000AOooo`030000oooooooo02Woool00`000?ooooooo`0a
oooo200000CooolB0000AOooo`030000oooooooo00_oool0023oool20000<oooo`P00004oooo4P00
04Coool00`000?ooooooo`0Yoooo00<0003oooooool0<Oooo`P00005oooo4P0004?oool200003Ooo
o`008?ooo`030000oooooooo037oool<00000_ooo`8000000oooo`000000000<0000A?ooo`030000
oooooooo02Woool00`000?ooooooo`0`oooo3@0000;oool00`000?ooo`00000>0000A?ooo`030000
oooooooo00_oool0023oool00`000?ooooooo`0aoooo3P0000Coool7000000?oool0000000001@00
04;oool00`000?ooooooo`0Yoooo00<0003oooooool0<?ooo`l00003oooo1`000003oooo00000000
00D00013oooo00<0003oooooool02oooo`008?ooo`030000oooooooo02goool900000_ooo`800002
oooo5P0004;oool00`000?ooooooo`0Yoooo00<0003oooooool0;Oooo`T000000oooo`0000000002
oooo5P0004?oool00`000?ooooooo`0;oooo000Foooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0^oooo1`000003oooo00000000008000000oooo`000000000<000000?o
ool0000000002000043oool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0^oooo1`000005oooo000000000000oooo00h000000oooo`0000000008
0000@Oooo`030000oooooooo00_oool001Goool00`000?ooo`000002oooo00<0003oool000000ooo
o`030000oooooooo02koool800000oooo`P00003oooo4000043oool00`000?ooooooo`0Noooo00<0
003oool000000_ooo`030000oooo000000?oool00`000?ooooooo`0^oooo200000;oool800000ooo
oa000011oooo00<0003oooooool02oooo`005Oooo`030000oooo000000;oool00`000?ooo`000003
oooo0P0002ooool800000oooo`P00003oooo400003ooool200008?ooo`030000oooo000000;oool0
0`000?ooo`000003oooo00<0003oooooool0;_ooo`P00002oooo200000?oool@0000@?ooo`80000=
oooo000Foooo00L0003oooooooooool0003oool000000oooo`030000oooooooo02goool7000000Oo
ool000000000003oool0003oool00`0000?ooolC0000@?ooo`030000oooooooo01ooool01`000?oo
ooooooooo`000?ooo`000003oooo00<0003oooooool0;Oooo`H00002oooo0P000003oooo0000oooo
00@00002oooo4`00047oool00`000?ooooooo`0;oooo000Eoooo00<0003oool000000_ooo`030000
oooo000000?oool00`000?ooooooo`0/oooo20000004oooo0000000000000_ooo`030000oooooooo
00d000000oooo`00000000070000@?ooo`030000oooooooo01koool00`000?ooo`000002oooo00<0
003oool000000oooo`030000oooooooo02_oool800000_ooo`800002oooo00@0003oooooooooool<
000000?oool0000000001`00047oool00`000?ooooooo`0;oooo000Foooo00<0003oooooool00_oo
o`030000oooooooo00;oool00`000?ooooooo`0/oooo2P0000;oool00`000?ooooooo`08oooo00<0
003oooooool03`0003ooool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0[oooo2`000003oooo0000oooo00Woool010000?ooooooooooo`l0000o
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo02coool00`000?ooo`00000600001?oo
o`030000oooooooo00;oool3000000?oool0000000000`0000;oool<0000?oooo`030000oooooooo
02Woool00`000?ooooooo`0[oooo0P000003oooo0000000000D00003oooo00<0003oooooool00ooo
o`8000000oooo`0000000004000000?oool0000000002`0003ooool00`000?ooooooo`0;oooo000P
oooo00<0003oooooool0;?ooo`P000000oooo`000?ooo`07oooo1`0000;oool2000000?oool00000
00002@0003ooool00`000?ooooooo`0Yoooo00<0003oooooool0:oooo`P00002oooo00<0003ooooo
ool01_ooo`L00002oooo00<0003oool000002`0003ooool00`000?ooooooo`0;oooo000Poooo0P00
02coool8000000?oool0000000000`000003oooo0000oooo00d000000oooo`00000000090000?ooo
o`030000oooooooo02Woool00`000?ooooooo`0Zoooo20000003oooo0000000000<000000oooo`00
0?ooo`0=000000?oool0000000002P0003koool200003Oooo`008?ooo`030000oooooooo02_oool8
00000oooo`<00002oooo00<0003oool000002`000003oooo0000000000T0000ooooo00<0003ooooo
ool0:Oooo`030000oooooooo02[oool800001?ooo`800002oooo00<0003oooooool02`000003oooo
0000000000X0000ooooo00<0003oooooool02oooo`008?ooo`030000oooooooo02_oool800000ooo
o`<00002oooo00<0003oool000002`000003oooo0000000000T0000ooooo00<0003oooooool0:Ooo
o`030000oooooooo02[oool800001?ooo`800002oooo00<0003oooooool02`000003oooo00000000
00X0000ooooo00<0003oooooool02oooo`008?ooo`030000oooooooo02_oool600001oooo`040000
oooooooo00000_ooo`030000oooooooo00<000000oooo`000?ooo`03oooo0`000003oooo00000000
00D0000ooooo00<0003oooooool0:Oooo`030000oooooooo02[oool600001oooo`040000oooooooo
00000oooo`030000oooo000000800002oooo00@0003oooooooooool4000000?oool0000000001@00
03ooool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0;?ooo`H00008oooo00@0003ooooo
ool00004oooo0`0000[oool60000?oooo`030000oooooooo02Woool00`000?ooooooo`0[oooo1P00
00Soool01@000?ooooooooooo`000003oooo100000[oool60000?oooo`030000oooooooo00_oool0
023oool20000;Oooo`H00003oooo1P0000;oool01@000?ooo`0000000?ooo`03000000?oool00000
00001@0000;oool50000@?ooo`030000oooooooo02Woool00`000?ooooooo`0[oooo1P0000Coool5
00000oooo`040000oooo0000oooo10000003oooo0000000000D00002oooo1000043oool200003Ooo
o`008?ooo`030000oooooooo02_oool500001Oooo`030000oooooooo00@00006oooo0P000003oooo
0000000000H00002oooo1@00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`D00006
oooo00<0003oool000000`0000Koool200000_ooo`P00002oooo1000047oool00`000?ooooooo`0;
oooo000Poooo00<0003oooooool0;?oooa000007oooo0`000003oooo0000000000/00010oooo00<0
003oooooool0:Oooo`030000oooooooo02_oool@00001oooo`@000000oooo`000000000:0000@Ooo
o`030000oooooooo00_oool0023oool00`000?ooooooo`0[oooo1P000003oooo0000000000X00005
oooo4@00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`H000000oooo`000000000;
00001?oooa400011oooo00<0003oooooool02oooo`008?ooo`030000oooooooo02_oool9000000Co
ool0003oooooool700000ooooa800010oooo00<0003oooooool0:Oooo`030000oooooooo02[oool9
00000_ooo`030000oooo000000L00002oooo4P00047oool00`000?ooooooo`0;oooo000Poooo00<0
003oooooool0:oooo`800004oooo1@0000Coool500000oooo`@000000oooo`0000000002000000?o
ool0000000001P00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`<00003oooo1P00
00?oool600000_ooo`D000001Oooo`00000000000?ooo`080000@Oooo`030000oooooooo00_oool0
023oool20000;?ooo`800004oooo1@0000Coool500000oooo`@000000oooo`0000000002000000?o
ool0000000001P00043oool00`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`<00003oooo1P00
00?oool600000_ooo`D000001Oooo`00000000000?ooo`080000@?ooo`80000=oooo000Poooo00<0
003oooooool0:oooo`030000oooooooo00?oool010000?ooo`000?ooo`<00003oooo6@00043oool0
0`000?ooooooo`0Yoooo00<0003oooooool0:_ooo`030000oooooooo00?oool00`000?ooo`000002
oooo0P0000?ooolI0000@Oooo`030000oooooooo00_oool0023oool00`000?ooooooo`0[oooo00<0
003oooooool01?ooo``00005oooo3`000003oooo0000oooo03ooool00`000?ooooooo`0Yoooo00<0
003oooooool0:_ooo`030000oooooooo00Coool=00001?ooo`l000000oooo`000?ooo`10oooo00<0
003oooooool02oooo`008?ooo`030000oooooooo02coool01`000?ooooooooooo`000?ooo`000003
oooo0P000003oooo0000000000<000000oooo`0000000002oooo1`0000Coool010000?oooooooooo
o`800010oooo00<0003oooooool0:Oooo`030000oooooooo02_oool200000_ooo`030000oooo0000
00Coool00`000?ooo`000005000000Coool0003oooooool700001Oooo`030000oooooooo00800011
oooo00<0003oooooool02oooo`003oooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo
00;oool00`000?ooooooo`0/oooo0P0000_oool00`000?ooooooo`09oooo0P0000;oool00`000?oo
ooooo`06oooo00<0003oooooool0?oooo`030000oooooooo01Soool500000_ooo`030000oooooooo
00;oool00`000?ooooooo`02oooo00<0003oooooool0:oooo`<0000:oooo00<0003oooooool02_oo
o`8000000oooo`000?ooo`07oooo00<0003oooooool0@?ooo`030000oooooooo00_oool0017oool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`030000oooooooo037oool0
0`000?ooooooo`08oooo00<0003oooooool01oooo`040000oooooooo00000_ooo`040000oooooooo
00000_ooo`030000oooooooo03ooool00`000?ooooooo`0Joooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000000?oool00`000?ooooooo`0`oooo00<0003oooooool02?ooo`800009
oooo00<0003oool000000_ooo`800002oooo00<0003oool00000@_ooo`030000oooooooo00_oool0
017oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`80000^oooo0`00
01[oool2000000?oool0003oool00`00047oool200007?ooo`070000oooooooooooo0000oooo0000
00;oool00`000?ooo`000003oooo00<0003oooooool0;Oooo`80000Joooo0P0000;oool010000?oo
o`00000004;oool200003Oooo`004Oooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`000003oooo00<0003oooooool0>?ooo`030000oooooooo00Woool200001Oooo`030000oooooooo
04Koool00`000?ooooooo`0Joooo00L0003oooooooooool0003oool000000_ooo`030000oooo0000
00?oool00`000?ooooooo`0goooo00<0003oooooool02Oooo`<00004oooo00<0003oooooool0Aooo
o`030000oooooooo00_oool0017oool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00000oooo`030000oooooooo03Soool00`000?ooooooo`09oooo0P0000Goool00`000?ooooooo`16
oooo00<0003oooooool06_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000003
oooo00<0003oooooool0=oooo`030000oooooooo00Woool300001?ooo`030000oooooooo04Ooool0
0`000?ooooooo`0;oooo000@oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00_oo
o`030000oooooooo033oool00`000?ooooooo`0Doooo0P000006oooo0000oooo0000oooo0000AOoo
o`030000oooooooo01Woool200001?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0
003oooooool0;oooo`030000oooooooo01Goool010000?ooo`000?ooo`8000000oooo`000?ooo`14
oooo00<0003oooooool02oooo`008?ooo`030000oooooooo037oool400005_ooo`<00016oooo00<0
003oooooool0:Oooo`030000oooooooo033oool500005Oooo`@00016oooo00<0003oooooool02ooo
o`008?ooo`80000coooo0P0000Soool00`000?ooooooo`03oooo0`000007oooo0000oooooooo0000
oooo000004Soool00`000?ooooooo`0Yoooo00<0003oooooool0<Oooo`800008oooo0P0000Coool4
000000Koool0003oool0003oool00018oooo0P0000goool0023oool00`000?ooooooo`0eoooo00@0
003oooooool00006oooo1@0000?oool30000B_ooo`030000oooooooo02Woool00`000?ooooooo`0e
oooo00<0003oool000001oooo`@00004oooo0P0004_oool00`000?ooooooo`0;oooo000Poooo00<0
003oooooool0=_ooo`800004oooo00<0003oooooool01?ooo`030000oooooooo04koool00`000?oo
ooooo`0Yoooo00<0003oooooool0=_ooo`030000oooooooo00;oool200001Oooo`030000oooooooo
04ooool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0U?ooo`030000oooooooo02Woool0
0`000?ooooooo`2Doooo00<0003oooooool02oooo`008?ooo`030000oooooooo09Coool00`000?oo
ooooo`0Yoooo00<0003oooooool0U?ooo`030000oooooooo00_oool0023oool00`000?ooooooo`2D
oooo00<0003oooooool0:Oooo`030000oooooooo09Coool00`000?ooooooo`0;oooo000Poooo0P00
09Goool00`000?ooooooo`0Yoooo00<0003oooooool0Toooo`80000=oooo000Poooo00<0003ooooo
ool0U?ooo`030000oooooooo02Woool00`000?ooooooo`2Doooo00<0003oooooool02oooo`008?oo
o`030000oooooooo09Coool00`000?ooooooo`0Yoooo00<0003oooooool0U?ooo`030000oooooooo
00_oool0023oool00`000?ooooooo`2Doooo00<0003oooooool0:Oooo`030000oooooooo09Coool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool0U?ooo`030000oooooooo02Woool00`000?oo
ooooo`2Doooo00<0003oooooool02oooo`008?ooo`030000oooooooo09Coool00`000?ooooooo`0Y
oooo00<0003oooooool0U?ooo`030000oooooooo00_oool0023oool20000UOooo`030000oooooooo
02Woool00`000?ooooooo`2Coooo0P0000goool0023oool00`000?ooooooo`2Doooo00<0003ooooo
ool0:Oooo`030000oooooooo09Coool00`000?ooooooo`0;oooo000Poooo00<0003oooooool0U?oo
o`030000oooooooo02Woool00`000?ooooooo`2Doooo00<0003oooooool02oooo`003oooo`D00000
1?ooo`000000000000?oool00`000?ooooooo`02oooo00<0003oooooool0U?ooo`030000oooooooo
01Soool5000000Coool0000000000003oooo00<0003oooooool00_ooo`030000oooooooo09Coool0
0`000?ooooooo`0;oooo000Aoooo00D0003oooooooooool000001?ooo`030000oooo000000?oool0
0`000?ooooooo`06oooo00<0003oooooool0Roooo`030000oooooooo01[oool01@000?oooooooooo
o`000004oooo00<0003oool000000oooo`030000oooooooo00Goool00`000?ooooooo`2<oooo00<0
003oooooool02oooo`004Oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000003
oooo0P0000Soool00`000?ooooooo`29oooo0P0001coool00`000?ooooooo`02oooo00L0003ooooo
ooooool0003oool000000oooo`030000oooooooo00Koool00`000?ooooooo`2:oooo0P0000goool0
017oool00`000?ooooooo`02oooo00L0003oooooooooool0003oool000000oooo`030000oooooooo
09Coool00`000?ooooooo`0Joooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo0000
00?oool00`000?ooooooo`2Doooo00<0003oooooool02oooo`004Oooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000003oooo00<0003oooooool01Oooo`030000oooooooo08coool0
0`000?ooooooo`0Joooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool0
0`000?ooooooo`04oooo00<0003oooooool0SOooo`030000oooooooo00_oool0013oool200001?oo
o`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool00P0008Soool00`000?oo
ooooo`07oooo00<0003oooooool06Oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
00;oool010000?ooo`00000008Woool00`000?ooooooo`07oooo00<0003oooooool02oooo`008?oo
o`030000oooooooo00?oool200001Oooo`030000oooooooo00Goool00`000?ooooooo`1ooooo00<0
003oooooool0:Oooo`030000oooooooo00;oool200001Oooo`030000oooooooo00Goool00`000?oo
ooooo`20oooo00<0003oooooool02oooo`008?ooo`030000oooooooo00;oool300002_ooo`030000
oooo000000Ooool010000?ooo`000?ooo`80001eoooo00<0003oooooool0:Oooo`040000oooooooo
oooo0`0000[oool00`000?ooo`000007oooo00H0003oool00000003oool0001foooo00<0003ooooo
ool02oooo`008?ooo`800003oooo0`0000[oool00`000?ooo`000007oooo00@0003oool0003oool2
0000MOooo`030000oooooooo02Woool010000?ooooooooooo`<0000:oooo00<0003oool000001ooo
o`060000oooo00000000oooo0000MOooo`80000=oooo000Poooo00<0003oooooool01Oooo`030000
oooo000000800004oooo00<0003oool000002Oooo`030000oooooooo07Ooool00`000?ooooooo`0Y
oooo00<0003oooooool01?ooo`030000oooo000000800004oooo00<0003oool000002Oooo`030000
oooooooo07Soool00`000?ooooooo`0;oooo000Poooo00<0003oooooool02@0000;oool00`000?oo
ooooo`03oooo00<0003oooooool05?ooo`030000oooooooo00_oool300002?ooo`030000oooooooo
00ooool00`000?ooooooo`05oooo00D0003oooooooooool000003?ooo`030000oooooooo00coool2
00005oooo`030000oooooooo02Woool00`000?ooo`00000800000_ooo`800004oooo00<0003ooooo
ool05?ooo`030000oooooooo00coool200002?ooo`030000oooooooo00ooool00`000?ooooooo`05
oooo00<0003oooooool00_ooo`030000oooooooo00Woool200003_ooo`030000oooooooo01Koool0
0`000?ooooooo`0;oooo000Poooo00<0003oooooool00`0000;oool00`000?ooo`00000200001?oo
o`030000oooooooo00Ooool00`000?ooooooo`02oooo0P0001;oool00`000?ooooooo`0Roooo00<0
003oooooool02_ooo`030000oooooooo02Goool00`000?ooooooo`06oooo00<0003oooooool0:Ooo
o`030000oooo000000800002oooo00<0003oool000000P0000Coool00`000?ooooooo`07oooo00<0
003oooooool00oooo`030000oooooooo013oool00`000?ooooooo`0Soooo00<0003oooooool02Ooo
o`030000oooooooo02Koool00`000?ooooooo`06oooo00<0003oooooool02oooo`008?ooo`030000
oooooooo09Coool00`000?ooooooo`0Yoooo00<0003oooooool0U?ooo`030000oooooooo00_oool0
023oool010000?ooooooo`0001Koool00`000?ooooooo`0Coooo00<0003oooooool05?ooo`030000
oooooooo01Coool00`000?ooooooo`0Doooo00<0003oooooool04oooo`030000oooooooo00Woool0
0`000?ooooooo`0Yoooo00<0003oool000005_ooo`030000oooooooo01Coool00`000?ooooooo`0D
oooo00<0003oooooool04oooo`030000oooooooo01Coool00`000?ooooooo`0Doooo00<0003ooooo
ool02Oooo`030000oooooooo00_oool0023ooonH0000:ooooiP0000=oooo003oooooROooo`00oooo
ohWoool00?oooon9oooo003oooooROooo`00Hoooo`<0002ooooo0`00063oool006Coool00`000?oo
ooooo`2ooooo00<0003oooooool0Goooo`00??ooo`@00002oooo100000;oool300002_ooo`<00002
oooo1@000005oooo0000oooo0000oooo00<00002oooo0`0000?oool200003Oooo`<00002oooo0`00
0004oooo0000oooooooo0P0000?oool200000oooo`80001Xoooo100000;oool400000_ooo`<0000:
oooo0`0000;oool5000000Goool0003oool0003oool00`0000;oool300000oooo`80000=oooo0`00
00;oool3000000Coool0003oooooool200000oooo`800003oooo0P00033oool003goool01@000?oo
ooooo`000?ooo`0300000_ooo`040000oooooooo00002_ooo`030000oooo000000;oool3000000So
ool0003oool0003oool0003oool00002oooo00@0003oooooool00003oooo00<0003oooooool03_oo
o`030000oooooooo00;oool01P000?ooooooo`000?ooo`0000;oool00`000?ooo`000002oooo00<0
003oool000000_ooo`030000oooooooo06Koool01@000?ooooooo`000?ooo`0300000_ooo`040000
oooooooo00002_ooo`030000oooo000000;oool3000000Soool0003oool0003oool0003oool00002
oooo00@0003oooooool00003oooo00<0003oooooool03_ooo`030000oooooooo00;oool01P000?oo
ooooo`000?ooo`0000;oool00`000?ooo`000002oooo00<0003oool000000_ooo`030000oooooooo
02goool003goool010000?ooooooo`0000?oool010000?ooooooo`0000;oool00`000?ooooooo`0:
oooo00<0003oooooool00_ooo`090000oooo0000oooo0000oooo0000oooo000000;oool010000?oo
ooooo`0000?oool300003_ooo`<00002oooo00H0003oooooool0003oool00002oooo00<0003oool0
00001?ooo`040000oooooooo0000J?ooo`040000oooooooo00000oooo`040000oooooooo00000_oo
o`030000oooooooo00[oool00`000?ooooooo`02oooo00T0003oool0003oool0003oool0003oool0
00000_ooo`040000oooooooo00000oooo`<0000>oooo0`0000;oool01P000?ooooooo`000?ooo`00
00;oool00`000?ooo`000004oooo00@0003oooooool0000_oooo000moooo0`0000?oool200000ooo
o`<0000;oooo00<0003oooooool00_ooo`8000001_ooo`0000000?ooo`000?ooo`@00003oooo00@0
003oooooooooool300003_ooo`050000oooooooo0000oooo00<00003oooo0P000003oooo00000000
00800003oooo0P0006Woool300000oooo`800003oooo0`0000_oool00`000?ooooooo`02oooo0P00
0006oooo00000000oooo0000oooo100000?oool010000?ooooooooooo`<0000>oooo00D0003ooooo
ool0003oool00`0000?oool2000000?oool0000000000P0000?oool20000<?ooo`00?Oooo`040000
oooooooo00002Oooo`030000oooooooo00Soool00`000?ooo`00000Boooo00<0003oooooool04_oo
o`060000oooooooo0000oooo00002Oooo`030000oooooooo06koool010000?ooooooo`0000Woool0
0`000?ooooooo`08oooo00<0003oool000004_ooo`030000oooooooo01;oool01P000?ooooooo`00
0?ooo`0000Woool00`000?ooooooo`0eoooo000loooo100000Woool200002_ooo`<0000Aoooo0P00
01?oool4000000?oool000000000NOooo`@00009oooo0P0000[oool300004Oooo`80000Coooo1000
0003oooo00000000047oool00?oooon9oooo003oooooROooo`00ooooohWoool00?oooon9oooo003o
ooooROooo`00ooooohWoool00?oooon9oooo0000\
\>"],
  ImageRangeCache->{{{0, 391}, {185.625, 0}} -> {-0.0532081, -0.0238146, 
  0.00538726, 0.00538726}, {{9.875, 186.625}, {181.188, 
  4.375}} -> {-31.2292, -16.0587, 0.880674, 0.880674}, {{204.313, 381.125}, {
  181.188, 4.375}} -> {-202.493, -16.0587, 0.880674, 0.880674}}]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", "  ", 
      StyleBox["Discrete",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Fourier",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(SampleFourier = Chop[Abs[Fourier[sample]]]; \)\)], "Input"],

Cell[BoxData[
    \(\(BadSampleFourier = Chop[Abs[Fourier[bsample]]]; \)\)], "Input"],

Cell["\<\
filterMatrix=
imageNormalize[BadSampleFourier]-imageNormalize[SampleFourier];\
\>", "Input",
  FormatType->InputForm],

Cell["defectSpect=filterMatrix Fourier[bsample];", "Input",
  FormatType->InputForm],

Cell["\<\
defectPosition=imageNormalize[Chop[InverseFourier[defectSpect]]];\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False]\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Identified) show
129.000000 13.000000 moveto
(Defect) show
165.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0017oool0
0`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Boooo00<0
003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000oooo
o`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`003?ooo`<00003oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`003?ooo`030000oooooooo00;oool00`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000=oooo00L0003oooooooooool0003oool000001?oo
o`<0003noooo0`0000Coool000goool01`000?ooooooooooo`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool2
0000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`003Oooo`<00002oooo00<0003oooooool00ooo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003_ooo`060000oooooooo0000oooo
00001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?ooo`@000001?ooo`00
0?ooo`0000Coool30000o_ooo`<00004oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool200000_ooo`030000
oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000koool01@000?oo
ooooooooo`000005oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`0l
oooo10000<3oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0??ooo`@00030oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo03[oool80000__ooo`030000oooooooo00;oool0
01Soool20000>oooo`P0002moooo0P0000Coool001Soool00`000?ooooooo`0joooo20000;koool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0>_ooo`P0002noooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo03[oool80000__ooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`0joooo20000;koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0??ooo`@00030
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo03coool40000`?ooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?ooo`800004
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?oo
o`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool30000o_ooo`<00004
oooo000<oooo0P0000?oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000<oooo00<0003oooooool00_ooo`030000oooo000000Coool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool000goool200000oooo`030000oooooooo00?oool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000ooooo`7oool2
00001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool00`000?oo
ooooo`02oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo000000Coool30000o_oo
o`<00004oooo000=oooo00L0003oooooooooool0003oool000001?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000=oooo00<0003oooooool00_ooo`030000
oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Ooo
o`800004oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1
oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool000Koool500000_ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo0008oooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000Soool0
1`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`<0003noooo0`0000Coool0
00Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`002?ooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0007oooo0P00
00Coool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`001_ooo`D000001?ooo`000000000000?oool0
0`000?ooooooo`03oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0008oooo00D0
003oooooooooool000001?ooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool000Soool00`000?ooooooo`02oooo00L0003oooooooooool0003oool000001?oo
o`<0003noooo0`0000Coool000Soool00`000?ooooooo`02oooo00L0003oooooooooool0003oool0
00001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`002?ooo`070000oooooooo
oooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo0007oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Ooo
o`800004oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P0000?oool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`800004
oooo000Hooooo`0000D00004oooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Ooo
o`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00J?ooo`<00003oooo0`0000;oool2000000?o
ool0000000000_ooo`030000oooooooo00800002oooo0`0000;oool300000_ooo`<00003oooo0P00
00?oool300004?ooo`@00003oooo0P0000;oool300000oooo`800002oooo0`0000?oool20000F_oo
o`00JOooo`050000oooooooooooo000000;oool00`000?ooo`000004oooo00H0003oooooool0003o
ool00002oooo00@0003oooooool00004oooo00<0003oooooool00_ooo`050000oooooooooooo0000
00Coool010000?ooooooo`00017oool01P000?ooooooo`000?ooo`0000Goool01@000?oooooooooo
o`000004oooo00<0003oooooool00_ooo`040000oooooooo0000FOooo`00JOooo`050000oooooooo
oooo000000;oool00`000?ooo`00000200000_ooo`060000oooooooo0000oooo00001Oooo`030000
oooooooo00;oool00`000?ooooooo`02oooo00@0003oooooooooool300000_ooo`040000oooooooo
00004Oooo`050000oooooooo0000oooo00<00003oooo00@0003oooooooooool300000_ooo`030000
oooooooo00;oool00`000?ooooooo`1Joooo001Yoooo00<0003oooooool00_ooo`<000001Oooo`00
000000000?ooo`04000000?oool0000000000P0000;oool200000oooo`<00002oooo0P0000?oool3
00000oooo`<0000Aoooo00D0003oooooool0003oool00`0000;oool300000_ooo`<00002oooo0`00
0003oooo000000000080001Joooo001Yoooo00<0003oooooool01?ooo`030000oooooooo00Woool0
0`000?ooooooo`08oooo00<0003oooooool03_ooo`030000oooooooo00ooool010000?ooooooo`00
00Ooool00`000?ooooooo`0;oooo00<0003oooooool0F_ooo`00J?ooo`<00004oooo0P00017oool0
0`000?ooooooo`03oooo00D0003oooooooooool000002_ooo`80000@oooo100000Woool00`000?oo
ooooo`1Woooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wSample = waveletMatrix[128, coif6] . sample; \)\)], "Input"],

Cell[BoxData[
    \(\(wBadSample = waveletMatrix[128, coif6] . bsample; \)\)], "Input"],

Cell["\<\
filterMatrix=
imageNormalize[wBadSample]-imageNormalize[wSample];\
\>", "Input",
  FormatType->InputForm],

Cell["defectSpect=filterMatrix wBadSample;", "Input",
  FormatType->InputForm],

Cell["\<\
defectPosition=imageNormalize[Transpose[waveletMatrix[128,coif6]].defectSpect]\
;\
\>", "Input",
  FormatType->InputForm],

Cell[CellGroupData[{

Cell["\<\
ListDensityPlot[Round[defectPosition],
\tPlotLabel->\"Identified Defect\",
\tMesh->False]\
\>", "Input",
  FormatType->InputForm],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -53 0 ]
[.5 1.0125 53 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -114 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Identified) show
129.000000 13.000000 moveto
(Defect) show
165.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
01goool00`000?ooooooo`0Poooo0`0000?oool00`000?ooooooo`0Ooooo0`0000;oool00`000?oo
ooooo`0Noooo0P0000Coool00`000?ooooooo`0Ooooo00<0003oooooool00_ooo`030000oooooooo
01[oool500000_ooo`030000oooooooo00;oool00`000?ooooooo`0Hoooo1@000004oooo00000000
00000oooo`030000oooooooo01;oool001coool00`000?ooo`00000Qoooo00<0003oooooool00_oo
o`030000oooo0000027oool01P000?ooooooo`000?ooo`0001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`030000oooo000000;oool00`000?ooo`00000Moooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001_oool01@000?ooooooooooo`000004oooo00<0003oool0
00004oooo`007?ooo`030000oooo000002;oool01`000?ooooooooooo`000?ooo`00000Ooooo1000
0004oooo0000oooo00007oooo`030000oooo000000;oool00`000?ooo`00000Ooooo00<0003oool0
00000_ooo`030000oooo000001goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00006oooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0
003oool000008_ooo`070000oooooooooooo0000oooo000001ooool00`000?ooo`000002oooo00<0
003oool000007oooo`800003oooo00<0003oool000008?ooo`070000oooooooooooo0000oooo0000
01goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000006oooo`030000oooooooo
00;oool01`000?ooooooooooo`000?ooo`00000Coooo000Loooo00<0003oool000008Oooo`030000
oooo000000;oool00`000?ooo`00000Poooo0P0000;oool00`000?ooo`00000Ooooo00<0003ooooo
ool00_ooo`030000oooo000001ooool00`000?ooo`000002oooo00<0003oool000007Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00000_ooo`030000oooo000001?oool001goool00`000?ooooooo`0Qoooo00<0003oooooool00_oo
o`030000oooooooo023oool01@000?ooooooooooo`00000Qoooo0P0000?oool00`000?ooooooo`0O
oooo00<0003oooooool00_ooo`030000oooooooo01_oool200001?ooo`030000oooooooo00;oool0
0`000?ooooooo`0Ioooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool04_ooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006?oo
ool0000500001?ooo`006?ooo`030000oooooooo00;oool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`06
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`800004oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Boooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`004Oooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool0017oool00`000?ooo`000004oooo0`000?koool300001?ooo`004Ooo
o`030000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0017oool0
0`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Boooo00<0
003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000oooo
o`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`003?ooo`<00003oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`003?ooo`030000oooooooo00;oool00`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000=oooo00L0003oooooooooool0003oool000001?oo
o`<0003noooo0`0000Coool000goool01`000?ooooooooooo`000?ooo`000004oooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool00`000?ooooooo`02
oooo00<0003oooooool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool2
0000ooooo`7oool200001?ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`003Oooo`<00002oooo00<0003oooooool00ooo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003_ooo`060000oooooooo0000oooo
00001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`003?ooo`@000001?ooo`00
0?ooo`0000Coool30000o_ooo`<00004oooo000<oooo00<0003oool000000_ooo`030000oooo0000
00Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000goool200000_ooo`030000
oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000koool01@000?oo
ooooooooo`000005oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`0joooo20000;koool00`000?ooooooo`02oooo000Hoooo0P00
03_oool80000_Oooo`800004oooo000Hoooo00<0003oooooool0>_ooo`P0002noooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo03[oool80000__ooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`0joooo20000;koool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0>_oo
o`P0002noooo00<0003oooooool00_ooo`006?ooo`030000oooooooo03coool60000__ooo`030000
oooooooo00;oool001Soool00`000?ooooooo`0loooo1P000;koool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000coool200001?ooo`030000
oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000coool00`000?oo
o`000002oooo00<0003oool000001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo0`000?koool300001?ooo`003?oo
o`800003oooo00<0003oool000001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`003?ooo`030000oooooooo00;oool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000=oooo0P0000?oool00`000?ooooooo`03oooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P000?ooool1oooo0P0000Coool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000=oooo00<0003oooooool00_oo
o`030000oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000coool0
0`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`003?ooo`030000oooo000000;oool00`000?ooo`000004oooo0`000?koool300001?oo
o`003Oooo`070000oooooooooooo0000oooo000000Coool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool000coool00`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`003Oooo`030000oooooooo00;oool00`000?ooooooo`03
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo0P00
0?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000ooooo`7oool200001?oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004
oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0006
oooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`002?ooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo0008oooo00L0003ooooo
ooooool0003oool000000_ooo`030000oooo000000Coool30000o_ooo`<00004oooo0008oooo00L0
003oooooooooool0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool000Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`001oooo`800004oooo00<0
003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool20000ooooo`7oool200001?ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1
oooo00<0003oooooool00_ooo`006?ooo`80003ooooo0Oooo`800004oooo000Hoooo00<0003ooooo
ool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?oo
ooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0
003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool0
0`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000H
oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0oooo
o`7oool00`000?ooooooo`02oooo000Hoooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo000Hoooo0P000?ooool1oooo0P0000Coool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Ooo
o`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool0
01Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool000Koool5000000Coool0000000000003oooo00<0003ooooo
ool00oooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`002?ooo`050000oooooooo
oooo000000Coool00`000?ooo`000004oooo00<0003oooooool0ooooo`7oool00`000?ooooooo`02
oooo0008oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool30000o_oo
o`<00004oooo0008oooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000000Coool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool000Soool01`000?ooooooooooo`000?oo
o`000002oooo00<0003oool000001?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_oo
o`001oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`3o
oooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo
00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?oo
ooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000
oooooooo00;oool001Soool00`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool0
0`000?ooooooo`3ooooo0Oooo`030000oooooooo00;oool001Soool20000ooooo`7oool200001?oo
o`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo
0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003ooooo
ool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000
oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0
003oooooool00_ooo`006?ooo`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?oo
o`030000oooooooo0?ooool1oooo00<0003oooooool00_ooo`006?ooo`800003oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Koool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool200001?ooo`006?oo
ool0000500001?ooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQ
oooo003ooooo8Oooo`00ooooob7oool006Soool300000oooo`<00002oooo0P000003oooo00000000
00;oool00`000?ooooooo`0200000_ooo`<00002oooo0`0000;oool300000oooo`800003oooo0`00
013oool400000oooo`800002oooo0`0000?oool200000_ooo`<00003oooo0P0005[oool006Woool0
1@000?ooooooooooo`000002oooo00<0003oool000001?ooo`060000oooooooo0000oooo00000_oo
o`040000oooooooo00001?ooo`030000oooooooo00;oool01@000?ooooooooooo`000004oooo00@0
003oooooool0000Aoooo00H0003oooooool0003oool00005oooo00D0003oooooooooool000001?oo
o`030000oooooooo00;oool010000?ooooooo`0005Woool006Woool01@000?ooooooooooo`000002
oooo00<0003oool000000P0000;oool01P000?ooooooo`000?ooo`0000Goool00`000?ooooooo`02
oooo00<0003oooooool00_ooo`040000oooooooooooo0`0000;oool010000?ooooooo`00017oool0
1@000?ooooooo`000?ooo`0300000oooo`040000oooooooooooo0`0000;oool00`000?ooooooo`02
oooo00<0003oooooool0F_ooo`00JOooo`030000oooooooo00;oool3000000Goool000000000003o
ool010000003oooo0000000000800002oooo0P0000?oool300000_ooo`800003oooo0`0000?oool3
00004Oooo`050000oooooooo0000oooo00<00002oooo0`0000;oool300000_ooo`<000000oooo`00
000000020000F_ooo`00JOooo`030000oooooooo00Coool00`000?ooooooo`09oooo00<0003ooooo
ool02?ooo`030000oooooooo00koool00`000?ooooooo`0?oooo00@0003oooooool00007oooo00<0
003oooooool02oooo`030000oooooooo05[oool006Soool300001?ooo`80000Aoooo00<0003ooooo
ool00oooo`050000oooooooooooo000000[oool200004?ooo`@00009oooo00<0003oooooool0Iooo
o`00ooooob7oool00?oooolQoooo003ooooo8Oooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-15.2856, -8.85663, 0.51466, 
  0.51466}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowSize->{567, 377},
WindowMargins->{{10, Automatic}, {Automatic, 30}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 204, 4, 90, "Input"],
Cell[1916, 55, 190, 4, 30, "Input"],
Cell[2109, 61, 310, 10, 30, "Text",
  Evaluatable->False],
Cell[2422, 73, 3291, 68, 922, "Input"],
Cell[5716, 143, 65, 1, 30, "Input"],
Cell[5784, 146, 413, 13, 152, "Input"],
Cell[6200, 161, 209, 6, 54, "Input"],
Cell[6412, 169, 360, 10, 110, "Input"],
Cell[6775, 181, 262, 8, 82, "Input"],
Cell[7040, 191, 58, 1, 30, "Input"],
Cell[7101, 194, 288, 4, 90, "Input"],

Cell[CellGroupData[{
Cell[7414, 202, 66, 1, 30, "Input"],
Cell[7483, 205, 24307, 575, 296, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[31793, 782, 137, 3, 29, "Output"]
}, Closed]],
Cell[31945, 788, 68, 1, 27, "Input"],
Cell[32016, 791, 54, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[32095, 796, 72, 1, 30, "Input"],
Cell[32170, 799, 31257, 661, 296, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[63430, 1462, 137, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[63604, 1470, 83, 1, 27, "Input"],
Cell[63690, 1473, 27693, 617, 296, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[91386, 2092, 137, 3, 29, "Output"]
}, Closed]],
Cell[91538, 2098, 70, 1, 27, "Input"],
Cell[91611, 2101, 71, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[91707, 2106, 67, 1, 30, "Input"],
Cell[91777, 2109, 31257, 661, 296, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[123037, 2772, 137, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[123211, 2780, 111, 2, 27, "Input"],
Cell[123325, 2784, 24307, 575, 296, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[147635, 3361, 137, 3, 29, "Output"]
}, Closed]],
Cell[147787, 3367, 67, 1, 27, "Input"],
Cell[147857, 3370, 288, 4, 90, "Input"],

Cell[CellGroupData[{
Cell[148170, 3378, 142, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[148337, 3385, 18147, 499, 207, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[166487, 3886, 18362, 502, 207, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[184852, 4390, 27138, 893, 146, 7942, 652, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]],
Cell[212005, 5286, 135, 3, 29, "Output"]
}, Closed]],
Cell[212155, 5292, 139, 3, 27, "Input"],
Cell[212297, 5297, 512, 13, 210, "Input"],

Cell[CellGroupData[{
Cell[212834, 5314, 76, 1, 30, "Input"],
Cell[212913, 5317, 57, 1, 29, "Output"]
}, Closed]],
Cell[212985, 5321, 417, 11, 27, "Input"],
Cell[213405, 5334, 54, 1, 30, "Input"],
Cell[213462, 5337, 54, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[213541, 5342, 80, 1, 30, "Input"],
Cell[213624, 5345, 55, 1, 29, "Output"]
}, Closed]],
Cell[213694, 5349, 277, 7, 27, "Input"],
Cell[213974, 5358, 71, 1, 30, "Input"],
Cell[214048, 5361, 71, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[214144, 5366, 70, 1, 30, "Input"],
Cell[214217, 5369, 55, 1, 29, "Output"]
}, Open  ]],
Cell[214287, 5373, 61, 1, 30, "Input"],
Cell[214351, 5376, 288, 4, 90, "Input"],

Cell[CellGroupData[{
Cell[214664, 5384, 142, 3, 50, "Input"],

Cell[CellGroupData[{
Cell[214831, 5391, 24307, 575, 296, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[239141, 5968, 24664, 580, 296, 3833, 318, "GraphicsData", 
"PostScript", "Graphics"],
Cell[263808, 6550, 35070, 991, 207, 7942, 652, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[298893, 7544, 135, 3, 28, "Output"]
}, Closed]],
Cell[299043, 7550, 417, 11, 27, "Input"],
Cell[299463, 7563, 172, 5, 66, "Input"],
Cell[299638, 7570, 54, 1, 30, "Input"],
Cell[299695, 7573, 111, 3, 30, "Input"],
Cell[299809, 7578, 70, 1, 30, "Input"],
Cell[299882, 7581, 101, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[300008, 7586, 140, 5, 66, "Input"],
Cell[300151, 7593, 25839, 629, 296, 5114, 369, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[326005, 8225, 277, 7, 27, "Input"],
Cell[326285, 8234, 71, 1, 30, "Input"],
Cell[326359, 8237, 93, 1, 30, "Input"],
Cell[326455, 8240, 70, 1, 30, "Input"],
Cell[326528, 8243, 129, 4, 48, "Input"],

Cell[CellGroupData[{
Cell[326682, 8251, 140, 5, 66, "Input"],
Cell[326825, 8258, 25507, 625, 296, 5114, 369, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[352347, 8886, 64, 1, 27, "Input"],
Cell[352414, 8889, 108, 2, 30, "Input"],
Cell[352525, 8893, 55, 1, 30, "Input"],
Cell[352583, 8896, 97, 4, 48, "Input"],
Cell[352683, 8902, 56, 1, 30, "Input"],
Cell[352742, 8905, 194, 4, 90, "Input"],

Cell[CellGroupData[{
Cell[352961, 8913, 220, 7, 102, "Input"],
Cell[353184, 8922, 150910, 3415, 195, 80546, 2542, "GraphicsData", 
"PostScript", "Graphics"]
}, Closed]],
Cell[504109, 12340, 418, 11, 27, "Input"],
Cell[504530, 12353, 81, 1, 30, "Input"],
Cell[504614, 12356, 85, 1, 30, "Input"],
Cell[504702, 12359, 127, 4, 48, "Input"],
Cell[504832, 12365, 84, 1, 30, "Input"],
Cell[504919, 12368, 115, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[505059, 12375, 139, 5, 66, "Input"],
Cell[505201, 12382, 60639, 1519, 296, 40102, 1261, "GraphicsData", 
"PostScript", "Graphics"],
Cell[565843, 13903, 137, 3, 29, "Output"]
}, Closed]],
Cell[565995, 13909, 276, 7, 27, "Input"],
Cell[566274, 13918, 83, 1, 30, "Input"],
Cell[566360, 13921, 87, 1, 30, "Input"],
Cell[566450, 13924, 115, 4, 48, "Input"],
Cell[566568, 13930, 78, 1, 30, "Input"],
Cell[566649, 13933, 131, 4, 48, "Input"],

Cell[CellGroupData[{
Cell[566805, 13941, 139, 5, 66, "Input"],
Cell[566947, 13948, 60627, 1519, 296, 40102, 1261, "GraphicsData", 
"PostScript", "Graphics"],
Cell[627577, 15469, 137, 3, 29, "Output"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

