(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1561524,      26621]*)
(*NotebookOutlinePosition[   1562196,      26645]*)
(*  CellTagsIndexPosition[   1562152,      26641]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Utilities`MemoryConserve`\n$MemoryIncrement; 
    \n<< \ LinearAlgebra`MatrixManipulation`; \n
    Off[General::spell1, MemoryConserve::start, MemoryConserve::end]; \)], 
  "Input"],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["\:57fa\:5e95\:95a2\:6570",
        FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
        FontWeight->"Bold"]}]], "Input"],

Cell[BoxData[
    StyleBox[\(Daubechies : \),
      FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
      FontWeight->"Bold",
      FontVariations->{"Underline"->True}]], "Input"],

Cell[BoxData[
    \(\(daub2 = {{1. , 1. }, {1. , \(-1. \)}}/Sqrt[2. ]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["     ",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold"],
  StyleBox["Coifman:",
    FontFamily->"\.82l\.82r \.83S\.83V\.83b\.83N",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\

coif30={{-.000149963800, .000253561200, .001540245700, 
\t\t -.002941110800,-.007163781900, .016552066400, 
 \t\t  .019917804300,-.064997262800,-.036800073600,
 \t\t  .298092323500, .547505429400, .309706849000, 
\t\t -.043866050800,-.074652238900, .029195879500, 
 \t\t  .023110777000,-.013973687900,-.006480090000, 
 \t\t  .004783001400, .001720654700,-.001175822200,
\t\t -.000451227000, .000213729800, .000099377600,
\t\t -.000029232100,-.000015072000, .000002640800, 
 \t\t  .000001459300,-.000000118400,-.000000067300},
 \t\t{-.000000067300, .000000118400, .000001459300,
 \t\t -.000002640800,-.000015072000, .000029232100,
 \t\t  .000099377600,-.000213729800,-.000451227000,
 \t\t  .001175822200, .001720654700,-.004783001400,
 \t\t -.006480090000, .013973687900, .023110777000,
 \t\t -.029195879500,-.074652238900, .043866050800,
 \t\t  .309706849000,-.547505429400, .298092323500,
 \t\t  .036800073600,-.064997262800,-.019917804300,
 \t\t  .016552066400, .007163781900,-.002941110800,
 \t\t -.001540245700, .000253561200, .000149963800}}*
 \t\tSqrt[2.]; \
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    \(\[FilledSquare]\ Wavelet\ Matrix\)], "Input"],

Cell["\<\
c[n_,baseType_]:=Module[{mat,i,result},
\tresult=mat=AppendRows[baseType,
\t\tZeroMatrix[2,n-Length[baseType[[1]]]]];
       \trotateRightofList[a_List]:=RotateRight/@ a;
        rotateRight[b_List,k_]:=
        Nest[rotateRightofList,b,k];
        Do[result=
        \tAppendColumns[result,rotateRight[mat,2 i]],
            {i,n/2-1}];
\tresult]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
cPrime[i_,n_,baseType_]:=BlockMatrix[{{c[n/2^i,baseType],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
\tIdentityMatrix[n-n/2^i]}}]\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
p[n_]:=Module[{mat,i},mat=IdentityMatrix[n];
\tDo[mat[[i]]=RotateRight[mat[[i]],i-1],{i,2,n}];
    Do[mat[[i]]=RotateRight[mat[[i]]],{i,n/2+1,n}];
    mat];
pPrime[i_,n_,baseType_]:=BlockMatrix[{{p[n/2^i],
\tZeroMatrix[n/2^i,n-n/2^i]},{ZeroMatrix[n-n/2^i,n/2^i],
  \tIdentityMatrix[n-n/2^i]}}];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell["\<\
waveletMatrix[n_,baseType_]:=
\tApply[Dot,Flatten[Table[{pPrime[j,n,baseType],
\t\tcPrime[j,n,baseType]},{j,Log[2,n]-
\t\tCeiling[Log[2.,Length[baseType[[2]]]]],1,-1}],
\t\t1]].p[n].c[n,baseType];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((1 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
expanMatrix[v_,wMat_]:=
\tBlock[{mdata=Length[v],is=Length[Transpose[daub2]],
\t\tndata=Ceiling[Log[2.,mdata]],mother,transwMat,emat,exPan},
\t\tmother=Ceiling[Log[2.,is]]-1;transwMat=Transpose[wMat];
    \temat=transwMat.Join[Take[v,{1,2^mother}],Table[0,{mdata-
    \t\t2^mother}]];\t
   \t\tpartInverse[i_]:=(exPan=Table[0,{mdata}];
   \t\t\tDo[exPan[[j]]=v[[j]],{j,1+2^(i-1),2^i}];
   \t\t\ttranswMat.exPan);
    \texPan=Table[partInverse[i],{i,mother+1,ndata}];
        emat=AppendColumns[{emat},exPan]\t\t
  \t];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((2 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["\<\
expanMatrix2D[spect2D_,wMatL_,wMatR_,anaW_]:=
\tBlock[{dim=Dimensions[spect2D],is=Length[Transpose[anaW]],
\t\tmother,transwMatL,emat2D,exPan2D},
\t\tmother=Ceiling[Log[2.,is]]-1;transwMatL=Transpose[wMatL];
\t\tWhich[\tdim[[1]]>=dim[[2]],nLdata=Log[2,dim[[1]]];size=dim[[1]],
\t\t\t\tdim[[2]]>dim[[1]],nLdata=Log[2,dim[[2]]];size=dim[[2]]];
\t\tinputMatrix=ZeroMatrix[size,size];
\t\t\tDo[inputMatrix[[i,j]]=spect2D[[i,j]],
\t\t\t\t{i,dim[[1]]},{j,dim[[2]]}];
\t\texPan2D=ZeroMatrix[dim[[1]],dim[[2]]];
\t\t\tDo[Do[exPan2D[[i,j]]=spect2D[[i,j]],{i,2^mother}],
\t\t\t\t{j,2^mother}];
\t\t\temat2D=transwMatL.exPan2D.wMatR;
\t\tpartInverse2D[i_]:=
\t\t\t(\tdummyMat=ZeroMatrix[size,size];
\t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
\t\t\t\t\t{k,2^i},{m,1+2^(i-1),2^i}];
   \t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
   \t\t\t\t\t{k,1+2^(i-1),2^i},{m,2^i}];
   \t\t\t\tDo[dummyMat[[k,m]]=inputMatrix[[k,m]],
   \t\t\t\t\t{k,1+2^(i-1),2^i},{m,1+2^(i-1),2^i}];
   \t\t\t\ttranswMatL.Table[dummyMat[[k,m]],
   \t\t\t\t\t{k,dim[[1]]},{m,dim[[2]]}].wMatR);
    \texPan2D=Table[partInverse2D[i],{i,mother+1,nLdata}];
    \t\tFlatten[{{emat2D},exPan2D},1]
    ];\
\>", "Input",
  AspectRatioFixed->True,
  FontSize->9],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["1",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["dimensional",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["sample",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(a = {x, y, u, v}; \)\)], "Input"],

Cell[BoxData[
    \(\(daub2 = {{1. , 1. }, {1. , \(-1. \)}}/Sqrt[2. ]; \)\)], "Input"],

Cell[BoxData[
    \(\(w = waveletMatrix[4, daub2]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.499999999999999911`", "0.499999999999999911`", 
              "0.499999999999999911`", "0.499999999999999911`"},
            {"0.499999999999999911`", "0.499999999999999911`", 
              \(-0.499999999999999911`\), \(-0.499999999999999911`\)},
            {"0.707106781186547461`", \(-0.707106781186547461`\), "0.`", 
              "0.`"},
            {"0.`", "0.`", "0.707106781186547461`", 
              \(-0.707106781186547461`\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(wa = w . a; \)\)], "Input"],

Cell[BoxData[
    \(\(unitMatrix4 = Transpose[w] . w; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[%] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0.999999999999999644`", "0", "0", "0"},
            {"0", "0.999999999999999644`", "0", "0"},
            {"0", "0", "0.999999999999999644`", "0"},
            {"0", "0", "0", "0.999999999999999644`"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[Simplify[Transpose[w] . wa]] // MatrixForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"(", GridBox[{
            {\(0.999999999999999644`\ x\)},
            {\(0.999999999999999644`\ y\)},
            {\(0.999999999999999644`\ u\)},
            {\(0.999999999999999644`\ v\)}
            }], ")"}],
      MatrixForm[ {
        Times[ .99999999999999967, x], 
        Times[ .99999999999999967, y], 
        Times[ .99999999999999967, u], 
        Times[ .99999999999999967, v]}]]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", 
      StyleBox[
        RowBox[{" ", 
          StyleBox[" ",
            FontVariations->{"Underline"->True}]}]], 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((1 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(multiResolvedVector = expanMatrix[wa, w]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Do[
      Print["\<Level\>", i, "\<->\>", \n\t\t
        MatrixForm[Simplify[multiResolvedVector[\([i]\)]]]], {i, 3}]; \)\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Level\"\>", "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        "\<\"->\"\>", "\[InvisibleSpace]", 
        InterpretationBox[
          RowBox[{"(", GridBox[{
                {\(0.249999999999999911`\ \((u + v + x + y)\)\)},
                {\(0.249999999999999911`\ \((u + v + x + y)\)\)},
                {\(0.249999999999999911`\ \((u + v + x + y)\)\)},
                {\(0.249999999999999911`\ \((u + v + x + y)\)\)}
                }], ")"}],
          MatrixForm[ {
            Times[ .24999999999999989, 
              Plus[ u, v, x, y]], 
            Times[ .24999999999999989, 
              Plus[ u, v, x, y]], 
            Times[ .24999999999999989, 
              Plus[ u, v, x, y]], 
            Times[ .24999999999999989, 
              Plus[ u, v, x, y]]}]]}],
      SequenceForm[ "Level", 1, "->", 
        MatrixForm[ {
          Times[ .24999999999999989, 
            Plus[ u, v, x, y]], 
          Times[ .24999999999999989, 
            Plus[ u, v, x, y]], 
          Times[ .24999999999999989, 
            Plus[ u, v, x, y]], 
          Times[ .24999999999999989, 
            Plus[ u, v, x, y]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Level\"\>", "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        "\<\"->\"\>", "\[InvisibleSpace]", 
        InterpretationBox[
          RowBox[{"(", GridBox[{
                {
                  \(\(-0.249999999999999911`\)\ u - 
                    0.249999999999999911`\ v + 
                    0.249999999999999911`\ \((x + y)\)\)},
                {
                  \(\(-0.249999999999999911`\)\ u - 
                    0.249999999999999911`\ v + 
                    0.249999999999999911`\ \((x + y)\)\)},
                {
                  \(0.249999999999999911`\ u + 0.249999999999999911`\ v - 
                    0.249999999999999911`\ \((x + y)\)\)},
                {
                  \(0.249999999999999911`\ u + 0.249999999999999911`\ v - 
                    0.249999999999999911`\ \((x + y)\)\)}
                }], ")"}],
          MatrixForm[ {
            Plus[ 
              Times[ -.24999999999999989, u], 
              Times[ -.24999999999999989, v], 
              Times[ .24999999999999989, 
                Plus[ x, y]]], 
            Plus[ 
              Times[ -.24999999999999989, u], 
              Times[ -.24999999999999989, v], 
              Times[ .24999999999999989, 
                Plus[ x, y]]], 
            Plus[ 
              Times[ .24999999999999989, u], 
              Times[ .24999999999999989, v], 
              Times[ -.24999999999999989, 
                Plus[ x, y]]], 
            Plus[ 
              Times[ .24999999999999989, u], 
              Times[ .24999999999999989, v], 
              Times[ -.24999999999999989, 
                Plus[ x, y]]]}]]}],
      SequenceForm[ "Level", 2, "->", 
        MatrixForm[ {
          Plus[ 
            Times[ -.24999999999999989, u], 
            Times[ -.24999999999999989, v], 
            Times[ .24999999999999989, 
              Plus[ x, y]]], 
          Plus[ 
            Times[ -.24999999999999989, u], 
            Times[ -.24999999999999989, v], 
            Times[ .24999999999999989, 
              Plus[ x, y]]], 
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ -.24999999999999989, 
              Plus[ x, y]]], 
          Plus[ 
            Times[ .24999999999999989, u], 
            Times[ .24999999999999989, v], 
            Times[ -.24999999999999989, 
              Plus[ x, y]]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Level\"\>", "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        "\<\"->\"\>", "\[InvisibleSpace]", 
        InterpretationBox[
          RowBox[{"(", GridBox[{
                {
                  \(0.`\ u + 0.`\ v + 0.499999999999999911`\ x - 
                    0.499999999999999911`\ y\)},
                {
                  \(0.`\ u + 0.`\ v - 0.499999999999999911`\ x + 
                    0.499999999999999911`\ y\)},
                {
                  \(0.499999999999999911`\ u - 0.499999999999999911`\ v + 
                    0.`\ x + 0.`\ y\)},
                {
                  \(\(-0.499999999999999911`\)\ u + 
                    0.499999999999999911`\ v + 0.`\ x + 0.`\ y\)}
                }], ")"}],
          MatrixForm[ {
            Plus[ 
              Times[ 0.0, u], 
              Times[ 0.0, v], 
              Times[ .49999999999999989, x], 
              Times[ -.49999999999999989, y]], 
            Plus[ 
              Times[ 0.0, u], 
              Times[ 0.0, v], 
              Times[ -.49999999999999989, x], 
              Times[ .49999999999999989, y]], 
            Plus[ 
              Times[ .49999999999999989, u], 
              Times[ -.49999999999999989, v], 
              Times[ 0.0, x], 
              Times[ 0.0, y]], 
            Plus[ 
              Times[ -.49999999999999989, u], 
              Times[ .49999999999999989, v], 
              Times[ 0.0, x], 
              Times[ 0.0, y]]}]]}],
      SequenceForm[ "Level", 3, "->", 
        MatrixForm[ {
          Plus[ 
            Times[ 0.0, u], 
            Times[ 0.0, v], 
            Times[ .49999999999999989, x], 
            Times[ -.49999999999999989, y]], 
          Plus[ 
            Times[ 0.0, u], 
            Times[ 0.0, v], 
            Times[ -.49999999999999989, x], 
            Times[ .49999999999999989, y]], 
          Plus[ 
            Times[ .49999999999999989, u], 
            Times[ -.49999999999999989, v], 
            Times[ 0.0, x], 
            Times[ 0.0, y]], 
          Plus[ 
            Times[ -.49999999999999989, u], 
            Times[ .49999999999999989, v], 
            Times[ 0.0, x], 
            Times[ 0.0, y]]}]],
      Editable->False]], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Print["\<All Levels\>", 
      "\<->\>"\n\t\t
        MatrixForm[
          Chop[Simplify[
              multiResolvedVector[\([1]\)] + multiResolvedVector[\([2]\)]\n
                \t\t\t\t\t\t\t + multiResolvedVector[\([3]\)]\ ]]]]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"All Levels\"\>", "\[InvisibleSpace]", 
        RowBox[{"\<\"->\"\>", " ", 
          InterpretationBox[
            RowBox[{"(", GridBox[{
                  {\(0.999999999999999644`\ x\)},
                  {\(0.999999999999999644`\ y\)},
                  {\(0.999999999999999644`\ u\)},
                  {\(0.999999999999999644`\ v\)}
                  }], ")"}],
            MatrixForm[ {
              Times[ .99999999999999967, x], 
              Times[ .99999999999999967, y], 
              Times[ .99999999999999967, u], 
              Times[ .99999999999999967, v]}]]}]}],
      SequenceForm[ "All Levels", 
        Times[ "->", 
          MatrixForm[ {
            Times[ .99999999999999967, x], 
            Times[ .99999999999999967, y], 
            Times[ .99999999999999967, u], 
            Times[ .99999999999999967, v]}]]],
      Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
    RowBox[{"\[FilledSquare]", "  ", 
      StyleBox["2",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["dimensional",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["sample",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(a = Table[fukuzawa[\([i, j]\)], {i, 30, 157}, {j, 5, 132}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[a, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
000000000000000000FFFFFFFF0000000000000000000000
0000000000000000FF00000000000000000000000000FF00
0000000000000000000000000000000000000000000000FF
FF000000000000000000000000000000FF00000000000000
000000000000000000000000000000000000000000000000
0000FFFF00FFFFFF
000000000000000000000000000000000000000000000000
000000000000000000FF000000FFFFFFFF0000FFFF00FFFF
FFFFFFFF000000FF00FFFFFF000000FF0000FFFFFF00FFFF
0000000000FFFFFF00000000FF0000FF000000FFFF0000FF
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
0000FF000000000000FF0000FFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000FF00FF00FFFFFFFF0000000000000000FF00
00FF00000000FFFFFFFF00FFFFFF00FFFF00000000FFFF00
000000000000000000000000000000000000000000000000
0000000000000000
000000000000000000000000000000000000000000000000
00000000FF000000FFFF000000000000FF000000FFFFFFFF
FFFFFFFFFF00000000FFFF00000000FF0000FF000000FFFF
FF00FFFF00FFFF00000000000000FF0000000000FF000000
00000000000000000000FF00FF00FFFFFF00FFFFFFFFFF00
0000000000000000
000000000000000000FFFFFF0000FFFF0000000000000000
00000000000000000000FF00000000000000FF000000FFFF
00FFFFFFFFFF00FF00FFFF00FF0000FFFFFFFF0000000000
FFFF00FF000000FFFFFFFF00000000000000000000000000
00000000000000000000FF00FFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF00FFFF
FFFF00000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFF0000000000000000FF0000FFFF
0000000000FFFFFFFFFFFFFFFFFF0000FF0000FF00000000
000000FFFF0000FF00FF00000000000000000000000000FF
00000000000000000000FF00FFFFFFFFFFFFFFFF0000FFFF
00FFFFFFFF00FFFF
000000000000000000000000000000000000000000000000
000000000000FF0000FFFFFF000000000000000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFF0000000000000000000000000000FF
FF0000000000000000000000FFFFFF000000000000FFFFFF
0000FF00000000FF
FFFFFFFFFFFFFFFFFF0000000000000000000000000000FF
00FF0000FFFFFFFF00FFFFFFFF0000FFFFFFFFFFFF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FFFF00FF00FFFFFFFF00FF
FFFFFF000000000000000000FFFFFFFFFF00FF0000FFFFFF
00FFFF000000FFFF
0000000000000000FFFFFFFF000000000000000000000000
0000FF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF
00FFFFFFFF00000000000000FFFFFFFFFF00FF0000FFFFFF
00FFFFFFFF00FFFF
0000000000000000FFFFFFFF00000000000000000000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFF00FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFFFFFF00000000000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FFFFFFFF00000000FFFFFFFFFF00FFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00
FFFFFFFF00FFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFFFFFF00FFFF00
FFFFFFFF00FFFF00000000000000FFFF0000FF0000FFFFFF
0000FFFFFF0000FF
0000000000000000FFFF0000000000FFFFFF000000FFFFFF
FF00FF00FF00FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFF00FFFF00FF00FFFFFF00FFFFFFFFFF00FF00FFFFFF
FFFFFFFFFFFFFFFFFF00FF0000FFFFFFFFFFFF00FFFFFF00
0000FFFFFFFFFFFFFFFFFF00000000000000000000FFFFFF
0000FF00FF0000FF
0000000000000000FF0000000000FFFFFFFFFF00FFFFFFFF
000000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFF00FFFFFFFF00FFFFFFFF00FFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFF00FFFF000000FFFFFFFFFF00000000FFFF
0000FFFF00FF00FFFFFFFFFFFF0000FF0000FFFF0000FFFF
0000FFFFFF00FFFF
000000000000000000000000FFFFFFFFFFFF00FF00FFFFFF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFF00FFFF00FFFF
FFFFFFFFFF0000FFFF00000000FFFFFFFF00FFFFFF00FFFF
FF000000FFFFFFFFFFFFFFFFFFFFFF00FFFF000000FFFF00
0000FFFFFF0000FF
00000000000000000000FFFFFFFFFFFFFFFFFFFF00FF0000
FFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFF0000FFFF
FFFFFFFFFFFFFFFFFF00000000FFFFFF000000FFFF00FFFF
FF000000FFFFFF0000FFFFFFFFFFFFFFFFFFFFFF0000FFFF
0000FFFF00FFFFFF
00000000FF00000000000000FFFFFFFFFFFFFFFFFF000000
FFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FFFF
FFFFFFFFFFFF0000FFFF00000000FFFFFFFFFFFFFF00FFFF
FF0000FFFFFFFF00FFFFFF00000000FFFFFFFFFFFF000000
0000FFFFFFFFFFFF
00000000FF00FF0000FF00FFFF000000FFFFFF00000000FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFF00FFFFFFFF
FFFF0000FFFF00FFFF00FFFF000000FFFFFFFFFFFF000000
0000FFFF00FFFFFF
000000000000FF00FFFFFFFFFF00FF00FFFF0000000000FF
0000FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF0000000000FFFFFFFFFF00FF00FFFF
FFFF00FF00FFFFFFFFFFFFFFFF00FFFFFF0000FFFFFF00FF
000000000000FFFF
0000000000FF00FFFFFFFFFFFF00FF00FF0000FF00FFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFF0000FFFF
FFFFFFFFFFFFFFFF00FF0000FFFFFF00FF00FF0000FFFFFF
FFFF0000FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000000000FFFF00
000000FFFFFFFFFF00FF00FF000000FF0000FFFF00FFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFF00FF
FFFFFFFFFFFFFFFF00FFFFFF00FFFF00FFFFFFFF00FFFFFF
FF0000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FFFF0000000000
000000FF00FFFFFF0000FFFF00FFFF000000FFFFFFFFFFFF
FF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF
FF0000FF00FFFF00FFFFFFFFFFFFFFFF0000FFFFFFFFFFFF
00000000000000FF
000000FFFF00FFFFFF00FFFFFF000000FFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFF0000FFFFFFFFFFFFFFFF00FFFFFF
FF00FFFFFFFF00FF0000FF00FFFFFFFF0000FFFFFFFFFF00
FF00000000000000
00000000FFFFFFFF000000FF000000FFFFFFFFFF00FFFFFF
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF00
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00FFFFFF
FFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000000000000000
00000000FFFFFF00FF00FF0000FFFFFFFFFFFF00FFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF
FFFFFFFFFFFFFF00FFFFFF00FFFF00FFFFFF00FF00FFFFFF
FFFF0000FF00FF0000FFFFFFFFFFFFFFFF00FFFFFFFFFF00
00000000000000FF
00000000FFFF0000FFFFFF00FFFFFFFFFF00FFFF00FFFFFF
FFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFF00FF0000FF
FFFFFFFF00FF00FF00FFFFFFFFFFFFFFFFFF0000FFFFFFFF
00FFFFFFFFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF0000FF00FFFF00FFFFFFFFFFFFFF0000FF00FFFF0000
00000000FF0000FF
000000000000000000FFFFFFFFFFFF000000FFFFFF00FFFF
0000FFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FF00FF0000FF
FFFFFFFFFF00FF00FFFFFFFFFF00FFFFFFFFFFFF00FFFFFF
00FF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF0000FF00FF00FFFFFF0000FF0000FF00FF0000
000000000000FFFF
0000000000FF000000FFFFFFFFFFFF0000FFFFFF00FF0000
00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF000000000000FF
FFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FFFFFF
00FFFFFFFFFF00FFFFFFFF00FFFF00FFFFFFFF00FFFFFFFF
FF00FFFFFF00000000FFFFFFFFFFFFFFFFFFFFFFFF000000
000000000000FFFF
000000FF00FFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FF00000000FF
FFFFFF00FFFF0000FF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF0000000000FF0000FFFF00000000FFFF000000
0000000000000000
00FFFFFFFFFF00FFFFFFFFFFFFFFFF000000FF00FF00FFFF
00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FF000000FF
FFFF0000FFFF00FFFF0000FFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF
00FFFFFF000000000000FF00FFFFFFFF0000FFFFFF000000
000000FF0000FF00
FF00FFFFFFFFFFFFFFFF00FF0000FFFF00FFFFFF00FFFFFF
00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00000000
FFFFFFFF00FFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFF00FF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFF000000FFFFFFFFFFFFFF000000FFFF00000000
000000000000FF00
FFFFFFFFFFFFFFFFFFFF00FFFFFF0000000000FFFF0000FF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
FFFF00FFFFFFFFFFFFFFFFFF00FFFF0000FFFFFFFF0000FF
FF0000FFFFFF00FFFFFFFFFF00FFFFFFFFFF0000FFFFFF00
FFFFFFFF00FF00FFFF000000FFFFFF0000FFFFFF00000000
0000000000000000
FFFF00FFFFFFFF00FFFFFF00FFFFFF0000FFFFFFFF00FF00
00FFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF00
FFFF00FFFFFF00FF0000FFFFFFFFFF00FFFFFFFFFFFF0000
FF0000FFFFFF00FFFFFFFFFFFFFFFFFFFFFF0000FFFFFF00
FFFF00FF00FF00FFFFFF000000FFFF000000FF0000000000
0000000000000000
FFFFFFFF00FFFF00FFFF0000FFFF00FFFF00FFFF00000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00
FF00FFFFFF0000FFFFFFFFFFFFFFFFFF0000FFFFFF0000FF
00FF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF00FFFF00FF
00FFFF00FFFF00FFFFFF000000FFFF000000FFFF00000000
0000FF0000000000
FFFFFFFFFFFFFFFF00FF0000FFFF00000000FFFF00FF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00
FFFFFF00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF
FFFFFFFF00FF0000FF00FF0000FF00FF00FF000000000000
00FFFFFFFF000000
FFFFFFFFFFFFFFFFFFFF0000FFFF0000FF00FFFF00000000
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FFFF
FF00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFF0000FFFF00FFFF
FFFFFF00FF000000FF00FF00FFFFFF000000000000000000
0000FFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFF0000FF00FF0000000000
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFF00FF00
FFFF0000FF00FFFFFFFFFFFFFFFF00FFFFFF0000FFFF00FF
FFFF0000FF00FFFFFFFF00FF00FFFFFFFFFF00FFFF00FFFF
FFFF0000FFFFFF00FFFF0000FF000000FF00FF000000FFFF
00FFFFFF00000000
00000000000000FFFFFFFF00FF000000FF000000FFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FF000000FFFFFF00FF00FFFF00FFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFFFFFF0000FF00FFFF
FFFFFF00FFFF0000FF0000000000000000000000FFFF0000
FFFFFFFFFFFFFFFF
00000000000000000000FF00FFFF00FFFF0000FFFFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF0000FF
FFFF00FF000000FF00FFFFFFFFFFFFFFFFFF000000FFFFFF
FFFFFF00FFFF00FFFFFFFFFFFFFFFFFFFFFF0000FF0000FF
FF0000FFFFFF0000FFFFFF000000FF000000FF0000FF0000
0000FFFFFFFFFF00
00000000000000000000FFFFFFFFFF00FF000000FFFF0000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00
FF00FFFFFF00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFF00FFFFFFFFFF00FF00FF00FFFF
FF00FFFFFF000000FFFFFF00000000FF000000FFFFFFFFFF
00FFFF00000000FF
FFFFFFFFFF00FFFFFFFFFFFF00FFFF00FF000000FFFF0000
00FFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFF
FF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
FFFFFFFF0000FF00FF00FFFF00FFFFFFFF00FFFFFFFFFFFF
0000FFFFFFFFFFFFFFFFFF00FF00FFFF0000FF00FF0000FF
FFFFFFFF0000FF00
00000000000000000000FFFF00000000FF00000000FF0000
00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF00000000FFFF
0000FFFF00FF00FFFFFF0000FFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFF0000FF0000FFFF0000FF0000FF000000FFFF
00FFFF00FF00FFFF
00000000000000000000FFFF0000FF00FFFF000000FF0000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF00
0000000000000000FFFFFF00FF00FFFFFFFFFF00FFFFFFFF
FFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFF000000FFFFFF00
00FFFFFF0000FF00FF00000000FFFF00FF0000FFFFFFFF00
FF00FFFF00FFFFFF
00000000000000000000FFFF000000000000000000FFFF00
00FF00FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFFFFFF0000FF0000
FFFF00FFFF00FFFFFFFFFFFF00FFFFFFFF00FF00FFFF0000
FFFFFFFFFFFF0000FF00FFFFFF00FFFFFF0000000000FFFF
FF00FFFFFFFFFFFF
00000000000000000000FFFF00000000FF00FF0000FFFF00
00FFFF00FFFFFF00FFFF00FFFFFFFFFFFFFFFFFF0000FFFF
FFFFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFF0000FF00
0000FF00FFFFFFFFFF00FFFF00FFFFFFFFFFFF00FFFF00FF
FFFFFFFFFFFF000000FFFFFFFFFF0000FFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFF
00000000000000000000FFFFFF000000000000FF0000FF00
0000FFFFFF00FF00FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF00FFFF0000
FF00FFFF00FFFFFF00FFFF00FFFFFFFFFFFF0000FF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF00FFFFFFFFFFFF
00000000000000000000FFFF00000000000000FFFFFFFF00
0000FFFFFF000000FFFFFF00FFFF00FFFF00FFFF00FFFF00
FFFFFFFFFFFFFFFFFFFF000000FF00FF0000FFFF000000FF
FFFFFF0000FFFFFF00FFFF00FFFFFFFFFFFFFFFF00FF0000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FFFFFFFFFFFF
00000000000000000000FFFF000000000000FFFFFFFFFFFF
0000FFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFF00FFFF00
FFFFFFFFFFFFFFFFFF000000FF0000FFFF00FFFFFFFFFF00
00000000FF0000FF00FFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FF00FF00FFFFFFFF
00000000000000000000FFFF000000000000FFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFF0000FFFFFFFFFF00FFFF00
FFFFFFFFFFFFFFFF0000FFFFFF000000FFFFFF000000FF00
FFFF0000000000FF00FFFF00FFFFFFFFFF000000FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF
FFFFFFFFFF00FFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF0000FFFF00FFFF00FF00FFFF00FFFFFF
FF0000FFFFFF00000000FF000000000000000000FFFFFF00
FF000000000000FFFFFF00FFFFFF0000FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FFFFFF00FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFF00FF0000FF00FFFFFFFFFF00
FF00FFFF0000000000FFFF0000000000000000000000FF00
000000FF000000FFFFFF000000FFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF000000000000
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FFFFFFFF00
FFFFFFFF00FF0000FF00000000000000000000000000FF00
000000FF000000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000FFFFFF
00FFFFFF00FF00FF00000000000000000000000000000000
FF0000FF000000FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
FFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FF0000000000FF0000000000000000000000000000000000
FF00FF00000000FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF00FF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00
FF0000000000000000000000000000000000000000000000
00000000000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FFFF000000000000000000000000000000000000000000
000000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00FF000000000000000000000000000000000000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00FF0000000000000000000000000000000000000000
000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FF00000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
00FFFF000000000000000000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFF00000000000000000000000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000000000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFF000000000000000000000000000000000000000000
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFF00000000000000000000000000
000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF00000000000000FFFFFFFF000000000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
0000000000000000000000FFFF00FF000000000000000000
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000000000000000000000FFFFFF000000000000FF00
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
0000000000FF0000FFFF0000000000000000000000000000
0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
00000000FF000000FF000000000000000000000000FF0000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
0000000000FFFF00000000000000FFFFFF00000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000
000000FF0000FF00FF000000FFFF00000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FF0000FFFF00FFFF0000000000000000000000FF00
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
0000000000FF00FFFFFFFFFFFFFFFFFF00FFFF0000000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF0000
00000000FFFFFF00FFFFFFFF0000FF0000000000FF000000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
000000FF00FFFFFFFFFFFFFF000000000000FFFF00FF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000FF00000000FF00FF0000000000000000000000FF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
0000FFFFFF0000FFFF00FF00000000000000000000FF0000
0000000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
FFFFFFFFFFFF00FFFF00FFFF00FF000000FF00FFFFFF0000
00FF000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
00FFFFFFFFFFFFFF00FFFF00FFFFFF000000FFFFFFFFFFFF
FFFFFF0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
00FFFFFF0000000000FFFF00FF00FF000000FF0000000000
00FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FF
FFFFFFFF00FF00000000FFFFFFFFFF0000FF000000000000
00FFFF00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000
00000000000000000000FFFFFFFFFFFF000000FF00000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
FF0000000000000000000000FFFFFFFF0000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000
000000FF00FF00000000000000FFFF000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFFFF
0000000000FFFFFF0000000000FFFF00000000FF000000FF
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
00FF00FF0000FFFFFF000000000000000000000000000000
00000000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFF
FF0000000000000000000000FFFFFFFF0000000000000000
0000000000FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFF00
FF00FFFFFF00FF0000000000FF00FFFF000000000000FFFF
FFFF00FFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FFFF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF0000FF00FFFF
FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFF00FF00FFFF
00FFFF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000
FF00FF0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF0000FFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FF00FF
00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
0000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FF0000FFFFFFFFFFFFFF00FFFFFFFF000000FF00FF00FF00
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFF00FF00FFFFFFFFFFFF00000000FFFFFF0000FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFF00FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
00FF0000000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFF00
00FF00FFFFFFFFFF00FFFFFFFFFF00FFFFFFFFFFFF00FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FFFFFFFF0000FFFFFFFFFFFFFFFFFF00FF00FFFFFF
FFFFFF00FF00FF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000FF00FFFFFFFF00FF000000FFFFFF00FF00FFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
FF0000FF000000000000000000FFFF00FFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFF
FFFFFFFFFF0000FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFF00FFFFFFFFFFFF00FFFFFF00FFFFFFFFFFFF
FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFFFFFF
FFFFFFFFFFFFFFFF
00000000FF000000FF00FF000000FFFFFF00FFFFFFFFFFFF
FFFF00FFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFF00FFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
000000000000FFFF00FF000000FF0000FFFFFF00FF0000FF
FFFFFF0000FFFFFFFFFFFFFFFFFFFFFF00FFFF00FFFFFF00
FFFF00FFFFFFFFFFFFFFFF00FF00FFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
00000000000000FF000000000000FF0000000000FFFF00FF
00FFFF00FF00FFFF00FFFFFF00FF00FFFFFFFFFFFFFF00FF
FFFFFF00FFFFFFFFFFFFFFFF00FFFFFF00FFFFFFFFFF00FF
FF00FF00FFFFFF00FFFFFFFF00FFFF00FFFFFFFFFFFF00FF
FFFFFFFFFFFFFF00FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFF
0000000000000000FF0000000000000000000000FF00FF00
000000FF00FFFFFF0000FF00FFFFFF000000FFFFFFFF00FF
FFFF00FF00FFFFFFFF00FFFFFF00FF00FFFFFFFFFFFF00FF
00FFFFFF00FFFFFFFFFFFF00FFFFFFFFFFFFFF00FFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00FFFFFF0000FFFF
FFFF00FFFFFFFFFF
00000000000000000000000000000000000000000000FF00
00000000FF0000000000FFFFFFFF00FF0000FFFFFFFFFFFF
FFFF00FF0000FFFF00FFFF0000FFFF00FFFFFFFFFF0000FF
FFFF00FFFFFFFFFFFF00FFFFFFFF00FFFFFFFFFFFFFFFF00
FFFFFFFFFFFF0000FFFFFFFFFFFFFFFFFFFFFFFFFF0000FF
00FF00FFFFFFFFFF
00000000000000000000000000000000000000FF00000000
00000000FF00FF00000000FF00000000FF0000FFFF000000
FFFFFFFF00FF00FF00FFFF0000FFFF00FFFFFF00FFFFFFFF
FF00FFFF00FFFF00FFFFFF00FFFFFFFFFF00FFFFFF00FFFF
FFFFFFFFFFFFFFFFFF00FFFF00FFFFFFFFFFFFFF00FFFFFF
FF00FFFFFF00FFFF
00FF000000000000000000000000000000FF000000000000
000000000000FFFF00FF0000FFFF00FF00000000FF00FFFF
FF00000000FF0000FF00000000FFFFFFFF00FFFFFF00FF00
FF00FFFF0000FF0000FFFF00FF00FF000000FFFFFF00FFFF
00FF00FF0000FFFFFF00FF00FFFFFF0000FFFFFF00FFFF00
00FFFF00FF0000FF
000000000000000000000000000000000000000000000000
00000000000000000000FF0000FF000000000000FF0000FF
000000FFFF00000000FFFF000000FF00FF00FFFF00000000
FF0000FF0000FFFF00FF00FF00FFFFFFFFFFFFFF00FF0000
FFFFFFFF00FFFF00000000FF00FFFFFFFFFF00FFFFFFFF00
FF00FF00FFFF0000
0000000000000000FF000000000000000000000000000000
000000FFFF000000000000000000000000000000000000FF
000000FF00000000000000FFFFFF00000000FF000000FF00
FFFF0000FF000000FF00FF0000FF00FF000000FF0000FFFF
0000000000000000FF00FFFF00FF0000FFFFFF000000FF00
00000000FF000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000FF0000FF0000
000000000000000000000000000000FFFF0000000000FFFF
FF00FF0000FF00000000FF00FFFF00FFFF0000FFFF00FF00
0000000000FFFF00FF000000000000FF0000FF0000000000
FF0000FF00000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000FF0000000000000000
0000FF00000000000000FFFF000000000000FF000000FF00
0000FF0000FF000000000000000000000000FFFF0000FFFF
00000000FF00FF00000000000000FF000000000000000000
0000000000000000
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006Oooo`030000
oooooooo02;oool300000oooo`030000oooooooo023oool300000_ooo`030000oooooooo01ooool2
00001?ooo`030000oooooooo023oool00`000?ooooooo`02oooo00<0003oooooool06oooo`D00002
oooo00<0003oooooool00_ooo`030000oooooooo01Woool5000000Coool0000000000003oooo00<0
003oooooool03oooo`006?ooo`030000oooo000002?oool00`000?ooooooo`02oooo00<0003oool0
00008_ooo`060000oooooooo0000oooo00008?ooo`030000oooo000000;oool00`000?ooo`00000P
oooo00<0003oool000000_ooo`030000oooo000001koool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oool000007?ooo`050000oooooooooooo000000Coool00`000?ooo`00000@oooo000H
oooo00<0003oool000009?ooo`070000oooooooooooo0000oooo0000023oool4000000Coool0003o
ool0000Poooo00<0003oool000000_ooo`030000oooo0000023oool00`000?ooo`000002oooo00<0
003oool000007_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Loooo00<0
003oooooool00_ooo`070000oooooooooooo0000oooo0000013oool001Soool00`000?ooo`00000T
oooo00L0003oooooooooool0003oool000008?ooo`030000oooo000000;oool00`000?ooo`00000P
oooo0P0000?oool00`000?ooo`00000Qoooo00L0003oooooooooool0003oool000007_ooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Loooo00<0003oooooool00_ooo`070000
oooooooooooo0000oooo0000013oool001Soool00`000?ooo`00000Soooo00<0003oool000000_oo
o`030000oooo0000027oool200000_ooo`030000oooo0000023oool00`000?ooooooo`02oooo00<0
003oool000008?ooo`030000oooo000000;oool00`000?ooo`00000Noooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001coool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000004?ooo`006Oooo`030000oooooooo02?oool00`000?ooooooo`02oooo00<0003ooooo
ool08Oooo`050000oooooooooooo000002;oool200000oooo`030000oooooooo023oool00`000?oo
ooooo`02oooo00<0003oooooool07?ooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
01[oool200001?ooo`030000oooooooo00;oool00`000?ooooooo`0?oooo003ooooo8Oooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool001Gooooo00002`00007oool001Goool0
0`000?ooooooo`02oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool200000Oooo`005Oooo`030000oooooooo00;oool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09?oo
o`030000oooooooo02Goool00`000?ooooooo`0Boooo0@00007oool000ooool00`000?ooooooo`03
oooo00<0003oooooool0ooooo`Ooool100000Oooo`003_ooo`030000oooo000000Coool00`000?oo
ooooo`3ooooo1oooo`400001oooo000>oooo00<0003oool000001?ooo`80003ooooo1oooo`800001
oooo000>oooo00<0003oool000001?ooo`030000oooooooo00;ooolB00002?ooobH00002oooo6P00
00;oool_00001?oooah00002oooo@P0000Coool200002oooo`400001oooo000>oooo00<0003oool0
00001?ooo`030000oooooooo00;ooolB00002?ooobH00002oooo6P0000;oool_00001?oooah00002
oooo@P0000Coool200002oooo`400001oooo000?oooo00<0003oooooool00oooo`030000oooooooo
00;ooom200000_ooo`H00008oooo100000Coool200003?ooo`H00002oooo0P0000Koool600000_oo
o`<00006oooo0P0000Coool:00001_ooo`P00002oooo100000;oool600001?ooo`@00002oooo@000
00Goool100000Oooo`005Oooo`030000oooooooo00;ooom200000_ooo`H00008oooo100000Coool2
00003?ooo`H00002oooo0P0000Koool600000_ooo`<00006oooo0P0000Coool:00001_ooo`P00002
oooo100000;oool600001?ooo`@00002oooo@00000Goool100000Oooo`005Oooo`030000oooooooo
00;ooold00000_ooo``00002oooo100001coool800000_ooo`800002oooo0P0000Soool?00000_oo
o`@00002oooo200000Soool200001_ooo`800004oooo200000Cooom200001Oooo`400001oooo000E
oooo00<0003oooooool00_oooc@00002oooo300000;oool400007?ooo`P00002oooo0P0000;oool2
00002?ooo`l00002oooo100000;oool800002?ooo`800006oooo0P0000Coool800001?oood800005
oooo0@00007oool001Goool00`000?ooooooo`02oooo>00000;oool600001?ooo``00002oooo1P00
01;oool800001?ooo`P00002oooo0`0000;oool600001_ooo`800004oooo0P0000Coool>00000_oo
o`X00002oooo6P0000;oool200000_ooo`800006oooo0P0000[ooolB00001Oooo`400001oooo000E
oooo00<0003oooooool00_ooocP00002oooo1P0000Coool<00000_ooo`H0000Boooo200000Coool8
00000_ooo`<00002oooo1P0000Koool200001?ooo`800004oooo3P0000;oool:00000_oooaX00002
oooo0P0000;oool200001_ooo`80000:oooo4P0000Goool100000Oooo`005Oooo`030000oooooooo
00;ooolB00001_ooo`@00004oooo900000;oool>00000_ooo`H00004oooo0P0000[oool200000_oo
o`800004oooo0P0000;oool400001oooo`X00004oooo0P0000;oool600002?ooobh00002oooo0P00
01Soool200002?ooo`800009oooo0@00007oool001Goool200000ooooa800006oooo100000CooolT
00000_ooo`h00002oooo1P0000Coool200002_ooo`800002oooo0P0000Coool200000_ooo`@00007
oooo2P0000Coool200000_ooo`H00008oooo;P0000;oool200006?ooo`800008oooo0P0000Soool2
00000Oooo`005Oooo`030000oooooooo00Kooolf00003?oooa000002oooo100000Coool:00004_oo
o`@000000oooo`000000000200000_ooo`h00004oooo100000;oool200000_oooaX00002oooo5000
00;oool200004?ooo`@00004oooo0P0000Soool200002Oooo`400001oooo000Eoooo00<0003ooooo
ool01_ooocH0000<oooo400000;oool400001?ooo`X0000Boooo10000003oooo0000000000800002
oooo3P0000Coool400000_ooo`800002oooo6P0000;ooolD00000_ooo`80000@oooo100000Coool2
00002?ooo`800009oooo0@00007oool001Goool00`000?ooooooo`02oooo?00000;oool400001_oo
oaP0000coooo0P0000cooolL00001?oooaH00006oooo300000Koool400000_ooo`P00007oooo0@00
007oool001Goool00`000?ooooooo`02oooo?00000;oool400001_oooaP0000coooo0P0000cooolL
00001?oooaH00006oooo300000Koool400000_ooo`P00007oooo0@00007oool001Goool00`000?oo
ooooo`0Doooo700000;oool200000_ooo`@00008oooo0P0000Soool400003?ooo`800002oooo0P00
04Ooool200001?ooo`800002oooo0P0000Soool200002?oooa80000:oooo0P0000;oool400001_oo
o`800004oooo1P0000Woool100000Oooo`005Oooo`030000oooooooo01CooolL00000_ooo`800002
oooo100000Soool200002?ooo`@0000<oooo0P0000;oool20000Aoooo`800004oooo0P0000;oool2
00002?ooo`800008oooo4P0000[oool200000_ooo`@00006oooo0P0000Coool600002Oooo`400001
oooo000Eoooo00<0003oooooool00_oooa000008oooo700000;oool200002_ooo`80000Joooo0P00
01Koool20000;Oooo`80000Doooo0P0000;oool200002?ooo`h0000:oooo0P0000;oool400001_oo
o`800008oooo0P0000Woool100000Oooo`005Oooo`030000oooooooo00;oool@00002?oooa`00002
oooo0P0000[oool200006_ooo`80000Foooo0P0002goool200005?ooo`800002oooo0P0000Soool>
00002_ooo`800002oooo100000Koool200002?ooo`800009oooo0@00007oool001Goool00`000?oo
ooooo`02oooo400000SooolD0000<_ooo`80000<oooo0P0000Soool400008oooo`800002oooo0P00
01Soool200003_ooo`h0000[oooo0@00007oool001Goool200000ooooa000008oooo500003;oool2
00003?ooo`800008oooo100002?oool200000_ooo`80000Hoooo0P0000koool>0000:_ooo`800001
oooo000Eoooo00<0003oooooool00_oooa000008oooo200000[oool200002_ooo`80000@oooo0P00
01Coool200002?ooo`800004oooo0P0000[oool200009Oooo`800002oooo100000koool200001?oo
o`800008oooo0P0000Coool>00001?ooo`@00002oooo100000Koool400001_ooo`@00007oooo0@00
007oool001Goool00`000?ooooooo`02oooo400000Soool800002_ooo`80000:oooo0P00013oool2
00005?ooo`800008oooo0P0000Coool200002_ooo`80000Uoooo0P0000;oool400003_ooo`800004
oooo0P0000Soool200001?ooo`h00004oooo100000;oool400001_ooo`@00006oooo100000Ooool1
00000Oooo`005Oooo`030000oooooooo00;oool@00001?ooo`X00006oooo1P0000Soool200000_oo
o`800002oooo0P0000Koool400006?ooo`800006oooo0P0000Coool200000_ooo`800006oooo0P00
00Woool200000_ooo`80000Hoooo0P0000;oool400003?ooo`800006oooo1P0001;ooolD00001_oo
o`@00002oooo0P0000;oool400001oooo`400001oooo000Eoooo00<0003oooooool00_oooa000004
oooo2P0000Koool600002?ooo`800002oooo0P0000;oool200001_ooo`@0000Hoooo0P0000Koool2
00001?ooo`800002oooo0P0000Koool200002Oooo`800002oooo0P0001Soool200000_ooo`@0000<
oooo0P0000Koool600004_oooa@00006oooo100000;oool200000_ooo`@00007oooo0@00007oool0
01Goool00`000?ooooooo`02oooo400000;oool:00002_ooo`800008oooo1P0000Coool200008_oo
o`800006oooo0P0000Soool200002?ooo`80000;oooo0P0001Coool200001?ooo`H0000:oooo2000
00Coool400001?ooo`800002oooo0P0000coool400000_ooo`@00004oooo100000Coool400001_oo
o`800009oooo0@00007oool001Goool00`000?ooooooo`02oooo400000;oool:00002_ooo`800008
oooo1P0000Coool200008_ooo`800006oooo0P0000Soool200002?ooo`80000;oooo0P0001Coool2
00001?ooo`H0000:oooo200000Coool400001?ooo`800002oooo0P0000coool400000_ooo`@00004
oooo100000Coool400001_ooo`800009oooo0@00007oool001Goool00`000?ooooooo`02oooo6000
00coool200000_ooo`80000<oooo100002Coool200004?ooo`800008oooo0P0000Ooool200001?oo
o`80000>oooo100000Coool800002?ooo`800006oooo0P0000Koool600005_ooo`800004oooo1P00
00Coool600001_ooo`@00007oooo0@00007oool001Goool00`000?ooooooo`02oooo600000coool2
00000_ooo`80000<oooo100002Coool200004?ooo`800008oooo0P0000Ooool200001?ooo`80000>
oooo100000Coool800002?ooo`800006oooo0P0000Koool600005_ooo`800004oooo1P0000Coool6
00001_ooo`@00007oooo0@00007oool001Goool00`000?ooooooo`02oooo500001Coool200000_oo
o`@00006oooo0P0000coool200006?ooo`80000Boooo0P0000Soool200002Oooo`@0000Foooo2000
00Koool600001?ooo`800006oooo1P0000Koool400005_ooo`@00004oooo100000Coool200002ooo
o`400001oooo000Eoooo0P0000?ooolD00005?ooo`800002oooo100000Koool200003?ooo`80000H
oooo0P0001;oool200002?ooo`800009oooo100001Koool800001_ooo`H00004oooo0P0000Koool6
00001_ooo`@0000Foooo100000Coool400001?ooo`80000:oooo0P00007oool001Goool00`000?oo
ooooo`02oooo200000;oool>00004_ooo`H0000Doooo0P0001Soool200007?ooo`@00009oooo0P00
013oool400001?ooo`P0000>oooo0P0000Koool400002?ooo`800006oooo200000coool:00004Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`P00002oooo3P0001;oool600005?ooo`80000H
oooo0P0001coool400002Oooo`80000@oooo100000Coool800003_ooo`800006oooo100000Soool2
00001_ooo`P0000<oooo2P00017oool100000Oooo`005Oooo`030000oooooooo00;oool800000_oo
o`800002oooo100000;oool200001?ooo`H00006oooo200000;oool200000_ooo`80000Xoooo0P00
01coool400008oooo`P0000:oooo0P0000coool400001?ooo`800004oooo0P0000Coool600003?oo
o`X00004oooo0P0000_oool100000Oooo`005Oooo`030000oooooooo00;oool800000_ooo`800002
oooo100000;oool200001?ooo`H00006oooo200000;oool200000_ooo`80000Xoooo0P0001coool4
00008oooo`P0000:oooo0P0000coool400001?ooo`800004oooo0P0000Coool600003?ooo`X00004
oooo0P0000_oool100000Oooo`005Oooo`030000oooooooo00;oool<00000_ooo`80000:oooo0P00
00;oool200001?ooo`X00002oooo1000013oool200005_ooo`@0000Noooo0P00027oool:00002_oo
o`800002oooo0P0000Soool200000_ooo`80000@oooo0P0000Koool400001_ooo`800002oooo3000
00Woool100000Oooo`005Oooo`030000oooooooo00;oool<00000_ooo`80000:oooo0P0000;oool2
00001?ooo`X00002oooo1000013oool200005_ooo`@0000Noooo0P00027oool:00002_ooo`800002
oooo0P0000Soool200000_ooo`80000@oooo0P0000Koool400001_ooo`800002oooo300000Woool1
00000Oooo`005Oooo`030000oooooooo00;oool:00000_ooo`80000<oooo0P0000;oool200000_oo
o`@00002oooo0P0000Koool40000:_ooo`80000Loooo0P0000;oool00`000?ooooooo`04oooo1000
01Coool200000_ooo`@00006oooo0P0000;oool200000_ooo`@0000:oooo100000Soool200007?oo
o``00004oooo0P0000Goool100000Oooo`002Oooo`<00003oooo00<0003oooooool00oooo`030000
oooooooo00;oool:00000_ooo`80000<oooo0P0000;oool200000_ooo`@00002oooo0P0000Koool4
0000:_ooo`80000Loooo0P0000;oool00`000?ooooooo`04oooo100001Coool200000_ooo`@00006
oooo0P0000;oool200000_ooo`@0000:oooo100000Soool200007?ooo``00004oooo0P0000Goool1
00000Oooo`002Oooo`030000oooooooo00;oool00`000?ooo`000004oooo00<0003oooooool00_oo
o`H0000:oooo0P0000;oool200000_ooo`H00002oooo100000Coool200002_ooo`80000Xoooo0P00
01koool300002_ooo`80000Boooo0P0000Koool200001?ooo`800008oooo0P0000Soool400000_oo
o`80000Loooo0P0000Soool200001?ooo`X00005oooo0@00007oool000[oool01`000?oooooooooo
o`000?ooo`000004oooo0P0000?oool600002_ooo`800002oooo0P0000;oool600000_ooo`@00004
oooo0P0000[oool20000:?ooo`80000Noooo0`0000[oool200004_ooo`800006oooo0P0000Coool2
00002?ooo`800008oooo100000;oool200007?ooo`800008oooo0P0000Coool:00001?ooo`800001
oooo000:oooo00L0003oooooooooool0003oool000001?ooo`030000oooooooo00;oool600000_oo
o`800006oooo100000Coool200001?ooo`H0000>oooo0P0000koool200005_ooo`@0000Noooo0P00
00;oool300002?ooo`80000Hoooo0P00013oool200002?ooo`@00002oooo0P0000Coool200004?oo
o`@0000<oooo3P0000Ooool100000Oooo`002Oooo`030000oooo000000;oool00`000?ooo`000004
oooo00<0003oooooool00_ooo`H00002oooo0P0000Koool400001?ooo`800004oooo1P0000koool2
00003_ooo`80000Foooo100001koool200000_ooo`<00008oooo0P0001Soool200004?ooo`800008
oooo100000;oool200001?ooo`80000@oooo100000coool>00001oooo`400001oooo000:oooo00<0
003oooooool00_ooo`030000oooooooo00?oool00`000?ooooooo`02oooo1P0000Coool200001_oo
o`800006oooo1P00013oool20000:?ooo`@0000Hoooo0P0000;oool200004Oooo`80000Doooo1000
013oool200002?ooo`800008oooo0P0000;oool400000_ooo`800008oooo100000[oool200000_oo
o`h00005oooo0@00007oool001Goool00`000?ooooooo`02oooo1P0000Coool200001_ooo`800006
oooo1P00013oool20000:?ooo`@0000Hoooo0P0000;oool200004Oooo`80000Doooo1000013oool2
00002?ooo`800008oooo0P0000;oool400000_ooo`800008oooo100000[oool200000_ooo`h00005
oooo0@00007oool001Goool00`000?ooooooo`02oooo200000Soool600000_ooo`H0000:oooo0P00
00Koool400008?ooo`800006oooo0P0000Soool400006Oooo`800008oooo0P0000coool200004_oo
o`@00004oooo0P0000coool200000_ooo`80000Roooo4P0000Goool100000Oooo`005Oooo`030000
oooooooo00;oool800002?ooo`H00002oooo1P0000[oool200001_ooo`@0000Poooo0P0000Koool2
00002?ooo`@0000Ioooo0P0000Soool200003?ooo`80000Boooo100000Coool200003?ooo`800002
oooo0P0002;ooolB00001Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`P00006oooo0P00
00;oool200000_ooo`@0000<oooo0P0000Koool20000;?ooo`800008oooo0P0000Soool200004Ooo
o`@0000Foooo0P0000Koool200001?ooo`800006oooo0P0000;oool200002_ooo`@00002oooo0P00
00;oool400004?ooo`80000:oooo400000Ooool100000Oooo`005Oooo`030000oooooooo00;oool8
00001_ooo`800002oooo0P0000;oool400003?ooo`800006oooo0P0002coool200002?ooo`800008
oooo0P00017oool400005_ooo`800006oooo0P0000Coool200001_ooo`800002oooo0P0000[oool4
00000_ooo`800002oooo1000013oool200002_oooa000007oooo0@00007oool001Goool00`000?oo
ooooo`02oooo200000Coool400001_ooo`80000:oooo0P0000Coool200005?ooo`800002oooo0P00
01;oool200000_ooo`@0000:oooo0P0000;oool200000_ooo`80000Aoooo100000Soool200003?oo
o`P0000Noooo100000;oool200001?ooo`80000>oooo100000;oool200001?ooo``00002oooo1000
00Ooool100000Oooo`005Oooo`800003oooo200000Coool400001_ooo`80000:oooo0P0000Coool2
00005?ooo`800002oooo0P0001;oool200000_ooo`@0000:oooo0P0000;oool200000_ooo`80000A
oooo100000Soool200003?ooo`P0000Noooo100000;oool200001?ooo`80000>oooo100000;oool2
00001?ooo``00002oooo100000Koool200000Oooo`005Oooo`030000oooooooo00;ooolB00003?oo
o`H00006oooo0P0000Coool400002_ooo`80000Boooo0P0000;oool200000_ooo`@0000<oooo0P00
00;oool200002_ooo`80000;oooo0P0000Koool200000_ooo`800008oooo0P0002[oool400000_oo
o`800002oooo0P0000Koool400000_ooo`@00002oooo0P0000;oool@00002Oooo`400001oooo000E
oooo00<0003oooooool00_oooa80000<oooo1P0000Koool200001?ooo`@0000:oooo0P0001;oool2
00000_ooo`800002oooo100000coool200000_ooo`80000:oooo0P0000_oool200001_ooo`800002
oooo0P0000Soool20000:_ooo`@00002oooo0P0000;oool200001_ooo`@00002oooo100000;oool2
00000_oooa000009oooo0@00007oool001Goool00`000?ooooooo`02oooo2P0000;oool600003?oo
o`@00006oooo0P0000;oool600004?ooo`80000>oooo300000Koool400003_ooo`80000?oooo0P00
00Koool200002_ooo`800008oooo0P0000Coool200002?ooo`80000:oooo0P0000Koool800006?oo
oa800009oooo0@00007oool001Goool00`000?ooooooo`02oooo2P0000;oool600003?ooo`@00006
oooo0P0000;oool600004?ooo`80000>oooo300000Koool400003_ooo`80000?oooo0P0000Koool2
00002_ooo`800008oooo0P0000Coool200002?ooo`80000:oooo0P0000Koool800006?oooa800009
oooo0@00007oool001Goool00`000?ooooooo`02oooo1P0000;oool200001?ooo`80000@oooo0P00
00Koool200005?ooo`80000Boooo0P0000;oool800002?ooo`800004oooo100000;oool400008ooo
o`80000Toooo0P0000Soool:00000_ooo`@00004oooo200000CooolF00001Oooo`400001oooo000E
oooo00<0003oooooool00_ooo`H00002oooo0P0000Coool200004?ooo`800006oooo0P0001Coool2
00004_ooo`800002oooo200000Soool200001?ooo`@00002oooo100002?oool200009?ooo`800008
oooo2P0000;oool400001?ooo`P00004oooo5P0000Goool100000Oooo`005Oooo`030000oooooooo
00;oool200002_ooo`80000@oooo1P0000;oool200000_ooo`800004oooo0P0000coool200005?oo
o`800002oooo1P0000Koool400001?ooo`800004oooo100001?oool200004_ooo`80000:oooo0P00
01Coool200001_ooo``00002oooo0P0000Soool400001_ooo``00002oooo100000;oool200001Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`80000:oooo0P00013oool600000_ooo`800002
oooo0P0000Coool200003?ooo`80000Doooo0P0000;oool600001_ooo`@00004oooo0P0000Coool4
00004oooo`80000Boooo0P0000[oool200005?ooo`800006oooo300000;oool200002?ooo`@00006
oooo300000;oool400000_ooo`800005oooo0@00007oool001Goool00`000?ooooooo`04oooo0P00
013oool200000_ooo`@00004oooo0P0000Koool200001_ooo`80000@oooo0P0001Coool800002?oo
o`800006oooo0P0000koool00`000?ooooooo`08oooo0P0000koool200008_ooo`800008oooo1P00
00koool600001?oooa@00002oooo0P0000Goool100000Oooo`005Oooo`800005oooo0P00013oool2
00000_ooo`@00004oooo0P0000Koool200001_ooo`80000@oooo0P0001Coool800002?ooo`800006
oooo0P0000koool00`000?ooooooo`08oooo0P0000koool200008_ooo`800008oooo1P0000koool6
00001?oooa@00002oooo0P0000Coool200000Oooo`005Oooo`030000oooooooo01Koool200001_oo
o`X00004oooo100000;oool20000:?ooo`H00004oooo0P0001;oool200001?ooo`<00008oooo1000
00Coool400001_ooo`80000:oooo0P0000[oool400001_ooo`800008oooo0P0000;oool200001?oo
o`H00006oooo100000KooolH00001Oooo`400001oooo000Eoooo00<0003oooooool05_ooo`800006
oooo2P0000Coool400000_ooo`80000Xoooo1P0000Coool200004_ooo`800004oooo0`0000Soool4
00001?ooo`@00006oooo0P0000[oool200002_ooo`@00006oooo0P0000Soool200000_ooo`800004
oooo1P0000Koool400001_oooaP00005oooo0@00007oool001Goool00`000?ooooooo`06oooo0P00
00Soool200001_ooo`800006oooo100000Soool200000_ooo`@0000@oooo0P0001;oool400001?oo
o`800004oooo0P0000Koool200000_ooo`@0000:oooo0P0000_oool400000_ooo`@00006oooo0P00
01Koool400001_ooo`800004oooo0P0000;oool200000_ooo`800006oooo1P0000Coool600000_oo
oaX00005oooo0@00007oool001Goool00`000?ooooooo`06oooo0P0000Soool200001_ooo`800006
oooo100000Soool200000_ooo`@0000@oooo0P0001;oool400001?ooo`800004oooo0P0000Koool2
00000_ooo`@0000:oooo0P0000_oool400000_ooo`@00006oooo0P0001Koool400001_ooo`800004
oooo0P0000;oool200000_ooo`800006oooo1P0000Coool600000_oooaX00005oooo0@00007oool0
01Goool00`000?ooooooo`0:oooo0P0000Coool200001?ooo`@00004oooo0P0000Coool200001?oo
o`P0000Xoooo100000;oool200000_ooo`800006oooo100001;oool300001_ooo`@00002oooo0P00
00;oool200003?ooo`80000Boooo0P0000Coool200000_ooo`800004oooo0P0000Coool200001_oo
o`H00004oooo1P0000Coool<00000_ooo`X00005oooo0@00007oool001Goool00`000?ooooooo`0:
oooo0P0000Coool200001?ooo`@00004oooo0P0000Coool200001?ooo`P0000Xoooo100000;oool2
00000_ooo`800006oooo100001;oool300001_ooo`@00002oooo0P0000;oool200003?ooo`80000B
oooo0P0000Coool200000_ooo`800004oooo0P0000Coool200001_ooo`H00004oooo1P0000Coool<
00000_ooo`X00005oooo0@00007oool001Goool00`000?ooooooo`0Boooo0P0000;oool400001?oo
o`P00004oooo0P0000;oool40000:_ooo`800002oooo0P0000Koool200000_ooo`@0000Ooooo1P00
02Soool200002_ooo`800002oooo100000;oool200000_ooo`@00002oooo0P0000;oool200000_oo
o`h00008oooo1P0000Goool100000Oooo`005Oooo`030000oooooooo01;oool200000_ooo`@00004
oooo200000Coool200000_ooo`@0000Zoooo0P0000;oool200001_ooo`800002oooo100001ooool6
0000:?ooo`80000:oooo0P0000;oool400000_ooo`800002oooo100000;oool200000_ooo`800002
oooo3P0000Soool600001Oooo`400001oooo000Eoooo00<0003oooooool05_ooo`@00004oooo1000
00;oool200001?ooo`P0000Boooo0P0001Koool200001_ooo`800004oooo100001Ooool200004?oo
o`80000@oooo0P0000Soool400001?ooo`80000:oooo0P0000;oool600000_ooo`800002oooo0P00
00KooolF00004Oooo`400001oooo000Eoooo0P0001Ooool400001?ooo`@00002oooo0P0000Coool8
00004_ooo`80000Foooo0P0000Koool200001?ooo`@0000Goooo0P00013oool200004?ooo`800008
oooo100000Coool200002_ooo`800002oooo1P0000;oool200000_ooo`800006oooo5P00013oool2
00000Oooo`005Oooo`030000oooooooo01Soool200001?ooo`@00002oooo0P0000;oool:00004_oo
o`80000Foooo0P0000;oool200001?ooo`@00002oooo0P00013oool200001Oooo`@00004oooo0P00
00Koool400000_ooo`800008oooo0P0000;oool200002_ooo`800004oooo0P0000Soool400001_oo
o`800004oooo100000;oool600000_ooo`800002oooo1P0000Coool200001_ooo`P00005oooo0@00
007oool001Goool00`000?ooooooo`0Hoooo0P0000Coool400000_ooo`800002oooo2P0001;oool2
00005_ooo`800002oooo0P0000Coool400000_ooo`80000@oooo0P0000Goool400001?ooo`800006
oooo100000;oool200002?ooo`800002oooo0P0000[oool200001?ooo`800008oooo100000Koool2
00001?ooo`@00002oooo1P0000;oool200000_ooo`H00004oooo0P0000Koool800001Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`h00008oooo0P0000;oool600000_ooo`H00004oooo1000
02[oool200001_ooo`H00006oooo0P0000;oool200001?ooo`80000Koooo0P00013oool200002_oo
o`@00002oooo0P0000[oool200001?ooo`@00002oooo5P0000Coool400005Oooo`400001oooo000E
oooo00<0003oooooool00_ooo`h00008oooo0P0000;oool600000_ooo`H00004oooo100002[oool2
00001_ooo`H00006oooo0P0000;oool200001?ooo`80000Koooo0P00013oool200002_ooo`@00002
oooo0P0000[oool200001?ooo`@00002oooo5P0000Coool400005Oooo`400001oooo000Eoooo00<0
003oooooool00_oooa@00002oooo0P0000Coool200001?ooo`@00006oooo100002;oool400001?oo
o`@00006oooo0P0000;oool600000_ooo`80000Aoooo1P0000coool200001?ooo`80000Foooo1000
00;oool400001?ooo`@00006oooo100000Koool600000_ooo`H00002oooo100000;oool800002_oo
o`800005oooo0@00007oool001Goool00`000?ooooooo`02oooo500000;oool200001?ooo`800004
oooo100000Koool400008_ooo`@00004oooo100000Koool200000_ooo`H00002oooo0P00017oool6
00003?ooo`800004oooo0P0001Koool400000_ooo`@00004oooo100000Koool400001_ooo`H00002
oooo1P0000;oool400000_ooo`P0000:oooo0P0000Goool100000Oooo`005Oooo`030000oooooooo
00;ooolD00002_ooo`800002oooo1P0000Coool400009?ooo`800002oooo100000;oool200000_oo
o`800006oooo0P0000Koool200008oooo`80000<oooo0P0000[oool200000_ooo`800002oooo0P00
00Koool200001_ooo`H00006oooo200000;oool600002_ooo`800004oooo200000Ooool100000Ooo
o`002_ooo`<00002oooo00<0003oooooool00oooo`030000oooooooo00;ooolD00002_ooo`800002
oooo1P0000Coool400009?ooo`800002oooo100000;oool200000_ooo`800006oooo0P0000Koool2
00008oooo`80000<oooo0P0000[oool200000_ooo`800002oooo0P0000Koool200001_ooo`H00006
oooo200000;oool600002_ooo`800004oooo200000Ooool100000Oooo`002oooo`060000oooooooo
0000oooo00001?ooo`030000oooooooo00coool200003?ooo`800004oooo0P0000;oool600001?oo
o`H00006oooo0P0001[oool200000_ooo`@00006oooo0P0000[oool200005oooo`800002oooo0P00
00[oool400000_ooo`800002oooo0P0000Coool200002?ooo`80000<oooo100001;oool200000_oo
o`800004oooo100000;oool200000_ooo`@0000:oooo100000;oool200001Oooo`400001oooo0009
oooo10000004oooo0000oooo00001?ooo`80000=oooo0P0000coool200001?ooo`800002oooo1P00
00Coool600001_ooo`80000Joooo0P0000;oool400001_ooo`80000:oooo0P0001Ooool200000_oo
o`80000:oooo100000;oool200000_ooo`800004oooo0P0000Soool200003?ooo`@0000Boooo0P00
00;oool200001?ooo`@00002oooo0P0000;oool400002_ooo`@00002oooo0P0000Coool200000Ooo
o`002Oooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool00_oooa@00004
oooo200000;oool800000_ooo`H00008oooo0P0001Soool800001?ooo`@00004oooo0P0000;oool2
00001_ooo`@00008oooo00<0003oooooool05?ooo`@0000Toooo0P0000[oool400000_ooo`@00004
oooo100000;oool400000_ooo`H00004oooo0P0000Coool200000_ooo`800009oooo0@00007oool0
00[oool200000_ooo`030000oooo000000Coool00`000?ooooooo`02oooo500000Coool800000_oo
o`P00002oooo1P0000Soool200006?ooo`P00004oooo100000Coool200000_ooo`800006oooo1000
00Soool00`000?ooooooo`0Doooo100002Coool200002_ooo`@00002oooo100000Coool400000_oo
o`@00002oooo1P0000Coool200001?ooo`800002oooo0P0000Woool100000Oooo`002oooo`050000
oooooooooooo000000Goool00`000?ooooooo`02oooo500000Coool400000_ooo`800004oooo1P00
00;oool600009_ooo`@00002oooo4P0000Koool200000_ooo`800009oooo0P00013oool400005_oo
o`H00006oooo100000Koool400000_ooo`800002oooo200000Coool200000_ooo`@00008oooo0P00
00;oool200001?ooo`80000;oooo0@00007oool001Goool00`000?ooooooo`02oooo500000Coool4
00000_ooo`800004oooo1P0000;oool600009_ooo`@00002oooo4P0000Koool200000_ooo`800009
oooo0P00013oool400005_ooo`H00006oooo100000Koool400000_ooo`800002oooo200000Coool2
00000_ooo`@00008oooo0P0000;oool200001?ooo`80000;oooo0@00007oool001Goool00`000?oo
ooooo`02oooo500000CooolB00001?ooo`@00002oooo0P0000koool200004_ooo`@0000<oooo0P00
00koool200002oooo`@00002oooo100000Coool200001?ooo`80000<oooo0P0000Soool200000_oo
o`800004oooo100000coool400000_ooo`800006oooo0P0000Koool:00001_ooo`80000Aoooo0@00
007oool001Goool00`000?ooooooo`02oooo500000CooolB00001?ooo`@00002oooo0P0000koool2
00004_ooo`@0000<oooo0P0000koool200002oooo`@00002oooo100000Coool200001?ooo`80000<
oooo0P0000Soool200000_ooo`800004oooo100000coool400000_ooo`800006oooo0P0000Koool:
00001_ooo`80000Aoooo0@00007oool001Goool00`000?ooooooo`02oooo500000Coool800000_oo
o`800002oooo100000Coool400001?ooo`800006oooo0P0000Coool200004_ooo`@0000:oooo1000
00koool200003Oooo`@00002oooo1P0000;oool200002_ooo`800004oooo0P0000coool200001?oo
o`80000>oooo1P0000[oool400004?ooo`80000Coooo0@00007oool001Goool00`000?ooooooo`02
oooo500000Coool800000_ooo`800002oooo100000Coool400001?ooo`800006oooo0P0000Coool2
00004_ooo`@0000:oooo100000koool200003Oooo`@00002oooo1P0000;oool200002_ooo`800004
oooo0P0000coool200001?ooo`80000>oooo1P0000[oool400004?ooo`80000Coooo0@00007oool0
01Goool00`000?ooooooo`02oooo500000Koool<00000_ooo`@00002oooo1P0000Koool200000_oo
o`80000Foooo0P0000coool200006?ooo`800005oooo0P0000Coool400000_ooo`800004oooo0P00
00Koool200001?ooo`80000<oooo100000;oool400009_ooo`80000<oooo0P00017oool100000Ooo
o`005Oooo`800003oooo500000Koool<00000_ooo`@00002oooo1P0000Koool200000_ooo`80000F
oooo0P0000coool200006?ooo`800005oooo0P0000Coool400000_ooo`800004oooo0P0000Koool2
00001?ooo`80000<oooo100000;oool400009_ooo`80000<oooo0P00013oool200000Oooo`005Ooo
o`030000oooooooo00;ooolD00001?ooo`h00008oooo1P0000Koool600001_ooo`800004oooo0P00
00Coool200001?ooo`800004oooo0P0001Coool600000_ooo`800002oooo0`0000Coool600002?oo
o`@00006oooo0P0000Coool200004?ooo`800002oooo1P00033oool200004Oooo`400001oooo000E
oooo00<0003oooooool00_oooa@00004oooo3P0000Soool600001_ooo`H00006oooo0P0000Coool2
00001?ooo`800004oooo0P0000Coool200005?ooo`H00002oooo0P0000;oool300001?ooo`H00008
oooo100000Koool200001?ooo`80000@oooo0P0000;oool60000<?ooo`80000Aoooo0@00007oool0
01Goool00`000?ooooooo`02oooo500000Coool<00003?ooo`@0000>oooo0P0000Koool200003?oo
o`800004oooo0P0001;oool600000_ooo`@00003oooo0P0000[oool:00000_ooo`@00002oooo0P00
00Coool200003_ooo`80000boooo0P0000Koool200000_ooo`80000=oooo0@00007oool001Goool0
0`000?ooooooo`02oooo500000Coool<00003?ooo`@0000>oooo0P0000Koool200003?ooo`800004
oooo0P0001;oool600000_ooo`@00003oooo0P0000[oool:00000_ooo`@00002oooo0P0000Coool2
00003_ooo`80000boooo0P0000Koool200000_ooo`80000=oooo0@00007oool001Goool00`000?oo
ooooo`02oooo500000Coool<00006?ooo`80000<oooo100000[oool200001?ooo`80000@oooo1000
00Koool600001Oooo`H00002oooo0P0000Coool:00000_ooo`800004oooo0P0000[oool60000<_oo
o`80000>oooo0P0000Woool100000Oooo`005Oooo`030000oooooooo00;ooolD00001?ooo``0000H
oooo0P0000coool400002_ooo`800004oooo0P00013oool400001_ooo`H00005oooo1P0000;oool2
00001?ooo`X00002oooo0P0000Coool200002_ooo`H0000boooo0P0000koool200002Oooo`400001
oooo000Eoooo00<0003oooooool01_ooo`80000joooo100000Coool200001?ooo`800002oooo0P00
00Coool200002?ooo`@00006oooo200000;ooolA00001_ooo`800002oooo300000Koool200001_oo
o`@00010oooo0P0000;oool200001_ooo`800007oooo0@00007oool001Goool00`000?ooooooo`06
oooo0P0003[oool400001?ooo`800004oooo0P0000;oool200001?ooo`800008oooo100000Koool8
00000_oooa400006oooo0P0000;oool<00001_ooo`800006oooo1000043oool200000_ooo`800006
oooo0P0000Ooool100000Oooo`005Oooo`030000oooooooo04[oool200000_ooo`@00002oooo0P00
00[oool200000_ooo`800004oooo2P0000CooolE00000_ooo`P00002oooo1P0000Koool60000B_oo
o``00005oooo0@00007oool001Goool20000Boooo`800002oooo100000;oool200002_ooo`800002
oooo0P0000Coool:00001?oooaD00002oooo200000;oool600001_ooo`H0001:oooo300000Coool2
00000Oooo`005Oooo`030000oooooooo05;oool200000_ooo`800008oooo0P0000Soool200000_oo
o`@00002oooo6@0000;oool800000_ooo`H00004oooo100005Soool200001Oooo`400001oooo000E
oooo00<0003oooooool0D_ooo`800002oooo0P0000Soool200002?ooo`800002oooo100000;ooolI
00000_ooo`P00002oooo1P0000Coool40000F?ooo`800005oooo0@00007oool001Goool00`000?oo
ooooo`1Doooo0P0000;oool400001_ooo`800006oooo0P0000;oool200000_oooal00002oooo1000
00;oool600001?ooo`@00014oooo1P0000[oool200002Oooo`400001oooo000Eoooo00<0003ooooo
ool0E?ooo`800002oooo100000Koool200001_ooo`800002oooo0P0000;ooolO00000_ooo`@00002
oooo1P0000Coool40000A?ooo`H0000:oooo0P0000Woool100000Oooo`005Oooo`030000oooooooo
05Koool200003?ooo`X00002oooo8@0000;oool200000_ooo`P00004oooo0P0005;oool200000_oo
o`800009oooo0@00007oool001Goool00`000?ooooooo`1Foooo0P0000coool:00000_ooob400002
oooo0P0000;oool800001?ooo`80001Boooo0P0000;oool200002Oooo`400001oooo000Eoooo00<0
003oooooool0F_ooo`800004oooo0P0000;ooolk00000_ooo`80001Foooo0P0000_oool100000Ooo
o`005Oooo`030000oooooooo05[oool200001?ooo`800002oooo>`0000;oool20000E_ooo`80000;
oooo0@00007oool001Goool00`000?ooooooo`1Poooo100000Cooolk0000Hoooo`400001oooo000E
oooo0P00067oool400001?oooc/0001Roooo0P00007oool001Goool00`000?ooooooo`1Toooo0P00
00;oooli0000IOooo`400001oooo000Eoooo00<0003oooooool0I?ooo`800002oooo>@0006Goool1
00000Oooo`005Oooo`030000oooooooo06;oool200000_ooo`800002oooo<`0006Woool100000Ooo
o`005Oooo`030000oooooooo06;oool200000_ooo`800002oooo<`0006Woool100000Oooo`005Ooo
o`030000oooooooo06;oool200000_ooocD0001[oooo0@00007oool001Goool00`000?ooooooo`1R
oooo0P0000;ooole0000Joooo`400001oooo000Eoooo00<0003oooooool0H?ooo`@00004oooo<`00
06_oool100000Oooo`002Oooo`800004oooo00<0003oooooool00oooo`030000oooooooo063oool4
00001?oooc<0001[oooo0@00007oool000Woool00`000?ooo`000002oooo00<0003oool000001?oo
o`030000oooooooo06Kooolc0000KOooo`400001oooo0009oooo00<0003oool000000_ooo`030000
oooo000000Coool20000Iooooc<0001/oooo0P00007oool000Woool200000oooo`030000oooo0000
00Coool00`000?ooooooo`1Toooo<@00077oool100000Oooo`002Oooo`030000oooooooo00;oool0
0`000?ooo`000004oooo00<0003oooooool0I?oooc40001aoooo0@00007oool000[oool200000ooo
o`030000oooooooo00?oool00`000?ooooooo`1Xoooo:`0007?oool100000Oooo`005Oooo`030000
oooooooo06Soool[0000Loooo`400001oooo000Eoooo00<0003oooooool0J?ooobd0001aoooo0@00
007oool001Goool00`000?ooooooo`1Xoooo;@00077oool100000Oooo`005Oooo`030000oooooooo
06Coool>00001_oooal0001_oooo0@00007oool001Goool00`000?ooooooo`1Toooo3P0000KooolO
0000Koooo`400001oooo000Eoooo00<0003oooooool0I?ooo`h00008oooo7`0006goool100000Ooo
o`005Oooo`80001Uoooo3P0000SooolO0000K?ooo`800001oooo000Eoooo00<0003oooooool0H_oo
oaH00004oooo0P0000;ooolI0000KOooo`400001oooo000Eoooo00<0003oooooool0H_oooaH00004
oooo0P0000;ooolI0000KOooo`400001oooo000Eoooo00<0003oooooool0H_oooaX00006oooo2`00
00;oool<0000Joooo`400001oooo000Eoooo00<0003oooooool0H_oooaX00006oooo2`0000;oool<
0000Joooo`400001oooo000Eoooo00<0003oooooool0G?oooa000002oooo100000CooolU0000Jooo
o`400001oooo000Eoooo00<0003oooooool0G?oooa000002oooo100000CooolU0000Joooo`400001
oooo000Eoooo00<0003oooooool0G_ooo``00002oooo1P0000;ooolG00000_oooa80001Woooo0@00
007oool001Goool00`000?ooooooo`1Noooo300000;oool600000_oooaL00002oooo4P0006Ooool1
00000Oooo`005Oooo`030000oooooooo05koool>00001?ooo`h00005oooo700006Ooool100000Ooo
o`005Oooo`80001Ooooo3P0000Coool>00001Ooooa`0001Voooo0P00007oool001Goool00`000?oo
ooooo`1Loooo300000;oool400000_ooo`800002oooo1P0000CooolQ0000Ioooo`400001oooo000E
oooo00<0003oooooool0G?ooo``00002oooo100000;oool200000_ooo`H00004oooo8@0006Ooool1
00000Oooo`005Oooo`030000oooooooo05[oool>00000_ooo`@00004oooo0P0000CooolE00000_oo
oa00001Woooo0@00007oool001Goool00`000?ooooooo`1Joooo3P0000;oool400001?ooo`800004
oooo5@0000;oool@0000Ioooo`400001oooo000Eoooo00<0003oooooool0F_oooa800002oooo0P00
01;oool00`000?ooooooo`02oooo6P0006Goool100000Oooo`005Oooo`030000oooooooo05[ooolB
00000_ooo`80000Boooo00<0003oooooool00_oooaX0001Uoooo0@00007oool001Goool00`000?oo
ooooo`1Joooo0P0000;oool<00001_ooo`800008oooo100000;oool900000_oooaH0001Uoooo0@00
007oool001Goool00`000?ooooooo`1Joooo0P0000;oool<00001_ooo`800008oooo100000;oool9
00000_oooaH0001Uoooo0@00007oool001Goool00`000?ooooooo`1Joooo3P0000;oool200003_oo
o`/00004oooo0P0000;ooolD0000IOooo`400001oooo000Eoooo0P0005_oool>00000_ooo`80000>
oooo2`0000Coool200000_oooa@0001Toooo0P00007oool001Goool00`000?ooooooo`1Hoooo3P00
00;oool800000_ooo`800002oooo5@0000;ooolD0000IOooo`400001oooo000Eoooo00<0003ooooo
ool0F?ooo`h00002oooo200000;oool200000_oooaD00002oooo500006Goool100000Oooo`005Ooo
o`030000oooooooo05Soool>00001_ooo`@00004oooo0P0000;ooolC00000_oooa@0001Uoooo0@00
007oool001Goool00`000?ooooooo`1Hoooo3P0000Koool400001?ooo`800002oooo4`0000;ooolD
0000IOooo`400001oooo000Eoooo00<0003oooooool0F?ooo`X0000<oooo0P0000Coool200001?oo
o`800002oooo1@0000;oool200001_ooo`H00002oooo300006Goool100000Oooo`005Oooo`030000
oooooooo05Soool:00003?ooo`800004oooo0P0000Coool200000_ooo`D00002oooo0P0000Koool6
00000_ooo``0001Uoooo0@00007oool001Goool00`000?ooooooo`1Joooo2P0000koool200001?oo
o`800006oooo1@0001;oool:0000IOooo`400001oooo000:oooo00<0003oooooool00_ooo`030000
oooooooo00?oool00`000?ooooooo`1Joooo2P0000koool200001?ooo`800006oooo1@0001;oool:
0000IOooo`400001oooo0009oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?oo
ooooo`1Joooo2P0000Koool:00001?ooo`800002oooo0P0000;oool500000_ooo``00004oooo2000
06Ooool100000Oooo`002Oooo`030000oooo000000;oool00`000?ooo`000004oooo0P0005_oool:
00001_ooo`X00004oooo0P0000;oool200000_ooo`D00002oooo300000Coool80000I_ooo`800001
oooo000:oooo00L0003oooooooooool0003oool000001?ooo`030000oooooooo05Soool800002_oo
o`800002oooo200000[oool300000_ooo`h00004oooo200006Ooool100000Oooo`002Oooo`030000
oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0F?ooo`P0000:oooo0P0000;oool8
00002_ooo`<00002oooo3P0000Coool80000Ioooo`400001oooo000:oooo00<0003oooooool00_oo
o`030000oooooooo00?oool00`000?ooooooo`1Joooo700000coool500000_oooaH0001Woooo0@00
007oool001Goool00`000?ooooooo`1Joooo700000coool500000_oooaH0001Woooo0@00007oool0
01Goool00`000?ooooooo`1Hoooo2P0000;ooolF00002?oooad0001Woooo0@00007oool001Goool0
0`000?ooooooo`1Hoooo2P0000;ooolF00002?oooad0001Woooo0@00007oool001Goool00`000?oo
ooooo`1Hoooo400000;oool200000_ooo`h00004oooo7`0006Ooool100000Oooo`005Oooo`030000
oooooooo05Soool@00000_ooo`800002oooo3P0000CooolO0000Ioooo`400001oooo000Eoooo00<0
003oooooool0F?ooo`@00006oooo2P0000Koool:00001?ooo`L00002oooo1P0000;oool>0000Iooo
o`400001oooo000Eoooo0P0005Woool400001_ooo`X00006oooo2P0000Coool700000_ooo`H00002
oooo3P0006Koool200000Oooo`005Oooo`030000oooooooo05Soool200002?ooo`800002oooo0P00
00;oool400001_ooob/0001Woooo0@00007oool001Goool00`000?ooooooo`1Hoooo0P0000Soool2
00000_ooo`800002oooo100000Koool[0000Ioooo`400001oooo000Eoooo00<0003oooooool0F?oo
o`80000:oooo5P0000SooolI00000_ooo`80001Woooo0@00007oool001Goool00`000?ooooooo`1H
oooo0P0000[ooolF00002?oooaT00002oooo0P0006Ooool100000Oooo`005Oooo`030000oooooooo
05[oool200001?ooo`800002oooo0P0000Koool200000_ooo`X00002oooo0P0000Coool;00002?oo
o`800004oooo100006Ooool100000Oooo`005Oooo`030000oooooooo05[oool200001?ooo`800002
oooo0P0000Koool200000_ooo`X00002oooo0P0000Coool;00002?ooo`800004oooo100006Ooool1
00000Oooo`005Oooo`030000oooooooo05[oool400004_ooo`80000Coooo100000;oool200003_oo
o`80001Yoooo0@00007oool001Goool00`000?ooooooo`1Joooo100001;oool200004oooo`@00002
oooo0P0000koool20000JOooo`400001oooo000Eoooo00<0003oooooool0H_ooo`80000Boooo0P00
00ooool200000_ooo`800004oooo0P0000Coool200000_ooo`80001Yoooo0@00007oool001Goool2
0000Hoooo`80000Boooo0P0000ooool200000_ooo`800004oooo0P0000Coool200000_ooo`80001X
oooo0P00007oool001Goool00`000?ooooooo`1Loooo100002goool400000_ooo`800002oooo1000
06_oool100000Oooo`005Oooo`030000oooooooo05coool40000;Oooo`@00002oooo0P0000;oool4
0000Joooo`400001oooo000Eoooo00<0003oooooool0K_ooo`80000Coooo100000Soool20000MOoo
o`400001oooo000Eoooo00<0003oooooool0K_ooo`80000Coooo100000Soool20000MOooo`400001
oooo000Eoooo00<0003oooooool0H?ooo`80000Woooo0P0000;oool200000_ooo`800002oooo0P00
06ooool100000Oooo`005Oooo`030000oooooooo063oool200009oooo`800002oooo0P0000;oool2
00000_ooo`80001_oooo0@00007oool001Goool00`000?ooooooo`1Roooo200002Goool60000LOoo
o`400001oooo000Eoooo00<0003oooooool0H_ooo`P0000Uoooo1P00077oool100000Oooo`005Ooo
o`030000oooooooo06Coool400003_ooo`800008oooo1@0000;oool200000_ooo`800002oooo0P00
07Goool100000Oooo`005Oooo`80001Uoooo100000koool200002?ooo`D00002oooo0P0000;oool2
00000_ooo`80001doooo0P00007oool001Goool00`000?ooooooo`1Zoooo0P0000;oool200003?oo
o`L00006oooo100007Woool100000Oooo`005Oooo`030000oooooooo06[oool200000_ooo`80000<
oooo1`0000Koool40000NOooo`400001oooo000Eoooo00<0003oooooool0K?ooo`800008oooo0P00
00[oool00`000?ooooooo`21oooo0@00007oool001Goool00`000?ooooooo`1/oooo0P0000Soool2
00002_ooo`030000oooooooo087oool100000Oooo`005Oooo`030000oooooooo0?ooool7oooo0@00
007oool001Goool00`000?ooooooo`3ooooo1oooo`400001oooo000Eoooo00<0003oooooool0oooo
o`Ooool100000Oooo`000oooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo00?oool0
0`000?ooooooo`3ooooo1oooo`400001oooo0005oooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000Coool00`000?ooooooo`3ooooo1oooo`400001oooo0005oooo00L0003ooooo
ooooool0003oool000000_ooo`030000oooo000000Coool20000ooooo`Ooool200000Oooo`001Ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool0oooo
o`Ooool100000Oooo`001Oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004
oooo00<0003oooooool0ooooo`Ooool100000Oooo`001?ooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo00?oool00`000?ooooooo`3ooooo1oooo`400001oooo000Eoooo00<0003ooooo
ool0ooooo`Ooool100000Oooo`005Oooo`030000oooooooo0?ooool7oooo0@00007oool001Goool0
0`000?ooooooo`3ooooo1oooo`400001oooo000Eoooo00<0003oooooool0ooooo`Ooool100000Ooo
o`005Oooo`030000oooooooo0?ooool7oooo0@00007oool001Goool00`000?ooooooo`3ooooo1ooo
o`400001oooo000Eoooo0P000?ooool7oooo0P00007oool001Goool00`000?ooooooo`06oooo0P00
0?koool100000Oooo`005Oooo`030000oooooooo00Koool20000o_ooo`400001oooo000Eoooo00<0
003oooooool0ooooo`Ooool100000Oooo`005Oooo`030000oooooooo0?ooool7oooo0@00007oool0
01Goool00`000?ooooooo`3ooooo1oooo`400001oooo000Eoooo00<0003oooooool0ooooo`Ooool1
00000Oooo`005Oooo`030000oooooooo00[oool200002_ooo`80003^oooo0@00007oool001Goool0
0`000?ooooooo`0:oooo0P0000[oool20000k_ooo`400001oooo000Eoooo00<0003oooooool06?oo
o`80003/oooo0@00007oool001Goool200006Oooo`80003[oooo0P00007oool001Goool00`000?oo
ooooo`0:oooo0P000?[oool100000Oooo`005Oooo`030000oooooooo00[oool20000n_ooo`400001
oooo000Eoooo00<0003oooooool01_ooo`80000<oooo0P000?3oool100000Oooo`005Oooo`030000
oooooooo00Koool200003?ooo`80003`oooo0@00007oool001Goool00`000?ooooooo`02oooo0P00
00;oool:0000koooo`800005oooo0@00007oool001Goool00`000?ooooooo`02oooo0P0000;oool:
0000koooo`800005oooo0@00007oool001Goool00`000?ooooooo`02oooo0P0000;oool200002_oo
o`80000:oooo0P0000coool20000f?ooo`400001oooo000Eoooo00<0003oooooool00_ooo`800002
oooo0P0000[oool200002_ooo`80000<oooo0P000=Soool100000Oooo`005Oooo`030000oooooooo
00;oool600002?ooo`@0000Boooo0P0000;oool200003?ooo`800002oooo0P0000;oool20000a?oo
o`400001oooo000Eoooo0P0000?oool600002?ooo`@0000Boooo0P0000;oool200003?ooo`800002
oooo0P0000;oool20000`oooo`800001oooo000Eoooo00<0003oooooool00_ooo`H00002oooo0P00
00Soool200000_ooo`H00006oooo0P0000;oool200004?ooo`80003:oooo0@00007oool001Goool0
0`000?ooooooo`02oooo1P0000;oool200002?ooo`800002oooo1P0000Koool200000_ooo`80000@
oooo0P000<[oool100000Oooo`005Oooo`030000oooooooo00Coool400000_oooa800004oooo0P00
00Soool200009_ooo`80000Hoooo100000koool200007Oooo`80000<oooo0P0000Koool200005?oo
o`80000Joooo0P0001ooool100000Oooo`005Oooo`030000oooooooo00Coool400000_oooa800004
oooo0P0000Soool200009_ooo`80000Hoooo100000koool200007Oooo`80000<oooo0P0000Koool2
00005?ooo`80000Joooo0P0001ooool100000Oooo`005Oooo`030000oooooooo00;oool800000_oo
o`H00002oooo0P0000;oool600001_ooo`80000@oooo0P0000Soool200008?ooo`80000ooooo0P00
01Coool20000Boooo`400001oooo000Eoooo00<0003oooooool00_ooo`P00002oooo1P0000;oool2
00000_ooo`H00006oooo0P00013oool200002?ooo`80000Poooo0P0003ooool200005?ooo`80001;
oooo0@00007oool001Goool00`000?ooooooo`02oooo300000Coool200000_ooo`H00002oooo1000
00Koool200000_ooo`@00008oooo100001Koool200001?ooo`800006oooo0P0000Coool200004?oo
o`800002oooo0P0008Soool100000Oooo`000oooo`D000001?ooo`000000000000?oool00`000?oo
ooooo`03oooo00<0003oooooool00_ooo``00004oooo0P0000;oool600000_ooo`@00006oooo0P00
00;oool400002?ooo`@0000Foooo0P0000Coool200001_ooo`800004oooo0P00013oool200000_oo
o`800028oooo0@00007oool000Goool01@000?ooooooooooo`000004oooo00<0003oool000001?oo
o`030000oooooooo00;oool>00000_ooo``00002oooo2P0000Coool200000_ooo`800004oooo0P00
00;oool200001?ooo`800006oooo0P0000;oool200003_ooo`800008oooo0P00013oool200001_oo
o`030000oooooooo00Soool200001?ooo`800002oooo0P0000Koool200002?ooo`800004oooo0P00
00coool200004?ooo`80000eoooo0@00007oool000Goool00`000?ooooooo`02oooo00L0003ooooo
ooooool0003oool000001?ooo`800003oooo3P0000;oool<00000_ooo`X00004oooo0P0000;oool2
00001?ooo`800002oooo0P0000Coool200001_ooo`800002oooo0P0000koool200002?ooo`80000@
oooo0P0000Koool00`000?ooooooo`08oooo0P0000Coool200000_ooo`800006oooo0P0000Soool2
00001?ooo`80000<oooo0P00013oool20000=?ooo`800001oooo0005oooo00<0003oooooool00_oo
o`070000oooooooooooo0000oooo000000Coool00`000?ooooooo`02oooo400000;ooolF00000_oo
o`800002oooo200000;oool200001_ooo`@00002oooo0P0000Koool600002?ooo`800006oooo0P00
00;oool200002?ooo`800006oooo0P0000;oool200002oooo`800002oooo0P0000Koool200003?oo
o`80000>oooo0P0002Soool200001_ooo`@00008oooo0P0000ooool100000Oooo`001Oooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool00_oooa000002
oooo5P0000;oool200000_ooo`P00002oooo0P0000Koool400000_ooo`800006oooo1P0000Soool2
00001_ooo`800002oooo0P0000Soool200001_ooo`800002oooo0P0000_oool200000_ooo`800006
oooo0P0000coool200003_ooo`80000Xoooo0P0000Koool400002?ooo`80000?oooo0@00007oool0
00Coool200001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00_oo
ob`00002oooo2P0000;oool:00002?ooo`800002oooo1000013oool200000_ooo`@00004oooo0P00
00Coool400001?ooo`800009oooo100000Koool200003?ooo`800008oooo0P00013oool200003?oo
o`@0000Joooo100000;oool200000_ooo`80000?oooo0@00007oool001Goool00`000?ooooooo`02
oooo;00000;oool:00000_ooo`X00008oooo0P0000;oool400004?ooo`800002oooo100000Coool2
00001?ooo`@00004oooo0P0000Woool400001_ooo`80000<oooo0P0000Soool200004?ooo`80000<
oooo100001[oool400000_ooo`800002oooo0P0000ooool100000Oooo`005Oooo`030000oooooooo
00;ooolV00000_oooa000002oooo0P0000;oool800000_ooo`P00002oooo100000Coool600002?oo
o`800002oooo0P0000;oool200001?ooo`@00004oooo0P0000Goool200002_ooo`800004oooo0P00
00Coool200001_ooo`80000:oooo0P0000Koool200005_ooo`800004oooo0P0000koool200002?oo
o`800006oooo0P0000Woool100000Oooo`005Oooo`030000oooooooo00;ooolV00000_oooa000002
oooo0P0000;oool800000_ooo`P00002oooo100000Coool600002?ooo`800002oooo0P0000;oool2
00001?ooo`@00004oooo0P0000Goool200002_ooo`800004oooo0P0000Coool200001_ooo`80000:
oooo0P0000Koool200005_ooo`800004oooo0P0000koool200002?ooo`800006oooo0P0000Woool1
00000Oooo`005Oooo`030000oooooooo00;oool200000_oooah00002oooo600000Coool200000_oo
o`@00004oooo0P0000;oool800000_ooo`800006oooo200000;oool400000_ooo`P00007oooo0P00
00Koool200000_ooo`800002oooo0P0000Coool400000_ooo`@00004oooo0P0000;oool200000_oo
o`H00006oooo0P0000Coool200000_ooo`800002oooo100000Koool200000_ooo`800006oooo1000
00Koool200001?ooo`@00004oooo0P0000;oool400001oooo`400001oooo000Eoooo00<0003ooooo
ool00_ooo`800002oooo7P0000;ooolH00001?ooo`800002oooo100000Coool200000_ooo`P00002
oooo0P0000Koool800000_ooo`@00002oooo200000Ooool200001_ooo`800002oooo0P0000;oool2
00001?ooo`@00002oooo100000Coool200000_ooo`800002oooo1P0000Koool200001?ooo`800002
oooo0P0000;oool400001_ooo`800002oooo0P0000Koool400001_ooo`800004oooo100000Coool2
00000_ooo`@00007oooo0@00007oool001Goool00`000?ooooooo`02ooooA00000;oool400000_oo
o``00002oooo100000;oool600001?ooo`P00004oooo1P0000;oool2000000?oool0000000001?oo
o`P00002oooo100000;oool400001?ooo`800002oooo0P0000;oool200003_ooo`800002oooo1000
00Soool200001?ooo`P00002oooo0P0000[oool200002?ooo`800002oooo0P0000;oool200001?oo
o`@00005oooo0@00007oool001Goool200000ooood@00002oooo100000;oool<00000_ooo`@00002
oooo1P0000Coool800001?ooo`H00002oooo0P000003oooo0000000000Coool800000_ooo`@00002
oooo100000Coool200000_ooo`800002oooo0P0000koool200000_ooo`@00008oooo0P0000Coool8
00000_ooo`80000:oooo0P0000Soool200000_ooo`800002oooo0P0000Coool400001?ooo`800001
oooo000Eoooo00<0003oooooool00_oooa000002oooo900000CooolT00000_ooo`H00002oooo3P00
00Koool700000_ooo`H00002oooo0P0000Coool400000_ooo`H00002oooo0P0000;oool400000_oo
o`800002oooo1P0000;oool400001?oooa000002oooo0P0000Coool200000_ooo`@00006oooo1P00
00;oool:00000_ooo`H00005oooo0@00007oool001Goool00`000?ooooooo`02oooo400000;ooolT
00001?ooob@00002oooo1P0000;oool>00001_ooo`L00002oooo1P0000;oool200001?ooo`@00002
oooo1P0000;oool200000_ooo`@00002oooo0P0000;oool600000_ooo`@00004oooo400000;oool2
00001?ooo`800002oooo100000Koool600000_ooo`X00002oooo1P0000Goool100000Oooo`005Ooo
o`030000oooooooo00;ooomD00000_ooo`@00002oooo8P0000?oool:00001_ooo`800002oooo1000
00;oool800000_ooo`800004oooo0P0000Coool400001?ooo`800002oooo300000Coool200000_oo
o``00002oooo100000;oool:00000_ooo`@00002oooo200000Goool100000Oooo`005Oooo`030000
oooooooo00;ooomD00000_ooo`@00002oooo8P0000?oool:00001_ooo`800002oooo100000;oool8
00000_ooo`800004oooo0P0000Coool400001?ooo`800002oooo300000Coool200000_ooo``00002
oooo100000;oool:00000_ooo`@00002oooo200000Goool100000Oooo`005Oooo`030000oooooooo
00;ooom>00000_oooa@00002oooo3P0000Coool;00000_ooo`H00002oooo1P0000;oool400000_oo
oaP00004oooo100000Coool800000_ooo`800002oooo3P0000;ooolR00001Oooo`400001oooo000E
oooo00<0003oooooool00_ooodh00002oooo500000;oool>00001?ooo`/00002oooo1P0000;oool6
00000_ooo`@00002oooo600000Coool400001?ooo`P00002oooo0P0000;oool>00000_ooob800005
oooo0@00007oool001Goool00`000?ooooooo`3ooooo1oooo`400001oooo000Eoooo00<0003ooooo
ool0ooooo`Ooool100000Oooo`005Oooo`030000oooooooo00;oool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09?oo
o`030000oooooooo02Goool00`000?ooooooo`0Boooo0@00007oool001Goool200000oooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`06oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo0P00007oool0
01Gooooo00002`00007oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, 
  0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", " ", 
      StyleBox["Wavelet",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Transform",
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell[BoxData[
    \(\(w = waveletMatrix[128, coif30]; \)\)], "Input"],

Cell[BoxData[
    \(\(wa = w . a . Transpose[w]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListDensityPlot[wa, Mesh -> False]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF86787B76818063C6
00FF8995FF00BA61984C54DB81879F6800A76B827A7C7B7C
7D7A7980787D787C7B7B787E7E73B1627D7B7B7C7B7B7A7C
7B7B788849545A9C2E63E97C6A9172819F55B2707C506F9B
707E7B7C7A7D7C7C7C7C7C7C7C7C7B7C7D7B7D7A7C7E7F7C
7C7C7C7A7D7B7C7B
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF86797D7D7B7F69DF
000004868500C75B6ACCA6A3FF1EAED300CD60847A7C7C7C
7C7C7C7B7D7C7D7C7C7C7C7D76847CFF7B7C7C7C7C7C7C7C
7C7C769C99318889491F00B8D96EBC3572007224D933A89C
767C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B7B7B
7C7B7C7C7C7C7B7C
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF827A7D7D7C7D76AD
9F5DFFFFB3009A698C837A65E46354B6009B6B817A7C7C7C
7C7C7B7C7A7A7A7D7C7B7C7D79874CFF7D7C7B7B7C7C7B7C
7C7A7B88D46181821C85C473A3A9705D61E54C6C919900A5
6C817B7C7C7B7C7C7C7C7C7C7C7C7C7C7B7C7B7B7C7C7B7D
7C7D7C7B7B7C7D7C
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7C7C79787A7F7483
44C1234F669B7681883B2A2BCC83B2858D787D7C7D7D7C7B
7A7A7D7A817D827A797F7B7C787B8973787C7D7D7C7B7F7C
7B7E7C7D62977C8E776F5F4836B26576989CCC6C8E8D9476
7D7C7A7C797E7B7C7C7D7B7C7B7C7C7C7D7B7D7E7C7B7E77
7B7A7A7E7F7B797C
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7C7C868C8175877B
8783847C7E757A70728F79818E836D7B767E7D7B7A797B7C
8283787F647B677A8473807A8A777C7B867D79797B7E717D
7E76797E86737C796C817D7B807F7F6C7B7B6B81737A7B7F
7F78827983777D7B7C7A7E7E7D7B7A7B797C78767C7F7A7F
757D817373808278
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF748560F397A35671
7D6D6193767E849D9B6C7665698988767977738080847F7B
67638182908B9A68689B658B549075915F8081838477A876
778B8171757F7D8092887A7C6F79578974868F718D74677B
6E8E6E866A83797F7B7C76737B817E7C817D828978728A0E
00516E7FA86F6E90
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF75AF52FF949DB914
91B98600806A6D0E269059D89E524A788BA69C7F6D9A798D
ADBE63A2FD1D63E16E8C5DB4FF54F10DAEB35C479ECD927B
972E1C6DCA636D3925664392BD76E363A4552FC15660BCC7
B178ABC0944F8474514ABFA57461764737866D4F73DB0052
28B35ABC8E54E5A0
FFFFFFFFFFFFFFFF66B01DCDFFFFFFFFBC1958D61B666A93
FF6000B07FA28FFF9163C1C6B1FF1ED4A0839B828A79C79C
B6C1AC4D8F767856856AAB37429487516388888177CD7D3D
B0203ED393D816A1067B4795763A7FFFA7FFD6FF403EA952
F2451CFF00FF6251518AFEFF54558F6D6D89E9B882983D58
8E768B6D7FA66D4F
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF9DF300A3D127
483B3F76A0CE8B0086A680F01DCB5B8337AE7F327E7E7088
E3FFFFFF334E53FF2EC3549EC7E6439C86A1547BFF96A467
9B727AB357E9FF49AD3D4E57F47B2CA84786954514936CBB
9E49ABA3842D00B19D846A80FFB17EFF86470939C4FF0075
7168B1A2317C6880
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF900093FF456A86FF
0043323601FF59FFC7A2ED3165FB138600FF93FF0D00DFE2
43FFFFD2C501515B00FF31B23809AF00364C438ECAB66C5C
00896F678948FF65C35739758762A06300CD779D90719EBE
7047C8A0B4FF9DAF3600AE93829E3EAA49AE04FF80BE0070
86BBD65D62D8BA6F
FFFFFFFFFFFFFFBAFFFFFFFFFFFFFFFF00B4FFFF794B93E2
A0005E9E00F3E3AB00E983655A5DCC54506A8EFF4C23FF8A
FF00E9DDC300FF8DE0F7FF09BA6261005038377F6972E8C2
79828396B6800098B43E8B49D09E582E794785287761B80B
FE6F75BC2500998865FF2539BA8F36FF9F78AA687CB60063
647F66BF39A3B0D1
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF4A0020006D0400FF
7E006D40838DC900005C6B51ED3C3F0036BE0012D8570085
FF5CAB7E33570000FF8EA794C3578AAD45A06A2DA26DD3FF
758176D072B2FF65938C00C03C7B953E759E2261755A45C2
475C811CCEB05913A7185EA3E618DD8B6087628D64C1FF82
4704FF00F34C53BA
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF63C500FF009200FF
AC6958E5908BFF0E3B9E1ACE2F9131FF53FF210B6F0000E7
8E67FFFFB07EC84E0000CFEA4B6655FF9F00FF267C8E988B
68887C4F00FFB3FF42BE93AD7D536C2EA1006983A7AFACC1
3310A9B9E1FF24A6C417FFEDD9DF4BEAD17C42B29C975974
77BD48D8E719FFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8A8BBAFF0061926E
874DB513CBA5C600A28982946CDA7FF300A2381FC577915E
609D7080C414FFA8967AFF107A7256FF417F935FB6A3ADA2
667168FF000BFF993200769AB76C6CD7C37FFFBA289A0048
F731AA93FF2366557562878A717C958342FF59E587D60A5E
5E8F53FF00988AB9
71FFFFFFFFFFFFFFFFFFFFFFFFFFE2348464611FB3767B6D
B0A55595D700B984FFDA8F7D618972BB00597E8A70787683
896750B8409454767D71518A908C7B6A877B76877172608A
6F648984435CCF5A6951798591797B747994BABE3A6C2F9D
40807B7C68907E847F817C79807E757C8B7E885985A1AE7A
777C7F689174797C
77FFFFFFFFFFFFFFFFFFFFFFFFFFB5FF7C8184926A7D7A7C
A2FF0069E5E8657643883CBE8E72B559D0757E777E7D7E79
788185728A75897D7D7F8A7677787296787D7E7A7F7F837A
7F81797A8E935A76C157BB846A92867C73817471B75C876A
8F797D7B82767B797B7A7B7C7B7B7E7B777E79867A746F7C
7C7C7B82767E7B7D
7B6F7E72706C756184BB8F8C7C81747C7E77726D5C7A6E89
8273919880777D8581808E807482777D76797A7C7D767E7A
7B797F6F81A18667787B79766C816B8C75877B817D79777C
7A7F847F7D797B81807E8A807E7A778176817A7B7E7E7276
7975787377817A7C81837A7A7B7D7C82857A81817D759753
8470669C8F756874
7D9792A8B7BD98EB5622709E7964A97F7479A7A56A46BA8A
50C19930978D633E3E9F97A1995867818D7A757C6B4D7A82
9CA250834BFF0068B224857BCF6DA157EB994962776C2786
855B697EA5428D4D6E71828D8AAF9C468B4B32859473AE98
7F46AF55AB487883967B9A69848664837F8B605A597F83C0
CF70707E6B84A666
5C0012001F00002190DCFFA0B5014D0068954FAA9CA8488E
356F1DDF6F9887FFFF66951B2EC2843E8A583DB7795C8E7E
272E4D97A85C78A8746A3CA909E78BF0DC3A40745100B888
61B0692EB2049559F4D698AA28D0007E4F767957FF1A2CCB
2E6E6588166551A2B28BB61C61A25F95C79C93B81D15BCC3
6DAB67809A71BED3
FFB5ABFF83ECF5F8FF082AD200007DFFF8FF4F5E73569B5C
035CFF6E2B3559208539424E853978008CBAE8AA24B95143
A9F69F89389B4062888A587EFF4B8595758166454A9741E1
718C2F62925F65BD68489D737173F4A86C4ACE9CA1916CBE
AA179899245F307D7E8AC7954D1E9A91AF44A479CBA16E6E
816A9FBA64637470
0043000000FF2CFF14CD00530014FF821C087A33FF6A592E
62995323834DBAFC8C6E90006399385000AF747300189B39
3F646DFF7E82EA00FC043D9E9C896ED07A2673253E2E9704
A6A0778E59984D6653C5709CA12F7AAC80DA7D6538881B00
0BE67C869EFF248C9BAF76A0DC77B1602BE14F763848CE5B
9ED03455CCA87E7B
7126A976B0532BBB00FFFF4F948F00A740665D6DFF6A7060
CE7AD7F92C8CAC8E49C5F3E5006FD7421985B1339138946D
89C8CE1E2A38537F4A556ED760746465BD50FE7EC4819C78
6E7A7F639A751197B5623B4C81D895673DBDC3589959F4D7
7D3D006500F27DC4FFFF87467C5A70905374E4CB80B80087
DCAC9DFFE1104357
00A67900F8BAB92CFF00D78DE4F6EB44D4A76200FF00F167
00A7161BA594C9F0CDA4B584FF0007356D7B9E8C35E70A78
FFFC911600D5672D3B5E89977562986359CC6F7E6D7D0089
8A7A7E02445EE5902671006E86598458CE84C2F33E36037F
747B985C3000D56F570091A785836975B35CCB64BA16ED8E
4AF26AAB2F5B33A4
F557C07E6F876D0022E37D8E6B006D586453F9363CFFBD68
D000FF510001577A8639B251FFC8458A458F7484FF5E58C1
FF681BDFC35AB4FF581AFF966BA63999B7AA00117A719337
82788A470013516B2D00787C6AAD916E895E47C9003D91C0
BCB96AAED96F8892007E427960DB3EA271945C8561AFB481
7A9A82E600BABA00
E5004E71FF7AC110B5C7FF9E00C5B302682E66627A808712
475693DBD364C2FF8100F1002C684F653C636FFC1C345BE8
A56A546D408E374FA5001F79BCA54D009EB344FF475300F7
AD8086AA4046CEC261FF4BC7A98949A63CA49048E91F3A00
FF778E6236FF61D28FB36A45AE9C2B69D7675127A47F8574
7198627AE74F61B6
7649B807A7BAD4B000000A00E4ADCEFF8484D5FF006B8F8E
157EDF068128992B47AC7827A5642A8EFFF9556E828F8F6B
6DAAA57FEC3EF77BB987FF294F634FC948B2789D9C94B88A
B7CB469985409C16CFDB796560715EC6844B3462FF708800
FF748262B04270667979626A78658E6356A45EFF7C62007C
827673B947905992
86488191796F6A86D7B895A48D8C73637B777150A77D7981
D1A60B9A006C858D5B7974997968973E7475858474767583
817073B6688E5A7771715C8C7785679B85757C7E74787677
80807C66687695FF8E8C91837982846C717C6F9C74B14B93
6387757C6B8B7C827E7D807D7F80767E886F837981868F7F
807C7E6B8F758179
B1BC6B767B7E827B57636D7175A0FF617B7F828C6A7B7E7C
754B711D007574772BEE9D6E5B89B7583B8F75797F7D7E7A
798080748575897E7E7E89767A798889787D7C7B7F7E807C
7D7F7786535FB39143B48475CB5A7485989F60926AB05683
837B7D7C82767B797B7B7B7C7B7B7E7B788079837A79727B
7B7C7B83757E7B7D
BFB07B7F7C7C797A8784808276C426B07B7B7A76817C7B6C
4800E6F33D6676806F8F9521A59469FF3178797F7A7C7B7C
7D7A7A7F787E787B7B7B787D7F7599047D7B7B7C7B7B7A7C
7B7B7D7572A56C464D8BB284FF82947377C38C57A868008B
6F807A7C7A7E7C7D7C7C7C7C7C7C7B7C7D7B7D797C7D7F7C
7C7C7C7A7E7B7C7B
FF95717D7C7C7D7D797B778368FFFF057B7C7D7E7A7B816D
971E48583F61827BDC9B3B86198370568B897B7B7C7C7C7C
7C7C7C7B7C7B7D7C7C7C7D7B7C7C7E7E7C7C7C7C7C7C7C7C
7C7C7B7D6C8A9677BCEE6585AC9B7671CB79863C918EE274
82797D7C7C7B7C7C7C7C7C7C7C7C7C7C7B7C7C7C7C7B7B7C
7C7C7C7C7B7C7C7C
0049817A7D7C7C7A7A7F7C7E814900007C7C7B7B7C7C7D81
DFFF84B97E6C7D7BA9896E3AFFF464244F7D7A7C7C7C7C7C
7B7B7C7C7D7E7C7B7B7D7B7C798441C27B7C7C7C7C7C7C7C
7C7B8074D5429D9614A7867577A1626366B277722B4B2A8C
767E7B7C7B7C7C7C7C7C7B7C7C7C7C7C7C7C7C7C7C7C7C7A
7B7A7B7D7D7B7B7C
2D96767F7D7F7C7F7C7276728C458B767B7C7E80787A7E7F
59D3493B739E757A794282669A70AF6A94787F7B7B7B7C7C
7D7E7A7D75707B807E797D7B82788567817C7A7A7B7C797C
7C7A7A7B768086817F575F7A738296968670A76F75729579
7F7A7E7C7E7A7C7C7C7B7E7C7C7C7B7B7A7C7B7A7B7D7A7D
81857A81797C807B
907CD04C9D9376B600133979C08FFF678C4F41A92561BC63
AD42FF352FFF7972B4FF0021BC827C71B88EA39588857888
8D664AAFF591A27E9B4BDC471B7B582B659F5FB87B8BBE88
D9E2002E936CAE1A9B399D6E42831DD9258421786E7A57B3
BDC35266825D7E7081837374807E73748596A3FFC2BEB196
B171789670796C80
4A206C97706FA680C4B887984CAB736E76966B68A97F7D5A
230020849D7C6782E68E24C472A7FF10489C877D7E7D7B7A
76848E168F89677D6D87678C8975CF2584707F6D797C7B74
614D7F70A4A4B2A0AA118C898C76836F6FB47009158BCE28
4E68807D767D807B7B7A80817A7E7D817B647C543B12CE78
8079806E817B8372
70438671817E8B7F676A766F9B3B51857C838F826F7B7B85
4F6E8E796B75887672BE7E6D82776545E08F7C7B7B7C7C7D
7984849E8979827B8079857675787B6878807B817D7D817C
848774766D5DFF86FF7F8774767C77827A747072B3494B43
A1797C797E7A7A7C7C7C7A7A7D7B7C7A7A7B778E6B61757B
7F7B7B807B7C7A7E
5168817D7B7B7B7A82817F7D747BB7817C7B787A7F7C7B79
6045506BDB7D7C7CC6B65EA66A8F5B917F747D7C7C7C7C7C
7C7B7B71797C7A7C7B7D797D7F7B86617D7B7C7A7B7B797C
78777E7E7E847D24A3668F809F697C7A7D828277415A877C
757B7C7D7B7D7C7C7C7C7C7C7C7C7C7C7C7C7C757B7B807B
7B7C7C7B7C7C7C7B
D6A2757D7C7C7C7C7B7B7A806E992B1D7B7C7D7C7B7C7C79
780FFF933D7A7A7D8ECF5B6BAE77D0D286807B7C7C7C7C7C
7C7C7C807C7C7C7C7C7C7D7B7B7B816C7B7C7C7C7C7C7D7C
7D7D7B7B7F946C60C14D61569D4C5E777594898C55489174
807C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7E7C7C7B7C
7C7C7C7C7C7C7C7C
58B7777E7B7C7C7C7C7C7A8071975BED7B7C7B7C7C7C7D7A
A3647AF89DA6747FB6DCB939D2BC7183A0727F7B7C7C7C7C
7C7C7C7A7C7C7C7C7C7C7C7C7C7F82D47C7C7C7C7C7C7C7C
7B7C7A845BD8487A00B94F50A96A716C6DFFAD6B94708076
7D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B7C7C7C7C
7C7C7C7C7C7C7C7C
776D827A7C7C7C7C7C7C7C7C7C8C25007C7C7C7C7C7C7C78
7084DC59AA6B7E7BA7D1794149439579627A7B7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7A71417C7C7C7C7C7C7C7C
7C7B7F72BD9B70A52DC2C45D83668CEA22186C8F6E894583
787D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
FFA2767D7C7C7C7C7C7B7E749EADF4FF7B7C7C7C7C7C7A72
34C035743C737B7D6A81FFA5FF995AB477807B7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7B7F75B35C7C7C7C7C7C7C7C7C
7B7E768600647219524DEA0095DCA9D4AFCE728CAA6E8979
7D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
FF3486787D7C7C7C7C7B7F75861BAB4F7D7C7C7C7C7C7986
4496FF81E95A8A786D503277AF2C6B35947F7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7A7E587C7C7C7C7C7C7C7C
7C7C7C7A907CD778949C55649B2371AE7773828C5880B578
7F7A7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
1AAA727F7B7C7C7C7C7C7C7D7D6100F27B7C7C7C7C7C7B76
680246FF43A1737F193470705E6E7C417D787D7B7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7D78924A7C7C7C7C7C7C7C7C
7C7C7A7D577BF0FF9FD5AE7AB3F10084968BDE6D585A6180
7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
00228C787C7C7C7C7C7C7A7E7CB21C407D7C7C7C7C7B7E74
A4D85D15F77B837856AA3677BB00738CA8767E7B7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7B7B511A7C7C7C7C7C7C7C7C
7C7A8365FF794269577904AD90686ABF3900C0C38B008475
7F7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
7F777D7B7C7C7C7C7C7C7C7B7D6D961B7C7C7C7C7C7C7B7D
746F45765A647D7B3E755B2FAF9A4DF77882797D7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7B878A7C7C7C7C7C7C7C7C
7C7C7B7E6FA2009340507D4D47968C6CFFFFD5ECE17B9176
7D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
22767C7C7C7C7C7C7C7B7E758F347D947C7C7C7C7C7C7A84
6EFFAF6E7D8B797C731DCD7B7556B6677F7A7D7C7C7C7C7C
7C7C7C7C7C7C7B7C7C7C7C7C7C7C758E7C7C7C7C7C7C7C7C
7C7C7C7B837976877957858B9863C4C0AD9AAF837671787D
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7B7C7B7B7C7C7C
9E7A7D7C7C7C7B7E7F7D7C7D788A919B7C7B7B767A7B7C7B
7C618C8580777D7B79847D866C7076837B7C7C7C7C7C7C7C
7C7C7C7B80807C7D7C7C7C7C7C7C7E7A7C7C7C7C7C7C7B7C
7C7C7C7C797E78798385827D7E767B7B7E78747F817F7D7B
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C80
837B7B807E7B7C7C
727C7B7C7B7C7A868E7A7A797E77787A7C7C7A677B7E7B7A
7B857A797B7D7C7C7D767F7A7D7C80797C7C7C7C7C7D7C7C
7B7B7D7C8D7F847F797E7C7D7B7C7B7C7A7A7D7C7D7D7F7C
7C7C7C7B7C7C7D7D7B787A7D7D7B7F807C7C7F7A7A7A7B7C
7C7D7B7D7B7C7C7C7B7B7C7C7C7C7C7B7B7C7C7C7C7D7491
8D7C7F79747C7C7D
7D7C7E7C7D7C7F779FA27C807B7B7F7A7C7B7F91567F7E80
797D807B7E7D7A79797F7E7F7F7B797E7E7B7C7C7B787C7C
7E7F787D4C44B18C7C737F7A7E7C7B7B8476787B7C7A767C
7C7A7C7D7E797D7A7C7C7F7C7C817C787C7A787D7E7D807C
7C767F777D7A7B7C7E7E7D7B7C7C7B7E7E7C7C7B7B778C5B
709E6AD8877A8177
7E838381798072C6FB37643984837F8281768F66F7B38156
8A7281827B777A80777A7B7D7C7E7F7C7A7D7F747D7D7B7B
7C7D809E956FCDB667868BA17182707D634789829C92AB77
7B7E8080758580877A787C777D7581817C82857D74817C6E
7F7D787B7D887C7A7A7E76817B7A7F7D7D787D807E852DFF
2E50D565B6928D7A
708FB2929782BD39FFA9213A944DCB70895852CF569A596B
52B3E674A88E5061338ABBC3B270718AA5748E72612A8777
9F9F798BB287F032353A36E478A02D7AA9B81F86FDAE8565
6C548B85AF50B570985AB97683CE7F55845F68A4AE9DD150
6F09BB15976E5C7CAFB096737E826FB0B46E858574804C23
BBA5390080554433
EB7F7F778684F27A76DFB5A7A152838DB06B8D37AE137076
874ADCC57254959EBD3C1EDC5E9AC363A583DF926CC67877
6457FFB33D9BA28C7FA400A23986007C51284A84C097E71E
14945F498FFCED80C4307332CE4157A395C4FFE75CA6A261
86D780C31DCF585D48A745CD8E67BF8C73199BD0E3AC5E65
97B25E3A9C409180
DE9064A0C631008B68586D345C7C59539E62597E717F8591
14778BC4707183EB7AFF9E7E12B6C047A9205E6D890956B2
B4CC28C0766D9E6B9281854DB8447265349B9E72ACA79691
0BEA48D64308FF80943A4A8080319724D2982498E300C4E6
FF6D52D480FF997CDB998D9797C034D5AB64007C00D76E8B
777A766D7F7A6994
7FF5FF768FD79A004309C871BDFF739965529233FF512688
5C7762F9417DE5DD5E4C794358C6B1A06E80784AD4788B8C
508F3D00579E228E8E71A04067686E74877573969799652A
9588B186D700395B61C2CA8F906834A2839AF63FB172B5AC
862A2E6558A1D7757D3ABAB9747341C8B084DC6C819DA698
7B7995BA6A538C84
FFE6E3FF4D000003B3009180FFD0E0FF5BFFA528FF456797
8C7734D9FFD6D5A100F37D4DE63EA899B600624E448F373D
838F57AA769F50008F7C7CAAA56752007777566B998D8500
56856D584A94E09E42C3E4D1005A925366C7442AC18AAD67
2E7E52C36561659D897C7C30227A947B943F7CB29D058D89
7F8075A6AD559C80
08400000B500332F0780E022000052923E99B43DD241F10D
9693338A92C792FF5991CF5D4D6F6D59749F5DFF7EC1BDAF
AFB6AC3A1A995A773FA052A385E08EB17D90969751AA9C4F
4F518B7257703987853EA5690B9296852A4E8A5C53A426BE
5A537260787DFFC03C4CA4878F917B1D5A8655CEC165387D
6C75745793728477
A286ACFF008AE4A48BD9B3FC83C6826CFF17598E003F00D8
666C60417A5A572DB1790649877B6A7FB857D60E0341E7CE
91604D72B732F446CD4400C8538F84683EA9E475F2089443
4262897580748D860052EFF68F0F6A93BADC738288557AE2
82AF3A813557CB6686C3F94479439F5FB27B889042027F72
9D9558807B37859F
00703E00B0FFA93F6DC1E56171827B6F7FFF6A539FFFDB44
927DB49E0F56FBC4A178AA83B7C8429AAA2AFF77636EE12E
A1FFD55E7FAF7BC7E435A3AA8E8878920003EEADBF52886B
8B7D7B847488A87076926DA268B4005937A85B866DB11572
7B08BED100966FCA7CB09D00AE5CF13A8564AD37A864B581
3D0000C07F7742A0
80750071A1E7674B7B9F00B191A24ED09928BCE19656597D
7BD585DB6468EA64A5B7A1882EB8A7668A56725526E38986
054E7C7E756430A300CCD67B538F5731516C567D91756D1A
7377854A6100BA75B1536E606857D4155FC0D87D875D6C7E
679167A7BF769800FFF13C505D9CB8815B69B6657767D561
FF56DE7689C8A25C
ACDF6A6D5792C81875776BA65B31859CB13F6A5F8800B16F
DDE9E40EA50282001E72286FA0716DA700B9A7AEFF405EA5
86865B98A8D7FD0159A5B0A25F956279692662648E7A3756
7E7B8190035F505DF085EDBEB0966AB3206DFFA19B710089
C66A3BA4807059FF9F518BE5BE67A2332BF6AD9E4655CB76
209C40950C8F6000
003A5A46E88D3B4600940A855E64E350B93ADC8B183A86AA
91904812D396DBA7B849B9D9A7CC87064381234D3863141E
22DF39B91167C13BBE10889B7A6878521D955586798135B2
728277C4FF74C15612DBA16CD36ADB765B085C5C373B088F
92008946FA70FFD6453D1C080C72D158682C7B73D1624E7D
6E83BF29B060B338
BB7528A36ABF76E6FF1982549E9AD65239BC8AB78E6F8DAA
22E9849C9948B75C19FFD78A1E67007B2EFF756F70859800
5BC47D669B64545566AE8C8396459E2C87A31B5F818064DB
7281795F90A5484F2483CB45713897008A568CD0CE7B5928
1634957400FFEF7E74C6DABECBE2A383729B7A64317E90A4
B6BB07970A8EA662
8C6C78BD97FF2DABFFA170756484EAD540BC5700EF84727A
8D0956675F7A4B81FFCC1949896DE9BD996DFF70D8907FD9
85958D9828A29F46FF806EA3827D61956357808C625F7690
807C81513188A7FF81C76668A3BC6D912D7E7393166CC399
D08B61FF555F43DE56D650AEE563033D46D61B609E91868A
7BA792322033B7A1
00C82D1C727DA75A00AFC38F74D6BDD7075C9FAD63E0C8B8
794A77736EE6930C00FBFFC324BB6D047BAB6362000199FF
4541B73BA55F9B4F9C5E433A864FC03A94A2CA5B982FB22C
438A779C3D798F6853CD4ED1082AC892615FC661D93A54AA
77618496FF739EFF52835073BD5DCB58423B6E9161305D7D
81677895B07C4386
9F427AA8193F17790D22D6CF7B552462AFA958A16C65CBC6
0036A56AAF00EE93B1D475780CA26F2A2DAE7144EB9A6484
8CB946B28474A4D2849F477A94488AD5D81B4927531D00AD
49EA5A770073C18BA16778ACA5E22EBA8680C10086FF477C
577F75EDBE53ED557775B8D05D9C9ACE74EBB0B090895D7A
7C7478933663926B
61806F7562773B6A62EF5E6E6C618A567880FFC000CC71A9
6B4E8B8E7FDBC84C4275748552C5788E112F7D65675CC87B
F24B5B44A5BA707D9D32FF8C8E618E8868AA44FFBF6E80B0
7480788587A0248B68857980885D00D44AB390757C7FA26E
F7B549B6A581834AB68A8C468F8B619A1872AAA43B836283
67117CFFD08EFF61
4DAF9142A9F4748D4A43636A6F727E88154F9291FFA39E93
ABBC1FD861009DC87AA6A434A7295F519DC6997A56BA5790
2DB9BE9D4EA0FAD3E78E635E8B6A60568059A8EF638966B0
797D825D524A797AA5618A7B2506547D6D5D2C917E604DC5
8A6E55846B70824A63ADFF561974956A749D0E4884754481
871954271B243E81
6441B3A3D7685A757766774D6351589D856A4B813A788889
AD4F51496397929992B7358D7664B47EA85EFF5C89CA3463
837669358D6E5C345DE4A84D9576577200740097817AB694
7C7A835692B170931223859A6F9283734593AA5585672186
00E081C0CF8E7285B283149D7586652FB7447D7E9497B776
98771C2657CB4ADC
9451304B5BFF937AB6A5AF81664D8173846F5193E57C2DBE
93B6B4D840CC7DC94A858F647E3EC1AF633F408F544FE6FF
CA73653E4230649D4E7731D0825061AD5100E42F7A7F46F1
71817E4A68648C5D80000057BC069450BD8E50B2B3691D7A
A14B6770AE7A8E8E7CA1C49E9EAB3D4FFFCF6974AD7A3E80
9122B88FC3656A69
4889308369FF93F65043007B7744BE91583E8F702D4184B2
93FE8D4F5481656B408A6CA48BC390427B804D9F7F7A764F
49B27BCAAD6D7E59A04BC69A7D644F5DCFB04C4C887C47AC
767B881F00877C4F47B94469D5856C94478F6D4996009C79
C398588FB27478DD6068834082B01FAF90787E882EC19355
ED5D00686985E094
5F64336C1852AE6CC9682B93878E5558FF6B592C10DF574C
95D1B667A488A28D200025495DAE4B5BAFC53B5B5FFE8A5E
8C50963371776000950054576EA95454D2FF45867976C214
8873865283944E2FAD827FE21B5DDB8879FFA0AE57AACC6F
4F9690567984DB872E1D4AB0D0865147A89C747A45624B00
8D64659FDE2AC7AD
538A6D9298A9B284782849ADB146E74E8F2C6A5A969C664F
008A31886FB240455EA81EFFEAAF66989881988C998E782E
95827D9D9AF8522E183923775A9CAF3C252425A9707E7014
83787A8539EC55D883BECF49626D147D7DDB003B6B877BB5
67567B89B54F10A2FE71749D7A92754812717994A97877C9
965860370D5E14EA
7F6A3C3191983F8688DC54696865A03E7394FF839C6035A7
958B77EE6C98B6C0C97C7E68895300A28A916F868A594569
FF7E89A99B82349738B0498E89697AD66EED8B83787D7EBB
777F7980585E56F60091847A838C5D826394211D7E9286B4
617081A17BD17340FFEA48237BCDFFFF679266E58448746F
5E4BFFAF856B86CA
FFEA688C305B21FF005AAB8883AE4AA86495A7FF3974AA5A
9489B16C8446B000947AA7CFDDABD780CCBC6C66B2946C9F
BB005453E25751675B228D6E718E7B963D636D7E7E7F7C4E
807A7C84889900FB3D24B49E5694B67E2AB2B6AFE009739E
A7668298928576B0B46746FF6E537F008F1ECAC498A13476
877F4D615CB5725E
DE7C3CD36D26FF32EB645A79AF95BB8F6DB8AA5537A57794
31BFE000C5AD9080A92FC362D54664C896B3A2B4B4D05B49
12092BF02C9043915F93827B80707DFFFE7D8879796B8074
7B7B7A3C6D83FFCEFFB7FFFF445C75BA8CA162831BA1BF79
8F597DC69CB0B278ED977E736957205F43DE6D3C826B0B88
717E6A784BC6FF67
DEE4AE7F003B84000067849C70202E55337DFFB0619C387F
8086889EF161A400CFD1044DA75BB98C4639639C55514B6A
4FB1F5878430FF266292563E668961654C56979AAAF1678A
84788076AA7790665A8100909BA2614FACF3A28176322604
FFBA7450A5A78E6F6D83A5A22129437000738726FF820081
7C217AA39CAA5687
3A6698EEC57D26A4A000715449E0FF7742B90D953699C58C
DC3AE24B778C00447CCD8263ED6F513D829EB9A82800C13D
41FF3A61678275707B898A7A536352A3868A954561A67861
5489805A848A1CB05418515C120B5964323E9E4C84C07A9F
355878848A3F537DC50F36A25DFF00B3CEB20E1CE3EC7C80
7A837B79774629DD
95A16505C7872E8380672F9D859AAA61F1FF7D8D5DB77D65
7B845DBA4054958F931880584B1A25955393723C6AC235EB
4459574581738150B84B8F486E9070450EC1839D00C43F92
97618384CE62865810B66F7C9486BD60FF00848500956B00
D78B7F985CAEB2836F999EF05BE46E703D83B8FF4C6E717C
7A777E769CAB4700
784262D59E775E72617E65D3D4A487FF6C86777764728ABB
8A866C3EC285FF865B6BB6091534FF0071892F7B1F678071
6F76539C8E7D834F9FE359B9DD7A4E91759748917D8A90AE
12FDA100DE8D53596A8470C18EF6F874D07BD79D61AD4992
8F818442F1FF48BC6C827068806F795963BC6F7DBA8E827F
837D7C7B949A6CB7
A36CA4BA6393467DFFFF76605B6E1A1D7F76F47AD56CA7FB
B1B6A488FF500086711F0FD3AE00DE145C1C9FD578887682
7A83861C6269527D6780B0A5F587E780807D569469B57EC9
5F5BF4B966765AA66572AF79AA6920AB5C684AAFA99E8D70
37638763875D90737D7D818479817D8480536E6DA8007B63
5D8081608A77835B
B37386727F788FFF69938B5BA785B6597C4D41FF6B934FBC
EC68DA8C9E189C764C2F8E35774D557DAE00647776787E78
816BDB337F50807479816C89AD89B0A47B7B85757C815B85
84CC6A195E62501D822084E750869062A863A6928D7585A2
409F8086758476807B7B7A797D7A7C797981585C596F665C
5B847A78817E7C7D
738B96768373FF53867A778192A3328972DDE25E88768666
5ACF56878777757F13666288809FD1A191A280807E7D7A82
66BD9A5CB2847C7D7C7A8278716D75007B7C797E7B7D8679
817C680025B6E2D56FC7FF82797B728667A56D70CA746FA4
987A78797C787E7A7C7C7C7D7C7C7C7D7451627DBD42C779
89787D7C7B7B7C7A
AB6E727C7B7D6D82777A7C7C77B3A46F7D727783787D7A7B
988D898A3C6D847BA2BCA6737B6D55816B6D787A7C7B7C7B
7D76684D63787D7C7C7C7A7C7E7C58327C7C7C7B7C7B787D
7C7D8B6896BE125FAD968E727F7C7F79846C96C1A168C9C8
777F7C7D7C7D7B7C7C7C7C7C7C7C7C7C7C80806CE4F45981
767E7B7C7C7C7C7D
738D787E7C7B86807D7D7D7983587D7C7B807D7D7D7C7B7C
47567F75969A787DBD7A6C807C818BA2BA7C807B7C7C7C7C
7B7F8178837C7C7C7C7C7C7C7C798C617C7C7C7C7C7C7D7C
7B7A797B7D7D8C0041757B7E7B7C7B7D7981746C6BA74946
86787D7B7C7B7C7C7C7C7C7C7C7C7C7C7B797A7D6C64847B
7D7B7C7B7C7C7C7B
7866827A7C7C787C7B7B7C7C7885A3757D797A7C7B7C7C7B
6D3F887B8B677F7AB28E757D7B7D72915D7B7A7C7C7C7C7C
7C7A7A7B797C7C7C7C7C7C7C7C7B7D657C7C7C7C7C7C7C7C
7C7C7D7C7F7D9693607A7B7C7C7C7C7C7D7A7F817AAE808E
777E7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7D7D7B8286797C
7B7C7C7C7C7C7C7C
8F8A787D7C7C7D7B7C7B7E77883D75797B7D7D7C7C7C7A80
4C7B807A51797A7DDA8980787E78A6B27D807B7C7C7C7C7C
7C7C7D7D7D7C7C7C7C7C7C7C7C7A836A7C7C7C7C7C7C7C7C
7C7C7C7B7A8095A5AD737E7B787E7C7C7B7E7297504F7F74
7E7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B7B7C79787D7C
7C7C7C7C7C7C7C7C
60757D7C7C7C7B7C7C7C7C7A81695C807C7C7C7C7C7C7B7E
81B38F7098857C7C5D4A7F7B8086A54E7E797D7C7C7C7C7C
7C7C7C7B7C7C7C7C7C7C7C7C7C7C798A7C7C7C7C7C7C7C7C
7C7C7C7C7C7D789D4F87767B87767A7C7A8275E76E8B797F
7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7D7D7C7C
7C7C7C7C7C7C7C7C
837A7C7C7C7C7C7C7C7C7A806FAF73667C7C7C7C7C7C7D76
84208C806D757C7C91BCA93F79727B9E7A7E7B7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7B7E6E7C7C7C7C7C7C7C7C
7C7C7C7B7D777D5FAA7A677C2A957D7F7D73728DCE757D7A
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
8769817A7C7C7C7C7C7C7C7B7E7AAE817C7C7C7C7C7C7C7D
87A85676AA747F7B476C41FF65A3879C897B7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7D7A877C7C7C7C7C7C7C7C
7C7C7C7C7B8395A35F7199809D00427E73A79B77615D8978
7D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
B64582797D7C7C7C7C7D79836EFB00BF7D7C7C7C7C7B7F6F
B982DFE07A528379C76DA27CA372BB6F5483797D7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7B7E6B877C7C7C7C7C7C7C7C
7C7C7D7A7B2A6864ABFA3EC9687F69777C649D73828D6184
797D7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
81797F7B7C7C7C7C7C7B7D79804DB7007C7C7C7C7C7C7B80
5E460066A6747D7B7F430000A7779178767B7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7B85777C7C7C7C7C7C7C7C
7C7C7B7D7DB47D8457E595B59E33745185357E7A7B7F6C7E
7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
446D777D7C7C7C7C7C7C7B7D7C9D53FF7C7C7C7C7C7C7C77
817FBBA323827B7C67513D00C25D477183827B7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7A78557C7C7C7C7C7C7C7C
7C7B7D7698957675BB1CDBC458845A58B15C46877A7AAD78
7E7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
A8757D7C7C7C7C7C7C7B7D7A7D3983E67C7C7C7C7C7C7A82
6E68563572797D7B62DE454BA4FF82817C7D7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C8BA37C7C7C7C7C7C7C7C
7C7C7A8264DD708B1926005E965A1A9C54069577807A827B
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
7E707E7B7C7C7C7C7C7C7D788792FF987C7C7C7C7C7C7B7B
5990672F8C7A7D7B7B1DAA7C8D7175767D7B7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7D7A8A6B7C7C7C7C7C7C7C7C
7C7C7B7D5B77806B128FC8FF56737A9559717776767E7B7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
9C8A797C7C7C7C7C7C7B7E74923F4E367C7C7C7C7C7C797E
3FAAA4E67B787C7CEB985FB8A3D591757C7D7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7D7893787C7C7C7C7C7C7C7C
7C7C7A804B93447C8DDA6910FFE184FFAE7285E28D7A807C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
FF627E7A7C7C7C7C7C7C7A806EB1FFCD7C7C7C7C7C7B7E7D
A792B9B39561847A3564E423994B6D6488817B7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7B7F6A967C7C7C7C7C7C7C7C
7C7B7D7A9C72647F884B6AAA431393203F93758E7D79AF78
7F7A7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
53A2747E7B7C7C7C7C7D78894EBF8D2A7B7C7C7C7C7B807C
DC01AF8C3284767E388646624BAB96B1707E7B7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C79824F977C7C7C7C7C7C7C7C
7C7A8075E96F85B456428E5C9A89AE3AFA688E5D9F6F717C
7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
AE6D7F7B7C7C7C7C7C7C7B7D7FAC82BB7C7C7C7C7C7C7E79
B1FF768897727F7B4FC579618475696E7D7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7B7F71A27C7C7C7C7C7C7C7C
7C7C7C7D6F638B7FD1D266788A903C90358B3F8A708E817C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
8A8F797D7C7C7C7C7C7C7B7E755F00EA7C7C7C7C7C7C7C7F
9D85BFDB818D7A7D5A3AD880F26F69648E787D7B7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7B7F74B07C7C7C7C7C7C7C7C
7C7C7B806D5296F4CF2E583BA26C91754474487F7B38797A
7D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
258A7C7D7B7C7C7C7C7C7A80729776FF7C7C7C7C7C7B7E7B
BAA22A54909E777D217156734D4EA9C1AB757E7B7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7B7F638D7C7C7C7C7C7C7C7C
7C7B7F74C7CD25317E2090846D169158AC8F67A0B049A66F
807B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
AC9B777D7C7C7C7C7C7C7C7E6D43B77F7B7C7C7C7C7C7B84
7A00398669827A7D006AB6B9651B4485847C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7B7D8FB17C7C7C7C7C7C7C7C
7C7D78874A9C90C76B7CA4ABB370905D3E44D2FD224D8379
7D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
2A258C787D7C7C7C7C7B7E77843898E77D7C7C7C7C7C7982
4A78C600CA6E84785DC7A66696E747938D7A7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C79834B7C7C7C7C7C7C7C7C
7C7C7C7891917F757AB5A87180746D55A202008981538578
7D7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
5BA5727E7C7C7C7C7C7C7A816CC3C3007B7C7C7C7C7B7E75
830B6ED42C7E777E6F8A5864ABA9007D707F7B7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7B7D5E7C7C7C7C7C7C7C7C
7C7C7C7B7B66F5A52A677C69678A959A8E735E0E4C8D777D
7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
87747E7B7C7C7C7C7C7B7D79835F80C57C7C7C7C7C7C7B80
74CDFFD19B7B7D7B673D5B62D600B77D817A7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7A897C7C7C7C7C7C7C7C
7C7C7C7C7C806A8D81FFAE383561898BFE8FB78D8B767E7B
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
877E7C7C7C7C7C7C7C7C7B7D788A5A5A7C7C7C7C7C7C7C79
825D69827F7A7C7C859E4B6E9F8973797C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C777C7C7C7C7C7C7C7C
7C7C7C7C7C7A82797CA67969618C53576C6D6C75777D7B7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C
7A7B7C7C7C7C7C7B7B7C7C7B7D77858A7C7C7C7D7C7C7C7D
7A86867B7D7C7C7C797189807474817C7C7C7C7C7C7C7C7C
7C7C7C7C7B7B7C7C7C7C7C7C7C7C7C7D7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7A7C7D767E7F82768786827F817E7D7B7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B
7B7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7D7D7C7C7C7B7D78767C7C7C7A7B7C7C7C
7D79777B7B7C7C7C7D7F777A7F807A7C7C7C7C7C7C7C7C7C
7C7C7C7C7E7D7C7C7C7C7C7C7C7C7C7B7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7B7D7B7B7A7E78787A7B7A7B7B7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B7E
7E7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7A787B7C7C7C7B7D7E7C7C7C807D7C7C7C
7C7D7D7C7C7C7C7C7C7B7D7C7B7B7C7C7C7C7C7C7C7C7C7C
7C7C7C7C797B7A7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7B7D7D7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7D78
777B7C7A7B7C7C7C
7C7C7C7C7B7E7599A07A7D7C7C7C7C7B7C79793E77797D7B
7C7C7B7C7C7C7C7C7C7C7B7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7B7E77ADA57C837A7C7C7C7C7C7C7C7C7B7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B7F70B2
B9747E837F7B7C7C
7C7C7C7C7C7C7D7552707E7C7C7C7C7C7C7C7F8B8E7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7B7D7AA15B657F7B7C7B7C7C7C7C7C7D7C7C7B7C7B7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7D7A
636286586482797C
7C7C7C7C7B7D7B80659475797C7C7C7C7C7A89826092787B
7C7C7C7C7C7C7C7C7B7C7C7C7C7C7C7C7C7C7C7C7C7B7C7C
7C7D7A837CD0924C757A7E7D7C7C7B7C79777C7C7E7E7F7C
7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7B
7C7B7C7B7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7C7199
3C3D9765008E767E
7C7A797A7C78844339A17B8E797C797B7A7F6779026F7785
7A7B787C7B7B7D7D7E7B797A7A7C7C7B7B7D7B7C7C7E7C7C
7B798068BAE52DB1748279767D7A7F7C83867B7C7174717D
7B7D7A7A7C7C7B7B7C7D7A7C7C7A7A7C7C7C7C7B7C7A7A7E
7B7F7B7F7B7B7C7C7A7A7C7C7C7C7C7A7A7C7C7B7C7F9373
A84D6924906F7D7F
7B818680817A8D3124B572348678877E7D7867A25DEF875C
827E8B7D80807879757E8583837B7B8080787E7C7A727C7B
82807D6F90833CBC7A639C877A856F7C5A048576B5A5AF78
7D7881807E7B817C7B77847A7D8481797D7B7C7E7C828476
7C6E7F6F7F7C7B7B82837B7C7C7C7B83837A7D7C7D7BAA99
9B6DABA263B9B056
7A64506C687754BA24C4706763824B6E6F98930056944A6C
8A6339736B618B8C8F72525F5E7F7E666691717482A87980
62647B746700AF1FA2C56C1C7C7FAC7B004E9866DCE9AA81
80846666767D6B7E7D94588776586285797D7A747D5D588D
78B76EB6757D7D825F5C80797C7B805D5C8678797A768C9C
8EB29D006D36AC0F
81826A955E78779A555E49CD4867433F6D9F9083A8555663
A06B535B80186AA72E55369050867B4852BE721879A87E80
55578C825DFF7F008FCE60FF5985A575B8594BBCC94E1D75
63843D34C368F8986E9C557AAE814B827C7E888B905E6B1E
73B282AEA2BB6188595F887D7D778A615F7B7B88877899AF
006D37006500E11E
B3CAC896B46E3C6BADAC55857A456B6C7D7B75A05A29988C
F1AC9F5463C5C8ACB0598E24228BB0E53F4946B8B4886770
B1B24262896E6B4A35D03E837049FF7B99FFE1B00000ACC1
E1F09F66C780CE35008388A3E2FFD8BB5C9C750007741784
CEA3096C9D97C36E89801B757588586C709B80515A777674
9095EF50920A5494
A04E7369EA25BA79808087B9193CB17BB8C382617344C6F7
17317AA3A86FE1CE3C8B7B3D4984FFC844FFADA250D29E8B
B6FF97925C804D7A982B7CDF927D7029627E548E1F7D8149
72A2FF7B597369ADB20081DA42BD6972B43C65D69717DE08
FDB0C8A7B9CC078462C64EB86A735B6A4236EEE47BBA717C
746B94A86F907D6D
69A9FBBF9BAFDB776F6A8A293163E255EA908FCF688F2D48
00001463B2F17700BD7FB6C25ECC2E5F407930685163D2C5
00435B44D34D907EAD4E7900CD9C612C347F7B75AD8AB9FF
1C66FC8B4A6E555540DE0005D87EF842AC0F58594D6C688F
00004E895101CEE1CA288A5A0034759865A364FF4679BED4
7C847B747E7B70E9
7974FFCAC438D38B43686135D48D6077FFA56A4CA792BC3B
70B9C52A7DB228557B4E6FFF135FA6E2DB475F2971D5AE98
B8004C8E7D8BC27E79835EF7988AA74E8E7A7984A032787F
B93A7183D04B9B74DA988E87B1B5A2AD118128FF223E4000
51ADCA85BB2FDA795853BD107CE7176B554F9BD053238973
7A85464C86748170
B95FD0006769B2F8A3CF64953A8F233D483445B60A928451
5DE3FFEE7071AD7B7C63246D1159004D747400007B9D4662
50AD7DA78F619C76717C77665C57A2BC757D7F75757C9BA5
6387DB9C8D53B43C40766C30A078625C4C6E25AB5CA86FB7
D94D7E787CABA48A5F0090A3814403B6A07881B80C7E647D
7C7C7D6384967384
01628B3C7D5471C7A2AE7A9A651F0A10887D82A51C89625F
4EF2A4FF0A4F9C576C508602827D698A219C19DBC1877F7B
8364A8AD9D669E5D6E7D9298551E65BE7D7D7498A172A0B5
8EB16445B82EBB54B59CFFD3A262F03E8322BA6B7CBDB461
1331FFB3AE0DFF648588716C768C8F75727A79A1754A6B75
7D7C76618E907A7C
00C2FF757E2C6FEB84CC8B27FF6C9DF4897414A74AAB2BA1
5CD07E67A400A7864FC394004A3058A7005B08D1B5766759
75B85090727290D68075A5EDE176FFEA7A7F75AC6242447D
C680467366875A406E4785B48776BA50616BC10089C1246D
912C0AAF2E39A2668172836E530F7C1A8480345D72CA6C7A
7B7C7A705C916679
FFBE4C598139A100A5D784001A91BD9F67DDC28676A31A2B
8D00F15F925E6979985360E256CC0FC8799A896E46906C60
8E1CC58FDE51A6C57E738250D17A636E7B7D776A73D78283
4D7F7495FF51AA67968F2B5DA4D62B4AFF55A6654C37CDFF
817C99798978D39F777A84646F919B68B63777B19A4C26AC
807F6F66659B6479
7E40322098306E0E00AA045A56299078749956D6007B7077
E68A9B7FAFDF837773846279916E6C5D522B46BA930E7255
9C7092378E4C999C7860DBA95C99BE528074D0FD6C82CBBE
5B54BB5E77126F837B838183A5638E7B6C827B566A8B8674
D3BC0628739B43774FA5667C7471A03B5F877AAA628A2E7B
7A788E5A786F807B
78BB7E757137004099D5622F809B869E76D466517900AAB3
6B865D88A5A73D948AB5C234648176B43CD59595DBD48C85
82C4FD6D4A7F7C756E545D92927D7C7F7A7C7191FF6E72BF
58677D7F85838181538DEE668DDC6280827D7C887D781761
CF539185656EC24E6DB5A86E99D051DDB34152628AC25C8A
797C7D787770917E
AF544E830DDC9FAC5CBFBBD08F689F958F54448F4C1AA118
6886572A837BCE0C88B49E507F78795F607D6BDD28CB8E68
CD8E8571807CB36FD86D7452A5FF7085BCF3511721537A4E
A6438F757A7774892688FF6FA0FF67B2CA8978797D7DBB36
5D7E7A7400767A793C167E8235CB1CAA78A67D9414A2857A
7A8178C55D99C59E
6DE2462D547CA6B088A4475E727C678F4E3FAAA36B017FBA
829E8A5F87A3B72263876D41AAFF7678CB8B618AFA75959D
CAD729CAC17078C4885AAF094B46807EFF5887826AFF696B
5A90757E7C7F8375C57C7EC4792E49BE700594737E43F723
8C6D79005F814B905A4F7F51949C00E938EB0C8B5D6FC769
836883CC4A9465A6
7ED5468149DB814AB673327C867C6C8D71FF847700959A64
7A68AD8AD2BEE78F7B827E76658185DF8E59A3334D93BD39
9AC08FCD7BB5EA623BF661809E947B7A71154F38A8637D8D
93737F7B7D7A7180647D84BB7981558B6B40837D6DBF44CA
6F5F5271965B8E41E56624A0298CA0775977668C373D7482
58929E5F47819380
4C9E808D3A8999B7803FB68E9DA87E4EA0001BA3A457B62B
A6AD526A592DBA86B873845D73BA6F698E6B84868831955F
81C0AA6A9F316D45838B835AADB36BAD666D98174E8F6CAC
B86E807B6EA8C96A8C777B6B81490E69618F827B7D756D00
A263BCA97C009151FF9829AB67125B52C2B6FB84800FCA65
B9571E31617947D8
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000181P00`40o`000?l0003oooooob7oool0
0?oooolQoooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Oooo`006Oooo`030000
oooooooo02;oool300000oooo`030000oooooooo023oool300000_ooo`030000oooooooo01ooool2
00001?ooo`030000oooooooo023oool00`000?ooooooo`02oooo00<0003oooooool06oooo`D00002
oooo00<0003oooooool00_ooo`030000oooooooo01Woool5000000Coool0000000000003oooo00<0
003oooooool03oooo`006?ooo`030000oooo000002?oool00`000?ooooooo`02oooo00<0003oool0
00008_ooo`060000oooooooo0000oooo00008?ooo`030000oooo000000;oool00`000?ooo`00000P
oooo00<0003oool000000_ooo`030000oooo000001koool01`000?ooooooooooo`000?ooo`000002
oooo00<0003oool000007?ooo`050000oooooooooooo000000Coool00`000?ooo`00000@oooo000H
oooo00<0003oool000009?ooo`070000oooooooooooo0000oooo0000023oool4000000Coool0003o
ool0000Poooo00<0003oool000000_ooo`030000oooo0000023oool00`000?ooo`000002oooo00<0
003oool000007_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Loooo00<0
003oooooool00_ooo`070000oooooooooooo0000oooo0000013oool001Soool00`000?ooo`00000T
oooo00L0003oooooooooool0003oool000008?ooo`030000oooo000000;oool00`000?ooo`00000P
oooo0P0000?oool00`000?ooo`00000Qoooo00L0003oooooooooool0003oool000007_ooo`070000
oooooooooooo0000oooo000000;oool00`000?ooo`00000Loooo00<0003oooooool00_ooo`070000
oooooooooooo0000oooo0000013oool001Soool00`000?ooo`00000Soooo00<0003oool000000_oo
o`030000oooo0000027oool200000_ooo`030000oooo0000023oool00`000?ooooooo`02oooo00<0
003oool000008?ooo`030000oooo000000;oool00`000?ooo`00000Noooo00L0003oooooooooool0
003oool000000_ooo`030000oooo000001coool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000004?ooo`006Oooo`030000oooooooo02?oool00`000?ooooooo`02oooo00<0003ooooo
ool08Oooo`050000oooooooooooo000002;oool200000oooo`030000oooooooo023oool00`000?oo
ooooo`02oooo00<0003oooooool07?ooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
01[oool200001?ooo`030000oooooooo00;oool00`000?ooooooo`0?oooo003ooooo8Oooo`00oooo
ob7oool00?oooolQoooo003ooooo8Oooo`00ooooob7oool001Gooooo00002`00007oool001Goool0
0`000?ooooooo`02oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Koool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool200000Oooo`005Oooo`030000oooooooo00;oool00`000?ooooooo`0Uoooo00<0
003oooooool09Oooo`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09?oo
o`030000oooooooo02Goool00`000?ooooooo`0Boooo0@00007oool000ooool00`000?ooooooo`03
oooo00<0003oooooool0ooooo`Ooool100000Oooo`003_ooo`030000oooo000000Coool00`000?oo
ooooo`3ooooo1oooo`400001oooo000>oooo00<0003oool000001?ooo`80003ooooo1oooo`800001
oooo000>oooo00<0003oool000001?ooo`030000oooooooo00;oool2Ogmo7_ooo`:6QXH2N7Qh0W]k
N`9fMWH2PH610X20P09SHf<2a/K60P0000;oool2RHV90YFEU@;oool200000[Zj^P9QHF42V9RH0Ta<
C09DE5@2fm_K0X61P@:7QhL2WinO0VQXJ0800002YjNW0V][J`:2PX82NWYj0WalO09kNg/2O7al0Wem
O@9jNWX2NGUi0X20P09hN7P2OGem0WQhN09lO7`4Ng]k0WQhN0AnOWh2Lg=c0[6a/@9RHV800gemOG]k
Ng]kN`02Ng]k0WalO0AkNg/2NWYj0WalO0AkNg/2N7Qh0XR8R099BDT2E5AD0UYJFP:LW9`2;Rh^0V=S
H`;YjNT2O7al0VYZJP:ATI42LW9b0X61P@:OWil2EEEE0[:b/P9`L702O7al0U1@D09_Kfl2Vi^K0W1`
L09nOWh2Ng]k0WalO09jNWX2OGem47alO09kNg/2O7al0WemO@9kNg/2OGem0WYjNP9lO7`2OWin0Wmo
O`QlO7`2NWYj0WemO@9kNg/2O7al0W]kN`Goool100000Oooo`003_ooo`030000oooo000000Coool0
0`000?ooooooo`02oooo0WmoOakoool2QXJ60WQhN09kNg/2MWIf0X61P@:0P802Hf=S0/K6aP800002
oooo0XV9R@:EUID2oooo0P0000:j^[X2HF5Q0YRHV09<C4`2E5AD0]_Kf`:1PH42QhN70YnOW`9XJ6P2
00000ZNWY`9[Jf/2PX:20WYjNP9lO7`2Ng]k0WalO09mOGd2NWYj0WUiN@:0P802N7Qh0WemO@9hN7P2
O7al17]kN`9hN7P4OWin0W=cL`:a/K42HV9R00=mOGekNg]kNg/00W]kN`9lO7`4Ng]k0WYjNP9lO7`4
Ng]k0WQhN0:8R8P2BDU90UADE09JFUX2W9bL0Rh^;P9SHf<2jNWY0WalO09ZJVX2TI6A0W9bLP:1PH42
WinO0UEEE@:b/[82L71`0WalO09@D502Kfm_0Y^KV`9`L702OWin0W]kN`9lO7`2NWYj0WemOA1lO7`2
Ng]k0WalO09mOGd2Ng]k0WemO@9jNWX2O7al0WinOP9oOgl8O7al0WYjNP9mOGd2Ng]k0WalO09kNg/5
oooo0@00007oool000ooool00`000?ooooooo`03oooo00<0003oooooool08_ooo`:6QXH2NGUi17em
O@9kNg/2Ogmo0VUYJ@;Ogml400000P@410:6QXH2QHF50P0000;7alL2Fe]K0VYZJP;<c<`2YZJV0Z>S
X`;oool27QhN0Zj^[P;Cdm<200000/g=c@9PH602Q8B40WYjNPalO7`2Ng]k0WemO@9lO7`2OGem27al
O09mOGd2MWIf0XB4Q09lO7`2oooo00=kNg]lO7alO7`047alO09fMWH2W9bL0YVIV@8a<C42R8R80XV9
R@99BDT27alO0P0000:h^;P2fMWI0Vi^KP:l_;`2=CDe0W9bLP800002LW9b0R@T90;IfMT2<c<c0ZRX
Z0:LW9`2MWIf:7alO0IkNg/2O7al0W]kN`QlO7`2Ng]k0WalO0Goool100000Oooo`005Oooo`030000
oooooooo02;oool2QXJ60WUiN@AmOGd2Ng]k0WmoO`9YJFT2gmoO1000008410@2QXJ60XF5Q@800002
alO70U]KF`9ZJVX2c<c<0ZJVYP:SXj<2oooo0QhN7P:^[Zh2dm?C0P0000;=cLd2H61P0XB4Q09jNWX<
O7al0W]kN`9mOGd2O7al0WemO@QlO7`2OGem0WIfMP:4Q8@2O7al0_ooo`03Ng]kO7alO7al011lO7`2
MWIf0YbLW0:IVIT2<C4a0XR8R0:9RHT2BDU90QlO7`800002^;Rh0]WIf@9^KVh2_;bl0SDe=@9bLW82
00000W9bLP8T92@2fMWI0S<c<`:XZ:P2W9bL0WIfMRQlO7`6Ng]k0WalO09kNg/8O7al0W]kN`9lO7`5
oooo0@00007oool001Goool00`000?ooooooo`0Roooo0X:2PP9jNWX4OGem0WalO09mOGd2MWIf0Zf]
[@:OWil2GEeM1?ooo`:c/k<200000YZJVP9YJFT2S8b<0X>3P`9jNWX2IFEU0^CTi09SHf<2E5AD0[Jf
]P800002Vi^K0V][J`:1PH42NWYj2WalO09kNg/2O7al1WYjNP9mOGd2O7al0W]kN`9lO7`2OGem0WUi
N@:7QhL2C4a<0_ooo`03OGemO7alO7al00AkNg/4O7al0W]kN`AlO7`2NWYj0W]kN`:8R8P2e=CD0V5Q
H@:1PH42PX:20Q`L70:5QHD2a<C40W=cL`:SXj<2ZJVY0W1`L09MGEd2HF5Q0^GUi@9<C4`2K6a/0Y6A
T@:IVIT200000ZFUY@9/K6`2PH610W]kN`AlO7`2Ng]k57alO09kNg/2O7al17]kN`AlO7`2Ng]k0Wem
O@9lO7`2OGem0WalO0AkNg/2O7al0WemO@9lO7`5oooo0@00007oool001Goool00`000?ooooooo`0R
oooo0X:2PP9jNWX4OGem0WalO09mOGd2MWIf0Zf][@:OWil2GEeM1?ooo`:c/k<200000YZJVP9YJFT2
S8b<0X>3P`9jNWX2IFEU0^CTi09SHf<2E5AD0[Jf]P800002Vi^K0V][J`:1PH42NWYj2WalO09kNg/2
O7al1WYjNP9mOGd2O7al0W]kN`9lO7`2OGem0WUiN@:7QhL2C4a<0_ooo`03OGemO7alO7al00AkNg/4
O7al0W]kN`AlO7`2NWYj0W]kN`:8R8P2e=CD0V5QH@:1PH42PX:20Q`L70:5QHD2a<C40W=cL`:SXj<2
ZJVY0W1`L09MGEd2HF5Q0^GUi@9<C4`2K6a/0Y6AT@:IVIT200000ZFUY@9/K6`2PH610W]kN`AlO7`2
Ng]k57alO09kNg/2O7al17]kN`AlO7`2Ng]k0WemO@9lO7`2OGem0WalO0AkNg/2O7al0WemO@9lO7`5
oooo0@00007oool001Goool00`000?ooooooo`0Roooo17alO09iNGT2N7Qh0WYjNP9oOgl2M7Ad0X>3
P`94A4@2`L710R<S8`9?Cdl2IVIV0Y^KV`9fMWH2PH610XR8R08k>c/2:RXZ0R/[:`;<c<`2Ph>30[:b
/P:5QHD2SHf=0WQhN09mOGd2O7al17emO@9lO7`2Ng]k17YjNP9mOGd2NWYj0X61P@9mOGd2PX:20WYj
NP9iNGT2Ogmo0W]kN`9lO7`2N7Qh0W]kN`:9RHT2Lg=c00=hN7QlO7alO7`017emO@9lO7`2Ng]k0Wmo
O`9lO7`2Ng]k0WinOP9lO7`2OGem0V9RHP:GUiL2O7al0Xj>SP9gMgL2Kfm_0UmOG`98B4P2=SHf0[:b
/P9UIFD2MWIf0YRHV0:LW9`2c<c<0Va/K0:>SXh2SHf=0YBDU09fMWH2OGem0WalO09jNWX2O7al0WUi
N@9nOWh2Ng]k17alO09mOGd2Ng]k0WalO09kNg/6O7al0WemO@9kNg/2OGem0WinOP9lO7`2Ng]k0Win
OP9gMgL2Ng]k17YjNP9nOWh2Ogmo0W]kN`9iNGT2O7al1Oooo`400001oooo000Eoooo00<0003ooooo
ool08_ooo`AlO7`2NGUi0WQhN09jNWX2Ogmo0WAdM0:3Ph<2A4A40/71`@8S8b<2Cdm?0VIVIP:KVi/2
MWIf0X61P@:8R8P2>c/k0RXZ:P8[:b/2c<c<0X>3P`:b/[82QHF50Xf=S@9hN7P2OGem0WalO0AmOGd2
O7al0W]kN`AjNWX2OGem0WYjNP:1PH42OGem0X:2PP9jNWX2NGUi0WmoO`9kNg/2O7al0WQhN09kNg/2
RHV90W=cL`03N7QhO7alO7al00AmOGd2O7al0W]kN`9oOgl2O7al0W]kN`9nOWh2O7al0WemO@9RHV82
UiNG0WalO0:>SXh2MgMg0Vm_K`9OGel2B4Q80SHf=P:b/[82IFEU0WIfMP:HV9P2W9bL0/c<c09/K6`2
SXj>0Xf=S@:DU9@2MWIf0WemO@9lO7`2NWYj0WalO09iNGT2OWin0W]kN`AlO7`2OGem0W]kN`9lO7`2
Ng]k1WalO09mOGd2Ng]k0WemO@9nOWh2O7al0W]kN`9nOWh2MgMg0W]kN`AjNWX2OWin0WmoO`9kNg/2
NGUi0WalO0Goool100000Oooo`005Oooo`030000oooooooo02;oool4O7al0XJ6QP:<S8`2PH610WEe
M@:7QhL2Ng]k0XN7Q`:3Ph<2Q8B40WalO09nOWh2MGEe0WYjNP9`L702LW9b0Xn?S`9iNGT2PH610Xj>
SP:3Ph<2KFe]0W]kN`9fMWH2OWin0WemO@9kNg/2NWYj0WUiN@9kNg/2O7al0X:2PP:3Ph<2N7Qh0Wmo
O`9TI6@2Ng]k0VMWI`9jNWX2Q8B40W=cL`:0P802NWYj0XZ:RP9gMgL2O7al0W]kN`03QXJ6OGemOGem
00AiNGT2Ng]k0WinOP9aLG42OGem0WinOP9fMWH2NGUi0WinOP:6QXH2Lg=c0WalO09iNGT2K6a/0X61
P@9mOGd2Ng]k0X20P0AoOgl2K6a/17]kN`9[Jf/2PH610W=cL`9jNWX2Ng]k17moO`9hN7P2PX:20WUi
N@:3Ph<2MgMg0WemO@9kNg/2O7al0WYjNPAnOWh2OGem0W]kN`9jNWX2Ng]k0WUiN@9lO7`2N7Qh0WIf
MP9lO7`2Ogmo0WYjNP9oOgl2MGEe0WemO@:1PH44Lg=c0X20P0:2PX82N7Qh1Oooo`400001oooo000E
oooo0P0002?oool4O7al0XJ6QP:<S8`2PH610WEeM@:7QhL2Ng]k0XN7Q`:3Ph<2Q8B40WalO09nOWh2
MGEe0WYjNP9`L702LW9b0Xn?S`9iNGT2PH610Xj>SP:3Ph<2KFe]0W]kN`9fMWH2OWin0WemO@9kNg/2
NWYj0WUiN@9kNg/2O7al0X:2PP:3Ph<2N7Qh0WmoO`9TI6@2Ng]k0VMWI`9jNWX2Q8B40W=cL`:0P802
NWYj0XZ:RP9gMgL2O7al0W]kN`03QXJ6OGemOGem00AiNGT2Ng]k0WinOP9aLG42OGem0WinOP9fMWH2
NGUi0WinOP:6QXH2Lg=c0WalO09iNGT2K6a/0X61P@9mOGd2Ng]k0X20P0AoOgl2K6a/17]kN`9[Jf/2
PH610W=cL`9jNWX2Ng]k17moO`9hN7P2PX:20WUiN@:3Ph<2MgMg0WemO@9kNg/2O7al0WYjNPAnOWh2
OGem0W]kN`9jNWX2Ng]k0WUiN@9lO7`2N7Qh0WIfMP9lO7`2Ogmo0WYjNP9oOgl2MGEe0WemO@:1PH44
Lg=c0X20P0:2PX82N7Qh1?ooo`800001oooo000Eoooo00<0003oooooool08_ooo`9dM7@2QHF50V1P
H0;clo<2UiNG0Z>SX`9FEUH2LG5a0WemO@9]KFd2HF5Q0Y>CT`9fMWH2OWin0XB4Q0:MWId2Vi^K0Va/
K09fMWH2IFEU0VUYJ@:9RHT2R8R80WIfMP9iNGT2MgMg0W=cL`B0P802Q8B40WmoO`9kNg/2IfMW0V=S
H`:1PH42PX:20Y2@T0:;Rh/2VYZJ16QXJ0:KVi/2IFEU0X^;R`9DE5@2T92@0WEeM@:ATI400emOGh20
P820P002PH610X>3P`:4Q8@2MgMg0ZRXZ09fMWH2MgMg0X^;R`:1PH42LG5a0WEeM@9oOgl2OGem0X20
P0:BTY82R8R80WYjNP9lO7`2Kfm_0WUiN@9GEeL2RHV90WAdM0:6QXH2Shn?0W5aL@:=SHd2M7Ad0VMW
I`9kNg/2KVi^0Xj>SP9^KVh2QXJ60VYZJP:3Ph<2NGUi0WmoO`9kNg/2O7al0WIfMP9cLg<2Ng]k0X61
P@9nOWh2O7al0X61P@9mOGd2PX:20XV9R@9hN7P2LW9b0XZ:RP8>3Ph200000U5AD@9^KVh2Ogmo0ZRX
Z09_Kfl2KVi^0Y2@T0Goool100000Oooo`005Oooo`030000oooooooo02;oool2M7Ad0XF5Q@9PH602
lo?c0YNGU`:SXj<2EUIF0W5aL@9mOGd2KFe]0V5QH@:CTi<2MWIf0WinOP:4Q8@2WIfM0Y^KV`9/K6`2
MWIf0VEUI@9YJFT2RHV90XR8R09fMWH2NGUi0WMgM`9cLg<4P8200XB4Q09oOgl2Ng]k0VMWI`9SHf<2
PH610X:2PP:@T902Rh^;0YZJVPAXJ6P2Vi^K0VEUI@:;Rh/2E5AD0Y2@T09eMGD2TI6A00=OGen0P820
P8000X61P@:3Ph<2Q8B40WMgM`:XZ:P2MWIf0WMgM`:;Rh/2PH610W5aL@9eMGD2Ogmo0WemO@:0P802
TY:B0XR8R09jNWX2O7al0Vm_K`9iNGT2EeMG0XV9R@9dM7@2QXJ60Xn?S`9aLG42SHf=0WAdM09WIfL2
Ng]k0Vi^KP:>SXh2KVi^0XJ6QP9ZJVX2Ph>30WUiN@9oOgl2Ng]k0WalO09fMWH2Lg=c0W]kN`:1PH42
OWin0WalO0:1PH42OGem0X:2PP:9RHT2N7Qh0W9bLP::RXX23Ph>0P00009ADE42KVi^0WmoO`:XZ:P2
Kfm_0Vi^KP:@T905oooo0@00007oool001Goool00`000?ooooooo`0Roooo0WEeM@:_[jl2DU9B0_oo
o`:DU9@2WIfM0[Vi^@8D51@2TI6A0[Vi^@:6QXH200000X20P09ZJVX2KFe]0Ph>3P8V9RH2T92@0UUI
F@;Hf=P2WYjN0U9BDP9:BTX2N7Qh0X^;R`:VYZH2W9bL0WmoO`9]KFd2VYZJ0WUiN@:=SHd2[Jf]0[jn
_P9SHf<2XZ:R0_gmo@8M7Ad2Hf=S0^7Qh@9^KVh2S8b<0UeMG@:d];@2oooo0UADE0;alO423@d=00>^
[Zjc/k>c/k<00UaLG097AdL2WYjN0/g=c@:BTY82Ng]k0YNGU`8^;Rh271`L0Ve]K@;:b/X2Hf=S0Ve]
K@8i>CT29BDU0VIVIP93@d<2TY:B0[fm_@9fMWH2hn?S0V=SH`:TY:@2EEEE0Rl_;`;1`L42EUIF0V1P
H0:l_;`2alO70[6a/@9hN7P2Zj^[0/30`0:DU9@2Cdm?0XB4Q09dM7@2DE5A0TY:BP:o_kl2YJFU0WAd
M09QHF42MWIf0TM7A`8g=cL2QXJ60Ve]K@9?Cdl2Lg=c0]_Kf`800002DU9B0RPX:0:c/k<2FUYJ0[bl
_0:>SXh2E5AD0^GUi@:PX:05oooo0@00007oool001Goool00`000?ooooooo`0Roooo0WEeM@:_[jl2
DU9B0_ooo`:DU9@2WIfM0[Vi^@8D51@2TI6A0[Vi^@:6QXH200000X20P09ZJVX2KFe]0Ph>3P8V9RH2
T92@0UUIF@;Hf=P2WYjN0U9BDP9:BTX2N7Qh0X^;R`:VYZH2W9bL0WmoO`9]KFd2VYZJ0WUiN@:=SHd2
[Jf]0[jn_P9SHf<2XZ:R0_gmo@8M7Ad2Hf=S0^7Qh@9^KVh2S8b<0UeMG@:d];@2oooo0UADE0;alO42
3@d=00>^[Zjc/k>c/k<00UaLG097AdL2WYjN0/g=c@:BTY82Ng]k0YNGU`8^;Rh271`L0Ve]K@;:b/X2
Hf=S0Ve]K@8i>CT29BDU0VIVIP93@d<2TY:B0[fm_@9fMWH2hn?S0V=SH`:TY:@2EEEE0Rl_;`;1`L42
EUIF0V1PH0:l_;`2alO70[6a/@9hN7P2Zj^[0/30`0:DU9@2Cdm?0XB4Q09dM7@2DE5A0TY:BP:o_kl2
YJFU0WAdM09QHF42MWIf0TM7A`8g=cL2QXJ60Ve]K@9?Cdl2Lg=c0]_Kf`800002DU9B0RPX:0:c/k<2
FUYJ0[bl_0:>SXh2E5AD0^GUi@:PX:05oooo0@00007oool001Goool00`000?ooooooo`0Boooo0VIV
IP:`/;027AdM0/g=c@Soool2_;bl0QTI6@9HF5P2e]KF0Q/K6`9VIVH2JVYZ0Y>CT`;oool2H61P0P00
00:`/;02Ogmo0Z:RXP:?Shl2oooo0Y6AT@9SHf<2`L710/K6aP:a/K42oooo0QhN7P;De=@2X:2P0X>3
P`:KVi/2PX:20XZ:RP9iNGT2alO70YbLW0:f][H2`L710Zb/[09=CDd2Shn?0WIfMP9hN7P2EUIF0XF5
Q@9ZJVX2Zj^[0SLg=`92@T82U9BD0XN7Q`9ADE400f=SHhR8R8R8R002R8R80X61P@9gMgL2cLg=0Wem
O@8m?Cd2/;2`0R0P808n?Sh2dm?C0Y>CT`;Hf=P25QHF0Z6QX@861PH2Ng]k0TM7A`:EUID2MWIf0SXj
>P9oOgl2oooo0ZNWY`;oool2e]KF0_ooo`90@402?Shn0ZVYZ@9BDU82l_;b0TE5A@8L71`2oooo0P00
00;oool2HV9R155AD@::RXX2o_kn0_ooo`9DE5@2EEEE0Xn?S`A]KFd2RHV90^WYj@:h^;P2PX:20YRH
V08m?Cd2F5QH0Xj>SP9fMWH2Rh^;0Ve]K@9oOgl2YZJV0Ve]K@9?Cdl5oooo0@00007oool001Goool0
0`000?ooooooo`0Boooo0VIVIP:`/;027AdM0/g=c@Soool2_;bl0QTI6@9HF5P2e]KF0Q/K6`9VIVH2
JVYZ0Y>CT`;oool2H61P0P0000:`/;02Ogmo0Z:RXP:?Shl2oooo0Y6AT@9SHf<2`L710/K6aP:a/K42
oooo0QhN7P;De=@2X:2P0X>3P`:KVi/2PX:20XZ:RP9iNGT2alO70YbLW0:f][H2`L710Zb/[09=CDd2
Shn?0WIfMP9hN7P2EUIF0XF5Q@9ZJVX2Zj^[0SLg=`92@T82U9BD0XN7Q`9ADE400f=SHhR8R8R8R002
R8R80X61P@9gMgL2cLg=0WemO@8m?Cd2/;2`0R0P808n?Sh2dm?C0Y>CT`;Hf=P25QHF0Z6QX@861PH2
Ng]k0TM7A`:EUID2MWIf0SXj>P9oOgl2oooo0ZNWY`;oool2e]KF0_ooo`90@402?Shn0ZVYZ@9BDU82
l_;b0TE5A@8L71`2oooo0P0000;oool2HV9R155AD@::RXX2o_kn0_ooo`9DE5@2EEEE0Xn?S`A]KFd2
RHV90^WYj@:h^;P2PX:20YRHV08m?Cd2F5QH0Xj>SP9fMWH2Rh^;0Ve]K@9oOgl2YZJV0Ve]K@9?Cdl5
oooo0@00007oool001Goool00`000?ooooooo`0Voooo0YfMW@;clo<200000Z>SX`;AdM429bLW0TQ8
B08k>c/2?clo0WIfMP:PX:02c/k>0X^;R`800002QXJ60ZJVYP:0P802l?3`0QdM7@;;bl/2Fe]K0X>3
P`8g=cL2[Zj^0WmoO`8b<S84OWin0W1`L0:8R8P2hn?S1_ooo`8c<c<2CTi>0U=CD`;oool2;Rh^0/?3
``9DE5@2WYjN0/O7a`;Vi^H2@d=30YbLW003QXJ6XJ6QXJ6Q009DE5@2Ng]k0_ooo`:FUYH2Y:BT0VMW
I`:KVi/2LW9b0WYjNP:c/k<2EeMG0^WYj@;oool2BDU90Zf][@8m?Cd2CTi>0UMGE`;dm?@2Ng]k0R`/
;0:XZ:P2AdM70XJ6QP:EUID2ADE50Q@D50:CTi<2K6a/0[^k^`:NWYh2BDU90Z^[Z`:SXj<2Q8B40Rd]
;@800002/K6a0YfMW@:4Q8@2JVYZ0X20P0;oool2/K6a0WinOP;oool2QXJ60TM7A`892@T2>CTi0/C4
a0;oool200000WEeM@9aLG42J6QX0[6a/@:RXZ82<C4a0WalO09XJ6P2P8201Oooo`400001oooo000E
oooo00<0003oooooool09_ooo`:MWId2lo?c0P0000:SXj<2dM7A0RLW9`98B4P2>c/k0Slo?`9fMWH2
X:2P0/k>cP:;Rh/200000XJ6QP:VYZH2P8200_3`l08M7Ad2bl_;0U]KF`:3Ph<2=cLg0Zj^[P9oOgl2
<S8b17inOP9`L702R8R80^?Sh`Koool2<c<c0Ti>CP9CDe<2oooo0Rh^;P;3`l<2E5AD0YjNWP;7alL2
i^KV0T=3@`:LW9`00hJ6QZ6QXJ6QX@02E5AD0W]kN`;oool2UYJF0ZBTY09WIfL2Vi^K0W9bLP9jNWX2
/k>c0UMGE`;YjNT2oooo0TU9B@:][Jd2?Cdm0Ti>CP9GEeL2m?Cd0W]kN`8/;2`2Z:RX0TM7A`:6QXH2
UIFE0TE5A@8D51@2Ti>C0Va/K0:k^k/2WYjN0TU9B@:[Zj/2Xj>S0XB4Q08];Bd200000[6a/@:MWId2
Q8B40VYZJP:0P802oooo0[6a/@9nOWh2oooo0XJ6QP97AdL22@T90STi>@;4a<@2oooo0P00009eMGD2
LG5a0VQXJ0:a/K42XZ:R0S4a<@9lO7`2J6QX0X20P0Goool100000Oooo`005Oooo`030000oooooooo
02;oool2T92@0P0000:CTi<2oooo0TE5A@9ZJVX2QXJ60_ooo`800002@d=30S8b<P8f=SH20@410_oo
o`9IFET2oooo0/O7a`:RXZ82kNg]0S4a<@9UIFD2no_k0Q<C4`:6QXH200000_ooo`:CTi<2oooo0Pd=
3@800002gmoO0^;RhP93@d<4oooo0];BdP;5aLD20@410U5AD@9KFe/200000_ooo`8a<C42/[:b0SPh
>0892@T2[jn_0P000003=SHfC4a<C4a<0093@d<2SXj>0/[:bP:f][H2K6a/0UaLG0800002RHV90Vm_
K`9WIfL2RHV90TQ8B0;oool2IFEU0/?3``9GEeL2>CTi0WEeM@:7QhL2HV9R0Z2PX09SHf<200000/g=
c@9gMgL2WIfM0Y2@T09aLG42WYjN0[jn_P9`L702AdM70/S8b0:PX:02];Bd0_ooo`:MWId2[jn_0SHf
=P800002[Zj^0Y>CT`:2PX82WYjN0Shn?P:ZZZX2BDU90Zj^[P8410@2oooo0X20P0:n_[h200000W1`
L0:6QXH2^k^k0]KFeP9MGEd2HV9R0]SHf0:j^[X2Kfm_1Oooo`400001oooo000Eoooo0P0002?oool2
T92@0P0000:CTi<2oooo0TE5A@9ZJVX2QXJ60_ooo`800002@d=30S8b<P8f=SH20@410_ooo`9IFET2
oooo0/O7a`:RXZ82kNg]0S4a<@9UIFD2no_k0Q<C4`:6QXH200000_ooo`:CTi<2oooo0Pd=3@800002
gmoO0^;RhP93@d<4oooo0];BdP;5aLD20@410U5AD@9KFe/200000_ooo`8a<C42/[:b0SPh>0892@T2
[jn_0P000003=SHfC4a<C4a<0093@d<2SXj>0/[:bP:f][H2K6a/0UaLG0800002RHV90Vm_K`9WIfL2
RHV90TQ8B0;oool2IFEU0/?3``9GEeL2>CTi0WEeM@:7QhL2HV9R0Z2PX09SHf<200000/g=c@9gMgL2
WIfM0Y2@T09aLG42WYjN0[jn_P9`L702AdM70/S8b0:PX:02];Bd0_ooo`:MWId2[jn_0SHf=P800002
[Zj^0Y>CT`:2PX82WYjN0Shn?P:ZZZX2BDU90Zj^[P8410@2oooo0X20P0:n_[h200000W1`L0:6QXH2
^k^k0]KFeP9MGEd2HV9R0]SHf0:j^[X2Kfm_1?ooo`800001oooo000Eoooo00<0003oooooool04?oo
o`:j^[X@oooo0P0000:d];@4oooo0WUiN@9;Bd/2Ti>C0^;RhP:PX:0200000UiNGP:NWYh200000_?c
l`;Shn<2Zj^[0P0000;YjNT2Ph>30VEUI@9JFUX2GEeM0/c<c09DE5@2D51@0VYZJP:>SXh2oooo0Ta<
C08S8b<2oooo0XZ:RP;oool200000^WYj@;MgMd2`l?30P0000;oool2SHf=0^3Ph0;gmoL2oooo0PT9
2@:j^[X2HV9R0V5QH@8000000e1@D3Ph>3Ph>002=cLg0WmoO`9YJFT2LW9b0^SXj0;2`/82NGUi0X:2
PP:3Ph<2UYJF0[Jf]P:0P80200000YRHV0:d];@2?Shn0X^;R`99BDT2d=3@0YjNWP9HF5P2;Rh^0WUi
N@97AdL2QHF50RPX:09gMgL2HF5Q0[Rh^08;2`/2o_kn0Vm_K`9eMGD2_;bl0RDU9@800002VIVI0XR8
R09UIFD2oooo0RDU9@8i>CT2^[Zj0Xn?S`8f=SH2oooo0YnOW`9hN7P2ZZZZ0VQXJ09lO7`2][Jf0P00
009SHf<2I6AT0WmoO`9VIVH2_kno0STi>@:SXj<2/;2`0]7Ad@Goool100000Oooo`005Oooo`030000
oooooooo013oool2^[Zj4?ooo`800002];Bd1?ooo`9iNGT2Bd];0Y>CT`;Rh^82X:2P0P00009NGUh2
WYjN0P0000;clo<2hn?S0Z^[Z`800002jNWY0X>3P`9UIFD2FUYJ0UeMG@;<c<`2E5AD0U1@D09ZJVX2
SXj>0_ooo`9<C4`28b<S0_ooo`::RXX2oooo0P0000;YjNT2gMgM0/?3``800002oooo0Xf=S@;Ph>02
moOg0_ooo`892@T2^[Zj0V9RHP9QHF42000000=@D50h>3Ph>3P00SLg=`9oOgl2JFUY0W9bLP;Xj>P2
`/;20WUiN@:2PX82Ph>30YJFUP:f][H2P8200P0000:HV9P2];Bd0Shn?P:;Rh/2BDU90]3@d0:NWYh2
F5QH0Rh^;P9iNGT2AdM70XF5Q@8X:2P2MgMg0V5QH@:h^;P22`/;0_knoP9_Kfl2MGEe0[bl_08U9BD2
00000YVIV@:8R8P2IFEU0_ooo`8U9BD2>CTi0[Zj^P:?Shl2=SHf0_ooo`:OWil2N7Qh0ZZZZP9XJ6P2
O7al0[Jf]P800002Hf=S0VATI09oOgl2IVIV0[no_`8i>CT2Xj>S0[2`/0;AdM45oooo0@00007oool0
01Goool00`000?ooooooo`0Roooo0TY:BP800002820P0P00009]KFd210@40P0000;oool2OWin0P00
009]KFd2@4100X>3P`:=SHd2bLW91000009LG5`2Jf][0U5AD@;]kNd2?3`l0Slo?`800002=SHf0[jn
_P8000024Q8B0]SHf09GEeL200000XF5Q@;oool2G5aL0Z^[Z`9nOWh2<c<c0UMGE`@00002oooo0Xj>
SP:WYjL2U9BD0/?3``9GEeL2RXZ:0Zf][@03ADE5X:2PX:2P009ZJVX2;Bd]0Z:RXP9]KFd2dm?C0_oo
o`9eMGD2PH610WIfMP;@d=02LW9b0[:b/P;oool2IFEU0Y>CT`:<S8`200000/30`08l?3`2Ng]k0YFE
U@8n?Sh2MGEe0YjNWP8R8R82HF5Q0WEeM@9JFUX2ADE50/;2`P97AdL2G5aL0X61P@8L71`2c/k>0[2`
/09IFET24a<C0ZNWY`8H61P2GUiN0Z>SX`;Vi^H261PH0]gMg@:;Rh/2H61P0XN7Q`9RHV82SHf=0VAT
I0;1`L42oooo0X:2PP97AdL210@40_ooo`800002lo?c0Ta<C09CDe<2^[Zj1Oooo`400001oooo000E
oooo00<0003oooooool08_ooo`9:BTX200000R0P80800002KFe]0P@410800002oooo0WinOP800002
KFe]0T10@0:3Ph<2SHf=0/W9b@@00002G5aL0V][J`9ADE42kNg]0S`l?08o?cl200000SHf=P:n_[h2
00000Q8B4P;Hf=P2EeMG0P0000:5QHD2oooo0UaLG0:[Zj/2OWin0S<c<`9GEeL400000_ooo`:>SXh2
YjNW0YBDU0;3`l<2EeMG0XZ:RP:][Jd00dE5AJ2PX:2PX002JVYZ0Rd];@:RXZ82KFe]0]?Cd`;oool2
MGEe0X61P@9fMWH2d=3@0W9bLP:b/[82oooo0VEUI@:CTi<2S8b<0P0000;0`<02?3`l0W]kN`:EUID2
?Shn0WEeM@:NWYh28R8R0V5QH@9eMGD2FUYJ0TE5A@;2`/82AdM70UaLG0:1PH4271`L0/k>cP:`/;02
FEUI0Q<C4`:WYjL261PH0UiNGP:SXj<2i^KV0QPH60;MgMd2Rh^;0V1PH0:7QhL2HV9R0Xf=S@9TI6@2
`L710_ooo`:2PX82AdM70P@410;oool200000_?cl`9<C4`2De=C0[Zj^PGoool100000Oooo`005Ooo
o`030000oooooooo02;oool2Hf=S0/G5a@800002oooo0P0000:BTY8200000_ooo`:/[:`2JFUY0UQH
F0;UiND2T92@0X^;R`;oool23Ph>0S/k>`:NWYh26QXJ0/k>cP8_;bl2TI6A0S4a<@;oool2De=C0_oo
o`8Q8B422`/;0Vm_K`@00002inOW0Xj>SP9WIfL4oooo0[2`/09nOWh2b<S80Ti>CP@00002clo?0^[Z
jP9;Bd/2IVIV0UEEE@;oool00inOW`0000000002oooo0RHV9P9lO7`2SXj>0YRHV0:;Rh/2J6QX0XR8
R09lO7`2Cdm?0P0000;oool2/k>c0_ooo`92@T82_[jn0Y>CT`:][Jd2OGem0U=CD`9/K6`2;Rh^0Z6Q
X@800002JFUY0X>3P`:WYjL2[jn_0Zb/[0;1`L42<c<c0Q0@40:YZJT2^KVi0^7Qh@;oool292@T0ZJV
YP;4a<@25aLG0_ooo`;]kNd2fMWI0]oOg`9;Bd/2j^[Z0]7Ad@9lO7`2@T920[:b/P:LW9`2UiNG0UUI
F@9dM7@2MgMg0[fm_@98B4P2f=SH0^OWi`8I6AT9oooo0@00007oool001Goool00`000?ooooooo`0R
oooo0V=SH`;5aLD200000_ooo`800002TY:B0P0000;oool2[:b/0VUYJ@9HF5P2iNGU0Y2@T0:;Rh/2
oooo0Ph>3P8k>c/2WYjN0QXJ6P;>c/h2;bl_0Y6AT@8a<C42oooo0U=CD`;oool28B4Q0P/;2`9_Kfl4
00000^OWi`:>SXh2IfMW1?ooo`:`/;02OWin0/S8b09>CTh400000/o?c`;Zj^X2Bd];0VIVIP9EEED2
oooo00>OWil0000000000_ooo`8V9RH2O7al0Xj>SP:HV9P2Rh^;0VQXJ0:8R8P2O7al0Tm?C`800002
oooo0[>c/`;oool2@T920[jn_P:CTi<2[Jf]0WemO@9CDe<2K6a/0Rh^;P:QXJ4200000VUYJ@:3Ph<2
YjNW0Zn_[`:/[:`2`L710S<c<`8@4102ZJVY0[Vi^@;QhN42oooo0R@T90:VYZH2a<C40QLG5`;oool2
kNg]0]WIf@;Ogml2Bd];0^[ZjP;AdM42O7al0T92@P:b/[82W9bL0YNGU`9IFET2M7Ad0WMgM`:m_Kd2
B4Q80]SHf0;WinL26ATI2Oooo`400001oooo000Eoooo00<0003oooooool08_ooo`::RXX2Rh^;0[Zj
^P;oool200000V5QH@:BTY82KVi^0XN7Q`9=CDd2]KFe0Q<C4`;;bl/2YJFU0/K6aP800002XZ:R0XV9
R@:2PX82U9BD0Va/K0;Jf]X2Ogmo0_?cl`800002XZ:R0SPh>08O7al2aLG50WMgM`:ATI42GUiN0V1P
H0:MWId2L71`0X20P0;4a<@251@D0_ooo`:XZ:P2UYJF0WYjNP;oool2410@0WYjNP9bLW82EUIF0_oo
o`03@D51OgmoOgmo00:CTi<2GemO0[Jf]P:SXj<2[Jf]0Z:RXP9VIVH2LG5a0VQXJ0;oool200000P/;
2`;oool2VIVI0S8b<P800002MWIf0YZJVP:g]kL4K6a/0]OGe`;3`l<2Ogmo0_ooo`:j^[X2:2PX0YZJ
VP800002B4Q80_Ogm`8a<C42ZZZZ0Y>CT`;oool28b<S0VIVIP9EEED2MGEe0V9RHP:7QhL2RXZ:0W5a
L@9lO7`2UIFE0X>3P`92@T82oooo0UUIF@;UiND2QhN70]KFeP8:2PX4GUiN0Xn?S`9CDe<2oooo0P00
00:HV9P2RXZ:0[Vi^@Goool100000Oooo`005Oooo`030000oooooooo02;oool2RXZ:0X^;R`:j^[X2
oooo0P00009QHF42TY:B0Vi^KP:7QhL2CDe=0[Fe]@8C4a<2bl_;0ZFUY@;6a/H200000Z:RXP:9RHT2
PX:20YBDU09/K6`2f][J0WmoO`;clo<200000Z:RXP8h>3P27alO0/G5a@9gMgL2TI6A0UiNGP9PH602
WIfM0W1`L0:0P802a<C40Q@D50;oool2Z:RX0YJFUP9jNWX2oooo0Q0@409jNWX2LW9b0UIFEP;oool0
0d51@GmoOgmoO`02Ti>C0UmOG`:f][H2Xj>S0Zf][@:RXZ82IVIV0W5aL@9XJ6P2oooo0P00008;2`/2
oooo0YVIV@8b<S8200000WIfMP:JVYX2]kNg16a/K0;GemL2`l?30WmoO`;oool2^[Zj0RPX:0:JVYX2
00000TQ8B0;gmoL2<C4a0ZZZZP:CTi<2oooo0R<S8`9VIVH2EEEE0WEeM@9RHV82QhN70XZ:RP9aLG42
O7al0YFEU@:3Ph<2@T920_ooo`9IFET2iNGU0XN7Q`;Fe]H22PX:15iNGP:?Shl2De=C0_ooo`800002
V9RH0XZ:RP:i^KT5oooo0@00007oool001Goool00`000?ooooooo`02oooo0W5aLA[oool2h^;R0S@d
=0:4Q8@2I6AT0V5QH@8O7al2/k>c0WIfMP9kNg/2KFe]0[2`/0:UYJD2EEEE0YFEU@;GemL200000[Vi
^@:4Q8@2oooo0][JfP:?Shl2OGem0V5QH@:9RHT2LW9b0[^k^`800002FEUI0WinOP::RXX2L71`0WQh
N09fMWH2Ph>30XV9R@9WIfL2D51@0[Rh^090@402U9BD0UADE09fMWH2OGem0W5aL@9ADE42RXZ:0Y2@
T0:<S8`2Ng]k0VYZJP03QhN7Ng]kNg]k009fMWH2QhN70W5aL@9bLW82H61P0XZ:RP9_Kfl2I6AT0XV9
R@:4Q8@2@d=30UaLG0;?cll2FUYJ0VUYJ@9ADE42NGUi0XF5Q@:ATI42NGUi0W]kN`9dM7@2NGUi0YBD
U0:j^[X2_[jn0SXj>P9/K6`2;bl_0YfMW@90@402P8200W]kN`9lO7`2J6QX0Y2@T09nOWh2Q8B40Wmo
O`:1PH42O7al0WUiN@:0P802OWin0WEeM@9lO7`2Rh^;0WinOP:8R8P2FEUI0XF5Q@:QXJ42[Zj^0WYj
NP9gMgL2O7al0WmoO`9XJ6P2TI6A0WAdM09iNGT2O7al1Oooo`400001oooo000Eoooo0P0000?oool2
LG5a6_ooo`;Rh^82=3@d0XB4Q09TI6@2HF5Q0QlO7`:c/k<2MWIf0W]kN`9]KFd2/;2`0ZFUY@9EEED2
UIFE0]OGe`800002^KVi0XB4Q0;oool2f][J0Xn?S`9mOGd2HF5Q0XV9R@9bLW82^k^k0P00009IFET2
OWin0XZ:RP9`L702N7Qh0WIfMP:3Ph<2RHV90VMWI`9@D502^;Rh0T10@0:DU9@2E5AD0WIfMP9mOGd2
LG5a0U5AD@::RXX2T92@0Xb<S09kNg/2JVYZ00>7QhMkNg]kNg/00WIfMP:7QhL2LG5a0W9bLP9PH602
RXZ:0Vm_K`9TI6@2RHV90XB4Q093@d<2G5aL0/o?c`9JFUX2JFUY0U5AD@9iNGT2QHF50Y6AT@9iNGT2
Ng]k0WAdM09iNGT2U9BD0[Zj^P:n_[h2>SXj0Va/K08_;bl2WIfM0T10@0:0P802Ng]k0WalO09XJ6P2
T92@0WinOP:4Q8@2Ogmo0X61P@9lO7`2NGUi0X20P09nOWh2MGEe0WalO0:;Rh/2OWin0XR8R09IFET2
QHF50Z6QX@:^[Zh2NWYj0WMgM`9lO7`2Ogmo0VQXJ0:ATI42M7Ad0WUiN@9lO7`4oooo0P00007oool0
01Goool00`000?ooooooo`02oooo0WMgMa[oool2]KFe0_ooo`9lO7`2PH610XB4Q0:BTY82JVYZ0Wem
O@9jNWX2O7al0Z:RXP;oool200000VUYJ@;UiND2j>SX0VEUI@9fMWH2@d=30XR8R08l?3`2_[jn0Xj>
SP9bLW82]KFe0UUIF@;@d=02MGEe0WinOP9gMgL2OWin0WemO@9nOWh2NGUi0WQhN0:1PH42QHF50W9b
LP::RXX2MGEe0XV9R@AmOGd2Ogmo0XZ:RP9fMWH2MgMg0WQhN09bLW82UYJF00=hN7QmOGemOGd00Win
OP9jNWX4Ogmo0X>3P`9jNWX2Ogmo0X61P@9iNGT2NWYj0Xj>SP:CTi<2FUYJ0WIfMP;1`L42EeMG0[^k
^`:4Q8@2JVYZ0Y:BTP:6QXH2O7al0W=cL`:1PH42M7Ad0W5aL@:g]kL2G5aL0XN7Q`9ZJVX2Shn?0WUi
N@9mOGd2Ng]k0X:2PP9fMWH2Ng]k0WUiN@9kNg/2NWYj0W]kN`9lO7`4Ng]k0WinOP9kNg/2MgMg0Win
OP9iNGT2QXJ60WYjNP9dM7@2Kfm_1WalO09kNg/2PX:20WIfMP9nOWh2Ng]k0WemO@Goool100000Ooo
o`005Oooo`030000oooooooo00;oool2MgMg6_ooo`:e]KD2oooo0WalO0:1PH42Q8B40Y:BTP9ZJVX2
OGem0WYjNP9lO7`2XZ:R0_ooo`800002JFUY0^GUi@;Xj>P2IFEU0WIfMP93@d<2R8R80S`l?0:n_[h2
SXj>0W9bLP:e]KD2FEUI0]3@d09eMGD2OWin0WMgM`9nOWh2OGem0WinOP9iNGT2N7Qh0X61P@:5QHD2
LW9b0XZ:RP9eMGD2RHV917emO@9oOgl2RXZ:0WIfMP9gMgL2N7Qh0W9bLP:FUYH00gQhN7emOGemO@02
OWin0WYjNPAoOgl2Ph>30WYjNP9oOgl2PH610WUiN@9jNWX2SXj>0Y>CT`9JFUX2MWIf0/71`@9GEeL2
^k^k0XB4Q09ZJVX2TY:B0XJ6QP9lO7`2Lg=c0X61P@9dM7@2LG5a0[Ng]`9LG5`2QhN70VYZJP:?Shl2
NGUi0WemO@9kNg/2PX:20WIfMP9kNg/2NGUi0W]kN`9jNWX2Ng]k0WalO0AkNg/2OWin0W]kN`9gMgL2
OWin0WUiN@:6QXH2NWYj0WAdM09_Kfl6O7al0W]kN`:2PX82MWIf0WinOP9kNg/2OGem1Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`9kNg/2Kfm_0WinOP9bLW82L71`0Va/K09eMGD2HF5Q0XB4
Q0:k^k/2Shn?0Xb<S09lO7`2PH610WAdM09lO7`2OWin0WMgM`9bLW82KFe]0UaLG09jNWX2KVi^0XV9
R@:2PX82Lg=c0Y6AT@:HV9P2P8200WMgM`9mOGd2QHF50X61P@:0P802SXj>0X20P09dM7@2PX:20WMg
M`9mOGd2MWIf0WUiN@9jNWX2O7al0WemO@9fMWH2OWin0WYjNP9kNg/2NGUi0WmoO`9_Kfl2PH610Z6Q
X@:6QXH2IfMW0WQhN09kNg/2NGUi0WIfMP9/K6`2PH610V][J`:<S8`00gEeMHN7QhN7Q`02Ng]k0X61
P@9mOGd2NGUi0WMgM`9lO7`2NWYj0WmoO`:4Q8@2Ogmo0WemO@9iNGT2Ng]k0X61P@:0P802OWin0XZ:
RP:0P802OWin0WYjNP9gMgL2PH610WIfMP:1PH42NWYj0W]kN`AnOWh2LW9b0WIfMP9iNGT2MGEe0WQh
N09cLg<2MgMg0X61P@9jNWX2O7al0X61P@:3Ph<4NWYj0W]kN`9mOGd2O7al0X:2PP:5QHD2NWYj1861
P@9mOGd2MGEe0YNGU`9CDe<2Q8B40W1`L09VIVH2W9bL0Xn?S`9eMGD2J6QX0WAdM0Goool100000Ooo
o`005Oooo`030000oooooooo00;oool2Ng]k0Vm_K`9nOWh2LW9b0W1`L09/K6`2MGEe0V5QH@:4Q8@2
^k^k0Xn?S`:<S8`2O7al0X61P@9dM7@2O7al0WinOP9gMgL2LW9b0Ve]K@9LG5`2NWYj0Vi^KP:9RHT2
PX:20W=cL`:ATI42V9RH0X20P09gMgL2OGem0XF5Q@:1PH42P8200Xj>SP:0P802M7Ad0X:2PP9gMgL2
OGem0WIfMP9iNGT2NWYj0WalO09mOGd2MWIf0WinOP9jNWX2Ng]k0WUiN@9oOgl2Kfm_0X61P@:QXJ42
QXJ60VMWI`9hN7P2Ng]k0WUiN@9fMWH2K6a/0X61P@9[Jf/2S8b<00=eMGF7QhN7QhL00W]kN`:1PH42
OGem0WUiN@9gMgL2O7al0WYjNP9oOgl2Q8B40WmoO`9mOGd2NGUi0W]kN`:1PH42P8200WinOP::RXX2
P8200WinOP9jNWX2MgMg0X61P@9fMWH2PH610WYjNP9kNg/4OWin0W9bLP9fMWH2NGUi0WEeM@9hN7P2
Lg=c0WMgM`:1PH42NWYj0WalO0:1PH42Ph>317YjNP9kNg/2OGem0WalO0:2PX82QHF50WYjNPB1PH42
OGem0WEeM@:GUiL2De=C0XB4Q09`L702IVIV0YbLW0:?Shl2MGEe0VQXJ09dM7@5oooo0@00007oool0
01Goool00`000?ooooooo`02oooo0WemO@:GUiL2TY:B0ZRXZ0:g]kL2_Kfm0YRHV0;[jn/2EUIF0R8R
8P9`L702WYjN0WUiN@9TI6@2ZJVY0WmoO`9dM7@2NGUi0ZNWY`:UYJD2JVYZ0TI6AP:j^[X2RXZ:0U1@
D0;1`L42VIVI0S0`<0:GUiL2SHf=0V=SH`@n?Sh2WinO0YNGU`:QXJ42VIVI0UQHF09WIfL2PH610Xf=
S@9jNWX2MGEe0WalO09[Jf/2CDe=0WYjNP:2PX82W9bL0Z:RXP9@D502Ph>30T];B`;oool200000VQX
J0:b/[8292@T0XF5Q@9kNg/2clo?0Ve]K@:QXJ42EeMG00?[jn^IVIVIVIT00TU9B@9RHV82MgMg0Va/
K08W9bL2QXJ60XF5Q@9KFe/2JFUY0WinOP:UYJD2@T920Xf=S@9=CDd2KVi^0W5aL@:2PX82SHf=0XZ:
RP:_[jl2W9bL0TI6AP:;Rh/2Bd];0S8b<P:5QHD2U9BD0W=cL`:^[Zh2V9RH0WmoO`96ATH2[jn_0UEE
E@:[Zj/2B4Q80WQhN0:3Ph<2UYJF0W]kN`:JVYX2JFUY0XB4Q0:6QXH2I6AT0X>3P`9oOgl2Rh^;0V1P
H09JFUX2FEUI0WmoO`:3Ph<2`<300/o?c`A`L702OWin0V][J`:4Q8@2YZJV0VIVIPGoool100000Ooo
o`005Oooo`030000oooooooo00;oool2OGem0YNGU`:BTY82Z:RX0[Ng]`:m_Kd2V9RH0^_[j`9FEUH2
8R8R0W1`L0:NWYh2NGUi0VATI0:YZJT2Ogmo0WAdM09iNGT2YjNW0ZFUY@9ZJVX2ATI60[Zj^P::RXX2
D51@0/71`@:IVIT2<30`0YNGU`:=SHd2Hf=S13hn?P:OWil2UiNG0Z6QX@:IVIT2F5QH0VMWI`:1PH42
SHf=0WYjNP9eMGD2O7al0V][J`9=CDd2NWYj0X:2PP:LW9`2XZ:R0U1@D0:3Ph<2Bd];0_ooo`800002
J6QX0[:b/P8T92@2QHF50W]kN`;?cll2KFe]0Z6QX@9GEeL00n_[jiVIVIVIV@02BDU90V9RHP9gMgL2
K6a/0RLW9`:6QXH2QHF50U]KF`9YJFT2OWin0ZFUY@92@T82SHf=0Te=C@9^KVh2LG5a0X:2PP:=SHd2
RXZ:0Zn_[`:LW9`2ATI60X^;R`9;Bd/2<S8b0XF5Q@:DU9@2Lg=c0Zj^[P:HV9P2Ogmo0TI6AP:_[jl2
EEEE0Z^[Z`98B4P2N7Qh0X>3P`:FUYH2Ng]k0YZJVP9YJFT2Q8B40XJ6QP9TI6@2Ph>30WmoO`:;Rh/2
H61P0UYJFP9IFET2Ogmo0X>3P`;0`<02clo?171`L09nOWh2Jf][0XB4Q0:VYZH2IVIV1Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`9LG5`200000Q8B4P8000027alO1000008Q8B42T92@0]cL
g0;oool2X:2P0[Fe]@810@42CDe=0P00009XJ6P2UIFE0Tm?C`:ZZZX2W9bL0ZRXZ098B4P2SXj>0SDe
=@9_Kfl27AdM0]oOg`9_Kfl2V9RH0XN7Q`Coool2IVIV0YFEU@8K6a/2;Rh^0/;2`P:4Q8@2?Shn0XZ:
RP9HF5P2?Cdm0[Ng]`9iNGT2G5aL0Xj>SP9nOWh29bLW0Rh^;P9=CDd2UiNG0ZRXZ09LG5`2N7Qh0ZRX
Z09dM7@2JVYZ0S`l?0:YZJT22@T90^OWi`:;Rh/2l?3`00?Lg=`j>SXj>SX00T10@09dM7@2DE5A0P00
00:h^;P2R8R80V5QH@:`/;02JFUY0Rh^;P:b/[8210@40YFEU@9IFET2m?Cd0]KFeP:HV9P2ZZZZ0RPX
:0;@d=0200000WinOP9?Cdl2MWIf0WUiN@9GEeL2oooo0QXJ6P8/;2`2bl_;0Rh^;P9^KVh2IFEU0XR8
R08F5QH2IFEU0U5AD@:RXZ82/[:b0X^;R`:f][H271`L0V5QH@:RXZ82GemO0YFEU@;7alL2W9bL0Y>C
T`:h^;P27AdM0QDE5@:l_;`2`l?30Ve]K@:[Zj/2IfMW0X20P0:JVYX2LG5a0[jn_P;Cdm<5oooo0@00
007oool000Woool300000oooo`030000oooooooo00?oool00`000?ooooooo`02oooo0UaLG0800002
4Q8B0P00008O7al400000R4Q8@:@T902g=cL0_ooo`:PX:02]KFe0P410@9=CDd200000VQXJ0:EUID2
Cdm?0ZZZZP:LW9`2Z:RX0TQ8B0:>SXh2=CDe0Vm_K`8M7Ad2gmoO0Vm_K`:HV9P2QhN71?ooo`9VIVH2
UIFE0Q/K6`8^;Rh2`/;20XB4Q08n?Sh2RXZ:0UQHF08m?Cd2]kNg0WUiN@9LG5`2SXj>0WinOP8W9bL2
;Rh^0Te=C@:GUiL2Z:RX0UaLG09hN7P2Z:RX0WAdM09ZJVX2?3`l0ZVYZ@892@T2inOW0X^;R`;`l?00
0mcLg3Xj>SXj>P02@4100WAdM09ADE4200000[Rh^0:8R8P2HF5Q0[2`/09YJFT2;Rh^0[:b/P8410@2
UIFE0UUIF@;dm?@2e]KF0YRHV0:ZZZX2:2PX0]3@d0800002OWin0Tm?C`9fMWH2NGUi0UMGE`;oool2
6QXJ0R`/;0;;bl/2;Rh^0Vi^KP9UIFD2R8R80QHF5P9UIFD2DE5A0Z:RXP:b/[82Rh^;0[Jf]P8L71`2
HF5Q0Z:RXP9OGel2UIFE0/O7a`:LW9`2Ti>C0[Rh^08M7Ad25ADE0[bl_0;3`l<2KFe]0Z^[Z`9WIfL2
P8200YZJVP9aLG42_[jn0]?Cd`Goool100000Oooo`002Oooo`030000oooooooo00;oool00`000?oo
o`000004oooo00<0003oooooool01?ooo`:e]KD2Zj^[0_ooo`:3Ph<2k>c/0_Gem@;hn?P2oooo0PP8
208Z:RX2d];B1000009mOGd2oooo0_Shn0;oool2Cdm?0UiNGP9cLg<2EUIF0Y^KV`9LG5`20`<30UaL
G0;oool2KVi^0R/[:`8e=CD2FEUI0R0P80:5QHD2>CTi0T92@P9>CTh2QHF50STi>@9hN7P200000Xb<
S0:j^[X2j>SX0ZZZZP8T92@2^KVi0U5AD@93@d<2ZJVY0_KfmP:OWil2RHV90SPh>0:KVi/2@4100V9R
HP:8R8P2RXZ:0UQHF09nOWh2oooo0T];B`:5QHD2UIFE00=eMGF1PH61PH400VIVIP95ADD2BTY:0YNG
U`91@D42hN7Q0W5aL@:<S8`2;bl_0V9RHP:BTY82GemO0VEUI@:m_Kd2J6QX0TQ8B0:MWId2Lg=c0W5a
L@9cLg<2m?Cd0ZRXZ09/K6`2BTY:0/k>cP:LW9`2XJ6Q0Y6AT@9/K6`2_[jn0ZZZZP8G5aL2V9RH0YVI
V@8T92@2GemO0S0`<09mOGd2OWin0XZ:RP;7alL2UIFE0Te=C@8N7Qh2VYZJ0Y6AT@:_[jl2A4A40ZBT
Y09iNGT2bl_;0Z6QX@A^KVh2PH610VYZJP:OWil2^[Zj0VATI09SHf<2M7Ad0W1`L0Goool100000Ooo
o`002_ooo`070000oooooooooooo0000oooo000000Coool200001Oooo`:e]KD2Zj^[0_ooo`:3Ph<2
k>c/0_Gem@;hn?P2oooo0PP8208Z:RX2d];B1000009mOGd2oooo0_Shn0;oool2Cdm?0UiNGP9cLg<2
EUIF0Y^KV`9LG5`20`<30UaLG0;oool2KVi^0R/[:`8e=CD2FEUI0R0P80:5QHD2>CTi0T92@P9>CTh2
QHF50STi>@9hN7P200000Xb<S0:j^[X2j>SX0ZZZZP8T92@2^KVi0U5AD@93@d<2ZJVY0_KfmP:OWil2
RHV90SPh>0:KVi/2@4100V9RHP:8R8P2RXZ:0UQHF09nOWh2oooo0T];B`:5QHD2UIFE00=eMGF1PH61
PH400VIVIP95ADD2BTY:0YNGU`91@D42hN7Q0W5aL@:<S8`2;bl_0V9RHP:BTY82GemO0VEUI@:m_Kd2
J6QX0TQ8B0:MWId2Lg=c0W5aL@9cLg<2m?Cd0ZRXZ09/K6`2BTY:0/k>cP:LW9`2XJ6Q0Y6AT@9/K6`2
_[jn0ZZZZP8G5aL2V9RH0YVIV@8T92@2GemO0S0`<09mOGd2OWin0XZ:RP;7alL2UIFE0Te=C@8N7Qh2
VYZJ0Y6AT@:_[jl2A4A40ZBTY09iNGT2bl_;0Z6QX@A^KVh2PH610VYZJP:OWil2^[Zj0VATI09SHf<2
M7Ad0W1`L0Coool200000Oooo`002_ooo`070000oooooooooooo0000oooo000000Coool00`000?oo
ooooo`02oooo0P000093@d<600000_ooo`8/;2`2oooo0Q@D50;=cLd200000U=CD`80000251@D0_oo
o`:2PX8271`L0PP8209jNWX2<c<c0_ooo`9ZJVX2FEUI0Rh^;P9RHV82VIVI0U=CD`8S8b<2Ph>30Te=
C@:j^[X2o?cl0Xb<S09^KVh2T92@0P00009SHf<2VIVI0SPh>09@D50200000Zn_[`9dM7@2Lg=c0P00
008H61P2Vi^K0STi>@8o?cl2I6AT0Ve]K@;oool2OWin0X:2PP;Zj^X200000_clo08410@2?Cdm0YjN
WP:LW9`2RHV90Vi^KP;@d=000gYjNRHV9RHV9P02Lg=c0RDU9@8n?Sh2;Rh^0YNGU`8410@2YZJV0Z2P
X09gMgL2SXj>0UUIF@:HV9P2CDe=0VIVIP9CDe<2aLG50W1`L0:LW9`2XJ6Q0Rl_;`9jNWX2[:b/0X20
P0;Jf]X2OGem0VEUI@8h>3P2R8R80Q/K6`8000022`/;0^KViP9lO7`2QXJ60YjNWP;oool292@T0Xb<
S0:KVi/2[jn_0WIfMP:PX:02g=cL0WMgM`:a/K42H61P0R/[:`;QhN42Cdm?0WIfMP8h>3P2B4Q80/k>
cP9KFe/2WYjN0]3@d08d=3@2EEEE0/c<c0:XZ:P2OWin0W]kN`Goool100000Oooo`002Oooo`030000
oooo000000;oool00`000?ooo`000004oooo00<0003oooooool00_ooo`800002@d=31P0000;oool2
;2`/0_ooo`8D51@2cLg=0P00009CDe<200000Q@D50;oool2PX:20Q`L708820P2NWYj0S<c<`;oool2
JVYZ0UUIF@8^;Rh2HV9R0YVIV@9CDe<28b<S0X>3P`9=CDd2^[Zj0_clo0:<S8`2KVi^0Y2@T0800002
Hf=S0YVIV@8h>3P2D51@0P0000:_[jl2M7Ad0W=cL`80000261PH0Y^KV`8i>CT2?clo0VATI09]KFd2
oooo0WinOP:2PX82j^[Z0P0000;lo?`210@40Sdm?@:NWYh2W9bL0XV9R@9^KVh2d=3@00=jNWXV9RHV
9RH00W=cL`8U9BD2?Shn0Rh^;P:GUiL210@40ZJVYP:PX:02MgMg0Xj>SP9IFET2V9RH0Te=C@9VIVH2
De=C0/G5a@9`L702W9bL0Z6QX@8_;bl2NWYj0Zb/[0:0P802f][J0WemO@9UIFD2>3Ph0XR8R08K6a/2
00000P/;2`;Vi^H2O7al0XJ6QP:NWYh2oooo0R@T90:<S8`2Vi^K0Zn_[`9fMWH2X:2P0]cLg09gMgL2
/K6a0V1PH08[:b/2hN7Q0Tm?C`9fMWH2>3Ph0TQ8B0;>c/h2Fe]K0YjNWP;@d=02=3@d0UEEE@;<c<`2
Z:RX0WinOP9kNg/5oooo0@00007oool000[oool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo00;oool2LG5a0RHV9P:YZJT2MWIf0[2`/09CDe<2:b/[0[^k^`800004oooo0Tm?
C`:DU9@2Shn?0P0000:WYjL2@4100VIVIP9MGEd2KFe]0_ooo`9ZJVX2L71`0V1PH0;>c/h2NWYj0]OG
e`;inOT2;2`/0Xb<S0:/[:`2SXj>0TU9B@;5aLD2lo?c0^GUi@800002Kfm_0]OGe`92@T826ATI0XF5
Q@:a/K42<c<c0Y6AT@8h>3P2U9BD0Ve]K@:9RHT2b<S80/k>cP8N7Qh2:RXZ0SPh>09CDe<2Ogmo0TY:
BP9EEED2KVi^0]OGe`9PH602M7Ad0VATI09UIFD00kfm_E1@D51@D002o_kn0WinOP;4a<@2PH610YbL
W09hN7P2KVi^0WYjNP9oOgl2Hf=S0YZJVP9eMGD24A4A0YNGU`:e]KD2HV9R0S/k>`9<C4`2PH610]SH
f0:EUID2IfMW0Sdm?@:m_Kd2`l?30UQHF0:IVIT2FEUI0_Cdm0;GemL2OGem0Sdm?@800002IFEU0P00
00;bl_82OGem0/C4a0Coool2QhN70TI6AP9lO7`2FUYJ0W1`L0:@T902De=C0WAdM0;Ti>@2bl_;0X20
P0:h^;P200000XN7Q`;Lg=`2[:b/0YfMW@;oool2hN7Q0Q0@4093@d<2EeMG1Oooo`400001oooo000E
oooo00<0003oooooool00_ooo`9aLG429RHV0ZVYZ@9fMWH2/;2`0U=CD`8[:b/2^k^k0P0000Coool2
Cdm?0YBDU0:?Shl200000ZNWY`90@402IVIV0UeMG@9]KFd2oooo0VYZJP9`L702H61P0/k>cP9jNWX2
emOG0_Win@8/;2`2S8b<0Zb/[0:>SXh2BDU90/G5a@;clo<2iNGU0P00009_Kfl2emOG0T92@P8I6AT2
QHF50[6a/@8c<c<2TI6A0SPh>0:DU9@2KFe]0XV9R@;8b<P2c/k>0QhN7P8Z:RX2>3Ph0U=CD`9oOgl2
BTY:0UEEE@9^KVh2emOG0V1PH09dM7@2I6AT0VEUI@03_KfmD51@D51@00;no_h2OWin0/C4a0:1PH42
W9bL0WQhN09^KVh2NWYj0WmoO`9SHf<2VYZJ0WEeM@8A4A42UiNG0[Fe]@9RHV82>c/k0Ta<C0:1PH42
f=SH0YFEU@9WIfL2?Cdm0[fm_@;3`l<2F5QH0YVIV@9IFET2m?Cd0]OGe`9mOGd2?Cdm0P00009UIFD2
00000_;blP9mOGd2a<C41?ooo`:7QhL2ATI60WalO09JFUX2L71`0Y2@T09CDe<2M7Ad0^CTi0;;bl/2
P8200[Rh^0800002QhN70]cLg0:/[:`2WIfM0_ooo`;QhN42410@0T=3@`9GEeL5oooo0@00007oool0
01Goool00`000?ooooooo`02oooo0P0000:VYZH2NGUi0P0000;hn?P2^[Zj0[Vi^@8/;2`2oooo0P00
00;GemL2SHf=0^CTi0;fm_H2jn_[0TA4A0;De=@2YjNW0V9RHP800002oooo0P0000;alO42IfMW0P00
00:WYjL25QHF0Q/K6`:UYJD2U9BD0/W9b@;`l?02cLg=0ZBTY0:e]KD2Q8B40_ooo`8000021`L70SDe
=@9]KFd2Ng]k0YjNWP:<S8`2=CDe0^OWi`8:2PX2N7Qh0_ooo`;lo?`2TI6A0QHF5P800002eMGE0VMW
I`8];Bd2>c/k0UiNGP:9RHT2UiNG0WEeM@9RHV82V9RH0V=SH`03FEUIc<c<c<c<009_Kfl2OWin0Ve]
K@9mOGd200000XV9R@::RXX2NWYj0WinOP820P82A4A40UiNGP;UiND2T92@0RHV9P9aLG4200000Vi^
KP:6QXH2FEUI0XB4Q09HF5P2c/k>0XB4Q0;2`/82lo?c0Shn?P8f=SH20`<30WmoO`9dM7@2Ng]k0YRH
V09LG5`2<30`0P0000;EeMD2Kfm_0UMGE`800002TI6A0ZNWY`:5QHD2Ph>30VUYJ@9eMGD2/k>c0UaL
G0;;bl/2I6AT0[Zj^P8F5QH2kNg]0Xj>SP9:BTX2l_;b0VYZJP:[Zj/2;bl_0U]KF`8c<c<2Y:BT1Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`800002YZJV0WUiN@800002n?Sh0[Zj^P:i^KT2
;2`/0_ooo`800002emOG0Xf=S@;Ti>@2m_Kf0^_[j`94A4@2e=CD0ZNWY`9RHV8200000_ooo`800002
lO7a0VMWI`800002YjNW0QHF5P8K6a/2YJFU0YBDU0;9bLT2l?3`0/g=c@:TY:@2]KFe0XB4Q0;oool2
00000PL71`8e=CD2KFe]0W]kN`:NWYh2S8b<0SDe=@;WinL22PX:0WQhN0;oool2o?cl0Y6AT@8F5QH2
00000]GEe@9WIfL2;Bd]0S/k>`9NGUh2RHV90YNGU`9eMGD2HV9R0YRHV09SHf<00eUIFLc<c<c<c002
Kfm_0WinOP9]KFd2OGem0P0000:9RHT2RXZ:0WYjNP9nOWh20P820TA4A09NGUh2iNGU0Y2@T08V9RH2
LG5a0P00009^KVh2QXJ60UUIF@:4Q8@2F5QH0/k>cP:4Q8@2`/;20_?cl`8n?Sh2=SHf0P<30`9oOgl2
M7Ad0W]kN`:HV9P2G5aL0S0`<0800002eMGE0Vm_K`9GEeL200000Y6AT@:WYjL2QHF50X>3P`9YJFT2
MGEe0[>c/`9LG5`2bl_;0VATI0:j^[X25QHF0^g]k@:>SXh2BTY:0_;blP9ZJVX2Zj^[0Rl_;`9KFe/2
<c<c0ZBTY0Goool100000Oooo`005Oooo`030000oooooooo00;oool2mOGe0UMGE`;0`<02OWin0Vm_
K`:7QhL2KFe]0P00008R8R82hn?S0WemO@:>SXh2Jf][0P00009]KFd2F5QH0VATI09CDe<2nOWi0SHf
=P8l?3`2oooo0[fm_@9XJ6P2d=3@0P0000;oool2DE5A0P0000810@42EeMG0WYjNP:6QXH2>CTi0[:b
/P9ADE42oooo0/S8b095ADD2RXZ:0TE5A@:?Shl2M7Ad0XB4Q0;oool2GUiN0UQHF0;1`L42oooo0VQX
J08K6a/2gmoO0/?3``9JFUX2];Bd0_ooo`9HF5P26QXJ0_ooo`:FUYH2Jf][0ZJVYP8i>CT2VIVI00>g
]kNZZZZZZZX00P00008A4A42NWYj0W5aL@:CTi<2=cLg0X:2PP9hN7P2RXZ:0TM7A`8000024a<C0U5A
D@9[Jf/2;Bd]0P00009hN7P2O7al0VYZJP:][Jd2TI6A0Vi^KP:9RHT2GUiN0TM7A`;9bLT200000Sdm
?@:ATI42`<300[bl_0:i^KT2JVYZ0Zj^[P;IfMT2Kfm_0XR8R0:BTY8200000WinOP92@T82NGUi0V1P
H0;Kfm/2?Shn0Z:RXP9aLG42U9BD0UaLG0:5QHD2HF5Q0Zn_[`:d];@2PH610WYjNP:JVYX2PX:20^KV
iP800004^[Zj0P0000Goool100000Oooo`005Oooo`030000oooooooo00;oool2mOGe0UMGE`;0`<02
OWin0Vm_K`:7QhL2KFe]0P00008R8R82hn?S0WemO@:>SXh2Jf][0P00009]KFd2F5QH0VATI09CDe<2
nOWi0SHf=P8l?3`2oooo0[fm_@9XJ6P2d=3@0P0000;oool2DE5A0P0000810@42EeMG0WYjNP:6QXH2
>CTi0[:b/P9ADE42oooo0/S8b095ADD2RXZ:0TE5A@:?Shl2M7Ad0XB4Q0;oool2GUiN0UQHF0;1`L42
oooo0VQXJ08K6a/2gmoO0/?3``9JFUX2];Bd0_ooo`9HF5P26QXJ0_ooo`:FUYH2Jf][0ZJVYP8i>CT2
VIVI00>g]kNZZZZZZZX00P00008A4A42NWYj0W5aL@:CTi<2=cLg0X:2PP9hN7P2RXZ:0TM7A`800002
4a<C0U5AD@9[Jf/2;Bd]0P00009hN7P2O7al0VYZJP:][Jd2TI6A0Vi^KP:9RHT2GUiN0TM7A`;9bLT2
00000Sdm?@:ATI42`<300[bl_0:i^KT2JVYZ0Zj^[P;IfMT2Kfm_0XR8R0:BTY8200000WinOP92@T82
NGUi0V1PH0;Kfm/2?Shn0Z:RXP9aLG42U9BD0UaLG0:5QHD2HF5Q0Zn_[`:d];@2PH610WYjNP:JVYX2
PX:20^KViP800004^[Zj0P0000Goool100000Oooo`005Oooo`030000oooooooo00;oool2iNGU0P00
009>CTh2LG5a0_ooo`9jNWX2`L710Q0@40:e]KD2alO70_ooo`:NWYh200000/G5a@:c/k<20P820VQX
J08^;Rh2IVIV0V9RHP9jNWX2P8200XN7Q`8B4Q82AdM70UIFEP:CTi<2fm_K0]?Cd`9TI6@2`/;20_oo
o`:1PH4200000_7al@800002;2`/0VQXJ09?Cdl2IFEU0S`l?09SHf<2Kfm_0_clo08L71`2=3@d0U]K
F`;Xj>P2YJFU0VYZJP9DE5@2KFe]0T10@0:>SXh2=cLg0Tm?C`:UYJD200000QlO7`9iNGT2_;bl0ZFU
Y@9=CDd2000000>NWYjc/k>c/k<00TA4A0;oool2AdM70U=CD`800002moOg0Zf][@:0P802QXJ60ZZZ
ZP90@402ATI60/k>cP;2`/82HF5Q0_ooo`9;Bd/2alO70ZVYZ@:9RHT2BDU90ZJVYP8l?3`2Y:BT0Y2@
T098B4P2jNWY0QlO7`8j>SX200000_ooo`9gMgL2SXj>0V9RHP8f=SH2oooo0V5QH@;Bd]82Shn?0[>c
/`9ZJVX2ADE50Zj^[P:LW9`2:b/[0VUYJ@;GemL2IfMW0U5AD@8W9bL2Y:BT0WmoO`:5QHD2M7Ad0W5a
L@:HV9P2HV9R0WYjNP;WinL2Cdm?0V5QH@:f][H5oooo0@00007oool001Goool200000oooo`;UiND2
00000Ti>CP9aLG42oooo0WYjNP;1`L42410@0[Fe]@;7alL2oooo0YjNWP800002aLG50[>c/`820P82
J6QX0Rh^;P9VIVH2HV9R0WYjNP:0P802QhN70Q8B4P97AdL2EUIF0Y>CT`;Kfm/2dm?C0VATI0;2`/82
oooo0X61P@800002lO7a0P00008/;2`2J6QX0Tm?C`9UIFD2?3`l0V=SH`9_Kfl2o?cl0Q`L708d=3@2
Fe]K0^SXj0:UYJD2JVYZ0UADE09]KFd2@4100Xj>SP8g=cL2Cdm?0ZFUY@8000027alO0WUiN@:l_;`2
YJFU0Te=C@8000000ijNW[>c/k>c/`02A4A40_ooo`97AdL2De=C0P0000;gmoL2[Jf]0X20P0:6QXH2
ZZZZ0T10@096ATH2c/k>0/;2`P9QHF42oooo0T];B`;7alL2ZJVY0XV9R@99BDT2YZJV0S`l?0:TY:@2
T92@0TQ8B0;YjNT27alO0SXj>P800002oooo0WMgM`:>SXh2HV9R0SHf=P;oool2HF5Q0];BdP:?Shl2
/k>c0VYZJP95ADD2[Zj^0YbLW08[:b/2JFUY0]OGe`9WIfL2DE5A0RLW9`:TY:@2Ogmo0XF5Q@9dM7@2
LG5a0YRHV09RHV82NWYj0^OWi`9?Cdl2HF5Q0[Jf]PCoool200000Oooo`005Oooo`030000oooooooo
00;oool2MWIf0TU9B@:h^;P21`L70ZNWY`:j^[X2e=CD0[2`/0@000022PX:0P0000;Ti>@2[Jf]0/k>
cP;oool4Q8B40]GEe@;oool200000V][J`:?Shl2SXj>0QDE5@9nOWh2gmoO0PH61P:1PH42:2PX0YVI
V@8[:b/2AdM70Zb/[09hN7P29bLW0ZFUY@9TI6@2:RXZ0Xj>SP;oool2nOWi0UEEE@9^KVh2PX:218n?
S`9[Jf/2KFe]0ZZZZP:UYJD2Ogmo0^c/k08n?Sh2moOg0W]kN`:i^KT2QhN70_ooo`8Y:BT2Cdm?0V=S
H`9?Cdl2bLW900=8B4Rb/[:b/[800WQhN0:MWId2W9bL0YBDU0:h^;P2RXZ:0[Ng]`;;bl/2ATI60YVI
V@:5QHD2@4100YbLW08F5QH2clo?0]_Kf`9iNGT2IFEU0V1PH09aLG42GUiN0/K6aP:4Q8@2Bd];0S@d
=09RHV82oooo0W1`L0:8R8P200000_ooo`9dM7@2PX:20V9RHP:`/;02@T920W1`L09VIVH4NGUi0V9R
HP9ZJVX2N7Qh0VEUI@:>SXh2Hf=S0UIFEP:TY:@2GUiN0_ooo`9lO7`2HV9R0P00009lO7`2PX:20WIf
MP9cLg<2^KVi0TM7A`:@T902FEUI0Y:BTPGoool100000Oooo`005Oooo`030000oooooooo00;oool2
MWIf0TU9B@:h^;P21`L70ZNWY`:j^[X2e=CD0[2`/0@000022PX:0P0000;Ti>@2[Jf]0/k>cP;oool4
Q8B40]GEe@;oool200000V][J`:?Shl2SXj>0QDE5@9nOWh2gmoO0PH61P:1PH42:2PX0YVIV@8[:b/2
AdM70Zb/[09hN7P29bLW0ZFUY@9TI6@2:RXZ0Xj>SP;oool2nOWi0UEEE@9^KVh2PX:218n?S`9[Jf/2
KFe]0ZZZZP:UYJD2Ogmo0^c/k08n?Sh2moOg0W]kN`:i^KT2QhN70_ooo`8Y:BT2Cdm?0V=SH`9?Cdl2
bLW900=8B4Rb/[:b/[800WQhN0:MWId2W9bL0YBDU0:h^;P2RXZ:0[Ng]`;;bl/2ATI60YVIV@:5QHD2
@4100YbLW08F5QH2clo?0]_Kf`9iNGT2IFEU0V1PH09aLG42GUiN0/K6aP:4Q8@2Bd];0S@d=09RHV82
oooo0W1`L0:8R8P200000_ooo`9dM7@2PX:20V9RHP:`/;02@T920W1`L09VIVH4NGUi0V9RHP9ZJVX2
N7Qh0VEUI@:>SXh2Hf=S0UIFEP:TY:@2GUiN0_ooo`9lO7`2HV9R0P00009lO7`2PX:20WIfMP9cLg<2
^KVi0TM7A`:@T902FEUI0Y:BTPGoool100000Oooo`005Oooo`030000oooooooo00;oool2QXJ60TQ8
B0:1PH42TI6A0WUiN@9_Kfl2JVYZ0XJ6QP;GemL2^;Rh0YFEU@:TY:@2SHf=0Xb<S09cLg<2Hf=S0W]k
N`9gMgL2LG5a0U1@D0:WYjL2OGem0WUiN@:1PH42dM7A0ZJVYP8;2`/2VYZJ0P00009/K6`2QHF50Xf=
S@9KFe/2NGUi0WAdM0:IVIT2NGUi0VQXJ0:GUiL2?Shn0WAdM09eMGD2QHF50XB4Q09dM7@2MWIf0WEe
M@:3Ph<2PH610W1`L09cLg<2][Jf0VQXJ0:>SXh2FUYJ0WMgM`AaLG42G5aL0Xb<S09gMgL2QHF50VMW
I`:KVi/00hF5QGEeMGEeM@02O7al0WinOP9dM7@2N7Qh0WIfMP9gMgL4P8200WalO09VIVH2J6QX0WIf
MP:EUID2oooo0Xj>SP:<S8`2TI6A0X>3P`9iNGT2PX:20XB4Q09/K6`2LG5a0WalO09_Kfl2W9bL0WAd
M0:a/K42Bd];0Y>CT`9SHf<2QhN70WEeM@9lO7`2Jf][0X^;R`9lO7`2PX:20WinOP9mOGd2P8200Wem
O@9oOgl2P8200WIfMP9nOWh2R8R80Vm_K`:3Ph<2NGUi0X61P@:6QXH2Shn?0WmoO`:0P802O7al0Win
OP9[Jf/2Shn?0WEeM@:1PH42NGUi1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`:6QXH2
B4Q80X61P@:ATI42NGUi0Vm_K`9ZJVX2QXJ60]OGe`:h^;P2UIFE0ZBTY0:=SHd2S8b<0W=cL`9SHf<2
Ng]k0WMgM`9aLG42D51@0ZNWY`9mOGd2NGUi0X61P@;AdM42YZJV0P/;2`:JVYX200000Va/K0:5QHD2
SHf=0U]KF`9iNGT2M7Ad0YVIV@9iNGT2J6QX0YNGU`8n?Sh2M7Ad0WEeM@:5QHD2Q8B40WAdM09fMWH2
MGEe0X>3P`:1PH42L71`0W=cL`:f][H2J6QX0Xj>SP9JFUX2MgMg175aL@9LG5`2S8b<0WMgM`:5QHD2
IfMW0Y^KV`03QHF5MGEeMGEe009lO7`2OWin0WAdM09hN7P2MWIf0WMgM`B0P802O7al0VIVIP9XJ6P2
MWIf0YFEU@;oool2SXj>0Xb<S0:ATI42Ph>30WUiN@:2PX82Q8B40Va/K09aLG42O7al0Vm_K`:LW9`2
M7Ad0[6a/@9;Bd/2Ti>C0V=SH`:7QhL2MGEe0WalO09[Jf/2Rh^;0WalO0:2PX82OWin0WemO@:0P802
OGem0WmoO`:0P802MWIf0WinOP:8R8P2Kfm_0X>3P`9iNGT2PH610XJ6QP:?Shl2Ogmo0X20P09lO7`2
OWin0V][J`:?Shl2MGEe0X61P@9iNGT5oooo0@00007oool001Goool00`000?ooooooo`02oooo0[6a
/@:l_;`2Jf][0WIfMP9kNg/2OWin0X:2PP9kNg/2EeMG0V=SH`9]KFd2LG5a0WEeM@:PX:02oooo0V5Q
H@9kNg/2Ogmo0X:2PP:<S8`2JVYZ0W]kN`9nOWh2O7al0WEeM@9;Bd/2LG5a0QdM7@800002MGEe0WAd
M09gMgL2:b/[0^k^kP:MWId2KVi^0U]KF`:9RHT2]kNg0UQHF08k>c/2Shn?0WEeM@9iNGT2Ogmo0Wem
O@9nOWh2NWYj0WUiN@B0P802M7Ad0XF5Q@9eMGD2RHV91WinOP:9RHT2MWIf0WYjNP9iNGT2R8R80XV9
R@03N7QhOGemOGem009lO7`2Ng]k0WmoO`9nOWh2P8200WalO09mOGd2Ogmo0WMgM`:6QXH2De=C0UmO
G`:c/k<2TI6A0T=3@`:d];@2Q8B40WEeM@;;bl/2FUYJ0WAdM0:5QHD2V9RH0YnOW`9PH602TY:B0VYZ
JP:`/;02EUIF18>3P`9kNg/2OGem0WalO0:2PX82MWIf0W]kN`9iNGT6Ng]k0WalO0AkNg/2OWin0W]k
N`9hN7P2P8200WUiN@:3Ph<2NWYj0WUiN@9bLW84Ng]k0WalO09kNg/2Ph>30WEeM@9nOWh2Ng]k0Wem
O@Goool100000Oooo`005Oooo`030000oooooooo00;oool2/K6a0[bl_09[Jf/2MWIf0W]kN`9nOWh2
PX:20W]kN`9GEeL2Hf=S0Ve]K@9aLG42MGEe0Z2PX0;oool2HF5Q0W]kN`9oOgl2PX:20Xb<S09ZJVX2
Ng]k0WinOP9lO7`2MGEe0T];B`9aLG427AdM0P00009eMGD2M7Ad0WMgM`8[:b/2k^k^0YfMW@9^KVh2
Fe]K0XV9R@:g]kL2F5QH0S/k>`:?Shl2MGEe0WUiN@9oOgl2OGem0WinOP9jNWX2NGUi1820P09dM7@2
QHF50WEeM@:9RHT6OWin0XV9R@9fMWH2NWYj0WUiN@:8R8P2RHV900=hN7QmOGemOGd00WalO09kNg/2
Ogmo0WinOP:0P802O7al0WemO@9oOgl2MgMg0XJ6QP9CDe<2GemO0[>c/`:ATI42@d=30[Bd]0:4Q8@2
MGEe0/_;b`9JFUX2M7Ad0XF5Q@:HV9P2WinO0V1PH0:BTY82JVYZ0[2`/09FEUH4Ph>30W]kN`9mOGd2
O7al0X:2PP9fMWH2Ng]k0WUiN@IkNg/2O7al17]kN`9nOWh2Ng]k0WQhN0:0P802NGUi0X>3P`9jNWX2
NGUi0W9bLPAkNg/2O7al0W]kN`:3Ph<2MGEe0WinOP9kNg/2OGem1Oooo`400001oooo000Eoooo00<0
003oooooool00_ooo`:o_kl2/;2`0W]kN`9oOgl4O7al0WUiN@9jNWX2QhN70XB4Q0:0P802PX:20WIf
MP;4a<@29RHV0[2`/0AkNg/2NWYj0WIfMP:1PH42O7al0W]kN`9/K6`2B4Q80P0000;Vi^H2lo?c0Sdm
?@9VIVH2MWIf0X20P09_Kfl2Shn?0YFEU@8Q8B42YJFU0YBDU09YJFT2oooo0S4a<@9hN7P2NGUi0Wmo
O`9jNWX2O7al0W]kN`9lO7`2OGem17YjNP9oOgl2N7Qh0WinOP9hN7P6Ng]k0WQhN09mOGd2Ogmo0WEe
M@:IVIT210@400=mOGekNg]kNg/00W]kN`9lO7`4Ng]k0WYjNP9lO7`4Ng]k0WemO@9eMGD2LW9b0ZFU
Y@9/K6`2ATI60Te=C@:;Rh/2/[:b0XB4Q0;oool2PX:20YBDU09cLg<2MgMg0/?3``:<S8`2EeMG0ZRX
Z09XJ6P200000X^;R`9_Kfl2P8200WYjNP9lO7`2NWYj0WinOP9lO7`2OGem37alO09kNg/2O7al0Wem
O@9kNg/2OGem0WUiN@9lO7`2OGem0WmoO`QlO7`2NWYj0WinOP9kNg/2O7al0W]kN`Goool100000Ooo
o`005Oooo`030000oooooooo00;oool2_kno0[2`/09kNg/2Ogmo17alO09iNGT2NWYj0XN7Q`:4Q8@2
P8200X:2PP9fMWH2a<C40RHV9P:`/;04Ng]k0WYjNP9fMWH2PH610WalO09kNg/2K6a/0TQ8B0800002
i^KV0_?cl`8m?Cd2IVIV0WIfMP:0P802Kfm_0Xn?S`:EUID28B4Q0ZFUY@:DU9@2JFUY0_ooo`8a<C42
N7Qh0WUiN@9oOgl2NWYj0WalO09kNg/2O7al0WemO@AjNWX2Ogmo0WQhN09nOWh2N7Qh1W]kN`9hN7P2
OGem0WmoO`9eMGD2VIVI0P@41003OGemNg]kNg]k009kNg/2O7al17]kN`9jNWX2O7al17]kN`9mOGd2
MGEe0W9bLP:UYJD2K6a/0TI6AP9=CDd2Rh^;0[:b/P:4Q8@2oooo0X:2PP:DU9@2Lg=c0WMgM`;3`l<2
S8b<0UMGE`:XZ:P2J6QX0P0000:;Rh/2Kfm_0X20P09jNWX2O7al0WYjNP9nOWh2O7al0WemO@alO7`2
Ng]k0WalO09mOGd2Ng]k0WemO@9iNGT2O7al0WemO@9oOgl8O7al0WYjNP9nOWh2Ng]k0WalO09kNg/5
oooo0@00007oool001Goool00`000?ooooooo`04oooo0YFEU@9aLG42OGem17alO0AmOGd2NGUi0W]k
N`9gMgL2Ph>30VQXJ0Coool21@D50W]kN`9lO7`2OGem0WinOP9jNWX2Ng]k0X61P@9]KFd2UiNG0QhN
7P98B4P2F5QH0Slo?`9QHF42PX:20W]kN`;Lg=`2Vi^K0S/k>`:6QXH26ATI0X>3P`9`L702EUIF0X^;
R`:9RHT4Ng]k3WalO09kNg/2O7al0W]kN`9mOGd6O7al0WemO@9kNg/4O7al17inOQ=lO7`2Ng]k0Wem
O@9/K6`2RXZ:0YJFUP9gMgL2_;bl0^k^kP9UIFD2QHF50Zb/[0:KVi/2MWIf0W5aL@;;bl/2NGUi0XJ6
QP8l?3`2TI6A0Xj>SP;Rh^82M7Ad0X:2PP9iNGT2OGem17alO09kNg/DO7al0W]kN`QlO7`4Ng]k2Wal
O09kNg/6O7al1Oooo`400001oooo000Eoooo0P0000Goool2UIFE0W5aL@9mOGd4O7al17emO@9iNGT2
Ng]k0WMgM`:3Ph<2J6QX1?ooo`851@D2Ng]k0WalO09mOGd2OWin0WYjNP9kNg/2PH610Ve]K@:GUiL2
7QhN0TQ8B09HF5P2?clo0V5QH@:2PX82Ng]k0]cLg0:KVi/2>c/k0XJ6QP8I6AT2Ph>30W1`L09FEUH2
Rh^;0XV9R@AkNg/>O7al0W]kN`9lO7`2Ng]k0WemO@IlO7`2OGem0W]kN`AlO7`4OWin4galO09kNg/2
OGem0Va/K0::RXX2UYJF0WMgM`:l_;`2k^k^0VEUI@:5QHD2[:b/0Y^KV`9fMWH2LG5a0/_;b`9iNGT2
QXJ60S`l?0:ATI42SXj>0^;RhP9dM7@2PX:20WUiN@9mOGd4O7al0W]kNaAlO7`2Ng]k27alO0AkNg/:
O7al0W]kN`IlO7`4oooo0P00007oool001Goool00`000?ooooooo`02oooo0P000099BDT2PH610WYj
NP9mOGd4O7al17YjNP9oOgl2O7al0WinOP:1PH42BDU9100000AlO7`4Ng]k17alO09mOGd2PH610]oO
g`;oool2Q8B40[Vi^@9nOWh2K6a/0WemO@9kNg/2ZJVY0XV9R@9^KVh2>SXj0_ooo`;dm?@2I6AT0R@T
909?Cdl2OGem0WYjNPYlO7`4Ng]k17alO09mOGd2OWin0WalO0AkNg/2OGem0W]kN`9lO7`2NGUi0XB4
Q091@D42`/;200=kNg]lO7alO7`03WalO09kNg/2P8200WAdM0;EeMD2@T920YfMW@:FUYH251@D0ZNW
Y`:6QXH2MGEe0WMgM`:QXJ42HV9R0V=SH`9VIVH2/[:b0WMgM`9bLW82:b/[0T];B`8Z:RX2S8b<0WIf
MP9nOWh2Ng]k0WalO09kNg/:O7al0W]kNaQlO7`2NWYj0W]kN`9jNWX2Ng]k17emO@AkNg/2O7al1Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`800002BDU90X61P@9jNWX2OGem17alO0AjNWX2
Ogmo0WalO09nOWh2PH610TU9B@@00004O7al17]kN`AlO7`2OGem0X61P@;Ogml2oooo0XB4Q0:i^KT2
OWin0Va/K09mOGd2Ng]k0ZVYZ@:9RHT2KVi^0SXj>P;oool2m?Cd0VATI08T92@2Cdm?0WemO@9jNWX:
O7al17]kN`AlO7`2OGem0WinOP9lO7`4Ng]k0WemO@9kNg/2O7al0WUiN@:4Q8@2@D510/;2`P03Ng]k
O7alO7al00ilO7`2Ng]k0X20P09dM7@2eMGE0T92@P:MWId2UYJF0Q@D50:WYjL2QXJ60WEeM@9gMgL2
XJ6Q0V9RHP9SHf<2IVIV0[:b/P9gMgL2LW9b0R/[:`9;Bd/2:RXZ0Xb<S09fMWH2OWin0W]kN`9lO7`2
Ng]k2WalO09kNg/HO7al0WYjNP9kNg/2NWYj0W]kN`AmOGd4Ng]k0WalO0Goool100000Oooo`005Ooo
o`030000oooooooo00;oool2;Bd]0YJFUP9fMWH2Ogmo0WemO@9oOgl2O7al0WmoO`9lO7`2LW9b0WIf
MP9bLW82S8b<0TE5A@:;Rh/2MWIf0W]kN`9lO7`2OWin0X20P09hN7P2NWYj0WinOP9oOgl2FEUI0]?C
d`99BDT2>c/k0W=cL`:NWYh2MGEe0WYjNP9iNGT2@T920X:2PP9VIVH2VYZJ0W1`L0:_[jl2JVYZ0YBD
U09hN7P2Ogmo1W]kN`AlO7`2OGem0WinOP9jNWX2OGem0WEeM@9`L702Ng]k0X20P09nOWh2NGUi0Wem
O@9kNg/2PX:20WQhN0:5QHD2IfMW00>1PH5lO7alO7`017YjNP9kNg/2O7al0WUiN@AlO7`4NWYj0W]k
N`9fMWH2P8200XJ6QP:1PH42Ogmo0UMGE`9OGel2NWYj0W=cL`:2PX84UYJF0XJ6QP9`L702YjNW0Vm_
K`9eMGD2LW9b0YFEU@9iNGT2Ogmo0WYjNP9nOWh2O7al0WinOP9jNWX6O7al0W]kN`9nOWh6O7al17]k
N`9jNWX2O7al0W]kN`9jNWX2Ng]k0WemO@9jNWX2OGem0X61P@:5QHD2NWYj0X61P@9iNGT2O7al0X20
P09kNg/5oooo0@00007oool001Goool00`000?ooooooo`02oooo0Rd];@:FUYH2MWIf0WmoO`9mOGd2
Ogmo0WalO09oOgl2O7al0W9bLP9fMWH2LW9b0Xb<S095ADD2Rh^;0WIfMP9kNg/2O7al0WinOP:0P802
N7Qh0WYjNP9nOWh2Ogmo0UUIF@;Cdm<2BDU90S/k>`9cLg<2WYjN0WEeM@9jNWX2NGUi0T92@P:2PX82
IVIV0YZJVP9`L702[jn_0VYZJP:DU9@2N7Qh0WmoO`IkNg/4O7al0WemO@9nOWh2NWYj0WemO@9eMGD2
L71`0W]kN`:0P802OWin0WUiN@9mOGd2Ng]k0X:2PP9hN7P2QHF50VMWI`03PH61O7alO7al00AjNWX2
Ng]k0WalO09iNGT4O7al17YjNP9kNg/2MWIf0X20P0:6QXH2PH610WmoO`9GEeL2GemO0WYjNP9cLg<2
PX:219JFUP:6QXH2L71`0ZNWY`9_Kfl2MGEe0W9bLP:EUID2NGUi0WmoO`9jNWX2OWin0WalO09nOWh2
NWYj1WalO09kNg/2OWin1WalO0AkNg/2NWYj0WalO09kNg/2NWYj0W]kN`9mOGd2NWYj0WemO@:1PH42
QHF50WYjNP:1PH42NGUi0WalO0:0P802Ng]k1Oooo`400001oooo000Eoooo00<0003oooooool00_oo
o`:@T902O7al0]3@d09<C4`2WIfM0Y>CT`9fMWH2][Jf0P00008C4a<2>CTi0WUiN@;0`<02Shn?0_oo
o`9WIfL2S8b<0Tm?C`91@D42ZJVY0RDU9@9QHF42_;bl0V=SH`:][Jd2@T920_ooo`8e=CD2;bl_0_oo
o`9iNGT2LW9b0[Bd]0;oool200000R4Q8@:l_;`2PX:20WalO09aLG42^;Rh0Xj>SP:SXj<2UIFE0XR8
R0:5QHD2N7Qh0XR8R0:=SHd2IVIV0TY:BP:_[jl2mOGe0Y6AT@:RXZ82OWin0Y^KV`9;Bd/2g=cL0TM7
A`8K6a/2Ng]k0UQHF08[:b/00fEUIInOWinOW`02GemO0[Rh^09kNg/2Rh^;0[jn_P:8R8P2fMWI0^;R
hP800002;Rh^0Y>CT`9/K6`2[Zj^0QXJ6P:KVi/2>CTi0YfMW@9^KVh2@T920X>3P`8M7Ad2fMWI0RDU
9@:4Q8@28B4Q0WQhN09^KVh2NWYj0UMGE`:c/k<2_Kfm0/?3``9BDU82IVIV0X:2PP9MGEd2OWin0W1`
L0:1PH42Ph>30W=cL`9dM7@2P8200WinOP9cLg<2M7Ad0XF5Q@:FUYH2Xj>S0_ooo`;2`/82_[jn0[6a
/@:FUYH2/K6a0W5aL@9hN7P2UYJF0W1`L09iNGT2K6a/0X20P0Goool100000Oooo`005Oooo`030000
oooooooo00;oool2T92@0WalO0;@d=02C4a<0YfMW@:CTi<2MWIf0[Jf]P8000024a<C0STi>@9iNGT2
`<300Xn?S`;oool2IfMW0Xb<S09?Cdl2@D510ZVYZ@8U9BD2HF5Q0[bl_09SHf<2[Jf]0T92@P;oool2
=CDe0Rl_;`;oool2NGUi0W9bLP:d];@2oooo0P00008Q8B42_;bl0X:2PP9lO7`2LG5a0[Rh^0:>SXh2
Xj>S0YFEU@:8R8P2QHF50WQhN0:8R8P2SHf=0VIVIP9:BTX2[jn_0_Gem@:ATI42XZ:R0WinOP:KVi/2
Bd];0]cLg097AdL26a/K0W]kN`9HF5P2:b/[00=UIFFOWinOWil00UmOG`:h^;P2Ng]k0X^;R`:n_[h2
R8R80]WIf@;Rh^8200000Rh^;P:CTi<2K6a/0Zj^[P8J6QX2Vi^K0STi>@:MWId2KVi^0T92@P:3Ph<2
7AdM0]WIf@8U9BD2Q8B40R4Q8@9hN7P2KVi^0WYjNP9GEeL2/k>c0[fm_@;3`l<2DU9B0VIVIP:2PX82
GEeM0WinOP9`L702PH610X>3P`9cLg<2M7Ad0X20P09nOWh2Lg=c0WAdM0:5QHD2UYJF0Z>SX`;oool2
`/;20[jn_P:a/K42UYJF0[6a/@9aLG42N7Qh0YJFUP9`L702NGUi0Va/K0:0P805oooo0@00007oool0
01Goool00`000?ooooooo`02oooo0TY:BP8P8202K6a/0YNGU`9`L702Kfm_0ZJVYP:0P802a<C40[Rh
^0:7QhL2V9RH0Ta<C0:[Zj/2Lg=c0Vi^KP9fMWH2UYJF0V][J`9XJ6P2ZJVY0WmoO`9mOGd2FUYJ0R<S
8`800002820P0XB4Q0:MWId2O7al0VMWI`:2PX82i^KV0Xj>SP8T92@2a<C40W9bLP:WYjL2oooo0Q0@
4098B4P2W9bL0XN7Q`9mOGd2OWin0WemO@9kNg/2NWYj0WIfMP:4Q8@2SXj>0QHF5P:?Shl2RHV90VMW
I`9mOGd2KFe]0XN7Q`9WIfL2S8b<0XV9R@9eMGD2clo?0RDU9@03Q8B4L71`L71`009oOgl2KFe]0WUi
N@9lO7`2Ng]k0WAdM09QHF42CDe=0WmoO`9`L704Y:BT0[:b/P:PX:02ZZZZ0Q4A4@:<S8`2RHV90Xb<
S09fMWH2Ph>316m_K`:d];@2L71`0PT92@8E5AD2Rh^;0/k>cP8X:2P2CTi>0VQXJ0:0P802OGem0WIf
MP9mOGd2P82017]kN`9jNWX2P8200X61P@9jNWX2OWin0WemO@:1PH42Ng]k0VATI09lO7`2E5AD0S/k
>`8B4Q82c/k>0WQhN0:0P802NGUi0X20P09^KVh2PH610W]kN`:3Ph<2LW9b1Oooo`400001oooo000E
oooo00<0003oooooool00_ooo`9:BTX2820P0Va/K0:GUiL2L71`0Vm_K`:VYZH2P8200/C4a0:h^;P2
QhN70YRHV09<C4`2Zj^[0W=cL`9^KVh2MWIf0YJFUP9[Jf/2J6QX0ZVYZ@9oOgl2OGem0UYJFP8S8b<2
00000R0P80:4Q8@2WIfM0WalO09WIfL2PX:20^KViP:>SXh292@T0/C4a09bLW82YjNW0_ooo`8@4102
B4Q80YbLW0:7QhL2OGem0WinOP9mOGd2Ng]k0WYjNP9fMWH2Q8B40Xj>SP8F5QH2Shn?0XV9R@9WIfL2
OGem0Ve]K@:7QhL2IfMW0Xb<S0:9RHT2MGEe0/o?c`8U9BD00hB4Q71`L71`L002Ogmo0Ve]K@9iNGT2
O7al0W]kN`9dM7@2HF5Q0Te=C@9oOgl2L71`1:BTY0:b/[82X:2P0ZZZZP8A4A42S8b<0XV9R@:<S8`2
MWIf0X>3P`A_Kfl2];Bd0W1`L0892@T25ADE0X^;R`;>c/h2:2PX0Ti>CP9XJ6P2P8200WemO@9fMWH2
OGem0X20P0AkNg/2NWYj0X20P0:1PH42NWYj0WinOP9mOGd2PH610W]kN`9TI6@2O7al0UADE08k>c/2
4Q8B0/k>cP9hN7P2P8200WUiN@:0P802KVi^0X61P@9kNg/2Ph>30W9bLPGoool100000Oooo`005Ooo
o`030000oooooooo00;oool2L71`0T=3@`:6QXH2LG5a0X61P@9nOWh2Rh^;0WmoO`9WIfL2JVYZ0WIf
MP9_Kfl2Vi^K0S/k>`9ADE42QHF50WalO0:3Ph<2Shn?0X:2PP9_Kfl4Ng]k0XF5Q@9?Cdl2KVi^0Xj>
SP9iNGT2Jf][0WEeM@:8R8P2MWIf0W9bLP:n_[h2OWin0Ve]K@:2PX82MgMg0VEUI@95ADD2h>3P0Xn?
S`9lO7`4Ng]k17alO09mOGd2NGUi18B4Q0:NWYh2RHV90WUiN@:2PX82Ng]k0X20P09iNGT2QHF50WIf
MP9eMGD2N7Qh0W]kN`9XJ6P00gQhN820P820P002Ng]k0X61P@AmOGd2PH610WalO0:4Q8@2QhN70WAd
M09fMWH2KFe]0UeMG@;oool2QXJ60_ooo`9oOgl2QhN70WAdM09fMWH2O7al0WMgM`:2PX82NWYj0WAd
M09`L702LW9b0[>c/`99BDT2Bd];0T=3@`:QXJ42NGUi0WalO09iNGT2OWin17YjNPIlO7`4NWYj0Wem
O@9kNg/2O7al17YjNP9kNg/2MgMg0Xj>SP9[Jf/2HF5Q0WEeM@9kNg/2Ogmo17]kN`:0P802Ng]k0Wal
O09jNWX2OWin1Oooo`400001oooo000Eoooo0P0000?oool2L71`0T=3@`:6QXH2LG5a0X61P@9nOWh2
Rh^;0WmoO`9WIfL2JVYZ0WIfMP9_Kfl2Vi^K0S/k>`9ADE42QHF50WalO0:3Ph<2Shn?0X:2PP9_Kfl4
Ng]k0XF5Q@9?Cdl2KVi^0Xj>SP9iNGT2Jf][0WEeM@:8R8P2MWIf0W9bLP:n_[h2OWin0Ve]K@:2PX82
MgMg0VEUI@95ADD2h>3P0Xn?S`9lO7`4Ng]k17alO09mOGd2NGUi18B4Q0:NWYh2RHV90WUiN@:2PX82
Ng]k0X20P09iNGT2QHF50WIfMP9eMGD2N7Qh0W]kN`9XJ6P00gQhN820P820P002Ng]k0X61P@AmOGd2
PH610WalO0:4Q8@2QhN70WAdM09fMWH2KFe]0UeMG@;oool2QXJ60_ooo`9oOgl2QhN70WAdM09fMWH2
O7al0WMgM`:2PX82NWYj0WAdM09`L702LW9b0[>c/`99BDT2Bd];0T=3@`:QXJ42NGUi0WalO09iNGT2
OWin17YjNPIlO7`4NWYj0WemO@9kNg/2O7al17YjNP9kNg/2MgMg0Xj>SP9[Jf/2HF5Q0WEeM@9kNg/2
Ogmo17]kN`:0P802Ng]k0WalO09jNWX2OWin1?ooo`800001oooo000Eoooo00<0003oooooool00_oo
o`9ADE42J6QX0X61P@9mOGd6Ng]k0WYjNP:2PX82PH610WmoO`9mOGd2M7Ad0W]kN`:g]kL2PH610Wal
O09kNg/2N7Qh0WYjNP9oOgl2O7al0W]kN`9iNGT2H61P0TE5A@9@D502Jf][0]_Kf`9mOGd4O7al0/K6
aP:f][H2GUiN0ZJVYP9ZJVX2Shn?0U]KF`:ATI42Ogmo0WAdM09mOGd<O7al17]kN`9aLG42NGUi0Wal
O09jNWX2O7al0W]kN`9mOGd2NGUi0WemO@9oOgl2Ng]k0XJ6QP9QHF400gemOG]kNg]kN`02O7al0WYj
NPAkNg/2NGUi0WalO09hN7P2MgMg1WinOP:4Q8@2OGem0R@T90:SXj<2IVIV0Xn?S`:0P802WinO0VUY
J@9lO7`2NWYj0WemO@B2PX82MgMg0T51@@9JFUX2QhN70WalO09eMGD2Ng]k0WalO09mOGd2Ng]k0Wem
OAYlO7`2MGEe17]kN`:0P804Ng]k17alO09kNg/6O7al0W]kN`Goool100000Oooo`005Oooo`030000
oooooooo00;oool2DE5A0VQXJ0:1PH42OGem1W]kN`9jNWX2PX:20X61P@9oOgl2OGem0WAdM09kNg/2
]kNg0X61P@9lO7`2Ng]k0WQhN09jNWX2Ogmo0WalO09kNg/2NGUi0V1PH095ADD2D51@0V][J`;Kfm/2
OGem17alO0;6a/H2][Jf0UiNGP:VYZH2JVYZ0Xn?S`9KFe/2TI6A0WmoO`9dM7@2OGem37alO0AkNg/2
LG5a0WUiN@9lO7`2NWYj0WalO09kNg/2OGem0WUiN@9mOGd2Ogmo0W]kN`:6QXH2HF5Q00=mOGekNg]k
Ng/00WalO09jNWX4Ng]k0WUiN@9lO7`2N7Qh0WMgM`InOWh2Q8B40WemO@8T92@2Xj>S0VIVIP:?Shl2
P8200YnOW`9YJFT2O7al0WYjNP9mOGd4PX:20WMgM`91@D42FUYJ0XN7Q`9lO7`2MGEe0W]kN`9lO7`2
OGem0W]kN`9mOGdJO7al0WEeM@AkNg/2P82017]kN`AlO7`2Ng]k1WalO09kNg/5oooo0@00007oool0
01Goool00`000?ooooooo`02oooo0]KFeP:RXZ82MGEe0WemO@QlO7`4Ng]k0WYjNP:0P802KVi^0YVI
V@8[:b/27AdM0W]kN`9lO7`2OGem0WalO09kNg/4O7al0WUiN@9hN7P23`l?0_ooo`:CTi<2?Cdm17Yj
NP9mOGd2SXj>0/o?c`9KFe/2Jf][0Zj^[P9gMgL2d=3@0];BdP:6QXH2P8200W]kNa1lO7`2P82037al
O09mOGd6Ng]k0X61P@9/K6`00g]kNgalO7alO008O7al0WemO@9lO7`4OGem17]kN`9oOgl2U9BD0Va/
K09PH602`L710Te=C@9QHF42EUIF0YfMW@9<C4`2GUiN0WMgM`9eMGD2U9BD0XV9R@:<S8`2EEEE0TQ8
B0:ATI42M7Ad0X20P2AlO7`2OWin17alO09kNg/BO7al1Oooo`400001oooo000Eoooo00<0003ooooo
ool00_ooo`;Fe]H2XZ:R0WEeM@9mOGd8O7al17]kN`9jNWX2P8200Vi^KP:IVIT2:b/[0QdM7@9kNg/2
O7al0WemO@9lO7`2Ng]k17alO09iNGT2N7Qh0Pl?3`;oool2Ti>C0Sdm?@AjNWX2OGem0Xj>SP;?cll2
Fe]K0V][J`:^[Zh2MgMg0]3@d0;Bd]82QXJ60X20P09kNg/@O7al0X20P0alO7`2OGem1W]kN`:1PH42
K6a/00=kNg]lO7alO7`027alO09mOGd2O7al17emO@AkNg/2Ogmo0YBDU09/K6`2H61P0/71`@9=CDd2
HF5Q0UIFEP:MWId2C4a<0UiNGP9gMgL2MGEe0YBDU0:9RHT2S8b<0UEEE@98B4P2TI6A0WAdM0:0P80T
O7al0WinOPAlO7`2Ng]k4WalO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2F5QH0[Ng
]`9gMgL2OWin0W]kN`YlO7`2NWYj0X20P09aLG42UiNG0U]KF`;]kNd2Ng]k0WalO09kNg/6O7al0Wem
O@9jNWX2Xj>S0VATI09jNWX2n?Sh0YfMW@:VYZH2M7Ad0WmoO`:f][H2g=cL0[Vi^@8i>CT2d];B0[bl
_09aLG42Ph>30Z2PX09bLW82Ogmo0W]kN`ilO7`2NWYj4WalO09oOgl2PX:20]CDe0mlO7`2Ng]k0Wal
O09jNWX2Q8B40U]KF`;Hf=P2B4Q80WYjNP800002^KVi0Tm?C`9@D502ZJVY0VYZJP9aLG42K6a/0Ve]
K@;oool2[Jf]0V][J`:DU9@2L71`0X20P09fMWH2OGem0W]kNb9lO7`2Ng]k67alO0Goool100000Ooo
o`005Oooo`030000oooooooo00;oool2F5QH0[Ng]`9gMgL2OWin0W]kN`YlO7`2NWYj0X20P09aLG42
UiNG0U]KF`;]kNd2Ng]k0WalO09kNg/6O7al0WemO@9jNWX2Xj>S0VATI09jNWX2n?Sh0YfMW@:VYZH2
M7Ad0WmoO`:f][H2g=cL0[Vi^@8i>CT2d];B0[bl_09aLG42Ph>30Z2PX09bLW82Ogmo0W]kN`ilO7`2
NWYj4WalO09oOgl2PX:20]CDe0mlO7`2Ng]k0WalO09jNWX2Q8B40U]KF`;Hf=P2B4Q80WYjNP800002
^KVi0Tm?C`9@D502ZJVY0VYZJP9aLG42K6a/0Ve]K@;oool2[Jf]0V][J`:DU9@2L71`0X20P09fMWH2
OGem0W]kNb9lO7`2Ng]k67alO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2MgMg0Ve]
K@:2PX82NWYj4WalO0:<S8`29BDU0P0000ilO7`2N7Qh0W1`L0:4Q8@2g=cL0UUIF@:ZZZX2Jf][0Win
OP9kNg/2YjNW0]7Ad@9iNGT2@D510TU9B@93@d<2UIFE0WUiN@9RHV82NWYj0W]kNbAlO7`2NWYj0W5a
L@91@D4AO7al0W]kN`9oOgl2LW9b0[fm_@:KVi/2L71`0ZFUY@8];Bd2`/;20/C4a09MGEd2Ph>30VIV
IP:<S8`2j^[Z0R8R8P8H61P2K6a/0Xn?S`9^KVh2RHV90TE5A@:3Ph<2N7Qh0WemO@9kNg/jO7al1Ooo
o`400001oooo000:oooo0`0000;oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`9gMgL2
KFe]0X:2PP9jNWXBO7al0Xb<S08U9BD200003WalO09hN7P2L71`0XB4Q0;Lg=`2FEUI0ZZZZP9[Jf/2
OWin0W]kN`:WYjL2dM7A0WUiN@91@D42BDU90T=3@`:EUID2NGUi0V9RHP9jNWX2Ng]k97alO09jNWX2
LG5a0T51@A5lO7`2Ng]k0WmoO`9bLW82_Kfm0Y^KV`9`L702YJFU0Rd];@;2`/82a<C40UeMG@:3Ph<2
IVIV0Xb<S0;Zj^X28R8R0QPH609/K6`2Shn?0Vi^KP:9RHT2ADE50X>3P`9hN7P2OGem0W]kNcYlO7`5
oooo0@00007oool000_oool01P000?ooooooo`000?ooo`0000Coool00`000?ooooooo`04oooo0Z:R
XP9fMWH2OGem2WalO09kNg/2OWin0WAdM0:NWYh2[Jf]0_Cdm0;oool2Ng]k2WalO09jNWX2LW9b0S@d
=0;0`<02=CDe0WAdM08l?3`2Lg=c0W]kN`9mOGd2JVYZ0X61P@;oool2YJFU0_ooo`:IVIT2FUYJ0[Bd
]09gMgL2P8200W]kNb1lO7`2Ng]k0WmoO`9eMGD2/k>c0UaLG0mlO7`2Ng]k0WinOP9fMWH2QXJ60P00
009TI6@2LW9b0QTI6@9BDU82CDe=0^[ZjP800002UIFE0]cLg0:YZJT2e=CD0Zn_[`;>c/h2LW9b0Xb<
S0:ZZZX2KVi^0XV9R@9iNGT2OGem0W]kNcalO7`5oooo0@00007oool000Woool4000000Coool0003o
ool00004oooo0P0000Goool2XZ:R0WIfMP9mOGd:O7al0W]kN`9nOWh2M7Ad0YjNWP:][Jd2m?Cd0_oo
o`9kNg/:O7al0WYjNP9bLW82=3@d0/30`08e=CD2M7Ad0S`l?09cLg<2Ng]k0WemO@9ZJVX2PH610_oo
o`:UYJD2oooo0YVIV@9JFUX2];Bd0WMgM`:0P802Ng]k87alO09kNg/2Ogmo0WEeM@:c/k<2G5aL3gal
O09kNg/2OWin0WIfMP:6QXH200000VATI09bLW826ATI0U9BDP9=CDd2j^[Z0P0000:EUID2g=cL0ZVY
Z@;De=@2[jn_0/k>cP9bLW82S8b<0ZZZZP9^KVh2RHV90WUiN@9mOGd2Ng]k?7alO0Coool200000Ooo
o`002Oooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool01?ooo`8d=3@2
QXJ60WQhN09mOGd8O7al0W]kN`9oOgl2MGEe0XJ6QP8K6a/2Zj^[0Tm?C`9mOGd:O7al0WUiN@:6QXH2
A4A40YJFUP;oool2PH610^WYj@9JFUX2RXZ:0WQhN09]KFd2D51@0S8b<P9gMgL2[jn_0R`/;09[Jf/2
=CDe0YBDU09oOglVO7al0WYjNP9nOWh2F5QH5GalO09jNWX2T92@0WalO0;GemL2N7Qh0YBDU0:LW9`2
EEEE0VATI0:KVi/28b<S0W5aL@:^[Zh2MgMg0W=cL`:2PX82S8b<0UQHF0:0P802]KFe0WQhN09oOgl2
NWYj?7alO0Goool100000Oooo`002_ooo`800002oooo00<0003oool000001?ooo`030000oooooooo
00Coool2=3@d0XJ6QP9hN7P2OGem27alO09kNg/2Ogmo0WEeM@:6QXH26a/K0Z^[Z`9?Cdl2OGem2Wal
O09iNGT2QXJ60TA4A0:FUYH2oooo0X61P@;YjNT2FUYJ0XZ:RP9hN7P2KFe]0U1@D08b<S82MgMg0Zn_
[`8/;2`2Jf][0SDe=@:DU9@2Ogmo9WalO09jNWX2OWin0UQHF1ElO7`2NWYj0Y2@T09lO7`2emOG0WQh
N0:DU9@2W9bL0UEEE@9TI6@2Vi^K0R<S8`9aLG42[Zj^0WMgM`9cLg<2PX:20Xb<S09HF5P2P8200[Fe
]@9hN7P2Ogmo0WYjNSalO7`5oooo0@00007oool000_oool01@000?ooooooooooo`000005oooo00<0
003oooooool00_ooo`8J6QX2ZZZZ0W9bLP9oOgl2Ng]k37alO0AmOGd2HF5Q0P0000;bl_82Ng]k2Wal
O09kNg/2MWIf0VQXJ0820P82ATI60_ooo`93@d<2XJ6Q0W=cL`9oOgl26ATI0S@d=0A`L702GUiN0Vi^
KP9lO7`2@D510WemO@9hN7P2OGem0W]kNb1lO7`2OGem0WQhN0:BTY82BTY:4galO09jNWX2OGem0UMG
E`9kNg/2l?3`0_ooo`:OWil2eMGE0Zj^[P9jNWX2/k>c0_7al@800002Q8B40YJFUP:;Rh/2g]kN0Ve]
K@9HF5P2FUYJ0V5QH@:0P802Ng]k?WalO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2
6QXJ0ZZZZP9bLW82Ogmo0W]kN`alO7`4OGem0V5QH@800002l_;b0W]kN`YlO7`2Ng]k0WIfMP9XJ6P2
0P820TI6AP;oool2@d=30Z6QX@9cLg<2Ogmo0QTI6@8d=3@4L71`0UiNGP9^KVh2O7al0T51@@9mOGd2
N7Qh0WemO@9kNg/PO7al0WemO@9hN7P2TY:B0TY:BQ=lO7`2NWYj0WemO@9GEeL2Ng]k0_3`l0;oool2
WinO0]GEe@:^[Zh2NWYj0[>c/`;alO4200000XB4Q0:FUYH2Rh^;0]kNgP9]KFd2F5QH0UYJFP9QHF42
P8200W]kNcilO7`5oooo0@00007oool001Goool00`000?ooooooo`02oooo0P00008R8R82S8b<0WQh
N0alO7`2NWYj0WinOP9lO7`2/[:b0Q`L7090@402OGem27alO09kNg/2OWin0WAdM0:TY:@2f=SH0UeM
G@8E5AD2moOg0W]kN`:3Ph<2N7Qh0UIFEP:ZZZX2=SHf0WMgM`:k^k/200000W=cL`:<S8`2Z:RX0WIf
MP9nOWh2Ng]k87alO0AkNg/2DE5A0QXJ6Q5lO7`2NWYj0X>3P`9UIFD2oooo0WUiN@92@T82JFUY0UMG
E`9iNGT210@40Zf][@:@T902J6QX0VYZJP:o_kl2>CTi0P0000;0`<02`l?30X^;R`800002Q8B40WEe
M@9oOgl2Ng]k?7alO0Goool100000Oooo`005Oooo`030000oooooooo00;oool200000R8R8P:<S8`2
N7Qh37alO09jNWX2OWin0WalO0:b/[8271`L0T10@09mOGd8O7al0W]kN`9nOWh2M7Ad0ZBTY0;Hf=P2
GEeM0QDE5@;gmoL2Ng]k0X>3P`9hN7P2EUIF0ZZZZP8f=SH2MgMg0[^k^`800002Lg=c0Xb<S0:XZ:P2
MWIf0WinOP9kNg/PO7al17]kN`9ADE426QXJ4GalO09jNWX2Ph>30VEUI@;oool2NGUi0T92@P9YJFT2
EeMG0WUiN@8410@2[Jf]0Y2@T09XJ6P2JVYZ0[no_`8i>CT200000/30`0;3`l<2Rh^;0P0000:4Q8@2
MGEe0WmoO`9kNg/lO7al1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9oOgl2MgMg0Wem
O@9kNg/>O7al0W]kN`9mOGd2KFe]0YJFUP8K6a/<O7al0W]kN`9mOGd2M7Ad0Vm_K`95ADD2MWIf0UYJ
FP9TI6@2OGem0W]kN`8n?Sh2MGEe0U]KF`8_;bl2[jn_0YZJVP9=CDd2moOg0WQhN0:2PX82NGUi0Wem
OB9lO7`2Ng]k0XN7Q`::RXXCO7al0W]kN`9nOWh2Kfm_0Z:RXP800002Ti>C0T10@09@D502OGem0Te=
C@97AdL2UYJF0Xb<S09/K6`4oooo0]GEe@;/k>`2hN7Q0W]kN`:ATI42MWIf0WemO@9kNg/lO7al1Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`9oOgl2MgMg0WemO@9kNg/>O7al0W]kN`9mOGd2
KFe]0YJFUP8K6a/<O7al0W]kN`9mOGd2M7Ad0Vm_K`95ADD2MWIf0UYJFP9TI6@2OGem0W]kN`8n?Sh2
MGEe0U]KF`8_;bl2[jn_0YZJVP9=CDd2moOg0WQhN0:2PX82NGUi0WemOB9lO7`2Ng]k0XN7Q`::RXXC
O7al0W]kN`9nOWh2Kfm_0Z:RXP800002Ti>C0T10@09@D502OGem0Te=C@97AdL2UYJF0Xb<S09/K6`4
oooo0]GEe@;/k>`2hN7Q0W]kN`:ATI42MWIf0WemO@9kNg/lO7al1Oooo`400001oooo000Eoooo00<0
003oooooool00_ooo`8R8R82MWIf3WalO09kNg/2OWin0WEeM@:?Shl2=3@d0WemO@:DU9@<O7al0WYj
NP:4Q8@2KVi^0_ooo`:_[jl2KVi^0WemO@:;Rh/2NGUi0WalO09cLg<27AdM0/g=c@9kNg/2MGEe0UIF
EP:f][H2IfMW0WmoO`9jNWX2OGem5WalO09kNg/>O7al0WEeM@:>SXhEO7al0W]kN`:3Ph<2NGUi0WIf
MP:7QhL2NGUi0UMGE`:5QHD2Rh^;0YRHV09SHf<2a<C40/30`0:][Jd2VYZJ0Zn_[`:3Ph<2MWIf0W5a
L@9hN7P2OGem<WalO09kNg/2O7al17]kN`IlO7`5oooo0@00007oool001Goool200000oooo`8R8R82
MWIf3WalO09kNg/2OWin0WEeM@:?Shl2=3@d0WemO@:DU9@<O7al0WYjNP:4Q8@2KVi^0_ooo`:_[jl2
KVi^0WemO@:;Rh/2NGUi0WalO09cLg<27AdM0/g=c@9kNg/2MGEe0UIFEP:f][H2IfMW0WmoO`9jNWX2
OGem5WalO09kNg/>O7al0WEeM@:>SXhEO7al0W]kN`:3Ph<2NGUi0WIfMP:7QhL2NGUi0UMGE`:5QHD2
Rh^;0YRHV09SHf<2a<C40/30`0:][Jd2VYZJ0Zn_[`:3Ph<2MWIf0W5aL@9hN7P2OGem<WalO09kNg/2
O7al17]kN`IlO7`4oooo0P00007oool001Goool00`000?ooooooo`02oooo0YjNWP9jNWX2OGem1Wal
O09kNg/2OWin0WmoO`9mOGd2O7al0WemO@9hN7P2RXZ:0Y6AT@:KVi/2O7al17]kN`9fMWH2NWYj0W]k
N`9lO7`2Ng]k0WalO09QHF42S8b<0XF5Q@:0P802MgMg0WemO@9kNg/2NGUi0XB4Q09mOGd2QXJ60Va/
K09`L702MWIf0X>3P`9kNg/DO7al0W]kN`B0P802O7al0WemO@alO7`2OWin0WYjNP]lO7`2Ng]k2Wal
O09iNGT2OWin0WQhN09iNGT2Ph>30XF5Q@:2PX82OGem0WinOP9fMWH4Ng]k0WinOP9hN7P2M7Ad0Wmo
O`:1PH42Ogmo0WemO@9kNg/^O7al0X20P0:3Ph<4Ng]k0X20P09nOWh2Ng]k17alO0Goool100000Ooo
o`005Oooo`030000oooooooo00;oool2WYjN0WYjNP9mOGd6O7al0W]kN`9nOWh2Ogmo0WemO@9lO7`2
OGem0WQhN0::RXX2TI6A0Y^KV`9lO7`4Ng]k0WIfMP9jNWX2Ng]k0WalO09kNg/2O7al0V5QH@:<S8`2
QHF50X20P09gMgL2OGem0W]kN`9iNGT2Q8B40WemO@:6QXH2K6a/0W1`L09fMWH2Ph>30W]kNaAlO7`2
Ng]k1820P09lO7`2OGem37alO09nOWh2NWYj2galO09kNg/:O7al0WUiN@9nOWh2N7Qh0WUiN@:3Ph<2
QHF50X:2PP9mOGd2OWin0WIfMPAkNg/2OWin0WQhN09dM7@2Ogmo0X61P@9oOgl2OGem0W]kNbilO7`2
P8200X>3P`AkNg/2P8200WinOP9kNg/4O7al1Oooo`400001oooo000Eoooo00<0003oooooool00_oo
o`9bLW82O7al0W]kN`9lO7`2Ng]k0WalO09jNWX2QXJ60Xj>SPAjNWX2NGUi0WinOP9gMgL2N7Qh0WYj
NPAlO7`2NWYj0VMWI`9kNg/2OWin0W]kN`9jNWX2Ng]k0XF5Q@9jNWX2NGUi0W]kN`9mOGd4O7al0Wem
O@9fMWH2Ogmo0WYjNP9mOGd2O7al0X20P09iNGT:O7al0WemO@AlO7`4Ng]k0WemO@9lO7`2SHf=0Wmo
O`:4Q8@2Ogmo0WUiN@9nOWh2O7al0WemO@9kNg/2O7al0W]kN`9lO7`3NWYj0WemO@9lO7`4OGem0Wmo
O`QlO7`2Ng]k17alO0AmOGd2Ng]k0WQhN09jNWX4OGem0W]kN`9oOgl2P82017alO09oOgl6NWYj0W]k
N`AlO7`2OGem0W]kN`9mOGd2Ng]k1WalO0AkNg/:O7al17]kN`QlO7`2OGem0WAdM0:ATI42SHf=0Wal
O09oOgl2NGUi0WAdM0AlO7`2OGem1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9bLW82
O7al0W]kN`9lO7`2Ng]k0WalO09jNWX2QXJ60Xj>SPAjNWX2NGUi0WinOP9gMgL2N7Qh0WYjNPAlO7`2
NWYj0VMWI`9kNg/2OWin0W]kN`9jNWX2Ng]k0XF5Q@9jNWX2NGUi0W]kN`9mOGd4O7al0WemO@9fMWH2
Ogmo0WYjNP9mOGd2O7al0X20P09iNGT:O7al0WemO@AlO7`4Ng]k0WemO@9lO7`2SHf=0WmoO`:4Q8@2
Ogmo0WUiN@9nOWh2O7al0WemO@9kNg/2O7al0W]kN`9lO7`3NWYj0WemO@9lO7`4OGem0WmoO`QlO7`2
Ng]k17alO0AmOGd2Ng]k0WQhN09jNWX4OGem0W]kN`9oOgl2P82017alO09oOgl6NWYj0W]kN`AlO7`2
OGem0W]kN`9mOGd2Ng]k1WalO0AkNg/:O7al17]kN`QlO7`2OGem0WAdM0:ATI42SHf=0WalO09oOgl2
NGUi0WAdM0AlO7`2OGem1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9mOGd2O7al0Win
OP9lO7`2OGem0WalO09oOgl2MgMg0YnOW`:RXZ82O7al0X20P0AkNg/2Ogmo0WYjNP9lO7`2Ng]k0Wmo
O`:ATI42EUIF0WmoO`9nOWh2P8200WUiN@9mOGd2P8200W]kN`9nOWh2OGem0WYjNPAiNGT2Ogmo0Win
OPAoOgl2Ng]k0WUiN@AnOWh2Ng]k17alO09kNg/2N7Qh17alO09nOWh2Ogmo0WQhN09mOGd2C4a<0TA4
A0:a/K42S8b<0WalO09cLg<2Ogmo0WYjNP9nOWh2O7al17]kN`03Q8B4MWIfMWIf009hN7P2Ng]k0Wal
O09jNWX2MWIf17alO09jNWX2O7al0WemO@9nOWh2NGUi0WemO@9jNWX4O7al0WmoO`AlO7`2PH610Wal
O09hN7P2O7al0WYjNP9hN7P2OGem0WinOP9mOGd2P82017alO09fMWH2Ogmo0WMgM`9mOGd2NWYj0W]k
N`9lO7`4OWin0WemO@9kNg/4O7al0W]kN`AnOWh4O7al17]kN`9gMgL2S8b<0U]KF`9`L702WYjN0VYZ
JP;Hf=P2QhN70WYjNP:1PH42MgMg1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9mOGd2
O7al0WinOP9lO7`2OGem0WalO09oOgl2MgMg0YnOW`:RXZ82O7al0X20P0AkNg/2Ogmo0WYjNP9lO7`2
Ng]k0WmoO`:ATI42EUIF0WmoO`9nOWh2P8200WUiN@9mOGd2P8200W]kN`9nOWh2OGem0WYjNPAiNGT2
Ogmo0WinOPAoOgl2Ng]k0WUiN@AnOWh2Ng]k17alO09kNg/2N7Qh17alO09nOWh2Ogmo0WQhN09mOGd2
C4a<0TA4A0:a/K42S8b<0WalO09cLg<2Ogmo0WYjNP9nOWh2O7al17]kN`03Q8B4MWIfMWIf009hN7P2
Ng]k0WalO09jNWX2MWIf17alO09jNWX2O7al0WemO@9nOWh2NGUi0WemO@9jNWX4O7al0WmoO`AlO7`2
PH610WalO09hN7P2O7al0WYjNP9hN7P2OGem0WinOP9mOGd2P82017alO09fMWH2Ogmo0WMgM`9mOGd2
NWYj0W]kN`9lO7`4OWin0WemO@9kNg/4O7al0W]kN`AnOWh4O7al17]kN`9gMgL2S8b<0U]KF`9`L702
WYjN0VYZJP;Hf=P2QhN70WYjNP:1PH42MgMg1Oooo`400001oooo000Eoooo00<0003oooooool00_oo
o`9nOWh4Ph>30X61P@9iNGT2P8200W9bLP;6a/H2no_k0SLg=`9TI6@2>CTi0XB4Q0:3Ph<2Ogmo0X:2
PP:1PH42MWIf0Xn?S`9VIVH2moOg0[>c/`:1PH42EUIF0XZ:RP9bLW82PH610X:2PP9kNg/2MgMg0WYj
NP:0P802MgMg0WYjNP9kNg/2OGem0WalO09nOWh2Ogmo0WalO09jNWX2OGem0WmoO`9dM7@4OGem17]k
N`9lO7`2OGem0X20P0:NWYh2UIFE0Vm_K`;=cLd2][Jf0VMWI`:6QXH2Rh^;0Z6QX@9aLG42PX:20W1`
L09mOGd00f=SHdM7AdM7A`02RHV90X:2PP:LW9`2TY:B0Z^[Z`9gMgL2Ng]k0WinOPB0P802MGEe0XF5
Q@:0P802QhN70WYjNP9hN7P2O7al0WMgM`9mOGd2MGEe1861P@9lO7`2PX:20XF5Q@9mOGd2M7Ad0X61
P@9lO7`2KVi^0WmoO`9mOGd2N7Qh0W]kN`9mOGd2R8R80WalO0AjNWX2OWin0WIfMP:1PH42Ng]k0WYj
NP9oOgl4OGem0WQhN09mOGd2P8200WinOP:5QHD2;Bd]0_ooo`8^;Rh2D51@0]GEe@9UIFD2][Jf0Y:B
TP:=SHd2NWYj1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9nOWh4Ph>30X61P@9iNGT2
P8200W9bLP;6a/H2no_k0SLg=`9TI6@2>CTi0XB4Q0:3Ph<2Ogmo0X:2PP:1PH42MWIf0Xn?S`9VIVH2
moOg0[>c/`:1PH42EUIF0XZ:RP9bLW82PH610X:2PP9kNg/2MgMg0WYjNP:0P802MgMg0WYjNP9kNg/2
OGem0WalO09nOWh2Ogmo0WalO09jNWX2OGem0WmoO`9dM7@4OGem17]kN`9lO7`2OGem0X20P0:NWYh2
UIFE0Vm_K`;=cLd2][Jf0VMWI`:6QXH2Rh^;0Z6QX@9aLG42PX:20W1`L09mOGd00f=SHdM7AdM7A`02
RHV90X:2PP:LW9`2TY:B0Z^[Z`9gMgL2Ng]k0WinOPB0P802MGEe0XF5Q@:0P802QhN70WYjNP9hN7P2
O7al0WMgM`9mOGd2MGEe1861P@9lO7`2PX:20XF5Q@9mOGd2M7Ad0X61P@9lO7`2KVi^0WmoO`9mOGd2
N7Qh0W]kN`9mOGd2R8R80WalO0AjNWX2OWin0WIfMP:1PH42Ng]k0WYjNP9oOgl4OGem0WQhN09mOGd2
P8200WinOP:5QHD2;Bd]0_ooo`8^;Rh2D51@0]GEe@9UIFD2][Jf0Y:BTP:=SHd2NWYj1Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`9`L702Shn?0[:b/P:BTY82UiNG0X:2PP:m_Kd2>CTi0_oo
o`:YZJT28B4Q0SXj>P:DU9@2CDe=0/_;b`9`L702RHV90UQHF09BDU82clo?0UIFEP:JVYX2FEUI0V][
J`9BDU82/k>c0^KViP9dM7@2Z:RX0Xj>SP9@D502HF5Q0S<c<`::RXX2^k^k0/?3``:b/[82L71`0W5a
L@::RXX2YJFU0WAdM0:>SXh2LW9b0V5QH@8Z:RX2QhN70WMgM`BOWil2NGUi0X^;R`:b/[82QhN70_3`
l08b<S82=CDe0SXj>P8f=SH2i>CT0WQhN0:PX:02;Bd]0WYjNP03ZJVY^;Rh^;Rh008O7al2QXJ60_gm
o@:^[Zh2QHF50VEUI@9/K6`2E5AD0X^;R`:5QHD2[jn_0U1@D0:e]KD2L71`0YRHV09JFUX2^KVi0WIf
MP:3Ph<2c/k>0WmoO`9EEED2Q8B40UmOG`9XJ6P2Y:BT0Zj^[P:MWId2dM7A0U1@D09_Kfl22@T90[^k
^`8E5AD2UiNG0Vi^KP9LG5`2O7al0Zn_[`:`/;02UYJF0W=cL`9nOWh2PX:20Vm_K`:`/;02];Bd0Vi^
KPB5QHD2M7Ad0X20P09<C4`28b<S0[^k^`:UYJD2>CTi0P0000:0P802EEEE0TA4A08c<c<5oooo0@00
007oool001Goool200000oooo`9`L702Shn?0[:b/P:BTY82UiNG0X:2PP:m_Kd2>CTi0_ooo`:YZJT2
8B4Q0SXj>P:DU9@2CDe=0/_;b`9`L702RHV90UQHF09BDU82clo?0UIFEP:JVYX2FEUI0V][J`9BDU82
/k>c0^KViP9dM7@2Z:RX0Xj>SP9@D502HF5Q0S<c<`::RXX2^k^k0/?3``:b/[82L71`0W5aL@::RXX2
YJFU0WAdM0:>SXh2LW9b0V5QH@8Z:RX2QhN70WMgM`BOWil2NGUi0X^;R`:b/[82QhN70_3`l08b<S82
=CDe0SXj>P8f=SH2i>CT0WQhN0:PX:02;Bd]0WYjNP03ZJVY^;Rh^;Rh008O7al2QXJ60_gmo@:^[Zh2
QHF50VEUI@9/K6`2E5AD0X^;R`:5QHD2[jn_0U1@D0:e]KD2L71`0YRHV09JFUX2^KVi0WIfMP:3Ph<2
c/k>0WmoO`9EEED2Q8B40UmOG`9XJ6P2Y:BT0Zj^[P:MWId2dM7A0U1@D09_Kfl22@T90[^k^`8E5AD2
UiNG0Vi^KP9LG5`2O7al0Zn_[`:`/;02UYJF0W=cL`9nOWh2PX:20Vm_K`:`/;02];Bd0Vi^KPB5QHD2
M7Ad0X20P09<C4`28b<S0[^k^`:UYJD2>CTi0P0000:0P802EEEE0TA4A08c<c<4oooo0P00007oool0
01Goool00`000?ooooooo`02oooo0^_[j`AoOgl2MgMg0XJ6QP:4Q8@2l_;b0WYjNP9fMWH2gmoO0[Fe
]@:WYjL2XJ6Q0U9BDP:3Ph<2SHf=0[2`/09[Jf/2SHf=0SLg=`:^[Zh24a<C0W1`L09fMWH2QhN70TY:
BP;Lg=`2aLG50W9bLP9DE5@2UIFE0YjNWP:m_Kd2?3`l0QhN7P;Lg=`2GUiN0YZJVP;3`l<2Hf=S0ZFU
Y@:3Ph<2gmoO0Y:BTP9/K6`2a/K60WQhN09gMgL2I6AT0UMGE`;oool2/k>c0Sdm?@:KVi/2XZ:R0Xb<
S09oOgl2Y:BT0P0000:RXZ82>CTi0XJ6QP800002O7al00=ADE4X:2PX:2P00TY:BP:4Q8@2`<300YNG
U`;WinL27QhN0Q@D50:DU9@2GemO0TU9B@:?Shl2o?cl0^g]k@:0P802a<C40S0`<09cLg<2<S8b0/k>
cP91@D42EeMG0Z>SX`:EUID2a<C40_ooo`;WinL2G5aL0ZJVYP:RXZ82HF5Q0XJ6QP;GemL2P8200/?3
``8M7Ad2clo?0UQHF09MGEd2B4Q80ZNWY`95ADD2cLg=0Xj>SP9WIfL2_kno0Xb<S09cLg<26ATI0Y^K
V`;@d=02hn?S0Zb/[09NGUh2IFEU0YNGU`:b/[82GUiN0SXj>P:LW9`2@4100Y6AT@:0P805oooo0@00
007oool001Goool00`000?ooooooo`02oooo0^_[j`AoOgl2MgMg0XJ6QP:4Q8@2l_;b0WYjNP9fMWH2
gmoO0[Fe]@:WYjL2XJ6Q0U9BDP:3Ph<2SHf=0[2`/09[Jf/2SHf=0SLg=`:^[Zh24a<C0W1`L09fMWH2
QhN70TY:BP;Lg=`2aLG50W9bLP9DE5@2UIFE0YjNWP:m_Kd2?3`l0QhN7P;Lg=`2GUiN0YZJVP;3`l<2
Hf=S0ZFUY@:3Ph<2gmoO0Y:BTP9/K6`2a/K60WQhN09gMgL2I6AT0UMGE`;oool2/k>c0Sdm?@:KVi/2
XZ:R0Xb<S09oOgl2Y:BT0P0000:RXZ82>CTi0XJ6QP800002O7al00=ADE4X:2PX:2P00TY:BP:4Q8@2
`<300YNGU`;WinL27QhN0Q@D50:DU9@2GemO0TU9B@:?Shl2o?cl0^g]k@:0P802a<C40S0`<09cLg<2
<S8b0/k>cP91@D42EeMG0Z>SX`:EUID2a<C40_ooo`;WinL2G5aL0ZJVYP:RXZ82HF5Q0XJ6QP;GemL2
P8200/?3``8M7Ad2clo?0UQHF09MGEd2B4Q80ZNWY`95ADD2cLg=0Xj>SP9WIfL2_kno0Xb<S09cLg<2
6ATI0Y^KV`;@d=02hn?S0Zb/[09NGUh2IFEU0YNGU`:b/[82GUiN0SXj>P:LW9`2@4100Y6AT@:0P805
oooo0@00007oool001Goool00`000?ooooooo`02oooo0]kNgP:@T902I6AT0Z2PX0;6a/H2<C4a0P00
00:;Rh/2J6QX0UQHF09]KFd2=3@d0UaLG09lO7`2FEUI0U=CD`:NWYh2HV9R0UUIF@9nOWh2LG5a0Wmo
O`:5QHD2TI6A0Q@D509gMgL2Rh^;0/C4a09`L702LG5a0X>3P`;[jn/2NWYj0_ooo`:NWYh2OWin0Q8B
4P:f][H2`<300TM7A`:YZJT2820P0UiNGP9]KFd2RHV90PT92@9FEUH2/[:b0[Bd]0;<c<`2:2PX0/30
`09fMWH2KFe]0YjNWP9[Jf/2TY:B0X61P@:5QHD2CDe=0[Rh^094A4@2LW9b0VEUI@03=3@dVi^KVi^K
00:NWYh2LW9b0Zb/[0:WYjL2UYJF0Y6AT@8;2`/2j^[Z0TQ8B0;Fe]H2@d=30PP820;oool2P8200YBD
U08j>SX2BTY:1820P08a<C42UiNG0R@T90;Bd]82V9RH0R@T90:HV9P2hn?S0P0000;4a<@2i^KV0_oo
o`9]KFd2DU9B0]CDe0:0P802oooo0YVIV@9lO7`2fm_K0YVIV@:=SHd4UiNG0/30`08d=3@2eMGE0Z^[
Z`9TI6@200000WalO0800002emOG0Vi^KP:;Rh/2MgMg0WYjNP9fMWH2KFe]0WmoO`9jNWX2JFUY0YBD
U0Goool100000Oooo`005Oooo`030000oooooooo00;oool2g]kN0Y2@T09TI6@2X:2P0/K6aP8a<C42
00000X^;R`9XJ6P2F5QH0Ve]K@8d=3@2G5aL0WalO09IFET2De=C0YjNWP9RHV82FEUI0WinOP9aLG42
Ogmo0XF5Q@:ATI4251@D0WMgM`:;Rh/2a<C40W1`L09aLG42Ph>30^_[j`9jNWX2oooo0YjNWP9nOWh2
4Q8B0[Jf]P;0`<02AdM70ZVYZ@8P8202GUiN0Ve]K@:9RHT22@T90UIFEP:b/[82];Bd0/c<c08X:2P2
`<300WIfMP9]KFd2WYjN0V][J`:BTY82PH610XF5Q@9=CDd2^;Rh0TA4A09bLW82IFEU00<d=3BKVi^K
Vi/00YjNWP9bLW82[:b/0ZNWY`:FUYH2TI6A0P/;2`;Zj^X2B4Q80]KFeP93@d<220P80_ooo`:0P802
U9BD0SXj>P9:BTX4P8200S4a<@:GUiL292@T0];BdP:HV9P292@T0YRHV0;Shn<200000/C4a0;Vi^H2
oooo0Ve]K@9BDU82e=CD0X20P0;oool2VIVI0WalO0;Kfm/2VIVI0Xf=S@BGUiL2`<300S@d=0;EeMD2
Zj^[0VATI0800002O7al0P0000;GemL2KVi^0X^;R`9gMgL2NWYj0WIfMP9]KFd2Ogmo0WYjNP9YJFT2
U9BD1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9oOgl2mOGe0_ooo`9fMWH2Shn?0]OG
e`:JVYX200000T=3@`892@T2b<S80W5aL@:m_Kd2oooo0W=cL`:IVIT2IFEU0U9BDP:BTY82<c<c0_oo
o`9ADE429RHV0XR8R09LG5`2MgMg0V9RHP;inOT2@D510WemO@;UiND2gMgM0UiNGP9<C4`2NGUi0T=3
@`9HF5P2a/K60[6a/@:PX:02KVi^0X20P09hN7P2BTY:0]CDe09hN7P2Rh^;0Xb<S09@D502Shn?0Sdm
?@800002EeMG0YjNWP8R8R84SXj>0W5aL@:PX:02@4100VMWI`9XJ6P2KVi^0WAdM003QhN7MGEeMGEe
009cLg<2UYJF0YNGU`:IVIT2IFEU0RXZ:P:EUID2R8R80[6a/@:6QXH2emOG0P00008i>CT2Fe]K0V5Q
H@;2`/82b/[:0Xn?S`:@T902J6QX0S@d=0:RXZ82Ph>30YZJVP;fm_H2?clo0[6a/@9bLW82]KFe0Zb/
[0:6QXH2:RXZ0Rh^;P9UIFD2F5QH0Z6QX@;GemL2MGEe0WemO@8j>SX2^[Zj0[Vi^@9dM7@2Lg=c0T51
@@;8b<P2/;2`0XB4Q0;Lg=`2K6a/0X61P@:MWId2YZJV0YRHV09kNg/2NGUi0YFEU@:j^[X2JVYZ0U=C
D`:<S8`2Q8B41Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9oOgl2mOGe0_ooo`9fMWH2
Shn?0]OGe`:JVYX200000T=3@`892@T2b<S80W5aL@:m_Kd2oooo0W=cL`:IVIT2IFEU0U9BDP:BTY82
<c<c0_ooo`9ADE429RHV0XR8R09LG5`2MgMg0V9RHP;inOT2@D510WemO@;UiND2gMgM0UiNGP9<C4`2
NGUi0T=3@`9HF5P2a/K60[6a/@:PX:02KVi^0X20P09hN7P2BTY:0]CDe09hN7P2Rh^;0Xb<S09@D502
Shn?0Sdm?@800002EeMG0YjNWP8R8R84SXj>0W5aL@:PX:02@4100VMWI`9XJ6P2KVi^0WAdM003QhN7
MGEeMGEe009cLg<2UYJF0YNGU`:IVIT2IFEU0RXZ:P:EUID2R8R80[6a/@:6QXH2emOG0P00008i>CT2
Fe]K0V5QH@;2`/82b/[:0Xn?S`:@T902J6QX0S@d=0:RXZ82Ph>30YZJVP;fm_H2?clo0[6a/@9bLW82
]KFe0Zb/[0:6QXH2:RXZ0Rh^;P9UIFD2F5QH0Z6QX@;GemL2MGEe0WemO@8j>SX2^[Zj0[Vi^@9dM7@2
Lg=c0T51@@;8b<P2/;2`0XB4Q0;Lg=`2K6a/0X61P@:MWId2YZJV0YRHV09kNg/2NGUi0YFEU@:j^[X2
JVYZ0U=CD`:<S8`2Q8B41Oooo`400001oooo000Eoooo00<0003oooooool01?ooo`;Vi^H2hn?S0_oo
o`9=CDd400000P<30`:c/k<200000Y6AT@:0P802oooo0]3@d0;Ph>02oooo0U]KF`;oool2YJFU0RPX
:0;oool2ADE50VMWI`:GUiL2S8b<0WMgM`8d=3@2fMWI0_ooo`;Fe]H2eMGE0Z6QX@800002lo?c0Wem
O@9=CDd2i^KV0Shn?P:XZ:P2VIVI0[Jf]P800002HV9R0Ti>CP94A4@2Shn?0SLg=`8m?Cd2Ph>30Xn?
S`9GEeL2ZZZZ0WIfMP:OWil2D51@0P0000:?Shl4O7al0ZZZZP:UYJD2IfMW0U9BDP800003MgMg0UIF
EP9[Jf/2VIVI0Xf=S@:5QHD200000UIFEP:5QHD2KFe]0UQHF09:BTX2U9BD0^3Ph0:NWYh2@T920/?3
``;Ti>@2dM7A0P00009JFUX2TY:B0U=CD`9VIVH2alO70TA4A08Z:RX2`L710XZ:RP:][Jd2IfMW0Rh^
;P9nOWh2DU9B0/?3``9UIFD2HF5Q0VEUI@:MWId2RHV917alO08`<3028R8R0WYjNP:DU9@2Ng]k0YBD
U08o?cl2O7al0[:b/P:MWId21@D50Xf=S@:9RHT2Ogmo0X20P09eMGD2YZJV0Zf][@9EEED2W9bL0X20
P0Goool100000Oooo`005Oooo`030000oooooooo00Coool2i^KV0^?Sh`;oool2CDe=100000830`<2
/k>c0P0000:ATI42P8200_ooo`;@d=02h>3P0_ooo`9KFe/2oooo0ZFUY@8X:2P2oooo0TE5A@9WIfL2
UiNG0Xb<S09gMgL2=3@d0]WIf@;oool2e]KF0]GEe@:QXJ4200000_?cl`9mOGd2CDe=0^KViP8n?Sh2
Z:RX0YVIV@:f][H200000V9RHP9>CTh2A4A40Xn?S`8g=cL2?Cdm0X>3P`:?Shl2EeMG0ZZZZP9fMWH2
WinO0U1@D0800002Shn?17alO0:ZZZX2YJFU0VMWI`9BDU8200000gMgM`9FEUH2Jf][0YVIV@:=SHd2
QHF50P00009FEUH2QHF50Ve]K@9HF5P2BTY:0YBDU0;Ph>02WYjN0T92@P;3`l<2i>CT0]7Ad@800002
FUYJ0Y:BTP9CDe<2IVIV0/O7a`94A4@2:RXZ0/71`@::RXX2[Jf]0VMWI`8^;Rh2OWin0U9BDP;3`l<2
IFEU0V5QH@9UIFD2WIfM0XV9R@AlO7`2<30`0R8R8P9jNWX2U9BD0W]kN`:DU9@2?clo0WalO0:b/[82
WIfM0PD51@:=SHd2RHV90WmoO`:0P802MGEe0ZJVYP:][Jd2EEEE0YbLW0:0P805oooo0@00007oool0
01Goool00`000?ooooooo`02oooo0PP82090@40400000[Fe]@800002<c<c0Rl_;`871`L2P8200^3P
h08R8R8400000U9BDP:BTY82?Shn0YVIV@:d];@2?Cdm0];BdP91@D42lO7a0Pd=3@:FUYH2Ti>C0S<c
<`::RXX2TY:B0/O7a`:BTY82oooo0UUIF@:ATI42clo?0UeMG@9=CDd2Kfm_0Ve]K@9IFET2M7Ad0YnO
W`9MGEd2oooo0WinOP;1`L42_Kfm1:n_[`:f][H2[:b/0SXj>P8J6QX2VIVI0UYJFP9gMgL2?clo0Z2P
X09BDU82Xj>S0XF5Q@;Ph>02SXj>0[6a/@03OGemT92@T92@00:FUYH2UiNG0U5AD@:ZZZX2W9bL14m?
C`9ADE42Rh^;0W9bLP9GEeL2L71`0STi>@:7QhL2QHF50Shn?P:UYJD2JFUY0P/;2`:BTY82UYJF0XF5
Q@8Z:RX2CTi>0XZ:RP9LG5`2De=C0ZBTY08V9RH2_[jn0UYJFP9CDe<2LW9b0V1PH09hN7P2OGem0_oo
o`;0`<02?3`l0Ta<C0:TY:@2QhN70Xn?S`:ATI42Ng]k0QdM7@9JFUX2QXJ60UEEE@;>c/h2`L710VEU
I@8h>3P2OGem0Va/K09eMGD2M7Ad0UMGE`:CTi<2LW9b0XB4Q09gMgL5oooo0@00007oool001Goool2
00000oooo`8820P2@410100000:e]KD200000S<c<`8_;bl21`L70X20P0;Ph>028R8R1000009BDU82
TY:B0Shn?P:IVIT2];Bd0Sdm?@;Bd]82@D510_7al@8=3@d2UYJF0Y>CT`8c<c<2RXZ:0Y:BTP;7alL2
TY:B0_ooo`9IFET2TI6A0/o?c`9MGEd2CDe=0Vm_K`9]KFd2FEUI0WAdM0:OWil2GEeM0_ooo`9nOWh2
`L710[fm_@B_[jl2][Jf0Zb/[08j>SX26QXJ0YVIV@9JFUX2MgMg0Slo?`:PX:02DU9B0Z>SX`:5QHD2
h>3P0Xj>SP:a/K400gemOI2@T92@T002UYJF0YNGU`9ADE42ZZZZ0YbLW0A?Cdl2DE5A0X^;R`9bLW82
EeMG0W1`L08i>CT2QhN70XF5Q@8n?Sh2YJFU0VUYJ@8;2`/2TY:B0YJFUP:5QHD2:RXZ0Ti>CP::RXX2
G5aL0U=CD`:TY:@29RHV0[jn_P9JFUX2De=C0W9bLP9PH602N7Qh0WemO@;oool2`<300S`l?09<C4`2
Y:BT0XN7Q`:?Shl2TI6A0W]kN`8M7Ad2FUYJ0XJ6QP9EEED2c/k>0/71`@9UIFD2>3Ph0WemO@9/K6`2
MGEe0WAdM09GEeL2Ti>C0W9bLP:4Q8@2MgMg1?ooo`800001oooo000Eoooo00<0003oooooool00_oo
o`:RXZ82QXJ60Zb/[0;oool200000XZ:RP;Ti>@2Y:BT0X^;R`;IfMT2/k>c0_clo0:3Ph<2a/K60X:2
PP9/K6`2oooo0QLG5`9IFET2SXj>0P00008o?cl200000]SHf09VIVH2K6a/0V1PH091@D42NWYj0UYJ
FP9GEeL2;Bd]0[6a/@9iNGT21PH60TU9B@:7QhL2Ng]k0VYZJP9oOgl2^;Rh0UMGE`;Fe]H23Ph>0P<3
0`91@D42inOW0/k>cP:ATI42H61P0Te=C@9bLW82]kNg0S8b<P;dm?@2ATI60/g=c@94A4@200000/S8
b09CDe<2Shn?0XB4Q09XJ6P00chn?ZVYZJVYZ@02i>CT0WEeM@;bl_8220P80YBDU093@d<2@T920V9R
HP:9RHT2MGEe0X20P09dM7@2SHf=0XJ6QP800002DU9B0^o_k`;fm_H2Shn?0Pl?3`9ZJVX2Ti>C0[Zj
^P;Lg=`2Lg=c0X:2PP:8R8P2EEEE0WYjNP;Rh^82PX:20Zn_[`8j>SX2PH610SDe=@9GEeL2bl_;0VIV
IP:6QXH2`l?30_Win@94A4@2NGUi0T=3@`:OWil2GemO0[:b/P9kNg/2R8R80Y2@T092@T820P820Wmo
O`9bLW82WIfM0YFEU@9HF5P2P8200W]kN`8g=cL2QHF50YnOW`Goool100000Oooo`005Oooo`030000
oooooooo00;oool2XZ:R0XJ6QP:/[:`2oooo0P0000::RXX2i>CT0ZBTY0:;Rh/2fMWI0[>c/`;lo?`2
Ph>30/K6aP:2PX82K6a/0_ooo`8G5aL2FEUI0Xj>SP800002?clo0P0000;Hf=P2IVIV0Va/K09PH602
@D510WYjNP9JFUX2EeMG0Rd];@:a/K42NGUi0PH61P99BDT2QhN70W]kN`9ZJVX2Ogmo0[Rh^09GEeL2
e]KF0Ph>3P830`<2@D510^OWi`;>c/h2TI6A0V1PH09=CDd2LW9b0[Ng]`8b<S82m?Cd0TI6AP;=cLd2
A4A40P0000;8b<P2De=C0Xn?S`:4Q8@2J6QX00<n?SjYZJVYZJT00^CTi09eMGD2l_;b0PP820:DU9@2
@d=30T92@P9RHV82RHV90WEeM@:0P802M7Ad0Xf=S@:6QXH200000U9BDP;_knl2m_Kf0Xn?S`8?3`l2
JVYZ0Y>CT`:j^[X2g=cL0W=cL`:2PX82R8R80UEEE@9jNWX2h^;R0X:2PP:_[jl2>SXj0X61P@8e=CD2
EeMG0/_;b`9VIVH2QXJ60/?3``;inOT2A4A40WUiN@93@d<2WinO0UmOG`:b/[82Ng]k0XR8R0:@T902
@T920P820P9oOgl2LW9b0YfMW@:EUID2F5QH0X20P09kNg/2=cLg0XF5Q@:OWil5oooo0@00007oool0
01Goool00`000?ooooooo`02oooo0P00009`L702?Shn0P0000:`/;02oooo0ZVYZ@8o?cl2KFe]0/71
`@;UiND2HF5Q0W5aL@:2PX82Ng]k0Vm_K`9oOgl2oooo0VYZJP9CDe<2WinO0_ooo`;Kfm/2A4A40Y:B
TP9mOGd2];Bd0YjNWP8?3`l2EUIF0__kn`;4a<@2XJ6Q0WQhN0:ZZZX2Ph>30[Ng]`;8b<P2@T920YZJ
VP:ZZZX2:RXZ0_ooo`9gMgL2Hf=S0Vi^KP;QhN42;Rh^0Z6QX@;oool2eMGE0UiNGP9oOgl2[jn_0W]k
N`;7alL2i>CT0SDe=@:SXj<2ZZZZ0Xj>SP:8R8P2N7Qh0Y:BTP0300000`<30`<300;^k^h2[Jf]0[no
_`9BDU82R8R80V][J`:;Rh/2OGem0W]kN`:4Q8@2M7Ad0XR8R0:XZ:P2L71`0WIfMP:BTY82KFe]0Z:R
XP9XJ6P2];Bd0P00009IFET2=cLg0ZRXZ09KFe/2QXJ60Ve]K@:a/K425ADE0W9bLP9kNg/220P80[jn
_P;AdM4200000YJFUP9_Kfl2b/[:0WalO0:`/;02WIfM0P0000:^[Zh2G5aL0_7al@8j>SX2QHF50VAT
I0:][Jd2=cLg0ZRXZ09TI6@2]KFe0X61P@8m?Cd400000/30`09oOgl2MgMg0T92@P:PX:05oooo0@00
007oool001Goool00`000?ooooooo`02oooo0P00009`L702?Shn0P0000:`/;02oooo0ZVYZ@8o?cl2
KFe]0/71`@;UiND2HF5Q0W5aL@:2PX82Ng]k0Vm_K`9oOgl2oooo0VYZJP9CDe<2WinO0_ooo`;Kfm/2
A4A40Y:BTP9mOGd2];Bd0YjNWP8?3`l2EUIF0__kn`;4a<@2XJ6Q0WQhN0:ZZZX2Ph>30[Ng]`;8b<P2
@T920YZJVP:ZZZX2:RXZ0_ooo`9gMgL2Hf=S0Vi^KP;QhN42;Rh^0Z6QX@;oool2eMGE0UiNGP9oOgl2
[jn_0W]kN`;7alL2i>CT0SDe=@:SXj<2ZZZZ0Xj>SP:8R8P2N7Qh0Y:BTP0300000`<30`<300;^k^h2
[Jf]0[no_`9BDU82R8R80V][J`:;Rh/2OGem0W]kN`:4Q8@2M7Ad0XR8R0:XZ:P2L71`0WIfMP:BTY82
KFe]0Z:RXP9XJ6P2];Bd0P00009IFET2=cLg0ZRXZ09KFe/2QXJ60Ve]K@:a/K425ADE0W9bLP9kNg/2
20P80[jn_P;AdM4200000YJFUP9_Kfl2b/[:0WalO0:`/;02WIfM0P0000:^[Zh2G5aL0_7al@8j>SX2
QHF50VATI0:][Jd2=cLg0ZRXZ09TI6@2]KFe0X61P@8m?Cd400000/30`09oOgl2MgMg0T92@P:PX:05
oooo0@00007oool001Goool00`000?ooooooo`02oooo0X20P09eMGD200000W5aL@:QXJ42inOW0VMW
I`9;Bd/2Ng]k0YnOW`800002/K6a0Y6AT@:RXZ82CTi>0]3@d0:IVIT2:2PX0[bl_0;QhN42UYJF0UIF
EP9IFET2OGem0W]kN`;EeMD2QHF50]_Kf`9TI6@2J6QX0^[ZjP9TI6@2YJFU0[Ng]`:QXJ42R8R80Rh^
;P:h^;P2YjNW0VIVIP::RXX2EUIF0W9bLP9EEED29RHV0^?Sh`:9RHT2QXJ60PD51@9>CTh2O7al0Win
OP9eMGD2I6AT0S0`<0:SXj<200000/c<c0;Fe]H2Ng]k0U=CD`:?Shl2EeMG0S4a<@03DE5AK6a/K6a/
009FEUH2OGem0Y6AT@9eMGD2KFe]0QXJ6P9cLg<2MgMg0XF5Q@9:BTX2HF5Q0P0000:j^[X2MGEe0[6a
/@9CDe<2KVi^0V1PH09XJ6P2EeMG0]CDe08E5AD2GemO0/30`0;Hf=P2OGem0XN7Q`9MGEd2K6a/0Win
OP9WIfL2TI6A0VMWI`:WYjL2_kno0WIfMP:HV9P200000_ooo`;alO42?3`l0U1@D09MGEd2W9bL0[Rh
^0:1PH42Fe]K0VUYJ@:f][H2IFEU0WMgM`9WIfL2eMGE0V5QH@;oool2EUIF0]kNgP9fMWH2RHV90/S8
b0:RXZ82G5aL1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`:0P802MGEe0P00009aLG42
XJ6Q0^OWi`9WIfL2Bd];0W]kN`:OWil200000[6a/@:ATI42XZ:R0Ti>CP;@d=02VIVI0RPX:0:l_;`2
hN7Q0YJFUP9FEUH2FEUI0WemO@9kNg/2eMGE0XF5Q@;Kfm/2I6AT0VQXJ0;Zj^X2I6AT0ZFUY@:g]kL2
XJ6Q0XR8R08^;Rh2^;Rh0ZNWY`9VIVH2RXZ:0UIFEP9bLW82EEEE0RHV9P;Shn<2RHV90XJ6QP851@D2
CTi>0WalO09nOWh2MGEe0VATI08`<302Xj>S0P0000;<c<`2e]KF0W]kN`9CDe<2Shn?0UMGE`8a<C40
0e5ADFa/K6a/K002EUIF0WemO@:ATI42MGEe0Ve]K@8J6QX2Lg=c0WMgM`:5QHD2BTY:0V5QH@800002
^[Zj0WEeM@:a/K42De=C0Vi^KP9PH602J6QX0UMGE`;De=@25ADE0UmOG`;0`<02f=SH0WemO@:7QhL2
GEeM0Va/K09nOWh2IfMW0Y6AT@9WIfL2YjNW0[no_`9fMWH2V9RH0P0000;oool2lO7a0S`l?09@D502
GEeM0YbLW0:h^;P2PH610U]KF`9YJFT2][Jf0VEUI@9gMgL2IfMW0]GEe@9QHF42oooo0UIFEP;Ng]h2
MWIf0XV9R@;8b<P2XZ:R0UaLG0Goool100000Oooo`005Oooo`030000oooooooo00;oool2[:b/0]oO
g`9ZJVX2KFe]0UMGE`:BTY82b<S80QPH609eMGD2MgMg0V][J`:VYZH2Fe]K0S4a<@:5QHD2W9bL0[6a
/@8o?cl2JVYZ0UmOG`:8R8P200000[6a/@9_Kfl2gMgM0^WYj@;Ti>@23Ph>0ZFUY@820P82PX:20P00
008N7Qh2LW9b0RPX:09_Kfl2X:2P0W5aL@9]KFd2YjNW0P0000:i^KT2YjNW0Zj^[P;oool2@4100UiN
GP:UYJD4QXJ60U]KF`:HV9P2Z:RX0]OGe`;moOd20@410UUIF@:UYJD2/;2`0Z:RXP9OGel2UIFE0V9R
HP9iNGT00fUYJBHV9RHV9P02HV9R0VATI0:>SXh2NWYj0SLg=`9FEUH2OWin0W]kN`:1PH42T92@0P<3
0`9OGel2D51@0UeMG@;`l?02QHF50^g]k@:n_[h2/;2`0YJFUP9ZJVX2/k>c0R0P809]KFd2oooo0Z6Q
X@:KVi/2LG5a0P0000:9RHT2a/K60VYZJP8k>c/2Y:BT0X20P09`L702FEUI0_ooo`:OWil2DE5A0X^;
R`;UiND2_[jn0VMWI`:RXZ82<c<c0R/[:`;fm_H2[Jf]0YjNWP96ATH2EEEE0/_;b`9fMWH2820P0YbL
W090@402UIFE0P`<30:?Shl2H61P0P0000Goool100000Oooo`002Oooo`800004oooo00<0003ooooo
ool00oooo`030000oooooooo00;oool2[:b/0]oOg`9ZJVX2KFe]0UMGE`:BTY82b<S80QPH609eMGD2
MgMg0V][J`:VYZH2Fe]K0S4a<@:5QHD2W9bL0[6a/@8o?cl2JVYZ0UmOG`:8R8P200000[6a/@9_Kfl2
gMgM0^WYj@;Ti>@23Ph>0ZFUY@820P82PX:20P00008N7Qh2LW9b0RPX:09_Kfl2X:2P0W5aL@9]KFd2
YjNW0P0000:i^KT2YjNW0Zj^[P;oool2@4100UiNGP:UYJD4QXJ60U]KF`:HV9P2Z:RX0]OGe`;moOd2
0@410UUIF@:UYJD2/;2`0Z:RXP9OGel2UIFE0V9RHP9iNGT00fUYJBHV9RHV9P02HV9R0VATI0:>SXh2
NWYj0SLg=`9FEUH2OWin0W]kN`:1PH42T92@0P<30`9OGel2D51@0UeMG@;`l?02QHF50^g]k@:n_[h2
/;2`0YJFUP9ZJVX2/k>c0R0P809]KFd2oooo0Z6QX@:KVi/2LG5a0P0000:9RHT2a/K60VYZJP8k>c/2
Y:BT0X20P09`L702FEUI0_ooo`:OWil2DE5A0X^;R`;UiND2_[jn0VMWI`:RXZ82<c<c0R/[:`;fm_H2
[Jf]0YjNWP96ATH2EEEE0/_;b`9fMWH2820P0YbLW090@402UIFE0P`<30:?Shl2H61P0P0000Goool1
00000Oooo`002Oooo`030000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool00_oo
o`800002>SXj0UYJFP96ATH2j>SX0Xf=S@8k>c/2ATI60P0000:DU9@22PX:0XF5Q@9NGUh2I6AT0^?S
h`9@D502^KVi0SXj>P;Lg=`2Rh^;0QPH608j>SX2QXJ60ZZZZP:ATI42T92@0TQ8B08B4Q82dm?C0YJF
UP;Kfm/2YjNW0[Rh^099BDT2^KVi0]WIf@:WYjL2c<c<0XN7Q`861PH2@d=30X61P@8S8b<2CDe=0SPh
>09SHf<251@D0QhN7P8R8R82gmoO0STi>@:i^KT24A4A0VMWI`;1`L42>c/k0[jn_P8@4102R8R80Y^K
V`9jNWX2J6QX0WQhN09BDU800adM7IFEUIFEU@02EEEE0XJ6QP9iNGT2PH610SDe=@:b/[82LW9b0X:2
PP9gMgL2a<C40_ooo`9dM7@2`L710UIFEP8B4Q82fm_K0Z6QX@9/K6`2dm?C0VYZJP;Kfm/2MWIf0U]K
F`8820P4G5aL0SLg=`8k>c/220P80Xn?S`:BTY8200000XV9R@96ATH2n_[j0W1`L0;oool2e]KF0TE5
A@8m?Cd271`L0PP8208<30`2LW9b0]7Ad@9HF5P2J6QX0R`/;09kNg/2Lg=c0]7Ad@9RHV82CTi>0Wem
O@9^KVh2Ph>30[no_`8Y:BT2/;2`0V1PH0:c/k<2>3Ph1Oooo`400001oooo0009oooo00<0003oool0
00000_ooo`030000oooo000000Coool200000oooo`800002>SXj0UYJFP96ATH2j>SX0Xf=S@8k>c/2
ATI60P0000:DU9@22PX:0XF5Q@9NGUh2I6AT0^?Sh`9@D502^KVi0SXj>P;Lg=`2Rh^;0QPH608j>SX2
QXJ60ZZZZP:ATI42T92@0TQ8B08B4Q82dm?C0YJFUP;Kfm/2YjNW0[Rh^099BDT2^KVi0]WIf@:WYjL2
c<c<0XN7Q`861PH2@d=30X61P@8S8b<2CDe=0SPh>09SHf<251@D0QhN7P8R8R82gmoO0STi>@:i^KT2
4A4A0VMWI`;1`L42>c/k0[jn_P8@4102R8R80Y^KV`9jNWX2J6QX0WQhN09BDU800adM7IFEUIFEU@02
EEEE0XJ6QP9iNGT2PH610SDe=@:b/[82LW9b0X:2PP9gMgL2a<C40_ooo`9dM7@2`L710UIFEP8B4Q82
fm_K0Z6QX@9/K6`2dm?C0VYZJP;Kfm/2MWIf0U]KF`8820P4G5aL0SLg=`8k>c/220P80Xn?S`:BTY82
00000XV9R@96ATH2n_[j0W1`L0;oool2e]KF0TE5A@8m?Cd271`L0PP8208<30`2LW9b0]7Ad@9HF5P2
J6QX0R`/;09kNg/2Lg=c0]7Ad@9RHV82CTi>0WemO@9^KVh2Ph>30[no_`8Y:BT2/;2`0V1PH0:c/k<2
>3Ph1?ooo`800001oooo0009oooo0P0000?oool00`000?ooo`000004oooo00<0003oooooool00_oo
o`:k^k/2MGEe0RPX:0:SXj<2JVYZ0[no_`9fMWH2i^KV0_ooo`8I6AT2PX:20UADE0:NWYh2VYZJ0]KF
eP9BDU82>CTi0[bl_0::RXX2]kNg0Xj>SP9_Kfl2SHf=0ZZZZP8R8R82jNWY0XB4Q0:LW9`2VIVI0TQ8
B0:g]kL2G5aL0QTI6@;oool2emOG0XZ:RP8N7Qh2IfMW0P00009kNg/2;Rh^0_ooo`9eMGD2Kfm_0W1`
L0:5QHD2V9RH0P00009KFe/2a<C40WemO@9VIVH2Vi^K0VATI09DE5@2EEEE0VIVIP:^[Zh2S8b<0X>3
P`:FUYH2ADE50YjNWP8/;2`00hN7Qj>SXj>SX`026a/K0UmOG`:1PH42P8200VATI0;Kfm/2LW9b0X61
P@9iNGT2GemO0Y2@T0:UYJD2B4Q80Tm?C`8T92@2Ph>30/_;b`95ADD2LG5a0SPh>0:GUiL200000XZ:
RP9FEUH2S8b<0]3@d0;>c/h2Ng]k0UUIF@8X:2P25QHF0S@d=0:EUID2M7Ad0P0000;oool2kno_0Win
OP9dM7@2a/K60][JfP:n_[h2bl_;0^;RhP:SXj<2Ph>30W9bLP:KVi/2NWYj0VATI08a<C42OWin0Y2@
T0:TY:@2][Jf0[^k^`871`L2UiNG0PX:2P:>SXh2YZJV0V9RHPGoool100000Oooo`002Oooo`030000
oooooooo00;oool00`000?ooo`000004oooo00<0003oooooool00_ooo`:k^k/2MGEe0RPX:0:SXj<2
JVYZ0[no_`9fMWH2i^KV0_ooo`8I6AT2PX:20UADE0:NWYh2VYZJ0]KFeP9BDU82>CTi0[bl_0::RXX2
]kNg0Xj>SP9_Kfl2SHf=0ZZZZP8R8R82jNWY0XB4Q0:LW9`2VIVI0TQ8B0:g]kL2G5aL0QTI6@;oool2
emOG0XZ:RP8N7Qh2IfMW0P00009kNg/2;Rh^0_ooo`9eMGD2Kfm_0W1`L0:5QHD2V9RH0P00009KFe/2
a<C40WemO@9VIVH2Vi^K0VATI09DE5@2EEEE0VIVIP:^[Zh2S8b<0X>3P`:FUYH2ADE50YjNWP8/;2`0
0hN7Qj>SXj>SX`026a/K0UmOG`:1PH42P8200VATI0;Kfm/2LW9b0X61P@9iNGT2GemO0Y2@T0:UYJD2
B4Q80Tm?C`8T92@2Ph>30/_;b`95ADD2LG5a0SPh>0:GUiL200000XZ:RP9FEUH2S8b<0]3@d0;>c/h2
Ng]k0UUIF@8X:2P25QHF0S@d=0:EUID2M7Ad0P0000;oool2kno_0WinOP9dM7@2a/K60][JfP:n_[h2
bl_;0^;RhP:SXj<2Ph>30W9bLP:KVi/2NWYj0VATI08a<C42OWin0Y2@T0:TY:@2][Jf0[^k^`871`L2
UiNG0PX:2P:>SXh2YZJV0V9RHPGoool100000Oooo`002_ooo`800003oooo00<0003oooooool00ooo
o`030000oooooooo00;oool2S8b<0Va/K09hN7P2_Kfm0YNGU`;oool2;Bd]0Z^[Z`;oool2XJ6Q0W1`
L09eMGD2I6AT0XB4Q0;Zj^X2eMGE0T10@0:l_;`2EeMG0P0000;_knl2Q8B40W9bLP9jNWX2SHf=0PT9
2@9FEUH2IfMW0UmOG`9jNWX2Bd];0X61P@;oool2c<c<0QTI6@99BDT2RHV90Ve]K@;YjNT2_Kfm0YVI
V@9]KFd2oooo0W1`L0;Hf=P2T92@0WmoO`;IfMT2QHF50YFEU@:=SHd2V9RH0RPX:0:RXZ82WinO0TI6
AP;oool2P8200Vi^KP:SXj<2PX:20WemO@9QHF42UIFE00=SHf=GEeMGEeL00X20P0:<S8`2HV9R0UmO
G`9fMWH2T92@0X20P09lO7`2PH610U5AD@8a<C42R8R80ZNWY`;oool2PH610/O7a`9VIVH2J6QX0Z>S
X`:l_;`2KFe]0Y6AT@8];Bd2OWin0W=cL`:CTi<25QHF0Va/K0;3`l<2VIVI0]3@d0:;Rh/2HF5Q0_oo
o`9EEED2GemO0T=3@`;Ng]h2EUIF0]KFeP9@D502[Zj^0^GUi@9SHf<20`<30Sdm?@96ATH2e]KF0Q/K
6`9PH602WYjN0Y6AT@:6QXH2RXZ:0W]kN`:WYjL2TY:B0S8b<P8P8202<c<c0[Ng]`:QXJ45oooo0@00
007oool001Goool00`000?ooooooo`02oooo0Xb<S09/K6`2N7Qh0[fm_@:GUiL2oooo0Rd];@:[Zj/2
oooo0Z6QX@9`L702MGEe0VATI0:4Q8@2j^[Z0]GEe@90@402_;bl0UMGE`800002kno_0XB4Q09bLW82
NWYj0Xf=S@892@T2EUIF0VMWI`9OGel2NWYj0T];B`:1PH42oooo0/c<c08I6AT2BDU90XV9R@9]KFd2
jNWY0[fm_@:IVIT2KFe]0_ooo`9`L702f=SH0Y2@T09oOgl2fMWI0XF5Q@:EUID2SHf=0YRHV08X:2P2
XZ:R0YnOW`96ATH2oooo0X20P09^KVh2Xj>S0X:2PP9mOGd2HF5Q0YFEU@03Hf=SEeMGEeMG00:0P802
S8b<0V9RHP9OGel2MWIf0Y2@T0:0P802O7al0X61P@9ADE42<C4a0XR8R0:WYjL2oooo0X61P@;7alL2
IVIV0VQXJ0:SXj<2_;bl0Ve]K@:ATI42;Bd]0WinOP9cLg<2Ti>C0QHF5P9/K6`2`l?30YVIV@;@d=02
Rh^;0V5QH@;oool2EEEE0UmOG`93@d<2g]kN0UIFEP;Fe]H2D51@0Zj^[P;UiND2Hf=S0P<30`8m?Cd2
ATI60]KFeP8K6a/2H61P0YjNWP:ATI42QXJ60XZ:RP9kNg/2YjNW0Y:BTP8b<S82820P0S<c<`:g]kL2
XJ6Q1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`800002b<S80Rd];@8L71`2LW9b0Wem
O@:WYjL2FUYJ0P0000:_[jl2`l?30Xn?S`9dM7@2e]KF0[fm_@;GemL21`L70UaLG0:OWil2[Jf]0V=S
H`;Ph>02b<S80[Rh^09iNGT2BTY:0WMgM`9cLg<2KVi^0^KViP:CTi<230`<0P0000;kno/2oooo0/?3
``8T92@2^k^k0Ve]K@8410@2Ng]k0Z^[Z`9SHf<2HV9R0P0000810@42VIVI0_ooo`95ADD2@D510[Ng
]`8k>c/2YJFU0UmOG`:KVi/2Cdm?0YbLW09NGUh2@d=30SXj>P:6QXH2Cdm?0/30`08j>SX00iBDU::R
XZ:RXP02b/[:0U]KF`:HV9P2;bl_0[:b/P8/;2`2@d=30XZ:RP9gMgL2W9bL0Sdm?@9iNGT2Shn?0VQX
J09CDe<2cLg=0Ti>CP;AdM4220P80RXZ:P;8b<P2TY:B0V5QH@9OGel2a/K60V5QH@;IfMT2>SXj0UAD
E0:ZZZX2MgMg0V5QH@:4Q8@2UYJF0_ooo`9cLg<2WYjN0_ooo`9BDU82Ph>30U1@D09cLg<2_Kfm0UeM
G@;;bl/2F5QH0T92@P8k>c/2KVi^0Y6AT@9QHF42<30`0UeMG@9mOGd2PH610VMWI`9hN7P2UIFE0[2`
/09lO7`2@d=30XJ6QPGoool100000Oooo`005Oooo`030000oooooooo00;oool200000/S8b08];Bd2
71`L0W9bLP9mOGd2YjNW0UYJFP800002[jn_0/?3``:?Shl2M7Ad0]KFeP:m_Kd2emOG0PL71`9LG5`2
WinO0Zf][@9SHf<2h>3P0/S8b0:h^;P2NGUi0TY:BP9gMgL2Lg=c0Vi^KP;Vi^H2Ti>C0P`<30800002
no_k0_ooo`;3`l<292@T0[^k^`9]KFd210@40W]kN`:[Zj/2Hf=S0V9RHP8000020@410YVIV@;oool2
ADE50T51@@:g]kL2>c/k0ZFUY@9OGel2Vi^K0Tm?C`:LW9`2GUiN0T=3@`8j>SX2QXJ60Tm?C`;0`<02
>SXj00>DU9BRXZ:RXZ800/[:bP9KFe/2V9RH0Rl_;`:b/[82;2`/0T=3@`::RXX2MgMg0YbLW08m?Cd2
NGUi0Xn?S`9XJ6P2De=C0/g=c@9>CTh2dM7A0PP8208Z:RX2b<S80Y:BTP9QHF42GemO0/K6aP9QHF42
fMWI0SXj>P9DE5@2ZZZZ0WMgM`9QHF42Q8B40YJFUP;oool2Lg=c0YjNWP;oool2DU9B0X>3P`9@D502
Lg=c0[fm_@9MGEd2bl_;0UQHF092@T82>c/k0Vi^KP:ATI42HF5Q0S0`<09MGEd2OGem0X61P@9WIfL2
N7Qh0YFEU@:`/;02O7al0T=3@`:6QXH5oooo0@00007oool001Goool00`000?ooooooo`02oooo0YnO
W`92@T82NWYj0ZRXZ08I6AT2?clo0QLG5`9iNGT23@d=0R8R8P;Fe]H2clo?0W]kN`9EEED292@T0V9R
HP:_[jl2ZJVY0UQHF0:QXJ42K6a/0VEUI@;;bl/2a/K60P00008f=SH2YJFU0VYZJP:_[jl200000^k^
kP:CTi<2/K6a0]CDe09eMGD2N7Qh0P`<30:RXZ82Kfm_0RXZ:P8];Bd2[Zj^0W5aL@94A4@2jn_[0YZJ
VP9TI6@2Q8B40Xb<S0:i^KT2ATI60[:b/P:4Q8@2M7Ad0ZBTY0;Bd]82Q8B40YnOW`97AdL2NWYj0YBD
U098B4P2RXZ:0]GEe@03f=SH6a/K6a/K0099BDT29bLW0U=CD`8M7Ad200000Zf][@99BDT2j^[Z0UYJ
FP9gMgL200000W=cL`;1`L42Rh^;0Z6QX@9WIfL2N7Qh0Zb/[0:UYJD2h^;R0Rh^;P:j^[X2QXJ60X20
P0;1`L4200000XJ6QP;oool2AdM70WalO09GEeL2Ogmo0WEeM@;]kNd2_[jn0U=CD`;]kNd2EEEE0WMg
M`9eMGD2^;Rh0]3@d09MGEd2W9bL0YZJVP;>c/h2M7Ad0^_[j`B`/;02T92@0XV9R@9MGEd2NWYj0Wal
O09dM7@2N7Qh0Y>CT`8f=SH2Hf=S0Y:BTP9[Jf/5oooo0@00007oool001Goool00`000?ooooooo`02
oooo0YnOW`92@T82NWYj0ZRXZ08I6AT2?clo0QLG5`9iNGT23@d=0R8R8P;Fe]H2clo?0W]kN`9EEED2
92@T0V9RHP:_[jl2ZJVY0UQHF0:QXJ42K6a/0VEUI@;;bl/2a/K60P00008f=SH2YJFU0VYZJP:_[jl2
00000^k^kP:CTi<2/K6a0]CDe09eMGD2N7Qh0P`<30:RXZ82Kfm_0RXZ:P8];Bd2[Zj^0W5aL@94A4@2
jn_[0YZJVP9TI6@2Q8B40Xb<S0:i^KT2ATI60[:b/P:4Q8@2M7Ad0ZBTY0;Bd]82Q8B40YnOW`97AdL2
NWYj0YBDU098B4P2RXZ:0]GEe@03f=SH6a/K6a/K0099BDT29bLW0U=CD`8M7Ad200000Zf][@99BDT2
j^[Z0UYJFP9gMgL200000W=cL`;1`L42Rh^;0Z6QX@9WIfL2N7Qh0Zb/[0:UYJD2h^;R0Rh^;P:j^[X2
QXJ60X20P0;1`L4200000XJ6QP;oool2AdM70WalO09GEeL2Ogmo0WEeM@;]kNd2_[jn0U=CD`;]kNd2
EEEE0WMgM`9eMGD2^;Rh0]3@d09MGEd2W9bL0YZJVP;>c/h2M7Ad0^_[j`B`/;02T92@0XV9R@9MGEd2
NWYj0WalO09dM7@2N7Qh0Y>CT`8f=SH2Hf=S0Y:BTP9[Jf/5oooo0@00007oool001Goool00`000?oo
ooooo`02oooo0V5QH@:0P802Kfm_0WEeM@9RHV82MgMg0S/k>`9ZJVX2HV9R0^o_k`9NGUh2KVi^0Va/
K09QHF42RXZ:0UIFEP9hN7P2P8200_ooo`;0`<0200000/c<c09aLG42ZJVY0V][J`9>CTh2Rh^;0Xj>
SP9oOgl2fm_K0/S8b09<C4`2@T920WEeM@9dM7@2QHF50U9BDP;5aLD2N7Qh0Xj>SP8A4A42;bl_0Wem
O@9UIFD2IfMW0UaLG0;8b<P2Ng]k0_;blP9;Bd/2Fe]K0TA4A0:UYJD2^[Zj0W1`L09mOGd2WIfM0S8b
<P;oool2S8b<0Xj>SP9QHF42SXj>0XR8R003J6QXZZZZZZZZ0094A4@2oooo0[no_`9^KVh2P8200[2`
/09dM7@2P8200WQhN0:5QHD2QhN70Z2PX08T92@2Rh^;0VQXJ0:5QHD2NGUi0X20P0:8R8P2GEeM0P00
00;De=@2BTY:0[>c/`:@T902MGEe0WalO09oOgl2XZ:R0Vi^KP;gmoL2]KFe0TU9B@:f][H2YJFU0X61
P@:3Ph<2BTY:0[Jf]P::RXX2S8b<0TI6AP:?Shl2Rh^;0V5QH@:JVYX261PH0W9bLP:ZZZX2Y:BT0S/k
>`:3Ph<2HV9R0X>3P`9WIfL24A4A0WalO0;oool2d=3@0Xj>SP;oool2HF5Q1Oooo`400001oooo000E
oooo0P0000?oool2HF5Q0X20P09_Kfl2MGEe0V9RHP9gMgL2>c/k0VYZJP9RHV82kno_0UiNGP9^KVh2
K6a/0V5QH@::RXX2EUIF0WQhN0:0P802oooo0/30`0800002c<c<0W5aL@:YZJT2Jf][0Ti>CP:;Rh/2
SXj>0WmoO`;Kfm/2b<S80Ta<C092@T82MGEe0WAdM0:5QHD2DU9B0/G5a@9hN7P2SXj>0Q4A4@8_;bl2
OGem0VEUI@9WIfL2G5aL0/S8b09kNg/2l_;b0T];B`9KFe/2A4A40ZFUY@:j^[X2L71`0WemO@:MWId2
<S8b0_ooo`:<S8`2SXj>0V5QH@:>SXh2R8R800=XJ6RZZZZZZZX00TA4A0;oool2_kno0Vi^KP:0P802
/;2`0WAdM0:0P802N7Qh0XF5Q@:7QhL2X:2P0R@T90:;Rh/2J6QX0XF5Q@9iNGT2P8200XR8R09MGEd2
00000]CDe09:BTX2/k>c0Y2@T09eMGD2O7al0WmoO`:RXZ82KVi^0_Ogm`:e]KD2BDU90[Jf]P:UYJD2
PH610X>3P`9:BTX2][Jf0XZ:RP:<S8`2ATI60Xn?S`:;Rh/2HF5Q0YZJVP8H61P2LW9b0ZZZZP:TY:@2
>c/k0X>3P`9RHV82Ph>30VMWI`8A4A42O7al0_ooo`;@d=02SXj>0_ooo`9QHF44oooo0P00007oool0
01Goool00`000?ooooooo`02oooo0Te=C@:_[jl2TI6A0T92@P:YZJT2m?Cd0WAdM0:=SHd2BTY:0T=3
@`9SHf<2JVYZ0Vm_K`9bLW82OWin0XR8R08E5AD2Cdm?0Y:BTP:ATI42oooo0Z>SX`:NWYh2Ti>C0Z^[
Z`:l_;`27alO0]SHf09QHF4200000YfMW@;8b<P2NWYj0ZJVYP:TY:@2=3@d0ZNWY`8Y:BT2GemO0U5A
D@:MWId2a/K60YVIV@9jNWX2EUIF0[Zj^P9GEeL2T92@0Rd];@:i^KT2_[jn0YfMW@9>CTh2X:2P0_[j
nP;Cdm<2inOW0Xj>SP9SHf<2GUiN0X^;R`9ZJVX2H61P0UIFEP03P820FEUIFEUI00:XZ:P2kno_0V=S
H`:9RHT2IVIV0[2`/09iNGT2OGem0X:2PP9MGEd2DU9B0TY:BP9iNGT2NWYj0ZFUY@9QHF42RXZ:0W]k
N`8U9BD21PH60UADE09mOGd2KFe]0UeMG@8/;2`2TI6A0WinOP9PH602CDe=0/G5a@::RXX2KVi^0UEE
E@:4Q8@2Jf][0W1`L0:2PX82BTY:0V=SH`:][Jd2oooo0UIFEP8I6AT2M7Ad0YFEU@9ZJVX2M7Ad0YfM
W@8>3Ph2B4Q80XB4Q09eMGD2A4A40X61P@:7QhL26ATI0UADE08W9bL26a/K0R@T908n?Sh2PH611Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`9=CDd2[jn_0Y6AT@92@T82ZJVY0_Cdm09dM7@2
SHf=0TY:BP93@d<2Hf=S0VYZJP9_Kfl2LW9b0WinOP:8R8P25ADE0Tm?C`:BTY82TI6A0_ooo`:SXj<2
WYjN0Y>CT`:[Zj/2_;bl0QlO7`;Hf=P2HF5Q0P0000:MWId2b<S80WYjNP:VYZH2Y:BT0S@d=0:WYjL2
:BTY0UmOG`9ADE42WIfM0/K6aP:IVIT2NWYj0UIFEP:j^[X2EeMG0Y2@T08];Bd2^KVi0[jn_P:MWId2
CTi>0Z2PX0;jn_X2dm?C0^OWi`:>SXh2Hf=S0UiNGP:;Rh/2JVYZ0V1PH09FEUH00h20P5UIFEUIF@02
Z:RX0^o_k`9SHf<2RHV90VIVIP:`/;02NGUi0WemO@:2PX82GEeM0U9BDP9:BTX2NGUi0WYjNP:UYJD2
HF5Q0XZ:RP9kNg/29BDU0PH61P9DE5@2OGem0Ve]K@9MGEd2;2`/0Y6AT@9nOWh2H61P0Te=C@;5aLD2
RXZ:0Vi^KP9EEED2Q8B40V][J`9`L702PX:20TY:BP9SHf<2[Jf]0_ooo`9FEUH26ATI0WAdM0:EUID2
JVYZ0WAdM0:MWId23Ph>0TQ8B0:4Q8@2MGEe0TA4A0:1PH42QhN70QTI6@9DE5@29bLW0Q/K6`8T92@2
?Shn0X61P@Goool100000Oooo`005Oooo`030000oooooooo00;oool2I6AT0T51@@:c/k<2Xj>S0]OG
e`9XJ6P2FUYJ0WEeM@9gMgL2IVIV0WMgM`9=CDd2Hf=S0U5AD@9HF5P2WIfM0XF5Q@9ZJVX2Bd];0X61
P@8j>SX2N7Qh0XR8R0:9RHT2[Jf]0Tm?C`9ADE42BDU90V=SH`:GUiL2TY:B0YVIV@:BTY82]kNg0SDe
=@:=SHd2MWIf0VATI0:d];@2OWin0ZRXZ09NGUh2oooo0UaLG0:9RHT2b/[:0S@d=09SHf<2Ph>30WIf
MP9YJFT2=CDe0Xf=S@9^KVh2G5aL0S@d=09MGEd2i>CT0ZRXZ09=CDd2UIFE0WIfMP9GEeL2LW9b00<0
001dM7AdM7@00P0000:GUiL2PH610WYjNP:f][H2U9BD0WalO09jNWX2Ph>30UIFEP:BTY82/K6a0W1`
L0:CTi<24Q8B0R<S8`:5QHD2VYZJ0Vm_K`:BTY82Ph>30W=cL`95ADD2Ti>C0ZZZZP9EEED2QHF50VMW
I`8Q8B42QXJ60P0000;Ph>02PH610/30`0;?cll2SXj>0W9bLP:5QHD2/[:b0X>3P`8D51@2WIfM0WEe
M@:6QXH2IFEU0Rl_;`:g]kL2A4A40WemO@9nOWh2U9BD0YNGU`:g]kL2MWIf0YRHV09gMgL271`L0RHV
9P9GEeL2bl_;0TY:BP;Lg=`5oooo0@00007oool001Goool00`000?ooooooo`02oooo0VATI091@D42
/k>c0Z>SX`;GemL2J6QX0UYJFP9eMGD2MgMg0VIVIP9gMgL2CDe=0V=SH`9ADE42F5QH0YfMW@:5QHD2
JVYZ0T];B`:1PH42>SXj0WQhN0:8R8P2RHV90Zf][@9?Cdl2DE5A0TU9B@9SHf<2UiNG0Y:BTP:IVIT2
TY:B0[Ng]`8e=CD2SHf=0WIfMP9TI6@2];Bd0WinOP:XZ:P2GUiN0_ooo`9LG5`2RHV90/[:bP8d=3@2
Hf=S0X>3P`9fMWH2JFUY0SDe=@:=SHd2KVi^0UaLG08d=3@2GEeM0^CTi0:XZ:P2CDe=0YFEU@9fMWH2
EeMG0W9bLP030000M7AdM7Ad00800002UiNG0X61P@9jNWX2][Jf0YBDU09lO7`2NWYj0X>3P`9FEUH2
TY:B0[6a/@9`L702Ti>C0Q8B4P8S8b<2QHF50YZJVP9_Kfl2TY:B0X>3P`9cLg<2ADE50Y>CT`:ZZZX2
EEEE0XF5Q@9WIfL28B4Q0XJ6QP800002h>3P0X61P@;0`<02clo?0Xj>SP9bLW82QHF50[:b/P:3Ph<2
51@D0YfMW@9eMGD2QXJ60VEUI@8_;bl2]kNg0TA4A09mOGd2OWin0YBDU0:GUiL2]kNg0WIfMP:HV9P2
MgMg0Q`L708V9RH2EeMG0/_;b`9:BTX2g=cL1Oooo`400001oooo000Eoooo00<0003oooooool00_oo
o`:DU9@2DE5A0S0`<09;Bd/2Fe]K0_ooo`:CTi<2NWYj0[Jf]P:UYJD2[jn_0X61P@9VIVH2CDe=0X61
P@9cLg<2Q8B40Vm_K`9ADE42Ti>C0^GUi@9lO7`2;Bd]0[jn_P:CTi<2][Jf0[Bd]0;Hf=P2@4100/c<
c09mOGd2bLW90TY:BP:5QHD2Shn?0VATI09nOWh2?Shn0/71`@:_[jl2Hf=S0Slo?`90@402Shn?0UAD
E09?Cdl2i^KV0_ooo`;:b/X2Lg=c0VEUI@8n?Sh2@T920S0`<09TI6@2WIfM0Ti>CP9gMgL2<C4a0]3@
d0:2PX82D51@0V5QH@:][Jd00e5AD@0000000002i>CT0Rl_;`9jNWX2Ogmo0TI6AP;alO42LG5a0X61
P@9nOWh2BTY:0VQXJ09TI6@2S8b<0UeMG@:0P80400000UMGE`:l_;`21PH60YBDU09@D502_Kfm0Xj>
SP9@D502/[:b0[>c/`9YJFT27AdM0WYjNP:QXJ42Bd];0VMWI`9`L702[Zj^0WYjNPB>SXh2O7al0Z6Q
X@;4a<@4WYjN0Z^[Z`8m?Cd2Cdm?0_ooo`;?cll2JFUY0WAdM0:][Jd2NWYj0Shn?P:0P802TI6A0R8R
8P:h^;P2Shn?0/?3``9UIFD2JVYZ0VUYJ@Goool100000Oooo`005Oooo`030000oooooooo00;oool2
U9BD0U5AD@8`<302Bd];0U]KF`;oool2Ti>C0WYjNP:f][H2YJFU0Zn_[`:1PH42IVIV0Te=C@:1PH42
Lg=c0XB4Q09_Kfl2DE5A0Y>CT`;UiND2O7al0Rd];@:n_[h2Ti>C0[Jf]P:d];@2f=SH0T10@0;<c<`2
OGem0/W9b@9:BTX2QHF50Xn?S`9TI6@2OWin0Shn?P;1`L42[jn_0V=SH`8o?cl2@4100Xn?S`9DE5@2
Cdm?0^KViP;oool2b/[:0W=cL`9UIFD2?Shn0T92@P8`<302I6AT0YfMW@9>CTh2MgMg0S4a<@;@d=02
PX:20U1@D09QHF42[Jf]00=ADE40000000000^CTi08_;bl2NWYj0WmoO`96ATH2lO7a0W5aL@:1PH42
OWin0TY:BP9XJ6P2I6AT0Xb<S09MGEd2P8201000009GEeL2_;bl0PH61P:DU9@2D51@0[fm_@:>SXh2
D51@0[:b/P:c/k<2JFUY0QdM7@9jNWX2XJ6Q0T];B`9WIfL2L71`0Zj^[P9jNWX4SXj>0WalO0:QXJ42
a<C419jNWP:[Zj/2?Cdm0Tm?C`;oool2clo?0VUYJ@9dM7@2[Jf]0WYjNP8n?Sh2P8200Y6AT@8R8R82
^;Rh0Xn?S`;3`l<2IFEU0VYZJP9YJFT5oooo0@00007oool001Goool00`000?ooooooo`02oooo0TQ8
B0:9RHT2<30`0X>3P`9YJFT2oooo0Y>CT`;fm_H2D51@0T=3@`800002Ng]k0WMgM`94A4@2_[jn0Y6A
T@9HF5P2?Shn0Xn?S`9`L702;Bd]0T51@@:4Q8@2/[:b0Y>CT`;no_h2SHf=0Tm?C`9DE5@2PH610VEU
I@9[Jf/2@4100XZ:RP9/K6`2Y:BT0X^;R`;3`l<2T92@0T92@P9kNg/2P8200Te=C@:OWil2Ogmo0WYj
NP9fMWH2Cdm?0TU9B@:b/[82Ng]k0/[:bP:][Jd2KFe]0WinOP9IFET2X:2P0T];B`;6a/H2VYZJ0Wem
O@9TI6@2Cdm?0UeMG@03clo?/;2`/;2`00A<C4`2R8R80WalO097AdL2[:b/0WIfMP9kNg/2R8R80QlO
7`800002QhN70WalO09?Cdl2AdM70[Vi^@94A4@2JFUY0]GEe@:5QHD2K6a/0YBDU097AdL2Shn?0Ve]
K@99BDT2UYJF0P0000:LW9`2NGUi0/?3``:HV9P2F5QH0Xn?S`:b/[82M7Ad0WQhN0;MgMd2H61P0VQX
J0:3Ph<2@4100X:2PP:`/;027alO0Zn_[`:@T902N7Qh0WinOP:8R8P2;Rh^0/71`@:CTi<2EEEE0^g]
k@9MGEd200000VQXJ09YJFT2QHF50^3Ph0:DU9@5oooo0@00007oool001Goool00`000?ooooooo`02
oooo0TQ8B0:9RHT2<30`0X>3P`9YJFT2oooo0Y>CT`;fm_H2D51@0T=3@`800002Ng]k0WMgM`94A4@2
_[jn0Y6AT@9HF5P2?Shn0Xn?S`9`L702;Bd]0T51@@:4Q8@2/[:b0Y>CT`;no_h2SHf=0Tm?C`9DE5@2
PH610VEUI@9[Jf/2@4100XZ:RP9/K6`2Y:BT0X^;R`;3`l<2T92@0T92@P9kNg/2P8200Te=C@:OWil2
Ogmo0WYjNP9fMWH2Cdm?0TU9B@:b/[82Ng]k0/[:bP:][Jd2KFe]0WinOP9IFET2X:2P0T];B`;6a/H2
VYZJ0WemO@9TI6@2Cdm?0UeMG@03clo?/;2`/;2`00A<C4`2R8R80WalO097AdL2[:b/0WIfMP9kNg/2
R8R80QlO7`800002QhN70WalO09?Cdl2AdM70[Vi^@94A4@2JFUY0]GEe@:5QHD2K6a/0YBDU097AdL2
Shn?0Ve]K@99BDT2UYJF0P0000:LW9`2NGUi0/?3``:HV9P2F5QH0Xn?S`:b/[82M7Ad0WQhN0;MgMd2
H61P0VQXJ0:3Ph<2@4100X:2PP:`/;027alO0Zn_[`:@T902N7Qh0WinOP:8R8P2;Rh^0/71`@:CTi<2
EEEE0^g]k@9MGEd200000VQXJ09YJFT2QHF50^3Ph0:DU9@5oooo0@00007oool001Goool00`000?oo
ooooo`02oooo0UmOG`9TI6@2<c<c0Va/K08H61P2DU9B0Zj^[P9/K6`2bLW90VQXJ08[:b/2Ti>C0XN7
Q`:>SXh2EEEE0UQHF0;oool2Jf][0UUIF@8/;2`2410@0]oOg`9GEeL2C4a<0YFEU@;AdM42][Jf0VMW
I`:TY:@2R8R80Z:RXP:=SHd2820P0P00008U9BD2BDU90UeMG@:^[Zh2Bd];0U]KF`:_[jl2aLG50S/k
>`9KFe/2GemO0_knoP::RXX2GUiN0Xb<S09@D502UYJF0S<c<`9aLG42MgMg0V1PH0800002UIFE0P00
009DE5@2EeMG0Vi^KP:YZJT4E5AD00?Bd];oooooool00TE5A@:6QXH2NGUi0WIfMP;2`/8251@D0XR8
R09cLg<2QXJ60U9BDP:3Ph<2U9BD0Ti>CP8_;bl2[Jf]0X:2PP9oOgl2h^;R0Q/K6`9MGEd2fm_K0XR8
R09iNGT2oooo0Z2PX0:^[Zh2EeMG0ZZZZP;<c<`2Kfm_0Tm?C`:FUYH2T92@0UIFEP9iNGT2Q8B40]_K
f`:7QhL2;Rh^0QdM7@9:BTX2/;2`0]3@d0:6QXH2DE5A0TM7A`:XZ:P2W9bL0WAdM09jNWX2ADE50V9R
HP9;Bd/200000Xf=S@9TI6@2IFEU0YnOW`;Ng]h2:RXZ0/O7a`:][Jd5oooo0@00007oool001Goool2
00000oooo`9OGel2I6AT0S<c<`9/K6`261PH0U9BDP:^[Zh2K6a/0/W9b@9XJ6P2:b/[0Y>CT`:7QhL2
SXj>0UEEE@9HF5P2oooo0V][J`9IFET2;2`/0Q0@40;Ogml2EeMG0Ta<C0:EUID2dM7A0[Jf]P9WIfL2
Y:BT0XR8R0:RXZ82SHf=0R0P808000029BDU0TU9B@9MGEd2[Zj^0T];B`9KFe/2[jn_0/G5a@8k>c/2
Fe]K0UmOG`;no_h2RXZ:0UiNGP:<S8`2D51@0YJFUP8c<c<2LG5a0WMgM`9PH60200000YFEU@800002
E5AD0UMGE`9^KVh2ZJVY15ADE003d];Boooooooo0095ADD2QXJ60WUiN@9fMWH2`/;20Q@D50:8R8P2
Lg=c0XJ6QP9BDU82Ph>30YBDU09>CTh2;bl_0Zf][@:2PX82Ogmo0^;RhP8K6a/2GEeM0]_Kf`:8R8P2
NGUi0_ooo`:PX:02[Zj^0UMGE`:ZZZX2c<c<0Vm_K`9?Cdl2UYJF0Y2@T09FEUH2NGUi0XB4Q0;Kfm/2
QhN70Rh^;P8M7Ad2BTY:0[2`/0;@d=02QXJ60U5AD@97AdL2Z:RX0YbLW09dM7@2NWYj0TE5A@9RHV82
Bd];0P0000:=SHd2I6AT0VEUI@:OWil2g]kN0RXZ:P;7alL2[Jf]1?ooo`800001oooo000Eoooo00<0
003oooooool00_ooo`9CDe<2RXZ:0Ve]K@:BTY82V9RH0ZVYZ@:b/[82Q8B40WQhN08X:2P2BDU90Zf]
[@:a/K42ATI60^OWi`9>CTh2Shn?0R`/;09ZJVX2FUYJ0YJFUP:LW9`2IVIV0Tm?C`800002RXZ:0S4a
<@:8R8P2Kfm_0[:b/P90@402ADE50UiNGP:XZ:P27QhN0_ooo`;Zj^X2[jn_0VIVIPBHV9P2PH610YRH
V0:<S8`2VIVI0Xj>SP9hN7P2;Rh^0YFEU@:2PX82OGem0YfMW@:JVYX2n?Sh0U9BDP8^;Rh261PH0STi
>@8S8b<2MgMg0UYJFP:LW9`2[jn_0S`l?0039BDU92@T92@T008U9BD2ZJVY0W1`L09nOWh2L71`0Q@D
50:3Ph<2N7Qh0WYjNP:5QHD2>CTi0^c/k09EEED2f=SH0X>3P`:n_[h2clo?0TU9B@9RHV82KFe]0Q@D
50AmOGd2fm_K0P00008k>c/2Jf][0XN7Q`9kNg/2]KFe0VMWI`9FEUH2Ng]k0XV9R@:e]KD2Cdm?0Q0@
40:RXZ82o_kn0W5aL@9dM7@2WIfM0WYjNP:BTY82MGEe0TQ8B08B4Q82LG5a0WUiN@:DU9@2ZJVY0WQh
N09gMgL2bLW90YJFUP9HF5P2H61P0SLg=`8=3@d2GUiN0Q@D50;Zj^X5oooo0@00007oool001Goool0
0`000?ooooooo`02oooo0U=CD`::RXX2KFe]0Y:BTP:HV9P2ZJVY0[:b/P:4Q8@2N7Qh0RPX:099BDT2
[Jf]0[6a/@96ATH2inOW0Ti>CP:?Shl2;2`/0VYZJP9JFUX2UYJF0YbLW09VIVH2Cdm?0P0000::RXX2
<C4a0XR8R09_Kfl2/[:b0T10@095ADD2GUiN0ZRXZ08N7Qh2oooo0^[ZjP:_[jl2IVIV19RHV0:1PH42
V9RH0Xb<S0:IVIT2SXj>0WQhN08^;Rh2UIFE0X:2PP9mOGd2WIfM0YZJVP;hn?P2DU9B0Rh^;P8H61P2
>CTi0R<S8`9gMgL2FUYJ0YbLW0:_[jl2?3`l00<U9BDT92@T92@00RDU9@:YZJT2L71`0WinOP9`L702
51@D0X>3P`9hN7P2NWYj0XF5Q@8i>CT2k>c/0UEEE@;Hf=P2Ph>30[jn_P;?cll2BDU90V9RHP9]KFd2
51@D17emO@;Kfm/200000S/k>`9[Jf/2QhN70W]kN`:e]KD2IfMW0UIFEP9kNg/2RHV90[Fe]@9?Cdl2
410@0Z:RXP;no_h2LG5a0WAdM0:MWId2NWYj0Y:BTP9eMGD2B4Q80Q8B4P9aLG42NGUi0YBDU0:YZJT2
N7Qh0WMgM`;9bLT2UYJF0UQHF09PH602=cLg0Pd=3@9NGUh251@D0^[ZjPGoool100000Oooo`005Ooo
o`030000oooooooo00;oool2Ogmo0VYZJP8l?3`2<C4a0Y6AT@:HV9P2?clo0XJ6QP:8R8P2g=cL0UAD
E09YJFT2J6QX0VEUI@:PX:02?Shn0W=cL`:DU9@2oooo0X>3P`:LW9`2H61P0SDe=@:WYjL2UIFE0X^;
R`9gMgL2k^k^0Va/K0:HV9P2][Jf0/30`0;9bLT2O7al0WinOP9XJ6P2RHV90U=CD`800002XZ:R0XZ:
RP:ATI42Kfm_0XJ6QP::RXX2FEUI0TE5A@9YJFT2oooo0WinOP:9RHT2ZJVY0Y^KV`:2PX82=3@d0YNG
U`8h>3P2/;2`0TU9B@:>SXh2RHV90VUYJ@9jNWX2e]KF00=^KVk]kNg]kNd00X^;R`:3Ph<2N7Qh0Wem
O@9nOWh2^k^k0WMgM`9oOgl2NGUi0X20P09HF5P2GUiN0UIFEP;fm_H200000Y6AT@:4Q8@2NWYj0X>3
P`:<S8`2GEeM0X:2PP9SHf<2U9BD0R4Q8@8M7Ad2OWin0Y:BTP:6QXH2];Bd0V5QH@9`L702PH610Z6Q
X@9kNg/2dM7A0W=cL`90@402oooo0^[ZjP98B4P28b<S0W]kN`;=cLd4oooo0VMWI`:BTY82IVIV0^GU
i@:4Q8@2B4Q80WAdM09_Kfl2GUiN0T];B`;oool2[jn_0XF5Q@9[Jf/2QXJ60/[:bPGoool100000Ooo
o`005Oooo`030000oooooooo00;oool2Ogmo0VYZJP8l?3`2<C4a0Y6AT@:HV9P2?clo0XJ6QP:8R8P2
g=cL0UADE09YJFT2J6QX0VEUI@:PX:02?Shn0W=cL`:DU9@2oooo0X>3P`:LW9`2H61P0SDe=@:WYjL2
UIFE0X^;R`9gMgL2k^k^0Va/K0:HV9P2][Jf0/30`0;9bLT2O7al0WinOP9XJ6P2RHV90U=CD`800002
XZ:R0XZ:RP:ATI42Kfm_0XJ6QP::RXX2FEUI0TE5A@9YJFT2oooo0WinOP:9RHT2ZJVY0Y^KV`:2PX82
=3@d0YNGU`8h>3P2/;2`0TU9B@:>SXh2RHV90VUYJ@9jNWX2e]KF00=^KVk]kNg]kNd00X^;R`:3Ph<2
N7Qh0WemO@9nOWh2^k^k0WMgM`9oOgl2NGUi0X20P09HF5P2GUiN0UIFEP;fm_H200000Y6AT@:4Q8@2
NWYj0X>3P`:<S8`2GEeM0X:2PP9SHf<2U9BD0R4Q8@8M7Ad2OWin0Y:BTP:6QXH2];Bd0V5QH@9`L702
PH610Z6QX@9kNg/2dM7A0W=cL`90@402oooo0^[ZjP98B4P28b<S0W]kN`;=cLd4oooo0VMWI`:BTY82
IVIV0^GUi@:4Q8@2B4Q80WAdM09_Kfl2GUiN0T];B`;oool2[jn_0XF5Q@9[Jf/2QXJ60/[:bPGoool1
00000Oooo`005Oooo`030000oooooooo00Coool2j^[Z0VQXJ0:<S8`2<30`0U]KF`8Q8B42oooo0P00
009JFUX2Zj^[0XR8R0:3Ph<2[Zj^0TY:BP:XZ:P2I6AT0YFEU@:WYjL2oooo0STi>@9dM7@2ZZZZ0UYJ
FP:DU9@2RHV90[6a/@9/K6`2Q8B40TI6AP:`/;0200000YBDU09jNWX2YjNW0/o?c`;MgMd2Zj^[0]OG
e`:0P802c<c<0[bl_09/K6`2IVIV0[:b/P:DU9@2K6a/0YnOW`:k^k/200000UADE09CDe<2h^;R0UMG
E`9ADE42IfMW0U]KF`8R8R82SHf=0Vi^KP9aLG42SXj>0W]kN`:FUYH00cdm?F=SHf=SH`02KFe]17in
OP9oOgl2O7al0Ti>CP:0P802NWYj0WalO0:4Q8@2R8R80YVIV@800002no_k0Sdm?@8T92@2];Bd0YjN
WP9FEUH2U9BD0[Jf]P9nOWh2:RXZ0[:b/P:f][H2[jn_0^3Ph0892@T2Lg=c0YjNWP:WYjL2IVIV0X:2
PP:HV9P2TY:B0XF5Q@9fMWH2/;2`0[Bd]09WIfL2ATI60_ooo`9^KVh2De=C0WmoO`800002Shn?0QhN
7P;:b/X2a<C40YRHV0:QXJ42=3@d0WIfMP:7QhL2Ogmo0Te=C@9QHF42G5aL0[Fe]@9bLW82GUiN1Ooo
o`400001oooo000Eoooo00<0003oooooool01?ooo`;Zj^X2J6QX0Xb<S08`<302Fe]K0R4Q8@;oool2
00000UYJFP:[Zj/2R8R80X>3P`:^[Zh2BTY:0ZRXZ09TI6@2UIFE0ZNWY`;oool2>CTi0WAdM0:ZZZX2
FUYJ0YBDU0:9RHT2/K6a0Va/K0:4Q8@2ATI60[2`/0800002U9BD0WYjNP:WYjL2clo?0]gMg@:[Zj/2
emOG0X20P0;<c<`2_;bl0Va/K09VIVH2/[:b0YBDU09/K6`2WinO0[^k^`800002E5AD0U=CD`;Rh^82
EeMG0U5AD@9WIfL2Fe]K0R8R8P:=SHd2KVi^0W5aL@:>SXh2Ng]k0YJFUP03?CdmHf=SHf=S009]KFd4
OWin0WmoO`9lO7`2CTi>0X20P09jNWX2O7al0XB4Q0:8R8P2VIVI0P0000;kno/2?Cdm0R@T90:d];@2
WYjN0UIFEP:DU9@2][Jf0WinOP8Z:RX2/[:b0[Jf]P:_[jl2h>3P0PT92@9cLg<2WYjN0ZNWY`9VIVH2
PX:20YRHV0:BTY82QHF50WIfMP:`/;02];Bd0VMWI`96ATH2oooo0Vi^KP9CDe<2Ogmo0P0000:?Shl2
7QhN0/[:bP;4a<@2V9RH0Z6QX@8d=3@2MWIf0XN7Q`9oOgl2CDe=0V5QH@9LG5`2]KFe0W9bLP9NGUh5
oooo0@00007oool001Goool00`000?ooooooo`02oooo0]kNgP9lO7`2?3`l0]?Cd`9]KFd29RHV0_oo
o`8b<S82jn_[0VATI09JFUX2NGUi0Zn_[`:EUID2^k^k0Xn?S`9]KFd2^;Rh0ZZZZP9EEED2=cLg0ZFU
Y@9gMgL2U9BD0S4a<@:o_kl2h>3P0P0000;5aLD2[Jf]0Y2@T0:0P802ZJVY0Rl_;`;3`l<2HV9R0]GE
e@96ATH2I6AT0/S8b0:FUYH2/k>c0Z:RXPBd];@2d=3@0U]KF`99BDT24Q8B0PT92@8[:b/2l?3`0R`/
;0:@T902@d=30Y6AT@9OGel2Ti>C0X:2PP9kNg/2P8200W1`L09mOGd2oooo00?no_imOGemOGd00XR8
R0AiNGT2Jf][0X20P09dM7@4Ng]k0WYjNP8l?3`2KFe]0X>3P`;oool2c/k>0_ooo`:g]kL4oooo0TA4
A09LG5`2MGEe0[Zj^P:<S8`2XJ6Q0V9RHP:3Ph<26a/K0Z6QX@:o_kl2NGUi0Xn?S`9IFET2OGem0/K6
aP:LW9`2/;2`0[:b/P9hN7P2kNg]0YNGU`9nOWh2Lg=c0VUYJ@9GEeL2820P0UmOG`93@d<2g]kN0Ve]
K@8l?3`2PX:20V][J`8;2`/2R8R80W5aL@9nOWh2JVYZ0WQhN09;Bd/2a/K60_ooo`9WIfL5oooo0@00
007oool001Goool00`000?ooooooo`02oooo0]kNgP9lO7`2?3`l0]?Cd`9]KFd29RHV0_ooo`8b<S82
jn_[0VATI09JFUX2NGUi0Zn_[`:EUID2^k^k0Xn?S`9]KFd2^;Rh0ZZZZP9EEED2=cLg0ZFUY@9gMgL2
U9BD0S4a<@:o_kl2h>3P0P0000;5aLD2[Jf]0Y2@T0:0P802ZJVY0Rl_;`;3`l<2HV9R0]GEe@96ATH2
I6AT0/S8b0:FUYH2/k>c0Z:RXPBd];@2d=3@0U]KF`99BDT24Q8B0PT92@8[:b/2l?3`0R`/;0:@T902
@d=30Y6AT@9OGel2Ti>C0X:2PP9kNg/2P8200W1`L09mOGd2oooo00?no_imOGemOGd00XR8R0AiNGT2
Jf][0X20P09dM7@4Ng]k0WYjNP8l?3`2KFe]0X>3P`;oool2c/k>0_ooo`:g]kL4oooo0TA4A09LG5`2
MGEe0[Zj^P:<S8`2XJ6Q0V9RHP:3Ph<26a/K0Z6QX@:o_kl2NGUi0Xn?S`9IFET2OGem0/K6aP:LW9`2
/;2`0[:b/P9hN7P2kNg]0YNGU`9nOWh2Lg=c0VUYJ@9GEeL2820P0UmOG`93@d<2g]kN0Ve]K@8l?3`2
PX:20V][J`8;2`/2R8R80W5aL@9nOWh2JVYZ0WQhN09;Bd/2a/K60_ooo`9WIfL5oooo0@00007oool0
01Goool00`000?ooooooo`02oooo0]kNgP;Ti>@2[Zj^0WmoO`800002>c/k0XB4Q0@00002IfMW0XB4
Q0:LW9`2L71`0R0P808^;Rh2EEEE0S<c<`9mOGd2oooo0[2`/09QHF42W9bL0SPh>09oOgl2P8200XJ6
QP:8R8P2WYjN0_7al@9QHF42Y:BT0P0000;?cll2dM7A0P@4109=CDd2YjNW0U]KF`:i^KT2S8b<0TI6
AP8i>CT2Hf=S0YbLW09EEED2DE5A0T];B`9ZJVX2Cdm?0[6a/@;emOD2QhN70XB4Q08`<302oooo0RHV
9P9RHV82TY:B0UIFEP8n?Sh2IVIV0XV9R@9QHF42IFEU00=<C4aFEUIFEUH00YNGU`:JVYX2ZZZZ0_7a
l@9WIfL2RXZ:0XB4Q09hN7P2P8200WIfMP:ZZZX2MgMg0Y2@T09VIVH2FUYJ0X61P@800002T92@0Y^K
V`:RXZ82HF5Q0Tm?C`:/[:`2lo?c0Z:RXP:1PH42MWIf0S8b<P8V9RH210@40_ooo`:j^[X2M7Ad0U1@
D0:UYJD2YjNW0Xj>SP9_Kfl2KFe]0X>3P`:UYJD2XZ:R0R4Q8@8Y:BT2@d=30W1`L0800002Lg=c0XN7
Q`8V9RH2oooo0X:2PP800002PH610WalO08Q8B42NWYj0Z>SX`:LW9`2ZZZZ0UIFEP:7QhL5oooo0@00
007oool001Goool200000oooo`;Ng]h2i>CT0Zj^[P9oOgl200000S/k>`:4Q8@400000VMWI`:4Q8@2
W9bL0W1`L08P8202;Rh^0UEEE@8c<c<2OGem0_ooo`:`/;02HF5Q0YbLW08h>3P2Ogmo0X20P0:6QXH2
R8R80YjNWP;alO42HF5Q0ZBTY0800002clo?0]7Ad@8410@2CDe=0ZNWY`9KFe/2^KVi0Xb<S096ATH2
>CTi0V=SH`:LW9`2EEEE0U5AD@9;Bd/2JVYZ0Tm?C`:a/K42mOGe0XN7Q`:4Q8@2<30`0_ooo`8V9RH2
HV9R0Y:BTP9FEUH2?Shn0VIVIP:9RHT2HF5Q0VEUI@03C4a<EUIFEUIF00:GUiL2VYZJ0ZZZZP;alO42
IfMW0XZ:RP:4Q8@2N7Qh0X20P09fMWH2ZZZZ0WMgM`:@T902IVIV0UYJFP:1PH4200000Y2@T0:KVi/2
XZ:R0V5QH@9?Cdl2[:b/0_?cl`:RXZ82PH610WIfMP8b<S829RHV0P@410;oool2^[Zj0WAdM09@D502
YJFU0ZNWY`:>SXh2Kfm_0Ve]K@:3Ph<2YJFU0Z:RXP8Q8B42:BTY0T=3@`9`L70200000W=cL`:7QhL2
9RHV0_ooo`:2PX8200000X61P@9lO7`28B4Q0WYjNP:SXj<2W9bL0ZZZZP9FEUH2QhN71?ooo`800001
oooo000Eoooo00<0003oooooool00_ooo`8j>SX2IVIV0YRHV0;^k^h2aLG50WemO@8V9RH2Y:BT0Z2P
X0800002LG5a0UADE099BDT2h>3P0_ooo`9gMgL2@T920[Vi^@8=3@d2UIFE0SHf=P:IVIT2aLG50Xb<
S0;Lg=`2>SXj0^;RhP9;Bd/2MgMg0Xb<S0800002A4A40WalO0;=cLd2PX:20V=SH`;]kNd2Kfm_0U5A
D@8m?Cd2PX:20YjNWP:i^KT2Z:RX0RPX:0800002`L710Sdm?@91@D42oooo0SXj>P9QHF42IfMW0X:2
PP9eMGD2L71`0W]kN`:9RHT2RXZ:0WYjNP9CDe<2Hf=S0U9BDP:SXj<00hJ6QXZ:RXZ:RP02UIFE0TE5
A@9QHF42YZJV0WQhN09QHF42E5AD0XV9R@:0P802FUYJ0XB4Q0::RXX271`L0[2`/09DE5@261PH0U5A
D@9LG5`24Q8B0P/;2`9IFET2I6AT0S8b<P8n?Sh2WYjN0Ta<C0:4Q8@2`<300WYjNP:OWil2=CDe0UQH
F09hN7P2Q8B40XZ:RP8o?cl2De=C0WemO@;5aLD23`l?0SHf=P:RXZ82GEeM0_ooo`800002/k>c0/k>
cP:b/[823Ph>0Q`L70;Shn<2k>c/0WalO0:0P802NWYj0X>3P`9kNg/2NGUi0WMgM`96ATH2:BTY0]gM
g@Goool100000Oooo`005Oooo`030000oooooooo00;oool2>SXj0VIVIP:HV9P2k^k^0/G5a@9mOGd2
9RHV0ZBTY0:PX:0200000W5aL@9DE5@2BDU90^3Ph0;oool2MgMg0T92@P:i^KT23@d=0YFEU@8f=SH2
VIVI0/G5a@:<S8`2g=cL0SXj>P;Rh^82Bd];0WMgM`:<S8`200000TA4A09lO7`2cLg=0X:2PP9SHf<2
kNg]0Vm_K`9ADE42?Cdm0X:2PP:NWYh2^KVi0ZRXZ08X:2P200000/71`@8m?Cd2@D510_ooo`8j>SX2
HF5Q0VMWI`:2PX82MGEe0W1`L09kNg/2RHV90XZ:RP9jNWX2De=C0V=SH`9BDU82Xj>S00>6QXJ:RXZ:
RXX00YFEU@95ADD2HF5Q0ZJVYP9hN7P2HF5Q0UADE0:9RHT2P8200UYJFP:4Q8@2RXZ:0Q`L70:`/;02
E5AD0QPH609ADE42G5aL0Q8B4P8;2`/2FEUI0VATI08b<S82?Shn0YjNWP9<C4`2Q8B40/30`09jNWX2
WinO0SDe=@9HF5P2N7Qh0XB4Q0::RXX2?clo0U=CD`9mOGd2aLG50Pl?3`8f=SH2XZ:R0UeMG@;oool2
00000[>c/`;>c/h2/[:b0Ph>3P8L71`2hn?S0^c/k09lO7`2P8200WYjNP:3Ph<2Ng]k0WUiN@9gMgL2
ATI60RTY:@;MgMd5oooo0@00007oool001Goool00`000?ooooooo`02oooo0YFEU@:QXJ42IFEU0PD5
1@;7alL2QhN70Rh^;P:3Ph<2P8200VMWI`8_;bl2WIfM0XF5Q@:JVYX2ZZZZ0V5QH@;alO42oooo0Wem
O@:=SHd2GEeM0[Ng]`9mOGd2IFEU0W]kN`:4Q8@2GEeM0[Zj^P90@402E5AD0YFEU@:?Shl2Ti>C0QPH
60:0P802F5QH0T];B`8J6QX29BDU0YFEU@9CDe<2Ti>C0W9bLP8l?3`2JVYZ0/;2`P8e=CD2jn_[0TA4
A09IFET2EeMG0TE5A@:1PH42Lg=c0X61P@9@D502^;Rh0T];B`:?Shl2B4Q80Vi^KP:@T902L71`0TE5
A@033Ph>`L71`L7100:3Ph<2WIfM0P0000;4a<@2?clo0Y:BTP:GUiL2HF5Q0X>3P`:4Q8@2c/k>0V9R
HP:6QXH2F5QH0Q0@40:f][H2Kfm_0WalO0:DU9@2QXJ60[fm_@9PH602oooo0P0000:4Q8@2QHF50P00
00:EUID2Jf][0P0000;GemL2Rh^;0WmoO`:HV9P2G5aL0Zj^[P:b/[82Ph>30Vm_K`:IVIT2WYjN0_3`
l09KFe/2i>CT0Vi^KP9`L702?Cdm0X>3P`:h^;P2oooo0Ta<C09^KVh2LG5a0WalO09jNWX2MgMg0Win
OP9fMWH2W9bL0Z^[Z`97AdL200001Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`:EUID2
XJ6Q0VEUI@851@D2alO70XN7Q`8^;Rh2Ph>30X20P09WIfL2;bl_0YfMW@:5QHD2VYZJ0ZZZZP9QHF42
lO7a0_ooo`9mOGd2SHf=0UeMG@:g]kL2OGem0VEUI@9kNg/2Q8B40UeMG@:j^[X2@4100UADE0:EUID2
Shn?0Y>CT`8H61P2P8200UQHF09;Bd/26QXJ0RDU9@:EUID2De=C0Y>CT`9bLW82?3`l0VYZJP;2`/82
=CDe0^_[j`94A4@2FEUI0UMGE`95ADD2PH610W=cL`:1PH42D51@0[Rh^09;Bd/2Shn?0TQ8B09^KVh2
T92@0W1`L095ADD00`h>3/71`L71`@02Ph>30YfMW@800002a<C40Slo?`:BTY82UiNG0V5QH@:3Ph<2
Q8B40/k>cP9RHV82QXJ60UQHF08@4102][Jf0Vm_K`9lO7`2U9BD0XJ6QP:m_Kd2H61P0_ooo`800002
Q8B40XF5Q@800002UIFE0V][J`800002emOG0X^;R`9oOgl2V9RH0UaLG0:^[Zh2/[:b0X>3P`9_Kfl2
VIVI0YjNWP;`l?02Fe]K0^CTi09^KVh2L71`0Sdm?@:3Ph<2^;Rh0_ooo`9<C4`2KVi^0W5aL@9lO7`2
NWYj0WMgM`9nOWh2MWIf0YbLW0:[Zj/2AdM70P0000Goool100000Oooo`005Oooo`030000oooooooo
00;oool2N7Qh0T92@P9RHV82eMGE0YjNWP9gMgL2GUiN0W9bLP9QHF42OWin0VEUI@;Cdm<2e=CD0ZBT
Y0:7QhL2oooo0Va/K0:6QXH4MgMg0VATI09bLW82RXZ:0[^k^`::RXX2QXJ60Va/K08n?Sh2`/;20XF5
Q@;oool2QXJ60U]KF`9[Jf/2][Jf0PT92@8E5AD2=3@d0_ooo`800002LG5a0XV9R@8_;bl2Ng]k0QlO
7`9WIfL2P8200W5aL@9_Kfl2MWIf0U=CD`:LW9`2SXj>0WemO@:3Ph<2Cdm?0YnOW`;Shn<2FEUI0[Vi
^@;MgMd2NWYj0Ti>CP:ATI400gEeMINGUiNGU`02B4Q80Y6AT@9mOGd2RXZ:0Y2@T0:^[Zh24Q8B0_gm
o@:QXJ4200000]kNgP:=SHd2De=C0UUIF@9ZJVX2Q8B40W1`L0;1`L42SXj>0_KfmP;hn?P2M7Ad0]3@
d09kNg/2emOG0YfMW@9QHF42[Jf]0TU9B@:BTY82Shn?0X61P@:4Q8@2@T920_7al@;oool2B4Q80[bl
_09/K6`2PX:20W1`L09XJ6P2P8200Vm_K`9iNGT2FEUI0V=SH`:l_;`2Kfm_0WemO@:j^[X2SXj>0X:2
PP9oOgl2Ph>30WemO@9lO7`2Ng]k0YBDU0:JVYX2K6a/0[Ng]`Goool100000Oooo`005Oooo`030000
oooooooo00;oool2N7Qh0T92@P9RHV82eMGE0YjNWP9gMgL2GUiN0W9bLP9QHF42OWin0VEUI@;Cdm<2
e=CD0ZBTY0:7QhL2oooo0Va/K0:6QXH4MgMg0VATI09bLW82RXZ:0[^k^`::RXX2QXJ60Va/K08n?Sh2
`/;20XF5Q@;oool2QXJ60U]KF`9[Jf/2][Jf0PT92@8E5AD2=3@d0_ooo`800002LG5a0XV9R@8_;bl2
Ng]k0QlO7`9WIfL2P8200W5aL@9_Kfl2MWIf0U=CD`:LW9`2SXj>0WemO@:3Ph<2Cdm?0YnOW`;Shn<2
FEUI0[Vi^@;MgMd2NWYj0Ti>CP:ATI400gEeMINGUiNGU`02B4Q80Y6AT@9mOGd2RXZ:0Y2@T0:^[Zh2
4Q8B0_gmo@:QXJ4200000]kNgP:=SHd2De=C0UUIF@9ZJVX2Q8B40W1`L0;1`L42SXj>0_KfmP;hn?P2
M7Ad0]3@d09kNg/2emOG0YfMW@9QHF42[Jf]0TU9B@:BTY82Shn?0X61P@:4Q8@2@T920_7al@;oool2
B4Q80[bl_09/K6`2PX:20W1`L09XJ6P2P8200Vm_K`9iNGT2FEUI0V=SH`:l_;`2Kfm_0WemO@:j^[X2
SXj>0X:2PP9oOgl2Ph>30WemO@9lO7`2Ng]k0YBDU0:JVYX2K6a/0[Ng]`Goool100000Oooo`005Ooo
o`030000oooooooo00;oool2Xj>S0Va/K0:TY:@2^[Zj0V=SH`:CTi<2ATI60WemO@Coool2MWIf0V1P
H09KFe/2KVi^0QXJ6P8M7Ad2Ogmo0WIfMP;dm?@2NWYj0]GEe@9/K6`2YjNW0__kn`:a/K42][Jf0ZBT
Y0:8R8P2oooo0U1@D0800002QXJ60W5aL@8O7al23`l?0]?Cd`:^[Zh200000]kNgP8D51@2G5aL0Q`L
70:OWil2eMGE0WQhN0:8R8P2MWIf0X:2PP9jNWX2Ph>30XJ6QP8L71`2HV9R0VUYJ@9BDU82OGem0VMW
I`:0P802/;2`0ZFUY@;emOD2QhN70^OWi`>0P802OGem0UIFEP:DU9@2JFUY0[Fe]@9nOWh2bLW90UmO
G`9KFe/2m?Cd0[Vi^@9VIVH2MWIf0UYJFP:VYZH2IFEU0W9bLP:_[jl2NGUi0ZZZZP9YJFT2820P0Z^[
Z`9LG5`2J6QX0TY:BP:_[jl2ZJVY0YjNWP:=SHd2L71`0SLg=`9SHf<2QhN70V=SH`:7QhL2GEeM0Y2@
T09cLg<4OGem0X61P@:4Q8@2NGUi0X61P@9mOGd2Q8B40X20P09CDe<2KVi^0Ve]K@:XZ:P200000W]k
N`9SHf<2GEeM0X20P0:1PH42H61P0XZ:RP9gMgL2Ph>30U]KF`Goool100000Oooo`002_ooo`030000
oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`:SXj<2K6a/0ZBTY0:j^[X2
Hf=S0Y>CT`96ATH2OGem1?ooo`9fMWH2H61P0U]KF`9^KVh26QXJ0QdM7@9oOgl2MWIf0_Cdm09jNWX2
eMGE0Va/K0:WYjL2no_k0[6a/@:f][H2Y:BT0XR8R0;oool2D51@0P0000:6QXH2LG5a0QlO7`8?3`l2
dm?C0Zj^[P800002g]kN0Q@D509LG5`271`L0YnOW`;EeMD2N7Qh0XR8R09fMWH2PX:20WYjNP:3Ph<2
QXJ60Q`L709RHV82JFUY0U9BDP9mOGd2IfMW0X20P0:`/;02YJFU0_Gem@:7QhL2inOW0h20P09mOGd2
EUIF0YBDU09YJFT2]KFe0WinOP;9bLT2GemO0U]KF`;dm?@2^KVi0VIVIP9fMWH2FUYJ0ZJVYP9UIFD2
LW9b0Zn_[`9iNGT2ZZZZ0VUYJ@8P8202Zj^[0UaLG09XJ6P2BTY:0Zn_[`:YZJT2WYjN0Xf=S@9`L702
=cLg0V=SH`:7QhL2Hf=S0XN7Q`9MGEd2T92@0W=cL`AmOGd2PH610XB4Q09iNGT2PH610WemO@:4Q8@2
P8200U=CD`9^KVh2KFe]0ZRXZ0800002Ng]k0V=SH`9MGEd2P8200X61P@9PH602RXZ:0WMgM`:3Ph<2
Fe]K1Oooo`400001oooo0009oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?oo
ooooo`02oooo0[>c/`9cLg<2QXJ60W9bLP9oOgl2N7Qh0Xn?S`;oool2JFUY0Y>CT`:;Rh/2Fe]K0ZNW
Y`:5QHD2][Jf0UUIF@9lO7`2CDe=0T51@@;oool2Jf][0Y>CT`9?Cdl2_;bl0^c/k09XJ6P2f][J0Xb<
S0:NWYh261PH0YbLW09fMWH2C4a<0Rl_;`:>SXh2=CDe0WMgM`9=CDd2EEEE0WemO@:^[Zh200000VAT
I09gMgL2MWIf0WQhN09nOWh2N7Qh0X61P@9[Jf/2fm_K0S<c<`9oOgl2D51@0X20P09dM7@2NGUi0X61
P@9/K6`2RHV90Zf][@:9RHT2/;2`0ZBTY0=kNg/2QHF50WEeM@9lO7`2PH610U]KF`:5QHD2Q8B40/c<
c09ZJVX26ATI0UiNGP9RHV82D51@0QdM7@:2PX82820P0XB4Q0;WinL2D51@0XJ6QP:@T902HV9R0ZRX
Z09SHf<2YZJV0Y:BTP:=SHd2MGEe0XF5Q@:RXZ82@4100YnOW`:0P802QXJ60WEeM@:4Q8@2MWIf0X20
P0AkNg/2NWYj0WUiN@9mOGd2NWYj0WalO0AiNGT2PH610UQHF09LG5`2FEUI0Vm_K`9VIVH2G5aL0U]K
F`:4Q8@2NWYj0WQhN0:1PH42OWin0WalO09mOGd5oooo0@00007oool000Woool00`000?ooo`000002
oooo00<0003oool000001?ooo`800003oooo0[>c/`9cLg<2QXJ60W9bLP9oOgl2N7Qh0Xn?S`;oool2
JFUY0Y>CT`:;Rh/2Fe]K0ZNWY`:5QHD2][Jf0UUIF@9lO7`2CDe=0T51@@;oool2Jf][0Y>CT`9?Cdl2
_;bl0^c/k09XJ6P2f][J0Xb<S0:NWYh261PH0YbLW09fMWH2C4a<0Rl_;`:>SXh2=CDe0WMgM`9=CDd2
EEEE0WemO@:^[Zh200000VATI09gMgL2MWIf0WQhN09nOWh2N7Qh0X61P@9[Jf/2fm_K0S<c<`9oOgl2
D51@0X20P09dM7@2NGUi0X61P@9/K6`2RHV90Zf][@:9RHT2/;2`0ZBTY0=kNg/2QHF50WEeM@9lO7`2
PH610U]KF`:5QHD2Q8B40/c<c09ZJVX26ATI0UiNGP9RHV82D51@0QdM7@:2PX82820P0XB4Q0;WinL2
D51@0XJ6QP:@T902HV9R0ZRXZ09SHf<2YZJV0Y:BTP:=SHd2MGEe0XF5Q@:RXZ82@4100YnOW`:0P802
QXJ60WEeM@:4Q8@2MWIf0X20P0AkNg/2NWYj0WUiN@9mOGd2NWYj0WalO0AiNGT2PH610UQHF09LG5`2
FEUI0Vm_K`9VIVH2G5aL0U]KF`:4Q8@2NWYj0WQhN0:1PH42OWin0WalO09mOGd4oooo0P00007oool0
00[oool01`000?ooooooooooo`000?ooo`000004oooo00<0003oooooool00_ooo`9cLg<2Rh^;0YJF
UP9fMWH2Ph>30W=cL`;oool2De=C0XJ6QP9jNWX2MgMg0X61P@:BTY82Xj>S0S8b<P:9RHT2LW9b0]gM
g@;Rh^82GUiN0XR8R09fMWH2QXJ60VIVIP9JFUX2clo?0UIFEPB7QhL2MgMg0WEeM@9oOgl24a<C0VIV
IP9RHV82R8R80X20P0:OWil2dM7A0Z6QX@:ATI42XZ:R1820P09nOWh2OGem0WYjNP:2PX82IVIV0[fm
_@:JVYX2G5aL0[:b/P:4Q8@2O7al0WemO@9lO7`2NWYj0X:2PP9hN7P2LG5a0Ve]K@9eMGD2000000=k
Ng]lO7alO7`00WUiN@9nOWh2Ng]k0WemO@:6QXH2NGUi0X61P@9lO7`2J6QX0P00008U9BD2][Jf0^;R
hP;EeMD2Kfm_0/O7a`;oool2PX:20WUiN@9kNg/2LW9b0XJ6QP9WIfL2YJFU0Ve]K@9`L702b/[:0WAd
M09_Kfl2Y:BT0YRHV09jNWX2N7Qh0WUiN@9lO7`2N7Qh0WinOP9jNWX6O7al0WemO@IlO7`2OGem0WAd
M09ADE42HV9R0WemO@:m_Kd2@T920/O7a`9iNGT2RHV90WQhN09mOGd2O7al17]kN`9lO7`2NWYj1Ooo
o`400001oooo0009oooo00<0003oool000000_ooo`030000oooo000000Coool00`000?ooooooo`02
oooo0W=cL`:;Rh/2UYJF0WIfMP:3Ph<2Lg=c0_ooo`9CDe<2QXJ60WYjNP9gMgL2PH610Y:BTP:SXj<2
<S8b0XV9R@9bLW82gMgM0^;RhP9NGUh2R8R80WIfMP:6QXH2IVIV0UYJFP;?cll2EUIF18N7Q`9gMgL2
MGEe0WmoO`8C4a<2IVIV0V9RHP:8R8P2P8200YnOW`;AdM42XJ6Q0Y6AT@:RXZ84P8200WinOP9mOGd2
NWYj0X:2PP9VIVH2_Kfm0YZJVP9LG5`2/[:b0XB4Q09lO7`2OGem0WalO09jNWX2PX:20WQhN09aLG42
KFe]0WEeM@8000000g]kNgalO7alO002NGUi0WinOP9kNg/2OGem0XJ6QP9iNGT2PH610WalO09XJ6P2
00000RDU9@:f][H2h^;R0]GEe@9_Kfl2alO70_ooo`:2PX82NGUi0W]kN`9bLW82QXJ60VMWI`:UYJD2
KFe]0W1`L0;:b/X2M7Ad0Vm_K`:TY:@2V9RH0WYjNP9hN7P2NGUi0WalO09hN7P2OWin0WYjNPIlO7`2
OGem1WalO09mOGd2M7Ad0U5AD@9RHV82OGem0[fm_@92@T82alO70WUiN@:9RHT2N7Qh0WemO@9lO7`4
Ng]k0WalO09jNWX5oooo0@00007oool000[oool00`000?ooooooo`02oooo00<0003oooooool00ooo
o`030000oooooooo00;oool2Zj^[0Vi^KP9bLW82O7al0W]kN`9mOGd2KFe]0X:2PP9gMgL2NWYj17al
O09gMgL2/k>c0ZBTY09_Kfl2OGem0W9bLP9gMgL2Ph>30WQhN09mOGd2NWYj0W]kN`:HV9P2SHf=0XV9
R@::RXX2?3`l0Ve]K@:4Q8@2Ng]k0Z:RXP:l_;`2YZJV0W=cL`9kNg/2KFe]0UEEE@:1PH42Jf][0Ve]
K@9hN7P2NWYj0WalO09kNg/2O7al0W]kN`9mOGd2MWIf0VQXJ09=CDd2Hf=S0WQhN09mOGd6O7al0WYj
NP9lO7`2OWin0WalO09HF5P2<S8b1GalO09kNg/2O7al0W]kN`9hN7P2OGem0WalO09mOGd2Rh^;0VQX
J0:FUYH2_[jn0Q8B4P9OGel2[Jf]0YJFUP:>SXh2LW9b0WmoO`9lO7`2Ogmo0WUiN@:4Q8@2K6a/0YJF
UP;1`L42XJ6Q0VQXJ0;9bLT2b<S80WMgM`9oOgl2O7al0WemO@9lO7`2OGem0W]kNaAlO7`4P8200Va/
K0;Ti>@2m?Cd0UUIF@:1PH42MWIf0WinOP9kNg/8O7al0WemO@Goool100000Oooo`005Oooo`030000
oooooooo00;oool2Zj^[0Vi^KP9bLW82O7al0W]kN`9mOGd2KFe]0X:2PP9gMgL2NWYj17alO09gMgL2
/k>c0ZBTY09_Kfl2OGem0W9bLP9gMgL2Ph>30WQhN09mOGd2NWYj0W]kN`:HV9P2SHf=0XV9R@::RXX2
?3`l0Ve]K@:4Q8@2Ng]k0Z:RXP:l_;`2YZJV0W=cL`9kNg/2KFe]0UEEE@:1PH42Jf][0Ve]K@9hN7P2
NWYj0WalO09kNg/2O7al0W]kN`9mOGd2MWIf0VQXJ09=CDd2Hf=S0WQhN09mOGd6O7al0WYjNP9lO7`2
OWin0WalO09HF5P2<S8b1GalO09kNg/2O7al0W]kN`9hN7P2OGem0WalO09mOGd2Rh^;0VQXJ0:FUYH2
_[jn0Q8B4P9OGel2[Jf]0YJFUP:>SXh2LW9b0WmoO`9lO7`2Ogmo0WUiN@:4Q8@2K6a/0YJFUP;1`L42
XJ6Q0VQXJ0;9bLT2b<S80WMgM`9oOgl2O7al0WemO@9lO7`2OGem0W]kNaAlO7`4P8200Va/K0;Ti>@2
m?Cd0UUIF@:1PH42MWIf0WinOP9kNg/8O7al0WemO@Goool100000Oooo`005Oooo`030000oooooooo
00;oool2Lg=c0Xf=S@9hN7P2OWin0WalO09kNg/2QXJ60X20P0ImOGd2NGUi0X>3P`9HF5P2OGem0Wal
O09kNg/2P8201WemO@9lO7`2Ng]k0WalO097AdL2EUIF0WmoO`9eMGD2UYJF0YZJVP9hN7P2OGem0[fm
_@9jNWX2K6a/0X20P09lO7`2PH610X^;R`:RXZ82^[Zj0WalO0:0P802Ng]k27alO09kNg/2Ogmo0X61
P@9hN7P2Ph>347alO09iNGT2S8b<0V5QH@]lO7`2OGem0WalO09kNg/2NWYj0WUiN@9kNg/4OGem0Xb<
S0800002@D510WEeM@9kNg/2OWin0W]kN`9lO7`2Ng]k0WemO@9iNGT2PH610WAdM09/K6`2Jf][0ZNW
Y`99BDT2ATI60XJ6QP9hN7P2OGem0W]kN`9lO7`2Ng]k57alO09kNg/2NGUi0WYjNP9mOGd2K6a/0VAT
I0:4Q8@2Ng]k0WemO@9kNg/2O7al0W]kN`IlO7`2Ng]k1Oooo`400001oooo000Eoooo00<0003ooooo
ool00_ooo`9cLg<2SHf=0WQhN09nOWh2O7al0W]kN`:6QXH2P8201WemO@9iNGT2Ph>30UQHF09mOGd2
O7al0W]kN`:0P806OGem0WalO09kNg/2O7al0TM7A`9FEUH2Ogmo0WEeM@:FUYH2VYZJ0WQhN09mOGd2
_Kfm0WYjNP9/K6`2P8200WalO0:1PH42Rh^;0Z:RXP:j^[X2O7al0X20P09kNg/8O7al0W]kN`9oOgl2
PH610WQhN0:3Ph<@O7al0WUiN@:<S8`2HF5Q2galO09mOGd2O7al0W]kN`9jNWX2NGUi0W]kN`AmOGd2
S8b<0P000091@D42MGEe0W]kN`9nOWh2Ng]k0WalO09kNg/2OGem0WUiN@:1PH42M7Ad0Va/K09[Jf/2
YjNW0TU9B@96ATH2QXJ60WQhN09mOGd2Ng]k0WalO09kNg/DO7al0W]kN`9iNGT2NWYj0WemO@9/K6`2
I6AT0XB4Q09kNg/2OGem0W]kN`9lO7`2Ng]k1WalO09kNg/5oooo0@00007oool001Goool00`000?oo
ooooo`02oooo0WQhN09VIVH2PX:20WYjNPAlO7`2N7Qh0WalO0AkNg/4O7al0WQhN0:5QHD2Xj>S0WEe
M@9mOGd2NGUi0WYjNP9lO7`2Ng]k17alO09kNg/2KFe]0Slo?`:8R8P2Ng]k0X^;R`9WIfL2Ogmo0WYj
NP:b/[82SXj>0WEeM@9mOGd2Ng]k0WemO@9bLW82TI6A0UeMG@9kNg/2NWYj37alO0AjNWX2Ng]k0WUi
NA1lO7`2Ng]k0WemO@9UIFDCO7al0WemO@9lO7`2Ogmo0WemO@:FUYH2Ti>C0V1PH09jNWX2Ng]k2Wal
O09mOGd2NWYj0WmoO`:1PH42NWYj0Zj^[P:0P802SXj>0WMgM`9nOWh2Ng]k77alO0AmOGd2Ng]k0X:2
PP:6QXH2NGUi0WalO09kNg/>O7al1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9hN7P2
IVIV0X:2PP9jNWX4O7al0WQhN09lO7`4Ng]k17alO09hN7P2QHF50Z>SX`9eMGD2OGem0WUiN@9jNWX2
O7al0W]kN`AlO7`2Ng]k0Ve]K@8o?cl2R8R80W]kN`:;Rh/2IfMW0WmoO`9jNWX2/[:b0Xj>SP9eMGD2
OGem0W]kN`9mOGd2LW9b0Y6AT@9MGEd2Ng]k0WYjNPalO7`4NWYj0W]kN`9iNGT@O7al0W]kN`9mOGd2
IFEU4galO09mOGd2O7al0WmoO`9mOGd2UYJF0Y>CT`9PH602NWYj0W]kN`YlO7`2OGem0WYjNP9oOgl2
PH610WYjNP:^[Zh2P8200Xj>SP9gMgL2OWin0W]kNaalO7`4OGem0W]kN`:2PX82QXJ60WUiN@9lO7`2
Ng]k3WalO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2Shn?0XZ:RP9hN7P2OGem17al
O09mOGd2Ng]k0WalO09kNg/2OWin0WMgM`:8R8P2?Cdm0WEeM@9iNGT2Ng]k17emO@IlO7`2NWYj0X20
P09<C4`2Ng]k0X20P09jNWX2DE5A0WUiN@9jNWX2OGem0][JfP:9RHT2P8200WQhN09nOWh2N7Qh0ZJV
YP:b/[82OGem0X20P09kNg/>O7al1WemOA1lO7`2NWYj0X>3P`9ZJVXEO7al0W]kN`9jNWX2P8200YFE
U@:UYJD2[Jf]0W=cL`9nOWh2Ng]k0WQhN09nOWh4O7al0W]kN`9nOWh2LW9b0YNGU`9@D502Cdm?0Wmo
O`9dM7@2OWin0W]kNailO7`4Ng]k0WalO09iNGT2N7Qh0WemOA9lO7`5oooo0@00007oool001Goool2
00000oooo`:?Shl2RXZ:0WQhN09mOGd4O7al0WemO@9kNg/2O7al0W]kN`9nOWh2MgMg0XR8R08m?Cd2
MGEe0WUiN@9kNg/4OGem1WalO09jNWX2P8200Ta<C09kNg/2P8200WYjNP9ADE42NGUi0WYjNP9mOGd2
f][J0XV9R@:0P802N7Qh0WinOP9hN7P2YZJV0[:b/P9mOGd2P8200W]kN`ilO7`6OGem47alO09jNWX2
Ph>30VYZJQElO7`2Ng]k0WYjNP:0P802UIFE0ZFUY@:][Jd2Lg=c0WinOP9kNg/2N7Qh0WinOPAlO7`2
Ng]k0WinOP9bLW82UiNG0U1@D09?Cdl2Ogmo0WAdM09nOWh2Ng]k7WalO0AkNg/2O7al0WUiN@9hN7P2
OGem4WalO0Coool200000Oooo`005Oooo`030000oooooooo00;oool2H61P0WEeM@9mOGd6O7al0W]k
N`QlO7`2NWYj0X61P@9YJFT2G5aL0X20P0alO7`2Ng]k0WinOP:1PH42/k>c0Xn?S`9`L702V9RH0XF5
Q@AlO7`2GEeM0TY:BP9oOgl2Ng]k0X20P0:6QXH2YJFU0Ti>CP9nOWh2NGUi0WemOA1lO7`2Ng]k57al
O09iNGT2RXZ:6GalO09mOGd2N7Qh0YfMW@9?Cdl2QhN70WIfMP9kNg/2QhN70WIfMP9jNWX2O7al0WYj
NP:2PX82MGEe0^OWi`9^KVh2Rh^;0WUiN@9oOgl2Ng]k9WalO0AmOGdDO7al1Oooo`400001oooo000E
oooo00<0003oooooool00_ooo`9PH602MGEe0WemO@IlO7`2Ng]k27alO09jNWX2PH610VUYJ@9LG5`2
P82037alO09kNg/2OWin0X61P@:c/k<2Shn?0W1`L0:HV9P2QHF517alO09MGEd2BTY:0WmoO`9kNg/2
P8200XJ6QP:UYJD2CTi>0WinOP9iNGT2OGem47alO09kNg/DO7al0WUiN@::RXXIO7al0WemO@9hN7P2
WIfM0Tm?C`:7QhL2MWIf0W]kN`:7QhL2MWIf0WYjNP9lO7`2NWYj0X:2PP9eMGD2inOW0Vi^KP:;Rh/2
NGUi0WmoO`9kNg/VO7al17emOAAlO7`5oooo0@00007oool001Goool00`000?ooooooo`02oooo0X>3
P`9jNWX@O7al0WYjNP:0P802Kfm_0Zn_[`9cLg<2IVIV37alO09mOGd2MWIf0XB4Q08P8202S8b<0X20
P09]KFd2MGEe17alO0:ATI42_;bl0ZVYZ@8o?cl2NGUi0W9bLP9kNg/2WYjN0WYjNP9nOWh2Ng]k97al
O09kNg/2OWin0Vi^KQElO7`2Ng]k0WemO@9gMgL2OGem0UmOG`:ZZZX2NWYj0VMWI`9lO7`2:RXZ0YFE
U@9mOGd2Ogmo0WemO@9cLg<2LW9b0Xf=S@;>c/h2MGEe0WemO@9jNWY0O7al1Oooo`400001oooo000E
oooo00<0003oooooool00_ooo`:3Ph<2NWYj47alO09jNWX2P8200Vm_K`:_[jl2Lg=c0VIVIPalO7`2
OGem0WIfMP:4Q8@2820P0Xb<S0:0P802KFe]0WEeM@AlO7`2TI6A0[bl_0:YZJT2?clo0WUiN@9bLW82
Ng]k0YjNWP9jNWX2OWin0W]kNbAlO7`2Ng]k0WinOP9^KVhEO7al0W]kN`9mOGd2MgMg0WemO@9OGel2
ZZZZ0WYjNP9WIfL2O7al0RXZ:P:EUID2OGem0WmoO`9mOGd2Lg=c0W9bLP:=SHd2c/k>0WEeM@9mOGd2
NWYj@7alO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2QhN70VUYJ@:1PH42NWYj3Wal
O09kNg/2OWin0WYjNP:^[Zh2PH613WalO09mOGd2QhN70ZRXZ09FEUH2MWIf0ZZZZP9dM7@2Ogmo0W]k
N`97AdL2K6a/0T51@@;oool2IFEU0Z>SX`:7QhL2W9bL0XV9R@9kNg/VO7al0WemO@9jNWX2QhN75gal
O09kNg/2Ph>30YFEU@:SXj<2GemO0W5aL@:IVIT2P8200YfMW@800002@T920WinOP9cLg<2YjNW0Y^K
V`9gMgL2HF5Q0UeMG@:9RHT2N7Qh0WemO@9kNg/lO7al1Oooo`400001oooo000Eoooo00<0003ooooo
ool00_ooo`:7QhL2JFUY0X61P@9jNWX>O7al0W]kN`9nOWh2NWYj0Zj^[P:1PH4>O7al0WemO@:7QhL2
Z:RX0UIFEP9fMWH2ZZZZ0WAdM09oOgl2Ng]k0TM7A`9/K6`2@D510_ooo`9UIFD2Xj>S0XN7Q`:LW9`2
RHV90W]kNbIlO7`2OGem0WYjNP:7QhLGO7al0W]kN`:3Ph<2UIFE0Z>SX`9OGel2LG5a0YVIV@:0P802
WIfM0P000092@T82OWin0W=cL`:WYjL2Vi^K0WMgM`9QHF42GEeM0XV9R@9hN7P2OGem0W]kNcalO7`5
oooo0@00007oool001Goool00`000?ooooooo`02oooo0[Jf]P95ADD2PX:20WUiN@9mOGd8O7al0Wem
O@9iNGT2Ph>30Vi^KP;kno/200000[no_`9mOGd8O7al0W]kN`9oOgl2Kfm_0[Vi^@:2PX82gmoO0^3P
h09jNWX2DU9B0X>3P`9iNGT2alO70Ve]K@:RXZ82O7al0Z>SX`9bLW82^k^k0Vm_K`9DE5@2Ph>30WUi
N@9mOGdPO7al0W]kN`9nOWh2Jf][0XN7Qa=lO7`2OGem0WYjNP9kNg/2:RXZ0VQXJ09TI6@2Zj^[0_[j
nP8n?Sh2bLW90VQXJ09oOgl2JFUY0WMgM`9lO7`2I6AT0YfMW@9cLg<2PX:20Xf=S@9QHF42Q8B40WUi
N@9mOGdlO7al1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`:f][H2ADE50X:2PP9iNGT2
OGem27alO09mOGd2NGUi0X>3P`9^KVh2no_k0P0000:o_kl2OGem27alO09kNg/2Ogmo0Vm_K`:i^KT2
PX:20]oOg`;Ph>02NWYj0U9BDP:3Ph<2NGUi0/O7a`9]KFd2XZ:R0WalO0:SXj<2LW9b0[^k^`9_Kfl2
E5AD0X>3P`9iNGT2OGem87alO09kNg/2OWin0V][J`:7QhLCO7al0WemO@9jNWX2Ng]k0RXZ:P9XJ6P2
I6AT0Z^[Z`;jn_X2?Shn0/W9b@9XJ6P2Ogmo0VUYJ@9gMgL2O7al0VATI0:MWId2Lg=c0X:2PP:=SHd2
HF5Q0XB4Q09iNGT2OGem?7alO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2PH610WUi
N@9oOgl2Ng]k2WalO09kNg/2OGem0WUiN@:0P802CDe=0[Ng]`80000<O7al0W]kN`:0P802GUiN0TI6
AP800002IVIV0ZJVYP9dM7@2OGem0W]kN`9oOgl2@d=3100000:WYjL2MgMg0Y6AT@9hN7P2MWIf0W]k
NbIlO7`2Ng]k0XF5Q@9gMgLCO7al0W]kN`AmOGd2];Bd0WemO@:4Q8@2EeMG0^GUi@:EUID2]KFe0YjN
WP8c<c<2M7Ad0U5AD@:5QHD2=CDe0WinOP9jNWX2Ng]k0WmoO`9/K6`2OWin0W]kNcilO7`5oooo0@00
007oool001Goool200000oooo`:1PH42NGUi0WmoO`9kNg/:O7al0W]kN`9mOGd2NGUi0X20P09=CDd2
]kNg0P0000alO7`2Ng]k0X20P09NGUh2ATI60P00009VIVH2YZJV0WAdM09mOGd2Ng]k0WmoO`93@d<4
00000ZNWY`9gMgL2TI6A0WQhN09fMWH2Ng]k9WalO09kNg/2QHF50WMgMa=lO7`2Ng]k17emO@:d];@2
OGem0XB4Q09GEeL2iNGU0YFEU@:e]KD2WYjN0S<c<`9dM7@2DE5A0XF5Q@8e=CD2OWin0WYjNP9kNg/2
Ogmo0Va/K09nOWh2Ng]k?WalO0Coool200000Oooo`005Oooo`030000oooooooo00;oool2A4A40Ve]
K@9gMgL2OGem37alO09kNg/2OGem0WalO0:MWId2De=C0_ooo`ilO7`2MgMg0X61P@9oOgl2^k^k0Z>S
X`8S8b<2PX:20W]kN`9lO7`2IfMW0U5AD@8m?Cd200000/;2`P9MGEd2AdM70W5aL@:3Ph<2PX:20W]k
NbAlO7`2NWYj0WQhN09EEEDAO7al0W]kN`9mOGd2MWIf0YRHV0:EUID2MWIf0WEeM@:k^k/271`L0]_K
f`;4a<@2F5QH0XB4Q09JFUX2F5QH0[6a/@9LG5`2ATI60XN7Q`AjNWX2[Jf]0WQhN09nOWh2Ng]k?7al
O0Goool100000Oooo`005Oooo`030000oooooooo00;oool2A4A40Ve]K@9gMgL2OGem37alO09kNg/2
OGem0WalO0:MWId2De=C0_ooo`ilO7`2MgMg0X61P@9oOgl2^k^k0Z>SX`8S8b<2PX:20W]kN`9lO7`2
IfMW0U5AD@8m?Cd200000/;2`P9MGEd2AdM70W5aL@:3Ph<2PX:20W]kNbAlO7`2NWYj0WQhN09EEEDA
O7al0W]kN`9mOGd2MWIf0YRHV0:EUID2MWIf0WEeM@:k^k/271`L0]_Kf`;4a<@2F5QH0XB4Q09JFUX2
F5QH0[6a/@9LG5`2ATI60XN7Q`AjNWX2[Jf]0WQhN09nOWh2Ng]k?7alO0Goool100000Oooo`005Ooo
o`030000oooooooo00;oool2Z:RX0WEeM@9mOGd<O7al0W]kN`9mOGd2NWYj0WemO@8i>CT2Ph>30^KV
iPalO7`2NWYj0X:2PP9^KVh2J6QX0UIFEP8e=CD2LW9b0WUiN@9mOGd2Ng]k0V9RHP;Ng]h2ADE50T];
B`:TY:@2oooo0X:2PP:1PH42O7al0WemOBQlO7`2Rh^;0Z>SXa=lO7`2NWYj0X:2PP9TI6@2gMgM0W1`
L0:;Rh/26ATI0RHV9P800002GUiN0YJFUP9JFUX26QXJ0YbLW09DE5@21PH60YFEU@9gMgL2P8200WYj
NP:2PX82Ng]k@7alO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2Z:RX0WEeM@9mOGd<
O7al0W]kN`9mOGd2NWYj0WemO@8i>CT2Ph>30^KViPalO7`2NWYj0X:2PP9^KVh2J6QX0UIFEP8e=CD2
LW9b0WUiN@9mOGd2Ng]k0V9RHP;Ng]h2ADE50T];B`:TY:@2oooo0X:2PP:1PH42O7al0WemOBQlO7`2
Rh^;0Z>SXa=lO7`2NWYj0X:2PP9TI6@2gMgM0W1`L0:;Rh/26ATI0RHV9P800002GUiN0YJFUP9JFUX2
6QXJ0YbLW09DE5@21PH60YFEU@9gMgL2P8200WYjNP:2PX82Ng]k@7alO0Goool100000Oooo`005Ooo
o`030000oooooooo00;oool2OWin0W1`L09nOWh2Ng]k37alO09mOGd2N7Qh0XN7Q`:BTY82oooo0YRH
V0alO7`4Ng]k0UUIF@:@T902IfMW0Rl_;`:<S8`2NWYj0WemO@AkNg/27AdM0ZZZZP9lO7`2SHf=0W5a
L@9eMGD2MWIf0WemO@9kNg/TO7al0WemO@9jNWX2RXZ:0V][Ja=lO7`2Ng]k0WemO@9KFe/2MgMg0X20
P09[Jf/24Q8B0Xn?S`;8b<P2oooo0UIFEP9cLg<2NWYj0YFEU@9IFET2LG5a0WMgM`AfMWH2OWin0W]k
Nd9lO7`5oooo0@00007oool001Goool00`000?ooooooo`02oooo0WinOP9`L702OWin0W]kN`alO7`2
OGem0WQhN0:7QhL2TY:B0_ooo`:HV9P<O7al17]kN`9IFET2T92@0VMWI`8_;bl2S8b<0WYjNP9mOGd4
Ng]k0QdM7@:ZZZX2O7al0Xf=S@9aLG42MGEe0WIfMP9mOGd2Ng]k97alO09mOGd2NWYj0XZ:RP9[Jf/C
O7al0W]kN`9mOGd2Fe]K0WMgM`:0P802Jf][0Q8B4P:?Shl2b<S80_ooo`9FEUH2Lg=c0WYjNP:EUID2
FEUI0W5aL@9gMgL4MWIf0WinOP9kNg]2O7al1Oooo`400001oooo000Eoooo00<0003oooooool00_oo
o`:LW9`2RXZ:0WUiN@alO7`2Ng]k0WinOP9dM7@2TY:B0Slo?`9>CTh2=SHf37alO09iNGT2OWin0Slo
?`:ZZZX2Y:BT0^KViP9kNg/2N7Qh17alO0;[jn/2V9RH0UmOG`:h^;P2Xj>S0]GEe@:ATI42MGEe0Wal
O09mOGdTO7al0WemO@9hN7P2Ti>C0WQhN1=lO7`2NWYj0X20P09;Bd/2Ti>C0TA4A09lO7`2SHf=0][J
fP9YJFT2410@0_ooo`;QhN42Q8B40_ooo`:^[Zh2LW9b0XF5Q@;Rh^82SHf=0WYjNP:0P812O7al1Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`:LW9`2RXZ:0WUiN@alO7`2Ng]k0WinOP9dM7@2
TY:B0Slo?`9>CTh2=SHf37alO09iNGT2OWin0Slo?`:ZZZX2Y:BT0^KViP9kNg/2N7Qh17alO0;[jn/2
V9RH0UmOG`:h^;P2Xj>S0]GEe@:ATI42MGEe0WalO09mOGdTO7al0WemO@9hN7P2Ti>C0WQhN1=lO7`2
NWYj0X20P09;Bd/2Ti>C0TA4A09lO7`2SHf=0][JfP9YJFT2410@0_ooo`;QhN42Q8B40_ooo`:^[Zh2
LW9b0XF5Q@;Rh^82SHf=0WYjNP:0P812O7al1Oooo`400001oooo000Eoooo00<0003oooooool01?oo
o`9RHV82OWin0WYjNPalO7`2NWYj0X20P09^KVh2/K6a0_ooo`;=cLd:O7al0W]kN`9nOWh2OGem0ZNW
Y`:BTY82^KVi0[>c/`:EUID2HF5Q0XB4Q09jNWX2=CDe0VATI0;Ti>@28b<S0YVIV@9;Bd/2KFe]0VAT
I0:8R8P2PH610W]kNb9lO7`2Ng]k0WmoO`9ZJVX2UYJF4GalO09kNg/2OGem0WYjNP:LW9`2LW9b0VAT
I09oOgl2R8R80T];B`9ZJVX2ZZZZ0T=3@`8C4a<2Ti>C0R0P808o?cl2Ti>C0WEeM@:>SXh2OGem0WUi
N@:_[jl2N7Qh0WmoO`9jNWXlO7al1Oooo`400001oooo000Eoooo0P0000Goool2HV9R0WinOP9jNWX<
O7al0WYjNP:0P802KVi^0[6a/@;oool2cLg=2WalO09kNg/2OWin0WemO@:WYjL2TY:B0[Vi^@:c/k<2
UIFE0V5QH@:4Q8@2NWYj0SDe=@9TI6@2i>CT0R<S8`:IVIT2Bd];0Ve]K@9TI6@2R8R80X61P@9kNg/R
O7al0W]kN`9oOgl2JVYZ0YJFUQ5lO7`2Ng]k0WemO@9jNWX2W9bL0W9bLP9TI6@2Ogmo0XR8R09;Bd/2
JVYZ0ZZZZP93@d<24a<C0Y>CT`8P8202?clo0Y>CT`9eMGD2SXj>0WemO@9iNGT2[jn_0WQhN09oOgl2
NWYj?7alO0Coool200000Oooo`005Oooo`030000oooooooo00;oool2De=C0Z:RXP9dM7@2OWin0W]k
N`QlO7`2OGem0WQhN0:9RHT2CTi>0[no_`:=SHd2:RXZ0W]kN`QlO7`2Ng]k0X20P09lO7`2g=cL0P41
0@:_[jl2S8b<0S8b<P:4Q8@2MWIf0WinOP8h>3P2QXJ60TI6AP9RHV82Bd];0Z^[Z`:FUYH2/K6a0W1`
L09nOWh2Ng]k8WalO09iNGT2PX:20Tm?C`:GUiLAO7al0WYjNP:0P802MGEe0^WYj@9_Kfl2QHF50[Bd
]09FEUH2@T920Xj>SP9LG5`2VYZJ0XV9R@:^[Zh2>SXj0_[jnP9XJ6P2SXj>0UeMG@:OWil2Kfm_0W5a
L@9lO7`2Ng]k?WalO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2De=C0Z:RXP9dM7@2
OWin0W]kN`QlO7`2OGem0WQhN0:9RHT2CTi>0[no_`:=SHd2:RXZ0W]kN`QlO7`2Ng]k0X20P09lO7`2
g=cL0P410@:_[jl2S8b<0S8b<P:4Q8@2MWIf0WinOP8h>3P2QXJ60TI6AP9RHV82Bd];0Z^[Z`:FUYH2
/K6a0W1`L09nOWh2Ng]k8WalO09iNGT2PX:20Tm?C`:GUiLAO7al0WYjNP:0P802MGEe0^WYj@9_Kfl2
QHF50[Bd]09FEUH2@T920Xj>SP9LG5`2VYZJ0XV9R@:^[Zh2>SXj0_[jnP9XJ6P2SXj>0UeMG@:OWil2
Kfm_0W5aL@9lO7`2Ng]k?WalO0Goool100000Oooo`005Oooo`030000oooooooo00;oool2[Zj^0Ve]
K@9oOgl2Ng]k37alO09kNg/2OGem0WmoO`:/[:`2PX:20[^k^`alO7`2OWin0WUiN@:a/K42oooo0WIf
MP:8R8P2UiNG0W9bLP9oOgl2Ng]k0Tm?C`;5aLD2NGUi0V5QH@:4Q8@2MGEe0VUYJ@9^KVh2OGem9Wal
O09kNg/2Ogmo0W5aL@:RXZ8EO7al0WemO@9_Kfl2Hf=S0X^;R`9oOgl2dM7A0];BdP9VIVH2N7Qh0XZ:
RP:@T902?3`l0Y2@T08e=CD2Rh^;0Slo?`::RXX2L71`0Xj>SP:1PH52O7al1Oooo`400001oooo000E
oooo00<0003oooooool00_ooo`:^[Zh2KFe]0WmoO`9kNg/<O7al0W]kN`9mOGd2Ogmo0Zb/[0:2PX82
^k^k37alO09nOWh2NGUi0[6a/@;oool2MWIf0XR8R0:GUiL2LW9b0WmoO`9kNg/2Cdm?0/G5a@9iNGT2
HF5Q0XB4Q09eMGD2JFUY0Vi^KP9mOGdVO7al0W]kN`9oOgl2LG5a0Z:RXQElO7`2OGem0Vm_K`9SHf<2
Rh^;0WmoO`;AdM42d];B0VIVIP9hN7P2RXZ:0Y2@T08l?3`2T92@0SDe=@:;Rh/2?clo0XZ:RP9`L702
SXj>0X61PD9lO7`5oooo0@00007oool001Goool00`000?ooooooo`02oooo0XZ:RP:?Shl2NGUi0Wem
O@alO7`2Ng]k0WinOP9eMGD2GemO0P0000;Zj^X>O7al0WmoO`:MWId2QHF50[no_`;Kfm/2PH610Xf=
S@9jNWX2OGem0UYJFP8j>SX2f=SH0X20P0;bl_82Kfm_0VUYJ@9TI6@2SXj>0WQhN09mOGd2Ng]k87al
O09kNg/2Ogmo0WAdM0:`/;0CO7al0W]kN`:0P802KFe]0U9BDP:FUYH2m?Cd0/o?c`8^;Rh2F5QH0S/k
>`:RXZ82K6a/0Y6AT@9eMGD2A4A40WAdM098B4P2Ogmo0W]kN`8h>3P2NGUi0WYjNP9mOGd2Ng]k?7al
O0Goool100000Oooo`005Oooo`030000oooooooo00;oool2RXZ:0Xn?S`9iNGT2OGem37alO09kNg/2
OWin0WEeM@9OGel200000^[ZjPilO7`2Ogmo0YfMW@:5QHD2_kno0]_Kf`:1PH42SHf=0WYjNP9mOGd2
FUYJ0SXj>P;Hf=P2P8200_;blP9_Kfl2JFUY0VATI0:>SXh2N7Qh0WemO@9kNg/PO7al0W]kN`9oOgl2
M7Ad0[2`/1=lO7`2Ng]k0X20P09]KFd2DU9B0YJFUP;dm?@2clo?0Rh^;P9HF5P2>c/k0Z:RXP9/K6`2
TI6A0WEeM@94A4@2M7Ad0TQ8B09oOgl2Ng]k0SPh>09iNGT2NWYj0WemO@9kNg/lO7al1Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`8U9BD2RXZ:0WalO09mOGd2Ng]k2WalO09jNWX2P8200W9b
LP:GUiL2MWIf0_ooo`YlO7`2Ng]k0WinOP9kNg/2^[Zj0Z:RXP8Z:RX2E5AD0Y2@T0:NWYh2MgMg0Wem
O@8Q8B42LG5a0UIFEP9cLg<2CDe=0Ti>CP:YZJT2`L710Z^[Z`9eMGD2OWin0W]kNb1lO7`2Ng]k0Wmo
O`9SHf<2SHf=4GalO09kNg/2Ogmo0WAdM0;7alL2cLg=0RDU9@8a<C42OWin0R0P80:@T902Q8B40Ve]
K@8F5QH2TI6A0UQHF0:/[:`2Shn?0VMWI`:PX:02/;2`0TU9B@:VYZH2Kfm_0X20P09kNg/lO7al1Ooo
o`400001oooo0003oooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool00oooo`030000
oooooooo00;oool29BDU0XZ:RP9lO7`2OGem0W]kN`YlO7`2NWYj0X20P09bLW82UiNG0WIfMP;oool:
O7al0W]kN`9nOWh2Ng]k0[Zj^P:RXZ82:RXZ0UADE0:@T902WYjN0WMgM`9mOGd28B4Q0W5aL@9FEUH2
Lg=c0Te=C@9>CTh2ZJVY0/71`@:[Zj/2MGEe0WinOP9kNg/PO7al0W]kN`9oOgl2Hf=S0Xf=SA5lO7`2
Ng]k0WmoO`9dM7@2alO70/g=c@8U9BD2<C4a0WinOP8P8202T92@0XB4Q09]KFd25QHF0Y6AT@9HF5P2
[:b/0Xn?S`9WIfL2X:2P0[2`/099BDT2YZJV0Vm_K`:0P802Ng]k?7alO0Goool100000Oooo`001Ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00<0003oooooool00_oo
o`:/[:`2Vi^K0WMgM`9mOGd>O7al0WinOP9]KFd2@d=30[Ng]`9oOgl2Ng]k2WalO09kNg/2Q8B40WYj
NP800002>CTi0XJ6QP9YJFT2PX:20WYjNP9mOGd200000VYZJP:f][H2^KVi0VEUI@8K6a/2A4A40XF5
Q@:4Q8@VO7al0W]kN`9mOGd2Shn?0[6a/A5lO7`2OGem0WQhN0:7QhL2BTY:0YbLW0:@T902alO70V][
J`9lO7`2Y:BT0Z^[Z`:c/k<2L71`0Y2@T09MGEd2?Shn0TA4A0;Bd]82oOgm0R8R8P9=CDd2Ph>30WUi
N@9mOGd2Ng]k?7alO0Goool100000Oooo`001Oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`000004oooo0P0000?oool2[:b/0Y^KV`9gMgL2OGem3WalO09nOWh2KFe]0T=3@`:g]kL2
Ogmo0W]kN`YlO7`2Ng]k0XB4Q09jNWX200000STi>@:6QXH2JFUY0X:2PP9jNWX2OGem0P00009ZJVX2
][Jf0[Vi^@9UIFD26a/K0TA4A0:5QHD2Q8B49WalO09kNg/2OGem0Xn?S`:a/K4AO7al0WemO@9hN7P2
QhN70TY:BP:LW9`2T92@0/O7a`9[Jf/2O7al0ZBTY0:[Zj/2/k>c0W1`L0:@T902GEeM0Shn?P94A4@2
d];B0_gmo@8R8R82CDe=0X>3P`9iNGT2OGem0W]kNcalO7`4oooo0P00007oool000Goool01`000?oo
ooooooooo`000?ooo`000002oooo00<0003oool000001?ooo`030000oooooooo00;oool2:RXZ0RDU
9@:<S8`2N7Qh0WemO@QlO7`2Ng]k0WinOP9gMgL2Q8B40SPh>0:HV9P2inOW0WemO@YlO7`2NGUi0X:2
PP9:BTX2N7Qh0/K6aP800002b/[:0Vi^KP:4Q8@2N7Qh0UeMG@;7alL2YZJV0VIVIP:FUYH2inOW0TM7
A`:CTi<2SHf=0WYjNRIlO7`2NGUi0X>3P`9;Bd/EO7al0WQhN0BATI42Ogmo0WEeM@9jNWX2]KFe0ZRX
Z09aLG42P8200WAdM09]KFd2EEEE0Z:RXP820P8200000XV9R@:1PH42De=C0XF5Q@9hN7P2OGem0W]k
NcalO7`5oooo0@00007oool000Goool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool0
00001?ooo`030000oooooooo00;oool2:RXZ0RDU9@:<S8`2N7Qh0WemO@QlO7`2Ng]k0WinOP9gMgL2
Q8B40SPh>0:HV9P2inOW0WemO@YlO7`2NGUi0X:2PP9:BTX2N7Qh0/K6aP800002b/[:0Vi^KP:4Q8@2
N7Qh0UeMG@;7alL2YZJV0VIVIP:FUYH2inOW0TM7A`:CTi<2SHf=0WYjNRIlO7`2NGUi0X>3P`9;Bd/E
O7al0WQhN0BATI42Ogmo0WEeM@9jNWX2]KFe0ZRXZ09aLG42P8200WAdM09]KFd2EEEE0Z:RXP820P82
00000XV9R@:1PH42De=C0XF5Q@9hN7P2OGem0W]kNcalO7`5oooo0@00007oool000Coool200001?oo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00<0003oooooool00_ooo`9KFe/2YJFU0W9b
LP9nOWh<O7al0WYjNP:1PH42K6a/1<?3``800002Ng]k27alO09kNg/2OWin0WEeM@:3Ph<22`/;0Vi^
KP;De=@2;2`/0WinOP9gMgL2OWin0Vm_K`::RXX2F5QH0VATI0:[Zj/2ZJVY0P00009mOGd2L71`0Wmo
O`9kNg/TO7al0W]kN`9mOGd2GUiN5GalO0AkNg/2IVIV0_Gem@:UYJD2:RXZ0VMWI`9lO7`2JFUY0VMW
I`::RXX2UIFE0YZJVP:>SXh2Lg=c0UiNGP8>3Ph2C4a<0Xf=S@9gMgL2OGem0W]kNcilO7`5oooo0@00
007oool001Goool00`000?ooooooo`02oooo0U]KF`:UYJD2LW9b0WinOPalO7`2NWYj0X61P@9/K6`4
`l?30P00009kNg/8O7al0W]kN`9nOWh2MGEe0X>3P`8;2`/2KVi^0]CDe08/;2`2OWin0WMgM`9nOWh2
Kfm_0XZ:RP9HF5P2I6AT0Z^[Z`:YZJT200000WemO@9`L702Ogmo0W]kNbAlO7`2Ng]k0WemO@9NGUhE
O7al17]kN`9VIVH2mOGe0ZFUY@8Z:RX2IfMW0WalO09YJFT2IfMW0XZ:RP:EUID2VYZJ0Xj>SP9cLg<2
GUiN0Ph>3P9<C4`2SHf=0WMgM`9mOGd2Ng]k?WalO0Goool100000Oooo`005Oooo`030000oooooooo
00;oool2QhN70WAdM09nOWh2Ng]k2WalO09kNg/2OGem0WUiN@:3Ph<2GemO0X20P0;5aLD<O7al0W]k
N`:0P802M7Ad0/g=c@;oool2dM7A0Y^KV`9kNg/2OGem0W]kN`9WIfL2?Cdm0U]KF`9RHV82e]KF0P00
00:g]kL2OGem0X61P@9jNWXXO7al0WYjNP:9RHTIO7al0X20P09ZJVX2SHf=0X61P@;oool2[Zj^0SPh
>08e=CD2HF5Q0XV9R@:;Rh/2o_kn0Xn?S`:g]kL2SHf=0X^;R`9fMWH2OWin0W]kNd1lO7`5oooo0@00
007oool001Goool00`000?ooooooo`02oooo0XN7Q`9dM7@2OWin0W]kN`YlO7`2Ng]k0WemO@9iNGT2
Ph>30UmOG`:0P802aLG537alO09kNg/2P8200WAdM0;=cLd2oooo0]7Ad@:KVi/2Ng]k0WemO@9kNg/2
IfMW0Sdm?@9KFe/2HV9R0]KFeP800002]kNg0WemO@:1PH42NWYj:7alO09jNWX2RHV96GalO0:0P802
JVYZ0Xf=S@:1PH42oooo0Zj^[P8h>3P2=CDe0V5QH@:9RHT2Rh^;0_knoP:?Shl2]kNg0Xf=S@:;Rh/2
MWIf0WinOP9kNg]0O7al1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`:7QhL2OWin47al
O09kNg/2OGem0WQhN0::RXX4FUYJ3WalO09iNGT2PX:20UeMG@9YJFT2PX:20WmoO`9jNWX4O7al0XF5
Q@:NWYh2Bd];0Vi^KP:OWil2RHV90W=cL`9iNGT^O7al0WMgMaUlO7`2NWYj0X:2PP9iNGT2O7al0ZJV
YP9iNGT2JFUY0V5QH@:<S8`2De=C0UMGE`9/K6`2KFe]0Va/K09eMGD2MgMg0WemO@9kNg]2O7al1Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`:7QhL2OWin47alO09kNg/2OGem0WQhN0::RXX4
FUYJ3WalO09iNGT2PX:20UeMG@9YJFT2PX:20WmoO`9jNWX4O7al0XF5Q@:NWYh2Bd];0Vi^KP:OWil2
RHV90W=cL`9iNGT^O7al0WMgMaUlO7`2NWYj0X:2PP9iNGT2O7al0ZJVYP9iNGT2JFUY0V5QH@:<S8`2
De=C0UMGE`9/K6`2KFe]0Va/K09eMGD2MgMg0WemO@9kNg]2O7al1Oooo`400001oooo000Eoooo00<0
003oooooool00_ooo`9jNWX2Ng]k2WalO0AkNg/4O7al0W]kN`9mOGd2MgMg0XF5Q@::RXX6O7al0Wem
O@IlO7`2OGem0WYjNPB6QXH2Ng]k0WemO@IlO7`2NGUi0W5aL@:9RHT2P82017AdM0:1PH4JO7al17]k
Na9lO7`2OGem6galO09jNWX2O7al0WemO@9fMWH2OWin0WmoO`:2PX82MWIf0XN7Q`:6QXH2PX:20Wmo
O`:1PH42OWin0WemO@9kNg/bO7al17]kN`ilO7`5oooo0@00007oool001Goool200000oooo`9jNWX2
Ng]k2WalO0AkNg/4O7al0W]kN`9mOGd2MgMg0XF5Q@::RXX6O7al0WemO@IlO7`2OGem0WYjNPB6QXH2
Ng]k0WemO@IlO7`2NGUi0W5aL@:9RHT2P82017AdM0:1PH4JO7al17]kNa9lO7`2OGem6galO09jNWX2
O7al0WemO@9fMWH2OWin0WmoO`:2PX82MWIf0XN7Q`:6QXH2PX:20WmoO`:1PH42OWin0WemO@9kNg/b
O7al17]kN`ilO7`4oooo0P00007oool001Goool00`000?ooooooo`02oooo3WalO0AmOGd6O7al0W]k
N`9mOGd2N7Qh0WIfMPIlO7`2NWYj0W]kN`IlO7`2OGem0WUiN@9gMgL4Ng]k1WalO09mOGd2Ogmo0WMg
M`9jNWX2Ogmo0X20P09jNWXJO7al0WinOP9mOGdBO7al0W]kNamlO7`2Ng]k0WemO@AkNg/2NWYj0Win
OPAhN7P2NWYj0W]kN`9jNWX4Ng]k<WalO09kNg/4OWin3WalO0Goool100000Oooo`005Oooo`030000
oooooooo00;oool>O7al17emO@IlO7`2Ng]k0WemO@9hN7P2MWIf1WalO09jNWX2Ng]k1WalO09mOGd2
NGUi0WMgM`AkNg/6O7al0WemO@9oOgl2MgMg0WYjNP9oOgl2P8200WYjNQYlO7`2OWin0WemOA9lO7`2
Ng]k7galO09kNg/2OGem17]kN`9jNWX2OWin17QhN09jNWX2Ng]k0WYjNPAkNg/bO7al0W]kN`AnOWh>
O7al1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`ilO7`2NWYj0WQhN09kNg/6O7al0W]k
N`9mOGd2OWin1WalO0:0P802OGem27alO0AmOGd<O7al0W]kN`9mOGd2O7al17]kNaalO7`2NGUi0W]k
N`9jNWX2Ng]k>GalO09kNg/4OGem?7alO09mOGd2N7Qh0WMgM`9kNg/2O7al0WYjNP9kNg/6O7al1Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`ilO7`2NWYj0WQhN09kNg/6O7al0W]kN`9mOGd2
OWin1WalO0:0P802OGem27alO0AmOGd<O7al0W]kN`9mOGd2O7al17]kNaalO7`2NGUi0W]kN`9jNWX2
Ng]k>GalO09kNg/4OGem?7alO09mOGd2N7Qh0WMgM`9kNg/2O7al0WYjNP9kNg/6O7al1Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`QlO7`2Ng]k0WinOP9eMGD2VIVI0Z2PX09jNWX2OGem27al
O09kNg/2O7al17UiN@8n?Sh2MgMg0WUiN@9mOGd2Ng]k17alO09kNg/>O7al0W]kNaalO7`2Ng]k0Win
OP9gMgL2[Jf]0ZFUY@9lO7`2Ph>30WYjNPmlO7`2Ng]kI7alO09kNg/2Ogmo0W1`L0:b/[82^KVi0WAd
M09nOWh2Ph>30WmoO`9kNg/4O7al1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`QlO7`2
Ng]k0WinOP9eMGD2VIVI0Z2PX09jNWX2OGem27alO09kNg/2O7al17UiN@8n?Sh2MgMg0WUiN@9mOGd2
Ng]k17alO09kNg/>O7al0W]kNaalO7`2Ng]k0WinOP9gMgL2[Jf]0ZFUY@9lO7`2Ph>30WYjNPmlO7`2
Ng]kI7alO09kNg/2Ogmo0W1`L0:b/[82^KVi0WAdM09nOWh2Ph>30WmoO`9kNg/4O7al1Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`alO7`2OGem0WEeM@9BDU82L71`0WinOPilO7`2Ogmo0X^;
R`:>SXhjO7al0W]kN`9mOGd2NWYj0Z6QX@9KFe/2IFEU0WmoO`9kNg/2O7al0W]kN`UlO7`2OGem17al
O09kNg/2O7al0W]kNeilO7`2OGem0WYjNP9SHf<2HV9R0XJ6QP9HF5P2I6AT0X:2PP9iNGT2O7al1Ooo
o`400001oooo000Eoooo00<0003oooooool00_ooo`alO7`2OGem0WEeM@9BDU82L71`0WinOPilO7`2
Ogmo0X^;R`:>SXhjO7al0W]kN`9mOGd2NWYj0Z6QX@9KFe/2IFEU0WmoO`9kNg/2O7al0W]kN`UlO7`2
OGem17alO09kNg/2O7al0W]kNeilO7`2OGem0WYjNP9SHf<2HV9R0XJ6QP9HF5P2I6AT0X:2PP9iNGT2
O7al1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`QlO7`2Ng]k0WemO@9kNg/2P8200VEU
I@:DU9@2MGEe0WUiN@YlO7`2NWYj0XV9R@:2PX82H61P0Y:BTP9hN7P2Ng]k47alO09kNg/HO7al0W]k
N`IlO7`2OGem0WYjNP:3Ph<2O7al0]3@d0:BTY82C4a<0WEeM@9jNWX2OWin0WemO@AlO7`2Ng]k0Wal
O003NGUiMgMgMgMg00AlO7`4OWin0WmoOc1lO7`2Ng]k0WalO09kNg/2O7al0W]kNbAlO7`2LG5a0YVI
V@8l?3`2?Cdm0YNGU`9UIFD200000Xj>SP9fMWH2OWin1Oooo`400001oooo000Eoooo0P0000?oool8
O7al0W]kN`9mOGd2Ng]k0X20P09UIFD2U9BD0WEeM@9iNGT:O7al0WYjNP:9RHT2PX:20V1PH0:BTY82
N7Qh0W]kNa1lO7`2Ng]k67alO09kNg/6O7al0WemO@9jNWX2Ph>30WalO0;@d=02TY:B0Ta<C09eMGD2
NWYj0WinOP9mOGd4O7al0W]kN`9lO7`00gUiNGMgMgMgM`04O7al17inOP9oOgl`O7al0W]kN`9lO7`2
Ng]k0WalO09kNg/TO7al0W5aL@:IVIT2?3`l0Sdm?@:GUiL2IFEU0P0000:>SXh2MWIf0WinOPCoool2
00000Oooo`005Oooo`030000oooooooo00;oool2O7al0WYjNP9iNGT2NWYj0WalO09hN7P2Q8B40T=3
@`8i>CT2XJ6Q0W]kN`:>SXh2NGUi0WalO09iNGT2Ng]k0WYjNP9oOgl2IfMW0WUiN@820P82Kfm_0WMg
M`:5QHD2NWYj0W]kN`9hN7P2O7al17]kN`AmOGd2OWin0W]kN`9iNGT4NWYj17alO0AkNg/2OGem0W]k
N`AlO7`2OWin17alO09kNg/2NGUi0X20P09XJ6P2^[Zj0^GUi@8];Bd2/K6a0WAdM0:2PX82NGUi0WIf
MP9mOGd2NWYj0WmoO`9lO7`00h>3PhJ6QXJ6QP02Ng]k0WalO09aLG42M7Ad0W5aL@9mOGd2Ng]k0Wem
O@AjNWX4O7al17]kN`9lO7`2OGem0WYjNPAlO7`4NWYj27alO09kNg/2O7al17YjNP9nOWh2Ng]k0Wmo
O`9kNg/2Ogmo17]kN`AlO7`4NWYj2WalO0AjNWX4O7al0W]kN`9lO7`2Ogmo0Y>CT`9cLg<2Z:RX0Te=
C@9YJFT292@T0Y2@T09_Kfl2OGem0WmoO`Goool100000Oooo`005Oooo`030000oooooooo00;oool2
O7al0WYjNP9iNGT2NWYj0WalO09hN7P2Q8B40T=3@`8i>CT2XJ6Q0W]kN`:>SXh2NGUi0WalO09iNGT2
Ng]k0WYjNP9oOgl2IfMW0WUiN@820P82Kfm_0WMgM`:5QHD2NWYj0W]kN`9hN7P2O7al17]kN`AmOGd2
OWin0W]kN`9iNGT4NWYj17alO0AkNg/2OGem0W]kN`AlO7`2OWin17alO09kNg/2NGUi0X20P09XJ6P2
^[Zj0^GUi@8];Bd2/K6a0WAdM0:2PX82NGUi0WIfMP9mOGd2NWYj0WmoO`9lO7`00h>3PhJ6QXJ6QP02
Ng]k0WalO09aLG42M7Ad0W5aL@9mOGd2Ng]k0WemO@AjNWX4O7al17]kN`9lO7`2OGem0WYjNPAlO7`4
NWYj27alO09kNg/2O7al17YjNP9nOWh2Ng]k0WmoO`9kNg/2Ogmo17]kN`AlO7`4NWYj2WalO0AjNWX4
O7al0W]kN`9lO7`2Ogmo0Y>CT`9cLg<2Z:RX0Te=C@9YJFT292@T0Y2@T09_Kfl2OGem0WmoO`Goool1
00000Oooo`005Oooo`030000oooooooo00;oool2Ng]k0X61P@:6QXH2P8200X61P@9jNWX2SHf=0S4a
<@8T92@2]KFe0W9bLP8d=3@2QXJ60WQhN0:7QhL2OWin0WemO@9hN7P2IfMW0Z:RXP9MGEd2kno_0XN7
Q`9LG5`2PX:20WinOP:;Rh/2OGem1820P09hN7P2NGUi0WEeM@9nOWh2QHF518>3P`AkNg/4P8200WQh
N09nOWh2O7al0WYjNP9bLW82O7al0W]kN`:2PX82P8200WemO@9_Kfl2T92@0X>3P`8l?3`2_;bl0WYj
NP9SHf<2W9bL0XN7Q`9jNWX2QHF50Vm_K`9lO7`00eYJFP@410@41002QHF50WIfMP:e]KD2YJFU0Zn_
[`9hN7P2OGem0WQhN0:1PH42P8200WinOP9kNg/2PH610WalO09kNg/2MgMg0XB4Q09jNWX2OGem0XB4
Q0:1PH42NGUi0WemO@9kNg/2O7al0WinOP9lO7`2PX:20XB4Q09fMWH2O7al0Vi^KP9oOgl2Kfm_0Wmo
O`9lO7`4Ng]k0X:2PP:3Ph<2Ng]k1WalO09kNg/4Ph>30WYjNP9mOGd2O7al0WemO@9kNg/2ZZZZ0YVI
V@:KVi/2KFe]0Z^[Z`:RXZ82Hf=S0[Vi^@:`/;02EUIF1Oooo`400001oooo000Eoooo00<0003ooooo
ool00_ooo`9kNg/2PH610XJ6QP:0P802PH610WYjNP:=SHd2<C4a0R@T90:e]KD2LW9b0S@d=0:6QXH2
N7Qh0XN7Q`9nOWh2OGem0WQhN09WIfL2XZ:R0UeMG@;_knl2QhN70UaLG0:2PX82OWin0X^;R`9mOGd4
P8200WQhN09iNGT2MGEe0WinOP:5QHD4Ph>317]kN`B0P802N7Qh0WinOP9lO7`2NWYj0W9bLP9lO7`2
Ng]k0X:2PP:0P802OGem0Vm_K`:@T902Ph>30S`l?0:l_;`2NWYj0V=SH`:LW9`2QhN70WYjNP:5QHD2
Kfm_0WalO003FUYJ10@410@400:5QHD2MWIf0[Fe]@:UYJD2[jn_0WQhN09mOGd2N7Qh0X61P@:0P802
OWin0W]kN`:1PH42O7al0W]kN`9gMgL2Q8B40WYjNP9mOGd2Q8B40X61P@9iNGT2OGem0W]kN`9lO7`2
OWin0WalO0:2PX82Q8B40WIfMP9lO7`2KVi^0WmoO`9_Kfl2Ogmo0WalO0AkNg/2PX:20X>3P`9kNg/6
O7al0W]kN`B3Ph<2NWYj0WemO@9lO7`2OGem0W]kN`:ZZZX2VIVI0Y^KV`9]KFd2Zj^[0Z:RXP9SHf<2
^KVi0[2`/09FEUH5oooo0@00007oool001Goool00`000?ooooooo`02oooo0WYjNP9TI6@2D51@0Va/
K09XJ6P2MgMg0UADE0:j^[X292@T0/C4a09`L702IfMW0V=SH`:2PX82Bd];0Vi^KP9_Kfl2V9RH0Y>C
T`800002EUIF0YBDU09:BTX2K6a/0XZ:RP9SHf<2>CTi0W=cL`9[Jf/2HF5Q0X^;R`:<S8`2Shn?0W9b
LP9BDU82GemO0UiNGP9oOgl2OWin16IVIP:ATI42LG5a0WAdM0:2PX82Z:RX0WUiN@:0P802HV9R0VAT
I09kNg/2M7Ad0VMWI`800002[jn_0QlO7`:RXZ82aLG50Va/K08L71`2O7al0WmoO`:/[:`2Ng]k00<0
001>CTi>CTh00YRHV09VIVH2g=cL0^WYj@:ZZZX2PH610X20P0:4Q8@4IVIV0WIfMP9mOGd2Jf][0Win
OP9mOGd2U9BD0UQHF0:7QhL2MWIf0UQHF09RHV82QHF50WUiN@9mOGd2NWYj0WAdM09mOGd2GEeM0UQH
F0:=SHd2N7Qh0[Ng]`9^KVh2][Jf0WEeM@AmOGd2PX:20UmOG`9LG5`2P8200WUiN@9lO7`2Ng]k0X20
P09MGEd2G5aL0XJ6QP9hN7P2NGUi0WYjNP9fMWH2S8b<0YbLW0:>SXh2/[:b0YfMW@800002KFe]0SHf
=P:/[:`23`l?1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9jNWX2I6AT0U1@D09/K6`2
J6QX0WMgM`9DE5@2^[Zj0R@T90;4a<@2L71`0VMWI`9SHf<2PX:20T];B`9^KVh2Kfm_0YRHV0:CTi<2
00000UIFEP:DU9@2BTY:0Va/K0::RXX2Hf=S0STi>@9cLg<2Jf][0V5QH@:;Rh/2S8b<0Xn?S`9bLW82
DU9B0UmOG`9NGUh2Ogmo0WinOPAVIVH2TI6A0W5aL@9dM7@2PX:20ZRXZ09iNGT2P8200V9RHP9TI6@2
Ng]k0WAdM09WIfL200000Zn_[`8O7al2XZ:R0/G5a@9/K6`271`L0WalO09oOgl2[:b/0W]kN`030000
CTi>CTi>00:HV9P2IVIV0]cLg0;YjNT2ZZZZ0X61P@:0P802Q8B416IVIP9fMWH2OGem0V][J`9nOWh2
OGem0YBDU09HF5P2QhN70WIfMP9HF5P2HV9R0XF5Q@9iNGT2OGem0WYjNP9dM7@2OGem0UeMG@9HF5P2
SHf=0WQhN0:g]kL2KVi^0[Jf]P9eMGD4OGem0X:2PP9OGel2G5aL0X20P09iNGT2O7al0W]kN`:0P802
GEeM0UaLG0:6QXH2N7Qh0WUiN@9jNWX2MWIf0Xb<S0:LW9`2SXj>0[:b/P:MWId200000Ve]K@8f=SH2
[:b/0Pl?3`Goool100000Oooo`005Oooo`030000oooooooo00;oool2PH610X:2PP9ZJVX2UIFE0UiN
GP9hN7P2MgMg0YZJVP9EEED2GUiN0TU9B@;=cLd2B4Q80VMWI`93@d<2?clo0Ve]K@:OWil2T92@0X>3
P`:XZ:P2EEEE0UIFEP9SHf<2X:2P0V][J`9CDe<2Fe]K0X20P08H61P2JVYZ0ZNWY`8^;Rh2EEEE0SHf
=P:@T902D51@0XJ6QP9kNg/2B4Q80U9BDP:n_[h2LW9b0QPH609iNGT2Z:RX0WinOP:0P802EEEE0UMG
E`:<S8`2PX:20UeMG@;oool2Ogmo0P0000:?Shl2c/k>0V1PH0;oool2FEUI0XF5Q@:UYJD2MGEe00>h
^;QIFEUIFET00T];B`:l_;`2bLW90Ti>CP8M7Ad2MGEe0V=SH`:4Q8@2?Cdm0S@d=0;3`l<2J6QX0_Sh
n0:HV9P2KVi^0YbLW09EEED2NWYj0Zj^[P:1PH42Bd];0X:2PP9lO7`2OWin0XR8R0:;Rh/2T92@0UiN
GP9[Jf/27QhN0W=cL`:b/[82PX:20Zj^[P:RXZ82^k^k0V5QH@:8R8P2FEUI0UmOG`:8R8P4OGem0WMg
M`::RXX2HF5Q0UmOG`AkNg/2R8R80XN7Q`9hN7P2VIVI0Zn_[`800002KFe]0SLg=`800002IFEU0P00
00;QhN427QhN1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`:1PH42PX:20VYZJP:EUID2
GUiN0WQhN09gMgL2VYZJ0UEEE@9NGUh2BDU90/g=c@98B4P2IfMW0T=3@`8o?cl2KFe]0YnOW`:@T902
Ph>30ZRXZ09EEED2EUIF0V=SH`:PX:02Jf][0U=CD`9KFe/2P8200QPH609ZJVX2YjNW0Rh^;P9EEED2
=SHf0Y2@T09@D502QXJ60W]kN`98B4P2DU9B0[jn_P9bLW8261PH0WUiN@:XZ:P2OWin0X20P09EEED2
EeMG0Xb<S0:2PX82GEeM0_ooo`9oOgl200000Xn?S`;>c/h2H61P0_ooo`9IFET2QHF50ZFUY@9eMGD0
0kRh^5UIFEUIF@02Bd];0[bl_0;9bLT2CTi>0QdM7@9eMGD2Hf=S0XB4Q08m?Cd2=3@d0/?3``9XJ6P2
n?Sh0YRHV09^KVh2W9bL0UEEE@9jNWX2[Zj^0X61P@9;Bd/2PX:20WalO09nOWh2R8R80X^;R`:@T902
GUiN0V][J`8N7Qh2Lg=c0[:b/P:2PX82[Zj^0Z:RXP:k^k/2HF5Q0XR8R09IFET2GemO0XR8R0AmOGd2
MgMg0XZ:RP9QHF42GemO17]kN`:8R8P2QhN70WQhN0:IVIT2[jn_0P00009]KFd2=cLg0P00009UIFD2
00000^7Qh@8N7Qh5oooo0@00007oool001Goool00`000?ooooooo`02oooo0[>c/`;:b/X2b<S80YJF
UP:d];@2KVi^0S`l?09[Jf/2[Jf]0Zb/[09EEED2QHF50WYjNP95ADD2Jf][0Va/K09mOGd2Ng]k0WEe
M@:PX:02FUYJ0RTY:@:HV9P2S8b<0_7al@:/[:`2WinO0UADE09SHf<2aLG50/S8b0:/[:`2/;2`0UUI
F@:>SXh292@T0R8R8P:;Rh/2/;2`0^GUi@8o?cl2BDU90TI6AP:h^;P2];Bd0XR8R09WIfL2L71`0[6a
/@:b/[82@T920V9RHP:9RHT2KVi^0V][J`9:BTX2=CDe0]3@d08n?Sh2Ph>30W1`L099BDT2oooo0W]k
N`03VIVIoooooooo00;QhN42/;2`100000:/[:`2`L710^7Qh@;`l?02WinO0VIVIP;7alL2P8200/k>
cP8e=CD200000X>3P`:8R8P2Xj>S0^;RhP;oool2f=SH0[^k^`9LG5`2W9bL0WEeM@8000021`L70WAd
M08G5aL2Q8B40/k>cP:SXj<22@T90Va/K0:MWId2UiNG0/?3``9^KVh2RHV90X20P08K6a/4MGEe0XR8
R09HF5P2K6a/0W1`L0:KVi/2P8200U5AD@9JFUX2MgMg0WIfMP9dM7@2T92@0YFEU@;_knl2D51@0Y:B
TP8:2PX2E5AD0YBDU0Goool100000Oooo`005Oooo`800003oooo0[>c/`;:b/X2b<S80YJFUP:d];@2
KVi^0S`l?09[Jf/2[Jf]0Zb/[09EEED2QHF50WYjNP95ADD2Jf][0Va/K09mOGd2Ng]k0WEeM@:PX:02
FUYJ0RTY:@:HV9P2S8b<0_7al@:/[:`2WinO0UADE09SHf<2aLG50/S8b0:/[:`2/;2`0UUIF@:>SXh2
92@T0R8R8P:;Rh/2/;2`0^GUi@8o?cl2BDU90TI6AP:h^;P2];Bd0XR8R09WIfL2L71`0[6a/@:b/[82
@T920V9RHP:9RHT2KVi^0V][J`9:BTX2=CDe0]3@d08n?Sh2Ph>30W1`L099BDT2oooo0W]kN`03VIVI
oooooooo00;QhN42/;2`100000:/[:`2`L710^7Qh@;`l?02WinO0VIVIP;7alL2P8200/k>cP8e=CD2
00000X>3P`:8R8P2Xj>S0^;RhP;oool2f=SH0[^k^`9LG5`2W9bL0WEeM@8000021`L70WAdM08G5aL2
Q8B40/k>cP:SXj<22@T90Va/K0:MWId2UiNG0/?3``9^KVh2RHV90X20P08K6a/4MGEe0XR8R09HF5P2
K6a/0W1`L0:KVi/2P8200U5AD@9JFUX2MgMg0WIfMP9dM7@2T92@0YFEU@;_knl2D51@0Y:BTP8:2PX2
E5AD0YBDU0Coool200000Oooo`005Oooo`030000oooooooo00;oool2X:2P0Ti>CP9cLg<2JFUY0^[Z
jP8U9BD2^[Zj0WUiN@B0P802QhN70[Vi^@8I6AT2?3`l0[6a/@9kNg/2^;Rh0/?3``:2PX82HF5Q0W=c
L`94A4@2a/K60_Ogm`8G5aL2<C4a0WYjNP:SXj<2Z:RX0Vm_K`;QhN42c/k>0S`l?0:;Rh/2Ng]k0Sdm
?@99BDT2Q8B40_ooo`;8b<P2A4A40_ooo`:][Jd2XZ:R0U1@D0;Bd]82WYjN0X^;R`:f][H2oooo0YNG
U`:BTY82G5aL0X20P09=CDd2NWYj0YRHV08[:b/2O7al0]oOg`:BTY82OGem0W1`L08Y:BT00f9RHWin
OWinOP02E5AD0Xj>SP8O7al2OGem0X61P@99BDT2LW9b0Z:RXP;oool2Ng]k0UUIF@9cLg<2JFUY0Zf]
[@:b/[8200000X61P@;Jf]X2@T920[fm_@9YJFT2LW9b0[Bd]08l?3`2IFEU0]KFeP:GUiL25aLG0]kN
gP8820P2oOgm0[2`/0;8b<P2YjNW0[Vi^@;<c<`21`L70XB4Q09RHV82a/K60Ti>CP:h^;P2JVYZ0W=c
L`9KFe/2JVYZ0T92@P8f=SH2k^k^0^CTi09kNg/2^[Zj0W5aL@9lO7`2M7Ad0V][J`:DU9@2Z:RX0Vm_
K`:@T902OGem0Ve]K@Goool100000Oooo`005Oooo`030000oooooooo00;oool2X:2P0Ti>CP9cLg<2
JFUY0^[ZjP8U9BD2^[Zj0WUiN@B0P802QhN70[Vi^@8I6AT2?3`l0[6a/@9kNg/2^;Rh0/?3``:2PX82
HF5Q0W=cL`94A4@2a/K60_Ogm`8G5aL2<C4a0WYjNP:SXj<2Z:RX0Vm_K`;QhN42c/k>0S`l?0:;Rh/2
Ng]k0Sdm?@99BDT2Q8B40_ooo`;8b<P2A4A40_ooo`:][Jd2XZ:R0U1@D0;Bd]82WYjN0X^;R`:f][H2
oooo0YNGU`:BTY82G5aL0X20P09=CDd2NWYj0YRHV08[:b/2O7al0]oOg`:BTY82OGem0W1`L08Y:BT0
0f9RHWinOWinOP02E5AD0Xj>SP8O7al2OGem0X61P@99BDT2LW9b0Z:RXP;oool2Ng]k0UUIF@9cLg<2
JFUY0Zf][@:b/[8200000X61P@;Jf]X2@T920[fm_@9YJFT2LW9b0[Bd]08l?3`2IFEU0]KFeP:GUiL2
5aLG0]kNgP8820P2oOgm0[2`/0;8b<P2YjNW0[Vi^@;<c<`21`L70XB4Q09RHV82a/K60Ti>CP:h^;P2
JVYZ0W=cL`9KFe/2JVYZ0T92@P8f=SH2k^k^0^CTi09kNg/2^[Zj0W5aL@9lO7`2M7Ad0V][J`:DU9@2
Z:RX0Vm_K`:@T902OGem0Ve]K@Goool100000Oooo`005Oooo`030000oooooooo00;oool2JFUY0ZVY
Z@;kno/2_kno0Y^KV`:_[jl2fm_K0WMgM`9_Kfl2JVYZ0XZ:RP8Y:BT2<C4a0V=SH`;Rh^82EEEE0^[Z
jP:@T902Shn?0/o?c`9XJ6P2Shn?0Rd];@98B4P400000Q@D509SHf<2/[:b0_7al@9gMgL200000[fm
_@9oOgl2][Jf0/;2`P9NGUh2c<c<0Rh^;P9OGel2@4100WUiN@8`<302J6QX0U5AD@9SHf<2d];B0/G5
a@800002@d=30U]KF`94A4@2dm?C0Te=C@:@T902OWin0Zf][@9>CTh2NGUi0P0000;=cLd2W9bL0V5Q
H@8/;2`00c@d=7moOgmoO`02Ng]k0WEeM@:][Jd2RXZ:0[Vi^@;oool271`L0VIVIP;lo?`2Rh^;0TY:
BP9^KVh4EEEE0T10@0;Ng]h200000PD51@;Hf=P2OWin0_Shn092@T82[:b/0Pl?3`9HF5P2FEUI0Te=
C@9/K6`2J6QX0Xn?S`@00002CTi>0XV9R@9ADE420@410/k>cP;QhN42b/[:0RPX:0::RXX2FUYJ0P00
008d=3@2MGEe0YRHV09UIFD2Xj>S0VATI0;oool2ATI60WUiN@:n_[h2e=CD0WalO0:4Q8@2Ng]k0WAd
M09nOWh2Ng]k0W1`L0;YjNT5oooo0@00007oool001Goool00`000?ooooooo`02oooo0VUYJ@:YZJT2
no_k0[no_`:KVi/2[jn_0]_Kf`9gMgL2Kfm_0VYZJP::RXX2:BTY0S4a<@9SHf<2h^;R0UEEE@;Zj^X2
T92@0Xn?S`;?cll2J6QX0Xn?S`8];Bd2B4Q81000008D51@2Hf=S0[:b/P;alO42MgMg0P0000:m_Kd2
Ogmo0[Jf]P;2`/82GUiN0/c<c08^;Rh2GemO0T10@09iNGT2<30`0VQXJ09ADE42Hf=S0];BdP;5aLD2
00000T=3@`9KFe/2A4A40]?Cd`9=CDd2T92@0WinOP:][Jd2CTi>0WUiN@800002cLg=0YbLW09QHF42
;2`/00<d=3AoOgmoOgl00W]kN`9eMGD2[Jf]0XZ:RP:i^KT2oooo0Q`L709VIVH2o?cl0X^;R`9:BTX2
KVi^15EEE@90@402g]kN0P0000851@D2f=SH0WinOP;hn?P2@T920Zb/[08?3`l2F5QH0UUIF@9=CDd2
K6a/0VQXJ0:?Shl400000Ti>CP:9RHT2DE5A0P410@;>c/h2hN7Q0/[:bP8X:2P2RXZ:0UYJFP800002
=3@d0WEeM@:HV9P2IFEU0Z>SX`9TI6@2oooo0TI6AP9iNGT2_[jn0]CDe09lO7`2Q8B40W]kN`9dM7@2
OWin0W]kN`9`L702jNWY1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9iNGT2M7Ad0_oo
o`;:b/X2a<C40SPh>0;Cdm<2Rh^;0T=3@`9XJ6P2HF5Q0SDe=@;De=@2SHf=0V1PH09gMgL2oooo0ZFU
Y@9ZJVX2C4a<0ZNWY`:BTY82_;bl0S/k>`9`L702^KVi0/G5a@8Z:RX2OGem0[:b/P8X:2P2EEEE0W]k
N`9>CTh2Kfm_0_ooo`8C4a<2GemO0ZJVYP;Rh^82fm_K0TM7A`9OGel2:BTY0W5aL@;EeMD2[Zj^0YRH
V0:h^;P200000Ta<C0:>SXh2OGem0X^;R`;2`/82OWin0WUiN@:3Ph<2GUiN0_Ogm`:HV9P2RXZ:0ZNW
Y`9>CTh00hj>SWYjNWYjNP02NGUi0XB4Q0:PX:02<S8b0WQhN09oOgl2^KVi0SXj>P9aLG42Ph>30]3@
d09;Bd/2Vi^K0WAdM0;Jf]X2V9RH0Xj>SP:7QhL2/K6a0[Fe]@:RXZ82[Jf]0Q4A4@:1PH42:2PX0_oo
o`8R8R82?Shn0T10@0800002DE5A0Zf][@;:b/X2QHF50[^k^`8_;bl2f][J0WUiN@9HF5P2De=C0[fm
_@8@4102O7al0^OWi`8G5aL2Jf][0UEEE@9?Cdl2Vi^K0]3@d09CDe<28b<S0XV9R@9cLg<2NWYj0XF5
Q@96ATH2C4a<0XJ6QP9dM7@2PH610W1`L0Goool100000Oooo`005Oooo`030000oooooooo00;oool2
NGUi0WAdM0;oool2b/[:0/C4a08h>3P2dm?C0X^;R`93@d<2J6QX0V5QH@8e=CD2e=CD0Xf=S@9PH602
MgMg0_ooo`:UYJD2JVYZ0Ta<C0:WYjL2TY:B0[bl_08k>c/2L71`0[Vi^@;5aLD2:RXZ0WemO@:b/[82
:2PX0UEEE@9kNg/2CTi>0Vm_K`;oool24a<C0UmOG`:VYZH2h^;R0]_Kf`97AdL2GemO0RTY:@9aLG42
eMGE0Zj^[P:HV9P2^;Rh0P00009<C4`2SXj>0WemO@:;Rh/2`/;20WinOP9iNGT2Ph>30UiNGP;gmoL2
V9RH0XZ:RP:WYjL2CTi>00>>SXijNWYjNWX00WUiN@:4Q8@2X:2P0S8b<P9hN7P2Ogmo0[Vi^@8j>SX2
LG5a0X>3P`;@d=02Bd];0Y^KV`9dM7@2f][J0YRHV0:>SXh2QhN70[6a/@:e]KD2XZ:R0Zf][@8A4A42
PH610RPX:0;oool28R8R0Shn?P90@40200000U5AD@:][Jd2b/[:0XF5Q@:k^k/2;bl_0][JfP9iNGT2
F5QH0U=CD`:m_Kd2410@0WalO0;WinL25aLG0V][J`9EEED2Cdm?0Y^KV`;@d=02De=C0R<S8`:9RHT2
Lg=c0WYjNP:5QHD2ATI60Ta<C0:6QXH2M7Ad0X61P@9`L705oooo0@00007oool001Goool00`000?oo
ooooo`02oooo0[Vi^@9OGel2d=3@0P00009WIfL2JFUY0[:b/P;hn?P2Xj>S0/o?c`9TI6@2UIFE0SXj
>P:?Shl28b<S0Sdm?@98B4P2=3@d0TE5A@:f][H22PX:0Y:BTP:4Q8@2DE5A0UeMG@;Shn<2oooo0^k^
kP9`L702LG5a0Zf][@9kNg/2O7al0V=SH`8T92@2KFe]0Q4A4@9IFET200000Te=C@AdM7@400000W]k
N`:MWId2ATI60V9RHP9@D502[Jf]0WemO@:WYjL2Shn?0V5QH@:LW9`2MWIf0W5aL@9lO7`2MgMg0VIV
IP9LG5`2EeMG0Z:RXP:l_;`00gEeMGemOGemO@02Ogmo17EeM@9lO7`2Vi^K0ZFUY@9SHf<2QhN70]_K
f`:LW9`2SHf=0U=CD`:d];@2?3`l0T10@09fMWH2K6a/0S0`<0:PX:02N7Qh0V9RHP9LG5`2C4a<0Vi^
KP8U9BD2Zj^[0UaLG0:XZ:P2Kfm_0[Ng]`;IfMT2CDe=0WinOP9hN7P2O7al0Z^[Z`:TY:@2RXZ:0UmO
G`800002T92@0Z>SX`:1PH42A4A40P<30`:f][H2X:2P0WQhN0:1PH42^;Rh0P`<309nOWh2I6AT0Wem
O@AlO7`2OGem0V=SH`:4Q8@2UYJF0W=cL`:4Q8@5oooo0@00007oool000?oool5000000Coool00000
00000003oooo00<0003oooooool00oooo`030000oooooooo00;oool2^KVi0UmOG`;@d=0200000VMW
I`9YJFT2/[:b0_Shn0:SXj<2clo?0VATI0:EUID2>SXj0Xn?S`8S8b<2?Cdm0TQ8B08d=3@2ADE50[Jf
]P8:2PX2TY:B0XB4Q09ADE42GEeM0^?Sh`;oool2k^k^0W1`L09aLG42[Jf]0W]kN`9lO7`2Hf=S0R@T
909]KFd24A4A0UUIF@800002CDe=17AdM0@00002Ng]k0YfMW@96ATH2HV9R0U1@D0:][Jd2OGem0ZNW
Y`:?Shl2HF5Q0YbLW09fMWH2LG5a0WalO09gMgL2IVIV0UaLG09GEeL2XZ:R0[bl_003MGEeOGemOGem
009oOgl4MGEe0WalO0:KVi/2YJFU0V=SH`:7QhL2fm_K0YbLW0:=SHd2De=C0[Bd]08l?3`2@4100WIf
MP9/K6`2<30`0Z2PX09hN7P2HV9R0UaLG09<C4`2KVi^0RDU9@:[Zj/2G5aL0ZRXZ09_Kfl2]kNg0]WI
f@9=CDd2OWin0WQhN09lO7`2Zj^[0ZBTY0::RXX2GemO0P0000:@T902Xj>S0X61P@94A4@20`<30[Jf
]P:PX:02N7Qh0X61P@:h^;P230`<0WinOP9TI6@2OGem17alO09mOGd2Hf=S0XB4Q0:FUYH2Lg=c0XB4
Q0Goool100000Oooo`001Oooo`050000oooooooooooo000000Coool00`000?ooo`000004oooo00<0
003oooooool00_ooo`810@42HV9R0X^;R`8l?3`2OGem0UADE09aLG42alO70Z:RXP:^[Zh2NWYj0YZJ
VP9UIFD27alO0PX:2P8@4102R8R80WemO@:2PX82YJFU0Q`L70:9RHT2HV9R0UmOG`9>CTh2l_;b0ZBT
Y0;oool22PX:0Tm?C`:LW9`2EeMG0Va/K09@D502QXJ60P820P:2PX82OGem0VUYJ@::RXX28B4Q0YbL
W08I6AT2fm_K0/71`@:7QhL2Ogmo0W]kN`:3Ph<2I6AT0ZRXZ0:][Jd2WIfM0VIVIP:NWYh2GEeM0Vi^
KP9mOGd2TY:B0YRHV09EEED27QhN0VEUI@:n_[h3OGem0WAdM0:HV9P2XJ6Q0W9bLP:PX:02]KFe0Xj>
SP:a/K42I6AT0TE5A@:h^;P2;Rh^0[^k^`9DE5@2]KFe0YbLW0;oool2dm?C0Z:RXP9RHV82l?3`0Shn
?P:3Ph<28R8R0[Zj^P9[Jf/2O7al0[fm_@:d];@2HF5Q0Q<C4`8a<C42oooo0[>c/`:^[Zh23@d=0_oo
o`9TI6@2QHF50XR8R09aLG42K6a/0WIfMP:<S8`2Shn?0WEeM@9bLW82NWYj0WUiN@:QXJ42MGEe0TY:
BP9[Jf/2MGEe0WemO@9lO7`2MWIf0V5QH@:>SXh2T92@0WYjNP9lO7`5oooo0@00007oool000Goool0
0`000?ooooooo`02oooo00L0003oooooooooool0003oool000001?ooo`800003oooo0P410@9RHV82
Rh^;0S`l?09mOGd2E5AD0W5aL@;7alL2XZ:R0Zj^[P9jNWX2VYZJ0VEUI@8O7al22PX:0Q0@40:8R8P2
OGem0X:2PP:UYJD271`L0XV9R@9RHV82GemO0Ti>CP;bl_82Y:BT0_ooo`8:2PX2Cdm?0YbLW09GEeL2
K6a/0U1@D0:6QXH20P820X:2PP9mOGd2JFUY0XZ:RP8Q8B42W9bL0QTI6@;Kfm/2`L710XN7Q`9oOgl2
Ng]k0X>3P`9TI6@2Z:RX0Zf][@:MWId2IVIV0YjNWP9MGEd2KVi^0WemO@:BTY82V9RH0UEEE@8N7Qh2
IFEU0[jn_P=mOGd2M7Ad0YRHV0:QXJ42LW9b0Z2PX0:e]KD2SXj>0[6a/@9TI6@2ADE50[Rh^08^;Rh2
^k^k0UADE0:e]KD2W9bL0_ooo`;Cdm<2XZ:R0V9RHP;`l?02?Shn0X>3P`8R8R82^[Zj0V][J`9lO7`2
_Kfm0[Bd]09QHF424a<C0S4a<@;oool2/k>c0Zj^[P8=3@d2oooo0VATI0:5QHD2R8R80W5aL@9/K6`2
MWIf0Xb<S0:?Shl2MGEe0W9bLP9jNWX2NGUi0Z6QX@9eMGD2BTY:0V][J`9eMGD2OGem0WalO09fMWH2
HF5Q0Xj>SP:@T902NWYj0WalO0Coool200000Oooo`001Oooo`030000oooooooo00;oool01`000?oo
ooooooooo`000?ooo`000004oooo00<0003oooooool00_ooo`800002`/;20_ooo`9eMGD2OWin0R`/
;09_Kfl2jn_[0XB4Q0;<c<`2Rh^;0RLW9`;oool2K6a/0YfMW@;dm?@2RHV90WAdM08D51@2YjNW0TY:
BP:[Zj/2:b/[0Z6QX@9LG5`2d=3@0WinOP9WIfL2Y:BT0P0000:WYjL2QXJ60Tm?C`;3`l<2U9BD0P00
009:BTX2<30`0UQHF0:WYjL200000U]KF`8820P2dM7A0[Fe]@9fMWH2IfMW0UUIF@9eMGD2^;Rh0U1@
D0:@T904LW9b0Y2@T0;Fe]H2P8200WEeM@:UYJD2kNg]0^7Qh@9fMWH2oooo0^[ZjP03NWYjOgmoOgmo
009eMGD2[:b/0V9RHP92@T82A4A40WemO@;6a/H2P8200TI6AP9cLg<2IVIV0XN7Q`9JFUX2@4100Vi^
KP97AdL2QHF50[Bd]0:7QhL2MWIf0[Zj^P9@D502HF5Q0V][J`;1`L4200000XV9R@;1`L4292@T0Ve]
K@:ATI42;2`/0PX:2P:_[jl2;Rh^0STi>@:RXZ82IVIV0X61P@9bLW82Ph>30Vi^KP9CDe<23`l?0Wal
O08J6QX2Q8B40X20P08d=3@2GEeM0W9bLP;:b/X2K6a/0WYjNP9kNg/2O7al0WYjNP9`L702G5aL0Y6A
T@9VIVH2NGUi1Oooo`400001oooo0005oooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000Coool00`000?ooooooo`02oooo0P0000;2`/82oooo0WEeM@9nOWh2;2`/0Vm_K`;[jn/2
Q8B40/c<c0:;Rh/29bLW0_ooo`9/K6`2WIfM0_Cdm0:9RHT2M7Ad0Q@D50:WYjL2BTY:0Z^[Z`8[:b/2
XJ6Q0UaLG0;@d=02OWin0VMWI`:TY:@200000ZNWY`:6QXH2Cdm?0/?3``:DU9@200000TY:BP8`<302
F5QH0ZNWY`800002Fe]K0PP820;AdM42]KFe0WIfMP9WIfL2FEUI0WEeM@:h^;P2D51@0Y2@T0AbLW82
T92@0]KFeP:0P802MGEe0ZFUY@;]kNd2hN7Q0WIfMP;oool2j^[Z00=jNWYoOgmoOgl00WEeM@:/[:`2
HV9R0T92@P94A4@2OGem0/K6aP:0P802ATI60W=cL`9VIVH2QhN70UYJFP90@402KVi^0TM7A`:5QHD2
];Bd0XN7Q`9fMWH2^[Zj0U1@D09QHF42Jf][0/71`@800002RHV90/71`@8T92@2KFe]0Y6AT@8/;2`2
2PX:0Zn_[`8^;Rh2>CTi0Z:RXP9VIVH2PH610W9bLP:3Ph<2KVi^0U=CD`8?3`l2O7al0QXJ6P:4Q8@2
P8200S@d=09MGEd2LW9b0/[:bP9/K6`2NWYj0W]kN`9lO7`2NWYj0W1`L09LG5`2TI6A0VIVIP9iNGT5
oooo0@00007oool000Coool200001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00<0
003oooooool01?ooo`:n_[h2C4a<0UUIF@:1PH42>CTi0Z6QX@800002YJFU0]OGe`:4Q8@200000QXJ
6P:ATI42_Kfm0YnOW`9WIfL2gMgM0/;2`P:6QXH2MWIf0Z>SX`8J6QX2:b/[0Xf=S@800002lO7a0UmO
G`:BTY82GUiN0VUYJ@9iNGT2V9RH0U=CD`9PH602h^;R0UIFEP;<c<`23`l?0/S8b09iNGT2VYZJ0XV9
R@9^KVh2ATI60Y2@T09/K6`2H61P0Xj>SP8L71`2aLG50Xn?S`;Ng]h2DE5A0ZJVYP;5aLD2OWin0W=c
L`:2PX82D51@0]7Ad@9jNWX2Hf=S0Vi^KP03Ng]kOGemOGem009gMgL2JVYZ0W=cL`;GemL2PX:20X>3
P`9=CDd2Ogmo0WAdM0:EUID2oooo0U5AD@:ZZZX2IfMW0YJFUP:?Shl2:b/[0UeMG@:TY:@2e]KF0R/[
:`9:BTX2oooo0UEEE@:VYZH2IFEU0Ta<C08g=cL2cLg=0_ooo`:1PH42O7al0YVIV@9iNGT2RHV90WQh
N0;Cdm<2WinO0WMgM`9jNWX2Q8B40VATI09_Kfl2TI6A0Y^KV`9XJ6P2][Jf0SLg=`9gMgL2/K6a0YZJ
VP9<C4`29RHV0Zb/[0:0P802Ogmo0Vm_K`9VIVH2IFEU0Y^KV`9TI6@2NGUi1Oooo`400001oooo000E
oooo00<0003oooooool01?ooo`:n_[h2C4a<0UUIF@:1PH42>CTi0Z6QX@800002YJFU0]OGe`:4Q8@2
00000QXJ6P:ATI42_Kfm0YnOW`9WIfL2gMgM0/;2`P:6QXH2MWIf0Z>SX`8J6QX2:b/[0Xf=S@800002
lO7a0UmOG`:BTY82GUiN0VUYJ@9iNGT2V9RH0U=CD`9PH602h^;R0UIFEP;<c<`23`l?0/S8b09iNGT2
VYZJ0XV9R@9^KVh2ATI60Y2@T09/K6`2H61P0Xj>SP8L71`2aLG50Xn?S`;Ng]h2DE5A0ZJVYP;5aLD2
OWin0W=cL`:2PX82D51@0]7Ad@9jNWX2Hf=S0Vi^KP03Ng]kOGemOGem009gMgL2JVYZ0W=cL`;GemL2
PX:20X>3P`9=CDd2Ogmo0WAdM0:EUID2oooo0U5AD@:ZZZX2IfMW0YJFUP:?Shl2:b/[0UeMG@:TY:@2
e]KF0R/[:`9:BTX2oooo0UEEE@:VYZH2IFEU0Ta<C08g=cL2cLg=0_ooo`:1PH42O7al0YVIV@9iNGT2
RHV90WQhN0;Cdm<2WinO0WMgM`9jNWX2Q8B40VATI09_Kfl2TI6A0Y^KV`9XJ6P2][Jf0SLg=`9gMgL2
/K6a0YZJVP9<C4`29RHV0Zb/[0:0P802Ogmo0Vm_K`9VIVH2IFEU0Y^KV`9TI6@2NGUi1Oooo`400001
oooo000Eoooo00<0003oooooool00_ooo`9nOWh2@4100S8b<P8P8202V9RH0S0`<09^KVh23Ph>0P00
00:ZZZX210@40UYJFP9FEUH2:BTY0Y2@T09hN7P2M7Ad0YVIV@9FEUH2e]KF0P00009kNg/2L71`0WMg
M`;Vi^H2RXZ:0Y^KV`9oOgl2[jn_0]oOg`:3Ph<2MgMg0W=cL`:4Q8@2HV9R0WUiN@:ATI42KVi^0Va/
K09MGEd2DU9B0R/[:`96ATH2^[Zj0Y>CT`8>3Ph2LW9b0UEEE@:LW9`2L71`0Y:BTP8g=cL2SXj>0Ta<
C0:IVIT2W9bL0WQhN09PH602fm_K0ZVYZ@9LG5`2VIVI0[jn_P9BDU800h20P7AdM7AdM002d=3@0_gm
o@9/K6`2PX:20/_;b`:n_[h2Fe]K0UADE0:k^k/2GUiN0WMgM`8B4Q82Kfm_0X>3P`9kNg/2Ph>30X61
P@:3Ph<2YJFU0V=SH`:>SXh2Ng]k0Va/K0:2PX82Ng]k0UIFEP9ZJVX2Rh^;0XJ6QP9dM7@2dm?C0[bl
_0861PH2:2PX0W=cL`:KVi/2@d=30WMgM`9?Cdl2YJFU0VIVIP9lO7`2M7Ad0W5aL@:PX:02>c/k0UmO
G`:7QhL2NWYj0ZZZZP9RHV82RXZ:0Rh^;P9kNg/2NWYj0WQhN0:>SXh2FUYJ0WQhN09_Kfl2P8200W]k
N`Goool100000Oooo`005Oooo`030000oooooooo00;oool2OWin0T10@08b<S82820P0YRHV08`<302
KVi^0Ph>3P800002ZZZZ0P@4109JFUX2EUIF0RTY:@:@T902N7Qh0WAdM0:IVIT2EUIF0]KFeP800002
Ng]k0W1`L09gMgL2i^KV0XZ:RP:KVi/2Ogmo0Zn_[`;Ogml2Ph>30WMgM`9cLg<2Q8B40V9RHP9iNGT2
TI6A0Vi^KP9/K6`2GEeM0U9BDP8[:b/2ATI60[Zj^P:CTi<23Ph>0W9bLP9EEED2W9bL0W1`L0:BTY82
=cLg0Xj>SP9<C4`2VIVI0YbLW09hN7P2H61P0]_Kf`:YZJT2G5aL0YVIV@:n_[h2DU9B00>0P81dM7Ad
M7@00]3@d0;moOd2K6a/0X:2PP;;bl/2_[jn0U]KF`9DE5@2^k^k0UiNGP9gMgL24Q8B0Vm_K`:3Ph<2
Ng]k0X>3P`:1PH42Ph>30ZFUY@9SHf<2SXj>0W]kN`9/K6`2PX:20W]kN`9FEUH2JVYZ0X^;R`:6QXH2
M7Ad0]?Cd`:l_;`21PH60RPX:09cLg<2Vi^K0T=3@`9gMgL2Cdm?0ZFUY@9VIVH2O7al0WAdM09aLG42
X:2P0S/k>`9OGel2QhN70WYjNP:ZZZX2HV9R0XZ:RP8^;Rh2Ng]k0WYjNP9hN7P2SXj>0UYJFP9hN7P2
Kfm_0X20P09kNg/5oooo0@00007oool001Goool00`000?ooooooo`02oooo0WQhN0:k^k/2OWin0WEe
M@9aLG42=cLg0P000090@402VIVI0]GEe@9RHV82;bl_0X20P0:KVi/2QXJ60YjNWP9fMWH2e=CD0VIV
IP9ADE42NGUi0P0000:ZZZX2/k>c0V][J`:6QXH2GEeM0XR8R0:UYJD2YjNW0Sdm?@:DU9@2RXZ:0[Fe
]@;2`/82=3@d0VATI0:1PH42MWIf0[Bd]08l?3`2eMGE19FEU@;Kfm/2e=CD0Xb<S0:5QHD2PX:20/C4
a0;moOd2KFe]0TY:BP9oOgl2O7al0WEeM@9^KVh2E5AD0UeMG@BBTY82OGem0WalO09oOgl00gYjNWal
O7alO002LG5a0Y6AT@;oool2KVi^0W9bLP:o_kl2F5QH0VMWI`9mOGd2Ogmo0XF5Q@:3Ph<4PH610U=C
D`:=SHd2k^k^0VIVIP:=SHd2g=cL0V9RHP:0P802PX:20WemO@9lO7`2R8R80WemO@9hN7P25aLG0V5Q
H@;?cll2De=C0Y6AT@:5QHD2IFEU0Vi^KP;2`/82CTi>0Ve]K@:e]KD2Z:RX0Vi^KP:IVIT2d=3@0U5A
D@;MgMd2/k>c0T51@@9BDU82HV9R0XZ:RP;2`/82G5aL0XZ:RP9iNGT2O7al0WemO@9hN7P2MgMg0W1`
L0:ATI42OWin1Oooo`400001oooo000Eoooo00<0003oooooool00_ooo`9hN7P2^k^k0WinOP9eMGD2
LG5a0SLg=`800002@4100YVIV@;EeMD2HV9R0Rl_;`:0P802Vi^K0XJ6QP:NWYh2MWIf0]CDe09VIVH2
DE5A0WUiN@800002ZZZZ0[>c/`9[Jf/2QXJ60UeMG@:8R8P2YJFU0ZNWY`8m?Cd2U9BD0XZ:RP:e]KD2
`/;20S@d=09TI6@2PH610WIfMP:d];@2?3`l0]GEe@BEUID2fm_K0]CDe0:<S8`2QHF50X:2PP;4a<@2
oOgm0Ve]K@9:BTX2Ogmo0WalO09eMGD2KVi^0UADE09MGEd4TY:B0WemO@9lO7`2Ogmo00=jNWYlO7al
O7`00W5aL@:ATI42oooo0Vi^KP9bLW82_kno0UQHF09WIfL2OGem0WmoO`:5QHD2Ph>31861P@9CDe<2
SHf=0^k^kP9VIVH2SHf=0]cLg09RHV82P8200X:2PP9mOGd2O7al0XR8R09mOGd2N7Qh0QLG5`9QHF42
clo?0U=CD`:ATI42QHF50VEUI@9^KVh2`/;20Ti>CP9]KFd2]KFe0ZRXZ09^KVh2VIVI0]3@d09ADE42
gMgM0[>c/`91@D42DU9B0V9RHP::RXX2`/;20UaLG0::RXX2NGUi0WalO09mOGd2N7Qh0WMgM`9`L702
TI6A0WinOPGoool100000Oooo`005Oooo`030000oooooooo00;oool2[jn_0UADE09>CTh2Ph>30Pd=
3@;Lg=`2WinO0Zb/[09LG5`2_kno0[^k^`;@d=02Shn?0VQXJ0:OWil2UIFE0Xn?S`9DE5@2A4A40Xn?
S`9<C4`26QXJ0Z6QX@8H61P2J6QX0XJ6QP9GEeL2:RXZ0X>3P`9kNg/2c/k>0P`<30:8R8P2];Bd0YjN
WP9@D502Ogmo0WQhN09iNGT2GemO0V1PH09mOGd2Jf][0]gMg@8X:2P2bl_;0Xj>SP9XJ6P2cLg=0Xj>
SP:5QHD2LG5a0X20P09lO7`2/k>c0Vm_K`;Hf=P2KFe]0WAdM09BDU82YJFU0_ooo`9`L702QHF500>l
_;cclo?clo<00U5AD@8G5aL28B4Q0U=CD`9jNWX2CTi>0ZJVYP93@d<2Shn?0WEeM@9jNWX2MgMg0WAd
M0:9RHT29RHV0XR8R0;oool2Kfm_0Z2PX0;oool2IfMW0[:b/P;:b/X2RHV90WQhN09iNGT4OGem0[^k
^`8f=SH2GEeM0WinOP9jNWX2M7Ad0P00009fMWH2NWYj0WUiN@8l?3`25QHF0WinOP:2PX82=CDe0/_;
b`8L71`2ZZZZ0WQhN0:VYZH2OGem0YBDU08D51@2XZ:R0XF5Q@AjNWX2PH610WQhN0;5aLD2GEeM0YVI
V@;5aLD2WYjN1Oooo`400001oooo000Eoooo0P0000?oool2[jn_0UADE09>CTh2Ph>30Pd=3@;Lg=`2
WinO0Zb/[09LG5`2_kno0[^k^`;@d=02Shn?0VQXJ0:OWil2UIFE0Xn?S`9DE5@2A4A40Xn?S`9<C4`2
6QXJ0Z6QX@8H61P2J6QX0XJ6QP9GEeL2:RXZ0X>3P`9kNg/2c/k>0P`<30:8R8P2];Bd0YjNWP9@D502
Ogmo0WQhN09iNGT2GemO0V1PH09mOGd2Jf][0]gMg@8X:2P2bl_;0Xj>SP9XJ6P2cLg=0Xj>SP:5QHD2
LG5a0X20P09lO7`2/k>c0Vm_K`;Hf=P2KFe]0WAdM09BDU82YJFU0_ooo`9`L702QHF500>l_;cclo?c
lo<00U5AD@8G5aL28B4Q0U=CD`9jNWX2CTi>0ZJVYP93@d<2Shn?0WEeM@9jNWX2MgMg0WAdM0:9RHT2
9RHV0XR8R0;oool2Kfm_0Z2PX0;oool2IfMW0[:b/P;:b/X2RHV90WQhN09iNGT4OGem0[^k^`8f=SH2
GEeM0WinOP9jNWX2M7Ad0P00009fMWH2NWYj0WUiN@8l?3`25QHF0WinOP:2PX82=CDe0/_;b`8L71`2
ZZZZ0WQhN0:VYZH2OGem0YBDU08D51@2XZ:R0XF5Q@AjNWX2PH610WQhN0;5aLD2GEeM0YVIV@;5aLD2
WYjN1?ooo`800001oooo000Eoooo00<0003oooooool00_ooo`9]KFd2h^;R0TI6AP8];Bd2E5AD0Wal
O0:VYZH2/;2`0XR8R0:TY:@2AdM70UiNGP9bLW82O7al0VMWI`:?Shl2CTi>0Slo?`:ZZZX2Xj>S0V][
J`810@42Ogmo0[Zj^P:2PX82WYjN0XZ:RP9OGel2QhN70Z>SX`:g]kL28R8R0V=SH`:7QhL2KFe]0T51
@@:ZZZX2oooo0WIfMP9hN7P2bl_;0X^;R`9QHF42RXZ:0_[jnP9eMGD2UIFE0YfMW@;:b/X2emOG0RTY
:@;:b/X2`L710W1`L09hN7P2a<C40XR8R09JFUX2[jn_0PT92@9;Bd/2ATI60X20P09nOWh00ooooeQH
F5QHF002QhN70X:2PP9ZJVX2oooo0VUYJ@9[Jf/2FUYJ0Y2@T09eMGD2OWin0WalO09oOgl2Ph>30WEe
M@;5aLD2O7al0WinOP;4a<@2NGUi0Rh^;P99BDT2_[jn0W1`L0851@D2U9BD0W=cL`9nOWh2@d=30_Og
m`8S8b<2S8b<0Ve]K@9iNGT200000UmOG`:1PH42Bd];0Y2@T09JFUX2Cdm?0WmoO`9ADE42U9BD0YbL
W0800002jNWY0SPh>0;[jn/230`<0X^;R`9MGEd2Kfm_0/O7a`9YJFT2Ph>30VQXJ0:3Ph<2c<c<0TY:
BP:DU9@2IFEU0ZJVYPGoool100000Oooo`005Oooo`030000oooooooo00;oool2KFe]0^;RhP96ATH2
;Bd]0UADE09lO7`2YZJV0[2`/0:8R8P2Y:BT0TM7A`9NGUh2LW9b0WalO09WIfL2Shn?0Ti>CP8o?cl2
ZZZZ0Z>SX`9[Jf/20@410WmoO`:j^[X2PX:20YjNWP::RXX2GemO0XN7Q`:SXj<2]kNg0R8R8P9SHf<2
QhN70Ve]K@91@D42ZZZZ0_ooo`9fMWH2N7Qh0/_;b`:;Rh/2HF5Q0XZ:RP;jn_X2MGEe0YFEU@:MWId2
b/[:0]OGe`8Y:BT2b/[:0/71`@9`L702N7Qh0/C4a0:8R8P2FUYJ0Zn_[`892@T2Bd];0TI6AP:0P802
OWin00?ooomHF5QHF5P00XN7Q`:2PX82JVYZ0_ooo`9YJFT2Jf][0UYJFP:@T902MGEe0WinOP9lO7`2
Ogmo0X>3P`9eMGD2aLG50WalO09nOWh2a<C40WUiN@8^;Rh2BDU90[jn_P9`L7021@D50YBDU09cLg<2
OWin0T=3@`;gmoL28b<S0Xb<S09]KFd2NGUi0P00009OGel2PH610T];B`:@T902FUYJ0Tm?C`9oOgl2
DE5A0YBDU0:LW9`200000^WYj@8h>3P2jn_[0P`<30:;Rh/2GEeM0Vm_K`;7alL2JFUY0X>3P`9XJ6P2
Ph>30/c<c09:BTX2U9BD0VEUI@:VYZH5oooo0@00007oool001Goool00`000?ooooooo`02oooo0Win
OP;EeMD2ATI60X61P@99BDT2fm_K0X61P@9:BTX2][Jf0W=cL`8b<S82O7al0XJ6QP9lO7`2K6a/0Xf=
S@9aLG42oooo0XB4Q09gMgL200000YFEU@:JVYX2I6AT0WYjNP9XJ6P2[Jf]0XZ:RP;Bd]82_[jn0^OW
i`:?Shl2Ng]k0X:2PP9nOWh2MWIf0VEUI@:1PH42QHF50]oOg`:>SXh2FEUI0Z>SX`8c<c<2CDe=0Y>C
T`:m_Kd2>CTi0YZJVP;0`<02Shn?0/g=c@9kNg/2]KFe0^[ZjP9RHV82>c/k0_KfmP9QHF42P8200YjN
WP:DU9@2Ng]k0WYjNP03LG5a5ADE5ADE009?Cdl2>3Ph0ZRXZ09SHf<2OGem0Xf=S@:CTi<2Lg=c0Wmo
O`9kNg/2OGem0WYjNP9aLG42P8200VATI09mOGd2Q8B40[^k^`9iNGT2PH610UEEE@:;Rh/2Jf][0T10
@0:3Ph<2OGem0Ve]K@:o_kl2A4A40/[:bP9_Kfl2GemO0U9BDP9aLG42UYJF0U]KF`:>SXh2@D510^GU
i@9VIVH292@T0Z2PX08Y:BT2S8b<0Z2PX09gMgL2FEUI0WMgM`9VIVH2S8b<0SLg=`8m?Cd2M7Ad0X:2
PP9HF5P2TY:B0YjNWP9OGel2AdM70X61P@:CTi<2P8201Oooo`400001oooo000Eoooo00<0003ooooo
ool00_ooo`9nOWh2eMGE0TI6AP:1PH42BDU90]_Kf`:1PH42BTY:0[Jf]P9cLg<2<S8b0WalO0:6QXH2
O7al0Va/K0:=SHd2LG5a0_ooo`:4Q8@2MgMg0P0000:EUID2VYZJ0VATI09jNWX2J6QX0Zf][@::RXX2
d];B0[jn_P;WinL2Shn?0W]kN`:2PX82OWin0WIfMP9UIFD2PH610XF5Q@;Ogml2SXj>0UUIF@:SXj<2
<c<c0Te=C@:CTi<2_Kfm0STi>@:JVYX2`<300Xn?S`;=cLd2Ng]k0[Fe]@;Zj^X2HV9R0S/k>`;fm_H2
HF5Q0X20P0:NWYh2U9BD0W]kN`9jNWX00g5aLADE5ADE5@02Cdm?0SPh>0:XZ:P2Hf=S0WemO@:=SHd2
Ti>C0W=cL`9oOgl2Ng]k0WemO@9jNWX2LG5a0X20P09TI6@2OGem0XB4Q0:k^k/2NGUi0X61P@9EEED2
Rh^;0V][J`90@402Ph>30WemO@9]KFd2_kno0TA4A0;:b/X2Kfm_0UmOG`9BDU82LG5a0YJFUP9KFe/2
SXj>0T51@@;UiND2IVIV0R@T90:PX:02:BTY0Xb<S0:PX:02MgMg0UUIF@9gMgL2IVIV0Xb<S08g=cL2
?Cdm0WAdM0:2PX82F5QH0Y:BTP:NWYh2GemO0TM7A`:1PH42Ti>C0X20P0Goool100000Oooo`005Ooo
o`030000oooooooo00;oool2C4a<0YjNWP:0P802SHf=0SXj>P:9RHT2VIVI0[Ng]`:0P802?clo0[Jf
]P:>SXh2WIfM0ZRXZ09nOWh2CTi>0Z2PX08000026a/K0Z>SX`:TY:@2EeMG0[Jf]P8[:b/2YZJV0Zf]
[@9BDU82JVYZ0UUIF@8];Bd2^[Zj0XJ6QP:h^;P2Lg=c0XB4Q09MGEd2Lg=c0[Zj^P9_Kfl2JFUY0Xj>
SP9[Jf/2Q8B40XJ6QP:8R8P2<C4a0YFEU@9OGel2PH610/30`0:ZZZX2JVYZ0YnOW`8a<C42KFe]0TE5
A@:3Ph<2Rh^;0X>3P`9JFUX2[Jf]0[>c/`9[Jf/2[Jf]00=VIVI]KFe]KFd00YRHV08G5aL2CTi>0Xn?
S`9/K6`2[:b/0[Rh^09^KVh2P8200W]kN`9^KVh2Z:RX0/W9b@9ZJVX2S8b<0WMgM`9kNg/2Jf][0X61
P@99BDT23Ph>0VUYJ@9QHF42Shn?0X:2PP9kNg/2OGem0WEeM@9]KFd200000Z:RXP9SHf<2_;bl0ZVY
Z@9lO7`200000Y6AT@9ADE42oooo0YRHV08Y:BT2Zj^[0VMWI`8B4Q82Fe]K0U9BDP;2`/82][Jf0__k
n`:4Q8@2P8200Pl?3`;:b/X2IFEU0[Vi^@9GEeL27QhN0S4a<@9QHF42NGUi0TM7A`;Hf=P5oooo0@00
007oool001Goool00`000?ooooooo`02oooo0Ta<C0:NWYh2P8200Xf=S@8j>SX2RHV90YVIV@:g]kL2
P8200Slo?`:f][H2SXj>0YfMW@:XZ:P2OWin0Ti>CP:PX:0200000Q/K6`:SXj<2Y:BT0UMGE`:f][H2
:b/[0ZJVYP:][Jd2DU9B0VYZJP9IFET2;Bd]0[Zj^P:6QXH2^;Rh0W=cL`:4Q8@2GEeM0W=cL`:j^[X2
Kfm_0VUYJ@:>SXh2Jf][0XB4Q0:6QXH2R8R80S4a<@:EUID2GemO0X61P@;0`<02ZZZZ0VYZJP:OWil2
<C4a0Ve]K@95ADD2Ph>30X^;R`:3Ph<2FUYJ0Zf][@:c/k<2Jf][0Zf][@03IVIVKFe]KFe]00:HV9P2
5aLG0Ti>CP:?Shl2K6a/0Zb/[0:h^;P2KVi^0X20P09kNg/2KVi^0ZRXZ0;9bLT2JVYZ0Xb<S09gMgL2
Ng]k0V][J`:1PH42BDU90Ph>3P9YJFT2HF5Q0Xn?S`:2PX82Ng]k0WemO@9eMGD2KFe]0P0000:RXZ82
Hf=S0[bl_0:YZJT2O7al0P0000:ATI42DE5A0_ooo`:HV9P2:BTY0Z^[Z`9WIfL24Q8B0U]KF`9BDU82
`/;20[Jf]P;kno/2Q8B40X20P08?3`l2b/[:0VEUI@:i^KT2EeMG0QhN7P8a<C42HF5Q0WUiN@97AdL2
f=SH1Oooo`400001oooo000Eoooo00<0003oooooool0ooooo`Ooool100000Oooo`005Oooo`030000
oooooooo0?ooool7oooo0@00007oool001Goool00`000?ooooooo`02oooo00<0003oooooool09Ooo
o`030000oooooooo02Goool00`000?ooooooo`0Uoooo00<0003oooooool09Oooo`030000oooooooo
02Coool00`000?ooooooo`0Uoooo00<0003oooooool04_ooo`400001oooo000Eoooo0P0000?oool0
0`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000
oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`030000oooooooo00Ooool0
0`000?ooooooo`07oooo00<0003oooooool01_ooo`030000oooooooo00Ooool00`000?ooooooo`07
oooo00<0003oooooool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003ooooo
ool01oooo`030000oooooooo00Ooool00`000?ooooooo`07oooo00<0003oooooool01oooo`800001
oooo000Eooooo`0000/00001oooo003ooooo8Oooo`00ooooob7oool00?oooolQoooo003ooooo8Ooo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-13.248, -11.0235, 0.501294, 
  0.501294}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  DensityGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[BoxData[
    RowBox[{"\[FilledCircle]", 
      StyleBox[
        RowBox[{" ", 
          StyleBox[" ",
            FontVariations->{"Underline"->True}]}]], 
      StyleBox["Multi",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Resolution",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox["Analysis",
        FontVariations->{"Underline"->True}], 
      StyleBox[" ",
        FontVariations->{"Underline"->True}], 
      StyleBox[\((2 D)\),
        FontVariations->{"Underline"->True}]}]], "Input"],

Cell["multiResolved=expanMatrix2D[wa,w,w,coif30];", "Input"],

Cell["\<\
recoveredGraph=
\tTable[ListDensityPlot[multiResolved[[i]],PlotRange->All,
\t\tMesh->False,PlotLabel->StringForm[\"Level `1`\",i],
\t\tDisplayFunction->Identity],{i,Length[multiResolved]}];\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
Do[Show[GraphicsArray[{{recoveredGraph[[i]],
\trecoveredGraph[[i+1]]}}]],{i,1,Length[multiResolved]-1,2}];\
\>", "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Level) show
99.000000 13.000000 moveto
(1) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
37332E2A262321212224262829292825201A140E09060506
090F151C23292D2F30302F2E2D2E30353B434B52595E6161
5F5B56504B4744434446484C4F5254565858595959595858
585757575656565656565656565657575859595A5957544F
49423B35302D2C2E3339414950575B5D5C5956514C484442
41404040403F3D3B
3C3834302D2A2827272828292A2927231F19140F0A08080A
0F161E262E34393C3C3B3A383636383C424951596065696A
6866625E5A5654535456585B5E6062636363626261606060
6161626363636362605E5B59575554555658595A5B595651
4941382F292423252B333D4751595F6363625F5B57534F4C
4B49494846454340
433F3B3734312F2D2C2C2C2B2B2927231F1A15110E0D0E12
19212A343C44494C4C4B4946444344474C535B62696F7375
7574716E6C696868696A6C6F7172737372716F6E6C6C6B6C
6D6F7172747473716D69645F5A57555556595B5E5F5F5B55
4C42372D241F1D1F26303C48545F676C6E6E6C6965615E5B
58565452504D4A47
4B47433F3C3936343231302E2D2B2925211D19161414171D
242E39434D565B5E5F5D5A5754525254595F666D747A7F82
83838281807F7E7E7F8182848586868583817E7C7A79797A
7C7E8184868685817C756E665F5A5756585B5F636666635C
5246392D231C1A1D242F3D4B596670777B7C7B7875726E6B
6865625E5B57534F
534F4A46433F3D3A38363433312F2C2926221F1D1C1E2128
323C48545F686E7272706D6965636264676D737A80868B8F
9193939494949495969798999999989693918E8B88878788
8B8E9295989896928B82786E655E5A595B5F64696D6E6B64
594C3E30251D1A1D26324050606E7A828789898885827E7B
77736F6B66625D58
5B56514D4945423F3D3B3938363533302D2A282626282D35
3F4B5864707A81848583807C78757374777B81878D93989C
9FA2A4A5A7A8A9AAAAABABABABAAA8A5A39F9C9997969697
9A9EA2A6A8A8A6A0988E82766C645F5E60656B707576746D
615445372B221F222A3746576776838C9295969593908D89
85817C77726C6661
635D57524D494543413F3E3E3E3D3C3A3734323131343941
4C596674808A92969695928E8A878585878B8F94999EA3A8
ACAFB2B4B7B8BABBBBBBBAB9B8B6B4B1AFACA9A6A4A3A4A5
A8ACB0B3B5B5B2ABA2978A7E736A6463666A71777C7E7C76
6B5D4E40342C282B333F4E5E6E7D8A939A9D9E9E9D9A9794
908C87827C767069
69625B554F4A4644434344454748474644423F3E3E40454D
586573808D979FA4A5A4A29E9B98969697999DA0A4A9ADB1
B5B9BDC0C3C5C6C7C6C5C4C2C0BEBBB9B7B4B3B1B0AFB0B2
B4B7BABCBEBCB9B2A89D908479706A696C71777E8385847E
74675A4D413936383F4A586675838E979DA0A2A2A19F9D9A
97938F8A847E7870
6E665D554F49464445474A4E5154555553514E4C4B4C5158
636F7D8A97A2AAAFB2B1B0ADABA8A6A5A6A7A9ABAEB1B5B8
BCC0C4C7CACDCECECDCBC8C6C3C0BDBCBABAB9B9B9B9BABC
BEC0C1C2C2C0BBB4AA9F94887E76717072777D83888B8A86
7D73675B514A47484E57626F7B8690989D9FA1A1A09F9D9B
9996938F8A857E76
71685E554D474444464B50575D62656564615D5A58595C63
6C7885929FAAB2B8BBBCBCBAB8B7B5B4B3B4B4B5B6B8BBBD
C1C5C8CCCFD1D2D1CFCCC8C5C1BEBCBBBBBCBDBFC0C2C3C4
C5C5C5C4C2BFBAB2AAA0968C837C7877797D83888D90908D
867E756B635D5A5B5F666E77808990969A9C9C9C9C9B9A99
989694928E89827B
73695E534B444243474E57606970757675716D696665676C
75808C99A5B0B8BFC3C5C6C6C5C4C2C1C0BFBFBEBDBEBFC1
C4C7CACED1D3D3D1CECAC6C1BDBAB8B8B9BCBFC3C6C8CACB
CBCAC7C5C1BCB6AFA79F968E87827F7E8084888D91949593
8F89837C76716F6F71757A80868B90939596969695949494
94949392908B857D
74695D5248423F4248525D69747E848685817C7773717175
7D87929EAAB4BDC4C9CDCFD0D0D0CFCDCCCAC7C5C3C2C2C3
C5C8CBCED1D3D2D0CCC7C2BCB8B4B3B4B7BBC0C5CACED0D1
CFCCC8C3BEB8B1AAA49D96908B888686878A8E9296999A9A
9895918D89868382838487898C8E90919190908F8E8D8D8D
8F9090918F8C877E
73675B4F463F3E414A5563727F8A929594908A847F7C7B7E
858E98A3AEB8C1C9CED3D6D8DADAD9D8D5D2CFCBC7C5C3C4
C5C8CBCED1D2D1CECAC4BDB7B2AEADAFB4BAC0C7CED2D5D5
D3CEC9C2BBB4ADA6A09B9793908E8D8D8E9194979A9D9FA0
A09F9E9C9A989695949392929291908F8E8C8A8887868687
898A8C8D8D8B867E
7065584D443E3E434C5A697988959EA1A09C96908A868486
8C949DA7B1BBC4CCD2D7DBDFE1E2E2E0DDD9D4CFCAC6C4C3
C4C7CACDCFD1D0CDC7C1B9B3ADA9A8ABB0B8C0C9D0D6D9D8
D5D0C8C0B8B0A9A39E9A9795949393949597999C9EA1A4A6
A7A8A9A9A8A7A6A4A2A09D9B989593908D8A878482808081
838587888987827A
6B60554B433F3F45505F6F808F9DA6AAA9A5A099938E8D8E
9299A2ABB4BEC6CED5DBDFE3E6E8E7E5E1DCD6D0CAC5C2C1
C3C5C8CCCFD0CFCCC6BFB7B0AAA6A5A8AEB6C0C9D1D7DBDA
D7D0C8C0B7AEA7A19D9A9897979898999B9C9EA0A3A6A8AB
ADAFB1B2B2B2B1AFADAAA6A39F9B97938F8B8784807E7D7D
7D7F808181807B74
635A51494441444B5664748594A1AAAEAEABA59F9A969495
999FA6AFB7C0C8D0D7DDE2E6E9EAEAE7E3DDD6CFC9C3C0BF
C0C3C7CBCED0D0CCC6BFB7AFA9A5A4A7ADB6BFC9D2D8DBDB
D7D1C9C0B7AEA7A29E9C9B9A9A9B9C9E9FA1A3A5A7AAACAF
B1B3B5B6B6B6B6B4B3B0ADAAA7A39F9A96918C87837F7C7A
797979797875716B
59534D4846464A525D6B7A8996A2AAAEAFACA8A39E9B999B
9EA4ABB2BAC2CAD1D8DDE2E7EAEBEAE7E2DBD4CCC5BFBCBB
BDC0C5CACED1D1CEC8C1B9B1ABA6A5A8AEB6BFC9D1D7DBDB
D7D1CAC1B9B1AAA4A19F9E9D9D9E9FA1A3A4A7A9ACAEB1B2
B4B5B6B6B6B6B5B5B4B3B2B0AEACA8A4A09A958F89837E7A
7774716E6C69645F
4E4B49484A4D535B66727F8B97A1A8ABACABA8A4A19F9EA0
A3A9AFB6BDC4CBD2D8DDE2E6E9E9E8E4DED7CFC7C0BAB7B7
B9BEC3C9CFD2D3D1CCC5BDB5AEAAA8AAAFB7BFC8D0D6D9D9
D6D1CBC3BCB4AEA9A5A3A1A1A0A1A2A3A5A8AAADB0B2B4B5
B5B5B4B3B2B1B1B1B2B4B5B6B6B5B3B0ABA69F989189827B
756E69645F5A5652
434446494E555C656F79848E969EA3A6A7A7A6A4A2A1A2A4
A8ADB2B9BFC5CCD2D8DDE1E4E6E6E4E0DAD2CAC1BAB4B1B2
B5BAC1C8CED3D5D3CFC8C1B9B3AEACADB1B8BFC7CED3D6D7
D5D1CBC5BFB9B3AFABA8A6A4A3A2A3A5A7AAADB1B4B6B8B7
B6B3B0ADABA9A9ABAEB1B5B9BCBEBEBCB8B2ABA39A90867C
72696058514B4744
393D444B545E67707981888F959A9EA0A1A2A2A2A2A2A4A7
ABB0B5BBC1C6CCD2D7DBDEE1E3E2DFDAD3CBC3BAB3ADABAC
B0B6BEC6CDD3D6D5D2CCC5BEB7B2B0B0B4B9BFC5CBCFD2D3
D2CFCBC7C2BDB9B4B0ADAAA7A5A4A4A6A9ACB0B4B7BABAB8
B5B0ABA6A29F9FA2A7ADB4BBC1C5C7C6C3BDB5ACA1968A7D
7063584D443D3937
3139434F5B67737C83898D91949698999B9C9D9FA1A3A5A9
ADB2B7BCC2C7CCD1D5D9DCDEDEDDDAD4CDC4BBB3ABA6A4A6
AAB2BAC3CBD2D6D6D3CFC8C2BCB7B4B3B5B9BEC3C7CBCECF
CECDCBC8C5C1BDB9B5B1AEAAA7A6A5A7AAAEB2B7BBBDBCB9
B4ADA59E989595989FA8B2BCC4CBCFCFCCC6BDB3A7998B7C
6C5D4F4237302C2C
2C37455464727F888E919293939292939496999C9FA3A6AB
AFB4B9BEC2C7CCD0D4D7D9DADAD8D4CEC6BEB4ACA49F9EA0
A5ADB6BFC8D0D4D6D4D0CBC5BFBAB7B6B7B9BCC0C3C6C8CA
CACAC9C8C6C4C1BEBAB6B1ADAAA7A7A9ACB0B5BABEBFBEBA
B2A99F968F8A8A8F97A2AFBBC6CFD4D5D2CBC2B6A99A8978
675646382D252225
2C3A4A5C6E7E8B949899989693908E8D8F9295999EA2A7AC
B1B5BABEC3C7CBCFD2D5D6D7D6D4CFC9C1B8AEA69E99989A
A0A7B1BBC4CCD1D4D3D0CCC7C2BDBAB8B8B9BBBCBEC0C2C4
C5C6C6C6C6C6C4C1BDB9B5B0ACAAA9ABAEB3B8BDC1C2C0BA
B1A69B9087828186909CABB9C6D0D6D7D4CCC1B4A6958472
5F4E3E30251E1D22
304053677A8B98A0A3A29E99948F8B8A8B8E93989DA3A8AD
B2B7BBBFC3C7CBCED1D3D4D5D4D1CCC5BDB3AAA19A959395
9BA2ACB6BFC7CDD0D0CECBC7C3BEBBB9B8B8B8B9BABBBCBE
BFC1C2C4C5C5C5C3C0BCB8B3AFADADAEB2B7BCC1C4C5C2BB
B1A5988B827B7A7F8A97A7B6C4CED5D5D1C8BBAD9D8C7A68
5646372A211C1D24
394B5F738798A4ABADAAA49D968F8B898A8D91979DA3A9AE
B3B8BCC0C3C7CACDD0D2D3D3D2CFCAC2BAB0A79E96918F91
969DA6B0B9C1C7CBCCCBC9C6C2BFBCB9B7B6B6B5B5B5B6B8
B9BBBEC0C2C4C4C3C1BEBAB6B3B1B1B3B6BBC0C4C7C7C4BC
B1A496897E78767B8593A3B2C0CAD0CFC9BFB1A1907E6C5B
4B3D3127211E222B
45586C8194A4B0B5B5B1AAA299918B89898C91969CA3A9AF
B4B8BCC0C4C7CACDD0D2D3D2D1CEC8C1B8AFA59C948F8D8E
9299A1AAB3BBC1C5C7C7C6C4C1BEBCB9B7B5B3B2B1B0B1B2
B3B6B9BCBFC1C2C2C1BFBCB9B7B5B5B7BBBFC4C8CAC9C5BD
B2A496887D767478828F9EADBAC4C8C6BEB2A392806E5D4D
40352C2623242B36
54667A8EA0AFB9BEBDB7AFA69C938C89898C90969CA2A9AF
B4B8BCC0C4C7CACDD0D2D3D3D1CDC8C1B8AEA49B938D8A8B
8E949CA4ACB4BABFC1C2C2C1C0BEBBB9B6B4B1AFADACABAC
AEB1B4B7BBBEC0C1C1C0BEBCBBBABABCC0C3C7CBCCCBC7BE
B2A596897D767377808C9AA8B3BBBEBAB1A392806E5D4D3F
352E2927282D3643
6375889BABB9C1C4C2BCB3A99E958E8A898B8F959BA1A8AE
B3B8BCC0C4C7CBCED1D2D3D3D1CEC8C1B8AEA49B938C8989
8C90979EA6ADB4B9BCBEBFBFBFBDBBB9B6B3B0ADAAA8A7A7
A9ACAFB3B7BBBEBFC0C0C0BFBEBEBFC1C4C7CACDCECCC7BE
B3A5978A7E7674767E8995A1ABB2B3AEA393826F5D4C3E33
2C29282A2F374352
718394A5B4BFC6C8C5BEB5AAA0968F8A898B8E93999FA5AB
B1B6BBBFC4C8CCCFD2D4D5D4D2CFC9C2B9AFA59B938C8887
898D9399A0A7AEB3B7BABCBEBEBEBCBAB7B3AFABA8A5A4A4
A5A8ABB0B4B8BCBEC0C1C1C1C2C2C3C5C8CACDCECECCC7BE
B3A6988B807875767D86909AA3A7A7A09484715F4D3E3129
2526292F38435060
7E8E9EADB9C2C8C8C5BEB5ABA0968F8A89898C90959BA2A8
AEB4B9BFC4C9CDD1D4D6D7D6D4D1CBC3BAB0A69C938C8786
878A8F949BA2A8AEB3B7BABDBEBFBEBCB8B4B0ABA7A3A1A1
A2A5A9ADB2B6BABEC0C2C3C4C5C5C7C8CACCCDCECDCAC5BC
B2A6998D827A76777C838B93999B99918575635141332923
23262D36424F5E6E
8897A4B0BAC1C5C5C1BAB2A99F968E8A8787898C90969CA2
A9B0B7BEC4CACFD4D7D9DADAD7D3CDC5BBB1A79C938C8784
84878B90969CA3A9AFB5B9BDC0C1C1BFBBB7B2ACA7A3A1A0
A1A4A7ACB1B5BABEC1C3C5C6C7C8C9CACBCCCDCCCAC7C1B9
AFA5998E847C78787A7F858A8E8E8B8376675747392D2523
252B343F4C5B6A79
8F9BA5AFB6BCBEBDB9B4ACA49C948D8885838486898E949B
A3ABB3BCC4CCD2D7DBDEDEDDDBD6CFC7BDB3A89D938B8682
8283878B91989FA6ADB3B9BEC2C5C5C3C0BBB5AFA9A5A2A0
A1A4A8ACB1B6BBBEC2C4C6C8C9CACACBCBCBCAC8C6C2BCB5
ACA3998F867F7A78797B7E8082817C74695C4F41362D2828
2C343E4A57657481
919BA3A9AFB2B3B2AFAAA49E97908A85817F7E7F81858A92
9BA5AFBAC4CDD5DCE0E2E3E2DED9D2C9BFB4A99E938B8581
7F8083888D949BA3ABB3BAC0C6C9CAC9C5C0BAB3ADA7A4A2
A3A5A9AEB2B7BCC0C3C6C8C9CACACACAC9C8C6C3C0BBB5AF
A7A0978F88817D797877777775736E675E544A4038333133
38404A56626F7B87
91989DA1A3A5A5A4A29F9B96918C87827E7A7877787B8088
939EABB8C4CFD9E0E5E7E8E6E2DDD5CCC1B5A99E938A847F
7D7E80848A9199A1AAB3BBC3C9CECFCECBC5BFB7B0AAA6A5
A5A8ABB0B4B9BEC2C5C7C9CACACACAC8C6C4C1BDB8B3AEA8
A29C96908A847F7B7774706D6A66615B554E48433F3D3E41
474F58626D77818A
8F929596969695959392908E8B88847F7A75716F6E71767F
8A98A7B5C4D1DCE4E9ECECEAE6E0D7CEC2B6AA9F948A837E
7C7C7E82878E97A0AAB3BDC6CDD2D4D3D0CAC3BCB4AEAAA8
A8AAAEB2B6BBC0C3C6C8C9CACACAC8C6C3BFBBB6B1ABA6A2
9D9995918C88827D77716B65605B56524E4B4A49494B4E52
585F676F777E858B
8C8C8B8A88868584848485858583807C77716C6866686D76
8292A2B3C3D2DFE8EDF0F0EEE9E2DACFC4B8AB9F948A827D
7B7B7D80868D969FAAB4BEC7CFD5D8D7D4CEC7BFB8B1ADAA
AAACB0B4B8BCC0C4C6C8C9CACAC9C7C4BFBBB5AFA9A49F9B
989694928F8C87807870675F57514D4A494B4D51555A5F65
6B71767C8185888B
8885817D7A77757475777A7C7E7F7D79746D67626060656E
7C8C9FB1C3D3E0EAF0F3F2F0EBE4DBD0C5B8ACA0948A837D
7B7B7C80868D969FAAB4BFC8D1D6D9D9D6D0CAC2BAB4AFAD
ACAEB1B4B8BCC0C3C5C7C8C9C8C7C5C1BCB6B0A9A39D9996
9594949493908C857B71665B524B4746484C535A626A7178
7D8185878A8B8B8A
837D77716C686565676B6F74787A7A77716B645F5B5B6069
77899CAFC2D2E0EAF1F3F3F0EBE4DBD0C5B9ACA0958B847F
7C7C7E82878E97A1ABB5BFC8D0D6D9D9D6D1CAC3BCB5B1AE
AEAFB1B4B8BBBEC1C3C5C6C7C7C5C3BEB9B2ABA49D979492
929395979896928A8074675B514945464A515B656F798289
8D909192918F8C88
7E766E665F5A58585B5F656B717577747069635D59595D67
75869AADC0D1DEE8EEF1F0EDE8E1D9CFC3B8ACA1968D8681
7F7F82868B929AA3ACB6BFC7CED3D6D5D3CEC8C2BBB5B1AE
AEAEB0B3B5B8BBBEC0C2C3C4C4C3C0BCB6AFA8A19A949190
9194989B9D9C9991877A6D60554D494B505965717D889197
9B9C9B9A96928C85
7A70675D554F4C4D50555C646B7173726F69635E5B5B5F68
768699ABBDCDDAE4E9EBEBE8E3DDD4CBC1B6ACA198908986
8485878C91979FA7AEB6BDC4C9CDCFCFCCC8C3BEB8B3AFAD
ACACADAFB1B4B6B9BBBDBFC0C1C0BEBAB4AEA69F98939090
93979BA0A3A3A09A8F8376695E5753555B65717D89949DA2
A5A5A29F9A938C83
766B61574E474444484E555E666D70716F6B66625F5F646C
798899AABAC8D4DDE1E3E3E0DCD6CEC6BDB4ABA299938E8B
8B8C8F93999EA5ABB1B6BBBFC3C5C6C5C3BFBCB7B3AFACAA
A9A9A9AAABADB0B2B5B8BABCBDBEBCB8B3ADA69F99949293
969BA0A5A9AAA9A39A8E82776D6562646A737E8A959EA6AA
ABAAA6A29B948B81
73685D5249423F3F4349515962696E70706D6A6766676B73
7E8C9AA9B7C3CDD4D8D9D9D6D3CEC7C0B9B1A9A29B969391
9294979CA1A6ABAFB3B5B8B9BABABAB9B7B4B2AFACA9A7A5
A4A3A3A3A4A6A8ABAEB1B4B8BABBBAB7B3AEA7A19C989697
9BA0A5ABB0B2B1ADA59C91877E7875767B838C969FA7ACAF
AFADA8A39C938A7F
72665B5047403D3D40464E575F676D717271706F6F71757C
85919DA9B4BEC6CBCECFCECCC9C5C0BAB4AEA8A39E9A9898
999CA0A4A9ADB0B2B3B3B3B2B0AEACAAA9A7A6A5A3A2A09F
9E9D9C9C9C9D9FA2A6AAAFB3B6B8B9B7B4AFAAA4A09D9B9D
A1A6ACB1B6B9BAB7B1AAA299928D8A8B8F949BA2A8ADB1B2
B1ADA8A29B92887D
71665A5047413D3D40464D565F676D7275767778797C8086
8E97A0A9B1B9BEC2C4C4C3C2BFBCB8B4B0ABA7A4A09E9E9F
A1A4A8ACB0B3B4B4B3B0ADA8A4A19D9B9A99999999999998
979695949495979A9FA4A9AFB3B6B8B7B5B1ADA9A5A2A2A3
A7ACB2B8BDC0C2C1BDB8B2ACA7A3A0A0A2A6AAAEB1B4B5B4
B1ADA8A19A91877C
72675D534B4542414449505860686F75797D7F8284888C91
979EA4AAB0B5B8BABBBBBAB8B6B4B2AFACA9A7A5A3A3A3A5
A8ABAEB2B5B6B6B4B0ABA49E98928E8B8A8A8B8C8E8F908F
8F8D8C8B8B8C8E92979EA4ABB1B5B8B8B7B5B1AEABA9A9AA
AEB3B8BEC3C7C9CAC8C6C2BEBBB8B6B5B5B7B8B9B9B9B8B5
B1ACA7A09990877D
756B6259524D4A4A4C50565E656D747A8084898C9094989C
A1A5A9ADB0B2B4B5B4B4B3B1B0AEADABA9A8A7A6A6A6A7AA
ACAFB2B5B6B6B4B0AAA39A928A837E7B7A7A7C7F82848586
858482818182858A9098A0A8AFB5B9BBBBB9B7B4B1B0B0B1
B5B9BEC4C9CDD0D2D2D1D0CECCCAC9C8C6C6C4C3C1BEBAB6
B2ACA6A09991887F
7A726A635D595656585C61676E757C82888E93989CA1A4A8
ABAEB0B1B2B3B3B2B1B0AFADACABAAA9A9A8A8A8A8A9ABAC
AFB1B2B4B4B2AEA8A1988E847B736D6A6A6B6D7175787A7B
7A79777676787B8189929CA6AFB6BCBFBFBFBDBAB8B7B7B8
BBBFC4C9CDD2D6D8DADBDBDBDAD9D8D6D4D2CECBC7C2BDB8
B3ADA7A09A938B83
837C76706C696868696C70757B81878D93999FA4A9ADB0B3
B5B6B7B7B6B6B4B3B1B0AFADACABABAAAAAAAAAAABABACAD
AEAEAEAEACA9A39C93897F746B635D5A5A5C5F63676B6D6E
6E6D6B6B6B6D7179828D99A5B0B9C0C4C6C5C3C1BFBDBDBE
C1C4C9CDD2D6DADDE0E2E3E3E4E3E2E0DDDAD6D1CCC6C0BB
B5AFA9A39D979089
8D8984817E7D7C7C7E8083868B8F959AA0A5ABB0B4B8BBBD
BFBFBFBEBDBBB9B7B5B4B2B1AFAEAEADADADADADADADACAC
ABA9A7A4A09B948C82786E645B534E4B4B4D51555A5E6061
61605F5F5F6268717C8997A5B2BDC5CACDCCCBC8C6C4C3C3
C5C9CDD1D5D9DDE0E3E5E7E8E9E8E7E5E2DFDAD5D0CAC4BE
B8B2ADA7A29D9792
99979594939292939496989A9DA0A4A8ADB2B7BBBFC3C5C7
C8C8C7C6C4C2C0BEBCBAB8B7B5B4B3B2B2B2B1B0AFAEACA9
A6A19D97918A82796F665C534B44403E3E4043484C505354
545353535559606A778797A7B5C2CCD2D4D4D2CFCCCAC8C8
CACCD0D4D8DCDFE2E5E7E8E9EAEAE9E7E4E0DCD8D2CDC7C2
BCB7B2ADA8A4A09D
A7A6A6A7A8A9AAABACADADAFB0B2B4B8BBBFC3C6CACDCFD0
D0D0CFCECCCAC8C6C4C2C0BEBDBBBAB9B8B7B6B4B2AFABA6
9F98918880776D645B524A423B3633313234373B3F434547
474747484B505965748597A9BAC8D2D9DCDCD9D6D2CFCDCC
CDD0D3D6DADDE1E3E5E6E7E8E8E8E7E5E3E0DDD9D4D0CBC6
C1BCB8B3AFACAAA8
B4B6B8BBBDC0C1C3C3C3C3C3C3C4C5C6C9CBCED1D3D5D7D8
D8D7D6D5D4D3D1CFCDCBC9C7C5C3C1BFBEBCBAB8B4B0AAA2
998F84796E63594F473F38322D2A282727292B2F3236383A
3B3C3D3F434A5462738599ACBECED9E0E3E3E0DCD8D4D1D0
D0D2D5D8DCDFE1E3E4E5E5E5E5E5E4E2E0DEDCD9D6D2CECA
C6C1BEBAB7B5B4B4
C2C5C9CDD1D4D7D8D9D8D7D6D5D4D4D4D5D6D8DADBDDDEDE
DEDEDDDDDCDBD9D8D6D4D2CFCDCBC8C6C5C2C0BCB8B1A99F
9386786A5D50453B332D2824211F1E1E1F202124272A2C2E
303235393F47536274889CB1C3D3DFE7EAE9E6E2DDD8D5D3
D3D5D7DADDDFE1E2E3E3E3E2E1E0DFDEDDDCDAD8D6D3D1CD
CAC6C3C1BFBDBEBF
CDD2D7DDE2E6E9EAEAEAE8E6E4E2E0DFDFE0E0E1E2E3E3E3
E3E3E3E3E2E2E1DFDEDCDAD7D4D2CFCDCBC8C5C1BCB4AA9E
8F7F6E5D4D3E3229221D1A19181818181819191B1D1F2224
272B30363E495666798DA2B6C8D8E4EBEEEEEBE6E1DCD8D6
D6D7D9DBDDDFE1E1E1E1E0DEDDDCDBDADAD9D8D7D6D5D3D0
CECBC9C7C6C6C7C9
D7DCE2E8EEF2F6F7F7F6F4F1EEECE9E8E7E6E6E6E6E6E7E7
E7E7E7E7E7E7E6E5E4E2DFDDDAD7D5D3D1CECBC7C1B9AD9F
8D7B6753403023191310101012141515151413141416191D
2228303943505E6F8295A9BCCDDCE7EEF0F0EDE9E4DFDBD9
D8D9DADCDEDFE0E0E0DEDDDBDAD9D8D7D7D7D7D7D7D6D5D3
D1D0CECDCCCDCED2
DDE3E9EFF4F9FCFDFDFCFAF7F4F1EEECEBEAE9E9E8E8E8E8
E8E8E9E9E9E9E9E8E7E5E3E0DDDAD8D7D6D4D2CEC8BFB3A3
8F7A634C3825170E0908090C101315151412100F0E101318
202934414E5D6D7E8FA1B3C3D2DEE8EDF0EFEDE9E5E1DDDB
DADBDCDDDEDFE0DFDEDDDBDAD8D7D6D6D6D6D7D7D7D7D7D6
D4D3D2D1D1D2D4D8
E1E6ECF1F6FAFDFEFEFCFAF8F5F2F0EDECEBEAE9E9E8E8E8
E8E8E9E9EAEAEAE9E8E6E3E1DEDCDADAD9D9D8D5D0C7BAA9
937C624A321F10060203060B1115181816130F0C0A0B0F16
212E3D4D5D6F8090A1B0BECBD6DFE6EBEDEDEBE8E5E2DFDD
DCDCDDDDDEDFDFDEDEDCDBD9D8D7D6D6D6D7D7D8D8D8D8D8
D7D6D5D5D5D6D9DC
E2E7EBEFF3F7F9FAFAF9F7F5F2F0EEECEAE9E8E8E7E7E6E6
E6E7E7E8E8E9E9E8E6E5E3E0DEDCDBDBDCDDDDDCD7CFC2B0
997F6449301B0C020001060D141A1E1E1A150F0B08080D16
2435485C708395A6B3BFCAD2DAE0E4E7E8E8E8E6E4E2E0DF
DEDDDDDEDEDEDEDEDDDCDBDAD9D8D8D8D8D8D8D9D9DADAD9
D9D8D8D8D8D9DBDE
E2E5E8EBEEF0F2F2F2F1F0EFEDEBE9E8E7E6E6E5E4E4E4E4
E4E4E5E5E6E6E6E5E4E3E1DEDCDBDBDDDFE1E2E2DED7CAB7
9F84684B311B0B02000309121B2225252019120B07070C18
283D546C8399ACBBC7CFD5DADDDFE0E1E2E3E3E3E2E1E1E0
DFDEDEDEDEDEDDDDDDDCDCDBDADADAD9D9DADADADBDBDBDB
DADADADADBDBDDDF
E0E2E4E5E7E8E9E9E9E9E8E7E6E5E4E3E3E2E2E1E1E1E1E1
E1E1E1E2E3E3E3E2E1E0DEDCDBDADBDDE0E3E6E6E4DDD0BD
A5896C4E331D0C0403070F19222A2E2D271E150D08080D1A
2E46617C97AFC2D0DADFE0E0DFDEDCDCDCDDDFE0E0E1E1E0
E0DFDEDDDDDDDDDDDDDCDCDCDCDCDCDBDBDBDCDCDCDCDCDC
DCDCDCDCDCDDDEDF
DEDFDFDFDFDFDFDFDFDFDFDFDFDFDEDEDEDEDEDEDEDDDDDD
DDDEDEDEDFDFDFDFDEDDDCDBDADADBDEE1E5E8E9E7E0D4C1
A98D6F5237201008080D16212B3337352E2419100A090F1E
334E6C8AA7C1D5E2E9EBEAE6E1DDD9D7D7D8DADCDEDFE0E0
E0DFDEDDDDDCDCDCDCDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
DDDDDDDEDEDEDEDE
DCDBDAD9D8D7D7D7D7D7D7D8D8D9D9DADADADADADADADADA
DADADADBDBDCDCDCDCDBDADAD9DADBDEE2E5E8E9E7E0D4C1
AA8F72553B25160F0F151E2A353D403D352A1E130C0A1120
38547495B3CEE2EFF5F5F0EAE3DCD6D3D3D4D7D9DCDEDFE0
DFDFDEDDDCDCDCDCDCDDDDDEDEDEDFDFDFDEDEDEDEDEDEDE
DEDEDFDFDFDEDEDD
DBD9D7D5D3D1D0D0D0D0D1D2D3D4D5D6D7D7D8D8D8D8D8D8
D8D8D8D8D8D8D9D9DADADADADADBDDDFE2E5E6E6E2DBCFBD
A78D72573F2B1D17181E28333E4548443B2F22160E0C1222
3A577899B8D4E8F5FAF9F3ECE4DBD5D2D1D2D5D8DADDDEDF
DFDEDDDCDCDCDCDCDDDDDEDEDFDFDFDFDFDFDFDFDFDFDFDF
DFDFDFDFDFDFDEDC
DAD7D5D3D0CFCDCDCDCDCECFD1D2D3D4D5D6D7D7D8D8D8D7
D7D6D6D5D5D6D6D7D9DADBDCDDDEE0E1E2E2E1DFDAD1C5B4
9F887058433126212329323C464C4E493F332519100D1322
39567697B6D1E5F2F8F7F2EBE4DCD6D2D2D3D5D7DADCDDDE
DEDDDCDCDCDCDCDCDDDDDEDFDFDFE0E0E0DFDFDFDFDFDFDF
DFDFE0E0DFDFDDDC
DAD7D5D3D0CFCDCDCDCDCECFD0D1D3D4D5D6D7D8D8D9D8D8
D7D6D5D4D3D4D5D6D9DBDEE0E2E3E3E3E1DEDAD5CDC3B6A6
94806C5846382F2C2E343C454D52534D4336281B120E1320
36516F8EACC6DBE8EFF0EDE9E3DDD8D5D4D5D7D8DADBDCDC
DCDCDBDBDBDCDCDDDDDEDEDFDFDFDFDFDFDFDFDFDFDFDFDF
DFDFE0E0DFDFDDDC
DAD8D6D4D2D1D0CFCFD0D0D1D2D3D4D5D6D7D8D9DADADAD9
D8D6D4D3D2D2D3D6D9DDE1E5E7E8E8E5E0DAD2C8BEB2A495
85756656493F39373A3F464D5357564F45382A1D1410131E
314964819CB5CAD8E1E5E6E4E2DEDCDAD9D9DADADADADADA
DADADADBDBDCDDDDDEDEDEDEDEDEDEDEDEDEDEDEDEDFDFDF
DFDFDFDFDFDEDDDC
DBDAD8D7D6D5D4D3D3D3D4D4D4D5D6D7D8D9DADCDCDDDCDB
D9D7D4D2D1D1D3D6DBE0E5EAEDEEECE7DFD4C8BAAD9E9082
756A5F554C464343464A4F55595A585146392B1F1611121B
2B3F577189A1B5C5D0D7DCDFE0E0E0E0DFDFDEDDDCDAD9D9
D8D9D9DADCDDDEDEDEDEDEDEDEDDDDDDDDDDDDDEDEDEDEDF
DFDFDFDFDFDEDDDC
DCDBDBDAD9D9D8D8D8D7D7D7D7D8D8D9DADBDDDEDFDFDFDD
DBD8D5D2D0D0D2D6DCE3E9EFF3F3F0E8DDCEBDAC9B8A7B6F
655D5753504E4E505256595C5E5D5951463A2D2118121219
2535495F758B9EAFBDC8D1D8DEE2E5E6E6E5E3E0DDDAD8D7
D7D7D8DADCDDDFDFDFDFDEDEDDDCDCDCDCDCDDDDDDDEDEDE
DEDEDEDEDEDEDDDD
DDDDDDDDDDDDDDDCDCDCDBDBDADADBDBDCDEDFE0E2E2E1DF
DCD9D5D2D0CFD1D6DDE5EDF3F8F8F4E9DAC8B39E8977675C
565251515356595C5E616263625F5A51473B2F231A141317
202C3C4E61748799AAB9C6D2DCE4E9ECECEAE7E3DEDAD7D5
D5D6D7DADCDEE0E0E0E0DFDEDDDCDBDBDBDCDCDCDDDDDDDD
DEDDDDDDDDDDDDDD
DEDEDFE0E0E0E1E0E0DFDFDEDDDDDDDDDEE0E1E3E4E4E3E1
DEDAD6D2CFCFD1D6DEE7F0F7FCFCF6EAD8C1A9907965554C
48484C51575D63676A6B6A6966615A51473C31261E181517
1C25313F4F60738598AABCCCDAE5EDF1F2F0EBE6E0DAD6D3
D3D4D7D9DCDFE0E1E1E0DFDEDCDBDBDADBDBDBDCDCDDDDDD
DDDDDDDCDCDCDDDD
DEDFE0E1E2E3E3E3E3E2E1E0DFDEDEDFE0E1E2E4E6E6E5E3
DFDBD6D2CFCED1D6DFE8F2FAFEFEF7E9D4BCA0856B56463E
3D4148525C656D727474726E69625A51473D332A221C1918
1B212934415062758A9EB3C7D8E6F0F6F6F4EEE8E0DAD5D2
D2D3D6D9DCDFE1E2E2E1DFDEDCDBDADADADBDBDCDCDCDDDD
DCDCDCDCDCDCDCDD
DEDFE1E2E3E4E5E5E4E3E2E1E0DFDFDFE0E1E3E5E6E7E6E3
E0DBD7D2CFCED1D6DFE9F3FBFFFFF7E8D1B6997C614B3B34
353C4754616D767C7E7C78726B635A51483F372F28231F1D
1D20262D3845566A7F96ADC3D7E7F2F9F9F7F1E9E1D9D4D1
D0D2D5D9DCE0E2E3E2E1E0DEDCDBDADADADADBDCDCDCDCDC
DCDCDCDBDBDCDCDD
DEDFE0E2E3E4E4E4E4E3E2E1E0DFDFDFE0E1E3E5E6E7E6E4
E0DCD7D2CFCED1D6DFE9F3FBFFFEF6E5CEB294755A43352F
313A475766747E8485837D766D645B524A423B352F2A2624
2323262C344050637991A9C0D6E7F4FAFBF8F2E9E1D9D3D0
D0D2D5D9DCE0E2E3E3E2E0DEDCDBDADADADADBDCDCDCDCDC
DCDCDCDBDBDBDCDD
DDDFE0E1E2E3E3E3E3E2E1E0DFDEDEDEDFE1E2E4E6E6E5E3
E0DBD7D3CFCED1D6DFE8F2F9FDFCF3E2CBAE90715640312D
313B4A5B6B7A858B8B8881786F655B534B45403B36322F2C
2A292A2E353F4E61778EA7BFD5E7F4FBFCF8F2E9E1D8D2CF
CFD1D5D8DCE0E2E3E3E2E0DEDDDBDADADADADBDCDCDCDDDD
DCDCDCDBDBDBDCDC
DDDEDFDFE0E1E1E1E1E0DFDEDEDDDDDEDEE0E1E3E4E5E4E2
DFDBD7D3D0CFD1D7DEE7F0F7FBF9F0DFC7AB8D6F543F312D
323E4D5F707F8B90908B847A70665C544D4844413D3A3734
3230313339424F61778EA7BFD5E7F3FAFBF8F1E9E0D8D2CF
CFD1D4D8DCE0E2E3E3E2E0DEDDDBDADADADBDBDCDCDDDDDD
DDDCDCDCDBDCDCDC
DDDDDEDEDFDFDFDFDFDEDEDDDCDCDCDDDEDFE0E2E3E4E3E1
DEDBD7D3D0D0D2D7DEE6EEF5F8F6EDDCC5A98C6F55403430
3641516375848F94938E867C71665D55504C494644423F3D
3A3838393E4653647990A8BFD4E6F3F9FAF7F0E8DFD7D2CF
CFD1D4D8DCE0E2E3E3E2E0DEDDDBDBDADADBDCDCDDDDDDDD
DDDDDCDCDCDCDCDC
DCDCDDDDDDDDDDDDDDDDDCDCDBDBDBDCDDDEDFE1E2E3E2E0
DEDBD7D4D1D1D2D7DEE5EDF2F5F2E9D9C2A88C7057443835
3A46566778869195948F867C72675E57524F4D4B4A484644
413F3F40444C58687C92A9C0D5E6F2F8F9F6EFE7DFD7D2CF
CFD1D4D8DCE0E2E3E3E2E0DEDDDCDBDADBDBDCDCDDDDDDDD
DDDDDDDCDCDCDCDC
DCDCDCDCDCDCDCDCDCDBDBDBDBDBDBDBDCDDDEE0E1E1E1E0
DDDBD8D5D2D2D3D8DEE4EBF0F2EFE6D6C1A88D735C493E3B
404B596A79879095938E867C726860595552504F4E4D4B49
474545474B525E6E8196ACC1D5E5F1F7F7F4EEE6DED7D2CF
CFD1D5D8DCDFE2E3E3E1E0DEDDDCDBDBDBDBDCDDDDDDDEDE
DEDDDDDDDDDCDCDC
DCDCDCDBDBDBDBDBDBDADADADADADADBDCDDDEDFE0E0E0DF
DDDBD8D5D3D3D4D8DEE3E9EDEEECE3D4C0A9907761504542
464F5C6B79858E91908C847C736A625C575452514F4E4D4B
4A49494C50586473859AAFC3D5E5F0F5F6F3EDE6DED7D2D0
D0D2D5D9DCDFE2E3E2E1E0DEDDDCDBDBDBDBDCDDDDDEDEDE
DEDEDDDDDDDDDCDC
DCDCDCDBDBDBDBDADADADADADADADADBDBDCDDDEDFE0DFDE
DDDBD9D6D5D4D6D9DEE3E7EBECE9E0D3C0AA937D68584D4A
4C545E6A7681888C8C88827B736C655E5A5653504E4D4B4A
494A4B4F555D69788A9EB1C5D6E5EFF4F4F2ECE5DED7D2D0
D0D2D5D9DCDFE1E2E2E1E0DEDDDCDBDBDBDCDCDDDDDEDEDE
DEDEDEDDDDDDDDDC
DCDCDCDCDBDBDBDADADADADADADADADBDBDCDDDEDFDFDFDE
DDDBD9D7D6D5D7DADEE2E6E9E9E6DED2C1AD988370615652
52585F69727B818585837F7A746E68625C57534F4B494746
46484B5058626E7E8FA1B4C6D7E4EEF3F3F0EBE5DED8D3D1
D1D3D6D9DCDFE1E2E2E1E0DEDDDCDBDBDBDCDCDDDDDEDEDE
DEDEDEDEDDDDDDDD
DDDCDCDCDCDBDBDBDBDBDBDADADADADBDBDCDDDEDEDFDFDE
DDDBDAD8D7D7D8DADEE1E5E7E7E4DDD1C2B09D8A796A605A
595B60676D74797D7E7E7C7A76726C665F59524D47434140
42454A515A65738394A6B7C8D8E4EDF1F2EFEBE4DED8D4D2
D2D3D6D9DCDFE1E2E2E1E0DEDDDCDBDBDBDCDCDDDDDEDEDE
DEDEDEDEDDDDDDDD
DDDDDDDDDCDCDCDCDCDBDBDBDBDBDBDBDBDCDDDDDEDEDEDE
DDDCDAD9D8D8D9DBDEE1E4E6E5E2DCD2C4B4A39282756A63
605F6165686D717577797A797875716B635B524A433E3B3A
3D4249525D6A788899AABBCAD8E4ECF0F1EEEAE4DED9D5D3
D2D4D6D9DCDFE1E2E2E1E0DEDDDCDCDBDBDCDCDDDDDDDEDE
DEDEDEDEDDDDDDDD
DDDDDDDDDDDDDDDCDCDCDCDBDBDBDBDBDBDCDCDDDEDEDEDE
DDDCDBDAD9D9D9DBDEE1E3E4E4E1DBD2C6B9AA9B8C7F756D
6764636364676A6D7175787A7B7A7670675D53483F393535
383F4853606F7E8E9FAFBECDD9E4EBEFEFEDE9E4DED9D5D4
D3D5D7DADCDFE1E1E1E1E0DEDDDCDCDCDCDCDCDDDDDDDEDE
DEDEDEDDDDDDDDDD
DDDEDEDDDDDDDDDDDDDCDCDCDBDBDBDBDBDCDCDDDEDEDEDE
DDDCDBDAD9D9DADCDEE0E2E3E2E0DBD3C9BDB0A3968A8077
6F6A6663626264686D72777C7F7F7D766C6154483E363131
363E4A5765758595A5B4C2CFDAE3EAEDEDECE8E3DFDAD6D5
D4D6D8DADCDFE0E1E1E0DFDEDDDDDCDCDCDCDCDDDDDDDDDD
DDDDDDDDDDDDDDDD
DEDEDEDEDEDEDEDDDDDDDCDCDCDBDBDBDCDCDCDDDEDEDEDE
DDDCDBDBDADADBDCDEE0E1E2E1DFDBD4CCC2B7ABA0958A81
78716B66636163666C72797F8486847D7366584A3E353131
37414D5C6C7D8D9DACBAC6D1DBE3E8EBEBEAE7E3DFDAD7D6
D5D6D8DADDDFE0E1E1E0DFDEDDDDDCDCDCDCDCDDDDDDDDDD
DDDDDDDDDDDDDDDD
DDDEDEDEDEDEDEDEDDDDDDDCDCDCDCDCDCDCDDDDDEDEDEDE
DDDCDCDBDADADBDCDEDFE1E1E1DFDBD6CEC6BDB3A99F958B
827A726C676565696E767D858A8D8B857A6C5E4F43393536
3C475464758696A6B3BFCAD4DCE2E7E9E9E8E6E2DEDBD8D7
D7D7D9DBDDDEE0E0E0E0DFDEDDDDDCDCDCDCDCDDDDDDDDDD
DDDDDDDDDDDDDDDD
DDDDDDDEDEDEDEDEDDDDDDDDDCDCDCDCDCDDDDDDDEDEDEDE
DDDCDCDBDBDBDBDCDEDFE0E1E0DFDCD7D1CAC2BAB1A89F95
8C847C75706D6D70767D858C9295938D827566584B423E3F
46515F6F8091A1AFBBC5CED6DDE1E5E6E7E6E4E1DEDBD9D8
D8D8D9DBDCDEDFE0E0DFDFDEDDDDDCDCDCDCDCDDDDDDDDDD
DDDDDDDDDDDDDDDD
DDDDDDDDDDDDDEDEDDDDDDDDDDDDDDDDDDDDDDDEDEDEDEDE
DDDDDCDBDBDBDBDCDEDFE0E1E1DFDDD9D4CEC7BFB8B0A79F
978F88817C79797C81888F969B9D9C958B7F716358504C4E
54606D7D8D9DABB8C3CBD2D8DDE1E3E4E4E4E2E0DEDCDAD9
D9D9DADBDCDEDEDFDFDFDEDDDDDCDCDCDCDCDCDDDDDDDDDD
DDDDDDDDDCDCDCDD
DCDCDDDDDDDDDDDDDDDDDDDDDDDDDDDDDEDEDEDEDFDFDEDE
DDDDDCDBDBDBDBDCDEDFE0E1E1E0DEDBD6D1CBC4BEB7B0A8
A19B958F8B89898B8F959BA0A4A6A49E958A7D7167605D5F
66717E8C9BAAB7C1CAD1D6DADDDFE1E2E2E1E1DFDDDCDBDA
DADADBDBDCDDDEDEDEDEDDDDDCDCDCDCDCDCDCDCDDDDDDDD
DDDDDCDCDCDCDCDC
DCDCDCDCDDDDDDDDDEDEDEDEDEDEDEDEDEDFDFDFDFDFDFDE
DDDDDCDBDBDBDBDCDEDFE0E1E2E1E0DDD9D4CEC9C3BDB7B1
ACA7A29F9C9A9A9C9FA3A8ACAEAFADA79F958B8078727073
79838F9CAAB6C1CAD1D6D9DCDDDEDFDFDFDFDFDEDDDCDBDB
DBDBDBDCDCDDDDDDDDDDDDDCDCDCDCDCDCDCDCDCDDDDDDDD
DCDCDCDCDCDCDCDC
DBDBDCDCDCDDDDDDDEDEDEDEDFDFDFDFDFDFDFE0E0DFDFDE
DEDDDCDBDBDBDBDCDEDFE1E2E2E2E1DEDBD6D1CCC7C2BDB9
B5B3B0AEADACADAEB0B2B5B7B8B8B5B0A9A198908A858487
8D96A1ACB7C2CBD2D7DADCDDDDDDDDDDDDDDDDDDDDDCDCDB
DBDBDBDCDCDCDCDDDCDCDCDCDCDBDBDBDBDCDCDCDCDCDCDC
DCDCDCDCDBDBDBDB
DBDBDBDCDCDDDDDEDEDEDFDFDFDFE0E0E0E0E0E0E0E0DFDF
DEDDDCDBDBDADBDCDDDFE1E2E3E3E2E0DCD8D4CFCAC6C3C0
BEBDBDBDBDBDBEBFC0C1C1C2C1C0BDB8B2ACA59F9B98989B
A0A8B1BBC4CDD4D9DCDEDEDEDDDDDCDBDBDCDCDCDCDCDCDC
DCDCDCDCDCDCDCDCDCDCDCDBDBDBDBDBDBDCDCDCDCDCDCDC
DCDCDCDBDBDBDBDB
DBDBDCDCDCDDDDDEDEDEDFDFDFE0E0E0E0E0E0E0E0E0DFDF
DEDDDCDBDBDADBDCDDDFE1E2E4E4E3E1DEDAD5D1CDCAC7C6
C6C7C8CACBCCCDCECECDCCCBC9C7C4BFBBB6B2AEABA9AAAD
B2B8C0C8CFD6DBDFE0E1E0DFDDDCDBDADADADBDBDCDCDDDD
DDDCDCDCDCDCDCDBDBDBDBDBDBDBDBDBDBDCDCDCDCDCDCDC
DCDCDBDBDBDBDBDB
DBDBDCDCDCDDDDDEDEDEDFDFDFDFDFE0E0E0E0E0E0E0DFDE
DEDDDCDBDADADBDCDDDFE1E2E3E4E3E1DEDBD7D3D0CDCCCB
CDCFD1D4D6D8D9D9D9D7D5D2D0CDC9C6C2BFBCBAB9B8BABD
C1C6CCD2D8DDE0E2E3E3E1DFDDDBDAD9D9DADADBDCDDDDDD
DDDDDCDCDCDCDBDBDBDBDBDBDBDBDBDBDCDCDCDCDCDCDCDC
DCDCDCDBDBDBDBDB
DCDCDCDDDDDDDDDDDEDEDEDEDEDEDEDEDEDFDFDFDFDFDEDE
DDDCDCDBDADADBDBDDDEE0E2E3E3E3E1DFDBD8D5D2D0CFD0
D2D4D7DBDDE0E1E1DFDDDBD8D4D1CECBC9C7C5C4C4C4C6C8
CCD0D5D9DEE1E4E5E4E3E2DFDDDBDAD9D9D9DADBDCDDDEDE
DEDDDDDDDCDCDCDBDBDCDCDCDCDCDCDCDCDCDCDCDCDCDCDC
DCDCDCDCDCDCDCDC
DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
DCDCDBDBDADADBDBDCDEDFE1E2E2E2E0DEDCD9D6D4D3D2D3
D5D8DBDEE1E3E4E4E2E0DDDAD7D4D2CFCECDCCCCCCCDCED1
D4D7DADEE1E3E5E5E5E3E2DFDDDBDAD9D9DADBDCDDDDDEDE
DEDEDDDDDDDCDCDCDCDCDCDDDDDDDDDDDDDDDDDDDDDDDDDD
DDDDDDDDDDDDDDDD
DEDEDEDEDEDDDDDDDCDCDCDBDBDBDBDBDBDBDBDCDCDCDCDC
DCDBDBDBDADADBDBDCDDDEDFE0E0E0DFDEDCDAD8D6D5D5D6
D8DADDE0E2E3E4E4E3E1DEDBD9D6D4D3D2D1D1D1D2D3D4D6
D9DBDEE0E2E4E5E5E4E3E1DFDDDCDBDADADBDBDCDDDEDFDF
DFDEDEDEDDDDDDDDDDDDDDDEDEDEDEDEDEDEDDDDDDDDDDDD
DDDDDDDEDEDEDEDE
DFDFDFDEDEDDDDDCDBDBDADAD9D9D9D9D9D9D9DADADBDBDB
DBDBDBDBDBDBDBDBDCDDDDDEDFDFDFDEDDDCDAD9D8D8D8D8
DADBDDDFE1E2E2E2E1DFDDDBD9D8D6D5D5D4D5D5D6D7D8DA
DBDDDFE1E2E3E4E4E3E2E1DFDEDCDCDBDBDCDCDDDEDFDFDF
DFDFDFDEDEDEDEDEDEDEDEDFDFDFDFDFDFDFDEDEDEDEDEDE
DEDEDEDFDFDFDFDF
E0E0DFDEDEDDDCDBDADAD9D8D7D7D7D7D7D7D8D8D9DADADA
DBDBDBDBDBDBDBDCDCDCDDDDDDDDDDDDDCDCDBDADADADADA
DBDCDDDEDEDFDFDFDEDDDCDAD9D8D8D7D7D7D8D8D9DADBDC
DDDEDFE0E1E2E2E2E1E1E0DFDEDDDDDDDDDDDEDEDFDFE0E0
E0E0DFDFDFDFDFDFDFDFE0E0E0E0E0E0E0E0DFDFDFDEDEDE
DFDFE0E0E0E1E1E0
E1E0DFDEDEDCDBDAD9D8D8D7D6D6D5D5D6D6D7D7D8D9D9DA
DBDBDBDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCDC
DCDCDCDCDCDCDBDBDBDADAD9D9D9D9D9D9D9DADADBDCDCDD
DEDEDFDFE0E0E0E0E0DFDFDFDEDEDEDEDEDEDFDFE0E0E0E0
E0E0E0E0E0DFDFE0E0E0E1E1E1E1E1E1E1E1E0E0DFDFDFDF
E0E0E0E1E1E1E1E1
E1E0DFDEDDDCDBDAD9D8D7D6D6D5D5D5D6D6D7D7D8D9D9DA
DBDBDCDCDDDDDDDDDDDCDCDCDBDBDBDBDBDCDCDDDDDDDDDD
DCDCDBDAD9D9D8D8D8D8D8D8D8D9D9DADADBDBDCDCDCDDDD
DDDEDEDEDEDEDEDEDEDEDEDEDEDEDFDFDFDFDFE0E0E0E0E0
E0E0E0E0E0E0E0E0E0E1E1E1E2E2E2E2E1E1E0E0E0DFDFE0
E0E0E1E1E2E2E2E1
E0DFDEDDDDDCDBDAD9D8D8D7D7D7D7D7D7D7D8D8D9D9DADB
DBDCDCDDDDDDDDDDDDDCDCDBDBDBDBDBDBDCDDDDDEDEDEDE
DDDBDAD9D7D6D6D5D5D6D6D7D8D9DADADBDBDCDCDDDDDDDD
DDDDDDDCDCDCDCDCDCDDDDDEDEDFDFDFDFE0E0E0E0E0E0E0
E0E0E0E0E0E0E0E0E0E0E1E1E1E1E1E1E1E1E0E0E0DFDFDF
E0E0E0E1E1E1E1E1
DEDEDDDCDCDBDBDADADAD9D9D9D9DADADADADADADBDBDCDC
DCDDDDDEDEDEDEDEDDDDDCDCDBDBDBDBDCDDDDDEDFDFDFDE
DDDBDAD8D7D5D5D4D4D5D6D7D8D9DADBDBDCDCDDDDDDDDDD
DCDCDCDBDBDBDBDBDBDCDCDDDEDEDFDFDFDFDFDFDFDEDEDE
DEDEDEDFDFDFDFDFDFDFDFDFE0E0E0E0DFDFDFDFDFDFDFDF
DFDFDFDFDFDFDFDF
DCDBDBDBDADADADBDBDBDCDCDDDDDEDEDEDEDEDEDEDDDDDE
DEDEDEDEDFDFDFDEDEDDDDDCDCDCDCDCDDDDDEDFDFE0DFDF
DDDCDAD9D7D6D5D5D5D5D6D7D8D9DADBDBDCDCDDDDDDDDDC
DCDBDBDADADADADADADBDBDCDDDEDEDEDEDEDEDDDDDDDDDC
DCDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD
DDDDDDDDDDDDDCDC
D8D8D8D8D8D9DADADCDDDEDFE0E1E2E2E2E2E2E1E1E0E0DF
DFDFDFDFDFDFDFDEDEDEDDDDDDDDDDDDDDDEDFDFE0E0DFDF
DEDCDBD9D8D7D6D6D6D6D7D8D8D9DADBDBDCDCDCDCDCDCDC
DCDBDADAD9D9D9D9D9DADBDBDCDDDDDDDDDDDCDCDBDBDADA
DADBDBDBDBDBDCDBDBDBDBDBDADADADADBDBDBDCDCDCDCDC
DCDBDBDADAD9D9D9
D4D4D4D5D6D7D8DADBDEE0E2E4E5E6E7E7E6E5E4E3E2E1E0
E0DFDFDFDFDFDEDEDEDEDEDDDDDDDEDEDEDFDFDFE0E0DFDF
DEDDDCDAD9D9D8D8D7D8D8D8D9D9DADADBDBDBDCDCDCDCDB
DBDADAD9D9D8D8D8D9D9DADADBDBDCDCDBDBDADAD9D9D8D8
D8D8D9D9D9DADAD9D9D9D8D8D7D7D7D7D8D8D9DADADADADA
DAD9D8D7D6D5D5D4
CFCFD0D0D1D3D5D7DADDE0E3E5E8E9EAEAE9E8E7E5E4E2E1
E0DFDFDEDEDEDEDDDDDDDDDEDEDEDEDFDFDFDFDFDFDFDEDE
DDDDDCDBDADAD9D9D9D8D8D9D9D9D9D9DADADADADBDBDBDA
DADAD9D9D8D8D8D8D8D8D9D9DADADADAD9D9D8D8D7D6D6D6
D6D6D7D7D8D8D8D7D7D6D5D5D4D4D4D4D5D6D7D8D8D9D9D8
D7D6D5D4D2D1D0D0
CACACACBCCCDD0D3D6DADEE2E5E8EAEBEBEBE9E8E6E4E2E1
E0DFDEDDDDDCDCDCDCDDDDDDDEDEDFDFDFDFDFDFDEDEDEDD
DDDCDCDBDBDBDADADAD9D9D9D9D9D9D9D9D9D9D9D9DADAD9
D9D9D8D8D8D8D7D7D8D8D8D9D9D9D9D9D8D7D7D6D5D5D4D4
D5D5D5D6D6D7D6D6D5D4D4D3D2D1D1D2D3D4D5D6D7D8D8D7
D6D4D2D1CFCDCCCB
C5C4C4C4C4C6C8CBD0D4D9DEE2E6E8EAEAEAE9E7E5E3E1DF
DEDDDCDCDBDBDBDBDCDCDDDDDEDFDFDFDFDFDFDEDEDDDDDC
DCDCDCDCDCDCDBDBDBDADAD9D9D9D9D8D8D8D9D9D9D9D9D9
D9D9D8D8D8D8D8D8D8D8D8D8D8D8D8D8D7D7D6D5D5D4D4D4
D4D5D5D6D6D6D6D6D5D4D3D2D1D0D1D1D2D4D5D6D7D8D8D7
D5D3D1CFCCCAC8C6
C0BEBCBBBBBCBEC1C5CAD0D5DBDFE3E5E6E6E5E4E2E0DFDD
DCDBDADADAD9DADADBDBDCDDDEDFE0E0E0DFDEDEDDDCDCDC
DCDCDCDCDDDDDDDDDCDCDBDBDADAD9D9D9D9D9D9D9D9DADA
DAD9D9D9D9D9D9D9D9D9D9D9D9D9D8D8D8D7D6D6D6D5D5D5
D6D6D7D7D8D8D8D7D6D5D4D3D2D1D2D2D4D5D7D8D9DADAD9
D7D4D2CFCBC8C5C2
BBB7B4B1AFAFB0B3B7BDC3C9CFD5D9DCDEDFDEDEDDDBDAD9
D9D8D8D8D8D8D8D9DADBDCDDDEDFE0E0E0DFDEDDDCDCDBDB
DBDCDCDDDDDEDEDEDEDDDDDCDCDBDBDBDBDBDBDBDBDBDBDB
DBDBDBDBDBDBDBDBDBDBDADADADAD9D9D9D9D8D8D8D8D8D8
D9D9DADADBDBDBDAD9D8D7D6D5D5D5D6D7D9DBDCDEDEDEDC
DAD7D4D0CCC8C3BF
B6B0AAA6A2A0A0A2A6ACB2B9C0C6CCD0D3D4D5D5D5D5D4D4
D4D4D5D5D5D6D6D7D9DADBDDDEDFE0E0DFDFDEDDDCDBDADA
DBDBDCDDDEDFDFDFDFDFDFDEDEDDDDDDDDDDDDDDDEDEDEDE
DEDEDEDEDEDEDDDDDDDDDCDCDCDBDBDBDBDBDBDBDCDCDCDD
DDDEDEDFDFDFDFDEDDDCDBDADAD9DADBDDDEE0E2E3E3E3E1
DFDCD7D3CEC8C2BC
B1A8A09993908E8F93989FA6AEB5BCC1C5C7C9CACBCCCDCD
CECFD0D1D2D3D4D5D7D8DADCDDDEDFDFDEDEDDDBDADAD9D9
DADBDCDDDEDFDFE0E0E0E0DFDFDFDFDFDFDFE0E0E0E0E0E0
E0E0E0E0E0E0E0DFDFDEDEDDDDDDDDDDDDDEDEDFE0E0E1E1
E2E2E3E3E3E3E3E3E2E1E0DFDFDFDFE1E3E5E6E8E9E9E9E7
E4E0DBD6D0C9C2B9
ABA0968C847E7B7B7E838A929AA2A9B0B4B8BBBEC0C2C3C5
C7C9CBCCCDCFD0D2D4D6D7D9DBDCDCDCDCDBDAD9D8D8D7D7
D8D9DADBDCDEDEDFE0E0E0E0E0E0E0E1E1E1E2E2E2E2E2E2
E3E2E2E2E2E2E1E1E0E0DFDEDEDEDEDFDFE0E1E2E3E4E5E6
E6E7E7E7E7E7E7E6E6E5E4E4E4E4E5E6E8EAECEEEEEEEEEC
E8E4DFD9D2CAC0B6
A5988B7F756D6867696E747D858E969DA3A8ACAFB3B6B8BB
BEC1C3C6C8CACBCDCFD1D3D5D7D8D8D9D8D8D7D6D5D5D4D5
D5D6D7D9DADBDCDDDEDEDFDFE0E0E0E1E1E2E2E3E3E3E3E4
E3E3E3E3E3E2E2E1E0E0DFDEDEDEDEDFE0E1E3E4E6E7E8E9
E9E9E9EAE9E9E9E8E8E8E7E7E8E8E9EBEDEFF1F2F3F2F1EF
EBE7E1DBD3C9BFB2
9E8F8072665C565355596068717B838B92979CA0A4A8ACB0
B3B7BABDC0C2C4C7C9CBCDCFD0D1D2D3D2D2D2D1D0D0D0D0
D1D2D3D4D5D7D8D9DADBDBDCDDDDDEDFE0E0E1E2E2E2E2E2
E2E2E2E1E1E0E0DFDEDDDDDCDCDCDDDEDFE1E2E4E6E7E9E9
EAEAEAE9E9E9E9E8E8E8E8E9E9EAECEDEFF1F2F3F4F3F2EF
ECE7E1DAD1C7BBAD
96857565574C454142464D555F68717980868B9095999EA2
A6AAAEB2B5B8BABDBFC1C3C5C7C8C9CACACACACAC9C9C9CA
CACBCCCDCECFD0D1D2D3D4D5D6D7D9DADBDCDCDDDEDEDEDE
DEDDDDDCDCDBDADAD9D8D8D8D8D8D9DADCDDDFE1E3E5E6E7
E7E7E6E6E6E5E5E5E5E5E6E6E7E9EAECEDEFF0F1F1F0EEEB
E8E3DDD5CDC2B5A6
8C7B69584A3E363233363D454E58616970767B8084898D92
969B9FA3A7AAADAFB2B4B6B8B9BBBCBDBEBEBFBFC0C0C0C0
C0C1C1C1C2C3C3C5C6C7C8CACBCDCFD0D1D3D4D5D5D6D6D6
D5D5D4D3D2D1D1D0D0CFCFD0D0D1D2D3D5D7D9DBDDDEDFE0
E0DFDFDEDEDDDDDDDEDEDFE0E1E3E4E5E7E8E9E8E8E6E4E2
DEDAD4CDC4B9AC9D
806F5D4D3E322A26262A3039424B545B61666B6F73777B7F
84898D9195989B9EA1A3A5A6A8AAABADAEB0B1B2B3B4B4B4
B4B3B3B2B2B2B3B3B5B6B8BABCBEC0C2C3C5C6C7C8C9C9C9
C8C7C6C5C4C3C2C2C2C2C3C4C5C6C7C9CBCDCED0D1D3D3D4
D4D3D3D2D1D1D1D1D2D2D4D5D6D7D9DADBDBDBDAD9D7D5D2
CFCAC5BFB6ACA091
736352423428201D1E21282F3841494F54585C5F6165686C
7074797D8184878A8C8E90929496989A9C9EA1A3A4A5A5A5
A4A3A2A09F9E9E9FA0A1A4A6A8ABADAFB2B3B5B6B8B8B8B8
B7B6B4B3B2B1B0B0B1B2B3B5B7B8BABCBEBFC1C2C3C3C4C4
C3C3C2C2C1C1C1C1C2C3C4C5C7C8C9CACAC9C8C7C5C2C0BD
BAB6B2ACA59C9183
665647382B211A17181C222931394045494C4D4F50525457
5B5F63676B6F727577797B7C7E808386898C8F9294969695
94928F8D8A898888898B8D909396999B9EA0A2A3A5A5A5A5
A4A2A09F9D9C9C9C9D9FA2A4A7A9ABADAFB0B0B1B1B1B1B1
B0B0AFAEAEADADAEAFB0B2B3B5B6B6B6B6B4B2B0ADAAA8A5
A3A09C98928A8074
584B3D30251B151315191F262D343A3E4040404040404143
464A4E5256595D5F61636566686A6D7175797D8184868786
83807D7976737171727476797C808386898B8E8F91929291
8F8E8C8A88878687898C8F9296999B9D9E9F9F9F9F9E9D9D
9C9B9A99989898999A9C9D9FA1A2A2A1A09E9B9894918E8C
898785827E776F65
4C41352A2018131213181D242B31353738373533312F2F30
32363A3E4245494B4D4F50515356595D62676C7175777877
74706B66625E5C5B5C5E6064676B6F7275787A7C7E7E7E7E
7C7A78757372727376797D8185888B8D8E8E8E8D8C8B8A88
87868584838383848587898B8D8E8E8C8A8784807C787573
71706E6D6A655F56
42382E251C16121214181E24292E3132312E2B2723211F1F
2124282C3134383A3C3D3E3F4144474C51585E63686A6B6A
67625C57514D4A49494B4E5255595D616467696B6D6E6D6C
6B6966646261616265696D7175797C7E7E7E7D7C7B797775
7472706F6E6E6E6F717375787A7B7B7977736F6A66615E5C
5B5B5A5A5855514A
3A322A221C161414161A1F24292D2E2E2B27221D18151212
14171B1F24282B2E2F3031323335393E444B52585D616261
5D58524B45403D3C3C3E4145494D5154575A5C5E5F60605F
5D5B595755545455585C6064686C6E7071706F6E6C6A6865
63605E5C5A5A5A5B5D606366696B6B6A67635E5954504D4B
4A4A4A4B4A494540
352F29221D191717191D2125292B2C2A27211C16100C0909
0B0E13181D2225272929292A2B2D30353C434B51575B5D5C
58534D46403B373636383B3F43474A4E5053545657585857
555351504E4D4D4E5154575B5E61636565656463615F5C59
55524E4B494848494C5054585C5F605F5D59544F4A454240
3F3F404141403E3A
342F2A25201D1B1C1D202326292A2A27231D17110B070505
080C11171D22262829292929292A2D3239404850565A5C5C
59544E48423D3A39393B3E4145494C4F5152545455555555
545251504F4E4E4F50525456585A5B5C5D5D5D5C5B595652
4D48433E3B38383A3E43494F54585B5B5956514C47433F3D
3C3C3D3E3E3D3C39
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Level) show
99.000000 13.000000 moveto
(2) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
59565454575C64707D878C887F756D6D72797F8486878788
8887827C746D676362646A768490959084766D6D737A8083
827E746451423F4D667F8E8A79634F433E3F465363747E7D
7469605F636869645C545259657177746B615C606A747568
54423C48617A8987776452494646494D5156595957545356
5B6166686765615D
574F4946474C556475848C8B83797170747A818588898886
827D756E67615D5B5D616B7C90A1A8A394857E8594A4AFB0
A89A866D54403C4C6986958D74563D3131374351606E7470
64564F53606D75706458525967757B76685950525B64675F
5144414C607482847C6F61554C4542464E575D5F5C585453
5355585C6063635E
5B50474241444D5C6E7F898A837A737173787C808283827D
776F67605B5858595D646F7F91A1A7A295888590A4B8C5C5
BAA992765C4742526F8C9A8E7150352C303A47545F686B64
574A454D5F727C796B5D555965727770615147474F585D5A
524B49515F6D777C7A756E645B524E4F555C6163615E5A56
5250515760676A65
695D534C494A505C6B7983848078726F6F7071737473716D
67605A565556595F666D757D848989857F7A7B8697A7B1B3
AEA3927E6958546179909A8D72533C363C48545D6264635C
5249475061727C7A6E6158595F666861544740424953595A
585554575D63696D707273737372706C6965636365666561
5A55555C67717673
7B70665E5A595B626B747A7C79746F6B6865646261605D5A
5552505154596069737A7C776D625A585B616970767C8287
8B8D8A82776E6C758492968A755E4E4B535D666967635E58
5451535A657077756E645C585756544E46403E424A535B60
6161605D5B5A5B5D616772808F9A9D94826F615F666E7370
68615F66727E8583
8A8178716C69686A6E727574726E69645F5B5754514F4D4B
49484A4F565E697580868170563D2D2E3A4B5759534E4D56
64737F84848282868C8F8E85786B64656C7478756D635C59
5A5E62676C6F71706D676059514B45413F40434950575F67
6D6F6E675E56504E525A6C87A6BFC7B899765E5A66768281
786F6C727E8A9291
8F867E7976747476787A79746D645D575451504F4E4E4D4A
49494C525C66727E888C836B4A2A171B2D43514E3F302A33
48607582888B8B8B8A87827D7975767A8086867F7367605F
646B71747372706E6C69645D554E49484A4F5356595D636D
787F80776A5B4F48474E6285ADD0DCC9A0735552657E9091
877B757985909795
8379727072757B838A8E8B7E6C584943454B52585D61625F
5A56555B646E7983898A806B4F34262C405560594530262E
425A6F7C8182817E7B77747475797E84898C8B847A706A6A
6F757B7D7C7A77736F6B6866656566696C6F6F6B66626471
81909690806E5C4D454554759FC3D1BC9162454862839B9E
91807678828B908C
6D615A5B636E7D8F9FA8A48E6E4C342E37485A6B78818580
766C65666D777F838381796D5F524F5767777C725D473A3E
4D5F6D73726E69666564656A70777E8487898885807B7877
797C80838585827B726A696F7A8792999B99918373666471
889EABA99B87705B4A40455D80A1AD9A734A343E6086A1A4
948072717980827A
56463F4351647C97AFBEB99C714526213049667F93A1A6A0
92817572777E82807B75706F71757C86919A998D78635554
5D676D6A6157504D4F535A626A737A7F8182828282838382
818182878D908E82726664738DA8BDC7C6BEAD967E6A6471
89A4B7BAB09E866C533F39465F788273533528385D85A0A2
927C6C6A70767468
46332A30425A7795AEBEBA9F74492C283954738EA3B2B7B0
A18F807A7D81827C7169676E7B8B99A5ADAFAA9D8B786A66
696D6D6456483E3D424B555F6870777A7A7A797B7E828585
8382838A929894836C5A586D92B8D6E1DDCEB89D836F666F
849CB0B8B4A8947B6047393B48585E55412E2A3B5B7D9395
89776A686E726E5D
462E222739526D8596A19F8E755B4B4A566A7F92A1AAADA7
9B8C817C7D7F7E756A615F6777899AA6ACADA89C8C7B6F6A
6C6F6D6354463E3D444E59636B727678777472727376797B
7D7F838B9498917B5D46415983B0D1DBD3C0A99380726B6D
7784929CA09F96856F594843454B4E4B443F404B5C6D797C
77706D71777B7561
52362628384F626D717272727476787B7F84898D9091908C
867F7A797A7A776F655C595E6977848F969A978E80716764
686C6D665B504A4A515A636B7175787775726D6763616369
7179838C9394896D4B2E263C6694B5BDB19B877C7775716B
656266707D898E897E6F6157514E4E53596064625E5A595C
626A737E878B846F
62432F2F3D4F5B594F454657728EA2A8A3998D827A736E6B
6B6D70737575716A61595454585F68727C82837C70645C5C
636A6F6C655E5A5C636B7276787877757370695E544D4C55
6373818C929081613B1A0E2048759398887262626C76776A
54403842576F828B8B857B6F625856607283887B634B3C3F
4E62788A979C9580
6F4F3A3845555D544132324A7198B3BAB09C877364585151
565E676E727370696158514C4B4D535D6871756F64585255
5F6B7374706B696D757D81807B75706F6F6F695C4C403D47
596E808D938F7E5C340F000E325C787A6953485065787C69
482919223C5C798A91928C7F6F615E6D869CA38F6B462F2F
415B778E9EA6A28E
7757434250626B6555464454718DA0A39887736253484345
4C57636D7376746D63584E4847484E58646E726B5F524D52
606F7A7C78727177828B8E887A6C6363696F6D614F403A43
576C8190979584633914010C2C526C6F5F4C444F657A7E69
4625131B365774878F918C80716462728CA4AB9976513733
40556E8599A6A694
785C4A4C5D7282857F766F6E717474706A625A5149444246
4D57626E787E7D7567594E48494D56616C76786F61524B52
637683847D75737B8995978B76605355626F746B5A4A4249
5A6F82939C9D907148230F1734566F73675750596B7B7E6B
4D2F20283F5C7482878680776C636371879BA39880665046
47505F748B9DA293
785F51566A8399A6AAA79C887057443B3A3E43454647494D
535A63707C86877D6D5C4F4B4F56616D7981817665544C54
677C8A8A8075717A8B9A9C8C7155464A5C707B7666564E53
61728494A0A49A7F5A3623294261787D74686166727D7D6E
5741363D4F65767E7D78716A6562646F7D8B93928A7E6F60
544C50617A919B91
786258627994ADBDC4C1B1916941241A1F2D3C464C515558
5B5E65717F8B8E84725F524F555F6C79848B8A7E6B595058
6C828F8D81736D7789999D8C6E514045586E7C7A6D5F575A
667484939FA59E876647363C536E82877E726B6D767D7D72
6050494F5F707B7E787068636263666C7279818990928B79
614B434F6985938C
7767626F88A3B8C2BFB49F7F5B39231F293A4C585E626463
626266707F8B8F87766558555B65717F8B9493877460575E
7085918D7F6F69718393978A70554648586A75746A5F595C
6773808D979C97846A51444C627C8C8C7F6F6567717B7E76
66575158677883847D736A66666869696869707F909D9C89
6A4B3B445D798B88
786B6A7994ACB9B5A38B725B4A3E3A404D5D6B737776736E
6965666F7B878C86786A5F5C606874818E98998E7B695F65
74868F8A7A6A636978888E86746054535A6469675F59565B
65707B848B8D887965544E597087948D7963565A69798079
695851596A7D8B8D877E75706F6E6C66605D63758C9FA390
6F4C393E55718384
776E6E7E97ACB1A07F5D43393E4A5A6A78838C8F8E888077
6E68676D78818682786D6563666D76828E97988F8070676B
78868C8575655C5F6B798181786E6561605F5D595552545B
656F777C7D7C766B5F5555647B90998D7358484D6076827C
6B5A51596B7F8E949089817B77726C6259545A6D869CA391
714E393D526C7E81
786C69758A9A9B85623E292B3F5B778B979EA19F9990857B
726D6B6E747B7D7A736B67676D747B83898D8C867B716C71
7C86887F6F5E54545D69747A7C7B7770685F57525052575F
69717676736D665F58555B6B81949A8C715444495D74827F
7061585C6979878E908F8A847B72685C534E54667F959C8D
6F503E4257708182
7A665A5D6975786A533E353D546E86979FA2A09B92887F78
737171727374736F69646469737D83837E78726D6B6A6D75
7E85857A69584C494F5966737E86878072645954565B636B
727879756E655D5856575F6E808F9488735D505362737F81
7A716A66676A7079828A8C867B6E60554F4C5363788A9084
6B52454E66808F8B
7D5E463C3F474E5252545A6573808A91949490887E756F6E
71767877736F69625D5A5D6978868B82715E504D535E6A76
7F84827765534540444D5B6D7E8D928C7E6D615E636A737A
7F817E776D625A56565B636E7A858984796E66666C737B82
868681746456515A6B7E88847766574F4D4F5663717E8277
65534F5E7994A197
7F5836211B1E2A3E566F848F918D888583807A71665E5C62
6D797F7D756B6057514F56677C8D9181654632303C4F6374
7E8481756451423B3D4554687D8F989488786D6B70788186
8988847B6F625A57595E656D73787C7E7F7E7C7875737681
8F9996816143333C55718281715E4F4B4F575F676D73726A
5E55586D8BA5AFA0
7E58341A0C0A17345B839FA9A292827974706A60554D4E59
6979828176695C524C4A52657D9194815F3B231F2C41586D
7B85857A6853433B3C445264788A95958D8279777A7F8489
8C8C887E71635A585C636A6D6F70737980878882786F6F7D
91A2A1896139242B47687D7D6C594B4C56626B6F6E6C6760
59575E738EA5AD9E
786147301E151D375D85A1A89E8C7B716E6B675D51494A55
67788281786C5F554F4D54667C8F938364442B2228364A60
76878D84725B4941424A5563717E888C8C8984807C7A7A7F
868B8A8172635959606A7173726F6F757D85867F73686775
8A9D9F8A643F2A304A677A7969584E5260707A7B746C635C
58575D6C7E8D928B
706F6859473936455F7A8E928A7C716D6E6F6D64584F4E57
66757F807A71675E58555A6779898E85715A44352F303B53
6F8A98927F66524B4D555D64686D747D868C8C85796D686D
798589817262585A64717A7C79747173767A7972675F5F6B
7E8F93856B504145576C7976685A545C6D7E88877D71655D
5958595C6064696D
677E8A8676645858626E7676706966697076766E6258545A
66747E817E777068615D5F6875818888807564503D303248
6A8CA19F8B715C565B636867615D5F6B7C8B90867360565B
6A7B847F71635A5D69768083817C76726F6C67615B575A64
727F858073655C5F68737873685F5D67788A949185766861
5E5C574E433D4050
648AA5A99D89766B6765635E59575A64707B7E77695B5459
66768185837D756D666161666F79828A8E8C816B50393446
698DA4A38F7663606872756E6053515D71858D836E584B4E
5D6E7979716863666F78808484817B72695F575251525860
6A747A7B78747071737676716A6465708090989386756864
6566604E3827273E
6791AFB7AE9B88786E655C534C4A4F5D6F7E837966534A52
657B8B8F897F7469625D5C6169737F8B959A9481674F4552
6D8B9D9A89736567737F837967554D55677A837C6B584B4A
535E696F727374757575767A7E817E7466574C494C525B63
6C73797B7A777473747474706D6A6D76828E928B7C6B6264
6F78766347302B40
6E91AAB3AC9E8E81766B6054494448576C7F85775E453B48
6483999C917F6E6058545459636F7D8B979E9C8F7C6A6166
75868F8A7B6B636A7A899086735E52545F6C7372695F5650
4E4F5662728189857A6D666A747D7F76655348464C56616B
747B7E7C77716C6A6C6E7171706F72788086857A6A5B5763
798D9486694E4350
768C9EA4A0978D847C74695B4D4445546B7F847456392F40
658CA6A8977E66564D494B525E6D7D8A949A9B968D837C7B
7D8180776B615F6A7D8F97907F6B5C56585D63666869655B
4E454657728B99927D65575A69798078655246454F5C6975
7E83847E7469615F62696F72737475777A7C7669584B4D61
81A0B0A78D716063
76828C908F8B8784827D7568584C4A576B7E837254382F44
6C95AFAF9A7C614F4643474F5C6C7B858C8F919292908D88
837D756B615B5D697B8C95928575655A5451545D6974766B
574540506E8C9B937A5E4E5264778078655146475464737F
8689867D70645B5A5F676F747575747474736B5D4E434861
85A9BDB8A287736E
6D747A7D7C7C7D81858784796B5D585F6E7D81735B464155
799DB2AE987A5F4E474549515D6B767D7F7F8083878A8B89
837D756B625D5D657380888882786C5E534A4B596D80887E
6952474F667E8A84705B4F55667880776451464B5B6E7D86
888681786F666061666D73767572706F6F6E695D50484D63
83A2B4B19E85726A
5E63686A6A6B707A8690938D8072696A717A7D75685D5E6E
88A1AEA7927861524D4C5057616B7273706C6A6C72787D7F
807E7A736B646062676E747778766F6354494958718A9792
7E6757545D676E6B635B59616F7B7F74625048506276868A
877F77726E6C6C6E72777978736E6A696C6E6C655C555867
7C919C978773635C
50535657575962728798A29F938477727275777674747986
95A1A59C8A7563585454585E666D6F6C645B55555A616A72
7A7F807C756C645F5C5C5F656D737268594C4B5B7590A0A0
917D6A5D55525153575D656F797F7E7261524C55687C8A8B
8378706C6E72767A7D7F7E79726A6565696E706E6964646A
747D80796D5F544F
4A4A4948474B576C869EACAB9F8E7E736E6D6F72777E8790
979B99908273675E5A5A5D646D73746C5F50464448515C68
737C807F7970665D5652545B6771756E6054525F768D9EA1
9A8C7A67564842465262717B81827D726457535A6A7C8788
81776E6B6D7075797D7F7F7A726A6564676C6F71706E6D6D
6D6C69645D56504C
514A44403F445169859FAEAD9F8B796C666465696F777F86
8B8D8B857D736A625D5A5E68757F81776450423E434D5963
6C727675726C655E5855565E697478746A605C63707F8C92
928D82726050484C5969778084837E756A605B5F69747D81
807C77706A6564676D74797976716C69666566686B6E6F6D
6965616061605E58
6051443D3C425169859EABA7957E695D59595B5D5F63686F
767B7D7C79746D655D585B697C8D9388725947434A555F64
66656565656563626060636971787B79736D6866686B7178
7E83837C70655F60677079808383807A726A656263676E77
8087857967554A4B55626F777B7C7871675D58595F676C6C
6965646A7278786F
715A473D3C43526A849BA59D876C564C4C515453504E5057
60697074757470665C5558698198A2988066524E555F6767
615B56565A5E62666A6E7276797B7D7D7C7A746B6158565C
67747E82807D79777777797C8082827F79736B635C595E6D
81919483654733313E5165758086847969574B4A535F686B
6A686C7786929387
7C5E4538383F50688399A09377573F383F4A52514A434247
525D666D70726E665C5558688199A59F8B73625D62696C68
60575253585F666D73787C7D7D7C7C8084868173604F4548
54657580878B8B87817A77787D8284827D766C60554E5265
7F969D8A6742292533496175838C8C7F6B5647454E5C686C
6B6B728297A6A998
7D583A2B2A3245617F989F8D6942282433475759524A4548
515A6166696B69635D595B687C8E9A988D7F726D6C6D6C68
625E5C5F646B7075777A7A7A79787A818A8F8C7E69544644
4C59687581898C89817974767C8285827B7166594E474D61
7C959D8D6D4B332F3B4F6476838B8B806F5C4F4E57636D70
6D6C73869EB0B39F
764D2C1B192338597C99A18B603315152B486068645D5757
5B5E6162626261605F5F6269727C83878886817B736C6866
686C70757A7D7E7C7874716F6F7177818C94958A7865554D
4D515A65707B81807A7470747C83857F74685B5049474E60
788D968C765D4B48515F6E798085847D72675F6067707674
6E6A70839CB0B29C
6D4422110F1930547B9BA48B5D2B0C0E294D6C7979736D69
696764605C5A5B5D62676A6A69686B737F888C85786B6466
6F7B858C8E8D8980766C65626469727E8B9497928778695C
534D4D545F6B7375716D6C727B82837B6C5D5049484B5463
75848C897E7066656971777B7B7B7A7875727173787D7D78
6F696D7E96A8AA93
6745291A182036587F9EA78F623214173358778789847E7A
76716A635D595A5F676E716C6259576172838B86786A6367
7585929898938B7F71655C585B626C77838C92938F867A6B
5B4D474A54616B6E6B68676E777F7F7667574B484C545E69
747D8384827E7A797A7C7C797572707275797D8081827F77
6F686A778A999A87
6755463D3B3F4F6A89A3AA96714A32344B68818E908C8783
7F79736C666262676F75766E6155505665757E7C7369666C
79869194918A80756A5F5855565C636B747B82888B8B8475
6352494B57656F706B6462677078797264574F5057616B72
777B7D7F80807F7E7D7B78736E6A696D737A7F807F7C7771
6C67686F7A828278
6C6F706E6C6C738296A6AA9D856C5D5D697A888F8E8B8785
82807C7773706F73777B7A72655951525961686B6A6A6C72
7A8185837D766E67615D595756585A5D61666D768087867B
6A5A515562717A796F645E60676E726E655D595D6670787C
7D7B7A7A7A79787674726F6B676465696F757878746F6A68
676868686868686A
7288989E9C9795989FA5A7A2988E8684878A8C8C89868483
838383817F7D7D7D7F7F7C756B6158524F4F5359616A7277
7979756F67605B595A5C5D5C59565452515359657380857E
71625B616E7C848175675E5C60666A6A6664656B747D8384
827D787572706D6A68666463616162666A6E706D67615E5F
646868615850515D
7697B0BAB7AFA6A19F9E9E9FA0A1A09D97918A85817F7E7E
8082848585858483827F7B77716B62584D46454E5D6D787B
7870675F57525052585E63625E59534D4A494E5A6978817F
756B666A747F8481786D64606063656666686D747D858988
847D76716C6865625F5E5E5E5F606265686A69655F59575A
6269695E4F434457
7797AEB6B2A89E96918E8E91979C9F9C958B837D79777778
797C7E80818281807E7B797776736D61544A475060717C7D
766B5F57525051565E656A6A666059534F4E515A66737B7C
77716C6C6E7275767674726E6965626264686E757C838685
817B746F6A6663605E5E5E6061636567696A69655F5A595D
646B6B615247475A
768A989B958C837D7A787A7D82878988837D777371707070
7172747577787877767574767879766D6258555C69777F7D
73675D5857595D62686E71716E6964605D5C5E6369707577
77747069625C5D65717D8481776C635F6064696F757A7D7E
7B77726E6B6866646363646566686A6B6D6D6D6A66636164
696E6E675E565763
74797B7871696360616365686A6C6D6E6D6D6B6A6A696868
686868696A6B6C6C6D6D6F74797D7E797069666A737C807C
71665D5C5F656B707478797876726F6E6D6E6F6F6F6E6F71
74746F63544847566E8694938574645D5D5F63676B6F7374
7473716F6D6B6A69696A6B6C6D6E6F70717171706E6D6C6D
6F70716F6C696A6E
716B645C544E4A4B4E525657575656595C5F626464646362
616060606061626465676B71787E81807B7673757A7E7E78
6E645F60676F777B7D7D7D7B7A7978787A7B7C7A76716E6D
6E6E695C4C4040526F8C9E9D8D78665D5B5C5F6164676A6D
6F70706F6E6E6D6D6E6F7071727273737474757575757474
7372737577797876
6E64595049444244474C4F50504F4F52565A5E6061616160
5F5E5D5C5C5D5E606265696F757B7E7F7D7B79797B7B7973
6B6361646C757C7F7E7C7A79797A7B7C7E7F7F7E7C78736E
68625B524B484E60788F9C998A77675E5B5C5E6061636669
6C6E6F6F6E6E6E6E70717273747474757575757676777776
747374777B7D7C77
6C635A534E4A48484A4D505152535456595C5F6061616161
60605F5E5E5E5F616365696C70747779797877777675726D
676362666E767B7D7B787574757778797A7A7C7F82827D71
61534A4A515C6A78858D908B807267605E5F606263656769
6C6D6E6E6E6D6D6D6F707172737474747474747474757574
7473747678797873
6965605C58555352535455575A5C5E5F6162626364646464
64646463626262636567696B6C6D6F7071727272716F6D69
666464686E74787977747170707172727272767D868B8675
5D473D455A7488908F898079736D67646263646567686A6B
6C6D6D6D6D6C6C6C6D6E6F70717272727272727171717272
727273737372706D
6868676563615F5E5D5C5D5F626567686867676767676868
6869686867666667686A6B6B6A6969696A6A6B6C6D6D6C6B
696767696D717476777674706C696767696C727C868D8976
5D463D4A66859A9C917F706968696969686768696A6C6C6D
6D6D6D6C6C6C6C6C6C6D6E6E6F7070707070706F6F6E6E6F
707171706E6C6A69
696A6B6B6A6A686766656566696B6D6D6D6B6B6A6A6B6B6B
6C6C6C6B6A69696A6A6B6C6C6C6B6967656464676C717373
706D6A6A6B6D71777E8281796C5F5859606A747C82848074
6355515D748B98958673645F63686D6F6E6C6C6C6D6D6D6D
6D6C6C6C6C6C6D6D6D6D6D6D6E6E6E6E6E6E6E6E6D6D6D6E
6F6F6F6E6C6A6868
6B6C6D6E6E6E6E6E6D6C6C6D6D6E6F6F6F6E6D6D6D6E6E6E
6E6E6E6D6D6C6C6C6C6C6D6E6F706E69635F5F656F797F7F
79736D6967696F7A889394856E57494B596B787D7B76716E
6D6D70778087888073655C5C626B717473716F6E6D6D6C6C
6C6C6C6D6D6E6E6E6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D
6D6E6D6D6C6B6A6A
6E6F70717272737373737372727171707070707070707070
7070706F6F6F6F6E6E6D6E707374736C635B5B6473828B8A
81766C6562646C7D92A2A49171513D40536B7C7D73686369
77848D8E887F746A6059575B646D7579787572706E6D6C6B
6B6C6D6D6E6E6E6E6E6D6D6C6C6C6C6C6C6C6C6C6D6D6D6D
6C6C6C6C6C6C6D6D
707172737576777878787877757473727272727271717171
71717171727271716F6E6E707477756D635B5B66798A938F
8171635B5A5E6A7E96A8AB97744F393B50697B7B6F635E68
7A8C96948778685D5653555B656F787B7B7874716E6D6C6B
6B6C6D6E6F6F6F6F6E6D6D6C6C6B6B6B6B6B6B6C6C6D6D6C
6C6B6B6B6C6D6E6F
7172747577787A7B7B7B7B79787674747373737272727272
7273737474747472706E6D6F7173726D655E606C7E8E948B
7762524C4F59687D92A2A49273533F3F4F637377716A676B
757D82817B746B625A54545A6470787C7B7773716F6E6D6C
6D6D6E6F6F6F6F6E6E6D6D6C6C6B6B6B6B6B6B6C6C6C6C6C
6B6B6A6B6C6D6E70
71727476787A7B7C7C7C7B7A797776757473737272717172
7374757576767574716E6C6B6B6C6C6A67656975848F8F7F
664D3C3A4455687A89929286715C4D4A505B6771777B7973
685E595D67727773685C5659636E7779787572706F6F6E6E
6E6E6F6F6F6F6E6E6D6D6C6C6C6C6C6B6B6B6B6C6C6C6C6B
6B6B6A6B6B6C6E6F
7072747677797A7A7A7A7979787776757473727170707071
7274767778777674716D6966646364676A6F7680898D8671
5338282B3C546A787E7F7C766F665E5854545C6B7E8C8D7B
5C3E2F385270848679685D5C636C737573706F6E6F707070
7070706F6F6E6D6D6D6C6C6C6C6C6C6C6C6C6C6C6C6C6C6B
6B6B6B6B6B6C6D6E
6F7072737576777777777676767575747271706F6E6E6E70
7174767878787774706C67615C5A5C646F7B858C8E8A7C63
452B1F273D586E76746D68686C7170675B52546782989B81
562C1621446D8B9287766864666A6D6E6C6B6B6D6F707172
727171706F6E6D6C6C6C6C6C6D6D6D6D6D6D6D6D6C6C6C6C
6C6C6C6C6C6C6C6D
6E6F7071717272737373737373737272706F6E6D6C6B6C6E
7073767879787774706B655C555155637688959891847058
402D2732496274766D60595E6B797E756455536481999E86
5B311A23436987938E8479716D6966646466696C6E707273
737372706F6D6C6B6B6B6C6D6D6E6E6E6E6E6E6D6D6D6C6C
6C6C6D6D6C6C6D6D
6D6D6E6E6E6E6E6E6E6F6F707070706F6E6D6C6A6969696B
6E727578797977746F6A63584F4A4F627D96A4A2927C6552
433A3B485B707B78695951586A7D867F6E5D57647C929988
694835374B647B898F908B8275685E5A5B60666B6E707274
757473716E6C6B6A6A6B6C6D6E6E6F6F6F6F6E6E6D6D6D6D
6D6D6D6D6D6D6D6D
6D6C6C6B6A6A6A6A6B6B6C6D6D6E6E6D6C6B6A6867666769
6D717478797977736F6961554A444B6383A0B0A992755C4D
494B5360707D827A6A585057697D888475665F6778899088
76635550555E6C7D8D9A9D927E675650545B646A6E707375
767574716E6C6A69696A6C6D6E6F6F70706F6F6E6E6E6D6D
6D6E6E6E6E6E6E6D
6C6B6A69686867676869696A6B6C6C6C6B6A686765656668
6C707477797977736E685F5348434B6486A5B4AA8F6F554A
4D5663717D86887F6F5F565A67778180766C676C76808684
7C7369605A5860738BA1A99D846751494E5862696D707376
777775726E6B6968696A6B6D6E6F707070706F6F6E6E6E6E
6E6E6E6E6E6E6E6D
6C6B6A69676766666767686A6B6B6B6B6A69686665646567
6B6F73777A7A78736D665D5249454E6686A2B0A58A6B5248
4B5563717E898D877C6E6361646B7071706F6F73787C7D7A
756F675E56535A6F8BA4AEA286674E464A5560686D717477
787775726E6B696868696B6D6E6F707070706F6F6E6E6E6E
6E6E6E6F6F6F6E6D
6D6B6A69686766666768696A6B6B6C6B6A69686665646567
6B6F73777A7B78736C645B524C4B5468839BA59C84685146
474D596877858E8F8A81756B625C5A5E656E767B7D7B766E
665E564F4B4D586F8BA3ADA186664E464A545F676D717578
797876726E6B686768696B6C6E6F707070706F6F6E6E6E6E
6E6E6F6F6F6F6E6E
6D6C6B6A6968686868696A6B6C6C6C6C6B6A686765656668
6B6F73777A7B79736B625A5350525A6C809299907D655247
454A53606F7D8A9296938977614E454A5A6D7C84827C7165
584D4440414858708BA1A99E846750474A545E676D727678
7A7876726E6B686768696B6C6E6F707070706F6F6E6E6E6E
6E6E6F6F6F6F6E6E
6D6D6C6B6A6A6A6A6A6B6B6C6D6D6D6D6C6B696866666768
6B6F73777A7C79736A615A555558606F7F8D91877560504A
4E5660696F77808D999F99826346373D536D838C89807364
564A403C3D45556D889EA79C836751484B545F676D727679
7A7976726E6B686768696B6C6E6F7070706F6F6E6E6E6D6E
6E6E6E6F6F6F6E6E
6E6D6D6C6C6C6B6B6C6C6D6D6E6E6E6E6D6C6A6968676869
6C6F72767A7B79736A625B58585B6472828E90836D574B51
647988887E73707C8FA0A18C6948363C5471889290887D72
675D534943434E66839CA79E856851484C5560686D727679
7A7976726E6B686768696B6C6E6F7070706F6F6E6E6D6D6D
6D6E6E6E6E6F6E6E
6E6E6E6D6D6D6D6D6D6E6E6F6F6F6F6E6E6C6B6A6968696A
6C6F7276797A78726B635D5A5A5C657486949583664C4459
80A8BEB494715C637C96A092725240445A758B9696918B87
837E73625044465C7C9BABA2876850474C5661696E737679
7A7976726E6B696868696B6C6E6F6F70706F6F6E6D6D6D6D
6D6D6E6E6E6E6E6E
6E6E6E6E6E6E6E6E6F6F6F6F70706F6F6E6D6C6B6A696A6B
6D6F7275787977726B65605D5C5E66768A9A9A8360423D5F
98D1EDDAA76D4849658699937A60505263788A949797979A
9D9C91795C453F53779BAEA68A694F464C57636B6F737678
797876726E6B696868696B6C6E6F6F706F6F6E6E6D6D6D6D
6D6D6D6D6E6E6E6E
6E6E6F6F6F6F6F6F707070707070706F6F6E6D6C6B6A6B6C
6D6F7274777776716C67625F5E6068788C9C9A805A39355E
A1E1FFE8AA6537334F748E91837165646D78838B909499A0
A6A79C8362463E51759BB0A88B694E464D59656C70737577
797876726F6B696868696B6C6D6F6F6F6F6F6E6E6D6D6D6D
6D6D6D6D6D6E6E6E
6E6E6F6F6F6F7070707070707070706F6F6E6D6C6B6B6B6C
6D6F7174767675716B67636162646B7A8A97937852322E53
91CDEAD398582B274064818D8B847D78767576797F858C92
96968D775D474256799CAFA68A6950484E5A656D70737577
787875726E6B696868696B6C6D6E6F6F6F6F6E6E6D6D6D6C
6C6D6D6D6D6D6E6E
6E6E6E6F6F6F6F70707070707070706F6F6E6D6D6C6C6C6C
6D6F7073757674706B6663636669707B868D866E4C2F2944
73A1B7A679482724385672869095948B7E6F6563686F7577
76736B5E51484C617F9CABA18769524A505B666D70727576
787775726E6B6968696A6B6C6D6E6F6F6F6F6E6E6D6D6D6C
6C6D6D6D6D6D6D6E
6E6E6E6E6F6F6F6F6F6F70707070706F6F6E6E6D6C6C6C6C
6D6E7072747574706A656365696F757B8081786349312937
53707E745A3D2A283549627B92A2A69A8267524D525A5F5D
564E47444449556B869CA69C8469544D525B666C70727476
777674726E6B6969696A6B6C6D6E6F6F6F6F6E6E6D6D6D6D
6C6D6D6D6D6D6D6D
6D6D6E6E6E6E6E6F6F6F6F6F6F706F6F6F6E6E6D6C6C6C6D
6D6E6F717375746F696462666D74797B7A746B5C4B3C3436
404A504D453C3532353D4E6A89A3AC9D7D593F39414E5550
443831323B485B72889AA19781695650545C666C6F717475
767674716E6B6A69696A6B6C6D6E6F6F6F6E6E6E6D6D6D6D
6D6D6D6D6D6D6D6D
6D6D6D6D6D6E6E6E6E6E6F6F6F6F6F6F6F6E6E6D6D6D6C6D
6D6D6F717374736F6863626770787D7B736A605A55514C47
413D3B3E43484841373036507494A1926E462C2B3B505D59
4B3B31313A475A6F85969C937F695752555E666C6F717374
757573716E6C6A69696A6B6C6D6E6E6F6F6E6E6E6D6D6D6D
6D6D6D6D6D6D6D6D
6D6D6D6D6D6D6D6D6E6E6E6F6F6F6F6F6F6E6E6D6D6D6D6D
6D6D6E707274736E68636268727B7F7A6E625A5C636A6C63
54443D42505E61533B252035597C8C7D59321D243F5E7272
6351423C3F4754687D9098917F695953575F676C6F707273
747473716E6C6A69696A6B6C6D6E6E6F6E6E6E6E6D6D6D6D
6D6D6D6D6D6D6D6D
6D6D6D6D6D6D6D6D6D6E6E6E6F6F6F6F6F6E6E6D6D6D6D6D
6D6D6E707273726E68636268737C7F786A5D58607182887F
6B564B5265777A6643221321436676694725162549708B8F
816D5A4D48474F607589938E7E6A5A555961686D6F707172
737372706E6C6A6A6A6A6B6C6D6E6E6E6E6E6E6E6D6D6D6D
6D6D6D6D6D6D6D6D
6D6D6D6D6D6D6D6D6D6D6E6E6E6F6F6F6E6E6E6D6D6D6D6D
6D6D6E6F7173726E69646469727B7D76695D5A65788C9690
7F6C636B7E8F9078512B18213F5F6F6346291F325A83A0A5
99846F5E524C4E5C6F838E8A7C6A5C585C63696D6E6F7072
737372706E6C6B6A6A6B6C6C6D6E6E6E6E6E6E6E6D6D6D6D
6D6D6D6D6D6D6D6D
6D6D6D6D6D6D6D6D6D6D6D6E6E6E6E6E6E6E6D6D6D6D6D6D
6D6D6E6F7172716E6A66666A707678746C64636977858E8F
8982818997A19E876544333B55707E755B433B4C6F93ABAF
A3907B6A5D55555F6E7E8885796B5F5C5F656A6D6E6F7071
727271706E6C6B6B6B6B6C6D6D6E6E6E6E6E6E6E6E6D6D6D
6D6D6D6E6E6D6D6D
6E6E6D6D6D6D6D6D6D6D6D6D6D6E6E6E6D6D6D6D6C6C6C6D
6D6D6E6F7070706E6B69686A6D70727271706E6D6E71777F
8A949DA6ABACA4927B665D667B919C947F6A616C849DADAD
A1907F7168616167717B817E766B636063676B6D6E6F6F70
7171706F6E6D6C6B6C6C6C6D6D6E6E6E6E6E6E6E6E6D6D6D
6D6E6E6E6E6E6E6E
6E6E6E6E6D6D6D6D6D6D6D6D6D6D6D6D6D6D6C6C6C6C6C6C
6D6E6E6F6F6F6F6E6D6C6B6A69696B70767B7A71655C5D6C
859FB3BAB7AFA3978D868690A0B0B7B1A190868994A1A7A4
998C7F76716D6D7074797B78726C676566696B6D6E6E6F70
7070706F6E6D6C6C6C6D6D6D6E6E6E6E6E6E6E6E6E6E6E6E
6E6E6E6E6E6E6E6E
6F6E6E6E6E6E6D6D6D6D6C6C6C6C6C6C6C6C6C6B6B6B6C6C
6D6E6E6F6F6F6E6E6E6E6C6A6764666E7982827561504C5D
7C9CB4BAB2A69B96979AA1A9B3BBBFBAB1A59C98999A9994
8B837C7876767676767675726F6C6A696A6B6C6D6E6E6F6F
6F706F6F6E6E6D6D6D6D6E6E6E6E6F6F6F6E6E6E6E6E6E6E
6E6E6E6E6F6F6F6F
6F6F6E6E6E6E6D6D6D6C6C6C6C6C6C6B6B6B6B6B6B6B6B6C
6D6E6F6F6F6F6E6E6E6E6C696563656D7881827765554F59
6E86989D99928D8E949BA1A5A7A8A7A5A29D97928C86827D
7A777677787979787572706E6D6D6D6D6D6D6D6E6E6E6E6F
6F6F6F6F6E6E6E6E6E6E6E6E6F6F6F6F6F6F6E6E6E6E6E6E
6E6E6E6F6F6F6F6F
6F6F6F6E6E6D6D6D6D6C6C6C6B6B6B6B6B6B6B6B6B6B6B6C
6D6E6E6F6F6F6F6E6E6D6B696664656B737A7D7970665F5D
5F646A6E72767B82888D8F8C867F7B7B7E81817C746C6665
676B6F7376787876726E6B6B6C6E6F706F6F6E6E6E6E6E6E
6E6E6F6F6E6E6E6E6E6F6F6F6F6F6F6F6F6F6E6E6E6E6E6E
6E6E6F6F6F6F6F6F
6F6F6E6E6E6D6D6D6D6C6C6C6B6B6B6B6B6B6B6B6B6B6B6C
6D6D6E6F70706F6F6D6C6A686666676A6E72767A7C7A7364
52423A3E4A5B6A74797A766C60544D4F576065635B524E50
5760686E727474726E6B69696B6E717171706F6E6E6E6E6E
6E6E6E6E6F6F6F6F6F6F6F6F6F6F6F6F6F6F6F6E6E6E6E6E
6E6F6F6F6F6F6F6F
6F6F6E6E6E6D6D6D6D6C6C6C6C6B6B6B6B6B6B6B6B6B6B6C
6D6D6E6F7070706F6D6B69686868696A6A6B70798388826B
4C2F1E2031475C676B69615545372F323C4952514B444145
4F5A646A6E6F6F6D6B6867686B6F717272716F6F6E6E6D6D
6D6D6E6E6E6F6F6F6F6F6F6F6F6F6F6F6F6F6E6E6E6E6E6E
6E6E6F6F6F6F6F6F
6E6E6E6E6E6D6D6D6D6C6C6C6C6C6C6C6C6C6C6C6C6C6C6D
6D6E6F6F7070706F6D6B6A69696A6A6A69696E77838A8570
523522223043545F62615B4F41342D303A4750514C47454A
535C64696B6B6B6A686767696B6F71727271706F6E6D6D6D
6D6D6D6E6E6E6F6F6F6F6F6F6E6E6E6E6E6E6E6E6E6E6E6E
6E6E6E6E6E6E6E6E
6E6E6E6E6E6E6D6D6D6D6C6D6D6D6E6E6D6D6D6D6D6D6D6D
6E6E6F6F7070706F6D6C6B6A6A6A6B6A6A6B6E757D817F72
604D403C414A535A5F6160594F4641434B545B5D5B58575A
5F65696A6A6968676767686A6C6F707171706F6E6E6D6C6C
6C6C6D6D6E6E6E6E6E6E6E6E6E6E6D6D6D6D6D6E6E6E6E6E
6E6E6E6E6E6E6E6E
6D6D6E6E6E6E6E6E6D6D6D6D6E6F70706F6F6E6E6E6E6E6E
6F6F6F6F6F6F6F6F6E6D6C6B6B6B6B6B6C6E707275777674
6F6A645F5A57575A5F656867635E5B5D61666B6D6D6C6C6D
6E6F6E6D6A67656566686A6C6D6E6F70706F6F6E6D6C6C6C
6C6C6C6D6D6D6E6E6E6D6D6D6D6D6C6C6D6D6D6D6D6D6D6D
6D6D6D6D6C6C6C6D
6C6C6D6D6E6E6E6E6E6E6E6F70717171717170706F6F6F6F
6F6F6F6F6F6F6F6E6E6E6D6D6C6B6B6C6E7071706F6E6F74
7B80807A6F645D5D62696F7272727172737577787A7B7C7B
7976736E6A67656566696B6D6E6E6E6E6E6E6E6D6C6C6B6B
6B6B6C6C6C6D6D6D6D6C6C6C6C6B6B6B6C6C6C6C6D6D6D6D
6D6C6C6C6B6B6B6B
6A6B6B6C6D6D6E6F70717272737373737373727271717070
6F6F6F6F6F6F6F6E6E6E6E6E6D6C6C6D6F71716F6C6A6C73
7C848782786D6563676D737678797A7A7A79797B7D7F7F7E
7B77736F6B686666686A6C6D6D6D6D6D6D6D6D6C6C6B6B6B
6B6B6B6B6C6C6C6C6C6B6B6B6A6A6A6A6A6B6B6C6C6C6C6C
6C6B6B6B6A6A6A6A
696A6A6B6B6C6E7072747575757574747474747472717070
6F6F6F6F6F6F6F6F6E6E6E6E6E6E6E6E6F706F6E6C6B6C70
767C7E7C77716D6B6D6F7274767778777776757677787877
7573706E6B6A69696A6B6C6D6D6D6C6C6C6C6C6C6B6A6A6A
6A6B6B6B6B6B6B6B6B6A6A6A696969696A6A6B6B6B6B6B6B
6B6B6A6A69696969
6869696A6A6C6E7073767777767574747575757473727070
6F6F6F6F6F6F6F6F6E6E6E6E6F6F6F6F6F6F6E6E6D6D6D6D
6E6F70717273747473727272727272727170706F6F6F6F6E
6E6D6D6D6D6D6D6D6C6C6C6C6C6C6C6C6C6C6B6B6B6A6A6A
6A6B6B6B6B6B6B6A6A6A6A6969696969696A6A6B6B6B6B6B
6A6A6A6A69696969
696868696A6C6F717375767675747373737474737271706F
6F6E6E6E6E6E6E6E6E6E6E6E6F70706F6F6E6D6D6E6E6D6B
686565696E747879777472706F6E6E6D6D6C6C6A69686767
68696B6C6E6F706F6F6D6C6C6C6C6C6C6C6B6B6B6B6B6B6B
6B6B6B6B6B6B6B6B6A6A6A6A6A69696A6A6A6B6B6B6B6B6B
6B6A6A6A6A6A6A69
6A6868696C6F7172727171717171717170707070706F6F6E
6E6D6D6D6D6D6D6D6D6D6E6F6F70706F6E6D6C6D6D6E6D6A
676464686E747879787573706F6E6D6C6C6C6B6A68676666
68696B6D6F707171706F6D6D6C6C6C6C6B6B6B6B6C6C6C6C
6C6C6C6C6C6C6C6B6B6B6B6B6B6B6B6B6B6B6B6C6C6C6C6C
6B6B6B6B6C6C6C6B
6B69686A6E7273726F6B69696A6C6E6E6C6B6A6B6C6D6E6E
6D6C6C6B6A6A6A6B6C6D6E6F6F6F6F6E6D6D6C6C6C6C6C6B
6A6A6A6C707375767675747271706F6E6E6D6D6C6B6A6A6A
6B6D6E6F70717171706F6F6E6D6D6C6C6C6C6C6D6D6E6E6E
6E6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D6D6C6D6D6E6E6D
6D6C6C6D6E70706E
6E6A696B707476736C65616164686A6A68666566686A6C6D
6C6C6B6A696869696B6D6E6F6F6F6E6D6D6C6B6B6B6B6C6D
6E707171717171727374747473727170706F6F6E6E6E6E6F
70707171717070707070706F6E6E6D6C6C6D6D6E6F707170
706F6E6E6E6E6F6F6F6F6F6F707070706F6F6E6E6F6F6F6F
6E6E6E6F72737471
706B696C717677726A625C5C5F6467676562616265686A6B
6B6B6A6A6969696A6B6C6D6E6E6E6D6C6C6C6B6B6B6B6C6E
7173747472706E6F70727374747372727171707071717272
737372727171707071717170706F6E6E6E6E6F7071727372
727170707070707171717172737373737271707070717171
706F707275787875
736D696A6F7476726A625C5B5D616364636262636567696A
6B6B6B6C6C6C6D6D6D6D6D6D6C6C6C6C6C6C6B6B6B6B6C6E
7072737372706F6F70717272727272727271717172727373
737272727272727272727171717070707171727373747474
747473737272727373747475767676757574737272727272
717172767A7E7E7A
766D68686C7174716B65605E5E5F61626364646566676869
6A6C6D6F707172716F6E6C6B6B6B6B6B6C6C6C6C6C6C6C6C
6D6E6F707172737372717070707071717171717171717171
717171717273747473727171717172727374757575747475
757676767574747475767777787878777776757473737272
727275797F83837E
766B6464696F73726E69656261616162646668696969696A
6B6D6F7274767674726F6C6A6A6A6A6B6C6C6D6D6D6C6B6A
6A696B6D7174767573706E6E6E6F7070717171717170706F
6E6E6F707274757473727170717273747576767675747474
757777777674747475777879797978787776757473727271
7273767C82878780
72665F60666E7475736F6B686666656667696A6A6A6A6A6B
6D6F717375767574726F6D6B6A6A6A6B6C6D6D6E6E6D6C6B
6A69696C6F737574726F6D6D6D6E6F7070707070706F6E6E
6D6D6E6F7173747372717070717273747575767574737373
747576757473737374767778787877777675747271707070
7173777C8286857D
685D575B65717A7C78736F6D6E6F6F6E6C6A6969696A6B6D
7072737371706E6E6E6F6F6E6D6C6B6B6B6C6D6D6E6F6F6F
6E6D6D6D6D6E6E6E6E6D6D6E6E6F70706F6F6F6E6E6E6E6E
6E6E6E6F6F6F707070707070707171717272727272727271
717170707070707071727374757575747372706E6D6C6D6E
7072767A7E807D74
5C514E56657682847E777172767B7C78716A6665676A6E71
737473706B6664656A6E7272716E6C6A6A6B6C6D6F717374
7474726F6A666465676B6E707070706F6F6E6D6D6D6D6E6E
6F6F6F6E6C6B6A6B6D6F7070706F6E6E6D6C6D6E6F70706F
6D6B6969696A6B6C6C6D6E6F707171706F6D6B696868696B
6E71747678787368
4F444350657C8B8C847972747D858781766A6261666C7175
7776736C645D595D656E757775706C6A696A6B6D70737679
7A7A777068605C5D62696F7171706F6E6D6D6C6C6C6C6D6E
6F70706D6A6765666A6D70706F6D6B69686767686B6D6E6C
69656262636567676868696A6C6D6D6C6967656363636569
6C6F717373716A5D
47393748638194958A7A71737E8A8E87796B62616870777B
7B78736A605754596471797B77726C6A696B6C6F71747679
7B7A776F665D585B61696F716F6C6968696B6C6B6B6A6A6C
6E6F6F6C67636162666A6D6E6C6A68656362626366696A68
65615E5D5E6062636464656768696866625F5C5B5C5E6165
696C6F7172706858
432F2A3D60849C9D8E7A6C6E7A888E887A6C64666F798082
807B736A6059575D69757E7E78716B696B6D707171727273
7373706B645F5D60666D706E68625E5F63686C6D6B686768
6A6B6B6864615F5F6265686867666462605E5E5F61636463
615E5C5C5C5D5F60616364656665635F5A55525254585D62
65686C727778705C
46291F335B86A2A390786766727F8783796E6A6E78838989
847C736B645F5F66717B817F786E68686C717474726E6B68
676666656465676A6F7270695F5551545D676E6F6C676363
6466676563605F5F5F616262626161605F5E5D5D5D5E5E5F
5F5F5F5E5C5C5C5E6164666665635F59524C48494D535A5E
62656B7580877F67
4B26182C5786A5A69175615E68747C7C756F6E75808A8F8D
857B726B68676A707980837F766C65666C737776716B6560
5C5A5B5F666C727678767065574B474C5A6872746E66605E
5F616364636261605F5E5E5E5E5F5F6060605F5D5B5A5A5C
5F636463605D5C5E6266696967635E564E4844454A51585D
60636B7A8B969074
532A18295483A2A48F735E585E6970726F6D7078828B8E89
80756C69696C71777E83837E746A64656B717676736E6760
5A56575E68737C807E7970625347444D5D6F7A7A71665C59
5B5F6265666767656461605F5F606263646564615C59595D
646B6F6D67605D5F646A6F6F6D68625B544E4A4A4E555B5F
61646D7F94A39E80
5C33202E537E9A9D8A725E56595F646767686C747C82827D
73696261656B73797E81807B736B6665676B70747778766F
665E5C626D798284807A6F63564D4C57697C868376665A56
595F656A6D6F70706E6C6A686767686A6C6D6C68615C5C63
6E797F7B716660616871777977736F6A66615E5C5D5F6264
6568718499A8A588
65402E3754768E918471615857585A5C5E61666B7072716B
625A56585F6770767A7B7B78736E6965626266707C868B85
796D6669727C83837E776F665E595C687A8B938C7B675955
59626B7176797B7C7C7B787673717172757777716962626B
7A89908A7D6E64656D77808382807E7D7D7C7975716E6C6B
6B6D768799A7A48B
6C4F3E43577082867E72665D57545253575C60636464605A
544E4D5159636C727475747473726E665E595C6A7E929C99
8C7D7170757C807F7A746F6A68686D7A8A989C927F6A5A57
5C6771797E818487888886837F7B7A7B7E81807A716A6A75
85959C9687766A6A717C858A8B8B8C8F9394928C837B7471
71747B8997A29F8B
715B4E505C6D797E7C766D645A524D4E53595E5F5E5A5652
4E4C4C525A636B6F706F6F7072736F665A52536279909E9E
9283767274787A787571706F71757C87939D9D93806D605D
646E787F8285878A8C8D8C8985817F80848787827A74737C
8A989E998C7D726F737B82878B8F93999FA2A0988D817975
7679808A93999687
71635B5C656F797E7E7B756A5F544D4D535A60615E5B5755
5555585D63696D6F6E6D6B6D6F706C63574D4B56687B888A
8379716E6F717271706F7174797E848C9296948C7F726A6A
70787F82828080828587888783807F8184888987827E7D81
888E918F89827B757372757A818991989C9E9B93887E7775
797E848A8E908B80
6F6864676D757D8283827C71645851515760666865636161
64676B6E707273726F6C6A6A6B6A675F554B474A525B6367
686766666667686A6C6F73787D8286888886847F7B777679
7E8285827D77737375797C7C7B7A7A7D8084878888878582
7E7B7A7D8184837B70656165707D878D8E8D888179726F72
7980878989857F77
6A696A6E747B8186888782776A5E57575E666D706F6D6D70
757A7E7E7D7A7773706D6A696867645D554D46413F3F4248
4F565C5E5D5D5E626970777C8082827E78737071757B8185
8889867F766C656365686C6F70727476797C8085898C8A80
72656068768489806D594E515E6E7A7E7C77716B6765666D
76808686827B746E
6566696D73797F85898A877E72665F5F656E75787878797E
83888A88837D77726E6B6A6B6B6B69655D554C443C38383E
4852595A5652535B67737D81807D766E655E5D636F7C868C
8C8881786E655D59595B5F63686C70727273757C858B897B
66524A556B828D836D5443434F5E696C69645E5B59595D65
707A80807A726A66
5E5E6063686D757D858A8A83796E67676C747B7F80818286
898C8B867F77716B69686A6F767B7C786F645B54514F5156
5C62635C52494853667985867E726459504C4F5969798588
847B736C67645F5B5754565C646D72726E69696F7A828172
5B463E4B647E8C86715846414750575B5A5957565454565D
666F7474706A6460
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{554, 263.563},
  ImageMargins->{{42, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008Z00011aP00`40o`000?l0003oooooooooool/
oooo003oooooooooobcoool00?oooooooooo;?ooo`00ooooooooool/oooo003oooooooooobcoool0
0?oooooooooo;?ooo`00ooooooooool/oooo000Yoooo00<0003oooooool06oooo`<00003oooo00<0
003oooooool06_ooo`<00002oooo00<0003oooooool06?ooo`800004oooo00<0003oooooool06_oo
o`030000oooooooo00;oool00`000?ooooooo`0Doooo1@0000;oool00`000?ooooooo`02oooo00<0
003oooooool04oooo`D000001?ooo`000000000000?oool00`000?ooooooo`12oooo00<0003ooooo
ool06oooo`<00003oooo00<0003oooooool06_ooo`<00002oooo00<0003oooooool06?ooo`800004
oooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo1@0000;oool0
0`000?ooooooo`02oooo00<0003oooooool04_ooo`D000001?ooo`000000000000?oool00`000?oo
ooooo`0Moooo000Xoooo00<0003oool000007?ooo`030000oooooooo00;oool00`000?ooo`00000L
oooo00H0003oooooool0003oool0000Ioooo00<0003oool000000_ooo`030000oooo000001[oool0
0`000?ooo`000002oooo00<0003oool000005oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`00000Foooo00D0003oooooooooool000001?ooo`030000oooo000004;oool00`000?oo
o`00000Loooo00<0003oooooool00_ooo`030000oooo000001coool01P000?ooooooo`000?ooo`00
01Woool00`000?ooo`000002oooo00<0003oool000006_ooo`030000oooo000000;oool00`000?oo
o`00000Hoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000001Goool01@000?oo
ooooooooo`000004oooo00<0003oool000007_ooo`00:?ooo`030000oooo000001goool01`000?oo
ooooooooo`000?ooo`00000Joooo10000004oooo0000oooo00006Oooo`030000oooo000000;oool0
0`000?ooo`00000Joooo00<0003oool000000_ooo`030000oooo000001Ooool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000005_ooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`000012oooo00<0003oool000007Oooo`070000oooooooooooo0000oooo000001[oool4
000000Coool0003oool0000Ioooo00<0003oool000000_ooo`030000oooo000001[oool00`000?oo
o`000002oooo00<0003oool000006?ooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`00000Eoooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000001koool002Soool0
0`000?ooo`00000Moooo00L0003oooooooooool0003oool000006_ooo`030000oooo000000;oool0
0`000?ooo`00000Ioooo0P0000?oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00005oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Foooo00<0003ooooo
ool00_ooo`070000oooooooooooo0000oooo000004;oool00`000?ooo`00000Moooo00L0003ooooo
ooooool0003oool000006_ooo`030000oooo000000;oool00`000?ooo`00000Ioooo0P0000?oool0
0`000?ooo`00000Koooo00L0003oooooooooool0003oool000006?ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`00000Eoooo00<0003oooooool00_ooo`070000oooooooooooo0000
oooo000001koool002Soool00`000?ooo`00000Loooo00<0003oool000000_ooo`030000oooo0000
01_oool200000_ooo`030000oooo000001Woool00`000?ooooooo`02oooo00<0003oool000006_oo
o`030000oooo000000;oool00`000?ooo`00000Goooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000001Koool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool00000@_oo
o`030000oooo000001coool00`000?ooo`000002oooo00<0003oool000006oooo`800002oooo00<0
003oool000006Oooo`030000oooooooo00;oool00`000?ooo`00000Joooo00<0003oool000000_oo
o`030000oooo000001Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000005Ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Noooo000Yoooo00<0003ooooo
ool07?ooo`030000oooooooo00;oool00`000?ooooooo`0Koooo00D0003oooooooooool000006ooo
o`800003oooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo0P00
00Coool00`000?ooooooo`02oooo00<0003oooooool05?ooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo04;oool00`000?ooooooo`0Loooo00<0003oooooool00_ooo`030000oooooooo
01_oool01@000?ooooooooooo`00000Koooo0P0000?oool00`000?ooooooo`0Joooo00<0003ooooo
ool00_ooo`030000oooooooo01Koool200001?ooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool07Oooo`00ooooooooool/oooo003o
ooooooooobcoool00?oooooooooo;?ooo`00ooooooooool/oooo003oooooooooobcoool002GooooP
0000=?oooml0000Boooo000Uoooo00<0003oooooool00_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Koool00`000?ooooooo`05oooo0P0003Coool01@000?ooooooooooo`000007
oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`80000Boooo000Poooo00<0
003oooooool00_ooo`030000oooooooo0=coool00`000?ooooooo`0/oooo00<0003oooooool00ooo
o`030000oooooooo0=_oool00`000?ooooooo`0@oooo000Ooooo00<0003oool000000oooo`030000
oooooooo0=coool00`000?ooooooo`0[oooo00<0003oool000001?ooo`030000oooooooo0=_oool0
0`000?ooooooo`0@oooo000Ooooo00<0003oool000000oooo`<0003Koooo0P0002goool00`000?oo
o`000004oooo0P000=_oool200004_ooo`007oooo`030000oooo000000?oool00`000?ooooooo`02
oooo0SLg=`03<c<c;Rh^;Rh^008Z:RX00bHV9R<S8b<S8`038B4Q0R8R8P8T92@00bHV9RPX:2PX:003
:BTY0RPX:08U9BD00b0P81XJ6QXJ6P0251@D00<>3Ph92@T92@T00PH61P031@D51PH61PH600892@T0
0`l?3aDE5ADE5@0271`L00<S8b<Y:BTY:BT00Rd];@8_;bl3<30`0Rl_;`03;Rh^;Bd];Bd]008^;Rh0
0c0`<3De=CDe=@02>c/k00=3@d=;Bd];Bd/00U9BDP03FEUIGUiNGUiN00=QHF42GemO0U]KF`03EUIF
D51@D51@009;Bd/00dM7AdA4A4A4A002@d=300=4A4A6ATI6ATH00TQ8B003C4a<Cdm?Cdm?009BDU80
0eADE5IFEUIFEP03F5QH1eUIF@EHF5P5EeMG4EIFEP=GEeL2F5QH0eUIF@9JFUX00eUIFEMGEeMGE`02
E5AD0Tm?C`03BDU9@T92@T92008k>c/00cDe=C0`<30`<002;Bd]00</;2`^;Rh^;Rh00S<c<`03>CTi
@D51@D510099BDT00e1@D5MGEeMGE`02Fe]K00=MGEeLG5aLG5`00UUIF@03EUIFDE5ADE5A009<C4`0
0dQ8B4A4A4A4A002@T9200=1@D50@410@4001D10@08o?cl00cdm?C/k>c/k>`04oooo00<0003ooooo
ool0:oooo`030000oooo000000Coool010000?ooooooooooo`9IFET00eIFEUADE5ADE002E5AD00=G
EeMLG5aLG5`00VATI003L71`OGemOGem00:7QhL00hb<S8R8R8R8R002Ogmo00=eMGE]KFe]KFd00Ve]
K@03LW9bNGUiNGUi009oOgl00hB4Q8J6QXJ6QP03QhN718R8R003QhN7PX:2PX:2009lO7`00gAdM6e]
KFe]K@02IfMW0V=SH`03HV9RI6ATI6AT009ZJVX00gIfMXB4Q8B4Q002T92@00>EUIF@T92@T9000XB4
Q003MWIfKFe]KFe]009]KFd00g=cLgYjNWYjNP02P82000>3Ph>2PX:2PX800WinOP03M7AdI6ATI6AT
009ADE400d92@Slo?clo?`02CDe=00=VIVIoOgmoOgl00Xj>SP03RXZ:NGUiNGUi009SHf<00dm?Cd=3
@d=3@`02?Shn00<o?cm6ATI6ATH00U=CD`03Hf=SM7AdM7Ad009nOWh00gemOGAdM7AdM002JFUY00=P
H61OGemOGel00V=SH`03J6QXJFUYJFUY009TI6@00eaLG5ADE5ADE002DU9B00=IFEUUIFEUIFD00W5a
L@03MgMgM7AdM7Ad009[Jf/00f5QHEaLG5aLG002H61P00=ZJVYdM7AdM7@00WEeM@9XJ6P00eADE492
@T92@P02?3`l00=8B4QQHF5QHF400WYjNP03RHV9QhN7QhN7009gMgL00fATI59BDU9BDP02BDU90dI6
AP99BDT00de=CE5ADE5AD@02EUIF0eUIF@9GEeL00eADE5=CDe=CD`02EUIF00=KFe]QHF5QHF400VIV
IP03J6QXIfMWIfMW009UIFD00f5QHEeMGEeMG@04oooo00<0003oooooool04?ooo`007oooo`030000
oooo000000?oool00`000?ooooooo`02oooo0SLg=`03<c<c;Rh^;Rh^008Z:RX00bHV9R<S8b<S8`03
8B4Q0R8R8P8T92@00bHV9RPX:2PX:003:BTY0RPX:08U9BD00b0P81XJ6QXJ6P0251@D00<>3Ph92@T9
2@T00PH61P031@D51PH61PH600892@T00`l?3aDE5ADE5@0271`L00<S8b<Y:BTY:BT00Rd];@8_;bl3
<30`0Rl_;`03;Rh^;Bd];Bd]008^;Rh00c0`<3De=CDe=@02>c/k00=3@d=;Bd];Bd/00U9BDP03FEUI
GUiNGUiN00=QHF42GemO0U]KF`03EUIFD51@D51@009;Bd/00dM7AdA4A4A4A002@d=300=4A4A6ATI6
ATH00TQ8B003C4a<Cdm?Cdm?009BDU800eADE5IFEUIFEP03F5QH1eUIF@EHF5P5EeMG4EIFEP=GEeL2
F5QH0eUIF@9JFUX00eUIFEMGEeMGE`02E5AD0Tm?C`03BDU9@T92@T92008k>c/00cDe=C0`<30`<002
;Bd]00</;2`^;Rh^;Rh00S<c<`03>CTi@D51@D510099BDT00e1@D5MGEeMGE`02Fe]K00=MGEeLG5aL
G5`00UUIF@03EUIFDE5ADE5A009<C4`00dQ8B4A4A4A4A002@T9200=1@D50@410@4001D10@08o?cl0
0cdm?C/k>c/k>`04oooo00<0003oooooool0:oooo`030000oooo000000Coool010000?oooooooooo
o`9IFET00eIFEUADE5ADE002E5AD00=GEeMLG5aLG5`00VATI003L71`OGemOGem00:7QhL00hb<S8R8
R8R8R002Ogmo00=eMGE]KFe]KFd00Ve]K@03LW9bNGUiNGUi009oOgl00hB4Q8J6QXJ6QP03QhN718R8
R003QhN7PX:2PX:2009lO7`00gAdM6e]KFe]K@02IfMW0V=SH`03HV9RI6ATI6AT009ZJVX00gIfMXB4
Q8B4Q002T92@00>EUIF@T92@T9000XB4Q003MWIfKFe]KFe]009]KFd00g=cLgYjNWYjNP02P82000>3
Ph>2PX:2PX800WinOP03M7AdI6ATI6AT009ADE400d92@Slo?clo?`02CDe=00=VIVIoOgmoOgl00Xj>
SP03RXZ:NGUiNGUi009SHf<00dm?Cd=3@d=3@`02?Shn00<o?cm6ATI6ATH00U=CD`03Hf=SM7AdM7Ad
009nOWh00gemOGAdM7AdM002JFUY00=PH61OGemOGel00V=SH`03J6QXJFUYJFUY009TI6@00eaLG5AD
E5ADE002DU9B00=IFEUUIFEUIFD00W5aL@03MgMgM7AdM7Ad009[Jf/00f5QHEaLG5aLG002H61P00=Z
JVYdM7AdM7@00WEeM@9XJ6P00eADE492@T92@P02?3`l00=8B4QQHF5QHF400WYjNP03RHV9QhN7QhN7
009gMgL00fATI59BDU9BDP02BDU90dI6AP99BDT00de=CE5ADE5AD@02EUIF0eUIF@9GEeL00eADE5=C
De=CD`02EUIF00=KFe]QHF5QHF400VIVIP03J6QXIfMWIfMW009UIFD00f5QHEeMGEeMG@04oooo00<0
003oooooool04?ooo`008?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo0S`l?003>3Ph
=3@d=3@d008`<3000bd];BXZ:RXZ:P02:2PX0bLW9`<X:2P2:BTY0RXZ:P03:BTY9bLW9bLW008S8b<0
0alO7aTI6ATI6@0251@D00<?3`l:2PX:2PX00`P8208:2PX23`l?00<F5QHN7QhN7Qh00RHV9P03;Rh^
=3@d=3@d008i>CT3?3`l0S/k>`8j>SX00cPh>3Hf=SHf=P02=SHf00<h>3Pl?3`l?3`00T92@P03BDU9
DE5ADE5A009IFET00f1PH6EUIFEUI@02JFUY00=ZJVYXJ6QXJ6P00VIVIP03HV9RGUiNGUiN009JFUX0
0eIFEUADE5ADE002De=C00=DE5AFEUIFEUH00UQHF003Fe]KGUiNGUiN009PH6000f9RHV=SHf=SH`03
Hf=S169RHP03HF5QH61PH61P00=PH604HF5Q00=RHV9SHf=SHf<01F=SH`9RHV800f1PH5iNGUiNGP02
Fe]K00=IFEUGEeMGEeL00UEEE@03E5ADEEEEEEEE009FEUH00eQHF5UIFEUIF@02FUYJ00=KFe]IFEUI
FET00UIFEP9ADE400dU9BD51@D51@@02>3Ph00<_;blY:BTY:BT00R@T90038b<S9BDU9BDU008[:b/0
0c<c<cdm?Cdm?@02AdM700=ADE5IFEUIFET00UmOG`=SHf<2HV9R00=OGemKFe]KFe/00UMGE`03De=C
Cdm?Cdm?009<C4`00d];BdU9BDU9B@02BDU900=8B4Q6ATI6ATH00TE5A@03@d=3@410@41000Coool0
0`000?ooooooo`0/oooo00<0003oooooool00oooo`040000oooooooooooo0UMGE`03Cdm?BDU9BDU9
0096ATH00dM7Ada<C4a<C002EEEE00=TI6AeMGEeMGD00XB4Q003S8b<Rh^;Rh^;00:3Ph<00gUiNG5a
LG5aL@02L71`00=dM7AjNWYjNWX00X61P@03QHF5R8R8R8R800:9RHT00hR8R8J6QXJ6QP02PX:200=m
OGeeMGEeMGD00Vi^KP03IfMWHF5QHF5Q009MGEd2Fe]K00=MGEeQHF5QHF400V][J`03O7alT92@T92@
00:QXJ400jRXZ:>SXj>SX`02U9BD00>5QHEnOWinOWh00XF5Q@03U9BDY:BTY:BT00:_[jl00k2`/:RX
Z:RXZ002VYZJ00>6QXI]KFe]KFd00UADE003@410?3`l?3`l009<C4`00fUYJHJ6QXJ6QP02UIFE00>=
SHedM7AdM7@00UIFEP03?Cdm<C4a<C4a008a<C400cLg=d=3@d=3@`02DE5A00=PH61^KVi^KVh00WAd
M003L71`I6ATI6AT009FEUH00dm?Ce=CDe=CD`02H61P00=]KFeeMGEeMGD00W1`L003I6ATF5QHF5QH
009BDU800eUIFFMWIfMWI`02MGEe00=kNg]fMWIfMWH00VQXJ003FEUID51@D51@009BDU800e]KFfAT
I6ATI002IfMW0UmOG`03DE5AA4A4A4A40091@D400da<C61PH61PH002M7Ad00>2PX:4Q8B4Q8@00Wal
O003Kfm_HF5QHF5Q009EEED00da<C4E5ADE5A@02@T9200=6ATI>CTi>CTh00UMGE`03GEeMGemOGemO
009LG5`00eQHF5ADE5ADE003De=C0UEEE@9HF5P00eaLG61PH61PH003Hf=S0UiNGPCoool00`000?oo
ooooo`0@oooo000Uoooo00<0003oooooool00_ooo`93@d<00clo?c/k>c/k>`02=cLg00<d=3@a<C4a
<C400Rl_;`03;Bd];2`/;2`/00</;2`4:b/[00<Y:BTW9bLW9bL00R<S8`037alO6QXJ6QXJ008E5AD0
0a4A4@h>3Ph>3P023@d=00<>3PhB4Q8B4Q800QTI6@038B4Q:RXZ:RXZ008d=3@00c`l?4A4A4A4A002
BDU90da<C09;Bd/2BDU900=6ATI4A4A4A4@00T=3@`03A4A4AdM7AdM7009<C4`00e=CDe]KFe]KF`02
HV9R00=YJFU_Kfm_Kfl00W=cL`=eMGD2M7Ad00=aLG5^KVi^KVh00Va/K003JFUYJ6QXJ6QX009XJ6P0
0fUYJFYZJVYZJP02K6a/00=_KfmaLG5aLG400W9bLP=cLg<2LW9b00=aLG5_Kfm_Kfl00Vi^KP=/K6`2
Jf][00=/K6a]KFe]KFd00Vm_K`03LG5aLW9bLW9b00=dM7@2Lg=c0W5aL@03KFe]JFUYJFUY009TI6@0
0emOGeYJFUYJFP02EeMG0eEEE@9FEUH00eUIFE]KFe]KF`02GUiN0emOG`9KFe/2EEEE00=<C4a2@T92
@T800SLg=`03;Bd]92@T92@T008O7al00adM7AlO7alO7`029RHV00<`<30l?3`l?3`00TQ8B003E5AD
GemOGemO009WIfL00fa/K6i^KVi^KP02KVi^00=/K6aYJFUYJFT00VEUI@03HF5QGUiNGUiN009KFe/0
0eQHF5IFEUIFEP02E5AD00=BDU9@D51@D5000Te=C@03BTY:AdM7AdM700Coool00`000?ooooooo`0b
oooo00@0003oooooooooool2Fe]K00=@D517AdM7AdL00T92@P03@D51A4A4A4A4009=CDd00eaLG6i^
KVi^KP02Ogmo00>9RHV:RXZ:RXX00X>3P`03NWYjLg=cLg=c009aLG400g=cLgQhN7QhN002O7al00>0
P822PX:2PX800X>3P`03PX:2OGemOGem009gMgL00fm_KfMWIfMWI`02H61P00=KFe]HF5QHF5P00UQH
F09IFET00eeMGFATI6ATI002Kfm_00=oOgnATI6ATI400Z6QX@03YjNWXZ:RXZ:R00:EUID00hR8R8F5
QHF5Q@02T92@00>TY:Bh^;Rh^;P00lG5a@:j^[X2ZJVY00>BTY9fMWIfMWH00UaLG003AdM7@T92@T92
009BDU800fm_Khb<S8b<S002VYZJ00>>SXiaLG5aLG400U1@D003=CDe;2`/;2`/008`<3000cXj>TM7
AdM7A`02E5AD00=OGemXJ6QXJ6P00V][J`03I6ATEeMGEeMG009:BTX00dE5ADe=CDe=C@02GemO00=b
LW9lO7alO7`00WUiN@03Jf][GEeMGEeM009EEED00eUIFFEUIFEUI@02LW9b00=gMgM`L71`L7000V5Q
H@03DE5AAdM7AdM70097AdL00dm?CeQHF5QHF002GEeM0UYJFP03DU9BBd];Bd];0099BDT00e5ADEmO
GemOG`02KFe]00=gMgMlO7alO7`00WYjNP03MGEeKVi^KVi^009TI6@00e]KFe9BDU9BDP02CTi>00=?
CdmEEEEEEED00UaLG003HF5QHf=SHf=S009QHF400eiNGUYJFUYJFP02EUIF00=BDU9@D51@D5000U5A
D@03EeMGH61PH61P009WIfL00fYZJVEUIFEUI@04oooo00<0003oooooool04?ooo`009Oooo`030000
oooooooo00;oool2@d=300<o?clk>c/k>c/00SLg=`03=3@d<C4a<C4a008_;bl00bd];B`/;2`/;003
;2`/12/[:`03:BTY9bLW9bLW008S8b<00alO7aXJ6QXJ6P025ADE00<A4A4>3Ph>3Ph00Pd=3@033Ph>
4Q8B4Q8B008I6AT00b4Q8BXZ:RXZ:P02=3@d00<l?3a4A4A4A4@00TU9B@=<C4`2Bd];0TU9B@03ATI6
A4A4A4A40093@d<00dA4A4M7AdM7A`02C4a<00=CDe=KFe]KFe/00V9RHP03JFUYKfm_Kfm_009cLg<3
MGEe0WAdM003LG5aKVi^KVi^009/K6`00fUYJFQXJ6QXJ002J6QX00=YJFUZJVYZJVX00Va/K003Kfm_
LG5aLG5a009bLW83Lg=c0W9bLP03LG5aKfm_Kfm_009^KVh3K6a/0V][J`03K6a/KFe]KFe]009_Kfl0
0g5aLG9bLW9bLP03M7Ad0W=cL`9aLG400fe]KFUYJFUYJ@02I6AT00=OGemJFUYJFUX00UMGE`=EEED2
EUIF00=IFEUKFe]KFe/00UiNGP=OGel2Fe]K0UEEE@03C4a<@T92@T92008g=cL00bd];B@T92@T9002
7alO00<M7AdO7alO7al00RHV9P03<30`?3`l?3`l0098B4P00eADE5mOGemOG`02IfMW00=/K6a^KVi^
KVh00Vi^KP03K6a/JFUYJFUY009UIFD00f5QHEiNGUiNGP02Fe]K00=HF5QFEUIFEUH00UADE003DU9B
D51@D51@009=CDd00dY:BTM7AdM7A`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0U]K
F`03D51@AdM7AdM70092@T800d51@DA4A4A4A002CDe=00=LG5a^KVi^KVh00WmoO`03RHV9RXZ:RXZ:
00:3Ph<00gYjNW=cLg=cL`02LG5a00=cLg=hN7QhN7P00WalO003P820PX:2PX:200:3Ph<00h:2PWem
OGemO@02MgMg00=_KfmWIfMWIfL00V1PH003Fe]KF5QHF5QH009HF5P2FEUI00=MGEeTI6ATI6@00Vm_
K`03OgmoTI6ATI6A00:QXJ400jNWYj:RXZ:RXP02UIFE00>8R8R5QHF5QHD00Y2@T003Y:BT^;Rh^;Rh
00?5aLD2^[Zj0ZVYZ@03TY:BMWIfMWIf009LG5`00dM7Ad92@T92@P02DU9B00=_Kfn<S8b<S8`00YZJ
VP03SXj>LG5aLG5a009@D5000cDe=B`/;2`/;002<30`00<j>SY7AdM7AdL00UADE003GemOJ6QXJ6QX
009[Jf/00fATI5MGEeMGE`02BTY:00=5ADE=CDe=CDd00UmOG`03LW9bO7alO7al009iNGT00f][JeeM
GEeMG@02EEEE00=IFEUUIFEUIFD00W9bLP03MgMgL71`L71`009QHF400e5ADDM7AdM7A`02AdM700=?
CdmHF5QHF5P00UeMG@9JFUX00e9BDT];Bd];B`02BDU900=ADE5OGemOGel00Ve]K@03MgMgO7alO7al
009jNWX00gEeMFi^KVi^KP02I6AT00=KFe]BDU9BDU800Ti>CP03Cdm?EEEEEEEE009LG5`00f5QHF=S
Hf=SH`02HF5Q00=NGUiJFUYJFUX00UIFEP03DU9BD51@D51@009ADE400eMGEf1PH61PH002IfMW00=Z
JVYUIFEUIFD01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0T];B`03AdM7
@d=3@d=3008o?cl00c`l?3Ti>CTi>@02=SHf00<d=3@b<S8b<S800S4a<@03<30`;Rh^;Rh^008];Bd0
0b/[:bTY:BTY:@029BDU00<Q8B4M7AdM7Ad00QTI6@035QHF51@D51@D008D51@00aLG5adM7AdM7@02
92@T00<^;Rhi>CTi>CT00T=3@`03CDe=EUIFEUIF009KFe/2GUiN00=OGemMGEeMGEd00UYJFP03EeMG
E5ADE5AD00=BDU82E5AD0UUIF@03GemOIVIVIVIV009]KFd00gAdM7YjNWYjNP02Ogmo00>2PX:3Ph>3
Ph<00X>3P`03PX:2PH61PH6100:0P8000gmoOginOWinOP02OWin00=oOgn1PH61PH400X:2PP03Q8B4
QHF5QHF500>6QXH2QHF50X>3P`03PH61OWinOWin009lO7`00gYjNWUiNGUiN@02NGUi00=jNWYlO7al
O7`00WinOP03PH61Q8B4Q8B400>6QXH2QHF50X61P@03O7alMGEeMGEe009^KVh00fIVIUmOGemOG`02
FUYJ00=GEeMFEUIFEUH00UQHF003Fe]KGemOGemO009SHf<3IVIV0V=SH`9LG5`00e9BDTI6ATI6AP02
>CTi00<];BdS8b<S8b<00Q`L70036QXJ7AdM7AdM008T92@00bl_;cdm?Cdm?@02Bd];00=IFEUVIVIV
IVH00W1`L003MgMgNg]kNg]k009lO7`00g]kNgQhN7QhN002MGEe00=bLW9^KVi^KVh00V][J`03J6QX
IFEUIFEU009RHV800eiNGU]KFe]KF`02EeMG00=CDe=?Cdm?Cdl01?ooo`030000oooooooo03;oool0
10000?ooooooooooo`9YJFT00eeMGE=CDe=CD`02C4a<00=9BDU:BTY:BTX00U1@D003G5aLJf][Jf][
009iNGT00h>3PhB4Q8B4Q002P82000=hN7QbLW9bLW800fm_K`9`L702LG5a00=cLg=dM7AdM7@00W=c
L`03LG5aKFe]KFe]009WIfL00f1PH5YJFUYJFP02EUIF00=EEEEFEUIFEUH00UUIF@9OGel00fIVIVe]
KFe]K@02MGEe00=mOGf4Q8B4Q8@00hV9R@:5QHD2Ogmo00=jNWYkNg]kNg/00XJ6QP03UiNGYjNWYjNW
00:a/K400k>c/jj^[Zj^[P02Xj>S00>BTY9nOWinOWh00VUYJ@03F5QHE5ADE5AD009QHF400gUiNI2@
T92@T002VYZJ00>=SHebLW9bLW800U=CD`03?3`l=SHf=SHf008l?3`00dQ8B5ADE5ADE002GEeM00=R
HV9TI6ATI6@00V=SH`03G5aLDU9BDU9B0099BDT00dM7Ae1@D51@D002HF5Q00=bLW9lO7alO7`00WYj
NP03KVi^HF5QHF5Q009HF5P00eUIFEmOGemOG`02IVIV00=XJ6QQHF5QHF400UADE003AdM7@410@410
0092@T800dU9BE=CDe=CD`02FEUI0UYJFP03F5QHEEEEEEEE009DE5@00eMGEeeMGEeMG@02Hf=S00=Y
JFU]KFe]KFd00W1`L003LW9bLg=cLg=c00=cLg<2LW9b0W1`L003K6a/JFUYJFUY009UIFD3Hf=S0VEU
I@03IVIVIFEUIFEU009QHF400eYJFUEEEEEEE@02EEEE00=LG5aWIfMWIfL00W5aL@03MWIfLg=cLg=c
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9;Bd/00dM7Ad=3@d=3@`02
?clo00<l?3`i>CTi>CT00SHf=P03=3@d<S8b<S8b008a<C400c0`<2h^;Rh^;P02;Bd]00<[:b/Y:BTY
:BT00RDU9@038B4Q7AdM7AdM008I6AT00aHF5Q@D51@D500251@D00<G5aLM7AdM7Ad00R@T9003;Rh^
>CTi>CTi0093@d<00de=CEIFEUIFEP02Fe]K0UiNGP03GemOGEeMGEeM009JFUX00eMGEeADE5ADE003
DU9B0UADE09IFET00emOGfIVIVIVIP02KFe]00=dM7AjNWYjNWX00WmoO`03PX:2Ph>3Ph>300:3Ph<0
0h:2PX61PH61P@02P82000=oOgmnOWinOWh00WinOP03OgmoPH61PH6100:2PX800hB4Q8F5QHF5Q@03
QXJ60XF5Q@:3Ph<00h61PGinOWinOP02O7al00=jNWYiNGUiNGT00WUiN@03NWYjO7alO7al009nOWh0
0h61PHB4Q8B4Q003QXJ60XF5Q@:1PH400galO7EeMGEeM@02KVi^00=VIVIOGemOGel00UYJFP03EeMG
EUIFEUIF009HF5P00e]KFemOGemOG`02Hf=S0fIVIP9SHf<2G5aL00=BDU96ATI6ATH00STi>@03;Bd]
8b<S8b<S008L71`00aXJ6QdM7AdM7@0292@T00<_;blm?Cdm?Cd00T];B`03FEUIIVIVIVIV009`L700
0gMgMg]kNg]kN`02O7al00=kNg]hN7QhN7P00WEeM@03LW9bKVi^KVi^009[Jf/00fQXJ6EUIFEUI@02
HV9R00=NGUiKFe]KFe/00UMGE`03De=CCdm?Cdm?00Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2JFUY00=MGEeCDe=CDe<00Ta<C003BDU9BTY:BTY:009@D5000eaLG6][Jf][J`02NGUi00>3
Ph>4Q8B4Q8@00X20P003N7QhLW9bLW9b00=_Kfl2L71`0W5aL@03Lg=cM7AdM7Ad009cLg<00g5aLFe]
KFe]K@02IfMW00=PH61JFUYJFUX00UIFEP03EEEEEUIFEUIF009IFET2GemO00=VIVI]KFe]KFd00WEe
M@03OGemQ8B4Q8B400>9RHT2QHF50WmoO`03NWYjNg]kNg]k00:6QXH00iNGUjNWYjNWY`02/K6a00>c
/k>^[Zj^[Zh00Z>SX`03TY:BOWinOWin009YJFT00eQHF5ADE5ADE002HF5Q00=iNGV@T92@T9000YZJ
VP03SHf=LW9bLW9b009CDe<00c`l?3Hf=SHf=P02?3`l00=8B4QDE5ADE5@00UeMG@03HV9RI6ATI6AT
009SHf<00eaLG59BDU9BDP02BDU900=7AdM@D51@D5000V5QH@03LW9bO7alO7al009jNWX00fi^KV5Q
HF5QH@02F5QH00=IFEUOGemOGel00VIVIP03J6QXHF5QHF5Q009DE5@00dM7Ad10@410@002@T9200=9
BDUCDe=CDe<00UUIF@9JFUX00eQHF5EEEEEEE@02E5AD00=GEeMMGEeMGEd00V=SH`03JFUYKFe]KFe]
009`L7000g9bLW=cLg=cL`03Lg=c0W9bLP9`L7000fa/K6UYJFUYJ@02IFEU0f=SH`9UIFD00fIVIVEU
IFEUI@02HF5Q00=JFUYEEEEEEED00UEEE@03G5aLIfMWIfMW009aLG400gIfMW=cLg=cL`04oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2De=C00=?Cdm:BTY:BTX00TI6AP03@d=3
?clo?clo008m?Cd00cXj>SPh>3Ph>002=SHf00<d=3@c<c<c<c<00S4a<@03;bl_;2`/;2`/008Y:BT0
0bHV9R8R8R8R8P027alO00<M7AdL71`L71`00QhN7P038B4Q:2PX:2PX008b<S800c`l?4Q8B4Q8B002
E5AD00=OGemXJ6QXJ6P00Vi^KP=bLW82L71`0Ve]K@03JFUYIFEUIFEU009SHf<00f9RHVATI6ATI002
IfMW00=]KFecLg=cLg<00WYjNP03P820QXJ6QXJ600:;Rh/00hn?Si6ATI6AT@03Ti>C1iBDU0:EUID0
0iJFUYNGUiNGU`02V9RH1IVIV@03V9RHUYJFUYJF00:CTi<00i6ATHj>SXj>SP02Rh^;00>8R8R7QhN7
QhL00XN7Q`03R8R8Rh^;Rh^;00:>SXh00i:BTYFEUIFEU@03V9RH0YJFUP:BTY800h^;Rh:2PX:2PP02
N7Qh00=^KViUIFEUIFD00UiNGP03FUYJFEUIFEUI009KFe/00emOGfATI6ATI002JFUY00=]KFe^KVi^
KVh00V][J`9TI6@00eUIFDa<C4a<C002?Shn00<`<30U9BDU9BD00QdM7@036QXJ7AdM7AdM008V9RH0
0c8b<T10@410@002D51@00=PH61^KVi^KVh00WYjNP03PX:2QhN7QhN700>9RHT2R8R80XF5Q@03PX:2
OWinOWin009kNg/00gMgMg=cLg=cL`02Kfm_00=[Jf]VIVIVIVH00V9RHP03GEeMF5QHF5QH00Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2Ng]k00=`L71VIVIVIVH00UiNGP03FUYJFEUIFEUI
009KFe/00f9RHV][Jf][J`02M7Ad00=jNWYlO7alO7`00WUiN@03M7AdKfm_Kfm_009[Jf/00fQXJ6EU
IFEUI@02I6AT00=RHV9QHF5QHF400V1PH003GEeMFUYJFUYJ009EEED00e9BDU1@D51@D002DE5A00=D
E5AIFEUIFET00V1PH09YJFT00g=cLgYjNWYjNP02O7al00=gMgM]KFe]KFd00V9RHP03FUYJF5QHF5QH
009KFe/00f5QHFUYJFUYJ@02L71`00=fMWIlO7alO7`00X:2PP03QhN7Rh^;Rh^;00:=SHd00hZ:RX:2
PX:2PP02MgMg00=^KVi/K6a/K6`00WEeM@03Q8B4TY:BTY:B00:FUYH00hZ:RWEeMGEeM@02GUiN00=>
CTi;Bd];Bd/00U=CD`03GEeMIVIVIVIV009YJFT00fMWIf=SHf=SH`02GUiN00=HF5QDE5ADE5@00U5A
D@03De=CFUYJFUYJ009UIFD00g1`L7MgMgMgM`02MGEe00=^KViTI6ATI6@00UaLG003F5QHEeMGEeMG
009FEUH00eADE4i>CTi>CP02ATI600=0@40n?Shn?Sh00T92@P03BTY:De=CDe=C009KFe/2H61P0f5Q
H@9PH6000eeMGE]KFe]KF`02FUYJ00=KFe]MGEeMGEd00V5QH@03IfMWLW9bLW9b00:0P8000hn?SiZJ
VYZJVP02WIfM00>DU9B2PX:2PX800Vm_K`03HF5QGemOGemO009VIVH00fi^KW=cLg=cL`02L71`00=X
J6QQHF5QHF400UmOG`03IVIVLW9bLW9b009nOWh00hF5QH>3Ph>3P`04oooo00<0003oooooool04?oo
o`009Oooo`800003oooo0U]KF`03EUIFDE5ADE5A009=CDd00dU9BDE5ADE5A@02@T9200<o?clm?Cdm
?Cd00S/k>`03>CTi>3Ph>3Ph008f=SH00cDe=C<c<c<c<`02<30`00<];BdZ:RXZ:RX00RPX:0<V9RH2
:2PX00<];Bde=CDe=CD00Slo?`03Bd];F5QHF5QH009TI6@00g1`L7YjNWYjNP02PH610XB4Q003QHF5
Ph>3Ph>300:0P8000galO7QhN7QhN002MGEe00=cLg=dM7AdM7@00WMgM`03Ng]kPH61PH6100:7QhL0
0hf=SI>CTi>CT`02V9RH00>LW9bOWinOWil00Z:RXP03Y:BTYJFUYJFU00:WYjL00jRXZ:VYZJVYZ@03
ZZZZ1j^[Z`:ZZZX00jRXZ:FUYJFUY@02Xj>S00>OWinLW9bLW9`00YVIV@03UiNGUYJFUYJF00:FUYH0
0iNGUiZJVYZJVP02WYjN00>RXZ:VYZJVYZH00jRXZ0:VYZH2X:2P00>HV9R>SXj>SXh00X:2PP03MWIf
K6a/K6a/009TI6@00emOGeiNGUiNGP02H61P00=UIFE[Jf][Jf/00W1`L003MGEeMWIfMWIf009dM7@2
KFe]00=QHF5DE5ADE5@00TE5A@03=cLg:b/[:b/[008R8R800alO7b8R8R8R8P02:RXZ00<g=cM6ATI6
ATH00UMGE`03IfMWMWIfMWIf00:3Ph<00hb<S9:BTY:BTP02UIFE00>FUYJEUIFEUID00Y>CT`03T92@
SHf=SHf=00:9RHT00hF5QH61PH61P@02O7al00=gMgMbLW9bLW800Va/K003IVIVHF5QHF5Q00?oool2
0000=?ooo`040000oooooooooooo0XZ:RP03PH61N7QhN7Qh009aLG400fa/K6UYJFUYJ@02J6QX00=Z
JVY^KVi^KVh00W9bLP03MGEeM7AdM7Ad009bLW800fi^KVUYJFUYJ@02I6AT00=OGemKFe]KFe/00UMG
E`03E5ADDE5ADE5A009?Cdl00de=CD];Bd];B`02BDU900=8B4Q:BTY:BTX00Tm?C`03EUIFGUiNGUiN
009YJFT2MGEe00>0P826QXJ6QXH00X61P@03L71`EUIFEUIF008m?Cd00bd];Bh^;Rh^;P02>SXj00=;
Bd]GEeMGEeL00UUIF@03De=CCTi>CTi>009=CDd00eIFEVATI6ATI002Lg=c00=oOgn4Q8B4Q8@00XB4
Q0>2PX82QXJ600><S8b?Shn?Shl00Xj>SP03QHF5N7QhN7Qh009[Jf/00fATI6EUIFEUI@02K6a/00=d
M7AhN7QhN7P00WEeM@03KFe]Hf=SHf=S009LG5`00eUIFEYJFUYJFP02GUiN00=RHV9WIfMWIfL00Va/
K003Kfm_LG5aLG5a009`L7000fe]KFMWIfMWI`02H61P00=IFEUADE5ADE400T];B`03ADE5@D51@D51
008o?cl00d10@4=3@d=3@`02BDU900=@D51GEeMGEeL00UmOG`9WIfL00fe]KFm_Kfm_K`02KVi^00=W
IfMNGUiNGUh00UIFEP03D51@CTi>CTi>009BDU800eYJFVa/K6a/K002QhN700>VYZJo_kno_kl00/O7
a`03^;RhVIVIVIVI009fMWH00eiNGUYJFUYJFP02IVIV00=fMWJ2PX:2PX800X61P@03N7QhKfm_Kfm_
009/K6`00g9bLWinOWinOP02RXZ:00>BTY:ATI6ATI400oooo`80000Boooo000Uoooo00<0003ooooo
ool00_ooo`9KFe/00eIFEU5ADE5AD@02CDe=00=9BDU5ADE5ADD00T92@P03?clo?Cdm?Cdm008k>c/0
0cTi>CPh>3Ph>002=SHf00<e=CDc<c<c<c<00S0`<003;Bd]:RXZ:RXZ008X:2P39RHV0RPX:003;Bd]
=CDe=CDe008o?cl00d];BeQHF5QHF002I6AT00=`L71jNWYjNWX00X61P@:4Q8@00hF5QH>3Ph>3P`02
P82000=lO7ahN7QhN7P00WEeM@03Lg=cM7AdM7Ad009gMgL00g]kNh61PH61P@02QhN700>=SHfCTi>C
Ti<00YRHV003W9bLWinOWinO00:RXZ800jBTY:FUYJFUY@02YjNW00>XZ:RYZJVYZJT00jZZZPN[Zj/2
ZZZZ00>XZ:RUYJFUYJD00Z>SX`03WinOW9bLW9bL00:IVIT00iNGUiJFUYJFUP02UYJF00>GUiNJVYZJ
VYX00YjNWP03XZ:RYZJVYZJV00>XZ:P2YZJV0Z2PX003V9RHSXj>SXj>00:2PX800gIfMVa/K6a/K002
I6AT00=OGemNGUiNGUh00V1PH003IFEUJf][Jf][009`L7000gEeMGIfMWIfMP02M7Ad0Ve]K@03HF5Q
E5ADE5AD0095ADD00cLg=b/[:b/[:`028R8R00<O7alR8R8R8R800RXZ:P03=cLgATI6ATI6009GEeL0
0fMWIgIfMWIfMP02Ph>300><S8bBTY:BTY800YFEU@03UYJFUIFEUIFE00:CTi<00i2@T8f=SHf=S@02
RHV900>5QHF1PH61PH400WalO003MgMgLW9bLW9b009/K6`00fIVIV5QHF5QH@04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0XZ:RP03PH61N7QhN7Qh009aLG400fa/K6UYJFUYJ@02J6QX00=Z
JVY^KVi^KVh00W9bLP03MGEeM7AdM7Ad009bLW800fi^KVUYJFUYJ@02I6AT00=OGemKFe]KFe/00UMG
E`03E5ADDE5ADE5A009?Cdl00de=CD];Bd];B`02BDU900=8B4Q:BTY:BTX00Tm?C`03EUIFGUiNGUiN
009YJFT2MGEe00>0P826QXJ6QXH00X61P@03L71`EUIFEUIF008m?Cd00bd];Bh^;Rh^;P02>SXj00=;
Bd]GEeMGEeL00UUIF@03De=CCTi>CTi>009=CDd00eIFEVATI6ATI002Lg=c00=oOgn4Q8B4Q8@00XB4
Q0>2PX82QXJ600><S8b?Shn?Shl00Xj>SP03QHF5N7QhN7Qh009[Jf/00fATI6EUIFEUI@02K6a/00=d
M7AhN7QhN7P00WEeM@03KFe]Hf=SHf=S009LG5`00eUIFEYJFUYJFP02GUiN00=RHV9WIfMWIfL00Va/
K003Kfm_LG5aLG5a009`L7000fe]KFMWIfMWI`02H61P00=IFEUADE5ADE400T];B`03ADE5@D51@D51
008o?cl00d10@4=3@d=3@`02BDU900=@D51GEeMGEeL00UmOG`9WIfL00fe]KFm_Kfm_K`02KVi^00=W
IfMNGUiNGUh00UIFEP03D51@CTi>CTi>009BDU800eYJFVa/K6a/K002QhN700>VYZJo_kno_kl00/O7
a`03^;RhVIVIVIVI009fMWH00eiNGUYJFUYJFP02IVIV00=fMWJ2PX:2PX800X61P@03N7QhKfm_Kfm_
009/K6`00g9bLWinOWinOP02RXZ:00>BTY:ATI6ATI401?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0V=SH`03GEeMEeMGEeMG009BDU800de=CDU9BDU9B@02ADE500=3@d=1@D51
@D400Slo?`Dn?Sh00cdm?C`l?3`l?002>SXj00<g=cLd=3@d=3@00S8b<P<a<C42=3@d00<i>CU1@D51
@D400Ta<C003FEUIIVIVIVIV009dM7@00h20P8Z:RXZ:RP02TY:B0iJFUP:EUID2TY:B00>>SXj:RXZ:
RXX00XN7Q`>5QHD2QhN700>;Rh^?Shn?Shl00YBDU003VIVIWYjNWYjN00:SXj<00jRXZ:b/[:b/[002
[jn_00>b/[:d];Bd];@00[Ng]`03^;Rh^[Zj^[Zj00Fk^k/2^[Zj00>i^KVh^;Rh^;P00[Jf]P03];Bd
/K6a/K6a00:_[jl00jb/[:VYZJVYZ@02YZJV00>TY:BSXj>SXj<00ZBTY003YJFUZ:RXZ:RX00:/[:`0
0k2`/;>c/k>c/`03]KFe0[:b/P:[Zj/00j:RXYNGUiNGU`02RXZ:00=nOWicLg=cLg<00VYZJP03I6AT
Hf=SHf=S009VIVH00fYZJW5aLG5aL@02MgMg00=lO7anOWinOWh00WalO09fMWH00f][JeeMGEeMG@02
CTi>00=0@40d=3@d=3@00R`/;003:2PX:b/[:b/[008c<c<00clo?di>CTi>CP02GUiN00=^KVimOGem
OGd00XZ:RP03Ti>CVYZJVYZJ00:MWId3WYjN0YfMW@03VYZJUiNGUiNG00:DU9@00i2@T8b<S8b<S002
QhN700>2PX9lO7alO7`00WIfMP03L71`JFUYJFUY00Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2Shn?00>6QXInOWinOWh00WUiN@03MWIfM7AdM7Ad009dM7@00gIfMWQhN7QhN002NWYj00=i
NGUdM7AdM7@00Ve]K@03I6ATGEeMGEeM009GEeL00eADE55ADE5AD@02D51@00=?Cdm>CTi>CTh00Ti>
CP03CDe=BTY:BTY:00=9BDT2C4a<0U9BDP03G5aLIVIVIVIV009bLW82OWin00>8R8R<S8b<S8`00X>3
P`03Jf][BTY:BTY:008Z:RX00aLG5a/K6a/K6`02;Bd]00=3@d=ADE5ADE400Ti>CP03?clo<30`<30`
008Z:RX00c<c<dQ8B4Q8B002H61P00=eMGF2PX:2PX800XR8R0F;Rh/00hZ:RXN7QhN7Q`02PX:200=m
OGeiNGUiNGT00WEeM@03MWIfNWYjNWYj00:0P803QXJ60WmoO`03Lg=cIfMWIfMW009PH6000emOGfAT
I6ATI002Jf][00=aLG5dM7AdM7@00W=cL`03LW9bL71`L71`009^KVh00fa/K6UYJFUYJ@02I6AT00=M
GEeEEEEEEED00Ti>CP03BDU9B4Q8B4Q8009:BTX00dm?Ce=CDe=CD`02EUIF00=IFEUMGEeMGEd00V=S
H`9]KFd00gQhN7moOgmoO`02P82000=gMgMZJVYZJVX00U]KF`03Cdm?B4Q8B4Q80097AdL00di>CV9R
HV9RHP02QHF500>][Jg@d=3@d=000]cLg003bLW9X:2PX:2P009cLg<00eEEEE9BDU9BDP02IFEU00=n
OWj@T92@T9000Y6AT@03QhN7Ng]kNg]k009eMGD00gUiNHF5QHF5Q@02T92@00>GUiNEUIFEUID01?oo
o`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0V=SH`03GEeMEeMGEeMG009BDU80
0de=CDU9BDU9B@02ADE500=3@d=1@D51@D400Slo?`Dn?Sh00cdm?C`l?3`l?002>SXj00<g=cLd=3@d
=3@00S8b<P<a<C42=3@d00<i>CU1@D51@D400Ta<C003FEUIIVIVIVIV009dM7@00h20P8Z:RXZ:RP02
TY:B0iJFUP:EUID2TY:B00>>SXj:RXZ:RXX00XN7Q`>5QHD2QhN700>;Rh^?Shn?Shl00YBDU003VIVI
WYjNWYjN00:SXj<00jRXZ:b/[:b/[002[jn_00>b/[:d];Bd];@00[Ng]`03^;Rh^[Zj^[Zj00Fk^k/2
^[Zj00>i^KVh^;Rh^;P00[Jf]P03];Bd/K6a/K6a00:_[jl00jb/[:VYZJVYZ@02YZJV00>TY:BSXj>S
Xj<00ZBTY003YJFUZ:RXZ:RX00:/[:`00k2`/;>c/k>c/`03]KFe0[:b/P:[Zj/00j:RXYNGUiNGU`02
RXZ:00=nOWicLg=cLg<00VYZJP03I6ATHf=SHf=S009VIVH00fYZJW5aLG5aL@02MgMg00=lO7anOWin
OWh00WalO09fMWH00f][JeeMGEeMG@02CTi>00=0@40d=3@d=3@00R`/;003:2PX:b/[:b/[008c<c<0
0clo?di>CTi>CP02GUiN00=^KVimOGemOGd00XZ:RP03Ti>CVYZJVYZJ00:MWId3WYjN0YfMW@03VYZJ
UiNGUiNG00:DU9@00i2@T8b<S8b<S002QhN700>2PX9lO7alO7`00WIfMP03L71`JFUYJFUY00Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2Shn?00>6QXInOWinOWh00WUiN@03MWIfM7AdM7Ad
009dM7@00gIfMWQhN7QhN002NWYj00=iNGUdM7AdM7@00Ve]K@03I6ATGEeMGEeM009GEeL00eADE55A
DE5AD@02D51@00=?Cdm>CTi>CTh00Ti>CP03CDe=BTY:BTY:00=9BDT2C4a<0U9BDP03G5aLIVIVIVIV
009bLW82OWin00>8R8R<S8b<S8`00X>3P`03Jf][BTY:BTY:008Z:RX00aLG5a/K6a/K6`02;Bd]00=3
@d=ADE5ADE400Ti>CP03?clo<30`<30`008Z:RX00c<c<dQ8B4Q8B002H61P00=eMGF2PX:2PX800XR8
R0F;Rh/00hZ:RXN7QhN7Q`02PX:200=mOGeiNGUiNGT00WEeM@03MWIfNWYjNWYj00:0P803QXJ60Wmo
O`03Lg=cIfMWIfMW009PH6000emOGfATI6ATI002Jf][00=aLG5dM7AdM7@00W=cL`03LW9bL71`L71`
009^KVh00fa/K6UYJFUYJ@02I6AT00=MGEeEEEEEEED00Ti>CP03BDU9B4Q8B4Q8009:BTX00dm?Ce=C
De=CD`02EUIF00=IFEUMGEeMGEd00V=SH`9]KFd00gQhN7moOgmoO`02P82000=gMgMZJVYZJVX00U]K
F`03Cdm?B4Q8B4Q80097AdL00di>CV9RHV9RHP02QHF500>][Jg@d=3@d=000]cLg003bLW9X:2PX:2P
009cLg<00eEEEE9BDU9BDP02IFEU00=nOWj@T92@T9000Y6AT@03QhN7Ng]kNg]k009eMGD00gUiNHF5
QHF5Q@02T92@00>GUiNEUIFEUID01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02
oooo0VUYJ@03HV9RFe]KFe]K009EEED00dm?CdY:BTY:BP02ATI600=4A4A3@d=3@d<00T=3@`03A4A4
ADE5ADE50097AdL00dQ8B4M7AdM7A`02ATI600=4A4A2@T92@T800Slo?`<n?Sh2@41000=5ADE=CDe=
CDd00UQHF003IFEULg=cLg=c00:0P8000hf=SINGUiNGU`02WinO0ZBTY003YJFUY:BTY:BT00:RXZ80
0ijNWY^KVi^KV`02V9RH0iJFUP:GUiL00iVIVIfMWIfMW@02X:2P00>TY:BYZJVYZJT00Zf][@03/K6a
]KFe]KFe00:i^KT00kfm_L30`<30`002`l?300?5aLG6a/K6a/H00/O7a`03a/K6aLG5aLG500;4a<@0
0l;2`/30`<30`002_[jn00>k^k^i^KVi^KT00[Ng]`03];Bd/k>c/k>c00:a/K400k2`/:n_[jn_[`02
/;2`00>b/[:d];Bd];@00[Ng]`03^[Zj_;bl_;bl00:n_[h00kbl_;Vi^KVi^@02/[:b00>XZ:RMWIfM
WId00Y2@T003Q8B4NGUiNGUi009`L7000fYZJVUYJFUYJ@02K6a/00=aLG5gMgMgMgL00WinOP03Ph>3
QHF5QHF500:4Q8@2OWin00=dM7AWIfMWIfL00UYJFP03CDe=@D51@D51008i>CT00cHf=SPh>3Ph>002
?clo00=:BTYHF5QHF5P00VIVIP03MGEePh>3Ph>300:>SXh00iNGUifMWIfMW@02X:2P0j:RXP:QXJ40
0inOWifMWIfMW@02VYZJ00>GUiNCTi>CTi<00Xn?S`03RXZ:Q8B4Q8B4009nOWh00gQhN71`L71`L004
oooo00<0003oooooool0<_ooo`040000oooooooooooo0X>3P`03NGUiLW9bLW9b009`L7000g9bLWEe
MGEeM@02Ng]k00>3Ph>:RXZ:RXX00Xj>SP03Rh^;OWinOWin009/K6`00eQHF4U9BDU9B@02@d=300=5
ADE;Bd];Bd/00U9BDP03F5QHGEeMGEeM009QHF400f9RHUmOGemOG`02FUYJ00=FEUIEEEEEEED00U]K
F`03I6ATKVi^KVi^009iNGT2Ph>300>9RHV:RXZ:RXX00X20P003Jf][Cdm?Cdm?008d=3@00bHV9R`/
;2`/;002@41000=EEEEPH61PH6000UUIF@03ADE5<30`<30`008V9RH00bh^;T92@T92@P02FUYJ00=_
KfmlO7alO7`00X61P@03PX:2PH61PH61009nOWh00g]kNgMgMgMgM`03M7Ad0WEeM@9iNGT00ginOXB4
Q8B4Q002RHV900><S8b;Rh^;Rh/00XB4Q003NWYjL71`L71`00=ZJVX2Kfm_0WEeM@03Ng]kOGemOGem
009lO7`00gYjNWMgMgMgM`02Lg=c00=_Kfm[Jf][Jf/00VQXJ003IVIVIFEUIFEU009UIFD00fIVIVUY
JFUYJ@02K6a/0fm_K`9[Jf/00fIVIV9RHV9RHP02I6AT0W5aL@03PH61T92@T92@00:FUYH00i2@T820
P820P002KVi^00=LG5a=CDe=CDd00dE5A@9DE5@2MGEe00>OWio3`l?3`l<00]7Ad@03_;blTI6ATI6A
009RHV800dE5ADQ8B4Q8B002HV9R00>3Ph>KVi^KVi/00YjNWP03TI6AP820P820009fMWH00gQhN8:2
PX:2PP02Rh^;00>@T92<S8b<S8`01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02
oooo0Vi^KP03IVIVGEeMGEeM009EEED00dm?CdU9BDU9B@02ATI600=4A4A5ADE5ADD00TM7A`03BTY:
CTi>CTi>009ADE400eADE5EEEEEEE@02EEEE00=CDe=ADE5ADE400Ti>CP03C4a<Bd];Bd];009<C4`0
0e5ADEQHF5QHF002Hf=S00=_KfmmOGemOGd00XZ:RP03UiNGXZ:RXZ:R00:ZZZX2[jn_00>b/[:a/K6a
/K400[2`/003[Jf]Zj^[Zj^[00:XZ:P00jJVYZFUYJFUY@02YZJV00>WYjNYZJVYZJT00Z^[Z`03[Zj^
/K6a/K6a00:e]KD00kRh^;bl_;bl_002`<3000?4a<C7alO7alL00/[:bP03cLg=c/k>c/k>00;>c/h0
0lg=cL_;bl_;b`02b<S800?6a/K3`l?3`l<00/30`003_Kfm_;bl_;bl00>j^[X7^KVi0[Zj^P03_;bl
_[jn_[jn00;0`<000l71`L;2`/;2`P02`/;200?0`<2k^k^k^k/00[Bd]003ZZZZWinOWinO00:DU9@0
0hR8R7inOWinOP02MWIf00=aLG5`L71`L7000W9bLP03MgMgOGemOGem00:3Ph<00hR8R8^;Rh^;R`02
RXZ:0XJ6QP03OGemLg=cLg=c009WIfL00e]KFe5ADE5AD@02BTY:00=7AdM8B4Q8B4P00Ti>CP03EeMG
HV9RHV9R009_Kfl00g]kNhJ6QXJ6QP02T92@00>HV9RMWIfMWId00YnOW`>QXJ42X:2P00>OWinMWIfM
WId00Y^KV`03VIVIUYJFUYJF00:CTi<00hn?ShZ:RXZ:RP02QHF500=nOWifMWIfMWH01?ooo`030000
oooooooo03;oool010000?ooooooooooo`9]KFd00f5QHEYJFUYJFP02Fe]K00=SHf=^KVi^KVh00Wem
O@03Shn?WinOWinO00:XZ:P00jBTY8j>SXj>SP02KVi^00=<C4`d=3@d=3@00Rh^;P03=cLgB4Q8B4Q8
009JFUX00f][JgQhN7QhN002PH6100>5QHF0P820P8000WIfMP03K6a/IFEUIFEU009VIVH00fe]KGMg
MgMgM`02Ogmo0h>3P`:1PH42NGUi00=]KFeOGemOGel00U9BDP03Cdm?EeMGEeMG009WIfL00gMgMgal
O7alO002LW9b00=MGEe7AdM7AdL00SXj>P03?ShnCDe=CDe=009OGel00fe]KG=cLg=cL`02LW9b00=^
KViYJFUYJFT00VIVIP03IFEUI6ATI6AT009UIFD00fYZJW1`L71`L002MgMg00=nOWj4Q8B4Q8@00XN7
Q`03RHV9R8R8R8R800:5QHD00h20P7]kNg]kN`02N7Qh00=gMgMiNGUiNGT00WalO003P820Ph>3Ph>3
00>5QHD2PX:20W]kN`03LW9bJVYZJVYZ009YJFT00fm_KgYjNWYjNP02QhN700>BTY:IVIVIVIT00Y^K
V`03VIVITI6ATI6A00:3Ph<00g=cLfIVIVIVIP02I6AT0W5aL@03R8R8WYjNWYjN00:[Zj/00jVYZI^K
Vi^KV`02QhN700=`L71KFe]KFe/00TY:BP03@410ADE5ADE5009MGEd00h20P:6QXJ6QX@02[Jf]00>J
VYYcLg=cLg<00TY:BP03=3@d?Shn?Shn009PH6000hJ6QZ6QXJ6QX@02Y:BT00>DU9B0P820P8000W9b
LP03LG5aNGUiNGUi00:0P8000h:2PWYjNWYjNP04oooo00<0003oooooool04?ooo`009Oooo`030000
oooooooo00;oool2KVi^00=VIVIMGEeMGEd00UEEE@03Cdm?BDU9BDU90096ATH00dA4A4E5ADE5A@02
AdM700=:BTY>CTi>CTh00U5AD@03E5ADEEEEEEEE009EEED00e=CDe5ADE5AD@02CTi>00=<C4a;Bd];
Bd/00Ta<C003DE5AF5QHF5QH009SHf<00fm_KgemOGemO@02RXZ:00>GUiNRXZ:RXZ800ZZZZP:_[jl0
0k:b/[6a/K6a/@02/;2`00>][Jf[Zj^[Zj/00ZRXZ003YZJVYJFUYJFU00:VYZH00jNWYjVYZJVYZ@02
Zj^[00>^[Zja/K6a/K400[Fe]@03^;Rh_;bl_;bl00;0`<000lC4a<O7alO7a`02b/[:00?=cLg>c/k>
c/h00/k>cP03cLg=bl_;bl_;00;8b<P00lK6a/?3`l?3``02`<3000>m_Kfl_;bl_;`00kZj^PNi^KT2
^[Zj00>l_;bn_[jn_[h00/30`003`L71`/;2`/;200;2`/800l30`;^k^k^k^`02];Bd00>ZZZZOWinO
Wil00YBDU003R8R8OWinOWin009fMWH00g5aLG1`L71`L002LW9b00=gMgMmOGemOGd00X>3P`03R8R8
Rh^;Rh^;00::RXX2QXJ600=mOGecLg=cLg<00VMWI`03Fe]KDE5ADE5A009:BTX00dM7AdQ8B4Q8B002
CTi>00=GEeMRHV9RHV800Vm_K`03Ng]kQXJ6QXJ600:@T9000iRHV9fMWIfMW@02WinO0j6QX@:PX:00
0inOWifMWIfMW@02Vi^K00>IVIVFUYJFUYH00Y>CT`03Shn?RXZ:RXZ:00:5QHD00ginOWIfMWIfMP04
oooo00<0003oooooool0<_ooo`040000oooooooooooo0Ve]K@03HF5QFUYJFUYJ009KFe/00f=SHfi^
KVi^KP02OGem00>?ShnOWinOWil00ZRXZ003Y:BTSXj>SXj>009^KVh00da<C3@d=3@d=002;Rh^00<g
=cM8B4Q8B4P00UYJFP03Jf][N7QhN7Qh00:1PH400hF5QH20P820P002MWIf00=/K6aUIFEUIFD00VIV
IP03KFe]MgMgMgMg009oOgl3Ph>30X61P@9iNGT00fe]KEmOGemOG`02DU9B00=?CdmGEeMGEeL00VMW
I`03MgMgO7alO7al009bLW800eeMGDM7AdM7A`02>SXj00<n?Si=CDe=CDd00UmOG`03KFe]Lg=cLg=c
009bLW800fi^KVUYJFUYJ@02IVIV00=UIFETI6ATI6@00VEUI@03JVYZL71`L71`009gMgL00ginOXB4
Q8B4Q002QhN700>9RHV8R8R8R8P00XF5Q@03P820Ng]kNg]k009hN7P00gMgMgUiNGUiN@02O7al00>0
P823Ph>3Ph<00hF5Q@:2PX82Ng]k00=bLW9ZJVYZJVX00VUYJ@03Kfm_NWYjNWYj00:7QhL00i:BTYVI
VIVIV@02Vi^K00>IVIVATI6ATI400X>3P`03Lg=cIVIVIVIV009TI6@2LG5a00>8R8RNWYjNWYh00Z^[
Z`03ZJVYVi^KVi^K00:7QhL00g1`L5]KFe]KF`02BTY:00=0@415ADE5ADD00UeMG@03P820XJ6QXJ6Q
00:][Jd00iZJVW=cLg=cL`02BTY:00<d=3@n?Shn?Sh00V1PH003QXJ6XJ6QXJ6Q00:TY:@00iBDU820
P820P002LW9b00=aLG5iNGUiNGT00X20P003PX:2NWYjNWYj00Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`9aLG400fQXJ5iNGUiNGP02EEEE00==CDe7AdM7AdL00dA4A096ATH2
Bd];00=@D51GEeMGEeL00UeMG@03HV9RIFEUIFEU009UIFD00fATI65QHF5QH@02GEeM00=JFUYHF5QH
F5P00UUIF@03G5aLHf=SHf=S009/K6`00gQhN8F5QHF5Q@02TY:B00>OWinZZZZZZZX00[:b/P:h^;P0
0k^k^kbl_;bl_002_;bl00>j^[Zh^;Rh^;P00[Ng]`03]KFe];Bd];Bd00:c/k<3];Bd0[Fe]@03][Jf
^;Rh^;Rh00:k^k/00kfm_L71`L71`@02aLG500?8b<S<c<c<c<`00/o?c`03dM7Ad];Bd];B00;AdM40
0lo?clc<c<c<c002b<S800?5aLG1`L71`L400[jn_P03_;bl^k^k^k^k00:k^k/00kbl_;fm_Kfm_@02
_kno00?0`<32`/;2`/800/?3``03a<C4aLG5aLG500?5aLD2a<C40/;2`P03_kno^[Zj^[Zj00:b/[80
0jZZZZ2PX:2PX002UYJF00><S8b3Ph>3Ph<00WalO003N7QhMgMgMgMg009iNGT00gemOH>3Ph>3P`02
R8R800>=SHf@T92@T9000Y2@T0:=SHd00hJ6QWinOWinOP02MGEe00=[Jf]SHf=SHf<00UeMG@03FUYJ
Fe]KFe]K009OGel00fIVIVi^KVi^KP02MgMg00>0P829RHV9RHT00Y2@T003UYJFVYZJVYZJ00NLW9`0
0i^KViZJVYZJVP02VIVI00>HV9RFUYJFUYH00YBDU003TY:BSXj>SXj>00:9RHT00h:2PW]kNg]kN`04
oooo00<0003oooooool0<_ooo`040000oooooooooooo0UIFEP03ATI6?clo?clo0093@d<00e5ADFAT
I6ATI002O7al00>GUiN_[jn_[jl00[jn_P03^KViW9bLW9bL009aLG400dE5ABHV9RHV9P028B4Q00<`
<319BDU9BDT00VIVIP03OgmoTi>CTi>C00:QXJ400jJVYZ2PX:2PX002TY:B00>1PH5eMGEeMGD00W9b
LP03MgMgOWinOWin00:2PX82P82000=kNg]eMGEeMGD00W1`L003Kfm_LG5aLG5a009eMGD00galO8J6
QXJ6QP02TI6A00>JVYZIVIVIVIT00Xf=S@03N7QhHf=SHf=S009EEED00eADE5eMGEeMG@02IfMW00=]
KFeZJVYZJVX00V5QH@03EeMGD51@D51@009=CDd00dm?Ce=CDe=CD`02FUYJ00=RHV9ZJVYZJVX00W=c
L`03NWYjOgmoOgmo00:1PH46PX:218>3P`03PX:2PH61PH6100:1PH400h:2PXN7QhN7Q`02SHf=00>@
T92>SXj>SXh00X:2PP03LW9bIVIVIVIV009TI6@00g=cLhf=SHf=S@02Z:RX00>m_Kg7alO7alL00/K6
aP03_[jn[Jf][Jf]00:FUYH00ginOVYZJVYZJP02I6AT0W5aL@03RHV9Y:BTY:BT00:g]kL00kZj^[2`
/;2`/002WYjN00>6QXI/K6a/K6`00U=CD`03?clo>CTi>CTi0096ATH00emOGgQhN7QhN002PX:200=c
Lg=CDe=CDe<00SDe=@03:2PX>3Ph>3Ph009MGEd00hF5QJ2PX:2PX002XZ:R00>BTY9lO7alO7`00Va/
K003JVYZL71`L71`009fMWH00gAdM6QXJ6QXJ004oooo00<0003oooooool04?ooo`009Oooo`800003
oooo0W5aL@03J6QXGUiNGUiN009EEED00de=CDM7AdM7A`03A4A40TI6AP9;Bd/00e1@D5MGEeMGE`02
GEeM00=RHV9UIFEUIFD00VEUI@03I6ATHF5QHF5Q009MGEd00eYJFUQHF5QHF002FEUI00=LG5aSHf=S
Hf<00Va/K003N7QhQHF5QHF500:BTY800inOWjZZZZZZZP02/[:b0[Rh^003^k^k_;bl_;bl00:l_;`0
0kZj^[Rh^;Rh^002]kNg00>e]KFd];Bd];@00[>c/`>d];@2]KFe00>f][Jh^;Rh^;P00[^k^`03_Kfm
`L71`L7100;5aLD00lS8b<c<c<c<c002clo?00?AdM7Bd];Bd]800]7Ad@03clo?c<c<c<c<00;8b<P0
0lG5aL71`L71`@02_[jn00>l_;bk^k^k^k/00[^k^`03_;bl_Kfm_Kfm00:o_kl00l30`<;2`/;2`P02
`l?300?4a<C5aLG5aLD00lG5a@;4a<@2`/;200>o_knj^[Zj^[X00[:b/P03ZZZZX:2PX:2P00:FUYH0
0hb<S8>3Ph>3P`02O7al00=hN7QgMgMgMgL00WUiN@03OGemPh>3Ph>300:8R8P00hf=SI2@T92@T002
T92@0Xf=S@03QXJ6OWinOWin009eMGD00f][Jf=SHf=SH`02GEeM00=JFUYKFe]KFe/00UmOG`03IVIV
KVi^KVi^009gMgL00h20P8V9RHV9R@02T92@00>FUYJJVYZJVYX01ibLW003Vi^KVYZJVYZJ00:IVIT0
0iRHV9JFUYJFUP02U9BD00>BTY:>SXj>SXh00XV9R@03PX:2Ng]kNg]k00?oool20000=?ooo`040000
oooooooooooo0UIFEP03ATI6?clo?clo0093@d<00e5ADFATI6ATI002O7al00>GUiN_[jn_[jl00[jn
_P03^KViW9bLW9bL009aLG400dE5ABHV9RHV9P028B4Q00<`<319BDU9BDT00VIVIP03OgmoTi>CTi>C
00:QXJ400jJVYZ2PX:2PX002TY:B00>1PH5eMGEeMGD00W9bLP03MgMgOWinOWin00:2PX82P82000=k
Ng]eMGEeMGD00W1`L003Kfm_LG5aLG5a009eMGD00galO8J6QXJ6QP02TI6A00>JVYZIVIVIVIT00Xf=
S@03N7QhHf=SHf=S009EEED00eADE5eMGEeMG@02IfMW00=]KFeZJVYZJVX00V5QH@03EeMGD51@D51@
009=CDd00dm?Ce=CDe=CD`02FUYJ00=RHV9ZJVYZJVX00W=cL`03NWYjOgmoOgmo00:1PH46PX:218>3
P`03PX:2PH61PH6100:1PH400h:2PXN7QhN7Q`02SHf=00>@T92>SXj>SXh00X:2PP03LW9bIVIVIVIV
009TI6@00g=cLhf=SHf=S@02Z:RX00>m_Kg7alO7alL00/K6aP03_[jn[Jf][Jf]00:FUYH00ginOVYZ
JVYZJP02I6AT0W5aL@03RHV9Y:BTY:BT00:g]kL00kZj^[2`/;2`/002WYjN00>6QXI/K6a/K6`00U=C
D`03?clo>CTi>CTi0096ATH00emOGgQhN7QhN002PX:200=cLg=CDe=CDe<00SDe=@03:2PX>3Ph>3Ph
009MGEd00hF5QJ2PX:2PX002XZ:R00>BTY9lO7alO7`00Va/K003JVYZL71`L71`009fMWH00gAdM6QX
J6QXJ003oooo0P0001;oool002Goool00`000?ooooooo`02oooo0W=cL`03JFUYGUiNGUiN009CDe<0
0d];BdA4A4A4A002@T9200=3@d=7AdM7AdL00Ti>CP03EeMGH61PH61P009YJFT00g1`L7EeMGEeM@02
MWIf00=eMGEaLG5aLG400Ve]K@03JFUYIVIVIVIV009UIFD00fMWIfa/K6a/K002MGEe00>0P82<S8b<
S8`00YVIV@03YJFU/;2`/;2`00:h^;P2_kno00?3`l?5aLG5aLD00lK6aP;5aLD2a<C400?2`/;1`L71
`L400/30`0>o_kl2_[jn00>m_Kfn_[jn_[h00[no_`03`L71a<C4a<C400;7alL00l[:b/k>c/k>cP02
dM7A0m?Cd`;AdM400lk>c/[:b/[:bP02a/K600?1`L6m_Kfm_Kd00[Zj^P>h^;P2^KVi00>l_;bo_kno
_kl00/?3``03a/K6b<S8b<S800;:b/X3bl_;0/[:bP03alO7aLG5aLG500;1`L400kbl_;Jf][Jf]P02
[jn_00>WYjNOWinOWil00YJFUP03SXj>QhN7QhN700:2PX800gmoOginOWinOP02P82000>4Q8B8R8R8
R8P00Xf=S@03TI6AU9BDU9BD00:EUID2Ti>C00>?Shn9RHV9RHT00X>3P`03O7alMWIfMWIf009aLG43
Kfm_0W5aL@03MGEeNWYjNWYj00:0P8000hJ6QX^;Rh^;R`02T92@00>CTi>EUIFEUID01IJFUP:EUID8
U9BD0Y>CT`03TY:BT92@T92@00:;Rh/00hF5QGemOGemO@04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0TI6AP03<c<c:RXZ:RXZ008`<3000d92@UYJFUYJFP02MgMg00>EUIF^[Zj^[Zh00[jn
_P03^[ZjWinOWinO009dM7@00dU9BB`/;2`/;002:2PX00<i>CUDE5ADE5@00W=cL`03SXj>Xj>SXj>S
00:b/[800kNg]k2`/;2`/002XJ6Q00>?Shn0P820P8000WYjNP03OGemPH61PH6100:2PX82O7al00=a
LG5YJFUYJFT00VMWI`03KVi^Ng]kNg]k00:;Rh/00iVIVJFUYJFUY@02[Jf]00>_[jnZZZZZZZX00YfM
W@03Rh^;N7QhN7Qh009ZJVX00fIVIVUYJFUYJ@03KFe]0VATI09FEUH00dQ8B3hn?Shn?P02?Cdm00=2
@T9;Bd];Bd/00UEEE@03GemOJ6QXJ6QX009`L7000gMgMgYjNWYjNP03NWYj0WUiN@9kNg/00ginOX:2
PX:2PP03QHF50X>3P`:2PX800h>3PhZ:RXZ:RP02TY:B00>HV9RDU9BDU9@00X>3P`03K6a/FUYJFUYJ
009HF5P00fe]KI:BTY:BTP02^;Rh00?Fe]KQhN7QhN400]gMg@03c/k>^;Rh^;Rh00:MWId00h>3Pfm_
Kfm_K`02IVIV0Vm_K`03Q8B4W9bLW9bL00:`/;000kRh^;Bd];Bd]002Z:RX00>DU9AkNg]kNg/00V1P
H003AdM7>CTi>CTi008k>c/00dQ8B5QHF5QHF002GUiN00=EEEE1@D51@D400Rh^;P03:RXZ>c/k>c/k
009KFe/00gemOI>CTi>CT`02UIFE00>9RHUgMgMgMgL00VYZJP03J6QXKVi^KVi^009bLW800fi^KUeM
GEeMG@04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2M7Ad00=YJFUMGEeM
GEd00U9BDP03B4Q8@T92@T92008o?cl00d92@TQ8B4Q8B002DU9B00=MGEeYJFUYJFT00WAdM003OWin
Q8B4Q8B400:6QXH00hF5QH61PH61P@02O7al00=gMgMcLg=cLg<00g5aL@9eMGD2OGem00>7QhNBTY:B
TY800YjNWP03ZZZZ];Bd];Bd00:m_Kd2a<C400?9bLW=cLg=cLd00/o?c`G@d=000lo?clg=cLg=c@02
c<c<00?:b/[7alO7alL00/G5a@03`l?3`/;2`/;200;2`/800l?3`lG5aLG5a@02b<S800?;bl_>c/k>
c/h00]7Ad@03dm?Cd];Bd];B00;@d=000lc<c<O7alO7a`02`/;200>l_;bh^;Rh^;P00[Bd]003/k>c
];Bd];Bd00:g]kL00k^k^l30`<30`002aLG500?:b/[>c/k>c/h00]3@d003dM7Aclo?clo?00;<c<`0
0lS8b<?3`l?3``02_[jn00>h^;Ra/K6a/K400ZZZZP03Y:BTWIfMWIfM00:FUYH00i2@T8^;Rh^;R`02
R8R80hJ6QP:7QhL00hZ:RXj>SXj>SP02TY:B00>FUYJIVIVIVIT019ZJVP03V9RHUIFEUIFE00:ATI40
0hf=SHV9RHV9R@02QXJ600>3Ph>2PX:2PX800X>3P`03Q8B4QhN7QhN700:9RHT00hb<S8j>SXj>SP02
T92@0i6AT@>@T902Shn?0Xj>SPF=SHd00hn?Si2@T92@T002T92@00>ATI6?Shn?Shl00Xb<S003QhN7
OWinOWin00Coool00`000?ooooooo`0boooo00@0003oooooooooool2ATI600<^;RhR8R8R8R800RLW
9`03>CTiDU9BDU9B009]KFd00hF5QIJFUYJFUP02XJ6Q00>OWin>SXj>SXh00WEeM@03Fe]KBd];Bd];
009:BTX00eIFEVYZJVYZJP02Ogmo00>BTY:QXJ6QXJ400ZZZZP03[Jf]YjNWYjNW00:KVi/00hb<S861
PH61P@02O7al00=mOGeoOgmoOgl00WinOP9eMGD00fYZJV5QHF5QH@02GemO00=WIfMgMgMgMgL00XV9
R@03VYZJYZJVYZJV00:/[:`00jf][JRXZ:RXZ002W9bL00><S8akNg]kNg/00Vm_K`03JVYZK6a/K6a/
009_Kfl00fe]KF=SHf=SH`02E5AD00=6ATHn?Shn?Sh00Sdm?@03A4A4CTi>CTi>009IFET00f=SHf][
Jf][J`02LW9b00=fMWIhN7QhN7P00WMgM`03M7AdLW9bLW9b009bLW800g=cLgIfMWIfMP02NGUi00=k
Ng]mOGemOGd00WmoO`03Ph>3Rh^;Rh^;00:DU9@00iRHV96ATI6AT@02Ng]k00=MGEe6ATI6ATH00T51
@@03FEUIPh>3Ph>300:`/;000m7AdM_Kfm_Kf`02dm?C00?0`<2YZJVYZJT00Y>CT`03P820LW9bLW9b
009[Jf/2KFe]00=gMgN4Q8B4Q8@00Y:BTP03W9bLX:2PX:2P00:OWil00iJFUXF5QHF5Q@02Kfm_00=I
FEU8B4Q8B4P00T=3@`03ADE5Bd];Bd];009>CTh00d];BdA4A4A4A002?clo00=0@41;Bd];Bd/00UaL
G003KFe]NGUiNGUi009lO7`00gMgMg1`L71`L002KFe]00=aLG5gMgMgMgL00W]kN`03MGEeHF5QHF5Q
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9dM7@00fUYJEeMGEeMG@02
DU9B00=8B4Q2@T92@T800Slo?`03@T92B4Q8B4Q8009BDU800eeMGFUYJFUYJ@02M7Ad00=nOWj4Q8B4
Q8@00XJ6QP03QHF5PH61PH61009lO7`00gMgMg=cLg=cL`03LG5a0WEeM@9mOGd00hN7Qi:BTY:BTP02
WYjN00>ZZZZd];Bd];@00[fm_@;4a<@00lW9bLg=cLg=c@02clo?1M3@d003clo?cLg=cLg=00;<c<`0
0l[:b/O7alO7a`02aLG500?3`l?2`/;2`/800/;2`P03`l?3aLG5aLG500;8b<P00l_;blk>c/k>cP02
dM7A00?Cdm?Bd];Bd]800]3@d003c<c<alO7alO700;2`/800kbl_;Rh^;Rh^002];Bd00>c/k>d];Bd
];@00[Ng]`03^k^k`<30`<3000;5aLD00l[:b/k>c/k>cP02d=3@00?AdM7?clo?cll00/c<c003b<S8
`l?3`l?300:n_[h00kRh^;6a/K6a/@02ZZZZ00>TY:BMWIfMWId00YJFUP03T92@Rh^;Rh^;00:8R8P3
QXJ60XN7Q`03RXZ:SXj>SXj>00:BTY800iJFUYVIVIVIV@04VYZJ00>HV9REUIFEUID00Y6AT@03SHf=
RHV9RHV900:6QXH00h>3Ph:2PX:2PP02Ph>300>4Q8B7QhN7QhL00XV9R@03S8b<SXj>SXj>00:@T903
TI6A0i2@T0:?Shl2SXj>1Hf=S@03Shn?T92@T92@00:@T9000i6ATHn?Shn?S`02S8b<00>7QhMnOWin
OWh01?ooo`030000oooooooo03;oool010000?ooooooooooo`96ATH00bh^;R8R8R8R8P029bLW00<i
>CUBDU9BDU800Ve]K@03QHF5UYJFUYJF00:QXJ400inOWhj>SXj>SP02MGEe00=KFe];Bd];Bd/00TY:
BP03EUIFJVYZJVYZ009oOgl00i:BTZ6QXJ6QX@02ZZZZ00>][JfWYjNWYjL00Y^KV`03S8b<PH61PH61
009lO7`00gemOGmoOgmoO`02OWin0WEeM@03JVYZHF5QHF5Q009OGel00fMWIgMgMgMgM`02RHV900>J
VYZVYZJVYZH00Zb/[003[Jf]Z:RXZ:RX00:LW9`00hb<S7]kNg]kN`02Kfm_00=ZJVY/K6a/K6`00Vm_
K`03KFe]Hf=SHf=S009DE5@00dI6AShn?Shn?P02?Cdm00=4A4A>CTi>CTh00UUIF@03Hf=SJf][Jf][
009bLW800gIfMWQhN7QhN002MgMg00=dM7AbLW9bLW800W9bLP03Lg=cMWIfMWIf009iNGT00g]kNgem
OGemO@02Ogmo00>3Ph>;Rh^;Rh/00YBDU003V9RHTI6ATI6A009kNg/00eeMGDI6ATI6AP02@D5100=I
FEV3Ph>3Ph<00[2`/003dM7Afm_Kfm_K00;Cdm<00l30`:VYZJVYZ@02Ti>C00>0P81bLW9bLW800V][
J`9]KFd00gMgMhB4Q8B4Q002TY:B00>LW9bPX:2PX:000YnOW`03UYJFQHF5QHF5009_Kfl00eUIFDQ8
B4Q8B002@d=300=5ADE;Bd];Bd/00Ti>CP03Bd];A4A4A4A4008o?cl00d10@4];Bd];B`02G5aL00=]
KFeiNGUiNGT00WalO003MgMgL71`L71`009]KFd00g5aLGMgMgMgM`02Ng]k00=eMGEQHF5QHF401?oo
o`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0W=cL`03IfMWFe]KFe]K009?Cdl0
0dI6ASlo?clo?`02?Shn00=1@D5:BTY:BTX00UEEE@03Hf=SLW9bLW9b009oOgl00hZ:RY:BTY:BTP02
UIFE00>DU9B@T92@T9000XZ:RP03Q8B4OgmoOgmo009lO7`00g]kNginOWinOP02QHF500>>SXjHV9RH
V9P00Z>SX`03[Zj^^;Rh^;Rh00;1`L42bLW900?>c/kCdm?Cdm<00]KFeP03f=SHf][Jf][J00;Jf]X0
0mWIfMSHf=SHf002eMGE00?Bd];?clo?cll00/_;b`03alO7aLG5aLG500;3`l<00lC4a<G5aLG5a@02
b<S800?;bl_>c/k>c/h00]7Ad@03d];BdM7AdM7A00;>c/h00l[:b/C4a<C4a002_Kfm00>g]kNb/[:b
/[800Zj^[P03[Jf][jn_[jn_00:d];@00kZj^/30`<30`002alO700?>c/kBd];Bd]800mGEe@;Cdm<2
c/k>00?9bLW2`/;2`/800[^k^`03];Bd[Jf][Jf]00:VYZH00j2PX9^KVi^KV`02UiNG00>CTi>@T92@
T9000Xj>SP>=SHd2SXj>00>ATI6DU9BDU9@00YNGU`03VYZJWIfMWIfM00:OWil3X:2P0YnOW`:NWYh0
0ibLW9ZJVYZJVP02V9RH00>FUYJEUIFEUID00YBDU003Ti>CTY:BTY:B00>BTY82TI6A0Y2@T003Shn?
SXj>SXj>00:<S8`00hZ:RXR8R8R8R002QhN70hJ6QP:7QhL00hV9RHZ:RXZ:RP02S8b<0hf=S@:;Rh/0
0hJ6QWinOWinOP04oooo00<0003oooooool0<_ooo`040000oooooooooooo0U9BDP03=SHf9RHV9RHV
008X:2P00cPh>4m?Cdm?C`02HV9R00=]KFeaLG5aLG401G9bLP9dM7@00gIfMWQhN7QhN002Ng]k00=o
Ogn4Q8B4Q8@00XV9R@03SHf=T92@T92@00:ATI400i2@T8b<S8b<S002QXJ600=oOgmjNWYjNWX00WUi
N@=jNWX2MgMg0Vm_K`03IFEUG5aLG5aL009IFET00eiNGVUYJFUYJ@02MgMg00>4Q8B?Shn?Shl00YJF
UP03VYZJUiNGUiNG00:>SXh00h20P75aLG5aL@02IfMW00=TI6AXJ6QXJ6P00Va/K003KFe]IVIVIVIV
009KFe/00e1@D4Y:BTY:BP02BTY:00=ADE5JFUYJFUX00V=SH`03Jf][LG5aLG5a009eMGD00gQhN7Mg
MgMgM`02MGEe00=bLW9]KFe]KFd00VMWI`03Hf=SHF5QHF5Q009SHf<00fUYJG5aLG5aL@02NGUi00>3
Ph><S8b<S8`00Y>CT`03U9BDRHV9RHV9009]KFd00d];Bbh^;Rh^;P029RHV00<l?3aVIVIVIVH00YBD
U003]KFe_Kfm_Kfm00:a/K400i^KVhN7QhN7Q`02O7al00=gMgMeMGEeMGD00W5aL@9[Jf/00fEUIF9R
HV9RHP02IVIV00=`L71mOGemOGd00XV9R@03SXj>RHV9RHV9009nOWh00fm_Kf5QHF5QH@02EeMG00=A
DE5>CTi>CTh00Ti>CP03De=CFEUIFEUI009PH6000fATI69RHV9RHP02GUiN00=JFUYIFEUIFET00UaL
G003HV9RJVYZJVYZ009cLg<00ginOXN7QhN7Q`02Rh^;00>4Q8A_Kfm_Kfl01?ooo`030000oooooooo
013oool002Goool00`000?ooooooo`02oooo0W=cL`03IfMWFe]KFe]K009?Cdl00dI6ASlo?clo?`02
?Shn00=1@D5:BTY:BTX00UEEE@03Hf=SLW9bLW9b009oOgl00hZ:RY:BTY:BTP02UIFE00>DU9B@T92@
T9000XZ:RP03Q8B4OgmoOgmo009lO7`00g]kNginOWinOP02QHF500>>SXjHV9RHV9P00Z>SX`03[Zj^
^;Rh^;Rh00;1`L42bLW900?>c/kCdm?Cdm<00]KFeP03f=SHf][Jf][J00;Jf]X00mWIfMSHf=SHf002
eMGE00?Bd];?clo?cll00/_;b`03alO7aLG5aLG500;3`l<00lC4a<G5aLG5a@02b<S800?;bl_>c/k>
c/h00]7Ad@03d];BdM7AdM7A00;>c/h00l[:b/C4a<C4a002_Kfm00>g]kNb/[:b/[800Zj^[P03[Jf]
[jn_[jn_00:d];@00kZj^/30`<30`002alO700?>c/kBd];Bd]800mGEe@;Cdm<2c/k>00?9bLW2`/;2
`/800[^k^`03];Bd[Jf][Jf]00:VYZH00j2PX9^KVi^KV`02UiNG00>CTi>@T92@T9000Xj>SP>=SHd2
SXj>00>ATI6DU9BDU9@00YNGU`03VYZJWIfMWIfM00:OWil3X:2P0YnOW`:NWYh00ibLW9ZJVYZJVP02
V9RH00>FUYJEUIFEUID00YBDU003Ti>CTY:BTY:B00>BTY82TI6A0Y2@T003Shn?SXj>SXj>00:<S8`0
0hZ:RXR8R8R8R002QhN70hJ6QP:7QhL00hV9RHZ:RXZ:RP02S8b<0hf=S@:;Rh/00hJ6QWinOWinOP04
oooo00<0003oooooool0<_ooo`040000oooooooooooo0U9BDP03=SHf9RHV9RHV008X:2P00cPh>4m?
Cdm?C`02HV9R00=]KFeaLG5aLG401G9bLP9dM7@00gIfMWQhN7QhN002Ng]k00=oOgn4Q8B4Q8@00XV9
R@03SHf=T92@T92@00:ATI400i2@T8b<S8b<S002QXJ600=oOgmjNWYjNWX00WUiN@=jNWX2MgMg0Vm_
K`03IFEUG5aLG5aL009IFET00eiNGVUYJFUYJ@02MgMg00>4Q8B?Shn?Shl00YJFUP03VYZJUiNGUiNG
00:>SXh00h20P75aLG5aL@02IfMW00=TI6AXJ6QXJ6P00Va/K003KFe]IVIVIVIV009KFe/00e1@D4Y:
BTY:BP02BTY:00=ADE5JFUYJFUX00V=SH`03Jf][LG5aLG5a009eMGD00gQhN7MgMgMgM`02MGEe00=b
LW9]KFe]KFd00VMWI`03Hf=SHF5QHF5Q009SHf<00fUYJG5aLG5aL@02NGUi00>3Ph><S8b<S8`00Y>C
T`03U9BDRHV9RHV9009]KFd00d];Bbh^;Rh^;P029RHV00<l?3aVIVIVIVH00YBDU003]KFe_Kfm_Kfm
00:a/K400i^KVhN7QhN7Q`02O7al00=gMgMeMGEeMGD00W5aL@9[Jf/00fEUIF9RHV9RHP02IVIV00=`
L71mOGemOGd00XV9R@03SXj>RHV9RHV9009nOWh00fm_Kf5QHF5QH@02EeMG00=ADE5>CTi>CTh00Ti>
CP03De=CFEUIFEUI009PH6000fATI69RHV9RHP02GUiN00=JFUYIFEUIFET00UaLG003HV9RJVYZJVYZ
009cLg<00ginOXN7QhN7Q`02Rh^;00>4Q8A_Kfm_Kfl01?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0W1`L003IFEUF5QHF5QH009=CDd00dA4A3hn?Shn?P02?Shn00=3@d=<C4a<
C4`00UYJFP03JFUYNGUiNGUi00:8R8P00iFEUIjNWYjNWP02XJ6Q00>PX:2LW9bLW9`00YJFUP03T92@
RXZ:RXZ:00:6QXH00hB4Q8J6QXJ6QP02S8b<00>DU9BMWIfMWId00ZNWY`03/K6a^k^k^k^k00;4a<@2
c<c<00?Bd];GemOGemL00]_Kf`03gmoOhN7QhN7Q00?Rh^82h>3P0]gMg@03fMWIe=CDe=CD00;?cll0
0l[:b/K6a/K6aP02a<C400?3`l?4a<C4a<@00/O7a`03b/[:cLg=cLg=00;?cll00m7AdM3@d=3@d002
cLg=00?7alO1`L71`L400[Vi^@03/k>c[Jf][Jf]00:YZJT00jRXZ:^[Zj^[Z`02/;2`00>h^;S0`<30
`<000/W9b@03d=3@e]KFe]KF00;IfMT00mSHf=GEeMGEe@02d=3@00?8b<S0`<30`<000[Rh^003/;2`
ZJVYZJVY00:SXj<00ijNWYZJVYZJVP02UiNG00>EUIFDU9BDU9@00i>CT`:DU9@2UIFE00>GUiNIVIVI
VIT00YbLW003WYjNXJ6QXJ6Q00:TY:@2YZJV00>WYjNXZ:RXZ:P00jVYZ@:XZ:P2YjNW00>VYZJTY:BT
Y:@00Z:RXP03X:2PWIfMWIfM00:KVi/00iRHV9FEUIFEU@02Ti>C00>@T92=SHf=SHd00XZ:RP03QhN7
Q8B4Q8B400:2PX83P8200X61P@03Ph>3QHF5QHF500:7QhL00hR8R8V9RHV9R@02QhN700>2PX9jNWYj
NWX01?ooo`030000oooooooo03;oool010000?ooooooooooo`9RHV800d=3@bl_;bl_;`02;bl_00<m
?Ce?Cdm?Cdl00U]KF`03FEUICdm?Cdm?0095ADD00dI6AUMGEeMGE`02LW9b00>>SXjRXZ:RXZ800ZRX
Z003Xj>SVIVIVIVI00:=SHd00h:2PWYjNWYjNP02Lg=c00=^KVi[Jf][Jf/00V][J`03KFe]L71`L71`
009cLg<3MGEe0W5aL@9ZJVX00f5QHEUIFEUIF@03E5AD0UQHF09OGel00fQXJ79bLW9bLP02O7al00>2
PX:3Ph>3Ph<00WalO003L71`I6ATI6AT00=LG5`2Hf=S0VYZJP03Kfm_K6a/K6a/009UIFD00eiNGUYJ
FUYJFP02G5aL00=SHf=[Jf][Jf/00W9bLP03MWIfN7QhN7Qh009hN7P00gMgMgEeMGEeM@02Lg=c00=`
L71YJFUYJFT00UiNGP03E5ADCDe=CDe=009<C4`00eEEEF=SHf=SH`02Lg=c00>1PH6<S8b<S8`00Y:B
TP03T92@PH61PH61009QHF400c/k>aXJ6QXJ6P023Ph>00<P8218B4Q8B4P00WEeM@03Ti>CV9RHV9RH
00:8R8P00g9bLV9RHV9RHP02HV9R00=/K6afMWIfMWH00WMgM`9ZJVX00eADE410@410@002>3Ph00=2
@T9GEeMGEeL00Vm_K`03PX:2Rh^;Rh^;00:;Rh/00hF5QG]kNg]kN`02Kfm_00=RHV9HF5QHF5P00UIF
EP03H61PLW9bLW9b00:3Ph<00hR8R7]kNg]kN`02Hf=S00=;Bd/l?3`l?3`00Slo?`03CTi>HV9RHV9R
009hN7P00hZ:RYNGUiNGU`02W9bL00>EUIF0P820P8001?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0V][J`03H61PEEEEEEEE009;Bd/00d=3@clo?clo?`02?clo00=5ADE@D51@
D5000UmOG`03Kfm_P820P82000:?Shl00ifMWJJVYZJVYP02ZZZZ00>YZJVUYJFUYJD00Z2PX003VIVI
Ti>CTi>C00:>SXh00hf=SHj>SXj>SP02TY:B00>IVIVRXZ:RXZ800Z^[Z`03];Bd_[jn_[jn00;6a/H2
c/k>00?EeMGKfm_Kfm/00]oOg`03hn?Si^KVi^KV00;Xj>P00nOWinGUiNGUi@02hN7Q00?Lg=cFe]KF
e]H00]3@d003b/[:aLG5aLG500;2`/800l71`L?3`l?3``02aLG500?8b<S<c<c<c<`00/o?c`03d=3@
clo?clo?00;<c<`00lK6a[no_kno_`02]kNg00>`/;2ZZZZZZZX00ZJVYP03YJFUZ:RXZ:RX00:^[Zh0
0kJf]/30`<30`002bLW900?AdM7GemOGemL00]_Kf`03f][JemOGemOG00;@d=000lS8b<30`<30`002
]kNg00>^[ZjWYjNWYjL00Z6QX@03WIfMVYZJVYZJ00:HV9P3UiNG0iRHV0:IVIT2Vi^K00>LW9bNWYjN
WYh00Z2PX003Xj>SYZJVYZJV00:XZ:P2Zj^[00>][Jf_[jn_[jl00[6a/@Fb/[800k6a/Jn_[jn_[`02
[Jf]00>ZZZZVYZJVYZH00Z>SX`03WinOVi^KVi^K00:GUiL00i>CThn?Shn?S`02Rh^;00>7QhN4Q8B4
Q8@00X20P003OWinOGemOGem00=mOGd2Ogmo0X20P0>1PH42P82000=kNg]dM7AdM7@01?ooo`030000
oooooooo03;oool010000?ooooooooooo`9_Kfl00dm?CcXj>SXj>P02>3Ph00=5ADEEEEEEEED00UeM
G@03E5AD@D51@D5100<b<S82BTY:0W5aL@03V9RH/k>c/k>c00:j^[X00k2`/9bLW9bLW002QhN700=c
Lg=TI6ATI6@00UQHF0=ADE42EUIF00=NGUiWIfMWIfL00Vi^KP03LW9bLg=cLg=c009`L702JFUY00=Q
HF5HF5QHF5P00U5AD@03C4a<Bd];Bd];009=CDd00e=CDeeMGEeMG@02J6QX00=aLG5eMGEeMGD00Vm_
K`03I6ATF5QHF5QH009BDU800eEEEEmOGemOG`02Jf][00=cLg=dM7AdM7@00W1`L003Jf][JFUYJFUY
009]KFd00gEeMGemOGemO@02PH6100>0P81kNg]kNg/00WEeM@03L71`Kfm_Kfm_00=_Kfl2JFUY0UaL
G003C4a<@410@410008m?Cd00dM7AeUIFEUIF@02KVi^00>0P82=SHf=SHd00Y>CT`03Shn?OWinOWin
009LG5`00c@d=0l?3`l?3`02000000<>3Phb<S8b<S800UaLG003N7QhNWYjNWYj009YJFT00e=CDdQ8
B4Q8B002D51@00=UIFEhN7QhN7P00WalO09YJFT00dQ8B2TY:BTY:@026ATI00<R8R8l?3`l?3`00UaL
G003NGUiRXZ:RXZ:00:ATI400i:BTXb<S8b<S002Ogmo00=_KfmQHF5QHF400UiNGP03KFe]QXJ6QXJ6
00:LW9`00j>SXhn?Shn?S`02Jf][00=6ATH_;bl_;bl00Rl_;`03@D51Fe]KFe]K009gMgL00hj>SYjN
WYjNWP02YZJV00>RXZ:>SXj>SXh01?ooo`030000oooooooo013oool002Goool200000oooo`9[Jf/0
0f1PH5EEEEEEE@02Bd];00=3@d<o?clo?cl00Slo?`03ADE5D51@D51@009OGel00fm_Kh20P820P002
Shn?00>MWIfVYZJVYZH00ZZZZP03ZJVYYJFUYJFU00:PX:000iVIVI>CTi>CT`02SXj>00>=SHf>SXj>
SXh00Y:BTP03VIVIXZ:RXZ:R00:[Zj/00kBd];jn_[jn_P02a/K60/k>cP03eMGEfm_Kfm_K00;Ogml0
0n?ShnKVi^KViP02j>SX00?WinOUiNGUiND00^7Qh@03g=cLe]KFe]KF00;@d=000l[:b/G5aLG5a@02
`/;200?1`L73`l?3`l<00/G5a@03b<S8c<c<c<c<00;?cll00m3@d<o?clo?c`02c<c<00?6a/Jo_kno
_kl00[Ng]`03/;2`ZZZZZZZZ00:VYZH00jFUYJRXZ:RXZ002[Zj^00>f][K0`<30`<000/W9b@03dM7A
emOGemOG00;Kfm/00m[Jf]OGemOGe`02d=3@00?8b<S0`<30`<000[Ng]`03[Zj^YjNWYjNW00:QXJ40
0ifMWIZJVYZJVP02V9RH0iNGU`>HV9P2VIVI0Y^KV`03W9bLWYjNWYjN00:PX:000j>SXjJVYZJVYP02
Z:RX0Z^[Z`03[Jf][jn_[jn_00:a/K45/[:b00>a/K6_[jn_[jl00Zf][@03ZZZZYZJVYZJV00:SXj<0
0inOWi^KVi^KV`02UiNG00>CTi>?Shn?Shl00X^;R`03QhN7Q8B4Q8B400:0P8000ginOWemOGemO@03
OGem0WmoO`:0P803PH610X20P003Ng]kM7AdM7Ad00?oool20000=?ooo`040000oooooooooooo0Vm_
K`03Cdm?>SXj>SXj008h>3P00dE5AEEEEEEEE@02GEeM00=DE5A1@D51@D400c8b<P9:BTX2LG5a00>H
V9Rc/k>c/k<00[Zj^P03/;2`W9bLW9bL00:7QhL00g=cLfATI6ATI002F5QH0e5AD@9FEUH00eiNGVMW
IfMWI`02KVi^00=bLW9cLg=cLg<00W1`L09YJFT00f5QHEQHF5QHF002DE5A00=<C4a;Bd];Bd/00Te=
C@03De=CGEeMGEeM009XJ6P00g5aLGEeMGEeM@02Kfm_00=TI6AHF5QHF5P00U9BDP03EEEEGemOGemO
009[Jf/00g=cLgAdM7AdM002L71`00=[Jf]YJFUYJFT00Ve]K@03MGEeOGemOGem00:1PH400h20P7]k
Ng]kN`02MGEe00=`L71_Kfm_Kfl00fm_K`9YJFT2G5aL00=<C4a0@410@4000Sdm?@03AdM7FEUIFEUI
009^KVh00h20P8f=SHf=S@02Ti>C00>?ShmnOWinOWh00UaLG003=3@d3`l?3`l?008000000`h>3S8b
<S8b<P02G5aL00=hN7QjNWYjNWX00VUYJ@03De=CB4Q8B4Q8009@D5000fEUIGQhN7QhN002O7al0VUY
J@03B4Q8:BTY:BTY008I6AT00b8R8S`l?3`l?002G5aL00=iNGV:RXZ:RXX00Y6AT@03TY:BS8b<S8b<
009oOgl00fm_Kf5QHF5QH@02GUiN00=]KFf6QXJ6QXH00YbLW003Xj>SShn?Shn?009[Jf/00dI6ARl_
;bl_;`02;bl_00=1@D5KFe]KFe/00WMgM`03SXj>WYjNWYjN00:VYZH00j:RXXj>SXj>SP03oooo0P00
01;oool002Goool00`000?ooooooo`02oooo0V=SH`03FUYJDE5ADE5A0099BDT00dA4A451@D51@@02
A4A400=;Bd]FEUIFEUH00VATI003M7AdQHF5QHF500:DU9@00j6QXJZZZZZZZP03[Zj^0Z^[Z`:UYJD0
0inOWiZJVYZJVP02UYJF00>DU9BEUIFEUID00YVIV@03WinOYZJVYZJV00:_[jl00kNg]l30`<30`002
b<S80]3@d003emOGgMgMgMgM00;Rh^800nKVi^WYjNWYj@03j^[Z0^OWi`;Shn<00mgMgMKFe]KFeP02
clo?00?9bLW3`l?3`l<00/30`003_kno`<30`<3000;3`l<00lO7al_;bl_;b`02c/k>0m3@d0;<c<`0
0lK6a[no_kno_`02]kNg00>_[jnYZJVYZJT00ZFUY@03Y:BTYjNWYjNW00:][Jd00kJf][no_kno_`02
bLW900?Bd];Hf=SHf=P00m_Kf`;GemL2dM7A00?9bLW0`<30`<000[Ng]`03[Zj^YjNWYjNW00:RXZ80
0ijNWYbLW9bLW002Vi^K0iZJVP:KVi/00ibLW9jNWYjNWP02WinO00>QXJ6SXj>SXj<00ZFUY@03YjNW
ZZZZZZZZ00:/[:`2[jn_00>a/K6c/k>c/k<00[Fe]@Jf][H2];Bd0[>c/`03/;2`[Jf][Jf]00:ZZZX0
0jNWYj>SXj>SX`02WinO00>JVYZFUYJFUYH00Y6AT@03S8b<QhN7QhN700:3Ph<00gmoOgalO7alO002
NWYj1WUiN@9hN7P2MGEe00=aLG5[Jf][Jf/01?ooo`030000oooooooo03;oool010000?oooooooooo
o`9gMgL00eMGEd=3@d=3@`02@T9200=@D51RHV9RHV800V][J`03IFEUEEEEEEEE0096ATH00dA4A5AD
E5ADE002LG5a00>=SHfPX:2PX:000Z>SX`03V9RHQhN7QhN7009cLg<00f9RHU=CDe=CD`02B4Q800=3
@d=5ADE5ADD00Ta<C003EeMGHf=SHf=S009]KFd00g=cLgIfMWIfMP02M7Ad0Ve]K@03Hf=SF5QHF5QH
009>CTh00dQ8B4M7AdM7A`02B4Q800=>CTiHF5QHF5P00VATI003KVi^LW9bLW9b009[Jf/00emOGe9B
DU9BDP02CDe=00=BDU9PH61PH6000Vm_K`03NWYjO7alO7al009hN7P00g9bLW5aLG5aL@02MgMg00>2
PX:;Rh^;Rh/00Xj>SP03R8R8NWYjNWYj009/K6`3Hf=S0VUYJ@03Kfm_KFe]KFe]009QHF400dm?Cd10
@410@002>SXj00=3@d=GEeMGEeL00Va/K003PH61T92@T92@00:GUiL00iFEUHB4Q8B4Q002Hf=S00<i
>CTD51@D51@00P410@0330`<;2`/;2`/009BDU800fa/K6m_Kfm_K`02GemO00=<C4a4A4A4A4@00Tm?
C`03IFEUNWYjNWYj009nOWh2JFUY00=6ATHU9BDU9BD00Q<C4`036a/K=SHf=SHf009GEeL00gAdM8N7
QhN7Q`02Shn?00>ATI6<S8b<S8`00X20P003LG5aI6ATI6AT009RHV800g9bLXb<S8b<S002Y:BT00>[
Zj^IVIVIVIT00WIfMP03DE5A=cLg=cLg008c<c<00d10@5EEEEEEE@02KVi^00>5QHFIVIVIVIT00jJV
YP:DU9@4oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2Hf=S00=JFUYADE5A
DE400TU9B@03A4A4@D51@D510094A4@00d];BeIFEUIFEP02I6AT00=dM7B5QHF5QHD00YBDU003XJ6Q
ZZZZZZZZ00>^[Zh2Zj^[0ZFUY@03WinOVYZJVYZJ00:FUYH00iBDU9FEUIFEU@02VIVI00>OWinVYZJV
YZH00Zn_[`03]kNg`<30`<3000;8b<P2d=3@00?GemOMgMgMgMd00^;RhP03i^KVjNWYjNWY00?Zj^X2
inOW0^?Sh`03gMgMe]KFe]KF00;?cll00lW9bL?3`l?3``02`<3000>o_ko0`<30`<000/?3``03alO7
bl_;bl_;00;>c/h3d=3@0/c<c003a/K6_kno_kno00:g]kL00jn_[jVYZJVYZ@02YJFU00>TY:BWYjNW
YjL00Zf][@03][Jf_kno_kno00;9bLT00m;Bd]SHf=SHf003fm_K0]OGe`;AdM400lW9bL30`<30`002
]kNg00>^[ZjWYjNWYjL00Z:RXP03WYjNW9bLW9bL00:KVi/3VYZJ0Y^KV`03W9bLWYjNWYjN00:OWil0
0j6QXJ>SXj>SX`02YJFU00>WYjNZZZZZZZX00Zb/[0:_[jl00k6a/K>c/k>c/`02]KFe1[Jf]P:d];@2
/k>c00>`/;2][Jf][Jd00ZZZZP03YjNWXj>SXj>S00:OWil00iZJVYJFUYJFUP02TI6A00><S8b7QhN7
QhL00X>3P`03OgmoO7alO7al009jNWX6NGUi0WQhN09eMGD00g5aLF][Jf][J`04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0WMgM`03EeMG@d=3@d=30092@T800e1@D69RHV9RHP02Jf][00=U
IFEEEEEEEED00TI6AP03A4A4E5ADE5AD009aLG400hf=SJ2PX:2PX002Xj>S00>HV9R7QhN7QhL00W=c
L`03HV9RDe=CDe=C0098B4P00d=3@dE5ADE5A@02C4a<00=GEeMSHf=SHf<00Ve]K@03Lg=cMWIfMWIf
009dM7@2KFe]00=SHf=HF5QHF5P00Ti>CP03B4Q8AdM7AdM70098B4P00di>CUQHF5QHF002I6AT00=^
KVibLW9bLW800V][J`03GemODU9BDU9B009=CDd00e9BDV1PH61PH002Kfm_00=jNWYlO7alO7`00WQh
N003LW9bLG5aLG5a009gMgL00h:2PX^;Rh^;R`02SXj>00>8R8QjNWYjNWX00Va/K0=SHf<2JFUY00=_
Kfm]KFe]KFd00V5QH@03Cdm?@410@410008j>SX00d=3@eMGEeMGE`02K6a/00>1PH6@T92@T9000YNG
U`03UIFEQ8B4Q8B4009SHf<00cTi>A@D51@D50020@4100<<30`/;2`/;2`00U9BDP03K6a/Kfm_Kfm_
009OGel00da<C4A4A4A4A002Cdm?00=UIFEjNWYjNWX00WinOP9YJFT00dI6ARDU9BDU9@024a<C00<K
6a/f=SHf=SH00UMGE`03M7AdQhN7QhN700:?Shl00i6ATHb<S8b<S002P82000=aLG5TI6ATI6@00V9R
HP03LW9bS8b<S8b<00:TY:@00j^[ZiVIVIVIV@02MWIf00=ADE4g=cLg=cL00S<c<`03@410EEEEEEEE
009^KVh00hF5QIVIVIVIV@03YZJV0YBDU0Coool00`000?ooooooo`0@oooo000Uoooo00<0003ooooo
ool00_ooo`9IFET00e=CDde=CDe=C@02B4Q80dI6AP9:BTX00e9BDUeMGEeMG@02Jf][00=jNWZ9RHV9
RHT00YJFUP03XZ:RZZZZZZZZ00:^[Zh00jn_[jb/[:b/[002Z:RX00>SXj>NWYjNWYh00Y^KV`03VIVI
Vi^KVi^K00:NWYh00jBTY:^[Zj^[Z`02/[:b00>j^[[2`/;2`/800/[:bP;AdM400mSHf=gMgMgMg@02
h^;R00?WinOZj^[Zj^X00^_[j`03j^[ZinOWinOW00;Rh^800m_KfmCDe=CDe002c<c<00?5aLFo_kno
_kl00[bl_003^k^k_Kfm_Kfm00;0`<000lG5aL[:b/[:bP02c/k>0m7Ad@;>c/h00lS8b<71`L71`@02
^KVi00>a/K6[Zj^[Zj/00ZJVYP03YJFUZ:RXZ:RX00:^[Zh00kJf][no_kno_`02bLW900?AdM7GemOG
emL00m_Kf`;GemL2dM7A00?:b/[1`L71`L400[Vi^@03/K6aZZZZZZZZ00:TY:@00j6QXInOWinOW`02
WYjN0ifMW@:NWYh00inOWj6QXJ6QX@02Xj>S00>TY:BWYjNWYjL00ZVYZ@03[:b/[Zj^[Zj^00:a/K42
/[:b00>d];Be]KFe]KD01kJf]P>e]KD2];Bd00>c/k>b/[:b/[800[2`/003[Zj^[:b/[:b/00:XZ:P0
0jBTY:2PX:2PX002VYZJ00>EUIF?Shn?Shl00XV9R@03Ph>3OWinOWin009jNWX00gMgMgAdM7AdM002
LG5a00=^KVi/K6a/K6`00VUYJ@03I6ATGemOGemO00Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2N7Qh00=LG5a:BTY:BTX00Ta<C003GEeMLW9bLW9b00:2PX800hF5QGmoOgmoO`02MWIf00=_
Kfm^KVi^KVh00W5aL@=dM7@2L71`00=ZJVYRHV9RHV800UYJFP03DE5ABDU9BDU90094A4@00d92@TI6
ATI6AP02CDe=00=GEeMRHV9RHV800Vi^KP03N7QhOWinOWin009mOGd2MGEe00=WIfMIFEUIFET00Ti>
CP03B4Q8BDU9BDU9009=CDd00eIFEV5QHF5QH@02K6a/00=fMWIhN7QhN7P00Vm_K`03HF5QDU9BDU9B
009;Bd/00e9BDV=SHf=SH`02MWIf00>3Ph>4Q8B4Q8@00WemO@03MGEeLg=cLg=c009kNg/00hV9RIFE
UIFEU@02UiNG00>;Rh]fMWIfMWH00V1PH003De=CEEEEEEEE009RHV800fm_KgAdM7AdM002Jf][00=J
FUY:BTY:BTX00T92@P03BDU9FUYJFUYJ009_Kfl00h:2PY>CTi>CT`02W9bL00>MWIf@T92@T9000W5a
L@03B4Q88b<S8b<S008?3`l00aLG5c@d=3@d=002EUIF00=_KfmcLg=cLg<00VMWI`03EeMGD51@D51@
009IFET00f][Jg]kNg]kN`02OWin0V][J`03CDe=;bl_;bl_008P82000bPX:3lo?clo?`02G5aL00=d
M7B2PX:2PX800XN7Q`03QXJ6P820P820009gMgL00fa/K6=SHf=SH`02Hf=S00=aLG67QhN7QhL00Y^K
V`03Xj>SV9RHV9RH00:0P8000fIVIU1@D51@D002ATI600=7AdM@D51@D5000UmOG`03M7AdRh^;Rh^;
00:MWId00j:RXY>CTi>CT`04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
CTi>00=;Bd]9BDU9BDT00TQ8B003BTY:CDe=CDe=009CDe<00e]KFfIVIVIVIP02LW9b00=oOgn;Rh^;
Rh/00YNGU`03XJ6QZ:RXZ:RX00:[Zj/00jb/[:^[Zj^[Z`02Z:RX00>TY:BQXJ6QXJ400YnOW`03WYjN
X:2PX:2P00:SXj<00jVYZJn_[jn_[`02][Jf00>m_Kg4a<C4a<@00/_;b`;Bd]800mSHf=gMgMgMg@02
h^;R00?Vi^KYjNWYjNT00^WYj@03j>SXi>CTi>CT00;Ng]h00mOGelo?clo?c`02alO700?0`<2j^[Zj
^[X00kNg]`:i^KT2_[jn00?3`l?9bLW9bLT00/o?c`03d];Bdm?Cdm?C00;AdM400lc<c<G5aLG5a@02
_Kfm00>e]KF^[Zj^[Zh00ZZZZP03Z:RXZZZZZZZZ00:_[jl00kNg]kno_kno_`02b<S800?@d=3Fe]KF
e]H00mWIf@;Fe]H2dM7A00?;bl_3`l?3`l<00[bl_003];Bd[Zj^[Zj^00:YZJT00jFUYJ>SXj>SX`03
XJ6Q0Z2PX0:QXJ400j:RXZ>SXj>SX`02YJFU00>XZ:RZZZZZZZX00Zf][@03/;2`/[:b/[:b00:d];@5
]KFe0[Bd]003/k>c/[:b/[:b00Fa/K42/[:b00>d];Be]KFe]KD00kJf]P:e]KD2/k>c00>`/;2[Zj^[
Zj/00ZJVYP03WinOV9RHV9RH00:ATI400hV9RH:2PX:2PP02Ng]k00=eMGE^KVi^KVh00VUYJ@03I6AT
GemOGemO009JFUX00eIFEU9BDU9BDP04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WQh
N003GemODE5ADE5A009FEUH00fYZJX>3Ph>3P`02VIVI00>VYZJZZZZZZZX00ZNWY`03W9bLR8R8R8R8
009`L7000eMGEdA4A4A4A002>c/k00<j>SXn?Shn?Sh00T=3@`03ADE5ATI6ATI60097AdL00dU9BDe=
CDe=C@02De=C00=JFUYSHf=SHf<00W1`L003O7alQXJ6QXJ600:7QhL2OGem00=]KFeLG5aLG5`00Tm?
C`03Bd];Cdm?Cdm?009FEUH00f5QHFe]KFe]K@02NGUi0h61P@9fMWH00fEUIEADE5ADE002C4a<00=D
E5AWIfMWIfL00WalO0>:RXX2P82000=eMGEaLG5aLG400WYjNP03Rh^;VYZJVYZJ00:LW9`00hb<S75a
LG5aL@02EEEE00=6ATI:BTY:BTX00UaLG003L71`Ng]kNg]k009fMWH00fIVIUIFEUIFEP02CTi>00=C
De=QHF5QHF400W9bLP03Q8B4U9BDU9BD00:PX:000jBTY9ZJVYZJVP02Ogmo00=JFUXf=SHf=SH00R<S
8`03:BTY@T92@T92009QHF400gQhN7emOGemO@02M7Ad00=XJ6QQHF5QHF400VIVIP03LW9bOGemOGem
009mOGd2KVi^00=GEeM1@D51@D400SHf=P03?CdmCdm?Cdm?009UIFD00gIfMWinOWinOP02OGem00=h
N7QaLG5aLG400VYZJP03IFEUHV9RHV9R009TI6@00fm_KgemOGemO@02Rh^;00>CTi>BTY:BTY800XZ:
RP03OWinKfm_Kfm_009PH6000eADE4a<C4a<C002D51@00=QHF5jNWYjNWX00Y6AT@03Vi^KTI6ATI6A
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9>CTh00d];BdU9BDU9B@02
B4Q800=:BTY=CDe=CDd00U=CD`03Fe]KIVIVIVIV009bLW800gmoOh^;Rh^;R`02UiNG00>QXJ6XZ:RX
Z:P00Z^[Z`03[:b/Zj^[Zj^[00:XZ:P00jBTY:6QXJ6QX@02WinO00>NWYjPX:2PX:000Z>SX`03ZJVY
[jn_[jn_00:f][H00kfm_LC4a<C4a002bl_;0];BdP03f=SHgMgMgMgM00;Rh^800nKVi^WYjNWYj@02
jNWY00?Xj>STi>CTi>@00]kNgP03emOGclo?clo?00;7alL00l30`;Zj^[Zj^P03]kNg0[Vi^@:n_[h0
0l?3`lW9bLW9b@02clo?00?Bd];Cdm?Cdm<00]7Ad@03c<c<aLG5aLG500:m_Kd00kFe]Jj^[Zj^[P02
ZZZZ00>XZ:RZZZZZZZX00Zn_[`03]kNg_kno_kno00;8b<P00m3@d=KFe]KFeP03fMWI0]KFeP;AdM40
0l_;bl?3`l?3``02_;bl00>d];B^[Zj^[Zh00ZVYZ@03YJFUXj>SXj>S00>QXJ42X:2P0Z6QX@03XZ:R
Xj>SXj>S00:UYJD00jRXZ:ZZZZZZZP02[Jf]00>`/;2b/[:b/[800[Bd]0Fe]KD2];Bd00>c/k>b/[:b
/[801K6a/@:b/[800kBd];Fe]KFe]@03][Jf0[Fe]@:c/k<00k2`/:^[Zj^[Z`02YZJV00>OWinHV9RH
V9P00Y6AT@03RHV9PX:2PX:2009kNg/00gEeMFi^KVi^KP02JFUY00=TI6AOGemOGel00UYJFP03EUIF
DU9BDU9B00Coool00`000?ooooooo`0boooo00@0003oooooooooool2N7Qh00=OGemADE5ADE400UIF
EP03JVYZPh>3Ph>300:IVIT00jJVYZZZZZZZZP02YjNW00>LW9b8R8R8R8P00W1`L003EeMGA4A4A4A4
008k>c/00cXj>Shn?Shn?P02@d=300=5ADE6ATI6ATH00TM7A`03BDU9CDe=CDe=009CDe<00eYJFV=S
Hf=SH`02L71`00=lO7b6QXJ6QXH00XN7Q`9mOGd00fe]KEaLG5aLG002Cdm?00=;Bd]?Cdm?Cdl00UIF
EP03HF5QKFe]KFe]009iNGT3PH610WIfMP03IFEUE5ADE5AD009<C4`00eADE6MWIfMWI`02O7al0hZ:
RP:0P8000gEeMG5aLG5aL@02NWYj00>;Rh^JVYZJVYX00YbLW003S8b<LG5aLG5a009EEED00dI6ATY:
BTY:BP02G5aL00=`L71kNg]kNg/00WIfMP03IVIVEUIFEUIF009>CTh00e=CDf5QHF5QH@02LW9b00>4
Q8BDU9BDU9@00Z2PX003Y:BTVYZJVYZJ009oOgl00eYJFSHf=SHf=P028b<S00<Y:BU2@T92@T800V5Q
H@03N7QhOGemOGem009dM7@00fQXJ65QHF5QH@02IVIV00=bLW9mOGemOGd00WemO@9^KVh00eMGEd51
@D51@@02=SHf00<m?Ce?Cdm?Cdl00VEUI@03MWIfOWinOWin009mOGd00gQhN75aLG5aL@02JVYZ00=U
IFERHV9RHV800VATI003Kfm_OGemOGem00:;Rh/00i>CTi:BTY:BTP02RXZ:00=nOWi_Kfm_Kfl00V1P
H003E5ADC4a<C4a<009@D5000f5QHGYjNWYjNP02TI6A00>KVi^ATI6ATI401?ooo`030000oooooooo
013oool002Goool00`000?ooooooo`02oooo0T=3@`03A4A4ATI6ATI60099BDT00di>CUEEEEEEE@02
G5aL00=UIFE_Kfm_Kfl00WUiN@03Q8B4SXj>SXj>00:FUYH00ijNWZ>SXj>SX`02YZJV0jNWY`:VYZH0
0jBTY::RXZ:RXP02XJ6Q00>RXZ:TY:BTY:@00ZRXZ003[Jf]/[:b/[:b00:i^KT00kno_lG5aLG5a@02
c<c<0];BdP03f=SHgMgMgMgM00;QhN400nCTi>KVi^KViP02i^KV00?Ti>CPh>3Ph>000][JfP03d];B
b/[:b/[:00;1`L400kZj^[Bd];Bd]002/K6a00>b/[:e]KFe]KD00[Zj^P03`L71b<S8b<S800;>c/h0
0m?CdmGEeMGEe@02dm?C00??clo8b<S8b<P00/71`@03^KVi/k>c/k>c00:^[Zh00jb/[:f][Jf][@02
/K6a00>h^;Ro_kno_kl00/O7a`03c/k>dm?Cdm?C00;Fe]H00mOGemGEeMGEe@02dM7A00?;bl_5aLG5
aLD00[no_`03^KVi/k>c/k>c00:_[jl00j^[ZjRXZ:RXZ002YZJV00>TY:BSXj>SXj<00Z:RXP03Xj>S
YJFUYJFU00:WYjL00jZZZZf][Jf][@02/K6a00>d];Bf][Jf][H00[Rh^0:g]kL00kJf][>c/k>c/`02
/;2`00>][Jf[Zj^[Zj/00jVYZ@:[Zj/2[Zj^00>a/K6e]KFe]KD00[Vi^@03_;bl_[jn_[jn00:n_[h0
0kbl_;Rh^;Rh^002/[:b00>[Zj^SXj>SXj<00YZJVP03T92@QXJ6QXJ6009lO7`00g9bLVUYJFUYJ@02
H61P00=HF5QADE5ADE400T];B`03AdM7A4A4A4A400Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2N7Qh00=RHV9HF5QHF5P00V9RHP03NGUiU9BDU9BD00:][Jd00kfm_LC4a<C4a002`L7100>a
/K6ATI6ATI400VUYJ@03@D5192@T92@T008J6QX00alO7bd];Bd];@02?3`l00=6ATI<C4a<C4`00U5A
D@03EEEEF5QHF5QH009KFe/00eiNGVEUIFEUI@02LG5a00=oOgn;Rh^;Rh/00Xj>SP:4Q8@00g9bLUmO
GemOG`02DU9B00=?CdmEEEEEEED00UmOG`03K6a/NGUiNGUi00:4Q8@00h^;RhZ:RXZ:RP02OWin00=[
Jf]IFEUIFET00U1@D003F5QHK6a/K6a/00:2PX800hn?Shf=SHf=S@02PH6100=cLg=]KFe]KFd00WMg
M`03RHV9VIVIVIVI00:MWId00hb<S6i^KVi^KP02DE5A00=0@415ADE5ADD00UQHF003KVi^O7alO7al
009jNWX00fe]KEmOGemOG`02EeMG00=JFUYVIVIVIVH00WAdM003Q8B4Ti>CTi>C00:OWil00jFUYIjN
WYjNWP02QhN700=VIVI7AdM7AdL00SHf=P03?3`lDe=CDe=C009^KVh00h:2PXN7QhN7Q`02OWin00=b
LW9[Jf][Jf/00Ve]K@03MWIfOGemOGem009mOGd2LW9b00=PH61@D51@D5000TU9B@03Cdm?GemOGemO
009`L7000g]kNginOWinOP02N7Qh00=`L71XJ6QXJ6P00V=SH`03HV9RHf=SHf=S009VIVH00fa/K79b
LW9bLP02NGUi00>1PH69RHV9RHT00Y2@T003TY:BRh^;Rh^;009iNGT00f5QHD];Bd];B`02@d=300=?
CdmYJFUYJFT00XF5Q@03Ti>CS8b<S8b<00Coool00`000?ooooooo`0@oooo000Joooo0`0000?oool0
0`000?ooooooo`02oooo00<0003oooooool00_ooo`93@d<00dA4A4I6ATI6AP02BDU900=>CTiEEEEE
EED00UaLG003IFEUKfm_Kfm_009iNGT00hB4Q8j>SXj>SP02UYJF00>NWYjSXj>SXj<00ZJVYP>WYjL2
YZJV00>TY:BRXZ:RXZ800Z6QX@03XZ:RY:BTY:BT00:XZ:P00jf][K:b/[:b/P02^KVi00>o_ko5aLG5
aLD00/c<c0;Bd]800mSHf=gMgMgMg@02hN7Q00?Ti>CVi^KVi^H00^KViP03i>CTh>3Ph>3P00;Jf]X0
0m;Bd/[:b/[:bP02`L7100>j^[Zd];Bd];@00[6a/@03/[:b]KFe]KFe00:j^[X00l71`LS8b<S8b002
c/k>00?Cdm?EeMGEeMD00]?Cd`03clo?b<S8b<S800;1`L400kVi^K>c/k>c/`02[Zj^00>/[:b][Jf]
[Jd00[6a/@03^;Rh_kno_kno00;7alL00lk>c]?Cdm?Cd`02e]KF00?GemOEeMGEeMD00]7Ad@03bl_;
aLG5aLG500:o_kl00kVi^K>c/k>c/`02[jn_00>[Zj^XZ:RXZ:P00ZJVYP03Y:BTXj>SXj>S00:RXZ80
0j>SXjFUYJFUY@02YjNW00>ZZZZ][Jf][Jd00[6a/@03];Bd][Jf][Jf00:h^;P2]kNg00>f][Jc/k>c
/k<00[2`/003[Jf]Zj^[Zj^[00>YZJT2Zj^[0Zj^[P03/K6a]KFe]KFe00:i^KT00kbl_;jn_[jn_P02
_[jn00>l_;bh^;Rh^;P00[:b/P03Zj^[Xj>SXj>S00:JVYX00i2@T8J6QXJ6QP02O7al00=bLW9YJFUY
JFT00V1PH003F5QHDE5ADE5A009;Bd/00dM7AdA4A4A4A004oooo00<0003oooooool09_ooo`<00003
oooo00<0003oooooool00oooo`040000oooooooooooo0WQhN003HV9RF5QHF5QH009RHV800gUiNIBD
U9BDU002[Jf]00>m_Kg4a<C4a<@00/71`@03/K6aTI6ATI6A009YJFT00d51@B@T92@T90026QXJ00<O
7al];Bd];Bd00S`l?003ATI6C4a<C4a<009ADE400eEEEEQHF5QHF002Fe]K00=NGUiUIFEUIFD00W5a
L@03OgmoRh^;Rh^;00:>SXh2Q8B400=bLW9OGemOGel00U9BDP03Cdm?EEEEEEEE009OGel00fa/K7Ui
NGUiN@02Q8B400>;Rh^:RXZ:RXX00WinOP03Jf][FEUIFEUI009@D5000eQHF6a/K6a/K002PX:200>?
Shn=SHf=SHd00X61P@03Lg=cKFe]KFe]009gMgL00hV9RIVIVIVIV@02WIfM00><S8a^KVi^KVh00U5A
D@03@410ADE5ADE5009HF5P00fi^KWalO7alO002NWYj00=]KFeOGemOGel00UMGE`03FUYJIVIVIVIV
009dM7@00hB4Q9>CTi>CT`02WinO00>UYJFNWYjNWYh00XN7Q`03IVIVAdM7AdM7008f=SH00c`l?5=C
De=CD`02KVi^00>2PX:7QhN7QhL00WinOP03LW9bJf][Jf][009]KFd00gIfMWemOGemO@02OGem0W9b
LP03H61PD51@D51@0099BDT00dm?CemOGemOG`02L71`00=kNg]nOWinOWh00WQhN003L71`J6QXJ6QX
009SHf<00f9RHV=SHf=SH`02IVIV00=/K6abLW9bLW800WUiN@03PH61RHV9RHV900:@T9000i:BTX^;
Rh^;R`02NGUi00=QHF5;Bd];Bd/00T=3@`03Cdm?JFUYJFUY00:5QHD00i>CThb<S8b<S004oooo00<0
003oooooool04?ooo`006_ooo`030000oooooooo00;oool00`000?ooo`000003oooo00<0003ooooo
ool00_ooo`8i>CT00cdm?DA4A4A4A002Bd];00=DE5ANGUiNGUh00VMWI`03L71`NGUiNGUi00:1PH40
0hR8R8n?Shn?S`02UIFE00>JVYZNWYjNWYh00Z2PX003XJ6QXZ:RXZ:R00NRXZ800jBTY:NWYjNWY`02
Zj^[00>`/;2e]KFe]KD00[^k^`03`L71a/K6a/K600;<c<`2d];B00?GemOKfm_Kfm/00]kNgP03hN7Q
hn?Shn?S00;Rh^800moOgm[Jf][JfP02dm?C00?;bl_3`l?3`l<00[Zj^P03/k>c[Jf][Jf]00:[Zj/0
0jb/[;2`/;2`/002][Jf00>n_[k6a/K6a/H00/g=c@03dm?Ce]KFe]KF00;EeMD00m;Bd/c<c<c<c002
aLG500>n_[jg]kNg]kL00[:b/P>`/;02];Bd00>i^KVo_kno_kl00/G5a@03bl_;clo?clo?00;Bd]80
0m?Cdm;Bd];BdP02clo?00?;bl_7alO7alL00/;2`P03_Kfm^KVi^KVi00:d];@00k2`/:f][Jf][@02
ZZZZ00>WYjNUYJFUYJD00jBTY0:VYZH2ZJVY00>/[:b`/;2`/;000[Bd]003]kNg^[Zj^[Zj00:j^[X2
^;Rh00>e]KF`/;2`/;000Z^[Z`03YZJVXZ:RXZ:R00>OWil2XZ:R0ZNWY`03[Jf]];Bd];Bd00:k^k/0
0l71`LG5aLG5a@02alO700?6a/K3`l?3`l<00[fm_@03]KFe[:b/[:b/00:QXJ400iJFUXZ:RXZ:RP02
OGem00=`L71SHf=SHf<00UQHF003CDe=A4A4A4A4008m?Cd00cTi>CLg=cLg=`04oooo00<0003ooooo
ool09_ooo`030000oooooooo00;oool00`000?ooo`000004oooo00@0003oooooooooool2MgMg00=W
IfMRHV9RHV800Vm_K`03R8R8Xj>SXj>S00:h^;P00l;2`[no_kno_`02];Bd00>OWimoOgmoOgl00U]K
F`03>CTi8b<S8b<S008O7al00bTY:CXj>SXj>P02C4a<00=HF5QNGUiNGUh00V9RHP03I6ATHf=SHf=S
00=RHV82IVIV0W1`L003OgmoRh^;Rh^;00:?Shl2QhN700=fMWIUIFEUIFD00UQHF003EEEEFe]KFe]K
009UIFD00g5aLGmoOgmoO`02Rh^;00>DU9BCTi>CTi<00XN7Q`03M7AdH61PH61P009GEeL00eiNGW1`
L71`L002QHF500>ATI6=SHf=SHd00WmoO`03Kfm_JFUYJFUY009aLG400h>3Pi>CTi>CT`02UiNG00>:
RXY`L71`L7000UEEE@03ATI6B4Q8B4Q8009HF5P00fYZJWEeMGEeM@02M7Ad00=ZJVYOGemOGel00UUI
F@03G5aLIfMWIfMW009cLg<00h20P8f=SHf=S@02UiNG00>LW9bGUiNGUiL00XB4Q003JVYZDE5ADE5A
0094A4@00da<C69RHV9RHP02O7al0hb<S09oOgl00fm_KfEUIFEUI@02IfMW00=aLG5kNg]kNg/00Win
OP9fMWH00fIVIUMGEeMGE`02DE5A00=HF5QWIfMWIfL00WQhN003Ph>3Q8B4Q8B4009mOGd00g=cLfYZ
JVYZJP03IVIV0VQXJ0=YJFT2J6QX0VUYJ@03L71`OgmoOgmo00:@T9000ifMWIbLW9bLW002RHV900=Z
JVY;Bd];Bd/00S/k>`03A4A4GEeMGEeM009iNGT00h^;RhR8R8R8R004oooo00<0003oooooool04?oo
o`006oooo`070000oooooooooooo0000oooo000000?oool300000_ooo`8a<C400cTi>D=3@d=3@`02
Cdm?00=KFe]WIfMWIfL00W=cL`03O7alPh>3Ph>300:9RHT00hf=SI6ATI6AT@02U9BD00>FUYJHV9RH
V9P00YVIV@03Vi^KW9bLW9bL00:MWId00inOWj6QXJ6QX@02Xj>S00>UYJFYZJVYZJT00Zf][@03/[:b
]kNg]kNg00:l_;`00l;2`/O7alO7a`02c<c<0]7Ad@03eMGEfMWIfMWI00;Lg=`3g]kN0]gMg@03f][J
e=CDe=CD00;=cLd00lC4a;^k^k^k^`02/k>c00>[Zj^VYZJVYZH00ZBTY003YZJVZZZZZZZZ00:b/[80
0kZj^/?3`l?3``02bl_;00?Bd];Fe]KFe]H00]KFeP03dm?Cclo?clo?00;8b<P00l;2`[bl_;bl_002
]kNg00>d];Bc/k>c/k<00[Fe]@03^KVi_[jn_[jn00;3`l<00lO7al_;bl_;b`02c/k>00??clo>c/k>
c/h00/g=c@03bl_;b<S8b<S800;5aLD00l71`Kfm_Kfm_@02^KVi00>e]KFa/K6a/K400Zj^[P03ZZZZ
YjNWYjNW00:VYZH00jFUYJNWYjNWY`02ZZZZ00>^[Zjb/[:b/[800[Ng]`03^k^k_Kfm_Kfm00:l_;`2
^KVi00>d];B][Jf][Jd00ZFUY@03WYjNV9RHV9RH00>EUID2V9RH0YnOW`03Z:RX/[:b/[:b00:l_;`0
0lC4a<_;bl_;b`03clo?0/c<c0;6a/H00kfm_K>c/k>c/`02YjNW00>IVIV;Rh^;Rh/00WalO003K6a/
GEeMGEeM009?Cdl00d92@SLg=cLg=`02<30`0b`/;0?oool20000:Oooo`070000oooooooooooo0000
oooo000000Coool200000_ooo`9hN7P00f][JfYZJVYZJP02NGUi00>DU9B/[:b/[:`00[Vi^@03]KFe
Xj>SXj>S00:;Rh/00g9bLU]KFe]KF`02BTY:00<n?Shj>SXj>SX00T10@003CDe=GEeMGEeM009[Jf/0
0g=cLgMgMgMgM`02MWIf00=cLg=^KVi^KVh00VUYJ@03IFEUIVIVIVIV009_Kfl00g]kNhN7QhN7Q`02
S8b<0XJ6QP03N7QhJVYZJVYZ009OGel00eaLG61PH61PH002J6QX00=dM7B1PH61PH400Xj>SP03V9RH
VIVIVIVI00:>SXh00g]kNfUYJFUYJ@02GemO00=UIFEdM7AdM7@00XJ6QP03Shn?RXZ:RXZ:009jNWX0
0fYZJV=SHf=SH`02JFUY00=hN7R8R8R8R8P00Xj>SP03QXJ6M7AdM7Ad009PH6000eADE5=CDe=CD`02
FUYJ00=TI6AYJFUYJFT00VMWI`03GemOFEUIFEUI009FEUH00e]KFfEUIFEUI@02L71`00=kNg^4Q8B4
Q8@00X^;R`03SHf=R8R8R8R8009iNGT00fEUIEADE5ADE002CTi>00=IFEU`L71`L7000XN7Q`03U9BD
SHf=SHf=009iNGT00f=SHeIFEUIFEP02FUYJ00=YJFUiNGUiNGT00X20P09iNGT00fUYJEQHF5QHF002
DE5A00=IFEUZJVYZJVX00WemO@03Rh^;SHf=SHf=00:7QhL00ginOWEeMGEeM@02L71`00=_Kfm^KVi^
KVh00Va/K003IVIVH61PH61P009MGEd00f=SHgEeMGEeM@02S8b<00>OWinSXj>SXj<00Y2@T003Kfm_
C4a<C4a<008i>CT00chn?UEEEEEEE@02LG5a00>3Ph>4Q8B4Q8@00oooo`80000Boooo000Koooo00L0
003oooooooooool0003oool000000oooo`030000oooooooo00;oool2<C4a00<i>CU3@d=3@d<00Tm?
C`03Fe]KIfMWIfMW009cLg<00galO8>3Ph>3P`02RHV900>=SHfATI6ATI400YBDU003UYJFV9RHV9RH
00:IVIT00i^KVibLW9bLW002WIfM00>OWinQXJ6QXJ400Z>SX`03YJFUZJVYZJVY00:][Jd00k:b/[Ng
]kNg]`02_;bl00?2`/;7alO7alL00/c<c0;AdM400mGEeMWIfMWIf@02g=cL0mkNgP;MgMd00m[Jf]CD
e=CDe002cLg=00?4a<Bk^k^k^k/00[>c/`03Zj^[YZJVYZJV00:TY:@00jJVYZZZZZZZZP02/[:b00>j
^[[3`l?3`l<00/_;b`03d];Be]KFe]KF00;Fe]H00m?Cdlo?clo?c`02b<S800?2`/:l_;bl_;`00[Ng
]`03];Bd/k>c/k>c00:e]KD00kVi^Kjn_[jn_P02`l?300?7alO;bl_;bl/00/k>cP03clo?c/k>c/k>
00;=cLd00l_;blS8b<S8b002aLG500?1`L6m_Kfm_Kd00[Vi^@03]KFe/K6a/K6a00:^[Zh00jZZZZNW
YjNWY`02YZJV00>UYJFWYjNWYjL00ZZZZP03[Zj^/[:b/[:b00:g]kL00k^k^kfm_Kfm_@02_;bl0[Vi
^@03];Bd[Jf][Jf]00:UYJD00ijNWYRHV9RHV003UIFE0YRHV0:OWil00jRXZ;:b/[:b/P02_;bl00?4
a<C;bl_;bl/00lo?c`;<c<`2a/K600>m_Kfc/k>c/k<00ZNWY`03VIVIRh^;Rh^;009lO7`00fa/K5eM
GEeMG@02Cdm?00=2@T8g=cLg=cL00S0`<0</;2`4oooo00<0003oooooool09oooo`070000oooooooo
oooo0000oooo000000Coool010000?ooooooooooo`9hN7P00f][JfYZJVYZJP02NGUi00>DU9B/[:b/
[:`00[Vi^@03]KFeXj>SXj>S00:;Rh/00g9bLU]KFe]KF`02BTY:00<n?Shj>SXj>SX00T10@003CDe=
GEeMGEeM009[Jf/00g=cLgMgMgMgM`02MWIf00=cLg=^KVi^KVh00VUYJ@03IFEUIVIVIVIV009_Kfl0
0g]kNhN7QhN7Q`02S8b<0XJ6QP03N7QhJVYZJVYZ009OGel00eaLG61PH61PH002J6QX00=dM7B1PH61
PH400Xj>SP03V9RHVIVIVIVI00:>SXh00g]kNfUYJFUYJ@02GemO00=UIFEdM7AdM7@00XJ6QP03Shn?
RXZ:RXZ:009jNWX00fYZJV=SHf=SH`02JFUY00=hN7R8R8R8R8P00Xj>SP03QXJ6M7AdM7Ad009PH600
0eADE5=CDe=CD`02FUYJ00=TI6AYJFUYJFT00VMWI`03GemOFEUIFEUI009FEUH00e]KFfEUIFEUI@02
L71`00=kNg^4Q8B4Q8@00X^;R`03SHf=R8R8R8R8009iNGT00fEUIEADE5ADE002CTi>00=IFEU`L71`
L7000XN7Q`03U9BDSHf=SHf=009iNGT00f=SHeIFEUIFEP02FUYJ00=YJFUiNGUiNGT00X20P09iNGT0
0fUYJEQHF5QHF002DE5A00=IFEUZJVYZJVX00WemO@03Rh^;SHf=SHf=00:7QhL00ginOWEeMGEeM@02
L71`00=_Kfm^KVi^KVh00Va/K003IVIVH61PH61P009MGEd00f=SHgEeMGEeM@02S8b<00>OWinSXj>S
Xj<00Y2@T003Kfm_C4a<C4a<008i>CT00chn?UEEEEEEE@02LG5a00>3Ph>4Q8B4Q8@01?ooo`030000
oooooooo013oool001[oool00`000?ooo`000002oooo00<0003oool000000oooo`030000oooooooo
00;oool2;2`/00<g=cM5ADE5ADD00UADE003I6ATLW9bLW9b009oOgl00hR8R8j>SXj>SP02TI6A00>B
TY:CTi>CTi<00Y>CT`>BTY82Ti>C00>DU9BFUYJFUYH00YVIV@03W9bLWinOWinO00:SXj<00jJVYZ^[
Zj^[Z`02[jn_00>d];Bi^KVi^KT00[jn_P03`/;2alO7alO700;<c<`2d=3@00?De=CGemOGemL00]WI
f@?Jf]X2f=SH00?De=C>c/k>c/h00/K6aP03_[jn];Bd];Bd00:/[:`00jBTY9nOWinOW`02WYjN00>P
X:2UYJFUYJD00Zf][@03][Jf_kno_kno00;8b<P00m3@d=CDe=CDe002e]KF00?De=C@d=3@d=000/_;
b`03aLG5_kno_kno00:j^[X00kNg]kJf][Jf]P02]kNg00>i^KVl_;bl_;`00/30`003`l?3a/K6a/K6
00;8b<P5b/[:00?9bLW8b<S8b<P00/K6aP03a<C4`L71`L7100:n_[h00kZj^[Jf][Jf]P02/K6a00>]
[JfZZZZZZZX00jNWY`:YZJT2[:b/00>`/;2e]KFe]KD00[Zj^P03_[jn_kno_kno00:n_[h2^[Zj00>b
/[:YZJVYZJT00YnOW`03UYJFShn?Shn?00>:RXX2Shn?0YNGU`03XZ:R[jn_[jn_00:k^k/00lK6a/o?
clo?c`02e=CD00?EeMGBd];Bd]800/_;b`03`/;2][Jf][Jf00:YZJT00iZJVXV9RHV9R@02N7Qh00=W
IfMFEUIFEUH00TI6AP03>3Ph;Bd];Bd]008U9BD00b8R8RDU9BDU9@04oooo00<0003oooooool09_oo
o`030000oooo000000;oool00`000?ooo`000004oooo00@0003oooooooooool2MgMg0fi^KP9nOWh0
0iNGUjb/[:b/[002/K6a00>PX:1oOgmoOgl00UeMG@03@d=3>CTi>CTi008n?Sh00dY:BUYJFUYJFP02
JVYZ00=hN7R3Ph>3Ph<00Xb<S003Shn?SXj>SXj>00:8R8P00h20P7MgMgMgM`02KVi^00=XJ6QWIfMW
IfL00Ve]K@03N7QhPH61PH6100:6QXH2PX:200=hN7Q]KFe]KFd00VEUI@03Hf=SIVIVIVIV009]KFd0
0gIfMX:2PX:2PP02SXj>00>GUiNHV9RHV9P00Xn?S`03P820L71`L71`009WIfL00f][JgQhN7QhN002
QXJ600><S8b5QHF5QHD00WEeM@03IFEUG5aLG5aL009OGel00f][JgUiNGUiN@03PH610WQhN09^KVh0
0fEUIF5QHF5QH@02H61P00=OGemMGEeMGEd00UUIF@03EEEEDU9BDU9B009DE5@00e]KFfEUIFEUI@02
Kfm_00=gMgMlO7alO7`00WemO@03O7alMWIfMWIf009[Jf/00emOGeEEEEEEE@02EEEE00=TI6AkNg]k
Ng/00Y2@T003VIVISHf=SHf=009cLg<00eQHF4Q8B4Q8B002CDe=00=PH61fMWIfMWH00X:2PP9lO7`0
0f][JeYJFUYJFP02DE5A00=IFEU[Jf][Jf/00WmoO`03SXj>U9BDU9BD00:@T9000hV9RH61PH61P@02
Ng]k00=gMgMbLW9bLW800Va/K003HV9RFEUIFEUI009DE5@00eYJFVe]KFe]K@02QXJ600>LW9bSXj>S
Xj<00Y6AT@03LG5aCTi>CTi>008i>CT00cdm?E9BDU9BDP02K6a/00=nOWj1PH61PH401?ooo`030000
oooooooo013oool001_oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000oooooooo
00;oool2;2`/00<g=cM5ADE5ADD00UADE003I6ATLW9bLW9b009oOgl00hR8R8j>SXj>SP02TI6A00>B
TY:CTi>CTi<00Y>CT`>BTY82Ti>C00>DU9BFUYJFUYH00YVIV@03W9bLWinOWinO00:SXj<00jJVYZ^[
Zj^[Z`02[jn_00>d];Bi^KVi^KT00[jn_P03`/;2alO7alO700;<c<`2d=3@00?De=CGemOGemL00]WI
f@?Jf]X2f=SH00?De=C>c/k>c/h00/K6aP03_[jn];Bd];Bd00:/[:`00jBTY9nOWinOW`02WYjN00>P
X:2UYJFUYJD00Zf][@03][Jf_kno_kno00;8b<P00m3@d=CDe=CDe002e]KF00?De=C@d=3@d=000/_;
b`03aLG5_kno_kno00:j^[X00kNg]kJf][Jf]P02]kNg00>i^KVl_;bl_;`00/30`003`l?3a/K6a/K6
00;8b<P5b/[:00?9bLW8b<S8b<P00/K6aP03a<C4`L71`L7100:n_[h00kZj^[Jf][Jf]P02/K6a00>]
[JfZZZZZZZX00jNWY`:YZJT2[:b/00>`/;2e]KFe]KD00[Zj^P03_[jn_kno_kno00:n_[h2^[Zj00>b
/[:YZJVYZJT00YnOW`03UYJFShn?Shn?00>:RXX2Shn?0YNGU`03XZ:R[jn_[jn_00:k^k/00lK6a/o?
clo?c`02e=CD00?EeMGBd];Bd]800/_;b`03`/;2][Jf][Jf00:YZJT00iZJVXV9RHV9R@02N7Qh00=W
IfMFEUIFEUH00TI6AP03>3Ph;Bd];Bd]008U9BD00b8R8RDU9BDU9@04oooo00<0003oooooool09ooo
o`030000oooooooo00;oool00`000?ooooooo`03oooo00@0003oooooooooool2MgMg0fi^KP9nOWh0
0iNGUjb/[:b/[002/K6a00>PX:1oOgmoOgl00UeMG@03@d=3>CTi>CTi008n?Sh00dY:BUYJFUYJFP02
JVYZ00=hN7R3Ph>3Ph<00Xb<S003Shn?SXj>SXj>00:8R8P00h20P7MgMgMgM`02KVi^00=XJ6QWIfMW
IfL00Ve]K@03N7QhPH61PH6100:6QXH2PX:200=hN7Q]KFe]KFd00VEUI@03Hf=SIVIVIVIV009]KFd0
0gIfMX:2PX:2PP02SXj>00>GUiNHV9RHV9P00Xn?S`03P820L71`L71`009WIfL00f][JgQhN7QhN002
QXJ600><S8b5QHF5QHD00WEeM@03IFEUG5aLG5aL009OGel00f][JgUiNGUiN@03PH610WQhN09^KVh0
0fEUIF5QHF5QH@02H61P00=OGemMGEeMGEd00UUIF@03EEEEDU9BDU9B009DE5@00e]KFfEUIFEUI@02
Kfm_00=gMgMlO7alO7`00WemO@03O7alMWIfMWIf009[Jf/00emOGeEEEEEEE@02EEEE00=TI6AkNg]k
Ng/00Y2@T003VIVISHf=SHf=009cLg<00eQHF4Q8B4Q8B002CDe=00=PH61fMWIfMWH00X:2PP9lO7`0
0f][JeYJFUYJFP02DE5A00=IFEU[Jf][Jf/00WmoO`03SXj>U9BDU9BD00:@T9000hV9RH61PH61P@02
Ng]k00=gMgMbLW9bLW800Va/K003HV9RFEUIFEUI009DE5@00eYJFVe]KFe]K@02QXJ600>LW9bSXj>S
Xj<00Y6AT@03LG5aCTi>CTi>008i>CT00cdm?E9BDU9BDP02K6a/00=nOWj1PH61PH401?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0R`/;003>SXjBTY:BTY:009LG5`00fi^KWin
OWinOP02Rh^;00>DU9BHV9RHV9P00YVIV@03V9RHUYJFUYJF00:CTi<00i2@T8j>SXj>SP02SHf=00>?
ShnBTY:BTY800YFEU@03VIVIWYjNWYjN00:RXZ800jNWYjb/[:b/[002/K6a00>e]KFj^[Zj^[X00[jn
_P03`l?3alO7alO700;;bl/2clo?00?Bd];EeMGEeMD00]KFeP03emOGe]KFe]KF00;De=@00lo?clW9
bLW9b@02`L7100>h^;R^[Zj^[Zh00ZJVYP03WYjNVIVIVIVI00:HV9P00iZJVZ2PX:2PX002YjNW00>a
/K6k^k^k^k/00/C4a003c<c<dM7AdM7A00;De=@00m?Cdm3@d=3@d002c<c<00?7alO2`/;2`/800[fm
_@03^[Zj^;Rh^;Rh00:h^;P00kVi^K^k^k^k^`02_;bl00>n_[k0`<30`<000/;2`P03a<C4aLG5aLG5
00S6a/H2a<C40/71`@03_Kfm^KVi^KVi00:e]KD00k2`/:b/[:b/[002ZZZZ00>YZJV[Zj^[Zj/00Zj^
[P03/k>c^;Rh^;Rh00:m_Kd00l71`L;2`/;2`P02`<300[Zj^P03/K6aYZJVYZJV00:KVi/00i2@T8N7
QhN7Q`02PX:200>1PH66QXJ6QXH00Y2@T003W9bLZj^[Zj^[00:i^KT00lK6a]3@d=3@d002e]KF00?G
emODe=CDe=@00/c<c003`L71];Bd];Bd00:VYZH00iFEUHB4Q8B4Q002LW9b00=OGem>CTi>CTh00Shn
?P03<30`9BDU9BDU008N7Qh00adM7B8R8R8R8P04oooo00<0003oooooool0<_ooo`040000oooooooo
oooo0WQhN003K6a/JFUYJFUY009eMGD00hZ:RYZJVYZJVP02Vi^K00>5QHERHV9RHV800Shn?P03:BTY
:b/[:b/[008o?cl00e]KFgMgMgMgM`02Rh^;00>GUiNNWYjNWYh00Z6QX@03WinOVIVIVIVI00:@T900
0hF5QG]kNg]kN`02LW9b00=]KFe[Jf][Jf/00Vi^KP03M7AdNg]kNg]k009mOGd2NWYj00=cLg=[Jf][
Jf/00fMWI`9]KFd2M7Ad00=kNg^3Ph>3Ph<00XV9R@03SHf=S8b<S8b<00:6QXH00g]kNg5aLG5aL@02
K6a/00=aLG5lO7alO7`00XJ6QP03R8R8OgmoOgmo009_Kfl00eiNGUADE5ADE002E5AD00=MGEeYJFUY
JFT00WAdM003NWYjO7alO7al009kNg/00gMgMg1`L71`L002J6QX00=OGemGEeMGEeL00U9BDP03D51@
DU9BDU9B009GEeL00emOGfUYJFUYJ@02LG5a0gIfMP9cLg<00fe]KFIVIVIVIP02GemO00=HF5QEEEEE
EED00U]KF`03Jf][PH61PH6100:DU9@00iZJVXb<S8b<S002LG5a00=DE5A4A4A4A4@00TU9B@03GEeM
M7AdM7Ad00:2PX82Ogmo00=`L71QHF5QHF400UQHF003G5aLJFUYJFUY009iNGT00hN7Qhj>SXj>SP02
T92@00>?Shn:RXZ:RXX00XB4Q003Ng]kLW9bLW9b009XJ6P00eaLG5=CDe=CD`02CTi>00=DE5AVIVIV
IVH00WmoO`03UIFEW9bLW9bL00:=SHd00fm_Ke1@D51@D002?Shn00=2@T9GEeMGEeL00W1`L003PH61
PX:2PX:200Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`8`<3000d10@5=C
De=CD`02IfMW00=jNWZ;Rh^;Rh/00YRHV003X:2PXj>SXj>S00:RXZ800ijNWYVIVIVIV@02U9BD00>?
Shn;Rh^;Rh/00XZ:RP03Rh^;SXj>SXj>00:CTi<00iRHV9fMWIfMW@02Xj>S00>XZ:R][Jf][Jd00[:b
/P03]kNg^k^k^k^k00:o_kl00l?3`lO7alO7a`02bl_;0/k>cP03dM7Adm?Cdm?C00;De=@00mGEeMCD
e=CDe002dM7A00?<c<c5aLG5aLD00[fm_@03/k>cZZZZZZZZ00:QXJ400iZJVYFEUIFEU@02Ti>C00>E
UIFKVi^KVi/00Z:RXP03[:b/][Jf][Jf00:o_kl00lO7alg=cLg=c@03d=3@0/k>cP;;bl/00lO7al?3
`l?3``02_[jn00>k^k^i^KVi^KT01KRh^0:i^KT00kZj^[^k^k^k^`02_;bl00>n_[jo_kno_kl00/71
`@03`/;2a<C4a<C400G5aLD2`l?300?0`<2l_;bl_;`00[Rh^003/k>c[jn_[jn_00>][Jd2[Zj^0[:b
/P03]kNg_;bl_;bl00;1`L400lC4a<G5aLG5a@02`/;20[^k^`03/K6aYJFUYJFU00:HV9P00h^;Rh:2
PX:2PP02Ng]k00=jNWYoOgmoOgl00XZ:RP03UiNGYjNWYjNW00:f][H00lC4a<k>c/k>cP03eMGE0]7A
d@;8b<P00k^k^jf][Jf][@02WIfM00><S8ajNWYjNWX00VQXJ003EUIFATI6ATI6008g=cL00bXZ:R4Q
8B4Q8@0271`L00<M7AdT92@T92@01?ooo`030000oooooooo03;oool010000?ooooooooooo`9jNWX0
0fIVIUYJFUYJFP02GEeM00=YJFUeMGEeMGD00WQhN003JVYZDe=CDe=C008n?Sh00cDe=Cdm?Cdm?@02
E5AD00=^KVj6QXJ6QXH00YNGU`03WinOXZ:RXZ:R00:PX:000i^KVi:BTY:BTP02R8R800=oOgmhN7Qh
N7P00W=cL`=aLG42LW9b00=cLg=dM7AdM7@00W=cL`9_Kfl00fUYJFATI6ATI002I6AT00=YJFUcLg=c
Lg<00WemO@>3Ph<2OWin00=hN7QbLW9bLW800Ve]K@03Jf][JVYZJVYZ009]KFd00gEeMGinOWinOP03
QHF50WYjNP9YJFT00eQHF4a<C4a<C002BDU900=?CdmIFEUIFET00VIVIP03Lg=cOWinOWin00:6QXH0
0hN7Qh20P820P002LW9b00=TI6AIFEUIFET00UADE003EUIFFe]KFe]K009SHf<00f][Jg9bLW9bLP02
N7Qh00=iNGUeMGEeMGD00Vi^KP03IFEUGEeMGEeM009HF5P00eIFEUMGEeMGE`02GemO00=^KVj0P820
P8000Xn?S`03U9BDR8R8R8R8009cLg<00eeMGE1@D51@D002De=C00=RHV9cLg=cLg<00WmoO`:1PH40
0gYjNW5aLG5aL@02JVYZ00=VIVIWIfMWIfL00VYZJP03L71`NGUiNGUi00:2PX800hZ:RXb<S8b<S002
QXJ600=kNg]^KVi^KVh00V1PH003EEEECdm?Cdm?009<C4`00e=CDf=SHf=SH`02N7Qh00>:RXZ@T92@
T9000XB4Q003Jf][DU9BDU9B0095ADD00di>CVIVIVIVIP02P82000>?Shn;Rh^;Rh/01?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0S0`<003@410De=CDe=C009WIfL00gYjNX^;
Rh^;R`02V9RH00>PX:2SXj>SXj<00Z:RXP03WYjNVIVIVIVI00:DU9@00hn?Sh^;Rh^;R`02RXZ:00>;
Rh^>SXj>SXh00Y>CT`03V9RHWIfMWIfM00:SXj<00jRXZ:f][Jf][@02/[:b00>g]kNk^k^k^k/00[no
_`03`l?3alO7alO700;;bl/2c/k>00?AdM7Cdm?Cdm<00]CDe003eMGEe=CDe=CD00;AdM400lc<c<G5
aLG5a@02_Kfm00>c/k>ZZZZZZZX00Z6QX@03VYZJUIFEUIFE00:CTi<00iFEUI^KVi^KV`02XZ:R00>/
[:bf][Jf][H00[no_`03alO7cLg=cLg=00?@d=02c/k>0/_;b`03alO7`l?3`l?300:n_[h00k^k^kVi
^KVi^@05^;Rh0[Vi^@03^[Zj^k^k^k^k00:l_;`00kjn_[no_kno_`02`L7100?2`/;4a<C4a<@01LG5
a@;3`l<00l30`;bl_;bl_002^;Rh00>c/k>_[jn_[jl00jf][@:^[Zh2/[:b00>g]kNl_;bl_;`00/71
`@03a<C4aLG5aLG500;2`/82^k^k00>a/K6UYJFUYJD00YRHV003Rh^;PX:2PX:2009kNg/00gYjNWmo
OgmoO`02RXZ:00>GUiNWYjNWYjL00[Jf]P03a<C4c/k>c/k>00?EeMD2dM7A0/S8b003^k^k[Jf][Jf]
00:MWId00hb<S7YjNWYjNP02J6QX00=FEUI6ATI6ATH00SLg=`03:RXZ8B4Q8B4Q008L71`00adM7B@T
92@T9004oooo00<0003oooooool0<_ooo`040000oooooooooooo0WYjNP03IVIVFUYJFUYJ009MGEd0
0fUYJGEeMGEeM@02N7Qh00=ZJVYCDe=CDe<00Shn?P03=CDe?Cdm?Cdm009DE5@00fi^KXJ6QXJ6QP02
UiNG00>OWinRXZ:RXZ800Z2PX003Vi^KTY:BTY:B00:8R8P00gmoOgQhN7QhN002Lg=c0g5aL@9bLW80
0g=cLgAdM7AdM002Lg=c0Vm_K`03JFUYI6ATI6AT009TI6@00fUYJG=cLg=cL`02OGem0h>3P`9nOWh0
0gQhN79bLW9bLP02KFe]00=[Jf]ZJVYZJVX00Ve]K@03MGEeOWinOWin00>5QHD2NWYj0VUYJ@03F5QH
C4a<C4a<0099BDT00dm?CeUIFEUIF@02IVIV00=cLg=nOWinOWh00XJ6QP03QhN7P820P820009bLW80
0fATI5UIFEUIF@02E5AD00=FEUIKFe]KFe/00V=SH`03Jf][LW9bLW9b009hN7P00gUiNGEeMGEeM@02
KVi^00=UIFEMGEeMGEd00UQHF003EUIFEeMGEeMG009OGel00fi^KX20P820P002Shn?00>DU9B8R8R8
R8P00W=cL`03GEeMD51@D51@009CDe<00f9RHW=cLg=cL`02Ogmo0X61P@03NWYjLG5aLG5a009ZJVX0
0fIVIVMWIfMWI`02JVYZ00=`L71iNGUiNGT00X:2PP03RXZ:S8b<S8b<00:6QXH00g]kNfi^KVi^KP02
H61P00=EEEE?Cdm?Cdl00Ta<C003De=CHf=SHf=S009hN7P00hZ:RY2@T92@T002Q8B400=[Jf]BDU9B
DU800TE5A@03CTi>IVIVIVIV00:0P8000hn?Sh^;Rh^;R`04oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool2>CTi00=;Bd]OGemOGel00W=cL`03QhN7V9RHV9RH00:TY:@00j^[Zjf]
[Jf][@02ZZZZ00>TY:BMWIfMWId00YJFUP03Shn?Rh^;Rh^;00:9RHT00hZ:RXf=SHf=S@02TI6A00>G
UiNMWIfMWId00Z>SX`03ZJVY[Zj^[Zj^00:c/k<00kRh^;bl_;bl_002`<3000?3`l?7alO7alL00/[:
bP;=cLd00m3@d=;Bd];BdP03dm?C0];BdP;?cll00l[:b/;2`/;2`P02^[Zj00>`/;2WYjNWYjL00YjN
WP03UYJFTI6ATI6A00:?Shl00i6ATIJFUYJFUP02WIfM00>VYZJ`/;2`/;000[Vi^@03`L71alO7alO7
00;;bl/00lc<c<_;bl_;b`02bLW900?6a/K2`/;2`/800[no_`03_;bl^KVi^KVi00:g]kL3][Jf1KFe
]@:f][H00kRh^;Vi^KVi^@02^k^k00>n_[k0`<30`<000/;2`P?4a<@2`l?300?1`L6n_[jn_[h00[Zj
^P03][Jf/k>c/k>c00>a/K42/k>c0[Jf]P03^k^k`<30`<3000;4a<@3alO70/C4a0:l_;`00k6a/JBT
Y:BTY002UYJF00>9RHUnOWinOWh00WQhN003MWIfNg]kNg]k00:5QHD00i>CTj>SXj>SX`02/[:b00?0
`<3:b/[:b/X00]3@d003clo?bLW9bLW900:o_kl00k6a/J6QXJ6QX@02T92@00=nOWi/K6a/K6`00U]K
F`03Bd];?Cdm?Cdm008a<C400bLW9b4Q8B4Q8@027QhN00<R8R8[:b/[:b/01?ooo`030000oooooooo
03;oool010000?ooooooooooo`9mOGd00eiNGTI6ATI6AP02?3`l00<o?cm7AdM7AdL00Ti>CP=BDU82
E5AD00=JFUYUIFEUIFD00W=cL`03P820RXZ:RXZ:00:ATI43U9BD0Y2@T003R8R8OWinOWin009eMGD0
0fm_Kfi^KVi^KP02LG5a00=fMWIhN7QhN7P00WMgM`03Lg=cKfm_Kfm_009YJFT2HV9R00=MGEeJFUYJ
FUX00UeMG@03JFUYN7QhN7Qh00:6QXH00h^;Rh:2PX:2PP02LG5a00=NGUi@D51@D5000Te=C@03De=C
GUiNGUiN009ZJVX00gIfMWmoOgmoO`02Q8B400>2PX9gMgMgMgL00VEUI@03De=CADE5ADE50090@400
0dA4A4e=CDe=C@02Fe]K00=]KFenOWinOWh00Xf=S@03TY:BS8b<S8b<009nOWh00fe]KF5QHF5QH@02
GUiN00=SHf=ZJVYZJVX00W=cL`03NWYjOgmoOgmo00:1PH400ginOWMgMgMgM`02KFe]00=RHV9JFUYJ
FUX00eIFEP9KFe/2Hf=S00=^KVijNWYjNWX00XF5Q@03RHV9Q8B4Q8B4009iNGT00fi^KVIVIVIVIP02
IVIV00=/K6acLg=cLg<00W]kN`:2PX83QXJ60X61P@03M7AdI6ATI6AT009FEUH00e5ADEYJFUYJFP02
Jf][00=nOWj8R8R8R8P00XB4Q003MgMgIVIVIVIV009GEeL00dm?Cde=CDe=C@02Cdm?00=FEUISHf=S
Hf<00W5aL@03OWinPX:2PX:2009gMgL00fEUIE=CDe=CD`02Cdm?00=NGUiiNGUiNGT00YBDU003XJ6Q
UiNGUiNG00Coool00`000?ooooooo`0@oooo000Uoooo0P0000?oool2>CTi00=;Bd]OGemOGel00W=c
L`03QhN7V9RHV9RH00:TY:@00j^[Zjf][Jf][@02ZZZZ00>TY:BMWIfMWId00YJFUP03Shn?Rh^;Rh^;
00:9RHT00hZ:RXf=SHf=S@02TI6A00>GUiNMWIfMWId00Z>SX`03ZJVY[Zj^[Zj^00:c/k<00kRh^;bl
_;bl_002`<3000?3`l?7alO7alL00/[:bP;=cLd00m3@d=;Bd];BdP03dm?C0];BdP;?cll00l[:b/;2
`/;2`P02^[Zj00>`/;2WYjNWYjL00YjNWP03UYJFTI6ATI6A00:?Shl00i6ATIJFUYJFUP02WIfM00>V
YZJ`/;2`/;000[Vi^@03`L71alO7alO700;;bl/00lc<c<_;bl_;b`02bLW900?6a/K2`/;2`/800[no
_`03_;bl^KVi^KVi00:g]kL3][Jf1KFe]@:f][H00kRh^;Vi^KVi^@02^k^k00>n_[k0`<30`<000/;2
`P?4a<@2`l?300?1`L6n_[jn_[h00[Zj^P03][Jf/k>c/k>c00>a/K42/k>c0[Jf]P03^k^k`<30`<30
00;4a<@3alO70/C4a0:l_;`00k6a/JBTY:BTY002UYJF00>9RHUnOWinOWh00WQhN003MWIfNg]kNg]k
00:5QHD00i>CTj>SXj>SX`02/[:b00?0`<3:b/[:b/X00]3@d003clo?bLW9bLW900:o_kl00k6a/J6Q
XJ6QX@02T92@00=nOWi/K6a/K6`00U]KF`03Bd];?Cdm?Cdm008a<C400bLW9b4Q8B4Q8@027QhN00<R
8R8[:b/[:b/00oooo`80000doooo00@0003oooooooooool2OGem00=NGUi6ATI6ATH00S`l?003?clo
AdM7AdM7009>CTh3DU9B0UADE003FUYJIFEUIFEU009cLg<00h20P8Z:RXZ:RP02TI6A0iBDU0:@T900
0hR8R7inOWinOP02MGEe00=_Kfm^KVi^KVh00W5aL@03MWIfN7QhN7Qh009gMgL00g=cLfm_Kfm_K`02
JFUY0V9RHP03GEeMFUYJFUYJ009MGEd00fUYJGQhN7QhN002QXJ600>;Rh^2PX:2PX800W5aL@03GUiN
D51@D51@009=CDd00e=CDeiNGUiNGP02JVYZ00=fMWIoOgmoOgl00XB4Q003PX:2MgMgMgMg009UIFD0
0e=CDdE5ADE5A@02@41000=4A4A=CDe=CDd00U]KF`03KFe]OWinOWin00:=SHd00i:BTXb<S8b<S002
OWin00=]KFeQHF5QHF400UiNGP03Hf=SJVYZJVYZ009cLg<00gYjNWmoOgmoO`02PH6100=nOWigMgMg
MgL00Ve]K@03HV9RFUYJFUYJ00=FEUH2Fe]K0V=SH`03KVi^NWYjNWYj00:5QHD00hV9RHB4Q8B4Q002
NGUi00=^KViVIVIVIVH00VIVIP03K6a/Lg=cLg=c009kNg/2PX:20hJ6QP:1PH400gAdM6ATI6ATI002
EUIF00=ADE5JFUYJFUX00V][J`03OWinR8R8R8R800:4Q8@00gMgMfIVIVIVIP02EeMG00=?Cdm=CDe=
CDd00Tm?C`03EUIFHf=SHf=S009aLG400ginOX:2PX:2PP02MgMg00=UIFECDe=CDe<00Tm?C`03GUiN
NGUiNGUi00:DU9@00j6QXINGUiNGU`03oooo0P0001;oool002Goool00`000?ooooooo`02oooo0TE5
A@03F5QHK6a/K6a/00:1PH400iBDU:BTY:BTY002/;2`0kFe]@:a/K400jZZZZ:RXZ:RXP02VIVI00>A
TI6;Rh^;Rh/00hV9R@:<S8`2TI6A00>FUYJLW9bLW9`00Z>SX`03ZJVY[jn_[jn_00:d];@00kRh^;bl
_;bl_002`<3000?4a<C7alO7alL00/[:bP;=cLd00m3@d=;Bd];BdP02dm?C00?Bd];AdM7AdM400/k>
cP03b<S8`L71`L7100:h^;P00jn_[jFUYJFUY@02W9bL00>DU9B?Shn?Shl00Xf=S@03SXj>TY:BTY:B
00:IVIT00j6QXJZZZZZZZP02/k>c00>k^k_1`L71`L400/G5a@?7alL2a/K600?4a<C1`L71`L400[jn
_P03_;bl^KVi^KVi00:g]kL00kFe]K>c/k>c/`02/[:b00>a/K6`/;2`/;000[6a/@03/[:b/k>c/k>c
00:f][H00kVi^Kbl_;bl_002_kno00?1`L72`/;2`/800/;2`P03`L71_kno_kno00:l_;`00kVi^KNg
]kNg]`03]KFe0[Ng]`:k^k/00kno_lC4a<C4a002b<S800?:b/[9bLW9bLT00/G5a@:m_Kd00k:b/ZBT
Y:BTY002UYJF00>8R8QmOGemOGd00WIfMP03M7AdN7QhN7Qh00:2PX800hn?SijNWYjNWP02[Jf]00>j
^[[4a<C4a<@00/S8b003a/K6_[jn_[jn00:b/[800j>SXi:BTY:BTP02P82000=^KViMGEeMGEd00Te=
C@03@410=CDe=CDe008/;2`00bHV9R<S8b<S8`0292@T00<[:b/f=SHf=SH01?ooo`030000oooooooo
03;oool010000?ooooooooooo`9oOgl00eQHF3Hf=SHf=P028B4Q00<K6a/N7QhN7Qh00RXZ:P03?Shn
EUIFEUIF009_Kfl00hB4Q8n?Shn?S`02TI6A00>=SHf8R8R8R8P00XF5Q@03Ph>3P820P820009jNWX0
0g5aLFIVIVIVIP02GUiN00=LG5aRHV9RHV800Ve]K@03NGUiOgmoOgmo009mOGd00gEeMF][Jf][J`02
H61P0UMGE`03DE5ACdm?Cdm?009FEUH00fMWIgalO7alO002SHf=00>ATI61PH61PH400VEUI@03ATI6
<S8b<S8b008`<3000c`l?4m?Cdm?C`02Hf=S00=dM7AnOWinOWh00XB4Q003PH61MGEeMGEe009TI6@0
0e5ADD92@T92@P02>c/k00<m?Ce5ADE5ADD00UADE003J6QXOGemOGem00:?Shl00iRHV9BDU9BDU002
R8R800=hN7Q]KFe]KFd00V][J`03L71`N7QhN7Qh00:1PH400hJ6QXV9RHV9R@02R8R800>4Q8AkNg]k
Ng/00Vm_K`03HV9RFUYJFUYJ009GEeL00eUIFEiNGUiNGP02IFEU00=]KFecLg=cLg<00WQhN003O7al
OWinOWin009oOgl00ginOWalO7alO002N7Qh00=eMGEcLg=cLg<00WIfMP:1PH400hn?SiVIVIVIV@02
UYJF00>1PH5QHF5QHF400T=3@`03<c<c?3`l?3`l009EEED00g5aLH:2PX:2PP02PH6100=aLG5NGUiN
GUh00Tm?C`03Bd];Cdm?Cdm?009GEeL00emOGfMWIfMWI`02KFe]00=cLg=bLW9bLW800VYZJP03GUiN
EEEEEEEE009HF5P00fe]KH^;Rh^;R`02YJFU00>_[jnPX:2PX:001?ooo`030000oooooooo013oool0
02Goool00`000?ooooooo`02oooo0UADE003IVIVNWYjNWYj00:>SXh00j2PX:n_[jn_[`02^KVi00>n
_[jm_Kfm_Kd00[Ng]`03[jn_YZJVYZJV00:LW9`00i>CThb<S8b<S003RHV90Xb<S0:@T9000iJFUYbL
W9bLW002XZ:R00>YZJV_[jn_[jl00[Bd]003^;Rh_;bl_;bl00;0`<000lC4a<O7alO7a`02b/[:0/g=
c@03d=3@d];Bd];B00?Cdm<2dM7A0/g=c@03b<S8`L71`L7100:h^;P00jj^[ZBTY:BTY002Vi^K00>C
Ti>=SHf=SHd00XZ:RP03Rh^;SXj>SXj>00:DU9@00ibLW:BTY:BTY002[:b/00>d];Bj^[Zj^[X00[no
_`03`L71`/;2`/;200;2`/800l71`L30`<30`002_[jn00>k^k^i^KVi^KT00[Jf]P03];Bd/K6a/K6a
00:_[jl00jf][Jb/[:b/[002Zj^[00>/[:b^[Zj^[Zh00[6a/@03];Bd]kNg]kNg00:k^k/00kjn_/30
`<30`003`L710/30`0:n_[h00kbl_;^k^k^k^`03^[Zj0[bl_0;0`<000l?3`lO7alO7a`02bl_;00?<
c<c;bl_;bl/00/O7a`:n_[h00k:b/ZFUYJFUY@02UYJF00>9RHUmOGemOGd00WIfMP03Lg=cMgMgMgMg
00:0P8000hb<S9ZJVYZJVP02Z:RX00>c/k>k^k^k^k/00[jn_P03^[Zj/K6a/K6a00:SXj<00i:BTX20
P820P002KVi^00=MGEe=CDe=CDd00Slo?`03=CDe;Rh^;Rh^008Y:BT00bLW9bPX:2PX:002;Bd]00<f
=SI3@d=3@d<01?ooo`030000oooooooo03;oool010000?ooooooooooo`9nOWh00eQHF3@d=3@d=002
6QXJ00<<30`:2PX:2PX00QLG5`03=3@dFe]KFe]K00:3Ph<00inOWjVYZJVYZ@02XZ:R00>BTY:2PX:2
PX800WUiN@03M7AdL71`L71`009ZJVX00f1PH5EEEEEEE@02CDe=00=>CTiIFEUIFET00VUYJ@03NGUi
PX:2PX:200:1PH400gIfMVUYJFUYJ@02G5aL0U9BDP03C4a<BTY:BTY:009BDU800fEUIGemOGemO@02
TI6A00>DU9B1PH61PH400UmOG`03>c/k8b<S8b<S008O7al00b`/;451@D51@@02F5QH00=]KFekNg]k
Ng/00hF5Q@9jNWX2J6QX00=CDe=3@d=3@d<00S/k>`03?3`lA4A4A4A4009BDU800fATI7QhN7QhN002
RXZ:0iFEU@:=SHd00h:2PWUiNGUiN@02MgMg00=jNWYoOgmoOgl00XB4Q003RHV9S8b<S8b<00:<S8`0
0hR8R7inOWinOP02LG5a00=SHf=JFUYJFUX00UQHF003G5aLHf=SHf=S009ZJVX00fe]KFm_Kfm_K`02
L71`00=cLg=iNGUiNGT00X20P003QhN7R8R8R8R800:2PX800gQhN6m_Kfm_K`02Kfm_0WemO@03TI6A
XZ:RXZ:R00:QXJ400hV9RF5QHF5QH@02>CTi00<T92@[:b/[:b/00TM7A`03J6QXOGemOGem009mOGd0
0fa/K5UIFEUIF@02Bd];00=<C4aFEUIFEUH00V9RHP03Jf][Kfm_Kfm_009^KVh00fa/K6MWIfMWI`02
H61P00=IFEUGEeMGEeL00UiNGP03Lg=cSXj>SXj>00:UYJD00jf][IjNWYjNWP04oooo00<0003ooooo
ool04?ooo`009Oooo`030000oooooooo00;oool2E5AD00=VIVIjNWYjNWX00Xj>SP03X:2P[jn_[jn_
00:i^KT00kjn_[fm_Kfm_@02]kNg00>_[jnVYZJVYZH00YbLW003Ti>CS8b<S8b<00>9RHT2S8b<0Y2@
T003UYJFW9bLW9bL00:RXZ800jVYZJn_[jn_[`02];Bd00>h^;Rl_;bl_;`00/30`003a<C4alO7alO7
00;:b/X2cLg=00?@d=3Bd];Bd]800m?Cd`;AdM42cLg=00?8b<S1`L71`L400[Rh^003[Zj^Y:BTY:BT
00:KVi/00i>CThf=SHf=S@02RXZ:00>;Rh^>SXj>SXh00YBDU003W9bLY:BTY:BT00:/[:`00kBd];Zj
^[Zj^P02_kno00?1`L72`/;2`/800/;2`P03`L71`<30`<3000:n_[h00k^k^kVi^KVi^@02][Jf00>d
];Ba/K6a/K400Zn_[`03[Jf][:b/[:b/00:[Zj/00jb/[:j^[Zj^[P02/K6a00>d];Bg]kNg]kL00[^k
^`03_[jn`<30`<3000?1`L42`<300[jn_P03_;bl^k^k^k^k00>j^[X2_;bl0/30`003`l?3alO7alO7
00;;bl/00lc<c<_;bl_;b`02alO70[jn_P03/[:bYJFUYJFU00:FUYH00hV9RGemOGemO@02MWIf00=c
Lg=gMgMgMgL00X20P003S8b<VYZJVYZJ00:XZ:P00k>c/k^k^k^k^`02_[jn00>j^[Za/K6a/K400Z>S
X`03TY:BP820P820009^KVh00eeMGDe=CDe=C@02?clo00<e=CD^;Rh^;Rh00RTY:@039bLW:2PX:2PX
008];Bd00cHf=T=3@d=3@`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WinOP03F5QH
=3@d=3@d008J6QX00``<30X:2PX:2P025aLG00<d=3AKFe]KFe/00X>3P`03WinOZJVYZJVY00:RXZ80
0i:BTX:2PX:2PP02NGUi00=dM7A`L71`L7000VYZJP03H61PEEEEEEEE009=CDd00di>CUUIFEUIF@02
JFUY00=iNGV2PX:2PX800X61P@03MWIfJFUYJFUY009LG5`2DU9B00=<C4a:BTY:BTX00U9BDP03IFEU
OGemOGem00:ATI400iBDU861PH61P@02GemO00<k>c/S8b<S8b<00QlO7`03;2`/@D51@D51009HF5P0
0fe]KG]kNg]kN`03QHF50WYjNP9XJ6P00e=CDd=3@d=3@`02>c/k00<l?3a4A4A4A4@00U9BDP03I6AT
N7QhN7Qh00::RXX3UIFE0Xf=S@03PX:2NGUiNGUi009gMgL00gYjNWmoOgmoO`02Q8B400>9RHV<S8b<
S8`00Xb<S003R8R8OWinOWin009aLG400f=SHeYJFUYJFP02F5QH00=LG5aSHf=SHf<00VYZJP03KFe]
Kfm_Kfm_009`L7000g=cLgUiNGUiN@02P82000>7QhN8R8R8R8P00X:2PP03N7QhKfm_Kfm_009_Kfl2
OGem00>ATI6RXZ:RXZ800Z6QX@03RHV9HF5QHF5Q008i>CT00b@T92/[:b/[:`02AdM700=XJ6QmOGem
OGd00WemO@03K6a/FEUIFEUI009;Bd/00da<C5IFEUIFEP02HV9R00=[Jf]_Kfm_Kfl00Vi^KP03K6a/
IfMWIfMW009PH6000eUIFEMGEeMGE`02GUiN00=cLg>>SXj>SXh00ZFUY@03[Jf]WYjNWYjN00Coool0
0`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9SHf<00gEeMHR8R8R8R002Vi^K00>[
Zj^i^KVi^KT00/71`@03a<C4`/;2`/;200:l_;`00k>c/jVYZJVYZ@02WYjN00>EUIF>SXj>SXh00XZ:
RP03RHV9Rh^;Rh^;00:?Shl00iFEUI^KVi^KV`02XJ6Q00>XZ:R^[Zj^[Zh00[>c/`03^;Rh_;bl_;bl
00;0`<000lC4a<O7alO7a`02bl_;0/k>cP03dM7Ad];Bd];B00?Cdm<2dM7A0/k>cP03b<S8`L71`L71
00:h^;P00jj^[ZBTY:BTY002Vi^K00>CTi><S8b<S8`00hV9R@:<S8`2T92@00>GUiNNWYjNWYh00ZJV
YP03[Jf]];Bd];Bd00:i^KT00kbl_;jn_[jn_P05_kno0[fm_@03^k^k^KVi^KVi00:f][H00k>c/k2`
/;2`/002[Jf]00>ZZZZXZ:RXZ:P00jNWY`:YZJT2[:b/00>_[jnc/k>c/k<00[Ng]`03^k^k_[jn_[jn
00:o_kl5`<3000>o_knn_[jn_[h00[jn_P03_kno`L71`L7100;4a<@00lO7al[:b/[:bP02cLg=00?>
c/k<c<c<c<`00/O7a`:n_[h00k>c/jFUYJFUY@02UiNG00>:RXYnOWinOWh00WIfMP03M7AdMWIfMWIf
009nOWh00hV9RIFEUIFEU@02XJ6Q00>[Zj^b/[:b/[800[>c/`03[Zj^Xj>SXj>S00:CTi<00h:2PVm_
Kfm_K`02GEeM00=<C4`n?Shn?Sh00S<c<`03;2`/:BTY:BTY008X:2P00bXZ:Rl_;bl_;`02=cLg00=3
@d=BDU9BDU801?ooo`030000oooooooo03;oool010000?ooooooooooo`9hN7P00f5QHDM7AdM7A`02
<30`00<N7QhE5ADE5AD00QdM7@03=cLgGEeMGEeM00:5QHD00j6QXJRXZ:RXZ002WYjN00><S8akNg]k
Ng/00W5aL@03KVi^Jf][Jf][009WIfL00eeMGE5ADE5AD@02BDU900=:BTYEEEEEEED00VMWI`03N7Qh
PX:2PX:200:1PH400gQhN6a/K6a/K002GemO0UEEE@03Cdm?CDe=CDe=009DE5@00fIVIWalO7alO002
Shn?00>CTi>3Ph>3Ph<00VATI003A4A4:b/[:b/[008R8R800bPX:3Hf=SHf=P02BTY:00=PH61fMWIf
MWH00XN7Q`03SHf=Q8B4Q8B4009bLW800e]KFdU9BDU9B@02@D5100=2@T9:BTY:BTX00UEEE@03Hf=S
LG5aLG5a009nOWh00hR8R8b<S8b<S002S8b<00>9RHV4Q8B4Q8@00X20P003O7alNWYjNWYj009jNWX0
0gmoOhJ6QXJ6QP02Rh^;00>:RXZ1PH61PH400W9bLP03Hf=SFEUIFEUI009IFET00f1PH6YZJVYZJP02
LG5a00=cLg=bLW9bLW800fm_K`9eMGD2OGem00>5QHF6QXJ6QXH00WmoO`03Lg=cJ6QXJ6QX009WIfL2
MGEe00>:RXZMWIfMWId00YnOW`03RXZ:I6ATI6AT008o?cl00bXZ:S0`<30`<002BTY:00=WIfMjNWYj
NWX00WUiN@03JFUYF5QHF5QH009>CTh00e9BDV1PH61PH002L71`00=jNWYkNg]kNg/00WAdM003K6a/
Hf=SHf=S009LG5`00eQHF5MGEeMGE`02GEeM00=/K6anOWinOWh00Xf=S@03TY:BRh^;Rh^;00Coool0
0`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9SHf<00gEeMHR8R8R8R002Vi^K00>[
Zj^i^KVi^KT00/71`@03a<C4`/;2`/;200:l_;`00k>c/jVYZJVYZ@02WYjN00>EUIF>SXj>SXh00XZ:
RP03RHV9Rh^;Rh^;00:?Shl00iFEUI^KVi^KV`02XJ6Q00>XZ:R^[Zj^[Zh00[>c/`03^;Rh_;bl_;bl
00;0`<000lC4a<O7alO7a`02bl_;0/k>cP03dM7Ad];Bd];B00?Cdm<2dM7A0/k>cP03b<S8`L71`L71
00:h^;P00jj^[ZBTY:BTY002Vi^K00>CTi><S8b<S8`00hV9R@:<S8`2T92@00>GUiNNWYjNWYh00ZJV
YP03[Jf]];Bd];Bd00:i^KT00kbl_;jn_[jn_P05_kno0[fm_@03^k^k^KVi^KVi00:f][H00k>c/k2`
/;2`/002[Jf]00>ZZZZXZ:RXZ:P00jNWY`:YZJT2[:b/00>_[jnc/k>c/k<00[Ng]`03^k^k_[jn_[jn
00:o_kl5`<3000>o_knn_[jn_[h00[jn_P03_kno`L71`L7100;4a<@00lO7al[:b/[:bP02cLg=00?>
c/k<c<c<c<`00/O7a`:n_[h00k>c/jFUYJFUY@02UiNG00>:RXYnOWinOWh00WIfMP03M7AdMWIfMWIf
009nOWh00hV9RIFEUIFEU@02XJ6Q00>[Zj^b/[:b/[800[>c/`03[Zj^Xj>SXj>S00:CTi<00h:2PVm_
Kfm_K`02GEeM00=<C4`n?Shn?Sh00S<c<`03;2`/:BTY:BTY008X:2P00bXZ:Rl_;bl_;`02=cLg00=3
@d=BDU9BDU801?ooo`030000oooooooo03;oool010000?ooooooooooo`9hN7P00f5QHDM7AdM7A`02
<30`00<N7QhE5ADE5AD00QdM7@03=cLgGEeMGEeM00:5QHD00j6QXJRXZ:RXZ002WYjN00><S8akNg]k
Ng/00W5aL@03KVi^Jf][Jf][009WIfL00eeMGE5ADE5AD@02BDU900=:BTYEEEEEEED00VMWI`03N7Qh
PX:2PX:200:1PH400gQhN6a/K6a/K002GemO0UEEE@03Cdm?CDe=CDe=009DE5@00fIVIWalO7alO002
Shn?00>CTi>3Ph>3Ph<00VATI003A4A4:b/[:b/[008R8R800bPX:3Hf=SHf=P02BTY:00=PH61fMWIf
MWH00XN7Q`03SHf=Q8B4Q8B4009bLW800e]KFdU9BDU9B@02@D5100=2@T9:BTY:BTX00UEEE@03Hf=S
LG5aLG5a009nOWh00hR8R8b<S8b<S002S8b<00>9RHV4Q8B4Q8@00X20P003O7alNWYjNWYj009jNWX0
0gmoOhJ6QXJ6QP02Rh^;00>:RXZ1PH61PH400W9bLP03Hf=SFEUIFEUI009IFET00f1PH6YZJVYZJP02
LG5a00=cLg=bLW9bLW800fm_K`9eMGD2OGem00>5QHF6QXJ6QXH00WmoO`03Lg=cJ6QXJ6QX009WIfL2
MGEe00>:RXZMWIfMWId00YnOW`03RXZ:I6ATI6AT008o?cl00bXZ:S0`<30`<002BTY:00=WIfMjNWYj
NWX00WUiN@03JFUYF5QHF5QH009>CTh00e9BDV1PH61PH002L71`00=jNWYkNg]kNg/00WAdM003K6a/
Hf=SHf=S009LG5`00eQHF5MGEeMGE`02GEeM00=/K6anOWinOWh00Xf=S@03TY:BRh^;Rh^;00Coool0
0`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9aLG400h>3PiBDU9BDU002YJFU00>d
];Bo_kno_kl00/K6aP03b<S8aLG5aLG500:n_[h00kFe]JZZZZZZZP02X:2P00>FUYJ?Shn?Shl00XZ:
RP03RHV9Rh^;Rh^;00:>SXh00i>CTiVIVIVIV@02WinO00>UYJF[Zj^[Zj/00[6a/@03][Jf^k^k^k^k
00:o_kl00lC4a<S8b<S8b002c<c<0/o?c`03d];Be=CDe=CD00;EeMD00mCDe=;Bd];BdP02clo?00?9
bLW2`/;2`/800[Vi^@03[jn_YJFUYJFU00:KVi/00i>CThb<S8b<S002R8R800>7QhN9RHV9RHT00Xf=
S@03Ti>CVIVIVIVI00:PX:000jNWYjj^[Zj^[P02/k>c00>g]kNj^[Zj^[X00[bl_0Fn_[h00kbl_;Zj
^[Zj^P02]kNg00>c/k>_[jn_[jl00Z^[Z`03Z:RXYJFUYJFU00>TY:@2YJFU0ZRXZ003Zj^[/;2`/;2`
00:d];@00kRh^;bl_;bl_002_[jn00?0`<31`L71`L400l71`@C2`/800l?3`lG5aLG5a@02b<S800?:
b/[=cLg=cLd00lk>cP;<c<`2alO70[jn_P03/k>cYZJVYZJV00:HV9P00h^;Rh20P820P002N7Qh00=e
MGEfMWIfMWH00WemO@03QXJ6T92@T92@00:JVYX00j>SXjNWYjNWY`02YjNW00>PX:2DU9BDU9@00XB4
Q003LG5aGemOGemO009=CDd00chn?S4a<C4a<@02:BTY00<U9BDV9RHV9RH00RTY:@03;bl_>3Ph>3Ph
0093@d<00e1@D61PH61PH004oooo00<0003oooooool0<_ooo`040000oooooooooooo0W1`L003Kfm_
J6QXJ6QX009IFET00dM7AcTi>CTi>@02=SHf00=5ADEOGemOGel00WYjNP03SXj>TY:BTY:B00::RXX0
0galO75aLG5aL@02KFe]00=^KVi_Kfm_Kfl00Ve]K@03I6ATF5QHF5QH009?Cdl00di>CUMGEeMGE`02
IVIV00=eMGEoOgmoOgl00X20P003NWYjLG5aLG5a009WIfL2GUiN00=HF5QEEEEEEED00UYJFP03IfMW
NGUiNGUi00:9RHT00hj>SXF5QHF5Q@02LG5a00=JFUY4A4A4A4@00SDe=@03;bl_<30`<30`008k>c/0
0e=CDfm_Kfm_K`02RXZ:00>HV9RBTY:BTY800WmoO`03IVIVDU9BDU9B009;Bd/00de=CEEEEEEEE@02
GEeM00=TI6AXJ6QXJ6P00Ve]K@03M7AdOGemOGem00:6QXH3S8b<0XF5Q@03NGUiKFe]KFe]009XJ6P0
0fe]KGUiNGUiN@02QHF500>9RHV1PH61PH400W9bLP03HV9RF5QHF5QH009JFUX00fATI75aLG5aL@02
NWYj00=lO7aiNGUiNGT00WAdM003LG5aLg=cLg=c009fMWH00gYjNWUiNGUiN@02LW9b00=WIfMOGemO
Gel00UmOG`9[Jf/00ginOXn?Shn?S`02Ti>C00>5QHE[Jf][Jf/00U1@D003@D51ADE5ADE5009GEeL0
0fa/K7UiNGUiN@02MWIf00=XJ6QJFUYJFUX00UADE003G5aLKFe]KFe]009nOWh00hR8R8N7QhN7Q`02
OGem00=aLG5UIFEUIFD00UeMG@03FEUIF5QHF5QH009IFET00eaLG61PH61PH002I6AT00=YJFU]KFe]
KFd01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0WinOP03SXj>WYjNWYjN
00:][Jd00kVi^L;2`/;2`P03b<S80/G5a@:n_[h00kFe]J^[Zj^[Z`02X:2P00>FUYJ?Shn?Shl00XZ:
RP>9RHT2S8b<00>@T92EUIFEUID00Y^KV`03XZ:RZ:RXZ:RX00:^[Zh00kBd];Vi^KVi^@02_kno00?4
a<C9bLW9bLT00/g=c@;AdM400mCDe=KFe]KFeP02emOG00?Fe]KDe=CDe=@00]7Ad@03bl_;`l?3`l?3
00:j^[X00k2`/:JVYZJVYP02W9bL00>CTi><S8b<S8`00XN7Q`03QXJ6QhN7QhN700::RXX00hn?SiBD
U9BDU002Vi^K00>RXZ:XZ:RXZ:P00Zj^[P03/k>c]kNg]kNg00:j^[X00kfm_Kjn_[jn_P02_kno00>n
_[jl_;bl_;`00[Rh^003];Bd/;2`/;2`00:[Zj/00jNWYj>SXj>SX`03XJ6Q0Z:RXP:UYJD00jVYZJf]
[Jf][@02/[:b00>f][Jj^[Zj^[X00[jn_P03`<30`/;2`/;200;3`l<00lC4a<G5aLG5a@02aLG500?7
alO8b<S8b<P00/[:bP03c<c<cLg=cLg=00;>c/h00lg=cL[:b/[:bP02aLG50[bl_003/[:bYZJVYZJV
00:IVIT00hf=SH:2PX:2PP02NWYj00=fMWIgMgMgMgL00WalO003Ph>3Rh^;Rh^;00:CTi<00iVIVI^K
Vi^KV`02VIVI00>ATI65QHF5QHD00WEeM@03Hf=SDE5ADE5A0091@D400c<c<bTY:BTY:@038b<S0RHV
9P8];Bd00cHf=T92@T92@P02Cdm?00=NGUi^KVi^KVh01?ooo`030000oooooooo03;oool010000?oo
ooooooooo`9WIfL00ginOXZ:RXZ:RP02QXJ600=fMWITI6ATI6@00eQHF09RHV82KVi^0gIfMP9`L700
0fUYJFIVIVIVIP02JFUY00=`L71fMWIfMWH00WIfMP03KVi^HV9RHV9R009HF5P00eADE5YJFUYJFP02
IVIV00=dM7AnOWinOWh00X61P@03OWinMgMgMgMg009`L702J6QX00=QHF5MGEeMGEd00UmOG`03J6QX
MGEeMGEe00:1PH43R8R80X20P003MGEeI6ATI6AT009@D5000cdm?C0`<30`<002<S8b00=8B4QZJVYZ
JVX00Xb<S003XJ6QWinOWinO00:;Rh/00g5aLEaLG5aLG002EUIF00=KFe]SHf=SHf<00VQXJ003IfMW
HF5QHF5Q009MGEd00emOGf][Jf][J`02O7al00>;Rh^@T92@T9000XJ6QP03Lg=cH61PH61P009FEUH0
0e]KFfYZJVYZJP02Ng]k00>4Q8AoOgmoOgl00W5aL@03Hf=SFUYJFUYJ009MGEd00fUYJGIfMWIfMP02
P82000>3Ph>1PH61PH400WalO003MWIfLW9bLW9b009_Kfl00fa/K6MWIfMWI`02HF5Q00=KFe]GEeMG
EeL00UYJFP9TI6@00g9bLWmoOgmoO`02QHF500>0P81cLg=cLg<00VEUI@03G5aLGemOGemO009XJ6P0
0g=cLgQhN7QhN002Lg=c00=XJ6QOGemOGel00UeMG@03IfMWN7QhN7Qh00::RXX00iBDU96ATI6AT@02
QHF500=fMWIXJ6QXJ6P00V5QH@03GUiNG5aLG5aL009GEeL00di>CT=3@d=3@`02?Cdm00=0@41@D51@
D5001?ooo`030000oooooooo013oool002Goool200000oooo`9nOWh00hj>SYjNWYjNWP02[Jf]00>i
^KW2`/;2`/800lS8b0;5aLD2_[jn00>e]KF[Zj^[Zj/00Z2PX003UYJFShn?Shn?00::RXX3RHV90Xb<
S003T92@UIFEUIFE00:KVi/00j:RXZRXZ:RXZ002[Zj^00>d];Bi^KVi^KT00[no_`03a<C4bLW9bLW9
00;=cLd2dM7A00?De=CFe]KFe]H00]OGe`03e]KFe=CDe=CD00;AdM400l_;bl?3`l?3``02^[Zj00>`
/;2VYZJVYZH00YbLW003Ti>CS8b<S8b<00:7QhL00hJ6QXN7QhN7Q`02RXZ:00>?ShnDU9BDU9@00Y^K
V`03XZ:RZ:RXZ:RX00:^[Zh00k>c/kNg]kNg]`02^[Zj00>m_Kfn_[jn_[h00[no_`03_[jn_;bl_;bl
00:h^;P00kBd];2`/;2`/002Zj^[00>WYjNSXj>SXj<00j6QX@:RXZ82YJFU00>YZJV][Jf][Jd00[:b
/P03][Jf^[Zj^[Zj00:n_[h00l30`<;2`/;2`P02`l?300?4a<C5aLG5aLD00/G5a@03alO7b<S8b<S8
00;:b/X00lc<c<g=cLg=c@02c/k>00?=cLg:b/[:b/X00/G5a@:l_;`00k:b/ZJVYZJVYP02VIVI00>=
SHf2PX:2PX800WYjNP03MWIfMgMgMgMg009lO7`00h>3Ph^;Rh^;R`02Ti>C00>IVIVKVi^KVi/00YVI
V@03TI6AQHF5QHF5009eMGD00f=SHe5ADE5AD@02@D5100<c<c<Y:BTY:BT00b<S8`8V9RH2;Bd]00<f
=SI2@T92@T800Tm?C`03GUiNKVi^KVi^00?oool20000=?ooo`040000oooooooooooo0VMWI`03OWin
RXZ:RXZ:00:6QXH00gIfMVATI6ATI003F5QH0V9RHP9^KVh3MWIf0W1`L003JFUYIVIVIVIV009YJFT0
0g1`L7IfMWIfMP02MWIf00=^KViRHV9RHV800UQHF003E5ADFUYJFUYJ009VIVH00gAdM7inOWinOP02
PH6100=nOWigMgMgMgL00W1`L09XJ6P00f5QHEeMGEeMG@02GemO00=XJ6QeMGEeMGD00X61P@>8R8P2
P82000=eMGETI6ATI6@00U1@D003?Cdm<30`<30`008b<S800dQ8B6YZJVYZJP02S8b<00>QXJ6OWinO
Wil00X^;R`03LG5aG5aLG5aL009FEUH00e]KFf=SHf=SH`02J6QX00=WIfMQHF5QHF400UeMG@03GemO
Jf][Jf][009lO7`00h^;Ri2@T92@T002QXJ600=cLg=PH61PH6000UIFEP03Fe]KJVYZJVYZ009kNg/0
0hB4Q7moOgmoO`02LG5a00=SHf=JFUYJFUX00UeMG@03JFUYMWIfMWIf00:0P8000h>3Ph61PH61P@02
O7al00=fMWIbLW9bLW800Vm_K`03K6a/IfMWIfMW009QHF400e]KFeMGEeMGE`02FUYJ0VATI003LW9b
OgmoOgmo00:5QHD00h20P7=cLg=cL`02IFEU00=LG5aOGemOGel00VQXJ003Lg=cN7QhN7Qh009cLg<0
0fQXJ5mOGemOG`02GEeM00=WIfMhN7QhN7P00XZ:RP03U9BDTI6ATI6A00:5QHD00gIfMVQXJ6QXJ002
HF5Q00=NGUiLG5aLG5`00UMGE`03CTi>@d=3@d=3008m?Cd00d10@51@D51@D003oooo0P0001;oool0
02Goool00`000?ooooooo`02oooo0XR8R003UiNGY:BTY:BT00:`/;000kZj^/71`L71`@03aLG50/71
`@:j^[X00k:b/ZVYZJVYZ@02WinO00>FUYJ>SXj>SXh00XZ:RP>7QhL2RHV900><S8b@T92@T9000YJF
UP03W9bLXZ:RXZ:R00:YZJT00k2`/;Ng]kNg]`02_[jn00?4a<C:b/[:b/X00/o?c`;De=@00mOGemWI
fMWIf@03f][J0]OGe`;Cdm<00lg=cLG5aLG5a@02^k^k00>a/K6WYjNWYjL00YbLW003Ti>CS8b<S8b<
00:7QhL3Q8B40XN7Q`03Rh^;T92@T92@00:FUYH00ibLW:>SXj>SX`02ZJVY00>_[jne]KFe]KD00[Vi
^@03_Kfm`<30`<3000?1`L42_kno0[^k^`03]kNg/[:b/[:b00:/[:`00jNWYj>SXj>SX`02XJ6Q00>P
X:2QXJ6QXJ400ZBTY003YjNW[:b/[:b/00:a/K400kFe]KZj^[Zj^P02_[jn00?1`L73`l?3`l<00/G5
a@03a/K6alO7alO700;8b<P00lW9bL[:b/[:bP02bl_;00?<c<c=cLg=cLd00/c<c003b/[:alO7alO7
00;1`L42^KVi00>_[jnUYJFUYJD00YVIV@03SXj>Q8B4Q8B4009lO7`3N7Qh0WYjNP03OgmoQHF5QHF5
00::RXX3SXj>0X^;R`03Ph>3MWIfMWIf009WIfL00eMGEdM7AdM7A`02>CTi00<];BdU9BDU9BD00R<S
8`039BDU:b/[:b/[008d=3@00clo?da<C4a<C002Fe]K00=ZJVYiNGUiNGT01?ooo`030000oooooooo
03;oool010000?ooooooooooo`9TI6@00hZ:RZFUYJFUY@02ZJVY00>MWIf9RHV9RHT00WIfMP03Jf][
IfMWIfMW009UIFD00f=SHeiNGUiNGP02FEUI00=GEeMJFUYJFUX00VATI003L71`Ng]kNg]k009nOWh0
0gMgMfUYJFUYJ@02Fe]K00=DE5AIFEUIFET00VIVIP03MWIfPH61PH6100:5QHD00h>3PgemOGemO@02
MGEe0Ve]K@03IVIVHF5QHF5Q009QHF400fIVIVm_Kfm_K`02NGUi00>2PX::RXZ:RXX00Xj>SP03S8b<
PH61PH61009[Jf/00e1@D3Ti>CTi>@02=3@d00=6ATIYJFUYJFT00Xf=S@03Y:BTXj>SXj>S00:?Shl0
0gIfMV=SHf=SH`02H61P00=XJ6QbLW9bLW800WEeM@03KVi^H61PH61P009CDe<00e5ADEeMGEeMG@02
LG5a00>5QHF=SHf=SHd00X>3P`03KVi^F5QHF5QH009;Bd/00di>CUeMGEeMG@02KVi^0gUiN@9aLG40
0fQXJ6=SHf=SH`02IVIV00=_KfmhN7QhN7P00X20P0>4Q8@2PH6100=kNg]bLW9bLW800VUYJ@03GemO
EeMGEeMG009BDU800e5ADE9BDU9BDP02F5QH0V1PH003JVYZM7AdM7Ad009jNWX00g]kNgQhN7QhN002
M7Ad00=`L71aLG5aLG400W=cL`=fMWH2LG5a00=ZJVYTI6ATI6@00VEUI@03L71`P820P82000:@T900
0iRHV9>CTi>CT`02QXJ600=eMGEXJ6QXJ6P00VATI003IFEUIVIVIVIV009PH6000di>CSPh>3Ph>003
9bLW0Shn?PCoool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`:8R8P00iNGUjBT
Y:BTY002/;2`00>j^[[1`L71`L400lG5a@;1`L42^[Zj00>b/[:YZJVYZJT00YnOW`03UYJFSXj>SXj>
00::RXX3QhN70XV9R@03S8b<T92@T92@00:FUYH00ibLW::RXZ:RXP02ZJVY00>`/;2g]kNg]kL00[jn
_P03a<C4b/[:b/[:00;?cll2e=CD00?GemOIfMWIfMT00m[JfP;GemL2dm?C00?=cLg5aLG5aLD00[^k
^`03/K6aYjNWYjNW00:LW9`00i>CThb<S8b<S002QhN70hB4Q0:7QhL00h^;Ri2@T92@T002UYJF00>L
W9bSXj>SXj<00ZVYZ@03[jn_]KFe]KFe00:i^KT00kfm_L30`<30`003`L710[no_`:k^k/00kNg]k:b
/[:b/P02[:b/00>WYjNSXj>SXj<00Z6QX@03X:2PXJ6QXJ6Q00:TY:@00jNWYjb/[:b/[002/K6a00>e
]KFj^[Zj^[X00[jn_P03`L71`l?3`l?300;5aLD00lK6a/O7alO7a`02b<S800?9bLW:b/[:b/X00/_;
b`03c<c<cLg=cLg=00;<c<`00l[:b/O7alO7a`02`L710[Vi^@03[jn_YJFUYJFU00:IVIT00hj>SXB4
Q8B4Q002O7al0gQhN09jNWX00gmoOhF5QHF5Q@02RXZ:0hj>SP:;Rh/00h>3PgIfMWIfMP02IfMW00=G
EeM7AdM7AdL00STi>@03;Bd]9BDU9BDU008S8b<00bDU9B/[:b/[:`02=3@d00<o?cm<C4a<C4`00U]K
F`03JVYZNGUiNGUi00Coool00`000?ooooooo`0boooo00@0003oooooooooool2I6AT00>:RXZUYJFU
YJD00ZVYZ@03WIfMRHV9RHV9009fMWH00f][JfMWIfMWI`02IFEU00=SHf=NGUiNGUh00UUIF@03EeMG
FUYJFUYJ009TI6@00g1`L7]kNg]kN`02OWin00=gMgMYJFUYJFT00U]KF`03E5ADFEUIFEUI009VIVH0
0gIfMX61PH61P@02QHF500>3Ph=mOGemOGd00WEeM@9]KFd00fIVIV5QHF5QH@02HF5Q00=VIVI_Kfm_
Kfl00WUiN@03PX:2RXZ:RXZ:00:>SXh00hb<S861PH61P@02Jf][00=@D50i>CTi>CT00S@d=003ATI6
JFUYJFUY00:=SHd00jBTY:>SXj>SX`02Shn?00=fMWISHf=SHf<00V1PH003J6QXLW9bLW9b009eMGD0
0fi^KV1PH61PH002De=C00=ADE5MGEeMGEd00W5aL@03QHF5SHf=SHf=00:3Ph<00fi^KUQHF5QHF002
Bd];00=>CTiMGEeMGEd00Vi^KP=iNGT2LG5a00=XJ6QSHf=SHf<00VIVIP03Kfm_N7QhN7Qh00:0P803
Q8B40X61P@03Ng]kLW9bLW9b009YJFT00emOGeMGEeMGE`02DU9B00=ADE5BDU9BDU800UQHF09PH600
0fYZJWAdM7AdM002NWYj00=kNg]hN7QhN7P00WAdM003L71`LG5aLG5a009cLg<3MWIf0W5aL@03JVYZ
I6ATI6AT009UIFD00g1`L820P820P002T92@00>HV9RCTi>CTi<00XJ6QP03MGEeJ6QXJ6QX009TI6@0
0fEUIFIVIVIVIP02H61P00=>CThh>3Ph>3P00bLW9`8n?Sh4oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool2Shn?00>KVi^UYJFUYJD00Zn_[`03][Jf_;bl_;bl00:n_[h00kfm_KVi
^KVi^@02];Bd00>/[:bTY:BTY:@00YbLW003U9BDSHf=SHf=00:8R8P00hF5QH>3Ph>3P`02Q8B400>6
QXJ9RHV9RHT00Xj>SP03U9BDVi^KVi^K00:SXj<00j^[Zk>c/k>c/`02_;bl00?4a<C<c<c<c<`00];B
dP;GemL00m_KfmkNg]kNgP02g]kN00?MgMgKfm_Kfm/00]KFeP03clo?alO7alO700:m_Kd00k>c/jRX
Z:RXZ002WIfM00>CTi>;Rh^;Rh/00XJ6QP>2PX82Ph>300>7QhN;Rh^;Rh/00Y6AT@03V9RHWinOWinO
00:VYZH00jf][K>c/k>c/`02^KVi00>n_[k2`/;2`/800lG5a@;3`l<2`<3000>k^k^e]KFe]KD00Zn_
[`03ZJVYYJFUYJFU00:RXZ800j2PX:6QXJ6QX@02Y:BT00>XZ:R/[:b/[:`00[6a/@03][Jf^k^k^k^k
00:n_[h00l;2`/C4a<C4a002a/K600?8b<S9bLW9bLT00l[:bPG;bl/2b/[:0/S8b003a/K6`/;2`/;2
00:l_;`2]KFe00>/[:bSXj>SXj<00YVIV@03Shn?QXJ6QXJ6009oOgl00gYjNWQhN7QhN002NGUi00=k
Ng]nOWinOWh00X20P003PX:2PH61PH61009lO7`00gAdM6UYJFUYJ@02G5aL00=?Cdm1@D51@D400SHf
=P03;Bd]:2PX:2PX008X:2P00b`/;3@d=3@d=002?Shn00=:BTYGEeMGEeL00VEUI@03M7AdPH61PH61
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2IfMW00>ATI6_[jn_[jl00[Ng]`03[Zj^
Vi^KVi^K00:8R8P00gQhN6i^KVi^KP02IFEU00=LG5aCDe=CDe<00Ta<C003BTY:Cdm?Cdm?009MGEd0
0fm_KginOWinOP02Ph>300=iNGUVIVIVIVH00U=CD`03BTY:DU9BDU9B009UIFD00g]kNh^;Rh^;R`02
Shn?00>9RHUoOgmoOgl00WAdM09YJFT00f9RHUeMGEeMG@02G5aL00=QHF5YJFUYJFT00W=cL`03Ogmo
Rh^;Rh^;00:EUID00iZJVYBDU9BDU002PH6100=WIfM?Cdm?Cdl00TE5A@03DU9BKFe]KFe]00:;Rh/0
0ifMWIZJVYZJVP02RHV900=cLg=UIFEUIFD00VMWI`03Lg=cOgmoOgmo00:3Ph<00gUiNFMWIfMWI`02
EEEE00==CDeEEEEEEED00VMWI`03NWYjPh>3Ph>3009lO7`00f][JeQHF5QHF002Bd];00=:BTYCDe=C
De<00UiNGP03JFUYKfm_Kfm_009bLW800g=cLgAdM7AdM005MGEe0WIfMP03NWYjOWinOWin00:1PH40
0ginOWAdM7AdM002IVIV00=GEeM<C4a<C4`00TU9B@03C4a<DU9BDU9B009KFe/2Hf=S00=/K6acLg=c
Lg<00WUiN@03Ng]kNWYjNWYj009gMgL00gAdM7=cLg=cL`05M7Ad0W1`L003KFe]JVYZJVYZ009]KFd0
0gIfMX:2PX:2PP02SXj>00>BTY:;Rh^;Rh/00WalO003Jf][HV9RHV9R009TI6@00fm_KgQhN7QhN002
MWIf00=SHf=7AdM7AdL00S0`<003:b/[@410@41000Coool00`000?ooooooo`0@oooo000Uoooo00<0
003oooooool00_ooo`:?Shl00i^KVjFUYJFUY@02[jn_00>f][Jl_;bl_;`00[jn_P03_Kfm^KVi^KVi
00:d];@00jb/[:BTY:BTY002W9bL00>DU9B=SHf=SHd00XR8R003QHF5Ph>3Ph>300:4Q8@00hJ6QXV9
RHV9R@02SXj>00>DU9BKVi^KVi/00Z>SX`03Zj^[/k>c/k>c00:l_;`00lC4a<c<c<c<c002d];B0]OG
e`03fm_Kg]kNg]kN00;Ng]h00mgMgM_Kfm_Kf`02e]KF00??clo7alO7alL00[fm_@03/k>cZ:RXZ:RX
00:MWId00i>CTh^;Rh^;R`02QXJ60h:2PP:3Ph<00hN7Qh^;Rh^;R`02TI6A00>HV9ROWinOWil00ZJV
YP03[Jf]/k>c/k>c00:i^KT00kjn_/;2`/;2`P03aLG50/?3``;0`<000k^k^kFe]KFe]@02[jn_00>Y
ZJVUYJFUYJD00Z:RXP03X:2PXJ6QXJ6Q00:TY:@00jRXZ:b/[:b/[002/K6a00>f][Jk^k^k^k/00[jn
_P03`/;2a<C4a<C400;6a/H00lS8b<W9bLW9b@03b/[:1L_;b`;:b/X2b<S800?6a/K2`/;2`/800[bl
_0:e]KD00jb/[:>SXj>SX`02VIVI00>?Shn6QXJ6QXH00WmoO`03NWYjN7QhN7Qh009iNGT00g]kNgin
OWinOP02P82000>2PX:1PH61PH400WalO003M7AdJFUYJFUY009LG5`00dm?Cd51@D51@@02=SHf00<]
;BdX:2PX:2P00RPX:003;2`/=3@d=3@d008n?Sh00dY:BUMGEeMGE`02IFEU00=dM7B1PH61PH401?oo
o`030000oooooooo03;oool010000?ooooooooooo`9WIfL00i6ATJn_[jn_[`02]kNg00>^[ZjKVi^K
Vi/00XR8R003N7QhKVi^KVi^009UIFD00eaLG5=CDe=CD`02C4a<00=:BTY?Cdm?Cdl00UeMG@03Kfm_
OWinOWin00:3Ph<00gUiNFIVIVIVIP02De=C00=:BTYBDU9BDU800VEUI@03Ng]kRh^;Rh^;00:?Shl0
0hV9RGmoOgmoO`02M7Ad0VUYJ@03HV9RGEeMGEeM009LG5`00f5QHFUYJFUYJ@02Lg=c00=oOgn;Rh^;
Rh/00YFEU@03VYZJU9BDU9BD00:1PH400fMWIdm?Cdm?C`02ADE500=BDU9]KFe]KFd00X^;R`03WIfM
VYZJVYZJ00:9RHT00g=cLfEUIFEUI@02IfMW00=cLg=oOgmoOgl00X>3P`03NGUiIfMWIfMW009EEED0
0de=CEEEEEEEE@02IfMW00=jNWZ3Ph>3Ph<00WalO003Jf][F5QHF5QH009;Bd/00dY:BU=CDe=CD`02
GUiN00=YJFU_Kfm_Kfl00W9bLP03Lg=cM7AdM7Ad00EeMGD2MWIf00=jNWYnOWinOWh00X61P@03OWin
M7AdM7Ad009VIVH00eMGEda<C4a<C002BDU900=<C4aBDU9BDU800U]KF`9SHf<00fa/K7=cLg=cL`02
NGUi00=kNg]jNWYjNWX00WMgM`03M7AdLg=cLg=c00EdM7@2L71`00=]KFeZJVYZJVX00Ve]K@03MWIf
PX:2PX:200:>SXh00i:BTX^;Rh^;R`02O7al00=[Jf]RHV9RHV800VATI003Kfm_N7QhN7Qh009fMWH0
0f=SHdM7AdM7A`02<30`00<[:b]0@410@4001?ooo`030000oooooooo013oool002Goool00`000?oo
ooooo`02oooo0Y6AT@03Vi^KXj>SXj>S00:YZJT00jn_[k:b/[:b/P02/k>c00>b/[:_[jn_[jl00ZZZ
ZP03Y:BTWYjNWYjN00:GUiL00i2@T8Z:RXZ:RP02QHF500>1PH5oOgmoOgl00WinOP03OgmoPH61PH61
00:5QHD00hZ:RY:BTY:BTP02Vi^K00>UYJF_[jn_[jl00[Zj^P03a<C4cLg=cLg=00;EeMD2g=cL00?P
h>3Rh^;Rh^800^?Sh`03h^;Rg]kNg]kN00;IfMT00m;Bd/W9bLW9b@02_kno00>d];BYZJVYZJT00YjN
WP03Ti>CRh^;Rh^;00:5QHD00h61PGmoOgmoO`02P82000>3Ph>8R8R8R8P00Xf=S@03U9BDVi^KVi^K
00:SXj<00j^[Zk>c/k>c/`02^[Zj00?0`<36a/K6a/H00/W9b@03b/[:bLW9bLW900;5aLD00l30`;Zj
^[Zj^P02/k>c00>][JfWYjNWYjL00ZBTY003XZ:RXj>SXj>S00:UYJD00jVYZJj^[Zj^[P02/[:b00>g
]kNl_;bl_;`00/30`003`l?3a/K6a/K600;8b<P00lW9bL[:b/[:bP05b/[:0/W9b@03b<S8a/K6a/K6
00;3`l<00l30`;^k^k^k^`02]KFe0Zn_[`03YjNWX:2PX:2P00:GUiL00hn?ShR8R8R8R002PH6100=m
OGeiNGUiNGT00WQhN0EgMgL00gEeMG=cLg=cL`02KVi^00=WIfMNGUiNGUh00UADE003BTY:@410@410
008h>3P00c<c<c4a<C4a<@02<c<c00<h>3Q0@410@4000TY:BP03EUIFHV9RHV9R009_Kfl00g]kNhN7
QhN7Q`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0Vi^KP03TI6AZZZZZZZZ00:c/k<0
0jb/[9jNWYjNWP02SXj>00>1PH5fMWIfMWH00V][J`03H61PE5ADE5AD0099BDT00dA4A4Q8B4Q8B002
EeMG00=/K6aoOgmoOgl00XF5Q@03MgMgGUiNGUiN0095ADD00c/k>dQ8B4Q8B002I6AT00>3Ph>IVIVI
VIT00YbLW003TI6AOgmoOgmo009^KVh2H61P00=HF5QDE5ADE5@00UADE003FEUIHf=SHf=S009_Kfl0
0gemOH^;Rh^;R`02UiNG00>NWYjLW9bLW9`00Xn?S`03O7alJVYZJVYZ009QHF400fIVIWEeMGEeM@02
QXJ600>?Shn:RXZ:RXX00W]kN`03Jf][Hf=SHf=S009ZJVX00gYjNXV9RHV9R@02T92@00>6QXIcLg=c
Lg<00UiNGP03DU9BE5ADE5AD009OGel00fa/K7=cLg=cL`02LW9b00=YJFUOGemOGel00UIFEP03D51@
CTi>CTi>009?Cdl00eIFEV9RHV9RHP02LW9b00>1PH69RHV9RHT00XF5Q@03NWYjKFe]KFe]009VIVH0
0fYZJWAdM7AdM002OGem00=oOgmfMWIfMWH00VEUI@03De=CB4Q8B4Q80096ATH00da<C5IFEUIFEP02
HF5Q0V][J`03M7AdNg]kNg]k009nOWh00galO7MgMgMgM`02LG5a00=/K6aZJVYZJVX00Va/K003KVi^
LG5aLG5a009aLG400g1`L6m_Kfm_K`02LW9b00=hN7R0P820P8000XJ6QP03QHF5NWYjNWYj009ZJVX0
0e]KFeMGEeMGE`02Hf=S00=iNGV=SHf=SHd00YBDU003QXJ6JFUYJFUY009>CTh00d=3@e1@D51@D004
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2TI6A00>HV9RMWIfMWId00Z6Q
X@03Xj>SYJFUYJFU00:UYJD00jBTY::RXZ:RXP02WinO00>KVi^FUYJFUYH00Y6AT@03S8b<QhN7QhN7
00:2PX800ginOWYjNWYjNP02N7Qh00=gMgMhN7QhN7P00W]kN`03P820R8R8R8R800:CTi<00ijNWZ^[
Zj^[Z`02^;Rh00?4a<C?clo?cll00]WIf@;Ph>000nGUiNOWinOWi`02j>SX00?Vi^KRh^;Rh^800]gM
g@03eMGEc<c<c<c<00;1`L400kFe]JVYZJVYZ@02WYjN00>CTi>:RXZ:RXX00XB4Q003OgmoOGemOGem
009nOWh00h20P8B4Q8B4Q002RXZ:00>ATI6IVIVIVIT00Z6QX@03ZZZZ/k>c/k>c00:k^k/00l?3`lW9
bLW9b@02c/k>00??clo>c/k>c/h00/_;b`03aLG5_kno_kno00:g]kL00k2`/:ZZZZZZZP02YZJV0jFU
Y@:XZ:P00j^[Zk2`/;2`/002];Bd00>i^KVn_[jn_[h00/;2`P03aLG5alO7alO700;9bLT6b/[:0/S8
b0;6a/H00lC4a<71`L71`@02_Kfm00>h^;Rc/k>c/k<00Zj^[P:XZ:P00j:RXYbLW9bLW002UYJF00>@
T92:RXZ:RXX00XB4Q003OgmoNg]kNg]k009gMgL00gAdM71`L71`L002KFe]00=ZJVYVIVIVIVH00V5Q
H@03Fe]KEEEEEEEE009>CTh00dQ8B4=3@d=3@`02?clo00<m?Cdn?Shn?Sh00T51@@03AdM7Cdm?Cdm?
009HF5P00f9RHVe]KFe]K@02MgMg00>1PH6:RXZ:RXX01?ooo`030000oooooooo03;oool010000?oo
ooooooooo`9fMWH00hb<S9jNWYjNWP02Y:BT00>PX:2GUiNGUiL00Xf=S@03Q8B4O7alO7al009dM7@0
0fUYJE]KFe]KF`02CDe=00=4A4A5ADE5ADD00UADE003Jf][OgmoOgmo00:4Q8@00gAdM5IFEUIFEP02
>CTi00<_;bm0@410@4000VEUI@03S8b<YZJVYZJV00:XZ:P00iNGUginOWinOP02IVIV0UIFEP03CDe=
BDU9BDU9009;Bd/00e9BDUiNGUiNGP02KFe]00=mOGf:RXZ:RXX00YBDU003VYZJVi^KVi^K00:FUYH0
0hf=SH>3Ph>3P`02O7al00=kNg]mOGemOGd00X61P@03P820MgMgMgMg009[Jf/00f5QHEmOGemOG`02
JVYZ00=mOGf?Shn?Shl00YNGU`03T92@OgmoOgmo009[Jf/00eaLG5IFEUIFEP02F5QH00=MGEeSHf=S
Hf<00VIVIP03J6QXJFUYJFUY009UIFD00e]KFdi>CTi>CP02ADE500=6ATIGEeMGEeL00W9bLP03Rh^;
VIVIVIVI00:BTY800gemOFEUIFEUI@02EeMG00=JFUYYJFUYJFT00WUiN@03P820N7QhN7Qh009UIFD0
0e9BDTI6ATI6AP02ADE500=?CdmLG5aLG5`00VUYJ@9eMGD00ginOX>3Ph>3P`02Q8B400=nOWidM7Ad
M7@00VUYJ@03HF5QGemOGemO009RHV800fUYJFm_Kfm_K`02LW9b00=cLg=dM7AdM7@00WEeM@03MgMg
NWYjNWYj009lO7`00gIfMVUYJFUYJ@02F5QH00=;Bd]=CDe=CDd00V5QH@03PH61X:2PX:2P00:`/;00
0jNWYhf=SHf=S@02LG5a00=PH61SHf=SHf<01?ooo`030000oooooooo013oool002Goool00`000?oo
ooooo`02oooo0Y6AT@03V9RHWIfMWIfM00:QXJ400j>SXjFUYJFUY@02YJFU00>TY:BRXZ:RXZ800YnO
W`03Vi^KUYJFUYJF00:ATI400hb<S8N7QhN7Q`02PX:200=nOWijNWYjNWX00WQhN003MgMgN7QhN7Qh
009kNg/00h20P8R8R8R8R002Ti>C00>NWYj[Zj^[Zj/00[Rh^003a<C4clo?clo?00;IfMT2h>3P00?U
iNGWinOWinL00^SXj003i^KVh^;Rh^;R00;MgMd00mGEeLc<c<c<c002`L7100>e]KFYZJVYZJT00YjN
WP03Ti>CRXZ:RXZ:00:4Q8@00gmoOgemOGemO@02OWin00>0P824Q8B4Q8@00XZ:RP03TI6AVIVIVIVI
00:QXJ400jZZZ[>c/k>c/`02^k^k00?3`l?9bLW9bLT00/k>cP03clo?c/k>c/k>00;;bl/00lG5aKno
_kno_`02]kNg00>`/;2ZZZZZZZX00ZJVYP>UYJD2Z:RX00>[Zj^`/;2`/;000[Bd]003^KVi_[jn_[jn
00;2`/800lG5aLO7alO7a`02bLW91/[:bP;8b<P2a/K600?4a<C1`L71`L400[fm_@03^;Rh/k>c/k>c
00:^[Zh2Z:RX00>RXZ:LW9bLW9`00YJFUP03T92@RXZ:RXZ:00:4Q8@00gmoOg]kNg]kN`02MgMg00=d
M7A`L71`L7000Ve]K@03JVYZIVIVIVIV009QHF400e]KFeEEEEEEE@02CTi>00=8B4Q3@d=3@d<00Slo
?`03?Cdm?Shn?Shn0091@D400dM7Adm?Cdm?C`02F5QH00=RHV9]KFe]KFd00WMgM`03PH61RXZ:RXZ:
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2MWIf00><S8bNWYjNWYh00ZBTY003X:2P
UiNGUiNG00:=SHd00hB4Q7alO7alO002M7Ad00=YJFUKFe]KFe/00Te=C@03A4A4ADE5ADE5009DE5@0
0f][JgmoOgmoO`02Q8B400=dM7AFEUIFEUH00STi>@03;bl_@410@410009UIFD00hb<S:JVYZJVYP02
Z:RX00>GUiMnOWinOWh00VIVIP9FEUH00de=CDU9BDU9B@02Bd];00=BDU9NGUiNGUh00Ve]K@03OGem
RXZ:RXZ:00:DU9@00iZJVY^KVi^KV`02UYJF00>=SHf3Ph>3Ph<00WalO003Ng]kOGemOGem00:1PH40
0h20P7MgMgMgM`02Jf][00=QHF5OGemOGel00VYZJP03OGemShn?Shn?00:GUiL00i2@T7moOgmoO`02
Jf][00=LG5aFEUIFEUH00UQHF003GEeMHf=SHf=S009VIVH00fQXJ6UYJFUYJ@02IFEU00=KFe]>CTi>
CTh00TE5A@03ATI6EeMGEeMG009bLW800h^;RiVIVIVIV@02TY:B00=mOGeUIFEUIFD00UMGE`03FUYJ
JFUYJFUY009iNGT00h20P7QhN7QhN002IFEU00=BDU96ATI6ATH00TE5A@03Cdm?G5aLG5aL009YJFT2
MGEe00=nOWj3Ph>3Ph<00XB4Q003OWinM7AdM7Ad009YJFT00f5QHEmOGemOG`02HV9R00=YJFU_Kfm_
Kfl00W9bLP03Lg=cM7AdM7Ad009eMGD00gMgMgYjNWYjNP02O7al00=fMWIYJFUYJFT00UQHF003Bd];
CDe=CDe=009QHF400h61PJ2PX:2PX002/;2`00>WYjN=SHf=SHd00W5aL@03H61PHf=SHf=S00Coool0
0`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`:?Shl00i:BTYFEUIFEU@05UYJF0iFE
U@:CTi<2TY:B00>@T92>SXj>SXh00X^;R`03R8R8Q8B4Q8B4009oOgl00gYjNWEeMGEeM@02LG5a00=_
Kfm^KVi^KVh00W5aL@03MWIfOgmoOgmo00::RXX00iRHV:NWYjNWY`02]KFe00?4a<CAdM7AdM400]cL
g0;Ti>@00nWYjNc/k>c/k002k>c/00?Zj^[Vi^KVi^H00^3Ph003emOGc/k>c/k>00;2`/800kJf]ZZZ
ZZZZZP02WinO00>DU9B:RXZ:RXX00X>3P`03OWinO7alO7al009lO7`00ginOX:2PX:2PP02QhN700>>
SXjGUiNGUiL00Z2PX003ZZZZ/k>c/k>c00:m_Kd00lK6a/g=cLg=c@02d];B00?De=CCdm?Cdm<00]3@
d003b/[:`l?3`l?300:l_;`00kBd]:j^[Zj^[P02ZZZZ0jRXZ0:ZZZX00jj^[[:b/[:b/P02][Jf00>k
^k_0`<30`<000/?3``03a/K6b<S8b<S800;9bLT5b/[:00?8b<S6a/K6a/H00/?3``03_kno^k^k^k^k
00:f][H00k6a/J^[Zj^[Z`02YZJV0Z:RXP03WIfMVIVIVIVI00:EUID00i6ATHb<S8b<S002R8R800>2
PX9mOGemOGd00WMgM`03LG5aJf][Jf][009UIFD00f1PH5]KFe]KF`02EUIF00=BDU9>CTi>CTh00T];
B`03BTY:BDU9BDU90099BDT00d];Bdi>CTi>CP02DU9B00=HF5QOGemOGel00VMWI`03Kfm_MgMgMgMg
009nOWh00hF5QH^;Rh^;R`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WIfMP03PX:2
S8b<S8b<00:@T9000hn?Sh^;Rh^;R`02QhN700>4Q8B2PX:2PX800WemO@03MGEeJ6QXJ6QX009HF5P0
0da<C4Y:BTY:BP02EeMG00=[Jf]nOWinOWh00X>3P`03LW9bE5ADE5AD008h>3P00bl_;dA4A4A4A002
K6a/00>EUIF_[jn_[jl00Zn_[`03VYZJO7alO7al009QHF42Cdm?00=6ATI3@d=3@d<00TM7A`03Cdm?
G5aLG5aL009/K6`00g]kNhF5QHF5Q@02S8b<00>?ShnATI6ATI400i:BTP:@T902SHf=00>8R8R3Ph>3
Ph<00WemO@03MGEeJf][Jf][009QHF400e]KFeeMGEeMG@02JFUY00=kNg^<S8b<S8`00YFEU@03TY:B
QHF5QHF5009eMGD00fEUIEYJFUYJFP02E5AD00=ADE5DE5ADE5@00UeMG@03JFUYM7AdM7Ad009fMWH0
0f][JeMGEeMGE`02ADE500=0@41@D51@D5000Vi^KP03S8b<Vi^KVi^K00:CTi<00gYjNUiNGUiNGP02
CTi>00=BDU9TI6ATI6@00WMgM`03P820N7QhN7Qh009UIFD00e5ADDI6ATI6AP02AdM700=DE5ATI6AT
I6@00W=cL`9oOgl00hJ6QXV9RHV9R@02QXJ600=mOGe`L71`L7000VATI003Fe]KFUYJFUYJ009OGel0
0fMWIfm_Kfm_K`02M7Ad0gEeM@EdM7@2Lg=c00=[Jf]MGEeMGEd00Ti>CP03@d=3B4Q8B4Q8009QHF40
0hF5QJVYZJVYZ@02_Kfm00>h^;RRXZ:RXZ800XN7Q`03Lg=cKVi^KVi^00Coool00`000?ooooooo`0@
oooo000Uoooo0P0000?oool2Shn?00>BTY:EUIFEUID01IJFUP>EUID2Ti>C0Y:BTP03T92@SXj>SXj>
00:;Rh/00hR8R8B4Q8B4Q002Ogmo00=jNWYeMGEeMGD00W5aL@03Kfm_KVi^KVi^009aLG400gIfMWmo
OgmoO`02RXZ:00>HV9RWYjNWYjL00[Fe]@03a<C4dM7AdM7A00;Lg=`2i>CT00?YjNW/k>c/k>`00^c/
k003j^[Zi^KVi^KV00;Ph>000mOGelk>c/k>cP02`/;200>f][JZZZZZZZX00YnOW`03U9BDRXZ:RXZ:
00:3Ph<00ginOWalO7alO002O7al00=nOWj2PX:2PX800XN7Q`03SXj>UiNGUiNG00:PX:000jZZZ[>c
/k>c/`02_Kfm00?6a/K=cLg=cLd00];BdP03e=CDdm?Cdm?C00;@d=000l[:b/?3`l?3``02_;bl00>d
];B^[Zj^[Zh00ZZZZP>XZ:P2ZZZZ00>^[Zjb/[:b/[800[Jf]P03^k^k`<30`<3000;3`l<00lK6a/S8
b<S8b002bLW91L[:bP03b<S8a/K6a/K600;3`l<00kno_k^k^k^k^`02][Jf00>a/K6[Zj^[Zj/00ZJV
YP:RXZ800ifMWIVIVIVIV@02UIFE00>ATI6<S8b<S8`00XR8R003PX:2OGemOGem009gMgL00g5aLF][
Jf][J`02IFEU00=PH61KFe]KFe/00UIFEP03DU9BCTi>CTi>009;Bd/00dY:BTU9BDU9B@02BDU900=;
Bd]>CTi>CTh00U9BDP03F5QHGemOGemO009WIfL00fm_KgMgMgMgM`02OWin00>5QHF;Rh^;Rh/00ooo
o`80000doooo00@0003oooooooooool2MWIf00>2PX:<S8b<S8`00Y2@T003Shn?Rh^;Rh^;00:7QhL0
0hB4Q8:2PX:2PP02OGem00=eMGEXJ6QXJ6P00UQHF003C4a<BTY:BTY:009GEeL00f][JginOWinOP02
Ph>300=bLW9DE5ADE5@00SPh>003;bl_A4A4A4A4009/K6`00iFEUJn_[jn_[`02[jn_00>JVYYlO7al
O7`00V5QH@9?Cdl00dI6AT=3@d=3@`02AdM700=?CdmLG5aLG5`00Va/K003Ng]kQHF5QHF500:<S8`0
0hn?Si6ATI6AT@03TY:B0Y2@T0:=SHd00hR8R8>3Ph>3P`02OGem00=eMGE[Jf][Jf/00V5QH@03Fe]K
GEeMGEeM009YJFT00g]kNhb<S8b<S002UIFE00>BTY:5QHF5QHD00WEeM@03IFEUFUYJFUYJ009DE5@0
0e5ADEADE5ADE002GEeM00=YJFUdM7AdM7@00WIfMP03Jf][EeMGEeMG0095ADD00d10@51@D51@D002
KVi^00><S8bKVi^KVi/00Y>CT`03NWYjGUiNGUiN009>CTh00e9BDVATI6ATI002MgMg00>0P81hN7Qh
N7P00VEUI@03DE5AATI6ATI60097AdL00eADE6ATI6ATI002Lg=c0WmoO`03QXJ6RHV9RHV900:6QXH0
0gemOG1`L71`L002I6AT00=KFe]JFUYJFUX00UmOG`03IfMWKfm_Kfm_009dM7@3MGEe1GAdM09cLg<0
0f][JeeMGEeMG@02CTi>00=3@d=8B4Q8B4P00V5QH@03QHF5ZJVYZJVY00:m_Kd00kRh^::RXZ:RXP02
QhN700=cLg=^KVi^KVh00oooo`80000Boooo000Uoooo00<0003oooooool00_ooo`><S8`2Rh^;0XZ:
RP03R8R8QXJ6QXJ600:5QHD5Q8B41HF5Q@03Ph>3P820P820009lO7`00gMgMg5aLG5aL@02K6a/00=X
J6QVIVIVIVH00VQXJ003KFe]MWIfMWIf00:2PX800i:BTZ:RXZ:RXP02/k>c00?3`l?Bd];Bd]800]oO
g`;Xj>P00ng]kO3`l?3`l002l?3`00?^k^kYjNWYjNT00^;RhP03f][Jclo?clo?00;4a<@00kRh^:^[
Zj^[Z`02WinO00>DU9B:RXZ:RXX00X:2PP03OGemNg]kNg]k009kNg/00gemOH20P820P002QXJ600>=
SHfFUYJFUYH00YnOW`03ZZZZ];Bd];Bd00:n_[h00lO7alo?clo?c`02eMGE00?Hf=SGemOGemL00]CD
e003c/k>alO7alO700:o_kl00kRh^;6a/K6a/@02[Jf]0jZZZP:/[:`00k2`/;Bd];Bd]002^;Rh00>l
_;c0`<30`<000/C4a003a/K6b<S8b<S800;9bLT3b/[:0/W9b@03alO7a<C4a<C400:o_kl00k^k^kFe
]KFe]@02[jn_00>YZJVTY:BTY:@00YnOW`:KVi/00iRHV9JFUYJFUP02U9BD00>BTY:?Shn?Shl00Xb<
S003QhN7P820P820009hN7P00g1`L6MWIfMWI`02GemO00=GEeMADE5ADE400Te=C@03BTY:BDU9BDU9
009;Bd/00de=CE5ADE5AD@02EEEE00=JFUYOGemOGel00VEUI@03Jf][LG5aLG5a009fMWH00galO861
PH61P@02QHF500>8R8R;Rh^;Rh/01?ooo`030000oooooooo03;oool010000?ooooooooooo`9]KFd0
0gAdM7YjNWYjNP02OGem0galO09mOGd00h61PHF5QHF5Q@02QhN700>4Q8AiNGUiNGT00V][J`03GEeM
F5QHF5QH009OGel00fi^KWemOGemO@02PH6100=cLg=KFe]KFe/00TI6AP03@D51EEEEEEEE009iNGT0
0ifMWK:b/[:b/P02[Zj^00>HV9QjNWYjNWX00UmOG`9>CTh00dM7AdE5ADE5A@02BDU900=ADE5MGEeM
GEd00V][J`03MWIfOGemOGem00=oOgl2P8200X>3P`03QhN7RXZ:RXZ:00:;Rh/00hV9RH>3Ph>3P`02
OGem00=eMGE[Jf][Jf/00V9RHP=MGEd2IFEU00=cLg>0P820P8000hR8R0:2PX82N7Qh00=/K6aNGUiN
GUh00U=CD`03BTY:Bd];Bd];009IFET00fe]KH20P820P002R8R800=nOWiYJFUYJFT00U9BDP03AdM7
Cdm?Cdm?009VIVH00ginOXZ:RXZ:RP02Q8B400=`L71KFe]KFe/00Tm?C`03EEEEIVIVIVIV009hN7P0
0h20P7MgMgMgM`02I6AT00=ADE56ATI6ATH00T];B`03Fe]KKVi^KVi^009mOGd2QXJ600>8R8R6QXJ6
QXH00X61P@03N7QhKfm_Kfm_009VIVH00f1PH65QHF5QH@02IVIV00=]KFecLg=cLg<00WIfMP03MGEe
LW9bLW9b009`L703Kfm_0Vi^KP03JFUYGEeMGEeM009@D5000dQ8B4e=CDe=C@02Hf=S00>3Ph>RXZ:R
XZ800[Bd]003/K6aWYjNWYjN00:5QHD00g9bLVYZJVYZJP04oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool2R8R800>5QHF1PH61PH400WemO@03NWYjMgMgMgMg009eMGD00gAdM7Ee
MGEeM@02MgMg00=jNWYlO7alO7`00WinOP03OgmoOGemOGem009iNGT00gAdM6e]KFe]K@02IfMW00=R
HV9PH61PH6000V1PH003IFEUKVi^KVi^009lO7`00hb<S9nOWinOW`02/K6a00?3`l?Cdm?Cdm<00^3P
h0;Zj^X00o3`l??clo?cl`02l_;b00?`l?3[jn_[jn/00^CTi003fm_Kd=3@d=3@00;5aLD00kRh^:b/
[:b/[002X:2P00>DU9B:RXZ:RXX00X>3P`03OGemNg]kNg]k009kNg/00galO820P820P002QXJ600>=
SHfFUYJFUYH00YnOW`03ZZZZ];Bd];Bd00:o_kl00lS8b=7AdM7Ad@02e]KF0mWIf@;Fe]H00m3@d<[:
b/[:bP02`/;200>j^[Zd];Bd];@00Zn_[`03[Jf][:b/[:b/00:^[Zh00k6a/KBd];Bd]002^;Rh00>l
_;c0`<30`<000/?3``03aLG5alO7alO700;8b<P00lW9bLS8b<S8b002alO700?5aLG1`L71`L400[bl
_003][Jf/;2`/;2`00:YZJT00j>SXifMWIfMW@02VIVI0YJFUP03UIFEU9BDU9BD00>DU9@2Ti>C0Y2@
T003S8b<QHF5QHF5009kNg/00g5aLFIVIVIVIP02Fe]K00=BDU9;Bd];Bd/00TM7A`03ATI6B4Q8B4Q8
009<C4`00e=CDeYJFUYJFP02HV9R00=ZJVYaLG5aLG400WQhN003OGemPH61PH6100:5QHD00hN7QhZ:
RXZ:RP03Rh^;0XZ:RPCoool00`000?ooooooo`0boooo00@0003oooooooooool2GUiN00=SHf=XJ6QX
J6P00fYZJP9[Jf/2L71`00=jNWZ6QXJ6QXH00Y2@T003Ti>CSHf=SHf=00:0P8000g9bLVUYJFUYJ@02
JVYZ00=aLG5jNWYjNWX00WemO@03MGEeJ6QXJ6QX009MGEd00eiNGVi^KVi^KP02R8R800>QXJ6^[Zj^
[Zh00ZNWY`03TY:BN7QhN7Qh009QHF42DU9B00==CDe<C4a<C4`00U1@D003EeMGHF5QHF5Q009[Jf/0
0g9bLW=cLg=cL`02L71`00=/K6aZJVYZJVX00Va/K003LW9bN7QhN7Qh009mOGd00gmoOh20P820P002
OWin00=jNWYcLg=cLg<00V][J`03I6ATH61PH61P009RHV800fMWIfi^KVi^KP02M7Ad00=gMgMhN7Qh
N7P00WIfMP03Kfm_Hf=SHf=S009DE5@3BDU90UQHF003LG5aRXZ:RXZ:00:GUiL00i:BTWinOWinOP02
IfMW00=GEeMDE5ADE5@00UeMG@03IfMWKVi^KVi^009[Jf/00f=SHe]KFe]KF`02FEUI00=QHF5_Kfm_
Kfl00W]kN`03OgmoM7AdM7Ad009RHV800e1@D4Q8B4Q8B002D51@00=RHV9fMWIfMWH00XJ6QP::RXX0
0hN7QgmoOgmoO`02MgMg00=bLW9^KVi^KVh00fa/K09^KVh2LW9b00=gMgMiNGUiNGT00WQhN003Lg=c
KVi^KVi^009ZJVX00fUYJFa/K6a/K002KVi^00=/K6aUIFEUIFD00UaLG003EEEEF5QHF5QH009WIfL0
0galO96ATI6AT@02W9bL00>GUiN7QhN7QhL00W=cL`03Hf=SG5aLG5aL00Coool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`:8R8P00hF5QH61PH61P@02OGem00=jNWYgMgMgMgL00WEe
M@03M7AdMGEeMGEe009gMgL00gYjNWalO7alO002OWin00=oOgmmOGemOGd00WUiN@03M7AdKFe]KFe]
009WIfL00f9RHV1PH61PH002H61P00=UIFE^KVi^KVh00WalO003S8b<WinOWinO00:a/K400l?3`m?C
dm?Cd`02h>3P0^[ZjP03l?3`lo?clo?c00;bl_800o3`l>_[jn_[j`02i>CT00?Kfm_@d=3@d=000/G5
a@03^;Rh[:b/[:b/00:PX:000iBDU8Z:RXZ:RP02Ph>300=mOGekNg]kNg/00W]kN`03O7alP820P820
00:6QXH00hf=SIJFUYJFUP02WinO00>ZZZZd];Bd];@00[no_`03b<S8dM7AdM7A00;Fe]H3fMWI0]KF
eP03d=3@b/[:b/[:00;2`/800kZj^[Bd];Bd]002[jn_00>][Jf/[:b/[:`00Zj^[P03/K6a];Bd];Bd
00:h^;P00kbl_<30`<30`002`l?300?5aLG7alO7alL00/S8b003bLW9b<S8b<S800;7alL00lG5aL71
`L71`@02_;bl00>f][J`/;2`/;000ZVYZ@03Xj>SWIfMWIfM00:IVIT2UYJF00>EUIFDU9BDU9@00iBD
U0:CTi<2T92@00><S8b5QHF5QHD00W]kN`03LG5aIVIVIVIV009KFe/00e9BDT];Bd];B`02AdM700=6
ATI8B4Q8B4P00Ta<C003De=CFUYJFUYJ009RHV800fYZJW5aLG5aL@02N7Qh00=mOGf1PH61PH400XF5
Q@03QhN7RXZ:RXZ:00>;Rh/2RXZ:1?ooo`030000oooooooo03;oool010000?ooooooooooo`9NGUh0
0f=SHfQXJ6QXJ003JVYZ0V][J`9`L7000gYjNXJ6QXJ6QP02T92@00>CTi>=SHf=SHd00X20P003LW9b
JFUYJFUY009ZJVX00g5aLGYjNWYjNP02OGem00=eMGEXJ6QXJ6P00UeMG@03GUiNKVi^KVi^00:8R8P0
0j6QXJj^[Zj^[P02YjNW00>BTY9hN7QhN7P00V5QH@9BDU800de=CDa<C4a<C002D51@00=GEeMQHF5Q
HF400V][J`03LW9bLg=cLg=c009`L7000fa/K6YZJVYZJP02K6a/00=bLW9hN7QhN7P00WemO@03Ogmo
P820P820009nOWh00gYjNW=cLg=cL`02Jf][00=TI6APH61PH6000V9RHP03IfMWKVi^KVi^009dM7@0
0gMgMgQhN7QhN002MWIf00=_KfmSHf=SHf<00UADE0=9BDT2F5QH00=aLG6:RXZ:RXX00YNGU`03TY:B
OWinOWin009WIfL00eMGEeADE5ADE002GEeM00=WIfM^KVi^KVh00V][J`03Hf=SFe]KFe]K009IFET0
0f5QHFm_Kfm_K`02Ng]k00=oOgmdM7AdM7@00V9RHP03D51@B4Q8B4Q8009@D5000f9RHWIfMWIfMP02
QXJ60XZ:RP03QhN7OgmoOgmo009gMgL00g9bLVi^KVi^KP03K6a/0Vi^KP9bLW800gMgMgUiNGUiN@02
N7Qh00=cLg=^KVi^KVh00VYZJP03JFUYK6a/K6a/009^KVh00fa/K6EUIFEUI@02G5aL00=EEEEHF5QH
F5P00VMWI`03O7alTI6ATI6A00:LW9`00iNGUhN7QhN7Q`02Lg=c00=SHf=LG5aLG5`01?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0X>3P`03OGemMgMgMgMg009aLG400fa/K6QX
J6QXJ003IFEU0VMWI`9[Jf/00fm_KgAdM7AdM002N7Qh0gYjNP9gMgL00g5aLF][Jf][J`02I6AT00=O
GemKFe]KFe/00U]KF`03H61PJFUYJFUY009gMgL00hV9RIbLW9bLW002[jn_00?2`/;Bd];Bd]800^3P
h0;Zj^X00o7alO?clo?cl`02lo?c00?`l?3[jn_[jn/00^CTi003fm_Kd=3@d=3@00;5aLD00kVi^Jb/
[:b/[002X:2P00>EUIF;Rh^;Rh/00XB4Q003OgmoO7alO7al009lO7`00ginOX:2PX:2PP02QhN700>>
SXjGUiNGUiL00Z6QX@03Zj^[]KFe]KFe00:o_kl00lS8b=3@d=3@d002e]KF0mWIf@;Fe]H00m7AdL[:
b/[:bP02`l?300>l_;be]KFe]KD00[6a/@>^[Zh2[jn_00>a/K6d];Bd];@00[Rh^003^k^k_[jn_[jn
00;1`L400l?3`lG5aLG5a@02a/K60lO7a`;5aLD00l?3`kjn_[jn_P02^KVi00>b/[:[Zj^[Zj/00ZBT
Y003WIfMUiNGUiNG00:DU9@3TY:B0Y>CT`:EUID00iNGUiRHV9RHV002UYJF00>BTY::RXZ:RXX00X20
P003M7AdIfMWIfMW009KFe/00e5ADDU9BDU9B@02ADE500=6ATI:BTY:BTX00U5AD@03Fe]KIFEUIFEU
009_Kfl00gUiNH:2PX:2PP02RHV900>=SHf@T92@T9000Y6AT@03TY:BTI6ATI6A00:?Shl00hb<S8R8
R8R8R004oooo00<0003oooooool0<_ooo`040000oooooooooooo0U1@D003De=CEUIFEUIF00=GEeL2
FEUI0V9RHP03LW9bQhN7QhN700:HV9P00j:RXYnOWinOW`02Ti>C00>4Q8AgMgMgMgL00g9bLP9eMGD2
MgMg00=fMWIdM7AdM7@00WAdM003NGUiQXJ6QXJ600:EUID00j6QXJFUYJFUY@02W9bL00>:RXYeMGEe
MGD00V=SH`9HF5P3E5AD0UQHF003GUiNIVIVIVIV009]KFd00fm_Kfa/K6a/K002I6AT00=KFe]EEEEE
EED00UEEE@03FUYJHF5QHF5Q009ZJVX00g9bLWYjNWYjNP02Ogmo00>0P81lO7alO7`00WEeM@03K6a/
I6ATI6AT009OGel3G5aL0UmOG`03IFEUKFe]KFe]009cLg<00g9bLVQXJ6QXJ002FEUI00=<C4a;Bd];
Bd/00U]KF`03MGEeT92@T92@00>PX:02TI6A0WemO@03JVYZGEeMGEeM009EEED00e9BDU5ADE5AD@02
De=C00=GEeMMGEeMGEd00VEUI@03Kfm_NGUiNGUi009oOgl00ginOW9bLW9bLP02HF5Q00=BDU9<C4a<
C4`00UEEE@03J6QXO7alO7al00::RXX2Rh^;00>3Ph=hN7QhN7P00W1`L003K6a/KVi^KVi^009bLW80
0gIfMWYjNWYjNP02OGem00=oOgmnOWinOWh00WUiN@03LW9bJVYZJVYZ00=UIFD2JFUY0Vi^KP03L71`
KVi^KVi^009YJFT3I6AT0VYZJP03M7AdOGemOGem00:0P8000gUiNFe]KFe]K@02GemO00=DE5A?Cdm?
Cdl01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0X>3P`03OGemMgMgMgMg
009aLG400fa/K6QXJ6QXJ003IFEU0VMWI`9[Jf/00fm_KgAdM7AdM002N7Qh0gYjNP9gMgL00g5aLF][
Jf][J`02I6AT00=OGemKFe]KFe/00U]KF`03H61PJFUYJFUY009gMgL00hV9RIbLW9bLW002[jn_00?2
`/;Bd];Bd]800^3Ph0;Zj^X00o7alO?clo?cl`02lo?c00?`l?3[jn_[jn/00^CTi003fm_Kd=3@d=3@
00;5aLD00kVi^Jb/[:b/[002X:2P00>EUIF;Rh^;Rh/00XB4Q003OgmoO7alO7al009lO7`00ginOX:2
PX:2PP02QhN700>>SXjGUiNGUiL00Z6QX@03Zj^[]KFe]KFe00:o_kl00lS8b=3@d=3@d002e]KF0mWI
f@;Fe]H00m7AdL[:b/[:bP02`l?300>l_;be]KFe]KD00[6a/@>^[Zh2[jn_00>a/K6d];Bd];@00[Rh
^003^k^k_[jn_[jn00;1`L400l?3`lG5aLG5a@02a/K60lO7a`;5aLD00l?3`kjn_[jn_P02^KVi00>b
/[:[Zj^[Zj/00ZBTY003WIfMUiNGUiNG00:DU9@3TY:B0Y>CT`:EUID00iNGUiRHV9RHV002UYJF00>B
TY::RXZ:RXX00X20P003M7AdIfMWIfMW009KFe/00e5ADDU9BDU9B@02ADE500=6ATI:BTY:BTX00U5A
D@03Fe]KIFEUIFEU009_Kfl00gUiNH:2PX:2PP02RHV900>=SHf@T92@T9000Y6AT@03TY:BTI6ATI6A
00:?Shl00hb<S8R8R8R8R004oooo00<0003oooooool0<_ooo`040000oooooooooooo0U1@D003De=C
EUIFEUIF00=GEeL2FEUI0V9RHP03LW9bQhN7QhN700:HV9P00j:RXYnOWinOW`02Ti>C00>4Q8AgMgMg
MgL00g9bLP9eMGD2MgMg00=fMWIdM7AdM7@00WAdM003NGUiQXJ6QXJ600:EUID00j6QXJFUYJFUY@02
W9bL00>:RXYeMGEeMGD00V=SH`9HF5P3E5AD0UQHF003GUiNIVIVIVIV009]KFd00fm_Kfa/K6a/K002
I6AT00=KFe]EEEEEEED00UEEE@03FUYJHF5QHF5Q009ZJVX00g9bLWYjNWYjNP02Ogmo00>0P81lO7al
O7`00WEeM@03K6a/I6ATI6AT009OGel3G5aL0UmOG`03IFEUKFe]KFe]009cLg<00g9bLVQXJ6QXJ002
FEUI00=<C4a;Bd];Bd/00U]KF`03MGEeT92@T92@00>PX:02TI6A0WemO@03JVYZGEeMGEeM009EEED0
0e9BDU5ADE5AD@02De=C00=GEeMMGEeMGEd00VEUI@03Kfm_NGUiNGUi009oOgl00ginOW9bLW9bLP02
HF5Q00=BDU9<C4a<C4`00UEEE@03J6QXO7alO7al00::RXX2Rh^;00>3Ph=hN7QhN7P00W1`L003K6a/
KVi^KVi^009bLW800gIfMWYjNWYjNP02OGem00=oOgmnOWinOWh00WUiN@03LW9bJVYZJVYZ00=UIFD2
JFUY0Vi^KP03L71`KVi^KVi^009YJFT3I6AT0VYZJP03M7AdOGemOGem00:0P8000gUiNFe]KFe]K@02
GemO00=DE5A?Cdm?Cdl01?ooo`030000oooooooo013oool001_oool300000_ooo`030000oooooooo
00;oool00`000?ooooooo`02oooo0WinOP03MWIfKVi^KVi^009VIVH00emOGeYJFUYJFP03F5QH0U]K
F`9OGel00fEUIF][Jf][J`02LG5a00=eMGEgMgMgMgL00WAdM003L71`JFUYJFUY009SHf<00eeMGEUI
FEUIF@02FEUI00=MGEeWIfMWIfL00WEeM@03QXJ6VYZJVYZJ00:][Jd00l30`=7AdM7Ad@02g]kN0^SX
j003k^k^lO7alO7a00;`l?000ng]kNSXj>SXj002hN7Q00?IfMW?clo?cll00/?3``03^;Rh[:b/[:b/
00:QXJ400iJFUXf=SHf=S@02QXJ600>1PH5oOgmoOgl00WmoO`03PX:2QXJ6QXJ600:;Rh/00i:BTYZJ
VYZJVP02Xj>S00>/[:bf][Jf][H00[no_`03alO7c/k>c/k>00;Cdm<00mKFe]GEeMGEe@02dm?C00?>
c/k8b<S8b<P00/;2`P03^k^k]KFe]KFe00:a/K45[Zj^00>`/;2c/k>c/k<00[Fe]@03^;Rh^k^k^k^k
00:n_[h00l30`<;2`/;2`P02`l?30lC4a0;3`l<00l30`;bl_;bl_002][Jf00>_[jnXZ:RXZ:P00Z6Q
X@03VYZJU9BDU9BD00:ATI42T92@00>ATI6DU9BDU9@00YRHV003Vi^KWIfMWIfM00:LW9`00iVIVI6A
TI6AT@02QhN700=jNWY]KFe]KFd00V1PH003EEEECDe=CDe=0099BDT00d];Be1@D51@D002FEUI00=U
IFEaLG5aLG400WemO@03R8R8TI6ATI6A00:GUiL00i^KVibLW9bLW002Vi^K00>JVYZFUYJFUYH00Y:B
TP03S8b<QHF5QHF500Coool00`000?ooooooo`0Woooo0`0000;oool00`000?ooooooo`03oooo00@0
003oooooooooool3BTY:0TU9B@98B4P00dM7Ad];Bd];B`02EeMG00=/K6b6QXJ6QXH00YjNWP03[:b/
Zj^[Zj^[00:OWil00hj>SWinOWinOP02Lg=c00=^KVi]KFe]KFd00Vm_K`03LW9bMgMgMgMg009nOWh0
0hN7Qi2@T92@T002UiNG00>KVi^IVIVIVIT00Y2@T003PX:2Lg=cLg=c009WIfL2GUiN0eYJFP9MGEd0
0fATI6e]KFe]K@02Lg=c00=dM7A/K6a/K6`00UmOG`03D51@ATI6ATI60094A4@00dQ8B55ADE5AD@02
G5aL00=XJ6QcLg=cLg<00WalO003P820OgmoOgmo009iNGT00g1`L6IVIVIVIP02GEeM00=FEUIBDU9B
DU800UADE003Fe]KIfMWIfMW009aLG400gEeMFi^KVi^KP02H61P00=DE5ABDU9BDU800UmOG`03MWIf
SHf=SHf=00:NWYh00j6QXIZJVYZJVP02S8b<00=jNWYWIfMWIfL00UIFEP03B4Q8@T92@T920096ATH0
0e9BDV9RHV9RHP02LG5a00=kNg^1PH61PH400X:2PP03OGemLW9bLW9b009TI6@00eMGEe=CDe=CD`02
FUYJ00=ZJVYlO7alO7`00XN7Q`:8R8P00h61PGMgMgMgM`02KVi^00=[Jf]]KFe]KFd00W1`L003MGEe
NGUiNGUi009mOGd3Ogmo0WYjNP03LW9bJVYZJVYZ009UIFD00fATI6MWIfMWI`02K6a/00=_KfmaLG5a
LG400W1`L003KVi^KFe]KFe]00=]KFd2K6a/0VUYJ@03I6ATGEeMGEeM009FEUH00e1@D4a<C4a<C004
oooo00<0003oooooool04?ooo`007?ooo`060000oooooooo0000oooo00000oooo`030000oooooooo
00;oool2NWYj00=`L71WIfMWIfL00UeMG@03EEEECdm?Cdm?009<C4`00de=CE1@D51@D002EEEE00=L
G5aTI6ATI6@00V][J`03LG5aLg=cLg=c009bLW800fm_KfUYJFUYJ@02Hf=S00=NGUiKFe]KFe/00U]K
F`03GemOJ6QXJ6QX009fMWH00hJ6QYVIVIVIV@02Zj^[00>m_Kg=cLg=cLd00][JfP;Ti>@00nWYjN_[
jn_[j`02jn_[00?Xj>SShn?Shn<00]gMg@03e=CDbl_;bl_;00;1`L400kJf]Zb/[:b/[002XJ6Q00>H
V9R@T92@T9000XV9R@03QXJ6Q8B4Q8B400:5QHD00hN7Qhb<S8b<S002TI6A00>GUiNOWinOWil00ZNW
Y`03[Zj^][Jf][Jf00:m_Kd00lC4a<W9bLW9b@02cLg=0lo?c`;<c<`00lS8b<?3`l?3``02_[jn00>h
^;Rc/k>c/k<00Zn_[`03[Jf][:b/[:b/00:/[:`00jf][Jn_[jn_[`02/K6a00>d];Bf][Jf][H00[Vi
^@03^k^k_Kfm_Kfm00:o_kl00l30`<71`L71`@02`<3000>n_[jj^[Zj^[X00[Bd]003[Zj^YZJVYZJV
00:OWil00iRHV9>CTi>CT`04T92@00>CTi>GUiNGUiL00Y^KV`03X:2PXj>SXj>S00:SXj<00j2PX9ZJ
VYZJVP02Shn?00>3Ph=fMWIfMWH00VUYJ@03GUiNEeMGEeMG009CDe<00eEEEE]KFe]KF`02IFEU00=a
LG5mOGemOGd00XV9R@03U9BDWIfMWIfM00:RXZ83YJFU0Z:RXP03WinOVYZJVYZJ00:CTi<00hb<S8>3
Ph>3P`04oooo00<0003oooooool0:?ooo`060000oooooooo0000oooo00001?ooo`040000oooooooo
oooo0U5AD@03BTY:A4A4A4A40090@4000clo?dA4A4A4A002DE5A00=YJFV5QHF5QHD00YnOW`03[Zj^
[Jf][Jf]00:OWil00h^;RgUiNGUiN@02K6a/00=VIVITI6ATI6@00VEUI@03JFUYKfm_Kfm_009gMgL0
0gmoOhJ6QXJ6QP02Rh^;00>=SHf;Rh^;Rh/00XF5Q@03OGemLg=cLg=c009ZJVX2HV9R00=MGEeJFUYJ
FUX00UiNGP03J6QXMGEeMGEe009oOgl00h61PGMgMgMgM`02I6AT00=@D512@T92@T800Shn?P03@d=3
CDe=CDe=009IFET00f=SHfa/K6a/K002LW9b00=fMWIeMGEeMGD00W9bLP03K6a/IFEUIFEU009NGUh0
0eQHF5EEEEEEE@02EUIF00=NGUiYJFUYJFT00WAdM003N7QhM7AdM7Ad009ZJVX00f1PH5aLG5aLG002
Hf=S00=`L71oOgmoOgl00Xb<S0>BTY82SHf=00>2PX9bLW9bLW800V1PH003D51@B4Q8B4Q8009<C4`0
0eUIFFUYJFUYJ@02MgMg00>0P824Q8B4Q8@00X>3P`03OWinMGEeMGEe009ZJVX00f1PH5]KFe]KF`02
GemO00=YJFUdM7AdM7@00WemO@:1PH400h20P7alO7alO002MgMg00=`L71ZJVYZJVX00VEUI@03I6AT
IfMWIfMW009]KFd00gAdM7UiNGUiN@02NGUi00=fMWIaLG5aLG400Va/K003JFUYIVIVIVIV009UIFD0
0fIVIVQXJ6QXJ002Jf][00=^KVi_Kfm_Kfl00Ve]K@03JFUYIFEUIFEU009QHF400f1PH65QHF5QH@02
H61P00=NGUiHF5QHF5P01?ooo`030000oooooooo013oool001[oool4000000Coool0003oool00003
oooo0`0000;oool2NWYj00=`L71WIfMWIfL00UeMG@03EEEECdm?Cdm?009<C4`00de=CE1@D51@D002
EEEE00=LG5aTI6ATI6@00V][J`03LG5aLg=cLg=c009bLW800fm_KfUYJFUYJ@02Hf=S00=NGUiKFe]K
Fe/00U]KF`03GemOJ6QXJ6QX009fMWH00hJ6QYVIVIVIV@02Zj^[00>m_Kg=cLg=cLd00][JfP;Ti>@0
0nWYjN_[jn_[j`02jn_[00?Xj>SShn?Shn<00]gMg@03e=CDbl_;bl_;00;1`L400kJf]Zb/[:b/[002
XJ6Q00>HV9R@T92@T9000XV9R@03QXJ6Q8B4Q8B400:5QHD00hN7Qhb<S8b<S002TI6A00>GUiNOWinO
Wil00ZNWY`03[Zj^][Jf][Jf00:m_Kd00lC4a<W9bLW9b@02cLg=0lo?c`;<c<`00lS8b<?3`l?3``02
_[jn00>h^;Rc/k>c/k<00Zn_[`03[Jf][:b/[:b/00:/[:`00jf][Jn_[jn_[`02/K6a00>d];Bf][Jf
][H00[Vi^@03^k^k_Kfm_Kfm00:o_kl00l30`<71`L71`@02`<3000>n_[jj^[Zj^[X00[Bd]003[Zj^
YZJVYZJV00:OWil00iRHV9>CTi>CT`04T92@00>CTi>GUiNGUiL00Y^KV`03X:2PXj>SXj>S00:SXj<0
0j2PX9ZJVYZJVP02Shn?00>3Ph=fMWIfMWH00VUYJ@03GUiNEeMGEeMG009CDe<00eEEEE]KFe]KF`02
IFEU00=aLG5mOGemOGd00XV9R@03U9BDWIfMWIfM00:RXZ83YJFU0Z:RXP03WinOVYZJVYZJ00:CTi<0
0hb<S8>3Ph>3P`03oooo0P0002Soool4000000Coool0003oool00004oooo0P0000;oool2DE5A00=:
BTY4A4A4A4@00T10@003?cloA4A4A4A4009ADE400fUYJHF5QHF5Q@02WinO00>^[Zj][Jf][Jd00YnO
W`03Rh^;NGUiNGUi009/K6`00fIVIVATI6ATI002IFEU00=YJFU_Kfm_Kfl00WMgM`03OgmoQXJ6QXJ6
00:;Rh/00hf=SH^;Rh^;R`02QHF500=mOGecLg=cLg<00VYZJP9RHV800eeMGEYJFUYJFP02GUiN00=X
J6QeMGEeMGD00WmoO`03PH61MgMgMgMg009TI6@00e1@D492@T92@P02?Shn00=3@d==CDe=CDd00UUI
F@03Hf=SK6a/K6a/009bLW800gIfMWEeMGEeM@02LW9b00=/K6aUIFEUIFD00UiNGP03F5QHEEEEEEEE
009FEUH00eiNGVUYJFUYJ@02M7Ad00=hN7QdM7AdM7@00VYZJP03H61PG5aLG5aL009SHf<00g1`L7mo
OgmoO`02S8b<0i:BTP:=SHd00h:2PW9bLW9bLP02H61P00=@D518B4Q8B4P00Ta<C003FEUIJFUYJFUY
009gMgL00h20P8B4Q8B4Q002Ph>300=nOWieMGEeMGD00VYZJP03H61PFe]KFe]K009OGel00fUYJGAd
M7AdM002OGem0X61P@03P820O7alO7al009gMgL00g1`L6YZJVYZJP02IFEU00=TI6AWIfMWIfL00Ve]
K@03M7AdNGUiNGUi009iNGT00gIfMW5aLG5aL@02K6a/00=YJFUVIVIVIVH00VEUI@03IVIVJ6QXJ6QX
009[Jf/00fi^KVm_Kfm_K`02KFe]00=YJFUUIFEUIFD00V5QH@03H61PHF5QHF5Q009PH6000eiNGUQH
F5QHF003oooo0P0001;oool001[oool00`000?ooo`000002oooo00<0003oool000000oooo`030000
oooooooo00;oool2MWIf00=[Jf]QHF5QHF400UMGE`03CTi>AdM7AdM700=4A4@2B4Q80Ti>CP03EEEE
GUiNGUiN009VIVH00fe]KG1`L71`L002LG5a00=_Kfm[Jf][Jf/00VIVIP03HV9RGemOGemO009OGel0
0fATI6a/K6a/K002NGUi00>8R8RIVIVIVIT00ZZZZP03^[Zjb<S8b<S800;De=@2gMgM00?QhN7Shn?S
hn<00^?Sh`03h>3Pg=cLg=cL00;Fe]H00lk>c/K6a/K6aP02_Kfm00>d];B[Zj^[Zj/00Z:RXP03VIVI
Ti>CTi>C00:>SXh3Rh^;0Xb<S003Shn?Ti>CTi>C00:IVIT00ijNWZFUYJFUY@02Zj^[00>a/K6f][Jf
][H00[^k^`03_kno`l?3`l?300;5aLD00lK6a/G5aLG5a@02`l?300>o_knl_;bl_;`00[Ng]`03/k>c
[jn_[jn_00:/[:`00jZZZZVYZJVYZ@03ZJVY0ZZZZP:[Zj/00jf][K2`/;2`/002/[:b00>e]KFh^;Rh
^;P00[Zj^P03_;bl_Kfm_Kfm00:n_[h00kbl_;Rh^;Rh^002/k>c00>][JfVYZJVYZH00YnOW`03VIVI
U9BDU9BD00:BTY82Ti>C00>FUYJKVi^KVi/00Z2PX003YJFUZJVYZJVY00:ZZZX00jVYZJ>SXj>SX`02
VYZJ00>>SXj2PX:2PX800WMgM`03KFe]IFEUIFEU009RHV800fATI6YZJVYZJP02Lg=c00=nOWj:RXZ:
RXX00YFEU@03WYjNYZJVYZJV00:ZZZX00j^[ZjZZZZZZZP02YZJV00>RXZ:KVi^KVi/00YBDU003Rh^;
PH61PH6100Coool00`000?ooooooo`0Voooo00<0003oool000000_ooo`030000oooo000000Coool0
10000?ooooooooooo`9PH6000e5ADDA4A4A4A002?Cdm00<l?3a2@T92@T800U5AD@03JFUYQHF5QHF5
00:NWYh00j^[ZjNWYjNWY`02UIFE00=nOWiYJFUYJFT00UeMG@=IFET2Fe]K00=MGEeOGemOGel00V=S
H`03J6QXKfm_Kfm_009fMWH00g]kNgemOGemO@02O7al00=iNGUdM7AdM7@00Ve]K@9UIFD00eeMGEQH
F5QHF002Fe]K00=YJFUlO7alO7`00Xf=S@03Ti>CR8R8R8R8009bLW800eUIFDM7AdM7A`02@d=300=:
BTYEEEEEEED00UmOG`03I6ATIVIVIVIV00QUIFD2Hf=S0V9RHP=PH602Hf=S00=YJFUaLG5aLG400WQh
N003Ng]kNGUiNGUi009cLg<00fe]KFQXJ6QXJ002IVIV00=XJ6Q[Jf][Jf/00W5aL@03N7QhOWinOWin
00>3Ph<2O7al0W1`L003IFEUGemOGemO009PH6000fMWIg1`L71`L002NGUi00>0P823Ph>3Ph<00X>3
P`03P820NWYjNWYj009bLW800fYZJVEUIFEUI@02HV9R00=SHf=WIfMWIfL00Vi^KP9gMgL00h20P8N7
QhN7Q`02QHF500=iNGUWIfMWIfL00UEEE@03BTY:Bd];Bd];009EEED00f9RHVm_Kfm_K`02MgMg00=k
Ng]lO7alO7`00WQhN003LG5aIfMWIfMW009MGEd00eQHF5UIFEUIF@02GemO00=WIfM/K6a/K6`00Va/
K003JFUYIFEUIFEU009TI6@00fYZJW9bLW9bLP03N7Qh0Vm_K`Coool00`000?ooooooo`0@oooo000K
oooo0P0000;oool00`000?ooo`000003oooo00<0003oooooool00_ooo`9fMWH00f][Jf5QHF5QH@02
EeMG00=>CTi7AdM7AdL00dA4A098B4P2CTi>00=EEEENGUiNGUh00VIVIP03KFe]L71`L71`009aLG40
0fm_Kf][Jf][J`02IVIV00=RHV9OGemOGel00UmOG`03I6ATK6a/K6a/009iNGT00hR8R9VIVIVIV@02
ZZZZ00>j^[[8b<S8b<P00]CDe0;MgMd00n7QhN?Shn?Sh`02hn?S00?Ph>3Lg=cLg=`00]KFeP03c/k>
a/K6a/K600:m_Kd00kBd]:^[Zj^[Z`02XZ:R00>IVIVCTi>CTi<00Xj>SP>;Rh/2S8b<00>?ShnCTi>C
Ti<00YVIV@03WYjNYJFUYJFU00:[Zj/00k6a/KJf][Jf]P02^k^k00>o_ko3`l?3`l<00/G5a@03a/K6
aLG5aLG500;3`l<00kno_kbl_;bl_002]kNg00>c/k>_[jn_[jl00Zb/[003ZZZZZJVYZJVY00>YZJT2
ZZZZ0Z^[Z`03[Jf]/;2`/;2`00:b/[800kFe]KRh^;Rh^002^[Zj00>l_;bm_Kfm_Kd00[jn_P03_;bl
^;Rh^;Rh00:c/k<00jf][JJVYZJVYP02WinO00>IVIVDU9BDU9@00Y:BTP:CTi<00iJFUY^KVi^KV`02
X:2P00>UYJFYZJVYZJT00ZZZZP03ZJVYXj>SXj>S00:JVYX00hj>SX:2PX:2PP02MgMg00=]KFeUIFEU
IFD00V9RHP03I6ATJVYZJVYZ009cLg<00ginOXZ:RXZ:RP02UIFE00>NWYjVYZJVYZH00ZZZZP03Zj^[
ZZZZZZZZ00:VYZH00j:RXY^KVi^KV`02U9BD00>;Rh^1PH61PH401?ooo`030000oooooooo02Ooool2
00000_ooo`030000oooo000000Coool010000?ooooooooooo`9PH6000e5ADDA4A4A4A002?Cdm00<l
?3a2@T92@T800U5AD@03JFUYQHF5QHF500:NWYh00j^[ZjNWYjNWY`02UIFE00=nOWiYJFUYJFT00UeM
G@=IFET2Fe]K00=MGEeOGemOGel00V=SH`03J6QXKfm_Kfm_009fMWH00g]kNgemOGemO@02O7al00=i
NGUdM7AdM7@00Ve]K@9UIFD00eeMGEQHF5QHF002Fe]K00=YJFUlO7alO7`00Xf=S@03Ti>CR8R8R8R8
009bLW800eUIFDM7AdM7A`02@d=300=:BTYEEEEEEED00UmOG`03I6ATIVIVIVIV00QUIFD2Hf=S0V9R
HP=PH602Hf=S00=YJFUaLG5aLG400WQhN003Ng]kNGUiNGUi009cLg<00fe]KFQXJ6QXJ002IVIV00=X
J6Q[Jf][Jf/00W5aL@03N7QhOWinOWin00>3Ph<2O7al0W1`L003IFEUGemOGemO009PH6000fMWIg1`
L71`L002NGUi00>0P823Ph>3Ph<00X>3P`03P820NWYjNWYj009bLW800fYZJVEUIFEUI@02HV9R00=S
Hf=WIfMWIfL00Vi^KP9gMgL00h20P8N7QhN7Q`02QHF500=iNGUWIfMWIfL00UEEE@03BTY:Bd];Bd];
009EEED00f9RHVm_Kfm_K`02MgMg00=kNg]lO7alO7`00WQhN003LG5aIfMWIfMW009MGEd00eQHF5UI
FEUIF@02GemO00=WIfM/K6a/K6`00Va/K003JFUYIFEUIFEU009TI6@00fYZJW9bLW9bLP03N7Qh0Vm_
K`Coool00`000?ooooooo`0@oooo000Loooo00D0003oooooooooool000001?ooo`030000oooooooo
00;oool2Lg=c00=XJ6QMGEeMGEd00U9BDP03BDU9@T92@T9200<o?cl2@d=30TU9B@03DE5AFEUIFEUI
009RHV800fUYJFi^KVi^KP03L71`0Ve]K@9ZJVX00fMWIfIVIVIVIP02IfMW00=[Jf]cLg=cLg<00Win
OP03S8b<VYZJVYZJ00:YZJT00kNg]l?3`l?3``02cLg=0]CDe003f=SHfMWIfMWI00;IfMT00mKFe]?C
dm?Cd`02c/k>00?7alO0`<30`<000[Vi^@03/K6aZJVYZJVY00:RXZ800i^KViJFUYJFUP02Ti>C00>A
TI6BTY:BTY800YBDU003UiNGW9bLW9bL00:QXJ400jJVYZ^[Zj^[Z`02[jn_00>c/k>e]KFe]KD00[Rh
^003^KVi^[Zj^[Zj00>j^[X2^KVi0[Ng]`03];Bd/[:b/[:b00:_[jl00jb/[:VYZJVYZ@02YjNW00>U
YJFTY:BTY:@01J>SX`:TY:@00jJVYZRXZ:RXZ002Zj^[00>^[Zja/K6a/K400[Bd]003^;Rh^[Zj^[Zj
00:k^k/00kZj^[Ng]kNg]`02/k>c00>^[ZjWYjNWYjL00Z6QX@03W9bLV9RHV9RH00:FUYH2UiNG00>K
Vi^PX:2PX:000ZFUY@03Zj^[/;2`/;2`00:b/[800k6a/Jf][Jf][@02YJFU00>LW9bATI6ATI400XN7
Q`03OWinN7QhN7Qh009eMGD00gIfMW]kNg]kN`02Ph>300><S8bFUYJFUYH00YnOW`03YjNW[:b/[:b/
00>_[jl2[Jf]0ZRXZ003Xj>SW9bLW9bL00:CTi<00hZ:RWmoOgmoO`04oooo00<0003oooooool0:?oo
o`050000oooooooooooo000000Goool010000?ooooooooooo`9aLG400eYJFTM7AdM7A`02?Cdm00<l
?3a3@d=3@d<00U9BDP03JVYZQ8B4Q8B400:KVi/00jFUYIfMWIfMW@02QhN700=/K6aFEUIFEUH00da<
C09ADE42E5AD00=CDe=@D51@D5000Ti>CP03D51@EeMGEeMG009PH6000fUYJG1`L71`L002M7Ad00=e
MGEdM7AdM7@00W1`L09VIVH00eaLG5EEEEEEE@02F5QH00=YJFV1PH61PH400YRHV003XZ:RV9RHV9RH
00:0P8000fIVIU9BDU9BDP02CTi>00=EEEEOGemOGel00fMWI`9QHF42Fe]K0eIFEP9JFUX00eiNGV9R
HV9RHP02IVIV00=ZJVY^KVi^KVh00W9bLP03MWIfNGUiNGUi009kNg/3OGem0WalO003NWYjM7AdM7Ad
009[Jf/00f5QHEQHF5QHF002EUIF00=LG5aWIfMWIfL00WAdM003OWinPX:2PX:200:0P8000gemOGUi
NGUiN@05MgMg0WUiN@03O7alP820P82000>2PX82Ogmo0WUiN@03Lg=cJf][Jf][009SHf<00eaLG5UI
FEUIF@02GUiN0Ve]K@03PH61TI6ATI6A00:DU9@00h>3PfEUIFEUI@02AdM700<c<c<a<C4a<C400Shn
?P03DE5AIFEUIFEU009eMGD00h20P8J6QXJ6QP02Q8B400=iNGUYJFUYJFT00UMGE`03Bd];BTY:BTY:
009CDe<00emOGfQXJ6QXJ002Jf][00=ZJVYXJ6QXJ6P00Va/K003MgMgQXJ6QXJ600:BTY800i>CThN7
QhN7Q`04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2LW9b00=VIVIKFe]K
Fe/00U1@D003AdM7@410@41000<m?Cd2@4100TI6AP03CTi>EeMGEeMG009OGel00fMWIfe]KFe]K@02
LG5a00=bLW9aLG5aLG400W1`L0=_Kfl2LG5a00=eMGElO7alO7`00XF5Q@03TI6AWIfMWIfM00:YZJT0
0kBd];jn_[jn_P02a/K60/_;b`03c/k>clo?clo?00;>c/h00lc<c<W9bLW9b@02aLG500?0`<2j^[Zj
^[X00[Bd]003[Zj^Z:RXZ:RX00:SXj<00ijNWYZJVYZJVP03V9RH0YVIV@:LW9`00j2PX:BTY:BTY002
ZJVY00>][Jf`/;2`/;000[:b/PFc/k<00k:b/[2`/;2`/002[Zj^00>/[:bZZZZZZZX00ZVYZ@03YjNW
YZJVYZJV00:UYJD00j>SXj:RXZ:RXP02X:2P00>OWinNWYjNWYh00YfMW@FLW9`00ifMWInOWinOW`02
XZ:R00>VYZJZZZZZZZX00Zn_[`03/k>c][Jf][Jf00:h^;P00kVi^KNg]kNg]`02];Bd00>_[jnZZZZZ
ZZX00ZBTY003X:2PWIfMWIfM00:KVi/2WIfM00>QXJ6VYZJVYZH00Zb/[003/K6a][Jf][Jf00:i^KT0
0kZj^[Ng]kNg]`02/K6a00>ZZZZRXZ:RXZ800YVIV@03TY:BSHf=SHf=00::RXX00h^;Rhn?Shn?S`02
U9BD00>KVi^RXZ:RXZ800ZRXZ003[Jf]/K6a/K6a00:b/[800k6a/Jf][Jf][@02Z:RX00>RXZ:KVi^K
Vi/00Y:BTP03R8R8OGemOGem00Coool00`000?ooooooo`0boooo00@0003oooooooooool2O7al00=N
GUi5ADE5ADD00cPh>08o?cl2D51@00=XJ6R3Ph>3Ph<00YVIV@03X:2PTi>CTi>C009gMgL00eMGEclo
?clo?`02>3Ph00<o?cm:BTY:BTX00U9BDP03DE5ABTY:BTY:0093@d<00d92@TM7AdM7A`02DU9B00=M
GEeVIVIVIVH00Ve]K@03L71`LW9bLW9b009^KVh2IVIV00=LG5aEEEEEEED00UQHF003J6QXPH61PH61
00:IVIT00jFUYInOWinOW`02Rh^;00=cLg=RHV9RHV800UeMG@03HV9RJFUYJFUY009/K6`00fQXJ61P
H61PH002EeMG00=BDU9CDe=CDe<00UQHF003GemOIVIVIVIV009]KFd00g=cLgQhN7QhN002O7al0gem
O@=lO7`2P8200XB4Q003QXJ6PH61PH61009cLg<00f1PH4m?Cdm?C`02ADE500=8B4QDE5ADE5@00VEU
I@03MGEeP820P82000:7QhL3Rh^;0XN7Q`03PH61NWYjNWYj009gMgL00gQhN7emOGemO@02PX:200>4
Q8B2PX:2PX800WemO@03MWIfK6a/K6a/009PH6000eEEEDi>CTi>CP02DU9B0VEUI@03OgmoUYJFUYJF
00:MWId00hZ:RVMWIfMWI`02@T9200<Y:BTU9BDU9BD00S<c<`03BDU9HF5QHF5Q009eMGD00h>3Phb<
S8b<S002S8b<00=oOgm[Jf][Jf/00UIFEP03AdM7ADE5ADE5009>CTh00eaLG6QXJ6QXJ002K6a/0f][
J`9bLW800h:2PYNGUiNGU`02YZJV00>YZJVHV9RHV9P01?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0W9bLP03IVIVFe]KFe]K009@D5000dM7Ad10@410@003?Cdm0T10@096ATH0
0di>CUMGEeMGE`02GemO00=WIfM]KFe]KFd00W5aL@03LW9bLG5aLG5a009`L703Kfm_0W5aL@03MGEe
O7alO7al00:5QHD00i6ATIfMWIfMW@02ZJVY00>d];Bn_[jn_[h00/K6aP;;bl/00lk>c/o?clo?c`02
c/k>00?<c<c9bLW9bLT00/G5a@03`<30^[Zj^[Zj00:d];@00jj^[ZRXZ:RXZ002Xj>S00>NWYjJVYZJ
VYX00iRHV0:IVIT2W9bL00>PX:2TY:BTY:@00ZVYZ@03[Jf]/;2`/;2`00:b/[85/k>c00>b/[:`/;2`
/;000Zj^[P03[:b/ZZZZZZZZ00:YZJT00jNWYjJVYZJVYP02YJFU00>SXj>RXZ:RXZ800Z2PX003WinO
WYjNWYjN00:MWId5W9bL00>MWIfOWinOWil00Z:RXP03YZJVZZZZZZZZ00:_[jl00k>c/kJf][Jf]P02
^;Rh00>i^KVg]kNg]kL00[Bd]003[jn_ZZZZZZZZ00:TY:@00j2PX9fMWIfMW@02Vi^K0YfMW@03XJ6Q
YZJVYZJV00:/[:`00k6a/KJf][Jf]P02^KVi00>j^[Zg]kNg]kL00[6a/@03ZZZZXZ:RXZ:R00:IVIT0
0i:BTXf=SHf=S@02RXZ:00>;Rh^?Shn?Shl00YBDU003Vi^KXZ:RXZ:R00:XZ:P00jf][K6a/K6a/@02
/[:b00>a/K6][Jf][Jd00ZRXZ003XZ:RVi^KVi^K00:BTY800hR8R7emOGemO@04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0WalO003GUiNADE5ADE500<h>3P2?clo0U1@D003J6QXPh>3Ph>3
00:IVIT00j2PX9>CTi>CT`02MgMg00=GEeLo?clo?cl00SPh>003?cloBTY:BTY:009BDU800e5ADDY:
BTY:BP02@d=300=2@T97AdM7AdL00U9BDP03GEeMIVIVIVIV009]KFd00g1`L79bLW9bLP02KVi^0VIV
IP03G5aLEEEEEEEE009HF5P00fQXJ861PH61P@02VIVI00>UYJFOWinOWil00X^;R`03Lg=cHV9RHV9R
009MGEd00f9RHVUYJFUYJ@02K6a/00=XJ6QPH61PH6000UMGE`03DU9BDe=CDe=C009HF5P00emOGfIV
IVIVIP02KFe]00=cLg=hN7QhN7P00WalO0=mOGd3O7al0X20P0:4Q8@00hJ6QX61PH61P@02Lg=c00=P
H61?Cdm?Cdl00TE5A@03B4Q8E5ADE5AD009UIFD00gEeMH20P820P002QhN70h^;R`:7QhL00h61PGYj
NWYjNP02MgMg00=hN7QmOGemOGd00X:2PP03Q8B4PX:2PX:2009mOGd00gIfMVa/K6a/K002H61P00=E
EEE>CTi>CTh00U9BDP9UIFD00gmoOiJFUYJFUP02WIfM00>:RXYWIfMWIfL00T92@P03:BTY9BDU9BDU
008c<c<00dU9BF5QHF5QH@02MGEe00>3Ph><S8b<S8`00Xb<S003OgmoJf][Jf][009FEUH00dM7AdE5
ADE5A@02CTi>00=LG5aXJ6QXJ6P00Va/K0=[Jf/2LW9b00>2PX:GUiNGUiL00ZJVYP03ZJVYV9RHV9RH
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9aLG400fIVIUYJFUYJFP02
D51@00=7AdM1@D51@D400cdm?@90@402ATI600==CDeFEUIFEUH00UmOG`03IfMWKFe]KFe]009bLW80
0gEeMGIfMWIfMP02MgMg00=hN7QiNGUiNGT00WalO003P820QXJ6QXJ600:>SXh00iNGUj2PX:2PX002
ZJVY00>a/K6i^KVi^KT00[jn_P;2`/83a<C40/?3``03`/;2_kno_kno00:l_;`00kRh^;Bd];Bd]002
/;2`00>[Zj^WYjNWYjL00ZBTY003X:2PWYjNWYjN00:NWYh00inOWj6QXJ6QX@02Y:BT00>XZ:R/[:b/
[:`00[2`/003/k>c];Bd];Bd00:d];@00k>c/k2`/;2`/002[Jf]00>XZ:RTY:BTY:@00Z6QX@03WIfM
Vi^KVi^K00:JVYX:VIVI00>HV9RGUiNGUiL00YJFUP03UIFEU9BDU9BD00:DU9@00iFEUINGUiNGU`02
VYZJ00>OWinTY:BTY:@00ZVYZ@03[jn_/k>c/k>c00:f][H00kRh^;Ng]kNg]`02]KFe00>a/K6][Jf]
[Jd00ZVYZ@03YJFUXZ:RXZ:R00:RXZ82Xj>S00>WYjN/[:b/[:`00[:b/P03^;Rh_Kfm_Kfm00;0`<00
0l;2`/71`L71`@02_Kfm00>h^;Rb/[:b/[800Zb/[003YjNWXj>SXj>S00>PX:02XZ:R0ZJVYP03ZZZZ
[Zj^[Zj^00:a/K400kBd];Fe]KFe]@02];Bd00>a/K6][Jf][Jd00ZRXZ003XJ6QVYZJVYZJ00:ATI40
0hN7QgalO7alO004oooo00<0003oooooool0<_ooo`040000oooooooooooo0WemO@03F5QH>SXj>SXj
008[:b/00bXZ:S8b<S8b<P02ADE500=QHF5oOgmoOgl00YRHV003WinOSHf=SHf=009YJFT00d92@RPX
:2PX:00292@T00<c<c=7AdM7AdL00UMGE`03FEUIDU9BDU9B009:BTX00dE5ADQ8B4Q8B002DE5A00=J
FUYQHF5QHF400VIVIP03JFUYJf][Jf][009YJFT2Hf=S00=MGEeIFEUIFET00U]KF`03J6QXO7alO7al
00:>SXh00iZJVYRHV9RHV002SHf=00=oOgmbLW9bLW800Ve]K@03K6a/KFe]KFe]009/K6`00fQXJ69R
HV9RHP02GUiN00=LG5aOGemOGel00VATI003Jf][L71`L71`009eMGD00gMgMgYjNWYjNP03NWYj0WUi
N@9hN7P00gYjNX61PH61P@02RXZ:00>?Shn<S8b<S8`00WinOP03JFUYE5ADE5AD0096ATH00dA4A4a<
C4a<C002FEUI00=XJ6QeMGEeMGD00X61P@03RHV9S8b<S8b<00:9RHT00h61PGUiNGUiN@02M7Ad00=f
MWIlO7alO7`00X:2PP03QHF5PX:2PX:2009kNg/00g5aLFIVIVIVIP02FEUI00=>CTi7AdM7AdL00Te=
C@9QHF400galO9FEUIFEU@02WIfM00>=SHe]KFe]KFd00T];B`03<c<c;bl_;bl_008k>c/00dm?CfAT
I6ATI002MWIf00>3Ph>;Rh^;Rh/00X^;R`03P820Kfm_Kfm_009LG5`00dm?Cdi>CTi>CP02EeMG00=S
Hf=]KFe]KFd00W1`L003KFe]K6a/K6a/009cLg<00hJ6QYjNWYjNWP02/;2`00>c/k>OWinOWil01?oo
o`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0W5aL@03IVIVFUYJFUYJ009@D500
0dM7Ad51@D51@@03?Cdm0T10@096ATH00de=CEIFEUIFEP02GemO00=WIfM]KFe]KFd00W9bLP03MGEe
MWIfMWIf009gMgL00gQhN7UiNGUiN@02O7al00>0P826QXJ6QXH00Xj>SP03UiNGX:2PX:2P00:YZJT0
0k6a/KVi^KVi^@02_[jn0/;2`P?4a<@2`l?300?2`/:o_kno_kl00[bl_003^;Rh];Bd];Bd00:`/;00
0j^[ZjNWYjNWY`02Y:BT00>PX:2NWYjNWYh00YjNWP03WinOXJ6QXJ6Q00:TY:@00jRXZ:b/[:b/[002
/;2`00>c/k>d];Bd];@00[Bd]003/k>c/;2`/;2`00:][Jd00jRXZ:BTY:BTY002XJ6Q00>MWIfKVi^K
Vi/00YZJVPZIVIT00iRHV9NGUiNGU`02UYJF00>EUIFDU9BDU9@00YBDU003UIFEUiNGUiNG00:JVYX0
0inOWjBTY:BTY002ZJVY00>_[jnc/k>c/k<00[Jf]P03^;Rh]kNg]kNg00:e]KD00k6a/Jf][Jf][@02
ZJVY00>UYJFRXZ:RXZ800Z:RXP:SXj<00jNWYjb/[:b/[002/[:b00>h^;Rm_Kfm_Kd00/30`003`/;2
`L71`L7100:m_Kd00kRh^;:b/[:b/P02[:b/00>WYjNSXj>SXj<00j2PX0:RXZ82YZJV00>ZZZZ^[Zj^
[Zh00[6a/@03];Bd]KFe]KFe00:d];@00k6a/Jf][Jf][@02Z:RX00>QXJ6JVYZJVYX00Y6AT@03QhN7
O7alO7al00Coool00`000?ooooooo`0boooo00@0003oooooooooool2OGem00=HF5Pj>SXj>SX00R/[
:`03:RXZ<S8b<S8b0095ADD00f5QHGmoOgmoO`02V9RH00>OWin=SHf=SHd00VUYJ@03@T92:2PX:2PX
008T92@00c<c<dM7AdM7A`02EeMG00=IFEUBDU9BDU800TY:BP03ADE5B4Q8B4Q8009ADE400eYJFV5Q
HF5QH@02IVIV00=YJFU[Jf][Jf/00VUYJ@9SHf<00eeMGEUIFEUIF@02Fe]K00=XJ6QlO7alO7`00Xj>
SP03VYZJV9RHV9RH00:=SHd00gmoOg9bLW9bLP02KFe]00=/K6a]KFe]KFd00Va/K003J6QXHV9RHV9R
009NGUh00eaLG5mOGemOG`02I6AT00=[Jf]`L71`L7000WEeM@03MgMgNWYjNWYj00=jNWX2NGUi0WQh
N003NWYjPH61PH6100::RXX00hn?Shb<S8b<S002OWin00=YJFUDE5ADE5@00TI6AP03A4A4C4a<C4a<
009IFET00fQXJ7EeMGEeM@02PH6100>9RHV<S8b<S8`00XV9R@03PH61NGUiNGUi009dM7@00gIfMWal
O7alO002PX:200>5QHF2PX:2PX800W]kN`03LG5aIVIVIVIV009IFET00di>CTM7AdM7A`02CDe=0V5Q
H@03O7alUIFEUIFE00:MWId00hf=SFe]KFe]K@02Bd];00<c<c<_;bl_;bl00S/k>`03Cdm?I6ATI6AT
009fMWH00h>3Ph^;Rh^;R`02Rh^;00>0P81_Kfm_Kfl00UaLG003Cdm?CTi>CTi>009GEeL00f=SHfe]
KFe]K@02L71`00=]KFe/K6a/K6`00W=cL`03QXJ6WYjNWYjN00:`/;000k>c/inOWinOW`04oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2LW9b00=WIfMMGEeMGEd00U=CD`03Bd];
ADE5ADE50092@T800d51@DA4A4A4A002BDU900=@D51HF5QHF5P00V1PH003J6QXKfm_Kfm_009eMGD0
0gUiNGemOGemO@02Ogmo00>2PX:4Q8B4Q8@00XR8R003S8b<TI6ATI6A00:GUiL00ijNWZBTY:BTY002
ZZZZ00>`/;2e]KFe]KD00[Rh^0:j^[X3^k^k0[Zj^P03^;Rh][Jf][Jf00:d];@00k:b/Zn_[jn_[`02
[:b/00>YZJVWYjNWYjL00ZFUY@FSXj<00jFUYJRXZ:RXZ002Zj^[00>^[Zjb/[:b/[800[Fe]@>f][H2
];Bd00>`/;2[Zj^[Zj/00ZBTY003WYjNV9RHV9RH00:BTY800hj>SX^;Rh^;R`03RXZ:0X^;R`:<S8`0
0hj>SXn?Shn?S`02T92@0hn?S`:=SHd00hb<S8^;Rh^;R`02Rh^;00><S8b>SXj>SXh00Y:BTP03UiNG
WYjNWYjN00:TY:@00j^[Zk6a/K6a/@02]KFe0kRh^0:g]kL00kFe]K6a/K6a/@02[Zj^00>[Zj^YZJVY
ZJT00ZVYZ@:ZZZX00jj^[[>c/k>c/`02^;Rh00>n_[k3`l?3`l<00/O7a`03bLW9b/[:b/[:00;8b<P0
0lK6a/;2`/;2`P02_[jn00>k^k^h^;Rh^;P00[Jf]P>e]KD2]kNg00>h^;Ri^KVi^KT00kVi^@:h^;P2
]KFe00>a/K6/[:b/[:`00ZNWY`03X:2PVIVIVIVI00:@T9000hN7QgemOGemO@04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0WIfMP03CDe=;2`/;2`/008K6a/00aTI6B<S8b<S8`02>3Ph00=I
FEUlO7alO7`00YVIV@03XJ6QRh^;Rh^;009PH6000c<c<aDE5ADE5@025ADE00<[:b]8B4Q8B4P00V1P
H003J6QXI6ATI6AT009MGEd3EeMG0U]KF`03GUiNHF5QHF5Q00ERHV82HF5Q0V1PH0=OGel2HV9R00=Y
JFUbLW9bLW800WalO003Ph>3QhN7QhN700:8R8P00hJ6QX61PH61P@02Ng]k00=cLg=/K6a/K6`00VQX
J003IVIVJ6QXJ6QX009/K6`00g1`L7EeMGEeM@02NWYj00=mOGenOWinOWh00WalO003N7QhM7AdM7Ad
009aLG43Kfm_0W5aL@03MgMgPH61PH6100:<S8`00iBDU9FEUIFEU@02RXZ:00=hN7QUIFEUIFD00UEE
E@==CDd2DE5A00=JFUYUIFEUIFD00W1`L003Ng]kPH61PH6100:0P8000gYjNWAdM7AdM002L71`00=d
M7AlO7alO7`00X>3P`03QHF5OgmoOgmo009dM7@00fQXJ5]KFe]KF`02D51@00=9BDU7AdM7AdL00Ti>
CP9PH6000gQhN8f=SHf=S@02UYJF00><S8afMWIfMWH00UeMG@03Bd];B4Q8B4Q8009ADE400emOGfi^
KVi^KP02NGUi00>0P825QHF5QHD00XB4Q003OGemLW9bLW9b009WIfL00emOGf1PH61PH002IfMW00=`
L71fMWIfMWH00WAdM003KVi^JVYZJVYZ009`L7000h>3PibLW9bLW002/;2`00>b/[:LW9bLW9`01?oo
o`030000oooooooo013oool002Goool200000oooo`9eMGD00f][Jf9RHV9RHP02FEUI00=BDU9=CDe=
CDd00dY:BP9<C4`2D51@00=FEUINGUiNGUh00VEUI@03KFe]M7AdM7Ad009jNWX00h20P8B4Q8B4Q002
RHV900><S8b@T92@T9000YBDU003V9RHW9bLW9bL00:QXJ400jFUYJVYZJVYZ@02[Jf]00>`/;2b/[:b
/[800[Bd]0:e]KD3];Bd0[>c/`03/K6a/;2`/;2`00:^[Zh00jf][J^[Zj^[Z`02ZJVY00>XZ:RWYjNW
YjL01JJVYP:WYjL00jZZZZb/[:b/[002[jn_00>b/[:e]KFe]KD00kJf]P:d];@2/;2`00>ZZZZSXj>S
Xj<00YZJVP03TY:BRXZ:RXZ:00:3Ph<00ginOW]kNg]kN`03NWYj0WalO09oOgl00h:2PXB4Q8B4Q002
QHF500>6QXJ5QHF5QHD00XB4Q003PX:2PH61PH6100:1PH400h:2PXF5QHF5Q@02RXZ:00>@T92HV9RH
V9P00Z2PX003Z:RX[jn_[jn_00:e]KD00kVi^K^k^k^k^`02^k^k00>i^KVg]kNg]kL00[Bd]003/K6a
/;2`/;2`00:`/;02/K6a00>e]KFi^KVi^KT00[jn_P03a<C4bLW9bLW900;=cLd00m3@d=;Bd];BdP02
d];B00?AdM7@d=3@d=000/k>cP03c<c<b/[:b/[:00;9bLT00lS8b<K6a/K6aP02a/K600?4a<C3`l?3
`l<00/71`@03_[jn^[Zj^[Zj00:f][H00k:b/Zb/[:b/[002YZJV00>PX:2IVIVIVIT00Y6AT@03R8R8
OgmoOgmo00?oool20000=?ooo`040000oooooooooooo0Ve]K@03A4A48R8R8R8R008A4A400`l?3aTI
6ATI6@02<30`00=DE5AkNg]kNg/00Y^KV`03Y:BTRh^;Rh^;009MGEd00b/[:``<30`<30023Ph>00<Y
:BU=CDe=CDd00Va/K0=iNGT2Lg=c00=]KFeYJFUYJFT00VUYJ@03IfMWI6ATI6AT009PH6000eaLG5YJ
FUYJFP02Fe]K0UeMG@03HV9RIfMWIfMW00=ZJVX2JFUY0VQXJ003Jf][Lg=cLg=c009oOgl00hR8R8b<
S8b<S002QHF500=hN7Q[Jf][Jf/00VATI003IVIVKfm_Kfm_009kNg/00hF5QHb<S8b<S002SXj>00>=
SHf9RHV9RHT00X20P003MWIfK6a/K6a/009UIFD00f9RHVATI6ATI002JFUY00=bLW9nOWinOWh00X^;
R`03U9BDUiNGUiNG00:BTY800hN7QgQhN7QhN002JFUY00=LG5aCDe=CDe<00de=C@9DE5@2GemO00=[
Jf]cLg=cLg<00WEeM@03LG5aKFe]KFe]009/K6`00g9bLW]kNg]kN`02PX:200>3Ph=kNg]kNg/00Va/
K003GEeMD51@D51@0099BDT00dQ8B4];Bd];B`02E5AD0V=SH`03MGEeQ8B4Q8B400:<S8`00hV9RGin
OWinOP02L71`00=VIVIUIFEUIFD00VUYJ@03LG5aMgMgMgMg00EkNg/2NWYj00=hN7QeMGEeMGD00W9b
LP03LG5aLg=cLg=c009hN7P3OGem0WQhN003Kfm_JFUYJFUY009]KFd00ginOYJFUYJFUP02Z:RX00>Z
ZZZCTi>CTi<00oooo`80000Boooo000Uoooo00<0003oooooool00_ooo`9eMGD00f][Jf9RHV9RHP02
FEUI00=BDU9=CDe=CDd00dY:BP9<C4`2D51@00=FEUINGUiNGUh00VEUI@03KFe]M7AdM7Ad009jNWX0
0h20P8B4Q8B4Q002RHV900><S8b@T92@T9000YBDU003V9RHW9bLW9bL00:QXJ400jFUYJVYZJVYZ@02
[Jf]00>`/;2b/[:b/[800[Bd]0:e]KD3];Bd0[>c/`03/K6a/;2`/;2`00:^[Zh00jf][J^[Zj^[Z`02
ZJVY00>XZ:RWYjNWYjL01JJVYP:WYjL00jZZZZb/[:b/[002[jn_00>b/[:e]KFe]KD00kJf]P:d];@2
/;2`00>ZZZZSXj>SXj<00YZJVP03TY:BRXZ:RXZ:00:3Ph<00ginOW]kNg]kN`03NWYj0WalO09oOgl0
0h:2PXB4Q8B4Q002QHF500>6QXJ5QHF5QHD00XB4Q003PX:2PH61PH6100:1PH400h:2PXF5QHF5Q@02
RXZ:00>@T92HV9RHV9P00Z2PX003Z:RX[jn_[jn_00:e]KD00kVi^K^k^k^k^`02^k^k00>i^KVg]kNg
]kL00[Bd]003/K6a/;2`/;2`00:`/;02/K6a00>e]KFi^KVi^KT00[jn_P03a<C4bLW9bLW900;=cLd0
0m3@d=;Bd];BdP02d];B00?AdM7@d=3@d=000/k>cP03c<c<b/[:b/[:00;9bLT00lS8b<K6a/K6aP02
a/K600?4a<C3`l?3`l<00/71`@03_[jn^[Zj^[Zj00:f][H00k:b/Zb/[:b/[002YZJV00>PX:2IVIVI
VIT00Y6AT@03R8R8OgmoOgmo00Coool00`000?ooooooo`0boooo00@0003oooooooooool2KFe]00=4
A4@R8R8R8R800Q4A4@033`l?6ATI6ATI008`<3000eADE7]kNg]kN`02Vi^K00>TY:B;Rh^;Rh/00UeM
G@03:b/[30`<30`<008>3Ph00bTY:De=CDe=C@02K6a/0gUiN@9cLg<00fe]KFUYJFUYJ@02JFUY00=W
IfMTI6ATI6@00V1PH003G5aLFUYJFUYJ009KFe/2GEeM00=RHV9WIfMWIfL00fYZJP9YJFT2J6QX00=[
Jf]cLg=cLg<00WmoO`03R8R8S8b<S8b<00:5QHD00gQhN6][Jf][J`02I6AT00=VIVI_Kfm_Kfl00W]k
N`03QHF5S8b<S8b<00:>SXh00hf=SHV9RHV9R@02P82000=fMWI/K6a/K6`00VEUI@03HV9RI6ATI6AT
009YJFT00g9bLWinOWinOP02Rh^;00>DU9BGUiNGUiL00Y:BTP03QhN7N7QhN7Qh009YJFT00eaLG5=C
De=CD`03CDe=0UADE09OGel00f][Jg=cLg=cL`02MGEe00=aLG5]KFe]KFd00Va/K003LW9bNg]kNg]k
00:2PX800h>3Pg]kNg]kN`02K6a/00=MGEe@D51@D5000TU9B@03B4Q8Bd];Bd];009DE5@2Hf=S00=e
MGF4Q8B4Q8@00Xb<S003RHV9OWinOWin009`L7000fIVIVEUIFEUI@02JFUY00=aLG5gMgMgMgL01G]k
N`9jNWX00gQhN7EeMGEeM@02LW9b00=aLG5cLg=cLg<00WQhN0=mOGd2N7Qh00=_KfmYJFUYJFT00Ve]
K@03OWinUYJFUYJF00:XZ:P00jZZZY>CTi>CT`04oooo00<0003oooooool04?ooo`009Oooo`030000
oooooooo00;oool2NWYj00=bLW9ZJVYZJVX00V=SH`03GEeMFEUIFEUI00=FEUH2F5QH0UaLG003HF5Q
IfMWIfMW009^KVh00gEeMGalO7alO002PX:200>8R8R>SXj>SXh00Y>CT`03V9RHW9bLW9bL00:QXJ40
0jBTY:RXZ:RXZ002Zj^[00>^[Zj`/;2`/;000[6a/@03/[:b/k>c/k>c00:c/k<2/[:b00>a/K6`/;2`
/;000Zn_[`03[Jf][:b/[:b/00:[Zj/00jZZZZVYZJVYZ@02ZJVY1ZRXZ0:YZJT2Zj^[00>/[:b_[jn_
[jl00[6a/@03/[:b];Bd];Bd00:d];@00k:b/Zj^[Zj^[P02Z:RX00>QXJ6HV9RHV9P00Xj>SP03Q8B4
Ng]kNg]k009cLg<00fe]KFYZJVYZJP02JVYZ00=[Jf]]KFe]KFd00W5aL@03MGEeN7QhN7Qh009jNWX0
0g]kNgYjNWYjNP02NGUi00=gMgMfMWIfMWH00WIfMP03N7QhNg]kNg]k00:1PH400hV9RI:BTY:BTP02
W9bL00>VYZJ_[jn_[jl00[Jf]P03_;bl_kno_kno00>o_kl2_Kfm0[Zj^P03^;Rh]kNg]kNg00:g]kL2
^;Rh00>k^k^o_kno_kl00/C4a003bLW9cLg=cLg=00;Bd]800mKFe]SHf=SHf002f][J1M_Kf`03f][J
fMWIfMWI00;Hf=P00mKFe]CDe=CDe002d];B00?>c/k;bl_;bl/00/O7a`03`/;2_Kfm_Kfm00:h^;P0
0k>c/jf][Jf][@02YjNW00>PX:2JVYZJVYX00Y>CT`03Rh^;Ph>3Ph>300Coool00`000?ooooooo`0b
oooo00@0003oooooooooool2IfMW00=5ADDY:BTY:BT00QXJ6P0361PH820P820P008f=SH00eQHF7mo
OgmoO`02WYjN00>WYjN?Shn?Shl00V9RHP03<S8b51@D51@D008G5aL00c<c<eQHF5QHF002MgMg00>7
QhN9RHV9RHT00XB4Q003OWinNWYjNWYj009fMWH00g5aLFYZJVYZJP02Hf=S00=MGEeIFEUIFET00UYJ
FP9OGel00fMWIfi^KVi^KP02LG5a00=/K6aRHV9RHV800UUIF@03EeMGHF5QHF5Q009bLW800h>3Ph^;
Rh^;R`02QXJ600=hN7QZJVYZJVX00V=SH`03IfMWMGEeMGEe00:5QHD00i:BTYRHV9RHV002V9RH00>C
Ti>;Rh^;Rh/00WmoO`03LG5aIFEUIFEU009LG5`00eQHF5]KFe]KF`02HV9R00=/K6agMgMgMgL00X>3
P`03S8b<TY:BTY:B00:CTi<00hn?ShJ6QXJ6QP02NWYj00=[Jf]KFe]KFe/00Te=C@03AdM7BTY:BTY:
009DE5@00f5QHF][Jf][J`02KVi^00=[Jf]XJ6QXJ6P00VMWI`03KVi^MgMgMgMg00=oOgl2MWIf0VMW
I`03EeMGBd];Bd];0098B4P00da<C5ADE5ADE002GUiN0VUYJ@03M7AdOGemOGem00:3Ph<00hB4Q8:2
PX:2PP02OWin00=jNWYiNGUiNGT00WYjNP=lO7`2NGUi00=eMGEbLW9bLW800W1`L003LW9bMGEeMGEe
009iNGT00gemOH20P820P002PH6100>2PX9oOgmoOgl00WMgM`03Kfm_J6QXJ6QX009ZJVX00gMgMhZ:
RXZ:RP02VIVI00>JVYZ7QhN7QhL01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02
oooo0WYjNP03LW9bJVYZJVYZ009SHf<00eeMGEUIFEUIF@03EUIF0UQHF09LG5`00f5QHFMWIfMWI`02
KVi^00=eMGElO7alO7`00X:2PP03R8R8SXj>SXj>00:CTi<00iRHV9bLW9bLW002XJ6Q00>TY:BXZ:RX
Z:P00Z^[Z`03[Zj^/;2`/;2`00:a/K400k:b/[>c/k>c/`02/k>c0[:b/P03/K6a/;2`/;2`00:_[jl0
0jf][Jb/[:b/[002Zj^[00>ZZZZYZJVYZJT00ZVYZ@JXZ:P2ZJVY0Z^[Z`03[:b/[jn_[jn_00:a/K40
0k:b/[Bd];Bd]002];Bd00>b/[:^[Zj^[Zh00ZRXZ003XJ6QV9RHV9RH00:>SXh00hB4Q7]kNg]kN`02
Lg=c00=]KFeZJVYZJVX00VYZJP03Jf][KFe]KFe]009aLG400gEeMGQhN7QhN002NWYj00=kNg]jNWYj
NWX00WUiN@03MgMgMWIfMWIf009fMWH00gQhN7]kNg]kN`02PH6100>9RHVBTY:BTY800YbLW003YZJV
[jn_[jn_00:f][H00kbl_;no_kno_`03_kno0[fm_@:j^[X00kRh^;Ng]kNg]`02]kNg0[Rh^003^k^k
_kno_kno00;4a<@00lW9bLg=cLg=c@02d];B00?Fe]KHf=SHf=P00][JfPGKfm/00m[Jf]WIfMWIf@02
f=SH00?Fe]KDe=CDe=@00];BdP03c/k>bl_;bl_;00;7alL00l;2`[fm_Kfm_@02^;Rh00>c/k>][Jf]
[Jd00ZNWY`03X:2PVYZJVYZJ00:CTi<00h^;Rh>3Ph>3P`04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0VMWI`03ADE5:BTY:BTY008J6QX00aPH620P820P8002=SHf00=HF5QoOgmoOgl00YjN
WP03YjNWShn?Shn?009RHV800c8b<Q@D51@D50025aLG00<c<c=HF5QHF5P00WMgM`03QhN7RHV9RHV9
00:4Q8@00ginOWYjNWYjNP02MWIf00=aLG5ZJVYZJVX00V=SH`03GEeMFEUIFEUI009JFUX2GemO00=W
IfM^KVi^KVh00W5aL@03K6a/HV9RHV9R009IFET00eMGEf5QHF5QH@02LW9b00>3Ph>;Rh^;Rh/00XJ6
QP03N7QhJVYZJVYZ009SHf<00fMWIgEeMGEeM@02QHF500>BTY:HV9RHV9P00YRHV003Ti>CRh^;Rh^;
009oOgl00g5aLFEUIFEUI@02G5aL00=HF5QKFe]KFe/00V9RHP03K6a/MgMgMgMg00:3Ph<00hb<S9:B
TY:BTP02Ti>C00>?Shn6QXJ6QXH00WYjNP03Jf][Fe]KFe]K009=CDd00dM7AdY:BTY:BP02E5AD00=Q
HF5[Jf][Jf/00Vi^KP03Jf][J6QXJ6QX009WIfL00fi^KWMgMgMgM`03Ogmo0WIfMP9WIfL00eMGEd];
Bd];B`02B4Q800=<C4aDE5ADE5@00UiNGP9YJFT00gAdM7emOGemO@02Ph>300>4Q8B2PX:2PX800Win
OP03NWYjNGUiNGUi009jNWX3O7al0WUiN@03MGEeLW9bLW9b009`L7000g9bLWEeMGEeM@02NGUi00=m
OGf0P820P8000X61P@03PX:2OgmoOgmo009gMgL00fm_KfQXJ6QXJ002JVYZ00=gMgN:RXZ:RXX00YVI
V@03VYZJQhN7QhN700Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`:3Ph<0
0galO7IfMWIfMP02L71`00=/K6aYJFUYJFT00fQXJ09YJFT2K6a/00=`L71eMGEeMGD00W]kN`03PH61
QhN7QhN700:=SHd00i>CTiVIVIVIV@02WinO00>TY:BYZJVYZJT00Zf][@03/;2`/k>c/k>c00:e]KD0
0kJf][Ng]kNg]`02]kNg0kJf]P:d];@2/k>c00>a/K6`/;2`/;000Zn_[`03[Jf][:b/[:b/00>[Zj/9
ZZZZ0j^[Z`:/[:`00jf][Jj^[Zj^[P05[Zj^0Zb/[003ZJVYXj>SXj>S00:LW9`00i>CThV9RHV9R@02
Ogmo00=dM7A[Jf][Jf/00V=SH`03GEeMFUYJFUYJ009JFUX00eaLG5mOGemOG`02Hf=S00=WIfM[Jf][
Jf/00Ve]K@=^KVh2KFe]1F][J`03KFe]LG5aLG5a009iNGT00h:2PXf=SHf=S@02VIVI00>UYJF`/;2`
/;000[Vi^@03`<30a<C4a<C400;6a/H00lG5aL?3`l?3``02`L7100>o_knm_Kfm_Kd00[fm_@:n_[h0
0l71`LC4a<C4a002bLW900?=cLgBd];Bd]800]KFeP03f][JgMgMgMgM00;Ph>000n;Rh^?Shn?Sh`02
hn?S00?Ti>CShn?Shn<00^;RhP03h>3PgMgMgMgM00;Jf]X00mKFe]7AdM7Ad@02c<c<00?6a/K0`<30
`<000[^k^`03]KFe[jn_[jn_00:YZJT00j>SXifMWIfMW@02UiNG00>@T929RHV9RHT01?ooo`030000
oooooooo03;oool010000?ooooooooooo`9WIfL00eEEEDI6ATI6AP02?Cdm00<k>c/o?clo?cl00Tm?
C`03JVYZRHV9RHV900:SXj<00jZZZYJFUYJFUP02LG5a00=:BTXb<S8b<S800S@d=003Bd];J6QXJ6QX
00:1PH400hj>SY2@T92@T002S8b<00>7QhN3Ph>3Ph<00WmoO`03NGUiLg=cLg=c009/K6`00fIVIV9R
HV9RHP02HV9R0VMWI`03Kfm_MGEeMGEe009fMWH00fi^KV5QHF5QH@02EEEE00=@D51FEUIFEUH00VEU
I@03MGEeOWinOWin009lO7`00g=cLfUYJFUYJ@02IVIV00=/K6aiNGUiNGT00XJ6QP03TI6AU9BDU9BD
00:ATI400hZ:RX20P820P002MGEe00=ZJVYOGemOGel00UQHF003EEEEEUIFEUIF009LG5`00f=SHf][
Jf][J`02M7Ad00=kNg^2PX:2PX800XR8R0>;Rh/2Q8B400=eMGESHf=SHf<00U9BDP03BDU9Bd];Bd];
009GEeL00fEUIFm_Kfm_K`02L71`00=[Jf]TI6ATI6@00V9RHP03IfMWL71`L71`009hN7P00gUiNG9b
LW9bLP02I6AT00=GEeM?Cdm?Cdl00U1@D003EeMGHF5QHF5Q009[Jf/2LW9b00=gMgMkNg]kNg/00Wem
O@03OgmoP820P82000:0P8000gmoOginOWinOP02OGem00=kNg]hN7QhN7P00W=cL`03KVi^JVYZJVYZ
009YJFT00fe]KG=cLg=cL`02NWYj00=oOgn0P820P8000WmoO`03O7alMgMgMgMg009aLG400fa/K6MW
IfMWI`02J6QX00=_KfmjNWYjNWX00h:2PP9hN7P4oooo00<0003oooooool04?ooo`009Oooo`030000
oooooooo00;oool2SHf=00>9RHV4Q8B4Q8@00X61P@03OWinOGemOGem00=lO7`2OWin0X20P003Ph>3
QXJ6QXJ600:;Rh/00hn?SiFEUIFEU@02VYZJ00>PX:2UYJFUYJD00Z^[Z`03/;2`];Bd];Bd00:h^;P0
0k^k^kfm_Kfm_@05_kno0[jn_P03_Kfm^k^k^k^k00:i^KT2]kNg00>e]KFd];Bd];@00[:b/P03/K6a
[jn_[jn_00>^[Zh<[Jf]0jb/[0:[Zj/2ZJVY00>WYjNTY:BTY:@00Z2PX003Vi^KU9BDU9BD00:<S8`0
0h:2PWQhN7QhN002KVi^00=TI6AKFe]KFe/00U=CD`03CTi>Bd];Bd];009;Bd/00de=CE5ADE5AD@02
EEEE00=JFUYNGUiNGUh00V1PH0=QHF42H61P1EmOG`03HV9RJ6QXJ6QX009aLG400galO8V9RHV9R@02
UiNG00>UYJFb/[:b/[800[fm_@03aLG5b/[:b/[:00;=cLd00lc<c<_;bl_;b`02b<S800?6a/K4a<C4
a<@01<?3``03aLG5bLW9bLW900;=cLd00m7AdMGEeMGEe@02fMWI00?MgMgPh>3Ph>000^?Sh`03iNGU
inOWinOW00;Xj>P00nWYjNSXj>SXj002inOW00?UiNGRh^;Rh^800]oOg`03f][JeMGEeMGE00;@d=00
0l[:b/C4a<C4a002_[jn00>h^;Rb/[:b/[800Zf][@03YjNWXZ:RXZ:R00:MWId00iNGUi:BTY:BTP04
oooo00<0003oooooool0<_ooo`040000oooooooooooo0Va/K003Kfm_L71`L71`009^KVh3K6a/0W=c
L`03PX:2UYJFUYJF00:VYZH00jZZZYfMWIfMW@02QHF500=/K6aMGEeMGEd00UeMG@03JFUYNWYjNWYj
00:8R8P00hn?Shj>SXj>SP02Rh^;00>7QhN5QHF5QHD00X:2PP03P820O7alO7al009gMgL00g=cLg1`
L71`L002Kfm_0W=cL`03MgMgNg]kNg]k009jNWX00g9bLVEUIFEUI@02FEUI00=ADE5BDU9BDU800UUI
F@03HF5QJ6QXJ6QX009[Jf/3JVYZ0Va/K003LW9bNWYjNWYj00:1PH400hF5QH>3Ph>3P`02OGem00=f
MWI^KVi^KVh00VMWI`03HF5QGEeMGEeM009IFET00eMGEeIFEUIFEP02F5QH00=JFUYMGEeMGEd00V5Q
H@03IVIVKFe]KFe]009fMWH00h20P8N7QhN7Q`02QXJ600=kNg]ZJVYZJVX00UYJFP03DE5AEEEEEEEE
009RHV800g5aLGYjNWYjNP02NGUi00=_KfmTI6ATI6@00UiNGP03H61PIfMWIfMW009^KVh00g9bLVi^
KVi^KP02IFEU00=MGEeIFEUIFET00UeMG@03IVIVL71`L71`009hN7P2O7al00=mOGekNg]kNg/01GYj
NP9iNGT00gQhN7IfMWIfMP02M7Ad00=bLW9_Kfm_Kfl00V][J`03IfMWI6ATI6AT009UIFD00fUYJFm_
Kfm_K`02MGEe0gQhN09dM7@00fm_KfYZJVYZJP02J6QX00=WIfMXJ6QXJ6P026QXJ09ZJVX4oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2SHf=00>9RHV4Q8B4Q8@00X61P@03OWin
OGemOGem00=lO7`2OWin0X20P003Ph>3QXJ6QXJ600:;Rh/00hn?SiFEUIFEU@02VYZJ00>PX:2UYJFU
YJD00Z^[Z`03/;2`];Bd];Bd00:h^;P00k^k^kfm_Kfm_@05_kno0[jn_P03_Kfm^k^k^k^k00:i^KT2
]kNg00>e]KFd];Bd];@00[:b/P03/K6a[jn_[jn_00>^[Zh<[Jf]0jb/[0:[Zj/2ZJVY00>WYjNTY:BT
Y:@00Z2PX003Vi^KU9BDU9BD00:<S8`00h:2PWQhN7QhN002KVi^00=TI6AKFe]KFe/00U=CD`03CTi>
Bd];Bd];009;Bd/00de=CE5ADE5AD@02EEEE00=JFUYNGUiNGUh00V1PH0=QHF42H61P1EmOG`03HV9R
J6QXJ6QX009aLG400galO8V9RHV9R@02UiNG00>UYJFb/[:b/[800[fm_@03aLG5b/[:b/[:00;=cLd0
0lc<c<_;bl_;b`02b<S800?6a/K4a<C4a<@01<?3``03aLG5bLW9bLW900;=cLd00m7AdMGEeMGEe@02
fMWI00?MgMgPh>3Ph>000^?Sh`03iNGUinOWinOW00;Xj>P00nWYjNSXj>SXj002inOW00?UiNGRh^;R
h^800]oOg`03f][JeMGEeMGE00;@d=000l[:b/C4a<C4a002_[jn00>h^;Rb/[:b/[800Zf][@03YjNW
XZ:RXZ:R00:MWId00iNGUi:BTY:BTP04oooo00<0003oooooool0<_ooo`040000oooooooooooo0Va/
K003Kfm_L71`L71`009^KVh3K6a/0W=cL`03PX:2UYJFUYJF00:VYZH00jZZZYfMWIfMW@02QHF500=/
K6aMGEeMGEd00UeMG@03JFUYNWYjNWYj00:8R8P00hn?Shj>SXj>SP02Rh^;00>7QhN5QHF5QHD00X:2
PP03P820O7alO7al009gMgL00g=cLg1`L71`L002Kfm_0W=cL`03MgMgNg]kNg]k009jNWX00g9bLVEU
IFEUI@02FEUI00=ADE5BDU9BDU800UUIF@03HF5QJ6QXJ6QX009[Jf/3JVYZ0Va/K003LW9bNWYjNWYj
00:1PH400hF5QH>3Ph>3P`02OGem00=fMWI^KVi^KVh00VMWI`03HF5QGEeMGEeM009IFET00eMGEeIF
EUIFEP02F5QH00=JFUYMGEeMGEd00V5QH@03IVIVKFe]KFe]009fMWH00h20P8N7QhN7Q`02QXJ600=k
Ng]ZJVYZJVX00UYJFP03DE5AEEEEEEEE009RHV800g5aLGYjNWYjNP02NGUi00=_KfmTI6ATI6@00UiN
GP03H61PIfMWIfMW009^KVh00g9bLVi^KVi^KP02IFEU00=MGEeIFEUIFET00UeMG@03IVIVL71`L71`
009hN7P2O7al00=mOGekNg]kNg/01GYjNP9iNGT00gQhN7IfMWIfMP02M7Ad00=bLW9_Kfm_Kfl00V][
J`03IfMWI6ATI6AT009UIFD00fUYJFm_Kfm_K`02MGEe0gQhN09dM7@00fm_KfYZJVYZJP02J6QX00=W
IfMXJ6QXJ6P026QXJ09ZJVX4oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
VIVI00>GUiNEUIFEUID00YBDU003Ti>CTY:BTY:B00:BTY800i>CTiBDU9BDU002UYJF00>HV9RJVYZJ
VYX00YfMW@03X:2PY:BTY:BT00:XZ:P00jf][K:b/[:b/P02]kNg00>k^k^o_kno_kl00/?3``03aLG5
alO7alO700?8b<P2alO70/K6aP03a<C4`/;2`/;200;0`<02_[jn00>l_;bj^[Zj^[X00[Rh^003]kNg
]KFe]KFe00:d];@00k>c/k:b/[:b/P03/[:b0[6a/@:`/;000jn_[jj^[Zj^[P02[:b/00>YZJVVYZJV
YZH00Z6QX@03WIfMUiNGUiNG00:ATI400hZ:RX:2PX:2PP02NGUi00=_KfmVIVIVIVH00UaLG003De=C
Bd];Bd];0094A4@00d10@3hn?Shn?P02?Shn00=0@413@d=3@d<00TQ8B003C4a<D51@D51@009CDe<3
E5AD1E=CD`9EEED00eUIFF1PH61PH002JVYZ00=gMgN7QhN7QhL00YNGU`03YjNW]KFe]KFe00;2`/80
0lc<c=;Bd];BdP03e=CD0];BdP;?cll00lc<c<[:b/[:bP04b<S800?:b/[<c<c<c<`00]3@d003e=CD
f=SHf=SH00;Lg=`00moOgn;Rh^;RhP02iNGU00?WinOXj>SXj>P00^WYj@?Zj^X2jNWY00?WinOTi>CT
i>@00^3Ph003g=cLf=SHf=SH00;Bd]800lg=cLO7alO7a`02`/;200>l_;bg]kNg]kL00[:b/P03[Jf]
Z:RXZ:RX00:TY:@00j2PX9fMWIfMW@04oooo00<0003oooooool0<_ooo`040000oooooooooooo0W9b
LP03R8R8V9RHV9RH00:NWYh00ibLW9NGUiNGU`02UIFE00>HV9ROWinOWil00ZFUY@03YjNWXZ:RXZ:R
00:HV9P00hj>SXJ6QXJ6QP02Q8B400>7QhN:RXZ:RXX00hb<S0:9RHT2QXJ600>4Q8B3Ph>3Ph<01H>3
P`:1PH400gmoOgemOGemO@04OGem0gmoO`9lO7`00gEeMF][Jf][J`02HF5Q00=HF5QBDU9BDU800dm?
C`9CDe<2FEUI00=QHF5ZJVYZJVX00W9bLP03MgMgNGUiNGUi009iNGT00gEeMFm_Kfm_K`02IfMW00=P
H61KFe]KFe/00UUIF@03FUYJG5aLG5aL009MGEd00eaLG5UIFEUIF@02EUIF00=DE5ABDU9BDU800U5A
D@03De=CFEUIFEUI009UIFD00g=cLh20P820P002QHF500=nOWiaLG5aLG400V9RHP03Fe]KHF5QHF5Q
009^KVh00galO8B4Q8B4Q002PH6100=eMGEWIfMWIfL00UiNGP03G5aLH61PH61P009VIVH3JVYZ0VIV
IP03I6ATIFEUIFEU009[Jf/00gAdM7emOGemO@02Ph>30XB4Q003PX:2OGemOGem009hN7P00gEeMG9b
LW9bLP02L71`00=]KFeZJVYZJVX00VQXJ003IVIVI6ATI6AT009SHf<3HF5Q0V9RHP03IVIVJVYZJVYZ
009^KVh00g1`L6e]KFe]K@02IfMW00=QHF5NGUiNGUh00UmOG`03I6ATJ6QXJ6QX009XJ6P00f5QHEQH
F5QHF002D51@00=ADE5MGEeMGEd01?ooo`030000oooooooo013oool002Goool200000oooo`:IVIT0
0iNGUiFEUIFEU@02U9BD00>CTi>BTY:BTY800Y:BTP03Ti>CU9BDU9BD00:FUYH00iRHV9ZJVYZJVP02
WIfM00>PX:2TY:BTY:@00ZRXZ003[Jf]/[:b/[:b00:g]kL00k^k^kno_kno_`02`l?300?5aLG7alO7
alL00lS8b0;7alL2a/K600?4a<C2`/;2`/800/30`0:n_[h00kbl_;Zj^[Zj^P02^;Rh00>g]kNe]KFe
]KD00[Bd]003/k>c/[:b/[:b00>b/[82/K6a0[2`/003[jn_[Zj^[Zj^00:/[:`00jVYZJJVYZJVYP02
XJ6Q00>MWIfGUiNGUiL00Y6AT@03RXZ:PX:2PX:2009iNGT00fm_KfIVIVIVIP02G5aL00=CDe=;Bd];
Bd/00TA4A003@410?Shn?Shn008n?Sh00d10@4=3@d=3@`02B4Q800=<C4a@D51@D5000U=CD`=DE5@5
De=C0UEEE@03FEUIH61PH61P009ZJVX00gMgMhN7QhN7Q`02UiNG00>WYjNe]KFe]KD00/;2`P03c<c<
d];Bd];B00?De=@2d];B0/o?c`03c<c<b/[:b/[:00C8b<P00l[:b/c<c<c<c002d=3@00?De=CHf=SH
f=P00]cLg003gmoOh^;Rh^;R00;UiND00nOWinSXj>SXj002jNWY0n[ZjP;YjNT00nOWinCTi>CTi002
h>3P00?Lg=cHf=SHf=P00];BdP03cLg=alO7alO700;2`/800kbl_;Ng]kNg]`02/[:b00>][JfXZ:RX
Z:P00ZBTY003X:2PWIfMWIfM00?oool20000=?ooo`040000oooooooooooo0W9bLP03R8R8V9RHV9RH
00:NWYh00ibLW9NGUiNGU`02UIFE00>HV9ROWinOWil00ZFUY@03YjNWXZ:RXZ:R00:HV9P00hj>SXJ6
QXJ6QP02Q8B400>7QhN:RXZ:RXX00hb<S0:9RHT2QXJ600>4Q8B3Ph>3Ph<01H>3P`:1PH400gmoOgem
OGemO@04OGem0gmoO`9lO7`00gEeMF][Jf][J`02HF5Q00=HF5QBDU9BDU800dm?C`9CDe<2FEUI00=Q
HF5ZJVYZJVX00W9bLP03MgMgNGUiNGUi009iNGT00gEeMFm_Kfm_K`02IfMW00=PH61KFe]KFe/00UUI
F@03FUYJG5aLG5aL009MGEd00eaLG5UIFEUIF@02EUIF00=DE5ABDU9BDU800U5AD@03De=CFEUIFEUI
009UIFD00g=cLh20P820P002QHF500=nOWiaLG5aLG400V9RHP03Fe]KHF5QHF5Q009^KVh00galO8B4
Q8B4Q002PH6100=eMGEWIfMWIfL00UiNGP03G5aLH61PH61P009VIVH3JVYZ0VIVIP03I6ATIFEUIFEU
009[Jf/00gAdM7emOGemO@02Ph>30XB4Q003PX:2OGemOGem009hN7P00gEeMG9bLW9bLP02L71`00=]
KFeZJVYZJVX00VQXJ003IVIVI6ATI6AT009SHf<3HF5Q0V9RHP03IVIVJVYZJVYZ009^KVh00g1`L6e]
KFe]K@02IfMW00=QHF5NGUiNGUh00UmOG`03I6ATJ6QXJ6QX009XJ6P00f5QHEQHF5QHF002D51@00=A
DE5MGEeMGEd00oooo`80000Boooo000Uoooo00<0003oooooool00_ooo`:WYjL3YZJV0ZNWY`03Z:RX
ZJVYZJVY00:ZZZX00j^[Zjb/[:b/[003[Jf]0Zn_[`:`/;000k:b/[Bd];Bd]002^;Rh00>k^k^o_kno
_kl00/?3``03a/K6b/[:b/[:00;=cLd00lo?cm3@d=3@d003d=3@0/o?c`;>c/h00lc<c<[:b/[:bP02
b<S80/K6aP03a<C4`/;2`/;200;0`<000kjn_[fm_Kfm_@02^k^k00>j^[Zi^KVi^KT00[Rh^003]kNg
][Jf][Jf00:d];@00k:b/Zn_[jn_[`02Zj^[00>VYZJOWinOWil00YRHV003TI6AR8R8R8R800:0P800
0gMgMfe]KFe]K@02I6AT00=KFe]BDU9BDU800TY:BP03@T92>c/k>c/k008f=SH00c<c<c4a<C4a<@02
<S8b00<d=3@g=cLg=cL00S/k>`03?clo@d=3@d=30095ADD6AdM70TQ8B09;Bd/00e1@D5UIFEUIF@02
IFEU00=dM7B5QHF5QHD00YNGU`03ZJVY^[Zj^[Zj00;8b<P00m;Bd]WIfMWIf@03g=cL0]WIf@;Fe]H0
0m;Bd/o?clo?c`02cLg=0/c<c003cLg=d=3@d=3@00;Cdm<00mKFe][Jf][JfP02gMgM00?QhN7Shn?S
hn<00^GUi@03i^KVinOWinOW00GXj>P2inOW00?UiNGShn?Shn<00^3Ph003gMgMfMWIfMWI00;De=@0
0m3@d<_;bl_;b`02a/K600?1`L6l_;bl_;`00[Rh^003/k>c[jn_[jn_00:/[:`00jZZZZRXZ:RXZ004
oooo00<0003oooooool0<_ooo`040000oooooooooooo0WIfMP03UiNG/;2`/;2`00:j^[X00kNg]jn_
[jn_[`02YZJV00>QXJ6OWinOWil00ijNWP:OWil2X:2P00>QXJ6PX:2PX:000YfMW@03UiNGTI6ATI6A
00::RXX00hF5QH61PH61P@02Ogmo0ginOP:0P8000h:2PXB4Q8B4Q005QHF50XB4Q0:3Ph<00h:2PWmo
OgmoO`02Ng]k00=gMgMaLG5aLG400V][J`03HV9RF5QHF5QH009=CDd00dI6ATE5ADE5A@02CTi>00=M
GEe]KFe]KFd00WQhN003Ng]kN7QhN7Qh009`L7000fMWIemOGemOG`02EeMG00=BDU9@D51@D5000U9B
DP03F5QHGUiNGUiN009SHf<00f9RHUiNGUiNGP02FEUI00=CDe==CDe=CDd00TY:BP03BDU9CTi>CTi>
009JFUX00fUYJGQhN7QhN002PH6100=oOgmeMGEeMGD00V][J`03IVIVJVYZJVYZ009dM7@00gmoOhB4
Q8B4Q002PH6100=hN7Q]KFe]KFd00VATI0=PH602Hf=S00=UIFEVIVIVIVH00VIVIP03J6QXKFe]KFe]
009dM7@00gemOHF5QHF5Q@02RHV90XR8R003Q8B4OGemOGem009fMWH00g5aLFa/K6a/K002J6QX00=U
IFERHV9RHV800UmOG`ENGUh00emOGf1PH61PH002HV9R00=UIFEXJ6QXJ6P00VYZJP03JFUYIFEUIFEU
009OGel00eUIFEMGEeMGE`02FUYJ00=RHV9YJFUYJFT00VUYJ@03GUiNCdm?Cdm?0093@d<00dA4A5MG
EeMGE`04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2];Bd00>f][Jh^;Rh
^;P00[^k^`03_Kfm`<30`<3000;1`L4:`l?300?4a<C5aLG5aLD00/K6aP03bLW9bl_;bl_;00;>c/h0
0m7AdM?Cdm?Cd`02eMGE00?GemOHf=SHf=P00]SHf003emOGe]KFe]KF00;EeMD00mCDe=?Cdm?Cd`02
dM7A0/o?c`03cLg=bl_;bl_;00;9bLT00lO7alG5aLG5a@02`l?300?1`L6o_kno_kl00[jn_P03_;bl
^[Zj^[Zj00:h^;P00kBd];2`/;2`/002ZZZZ00>RXZ:IVIVIVIT00Xn?S`03Q8B4NGUiNGUi009^KVh0
0f=SHeUIFEUIF@02Cdm?00=7AdLo?clo?cl00SPh>003<S8b;Bd];Bd]008Z:RX00bPX:2LW9bLW9`02
9bLW00<Y:BT[:b/[:b/00Rl_;`03<S8b=SHf=SHf008h>3P00cXj>S/k>c/k>`02?3`l00<m?Cdo?clo
?cl00T=3@`03BTY:E5ADE5AD009RHV800g=cLhF5QHF5Q@02VIVI00>/[:bn_[jn_[h00/k>cP03fMWI
h>3Ph>3P00?Shn<2h>3P0]cLg003f=SHe=CDe=CD00;AdM43d=3@0];BdP;EeMD00mSHf=cLg=cLg002
gmoO00?QhN7Shn?Shn<00^CTi0SUiND2i>CT00?Rh^;Ph>3Ph>000]kNgP03g=cLfMWIfMWI00;Fe]H0
0m;Bd/k>c/k>cP02b/[:00?6a/K1`L71`L400[jn_P03^[Zj]kNg]kNg00:e]KD3];Bd1?ooo`030000
oooooooo03;oool010000?ooooooooooo`9gMgL00iNGUjj^[Zj^[P02][Jf00>b/[:XZ:RXZ:P00YjN
WP03UYJFTI6ATI6A00>>SXh2TI6A0YNGU`03W9bLWinOWinO00:LW9`00iFEUH^;Rh^;R`02Ph>300=m
OGeiNGUiNGT00gMgM`9hN7P2NGUi00=lO7anOWinOWh00X20P003PH61PX:2PX:200:1PH42P82000=n
OWikNg]kNg/00WUiN@03MgMgMWIfMWIf009cLg<00fe]KF5QHF5QH@02E5AD00=:BTY7AdM7AdL00U1@
D003H61PLG5aLG5a009lO7`00gemOGIfMWIfMP02Jf][00=OGemGEeMGEeL00U9BDP03D51@DE5ADE5A
009FEUH00eiNGVEUIFEUI@03JVYZ0VIVIP9PH6000eUIFE=CDe=CD`02Cdm?00=>CTiADE5ADE400UYJ
FP03IVIVLg=cLg=c009kNg/00galO7MgMgMgM`02LG5a0fa/K09^KVh00g9bLWEeMGEeM@03MWIf0WAd
M09bLW800fi^KVUYJFUYJ@02IFEU0f9RHP9TI6@00fQXJ6i^KVi^KP02MGEe00=lO7b3Ph>3Ph<00XJ6
QP:5QHD00h61PG]kNg]kN`02M7Ad00=_KfmZJVYZJVX00VIVIP03Hf=SH61PH61P00ENGUh2H61P00=Q
HF5SHf=SHf<00VEUI@03IfMWJFUYJFUY009ZJVX00fUYJFEUIFEUI@02GemO00=JFUYIFEUIFET00UeM
G@03I6ATJf][Jf][009[Jf/00f5QHE9BDU9BDP03AdM70UYJFPCoool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`:d];@00kJf][Rh^;Rh^002^k^k00>m_Kg0`<30`<000/71`@[3`l<0
0lC4a<G5aLG5a@02a/K600?9bLW;bl_;bl/00/k>cP03dM7Adm?Cdm?C00;EeMD00mOGemSHf=SHf002
f=SH00?GemOFe]KFe]H00]GEe@03e=CDdm?Cdm?C00;AdM42clo?00?=cLg;bl_;bl/00/W9b@03alO7
aLG5aLG500;3`l<00l71`Kno_kno_`02_[jn00>l_;bj^[Zj^[X00[Rh^003];Bd/;2`/;2`00:ZZZX0
0j:RXYVIVIVIV@02Shn?00>4Q8AiNGUiNGT00Vi^KP03Hf=SFEUIFEUI009?Cdl00dM7Aclo?clo?`02
>3Ph00<b<S8];Bd];Bd00RXZ:P03:2PX9bLW9bLW008W9bL00bTY:B/[:b/[:`02;bl_00<b<S8f=SHf
=SH00SPh>003>SXj>c/k>c/k008l?3`00cdm?Clo?clo?`02@d=300=:BTYDE5ADE5@00V9RHP03Lg=c
QHF5QHF500:IVIT00jb/[;jn_[jn_P02c/k>00?IfMWPh>3Ph>000n?Sh`;Ph>02g=cL00?Hf=SDe=CD
e=@00]7Ad@?@d=02d];B0]GEe@03f=SHg=cLg=cL00;Ogml00n7QhN?Shn?Sh`02i>CT2>GUi@;Ti>@0
0n;Rh^3Ph>3Ph002g]kN00?Lg=cIfMWIfMT00]KFeP03d];Bc/k>c/k>00;:b/X00lK6a/71`L71`@02
_[jn00>j^[Zg]kNg]kL00[Fe]@>d];@4oooo00<0003oooooool0<_ooo`040000oooooooooooo0WMg
M`03UiNG[Zj^[Zj^00:f][H00k:b/ZRXZ:RXZ002WYjN00>FUYJATI6ATI400hj>SP:ATI42UiNG00>L
W9bOWinOWil00YbLW003UIFERh^;Rh^;00:3Ph<00gemOGUiNGUiN@03MgMg0WQhN09iNGT00galO7in
OWinOP02P82000>1PH62PX:2PX800X61P@:0P8000ginOW]kNg]kN`02NGUi00=gMgMfMWIfMWH00W=c
L`03KFe]HF5QHF5Q009DE5@00dY:BTM7AdM7A`02D51@00=PH61aLG5aLG400WalO003OGemMWIfMWIf
009[Jf/00emOGeMGEeMGE`02DU9B00=@D51ADE5ADE400UIFEP03GUiNIFEUIFEU00=ZJVX2IVIV0V1P
H003FEUIDe=CDe=C009?Cdl00di>CU5ADE5AD@02FUYJ00=VIVIcLg=cLg<00W]kN`03O7alMgMgMgMg
009aLG43K6a/0Vi^KP03LW9bMGEeMGEe00=fMWH2M7Ad0W9bLP03KVi^JFUYJFUY009UIFD3HV9R0VAT
I003J6QXKVi^KVi^009eMGD00galO8>3Ph>3P`02QXJ60XF5Q@03PH61Ng]kNg]k009dM7@00fm_KfYZ
JVYZJP02IVIV00=SHf=PH61PH6001EiNGP9PH6000f5QHF=SHf=SH`02IFEU00=WIfMYJFUYJFT00VYZ
JP03JFUYIFEUIFEU009OGel00eYJFUUIFEUIF@02GEeM00=TI6A[Jf][Jf/00V][J`03HF5QDU9BDU9B
00=7AdL2FUYJ1?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0/;2`P03aLG5
bLW9bLW900;=cLd00m7AdMCDe=CDe002emOG00?Hf=SIfMWIfMT00]SHf003emOGe]KFe]KF00;EeMD5
e=CD00?EeMGFe]KFe]H00]SHf003f][Jfm_Kfm_K00;MgMd6g]kN1=gMg@03g=cLfm_Kfm_K00;IfMT2
f=SH00?Fe]KDe=CDe=@00];BdP03clo?cLg=cLg=00;;bl/00lS8b<K6a/K6aP02aLG500?2`/;0`<30
`<000[bl_003^;Rh/K6a/K6a00:YZJT00inOWi>CTi>CT`02QXJ600=hN7QZJVYZJVX00UeMG@03D51@
ADE5ADE5008k>c/00c<c<bd];Bd];@02:2PX00<T92@Q8B4Q8B400QlO7`<N7Qh27alO00<P820Q8B4Q
8B400R@T90039bLW:RXZ:RXZ008/;2`00bh^;S0`<30`<002<S8b00<e=CDi>CTi>CT00Slo?`03AdM7
De=CDe=C009RHV800gAdM8R8R8R8R002W9bL00>a/K73`l?3`l<00]?Cd`03gmoOinOWinOW00;Zj^X0
0nWYjNKVi^KViP02h^;R00?MgMgHf=SHf=P00]GEe@?Cdm<2eMGE0]OGe`03f][JgMgMgMgM00;Ogml0
0n7QhN;Rh^;RhP05hn?S0^;RhP03hN7Qh>3Ph>3P00;Ogml00mkNg]gMgMgMg@02g=cL00?Jf][Hf=SH
f=P00]KFeP03dm?CdM7AdM7A00;=cLd00l[:b/K6a/K6aP02`l?300?1`L6o_kno_kl00[fm_@03_[jn
_kno_kno00Coool00`000?ooooooo`0boooo00@0003oooooooooool2MWIf00>:RXZHV9RHV9P00Y^K
V`03UIFES8b<S8b<00:3Ph<00gemOGYjNWYjNP02N7Qh00=jNWYmOGemOGd00X:2PP03QhN7RHV9RHV9
00:8R8P00h>3PgemOGemO@02MgMg00=cLg=aLG5aLG401G1`L09aLG400g9bLWAdM7AdM002MGEe00=g
MgMhN7QhN7P00WQhN09gMgL00gIfMWEeMGEeM@02M7Ad00=fMWIhN7QhN7P00WUiN@03MWIfKFe]KFe]
009RHV800eQHF5EEEEEEE@02G5aL00=YJFUgMgMgMgL00WmoO`03OGemLg=cLg=c009WIfL00eeMGEQH
F5QHF002EeMG00=IFEUMGEeMGEd00V9RHP03J6QXKVi^KVi^00=aLG42KVi^0VUYJ@03I6ATH61PH61P
009MGEd00eaLG5iNGUiNGP02Hf=S00=YJFU`L71`L7000WEeM@=gMgL2M7Ad00=`L71YJFUYJFT00V9R
HP03G5aLGEeMGEeM009UIFD00g5aLGemOGemO@02Q8B400>1PH5gMgMgMgL00Va/K003Hf=SGemOGemO
009PH6000fATI6UYJFUYJ@02Kfm_00=eMGEjNWYjNWX00WemO@9nOWh00g]kNgMgMgMgM`02LW9b00=^
KVi[Jf][Jf/00VQXJ003IVIVI6ATI6AT00=SHf<2I6AT0VEUI@03IVIVJ6QXJ6QX009ZJVX00f][Jfe]
KFe]K@03KFe]0VYZJP9VIVH00f=SHf5QHF5QH@02I6AT00=YJFU^KVi^KVh00Vi^KP03IfMWGUiNGUiN
009FEUH00eMGEf=SHf=SH`04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
`/;200?5aLG9bLW9bLT00/g=c@03dM7Ae=CDe=CD00;GemL00mSHf=WIfMWIf@02f=SH00?GemOFe]KF
e]H00]GEe@GDe=@00mGEeMKFe]KFeP02f=SH00?Jf][Kfm_Kfm/00]gMg@KNg]h4gMgM00?Lg=cKfm_K
fm/00]WIf@;Hf=P00mKFe]CDe=CDe002d];B00??clo=cLg=cLd00/_;b`03b<S8a/K6a/K600;5aLD0
0l;2`/30`<30`002_;bl00>h^;Ra/K6a/K400ZVYZ@03WinOTi>CTi>C00:6QXH00gQhN6YZJVYZJP02
GEeM00=@D515ADE5ADD00S/k>`03<c<c;Bd];Bd]008X:2P00b@T924Q8B4Q8@027alO0ahN7P8O7al0
0b0P824Q8B4Q8@0292@T00<W9bLZ:RXZ:RX00R`/;003;Rh^<30`<30`008b<S800cDe=CTi>CTi>@02
?clo00=7AdMCDe=CDe<00V9RHP03M7AdR8R8R8R800:LW9`00k6a/L?3`l?3``02dm?C00?OgmoWinOW
inL00^[ZjP03jNWYi^KVi^KV00;Rh^800mgMgMSHf=SHf002eMGE0m?Cd`;EeMD2emOG00?Jf][MgMgM
gMd00]oOg`03hN7Qh^;Rh^;R00GShn<2h^;R00?QhN7Ph>3Ph>000]oOg`03g]kNgMgMgMgM00;Lg=`0
0m[Jf]SHf=SHf002e]KF00?Cdm?AdM7AdM400/g=c@03b/[:a/K6a/K600;3`l<00l71`Kno_kno_`02
_Kfm00>n_[jo_kno_kl01?ooo`030000oooooooo03;oool010000?ooooooooooo`9fMWH00hZ:RYRH
V9RHV002Vi^K00>EUIF<S8b<S8`00X>3P`03OGemNWYjNWYj009hN7P00gYjNWemOGemO@02PX:200>7
QhN9RHV9RHT00XR8R003Ph>3OGemOGem009gMgL00g=cLg5aLG5aL@05L71`0W5aL@03LW9bM7AdM7Ad
009eMGD00gMgMgQhN7QhN002N7Qh0WMgM`03MWIfMGEeMGEe009dM7@00gIfMWQhN7QhN002NGUi00=f
MWI]KFe]KFd00V9RHP03F5QHEEEEEEEE009LG5`00fUYJGMgMgMgM`02Ogmo00=mOGecLg=cLg<00VMW
I`03GEeMF5QHF5QH009GEeL00eUIFEeMGEeMG@02HV9R00=XJ6Q^KVi^KVh00g5aL@9^KVh2JFUY00=T
I6APH61PH6000UeMG@03G5aLGUiNGUiN009SHf<00fUYJG1`L71`L002MGEe0gMgM`9dM7@00g1`L6UY
JFUYJ@02HV9R00=LG5aMGEeMGEd00VEUI@03LG5aOGemOGem00:4Q8@00h61PGMgMgMgM`02K6a/00=S
Hf=OGemOGel00V1PH003I6ATJFUYJFUY009_Kfl00gEeMGYjNWYjNP02OGem0WinOP03Ng]kMgMgMgMg
009bLW800fi^KV][Jf][J`02J6QX00=VIVITI6ATI6@00f=SH`9TI6@2IFEU00=VIVIXJ6QXJ6P00VYZ
JP03Jf][KFe]KFe]00=]KFd2JVYZ0VIVIP03Hf=SHF5QHF5Q009TI6@00fUYJFi^KVi^KP02KVi^00=W
IfMNGUiNGUh00UIFEP03EeMGHf=SHf=S00Coool00`000?ooooooo`0@oooo000Uoooo00<0003ooooo
ool00_ooo`;=cLd00m;Bd]OGemOGe`02gMgM00?Rh^;Vi^KVi^H00^WYj@GZj^X00nSXj>KVi^KViP02
i>CT00?Rh^;Ph>3Ph>000moOg`CPh>000n7QhN;Rh^;RhP0<hn?S0n;RhP;QhN42gmoO00?Ng]kLg=cL
g=`00][JfP03emOGe=CDe=CD00;Bd]800lo?clg=cLg=c@02bl_;00?8b<S5aLG5aLD00/71`@03_;bl
];Bd];Bd00:ZZZX00ijNWXn?Shn?S`02Ogmo00=^KViMGEeMGEd00Te=C@03?Shn<S8b<S8b008Y:BT0
0b8R8QdM7AdM7@026QXJ00<I6ATH61PH61P01aPH60<I6AT26a/K00<M7AdO7alO7al00R8R8P0392@T
9bLW9bLW008[:b/00c0`<3Hf=SHf=P02?Shn00=9BDUFEUIFEUH00VIVIP03NGUiSHf=SHf=00:RXZ80
0kJf]/S8b<S8b002f=SH00?Ti>C[jn_[jn/00nk^kP;[jn/2i^KV00?QhN7Lg=cLg=`00]SHf0?Fe]H2
emOG0]WIf@03fm_KgMgMgMgM00;Ogml6hN7Q0^3Ph0;Ng]h00mgMgMcLg=cLg002fm_K0m[JfP;IfMT0
0mSHf=OGemOGe`02e]KF00?EeMGCdm?Cdm<00]3@d003c/k>bl_;bl_;00;9bLT00lO7alK6a/K6aP02
a/K600?7alO9bLW9bLT01?ooo`030000oooooooo03;oool010000?ooooooooooo`9dM7@00gUiNG]k
Ng]kN`02N7Qh00=aLG5YJFUYJFT00V=SH`03H61PHF5QHF5Q009SHf<00fEUIFQXJ6QXJ002JVYZ00=/
K6a]KFe]KFd00Vi^KP=]KFd2Jf][0fYZJP9YJFT8J6QX0VUYJ@03JVYZJf][Jf][00A/K6`3KFe]0Vm_
K`03M7AdNGUiNGUi009mOGd00ginOWUiNGUiN@02L71`00=YJFUVIVIVIVH00VYZJP03Lg=cO7alO7al
00:0P8000galO75aLG5aL@02IVIV00=MGEeLG5aLG5`00UmOG`03IFEUJf][Jf][009`L7000gAdM7Qh
N7QhN002NGUi00=hN7QfMWIfMWH00W9bLP03Kfm_KVi^KVi^009]KFd00fi^KVm_Kfm_K`03Kfm_0Vi^
KP9_Kfl00g5aLGAdM7AdM002M7Ad00=_KfmSHf=SHf<00UADE003B4Q8AdM7AdM7009FEUH00fi^KXJ6
QXJ6QP02U9BD00>CTi>5QHF5QHD00WAdM003I6ATGEeMGEeM009MGEd00emOGf=SHf=SH`02IfMW00=[
Jf]_Kfm_Kfl00W=cL`=dM7@2Lg=c0W5aL@03Kfm_KFe]KFe]009[Jf/00fYZJVUYJFUYJ@02JFUY00=Z
JVY[Jf][Jf/00Va/K003KFe]KVi^KVi^009_Kfl00g1`L75aLG5aL@03LG5a0W1`L09^KVh00fe]KFa/
K6a/K002KFe]00=_Kfm`L71`L7000W5aL@03Kfm_K6a/K6a/009YJFT00fYZJVi^KVi^KP04oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2emOG00?Lg=cRh^;Rh^800^SXj003k^k^
l_;bl_;b00;fm_H3moOg0_KfmP03m?CdlO7alO7a00;^k^h00nc/k>WYjNWYj@02j>SX00?WinOVi^KV
i^H01nKViPgWinL2i^KV0^GUi@03i>CTh^;Rh^;R00;Ogml00mgMgM[Jf][JfP02emOG00?EeMGCdm?C
dm<00]7Ad@03c/k>bl_;bl_;00;7alL00l71`KVi^KVi^@02[Jf]00>OWin=SHf=SHd00W]kN`03IfMW
De=CDe=C0090@4000c0`<2<S8b<S8`026ATI00<C4a<@410@41000a0@408B4Q8251@D1ADE5@0351@D
4a<C4a<C00<D51@25QHF0QTI6@037AdM8R8R8R8R008X:2P00c0`<3Ti>CTi>@02@d=300=@D51NGUiN
GUh00Vm_K`03PX:2UIFEUIFE00:YZJT00kbl_<g=cLg=c@02g=cL00?WinO^k^k^k^h00o3`l0;]kNd2
jNWY00?Ti>COgmoOgml00]_Kf`;IfMT00mSHf=WIfMWIf@02f][J00?Lg=cNg]kNg]h00]oOg`GPh>00
0mkNg]gMgMgMg@02fm_K00?Jf][IfMWIfMT00]SHf0[GemL00mKFe]GEeMGEe@02dm?C00?AdM7@d=3@
d=000/k>cP03cLg=c<c<c<c<00;=cLd00lk>c];Bd];BdP04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0W5aL@03Jf][I6ATI6AT009LG5`00eADE4i>CTi>CP02BTY:00=;Bd]>CTi>CTh00U9B
DP03EUIFEeMGEeMG009GEeL3EUIF0UUIF@03G5aLGemOGemO009RHV85I6AT00=SHf=RHV9RHV800V5Q
H@IPH602HF5Q0V9RHP9TI6@00fEUIFMWIfMWI`02Jf][00=aLG5hN7QhN7P00WinOP03PH61P820P820
009kNg/00gIfMW=cLg=cL`02MGEe00=jNWYnOWinOWh00WinOP03N7QhKVi^KVi^009TI6@00emOGf1P
H61PH002IfMW00=_KfmgMgMgMgL00W]kN`EmOGd00g]kNgYjNWYjNP02NGUi0gQhN09jNWX00g]kNgal
O7alO002NWYj00=fMWIaLG5aLG400Vi^KP03KFe]KVi^KVi^009^KVh00fUYJEaLG5aLG002C4a<0d10
@09BDU800fm_Khb<S8b<S002WYjN00>MWIf=SHf=SHd00WQhN003IVIVGEeMGEeM009KFe/00eaLG5mO
GemOG`02HF5Q00=TI6AWIfMWIfL00VYZJP9]KFd00fm_Kg1`L71`L002L71`00=_Kfm^KVi^KVh00Vi^
KP=]KFd2KVi^00=_Kfm`L71`L7000W5aL@=bLW83Lg=c17AdM0IeMGD4M7Ad00=cLg=bLW9bLW800W=c
L`03MGEeMgMgMgMg009iNGT00gQhN7IfMWIfMP04oooo00<0003oooooool04?ooo`009Oooo`800003
oooo0]OGe`03g=cLh^;Rh^;R00;Xj>P00nk^k_;bl_;blP02m_Kf0oOgm`;fm_H00oCdm?7alO7al@02
k^k^00?/k>cYjNWYjNT00^SXj003inOWi^KVi^KV00OVi^H=inOW0^KViP;UiND00nCTi>;Rh^;RhP02
gmoO00?MgMgJf][Jf]X00]OGe`03eMGEdm?Cdm?C00;AdM400lk>c/_;bl_;b`02alO700?1`L6i^KVi
^KT00Zf][@03WinOSHf=SHf=009kNg/00fMWIe=CDe=CD`02@41000<`<30S8b<S8b<00QTI6@034a<C
410@410@00<@41024Q8B0Q@D50DE5AD00a@D51<C4a<C4`0351@D0QHF5P8I6AT00adM7B8R8R8R8P02
:2PX00<`<30i>CTi>CT00T=3@`03D51@GUiNGUiN009_Kfl00h:2PYFEUIFEU@02ZJVY00>l_;c=cLg=
cLd00]cLg003inOWk^k^k^k^00?`l?02kNg]0^WYj@03i>CTgmoOgmoO00;Kfm/2fMWI00?Hf=SIfMWI
fMT00][JfP03g=cLg]kNg]kN00;Ogml5h>3P00?Ng]kMgMgMgMd00]_Kf`03f][JfMWIfMWI00;Hf=P:
emOG00?Fe]KEeMGEeMD00]?Cd`03dM7Ad=3@d=3@00;>c/h00lg=cLc<c<c<c002cLg=00?>c/kBd];B
d]800oooo`80000doooo00@0003oooooooooool2LG5a00=[Jf]TI6ATI6@00UaLG003E5ADCTi>CTi>
009:BTX00d];Bdi>CTi>CP02DU9B00=FEUIGEeMGEeL00UMGE`=FEUH2FEUI00=LG5aOGemOGel00V9R
HPETI6@00f=SHf9RHV9RHP02HF5Q1V1PH09QHF42HV9R0VATI003IFEUIfMWIfMW009[Jf/00g5aLGQh
N7QhN002OWin00>1PH60P820P8000W]kN`03MWIfLg=cLg=c009eMGD00gYjNWinOWinOP02OWin00=h
N7Q^KVi^KVh00VATI003GemOH61PH61P009WIfL00fm_KgMgMgMgM`02Ng]k1GemO@03Ng]kNWYjNWYj
009iNGT3N7Qh0WYjNP03Ng]kO7alO7al009jNWX00gIfMW5aLG5aL@02KVi^00=]KFe^KVi^KVh00Vi^
KP03JFUYG5aLG5aL009<C4`3@4100U9BDP03Kfm_S8b<S8b<00:NWYh00ifMWHf=SHf=S@02N7Qh00=V
IVIMGEeMGEd00U]KF`03G5aLGemOGemO009QHF400fATI6MWIfMWI`02JVYZ0Ve]K@03Kfm_L71`L71`
009`L7000fm_Kfi^KVi^KP02KVi^0fe]K@9^KVh00fm_Kg1`L71`L002LG5a0g9bLP=cLg<4M7Ad1WEe
M@AdM7@00g=cLg9bLW9bLP02Lg=c00=eMGEgMgMgMgL00WUiN@03N7QhMWIfMWIf00?oool200004_oo
o`009Oooo`030000oooooooo00;oool2gMgM00?Shn?YjNWYjNT00^o_k`03m?CdnOWinOWi00;lo?`3
oOgm0_clo003n_[jmoOgmoOg00;dm?@00o7alNk^k^k^kP02k>c/00?[jn_Zj^[Zj^X00nWYj@[Xj>P9
jNWY0^SXj003inOWiNGUiNGU00;Shn<00n3Ph=gMgMgMg@02f][J00?Hf=SGemOGemL00]KFeP03e=CD
d];Bd];B00;>c/h00lS8b;no_kno_`02/k>c00>SXj>?Shn?Shl00WYjNP03Hf=SC4a<C4a<008h>3P0
0bDU9ALG5aLG5`023Ph>00<92@T820P820P00PT92@0330`<410@410@008C4a<35ADE0Q@D50034Q8B
410@410@008?3`l00`h>3Q0@410@40024a<C00<H61PP820P82000RTY:@03=3@d@D51@D51009>CTh0
0eeMGFe]KFe]K@02OWin00>?ShnQXJ6QXJ400[>c/`03`l?3d];Bd];B00;Ng]h00nSXj>g]kNg]k@02
l?3`00?_kno]kNg]kNd00^WYj@03iNGUhN7QhN7Q00;MgMd2fm_K00?Jf][Kfm_Kfm/00]cLg003gMgM
g]kNg]kN00;Ogml00n3Ph=oOgmoOg`02g]kN00?MgMgKfm_Kfm/00][JfP03f=SHemOGemOG00OFe]H8
emOG0]KFeP03e=CDdm?Cdm?C00;Bd]83dM7A0];BdP03e=CDf=SHf=SH00Coool00`000?ooooooo`0b
oooo00@0003oooooooooool2KVi^00=TI6AIFEUIFET00U1@D003BDU9A4A4A4A40092@T800dA4A4M7
AdM7A`02C4a<00=?Cdm@D51@D5000U1@D0=?Cdl2DU9B00=FEUIJFUYJFUX00UiNGP03H61PHF5QHF5Q
00=QHF42H61P0UmOG`03GUiNGEeMGEeM00=LG5`2GEeM0UiNGP9PH6000f9RHVEUIFEUI@02JFUY00=_
KfmeMGEeMGD00W]kN`03OWinOgmoOgmo009mOGd00g]kNgUiNGUiN@02NGUi0g]kN`9iNGT00g=cLf][
Jf][J`02Hf=S00=QHF5TI6ATI6@00Va/K003MGEeO7alO7al009oOgl00ginOWalO7alO002NWYj0gUi
N@9jNWX00g]kNgalO7alO002OWin0gmoO`9nOWh00galO7QhN7QhN002Lg=c00=^KViXJ6QXJ6P00V9R
HP03Fe]KDU9BDU9B009;Bd/00dQ8B4i>CTi>CP02H61P00=hN7R?Shn?Shl00YbLW003VIVIRXZ:RXZ:
009gMgL00fMWIeiNGUiNGP02Fe]K00=LG5aNGUiNGUh00V1PH003HF5QHf=SHf=S009VIVH2JFUY00=/
K6a^KVi^KVh00fm_K`M^KVh2L71`00=aLG5bLW9bLW800W=cL`EdM7@6MGEe17IfMP=gMgL2MWIf00=d
M7AcLg=cLg<00WAdM003MgMgNg]kNg]k009mOGd00galO7MgMgMgM`04oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool2gMgM00?Shn?YjNWYjNT00^o_k`03m?CdnOWinOWi00;lo?`3
oOgm0_clo003n_[jmoOgmoOg00;dm?@00o7alNk^k^k^kP02k>c/00?[jn_Zj^[Zj^X00nWYj@[Xj>P9
jNWY0^SXj003inOWiNGUiNGU00;Shn<00n3Ph=gMgMgMg@02f][J00?Hf=SGemOGemL00]KFeP03e=CD
d];Bd];B00;>c/h00lS8b;no_kno_`02/k>c00>SXj>?Shn?Shl00WYjNP03Hf=SC4a<C4a<008h>3P0
0bDU9ALG5aLG5`023Ph>00<92@T820P820P00PT92@0330`<410@410@008C4a<35ADE0Q@D50034Q8B
410@410@008?3`l00`h>3Q0@410@40024a<C00<H61PP820P82000RTY:@03=3@d@D51@D51009>CTh0
0eeMGFe]KFe]K@02OWin00>?ShnQXJ6QXJ400[>c/`03`l?3d];Bd];B00;Ng]h00nSXj>g]kNg]k@02
l?3`00?_kno]kNg]kNd00^WYj@03iNGUhN7QhN7Q00;MgMd2fm_K00?Jf][Kfm_Kfm/00]cLg003gMgM
g]kNg]kN00;Ogml00n3Ph=oOgmoOg`02g]kN00?MgMgKfm_Kfm/00][JfP03f=SHemOGemOG00OFe]H8
emOG0]KFeP03e=CDdm?Cdm?C00;Bd]83dM7A0];BdP03e=CDf=SHf=SH00Coool00`000?ooooooo`0b
oooo00@0003oooooooooool2KVi^00=TI6AIFEUIFET00U1@D003BDU9A4A4A4A40092@T800dA4A4M7
AdM7A`02C4a<00=?Cdm@D51@D5000U1@D0=?Cdl2DU9B00=FEUIJFUYJFUX00UiNGP03H61PHF5QHF5Q
00=QHF42H61P0UmOG`03GUiNGEeMGEeM00=LG5`2GEeM0UiNGP9PH6000f9RHVEUIFEUI@02JFUY00=_
KfmeMGEeMGD00W]kN`03OWinOgmoOgmo009mOGd00g]kNgUiNGUiN@02NGUi0g]kN`9iNGT00g=cLf][
Jf][J`02Hf=S00=QHF5TI6ATI6@00Va/K003MGEeO7alO7al009oOgl00ginOWalO7alO002NWYj0gUi
N@9jNWX00g]kNgalO7alO002OWin0gmoO`9nOWh00galO7QhN7QhN002Lg=c00=^KViXJ6QXJ6P00V9R
HP03Fe]KDU9BDU9B009;Bd/00dQ8B4i>CTi>CP02H61P00=hN7R?Shn?Shl00YbLW003VIVIRXZ:RXZ:
009gMgL00fMWIeiNGUiNGP02Fe]K00=LG5aNGUiNGUh00V1PH003HF5QHf=SHf=S009VIVH2JFUY00=/
K6a^KVi^KVh00fm_K`M^KVh2L71`00=aLG5bLW9bLW800W=cL`EdM7@6MGEe17IfMP=gMgL2MWIf00=d
M7AcLg=cLg<00WAdM003MgMgNg]kNg]k009mOGd00galO7MgMgMgM`04oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool2hN7Q00?Vi^K/k>c/k>`00_7al@03m_Kfn_[jn_[j00;moOd3
o_kn0_clo003n_[jn?Shn?Sh00;emOD00o;bl_3`l?3`l002kNg]00?/k>c[jn_[jn/00^[ZjP?YjNT8
j>SX1>WYj@GZj^X2jNWY00?Xj>SVi^KVi^H00^?Sh`03hN7Qg]kNg]kN00;Lg=`3f][J0mWIf@;Hf=P2
eMGE00?@d=37alO7alL00[Zj^P03ZJVYTi>CTi>C009lO7`00f9RHTY:BTY:BP02<S8b00<O7al@410@
41000PH61P030P820`<30`<300861PH00`/;2a4A4A4A4@025ADE0aPH608F5QH00a<C4`l?3`l?3`02
30`<00<:2PX;2`/;2`/00Pl?3`035QHF8B4Q8B4Q008^;Rh00cdm?De=CDe=C@02GEeM00=_Kfn0P820
P8000Y2@T003XJ6Q/;2`/;2`00:n_[h00l_;bmKFe]KFeP02gmoO00?Vi^K[jn_[jn/00ng]k@;[jn/2
j>SX00?UiNGRh^;Rh^800]oOg`;MgMd3g=cL0mgMg@;Ng]h3gmoO1=kNgP03g=cLfm_Kfm_K00;IfMT0
0mSHf=OGemOGe`05e]KF0mOGe`WHf=P00mOGemKFe]KFeP05eMGE0]KFeP03fMWIg=cLg=cL00Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2K6a/00=SHf=JFUYJFUX00U=CD`03CTi>BTY:BTY:
00=8B4P2BTY:0Te=C@03D51@DE5ADE5A009BDU800e=CDeADE5ADE002EUIF00=IFEULG5aLG5`00UmO
G`03H61PHF5QHF5Q00EQHF43H61P0UmOG`ENGUh2GemO0V5QH@03Hf=SIFEUIFEU009YJFT00fa/K71`
L71`L002M7Ad00=gMgMiNGUiNGT00WUiN@03N7QhMgMgMgMg009gMgL00gIfMWEeMGEeM@02LW9b00=]
KFeWIfMWIfL00V=SH`03HV9RIVIVIVIV009^KVh00gIfMW]kNg]kN`02OGem00=kNg]hN7QhN7P00WEe
M@03M7AdMGEeMGEe009gMgL00gQhN7UiNGUiN@03NWYj0WalO09oOgl3PX:20WemO@03LG5aHF5QHF5Q
009CDe<3BTY:0U5AD@03G5aLJVYZJVYZ009hN7P00hF5QHf=SHf=S@02T92@00>;Rh^0P820P8000W9b
LP03IfMWH61PH61P009NGUh00emOGf1PH61PH002HV9R00=SHf=UIFEUIFD00VMWI`9YJFT00fa/K6e]
KFe]K@05KVi^1Fe]K@9_Kfl00g1`L75aLG5aL@02LW9b00=cLg=dM7AdM7@037AdM0=eMGD3M7Ad0W=c
L`9dM7@00gIfMWQhN7QhN002NGUi00=hN7QcLg=cLg<01?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0^;RhP03inOWjn_[jn_[00;_knl00o?cloOgmoOgm`02nOWi0o[jnP;inOT0
0oOgmoGemOGem@02l_;b00?`l?3^k^k^k^h00^c/k003j^[ZjNWYjNWY00?Xj>P4inOW1NKViP?WinL3
j>SX1>WYj@;Xj>P00nKVi^GUiNGUi@02hn?S00?Ph>3Ng]kNg]h00]cLg0?Kfm/2g=cL0mgMg@;Lg=`0
0mOGelo?clo?c`02`/;200>`/;2IVIVIVIT00WmoO`03I6ATBDU9BDU9008`<3000a/K6``<30`<3002
0P8200<000010@410@400PH61P033@d=51@D51@D008J6QX37QhN0QXJ6P035ADE3`l?3`l?008;2`/3
20P80Pd=3@035QHF92@T92@T008e=CD00dQ8B5aLG5aLG002L71`00>3Ph>EUIFEUID00ZJVYP03/k>c
_kno_kno00;:b/X00m;Bd][Jf][JfP02h>3P00?Ti>CWinOWinL01NSXj0;Vi^H00nCTi>;Rh^;RhP02
h>3P0]oOg`03g]kNgMgMgMgM00;MgMd8g]kN0]gMg@03g=cLfm_Kfm_K00;Jf]X00mWIfMSHf=SHf008
f=SH1=WIf@?Jf]X3fMWI1mSHf0;IfMT00m_KfmkNg]kNgP04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0VUYJ@03IFEUH61PH61P009LG5`00eQHF5EEEEEEE@02De=C00=BDU9CDe=CDe<00UAD
E003EEEEEeMGEeMG009JFUX00eaLG5iNGUiNGP02GemO00=QHF5RHV9RHV800V9RHP03Hf=SI6ATI6AT
00YTI6@2Hf=S1F9RHP9SHf<00fEUIFMWIfMWI`02JFUY00=[Jf]/K6a/K6`00Ve]K@03Kfm_L71`L71`
009aLG45LW9b00=aLG5_Kfm_Kfl00Ve]K@03JFUYIVIVIVIV00=TI6@2J6QX0Vi^KP03M7AdN7QhN7Qh
009iNGT00gMgMgAdM7AdM002LG5a0g1`L09aLG46LW9b0WIfMP9mOGd00hJ6QX^;Rh^;R`02QXJ600=e
MGEMGEeMGEd00TM7A`03?CdmADE5ADE5009JFUX00gAdM8R8R8R8R002T92@00>?Shn9RHV9RHT00X20
P003NGUiLg=cLg=c009]KFd00fMWIfATI6ATI002HV9R00=SHf=TI6ATI6@00VEUI@03IfMWJ6QXJ6QX
009ZJVX2Jf][00=/K6a]KFe]KFd01Fe]K@E/K6`2KFe]00=^KVi_Kfm_Kfl00W1`L003LG5aLW9bLW9b
00QbLW85LG5a1g9bLPEcLg<2LW9b00=`L71]KFe]KFd01?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0^;RhP03inOWjn_[jn_[00;_knl00o?cloOgmoOgm`02nOWi0o[jnP;inOT0
0oOgmoGemOGem@02l_;b00?`l?3^k^k^k^h00^c/k003j^[ZjNWYjNWY00?Xj>P4inOW1NKViP?WinL3
j>SX1>WYj@;Xj>P00nKVi^GUiNGUi@02hn?S00?Ph>3Ng]kNg]h00]cLg0?Kfm/2g=cL0mgMg@;Lg=`0
0mOGelo?clo?c`02`/;200>`/;2IVIVIVIT00WmoO`03I6ATBDU9BDU9008`<3000a/K6``<30`<3002
0P8200<000010@410@400PH61P033@d=51@D51@D008J6QX37QhN0QXJ6P035ADE3`l?3`l?008;2`/3
20P80Pd=3@035QHF92@T92@T008e=CD00dQ8B5aLG5aLG002L71`00>3Ph>EUIFEUID00ZJVYP03/k>c
_kno_kno00;:b/X00m;Bd][Jf][JfP02h>3P00?Ti>CWinOWinL01NSXj0;Vi^H00nCTi>;Rh^;RhP02
h>3P0]oOg`03g]kNgMgMgMgM00;MgMd8g]kN0]gMg@03g=cLfm_Kfm_K00;Jf]X00mWIfMSHf=SHf008
f=SH1=WIf@?Jf]X3fMWI1mSHf0;IfMT00m_KfmkNg]kNgP04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0VUYJ@03IFEUH61PH61P009LG5`00eQHF5EEEEEEE@02De=C00=BDU9CDe=CDe<00UAD
E003EEEEEeMGEeMG009JFUX00eaLG5iNGUiNGP02GemO00=QHF5RHV9RHV800V9RHP03Hf=SI6ATI6AT
00YTI6@2Hf=S1F9RHP9SHf<00fEUIFMWIfMWI`02JFUY00=[Jf]/K6a/K6`00Ve]K@03Kfm_L71`L71`
009aLG45LW9b00=aLG5_Kfm_Kfl00Ve]K@03JFUYIVIVIVIV00=TI6@2J6QX0Vi^KP03M7AdN7QhN7Qh
009iNGT00gMgMgAdM7AdM002LG5a0g1`L09aLG46LW9b0WIfMP9mOGd00hJ6QX^;Rh^;R`02QXJ600=e
MGEMGEeMGEd00TM7A`03?CdmADE5ADE5009JFUX00gAdM8R8R8R8R002T92@00>?Shn9RHV9RHT00X20
P003NGUiLg=cLg=c009]KFd00fMWIfATI6ATI002HV9R00=SHf=TI6ATI6@00VEUI@03IfMWJ6QXJ6QX
009ZJVX2Jf][00=/K6a]KFe]KFd01Fe]K@E/K6`2KFe]00=^KVi_Kfm_Kfl00W1`L003LG5aLW9bLW9b
00QbLW85LG5a1g9bLPEcLg<2LW9b00=`L71]KFe]KFd01?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0^;RhP03iNGUj>SXj>SX00;[jn/00nk^k_3`l?3`l005l_;b0_7al@03l?3`
kno_kno_00;]kNd00n_[jnWYjNWYj@02j>SX00?WinOVi^KVi^H00^KViP03iNGUi>CTi>CT00STi>@4
iNGU1NKViP;UiND00nCTi>?Shn?Sh`02hN7Q00?Ng]kLg=cLg=`00m_Kf`;MgMd2gmoO00?QhN7Rh^;R
h^800^;RhP03g]kNemOGemOG00;:b/X00kNg]inOWinOW`02Q8B400=XJ6Q;Bd];Bd/00S4a<@036a/K
2`/;2`/;00820P800`0000<30`<30`022@T900<B4Q8K6a/K6a/00R8R8P<U9BD2820P00<I6ATB4Q8B
4Q800P/;2`<71`L230`<00<H61PX:2PX:2P00Sdm?@03E5ADK6a/K6a/00:3Ph<00iVIVJb/[:b/[002
^k^k00?7alO?clo?cll00]GEe@03f][JgMgMgMgM00;Ogml00n3Ph>7QhN7Qh@02h^;R1N?Sh`03h^;R
hN7QhN7Q00;QhN42h>3P00?OgmoNg]kNg]h01mkNgPGMgMd3g=cL0]_Kf`GJf]X3fMWI1M[JfPOKfm/6
f][J1=_Kf`03gMgMgmoOgmoO00Coool00`000?ooooooo`0boooo00@0003oooooooooool3J6QX0VMW
I`9UIFD00f=SHf5QHF5QH@02GemO00=NGUiMGEeMGEd00UaLG003GEeMGemOGemO009RHV800fEUIFMW
IfMWI`03J6QX2FMWI`EXJ6P00fUYJFQXJ6QXJ002J6QX00=WIfMVIVIVIVH00VIVIP9WIfL00fQXJ6YZ
JVYZJP03Jf][0VYZJPEYJFT3JVYZ0V][J`9/K6`3KFe]0Va/K003Jf][JFUYJFUY00=WIfL2JFUY0Ve]
K@03LG5aM7AdM7Ad009fMWH00gMgMgIfMWIfMP02M7Ad00=`L71/K6a/K6`00VUYJ@=WIfL2JFUY00=/
K6abLW9bLW800WalO003QXJ6SHf=SHf=00:9RHT00gIfMUeMGEeMG@02ATI600<m?Ce:BTY:BTX00VIV
IP03QHF5VYZJVYZJ00:LW9`00i6ATGmoOgmoO`02L71`00=YJFUXJ6QXJ6P01FUYJ@9XJ6P00fMWIfQX
J6QXJ002JFUY00=ZJVY/K6a/K6`00Va/K0M]KFd:K6a/00=]KFe^KVi^KVh00Vi^KP03Kfm_L71`L71`
00Q`L704Kfm_0fi^KP9_Kfl00g1`L75aLG5aL@02LG5a00=`L71^KVi^KVh00Va/K003JVYZJFUYJFUY
00Coool00`000?ooooooo`0@oooo000Joooo0P0000Coool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`;Rh^800nGUiNSXj>SXj002jn_[00?^k^k`l?3`l?001O;blP;alO400o3`l>o_kno_k`02
kNg]00?[jn_YjNWYjNT00^SXj003inOWi^KVi^KV00;Vi^H00nGUiNCTi>CTi008i>CT1>GUi@GVi^H2
iNGU00?Ti>CShn?Shn<00^7Qh@03g]kNg=cLg=cL00?Kfm/2gMgM0]oOg`03hN7Qh^;Rh^;R00;Rh^80
0mkNg]OGemOGe`02b/[:00>g]kNOWinOWil00XB4Q003J6QXBd];Bd];008a<C400a/K6`/;2`/;2`02
0P8200<000030`<30`<00PT92@034Q8B6a/K6a/K008R8R839BDU0R0P80036ATI4Q8B4Q8B008;2`/3
1`L70P`<300361PH:2PX:2PX008m?Cd00eADE6a/K6a/K002Ph>300>IVIV/[:b/[:`00[^k^`03alO7
clo?clo?00;EeMD00m[Jf]gMgMgMg@02gmoO00?Ph>3QhN7QhN400^;RhPGShn<00n;Rh^7QhN7Qh@02
hN7Q0^3Ph003gmoOg]kNg]kN00ONg]h5gMgM0mcLg0;Kfm/5f][J0mWIf@GJf]X7fm_K1][JfPCKfm/0
0mgMgMoOgmoOg`04oooo00<0003oooooool09_ooo`800004oooo00<0003oooooool00oooo`040000
oooooooooooo0fQXJ09WIfL2IFEU00=SHf=QHF5QHF400UmOG`03GUiNGEeMGEeM009LG5`00eeMGEmO
GemOG`02HV9R00=UIFEWIfMWIfL00fQXJ0UWIfL5J6QX00=YJFUXJ6QXJ6P00VQXJ003IfMWIVIVIVIV
009VIVH2IfMW00=XJ6QZJVYZJVX00f][J`9ZJVX5JFUY0fYZJP9[Jf/2K6a/0fe]K@9/K6`00f][JfUY
JFUYJ@03IfMW0VUYJ@9]KFd00g5aLGAdM7AdM002MWIf00=gMgMfMWIfMWH00WAdM003L71`K6a/K6a/
009YJFT3IfMW0VUYJ@03K6a/LW9bLW9b009lO7`00hJ6QXf=SHf=S@02RHV900=fMWIMGEeMGEd00TI6
AP03?CdmBTY:BTY:009VIVH00hF5QIZJVYZJVP02W9bL00>ATI5oOgmoOgl00W1`L003JFUYJ6QXJ6QX
00EYJFT2J6QX00=WIfMXJ6QXJ6P00VUYJ@03JVYZK6a/K6a/009/K6`7KFe]2Va/K003KFe]KVi^KVi^
009^KVh00fm_Kg1`L71`L008L71`16m_K`=^KVh2Kfm_00=`L71aLG5aLG400W5aL@03L71`KVi^KVi^
009/K6`00fYZJVUYJFUYJ@04oooo00<0003oooooool04?ooo`006_ooo`030000oooo000000;oool0
0`000?ooo`000003oooo00<0003oooooool00_ooo`;Ph>000n;Rh^CTi>CTi002iNGU00?WinOXj>SX
j>P01nWYj@03j>SXinOWinOW00;Vi^H00nGUiNCTi>CTi003hn?S1>;RhPgQhN42h^;R1N?Sh`;Rh^80
0n7QhN3Ph>3Ph002g]kN00?Lg=cKfm_Kfm/00][JfP03fm_KgMgMgMgM00;Ph>000n?ShnKVi^KViP02
i^KV00?Ti>CMgMgMgMd00]3@d003_KfmYJFUYJFU00:9RHT00fa/K4i>CTi>CP02<c<c00<M7Ad<30`<
30`00P@410030`<31`L71`L7008?3`l00aTI6B8R8R8R8P02:RXZ00<^;Rh];Bd];Bd00RLW9`037QhN
5ADE5ADE008=3@d320P80Pd=3@036QXJ;Rh^;Rh^0096ATH00f5QHGalO7alO002UiNG00>_[jo2`/;2
`/800]3@d003f][JgmoOgmoO00?Ph>02gmoO0]kNgPGLg=`00mgMgMoOgmoOg`03h>3P1>7Qh@?Ph>02
gmoO0]kNgP[MgMd:g=cL1M_Kfa;Lg=`2gMgM00?Ng]kOgmoOgml01?ooo`030000oooooooo02Koool0
0`000?ooo`000002oooo00<0003oool000001?ooo`040000oooooooooooo0VUYJ@03JVYZJf][Jf][
009[Jf/3JVYZ0VQXJ003IfMWIVIVIVIV00=UIFD2IVIV0VUYJ@03Jf][KFe]KFe]00=]KFd4Jf][0fYZ
JPE[Jf/5K6a/0V][J`03JVYZJFUYJFUY009YJFT3JVYZ0V][J`E/K6`2Jf][00=YJFUWIfMWIfL00VEU
I@=TI6@2IfMW00=/K6aaLG5aLG400g=cL`9`L702KFe]0fYZJP9[Jf/00fe]KG5aLG5aL@02MgMg00=n
OWj2PX:2PX800X61P@03NGUiK6a/K6a/009OGel00eQHF5UIFEUIF@02H61P00=ZJVYdM7AdM7@00Wal
O003PX:2Q8B4Q8B400:0P8000gAdM6=SHf=SH`02EEEE00=ADE5MGEeMGEd00WAdM003Rh^;V9RHV9RH
00:EUID00hJ6QW=cLg=cL`02I6AT00=OGemSHf=SHf<00VQXJ003KFe]Kfm_Kfm_009^KVh5K6a/26e]
K@U/K6`:KFe]3Fi^KPE]KFd2KVi^1Fm_K`03KVi^K6a/K6a/009ZJVX3J6QX1?ooo`030000oooooooo
013oool001[oool00`000?ooo`000002oooo00<0003oool000000oooo`<00002oooo0]kNgQGOgml<
g]kN1mgMg@GNg]h7gmoO00?Ng]kMgMgMgMd00]cLg003fm_Kf][Jf][J00;Jf]X00m_KfmkNg]kNgP02
hN7Q00?UiNGXj>SXj>P00^WYj@03inOWh>3Ph>3P00;De=@00l71`JVYZJVYZ@02SHf=00=_KfmBDU9B
DU800SLg=`03820P410@410@00<820P23@d=0QHF5P038B4Q:b/[:b/[008c<c<00cLg=cDe=CDe=@02
;Rh^00<T92@I6ATI6AT00Q0@40032PX:2@T92@T9008?3`l00ahN7S<c<c<c<`02CTi>00=/K6b:RXZ:
RXX00ZNWY`03`L71eMGEeMGE00;Rh^800nWYjN_[jn_[j`02j^[Z00?Vi^KQhN7QhN400]gMg@03fMWI
emOGemOG00;GemL00mSHf=[Jf][JfP02g=cL00?Ng]kOgmoOgml01N3Ph0;Ogml2g]kN0mgMg@OLg=`N
gMgM2=kNgP?oool20000:?ooo`030000oooo000000;oool00`000?ooo`000004oooo0P0000;oool2
Jf][00=/K6a]KFe]KFd026i^KP9]KFd3K6a/16e]K@03KVi^Kfm_Kfm_00=_Kfl2KVi^1Fe]K@Y^KVh3
KFe]2Fa/K09]KFd00fi^KVm_Kfm_K`02L71`00=^KViYJFUYJFT00V=SH`=OGel2IFEU00=_KfmiNGUi
NGT00gmoO`9iNGT2Lg=c00=]KFeYJFUYJFT00VMWI`03JFUYKfm_Kfm_009jNWX00hR8R9>CTi>CT`02
U9BD00>5QHE^KVi^KVh00UMGE`03BDU9Bd];Bd];009IFET00f][JgQhN7QhN002OGem00=kNg]fMWIf
MWH00W5aL@03KVi^KFe]KFe]009]KFd00g1`L7MgMgMgM`02P82000>7QhN8R8R8R8P00X20P003Lg=c
IFEUIFEU00=LG5`2HV9R0V][J`03LG5aM7AdM7Ad009cLg<00g5aLFm_Kfm_K`02KVi^0fe]K@U/K6`3
KFe]1Fi^KQa]KFd2KVi^0fe]K@9/K6`2Jf][0fYZJP?oool200004_ooo`006_ooo`800003oooo00<0
003oool000000oooo`030000oooooooo00;oool2g]kN5MoOg`cNg]h7gMgM1MkNgPOOgml00mkNg]gM
gMgMg@02g=cL00?Kfm_Jf][Jf]X00][JfP03fm_Kg]kNg]kN00;QhN400nGUiNSXj>SXj002jNWY00?W
inOPh>3Ph>000]CDe003`L71ZJVYZJVY00:=SHd00fm_Ke9BDU9BDP02=cLg00<P820@410@41000`P8
208=3@d25QHF00<Q8B4[:b/[:b/00S<c<`03=cLg=CDe=CDe008^;Rh00b@T91TI6ATI6@02410@00<:
2PX92@T92@T00Pl?3`037QhN<c<c<c<c009>CTh00fa/K8Z:RXZ:RP02YjNW00?1`L7EeMGEeMD00^;R
hP03jNWYjn_[jn_[00;Zj^X00nKVi^7QhN7Qh@02gMgM00?IfMWGemOGemL00]OGe`03f=SHf][Jf][J
00;Lg=`00mkNg]oOgmoOg`05h>3P0]oOg`;Ng]h3gMgM1mcLg1kMgMd8g]kN1?ooo`030000oooooooo
02Koool200000oooo`030000oooo000000Coool010000?ooooooooooo`9[Jf/00fa/K6e]KFe]K@08
KVi^0Ve]K@=/K6`4KFe]00=^KVi_Kfm_Kfl00fm_K`9^KVh5KFe]2Vi^KP=]KFd9K6a/0Ve]K@03KVi^
Kfm_Kfm_009`L7000fi^KVUYJFUYJ@02Hf=S0emOG`9UIFD00fm_KgUiNGUiN@03Ogmo0WUiN@9cLg<0
0fe]KFUYJFUYJ@02IfMW00=YJFU_Kfm_Kfl00WYjNP03R8R8Ti>CTi>C00:DU9@00hF5QFi^KVi^KP02
EeMG00=9BDU;Bd];Bd/00UUIF@03Jf][N7QhN7Qh009mOGd00g]kNgIfMWIfMP02LG5a00=^KVi]KFe]
KFd00Ve]K@03L71`MgMgMgMg00:0P8000hN7QhR8R8R8R002P82000=cLg=UIFEUIFD00eaLG09RHV82
Jf][00=aLG5dM7AdM7@00W=cL`03LG5aKfm_Kfm_009^KVh3KFe]2Fa/K0=]KFd5KVi^76e]K@9^KVh3
KFe]0Va/K09[Jf/3JVYZ1?ooo`030000oooooooo013oool001[oool00`000?ooooooo`02oooo00<0
003oool000000oooo`030000oooooooo00;oool2g=cL00?Kfm_Jf][Jf]X00]WIf@03f=SHemOGemOG
00SGemL4f=SH0mWIfACJf]X3fm_K1mcLg0;Kfm/3f][J0]WIf@;Jf]X00m_KfmkNg]kNgP02h^;R00?U
iNGXj>SXj>P00^WYj@03inOWh>3Ph>3P00;De=@00l71`JZZZZZZZP02Shn?00=bLW9EEEEEEED00S/k
>`039BDU5QHF5QHF00<?3`l25ADE0QhN7P03:RXZ=CDe=CDe008m?Cd00d10@3dm?Cdm?@02=CDe00<Z
:RXN7QhN7Qh00Q<C4`0330`<2PX:2PX:008A4A400b0P83Ph>3Ph>002E5AD00=dM7BEUIFEUID00[>c
/`03c/k>h^;Rh^;R00;_knl3mOGe0_3`l003j^[Zhn?Shn?S00;Lg=`00mKFe]?Cdm?Cd`02dm?C00?D
e=CGemOGemL00]WIf@03g=cLg]kNg]kN00;Ogml2h>3P0moOg`;Ng]h00mgMgMcLg=cLg007g=cL0mgM
g@GNg]h5gmoO3mkNgPGOgml3g]kN0]gMg@Coool00`000?ooooooo`0Voooo00<0003oooooool00_oo
o`030000oooo000000Coool010000?ooooooooooo`9^KVh00fm_Kg1`L71`L002LG5a0g9bLPQcLg<4
LW9b0g5aLAA`L707Kfm_0fi^KP9]KFd2KVi^00=`L71cLg=cLg<00WAdM003Lg=cK6a/K6a/009SHf<3
Fe]K0VATI003Lg=cPX:2PX:200:;Rh/00hZ:RX61PH61P@02MWIf00=/K6aUIFEUIFD00V9RHP03I6AT
K6a/K6a/009mOGd00i:BTZ:RXZ:RXP02Y:BT00>ATI5aLG5aLG400U5AD@03?Cdm@410@410009CDe<0
0f][JgalO7alO002OGem00=cLg=XJ6QXJ6P00V=SH`03JFUYMgMgMgMg00:4Q8@00hf=SHj>SXj>SP02
R8R800=oOgmdM7AdM7@00VYZJP03H61PFEUIFEUI009GEeL00e]KFfATI6ATI002KFe]00=eMGEiNGUi
NGT00WQhN003MGEeLW9bLW9b009`L7000fi^KVe]KFe]K@02K6a/0f][J`9/K6`3KFe]2Fi^KP=]KFd?
K6a/1fe]K@Y/K6`3KFe]1?ooo`030000oooooooo013oool001_oool200000oooo`030000oooooooo
00;oool00`000?ooooooo`02oooo0]cLg003fm_Kf][Jf][J00;IfMT00mSHf=OGemOGe`08emOG1=SH
f0?IfMTDf][J0m_Kf`OLg=`2fm_K0m[JfP;IfMT2f][J00?Kfm_Ng]kNg]h00^;RhP03iNGUj>SXj>SX
00;YjNT00nOWin3Ph>3Ph002e=CD00?1`L6ZZZZZZZX00Xn?S`03LW9bEEEEEEEE008k>c/00bDU9AHF
5QHF5P033`l?0QDE5@8N7Qh00bXZ:SDe=CDe=@02?Cdm00=0@40m?Cdm?Cd00SDe=@03:RXZ7QhN7QhN
008C4a<00``<30X:2PX:2P024A4A00<P820h>3Ph>3P00UADE003M7AdUIFEUIFE00:c/k<00lk>c^;R
h^;RhP02kno_0oGem@;`l?000n[Zj^?Shn?Sh`02g=cL00?Fe]KCdm?Cdm<00]?Cd`03e=CDemOGemOG
00;IfMT00mcLg=kNg]kNgP02gmoO0^3Ph0?Ogml2g]kN00?MgMgLg=cLg=`01mcLg0?MgMd5g]kN1MoO
g`oNg]h5gmoO0mkNgP;MgMd4oooo00<0003oooooool09oooo`800003oooo00<0003oooooool00ooo
o`040000oooooooooooo0Vi^KP03Kfm_L71`L71`009aLG43LW9b27=cL`AbLW83LG5a571`L0M_Kfl3
KVi^0Ve]K@9^KVh00g1`L7=cLg=cL`02M7Ad00=cLg=/K6a/K6`00V=SH`=KFe/2I6AT00=cLg>2PX:2
PX800X^;R`03RXZ:PH61PH61009fMWH00fa/K6EUIFEUI@02HV9R00=TI6A/K6a/K6`00WemO@03TY:B
XZ:RXZ:R00:TY:@00i6ATG5aLG5aL@02DE5A00<m?Ce0@410@4000U=CD`03Jf][O7alO7al009mOGd0
0g=cLfQXJ6QXJ002Hf=S00=YJFUgMgMgMgL00XB4Q003SHf=SXj>SXj>00:8R8P00gmoOgAdM7AdM002
JVYZ00=PH61IFEUIFET00UMGE`03Fe]KI6ATI6AT009]KFd00gEeMGUiNGUiN@02N7Qh00=eMGEbLW9b
LW800W1`L003KVi^KFe]KFe]009/K6`3Jf][0Va/K0=]KFd9KVi^0fe]K@m/K6`7KFe]2Va/K0=]KFd4
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2fm_K00?IfMWGemOGemL00]GE
e@03dm?CdM7AdM7A00O@d=000m7AdM;Bd];BdP02dm?C00?De=CEeMGEeMD00]KFeP?GemLDf=SH1=WI
f@SJf]X2fm_K00?MgMgOgmoOgml00^;RhP03iNGUi^KVi^KV00;Vi^H00n;Rh]_Kfm_Kf`02clo?00>m
_KfWYjNWYjL00Xf=S@03LW9bEeMGEeMG008o?cl00b/[:adM7AdM7@025aLG00<H61PN7QhN7Qh00RPX
:003<c<c?Shn?Shn0095ADD00dQ8B4A4A4A4A002>c/k00<_;blR8R8R8R800QHF5P033Ph>30`<30`<
008B4Q800b8R8SXj>SXj>P02EeMG00=hN7RIVIVIVIT00[Rh^003e=CDj>SXj>SX00;emOD00o[jn_Wi
nOWin@02lo?c00?/k>cTi>CTi>@00]_Kf`03eMGEd];Bd];B00;AdM400m;Bd]GEeMGEe@02f=SH00?J
f][MgMgMgMd00]kNgP?Ogml2g]kN0]gMg@SLg=`3gMgM1=kNgQkOgml00mkNg]cLg=cLg004oooo00<0
003oooooool0<_ooo`040000oooooooooooo0W1`L003LG5aLW9bLW9b009cLg<00gEeMGIfMWIfMP02
MgMg1WQhN09gMgL2MGEe00=dM7AcLg=cLg<0279bLPiaLG43LW9b175aL@03Kfm_KVi^KVi^009^KVh0
0g1`L7AdM7AdM002MgMg00=eMGE]KFe]KFd00V=SH`=KFe/2IVIV00=iNGV:RXZ:RXX00Y>CT`03Shn?
PH61PH61009aLG400f=SHe]KFe]KF`02FUYJ00=NGUiZJVYZJVX00WinOP03UYJFZ:RXZ:RX00:[Zj/0
0iNGUgAdM7AdM002Cdm?00<i>CTk>c/k>c/00U1@D003JFUYNg]kNg]k009kNg/00fm_Kf=SHf=SH`02
GUiN00=XJ6QjNWYjNWX00Xb<S003UYJFU9BDU9BD00:7QhL00gQhN6QXJ6QXJ002GEeM00=FEUICDe=C
De<00UEEE@03Fe]KIFEUIFEU009_Kfl00gQhN7]kNg]kN`02Ng]k00=hN7QdM7AdM7@00W5aL@03KVi^
KFe]KFe]009/K6`3Jf][0Va/K09]KFd00fi^KVm_Kfm_K`05Kfm_0Vi^KP=]KFd3K6a/2V][J`A/K6`3
KFe]0fa/K0E[Jf/2K6a/0Ve]K@03KVi^Kfm_Kfm_00Coool00`000?ooooooo`0@oooo000Uoooo00<0
003oooooool00_ooo`;Jf]X00mOGemGEeMGEe@02dm?C00?@d=3?clo?cll01lg=c@03c/k>clo?clo?
00;AdM400m;Bd]?Cdm?Cd`02e=CD00?EeMGFe]KFe]H00mOGe`GHf=P4emOG0mKFeP?EeMD4e]KF0]OG
e`03fMWIf][Jf][J00;Kfm/00mcLg=gMgMgMg@02g]kN00?Ph>3QhN7QhN400n;RhP;QhN42gmoO00?J
f][AdM7AdM400/G5a@03];BdWinOWinO00:8R8P00g1`L5QHF5QHF002@d=300<a<C4V9RHV9RH00R4Q
8@038b<S:BTY:BTY008b<S800c`l?4I6ATI6AP02C4a<00=>CTi9BDU9BDT00Slo?`03<c<c9BDU9BDU
008I6AT00a0@40d=3@d=3@024a<C00<R8R8i>CTi>CT00UIFEP03MWIfUiNGUiNG00:f][H00m7AdNGU
iNGUi@02l_;b00?hn?SgmoOgmoL00_;blP03jn_[i>CTi>CT00;Lg=`00mKFe];Bd];BdP02d];B00?C
dm?EeMGEeMD00]OGe`03f][Jg=cLg=cL00;MgMd3g]kN0]gMg@[Lg=`3gMgM0]kNgPGOgml5h>3P3moO
g`?Ph>04gmoO00?MgMgLg=cLg=`01?ooo`030000oooooooo03;oool010000?ooooooooooo`9aLG40
0g9bLWAdM7AdM002MGEe00=gMgMhN7QhN7P00WYjNPIkNg/2NGUi0WQhN003MWIfM7AdM7Ad009dM7@5
Lg=c2W9bLP=cLg<7M7Ad0W9bLP03L71`KVi^KVi^009]KFd00fm_Kg5aLG5aL@02Lg=c00=bLW9]KFe]
KFd00VEUI@03GUiNH61PH61P009/K6`00ginOXj>SXj>SP02U9BD00>;Rh]gMgMgMgL00V9RHP03DU9B
C4a<C4a<009?Cdl00eUIFFQXJ6QXJ002OGem00>BTY:RXZ:RXZ800ZBTY003TY:BLg=cLg=c009CDe<3
?clo0Tm?C`03Hf=SLg=cLg=c009gMgL00g5aLFYZJVYZJP02IfMW00=[Jf]eMGEeMGD00WemO@03PX:2
PH61PH61009kNg/00gAdM6][Jf][J`02HV9R00=JFUYDE5ADE5@00UADE003FUYJI6ATI6AT009`L700
0gQhN7alO7alO002Ng]k00=gMgMcLg=cLg<00W5aL@03Kfm_KVi^KVi^009]KFd2K6a/0fe]K@9^KVh6
Kfm_16i^KP=]KFd3K6a/2V][J`U/K6`3Jf][0VYZJP03Jf][K6a/K6a/009]KFd00fi^KW1`L71`L004
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2f][J00?GemOEeMGEeMD00]?C
d`03d=3@clo?clo?00O=cLd00lk>c/o?clo?c`02dM7A00?Bd];Cdm?Cdm<00]CDe003eMGEe]KFe]KF
00?GemL5f=SH1=OGe`?Fe]H3eMGE1=KFeP;GemL00mWIfM[Jf][JfP02fm_K00?Lg=cMgMgMgMd00]kN
gP03h>3PhN7QhN7Q00?Rh^82hN7Q0]oOg`03f][JdM7AdM7A00;5aLD00kBd]9nOWinOW`02R8R800=`
L71HF5QHF5P00T=3@`03<C4a9RHV9RHV008Q8B400b<S8bTY:BTY:@02<S8b00<l?3a6ATI6ATH00Ta<
C003CTi>BDU9BDU9008o?cl00c<c<bDU9BDU9@026ATI00<@410=3@d=3@d00Q<C4`038R8R>CTi>CTi
009FEUH00gIfMYNGUiNGU`02][Jf00?AdM7UiNGUiND00_;blP03n?ShmoOgmoOg00;bl_800n_[jnCT
i>CTi002g=cL00?Fe]KBd];Bd]800];BdP03dm?CeMGEeMGE00;GemL00m[Jf]cLg=cLg002gMgM0mkN
gP;MgMd:g=cL0mgMg@;Ng]h5gmoO1N3Ph0oOgml3h>3P1=oOg`03gMgMg=cLg=cL00Coool00`000?oo
ooooo`0boooo00@0003oooooooooool2LG5a00=bLW9dM7AdM7@00WEeM@03MgMgN7QhN7Qh009jNWX6
Ng]k0WUiN@9hN7P00gIfMWAdM7AdM002M7Ad1G=cL`YbLW83Lg=c1gAdM09bLW800g1`L6i^KVi^KP02
KFe]00=_KfmaLG5aLG400W=cL`03LW9bKFe]KFe]009UIFD00eiNGV1PH61PH002K6a/00=nOWj>SXj>
SXh00YBDU003Rh^;MgMgMgMg009RHV800e9BDTa<C4a<C002Cdm?00=IFEUXJ6QXJ6P00WemO@03TY:B
XZ:RXZ:R00:TY:@00i:BTW=cLg=cL`02De=C0clo?`9?Cdl00f=SHg=cLg=cL`02MgMg00=aLG5ZJVYZ
JVX00VMWI`03Jf][MGEeMGEe009mOGd00h:2PX61PH61P@02Ng]k00=dM7A[Jf][Jf/00V9RHP03FUYJ
E5ADE5AD009DE5@00eYJFVATI6ATI002L71`00=hN7QlO7alO7`00W]kN`03MgMgLg=cLg=c009aLG40
0fm_Kfi^KVi^KP02KFe]0Va/K0=]KFd2KVi^1Vm_K`A^KVh3KFe]0fa/K0Y[Jf/9K6a/0f][J`9ZJVX0
0f][Jfa/K6a/K002KFe]00=^KVi`L71`L7001?ooo`030000oooooooo013oool002Goool00`000?oo
ooooo`02oooo0][JfP03emOGeMGEeMGE00;Cdm<00m3@d<o?clo?c`07cLg=00?>c/k?clo?cll00]3@
d003dM7Adm?Cdm?C00;De=@00mGEeMKFe]KFeP02emOG0mSHf0;IfMT3f=SH0]OGe`03e]KFeMGEeMGE
00;De=@00m?CdmCDe=CDe002eMGE0]KFeP03fMWIfm_Kfm_K00;Ng]h00n3Ph>;Rh^;RhP05hn?S0^7Q
h@03g]kNf][Jf][J00;EeMD00lg=cL?3`l?3``02][Jf00>VYZJDU9BDU9@00X20P003K6a/F5QHF5QH
0096ATH00cPh>2l_;bl_;`02;2`/00<^;Rhd=3@d=3@00S`l?003ADE5CDe=CDe=009BDU800e=CDde=
CDe=C@02@d=300<f=SHX:2PX:2P00Q/K6`034Q8B3Ph>3Ph>008C4a<00b0P83Hf=SHf=P02DE5A00=_
Kfn>SXj>SXh00Zb/[003a/K6fm_Kfm_K00;Xj>P00no_ko3`l?3`l002kNg]00?YjNWShn?Shn<00]gM
g@03f=SHeMGEeMGE00;De=@00mGEeMOGemOGe`02f=SH00?Jf][Kfm_Kfm/01mcLg0GKfm/3g=cL1=gM
g@?Ng]hIgmoO0n3Ph0COgml00mgMgMcLg=cLg004oooo00<0003oooooool0<_ooo`040000oooooooo
oooo0W5aL@03LW9bM7AdM7Ad009fMWH00gQhN7YjNWYjNP02Ng]k1GalO003Ng]kNWYjNWYj009iNGT0
0gMgMgIfMWIfMP02MGEe00=dM7AcLg=cLg<00W=cL`=bLW83LG5a0W9bLP9cLg<00gAdM7EeMGEeM@02
MGEe0gIfMP9eMGD2M7Ad00=aLG5^KVi^KVh00Va/K0=[Jf/3K6a/0VYZJP9WIfL00fEUIFUYJFUYJ@02
MGEe00>4Q8B?Shn?Shl00Xn?S`03OgmoIVIVIVIV009=CDd00c`l?3Xj>SXj>P02A4A400=EEEEXJ6QX
J6P00WYjNP03RHV9TY:BTY:B00:BTY800hJ6QW5aLG5aL@02G5aL00==CDe:BTY:BTX00U1@D003Fe]K
IfMWIfMW009aLG400gMgMg]kNg]kN`02NGUi00=cLg=XJ6QXJ6P00UiNGP03FEUIGEeMGEeM009WIfL0
0g9bLWMgMgMgM`02Lg=c00=XJ6QLG5aLG5`00UIFEP03FEUIHf=SHf=S009^KVh00gMgMgUiNGUiN@02
N7Qh00=eMGEbLW9bLW800W1`L0=_Kfl7KVi^1fm_K`=^KVh3KFe]2Fa/K0I[Jf/7K6a/1F][J`9ZJVX3
Jf][0Va/K003KVi^Kfm_Kfm_00Coool00`000?ooooooo`0@oooo000Uoooo0P0000?oool2f][J00?G
emOEeMGEeMD00]?Cd`03d=3@clo?clo?00O=cLd00lk>c/o?clo?c`02d=3@00?AdM7Cdm?Cdm<00]CD
e003eMGEe]KFe]KF00;GemL3f=SH0]WIf@?Hf=P2emOG00?Fe]KEeMGEeMD00]CDe003dm?Ce=CDe=CD
00;EeMD2e]KF00?IfMWKfm_Kfm/00]kNgP03h>3Ph^;Rh^;R00GShn<2hN7Q00?Ng]kJf][Jf]X00]GE
e@03cLg=`l?3`l?300:f][H00jJVYYBDU9BDU002P82000=/K6aHF5QHF5P00TI6AP03>3Ph;bl_;bl_
008/;2`00bh^;S@d=3@d=002?3`l00=5ADE=CDe=CDd00U9BDP03De=CCDe=CDe=0093@d<00cHf=RPX
:2PX:0026a/K00<B4Q8>3Ph>3Ph00Q<C4`03820P=SHf=SHf009ADE400fm_Khj>SXj>SP02[:b/00?6
a/KKfm_Kfm/00^SXj003kno_l?3`l?3`00;]kNd00nWYjN?Shn?Sh`02gMgM00?Hf=SEeMGEeMD00]CD
e003eMGEemOGemOG00;Hf=P00m[Jf]_Kfm_Kf`07g=cL1M_Kf`?Lg=`4gMgM0mkNgQWOgml3h>3P1=oO
g`03gMgMg=cLg=cL00?oool20000=?ooo`040000oooooooooooo0W5aL@03LW9bM7AdM7Ad009fMWH0
0gQhN7YjNWYjNP02Ng]k1GalO003Ng]kNWYjNWYj009iNGT00gMgMgIfMWIfMP02MGEe00=dM7AcLg=c
Lg<00W=cL`=bLW83LG5a0W9bLP9cLg<00gAdM7EeMGEeM@02MGEe0gIfMP9eMGD2M7Ad00=aLG5^KVi^
KVh00Va/K0=[Jf/3K6a/0VYZJP9WIfL00fEUIFUYJFUYJ@02MGEe00>4Q8B?Shn?Shl00Xn?S`03Ogmo
IVIVIVIV009=CDd00c`l?3Xj>SXj>P02A4A400=EEEEXJ6QXJ6P00WYjNP03RHV9TY:BTY:B00:BTY80
0hJ6QW5aLG5aL@02G5aL00==CDe:BTY:BTX00U1@D003Fe]KIfMWIfMW009aLG400gMgMg]kNg]kN`02
NGUi00=cLg=XJ6QXJ6P00UiNGP03FEUIGEeMGEeM009WIfL00g9bLWMgMgMgM`02Lg=c00=XJ6QLG5aL
G5`00UIFEP03FEUIHf=SHf=S009^KVh00gMgMgUiNGUiN@02N7Qh00=eMGEbLW9bLW800W1`L0=_Kfl7
KVi^1fm_K`=^KVh3KFe]2Fa/K0I[Jf/7K6a/1F][J`9ZJVX3Jf][0Va/K003KVi^Kfm_Kfm_00?oool2
00004_ooo`009Oooo`030000oooooooo00;oool2f][J00?Hf=SFe]KFe]H00]CDe003d];BdM7AdM7A
00;@d=03clo?0m3@d0;AdM42d];B00?Cdm?De=CDe=@00]GEe@03e]KFemOGemOG00;Hf=P00mWIfM[J
f][JfP03f][J0]WIf@;Hf=P00mKFe]CDe=CDe002dm?C0m;BdP;Cdm<2e]KF00?IfMWMgMgMgMd00^7Q
h@03iNGUinOWinOW00?Xj>P2iNGU0^3Ph003f][Jd];Bd];B00;8b<P00kjn_[:b/[:b/P02Y:BT00>E
UIF5QHF5QHD00WEeM@03IVIVEUIFEUIF0099BDT00clo?cTi>CTi>@02=cLg00<j>SXo?clo?cl00TI6
AP03CDe=De=CDe=C009GEeL00eIFETm?Cdm?C`02ADE500<h>3PZ:RXZ:RX00QdM7@0351@D410@410@
008C4a<00ahN7S4a<C4a<@02BDU900=TI6B1PH61PH400YbLW003]KFeb/[:b/[:00;Hf=P00n7QhNGU
iNGUi@02i^KV00?Ti>CRh^;Rh^800]kNgP03g=cLf][Jf][J00?IfMT@f][J0m_Kf`;Lg=`3gMgM5]kN
gPgOgml2g]kN00?MgMgLg=cLg=`01?ooo`030000oooooooo03;oool010000?ooooooooooo`9`L700
0g9bLWAdM7AdM002MWIf00=gMgMiNGUiNGT01gYjNP=iNGT2N7Qh00=gMgMfMWIfMWH00WEeM@03M7Ad
Lg=cLg=c009bLW800g5aLG1`L71`L003L71`0W5aL@9bLW800gAdM7IfMWIfMP02MgMg00=hN7QgMgMg
MgL00WIfMP9dM7@00g5aLFe]KFe]K@02JFUY00=VIVITI6ATI6@00V=SH`03I6ATIfMWIfMW009ZJVX0
0fm_KgIfMWIfMP02P82000>9RHV=SHf=SHd00XJ6QP03LG5aDe=CDe=C008h>3P00bPX:2/[:b/[:`02
?3`l00=DE5AZJVYZJVX00WQhN003OWinOgmoOgmo009lO7`00gIfMVm_Kfm_K`02IVIV00=NGUiHF5QH
F5P00eADE09LG5`2Jf][00=nOWj<S8b<S8`00Xf=S@03Ng]kG5aLG5aL008n?Sh00bl_;cPh>3Ph>002
DU9B00=`L724Q8B4Q8@00XJ6QP03NGUiJ6QXJ6QX009MGEd00eaLG6=SHf=SH`02K6a/00=cLg=eMGEe
MGD00W=cL`03L71`Kfm_Kfm_009^KVh00fm_Kg1`L71`L009L71`0fm_K`9^KVh5KFe]5fa/K0Y[Jf/2
K6a/00=]KFe^KVi^KVh01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0]_K
f`03f][Jf=SHf=SH00;GemL00mKFe]GEeMGEe@02e=CD1M?Cd`GDe=@00mGEeMKFe]KFeP02emOG00?H
f=SIfMWIfMT00][JfP?Lg=`2gMgM00?Lg=cKfm_Kfm/00]WIf@03emOGe=CDe=CD00;Bd]83dM7A0]?C
d`;Fe]H00m_Kfn3Ph>3Ph002iNGU00?Zj^[]kNg]kNd00^k^kP03k>c/inOWinOW00;Ogml00mCDe<S8
b<S8b002^[Zj00>][JfNWYjNWYh00Y2@T003PX:2MGEeMGEe009ZJVX00emOGeEEEEEEE@02C4a<00=6
ATI3@d=3@d<00T=3@`03ATI6BTY:BTY:009?Cdl00eEEEEUIFEUIF@02FUYJ00=HF5QADE5ADE400TI6
AP03>CTi:b/[:b/[008O7al00aHF5Q4A4A4A4@024Q8B00<K6a/[:b/[:b/00Slo?`03EeMGLG5aLG5a
00:9RHT00j6QXKFe]KFe]@02aLG500?@d=3GemOGemL00]cLg003gmoOh>3Ph>3P00GPh>03gmoO0]kN
gP;MgMd00mcLg=[Jf][JfP04fMWI00?Hf=SIfMWIfMT00]WIf@03f][Jg=cLg=cL00;MgMd;g]kN2]gM
g@ONg]h:gmoO0]kNgP03gMgMg=cLg=cL00Coool00`000?ooooooo`0boooo00@0003oooooooooool2
Kfm_00=`L71bLW9bLW800W=cL`03MGEeMWIfMWIf00MgMgL5MWIf0gEeM@9dM7@00g9bLW5aLG5aL@02
L71`00=_Kfm^KVi^KVh00fi^KP9`L702LG5a00=dM7AfMWIfMWH01GQhN09gMgL2M7Ad00=`L71/K6a/
K6`00VMWI`03HF5QG5aLG5aL009JFUX00eaLG6ATI6ATI002Kfm_00=kNg^5QHF5QHD00Xb<S003SXj>
RXZ:RXZ:009lO7`00f=SHdE5ADE5A@02:b/[00<O7alW9bLW9bL00Sdm?@03F5QHKVi^KVi^009fMWH0
0gAdM6e]KFe]K@03J6QX0Va/K09aLG400g1`L6MWIfMWI`02Fe]K00=BDU9DE5ADE5@00VMWI`03PX:2
V9RHV9RH00:KVi/00h61PEIFEUIFEP02;2`/00<F5QHQ8B4Q8B400TA4A003KFe]Rh^;Rh^;00:BTY80
0hN7QgIfMWIfMP02J6QX00=TI6AVIVIVIVH00VYZJP03KFe]KVi^KVi^009/K6`3Jf][0Ve]K@03Kfm_
L71`L71`009aLG43LW9b175aL@03L71`Kfm_Kfm_009^KVh00fe]KFa/K6a/K007K6a/3Fe]KA9/K6`2
KFe]1?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0]_Kf`03f][Jf=SHf=SH
00;GemL00mKFe]GEeMGEe@02e=CD1M?Cd`GDe=@00mGEeMKFe]KFeP02emOG00?Hf=SIfMWIfMT00][J
fP?Lg=`2gMgM00?Lg=cKfm_Kfm/00]WIf@03emOGe=CDe=CD00;Bd]83dM7A0]?Cd`;Fe]H00m_Kfn3P
h>3Ph002iNGU00?Zj^[]kNg]kNd00^k^kP03k>c/inOWinOW00;Ogml00mCDe<S8b<S8b002^[Zj00>]
[JfNWYjNWYh00Y2@T003PX:2MGEeMGEe009ZJVX00emOGeEEEEEEE@02C4a<00=6ATI3@d=3@d<00T=3
@`03ATI6BTY:BTY:009?Cdl00eEEEEUIFEUIF@02FUYJ00=HF5QADE5ADE400TI6AP03>CTi:b/[:b/[
008O7al00aHF5Q4A4A4A4@024Q8B00<K6a/[:b/[:b/00Slo?`03EeMGLG5aLG5a00:9RHT00j6QXKFe
]KFe]@02aLG500?@d=3GemOGemL00]cLg003gmoOh>3Ph>3P00GPh>03gmoO0]kNgP;MgMd00mcLg=[J
f][JfP04fMWI00?Hf=SIfMWIfMT00]WIf@03f][Jg=cLg=cL00;MgMd;g]kN2]gMg@ONg]h:gmoO0]kN
gP03gMgMg=cLg=cL00Coool00`000?ooooooo`0boooo00@0003oooooooooool2Kfm_00=`L71bLW9b
LW800W=cL`03MGEeMWIfMWIf00MgMgL5MWIf0gEeM@9dM7@00g9bLW5aLG5aL@02L71`00=_Kfm^KVi^
KVh00fi^KP9`L702LG5a00=dM7AfMWIfMWH01GQhN09gMgL2M7Ad00=`L71/K6a/K6`00VMWI`03HF5Q
G5aLG5aL009JFUX00eaLG6ATI6ATI002Kfm_00=kNg^5QHF5QHD00Xb<S003SXj>RXZ:RXZ:009lO7`0
0f=SHdE5ADE5A@02:b/[00<O7alW9bLW9bL00Sdm?@03F5QHKVi^KVi^009fMWH00gAdM6e]KFe]K@03
J6QX0Va/K09aLG400g1`L6MWIfMWI`02Fe]K00=BDU9DE5ADE5@00VMWI`03PX:2V9RHV9RH00:KVi/0
0h61PEIFEUIFEP02;2`/00<F5QHQ8B4Q8B400TA4A003KFe]Rh^;Rh^;00:BTY800hN7QgIfMWIfMP02
J6QX00=TI6AVIVIVIVH00VYZJP03KFe]KVi^KVi^009/K6`3Jf][0Ve]K@03Kfm_L71`L71`009aLG43
LW9b175aL@03L71`Kfm_Kfm_009^KVh00fe]KFa/K6a/K007K6a/3Fe]KA9/K6`2KFe]1?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0]cLg0?Kfm/2f][J0mWIf@GHf=P7emOG0mSH
f0;IfMT00m[Jf]_Kfm_Kf`02gMgM00?Ng]kOgmoOgml00moOg`;MgMd2fm_K00?Hf=SEeMGEeMD00];B
dP?@d=02d];B0]KFeP03g=cLhn?Shn?S00;YjNT00no_ko?clo?cl`02lo?c00?`l?3Xj>SXj>P00]gM
g@03c/k>_Kfm_Kfm00:/[:`00i^KVhZ:RXZ:RP02Ng]k00=_KfmUIFEUIFD00UeMG@03EeMGDe=CDe=C
009@D503CTi>0U1@D003DU9BEUIFEUIF009IFET00eaLG5iNGUiNGP02GEeM00=IFEUADE5ADE400TI6
AP03>SXj;Bd];Bd]008Q8B400aPH618B4Q8B4P024Q8B00<I6ATU9BDU9BD00SDe=@03BDU9GemOGemO
009eMGD00h^;RijNWYjNWP02[jn_00>m_Kg8b<S8b<P00]7Ad@03f=SHg]kNg]kN00;Rh^800nGUiNKV
i^KViP02i^KV00?UiNGShn?Shn<00^3Ph003gMgMf][Jf][J00;Hf=P5emOG0]SHf003f][Jg=cLg=cL
00;MgMd6gmoO1=kNgP03gMgMg=cLg=cL00OLg=`5gMgM3mkNgP?MgMd4oooo00<0003oooooool0<_oo
o`040000oooooooooooo0Vi^KP03Kfm_L71`L71`00=aLG44LW9b2g=cL`AbLW800g1`L6m_Kfm_K`02
KVi^00=]KFe/K6a/K6`00V][J`03K6a/KVi^KVi^009`L7000g=cLgIfMWIfMP02N7Qh00=iNGUhN7Qh
N7P00WMgM`9dM7@00g1`L6][Jf][J`02IFEU00=LG5aEEEEEEED00U5AD@03EEEEHf=SHf=S009fMWH0
0hR8R9FEUIFEU@02V9RH00>ATI64Q8B4Q8@00W1`L003F5QH@410@410008];Bd00bLW9c8b<S8b<P02
BDU900=RHV9dM7AdM7@00WIfMP03KFe]H61PH61P009IFET00eiNGV][Jf][J`02NGUi00=nOWieMGEe
MGD00VATI003EEEEDe=CDe=C009TI6@00h61PIVIVIVIV@02WYjN00>6QXIKFe]KFe/00S4a<@036QXJ
8b<S8b<S0093@d<00fUYJHN7QhN7Q`02Ti>C00>>SXj4Q8B4Q8@00WUiN@03LG5aKFe]KFe]009YJFT0
0fIVIVATI6ATI002I6AT00=VIVIYJFUYJFT00Va/K003KVi^L71`L71`009bLW85Lg=c0W9bLP03L71`
Kfm_Kfm_009]KFd00fa/K6][Jf][J`03Jf][0Va/K0=]KFd:KVi^1Fe]K@M/K6`3KFe]16a/K0=]KFd4
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2g=cL0m_Kf`;Jf]X3fMWI1MSH
f0OGemL3f=SH0]WIf@03f][Jfm_Kfm_K00;MgMd00mkNg]oOgmoOg`03gmoO0]gMg@;Kfm/00mSHf=GE
eMGEe@02d];B0m3@d0;Bd]82e]KF00?Lg=cShn?Shn<00^WYj@03kno_lo?clo?c00;clo<00o3`l>SX
j>SXj002gMgM00?>c/jm_Kfm_Kd00Zb/[003Vi^KRXZ:RXZ:009kNg/00fm_KfEUIFEUI@02GEeM00=G
EeMCDe=CDe<00U1@D0=>CTh2D51@00=BDU9FEUIFEUH00UUIF@03G5aLGUiNGUiN009MGEd00eUIFE5A
DE5AD@02ATI600<j>SX];Bd];Bd00R4Q8@0361PH4Q8B4Q8B008B4Q800aTI6BDU9BDU9@02=CDe00=9
BDUOGemOGel00WEeM@03Rh^;WYjNWYjN00:_[jl00kfm_LS8b<S8b002dM7A00?Hf=SNg]kNg]h00^;R
hP03iNGUi^KVi^KV00;Vi^H00nGUiN?Shn?Sh`02h>3P00?MgMgJf][Jf]X00]SHf0GGemL2f=SH00?J
f][Lg=cLg=`00]gMg@KOgml4g]kN00?MgMgLg=cLg=`01mcLg0GMgMd?g]kN0mgMg@Coool00`000?oo
ooooo`0boooo00@0003oooooooooool2KVi^00=_Kfm`L71`L7000g5aL@AbLW8;Lg=c179bLP03L71`
Kfm_Kfm_009^KVh00fe]KFa/K6a/K002Jf][00=/K6a^KVi^KVh00W1`L003Lg=cMWIfMWIf009hN7P0
0gUiNGQhN7QhN002MgMg0WAdM003L71`Jf][Jf][009UIFD00eaLG5EEEEEEE@02DE5A00=EEEESHf=S
Hf<00WIfMP03R8R8UIFEUIFE00:HV9P00i6ATHB4Q8B4Q002L71`00=HF5Q0@410@4000Rd];@039bLW
<S8b<S8b0099BDT00f9RHWAdM7AdM002MWIf00=]KFePH61PH6000UUIF@03GUiNJf][Jf][009iNGT0
0ginOWEeMGEeM@02I6AT00=EEEECDe=CDe<00VATI003PH61VIVIVIVI00:NWYh00hJ6QU]KFe]KF`02
<C4a00<J6QXS8b<S8b<00T=3@`03JFUYQhN7QhN700:CTi<00hj>SXB4Q8B4Q002NGUi00=aLG5]KFe]
KFd00VUYJ@03IVIVI6ATI6AT009TI6@00fIVIVUYJFUYJ@02K6a/00=^KVi`L71`L7000W9bLPEcLg<2
LW9b00=`L71_Kfm_Kfl00Ve]K@03K6a/Jf][Jf][00=[Jf/2K6a/0fe]K@Y^KVh5KFe]1fa/K0=]KFd4
K6a/0fe]K@Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`cMgMd5g=cL0m_K
f`?Jf]X4fm_K00?Lg=cNg]kNg]h00]oOg`03h>3Ph^;Rh^;R00;Rh^800n7QhMoOgmoOg`02g=cL00?I
fMWEeMGEeMD00];BdP03d=3@clo?clo?00;AdM42e]KF00?MgMgUiNGUiND00^g]k@03lo?cn?Shn?Sh
00;hn?P00oCdm>WYjNWYj@02f][J00?8b<Rc/k>c/k<00YjNWP03RHV9MgMgMgMg009WIfL00eaLG5IF
EUIFEP02DU9B0e5AD@9CDe<00eIFEUUIFEUIF@02G5aL00=NGUiQHF5QHF400V9RHP03Hf=SHV9RHV9R
009OGel00eYJFU5ADE5AD@02AdM700<k>c/_;bl_;bl00R<S8`036QXJ51@D51@D008C4a<00aLG5b0P
820P8002;2`/00<l?3a>CTi>CTh00V5QH@03M7AdQhN7QhN700:IVIT00jZZZ[Vi^KVi^@02a/K600?B
d];Lg=cLg=`00^CTi003jNWYk>c/k>c/00;/k>`00n[Zj^OWinOWi`02hn?S00?Ng]kJf][Jf]X00]OG
e`?EeMD2e]KF0]OGe`03f][Jg=cLg=cL00;Ng]h6h>3P0]oOg`;Ng]h00mgMgMcLg=cLg005fm_K1McL
g0OMgMd00mkNg]gMgMgMg@0:gMgM1?ooo`030000oooooooo03;oool010000?ooooooooooo`=]KFd<
KVi^0fm_K`M`L702Kfm_00=^KVi]KFe]KFd00Va/K003JVYZJFUYJFUY00=YJFT2Jf][0Vi^KP03LW9b
MGEeMGEe009hN7P3NGUi0WMgM`9dM7@00fm_KfYZJVYZJP02Hf=S00=HF5Q?Cdm?Cdl00TY:BP03Cdm?
HV9RHV9R009mOGd00iJFUZBTY:BTY002XZ:R00>BTY9lO7alO7`00VEUI@03DU9B@d=3@d=3008j>SX0
0c/k>dQ8B4Q8B002Fe]K00=`L71kNg]kNg/00WQhN003JFUYFEUIFEUI009ADE400eQHF6YZJVYZJP02
OGem00>6QXIoOgmoOgl00Vi^KP03GEeMEeMGEeMG009TI6@00galO9:BTY:BTP02VIVI00>8R8QYJFUY
JFT00TQ8B003=CDe=cLg=cLg009;Bd/00fATI7]kNg]kN`02RHV900>?Shn@T92@T9000X^;R`03PX:2
MGEeMGEe009XJ6P00eiNGUYJFUYJFP02Fe]K00=PH61VIVIVIVH00V][J`03KVi^L71`L71`009bLW82
M7Ad00=eMGEdM7AdM7@00W=cL`03LG5aKVi^KVi^009/K6`00f][JfYZJVYZJP02JVYZ00=[Jf]/K6a/
K6`00Ve]K@=^KVh7Kfm_0fi^KQA]KFd4oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo
00;oool3g]kN0]oOg`GPh>02hN7Q0n3Ph0?Ogml2g]kN1mgMg@03g]kNh>3Ph>3P00;QhN400n?ShnCT
i>CTi002i>CT00?Shn?QhN7QhN400]kNgP03f][Je]KFe]KF00;Bd]83clo?0]7Ad@;Fe]H00mkNg^OW
inOWi`02l?3`00?gmoOlo?clo?`00_clo003m_Kfj^[Zj^[Z00;Hf=P00l71`JVYZJVYZ@02T92@00=i
NGUUIFEUIFD00UEEE@03C4a<B4Q8B4Q80098B4P00da<C55ADE5AD@02EeMG00=MGEeSHf=SHf<00VMW
I`03JVYZJf][Jf][009ZJVX00fUYJFIVIVIVIP02HF5Q00=JFUYADE5ADE400TM7A`03?3`l<C4a<C4a
008V9RH00ahN7QPH61PH60025ADE00<G5aLL71`L71`00RDU9@03<C4a?clo?clo009?Cdl00f1PH7=c
Lg=cL`02QHF500>HV9RZZZZZZZX00[bl_003c<c<f][Jf][J00;UiND00ng]kO7alO7al@02l_;b00?`
l?3[jn_[jn/00^KViP03h>3Pf][Jf][J00;Fe]H3dm?C0]CDe0;GemL00mWIfMcLg=cLg002gmoO00?P
h>3QhN7QhN400^7Qh@03h>3PgmoOgmoO00;Ng]h00mcLg=_Kfm_Kf`02fm_K00?Jf][Kfm_Kfm/00m_K
f`CLg=`:gMgM1McLg0?MgMd4oooo00<0003oooooool0<_ooo`040000oooooooooooo0Ve]K@=/K6`2
Jf][1VYZJPA[Jf/00fa/K6e]KFe]K@02KFe]0fi^KP9]KFd00fa/K6][Jf][J`02JVYZ00=XJ6QWIfMW
IfL00VIVIP03IfMWJFUYJFUY009]KFd00g5aLGAdM7AdM002N7Qh0gUiN@9gMgL2Lg=c00=_KfmYJFUY
JFT00V5QH@03EEEEBTY:BTY:0094A4@00d];Bf=SHf=SH`02Ph>300>PX:2`/;2`/;000ZVYZ@03TY:B
MGEeMGEe009LG5`00de=CDU9BDU9B@02Bd];00=CDe=PH61PH6000W1`L003OGemPX:2PX:2009jNWX0
0fYZJUQHF5QHF002D51@00=GEeMYJFUYJFT00WemO@03R8R8Q8B4Q8B4009eMGD00fIVIUmOGemOG`02
IfMW00=hN7R9RHV9RHT00Y2@T003R8R8MWIfMWIf009SHf<00eEEEE1@D51@D002EEEE00=NGUi/K6a/
K6`00WemO@03SHf=VYZJVYZJ00:MWId00i:BTWinOWinOP02IfMW00=FEUI@D51@D5000UADE003Fe]K
I6ATI6AT009ZJVX00fi^KW1`L71`L002Lg=c0WEeM@03MWIfMGEeMGEe009dM7@00g5aLFi^KVi^KP02
K6a/00=ZJVYYJFUYJFT00VUYJ@03JVYZK6a/K6a/009]KFd00fi^KVm_Kfm_K`02Kfm_0g1`L0=_Kfl5
KVi^1Fe]K@Y^KVh2KFe]1?ooo`030000oooooooo013oool002Goool200000oooo`?Ng]h2gmoO1N3P
h0;QhN43h>3P0moOg`;Ng]h7gMgM00?Ng]kPh>3Ph>000^7Qh@03hn?Si>CTi>CT00;Ti>@00n?Shn7Q
hN7Qh@02g]kN00?Jf][Fe]KFe]H00];BdP??cll2dM7A0]KFeP03g]kNinOWinOW00;`l?000oOgmocl
o?clo002o?cl00?fm_KZj^[Zj^X00]SHf003`L71ZJVYZJVY00:@T9000gUiNFEUIFEUI@02EEEE00=<
C4a8B4Q8B4P00TQ8B003C4a<DE5ADE5A009GEeL00eeMGF=SHf=SH`02IfMW00=ZJVY[Jf][Jf/00VYZ
JP03JFUYIVIVIVIV009QHF400eYJFU5ADE5AD@02AdM700<l?3`a<C4a<C400RHV9P037QhN61PH61PH
008E5AD00aLG5a`L71`L70029BDU00<a<C4o?clo?cl00Tm?C`03H61PLg=cLg=c00:5QHD00iRHV:ZZ
ZZZZZP02_;bl00?<c<cJf][Jf]X00^GUi@03kNg]lO7alO7a00;bl_800o3`l>_[jn_[j`02i^KV00?P
h>3Jf][Jf]X00]KFeP?Cdm<2e=CD0]OGe`03fMWIg=cLg=cL00;Ogml00n3Ph>7QhN7Qh@02hN7Q00?P
h>3OgmoOgml00]kNgP03g=cLfm_Kfm_K00;Kfm/00m[Jf]_Kfm_Kf`03fm_K1=cLg0[MgMd5g=cL0mgM
g@?oool20000=?ooo`040000oooooooooooo0Ve]K@=/K6`2Jf][1VYZJPA[Jf/00fa/K6e]KFe]K@02
KFe]0fi^KP9]KFd00fa/K6][Jf][J`02JVYZ00=XJ6QWIfMWIfL00VIVIP03IfMWJFUYJFUY009]KFd0
0g5aLGAdM7AdM002N7Qh0gUiN@9gMgL2Lg=c00=_KfmYJFUYJFT00V5QH@03EEEEBTY:BTY:0094A4@0
0d];Bf=SHf=SH`02Ph>300>PX:2`/;2`/;000ZVYZ@03TY:BMGEeMGEe009LG5`00de=CDU9BDU9B@02
Bd];00=CDe=PH61PH6000W1`L003OGemPX:2PX:2009jNWX00fYZJUQHF5QHF002D51@00=GEeMYJFUY
JFT00WemO@03R8R8Q8B4Q8B4009eMGD00fIVIUmOGemOG`02IfMW00=hN7R9RHV9RHT00Y2@T003R8R8
MWIfMWIf009SHf<00eEEEE1@D51@D002EEEE00=NGUi/K6a/K6`00WemO@03SHf=VYZJVYZJ00:MWId0
0i:BTWinOWinOP02IfMW00=FEUI@D51@D5000UADE003Fe]KI6ATI6AT009ZJVX00fi^KW1`L71`L002
Lg=c0WEeM@03MWIfMGEeMGEe009dM7@00g5aLFi^KVi^KP02K6a/00=ZJVYYJFUYJFT00VUYJ@03JVYZ
K6a/K6a/009]KFd00fi^KVm_Kfm_K`02Kfm_0g1`L0=_Kfl5KVi^1Fe]K@Y^KVh2KFe]0oooo`80000B
oooo000Uoooo00<0003oooooool00_ooo`;Ng]h00moOgn3Ph>3Ph002hN7Q00?Rh^;Shn?Shn<01N?S
h`;Rh^800n7QhN3Ph>3Ph002gmoO0mkNgP;Ogml00n3Ph>7QhN7Qh@02h^;R00?Ti>CVi^KVi^H00^KV
iP03iNGUhn?Shn?S00;Ogml00m_KfmKFe]KFeP02d];B00??clo>c/k>c/h00]7Ad@;Fe]H00moOgnSX
j>SXj002l_;b00?jn_[no_kno_h00_knoP03moOgjNWYjNWY00;De=@00kbl_:2PX:2PX002QHF500=[
Jf]FEUIFEUH00TI6AP03?Shn?Cdm?Cdm0091@D400dQ8B59BDU9BDP02G5aL00=UIFE]KFe]KFd00W9b
LP=dM7@2LW9b00=^KViYJFUYJFT00V9RHP03FUYJDE5ADE5A0097AdL00cdm?C<c<c<c<`02:RXZ00<R
8R8L71`L71`00QTI6@0361PH6a/K6a/K008Q8B400bTY:C@d=3@d=002@D5100=@D51RHV9RHV800WEe
M@03RXZ:WYjNWYjN00:c/k<00lO7amSHf=SHf002i^KV00?`l?3fm_Kfm_H00_KfmP03m?Cdk^k^k^k^
00;Xj>P00n3Ph=[Jf][JfP02eMGE0m;BdP;Cdm<2e]KF00?IfMWLg=cLg=`00]oOg`03hN7Qh^;Rh^;R
00;Rh^800n7QhMoOgmoOg`02g]kN00?Lg=cKfm_Kfm/01M[JfP?Kfm/5g=cL1=gMg@_Lg=`2gMgM1?oo
o`030000oooooooo03;oool010000?ooooooooooo`9/K6`00f][JfYZJVYZJP02JFUY0fQXJ0=WIfL2
J6QX0fUYJ@9ZJVX2Jf][1Fa/K003Jf][JVYZJVYZ009XJ6P00fMWIfEUIFEUI@02IFEU00=VIVIXJ6QX
J6P00Va/K003L71`M7AdM7Ad009gMgL3NGUi0WMgM`9cLg<00fi^KVQXJ6QXJ002GemO00=CDe=8B4Q8
B4P00T=3@`03Bd];I6ATI6AT00:6QXH00jFUYKBd];Bd]002ZZZZ00>?Shm_Kfm_Kfl00UEEE@03BTY:
CDe=CDe=009FEUH00f=SHg5aLG5aL@02OGem00>6QXJ8R8R8R8P00WmoO`03Kfm_GemOGemO009FEUH0
0eYJFVMWIfMWI`02MgMg00>1PH60P820P8000WIfMP03K6a/IfMWIfMW009/K6`00gIfMX20P820P002
QXJ600>4Q8AlO7alO7`00W=cL`03JFUYH61PH61P009JFUX00eQHF61PH61PH002Lg=c00>;Rh^QXJ6Q
XJ400ZVYZ@03WIfMQ8B4Q8B4009WIfL00e5ADDU9BDU9B@02CTi>00=HF5QRHV9RHV800VUYJ@03KFe]
L71`L71`009cLg<2MWIf0gMgM`9eMGD00g9bLVi^KVi^KP02Jf][00=YJFUXJ6QXJ6P00VUYJ@03JVYZ
Jf][Jf][009]KFd00fi^KVm_Kfm_K`07L71`0fm_Ka9^KVh2KFe]1?ooo`030000oooooooo013oool0
02Goool00`000?ooooooo`02oooo0]kNgP03gmoOh>3Ph>3P00;QhN400n;Rh^?Shn?Sh`05hn?S0^;R
hP03hN7Qh>3Ph>3P00;Ogml3g]kN0]oOg`03h>3PhN7QhN7Q00;Rh^800nCTi>KVi^KViP02i^KV00?U
iNGShn?Shn<00]oOg`03fm_Ke]KFe]KF00;Bd]800lo?clk>c/k>cP02dM7A0]KFeP03gmoOj>SXj>SX
00;bl_800o[jn_kno_knoP02o_kn00?gmoOYjNWYjNT00]CDe003_;blX:2PX:2P00:5QHD00f][JeIF
EUIFEP02ATI600<n?Shm?Cdm?Cd00T51@@03B4Q8DU9BDU9B009LG5`00fEUIFe]KFe]K@02LW9b0gAd
M09bLW800fi^KVUYJFUYJ@02HV9R00=JFUYADE5ADE400TM7A`03?Cdm<c<c<c<c008Z:RX00b8R8Q`L
71`L70026ATI00<H61PK6a/K6a/00R4Q8@03:BTY=3@d=3@d0091@D400e1@D69RHV9RHP02MGEe00>:
RXZNWYjNWYh00[>c/`03alO7f=SHf=SH00;Vi^H00o3`l?Kfm_KfmP02m_Kf00?dm?C^k^k^k^h00^SX
j003h>3Pf][Jf][J00;EeMD3d];B0]?Cd`;Fe]H00mWIfMcLg=cLg002gmoO00?QhN7Rh^;Rh^800^;R
hP03hN7QgmoOgmoO00;Ng]h00mcLg=_Kfm_Kf`05f][J0m_Kf`GLg=`4gMgM2mcLg0;MgMd4oooo00<0
003oooooool0<_ooo`040000oooooooooooo0Va/K003Jf][JVYZJVYZ009YJFT3J6QX0fMWI`9XJ6P3
JFUY0VYZJP9[Jf/5K6a/00=[Jf]ZJVYZJVX00VQXJ003IfMWIFEUIFEU009UIFD00fIVIVQXJ6QXJ002
K6a/00=`L71dM7AdM7@00WMgM`=iNGT2MgMg0W=cL`03KVi^J6QXJ6QX009OGel00e=CDdQ8B4Q8B002
@d=300=;Bd]TI6ATI6@00XJ6QP03YJFU];Bd];Bd00:ZZZX00hn?Sfm_Kfm_K`02EEEE00=:BTY=CDe=
CDd00UIFEP03Hf=SLG5aLG5a009mOGd00hJ6QXR8R8R8R002Ogmo00=_KfmOGemOGel00UIFEP03FUYJ
IfMWIfMW009gMgL00h61PH20P820P002MWIf00=/K6aWIfMWIfL00Va/K003MWIfP820P82000:6QXH0
0hB4Q7alO7alO002Lg=c00=YJFUPH61PH6000UYJFP03F5QHH61PH61P009cLg<00h^;Rj6QXJ6QX@02
ZJVY00>MWIf4Q8B4Q8@00VMWI`03DE5ABDU9BDU9009>CTh00eQHF69RHV9RHP02JFUY00=]KFe`L71`
L7000W=cL`9fMWH3MgMg0WEeM@03LW9bKVi^KVi^009[Jf/00fUYJFQXJ6QXJ002JFUY00=ZJVY[Jf][
Jf/00Ve]K@03KVi^Kfm_Kfm_00M`L703Kfm_4Vi^KP9]KFd4oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool2g]kN00?OgmoQhN7QhN400^;RhP03hn?Si>CTi>CT00?UiND2i>CT0^?S
h`03h^;RhN7QhN7Q00;Ph>05gmoO00?Ph>3QhN7QhN400^?Sh`03iNGUi^KVi^KV00;WinL00nKVi^?S
hn?Sh`02h>3P00?Kfm_GemOGemL00];BdP03clo?c/k>c/k>00;AdM42e]KF00?OgmoYjNWYjNT00_?c
l`03no_koooooooo00;oool00oOgmnSXj>SXj002dM7A00>f][JIVIVIVIT00WalO003HF5QBd];Bd];
008k>c/00c@d=3De=CDe=@02?3`l00=7AdMDE5ADE5@00V5QH@03KFe]MWIfMWIf009lO7`00ginOWal
O7alO002N7Qh00=bLW9[Jf][Jf/00V=SH`03FUYJDE5ADE5A0098B4P00clo?cLg=cLg=`02;bl_00<X
:2PS8b<S8b<00QlO7`<M7Ad2820P00<V9RH];Bd];Bd00SPh>003ADE5EUIFEUIF009ZJVX00gmoOiJF
UYJFUP02[Jf]00?3`l?GemOGemL00^OWi`03l_;bnOWinOWi00;inOT00oOgmo7alO7al@02jNWY00?Q
hN7IfMWIfMT00]CDe0;AdM400m3@d=;Bd];BdP02eMGE00?IfMWLg=cLg=`00^3Ph003h^;Rhn?Shn?S
00;Rh^800n7QhN3Ph>3Ph002g]kN00?Lg=cKfm_Kfm/01m[JfP03fm_Kg=cLg=cL00cLg=`3fm_K0mcL
g0;MgMd4oooo00<0003oooooool0<_ooo`040000oooooooooooo0Va/K003Jf][JVYZJVYZ009YJFT3
IfMW0fIVIPAWIfL00fQXJ6YZJVYZJP07Jf][00=ZJVYYJFUYJFT00VQXJ003IVIVIFEUIFEU009TI6@0
0fEUIFMWIfMWI`02Jf][00=_KfmcLg=cLg<00WMgM`=jNWX2N7Qh0W=cL`03KFe]IVIVIVIV009MGEd0
0e9BDTU9BDU9B@02ADE500=>CTiVIVIVIVH00XJ6QP03XZ:R/;2`/;2`00:UYJD00hZ:RV][Jf][J`02
DU9B00=8B4Q;Bd];Bd/00UEEE@03Hf=SLG5aLG5a009nOWh00hV9RHf=SHf=S@02QhN700=lO7a^KVi^
KVh00V=SH`03HF5QI6ATI6AT009[Jf/00g1`L75aLG5aL@02L71`0fm_K`9cLg<00gQhN7alO7alO002
OGem00=jNWYeMGEeMGD00Vm_K`03IfMWGUiNGUiN009FEUH00e=CDeYJFUYJFP02Kfm_00>;Rh^TY:BT
Y:@00Zj^[P03XZ:RQXJ6QXJ6009WIfL00di>CTI6ATI6AP02BTY:00=EEEEPH61PH6000VQXJ003KFe]
LG5aLG5a009dM7@2MgMg00=hN7QgMgMgMgL00WEeM@03LW9bKVi^KVi^009[Jf/00fUYJFQXJ6QXJ002
J6QX00=YJFU[Jf][Jf/00Ve]K@03KVi^Kfm_Kfm_00M`L703Kfm_36i^KPE_Kfl00fi^KVe]KFe]K@04
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2g]kN00?OgmoPh>3Ph>000^;R
hP03hn?Si>CTi>CT00GTi>@2hn?S00?Rh^;QhN7QhN400^3Ph0GOgml00n3Ph>7QhN7Qh@02hn?S00?U
iNGVi^KVi^H00^OWi`03i^KVi>CTi>CT00;Ph>000mcLg=OGemOGe`02d];B00??clo>c/k>c/h00]7A
d@;Fe]H00moOgnWYjNWYj@02lo?c00?kno_oooooool00_knoP03m_KfiNGUiNGU00;>c/h00k:b/YBD
U9BDU002MGEe00=JFUY3@d=3@d<00SDe=@03;bl_<C4a<C4a008j>SX00dM7AeMGEeMGE`02IVIV00=d
M7AnOWinOWh00XB4Q003QHF5Ph>3Ph>3009mOGd00gIfMVe]KFe]K@02I6AT00=KFe]BDU9BDU800TY:
BP03@T92>c/k>c/k008e=CD00bl_;bXZ:RXZ:P029RHV00<T92@S8b<S8b<00R<S8`039RHV;2`/;2`/
008d=3@00d10@51@D51@D002Hf=S00=iNGVATI6ATI400ZVYZ@03`<30e]KFe]KF00;WinL00oCdm?[j
n_[jnP02no_k00?hn?Sbl_;bl_800^WYj@03hN7QfMWIfMWI00;Cdm<3d=3@0];BdP;EeMD00mWIfMcL
g=cLg002h>3P00?Rh^;Shn?Shn<00^?Sh`03h^;Rh>3Ph>3P00;Ng]h00mcLg=_Kfm_Kf`07f][J00?K
fm_Lg=cLg=`03=cLg0GKfm/00mcLg=gMgMgMg@04oooo00<0003oooooool0<_ooo`040000oooooooo
oooo0Ve]K@03Jf][JVYZJVYZ009YJFT00fQXJ6MWIfMWI`03IVIV0VMWI`9XJ6P00fUYJFYZJVYZJP03
Jf][0Va/K09[Jf/00fYZJVUYJFUYJ@02J6QX00=VIVIUIFEUIFD00VATI003IFEUIfMWIfMW009[Jf/0
0fm_Kg=cLg=cL`02MgMg00=jNWYkNg]kNg/00WQhN09cLg<00fa/K6ATI6ATI002Fe]K00=BDU9<C4a<
C4`00T];B`03E5ADJ6QXJ6QX00:3Ph<00i^KVjFUYJFUY@02W9bL00>4Q8AXJ6QXJ6P00U5AD@03ATI6
AdM7AdM7009=CDd00eUIFFQXJ6QXJ002MgMg00>5QHF>SXj>SXh00Xn?S`03RXZ:PH61PH61009eMGD0
0f][Jf9RHV9RHP02G5aL00=JFUYNGUiNGUh00VEUI@03KVi^MWIfMWIf009kNg/00gemOG]kNg]kN`02
MWIf00=^KViVIVIVIVH00UiNGP03EUIFCdm?Cdm?009;Bd/00de=CEQHF5QHF002Kfm_00>;Rh^SXj>S
Xj<00Zf][@03XJ6QQXJ6QXJ6009VIVH00di>CTI6ATI6AP02BTY:00=DE5AOGemOGel00VMWI`03KFe]
LG5aLG5a009eMGD2N7Qh00=iNGUhN7QhN7P00WIfMP03LW9bKVi^KVi^009[Jf/00fQXJ6MWIfMWI`02
J6QX00=YJFU[Jf][Jf/00Va/K003KVi^Kfm_Kfm_00M`L703Kfm_2Vi^KPM_Kfl3KVi^1?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0]kNgP03gmoOh>3Ph>3P00;Rh^800n?ShnCT
i>CTi005i>CT0^?Sh`03h^;RhN7QhN7Q00;Ph>05gmoO00?Ph>3QhN7QhN400^?Sh`03iNGUi^KVi^KV
00;WinL00nKVi^CTi>CTi002h>3P00?Lg=cGemOGemL00];BdP03clo?c/k>c/k>00;AdM42e]KF00?O
gmoYjNWYjNT00_?cl`03no_koooooooo00;no_h00oKfm^GUiNGUi@02c/k>00>b/[:DU9BDU9@00WEe
M@03FUYJ@d=3@d=3008e=CD00bl_;c4a<C4a<@02>SXj00=7AdMGEeMGEeL00VIVIP03M7AdOWinOWin
00:4Q8@00hF5QH>3Ph>3P`02OGem00=fMWI]KFe]KFd00VATI003Fe]KDU9BDU9B009:BTX00d92@S/k
>c/k>`02=CDe00<_;blZ:RXZ:RX00RHV9P0392@T8b<S8b<S008S8b<00bHV9R`/;2`/;002=3@d00=0
@41@D51@D5000V=SH`03NGUiTI6ATI6A00:YZJT00l30`=KFe]KFeP02inOW00?dm?Cjn_[jn_X00__k
n`03n?Shl_;bl_;b00;YjNT00n7QhMWIfMWIf@02dm?C0m3@d0;Bd]82eMGE00?IfMWLg=cLg=`00^3P
h003h^;Rhn?Shn?S00;Shn<00n;Rh^3Ph>3Ph002g]kN00?Lg=cKfm_Kfm/01m[JfP03fm_Kg=cLg=cL
00cLg=`5fm_K00?Lg=cMgMgMgMd01?ooo`030000oooooooo03;oool010000?ooooooooooo`9]KFd0
0f][JfYZJVYZJP02JFUY00=XJ6QWIfMWIfL00fIVIP9WIfL2J6QX00=YJFUZJVYZJVX00f][J`9/K6`2
Jf][00=ZJVYYJFUYJFT00VQXJ003IVIVIFEUIFEU009TI6@00fEUIFMWIfMWI`02Jf][00=_KfmcLg=c
Lg<00WMgM`03NWYjNg]kNg]k009hN7P2Lg=c00=/K6aTI6ATI6@00U]KF`03DU9BC4a<C4a<009;Bd/0
0eADE6QXJ6QXJ002Ph>300>KVi^UYJFUYJD00YbLW003Q8B4J6QXJ6QX009ADE400dI6ATM7AdM7A`02
CDe=00=IFEUXJ6QXJ6P00WMgM`03QHF5SXj>SXj>00:?Shl00hZ:RX61PH61P@02MGEe00=[Jf]RHV9R
HV800UaLG003FUYJGUiNGUiN009UIFD00fi^KWIfMWIfMP02Ng]k00=mOGekNg]kNg/00WIfMP03KVi^
IVIVIVIV009NGUh00eIFETm?Cdm?C`02Bd];00==CDeHF5QHF5P00Vm_K`03Rh^;Xj>SXj>S00:][Jd0
0j6QXHJ6QXJ6QP02IVIV00=>CTi6ATI6ATH00TY:BP03E5ADGemOGemO009WIfL00fe]KG5aLG5aL@02
MGEe0WQhN003NGUiN7QhN7Qh009fMWH00g9bLVi^KVi^KP02Jf][00=XJ6QWIfMWIfL00VQXJ003JFUY
Jf][Jf][009/K6`00fi^KVm_Kfm_K`07L71`0fm_K`Y^KVh7Kfm_0fi^KPCoool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`;MgMd00moOgn3Ph>3Ph002hN7Q00?Rh^;Shn?Shn<01N?S
h`;Rh^800n7QhN3Ph>3Ph002gmoO1MkNgP03gmoOhN7QhN7Q00;Rh^800nCTi>KVi^KViP02i^KV00?U
iNGShn?Shn<00^3Ph003fm_KemOGemOG00;Cdm<00lo?clk>c/k>cP02dM7A0]KFeP03gmoOj>SXj>SX
00;bl_800oWinOgmoOgmo@02o?cl00?clo?Rh^;Rh^800/_;b`03[Zj^T92@T92@009aLG400eIFET10
@410@002<C4a00<];Bda<C4a<C400S/k>`03BTY:Fe]KFe]K009[Jf/00gYjNXF5QHF5Q@03Rh^;0XR8
R0:1PH400gQhN6m_Kfm_K`02IFEU00=KFe]CDe=CDe<00T];B`03ADE5@410@410008k>c/00cHf=S8b
<S8b<P02;bl_00</;2`Z:RXZ:RX00RTY:@03:RXZ;Rh^;Rh^008e=CD00clo?di>CTi>CP02HF5Q00=g
MgN>SXj>SXh00ZNWY`03_knoeMGEeMGE00;WinL00oCdm?_kno_kn`02o?cl00?hn?Sbl_;bl_800^WY
j@03hN7Qf=SHf=SH00;Bd]83clo?0]7Ad@;EeMD00mSHf=cLg=cLg002h>3P00?Rh^;Shn?Shn<00^?S
h`03h^;Rh>3Ph>3P00;Ng]h00mgMgM_Kfm_Kf`07f][J00?Kfm_Lg=cLg=`00mcLg0CMgMd5g=cL1M_K
f`?Lg=`4oooo00<0003oooooool0<_ooo`040000oooooooooooo0Ve]K@03K6a/Jf][Jf][009ZJVX0
0fUYJFQXJ6QXJ005J6QX0VUYJ@03JVYZJf][Jf][00M/K6`00f][JfYZJVYZJP02J6QX00=WIfMUIFEU
IFD00VEUI@03IVIVJ6QXJ6QX009[Jf/00fm_Kg=cLg=cL`02MgMg00=jNWYkNg]kNg/00WUiN@9cLg<0
0f][Jf9RHV9RHP02FUYJ00=CDe=@D51@D5000U9BDP03FUYJK6a/K6a/00:0P8000i:BTYVIVIVIV@02
T92@00=mOGeUIFEUIFD00U9BDP03AdM7ADE5ADE5009:BTX00e=CDf1PH61PH002Kfm_00=mOGf:RXZ:
RXX00Y:BTP03UYJFTi>CTi>C00:9RHT00gMgMf5QHF5QH@02CTi>00=5ADE:BTY:BTX00UYJFP03KFe]
O7alO7al00:4Q8@00h:2PWalO7alO002LG5a00=UIFEHF5QHF5P00Te=C@03A4A4@410@4100091@D40
0dQ8B5QHF5QHF002L71`00>;Rh^QXJ6QXJ400ZVYZ@03WYjNQ8B4Q8B4009WIfL00e1@D4M7AdM7A`02
BTY:00=DE5ANGUiNGUh00VMWI`03KFe]LW9bLW9b009fMWH2N7Qh00=jNWYhN7QhN7P00WIfMP03LW9b
KVi^KVi^009[Jf/00fQXJ6MWIfMWI`02J6QX00=YJFU[Jf][Jf/00Va/K003KVi^Kfm_Kfm_00M`L703
Kfm_2Vi^KPM_Kfl3KVi^1?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0]gM
g@03gmoOh>3Ph>3P00;QhN400n;Rh^?Shn?Sh`05hn?S0^;RhP03hN7Qh>3Ph>3P00;Ogml5g]kN00?O
gmoQhN7QhN400^;RhP03i>CTi^KVi^KV00;Vi^H00nGUiN?Shn?Sh`02h>3P00?Kfm_GemOGemL00]?C
d`03clo?c/k>c/k>00;AdM42e]KF00?OgmoXj>SXj>P00_;blP03nOWioOgmoOgm00;lo?`00o?cln;R
h^;RhP02bl_;00>^[Zj@T92@T9000W5aL@03EUIF@410@410008a<C400bd];C4a<C4a<@02>c/k00=:
BTYKFe]KFe/00V][J`03NWYjQHF5QHF500>;Rh/2R8R80X61P@03N7QhKfm_Kfm_009UIFD00e]KFe=C
De=CD`02Bd];00=5ADE0@410@4000S/k>`03=SHf<S8b<S8b008_;bl00b`/;2XZ:RXZ:P02:BTY00<Z
:RX^;Rh^;Rh00SDe=@03?cloCTi>CTi>009QHF400gMgMhj>SXj>SP02YjNW00>o_koEeMGEeMD00^OW
i`03m?Cdno_kno_k00;lo?`00oShn?;bl_;blP02jNWY00?QhN7Hf=SHf=P00];BdP??cll2dM7A0]GE
e@03f=SHg=cLg=cL00;Ph>000n;Rh^?Shn?Sh`02hn?S00?Rh^;Ph>3Ph>000]kNgP03gMgMfm_Kfm_K
00OJf]X00m_KfmcLg=cLg003g=cL1=gMg@GLg=`5fm_K0mcLg0Coool00`000?ooooooo`0boooo00@0
003oooooooooool2KFe]00=/K6a[Jf][Jf/00VYZJP03JFUYJ6QXJ6QX00EXJ6P2JFUY00=ZJVY[Jf][
Jf/01fa/K003Jf][JVYZJVYZ009XJ6P00fMWIfEUIFEUI@02IFEU00=VIVIXJ6QXJ6P00V][J`03Kfm_
Lg=cLg=c009gMgL00gYjNW]kNg]kN`02NGUi0W=cL`03Jf][HV9RHV9R009JFUX00e=CDe1@D51@D002
DU9B00=JFUY/K6a/K6`00X20P003TY:BVIVIVIVI00:@T9000gemOFEUIFEUI@02DU9B00=7AdM5ADE5
ADD00TY:BP03De=CH61PH61P009_Kfl00gemOHZ:RXZ:RP02TY:B00>FUYJCTi>CTi<00XV9R@03MgMg
HF5QHF5Q009>CTh00dE5ADY:BTY:BP02FUYJ00=]KFelO7alO7`00XB4Q003PX:2O7alO7al009aLG40
0fEUIEQHF5QHF002CDe=00=4A4A0@410@4000T51@@03B4Q8F5QHF5QH009`L7000h^;Rj6QXJ6QX@02
ZJVY00>NWYj4Q8B4Q8@00VMWI`03D51@AdM7AdM7009:BTX00eADE5iNGUiNGP02IfMW00=]KFebLW9b
LW800WIfMP9hN7P00gYjNWQhN7QhN002MWIf00=bLW9^KVi^KVh00V][J`03J6QXIfMWIfMW009XJ6P0
0fUYJF][Jf][J`02K6a/00=^KVi_Kfm_Kfl01g1`L0=_Kfl:KVi^1fm_K`=^KVh4oooo00<0003ooooo
ool04?ooo`009Oooo`030000oooooooo00;oool2gMgM00?Ng]kOgmoOgml00]oOg`03h>3PhN7QhN7Q
00GQhN42h>3P00?OgmoNg]kNg]h00]kNgP?MgMd3g]kN0^3Ph0;QhN400n?ShnCTi>CTi002iNGU00?T
i>CRh^;Rh^800]oOg`03fm_KemOGemOG00;Cdm<00m3@d<o?clo?c`02dM7A0]OGe`03g]kNinOWinOW
00;`l?000oOgmo_kno_kn`02nOWi00?`l?3OgmoOgml00/O7a`03Zj^[SHf=SHf=009_Kfl00eADE3lo
?clo?`02<C4a00<];Bdb<S8b<S800Shn?P03CDe=GemOGemO009`L7000gmoOh^;Rh^;R`03T92@0X^;
R`:4Q8@00gYjNW1`L71`L002IVIV00=LG5aDE5ADE5@00Te=C@03B4Q8A4A4A4A40091@D400cdm?CXj
>SXj>P02=cLg00<d=3@b<S8b<S800S0`<003<C4a<c<c<c<c008i>CT00d92@Tm?Cdm?C`02HF5Q00=g
MgN>SXj>SXh00ZNWY`03_knoeMGEeMGE00;WinL00o?clo[jn_[jnP02no_k00?hn?SalO7alO400^WY
j@03h>3Pf=SHf=SH00;Bd]83clo?0]7Ad@;De=@00mSHf=cLg=cLg002h>3P00?Rh^;Shn?Shn<00^?S
h`03h^;Rh>3Ph>3P00;Ng]h00mgMgM_Kfm_Kf`05f][J0m_Kf`CLg=`6gMgM1McLg0;Kfm/5g=cL1?oo
o`030000oooooooo03;oool010000?ooooooooooo`=]KFd2K6a/0V][J`QZJVX3Jf][0Va/K0M]KFd0
0fa/K6][Jf][J`02JFUY00=XJ6QVIVIVIVH00VIVIP03IfMWJ6QXJ6QX009[Jf/00fm_Kg=cLg=cL`02
MgMg00=jNWYlO7alO7`00WUiN@9cLg<00fYZJV5QHF5QH@02FUYJ0eEEE@9HF5P00f1PH6m_Kfm_K`02
Ogmo00>=SHfATI6ATI400XN7Q`03MGEeH61PH61P009@D5000dY:BTi>CTi>CP02EUIF00=PH61YJFUY
JFT00Vm_K`03MgMgP820P82000:=SHd00iVIVInOWinOW`02VIVI00>2PX9SHf=SHf<00TI6AP03=cLg
?Cdm?Cdm009CDe<00fe]KH>3Ph>3P`02S8b<00>9RHV0P820P8000W=cL`03I6ATEUIFEUIF009:BTX0
0d10@3`l?3`l?002?Cdm00=5ADEEEEEEEED00Ve]K@03R8R8WYjNWYjN00:WYjL00ibLW8>3Ph>3P`02
IfMW00=ADE58B4Q8B4P00T];B`03E5ADGemOGemO009WIfL00fe]KG9bLW9bLP02MWIf0WUiN@03NWYj
NGUiNGUi009fMWH00g9bLVi^KVi^KP02Jf][00=XJ6QWIfMWIfL00VQXJ003JFUYJf][Jf][009/K6`0
0fi^KVm_Kfm_K`05L71`0fm_K`E^KVh2KFe]1fi^KPE_Kfl3KVi^1?ooo`030000oooooooo013oool0
02Goool200000oooo`?MgMd4g]kN2=oOg`?Ng]h2gMgM1McLg0;MgMd00mkNg]oOgmoOg`02h>3P00?R
h^;Shn?Shn<00^CTi003hn?ShN7QhN7Q00;Ng]h00m_KfmOGemOGe`02dm?C0m3@d0;Bd]82emOG00?N
g]kVi^KVi^H00^k^kP03mOGen?Shn?Sh00;fm_H00ng]kMcLg=cLg002aLG500>YZJV<S8b<S8`00Vm_
K`03EEEE@410@410008d=3@00c0`<3Hf=SHf=P02@D5100=ADE5SHf=SHf<00WEeM@03Q8B4Shn?Shn?
00:DU9@00i>CThj>SXj>SP02QXJ600=lO7aaLG5aLG400VIVIP03GEeMEEEEEEEE009@D5000da<C4U9
BDU9B@02ATI600=4A4A2@T92@T800Slo?`03?Cdm>SXj>SXj00<h>3P2>CTi0Shn?P03ATI6De=CDe=C
009TI6@00gUiNI2@T92@T002Z:RX00>o_koDe=CDe=@00^KViP03lo?cnOWinOWi00;jn_X00oOgmo3`
l?3`l002j>SX00?OgmoGemOGemL00];BdP??cll2dM7A0]CDe003f=SHg=cLg=cL00;Ph>000n;Rh^?S
hn?Sh`02hn?S00?Rh^;Ph>3Ph>000]kNgP03gMgMfm_Kfm_K00;Kfm/3f][J0]_Kf`?Lg=`:gMgM2]cL
g0?oool20000=?ooo`040000oooooooooooo0Vi^KP=]KFd5K6a/0f][J`A/K6`3KFe]1fi^KP03KFe]
K6a/K6a/009ZJVX00fUYJFQXJ6QXJ002IfMW00=XJ6QYJFUYJFT00Va/K003Kfm_LW9bLW9b009fMWH0
0gYjNW]kNg]kN`02NGUi0W=cL`03JVYZHV9RHV9R009KFe/3F5QH0U]KF`03I6ATLW9bLW9b00:2PX80
0hj>SY2@T92@T002Ph>300=]KFeGEeMGEeL00T];B`03DE5AI6ATI6AT009iNGT3R8R80WinOP03Lg=c
L71`L71`009lO7`00hn?Sj2PX:2PX002XJ6Q00><S8aYJFUYJFT00TQ8B003=SHf?3`l?3`l009DE5@0
0g5aLHR8R8R8R002TY:B00>@T928R8R8R8P00WemO@03LW9bIfMWIfMW009MGEd00e=CDdU9BDU9B@03
@d=30Ti>CP9VIVH00h>3PibLW9bLW002YjNW00>NWYj5QHF5QHD00VQXJ003DE5AB4Q8B4Q8009<C4`0
0eEEEF1PH61PH002J6QX00=]KFebLW9bLW800WIfMP9iNGT00gYjNWUiNGUiN@02MWIf00=bLW9^KVi^
KVh00V][J`03J6QXIfMWIfMW009XJ6P00fUYJF][Jf][J`02K6a/00=^KVi_Kfm_Kfl01G1`L0=_Kfl4
KVi^1Ve]K@M^KVh2Kfm_0fi^KP?oool200004_ooo`009Oooo`030000oooooooo00;oool3gMgM1=kN
gPSOgml3g]kN0]gMg@GLg=`2gMgM00?Ng]kOgmoOgml00^3Ph003h^;Rhn?Shn?S00;Ti>@00n?Shn7Q
hN7Qh@02g]kN00?Kfm_GemOGemL00]?Cd`?@d=02d];B0]OGe`03g]kNi^KVi^KV00;^k^h00oGemOSh
n?Shn002m_Kf00?]kNgLg=cLg=`00/G5a@03ZJVYS8b<S8b<009_Kfl00eEEED10@410@002=3@d00<`
<30f=SHf=SH00T51@@03DE5AHf=SHf=S009eMGD00hB4Q8n?Shn?S`02U9BD00>CTi>>SXj>SXh00XJ6
QP03O7alLG5aLG5a009VIVH00eeMGEEEEEEEE@02D51@00=<C4a9BDU9BDT00TI6AP03A4A4@T92@T92
008o?cl00cdm?CXj>SXj>P03>3Ph0STi>@8n?Sh00dI6AU=CDe=CD`02I6AT00=iNGV@T92@T9000ZRX
Z003_knoe=CDe=CD00;Vi^H00o?cloWinOWin@02n_[j00?gmoO`l?3`l?000^SXj003gmoOemOGemOG
00;Bd]83clo?0]7Ad@;De=@00mSHf=cLg=cLg002h>3P00?Rh^;Shn?Shn<00^?Sh`03h^;Rh>3Ph>3P
00;Ng]h00mgMgM_Kfm_Kf`02fm_K0m[JfP;Kfm/3g=cL2]gMg@[Lg=`4oooo00<0003oooooool0<_oo
o`040000oooooooooooo0Vi^KP=]KFd5K6a/0f][J`A/K6`3KFe]1fi^KP03KFe]K6a/K6a/009ZJVX0
0fUYJFQXJ6QXJ002IfMW00=XJ6QYJFUYJFT00Va/K003Kfm_LW9bLW9b009fMWH00gYjNW]kNg]kN`02
NGUi0W=cL`03JVYZHV9RHV9R009KFe/3F5QH0U]KF`03I6ATLW9bLW9b00:2PX800hj>SY2@T92@T002
Ph>300=]KFeGEeMGEeL00T];B`03DE5AI6ATI6AT009iNGT3R8R80WinOP03Lg=cL71`L71`009lO7`0
0hn?Sj2PX:2PX002XJ6Q00><S8aYJFUYJFT00TQ8B003=SHf?3`l?3`l009DE5@00g5aLHR8R8R8R002
TY:B00>@T928R8R8R8P00WemO@03LW9bIfMWIfMW009MGEd00e=CDdU9BDU9B@03@d=30Ti>CP9VIVH0
0h>3PibLW9bLW002YjNW00>NWYj5QHF5QHD00VQXJ003DE5AB4Q8B4Q8009<C4`00eEEEF1PH61PH002
J6QX00=]KFebLW9bLW800WIfMP9iNGT00gYjNWUiNGUiN@02MWIf00=bLW9^KVi^KVh00V][J`03J6QX
IfMWIfMW009XJ6P00fUYJF][Jf][J`02K6a/00=^KVi_Kfm_Kfl01G1`L0=_Kfl4KVi^1Ve]K@M^KVh2
Kfm_0fi^KPCoool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`?Lg=`>gMgM0mcL
g0GKfm/2g=cL00?MgMgNg]kNg]h00]oOg`03hN7Qh^;Rh^;R00;Shn<00n;Rh^3Ph>3Ph002g]kN00?K
fm_GemOGemL00]CDe0?AdM42d];B0]OGe`03g]kNiNGUiNGU00;]kNd00o;bl_GemOGem@02l_;b00?Y
jNWIfMWIfMT00/;2`P03Z:RXS8b<S8b<009`L7000eMGEdA4A4A4A002>3Ph00<e=CDj>SXj>SX00TI6
AP03EUIFIfMWIfMW009hN7P00hJ6QY6ATI6AT@02UIFE00>DU9B?Shn?Shl00XJ6QP03O7alLW9bLW9b
009WIfL00eiNGUMGEeMGE`02DU9B00=?Cdm=CDe=CDd00T];B`03BTY:B4Q8B4Q80096ATH00dA4A451
@D51@@03?clo0T10@094A4@00da<C5QHF5QHF002J6QX00=lO7bBTY:BTY800ZVYZ@03`<30eMGEeMGE
00;Vi^H00o;bl_Shn?Shn002nOWi00?fm_K_kno_knl00^OWi`03gmoOemOGemOG00;Bd]83clo?0]7A
d@;De=@00mSHf=cLg=cLg002h>3P00?Rh^;Shn?Shn<00^?Sh`03h^;Rh>3Ph>3P00;Ng]h00mgMgMcL
g=cLg002fm_K00?Jf][Kfm_Kfm/00]_Kf`?Lg=`<gMgM2=cLg0Coool00`000?ooooooo`0boooo00@0
003oooooooooool5KVi^2Ve]K@=^KVh7Kfm_0fi^KP9/K6`2Jf][00=ZJVYYJFUYJFT00VQXJ003JFUY
JVYZJVYZ009/K6`00fm_Kg9bLW9bLP02MWIf00=iNGUjNWYjNWX00WQhN09bLW800f][Jf=SHf=SH`02
GEeM0eYJFP9LG5`00fEUIGAdM7AdM002QXJ600>DU9BEUIFEUID00X>3P`03IVIVC4a<C4a<0094A4@0
0eUIFH20P820P002Z:RX00>n_[jd];Bd];@00YBDU003LG5aG5aLG5aL009SHf<00galO9JFUYJFUP02
X:2P00>BTY9bLW9bLW800U9BDP03@410A4A4A4A4009JFUX00gEeMH^;Rh^;R`03UYJF0Y6AT@:;Rh/0
0hN7Qh>3Ph>3P`02OWin00=cLg=RHV9RHV800U1@D003A4A4ATI6ATI6009LG5`00galO9^KVi^KV`02
Zj^[00>RXZ:7QhN7QhL00VQXJ003D51@AdM7AdM7009<C4`00eIFEV5QHF5QH@02JFUY00=^KVicLg=c
Lg<00WIfMP9iNGT00gYjNWUiNGUiN@02MWIf00=bLW9^KVi^KVh00V][J`03JFUYJ6QXJ6QX009XJ6P0
0fUYJF][Jf][J`02K6a/00=^KVi_Kfm_Kfl00Vm_K`=`L703Kfm_0Vi^KPY]KFd:KVi^1?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0mcLg0kMgMd3g=cL1M_Kf`;Lg=`00mgMgMkN
g]kNgP02gmoO00?QhN7Rh^;Rh^800^?Sh`03h^;Rh>3Ph>3P00;Ng]h00m_KfmOGemOGe`02e=CD0m7A
d@;Bd]82emOG00?Ng]kUiNGUiND00^g]k@03l_;bmOGemOGe00;bl_800nWYjMWIfMWIf@02`/;200>X
Z:R<S8b<S8`00W1`L003EeMGA4A4A4A4008h>3P00cDe=CXj>SXj>P02ATI600=FEUIWIfMWIfL00WQh
N003QXJ6TI6ATI6A00:EUID00iBDU8n?Shn?S`02QXJ600=lO7abLW9bLW800VMWI`03GUiNEeMGEeMG
009BDU800dm?Cde=CDe=C@02Bd];00=:BTY8B4Q8B4P00TI6AP03A4A4@D51@D5100<o?cl2@4100TA4
A003C4a<F5QHF5QH009XJ6P00galO9:BTY:BTP02ZJVY00?0`<3EeMGEeMD00^KViP03l_;bn?Shn?Sh
00;inOT00oKfm^o_kno_k`02inOW00?OgmoGemOGemL00];BdP??cll2dM7A0]CDe003f=SHg=cLg=cL
00;Ph>000n;Rh^?Shn?Sh`02hn?S00?Rh^;Ph>3Ph>000]kNgP03gMgMg=cLg=cL00;Kfm/00m[Jf]_K
fm_Kf`02fm_K0mcLg0cMgMd8g=cL1?ooo`030000oooooooo03;oool010000?ooooooooooo`E^KVh:
KFe]0fi^KPM_Kfl3KVi^0Va/K09[Jf/00fYZJVUYJFUYJ@02J6QX00=YJFUZJVYZJVX00Va/K003Kfm_
LW9bLW9b009fMWH00gUiNGYjNWYjNP02N7Qh0W9bLP03Jf][Hf=SHf=S009MGEd3FUYJ0UaLG003IFEU
M7AdM7Ad00:6QXH00iBDU9FEUIFEU@02Ph>300=VIVI<C4a<C4`00TA4A003FEUIP820P82000:XZ:P0
0kjn_[Bd];Bd]002U9BD00=aLG5LG5aLG5`00V=SH`03O7alUYJFUYJF00:PX:000i:BTW9bLW9bLP02
DU9B00=0@414A4A4A4@00UYJFP03MGEeRh^;Rh^;00>FUYH2TI6A0X^;R`03QhN7Ph>3Ph>3009nOWh0
0g=cLf9RHV9RHP02D51@00=4A4A6ATI6ATH00UaLG003O7alVi^KVi^K00:[Zj/00j:RXXN7QhN7Q`02
J6QX00=@D517AdM7AdL00Ta<C003EUIFHF5QHF5Q009YJFT00fi^KW=cLg=cL`02MWIf0WUiN@03NWYj
NGUiNGUi009fMWH00g9bLVi^KVi^KP02Jf][00=YJFUXJ6QXJ6P00VQXJ003JFUYJf][Jf][009/K6`0
0fi^KVm_Kfm_K`02Kfm_0g1`L0=_Kfl2KVi^2Ve]K@Y^KVh4oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool?g=cL3=_Kf`03g=cLgMgMgMgM00;Ng]h00n3Ph>7QhN7Qh@03hN7Q0^3P
h0;MgMd00m_KfmSHf=SHf002eMGE0m;BdP;Cdm<2f=SH00?Ng]kTi>CTi>@00^_[j`03l?3`l_;bl_;b
00;_knl00nKVi]KFe]KFeP02`L7100>XZ:R=SHf=SHd00W=cL`03G5aLBDU9BDU9008n?Sh00c/k>d10
@410@002Bd];00=IFEUZJVYZJVX00WUiN@03QhN7T92@T92@00:EUID00i>CThj>SXj>SP02QXJ600=l
O7abLW9bLW800VQXJ003H61PFEUIFEUI009EEED00e9BDU1@D51@D002Cdm?00=>CTi=CDe=CDd00T];
B`03BDU9AdM7AdM700=5ADD2AdM70T];B`03DU9BGUiNGUiN009^KVh00h61PIJFUYJFUP02[:b/00?1
`L7EeMGEeMD00^GUi@03lO7amoOgmoOg00;gmoL00oCdm>k^k^k^kP02i^KV00?Ng]kGemOGemL00];B
dP??cll2dM7A0]GEe@03f=SHg=cLg=cL00;Ogml00n;Rh^?Shn?Sh`02hn?S00?QhN7Ph>3Ph>000]kN
gP03gMgMg=cLg=cL00OKfm/00mcLg=gMgMgMg@03gMgM1MkNgPOMgMd5g=cL1?ooo`030000oooooooo
03;oool010000?ooooooooooo`e^KVh7Kfm_0g1`L0A_Kfl00fi^KVe]KFe]K@02K6a/00=[Jf]ZJVYZ
JVX00VUYJ@03JVYZJf][Jf][009]KFd00fm_Kg9bLW9bLP02MGEe00=hN7QiNGUiNGT00WMgM`9bLW80
0f][JfEUIFEUI@02H61P00=MGEeLG5aLG5`00UiNGP03IVIVMWIfMWIf00::RXX3VYZJ0X>3P`03H61P
@T92@T92008m?Cd00emOGiRHV9RHV002dM7A00?]kNgJf][Jf]X00ZNWY`03KFe]B4Q8B4Q80099BDT0
0fEUIHJ6QXJ6QP02VIVI00>CTi=jNWYjNWX00V1PH003D51@DU9BDU9B009SHf<00gQhN8Z:RXZ:RP02
U9BD1INGU`03VYZJWIfMWIfM00:LW9`00i6ATGUiNGUiN@02G5aL00=5ADDo?clo?cl00U=CD`03MgMg
Vi^KVi^K00:^[Zh00jJVYXZ:RXZ:RP02JFUY00=?Cdm6ATI6ATH00Ta<C003EeMGHf=SHf=S009[Jf/0
0fm_Kg=cLg=cL`02MWIf0WQhN003NGUiN7QhN7Qh009fMWH00g9bLVi^KVi^KP02Jf][00=YJFUXJ6QX
J6P00VQXJ003JFUYJf][Jf][009/K6`00fi^KVm_Kfm_K`02Kfm_00=`L71_Kfm_Kfl00Vm_K`=^KVh=
KFe]1fi^KPCoool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`GLg=`:fm_K2][J
fP;Kfm/00mcLg=gMgMgMg@02g]kN00?OgmoPh>3Ph>000n3Ph0;Ogml2gMgM00?Kfm_Hf=SHf=P00]GE
e@?Cdm<2e=CD0]SHf003g]kNhn?Shn?S00;YjNT00ng]kNk^k^k^kP02k>c/00?Shn?De=CDe=@00/30
`003ZJVYT92@T92@009gMgL00f5QHE1@D51@D002ADE500=2@T96ATI6ATH00Tm?C`03G5aLJf][Jf][
009iNGT00hF5QHj>SXj>SP02TI6A00>@T92<S8b<S8`00XB4Q003O7alLg=cLg=c009ZJVX00f9RHUaL
G5aLG002EeMG00=DE5ABDU9BDU800U5AD@03Cdm?CTi>CTi>009=CDd00d];BdY:BTY:BP03BDU90Ta<
C09@D5000eQHF6ATI6ATI002Lg=c00>5QHFJVYZJVYX00Zn_[`03`l?3eMGEeMGE00;UiND00o3`l?Ge
mOGem@02m_Kf00?clo?]kNg]kNd00^KViP03g]kNemOGemOG00;Bd]83d=3@0];BdP;EeMD00mWIfMcL
g=cLg002gmoO00?Rh^;Shn?Shn<00^;RhP03hN7Qh>3Ph>3P00;Ng]h00mgMgMcLg=cLg007fm_K00?L
g=cMgMgMgMd00]gMg@SNg]h7gMgM0mcLg0Coool00`000?ooooooo`0boooo00@0003oooooooooool3
KVi^2Vm_K`a`L703Kfm_0Vi^KP9]KFd00fa/K6][Jf][J`02JVYZ00=[Jf]/K6a/K6`00Ve]K@03Kfm_
LW9bLW9b009dM7@3MgMg0WIfMP9aLG400fa/K6MWIfMWI`02HV9R00=OGemNGUiNGUh00V1PH003J6QX
N7QhN7Qh00:<S8`00ibLW9ZJVYZJVP02P82000=JFUXi>CTi>CT00SDe=@03GUiNXJ6QXJ6Q00;QhN40
0oooonSXj>SXj002ZZZZ00=UIFDg=cLg=cL00S<c<`03Cdm?M7AdM7Ad00:>SXh00i6ATH>3Ph>3P`02
LG5a00=UIFETI6ATI6@00Ve]K@03N7QhPh>3Ph>300:;Rh/00i2@T9BDU9BDU002VIVI00>PX:2VYZJV
YZH00ZNWY`03W9bLPh>3Ph>3009RHV800dI6AShn?Shn?P02DE5A00=eMGFKVi^KVi/00[2`/003Z:RX
Rh^;Rh^;009YJFT00di>CTI6ATI6AP02CDe=00=IFEUUIFEUIFD00Va/K003L71`Lg=cLg=c009eMGD2
MgMg00=iNGUhN7QhN7P00WIfMP03LW9bKfm_Kfm_009[Jf/00fUYJFQXJ6QXJ002J6QX00=YJFU[Jf][
Jf/00Va/K003KFe]Kfm_Kfm_00M_Kfl3KVi^3fe]K@E^KVh4oooo00<0003oooooool04?ooo`006ooo
o`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`GLg=`:fm_K2][J
fP;Kfm/00mcLg=gMgMgMg@02g]kN00?OgmoPh>3Ph>000n3Ph0;Ogml2gMgM00?Kfm_Hf=SHf=P00]GE
e@?Cdm<2e=CD0]SHf003g]kNhn?Shn?S00;YjNT00ng]kNk^k^k^kP02k>c/00?Shn?De=CDe=@00/30
`003ZJVYT92@T92@009gMgL00f5QHE1@D51@D002ADE500=2@T96ATI6ATH00Tm?C`03G5aLJf][Jf][
009iNGT00hF5QHj>SXj>SP02TI6A00>@T92<S8b<S8`00XB4Q003O7alLg=cLg=c009ZJVX00f9RHUaL
G5aLG002EeMG00=DE5ABDU9BDU800U5AD@03Cdm?CTi>CTi>009=CDd00d];BdY:BTY:BP03BDU90Ta<
C09@D5000eQHF6ATI6ATI002Lg=c00>5QHFJVYZJVYX00Zn_[`03`l?3eMGEeMGE00;UiND00o3`l?Ge
mOGem@02m_Kf00?clo?]kNg]kNd00^KViP03g]kNemOGemOG00;Bd]83d=3@0];BdP;EeMD00mWIfMcL
g=cLg002gmoO00?Rh^;Shn?Shn<00^;RhP03hN7Qh>3Ph>3P00;Ng]h00mgMgMcLg=cLg007fm_K00?L
g=cMgMgMgMd00]gMg@SNg]h7gMgM0mcLg0Coool00`000?ooooooo`0Woooo00<0003oooooool00_oo
o`030000oooooooo00?oool010000?ooooooooooo`=^KVh:Kfm_371`L0=_Kfl2KVi^0Ve]K@03K6a/
Jf][Jf][009ZJVX00f][Jfa/K6a/K002KFe]00=_KfmbLW9bLW800WAdM0=gMgL2MWIf0W5aL@03K6a/
IfMWIfMW009RHV800emOGeiNGUiNGP02H61P00=XJ6QhN7QhN7P00Xb<S003W9bLVYZJVYZJ00:0P800
0eYJFSTi>CTi>@02=CDe00=NGUjQXJ6QXJ400^7Qh@03ooooj>SXj>SX00:ZZZX00fEUICLg=cLg=`02
<c<c00=?CdmdM7AdM7@00Xj>SP03TI6APh>3Ph>3009aLG400fEUIFATI6ATI002KFe]00=hN7R3Ph>3
Ph<00X^;R`03T92@U9BDU9BD00:IVIT00j2PX:JVYZJVYP02YjNW00>LW9b3Ph>3Ph<00V9RHP03ATI6
?Shn?Shn009ADE400gEeMI^KVi^KV`02/;2`00>XZ:R;Rh^;Rh/00VUYJ@03CTi>ATI6ATI6009=CDd0
0eUIFFEUIFEUI@02K6a/00=`L71cLg=cLg<00WEeM@9gMgL00gUiNGQhN7QhN002MWIf00=bLW9_Kfm_
Kfl00V][J`03JFUYJ6QXJ6QX009XJ6P00fUYJF][Jf][J`02K6a/00=]KFe_Kfm_Kfl01fm_K`=^KVh?
KFe]1Fi^KPCoool00`000?ooooooo`0@oooo000Joooo00<0003oool000000_ooo`030000oooo0000
00?oool00`000?ooooooo`02oooo1McLg0OKfm/=f][J0m_Kf`;Lg=`2gMgM00?Ng]kOgmoOgml00^3P
h003gmoOg]kNg]kN00;MgMd00m_KfmWIfMWIf@02e]KF00?EeMGDe=CDe=@00]KFeP;IfMT00mkNg^?S
hn?Sh`02inOW00?[jn_/k>c/k>`00^WYj@03h>3Pdm?Cdm?C00;0`<000jZZZY>CTi>CT`02OGem00=X
J6QHF5QHF5P00Te=C@03BTY:C4a<C4a<009DE5@00eiNGVYZJVYZJP02MWIf00>1PH68R8R8R8P00hb<
S0:8R8P2PX:200=kNg]cLg=cLg<00Va/K003IFEUGUiNGUiN009JFUX00eIFEU=CDe=CD`02D51@00=>
CTi=CDe=CDd00T];B`03BTY:BDU9BDU9009:BTX00d];Bdm?Cdm?C`02EEEE00=MGEeYJFUYJFT00WQh
N003RXZ:WYjNWYjN00:a/K400lG5aMKFe]KFeP02iNGU00?_knodm?Cdm?@00_Cdm003l_;bk>c/k>c/
00;UiND00mkNg]OGemOGe`02d];B0m3@d0;Bd]82eMGE00?IfMWLg=cLg=`00]oOg`03hN7Qh^;Rh^;R
00;Rh^800n7QhN3Ph>3Ph002g]kN00?MgMgLg=cLg=`01M_Kf`?Lg=`4gMgM2]kNgPKMgMd2g=cL1?oo
o`030000oooooooo02Koool00`000?ooo`000002oooo00<0003oool000001?ooo`040000oooooooo
oooo0fi^KPM_Kfl?L71`0fm_K`9^KVh2KFe]00=/K6a[Jf][Jf/00f][J`9/K6`2KFe]00=_KfmaLG5a
LG400WAdM0=fMWH2MGEe0W5aL@03Jf][IfMWIfMW009SHf<00f5QHF9RHV9RHP02I6AT00=[Jf]jNWYj
NWX00XZ:RP03UiNGTi>CTi>C009hN7P00e9BDS8b<S8b<P02;Rh^00=CDe>ATI6ATI400/g=c@03j^[Z
dm?Cdm?C00:HV9P00eQHF2/[:b/[:`029bLW00=0@41TI6ATI6@00X61P@03SHf=Rh^;Rh^;00:4Q8@0
0gemOGQhN7QhN002MWIf00=eMGEfMWIfMWH00WUiN@03OgmoQHF5QHF500:<S8`00i:BTYJFUYJFUP02
UYJF00>=SHegMgMgMgL00UeMG@03AdM7@T92@T92009FEUH00gUiNIbLW9bLW002[jn_00>VYZJ:RXZ:
RXX00VUYJ@03D51@B4Q8B4Q8009>CTh00eYJFVEUIFEUI@02KFe]00=`L71cLg=cLg<00WEeM@9gMgL3
N7Qh0WEeM@03LW9bKVi^KVi^009[Jf/00fUYJFQXJ6QXJ002J6QX00=YJFU[Jf][Jf/00Va/K003KFe]
KVi^KVi^00M_Kfl3KVi^1Fe]K@=/K6`9KFe]0fi^KPCoool00`000?ooooooo`0@oooo000Joooo00<0
003oool000000_ooo`030000oooo000000?oool300000_ooo`GLg=`7fm_K3M[JfP?Kfm/2g=cL0]gM
g@03g]kNgmoOgmoO00;Ph>000moOgmkNg]kNgP02gMgM00?Kfm_IfMWIfMT00]KFeP03eMGEe=CDe=CD
00;Fe]H2fMWI00?Ng]kShn?Shn<00^OWi`03jn_[k>c/k>c/00;YjNT00n3Ph=?Cdm?Cd`02`<3000>Z
ZZZCTi>CTi<00WemO@03J6QXF5QHF5QH009=CDd00dY:BTa<C4a<C002E5AD00=NGUiZJVYZJVX00WIf
MP03PH61R8R8R8R800><S8`2R8R80X:2PP03Ng]kLg=cLg=c009/K6`00fEUIEiNGUiNGP02FUYJ00=F
EUICDe=CDe<00U1@D003CTi>CDe=CDe=009;Bd/00dY:BTU9BDU9B@02BTY:00=;Bd]?Cdm?Cdl00UEE
E@03GEeMJFUYJFUY009hN7P00hZ:RYjNWYjNWP02/K6a00?5aLGFe]KFe]H00^GUi@03kno_m?Cdm?Cd
00;dm?@00o;bl^c/k>c/k002iNGU00?Ng]kGemOGemL00];BdP?@d=02d];B0]GEe@03fMWIg=cLg=cL
00;Ogml00n7QhN;Rh^;RhP02h^;R00?QhN7Ph>3Ph>000]kNgP03gMgMg=cLg=cL00GKfm/3g=cL1=gM
g@[Ng]h6gMgM0]cLg0?oool20000:?ooo`030000oooo000000;oool00`000?ooo`000004oooo0P00
00;oool3KVi^1fm_K`m`L703Kfm_0Vi^KP9]KFd00fa/K6][Jf][J`03Jf][0Va/K09]KFd00fm_Kg5a
LG5aL@02M7Ad0gIfMP9eMGD2LG5a00=[Jf]WIfMWIfL00V=SH`03HF5QHV9RHV9R009TI6@00f][JgYj
NWYjNP02RXZ:00>GUiNCTi>CTi<00WQhN003DU9B<S8b<S8b008^;Rh00e=CDi6ATI6AT@02cLg=00?Z
j^[Cdm?Cdm<00YRHV003F5QH:b/[:b/[008W9bL00d10@6ATI6ATI002PH6100>=SHf;Rh^;Rh/00XB4
Q003OGemN7QhN7Qh009fMWH00gEeMGIfMWIfMP02NGUi00=oOgn5QHF5QHD00Xb<S003TY:BUYJFUYJF
00:FUYH00hf=SGMgMgMgM`02GEeM00=7AdM2@T92@T800UIFEP03NGUiW9bLW9bL00:_[jl00jJVYXZ:
RXZ:RP02JFUY00=@D518B4Q8B4P00Ti>CP03FUYJIFEUIFEU009]KFd00g1`L7=cLg=cL`02MGEe0WMg
M`=hN7P2MGEe00=bLW9^KVi^KVh00V][J`03JFUYJ6QXJ6QX009XJ6P00fUYJF][Jf][J`02K6a/00=]
KFe^KVi^KVh01fm_K`=^KVh5KFe]0fa/K0U]KFd3KVi^0oooo`80000Boooo000Koooo00L0003ooooo
ooooool0003oool000000oooo`030000oooooooo00;oool7g=cL1M_Kf`gJf]X3fm_K0]cLg0;MgMd0
0mkNg]oOgmoOg`03gmoO0]kNgP;MgMd00m_KfmWIfMWIf@02emOG00?Fe]KEeMGEeMD00]OGe`;Jf]X0
0mkNg^;Rh^;RhP02i^KV0nWYj@;Vi^H00mkNg];Bd];BdP02`L7100>][JfHV9RHV9P00X>3P`03L71`
HF5QHF5Q009FEUH3DU9B0UQHF003GemOJFUYJFUY009bLW800g]kNh61PH61P@03QHF50X>3P`9oOgl0
0gYjNWAdM7AdM002KVi^00=XJ6QRHV9RHV800UaLG003EeMGDe=CDe=C009?Cdl00d];BdU9BDU9B@02
AdM70dI6AP98B4P00d];Be1@D51@D002F5QH00=RHV9^KVi^KVh00WinOP03Shn?XJ6QXJ6Q00:d];@0
0lK6a]OGemOGe`02i>CT00?^k^kclo?clo<00_?cl`03l?3`jn_[jn_[00;UiND00mkNg]SHf=SHf002
dm?C0m7Ad@;Cdm<2e]KF00?IfMWLg=cLg=`00]oOg`03hN7Qh^;Rh^;R00;Rh^800n7QhN3Ph>3Ph002
g]kN00?MgMgLg=cLg=`01M_Kf`?Lg=`4gMgM2mkNgPOMgMd4oooo00<0003oooooool09oooo`070000
oooooooooooo0000oooo000000Coool010000?ooooooooooo`E^KVh7Kfm_3G1`L0=_Kfl2KVi^0fe]
K@M/K6`2KFe]00=_Kfm`L71`L7000W=cL`03MGEeMWIfMWIf009dM7@2L71`00=[Jf]VIVIVIVH00f=S
H`9VIVH2JFUY00=`L71kNg]kNg/00XJ6QP03SHf=QXJ6QXJ6009^KVh00da<C2l_;bl_;`02:BTY00=4
A4AcLg=cLg<00Z6QX@03]kNgYZJVYZJV009iNGT00dQ8B2LW9bLW9`0292@T00<h>3QFEUIFEUH00W9b
LP03QXJ6T92@T92@00:EUID00iBDU8^;Rh^;R`02OWin00=_KfmUIFEUIFD00V=SH`03J6QXKfm_Kfm_
009eMGD00gMgMgIfMWIfMP02Lg=c00=[Jf]NGUiNGUh00U5AD@03B4Q8C4a<C4a<009QHF400gmoOibL
W9bLW002Zj^[00>QXJ67QhN7QhL00VUYJ@03DU9BBTY:BTY:009@D5000e]KFfIVIVIVIP02KFe]00=`
L71bLW9bLW800WEeM@9fMWH00gQhN7MgMgMgM`02MGEe00=bLW9^KVi^KVh00V][J`03JFUYJ6QXJ6QX
009YJFT00fYZJV][Jf][J`02K6a/00=]KFe^KVi^KVh01fm_K`=^KVh5KFe]0fa/K0Y]KFd2KVi^1?oo
o`030000oooooooo013oool001[oool00`000?ooo`000002oooo00<0003oool000000oooo`030000
oooooooo00;oool2gMgM1]cLg0[Kfm/7f][J0m_Kf`;Lg=`2gMgM0mkNgP?Ogml2g]kN0]gMg@03fm_K
f][Jf][J00;Hf=P3emOG0]SHf0;Jf]X00mkNg^7QhN7Qh@02iNGU0nOWi`;Ti>@00mgMgM7AdM7Ad@02
`/;200>`/;2MWIfMWId00XZ:RP03NGUiJVYZJVYZ009PH6000eYJFUUIFEUIF@02Fe]K00=PH61WIfMW
IfL00Ve]K@03M7AdNGUiNGUi009mOGd3OWin0WalO003NWYjMWIfMWIf009bLW800fa/K6IVIVIVIP02
GemO00=IFEUBDU9BDU800Te=C@03AdM7@d=3@d=30091@D400d10@492@T92@P02ADE500=:BTYADE5A
DE400UYJFP03IFEULg=cLg=c00:3Ph<00iBDU:JVYZJVYP02]kNg00?8b<SHf=SHf=P00^CTi003kNg]
lO7alO7a00;bl_800no_kn_[jn_[j`02i>CT00?Ng]kHf=SHf=P00]CDe0?Bd]82dm?C0]KFeP03fMWI
g=cLg=cL00;Ogml00n7QhN;Rh^;RhP02h^;R00?QhN7Ph>3Ph>000]kNgP03gMgMg=cLg=cL00GKfm/3
g=cL1=gMg@_Ng]h7gMgM1?ooo`030000oooooooo02Koool00`000?ooo`000002oooo00<0003oool0
00001?ooo`040000oooooooooooo1fi^KPY_Kfl8L71`0fm_K`A^KVh00fe]KFa/K6a/K005K6a/0Ve]
K@03KVi^L71`L71`009bLW800gAdM7EeMGEeM@02M7Ad0W1`L003JVYZIFEUIFEU009SHf<00fEUIFUY
JFUYJ@02Kfm_00=eMGEkNg]kNg/00X20P003PH61N7QhN7Qh009SHf<00dU9BC4a<C4a<@02:BTY00<g
=cMCDe=CDe<00W1`L003OWinM7AdM7Ad009JFUX00cdm?BXZ:RXZ:P02:2PX00<e=CE9BDU9BDT00V9R
HP03Ng]kTY:BTY:B00:RXZ800jJVYYZJVYZJVP02PX:200=WIfMBDU9BDU800Te=C@03DU9BFUYJFUYJ
009OGel00eeMGEIFEUIFEP02CTi>00=7AdM4A4A4A4@00TA4A003BDU9EEEEEEEE009[Jf/00hJ6QYbL
W9bLW002YZJV00>LW9b4Q8B4Q8@00VUYJ@03E5ADCDe=CDe=009BDU800e]KFfIVIVIVIP02K6a/00=`
L71bLW9bLW800WAdM09fMWH00gMgMgIfMWIfMP02M7Ad00=bLW9^KVi^KVh00V][J`EYJFT00fYZJV][
Jf][J`02K6a/00=]KFe^KVi^KVh01fm_K`=^KVh7KFe]00=/K6a]KFe]KFd02Ve]K@Coool00`000?oo
ooooo`0@oooo000Koooo00<0003oooooool00_ooo`030000oooooooo00;oool00`000?ooooooo`02
oooo0]gMg@KLg=`:fm_K1m[JfP?Kfm/2g=cL0]gMg@?Ng]h3gmoO0]kNgP;MgMd00m_Kfm[Jf][JfP02
f=SH0mOGe`;Hf=P2f][J00?Ng]kQhN7QhN400^GUi@?WinL2i>CT00?MgMgAdM7AdM400/;2`P03/;2`
WIfMWIfM00::RXX00gUiNFYZJVYZJP02H61P00=JFUYIFEUIFET00U]KF`03H61PIfMWIfMW009]KFd0
0gAdM7UiNGUiN@02OGem0ginOP9lO7`00gYjNWIfMWIfMP02LW9b00=/K6aVIVIVIVH00UmOG`03FEUI
DU9BDU9B009=CDd00dM7Ad=3@d=3@`02@D5100=0@412@T92@T800TE5A@03BTY:DE5ADE5A009JFUX0
0fEUIG=cLg=cL`02Ph>300>DU9BVYZJVYZH00[Ng]`03b<S8f=SHf=SH00;Ti>@00ng]kO7alO7al@02
l_;b00?_kno[jn_[jn/00^CTi003g]kNf=SHf=SH00;De=@3d];B0]?Cd`;Fe]H00mWIfMcLg=cLg002
gmoO00?QhN7Rh^;Rh^800^;RhP03hN7Qh>3Ph>3P00;Ng]h00mgMgMcLg=cLg005fm_K0mcLg0CMgMd;
g]kN1mgMg@Coool00`000?ooooooo`0Woooo00<0003oooooool00_ooo`030000oooooooo00?oool0
10000?ooooooooooo`M^KVh:Kfm_271`L0=_Kfl4KVi^00=]KFe/K6a/K6`01Fa/K09]KFd00fi^KW1`
L71`L002LW9b00=dM7AeMGEeMGD00WAdM09`L7000fYZJVEUIFEUI@02Hf=S00=UIFEYJFUYJFT00Vm_
K`03MGEeNg]kNg]k00:0P8000h61PGQhN7QhN002Hf=S00=9BDTa<C4a<C400RTY:@03=cLgDe=CDe=C
009`L7000ginOWAdM7AdM002FUYJ00<m?CdZ:RXZ:RX00RPX:003=CDeBDU9BDU9009RHV800g]kNi:B
TY:BTP02XZ:R00>VYZJJVYZJVYX00X:2PP03IfMWDU9BDU9B009=CDd00e9BDUYJFUYJFP02GemO00=M
GEeFEUIFEUH00Ti>CP03AdM7A4A4A4A40094A4@00dU9BEEEEEEEE@02Jf][00>6QXJLW9bLW9`00ZJV
YP03W9bLQ8B4Q8B4009YJFT00eADE4e=CDe=C@02DU9B00=KFe]VIVIVIVH00Va/K003L71`LW9bLW9b
009dM7@2MWIf00=gMgMfMWIfMWH00WAdM003LW9bKVi^KVi^009[Jf/5JFUY00=ZJVY[Jf][Jf/00Va/
K003KFe]KVi^KVi^00M_Kfl3KVi^1fe]K@03K6a/KFe]KFe]00Y]KFd4oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool7gMgM2=cLg0gKfm/2g=cL0mgMg@ONg]h2gMgM00?Lg=cJf][J
f]X00]WIf@?Hf=P2fMWI0]_Kf`03g]kNhN7QhN7Q00;Ti>@00nKVi^GUiNGUi@02h^;R00?Lg=cBd];B
d]800/C4a003];BdXj>SXj>S00:BTY800h:2PWEeMGEeM@02JVYZ00=SHf=PH61PH6000UmOG`03HF5Q
IFEUIFEU009XJ6P00fe]KG5aLG5aL@02MGEe00=gMgMiNGUiNGT00WYjNP03NGUiN7QhN7Qh009eMGD0
0g5aLF][Jf][J`02Hf=S00=KFe]BDU9BDU800TY:BP03@d=3?Shn?Shn008k>c/00cXj>Sdm?Cdm?@02
@T9200=9BDUBDU9BDU800UeMG@03JVYZN7QhN7Qh00:8R8P00iVIVJZZZZZZZP02^k^k00?:b/[Hf=SH
f=P00^CTi003k>c/l?3`l?3`00;alO400nk^k^[Zj^[ZjP02i>CT00?Ng]kIfMWIfMT00]GEe@;Cdm<0
0m;Bd]CDe=CDe002e]KF00?IfMWLg=cLg=`00]oOg`03hN7Qh^;Rh^;R00;Rh^800n7QhN3Ph>3Ph002
g]kN00?MgMgLg=cLg=`00]cLg0?Kfm/3g=cL1MgMg@[Ng]h7gMgM1?ooo`030000oooooooo03;oool0
10000?ooooooooooo`=]KFd9KVi^2Vm_K`03L71`Kfm_Kfm_00=_Kfl4KVi^00=]KFe/K6a/K6`00fa/
K0A]KFd00fi^KVm_Kfm_K`02LG5a00=cLg=eMGEeMGD00WAdM09_Kfl00fUYJFATI6ATI002HV9R00=V
IVI]KFe]KFd00WAdM003NGUiNg]kNg]k009jNWX00gAdM6][Jf][J`02G5aL00=;Bd/l?3`l?3`00S@d
=003=SHf@410@410009:BTX00e1@D4e=CDe=C@02ADE500<l?3`e=CDe=CD00S8b<P03=CDe?Cdm?Cdm
009>CTh00fYZJXV9RHV9R@02Xj>S00>/[:bMWIfMWId00WemO@03FEUI?clo?clo008i>CT00d51@Di>
CTi>CP02EEEE00=@D514A4A4A4@00SPh>003<C4a<S8b<S8b008k>c/00dQ8B5]KFe]KF`02LW9b00>8
R8RJVYZJVYX00Z6QX@03UiNGPH61PH61009YJFT00eIFEU1@D51@D002E5AD00=LG5aVIVIVIVH00Va/
K003Kfm_LG5aLG5a009dM7@2MGEe0gIfMP9dM7@00g5aLFi^KVi^KP02Jf][00=ZJVYYJFUYJFT00VUY
J@03JVYZJf][Jf][009/K6`00fe]KFi^KVi^KP05Kfm_1Fi^KQA]KFd4oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool7gMgM2=cLg0gKfm/2g=cL0mgMg@ONg]h2gMgM00?Lg=cJf][J
f]X00]WIf@?Hf=P2fMWI0]_Kf`03g]kNhN7QhN7Q00;Ti>@00nKVi^GUiNGUi@02h^;R00?Lg=cBd];B
d]800/C4a003];BdXj>SXj>S00:BTY800h:2PWEeMGEeM@02JVYZ00=SHf=PH61PH6000UmOG`03HF5Q
IFEUIFEU009XJ6P00fe]KG5aLG5aL@02MGEe00=gMgMiNGUiNGT00WYjNP03NGUiN7QhN7Qh009eMGD0
0g5aLF][Jf][J`02Hf=S00=KFe]BDU9BDU800TY:BP03@d=3?Shn?Shn008k>c/00cXj>Sdm?Cdm?@02
@T9200=9BDUBDU9BDU800UeMG@03JVYZN7QhN7Qh00:8R8P00iVIVJZZZZZZZP02^k^k00?:b/[Hf=SH
f=P00^CTi003k>c/l?3`l?3`00;alO400nk^k^[Zj^[ZjP02i>CT00?Ng]kIfMWIfMT00]GEe@;Cdm<0
0m;Bd]CDe=CDe002e]KF00?IfMWLg=cLg=`00]oOg`03hN7Qh^;Rh^;R00;Rh^800n7QhN3Ph>3Ph002
g]kN00?MgMgLg=cLg=`00]cLg0?Kfm/3g=cL1MgMg@[Ng]h7gMgM1?ooo`030000oooooooo03;oool0
10000?ooooooooooo`=]KFd9KVi^2Vm_K`03L71`Kfm_Kfm_00=_Kfl4KVi^00=]KFe/K6a/K6`00fa/
K0A]KFd00fi^KVm_Kfm_K`02LG5a00=cLg=eMGEeMGD00WAdM09_Kfl00fUYJFATI6ATI002HV9R00=V
IVI]KFe]KFd00WAdM003NGUiNg]kNg]k009jNWX00gAdM6][Jf][J`02G5aL00=;Bd/l?3`l?3`00S@d
=003=SHf@410@410009:BTX00e1@D4e=CDe=C@02ADE500<l?3`e=CDe=CD00S8b<P03=CDe?Cdm?Cdm
009>CTh00fYZJXV9RHV9R@02Xj>S00>/[:bMWIfMWId00WemO@03FEUI?clo?clo008i>CT00d51@Di>
CTi>CP02EEEE00=@D514A4A4A4@00SPh>003<C4a<S8b<S8b008k>c/00dQ8B5]KFe]KF`02LW9b00>8
R8RJVYZJVYX00Z6QX@03UiNGPH61PH61009YJFT00eIFEU1@D51@D002E5AD00=LG5aVIVIVIVH00Va/
K003Kfm_LG5aLG5a009dM7@2MGEe0gIfMP9dM7@00g5aLFi^KVi^KP02Jf][00=ZJVYYJFUYJFT00VUY
J@03JVYZJf][Jf][009/K6`00fe]KFi^KVi^KP05Kfm_1Fi^KQA]KFd4oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool<gMgM1]cLg0[Kfm/4g=cL00?MgMgNg]kNg]h01MkNgP;MgMd0
0mcLg=_Kfm_Kf`02f][J1MWIf@;Kfm/00mkNg^7QhN7Qh@02hn?S0nCTi0;QhN400m_Kfm;Bd];BdP02
a/K600>i^KVZZZZZZZX00Y^KV`03S8b<OgmoOgmo009eMGD00fe]KFMWIfMWI`02I6AT0f=SH`9TI6@0
0fMWIfYZJVYZJP02KFe]00=aLG5eMGEeMGD00WQhN003NWYjNg]kNg]k009jNWX00gIfMW1`L71`L002
IfMW00=MGEeCDe=CDe<00TQ8B003?clo>CTi>CTi00<e=CD2>3Ph0Slo?`03B4Q8De=CDe=C009PH600
0fm_KginOWinOP02SXj>00>OWin_[jn_[jl00[jn_P03cLg=fMWIfMWI00;Ti>@00n_[jno_kno_k`02
kno_00?]kNgYjNWYjNT00^CTi003g]kNfMWIfMWI00;EeMD2e=CD00?Cdm?EeMGEeMD00]OGe`03f][J
g=cLg=cL00;Ogml6hN7Q0^3Ph0;Ng]h00mgMgMcLg=cLg008g=cL1MgMg@WNg]h8gMgM1?ooo`030000
oooooooo03;oool010000?ooooooooooo`Q]KFd9KVi^2fm_K`A^KVh5KFe]00=/K6a]KFe]KFd00fe]
K@9_Kfl2LG5a00=cLg=dM7AdM7@00W=cL`9_Kfl00fQXJ6=SHf=SH`02HV9R00=WIfM`L71`L7000WQh
N003OGemNg]kNg]k009cLg<00fYZJV1PH61PH002FUYJ00=EEEEADE5ADE400Ta<C003AdM7@D51@D51
008m?Cd00c/k>chn?Shn?P02@d=30dQ8B091@D400cLg=c0`<30`<002=SHf00=@D51dM7AdM7@00YBD
U003XJ6QTY:BTY:B009^KVh00dI6AR`/;2`/;002:b/[00<k>c]@D51@D5000UeMG@03FEUIBd];Bd];
008k>c/3<C4a0SXj>P03AdM7FUYJFUYJ009_Kfl00hF5QIJFUYJFUP02W9bL00>CTi=oOgmoOgl00VUY
J@03EeMGDU9BDU9B009EEED00eiNGVIVIVIVIP02K6a/00=_KfmaLG5aLG400W=cL`9dM7@3MGEe0W=c
L`03LG5aKVi^KVi^009/K6`00fYZJVUYJFUYJ@02JFUY00=ZJVY[Jf][Jf/00Va/K003KFe]KVi^KVi^
009^KVh3Kfm_1Fi^KQA]KFd4oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
gMgM0mkNgP[MgMd5g=cL2=_Kf`CLg=`00mgMgMkNg]kNgP05g]kN0]gMg@03g=cLfm_Kfm_K00;Jf]X3
fMWI0][JfP;Lg=`00mkNg^3Ph>3Ph002h^;R00?Shn?Rh^;Rh^800^3Ph003fm_Kdm?Cdm?C00;9bLT0
0kfm_K2`/;2`/002Xj>S00>FUYJ:RXZ:RXX00X20P003MgMgKfm_Kfm_009ZJVX00fIVIV=SHf=SH`03
HV9R0VATI09XJ6P00fe]KG9bLW9bLP02MgMg00=lO7aoOgmoOgl00WmoO`03OGemMWIfMWIf009/K6`0
0f5QHEADE5ADE002B4Q800<n?Shf=SHf=SH00c4a<@8f=SH2?Shn00=:BTYGEeMGEeL00VEUI@03MGEe
QHF5QHF500:EUID00jFUYKBd];Bd]002`/;200??cloJf][Jf]X00^?Sh`03j^[ZkNg]kNg]00;]kNd0
0nc/k>SXj>SXj002hn?S00?OgmoJf][Jf]X00]KFeP;EeMD00mCDe=KFe]KFeP02f=SH00?Jf][Lg=cL
g=`00]oOg`03h>3PhN7QhN7Q00;QhN400n3Ph=oOgmoOg`02g]kN0mgMg@SLg=`FgMgM1?ooo`030000
oooooooo03;oool010000?ooooooooooo`e]KFd5KVi^2Vm_K`A^KVh;KFe]0Vi^KP9`L7000g9bLWAd
M7AdM002Lg=c0Vi^KP03J6QXHf=SHf=S009RHV800fQXJ79bLW9bLP02Ng]k00=oOgmjNWYjNWX00Vi^
KP03HV9RFUYJFUYJ009LG5`00f=SHfYZJVYZJP02K6a/00=SHf=DE5ADE5@00TA4A003?Cdm@T92@T92
009@D5000eiNGV5QHF5QH@02De=C00<k>c/U9BDU9BD00R0P8003=CDeFEUIFEUI009lO7`00hb<S7em
OGemO@02FEUI00<b<S8M7AdM7Ad00R@T9003?cloGUiNGUiN00=bLW82Hf=S0U5AD@03@T92?3`l?3`l
008o?cl00dM7AeADE5ADE002J6QX00=mOGf@T92@T9000YRHV003TI6AOgmoOgmo009YJFT00eUIFE=C
De=CD`02EeMG00=OGemWIfMWIfL00Va/K003Kfm_L71`L71`009bLW82Lg=c0gAdM09cLg<00g5aLFi^
KVi^KP02K6a/00=ZJVYYJFUYJFT00VUYJ@03JVYZJf][Jf][009/K6`00fe]KFi^KVi^KP02KVi^00=_
Kfm^KVi^KVh01Fi^KQA]KFd4oooo00<0003oooooool04?ooo`009Oooo`800003oooo0]gMg@?Ng]h:
gMgM1McLg0SKfm/4g=cL00?MgMgNg]kNg]h01MkNgP;MgMd00mcLg=_Kfm_Kf`02f][J0mWIf@;Jf]X2
g=cL00?Ng]kPh>3Ph>000^;RhP03hn?Sh^;Rh^;R00;Ph>000m_Kfm?Cdm?Cd`02bLW900>m_Kf`/;2`
/;000Z>SX`03UYJFRXZ:RXZ:00:0P8000gMgMfm_Kfm_K`02JVYZ00=VIVISHf=SHf<00f9RHP9TI6@2
J6QX00=]KFebLW9bLW800WMgM`03O7alOgmoOgmo009oOgl00gemOGIfMWIfMP02K6a/00=QHF5DE5AD
E5@00TQ8B003?Shn=SHf=SHf00<a<C42=SHf0Shn?P03BTY:EeMGEeMG009UIFD00gEeMHF5QHF5Q@02
UIFE00>UYJFd];Bd];@00/;2`P03clo?f][Jf][J00;Shn<00n[Zj^g]kNg]k@02kNg]00?/k>cXj>SX
j>P00^?Sh`03gmoOf][Jf][J00;Fe]H2eMGE00?De=CFe]KFe]H00]SHf003f][Jg=cLg=cL00;Ogml0
0n3Ph>7QhN7Qh@02hN7Q00?Ph>3OgmoOgml00]kNgP?MgMd8g=cL5]gMg@?oool20000=?ooo`040000
oooooooooooo3Fe]K@E^KVh:Kfm_16i^KP]]KFd2KVi^0W1`L003LW9bM7AdM7Ad009cLg<2KVi^00=X
J6QSHf=SHf<00V9RHP03J6QXLW9bLW9b009kNg/00gmoOgYjNWYjNP02KVi^00=RHV9JFUYJFUX00UaL
G003Hf=SJVYZJVYZ009/K6`00f=SHeADE5ADE002A4A400<m?Ce2@T92@T800U1@D003GUiNHF5QHF5Q
009CDe<00c/k>bDU9BDU9@02820P00<e=CEIFEUIFET00WalO003S8b<OGemOGem009IFET00c8b<QdM
7AdM7@0292@T00<o?cmNGUiNGUh00g9bLP9SHf<2DE5A00=2@T8l?3`l?3`00Slo?`03AdM7E5ADE5AD
009XJ6P00gemOI2@T92@T002V9RH00>ATI5oOgmoOgl00VUYJ@03FEUIDe=CDe=C009GEeL00emOGfMW
IfMWI`02K6a/00=_Kfm`L71`L7000W9bLP9cLg<3M7Ad0W=cL`03LG5aKVi^KVi^009/K6`00fYZJVUY
JFUYJ@02JFUY00=ZJVY[Jf][Jf/00Va/K003KFe]KVi^KVi^009^KVh00fm_Kfi^KVi^KP05KVi^56e]
K@?oool200004_ooo`009Oooo`030000oooooooo00;oool<g]kN1MgMg@GLg=`5fm_K1McLg003gMgM
g]kNg]kN00GNg]h2gMgM00?Lg=cKfm_Kfm/00]_Kf`?Jf]X2fm_K0]cLg003g]kNh>3Ph>3P00;QhN40
0n;Rh^7QhN7Qh@02gmoO00?Kfm_De=CDe=@00/c<c003`/;2]kNg]kNg00:[Zj/00j2PX9FEUIFEU@02
RXZ:00>1PH5hN7QhN7P00W5aL@03Jf][IVIVIVIV009SHf<00f5QHF=SHf=SH`02IVIV00=/K6abLW9b
LW800WUiN@03OgmoQ8B4Q8B400:6QXH00hB4Q7emOGemO@02Lg=c00=VIVIHF5QHF5P00TY:BP03?Shn
=CDe=CDe00<a<C42=cLg0T51@@03CDe=G5aLG5aL009/K6`00gemOHf=SHf=S@02WIfM00>/[:bj^[Zj
^[X00/K6aP03dM7Afm_Kfm_K00;Shn<00nSXj>_[jn_[j`02jn_[00?Zj^[WinOWinL00^?Sh`03gmoO
f][Jf][J00;GemL2e]KF00?EeMGFe]KFe]H00]SHf003f][JgMgMgMgM00;Ogml00n3Ph>7QhN7Qh@02
hN7Q00?Ph>3OgmoOgml00]kNgP?MgMd8g=cL5]gMg@Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool?KFe]1Fi^KPQ_Kfl4KVi^2fe]K@9^KVh2L71`00=bLW9cLg=cLg<00W9bLP9^KVh00fQXJ6=S
Hf=SH`02HV9R00=XJ6QcLg=cLg<00WalO003OgmoN7QhN7Qh009ZJVX00eeMGEQHF5QHF002H61P00=a
LG62PX:2PX800XR8R003OgmoJf][Jf][009FEUH00d];Be9BDU9BDP02IFEU00=gMgMjNWYjNWX00VIV
IP03@d=38R8R8R8R008C4a<00b4Q8D=3@d=3@`02IVIV00=fMWIYJFUYJFT00TM7A`039BDU5QHF5QHF
008U9BD00dU9BG1`L71`L002Rh^;00>?Shn1PH61PH400Ve]K@03FUYJCDe=CDe=0098B4P00dM7Adm?
Cdm?C`02H61P00=eMGF9RHV9RHT00Y>CT`03SXj>OWinOWin009ZJVX00eYJFUEEEEEEE@02FEUI00=Q
HF5XJ6QXJ6P00Ve]K@03Kfm_L71`L71`009aLG42LW9b0g=cL`9bLW800g1`L6i^KVi^KP02K6a/1VYZ
JP9[Jf/2K6a/00=]KFe^KVi^KVh02Vi^KQA]KFd4oooo00<0003oooooool04?ooo`009Oooo`030000
oooooooo00;oool<g]kN1MgMg@GLg=`5fm_K1McLg003gMgMg]kNg]kN00GNg]h2gMgM00?Lg=cKfm_K
fm/00]_Kf`?Jf]X2fm_K0]cLg003g]kNh>3Ph>3P00;QhN400n;Rh^7QhN7Qh@02gmoO00?Kfm_De=CD
e=@00/c<c003`/;2]kNg]kNg00:[Zj/00j2PX9FEUIFEU@02RXZ:00>1PH5hN7QhN7P00W5aL@03Jf][
IVIVIVIV009SHf<00f5QHF=SHf=SH`02IVIV00=/K6abLW9bLW800WUiN@03OgmoQ8B4Q8B400:6QXH0
0hB4Q7emOGemO@02Lg=c00=VIVIHF5QHF5P00TY:BP03?Shn=CDe=CDe00<a<C42=cLg0T51@@03CDe=
G5aLG5aL009/K6`00gemOHf=SHf=S@02WIfM00>/[:bj^[Zj^[X00/K6aP03dM7Afm_Kfm_K00;Shn<0
0nSXj>_[jn_[j`02jn_[00?Zj^[WinOWinL00^?Sh`03gmoOf][Jf][J00;GemL2e]KF00?EeMGFe]KF
e]H00]SHf003f][JgMgMgMgM00;Ogml00n3Ph>7QhN7Qh@02hN7Q00?Ph>3OgmoOgml00]kNgP?MgMd8
g=cL5]gMg@Coool00`000?ooooooo`0boooo00@0003oooooooooool?KFe]1Fi^KPQ_Kfl4KVi^2fe]
K@9^KVh2L71`00=bLW9cLg=cLg<00W9bLP9^KVh00fQXJ6=SHf=SH`02HV9R00=XJ6QcLg=cLg<00Wal
O003OgmoN7QhN7Qh009ZJVX00eeMGEQHF5QHF002H61P00=aLG62PX:2PX800XR8R003OgmoJf][Jf][
009FEUH00d];Be9BDU9BDP02IFEU00=gMgMjNWYjNWX00VIVIP03@d=38R8R8R8R008C4a<00b4Q8D=3
@d=3@`02IVIV00=fMWIYJFUYJFT00TM7A`039BDU5QHF5QHF008U9BD00dU9BG1`L71`L002Rh^;00>?
Shn1PH61PH400Ve]K@03FUYJCDe=CDe=0098B4P00dM7Adm?Cdm?C`02H61P00=eMGF9RHV9RHT00Y>C
T`03SXj>OWinOWin009ZJVX00eYJFUEEEEEEE@02FEUI00=QHF5XJ6QXJ6P00Ve]K@03Kfm_L71`L71`
009aLG42LW9b0g=cL`9bLW800g1`L6i^KVi^KP02K6a/1VYZJP9[Jf/2K6a/00=]KFe^KVi^KVh02Vi^
KQA]KFd4oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2gMgM2mkNgPGMgMd<
g=cL0mgMg@ONg]h2gMgM0mcLg0;Kfm/3f][J0]_Kf`;Lg=`00mkNg]oOgmoOg`05hN7Q0]oOg`03fm_K
e]KFe]KF00;>c/h00lK6a[fm_Kfm_@02/k>c00>YZJVOWinOWil00YFEU@03Rh^;PX:2PX:2009jNWX0
0g9bLVa/K6a/K002IfMW0fEUI@9YJFT00fi^KWIfMWIfMP02OGem00>5QHF:RXZ:RXX00Xf=S@03Rh^;
QHF5QHF5009jNWX00fa/K5iNGUiNGP02Cdm?00=3@d<i>CTi>CT00SDe=@03=SHf?3`l?3`l0097AdL0
0eADE6ATI6ATI002MGEe00>6QXJFUYJFUYH00ZJVYP03/k>c_kno_kno00;:b/X00mCDe=cLg=cLg002
h^;R00?WinOYjNWYjNT00^WYj@03j>SXi^KVi^KV00;Rh^800mkNg]_Kfm_Kf`02f=SH1MOGe`;IfMT0
0m_KfmgMgMgMg@02g]kN1^3Ph0;Ogml2g]kN0mgMg@SLg=`FgMgM1?ooo`030000oooooooo03;oool0
10000?oooooooooooa5]KFd5KVi^1Fm_K`E^KVh;KFe]0Vi^KP9_Kfl00g5aLG=cLg=cL`02LW9b0Vi^
KP03JFUYI6ATI6AT009TI6@00fUYJG9bLW9bLP02Ng]k00=mOGefMWIfMWH00VUYJ@03GEeMFUYJFUYJ
009UIFD00gQhN8b<S8b<S002UYJF00>@T91oOgmoOgl00Va/K003Hf=SJf][Jf][009nOWh00hn?Si2@
T92@T002N7Qh00=ADE4[:b/[:b/00QPH60038B4Q?clo?clo009OGel00fm_Kf=SHf=SH`02ATI600<Y
:BTO7alO7al00S8b<P03FUYJPh>3Ph>300:PX:000jFUYIVIVIVIV@02Q8B400=_KfmNGUiNGUh00U9B
DP03C4a<CTi>CTi>009LG5`00fm_Kh>3Ph>3P`02SXj>00>:RXYlO7alO7`00VYZJP03G5aLF5QHF5QH
009LG5`00f=SHfUYJFUYJ@02KFe]00=^KVi_Kfm_Kfl00W1`L09bLW83Lg=c0W9bLP03L71`KVi^KVi^
009/K6`00f][JfYZJVYZJP02JVYZ00=[Jf]/K6a/K6`00Va/K003KFe]KVi^KVi^00Y^KVhDKFe]1?oo
o`030000oooooooo013oool002Goool00`000?ooooooo`02oooo1MgMg@SNg]h7gMgM2=cLg0GMgMd7
g]kN0]gMg@?Lg=`7fm_K0]cLg003g]kNgmoOgmoO00;Ph>000n7QhN3Ph>3Ph002gmoO00?Lg=cGemOG
emL00]7Ad@03b/[:`/;2`/;200:j^[X00k6a/JRXZ:RXZ002WinO00>EUIF<S8b<S8`00XB4Q003O7al
MGEeMGEe009`L703KFe]0W1`L003MWIfOGemOGem00:5QHD00hb<S9:BTY:BTP02UIFE00>CTi>=SHf=
SHd00X:2PP03MGEeIVIVIVIV009HF5P00d];Bd92@T92@P02?Shn00<o?cm6ATI6ATH00U5AD@03GemO
Kfm_Kfm_00:0P8000i6ATJ6QXJ6QX@02[jn_00>k^k_5aLG5aLD00/k>cP03e]KFgMgMgMgM00;QhN40
0nGUiNKVi^KViP02inOW00?Vi^KTi>CTi>@00^7Qh@03g]kNfm_Kfm_K00;IfMT5f=SH0]WIf@03fm_K
g=cLg=cL00;Ng]h00moOgn3Ph>3Ph002h>3P0moOg`;Ng]h3gMgM2=cLg1KMgMd4oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo4Ve]K@a^KVh=KFe]0Vi^KP9_Kfl00g5aLG9bLW9bLP02LG5a0Vi^
KP03JVYZIVIVIVIV009VIVH00fYZJW1`L71`L002MWIf00=hN7QdM7AdM7@00Va/K003I6ATHf=SHf=S
009YJFT00gMgMhF5QHF5Q@02SXj>00>?Shn9RHV9RHT00X:2PP03PH61RHV9RHV900:GUiL00j6QXIjN
WYjNWP02QhN700=UIFE4A4A4A4@00S<c<`03>c/kEEEEEEEE009`L7000ginOWEeMGEeM@02Fe]K00=3
@d<k>c/k>c/00Ta<C003Kfm_Ti>CTi>C00:[Zj/00jn_[j>SXj>SX`02T92@00=kNg]ZJVYZJVX00UeM
G@=EEED2GemO00=^KVinOWinOWh00XR8R003QHF5NGUiNGUi009[Jf/00emOGeaLG5aLG002GemO00=U
IFEZJVYZJVX00Ve]K@03KVi^Kfm_Kfm_009`L702LG5a0g9bLP9aLG400g1`L6i^KVi^KP02K6a/1V][
J`9/K6`3KFe]3Vi^KPY]KFd3KVi^1Fe]K@Coool00`000?ooooooo`0@oooo000Uoooo00<0003ooooo
ool00_ooo`GMgMd8g]kN1mgMg@SLg=`5gMgM1mkNgP;MgMd3g=cL1m_Kf`;Lg=`00mkNg]oOgmoOg`02
h>3P00?QhN7Ph>3Ph>000]oOg`03g=cLemOGemOG00;AdM400l[:b/;2`/;2`P02^[Zj00>a/K6XZ:RX
Z:P00YnOW`03UIFES8b<S8b<00:4Q8@00galO7EeMGEeM@02L71`0fe]K@9`L7000gIfMWemOGemO@02
QHF500><S8bBTY:BTY800YFEU@03Ti>CSHf=SHf=00:2PX800gEeMFIVIVIVIP02F5QH00=;Bd]2@T92
@T800Shn?P03?cloATI6ATI6009ADE400emOGfm_Kfm_K`02P82000>ATI6QXJ6QXJ400Zn_[`03^k^k
aLG5aLG500;>c/h00mKFe]gMgMgMg@02hN7Q00?UiNGVi^KVi^H00^OWi`03i^KVi>CTi>CT00;QhN40
0mkNg]_Kfm_Kf`02fMWI1MSHf0;IfMT00m_KfmcLg=cLg002g]kN00?OgmoPh>3Ph>000^3Ph0?Ogml2
g]kN0mgMg@SLg=`FgMgM1?ooo`030000oooooooo03;oool010000?oooooooooooa9]KFd<KVi^3Fe]
K@9^KVh2Kfm_00=aLG5bLW9bLW800W5aL@9^KVh00fYZJVIVIVIVIP02IVIV00=ZJVY`L71`L7000WIf
MP03N7QhM7AdM7Ad009/K6`00fATI6=SHf=SH`02JFUY00=gMgN5QHF5QHD00Xj>SP03Shn?RHV9RHV9
00:2PX800h61PHV9RHV9R@02UiNG00>QXJ6NWYjNWYh00XN7Q`03IFEUA4A4A4A4008c<c<00c/k>eEE
EEEEE@02L71`00=nOWieMGEeMGD00U]KF`03@d=3>c/k>c/k009<C4`00fm_Ki>CTi>CT`02Zj^[00>_
[jnSXj>SXj<00Y2@T003Ng]kJVYZJVYZ009MGEd3EEEE0UmOG`03KVi^OWinOWin00:8R8P00hF5QGUi
NGUiN@02Jf][00=OGemLG5aLG5`00UmOG`03IFEUJVYZJVYZ009]KFd00fi^KVm_Kfm_K`02L71`0W5a
L@=bLW82LG5a00=`L71^KVi^KVh00Va/K0I[Jf/2K6a/0fe]K@i^KVh:KFe]0fi^KPE]KFd4oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool:gMgM0mkNgQ?MgMd8g]kN0mgMg@;Lg=`7
fm_K0]cLg003g]kNgmoOgmoO00;Ph>03hN7Q0]oOg`03gMgMfMWIfMWI00;De=@00lk>c/O7alO7a`02
_kno00>h^;R`/;2`/;000ZNWY`03WinOUiNGUiNG00:?Shl00hR8R861PH61P@02O7al0gUiN@9lO7`0
0h61PHR8R8R8R002Shn?00>FUYJKVi^KVi/00YfMW@03W9bLUIFEUIFE00:;Rh/00gmoOg5aLG5aL@02
Hf=S00=HF5Q@D51@D5000Ta<C003CTi>E5ADE5AD009PH6000fe]KGemOGemO@02SHf=00>MWIf[Zj^[
Zj/00[Rh^003`l?3bl_;bl_;00;Bd]800mSHf=gMgMgMg@02hN7Q00?Shn?Ti>CTi>@00nCTi0;Rh^82
h>3P00?Ng]kLg=cLg=`00][JfPGIfMT2f][J00?Kfm_Lg=cLg=`00mkNgPGOgml2g]kN0mgMg@[Lg=`?
gMgM1McLg0;MgMd4oooo00<0003oooooool0<_ooo`040000oooooooooooo0fi^KQ=]KFd5KVi^1Ve]
K@E/K6`5KFe]0Vi^KP9_Kfl5L71`0Vi^KP03Jf][JFUYJFUY009XJ6P00fYZJVe]KFe]K@02L71`0g9b
LP9aLG400g1`L6i^KVi^KP02KFe]00=^KViaLG5aLG400WMgM`03OgmoRXZ:RXZ:00:DU9@00ifMWJJV
YZJVYP02Zj^[00>/[:bTY:BTY:@00Y:BTP03Ng]kIVIVIVIV009MGEd00fIVIW]kNg]kN`02TI6A00>L
W9bDU9BDU9@00WmoO`03JVYZHF5QHF5Q009/K6`00hB4Q9fMWIfMW@03[Jf]0Z6QX@:@T9000gmoOg5a
LG5aL@02J6QX0f5QH@9WIfL00g5aLG]kNg]kN`02PH6100=nOWifMWIfMWH00V][J`03Hf=SH61PH61P
009SHf<00fMWIf][Jf][J`02KFe]00=^KVi_Kfm_Kfl00Vm_K`9`L703LG5a0W1`L003Kfm_KVi^KVi^
009]KFd00fa/K6][Jf][J`05K6a/0fe]K@i^KVh6KFe]36i^KPCoool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`[MgMd3g]kN4mgMg@SNg]h3gMgM0]cLg0OKfm/2g=cL00?Ng]kOgmoO
gml00^3Ph0?QhN42gmoO00?MgMgIfMWIfMT00]CDe003c/k>alO7alO700:o_kl00kRh^;2`/;2`/002
YjNW00>OWinGUiNGUiL00Xn?S`03R8R8PH61PH61009lO7`3NGUi0WalO003PH61R8R8R8R800:?Shl0
0iJFUY^KVi^KV`02WIfM00>LW9bEUIFEUID00X^;R`03OgmoLG5aLG5a009SHf<00eQHF51@D51@D002
C4a<00=>CTiDE5ADE5@00V1PH003KFe]OGemOGem00:=SHd00ifMWJ^[Zj^[Z`02^;Rh00?3`l?;bl_;
bl/00];BdP03f=SHgMgMgMgM00;QhN400n?ShnCTi>CTi003i>CT0^;RhP;Ph>000mkNg]cLg=cLg002
f][J1MWIf@;Jf]X00m_KfmcLg=cLg003g]kN1MoOg`;Ng]h3gMgM2]cLg0oMgMd5g=cL0]gMg@Coool0
0`000?ooooooo`0boooo00@0003oooooooooool3KVi^4fe]K@E^KVh6KFe]1Fa/K0E]KFd2KVi^0Vm_
K`E`L702KVi^00=[Jf]YJFUYJFT00VQXJ003JVYZKFe]KFe]009`L703LW9b0W5aL@03L71`KVi^KVi^
009]KFd00fi^KW5aLG5aL@02MgMg00=oOgn:RXZ:RXX00YBDU003WIfMYZJVYZJV00:[Zj/00jb/[:BT
Y:BTY002TY:B00=kNg]VIVIVIVH00UeMG@03IVIVNg]kNg]k00:ATI400ibLW9BDU9BDU002Ogmo00=Z
JVYQHF5QHF400Va/K003Q8B4WIfMWIfM00>][Jd2XJ6Q0Y2@T003OgmoLG5aLG5a009XJ6P3HF5Q0VMW
I`03LG5aNg]kNg]k00:1PH400ginOWIfMWIfMP02Jf][00=SHf=PH61PH6000V=SH`03IfMWJf][Jf][
009]KFd00fi^KVm_Kfm_K`02Kfm_0W1`L0=aLG42L71`00=_Kfm^KVi^KVh00Ve]K@03K6a/Jf][Jf][
00E/K6`3KFe]3Vi^KPI]KFd<KVi^1?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02
oooo0mcLg1SMgMd6g]kN1=oOg`?Ng]h3gMgM0]cLg0OKfm/2g=cL00?Ng]kOgmoOgml00^3Ph0?QhN42
h>3P00?Ng]kKfm_Kfm/00]KFeP03dM7Abl_;bl_;00;4a<@00kjn_[Ng]kNg]`02/;2`00>XZ:RQXJ6Q
XJ400Y^KV`03UIFEShn?Shn?00:;Rh/3RHV90X^;R`03Shn?UIFEUIFE00:KVi/00j2PX:BTY:BTY002
YZJV00>TY:BNWYjNWYh00YFEU@03RXZ:OGemOGem009aLG400fMWIf1PH61PH002GEeM00=OGemVIVIV
IVH00W5aL@03OWinS8b<S8b<00:KVi/00jZZZ[Ng]kNg]`02`L7100?:b/[AdM7AdM400]KFeP03f][J
gMgMgMgM00;Ogml00n7QhN;Rh^;RhP02h^;R0n7Qh@;Ogml00mgMgMcLg=cLg002fm_K1M[JfP?Kfm/2
g=cL0]gMg@KNg]h4gMgM3McLg0[MgMd:g=cL1?ooo`030000oooooooo03;oool010000?oooooooooo
o`M^KVhGKFe]2Va/K09]KFd3KVi^1fm_K`9^KVh00fe]KFa/K6a/K002Jf][00=ZJVYYJFUYJFT00VUY
J@03Jf][L71`L71`009fMWH00g]kNgYjNWYjNP02LG5a00=UIFELG5aLG5`00UeMG@03K6a/QHF5QHF5
00:OWil00k>c/kZj^[Zj^P02]kNg00>_[jnSXj>SXj<00YNGU`03SHf=QXJ6QXJ600:6QXH00i2@T:2P
X:2PX002/;2`00>g]kNa/K6a/K400Z6QX@03T92@QXJ6QXJ600:9RHT00iBDU:6QXJ6QX@02YjNW00>T
Y:BIVIVIVIT00Xb<S003OgmoMWIfMWIf009aLG43KFe]0W1`L003M7AdNGUiNGUi009kNg/00gQhN79b
LW9bLP02K6a/00=WIfMUIFEUIFD00VIVIP03JFUYJf][Jf][009]KFd3KVi^0Vm_K`M`L7000fm_Kfi^
KVi^KP02KFe]1Fa/K0E]KFdQKVi^1?ooo`030000oooooooo013oool002Goool200000oooo`OLg=`6
gMgM3mkNgP[Ogml2g]kN0mgMg@;Lg=`7fm_K0]cLg003g]kNgmoOgmoO00;Ph>000n7QhN;Rh^;RhP02
hN7Q00?Ph>3MgMgMgMd00]WIf@03e=CDc/k>c/k>00;9bLT00l?3`kfm_Kfm_@02]kNg00>a/K6/[:b/
[:`00ZNWY`03XZ:RWinOWinO00:LW9`3VYZJ0YbLW003WinOXj>SXj>S00:XZ:P00jb/[:j^[Zj^[P02
[jn_00>][JfWYjNWYjL00YnOW`03UIFERh^;Rh^;00:0P8000gQhN79bLW9bLP02L71`00=cLg=iNGUi
NGT00X>3P`03Shn?W9bLW9bL00:ZZZX00kJf]/71`L71`@02b/[:00?AdM7Fe]KFe]H00]WIf@03g=cL
gMgMgMgM00;Ng]h8gmoO0]kNgP03gMgMg=cLg=cL00WKfm/3g=cL2]gMg@oLg=`7gMgM3McLg0?oool2
0000=?ooo`040000oooooooooooo0Vm_K`Q^KVh7KFe]3fa/K0E[Jf/3K6a/0Ve]K@=^KVh5Kfm_1fi^
KP9/K6`00fYZJVMWIfMWI`02I6AT00=VIVI^KVi^KVh00WUiN@>2PX82MGEe00=QHF5@D51@D5000Ta<
C003GEeMO7alO7al00:LW9`00kBd];Zj^[Zj^P02/[:b00>VYZJKVi^KVi/00YJFUP03UiNGVYZJVYZJ
00:QXJ400jVYZK>c/k>c/`02^k^k00>o_knj^[Zj^[X00[6a/@03YJFUW9bLW9bL00:HV9P00iVIVIZJ
VYZJVP02VIVI00>DU9B;Rh^;Rh/00X>3P`03O7alN7QhN7Qh00YfMWH2MGEe00=bLW9_Kfm_Kfl00Va/
K003JVYZJFUYJFUY009ZJVX00f][Jfa/K6a/K002KFe]0fi^KPE_Kfl2L71`0fm_K`A^KVh6KFe]1fi^
KPE_KflBKVi^1fm_K`?oool200004_ooo`009Oooo`030000oooooooo00;oool7g=cL1]gMg@oNg]h:
gmoO0]kNgP?MgMd2g=cL1m_Kf`;Lg=`00mkNg]oOgmoOg`02h>3P00?QhN7Rh^;Rh^800^7Qh@03h>3P
gMgMgMgM00;IfMT00mCDe<k>c/k>cP02bLW900?3`l>m_Kfm_Kd00[Ng]`03/K6a[:b/[:b/00:WYjL0
0j:RXYnOWinOW`02W9bL0iZJVP:LW9`00inOWj>SXj>SX`02Z:RX00>/[:b^[Zj^[Zh00Zn_[`03[Jf]
YjNWYjNW00:OWil00iFEUH^;Rh^;R`02P82000=hN7QbLW9bLW800W1`L003Lg=cNGUiNGUi00:3Ph<0
0hn?SibLW9bLW002ZZZZ00>f][K1`L71`L400/[:bP03dM7Ae]KFe]KF00;IfMT00mcLg=gMgMgMg@02
g]kN2=oOg`;Ng]h00mgMgMcLg=cLg009fm_K0mcLg0[MgMd?g=cL1mgMg@gLg=`4oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0Vm_K`Q^KVh7KFe]3fa/K0E[Jf/3K6a/0Ve]K@=^KVh5Kfm_1fi^
KP9/K6`00fYZJVMWIfMWI`02I6AT00=VIVI^KVi^KVh00WUiN@>2PX82MGEe00=QHF5@D51@D5000Ta<
C003GEeMO7alO7al00:LW9`00kBd];Zj^[Zj^P02/[:b00>VYZJKVi^KVi/00YJFUP03UiNGVYZJVYZJ
00:QXJ400jVYZK>c/k>c/`02^k^k00>o_knj^[Zj^[X00[6a/@03YJFUW9bLW9bL00:HV9P00iVIVIZJ
VYZJVP02VIVI00>DU9B;Rh^;Rh/00X>3P`03O7alN7QhN7Qh00YfMWH2MGEe00=bLW9_Kfm_Kfl00Va/
K003JVYZJFUYJFUY009ZJVX00f][Jfa/K6a/K002KFe]0fi^KPE_Kfl2L71`0fm_K`A^KVh6KFe]1fi^
KPE_KflBKVi^1fm_K`Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`?Kfm/5
g=cL1MgMg@ONg]h<gmoO0n3Ph0?Ogml4g]kN00?MgMgLg=cLg=`01m_Kf`;Lg=`00mkNg]oOgmoOg`02
hN7Q1N;RhP03hN7Qg]kNg]kN00;Kfm/00mKFe]7AdM7Ad@02c<c<00?7alO2`/;2`/800[fm_@03^KVi
]KFe]KFe00:c/k<00k2`/:j^[Zj^[P02[Jf]00>/[:b][Jf][Jd00Zj^[P03/;2`/[:b/[:b00:e]KD0
0kNg]kRh^;Rh^002^;Rh00>e]KF`/;2`/;000ZVYZ@03XJ6QV9RHV9RH00:@T9000hZ:RXF5QHF5Q@02
Q8B400>7QhN=SHf=SHd00YJFUP03XJ6Q[:b/[:b/00:g]kL00l;2`/_;bl_;b`02d];B00?GemOJf][J
f]X00]cLg13MgMd4g=cL1m_Kf`KLg=`2gMgM2=cLg0OKfm/Bg=cL1m_Kf`Coool00`000?ooooooo`0b
oooo00@0003oooooooooool3Kfm_1fi^KPE]KFd:K6a/3F][J`9/K6`2KFe]00=^KVi_Kfm_Kfl01Fm_
K`M^KVh2K6a/00=YJFUUIFEUIFD00V=SH`03IFEUKFe]KFe]009hN7P00h61PH:2PX:2PP02MgMg00=U
IFEEEEEEEED00Tm?C`03FEUIKVi^KVi^00:6QXH00iRHV9fMWIfMW@02VIVI00>BTY:=SHf=SHd00Xj>
SP03U9BDVi^KVi^K00:QXJ400jFUYJNWYjNWY`02Z:RX00>WYjNUYJFUYJD00Z:RXP03WIfMUiNGUiNG
00:BTY800hb<S8J6QXJ6QP02PX:200=mOGejNWYjNWX00WMgM`03MWIfMgMgMgMg009hN7P3NGUi0WQh
N003MGEeLW9bLW9b009`L7000fi^KVe]KFe]K@0:KFe]1fi^KPQ_Kfl>KVi^2Vm_K`m^KVh8Kfm_1?oo
o`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0m_Kf`GLg=`5gMgM1mkNgPcOgml3
h>3P0moOg`CNg]h00mgMgMcLg=cLg007fm_K0]cLg003g]kNgmoOgmoO00;QhN45h^;R00?QhN7Ng]kN
g]h00]_Kf`03e]KFdM7AdM7A00;<c<`00lO7al;2`/;2`P02_Kfm00>i^KVe]KFe]KD00[>c/`03/;2`
[Zj^[Zj^00:][Jd00jb/[:f][Jf][@02[Zj^00>`/;2b/[:b/[800[Fe]@03]kNg^;Rh^;Rh00:h^;P0
0kFe]K2`/;2`/002ZJVY00>QXJ6HV9RHV9P00Y2@T003RXZ:QHF5QHF500:4Q8@00hN7Qhf=SHf=S@02
UYJF00>QXJ6/[:b/[:`00[Ng]`03`/;2bl_;bl_;00;Bd]800mOGem[Jf][JfP02g=cL4=gMg@CLg=`7
fm_K1]cLg0;MgMd8g=cL1m_Kfa;Lg=`7fm_K1?ooo`030000oooooooo03;oool010000?oooooooooo
o`=_Kfl7KVi^1Fe]K@Y/K6`=Jf][0Va/K09]KFd00fi^KVm_Kfm_K`05Kfm_1fi^KP9/K6`00fUYJFEU
IFEUI@02Hf=S00=UIFE]KFe]KFd00WQhN003PH61PX:2PX:2009gMgL00fEUIEEEEEEEE@02Cdm?00=I
FEU^KVi^KVh00XJ6QP03V9RHWIfMWIfM00:IVIT00i:BTXf=SHf=S@02SXj>00>DU9BKVi^KVi/00Z6Q
X@03YJFUYjNWYjNW00:XZ:P00jNWYjFUYJFUY@02XZ:R00>MWIfGUiNGUiL00Y:BTP03S8b<QXJ6QXJ6
00:2PX800gemOGYjNWYjNP02MgMg00=fMWIgMgMgMgL00WQhN0=iNGT2N7Qh00=eMGEbLW9bLW800W1`
L003KVi^KFe]KFe]00Y]KFd7KVi^26m_K`i^KVh:Kfm_3fi^KPQ_Kfl4oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool5fm_K0mcLg0CMgMd5g]kN1]oOg`kPh>03gmoO0]kNgP03gMgM
g=cLg=cL00?Kfm/2f][J0]_Kf`;Lg=`00mgMgMoOgmoOg`02hN7Q00?Rh^;Shn?Shn<00^?Sh`03h^;R
h>3Ph>3P00;Lg=`00mSHf=CDe=CDe002clo?00?:b/[6a/K6a/H00/?3``03`<30_[jn_[jn00Rm_Kd2
_[jn0[no_`03`<30`L71`L7100;1`L400l;2`/71`L71`@02`<3000>m_Kfh^;Rh^;P00[:b/P03[:b/
YJFUYJFU00:OWil00i^KViRHV9RHV002V9RH00>KVi^PX:2PX:000ZRXZ003/K6a^k^k^k^k00;4a<@0
0lg=cMCDe=CDe002fMWI00?Lg=cNg]kNg]h00mkNgPCMgMd00mcLg=_Kfm_Kf`02fm_K7]cLg0[Kfm/A
g=cL2=_Kf`Coool00`000?ooooooo`0boooo00@0003oooooooooool5Kfm_0fi^KPM]KFd5K6a/4V][
J`9/K6`2KFe]0fi^KPM_Kfl3KVi^0Ve]K@9[Jf/00fUYJFIVIVIVIP02I6AT00=UIFE[Jf][Jf/00W=c
L`03NWYjOGemOGem009iNGT00g1`L6IVIVIVIP02GemO00=MGEeOGemOGel00VATI003JVYZKVi^KVi^
009bLW800gIfMW]kNg]kN`02PX:200>8R8R=SHf=SHd00Xn?S`03S8b<QXJ6QXJ6009oOgl3Ng]k0Win
OP>1PH42O7al00=dM7A/K6a/K6`00VIVIP03IFEUIfMWIfMW009[Jf/00fm_Kg=cLg=cL`02MWIf0gQh
N09fMWH00g9bLVi^KVi^KP03Jf][0Va/K09^KVh00fm_Kg1`L71`L003Kfm_3Vi^KP=_Kfl9KVi^3fm_
K`e^KVh:Kfm_1?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0m_Kf`GLg=`4
gMgM1MkNgPGOgml?h>3P0moOg`;Ng]h00mgMgMcLg=cLg003fm_K0][JfP;Kfm/2g=cL00?MgMgOgmoO
gml00^7Qh@03h^;Ri>CTi>CT00;Ti>@00n?Shn7QhN7Qh@02g]kN00?Jf][EeMGEeMD00]7Ad@03cLg=
b/[:b/[:00;7alL3a/K60/O7a`03b<S8b/[:b/[:00;;bl/00lc<c<g=cLg=c@03c/k>0/g=c@;<c<`0
0l_;blW9bLW9b@02alO700?4a<Bo_kno_kl00[^k^`03][Jf/[:b/[:b00:^[Zh00j^[ZjVYZJVYZ@02
ZZZZ00>][Jfb/[:b/[800[Rh^003`<30b<S8b<S800;?cll00mKFe]_Kfm_Kf`02gmoO00?Ph>3QhN7Q
hN400^3Ph003gmoOgMgMgMgM00;Lg=`00m_Kfm[Jf][JfP03f][J1=_Kf`?Lg=`5gMgM2]cLg17Kfm/?
g=cL2]_Kf`Coool00`000?ooooooo`0boooo00@0003oooooooooool3Kfm_1Fi^KPM]KFd5K6a/4V][
J`9/K6`3KFe]0Vi^KP9_Kfl3L71`16m_K`03KFe]K6a/K6a/009ZJVX00fQXJ6IVIVIVIP02IVIV00=W
IfMZJVYZJVX00Vi^KP03LW9bMWIfMWIf009jNWX00galO7YjNWYjNP02Lg=c00=TI6ABDU9BDU800T92
@P03>SXj?Shn?Shn009:BTX00e]KFfYZJVYZJP02M7Ad00=iNGUjNWYjNWX00WIfMP03K6a/H61PH61P
009DE5@00de=CDm?Cdm?C`02EeMG00=PH61UIFEUIFD00V=SH`03Fe]KDU9BDU9B009>CTh00e1@D5MG
EeMGE`02H61P00=XJ6Q^KVi^KVh00W9bLP=dM7@2LW9b00=^KVi[Jf][Jf/00fUYJ@9[Jf/2KVi^1G5a
L@03L71`Kfm_Kfm_00m^KVhIKfm_2Vi^KPa_Kfl4oooo00<0003oooooool04?ooo`009Oooo`030000
oooooooo00;oool3fm_K1McLg0CMgMd5g]kN1MoOg`oPh>03gmoO0]kNgP03gMgMg=cLg=cL00?Kfm/2
f][J0]_Kf`;Lg=`00mgMgMoOgmoOg`02hN7Q00?Rh^;Ti>CTi>@00^CTi003hn?ShN7QhN7Q00;Ng]h0
0m[Jf]GEeMGEe@02dM7A00?=cLg:b/[:b/X00/O7a`?6a/H2alO700?8b<S:b/[:b/X00/_;b`03c<c<
cLg=cLg=00?>c/h2cLg=0/c<c003bl_;bLW9bLW900;7alL00lC4a;no_kno_`02^k^k00>f][Jb/[:b
/[800Zj^[P03Zj^[ZJVYZJVY00:ZZZX00jf][K:b/[:b/P02^;Rh00?0`<38b<S8b<P00/o?c`03e]KF
fm_Kfm_K00;Ogml00n3Ph>7QhN7Qh@02h>3P00?OgmoMgMgMgMd00]cLg003fm_Kf][Jf][J00?Jf]X4
fm_K0mcLg0GMgMd:g=cL4M_Kf`oLg=`:fm_K1?ooo`030000oooooooo03;oool010000?oooooooooo
o`=_Kfl5KVi^1fe]K@E/K6`BJf][0Va/K0=]KFd2KVi^0Vm_K`=`L704Kfm_00=]KFe/K6a/K6`00VYZ
JP03J6QXIVIVIVIV009VIVH00fMWIfYZJVYZJP02KVi^00=bLW9fMWIfMWH00WYjNP03O7alNWYjNWYj
009cLg<00fATI59BDU9BDP02@T9200<j>SXn?Shn?Sh00TY:BP03Fe]KJVYZJVYZ009dM7@00gUiNGYj
NWYjNP02MWIf00=/K6aPH61PH6000UADE003CDe=Cdm?Cdm?009GEeL00f1PH6EUIFEUI@02Hf=S00=K
Fe]BDU9BDU800Ti>CP03D51@EeMGEeMG009PH6000fQXJ6i^KVi^KP02LW9b0gAdM09bLW800fi^KV][
Jf][J`03JFUY0V][J`9^KVh5LG5a00=`L71_Kfm_Kfl03fi^KQU_Kfl:KVi^36m_K`Coool00`000?oo
ooooo`0@oooo000Uoooo00<0003oooooool00_ooo`?Kfm/5g=cL1=gMg@GNg]h8gmoO3>3Ph003gmoO
g]kNg]kN00;Ng]h00mgMgMcLg=cLg002fm_K0m[JfP;Kfm/2g=cL00?MgMgOgmoOgml00^7Qh@03h^;R
hn?Shn?S00;Ti>@00n?Shn7QhN7Qh@02g]kN00?Kfm_GemOGemL00]?Cd`03d=3@cLg=cLg=00;<c<`0
0l_;blg=cLg=c@02clo?00?AdM7De=CDe=@00]KFeP03f=SHfMWIfMWI00?IfMT2emOG0]GEe@03d];B
d=3@d=3@00;=cLd00lW9bLK6a/K6aP02`/;200>o_knl_;bl_;`00[Zj^P03^KVi^;Rh^;Rh00:j^[X0
0kfm_L71`L71`@02a/K600?<c<cBd];Bd]800]SHf003gMgMh>3Ph>3P00;Rh^83hn?S0^7Qh@03gmoO
gMgMgMgM00;Kfm/00m[Jf]WIfMWIf@02fMWI0m[JfP;Kfm/00mcLg=gMgMgMg@07gMgM1mcLg13Kfm/C
g=cL2=_Kf`Coool00`000?ooooooo`0boooo00@0003oooooooooool3Kfm_1Fi^KPM]KFd7K6a/46][
J`9/K6`3KFe]0Vi^KP9_Kfl5L71`0Vm_K`03KFe]Jf][Jf][009YJFT5J6QX00=YJFUZJVYZJVX00VYZ
JP03Jf][L71`L71`009iNGT00h>3PhR8R8R8R002PX:200=[Jf]<C4a<C4`00Rl_;`037QhN820P820P
008a<C400dM7AeaLG5aLG002IfMW00=[Jf]YJFUYJFT00V5QH@03EEEEADE5ADE5008g=cL00bl_;c8b
<S8b<P02?3`l00=9BDUBDU9BDU800U5AD@03Bd];A4A4A4A40091@D400dE5ADm?Cdm?C`02FUYJ00=T
I6AZJVYZJVX00Vi^KP=_Kfl2KFe]00=[Jf]XJ6QXJ6P00VMWI`03J6QXJf][Jf][009_Kfl00g5aLG9b
LW9bLP02LW9b00=aLG5_Kfm_Kfl00Vm_K`=^KVh7KFe]1Fi^KQI_Kfl=KVi^2Vm_K`Coool00`000?oo
ooooo`0@oooo000Uoooo0P0000?oool3fm_K1McLg0CMgMd5g]kN2=oOg`cPh>000moOgmkNg]kNgP02
g]kN00?MgMgLg=cLg=`00]_Kf`?Jf]X2fm_K0]cLg003gMgMgmoOgmoO00;QhN400n;Rh^?Shn?Sh`02
i>CT00?Shn?QhN7QhN400]kNgP03fm_KemOGemOG00;Cdm<00m3@d<g=cLg=c@02c<c<00?;bl_=cLg=
cLd00/o?c`03dM7Ae=CDe=CD00;Fe]H00mSHf=WIfMWIf@03fMWI0]OGe`;EeMD00m;Bd]3@d=3@d002
cLg=00?9bLW6a/K6a/H00/;2`P03_kno_;bl_;bl00:j^[X00kVi^KRh^;Rh^002^[Zj00>m_Kg1`L71
`L400/K6aP03c<c<d];Bd];B00;Hf=P00mgMgN3Ph>3Ph002h^;R0n?Sh`;QhN400moOgmgMgMgMg@02
fm_K00?Jf][IfMWIfMT00]WIf@?Jf]X2fm_K00?Lg=cMgMgMgMd01mgMg@OLg=`@fm_K4mcLg0SKfm/3
oooo0P0003Coool010000?ooooooooooo`=_Kfl5KVi^1fe]K@M/K6`@Jf][0Va/K0=]KFd2KVi^0Vm_
K`E`L702Kfm_00=]KFe[Jf][Jf/00VUYJ@EXJ6P00fUYJFYZJVYZJP02JVYZ00=[Jf]`L71`L7000WUi
N@03Ph>3R8R8R8R800:2PX800f][Jda<C4a<C002;bl_00<N7QhP820P82000S4a<@03AdM7G5aLG5aL
009WIfL00f][JfUYJFUYJ@02HF5Q00=EEEE5ADE5ADD00SLg=`03;bl_<S8b<S8b008l?3`00dU9BE9B
DU9BDP02DE5A00=;Bd]4A4A4A4@00T51@@03ADE5Cdm?Cdm?009JFUX00fATI6YZJVYZJP02KVi^0fm_
K`9]KFd00f][JfQXJ6QXJ002IfMW00=XJ6Q[Jf][Jf/00Vm_K`03LG5aLW9bLW9b009bLW800g5aLFm_
Kfm_K`02Kfm_0fi^KPM]KFd5KVi^5Vm_K`e^KVh:Kfm_0oooo`80000Boooo000Uoooo00<0003ooooo
ool00_ooo`GLg=`8gMgM3mkNgPWOgml3g]kN0]gMg@?Lg=`2fm_K0m[JfPCKfm/00mgMgMkNg]kNgP02
h>3P00?Rh^;Shn?Shn<00n?Sh`;QhN42gmoO00?Kfm_Hf=SHf=P00]GEe@03d];Bd=3@d=3@00;?cll0
0m3@d=;Bd];BdP02e=CD00?GemOKfm_Kfm/00]gMg@03h>3PhN7QhN7Q00;QhN400moOgmgMgMgMg@02
fm_K00?Hf=SDe=CDe=@00]7Ad@03c/k>bl_;bl_;00;9bLT00lO7alG5aLG5a@05a<C40/K6aP03b<S8
c<c<c<c<00;@d=000mGEeMWIfMWIf@02g]kN00?QhN7Ti>CTi>@00^GUi@03i>CThn?Shn?S00;Rh^80
0moOgmgMgMgMg@02fm_K00?Jf][IfMWIfMT00mWIf@;Jf]X2fm_K00?Lg=cMgMgMgMd01MkNgPGMgMd5
g=cL1=_KfbKLg=`4oooo00<0003oooooool0<_ooo`040000oooooooooooo26i^KPM]KFdGK6a/16e]
K@03KVi^Kfm_Kfm_009_Kfl5L71`0Vm_K`03KFe]Jf][Jf][009ZJVX3JFUY1FYZJP=YJFT2KVi^0WMg
M`03Ph>3RXZ:RXZ:00:5QHD00g1`L59BDU9BDP02=CDe0b8R8P8`<3000d=3@eADE5ADE002GemO00=R
HV9QHF5QHF400U]KF`03Cdm?@D51@D51008d=3@00bd];C0`<30`<002>SXj00=7AdM@D51@D5000U5A
D@03C4a<AdM7AdM70095ADD00dY:BU=CDe=CD`02G5aL00=TI6AYJFUYJFT01F][J`9ZJVX00fQXJ6MW
IfMWI`02IfMW00=YJFU[Jf][Jf/00Vm_K`03LG5aLW9bLW9b009bLW800g5aLG1`L71`L002Kfm_00=^
KVi]KFe]KFd02Fe]K@E^KVh:Kfm_8Fi^KPCoool00`000?ooooooo`0@oooo000Uoooo00<0003ooooo
ool00_ooo`GLg=`8gMgM3mkNgPWOgml3g]kN0]gMg@?Lg=`2fm_K0m[JfPCKfm/00mgMgMkNg]kNgP02
h>3P00?Rh^;Shn?Shn<00n?Sh`;QhN42gmoO00?Kfm_Hf=SHf=P00]GEe@03d];Bd=3@d=3@00;?cll0
0m3@d=;Bd];BdP02e=CD00?GemOKfm_Kfm/00]gMg@03h>3PhN7QhN7Q00;QhN400moOgmgMgMgMg@02
fm_K00?Hf=SDe=CDe=@00]7Ad@03c/k>bl_;bl_;00;9bLT00lO7alG5aLG5a@05a<C40/K6aP03b<S8
c<c<c<c<00;@d=000mGEeMWIfMWIf@02g]kN00?QhN7Ti>CTi>@00^GUi@03i>CThn?Shn?S00;Rh^80
0moOgmgMgMgMg@02fm_K00?Jf][IfMWIfMT00mWIf@;Jf]X2fm_K00?Lg=cMgMgMgMd01MkNgPGMgMd5
g=cL1=_KfbKLg=`4oooo00<0003oooooool0<_ooo`040000oooooooooooo26i^KPM]KFdGK6a/16e]
K@03KVi^Kfm_Kfm_009_Kfl5L71`0Vm_K`03KFe]Jf][Jf][009ZJVX3JFUY1FYZJP=YJFT2KVi^0WMg
M`03Ph>3RXZ:RXZ:00:5QHD00g1`L59BDU9BDP02=CDe0b8R8P8`<3000d=3@eADE5ADE002GemO00=R
HV9QHF5QHF400U]KF`03Cdm?@D51@D51008d=3@00bd];C0`<30`<002>SXj00=7AdM@D51@D5000U5A
D@03C4a<AdM7AdM70095ADD00dY:BU=CDe=CD`02G5aL00=TI6AYJFUYJFT01F][J`9ZJVX00fQXJ6MW
IfMWI`02IfMW00=YJFU[Jf][Jf/00Vm_K`03LG5aLW9bLW9b009bLW800g5aLG1`L71`L002Kfm_00=^
KVi]KFe]KFd02Fe]K@E^KVh:Kfm_8Fi^KPCoool00`000?ooooooo`0@oooo000Uoooo00<0003ooooo
ool00_ooobSMgMd3g=cL1=_Kf`?Jf]X4fm_K00?Lg=cNg]kNg]h00]oOg`03hN7Qh^;Rh^;R00?Rh^82
h>3P0]kNgP03g=cLfMWIfMWI00;Fe]H00mCDe=?Cdm?Cd`02d];B00?Cdm?EeMGEeMD00]SHf003fm_K
g]kNg]kN00;QhN400n?ShnCTi>CTi002i>CT00?Rh^;Ph>3Ph>000]gMg@03f][JemOGemOG00;De=@0
0m;Bd/o?clo?c`02c/k>00?=cLg<c<c<c<`00lc<c0;=cLd2c/k>00?AdM7De=CDe=@00]OGe`03f][J
g]kNg]kN00;QhN400n?ShnGUiNGUi@03iNGU0^?Sh`;Rh^800moOgmgMgMgMg@02fm_K00?Jf][IfMWI
fMT00]WIf@03f][Jfm_Kfm_K00;Lg=`3gMgM1mkNgPGMgMd:g=cL8mgMg@Coool00`000?ooooooo`0b
oooo00@0003oooooooooool:KVi^1fe]K@03K6a/KFe]KFe]00=]KFd4KVi^3Fe]K@=^KVh4Kfm_1G1`
L09_Kfl00fe]KFa/K6a/K002Jf][1FYZJP03Jf][JVYZJVYZ009ZJVX00f][Jfi^KVi^KP02MGEe00=m
OGf1PH61PH400WmoO`03LW9bH61PH61P009=CDd00d10@3`l?3`l?002@D5100=:BTYCDe=CDe<00UYJ
FP03GemOHF5QHF5Q009PH6000eUIFDm?Cdm?C`02ATI600=1@D53@d=3@d<00T];B`03E5ADFe]KFe]K
009MGEd00e]KFeQHF5QHF002EeMG00=JFUYOGemOGel00VEUI@03JFUYJVYZJVYZ009ZJVX00fUYJFQX
J6QXJ005IfMW0VQXJ003JVYZK6a/K6a/009_Kfl00g1`L75aLG5aL@02LG5a00=`L71_Kfm_Kfl00fi^
KP9]KFd7K6a/0fe]KA5^KVh8KFe]5Vi^KPCoool00`000?ooooooo`0@oooo000Uoooo00<0003ooooo
ool00_ooo`SNg]h5gMgM1McLg0kKfm/:g=cL1M_Kf`?Jf]X4fm_K00?Lg=cMgMgMgMd00]kNgP03gmoO
h>3Ph>3P00?Ph>02gmoO0]kNgP03g=cLf][Jf][J00;Hf=P00mKFe]GEeMGEe@02eMGE00?Fe]KHf=SH
f=P00][JfP03gMgMh>3Ph>3P00;Rh^800n?ShnCTi>CTi002i>CT00?Shn?QhN7QhN400]kNgP03fm_K
fMWIfMWI00;Fe]H00mCDe=?Cdm?Cd`02d];B1M7Ad@03d];Bdm?Cdm?C00;De=@00mKFe]WIfMWIf@02
fm_K00?Ng]kPh>3Ph>000^;RhP03i>CTiNGUiNGU00;UiND00nCTi>?Shn?Sh`02hN7Q00?OgmoMgMgM
gMd00]cLg003fm_Kf][Jf][J00;Jf]X3fm_K0]cLg003gMgMg]kNg]kN00GOgml5g]kN3=gMg@cNg]h?
gMgM2=kNgPCoool00`000?ooooooo`0boooo00@0003oooooooooool3KFe]2Vi^KPM]KFd2KVi^00=_
Kfm`L71`L7000W1`L0=_Kfl:KVi^3Vm_K`03KVi^KFe]KFe]009/K6`8Jf][0Va/K003KVi^L71`L71`
009bLW800gEeMGMgMgMgM`02MWIf00=dM7A_Kfm_Kfl00VYZJP03I6ATGemOGemO009JFUX3EeMG0UYJ
FP03GemOIFEUIFEU009XJ6P00fMWIf=SHf=SH`02GUiN00=KFe]MGEeMGEd00V5QH@03IVIVJf][Jf][
00=]KFd4K6a/00=]KFe^KVi^KVh00Vm_K`03KVi^KFe]KFe]009ZJVX00fMWIfEUIFEUI@02IFEU00=V
IVIXJ6QXJ6P00VYZJP03K6a/KFe]KFe]009^KVh00fm_Kg1`L71`L002L71`0fm_K`9^KVh00fe]KFa/
K6a/K009K6a/1Fe]K@E^KVh8KFe]0fa/K1A]KFd5K6a/0Ve]K@Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`SNg]h5gMgM1McLg0kKfm/:g=cL1M_Kf`?Jf]X4fm_K00?Lg=cMgMgM
gMd00]kNgP03gmoOh>3Ph>3P00?Ph>02gmoO0]kNgP03g=cLf][Jf][J00;Hf=P00mKFe]GEeMGEe@02
eMGE00?Fe]KHf=SHf=P00][JfP03gMgMh>3Ph>3P00;Rh^800n?ShnCTi>CTi002i>CT00?Shn?QhN7Q
hN400]kNgP03fm_KfMWIfMWI00;Fe]H00mCDe=?Cdm?Cd`02d];B1M7Ad@03d];Bdm?Cdm?C00;De=@0
0mKFe]WIfMWIf@02fm_K00?Ng]kPh>3Ph>000^;RhP03i>CTiNGUiNGU00;UiND00nCTi>?Shn?Sh`02
hN7Q00?OgmoMgMgMgMd00]cLg003fm_Kf][Jf][J00;Jf]X3fm_K0]cLg003gMgMg]kNg]kN00GOgml5
g]kN3=gMg@cNg]h?gMgM2=kNgPCoool00`000?ooooooo`0boooo00@0003oooooooooool3KFe]2Vi^
KPM]KFd2KVi^00=_Kfm`L71`L7000W1`L0=_Kfl:KVi^3Vm_K`03KVi^KFe]KFe]009/K6`8Jf][0Va/
K003KVi^L71`L71`009bLW800gEeMGMgMgMgM`02MWIf00=dM7A_Kfm_Kfl00VYZJP03I6ATGemOGemO
009JFUX3EeMG0UYJFP03GemOIFEUIFEU009XJ6P00fMWIf=SHf=SH`02GUiN00=KFe]MGEeMGEd00V5Q
H@03IVIVJf][Jf][00=]KFd4K6a/00=]KFe^KVi^KVh00Vm_K`03KVi^KFe]KFe]009ZJVX00fMWIfEU
IFEUI@02IFEU00=VIVIXJ6QXJ6P00VYZJP03K6a/KFe]KFe]009^KVh00fm_Kg1`L71`L002L71`0fm_
K`9^KVh00fe]KFa/K6a/K009K6a/1Fe]K@E^KVh8KFe]0fa/K1A]KFd5K6a/0Ve]K@Coool00`000?oo
ooooo`0@oooo000Doooo1@0000;oool00`000?ooooooo`02oooo00<0003oooooool00_ooo`030000
oooooooo00;oool5gmoO0mkNgPCMgMd00mcLg=_Kfm_Kf`02fm_K0m[JfPcIfMT3f][J4m_Kf`03g=cL
gMgMgMgM00;MgMd00mkNg]oOgmoOg`03gmoO0]kNgP;MgMd00mcLg=[Jf][JfP02fMWI1]SHf0;Jf]X2
fm_K00?MgMgOgmoOgml00^7Qh@GRh^800n7QhMoOgmoOg`02gMgM00?Kfm_IfMWIfMT00]SHf003e]KF
eMGEeMGE00;EeMD00mCDe=GEeMGEe@02eMGE00?Fe]KGemOGemL00]SHf003f][Jfm_Kfm_K00;MgMd0
0moOgn7QhN7Qh@02h^;R00?Shn?Ti>CTi>@00^CTi003hn?Sh^;Rh^;R00;QhN400moOgmkNg]kNgP03
g=cL1=_Kf`?Lg=`2gMgM00?Ng]kOgmoOgml02MoOg`gNg]h<gmoO3mkNgPSOgml4oooo00<0003ooooo
ool08?ooo`D00002oooo00<0003oooooool00_ooo`030000oooooooo00?oool010000?oooooooooo
o`=/K6`4KFe]2fi^KP9_Kfl2L71`275aL@=`L70CKfm_1Fi^KP=]KFd2K6a/0f][J`9/K6`2KVi^00=`
L71aLG5aLG400W1`L003Kfm_KVi^KVi^009_Kfl00gAdM7]kNg]kN`03P8200WYjNP9_Kfl00fATI5eM
GEeMG@02GEeM00=RHV9YJFUYJFT00Vm_K`EbLW800g5aLG9bLW9bLP02Lg=c00=eMGEgMgMgMgL00WQh
N003NWYjNg]kNg]k009lO7`00g]kNgUiNGUiN@02MWIf00=cLg=^KVi^KVh00VYZJP03IfMWIFEUIFEU
009UIFD00fIVIVUYJFUYJ@02Jf][00=]KFe^KVi^KVh02Vi^KP9]KFd3K6a/1f][J`E/K6`7KFe]1Va/
K0E[Jf/7K6a/26e]K@E/K6`7Jf][1?ooo`030000oooooooo013oool001Koool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000000oooo`030000oooooooo00;oool5gmoO0mkNgPCMgMd0
0mcLg=_Kfm_Kf`02fm_K0m[JfPcIfMT3f][J4m_Kf`03g=cLgMgMgMgM00;MgMd00mkNg]oOgmoOg`03
gmoO0]kNgP;MgMd00mcLg=[Jf][JfP02fMWI1]SHf0;Jf]X2fm_K00?MgMgOgmoOgml00^7Qh@GRh^80
0n7QhMoOgmoOg`02gMgM00?Kfm_IfMWIfMT00]SHf003e]KFeMGEeMGE00;EeMD00mCDe=GEeMGEe@02
eMGE00?Fe]KGemOGemL00]SHf003f][Jfm_Kfm_K00;MgMd00moOgn7QhN7Qh@02h^;R00?Shn?Ti>CT
i>@00^CTi003hn?Sh^;Rh^;R00;QhN400moOgmkNg]kNgP03g=cL1=_Kf`?Lg=`2gMgM00?Ng]kOgmoO
gml02MoOg`gNg]h<gmoO3mkNgPSOgml4oooo00<0003oooooool08_ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`000004oooo00@0003oooooooooool3K6a/16e]K@]^KVh2Kfm_0W1`
L0QaLG43L71`4fm_K`E^KVh3KFe]0Va/K0=[Jf/2K6a/0Vi^KP03L71`LG5aLG5a009`L7000fm_Kfi^
KVi^KP02Kfm_00=dM7AkNg]kNg/00h20P09jNWX2Kfm_00=TI6AMGEeMGEd00UeMG@03HV9RJFUYJFUY
009_Kfl5LW9b00=aLG5bLW9bLW800W=cL`03MGEeMgMgMgMg009hN7P00gYjNW]kNg]kN`02O7al00=k
Ng]iNGUiNGT00WIfMP03Lg=cKVi^KVi^009ZJVX00fMWIfEUIFEUI@02IFEU00=VIVIYJFUYJFT00V][
J`03KFe]KVi^KVi^00Y^KVh2KFe]0fa/K0M[Jf/5K6a/1fe]K@I/K6`5Jf][1fa/K0Q]KFd5K6a/1f][
J`Coool00`000?ooooooo`0@oooo000Foooo00L0003oooooooooool0003oool000000_ooo`030000
oooo000000?oool300000_ooo`?Ph>02gmoO0mkNgP;MgMd2g=cL00?Kfm_Jf][Jf]X00][JfP03fMWI
f=SHf=SH00[GemL3f=SH0]WIf@GJf]X<fm_K1McLg0[MgMd3g=cL0]_Kf`SJf]X2fm_K0]cLg003gMgM
g]kNg]kN00;Ng]h5gmoO00?Ng]kMgMgMgMd00]cLg003f][JfMWIfMWI00?Hf=P5emOG1=SHf003fMWI
f][Jf][J00;Kfm/00mcLg=gMgMgMg@02g]kN00?OgmoPh>3Ph>000^7Qh@GRh^83hN7Q0^3Ph003gmoO
g]kNg]kN00SMgMd4g]kN0moOg`OPh>0=gmoO3^3Ph0GOgml5g]kN0moOg`GPh>03hN7Q0^3Ph0?oool2
00009?ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo0P0000;oool2
JVYZ0f][J`9/K6`3KFe]0Vi^KP03Kfm_L71`L71`009aLG43LW9b2W=cL`=bLW84LG5a0g1`L0a_Kfl8
KVi^0Ve]K@=/K6`2KFe]0Vm_K`=aLG42Kfm_00=/K6aZJVYZJVX00Va/K003Lg=cO7alO7al00:4Q8@0
0hN7Qh:2PX:2PP02N7Qh00=]KFeUIFEUIFD00V=SH`03IfMWKFe]KFe]009cLg<00gIfMWQhN7QhN002
NGUi1GYjNP=iNGT2Ng]k00=mOGeoOgmoOgl00WmoO`03OWinNg]kNg]k009gMgL00g=cLfm_Kfm_K`02
Jf][00=XJ6QVIVIVIVH00VIVIP03J6QXJVYZJVYZ009/K6`=KFe]0fa/K0a[Jf/9K6a/1F][J`QZJVX3
Jf][2Va/K0E[Jf/7JVYZ0oooo`80000Boooo000Foooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000000?oool00`000?ooooooo`02oooo0^7Qh@03h>3PgmoOgmoO00?Ng]h2g=cL0]_K
f`03f][JfMWIfMWI00?Hf=P2emOG0mKFePCEeMD3e]KF0mOGe`;Hf=P3fMWI0][JfPGKfm/]g=cL1M_K
f`CJf]X;fMWI1=[JfP03fm_Kg=cLg=cL00;Lg=`00mgMgMkNg]kNgP02g]kN0moOg`SPh>05gmoO2]kN
gPCOgml?h>3P0moOg`GPh>0>hN7Q0n3Ph0OOgml5h>3P2>7Qh@Coool00`000?ooooooo`0Roooo00L0
003oooooooooool0003oool000000_ooo`030000oooo000000Coool010000?ooooooooooo`9YJFT3
JVYZ0f][J`9/K6`2KVi^00=`L71bLW9bLW800WAdM0IeMGD:M7Ad0W9bLP9aLG43L71`3Vm_K`e^KVh2
Kfm_00=`L71_Kfm_Kfl00Vi^KP03K6a/Jf][Jf][009/K6`00g1`L7IfMWIfMP02O7al00=nOWilO7al
O7`00WMgM`03LG5aKFe]KFe]009[Jf/00fe]KFm_Kfm_K`02LW9b00=dM7AfMWIfMWH00WMgM`03N7Qh
MgMgMgMg009gMgL00gIfMWEeMGEeM@02MWIf00=gMgMhN7QhN7P00WQhN003MgMgMGEeMGEe009cLg<0
0g1`L6i^KVi^KP02Jf][00=ZJVYYJFUYJFT00VUYJ@03JVYZJf][Jf][009/K6`5KFe]2Va/K003Jf][
JVYZJVYZ00EZJVX>Jf][1FYZJPIYJFT4JVYZ3F][J`=ZJVX7JFUY1?ooo`030000oooooooo013oool0
01Koool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000000oooo`030000oooooooo
00;oool2hN7Q00?Ph>3OgmoOgml00mkNgP;Lg=`2fm_K00?Jf][IfMWIfMT00mSHf0;GemL3e]KF1=GE
e@?Fe]H3emOG0]SHf0?IfMT2f][J1M_KfbgLg=`5fm_K1=[JfP_IfMT4f][J00?Kfm_Lg=cLg=`00]cL
g003gMgMg]kNg]kN00;Ng]h3gmoO2>3Ph0GOgml:g]kN1=oOg`oPh>03gmoO1N3Ph0kQhN43h>3P1moO
g`GPh>08hN7Q1?ooo`030000oooooooo02;oool01`000?ooooooooooo`000?ooo`000002oooo00<0
003oool000001?ooo`040000oooooooooooo0VUYJ@=ZJVX3Jf][0Va/K09^KVh00g1`L79bLW9bLP02
M7Ad1WEeM@YdM7@2LW9b0W5aL@=`L70>Kfm_3Fi^KP9_Kfl00g1`L6m_Kfm_K`02KVi^00=/K6a[Jf][
Jf/00Va/K003L71`MWIfMWIf009lO7`00ginOWalO7alO002MgMg00=aLG5]KFe]KFd00V][J`03KFe]
Kfm_Kfm_009bLW800gAdM7IfMWIfMP02MgMg00=hN7QgMgMgMgL00WMgM`03MWIfMGEeMGEe009fMWH0
0gMgMgQhN7QhN002N7Qh00=gMgMeMGEeMGD00W=cL`03L71`KVi^KVi^009[Jf/00fYZJVUYJFUYJ@02
JFUY00=ZJVY[Jf][Jf/00Va/K0E]KFd:K6a/00=[Jf]ZJVYZJVX01FYZJPi[Jf/5JVYZ1VUYJ@AZJVX=
Jf][0fYZJPMYJFT4oooo00<0003oooooool04?ooo`005Oooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo00;oool00`000?ooooooo`02oooo0^7Qh@03h>3PgmoOgmoO00;Ng]h00mgMgMcL
g=cLg002fm_K00?Jf][IfMWIfMT00]SHf003emOGe]KFe]KF00;Fe]H5eMGE0mKFeP?GemL2f=SH0mWI
f@;Jf]X3fm_K1=cLg0SMgMd5g=cL2M_Kf`?Lg=`8gMgM1=cLg003fm_Kf][Jf][J00?IfMT<f=SH0mWI
f@CJf]X3fm_K1McLg0GMgMdFg]kN2=oOgaSPh>05hN7Q1^;RhPCQhN45h>3P0moOg`GPh>03hN7Q1N;R
hP;QhN44oooo00<0003oooooool08Oooo`800004oooo00<0003oooooool00_ooo`030000oooooooo
00?oool010000?ooooooooooo`9XJ6P3JFUY0fYZJP9/K6`2KVi^00=`L71cLg=cLg<00WIfMP=gMgL2
MWIf00=eMGEdM7AdM7@00WAdM0EeMGD00gAdM7=cLg=cL`02LW9b0g1`L0i_Kfl6KVi^2Vm_K`A^KVh6
KFe]0Vi^KP9_Kfl00g1`L75aLG5aL@02LW9b00=cLg=dM7AdM7@00WAdM003Lg=cLW9bLW9b00YbLW82
LG5a0g1`L0M_Kfl3KVi^36e]KA1/K6`5Jf][1fYZJPY[Jf/7JVYZ2VUYJ@=ZJVX9Jf][1VYZJPMYJFT4
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2hN7Q00?Ph>3OgmoOgml00]kN
gP03gMgMg=cLg=cL00;Kfm/00m[Jf]WIfMWIf@02f=SH00?GemOFe]KFe]H00]KFePGEeMD3e]KF0mOG
e`;Hf=P3fMWI0][JfP?Kfm/4g=cL2=gMg@GLg=`9fm_K0mcLg0SMgMd4g=cL00?Kfm_Jf][Jf]X00mWI
f@cHf=P3fMWI1=[JfP?Kfm/5g=cL1MgMgAKNg]h8gmoO6>3Ph0GQhN46h^;R1>7Qh@GPh>03gmoO1N3P
h0?QhN45h^;R0^7Qh@Coool00`000?ooooooo`0boooo00@0003oooooooooool2J6QX0fUYJ@=ZJVX2
K6a/0Vi^KP03L71`Lg=cLg=c009fMWH3MgMg0WIfMP03MGEeM7AdM7Ad009dM7@5MGEe00=dM7AcLg=c
Lg<00W9bLP=`L70>Kfm_1Vi^KPY_Kfl4KVi^1Ve]K@9^KVh2Kfm_00=`L71aLG5aLG400W9bLP03Lg=c
M7AdM7Ad009dM7@00g=cLg9bLW9bLP0:LW9b0W5aL@=`L707Kfm_0fi^KPa]KFd@K6a/1F][J`MZJVX:
Jf][1fYZJPYYJFT3JVYZ2F][J`IZJVX7JFUY1?ooo`030000oooooooo013oool002Goool00`000?oo
ooooo`02oooo0^3Ph003gmoOg]kNg]kN00?MgMd2g=cL0]_Kf`03f][JfMWIfMWI00?Hf=P<emOG0mSH
f0CIfMT00m[Jf]_Kfm_Kf`02fm_K0mcLg0[MgMd4g=cL2]_Kf`03g=cLgMgMgMgM00;MgMd6g]kN0]gM
g@;Kfm/00m[Jf]WIfMWIf@02emOG0mKFeP?EeMD4e]KF00?GemOHf=SHf=P00]WIf@?Jf]X3fm_K1=cL
g0_MgMd:g=cL1=gMg@?Ng]h7gmoO7>3Ph0kQhN45h>3P1MoOg`GPh>08hN7Q1?ooo`030000oooooooo
03;oool010000?ooooooooooo`9YJFT3J6QX0VUYJ@03JVYZK6a/K6a/009_Kfl00g5aLG=cLg=cL`02
MGEe0gIfMP9eMGD00gAdM7=cLg=cL`03Lg=c17AdM003Lg=cLW9bLW9b009aLG400g1`L6m_Kfm_K`02
Kfm_4Vi^KP9_Kfl3L71`16m_K`03KVi^KFe]KFe]009]KFd3KVi^0Ve]K@03Jf][J6QXJ6QX00=UIFD2
JFUY0Vi^KP03M7AdN7QhN7Qh009iNGT00gMgMgAdM7AdM002LW9b00=`L71_Kfm_Kfl00fi^KPA]KFd3
K6a/0VYZJP03JFUYJ6QXJ6QX00=WIfL2J6QX0VUYJ@03Jf][K6a/K6a/009^KVh00fm_Kg1`L71`L003
Kfm_0Ve]K@a/K6`IJf][26YZJPAYJFT5JVYZ2f][J`YZJVX2JFUY1?ooo`030000oooooooo013oool0
02Goool00`000?ooooooo`02oooo0mkNgP;MgMd3g=cL1=_Kf`GJf]X6fMWI2][JfPCKfm/5g=cL0mgM
g@WNg]h3gMgM0mcLg0OKfm/2g=cL0mgMg@;Ng]h5gmoO00?Ng]kMgMgMgMd00]_Kf`03f][Jf=SHf=SH
00;GemL3eMGE0mCDe0;EeMD2e]KF00?GemOHf=SHf=P00]WIf@03f][Jfm_Kfm_K00;Kfm/3g=cL2=gM
g@GLg=`:fm_K1=cLg003gMgMg]kNg]kN00;Ng]h;gmoO2mkNgPoOgml6h>3P6moOg`Coool00`000?oo
ooooo`0boooo00@0003oooooooooool2JVYZ0fQXJ09YJFT00fa/K6m_Kfm_K`02LG5a0g9bLPaaLG48
L71`0fm_K`A^KVh?KFe]0Vi^KP=_Kfl3L71`0Vm_K`9^KVh00fe]KFa/K6a/K003KFe]0Vi^KP9]KFd0
0fYZJVMWIfMWI`03I6AT0VQXJ09^KVh00gAdM7QhN7QhN002NGUi00=hN7QeMGEeMGD00W=cL`03L71`
Kfm_Kfm_009^KVh00fe]KFa/K6a/K003K6a/0V][J`9ZJVX00fQXJ6MWIfMWI`03IVIV0VQXJ09YJFT0
0f][Jfe]KFe]K@02Kfm_00=`L71aLG5aLG400W5aL@03L71`Kfm_Kfm_00=]KFd7K6a/1f][Ja9/K6`D
Jf][2Fa/K0I[Jf/5K6a/0V][J`Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_oo
o`?Ng]h2gMgM0mcLg0CKfm/5f][J1]WIf@[Jf]X4fm_K1McLg0?MgMd9g]kN0mgMg@?Lg=`7fm_K0]cL
g0?MgMd2g]kN1MoOg`03g]kNgMgMgMgM00;Kfm/00m[Jf]SHf=SHf002emOG0mGEe@?De=@2eMGE0]KF
eP03emOGf=SHf=SH00;IfMT00m[Jf]_Kfm_Kf`02fm_K0mcLg0SMgMd5g=cL2]_Kf`CLg=`00mgMgMkN
g]kNgP02g]kN2moOg`_Ng]h?gmoO1^3Ph1_Ogml4oooo00<0003oooooool0<_ooo`040000oooooooo
oooo0VYZJP=XJ6P2JFUY00=/K6a_Kfm_Kfl00W5aL@=bLW8<LG5a271`L0=_Kfl4KVi^3fe]K@9^KVh3
Kfm_0g1`L09_Kfl2KVi^00=]KFe/K6a/K6`00fe]K@9^KVh2KFe]00=ZJVYWIfMWIfL00fATI09XJ6P2
KVi^00=dM7AhN7QhN7P00WUiN@03N7QhMGEeMGEe009cLg<00g1`L6m_Kfm_K`02KVi^00=]KFe/K6a/
K6`00fa/K09[Jf/2JVYZ00=XJ6QWIfMWIfL00fIVIP9XJ6P2JFUY00=[Jf]]KFe]KFd00Vm_K`03L71`
LG5aLG5a009aLG400g1`L6m_Kfm_K`03KFe]1fa/K0M[Jf/BK6a/56][J`U/K6`6Jf][1Fa/K09[Jf/4
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2g=cL1M_Kf`GJf]X5fm_K0mcL
g0?MgMd<g]kN0mgMg@WNg]h5gmoO0mkNgPCMgMd8g=cL0mgMg@;Ng]h3gmoO0^3Ph0?Ogml2gMgM0]cL
g003f][JfMWIfMWI00;GemL00mKFe]GEeMGEe@05eMGE0]KFeP03emOGf=SHf=SH00;IfMT00m[Jf]_K
fm_Kf`02fm_K0mcLg0OMgMd3g=cL0m_Kf`[Jf]X4fm_K00?Lg=cMgMgMgMd02]kNgPOMgMd3g=cL<MgM
g@?Lg=`4oooo00<0003oooooool0<_ooo`040000oooooooooooo0V][J`03JFUYJ6QXJ6QX009ZJVX0
0fi^KW9bLW9bLP02Lg=c00=bLW9_Kfm_Kfl00V][J`=YJFT2JVYZ00=/K6a^KVi^KVh00Vi^KP03K6a/
Jf][Jf][009ZJVX00f][Jfa/K6a/K002KFe]0fi^KP9]KFd3K6a/0V][J`EZJVX2Jf][00=/K6a]KFe]
KFd00Vi^KPI_Kfl2KVi^0fe]K@U/K6`00f][JfYZJVYZJP03JVYZ0Va/K09`L7000g=cLgEeMGEeM@03
MWIf0WEeM@9dM7@00g9bLW5aLG5aL@02L71`00=_Kfm^KVi^KVh00Vi^KP=]KFd2K6a/00=[Jf]ZJVYZ
JVX00fYZJP9[Jf/2KFe]00=^KVi_Kfm_Kfl00W1`L0EaLG400g1`L6m_Kfm_K`02Kfm_00=^KVi]KFe]
KFd00Ve]K@Q/K6`3KFe]1fi^KQe]KFd00fa/K6e]KFe]K@02KFe]0fi^KP=]KFd4K6a/00=]KFe^KVi^
KVh00g1`L09^KVh4oooo00<0003oooooool04?ooo`009Oooo`800003oooo0]cLg0GKfm/5f][J1M_K
f`?Lg=`3gMgM3=kNgP?MgMd9g]kN1MoOg`?Ng]h4gMgM2=cLg0?MgMd2g]kN0moOg`;Ph>03gmoO0]gM
g@;Lg=`00m[Jf]WIfMWIf@02emOG00?Fe]KEeMGEeMD01MGEe@;Fe]H00mOGemSHf=SHf002fMWI00?J
f][Kfm_Kfm/00]_Kf`?Lg=`7gMgM0mcLg0?Kfm/:f][J1=_Kf`03g=cLgMgMgMgM00[Ng]h7gMgM0mcL
g37MgMd3g=cL0oooo`80000doooo00@0003oooooooooool2Jf][00=YJFUXJ6QXJ6P00VYZJP03KVi^
LW9bLW9b009cLg<00g9bLVm_Kfm_K`02Jf][0fUYJ@9ZJVX00fa/K6i^KVi^KP02KVi^00=/K6a[Jf][
Jf/00VYZJP03Jf][K6a/K6a/009]KFd3KVi^0Ve]K@=/K6`2Jf][1FYZJP9[Jf/00fa/K6e]KFe]K@02
KVi^1Vm_K`9^KVh3KFe]2Fa/K003Jf][JVYZJVYZ00=ZJVX2K6a/0W1`L003Lg=cMGEeMGEe00=fMWH2
MGEe0WAdM003LW9bLG5aLG5a009`L7000fm_Kfi^KVi^KP02KVi^0fe]K@9/K6`00f][JfYZJVYZJP03
JVYZ0V][J`9]KFd00fi^KVm_Kfm_K`02L71`1G5aL@03L71`Kfm_Kfm_009_Kfl00fi^KVe]KFe]K@02
KFe]26a/K0=]KFd7KVi^7Fe]K@03K6a/KFe]KFe]009]KFd3KVi^0fe]K@A/K6`00fe]KFi^KVi^KP03
L71`0Vi^KP?oool200004_ooo`009Oooo`030000oooooooo00;oool8f=SH0]WIf@?Jf]X2g=cL0]gM
g@03g]kNgmoOgmoO00;Ph>000n7QhN;Rh^;RhP07h^;R0n7Qh@?Ph>0>gmoO1MkNgPcMgMd00mkNg]oO
gmoOg`02gmoO0n3Ph0?Ogml2g]kN0]cLg003fm_KfMWIfMWI00;Hf=P00mOGemKFe]KFeP05e]KF0]OG
e`?Hf=P2fMWI00?Jf][Kfm_Kfm/00]_Kf`gLg=`2fm_K0m[JfPSIfMT2f][J0m_Kf`;Lg=`8gMgM1=cL
g0?Kfm/5f][J2M_Kf`03g=cLfm_Kfm_K00OKfm/6f][J1M_Kf`[Lg=`4fm_K0m[JfPGIfMT4oooo00<0
003oooooool0<_ooo`040000oooooooooooo0Vi^KP03JVYZJFUYJFUY009[Jf/00g1`L7AdM7AdM002
MWIf00=cLg=/K6a/K6`00VEUI@=QHF42I6AT00=XJ6QZJVYZJVX00VYZJP03J6QXIVIVIVIV009UIFD0
0fIVIVQXJ6QXJ002JVYZ00=/K6a]KFe]KFd00fa/K09[Jf/2JVYZ00=YJFUXJ6QXJ6P016UYJ@03Jf][
KFe]KFe]009^KVh5Kfm_00=^KVi]KFe]KFd00Ve]K@03K6a/Jf][Jf][00E[Jf/2K6a/00=]KFe^KVi^
KVh00W1`L0QaLG42LW9b00=cLg=dM7AdM7@00gAdM09cLg<2LW9b00=aLG5`L71`L7000W1`L0=_Kfl7
KVi^00=_Kfm`L71`L7000W1`L0EaLG4:L71`00=_Kfm^KVi^KVh00Vi^KP03KFe]K6a/K6a/009/K6`3
KFe]0Vi^KP03Kfm_L71`L71`009aLG43L71`0Vm_K`M^KVh:Kfm_1W1`L0A_Kfl3KVi^1fm_K`E^KVh0
0fm_Kg9bLW9bLP02Lg=c00=dM7AaLG5aLG401?ooo`030000oooooooo013oool002Goool00`000?oo
ooooo`02oooo1MCDe0;EeMD00mKFe]OGemOGe`02f=SH00?Jf][Kfm_Kfm/00]kNgP03h>3Ph^;Rh^;R
00;Ti>@00nGUiNKVi^KViP03inOW0^KViP;UiND00nCTi>?Shn?Sh`02h^;R00?QhN7Ph>3Ph>000^3P
h0SOgml9g]kN1MgMg@GNg]h5gmoO0n3Ph0?Ogml2g]kN0]gMg@03g=cLf][Jf][J00?IfMT4f=SH00?G
emOHf=SHf=P00mSHf0CIfMT3f][J1M_Kf`OLg=`3fm_K0m[JfPCIfMT5f=SH0mWIf@?Jf]X4fm_K0mcL
g0?Kfm/4f][J0mWIf@OHf=P5fMWI0m[JfPGIfMT4f=SH1]OGe`CHf=P00mWIfM[Jf][JfP08f][J0]WI
f@;Hf=P00mOGemKFe]KFeP03eMGE0]CDe0Coool00`000?ooooooo`0boooo00@0003oooooooooool2
L71`00=[Jf]YJFUYJFT00Va/K003LG5aMWIfMWIf009gMgL00g9bLVYZJVYZJP02HV9R0eaLG09OGel0
0fATI6MWIfMWI`02IfMW00=UIFERHV9RHV800V5QH@03HV9RIFEUIFEU009XJ6P00fYZJV][Jf][J`03
Jf][16YZJPEYJFT2JVYZ00=[Jf]/K6a/K6`00Ve]K@E^KVh00fe]KFa/K6a/K003K6a/1f][J`9/K6`0
0fi^KW5aLG5aL@02Lg=c0gAdM09bLW800g1`L6i^KVi^KP02Kfm_00=`L71bLW9bLW800W=cL`=dM7@2
Lg=c0g9bLP=aLG44L71`0g5aL@=bLW84Lg=c0g9bLP=aLG44L71`1G5aL@=`L702Kfm_1Vi^KP9_Kfl2
L71`00=aLG5bLW9bLW800W=cL`=bLW82LG5a271`L0MaLG42LW9b1W=cL`9bLW82LG5a1G1`L0EaLG40
0g1`L6m_Kfm_K`02L71`00=bLW9eMGEeMGD00gQhN09eMGD4oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool5e=CD0]GEe@03e]KFemOGemOG00;Hf=P00m[Jf]_Kfm_Kf`02g]kN00?P
h>3Rh^;Rh^800^CTi003iNGUi^KVi^KV00?WinL2i^KV0^GUi@03i>CThn?Shn?S00;Rh^800n7QhN3P
h>3Ph002h>3P2=oOg`WNg]h5gMgM1MkNgPGOgml3h>3P0moOg`;Ng]h2gMgM00?Lg=cJf][Jf]X00mWI
f@CHf=P00mOGemSHf=SHf003f=SH1=WIf@?Jf]X5fm_K1mcLg0?Kfm/3f][J1=WIf@GHf=P3fMWI0m[J
fPCKfm/3g=cL0m_Kf`CJf]X3fMWI1mSHf0GIfMT3f][J1MWIf@CHf=P6emOG1=SHf003fMWIf][Jf][J
00SJf]X2fMWI0]SHf003emOGe]KFe]KF00?EeMD2e=CD1?ooo`030000oooooooo03;oool010000?oo
ooooooooo`9`L7000f][JfUYJFUYJ@02K6a/00=aLG5fMWIfMWH00WMgM`03LW9bJVYZJVYZ009RHV83
G5aL0UmOG`03I6ATIfMWIfMW009WIfL00fEUIF9RHV9RHP02HF5Q00=RHV9UIFEUIFD00VQXJ003JVYZ
Jf][Jf][00=[Jf/4JVYZ1FUYJ@9ZJVX00f][Jfa/K6a/K002KFe]1Fi^KP03KFe]K6a/K6a/00=/K6`7
Jf][0Va/K003KVi^LG5aLG5a009cLg<3M7Ad0W9bLP03L71`KVi^KVi^009_Kfl00g1`L79bLW9bLP02
Lg=c0gAdM09cLg<3LW9b0g5aL@A`L703LG5a0g9bLPAcLg<3LW9b0g5aL@A`L705LG5a0g1`L09_Kfl6
KVi^0Vm_K`9`L7000g5aLG9bLW9bLP02Lg=c0g9bLP9aLG48L71`1g5aL@9bLW86Lg=c0W9bLP9aLG45
L71`1G5aL@03L71`Kfm_Kfm_009`L7000g9bLWEeMGEeM@03N7Qh0WEeM@Coool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`??cll4d=3@00?AdM7Cdm?Cdm<00]GEe@03emOGf][Jf][J
00;MgMd00n3Ph>?Shn?Sh`02iNGU00?Xj>SYjNWYjNT00n[ZjP;YjNT2j>SX00?WinOUiNGUiND00^CT
i003h^;RhN7QhN7Q00;Ph>03gmoO1mkNgPOMgMd6g]kN3=oOg`?Ng]h4gMgM00?Lg=cKfm_Kfm/00m[J
fPGIfMT4f=SH2=WIf@OJf]X5fm_K1M[JfP?IfMT:f=SH0mWIf@OJf]X3fMWI1=SHf003emOGe]KFe]KF
00OFe]H3emOG1MSHf0CGemL00mKFe]GEeMGEe@02eMGE1]CDe0;EeMD2e]KF00?GemOHf=SHf=P00]SH
f0?IfMT2f=SH00?GemOFe]KFe]H00]GEe@03e=CDd];Bd];B00;AdM43d=3@1?ooo`030000oooooooo
03;oool010000?ooooooooooo`9cLg<00fe]KFUYJFUYJ@02JVYZ00=_KfmdM7AdM7@00WIfMP03LW9b
JVYZJVYZ009RHV800eaLG5]KFe]KF`02GEeM00=QHF5SHf=SHf<00VATI003Hf=SHV9RHV9R009RHV80
0f=SHfEUIFEUI@02IfMW00=YJFUZJVYZJVX01F][J`E/K6`:KFe]2Va/K0M[Jf/2K6a/00=^KVi`L71`
L7000W9bLP=cLg<2LW9b00=`L71_Kfm_Kfl00Vm_K`03L71`LG5aLG5a00abLW85LG5a0g9bLPEcLg<?
LW9b1G5aL@E`L703LG5a0W9bLP=cLg<9M7Ad0g=cL`EbLW84Lg=c0gAdM09eMGD5MWIf0gEeM@9dM7@0
0g=cLg9bLW9bLP07LW9b0g5aL@9bLW800gIfMWYjNWYjNP03OWin0WYjNPCoool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`??cll4d=3@00?AdM7Cdm?Cdm<00]GEe@03emOGf][Jf][J
00;MgMd00n3Ph>?Shn?Sh`02iNGU00?Xj>SYjNWYjNT00n[ZjP;YjNT2j>SX00?WinOUiNGUiND00^CT
i003h^;RhN7QhN7Q00;Ph>03gmoO1mkNgPOMgMd6g]kN3=oOg`?Ng]h4gMgM00?Lg=cKfm_Kfm/00m[J
fPGIfMT4f=SH2=WIf@OJf]X5fm_K1M[JfP?IfMT:f=SH0mWIf@OJf]X3fMWI1=SHf003emOGe]KFe]KF
00OFe]H3emOG1MSHf0CGemL00mKFe]GEeMGEe@02eMGE1]CDe0;EeMD2e]KF00?GemOHf=SHf=P00]SH
f0?IfMT2f=SH00?GemOFe]KFe]H00]GEe@03e=CDd];Bd];B00;AdM43d=3@1?ooo`030000oooooooo
03;oool010000?ooooooooooo`9cLg<00fe]KFUYJFUYJ@02JVYZ00=_KfmdM7AdM7@00WIfMP03LW9b
JVYZJVYZ009RHV800eaLG5]KFe]KF`02GEeM00=QHF5SHf=SHf<00VATI003Hf=SHV9RHV9R009RHV80
0f=SHfEUIFEUI@02IfMW00=YJFUZJVYZJVX01F][J`E/K6`:KFe]2Va/K0M[Jf/2K6a/00=^KVi`L71`
L7000W9bLP=cLg<2LW9b00=`L71_Kfm_Kfl00Vm_K`03L71`LG5aLG5a00abLW85LG5a0g9bLPEcLg<?
LW9b1G5aL@E`L703LG5a0W9bLP=cLg<9M7Ad0g=cL`EbLW84Lg=c0gAdM09eMGD5MWIf0gEeM@9dM7@0
0g=cLg9bLW9bLP07LW9b0g5aL@9bLW800gIfMWYjNWYjNP03OWin0WYjNPCoool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`G:b/X2bl_;00?<c<c=cLg=cLd00]3@d003dm?Ce]KFe]KF
00;Jf]X00mkNg^;Rh^;RhP02iNGU00?Xj>SZj^[Zj^X01N_[j`;YjNT00nSXj>KVi^KViP02i>CT00?R
h^;QhN7QhN400^3Ph003gmoOg]kNg]kN00?MgMd7g=cL1MgMg@CNg]h:gmoO1MkNgP?MgMd3g=cL1M_K
f`GJf]XDfMWI1=[JfPGIfMT6f=SH1=OGe`GHf=P8fMWI0]SHf0?GemL2e]KF0mGEe@CDe=@5eMGE0mKF
eP;GemL3e]KF0]GEe@?De=@2dm?C00?Bd];AdM7AdM400]7Ad@03d];Bdm?Cdm?C00;De=@00mGEeMKF
e]KFeP02emOG0mSHf0;GemL00mKFe]CDe=CDe002d];B00?AdM7?clo?cll00/g=c@03c<c<bl_;bl_;
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2MWIf00=]KFeXJ6QXJ6P00VQXJ003K6a/
LG5aLG5a009dM7@00g5aLF][Jf][J`02IFEU00=PH61NGUiNGUh00UiNGP03GemOHF5QHF5Q009RHV80
0f=SHfATI6ATI002I6AT00=UIFEVIVIVIVH00VMWI`03J6QXJFUYJFUY009ZJVX00fa/K6e]KFe]K@02
Kfm_00=`L71aLG5aLG400W9bLP9aLG400fm_Kfi^KVi^KP02K6a/26][J`e/K6`2KFe]0Vi^KP03Kfm_
L71`L71`009aLG400g9bLW=cLg=cL`02Lg=c00=bLW9aLG5aLG401g1`L1MaLG42LW9b00=cLg=dM7Ad
M7@00WAdM003Lg=cLW9bLW9b00MaLG43LW9b0W=cL`03M7AdMGEeMGEe00=eMGD4M7Ad0gEeM@EfMWH2
MGEe1GAdM09eMGD00gIfMWMgMgMgM`02MgMg1GQhN0=gMgL2MWIf00=eMGEdM7AdM7@00g=cL`MbLW82
MGEe00=iNGUoOgmoOgl00h>3P`9nOWh4oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo
00;oool2aLG51/C4a0;6a/H2b<S800?;bl_@d=3@d=000]CDe003fMWIg]kNg]kN00;Rh^800nKVi^SX
j>SXj005j^[Z0^WYj@03inOWiNGUiNGU00;Shn<00n7QhMoOgmoOg`02g]kN00?MgMgLg=cLg=`00]cL
g0OKfm/3g=cL0mgMg@;Ng]h:gmoO0mkNgPCMgMd;g=cL1M_Kf`CJf]X6fMWI1MSHf0kIfMTGf=SH0mOG
e`;Fe]H3eMGE1mCDe0CEeMD8e]KF0]GEe@03e=CDdm?Cdm?C00;Bd]800m7AdM3@d=3@d003dM7A0];B
dP;De=@00mGEeMKFe]KFeP02emOG0mSHf0;GemL00mGEeM?Cdm?Cd`02dM7A00??clo<c<c<c<`00/[:
bP03b<S8a/K6a/K600Coool00`000?ooooooo`0boooo00@0003oooooooooool2MWIf00=[Jf]TI6AT
I6@00VATI003JFUYKfm_Kfm_009cLg<00g9bLVi^KVi^KP02JFUY00=UIFERHV9RHV801F5QH@9RHV80
0fATI6IVIVIVIP02J6QX1VUYJ@9ZJVX2Jf][00=]KFe_Kfm_Kfl00W9bLP03M7AdMWIfMWIf009fMWH2
M7Ad00=bLW9_Kfm_Kfl00Va/K0IZJVX2Jf][0fa/K0E]KFd2K6a/0V][J`=ZJVX2JFUY00=[Jf]]KFe]
KFd00W5aL@03M7AdMWIfMWIf009eMGD00g=cLg1`L71`L005KVi^0Vm_K`=`L708LG5a171`L003Kfm_
KVi^KVi^009^KVh00fm_Kg1`L71`L002LW9b00=dM7AeMGEeMGD00WAdM003Lg=cLW9bLW9b009aLG40
0g1`L75aLG5aL@02LW9b00=cLg=dM7AdM7@00WEeM@EfMWH00gEeMGAdM7AdM004M7Ad00=eMGEgMgMg
MgL00gMgM`9fMWH5M7Ad0WEeM@03MgMgN7QhN7Qh00EiNGT3N7Qh0WMgM`9fMWH00gEeMGAdM7AdM002
Lg=c0g9bLP9aLG400g9bLW=cLg=cL`02MWIf00=lO7b2PX:2PX800hN7Q`:0P804oooo00<0003ooooo
ool04?ooo`009Oooo`800003oooo0/G5a@K4a<@2a/K60/S8b003bl_;d=3@d=3@00;De=@00mWIfMkN
g]kNgP02h^;R00?Vi^KXj>SXj>P01N[ZjP;YjNT00nOWinGUiNGUi@02hn?S00?QhN7OgmoOgml00]kN
gP03gMgMg=cLg=cL00;Lg=`7fm_K0mcLg0?MgMd2g]kN2]oOg`?Ng]h4gMgM2mcLg0GKfm/4f][J1]WI
f@GHf=P>fMWI5mSHf0?GemL2e]KF0mGEe@ODe=@4eMGE2=KFeP;EeMD00mCDe=?Cdm?Cd`02d];B00?A
dM7@d=3@d=000m7Ad@;Bd]82e=CD00?EeMGFe]KFe]H00]OGe`?Hf=P2emOG00?EeMGCdm?Cdm<00]7A
d@03clo?c<c<c<c<00;:b/X00lS8b<K6a/K6aP03oooo0P0003Coool010000?ooooooooooo`9fMWH0
0f][JfATI6ATI002I6AT00=YJFU_Kfm_Kfl00W=cL`03LW9bKVi^KVi^009YJFT00fEUIF9RHV9RHP05
HF5Q0V9RHP03I6ATIVIVIVIV009XJ6P6JFUY0VYZJP9[Jf/00fe]KFm_Kfm_K`02LW9b00=dM7AfMWIf
MWH00WIfMP9dM7@00g9bLVm_Kfm_K`02K6a/1VYZJP9[Jf/3K6a/1Fe]K@9/K6`2Jf][0fYZJP9YJFT0
0f][Jfe]KFe]K@02LG5a00=dM7AfMWIfMWH00WEeM@03Lg=cL71`L71`00E^KVh2Kfm_0g1`L0QaLG44
L71`00=_Kfm^KVi^KVh00Vi^KP03Kfm_L71`L71`009bLW800gAdM7EeMGEeM@02M7Ad00=cLg=bLW9b
LW800W5aL@03L71`LG5aLG5a009bLW800g=cLgAdM7AdM002MGEe1GIfMP03MGEeM7AdM7Ad00AdM7@0
0gEeMGMgMgMgM`03MgMg0WIfMPEdM7@2MGEe00=gMgMhN7QhN7P01GUiN@=hN7P2MgMg0WIfMP03MGEe
M7AdM7Ad009cLg<3LW9b0W5aL@03LW9bLg=cLg=c009fMWH00galO8:2PX:2PP03QhN70X20P0?oool2
00004_ooo`009Oooo`030000oooooooo00;oool2`<3000>n_[jl_;bl_;`00k^k^`:l_;`2_[jn00?1
`L75aLG5aLD00/[:bP03d=3@eMGEeMGE00;Kfm/00moOgn?Shn?Sh`02iNGU0nKViP;UiND00nCTi>;R
h^;RhP02h>3P00?OgmoMgMgMgMd00]cLg003fm_Kf][Jf][J00?Jf]X2fMWI1=[JfP?Kfm/2g=cL00?M
gMgNg]kNg]h00]oOg`GPh>000moOgmkNg]kNgP02g]kN00?MgMgLg=cLg=`02]cLg0OMgMd3g=cL0m_K
f`CJf]X=fMWI1M[JfQKIfMT5f=SH00?GemOFe]KFe]H00mKFePKEeMD3e]KF0mOGe`GHf=P2emOG0]KF
eP03eMGEe=CDe=CD00;Cdm<00m;Bd]7AdM7Ad@03d];B0]CDe0;EeMD00mOGemSHf=SHf002fMWI0m[J
fP;IfMT00mOGemCDe=CDe002d];B00??clo;bl_;bl/00/S8b003aLG5`/;2`/;200Coool00`000?oo
ooooo`0boooo00@0003oooooooooool2LW9b00=VIVIOGemOGel00V1PH003IVIVKVi^KVi^009dM7@0
0gEeMG=cLg=cL`02Kfm_00=[Jf]XJ6QXJ6P00fIVIP9UIFD2IVIV00=WIfMYJFUYJFT026YZJP9[Jf/2
KFe]00=_KfmaLG5aLG400W=cL`03MGEeMWIfMWIf009eMGD2M7Ad00=bLW9_Kfm_Kfl00Ve]K@03Jf][
JVYZJVYZ00=ZJVX2Jf][0Va/K0=]KFd3KVi^0Ve]K@9/K6`00f][JfYZJVYZJP03JFUY0Va/K09_Kfl0
0g=cLgEeMGEeM@02M7Ad00=bLW9_Kfm_Kfl01Fe]K@9^KVh00fm_Kg1`L71`L008L71`0Vm_K`=^KVh4
KFe]00=^KVi_Kfm_Kfl00W5aL@03Lg=cM7AdM7Ad009cLg<00g9bLW5aLG5aL@03L71`0W5aL@9bLW80
0g=cLgAdM7AdM003MGEe0WIfMP9eMGD00gAdM7=cLg=cL`04Lg=c00=dM7AeMGEeMGD00WIfMP03MGEe
M7AdM7Ad00EcLg<2M7Ad00=fMWIgMgMgMgL01GQhN0=gMgL2MWIf0WEeM@03M7AdLW9bLW9b009aLG45
L71`00=aLG5cLg=cLg<00WMgM`03O7alPX:2PX:200:6QXH00hF5QGemOGemO@04oooo00<0003ooooo
ool04?ooo`009Oooo`030000oooooooo00;oool2`<3000>n_[jl_;bl_;`00k^k^`:l_;`2_[jn00?1
`L75aLG5aLD00/[:bP03d=3@eMGEeMGE00;Kfm/00moOgn?Shn?Sh`02iNGU0nKViP;UiND00nCTi>;R
h^;RhP02h>3P00?OgmoMgMgMgMd00]cLg003fm_Kf][Jf][J00?Jf]X2fMWI1=[JfP?Kfm/2g=cL00?M
gMgNg]kNg]h00]oOg`GPh>000moOgmkNg]kNgP02g]kN00?MgMgLg=cLg=`02]cLg0OMgMd3g=cL0m_K
f`CJf]X=fMWI1M[JfQKIfMT5f=SH00?GemOFe]KFe]H00mKFePKEeMD3e]KF0mOGe`GHf=P2emOG0]KF
eP03eMGEe=CDe=CD00;Cdm<00m;Bd]7AdM7Ad@03d];B0]CDe0;EeMD00mOGemSHf=SHf002fMWI0m[J
fP;IfMT00mOGemCDe=CDe002d];B00??clo;bl_;bl/00/S8b003aLG5`/;2`/;200Coool00`000?oo
ooooo`0boooo00@0003oooooooooool2LW9b00=VIVIOGemOGel00V1PH003IVIVKVi^KVi^009dM7@0
0gEeMG=cLg=cL`02Kfm_00=[Jf]XJ6QXJ6P00fIVIP9UIFD2IVIV00=WIfMYJFUYJFT026YZJP9[Jf/2
KFe]00=_KfmaLG5aLG400W=cL`03MGEeMWIfMWIf009eMGD2M7Ad00=bLW9_Kfm_Kfl00Ve]K@03Jf][
JVYZJVYZ00=ZJVX2Jf][0Va/K0=]KFd3KVi^0Ve]K@9/K6`00f][JfYZJVYZJP03JFUY0Va/K09_Kfl0
0g=cLgEeMGEeM@02M7Ad00=bLW9_Kfm_Kfl01Fe]K@9^KVh00fm_Kg1`L71`L008L71`0Vm_K`=^KVh4
KFe]00=^KVi_Kfm_Kfl00W5aL@03Lg=cM7AdM7Ad009cLg<00g9bLW5aLG5aL@03L71`0W5aL@9bLW80
0g=cLgAdM7AdM003MGEe0WIfMP9eMGD00gAdM7=cLg=cL`04Lg=c00=dM7AeMGEeMGD00WIfMP03MGEe
M7AdM7Ad00EcLg<2M7Ad00=fMWIgMgMgMgL01GQhN0=gMgL2MWIf0WEeM@03M7AdLW9bLW9b009aLG45
L71`00=aLG5cLg=cLg<00WMgM`03O7alPX:2PX:200:6QXH00hF5QGemOGemO@04oooo00<0003ooooo
ool04?ooo`009Oooo`030000oooooooo00;oool2^k^k00>g]kNd];Bd];@00[6a/@>_[jl2/;2`00>c
/k>g]kNg]kL00[fm_@03`l?3bLW9bLW900;?cll00mGEeMWIfMWIf@02g=cL00?Ng]kOgmoOgml00mkN
gP;MgMd2fm_K00?Jf][IfMWIfMT00]WIf@[Hf=P2fMWI00?Jf][Kfm_Kfm/00]cLg003gMgMg]kNg]kN
00;Ogml5h>3P00?OgmoNg]kNg]h00]gMg@?Lg=`5fm_K0mcLg0CMgMd6g]kN1=gMg@?Lg=`Sfm_K1m[J
fPKIfMT;f=SH0mWIf@?Jf]X5fm_K0][JfP;IfMT00mSHf=OGemOGe`02e]KF1MGEe@03e]KFemOGemOG
00;IfMT00m_KfmcLg=cLg005g]kN0]cLg003f][JemOGemOG00;De=@00m3@d<c<c<c<c002b<S800?3
`l>o_kno_kl01?ooo`030000oooooooo03;oool010000?ooooooooooo`9XJ6P00eeMGEMGEeMGE`02
Fe]K00=UIFEaLG5aLG400WYjNP03O7alN7QhN7Qh009cLg<00fm_Kfe]KFe]K@02KVi^0fm_K`9^KVh0
0fa/K6YZJVYZJP05JFUY0VYZJP03Jf][KFe]KFe]009`L7000g9bLW=cLg=cL`02Lg=c00=aLG5`L71`
L7001Fi^KPA_Kfl00fi^KVe]KFe]K@02K6a/1F][J`03K6a/KFe]KFe]009]KFd00fi^KVm_Kfm_K`03
Kfm_0Vi^KPM]KFd6KVi^16e]K@=^KVh2Kfm_0g1`L0E_Kfl=KVi^1Fm_K`a`L705LG5a379bLPEaLG4:
L71`0W5aL@03LW9bLg=cLg=c009dM7@5MGEe00=dM7AcLg=cLg<00W9bLP03L71`KVi^KVi^009]KFd0
0fa/K6e]KFe]K@02KVi^00=`L71bLW9bLW800WIfMP03NWYjOWinOWin00:0P8000gemOGAdM7AdM004
oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2][Jf00>`/;2ZZZZZZZX00ZJV
YP03XZ:RX:2PX:2P00:PX:000j:RXZJVYZJVYP02[:b/00>b/[:i^KVi^KT00/30`003a/K6c<c<c<c<
00;@d=000m?CdmCDe=CDe007eMGE1]CDe0GEeMD4e]KF0]OGe`03fMWIf][Jf][J00;Kfm/00mgMgMkN
g]kNgP02gmoO0n3Ph0?Ogml2g]kN0]gMg@03g=cLfm_Kfm_K00?Jf]X4fm_K00?Lg=cMgMgMgMd00]kN
gP[Ogml3g]kN3=gMgA3Ng]h7gMgM1McLg0cKfm/5g=cL0mgMg@CNg]h6gmoO0]kNgP;MgMd00mcLg=_K
fm_Kf`03f][J0]WIf@;Jf]X00m_KfmgMgMgMg@02g]kN00?Ph>3Rh^;Rh^801N?Sh`;QhN400moOgmcL
g=cLg002emOG00?Cdm?>c/k>c/h00/S8b003`/;2_;bl_;bl00Coool00`000?ooooooo`0boooo00@0
003oooooooooool2G5aL00=ADE5>CTi>CTh00UIFEP03IFEUMWIfMWIf00:2PX800hB4Q7inOWinOP02
MgMg00=aLG5bLW9bLW800WIfMP03Ng]kO7alO7al009hN7P00g5aLFYZJVYZJP02IVIV00=UIFEWIfMW
IfL00VYZJP03KVi^LG5aLG5a009cLg<00gAdM7=cLg=cL`02L71`00=[Jf]VIVIVIVH00VATI09UIFD0
0fYZJVi^KVi^KP03LW9b0W5aL@9^KVh00fa/K6YZJVYZJP02JVYZ00=[Jf]/K6a/K6`00Ve]K@03Kfm_
LG5aLG5a009cLg<5M7Ad00=bLW9_Kfm_Kfl00VYZJP03IVIVI6ATI6AT009UIFD00fMWIf][Jf][J`02
KVi^1W1`L0A_Kfl00fi^KVe]KFe]K@05KFe]0fi^KPE_Kfl2KVi^0Va/K003Jf][JVYZJVYZ009[Jf/0
0fe]KFm_Kfm_K`05L71`0Vm_K`=^KVh2KFe]00=/K6a]KFe]KFd00Vi^KP03Kfm_L71`L71`009`L702
Kfm_00=]KFe[Jf][Jf/01FUYJ@9ZJVX00f][Jfa/K6a/K002K6a/00=]KFe^KVi^KVh00Vm_K`03L71`
LG5aLG5a009aLG400g1`L6m_Kfm_K`02KFe]00=[Jf]YJFUYJFT00fQXJ09YJFT2Jf][00=^KViaLG5a
LG400WAdM003MWIfN7QhN7Qh009hN7P00g=cLfQXJ6QXJ004oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool2][Jf00>`/;2ZZZZZZZX00ZJVYP03XZ:RX:2PX:2P00:PX:000j:RXZJV
YZJVYP02[:b/00>b/[:i^KVi^KT00/30`003a/K6c<c<c<c<00;@d=000m?CdmCDe=CDe007eMGE1]CD
e0GEeMD4e]KF0]OGe`03fMWIf][Jf][J00;Kfm/00mgMgMkNg]kNgP02gmoO0n3Ph0?Ogml2g]kN0]gM
g@03g=cLfm_Kfm_K00?Jf]X4fm_K00?Lg=cMgMgMgMd00]kNgP[Ogml3g]kN3=gMgA3Ng]h7gMgM1McL
g0cKfm/5g=cL0mgMg@CNg]h6gmoO0]kNgP;MgMd00mcLg=_Kfm_Kf`03f][J0]WIf@;Jf]X00m_KfmgM
gMgMg@02g]kN00?Ph>3Rh^;Rh^801N?Sh`;QhN400moOgmcLg=cLg002emOG00?Cdm?>c/k>c/h00/S8
b003`/;2_;bl_;bl00Coool00`000?ooooooo`0boooo00@0003oooooooooool2G5aL00=ADE5>CTi>
CTh00UIFEP03IFEUMWIfMWIf00:2PX800hB4Q7inOWinOP02MgMg00=aLG5bLW9bLW800WIfMP03Ng]k
O7alO7al009hN7P00g5aLFYZJVYZJP02IVIV00=UIFEWIfMWIfL00VYZJP03KVi^LG5aLG5a009cLg<0
0gAdM7=cLg=cL`02L71`00=[Jf]VIVIVIVH00VATI09UIFD00fYZJVi^KVi^KP03LW9b0W5aL@9^KVh0
0fa/K6YZJVYZJP02JVYZ00=[Jf]/K6a/K6`00Ve]K@03Kfm_LG5aLG5a009cLg<5M7Ad00=bLW9_Kfm_
Kfl00VYZJP03IVIVI6ATI6AT009UIFD00fMWIf][Jf][J`02KVi^1W1`L0A_Kfl00fi^KVe]KFe]K@05
KFe]0fi^KPE_Kfl2KVi^0Va/K003Jf][JVYZJVYZ009[Jf/00fe]KFm_Kfm_K`05L71`0Vm_K`=^KVh2
KFe]00=/K6a]KFe]KFd00Vi^KP03Kfm_L71`L71`009`L702Kfm_00=]KFe[Jf][Jf/01FUYJ@9ZJVX0
0f][Jfa/K6a/K002K6a/00=]KFe^KVi^KVh00Vm_K`03L71`LG5aLG5a009aLG400g1`L6m_Kfm_K`02
KFe]00=[Jf]YJFUYJFT00fQXJ09YJFT2Jf][00=^KViaLG5aLG400WAdM003MWIfN7QhN7Qh009hN7P0
0g=cLfQXJ6QXJ004oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2/K6a00>X
Z:RPX:2PX:000YVIV@03Ti>CT92@T92@00:>SXh00hn?Si>CTi>CT`02V9RH00>OWinVYZJVYZH00Zj^
[P03]KFe_;bl_;bl00;1`L400lG5aLO7alO7a`02bLW900?:b/[;bl_;bl/00/c<c0?=cLd2c/k>00??
clo@d=3@d=000]7Ad@03d];Bdm?Cdm?C00;De=@2eMGE00?GemOHf=SHf=P00][JfP03g=cLgMgMgMgM
00;Ng]h3gmoO0mkNgP;MgMd2fm_K0m[JfP?IfMT2f][J0]_Kf`03g=cLgMgMgMgM00;Ng]h3gmoO1n3P
h0_OgmlFh>3P0moOg`CNg]h:gMgM0mkNgP;Ogml3h>3P1>7Qh@?Rh^8:hn?S0^;RhP03hN7Qh>3Ph>3P
00OOgml00n7QhN?Shn?Sh`02iNGU00?Vi^KXj>SXj>P01NWYj@;WinL00nCTi>3Ph>3Ph002fm_K00?F
e]K@d=3@d=000/W9b@03`/;2^KVi^KVi00Coool00`000?ooooooo`0boooo00@0003oooooooooool2
Cdm?00=4A4A3@d=3@d<00U1@D003IFEUO7alO7al00:;Rh/00hb<S8B4Q8B4Q002NGUi00=bLW9dM7Ad
M7@00WemO@03QHF5QhN7QhN700:1PH400gIfMVYZJVYZJP02HV9R00=QHF5VIVIVIVH00Va/K003LG5a
MGEeMGEe009gMgL00gIfMW=cLg=cL`02K6a/00=TI6AMGEeMGEd00UUIF@9MGEd00fEUIFi^KVi^KP02
MGEe00=gMgMeMGEeMGD00W1`L003K6a/JVYZJVYZ009YJFT00fYZJV][Jf][J`02KFe]00=`L71cLg=c
Lg<00WIfMP03NGUiNWYjNWYj009jNWX00gMgMg1`L71`L002J6QX00=PH61LG5aLG5`00UeMG@03HV9R
JFUYJFUY009_Kfl3LG5a0W1`L003Kfm_KVi^KVi^00=]KFd7K6a/0Ve]K@03KVi^Kfm_Kfm_00=`L702
KFe]0VYZJP03IfMWIFEUIFEU009VIVH00fYZJVe]KFe]K@03L71`0Vm_K`9]KFd00f][JfUYJFUYJ@02
J6QX0fMWI`9XJ6P00f][Jfe]KFe]K@02KVi^0Va/K003JFUYIFEUIFEU00=RHV82Hf=S0VEUI@=WIfL3
J6QX0VUYJ@9ZJVX00fa/K6e]KFe]K@02KFe]00=/K6aYJFUYJFT00VMWI`03IFEUHf=SHf=S00=SHf<2
IFEU0VUYJ@03K6a/Kfm_Kfm_009aLG43Lg=c0W5aL@03JVYZGEeMGEeM00Coool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`:a/K400jRXZ:2PX:2PX002VIVI00>CTi>@T92@T9000Xj>
SP03Shn?Ti>CTi>C00:HV9P00inOWjJVYZJVYP02[Zj^00>e]KFl_;bl_;`00/71`@03aLG5alO7alO7
00;9bLT00l[:b/_;bl_;b`02c<c<0lg=c@;>c/h00lo?cm3@d=3@d002dM7A00?Bd];Cdm?Cdm<00]CD
e0;EeMD00mOGemSHf=SHf002f][J00?Lg=cMgMgMgMd00]kNgP?Ogml3g]kN0]gMg@;Kfm/3f][J0mWI
f@;Jf]X2fm_K00?Lg=cMgMgMgMd00]kNgP?Ogml7h>3P2moOgaKPh>03gmoO1=kNgP[MgMd3g]kN0]oO
g`?Ph>04hN7Q0n;RhP[Shn<2h^;R00?QhN7Ph>3Ph>001moOg`03hN7Qhn?Shn?S00;UiND00nKVi^SX
j>SXj005jNWY0^OWi`03i>CTh>3Ph>3P00;Kfm/00mKFe]3@d=3@d002bLW900?2`/:i^KVi^KT01?oo
o`030000oooooooo03;oool010000?ooooooooooo`9?Cdl00dA4A4=3@d=3@`02D51@00=UIFElO7al
O7`00X^;R`03S8b<Q8B4Q8B4009iNGT00g9bLWAdM7AdM002OGem00>5QHF7QhN7QhL00X61P@03MWIf
JVYZJVYZ009RHV800f5QHFIVIVIVIP02K6a/00=aLG5eMGEeMGD00WMgM`03MWIfLg=cLg=c009/K6`0
0fATI5eMGEeMG@02FEUI0UeMG@03IFEUKVi^KVi^009eMGD00gMgMgEeMGEeM@02L71`00=/K6aZJVYZ
JVX00VUYJ@03JVYZJf][Jf][009]KFd00g1`L7=cLg=cL`02MWIf00=iNGUjNWYjNWX00WYjNP03MgMg
L71`L71`009XJ6P00f1PH5aLG5aLG002GEeM00=RHV9YJFUYJFT00Vm_K`=aLG42L71`00=_Kfm^KVi^
KVh00fe]K@M/K6`2KFe]00=^KVi_Kfm_Kfl00g1`L09]KFd2JVYZ00=WIfMUIFEUIFD00VIVIP03JVYZ
KFe]KFe]00=`L702Kfm_0Ve]K@03Jf][JFUYJFUY009XJ6P3IfMW0VQXJ003Jf][KFe]KFe]009^KVh2
K6a/00=YJFUUIFEUIFD00f9RHP9SHf<2IFEU0fMWI`=XJ6P2JFUY0VYZJP03K6a/KFe]KFe]009]KFd0
0fa/K6UYJFUYJ@02IfMW00=UIFESHf=SHf<00f=SH`9UIFD2JFUY00=/K6a_Kfm_Kfl00W5aL@=cLg<2
LG5a00=ZJVYMGEeMGEd01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0Z^[
Z`03X:2PUYJFUYJF00:<S8`00hB4Q7inOWinOP03Ng]k0WinOP:3Ph<00hZ:RY:BTY:BTP02VYZJ00>R
XZ:YZJVYZJT00[2`/003];Bd^;Rh^;Rh00:k^k/00kjn_/30`<30`002`/;200?3`l?5aLG5aLD00/O7
a`03bLW9bl_;bl_;00;<c<`00lg=cLo?clo?c`02d=3@0];BdP03e=CDe]KFe]KF00;GemL00mWIfM_K
fm_Kf`07g=cL00?Kfm_Jf][Jf]X00]WIf@?Hf=P3emOG0]SHf0;IfMT00m[Jf]_Kfm_Kf`02g=cL0mkN
gP;Ogml;h>3P1N7Qh@[Rh^82hn?S2>;RhPCQhN43h>3P0]oOg`KNg]h4gmoO00?Ph>3QhN7QhN400^;R
hP03hn?Si>CTi>CT00;UiND3i^KV2^OWi`CVi^H00nGUiNCTi>CTi005i>CT0^GUi@03i^KVj>SXj>SX
00;Zj^X00nc/k>k^k^k^kP05k^k^0^c/k003j>SXi>CTi>CT00;Ogml00mWIfM;Bd];BdP02b/[:00?0
`<2f][Jf][H01?ooo`030000oooooooo03;oool010000?ooooooooooo`97AdL00cTi>CLg=cLg=`02
B4Q800=SHf>1PH61PH400YBDU003UIFERXZ:RXZ:009jNWX00g5aLG=cLg=cL`02OWin00>:RXZ>SXj>
SXh00XN7Q`03NGUiJf][Jf][009RHV800f5QHFQXJ6QXJ002L71`00=gMgMkNg]kNg/00W]kN`03N7Qh
Lg=cLg=c009ZJVX00f1PH5MGEeMGE`02E5AD0UUIF@03I6ATLG5aLG5a009iNGT00g]kNgMgMgMgM`02
LW9b00=/K6aZJVYZJVX00VUYJ@03Jf][K6a/K6a/009_Kfl00g5aLGAdM7AdM002MWIf00=iNGUkNg]k
Ng/00WYjNP03MgMgKfm_Kfm_009VIVH00eeMGEQHF5QHF002Fe]K00=QHF5YJFUYJFT00Vm_K`03LG5a
Kfm_Kfm_009/K6`00fUYJFQXJ6QXJ002JFUY00=[Jf]/K6a/K6`00f][J`AZJVX00fa/K6i^KVi^KP03
Kfm_0Va/K09WIfL00f=SHf5QHF5QH@02HV9R00=VIVIZJVYZJVX00Ve]K@03KVi^K6a/K6a/009ZJVX0
0fQXJ6EUIFEUI@02Hf=S0f9RHP9SHf<00fIVIVUYJFUYJ@02JVYZ0VQXJ003IFEUHF5QHF5Q009NGUh0
0eeMGEiNGUiNGP02H61P00=RHV9SHf=SHf<00fATI09UIFD2IfMW00=XJ6QYJFUYJFT00VQXJ003IVIV
HV9RHV9R009OGel00eaLG5]KFe]KF`02G5aL00=NGUiQHF5QHF400VEUI@03JFUYK6a/K6a/009_Kfl0
0g5aLG9bLW9bLP02L71`00=XJ6QHF5QHF5P01?ooo`030000oooooooo013oool002Goool200000ooo
o`:UYJD00iRHV8^;Rh^;R`02Ogmo00=eMGE]KFe]KFd00VQXJ003IfMWJFUYJFUY009^KVh00gAdM7em
OGemO@02QHF500>>SXjFUYJFUYH00YfMW@03Xj>SZ:RXZ:RX00:/[:`00jn_[k>c/k>c/`02][Jf00>h
^;Rk^k^k^k/00[jn_P03`L71`l?3`l?300;6a/H00lS8b<[:b/[:bP02bl_;0/g=c@03clo?dM7AdM7A
00;Cdm<00mGEeMOGemOGe`03f=SH0]WIf@?Hf=P2emOG0]KFeP?EeMD2e=CD0mGEe@;Fe]H00mOGemWI
fMWIf@02f][J00?Kfm_Lg=cLg=`00]gMg@?Ng]h3gmoO1N3Ph0CQhN43h^;R1n?Sh`03i>CThn?Shn?S
00OShn<3h^;R0^7Qh@?Ph>02gmoO1]kNgP;Ogml2h>3P00?QhN7Shn?Shn<00^CTi003i^KVinOWinOW
00;Xj>P7jNWY00?Zj^[YjNWYjNT00nWYj@GXj>P4inOW0nSXj0;YjNT00n_[jng]kNg]k@02kno_00?a
lO7bl_;bl_800_?cl`03l_;blO7alO7a00;_knl00n_[jnOWinOWi`02hN7Q00?Kfm_Cdm?Cdm<00/W9
b@03_kno/[:b/[:b00?oool20000=?ooo`040000oooooooooooo0T=3@`03;bl_:RXZ:RXZ008m?Cd0
0f1PH8B4Q8B4Q002W9bL00>MWIf>SXj>SXh00WYjNP03K6a/KVi^KVi^009jNWX00hR8R8j>SXj>SP02
R8R800=jNWY/K6a/K6`00VATI003IVIVKfm_Kfm_009iNGT00h20P8:2PX:2PP02P82000=kNg]cLg=c
Lg<00VYZJP03H61PFEUIFEUI009GEeL2GEeM00=YJFUeMGEeMGD00ginOP9hN7P2LG5a00=[Jf]YJFUY
JFT00V][J`03KFe]L71`L71`00=aLG44LW9b1G=cL`03L71`Jf][Jf][009TI6@00emOGeeMGEeMG@02
H61P00=VIVI]KFe]KFd00W1`L003KVi^J6QXJ6QX009RHV800eiNGUmOGemOG`02Hf=S00=XJ6Q/K6a/
K6`00Ve]K@03Jf][J6QXJ6QX009WIfL00fQXJ6YZJVYZJP03Jf][0VQXJ09TI6@00f5QHEmOGemOG`02
GemO00=RHV9UIFEUIFD00fQXJ09WIfL2IVIV00=TI6ARHV9RHV800V1PH0=NGUh2GemO00=QHF5SHf=S
Hf<00VATI09SHf<00f5QHEiNGUiNGP05G5aL0UeMG@03GemOH61PH61P009QHF400f=SHfATI6ATI002
IFEU00=VIVIUIFEUIFD00V=SH`03GemOFUYJFUYJ009EEED3DU9B0UADE003F5QHGEeMGEeM009RHV80
0fEUIFQXJ6QXJ002K6a/00=bLW9gMgMgMgL00WQhN003L71`G5aLG5aL00?oool200004_ooo`009Ooo
o`030000oooooooo00;oool2YJFU00>HV9R;Rh^;Rh/00WmoO`03MGEeKFe]KFe]009XJ6P00fMWIfUY
JFUYJ@02KVi^00=dM7AmOGemOGd00XF5Q@03SXj>UYJFUYJF00:MWId00j>SXjRXZ:RXZ002[:b/00>_
[jnc/k>c/k<00[Jf]P03^;Rh^k^k^k^k00:n_[h00l71`L?3`l?3``02a/K600?8b<S:b/[:b/X00/_;
b`;=cLd00lo?cm7AdM7Ad@02dm?C00?EeMGGemOGemL00mSHf0;IfMT3f=SH0]OGe`;Fe]H3eMGE0]CD
e0?EeMD2e]KF00?GemOIfMWIfMT00][JfP03fm_Kg=cLg=cL00;MgMd3g]kN0moOg`GPh>04hN7Q0n;R
hPOShn<00nCTi>?Shn?Sh`07hn?S0n;RhP;QhN43h>3P0]oOg`KNg]h2gmoO0^3Ph003hN7Qhn?Shn?S
00;Ti>@00nKVi^OWinOWi`02j>SX1nWYj@03j^[ZjNWYjNWY00?YjNT5j>SX1>OWi`?Xj>P2jNWY00?[
jn_]kNg]kNd00^o_k`03lO7al_;bl_;b00;clo<00o;bl_7alO7al@02kno_00?[jn_WinOWinL00^7Q
h@03fm_Kdm?Cdm?C00;9bLT00kno_k:b/[:b/P04oooo00<0003oooooool0<_ooo`040000oooooooo
oooo0T=3@`03;bl_:RXZ:RXZ008m?Cd00f1PH8B4Q8B4Q002W9bL00>MWIf>SXj>SXh00WYjNP03K6a/
KVi^KVi^009jNWX00hR8R8j>SXj>SP02R8R800=jNWY/K6a/K6`00VATI003IVIVKfm_Kfm_009iNGT0
0h20P8:2PX:2PP02P82000=kNg]cLg=cLg<00VYZJP03H61PFEUIFEUI009GEeL2GEeM00=YJFUeMGEe
MGD00ginOP9hN7P2LG5a00=[Jf]YJFUYJFT00V][J`03KFe]L71`L71`00=aLG44LW9b1G=cL`03L71`
Jf][Jf][009TI6@00emOGeeMGEeMG@02H61P00=VIVI]KFe]KFd00W1`L003KVi^J6QXJ6QX009RHV80
0eiNGUmOGemOG`02Hf=S00=XJ6Q/K6a/K6`00Ve]K@03Jf][J6QXJ6QX009WIfL00fQXJ6YZJVYZJP03
Jf][0VQXJ09TI6@00f5QHEmOGemOG`02GemO00=RHV9UIFEUIFD00fQXJ09WIfL2IVIV00=TI6ARHV9R
HV800V1PH0=NGUh2GemO00=QHF5SHf=SHf<00VATI09SHf<00f5QHEiNGUiNGP05G5aL0UeMG@03GemO
H61PH61P009QHF400f=SHfATI6ATI002IFEU00=VIVIUIFEUIFD00V=SH`03GemOFUYJFUYJ009EEED3
DU9B0UADE003F5QHGEeMGEeM009RHV800fEUIFQXJ6QXJ002K6a/00=bLW9gMgMgMgL00WQhN003L71`
G5aLG5aL00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`:NWYh00hn?Sh20
P820P002LW9b00=VIVILG5aLG5`00UIFEP03De=CEEEEEEEE009IFET00f1PH6QXJ6QXJ002LG5a00=k
Ng^3Ph>3Ph<00X^;R`03TY:BUiNGUiNG00:LW9`00j2PX:BTY:BTY002Z:RX00>/[:b`/;2`/;000[>c
/`03]kNg^[Zj^[Zj00:m_Kd00l30`<;2`/;2`P02a<C40/O7a`03bLW9bl_;bl_;00;=cLd00lo?cm3@
d=3@d002dM7A00?Bd];Cdm?Cdm<01M;BdP;AdM46d=3@0]7Ad@;Bd]800m?CdmCDe=CDe002eMGE00?G
emOHf=SHf=P00]WIf@03f][Jfm_Kfm_K00;Kfm/00mcLg=gMgMgMg@02gMgM00?Ng]kOgmoOgml00n3P
h0;QhN4=h^;R1>7Qh@?Ph>02gmoO00?Ng]kMgMgMgMd00]gMg@GLg=`00mgMgMkNg]kNgP02gmoO00?Q
hN7Rh^;Rh^800^CTi003i^KVinOWinOW00CYjNT5j^[Z1^WYj@OXj>P3jNWY0^[ZjP;/k>`00ng]kNo_
kno_k`02lO7a00?bl_;clo?clo<00_Cdm003lo?cl_;bl_;b00;_knl00nc/k>OWinOWi`02hN7Q00?J
f][AdM7AdM400/O7a`03^k^k[Jf][Jf]00Coool00`000?ooooooo`0boooo00@0003oooooooooool2
ATI600<Y:BTO7alO7al00S<c<`03Fe]KQXJ6QXJ600:RXZ800j>SXi2@T92@T002N7Qh00=WIfMVIVIV
IVH00W9bLP03OgmoQhN7QhN700:3Ph<00gUiNFi^KVi^KP02JVYZ00=^KVihN7QhN7P00X>3P`>9RHT2
Q8B400=lO7acLg=cLg<00V][J`03I6ATGemOGemO009OGel2IVIV00=aLG5kNg]kNg/00X61P@03Ogmo
N7QhN7Qh009^KVh3J6QX0Va/K003LG5aM7AdM7Ad009dM7@00g9bLVi^KVi^KP02Jf][00=XJ6QWIfMW
IfL00fIVIP9UIFD2I6AT00=UIFEWIfMWIfL00VYZJP03Kfm_LW9bLW9b009`L7000fUYJEmOGemOG`02
EEEE00=ADE5DE5ADE5@00UeMG@03IfMWKVi^KVi^009_Kfl00fa/K6MWIfMWI`03Hf=S0VATI09VIVH0
0fMWIfEUIFEUI@02Hf=S00=PH61OGemOGel00emOG`9QHF45HV9R0f5QH@9PH602GemO00=NGUiMGEeM
GEd00eeMG@ANGUh7GemO00=NGUiLG5aLG5`00eaLG09NGUh2HF5Q00=TI6AVIVIVIVH00VIVIP03IFEU
Hf=SHf=S009OGel00eUIFE9BDU9BDP02C4a<00=8B4Q9BDU9BDT00Te=C@03De=CFUYJFUYJ009NGUh0
0f9RHVEUIFEUI@02Jf][00=eMGF0P820P8000XN7Q`03OgmoIfMWIfMW00Coool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`:NWYh00hn?Sh20P820P002LW9b00=VIVILG5aLG5`00UIF
EP03De=CEEEEEEEE009IFET00f1PH6QXJ6QXJ002LG5a00=kNg^3Ph>3Ph<00X^;R`03TY:BUiNGUiNG
00:LW9`00j2PX:BTY:BTY002Z:RX00>/[:b`/;2`/;000[>c/`03]kNg^[Zj^[Zj00:m_Kd00l30`<;2
`/;2`P02a<C40/O7a`03bLW9bl_;bl_;00;=cLd00lo?cm3@d=3@d002dM7A00?Bd];Cdm?Cdm<01M;B
dP;AdM46d=3@0]7Ad@;Bd]800m?CdmCDe=CDe002eMGE00?GemOHf=SHf=P00]WIf@03f][Jfm_Kfm_K
00;Kfm/00mcLg=gMgMgMg@02gMgM00?Ng]kOgmoOgml00n3Ph0;QhN4=h^;R1>7Qh@?Ph>02gmoO00?N
g]kMgMgMgMd00]gMg@GLg=`00mgMgMkNg]kNgP02gmoO00?QhN7Rh^;Rh^800^CTi003i^KVinOWinOW
00CYjNT5j^[Z1^WYj@OXj>P3jNWY0^[ZjP;/k>`00ng]kNo_kno_k`02lO7a00?bl_;clo?clo<00_Cd
m003lo?cl_;bl_;b00;_knl00nc/k>OWinOWi`02hN7Q00?Jf][AdM7AdM400/O7a`03^k^k[Jf][Jf]
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2ATI600<Y:BTO7alO7al00S<c<`03Fe]K
QXJ6QXJ600:RXZ800j>SXi2@T92@T002N7Qh00=WIfMVIVIVIVH00W9bLP03OgmoQhN7QhN700:3Ph<0
0gUiNFi^KVi^KP02JVYZ00=^KVihN7QhN7P00X>3P`>9RHT2Q8B400=lO7acLg=cLg<00V][J`03I6AT
GemOGemO009OGel2IVIV00=aLG5kNg]kNg/00X61P@03OgmoN7QhN7Qh009^KVh3J6QX0Va/K003LG5a
M7AdM7Ad009dM7@00g9bLVi^KVi^KP02Jf][00=XJ6QWIfMWIfL00fIVIP9UIFD2I6AT00=UIFEWIfMW
IfL00VYZJP03Kfm_LW9bLW9b009`L7000fUYJEmOGemOG`02EEEE00=ADE5DE5ADE5@00UeMG@03IfMW
KVi^KVi^009_Kfl00fa/K6MWIfMWI`03Hf=S0VATI09VIVH00fMWIfEUIFEUI@02Hf=S00=PH61OGemO
Gel00emOG`9QHF45HV9R0f5QH@9PH602GemO00=NGUiMGEeMGEd00eeMG@ANGUh7GemO00=NGUiLG5aL
G5`00eaLG09NGUh2HF5Q00=TI6AVIVIVIVH00VIVIP03IFEUHf=SHf=S009OGel00eUIFE9BDU9BDP02
C4a<00=8B4Q9BDU9BDT00Te=C@03De=CFUYJFUYJ009NGUh00f9RHVEUIFEUI@02Jf][00=eMGF0P820
P8000XN7Q`03OgmoIfMWIfMW00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_oo
o`:FUYH00hF5QGEeMGEeM@02IFEU00=GEeM<C4a<C4`00TE5A@03@D51@T92@T920096ATH00de=CEEE
EEEEE@02GemO00=XJ6QaLG5aLG400WUiN@03P820QXJ6QXJ600:;Rh/00i2@T9FEUIFEU@02VIVI00>N
WYjRXZ:RXZ800ZJVYP03ZZZZ[Zj^[Zj^00:b/[800kFe]KRh^;Rh^002^[Zj0[fm_@03_kno`L71`L71
00;3`l<00lG5aLO7alO7a`02b<S800?9bLW:b/[:b/X01l[:bPG9bLT3b/[:0/_;b`03c<c<cLg=cLg=
00;>c/h00lo?cm3@d=3@d002dM7A00?Bd];Cdm?Cdm<00]CDe003eMGEe]KFe]KF00;GemL00mWIfM[J
f][JfP02fm_K0mcLg0;MgMd8g]kN0mgMg@CLg=`00m_Kfm[Jf][JfP02f][J00?IfMWHf=SHf=P01mSH
f003fMWIf][Jf][J00;Lg=`00mgMgMoOgmoOg`02hN7Q00?Shn?UiNGUiND00^KViPGWinL5i^KV2>GU
i@CVi^H00nOWinWYjNWYj@02j^[Z00?/k>c]kNg]kNd00^o_k`03l?3`lO7alO7a00;alO400o3`l>k^
k^k^kP02jn_[00?Xj>SShn?Shn<00]gMg@03eMGEcLg=cLg=00;2`/800kFe]JJVYZJVYP04oooo00<0
003oooooool0<_ooo`040000oooooooooooo0T];B`039RHV61PH61PH008/;2`00eMGEhJ6QXJ6QP02
YJFU00>VYZJATI6ATI400WEeM@03HF5QGUiNGUiN009XJ6P00gAdM7alO7alO002O7al00=eMGE_Kfm_
Kfl00Vi^KP03MGEeP820P82000::RXX00hn?Shf=SHf=S@02QHF500=kNg]bLW9bLW800V][J`03J6QX
IfMWIfMW009ZJVX2L71`00=iNGV0P820P8000X>3P`03OgmoMWIfMWIf009/K6`00fEUIFIVIVIVIP02
K6a/00=cLg=gMgMgMgL00WIfMP03LG5aJf][Jf][009UIFD00f1PH5aLG5aLG002FUYJ00=KFe]OGemO
Gel00VIVIP03K6a/LW9bLW9b009fMWH00gQhN7IfMWIfMP02L71`00=UIFEGEeMGEeL00T];B`03AdM7
C4a<C4a<009JFUX00fQXJ79bLW9bLP02M7Ad00=^KViVIVIVIVH00V1PH003GUiNGemOGemO009QHF40
0f=SHfATI6ATI002Hf=S00=RHV9QHF5QHF400V1PH003GemOGUiNGUiN00ENGUh3GemO1F1PH09OGel2
GEeM00=KFe]JFUYJFUX00UYJFP9LG5`00emOGf=SHf=SH`02I6AT00=SHf=PH61PH6000UeMG@03G5aL
GUiNGUiN009RHV800fIVIVUYJFUYJ@02JFUY00=WIfMSHf=SHf<00UiNGP03EUIFCTi>CTi>0098B4P0
0dA4A4E5ADE5A@02BTY:00=ADE5HF5QHF5P00UeMG@03H61PHf=SHf=S009[Jf/00gYjNX^;Rh^;R`02
UYJF00>@T91dM7AdM7@01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0Xb<
S003Ng]kJFUYJFUY009HF5P00dY:BShn?Shn?P02=SHf00<b<S8c<c<c<c<00SHf=P03?CdmADE5ADE5
009>CTh00eQHF65QHF5QH@02JFUY00=`L71fMWIfMWH00W]kN`03P820Q8B4Q8B400:9RHT00hf=SI:B
TY:BTP02UYJF00>KVi^OWinOWil00Z>SX`03YjNWZZZZZZZZ00:][Jd2[jn_00>b/[:d];Bd];@00[Jf
]P03^;Rh^KVi^KVi00:k^k/00kbl_;fm_Kfm_@03_[jn1;no_`S0`<05`L710/;2`P?3`l<2aLG500?6
a/K7alO7alL00/S8b003b/[:bl_;bl_;00;=cLd00lo?cm3@d=3@d002dM7A00?Cdm?De=CDe=@00mGE
e@GFe]H4eMGE00?De=CCdm?Cdm<00];BdP?AdM43d=3@1<o?c`?@d=02dM7A00?Bd];Cdm?Cdm<00]GE
e@03emOGfMWIfMWI00;Kfm/00mgMgMkNg]kNgP02gmoO0n3Ph0COgml3g]kN1MgMg@?Ng]h2gmoO0^3P
h003hN7Qhn?Shn?S00;Ti>@00nGUiNOWinOWi`02j>SX00?YjNWXj>SXj>P00^SXj003i^KVi>CTi>CT
00;Rh^800mkNg][Jf][JfP02e=CD00?=cLg4a<C4a<@00[Vi^@03[:b/WIfMWIfM00Coool00`000?oo
ooooo`0boooo00@0003oooooooooool2De=C00<Z:RXH61PH61P00RTY:@03E5ADPh>3Ph>300:RXZ80
0jBTY8n?Shn?S`02Lg=c00=NGUiHF5QHF5P00UiNGP03JFUYL71`L71`009bLW800fm_Kfe]KFe]K@02
L71`00=hN7R2PX:2PX800X^;R`03SXj>RHV9RHV900:0P8000gEeMFa/K6a/K003JFUY0Va/K09aLG42
MgMg00=nOWj3Ph>3Ph<00X>3P`03OWinM7AdM7Ad009ZJVX00fATI6EUIFEUI@02Jf][00=aLG5fMWIf
MWH00WIfMP03Lg=cKVi^KVi^009WIfL00f1PH5YJFUYJFP02EUIF00=GEeMNGUiNGUh00VQXJ003Lg=c
O7alO7al00:0P8000ginOWUiNGUiN@02L71`00=RHV9CDe=CDe<00TM7A`03A4A4CDe=CDe=009MGEd0
0fm_KgYjNWYjNP02NWYj00=aLG5VIVIVIVH00UaLG003FEUIFe]KFe]K009OGel00f9RHVEUIFEUI@02
IVIV0fMWI`9UIFD00fATI65QHF5QH@02H61P0emOG`9PH6000f9RHV=SHf=SH`02I6AT00=UIFETI6AT
I6@00V5QH@03G5aLFEUIFEUI009IFET2GEeM00=TI6A[Jf][Jf/00Vm_K`03KFe]IfMWIfMW009PH600
0eeMGEmOGemOG`02I6AT00=ZJVY_Kfm_Kfl00Vm_K`03KFe]J6QXJ6QX009RHV800e]KFeADE5ADE002
CTi>0dY:BP9>CTh00eEEEE]KFe]KF`02GemO00=QHF5TI6ATI6@00Ve]K@03OgmoU9BDU9BD00:SXj<0
0ijNWX20P820P004oooo00<0003oooooool04?ooo`005?ooo`D000001?ooo`000000000000?oool0
0`000?ooooooo`02oooo00<0003oooooool00_ooo`:<S8`00g]kNfUYJFUYJ@02F5QH00=:BTXn?Shn
?Sh00SHf=P03<S8b<c<c<c<c008f=SH00cdm?DE5ADE5A@02CTi>00=HF5QQHF5QHF400VUYJ@03L71`
MWIfMWIf009kNg/00h20P8B4Q8B4Q002RHV900>=SHfBTY:BTY800YJFUP03Vi^KWinOWinO00:SXj<0
0jNWYjZZZZZZZP02[Jf]0Zn_[`03/[:b];Bd];Bd00:f][H00kRh^;Vi^KVi^@02^k^k00>l_;bm_Kfm
_Kd00kjn_PBo_kl8`<301L71`@;2`/83`l?30/G5a@03a/K6alO7alO700;8b<P00l[:b/_;bl_;b`02
cLg=00??clo@d=3@d=000]7Ad@03dm?Ce=CDe=CD00?EeMD5e]KF1=GEe@03e=CDdm?Cdm?C00;Bd]83
dM7A0m3@d0C?cll3d=3@0]7Ad@03d];Bdm?Cdm?C00;EeMD00mOGemWIfMWIf@02fm_K00?MgMgNg]kN
g]h00]oOg`?Ph>04gmoO0mkNgPGMgMd3g]kN0]oOg`;Ph>000n7QhN?Shn?Sh`02i>CT00?UiNGWinOW
inL00^SXj003jNWYj>SXj>SX00;Xj>P00nKVi^CTi>CTi002h^;R00?Ng]kJf][Jf]X00]CDe003cLg=
a<C4a<C400:i^KT00jb/[9fMWIfMW@04oooo00<0003oooooool08?ooo`D000001?ooo`0000000000
00?oool00`000?ooooooo`03oooo00@0003oooooooooool2De=C00<Z:RXH61PH61P00RTY:@03E5AD
Ph>3Ph>300:RXZ800jBTY8n?Shn?S`02Lg=c00=NGUiHF5QHF5P00UiNGP03JFUYL71`L71`009bLW80
0fm_Kfe]KFe]K@02L71`00=hN7R2PX:2PX800X^;R`03SXj>RHV9RHV900:0P8000gEeMFa/K6a/K003
JFUY0Va/K09aLG42MgMg00=nOWj3Ph>3Ph<00X>3P`03OWinM7AdM7Ad009ZJVX00fATI6EUIFEUI@02
Jf][00=aLG5fMWIfMWH00WIfMP03Lg=cKVi^KVi^009WIfL00f1PH5YJFUYJFP02EUIF00=GEeMNGUiN
GUh00VQXJ003Lg=cO7alO7al00:0P8000ginOWUiNGUiN@02L71`00=RHV9CDe=CDe<00TM7A`03A4A4
CDe=CDe=009MGEd00fm_KgYjNWYjNP02NWYj00=aLG5VIVIVIVH00UaLG003FEUIFe]KFe]K009OGel0
0f9RHVEUIFEUI@02IVIV0fMWI`9UIFD00fATI65QHF5QH@02H61P0emOG`9PH6000f9RHV=SHf=SH`02
I6AT00=UIFETI6ATI6@00V5QH@03G5aLFEUIFEUI009IFET2GEeM00=TI6A[Jf][Jf/00Vm_K`03KFe]
IfMWIfMW009PH6000eeMGEmOGemOG`02I6AT00=ZJVY_Kfm_Kfl00Vm_K`03KFe]J6QXJ6QX009RHV80
0e]KFeADE5ADE002CTi>0dY:BP9>CTh00eEEEE]KFe]KF`02GemO00=QHF5TI6ATI6@00Ve]K@03Ogmo
U9BDU9BD00:SXj<00ijNWX20P820P004oooo00<0003oooooool04?ooo`005_ooo`050000oooooooo
oooo000000Coool00`000?ooo`000003oooo00<0003oooooool00_ooo`:0P8000fm_KeeMGEeMG@02
CDe=00<n?Shb<S8b<S800RXZ:P<V9RH2:RXZ00<`<30i>CTi>CT00T92@P03Bd];E5ADE5AD009KFe/0
0f5QHFIVIVIVIP02Jf][00=_KfmcLg=cLg<00WMgM`03Ng]kOgmoOgmo00:4Q8@00hV9RHf=SHf=S@02
TI6A00>EUIFHV9RHV9P00Y^KV`:NWYh00j6QXJ>SXj>SX`02YJFU00>VYZJXZ:RXZ:P00ZZZZP03Zj^[
[Jf][Jf]00:^[Zh00k2`/;6a/K6a/@02/[:b00>c/k>d];Bd];@01KBd]0>c/k<5/[:b1;>c/`03]KFe
][Jf][Jf00:h^;P00kZj^[bl_;bl_002_[jn00?0`<32`/;2`/800/?3``03aLG5a/K6a/K600;7alL0
0lS8b<W9bLW9b@03bLW90/S8b0;7alL00lK6a/G5aLG5a@02a<C400?3`l?2`/;2`/801L;2`P;3`l<0
0lC4a<G5aLG5a@02a/K600?7alO9bLW9bLT00/_;b`03cLg=c/k>c/k>00;@d=000m7AdM?Cdm?Cd`02
dm?C0mCDe0CCdm<00m;Bd]7AdM7Ad@05dM7A0m;BdP;De=@2eMGE00?Fe]KGemOGemL00]WIf@03f][J
fm_Kfm_K00?Kfm/2f][J0]WIf@03emOGeMGEeMGE00;Bd]800lo?cl[:b/[:bP02aLG500>o_knf][Jf
][H00Zb/[003X:2PTI6ATI6A00Coool00`000?ooooooo`0Roooo00D0003oooooooooool000001?oo
o`030000oooo000000Coool010000?ooooooooooo`9LG5`00c<c<b0P820P8002;Rh^00=CDe=nOWin
OWh00YZJVP03WIfMRXZ:RXZ:009bLW800eiNGUIFEUIFEP02FEUI00=OGemTI6ATI6@00fMWI`9XJ6P2
K6a/00=dM7AlO7alO7`00h:2PP9mOGd2Lg=c00=YJFURHV9RHV800V5QH@03IFEUJf][Jf][009cLg<2
NGUi00=nOWj1PH61PH400X20P003Ng]kLg=cLg=c009[Jf/00fIVIVEUIFEUI@02IfMW00=[Jf]`L71`
L7000WAdM003MgMgN7QhN7Qh009fMWH00fm_KfIVIVIVIP02GUiN00=LG5aRHV9RHV800Ve]K@03NGUi
PX:2PX:200:4Q8@00h20P7YjNWYjNP02Kfm_00=SHf=FEUIFEUH00Te=C@03C4a<EeMGEeMG009YJFT0
0galO8J6QXJ6QP02Ph>300=fMWIVIVIVIVH00UYJFP03EUIFFEUIFEUI009OGel00fEUIFYZJVYZJP02
KFe]00=_Kfm`L71`L7000W1`L003KVi^K6a/K6a/009ZJVX00fQXJ6MWIfMWI`02IfMW00=XJ6QZJVYZ
JVX00Va/K003KFe]K6a/K6a/009XJ6P00f5QHEaLG5aLG002G5aL0V=SH`03KVi^NGUiNGUi009oOgl0
0g]kNg5aLG5aL@02IVIV00=PH61QHF5QHF400VQXJ003LG5aMgMgMgMg009iNGT00gMgMg=cLg=cL`02
Kfm_00=ZJVYVIVIVIVH00V5QH@03GUiNG5aLG5aL009MGEd00emOGf9RHV9RHP02I6AT00=UIFEXJ6QX
J6P00W5aL@03Q8B4VIVIVIVI00:XZ:P00jFUYHR8R8R8R004oooo00<0003oooooool04?ooo`005_oo
o`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000003oooo0`0000;oool2P82000=_
KfmMGEeMGEd00Te=C@03?Shn<S8b<S8b008Z:RX39RHV0RXZ:P03<30`>CTi>CTi0092@T800d];BeAD
E5ADE002Fe]K00=QHF5VIVIVIVH00V][J`03Kfm_Lg=cLg=c009gMgL00g]kNgmoOgmoO`02Q8B400>9
RHV=SHf=SHd00Y6AT@03UIFEV9RHV9RH00:KVi/2WYjN00>QXJ6SXj>SXj<00ZFUY@03YZJVZ:RXZ:RX
00:ZZZX00j^[Zjf][Jf][@02[Zj^00>`/;2a/K6a/K400[:b/P03/k>c];Bd];Bd00Fd];@3/k>c1K:b
/PBc/k<00kFe]KJf][Jf]P02^;Rh00>j^[Zl_;bl_;`00[jn_P03`<30`/;2`/;200;3`l<00lG5aLK6
a/K6aP02alO700?8b<S9bLW9bLT00lW9b@;8b<P2alO700?6a/K5aLG5aLD00/C4a003`l?3`/;2`/;2
00G2`/82`l?300?4a<C5aLG5aLD00/K6aP03alO7bLW9bLW900;;bl/00lg=cLk>c/k>cP02d=3@00?A
dM7Cdm?Cdm<00]?Cd`?De=@4dm?C00?Bd];AdM7AdM401M7Ad@?Bd]82e=CD0]GEe@03e]KFemOGemOG
00;IfMT00m[Jf]_Kfm_Kf`03fm_K0][JfP;IfMT00mOGemGEeMGEe@02d];B00??clo:b/[:b/X00/G5
a@03_kno][Jf][Jf00:/[:`00j2PX96ATI6AT@03oooo0P0002Coool00`000?ooooooo`02oooo00L0
003oooooooooool0003oool000001?ooo`800002oooo0UaLG003<c<c820P820P008^;Rh00e=CDgin
OWinOP02VYZJ00>MWIf:RXZ:RXX00W9bLP03GUiNEUIFEUIF009IFET00emOGfATI6ATI003IfMW0VQX
J09/K6`00gAdM7alO7alO003PX:20WemO@9cLg<00fUYJF9RHV9RHP02HF5Q00=UIFE[Jf][Jf/00W=c
L`9iNGT00ginOX61PH61P@02P82000=kNg]cLg=cLg<00V][J`03IVIVIFEUIFEU009WIfL00f][Jg1`
L71`L002M7Ad00=gMgMhN7QhN7P00WIfMP03Kfm_IVIVIVIV009NGUh00eaLG69RHV9RHP02KFe]00=i
NGV2PX:2PX800XB4Q003P820NWYjNWYj009_Kfl00f=SHeIFEUIFEP02CDe=00=<C4aGEeMGEeL00VUY
J@03O7alQXJ6QXJ600:3Ph<00gIfMVIVIVIVIP02FUYJ00=FEUIIFEUIFET00UmOG`03IFEUJVYZJVYZ
009]KFd00fm_Kg1`L71`L002L71`00=^KVi/K6a/K6`00VYZJP03J6QXIfMWIfMW009WIfL00fQXJ6YZ
JVYZJP02K6a/00=]KFe/K6a/K6`00VQXJ003HF5QG5aLG5aL009LG5`2Hf=S00=^KViiNGUiNGT00Wmo
O`03Ng]kLG5aLG5a009VIVH00f1PH65QHF5QH@02J6QX00=aLG5gMgMgMgL00WUiN@03MgMgLg=cLg=c
009_Kfl00fYZJVIVIVIVIP02HF5Q00=NGUiLG5aLG5`00UeMG@03GemOHV9RHV9R009TI6@00fEUIFQX
J6QXJ002LG5a00>4Q8BIVIVIVIT00ZRXZ003YJFUR8R8R8R800?oool200004_ooo`005_ooo`030000
oooooooo00;oool01`000?ooooooooooo`000?ooo`000003oooo00<0003oooooool00_ooo`9cLg<0
0f=SHe9BDU9BDP02@T9200<d=3@X:2PX:2P00R0P80037AdM7QhN7QhN008Q8B400bPX:2l_;bl_;`02
>3Ph00=1@D59BDU9BDT00Tm?C`03E5ADF5QHF5QH009LG5`00emOGf5QHF5QH@02IFEU00=XJ6Q/K6a/
K6`00W1`L003M7AdNGUiNGUi009mOGd00h61PHB4Q8B4Q002QhN70XZ:RP03S8b<SXj>SXj>00:@T900
0i:BTYBDU9BDU002UYJF00>HV9RJVYZJVYX00YbLW003WYjNXJ6QXJ6Q00:SXj<00jBTY:FUYJFUY@03
YJFU0ZBTY0:SXj<00j:RXZ2PX:2PX002WinO0ijNWP:OWil00j2PX:6QXJ6QX@02Y:BT00>VYZJXZ:RX
Z:P00Z^[Z`03[Jf][jn_[jn_00:b/[800k>c/kFe]KFe]@02][Jf1[Rh^0:g]kL2][Jf00>d];Bc/k>c
/k<00[:b/P03/K6a/;2`/;2`00:`/;000k6a/K:b/[:b/P02/k>c00>e]KFg]kNg]kL00[Rh^003^[Zj
_;bl_;bl00:n_[h00kno_l71`L71`@02`/;20l?3``C4a<@3`l?30l;2`PO1`L42`/;200?3`l?4a<C4
a<@00/G5a@03alO7b<S8b<S800;9bLT3b/[:0/W9b@03b<S8alO7alO700;5aLD00l;2`/30`<30`002
_Kfm00>j^[Zf][Jf][H00[:b/P03[:b/YJFUYJFU00:LW9`00i6ATH>3Ph>3P`04oooo00<0003ooooo
ool08_ooo`030000oooooooo00;oool01`000?ooooooooooo`000?ooo`000004oooo00@0003ooooo
ooooool2IFEU00=0@40^;Rh^;Rh00SLg=`03E5ADMWIfMWIf00:>SXh00i6ATHB4Q8B4Q002LG5a00=Q
HF5HF5QHF5P00UMGE`03F5QHFUYJFUYJ009LG5`00eiNGV5QHF5QH@02IVIV00=[Jf]`L71`L7000W9b
LP03LG5aJf][Jf][009RHV800eYJFUIFEUIFEP02F5QH00=OGemWIfMWIfL00W1`L09fMWH00gYjNW]k
Ng]kN`02Ng]k00=hN7QcLg=cLg<00Vi^KP03JFUYIFEUIFEU00=RHV82IVIV0W1`L003O7alQXJ6QXJ6
00:;Rh/00hF5QGUiNGUiN@02KFe]00=VIVIYJFUYJFT00W9bLP03O7alPh>3Ph>300:3Ph<00ginOWMg
MgMgM`02Kfm_00=VIVINGUiNGUh00UUIF@03G5aLJ6QXJ6QX009jNWX00h^;Ri>CTi>CT`02S8b<00=k
Ng]WIfMWIfL00UUIF@03EEEEFEUIFEUI009RHV800f][Jg5aLG5aL@02MWIf00=iNGUkNg]kNg/00gal
O09kNg/2N7Qh00=fMWIcLg=cLg<00g5aL@9bLW82MGEe0gMgM`9aLG400fUYJF9RHV9RHP02HV9R0V][
J`03NWYjRHV9RHV900:@T9000hZ:RWemOGemO@02KVi^00=TI6AUIFEUIFD00Ve]K@03MgMgP820P820
00:3Ph<00h:2PX20P820P002OWin0gemO@9lO7`00gUiNGEeMGEeM@02LG5a00=^KVi/K6a/K6`00f][
J`9]KFd2MWIf00>7QhNIVIVIVIT00ZNWY`03Y:BTRh^;Rh^;00Coool00`000?ooooooo`0@oooo000F
oooo00L0003oooooooooool0003oool000000_ooo`030000oooo000000?oool00`000?ooooooo`02
oooo0VIVIP03EUIFAdM7AdM7008h>3P00b/[:b4Q8B4Q8@026QXJ00<G5aLH61PH61P00Q`L70038R8R
:BTY:BTY008a<C400cTi>D10@410@002ADE500=9BDU<C4a<C4`00Te=C@03Cdm?D51@D51@009BDU80
0eADE5MGEeMGE`02Fe]K00=OGemSHf=SHf<00VMWI`03Jf][Kfm_Kfm_009bLW82MGEe00=gMgMiNGUi
NGT00W]kN`03O7alOWinOWin00:0P8000h>3PhJ6QXJ6QP02RHV900><S8b?Shn?Shl00Y:BTP03U9BD
UYJFUYJF00:FUYH00iFEUIBDU9BDU002TY:B00>?Shn=SHf=SHd00XZ:RP03RHV9R8R8R8R800:8R8P0
0hV9RH^;Rh^;R`02SHf=00>@T92CTi>CTi<00YJFUP03VIVIVi^KVi^K00:NWYh00j2PX::RXZ:RXP02
Xj>S1ZFUY@:TY:@2XZ:R00>PX:2OWinOWil00YfMW@FLW9`00ifMWInOWinOW`02XZ:R00>TY:BWYjNW
YjL00ZVYZ@03Zj^[[Jf][Jf]00:_[jl3/;2`2K6a/@>`/;02[jn_0jj^[P>][Jd2[Zj^0Zn_[`03/;2`
/[:b/[:b00:c/k<00kFe]KJf][Jf]P05][Jf0[Bd]003/[:b/;2`/;2`00:][Jd00jZZZZRXZ:RXZ002
YJFU00>SXj>PX:2PX:000YbLW003V9RHTY:BTY:B00::RXX00h20P7AdM7AdM004oooo00<0003ooooo
ool08_ooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`000004oooo00@0003ooooo
ooooool2K6a/00=?Cdln?Shn?Sh00T=3@`03EeMGL71`L71`00:2PX800hJ6QWinOWinOP02LW9b00=V
IVIMGEeMGEd00UMGE`03E5ADDU9BDU9B009CDe<00eMGEeaLG5aLG002H61P00=SHf=TI6ATI6@00VAT
I003H61PFUYJFUYJ009DE5@00di>CTe=CDe=C@02DE5A00=IFEUSHf=SHf<00Va/K09bLW800gAdM7Ee
MGEeM@03M7Ad0W=cL`9bLW800fi^KVIVIVIVIP02GUiN00=IFEULG5aLG5`00VYZJP03OWinTY:BTY:B
00:LW9`00iVIVHb<S8b<S002OGem00=aLG5`L71`L7000WEeM@03O7alP820P820009oOgl00gYjNWAd
M7AdM002Kfm_00=ZJVYXJ6QXJ6P00VQXJ003KFe]NWYjNWYj00::RXX00iRHV9bLW9bLW002TY:B00=o
OgmZJVYZJVX00UYJFP03EeMGG5aLG5aL009WIfL00g5aLGUiNGUiN@02OWin00>1PH64Q8B4Q8@00XN7
Q`>8R8P2QXJ600>3Ph=oOgmoOgl00W]kN`03NWYjNg]kNg]k009nOWh00h61PH20P820P002NWYj00=a
LG5ZJVYZJVX00VYZJP9eMGD00hF5QIFEUIFEU@02W9bL00>FUYJ7QhN7QhL00WIfMP=ZJVX2LG5a00=l
O7b5QHF5QHD00XZ:RP>;Rh/2S8b<00>?ShnCTi>CTi<00YBDU003TY:BS8b<S8b<00:3Ph<00g]kNgAd
M7AdM003LG5a0WAdM09kNg/00hV9RINGUiNGU`02XZ:R00>OWin;Rh^;Rh/01?ooo`030000oooooooo
013oool001Goool200001?ooo`030000oooooooo00;oool00`000?ooooooo`02oooo00<0003ooooo
ool00_ooo`9VIVH00eIFETM7AdM7A`02>3Ph00<[:b/Q8B4Q8B400QXJ6P035aLG61PH61PH008L71`0
0b8R8RTY:BTY:@02<C4a00<i>CU0@410@4000TE5A@03BDU9C4a<C4a<009=CDd00dm?Ce1@D51@D002
DU9B00=DE5AGEeMGEeL00U]KF`03GemOHf=SHf=S009WIfL00f][Jfm_Kfm_K`02LW9b0WEeM@03MgMg
NGUiNGUi009kNg/00galO7inOWinOP02P82000>3Ph>6QXJ6QXH00XV9R@03S8b<Shn?Shn?00:BTY80
0iBDU9JFUYJFUP02UYJF00>EUIFDU9BDU9@00Y:BTP03Shn?SHf=SHf=00::RXX00hV9RHR8R8R8R002
R8R800>9RHV;Rh^;Rh/00Xf=S@03T92@Ti>CTi>C00:FUYH00iVIVI^KVi^KV`02WYjN00>PX:2RXZ:R
XZ800Z>SX`JUYJD2Y:BT0Z:RXP03X:2PWinOWinO00:MWId5W9bL00>MWIfOWinOWil00Z:RXP03Y:BT
YjNWYjNW00:YZJT00j^[Zjf][Jf][@02[jn_0k2`/0Va/K43/;2`0Zn_[`>^[Zh3[Jf]0Zj^[P:_[jl0
0k2`/;:b/[:b/P02/k>c00>e]KFf][Jf][H01KJf]P:d];@00k:b/[2`/;2`/002[Jf]00>ZZZZXZ:RX
Z:P00ZFUY@03Xj>SX:2PX:2P00:LW9`00iRHV9:BTY:BTP02RXZ:00>0P81dM7AdM7@01?ooo`030000
oooooooo027oool200001?ooo`030000oooooooo00;oool00`000?ooooooo`03oooo00@0003ooooo
ooooool2K6a/00=?Cdln?Shn?Sh00T=3@`03EeMGL71`L71`00:2PX800hJ6QWinOWinOP02LW9b00=V
IVIMGEeMGEd00UMGE`03E5ADDU9BDU9B009CDe<00eMGEeaLG5aLG002H61P00=SHf=TI6ATI6@00VAT
I003H61PFUYJFUYJ009DE5@00di>CTe=CDe=C@02DE5A00=IFEUSHf=SHf<00Va/K09bLW800gAdM7Ee
MGEeM@03M7Ad0W=cL`9bLW800fi^KVIVIVIVIP02GUiN00=IFEULG5aLG5`00VYZJP03OWinTY:BTY:B
00:LW9`00iVIVHb<S8b<S002OGem00=aLG5`L71`L7000WEeM@03O7alP820P820009oOgl00gYjNWAd
M7AdM002Kfm_00=ZJVYXJ6QXJ6P00VQXJ003KFe]NWYjNWYj00::RXX00iRHV9bLW9bLW002TY:B00=o
OgmZJVYZJVX00UYJFP03EeMGG5aLG5aL009WIfL00g5aLGUiNGUiN@02OWin00>1PH64Q8B4Q8@00XN7
Q`>8R8P2QXJ600>3Ph=oOgmoOgl00W]kN`03NWYjNg]kNg]k009nOWh00h61PH20P820P002NWYj00=a
LG5ZJVYZJVX00VYZJP9eMGD00hF5QIFEUIFEU@02W9bL00>FUYJ7QhN7QhL00WIfMP=ZJVX2LG5a00=l
O7b5QHF5QHD00XZ:RP>;Rh/2S8b<00>?ShnCTi>CTi<00YBDU003TY:BS8b<S8b<00:3Ph<00g]kNgAd
M7AdM003LG5a0WAdM09kNg/00hV9RINGUiNGU`02XZ:R00>OWin;Rh^;Rh/01?ooo`030000oooooooo
013oool002Goool00`000?ooooooo`02oooo0UQHF003Bd];?Cdm?Cdm008`<3000bDU9A/K6a/K6`02
5ADE00<C4a<E5ADE5AD00QTI6@037alO9RHV9RHV008];Bd00c@d=3Xj>SXj>P02?Shn2T10@003@D51
@d=3@d=30096ATH00dY:BTi>CTi>CP02DU9B00=FEUIIFEUIFET00UeMG@9OGel00f5QHF=SHf=SH`02
IFEU00=VIVIXJ6QXJ6P00VYZJP03KFe]LG5aLG5a009eMGD00gUiNGemOGemO@02PH6100>4Q8B6QXJ6
QXH00XN7Q`03QXJ6Ph>3Ph>300:0P8000gemOGUiNGUiN@02MWIf00=cLg=aLG5aLG400W5aL@03LW9b
M7AdM7Ad009fMWH00gUiNGalO7alO002P82000>3Ph>6QXJ6QXH00XV9R@03Rh^;SXj>SXj>00:?Shl0
0i6ATI:BTY:BTP02TY:B00>ATI6?Shn?Shl00Xj>SP03S8b<RXZ:RXZ:00:8R8P00hN7QhJ6QXJ6QP02
QhN700>9RHV<S8b<S8`00Xn?S`03TY:BUYJFUYJF00:IVIT00i^KVifMWIfMW@02WYjN1YnOW`:NWYh4
WIfM00>LW9bKVi^KVi/00YZJVP03VIVIV9RHV9RH00>HV9P2VIVI0YZJVP03W9bLWIfMWIfM00:OWil0
0j6QXJ:RXZ:RXP02XZ:R00>QXJ6PX:2PX:000YjNWP03Vi^KV9RHV9RH00:DU9@00i6ATHj>SXj>SP02
S8b<00>9RHV7QhN7QhL00XF5Q@03PX:2OWinOWin009gMgL00fm_KfEUIFEUI@04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0W5aL@03Fe]KCTi>CTi>009@D5000eaLG6e]KFe]K@02NGUi00=n
OWilO7alO7`00WIfMP03KFe]I6ATI6AT009JFUX00e9BDTe=CDe=C@02CTi>00=CDe=IFEUIFET00UiN
GP03GemOGUiNGUiN009JFUX00eIFEU9BDU9BDP02CTi>0da<C09BDU800eYJFV=SHf=SH`02Jf][0Vm_
K`03L71`Kfm_Kfm_009_Kfl00g1`L79bLW9bLP02Lg=c00=_KfmVIVIVIVH00UYJFP03DU9BDe=CDe=C
009RHV800gUiNI2@T92@T003WYjN0Y:BTP:3Ph<00gIfMW9bLW9bLP02M7Ad00=hN7QjNWYjNWX00WQh
N003MGEeLG5aLG5a009`L7000fm_Kg5aLG5aL@02MGEe00=lO7b7QhN7QhL00Y>CT`>MWId2Ti>C00>0
P81]KFe]KFd00V1PH003GEeMI6ATI6AT009^KVh00gQhN7moOgmoO`02PX:200>5QHF7QhN7QhL00XZ:
RP03S8b<SHf=SHf=00:<S8`00hV9RHF5QHF5Q@02PH6100=oOgn0P820P8000XB4Q0>7QhL2PX:200=j
NWYdM7AdM7@00W=cL`9lO7`00hZ:RYRHV9RHV002WYjN00>IVIV<S8b<S8`00WemO@03LW9bKfm_Kfm_
009cLg<00g]kNh:2PX:2PP02QhN700>;Rh^?Shn?Shl00Y>CT`03VIVIWinOWinO00:RXZ800j2PX9RH
V9RHV002SHf=00>1PH5iNGUiNGT00WEeM@03MWIfNGUiNGUi00:0P8000hZ:RY>CTi>CT`02VIVI00>F
UYJ7QhN7QhL01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0UQHF003Bd];
?Cdm?Cdm008`<3000bDU9A/K6a/K6`025ADE00<C4a<E5ADE5AD00QTI6@037alO9RHV9RHV008];Bd0
0c@d=3Xj>SXj>P02?Shn2T10@003@D51@d=3@d=30096ATH00dY:BTi>CTi>CP02DU9B00=FEUIIFEUI
FET00UeMG@9OGel00f5QHF=SHf=SH`02IFEU00=VIVIXJ6QXJ6P00VYZJP03KFe]LG5aLG5a009eMGD0
0gUiNGemOGemO@02PH6100>4Q8B6QXJ6QXH00XN7Q`03QXJ6Ph>3Ph>300:0P8000gemOGUiNGUiN@02
MWIf00=cLg=aLG5aLG400W5aL@03LW9bM7AdM7Ad009fMWH00gUiNGalO7alO002P82000>3Ph>6QXJ6
QXH00XV9R@03Rh^;SXj>SXj>00:?Shl00i6ATI:BTY:BTP02TY:B00>ATI6?Shn?Shl00Xj>SP03S8b<
RXZ:RXZ:00:8R8P00hN7QhJ6QXJ6QP02QhN700>9RHV<S8b<S8`00Xn?S`03TY:BUYJFUYJF00:IVIT0
0i^KVifMWIfMW@02WYjN1YnOW`:NWYh4WIfM00>LW9bKVi^KVi/00YZJVP03VIVIV9RHV9RH00>HV9P2
VIVI0YZJVP03W9bLWIfMWIfM00:OWil00j6QXJ:RXZ:RXP02XZ:R00>QXJ6PX:2PX:000YjNWP03Vi^K
V9RHV9RH00:DU9@00i6ATHj>SXj>SP02S8b<00>9RHV7QhN7QhL00XF5Q@03PX:2OWinOWin009gMgL0
0fm_KfEUIFEUI@04oooo00<0003oooooool0<_ooo`040000oooooooooooo0W5aL@03Fe]KCTi>CTi>
009@D5000eaLG6e]KFe]K@02NGUi00=nOWilO7alO7`00WIfMP03KFe]I6ATI6AT009JFUX00e9BDTe=
CDe=C@02CTi>00=CDe=IFEUIFET00UiNGP03GemOGUiNGUiN009JFUX00eIFEU9BDU9BDP02CTi>0da<
C09BDU800eYJFV=SHf=SH`02Jf][0Vm_K`03L71`Kfm_Kfm_009_Kfl00g1`L79bLW9bLP02Lg=c00=_
KfmVIVIVIVH00UYJFP03DU9BDe=CDe=C009RHV800gUiNI2@T92@T003WYjN0Y:BTP:3Ph<00gIfMW9b
LW9bLP02M7Ad00=hN7QjNWYjNWX00WQhN003MGEeLG5aLG5a009`L7000fm_Kg5aLG5aL@02MGEe00=l
O7b7QhN7QhL00Y>CT`>MWId2Ti>C00>0P81]KFe]KFd00V1PH003GEeMI6ATI6AT009^KVh00gQhN7mo
OgmoO`02PX:200>5QHF7QhN7QhL00XZ:RP03S8b<SHf=SHf=00:<S8`00hV9RHF5QHF5Q@02PH6100=o
Ogn0P820P8000XB4Q0>7QhL2PX:200=jNWYdM7AdM7@00W=cL`9lO7`00hZ:RYRHV9RHV002WYjN00>I
VIV<S8b<S8`00WemO@03LW9bKfm_Kfm_009cLg<00g]kNh:2PX:2PP02QhN700>;Rh^?Shn?Shl00Y>C
T`03VIVIWinOWinO00:RXZ800j2PX9RHV9RHV002SHf=00>1PH5iNGUiNGT00WEeM@03MWIfNGUiNGUi
00:0P8000hZ:RY>CTi>CT`02VIVI00>FUYJ7QhN7QhL01?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0Ta<C003@D51=CDe=CDe008Z:RX00b0P81PH61PH60024a<C00<B4Q8C4a<C
4a<00QPH60037AdM92@T92@T008[:b/00c4a<CDe=CDe=@02=cLg00<h>3Pg=cLg=cL00SDe=@03<c<c
<C4a<C4a00<_;bl2<30`0S8b<P03=SHf>SXj>SXj008n?Sh00d92@TE5ADE5A@02BDU90T];B`03CDe=
Cdm?Cdm?009@D5000e5ADE=CDe=CD`02EUIF00=IFEUMGEeMGEd00V9RHP03IfMWK6a/K6a/009aLG40
0gEeMGMgMgMgM`02N7Qh00=gMgMdM7AdM7@00W1`L003Jf][IVIVIVIV009RHV800eiNGUaLG5aLG002
Fe]K00=LG5aNGUiNGUh00V1PH003I6ATIfMWIfMW009[Jf/00fm_Kg9bLW9bLP02MGEe00=hN7QjNWYj
NWX00WalO0InOWh2O7al0WYjNP03N7QhMGEeMGEe009cLg<3LW9b0W=cL`03MWIfNGUiNGUi009mOGd0
0h61PHF5QHF5Q@02R8R800>;Rh^=SHf=SHd01Hj>SP:=SHd00hb<S8^;Rh^;R`02RXZ:0XR8R003QhN7
QXJ6QXJ600:5QHD00hB4Q8>3Ph>3P`03Ph>30XB4Q0:5QHD00hN7QhV9RHV9R@02Rh^;00>=SHf>SXj>
SXh00Xj>SP03S8b<RXZ:RXZ:00:7QhL00hB4Q820P820P002O7al00=hN7QeMGEeMGD00W=cL`03LG5a
L71`L71`009^KVh00fe]KFYZJVYZJP02IFEU00=OGemFEUIFEUH01?ooo`030000oooooooo03;oool0
10000?ooooooooooo`9aLG400f=SHe]KFe]KF`02G5aL00=UIFE_Kfm_Kfl00WUiN@=nOWh2Ng]k00=e
MGEZJVYZJVX00UmOG`03E5ADCDe=CDe=009=CDd00e=CDeYJFUYJFP02H61P00=QHF5NGUiNGUh00U]K
F`03EeMGEEEEEEEE00=EEED2F5QH0UeMG@03Hf=SJFUYJFUY009]KFd2Kfm_00=^KVi]KFe]KFd00V][
J`03KFe]Kfm_Kfm_009`L7000fa/K6=SHf=SH`02EeMG00==CDe;Bd];Bd/00UIFEP03J6QXNg]kNg]k
00:8R8P00hZ:RX>3Ph>3P`02NGUi00=aLG5^KVi^KVh00Vm_K`03LG5aLW9bLW9b009aLG400g1`L6m_
Kfm_K`02LG5a00=dM7AiNGUiNGT00WinOP03Q8B4S8b<S8b<00:BTY800iJFUYBDU9BDU002S8b<00=o
OgmbLW9bLW800fYZJP9`L702N7Qh00=oOgn2PX:2PX800X:2PP>0P802PX:200>5QHF7QhN7QhL00XR8
R003QhN7Ph>3Ph>300:0P8000gmoOh61PH61P@02Q8B400>8R8R9RHV9RHT00XN7Q`03PX:2OWinOWin
009mOGd2PH6100>8R8R>SXj>SXh00Y6AT@03Shn?RHV9RHV900:2PX800g]kNgEeMGEeM@02Lg=c00=b
LW9eMGEeMGD00WYjNP03PH61RHV9RHV900:ATI400iRHV9bLW9bLW002WYjN00>KVi^CTi>CTi<00XR8
R003OWinMgMgMgMg009eMGD00gUiNGinOWinOP02Q8B400>:RXZ>SXj>SXh00Y2@T003Rh^;P820P820
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`92@T800cPh>2h^;Rh^;P02
9BDU00<L71`F5QHF5QH00a8B4P8D51@261PH00<N7QhT92@T92@00RTY:@03;Rh^<C4a<C4a008b<S80
0c4a<Bh^;Rh^;P02:b/[00<W9bLS8b<S8b<00R4Q8@<O7al28B4Q00<T92@X:2PX:2P00R`/;003<C4a
=3@d=3@d008h>3P2>SXj00<l?3`m?Cdm?Cd00Shn?P03?clo@D51@D510094A4@00dM7Ada<C4a<C002
DE5A00=HF5QNGUiNGUh00V=SH`03J6QXJVYZJVYZ009[Jf/00fYZJVMWIfMWI`02HV9R00=LG5aGEeMG
EeL00U5AD@03CDe=BTY:BTY:00=9BDT2Bd];0Ti>CP03DU9BEEEEEEEE009IFET00eeMGF5QHF5QH@02
I6AT00=WIfMYJFUYJFT00V][J`03KFe]KVi^KVi^009]KFd00fa/K6][Jf][J`02JFUY00=VIVITI6AT
I6@00V9RHP=QHF42HV9R00=UIFEYJFUYJFT00Ve]K@03LG5aMGEeMGEe009iNGT00galO7inOWinOP03
OWin0WemO@9lO7`00g]kNgUiNGUiN@02MgMg0WEeM@03M7AdLW9bLW9b009`L7000fm_Kfi^KVi^KP03
KVi^0Vm_K`9aLG400g=cLgEeMGEeM@02N7Qh00=jNWYkNg]kNg/00W]kN`03NGUiMgMgMgMg009cLg<0
0fm_KfYZJVYZJP02IVIV00=QHF5NGUiNGUh00UaLG0=KFe/3FUYJ0UQHF09EEED00e5ADDY:BTY:BP04
oooo00<0003oooooool0<_ooo`040000oooooooooooo0Vm_K`03J6QXI6ATI6AT009WIfL00fe]KGEe
MGEeM@02OGem00>2PX:3Ph>3Ph<00X:2PP03O7alLG5aLG5a009TI6@00eQHF55ADE5AD@02DE5A00=G
EeMPH61PH6000VIVIP03J6QXIFEUIFEU009SHf<3HF5Q0VATI003IfMWJf][Jf][009^KVh00g1`L79b
LW9bLP02Lg=c0W9bLP03Kfm_K6a/K6a/00=ZJVX2Jf][0VYZJP03IfMWGemOGemO009EEED00d];BdM7
AdM7A`02BTY:00=BDU9KFe]KFe/00V=SH`03IfMWJ6QXJ6QX009WIfL5IVIV00=WIfMXJ6QXJ6P00VYZ
JP03K6a/Kfm_Kfm_009cLg<00gQhN7emOGemO@02PX:200>6QXJ8R8R8R8P00XR8R003QXJ6Q8B4Q8B4
009oOgl00g]kNgMgMgMgM`02MWIf00=iNGUnOWinOWh00X:2PP03QHF5PX:2PX:2009mOGd00gMgMg=c
Lg=cL`02Lg=c00=eMGEiNGUiNGT00galO09kNg/3NWYj0WemO@:0P8000hB4Q8N7QhN7Q`03R8R80XN7
Q`:5QHD2PX:200=nOWikNg]kNg/00WYjNP03OGemPH61PH6100:4Q8@00h>3Pg]kNg]kN`02L71`00=U
IFEQHF5QHF400VEUI@03L71`OGemOGem00:7QhL00hf=SHj>SXj>SP02SHf=00>8R8R1PH61PH400WUi
N@03LW9bKfm_Kfm_009bLW800gUiNH20P820P002QhN70hV9R@:5QHD00gmoOgMgMgMgM`04oooo00<0
003oooooool04?ooo`009Oooo`800003oooo0T92@P03>3Ph;Rh^;Rh^008U9BD00a`L71HF5QHF5P03
4Q8B0Q@D508H61P00ahN7R@T92@T9002:BTY00<^;Rha<C4a<C400S8b<P03<C4a;Rh^;Rh^008[:b/0
0bLW9b<S8b<S8`028B4Q0alO7`8Q8B400b@T92PX:2PX:002;2`/00<a<C4d=3@d=3@00SPh>08j>SX0
0c`l?3dm?Cdm?@02?Shn00<o?cm1@D51@D400TA4A003AdM7C4a<C4a<009ADE400eQHF5iNGUiNGP02
Hf=S00=XJ6QZJVYZJVX00V][J`03JVYZIfMWIfMW009RHV800eaLG5MGEeMGE`02DE5A00==CDe:BTY:
BTX00dU9B@9;Bd/2CTi>00=BDU9EEEEEEED00UUIF@03GEeMHF5QHF5Q009TI6@00fMWIfUYJFUYJ@02
Jf][00=]KFe^KVi^KVh00Ve]K@03K6a/Jf][Jf][009YJFT00fIVIVATI6ATI002HV9R0f5QH@9RHV80
0fEUIFUYJFUYJ@02KFe]00=aLG5eMGEeMGD00WUiN@03O7alOWinOWin00=nOWh2OGem0WalO003Ng]k
NGUiNGUi009gMgL2MGEe00=dM7AbLW9bLW800W1`L003Kfm_KVi^KVi^00=^KVh2Kfm_0W5aL@03Lg=c
MGEeMGEe009hN7P00gYjNW]kNg]kN`02Ng]k00=iNGUgMgMgMgL00W=cL`03Kfm_JVYZJVYZ009VIVH0
0f5QHEiNGUiNGP02G5aL0e]KF`=JFUX2F5QH0UEEE@03DE5ABTY:BTY:00?oool20000=?ooo`040000
oooooooooooo0Vm_K`03J6QXI6ATI6AT009WIfL00fe]KGEeMGEeM@02OGem00>2PX:3Ph>3Ph<00X:2
PP03O7alLG5aLG5a009TI6@00eQHF55ADE5AD@02DE5A00=GEeMPH61PH6000VIVIP03J6QXIFEUIFEU
009SHf<3HF5Q0VATI003IfMWJf][Jf][009^KVh00g1`L79bLW9bLP02Lg=c0W9bLP03Kfm_K6a/K6a/
00=ZJVX2Jf][0VYZJP03IfMWGemOGemO009EEED00d];BdM7AdM7A`02BTY:00=BDU9KFe]KFe/00V=S
H`03IfMWJ6QXJ6QX009WIfL5IVIV00=WIfMXJ6QXJ6P00VYZJP03K6a/Kfm_Kfm_009cLg<00gQhN7em
OGemO@02PX:200>6QXJ8R8R8R8P00XR8R003QXJ6Q8B4Q8B4009oOgl00g]kNgMgMgMgM`02MWIf00=i
NGUnOWinOWh00X:2PP03QHF5PX:2PX:2009mOGd00gMgMg=cLg=cL`02Lg=c00=eMGEiNGUiNGT00gal
O09kNg/3NWYj0WemO@:0P8000hB4Q8N7QhN7Q`03R8R80XN7Q`:5QHD2PX:200=nOWikNg]kNg/00WYj
NP03OGemPH61PH6100:4Q8@00h>3Pg]kNg]kN`02L71`00=UIFEQHF5QHF400VEUI@03L71`OGemOGem
00:7QhL00hf=SHj>SXj>SP02SHf=00>8R8R1PH61PH400WUiN@03LW9bKfm_Kfm_009bLW800gUiNH20
P820P002QhN70hV9R@:5QHD00gmoOgMgMgMgM`03oooo0P0001;oool002Goool00`000?ooooooo`02
oooo0SXj>P03<S8b:RXZ:RXZ008R8R800a`L71HF5QHF5P0351@D0QHF5P8J6QX00alO7b@T92@T9002
:BTY00<];Bd^;Rh^;Rh00Rh^;P03:b/[9bLW9bLW008R8R800adM7APH61PH60025ADE0a8B4P8D51@0
0aLG5a/K6a/K6`027alO00<T92@X:2PX:2P00R/[:`8^;Rh00bl_;c0`<30`<002<C4a00<b<S8c<c<c
<c<00SDe=@03>CTi?Shn?Shn0094A4@00d];Be9BDU9BDP02F5QH00=MGEeQHF5QHF400V9RHP03HF5Q
GEeMGEeM009HF5P00e9BDT];Bd];B`02ADE500=0@40m?Cdm?Cd00c`l?08n?Sh2@D5100=5ADE9BDU9
BDT00Te=C@03DE5AE5ADE5AD009GEeL00eYJFUaLG5aLG002GUiN00=OGemPH61PH6000V1PH003GemO
GEeMGEeM009KFe/00eUIFEMGEeMGE`02EEEE0eADE09EEED00eQHF5aLG5aLG002H61P00=TI6AXJ6QX
J6P00Va/K003KVi^L71`L71`009aLG400g1`L6m_Kfm_K`02KVi^00=/K6aZJVYZJVX00VQXJ09UIFD0
0f=SHf1PH61PH002GUiN00=LG5aJFUYJFUX00eYJFP9KFe/2GEeM00=PH61SHf=SHf<00VIVIP03JFUY
Jf][Jf][009[Jf/00fYZJVMWIfMWI`02Hf=S00=NGUiIFEUIFET00UADE003D51@CDe=CDe=009;Bd/5
BTY:00=;Bd]:BTY:BTX00TU9B@03ADE5@410@41000Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2JVYZ00=YJFUZJVYZJVX00Vi^KP03M7AdNg]kNg]k00:1PH400hJ6QXR8R8R8R002QhN700>2
PX9gMgMgMgL00VYZJP03GUiNEeMGEeMG009GEeL00eiNGVIVIVIVIP02KFe]00=`L71_Kfm_Kfl00fe]
K@9`L702MGEe00=jNWYnOWinOWh00WinOP03OGemNWYjNWYj009gMgL2Lg=c00=`L71]KFe]KFd00VYZ
JP03JFUYJ6QXJ6QX009WIfL00fATI5eMGEeMG@02EEEE00==CDe6ATI6ATH00T51@@<o?cl2@T9200=8
B4Q?Cdm?Cdl00UIFEP03G5aLGUiNGUiN00=MGEd2GUiN0V9RHP03JFUYL71`L71`009gMgL00galO820
P820P003PX:20WinOP9hN7P00g=cLg1`L71`L002LG5a00=eMGEkNg]kNg/00X61P@03QHF5R8R8R8R8
00:9RHT00hJ6QWmoOgmoO`02MWIf00=/K6aUIFEUIFD00V=SH`03IFEUJ6QXJ6QX009/K6`00fm_Kg1`
L71`L002LW9b00=dM7AfMWIfMWH00WUiN@03O7alP820P82000:5QHD00hV9RHb<S8b<S002RXZ:0X20
P003LW9bIFEUIFEU009PH6000fQXJ7IfMWIfMP02Q8B400>9RHV0P820P8000Ve]K@03FEUICTi>CTi>
009ADE400eiNGVi^KVi^KP02NWYj00=nOWilO7alO7`00WMgM`03LG5aJf][Jf][009WIfL00fEUIFIV
IVIVIP02KFe]00=fMWJ0P820P8000hJ6QP:2PX82Ng]k00=dM7A^KVi^KVh01?ooo`030000oooooooo
013oool002Goool00`000?ooooooo`02oooo0SXj>P03<S8b:RXZ:RXZ008R8R800a`L71HF5QHF5P03
51@D0QHF5P8J6QX00alO7b@T92@T9002:BTY00<];Bd^;Rh^;Rh00Rh^;P03:b/[9bLW9bLW008R8R80
0adM7APH61PH60025ADE0a8B4P8D51@00aLG5a/K6a/K6`027alO00<T92@X:2PX:2P00R/[:`8^;Rh0
0bl_;c0`<30`<002<C4a00<b<S8c<c<c<c<00SDe=@03>CTi?Shn?Shn0094A4@00d];Be9BDU9BDP02
F5QH00=MGEeQHF5QHF400V9RHP03HF5QGEeMGEeM009HF5P00e9BDT];Bd];B`02ADE500=0@40m?Cdm
?Cd00c`l?08n?Sh2@D5100=5ADE9BDU9BDT00Te=C@03DE5AE5ADE5AD009GEeL00eYJFUaLG5aLG002
GUiN00=OGemPH61PH6000V1PH003GemOGEeMGEeM009KFe/00eUIFEMGEeMGE`02EEEE0eADE09EEED0
0eQHF5aLG5aLG002H61P00=TI6AXJ6QXJ6P00Va/K003KVi^L71`L71`009aLG400g1`L6m_Kfm_K`02
KVi^00=/K6aZJVYZJVX00VQXJ09UIFD00f=SHf1PH61PH002GUiN00=LG5aJFUYJFUX00eYJFP9KFe/2
GEeM00=PH61SHf=SHf<00VIVIP03JFUYJf][Jf][009[Jf/00fYZJVMWIfMWI`02Hf=S00=NGUiIFEUI
FET00UADE003D51@CDe=CDe=009;Bd/5BTY:00=;Bd]:BTY:BTX00TU9B@03ADE5@410@41000Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2JVYZ00=YJFUZJVYZJVX00Vi^KP03M7AdNg]kNg]k
00:1PH400hJ6QXR8R8R8R002QhN700>2PX9gMgMgMgL00VYZJP03GUiNEeMGEeMG009GEeL00eiNGVIV
IVIVIP02KFe]00=`L71_Kfm_Kfl00fe]K@9`L702MGEe00=jNWYnOWinOWh00WinOP03OGemNWYjNWYj
009gMgL2Lg=c00=`L71]KFe]KFd00VYZJP03JFUYJ6QXJ6QX009WIfL00fATI5eMGEeMG@02EEEE00==
CDe6ATI6ATH00T51@@<o?cl2@T9200=8B4Q?Cdm?Cdl00UIFEP03G5aLGUiNGUiN00=MGEd2GUiN0V9R
HP03JFUYL71`L71`009gMgL00galO820P820P003PX:20WinOP9hN7P00g=cLg1`L71`L002LG5a00=e
MGEkNg]kNg/00X61P@03QHF5R8R8R8R800:9RHT00hJ6QWmoOgmoO`02MWIf00=/K6aUIFEUIFD00V=S
H`03IFEUJ6QXJ6QX009/K6`00fm_Kg1`L71`L002LW9b00=dM7AfMWIfMWH00WUiN@03O7alP820P820
00:5QHD00hV9RHb<S8b<S002RXZ:0X20P003LW9bIFEUIFEU009PH6000fQXJ7IfMWIfMP02Q8B400>9
RHV0P820P8000Ve]K@03FEUICTi>CTi>009ADE400eiNGVi^KVi^KP02NWYj00=nOWilO7alO7`00WMg
M`03LG5aJf][Jf][009WIfL00fEUIFIVIVIVIP02KFe]00=fMWJ0P820P8000hJ6QP:2PX82Ng]k00=d
M7A^KVi^KVh01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0SDe=@03;bl_
:BTY:BTY008R8R800adM7ATI6ATI6@035aLG0QTI6@8M7Ad00b4Q8BDU9BDU9@02:BTY00<[:b//;2`/
;2`00RXZ:P039bLW8B4Q8B4Q008L71`00aHF5Q0@410@400230`<0`T92@8;2`/00`h>3Q<C4a<C4`02
61PH00<M7AdR8R8R8R800RDU9@8W9bL5:BTY00<Z:RX[:b/[:b/00Rd];@03<30`=CDe=CDe008l?3`0
0d=3@d];Bd];B`02DE5A00=GEeMKFe]KFe/00UeMG@03G5aLF5QHF5QH009CDe<00de=CDI6ATI6AP02
@41000<k>c/g=cLg=cL00cHf=P8h>3P2>c/k00<o?cm3@d=3@d<00TM7A`03BTY:CTi>CTi>009@D500
0e=CDeADE5ADE002EUIF00=GEeMHF5QHF5P00UQHF003EeMGEEEEEEEE009CDe<00e5ADE1@D51@D002
CTi>0de=C@9>CTh00e5ADEADE5ADE002EeMG00=KFe]NGUiNGUh00V5QH@03Hf=SIFEUIFEU00=UIFD2
I6AT0V=SH`03HF5QGemOGemO009LG5`2FEUI00=EEEEBDU9BDU800Ti>CP03Bd];BDU9BDU900=8B4P2
BDU90Ta<C003D51@E5ADE5AD009HF5P00eaLG5mOGemOG`02H61P00=OGemMGEeMGEd00UUIF@03E5AD
Cdm?Cdm?009:BTX00dE5AD92@T92@P02@4100clo?`90@403@D510T10@003?Shn>SXj>SXj00Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2IFEU00=VIVIYJFUYJFT00Ve]K@03Lg=cNGUiNGUi
009oOgl00hF5QHV9RHV9R@02RXZ:00>7QhMnOWinOWh00W9bLP03IVIVGemOGemO009OGel00fEUIFi^
KVi^KP02MGEe1GQhN003NGUiOWinOWin00:3Ph<00hR8R8Z:RXZ:RP02R8R800>3Ph=mOGemOGd00WMg
M`9bLW800fi^KV][Jf][J`02JVYZ1F][J`03JFUYIFEUIFEU009MGEd00eEEEDa<C4a<C002A4A400<l
?3`h>3Ph>3P00SPh>003?ShnB4Q8B4Q8009BDU800eUIFEYJFUYJFP02EUIF00=BDU9CDe=CDe<00U]K
F`03IfMWLg=cLg=c009mOGd00h61PH20P820P002OGem00=fMWI^KVi^KVh00VEUI@03GUiNGEeMGEeM
009SHf<00fm_KgalO7alO002QXJ60hb<S0:8R8P00h61PGQhN7QhN002KVi^00=UIFEMGEeMGEd00eUI
F@9KFe/2GemO00=SHf=XJ6QXJ6P00Va/K003L71`LW9bLW9b009bLW800g=cLgEeMGEeM@02O7al00>5
QHF;Rh^;Rh/00XV9R@9kNg/00fIVIU9BDU9BDP02BTY:00=EEEE[Jf][Jf/00X:2PP03SHf=Ph>3Ph>3
009]KFd00eADE4=3@d=3@`02@d=300=?CdmNGUiNGUh00VUYJ@03K6a/JFUYJFUY009TI6@00eiNGU]K
Fe]KF`03FEUI0UeMG@9UIFD00g1`L7YjNWYjNP03P8200WYjNP9bLW800fYZJVIVIVIVIP04oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2=3@d00<_;blZ:RXZ:RX00RDU9@03820P
7AdM7AdM008K6a/00a`L71dM7AdM7@02820P00<S8b<V9RHV9RH00RTY:@<Z:RX29bLW00<S8b<M7AdM
7Ad00QLG5`034A4A2`/;2`/;00871`L31@D50PP8200330`<4A4A4A4A008G5aL00adM7B8R8R8R8P02
9RHV0RPX:0PY:BT2:RXZ00<];Bdb<S8b<S800STi>@03@410B4Q8B4Q8009@D5000eIFEUYJFUYJFP03
G5aL0UUIF@9DE5@00di>CTQ8B4Q8B002@T9200<m?Cdj>SXj>SX00cTi>@8k>c/2?Shn00=1@D55ADE5
ADD00TU9B@03C4a<Cdm?Cdm?009ADE400e9BDUADE5ADE002E5AD1UEEE@9DE5@2DU9B00=ADE5@D51@
D5000Tm?C`=>CTh2Cdm?00=@D51BDU9BDU800UADE003EUIFF5QHF5QH009JFUX00e]KFeaLG5aLG005
GEeM0UaLG003Fe]KFEUIFEUI009FEUH2DU9B00==CDe8B4Q8B4P00T=3@`03?Shn>c/k>c/k00<h>3P2
>SXj0Shn?P03@d=3BDU9BDU9009?Cdl00eADE5QHF5QHF003Fe]K0UUIF@9FEUH00e5ADDa<C4a<C002
AdM700=3@d<o?clo?cl00Sdm?@<l?3`2?Cdm0chn?P8m?Cd00c`l?3Ti>CTi>@04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0eiNGP9PH602Hf=S00=XJ6Q]KFe]KFd00WEeM@03OGemQHF5QHF5
00>:RXX2Ph>30WUiN@03KVi^IfMWIfMW009WIfL00fa/K7AdM7AdM002Ng]k00=oOgn0P820P8000X61
P@03PX:2QXJ6QXJ600:9RHT00hb<S8^;Rh^;R`02QXJ600=oOgmgMgMgMgL00W5aL@9[Jf/00fUYJFQX
J6QXJ002JVYZ00=_KfmfMWIfMWH00W]kN`03O7alN7QhN7Qh009_Kfl00fATI5]KFe]KF`02E5AD00=A
DE5?Cdm?Cdl00U5AD@03EUIFG5aLG5aL009RHV800f=SHeaLG5aLG002DU9B00=9BDU8B4Q8B4P00U=C
D`03IVIVNGUiNGUi00:5QHD00hJ6QWinOWinOP02LW9b00=TI6AIFEUIFET00U1@D003C4a<Cdm?Cdm?
009IFET00fUYJGUiNGUiN@02QHF500>8R8R4Q8B4Q8@00W]kN`03Lg=cK6a/K6a/009WIfL00fATI5mO
GemOG`02Fe]K00=GEeMDE5ADE5@00UIFEP03G5aLI6ATI6AT009]KFd3LW9b0Vi^KP=YJFT2Kfm_00=j
NWZ2PX:2PX800X61P@9bLW800e]KFdI6ATI6AP02?Shn00=;Bd]TI6ATI6@00WinOP03S8b<QXJ6QXJ6
009aLG400eQHF4I6ATI6AP02@D5100=7AdM@D51@D5000UMGE`03Fe]KFUYJFUYJ009IFET00eMGEeIF
EUIFEP03E5AD0UIFEP9MGEd00fIVIVm_Kfm_K`03M7Ad0W1`L09ZJVX00fATI61PH61PH004oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2=3@d00<_;blZ:RXZ:RX00RDU9@03820P
7AdM7AdM008K6a/00a`L71dM7AdM7@02820P00<S8b<V9RHV9RH00RTY:@<Z:RX29bLW00<S8b<M7AdM
7Ad00QLG5`034A4A2`/;2`/;00871`L31@D50PP8200330`<4A4A4A4A008G5aL00adM7B8R8R8R8P02
9RHV0RPX:0PY:BT2:RXZ00<];Bdb<S8b<S800STi>@03@410B4Q8B4Q8009@D5000eIFEUYJFUYJFP03
G5aL0UUIF@9DE5@00di>CTQ8B4Q8B002@T9200<m?Cdj>SXj>SX00cTi>@8k>c/2?Shn00=1@D55ADE5
ADD00TU9B@03C4a<Cdm?Cdm?009ADE400e9BDUADE5ADE002E5AD1UEEE@9DE5@2DU9B00=ADE5@D51@
D5000Tm?C`=>CTh2Cdm?00=@D51BDU9BDU800UADE003EUIFF5QHF5QH009JFUX00e]KFeaLG5aLG005
GEeM0UaLG003Fe]KFEUIFEUI009FEUH2DU9B00==CDe8B4Q8B4P00T=3@`03?Shn>c/k>c/k00<h>3P2
>SXj0Shn?P03@d=3BDU9BDU9009?Cdl00eADE5QHF5QHF003Fe]K0UUIF@9FEUH00e5ADDa<C4a<C002
AdM700=3@d<o?clo?cl00Sdm?@<l?3`2?Cdm0chn?P8m?Cd00c`l?3Ti>CTi>@04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0eiNGP9PH602Hf=S00=XJ6Q]KFe]KFd00WEeM@03OGemQHF5QHF5
00>:RXX2Ph>30WUiN@03KVi^IfMWIfMW009WIfL00fa/K7AdM7AdM002Ng]k00=oOgn0P820P8000X61
P@03PX:2QXJ6QXJ600:9RHT00hb<S8^;Rh^;R`02QXJ600=oOgmgMgMgMgL00W5aL@9[Jf/00fUYJFQX
J6QXJ002JVYZ00=_KfmfMWIfMWH00W]kN`03O7alN7QhN7Qh009_Kfl00fATI5]KFe]KF`02E5AD00=A
DE5?Cdm?Cdl00U5AD@03EUIFG5aLG5aL009RHV800f=SHeaLG5aLG002DU9B00=9BDU8B4Q8B4P00U=C
D`03IVIVNGUiNGUi00:5QHD00hJ6QWinOWinOP02LW9b00=TI6AIFEUIFET00U1@D003C4a<Cdm?Cdm?
009IFET00fUYJGUiNGUiN@02QHF500>8R8R4Q8B4Q8@00W]kN`03Lg=cK6a/K6a/009WIfL00fATI5mO
GemOG`02Fe]K00=GEeMDE5ADE5@00UIFEP03G5aLI6ATI6AT009]KFd3LW9b0Vi^KP=YJFT2Kfm_00=j
NWZ2PX:2PX800X61P@9bLW800e]KFdI6ATI6AP02?Shn00=;Bd]TI6ATI6@00WinOP03S8b<QXJ6QXJ6
009aLG400eQHF4I6ATI6AP02@D5100=7AdM@D51@D5000UMGE`03Fe]KFUYJFUYJ009IFET00eMGEeIF
EUIFEP03E5AD0UIFEP9MGEd00fIVIVm_Kfm_K`03M7Ad0W1`L09ZJVX00fATI61PH61PH004oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo0=coool00`000?ooooooo`0boooo00<0003ooooo
ool0foooo`030000oooooooo013oool002Goool00`000?ooooooo`3Loooo00<0003oooooool0<_oo
o`030000oooooooo0=_oool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`030000
oooooooo01koool00`000?ooooooo`0Ooooo00<0003oooooool07_ooo`030000oooooooo01ooool0
0`000?ooooooo`0Noooo00<0003oooooool07_ooo`030000oooooooo00ooool00`000?ooooooo`0b
oooo00D0003oooooooooool000008?ooo`030000oooooooo01ooool00`000?ooooooo`0Noooo00<0
003oooooool07oooo`030000oooooooo01koool00`000?ooooooo`0Noooo00<0003oooooool03ooo
o`030000oooooooo013oool002Goool200000oooo`030000oooooooo00Goool00`000?ooooooo`05
oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool0
0`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05
oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003ooooo
ool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Oooo`030000
oooooooo00Koool00`000?ooooooo`05oooo0P0003Coool01@000?ooooooooooo`000007oooo00<0
003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_oo
o`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo
00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?oo
ooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`80000Boooo000Uooooh00003CooooO
00004_ooo`00ooooooooool/oooo003oooooooooobcoool00?oooooooooo;?ooo`00ooooooooool/
oooo003oooooooooobcoool00?oooooooooo;?ooo`00P?ooo`D00002oooo0P0000?oool200000ooo
o`800002oooo0`0000coool50000j_ooo`D00002oooo0P0000?oool200000oooo`800002oooo0`00
00goool30000Koooo`00POooo`060000oooooooo0000oooo00001Oooo`800002oooo00<0003ooooo
ool00oooo`030000oooooooo00goool00`000?ooooooo`3[oooo00H0003oooooool0003oool00005
oooo0P0000;oool00`000?ooooooo`03oooo00<0003oooooool03?ooo`030000oooooooo06ooool0
087oool00`000?ooooooo`02oooo0`0000;oool01@000?ooooooo`000?ooo`0300000oooo`030000
oooooooo00goool00`000?ooooooo`3[oooo00<0003oooooool00_ooo`<00002oooo00D0003ooooo
ool0003oool00`0000?oool00`000?ooooooo`0=oooo00<0003oooooool0K_ooo`00POooo`030000
oooooooo00;oool3000000?oool0000000000_ooo`030000oooo000000800003oooo00<0003ooooo
ool03Oooo`030000oooooooo0>_oool00`000?ooooooo`02oooo0`000003oooo0000000000;oool0
0`000?ooo`00000200000oooo`030000oooooooo00goool00`000?ooooooo`1^oooo0021oooo00<0
003oooooool04_ooo`030000oooooooo00goool00`000?ooooooo`3[oooo00<0003oooooool04_oo
o`030000oooooooo00coool00`000?ooo`00001_oooo0020oooo0`0001;oool200003_ooo`80003/
oooo0`0001;oool200003oooo`030000oooooooo06koool00?oooooooooo;?ooo`00ooooooooool/
oooo003oooooooooobcoool00?oooooooooo;?ooo`00ooooooooool/oooo003oooooooooobcoool0
0?oooooooooo;?ooo`00ooooooooool/oooo003oooooooooobcoool00001\
\>"],
  ImageRangeCache->{{{0, 553}, {262.563, 0}} -> {-0.0530921, -0.0238146, 
  0.00380866, 0.00380866}, {{13.9375, 263.938}, {256.25, 
  6.25}} -> {-25.2811, -13.3836, 0.598134, 0.598134}, {{289, 539}, {256.25, 
  6.25}} -> {-189.805, -13.3836, 0.598134, 0.598134}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .47619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0113379 0.47619 [
[ 0 0 0 0 ]
[ 1 .47619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .47619 L
0 .47619 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0113379 0.477324 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Level) show
99.000000 13.000000 moveto
(3) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
91838A8B8A8882767CACD7CFAB8C7A7B837E76787D7F7E7D
7A736C68696C7CA0B6A580645F7A93856760605452708566
4969918673889D89738B9B7145587C7B7A9DB89E766A7283
89725857697D8778646064645C49425A7D9395846D61667C
92979496948672615A67787877858D79605C646A6F7B7F6B
679FD0B391BDEBC9
7B82939998979183787B838B8977676F7D7E79787A7C7D7A
7B868E8A7C676796BFAA80738099B0B7A88770809688747C
8D96917B6F88A3937F96AA8B6B839E866E90B39B7C8CA7A1
8C83785B5790C3AF7E656889A1866883A490778BA49A8788
90959590857A6F6560656C6E70757567544645576D767363
5D758B7966809C90
647B8D979B9A948A755036425B656971787C7E7C7B7E807A
7C93AAAE9A684E7EB3A27C7C91A2B4CFD6AF8FABC8A07695
BFB491766F849A8F8092A9A194A1AA8F768A9C796299D4BD
909AA3725496DDCE99787BADDAC098ACBD845789CECEA98D
7D7E88867E7B7A7674787A736C6C6E6A62575463767A746B
605148494B423E4C
7171727980817D75748995745A79A09A827C7F808184837E
7D8694A39E725479A69A76646471859295928A8180919F95
8482868A8881776F71818B7C6A6E808C949B8C5733558B96
91A3A8805A63819297948E909596959B9776627FA49E8069
5F6B808A8B8C877B7891A697838DA1A5A4A8ACAEAEAC9F81
6D7E95917F716A6B
8E715B5C666B6A6273C1F4B46A8ECABA8D8082868B8C8886
81746E7C897D707B8C918055313D554D456578462671B989
404A7893957E605A6571715C443D5283ACA77E49221E3A68
8F998E846D3C23508DA28E5D3A537B76636B777061554E50
59647386949A95817C9FC1B198A9C4C3C0D8ECDAC2CBCA90
6DADF5DBA4A2B0A6
A28463616F7778706F889A82697F9F9F918D8F9396928E92
90796056618194745A86AA75343C5D584D626D482E5C9082
5F5D6A6F737B7D7570778289826759799C9172635C515373
8C79647A8C664569958D67443751706958636E5D494A5B79
8971555E7A93A0988B919A948A8E8C6F5F89AF89649CCB86
4488D5A55B628CA3
A5947978878E8D8A774B2E43666B677689919292908B8C96
9885684C4E89B070367BCAA36063828B877D716E6D626282
9C8D6C56587B9D9A888796B2C0A17A7881777289A29E9193
8C654C72A19E8D9BA1794F5067777D776C6B6B66646679A7
BE8C4D48658196A19778616B7B7150200836602F0962B673
21599A5B0A1E6090
9089868B94918E96977C61626E7374747576756D69717D84
84817C7176A1B577406FB6BAA0979DAFBBA78F99A58C7689
A3A08E807B82909B9B8C7F85929895897E7C8598A9AAA29F
967D6C7F97958D9AA3917E8496A4A79C8E888EA2AA8A7399
C1A77B777F70688497714F6E968D6C5149667A4C2969A66E
3373B472244A929F
7B76869395847990B3C8C198727A9088746C634E44566F78
7983919BA5B1A981606A8EB0C0B3A4B6C9B7A2B0C0B1978A
8D9DADAFA183728AA3916B4B4873A09C878A95928E92989B
9B99958D8378768296AAB4ACA6B6C3B5A19DADD1DDA56A77
A2AFADAD9D6C4A6486725A769FA9A5A5A9B7B791708AA273
5197DBA96A92C8AC
7D7377898F6D5474ACD2D1A06B657D94A19E8763494F6B8C
A3A49B999C9F9C8B7A747A848F93939796898399ADA28978
7990A5A18A6E66809EA085563E639599898B8E857D81888A
8A8E8F857B7F83787590A7957F90A596838AA1B9BEA17D75
849BABA69280716059656E5B5487BAB29CB4C79E7692AD79
4D81C3B59199A795
8A7B6A7E885D3B629FB5A6805A4C64A1D4CFA5775C6181A8
BCAE8F7A757E8B8F898175605667786D58505A768A7F6A63
6D808B796263717885A6B07F4E5E87938D867C726F757C7B
787879787B878D7966758164485E7B71606D7F79748B997C
60769487768FA1754C6E8C501C5EAC90638AB3865B92C280
38599BA9967C6B78
918673848F674B7BAE965F433F4568B2E1BF7B4F518ABDAB
7B68645B596474868E84756C6B6B695F544E567387755D61
707876665F7D94715895CA934D5B8C9F99866C5D60748682
77777B7B787374828F8C754E38537B81736C61423D7DAC72
315691846677949899AFB48558647B644C6C8A644B97D285
2B4E959A7D635A73
8A8882919A7C6996B67F342740587BB3C7934E3351A6DEA2
47384C4D4C5A6D828D8074889A876A696F676681957F6269
7A7B74696E9DB470387AC59A56608CA3A48D6B5252719192
85838482765A558EC3AF774E476B979D88735B373377A970
2C498387746873A2D2D8C8BEAC835E5258686D4A419CE08C
2A56A2905F576579
737780939C857080937F666B7E899197917B696D819BAAA0
8A81765A4C658898937A6A84A1947A797E74718A9F917970
74828C807A9EB27842669D9C7F6C6D88A39F81563F578195
978D80807A554A8CCAB075596494B5905C61786F6372858A
7C574775A6997772849FB8C0B6A29086858E864F3BA0F49F
3765B49961637777
5F6177929E8A6C606B88A9BEBDA88A716C7E98ABA3745C96
D9D5A677627AA0AB99745E7598988A868479788FA59F8973
6E89A39581909C82635E7199A97749679EAF9A69424D7496
A492797C7F5C4D8AC3AB756070A5C28444639FAC997164A7
D3741D6AD5C97E3C24569799879CBABBB0B1A3684D9EE39D
4A78BEA2717F957D
655D7496AA9671626A809FBFBE834A527C99A2987A4B3E7C
BFBD998B8A8B909B967158759D9D8B88887D7C95A895776F
788C9A9284858A877C67679AB87938599BAD9E8A7B7D8D9D
A18C778087645698D8BF7E504B79ADAC9AA4B2AC99756BAC
D98B4183D6B4643B3A5E7C623F4F7998A4998781848B8768
5989B6977195BA98
6F607497AF9B797179777C9A9D551D51A2B29265403E536B
7A777893A890738191755D7CA29B8481847A7A98AC8A6268
818886838080828785736F9CB882465C8F9E9B9DA0A4A7A2
97857881876C65A0D8C483462C4A8BC7E4D3A985727184AA
BC967292B48D5A5C77867B4C1C16346A8E755D8BB27F3C3A
5F8DA482679BCFAC
5E58718A988E7C798082838A835E4E82B7AA784838648F79
52567492A0876D7D938371839A907D7C7E6E6E99BB9E7069
767E8179737D88867B6D7099B8A1786B7591A0846779999F
94877C777672768999947F61505C79929E9C855C445C8BB2
BA92686C87918E817C91A0845E505F8DAA815880AF93604D
587D9472588FC49D
4F5878828284827673879889788299A8A58E6F515698C795
50557A8B8B7E727D8D8982899087797877676895BCA87E6E
717B847970808F8571656D8EAEB7A3735781A4703244768F
948E7F6D677783735F697D8383847B5A4561764C284C8EB6
B4804A476CA2BC946A8BBFC1AEA6A7B4B48C677192A8A479
57729372527DA782
5F718F938E938C654C6E998F7D9AAF865B6F928B84ADCCAB
796A74838C82716C6F757E8A90887B7270717A8E957C6471
8A8E8887898784817A6E6C7D94A296613F6A9E9167515574
92907C6E6E808D7D69758988828A8C716390AC6E325B9FA6
865F49597E9B9F826B84A9ACA3ADAD88626171757C9BAB8A
6C88A78864768F78
75859AA1A1A8995A2D56959B8B9895572F6AB6B69DA6B5A9
927D7584938A74635C657889918B7D72717B858677524476
ACA28286948C8186897A6B6F79817A5C49608DB7BB7F475F
8F907D7B7F828892989A927D7182999598CBE293486EAA95
63525E809B8D6E646B79847972919B56183E80897C899484
7C9BB59F7C777E78
75777E8B9BB0A96B3C5D98A69271575C7798A7917B93A780
566A90968C88837C787B818A8E877D7C7C6B64819263427E
BFA165586C8BA4A18B796E6A6E788189887574AAD09E5E66
8A908B908C70689AC9B4867375848E7C75A6C6854267A196
757483959B85675C62717B6D668AA27040639DA798918671
6A85A09981767272
7662587399ABA27C61779BA48C543A7BC4BA84584E81A35E
1C53A5A687838C9093928D8B897F7A878B644E87BA844C83
C29D56334084C0AD7D777F7670778EB7C58A567FB9AC8477
7D8895A09668528ECAAB747183877B5C4B71916C425E8F9E
9B98948F8B877E6A5E70847B728EA7967F8BA5B5B49F7E5C
5067878D837A7477
92674D82BA9F6E6D84959A8976768493988A70534F81A67A
496699A091867D7677818B8C867B778999887CA0B77F4E7D
BAAF7D504474A487607DA4997D707CACC07B365699AC9C7F
68708A9E9F876C676C6A6C7F8D84746E73848D7F6D6E80A0
AE8F69667B949E836877918E8692988269687B9BAE9C7654
4B688E9B978C8591
A36E5194D0924151879E997769A7D693414F7C756886A499
827C84939A8B7059556C878D847875859CA6A7AA9C694D7B
B7BB9B7A656F7B645889BAAC8267678A9E6D3843739DA87E
50557993A1A2884C233A6D8D9381738BA8A3919192847E99
A5723F4F7FA3AD94777E959A96948665483F527F9F926F58
59789BA1989599A6
875E4E7EAB8B5241527A9B8F80ABC06B215CB1A3777E8B74
5D6881909590816C63758A8B807877828E8A8186835E4F8D
C7A770758C867B7E8A9DA48C6C5E6578898A7B5B5287AD78
363E6C8E9A8B70676A6B7287927F718BA48C6C6E808A8D8D
8164587DA8A8948C89817F8C978C7A726E616389A589615C
6F848D776680A1A1
5C4F5C72868F7D4A2D5998A3959B8E482680DFBE77788353
2E5289948C9092857D87928A7D777980806A5663715751A2
DC8F3559A09B86A2BB9E74646368727581A9BA804D7AAA7A
3B467290926C558DC9AF7D7D8B7D70818C725450658EA37D
53608DB8C59C6C72887E6E7787898788898387A7B5865662
849183573E6DA08B
425D90A19E9C8F725F6F86837E99A3633885D5A76487B488
51658F978E878077798E9D907B74798086837971684E55AA
E290304C8E867194AA7543619498887F839DAC8D6D83A08D
75839B9C8D77708EAFA68E88877C767E88898373739DB06C
2F5DA9BAA07B5B53607885746C9AB9854A588DBCC6925B65
8CA19D795F7D996F
4B74B1C8BFA48E9AA793725D669DBF834776B0845898DDBA
7E7E95998F7F6E646C869C927C74788190A6AB93705159A5
D999444B74766C7C7E503775BDBE9A83797C8690938B8AA0
B6B4A79E968E857A7888968C7B777C85909EA4968EAAB165
2963B1A36F5E5B4D4F76947767B3E172002B94C3BD956B6D
8BA4AFA392969367
82828FA6B39E8CA5B89468677F9B9D683C6499876D93B690
63779A958282837368718087857D777E8FA0A9A58F645694
C8975050789CA9906B6373889AA4966C4F62899F9C78669F
CF985A81B38A566A929B8C6F5B6682979779617295ACA571
4D79AE9C6E585D798F7D69769ACBC95B044EBCB682777F82
868A8C90959A988C
B4875A698A867D94A27F6280A7A17A48315B949D8C847752
426D9A8D74869C8A6E646B7E8D86787A848A8F9C9B765E88
AF8B5C638CBBCC9D6C85AB8F6B82925727569CAE97634A8A
BB621169CB842A60B6AF7D5A4F5F81A5A2571C4A95A38E7B
768A9F9B836362ABDB8B3766BACFA750237FDEA84E5B8B8F
7E706771828890AB
A97F48435556587180695B83B0B08F624C6A99A89A7E6154
5E7C93867480938D7F7A7D858B867C77777E81766C728293
967A65809F93786F75838E817899A6612857A2B195684C69
84522F7DC99349639892797B8175759FB3753A5F998F6F6C
79838B918B6E6DB6E597383B75AEB7612072D4AC5F63837F
7272757A7B6B678E
92845D4A44424C65725A4E7BB1BEA9806880A5A994766473
8C91887D767A84898B90938E87837F746F7E81583C679D9E
867576949F5E244E8A7B5C6F97B4B17C4E6595A79B7E6055
5C637498AF9C7A6D6F74829EAA8A7090B49A798CA1815B62
797D7C85897471A5C99D55293690CD7D235AB3AB807B7D6B
647D969378524268
AEB2998A847F8395925B3A78C4C4986A5B84B1A57D656583
A0987E6E6D7E8F8A7E7D838B8D867B727389926E4D648B8E
87959F947B5B5485AF8F62759A9C90908D7A7391AB967368
7183939389847F747181908A7D7D838A8E8888A2B0875F77
9B90777B816D668FB49E766471A2BF8E566D978870859572
5678A19A754D4475
C1C8BBB9BBB5B4C6BD6C3478CAB36F4F547DA29876616487
A598786568859D8C6E646D83928977727C93A2957A68697D
98ADA87C5B74A3BEBC9E7D7E86716799BE885179B19E7B88
A2A08F7D6E6A717A889C9B694264948F756B769BB18A6794
C4A16C72846A577DA595809CBCB39A8C8687836A5F8BAD80
4F70A09B7A626390
898684878C878DB3C3875078A77C465E877A67849C7D5E7D
A3987A6D71849489756E74828C877C787F909FA1926D5D89
AF895252708A9B9D93877A6F64555C94B9864B6A9C8B759A
BEA3776B6F6C70859AA79B6D4A5D87A09D76587494745C9B
D0924A6CA08159789C7C5979A18F717684817A767E99A57D
5875A09E8B8B908D
4F4146484A4A5784A894737E87583B80BA712B7BD5A15369
9B97817A7B818787838283828282828183868C989874629B
C0670F3F939879696670796A5653668BA0835D65796C6896
BA9664667B7B7C90A3A29077656279ADC58A4550725D5193
C2783173C39553739F7A46475C64676B6E6F7992A5A49171
627EA19C90A3AD82
5B555D5B595C636D77787B8D987F6D98AE5A208EFDB74B5B
9497847B7A828D8C84807E7C7D7F838A8C827A899478689A
C39155679299897268809B937C717891A39577635A58637F
9287747580878F9BA0978166596A8AA6A9815658695E5A89
A76D408FD5872B55A7B7965C3A659C8F6A657A98ADA58969
5F83A691748AA183
818A95908A8F8B6D54607F97A7A69EA4964E2F9CFFB94B4E
8296937E6C7B928F817C7A797A7A7E8E978570727C7B7D90
A7B3B09B888B938C8898AAADA3918792A2A28F6E545B6D6E
718A9A826B7F9EA1948A79584C749F977C7477787A7C7B7D
7B6769ABCD721A49ADE4D8803E7FD2B26E667D909B998666
5D8AAD814E628C8C
8B9AACA8A0A7A47F637A9A93807D88A5A8633683D3A54F36
5292BC91545B7D86858D8F83766E748C9D8E6F545483A98C
657699A496746184AA95747D93928677748B9F90777A857F
83ADBC722E569DA289847F6B647F9A917D818F939AB3B273
3E5A96B3AA79577AADB094726A99C2A16F7288867C7D7D6E
6D98AF7337589398
7D8BA3A49FA8A8887499B68B50425F9EC08341639B956A38
328AD5A24E4B70828D999889766769829A9F864A307EC58D
393C698E945F3A77B78C4745657D826956769FA293959D99
9EC3C25D06358D9C898B8E827A828E918D84859AB9DBD06E
2058AEAB868493A49F673B5D95A1917F76808978636B7B77
799CAA6D3967A69C
5D638088899896654A86BD8E463C6095B28E5D6285A4A674
4F7DB5A278798C9898877479807166708DBBC26B225AA88E
5C6E8A76575162849C906E4B41628A90868A8D7E758AA29B
8F9B98603044758F99A19A7C69799297845A4B82C3CDA86B
476CA09C8175767F80634D698C86757B8681746560748677
6988A0785682B18F
424564727A8C84442069B89C605A758E9A8B746D82B6D4A6
6B6D8D9DA29F9AA09C73546B8B816B667FC4E38C2D418599
9CB5B06529569B97809BA86D395999B6B39F7D574C6F948D
757074706D6D76899DA99D6F4F6D989E7E3E226AB8A06769
8283818E8E6C4C516B808A85776767829680626175909875
556F9488799AAE7C
4F56758894A1955B386FB5B69684818D978A756874A9C486
455F97A4947865778D7C68798F897A71799EB0804E6296B5
BBA9865F51729B998EA7B3815677A8A28885816552637C7A
7485917D7090AF997A85916E50668D9E93664A759E754566
978972879D8769687A91A19E8A695B7D9F8C717E9DB3AD7E
55678E938D9A9A73
62718FA3AEB7A975557AB2C2B49A85858A7F6F687299A251
1251ACB07E49304F81908B8D8F89848381796E63698AAEC0
B3845D6B8A8E8B9AA7A09184839AA47B556C8F866B636871
84A9B6825E9FDDA3556286755D6A879FA898848787634967
8D8473869FA0969190949CA6A17B5F799D978996ACB8AE87
656F8B9290948F75
5060889494A096562E66AEA9847E7C68575F748290ABA34C
0B449EB698623F62979B8A9096877D8F9D8A6C5D63809B98
8A8B908B89919EAFA9744D6F9F9B807174899A8E7567697B
93A4A17F6B94B78B586D8F7D667C9FACA693817E81797070
757B8185899095918B88898E8E8379808D928F867E808581
7D838A888AA4AC7E
4A50737B7B8A813B1057A88A51617A59374F7F9AA9BAAB64
2D498AB3B7926F81A0958089927D6F8CACA88B68566B8370
618EB89C7788A6A88C523268A3855976A6AA968679737A8E
9C8F7A75777574757D8E96807087A6A996786570899B997D
67768D84727680807B777471748490867C868A6C4D4E647E
8F8D837A83A9BA86
8371687F9BA59364476F9E8C6C7F957C606E8B96999F997D
68738DA2AAA28F796F7A8885776A697B93A29B775D759280
615B687885897B5D4D64899C936C5376A29A7E7981868E9A
9C8A726863555A8AB5A7857E81766E7C8571607594A39F8C
7C808981747377777472717175828A81777F836D5A657D8B
8A7A6C707C808085
BA986A89BABDA8978D8B91969BA5ABA2969290877E7C828D
9797938D8D9C9B694365928362626E6C6E899B87758CA496
6E3B2A60988750232C8BE2C67C5F65798A7E6A6D7F939E97
89857E6A544254A6E1AB617191693E567C776C8098968E92
958B807F807D777676777A7E807F7D7B7B7D7E7C80919E97
83695B71805B437E
A7987B859B9E9998948B868C94999998948F88817C7A7E87
8E8C8680808E92765F7692846E76816F60718B95969B9374
5F71909B8F7155516A9EBE9D6E6A7C83827F7768698EA783
5B6D8C8B7248449DE29536579786616C838582878B858084
8A857F8184827E7D7E7F818383817E7D7E7E7F878F8D8A93
947A678197715077
828886786B717E817F7F7E7C7979797A7B7B7D8083848179
7373777A7C7E81878D8F8D87848F93806A667591A49E8155
52AAF7CE7E677B9CB09971646C7E8D8B848C8E6F5A7F9D73
47679BA7905D4891CA7A204A9CA8958F8F9091887B777775
757C83848384868787868584838484838181848E8E756583
A4967F8C9E917D7B
8A80756760667177797B7A77726E6D6E72767A7E81827F79
74747678787779828A8B88878B9297948874687183949579
698CB09A7B8CAAAD9B7E666676858E8F8C908F7F6E717B7B
8098A899807079A9BE793863A9AA8F8A8C8A878077757574
767C82848486888888888785848484838282858E8C6C5673
9B9E8D7C76839495
9C7F64616B7072777B7C7B7A7773707175797D7E7E7D7E80
81807C7A7A7A7B79787E848687888F9C9F8A6C595F85A79F
7E5D4D5577A8BF9A696679808083868D928D868A886C6089
B9BFA47E687BA0B4AD836683A7977779847F76787C7B7A7C
7F80818284848484858585858483828182828489866F5F6E
899991694D6A99A9
8E7F73747A7E7F80807F7F7F7E7E7D7D7E7F8080807F8082
83838180807F7F7D7C7F8281807E818B938F82716B7B8B7E
6B6F76665F809D88696C7E82818182868985818687797086
9C978476737C86847F82888886817D7E817D7A7C80818182
8282818181818181818181818281818181818283827D7A7D
8592906F566F959C
7A818B8B888A8C8A8784838486898B8A8885838282828382
82838485858483858685817E7A7776767B889391857E7258
5693C1935253717C7D80807E7D7F817E7C7D7E7C7D878B7D
6B656B7A8377655B6380947F657188898181848383858684
838281807F7F7F7F7E7E7F7F808081818080807F818A918D
868A8B7E737D8983
7B838C8E8D8D8E8B88858485888B8D8D8A87848383838383
83848686868584858583807D7A77757376818B89858E9177
6A90B4996D646F7B85898784817F7D7B797B7E7D7D868B7F
7479817E7776797C81898877687384858181838485868786
848281807F7F7F7E7E7E7E7F7F8080818080807E7F858987
838485827F7E7E7B
838483868889878685838383858787878684838282828283
84848484848383828180807F7E7D7C7C7B7B7B777D9BB09B
7E83928F86838485898B8C8B86807B7B7E7F8081817D7D85
909B987A64799DAAA28D79757B7C7D7F8281808183858584
8382818080808080807F808080808181818180807E7A787B
80818081807C797E
838180808181818181818181818181818181818181818182
828181818181818180808081828282817F7C7A7A8191977E
6B87A590727A8F929091918B847F7D7E808485837F787784
908C7B655F81A5A18B817E7F81817F808281808081818282
8181818181818181818181818181818181818181807D7B7D
8080808182807E80
807F7F7D7C7C7D7D7E7F807F7E7D7C7D7E7F808081818080
807F7F7F80808080808081828486868583808084857F725C
5B8CB189586A92978E8E8D8681808282838687837E787881
8474615D6A87988166738B8B82828382818181807F7F7F80
808081818282828282828282828181818181818282848583
8180818182848583
817F7E7D7C7C7C7D7E7F807F7E7D7C7C7D7E808080808080
7F7F7F7F7F808080808181838485868685848282817A7577
7B7E7A6B64788F8E817C7C7F8385858685848282817F7D7E
7F8081848586807067768A8C86848381818181807F7F7F7F
808081818282828282828282828281818181818282848483
8180818182848584
82817F7F7F7E7E7F80808080807F7E7F7F80808181818080
808080808080808181828282828282848687847E7977809A
A37A505979898A83756967707D858989867F7B7F858B897B
7690ACAE9B816D6C777F8387888480808181818180808080
808181818181818182828281818181818181818181818081
8180808182828282
818181818181818181818181818181818181818181818181
8181818181818181828282817F7E7E81868A887E736B718D
A39B8373717E8B85735E5051627C90908379767B86989B7B
6588B3AF927F75757C81838585827F7F8081828281818181
818181818181818181818181818181818181818181808081
8181818181818181
818182838383838282828282828383838282828181818181
8282828281818181828383817D7B7B7F858B8A8072656678
94B1B690696F888D82705C4D517392918076757A869CA17C
5C7296958682827E7C80858583807E7E7F81828382828181
818181818181818181818181818181818181818181818181
8181818180808080
818182838383838382828282828383838282828181818182
8282828281818181828382817E7B7B7F8589888179757A88
938C7F7F8077768DA8B4A985676D8186817A767E8B8F8979
67585C7B968B75757F83858584807D7D7F81828382828181
818181818181818181818181818181818181818181818181
8181828180808080
818181828282828282818181828282828281818181818181
8181818181818181828282817F7D7D80838786807E88959D
9060416A99826584BCDFE0B888797D80807F7D83887E747C
7A513A6EA6956D6C7C83858886817D7D7F81828382818181
818181818181818181818181818181818181818181818181
8181818181818081
818181818181818181818181818181818181818181818181
8181818181818181818181818181817F7F86887A738AA197
7D6A687E8F7B667593A6AA9F95A2AA8F737C8C817379868B
846F657A979C907C707A8A8C85807E7D7F81828282818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818180818181818181818181818181818181818181
8181818181818181808080818385857F7B81867A72869682
6F839E9B88766A6A6B615C6886B3C79C6C79937F677D9A93
8695A28E7D94A98D6C758B8B83807F7F8081828281818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818180808181818181818180818181818181818181
8181818181828281807E7F81858786817B75778995856E6F
7B7B81A0AF865C6E8C7D5F535B7A958F7E818B8881828581
859DAA90707484827A7D8282818181828282818080818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81818181828282817F7D7D81868987837B696998B7864E64
886F5B95C592587BB0A478543F3F557890877A8B9A866C6E
7F9095866C585878958B74747E82838585827F7F80818282
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81818181828383817F7D7D81878B898176696D95AF8C5F65
7D807D858A837C8488745D595A514F6A837B6D7A8A867A74
7682887C695A618FB19469687B83868987827E7D7F818282
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81818181828383817F7D7D80868C8B7D71717C89908C8173
7392A4774E709C875C4B5470898675707172726C6C819284
7279837A6E6A7AA5BF9865627783888B88827D7C7F818383
828181808181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818182828281807E7E80838A8A7B6F7D8B7F717B8B8B
868C8C76657387817A889C9F9EA7A9917A848E7662789288
767882837F727499B4966B657481898C88827D7C7E818383
828181808181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818181818181818080808186887972899A7E606D8B9B
987E697C92816D7BA1CDE1BB94ADCCAB8393A88C6C758986
7E81899492766381A293756D737E898C87817D7C7F818383
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818181818181828282807E8284797694AA8F6F7A9396
8B7C747E8C8F8A8189B8D5A37096C39C6D84ABA188868A89
8A9099A39D785D789B947C72747D888A86817E7D7F818282
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818180808081838383807D7F807A7D97AA9379889B8A
747F8E80748DA186698097704D739C815B6A8E9F9F958781
868F99A49E785D799D977E74757D878A86817E7D7F818282
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818180808081838383817E7C7C7F85908D6B567AA18D
6F8096856B6A737876695749495E757C735C5472928C7263
6168798F94755E7BA0977D72747D888A86817E7D7F818282
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
818181818180808183838281807C7C838888774B36689F90
707E938970554F76926B383D5A646B81855B3A5A87836753
4B506178826F6382A296796E717D8A8C87817D7C7F818383
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818181808181828281808080807F80888769536C897D
69768989838187989B7854536C8A978063627A9AAC9B7E73
76797A746C63698AA29375696F7D8C8E88817C7C7E818383
828181808181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81818181818181818282817F7F83857A778EA2937C7A7E75
6C7683838AADC6B18E888D7F7EAEC47B3B6FC4D9C3A59091
A3B1A87F58587496A69170656E7E8C8F89817C7B7E818383
828180808181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81818181818081818282827F7E82847A7891A58F7687A098
888D8F756893B8966E8CB6A992A8B1703F78C1B686727174
8BBACA8D4B5586ACB493696171808B8E89827C7B7E818383
828180808181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818180808081838383807D7E807C7F959E7A5E83B5B8
A49F92674B6785685080BAB89E9B936C5477997B4B445152
66A8CF954F598DB6BF9665607582898D89827C7C7E818383
828180808181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81828281807F8081838584807C7A7C7D85999E79555E81A1
A98E695E62635D4C4867909EA1B1AF7F5564827D69606063
7497AA8E6A647AA3B89566637782888B88827D7C7E818383
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81828281807F7F81848685817B77787E8B9E9D784F455983
9A744D658B7F625B5C5B627492BDC7894956869FA1917F84
908C81817E69638CAD9269677882878A88827D7D7F818283
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81828281807F7F81858786817B74758191A198623C609492
797279869AB0B7A5877166606A8F9E693D69ABB8A6978D8F
9590847C7260608BAD9369687982878A87827D7D7F818283
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81828281807E7F81858786827B71728396A19053388ADAAB
627AA99A8DC2F3DAA58A7A605265704B397EC8BE91828485
898F8B7863596693B19469677983878987827D7D7F818283
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81828281807E7F81858786837B706F869C9A85645E96C8A5
717A917A6580A3A695806F6A707E7E5B4775ABA7856C6167
716D646A71676891AF946B687982878987827D7D7F818282
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81828281807F7F81848786827C7171869A96857978889893
83786D5E4E3E3E5A766F677D9CA79D7F676D7E817660505E
6D5B4D6C8C7A678BAC936D6A7A82868987827E7D7F818282
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
81828281807F7F81838585817C787A7F899B9C72516E9387
6F768584755F505A707C8698A6A59E9B978B7A67606F8697
9A8E8597A27F6386AD956D6C7C82858786827E7E7F818282
828181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818181808081828383807D808378789CAC6A305C9983
5F79A4AEA497887D7E8E9EA1988A889EB1A382645F85B4C4
C1C4C1B29A786887A59271707E83848685827F7F80818282
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818181818181818181808084857B768B977B5D6B8587
82868E96988D838B958D81848572657A9086757B87858492
A5B6B2865F6987928E847A797E8183848381808080818182
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818181828281807F7F81838584817C777A8E9C87748C
A58E6D707C706B8BA2855F657668565F6B626593B182494E
7088855636649F987A7982807E8083838281818081818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
8181818181828281807F7F81848584827D73748DA3958086
9084747980756F8292846D6B73787C85846E6692B6966152
5A69736B657A91897A7B8282808182818181818181818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
818181818181818180808081838484817C7A7C838D94907D
6C6D7B8C948A7B797E8384808193A5A99D8476869EA29171
595E7795A491787781828081838180808181818181818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
818181818181818181818181828282807F80817E7F898E7F
67525681A89C7F7D837B77879AA19881717C8D857B899173
576687999A8A787880828183838280808081818181818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
818181818181818181818281818080818285857D777D8484
76534677AB9B798593745F84ADA37A4B3C70A48C606D8574
647C978C787981807D808484828180808081818181818181
818181818181818181818181818181818181818181818181
8181818181818181
818181818181818181818181818181818181818181818181
818181818181818181828281807F7F818386867E76777D85
8B8D8C918F7564819976577CA9A1784A3E7BB49460709494
8A909387797B81807E808383828180808081818181818181
818181818181818181818181818181818181818181818181
8181818181818181
818080808181818181828282818181818181818181818181
81818181818181818182828180808081838483807B797B83
97BCCCA77155597C967C5E76989A84675E8AB297717FA0AA
A495868386837E7F81828282828181818181818181818181
818181818181818181818181818181818181818181818181
8181818181818181
808181818080818182828382828181818181828281818181
8181818181818181818181818181818182818181807F7F81
899CA491776F76858E80717A8B918C817B89968D7F838E92
90877F7F8383818182818181818181818181818181818181
818181818181818181818181818181818181818181818181
8181818181818181
808182818080818181828382828181818181828281818181
81818181818282818181818181818281808080818385847F
756762718894958F8682828182888D8F8B817A7F85807772
72767C7E7E81848482818080808181828181818181818181
818181818181818181818181818181818181818181818181
8181818181818181
81807E7F8181818181818080818181818181818181818181
81818181818181818181818181828281808080828486857F
7365606D808D908B8482837F7D7F8386857D777A7F7A736F
70757B7E7F81848382818080808181828181818181818181
818181818181818181818181818181818181818181818181
8181818181818181
82807E8082828181817F7E7E808181818180808081818181
81818181818181818181818181818181818080828384837F
7C7C7B7775787D8284817D7C7C7A7877787D807C77777A7C
7D7D7D7F8182828282818080818181818181818181818181
818181818181818181818181818181818181818181818181
8181818181818182
82858887848383817F7F7F7F7F80818181807F8080818181
818181808080808080818181818181818181818181818181
828585817C7A7C7F81817F80807E7C7B7C8083807D7E8182
838281818181818181818181818181818181818181818181
818181818181818181818181818181818181818181818181
8181818181818281
82888C8A848383817E7F81808080818181807F8080818181
8181818080808080818181818181818181828181807F8083
858787888784807E7E818485848485868684828486878685
848484838180808080818282818181818181818181818181
818181818181818181818181818181818181818181818181
8181818180818281
83817D7F82817F80827F7D7E808181818181818181818181
8181818181818181818181818181818181828281807F8083
868889898783807E7F818384848485858584838487878786
868584838180808080818282818181818181818181818181
818181818181818181818181818181818181818181818181
8181818181807F82
87776A7483807A7E85827F80838280808183838382818080
818182828383838282818180818181818181818180808081
838687858381808080808081818181818182838383838484
848382828181818181818181818181818182828181818181
818182828181818181818181818181818181818181808081
81828182827E7C84
8C7664768E897B7B828C9390888280808183848483828180
808182828283838382818080808081818181818181818080
80808081818283838281807F7F8080808080818180808181
808080818182828281818181818181828282828281808080
818282828281818181818181818181818182828181808081
82828282827D7C87
8D7D6F7D908B7F7C828E98958A83807F8182838383828180
80818282828283838281818080808181818181818181817F
7E7C7C7E808385848381807F7F7F8080808080807F7F7E7E
7E7F7F808182828282818181818182828282828281818081
818282828281818181818181818181818182828281808081
82828282817D7C87
828A8B7F71727B888C7E707A88857D7D8183848381807F80
818181838483828282818181818181818181818181828180
7E7D7D7E7F8182828282818181808080808080807F7F7F7F
7F7F80818181818181818181818181818181818181818181
818181818181818181818181818181818181818181808081
828383817F7C7C7D
7D98A58058607E96956D4A5E82867D7D80818382807F8081
8281818283817F8081818282838282818080818181828282
818181807F7E7D7F80818282838281818181818180808081
8182828281807F808181818181818080807F7F8081828282
8180807F7F80818181818181818181818180808081818182
838483807D7C7C78
8FA2A88A6F809D9E8B6F5B63788589857E78777A7F828483
8181807B77777A7C7D808383838281828281808081828284
86858482807E7D7D7E808383838384838181828281828283
838383828180808080828383828181807F7F808182828282
81807F7F8181818181808080818182818181828181818282
8384847F7B7D8387
9C9D978A869AAA9A807B7E7A79848D897E76757980858684
8181807973757A7C7D8083838281818283817F8081818284
8686848281807F7D7D808382828385838181828282828383
848483828181818080818383828281808080808182828282
81807F808282808081808080818282818182838281818282
8283837F7C7D8491
8884796E696D77818784828A91877B7A828A908D87838283
83808088918E878585827F808182827F7E7F828281828381
808284827F7C7B7E8181818384807D7F8282818282828282
8282828281807F7F80807F808080808080807F7E7F818282
808182807E7F81828181818181818181817F7E7F81808081
82807E83867D767E
6766645F574E516B8789879BA485656D889BA096857C7C82
8681808F9F9C918D8A837D7C7F81827F7C8084838181827D
7A7C8181807F7F8385827F81837D797C828281818180807F
7F7F808181807F80817F7D7D7E7F80818281807E7E7F8180
808385817D7F82828282828282818080807E7B7E80807E7F
807D7C858C82736A
4D536F8591988F73678AB3B59A766176938E7A71706E7481
8C8A80716B7686888381807C78797E868B878080817C787B
7E79767D8994989187827F78767E87837D7D81818080807E
7C7B7B7D81878A88838282818083858686888989867F7B7E
838384898C878180828382828080807F808488858181817E
7C7F838284929370
4A5484B1CFDDC4784A85CCB479667088967E59515B697A87
8E8F80593F567B817A7F837D76777F8A90897F7F817C777C
817B767F8E999D9588827E7673808D887E7D7F7F7F81817F
7C7A797D83898D8A8686868381848888888A8C8E8B81797D
8484848A8E898280828282817F7F7F8082878B898483837D
7981887B789EB482
696B89AFC2A87A57537D9D774B638E9285827D675E7E9F97
82808278707984827B7C7F7D7D8A907B68778D8B82898F84
7A828C897D6E687A8C84788794816D7A8D887C7C7F7F7E80
81808085877D747D89867E7C7C7C7E82847F7A7A7F848681
7D868B7A6B76878882818282817E7E85887A6E7886817879
7D7E7D767999AE8F
85808699965B2841727D6A43356BA6977991AC8F718CADA0
837A8396A6A39589817E7F7E849A9F714B6894918193A188
72869E94744B3A6290877491A98159739A91797981808084
8886858D8C73607087867B787877787C7D766D6A70829086
7A888F6C4E688D8E817F8182827E7D8B8F71596F8D867479
827F7875798A9791
777D8A8F8566526989907F615377A29F909EADA087716F8F
AB9A7C7782949E9383878F857E8C978671747F7E7C868B7C
717D90978D6E5973928A76757E83899496877778838D9392
8C85838A8E80706F79858C867D82877C737C857A6E798888
83868572677B938F807C7D7C7D7D818E958577879C9B8E84
828D937D69798D85
5A6F8E8C828A979A9BA2A29080828F9BA0958A96945C3A77
BEB07A544F78A29275869D8D777C8C959381717781746771
7F7A768A9F9D938F8C8C815E5083B8AB84777B7F868F9494
8E827A7F898F8C7B71849991828B948274889B8E77737B87
8C82788190928D857F7D7D7A797E858A8F979E9C999C9D8F
8696A07F61778F76
53698C8C7F7C859CADA28E87888784837A6258759281676C
7F8B896D5D83A3794C6A99907A8996795F708FA09973597C
A28E6A697F9AA8937A87977C637E9A8466718992896D5B72
8D816B6C7B8B948D828489827A7D868E918E8785837B7681
8A7F778A9B89716F7A868C878085897B748C9F8B6E6B7A8F
9887716F7E949974
606D888E81675F86AB956F6F7F86806D543F415E87A9A76E
3E5C9191849BA0612B4E8B93889A98592E5DA8C7B4774F82
BEA76E505480A58C6C84A5987C78755F5671929D8A56365C
8E866863708292968F81757173707590A1896E7A8F88797D
837D7B8D967C60657B8D968D818A8D6C55779471403B5889
A075496397ACA27D
787B878C87766A78898174777F837F726566707680989F7A
545D7B8A93A49D63354D819B9C8D74605D6F8EB9BE733667
B1B1855847709E8F7285997A5D7592836C75878B857D7A87
94908478768591887875787C7F7D797B7D78788999938582
827A7889968B7B818C8D85736B84946A47749E6E33426F85
877A6C7183959B8A
8C8987888B8983756D768386848282828A9DA8967E797F87
8573687893A1987558607FA1AA805A769C816594B5733056
99A690746371898B848D88553A79BFAF8079817B7FA0BBAF
98989A897B87907962708888848E8F6B50698F9A938E8985
837F7C7F88959E9C918373615E809872517DA87C4B6E9E87
67809E8A6E75898E
8B8B87878785817E7E8185898A86858B96A1A1917F7B8189
8B81787F8C9695877A7C8B9EA59078818A6C567B9D7F5A74
96826B8BA7866172949E8D614D87BF9C67799C947E79808A
928F8371697A8C8173839177648AA87B4E6E9D94766E7378
839699755A779B8C6E6D797C808D927F72889F8D7EA3BF91
6077A09F8A7D7980
7E8584858278778A998B797E8A89858D928B817E81898E85
7D848E8E89898B89898E9493939C9C82645B6476888E8E99
94634C96D79A4A5D94A196817590A376517DB2A370483D62
8B84685B6072888C8A97966B5083B793627A9D855E59666E
7E9FA7703F608C7553668C9FA1968A8990959999A0BBC49B
6C6982A0AA8B676A
737D7B7F807673889578575E7680838787807B7D838A8C84
7C818C98998672707981868381898D7F727D8E8E8C99A196
826C6B93B08F61627A868D94938B8174738D99714754798B
8E877C787C83888687959D887A97B196737B8B7E6F7C8B7F
707B8572637B948573849D9B8D87868991A2A9958495A79B
7F60587E9B754551
7479767D827A7480846A51586D7A7F7F7C7C7E8083868683
7E787C95A184615F6D7475747170737B889CA89C8E969B7E
677E9A89717C8974606C8495947A697F9C9D80462E74C4BE
938890959895897A758397A1A19C92867D7B7D7D849FAC91
6A5B637C969E9A95959EA0856C7587817E9DAE8559638291
89674F6782694957
867D7E81847F79777E909E9C90857E7D7E7C797C81828280
7C716C7883796F7D8D8877675F6B7A76707D8774657F916A
48709E87657E9B8062748C80685F677C94A2976A4C6FA1A5
8E7B727B898A7E6E656D7C817B6A5E6679888B7F747D8A88
7D72748BA19A887D7E898E7C6C7C8D7D6D7F8F765A657B7D
7C8B98918B9AA79B
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0113379 0.97619 0.464853 MathSubStart
%% DensityGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00751202 0.0192308 0.00751202 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -6 -9 ]
[.16947 -0.0125 6 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -9 -9 ]
[.77043 -0.0125 9 0 ]
[.92067 -0.0125 -9 -9 ]
[.92067 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -12 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -18 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -18 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -23 0 ]
[.5 1.0125 23 12.875 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(20)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(40)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(60)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(80)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(100)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(120)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.05679 0 m
.05679 .00375 L
s
.09435 0 m
.09435 .00375 L
s
.13191 0 m
.13191 .00375 L
s
.20703 0 m
.20703 .00375 L
s
.24459 0 m
.24459 .00375 L
s
.28215 0 m
.28215 .00375 L
s
.35727 0 m
.35727 .00375 L
s
.39483 0 m
.39483 .00375 L
s
.43239 0 m
.43239 .00375 L
s
.50751 0 m
.50751 .00375 L
s
.54507 0 m
.54507 .00375 L
s
.58263 0 m
.58263 .00375 L
s
.65775 0 m
.65775 .00375 L
s
.69531 0 m
.69531 .00375 L
s
.73287 0 m
.73287 .00375 L
s
.80799 0 m
.80799 .00375 L
s
.84555 0 m
.84555 .00375 L
s
.88311 0 m
.88311 .00375 L
s
.95823 0 m
.95823 .00375 L
s
.99579 0 m
.99579 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(20)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(40)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(60)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(80)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(100)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(120)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .05679 m
.00375 .05679 L
s
0 .09435 m
.00375 .09435 L
s
0 .13191 m
.00375 .13191 L
s
0 .20703 m
.00375 .20703 L
s
0 .24459 m
.00375 .24459 L
s
0 .28215 m
.00375 .28215 L
s
0 .35727 m
.00375 .35727 L
s
0 .39483 m
.00375 .39483 L
s
0 .43239 m
.00375 .43239 L
s
0 .50751 m
.00375 .50751 L
s
0 .54507 m
.00375 .54507 L
s
0 .58263 m
.00375 .58263 L
s
0 .65775 m
.00375 .65775 L
s
0 .69531 m
.00375 .69531 L
s
0 .73287 m
.00375 .73287 L
s
0 .80799 m
.00375 .80799 L
s
0 .84555 m
.00375 .84555 L
s
0 .88311 m
.00375 .88311 L
s
0 .95823 m
.00375 .95823 L
s
0 .99579 m
.00375 .99579 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.05679 .99625 m
.05679 1 L
s
.09435 .99625 m
.09435 1 L
s
.13191 .99625 m
.13191 1 L
s
.20703 .99625 m
.20703 1 L
s
.24459 .99625 m
.24459 1 L
s
.28215 .99625 m
.28215 1 L
s
.35727 .99625 m
.35727 1 L
s
.39483 .99625 m
.39483 1 L
s
.43239 .99625 m
.43239 1 L
s
.50751 .99625 m
.50751 1 L
s
.54507 .99625 m
.54507 1 L
s
.58263 .99625 m
.58263 1 L
s
.65775 .99625 m
.65775 1 L
s
.69531 .99625 m
.69531 1 L
s
.73287 .99625 m
.73287 1 L
s
.80799 .99625 m
.80799 1 L
s
.84555 .99625 m
.84555 1 L
s
.88311 .99625 m
.88311 1 L
s
.95823 .99625 m
.95823 1 L
s
.99579 .99625 m
.99579 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .05679 m
1 .05679 L
s
.99625 .09435 m
1 .09435 L
s
.99625 .13191 m
1 .13191 L
s
.99625 .20703 m
1 .20703 L
s
.99625 .24459 m
1 .24459 L
s
.99625 .28215 m
1 .28215 L
s
.99625 .35727 m
1 .35727 L
s
.99625 .39483 m
1 .39483 L
s
.99625 .43239 m
1 .43239 L
s
.99625 .50751 m
1 .50751 L
s
.99625 .54507 m
1 .54507 L
s
.99625 .58263 m
1 .58263 L
s
.99625 .65775 m
1 .65775 L
s
.99625 .69531 m
1 .69531 L
s
.99625 .73287 m
1 .73287 L
s
.99625 .80799 m
1 .80799 L
s
.99625 .84555 m
1 .84555 L
s
.99625 .88311 m
1 .88311 L
s
.99625 .95823 m
1 .95823 L
s
.99625 .99579 m
1 .99579 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -84 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 61.000000 16.875000 moveto
 458.000000 16.875000 lineto
 458.000000 4.000000 lineto
 61.000000 4.000000 lineto
 61.000000 16.875000 lineto
closepath
clip newpath
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Level) show
99.000000 13.000000 moveto
(4) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
128 string
128 128 8 [128 0 0 128 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
778785878989898C7DC7A0A7CA7185878083898886868786
868A8E9292918569D0647E8E896A505D7984858A8363C563
7C6851688884767E7E593F63908E7C8487694F5B717062CE
CF718D8E7D696170878F8C88878E8F7DDF5A5C667377756F
6E7B867F7470778592908A8B89796E7B8D8E888686818191
9160AEC568BF9CBD
888982828483838582766962697F93908483868786858587
867D76798596956D4BD3767760B9A09CAE5568CBAA2EAEA7
9EA3B7DC807B6AE668BA9EBB6A6A63F89272C8D2E252B1BA
5969778B85C799AD65838668C65A6FD549627DE4C95261E4
717C8386858384898F8E8C8C8B86838A949B988B7E7C8493
9984717E8B75606F
938A8481818181808699A79E8E8D908D8885848587848388
8774DB5C6B90A3794ACE6E65C2AB968282A6BE9A7180977D
61772C56706ED95ED0338E9BB8C45571836D566B77448C2A
56D051737E3C7484BBE370C095A44AB7B3729C7132A6C267
7F89898C8E8B8684827D797D82807D7B7D8181766A6B7581
8F9EA6A29CA0A39D
7A848D8F8D8D8D8E856B5C76907D626C828988888885868A
8A817362DA7F916EBDC3646F6C5F4F46BE474743AD917B80
919AA2AFBF5863604EA99933546567DB574BCB789376C5C0
CA46BBD36DD3B4313747575A5554CF5560829579CE536880
908F87848685868C876BCA53D44BB0AAAB30A8A8A9ACB95E
756C5B5C666C7175
50728E959191919582B88BBF856CB9CC7A8A8B8A87878989
8A908F7B68686A59443DC4749A9A8C939573D47A8C477EA0
5ECDA8989DB756CF42A7A443DE7A75C9A4A2C072959C8865
C0B844BE4F6F80D9B0ABC77FA392767F928D828186898B8B
898987827E7F85928E65B233AC8D6E707B736B7D8E8282B6
62AD778AB135A1AE
AACC77807A787A81806B5B70877863697981848483868881
7E8A95917CD0B4C4D1AB92539CA8999C9B7C67FA956FBCBF
564C382F2B9F9DA0A0978F8F9EBE563C96223BC558696B52
3B4552B3A0435EBF28B3658EA599868F9D908188918A78D8
567091988E8480868876D241A4857995B4A798BB58216EAA
6FBA80A6DE5AB0A1
263D5D655E5C5F627195AEA0888B948D817E7F8183858276
6F77838D7E408C3C64A46B9E758A7E756A605E6068787855
A9A3AEB5AE8E717483867D69627FA0A1979DA3968B97A7A4
A5BE52A98185968F9243717C7774767C817D7673706A58A8
96498598918A837D808E8A5FA68D974D786F608B9EBF70A8
7B58A35E9C8852A8
B4C6D1D3CED1D2C7C25C747B7D868F9393908D90918678E9
6CE26561C8977AA453A67381AC4D53BAA2A3ACA7A94EDE4D
A1918F908E867B7476859390857F80878E8F8A807A808A8B
8D9DA5927E828D8A8BA3BDC241B5B543C44ABBA9A3BE57AD
879AC359648298887A929C63957B86A5C451CD7782B2719F
62B388478462A19D
596A67615E67684A9C8389B871807D8894918D94947E655C
5A52BC30957E7A94AE2E907E7C91A18D7276827C7B95B03D
A78C726A748F9F8D7B8BAB4AC49E767686827A7F8686827F
7D7B7B7F86909796928E8E1E9B8A7B839192876F6DA25AC3
1D83848CA96A978F7C8D96679F7A6E768A20A7464A957096
44946894C62A7A9B
647D86797082895C966A6AA26D8D8C7D695C5E6C7567C4A9
999CA39F91837D8899A09F988F8B877E777C8076738AA639
AA8E767990AC3FA58C899D4758AF827C878582888E898280
807D7C8186838521AD2C9AA6AC8F727888857A737C9F47C1
A888747C99B75C7B8F8E868776B07A88ACADA5BBC3926B94
C4A97F8EAAA29CB8
63839E918198A26DA07F89B572969463A89BACC2CC459F81
7486A235A99887848D98A4B0369881838F9490837F94AF3C
AA958A9C3EBFBA3CA98B7FA4C83D93868A8F959A988F8686
8A8C8C8A84797B9CBF4CC25759AA8081918E8B9F38ABA53E
C3A4838D2897985386786693B06C9EB9725EB858669C669A
6555A298A64156D5
5D7D9C9383979D64A4AA5973808771AD7F90435D549A6E7E
A942C049BD329A8D8A1D2AA49A8D85868C918F817D98B43A
A49A9B33BBAB24BC55996A9351BC928184932DB030958384
8C8D8987878C949CAA48DA756EB57F738394AA57DEB28F44
744E9097AFA5949DAAA7AD5C7E6E586D846E556E77A76EAC
7E66A726B44F5FD6
5B778F897C8A8D5EB5619697795DB3826F99D270D28D6092
646F5BCEC73CA2918B9AA48E777D8B877E84897B7795B437
9F999D2FAA8A7CB569A9698BC34094807F90ABBE44A28581
878682828BA6B7258EB5728772B0766B84A2496C70398ABC
7F69B2A938B42F86676C8493A65170F16F5ED2F1823B7DC0
92679AA1C34FC5C8
657F8C8479838C7D6F7D876EBC977E727A9638B938A59DA6
B4B5B64B4FAE8E80879EAB94787D8C887F868A7E788EA937
A89689929A8173A355B08285A038B19B828322C1D64AA089
808187848B364EAB9549848F6CA1718CC050C0C7C739A0A4
BE6F82569893A3A29584787C8EA7B942B3A22D6587BE844E
99638C95BA3C33C0
708B8E80727A8D999680D4A8847272808C8C898B26D17141
7D779234B79C797080A13CA285828A88848A8D817B8BA33A
B191747C8E847B90A9329E827CAC5DBC8B7888B35F5AB391
7C808D8787ABC8B1A0558D956FA075A66C61369D9D36B68A
7B63B46E7E729D4F5FB1828BA7A28E8681737CBC734C9ED7
955C898F339C90B6
6B8C8D76D9667C89867553228095B1A78B818AA2C9808F5B
958C9C9C928B827980A240A382808B8883898B7F7D99B742
A98D777A868785858B9A9E7D71B17456927A8194A732A08D
7F858E827EA143268ABA83A1904F8C8AA2A6A09B9A2FAC82
745098D57F85B34FC5A7933A6361429B827D8A9FB7546A88
8C569AA4B69175A1
688C8B6FCC54DD6259D14FA799527A508B85A75C828A7ADD
51C23C9275809389819EB59D7C7E8C8881878B7C7BA4CC49
A28C8381868A89827D898F7873B2725DA0867F7D82858685
858A8C7F7993A68E7EAA73A0A272A46F5F759C38B3A89581
86B9664795A241B097129AC87E8B74BB919BAD92864C95A1
835AB8C7569A6F99
7C958B735A4FC53FAAA2A1A1AF5FEE4E9BA4537B896742C9
6A5EB58F778091867B902C9680828B86808C927B6F96494A
AA9283858E8B848182888877749DCA58B990768BA9A18A82
8486878582878F95A347677C795AAB928D96AB4ED13C8E76
80B061D3389A91979B8C849EC156C398791C3C9A7EA161F8
826D5B6E763C86B0
919782715FC032A49C877E9ABE52C948C05061ED6CAD83A9
645AAD92858487817C89969084858984828E937C6E8FB846
AE937F84908A80838A8C887D7B8B2FCC599D729A574FA28B
817F848C8D807E9E4DD65951BCA8A13FCE44AF546BBF896F
7EB56E6FC18A6D8B3698706F7E837F727191AEA58C7E8C49
7C7A6A828FD6AC58
8A846BD3C1A495A940A00DA04A4641DE8064B4B33A8F738D
B4BE3698847F878E9397968C83838788868483818CB1CD43
99857C7A7E868C8984878A8A8D96AD5C6CB37C84A9C045A3
847F898E8B7B77943FC3BCB937998C28B49885B463B27879
A0546ED83890869BB09E817E81757291B4B7AB2A987E78A9
66E5DE7F9173566B
7C735CBE2B8683B36651A6AE4BC1C5799155857E90867B86
9A31AD987F7B8796A229998B8182878A887E7B87A4596DB8
7E76847F798692897E838F969DA73ED1614593706EA155B7
89828C8983828287929FAC3EB4977C828B6E619C55A36C84
BC6060BD25A0B03AAEA39AA0A1847BB7765DA295988986AA
585F60778B8071EF
807E6FCAA10073ACE566C0BAC7616C5DB6917D8B9D8A7DA1
4CB7958987817F858C908F888385898583909A8E8F4B6DB1
707AA1AB9F8C7B7B858D9422A12AA3A1A2B0B0856790C13C
9185847E819AA6876B86353DA78E8096AC9380AF5DA97181
AC46BEB0A4AB40BC3B2C9B29A58472A157428E8084849342
E27476838F8C8481
7F8F8E64A68180A85A5F52C4526F73AA65668EB141947CB9
784C807B8D897E7B7B7F858684898B7F7DA03F9476AD64AC
6E80B35750996C7A9B9A8E949C998B706AA055AF7F87A42E
9C8D7F7580AA48976D8BB7B196888EB05446ACC45DB07F78
8A9EAF3EB739B2BABCA6909397806F84A09E8B7A7480A25A
84908D8E8F8A847E
648B9C62999CBA46BA42C05156C0A790868DA040BE997E29
CBB2857C868C919899928A8584898B807C94A89386B866B2
76769946CFAD8BA245A17A7D8F978E6D66A9705899858C9D
AA9F887A7D96B242BABDB9288C8B1CA1A9A72CAC35A28C75
759C4E5BCA3DAC3F48A787838982829BB645B3968390B66D
9094877E77726CDA
4F83A0619BBE7A67B3A0A343C38C6194D64EA3AB3FA28A8F
9D9C92837D8BA33FBE32938684868885848F9D29AF5B6BB5
7B7085A240B93BC855A170728B9998817BAF6A63B38A7B98
40B295837D829E597C683A9489929B8A7780908E878E8F79
74A66266CA41B7C24EAC897D81889ABA5E6AD83C9BA9557A
908B7A71E25A4DBC
5C8DA47D515F7E7B5CA6818A9A7E744583528795BC3FABB6
44318F82818A9B37BAAC95898582838A993DD25CD47070AB
7183ADAB9F32BA41AE9889919F26968A8690A6C34D977198
52C426888497B243B9B5AC998C99A38A73849E9C8E888684
8BA5B9B2AB4B67DF51B6288E8897343FBE5254B42AC37588
8A858289855CB0B3
778F908471DC627573B06E657B87A06988B86C8A4FC9425E
6EBC867C878B909FA926918B8680808CA85F8784758077A0
64996449909DB5A08A9BB43CAA9A8D8C89726B9E4EA07498
4FBD9A868BB2519D697A9F25939E2D938391A632A0867893
AF28867C945C93875CC0B6A59DA3ACADABB1B2A1A15B9094
837E889FA067ABBF
867551C04BC3C44EBE9A7A7E908B94D27EB877A062C096AF
CCAE827984909C2FA99987858983808AA045DE77808F7EA3
6599E0509CAD4D33974263BA877C848A8877708FAD9E8692
A18F7A7D9132B69C7C7C8C90929DA195867D7F90987E72A6
57A76F79AF729C9D7C4EA735409C893A685C34939A5C989C
837474868C644260
7CC9917D88A1369B808296ABB092823F71499240E2367486
309C7F798292A537AE988382898783888E922AC7759286B2
7292514BABB74EBDB75C69AB6C68829194908A899228A691
766E747E8C9BA633A6907E849522988F82726C7C897977B2
64AB708E587D8C93824E9F39C48C6BC5A681A98FA560929B
877367E47163D371
C6328F756E859985708A35B63326A5D279CEA0B152B092A9
48A47D7C8A8B8D9DA92994898384888784848FA651828F4E
8594BDBB2A9492A846BEAC9A8D8892AE43A5857C8EBB59A0
6E8DB898769F53B88D7C8196A8A28E7E7F99AEA48C7E86AF
50A47D96CC73775EBCBFC7BBA07D8161A465899B5F7B848A
8985827F7B74E45F
999AA48D7581938882A449B29CA951778359279CB14450E0
66AE7C80928374859FA9A3907E818A888386909BB46D875A
9C9F3BAC937A7499B899758E3AA89D4E69B27671965978BB
884A82B163A171BA6C6A8DA534A38A717ABD7957958B9C31
AE9E8F9A3CD864A1773A7B558C7EA06C8EBB72AC8E967C7E
8A9196938C897A4A
9C9A32A497A0AA279DBAD0419FA6C2676FC69C95AC54E76E
54A17E808E867A82901D948B8383878887858E3152DBD84A
AFB13A9C8B9F41BD32198391A3938D47E6B6767298CD755F
BC6275A7648C4CAD80839590878F90756EAB694E989EB73E
ADA528A233CB57976FAD817F519E98639855843889968688
897D75768195925B
A8969FA531B4B632ABC8634BA4A13ACED63D959B43697B62
AD8D7F80878A898A8A888586878584898C8288B96A59B035
B840B299975A8AD79693A4967F737EA94F37887F923B5DE3
66D74899787A8E999C26987E6D8094806F90B52F96AC4EBF
31A7AC30AFC858AA8CAF6F948ABC8B549E73ABBE788A8C92
865EB844648E9B6C
8B757B80868F928A1AC9744E959F4C6A6A3D90A560FF895F
A18681868A86828D999B958B8382868A897B7AA3CA4AAD35
B3A59C2FC26567AB767F9889727B8E9396A6AC958398BB52
5249B2A396867E89989A9698988E84858FA3AD9A8CA849AA
8B94ACB13DD26749A53BD4685EB224C77DE7536B8D867884
82C69399C2758352
7D6D706E6D74796C76BD784B8CAA6C81EB46A0B66D909060
9F84838A8D80798DA838A8917E7F898C86787385A23EBEB4
A31C9DC56A56A27E6D74827E7C95A6856E9F56AD7B87A5A4
9CA9B83FAE9A8783878793B953A47782A64547A48C2BBA90
6785B53FB55C755AB345CE3EA0ABC3575E616A899C7E5C6E
79428184A8CAD3AE
B3B1AFACA9AEA98878A8D744A1CE8771C24DD6514E768F62
9C83828587817F8EA02B9E8E8180878C8C858185953EC930
90B46B70D344A99C948F8D9098A8308570A45E40888D2386
789C4C4DB22892847E8119B44BAA837689B862C6A43CC18A
5F945B469DBFE757B5D0745DBC567472E069EB797A65CEDD
68B17E7E1E2C3439
77807B7B7C7D6FBD97A0B737B167864F9858935A94C68A66
9C8482818386888B8F8E8B888683848A929A9E9B9F45CFA1
85559F7AB1ADC350C1349CA031AA9D8882A5C9BDA09E9B7B
6B97C94EAEA49D8B808695A330A4916F6BAB736AC04DC990
6DB0EF437EA76750A85181887F8184817C776C58C2C3535F
D2AA848A9E9B9EC6
79807B7F858379654E3FAD249AB755B1A270A2C66FA88065
9C8687888A878183898A8A8886848488933042B6B2515CAA
85AB60CB302C39C34DAC8E8A93948D807C9438433CA99883
7E94AF3CAFA928948C8F9AA9AD9C857885B46663C64C489B
87446EA86CAB7D5D9791B4759D84D667807CDD4631AE4658
57318BA1C1BAB155
615F5C656F6C69737357AA928A93A42FBA809D446BA1796A
AB8D858F9B8F7C7E888B8A88858587858EAE54D55758CD3E
9F158D9CAD33A7ADAF258A7D797D817D7A869AB1BBA99290
948886A548B9A19A9B989B35B5937586AA43C247B935AAA8
AE4AC58F714088638E687A55976C2EC17A785BBDADA8B3C9
55A98F3D6F664BCB
D0CFCAD7E364D9E7E8C0979934BABC34B1759D5F95B57A84
619A6D893CAC8D8586807D81868A898287A859F17A52A8BB
D74BA398A2BDCD37909FB5A3877E84939E9489952A9A128D
8B6C66AD765EA120A322949D278B7A8AA534AAA9A08784B5
664F99828CB7D6BB9494B05AE44CA9C5726BCB49C13E37BB
BD9D8EC27D66B642
5A605B677169616B663387A7657D7044A662997F51CD708F
87AC6281BF419A8B857D7C81868A89828396427C924F8BB7
817ED1B02FD072B67F9F5953AB928BA23DA3868895948C8C
846363BB8F6FA3959E948A8E928B848794A5ACA18A6F75BE
7CC1787FA7B4372CA95B7FDEB33546D2635CCA575D4BAFAF
36968D45E84A95AA
6B7D79808579738A8C4888AF7A90F858BAD6848269CA4B6A
7BC08488A099867E8294A2948080878A867884D395639A37
6357414E63614D2C8D92AA49C8338B879090932EB8AE9EA0
A3918DB86758AA948A818398A494808096475C3985819E4B
59A676812F4CD356CB626D5133B1C34AC35562E2DBBDA434
BA2A90AC499B7AA6
7A949296968784A8B26391AB71877D6B5C616F766ABCA246
6AD23090837E807D85AB4AA67D7885918D695FAD826FAFA2
A49499D484D292909E8477A75ABB876E6F7F9F4F66CF3F43
C9C23CB0AE31A293857D86A944A07B78995BF64C90AC5E4F
A08C858398CB7D7DDC46ADA9AF40BCADA84C6A684D2A93AC
C83B95979A7A6EAA
708A8D8D8A7D7C999F5E959B4F738378DE60E06F69BCA559
84DDA31595A7B32D98A83DA2847E859194827EAC5E4E9E87
8594AF5257AF8988907C739F4CAD868798979DBD6262D15A
5A45AB39B695788AA62696AE46A7847888B5D746A7CF7AC9
8D848E8384AB595E48A58D8792AB3E2991ACC9BC9B7F7BA1
4DBB9A8D867579AD
647B7F807E74738788539491B56A8B87716560D8573AAE74
A1669088AD5CE955A5999C96908F9090939DAB40BBA58A7B
83A546AE90898C827D889BABAF9F9538CAB29429C3D66361
CC329CBF5B98608D54C4A432B6A4897979913339BA6071C5
93898D817986999F9A8F81737593AC9B859127957E6E7396
B83C9F90857A83AE
778C88909588839FA45D91A2618495A198764EB1A38E9764
976795829B4E6A4B96909C1F95A331978414A5B641AB9920
9D928583827C767080B667532FAD47C6422B939E3F545BCE
C2B8BB5A63B38EAE5DC3A22FB195756F7E99B3BB42C0483D
2C938580818283868785817C7C87918D8684888E93908E97
A42DA29C8E7270AB
7D9490989D8D88AAB25F8DB383928DA2A776B08C7C6E7CB7
6B569E8080A1BDAB8D18A29F9F3EC4A680798BAB4ABCAC3E
B8885B6D8C82717CA1668C68B55475D1A31FA3ADB8C1C242
42576D70E05F58CA47AFA330AB8E71728CB0C94AAE9B95A3
AD977E818E8B83828486888D8D837B838B817D96B13AA799
9525AA329C776DAA
48687E7561585D72733F8BA45A615C6A6E4B98837D787E95
A8A29184828C23ACB0A398A1B55055BB9D8685A446B39D2D
B7B2A1918A8EA3C86963CAC3CF788B6ABABBCB4E433DB339
BED87A817E7E70BD1EA0B637A19FA09798384C3D9987838D
968D82858B8984838586898C8B847E858A827D91A6289591
9AADBCB8AB2DAAB0
8BA856B99493A0A39E93898B959A9DA19F9387878C8D8980
7A7B81898D8487AE52348B9D49CBC74FC22D92A1379E8991
AE5A67B68FA66392954F8B30738F8C7A6A6F796DCFB7AD40
D0667280898C73A5749F5DC099AD503C9AA4B09F8783857F
7B818987838487878786858484868989878483888B85818B
26B94EB9B0D26FBA
8F8E9C91818287858385878482848685848384878B8C8980
7A7C82898B828098AB99869737B23649D14AACA09A919332
BD389E9C3658778272C6B1598791868384848486794FAF56
817C68DE6F857FAB72B1825E1D98AEA18F8F928B84848681
7E83888784858888878685848487898886868685868F9793
92A841332B526F49
A287777C8888838385858586878584838486878584838489
8D8C8886858584817F80858F959295AD4DD04BA8908C9F4B
CD8E598659EF6D55C05C7E8F8F8781878F8881909469C26C
96835CC8587880B8854A8FDD8F7B8282817E7C8087878689
8B888586878786858686878787868585868787848AA6B8A0
838DA2A1A0B5C642
91837C808787848485868686868585848586878684848589
8C8B8886858786817D80858888858691A544CB462D918CA7
46B1A2C06ADE52CC61798E918B8583878B88858B8D81716F
E75D53D76E7565AE914671BE7C7484847F7F7F8387878789
8A888586878786858686868787868586868687848C32472F
868292A9BA3FAB9E
7B848E8C8484878786868686868687878686868687888785
83838586878686898C8A86858584827F859F41C8BC987C8A
B46582887655BF678F9283808487888683878A827D8E936E
C042D27B8E7C56B0A236B694707B949185878C8985858685
84858786868686878686868686868787868686858BA2B2A6
8F818937CF439680
81878B8A8686888887878686878787878787868687878785
84848686868686888A89868585858480818B9AA7309B912E
C75C67808E786377939183818587888683858883808C907C
656777868E8878DF4EA78C7F7F858B8A87888A8886868685
8586868686868686868686868686868686868686888F9392
8C8284A240A6867D
8D8881838787858686868686868686868686868686868687
8887878686868685838486878787878989837E828C94A54E
62BCA75F9B9F8A848584868888868586888685888A84818A
95969087848E93845EA0777D928C7F818786848587878687
8786868686868686868686868686868686868687857E7A7F
8584848E968C8186
8A8783848686858586868686868686868686868686868687
8787868686868685858586878787878989837D8187858CB0
CD46B35B87948F898584868787868686878685888984818B
938D848587817056B08F7C828E8A82838786848586868686
878686868686868686868686868686868686868685807D80
8586868686858487
848588878686878786868686868686868686868686868686
868686868686868787878686868685858686888D8C7A7292
42CA55DD747E838788888785858687868586878585878886
807877868965AD8E82838987838588888686878786868686
868686868686868686868686868686868686868687898B89
8787878685878886
848687878686868686868686868686868686868686868686
868686868686868687878686868686858687898A888185A8
4FC3426286897F8187868587888786868686868685878883
828991927BBB847781878887848587878686878686868686
868686868686868686868686868686868686868687898B89
8686878685868886
878685868686868686868686868686868686868686868686
8686868686868686868686868686868686878582828C9F45
57BAAD659C99807F88878588898785858786868686868684
88989E895D9C747C928E8183898885858686868686868686
868686868686868686868686868686868686868686858485
8686868686868586
878686868686868686868686868686868686868686868686
8686868686868686868686868686868686868683838A949F
ADBE5C7C928E83858C8B8683838487878686868686868787
847E6F53AB8C7B818D8B8384888785868686868686868686
868686868686868686868686868686868686868686858585
8686868687868686
868686868686868686868686868686868686868686868686
868686868686868686868686868686868686878785848178
83417B89818186898B8A878280848988868686868686878B
815BA88F86878A8783848887858687868686868686868686
868686868686868686868686868686868686868686878787
8686868686868786
868686868686868686868686868686868686868686868686
86868686868686868686868686868686868686878788857B
7D9DC974888B84818285898D8E8A8585888685878983808D
86C78A788186888784858787868686868686868686868686
868686868686868686868686868686868686868686868786
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686868686868686868686888A8C8B
8C8FA562929783756E6C7487958E8183898784888A827E8C
8A5999868884818588878586878686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868686868686878683818187
9842667984908E70C4ABAD567E8B87868586868584878B8B
85795FAA85828D8B84858787868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686868686868686868687847A7886
AD79AB9775859672B28B85A95F777E818385878481899085
80989B598B81918D83848887868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868686878883818D93847F9F
59869C9280878E795A4741C3CC4CC56A8A8B82888D807375
849A9B71AF87777D898A8485878786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868685888982808D9B979CC6
79817B7E8484817B7A84897B5DAEA0CD8B8E7F8C9374D36B
8A8D827B619C6A738E8D8283888786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686868686878685878882872F586F
7D8E91735AE58170D6E98B8F7E5C4555758487857D6E6979
8B89818379C89A8A8A878586868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868686878884828C8F7876B98689
7A96A76EB253785DB34D768E93887361607A908069E88088
8A89888884785CA67F7E8B8A848587878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686868687878584898A7E87C48B96
87837E6B59CBC94C536E87877B79F0E2DF7D948B77737A83
8A8885888C876BA875788F8D828488878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686878585888882818EAB587D95
947256E57E55A53FE685866FCDCA5C67727F89918E7A6A77
8A8780878D876AA774788F8D828388878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686878785848A8C7E7C9F55707E89
8B7B6BE4674DAEB245BEB841433C3D566F6E6A809281E678
8A8A8585878B7ABB847D8B8A848587878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686878784838B8D7C7AAB6B828280
818C8D6A44B943AC90746F9AC5BBA9C76ED9C765827F747D
8A8D8A8281908D5996838686868786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686878884828B8E7C78A867F57E86
8E90866BC4AFA328987569A4695DBE66876B444ADC6C717D
8688867F7F9294619E858485878786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868687878584898B7E80AC6574788D
9A8366DA5BB2939EAD9990C4837E6D85997ECEBC46D06D7E
8587857E7F9395629E858485868786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868786858584985587857584
8C68BB45555548B22EAA4464828E8D8884857E6048CE7288
93958F817E9296649E858485878786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868785858888838188A76FA3997979
7547979BBA6672C49C35D6696E828E7D6E818E6E4ACB6E83
8D8E887F819495629E858485878786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868686878686858496558D9A8C81
E0A97C7F9DBD52BAA635C4CF59D25E7383F059B2A1B04F57
55CD5B6F8799905E9F868384878786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686878785838A8C7D7EAB6D909684
5B9A737A959FA5B747AF9E34BDA8A36A9C6B998393A9B8B3
A196A45C8F9D85529A858585868786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686878785838A8C7D7EB072857A69
4A9276944548425F6EBA8714A725A1649064A3325765625B
479991579A9C70B389808989848587868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868687868588897F8A4C858466CE
BE9F96BF75F3748B91578F87999CA75878E25673999C8F8D
7DC1A5609D9560A0797B8D8C838488878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868686868587878190C8899B8A6B
515364707A8998A49E76BFA4947F82B5737D76FB92969594
8A7162778F8A66A577798E8C828488878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868786868584955087A29E7E
E17F9A866A779196928D7A59A67266A87D908075727A8685
828B948D828272B07B7A8D8C838487878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686868687878483869D5D8A775660
7C8783F061C442547186897B5A9F8C4D8F8C6E6B7477797A
7C8792928B8871AE7A798D8C838488878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868785858888828188A3637DB57AAC
7D78586364A97E99597A878C7DCEBC6F9D8660E5848074ED
7779808B918A6BA978798E8C828488878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686878585898A807D8EAA4DC7956E97
5CE060EA7756B0B9DB85988F704B416C9A937A7C87878179
76818D877B7968AB7A7A8D8B838487878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686878585898A817E8FA434A7928594
B35468737679796F6F8A997BC4A4A2C77C93958E85817D6D
667C8D7558DA64AE7C7B8D8B838487878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868686868587888389AB49A8881F
B641B3B3B94DD560626A684FA81B929F4063808D8364BDAC
ADBD50BCB14F5CA978798E8C838487878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686878884818C917871AC66458EA0
BCA47F767D899A35BAB7AB9F948F8A8186A85873E7438D7F
85878D98A845C29D777A8D8B838487878686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686878784838B8D7D7798BDBDABA3
218A7A72758596959199269384888F86849FBC43B236ADA3
1D8B8F36CA419A8883848788868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868686868786858788838A3146A4
7E7E8C888598A38C7689A1937E83919092A7B29582AB6260
BF31AA5265B179798E8C8384878786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686868687878584898A807E98B0A7
928E908A8996258D7A808C8A827E7C7A812232907B9CCB5F
D0C0B2B1AE957C7F8A898485878786868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
8686868686868686868686868686868686868685878A942D
B4B1A291888D969289817E84877E74737F95A59F1B9830C3
58C62F87747C8C8B83848787868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868686868686878685888983859C
435E603A8987948F868D938D878C99ADB8AC9DA8B8B2AF4B
5A43977F787F8A8A84858787868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868686868685858888828190
B0667BC9918D9B897B97369B869AC3707846912DD051B847
C5A68686918C838488878686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868686868686868686868686868686868686868686868686
86868686868686868686868686868686868685878884828A
98A9B3AD2BAC338E7997B7A28921496F73B37F9A4E44A09B
9C8E83878E8A848587878686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868687868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868687
826F6988AF45B4937B91329F8B93A9C14A9A758AABA1857A
798087868284888786868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868685868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868786
81746F8198A09A8B818B979288888F989A8C7E858F8C827D
7C8187868385878786868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868685858686868686868686868686868686868686868686
868686868686868686868686868686868686868687868686
899093897D7A7D838787848484817E7D7F878B857F81888C
8C8985868887868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868788878686868686868787868686868686868686868686
868686868686868686868686868686868686868686868686
898E90887F7C7E84888682838583807E7F858A868082878A
8B8886868787868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
868889888686878686868787868686868686868686868686
868686868686868686868686868686868686868686868686
858280858B8C8B88858688888788898B8A86848689888584
848587868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868686
878482848686868687868585868686868686868686868686
868686868686868686868686868686868686868686868686
85838386898B8A87868688878788898A8A87848689888685
848586868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868687
878380828686858687858484868686868686868686868686
868686868686868686868686868686868686868686868686
878888878483848687868585868685848486878685858787
878786868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686868587
86898D8B8787888685878989878686868686868686868686
868686868686868686868686868686868686868686868686
868787868585858686868586868685858586878685858687
878686868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868686878786
84929D9486868A8784888C8A878687868686868686868686
868686868686868686868686868686868686868686868686
868685868787878686868787868687878786868687878686
868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686878685878984
80952B947D7D878A87837F81858686868687878786868686
868686878787868686868686868686868686868686868686
868686868687868686868686868686878786868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686878685888981
80919D907D7C858989837D7F848686868687878786868686
868686878787878786868686868686868686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
868686868686868686868686868686868686868686868686
8686868685878881
8A88899299958B8181919E95868589888685858586878786
868686858485868686868686868686868786868686868686
868686868687878686868686868686868686868686868686
868686868686868686868686868686868686868686868686
868686868786868686868686868686868686878686868686
8686868686868789
907F79973AA98C797C9E42AB8B848A888684838486878787
868686848383858585868686868686878786868686868686
878686868787878786868686868687878686868686868686
868686868686878786868686868686868686878786868686
868686878787868686868686868686868687878786868686
868686868785868D
847C7C95A8957976869DAE2D93868182878A8B8986858486
878686898B8A878787868686868786868586878686868786
868687868685858586868687878685868686868686868686
868686868686858686868686868686868686868586868686
868686868586868686868686868686868686858686868686
8686858788848183
8088939E2387747E9296939493877E80878C8D8B86848485
8786868B8F8D898888878686878787858485878786878786
858687878584838587868687888684858787868686868686
868686878685858586868685868585868685858585868786
868687858485878786868686868686868685848586868686
868686878786837F
9AA73DBEBDB2A397921B958B82858C8C86807C7F85888887
858787807A7D838584868787858585878987858586858586
8887858687898A8886868785848689888585868686868686
868686868687888787878787878787878787878888878586
878686878987868686868686868686868687888886878786
85888884828A9597
47CC5A5C5A574DAE9998998576889E97847977808C918F89
8487887E747A848584868887858485888B88848586858486
89868485898C8C898586878482878B898585868686868786
868685858688898887878888878788878788898989878586
878685888B898685868686868686868686888A8986878886
85888983808B9F38
68E95EC3AD9B99AE42A3817985992A93818BA0A7A528998B
81818B9CA6A195918E888385888A88837F83898886888A86
82858988837F7E82878785898B857F838888868686868686
878787888784828486858384858584858685838282868987
858688848083878786868687878686878683818386858485
8785838689838BB6
737C5CAC856A733763B37B88ACAF9E8B86A24BCA42A99687
81808F3BCF48A522988A80838A8C89827D838A89868A8C86
80858B88817D7D818786858B8E867D818989868686858585
868888888684828485838183868584858685827F7F858A88
848688847F82878887868787878686868682808285848286
89827E8B927972AC
607568BC239EB7D3DF4EB3526846928E9F2EAF44BC9A787B
8C90929F31A79E9B968C838486807F919F927F8087827D85
8D867F8491A1A79581848A7F788C9F948080888786878987
84858582848F989085868B8D8D8E8E8C8B8F93918B858286
8A8482909C938483878785858587888484919C9386878C8A
8685878E8D7873A1
C56D79DE546E8874585C748E8DCB8F1FB5A58FA136906E77
909A978B81858F93918B85858578789E419F797C8B7F768C
9E8E7A829C434FA47B80907C6F9640A17B7B8A8984888B88
8384847F8298309D8A8B9396961D9793921E9EA099897D85
8E827D9A3A9F817E8888848383878A82829D399F8486918B
84878D8D877C7D9C
5978827AE86F6E5DCA5BEB88865AA6A3AF2B9699A3ABA68B
77882BACA29387108F867C86918C8693A0998D8F949090A0
32A292888BA0AC94787F939B9C9F9D8F84858B8984818082
868B8B8684909EA099178B9197928D959C938B9424958886
888384949F917F818A8A87878789898280919F917C797F86
887F798690837DA1
728886867B5CBBB94DD1626F72DD4E3EB1B8BC30A04C64AB
7584B45A5BAF878EA08D7989A1A298901397A12195A3B235
A7AE379B827C7D7E8083923DCC2F7E839794888584858789
8D9599948B868A99A395848C978F86929C8A7A869A9F988B
81858C867E81888D8E8B87888B89868686827F80817B7781
8A7D7386968178AB
798E8A8A85735DC449607A80776EE16265757858B2B952C8
43B7BA55D73891AD54B18A9330A120B1C4B3958386A542A4
8AA1C044A385738399918AA84BB39BA536997D7887A946AF
9724AD309B8D851296959399269C941286868B8F949E2894
8486897C768CA52C97877C7E858382909887798BA4A69988
8291A099846D74AF
71898A89898F8A6ACE719798867A7983939F987BCE35AF66
907A4FC54FADA1CF7E5FA526AB9FA25D8259917076A14599
708C47D856A58296B3298C9BB642BA49BC9A78738EC570CD
28A3B7B7319A8B878D98A32DA6A9A48C7A8BA1218E99A49B
8C87857B7D9CBAB59D86797D867F7E9932917C9D4F57BB96
84A850AC796576AE
617C8789888C8D81788493928A84848B918B7F776D59CD74
96907563CD3D3B648772C0AAA8B450DE6A5DB88A77A6D0AB
788438D96B4698A546B2A4455EC2A42CAC9A878A9B3643B4
A6A32FAEAD9F9298A42CA2A09FA12AA09C9D9D938C96A123
918E8B828297322E988F8E999E897A9BB590719DD55739A4
2BAF3EAD98878AAD
567083898581828B928D8483878A89867C675BE27E84817D
7E8C937FDA4DC7657B745AB53252725FC05F72B98C386547
9294B1CD62D042BB49BCC06F82C3830CA2A0982AAB9D909B
AB2C9EA939A8A037C0B29D23A19999B4C737908B9625A4A1
9A9594959797979A9F2CACB63B967F9AB38E6D9952B899B0
CB3B99A5B939AAB6
5EE87F858686858584817E7D81888B8376E26674868C8A84
82888B7F6D5FD4DD6DE55F4EBFCF68DF637F8E67B546D4BE
A949644F3AD07669C74550707BBF899FC43894A0BA4CC644
B438B9C75549B4424AB3A43EC72E8E37593C8F98B545BCB6
309619B15340A1B0CA50BD3CAC9C93242E96879E3B9F8F3E
65C9A328B2444FCF
71767F83868D8B796A7383827E848A837B7D838788858389
8D837672726E6A6A6B68DE6463D35A728E988F7BDE5751C0
4C788FCF9D589B8B5CC7CC5E6246AA52E94A98A7597C8566
BC465DE46C61CCC84CB639D36EBB8FAACFB99BAE56D55450
C0A8A3CF7CD9B553756B4EB430A9ACA9A4A42DAEB0A29E46
E266C734A6C36F76
82808684848B8A76E27F9A988A8889868386888987848489
8B8273E0DE738386807B787A7C75717E8A82757474685EDE
728283DE517097947C6C5FCEC9CB58636552C2688677CF44
BAC1545DDB636466DC52BF525BB927B4554D3DC05045B5C8
6566626F73563E4FE467D2D057CA4844BAB2B451655CC754
66797B5BC06C9A97
88878C878287897B74869A988D8889898A88858586868787
85857D685D7796998F8B8B8B8C8C88827868D96B78EC6D82
907961738E8A818E96836653526778E3CF58709AA4629395
B94CC64F54D86D7B7E6FD34CC0BF4ACBD25A57CDC230A24A
7B97987E5BBFBB4BD260677A85715AD76350C27099947969
E27D8CF26781A19B
7E888A88868889857965575B6B7B85888686878685868786
858A8C8179838E84787D8994958778F4827973828D766481
9B7AD072988D79879377D2D9778484796A60E0849169B234
4A60E86C64E073838D86786E6C737971645BD2D86256C7D6
78929A80D955D46672777B898F79DE6F7E7269819C978681
7C695B6068605A69
pop
P
% End of image
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{554, 263.563},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40008Z00011aP00`40o`000?l0003oooooooooool/
oooo003oooooooooobcoool00?oooooooooo;?ooo`00ooooooooool/oooo003oooooooooobcoool0
0?oooooooooo;?ooo`00ooooooooool/oooo000Yoooo00<0003oooooool06oooo`<00003oooo00<0
003oooooool06_ooo`<00002oooo00<0003oooooool06?ooo`800004oooo00<0003oooooool06_oo
o`030000oooooooo00;oool00`000?ooooooo`0Doooo1@0000;oool00`000?ooooooo`02oooo00<0
003oooooool04oooo`D000001?ooo`000000000000?oool00`000?ooooooo`12oooo00<0003ooooo
ool06oooo`<00003oooo00<0003oooooool06_ooo`<00002oooo00<0003oooooool06?ooo`800004
oooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo1@0000;oool0
0`000?ooooooo`02oooo00<0003oooooool04_ooo`D000001?ooo`000000000000?oool00`000?oo
ooooo`0Moooo000Xoooo00<0003oool000007?ooo`030000oooooooo00;oool00`000?ooo`00000L
oooo00H0003oooooool0003oool0000Ioooo00<0003oool000000_ooo`030000oooo000001[oool0
0`000?ooo`000002oooo00<0003oool000005oooo`070000oooooooooooo0000oooo000000;oool0
0`000?ooo`00000Foooo00D0003oooooooooool000001?ooo`030000oooo000004;oool00`000?oo
o`00000Loooo00<0003oooooool00_ooo`030000oooo000001coool01P000?ooooooo`000?ooo`00
01Woool00`000?ooo`000002oooo00<0003oool000006_ooo`030000oooo000000;oool00`000?oo
o`00000Hoooo00L0003oooooooooool0003oool000000_ooo`030000oooo000001Goool01@000?oo
ooooooooo`000004oooo00<0003oool000007_ooo`00:?ooo`030000oooo000001goool01`000?oo
ooooooooo`000?ooo`00000Joooo10000004oooo0000oooo00006Oooo`030000oooo000000;oool0
0`000?ooo`00000Joooo00<0003oool000000_ooo`030000oooo000001Ooool01`000?oooooooooo
o`000?ooo`000002oooo00<0003oool000005_ooo`030000oooooooo00;oool01`000?oooooooooo
o`000?ooo`000012oooo00<0003oool000007Oooo`070000oooooooooooo0000oooo000001[oool4
000000Coool0003oool0000Ioooo00<0003oool000000_ooo`030000oooo000001[oool00`000?oo
o`000002oooo00<0003oool000006?ooo`070000oooooooooooo0000oooo000000;oool00`000?oo
o`00000Eoooo00<0003oooooool00_ooo`070000oooooooooooo0000oooo000001koool002Soool0
0`000?ooo`00000Moooo00L0003oooooooooool0003oool000006_ooo`030000oooo000000;oool0
0`000?ooo`00000Ioooo0P0000?oool00`000?ooo`00000Koooo00L0003oooooooooool0003oool0
00005oooo`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Foooo00<0003ooooo
ool00_ooo`070000oooooooooooo0000oooo000004;oool00`000?ooo`00000Moooo00L0003ooooo
ooooool0003oool000006_ooo`030000oooo000000;oool00`000?ooo`00000Ioooo0P0000?oool0
0`000?ooo`00000Koooo00L0003oooooooooool0003oool000006?ooo`070000oooooooooooo0000
oooo000000;oool00`000?ooo`00000Eoooo00<0003oooooool00_ooo`070000oooooooooooo0000
oooo000001koool002Soool00`000?ooo`00000Loooo00<0003oool000000_ooo`030000oooo0000
01_oool200000_ooo`030000oooo000001Woool00`000?ooooooo`02oooo00<0003oool000006_oo
o`030000oooo000000;oool00`000?ooo`00000Goooo00L0003oooooooooool0003oool000000_oo
o`030000oooo000001Koool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool00000@_oo
o`030000oooo000001coool00`000?ooo`000002oooo00<0003oool000006oooo`800002oooo00<0
003oool000006Oooo`030000oooooooo00;oool00`000?ooo`00000Joooo00<0003oool000000_oo
o`030000oooo000001Soool01`000?ooooooooooo`000?ooo`000002oooo00<0003oool000005Ooo
o`070000oooooooooooo0000oooo000000;oool00`000?ooo`00000Noooo000Yoooo00<0003ooooo
ool07?ooo`030000oooooooo00;oool00`000?ooooooo`0Koooo00D0003oooooooooool000006ooo
o`800003oooo00<0003oooooool06_ooo`030000oooooooo00;oool00`000?ooooooo`0Eoooo0P00
00Coool00`000?ooooooo`02oooo00<0003oooooool05?ooo`800004oooo00<0003oooooool00_oo
o`030000oooooooo04;oool00`000?ooooooo`0Loooo00<0003oooooool00_ooo`030000oooooooo
01_oool01@000?ooooooooooo`00000Koooo0P0000?oool00`000?ooooooo`0Joooo00<0003ooooo
ool00_ooo`030000oooooooo01Koool200001?ooo`030000oooooooo00;oool00`000?ooooooo`0C
oooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool07Oooo`00ooooooooool/oooo003o
ooooooooobcoool00?oooooooooo;?ooo`00ooooooooool/oooo003oooooooooobcoool002GooooP
0000=?oooml0000Boooo000Uoooo00<0003oooooool00_ooo`030000oooooooo00Goool00`000?oo
ooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0
003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Ooo
o`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo
00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?oo
ooooo`05oooo00<0003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0
003oooooool01Oooo`030000oooooooo00Koool00`000?ooooooo`05oooo00<0003oooooool01Ooo
o`030000oooooooo00Koool00`000?ooooooo`05oooo0P0003Coool01@000?ooooooooooo`000007
oooo00<0003oooooool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003ooooo
ool01_ooo`030000oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000
oooooooo00Goool00`000?ooooooo`05oooo00<0003oooooool01_ooo`030000oooooooo00Goool0
0`000?ooooooo`06oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06
oooo00<0003oooooool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003ooooo
ool01Oooo`030000oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`030000
oooooooo00Goool00`000?ooooooo`06oooo00<0003oooooool01Oooo`80000Boooo000Poooo00<0
003oooooool00_ooo`030000oooooooo0=coool00`000?ooooooo`0/oooo00<0003oooooool00ooo
o`030000oooooooo0=_oool00`000?ooooooo`0@oooo000Ooooo00<0003oool000000oooo`030000
oooooooo0=coool00`000?ooooooo`0[oooo00<0003oool000001?ooo`030000oooooooo0=_oool0
0`000?ooooooo`0@oooo000Ooooo00<0003oool000000oooo`<0003Koooo0P0002goool00`000?oo
o`000004oooo0P000=_oool200004_ooo`007oooo`030000oooo000000?oool00`000?ooooooo`02
oooo0Y6AT@03Ph>3RXZ:RXZ:00:;Rh/00hZ:RXR8R8R8R002PX:200=fMWIlO7alO7`00Zb/[003emOG
clo?clo?00:[Zj/00hb<S7YjNWYjNP02Ng]k00>3Ph=nOWinOWh00WIfMP03N7QhOGemOGem009oOgl0
0ginOWemOGemO@02NWYj00=cLg=/K6a/K6`00VQXJ003JFUYK6a/K6a/009lO7`2X:2P00>f][JUYJFU
YJD00X20P003I6ATGemOGemO009jNWX00i>CThF5QHF5Q@02IfMW0f1PH09DE5@00e9BDW1`L71`L002
QHF500=VIVI9BDU9BDT00VUYJ@03TI6AQXJ6QXJ6009cLg<00hR8R9fMWIfMW@02RHV900=cLg>;Rh^;
Rh/00Y^KV`03LG5aADE5ADE5009HF5P00galO7]kNg]kN`02NWYj00>MWIfh^;Rh^;P00YjNWP03MWIf
JVYZJVYZ009bLW800h>3PhV9RHV9R@02LW9b00=HF5QGEeMGEeL00VUYJ@03OGemQhN7QhN7009hN7P0
0fATI61PH61PH003I6AT0UaLG099BDT00d92@UYJFUYJFP02OGem00>CTi>EUIFEUID00XB4Q003KFe]
HF5QHF5Q009VIVH2O7al00>BTY:GUiNGUiL00YBDU003UYJFU9BDU9BD00:6QXH00g9bLV5QHF5QH@02
FUYJ00=WIfMhN7QhN7P00WQhN003MgMgQHF5QHF500:=SHd00gUiNF1PH61PH002G5aL00=TI6AZJVYZ
JVX00Vm_K`03Ng]kOgmoOgmo009[Jf/00fMWIinOWinOW`02d=3@00>c/k>ATI6ATI400[fm_@03jn_[
bLW9bLW900Coool00`000?ooooooo`0[oooo00<0003oool000001?ooo`040000oooooooooooo0WMg
M`03QhN7QHF5QHF500:7QhL5RHV900><S8amOGemOGd00/O7a`03X:2PYjNWYjNW00;:b/X00g5aLHF5
QHF5Q@02QhN700>0P823Ph>3Ph<00XV9R@03R8R8QXJ6QXJ600:6QXH00hN7QhJ6QXJ6QP02QXJ600>:
RXZ>SXj>SXh00i:BTP:ATI42QHF50VUYJ@03d=3@I6ATI6AT009nOWh00hj>SXV9RHV9R@02JVYZ00=@
D51MGEeMGEd00WUiN@03Q8B4QHF5QHF500::RXX00h>3Pf=SHf=SH`02aLG500=SHf=lO7alO7`00VQX
J003DE5AJ6QXJ6QX00:8R8P00hB4Q7IfMWIfMP03OWin0UUIF@8o?cl00f=SHi2@T92@T002SXj>00=l
O7b4Q8B4Q8@00XN7Q`03JFUYCdm?Cdm?009KFe/00g5aLG1`L71`L002HV9R00?>c/k?clo?cll00W5a
L@03SHf=SXj>SXj>009mOGd00fUYJF5QHF5QH@02L71`00>7QhN?Shn?Shl00Xb<S003R8R8QhN7QhN7
00:>SXh00hn?SgemOGemO@02gmoO00=JFUYLG5aLG5`00VIVIP03Lg=cMgMgMgMg009eMGD2Kfm_00=^
KVikNg]kNg/00XJ6QP03OgmoM7AdM7Ad009`L7000gMgMhF5QHF5Q@02TY:B00>@T92:RXZ:RXX00X^;
R`03RHV9NGUiNGUi009^KVh00g]kNhf=SHf=S@02SXj>00>8R8R6QXJ6QXH00XJ6QP>1PH43TI6A0V1P
H0:^[Zh00lG5aFQXJ6QXJ002_kno00>LW9bm_Kfm_Kd01?ooo`030000oooooooo013oool001ooool0
0`000?ooo`000003oooo00<0003oooooool00_ooo`:ATI400h>3PhZ:RXZ:RP02Rh^;00>:RXZ8R8R8
R8P00X:2PP03MWIfO7alO7al00:/[:`00mOGelo?clo?c`02Zj^[00><S8ajNWYjNWX00W]kN`03Ph>3
OWinOWin009fMWH00gQhN7emOGemO@02Ogmo00=nOWimOGemOGd00WYjNP03Lg=cK6a/K6a/009XJ6P0
0fUYJFa/K6a/K002O7al0Z2PX003][JfYJFUYJFU00:0P8000fATI5mOGemOG`02NWYj00>CTi>5QHF5
QHD00VMWI`=PH602E5AD00=BDU9`L71`L7000XF5Q@03IVIVBDU9BDU9009YJFT00i6ATHJ6QXJ6QP02
Lg=c00>8R8RMWIfMWId00XV9R@03Lg=cRh^;Rh^;00:KVi/00g5aLDE5ADE5A@02F5QH00=lO7akNg]k
Ng/00WYjNP03WIfM^;Rh^;Rh00:NWYh00gIfMVYZJVYZJP02LW9b00>3Ph>9RHV9RHT00W9bLP03F5QH
EeMGEeMG009YJFT00gemOHN7QhN7Q`02N7Qh00=TI6APH61PH6000fATI09LG5`2BDU900=2@T9JFUYJ
FUX00WemO@03Ti>CUIFEUIFE00:4Q8@00fe]KF5QHF5QH@02IVIV0WalO003TY:BUiNGUiNG00:DU9@0
0iJFUYBDU9BDU002QXJ600=bLW9QHF5QHF400UYJFP03IfMWN7QhN7Qh009hN7P00gMgMhF5QHF5Q@02
SHf=00=iNGUPH61PH6000UaLG003I6ATJVYZJVYZ009_Kfl00g]kNgmoOgmoO`02Jf][00=WIfNOWinO
Wil00]3@d003/k>cTI6ATI6A00:m_Kd00n_[jlW9bLW9b@04oooo00<0003oooooool0:oooo`030000
oooo000000Coool010000?ooooooooooo`9gMgL00hN7QhF5QHF5Q@02QhN71HV9R@03S8b<OGemOGem
00;7alL00j2PX:NWYjNWY`02b/[:00=aLG65QHF5QHD00XN7Q`03P820Ph>3Ph>300:9RHT00hR8R8J6
QXJ6QP02QXJ600>7QhN6QXJ6QXH00XJ6QP03RXZ:SXj>SXj>00>BTY82TI6A0XF5Q@9YJFT00m3@d6AT
I6ATI002OWin00>>SXj9RHV9RHT00VYZJP03D51@GEeMGEeM009iNGT00hB4Q8F5QHF5Q@02RXZ:00>3
Ph=SHf=SHf<00/G5a@03Hf=SO7alO7al009XJ6P00e5ADFQXJ6QXJ002R8R800>4Q8AfMWIfMWH00gin
OP9IFET2?clo00=SHf>@T92@T9000Xj>SP03O7alQ8B4Q8B400:7QhL00fUYJDm?Cdm?C`02Fe]K00=a
LG5`L71`L7000V9RHP03c/k>clo?clo?009aLG400hf=SHj>SXj>SP02OGem00=YJFUQHF5QHF400W1`
L003QhN7Shn?Shn?00:<S8`00hR8R8N7QhN7Q`02SXj>00>?ShmmOGemOGd00]oOg`03FUYJG5aLG5aL
009VIVH00g=cLgMgMgMgM`02MGEe0Vm_K`03KVi^Ng]kNg]k00:6QXH00gmoOgAdM7AdM002L71`00=g
MgN5QHF5QHD00Y:BTP03T92@RXZ:RXZ:00:;Rh/00hV9RGUiNGUiN@02KVi^00=kNg^=SHf=SHd00Xj>
SP03R8R8QXJ6QXJ600:6QXH3PH610i6AT@9PH602[Zj^00?5aLEXJ6QXJ6P00[no_`03W9bL_Kfm_Kfm
00Coool00`000?ooooooo`0@oooo000Poooo00<0003oooooool00_ooo`030000oooooooo00;oool2
Ng]k00>2PX:CTi>CTi<00YVIV@03V9RHUiNGUiNG00:ATI400h>3PgQhN7QhN002Ng]k00>3Ph>;Rh^;
Rh/00XV9R@03MgMgIfMWIfMW009_Kfl00gemOGinOWinOP02NGUi00=hN7QjNWYjNWX00WalO003OGem
NWYjNWYj009kNg/00hJ6QXj>SXj>SP02RXZ:00=lO7aWIfMWIfL00VMWI`:FUYH00kno_jZZZZZZZP02
P82000=cLg>0P820P8000YVIV@03/;2`]kNg]kNg00:XZ:P00hN7Qg1`L71`L002P82000>FUYJ8R8R8
R8P00WAdM003O7alSHf=SHf=00:FUYH00i6ATG]kNg]kN`02Kfm_00>8R8RSXj>SXj<00Y>CT`03Ogmo
UYJFUYJF00:ZZZX00h^;Rf][Jf][J`02Ph>300>NWYj6QXJ6QXH00Vi^KP03T92@/k>c/k>c00:KVi/0
0galO8b<S8b<S002YjNW00>QXJ6<S8b<S8`00X>3P`03N7QhFe]KFe]K009GEeL00i2@T<?3`l?3``02
[jn_00=nOWiUIFEUIFD00VQXJ003RHV9XJ6QXJ6Q00:6QXH00fQXJ8>3Ph>3P`02Y:BT00>@T91gMgMg
MgL00X^;R`03Y:BTVYZJVYZJ00:7QhL2R8R800>@T92EUIFEUID00YFEU@03T92@QHF5QHF5009jNWX0
0fm_KfEUIFEUI@02H61P00=UIFE/K6a/K6`00Vi^KP03L71`MGEeMGEe009eMGD00fMWIeADE5ADE002
ATI600=5ADEGEeMGEeL00Ve]K@03MWIfLg=cLg=c009SHf<00eeMGGEeMGEeM@02Rh^;00=iNGUVIVIV
IVH00X20P003W9bLT92@T92@00Coool00`000?ooooooo`0/oooo00<0003oooooool00oooo`040000
oooooooooooo0XR8R003RHV9PX:2PX:200:2PX800hB4Q8>3Ph>3P`02Ph>300>5QHF2PX:2PX800WIf
MP03JFUYHV9RHV9R009YJFT00gmoOi>CTi>CT`02T92@00>4Q8B3Ph>3Ph<00XJ6QP03QhN7QXJ6QXJ6
00>5QHD2QhN70XJ6QP03OGemMWIfMWIf009iNGT00hF5QIJFUYJFUP02UIFE0Ve]K@03Bd];dm?Cdm?C
009fMWH00gMgMf1PH61PH002^KVi00>PX:2LW9bLW9`00Zj^[P03EEEEJ6QXJ6QX00;;bl/00jZZZRh^
;Rh^;P02[Zj^00>WYjNNWYjNWYh00Z>SX`03]kNgg=cLg=cL00:0P8000g]kNfYZJVYZJP02i^KV00=X
J6Rj^[Zj^[X00YjNWP03^k^kJVYZJVYZ009ZJVX00f=SHoShn?Shn002TY:B00=bLW;8b<S8b<P00];B
dP03h^;RDU9BDU9B00:a/K400kZj^UUIFEUIF@02JFUY00=gMgN;Rh^;Rh/00XF5Q@03alO7VIVIVIVI
00:][Jd00fEUIH>3Ph>3P`02QXJ600=XJ6S6a/K6a/H00UYJFP03Kfm_eMGEeMGE0099BDT00f9RHWem
OGemO@02i>CT00?9bLUBDU9BDU800V5QH@;Ti>@00g5aLGalO7alO002Ph>300>6QXJ5QHF5QHD00X>3
P`03Q8B4RHV9RHV900:?Shl00hj>SXb<S8b<S002S8b<00>;Rh^6QXJ6QXH00X>3P`03RXZ:U9BDU9BD
00:KVi/00iRHV8^;Rh^;R`02OWin00=lO7b4Q8B4Q8@00Y>CT`03VIVIQ8B4Q8B4009aLG400ginOX^;
Rh^;R`02MGEe00=PH61_Kfm_Kfl01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02
oooo0VATI003Ng]kSHf=SHf=00:GUiL00i^KViZJVYZJVP02U9BD00>:RXYeMGEeMGD00U1@D003=SHf
@T92@T92009KFe/00fEUIFUYJFUYJ@02LG5a00=hN7QlO7alO7`00WinOP03O7alNg]kNg]k009nOWh0
0h20P7YjNWYjNP02O7al00>CTi>ZZZZZZZX00Zj^[P03VYZJJ6QXJ6QX009>CTh2OWin00>c/k>RXZ:R
XZ800galO0:ATI42XZ:R00>d];C?clo?cll00]KFeP03[jn_Shn?Shn?00:[Zj/00lS8b:2PX:2PX002
MWIf00>EUIFo_kno_kl00[Bd]003TI6AMWIfMWIf009_Kfl00hB4Q9ZJVYZJVP02Shn?00>0P82BTY:B
TY800ZVYZ@03XJ6QU9BDU9BD00:QXJ400jZZZXn?Shn?S`02MWIf00>:RXZLW9bLW9`00WUiN@03HV9R
VIVIVIVI00;De=@00kfm_I2@T92@T002VYZJ00>SXj=bLW9bLW800UADE003UYJFgMgMgMgM00;>c/h0
0iVIVGQhN7QhN002Ng]k00>][JgJf][Jf]X00/30`003V9RH[:b/[:b/00:m_Kd00hB4Q5MGEeMGE`02
RHV90lk>cP:YZJT2SHf=00=mOGenOWinOWh00XR8R003QXJ6OWinOWin009kNg/00gYjNWIfMWIfMP02
M7Ad00=hN7QjNWYjNWX00W=cL`=/K6`2KVi^00=ZJVYRHV9RHV800UMGE`03E5ADHf=SHf=S009fMWH0
0gYjNWAdM7AdM002Jf][00=PH61ADE5ADE400TQ8B003BDU9Bd];Bd];0092@T800chn?Ta<C4a<C004
oooo00<0003oooooool0<_ooo`040000oooooooooooo0Y>CT`03RXZ:Q8B4Q8B400N1PH400h20P8J6
QXJ6QP02VIVI00>WYjNNWYjNWYh00Xj>SP03SHf=T92@T92@00:=SHd00hR8R8F5QHF5Q@02Q8B400>5
QHF7QhN7QhL00XB4Q003Ph>3R8R8R8R800:7QhL00gAdM=_Kfm_Kf`02G5aL00=[Jf^@T92@T9000Z>S
X`9iNGT00dY:B/k>c/k>cP02KVi^00=UIFG2`/;2`/800Z^[Z`03UYJFPX:2PX:200:2PX800jJVY[jn
_[jn_P02VYZJ00=aLG60P820P8000YNGU`03OGemHF5QHF5Q009gMgL00b`/;5IFEUIFEP02L71`00=^
KVkIfMWIfMT00UiNGP03d=3@<c<c<c<c00:>SXh00i^KVkRh^;Rh^002a<C400=EEEEaLG5aLG400X>3
P`03KFe]EUIFEUIF009[Jf/00gMgMdA4A4A4A002S8b<00<Z:RYFEUIFEUH00]3@d003DE5ALg=cLg=c
009nOWh00c`l?7AdM7AdM002Q8B400>k^k_Shn?Shn<00W1`L003`<30UIFEUIFE00:TY:@00dY:B[Ng
]kNg]`02/k>c00=bLW:LW9bLW9`00W5aL@03<S8bYZJVYZJV00;2`/82IfMW00=oOgn9RHV9RHT00XV9
R@03S8b<SXj>SXj>00:;Rh/00hJ6QXB4Q8B4Q002PX:200=mOGeiNGUiNGT00WemO@03PX:2P820P820
009mOGd00g]kNgemOGemO@03PH610WIfMP9ZJVX00f][JgEeMGEeM@02PH6100>?ShnNWYjNWYh00ZJV
YP03XZ:RW9bLW9bL00:PX:000j>SXifMWIfMW@04oooo00<0003oooooool04?ooo`009Oooo`030000
oooooooo00;oool2I6AT00=kNg^=SHf=SHd00YNGU`03Vi^KVYZJVYZJ00:DU9@00hZ:RWEeMGEeM@02
D51@00<f=SI2@T92@T800U]KF`03IFEUJFUYJFUY009aLG400gQhN7alO7alO002OWin00=lO7akNg]k
Ng/00WinOP03P820NWYjNWYj009lO7`00i>CTjZZZZZZZP02[Zj^00>JVYYXJ6QXJ6P00Ti>CP9nOWh0
0k>c/j:RXZ:RXP03O7al0Y6AT@:RXZ800kBd]<o?clo?c`02e]KF00>_[jn?Shn?Shl00Z^[Z`03b<S8
X:2PX:2P009fMWH00iFEUKno_kno_`02];Bd00>ATI5fMWIfMWH00Vm_K`03Q8B4VYZJVYZJ00:?Shl0
0h20P9:BTY:BTP02ZJVY00>QXJ6DU9BDU9@00Z6QX@03ZZZZShn?Shn?009fMWH00hZ:RYbLW9bLW002
NGUi00=RHV:IVIVIVIT00]CDe003_KfmT92@T92@00:JVYX00j>SXg9bLW9bLP02E5AD00>FUYKMgMgM
gMd00/k>cP03VIVIN7QhN7Qh009kNg/00jf][M[Jf][JfP02`<3000>HV9R/[:b/[:`00[fm_@03Q8B4
EeMGEeMG00:9RHT3c/k>0ZVYZ@:=SHd00gemOGinOWinOP02R8R800>6QXInOWinOWh00W]kN`03NWYj
MWIfMWIf009dM7@00gQhN7YjNWYjNP02Lg=c0fa/K09^KVh00fYZJV9RHV9RHP02EeMG00=DE5ASHf=S
Hf<00WIfMP03NWYjM7AdM7Ad009[Jf/00f1PH55ADE5AD@02B4Q800=9BDU;Bd];Bd/00T92@P03?Shn
C4a<C4a<00Coool00`000?ooooooo`0boooo00@0003oooooooooool2Ti>C00>:RXZ4Q8B4Q8@01h61
P@03P820QXJ6QXJ600:IVIT00jNWYijNWYjNWP02SXj>00>=SHf@T92@T9000Xf=S@03R8R8QHF5QHF5
00:4Q8@00hF5QHN7QhN7Q`02Q8B400>3Ph>8R8R8R8P00XN7Q`03M7Adfm_Kfm_K009LG5`00f][Ji2@
T92@T002Xj>S0WUiN@03BTY:c/k>c/k>009^KVh00fEUIL;2`/;2`P02Zj^[00>FUYJ2PX:2PX800X:2
PP03YZJV_[jn_[jn00:JVYX00g5aLH20P820P002UiNG00=mOGeQHF5QHF400WMgM`03;2`/EUIFEUIF
009`L7000fi^K]WIfMWIf@02GUiN00?@d=0c<c<c<c<00Xj>SP03Vi^K^;Rh^;Rh00;4a<@00eEEEG5a
LG5aL@02Ph>300=]KFeFEUIFEUH00V][J`03MgMgA4A4A4A400:<S8`00bXZ:UIFEUIFEP02d=3@00=A
DE5cLg=cLg<00WinOP03?3`lM7AdM7Ad00:4Q8@00k^k^n?Shn?Sh`02L71`00?0`<2EUIFEUID00ZBT
Y003BTY:]kNg]kNg00:c/k<00g9bLYbLW9bLW002LG5a00<b<S:VYZJVYZH00/;2`P9WIfL00gmoOhV9
RHV9R@02RHV900><S8b>SXj>SXh00X^;R`03QXJ6Q8B4Q8B400:2PX800gemOGUiNGUiN@02OGem00>2
PX:0P820P8000WemO@03Ng]kOGemOGem00>1PH42MWIf0VYZJP03Jf][MGEeMGEe00:1PH400hn?SijN
WYjNWP02YZJV00>RXZ:LW9bLW9`00Z2PX003Xj>SWIfMWIfM00Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`=aLG42LW9b0WUiN@03P820PH61PH61009mOGd00gEeMGAdM7AdM002
RHV900>EUIEdM7AdM7@00UYJFP03NGUiX:2PX:2P00:JVYX00h:2PWalO7alO002Ogmo00>0P821PH61
PH400XB4Q003Ph>3OWinOWin009mOGd00hJ6QYBDU9BDU002Xj>S00>NWYibLW9bLW800UADE09iNGT0
0jJVYYZJVYZJVP02MWIf0fATI09aLG400hF5QI:BTY:BTP02UIFE00>BTY::RXZ:RXX00X61P@03P820
TI6ATI6A00:OWil00iFEUHB4Q8B4Q002PX:200>6QXJ:RXZ:RXX00XR8R003PH61MgMgMgMg009_Kfl0
0g5aLH61PH61P@02Rh^;00=lO7aZJVYZJVX00Vi^KP03P820S8b<S8b<00:DU9@00i^KVhb<S8b<S002
EeMG00<c<c=EEEEEEED00X^;R`03UYJFTI6ATI6A00:SXj<00jRXZ820P820P002FUYJ00=SHf>1PH61
PH400Y:BTP03UiNGU9BDU9BD00:>SXh00i2@T9FEUIFEU@02UYJF00>EUIFKVi^KVi/00YNGU`03MWIf
HV9RHV9R009oOgl00jBTY9jNWYjNWP02P8200VUYJ@03GemOJf][Jf][00:0P8000hZ:RX^;Rh^;R`02
S8b<00>7QhMkNg]kNg/00WQhN003TI6AYZJVYZJV00:GUiL00h>3Phf=SHf=S@02XJ6Q00>UYJFTY:BT
Y:@00ZRXZ003[:b/[Zj^[Zj^00:^[Zh00jb/[9nOWinOW`02PH6100=]KFenOWinOWh00YFEU@03TI6A
OgmoOgmo009aLG400fYZJV][Jf][J`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WYj
NP03Q8B4SHf=SHf=00:?Shl5SHf=00>>SXj5QHF5QHD00V][J`03G5aLMWIfMWIf00:@T9000gemOF9R
HV9RHP02K6a/00>2PX:9RHV9RHT01HR8R0:5QHD00hJ6QXZ:RXZ:RP02RXZ:00>1PH5cLg=cLg<00V9R
HP03f][JOgmoOgmo00:ATI42KVi^00>m_Kg3`l?3`l<00VATI003Kfm_K6a/K6a/009OGel00dm?CdI6
ATI6AP02_[jn0dM7A`93@d<00jf][I6ATI6AT@02Ng]k00>0P82ATI6ATI400YZJVP03XZ:R[jn_[jn_
00:o_kl00eQHF6=SHf=SH`02H61P00=>CTjYZJVYZJT00YVIV@03<c<cE5ADE5AD009UIFD00fMWIm_K
fm_Kf`02EeMG00=;Bd_;bl_;bl/00WQhN003Ti>CMWIfMWIf00;5aLD00l30`<[:b/[:bP02ATI600>k
^k_Cdm?Cdm<00Ve]K@03dm?C];Bd];Bd008a<C400cLg=dM7AdM7A`02EeMG00=JFUYEEEEEEED00UAD
E003clo?EEEEEEEE009PH6000h:2PYFEUIFEU@02NGUi00?>c/iCDe=CDe<00VQXJ0:0P8000i2@T8n?
Shn?S`02QhN700>4Q8B6QXJ6QXH00XF5Q@03QXJ6S8b<S8b<00:7QhL00f][Jl[:b/[:bP02De=C00?D
e=A;Bd];Bd/00[2`/003ZZZZZj^[Zj^[008`<303Z:RX0ZVYZ@03[:b/^KVi^KVi009NGUh00gEeMFa/
K6a/K002Fe]K00=LG5aVIVIVIVH00Va/K003LG5aMGEeMGEe00Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`=aLG42LW9b0WUiN@03P820PH61PH61009mOGd00gEeMGAdM7AdM002
RHV900>EUIEdM7AdM7@00UYJFP03NGUiX:2PX:2P00:JVYX00h:2PWalO7alO002Ogmo00>0P821PH61
PH400XB4Q003Ph>3OWinOWin009mOGd00hJ6QYBDU9BDU002Xj>S00>NWYibLW9bLW800UADE09iNGT0
0jJVYYZJVYZJVP02MWIf0fATI09aLG400hF5QI:BTY:BTP02UIFE00>BTY::RXZ:RXX00X61P@03P820
TI6ATI6A00:OWil00iFEUHB4Q8B4Q002PX:200>6QXJ:RXZ:RXX00XR8R003PH61MgMgMgMg009_Kfl0
0g5aLH61PH61P@02Rh^;00=lO7aZJVYZJVX00Vi^KP03P820S8b<S8b<00:DU9@00i^KVhb<S8b<S002
EeMG00<c<c=EEEEEEED00X^;R`03UYJFTI6ATI6A00:SXj<00jRXZ820P820P002FUYJ00=SHf>1PH61
PH400Y:BTP03UiNGU9BDU9BD00:>SXh00i2@T9FEUIFEU@02UYJF00>EUIFKVi^KVi/00YNGU`03MWIf
HV9RHV9R009oOgl00jBTY9jNWYjNWP02P8200VUYJ@03GemOJf][Jf][00:0P8000hZ:RX^;Rh^;R`02
S8b<00>7QhMkNg]kNg/00WQhN003TI6AYZJVYZJV00:GUiL00h>3Phf=SHf=S@02XJ6Q00>UYJFTY:BT
Y:@00ZRXZ003[:b/[Zj^[Zj^00:^[Zh00jb/[9nOWinOW`02PH6100=]KFenOWinOWh00YFEU@03TI6A
OgmoOgmo009aLG400fYZJV][Jf][J`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WYj
NP03Q8B4SHf=SHf=00:?Shl5SHf=00>>SXj5QHF5QHD00V][J`03G5aLMWIfMWIf00:@T9000gemOF9R
HV9RHP02K6a/00>2PX:9RHV9RHT01HR8R0:5QHD00hJ6QXZ:RXZ:RP02RXZ:00>1PH5cLg=cLg<00V9R
HP03f][JOgmoOgmo00:ATI42KVi^00>m_Kg3`l?3`l<00VATI003Kfm_K6a/K6a/009OGel00dm?CdI6
ATI6AP02_[jn0dM7A`93@d<00jf][I6ATI6AT@02Ng]k00>0P82ATI6ATI400YZJVP03XZ:R[jn_[jn_
00:o_kl00eQHF6=SHf=SH`02H61P00=>CTjYZJVYZJT00YVIV@03<c<cE5ADE5AD009UIFD00fMWIm_K
fm_Kf`02EeMG00=;Bd_;bl_;bl/00WQhN003Ti>CMWIfMWIf00;5aLD00l30`<[:b/[:bP02ATI600>k
^k_Cdm?Cdm<00Ve]K@03dm?C];Bd];Bd008a<C400cLg=dM7AdM7A`02EeMG00=JFUYEEEEEEED00UAD
E003clo?EEEEEEEE009PH6000h:2PYFEUIFEU@02NGUi00?>c/iCDe=CDe<00VQXJ0:0P8000i2@T8n?
Shn?S`02QhN700>4Q8B6QXJ6QXH00XF5Q@03QXJ6S8b<S8b<00:7QhL00f][Jl[:b/[:bP02De=C00?D
e=A;Bd];Bd/00[2`/003ZZZZZj^[Zj^[008`<303Z:RX0ZVYZ@03[:b/^KVi^KVi009NGUh00gEeMFa/
K6a/K002Fe]K00=LG5aVIVIVIVH00Va/K003LG5aMGEeMGEe00Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`:>SXh00g5aLE]KFe]KF`02G5aL00=VIVI[Jf][Jf/00VYZJP03HV9R
Lg=cLg=c00;1`L400oCdm;Bd];Bd]002JVYZ00>>SXk:b/[:b/X00[Zj^P03SHf=P820P82000:2PX80
0hJ6QX^;Rh^;R`02S8b<00>8R8R6QXJ6QXH00X61P@03M7AdKVi^KVi^009lO7`00hV9RGemOGemO@02
L71`0W]kN`03S8b<TI6ATI6A00:0P8000eEEEC4a<C4a<@02?Cdm00=EEEE=CDe=CDd00TE5A@03IFEU
N7QhN7Qh0096ATH00bHV9W5aLG5aL@02^KVi00>9RHU0@410@4000TY:BP03N7QhTi>CTi>C00:EUID0
0ginOV1PH61PH002FUYJ00=UIFEaLG5aLG400W5aL@03G5aLA4A4A4A4008m?Cd00e9BDX>3Ph>3P`02
[:b/00>WYjMnOWinOWh00TU9B@038R8R7QhN7QhN008j>SX00fQXJ8n?Shn?S`02VIVI00>>SXj4Q8B4
Q8@00Ve]K@03?3`l8b<S8b<S009@D5000hf=SJ:RXZ:RXP02SXj>00=MGEdj>SXj>SX00U=CD`03Ng]k
MWIfMWIf009SHf<00f][JgMgMgMgM`02L71`00=QHF5EEEEEEED00Ti>CP9@D5000eUIFFATI6ATI002
Lg=c00>6QXJDU9BDU9@00YZJVP03UIFEPH61PH61009lO7`00inOWl71`L71`@02/K6a00>HV9RYZJVY
ZJT00/C4a003`l?3`<30`<3000;Hf=P00nc/k=[Jf][JfP02`/;200?;bl_:b/[:b/X00Y2@T003KFe]
[Jf][Jf]00;emOD00m_KfjBTY:BTY002XZ:R00>`/;2VYZJVYZH01?ooo`030000oooooooo03;oool0
10000?ooooooooooo`9@D5000g9bLXj>SXj>SP02UIFE1I6AT@03UIFEPX:2PX:200:h^;P00h^;Rkno
_kno_`02QHF500=/K6bi^KVi^KT00/c<c003NWYjRXZ:RXZ:00:;Rh/00hZ:RXN7QhN7Q`02QhN70hV9
R@::RXX00i2@T8n?Shn?S`02Ng]k0fQXJ09ZJVX2FEUI00=4A4@m?Cdm?Cd00/C4a003M7AdVYZJVYZJ
00:JVYX00hb<S9>CTi>CT`02UIFE00=cLg?De=CDe=@00WYjNP03S8b<AdM7AdM7009nOWh00j2PX5iN
GUiNGP02cLg=00>XZ:RHV9RHV9P00YfMW@03]kNgEUIFEUIF00;?cll00d92@ZNWYjNWY`02Y:BT00=3
@d?Ng]kNg]h00WYjNP03MGEebLW9bLW900:TY:@00j:RX/30`<30`002LW9b00>EUIFLW9bLW9`00XR8
R003IFEU`<30`<3000:h^;P00dA4A;jn_[jn_P02Cdm?00=_Kfn0P820P8000]WIf@03/;2`Zj^[Zj^[
00;7alL00gmoOj>SXj>SX`02TY:B00=fMWIoOgmoOgl00Y:BTP03SHf=PX:2PX:200:1PH400hJ6QXV9
RHV9R@04Rh^;0hV9R@:7QhL00h:2PWinOWinOP02Ogmo00>5QHFBTY:BTY800Xj>SP03IFEU/[:b/[:b
008c<c<00jb/[8f=SHf=S@02KVi^00=`L71kNg]kNg/00W=cL`03Jf][OGemOGem00:>SXh3PX:20[Jf
]P03HV9R[Jf][Jf]009gMgL00hZ:R[6a/K6a/@02=CDe00>QXJ6^[Zj^[Zh01?ooo`030000oooooooo
013oool002Goool200000oooo`:RXZ800hB4Q6=SHf=SH`02HF5Q00=_KfmgMgMgMgL00WQhN003L71`
Kfm_Kfm_00:8R8P00iZJVX:2PX:2PP02JFUY00=oOgnOWinOWil00YnOW`03TI6ASHf=SHf=00:?Shl0
0i>CTiJFUYJFUP02TY:B00>>SXjBTY:BTY800Y2@T003NGUiH61PH61P009FEUH00f5QHH61PH61P@02
U9BD0WAdM003FUYJQXJ6QXJ600:ZZZX00gEeMC@d=3@d=002?3`l00=MGEeHF5QHF5P00Te=C@03HV9R
KFe]KFe]0098B4P00bh^;UaLG5aLG002T92@00>2PX9OGemOGel00UeMG@03JVYZKfm_Kfm_009cLg<0
0g]kNgemOGemO@02MGEe00=`L71gMgMgMgL00X:2PP03RHV9PX:2PX:2009WIfL00eUIFGUiNGUiN@02
W9bL00>ATI5bLW9bLW800V=SH`03G5aLDE5ADE5A009CDe<00g=cLhb<S8b<S002NGUi00=TI6AjNWYj
NWX00Xb<S003IVIVADE5ADE5009YJFT00iFEUHf=SHf=S@02IfMW00=4A4@g=cLg=cL00U5AD@03L71`
JFUYJFUY009HF5P00f=SHfi^KVi^KP02GEeM00=9BDU:BTY:BTX00U]KF`9iNGT00hV9RG5aLG5aL@02
EEEE00=NGUijNWYjNWX00Y>CT`03X:2PV9RHV9RH00:;Rh/00i6ATIZJVYZJVP02U9BD00>:RXZ>SXj>
SXh00Xb<S003Kfm_GemOGemO00:9RHT00jn_[hV9RHV9R@02I6AT00>LW9c;bl_;bl/00XJ6QP03A4A4
R8R8R8R800;EeMD00jFUYE]KFe]KF`02HV9R00><S8bSXj>SXj<00oooo`80000doooo00@0003ooooo
ooooool2ZZZZ00?<c<agMgMgMgL00X20P003NWYjN7QhN7Qh009jNWX00h61PH20P820P002Jf][00=K
Fe]`L71`L7000XN7Q`03N7QhHf=SHf=S009YJFT00gUiNH61PH61P@03Q8B40X>3P`:6QXH00hR8R861
PH61P@02OWin00>:RXZEUIFEUID00Y6AT@03O7ald=3@d=3@00:d];@2a<C400?AdM6[Zj^[Zj/00Y:B
TP03De=CW9bLW9bL00:XZ:P00iVIVIbLW9bLW002Vi^K00=lO7aWIfMWIfL00_[jnP03UIFEKfm_Kfm_
00:l_;`00kno_eIFEUIFEP02C4a<00<h>3P_;bl_;bl00R/[:`03WinOWIfMWIfM00>PX:02UiNG0hn?
S`:NWYh2_[jn00=FEUHl?3`l?3`00YJFUP038R8R>c/k>c/k00;5aLD00eQHF6UYJFUYJ@02Jf][00=B
DU8k>c/k>c/00TE5A@03DU9B/k>c/k>c00:PX:000d=3@eiNGUiNGP02_kno00<X:2Rc/k>c/k<00VEU
I@03SXj>YJFUYJFU00:IVIT00hJ6QXn?Shn?S`02WIfM00>@T921PH61PH400XR8R003TI6ARXZ:RXZ:
009hN7P2f=SH00=FEUI`L71`L7000Y6AT@03V9RHSXj>SXj>00:4Q8@00h20P8J6QXJ6QP02R8R800=f
MWKBd];Bd]800T51@@03Y:BTQHF5QHF5009iNGT00iFEUKBd];Bd]002YjNW00>HV9Rk^k^k^k/00UQH
F0038B4QKVi^KVi^00:ZZZX00fm_KkZj^[Zj^P02P82000>VYZKNg]kNg]h00UYJFP03/;2`XJ6QXJ6Q
00?oool200004_ooo`009Oooo`030000oooooooo00;oool2XZ:R00>4Q8ASHf=SHf<00V5QH@03Kfm_
MgMgMgMg009hN7P00g1`L6m_Kfm_K`02R8R800>JVYZ2PX:2PX800VUYJ@03OgmoWinOWinO00:OWil0
0i6ATHf=SHf=S@02Shn?00>CTi>FUYJFUYH00Y:BTP03SXj>TY:BTY:B00:@T9000gUiNF1PH61PH002
EUIF00=QHF61PH61PH400YBDU09dM7@00eYJFXJ6QXJ6QP02ZZZZ00=eMGDd=3@d=3@00S`l?003GEeM
F5QHF5QH009=CDd00f9RHVe]KFe]K@02B4Q800<^;RiLG5aLG5`00Y2@T003PX:2GemOGemO009MGEd0
0fYZJVm_Kfm_K`02Lg=c00=kNg]mOGemOGd00WEeM@03L71`MgMgMgMg00:2PX800hV9RH:2PX:2PP02
IfMW00=IFEUiNGUiNGT00YbLW003TI6ALW9bLW9b009SHf<00eaLG55ADE5AD@02De=C00=cLg><S8b<
S8`00WUiN@03I6ATNWYjNWYj00:<S8`00fIVITE5ADE5A@02JFUY00>EUIF=SHf=SHd00VMWI`03A4A4
=cLg=cLg009ADE400g1`L6UYJFUYJ@02F5QH00=SHf=^KVi^KVh00UeMG@03BDU9BTY:BTY:009KFe/2
NGUi00>9RHUaLG5aLG400UEEE@03GUiNNWYjNWYj00:CTi<00j2PX9RHV9RHV002Rh^;00>ATI6JVYZJ
VYX00YBDU003RXZ:SXj>SXj>00:<S8`00fm_KemOGemOG`02RHV900>_[jn9RHV9RHT00VATI003W9bL
bl_;bl_;00:6QXH00dA4A8R8R8R8R002eMGE00>UYJEKFe]KFe/00V9RHP03S8b<Xj>SXj>S00Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2ZZZZ00?<c<agMgMgMgL00X20P003NWYjN7QhN7Qh
009jNWX00h61PH20P820P002Jf][00=KFe]`L71`L7000XN7Q`03N7QhHf=SHf=S009YJFT00gUiNH61
PH61P@03Q8B40X>3P`:6QXH00hR8R861PH61P@02OWin00>:RXZEUIFEUID00Y6AT@03O7ald=3@d=3@
00:d];@2a<C400?AdM6[Zj^[Zj/00Y:BTP03De=CW9bLW9bL00:XZ:P00iVIVIbLW9bLW002Vi^K00=l
O7aWIfMWIfL00_[jnP03UIFEKfm_Kfm_00:l_;`00kno_eIFEUIFEP02C4a<00<h>3P_;bl_;bl00R/[
:`03WinOWIfMWIfM00>PX:02UiNG0hn?S`:NWYh2_[jn00=FEUHl?3`l?3`00YJFUP038R8R>c/k>c/k
00;5aLD00eQHF6UYJFUYJ@02Jf][00=BDU8k>c/k>c/00TE5A@03DU9B/k>c/k>c00:PX:000d=3@eiN
GUiNGP02_kno00<X:2Rc/k>c/k<00VEUI@03SXj>YJFUYJFU00:IVIT00hJ6QXn?Shn?S`02WIfM00>@
T921PH61PH400XR8R003TI6ARXZ:RXZ:009hN7P2f=SH00=FEUI`L71`L7000Y6AT@03V9RHSXj>SXj>
00:4Q8@00h20P8J6QXJ6QP02R8R800=fMWKBd];Bd]800T51@@03Y:BTQHF5QHF5009iNGT00iFEUKBd
];Bd]002YjNW00>HV9Rk^k^k^k/00UQHF0038B4QKVi^KVi^00:ZZZX00fm_KkZj^[Zj^P02P82000>V
YZKNg]kNg]h00UYJFP03/;2`XJ6QXJ6Q00Coool00`000?ooooooo`0@oooo000Uoooo00<0003ooooo
ool00_ooo`:UYJD00iBDU7UiNGUiN@02N7Qh00>7QhN>SXj>SXh00Xf=S@03RXZ:MgMgMgMg009;Bd/0
0bh^;T=3@d=3@`02IVIV00=[Jf]WIfMWIfL00WIfMP03RHV9TI6ATI6A00>BTY82T92@0X^;R`03S8b<
UYJFUYJF00:HV9P00hF5QFQXJ6QXJ002C4a<00=>CTj9RHV9RHT00[2`/09`L7000cHf=W]kNg]kN`02
b/[:00>SXj=PH61PH6000V=SH`03PX:2Rh^;Rh^;00:7QhL00gemOG5aLG5aL@02KVi^00=]KFeRHV9R
HV800V9RHP03PX:2W9bLW9bL00:=SHd00fa/K5IFEUIFEP02F5QH00=kNg^MWIfMWId00YZJVP03R8R8
QhN7QhN700:FUYH00k:b//30`<30`002XJ6Q00=jNWYhN7QhN7P00X61P@03MgMgLW9bLW9b00:9RHT0
0j:RXYjNWYjNWP02TI6A00>CTi><S8b<S8`00VEUI@03C4a<LW9bLW9b00:QXJ400ijNWXf=SHf=S@02
Vi^K00>QXJ5iNGUiNGT00Tm?C`03D51@IfMWIfMW009gMgL00gemOGMgMgMgM`02K6a/0f][J`9VIVH0
0fATI6IVIVIVIP02NGUi0ZNWY`03_[jnS8b<S8b<009=CDd00dQ8B6EUIFEUI@02PH6100>FUYJQXJ6Q
XJ400YNGU`03N7QhHF5QHF5Q009[Jf/00g]kNg5aLG5aL@02D51@00<P820820P820P00SHf=P03H61P
;bl_;bl_00892@T00f9RH[Jf][Jf]P02Lg=c00<Q8B5IFEUIFET00YZJVP03Fe]K2PX:2PX:008N7Qh0
0f1PH92@T92@T004oooo00<0003oooooool0<_ooo`040000oooooooooooo0RHV9P03?CdmGEeMGEeM
009UIFD00eiNGUaLG5aLG002GemO00=RHV9aLG5aLG400YFEU@03[Zj^X:2PX:2P00:8R8P00h^;RiBD
U9BDU002SHf=00>1PH5nOWinOWh00WmoO`03PH61Ph>3Ph>300:5QHD00h:2PWIfMWIfMP02Kfm_00=g
MgN3Ph>3Ph<00Xf=S@03OWin@410@41000:<S8`2?3`l00=TI6BTY:BTY:@00V][J`03WYjNMGEeMGEe
00::RXX00ginOWEeMGEeM@02JVYZ00=PH61NGUiNGUh00V1PH003J6QXN7QhN7Qh009hN7P00eEEEJVY
ZJVYZ@02Xj>S00>^[Zje]KFe]KD00Zj^[P03SXj>LG5aLG5a009dM7@00h>3PhJ6QXJ6QP02OGem00=Y
JFURHV9RHV800WmoO`03X:2PXJ6QXJ6Q00:GUiL00ifMWJ>SXj>SX`02UYJF00>;Rh^GUiNGUiL00ZNW
Y`03Y:BTYJFUYJFU00:n_[h00e9BDZVYZJVYZ@02PH6100>5QHFFUYJFUYH00Xn?S`03TY:B@d=3@d=3
009aLG400galO7MgMgMgM`02M7Ad00=fMWIlO7alO7`00X61P@03OGemMWIfMWIf009cLg<00g1`L6YZ
JVYZJP02F5QH0ZRXZ003UYJFBDU9BDU900:5QHD00iRHV96ATI6AT@02RXZ:00>3Ph=mOGemOGd00X20
P003SXj>RXZ:RXZ:009OGel00jJVYXf=SHf=S@02UiNG00==CDehN7QhN7P00Vm_K`03H61PRh^;Rh^;
00:NWYh00kno_g1`L71`L002Z:RX00=kNg]HF5QHF5P00Z>SX`03GUiNW9bLW9bL00:8R8P00e9BDZRX
Z:RXZ004oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2YJFU00>DU9AiNGUi
NGT00WQhN003QhN7SXj>SXj>00:=SHd00hZ:RWMgMgMgM`02Bd];00<^;Ri3@d=3@d<00VIVIP03Jf][
IfMWIfMW009fMWH00hV9RI6ATI6AT@03TY:B0Y2@T0:;Rh/00hb<S9JFUYJFUP02V9RH00>5QHEXJ6QX
J6P00Ta<C003CTi>RHV9RHV900:`/;02L71`00<f=SIkNg]kNg/00/[:bP03Xj>SH61PH61P009SHf<0
0h:2PX^;Rh^;R`02QhN700=mOGeaLG5aLG400Vi^KP03KFe]HV9RHV9R009RHV800h:2PYbLW9bLW002
SHf=00=/K6aFEUIFEUH00UQHF003Ng]kWIfMWIfM00:JVYX00hR8R8N7QhN7Q`02UYJF00>b/[;0`<30
`<000Z6QX@03NWYjN7QhN7Qh00:1PH400gMgMg9bLW9bLP02RHV900>RXZ:NWYjNWYh00Y6AT@03Ti>C
S8b<S8b<009UIFD00da<C79bLW9bLP02XJ6Q00>NWYj=SHf=SHd00Y^KV`03XJ6QNGUiNGUi009?Cdl0
0e1@D6MWIfMWI`02MgMg00=mOGegMgMgMgL00Va/K0=[Jf/2IVIV00=TI6AVIVIVIVH00WUiN@:WYjL0
0kjn_Xb<S8b<S002CDe=00=8B4QUIFEUIFD00X61P@03UYJFXJ6QXJ6Q00:GUiL00gQhN65QHF5QH@02
Jf][00=kNg]aLG5aLG400U1@D003820P20P820P8008f=SH00f1PH2l_;bl_;`022@T900=RHV:f][Jf
][H00W=cL`038B4QFEUIFEUI00:JVYX00e]KF`X:2PX:2P027QhN00=PH62@T92@T9001?ooo`030000
oooooooo03;oool010000?ooooooooooo`8V9RH00cdm?EeMGEeMG@02IFEU00=NGUiLG5aLG5`00UmO
G`03HV9RLG5aLG5a00:EUID00jj^[Z2PX:2PX002R8R800>;Rh^DU9BDU9@00Xf=S@03PH61OWinOWin
009oOgl00h61PH>3Ph>3P`02QHF500>2PX9fMWIfMWH00Vm_K`03MgMgPh>3Ph>300:=SHd00ginOT10
@410@002S8b<0S`l?003I6ATY:BTY:BT009[Jf/00ijNWWEeMGEeM@02RXZ:00=nOWieMGEeMGD00VYZ
JP03H61PGUiNGUiN009PH6000fQXJ7QhN7QhN002N7Qh00=EEEFYZJVYZJT00Z>SX`03[Zj^]KFe]KFe
00:^[Zh00hj>SW5aLG5aL@02M7Ad00>3Ph>6QXJ6QXH00WemO@03JFUYHV9RHV9R009oOgl00j2PX:6Q
XJ6QX@02UiNG00>MWIfSXj>SXj<00YJFUP03Rh^;UiNGUiNG00:WYjL00jBTY:FUYJFUY@02_[jn00=B
DU:YZJVYZJT00X61P@03QHF5UYJFUYJF00:?Shl00i:BTT=3@d=3@`02LG5a00=lO7agMgMgMgL00WAd
M003MWIfO7alO7al00:1PH400gemOGIfMWIfMP02Lg=c00=`L71ZJVYZJVX00UQHF0:XZ:P00iJFUTU9
BDU9B@02QHF500>HV9RATI6ATI400XZ:RP03Ph>3OGemOGem00:0P8000hj>SXZ:RXZ:RP02GemO00>V
YZJ=SHf=SHd00YNGU`03CDe=N7QhN7Qh009_Kfl00f1PH8^;Rh^;R`02WYjN00>o_km`L71`L7000ZRX
Z003Ng]kF5QHF5QH00:SXj<00eiNGYbLW9bLW002R8R800=BDU:XZ:RXZ:P01?ooo`030000oooooooo
013oool002Goool00`000?ooooooo`02oooo0Y2@T003RHV9QXJ6QXJ600:;Rh/00iBDU96ATI6AT@02
SXj>00>FUYJGUiNGUiL00WalO003HF5QHV9RHV9R009^KVh00g=cLgAdM7AdM002M7Ad00=eMGEfMWIf
MWH00WEeM@03KFe]JFUYJFUY009aLG400gemOHB4Q8B4Q002Q8B400>1PH5lO7alO7`00W5aL@03MWIf
XJ6QXJ6Q00:e]KD2MgMg00=0@41_Kfm_Kfl00[Jf]P03^[ZjX:2PX:2P00:GUiL00ifMWJn_[jn_[`02
^k^k00>WYjN?Shn?Shl00YVIV@03YJFUS8b<S8b<009fMWH00hV9RJ>SXj>SX`02X:2P00>>SXj0P820
P8000W]kN`03PX:2T92@T92@00>KVi/2S8b<0WmoO`03QHF5TY:BTY:B00:HV9P00iFEUHV9RHV9R@02
OWin00=lO7b5QHF5QHD00YRHV003ZJVYZZZZZZZZ00:RXZ800inOWiJFUYJFUP02OGem00=/K6aoOgmo
Ogl00YNGU`03UIFESHf=SHf=00:JVYX00j>SXi6ATI6AT@02OWin00>4Q8BFUYJFUYH00ZBTY003YjNW
W9bLW9bL00:>SXh00hR8R8j>SXj>SP02XZ:R00>ZZZZ:RXZ:RXX00W=cL`:IVIT00l71`JNWYjNWY`02
Ng]k00=gMgMoOgmoOgl00W1`L003J6QXQ8B4Q8B400:GUiL00g5aLDm?Cdm?C`02KVi^00>FUYJ=SHf=
SHd00Va/K003DE5ABDU9BDU9009VIVH00gYjNTa<C4a<C002:BTY00=YJFVVYZJVYZH00Vi^KP03<c<c
Lg=cLg=c00:d];@00g9bLR@T92@T9002BTY:00>BTY:OWinOWil01?ooo`030000oooooooo03;oool0
10000?ooooooooooo`:d];@00lK6a]7AdM7Ad@02dm?C00?>c/kAdM7AdM400];BdP03alO7`/;2`/;2
009LG5`00gAdM7]kNg]kN`02OGem00>6QXJ?Shn?Shl00i>CT`:@T902SHf=00>@T92ATI6ATI400XJ6
QP03N7QhjNWYjNWY009/K6`00n;RhVEUIFEUI@02HF5Q00?8b<RGUiNGUiL00WYjNP:TY:@00e=CDjJV
YZJVYP02Lg=c00>1PH6/[:b/[:`00Te=C@03De=C^[Zj^[Zj00:RXZ800j>SXjb/[:b/[002YjNW00>Y
ZJU>CTi>CTh00]kNgP03CDe=XJ6QXJ6Q00:ATI400hn?Si2@T92@T002SXj>00>6QXIkNg]kNg/00WAd
M003MWIfQHF5QHF500:CTi<00i2@T8F5QHF5Q@02Ogmo00>0P827QhN7QhL00Xj>SP03Shn?RXZ:RXZ:
00:0P8000gYjNX20P820P002RXZ:00>;Rh^=SHf=SHd00YfMW@03YJFUTY:BTY:B009nOWh00h:2PXf=
SHf=S@02RXZ:00>;Rh^SXj>SXj<00[fm_@03`/;2@D51@D5100>e]KD2@d=30/C4a003BTY:^k^k^k^k
00:YZJT00j>SXkjn_[jn_P02EeMG0Zf][@03QhN7VYZJVYZJ00;3`l<00eUIFFATI6ATI002PX:200>H
V9R8R8R8R8P00WYjNP03TY:BW9bLW9bL009SHf<00iFEUG]kNg]kN`02QXJ600>UYJG4a<C4a<@00U5A
D@03cLg=MgMgMgMg00:2PX800k:b/W5aLG5aL@02WinO00=RHV:c/k>c/k<00XR8R003AdM7Q8B4Q8B4
009RHV800j6QXIfMWIfMW@04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
Ng]k00=fMWJ6QXJ6QXH00Y>CT`03UIFEQ8B4Q8B4009iNGT00i2@T;>c/k>c/`02b<S800?1`L6HV9RH
V9P00W9bLP03NWYjT92@T92@00:8R8P00gAdM6a/K6a/K002Hf=S00=>CTi4A4A4A4@00UIFEP03Kfm_
N7QhN7Qh009iNGT00h>3Pi6ATI6AT@02Vi^K00>UYJFa/K6a/K400ZVYZ@:1PH400f1PH6YZJVYZJP02
SXj>00>`/;30`<30`<000[>c/`03Y:BT][Jf][Jf00;9bLT00kNg]j:RXZ:RXP02/;2`00?0`<2a/K6a
/K400YNGU`03RXZ:SHf=SHf=00:MWId00jf][Jn_[jn_[`02XJ6Q00>3Ph=bLW9bLW800XZ:RP03Xj>S
TI6ATI6A009[Jf/00d];BdQ8B4Q8B002Lg=c00>PX:2LW9bLW9`00XN7Q`03RXZ:UIFEUIFE00:BTY80
0hj>SY:BTY:BTP02V9RH0i^KV`:IVIT00iFEUHf=SHf=S@02Ph>300=hN7QfMWIfMWH00X:2PP03UYJF
ZZZZZZZZ00:d];@00jb/[:JVYZJVYP02][Jf00?3`l>e]KFe]KD00Z6QX@03WIfM[Jf][Jf]00;AdM40
0mgMgJFUYJFUY@02JVYZ0WMgM`03XZ:R[jn_[jn_00>][Jd2WIfM0Va/K003BTY:I6ATI6AT00:6QXH0
0g9bLUYJFUYJFP02MWIf00>OWinYZJVYZJT00jFUY@:YZJT3]kNg0Y6AT@9`L7000hZ:RZ:RXZ:RXP02
Lg=c00=ADE6GUiNGUiL00]_Kf`03ZJVYJVYZJVYZ00:BTY800lS8b:b/[:b/[004oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0UUIF@03JVYZIfMWIfMW009QHF400eiNGVMWIfMWI`02J6QX00=:
BTZLW9bLW9`00X>3P`03RHV9^;Rh^;Rh009aLG400h20P7emOGemO@02R8R800>DU9BATI6ATI400Xf=
S@>DU9@2OWin00=UIFELG5aLG5`00UYJFP03DU9B_;bl_;bl008`<3000iFEUGinOWinOP02NWYj0YBD
U003[Zj^;Rh^;Rh^00:@T9000ginOWalO7alO002TI6A00>QXJ6=SHf=SHd00W9bLP03MWIfPX:2PX:2
009lO7`00g]kNiFEUIFEU@02/;2`00<m?CfWYjNWYjL00Xb<S003LW9bJVYZJVYZ009dM7@00hn?SinO
WinOW`02SHf=00=kNg^;Rh^;Rh/00Z^[Z`03BTY:a<C4a<C400:NWYh3MWIf0XJ6QP03PX:2NWYjNWYj
009oOgl3QXJ60X:2PP03OgmoOGemOGem00=kNg/2Ogmo0XJ6QP03T92@UiNGUiNG00:FUYH00i:BTXj>
SXj>SP02SXj>00<N7QjKVi^KVi/00XZ:RP03Ng]kPh>3Ph>300:ATI400i:BTXN7QhN7Q`02Kfm_00=]
KFfRXZ:RXZ800UYJFP;3`l<00adM7H>3Ph>3P`02Q8B400><S8bYZJVYZJT00VYZJP03UiNGShn?Shn?
009lO7`00hf=SIJFUYJFUP02IfMW00>OWimjNWYjNWX00Vi^KP03MWIfRXZ:RXZ:008P82000jNWYdI6
ATI6AP02BTY:00>EUIE`L71`L7000YJFUP03A4A4U9BDU9BD009XJ6P00iBDU<K6a/K6aP02:RXZ00=j
NWZKVi^KVi/01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0W]kN`03MWIf
QXJ6QXJ600:CTi<00iFEUHB4Q8B4Q002NGUi00>@T92c/k>c/k<00/S8b003`L71V9RHV9RH009bLW80
0gYjNY2@T92@T002R8R800=dM7A/K6a/K6`00V=SH`03CTi>A4A4A4A4009FEUH00fm_KgQhN7QhN002
NGUi00>3Ph>ATI6ATI400Y^KV`03YJFU/K6a/K6a00:YZJT2PH6100=PH61ZJVYZJVX00Xj>SP03/;2`
`<30`<3000:c/k<00jBTY;Jf][Jf]P02bLW900>g]kNRXZ:RXZ800[2`/003`<30/K6a/K6a00:GUiL0
0hZ:RXf=SHf=S@02WIfM00>][Jf_[jn_[jl00Z6QX@03Ph>3LW9bLW9b00::RXX00j>SXi6ATI6AT@02
Jf][00=;Bd]8B4Q8B4P00W=cL`03X:2PW9bLW9bL00:7QhL00hZ:RYFEUIFEU@02TY:B00>>SXjBTY:B
TY800YRHV0>KVi/2VIVI00>EUIF=SHf=SHd00X>3P`03N7QhMWIfMWIf00:2PX800iJFUZZZZZZZZP02
];Bd00>/[:bVYZJVYZH00[Jf]P03`l?3]KFe]KFe00:QXJ400ifMWJf][Jf][@02dM7A00?MgMfUYJFU
YJD00VYZJP9gMgL00j:RXZn_[jn_[`03[Jf]0YfMW@9/K6`00dY:BVATI6ATI002QXJ600=bLW9JFUYJ
FUX00WIfMP03WinOZJVYZJVY00>UYJD2ZJVY0kNg]`:ATI42L71`00>:RXZRXZ:RXZ800W=cL`03DE5A
UiNGUiNG00;Kfm/00jVYZFYZJVYZJP02TY:B00?8b<R/[:b/[:`01?ooo`030000oooooooo03;oool0
10000?ooooooooooo`9IFET00fYZJVMWIfMWI`02HF5Q00=NGUiWIfMWIfL00VQXJ003BTY:W9bLW9bL
00:3Ph<00hV9RKRh^;Rh^002LG5a00>0P81mOGemOGd00XR8R003U9BDTI6ATI6A00:=SHd3U9BD0Win
OP03IFEUG5aLG5aL009JFUX00e9BD[bl_;bl_002<30`00>EUIEnOWinOWh00WYjNP:DU9@00jj^[Rh^
;Rh^;P02T92@00=nOWilO7alO7`00Y6AT@03XJ6QSHf=SHf=009bLW800gIfMX:2PX:2PP02O7al00=k
Ng^EUIFEUID00[2`/003?CdmYjNWYjNW00:<S8`00g9bLVYZJVYZJP02M7Ad00>?ShnOWinOWil00Xf=
S@03Ng]kRh^;Rh^;00:[Zj/00dY:B/C4a<C4a002WYjN0gIfMP:6QXH00h:2PWYjNWYjNP02Ogmo0hJ6
QP:2PX800gmoOgemOGemO@03Ng]k0WmoO`:6QXH00i2@T9NGUiNGU`02UYJF00>BTY:>SXj>SXh00Xj>
SP037QhNVi^KVi^K00::RXX00g]kNh>3Ph>3P`02TI6A00>BTY:7QhN7QhL00Vm_K`03KFe]XZ:RXZ:R
009JFUX2`l?300<M7Af3Ph>3Ph<00XB4Q003S8b<ZJVYZJVY009ZJVX00iNGUhn?Shn?S`02O7al00>=
SHfFUYJFUYH00VMWI`03WinONWYjNWYj009^KVh00gIfMXZ:RXZ:RP02820P00>WYjM6ATI6ATH00TY:
BP03UIFEL71`L71`00:FUYH00dA4A9BDU9BDU002J6QX00>DU9C6a/K6a/H00RXZ:P03NWYjVi^KVi^K
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9mOGd00g=cLgMgMgMgM`02
RHV900>?Shm]KFe]KFd00UADE003M7Ad[:b/[:b/00;Bd]800m7AdJ2PX:2PX002Jf][00=UIFEmOGem
OGd00YBDU003XJ6QWYjNWYjN00:7QhL00f=SHdU9BDU9B@02Cdm?00=[Jf^<S8b<S8`00Z>SX`03Y:BT
Vi^KVi^K00:IVIT00ibLW9nOWinOW`02W9bL0X^;R`03NWYjM7AdM7Ad009jNWX00hB4Q8n?Shn?S`03
Ti>C0YNGU`:FUYH00hV9RH>3Ph>3P`02VIVI00>][JfRXZ:RXZ800XV9R@03N7QhNGUiNGUi00:@T900
0jFUYJ6QXJ6QX@02RXZ:00=^KViVIVIVIVH00X20P003WYjNX:2PX:2P00:5QHD00eIFEShn?Shn?P02
Hf=S00>EUIFIVIVIVIT00XV9R@03Rh^;SXj>SXj>00:5QHD00gemOH61PH61P@02R8R80hZ:RP:>SXh0
0hn?ShF5QHF5Q@02Ng]k00=oOgn3Ph>3Ph<00WQhN003MGEeT92@T92@00:WYjL00iFEUGmoOgmoO`02
T92@00>UYJFFUYJFUYH00X>3P`03RXZ:XJ6QXJ6Q00:i^KT00kjn_Z6QXJ6QX@02OGem0WEeM@03Q8B4
Vi^KVi^K00:[Zj/00jJVYY:BTY:BTP02P82000=aLG5PH61PH6000UUIF@03IFEUKVi^KVi^009KFe/0
0eADE8N7QhN7Q`02^[Zj00>b/[:LW9bLW9`00[Bd]003alO7WYjNWYjN009fMWH00i:BTZf][Jf][@02
NGUi00==CDf1PH61PH400/?3``03]KFeTI6ATI6A00:IVIT00jNWYiFEUIFEU@04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0VATI003OGemQXJ6QXJ6009iNGT00g1`L8:2PX:2PP02RHV900=L
G5bFUYJFUYH00fYZJP:RXZ82KFe]00>=SHf<S8b<S8`00WemO@03JFUYG5aLG5aL009NGUh00fa/K7Ee
MGEeM@02IfMW00?4a<BYZJVYZJT00YVIV@03W9bLXj>SXj>S00:OWil00i6ATH>3Ph>3P`02OGem0XR8
R003VIVIX:2PX:2P00:OWil00iRHV8n?Shn?S`02Rh^;00>7QhMnOWinOWh00WMgM`03O7alP820P820
009fMWH00g=cLhZ:RXZ:RP02YZJV00<i>CVZZZZZZZX00Xj>SP03MWIfNGUiNGUi00:@T9000jb/[3lo
?clo?`02YJFU00><S8b9RHV9RHT00YfMW@03AdM7F5QHF5QH00:_[jl00h:2PWalO7alO002QhN700>5
QHF2PX:2PX800XR8R003SXj>RHV9RHV900:2PX83P8200WemO@03O7alPH61PH6100:6QXH00h>3PhF5
QHF5Q@028B4Q00>][Jd/;2`/;2`00YZJVP03YZJV[:b/[:b/00:?Shl00g9bLWQhN7QhN002R8R800>5
QHEjNWYjNWX00W=cL`03O7alWinOWinO0097AdL2`L7100>XZ:R8R8R8R8P00WAdM003O7alVIVIVIVI
00:g]kL00eaLG7]kNg]kN`02Shn?00>>SXj6QXJ6QXH00XN7Q`03MWIf/;2`/;2`009jNWX00hR8R:b/
[:b/[002[Jf]00>UYJFk^k^k^k/00/?3``03TY:BJf][Jf][00:DU9@00lC4a:VYZJVYZ@02Ogmo00>>
SXjZZZZZZZX00Z:RXP03W9bL^;Rh^;Rh00Coool00`000?ooooooo`0@oooo000Uoooo0P0000?oool2
OGem00=cLg=gMgMgMgL00XV9R@03Shn?KFe]KFe]009DE5@00gAdM:b/[:b/[002d];B00?AdM6PX:2P
X:000V][J`03IFEUOGemOGem00:DU9@00j6QXIjNWYjNWP02QhN700=SHf=9BDU9BDT00Tm?C`03Jf][
S8b<S8b<00:SXj<00jBTY9^KVi^KV`02VIVI00>LW9bOWinOWil00YbLW0:;Rh/00gYjNWAdM7AdM002
NWYj00>4Q8B?Shn?Shl00i>CT`:GUiL2UYJF00>9RHV3Ph>3Ph<00YVIV@03[Jf]XZ:RXZ:R00:9RHT0
0gQhN7UiNGUiN@02T92@00>UYJFQXJ6QXJ400XZ:RP03KVi^IVIVIVIV00:0P8000ijNWZ2PX:2PX002
QHF500=FEUHn?Shn?Sh00V=SH`03UIFEVIVIVIVI00:9RHT00h^;Rhj>SXj>SP02QHF500=mOGf1PH61
PH400XR8R0>:RXX2SXj>00>?Shn5QHF5QHD00W]kN`03OgmoPh>3Ph>3009hN7P00gEeMI2@T92@T002
YjNW00>EUIEoOgmoOgl00Y2@T003YJFUUYJFUYJF00:3Ph<00hZ:RZ6QXJ6QX@02^KVi00>n_[jQXJ6Q
XJ400WemO@9eMGD00hB4Q9^KVi^KV`02Zj^[00>VYZJBTY:BTY800X20P003LG5aH61PH61P009IFET0
0fEUIFi^KVi^KP02Fe]K00=DE5B7QhN7QhL00[Zj^P03/[:bW9bLW9bL00:d];@00lO7aijNWYjNWP02
MWIf00>BTY:][Jf][Jd00WUiN@03CDe=PH61PH6100;3`l<00kFe]I6ATI6AT@02VIVI00>WYjNEUIFE
UID00oooo`80000doooo00@0003oooooooooool2I6AT00=mOGf6QXJ6QXH00WUiN@03L71`PX:2PX:2
00:9RHT00eaLG9JFUYJFUP03JVYZ0Z:RXP9]KFd00hf=SHb<S8b<S002OGem00=YJFULG5aLG5`00UiN
GP03K6a/MGEeMGEe009WIfL00lC4a:VYZJVYZ@02VIVI00>LW9bSXj>SXj<00YnOW`03TI6APh>3Ph>3
009mOGd2R8R800>IVIVPX:2PX:000YnOW`03V9RHShn?Shn?00:;Rh/00hN7QginOWinOP02MgMg00=l
O7b0P820P8000WIfMP03Lg=cRXZ:RXZ:00:VYZH00cTi>JZZZZZZZP02SXj>00=fMWIiNGUiNGT00Y2@
T003[:b/?clo?clo00:UYJD00hb<S8V9RHV9R@02WIfM00=7AdMHF5QHF5P00Zn_[`03PX:2O7alO7al
00:7QhL00hF5QH:2PX:2PP02R8R800>>SXj9RHV9RHT00X:2PP>0P802OGem00=lO7b1PH61PH400XJ6
QP03Ph>3QHF5QHF5008Q8B400jf][B`/;2`/;002VYZJ00>VYZJ/[:b/[:`00Xn?S`03LW9bN7QhN7Qh
00:8R8P00hF5QGYjNWYjNP02Lg=c00=lO7bOWinOWil00TM7A`;1`L400jRXZ8R8R8R8R002M7Ad00=l
O7bIVIVIVIT00[Ng]`03G5aLNg]kNg]k00:?Shl00hj>SXJ6QXJ6QP02QhN700=fMWJ`/;2`/;000WYj
NP03R8R8[:b/[:b/00:][Jd00jFUYK^k^k^k^`02`l?300>BTY9[Jf][Jf/00YBDU003a<C4ZJVYZJVY
009oOgl00hj>SZZZZZZZZP02XZ:R00>LW9bh^;Rh^;P00oooo`80000Boooo000Uoooo00<0003ooooo
ool00_ooo`::RXX00g]kNfYZJVYZJP02OWin00>8R8QMGEeMGEd00S/k>`03HV9RWinOWinO00:e]KD0
0jJVYX20P820P002FUYJ00=<C4aTI6ATI6@00Z6QX@03e=CDclo?clo?00:UYJD00gMgMeaLG5aLG002
HF5Q00>1PH6XZ:RXZ:P00[bl_003[Zj^Shn?Shn?009jNWX00gEeMGinOWinOP02Rh^;0Xn?S`03RHV9
PH61PH61009eMGD00f1PH5IFEUIFEP02IfMW00=hN7Q]KFe]KFd00UQHF003D51@FUYJFUYJ009fMWH0
0hZ:RWmoOgmoO`02JVYZ00=SHf=]KFe]KFd00X20P003Rh^;NGUiNGUi009RHV800f=SHg5aLG5aL@02
N7Qh00>5QHFVYZJVYZH00[2`/003OgmoCTi>CTi>009NGUh00hN7Qi>CTi>CT`02SHf=00>6QXIlO7al
O7`00W9bLP03Kfm_MGEeMGEe009lO7`00g]kNgQhN7QhN002N7Qh00=iNGUhN7QhN7P00W]kN`03QhN7
SHf=SHf=009iNGT00fIVIWEeMGEeM@02PH6100=TI6A8B4Q8B4P00UiNGP03Ng]kLG5aLG5a009PH600
0fe]KGmoOgmoO`02NGUi00=dM7B;Rh^;Rh/00YVIV@9lO7`00f1PH7IfMWIfMP02U9BD00>7QhMfMWIf
MWH00Xn?S`03XJ6QMGEeMGEe009<C4`00fi^KXb<S8b<S002D51@00<L71aNGUiNGUh00Zb/[003T92@
Hf=SHf=S00::RXX00k>c/hJ6QXJ6QP02Fe]K00>BTY;2`/;2`/800X20P003>3PhFEUIFEUI00:KVi/0
0jVYZIJFUYJFUP02O7al00=[Jf]hN7QhN7P01?ooo`030000oooooooo03;oool010000?oooooooooo
o`9SHf<00h>3PijNWYjNWP02TI6A00>1PH6HV9RHV9P00Z:RXP03KFe]X:2PX:2P009oOgl00hV9RKFe
]KFe]@02LW9b00>FUYJDU9BDU9@00V=SH`03Z:RXVi^KVi^K00:/[:`00l;2`/c<c<c<c002ADE500>O
Win1PH61PH400WAdM003QXJ6XZ:RXZ:R008e=CD00jVYZIRHV9RHV002QhN70XB4Q003SHf=V9RHV9RH
00:TY:@00k2`/3Hf=SHf=P02V9RH00>1PH63Ph>3Ph<00Xn?S`03U9BDT92@T92@00:3Ph<00gmoOiBD
U9BDU002[jn_00<l?3bZZZZZZZX00YFEU@03RXZ:W9bLW9bL008n?Sh00kno_kZj^[Zj^P02?3`l00>Y
ZJV;Rh^;Rh/00WmoO`03Y:BTb<S8b<S8008m?Cd00i>CThJ6QXJ6QP02RXZ:00>?ShnEUIFEUID00YZJ
VP03V9RHShn?Shn?00>6QXH2RXZ:0hb<S0::RXX2Q8B400=iNGUkNg]kNg/00YbLW003_knoC4a<C4a<
00;2`/800eMGEeUIFEUIF@02ZZZZ00>0P821PH61PH400Y6AT@03SXj>Rh^;Rh^;00:OWil00cPh>:^[
Zj^[Z`02YJFU0Shn?P03`l?3Y:BTY:BT00:3Ph<00hf=SBPX:2PX:002UiNG00>HV9QCDe=CDe<00XJ6
QP03N7QhIVIVIVIV00:CTi<00k2`/6a/K6a/K002WYjN00>i^KUbLW9bLW800UiNGP03^;RhF5QHF5QH
009VIVH00ibLW6IVIVIVIP02VYZJ00=UIFEEEEEEEED00Z:RXP03V9RHYZJVYZJV0091@D400eIFE]GE
eMGEe@04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2TI6A00>6QXIcLg=c
Lg<00XB4Q003Shn?IfMWIfMW009;Bd/00g]kNjj^[Zj^[P02UYJF00=OGem3@d=3@d<00Slo?`03ADE5
J6QXJ6QX00:b/[800n7QhKno_kno_`02Ng]k00=?CdmADE5ADE400XZ:RP03_KfmZj^[Zj^[009kNg/0
0fQXJ6ATI6ATI002Fe]K00=IFEUTI6ATI6@00WAdM0:6QXH00hj>SXB4Q8B4Q002MGEe00=/K6a[Jf][
Jf/00V][J`03JFUYGemOGemO009DE5@00di>CUIFEUIFEP02Lg=c00>7QhMeMGEeMGD00UeMG@03HF5Q
L71`L71`009hN7P00gIfMVIVIVIVIP02GemO00=mOGfDU9BDU9@00W5aL@03F5QHUIFEUIFE00;:b/X0
0i>CTde=CDe=C@02Fe]K00><S8bOWinOWil00YVIV@03QXJ6K6a/K6a/009MGEd00f1PH7AdM7AdM002
QXJ600>2PX9gMgMgMgL00WMgM`=kNg/2N7Qh00=cLg=dM7AdM7@00X:2PP03Shn?S8b<S8b<009eMGD0
0di>CSPh>3Ph>002De=C00=kNg^1PH61PH400W=cL`03K6a/HF5QHF5Q0092@T800cdm?GemOGemO@02
[:b/0W9bLP03<C4aEUIFEUIF00:ATI400hB4Q6IVIVIVIP02MgMg00>DU9BHV9RHV9P00YVIV@03[jn_
];Bd];Bd00:5QHD00eQHF6ATI6ATI002Ng]k00=TI6A<C4a<C4`00Va/K003RXZ:I6ATI6AT009;Bd/0
0iNGUm;Bd];BdP02QHF500<[:b]>CTi>CTh00YFEU@03VYZJOGemOGem009SHf<00eYJFW=cLg=cL`04
oooo00<0003oooooool0<_ooo`040000oooooooooooo0UeMG@03OGemW9bLW9bL00:CTi<00h>3PiNG
UiNGU`02WIfM00=TI6BTY:BTY:@00ZZZZP03FEUILg=cLg=c00:0P8000hN7Qg5aLG5aL@02[Jf]00=o
Ogn@T92@T9000T=3@`03GEeME5ADE5AD00:JVYX00fi^KWinOWinOP02ZJVY00=2@T;0`<30`<000TU9
B@03_Kfm<S8b<S8b00:JVYX2SHf=00>:RXXM7AdM7Ad00RXZ:P03Y:BTVYZJVYZJ00:=SHd00hF5QHJ6
QXJ6QP02S8b<00>ATI6?Shn?Shl00X61P@03OGemV9RHV9RH00:d];@00cXj>ZBTY:BTY002VYZJ00>K
Vi/c<c<c<c<00[^k^`03Zj^[92@T92@T00:l_;`00eEEEIVIVIVIV@02JVYZ00>CTi=ADE5ADE400[bl
_003TY:BPH61PH6100:4Q8@00i>CTbd];Bd];@02/;2`00<`<32EUIFEUID00X>3P`03Q8B4S8b<S8b<
00:=SHd00hV9RHN7QhN7Q`02QhN700><S8bDU9BDU9@00YbLW003ZZZZB4Q8B4Q800;Jf]X00gEeMFi^
KVi^KP02]KFe00=oOgmcLg=cLg<00X>3P`03U9BDZZZZZZZZ009GEeL00mkNg[:b/[:b/P02Shn?0TA4
A003M7AdCTi>CTi>00:@T9000iNGUjn_[jn_[`02YJFU00>DU9BMWIfMWId00ZZZZP03YjNW[Jf][Jf]
009LG5`00ginOVi^KVi^KP02F5QH00=]KFf4Q8B4Q8@00Vi^KP03EEEEKVi^KVi^009gMgL00jNWYfi^
KVi^KP02[:b/00=nOWiVIVIVIVH00ZNWY`039RHV];Bd];Bd009?Cdl00emOGmKFe]KFeP04oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2TI6A00>6QXIcLg=cLg<00XB4Q003Shn?
IfMWIfMW009;Bd/00g]kNjj^[Zj^[P02UYJF00=OGem3@d=3@d<00Slo?`03ADE5J6QXJ6QX00:b/[80
0n7QhKno_kno_`02Ng]k00=?CdmADE5ADE400XZ:RP03_KfmZj^[Zj^[009kNg/00fQXJ6ATI6ATI002
Fe]K00=IFEUTI6ATI6@00WAdM0:6QXH00hj>SXB4Q8B4Q002MGEe00=/K6a[Jf][Jf/00V][J`03JFUY
GemOGemO009DE5@00di>CUIFEUIFEP02Lg=c00>7QhMeMGEeMGD00UeMG@03HF5QL71`L71`009hN7P0
0gIfMVIVIVIVIP02GemO00=mOGfDU9BDU9@00W5aL@03F5QHUIFEUIFE00;:b/X00i>CTde=CDe=C@02
Fe]K00><S8bOWinOWil00YVIV@03QXJ6K6a/K6a/009MGEd00f1PH7AdM7AdM002QXJ600>2PX9gMgMg
MgL00WMgM`=kNg/2N7Qh00=cLg=dM7AdM7@00X:2PP03Shn?S8b<S8b<009eMGD00di>CSPh>3Ph>002
De=C00=kNg^1PH61PH400W=cL`03K6a/HF5QHF5Q0092@T800cdm?GemOGemO@02[:b/0W9bLP03<C4a
EUIFEUIF00:ATI400hB4Q6IVIVIVIP02MgMg00>DU9BHV9RHV9P00YVIV@03[jn_];Bd];Bd00:5QHD0
0eQHF6ATI6ATI002Ng]k00=TI6A<C4a<C4`00Va/K003RXZ:I6ATI6AT009;Bd/00iNGUm;Bd];BdP02
QHF500<[:b]>CTi>CTh00YFEU@03VYZJOGemOGem009SHf<00eYJFW=cLg=cL`04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0UeMG@03OGemW9bLW9bL00:CTi<00h>3PiNGUiNGU`02WIfM00=T
I6BTY:BTY:@00ZZZZP03FEUILg=cLg=c00:0P8000hN7Qg5aLG5aL@02[Jf]00=oOgn@T92@T9000T=3
@`03GEeME5ADE5AD00:JVYX00fi^KWinOWinOP02ZJVY00=2@T;0`<30`<000TU9B@03_Kfm<S8b<S8b
00:JVYX2SHf=00>:RXXM7AdM7Ad00RXZ:P03Y:BTVYZJVYZJ00:=SHd00hF5QHJ6QXJ6QP02S8b<00>A
TI6?Shn?Shl00X61P@03OGemV9RHV9RH00:d];@00cXj>ZBTY:BTY002VYZJ00>KVi/c<c<c<c<00[^k
^`03Zj^[92@T92@T00:l_;`00eEEEIVIVIVIV@02JVYZ00>CTi=ADE5ADE400[bl_003TY:BPH61PH61
00:4Q8@00i>CTbd];Bd];@02/;2`00<`<32EUIFEUID00X>3P`03Q8B4S8b<S8b<00:=SHd00hV9RHN7
QhN7Q`02QhN700><S8bDU9BDU9@00YbLW003ZZZZB4Q8B4Q800;Jf]X00gEeMFi^KVi^KP02]KFe00=o
OgmcLg=cLg<00X>3P`03U9BDZZZZZZZZ009GEeL00mkNg[:b/[:b/P02Shn?0TA4A003M7AdCTi>CTi>
00:@T9000iNGUjn_[jn_[`02YJFU00>DU9BMWIfMWId00ZZZZP03YjNW[Jf][Jf]009LG5`00ginOVi^
KVi^KP02F5QH00=]KFf4Q8B4Q8@00Vi^KP03EEEEKVi^KVi^009gMgL00jNWYfi^KVi^KP02[:b/00=n
OWiVIVIVIVH00ZNWY`039RHV];Bd];Bd009?Cdl00emOGmKFe]KFeP04oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool2RXZ:00>8R8R2PX:2PX800Y6AT@03VYZJO7alO7al009YJFT0
0iJFU[Jf][Jf]P02Ogmo00<d=3@W9bLW9bL00T10@003F5QHNg]kNg]k00:c/k<00lO7ai>CTi>CT`02
CTi>00<c<c=ADE5ADE400ZJVYP03g]kNXZ:RXZ:R0097AdL00cPh>4a<C4a<C002CDe=00=<C4aJFUYJ
FUX00Ve]K@:2PX800hf=SH20P820P002M7Ad00>8R8RJVYZJVYX00XN7Q`03JVYZJFUYJFUY009_Kfl0
0fMWIfIVIVIVIP02PH6100>EUIEoOgmoOgl00V9RHP03JFUYNWYjNWYj009kNg/00gAdM6UYJFUYJ@02
KVi^00>MWIfd];Bd];@00W1`L003>3PhNWYjNWYj00;5aLD00iZJVUIFEUIFEP02H61P00><S8bSXj>S
Xj<00ZBTY003SHf=Jf][Jf][00=BDU82LG5a0Y6AT@03TY:BQHF5QHF500:3Ph<00hB4Q8:2PX:2PP02
MWIf00=JFUYEEEEEEED00Xj>SP03`l?3[jn_[jn_009gMgL00di>CTM7AdM7A`02Jf][00>GUiNMWIfM
WId00XR8R003Lg=cFe]KFe]K008g=cL00c<c<gMgMgMgM`02ZJVY0W1`L003;2`/BDU9BDU900:3Ph<0
0hN7QgAdM7AdM002J6QX00=cLg>RXZ:RXZ800];BdP03f=SHb<S8b<S800:n_[h00jb/[8>3Ph>3P`02
GUiN00=BDU9HF5QHF5P00VQXJ003KFe]BTY:BTY:0091@D400ibLW>3Ph>3Ph002S8b<00<Z:RYFEUIF
EUH00Z:RXP03T92@GemOGemO009GEeL00fEUIGUiNGUiN@04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0U]KF`03MgMgShn?Shn?00:9RHT00galO8Z:RXZ:RP02SHf=00=NGUje]KFe]KD00V5Q
H@03UYJFUiNGUiNG009iNGT00eeMGK>c/k>c/`02PX:200=_KfnIVIVIVIT00];BdP03L71`d];Bd];B
00:=SHd00f1PH9:BTY:BTP02I6AT00=_KfmKFe]KFe/00/k>cP03alO7?3`l?3`l00:RXZ82TI6A00>;
Rh^JVYZJVYX00ZBTY003SXj>MgMgMgMg009mOGd00h^;RhN7QhN7Q`02OWin00>4Q8B9RHV9RHT00W]k
N`03MgMgUIFEUIFE00:d];@00cLg=inOWinOW`02VIVI00>MWId_;bl_;bl00ZZZZP03RXZ:O7alO7al
00:e]KD00fUYJJVYZJVYZ@02JFUY00>;Rh_3`l?3`l<00T10@003U9BDP820P820009oOgl00i2@T:^[
Zj^[Z`02_[jn00=4A4BRXZ:RXZ800XF5Q@03PH61QhN7QhN700:6QXH3PX:20X^;R`03YZJV]kNg]kNg
008U9BD00hj>S[Fe]KFe]@02LW9b00>7QhMbLW9bLW800[2`/003MWIfJf][Jf][00:4Q8@00j:RXTU9
BDU9B@02K6a/00=`L70i>CTi>CT00XZ:RP:l_;`00gmoOfUYJFUYJ@02/[:b00>YZJTh>3Ph>3P00[Bd
]003;bl_QXJ6QXJ6009WIfL00fa/K8B4Q8B4Q002Ti>C00>VYZIADE5ADE400W1`L003lO7aKfm_Kfm_
009NGUh00m;Bd_7alO7al@02PX:200<k>c]mOGemOGd00/30`003TY:BIfMWIfMW00:JVYX00j6QXL?3
`l?3``02Cdm?00?5aLG8b<S8b<P01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02
oooo0XZ:RP03R8R8PX:2PX:200:ATI400iZJVWalO7alO002JFUY00>FUYJf][Jf][H00WmoO`03=3@d
9bLW9bLW0090@4000eQHF7]kNg]kN`02/k>c00?7alNCTi>CTi<00Ti>CP03<c<cDE5ADE5A00:VYZH0
0mkNgZ:RXZ:RXP02AdM700<h>3Q<C4a<C4`00Te=C@03C4a<FUYJFUYJ009]KFd2PX:200>=SHf0P820
P8000WAdM003R8R8VYZJVYZJ00:7QhL00fYZJVUYJFUYJ@02Kfm_00=WIfMVIVIVIVH00X61P@03UIFE
OgmoOgmo009RHV800fUYJGYjNWYjNP02Ng]k00=dM7AYJFUYJFT00Vi^KP03WIfM];Bd];Bd009`L700
0cPh>7YjNWYjNP02aLG500>JVYYFEUIFEUH00V1PH003S8b<Xj>SXj>S00:TY:@00hf=SF][Jf][J`03
DU9B0W5aL@:ATI400i:BTXF5QHF5Q@02Ph>300>4Q8B2PX:2PX800WIfMP03FUYJEEEEEEEE00:>SXh0
0l?3`jn_[jn_[`02MgMg00=>CTi7AdM7AdL00V][J`03UiNGWIfMWIfM00:8R8P00g=cLe]KFe]KF`02
=cLg00<c<c=gMgMgMgL00ZVYZ@9`L7000b`/;4U9BDU9B@02Ph>300>7QhMdM7AdM7@00VQXJ003Lg=c
XZ:RXZ:R00;Bd]800mSHf<S8b<S8b002_[jn00>/[:b3Ph>3Ph<00UiNGP03DU9BF5QHF5QH009XJ6P0
0fe]KDY:BTY:BP02@D5100>LW9cPh>3Ph>000Xb<S003:RXZEUIFEUIF00:RXZ800i2@T5mOGemOG`02
EeMG00=UIFEiNGUiNGT01?ooo`030000oooooooo03;oool010000?ooooooooooo`9KFe/00gMgMhn?
Shn?S`02RHV900=lO7b:RXZ:RXX00Xf=S@03GUiN]KFe]KFe009QHF400iJFUYNGUiNGU`02NGUi00=M
GEfc/k>c/k<00X:2PP03Kfm_VIVIVIVI00;Bd]800g1`L=;Bd];BdP02SHf=00=PH62BTY:BTY800VAT
I003Kfm_Fe]KFe]K00;>c/h00lO7ac`l?3`l?002XZ:R0Y6AT@03Rh^;VYZJVYZJ00:TY:@00hj>SWMg
MgMgM`02OGem00>;Rh^7QhN7QhL00WinOP03Q8B4RHV9RHV9009kNg/00gMgMiFEUIFEU@02];Bd00<g
=cNOWinOWil00YVIV@03WIfM;bl_;bl_00:ZZZX00hZ:RWalO7alO002]KFe00=YJFVYZJVYZJT00VUY
J@03Rh^;`l?3`l?30090@4000iBDU820P820P002Ogmo00>@T92[Zj^[Zj/00[jn_P03A4A4XZ:RXZ:R
00:5QHD00h61PHN7QhN7Q`02QXJ60h:2PP:;Rh/00jJVY[Ng]kNg]`029BDU00>>SXje]KFe]KD00W9b
LP03QhN7LW9bLW9b00:`/;000gIfMV][Jf][J`02Q8B400>RXZ99BDU9BDT00Va/K003L71`>CTi>CTi
00::RXX2_;bl00=oOgmYJFUYJFT00[:b/P03ZJVY>3Ph>3Ph00:d];@00bl_;hJ6QXJ6QP02IfMW00=/
K6b4Q8B4Q8@00Y>CT`03YZJVDE5ADE5A009`L7000o7alFm_Kfm_K`02GUiN00?Bd];alO7alO400X:2
PP03>c/kOGemOGem00;0`<000i:BTVMWIfMWI`02VYZJ00>QXJ73`l?3`l<00Tm?C`03aLG5b<S8b<S8
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9cLg<00gMgMh20P820P002
Ti>C00>LW9b5QHF5QHD00W1`L003P820Ti>CTi>C009oOgl00fIVIV][Jf][J`02OWin00>9RHVATI6A
TI400YNGU`03TI6ANg]kNg]k009YJFT00fe]KH61PH61P@02Vi^K00>ZZZZPX:2PX:000XZ:RP03PH61
MWIfMWIf009JFUX00da<C6EUIFEUI@02R8R80YRHV003Ti>CNWYjNWYj009ZJVX00hB4Q:6QXJ6QX@02
U9BD00=jNWYiNGUiNGT00WinOP03M7AdLG5aLG5a00::RXX00inOWi6ATI6AT@02NGUi00=`L71dM7Ad
M7@00X:2PP03S8b<P820P820009jNWX00ijNW[:b/[:b/P02N7Qh00=2@T9VIVIVIVH00YfMW@03W9bL
OgmoOgmo009/K6`00fe]KHR8R8R8R002Xj>S00>OWin1PH61PH400UIFEP03?cloEeMGEeMG00:1PH40
0iFEUINGUiNGU`02SHf=0h20P09jNWX00eEEEDY:BTY:BP02S8b<00?:b/Z`/;2`/;000WEeM@03FEUI
I6ATI6AT00:DU9@00kFe]I2@T92@T002G5aL00=QHF5hN7QhN7P00Vm_K`03Hf=SLW9bLW9b00:5QHD2
RXZ:00=lO7aGEeMGEeL00TM7A`03MGEeYZJVYZJV00:IVIT00gMgMg9bLW9bLP02Q8B400>OWinh^;Rh
^;P00/30`003][JfXZ:RXZ:R00:@T9000hJ6QXF5QHF5Q@02SXj>00>6QXI?Cdm?Cdl00S/k>`03X:2P
m?Cdm?Cd00:OWil00cLg=fEUIFEUI@02];Bd00>IVIUQHF5QHF400V=SH`=gMgL4oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0VEUI@03OgmoS8b<S8b<00:4Q8@00gUiNH>3Ph>3P`02S8b<00=m
OGe_Kfm_Kfl00WemO@03QhN7KVi^KVi^00:l_;`00iNGUginOWinOP02LW9b00=jNWZFUYJFUYH00SPh
>003^KVi>3Ph>3Ph00:UYJD00ifMWJJVYZJVYP02];Bd00>e]KFf][Jf][H00T];B`03Cdm?[Zj^[Zj^
00:>SXh2P82000>7QhNNWYjNWYh00Z^[Z`03U9BDN7QhN7Qh009mOGd00hb<S8R8R8R8R002Ogmo00>6
QXJ:RXZ:RXX00WinOP03N7QhSXj>SXj>00:YZJT00cLg=jRXZ:RXZ002UYJF00>9RHVBTY:BTY800YZJ
VP03PH61Lg=cLg=c00:SXj<00eEEEK2`/;2`/002PX:200>5QHFPX:2PX:000SPh>003/K6aVi^KVi^K
00:2PX800h>3Pb8R8R8R8P02`L7100?Fe]I:BTY:BTX00Z2PX003RHV9P820P82000:1PH400hN7QhB4
Q8B4Q002Rh^;00<f=SI>CTi>CTh00Z^[Z`03UIFEBDU9BDU900:4Q8@00hn?Sfa/K6a/K002XJ6Q00=a
LG6<S8b<S8`00/30`003D51@`<30`<3000?7alL2>CTi0Z2PX0:TY:@00kjn_Vm_Kfm_K`02PX:200=F
EUJHV9RHV9P00Y>CT`03Xj>SXZ:RXZ:R00:EUID00hB4Q7QhN7QhN002O7al00>>SXjWYjNWYjL00[Vi
^@03@T92/k>c/k>c00:RXZ800bd];FEUIFEUI@02QhN700>n_[j4Q8B4Q8@00Ti>CP03VIVIHf=SHf=S
00:<S8`00iFEUKZj^[Zj^P02?3`l00<c<c?0`<30`<001?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0UmOG`03HF5QMgMgMgMg00:BTY800ijNWXZ:RXZ:RP02K6a/00=PH61[Jf][
Jf/00XR8R003ZJVY_[jn_[jn00:m_Kd00jRXZ8Z:RXZ:RP02LG5a00=/K6anOWinOWh00YRHV003Zj^[
Xj>SXj>S009dM7@00eaLG9JFUYJFUP02fMWI00?EeMFVYZJVYZH00WMgM`03HV9RNWYjNWYj00:PX:02
Zj^[00>IVIUdM7AdM7@00UiNGP03MGEeV9RHV9RH00:HV9P00hZ:RXJ6QXJ6QP02Q8B400=iNGUhN7Qh
N7P00Xn?S`03YJFUWinOWinO00:9RHT00g=cLfi^KVi^KP02RHV900>SXj>EUIFEUID00X61P@03T92@
W9bLW9bL00:2PX800f=SHeiNGUiNGP02LG5a00>IVIVYZJVYZJT00WMgM`03BDU9IfMWIfMW00:NWYh0
0jn_[iZJVYZJVP02JFUY00=2@T9=CDe=CDd00WAdM003UYJFY:BTY:BT00:BTY800gUiNGalO7alO002
Ogmo00=LG5a=CDe=CDd00XZ:RP03`l?3Zj^[Zj^[009eMGD00f1PH71`L71`L002YJFU00?2`/:4Q8B4
Q8@00TA4A003Hf=SWinOWinO00:/[:`00iVIVG5aLG5aL@02I6AT0ZNWY`03dm?CM7AdM7Ad008M7Ad0
0fYZJ]GEeMGEe@02bLW900=nOWhl?3`l?3`00R@T9003EUIFUiNGUiNG00:IVIT00hN7QibLW9bLW002
^[Zj00>k^k^`/;2`/;000[6a/@03Xj>SJ6QXJ6QX009=CDd00ijNW^?Shn?Sh`02WIfM00=:BTYhN7Qh
N7P00[jn_P03XZ:RLG5aLG5a009oOgl00iFEUGemOGemO@04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0W1`L003Rh^;SXj>SXj>00:0P8000g9bLWYjNWYjNP02SHf=00>IVIVFUYJFUYH00X20
P003e=CDZ:RXZ:RX00:4Q8@3LW9b0X20P0><S8`2RHV900>;Rh/V9RHV9RH00]7Ad@03LG5a@D51@D51
009mOGd00gMgMi:BTY:BTP02=3@d00>g]kNLW9bLW9`00WUiN@9`L7000h20P:6QXJ6QX@02?3`l00>R
XZ:5QHF5QHD00X:2PP03RXZ:R8R8R8R800:4Q8@00hZ:RXf=SHf=S@02PH6100=kNg^;Rh^;Rh/00Z>S
X`03>SXj/K6a/K6a00:ATI400gAdM7alO7alO002SXj>00>4Q8AkNg]kNg/00Y2@T003ZJVY<S8b<S8b
00:NWYh00h:2PWalO7alO002[:b/00=MGEfl_;bl_;`00X^;R`03N7QhR8R8R8R800:c/k<00emOGeYJ
FUYJFP02/k>c00>ATI5lO7alO7`00X20P003SHf=QhN7QhN700:7QhL00j^[ZlS8b<S8b002/K6a00>P
X:1EEEEEEED00Xf=S@03UIFEKfm_Kfm_00:PX:000gEeMJJVYZJVYP02K6a/00=QHF4f=SHf=SH00ifM
W@8f=SH2][Jf0XZ:RP03Ng]kHf=SHf=S00:d];@00fi^KWinOWinOP02LW9b00>MWIe?Cdm?Cdl00UmO
G`03/K6aPX:2PX:200:;Rh/00jNWYj:RXZ:RXP02SXj>00>6QXJ1PH61PH400W=cL`03O7al_;bl_;bl
009cLg<00da<C9jNWYjNWP02emOG00>EUIELG5aLG5`00XV9R@03Shn?<c<c<c<c00:LW9`00i2@T;Jf
][Jf]P04oooo00<0003oooooool04?ooo`009Oooo`800003oooo0UmOG`03HF5QMgMgMgMg00:BTY80
0ijNWXZ:RXZ:RP02K6a/00=PH61[Jf][Jf/00XR8R003ZJVY_[jn_[jn00:m_Kd00jRXZ8Z:RXZ:RP02
LG5a00=/K6anOWinOWh00YRHV003Zj^[Xj>SXj>S009dM7@00eaLG9JFUYJFUP02fMWI00?EeMFVYZJV
YZH00WMgM`03HV9RNWYjNWYj00:PX:02Zj^[00>IVIUdM7AdM7@00UiNGP03MGEeV9RHV9RH00:HV9P0
0hZ:RXJ6QXJ6QP02Q8B400=iNGUhN7QhN7P00Xn?S`03YJFUWinOWinO00:9RHT00g=cLfi^KVi^KP02
RHV900>SXj>EUIFEUID00X61P@03T92@W9bLW9bL00:2PX800f=SHeiNGUiNGP02LG5a00>IVIVYZJVY
ZJT00WMgM`03BDU9IfMWIfMW00:NWYh00jn_[iZJVYZJVP02JFUY00=2@T9=CDe=CDd00WAdM003UYJF
Y:BTY:BT00:BTY800gUiNGalO7alO002Ogmo00=LG5a=CDe=CDd00XZ:RP03`l?3Zj^[Zj^[009eMGD0
0f1PH71`L71`L002YJFU00?2`/:4Q8B4Q8@00TA4A003Hf=SWinOWinO00:/[:`00iVIVG5aLG5aL@02
I6AT0ZNWY`03dm?CM7AdM7Ad008M7Ad00fYZJ]GEeMGEe@02bLW900=nOWhl?3`l?3`00R@T9003EUIF
UiNGUiNG00:IVIT00hN7QibLW9bLW002^[Zj00>k^k^`/;2`/;000[6a/@03Xj>SJ6QXJ6QX009=CDd0
0ijNW^?Shn?Sh`02WIfM00=:BTYhN7QhN7P00[jn_P03XZ:RLG5aLG5a009oOgl00iFEUGemOGemO@03
oooo0P0003Coool010000?ooooooooooo`9`L7000h^;Rhj>SXj>SP02P82000=bLW9jNWYjNWX00Xf=
S@03VIVIUYJFUYJF00:0P8000mCDe:RXZ:RXZ002Q8B40g9bLP:0P803S8b<0XV9R@03Rh^;9RHV9RHV
00;AdM400g5aLD51@D51@@02OGem00=gMgNBTY:BTY800S@d=003]kNgW9bLW9bL009iNGT2L71`00>0
P82QXJ6QXJ400S`l?003XZ:RQHF5QHF500:2PX800hZ:RXR8R8R8R002Q8B400>:RXZ=SHf=SHd00X61
P@03Ng]kRh^;Rh^;00:SXj<00cXj>[6a/K6a/@02TI6A00=dM7AlO7alO7`00Xj>SP03Q8B4Ng]kNg]k
00:@T9000jVYZC8b<S8b<P02WYjN00>2PX9lO7alO7`00Zb/[003GEeM_;bl_;bl00:;Rh/00gQhN8R8
R8R8R002/k>c00=OGemJFUYJFUX00[>c/`03TI6AO7alO7al00:0P8000hf=SHN7QhN7Q`02QhN700>[
Zj_8b<S8b<P00[6a/@03X:2PEEEEEEEE00:=SHd00iFEUFm_Kfm_K`02X:2P00=eMGFVYZJVYZH00Va/
K003HF5Q=SHf=SHf00>MWId2=SHf0[Jf]P::RXX00g]kNf=SHf=SH`02];Bd00=^KVinOWinOWh00W9b
LP03WIfMCdm?Cdm?009OGel00k6a/H:2PX:2PP02Rh^;00>WYjNRXZ:RXZ800Xj>SP03QXJ6PH61PH61
009cLg<00galO;bl_;bl_002Lg=c00=<C4bNWYjNWYh00]OGe`03UIFEG5aLG5aL00:9RHT00hn?Sc<c
<c<c<`02W9bL00>@T92f][Jf][H00oooo`80000Boooo000Uoooo00<0003oooooool00_ooo`9UIFD0
0eeMGGAdM7AdM002UYJF00>ZZZZFUYJFUYH00W5aL@03HV9RJVYZJVYZ00:0P8000inOWkno_kno_`02
_[jn00>3Ph=:BTY:BTX00U9BDP03O7alVIVIVIVI00:RXZ800iRHV7YjNWYjNP02Bd];00<n?SilO7al
O7`00[no_`03_KfmVIVIVIVI00:;Rh/00hZ:RX^;Rh^;R`02T92@0Y^KV`03UYJFLG5aLG5a009HF5P0
0gEeMIfMWIfMW@02WIfM00>;Rh^8R8R8R8P00XR8R003OGemO7alO7al00:EUID00jRXZ9FEUIFEU@02
MgMg00=_KfmhN7QhN7P00Xb<S003VYZJTY:BTY:B00:4Q8@00hF5QHZ:RXZ:RP02QhN700=lO7aWIfMW
IfL00VMWI`03VYZJ^;Rh^;Rh009iNGT00cPh>5UIFEUIF@02Vi^K00>][JfNWYjNWYh00XZ:RP03Ng]k
OGemOGem00:=SHd00ifMWJ6QXJ6QX@02S8b<00=gMgN0P820P8000XN7Q`03I6ATEUIFEUIF00:HV9P0
0mSHf;no_kno_`02OWin00=@D51;Bd];Bd/00WUiN@03[Jf][:b/[:b/00:JVYX00jBTY;:b/[:b/P02
[:b/00>IVIUeMGEeMGD00V][J`:/[:`00mWIfH^;Rh^;R`02@D5100>3Ph?Fe]KFe]H00[Bd]003I6AT
>c/k>c/k008j>SX00eiNGWalO7alO002HV9R00<o?cm?Cdm?Cdl00WUiN@03V9RHY:BTY:BT00:IVIT0
0hN7Qh61PH61P@02Q8B400>;Rh^7QhN7QhL00VQXJ003FEUIRHV9RHV900:f][H00iNGUg5aLG5aL@02
UIFE00>j^[ZHV9RHV9P01?ooo`030000oooooooo03;oool010000?ooooooooooo`9[Jf/00hb<S8f=
SHf=S@02MWIf00?IfMUVIVIVIVH00WalO003RHV9QXJ6QXJ6009eMGD00e=CDb8R8R8R8P02P82000>E
UIFa/K6a/K400ZNWY`03Rh^;PH61PH6100::RXX00j:RX/W9bLW9b@02P82000>?ShmKFe]KFe/00YFE
U@03S8b<W9bLW9bL00:LW9`00i:BTX^;Rh^;R`02PX:20WUiN@03P820XZ:RXZ:R0090@4000j>SXh:2
PX:2PP02P82000>;Rh^8R8R8R8P00X>3P`03RHV9Rh^;Rh^;009oOgl00gemOIVIVIVIV@02]kNg00=2
@T:YZJVYZJT00Xf=S@03MgMgNWYjNWYj00:6QXH00hN7QhF5QHF5Q@02QHF500>;Rh^JVYZJVYX00YjN
WP03OGemLG5aLG5a00:a/K400gAdM5IFEUIFEP02TY:B00=jNWZ1PH61PH400YBDU003YjNW<S8b<S8b
00:PX:000hf=SGmoOgmoO`02QHF500>>SXj2PX:2PX800WinOP03XJ6Q@d=3@d=3008V9RH00hZ:R[Zj
^[Zj^P02Ph>300>QXJ6@T92@T9000Tm?C`03S8b<RXZ:RXZ:00:RXZ800jJVYZ2PX:2PX002Vi^K00>J
VYX_;bl_;bl00Zb/[0:2PX800gAdM51@D51@D002V9RH00?EeMEoOgmoOgl00XF5Q@03/k>cCdm?Cdm?
00;5aLD00jNWYi>CTi>CT`02>SXj00=SHf=QHF5QHF400T92@P03Vi^KPX:2PX:2009mOGd00hZ:RYnO
WinOW`02]kNg00=DE5AZJVYZJVX00XR8R003S8b<EUIFEUIF00:JVYX00jBTY;Jf][Jf]P02TI6A00=e
MGFQXJ6QXJ401?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0VEUI@03GEeM
M7AdM7Ad00:FUYH00jZZZYJFUYJFUP02LG5a00=RHV9ZJVYZJVX00X20P003WinO_kno_kno00:n_[h0
0h>3PdY:BTY:BP02DU9B00=lO7bIVIVIVIT00Z:RXP03V9RHNWYjNWYj009;Bd/00chn?WalO7alO002
_kno00>m_KfIVIVIVIT00X^;R`03RXZ:Rh^;Rh^;00:@T902Vi^K00>FUYIaLG5aLG400UQHF003MGEe
WIfMWIfM00:MWId00h^;RhR8R8R8R002R8R800=mOGelO7alO7`00YFEU@03Z:RXUIFEUIFE009gMgL0
0fm_KgQhN7QhN002S8b<00>JVYZBTY:BTY800XB4Q003QHF5RXZ:RXZ:00:7QhL00galO6MWIfMWI`02
IfMW00>JVYZh^;Rh^;P00WUiN@03>3PhFEUIFEUI00:KVi/00jf][IjNWYjNWP02RXZ:00=kNg]mOGem
OGd00Xf=S@03WIfMXJ6QXJ6Q00:<S8`00gMgMh20P820P002QhN700=TI6AFEUIFEUH00YRHV003f=SH
_kno_kno009nOWh00e1@D4];Bd];B`02NGUi00>][Jf/[:b/[:`00YZJVP03Y:BT/[:b/[:b00:/[:`0
0iVIVGEeMGEeM@02Jf][0Zb/[003fMWIRh^;Rh^;0091@D400h>3PmKFe]KFeP02];Bd00=TI6@k>c/k
>c/00SXj>P03GUiNO7alO7al009RHV800clo?dm?Cdm?C`02NGUi00>HV9RTY:BTY:@00YVIV@03QhN7
PH61PH6100:4Q8@00h^;RhN7QhN7Q`02J6QX00=IFEV9RHV9RHT00[Jf]P03UiNGLG5aLG5a00:EUID0
0kZj^YRHV9RHV004oooo00<0003oooooool0<_ooo`040000oooooooooooo0V][J`03S8b<SHf=SHf=
009fMWH00mWIfFIVIVIVIP02O7al00>9RHV6QXJ6QXH00WEeM@03De=C8R8R8R8R00:0P8000iFEUK6a
/K6a/@02YjNW00>;Rh^1PH61PH400XZ:RP03XZ:RbLW9bLW900:0P8000hn?Se]KFe]KF`02UIFE00><
S8bLW9bLW9`00YbLW003TY:BRh^;Rh^;00:2PX82NGUi00>0P82RXZ:RXZ800T10@003Xj>SPX:2PX:2
00:0P8000h^;RhR8R8R8R002Ph>300>9RHV;Rh^;Rh/00WmoO`03OGemVIVIVIVI00:g]kL00d92@ZVY
ZJVYZ@02SHf=00=gMgMjNWYjNWX00XJ6QP03QhN7QHF5QHF500:5QHD00h^;RiZJVYZJVP02WYjN00=m
OGeaLG5aLG400[6a/@03M7AdEUIFEUIF00:BTY800gYjNX61PH61P@02U9BD00>WYjLb<S8b<S800Z2P
X003SHf=OgmoOgmo00:5QHD00hj>SX:2PX:2PP02OWin00>QXJ53@d=3@d<00RHV9P03RXZ:^[Zj^[Zj
00:3Ph<00j6QXI2@T92@T002Cdm?00><S8b:RXZ:RXX00Z:RXP03YZJVX:2PX:2P00:KVi/00iZJVRl_
;bl_;`02[:b/0X:2PP03M7AdD51@D51@00:HV9P00mGEeGmoOgmoO`02QHF500>c/k=?Cdm?Cdl00/G5
a@03YjNWTi>CTi>C008j>SX00f=SHf5QHF5QH@02@T9200>KVi^2PX:2PX800WemO@03RXZ:WinOWinO
00:g]kL00eADE6YZJVYZJP02R8R800><S8aFEUIFEUH00YZJVP03Y:BT][Jf][Jf00:ATI400gEeMJ6Q
XJ6QX@04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2Kfm_00=PH61dM7Ad
M7@00YNGU`03[jn_Vi^KVi^K009iNGT00g5aLGUiNGUiN@02MgMg00=lO7bJVYZJVYX00YfMW@03EEEE
7AdM7AdM009ADE400j:RX[:b/[:b/P02TY:B00=UIFE0@410@4000Shn?P03De=CJf][Jf][009jNWX0
0gMgMgQhN7QhN002Ti>C00>XZ:R@T92@T9000W=cL`:1PH400i6ATGEeMGEeM@02GEeM00=lO7bRXZ:R
XZ800Y^KV`03Q8B4PH61PH6100:4Q8@3NWYj0YRHV003[:b/RXZ:RXZ:009RHV800fQXJ861PH61P@02
R8R800>6QXJ3Ph>3Ph<00h20P0:2PX82QhN700>5QHEcLg=cLg<00Vm_K`03W9bL^;Rh^;Rh00:2PX80
0dI6AUaLG5aLG002Shn?00>NWYjKVi^KVi/00YfMW@03X:2PY:BTY:BT00:WYjL00j:RXYNGUiNGU`02
QHF500=hN7R1PH61PH400XN7Q`03K6a/IFEUIFEU00:PX:000mSHf<C4a<C4a002Ph>300=6ATH/;2`/
;2`00TY:BP03Rh^;alO7alO700;Ti>@00m?CdjVYZJVYZ@02QHF500=bLW9aLG5aLG400XB4Q0:ZZZX0
0kbl_9JFUYJFUP02LW9b00>BTY:d];Bd];@00Xf=S@03FUYJG5aLG5aL009gMgL00hJ6QW]kNg]kN`02
C4a<00<L71`F5QHF5QH00S@d=003JVYZSXj>SXj>009eMGD00eeMGH^;Rh^;R`02/[:b00=oOgll?3`l
?3`00SXj>P03GemOSHf=SHf=00:TY:@00h:2PVMWIfMWI`02Vi^K00??cln/[:b/[:`01?ooo`030000
oooooooo03;oool010000?ooooooooooo`9XJ6P00hb<S8^;Rh^;R`02Kfm_00?<c<aDE5ADE5@00]gM
g@03HV9RFEUIFEUI00;AdM400dm?CjNWYjNWY`02VIVI00=BDU9jNWYjNWX00U1@D003Rh^;QHF5QHF5
00:WYjL00eaLG8:2PX:2PP02RXZ:00=jNW[MgMgMgMd00U5AD@03`/;2?3`l?3`l00:BTY800gEeMH20
P820P002Ti>C0XV9R@03PH61WYjNWYjN00:e]KD00ifMWGalO7alO002OWin00><S8b8R8R8R8P00X61
P@03QhN7Rh^;Rh^;009lO7`00g]kNjBTY:BTY002c<c<00=9BDVRXZ:RXZ800Xb<S003Ph>3PH61PH61
00:6QXH00hZ:RXV9RHV9R@02PX:200=mOGf9RHV9RHT00Xn?S`03N7QhLg=cLg=c00:b/[800g9bLUeM
GEeMG@02X:2P00>6QXIoOgmoOgl00WemO@03PX:2QHF5QHF500:6QXH3QHF50XZ:RP03S8b<OgmoOgmo
009iNGT00i>CTjJVYZJVYP02SXj>00=nOWjZZZZZZZX00W=cL`03X:2PXZ:RXZ:R009bLW800jBTY6m_
Kfm_K`02GemO00=eMGFLW9bLW9`00SPh>003/k>cZ:RXZ:RX00:EUID2PH6100>6QXJi^KVi^KT00VIV
IP03AdM7UIFEUIFE00:RXZ800d51@K2`/;2`/002UiNG00<B4Q:JVYZJVYX00/S8b003OWinRh^;Rh^;
009dM7@00k^k^i6ATI6AT@02Vi^K00>][JfBTY:BTY800XJ6QP03C4a<UIFEUIFE00:QXJ400h>3PeYJ
FUYJFP02^;Rh00?7alMFEUIFEUH00YZJVP03Kfm_VIVIVIVI00Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`9NGUh00eQHF75aLG5aL@02RXZ:00>HV9R>SXj>SXh00WalO003NGUi
P820P82000:2PX800h>3PhZ:RXZ:RP02Ph>300=NGUi>CTi>CTh00X:2PP03]kNgZZZZZZZZ009hN7P0
0dQ8B3Ph>3Ph>002I6AT00>?ShmiNGUiNGT00U9BDP03EUIFM7AdM7Ad00:BTY800j2PX8N7QhN7Q`02
KFe]0WemO@03Ti>CPh>3Ph>3009aLG400h>3PiZJVYZJVP02T92@00=mOGelO7alO7`00WinOP=^KVh2
VIVI00>k^k^NWYjNWYh00W1`L003JFUYMWIfMWIf009nOWh00h61PGUiNGUiN@02Lg=c00=mOGf8R8R8
R8P00XJ6QP03Ng]kKFe]KFe]009`L7000iVIVKRh^;Rh^002XJ6Q00=hN7Q[Jf][Jf/00WEeM@03TI6A
X:2PX:2P00:4Q8@00fMWIgUiNGUiN@02VIVI00>OWinDU9BDU9@00XN7Q`03O7alMgMgMgMg009fMWH0
0g9bLWIfMWIfMP02RHV900>IVIVDU9BDU9@00WmoO`03HF5QD51@D51@009LG5`00gUiNI:BTY:BTP02
WYjN00>LW9b5QHF5QHD00UaLG003A4A4G5aLG5aL00:;Rh/2/[:b00>j^[ZBTY:BTY800VQXJ003K6a/
QhN7QhN700:ATI400hj>SX61PH61P@02O7al00>ATI6PX:2PX:000XB4Q003GUiND51@D51@009OGel0
0hf=SJZZZZZZZP02PH6100=HF5R0P820P8000Zn_[`03Ti>CH61PH61P009=CDd00eQHF7emOGemO@02
U9BD00=bLW9HF5QHF5P00Xn?S`03a<C4WIfMWIfM00Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2O7al00>EUIF;Rh^;Rh/00W=cL`03FUYJCdm?Cdm?00;5aLD00clo?jZZZZZZZP02XZ:R0j6Q
X@:_[jl00emOGnk^k^k^kP02CTi>00>KVi^TY:BTY:@00U=CD`03Ng]kRHV9RHV9009WIfL00d92@/W9
bLW9b@02JVYZ00=NGUje]KFe]KD00Xn?S`03MgMgP820P82000:ATI42QXJ600=kNg^@T92@T9000R`/
;003UYJFP820P82000:2PX800h^;RhJ6QXJ6QP02P82000><S8bBTY:BTY800W]kN`03Kfm_UYJFUYJF
0099BDT00dY:BZZZZZZZZP02TY:B00>3Ph>5QHF5QHD00Xj>SP03Rh^;Q8B4Q8B400:1PH400h:2PXR8
R8R8R002R8R800=gMgMdM7AdM7@00YfMW@03b/[:F5QHF5QH00:i^KT00i2@T7IfMWIfMP02Rh^;00>Y
ZJVQXJ6QXJ400XZ:RP03PX:2Q8B4Q8B400:6QXH00hN7QhF5QHF5Q@02PX:200>7QhN?Shn?Shl00YFE
U@03Xj>SAdM7AdM7009WIfL00galO7UiNGUiN@02FUYJ00>[Zj^BTY:BTY800Xf=S@03UYJFZj^[Zj^[
009>CTh00m7AdC`l?3`l?002SXj>0WIfMP03P820/;2`/;2`009QHF400m?CdcPh>3Ph>002VYZJ00>A
TI6GUiNGUiL00Y^KV`03S8b<Q8B4Q8B400:NWYh00l71`EIFEUIFEP02`l?300>HV9QiNGUiNGT00Q`L
7003?3`lVYZJVYZJ009nOWh00j6QXF5QHF5QH@02n?Sh00>2PX9]KFe]KFd00U]KF`03KVi^MWIfMWIf
008l?3`00hJ6Q[2`/;2`/004oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
GUiN00=HF5QaLG5aLG400XZ:RP03V9RHSXj>SXj>009lO7`00gUiNH20P820P002PX:200>3Ph>:RXZ:
RXX00X>3P`03GUiNCTi>CTi>00:2PX800kNg]jZZZZZZZP02N7Qh00=8B4Ph>3Ph>3P00VATI003Shn?
NGUiNGUi009BDU800eIFEWAdM7AdM002TY:B00>PX:27QhN7QhL00Ve]K@9mOGd00i>CTh>3Ph>3P`02
LG5a00>3Ph>JVYZJVYX00Y2@T003OGemO7alO7al009nOWh3KVi^0YVIV@03^k^kWYjNWYjN009`L700
0fUYJGIfMWIfMP02OWin00>1PH5iNGUiNGT00W=cL`03OGemR8R8R8R800:6QXH00g]kNfe]KFe]K@02
L71`00>IVIVh^;Rh^;P00Z6QX@03N7QhJf][Jf][009eMGD00i6ATJ2PX:2PX002Q8B400=WIfMiNGUi
NGT00YVIV@03WinOU9BDU9BD00:7QhL00galO7MgMgMgM`02MWIf00=bLW9fMWIfMWH00XV9R@03VIVI
U9BDU9BD009oOgl00f5QHE1@D51@D002G5aL00=iNGVBTY:BTY800YjNWP03W9bLQHF5QHF5009LG5`0
0dA4A5aLG5aLG002Rh^;0[:b/P03^[ZjTY:BTY:B009XJ6P00fa/K8N7QhN7Q`02TI6A00>>SXj1PH61
PH400WalO003TI6AX:2PX:2P00:4Q8@00eiNGU1@D51@D002GemO00>=SHfZZZZZZZX00X61P@03F5QH
P820P82000:_[jl00i>CTf1PH61PH002CDe=00=HF5QmOGemOGd00YBDU003LW9bF5QHF5QH00:?Shl0
0lC4a9fMWIfMW@04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WalO003UIFERh^;Rh^;
009cLg<00eYJFTm?Cdm?C`02aLG500<o?cnZZZZZZZX00Z:RXP>QXJ42[jn_00=OGeo^k^k^k^h00Ti>
CP03Vi^KY:BTY:BT009CDe<00g]kNhV9RHV9R@02IfMW00=2@T;9bLW9bLT00VYZJP03GUiN]KFe]KFe
00:?Shl00gMgMh20P820P002TI6A0XJ6QP03Ng]kT92@T92@008/;2`00iJFUX20P820P002PX:200>;
Rh^6QXJ6QXH00X20P003S8b<TY:BTY:B009kNg/00fm_KiJFUYJFUP02BDU900=:BTZZZZZZZZX00Y:B
TP03Ph>3QHF5QHF500:>SXh00h^;RhB4Q8B4Q002PH6100>2PX:8R8R8R8P00XR8R003MgMgM7AdM7Ad
00:MWId00l[:bUQHF5QHF002^KVi00>@T91fMWIfMWH00X^;R`03ZJVYXJ6QXJ6Q00::RXX00h:2PXB4
Q8B4Q002QXJ600>7QhN5QHF5QHD00X:2PP03QhN7Shn?Shn?00:EUID00j>SXdM7AdM7A`02IfMW00=l
O7aiNGUiNGT00UYJFP03Zj^[TY:BTY:B00:=SHd00iJFUZ^[Zj^[Z`02CTi>00?AdM4l?3`l?3`00Xj>
SP9fMWH00h20P;2`/;2`/002HF5Q00?Cdm<h>3Ph>3P00YZJVP03TI6AUiNGUiNG00:KVi/00hb<S8B4
Q8B4Q002WYjN00?1`L5FEUIFEUH00/?3``03V9RHNGUiNGUi008L71`00c`l?9ZJVYZJVP02OWin00>Q
XJ5QHF5QHF400_Shn003PX:2KFe]KFe]009KFe/00fi^KWIfMWIfMP02?3`l00>6QXJ`/;2`/;001?oo
o`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0Tm?C`03F5QHN7QhN7Qh00>2PX82
Q8B40X:2PP03MWIfLg=cLg=c00:7QhL00iRHV8V9RHV9R@02N7Qh00>2PX:IVIVIVIT00ZRXZ003YJFU
SXj>SXj>009_Kfl00e5ADEIFEUIFEP02V9RH00?7alNEUIFEUID00U1@D003EEEENWYjNWYj00>;Rh/2
OWin0W9bLP9mOGd00hf=SHV9RHV9R@02PX:200>9RHV@T92@T9000XN7Q`03NGUiN7QhN7Qh009gMgL0
0fMWIfQXJ6QXJ002UIFE00>l_;bXZ:RXZ:P00WinOP03KVi^LG5aLG5a009kNg/00hB4Q7UiNGUiN@02
L71`00>0P82?Shn?Shl00XF5Q@03LG5aIFEUIFEU009]KFd00hj>SZj^[Zj^[P02]kNg00>SXj=cLg=c
Lg<00UMGE`03PH61Y:BTY:BT009`L7000c8b<TA4A4A4A002MWIf00>?ShnDU9BDU9@00Xj>SP03Ogmo
KFe]KFe]009WIfL00gMgMh>3Ph>3P`02Lg=c00=OGemYJFUYJFT00WemO@>3Ph<2Q8B400=kNg]JFUYJ
FUX00TE5A@03HF5QMWIfMWIf009<C4`00bPX:4a<C4a<C002SXj>0[Jf]P03];BdP820P820009:BTX0
0dM7Afa/K6a/K002XZ:R00>l_;bDU9BDU9@00VYZJP03Rh^;_kno_kno00;1`L400jj^[ZJVYZJVYP02
YjNW0kBd]0:<S8`00fMWIg5aLG5aL@02TY:B00>XZ:RTY:BTY:@00WUiN@03EeMGLW9bLW9b00:CTi<0
0g9bLU9BDU9BDP02OGem00>WYjN2PX:2PX801?ooo`030000oooooooo03;oool010000?oooooooooo
o`:ATI400iNGUh:2PX:2PP02LG5a00=OGeo0`<30`<000S8b<P03Y:BTW9bLW9bL00:7QhL00ginOYZJ
VYZJVP02_[jn00=BDU;9bLW9bLT00TQ8B003`<30D51@D51@009QHF400ng]kFa/K6a/K002[Jf]00>3
Ph>YZJVYZJT00VATI003FUYJ[Jf][Jf]00:BTY800hF5QHB4Q8B4Q002QhN70X61P@03O7alRHV9RHV9
00:FUYH00i2@T8B4Q8B4Q002QHF500>9RHV4Q8B4Q8@00X:2PP03SXj>Ti>CTi>C009lO7`00fi^KXn?
Shn?S`02^;Rh00=6ATJ^[Zj^[Zh00Y>CT`03OgmoQ8B4Q8B400:@T9000hZ:RX20P820P002Ph>300>:
RXZ<S8b<S8`00XR8R003OGemNg]kNg]k00:;Rh/00bl_;lc<c<c<c002FEUI00>MWIebLW9bLW800YZJ
VP03EeMGCdm?Cdm?00:RXZ800h^;Rh61PH61P@02Ogmo00>4Q8B<S8b<S8`00Xf=S@03P820OWinOWin
00:NWYh00de=CMKFe]KFeP02FEUI00=ADE6l_;bl_;`00ZRXZ003XJ6Q?clo?clo00;>c/h00dA4A:n_
[jn_[`02E5AD00=[Jf^o_kno_kl00XV9R@9_Kfl00ginO[Fe]KFe]@02KVi^00=_Kfo1`L71`L400XZ:
RP03KFe]Rh^;Rh^;008f=SH00iRHV71`L71`L002Kfm_00=nOWj3Ph>3Ph<00WmoO`03LW9bLG5aLG5a
00:ATI400jj^[ZFUYJFUY@02S8b<00=nOWj<S8b<S8`00TU9B@03O7alNWYjNWYj009ZJVX00h:2PXn?
Shn?S`02e]KF00>/[:aHF5QHF5P01?ooo`030000oooooooo013oool001[oool300000oooo`030000
oooooooo00;oool00`000?ooooooo`02oooo0Tm?C`03F5QHN7QhN7Qh00>2PX82Q8B40X:2PP03MWIf
Lg=cLg=c00:7QhL00iRHV8V9RHV9R@02N7Qh00>2PX:IVIVIVIT00ZRXZ003YJFUSXj>SXj>009_Kfl0
0e5ADEIFEUIFEP02V9RH00?7alNEUIFEUID00U1@D003EEEENWYjNWYj00>;Rh/2OWin0W9bLP9mOGd0
0hf=SHV9RHV9R@02PX:200>9RHV@T92@T9000XN7Q`03NGUiN7QhN7Qh009gMgL00fMWIfQXJ6QXJ002
UIFE00>l_;bXZ:RXZ:P00WinOP03KVi^LG5aLG5a009kNg/00hB4Q7UiNGUiN@02L71`00>0P82?Shn?
Shl00XF5Q@03LG5aIFEUIFEU009]KFd00hj>SZj^[Zj^[P02]kNg00>SXj=cLg=cLg<00UMGE`03PH61
Y:BTY:BT009`L7000c8b<TA4A4A4A002MWIf00>?ShnDU9BDU9@00Xj>SP03OgmoKFe]KFe]009WIfL0
0gMgMh>3Ph>3P`02Lg=c00=OGemYJFUYJFT00WemO@>3Ph<2Q8B400=kNg]JFUYJFUX00TE5A@03HF5Q
MWIfMWIf009<C4`00bPX:4a<C4a<C002SXj>0[Jf]P03];BdP820P820009:BTX00dM7Afa/K6a/K002
XZ:R00>l_;bDU9BDU9@00VYZJP03Rh^;_kno_kno00;1`L400jj^[ZJVYZJVYP02YjNW0kBd]0:<S8`0
0fMWIg5aLG5aL@02TY:B00>XZ:RTY:BTY:@00WUiN@03EeMGLW9bLW9b00:CTi<00g9bLU9BDU9BDP02
OGem00>WYjN2PX:2PX801?ooo`030000oooooooo02Koool300000oooo`030000oooooooo00?oool0
10000?ooooooooooo`:ATI400iNGUh:2PX:2PP02LG5a00=OGeo0`<30`<000S8b<P03Y:BTW9bLW9bL
00:7QhL00ginOYZJVYZJVP02_[jn00=BDU;9bLW9bLT00TQ8B003`<30D51@D51@009QHF400ng]kFa/
K6a/K002[Jf]00>3Ph>YZJVYZJT00VATI003FUYJ[Jf][Jf]00:BTY800hF5QHB4Q8B4Q002QhN70X61
P@03O7alRHV9RHV900:FUYH00i2@T8B4Q8B4Q002QHF500>9RHV4Q8B4Q8@00X:2PP03SXj>Ti>CTi>C
009lO7`00fi^KXn?Shn?S`02^;Rh00=6ATJ^[Zj^[Zh00Y>CT`03OgmoQ8B4Q8B400:@T9000hZ:RX20
P820P002Ph>300>:RXZ<S8b<S8`00XR8R003OGemNg]kNg]k00:;Rh/00bl_;lc<c<c<c002FEUI00>M
WIebLW9bLW800YZJVP03EeMGCdm?Cdm?00:RXZ800h^;Rh61PH61P@02Ogmo00>4Q8B<S8b<S8`00Xf=
S@03P820OWinOWin00:NWYh00de=CMKFe]KFeP02FEUI00=ADE6l_;bl_;`00ZRXZ003XJ6Q?clo?clo
00;>c/h00dA4A:n_[jn_[`02E5AD00=[Jf^o_kno_kl00XV9R@9_Kfl00ginO[Fe]KFe]@02KVi^00=_
Kfo1`L71`L400XZ:RP03KFe]Rh^;Rh^;008f=SH00iRHV71`L71`L002Kfm_00=nOWj3Ph>3Ph<00Wmo
O`03LW9bLG5aLG5a00:ATI400jj^[ZFUYJFUY@02S8b<00=nOWj<S8b<S8`00TU9B@03O7alNWYjNWYj
009ZJVX00h:2PXn?Shn?S`02e]KF00>/[:aHF5QHF5P01?ooo`030000oooooooo013oool001[oool0
0`000?ooooooo`02oooo00<0003oool000000oooo`030000oooooooo00;oool2GemO00=aLG6?Shn?
Shl00Y>CT`03SXj>Ti>CTi>C00:<S8`00fEUIDa<C4a<C002KVi^00>IVIV?Shn?Shl00WemO@03VYZJ
[jn_[jn_00:6QXH00e]KFfm_Kfm_K`02TY:B00>;Rh^4Q8B4Q8@00Zf][@03c<c<Zj^[Zj^[009iNGT0
0fYZJWAdM7AdM002Ph>300><S8b2PX:2PX800W5aL@9/K6`00fm_KgEeMGEeM@02OWin00>:RXZ@T92@
T9000XR8R003Ng]kLW9bLW9b009`L7000g5aLGYjNWYjNP02SXj>00>EUIElO7alO7`00VATI003LG5a
RXZ:RXZ:00:>SXh00hR8R8N7QhN7Q`02RHV900>7QhN4Q8B4Q8@00X61P@03NWYjKVi^KVi^009/K6`0
0gemOIBDU9BDU002XZ:R00>FUYIQHF5QHF400Slo?`03JVYZWYjNWYjN00:ATI400fMWIe5ADE5AD@02
EEEE00=dM7BBTY:BTY800Y2@T003O7alKVi^KVi^009^KVh00h20P8f=SHf=S@02OGem00=YJFUeMGEe
MGD00XV9R@03R8R8PX:2PX:200::RXX00hb<S75aLG5aL@02Hf=S00>@T92/[:b/[:`00Vi^KP03<S8b
Fe]KFe]K00:OWil2YZJV00>6QXIOGemOGel00TU9B@03FEUIOWinOWin00:KVi/00inOWh:2PX:2PP02
Jf][00>4Q8BYZJVYZJT00Zb/[003Xj>S[Jf][Jf]00:][Jd00hR8R69RHV9RHP02HF5Q00=aLG5eMGEe
MGD00WalO003Vi^KZj^[Zj^[00::RXX00fa/K8R8R8R8R002YjNW00>8R8QTI6ATI6@00WIfMP03Shn?
N7QhN7Qh00Coool00`000?ooooooo`0Voooo00<0003oooooool00_ooo`030000oooo000000Coool0
10000?ooooooooooo`::RXX00hB4Q6][Jf][J`02dm?C00?1`L6TY:BTY:@00YFEU@03ZJVY@410@410
00:PX:000`d=3J2PX:2PX002BTY:00=6ATI1@D51@D400]kNgP03P820I6ATI6AT00:d];@00k>c/cXj
>SXj>P02Shn?00=cLg>=SHf=SHd00[Bd]003_[jn=SHf=SHf00:HV9P00hB4Q7moOgmoO`02QhN70Xj>
SP03Ti>CUiNGUiNG00:FUYH00hb<S8>3Ph>3P`02Ph>300>7QhN8R8R8R8P00XJ6QP03Q8B4Ph>3Ph>3
00:1PH400hb<S;6a/K6a/@02cLg=00=3@d>IVIVIVIT00XF5Q@03O7alNWYjNWYj009nOWh00hJ6QXb<
S8b<S002RHV900>4Q8B7QhN7QhL00hZ:RP:=SHd2UYJF00>][JeLG5aLG5`00Va/K003/k>cO7alO7al
00:4Q8@00jVYZL30`<30`002ADE500>SXj>4Q8B4Q8@00WmoO`03RHV9SXj>SXj>00:;Rh/00g]kNgMg
MgMgM`02U9BD00<o?co3`l?3`l<00[bl_003^KVi=cLg=cLg00:IVIT00hb<S2PX:2PX:002];Bd00>H
V9R5QHF5QHD00[Bd]003Hf=S/[:b/[:b009hN7P2NGUi00>PX:1DE5ADE5@00Vi^KP03f=SH>3Ph>3Ph
00:@T9000hJ6QY^KVi^KV`02/;2`00>NWYj1PH61PH400WinOP03PH61MGEeMGEe009bLW800i6ATKBd
];Bd]002]kNg00>[Zj/Z:RXZ:RX00YRHV003OWinN7QhN7Qh00:YZJT00fIVI^GUiNGUi@02g]kN00=o
OgnATI6ATI400W=cL`03EUIFJf][Jf][00Coool00`000?ooooooo`0@oooo000Koooo00L0003ooooo
ooooool0003oool000000oooo`<00002oooo0WEeM@03QHF5VYZJVYZJ00>QXJ42Z:RX0YVIV@03FUYJ
;Bd];Bd]009FEUH00iFEUI^KVi^KV`02Rh^;00>HV9REUIFEUID00UMGE`03;bl_JVYZJVYZ00>f][H2
WIfM0ZJVYP03]KFeZJVYZJVY00:BTY800gemOGEeMGEeM@02Q8B400>CTi>:RXZ:RXX00WAdM09SHf<0
0eaLG6EUIFEUI@02N7Qh00>9RHVATI6ATI400X^;R`03OGemLW9bLW9b009aLG400g]kNhF5QHF5Q@02
QXJ600=gMgMBDU9BDU800TA4A003MWIf[:b/[:b/00:RXZ800h:2PXJ6QXJ6QP02U9BD00><S8b1PH61
PH400XJ6QP03RHV9NWYjNWYj009[Jf/00fm_KgUiNGUiN@02PH6100=jNWYLG5aLG5`00TU9B@03H61P
SHf=SHf=00:g]kL00k^k^gmoOgmoO`02AdM700=OGen?Shn?Shl00Y2@T003OGemNg]kNg]k009oOgl0
0h:2PXR8R8R8R002TY:B00>HV9RJVYZJVYX00Y:BTP03OGemLG5aLG5a00:2PX800iVIVIFEUIFEU@02
V9RH00?;bl_Rh^;Rh^800Y>CT`03B4Q8KVi^KVi^00:ZZZX2UIFE00=SHf=BDU9BDU800UiNGP03P820
Vi^KVi^K00:=SHd00fi^KVATI6ATI002Jf][00=iNGV4Q8B4Q8@00WUiN@03LW9bTI6ATI6A00:KVi/0
0eIFEQPH61PH6002?Shn00>0P829RHV9RHT00WalO003RHV9U9BDU9BD00:4Q8@00galO9^KVi^KV`02
]KFe00>OWimlO7alO7`00WMgM`03OWinN7QhN7Qh00?oool20000:Oooo`070000oooooooooooo0000
oooo000000Coool200000_ooo`9lO7`00g=cLeaLG5aLG002_[jn00<[:b^6QXJ6QXH00X>3P`03/k>c
IVIVIVIV009ADE400jJVYZj^[Zj^[P02Bd];00?1`L75aLG5aLD00WUiN@03TI6AEEEEEEEE00:5QHD0
0ginOY2@T92@T002QXJ600=kNg^6QXJ6QXH00YZJVP03<C4a[Jf][Jf]00:HV9P00gmoOg]kNg]kN`02
QhN70YJFUP03XZ:R:BTY:BTY00:IVIT00h^;Rh61PH61P@02PX:200>7QhN:RXZ:RXX00XR8R003OWin
Ng]kNg]k00:7QhL00jBTY5UIFEUIF@02KFe]00>h^;QnOWinOWh00WIfMP03Q8B4OgmoOgmo009iNGT0
0hJ6QY:BTY:BTP02RHV900=nOWj3Ph>3Ph<00Xn?S`03UYJFWIfMWIfM00:WYjL00chn?]7AdM7Ad@02
HF5Q00=5ADFCTi>CTi<00W1`L003KVi^XJ6QXJ6Q009EEED00kNg]hV9RHV9R@02PX:200><S8b9RHV9
RHT00X>3P`>2PX82QhN700>BTY:OWinOWil00Zb/[003?Shn];Bd];Bd00:GUiL00galO8:2PX:2PP02
Rh^;00=^KViQHF5QHF400YbLW003EEEEXj>SXj>S009/K6`2Q8B400>l_;aPH61PH6000V1PH003_Kfm
9BDU9BDU00:PX:000k2`/3Xj>SXj>P02[Zj^00>SXj>JVYZJVYX00Z2PX003XJ6QQ8B4Q8B4009kNg/0
0kNg]gIfMWIfMP02GEeM00>RXZ:EUIFEUID00YRHV003RHV9QXJ6QXJ600:ZZZX00eQHF5mOGemOG`02
H61P00=gMgN;Rh^;Rh/00X20P003LG5akno_kno_00?oool200004_ooo`006oooo`070000oooooooo
oooo0000oooo000000?oool00`000?ooooooo`02oooo0WEeM@03QHF5VYZJVYZJ00>QXJ42Z:RX0YVI
V@03FUYJ;Bd];Bd]009FEUH00iFEUI^KVi^KV`02Rh^;00>HV9REUIFEUID00UMGE`03;bl_JVYZJVYZ
00>f][H2WIfM0ZJVYP03]KFeZJVYZJVY00:BTY800gemOGEeMGEeM@02Q8B400>CTi>:RXZ:RXX00WAd
M09SHf<00eaLG6EUIFEUI@02N7Qh00>9RHVATI6ATI400X^;R`03OGemLW9bLW9b009aLG400g]kNhF5
QHF5Q@02QXJ600=gMgMBDU9BDU800TA4A003MWIf[:b/[:b/00:RXZ800h:2PXJ6QXJ6QP02U9BD00><
S8b1PH61PH400XJ6QP03RHV9NWYjNWYj009[Jf/00fm_KgUiNGUiN@02PH6100=jNWYLG5aLG5`00TU9
B@03H61PSHf=SHf=00:g]kL00k^k^gmoOgmoO`02AdM700=OGen?Shn?Shl00Y2@T003OGemNg]kNg]k
009oOgl00h:2PXR8R8R8R002TY:B00>HV9RJVYZJVYX00Y:BTP03OGemLG5aLG5a00:2PX800iVIVIFE
UIFEU@02V9RH00?;bl_Rh^;Rh^800Y>CT`03B4Q8KVi^KVi^00:ZZZX2UIFE00=SHf=BDU9BDU800UiN
GP03P820Vi^KVi^K00:=SHd00fi^KVATI6ATI002Jf][00=iNGV4Q8B4Q8@00WUiN@03LW9bTI6ATI6A
00:KVi/00eIFEQPH61PH6002?Shn00>0P829RHV9RHT00WalO003RHV9U9BDU9BD00:4Q8@00galO9^K
Vi^KV`02]KFe00>OWimlO7alO7`00WMgM`03OWinN7QhN7Qh00Coool00`000?ooooooo`0Woooo00L0
003oooooooooool0003oool000001?ooo`040000oooooooooooo0WalO003Lg=cG5aLG5aL00:n_[h0
0b/[:hJ6QXJ6QP02Ph>300>c/k=VIVIVIVH00U5AD@03YZJV[Zj^[Zj^009;Bd/00l71`LG5aLG5a@02
NGUi00>ATI5EEEEEEED00XF5Q@03OWinT92@T92@00:6QXH00g]kNhJ6QXJ6QP02VYZJ00<a<C6][Jf]
[Jd00YRHV003OgmoNg]kNg]k00:7QhL2UYJF00>RXZ8Y:BTY:BT00YVIV@03Rh^;PH61PH6100:2PX80
0hN7QhZ:RXZ:RP02R8R800=nOWikNg]kNg/00XN7Q`03Y:BTFEUIFEUI009]KFd00kRh^7inOWinOP02
MWIf00>4Q8AoOgmoOgl00WUiN@03QXJ6TY:BTY:B00:9RHT00ginOX>3Ph>3P`02Shn?00>FUYJMWIfM
WId00ZNWY`03?ShndM7AdM7A009QHF400dE5AI>CTi>CT`02L71`00=^KVjQXJ6QXJ400UEEE@03]kNg
RHV9RHV900:2PX800hb<S8V9RHV9R@02Ph>30h:2PP:7QhL00i:BTYnOWinOW`02[:b/00<n?Sjd];Bd
];@00YNGU`03O7alPX:2PX:200:;Rh/00fi^KV5QHF5QH@02W9bL00=EEEFSXj>SXj<00Va/K0:4Q8@0
0kbl_61PH61PH002H61P00>m_KdU9BDU9BD00Z2PX003/;2`>SXj>SXj00:^[Zh00j>SXiZJVYZJVP02
X:2P00>QXJ64Q8B4Q8@00W]kN`03]kNgMWIfMWIf009MGEd00j:RXYFEUIFEU@02V9RH00>9RHV6QXJ6
QXH00ZZZZP03F5QHGemOGemO009PH6000gMgMh^;Rh^;R`02P82000=aLG7_kno_knl01?ooo`030000
oooooooo013oool001[oool00`000?ooo`000002oooo00<0003oool000000oooo`030000oooooooo
00;oool2MGEe00=gMgMnOWinOWh00X^;R`03Vi^K/;2`/;2`00:YZJT00f][Jc`l?3`l?002GEeM00>H
V9RVYZJVYZH00Y:BTP03LG5aEeMGEeMG009LG5`00gMgMiRHV9RHV002YjNW00>ATI5kNg]kNg/00Y>C
T`03YjNWP820P820009FEUH00fYZJY2@T92@T002UYJF00><S8b8R8R8R8P00X>3P`9lO7`00gQhN7]k
Ng]kN`02PH6100>:RXZ>SXj>SXh00XN7Q`03OGemO7alO7al009lO7`00f][JfATI6ATI002PH6100>B
TY9SHf=SHf<00T92@P03OWin_kno_kno00:QXJ400fEUIEQHF5QHF002K6a/00>;Rh^TY:BTY:@00Z6Q
X@03Rh^;NGUiNGUi009^KVh00fYZJVi^KVi^KP02N7Qh00>1PH69RHV9RHT00XR8R003MGEeM7AdM7Ad
00:ZZZX00m3@d9jNWYjNWP02GUiN00=VIVJ:RXZ:RXX00Y2@T003Rh^;T92@T92@00:<S8`00g1`L6QX
J6QXJ002VYZJ00?9bLVd];Bd];@00XJ6QP03Lg=cMGEeMGEe00:4Q8@00hj>SWalO7alO002MGEe00>V
YZK6a/K6a/H00XF5Q@03@T92IfMWIfMW00:QXJ42UYJF00=eMGEdM7AdM7@00X>3P`03UIFEVi^KVi^K
00:5QHD00fMWIeaLG5aLG002HV9R00=aLG5kNg]kNg/00Ve]K@03IVIVRXZ:RXZ:00:RXZ800g1`L410
@410@002Hf=S00>MWIfWYjNWYjL00YRHV003TI6AQXJ6QXJ6009aLG400fYZJXF5QHF5Q@02X:2P00>I
VIV1PH61PH400WIfMP=bLW84oooo00<0003oooooool09_ooo`030000oooo000000;oool00`000?oo
o`000004oooo00@0003oooooooooool2P82000=nOWi_Kfm_Kfl00/[:bP03XJ6Q00000000009cLg<0
0jb/[>GUiNGUi@02IVIV00?0`<2j^[Zj^[X00/O7a`03HF5QK6a/K6a/009MGEd00kJf]Y6ATI6AT@02
OGem00>;Rh^MWIfMWId00XZ:RP03OGemXJ6QXJ6Q009<C4`00kNg]iFEUIFEU@02RHV900>7QhN1PH61
PH400WmoO`:5QHD00hb<S92@T92@T002Shn?00>8R8R3Ph>3Ph<00XF5Q@03RHV9QHF5QHF500:3Ph<0
0i2@T9ZJVYZJVP02SXj>00>?Shm;Bd];Bd/00Ve]K@03/K6aL71`L71`009jNWX00j6QXJ^[Zj^[Z`02
WinO00><S8akNg]kNg/00W]kN`03QHF5SHf=SHf=00:DU9@00b8R8Z6QXJ6QX@02:RXZ00>SXj>QXJ6Q
XJ400Z:RXP>`/;02QHF500=WIfN@T92@T9000/71`@03?3`lTI6ATI6A00:5QHD00hB4Q7inOWinOP02
PH6100>JVYZVYZJVYZH00XN7Q`03Jf][QXJ6QXJ6008e=CD00cdm?JNWYjNWY`02SXj>00>0P82FUYJF
UYH00Zb/[003Ti>CP820P82000:_[jl00eeMGJVYZJVYZ@02LG5a0X61P@03[:b/ATI6ATI600:n_[h0
0k2`/:BTY:BTY002Zj^[00=0@42l_;bl_;`00S/k>`03;2`/Vi^KVi^K008Y:BT00jFUYHB4Q8B4Q002
LW9b00>QXJ5GEeMGEeL00T92@P03SXj>P820P82000>4Q8@2Ti>C0T92@P03h^;RM7AdM7Ad009fMWH0
0h>3Phn?Shn?S`02S8b<00>4Q8B1PH61PH401?ooo`030000oooooooo013oool001_oool00`000?oo
ooooo`02oooo00<0003oooooool00_ooo`030000oooooooo00;oool2MGEe00=gMgMnOWinOWh00X^;
R`03Vi^K/;2`/;2`00:YZJT00f][Jc`l?3`l?002GEeM00>HV9RVYZJVYZH00Y:BTP03LG5aEeMGEeMG
009LG5`00gMgMiRHV9RHV002YjNW00>ATI5kNg]kNg/00Y>CT`03YjNWP820P820009FEUH00fYZJY2@
T92@T002UYJF00><S8b8R8R8R8P00X>3P`9lO7`00gQhN7]kNg]kN`02PH6100>:RXZ>SXj>SXh00XN7
Q`03OGemO7alO7al009lO7`00f][JfATI6ATI002PH6100>BTY9SHf=SHf<00T92@P03OWin_kno_kno
00:QXJ400fEUIEQHF5QHF002K6a/00>;Rh^TY:BTY:@00Z6QX@03Rh^;NGUiNGUi009^KVh00fYZJVi^
KVi^KP02N7Qh00>1PH69RHV9RHT00XR8R003MGEeM7AdM7Ad00:ZZZX00m3@d9jNWYjNWP02GUiN00=V
IVJ:RXZ:RXX00Y2@T003Rh^;T92@T92@00:<S8`00g1`L6QXJ6QXJ002VYZJ00?9bLVd];Bd];@00XJ6
QP03Lg=cMGEeMGEe00:4Q8@00hj>SWalO7alO002MGEe00>VYZK6a/K6a/H00XF5Q@03@T92IfMWIfMW
00:QXJ42UYJF00=eMGEdM7AdM7@00X>3P`03UIFEVi^KVi^K00:5QHD00fMWIeaLG5aLG002HV9R00=a
LG5kNg]kNg/00Ve]K@03IVIVRXZ:RXZ:00:RXZ800g1`L410@410@002Hf=S00>MWIfWYjNWYjL00YRH
V003TI6AQXJ6QXJ6009aLG400fYZJXF5QHF5Q@02X:2P00>IVIV1PH61PH400WIfMP=bLW84oooo00<0
003oooooool09oooo`030000oooooooo00;oool00`000?ooooooo`03oooo00@0003oooooooooool2
P82000=nOWi_Kfm_Kfl00/[:bP03XJ6Q00000000009cLg<00jb/[>GUiNGUi@02IVIV00?0`<2j^[Zj
^[X00/O7a`03HF5QK6a/K6a/009MGEd00kJf]Y6ATI6AT@02OGem00>;Rh^MWIfMWId00XZ:RP03OGem
XJ6QXJ6Q009<C4`00kNg]iFEUIFEU@02RHV900>7QhN1PH61PH400WmoO`:5QHD00hb<S92@T92@T002
Shn?00>8R8R3Ph>3Ph<00XF5Q@03RHV9QHF5QHF500:3Ph<00i2@T9ZJVYZJVP02SXj>00>?Shm;Bd];
Bd/00Ve]K@03/K6aL71`L71`009jNWX00j6QXJ^[Zj^[Z`02WinO00><S8akNg]kNg/00W]kN`03QHF5
SHf=SHf=00:DU9@00b8R8Z6QXJ6QX@02:RXZ00>SXj>QXJ6QXJ400Z:RXP>`/;02QHF500=WIfN@T92@
T9000/71`@03?3`lTI6ATI6A00:5QHD00hB4Q7inOWinOP02PH6100>JVYZVYZJVYZH00XN7Q`03Jf][
QXJ6QXJ6008e=CD00cdm?JNWYjNWY`02SXj>00>0P82FUYJFUYH00Zb/[003Ti>CP820P82000:_[jl0
0eeMGJVYZJVYZ@02LG5a0X61P@03[:b/ATI6ATI600:n_[h00k2`/:BTY:BTY002Zj^[00=0@42l_;bl
_;`00S/k>`03;2`/Vi^KVi^K008Y:BT00jFUYHB4Q8B4Q002LW9b00>QXJ5GEeMGEeL00T92@P03SXj>
P820P82000>4Q8@2Ti>C0T92@P03h^;RM7AdM7Ad009fMWH00h>3Phn?Shn?S`02S8b<00>4Q8B1PH61
PH401?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0WIfMP03HV9RF5QHF5QH
009cLg<00iVIVJ^[Zj^[Z`02XZ:R00=lO7aQHF5QHF400WMgM`03Vi^KY:BTY:BT00:<S8`00eADE3Xj
>SXj>P02Ng]k00?4a<Bj^[Zj^[X00XB4Q003F5QHCTi>CTi>00:1PH400j>SXeiNGUiNGP0271`L00=C
De>UYJFUYJD00ZJVYP03QhN7Ph>3Ph>300:<S8`2T92@00>CTi>BTY:BTY800Xf=S@03Rh^;RHV9RHV9
009oOgl00gYjNXN7QhN7Q`02Rh^;00=TI6A>CTi>CTh00XN7Q`03^[ZjQ8B4Q8B4009<C4`00h>3Pl;2
`/;2`P02WIfM00=FEUHc<c<c<c<00T10@003Q8B4`<30`<3000:][Jd00gemOGMgMgMgM`02Ogmo00=f
MWI`L71`L7000WMgM`03SXj>]kNg]kNg00;5aLD00hZ:RUIFEUIFEP02Ogmo00>i^KV/[:b/[:`00XB4
Q003MgMgOGemOGem00:8R8P00iFEUJ2PX:2PX002UYJF00=XJ6QBDU9BDU800Xj>SP03b/[:Zj^[Zj^[
009dM7@00g5aLH>3Ph>3P`02QhN700=kNg]LG5aLG5`00T];B`03LG5aTI6ATI6A009/K6`00d92@UiN
GUiNGP02Shn?0YjNWP03Vi^KV9RHV9RH00:DU9@00hn?Sh^;Rh^;R`02QhN700=nOWiZJVYZJVX00UiN
GP03L71`Q8B4Q8B4009kNg/00g9bLXj>SXj>SP02YjNW00>FUYIoOgmoOgl00X^;R`03YJFU]KFe]KFe
00:d];@00inOWginOWinOP02G5aL00=@D51WIfMWIfL00XN7Q`03SHf=Ph>3Ph>3009jNWX00gAdM7Mg
MgMgM`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WmoO`03Shn?SXj>SXj>009TI6@0
0jJVYX61PH61P@02P82000>XZ:QJFUYJFUX00UmOG`03DU9Ba<C4a<C4009BDU800fm_Kg=cLg=cL`02
ZZZZ00=UIFEVIVIVIVH00Xj>SP03/K6a@D51@D5100:DU9@00galO;Vi^KVi^@02N7Qh00=<C4b0P820
P8000W]kN`03SHf=RHV9RHV9009nOWh3Ng]k0WmoO`:5QHD00hJ6QXB4Q8B4Q002RHV900>;Rh]oOgmo
Ogl00WemO@03X:2P?clo?clo00:DU9@00gIfMZf][Jf][@02I6AT00>/[:a^KVi^KVh00X20P003/k>c
EeMGEeMG009@D5000iVIVFa/K6a/K002NWYj00>KVi^JVYZJVYX00Xj>SP03U9BDW9bLW9bL00:IVIT0
0h^;Rg1`L71`L002JVYZ00>PX:1EEEEEEED00Zn_[`03OgmoQhN7QhN700:TY:@00bh^;YbLW9bLW002
SHf=00=oOgmeMGEeMGD00X20P003ZZZZB4Q8B4Q800:GUiL00fe]KH^;Rh^;R`02]kNg00>a/K6FUYJF
UYH00XR8R003SXj>/;2`/;2`009DE5@00dI6AZb/[:b/[002a<C400=MGEf`/;2`/;000WmoO`9hN7P0
0hZ:RYjNWYjNWP02[jn_00<n?Sjg]kNg]kL00STi>@03/[:b^[Zj^[Zj00:l_;`00jJVYY2@T92@T002
Ti>C00>GUiN0P820P8000Vm_K`03Q8B4X:2PX:2P00:NWYh00h^;RgYjNWYjNP02M7Ad00>0P82RXZ:R
XZ800UYJFP03Q8B4T92@T92@00:=SHd00hj>SXn?Shn?S`02RXZ:00>4Q8AnOWinOWh01?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0Y:BTP03IfMWCDe=CDe=00:2PX800kZj^YnO
WinOW`02KVi^00=]KFf4Q8B4Q8@00YFEU@03VYZJRHV9RHV900=fMWH2Q8B40Y>CT`03V9RHRXZ:RXZ:
009`L7000e=CDdm?Cdm?C`02PH6100>VYZIjNWYjNWX00TU9B@03IVIVVIVIVIVI00:PX:000i6ATHJ6
QXJ6QP02OGem0WIfMP03MgMgPH61PH6100:;Rh/00hb<S8J6QXJ6QP02Ng]k00=gMgN9RHV9RHT00YVI
V@03R8R8O7alO7al00:PX:000kNg]gmoOgmoO`02CTi>00=mOGfj^[Zj^[X00Zn_[`03OGemD51@D51@
0094A4@00gAdM:BTY:BTY002QhN700=PH61mOGemOGd00ZBTY003VIVIOGemOGem009`L7000galO:b/
[:b/[002`<3000=kNg/f=SHf=SH00UIFEP03VIVI[:b/[:b/00:LW9`00gmoOfQXJ6QXJ002L71`00>:
RXZNWYjNWYh00YnOW`03QhN7K6a/K6a/009WIfL00fa/K6YZJVYZJP02K6a/00=oOgn=SHf=SHd00XB4
Q003M7AdKVi^KVi^009cLg<00hB4Q8f=SHf=S@02Ogmo00=]KFe^KVi^KVh00X20P0:PX:000jj^[Xn?
Shn?S`02JFUY00=VIVIkNg]kNg/00YBDU003WYjNPh>3Ph>3009XJ6P00gMgMi6ATI6AT@02SXj>00>6
QXJBTY:BTY800YRHV003PX:2JFUYJFUY009XJ6P00g]kNi^KVi^KV`02[Zj^00>LW9afMWIfMWH00UAD
E003Bd];J6QXJ6QX00:>SXh00i^KViNGUiNGU`02S8b<00>5QHFATI6ATI401?ooo`030000oooooooo
03;oool010000?ooooooooooo`9TI6@00h^;RibLW9bLW002HV9R00>IVIVLW9bLW9`00[Zj^P03ATI6
^[Zj^[Zj0092@T800l30`55ADE5AD@02EUIF00?0`<2WYjNWYjL00Y2@T003QXJ6SHf=SHf=00:PX:00
0d10@;jn_[jn_P02VIVI00=nOWhY:BTY:BT00/_;b`03/[:bQHF5QHF5009lO7`00hJ6QXb<S8b<S002
TI6A0YRHV003VIVITY:BTY:B00::RXX00hF5QHB4Q8B4Q002RHV900>;Rh^0P820P8000WalO003U9BD
Z:RXZ:RX00:CTi<00hJ6Q[Rh^;Rh^002IVIV00>b/[9fMWIfMWH00WIfMP03VIVIATI6ATI600;?cll0
0jf][H^;Rh^;R`02XZ:R00=5ADFQXJ6QXJ400WYjNP03OGemShn?Shn?00:GUiL00hj>SVe]KFe]K@02
IVIV00>YZJU`L71`L7000UQHF003VIVIQHF5QHF500:<S8`00ifMWJZZZZZZZP02WinO00>8R8QjNWYj
NWX00WemO@03UYJF/[:b/[:b0092@T800kZj^[fm_Kfm_@02^KVi00<X:2R<S8b<S8`00X^;R`0371`L
XJ6QXJ6Q00:YZJT00jNWYb`/;2`/;002[:b/00<e=CFRXZ:RXZ800Xb<S0=eMGD2W9bL0Ti>CP03Fe]K
b/[:b/[:008m?Cd00jb/[3lo?clo?`02B4Q800>WYjN7QhN7QhL00X>3P`03RHV9PX:2PX:200:2PX80
0i^KVkJf][Jf]P02ADE500>c/k>FUYJFUYH00X>3P`03T92@][Jf][Jf009]KFd00i2@T9BDU9BDU002
QhN700=nOWigMgMgMgL00W9bLP03K6a/f][Jf][J00Coool00`000?ooooooo`0@oooo000Uoooo00<0
003oooooool00_ooo`:BTY800fMWIde=CDe=C@02PX:200>j^[ZOWinOWil00Vi^KP03KFe]Q8B4Q8B4
00:EUID00iZJVXV9RHV9R@03MWIf0XB4Q0:CTi<00iRHV8Z:RXZ:RP02L71`00=CDe=?Cdm?Cdl00X61
P@03YZJVNWYjNWYj0099BDT00fIVIYVIVIVIV@02X:2P00>ATI66QXJ6QXH00WemO@9fMWH00gMgMh61
PH61P@02Rh^;00><S8b6QXJ6QXH00W]kN`03MgMgRHV9RHV900:IVIT00hR8R7alO7alO002X:2P00>g
]kMoOgmoOgl00Ti>CP03OGem^[Zj^[Zj00:_[jl00gemOE1@D51@D002A4A400=dM7BTY:BTY:@00XN7
Q`03H61POGemOGem00:TY:@00iVIVGemOGemO@02L71`00=lO7b/[:b/[:`00/30`003Ng]k=SHf=SHf
009FEUH00iVIVJb/[:b/[002W9bL00=oOgmXJ6QXJ6P00W1`L003RXZ:WYjNWYjN00:OWil00hN7Qfa/
K6a/K002IfMW00=/K6aZJVYZJVX00Va/K003OgmoSHf=SHf=00:4Q8@00gAdM6i^KVi^KP02Lg=c00>4
Q8B=SHf=SHd00WmoO`03KFe]KVi^KVi^00:0P802X:2P00>^[Zj?Shn?Shl00VUYJ@03IVIVNg]kNg]k
00:DU9@00ijNWX>3Ph>3P`02J6QX00=gMgNATI6ATI400Xj>SP03QXJ6TY:BTY:B00:HV9P00h:2PVUY
JFUYJ@02J6QX00=kNg^KVi^KVi/00Zj^[P03W9bLMWIfMWIf009DE5@00d];BfQXJ6QXJ002SXj>00>K
Vi^GUiNGUiL00Xb<S003QHF5TI6ATI6A00Coool00`000?ooooooo`0boooo00@0003oooooooooool2
I6AT00>;Rh^LW9bLW9`00V9RHP03VIVIW9bLW9bL00:j^[X00dI6A[Zj^[Zj^P02@T9200?0`<1ADE5A
DE400UIFEP03`<30YjNWYjNW00:@T9000hJ6QXf=SHf=S@02X:2P00=0@42n_[jn_[h00YVIV@03OWin
:BTY:BTY00;;bl/00k:b/XF5QHF5Q@02O7al00>6QXJ<S8b<S8`00Y6AT@:HV9P00iVIVI:BTY:BTP02
RXZ:00>5QHF4Q8B4Q8@00XV9R@03Rh^;P820P820009lO7`00iBDU:RXZ:RXZ002Ti>C00>6QXJh^;Rh
^;P00VIVIP03/[:bMWIfMWIf009fMWH00iVIVDI6ATI6AP02clo?00>][Jf;Rh^;Rh/00Z:RXP03ADE5
XJ6QXJ6Q009jNWX00gemOHn?Shn?S`02UiNG00>>SXi]KFe]KFd00VIVIP03ZJVYL71`L71`009HF5P0
0iVIVHF5QHF5Q@02S8b<00>MWIfZZZZZZZX00YnOW`03R8R8NWYjNWYj009mOGd00iJFU[:b/[:b/P02
@T9200>j^[Zm_Kfm_Kd00[Vi^@03:2PXS8b<S8b<00:;Rh/00a`L7:6QXJ6QX@02ZJVY00>WYjL/;2`/
;2`00Zb/[003=CDeXZ:RXZ:R00:<S8`3MGEe0YbLW09>CTh00e]KFl[:b/[:bP02?Cdm00>/[:`o?clo
?cl00TQ8B003YjNWQhN7QhN700:3Ph<00hV9RH:2PX:2PP02PX:200>KVi^f][Jf][H00TE5A@03/k>c
UYJFUYJF00:3Ph<00i2@T;Jf][Jf]P02KFe]00>@T92DU9BDU9@00XN7Q`03OWinMgMgMgMg009bLW80
0fa/K=[Jf][JfP04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2Xj>S00=^
KViADE5ADE400YBDU003d=3@TY:BTY:B0091@D400e5ADHN7QhN7Q`02WYjN00>IVIUgMgMgMgL00VUY
J@03YjNWe]KFe]KF00:CTi<00d51@Dm?Cdm?C`02O7al00=eMGEXJ6QXJ6P00XJ6QP03Y:BTVIVIVIVI
00:2PX800galO8B4Q8B4Q002Ti>C00>JVYZ;Rh^;Rh/00W1`L09IFET00eEEEFa/K6a/K002QhN700>=
SHf4Q8B4Q8@00WQhN003MGEeQHF5QHF500:LW9`00jJVYZNWYjNWY`02ZZZZ00>LW9aYJFUYJFT00Te=
C@03Ng]k]kNg]kNg00:k^k/00i^KVgYjNWYjNP02IFEU00=_KfmkNg]kNg/00VATI003F5QHRHV9RHV9
00:j^[X00jb/[8:2PX:2PP03IfMW0XZ:RP:NWYh00fe]KCPh>3Ph>002@d=300=cLg>MWIfMWId00ZRX
Z003OWinD51@D51@009EEED00gUiNI>CTi>CT`02XJ6Q00>RXZ:8R8R8R8P00Ta<C0038b<S>SXj>SXj
009]KFd00hf=SI>CTi>CT`02PH6100=cLg>;Rh^;Rh/00ZRXZ003Xj>STI6ATI6A00:ATI400i:BTXB4
Q8B4Q002OWin0YVIV@03YJFULW9bLW9b008o?cl00dm?CgmoOgmoO`02Xj>S00>][JfDU9BDU9@00WMg
M`03OWinUIFEUIFE00:JVYX00iJFUYBDU9BDU002QXJ600=UIFE8B4Q8B4P00Slo?`03DU9BOgmoOgmo
00:OWil00i:BTVm_Kfm_K`02F5QH00=IFEUhN7QhN7P00Y^KV`03XJ6QV9RHV9RH00:EUID00iVIVJJV
YZJVYP04oooo00<0003oooooool0<_ooo`040000oooooooooooo0Tm?C`03Ph>3X:2PX:2P009QHF40
0i^KVkjn_[jn_P02NWYj00=WIfNc/k>c/k<00Z2PX003Xj>S@d=3@d=300;3`l<00hb<S65QHF5QH@02
U9BD00?Fe]I>CTi>CTh00Z>SX`03Zj^[?clo?clo00:RXZ800hZ:RXn?Shn?S`02WIfM00>LW9bBTY:B
TY800X>3P`03OGemRh^;Rh^;00:SXj<2?clo00>n_[hb<S8b<S800Y>CT`03QXJ6Q8B4Q8B400:6QXH0
0hR8R8F5QHF5Q@02Q8B400>?ShnMWIfMWId00RTY:@03[jn_Fe]KFe]K009[Jf/00kFe]G]kNg]kN`02
L71`00>5QHFRXZ:RXZ800T10@003^KVi>c/k>c/k00;8b<P00eEEEJ6QXJ6QX@02L71`00=bLW:;Rh^;
Rh/00YVIV@03V9RHPH61PH61009kNg/00jn_[fYZJVYZJP02Hf=S00>c/k>:RXZ:RXX00W]kN`03V9RH
@410@41000:b/[800iFEUH>3Ph>3P`02OGem00>2PX:NWYjNWYh00UUIF@03O7alJ6QXJ6QX008j>SX0
0iBDU8V9RHV9R@02TY:B00>KVi^:RXZ:RXX00WMgM`03P820T92@T92@00:>SXh00hN7Qhj>SXj>SP02
Shn?0WUiN@03M7AdYZJVYZJV009RHV800fIVI/[:b/[:bP02@D5100>g]kO2`/;2`/800Ti>CP03[:b/
RHV9RHV9009mOGd00h61PHR8R8R8R002VYZJ00>j^[YNGUiNGUh00VYZJP03f=SH?3`l?3`l00:KVi/0
0jVYZEEEEEEEE@02NWYj00>@T92;Rh^;Rh/00WYjNP03LG5ah^;Rh^;R009JFUX00de=CKbl_;bl_004
oooo00<0003oooooool04?ooo`009Oooo`800003oooo0Z>SX`03KVi^DE5ADE5A00:DU9@00m3@d9:B
TY:BTP02@D5100=ADE67QhN7QhL00YjNWP03VIVIMgMgMgMg009YJFT00jNWYmKFe]KFeP02Ti>C00=1
@D5?Cdm?Cdl00WalO003MGEeJ6QXJ6QX00:6QXH00jBTY9VIVIVIV@02PX:200=lO7b4Q8B4Q8@00Y>C
T`03VYZJRh^;Rh^;009`L702FEUI00=EEEE/K6a/K6`00XN7Q`03SHf=Q8B4Q8B4009hN7P00gEeMHF5
QHF5Q@02W9bL00>VYZJWYjNWYjL00ZZZZP03W9bLJFUYJFUY009=CDd00g]kNkNg]kNg]`02^k^k00>K
Vi]jNWYjNWX00VEUI@03Kfm_Ng]kNg]k009TI6@00eQHF8V9RHV9R@02^[Zj00>/[:b2PX:2PX800fMW
I`::RXX2WYjN00=]KFdh>3Ph>3P00T=3@`03Lg=cWIfMWIfM00:XZ:P00ginOU1@D51@D002EEEE00=i
NGVCTi>CTi<00Z6QX@03XZ:RR8R8R8R8009<C4`00b<S8cXj>SXj>P02KFe]00>=SHfCTi>CTi<00X61
P@03Lg=cRh^;Rh^;00:XZ:P00j>SXi6ATI6AT@02TI6A00>BTY:4Q8B4Q8@00WinOP:IVIT00jFUYG9b
LW9bLP02?clo00=?CdmoOgmoOgl00Z>SX`03[Jf]U9BDU9BD009gMgL00ginOYFEUIFEU@02VYZJ00>F
UYJDU9BDU9@00XJ6QP03IFEUB4Q8B4Q8008o?cl00e9BDWmoOgmoO`02WinO00>BTY9_Kfm_Kfl00UQH
F003FEUIN7QhN7Qh00:KVi/00j6QXIRHV9RHV002UIFE00>IVIVVYZJVYZH00oooo`80000doooo00@0
003oooooooooool2Cdm?00>3Ph>PX:2PX:000V5QH@03Vi^K_[jn_[jn009jNWX00fMWIk>c/k>c/`02
X:2P00>SXj=3@d=3@d<00/?3``03S8b<HF5QHF5Q00:DU9@00mKFeTi>CTi>CP02Xj>S00>[Zj/o?clo
?cl00Z:RXP03RXZ:Shn?Shn?00:MWId00ibLW9:BTY:BTP02Ph>300=mOGf;Rh^;Rh/00Z>SX`8o?cl0
0kjn_S8b<S8b<P02Ti>C00>6QXJ4Q8B4Q8@00XJ6QP03R8R8QHF5QHF500:4Q8@00hn?SifMWIfMW@02
:BTY00>_[jmKFe]KFe/00V][J`03]KFeNg]kNg]k009`L7000hF5QJ:RXZ:RXP02@41000>i^KTk>c/k
>c/00/S8b003EEEEXJ6QXJ6Q009`L7000g9bLX^;Rh^;R`02VIVI00>HV9R1PH61PH400W]kN`03[jn_
JVYZJVYZ009SHf<00k>c/hZ:RXZ:RP02Ng]k00>HV9Q0@410@4000[:b/P03UIFEPh>3Ph>3009mOGd0
0h:2PYjNWYjNWP02FEUI00=lO7aXJ6QXJ6P00SXj>P03U9BDRHV9RHV900:BTY800i^KVhZ:RXZ:RP02
MgMg00>0P82@T92@T9000Xj>SP03QhN7SXj>SXj>00:?Shl2NGUi00=dM7BVYZJVYZH00V9RHP03IVIV
b/[:b/[:0091@D400kNg]l;2`/;2`P02CTi>00>/[:b9RHV9RHT00WemO@03PH61R8R8R8R800:JVYX0
0kZj^UiNGUiNGP02JVYZ00?Hf=Pl?3`l?3`00Y^KV`03ZJVYEEEEEEEE009jNWX00i2@T8^;Rh^;R`02
NWYj00=aLG7Rh^;Rh^800UYJFP03CDe=_;bl_;bl00?oool200004_ooo`009Oooo`030000oooooooo
00;oool2QhN700=NGUi>CTi>CTh00WinOP03Zj^[Rh^;Rh^;009BDU800d51@E9BDU9BDP02NWYj00>K
Vi^?Shn?Shl00X20P003Zj^[`<30`<30009[Jf/00b4Q8EaLG5aLG002/K6a00>SXj=gMgMgMgL00Win
OP03Rh^;M7AdM7Ad009MGEd00fQXJ861PH61P@02T92@00>EUIF@T92@T9000X61P@9/K6`00f=SHgEe
MGEeM@02RXZ:00>;Rh^0P820P8000WQhN003MgMgPX:2PX:200:>SXh00hZ:RX61PH61P@02QXJ600>3
Ph=NGUiNGUh00Tm?C`03SHf=alO7alO700:WYjL00g1`L7EeMGEeM@02S8b<00>6QXIkNg]kNg/00Win
OP03RXZ:WIfMWIfM00:TY:@00hb<S6a/K6a/K002GUiN00=UIFEhN7QhN7P00XV9R@03RXZ:Ng]kNg]k
009KFe/00e9BDXN7QhN7Q`02[Jf]00=hN7Pf=SHf=SH00Shn?P03K6a/SXj>SXj>00:JVYX00h^;Rg1`
L71`L002IfMW00=ZJVY[Jf][Jf/00W9bLP03QhN7TY:BTY:B009oOgl00g5aLH^;Rh^;R`02Y:BT00><
S8a/K6a/K6`00Vi^KP03P820RXZ:RXZ:00B=SHd00h61PFATI6ATI002F5QH00=mOGfXZ:RXZ:P00ZRX
Z003U9BDS8b<S8b<00:9RHT00h61PGmoOgmoO`02S8b<00>GUiN<S8b<S8`00WYjNP03LW9bKVi^KVi^
009QHF400f=SHhV9RHV9R@02YJFU00>9RHUQHF5QHF400UaLG003Kfm_Q8B4Q8B400:=SHd00gMgMfIV
IVIVIP02P8200j6QX@Coool00`000?ooooooo`0boooo00@0003oooooooooool2G5aL00>=SHfTY:BT
Y:@00WemO@03DE5AGemOGemO009nOWh00g]kNeaLG5aLG002YZJV00>1PH6:RXZ:RXX00YZJVP03OWin
M7AdM7Ad0095ADD00h>3Pe9BDU9BDP02QhN700>EUIFl_;bl_;`00Slo?`03Zj^[][Jf][Jf0094A4@0
0c4a<Hn?Shn?S`02PX:200>1PH6:RXZ:RXX00Y^KV`8g=cL00kZj^Zb/[:b/[002UIFE00>9RHV5QHF5
QHD00X:2PP03Ph>3RXZ:RXZ:00:IVIT00cdm?M;Bd];BdP02G5aL00?De=A`L71`L7000W1`L003Zj^[
LG5aLG5a00:3Ph<00jf][J^[Zj^[Z`02WinO00<b<S:j^[Zj^[X00T51@@03[Zj^V9RHV9RH00:9RHT0
0i6ATInOWinOW`029RHV00>FUYJ:RXZ:RXX00XJ6QP03T92@YZJVYZJV00;3`l<00de=CINGUiNGU`02
LG5a00>HV9QBDU9BDU800/C4a0039RHVR8R8R8R800:4Q8@00iNGUk:b/[:b/P02@d=300>i^KVe]KFe
]KD00Zb/[003VIVIS8b<S8b<00:IVIT00j>SXhZ:RXZ:RP02Lg=c00>4Q8BNWYjNWYh00YbLW003SXj>
R8R8R8R800:6QXH2Q8B400>;Rh^UYJFUYJD00[Vi^@03/[:bZj^[Zj^[009;Bd/00fMWImoOgmoOg`02
DE5A00>f][HX:2PX:2P00Xj>SP03R8R8UiNGUiNG008d=3@00clo?kjn_[jn_P02DU9B00=DE5Bd];Bd
];@00RXZ:P03`l?3MGEeMGEe00:8R8P00hZ:RXF5QHF5Q@02PX:200>9RHV5QHF5QHD00UaLG003/;2`
/k>c/k>c00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9LG5`00dm?CeaL
G5aLG002LW9b00>6QXJ?Shn?Shl00WemO@03BTY:;Bd];Bd]009IFET00iRHV:>SXj>SX`02UIFE00>K
Vi^>SXj>SXh00TQ8B0039RHVP820P82000;Ogml00kjn_WMgMgMgM`02N7Qh00>3Ph=CDe=CDe<00Rh^
;P03DU9BRHV9RHV900:DU9@00hb<S92@T92@T002TY:B0XF5Q@03OGemQhN7QhN700:BTY800hZ:RWem
OGemO@02MgMg00=iNGV0P820P8000X20P003JVYZEUIFEUIF009SHf<00g5aLEMGEeMGE`02DE5A00>R
XZ;Lg=cLg=`00Xn?S`03=CDeFEUIFEUI00:PX:000i^KVhJ6QXJ6QP02XZ:R00>k^k^NWYjNWYh00WAd
M003I6ATHf=SHf=S009XJ6P00g9bLWEeMGEeM@02PH6100>YZJVj^[Zj^[X00X20P003CDe=NWYjNWYj
00:ZZZX00gYjNS/k>c/k>`02ATI600=bLW:@T92@T9000Y:BTP03K6a/EEEEEEEE00:=SHd00lW9bJn_
[jn_[`03OGem0X^;R`9mOGd00g1`L861PH61P@02S8b<00=bLW9DE5ADE5@00U1@D003IFEUSXj>SXj>
00:SXj<2OGem00=CDe=PH61PH6000Xf=S@03^;RhaLG5aLG500:LW9`00fa/K79bLW9bLP02R8R800=n
OWi^KVi^KVh00WMgM`03QhN7RHV9RHV900:7QhL00hR8R8V9RHV9R@02Ph>300>7QhNWYjNWYjL00[Fe
]@03QXJ6EUIFEUIF009RHV800hB4Q96ATI6AT@02Ph>300=GEeLn?Shn?Sh00Ve]K@03X:2PRh^;Rh^;
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2MgMg00>?Shn@T92@T9000XB4Q003LG5a
g=cLg=cL009RHV800gEeMG=cLg=cL`02/;2`00=^KViUIFEUIFD00W]kN`03QhN7X:2PX:2P009YJFT0
0hR8R;Rh^;Rh^002K6a/00>:RXY?Cdm?Cdl00/W9b@03@T92GUiNGUiN009^KVh00kbl_8J6QXJ6QP02
O7al00>7QhN;Rh^;Rh/00Y2@T0:OWil00jVYZBHV9RHV9P02TI6A00>;Rh^6QXJ6QXH00h20P0:<S8`2
Z:RX00=OGen7QhN7QhL00XB4Q003MGEeP820P820009gMgL00j2PX6ATI6ATI002VIVI00=TI6A9BDU9
BDT00Y2@T003WIfM]KFe]KFe00:PX:000hZ:RY^KVi^KV`02];Bd00<l?3bZZZZZZZX00YZJVP03SHf=
S8b<S8b<00:9RHT00g9bLV][Jf][J`02WYjN00=>CTjPX:2PX:000WAdM003V9RHCdm?Cdm?00:m_Kd0
0iZJVXJ6QXJ6QP02Rh^;00>b/[9ADE5ADE400YfMW@03JFUYNWYjNWYj00:OWil00bDU9I>CTi>CT`02
WYjN00<];BfCTi>CTi<00X>3P`03TI6AYZJVYZJV008b<S800j2PX8J6QXJ6QP02N7Qh0Y>CT`03[jn_
:2PX:2PX00:6QXH00galO9BDU9BDU002G5aL00>CTi>7QhN7QhL00UaLG003`<30][Jf][Jf00:UYJD0
0ifMWJ>SXj>SX`02[:b/00>][Jf[Zj^[Zj/00[6a/@03/[:bXJ6QXJ6Q00:QXJ400e]KFi2@T92@T002
U9BD00>3Ph=nOWinOWh00XR8R003WinOX:2PX:2P009WIfL00j^[Zkno_kno_`04oooo00<0003ooooo
ool04?ooo`009Oooo`030000oooooooo00;oool2G5aL00=?CdmLG5aLG5`00W9bLP03QXJ6Shn?Shn?
009mOGd00dY:BRd];Bd];@02FEUI00>HV9RSXj>SXj<00YFEU@03Vi^KSXj>SXj>0098B4P00bHV9X20
P820P002gmoO00>n_[igMgMgMgL00WQhN003Ph>3De=CDe=C008^;Rh00e9BDXV9RHV9R@02U9BD00><
S8b@T92@T9000Y:BTP:5QHD00gemOHN7QhN7Q`02TY:B00>:RXYmOGemOGd00WMgM`03NGUiP820P820
00:0P8000fYZJUIFEUIFEP02Hf=S00=aLG5GEeMGEeL00U5AD@03XZ:Rg=cLg=cL00:?Shl00cDe=EUI
FEUIF@02X:2P00>KVi^6QXJ6QXH00Z:RXP03^k^kWYjNWYjN009dM7@00fATI6=SHf=SH`02J6QX00=b
LW9eMGEeMGD00X61P@03ZJVY^[Zj^[Zj00:0P8000de=CGYjNWYjNP02ZZZZ00=jNWXk>c/k>c/00TI6
AP03LW9bT92@T92@00:BTY800fa/K5EEEEEEE@02SHf=00?9bLV_[jn_[jl00gemO@:;Rh/2OGem00=`
L721PH61PH400Xb<S003LW9bE5ADE5AD009@D5000fEUIHj>SXj>SP02Xj>S0WemO@03De=CH61PH61P
00:=SHd00kRh^<G5aLG5a@02W9bL00=/K6abLW9bLW800XR8R003OWinKVi^KVi^009gMgL00hN7QhV9
RHV9R@02QhN700>8R8R9RHV9RHT00X>3P`03QhN7YjNWYjNW00:e]KD00hJ6QUIFEUIFEP02HV9R00>4
Q8BATI6ATI400X>3P`03EeMG?Shn?Shn009]KFd00j2PX8^;Rh^;R`04oooo00<0003oooooool0<_oo
o`040000oooooooooooo0WMgM`03Shn?T92@T92@00:4Q8@00g5aLMcLg=cLg002HV9R00=eMGEcLg=c
Lg<00[2`/003KVi^IFEUIFEU009kNg/00hN7Qj2PX:2PX002JFUY00>8R8Rh^;Rh^;P00Va/K003RXZ:
Cdm?Cdm?00;9bLT00d92@UiNGUiNGP02KVi^00>l_;b6QXJ6QXH00WalO003QhN7Rh^;Rh^;00:@T902
WinO00>YZJTV9RHV9RH00Y6AT@03Rh^;QXJ6QXJ600>0P802S8b<0ZRXZ003GemOQhN7QhN700:4Q8@0
0gEeMH20P820P002MgMg00>PX:1TI6ATI6@00YVIV@03I6ATBDU9BDU900:@T9000ifMWKFe]KFe]@02
X:2P00>:RXZKVi^KVi/00[Bd]003?3`lZZZZZZZZ00:JVYX00hf=SHb<S8b<S002RHV900=bLW9[Jf][
Jf/00YjNWP03CTi>X:2PX:2P009dM7@00iRHV4m?Cdm?C`02_Kfm00>JVYZ6QXJ6QXH00X^;R`03/[:b
DE5ADE5A00:MWId00fUYJGYjNWYjNP02WinO00<U9BFCTi>CTi<00YjNWP03;Bd]Ti>CTi>C00:3Ph<0
0i6ATJJVYZJVYP02<S8b00>PX:26QXJ6QXH00WQhN0:CTi<00jn_[bPX:2PX:002QXJ600=lO7bDU9BD
U9@00UaLG003Ti>CQhN7QhN7009LG5`00l30`;Jf][Jf]P02YJFU00>MWIfSXj>SXj<00Zb/[003[Jf]
Zj^[Zj^[00:a/K400k:b/Z6QXJ6QX@02XJ6Q00=KFe^@T92@T9000YBDU003Ph>3OWinOWin00:8R8P0
0inOWj2PX:2PX002IfMW00>[Zj^o_kno_kl01?ooo`030000oooooooo013oool002Goool00`000?oo
ooooo`02oooo0T92@P03GEeMT92@T92@00:QXJ400ijNWYbLW9bLW002Shn?00=bLW9OGemOGel00Vm_
K`03QXJ6Ph>3Ph>3009nOWh00iVIVJ>SXj>SX`02Hf=S00<h>3R5QHF5QHD00]GEe@03YjNWI6ATI6AT
00:7QhL00kBd]8R8R8R8R002DE5A00=UIFF?Shn?Shl00YNGU`03SXj>QhN7QhN700:0P802MgMg00=i
NGV>SXj>SXh00YfMW@03T92@Ng]kNg]k009dM7@00gUiNH20P820P002QXJ600>3Ph=iNGUiNGT00W5a
L@03J6QXCTi>CTi>009EEED00jZZZ^;Rh^;RhP02T92@00<`<31<C4a<C4`00Xj>SP03QXJ6LG5aLG5a
00:DU9@00jZZZWEeMGEeM@02@d=300=QHF6DU9BDU9@00YRHV003R8R8OgmoOgmo00:3Ph<00ifMWJb/
[:b/[002SHf=00=]KFf3Ph>3Ph<00Z2PX003SHf=MGEeMGEe00:3Ph<00i^KVibLW9bLW002SHf=00=g
MgM`L71`L7000Xj>SP03[jn_YZJVYZJV00:>SXh00hR8R8N7QhN7Q`02O7al00=fMWInOWinOWh00XR8
R003RHV9Ph>3Ph>300=cLg<2WIfM0[2`/09/K6`00bl_;eeMGEeMG@02ZJVY00>j^[ZPX:2PX:000W]k
N`03Fe]KDe=CDe=C009PH6000gQhN8F5QHF5Q@02M7Ad00=/K6bJVYZJVYX00[Vi^@03QHF5BTY:BTY:
009HF5P00hf=SKbl_;bl_002a/K600>BTY9KFe]KFe/00VEUI@03S8b<XJ6QXJ6Q00:MWId00gUiNEmO
GemOG`02OGem00>IVIU_Kfm_Kfl01?ooo`030000oooooooo03;oool010000?ooooooooooo`:6QXH0
0gEeME5ADE5AD@02`<3000=;Bd_3`l?3`l<00/C4a003CTi>_[jn_[jn00:JVYX00gYjNWinOWinOP02
T92@00>;Rh^DU9BDU9@00];BdP03OWin^;Rh^;Rh009gMgL00j2PX69RHV9RHP02`<3000>FUYJ_[jn_
[jl00/c<c003[Zj^PX:2PX:2009iNGT00hB4Q92@T92@T002W9bL0Rl_;`03ZJVYVIVIVIVI00:7QhL0
0hF5QHV9RHV9R@02Ph>300>0P82:RXZ:RXX00Z2PX003ADE5g]kNg]kN009gMgL00h20P8n?Shn?S`02
OWin00>SXj=UIFEUIFD00YVIV@03h>3PD51@D51@00:LW9`00jf][De=CDe=C@02<c<c00>GUiM2@T92
@T800V=SH`03^[ZjQhN7QhN7009lO7`00hB4Q8Z:RXZ:RP02R8R800=gMgM`L71`L7000Xn?S`03[Jf]
WYjNWYjN00:6QXH00i:BTZ6QXJ6QX@02Shn?00=jNWYmOGemOGd00Y6AT@03<S8b][Jf][Jf00:LW9`3
O7al0Xb<S003T92@TY:BTY:B00:MWId00j6QXIFEUIFEU@02QXJ600=mOGeoOgmoOgl00Y2@T003V9RH
OWinOWin009bLW82YZJV00=GEeNWYjNWYjL00Vm_K`03NGUi[jn_[jn_009bLW800ibLW9fMWIfMW@02
O7al00=>CTjWYjNWYjL00SDe=@03@410W9bLW9bL00:9RHT00cXj>VQXJ6QXJ002G5aL00<d=3BCTi>C
Ti<00YZJVP03G5aLV9RHV9RH00:LW9`00h>3PgAdM7AdM002M7Ad00>6QXJ<S8b<S8`00VATI003@T92
H61PH61P00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`92@T800eeMGI2@
T92@T002XJ6Q00>NWYjLW9bLW9`00Xn?S`03LW9bGemOGemO009_Kfl00hJ6QX>3Ph>3P`02OWin00>I
VIVSXj>SXj<00V=SH`03>3PhQHF5QHF500;EeMD00jNWYfATI6ATI002QhN700>d];B8R8R8R8P00U5A
D@03IFEUShn?Shn?00:GUiL00hj>SXN7QhN7Q`02P8200WMgM`03NGUiSXj>SXj>00:MWId00i2@T7]k
Ng]kN`02M7Ad00=iNGV0P820P8000XJ6QP03Ph>3NGUiNGUi009aLG400fQXJ4i>CTi>CP02EEEE00>Z
ZZ[Rh^;Rh^800Y2@T003<30`C4a<C4a<00:>SXh00hJ6QW5aLG5aL@02U9BD00>ZZZYeMGEeMGD00T=3
@`03HF5QU9BDU9BD00:HV9P00hR8R7moOgmoO`02Ph>300>MWIf/[:b/[:`00Xf=S@03KFe]Ph>3Ph>3
00:PX:000hf=SGEeMGEeM@02Ph>300>KVi^LW9bLW9`00Xf=S@03MgMgL71`L71`00:>SXh00jn_[jJV
YZJVYP02SXj>00>8R8R7QhN7QhL00WalO003MWIfOWinOWin00:8R8P00hV9RH>3Ph>3P`03Lg=c0YfM
W@:`/;02K6a/00<_;bmMGEeMGEd00ZVYZ@03^[ZjX:2PX:2P009kNg/00e]KFe=CDe=CD`02H61P00=h
N7R5QHF5QHD00WAdM003K6a/VYZJVYZJ00:i^KT00hF5QDY:BTY:BP02F5QH00>=SHfl_;bl_;`00/K6
aP03TY:BFe]KFe]K009UIFD00hb<S:6QXJ6QX@02WIfM00=iNGUOGemOGel00WemO@03VIVIKfm_Kfm_
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2QXJ600=eMGEADE5ADE400/30`003Bd];
`l?3`l?300;4a<@00di>C[jn_[jn_P02VYZJ00=jNWYnOWinOWh00Y2@T003Rh^;U9BDU9BD00;Bd]80
0ginO[Rh^;Rh^002MgMg00>PX:1RHV9RHV800/30`003UYJF[jn_[jn_00;<c<`00jj^[X:2PX:2PP02
NGUi00>4Q8B@T92@T9000YbLW08_;bl00jVYZIVIVIVIV@02QhN700>5QHF9RHV9RHT00X>3P`03P820
RXZ:RXZ:00:PX:000dE5AMkNg]kNgP02MgMg00>0P82?Shn?Shl00WinOP03Xj>SIFEUIFEU00:IVIT0
0n3Ph51@D51@D002W9bL00>][Je=CDe=CDd00S<c<`03UiNG@T92@T92009SHf<00kZj^XN7QhN7Q`02
O7al00>4Q8B:RXZ:RXX00XR8R003MgMgL71`L71`00:?Shl00jf][IjNWYjNWP02QXJ600>BTY:QXJ6Q
XJ400Xn?S`03NWYjOGemOGem00:ATI400c8b<[Jf][Jf]P02W9bL0galO0:<S8`00i2@T9:BTY:BTP02
WIfM00>QXJ6EUIFEUID00XJ6QP03OGemOgmoOgmo00:@T9000iRHV7inOWinOP02LW9b0ZJVYP03EeMG
YjNWYjNW009_Kfl00gUiNJn_[jn_[`02LW9b00>LW9bMWIfMWId00WalO003CTi>YjNWYjNW008e=CD0
0d10@9bLW9bLW002RHV900<j>SYXJ6QXJ6P00UaLG003=3@dTi>CTi>C00:JVYX00eaLG9RHV9RHV002
W9bL00>3Ph=dM7AdM7@00WAdM003QXJ6S8b<S8b<009TI6@00d92@V1PH61PH004oooo00<0003ooooo
ool04?ooo`009Oooo`030000oooooooo00;oool2Bd];00=dM7Ba/K6a/K400/S8b003_knoY:BTY:BT
00:>SXh00iZJVZNWYjNWY`02Ti>C00=bLW9MGEeMGEd00VIVIP03WIfM_kno_kno00:3Ph<00dM7AgIf
MWIfMP02/;2`00>4Q8AHF5QHF5P00YRHV003gMgM^[Zj^[Zj00=nOWh2UIFE0YVIV@03Shn?OgmoOgmo
009^KVh2I6AT00=/K6b6QXJ6QXH00YbLW003TY:BO7alO7al009dM7@00gQhN861PH61P@02T92@00>V
YZJ[Zj^[Zj/00Y>CT`03L71`DE5ADE5A009IFET00jFUYMWIfMWIf@02VIVI00=4A4A;Bd];Bd/00WAd
M003MWIfK6a/K6a/009lO7`00ginOU1@D51@D002=cLg00=eMGFm_Kfm_Kd00[jn_P03VYZJPh>3Ph>3
009iNGT00galO8J6QXJ6QP02T92@00>CTi>;Rh^;Rh/00XZ:RP03X:2P][Jf][Jf00:d];@00jNWYijN
WYjNWP02UYJF00>>SXj5QHF5QHD00WYjNP03N7QhR8R8R8R800:FUYH00hb<S7]kNg]kN`02MgMg00=l
O7b5QHF5QHD00Y2@T003WYjNY:BTY:BT00:FUYH00hj>SZZZZZZZZP02/K6a0VEUI@03:BTYHf=SHf=S
00:a/K400j>SXfm_Kfm_K`02GUiN00=KFe]=CDe=CDd00Tm?C`03MWIfU9BDU9BD009gMgL00fMWIk>c
/k>c/`02hN7Q00=bLW80000000000R/[:`03U9BD`l?3`l?300:m_Kd00iFEUF][Jf][J`02KFe]00>;
Rh^TY:BTY:@00Zn_[`03Xj>STY:BTY:B00:FUYH00i>CTfMWIfMWI`04oooo00<0003oooooool0<_oo
o`040000oooooooooooo0WalO003bLW9TI6ATI6A009mOGd00hR8R:6QXJ6QX@02=SHf00>KVi^0P820
P8000X:2PP03UYJFZj^[Zj^[00:`/;000i:BTX:2PX:2PP02?clo00=aLG59BDU9BDT00Y:BTP03@410
h^;Rh^;R008f=SH00gAdM8J6QXJ6QP02<30`00>LW9aoOgmoOgl00WUiN@03PX:2TY:BTY:B00:UYJD2
=cLg00>^[ZjHV9RHV9P00X>3P`03PX:2RHV9RHV900:7QhL00h>3PhR8R8R8R002SXj>00>BTY8Z:RXZ
:RX00/O7a`03MGEeTY:BTY:B00:6QXH00k:b/W9bLW9bLP02TY:B00=ADE5;Bd];Bd/00Z^[Z`03]kNg
CTi>CTi>00:m_Kd00kNg]eaLG5aLG002JFUY00>[Zj]/K6a/K6`00VQXJ003PX:2TI6ATI6A00:DU9@0
0i2@T8Z:RXZ:RP02RHV900>BTY8X:2PX:2P00ZJVYP03TI6AMWIfMWIf009^KVh00gAdM7inOWinOP02
S8b<00>KVi^VYZJVYZH00S<c<`03YZJVT92@T92@009nOWh00hB4Q9FEUIFEU@028R8R00>HV9R?Shn?
Shl00X:2PP03LW9bK6a/K6a/009lO7`00hV9RGUiNGUiN@02MgMg0[:b/P03I6ATZj^[Zj^[009`L700
0hj>SUQHF5QHF002OGem00><S8bCTi>CTi<00X:2PP03CTi>WinOWinO008i>CT00lC4a8b<S8b<S002
Jf][00?5aLFVYZJVYZH00X61P@03ZJVYShn?Shn?00:UYJD00f1PH9:BTY:BTP02Vi^K00>7QhMcLg=c
Lg<00VMWI`03i>CTLG5aLG5a009SHf<00m?Cdg5aLG5aL@04oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool3PX:20Xn?S`:VYZH00k>c/ijNWYjNWP02S8b<00>UYJFh^;Rh^;P00YBD
U003J6QXIfMWIfMW009oOgl00i^KVifMWIfMW@02J6QX00<l?3aTI6ATI6@00YVIV@03QhN7KFe]KFe]
00:CTi<00kJf]Y2@T92@T002Hf=S00=gMgNJVYZJVYX00YFEU@>2PX82Ph>30W=cL`03J6QXLG5aLG5a
00:0P8000hN7QhF5QHF5Q@02OGem00=gMgMnOWinOWh00Xn?S`03X:2PZJVYZJVY00:UYJD00hn?SfAT
I6ATI002EUIF00>DU9C8b<S8b<P00YNGU`=@D502N7Qh00>LW9bYZJVYZJT00Y2@T003Jf][Hf=SHf=S
009cLg<00hR8R9ZJVYZJVP02Y:BT00>FUYI/K6a/K6`00Tm?C`03HV9RRHV9RHV900:OWil00ibLW7Qh
N7QhN002IVIV00>OWio?clo?cll00YRHV003FUYJPH61PH6100:c/k<00hZ:RUIFEUIFEP02JVYZ00>B
TY:KVi^KVi/00Xb<S003Kfm_Fe]KFe]K009VIVH00h:2PYNGUiNGU`02UiNG00=iNGUQHF5QHF400W9b
LP03UIFE[:b/[:b/00:UYJD2LG5a00==CDeiNGUiNGT00Zj^[P03W9bLKVi^KVi^009HF5P00eeMGGUi
NGUiN@02Shn?00=mOGeYJFUYJFT00WIfMP03VYZJbl_;bl_;00;9bLT00e]KF`@410@41002CTi>00>l
_;bf][Jf][H00X:2PP03MgMgOgmoOgmo00:2PX800hJ6QXZ:RXZ:RP02S8b<00>@T92EUIFEUID00YZJ
VP03V9RHS8b<S8b<00Coool00`000?ooooooo`0boooo00@0003oooooooooool2a/K600<b<S:?Shn?
Shl00WEeM@03KVi^QHF5QHF500:IVIT00hF5QG1`L71`L002RXZ:00<e=CFf][Jf][H00S<c<`039RHV
YJFUYJFU00;Bd]800gUiNLk>c/k>cP02X:2P00>a/K5BDU9BDU800[2`/003TY:BZJVYZJVY0098B4P0
0jBTY7emOGemO@02O7al00>:RXZ;Rh^;Rh/00Xf=S@:MWId00jVYZBTY:BTY:@02U9BD00>9RHV3Ph>3
Ph<00XB4Q003R8R8QhN7QhN700>4Q8@2Shn?0ZJVYP03DE5APX:2PX:200:?Shl00di>CXF5QHF5Q@02
U9BD00>m_Kfk^k^k^k/00RXZ:P03U9BDTY:BTY:B00:XZ:P00dI6A[jn_[jn_P02[:b/00>JVYZ=SHf=
SHd00XR8R003TY:B[Zj^[Zj^0093@d<00jFUYHF5QHF5Q@02O7al00>>SXjk^k^k^k/00UUIF@03X:2P
KVi^KVi^00:=SHd00kRh^9RHV9RHV002MWIf00>OWimCDe=CDe<00[Rh^003SHf=O7alO7al00:1PH40
0iJFUZRXZ:RXZ002XZ:R00>>SXinOWinOWh00WmoO`03VIVI[Zj^[Zj^00:TY:@00hb<S7inOWinOP02
QXJ60Zn_[`03D51@Y:BTY:BT009mOGd00iJFU/c<c<c<c002Lg=c00=gMgMNGUiNGUh00[bl_003_kno
alO7alO700:k^k/00j2PX7emOGemO@02PH6100=QHF6TY:BTY:@00VEUI@03RHV9Vi^KVi^K009OGel0
0g]kNhB4Q8B4Q002RXZ:00>9RHV5QHF5QHD00X:2PP03OgmoNg]kNg]k009dM7@00nCTi5mOGemOG`04
oooo00<0003oooooool04?ooo`009Oooo`800003oooo0h:2PP:?Shl2YZJV00>c/k>NWYjNWYh00Xb<
S003YJFU^;Rh^;Rh00:DU9@00fQXJ6MWIfMWI`02Ogmo00>KVi^MWIfMWId00VQXJ003?3`lI6ATI6AT
00:IVIT00hN7Qfe]KFe]K@02Ti>C00>f][J@T92@T9000V=SH`03MgMgVYZJVYZJ00:EUID3PX:20X>3
P`9cLg<00fQXJ75aLG5aL@02P82000>7QhN5QHF5QHD00WemO@03MgMgOWinOWin00:?Shl00j2PX:VY
ZJVYZ@02YJFU00>?ShmTI6ATI6@00UIFEP03U9BDb<S8b<S800:GUiL3D51@0WQhN003W9bLZJVYZJVY
00:@T9000f][Jf=SHf=SH`02Lg=c00>8R8RJVYZJVYX00ZBTY003UYJFK6a/K6a/009?Cdl00f9RHXV9
RHV9R@02WinO00>LW9ahN7QhN7P00VIVIP03WinOclo?clo?00:HV9P00eYJFX61PH61P@02/k>c00>:
RXYFEUIFEUH00VYZJP03TY:BVi^KVi^K00:<S8`00fm_Ke]KFe]KF`02IVIV00>2PX:GUiNGUiL00YNG
U`03NGUiHF5QHF5Q009bLW800iFEUJb/[:b/[002YJFU0W5aL@03CDe=NGUiNGUi00:^[Zh00ibLW6i^
KVi^KP02F5QH00=MGEeiNGUiNGT00Xn?S`03OGemJFUYJFUY009fMWH00iZJV/_;bl_;b`02bLW900=K
Fe/410@410@00Ti>CP03_;bl][Jf][Jf00:2PX800gMgMgmoOgmoO`02PX:200>6QXJ:RXZ:RXX00Xb<
S003T92@UIFEUIFE00:JVYX00iRHV8b<S8b<S003oooo0P0003Coool010000?ooooooooooo`;6a/H0
0c8b<Xn?Shn?S`02MGEe00=^KVj5QHF5QHD00YVIV@03QHF5L71`L71`00::RXX00cDe=KJf][Jf]P02
<c<c00<V9RJUYJFUYJD00];BdP03NGUic/k>c/k>00:PX:000k6a/E9BDU9BDP02/;2`00>BTY:YZJVY
ZJT00TQ8B003Y:BTOGemOGem009lO7`00hZ:RX^;Rh^;R`02SHf=0YfMW@03ZJVY:BTY:BTY00:DU9@0
0hV9RH>3Ph>3P`02Q8B400>8R8R7QhN7QhL00hB4Q0:?Shl2YZJV00=ADE62PX:2PX800Xn?S`03CTi>
QHF5QHF500:DU9@00kfm_K^k^k^k^`02:RXZ00>DU9BBTY:BTY800ZRXZ003ATI6_[jn_[jn00:/[:`0
0iZJVXf=SHf=S@02R8R800>BTY:^[Zj^[Zh00T=3@`03YJFUQHF5QHF5009lO7`00hj>S[^k^k^k^`02
FEUI00>PX:1^KVi^KVh00Xf=S@03^;RhV9RHV9RH009fMWH00inOWe=CDe=CD`02^;Rh00>=SHelO7al
O7`00X61P@03UYJFZ:RXZ:RX00:RXZ800hj>SWinOWinOP02Ogmo00>IVIV^[Zj^[Zh00ZBTY003S8b<
OWinOWin00:6QXH2[jn_00=@D52TY:BTY:@00WemO@03UYJFc<c<c<c<009cLg<00gMgMeiNGUiNGP02
_;bl00>o_ko7alO7alL00[^k^`03X:2POGemOGem00:1PH400f5QHJBTY:BTY002IFEU00>9RHVKVi^K
Vi/00UmOG`03Ng]kQ8B4Q8B400::RXX00hV9RHF5QHF5Q@02PX:200=oOgmkNg]kNg/00WAdM003i>CT
GemOGemO00?oool200004_ooo`009Oooo`030000oooooooo00;oool2];Bd00>7QhMJFUYJFUX00VUY
J@03RXZ:QXJ6QXJ6009mOGd00iBDU::RXZ:RXP02Ogmo00=RHV:0P820P8000ZNWY`03XJ6QNWYjNWYj
0098B4P00c4a<E]KFe]KF`02U9BD00>MWIf<S8b<S8`00XB4Q003MgMgDU9BDU9B0092@T800fe]KIZJ
VYZJVP02SHf=00=dM7B6QXJ6QXH00YbLW0::RXX00fi^KVATI6ATI002Jf][00=nOWj=SHf=SHd00XJ6
QP03N7QhNWYjNWYj00:4Q8@00hZ:RXn?Shn?S`02W9bL00>KVi]fMWIfMWH00UiNGP03R8R8[jn_[jn_
00:;Rh/00eaLG6=SHf=SH`02S8b<00>k^k_<c<c<c<`00YfMW@03K6a/QHF5QHF500:[Zj/00hn?Sf][
Jf][J`02PX:200>BTY9GEeMGEeL00RLW9`03EUIFW9bLW9bL00:^[Zh00iNGUf=SHf=SH`02BTY:00>:
RXZk^k^k^k/00V9RHP034A4AJFUYJFUY00;;bl/00hB4Q2XZ:RXZ:P02H61P00>f][J_[jn_[jl00Wem
O@03FUYJCdm?Cdm?009OGel00h61PJFUYJFUY@02XZ:R00=GEeLL71`L71`00TY:BP03UIFEXj>SXj>S
00:>SXh2Ng]k00=fMWJ:RXZ:RXX00YnOW`03Vi^KPh>3Ph>3009SHf<00f9RHZ^[Zj^[Z`02fm_K00>;
Rh/g=cLg=cL00VIVIP03^[Zjclo?clo?00:WYjL00e1@D2<S8b<S8`02Ogmo00?Ng]jXZ:RXZ:P00Ti>
CP03Fe]KRh^;Rh^;00:?Shl00ginOW1`L71`L002IfMW00=aLG62PX:2PX800XR8R003T92@Zj^[Zj^[
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2VIVI00>JVYZTY:BTY:@00Xf=S@03MGEe
PH61PH6100:CTi<00hR8R8:2PX:2PP02Y:BT00=9BDVb/[:b/[800YbLW003ZJVYDE5ADE5A009gMgL0
0h>3PeUIFEUIF@029bLW00>LW9ba/K6a/K400TA4A003D51@h>3Ph>3P009VIVH00jj^[WalO7alO002
P82000>BTY:3Ph>3Ph<00WAdM0:5QHD00inOWjVYZJVYZ@02Xj>S00>@T91nOWinOWh00X61P@03RXZ:
R8R8R8R800:3Ph<00hJ6QY2@T92@T002Vi^K00>d];A]KFe]KFd00XN7Q`03FUYJW9bLW9bL00:OWil0
0c/k>jb/[:b/[002Ti>C00=jNWYdM7AdM7@00YVIV@03^;RhVIVIVIVI009eMGD00hj>SSXj>SXj>P02
Z:RX00>MWIe>CTi>CTh00VUYJ@03/[:bMWIfMWIf009aLG400iJFUUUIFEUIF@02N7Qh00>k^k^8R8R8
R8P00TY:BP03PX:2/K6a/K6a009SHf<00j6QXG5aLG5aL@02^[Zj00=/K6aZJVYZJVX00Xf=S@03YJFU
=3@d=3@d00:SXj<00hZ:RW5aLG5aL@02NWYj00>m_KeiNGUiNGT00UMGE`03UIFERh^;Rh^;00:LW9`2
<C4a00>^[ZjNWYjNWYh00Xn?S`03VYZJ?3`l?3`l00;Hf=P00fATI:6QXJ6QX@02MgMg00<j>SYkNg]k
Ng/00UEEE@03S8b<OWinOWin00:PX:000fa/K8j>SXj>SP02^k^k00=bLW:/[:b/[:`00Xj>SP03UYJF
O7alO7al009nOWh00hZ:RY6ATI6AT@02UYJF00>CTi><S8b<S8`00XV9R@03NWYjBTY:BTY:00Coool0
0`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`:d];@00hN7QeYJFUYJFP02JFUY00>:
RXZ6QXJ6QXH00WemO@03U9BDXZ:RXZ:R009oOgl00f9RHX20P820P002YjNW00>QXJ5jNWYjNWX00TQ8
B003<C4aFe]KFe]K00:DU9@00ifMWHb<S8b<S002Q8B400=gMgMBDU9BDU800T92@P03KFe]VYZJVYZJ
00:=SHd00gAdM8J6QXJ6QP02W9bL0XZ:RP03KVi^I6ATI6AT009[Jf/00ginOXf=SHf=S@02QXJ600=h
N7QjNWYjNWX00XB4Q003RXZ:Shn?Shn?00:LW9`00i^KVgIfMWIfMP02GUiN00>8R8R_[jn_[jl00X^;
R`03G5aLHf=SHf=S00:<S8`00k^k^lc<c<c<c002WIfM00=/K6b5QHF5QHD00Z^[Z`03Shn?Jf][Jf][
00:2PX800i:BTUMGEeMGE`029bLW00=FEUJLW9bLW9`00Zj^[P03UiNGHf=SHf=S009:BTX00hZ:R[^k
^k^k^`02HV9R00<A4A5YJFUYJFT00/_;b`03Q8B4:RXZ:RXZ009PH6000kJf]Zn_[jn_[`02OGem00=J
FUY?Cdm?Cdl00UmOG`03PH61YJFUYJFU00:RXZ800eMGEa`L71`L7002BTY:00>EUIFSXj>SXj<00Xj>
SP9kNg/00gIfMXZ:RXZ:RP02WinO00>KVi^3Ph>3Ph<00V=SH`03HV9RZj^[Zj^[00;Kfm/00h^;RcLg
=cLg=`02IVIV00>j^[[?clo?cll00ZNWY`03D51@8b<S8b<S009oOgl00mkNgZRXZ:RXZ002CTi>00=K
Fe^;Rh^;Rh/00Xn?S`03OWinL71`L71`009WIfL00g5aLH:2PX:2PP02R8R800>@T92[Zj^[Zj/01?oo
o`030000oooooooo03;oool010000?ooooooooooo`:IVIT00iZJVZBTY:BTY002SHf=00=eMGF1PH61
PH400Y>CT`03R8R8PX:2PX:200:TY:@00dU9BK:b/[:b/P02W9bL00>YZJUADE5ADE400WMgM`03Ph>3
FEUIFEUI008W9bL00ibLW;6a/K6a/@02A4A400=@D53Ph>3Ph>000VIVIP03[Zj^O7alO7al00:0P800
0i:BTX>3Ph>3P`02M7Ad0XF5Q@03WinOZJVYZJVY00:SXj<00i2@T7inOWinOP02PH6100>:RXZ8R8R8
R8P00X>3P`03QXJ6T92@T92@00:KVi/00kBd]6e]KFe]K@02QhN700=JFUZLW9bLW9`00YnOW`03>c/k
[:b/[:b/00:CTi<00gYjNWAdM7AdM002VIVI00>h^;RIVIVIVIT00WEeM@03SXj>>SXj>SXj00:XZ:P0
0ifMWDi>CTi>CP02JFUY00>b/[9fMWIfMWH00W5aL@03UYJFFEUIFEUI009hN7P00k^k^hR8R8R8R002
BTY:00>2PX:a/K6a/K400V=SH`03XJ6QLG5aLG5a00:j^[X00fa/K6YZJVYZJP02SHf=00>UYJDd=3@d
=3@00Z>SX`03RXZ:LG5aLG5a009jNWX00kfm_GUiNGUiN@02EeMG00>EUIF;Rh^;Rh/00YbLW08a<C40
0jj^[YjNWYjNWP02Shn?00>JVYXl?3`l?3`00]SHf003I6ATXJ6QXJ6Q009gMgL00cXj>W]kNg]kN`02
EEEE00><S8anOWinOWh00Z2PX003K6a/SXj>SXj>00:k^k/00g9bLZb/[:b/[002SXj>00>FUYIlO7al
O7`00WinOP03RXZ:TI6ATI6A00:FUYH00i>CThb<S8b<S002RHV900=jNWY:BTY:BTX01?ooo`030000
oooooooo013oool002Goool00`000?ooooooo`02oooo0ZVYZ@03OgmoB4Q8B4Q80093@d<00eEEEEIF
EUIFEP02F5QH00=aLG60P820P8000VUYJ@03Fe]KPh>3Ph>300>`/;02Shn?0V9RHP03C4a<JVYZJVYZ
00:IVIT00jRXZ9ZJVYZJVP02OWin00=QHF5DE5ADE5@00UiNGP03O7alTi>CTi>C00:6QXH00gAdM820
P820P002Ti>C0Xf=S@03OgmoNWYjNWYj009mOGd00hF5QH^;Rh^;R`02QXJ600=lO7agMgMgMgL00WMg
M`03OWinPH61PH61009fMWH00fa/K79bLW9bLP02PX:200>CTi>FUYJFUYH00WYjNP03IFEUP820P820
00:OWil00i>CTgQhN7QhN002Kfm_00=eMGF3Ph>3Ph<00Xj>SP03PH61N7QhN7Qh00:IVIT00jJVYV5Q
HF5QH@02:2PX00=GEeNRXZ:RXZ800[6a/@03UIFEJ6QXJ6QX009<C4`00fUYJHB4Q8B4Q002DU9B00<_
;bmmOGemOGd00/W9b@03Ti>CBDU9BDU9009SHf<00iRHV9:BTY:BTP02NGUi00=kNg^1PH61PH400gEe
M@:OWil2/k>c00=eMGDj>SXj>SX00UmOG`03VIVIShn?Shn?009_Kfl2K6a/00=iNGV3Ph>3Ph<00X^;
R`03TI6ARh^;Rh^;009^KVh00fe]KKJf][Jf]P02iNGU00>GUiLh>3Ph>3P00S/k>`03MGEe[Zj^[Zj^
00:g]kL00f5QHB0P820P8002LW9b00?De=B/[:b/[:`00UmOG`03Hf=SPh>3Ph>3009oOgl3LW9b0WEe
M@03NWYjNg]kNg]k009[Jf/00fMWIhj>SXj>SP04oooo00<0003oooooool0<_ooo`040000oooooooo
oooo0YbLW003VYZJ<S8b<S8b00:TY:@00iNGUj2PX:2PX002ZZZZ00<W9bNMWIfMWId00[Zj^P03d=3@
@D51@D5100:OWil00jJVY/;2`/;2`P02IfMW00=_Kfo6a/K6a/H00YbLW003UIFE[:b/[:b/009DE5@0
0nOWifi^KVi^KP02E5AD00>QXJ5nOWinOWh00X20P003SXj>QXJ6QXJ6009jNWX2PX:200>@T90M7AdM
7Ad00YBDU003Rh^;Ph>3Ph>300:3Ph<00hN7QhR8R8R8R002QhN700>5QHF>SXj>SXh00S4a<@03DU9B
fm_Kfm_K00;Hf=P00dY:BZn_[jn_[`02/K6a00<j>SZLW9bLW9`00X^;R`03WinO@D51@D5100:m_Kd0
0c8b<QTI6ATI6@02Ph>300>ATI6SXj>SXj<00Y>CT`03SHf=AdM7AdM700;Vi^H00kJf]WIfMWIfMP02
LW9b00>HV9S=cLg=cLd00WEeM@03GemO_;bl_;bl009RHV800gEeMJNWYjNWY`02I6AT00><S8a<C4a<
C4`00Zf][@03P820Ph>3Ph>300:EUID00i2@T8N7QhN7Q`02Shn?00>@T91eMGEeMGD00Vi^KP03Zj^[
JFUYJFUY009>CTh00iRHV9jNWYjNWP02]kNg0Shn?P03[Jf]YJFUYJFU008X:2P00j:RXS<c<c<c<`02
bl_;00=GEeNGUiNGUiL00Vm_K`03[Jf]PH61PH61009oOgl00e5ADIjNWYjNWP02V9RH00=SHf>HV9RH
V9P00UEEE@03Q8B4>3Ph>3Ph00:9RHT00iJFUXJ6QXJ6QP02R8R800>9RHUmOGemOGd00WEeM@03MWIf
PH61PH6100:EUID00i:BTU]KFe]KF`04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo
00;oool2ZJVY00=oOgm8B4Q8B4P00T=3@`03EEEEEUIFEUIF009HF5P00g5aLH20P820P002JFUY00=K
Fe^3Ph>3Ph<00k2`/0:?Shl2HV9R00=<C4aZJVYZJVX00YVIV@03Z:RXVYZJVYZJ009nOWh00f5QHEAD
E5ADE002GUiN00=lO7bCTi>CTi<00XJ6QP03M7AdP820P82000:CTi<2SHf=00=oOgmjNWYjNWX00Wem
O@03QHF5Rh^;Rh^;00:6QXH00galO7MgMgMgM`02MgMg00=nOWj1PH61PH400WIfMP03K6a/LW9bLW9b
00:2PX800i>CTiJFUYJFUP02NWYj00=UIFF0P820P8000YnOW`03Ti>CN7QhN7Qh009_Kfl00gEeMH>3
Ph>3P`02SXj>00>1PH5hN7QhN7P00YVIV@03YZJVHF5QHF5Q008X:2P00eMGEj:RXZ:RXP02/K6a00>E
UIEXJ6QXJ6P00Ta<C003JFUYQ8B4Q8B4009BDU800bl_;gemOGemO@02bLW900>CTi=9BDU9BDT00V=S
H`03V9RHTY:BTY:B009iNGT00g]kNh61PH61P@03MGEe0YnOW`:c/k<00gEeMCXj>SXj>P02GemO00>I
VIV?Shn?Shl00Vm_K`9/K6`00gUiNH>3Ph>3P`02Rh^;00>ATI6;Rh^;Rh/00Vi^KP03KFe]][Jf][Jf
00;UiND00iNGUcPh>3Ph>002>c/k00=eMGF^[Zj^[Zh00[Ng]`03HF5Q820P820P009bLW800mCDe:b/
[:b/[002GemO00=SHf>3Ph>3Ph<00WmoO`=bLW82MGEe00=jNWYkNg]kNg/00V][J`03IfMWSXj>SXj>
00Coool00`000?ooooooo`0boooo00@0003oooooooooool2W9bL00>JVYXb<S8b<S800ZBTY003UiNG
X:2PX:2P00:ZZZX00bLW9ifMWIfMW@02^[Zj00?@d=11@D51@D400YnOW`03YZJV`/;2`/;2009WIfL0
0fm_KlK6a/K6aP02W9bL00>EUIF/[:b/[:`00UADE003inOWKVi^KVi^009DE5@00j6QXGinOWinOP02
P82000>>SXj6QXJ6QXH00WYjNP:2PX800i2@T1dM7AdM7@02U9BD00>;Rh^3Ph>3Ph<00X>3P`03QhN7
R8R8R8R800:7QhL00hF5QHj>SXj>SP02<C4a00=BDU;Kfm_Kfm/00]SHf003BTY:[jn_[jn_00:a/K40
0cXj>YbLW9bLW002Rh^;00>OWim1@D51@D400[fm_@03<S8b6ATI6ATI00:3Ph<00i6ATJ>SXj>SX`02
Ti>C00>=SHe7AdM7AdL00^KViP03][JfMWIfMWIf009bLW800iRHV<g=cLg=c@02MGEe00=OGenl_;bl
_;`00V9RHP03MGEeYjNWYjNW009TI6@00hb<S4a<C4a<C002[Jf]00>0P823Ph>3Ph<00YFEU@03T92@
QhN7QhN700:?Shl00i2@T7EeMGEeM@02KVi^00>[Zj]YJFUYJFT00Ti>CP03V9RHWYjNWYjN00:g]kL2
?Shn00>][JfUYJFUYJD00RPX:003XZ:R<c<c<c<c00;;bl/00eMGEiNGUiNGU`02Kfm_00>][Jf1PH61
PH400WmoO`03DE5AWYjNWYjN00:HV9P00f=SHiRHV9RHV002EEEE00>4Q8@h>3Ph>3P00XV9R@03UYJF
QXJ6QXJ600:8R8P00hV9RGemOGemO@02MGEe00=fMWJ1PH61PH400YFEU@03TY:BFe]KFe]K00Coool0
0`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`:BTY800hB4Q5eMGEeMG@02BTY:00=4
A4A2@T92@T800Ta<C003IFEULW9bLW9b009JFUX00di>CW]kNg]kN`02/K6a00>n_[jYZJVYZJT00X20
P003J6QXP820P82000:UYJD00jVYZIBDU9BDU002MWIf00=TI6AcLg=cLg<00Xb<S003TI6AR8R8R8R8
009mOGd00gIfMWYjNWYjNP02Q8B40XV9R@03Rh^;T92@T92@00:CTi<00hj>SXN7QhN7Q`02Ph>300=o
OgmdM7AdM7@00Vm_K`03OWinPH61PH61009HF5P00c`l?6MWIfMWI`02WIfM00>NWYj6QXJ6QXH00WEe
M@03MWIfU9BDU9BD00:OWil00eiNGR@T92@T9002CTi>00>:RXYkNg]kNg/00UaLG003Kfm_UiNGUiNG
00:d];@00k6a/GalO7alO002CTi>00=UIFFEUIFEUID00ZNWY`03Vi^KOWinOWin009PH6000eEEEEaL
G5aLG002Hf=S00=dM7BHV9RHV9P00Zn_[`03W9bLNWYjNWYj009]KFd00fm_KgAdM7AdM002PX:200>N
WYjZZZZZZZX00XZ:RP03L71`T92@T92@00:d];@00iZJVWUiNGUiN@02S8b<00>QXJ61PH61PH400U]K
F`9RHV800gUiNGemOGemO@02O7al00>5QHF9RHV9RHT00WAdM003LG5aYJFUYJFU00;9bLT00ifMWEEE
EEEEE@02:BTY00<f=SJ@T92@T9000/g=c@03OGem8b<S8b<S009JFUX00k>c/j^[Zj^[Z`02P82000=k
Ng]mOGemOGd00V][J`03I6ATOGemOGem00:FUYH00i>CTgQhN7QhN002DU9B00=2@T9XJ6QXJ6P01?oo
o`030000oooooooo03;oool010000?ooooooooooo`:XZ:P00iJFUYnOWinOW`02YJFU00<a<C6d];Bd
];@00[Jf]P03<S8bZj^[Zj^[00;8b<P00f=SHd];Bd];B`02Y:BT00>QXJ4j>SXj>SX00/k>cP03e]KF
?Cdm?Cdm00:EUID00i^KVd=3@d=3@`02JFUY00=kNg]RHV9RHV800Zf][@03SHf=OgmoOgmo00:0P800
0hN7QhZ:RXZ:RP02RHV90hZ:RP:8R8P2QHF500>6QXJ7QhN7QhL00XF5Q@03Q8B4RHV9RHV900:<S8`0
0h:2PXR8R8R8R002^KVi00=ZJVYIFEUIFET00[2`/003=CDe^;Rh^;Rh0090@4000k:b/YVIVIVIV@02
UiNG00=JFUZ:RXZ:RXX00]OGe`03UYJFTi>CTi>C00:TY:@00iJFUWmoOgmoO`02Lg=c00=nOWjYZJVY
ZJT00Tm?C`03=cLgR8R8R8R8009oOgl00i:BTS/k>c/k>`02GEeM00?Shn=VIVIVIVH00]OGe`03B4Q8
VIVIVIVI009hN7P00gYjNXj>SXj>SP02VIVI00>LW9`V9RHV9RH00YRHV003OWinKFe]KFe]00:0P800
0iBDU820P820P002Kfm_00>@T92e]KFe]KD00Rl_;`03UYJF[:b/[:b/009>CTh2_kno00<a<C6WYjNW
YjL00Zb/[003<30`[jn_[jn_00;8b<P00eQHF:ZZZZZZZP02S8b<00>_[jm_Kfm_Kfl00YBDU003RXZ:
_;bl_;bl00:;Rh/00eADE9jNWYjNWP02Lg=c00>[Zj^n_[jn_[h00WQhN003RXZ:S8b<S8b<00:BTY80
0hJ6QUiNGUiNGP02^;Rh00=4A4ATI6ATI6@00Xj>SP03Vi^KK6a/K6a/00Coool00`000?ooooooo`0@
oooo000Uoooo00<0003oooooool00_ooo`:^[Zh00k:b/YVIVIVIV@02RXZ:00>4Q8AoOgmoOgl00X>3
P`03UIFETY:BTY:B009KFe/00cXj>WQhN7QhN003a<C40YRHV09ZJVX00e]KFhB4Q8B4Q002/K6a00>U
YJEmOGemOGd00fEUI@:3Ph<2X:2P00>HV9QnOWinOWh00Vi^KP03KFe]OWinOWin00:?Shl2RXZ:00=n
OWimOGemOGd00X>3P`03Rh^;SHf=SHf=00:6QXH00g]kNg9bLW9bLP02Lg=c00>9RHVBTY:BTY800Vi^
KP03CDe=I6ATI6AT00:;Rh/00hj>SXN7QhN7Q`02UIFE00>OWinDU9BDU9@00W]kN`03Fe]KE5ADE5AD
00:5QHD00jn_[hn?Shn?S`02HV9R00=eMGFJVYZJVYX00YbLW0>@T902SHf=00=jNWYcLg=cLg<00Y6A
T@03Zj^[UYJFUYJF009cLg<00fQXJ75aLG5aL@02Ph>30i>CT`:9RHT00hB4Q7moOgmoO`02M7Ad00=a
LG61PH61PH400Y2@T003RXZ:OGemOGem009mOGd00h>3PhZ:RXZ:RP02SXj>0hR8R0:RXZ800k2`/8N7
QhN7Q`02GemO0WMgM`03Vi^KT92@T92@009gMgL00g]kNh61PH61P@02KFe]00=VIVJ?Shn?Shl00[Bd
]003WYjNMWIfMWIf009TI6@00g5aLJ:RXZ:RXP02_kno00>>SXiFEUIFEUH00Ve]K@03UiNGR8R8R8R8
009`L7000hF5QIFEUIFEU@02LW9b00=FEUIhN7QhN7P00Z6QX@03VYZJMGEeMGEe009=CDd00dA4A7Ee
MGEeM@04oooo00<0003oooooool0<_ooo`040000oooooooooooo0X^;R`03MGEeNg]kNg]k00:0P800
0hJ6QXn?Shn?S`02TY:B00>:RXXJ6QXJ6QX00/W9b@03M7AdCTi>CTi>00:EUID00inOWda<C4a<C003
JVYZ0Sdm?@:@T9000jFUYF1PH61PH002oooo00>9RHUOGemOGel00Z6QX@03QXJ6PH61PH6100:6QXH0
0hZ:RXJ6QXJ6QP02PX:20Xf=S@03VIVIVi^KVi^K00:EUID00h^;Rh>3Ph>3P`02PX:200>6QXJ:RXZ:
RXX00XV9R@03Ng]kNWYjNWYj00:SXj<00l[:bTY:BTY:BP02[Jf]00<e=CFc/k>c/k<00ZFUY@03W9bL
;bl_;bl_00;2`/800fEUIFMWIfMWI`02Zj^[00=fMWIoOgmoOgl00YRHV003RHV9LW9bLW9b009kNg/0
0hj>SY>CTi>CT`02UYJF00>VYZJ/[:b/[:`00YFEU@03Ph>3V9RHV9RH00:k^k/3DU9B0TU9B@03/[:b
Xj>SXj>S00:FUYH00hJ6QWinOWinOP02RHV900>HV9RJVYZJVYX00YJFUP>HV9P2SXj>00>4Q8B5QHF5
QHD00Xn?S`03Xj>S[Jf][Jf]00:JVYX00hb<S:RXZ:RXZ002BDU90ZZZZP03Rh^;U9BDU9BD00:/[:`0
0k6a/Cdm?Cdm?@02d];B00=WIfM9BDU9BDT00ZFUY@03>c/ke=CDe=CD009XJ6P00eiNG[:b/[:b/P02
92@T00?7alMmOGemOGd00^OWi`03De=CJf][Jf][00:=SHd00hJ6QWQhN7QhN002Q8B400>2PX;6a/K6
a/H00Y>CT`03VIVI`/;2`/;2009eMGD00h>3Pe9BDU9BDP04oooo00<0003oooooool04?ooo`009Ooo
o`030000oooooooo00;oool2[Zj^00>b/[:IVIVIVIT00XZ:RP03Q8B4OgmoOgmo00:3Ph<00iFEUI:B
TY:BTP02Fe]K00<j>SYhN7QhN7P00lC4a0:HV9P2JVYZ00=KFe^4Q8B4Q8@00[6a/@03YJFUOGemOGem
00=UIFD2Ph>30Z2PX003V9RHOWinOWin009^KVh00fe]KGinOWinOP02Shn?0XZ:RP03OWinOGemOGem
00:3Ph<00h^;Rhf=SHf=S@02QXJ600=kNg]bLW9bLW800W=cL`03RHV9TY:BTY:B009^KVh00de=CFAT
I6ATI002Rh^;00>>SXj7QhN7QhL00YFEU@03WinOU9BDU9BD009kNg/00e]KFeADE5ADE002QHF500>_
[jn?Shn?Shl00V9RHP03MGEeVYZJVYZJ00:LW9`3T92@0Xf=S@03NWYjLg=cLg=c00:ATI400j^[ZiJF
UYJFUP02Lg=c00=XJ6QaLG5aLG400X>3P`>CTi<2RHV900>4Q8AoOgmoOgl00WAdM003LG5aPH61PH61
00:@T9000hZ:RWemOGemO@02OGem00>3Ph>:RXZ:RXX00Xj>SP>8R8P2XZ:R00>`/;27QhN7QhL00UmO
G`9gMgL00i^KVi2@T92@T002MgMg00=kNg^1PH61PH400Ve]K@03IVIVShn?Shn?00:d];@00ijNWWIf
MWIfMP02I6AT00=aLG6RXZ:RXZ800[no_`03SXj>EUIFEUIF009]KFd00iNGUhR8R8R8R002L71`00>5
QHFEUIFEUID00W9bLP03EUIFN7QhN7Qh00:QXJ400iZJVWEeMGEeM@02CDe=00=4A4AeMGEeMGD01?oo
o`030000oooooooo03;oool010000?ooooooooooo`:;Rh/00gEeMG]kNg]kN`02P82000>6QXJ?Shn?
Shl00Y:BTP03RXZ:6QXJ6QXJ00;9bLT00gAdM4i>CTi>CP02UIFE00>OWim<C4a<C4`00fYZJP8m?Cd2
T92@00>UYJEPH61PH6000_ooo`03RHV9GemOGemO00:QXJ400hJ6QX61PH61P@02QXJ600>:RXZ6QXJ6
QXH00X:2PP:=SHd00iVIVI^KVi^KV`02UIFE00>;Rh^3Ph>3Ph<00X:2PP03QXJ6RXZ:RXZ:00:9RHT0
0g]kNgYjNWYjNP02Xj>S00?:b/Y:BTY:BTX00Zf][@03=CDe/k>c/k>c00:UYJD00ibLW2l_;bl_;`02
`/;200=UIFEWIfMWIfL00Z^[Z`03MWIfOgmoOgmo00:HV9P00hV9RG9bLW9bLP02Ng]k00>>SXjCTi>C
Ti<00YJFUP03YZJV[:b/[:b/00:EUID00h>3PiRHV9RHV002^k^k0e9BDP99BDT00k:b/Z>SXj>SX`02
UYJF00>6QXInOWinOWh00XV9R@03V9RHVYZJVYZJ00:FUYH3V9RH0Xj>SP03Q8B4QHF5QHF500:?Shl0
0j>SXjf][Jf][@02VYZJ00><S8bXZ:RXZ:P00TU9B@:ZZZX00h^;RiBDU9BDU002[:b/00>a/K4m?Cdm
?Cd00];BdP03IfMWBDU9BDU900:UYJD00c/k>mCDe=CDe002J6QX00=NGUjb/[:b/[800R@T9003alO7
OGemOGem00;WinL00e=CDf][Jf][J`02SHf=00>6QXIhN7QhN7P00XB4Q003PX:2a/K6a/K600:CTi<0
0iVIVL;2`/;2`P02MGEe00>3Ph=BDU9BDU801?ooo`030000oooooooo013oool002Goool00`000?oo
ooooo`02oooo0/71`@03b<S8^k^k^k^k00:i^KT00k^k^kFe]KFe]@02];Bd00?6a/Jm_Kfm_Kd00Va/
K003=3@dN7QhN7Qh00;:b/X00k>c/fm_Kfm_K`02Cdm?00=DE5AmOGemOGd00Z:RXP03V9RHMWIfMWIf
009QHF400fATI8N7QhN7Q`02YJFU00>HV9QhN7QhN7P00VEUI@03J6QXQHF5QHF500:MWId2S8b<00=^
KViTI6ATI6@00Ve]K@03Ph>3TY:BTY:B00:9RHT00gMgMg9bLW9bLP02O7al00>CTi>RXZ:RXZ800YFE
U@03NWYjJ6QXJ6QX009YJFT00gemOIRHV9RHV002[Jf]00>XZ:QlO7alO7`00U]KF`03M7AdXj>SXj>S
00:n_[h00kbl_9jNWYjNWP02OGem00=nOWj6QXJ6QXH00W5aL@03IfMWVIVIVIVI00:n_[h00hR8R55A
DE5AD@02NGUi00>a/K6NWYjNWYh00W]kN`03R8R8XZ:RXZ:R00:PX:000hn?SgemOGemO@02KVi^00=Z
JVYaLG5aLG400WYjNP03R8R8W9bLW9bL00:KVi/00fUYJD92@T92@P02I6AT00>DU9B?Shn?Shl00WEe
M@03Jf][MWIfMWIf00:KVi/00k6a/HZ:RXZ:RP02IfMW0YBDU003a<C4XJ6QXJ6Q009/K6`00g9bLXB4
Q8B4Q002JVYZ00=GEeMmOGemOGd00ZFUY@03UIFEP820P82000:LW9`00kbl_;>c/k>c/`02VYZJ00><
S8b6QXJ6QXH00XN7Q`03Ph>3JVYZJVYZ009OGel00h^;Rjf][Jf][@02P82000=?Cdm`L71`L7000Z2P
X003Vi^KNWYjNWYj009RHV800f=SHi2@T92@T004oooo00<0003oooooool0<_ooo`040000oooooooo
oooo0WemO@03KFe]L71`L71`009^KVh00fe]KGAdM7AdM002NGUi00=/K6afMWIfMWH00[fm_@03N7Qh
Bd];Bd];00:<S8`00jZZZVa/K6a/K002PH6100?[jn]6ATI6ATH00Z2PX003][JfKFe]KFe]00>@T902
H61P0YnOW`03Q8B4Ph>3Ph>300::RXX00hf=SH20P820P002NGUi0Xf=S@03Z:RX>3Ph>3Ph00:XZ:P0
0i6ATGinOWinOP02Ogmo00>9RHV<S8b<S8`00XJ6QP03N7QhLg=cLg=c00:5QHD00j:RXShn?Shn?P02
_[jn00>d];BSXj>SXj<00Q`L7003WIfMaLG5aLG5009ZJVX00eIFEZ:RXZ:RXP02OWin00=]KFedM7Ad
M7@00X:2PP03OWinO7alO7al00:EUID00jJVYXF5QHF5Q@02KVi^00>OWimFEUIFEUH00Zf][@03Ng]k
QhN7QhN700:UYJD00jBTY9bLW9bLW002ZJVY00>h^;Po?clo?cl00Zj^[P03VYZJQhN7QhN700:3Ph<3
QhN70Y>CT`03^KViDe=CDe=C00:TY:@00gMgMh:2PX:2PP02YZJV00=5ADE7AdM7AdL00ZBTY003S8b<
:b/[:b/[00:j^[X2T92@00=WIfN5QHF5QHD00[Fe]@03?clo]KFe]KFe009LG5`00gEeMEYJFUYJFP02
/k>c00=5ADG>c/k>c/h00Shn?P03X:2PZj^[Zj^[00;3`l<00eMGEeiNGUiNGP02HF5Q00=ZJVZ9RHV9
RHT00YbLW003OWinG5aLG5aL009^KVh00gUiND92@T92@P02PH6100>4Q8BXZ:RXZ:P00/[:bP03dm?C
[Zj^[Zj^00Coool00`000?ooooooo`0@oooo000Uoooo0P0000?oool2`L7100?8b<Rk^k^k^k/00[Vi
^@03^k^k]KFe]KFe00:d];@00lK6a[fm_Kfm_@02K6a/00<d=3AhN7QhN7P00/[:bP03/k>cKfm_Kfm_
009?Cdl00eADE7emOGemO@02XZ:R00>HV9QfMWIfMWH00V5QH@03I6ATQhN7QhN700:UYJD00iRHV7Qh
N7QhN002IFEU00=XJ6R5QHF5QHD00YfMW@:<S8`00fi^KVATI6ATI002KFe]00>3Ph>BTY:BTY800XV9
R@03MgMgLW9bLW9b009lO7`00i>CTj:RXZ:RXP02UIFE00=jNWYXJ6QXJ6P00VUYJ@03OGemV9RHV9RH
00:][Jd00jRXZ7alO7alO002Fe]K00=dM7BSXj>SXj<00[jn_P03_;blWYjNWYjN009mOGd00ginOXJ6
QXJ6QP02LG5a00=WIfNIVIVIVIT00[jn_P03R8R8DE5ADE5A009iNGT00k6a/IjNWYjNWP02Ng]k00>8
R8RRXZ:RXZ800Z2PX003Shn?OGemOGem009^KVh00fYZJW5aLG5aL@02NWYj00>8R8RLW9bLW9`00Y^K
V`03JFUY@T92@T92009TI6@00iBDU8n?Shn?S`02MGEe00=[Jf]fMWIfMWH00Y^KV`03/K6aRXZ:RXZ:
009WIfL2U9BD00?4a<BQXJ6QXJ400Va/K003LW9bQ8B4Q8B4009ZJVX00eMGEgemOGemO@02YJFU00>E
UIF0P820P8000YbLW003_;bl/k>c/k>c00:JVYX00hb<S8J6QXJ6QP02QhN700>3Ph=ZJVYZJVX00UmO
G`03Rh^;[Jf][Jf]00:0P8000dm?Cg1`L71`L002X:2P00>KVi]jNWYjNWX00V9RHP03Hf=ST92@T92@
00?oool20000=?ooo`040000oooooooooooo0WemO@03KFe]L71`L71`009^KVh00fe]KGAdM7AdM002
NGUi00=/K6afMWIfMWH00[fm_@03N7QhBd];Bd];00:<S8`00jZZZVa/K6a/K002PH6100?[jn]6ATI6
ATH00Z2PX003][JfKFe]KFe]00>@T902H61P0YnOW`03Q8B4Ph>3Ph>300::RXX00hf=SH20P820P002
NGUi0Xf=S@03Z:RX>3Ph>3Ph00:XZ:P00i6ATGinOWinOP02Ogmo00>9RHV<S8b<S8`00XJ6QP03N7Qh
Lg=cLg=c00:5QHD00j:RXShn?Shn?P02_[jn00>d];BSXj>SXj<00Q`L7003WIfMaLG5aLG5009ZJVX0
0eIFEZ:RXZ:RXP02OWin00=]KFedM7AdM7@00X:2PP03OWinO7alO7al00:EUID00jJVYXF5QHF5Q@02
KVi^00>OWimFEUIFEUH00Zf][@03Ng]kQhN7QhN700:UYJD00jBTY9bLW9bLW002ZJVY00>h^;Po?clo
?cl00Zj^[P03VYZJQhN7QhN700:3Ph<3QhN70Y>CT`03^KViDe=CDe=C00:TY:@00gMgMh:2PX:2PP02
YZJV00=5ADE7AdM7AdL00ZBTY003S8b<:b/[:b/[00:j^[X2T92@00=WIfN5QHF5QHD00[Fe]@03?clo
]KFe]KFe009LG5`00gEeMEYJFUYJFP02/k>c00=5ADG>c/k>c/h00Shn?P03X:2PZj^[Zj^[00;3`l<0
0eMGEeiNGUiNGP02HF5Q00=ZJVZ9RHV9RHT00YbLW003OWinG5aLG5aL009^KVh00gUiND92@T92@P02
PH6100>4Q8BXZ:RXZ:P00/[:bP03dm?C[Zj^[Zj^00?oool200004_ooo`009Oooo`030000oooooooo
00;oool2RHV900>6QXJ4Q8B4Q8@00XN7Q`03S8b<QhN7QhN700:=SHd00k>c/l?3`l?3``02QhN700=@
D51hN7QhN7P00ZNWY`03O7alATI6ATI6009NGUh00hN7QgYjNWYjNP02IfMW00>4Q8BLW9bLW9`00Wem
O@03GUiNOGemOGem00:SXj<00iRHV7YjNWYjNP02KFe]00=aLG64Q8B4Q8@00YBDU0:9RHT00gEeMFi^
KVi^KP02M7Ad00>2PX:<S8b<S8`00XN7Q`03O7alN7QhN7Qh009oOgl00i2@T9nOWinOW`02XJ6Q00>B
TY9]KFe]KFd00UeMG@03RHV9[jn_[jn_00:9RHT3DU9B0W1`L003RXZ:Vi^KVi^K00:MWId00i>CThN7
QhN7Q`02NWYj00=_KfmTI6ATI6@00UEEE@03G5aLU9BDU9BD00:i^KT00hJ6QT];Bd];B`02JVYZ00>L
W9b;Rh^;Rh/00WEeM@03VYZJ_[jn_[jn00:SXj<00gMgMf][Jf][J`02Kfm_00=/K6a`L71`L7000XF5
Q@03VYZJYjNWYjNW00:KVi/00fe]KDY:BTY:BP02GEeM00>7QhNPX:2PX:000YfMW@03MWIfF5QHF5QH
009dM7@00iBDU7AdM7AdM002G5aL0Y^KV`03d=3@TY:BTY:B009:BTX00fa/K:2PX:2PX002PH6100=I
FEUhN7QhN7P00YbLW003O7alFEUIFEUI009iNGT00j6QXHn?Shn?S`02LG5a00=fMWJ4Q8B4Q8@00X61
P@03NWYjMWIfMWIf009nOWh00iVIVJFUYJFUY@02OGem00=HF5QeMGEeMGD00Z2PX003WYjNRh^;Rh^;
00:;Rh/00i2@T8f=SHf=S@04oooo00<0003oooooool0<_ooo`040000oooooooooooo0[>c/`03/K6a
[jn_[jn_00:/[:`00jVYZJj^[Zj^[P02ZJVY00>8R8QhN7QhN7P00ZRXZ003emOGA4A4A4A400:QXJ40
0lk>cXN7QhN7Q`02LG5a00?2`/9=CDe=CDd00]KFeP03DE5ACTi>CTi>009fMWH00hn?Sf9RHV9RHP02
W9bL00>3Ph>2PX:2PX800XF5Q@03QhN7PH61PH61009oOgl2SXj>00>PX:0[:b/[:b/00YjNWP03SXj>
PH61PH6100:0P8000hN7Qhb<S8b<S002S8b<00>5QHF1PH61PH400XF5Q@03UIFE?Shn?Shn00;9bLT0
0c0`<92@T92@T002];Bd00=[Jf]`L71`L7000]?Cd`03A4A4ZJVYZJVY00:LW9`00iBDU8n?Shn?S`02
SHf=00>@T92HV9RHV9P00ZRXZ003<30`QHF5QHF5009`L7000jBTY5iNGUiNGP02@41000>8R8R=SHf=
SHd00R<S8`03QXJ6N7QhN7Qh00:LW9`00da<C4e=CDe=C@02/[:b00<X:2RBTY:BTY800XB4Q003OWin
PH61PH61008I6AT00kBd]4];Bd];B`02ZZZZ00>3Ph=fMWIfMWH00XV9R@03^;RhHV9RHV9R00;6a/H0
0jBTY3`l?3`l?002`L710XZ:RP03GemOU9BDU9BD009KFe/00dI6AYfMWIfMW@02_kno00?WinMGEeMG
EeL00[Fe]@03d=3@M7AdM7Ad009MGEd00kbl_5IFEUIFEP02M7Ad00=bLW;Ph>3Ph>000VUYJ@03jn_[
NGUiNGUi009jNWX00fEUILk>c/k>cP02gMgM00=XJ6Ra/K6a/K400ginOP8N7Qh2;2`/00<d=3@i>CTi
>CT01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0Tm?C`03@D51ATI6ATI6
0098B4P3BTY:0UMGE`03Q8B4Z:RXZ:RX00:DU9@00g=cLginOWinOP02QhN700=HF5Pk>c/k>c/00X20
P003^[ZjLG5aLG5a008[:b/00g]kNmGEeMGEe@02XJ6Q00=CDe=YJFUYJFT00Y^KV`03UiNGPH61PH61
009jNWX00g]kNh61PH61P@04QhN700>3Ph>2PX:2PX800X>3P`J2PX82PH610X>3P`03QXJ6S8b<S8b<
00>HV9P2M7Ad0V9RHP03Vi^K`<30`<30009WIfL00`l?3clo?clo?`02Ti>C00>HV9QiNGUiNGT00VUY
J@03IVIVL71`L71`009iNGT00fYZJUIFEUIFEP02De=C00=VIVJ;Rh^;Rh/00Z2PX003Ph>3GEeMGEeM
009UIFD00gUiNFa/K6a/K002J6QX00>FUYJj^[Zj^[X00YJFUP03I6ATIVIVIVIV00=kNg/2O7al0Y2@
T003Xj>SXZ:RXZ:R00:@T9000gMgMfEUIFEUI@02HV9R00=iNGV][Jf][Jd00/G5a@03RXZ:ADE5ADE5
009@D5000g9bLUeMGEeMG@02DE5A0Y>CT`03`/;2N7QhN7Qh008a<C400g=cLl?3`l?3``02UIFE00=C
De=cLg=cLg<00YnOW`03NWYjATI6ATI60097AdL00eaLG6ATI6ATI002IfMW00=[Jf]^KVi^KVh00Vm_
K`03NGUiTY:BTY:B00:UYJD00jBTY96ATI6AT@02LG5a00=RHV9nOWinOWh00Z6QX@03W9bLT92@T92@
00:SXj<00jf][H:2PX:2PP04oooo00<0003oooooool0<_ooo`040000oooooooooooo0WMgM`03P820
Ng]kNg]k009kNg/00galO7emOGemO@02Kfm_00>m_KfGUiNGUiL00Z2PX003]kNg=cLg=cLg00:a/K40
0fMWIhJ6QXJ6QP02Cdm?00>HV9QHF5QHF5P00Y>CT`03FUYJU9BDU9BD00;6a/H00hZ:RVIVIVIVIP02
W9bL00>4Q8B2PX:2PX800X61P@03Ph>3QXJ6QXJ600:8R8P2Rh^;00>?Shn>SXj>SXh00X^;R`03R8R8
QXJ6QXJ600:3Ph<00hB4Q8Z:RXZ:RP02TY:B00>JVYZNWYjNWYh00Y^KV`03WinOADE5ADE500;?cll0
0j6QXHF5QHF5Q@02EEEE00>OWimjNWYjNWX00[6a/@03[Jf]`l?3`l?3009@D5000l71`C@d=3@d=002
W9bL00>PX:0a<C4a<C400ZZZZP03WIfMR8R8R8R800:2PX800jFUYLW9bLW9b@02_Kfm00>PX:2NWYjN
WYh00Y^KV`03Ng]kJf][Jf][00:GUiL00lW9bDi>CTi>CP02[Zj^00>TY:BMWIfMWId00X^;R`03P820
QXJ6QXJ600:EUID00j>SXc0`<30`<002Y:BT00>ATI5_Kfm_Kfl00V][J`03Zj^[Lg=cLg=c009ZJVX0
0l30`4e=CDe=C@02bLW90Y2@T003KFe]/;2`/;2`00;_knl00d=3@ginOWinOP02YjNW00=WIfM@D51@
D5000ZRXZ003DE5APH61PH6100:8R8P00gmoOh61PH61P@02Q8B400>1PH5lO7alO7`00WMgM`03K6a/
F5QHF5QH00;2`/800l?3`e=CDe=CD`02GemO00?Bd]:ZZZZZZZX00XB4Q003RXZ:WYjNWYjN00:KVi/0
0ijNW/K6a/K6aP04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2Cdm?00=1
@D56ATI6ATH00TQ8B0=:BTX2EeMG00>4Q8BXZ:RXZ:P00YBDU003Lg=cOWinOWin00:7QhL00eQHF3/k
>c/k>`02P82000>j^[YaLG5aLG400R/[:`03Ng]keMGEeMGE00:QXJ400e=CDfUYJFUYJ@02Vi^K00>G
UiN1PH61PH400WYjNP03Ng]kPH61PH6100B7QhL00h>3Ph:2PX:2PP02Ph>31X:2PP:1PH42Ph>300>6
QXJ<S8b<S8`00iRHV09dM7@2HV9R00>KVi_0`<30`<000VMWI`033`l??clo?clo00:CTi<00iRHV7Ui
NGUiN@02JFUY00=VIVI`L71`L7000WUiN@03JVYZEUIFEUIF009CDe<00fIVIX^;Rh^;R`02X:2P00>3
Ph=MGEeMGEd00VEUI@03NGUiK6a/K6a/009XJ6P00iJFU[Zj^[Zj^P02UYJF00=TI6AVIVIVIVH00g]k
N`9lO7`2T92@00>SXj>RXZ:RXZ800Y2@T003MgMgIFEUIFEU009RHV800gUiNJf][Jf][@02aLG500>:
RXY5ADE5ADD00U1@D003LW9bGEeMGEeM009ADE42Ti>C00?2`/9hN7QhN7P00S4a<@03Lg=c`l?3`l?3
00:EUID00e=CDg=cLg=cL`02WinO00=jNWY6ATI6ATH00TM7A`03G5aLI6ATI6AT009WIfL00f][Jfi^
KVi^KP02Kfm_00=iNGVBTY:BTY800ZFUY@03Y:BTTI6ATI6A009aLG400f9RHWinOWinOP02XJ6Q00>L
W9b@T92@T9000Z>SX`03[Jf]PX:2PX:200Coool00`000?ooooooo`0boooo00@0003oooooooooool2
MgMg00>0P81kNg]kNg/00W]kN`03O7alOGemOGem009_Kfl00kfm_INGUiNGU`02X:2P00>g]kLg=cLg
=cL00[6a/@03IfMWQXJ6QXJ6009?Cdl00iRHV5QHF5QHF002Ti>C00=JFUZDU9BDU9@00/K6aP03RXZ:
IVIVIVIV00:LW9`00hB4Q8:2PX:2PP02PH6100>3Ph>6QXJ6QXH00XR8R0:;Rh/00hn?Shj>SXj>SP02
Rh^;00>8R8R6QXJ6QXH00X>3P`03Q8B4RXZ:RXZ:00:BTY800iZJVYjNWYjNWP02Vi^K00>OWim5ADE5
ADD00/o?c`03XJ6QQHF5QHF5009EEED00inOWgYjNWYjNP02/K6a00>][Jg3`l?3`l<00U1@D003`L71
=3@d=3@d00:LW9`00j2PX34a<C4a<@02ZZZZ00>MWIf8R8R8R8P00X:2PP03YJFUbLW9bLW900:m_Kd0
0j2PX9jNWYjNWP02Vi^K00=kNg][Jf][Jf/00YNGU`03bLW9CTi>CTi>00:^[Zh00jBTY9fMWIfMW@02
Rh^;00>0P826QXJ6QXH00YFEU@03Xj>S<30`<30`00:TY:@00i6ATFm_Kfm_K`02Jf][00>[Zj]cLg=c
Lg<00VYZJP03`<30CDe=CDe=00;9bLT2T92@00=]KFf`/;2`/;000^o_k`03@d=3OWinOWin00:WYjL0
0fMWIe1@D51@D002Z:RX00=ADE61PH61PH400XR8R003OgmoPH61PH6100:4Q8@00h61PGalO7alO002
MgMg00=/K6aHF5QHF5P00/;2`P03`l?3De=CDe=C009OGel00m;BdZZZZZZZZP02Q8B400>:RXZNWYjN
WYh00Y^KV`03WYjNa/K6a/K600Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_oo
o`9KFe/00eEEEEeMGEeMG@02Fe]K00=IFEULG5aLG5`00V=SH`03KFe]MgMgMgMg009hN7P00g]kNhf=
SHf=S@02V9RH00=oOgm]KFe]KFd00YRHV003[Zj^FUYJFUYJ008P82000hj>S_gmoOgmo@02]kNg00=;
Bd]KFe]KFe/00YBDU003UiNGQ8B4Q8B4009kNg/00gYjNX:2PX:2PP02SHf=0Xb<S003Q8B4P820P820
009nOWh00galO7emOGemO@02Ogmo00>3Ph>:RXZ:RXX00Xb<S003PX:2NWYjNWYj00:9RHT00iBDU7Qh
N7QhN002J6QX00>JVY[3`l?3`l<00Y6AT@03EEEEIfMWIfMW00:BTY800iVIVHV9RHV9R@02LW9b00=X
J6R0P820P8000Y^KV`03Ti>CO7alO7al009aLG400gQhN96ATI6AT@02Xj>S00>EUIEgMgMgMgL00V=S
H`03FUYJF5QHF5QH009SHf<00gmoOi:BTY:BTP02QhN700=dM7AeMGEeMGD00X20P003QhN7Shn?Shn?
00:KVi/00j2PX9NGUiNGU`02PH6100=VIVIIFEUIFET00VYZJP03RXZ:YZJVYZJV00:YZJT00h61PEIF
EUIFEP02F5QH00=YJFUNGUiNGUh00UYJFP:9RHT00jNWYfe]KFe]K@02@41000>?ShoEeMGEeMD00XN7
Q`03:b/[EEEEEEEE00:WYjL00kNg]iJFUYJFUP02G5aL00<j>SYUIFEUIFD00YbLW003Shn?JVYZJVYZ
009UIFD00gYjNYRHV9RHV002[Jf]00>UYJF9RHV9RHT00VUYJ@03GemOPh>3Ph>300:VYZH00i6ATGAd
M7AdM002RXZ:00>QXJ63Ph>3Ph<01?ooo`030000oooooooo03;oool010000?ooooooooooo`9iNGT0
0h20P7]kNg]kN`02Ogmo00>5QHF3Ph>3Ph<00WUiN@03IFEUCTi>CTi>008o?cl00jf][B@T92@T9002
VYZJ00>g]kMEEEEEEED00[6a/@03XZ:RL71`L71`00:RXZ800lK6aVm_Kfm_K`02Z:RX00>0P81UIFEU
IFD00YbLW003QXJ6QhN7QhN700:8R8P00hZ:RXN7QhN7Q`02PH610X>3P`03RHV9RXZ:RXZ:00::RXX0
0hR8R8J6QXJ6QP03Q8B40XR8R0:CTi<00c0`<492@T92@P02][Jf00>b/[9ADE5ADE400UaLG003ZZZZ
QHF5QHF500:[Zj/00f1PH<_;bl_;b`02<30`00</;2`i>CTi>CT00/?3``03CDe=[:b/[:b/00:>SXh0
0hZ:RY>CTi>CT`02U9BD00>=SHf0P820P8000WalO003U9BD>3Ph>3Ph0093@d<00c`l?:VYZJVYZ@02
V9RH00>3Ph=nOWinOWh00YBDU003[jn_?3`l?3`l00:_[jl00jVYZBPX:2PX:002U9BD00><S8b?Shn?
Shl00YZJVP03ZJVY[Jf][Jf]00:LW9`00hF5QGQhN7QhN002QHF500>d];AVIVIVIVH00V=SH`03a/K6
C4a<C4a<0098B4P2Vi^K00>7QhM4A4A4A4@00Vi^KP03Z:RXK6a/K6a/00:[Zj/00gemOEeMGEeMG@02
UiNG00>ATI6d];Bd];@00WEeM@03WIfMQ8B4Q8B400;Fe]H00fMWIh20P820P002O7al00?MgMe6ATI6
ATH00S4a<@03[Zj^ATI6ATI6009HF5P00eMGEc4a<C4a<@02Rh^;00>QXJ71`L71`L400[Zj^P03/K6a
EEEEEEEE00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9KFe/00eEEEEeM
GEeMG@02Fe]K00=IFEULG5aLG5`00V=SH`03KFe]MgMgMgMg009hN7P00g]kNhf=SHf=S@02V9RH00=o
Ogm]KFe]KFd00YRHV003[Zj^FUYJFUYJ008P82000hj>S_gmoOgmo@02]kNg00=;Bd]KFe]KFe/00YBD
U003UiNGQ8B4Q8B4009kNg/00gYjNX:2PX:2PP02SHf=0Xb<S003Q8B4P820P820009nOWh00galO7em
OGemO@02Ogmo00>3Ph>:RXZ:RXX00Xb<S003PX:2NWYjNWYj00:9RHT00iBDU7QhN7QhN002J6QX00>J
VY[3`l?3`l<00Y6AT@03EEEEIfMWIfMW00:BTY800iVIVHV9RHV9R@02LW9b00=XJ6R0P820P8000Y^K
V`03Ti>CO7alO7al009aLG400gQhN96ATI6AT@02Xj>S00>EUIEgMgMgMgL00V=SH`03FUYJF5QHF5QH
009SHf<00gmoOi:BTY:BTP02QhN700=dM7AeMGEeMGD00X20P003QhN7Shn?Shn?00:KVi/00j2PX9NG
UiNGU`02PH6100=VIVIIFEUIFET00VYZJP03RXZ:YZJVYZJV00:YZJT00h61PEIFEUIFEP02F5QH00=Y
JFUNGUiNGUh00UYJFP:9RHT00jNWYfe]KFe]K@02@41000>?ShoEeMGEeMD00XN7Q`03:b/[EEEEEEEE
00:WYjL00kNg]iJFUYJFUP02G5aL00<j>SYUIFEUIFD00YbLW003Shn?JVYZJVYZ009UIFD00gYjNYRH
V9RHV002[Jf]00>UYJF9RHV9RHT00VUYJ@03GemOPh>3Ph>300:VYZH00i6ATGAdM7AdM002RXZ:00>Q
XJ63Ph>3Ph<01?ooo`030000oooooooo03;oool010000?ooooooooooo`9iNGT00h20P7]kNg]kN`02
Ogmo00>5QHF3Ph>3Ph<00WUiN@03IFEUCTi>CTi>008o?cl00jf][B@T92@T9002VYZJ00>g]kMEEEEE
EED00[6a/@03XZ:RL71`L71`00:RXZ800lK6aVm_Kfm_K`02Z:RX00>0P81UIFEUIFD00YbLW003QXJ6
QhN7QhN700:8R8P00hZ:RXN7QhN7Q`02PH610X>3P`03RHV9RXZ:RXZ:00::RXX00hR8R8J6QXJ6QP03
Q8B40XR8R0:CTi<00c0`<492@T92@P02][Jf00>b/[9ADE5ADE400UaLG003ZZZZQHF5QHF500:[Zj/0
0f1PH<_;bl_;b`02<30`00</;2`i>CTi>CT00/?3``03CDe=[:b/[:b/00:>SXh00hZ:RY>CTi>CT`02
U9BD00>=SHf0P820P8000WalO003U9BD>3Ph>3Ph0093@d<00c`l?:VYZJVYZ@02V9RH00>3Ph=nOWin
OWh00YBDU003[jn_?3`l?3`l00:_[jl00jVYZBPX:2PX:002U9BD00><S8b?Shn?Shl00YZJVP03ZJVY
[Jf][Jf]00:LW9`00hF5QGQhN7QhN002QHF500>d];AVIVIVIVH00V=SH`03a/K6C4a<C4a<0098B4P2
Vi^K00>7QhM4A4A4A4@00Vi^KP03Z:RXK6a/K6a/00:[Zj/00gemOEeMGEeMG@02UiNG00>ATI6d];Bd
];@00WEeM@03WIfMQ8B4Q8B400;Fe]H00fMWIh20P820P002O7al00?MgMe6ATI6ATH00S4a<@03[Zj^
ATI6ATI6009HF5P00eMGEc4a<C4a<@02Rh^;00>QXJ71`L71`L400[Zj^P03/K6aEEEEEEEE00Coool0
0`000?ooooooo`0@oooo000Koooo0`0000;oool00`000?ooooooo`02oooo00<0003oooooool00_oo
o`:1PH400hZ:RYFEUIFEU@02T92@00>:RXZ?Shn?Shl00X^;R`03KFe]E5ADE5AD009PH6000gmoOiNG
UiNGU`02YjNW00>VYZJNWYjNWYh00ZBTY003UYJFCTi>CTi>008_;bl00ibLW?ooooooo`02^KVi00=;
Bd]>CTi>CTh00X:2PP03UYJFTi>CTi>C009nOWh00fa/K7]kNg]kN`02TY:B0Xn?S`03PH61O7alO7al
009jNWX00gUiNGYjNWYjNP02NWYj00=nOWj>SXj>SXh00YNGU`03QHF5L71`L71`009bLW800galO7]k
Ng]kN`02OGem00>@T92WYjNWYjL00[>c/`03/;2`Vi^KVi^K00:8R8P00h^;Ri>CTi>CT`02S8b<00>8
R8RHV9RHV9P00ZZZZP03[Jf]Xj>SXj>S00:ATI400hN7Qi:BTY:BTP03XZ:R0Xn?S`9^KVh00eADE5]K
Fe]KF`02KFe]00=^KViaLG5aLG400XZ:RP03VYZJPX:2PX:2009[Jf/00gmoOijNWYjNWP02XJ6Q00>D
U9B:RXZ:RXX00WUiN@03F5QHC4a<C4a<009dM7@00inOWiNGUiNGU`02O7al00=dM7AgMgMgMgL00WQh
N003NWYjO7alO7al009kNg/2OGem00=kNg]WIfMWIfL00VUYJ@03Zj^[cLg=cLg=009bLW800aXJ6TU9
BDU9B@02[Jf]00?Ti>CHf=SHf=P00X20P003?ShnOgmoOgmo00;Bd]800k:b/Vi^KVi^KP02IVIV00=m
OGf@T92@T9000Y^KV`03VIVIQXJ6QXJ6009VIVH00eeMGHZ:RXZ:RP02[Jf]00>1PH5>CTi>CTh00V9R
HP><S8`4oooo00<0003oooooool09oooo`<00002oooo00<0003oooooool00oooo`040000oooooooo
oooo0V5QH@03GemOG5aLG5aL009UIFD00fm_Kfa/K6a/K002JFUY0g=cL`9GEeL00jZZZY:BTY:BTP02
RXZ:00>CTi>TY:BTY:@00Rl_;`03^[ZjP820P82000:MWId00dA4A6][Jf][J`02XJ6Q00=iNGUZJVYZ
JVX00Z^[Z`03SHf=QHF5QHF500:?Shl00i^KVhn?Shn?S`02O7al0WinOP03R8R8Rh^;Rh^;00::RXX0
0hR8R8F5QHF5Q@02QHF500>7QhN5QHF5QHD00Xj>SP03[Zj^E5ADE5AD00;EeMD00eMGEeQHF5QHF002
cLg=00<n?SjOWinOWil00QDE5@03SHf=W9bLW9bL00:][Jd00c<c<jNWYjNWY`02[Jf]00>_[jlU9BDU
9BD00XZ:RP03OGemNGUiNGUi009mOGd00h61PGemOGemO@02NWYj00>6QXJJVYZJVYX00[6a/@03^k^k
ZJVYZJVY00:BTY800i2@T9BDU9BDU002R8R800>6QXJUYJFUYJD00TQ8B003^KViXJ6QXJ6Q00:JVYX0
0i^KViRHV9RHV002Vi^K00<e=CFe]KFe]KD00Y>CT`03MGEeQXJ6QXJ600:ZZZX00d=3@l;2`/;2`P02
AdM700>i^KTe=CDe=CD00ZZZZP:XZ:P00jj^[TY:BTY:BP02aLG500>?ShmaLG5aLG400T10@003R8R8
Hf=SHf=S00:>SXh00fQXJ7YjNWYjNP02EEEE00>GUiM/K6a/K6`00Rh^;P03`L71NWYjNWYj009hN7P0
0e]KFkfm_Kfm_@02[Jf]00>XZ:Rc/k>c/k<00/W9b@03EEEEZJVYZJVY00:?Shl00cdm?Fm_Kfm_K`02
IVIV00=;Bd_;bl_;bl/01?ooo`030000oooooooo013oool001coool01P000?ooooooo`000?ooo`00
00?oool00`000?ooooooo`02oooo0X^;R`03VYZJ[:b/[:b/00:XZ:P00j2PX:NWYjNWY`02Y:BT00=o
OgmSHf=SHf<00WYjNP03VYZJTi>CTi>C00:0P8000gemOHR8R8R8R002YJFU00>XZ:QSHf=SHf<00SHf
=P03Ph>3dm?Cdm?C00:UYJD00dm?CcHf=SHf=P02DU9B00>BTY:l_;bl_;`00Y6AT@03E5ADFe]KFe]K
009mOGd2QXJ600>5QHF=SHf=SHd00Xn?S`03Ph>3MWIfMWIf009^KVh00gAdM8b<S8b<S002WIfM00>>
SXi_Kfm_Kfl00eADE0:3Ph<2ZJVY00><S8aUIFEUIFD00WIfMP03VIVIY:BTY:BT00:FUYH00gAdM65Q
HF5QH@02Q8B400>ZZZZEUIFEUID00WAdM003OGemTi>CTi>C00:BTY800hJ6QWMgMgMgM`02M7Ad00>;
Rh^OWinOWil00Y2@T003MgMgNWYjNWYj00:5QHD00gmoOh>3Ph>3P`02[Jf]00>l_;abLW9bLW800Rh^
;P03EUIFWIfMWIfM00:RXZ800hV9RHB4Q8B4Q002Ogmo00=[Jf]TI6ATI6@00WmoO`03VYZJTI6ATI6A
009mOGd00h61PHn?Shn?S`02Ti>C00>JVYZc/k>c/k<00[:b/P9cLg<00chn?UYJFUYJFP02UYJF00>c
/k>ZZZZZZZX00WUiN@03EeMGNWYjNWYj00:][Jd00k2`/9BDU9BDU002LW9b00=ZJVZIVIVIVIT00/;2
`P03XJ6QKfm_Kfm_009bLW800hR8R8J6QXJ6QP02O7al0gemO@9^KVh00fe]KIRHV9RHV002[jn_00=c
Lg<g=cLg=cL00UQHF003Ti>CV9RHV9RH00Coool00`000?ooooooo`0Xoooo00H0003oooooool0003o
ool00004oooo00@0003oooooooooool2d=3@00??clo:b/[:b/X00]OGe`03hn?SI6ATI6AT00;IfMT0
0nOWinSXj>SXj002`<3000>GUiNIVIVIVIT00S@d=003^[Zj_;bl_;bl008d=3@00k6a/GEeMGEeM@02
WIfM00=OGenEUIFEUID00[Fe]@03NWYjQ8B4Q8B4009QHF400iZJVVe]KFe]K@02RHV900<l?3b/[:b/
[:`00Xf=S@:5QHD00hJ6QX20P820P002OGem00>1PH66QXJ6QXH00XZ:RP03RHV9PX:2PX:200:7QhL0
0jRXZ5UIFEUIF@02lO7a00=jNWYBDU9BDU800ZRXZ003^k^kemOGemOG009;Bd/00j>SXiRHV9RHV002
XZ:R00>m_Kg=cLg=cLd00SLg=`03T92@WinOWinO00:e]KD00j>SXhN7QhN7Q`02OWin00>4Q8BCTi>C
Ti<00YjNWP03U9BDRHV9RHV900:EUID00bXZ:YZJVYZJVP024Q8B00>=SHf;Rh^;Rh/00Va/K003IVIV
[Jf][Jf]009fMWH00eiNGZ6QXJ6QX@02820P00>SXj<R8R8R8R800YBDU003WIfM9bLW9bLW00:;Rh/0
0gYjNXZ:RXZ:RP02YJFU00<d=3BZZZZZZZX00ZVYZ@03X:2PQhN7QhN700:4Q8@2]KFe00=VIVI?Cdm?
Cdl00YVIV@03PX:2S8b<S8b<00:g]kL00mKFe[^k^k^k^`03U9BD0[2`/09JFUX00nCTi4a<C4a<C002
ZJVY00?5aLEbLW9bLW800V][J`03bl_;BDU9BDU900;1`L400chn?SLg=cLg=`02^k^k00>m_KfMWIfM
WId00Xj>SP03`/;2OGemOGem009VIVH00kJf]T92@T92@P04oooo00<0003oooooool04?ooo`006_oo
o`@000001?ooo`000?ooo`0000?oool300000_ooo`:;Rh/00iZJVZb/[:b/[002Z:RX00>PX:2WYjNW
YjL00ZBTY003OgmoHf=SHf=S009jNWX00iZJVY>CTi>CT`02P82000=mOGf8R8R8R8P00ZFUY@03Z:RX
Hf=SHf=S008f=SH00h>3Pm?Cdm?Cd`02YJFU00=?Cdlf=SHf=SH00U9BDP03TY:B_;bl_;bl00:ATI40
0eADE5]KFe]KF`02OGem0XJ6QP03QHF5SHf=SHf=00:?Shl00h>3PgIfMWIfMP02KVi^00=dM7B<S8b<
S8`00YfMW@03SXj>Kfm_Kfm_00=DE5@2Ph>30ZVYZ@03S8b<IFEUIFEU009fMWH00iVIVJBTY:BTY002
UYJF00=dM7AQHF5QHF400XB4Q003ZZZZUIFEUIFE009dM7@00gemOI>CTi>CT`02TY:B00>6QXIgMgMg
MgL00WAdM003Rh^;WinOWinO00:@T9000gMgMgYjNWYjNP02QHF500=oOgn3Ph>3Ph<00Zf][@03_;bl
LW9bLW9b008^;Rh00eIFEYfMWIfMW@02XZ:R00>9RHV4Q8B4Q8@00WmoO`03Jf][I6ATI6AT009oOgl0
0iZJVY6ATI6AT@02OGem00>1PH6?Shn?Shl00Y>CT`03VYZJ/k>c/k>c00:b/[82Lg=c00<n?SiJFUYJ
FUX00YJFUP03/k>cZZZZZZZZ009iNGT00eMGEgYjNWYjNP02[Jf]00>`/;2DU9BDU9@00W9bLP03JVYZ
VIVIVIVI00;2`/800j6QXFm_Kfm_K`02LW9b00>8R8R6QXJ6QXH00WalO0=mOGd2KVi^00=]KFfHV9RH
V9P00Zn_[`03Lg=c=cLg=cLg009HF5P00i>CTiRHV9RHV003oooo0P0002Soool4000000Coool0003o
ool00004oooo0P0000;oool2d=3@00??clo:b/[:b/X00]OGe`03hn?SI6ATI6AT00;IfMT00nOWinSX
j>SXj002`<3000>GUiNIVIVIVIT00S@d=003^[Zj_;bl_;bl008d=3@00k6a/GEeMGEeM@02WIfM00=O
GenEUIFEUID00[Fe]@03NWYjQ8B4Q8B4009QHF400iZJVVe]KFe]K@02RHV900<l?3b/[:b/[:`00Xf=
S@:5QHD00hJ6QX20P820P002OGem00>1PH66QXJ6QXH00XZ:RP03RHV9PX:2PX:200:7QhL00jRXZ5UI
FEUIF@02lO7a00=jNWYBDU9BDU800ZRXZ003^k^kemOGemOG009;Bd/00j>SXiRHV9RHV002XZ:R00>m
_Kg=cLg=cLd00SLg=`03T92@WinOWinO00:e]KD00j>SXhN7QhN7Q`02OWin00>4Q8BCTi>CTi<00YjN
WP03U9BDRHV9RHV900:EUID00bXZ:YZJVYZJVP024Q8B00>=SHf;Rh^;Rh/00Va/K003IVIV[Jf][Jf]
009fMWH00eiNGZ6QXJ6QX@02820P00>SXj<R8R8R8R800YBDU003WIfM9bLW9bLW00:;Rh/00gYjNXZ:
RXZ:RP02YJFU00<d=3BZZZZZZZX00ZVYZ@03X:2PQhN7QhN700:4Q8@2]KFe00=VIVI?Cdm?Cdl00YVI
V@03PX:2S8b<S8b<00:g]kL00mKFe[^k^k^k^`03U9BD0[2`/09JFUX00nCTi4a<C4a<C002ZJVY00?5
aLEbLW9bLW800V][J`03bl_;BDU9BDU900;1`L400chn?SLg=cLg=`02^k^k00>m_KfMWIfMWId00Xj>
SP03`/;2OGemOGem009VIVH00kJf]T92@T92@P03oooo0P0001;oool001[oool00`000?ooo`000002
oooo00<0003oool000000oooo`030000oooooooo00;oool2OGem00>;Rh^SXj>SXj<00ZBTY003WinO
Z:RXZ:RX00:XZ:P00hR8R7AdM7AdM002VIVI00>f][J;Rh^;Rh/00U1@D003@T92GemOGemO00:NWYh0
0l30`8>3Ph>3P`02@D5100=SHf>KVi^KVi/00YFEU@03JVYZ>3Ph>3Ph008b<S800hZ:R]GEeMGEe@02
XZ:R00=>CTi;Bd];Bd/00W1`L0:2PX800hf=SIVIVIVIV@02V9RH00>9RHUfMWIfMWH00VMWI`03JFUY
PX:2PX:200:JVYX00inOWhJ6QXJ6QP02BTY:00<`<31nOWinOWh00/G5a@03SHf=>CTi>CTi008l?3`0
0fUYJHj>SXj>SP02U9BD00=OGelj>SXj>SX00WMgM`03]kNgS8b<S8b<0097AdL00dE5AFEUIFEUI@02
OGem00>2PX9YJFUYJFT00UIFEP03MWIfWinOWinO00:RXZ800i>CTiFEUIFEU@02WIfM00>IVIVNWYjN
WYh00/?3``03`/;2GEeMGEeM00861PH00cDe=Hf=SHf=S@02W9bL00>9RHV;Rh^;Rh/00Xj>SP03PX:2
NWYjNWYj00:2PX800hj>SY6ATI6AT@02SHf=00>4Q8B5QHF5QHD00YZJVP03^KVifm_Kfm_K00;@d=02
KVi^00<P821HF5QHF5P00Zj^[P03Zj^[QXJ6QXJ600:4Q8@00i>CTjBTY:BTY002WinO00=WIfLk>c/k
>c/00UeMG@03UIFEXJ6QXJ6Q00:ATI400gmoOgIfMWIfMP02P82000>9RHUhN7QhN7P00V=SH`03Jf][
Ng]kNg]k009gMgL00gUiNIbLW9bLW002ZZZZ00=]KFdi>CTi>CT00VMWI`03YZJVW9bLW9bL00Coool0
0`000?ooooooo`0Voooo00<0003oool000000_ooo`030000oooo000000Coool010000?oooooooooo
o`9JFUX00f1PH5]KFe]KF`02IfMW00=aLG5YJFUYJFT00V5QH@03Jf][IVIVIVIV008c<c<00hN7QjNW
YjNWY`02IFEU00=mOGe`L71`L7000TA4A003YZJVHV9RHV9R00:IVIT00gmoOe5ADE5AD@02cLg=00=`
L72?Shn?Shl00XN7Q`03[:b/HV9RHV9R00:1PH400kno_d51@D51@@02VYZJ0X^;R`03QHF5OGemOGem
009lO7`00h61PHJ6QXJ6QP02RXZ:00>9RHV2PX:2PX800X>3P`03UYJF@T92@T92009lO7`00i:BTTm?
Cdm?C`02Rh^;00>g]kN1PH61PH400WinOP03dM7A/;2`/;2`008_;bl00m3@d79bLW9bLP02][Jf00=o
OgnOWinOWil00UUIF@03De=CZj^[Zj^[00:BTY800h^;Rj:RXZ:RXP02?Cdm00>SXj>6QXJ6QXH00XR8
R003UIFEU9BDU9BD00><S8`2Q8B40f=SH`:k^k/2Shn?00=_KfnSXj>SXj<00YFEU@03WYjNU9BDU9BD
00::RXX00hj>SY:BTY:BTP02Rh^;00>4Q8B7QhN7QhL00YBDU003YJFU[:b/[:b/00:QXJ400hZ:RVm_
Kfm_K`02MGEe0[jn_P03O7al`L71`L71009hN7P00gmoOjNWYjNWY`02];Bd00<g=cL/;2`/;2`00ZVY
Z@03Fe]KOgmoOgmo00;Ng]h00k>c/cDe=CDe=@02ATI600?Bd]9SHf=SHf<00UaLG003b/[:EeMGEeMG
009MGEd00d];Bjn_[jn_[`02[jn_00<f=SJFUYJFUYH00Xf=S@03ADE5j>SXj>SX009:BTX00iFEUJZZ
ZZZZZP04oooo00<0003oooooool04?ooo`006oooo`800002oooo00<0003oool000000oooo`030000
oooooooo00;oool2OGem00>;Rh^SXj>SXj<00ZBTY003WinOZ:RXZ:RX00:XZ:P00hR8R7AdM7AdM002
VIVI00>f][J;Rh^;Rh/00U1@D003@T92GemOGemO00:NWYh00l30`8>3Ph>3P`02@D5100=SHf>KVi^K
Vi/00YFEU@03JVYZ>3Ph>3Ph008b<S800hZ:R]GEeMGEe@02XZ:R00=>CTi;Bd];Bd/00W1`L0:2PX80
0hf=SIVIVIVIV@02V9RH00>9RHUfMWIfMWH00VMWI`03JFUYPX:2PX:200:JVYX00inOWhJ6QXJ6QP02
BTY:00<`<31nOWinOWh00/G5a@03SHf=>CTi>CTi008l?3`00fUYJHj>SXj>SP02U9BD00=OGelj>SXj
>SX00WMgM`03]kNgS8b<S8b<0097AdL00dE5AFEUIFEUI@02OGem00>2PX9YJFUYJFT00UIFEP03MWIf
WinOWinO00:RXZ800i>CTiFEUIFEU@02WIfM00>IVIVNWYjNWYh00/?3``03`/;2GEeMGEeM00861PH0
0cDe=Hf=SHf=S@02W9bL00>9RHV;Rh^;Rh/00Xj>SP03PX:2NWYjNWYj00:2PX800hj>SY6ATI6AT@02
SHf=00>4Q8B5QHF5QHD00YZJVP03^KVifm_Kfm_K00;@d=02KVi^00<P821HF5QHF5P00Zj^[P03Zj^[
QXJ6QXJ600:4Q8@00i>CTjBTY:BTY002WinO00=WIfLk>c/k>c/00UeMG@03UIFEXJ6QXJ6Q00:ATI40
0gmoOgIfMWIfMP02P82000>9RHUhN7QhN7P00V=SH`03Jf][Ng]kNg]k009gMgL00gUiNIbLW9bLW002
ZZZZ00=]KFdi>CTi>CT00VMWI`03YZJVW9bLW9bL00Coool00`000?ooooooo`0Woooo0P0000;oool0
0`000?ooo`000004oooo00@0003oooooooooool2FUYJ00=PH61KFe]KFe/00VMWI`03LG5aJFUYJFUY
009QHF400f][JfIVIVIVIP02<c<c00>7QhNWYjNWYjL00VEUI@03OGemL71`L71`0094A4@00jJVYV9R
HV9RHP02VIVI00=oOgmADE5ADE400/g=c@03L71`Shn?Shn?00:7QhL00jb/[69RHV9RHP02PH6100>o
_km1@D51@D400YZJVP:;Rh/00hF5QGemOGemO@02O7al00>1PH66QXJ6QXH00XZ:RP03RHV9PX:2PX:2
00:3Ph<00iJFUT92@T92@P02O7al00>BTY9?Cdm?Cdl00X^;R`03]kNgPH61PH61009nOWh00m7AdK2`
/;2`/002;bl_00?@d=1bLW9bLW800[Jf]P03OgmoWinOWinO009IFET00e=CDj^[Zj^[Z`02TY:B00>;
Rh^RXZ:RXZ800Sdm?@03Xj>SQXJ6QXJ600:8R8P00iFEUIBDU9BDU003S8b<0XB4Q0=SHf<2^k^k0Xn?
S`03Kfm_Xj>SXj>S00:EUID00ijNWYBDU9BDU002RXZ:00>>SXjBTY:BTY800X^;R`03Q8B4QhN7QhN7
00:DU9@00jFUYJb/[:b/[002XJ6Q00>:RXY_Kfm_Kfl00WEeM@:n_[h00galO<71`L71`@02N7Qh00=o
OgnWYjNWYjL00[Bd]003=cLg;2`/;2`/00:YZJT00e]KFgmoOgmoO`02g]kN00>c/k<e=CDe=CD00TI6
AP03d];BHf=SHf=S009LG5`00l[:bUMGEeMGE`02GEeM00=;Bd^_[jn_[jl00Zn_[`03=SHfUYJFUYJF
00:=SHd00dE5ANSXj>SXj002BTY:00>EUIFZZZZZZZX01?ooo`030000oooooooo013oool001coool0
1@000?ooooooooooo`000004oooo00<0003oooooool00_ooo`9MGEd00f=SHh20P820P002R8R800>9
RHVHV9RHV9P00YJFUP03IFEUBTY:BTY:00:6QXH00kfm_Hj>SXj>SP02ATI600<l?3aPH61PH6000YFE
U@03/[:bSXj>SXj>009MGEd00f9RHXF5QHF5Q@02Y:BT00>VYZIdM7AdM7@00Tm?C`03OGem]KFe]KFe
00:RXZ800gQhN7UiNGUiN@02S8b<0iRHV0:7QhL2M7Ad00=iNGV0P820P8000W5aL@03IVIVL71`L71`
00:=SHd00k^k^l;2`/;2`P02Jf][00<R8R9JFUYJFUX00ZRXZ003SXj>G5aLG5aL009^KVh00hZ:RWIf
MWIfMP02EeMG00=ADE5RHV9RHV800XB4Q003W9bLT92@T92@009^KVh00d];Bd51@D51@@02HV9R00>:
RXZ@T92@T9000XJ6QP03RXZ:SHf=SHf=009nOWh00gEeMHZ:RXZ:RP02XZ:R00>KVi^?Shn?Shl00Y^K
V`03V9RHH61PH61P008`<3000dA4A7EeMGEeM@02Shn?00>IVIVQXJ6QXJ400YZJVP03O7alJFUYJFUY
009iNGT00i:BTYNGUiNGU`02Q8B400=JFUY;Bd];Bd/00X:2PP03`l?3cLg=cLg=00:XZ:P2Jf][00=7
AdM/K6a/K6`00Z2PX003W9bLPH61PH61009eMGD00gIfMWmoOgmoO`02P82000=SHf==CDe=CDd00VUY
J@03S8b<QXJ6QXJ6009eMGD00g]kNhJ6QXJ6QP02PH6100=dM7AUIFEUIFD00V1PH003M7AdQXJ6QXJ6
009gMgL00fUYJHR8R8R8R002X:2P00=hN7QFEUIFEUH00X:2PP03/K6aShn?Shn?00Coool00`000?oo
ooooo`0Xoooo00D0003oooooooooool000001Oooo`040000oooooooooooo0V][J`03OGemNGUiNGUi
00:0P8000hF5QGUiNGUiN@02Lg=c00>:RXZ<S8b<S8`00TQ8B003R8R8[jn_[jn_009jNWX00i2@T?Sh
n?Shn002F5QH00>j^[[Fe]KFe]H00XB4Q003PX:2JFUYJFUY00;:b/X00d];BfYZJVYZJP02Ng]k00?0
`<24Q8B4Q8@00XR8R003X:2PVIVIVIVI00:6QXH2OWin00>2PX:DU9BDU9@00Z:RXP03U9BDP820P820
00:0P8000hN7QhZ:RXZ:RP02QXJ600=hN7R4Q8B4Q8@00]?Cd`03UIFEHf=SHf=S00:JVYX00cLg=f=S
Hf=SH`02EeMG00=1@D5>CTi>CTh00V=SH`03HF5QCDe=CDe=008/;2`00hf=SI:BTY:BTP02ZZZZ00=9
BDW8b<S8b<P00S<c<`03Rh^;QhN7QhN700>@T902Ti>C0Rh^;P03^;Rh[Zj^[Zj^00:NWYh00j2PX:>S
Xj>SX`02TI6A00>=SHfh^;Rh^;P00VMWI`03F5QHZZZZZZZZ00:DU9@00hZ:RX61PH61P@02Ph>300>H
V9RTY:BTY:@00YBDU0>0P802UYJF00=7AdMLG5aLG5`00STi>@03QHF5PH61PH6100:NWYh2Bd];00=I
FEVVYZJVYZH00WIfMP03PH61;bl_;bl_009<C4`00m?CdeIFEUIFEP02bl_;00=RHV9]KFe]KFd00U5A
D@03<c<c/K6a/K6a00;3`l<00dY:B/?3`l?3``02EEEE00=RHV;Rh^;Rh^800]_Kf`03_KfmY:BTY:BT
008d=3@00kZj^RXZ:RXZ:P02T92@00>/[:a9BDU9BDT00Y^KV`03NWYjYZJVYZJV00Coool00`000?oo
ooooo`0@oooo000Uoooo00<0003oooooool00_ooo`92@T800dE5AFATI6ATI002LW9b00=jNWZ<S8b<
S8`00XB4Q003A4A4820P820P009YJFT00kRh^9bLW9bLW002H61P00=JFUYeMGEeMGD00Xj>SP03VYZJ
Rh^;Rh^;009dM7@00fe]KH:2PX:2PP02][Jf00?De=BVYZJVYZH00V][J`03KFe]SHf=SHf=00:MWId0
0j:RXYnOWinOW`02VYZJ0Z2PX003W9bLLg=cLg=c009DE5@00f][Jh^;Rh^;R`02PH6100=[Jf]VIVIV
IVH00WmoO`03a<C4hn?Shn?S00:<S8`00bd];D51@D51@@02QHF500>IVIVLW9bLW9`00[Fe]@03/;2`
IFEUIFEU008Y:BT00eIFEY^KVi^KV`02UiNG00>0P82KVi^KVi/00ZRXZ003KFe]>CTi>CTi009IFET0
0iVIVKJf][Jf]P02/k>c00>OWimmOGemOGd00UMGE`03C4a<Kfm_Kfm_00:DU9@00hf=SGEeMGEeM@02
L71`00=dM7A`L71`L7000fe]K@9fMWH2RHV900>MWIfYZJVYZJT00YfMW@03Kfm_Cdm?Cdm?009]KFd0
0iRHV9jNWYjNWP02OWin00<n?ShR8R8R8R800VYZJP03^;RhX:2PX:2P009WIfL2JFUY00>2PX:3Ph>3
Ph<00X61P@>>SXh2K6a/00=<C4aADE5ADE400V][J`03P820RXZ:RXZ:00:5QHD00gMgMfMWIfMWI`02
IfMW00>2PX:FUYJFUYH00X20P003HV9RHF5QHF5Q009eMGD00i2@T9RHV9RHV002MGEe00=EEEE_Kfm_
Kfl00YBDU003R8R8NGUiNGUi00:JVYX00jj^[WalO7alO004oooo00<0003oooooool0<_ooo`040000
oooooooooooo0WYjNP03U9BDTY:BTY:B00>FUYH2QhN70XB4Q003Z:RX/[:b/[:b009SHf<00i6ATJ^[
Zj^[Z`02LG5a00>7QhMmOGemOGd00V][J`03G5aLHF5QHF5Q009_Kfl00gIfMVYZJVYZJP02_;bl00>R
XZ96ATI6ATH00VYZJP03d];B<30`<30`00:@T9000h>3PginOWinOP02P8200WemO@03QHF5Zj^[Zj^[
009:BTX00jJVYWemOGemO@02N7Qh00>5QHFATI6ATI400Xf=S@03JFUYGemOGemO00:][Jd00h:2PVm_
Kfm_K`02[jn_00>RXZ:TY:BTY:@00YBDU003VIVIe=CDe=CD00:4Q8@00m;BdY:BTY:BTP02T92@00>N
WYj4Q8B4Q8@00WMgM`03YjNWFUYJFUYJ00:k^k/00hN7Qfi^KVi^KP02Kfm_00=oOgnOWinOWil00Tm?
C`03IVIVclo?clo?008o?cl00d=3@lW9bLW9b@02`/;200<l?3b`/;2`/;000Zj^[P03<C4aXZ:RXZ:R
00:CTi<00hF5QGemOGemO@02QXJ600>YZJU4A4A4A4@00Z2PX003Ng]kN7QhN7Qh00:IVIT00e]KFoKf
m_KfmP02C4a<00>@T92/[:b/[:`00UiNGP9?Cdl00j2PX8b<S8b<S002QHF500>3Ph>HV9RHV9P00/_;
b`=mOGd2g=cL00=6ATJ][Jf][Jd00ZVYZ@03[jn_@410@41000:l_;`00jf][JRXZ:RXZ002C4a<00=Z
JVYXJ6QXJ6P00Te=C@03:RXZTi>CTi>C00:/[:`00lS8b3/k>c/k>`02UIFE00>GUiNJVYZJVYX00WYj
NP03KVi^ZZZZZZZZ00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`92@T80
0dE5AFATI6ATI002LW9b00=jNWZ<S8b<S8`00XB4Q003A4A4820P820P009YJFT00kRh^9bLW9bLW002
H61P00=JFUYeMGEeMGD00Xj>SP03VYZJRh^;Rh^;009dM7@00fe]KH:2PX:2PP02][Jf00?De=BVYZJV
YZH00V][J`03KFe]SHf=SHf=00:MWId00j:RXYnOWinOW`02VYZJ0Z2PX003W9bLLg=cLg=c009DE5@0
0f][Jh^;Rh^;R`02PH6100=[Jf]VIVIVIVH00WmoO`03a<C4hn?Shn?S00:<S8`00bd];D51@D51@@02
QHF500>IVIVLW9bLW9`00[Fe]@03/;2`IFEUIFEU008Y:BT00eIFEY^KVi^KV`02UiNG00>0P82KVi^K
Vi/00ZRXZ003KFe]>CTi>CTi009IFET00iVIVKJf][Jf]P02/k>c00>OWimmOGemOGd00UMGE`03C4a<
Kfm_Kfm_00:DU9@00hf=SGEeMGEeM@02L71`00=dM7A`L71`L7000fe]K@9fMWH2RHV900>MWIfYZJVY
ZJT00YfMW@03Kfm_Cdm?Cdm?009]KFd00iRHV9jNWYjNWP02OWin00<n?ShR8R8R8R800VYZJP03^;Rh
X:2PX:2P009WIfL2JFUY00>2PX:3Ph>3Ph<00X61P@>>SXh2K6a/00=<C4aADE5ADE400V][J`03P820
RXZ:RXZ:00:5QHD00gMgMfMWIfMWI`02IfMW00>2PX:FUYJFUYH00X20P003HV9RHF5QHF5Q009eMGD0
0i2@T9RHV9RHV002MGEe00=EEEE_Kfm_Kfl00YBDU003R8R8NGUiNGUi00:JVYX00jj^[WalO7alO004
oooo00<0003oooooool0<_ooo`040000oooooooooooo0WYjNP03U9BDTY:BTY:B00>FUYH2QhN70XB4
Q003Z:RX/[:b/[:b009SHf<00i6ATJ^[Zj^[Z`02LG5a00>7QhMmOGemOGd00V][J`03G5aLHF5QHF5Q
009_Kfl00gIfMVYZJVYZJP02_;bl00>RXZ96ATI6ATH00VYZJP03d];B<30`<30`00:@T9000h>3Pgin
OWinOP02P8200WemO@03QHF5Zj^[Zj^[009:BTX00jJVYWemOGemO@02N7Qh00>5QHFATI6ATI400Xf=
S@03JFUYGemOGemO00:][Jd00h:2PVm_Kfm_K`02[jn_00>RXZ:TY:BTY:@00YBDU003VIVIe=CDe=CD
00:4Q8@00m;BdY:BTY:BTP02T92@00>NWYj4Q8B4Q8@00WMgM`03YjNWFUYJFUYJ00:k^k/00hN7Qfi^
KVi^KP02Kfm_00=oOgnOWinOWil00Tm?C`03IVIVclo?clo?008o?cl00d=3@lW9bLW9b@02`/;200<l
?3b`/;2`/;000Zj^[P03<C4aXZ:RXZ:R00:CTi<00hF5QGemOGemO@02QXJ600>YZJU4A4A4A4@00Z2P
X003Ng]kN7QhN7Qh00:IVIT00e]KFoKfm_KfmP02C4a<00>@T92/[:b/[:`00UiNGP9?Cdl00j2PX8b<
S8b<S002QHF500>3Ph>HV9RHV9P00/_;b`=mOGd2g=cL00=6ATJ][Jf][Jd00ZVYZ@03[jn_@410@410
00:l_;`00jf][JRXZ:RXZ002C4a<00=ZJVYXJ6QXJ6P00Te=C@03:RXZTi>CTi>C00:/[:`00lS8b3/k
>c/k>`02UIFE00>GUiNJVYZJVYX00WYjNP03KVi^ZZZZZZZZ00Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`9?Cdl00eIFEWEeMGEeM@02R8R800>DU9BQXJ6QXJ400YFEU@03Fe]K
>3Ph>3Ph009_Kfl00kFe]KJf][Jf]P02UYJF00>4Q8B1PH61PH400Xf=S@03UiNGRXZ:RXZ:009eMGD0
0fQXJ7AdM7AdM002ZJVY00?4a<B6QXJ6QXH00TE5A@03GemOUiNGUiNG00:TY:@00iBDU7QhN7QhN002
IFEU0WMgM`03SHf=O7alO7al009XJ6P00gUiNHn?Shn?S`02RHV900=jNWYaLG5aLG400WUiN@03WYjN
/;2`/;2`00:0P8000di>CV9RHV9RHP02UYJF00>e]KFk^k^k^k/00ZVYZ@03QXJ6GemOGemO009ADE40
0g9bLY^KVi^KV`02VIVI00>>SXjWYjNWYjL00[>c/`03PH61EUIFEUIF009gMgL00jRXZ::RXZ:RXP02
R8R800>5QHF1PH61PH400VEUI@03DU9BHf=SHf=S009lO7`00gYjNWAdM7AdM002QHF500>ATI5mOGem
OGd00W1`L003T92@[jn_[jn_00:IVIT00gYjNXF5QHF5Q@02TI6A00=^KVi@D51@D5000VIVIP03SHf=
WYjNWYjN00:CTi<00fIVITY:BTY:BP02MGEe00>NWYieMGEeMGD00TE5A@9VIVH00iNGUhV9RHV9R@02
LW9b00>7QhNMWIfMWId00XN7Q`03JFUYJ6QXJ6QX009jNWX00i6ATJ6QXJ6QX@02WYjN00>:RXYYJFUY
JFT00U]KF`03OGemWinOWinO00:<S8`00g5aLGinOWinOP02WIfM00>c/k>][Jf][Jd00WinOP03EEEE
IfMWIfMW00:>SXh00i>CThf=SHf=S@03VYZJ0W=cL`Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2L71`00>:RXZ=SHf=SHd00Xf=S@03RXZ:OGemOGem009lO7`00iVIVInOWinOW`02GUiN00>E
UIFKVi^KVi/00Tm?C`03Lg=cPh>3Ph>3009hN7P00mkNgV1PH61PH002h>3P00=_KfmYJFUYJFT00[bl
_003YJFUFEUIFEUI00:4Q8@00mgMgJ>SXj>SX`025ADE00>EUIFWYjNWYjL00[>c/`8];Bd00iRHV:RX
Z:RXZ002?Cdm00>RXZ:4Q8B4Q8@00WinOP03QHF5TI6ATI6A00:DU9@00h:2PWinOWinOP02[:b/00=N
GUi>CTi>CTh00YjNWP03QhN7QHF5QHF500:DU9@00jn_[e9BDU9BDP02EeMG00>_[jn9RHV9RHT00XR8
R003T92@O7alO7al009cLg<00inOWda<C4a<C002[Jf]00>6QXJ7QhN7QhL00YRHV003UiNGWIfMWIfM
00:m_Kd3HV9R0]7Ad@=JFUX2ADE500>[Zj/i>CTi>CT00[Jf]P03UIFEN7QhN7Qh00::RXX00jJVYRHV
9RHV9P02UYJF00>^[Zi6ATI6ATH00ZNWY`03Q8B4N7QhN7Qh00:8R8P00kFe]MOGemOGe`02ATI600>W
YjO?clo?cll00WYjNP;9bLT00hf=SHB4Q8B4Q002SXj>00>3Ph>4Q8B4Q8@00Z^[Z`03FEUIGUiNGUiN
0098B4P00jFUYHf=SHf=S@02QhN700>BTY:[Zj^[Zj/00Shn?P03:BTYTI6ATI6A00:/[:`00lW9bKbl
_;bl_002Vi^K00=oOgmkNg]kNg/00Z6QX@03CDe=^k^k^k^k00:JVYX00hf=SHJ6QXJ6QP02MGEe00=i
NGV][Jf][Jd01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0Tm?C`03EUIF
MGEeMGEe00:8R8P00iBDU:6QXJ6QX@02UIFE00=KFe/h>3Ph>3P00Vm_K`03]KFe][Jf][Jf00:FUYH0
0hB4Q861PH61P@02SHf=00>GUiN:RXZ:RXX00WEeM@03J6QXM7AdM7Ad00:YZJT00lC4a8J6QXJ6QP02
ADE500=OGenGUiNGUiL00ZBTY003U9BDN7QhN7Qh009UIFD2MgMg00>=SHelO7alO7`00VQXJ003NGUi
Shn?Shn?00:9RHT00gYjNW5aLG5aL@02NGUi00>NWYj`/;2`/;000X20P003CTi>HV9RHV9R00:FUYH0
0kFe]K^k^k^k^`02ZJVY00>6QXIOGemOGel00U5AD@03LW9bVi^KVi^K00:IVIT00hj>SZNWYjNWY`02
/k>c00>1PH5FEUIFEUH00WMgM`03Z:RXXZ:RXZ:R00:8R8P00hF5QH61PH61P@02IFEU00=BDU9SHf=S
Hf<00WalO003NWYjM7AdM7Ad00:5QHD00i6ATGemOGemO@02L71`00>@T92_[jn_[jl00YVIV@03NWYj
QHF5QHF500:ATI400fi^KU1@D51@D002IVIV00>=SHfNWYjNWYh00Y>CT`03IVIVBTY:BTY:009eMGD0
0ijNWWEeMGEeM@02ADE50VIVIP03UiNGRHV9RHV9009bLW800hN7QifMWIfMW@02QhN700=YJFUXJ6QX
J6P00WYjNP03TI6AXJ6QXJ6Q00:NWYh00hZ:RVUYJFUYJ@02Fe]K00=mOGfOWinOWil00Xb<S003LG5a
OWinOWin00:MWId00k>c/jf][Jf][@02OWin00=EEEEWIfMWIfL00Xj>SP03Ti>CSHf=SHf=00>JVYX2
Lg=c1?ooo`030000oooooooo03;oool010000?ooooooooooo`9`L7000hZ:RXf=SHf=S@02SHf=00>:
RXYmOGemOGd00WalO003VIVIWinOWinO009NGUh00iFEUI^KVi^KV`02Cdm?00=cLg>3Ph>3Ph<00WQh
N003g]kNH61PH61P00;Ph>000fm_KfUYJFUYJ@02_;bl00>UYJEIFEUIFET00XB4Q003gMgMXj>SXj>S
008E5AD00iFEUJNWYjNWY`02/k>c0Rd];@03V9RHZ:RXZ:RX008m?Cd00j:RXXB4Q8B4Q002OWin00>5
QHFATI6ATI400YBDU003PX:2OWinOWin00:/[:`00eiNGTi>CTi>CP02WYjN00>7QhN5QHF5QHD00YBD
U003[jn_DU9BDU9B009GEeL00jn_[hV9RHV9R@02R8R800>@T91lO7alO7`00W=cL`03WinOC4a<C4a<
00:][Jd00hJ6QXN7QhN7Q`02V9RH00>GUiNMWIfMWId00[fm_@=RHV82dM7A0eYJFP95ADD00j^[ZcTi
>CTi>@02][Jf00>EUIEhN7QhN7P00XZ:RP03YZJV9RHV9RHV00:FUYH00jj^[TI6ATI6AP02YjNW00>4
Q8AhN7QhN7P00XR8R003]KFeemOGemOG0096ATH00jNWYlo?clo?c`02NWYj0/W9b@03SHf=Q8B4Q8B4
00:>SXh00h>3PhB4Q8B4Q002Zj^[00=IFEUNGUiNGUh00TQ8B003YJFUSHf=SHf=00:7QhL00i:BTZ^[
Zj^[Z`02?Shn00<Y:BVATI6ATI400Zb/[003bLW9_;bl_;bl00:KVi/00gmoOg]kNg]kN`02XJ6Q00==
CDfk^k^k^k/00YZJVP03SHf=QXJ6QXJ6009eMGD00gUiNJf][Jf][@04oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool2HV9R00=aLG6?Shn?Shl00Z>SX`03[Zj^]kNg]kNg00:YZJT0
0gEeMEEEEEEEE@02NWYj00>b/[;2`/;2`/800[Bd]003VYZJQHF5QHF500:5QHD00hZ:RWmoOgmoO`02
Kfm_00=XJ6QbLW9bLW800YVIV@03XZ:RDE5ADE5A008B4Q800e5ADJb/[:b/[002/;2`00=nOWi9BDU9
BDT00S0`<09?Cdl00h61PI2@T92@T002Rh^;00>=SHf?Shn?Shl00XV9R@03Q8B4Ph>3Ph>300:1PH40
0gUiNFi^KVi^KP02Hf=S00=YJFV:RXZ:RXX00Zj^[P03`<30/k>c/k>c00:4Q8@00eeMGF][Jf][J`02
RXZ:00>>SXj;Rh^;Rh/00YZJVP03YjNWX:2PX:2P00:ATI400hB4Q8>3Ph>3P`02VYZJ00>TY:AkNg]k
Ng/00UEEE@03K6a/Shn?Shn?00:6QXH00f][Jf=SHf=SH`02J6QX00=aLG64Q8B4Q8@00ZVYZ@03][Jf
PX:2PX:2009NGUh00inOWmgMgMgMg@02Xj>S00=EEEERHV9RHV800XJ6QP03MGEeGEeMGEeM009ZJVX0
0hN7QinOWinOW`02Z:RX00>HV9R4Q8B4Q8@00hN7Q`9SHf<2BDU90VMWI`03SHf=Q8B4Q8B4009cLg<0
0hJ6QYnOWinOW`02X:2P00>FUYJATI6ATI400Y2@T003U9BDW9bLW9bL00:VYZH00j6QXG]kNg]kN`02
GemO00=iNGVMWIfMWId00YNGU`03RHV9UYJFUYJF00:/[:`00kRh^:j^[Zj^[P02QhN700=UIFE_Kfm_
Kfl00X^;R`03TY:BT92@T92@00:DU9@00hn?SgEeMGEeM@04oooo00<0003oooooool0<_ooo`040000
oooooooooooo0VATI003Ng]kOgmoOgmo00:0P8000ginOWAdM7AdM002Lg=c00>7QhN8R8R8R8P00U=C
D`03U9BDTI6ATI6A00:e]KD00fYZJX^;Rh^;R`02QhN700=aLG5UIFEUIFD00V1PH003f=SHEeMGEeMG
008j>SX00jj^[WAdM7AdM002XJ6Q00=VIVJ@T92@T9000XR8R003[Jf]G5aLG5aL00;YjNT2EEEE00>U
YJFIVIVIVIT00YbLW003UYJFT92@T92@00:?Shl3T92@0Y>CT`03WIfMZj^[Zj^[0090@4000k^k^jFU
YJFUY@02RXZ:00=kNg^3Ph>3Ph<00ZFUY@03ATI6[Zj^[Zj^00:@T9000hV9RHb<S8b<S002PX:200=m
OGf8R8R8R8P00Y^KV`03Zj^[[jn_[jn_00:OWil00iFEUCPh>3Ph>002b/[:00>b/[:DU9BDU9@00RTY
:@03`l?3e]KFe]KF009SHf<00f5QHLc<c<c<c002<S8b00>LW9bo_kno_kl00U]KF`03V9RHH61PH61P
00:=SHd00eADE<C4a<C4a002Y:BT00<b<S:f][Jf][H00ZBTY003RHV9NGUiNGUi009iNGT00i6ATC<c
<c<c<`02>CTi00>j^[YPH61PH6000W5aL@;5aLD00i>CThV9RHV9R@02SHf=00>1PH5iNGUiNGT00XJ6
QP03VIVIWinOWinO00:JVYX00hn?Sh61PH61P@02Lg=c00=eMGFCTi>CTi<00Zb/[003Vi^KQHF5QHF5
00:ATI400bLW9iFEUIFEU@02OWin00=^KVicLg=cLg<00YJFUP03^;Rh?3`l?3`l00:OWil00i2@T8F5
QHF5Q@02NWYj00>3Ph>^[Zj^[Zh01?ooo`030000oooooooo013oool002Goool200000oooo`9@D500
0f1PH8R8R8R8R003U9BD0Z2PX0:FUYH00eIFERh^;Rh^;P02IVIV00>^[ZjYZJVYZJT00XB4Q003OWin
O7alO7al009XJ6P00eMGEemOGemOG`02M7Ad00>2PX:@T92@T9000Z^[Z`03Xj>SC4a<C4a<008;2`/0
0dA4A9jNWYjNWP02][Jf00>HV9QRHV9RHV800Slo?`9RHV800iNGUi^KVi^KV`02RXZ:00>@T92FUYJF
UYH00XN7Q`03OGemShn?Shn?00:MWId00hZ:RVa/K6a/K002GEeM00=SHf>0P820P8000Y^KV`03V9RH
RXZ:RXZ:00:;Rh/00i2@T8^;Rh^;R`02RHV900>ATI6NWYjNWYh00Zn_[`03ZJVYM7AdM7Ad009=CDd0
0fm_KinOWinOW`02Vi^K00>0P81aLG5aLG400WAdM003RHV9VYZJVYZJ00:>SXh00gEeMFMWIfMWI`02
JFUY00=kNg^CTi>CTi<00ZBTY003XJ6QOgmoOgmo009[Jf/00iBDU;Ng]kNg]`02Rh^;00=HF5Q]KFe]
KFd00Xn?S`03OGemIVIVIVIV009lO7`00inOWjb/[:b/[002YZJV00>CTi>1PH61PH400WinOP03PH61
NGUiNGUi00A`L7000gEeMG]kNg]kN`02PH6100>5QHF9RHV9RHT00Y2@T003UIFETI6ATI6A00:;Rh/0
0hR8R8V9RHV9R@03SXj>0X>3P`9iNGT00h20P8f=SHf=S@02TY:B00>?Shn6QXJ6QXH00WinOP03P820
QHF5QHF500:1PH400gemOH>3Ph>3P`02RXZ:00>8R8R:RXZ:RXX00ZBTY003[:b/OWinOWin00?oool2
0000=?ooo`040000oooooooooooo0WMgM`03S8b<R8R8R8R800:@T9000iFEUHR8R8R8R002Ph>300>O
WinTY:BTY:@00UeMG@03TI6AXZ:RXZ:R009QHF400hB4Q9FEUIFEU@02XJ6Q00>HV9QfMWIfMWH00Ti>
CP03/K6aXj>SXj>S00:>SXh00iNGUfATI6ATI002UiNG00=WIfNEUIFEUID00X:2PP03Vi^KCTi>CTi>
009ZJVX2Bd];00>FUYJ@T92@T9000YbLW0037alOUIFEUIFE00:SXj<00c4a<INGUiNGU`02Q8B400<D
51BUYJFUYJD00[Jf]P03@D51Zj^[Zj^[00:IVIT00b0P89fMWIfMW@02TY:B00>5QHF3Ph>3Ph<00X:2
PP03O7alMWIfMWIf009`L7000h20P;Jf][Jf]P02IfMW00=CDe<_;bl_;bl00Zf][@03AdM7a/K6a/K6
0092@T800b/[:i>CTi>CT`02WYjN00<o?cmDE5ADE5@00U]KF`03c/k>`/;2`/;200:h^;P00k^k^eYJ
FUYJFP02Hf=S00>c/k>>SXj>SXh00Zj^[P03GEeM`l?3`l?300:RXZ800bl_;k6a/K6a/@02UIFE00=e
MGE_Kfm_Kfl00WinOP03VIVI/k>c/k>c00:k^k/00d92@/30`<30`002B4Q80Sdm?@03;2`/Ti>CTi>C
00:5QHD00h20P861PH61P@02PX:200>3Ph>6QXJ6QXH00XN7Q`03QHF5PH61PH6100=lO7`2QhN70Y6A
T@03SHf=QXJ6QXJ600:4Q8@00hR8R8j>SXj>SP02Ti>C00>@T92>SXj>SXh00YNGU`03Y:BT;Bd];Bd]
00:RXZ800ibLW8j>SXj>SP02LW9b00=`L72[Zj^[Zj/00oooo`80000Boooo000Uoooo00<0003ooooo
ool00_ooo`9@D5000f1PH8R8R8R8R003U9BD0Z2PX0:FUYH00eIFERh^;Rh^;P02IVIV00>^[ZjYZJVY
ZJT00XB4Q003OWinO7alO7al009XJ6P00eMGEemOGemOG`02M7Ad00>2PX:@T92@T9000Z^[Z`03Xj>S
C4a<C4a<008;2`/00dA4A9jNWYjNWP02][Jf00>HV9QRHV9RHV800Slo?`9RHV800iNGUi^KVi^KV`02
RXZ:00>@T92FUYJFUYH00XN7Q`03OGemShn?Shn?00:MWId00hZ:RVa/K6a/K002GEeM00=SHf>0P820
P8000Y^KV`03V9RHRXZ:RXZ:00:;Rh/00i2@T8^;Rh^;R`02RHV900>ATI6NWYjNWYh00Zn_[`03ZJVY
M7AdM7Ad009=CDd00fm_KinOWinOW`02Vi^K00>0P81aLG5aLG400WAdM003RHV9VYZJVYZJ00:>SXh0
0gEeMFMWIfMWI`02JFUY00=kNg^CTi>CTi<00ZBTY003XJ6QOgmoOgmo009[Jf/00iBDU;Ng]kNg]`02
Rh^;00=HF5Q]KFe]KFd00Xn?S`03OGemIVIVIVIV009lO7`00inOWjb/[:b/[002YZJV00>CTi>1PH61
PH400WinOP03PH61NGUiNGUi00A`L7000gEeMG]kNg]kN`02PH6100>5QHF9RHV9RHT00Y2@T003UIFE
TI6ATI6A00:;Rh/00hR8R8V9RHV9R@03SXj>0X>3P`9iNGT00h20P8f=SHf=S@02TY:B00>?Shn6QXJ6
QXH00WinOP03P820QHF5QHF500:1PH400gemOH>3Ph>3P`02RXZ:00>8R8R:RXZ:RXX00ZBTY003[:b/
OWinOWin00Coool00`000?ooooooo`0boooo00@0003oooooooooool2MgMg00><S8b8R8R8R8P00Y2@
T003UIFER8R8R8R800:3Ph<00inOWjBTY:BTY002GEeM00>ATI6RXZ:RXZ800V5QH@03Q8B4UIFEUIFE
00:QXJ400iRHV7IfMWIfMP02CTi>00>a/K6SXj>SXj<00Xj>SP03UiNGI6ATI6AT00:GUiL00fMWIiFE
UIFEU@02PX:200>KVi]>CTi>CTh00VYZJP9;Bd/00iJFUY2@T92@T002W9bL00<O7anEUIFEUID00Z>S
X`03<C4aUiNGUiNG00:4Q8@00a@D5:FUYJFUY@02][Jf00=1@D6[Zj^[Zj/00YVIV@03820PWIfMWIfM
00:BTY800hF5QH>3Ph>3P`02PX:200=lO7afMWIfMWH00W1`L003P820][Jf][Jf009WIfL00e=CDbl_
;bl_;`02[Jf]00=7AdO6a/K6a/H00T92@P03:b/[Ti>CTi>C00:NWYh00clo?eADE5ADE002Fe]K00?>
c/k2`/;2`/800[Rh^003^k^kFUYJFUYJ009SHf<00k>c/hj>SXj>SP02[Zj^00=MGEg3`l?3`l<00Z:R
XP03;bl_/K6a/K6a00:EUID00gEeMFm_Kfm_K`02OWin00>IVIVc/k>c/k<00[^k^`03@T92`<30`<30
0098B4P2?Cdm00</;2bCTi>CTi<00XF5Q@03P820PH61PH6100:2PX800h>3PhJ6QXJ6QP02QhN700>5
QHF1PH61PH400galO0:7QhL2TI6A00>=SHf6QXJ6QXH00XB4Q003R8R8SXj>SXj>00:CTi<00i2@T8j>
SXj>SP02UiNG00>TY:@];Bd];Bd00Z:RXP03W9bLSXj>SXj>009bLW800g1`L:^[Zj^[Z`04oooo00<0
003oooooool04?ooo`009Oooo`030000oooooooo00;oool2BTY:00=@D51cLg=cLg<00g]kN`::RXX2
PH6100<k>c/@410@41000UMGE`03Z:RXRXZ:RXZ:009ADE400f5QHGYjNWYjNP02FEUI00<g=cM?Cdm?
Cdl00WmoO`03VYZJZJVYZJVY00:j^[X00j^[ZfATI6ATI002;Bd]00=9BDV:RXZ:RXX00[>c/`03]kNg
TY:BTY:B009_Kfl2PH6100>PX:2EUIFEUID00X20P003RHV9TY:BTY:B009mOGd00fm_Khb<S8b<S002
[:b/00>XZ:R;Rh^;Rh/00VQXJ003EUIFJf][Jf][00:3Ph<00g1`L65QHF5QH@02SXj>00>h^;RLW9bL
W9`00WMgM`03R8R8YZJVYZJV00:XZ:P00hb<S59BDU9BDP02<S8b00=XJ6RSXj>SXj<00XF5Q@03FEUI
MWIfMWIf00:VYZH00jZZZYJFUYJFUP02QXJ600=iNGUcLg=cLg<00WYjNP03SXj>W9bLW9bL00:?Shl0
0gYjNWEeMGEeM@02MgMg00=eMGEdM7AdM7@00WEeM@03OGemSXj>SXj>00:FUYH00h20P71`L71`L002
QhN700>VYZJYZJVYZJT00YJFUP03N7QhIFEUIFEU009`L7000hV9RI^KVi^KV`02VIVI0WemO@03IfMW
MWIfMWIf00:=SHd00hB4Q79bLW9bLP02MWIf0h20P09kNg/00gMgMgAdM7AdM002LG5a00=dM7B4Q8B4
Q8@00Y2@T003QXJ6O7alO7al00:6QXH00hZ:RVa/K6a/K002CDe=00=>CTiTI6ATI6@00WinOP03Shn?
SHf=SHf=00:3Ph<00gYjNX>3Ph>3P`02ZJVY00>j^[Z6QXJ6QXH01?ooo`030000oooooooo03;oool0
10000?ooooooooooo`9mOGd00iBDU92@T92@T002V9RH00>MWIf=SHf=SHd00XR8R003ZZZZ/[:b/[:b
009OGel00hf=SK>c/k>c/`02Ph>300>BTY:=SHf=SHd00Z:RXP03YjNWMWIfMWIf00:`/;000hb<S7al
O7alO002KVi^00=lO7bg]kNg]kL00V][J`03EUIFWYjNWYjN00>0P802XJ6Q0[fm_@:[Zj/00hf=SAPH
61PH6002XZ:R0inOW`8n?Sh00lC4a:JVYZJVYP02P82000=iNGV;Rh^;Rh/00Z^[Z`03BTY:_;bl_;bl
00:/[:`00chn?[Rh^;Rh^002R8R800=KFe]]KFe]KFd00Xb<S003PX:2LG5aLG5a009lO7`00j6QXFIV
IVIVIP02S8b<00=XJ6Re]KFe]KD00UADE003MGEedM7AdM7A00:SXj<00alO7j>SXj>SX`02[Jf]00>h
^;S1`L71`L400/;2`P=2@T82EeMG00=]KFe`L71`L7000^3Ph003GemOF5QHF5QH00;:b/X00dM7Ajn_
[jn_[`02Xj>S00<`<32[Zj^[Zj/00Xj>SP03LG5aLW9bLW9b00:<S8`00k2`/<W9bLW9b@02BTY:00>^
[ZjKVi^KVi/00YFEU@:SXj<00jf][INGUiNGU`02OWin00>1PH6>SXj>SXh00X^;R`03Ph>3PX:2PX:2
00:4Q8@00hJ6QXR8R8R8R003SHf=0X>3P`9kNg/00h>3Ph^;Rh^;R`02PH6100=mOGfFUYJFUYH00[6a
/@03>SXjYjNWYjNW00:IVIT00iFEUBDU9BDU9@02ZZZZ00<b<S:LW9bLW9`00WMgM`03KFe]ZZZZZZZZ
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`9:BTX00e1@D7=cLg=cL`03
Ng]k0XZ:RP:1PH400c/k>a0@410@4002EeMG00>XZ:R:RXZ:RXX00U5AD@03HF5QNWYjNWYj009IFET0
0cLg=dm?Cdm?C`02Ogmo00>JVYZYZJVYZJT00[Zj^P03Zj^[I6ATI6AT008];Bd00dU9BHZ:RXZ:RP02
/k>c00>g]kNBTY:BTY800Vm_K`:1PH400j2PX9FEUIFEU@02P82000>9RHVBTY:BTY800WemO@03Kfm_
S8b<S8b<00:/[:`00jRXZ8^;Rh^;R`02J6QX00=FEUI[Jf][Jf/00X>3P`03L71`HF5QHF5Q00:>SXh0
0kRh^9bLW9bLW002MgMg00>8R8RVYZJVYZH00ZRXZ003S8b<DU9BDU9B008b<S800fQXJ:>SXj>SX`02
QHF500=IFEUfMWIfMWH00ZJVYP03ZZZZUYJFUYJF00:6QXH00gUiNG=cLg=cL`02NWYj00>>SXjLW9bL
W9`00Xn?S`03NWYjMGEeMGEe009gMgL00gEeMGAdM7AdM002MGEe00=mOGf>SXj>SXh00YJFUP03P820
L71`L71`00:7QhL00jJVYZVYZJVYZ@02UYJF00=hN7QUIFEUIFD00W1`L003RHV9Vi^KVi^K00:IVIT2
OGem00=WIfMfMWIfMWH00Xf=S@03Q8B4LW9bLW9b009fMWH3P8200W]kN`03MgMgM7AdM7Ad009aLG40
0gAdM8B4Q8B4Q002T92@00>6QXIlO7alO7`00XJ6QP03RXZ:K6a/K6a/009=CDd00di>CVATI6ATI002
OWin00>?Shn=SHf=SHd00X>3P`03NWYjPh>3Ph>300:YZJT00kZj^XJ6QXJ6QP04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0WemO@03U9BDT92@T92@00:HV9P00ifMWHf=SHf=S@02R8R800>Z
ZZZb/[:b/[800UmOG`03SHf=/k>c/k>c00:3Ph<00i:BTXf=SHf=S@02XZ:R00>WYjMfMWIfMWH00[2`
/003S8b<O7alO7al009^KVh00galO;Ng]kNg]`02Jf][00=FEUJNWYjNWYh00h20P0:QXJ42_Kfm0Z^[
Z`03SHf=61PH61PH00:RXZ83WinO0Shn?P03a<C4YZJVYZJV00:0P8000gUiNH^;Rh^;R`02Zj^[00=:
BTZl_;bl_;`00Zb/[003?Shn^;Rh^;Rh00:8R8P00e]KFfe]KFe]K@02S8b<00>2PX9aLG5aLG400Wal
O003XJ6QIVIVIVIV00:<S8`00fQXJ;Fe]KFe]@02E5AD00=eMGGAdM7AdM400Z>SX`037alOXj>SXj>S
00:][Jd00kRh^<71`L71`@02`/;20d92@P9GEeL00fe]KG1`L71`L002h>3P00=OGemHF5QHF5P00/[:
bP03AdM7[jn_[jn_00:SXj<00c0`<:^[Zj^[Z`02SXj>00=aLG5bLW9bLW800Xb<S003/;2`bLW9bLW9
009:BTX00jj^[Y^KVi^KV`02UIFE0Z>SX`03[Jf]UiNGUiNG009nOWh00h61PHj>SXj>SP02Rh^;00>3
Ph>2PX:2PX800XB4Q003QXJ6R8R8R8R800>=SHd2Ph>30W]kN`03Ph>3Rh^;Rh^;00:1PH400gemOIJF
UYJFUP02/K6a00<j>SZWYjNWYjL00YVIV@03UIFE9BDU9BDU00:ZZZX00c8b<YbLW9bLW002MgMg00=]
KFfZZZZZZZX01?ooo`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0X>3P`03LG5a
J6QXJ6QX009oOgl00i^KVjFUYJFUY@02Ti>C00=TI6A7AdM7AdL00Vm_K`03WYjNS8b<S8b<009/K6`0
0gmoOiFEUIFEU@02O7al00=PH61^KVi^KVh00X^;R`03UYJFVIVIVIVI00:OWil00iVIVGemOGemO@02
J6QX00=cLg>=SHf=SHd00Z:RXP03ZZZZXZ:RXZ:R00:?Shl2NGUi00=_KfmjNWYjNWX00XR8R003QHF5
MgMgMgMg009ZJVX00fUYJG]kNg]kN`02Ti>C00>RXZ:KVi^KVi/00WMgM`03GEeMMGEeMGEe00:BTY80
0h20P65QHF5QH@02Fe]K00=XJ6QhN7QhN7P00XF5Q@03RHV9Ng]kNg]k009MGEd00de=CFATI6ATI002
RHV900>LW9bCTi>CTi<00Va/K003De=CMWIfMWIf00:RXZ800iZJVWinOWinOP02NGUi00>1PH66QXJ6
QXH00Xj>SP03VYZJW9bLW9bL00::RXX00g9bLVQXJ6QXJ002Hf=S00=EEEEJFUYJFUX00XZ:RP03]KFe
YjNWYjNW00:5QHD00ginOX61PH61P@02MWIf00=^KVilO7alO7`00XF5Q@03LG5aH61PH61P009eMGD0
0iBDU:>SXj>SX`02WinO0Xb<S003O7alP820P82000:9RHT00h61PGAdM7AdM002Lg=c0gMgM`9dM7@0
0g9bLW5aLG5aL@02LG5a00=eMGF2PX:2PX800XZ:RP03PH61MgMgMgMg009oOgl00h>3Pfe]KFe]K@02
FUYJ00=UIFEmOGemOGd00X^;R`03RXZ:NWYjNWYj009/K6`00g1`L7alO7alO003P8200XF5Q@Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2B4Q800=XJ6QnOWinOWh00WEeM@03HF5QF5QHF5QH
009MGEd00g9bLW=cLg=cL`02?clo00>;Rh^TY:BTY:@00UYJFP03HF5QG5aLG5aL009ZJVX00fi^KT];
Bd];B`02V9RH00>3Ph=mOGemOGd00WQhN003OWinUIFEUIFE00:XZ:P00j:RXY6ATI6AT@02Q8B400>2
PX:<S8b<S8`00R<S8`:/[:`00k2`/:>SXj>SX`02V9RH00>QXJ6e]KFe]KD00U1@D003EEEE^k^k^k^k
00:MWId00hJ6QXF5QHF5Q@02Y:BT00=6ATJc/k>c/k<00YfMW@03;Bd]]kNg]kNg00:b/[800j6QXI6A
TI6AT@02RXZ:00>>SXjSXj>SXj<00/S8b003JFUYHf=SHf=S00;:b/X00l?3`lo?clo?c`02N7Qh00>;
Rh]ZJVYZJVX00[Zj^P03^k^kbl_;bl_;009>CTh00d=3@cdm?Cdm?@02/k>c00<i>CVn_[jn_[h00]SH
f003NWYjPH61PH6100=nOWh2L71`0[fm_@037QhNX:2PX:2P00:f][H00cLg=j6QXJ6QX@02WinO00>P
X:2GUiNGUiL00YRHV003>3PhC4a<C4a<008m?Cd00iVIVHN7QhN7Q`02Ph>30Xf=S@03UYJFSHf=SHf=
00:2PX800hF5QH^;Rh^;R`02RHV900>4Q8B3Ph>3Ph<00XF5Q@03QXJ6RHV9RHV900:<S8`00h^;RhB4
Q8B4Q002OWin00>5QHF:RXZ:RXX00X:2PP03OGemTI6ATI6A00:VYZH00bPX:9FEUIFEU@02TI6A00>J
VYZ][Jf][Jd00[bl_003^;RhZj^[Zj^[008];Bd00jZZZ[2`/;2`/004oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool2^[Zj00>HV9QZJVYZJVX00XV9R@03^[Zj_Kfm_Kfm00:XZ:P0
0iNGUhf=SHf=S@02Rh^;00>ATI6FUYJFUYH00Y^KV`03YJFUZj^[Zj^[00:RXZ800iJFUY:BTY:BTP02
T92@00>7QhMnOWinOWh00WalO003PX:2SHf=SHf=00>GUiL2Ti>C0hf=S@:LW9`2Vi^K0VUYJ@03@d=3
IFEUIFEU00:BTY800h>3Pf9RHV9RHP02HV9R00=^KVi/K6a/K6`00Vi^KP03RHV9Vi^KVi^K00:7QhL0
0gEeMHb<S8b<S002Y:BT00>FUYI^KVi^KVh00S/k>`03:RXZH61PH61P00:HV9P00hN7Qe1@D51@D002
8b<S00</;2b;Rh^;Rh/00^;RhP03a/K6O7alO7al009OGel00fEUIGUiNGUiN@02RXZ:00=nOWiZJVYZ
JVX00Ve]K@03OgmoTi>CTi>C00:NWYh00iNGUhV9RHV9R@02QHF500=nOWiZJVYZJVX00UADE003@T92
E5ADE5AD00:VYZH00n7QhJ^[Zj^[Z`02HF5Q00=aLG6ATI6ATI400VUYJ@03?ShnEUIFEUIF009lO7`0
0gMgMfa/K6a/K002P82000>HV9RFUYJFUYH00Xj>SP:BTY800iFEUH^;Rh^;R`02P82000=oOgn0P820
P8000WemO@03MgMgMWIfMWIf009fMWH00gMgMgYjNWYjNP02OWin00>0P81oOgmoOgl00WemO@=kNg/2
OGem00=nOWilO7alO7`00X20P003TI6AWYjNWYjN00:GUiL00h>3PfUYJFUYJ@02Fe]K00=aLG60P820
P8000U]KF`03@d=3OWinOWin00Coool00`000?ooooooo`0boooo00@0003oooooooooool2Rh^;00>X
Z:QFEUIFEUH00[Vi^@03U9BDTi>CTi>C00:PX:000j>SXijNWYjNWP02Ti>C00>9RHV;Rh^;Rh/00YFE
U@03VYZJWIfMWIfM00:QXJ400inOWi>CTi>CT`03QhN70Xb<S0:=SHd00hV9RH20P820P002NWYj00=k
Ng^1PH61PH400XV9R@03SHf=Q8B4Q8B400:7QhL2[Zj^00=BDU8d=3@d=3@00X^;R`03WIfMBDU9BDU9
00;;bl/00lO7adm?Cdm?C`02`/;200<];BfBTY:BTY800Z6QX@03=cLgWYjNWYjN00:9RHT00i6ATJj^
[Zj^[P02FUYJ00=WIfNf][Jf][H00Xn?S`03YZJVHf=SHf=S00:BTY800iFEUDm?Cdm?C`02Rh^;00<`
<31cLg=cLg<00Xn?S`03S8b<NWYjNWYj009ZJVX00fm_KgUiNGUiN@02KFe]00??clng]kNg]kL00Zf]
[@03@410d=3@d=3@009VIVH00g9bLX20P820P002RHV900><S8acLg=cLg<00ZFUY@03M7AdWinOWinO
009MGEd00l30`9VIVIVIV@02[Jf]00=@D50l?3`l?3`00YZJVP03Y:BT/;2`/;2`00:OWil00hN7Qh>3
Ph>3P`02QHF50WmoO`03Ng]kPH61PH6100:9RHT00hN7Qh>3Ph>3P`02Q8B41HN7Q`03QXJ6QHF5QHF5
00>4Q8@2QXJ60hV9R@:7QhL2Q8B400>3Ph>8R8R8R8P00X^;R`03QHF5PH61PH6100:;Rh/00bHV9[Vi
^KVi^@02CTi>00>i^KV`/;2`/;000];BdP03Kfm_^[Zj^[Zj00Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`:j^[X00iRHV6YZJVYZJP02RHV900>j^[Zm_Kfm_Kd00ZRXZ003UiNG
SHf=SHf=00:;Rh/00i6ATIJFUYJFUP02Vi^K00>UYJF[Zj^[Zj/00Z:RXP03UYJFTY:BTY:B00:@T900
0hN7QginOWinOP02O7al00>2PX:=SHf=SHd00iNGU`:CTi<3SHf=0YbLW0:KVi/2JFUY00=3@d=UIFEU
IFD00Y:BTP03Ph>3HV9RHV9R009RHV800fi^KVa/K6a/K002KVi^00>9RHVKVi^KVi/00XN7Q`03MGEe
S8b<S8b<00:TY:@00iJFUVi^KVi^KP02>c/k00<Z:RYPH61PH6000YRHV003QhN7D51@D51@008S8b<0
0b`/;8^;Rh^;R`02h^;R00?6a/IlO7alO7`00UmOG`03IFEUNGUiNGUi00::RXX00ginOVYZJVYZJP02
KFe]00=oOgnCTi>CTi<00YjNWP03UiNGRHV9RHV900:5QHD00ginOVYZJVYZJP02E5AD00=2@T9DE5AD
E5@00ZJVYP03hN7QZj^[Zj^[009QHF400g5aLI6ATI6AT@02JFUY00<n?SiFEUIFEUH00WalO003MgMg
K6a/K6a/00:0P8000iRHV9JFUYJFUP02SXj>0Y:BTP03UIFERh^;Rh^;00:0P8000gmoOh20P820P002
OGem00=gMgMfMWIfMWH00WIfMP03MgMgNWYjNWYj009nOWh00h20P7moOgmoO`02OGem0g]kN`9mOGd0
0ginOWalO7alO002P82000>ATI6NWYjNWYh00YNGU`03Ph>3JFUYJFUY009KFe/00g5aLH20P820P002
Fe]K00=3@d=nOWinOWh01?ooo`030000oooooooo03;oool010000?ooooooooooo`:;Rh/00jRXZ5IF
EUIFEP02^KVi00>DU9BCTi>CTi<00Z2PX003Xj>SWYjNWYjN00:CTi<00hV9RH^;Rh^;R`02UIFE00>J
VYZMWIfMWId00Z6QX@03WinOTi>CTi>C00>7QhL2S8b<0Xf=S@03RHV9P820P820009jNWX00g]kNh61
PH61P@02RHV900>=SHf4Q8B4Q8@00XN7Q`:^[Zh00e9BDS@d=3@d=002Rh^;00>MWIe9BDU9BDT00/_;
b`03alO7Cdm?Cdm?00;2`/800bd];I:BTY:BTP02XJ6Q00<g=cNNWYjNWYh00XV9R@03TI6A[Zj^[Zj^
009JFUX00fMWIkJf][Jf]P02Shn?00>VYZISHf=SHf<00Y:BTP03UIFECdm?Cdm?00:;Rh/00c0`<7=c
Lg=cL`02Shn?00><S8ajNWYjNWX00VYZJP03Kfm_NGUiNGUi009]KFd00lo?ckNg]kNg]`02[Jf]00=0
@43@d=3@d=000VIVIP03LW9bP820P82000:9RHT00hb<S7=cLg=cL`02YJFU00=dM7BOWinOWil00UeM
G@03`<30VIVIVIVI00:][Jd00e1@D3`l?3`l?002VYZJ00>TY:B`/;2`/;000YnOW`03QhN7Ph>3Ph>3
00:5QHD2Ogmo00=kNg^1PH61PH400XV9R@03QhN7Ph>3Ph>300:4Q8@5QhN700>6QXJ5QHF5QHD00hB4
Q0:6QXH3RHV90XN7Q`:4Q8@00h>3PhR8R8R8R002Rh^;00>5QHF1PH61PH400X^;R`039RHV^KVi^KVi
009>CTh00kVi^K2`/;2`/002d];B00=_Kfnj^[Zj^[X01?ooo`030000oooooooo013oool002Goool0
0`000?ooooooo`02oooo0ZNWY`03V9RHNg]kNg]k00:5QHD00i^KVijNWYjNWP02VIVI00>HV9RDU9BD
U9@00X^;R`03QXJ6S8b<S8b<00:DU9@3VIVI0YRHV003U9BDShn?Shn?00:8R8P00h61PGalO7alO002
NWYj00=nOWj7QhN7QhL00Xj>SP03S8b<QXJ6QXJ600>0P802SXj>0Y:BTP9fMWH00emOGgIfMWIfMP02
TY:B00>4Q8A^KVi^KVh00WIfMP03PH61Kfm_Kfm_009PH6000g5aLH^;Rh^;R`02UIFE00>FUYJKVi^K
Vi/00Y>CT`03M7AdGemOGemO009aLG400i2@T9^KVi^KV`02Shn?00=aLG5EEEEEEED00U5AD@03JVYZ
WYjNWYjN00:n_[h00ifMWFi^KVi^KP02JVYZ00=lO7b3Ph>3Ph<00X:2PP03OgmoMgMgMgMg009XJ6P0
0fUYJHj>SXj>SP02YjNW00>3Ph=KFe]KFe/00Ve]K@03S8b<Rh^;Rh^;009bLW800dQ8B4A4A4A4A002
WIfM00?Rh^:EUIFEUID00SHf=P03EeMGUiNGUiNG00:6QXH00f5QHFa/K6a/K002Ph>300>5QHF2PX:2
PX800XN7Q`03Rh^;QHF5QHF500:0P802Q8B400>:RXZ5QHF5QHD00WmoO`03PH61Q8B4Q8B400:2PX80
0ginOWemOGemO@02OWin00=oOgn1PH61PH400h>3P`:1PH42OWin00=mOGenOWinOWh00WinOP03Ogmo
QhN7QhN700:?Shl00hf=SHZ:RXZ:RP02Ti>C00>DU9AjNWYjNWX00VMWI`03PH61UiNGUiNG009aLG40
0e1@D7MgMgMgM`04oooo00<0003oooooool0<_ooo`040000oooooooooooo0Xn?S`03SXj>W9bLW9bL
00:ATI400h61PH:2PX:2PP02QhN700>5QHF3Ph>3Ph<00XF5Q@03QhN7Q8B4Q8B400:2PX800hB4Q8J6
QXJ6QP02QHF500>4Q8B3Ph>3Ph<00XB4Q003QhN7Rh^;Rh^;00:<S8`00hV9RH20P820P002NWYj00=l
O7b2PX:2PX800XV9R@03Rh^;PX:2PX:200:0P802V9RH00>[Zj^IVIVIVIT00XJ6QP03UiNG=cLg=cLg
00:b/[800cHf=TU9BDU9B@02dM7A00=:BTZ/[:b/[:`00Z2PX003VYZJTI6ATI6A00:CTi<00c8b<[fm
_Kfm_@02>3Ph00>NWYjLW9bLW9`00SHf=P03F5QHMgMgMgMg00:2PX800g9bL/K6a/K6aP02/K6a00=I
FEV7QhN7QhL00Y6AT@03QXJ6Ph>3Ph>300F4Q8@2QXJ600=iNGU?Cdm?Cdl00Zn_[`03EUIFPH61PH61
009lO7`00fQXJ=kNg]kNgP02Kfm_00>5QHEoOgmoOgl00Z^[Z`03LW9b/K6a/K6a00:2PX800eiNGQdM
7AdM7@02V9RH00>^[ZjQXJ6QXJ400hn?S`:BTY82Rh^;0hB4Q0:6QXH2PH6100=nOWj3Ph>3Ph<00XR8
R003QhN7Q8B4Q8B400:5QHD3R8R80XN7Q`03QXJ6QHF5QHF500>4Q8@2QhN70XV9R@03R8R8QXJ6QXJ6
00>6QXH2QHF50XJ6QP03Shn?UiNGUiNG00:CTi<00i:BTZRXZ:RXZ002@D5100<c<c<[:b/[:b/00U9B
DP03Kfm_BDU9BDU900Coool00`000?ooooooo`0@oooo000Uoooo0P0000?oool2YjNW00>HV9QkNg]k
Ng/00XF5Q@03Vi^KWYjNWYjN00:IVIT00iRHV9BDU9BDU002Rh^;00>6QXJ<S8b<S8`00YBDU0>IVIT2
V9RH00>DU9B?Shn?Shl00XR8R003PH61O7alO7al009jNWX00ginOXN7QhN7Q`02SXj>00><S8b6QXJ6
QXH00h20P0:>SXh2TY:B0WIfMP03GemOMWIfMWIf00:BTY800hB4Q6i^KVi^KP02MWIf00>1PH5_Kfm_
Kfl00V1PH003LG5aRh^;Rh^;00:EUID00iJFUY^KVi^KV`02Ti>C00=dM7AOGemOGel00W5aL@03T92@
Vi^KVi^K00:?Shl00g5aLEEEEEEEE@02DE5A00=ZJVZNWYjNWYh00[jn_P03WIfMKVi^KVi^009ZJVX0
0galO8>3Ph>3P`02PX:200=oOgmgMgMgMgL00VQXJ003JFUYSXj>SXj>00:WYjL00h>3Pe]KFe]KF`02
KFe]00><S8b;Rh^;Rh/00W9bLP03B4Q8A4A4A4A400:MWId00n;RhYFEUIFEU@02=SHf00=GEeNGUiNG
UiL00XJ6QP03HF5QK6a/K6a/00:3Ph<00hF5QH:2PX:2PP02QhN700>;Rh^5QHF5QHD00X20P0:4Q8@0
0hZ:RXF5QHF5Q@02Ogmo00>1PH64Q8B4Q8@00X:2PP03OWinOGemOGem009nOWh00gmoOh61PH61P@03
Ph>30X61P@9nOWh00gemOGinOWinOP02OWin00=oOgn7QhN7QhL00Xn?S`03SHf=RXZ:RXZ:00:CTi<0
0iBDU7YjNWYjNP02IfMW00>1PH6GUiNGUiL00W5aL@03D51@MgMgMgMg00?oool20000=?ooo`040000
oooooooooooo0Xn?S`03SXj>W9bLW9bL00:ATI400h61PH:2PX:2PP02QhN700>5QHF3Ph>3Ph<00XF5
Q@03QhN7Q8B4Q8B400:2PX800hB4Q8J6QXJ6QP02QHF500>4Q8B3Ph>3Ph<00XB4Q003QhN7Rh^;Rh^;
00:<S8`00hV9RH20P820P002NWYj00=lO7b2PX:2PX800XV9R@03Rh^;PX:2PX:200:0P802V9RH00>[
Zj^IVIVIVIT00XJ6QP03UiNG=cLg=cLg00:b/[800cHf=TU9BDU9B@02dM7A00=:BTZ/[:b/[:`00Z2P
X003VYZJTI6ATI6A00:CTi<00c8b<[fm_Kfm_@02>3Ph00>NWYjLW9bLW9`00SHf=P03F5QHMgMgMgMg
00:2PX800g9bL/K6a/K6aP02/K6a00=IFEV7QhN7QhL00Y6AT@03QXJ6Ph>3Ph>300F4Q8@2QXJ600=i
NGU?Cdm?Cdl00Zn_[`03EUIFPH61PH61009lO7`00fQXJ=kNg]kNgP02Kfm_00>5QHEoOgmoOgl00Z^[
Z`03LW9b/K6a/K6a00:2PX800eiNGQdM7AdM7@02V9RH00>^[ZjQXJ6QXJ400hn?S`:BTY82Rh^;0hB4
Q0:6QXH2PH6100=nOWj3Ph>3Ph<00XR8R003QhN7Q8B4Q8B400:5QHD3R8R80XN7Q`03QXJ6QHF5QHF5
00>4Q8@2QhN70XV9R@03R8R8QXJ6QXJ600>6QXH2QHF50XJ6QP03Shn?UiNGUiNG00:CTi<00i:BTZRX
Z:RXZ002@D5100<c<c<[:b/[:b/00U9BDP03Kfm_BDU9BDU900?oool200004_ooo`009Oooo`030000
oooooooo00;oool2PX:200>8R8R6QXJ6QXH00WQhN003Jf][LG5aLG5a009nOWh00h61PGmoOgmoO`02
Ogmo00=nOWilO7alO7`01GUiN@9jNWX3Ng]k0WemO@03P820Ph>3Ph>300:4Q8@00h61PGUiNGUiN@03
Lg=c0WMgM`9jNWX00galO7inOWinOP02PH610XN7Q`03SHf=Shn?Shn?00:=SHd00hN7QhB4Q8B4Q002
Shn?00>CTi>0P820P8000VYZJP03IVIVMGEeMGEe00:ATI400jBTY9jNWYjNWP02PH6100=EEEEBDU9B
DU800ZZZZP03moOgc/k>c/k>009nOWh00fMWIg]kNg]kN`02W9bL00>`/;2IVIVIVIT00W5aL@03I6AT
K6a/K6a/009nOWh00hf=SH^;Rh^;R`02Q8B400><S8b>SXj>SXh00Vm_K`03FUYJOgmoOgmo00:MWId0
0g=cLdM7AdM7A`02IfMW00>KVi^WYjNWYjL00Y2@T003GEeMB4Q8B4Q800:ATI400l[:bWYjNWYjNP02
820P00=:BTZLW9bLW9`00ZRXZ003UIFEShn?Shn?00:?Shl00i2@T96ATI6AT@02R8R800=kNg]gMgMg
MgL00WMgM`=eMGD2O7al0X>3P`03Q8B4Ph>3Ph>300:4Q8@00hJ6QXN7QhN7Q`02QhN700>6QXJ5QHF5
QHD00XB4Q003Ph>3Q8B4Q8B400:4Q8@00h>3Ph61PH61P@02PH6100>4Q8B>SXj>SXh00Xj>SP03MGEe
IFEUIFEU00:3Ph<00jBTY9JFUYJFUP02Ogmo00><S8bNWYjNWYh00Y6AT@03OGemNg]kNg]k00Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2XZ:R00>7QhMgMgMgMgL00WalO0>8R8P3Ph>31HF5
Q@:6QXH2QhN700>5QHF4Q8B4Q8@00X>3P`03Q8B4QXJ6QXJ600:7QhL00hF5QHB4Q8B4Q002Ph>300>4
Q8B9RHV9RHT00Xf=S@03S8b<R8R8R8R800:6QXH3QHF50XB4Q0:1PH400gmoOh20P820P002QHF500>?
ShnEUIFEUID00Y:BTP03UIFE[Jf][Jf]009=CDd00m3@d4];Bd];B`02Z:RX00>@T92<S8b<S8`00YnO
W`03Bd];cLg=cLg=00:>SXh00eUIFHJ6QXJ6QP02FEUI00?_knm]KFe]KFd00UEEE@03`<30G5aLG5aL
009nOWh3Shn?0XN7Q`03PH61QhN7QhN700:?Shl00hR8R861PH61P@02T92@00>DU9AYJFUYJFT00/;2
`P03K6a/UYJFUYJF00:3Ph<00eaLG<S8b<S8b002F5QH00=hN7R0P820P8000[Rh^003QHF5BTY:BTY:
00:?Shl00mgMgHn?Shn?S`02Ng]k0h:2PP:1PH400ginOWalO7alO002P8200hN7Q`:6QXH2RHV900>;
Rh^8R8R8R8P00XF5Q@03QXJ6QhN7QhN700:7QhL00hJ6QXF5QHF5Q@03QXJ61HN7Q`:6QXH3QHF50XJ6
QP>7QhL2Q8B40XZ:RP03YZJV^;Rh^;Rh00:PX:000h>3Phf=SHf=S@02XZ:R00>QXJ6PX:2PX:000[Fe
]@03a/K6@T92@T9200Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`::RXX0
0h20P7EeMGEeM@02IfMW00=PH61VIVIVIVH00W5aL@03MgMgNGUiNGUi009kNg/00gYjNWMgMgMgM`02
LW9b00=^KVi]KFe]KFd00Vi^KP03LW9bMWIfMWIf009jNWX00ginOX61PH61P@02PX:200=oOgmiNGUi
NGT00gAdM09fMWH3N7Qh0WMgM`9iNGT2PX:200>:RXZ;Rh^;Rh/00XR8R003QhN7Rh^;Rh^;00:BTY80
0iNGUiBDU9BDU002R8R800=dM7AXJ6QXJ6P00W5aL@03Ph>3U9BDU9BD00:EUID00gUiNFUYJFUYJ@02
S8b<00>`/;2JVYZJVYX00W]kN`03S8b<ZZZZZZZZ00:][Jd00i^KVginOWinOP03IVIV0WIfMP:5QHD0
0hj>SXn?Shn?S`02S8b<00>@T92?Shn?Shl00WmoO`03KVi^LG5aLG5a00=kNg/2P8200YRHV003Z:RX
VIVIVIVI00:0P8000g1`L7UiNGUiN@02ZJVY00>n_[iiNGUiNGT00SPh>003Hf=SZJVYZJVY00:ZZZX0
0hn?ShZ:RXZ:RP02S8b<00>:RXZ7QhN7QhL00X20P003MgMgMGEeMGEe009eMGD2M7Ad00=fMWIlO7al
O7`00X:2PP>4Q8@2QXJ61XR8R0:7QhL2QHF51HB4Q003Ph>3PX:2PX:200:2PX800hF5QHj>SXj>SP02
S8b<00=/K6aFEUIFEUH00W=cL`03Vi^KWYjNWYjN00:=SHd00galO7IfMWIfMP02Ph>300>DU9BEUIFE
UID01?ooo`030000oooooooo03;oool010000?ooooooooooo`:ATI400h>3PgalO7alO002P8200hN7
Q`>4Q8@2QHF51hJ6QP>5QHD2Q8B400>5QHF6QXJ6QXH00XN7Q`03QXJ6Q8B4Q8B400:4Q8@00hF5QHV9
RHV9R@02S8b<00>;Rh^8R8R8R8P00XJ6QP03QHF5QhN7QhN700:6QXH2PH6100=mOGf0P820P8000XF5
Q@>8R8P2QHF500>6QXJATI6ATI400ZFUY@03A4A4bl_;bl_;0096ATH00bd];I6ATI6AT@02S8b<00>W
YjM6ATI6ATH00[6a/@03XZ:R`<30`<30009ZJVX00mkNgU9BDU9BDP02c<c<00=QHF5iNGUiNGT00Xj>
SP03TI6ARh^;Rh^;00:5QHD00h>3PhN7QhN7Q`02Rh^;00>8R8R5QHF5QHD00X^;R`03SHf=PH61PH61
009aLG400fm_KnOWinOWi`02GEeM00=CDe?GemOGemL00Vi^KP03MGEeIFEUIFEU00:^[Zh00i6ATDI6
ATI6AP02LG5a00>n_[ilO7alO7`00WAdM0>4Q8@5Ogmo0X>3P`F7QhL2RHV900>:RXZ8R8R8R8P00XF5
Q@03QXJ6QhN7QhN700:7QhL00hJ6QXF5QHF5Q@05QXJ60hN7Q`:6QXH2QHF51HJ6QP03QhN7Q8B4Q8B4
00:<S8`00c8b<TM7AdM7A`02;bl_00>6QXJ2PX:2PX800Y:BTP03ZJVY^[Zj^[Zj008o?cl00j^[ZijN
WYjNWP04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2RXZ:00>0P81eMGEe
MGD00VMWI`03H61PIVIVIVIV009aLG400gMgMgUiNGUiN@02Ng]k00=jNWYgMgMgMgL00W9bLP03KVi^
KFe]KFe]009^KVh00g9bLWIfMWIfMP02NWYj00=nOWj1PH61PH400X:2PP03OgmoNGUiNGUi00=dM7@2
MWIf0gQhN09gMgL2NGUi0X:2PP03RXZ:Rh^;Rh^;00:8R8P00hN7Qh^;Rh^;R`02TY:B00>GUiNDU9BD
U9@00XR8R003M7AdJ6QXJ6QX009aLG400h>3PiBDU9BDU002UIFE00=iNGUYJFUYJFT00Xb<S003/;2`
VYZJVYZJ009kNg/00hb<S:ZZZZZZZP02[Jf]00>KVi]nOWinOWh00fIVIP9fMWH2QHF500>>SXj?Shn?
Shl00Xb<S003T92@Shn?Shn?009oOgl00fi^KW5aLG5aL@03Ng]k0X20P0:HV9P00jRXZ9VIVIVIV@02
P82000=`L71iNGUiNGT00ZVYZ@03_[jnNGUiNGUi008h>3P00f=SHjVYZJVYZ@02ZZZZ00>?Shn:RXZ:
RXX00Xb<S003RXZ:QhN7QhN700:0P8000gMgMgEeMGEeM@02MGEe0WAdM003MWIfO7alO7al00:2PX83
Q8B40XJ6QPJ8R8P2QhN70XF5Q@F4Q8@00h>3Ph:2PX:2PP02PX:200>5QHF>SXj>SXh00Xb<S003K6a/
EUIFEUIF009cLg<00i^KVijNWYjNWP02SHf=00=lO7afMWIfMWH00X>3P`03U9BDUIFEUIFE00Coool0
0`000?ooooooo`0boooo00@0003oooooooooool2TI6A00>3Ph=lO7alO7`00X20P0>7QhL3Q8B40XF5
Q@N6QXH3QHF50XB4Q003QHF5QXJ6QXJ600:7QhL00hJ6QXB4Q8B4Q002Q8B400>5QHF9RHV9RHT00Xb<
S003Rh^;R8R8R8R800:6QXH00hF5QHN7QhN7Q`02QXJ60X61P@03OGemP820P82000:5QHD3R8R80XF5
Q@03QXJ6TI6ATI6A00:UYJD00dA4A<_;bl_;b`02ATI600<];BfATI6ATI400Xb<S003YjNWATI6ATI6
00:a/K400j:RX/30`<30`002JVYZ00?Ng]iBDU9BDU800/c<c003HF5QNGUiNGUi00:>SXh00i6ATH^;
Rh^;R`02QHF500>3Ph>7QhN7QhL00X^;R`03R8R8QHF5QHF500:;Rh/00hf=SH61PH61P@02LG5a00=_
KfoWinOWinL00UeMG@03De=CemOGemOG009^KVh00gEeMFEUIFEUI@02[Zj^00>ATI56ATI6ATH00W5a
L@03_[jnO7alO7al009dM7@3Q8B41GmoO`:3Ph<5QhN70XV9R@03RXZ:R8R8R8R800:5QHD00hJ6QXN7
QhN7Q`02QhN700>6QXJ5QHF5QHD01HJ6QP>7QhL2QXJ60XF5Q@F6QXH00hN7QhB4Q8B4Q002S8b<00<b
<S97AdM7AdL00Rl_;`03QXJ6PX:2PX:200:BTY800jVYZKZj^[Zj^P02?clo00>[Zj^NWYjNWYh01?oo
o`030000oooooooo013oool002Goool00`000?ooooooo`02oooo0YbLW003OgmoI6ATI6AT009QHF40
0f][Jg1`L71`L002LW9b00=gMgMkNg]kNg/00WalO003Ng]kNWYjNWYj009gMgL00g=cLg1`L71`L002
LG5a00=eMGEiNGUiNGT00WemO@=nOWh2OGem00=nOWj0P820P8000X61P@03P820O7alO7al00EjNWX2
Ng]k0WUiN@03N7QhOWinOWin00:4Q8@00hJ6QXN7QhN7Q`02R8R800>?ShnLW9bLW9`00YnOW`03RXZ:
K6a/K6a/009IFET00emOGhF5QHF5Q@02YjNW00>OWimnOWinOWh00UeMG@03CDe=EEEEEEEE009gMgL0
0jRXZ;no_kno_`02VYZJ00=YJFUVIVIVIVH00WUiN@>0P802Ph>300>6QXJ=SHf=SHd00Y:BTP03SHf=
QXJ6QXJ600::RXX00hR8R6a/K6a/K002H61P00>9RHVi^KVi^KT00[no_`03Y:BTOWinOWin009XJ6P0
0g]kNj2PX:2PX002];Bd00>][Jf3Ph>3Ph<00VIVIP03Ph>3YjNWYjNW00:GUiL00gMgMgUiNGUiN@02
Q8B400=oOgmfMWIfMWH00WQhN003O7alNg]kNg]k009jNWX2O7al00=oOgn0P820P8000X61P@03PX:2
Q8B4Q8B400F4Q8@7QHF500>4Q8B3Ph>3Ph<00X:2PP03PH61PX:2PX:200:2PX800hB4Q8V9RHV9R@02
QXJ600=_KfmOGemOGel00Vi^KP03RHV9VIVIVIVI00:ATI400fUYJDe=CDe=C@02JVYZ00>IVIVYZJVY
ZJT01?ooo`030000oooooooo03;oool010000?ooooooooooo`9kNg/00hB4Q8j>SXj>SP02S8b<0hB4
Q0>7QhL:QXJ618N7Q`J6QXH2QhN70XR8R003QhN7QHF5QHF500>3Ph<2QHF50XJ6QP03QhN7QXJ6QXJ6
00:6QXH2RHV900><S8b:RXZ:RXX00XJ6QP>5QHD2Q8B400>2PX9oOgmoOgl00XF5Q@03WinO@D51@D51
00;8b<P00kbl_9RHV9RHV002O7al00>:RXZd];Bd];@00VEUI@03PX:2R8R8R8R8009fMWH00eEEEKno
_kno_`02IfMW00>?ShnBTY:BTY800X>3P`03P820Q8B4Q8B400:7QhL00hR8R8J6QXJ6QP02Ph>300>7
QhN:RXZ:RXX00X:2PP03OGemSXj>SXj>00:CTi<00fi^K/30`<30`002@T9200?Bd]9kNg]kNg/00Xj>
SP03O7alEUIFEUIF00:`/;000j:RXSHf=SHf=P02][Jf00>DU9A`L71`L7000W]kN`03U9BDTI6ATI6A
00:5QHD00hN7Qhb<S8b<S002RHV90hF5Q@:6QXH2QHF500>4Q8B5QHF5QHD00XN7Q`J6QXH2QhN72XJ6
QP>7QhL5QXJ60XF5Q@:;Rh/00j:RX[:b/[:b/P02YZJV00>?Shn1PH61PH400XV9R@03=cLgclo?clo?
0093@d<00iJFUX20P820P004oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
W9bL00=oOgmTI6ATI6@00V5QH@03Jf][L71`L71`009bLW800gMgMg]kNg]kN`02O7al00=kNg]jNWYj
NWX00WMgM`03Lg=cL71`L71`009aLG400gEeMGUiNGUiN@02OGem0ginOP9mOGd00ginOX20P820P002
PH6100>0P81lO7alO7`01GYjNP9kNg/2NGUi00=hN7QnOWinOWh00XB4Q003QXJ6QhN7QhN700:8R8P0
0hn?SibLW9bLW002WinO00>:RXY/K6a/K6`00UUIF@03GemOQHF5QHF500:WYjL00inOWginOWinOP02
GEeM00==CDeEEEEEEED00WMgM`03Z:RX_kno_kno00:JVYX00fUYJFIVIVIVIP02NGUi0h20P0:3Ph<0
0hJ6QXf=SHf=S@02TY:B00>=SHf6QXJ6QXH00XZ:RP03R8R8K6a/K6a/009PH6000hV9RKVi^KVi^@02
_kno00>TY:AnOWinOWh00VQXJ003Ng]kX:2PX:2P00:d];@00jf][H>3Ph>3P`02IVIV00>3Ph>WYjNW
YjL00YNGU`03MgMgNGUiNGUi00:4Q8@00gmoOgIfMWIfMP02N7Qh00=lO7akNg]kNg/00WYjNP9lO7`0
0gmoOh20P820P002PH6100>2PX:4Q8B4Q8@01HB4Q0N5QHD00hB4Q8>3Ph>3P`02PX:200>1PH62PX:2
PX800X:2PP03Q8B4RHV9RHV900:6QXH00fm_KemOGemOG`02KVi^00>9RHVIVIVIVIT00Y6AT@03JFUY
CDe=CDe=009ZJVX00iVIVJVYZJVYZ@04oooo00<0003oooooool0<_ooo`040000oooooooooooo0W]k
N`03Q8B4SXj>SXj>00:<S8`3Q8B40hN7Q`Z6QXH4QhN71XJ6QP:7QhL2R8R800>7QhN5QHF5QHD00h>3
P`:5QHD2QXJ600>7QhN6QXJ6QXH00XJ6QP:9RHT00hb<S8Z:RXZ:RP02QXJ60hF5Q@:4Q8@00h:2PWmo
OgmoO`02QHF500>OWim1@D51@D400/S8b003_;blV9RHV9RH009lO7`00hZ:R[Bd];Bd]002IFEU00>2
PX:8R8R8R8P00WIfMP03EEEE_kno_kno009WIfL00hn?Si:BTY:BTP02Ph>300>0P824Q8B4Q8@00XN7
Q`03R8R8QXJ6QXJ600:3Ph<00hN7QhZ:RXZ:RP02PX:200=mOGf>SXj>SXh00Y>CT`03KVi^`<30`<30
0092@T800m;BdW]kNg]kN`02SXj>00=lO7aFEUIFEUH00[2`/003XZ:R=SHf=SHf00:f][H00iBDU71`
L71`L002Ng]k00>DU9BATI6ATI400XF5Q@03QhN7S8b<S8b<00:9RHT3QHF50XJ6QP:5QHD00hB4Q8F5
QHF5Q@02QhN71XJ6QP:7QhL:QXJ60hN7Q`F6QXH2QHF50X^;R`03XZ:R/[:b/[:b00:VYZH00hn?Sh61
PH61P@02RHV900<g=cO?clo?cll00T=3@`03UYJFP820P82000Coool00`000?ooooooo`0@oooo000U
oooo00<0003oooooool00_ooo`:>SXh00gmoOg=cLg=cL`02M7Ad00=jNWYnOWinOWh00WmoO`>0P805
Ogmo0ginOPAmOGd00ginOWmoOgmoO`05P8200WmoO`03P820PX:2PX:200>3Ph<2PH610h20P0AoOgl2
OGem00=lO7aoOgmoOgl00X:2PP03PH61P820P820009nOWh00h61PH^;Rh^;R`02Ti>C00>?Shn2PX:2
PX800W5aL@03Jf][Ng]kNg]k00:;Rh/00ginOV][Jf][J`02Kfm_00=fMWIVIVIVIVH00UmOG`03P820
WIfMWIfM00:8R8P00fUYJFa/K6a/K002OWin00>2PX:1PH61PH400X61P@03PX:2QXJ6QXJ600:9RHT0
0hF5QH61PH61P@02QXJ600>7QhMiNGUiNGT00W1`L003QXJ6W9bLW9bL00:GUiL00hB4Q7IfMWIfMP02
Lg=c00=lO7b6QXJ6QXH00XB4Q003OgmoPX:2PX:200>8R8P2QXJ60X61P@03OGemOWinOWin00:1PH40
0gemOGYjNWYjNP02O7al00>0P821PH61PH400X61P@F2PX8APH6100>2PX:1PH61PH401h61P@03PX:2
Ph>3Ph>300:2PX800gemOGYjNWYjNP02OGem00>5QHFBTY:BTY800Y2@T003Kfm_EUIFEUIF009_Kfl0
0iFEUIbLW9bLW004oooo00<0003oooooool0<_ooo`040000oooooooooooo0X61P@03QhN7Rh^;Rh^;
00::RXX3QXJ60hR8R0B7QhL3QXJ62XN7Q`>6QXH5QhN70XF5Q@>4Q8@9QXJ60XR8R003RXZ:RHV9RHV9
00:6QXH5QHF500>4Q8B0P820P8000X61P@03Rh^;VYZJVYZJ00:WYjL00c0`<9^KVi^KV`02TI6A00<^
;Rk7alO7alL00UaLG003IfMWP820P82000:>SXh00gQhN6=SHf=SH`02MgMg00>CTi>ATI6ATI400X>3
P`03PH61QHF5QHF500:7QhL00hR8R8J6QXJ6QP02Ph>300>5QHF8R8R8R8P00X>3P`03P820S8b<S8b<
00:@T9000galO6EUIFEUI@02IfMW00=gMgN6QXJ6QXH00Xj>SP03R8R8N7QhN7Qh00;Ogml00di>CZNW
YjNWY`02S8b<0gmoO`:5QHD00h^;RhZ:RXZ:RP02QhN700>8R8R:RXZ:RXX00XR8R0F6QXH3QHF588J6
QP:8R8P00hn?Si>CTi>CT`02TY:B00><S8b2PX:2PX800XB4Q003XZ:R@410@41000:VYZH00hJ6QWem
OGemO@04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2NWYj00>1PH6;Rh^;
Rh/00X^;R`03R8R8RXZ:RXZ:00:<S8`00hZ:RXN7QhN7Q`02Q8B400>3Ph>4Q8B4Q8@00XJ6QP03RHV9
Rh^;Rh^;00::RXX00hR8R8F5QHF5Q@02Ph>31H:2PP03Ph>3PX:2PX:200:2PX800h>3PhB4Q8B4Q003
QHF50XB4Q0:3Ph<2QHF500>6QXJ5QHF5QHD00X61P@03OWinNWYjNWYj009gMgL3MWIf0W]kN`03R8R8
Ti>CTi>C00:ATI400hF5QGinOWinOP02LW9b00=HF5QFEUIFEUH00Y>CT`03`L71Ti>CTi>C009BDU80
0e=CDg5aLG5aL@02O7al00=mOGf0P820P8000X20P003OWinOGemOGem009oOgl00h61PGinOWinOP02
O7al00=mOGenOWinOWh00WalO003OGemQhN7QhN700:;Rh/00gemOF][Jf][J`02IFEU00=[Jf]jNWYj
NWX00X>3P`03MgMgIFEUIFEU009KFe/00f=SHh20P820P002U9BD00=oOgmUIFEUIFD00W5aL@03R8R8
RHV9RHV900>1PH42Q8B40h>3P`:5QHD2QXJ60XB4Q003Ph>3PX:2PX:200:1PH400h20P7moOgmoO`05
Ogmo0ginOPAoOgl3P8200h61P@F0P802Ogmo0X61P@03RXZ:TI6ATI6A00:=SHd00hJ6QXZ:RXZ:RP02
Rh^;00=nOWicLg=cLg<00WemO@03RHV9Ph>3Ph>300Coool00`000?ooooooo`0boooo00@0003ooooo
ooooool2SHf=00>8R8R1PH61PH400X>3P`>7QhL2QHF56XJ6QP:7QhL2R8R80hN7Q`N6QXH2QHF500>3
Ph>4Q8B4Q8@00XJ6QPJ7QhL4RHV900>3Ph=nOWinOWh00X:2PP03S8b<U9BDU9BD00:UYJD00di>CV9R
HV9RHP02_;bl00>WYjMOGemOGel00Y^KV`03WinORXZ:RXZ:00:4Q8@00hF5QHB4Q8B4Q002QXJ60hR8
R0:6QXH00hF5QHJ6QXJ6QP02R8R800>6QXJ5QHF5QHD00XR8R003RXZ:Q8B4Q8B400:1PH400hZ:RYFE
UIFEU@02UYJF00>@T927QhN7QhL00XB4Q003SXj>Ti>CTi>C00:4Q8@00eiNGZ2PX:2PX002MgMg00=m
OGfBTY:BTY800Xb<S003OgmoPH61PH6100:7QhL00hJ6QXB4Q8B4Q002QHF50hN7Q`:6QXH3QhN77XJ6
QP:7QhL2QHF500=nOWijNWYjNWX00WmoO`03QHF5Q8B4Q8B400:4Q8@00hj>SYJFUYJFUP02S8b<00>1
PH66QXJ6QXH01?ooo`030000oooooooo013oool002Goool200000oooo`9jNWX00h61PH^;Rh^;R`02
Rh^;00>8R8R:RXZ:RXX00Xb<S003RXZ:QhN7QhN700:4Q8@00h>3PhB4Q8B4Q002QXJ600>9RHV;Rh^;
Rh/00XZ:RP03R8R8QHF5QHF500:3Ph<5PX:200>3Ph>2PX:2PX800X:2PP03Ph>3Q8B4Q8B400>5QHD2
Q8B40X>3P`:5QHD00hJ6QXF5QHF5Q@02PH6100=nOWijNWYjNWX00WMgM`=fMWH2Ng]k00>8R8RCTi>C
Ti<00Y6AT@03QHF5OWinOWin009bLW800eQHF5IFEUIFEP02Ti>C00?1`L6CTi>CTi<00U9BDP03De=C
LG5aLG5a009lO7`00gemOH20P820P002P82000=nOWimOGemOGd00WmoO`03PH61OWinOWin009lO7`0
0gemOGinOWinOP02O7al00=mOGf7QhN7QhL00X^;R`03OGemJf][Jf][009UIFD00f][JgYjNWYjNP02
Ph>300=gMgMUIFEUIFD00U]KF`03Hf=SP820P82000:DU9@00gmoOfEUIFEUI@02LG5a00>8R8R9RHV9
RHT00h61P@:4Q8@3Ph>30XF5Q@:6QXH2Q8B400>3Ph>2PX:2PX800X61P@03P820OgmoOgmo00EoOgl3
OWin17moO`>0P803PH611H20P09oOgl2PH6100>:RXZATI6ATI400Xf=S@03QXJ6RXZ:RXZ:00:;Rh/0
0ginOW=cLg=cL`02OGem00>9RHV3Ph>3Ph<00oooo`80000doooo00@0003oooooooooool2SHf=00>8
R8R1PH61PH400X>3P`>7QhL2QHF56XJ6QP:7QhL2R8R80hN7Q`N6QXH2QHF500>3Ph>4Q8B4Q8@00XJ6
QPJ7QhL4RHV900>3Ph=nOWinOWh00X:2PP03S8b<U9BDU9BD00:UYJD00di>CV9RHV9RHP02_;bl00>W
YjMOGemOGel00Y^KV`03WinORXZ:RXZ:00:4Q8@00hF5QHB4Q8B4Q002QXJ60hR8R0:6QXH00hF5QHJ6
QXJ6QP02R8R800>6QXJ5QHF5QHD00XR8R003RXZ:Q8B4Q8B400:1PH400hZ:RYFEUIFEU@02UYJF00>@
T927QhN7QhL00XB4Q003SXj>Ti>CTi>C00:4Q8@00eiNGZ2PX:2PX002MgMg00=mOGfBTY:BTY800Xb<
S003OgmoPH61PH6100:7QhL00hJ6QXB4Q8B4Q002QHF50hN7Q`:6QXH3QhN77XJ6QP:7QhL2QHF500=n
OWijNWYjNWX00WmoO`03QHF5Q8B4Q8B400:4Q8@00hj>SYJFUYJFUP02S8b<00>1PH66QXJ6QXH00ooo
o`80000Boooo000Uoooo00<0003oooooool00_ooo`9kNg/00h>3Phb<S8b<S002SXj>0hf=S@:>SXh0
0h^;RhR8R8R8R002QHF500>4Q8B5QHF5QHD00XR8R003Rh^;SHf=SHf=00:=SHd00hZ:RXN7QhN7Q`02
Q8B42X>3P`03Q8B4QXJ6QXJ600>6QXH2QHF50XB4Q0>5QHD2Ph>30X20P003OGemNWYjNWYj009gMgL0
0gEeMG=cLg=cL`02MWIf00>1PH6;Rh^;Rh/00XV9R@03QHF5SXj>SXj>00:ATI400gMgMfYZJVYZJP02
T92@00>d];BIVIVIVIT00Ve]K@03I6ATKfm_Kfm_009kNg/00hF5QHV9RHV9R@02QhN700>4Q8B1PH61
PH400WmoO`03OGemNg]kNg]k009iNGT00g]kNginOWinOP03OGem0XJ6QP:;Rh/00gmoOgAdM7AdM002
NGUi00>1PH5nOWinOWh00WMgM`03MWIfNGUiNGUi009lO7`00h61PHV9RHV9R@02R8R800=gMgMXJ6QX
J6P00W=cL`03Q8B4QHF5QHF500>1PH42Ph>30XB4Q003QHF5QXJ6QXJ600:7QhL2QXJ600>4Q8B2PX:2
PX800X61P@03P820OgmoOgmo00=oOgl7OWin0gmoO`B0P8000h61PH20P820P003P8200WinOP9oOgl0
0hF5QHV9RHV9R@02QhN700>3Ph>4Q8B4Q8@00XF5Q@03PX:2OgmoOgmo00=nOWh2Ng]k1?ooo`030000
oooooooo03;oool010000?ooooooooooo`::RXX00hN7Qh>3Ph>3P`02Q8B40hJ6QP>5QHDIQXJ61HN7
Q`V6QXH5QHF50XJ6QPJ7QhL4RHV900>3Ph=mOGemOGd00X61P@03QhN7QHF5QHF500:<S8`00k2`/<g=
cLg=c@02ATI600>c/k=KFe]KFe/00XN7Q`03U9BDShn?Shn?00:9RHT00hF5QHB4Q8B4Q002QXJ60hN7
Q`F6QXH2QhN700>6QXJ5QHF5QHD00XR8R003RHV9Q8B4Q8B400:1PH400h^;Ri>CTi>CT`02SHf=00>4
Q8B5QHF5QHD00XN7Q`03PH61L71`L71`009FEUH00k2`/8n?Shn?S`02O7al00>2PX:>SXj>SXh00XZ:
RP03PX:2Ph>3Ph>300:7QhL00hJ6QXB4Q8B4Q002QHF51hJ6QP03QhN7QXJ6QXJ601j6QXH2QHF500>0
P81mOGemOGd00X20P003QHF5QXJ6QXJ600F6QXH2QHF500>4Q8B7QhN7QhL01?ooo`030000oooooooo
013oool002Goool00`000?ooooooo`02oooo0W]kN`03Ph>3S8b<S8b<00:>SXh3SHf=0Xj>SP03Rh^;
R8R8R8R800:5QHD00hB4Q8F5QHF5Q@02R8R800>;Rh^=SHf=SHd00Xf=S@03RXZ:QhN7QhN700:4Q8@:
Ph>300>4Q8B6QXJ6QXH00hJ6QP:5QHD2Q8B40hF5Q@:3Ph<2P82000=mOGejNWYjNWX00WMgM`03MGEe
Lg=cLg=c009fMWH00h61PH^;Rh^;R`02RHV900>5QHF>SXj>SXh00Y6AT@03MgMgJVYZJVYZ00:@T900
0kBd]9VIVIVIV@02KFe]00=TI6A_Kfm_Kfl00W]kN`03QHF5RHV9RHV900:7QhL00hB4Q861PH61P@02
Ogmo00=mOGekNg]kNg/00WUiN@03Ng]kOWinOWin00=mOGd2QXJ60X^;R`03OgmoM7AdM7Ad009iNGT0
0h61PGinOWinOP02MgMg00=fMWIiNGUiNGT00WalO003PH61RHV9RHV900:8R8P00gMgMfQXJ6QXJ002
Lg=c00>4Q8B5QHF5QHD00h61P@:3Ph<2Q8B400>5QHF6QXJ6QXH00XN7Q`:6QXH00hB4Q8:2PX:2PP02
PH6100>0P81oOgmoOgl00gmoO`MnOWh3Ogmo1820P003PH61P820P82000>0P802OWin0WmoO`03QHF5
RHV9RHV900:7QhL00h>3PhB4Q8B4Q002QHF500>2PX9oOgmoOgl00ginOP9kNg/4oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0XZ:RP03QhN7Ph>3Ph>300:4Q8@3QXJ60hF5QAV6QXH5QhN72HJ6
QPF5QHD2QXJ61XN7Q`B9RHT00h>3PgemOGemO@02PH6100>7QhN5QHF5QHD00Xb<S003/;2`cLg=cLg=
0096ATH00k>c/e]KFe]KF`02QhN700>DU9B?Shn?Shl00XV9R@03QHF5Q8B4Q8B400:6QXH3QhN71HJ6
QP:7QhL00hJ6QXF5QHF5Q@02R8R800>9RHV4Q8B4Q8@00X61P@03Rh^;Ti>CTi>C00:=SHd00hB4Q8F5
QHF5Q@02QhN700>1PH5`L71`L7000UIFEP03/;2`Shn?Shn?009lO7`00h:2PXj>SXj>SP02RXZ:00>2
PX:3Ph>3Ph<00XN7Q`03QXJ6Q8B4Q8B400:5QHD7QXJ600>7QhN6QXJ6QXH07XJ6QP:5QHD00h20P7em
OGemO@02P82000>5QHF6QXJ6QXH01HJ6QP:5QHD00hB4Q8N7QhN7Q`04oooo00<0003oooooool04?oo
o`009Oooo`030000oooooooo00;oool2Ph>300>4Q8B3Ph>3Ph<00XJ6QP03R8R8RHV9RHV900:7QhL0
0hJ6QXF5QHF5Q@05Ph>30XF5Q@F7QhL00hJ6QXB4Q8B4Q002Ph>31X:2PP:3Ph<8Q8B418>3P`:2PX80
0h61PH20P820P002P82000=oOgmnOWinOWh00WemO@=lO7`5Ng]k0WMgM`03OGemVi^KVi^K00:`/;00
0i^KVginOWinOP02Ph>300>BTY:?Shn?Shl00XJ6QP03Ph>3Q8B4Q8B400:5QHD00hV9RH^;Rh^;R`02
S8b<00>;Rh^6QXJ6QXH00X20P0=kNg/2OWin00=oOgn0P820P8000h61P@AmOGd00hF5QI2@T92@T002
Vi^K00>HV9QjNWYjNWX00VATI003NGUiWIfMWIfM00:ZZZX00j:RXXf=SHf=S@02NGUi00=eMGEkNg]k
Ng/00WalO003OGemOgmoOgmo00:2PX800h61PH20P820P002PH6100>3Ph>5QHF5QHD00XF5Q@:4Q8@0
0h>3Ph:2PX:2PP02PH612X20P003OgmoP820P82000F0P807PH610h20P09nOWh00gYjNWQhN7QhN002
Ng]k00>0P821PH61PH400X20P003PH61P820P820009lO7`00gUiNGinOWinOP04oooo00<0003ooooo
ool0<_ooo`040000oooooooooooo0XB4Q003QHF5R8R8R8R800:7QhL3QXJ60hN7QbN6QXH5QhN71hJ6
QP>5QHD3QXJ60XR8R0:=SHd00hb<S7YjNWYjNP02LW9b00>BTY92@T92@T800/[:bP03EEEEgMgMgMgM
009dM7@00ginOX>3Ph>3P`02QhN70hR8R0:7QhL3QHF50XJ6QP03QhN7QXJ6QXJ600:5QHD00hJ6QXN7
QhN7Q`03QHF50XN7Q`:8R8P00hJ6QX20P820P002N7Qh00=gMgN6QXJ6QXH00XV9R@03IFEU[Jf][Jf]
00:>SXh00h:2PX>3Ph>3P`02RHV900>7QhN3Ph>3Ph<00XF5Q@>8R8P3QXJ618N7QbR6QXH2QhN700>9
RHV;Rh^;Rh/00XV9R@F7QhL00hJ6QXF5QHF5Q@02QhN700>8R8R6QXJ6QXH01?ooo`030000oooooooo
013oool002Goool00`000?ooooooo`02oooo0X>3P`03PH61P820P82000:0P80OPH6118:2PPb1PH45
P82000>1PH62PX:2PX800h:2PP:1PH42Ogmo00=lO7ajNWYjNWX00WYjNP03PH61TI6ATI6A00:GUiL0
0ginOV][Jf][J`02QhN700>UYJF@T92@T9000W9bLP03NWYjShn?Shn?00:BTY800i2@T96ATI6AT@02
TI6A00>;Rh^4Q8B4Q8@00WmoO`03OGemOWinOWin00:0P8000hB4Q8F5QHF5Q@02Ph>300=oOgmhN7Qh
N7P00WMgM`03Q8B4T92@T92@00:<S8`00g]kNfEUIFEUI@02GemO00>1PH6UYJFUYJD00Z6QX@03Rh^;
PH61PH61009nOWh00gmoOh61PH61P@02PH6100=oOgn0P820P8000X:2PP03PH61P820P82000:0P803
PH6118:2PR61PH42P82000=mOGekNg]kNg/00WemO@F0P8000h61PH:2PX:2PP02P82000=nOWj0P820
P8001?ooo`030000oooooooo03;oool010000?ooooooooooo`:4Q8@00hJ6QXN7QhN7Q`02QhN7;hJ6
QP>7QhL8QXJ60XF5Q@:6QXH00hN7QhV9RHV9R@02RXZ:00>8R8R1PH61PH400XF5Q@03Z:RXCdm?Cdm?
00;3`l<00d92@V9RHV9RHP02QXJ600>9RHUoOgmoOgl00X61P@03QhN7QXJ6QXJ600:5QHD00hN7QhR8
R8R8R002QhN72XJ6QP03QHF5QhN7QhN700:8R8P00h>3Ph:2PX:2PP02RHV900>ATI6BTY:BTY800W]k
N`03^k^kQ8B4Q8B4009gMgL00h61PHN7QhN7Q`02R8R800>7QhN4Q8B4Q8@00XF5Q@>7QhL3QXJ60XN7
QbZ6QXH2QhN700>9RHV;Rh^;Rh/00XV9R@>6QXH2QhN700>6QXJ5QHF5QHD00XJ6QP03R8R8QXJ6QXJ6
00Coool00`000?ooooooo`0@oooo000Uoooo00<0003oooooool00_ooo`:3Ph<00h61PH20P820P002
P8207h61P@B2PX8<PH611H20P003PH61PX:2PX:200>2PX82PH610WmoO`03O7alNWYjNWYj009jNWX0
0h61PI6ATI6AT@02UiNG00=nOWi[Jf][Jf/00XN7Q`03YJFUT92@T92@009bLW800gYjNXn?Shn?S`02
TY:B00>@T92ATI6ATI400Y6AT@03Rh^;Q8B4Q8B4009oOgl00gemOGinOWinOP02P82000>4Q8B5QHF5
QHD00X>3P`03OgmoN7QhN7Qh009gMgL00hB4Q92@T92@T002S8b<00=kNg]UIFEUIFD00UmOG`03PH61
YJFUYJFU00:QXJ400h^;Rh61PH61P@02OWin00=oOgn1PH61PH400X61P@03OgmoP820P82000:2PX80
0h61PH20P820P002P8200h61P@B2PX8QPH610X20P003OGemNg]kNg]k009mOGd5P82000>1PH62PX:2
PX800X20P003OWinP820P82000Coool00`000?ooooooo`0boooo00@0003oooooooooool2Q8B400>6
QXJ7QhN7QhL00XN7Qbn6QXH3QhN728J6QP:5QHD2QXJ600>7QhN9RHV9RHT00XZ:RP03R8R8PH61PH61
00:5QHD00jRXZ4m?Cdm?C`02`l?300=2@T9RHV9RHV800XJ6QP03RHV9OgmoOgmo00:1PH400hN7QhJ6
QXJ6QP02QHF500>7QhN8R8R8R8P00XN7Q`Z6QXH00hF5QHN7QhN7Q`02R8R800>3Ph>2PX:2PX800XV9
R@03TI6ATY:BTY:B009kNg/00k^k^hB4Q8B4Q002MgMg00>1PH67QhN7QhL00XR8R003QhN7Q8B4Q8B4
00:5QHD3QhN70hJ6QP:7QhLZQXJ60XN7Q`03RHV9Rh^;Rh^;00:9RHT3QXJ60XN7Q`03QXJ6QHF5QHF5
00:6QXH00hR8R8J6QXJ6QP04oooo00<0003oooooool04?ooo`009Oooo`030000oooooooo00;oool2
P8200gmoO`9mOGd3O7al0gemO@9nOWh2Ogmo00>0P81oOgmoOgl00WinOP03OGemO7alO7al009mOGd0
0ginOWmoOgmoO`03P8201861P@F0P805Ogmo2X20P0:1PH400h:2PXB4Q8B4Q003QXJ60XF5Q@:3Ph<3
P8200XB4Q003QHF5OgmoOgmo009bLW800eaLG5]KFe]KF`02S8b<00>a/K69RHV9RHT00UQHF003JVYZ
TY:BTY:B00:GUiL3SXj>0Xf=S@03QXJ6PH61PH6100:0P803PX:20X>3P`03QXJ6QhN7QhN700:3Ph<0
0ginOWQhN7QhN002N7Qh00>1PH64Q8B4Q8@00WAdM003HF5QGEeMGEeM009ZJVX00hN7QiRHV9RHV002
PH6100=VIVIcLg=cLg<00h^;R`B2PX800h>3Ph:2PX:2PP05PH610X20P0EoOgl5P8200h61P@n2PX8:
PH6118:2PP03Q8B4QHF5QHF500:3Ph<00h61PH20P820P003PH610X:2PP:4Q8@00hF5QH>3Ph>3P`04
oooo00<0003oooooool0<_ooo`040000oooooooooooo0XN7Q`03QXJ6QHF5QHF50426QXH00hN7QhF5
QHF5Q@03PX:20Xb<S0:OWil00dE5AEMGEeMGE`02^[Zj00>][JeUIFEUIFD00YbLW003VIVIP820P820
009oOgl00hR8R8N7QhN7Q`02QHF500>8R8R9RHV9RHT00XN7Q`>5QHD2QhN72XJ6QP03Q8B4R8R8R8R8
00:HV9P00ijNWXV9RHV9R@02GEeM00>LW9adM7AdM7@00WalO003TY:BSXj>SXj>00:1PH400h>3PhV9
RHV9R@02R8R80hF5QC66QXH00hF5QHB4Q8B4Q002QHF52XJ6QP03QHF5QXJ6QXJ600Coool00`000?oo
ooooo`0@oooo000Joooo0P0000Coool00`000?ooooooo`02oooo00<0003oooooool00_ooo`:0P803
Ogmo0WemO@=lO7`3OGem0WinOP9oOgl00h20P7moOgmoO`02OWin00=mOGelO7alO7`00WemO@03OWin
OgmoOgmo00>0P804PH611H20P0EoOgl:P8200X61P@03PX:2Q8B4Q8B400>6QXH2QHF50X>3P`>0P802
Q8B400>5QHEoOgmoOgl00W9bLP03G5aLFe]KFe]K00:<S8`00k6a/HV9RHV9R@02F5QH00=ZJVZBTY:B
TY800YNGU`>>SXh2SHf=00>6QXJ1PH61PH400X20P0>2PX82Ph>300>6QXJ7QhN7QhL00X>3P`03OWin
N7QhN7Qh009hN7P00h61PHB4Q8B4Q002M7Ad00=QHF5MGEeMGEd00VYZJP03QhN7V9RHV9RH00:1PH40
0fIVIW=cLg=cL`03Rh^;18:2PP03Ph>3PX:2PX:200F1PH42P8201GmoO`F0P803PH613h:2PPZ1PH44
PX:200>4Q8B5QHF5QHD00X>3P`03PH61P820P82000>1PH42PX:20XB4Q003QHF5Ph>3Ph>300Coool0
0`000?ooooooo`0Voooo0P0000Coool00`000?ooooooo`03oooo00@0003oooooooooool2QhN700>6
QXJ5QHF5QHD0@8J6QP03QhN7QHF5QHF500>2PX82S8b<0YnOW`03ADE5EeMGEeMG00:j^[X00jf][FEU
IFEUI@02W9bL00>IVIV0P820P8000WmoO`03R8R8QhN7QhN700:5QHD00hR8R8V9RHV9R@02QhN70hF5
Q@:7QhL:QXJ600>4Q8B8R8R8R8P00YRHV003WYjNRHV9RHV9009MGEd00ibLW7AdM7AdM002O7al00>B
TY:>SXj>SXh00X61P@03Ph>3RHV9RHV900:8R8P3QHF5<HJ6QP03QHF5Q8B4Q8B400:5QHD:QXJ600>5
QHF6QXJ6QXH01?ooo`030000oooooooo013oool001[oool00`000?ooo`000002oooo00<0003oool0
00000oooo`030000oooooooo00;oool2PH6100=oOgmnOWinOWh00WemO@ElO7`00gemOGinOWinOP02
Ogmo00>0P81oOgmoOgl00WinOP03OGemO7alO7al009lO7`00gemOGinOWinOP0:P82027moO`N0P804
PH6100>3Ph>4Q8B4Q8@00XF5Q@>6QXH2QHF500>4Q8B2PX:2PX800X:2PP03PH61NWYjNWYj009eMGD0
0gMgMg]kNg]kN`02OWin00=jNWY[Jf][Jf/00VATI003N7QhShn?Shn?00:>SXh00h61PGalO7alO002
O7al00=oOgn3Ph>3Ph<00hF5Q@:6QXH2QHF500>4Q8B2PX:2PX800X:2PP03PH61OgmoOgmo009mOGd0
0ginOWmoOgmoO`02P82000>1PH64Q8B4Q8@00XF5Q@03QXJ6P820P820009`L7000fMWIgIfMWIfMP02
RXZ:00><S8b6QXJ6QXH00XB4Q003Ph>3PH61PH6100F1PH42P8201gmoO`>0P803PH614H:2PPR1PH44
PX:20hB4Q0:3Ph<00h61PH20P820P003PH610X:2PP:4Q8@00hF5QHB4Q8B4Q004oooo00<0003ooooo
ool09_ooo`030000oooo000000;oool00`000?ooo`000004oooo00@0003oooooooooool2QhN7AXJ6
QP>3Ph<2RXZ:0YBDU003WinO[Jf][Jf]00:n_[h00eaLG7alO7alO002TY:B00>>SXj3Ph>3Ph<00XF5
Q@03S8b<Rh^;Rh^;00:6QXH3Ph>30XB4Q0>7QhL:QXJ60hN7Q`:4Q8@2OWin00=_KfmCDe=CDe<00Z^[
Z`03S8b<Ng]kNg]k00:1PH400hf=SH^;Rh^;R`02Ph>300>4Q8B8R8R8R8P00XN7Q`03QHF5QXJ6QXJ6
0366QXH5QHF51XJ6QP:7QhL5QXJ61?ooo`030000oooooooo013oool001[oool00`000?ooo`000002
oooo00<0003oool000000oooo`<00002oooo0X:2PP03PH61OgmoOgmo00=oOgl4OWin00=oOgn0P820
P8001h20P003OgmoOWinOWin00=oOgl4P8201H61P@n