(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    305187,       5797]
NotebookOptionsPosition[    300830,       5642]
NotebookOutlinePosition[    301186,       5658]
CellTagsIndexPosition[    301143,       5655]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\:591a\:9762\:4f53\:3092\:63cf\:304f", "Title",
 CellChangeTimes->{{3.4994693901603804`*^9, 3.4994694041004*^9}},
 TextAlignment->Center,
 ImageRegion->{{0, 1}, {0, 1}},
 FontWeight->"Plain",
 Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["polygon", "Section",
 CellChangeTimes->{{3.499469455080471*^9, 3.4994694577804747`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4994695859206543`*^9, 3.4994695866306553`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Show[Graphics3D[Polygon[{{8,2,5},
                {4,-2,5},{3,3,8}}]],Axes->True]\
\>", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994694896405196`*^9, 3.499469568900631*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
 Graphics3DBox[Polygon3DBox[{{8, 2, 5}, {4, -2, 5}, {3, 3, 8}}],
  AutomaticImageSize->True,
  Axes->True,
  ImageSize->{359.19026746595864`, 248.47200638109317`},
  ViewPoint->{1.3000000000000005`, -2.4, 2.0000000000000004`},
  ViewVertical->{-0.04849666376537991, -0.02756663897762979, 
   4.992214323371708}]], "Output",
 CellChangeTimes->{
  3.4994694802305064`*^9, {3.499469512720552*^9, 3.499469524830569*^9}, {
   3.4994695559806128`*^9, 3.4994695711606336`*^9}}]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{3.499469600700675*^9},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Module[{p1,p2,p3,poly},
              p1={{0,0,0},{3,0,0},{0,3,0}};
              p2={{0,0,0},{3,0,0},{2,2,4}};
              p3={{0,0,0},{0,3,0},{2,2,4}};
              p4={{0,3,0},{3,0,0},{2,2,4}};
            poly=Map[Polygon,{p1,p2,p3,p4}];
          Show[Graphics3D[poly],
                  Axes->True,ViewPoint->{1.2,0.8,4}]]\
\>", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994696643507643`*^9, 3.499469814340974*^9}, {
  3.49946984736102*^9, 3.4994698838910713`*^9}, {3.4994699272611322`*^9, 
  3.4994700166712575`*^9}, {3.4994700800813465`*^9, 3.4994701344014225`*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[{Polygon3DBox[{{0, 0, 0}, {3, 0, 0}, {0, 3, 0}}], 
   Polygon3DBox[{{0, 0, 0}, {3, 0, 0}, {2, 2, 4}}], 
   Polygon3DBox[{{0, 0, 0}, {0, 3, 0}, {2, 2, 4}}], 
   Polygon3DBox[{{0, 3, 0}, {3, 0, 0}, {2, 2, 4}}]},
  AutomaticImageSize->True,
  Axes->True,
  ImageSize->{390.0677623976293, 439.42449822211046`},
  ViewPoint->{1.2, 0.8, 4},
  ViewVertical->{-0.6598345813866031, -0.1530475830784425, 
   0.861348973365395}]], "Output",
 CellChangeTimes->{
  3.499469650850745*^9, {3.4994698252809896`*^9, 3.4994698520510273`*^9}, 
   3.4994698863710747`*^9, {3.499469950801165*^9, 3.4994700190712605`*^9}, {
   3.4994700842113523`*^9, 3.4994701368114257`*^9}}]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.49947016122146*^9, 3.4994701628214617`*^9}},
 ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
Module[{m1,m2,m3,m4,m5,m6,m7,m8},
             m1={{0,0,0},{4,0,0},{2,2,2Sqrt[2]}};
             m2={{4,0,0},{4,4,0},{2,2,2Sqrt[2]}};
             m3={{4,4,0},{0,4,0},{2,2,2Sqrt[2]}};
             m4={{0,4,0},{0,0,0},{2,2,2Sqrt[2]}};
             m5={{0,0,0},{4,0,0},{2,2,-2Sqrt[2]}};
             m6={{4,0,0},{4,4,0},{2,2,-2Sqrt[2]}};
             m7={{4,4,0},{0,4,0},{2,2,-2Sqrt[2]}};
             m8={{0,4,0},{0,0,0},{2,2,-2Sqrt[2]}};
       men8=Map[Polygon,{m1,m2,m3,m4,m5,m6,m7,m8}];
    Show[Graphics3D[men8],Boxed->False,
                         ViewPoint->{1,1,0.3}]]\
\>", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994768533281736`*^9, 3.499476908578251*^9}, {
  3.499476940078295*^9, 3.499476958888322*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[
    NCache[{{0, 0, 0}, {4, 0, 0}, {2, 2, 2 2^Rational[1, 2]}}, {{0, 0, 0}, {4,
       0, 0}, {2, 2, 2.8284271247461903`}}]], 
   Polygon3DBox[
    NCache[{{4, 0, 0}, {4, 4, 0}, {2, 2, 2 2^Rational[1, 2]}}, {{4, 0, 0}, {4,
       4, 0}, {2, 2, 2.8284271247461903`}}]], 
   Polygon3DBox[
    NCache[{{4, 4, 0}, {0, 4, 0}, {2, 2, 2 2^Rational[1, 2]}}, {{4, 4, 0}, {0,
       4, 0}, {2, 2, 2.8284271247461903`}}]], 
   Polygon3DBox[
    NCache[{{0, 4, 0}, {0, 0, 0}, {2, 2, 2 2^Rational[1, 2]}}, {{0, 4, 0}, {0,
       0, 0}, {2, 2, 2.8284271247461903`}}]], 
   Polygon3DBox[
    NCache[{{0, 0, 0}, {4, 0, 0}, {2, 2, (-2) 2^Rational[1, 2]}}, {{0, 0, 
      0}, {4, 0, 0}, {2, 2, -2.8284271247461903`}}]], 
   Polygon3DBox[
    NCache[{{4, 0, 0}, {4, 4, 0}, {2, 2, (-2) 2^Rational[1, 2]}}, {{4, 0, 
      0}, {4, 4, 0}, {2, 2, -2.8284271247461903`}}]], 
   Polygon3DBox[
    NCache[{{4, 4, 0}, {0, 4, 0}, {2, 2, (-2) 2^Rational[1, 2]}}, {{4, 4, 
      0}, {0, 4, 0}, {2, 2, -2.8284271247461903`}}]], 
   Polygon3DBox[
    NCache[{{0, 4, 0}, {0, 0, 0}, {2, 2, (-2) 2^Rational[1, 2]}}, {{0, 4, 
      0}, {0, 0, 0}, {2, 2, -2.8284271247461903`}}]]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{437.8096230884189, 399.1726896411319},
  ViewPoint->{1.279921809158408, -0.6443393766036303, 0.1913816349567361},
  ViewVertical->{-1.1600873727248695`, -0.4687643795924285, 
   0.4660779141246857}]], "Output",
 CellChangeTimes->{3.4994701516614466`*^9, 3.4994769116482553`*^9, 
  3.499476962328326*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Regular Polyhedron", "Section",
 CellChangeTimes->{{3.49947023986157*^9, 3.4994702445015764`*^9}, {
  3.499475032165614*^9, 3.4994750330356154`*^9}, {3.4994751875058317`*^9, 
  3.499475189965835*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4994706968922095`*^9, 3.4994706974522104`*^9}}],

Cell[CellGroupData[{

Cell["4", "Subsection",
 CellChangeTimes->{{3.499470300761655*^9, 3.499470303571659*^9}, {
  3.499470372161755*^9, 3.499470372811756*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontWeight->"Plain",
 Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["PolyhedronData[\"Tetrahedron\"]", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994704160018167`*^9, 3.499470422661826*^9}, {
  3.4994705051619415`*^9, 3.499470526991972*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
      Rational[-1, 2] 6^Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
     0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
     0.5773502691896258, 0, -0.20412414523193154`}}], 
   Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]],
  AutomaticImageSize->True,
  ImageSize->{327.7822267015459, 393.4880779075121},
  ViewPoint->{-0.049667111089781724`, -2.8321384571216295`, 
   1.8510875013809343`},
  ViewVertical->{-0.2981150135775267, -0.07196449798179305, 
   1.1799364538228203`}]], "Output",
 CellChangeTimes->{3.499470426381831*^9, 3.4994705278019733`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6", "Subsection",
 CellChangeTimes->{{3.499470300761655*^9, 3.499470303571659*^9}, {
  3.4994703769717617`*^9, 3.4994703783417635`*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontWeight->"Plain",
 Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["PolyhedronData[\"Hexahedron\"]", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994705592720175`*^9, 3.499470628362114*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[
      1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
    0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 
    0.5, -0.5}, {0.5, 0.5, 0.5}}], 
   Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {1, 
    3, 7, 5}, {2, 1, 5, 6}}]]]], "Output",
 CellChangeTimes->{{3.4994706160120964`*^9, 3.499470630582117*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["8", "Subsection",
 CellChangeTimes->{{3.499470300761655*^9, 3.499470303571659*^9}, {
  3.499470381281768*^9, 3.499470383381771*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontWeight->"Plain",
 Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["PolyhedronData[\"Octahedron\"]", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994705668420277`*^9, 3.4994705888320584`*^9}, {
  3.499470645752138*^9, 3.499470648502142*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
     0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
     0, -2^Rational[-1, 2], 0}, {
     2^Rational[-1, 2], 0, 0}}, {{-0.7071067811865475, 0, 0}, {
     0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
     0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
     0.7071067811865475, 0, 0}}], 
   Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 3}, {5, 3,
     6}, {3, 1, 2}, {6, 3, 2}}]]]], "Output",
 CellChangeTimes->{3.499470650442145*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["12", "Subsection",
 CellChangeTimes->{{3.499470300761655*^9, 3.499470303571659*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontWeight->"Plain",
 Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["PolyhedronData[\"Dodecahedron\"]", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994705725120354`*^9, 3.4994705939920654`*^9}, {
  3.4994706565921535`*^9, 3.499470659372157*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116068`}, \
{-0.6881909602355868, 0.5, -1.1135163644116068`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
     0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
   Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
    11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17, 
    13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 7, 
    16, 1, 14}, {16, 8, 4, 15, 1}}]]]], "Output",
 CellChangeTimes->{3.49947066131216*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["20", "Subsection",
 CellChangeTimes->{{3.4994703062916627`*^9, 3.4994703086816664`*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontWeight->"Plain",
 Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell["PolyhedronData[\"Icosahedron\"]", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994705793420453`*^9, 3.499470599002073*^9}, {
  3.4994706751521792`*^9, 3.4994706780721836`*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
     0, 0, 5 (50 - 10 5^Rational[1, 2])^
       Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
      0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
       Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
      Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), 
      Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), Rational[
      1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
      Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
       5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
      Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
     Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
       5^Rational[1, 2]), 
      Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
       Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
     0, 0, -0.9510565162951536}, {
     0, 0, 0.9510565162951536}, {-0.85065080835204, 
      0, -0.42532540417601994`}, {
     0.85065080835204, 0, 0.42532540417601994`}, {
     0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
     0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
     0.42532540417601994`}, {-0.6881909602355868, 0.5, 
     0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
     0.8090169943749475, -0.42532540417601994`}, {
     0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
     0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
   Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
    5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
    3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12,
     6}, {3, 8, 10}, {9, 7, 3}}]]]], "Output",
 CellChangeTimes->{3.499470679792186*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.499470790702341*^9, 3.4994708162923765`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", " ", "\"\<VertexCoordinates\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4994707623423014`*^9, 3.4994707653223057`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["5", 
       SqrtBox[
        RowBox[{"50", "-", 
         RowBox[{"10", " ", 
          SqrtBox["5"]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["5", 
      SqrtBox[
       RowBox[{"50", "-", 
        RowBox[{"10", " ", 
         SqrtBox["5"]}]}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       FractionBox["2", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}]]]}], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox[
      FractionBox["2", 
       RowBox[{"5", "-", 
        SqrtBox["5"]}]]], ",", "0", ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"10", "-", 
        RowBox[{"2", " ", 
         SqrtBox["5"]}]}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       SqrtBox["5"]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]}]], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       SqrtBox["5"]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]}]], ",", 
     FractionBox["1", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", 
        SqrtBox["5"]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"10", "-", 
          RowBox[{"2", " ", 
           SqrtBox["5"]}]}]]}]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"10", "-", 
        RowBox[{"2", " ", 
         SqrtBox["5"]}]}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"1", "+", 
        SqrtBox["5"]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"10", "-", 
          RowBox[{"2", " ", 
           SqrtBox["5"]}]}]]}]]}], ",", 
     FractionBox["1", "2"], ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"10", "-", 
        RowBox[{"2", " ", 
         SqrtBox["5"]}]}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"10", "-", 
          RowBox[{"2", " ", 
           SqrtBox["5"]}]}]]}]]}], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"5", "+", 
         SqrtBox["5"]}], 
        RowBox[{"5", "-", 
         SqrtBox["5"]}]]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"10", "-", 
          RowBox[{"2", " ", 
           SqrtBox["5"]}]}]]}]]}], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"5", "+", 
         SqrtBox["5"]}], 
        RowBox[{"5", "-", 
         SqrtBox["5"]}]]]}], ",", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]}]], ",", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"5", "+", 
         SqrtBox["5"]}], 
        RowBox[{"5", "-", 
         SqrtBox["5"]}]]]}], ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"10", "-", 
        RowBox[{"2", " ", 
         SqrtBox["5"]}]}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"]}], 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"10", "-", 
         RowBox[{"2", " ", 
          SqrtBox["5"]}]}]]}]], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"5", "+", 
         SqrtBox["5"]}], 
        RowBox[{"5", "-", 
         SqrtBox["5"]}]]]}], ",", 
     FractionBox["1", 
      SqrtBox[
       RowBox[{"10", "-", 
        RowBox[{"2", " ", 
         SqrtBox["5"]}]}]]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.4994707748923187`*^9, 3.499475697036545*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  RowBox[{"\"\<Icosahedron\>\"", ",", " ", "\"\<NetImage\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4994757179565744`*^9, 3.4994757243465834`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[RGBColor[1, 1, 0.85]], 
   GraphicsComplexBox[
    NCache[{{1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[3, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[5, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[7, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[9, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      Rational[11, 2], Rational[1, 2] 3^Rational[1, 2]}, {
      0, 3^Rational[1, 2]}, {1, 3^Rational[1, 2]}, {2, 3^Rational[1, 2]}, {
      3, 3^Rational[1, 2]}, {4, 3^Rational[1, 2]}, {5, 3^Rational[1, 2]}, {
      Rational[1, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[3, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[5, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[7, 2], Rational[3, 2] 3^Rational[1, 2]}, {
      Rational[9, 2], Rational[3, 2] 3^Rational[1, 2]}}, {{1, 0}, {2, 0}, {3, 
      0}, {4, 0}, {5, 0}, {0.5, 0.8660254037844386}, {1.5, 
      0.8660254037844386}, {2.5, 0.8660254037844386}, {3.5, 
      0.8660254037844386}, {4.5, 0.8660254037844386}, {5.5, 
      0.8660254037844386}, {0, 1.7320508075688772`}, {
      1, 1.7320508075688772`}, {2, 1.7320508075688772`}, {
      3, 1.7320508075688772`}, {4, 1.7320508075688772`}, {
      5, 1.7320508075688772`}, {0.5, 2.598076211353316}, {1.5, 
      2.598076211353316}, {2.5, 2.598076211353316}, {3.5, 
      2.598076211353316}, {4.5, 2.598076211353316}}], 
    PolygonBox[{{7, 6, 1}, {13, 12, 6}, {8, 7, 2}, {14, 13, 7}, {9, 8, 3}, {
     15, 14, 8}, {10, 9, 4}, {16, 15, 9}, {11, 10, 5}, {17, 16, 10}, {6, 7, 
     13}, {12, 13, 18}, {7, 8, 14}, {13, 14, 19}, {8, 9, 15}, {14, 15, 20}, {
     9, 10, 16}, {15, 16, 21}, {10, 11, 17}, {16, 17, 22}}]]}]], "Output",
 CellChangeTimes->{3.499475726246586*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Semi-Regular-Polyhedron", "Section",
 CellChangeTimes->{{3.4994708987824926`*^9, 3.499470933612541*^9}, {
  3.499472394934587*^9, 3.4994723962345886`*^9}, {3.4994750358556194`*^9, 
  3.49947503663562*^9}, {3.499475195995844*^9, 3.4994751985258474`*^9}, {
  3.499475603536414*^9, 3.499475610506424*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4994755762263756`*^9, 3.4994755766163764`*^9}}],

Cell[BoxData[{
 RowBox[{"\:4e00\:69d8\:591a\:9762\:4f53\:306e\:6761\:4ef6\:306f\:3001\:5168\
\:3066\:306e\:9762\:304c\:6b63\:591a\:89d2\:5f62\:3067\:3001\:9802\:70b9\:5f62\
\:72b6\:304c\:5408\:540c", 
  RowBox[{
  "\:ff08", 
   "\:9802\:70b9\:306b\:96c6\:307e\:308b\:6b63\:591a\:89d2\:5f62\:306e\:7a2e\
\:985e\:3068\:9806\:5e8f\:304c\:540c\:3058", 
   "\:ff09"}]}], "\[IndentingNewLine]", "\:306a\:3053\:3068\:3067\:3042\:308b\
\:3002\:6b63\:591a\:9762\:4f53\:306f\:9664\:5916\:3059\:308b\:306e\:3067\:3001\
\:534a\:6b63\:591a\:9762\:4f53\:306e\:9762\:306f2\:7a2e\:985e\:4ee5\:4e0a\
\:306e\:6b63\:591a\:89d2\:5f62\:3067\:69cb\:6210\:3055\:308c\:308b\:3002", "\n\
", 
 RowBox[{"\:6e96\:6b63\:591a\:9762\:4f53", " ", 
  RowBox[{"(", 
   RowBox[{"quasi", "-", 
    RowBox[{"regular", " ", "polyhedron"}]}], ")"}], " ", 
  "\:3068\:306f\:3001\:3053\:306e\:3046\:3061\:8fba\:306e\:8fd1\:508d\:304c\
\:5408\:540c\:306a\:3082\:306e\:3067\:3001"}], "\[IndentingNewLine]", "\:7acb\
\:65b9\:516b\:9762\:4f53\:3068\:4e8c\:5341\:30fb\:5341\:4e8c\:9762\:4f53\:304c\
\:5f53\:3066\:306f\:307e\:308b\:3002", "\n"}], "Input",
 CellChangeTimes->{{3.4994755853063884`*^9, 3.4994755959564037`*^9}}],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<PolyhedronOperations`\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell["Truncate[PolyhedronData[\"Tetrahedron\",\"Image\"]]", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994710046826406`*^9, 3.4994710187726603`*^9}, {
  3.4994711107627892`*^9, 3.499471129322815*^9}, {3.4994711851228933`*^9, 
  3.4994712196229415`*^9}, {3.4994712630230026`*^9, 3.4994712660930066`*^9}, {
  3.4994713716931543`*^9, 3.4994713750131593`*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
      Rational[-1, 2] 6^Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}, {
     Rational[-7, 20] 3^Rational[-1, 2] + Rational[-1, 20] 3^Rational[1, 2], 
      Rational[-1, 5], Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[-7, 20] 6^Rational[-1, 2]}, {
     Rational[-7, 20] 3^Rational[-1, 2] + Rational[-1, 20] 3^Rational[1, 2], 
      Rational[1, 5], Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[-7, 20] 6^Rational[-1, 2]}, {
     Rational[-7, 20] 3^Rational[-1, 2] + Rational[1, 10] 3^Rational[1, 2], 
      Rational[7, 20], Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[-7, 20] 6^Rational[-1, 2]}, {
     Rational[7, 10] 3^Rational[-1, 2] + Rational[-1, 20] 3^Rational[1, 2], 
      Rational[3, 20], Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[-7, 20] 6^Rational[-1, 2]}, {
     Rational[7, 10] 3^Rational[-1, 2] + Rational[-1, 20] 3^Rational[1, 2], 
      Rational[-3, 20], Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[-7, 20] 6^Rational[-1, 2]}, {
     Rational[-7, 20] 3^Rational[-1, 2] + Rational[1, 10] 3^Rational[1, 2], 
      Rational[-7, 20], Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[-7, 20] 6^Rational[-1, 2]}, {
     Rational[-7, 20] 3^Rational[-1, 2], Rational[-7, 20], 
      Rational[-7, 20] 6^Rational[-1, 2] + 
      Rational[3, 10] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}, {
     Rational[-1, 20] 3^Rational[1, 2], Rational[-3, 20], 
      Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[7, 10] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}, {
     Rational[-1, 20] 3^Rational[1, 2], Rational[3, 20], 
      Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[7, 10] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}, {
     Rational[-7, 20] 3^Rational[-1, 2], Rational[7, 20], 
      Rational[-7, 20] 6^Rational[-1, 2] + 
      Rational[3, 10] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}, {
     Rational[7, 10] 3^Rational[-1, 2], 0, Rational[-7, 20] 6^Rational[-1, 2] + 
      Rational[3, 10] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}, {
     Rational[1, 10] 3^Rational[1, 2], 0, 
      Rational[-1, 20] Rational[3, 2]^Rational[1, 2] + 
      Rational[7, 10] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}}, {{
     0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
     0.5773502691896258, 
      0, -0.20412414523193154`}, {-0.28867513459481287`, -0.2, \
-0.2041241452319315}, {-0.28867513459481287`, 
     0.2, -0.2041241452319315}, {-0.028867513459481298`, 
     0.35, -0.2041241452319315}, {0.3175426480542942, 
     0.15, -0.2041241452319315}, {
     0.3175426480542942, -0.15, -0.2041241452319315}, \
{-0.028867513459481298`, -0.35, -0.2041241452319315}, {-0.20207259421636903`, \
-0.35, 0.04082482904638626}, {-0.08660254037844387, -0.15, 
     0.36742346141747667`}, {-0.08660254037844387, 0.15, 
     0.36742346141747667`}, {-0.20207259421636903`, 0.35, 
     0.04082482904638626}, {0.40414518843273806`, 0, 0.04082482904638626}, {
     0.17320508075688773`, 0, 0.36742346141747667`}}], {
    Polygon3DBox[{{5, 6, 7, 8, 9, 10}, {6, 5, 11, 12, 13, 14}, {15, 16, 12, 
     11, 10, 9}, {16, 15, 8, 7, 14, 13}}], 
    Polygon3DBox[{{16, 13, 12}, {11, 5, 10}, {14, 7, 6}, {15, 9, 8}}]}],
  AutomaticImageSize->True,
  ImageSize->{334.580565665019, 399.1258183391143},
  ViewPoint->{-1.9855058186864434`, -2.4673018779454288`, 1.191716445740863},
  ViewVertical->{-0.8841774252325948, 0.12005347412158607`, 
   0.5741584208137491}]], "Output",
 CellChangeTimes->{
  3.4994711299228163`*^9, {3.4994711880528975`*^9, 3.4994712214729443`*^9}, 
   3.499471268013009*^9, 3.4994712984830523`*^9, {3.499471351323126*^9, 
   3.4994713759131603`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Tetrahedron\>\"", ",", "\"\<Image\>\""}], "]"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.499471492103323*^9, 3.499471494343326*^9}, {
  3.4994716089534864`*^9, 3.499471628033513*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
      Rational[-1, 2] 6^Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}, {
     Rational[-1, 2] 3^Rational[-1, 2], 0, Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     Rational[1, 4] 3^Rational[-1, 2], Rational[1, 4], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     Rational[1, 4] 3^Rational[-1, 2], Rational[-1, 4], Rational[-1, 2] 
      6^Rational[-1, 2]}, {
     Rational[-1, 4] 3^Rational[-1, 2], Rational[-1, 4], 
      Rational[1, 2] (Rational[2, 3]^Rational[1, 2] - 6^Rational[-1, 2])}, {
     Rational[-1, 4] 3^Rational[-1, 2], Rational[1, 4], 
      Rational[1, 2] (Rational[2, 3]^Rational[1, 2] - 6^Rational[-1, 2])}, {
     Rational[1, 2] 3^Rational[-1, 2], 0, 
      Rational[1, 2] (Rational[2, 3]^Rational[1, 2] - 6^Rational[-1, 2])}, {
     Rational[1, 2] 3^Rational[-1, 2], 0, Rational[-1, 4] 6^Rational[-1, 2] + 
      Rational[1, 2] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}, {
     Rational[-1, 4] 3^Rational[-1, 2], Rational[1, 4], 
      Rational[-1, 4] 6^Rational[-1, 2] + 
      Rational[1, 2] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}, {
     Rational[-1, 4] 3^Rational[-1, 2], Rational[-1, 4], 
      Rational[-1, 4] 6^Rational[-1, 2] + 
      Rational[1, 2] (Rational[2, 3]^Rational[1, 2] + 
        Rational[-1, 2] 6^Rational[-1, 2])}}, {{
     0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
     0.5773502691896258, 0, -0.20412414523193154`}, {-0.2886751345948129, 
      0, -0.20412414523193154`}, {0.14433756729740646`, 
     0.25, -0.20412414523193154`}, {
     0.14433756729740646`, -0.25, -0.20412414523193154`}, \
{-0.14433756729740646`, -0.25, 0.20412414523193148`}, {-0.14433756729740646`, 
     0.25, 0.20412414523193148`}, {
     0.2886751345948129, 0, 0.20412414523193148`}, {
     0.2886751345948129, 0, 0.20412414523193145`}, {-0.14433756729740646`, 
     0.25, 0.20412414523193145`}, {-0.14433756729740646`, -0.25, 
     0.20412414523193145`}}], {
    Polygon3DBox[{{5, 6, 7}, {5, 8, 9}, {10, 8, 7}, {10, 6, 9}}], 
    Polygon3DBox[{{11, 12, 13}, {13, 5, 7}, {12, 6, 5}, {11, 7, 
     6}}]}]]], "Output",
 CellChangeTimes->{
  3.499471496233329*^9, {3.499471619543502*^9, 3.4994716299235163`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Icosidodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 0}, {
     0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
      0}, {(Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[-1, 2], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[1, 2], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2],
       0, Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {(1 + 
       2 5^Rational[-1, 2])^Rational[1, 2], 
      0, (Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
      Rational[1, 2], Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 
      0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
      0}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      0, -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2],
       0}, {Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 2], 0}, {
     Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2], 
      0}, {Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 2], 0}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[7, 40] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[3, 40] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[3, 40] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[7, 40] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[-3, 20] + 
      Rational[7, 40] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[-7, 20] + 
      Rational[3, 40] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[-1, 5], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[1, 5], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[7, 20] + 
      Rational[3, 40] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[3, 20] + 
      Rational[7, 40] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (1 + 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (1 + 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (-1 - 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (-1 - 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[-3, 20] + 
      Rational[7, 40] (-3 - 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[-7, 20] + 
      Rational[3, 40] (-3 - 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[3, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[7, 40] (-1 - 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[7, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[3, 40] (-1 - 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      3, 20], Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      7, 20], Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-7, 20], 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-3, 20], 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[3, 40] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[7, 40] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[7, 20] + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 
      Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[3, 20] + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 
      Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[3, 20] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[7, 20] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[7, 20] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[3, 20] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[3, 20] + Rational[7, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[7, 20] + Rational[3, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[7, 20] + 
      Rational[3, 40] (1 + 5^Rational[1, 2]), 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[3, 20] + 
      Rational[7, 40] (1 + 5^Rational[1, 2]), 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-7, 20] + Rational[-3, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-3, 20] + Rational[-7, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-7, 80] (1 + 5^Rational[1, 2])^2, 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-3, 80] (1 + 5^Rational[1, 2])^2, 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[-3, 20] + 
      Rational[7, 40] (-1 - 5^Rational[1, 2]), 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[-7, 20] + 
      Rational[3, 40] (-1 - 5^Rational[1, 2]), 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[7, 20] (-1 - 5^Rational[1, 2]) + 
      Rational[-3, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[3, 20] (-1 - 5^Rational[1, 2]) + 
      Rational[-7, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[3, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[-7, 80] (1 + 5^Rational[1, 2])^2, 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[7, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[-3, 80] (1 + 5^Rational[1, 2])^2, 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[7, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[3, 20] (-1 - 5^Rational[1, 2]), 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[3, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[7, 20] (-1 - 5^Rational[1, 2]), 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 5], 
      0}, {Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 5], 0}, {
     Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      7, 20], Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      3, 20], Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-3, 20], 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-7, 20], 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[7, 20] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[3, 20] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[1, 5], 
      0}, {Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 5], 0}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[3, 20] (-1 - 5^Rational[1, 2]) + 
      Rational[-7, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[7, 20] (-1 - 5^Rational[1, 2]) + 
      Rational[-3, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-3, 20] + Rational[-7, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-7, 20] + Rational[-3, 80] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[7, 20] + Rational[3, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[3, 20] + Rational[7, 40] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 5], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      1, 5], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-7, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[7, 20] + 
      Rational[3, 40] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-3, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[3, 20] + 
      Rational[7, 40] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[7, 40] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[3, 40] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[3, 40] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[7, 40] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-3, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-3, 20] + 
      Rational[7, 40] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-7, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-7, 20] + 
      Rational[3, 40] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[3, 40] (-1 - 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[7, 40] (-1 - 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[7, 40] (1 + 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[3, 40] (1 + 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-7, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[7, 20] + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[3, 20] + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-13, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-7, 20], 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-17, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-3, 20], 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-17, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      3, 20], Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-13, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      7, 20], Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[7, 40] (-1 - 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[3, 40] (-1 - 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[-3, 20] + 
      Rational[7, 40] (-3 - 5^Rational[1, 2]), 
      Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-7, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[-7, 20] + 
      Rational[3, 40] (-3 - 5^Rational[1, 2]), 
      Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[3, 20] (-1 - 5^Rational[1, 2]), Rational[7, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[7, 20] (-1 - 5^Rational[1, 2]), Rational[3, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[-7, 80] (1 + 5^Rational[1, 2])^2, Rational[3, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 40] (-3 - 5^Rational[1, 2]) + 
      Rational[-3, 80] (1 + 5^Rational[1, 2])^2, Rational[7, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-3, 20] + Rational[7, 40] (-1 - 5^Rational[1, 2]), 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-7, 20] + Rational[3, 40] (-1 - 5^Rational[1, 2]), 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[3, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-7, 80] (1 + 5^Rational[1, 2])^2, Rational[3, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[7, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-3, 80] (1 + 5^Rational[1, 2])^2, Rational[7, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[7, 40] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), Rational[7, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 10] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[3, 40] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), Rational[3, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[7, 20] + Rational[3, 40] (1 + 5^Rational[1, 2]), 
      Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[3, 20] + Rational[7, 40] (1 + 5^Rational[1, 2]), 
      Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[7, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-7, 20] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[3, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[3, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[7, 20] (1 + 5^Rational[1, 2]) + 
      Rational[3, 40] (3 + 5^Rational[1, 2]), Rational[3, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[7, 10] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[3, 20] (1 + 5^Rational[1, 2]) + 
      Rational[7, 40] (3 + 5^Rational[1, 2]), Rational[7, 10] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-3, 20], Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-7, 20], Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-7, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      7, 20], Rational[3, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-7, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-3, 20] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      3, 20], Rational[7, 10] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}}, {{
     0, -1.618033988749895, 0}, {0, 1.618033988749895, 0}, {
     0.2628655560595668, -0.8090169943749475, -1.3763819204711736`}, {
     0.2628655560595668, 0.8090169943749475, -1.3763819204711736`}, {
     0.42532540417601994`, -1.3090169943749475`, 0.85065080835204}, {
     0.42532540417601994`, 1.3090169943749475`, 0.85065080835204}, {
     0.6881909602355868, -0.5, 1.3763819204711736`}, {0.6881909602355868, 0.5,
      1.3763819204711736`}, {
     1.1135163644116066`, -0.8090169943749475, -0.85065080835204}, {
     1.1135163644116066`, 
     0.8090169943749475, -0.85065080835204}, {-1.3763819204711736`, 
      0, -0.85065080835204}, {-0.6881909602355868, -0.5, \
-1.3763819204711736`}, {-0.6881909602355868, 0.5, -1.3763819204711736`}, {
     1.3763819204711736`, 0, 0.85065080835204}, {
     0.9510565162951535, -1.3090169943749475`, 0}, {
     0.9510565162951535, 1.3090169943749475`, 0}, {
     0.85065080835204, 
      0, -1.3763819204711736`}, {-0.9510565162951535, -1.3090169943749475`, 
      0}, {-0.9510565162951535, 1.3090169943749475`, 
      0}, {-1.5388417685876268`, -0.5, 0}, {-1.5388417685876268`, 0.5, 0}, {
     1.5388417685876268`, -0.5, 0}, {
     1.5388417685876268`, 0.5, 0}, {-0.85065080835204, 0, 
      1.3763819204711736`}, {-1.1135163644116068`, -0.8090169943749475, 
     0.85065080835204}, {-1.1135163644116068`, 0.8090169943749475, 
     0.85065080835204}, {-0.42532540417601994`, -1.3090169943749475`, \
-0.85065080835204}, {-0.42532540417601994`, 
     1.3090169943749475`, -0.85065080835204}, {-0.2628655560595668, \
-0.8090169943749475, 1.3763819204711736`}, {-0.2628655560595668, 
     0.8090169943749475, 1.3763819204711736`}, {-0.43920113174730874`, 
     0.5663118960624631, 1.3763819204711736`}, {-0.674315232664298, 
     0.2427050983124842, 
     1.3763819204711736`}, {-0.674315232664298, -0.2427050983124842, 
     1.3763819204711736`}, {-0.43920113174730874`, -0.5663118960624631, 
     1.3763819204711736`}, {0.022451398828979285`, -0.7163118960624631, 
     1.3763819204711736`}, {0.40287400534704065`, -0.5927050983124842, 
     1.3763819204711736`}, {0.6881909602355868, -0.2, 1.3763819204711736`}, {
     0.6881909602355868, 0.2, 1.3763819204711736`}, {0.40287400534704065`, 
     0.5927050983124842, 1.3763819204711736`}, {0.022451398828979285`, 
     0.7163118960624631, 1.3763819204711736`}, {-1.0346566975937366`, 
     0.5663118960624631, 1.00837014198778}, {-0.92951047516991, 
     0.2427050983124842, 1.2186625868354333`}, {-0.5180607985651788, 
     0.8090169943749475, 1.2186625868354333`}, {-0.8583211219059947, 
     0.8090169943749475, 
     1.00837014198778}, {-0.8583211219059947, -0.8090169943749475, 
     1.00837014198778}, {-0.5180607985651788, -0.8090169943749475, 
     1.2186625868354333`}, {-0.92951047516991, -0.2427050983124842, 
     1.2186625868354333`}, {-1.0346566975937366`, -0.5663118960624631, 
     1.00837014198778}, {0.50418507099389, -1.0663118960624631`, 
     1.00837014198778}, {0.6093312934177166, -0.7427050983124842, 
     1.2186625868354333`}, {-0.05640826798889079, -0.9590169943749474, 
     1.2186625868354333`}, {0.2188681161053439, -1.1590169943749473`, 
     1.00837014198778}, {1.1699246324004975`, 0.15, 1.00837014198778}, {
     0.8946482483062628, 0.35, 1.2186625868354333`}, {
     0.8946482483062628, -0.35, 1.2186625868354333`}, {
     1.1699246324004975`, -0.15, 1.00837014198778}, {0.2188681161053439, 
     1.1590169943749473`, 1.00837014198778}, {-0.05640826798889079, 
     0.9590169943749474, 1.2186625868354333`}, {0.6093312934177166, 
     0.7427050983124842, 1.2186625868354333`}, {0.50418507099389, 
     1.0663118960624631`, 1.00837014198778}, {
     0.6657395614066074, 1.4017220926874314`, 0}, {
     0.285316954888546, 1.5253288904374105`, 0}, {0.12759762125280597`, 
     1.5253288904374105`, 0.255195242505612}, {0.29772778292321395`, 
     1.4017220926874314`, 0.595455565846428}, {0.58304473781176, 
     1.3090169943749475`, 0.595455565846428}, {0.7933371826594133, 
     1.3090169943749475`, 
     0.255195242505612}, {-1.1273920919828955`, 1.0663118960624631`, 
      0}, {-1.3625061928998847`, 0.7427050983124842, 
      0}, {-1.4112441473348207`, 0.5927050983124842, 
     0.255195242505612}, {-1.2411139856644127`, 0.7163118960624631, 
     0.595455565846428}, {-1.0647784099766708`, 0.9590169943749474, 
     0.595455565846428}, {-0.9997944707300894, 1.1590169943749473`, 
     0.255195242505612}, {-1.3625061928998847`, -0.7427050983124842, 
      0}, {-1.1273920919828955`, -1.0663118960624631`, 
      0}, {-0.9997944707300894, -1.1590169943749473`, 
     0.255195242505612}, {-1.0647784099766708`, -0.9590169943749474, 
     0.595455565846428}, {-1.2411139856644127`, -0.7163118960624631, 
     0.595455565846428}, {-1.4112441473348207`, -0.5927050983124842, 
     0.255195242505612}, {0.285316954888546, -1.5253288904374105`, 0}, {
     0.6657395614066074, -1.4017220926874314`, 0}, {
     0.7933371826594133, -1.3090169943749475`, 0.255195242505612}, {
     0.58304473781176, -1.3090169943749475`, 0.595455565846428}, {
     0.29772778292321395`, -1.4017220926874314`, 0.595455565846428}, {
     0.12759762125280597`, -1.5253288904374105`, 0.255195242505612}, {
     1.5388417685876268`, -0.2, 0}, {1.5388417685876268`, 0.2, 0}, {
     1.4901038141526906`, 0.35, 0.255195242505612}, {1.4251198749061094`, 
     0.15, 0.595455565846428}, {1.4251198749061094`, -0.15, 
     0.595455565846428}, {1.4901038141526906`, -0.35, 
     0.255195242505612}, {-0.285316954888546, 1.5253288904374105`, 
      0}, {-0.6657395614066074, 1.4017220926874314`, 
      0}, {-1.5388417685876268`, 0.2, 0}, {-1.5388417685876268`, -0.2, 
      0}, {-0.6657395614066074, -1.4017220926874314`, 
      0}, {-0.285316954888546, -1.5253288904374105`, 0}, {
     1.1273920919828955`, -1.0663118960624631`, 0}, {
     1.3625061928998847`, -0.7427050983124842, 0}, {
     1.3625061928998847`, 0.7427050983124842, 0}, {
     1.1273920919828955`, 1.0663118960624631`, 
      0}, {-0.6881909602355868, -0.2, -1.3763819204711736`}, \
{-0.6881909602355868, 0.2, -1.3763819204711736`}, {-0.40287400534704065`, 
     0.5927050983124842, -1.3763819204711736`}, {-0.022451398828979285`, 
     0.7163118960624631, -1.3763819204711736`}, {0.43920113174730874`, 
     0.5663118960624631, -1.3763819204711736`}, {0.674315232664298, 
     0.2427050983124842, -1.3763819204711736`}, {
     0.674315232664298, -0.2427050983124842, -1.3763819204711736`}, {
     0.43920113174730874`, -0.5663118960624631, -1.3763819204711736`}, \
{-0.022451398828979285`, -0.7163118960624631, -1.3763819204711736`}, \
{-0.40287400534704065`, -0.5927050983124842, -1.3763819204711736`}, {
     0.9295104751699099, -0.2427050983124842, -1.2186625868354333`}, {
     1.0346566975937366`, -0.5663118960624631, -1.00837014198778}, {
     0.8583211219059946, -0.8090169943749475, -1.00837014198778}, {
     0.5180607985651787, -0.8090169943749475, -1.2186625868354333`}, {
     0.5180607985651787, 0.8090169943749475, -1.2186625868354333`}, {
     0.8583211219059946, 0.8090169943749475, -1.00837014198778}, {
     1.0346566975937366`, 0.5663118960624631, -1.00837014198778}, {
     0.9295104751699099, 
     0.2427050983124842, -1.2186625868354333`}, {-0.6093312934177166, 
     0.7427050983124842, -1.2186625868354333`}, {-0.50418507099389, 
     1.0663118960624631`, -1.00837014198778}, {-0.2188681161053439, 
     1.1590169943749473`, -1.00837014198778}, {0.05640826798889079, 
     0.9590169943749474, -1.2186625868354333`}, {-0.8946482483062629, -0.35, \
-1.2186625868354333`}, {-1.1699246324004975`, -0.15, -1.00837014198778}, \
{-1.1699246324004975`, 0.15, -1.00837014198778}, {-0.8946482483062629, 
     0.35, -1.2186625868354333`}, {
     0.05640826798889079, -0.9590169943749474, -1.2186625868354333`}, \
{-0.2188681161053439, -1.1590169943749473`, -1.00837014198778}, \
{-0.50418507099389, -1.0663118960624631`, -1.00837014198778}, \
{-0.6093312934177166, -0.7427050983124842, -1.2186625868354333`}, \
{-0.29772778292321395`, -1.4017220926874314`, -0.595455565846428}, \
{-0.12759762125280597`, -1.5253288904374105`, -0.255195242505612}, \
{-0.7933371826594133, -1.3090169943749475`, -0.255195242505612}, \
{-0.58304473781176, -1.3090169943749475`, -0.595455565846428}, {
     1.2411139856644127`, -0.7163118960624631, -0.595455565846428}, {
     1.4112441473348205`, -0.5927050983124842, -0.255195242505612}, {
     0.9997944707300894, -1.1590169943749473`, -0.255195242505612}, {
     1.0647784099766706`, -0.9590169943749474, -0.595455565846428}, {
     1.0647784099766706`, 0.9590169943749474, -0.595455565846428}, {
     0.9997944707300894, 1.1590169943749473`, -0.255195242505612}, {
     1.4112441473348205`, 0.5927050983124842, -0.255195242505612}, {
     1.2411139856644127`, 
     0.7163118960624631, -0.595455565846428}, {-0.58304473781176, 
     1.3090169943749475`, -0.595455565846428}, {-0.7933371826594133, 
     1.3090169943749475`, -0.255195242505612}, {-0.12759762125280597`, 
     1.5253288904374105`, -0.255195242505612}, {-0.29772778292321395`, 
     1.4017220926874314`, -0.595455565846428}, {-1.4251198749061094`, -0.15, \
-0.595455565846428}, {-1.4901038141526906`, -0.35, -0.255195242505612}, \
{-1.4901038141526906`, 0.35, -0.255195242505612}, {-1.4251198749061094`, 
     0.15, -0.595455565846428}}], {
    Polygon3DBox[{{31, 32, 33, 34, 35, 36, 37, 38, 39, 40}, {41, 42, 32, 31, 
      43, 44}, {45, 46, 34, 33, 47, 48}, {49, 50, 36, 35, 51, 52}, {53, 54, 
      38, 37, 55, 56}, {57, 58, 40, 39, 59, 60}, {61, 62, 63, 64, 65, 66}, {
      67, 68, 69, 70, 71, 72}, {73, 74, 75, 76, 77, 78}, {79, 80, 81, 82, 83, 
      84}, {85, 86, 87, 88, 89, 90}, {91, 92, 72, 71, 44, 43, 58, 57, 64, 
      63}, {93, 94, 78, 77, 48, 47, 42, 41, 70, 69}, {95, 96, 84, 83, 52, 51, 
      46, 45, 76, 75}, {97, 98, 90, 89, 56, 55, 50, 49, 82, 81}, {99, 100, 66,
       65, 60, 59, 54, 53, 88, 87}, {101, 102, 103, 104, 105, 106, 107, 108, 
      109, 110}, {108, 107, 111, 112, 113, 114}, {106, 105, 115, 116, 117, 
      118}, {104, 103, 119, 120, 121, 122}, {102, 101, 123, 124, 125, 126}, {
      110, 109, 127, 128, 129, 130}, {131, 132, 96, 95, 133, 134}, {135, 136, 
      98, 97, 137, 138}, {139, 140, 100, 99, 141, 142}, {143, 144, 92, 91, 
      145, 146}, {147, 148, 94, 93, 149, 150}, {128, 127, 114, 113, 138, 137, 
      80, 79, 132, 131}, {112, 111, 118, 117, 142, 141, 86, 85, 136, 135}, {
      116, 115, 122, 121, 146, 145, 62, 61, 140, 139}, {120, 119, 126, 125, 
      150, 149, 68, 67, 144, 143}, {124, 123, 130, 129, 134, 133, 74, 73, 148,
       147}}], Polygon3DBox[{{96, 132, 79, 84}, {145, 91, 63, 62}, {114, 127, 
     109, 108}, {122, 115, 105, 104}, {83, 82, 49, 52}, {65, 64, 57, 60}, {50,
      55, 37, 36}, {54, 59, 39, 38}, {135, 138, 113, 112}, {139, 142, 117, 
     116}, {147, 150, 125, 124}, {130, 123, 101, 110}, {126, 119, 103, 102}, {
     89, 88, 53, 56}, {137, 97, 81, 80}, {100, 140, 61, 66}, {118, 111, 107, 
     106}, {133, 95, 75, 74}, {92, 144, 67, 72}, {94, 148, 73, 78}, {149, 93, 
     69, 68}, {98, 136, 85, 90}, {141, 99, 87, 86}, {42, 47, 33, 32}, {77, 76,
      45, 48}, {71, 70, 41, 44}, {131, 134, 129, 128}, {143, 146, 121, 120}, {
     46, 51, 35, 34}, {58, 43, 31, 40}}]}]]], "Output",
 CellChangeTimes->{3.4994713436531153`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Icosidodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
   ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.499471659073557*^9, 3.499471660533559*^9}, {
  3.4994718553938313`*^9, 3.499471869213851*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 0}, {
     0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
      0}, {(Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[-1, 2], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[1, 2], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2],
       0, Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {(1 + 
       2 5^Rational[-1, 2])^Rational[1, 2], 
      0, (Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
      Rational[1, 2], Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 
      0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
      0}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      0, -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2],
       0}, {Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 2], 0}, {
     Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2], 
      0}, {Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 2], 0}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] (Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 8] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] (Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], 0, (1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[1, 2] + 
       Rational[1, 4] (1 + 5^Rational[1, 2])), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] (Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] (Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-3 - 5^Rational[1, 2])), 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^Rational[1, 2]), Rational[
      1, 4], Rational[
       1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^Rational[1, 2]), 
      Rational[-1, 4], 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (3 + 5^Rational[1, 2])),
       Rational[
       1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2])}, {
     Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], 
      Rational[1, 2] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 0}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], 
      Rational[1, 2] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]), Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (
       Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (3 + 5^Rational[1, 2])),
       0}, {Rational[1, 2] (
       Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (1 + 5^Rational[1, 2])),
       Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (
       Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (
       Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), 0}, {
     Rational[1, 2] (
       Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], 
      Rational[1, 2] (Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), 0}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 2] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 0, 0}, {
     Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), Rational[
      1, 4], Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[-1, 4], 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 2] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 0}, {
     Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 0, 0}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 2] (Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), 0}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), 0}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (3 + 5^Rational[1, 2])),
       0}, {Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      0, -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 2] + 
       Rational[1, 4] (1 + 5^Rational[1, 2])), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]), 
      Rational[1, 8] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]), 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]), Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]), Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]), Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]), Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] (Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (3 + 5^Rational[1, 2])),
       Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[-3, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 4], 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[-3, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 4],
       Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] (Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-3 - 5^Rational[1, 2])), 
      Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0])}, {
     Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 2] (-1 - 5^Rational[1, 2])), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (
       Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
       Rational[-1, 8] (1 + 5^Rational[1, 2])^2), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (1 + 5^Rational[1, 2])),
       Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (
       Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 2] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), 
      Rational[-1, 4], Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]), Rational[
      1, 4], Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 16] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 16] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 0}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 0}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[-1, 16] (1 + 5^Rational[1, 2])^2, 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[-1, 4] + 
      Rational[1, 8] (-3 - 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 4], 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 4],
       Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 8] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 16] (1 + 5^Rational[1, 2])^2, Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 4], Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[1, 4],
       Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 4],
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-3, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 4], 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[-1, 4] + 
      Rational[1, 8] (-3 - 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 4],
       Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[1, 4], 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 4] + 
      Rational[-1, 16] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[1, 2] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[1, 4] + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[-1, 16] (1 + 5^Rational[1, 2])^2, Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 16] (1 + 5^Rational[1, 2])^2, 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 4] + Rational[-1, 16] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[1, 2] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[1, 4] + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 4] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 4] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}}, {{0, -1.618033988749895, 0}, {
     0, 1.618033988749895, 0}, {
     0.2628655560595668, -0.8090169943749475, -1.3763819204711736`}, {
     0.2628655560595668, 0.8090169943749475, -1.3763819204711736`}, {
     0.42532540417601994`, -1.3090169943749475`, 0.85065080835204}, {
     0.42532540417601994`, 1.3090169943749475`, 0.85065080835204}, {
     0.6881909602355868, -0.5, 1.3763819204711736`}, {0.6881909602355868, 0.5,
      1.3763819204711736`}, {
     1.1135163644116066`, -0.8090169943749475, -0.85065080835204}, {
     1.1135163644116066`, 
     0.8090169943749475, -0.85065080835204}, {-1.3763819204711736`, 
      0, -0.85065080835204}, {-0.6881909602355868, -0.5, \
-1.3763819204711736`}, {-0.6881909602355868, 0.5, -1.3763819204711736`}, {
     1.3763819204711736`, 0, 0.85065080835204}, {
     0.9510565162951535, -1.3090169943749475`, 0}, {
     0.9510565162951535, 1.3090169943749475`, 0}, {
     0.85065080835204, 
      0, -1.3763819204711736`}, {-0.9510565162951535, -1.3090169943749475`, 
      0}, {-0.9510565162951535, 1.3090169943749475`, 
      0}, {-1.5388417685876268`, -0.5, 0}, {-1.5388417685876268`, 0.5, 0}, {
     1.5388417685876268`, -0.5, 0}, {
     1.5388417685876268`, 0.5, 0}, {-0.85065080835204, 0, 
      1.3763819204711736`}, {-1.1135163644116068`, -0.8090169943749475, 
     0.85065080835204}, {-1.1135163644116068`, 0.8090169943749475, 
     0.85065080835204}, {-0.42532540417601994`, -1.3090169943749475`, \
-0.85065080835204}, {-0.42532540417601994`, 
     1.3090169943749475`, -0.85065080835204}, {-0.2628655560595668, \
-0.8090169943749475, 1.3763819204711736`}, {-0.2628655560595668, 
     0.8090169943749475, 1.3763819204711736`}, {-0.5567581822058034, 
     0.4045084971874737, 
     1.3763819204711736`}, {-0.5567581822058034, -0.4045084971874737, 
     1.3763819204711736`}, {0.21266270208801, -0.6545084971874737, 
     1.3763819204711736`}, {0.6881909602355868, 0, 1.3763819204711736`}, {
     0.21266270208801, 0.6545084971874737, 
     1.3763819204711736`}, {-0.9820835863818234, 0.4045084971874737, 
     1.1135163644116068`}, {-0.6881909602355868, 0.8090169943749475, 
     1.1135163644116068`}, {-0.6881909602355868, -0.8090169943749475, 
     1.1135163644116068`}, {-0.9820835863818234, -0.4045084971874737, 
     1.1135163644116068`}, {0.5567581822058034, -0.9045084971874737, 
     1.1135163644116068`}, {0.08122992405822657, -1.0590169943749475`, 
     1.1135163644116068`}, {1.0322864403533802`, 0.25, 1.1135163644116068`}, {
     1.0322864403533802`, -0.25, 1.1135163644116068`}, {0.08122992405822657, 
     1.0590169943749475`, 1.1135163644116068`}, {0.5567581822058034, 
     0.9045084971874737, 1.1135163644116068`}, {
     0.47552825814757677`, 1.4635254915624212`, 0}, {0.21266270208800997`, 
     1.4635254915624212`, 0.42532540417602}, {0.6881909602355867, 
     1.3090169943749475`, 
     0.42532540417602}, {-1.24494914244139, 0.9045084971874737, 
      0}, {-1.3261790664996167`, 0.6545084971874737, 
     0.42532540417602}, {-1.0322864403533802`, 1.0590169943749475`, 
     0.42532540417602}, {-1.24494914244139, -0.9045084971874737, 
      0}, {-1.0322864403533802`, -1.0590169943749475`, 
     0.42532540417602}, {-1.3261790664996167`, -0.6545084971874737, 
     0.42532540417602}, {0.47552825814757677`, -1.4635254915624212`, 0}, {
     0.6881909602355867, -1.3090169943749475`, 0.42532540417602}, {
     0.21266270208800997`, -1.4635254915624212`, 0.42532540417602}, {
     1.5388417685876268`, 0, 0}, {1.4576118445294002`, 0.25, 
     0.42532540417602}, {1.4576118445294002`, -0.25, 
     0.42532540417602}, {-0.47552825814757677`, 1.4635254915624212`, 
      0}, {-1.5388417685876268`, 0, 
      0}, {-0.47552825814757677`, -1.4635254915624212`, 0}, {
     1.24494914244139, -0.9045084971874737, 0}, {
     1.24494914244139, 0.9045084971874737, 0}, {-0.6881909602355868, 
      0, -1.3763819204711736`}, {-0.21266270208801, 
     0.6545084971874737, -1.3763819204711736`}, {0.5567581822058034, 
     0.4045084971874737, -1.3763819204711736`}, {
     0.5567581822058034, -0.4045084971874737, -1.3763819204711736`}, \
{-0.21266270208801, -0.6545084971874737, -1.3763819204711736`}, {
     0.9820835863818234, -0.4045084971874737, -1.1135163644116068`}, {
     0.6881909602355867, -0.8090169943749475, -1.1135163644116068`}, {
     0.6881909602355867, 0.8090169943749475, -1.1135163644116068`}, {
     0.9820835863818234, 
     0.4045084971874737, -1.1135163644116068`}, {-0.5567581822058034, 
     0.9045084971874737, -1.1135163644116068`}, {-0.08122992405822657, 
     1.0590169943749475`, -1.1135163644116068`}, {-1.0322864403533802`, \
-0.25, -1.1135163644116068`}, {-1.0322864403533802`, 
     0.25, -1.1135163644116068`}, {-0.08122992405822657, \
-1.0590169943749475`, -1.1135163644116068`}, {-0.5567581822058034, \
-0.9045084971874737, -1.1135163644116068`}, {-0.21266270208800997`, \
-1.4635254915624212`, -0.42532540417602}, {-0.6881909602355867, \
-1.3090169943749475`, -0.42532540417602}, {
     1.3261790664996167`, -0.6545084971874737, -0.42532540417602}, {
     1.03228644035338, -1.0590169943749475`, -0.42532540417602}, {
     1.03228644035338, 1.0590169943749475`, -0.42532540417602}, {
     1.3261790664996167`, 
     0.6545084971874737, -0.42532540417602}, {-0.6881909602355867, 
     1.3090169943749475`, -0.42532540417602}, {-0.21266270208800997`, 
     1.4635254915624212`, -0.42532540417602}, {-1.4576118445294002`, -0.25, \
-0.42532540417602}, {-1.4576118445294002`, 
     0.25, -0.42532540417602}, {-0.47552825814757677`, -1.4635254915624212`, 
      0}, {-0.21266270208800997`, -1.4635254915624212`, -0.42532540417602}, {
     0.47552825814757677`, -1.4635254915624212`, 0}, {
     0.21266270208800997`, -1.4635254915624212`, 
     0.42532540417602}, {-0.21266270208800997`, 
     1.4635254915624212`, -0.42532540417602}, {-0.47552825814757677`, 
      1.4635254915624212`, 0}, {0.21266270208800997`, 1.4635254915624212`, 
     0.42532540417602}, {0.47552825814757677`, 1.4635254915624212`, 0}, {
     0.6881909602355867, -0.8090169943749475, -1.1135163644116068`}, \
{-0.08122992405822657, -1.0590169943749475`, -1.1135163644116068`}, \
{-0.21266270208801, -0.6545084971874737, -1.3763819204711736`}, {
     0.5567581822058034, -0.4045084971874737, -1.3763819204711736`}, \
{-0.08122992405822657, 1.0590169943749475`, -1.1135163644116068`}, {
     0.6881909602355867, 0.8090169943749475, -1.1135163644116068`}, {
     0.5567581822058034, 
     0.4045084971874737, -1.3763819204711736`}, {-0.21266270208801, 
     0.6545084971874737, -1.3763819204711736`}, {
     0.6881909602355867, -1.3090169943749475`, 0.42532540417602}, {
     0.5567581822058034, -0.9045084971874737, 1.1135163644116068`}, {
     0.08122992405822657, -1.0590169943749475`, 1.1135163644116068`}, {
     0.6881909602355867, 1.3090169943749475`, 0.42532540417602}, {
     0.08122992405822657, 1.0590169943749475`, 1.1135163644116068`}, {
     0.5567581822058034, 0.9045084971874737, 1.1135163644116068`}, {
     1.0322864403533802`, -0.25, 1.1135163644116068`}, {
     0.21266270208801, -0.6545084971874737, 1.3763819204711736`}, {
     1.0322864403533802`, 0.25, 1.1135163644116068`}, {0.21266270208801, 
     0.6545084971874737, 1.3763819204711736`}, {
     1.3261790664996167`, -0.6545084971874737, -0.42532540417602}, {
     1.03228644035338, -1.0590169943749475`, -0.42532540417602}, {
     0.9820835863818234, -0.4045084971874737, -1.1135163644116068`}, {
     1.03228644035338, 1.0590169943749475`, -0.42532540417602}, {
     1.3261790664996167`, 0.6545084971874737, -0.42532540417602}, {
     0.9820835863818234, 
     0.4045084971874737, -1.1135163644116068`}, {-1.4576118445294002`, -0.25, \
-0.42532540417602}, {-1.4576118445294002`, 
     0.25, -0.42532540417602}, {-1.0322864403533802`, 
     0.25, -1.1135163644116068`}, {-1.0322864403533802`, -0.25, \
-1.1135163644116068`}, {-0.5567581822058034, -0.9045084971874737, \
-1.1135163644116068`}, {-0.5567581822058034, 
     0.9045084971874737, -1.1135163644116068`}, {1.4576118445294002`, -0.25, 
     0.42532540417602}, {1.4576118445294002`, 0.25, 0.42532540417602}, {
     1.24494914244139, -0.9045084971874737, 0}, {
     1.24494914244139, 0.9045084971874737, 
      0}, {-0.6881909602355867, -1.3090169943749475`, -0.42532540417602}, \
{-1.0322864403533802`, -1.0590169943749475`, 
     0.42532540417602}, {-1.24494914244139, -0.9045084971874737, 
      0}, {-0.6881909602355867, 
     1.3090169943749475`, -0.42532540417602}, {-1.24494914244139, 
      0.9045084971874737, 0}, {-1.0322864403533802`, 1.0590169943749475`, 
     0.42532540417602}, {-1.3261790664996167`, -0.6545084971874737, 
     0.42532540417602}, {-1.3261790664996167`, 0.6545084971874737, 
     0.42532540417602}, {-0.9820835863818234, 0.4045084971874737, 
     1.1135163644116068`}, {-0.9820835863818234, -0.4045084971874737, 
     1.1135163644116068`}, {-0.5567581822058034, -0.4045084971874737, 
     1.3763819204711736`}, {-0.5567581822058034, 0.4045084971874737, 
     1.3763819204711736`}, {-0.6881909602355868, -0.8090169943749475, 
     1.1135163644116068`}, {-0.6881909602355868, 0.8090169943749475, 
     1.1135163644116068`}}], {
    Polygon3DBox[{{31, 32, 33, 34, 35}, {36, 31, 37}, {38, 32, 39}, {40, 33, 
      41}, {42, 34, 43}, {44, 35, 45}, {46, 47, 48}, {49, 50, 51}, {52, 53, 
      54}, {55, 56, 57}, {58, 59, 60}, {61, 51, 37, 44, 47}, {62, 54, 39, 36, 
      50}, {63, 57, 41, 38, 53}, {64, 60, 43, 40, 56}, {65, 48, 45, 42, 59}, {
      66, 67, 68, 69, 70}, {69, 71, 72}, {68, 73, 74}, {67, 75, 76}, {66, 77, 
      78}, {70, 79, 80}, {81, 63, 82}, {83, 64, 84}, {85, 65, 86}, {87, 61, 
      88}, {89, 62, 90}, {79, 72, 84, 55, 81}, {71, 74, 86, 58, 83}, {73, 76, 
      88, 46, 85}, {75, 78, 90, 49, 87}, {77, 80, 82, 52, 89}}], 
    Polygon3DBox[{{91, 92, 93, 94}, {95, 96, 97, 98}, {99, 100, 101, 102}, {
     103, 104, 105, 106}, {94, 107, 108, 109}, {110, 97, 111, 112}, {108, 113,
      34, 114}, {115, 112, 116, 34}, {117, 118, 99, 119}, {120, 121, 122, 
     104}, {123, 124, 125, 126}, {127, 126, 66, 101}, {125, 128, 106, 66}, {
     129, 130, 115, 113}, {118, 131, 107, 93}, {132, 120, 98, 110}, {122, 119,
      102, 105}, {133, 91, 134, 135}, {96, 136, 137, 138}, {62, 123, 135, 
     139}, {124, 62, 140, 137}, {131, 117, 58, 129}, {121, 132, 130, 58}, {
     141, 142, 143, 144}, {139, 134, 145, 142}, {138, 140, 141, 146}, {92, 
     133, 127, 100}, {136, 95, 103, 128}, {145, 109, 114, 143}, {111, 146, 
     144, 116}}]}]]], "Output",
 CellChangeTimes->{
  3.4994716617235603`*^9, {3.4994718572838345`*^9, 3.4994718702338524`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Icosidodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
   ",", 
   RowBox[{"1", "/", "20"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.499471745783678*^9, 3.499471746533679*^9}, {
  3.499471793743745*^9, 3.4994718246737885`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{0, Rational[1, 2] (-1 - 5^Rational[1, 2]), 0}, {
     0, Rational[1, 2] (1 + 5^Rational[1, 2]), 
      0}, {(Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[-1, 2], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[1, 2], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {-(1 + 2 5^Rational[-1, 2])^Rational[1, 2],
       0, Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      1, 2], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {(1 + 
       2 5^Rational[-1, 2])^Rational[1, 2], 
      0, (Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2]}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
      Rational[1, 2], Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 
      0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
      0}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      0, -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[-1, 8] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2],
       0}, {Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 2], 0}, {
     Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-1, 2], 
      0}, {Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 2], 0}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (
       Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[19, 80] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 80] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[19, 80] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[-1, 40] + 
      Rational[19, 80] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[-19, 40] + 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[-9, 20], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[9, 20], (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[19, 40] + 
      Rational[1, 80] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] + 
      Rational[19, 80] (1 + 5^Rational[1, 2]), (1 + 2 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (1 + 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (1 + 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (-1 - 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[-1, 40] + 
      Rational[19, 80] (-3 - 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[-19, 40] + 
      Rational[1, 80] (-3 - 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[19, 80] (-1 - 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[19, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      1, 40], Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      19, 40], Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-19, 40], 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 40], 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 80] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[19, 80] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[19, 40] + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 
      Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 40] + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 
      Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]}, {
     Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 40] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[19, 40] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[19, 40] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[1, 40] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 40] + Rational[19, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[19, 40] + Rational[1, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[19, 40] + 
      Rational[1, 80] (1 + 5^Rational[1, 2]), 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[1, 40] + 
      Rational[19, 80] (1 + 5^Rational[1, 2]), 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-19, 40] + Rational[-1, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[-1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 40] + Rational[-19, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (-1 - 5^Rational[1, 2]) + 
      Rational[-19, 160] (1 + 5^Rational[1, 2])^2, 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 160] (1 + 5^Rational[1, 2])^2, 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[-1, 40] + 
      Rational[19, 80] (-1 - 5^Rational[1, 2]), 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[-19, 40] + 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[19, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-19, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[-19, 160] (1 + 5^Rational[1, 2])^2, 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[19, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[-1, 160] (1 + 5^Rational[1, 2])^2, 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[19, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 40] (-1 - 5^Rational[1, 2]), 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[1, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[19, 40] (-1 - 5^Rational[1, 2]), 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[-9, 20],
       0}, {Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      9, 20], 0}, {
     Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      19, 40], Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 40], Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 40], 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-19, 40], 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2]}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[19, 40] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[1, 40] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[9, 20],
       0}, {Rational[-1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-9, 20], 0}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[1, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-19, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      Rational[19, 40] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 40] + Rational[-19, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-19, 40] + Rational[-1, 160] (1 + 5^Rational[1, 2])^2, 0}, {
     Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[19, 40] + Rational[1, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2] + 
      Rational[1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 40] + Rational[19, 80] (3 + 5^Rational[1, 2]), 0}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-9, 20], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      9, 20], -(1 + 2 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-19, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[19, 40] + 
      Rational[1, 80] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-1, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 40] + 
      Rational[19, 80] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[19, 80] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], 
      Rational[1, 80] (1 + 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[19, 80] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-1, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 40] + 
      Rational[19, 80] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[-19, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-19, 40] + 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), -(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], Rational[1, 80] (-1 - 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[19, 80] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2],
       Rational[19, 80] (1 + 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], Rational[1, 80] (1 + 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-19, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[19, 40] + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 40] + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-21, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-19, 40], 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-39, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 40], 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-39, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      1, 40], Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-21, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
      19, 40], Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[19, 80] (-1 - 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[1, 8] + Rational[-1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 80] (-1 - 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[-1, 40] + 
      Rational[19, 80] (-3 - 5^Rational[1, 2]), 
      Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-19, 40] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[-19, 40] + 
      Rational[1, 80] (-3 - 5^Rational[1, 2]), 
      Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 40] (-1 - 5^Rational[1, 2]), Rational[19, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[19, 40] (-1 - 5^Rational[1, 2]), Rational[1, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[-19, 160] (1 + 5^Rational[1, 2])^2, Rational[1, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 80] (-3 - 5^Rational[1, 2]) + 
      Rational[-1, 160] (1 + 5^Rational[1, 2])^2, Rational[19, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 40] + Rational[19, 80] (-1 - 5^Rational[1, 2]), 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-19, 40] + Rational[1, 80] (-1 - 5^Rational[1, 2]), 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 80] (-1 - 5^Rational[1, 2]) + 
      Rational[-19, 160] (1 + 5^Rational[1, 2])^2, Rational[1, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[19, 80] (-1 - 5^Rational[1, 2]) + 
      Rational[-1, 160] (1 + 5^Rational[1, 2])^2, Rational[19, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[19, 80] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), Rational[19, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 20] (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 80] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), Rational[1, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[19, 40] + Rational[1, 80] (1 + 5^Rational[1, 2]), 
      Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 40] + Rational[19, 80] (1 + 5^Rational[1, 2]), 
      Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[19, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-19, 40] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Rational[1, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[1, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[19, 40] (1 + 5^Rational[1, 2]) + 
      Rational[1, 80] (3 + 5^Rational[1, 2]), Rational[1, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[19, 20] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (1 + 5^Rational[1, 2]) + 
      Rational[19, 80] (3 + 5^Rational[1, 2]), Rational[19, 20] 
      Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-1, 40], Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], 
      Rational[-19, 40], Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-19, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      19, 40], Rational[1, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}, {
     Rational[-19, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[-1, 40] (5 + 2 5^Rational[1, 2])^Rational[1, 2], Rational[
      1, 40], Rational[19, 20] Root[1 - 5 #^2 + 5 #^4& , 1, 0]}}, {{
     0, -1.618033988749895, 0}, {0, 1.618033988749895, 0}, {
     0.2628655560595668, -0.8090169943749475, -1.3763819204711736`}, {
     0.2628655560595668, 0.8090169943749475, -1.3763819204711736`}, {
     0.42532540417601994`, -1.3090169943749475`, 0.85065080835204}, {
     0.42532540417601994`, 1.3090169943749475`, 0.85065080835204}, {
     0.6881909602355868, -0.5, 1.3763819204711736`}, {0.6881909602355868, 0.5,
      1.3763819204711736`}, {
     1.1135163644116066`, -0.8090169943749475, -0.85065080835204}, {
     1.1135163644116066`, 
     0.8090169943749475, -0.85065080835204}, {-1.3763819204711736`, 
      0, -0.85065080835204}, {-0.6881909602355868, -0.5, \
-1.3763819204711736`}, {-0.6881909602355868, 0.5, -1.3763819204711736`}, {
     1.3763819204711736`, 0, 0.85065080835204}, {
     0.9510565162951535, -1.3090169943749475`, 0}, {
     0.9510565162951535, 1.3090169943749475`, 0}, {
     0.85065080835204, 
      0, -1.3763819204711736`}, {-0.9510565162951535, -1.3090169943749475`, 
      0}, {-0.9510565162951535, 1.3090169943749475`, 
      0}, {-1.5388417685876268`, -0.5, 0}, {-1.5388417685876268`, 0.5, 0}, {
     1.5388417685876268`, -0.5, 0}, {
     1.5388417685876268`, 0.5, 0}, {-0.85065080835204, 0, 
      1.3763819204711736`}, {-1.1135163644116068`, -0.8090169943749475, 
     0.85065080835204}, {-1.1135163644116068`, 0.8090169943749475, 
     0.85065080835204}, {-0.42532540417601994`, -1.3090169943749475`, \
-0.85065080835204}, {-0.42532540417601994`, 
     1.3090169943749475`, -0.85065080835204}, {-0.2628655560595668, \
-0.8090169943749475, 1.3763819204711736`}, {-0.2628655560595668, 
     0.8090169943749475, 1.3763819204711736`}, {-0.29225481867419045`, 
     0.7685661446562, 1.3763819204711736`}, {-0.8212615457374163, 
     0.04045084971874738, 
     1.3763819204711736`}, {-0.8212615457374163, -0.04045084971874738, 
     1.3763819204711736`}, {-0.29225481867419045`, -0.7685661446562, 
     1.3763819204711736`}, {-0.2153127302448091, -0.7935661446562, 
     1.3763819204711736`}, {0.6406381344208291, -0.5154508497187473, 
     1.3763819204711736`}, {0.6881909602355868, -0.45, 1.3763819204711736`}, {
     0.6881909602355868, 0.45, 1.3763819204711736`}, {0.6406381344208291, 
     0.5154508497187473, 1.3763819204711736`}, {-0.2153127302448091, 
     0.7935661446562, 1.3763819204711736`}, {-1.1003730866086285`, 
     0.7685661446562, 0.8769373639579967}, {-0.8637940861550183, 
     0.04045084971874738, 1.3500953648652168`}, {-0.30539809647716876`, 
     0.8090169943749475, 1.3500953648652168`}, {-1.0709838239940048`, 
     0.8090169943749475, 
     0.8769373639579967}, {-1.0709838239940048`, -0.8090169943749475, 
     0.8769373639579967}, {-0.30539809647716876`, -0.8090169943749475, 
     1.3500953648652168`}, {-0.8637940861550183, -0.04045084971874738, 
     1.3500953648652168`}, {-1.1003730866086285`, -0.7685661446562, 
     0.8769373639579967}, {0.43846868197899824`, -1.2685661446562, 
     0.8769373639579967}, {0.6750476824326084, -0.5404508497187474, 
     1.3500953648652168`}, {-0.22845600804778743`, -0.8340169943749474, 
     1.3500953648652168`}, {0.39091585616424057`, -1.2840169943749475`, 
     0.8769373639579967}, {1.3419723724593942`, 0.025, 0.8769373639579967}, {
     0.7226005082473661, 0.475, 1.3500953648652168`}, {
     0.7226005082473661, -0.475, 1.3500953648652168`}, {
     1.3419723724593942`, -0.025, 0.8769373639579967}, {0.39091585616424057`, 
     1.2840169943749475`, 0.8769373639579967}, {-0.22845600804778743`, 
     0.8340169943749474, 1.3500953648652168`}, {0.6750476824326084, 
     0.5404508497187474, 1.3500953648652168`}, {0.43846868197899824`, 
     1.2685661446562, 0.8769373639579967}, {
     0.9035036904803958, 1.3244678440936948`, 0}, {
     0.04755282581475768, 1.6025831390311474`, 0}, {0.021266270208800998`, 
     1.6025831390311474`, 0.042532540417602}, {0.40405913396721893`, 
     1.3244678440936948`, 0.808118267934438}, {0.4516119597819766, 
     1.3090169943749475`, 0.808118267934438}, {0.9247699606891968, 
     1.3090169943749475`, 
     0.042532540417602}, {-0.9804457789097771, 1.2685661446562, 
      0}, {-1.509452505973003, 0.5404508497187474, 0}, {-1.5175754983788257`, 
     0.5154508497187473, 0.042532540417602}, {-1.134782634620408, 
     0.7935661446562, 0.808118267934438}, {-1.1053933720057842`, 
     0.8340169943749474, 0.808118267934438}, {-0.9591795087009761, 
     1.2840169943749475`, 
     0.042532540417602}, {-1.509452505973003, -0.5404508497187474, 
      0}, {-0.9804457789097771, -1.2685661446562, 
      0}, {-0.9591795087009761, -1.2840169943749475`, 
     0.042532540417602}, {-1.1053933720057842`, -0.8340169943749474, 
     0.808118267934438}, {-1.134782634620408, -0.7935661446562, 
     0.808118267934438}, {-1.5175754983788257`, -0.5154508497187473, 
     0.042532540417602}, {0.04755282581475768, -1.6025831390311474`, 0}, {
     0.9035036904803958, -1.3244678440936948`, 0}, {
     0.9247699606891968, -1.3090169943749475`, 0.042532540417602}, {
     0.4516119597819766, -1.3090169943749475`, 0.808118267934438}, {
     0.40405913396721893`, -1.3244678440936948`, 0.808118267934438}, {
     0.021266270208800998`, -1.6025831390311474`, 0.042532540417602}, {
     1.5388417685876268`, -0.45, 0}, {1.5388417685876268`, 0.45, 0}, {
     1.530718776181804, 0.475, 0.042532540417602}, {1.3845049128769962`, 
     0.025, 0.808118267934438}, {1.3845049128769962`, -0.025, 
     0.808118267934438}, {1.530718776181804, -0.475, 
     0.042532540417602}, {-0.04755282581475768, 1.6025831390311474`, 
      0}, {-0.9035036904803958, 1.3244678440936948`, 
      0}, {-1.5388417685876268`, 0.45, 0}, {-1.5388417685876268`, -0.45, 
      0}, {-0.9035036904803958, -1.3244678440936948`, 
      0}, {-0.04755282581475768, -1.6025831390311474`, 0}, {
     0.9804457789097771, -1.2685661446562, 0}, {
     1.509452505973003, -0.5404508497187474, 0}, {
     1.509452505973003, 0.5404508497187474, 0}, {
     0.9804457789097771, 1.2685661446562, 
      0}, {-0.6881909602355868, -0.45, -1.3763819204711736`}, \
{-0.6881909602355868, 0.45, -1.3763819204711736`}, {-0.6406381344208291, 
     0.5154508497187473, -1.3763819204711736`}, {0.2153127302448091, 
     0.7935661446562, -1.3763819204711736`}, {0.29225481867419045`, 
     0.7685661446562, -1.3763819204711736`}, {0.8212615457374163, 
     0.04045084971874738, -1.3763819204711736`}, {
     0.8212615457374163, -0.04045084971874738, -1.3763819204711736`}, {
     0.29225481867419045`, -0.7685661446562, -1.3763819204711736`}, {
     0.2153127302448091, -0.7935661446562, -1.3763819204711736`}, \
{-0.6406381344208291, -0.5154508497187473, -1.3763819204711736`}, {
     0.8637940861550183, -0.04045084971874738, -1.3500953648652168`}, {
     1.1003730866086283`, -0.7685661446562, -0.8769373639579967}, {
     1.0709838239940046`, -0.8090169943749475, -0.8769373639579967}, {
     0.30539809647716876`, -0.8090169943749475, -1.3500953648652168`}, {
     0.30539809647716876`, 0.8090169943749475, -1.3500953648652168`}, {
     1.0709838239940046`, 0.8090169943749475, -0.8769373639579967}, {
     1.1003730866086283`, 0.7685661446562, -0.8769373639579967}, {
     0.8637940861550183, 
     0.04045084971874738, -1.3500953648652168`}, {-0.6750476824326084, 
     0.5404508497187474, -1.3500953648652168`}, {-0.43846868197899824`, 
     1.2685661446562, -0.8769373639579967}, {-0.39091585616424057`, 
     1.2840169943749475`, -0.8769373639579967}, {0.22845600804778743`, 
     0.8340169943749474, -1.3500953648652168`}, {-0.7226005082473662, -0.475, \
-1.3500953648652168`}, {-1.3419723724593942`, -0.025, -0.8769373639579967}, \
{-1.3419723724593942`, 0.025, -0.8769373639579967}, {-0.7226005082473662, 
     0.475, -1.3500953648652168`}, {
     0.22845600804778743`, -0.8340169943749474, -1.3500953648652168`}, \
{-0.39091585616424057`, -1.2840169943749475`, -0.8769373639579967}, \
{-0.43846868197899824`, -1.2685661446562, -0.8769373639579967}, \
{-0.6750476824326084, -0.5404508497187474, -1.3500953648652168`}, \
{-0.40405913396721893`, -1.3244678440936948`, -0.808118267934438}, \
{-0.021266270208800998`, -1.6025831390311474`, -0.042532540417602}, \
{-0.9247699606891968, -1.3090169943749475`, -0.042532540417602}, \
{-0.4516119597819766, -1.3090169943749475`, -0.808118267934438}, {
     1.1347826346204077`, -0.7935661446562, -0.808118267934438}, {
     1.5175754983788257`, -0.5154508497187473, -0.042532540417602}, {
     0.9591795087009761, -1.2840169943749475`, -0.042532540417602}, {
     1.105393372005784, -0.8340169943749474, -0.808118267934438}, {
     1.105393372005784, 0.8340169943749474, -0.808118267934438}, {
     0.9591795087009761, 1.2840169943749475`, -0.042532540417602}, {
     1.5175754983788257`, 0.5154508497187473, -0.042532540417602}, {
     1.1347826346204077`, 
     0.7935661446562, -0.808118267934438}, {-0.4516119597819766, 
     1.3090169943749475`, -0.808118267934438}, {-0.9247699606891968, 
     1.3090169943749475`, -0.042532540417602}, {-0.021266270208800998`, 
     1.6025831390311474`, -0.042532540417602}, {-0.40405913396721893`, 
     1.3244678440936948`, -0.808118267934438}, {-1.3845049128769962`, -0.025, \
-0.808118267934438}, {-1.530718776181804, -0.475, -0.042532540417602}, \
{-1.530718776181804, 0.475, -0.042532540417602}, {-1.3845049128769962`, 0.025,
      -0.808118267934438}}], {
    Polygon3DBox[{{31, 32, 33, 34, 35, 36, 37, 38, 39, 40}, {41, 42, 32, 31, 
      43, 44}, {45, 46, 34, 33, 47, 48}, {49, 50, 36, 35, 51, 52}, {53, 54, 
      38, 37, 55, 56}, {57, 58, 40, 39, 59, 60}, {61, 62, 63, 64, 65, 66}, {
      67, 68, 69, 70, 71, 72}, {73, 74, 75, 76, 77, 78}, {79, 80, 81, 82, 83, 
      84}, {85, 86, 87, 88, 89, 90}, {91, 92, 72, 71, 44, 43, 58, 57, 64, 
      63}, {93, 94, 78, 77, 48, 47, 42, 41, 70, 69}, {95, 96, 84, 83, 52, 51, 
      46, 45, 76, 75}, {97, 98, 90, 89, 56, 55, 50, 49, 82, 81}, {99, 100, 66,
       65, 60, 59, 54, 53, 88, 87}, {101, 102, 103, 104, 105, 106, 107, 108, 
      109, 110}, {108, 107, 111, 112, 113, 114}, {106, 105, 115, 116, 117, 
      118}, {104, 103, 119, 120, 121, 122}, {102, 101, 123, 124, 125, 126}, {
      110, 109, 127, 128, 129, 130}, {131, 132, 96, 95, 133, 134}, {135, 136, 
      98, 97, 137, 138}, {139, 140, 100, 99, 141, 142}, {143, 144, 92, 91, 
      145, 146}, {147, 148, 94, 93, 149, 150}, {128, 127, 114, 113, 138, 137, 
      80, 79, 132, 131}, {112, 111, 118, 117, 142, 141, 86, 85, 136, 135}, {
      116, 115, 122, 121, 146, 145, 62, 61, 140, 139}, {120, 119, 126, 125, 
      150, 149, 68, 67, 144, 143}, {124, 123, 130, 129, 134, 133, 74, 73, 148,
       147}}], Polygon3DBox[{{96, 132, 79, 84}, {145, 91, 63, 62}, {114, 127, 
     109, 108}, {122, 115, 105, 104}, {83, 82, 49, 52}, {65, 64, 57, 60}, {50,
      55, 37, 36}, {54, 59, 39, 38}, {135, 138, 113, 112}, {139, 142, 117, 
     116}, {147, 150, 125, 124}, {130, 123, 101, 110}, {126, 119, 103, 102}, {
     89, 88, 53, 56}, {137, 97, 81, 80}, {100, 140, 61, 66}, {118, 111, 107, 
     106}, {133, 95, 75, 74}, {92, 144, 67, 72}, {94, 148, 73, 78}, {149, 93, 
     69, 68}, {98, 136, 85, 90}, {141, 99, 87, 86}, {42, 47, 33, 32}, {77, 76,
      45, 48}, {71, 70, 41, 44}, {131, 134, 129, 128}, {143, 146, 121, 120}, {
     46, 51, 35, 34}, {58, 43, 31, 40}}]}]]], "Output",
 CellChangeTimes->{
  3.4994717488236823`*^9, {3.499471795563748*^9, 3.49947182563379*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Truncate", "[", 
   RowBox[{
    RowBox[{"PolyhedronData", "[", 
     RowBox[{"\"\<Octahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], ",", 
    RowBox[{"1", "/", "2"}]}], "]"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.499471947973961*^9, 3.49947196144398*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
     0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
     0, -2^Rational[-1, 2], 0}, {2^Rational[-1, 2], 0, 0}, {
     0, Rational[-1, 2] 2^Rational[-1, 2], Rational[1, 2] 
      2^Rational[-1, 2]}, {
     Rational[1, 2] 2^Rational[-1, 2], Rational[-1, 2] 2^Rational[-1, 2], 
      0}, {Rational[1, 2] 2^Rational[-1, 2], 0, Rational[1, 2] 
      2^Rational[-1, 2]}, {
     Rational[1, 2] 2^Rational[-1, 2], Rational[1, 2] 2^Rational[-1, 2], 0}, {
     0, Rational[1, 2] 2^Rational[-1, 2], Rational[1, 2] 2^Rational[-1, 2]}, {
     Rational[-1, 2] 2^Rational[-1, 2], Rational[1, 2] 2^Rational[-1, 2], 
      0}, {Rational[-1, 2] 2^Rational[-1, 2], 0, Rational[1, 2] 
      2^Rational[-1, 2]}, {
     Rational[-1, 2] 2^Rational[-1, 2], Rational[-1, 2] 2^Rational[-1, 2], 
      0}, {Rational[-1, 2] 2^Rational[-1, 2], 0, Rational[-1, 2] 
      2^Rational[-1, 2]}, {
     0, Rational[-1, 2] 2^Rational[-1, 2], Rational[-1, 2] 
      2^Rational[-1, 2]}, {
     Rational[1, 2] 2^Rational[-1, 2], 0, Rational[-1, 2] 
      2^Rational[-1, 2]}, {
     0, Rational[1, 2] 2^Rational[-1, 2], Rational[-1, 2] 
      2^Rational[-1, 2]}}, {{-0.7071067811865475, 0, 0}, {
     0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
     0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
     0.7071067811865475, 0, 0}, {
     0, -0.35355339059327373`, 0.35355339059327373`}, {
     0.35355339059327373`, -0.35355339059327373`, 0}, {
     0.35355339059327373`, 0, 0.35355339059327373`}, {
     0.35355339059327373`, 0.35355339059327373`, 0}, {
     0, 0.35355339059327373`, 0.35355339059327373`}, {-0.35355339059327373`, 
      0.35355339059327373`, 0}, {-0.35355339059327373`, 0, 
      0.35355339059327373`}, {-0.35355339059327373`, -0.35355339059327373`, 
      0}, {-0.35355339059327373`, 0, -0.35355339059327373`}, {
     0, -0.35355339059327373`, -0.35355339059327373`}, {
     0.35355339059327373`, 0, -0.35355339059327373`}, {
     0, 0.35355339059327373`, -0.35355339059327373`}}], {
    Polygon3DBox[{{7, 8, 9}, {9, 10, 11}, {11, 12, 13}, {13, 14, 7}, {14, 15, 
     16}, {16, 17, 8}, {15, 12, 18}, {17, 18, 10}}], 
    Polygon3DBox[{{15, 14, 13, 12}, {18, 12, 11, 10}, {18, 17, 16, 15}, {11, 
     13, 7, 9}, {14, 16, 8, 7}, {17, 10, 9, 8}}]}]]], "Output",
 CellChangeTimes->{3.499471965763986*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Octahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4994721409142313`*^9, 3.49947214700424*^9}, {
  3.49947222576435*^9, 3.499472226394351*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
     0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
     0, -2^Rational[-1, 2], 0}, {2^Rational[-1, 2], 0, 0}, {
     0, Rational[-1, 3] 2^Rational[-1, 2], Rational[1, 3] 2^Rational[1, 2]}, {
     0, Rational[-1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[-1, 2]}, {
     Rational[1, 3] 2^Rational[-1, 2], Rational[-1, 3] 2^Rational[1, 2], 0}, {
     Rational[1, 3] 2^Rational[1, 2], Rational[-1, 3] 2^Rational[-1, 2], 0}, {
     Rational[1, 3] 2^Rational[1, 2], 0, Rational[1, 3] 2^Rational[-1, 2]}, {
     Rational[1, 3] 2^Rational[-1, 2], 0, Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[-1, 2], 0}, {
     Rational[1, 3] 2^Rational[-1, 2], Rational[1, 3] 2^Rational[1, 2], 0}, {
     0, Rational[1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[-1, 2]}, {
     0, Rational[1, 3] 2^Rational[-1, 2], Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[-1, 3] 2^Rational[-1, 2], Rational[1, 3] 2^Rational[1, 2], 0}, {
     Rational[-1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[-1, 2], 0}, {
     Rational[-1, 3] 2^Rational[1, 2], 0, Rational[1, 3] 2^Rational[-1, 2]}, {
     Rational[-1, 3] 2^Rational[-1, 2], 0, Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[-1, 3] 2^Rational[1, 2], Rational[-1, 3] 2^Rational[-1, 2], 
      0}, {Rational[-1, 3] 2^Rational[-1, 2], Rational[-1, 3] 
      2^Rational[1, 2], 0}, {
     Rational[-1, 3] 2^Rational[1, 2], 0, Rational[-1, 3] 
      2^Rational[-1, 2]}, {
     Rational[-1, 3] 2^Rational[-1, 2], 0, Rational[-1, 3] 
      2^Rational[1, 2]}, {
     0, Rational[-1, 3] 2^Rational[-1, 2], Rational[-1, 3] 
      2^Rational[1, 2]}, {
     0, Rational[-1, 3] 2^Rational[1, 2], Rational[-1, 3] 
      2^Rational[-1, 2]}, {
     Rational[1, 3] 2^Rational[-1, 2], 0, Rational[-1, 3] 2^Rational[1, 2]}, {
     Rational[1, 3] 2^Rational[1, 2], 0, Rational[-1, 3] 2^Rational[-1, 2]}, {
     0, Rational[1, 3] 2^Rational[1, 2], Rational[-1, 3] 2^Rational[-1, 2]}, {
     0, Rational[1, 3] 2^Rational[-1, 2], Rational[-1, 3] 
      2^Rational[1, 2]}}, {{-0.7071067811865475, 0, 0}, {
     0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
     0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
     0.7071067811865475, 0, 0}, {
     0, -0.2357022603955158, 0.4714045207910317}, {
     0, -0.4714045207910317, 0.2357022603955158}, {
     0.2357022603955158, -0.4714045207910317, 0}, {
     0.4714045207910317, -0.2357022603955158, 0}, {
     0.4714045207910317, 0, 0.2357022603955158}, {
     0.2357022603955158, 0, 0.4714045207910317}, {
     0.4714045207910317, 0.2357022603955158, 0}, {
     0.2357022603955158, 0.4714045207910317, 0}, {
     0, 0.4714045207910317, 0.2357022603955158}, {
     0, 0.2357022603955158, 0.4714045207910317}, {-0.2357022603955158, 
      0.4714045207910317, 0}, {-0.4714045207910317, 0.2357022603955158, 
      0}, {-0.4714045207910317, 0, 0.2357022603955158}, {-0.2357022603955158, 
      0, 0.4714045207910317}, {-0.4714045207910317, -0.2357022603955158, 
      0}, {-0.2357022603955158, -0.4714045207910317, 0}, {-0.4714045207910317,
       0, -0.2357022603955158}, {-0.2357022603955158, 
      0, -0.4714045207910317}, {
     0, -0.2357022603955158, -0.4714045207910317}, {
     0, -0.4714045207910317, -0.2357022603955158}, {
     0.2357022603955158, 0, -0.4714045207910317}, {
     0.4714045207910317, 0, -0.2357022603955158}, {
     0, 0.4714045207910317, -0.2357022603955158}, {
     0, 0.2357022603955158, -0.4714045207910317}}], {
    Polygon3DBox[{{7, 8, 9, 10, 11, 12}, {12, 11, 13, 14, 15, 16}, {16, 15, 
     17, 18, 19, 20}, {20, 19, 21, 22, 8, 7}, {22, 21, 23, 24, 25, 26}, {26, 
     25, 27, 28, 10, 9}, {24, 23, 18, 17, 29, 30}, {28, 27, 30, 29, 14, 13}}],
     Polygon3DBox[{{23, 21, 19, 18}, {29, 17, 15, 14}, {30, 27, 25, 24}, {16, 
     20, 7, 12}, {22, 26, 9, 8}, {28, 13, 11, 10}}]}]]], "Output",
 CellChangeTimes->{3.4994721487142425`*^9, 3.499472228614354*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Hexahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], ",", 
   RowBox[{"1", "-", 
    FractionBox["1", 
     SqrtBox["2"]]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.499471986424015*^9, 3.499472056864114*^9}, {
  3.499472197814311*^9, 3.499472205714322*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
     Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}, {
     Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (1 - 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2]), 
      Rational[-1, 2] 2^Rational[-1, 2] + 
      Rational[1, 2] (-1 + 2^Rational[-1, 2])}}, CompressedData["
1:eJxTTMoPSmViYGBQAGJmBhh4sJ9I2p4AH10cnSbWPFz6MOQN3v+ZWdl0Cpc4
Ln37cejbj64PjY8ujtN9uOzH5d7B4i5i7Uczn2R34XAnuj0YNC55HO4nqA8A
Ntzbxw==
    "]], {
    Polygon3DBox[{{9, 10, 11, 12, 13, 14, 15, 16}, {16, 15, 17, 18, 19, 20, 
     21, 22}, {22, 21, 23, 24, 25, 26, 10, 9}, {26, 25, 27, 28, 29, 30, 12, 
     11}, {28, 27, 24, 23, 20, 19, 31, 32}, {30, 29, 32, 31, 18, 17, 14, 
     13}}], Polygon3DBox[{{32, 29, 28}, {30, 13, 12}, {27, 25, 24}, {26, 11, 
     10}, {31, 19, 18}, {17, 15, 14}, {23, 21, 20}, {22, 9, 
     16}}]}]]], "Output",
 CellChangeTimes->{3.499472017034058*^9, 3.499472060544119*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4994721023241773`*^9, 3.4994721091241865`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[1, 2] (Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (1 + 5^Rational[1, 2])),
       Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0])}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0])}, {
     Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^Rational[1, 2]), 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (1 + 5^Rational[1, 2])),
       Rational[
       1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {(
       Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^Rational[1, 2]), 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[1, 2] + 
       Rational[1, 4] (1 + 5^Rational[1, 2])), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] (Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 8] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] (Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] ((1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2]), 0, 
      Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0])}, {
     Rational[1, 2] ((Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[1, 8] (1 + 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0])}, {
     Rational[1, 2] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0])}, {
     Rational[1, 2] ((Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[1, 2] (Rational[1, 2] + Rational[1, 4] (1 + 5^Rational[1, 2])),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 4] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] (Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[1, 2] (Rational[-1, 2] + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 2] (Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0]), 
      Rational[1, 2] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 4] (-1 - 5^Rational[1, 2])), 
      Rational[1, 2] (Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[1, 2] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0]), 0, 
      Rational[1, 2] ((Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
      0, Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[1, 2] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[-1, 4] + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 4] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0], Rational[1, 4] + 
      Rational[1, 8] (1 + 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 8] (-3 - 5^Rational[1, 2]) + 
      Rational[1, 8] (-1 - 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[1, 2] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Rational[1, 2] Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 8] (1 + 5^Rational[1, 2]) + 
      Rational[1, 8] (3 + 5^Rational[1, 2]), 
      Rational[1, 2] Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 2] 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116068`}, \
{-0.6881909602355868, 0.5, -1.1135163644116068`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
     0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 
     1.3090169943749475`, -0.2628655560595668}, {-0.9008536623235968, 
     0.6545084971874737, -0.6881909602355868}, {-0.6881909602355868, 
      0, -1.1135163644116068`}, {-0.9008536623235968, -0.6545084971874737, \
-0.6881909602355868}, {-1.2449491424413903`, -0.4045084971874737, 
     0.}, {-1.2449491424413903`, 0.4045084971874737, 0.}, {1.24494914244139, 
     0.4045084971874737, 0.}, {0.9008536623235968, 0.6545084971874737, 
     0.6881909602355867}, {0.6881909602355868, 0, 1.1135163644116066`}, {
     0.9008536623235968, -0.6545084971874737, 0.6881909602355867}, {
     1.24494914244139, -0.4045084971874737, 0.}, {
     0.21266270208801, -0.6545084971874737, 
     1.1135163644116066`}, {-0.34409548011779334`, -1.0590169943749475`, 
     0.6881909602355867}, {0., -1.3090169943749475`, 0.}, {
     0.7694208842938133, -1.0590169943749475`, 0.}, {0.21266270208801, 
     0.6545084971874737, 1.1135163644116066`}, {-0.5567581822058034, 
     0.4045084971874737, 
     1.1135163644116066`}, {-0.5567581822058034, -0.4045084971874737, 
     1.1135163644116066`}, {0.7694208842938133, 1.0590169943749475`, 0.}, {0.,
      1.3090169943749475`, 0.}, {-0.34409548011779334`, 1.0590169943749475`, 
     0.6881909602355867}, {1.1135163644116068`, 0, -0.6881909602355868}, {
     0.5567581822058034, 0.4045084971874737, -1.1135163644116068`}, {
     0.34409548011779334`, 1.0590169943749475`, -0.6881909602355868}, {
     0.34409548011779334`, -1.0590169943749475`, -0.6881909602355868}, {
     0.5567581822058034, -0.4045084971874737, -1.1135163644116068`}, \
{-0.21266270208801, 
     0.6545084971874737, -1.1135163644116068`}, {-0.7694208842938134, 
     1.0590169943749475`, 
     0.}, {-0.21266270208801, -0.6545084971874737, -1.1135163644116068`}, \
{-0.7694208842938134, -1.0590169943749475`, 
     0.}, {-1.1135163644116068`, 0, 
      0.6881909602355867}, {-1.1135163644116068`, 0, 
      0.6881909602355867}, {-1.2449491424413903`, 0.4045084971874737, 
     0.}, {-1.2449491424413903`, -0.4045084971874737, 0.}, {
     1.1135163644116068`, 0, -0.6881909602355868}, {1.24494914244139, 
     0.4045084971874737, 0.}, {1.24494914244139, -0.4045084971874737, 
     0.}, {-0.7694208842938134, -1.0590169943749475`, 0.}, {
     0., -1.3090169943749475`, 
     0.}, {-0.34409548011779334`, -1.0590169943749475`, 
     0.6881909602355867}, {-0.7694208842938134, 1.0590169943749475`, 
     0.}, {-0.34409548011779334`, 1.0590169943749475`, 0.6881909602355867}, {
     0., 1.3090169943749475`, 0.}, {0.7694208842938133, -1.0590169943749475`, 
     0.}, {0.9008536623235968, -0.6545084971874737, 0.6881909602355867}, {
     0.7694208842938133, 1.0590169943749475`, 0.}, {0.9008536623235968, 
     0.6545084971874737, 
     0.6881909602355867}, {-0.5567581822058034, -0.4045084971874737, 
     1.1135163644116066`}, {0.21266270208801, -0.6545084971874737, 
     1.1135163644116066`}, {-0.5567581822058034, 0.4045084971874737, 
     1.1135163644116066`}, {0.21266270208801, 0.6545084971874737, 
     1.1135163644116066`}, {-0.21266270208801, -0.6545084971874737, \
-1.1135163644116068`}, {-0.9008536623235968, -0.6545084971874737, \
-0.6881909602355868}, {-0.21266270208801, 
     0.6545084971874737, -1.1135163644116068`}, {-0.9008536623235968, 
     0.6545084971874737, -0.6881909602355868}, {
     0.5567581822058034, -0.4045084971874737, -1.1135163644116068`}, {
     0.5567581822058034, 0.4045084971874737, -1.1135163644116068`}, {
     0.34409548011779334`, -1.0590169943749475`, -0.6881909602355868}, {
     0.34409548011779334`, 1.0590169943749475`, -0.6881909602355868}}], {
    Polygon3DBox[{{21, 22, 23, 24, 25}, {26, 27, 28, 29, 30}, {29, 31, 32, 33,
      34}, {28, 35, 36, 37, 31}, {27, 38, 39, 40, 35}, {26, 41, 42, 43, 38}, {
     30, 34, 44, 45, 41}, {39, 43, 46, 21, 47}, {42, 45, 48, 22, 46}, {44, 33,
      49, 23, 48}, {32, 37, 50, 24, 49}, {36, 40, 47, 25, 50}}], 
    Polygon3DBox[{{51, 52, 53}, {54, 55, 56}, {57, 58, 59}, {60, 61, 62}, {63,
      56, 64}, {65, 66, 55}, {67, 59, 68}, {61, 69, 70}, {71, 72, 22}, {73, 
     22, 74}, {68, 64, 28}, {70, 28, 66}, {75, 76, 54}, {57, 53, 72}, {60, 74,
      52}, {51, 67, 69}, {71, 75, 77}, {73, 78, 76}, {77, 63, 58}, {78, 62, 
     65}}]}]]], "Output",
 CellChangeTimes->{3.49947211153419*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Truncate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Dodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], ",", 
   FractionBox[
    RowBox[{"5", "-", 
     SqrtBox["5"]}], "10"]}], "]"}]], "Input",
 CellChangeTimes->{{3.4994721023241773`*^9, 3.4994721091241865`*^9}, {
  3.499472300734455*^9, 3.499472313974474*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 20] (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 20] (-5 + 5^Rational[1, 2]) + 
      Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + 
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 20] (5 - 5^Rational[1, 2]) + 
      Rational[1, 2] (-1 + Rational[1, 10] (5 - 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 2] (-1 + Rational[1, 10] (5 - 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 20] (-5 + 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[-1, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {-(1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {-(1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[-1, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 
       5^Rational[1, 2]), (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 20] (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 20] (-5 + 5^Rational[1, 2]) + 
      Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 20] (5 - 5^Rational[1, 2]) + 
      Rational[1, 2] (-1 + Rational[1, 10] (5 - 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 2] (-1 + 
        Rational[1, 10] (5 - 5^Rational[1, 2])), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 20] (-5 + 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^
       Rational[1, 2]), (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 4] + 
         Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 2] (-1 + Rational[1, 10] (5 - 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 20] (-5 + 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (-3 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-3 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (-3 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-3 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (-3 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-3 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-3 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (-3 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 4] + 
         Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 20] (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {(1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {(1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2]))}, {
     Rational[1, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (3 + 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 4] (3 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (3 + 5^Rational[1, 2]) + 
      Rational[1, 4] (3 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (3 + 5^Rational[1, 2]) + 
      Rational[1, 4] (3 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 4] (3 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (3 + 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (5 - 5^
        Rational[1, 2]) (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 0, 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[1, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      0, (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {(
         Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 10] (5 - 5^
        Rational[1, 2]) (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2] + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (3 + 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 4] (3 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-3 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[1, 10] (Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (-3 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[1, 10] (5 - 5^
        Rational[1, 2]) (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2] + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
       Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(
         Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 20] (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (3 + 5^Rational[1, 2]) + 
      Rational[1, 4] (1 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (5 - 5^Rational[1, 2]) (1 + 5^Rational[1, 2]) + 
      Rational[1, 4] (3 + 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[-1, 20] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 20] (-5 + 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 2] (-1 + Rational[1, 10] (5 - 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (-1 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-3 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 40] (-3 - 5^Rational[1, 2]) (5 - 5^Rational[1, 2]) + 
      Rational[1, 4] (-1 - 5^Rational[1, 2]) (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])), (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Rational[-1, 10] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] (5 - 5^
        Rational[1, 2]) + (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] (
        1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {-(1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] (1 + Rational[1, 10] (-5 + 5^Rational[1, 2])) + 
      Rational[1, 10] (5 - 5^Rational[1, 2]) Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, Rational[1, 10] (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] (5 - 5^Rational[1, 2]) + (1 + 
        Rational[1, 10] (-5 + 5^Rational[1, 2])) 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116068`}, \
{-0.6881909602355868, 0.5, -1.1135163644116068`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
     0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 
     1.3090169943749475`, -0.2628655560595668}, {-0.9959593139531121, 
     0.7236067977499789, -0.4979796569765561}, {-0.8057480106940814, 
     0.5854101966249684, -0.8784022634946175}, {-0.6881909602355868, 
     0.22360679774997896`, -1.1135163644116068`}, {-0.6881909602355868, \
-0.22360679774997896`, -1.1135163644116068`}, {-0.8057480106940814, \
-0.5854101966249685, -0.8784022634946175}, {-0.9959593139531121, \
-0.7236067977499789, -0.4979796569765561}, {-1.186170617212143, \
-0.5854101966249684, -0.11755705045849463`}, {-1.3037276676706375`, \
-0.223606797749979, 0.11755705045849463`}, {-1.3037276676706375`, 
     0.22360679774997896`, 0.11755705045849463`}, {-1.186170617212143, 
     0.5854101966249684, -0.11755705045849463`}, {1.3037276676706373`, 
     0.22360679774997896`, -0.11755705045849463`}, {1.1861706172121427`, 
     0.5854101966249684, 0.11755705045849463`}, {0.995959313953112, 
     0.7236067977499789, 0.497979656976556}, {0.8057480106940813, 
     0.5854101966249684, 0.8784022634946174}, {0.6881909602355868, 
     0.22360679774997896`, 1.1135163644116066`}, {
     0.6881909602355868, -0.22360679774997896`, 1.1135163644116066`}, {
     0.8057480106940813, -0.5854101966249685, 0.8784022634946174}, {
     0.995959313953112, -0.7236067977499789, 0.497979656976556}, {
     1.1861706172121427`, -0.5854101966249684, 0.11755705045849463`}, {
     1.3037276676706373`, -0.223606797749979, -0.11755705045849463`}, {
     0.42532540417601994`, -0.5854101966249685, 1.1135163644116066`}, {
     0., -0.7236067977499789, 
     1.1135163644116066`}, {-0.3077683537175253, -0.9472135954999579, 
     0.8784022634946174}, {-0.38042260651806137`, -1.1708203932499368`, 
     0.497979656976556}, {-0.19021130325903068`, -1.3090169943749475`, 
     0.11755705045849463`}, {
     0.19021130325903068`, -1.3090169943749475`, -0.11755705045849463`}, {
     0.6155367074350506, -1.1708203932499368`, -0.11755705045849463`}, {
     0.9233050611525759, -0.9472135954999579, 0.11755705045849463`}, {
     0.42532540417601994`, 0.5854101966249684, 1.1135163644116066`}, {0., 
     0.7236067977499789, 1.1135163644116066`}, {-0.42532540417601994`, 
     0.5854101966249684, 1.1135163644116066`}, {-0.6881909602355868, 
     0.22360679774997896`, 
     1.1135163644116066`}, {-0.6881909602355868, -0.223606797749979, 
     1.1135163644116066`}, {-0.42532540417601994`, -0.5854101966249684, 
     1.1135163644116066`}, {0.9233050611525759, 0.9472135954999579, 
     0.11755705045849463`}, {0.6155367074350506, 
     1.1708203932499368`, -0.11755705045849463`}, {0.19021130325903068`, 
     1.3090169943749475`, -0.11755705045849463`}, {-0.19021130325903068`, 
     1.3090169943749475`, 0.11755705045849463`}, {-0.38042260651806137`, 
     1.1708203932499368`, 0.497979656976556}, {-0.3077683537175253, 
     0.9472135954999579, 0.8784022634946174}, {
     1.2310734148701012`, 0, -0.4979796569765561}, {
     0.9959593139531122, 0, -0.8784022634946175}, {0.6881909602355868, 
     0.22360679774997896`, -1.1135163644116068`}, {0.42532540417601994`, 
     0.5854101966249684, -1.1135163644116068`}, {0.3077683537175253, 
     0.9472135954999579, -0.8784022634946175}, {0.38042260651806137`, 
     1.1708203932499368`, -0.4979796569765561}, {
     0.38042260651806137`, -1.1708203932499368`, -0.4979796569765561}, {
     0.3077683537175253, -0.9472135954999579, -0.8784022634946175}, {
     0.42532540417601994`, -0.5854101966249684, -1.1135163644116068`}, {
     0.6881909602355868, -0.223606797749979, -1.1135163644116068`}, {0., 
     0.7236067977499789, -1.1135163644116068`}, {-0.42532540417601994`, 
     0.5854101966249684, -1.1135163644116068`}, {-0.923305061152576, 
     0.9472135954999579, -0.11755705045849463`}, {-0.6155367074350506, 
     1.1708203932499368`, 0.11755705045849463`}, {
     0., -0.7236067977499789, -1.1135163644116068`}, {-0.42532540417601994`, \
-0.5854101966249685, -1.1135163644116068`}, {-0.6155367074350506, \
-1.1708203932499368`, 
     0.11755705045849463`}, {-0.923305061152576, -0.9472135954999579, \
-0.11755705045849463`}, {-0.9959593139531122, 0, 
      0.8784022634946174}, {-1.2310734148701012`, 0, 0.497979656976556}}], {
    Polygon3DBox[{{21, 22, 23, 24, 25, 26, 27, 28, 29, 30}, {31, 32, 33, 34, 
     35, 36, 37, 38, 39, 40}, {38, 37, 41, 42, 43, 44, 45, 46, 47, 48}, {36, 
     35, 49, 50, 51, 52, 53, 54, 42, 41}, {34, 33, 55, 56, 57, 58, 59, 60, 50,
      49}, {32, 31, 61, 62, 63, 64, 65, 66, 56, 55}, {40, 39, 48, 47, 67, 68, 
     69, 70, 62, 61}, {58, 57, 66, 65, 71, 72, 22, 21, 73, 74}, {64, 63, 70, 
     69, 75, 76, 24, 23, 72, 71}, {68, 67, 46, 45, 77, 78, 26, 25, 76, 75}, {
     44, 43, 54, 53, 79, 80, 28, 27, 78, 77}, {52, 51, 60, 59, 74, 73, 30, 29,
      80, 79}}], 
    Polygon3DBox[{{80, 29, 28}, {61, 31, 40}, {77, 45, 44}, {74, 59, 58}, {48,
      39, 38}, {55, 33, 32}, {54, 43, 42}, {60, 51, 50}, {76, 25, 24}, {72, 
     23, 22}, {41, 37, 36}, {49, 35, 34}, {70, 63, 62}, {78, 27, 26}, {73, 21,
      30}, {79, 53, 52}, {75, 69, 68}, {71, 65, 64}, {67, 47, 46}, {66, 57, 
     56}}]}]]], "Output",
 CellChangeTimes->{3.4994723179244795`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stellation", "Section",
 CellChangeTimes->{{3.499475301835992*^9, 3.4994753045859957`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.499475307906*^9, 3.4994753083460007`*^9}}],

Cell[BoxData[{"\:661f\:578b\:591a\:9762\:4f53\:306e\:9762\:306f\:5143\:306e\
\:591a\:9762\:4f53\:306e\:9762\:5e73\:9762\:72b6\:306b\:306a\:3051\:308c\:3070\
\:306a\:3089\:306a\:3044\:3002", "\n", "\:3059\:3079\:3066\:306e\:9762\:3092\
\:69cb\:6210\:3059\:308b\:9818\:57df\:306f\:5404\:5e73\:9762\:3067\:540c\:3058\
\:3067\:306a\:3051\:308c\:3070\:306a\:3089\:306a\:3044\:3002", "\n", "\:5e73\
\:9762\:306b\:542b\:307e\:308c\:308b\:9818\:57df\:306f\:5143\:306e\:591a\:9762\
\:4f53\:306e\:9762\:3068\:540c\:3058\:56de\:8ee2\:5bfe\:79f0\:6027\:3092\:6301\
\:305f\:306a\:3051\:308c\:3070\:306a\:3089\:306a\:3044\:3002", "\n", "\:5e73\
\:9762\:306b\:542b\:307e\:308c\:308b\:9818\:57df\:306f\:5b8c\:6210\:3057\:305f\
\:661f\:578b\:3067\:898b\:3048\:306a\:3051\:308c\:3070\:306a\:3089\:306a\:3044\
\:3002", "\n", "\:93e1\:50cf\:306e\:7d44\:307f\:5408\:308f\:305b\:3067\:306f\
\:306a\:30442\:3064\:306e\:661f\:578b\:306e\:9762\:3068\:9762\:304c\:63a5\
\:3057\:306a\:3044\:548c\:306f\:8a31\:3055\:306a\:3044\:3002", "\n"}], "Input"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.4994759151568503`*^9, 3.499475915606851*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stellate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Dodecahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
      Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 1, 0], Rational[1, 4] (3 + 5^Rational[1, 2]),
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 3, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[1, 2],
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
       Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
      Rational[1, 2], Rational[
      1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
      Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
      Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
      0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
      Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Root[1 - 20 #^2 + 80 #^4& , 3, 0], Rational[1, 4] (1 + 5^Rational[1, 2]),
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
       Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
      Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
      1 - 20 #^2 + 80 #^4& , 2, 0]}, {
     Rational[2, 5] ((-2) (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       2 Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
      Rational[2, 5] (Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
       Rational[1, 4] (1 + 5^Rational[1, 2])), 
      Rational[2, 5] (2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] (
       2 (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] + 
       2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
         Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^Rational[1, 2]), 
      Rational[2, 5] (Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
       Rational[1, 4] (1 + 5^Rational[1, 2])), 
      Rational[2, 5] (
       2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[2, 5] (Rational[-1, 2] + 
       Rational[1, 2] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 2] (-1 - 5^Rational[1, 2])), 
      Rational[2, 5] (
       2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] (
       2 (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 2 Root[1 - 20 #^2 + 80 #^4& , 2, 0]),
       Rational[2, 5] (Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
       Rational[1, 4] (1 + 5^Rational[1, 2])), 
      2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
       Rational[1, 2]}, {
     Rational[2, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
      Rational[2, 5] (Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 2] (3 + 5^Rational[1, 2])), 
      Rational[2, 5] (
       2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[2, 5] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[2, 5] (2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^
        Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[2, 5] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 2] (-1 - 5^Rational[1, 2])), 
      Rational[2, 5] (2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[2, 5] (Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 2] (3 + 5^Rational[1, 2])), 
      Rational[2, 5] (2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 
        5] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + (
         Rational[1, 10] (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[2, 5] (Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
       Rational[1, 4] (1 + 5^Rational[1, 2])), 2 
      Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
     Rational[2, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
        Rational[1, 2] + 
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0] + Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
      Rational[2, 5] (Rational[-1, 2] + 
       Rational[1, 2] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 2] (-1 - 5^Rational[1, 2])), 
      Rational[2, 5] (2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0] + Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]),
       Rational[2, 5] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
       Rational[1, 2] (-1 - 5^Rational[1, 2])), 
      Rational[2, 5] (
       2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
     Rational[2, 5] (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 5 #^2 + 5 #^4& , 1, 0] + Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
       Root[1 - 20 #^2 + 80 #^4& , 1, 0] + Root[1 - 20 #^2 + 80 #^4& , 2, 0]),
       Rational[2, 5] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
       Rational[1, 4] (3 + 5^Rational[1, 2])), 
      Rational[2, 5] (
       2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
       Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
       2 Root[1 - 20 #^2 + 80 #^4& , 3, 0])}}, {{-1.3763819204711736`, 0, 
      0.2628655560595668}, {
     1.3763819204711736`, 
      0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`, 
     0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
     0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
     0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
     0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
     1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
     1.1135163644116066`}, {-0.6881909602355868, -0.5, -1.1135163644116066`}, \
{-0.6881909602355868, 0.5, -1.1135163644116066`}, {0.6881909602355868, -0.5, 
     1.1135163644116066`}, {0.6881909602355868, 0.5, 1.1135163644116066`}, {
     0.85065080835204, 
      0, -1.1135163644116066`}, {-1.1135163644116066`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116066`, 
     0.8090169943749475, -0.2628655560595668}, {-0.8506508083520399, 0, 
      1.1135163644116066`}, {
     0.2628655560595668, -0.8090169943749475, -1.1135163644116066`}, {
     0.2628655560595668, 0.8090169943749475, -1.1135163644116066`}, {
     0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
     0.42532540417601994`, 
     1.3090169943749475`, -0.2628655560595668}, {-1.9919186279062242`, 
     0., -0.995959313953112}, {1.9919186279062242`, 0., 0.9959593139531121}, {
     0.6155367074350508, -1.894427190999916, 0.9959593139531121}, {
     4.4408920985006264`*^-17, 0., 2.2270327288232132`}, {0.6155367074350508, 
     1.894427190999916, 0.9959593139531121}, {1.611496021388163, 
     1.170820393249937, -0.995959313953112}, {
     1.611496021388163, -1.170820393249937, -0.995959313953112}, \
{-0.6155367074350506, 1.894427190999916, -0.995959313953112}, {0., 
     0., -2.2270327288232132`}, {-0.6155367074350506, -1.894427190999916, \
-0.995959313953112}, {-1.6114960213881628`, -1.170820393249937, 
     0.9959593139531121}, {-1.6114960213881628`, 1.170820393249937, 
     0.9959593139531121}}], 
   Polygon3DBox[{{21, 15, 10}, {21, 10, 9}, {21, 9, 14}, {21, 14, 1}, {21, 1, 
    15}, {22, 2, 6}, {22, 6, 12}, {22, 12, 11}, {22, 11, 5}, {22, 5, 2}, {23, 
    5, 11}, {23, 11, 7}, {23, 7, 3}, {23, 3, 19}, {23, 19, 5}, {24, 11, 12}, {
    24, 12, 8}, {24, 8, 16}, {24, 16, 7}, {24, 7, 11}, {25, 12, 6}, {25, 6, 
    20}, {25, 20, 4}, {25, 4, 8}, {25, 8, 12}, {26, 6, 2}, {26, 2, 13}, {26, 
    13, 18}, {26, 18, 20}, {26, 20, 6}, {27, 2, 5}, {27, 5, 19}, {27, 19, 
    17}, {27, 17, 13}, {27, 13, 2}, {28, 4, 20}, {28, 20, 18}, {28, 18, 10}, {
    28, 10, 15}, {28, 15, 4}, {29, 18, 13}, {29, 13, 17}, {29, 17, 9}, {29, 9,
     10}, {29, 10, 18}, {30, 17, 19}, {30, 19, 3}, {30, 3, 14}, {30, 14, 9}, {
    30, 9, 17}, {31, 3, 7}, {31, 7, 16}, {31, 16, 1}, {31, 1, 14}, {31, 14, 
    3}, {32, 16, 8}, {32, 8, 4}, {32, 4, 15}, {32, 15, 1}, {32, 1, 
    16}}]]]], "Output",
 CellChangeTimes->{{3.4994758443967514`*^9, 3.4994758539367647`*^9}, 
   3.4994758841368065`*^9, 3.4994761652172003`*^9, 3.499832705140625*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stellate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Dodecahedron\>\"", ",", " ", "\"\<NetImage\>\""}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.499476182047224*^9, 3.4994762110972643`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[GrayLevel[0]], FaceForm[RGBColor[1, 1, 0.85]], 
   GraphicsComplexBox[
    NCache[{{Rational[1, 2] (2 + 5^Rational[1, 2]), 0}, {
      Rational[5, 2] + 5^Rational[1, 2], 0}, {
      Rational[7, 2] + 5^Rational[1, 2], 0}, {
      Rational[3, 2] (2 + 5^Rational[1, 2]), 0}, {
      4 + Rational[3, 2] 5^Rational[1, 2], 0}, {
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
       Rational[1, 4] (10 - 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
       Rational[1, 4] (10 - 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (7 + 3 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (11 + 3 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (13 + 5 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (15 + 7 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      0, Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 2] (1 + 5^Rational[1, 2]), 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 2] (3 + 5^Rational[1, 2]), 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      2 + 5^Rational[1, 2], 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      3 + 5^Rational[1, 2], 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 2] (7 + 3 5^Rational[1, 2]), 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[3, 2] (3 + 5^Rational[1, 2]), 
       Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (-1 + 5^Rational[1, 2]), 
       Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (3 + 5^Rational[1, 2]), 
       Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (5 + 3 5^Rational[1, 2]), 
       Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[3, 4] (3 + 5^Rational[1, 2]), 
       Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (11 + 5 5^Rational[1, 2]), (Rational[25, 8] + 
        Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[5, 4] (3 + 5^Rational[1, 2]), (Rational[25, 8] + 
        Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (17 + 7 5^Rational[1, 2]), 
       Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 2], (5 + 2 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 2] (2 + 5^Rational[1, 2]), (5 + 2 5^Rational[1, 2])^
       Rational[1, 2]}, {
      Rational[3, 2] + 5^Rational[1, 2], (5 + 2 5^Rational[1, 2])^
       Rational[1, 2]}, {
      Rational[5, 2] + 5^Rational[1, 2], (5 + 2 5^Rational[1, 2])^
       Rational[1, 2]}, {
      4 + Rational[3, 2] 5^Rational[1, 2], (5 + 2 5^Rational[1, 2])^
       Rational[1, 2]}, {
      3 + 5^Rational[1, 2], (Rational[25, 4] + 
        Rational[5, 2] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 2] (7 + 3 5^Rational[1, 2]), (Rational[25, 4] + 
        Rational[5, 2] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[65, 8] + 
        Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (5 + 5^Rational[1, 2]), (Rational[65, 8] + 
        Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[3, 4] (1 + 5^Rational[1, 2]), (Rational[65, 8] + 
        Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (7 + 3 5^Rational[1, 2]), (Rational[65, 8] + 
        Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[1, 4] (13 + 5 5^Rational[1, 2]), (Rational[65, 8] + 
        Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      Rational[2, 5] (3 + 5^Rational[1, 2] + 
        Rational[5, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 2] (7 + 3 5^Rational[1, 2]) + 
        Rational[1, 4] (11 + 5 5^Rational[1, 2]) + 
        Rational[1, 4] (13 + 5 5^Rational[1, 2])), 
       Rational[
        2, 5] ((Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2] + 
        2 (Rational[25, 8] + Rational[11, 8] 5^Rational[1, 2])^
          Rational[1, 2] + (5 + 2 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (3 + 5^Rational[1, 2] + 
        Rational[5, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 2] (7 + 3 5^Rational[1, 2]) + 
        Rational[1, 4] (11 + 5 5^Rational[1, 2]) + 
        Rational[1, 4] (13 + 5 5^Rational[1, 2])), 
       Rational[2, 5] (
        2 (Rational[25, 8] + Rational[11, 8] 5^Rational[1, 2])^Rational[1, 2] + 
        2 (Rational[25, 4] + Rational[5, 2] 5^Rational[1, 2])^
          Rational[1, 2] + (Rational[65, 8] + 
          Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (4 + Rational[3, 2] 5^Rational[1, 2] + 
        Rational[11, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 2] (7 + 3 5^Rational[1, 2]) + 
        Rational[1, 4] (17 + 7 5^Rational[1, 2])), 
       Rational[
        2, 5] ((Rational[25, 8] + Rational[11, 8] 5^Rational[1, 2])^
         Rational[1, 2] + 2 (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (4 + Rational[3, 2] 5^Rational[1, 2] + 
        Rational[3, 2] (2 + 5^Rational[1, 2]) + 
        Rational[1, 2] (7 + 3 5^Rational[1, 2]) + 
        Rational[1, 4] (13 + 5 5^Rational[1, 2]) + 
        Rational[1, 4] (15 + 7 5^Rational[1, 2])), 
       Rational[2, 5] (
        2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (9 + 3 5^Rational[1, 2] + 
        Rational[1, 4] (11 + 3 5^Rational[1, 2]) + 
        Rational[1, 4] (13 + 5 5^Rational[1, 2])), 
       Rational[2, 5] (
        2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 2] (5 + 2 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (Rational[15, 2] + 3 5^Rational[1, 2] + 
        Rational[3, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 4] (11 + 5 5^Rational[1, 2])), 
       Rational[
        2, 5] ((Rational[25, 8] + Rational[11, 8] 5^Rational[1, 2])^
         Rational[1, 2] + 2 (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (2 + 5^Rational[1, 2] + 
        Rational[5, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 4] (5 + 3 5^Rational[1, 2]) + 
        Rational[1, 4] (7 + 3 5^Rational[1, 2])), 
       Rational[
        2, 5] ((Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2] + (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 2] (50 + 22 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
        Rational[1, 2] (2 + 5^Rational[1, 2]) + 
        Rational[3, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 4] (5 + 3 5^Rational[1, 2])), 
       Rational[2, 5] (
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[1, 2] + (5 + 
          2 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (Rational[1, 4] (-1 + 5^Rational[1, 2]) + 
        Rational[3, 4] (1 + 5^Rational[1, 2]) + 
        Rational[1, 4] (3 + 5^Rational[1, 2])), 
       Rational[
        2, 5] ((Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2] + (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 2] (50 + 22 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (Rational[1, 2] + Rational[1, 4] (1 + 5^Rational[1, 2]) + 
        Rational[1, 2] (2 + 5^Rational[1, 2]) + 
        Rational[1, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 4] (5 + 5^Rational[1, 2])), 
       Rational[2, 5] (2 (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
        2 (Rational[65, 8] + Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (Rational[3, 2] + 5^Rational[1, 2] + 
        Rational[3, 4] (1 + 5^Rational[1, 2]) + 
        Rational[1, 2] (2 + 5^Rational[1, 2]) + 
        Rational[1, 4] (5 + 3 5^Rational[1, 2]) + 
        Rational[1, 4] (7 + 3 5^Rational[1, 2])), 
       Rational[2, 5] (2 (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
        2 (Rational[65, 8] + Rational[29, 8] 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 4] (50 + 22 5^Rational[1, 2])^Rational[1, 2])}, {
      Rational[2, 5] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
        Rational[1, 2] (2 + 5^Rational[1, 2]) + 
        Rational[3, 4] (3 + 5^Rational[1, 2]) + 
        Rational[1, 4] (5 + 3 5^Rational[1, 2])), 
       Rational[2, 5] (2 (5 + 2 5^Rational[1, 2])^Rational[1, 2] + 
        Rational[1, 2] (50 + 22 5^Rational[1, 2])^Rational[1, 2])}}, {{
      2.118033988749895, 0}, {4.73606797749979, 0}, {5.73606797749979, 0}, {
      6.354101966249685, 0}, {7.354101966249685, 0}, {1.3090169943749475`, 
      0.5877852522924731}, {2.9270509831248424`, 0.5877852522924731}, {
      0.8090169943749475, 0.9510565162951535}, {3.4270509831248424`, 
      0.9510565162951535}, {4.427050983124842, 0.9510565162951535}, {
      6.045084971874737, 0.9510565162951535}, {7.663118960624632, 
      0.9510565162951535}, {0, 1.5388417685876268`}, {1.618033988749895, 
      1.5388417685876268`}, {2.618033988749895, 1.5388417685876268`}, {
      4.23606797749979, 1.5388417685876268`}, {5.23606797749979, 
      1.5388417685876268`}, {6.854101966249685, 1.5388417685876268`}, {
      7.854101966249685, 1.5388417685876268`}, {0.30901699437494745`, 
      2.48989828488278}, {1.3090169943749475`, 2.48989828488278}, {
      2.9270509831248424`, 2.48989828488278}, {3.9270509831248424`, 
      2.48989828488278}, {5.545084971874737, 2.48989828488278}, {
      6.545084971874737, 2.48989828488278}, {8.163118960624633, 
      2.48989828488278}, {0.5, 3.0776835371752536`}, {2.118033988749895, 
      3.0776835371752536`}, {3.73606797749979, 3.0776835371752536`}, {
      4.73606797749979, 3.0776835371752536`}, {7.354101966249685, 
      3.0776835371752536`}, {5.23606797749979, 3.440954801177934}, {
      6.854101966249685, 3.440954801177934}, {0.8090169943749475, 
      4.028740053470407}, {1.8090169943749475`, 4.028740053470407}, {
      2.4270509831248424`, 4.028740053470407}, {3.4270509831248424`, 
      4.028740053470407}, {6.045084971874737, 4.028740053470407}, {
      12.090169943749475`, 3.603414649294387}, {12.090169943749475`, 
      6.356178490236734}, {14.708203932499371`, 4.454065457646427}, {
      13.708203932499371`, 1.3763819204711736`}, {10.47213595499958, 
      1.3763819204711736`}, {9.47213595499958, 4.454065457646427}, {
      6.854101966249684, 3.603414649294387}, {4.23606797749979, 
      1.70130161670408}, {1.618033988749895, 3.603414649294387}, {
      2.618033988749895, 6.68109818646964}, {5.854101966249686, 
      6.68109818646964}, {4.23606797749979, 4.454065457646427}}], 
    PolygonBox[{{39, 18, 25}, {39, 25, 24}, {39, 24, 17}, {39, 17, 11}, {39, 
     11, 18}, {40, 32, 24}, {40, 24, 25}, {40, 25, 33}, {40, 33, 38}, {40, 38,
      32}, {41, 31, 25}, {41, 25, 18}, {41, 18, 19}, {41, 19, 26}, {41, 26, 
     31}, {42, 12, 18}, {42, 18, 11}, {42, 11, 4}, {42, 4, 5}, {42, 5, 12}, {
     43, 3, 11}, {43, 11, 17}, {43, 17, 10}, {43, 10, 2}, {43, 2, 3}, {44, 16,
      17}, {44, 17, 24}, {44, 24, 30}, {44, 30, 23}, {44, 23, 16}, {45, 23, 
     22}, {45, 22, 15}, {45, 15, 9}, {45, 9, 16}, {45, 16, 23}, {46, 7, 15}, {
     46, 15, 14}, {46, 14, 6}, {46, 6, 1}, {46, 1, 7}, {47, 8, 14}, {47, 14, 
     21}, {47, 21, 20}, {47, 20, 13}, {47, 13, 8}, {48, 27, 21}, {48, 21, 
     28}, {48, 28, 35}, {48, 35, 34}, {48, 34, 27}, {49, 36, 28}, {49, 28, 
     22}, {49, 22, 29}, {49, 29, 37}, {49, 37, 36}, {50, 21, 14}, {50, 14, 
     15}, {50, 15, 22}, {50, 22, 28}, {50, 28, 21}}]]}]], "Output",
 CellChangeTimes->{3.4994762129772673`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.49947597194693*^9, 3.4994759724369307`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stellate", "[", 
  RowBox[{"PolyhedronData", "[", 
   RowBox[{"\"\<Octahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.499475983646946*^9, 3.4994759869369507`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
     0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
     0, -2^Rational[-1, 2], 0}, {2^Rational[-1, 2], 0, 0}, {
     Rational[1, 3] 2^Rational[1, 2], Rational[-1, 3] 2^Rational[1, 2], 
      Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[1, 2], 
      Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[-1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[1, 2], 
      Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[-1, 3] 2^Rational[1, 2], Rational[-1, 3] 2^Rational[1, 2], 
      Rational[1, 3] 2^Rational[1, 2]}, {
     Rational[-1, 3] 2^Rational[1, 2], Rational[-1, 3] 2^Rational[1, 2], 
      Rational[-1, 3] 2^Rational[1, 2]}, {
     Rational[1, 3] 2^Rational[1, 2], Rational[-1, 3] 2^Rational[1, 2], 
      Rational[-1, 3] 2^Rational[1, 2]}, {
     Rational[-1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[1, 2], 
      Rational[-1, 3] 2^Rational[1, 2]}, {
     Rational[1, 3] 2^Rational[1, 2], Rational[1, 3] 2^Rational[1, 2], 
      Rational[-1, 3] 2^Rational[1, 2]}}, {{-0.7071067811865475, 0, 0}, {
     0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
     0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
     0.7071067811865475, 0, 0}, {0.4714045207910317, -0.4714045207910317, 
     0.4714045207910317}, {0.4714045207910317, 0.4714045207910317, 
     0.4714045207910317}, {-0.4714045207910317, 0.4714045207910317, 
     0.4714045207910317}, {-0.4714045207910317, -0.4714045207910317, 
     0.4714045207910317}, {-0.4714045207910317, -0.4714045207910317, \
-0.4714045207910317}, {
     0.4714045207910317, -0.4714045207910317, -0.4714045207910317}, \
{-0.4714045207910317, 0.4714045207910317, -0.4714045207910317}, {
     0.4714045207910317, 0.4714045207910317, -0.4714045207910317}}], 
   Polygon3DBox[{{7, 4, 5}, {7, 5, 6}, {7, 6, 4}, {8, 4, 6}, {8, 6, 2}, {8, 2,
     4}, {9, 4, 2}, {9, 2, 1}, {9, 1, 4}, {10, 4, 1}, {10, 1, 5}, {10, 5, 
    4}, {11, 5, 1}, {11, 1, 3}, {11, 3, 5}, {12, 5, 3}, {12, 3, 6}, {12, 6, 
    5}, {13, 3, 1}, {13, 1, 2}, {13, 2, 3}, {14, 6, 3}, {14, 3, 2}, {14, 2, 
    6}}]],
  AutomaticImageSize->True,
  ImageSize->{326.9673031881962, 343.3928273023242},
  ViewPoint->{0.6612848125287845, -3.1770777972982374`, 0.9585817996568405},
  ViewVertical->{-0.044903929915922014`, -0.35739047095044096`, 
   0.932874958583372}]], "Output",
 CellChangeTimes->{3.4994759889969535`*^9, 3.4994762386973033`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stellate", "[", 
  RowBox[{
   RowBox[{"PolyhedronData", "[", 
    RowBox[{"\"\<Octahedron\>\"", ",", " ", "\"\<Image\>\""}], "]"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.499476068427065*^9, 3.4994760853670883`*^9}, {
  3.4994761161671314`*^9, 3.4994761288171496`*^9}, {3.499476261187335*^9, 
  3.499476288727373*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
     0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
     0, -2^Rational[-1, 2], 0}, {2^Rational[-1, 2], 0, 0}, {
     Rational[1, 6] 2^Rational[-1, 2], Rational[-1, 6] 2^Rational[-1, 2], 
      Rational[1, 6] 2^Rational[-1, 2]}, {
     Rational[1, 6] 2^Rational[-1, 2], Rational[1, 6] 2^Rational[-1, 2], 
      Rational[1, 6] 2^Rational[-1, 2]}, {
     Rational[-1, 6] 2^Rational[-1, 2], Rational[1, 6] 2^Rational[-1, 2], 
      Rational[1, 6] 2^Rational[-1, 2]}, {
     Rational[-1, 6] 2^Rational[-1, 2], Rational[-1, 6] 2^Rational[-1, 2], 
      Rational[1, 6] 2^Rational[-1, 2]}, {
     Rational[-1, 6] 2^Rational[-1, 2], Rational[-1, 6] 2^Rational[-1, 2], 
      Rational[-1, 6] 2^Rational[-1, 2]}, {
     Rational[1, 6] 2^Rational[-1, 2], Rational[-1, 6] 2^Rational[-1, 2], 
      Rational[-1, 6] 2^Rational[-1, 2]}, {
     Rational[-1, 6] 2^Rational[-1, 2], Rational[1, 6] 2^Rational[-1, 2], 
      Rational[-1, 6] 2^Rational[-1, 2]}, {
     Rational[1, 6] 2^Rational[-1, 2], Rational[1, 6] 2^Rational[-1, 2], 
      Rational[-1, 6] 2^Rational[-1, 2]}}, {{-0.7071067811865475, 0, 0}, {
     0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
     0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
     0.7071067811865475, 0, 0}, {0.1178511301977579, -0.1178511301977579, 
     0.1178511301977579}, {0.1178511301977579, 0.1178511301977579, 
     0.1178511301977579}, {-0.1178511301977579, 0.1178511301977579, 
     0.1178511301977579}, {-0.1178511301977579, -0.1178511301977579, 
     0.1178511301977579}, {-0.1178511301977579, -0.1178511301977579, \
-0.1178511301977579}, {
     0.1178511301977579, -0.1178511301977579, -0.1178511301977579}, \
{-0.1178511301977579, 0.1178511301977579, -0.1178511301977579}, {
     0.1178511301977579, 0.1178511301977579, -0.1178511301977579}}], 
   Polygon3DBox[{{7, 4, 5}, {7, 5, 6}, {7, 6, 4}, {8, 4, 6}, {8, 6, 2}, {8, 2,
     4}, {9, 4, 2}, {9, 2, 1}, {9, 1, 4}, {10, 4, 1}, {10, 1, 5}, {10, 5, 
    4}, {11, 5, 1}, {11, 1, 3}, {11, 3, 5}, {12, 5, 3}, {12, 3, 6}, {12, 6, 
    5}, {13, 3, 1}, {13, 1, 2}, {13, 2, 3}, {14, 6, 3}, {14, 3, 2}, {14, 2, 
    6}}]]]], "Output",
 CellChangeTimes->{{3.49947607212707*^9, 3.4994760874570913`*^9}, {
   3.4994761184371347`*^9, 3.4994761294671507`*^9}, {3.4994762634973383`*^9, 
   3.499476289257374*^9}, 3.49983267765625*^9, 3.4998327094375*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Animate[Show[Stellate[PolyhedronData[\"Hexahedron\", \"Image\"], k],
               Boxed->False,PlotRange->All],{k,0.2,7,0.1}]\
\>", "Input",
 PageWidth->Infinity,
 CellChangeTimes->{{3.4994763336974363`*^9, 3.499476344087451*^9}, {
  3.499476474137633*^9, 3.499476476837637*^9}, {3.4994765075776796`*^9, 
  3.499476541097727*^9}, {3.4994766175078335`*^9, 3.499476677527918*^9}},
 ImageRegion->{{0, 1}, {0, 1}},
 FontFamily->"Courier New",
 Background->GrayLevel[1]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`k$$ = 0.6000000000000001, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`k$$], 0.2, 7, 0.1}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`k$11229$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`k$$ = 0.2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`k$$, $CellContext`k$11229$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        PolyhedronOperations`Stellate[
         PolyhedronData["Hexahedron", "Image"], $CellContext`k$$], Boxed -> 
        False, PlotRange -> All], 
      "Specifications" :> {{$CellContext`k$$, 0.2, 7, 0.1, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{407., {230., 235.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.4994764779676385`*^9, 3.499476513437688*^9, {3.4994765440577307`*^9, 
   3.4994765684877653`*^9}, {3.4994766204278374`*^9, 
   3.4994766889479337`*^9}, {3.49983261425*^9, 3.499832643109375*^9}, 
   3.499832712234375*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{901, 546},
WindowMargins->{{19, Automatic}, {Automatic, 30}},
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (2008\:5e7412\:670810\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 224, 5, 81, "Title"],
Cell[CellGroupData[{
Cell[816, 31, 94, 1, 71, "Section"],
Cell[913, 34, 96, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[1034, 39, 228, 6, 48, "Input"],
Cell[1265, 47, 484, 10, 263, "Output"]
}, Open  ]],
Cell[1764, 60, 90, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[1879, 66, 686, 16, 150, "Input"],
Cell[2568, 84, 683, 14, 454, "Output"]
}, Open  ]],
Cell[3266, 101, 115, 2, 29, "Text"],
Cell[CellGroupData[{
Cell[3406, 107, 828, 19, 218, "Input"],
Cell[4237, 128, 1552, 33, 414, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[5838, 167, 206, 3, 41, "Section"],
Cell[6047, 172, 96, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[6168, 177, 219, 5, 36, "Subsection"],
Cell[CellGroupData[{
Cell[6412, 186, 276, 6, 31, "Input"],
Cell[6691, 194, 1007, 20, 408, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7747, 220, 223, 5, 36, "Subsection"],
Cell[CellGroupData[{
Cell[7995, 229, 224, 5, 31, "Input"],
Cell[8222, 236, 877, 16, 406, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9148, 258, 219, 5, 36, "Subsection"],
Cell[CellGroupData[{
Cell[9392, 267, 275, 6, 31, "Input"],
Cell[9670, 275, 608, 12, 406, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10327, 293, 171, 4, 36, "Subsection"],
Cell[CellGroupData[{
Cell[10523, 301, 279, 6, 31, "Input"],
Cell[10805, 309, 4470, 78, 376, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15324, 393, 175, 4, 36, "Subsection"],
Cell[CellGroupData[{
Cell[15524, 401, 278, 6, 31, "Input"],
Cell[15805, 409, 3030, 53, 429, "Output"]
}, Open  ]],
Cell[18850, 465, 94, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[18969, 470, 210, 4, 31, "Input"],
Cell[19182, 476, 5394, 214, 309, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24613, 695, 201, 4, 31, "Input"],
Cell[24817, 701, 1858, 31, 193, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26736, 739, 308, 4, 41, "Section"],
Cell[27047, 745, 96, 1, 31, "Input"],
Cell[27146, 748, 1178, 21, 112, "Input"],
Cell[28327, 771, 86, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[28438, 776, 454, 8, 31, "Input"],
Cell[28895, 786, 4345, 77, 414, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33277, 868, 322, 7, 31, "Input"],
Cell[33602, 877, 2642, 49, 358, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36281, 931, 170, 4, 31, "Input"],
Cell[36454, 937, 48578, 825, 389, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85069, 1767, 337, 8, 31, "Input"],
Cell[85409, 1777, 47074, 820, 389, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[132520, 2602, 338, 8, 31, "Input"],
Cell[132861, 2612, 48931, 828, 390, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181829, 3445, 340, 8, 72, "Input"],
Cell[182172, 3455, 2434, 43, 406, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[184643, 3503, 324, 7, 31, "Input"],
Cell[184970, 3512, 4063, 66, 406, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189070, 3583, 362, 9, 52, "Input"],
Cell[189435, 3594, 7641, 165, 406, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197113, 3764, 281, 6, 31, "Input"],
Cell[197397, 3772, 25868, 442, 391, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[223302, 4219, 369, 9, 51, "Input"],
Cell[223674, 4230, 42283, 764, 383, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[266006, 5000, 97, 1, 71, "Section"],
Cell[266106, 5003, 91, 1, 31, "Input"],
Cell[266200, 5006, 1023, 12, 132, "Input"],
Cell[267226, 5020, 94, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[267345, 5025, 165, 4, 31, "Input"],
Cell[267513, 5031, 12311, 212, 429, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[279861, 5248, 236, 5, 31, "Input"],
Cell[280100, 5255, 12247, 208, 186, "Output"]
}, Open  ]],
Cell[292362, 5466, 93, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[292480, 5471, 231, 5, 31, "Input"],
Cell[292714, 5478, 2552, 43, 358, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[295303, 5526, 379, 8, 31, "Input"],
Cell[295685, 5536, 2476, 40, 406, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[298198, 5581, 477, 10, 48, "Input"],
Cell[298678, 5593, 2112, 44, 482, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
